/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */



// ----------------------------------------------------------------
// Sample captured: 2015-10-03 09:06:23 local
AccelRawData *activity_sample_walk_200_pbl_25532_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25532_10
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 104, 208, -984},
    { 120, 184, -968},
    { 144, 176, -1016},
    { 128, 144, -1008},
    { 128, 104, -1000},
    { 144, 144, -1064},
    { 112, 112, -1040},
    { 136, 120, -1056},
    { 96, 136, -1032},
    { -8, 64, -1000},
    { 96, 136, -1032},
    { 16, 120, -1008},
    { -40, 88, -992},
    { -24, 136, -1024},
    { -16, 176, -1016},
    { 72, 0, -928},
    { 48, 208, -1016},
    { 40, 168, -1032},
    { 48, 128, -1032},
    { 32, 96, -1024},
    { 48, 80, -1008},
    { 40, 64, -1016},
    { 24, 72, -1008},
    { 48, 56, -1016},
    { 48, 48, -1024},
    // 1 seconds
    { 56, 64, -1024},
    { 72, 56, -1024},
    { 80, 56, -1024},
    { 56, 48, -1024},
    { 80, 56, -1000},
    { 88, 40, -1000},
    { 72, 56, -1024},
    { 72, 136, -968},
    { 96, -32, -1024},
    { 184, -48, -1080},
    { 56, -16, -1048},
    { -368, 208, -1056},
    { 1224, 8, -1256},
    { 144, 24, -968},
    { 96, 96, -968},
    { 48, 88, -880},
    { 24, 256, -864},
    { 0, 368, -816},
    { 0, 408, -824},
    { -24, 456, -912},
    { 48, 328, -976},
    { -40, 400, -832},
    { -88, 528, -936},
    { 64, 424, -944},
    { 88, 408, -648},
    // 2 seconds
    { 184, 656, -616},
    { 88, 560, -464},
    { 144, 736, -400},
    { 184, 704, -368},
    { 48, 880, -432},
    { 88, 1016, -440},
    { 104, 1144, -376},
    { 160, 1352, -368},
    { 208, 1240, -312},
    { 224, 1160, -296},
    { 160, 944, -272},
    { 136, 824, -256},
    { 152, 792, -224},
    { 176, 648, -136},
    { 248, 616, -88},
    { 496, 632, -176},
    { 520, 496, -216},
    { 760, 392, -136},
    { 1096, 376, 0},
    { 1352, 360, 216},
    { 2072, 472, 288},
    { 848, 824, 168},
    { 816, 360, 240},
    { 1000, 208, 384},
    { 888, 336, 472},
    // 3 seconds
    { 768, 280, 136},
    { 752, 488, 72},
    { 656, 224, 184},
    { 672, 304, 304},
    { 736, 384, 312},
    { 632, 504, 208},
    { 856, 632, 240},
    { 1168, 656, 280},
    { 1408, 512, 360},
    { 1632, 656, 320},
    { 1296, 688, 320},
    { 616, 552, 152},
    { 816, 400, 184},
    { 1048, 216, 328},
    { 1064, 208, 416},
    { 888, 256, 256},
    { 816, 224, 152},
    { 712, 208, 144},
    { 656, 208, 88},
    { 664, 160, 24},
    { 720, 88, -16},
    { 952, 192, -152},
    { 1120, 112, -168},
    { 1584, -208, 120},
    { 1648, 40, 72},
    // 4 seconds
    { 1232, 352, -176},
    { 960, 272, -144},
    { 880, 160, 96},
    { 920, 104, 232},
    { 904, 136, 256},
    { 1008, 216, 304},
    { 968, 352, 256},
    { 880, 456, 152},
    { 896, 584, 80},
    { 936, 552, 48},
    { 1184, 656, -40},
    { 1504, 552, 24},
    { 1784, 552, 112},
    { 1272, 488, 16},
    { 1040, 376, -8},
    { 1296, 304, 16},
    { 1376, 8, 176},
    { 1336, 168, 328},
    { 1184, 168, 184},
    { 1024, 80, 168},
    { 888, 56, 168},
    { 744, 56, 104},
    { 608, 8, 48},
    { 504, -40, 32},
    { 608, -32, -48},
    // 5 seconds
    { 944, 128, -144},
    { 1424, 8, 32},
    { 1704, -16, 288},
    { 1400, 496, -72},
    { 1344, 544, -136},
    { 1296, 464, 80},
    { 1096, 408, 176},
    { 1016, 264, 304},
    { 984, 336, 248},
    { 872, 368, 184},
    { 752, 432, 56},
    { 744, 424, 48},
    { 824, 552, 0},
    { 1168, 640, -24},
    { 1248, 520, 104},
    { 1760, 464, 128},
    { 1624, 496, 184},
    { 872, 392, 96},
    { 1120, 288, 16},
    { 1400, 192, 144},
    { 1312, 152, 272},
    { 1096, 80, 264},
    { 960, 72, 160},
    { 816, 64, 160},
    { 768, 56, 128},
    // 6 seconds
    { 752, 40, 104},
    { 656, -8, 56},
    { 768, -8, -56},
    { 984, 64, -64},
    { 1464, -32, 16},
    { 1696, 8, 120},
    { 1208, 424, -152},
    { 1008, 432, -256},
    { 1176, 208, 24},
    { 1376, 256, 264},
    { 1144, 488, 240},
    { 968, 400, 224},
    { 832, 424, 176},
    { 752, 344, 144},
    { 760, 320, 128},
    { 816, 456, 40},
    { 1016, 480, 64},
    { 1280, 520, 96},
    { 1560, 512, 72},
    { 1616, 424, 128},
    { 1112, 408, 88},
    { 1096, 368, 64},
    { 1320, 240, 136},
    { 1408, 136, 288},
    { 1256, 144, 208},
    // 7 seconds
    { 1064, 32, 208},
    { 952, 56, 80},
    { 848, 56, 120},
    { 784, 72, 128},
    { 712, 80, -16},
    { 688, -16, -72},
    { 872, 24, -176},
    { 1360, -80, 0},
    { 1656, -64, 184},
    { 1352, 416, -240},
    { 1352, 440, -248},
    { 1304, 88, 272},
    { 1320, 264, 192},
    { 1200, 192, 424},
    { 1112, 432, 304},
    { 968, 424, 200},
    { 848, 448, 144},
    { 816, 520, 88},
    { 720, 528, 32},
    { 936, 528, 24},
    { 1224, 504, 176},
    { 1656, 584, 160},
    { 1712, 488, 168},
    { 1304, 456, 80},
    { 1472, 200, 176},
    // 8 seconds
    { 1568, 120, 256},
    { 1552, -16, 512},
    { 1520, -48, 216},
    { 1096, 152, 128},
    { 784, 224, 112},
    { 576, 192, -184},
    { 440, 112, -240},
    { 512, 16, -120},
    { 840, 184, -144},
    { 1288, 120, -152},
    { 1464, -152, 256},
    { 1552, 176, 224},
    { 1160, 416, -112},
    { 1088, 416, -88},
    { 1216, 264, 208},
    { 1400, 120, 440},
    { 1512, 288, 376},
    { 1240, 736, 72},
    { 816, 744, 8},
    { 792, 616, -64},
    { 944, 520, -80},
    { 1008, 496, -160},
    { 1208, 504, -120},
    { 1648, 528, -32},
    { 1904, 432, 144},
    // 9 seconds
    { 1424, 312, 184},
    { 1544, 280, 184},
    { 1656, 160, 168},
    { 1632, 88, 216},
    { 1320, -56, 328},
    { 1000, -40, 224},
    { 832, -40, 112},
    { 624, -56, 56},
    { 496, -40, -8},
    { 464, -64, 16},
    { 592, -48, -40},
    { 896, 64, -168},
    { 1240, -24, -16},
    { 1952, -48, 368},
    { 1928, 184, 200},
    { 1816, 344, -104},
    { 1616, 632, -72},
    { 1088, 424, 288},
    { 984, 152, 288},
    { 1008, 128, 216},
    { 928, 248, 128},
    { 808, 432, 8},
    { 792, 432, -96},
    { 808, 448, -96},
    { 1032, 360, -8},
    // 10 seconds
    { 1328, 416, -24},
    { 1872, 336, 104},
    { 1840, 208, 184},
    { 1192, 224, 184},
    { 1368, 192, 184},
    { 1424, 104, 32},
    { 1224, 72, 264},
    { 1064, 32, 216},
    { 920, 16, 208},
    { 784, 56, 96},
    { 712, 0, 152},
    { 608, -8, 128},
    { 560, -32, 88},
    { 720, -16, 8},
    { 1008, 56, -64},
    { 1672, -88, 56},
    { 1952, -48, 432},
    { 1360, 456, -184},
    { 1184, 448, -456},
    { 1144, 272, 40},
    { 1024, 144, 96},
    { 1024, 272, 120},
    { 976, 368, 176},
    { 848, 360, 160},
    { 752, 408, 32},
    // 11 seconds
    { 768, 336, 48},
    { 880, 424, -8},
    { 1128, 376, -24},
    { 1272, 344, 48},
    { 1832, 496, -8},
    { 1664, 432, 48},
    { 1048, 256, 56},
    { 1200, 208, 72},
    { 1432, 144, 176},
    { 1280, 88, 256},
    { 1104, 72, 192},
    { 960, 80, 112},
    { 848, 40, 96},
    { 744, 16, 96},
    { 624, 16, 40},
    { 552, -40, 40},
    { 688, -16, -8},
    { 1040, 128, -40},
    { 1648, -40, 80},
    { 1856, 208, 320},
    { 1264, 712, 32},
    { 944, 560, -112},
    { 1000, 304, 48},
    { 1024, 216, 272},
    { 1024, 216, 320},
    // 12 seconds
    { 992, 376, 192},
    { 848, 440, 112},
    { 752, 456, 24},
    { 784, 400, -64},
    { 856, 272, 40},
    { 1088, 360, 56},
    { 1336, 464, 104},
    { 1728, 336, 200},
    { 1824, 344, 232},
    { 1080, 304, 144},
    { 1032, 208, 16},
    { 1184, 184, 24},
    { 1168, 120, 136},
    { 984, 48, 136},
    { 856, 32, 96},
    { 760, 32, 40},
    { 672, 8, 64},
    { 632, 0, 96},
    { 616, -8, 88},
    { 736, 32, -24},
    { 1064, 120, -104},
    { 1344, -72, 8},
    { 1800, -184, 288},
    { 1592, 264, 32},
    { 1352, 592, -384},
    // 13 seconds
    { 1128, 408, -24},
    { 848, 184, 192},
    { 840, 160, 200},
    { 904, 160, 256},
    { 920, 392, 160},
    { 824, 456, 64},
    { 792, 448, 16},
    { 832, 456, -8},
    { 1152, 384, -16},
    { 1264, 296, 32},
    { 1808, 272, 112},
    { 1728, 368, 96},
    { 960, 304, 104},
    { 1544, 96, -152},
    { 1336, 192, 248},
    { 1248, 88, 160},
    { 1080, 24, 272},
    { 960, 56, 120},
    { 856, 8, 96},
    { 744, 0, 120},
    { 720, -72, 136},
    { 528, -160, 112},
    { 704, -8, -72},
    { 984, 72, -200},
    { 1600, -120, -72},
    // 14 seconds
    { 2040, -104, 184},
    { 1800, 536, -504},
    { 1504, 440, -264},
    { 1264, 264, 352},
    { 968, 352, 312},
    { 896, 136, 368},
    { 896, 168, 352},
    { 768, 352, 256},
    { 696, 392, 64},
    { 760, 448, 32},
    { 832, 496, 40},
    { 1096, 448, 24},
    { 1280, 344, 24},
    { 1800, 264, 0},
    { 1656, 304, 0},
    { 1040, 208, 72},
    { 1224, 168, 40},
    { 1264, -8, 232},
    { 1184, 112, 264},
    { 1016, 40, 232},
    { 944, 72, 104},
    { 944, 48, 128},
    { 864, 72, 80},
    { 768, 16, 64},
    { 744, -16, 0},
    // 15 seconds
    { 816, -24, -96},
    { 1040, 40, -176},
    { 1504, -336, 216},
    { 1592, -32, 328},
    { 1288, 424, -120},
    { 1216, 256, -184},
    { 1264, 200, 136},
    { 1208, 232, 216},
    { 1176, 360, 240},
    { 1048, 544, 184},
    { 888, 504, 152},
    { 816, 456, -40},
    { 832, 344, -72},
    { 896, 312, 48},
    { 1176, 304, 144},
    { 1352, 160, 384},
    { 1864, 216, 464},
    { 1224, 496, 240},
    { 1200, 320, 96},
    { 1472, 272, 64},
    { 1488, 152, 136},
    { 1344, 88, 144},
    { 1168, 72, 184},
    { 936, 40, 120},
    { 800, -24, 112},
    // 16 seconds
    { 704, -24, 80},
    { 616, -40, 24},
    { 632, -152, 64},
    { 792, -56, -24},
    { 1152, -24, 24},
    { 1728, 144, 312},
    { 1416, 504, -32},
    { 1304, 368, -152},
    { 1264, 440, 8},
    { 1064, 344, 176},
    { 976, 208, 184},
    { 1008, 304, 264},
    { 896, 304, 208},
    { 864, 312, 72},
    { 880, 416, 24},
    { 904, 448, -16},
    { 1048, 424, -56},
    { 1288, 392, -8},
    { 1880, 240, 104},
    { 1696, 352, 128},
    { 1048, 184, 104},
    { 1144, 144, 64},
    { 1440, 112, -104},
    { 1280, 64, 424},
    { 1160, 80, 184},
    // 17 seconds
    { 1008, -48, 224},
    { 896, 16, 120},
    { 848, -8, 152},
    { 720, 16, 88},
    { 664, -48, 72},
    { 656, -88, 56},
    { 984, 112, -160},
    { 1632, -192, 88},
    { 1640, 56, -24},
    { 1240, 112, -232},
    { 1224, 160, -240},
    { 1248, 240, -16},
    { 1152, 232, 136},
    { 1112, 304, 152},
    { 1024, 296, 200},
    { 904, 304, 120},
    { 800, 280, 80},
    { 832, 392, 16},
    { 864, 504, -40},
    { 1120, 504, -128},
    { 1344, 568, -48},
    { 1912, 544, 56},
    { 1600, 496, -88},
    { 1056, 368, -72},
    { 1368, 216, -16},
    // 18 seconds
    { 1576, 80, 192},
    { 1400, 56, 352},
    { 1168, 0, 280},
    { 968, 16, 144},
    { 792, 72, 40},
    { 720, 40, 32},
    { 640, -32, 40},
    { 584, -88, 56},
    { 664, -48, -72},
    { 960, 88, -176},
    { 1520, -48, -48},
    { 1856, -96, 192},
    { 1632, 304, -16},
    { 1496, 584, -280},
    { 1352, 400, 120},
    { 1176, 360, 280},
    { 1048, 184, 312},
    { 1016, 176, 256},
    { 896, 312, 216},
    { 768, 416, 8},
    { 784, 392, 16},
    { 872, 544, 24},
    { 1128, 496, 104},
    { 1296, 616, 120},
    { 1944, 576, 152},
    // 19 seconds
    { 1680, 432, 8},
    { 1176, 232, 56},
    { 1416, 256, 32},
    { 1656, 72, 240},
    { 1464, 72, 248},
    { 1224, 48, 184},
    { 1080, 8, 184},
    { 936, 16, 144},
    { 848, 0, 128},
    { 744, 32, 24},
    { 640, -88, 24},
    { 680, 0, -104},
    { 776, -56, -152},
    { 1328, -224, 112},
    { 1568, 56, 224},
    { 1424, 504, -32},
    { 1416, 560, -104},
    { 1352, 488, 72},
    { 1192, 328, 352},
    { 1200, 432, 152},
    { 1104, 528, 152},
    { 936, 544, 88},
    { 752, 488, 16},
    { 888, 504, -16},
    { 936, 488, -72},
    // 20 seconds
    { 1152, 600, -208},
    { 1360, 584, -72},
    { 1872, 624, 8},
    { 1488, 424, 88},
    { 1248, 216, 128},
    { 1664, -8, 112},
    { 1688, 128, 328},
    { 1416, 152, 176},
    { 1176, 72, 168},
    { 1048, -48, 240},
    { 944, -80, 216},
    { 784, -40, 160},
    { 640, -56, 96},
    { 552, -80, 0},
    { 640, -40, -80},
    { 928, 48, -232},
    { 1304, -152, 144},
    { 1552, 40, 184},
    { 1504, 512, -256},
    { 1584, 416, -128},
    { 1440, 304, 264},
    { 1272, 368, 272},
    { 1112, 368, 336},
    { 984, 432, 144},
    { 944, 336, 176},
    // 21 seconds
    { 904, 448, -40},
    { 752, 488, -112},
    { 984, 528, -160},
    { 1232, 520, -72},
    { 1712, 544, 40},
    { 1864, 400, 240},
    { 1216, 296, 112},
    { 1200, 280, 64},
    { 1536, 296, 144},
    { 1568, 136, 288},
    { 1288, 160, 200},
    { 1072, 56, 216},
    { 976, 40, 216},
    { 864, 40, 128},
    { 736, 96, 16},
    { 624, -8, 16},
    { 584, -56, -8},
    { 712, -8, -96},
    { 912, -72, 72},
    { 1600, -152, 424},
    { 1680, 792, 360},
    { 1384, 1168, -160},
    { 1120, 584, 40},
    { 1024, 104, 400},
    { 1056, -24, 368},
    // 22 seconds
    { 1056, 176, 328},
    { 1000, 352, 264},
    { 896, 352, 240},
    { 856, 416, 176},
    { 856, 448, 104},
    { 1000, 528, 72},
    { 1224, 584, 96},
    { 1576, 568, 208},
    { 1784, 592, 280},
    { 1072, 472, 104},
    { 1048, 376, 16},
    { 1336, 280, 48},
    { 1408, 88, 272},
    { 1248, 72, 312},
    { 1144, 64, 144},
    { 1008, 32, 128},
    { 872, 32, 120},
    { 768, 24, 112},
    { 696, -8, 72},
    { 704, -56, 40},
    { 1008, 96, -120},
    { 1184, 16, -72},
    { 1448, -200, 120},
    { 1336, 120, -216},
    { 1232, 480, -376},
    // 23 seconds
    { 1288, 528, -208},
    { 1112, 304, 112},
    { 1120, 208, 224},
    { 1056, 200, 304},
    { 968, 344, 176},
    { 808, 376, 144},
    { 792, 432, 40},
    { 896, 488, 48},
    { 1136, 512, 272},
    { 1248, 728, 264},
    { 1744, 592, 240},
    { 1680, 512, 208},
    { 1104, 400, 112},
    { 1312, 208, 88},
    { 1488, 56, 240},
    { 1296, 56, 296},
    { 1104, 16, 248},
    { 912, 56, 120},
    { 800, 32, 112},
    { 712, 8, 96},
    { 592, -40, 72},
    { 592, -88, 48},
    { 712, -72, -32},
    { 1072, 72, -120},
    { 1568, 0, 8},
    // 24 seconds
    { 1768, 48, 440},
    { 1280, 608, 32},
    { 1312, 664, -240},
    { 1216, 592, 16},
    { 1008, 432, 144},
    { 960, 88, 288},
    { 968, 184, 256},
    { 856, 368, 152},
    { 744, 448, 96},
    { 808, 488, 48},
    { 880, 432, 48},
    { 1176, 272, 192},
    { 1272, 392, 104},
    { 1720, 440, 168},
    { 1680, 616, 144},
    { 968, 352, 72},
    { 1176, 288, 184},
    { 1464, 96, 376},
    { 1304, 88, 304},
    { 1192, 56, 248},
    { 1024, -32, 280},
    { 896, 24, 160},
    { 816, 8, 136},
    { 720, -16, 120},
    { 648, -64, 64},
    // 25 seconds
    { 704, -80, -8},
    { 904, 64, -176},
    { 1400, 0, -72},
    { 1672, -160, 256},
    { 1424, 176, 56},
    { 1416, 504, -216},
    { 1416, 576, 48},
    { 1136, 512, 288},
    { 944, 336, 240},
    { 952, 176, 184},
    { 880, 232, 160},
    { 784, 336, 32},
    { 792, 336, 16},
    { 896, 392, -24},
    { 1016, 408, 8},
    { 1232, 456, -48},
    { 1360, 376, 40},
    { 1488, 416, 72},
    { 1352, 448, 56},
    { 1016, 320, 88},
    { 1232, 272, 104},
    { 1376, 128, 296},
    { 1216, 72, 336},
    { 1072, 88, 184},
    { 1000, 40, 208},
    // 26 seconds
    { 880, 40, 152},
    { 808, 40, 96},
    { 720, -8, 104},
    { 640, -16, 8},
    { 696, 16, -120},
    { 936, 40, -120},
    { 1520, -256, 216},
    { 1640, 120, 224},
    { 1288, 632, -168},
    { 1216, 552, -248},
    { 1152, 296, 160},
    { 1064, 216, 280},
    { 1016, 256, 264},
    { 952, 320, 232},
    { 840, 352, 184},
    { 752, 384, 56},
    { 808, 448, -48},
    { 888, 408, -16},
    { 1152, 464, -72},
    { 1264, 400, 168},
    { 1952, 656, 184},
    { 1392, 496, 64},
    { 1184, 296, 80},
    { 1328, 232, 128},
    { 1416, 160, 192},
    // 27 seconds
    { 1192, 96, 216},
    { 1048, 80, 152},
    { 1016, 32, 120},
    { 872, 32, 80},
    { 792, 40, 48},
    { 712, -8, 40},
    { 608, -40, -24},
    { 616, -24, -104},
    { 768, 80, -240},
    { 1368, -96, -8},
    { 1672, -16, 264},
    { 1632, 424, 48},
    { 1520, 600, -248},
    { 1120, 352, 160},
    { 968, 168, 288},
    { 1008, 72, 304},
    { 1008, 208, 192},
    { 928, 344, 120},
    { 840, 432, -24},
    { 896, 472, -32},
    { 968, 568, -40},
    { 1184, 496, 24},
    { 1232, 368, 120},
    { 1664, 400, 160},
    { 1600, 456, 112},
    // 28 seconds
    { 1080, 272, 48},
    { 1304, 208, 64},
    { 1488, 104, 216},
    { 1264, 80, 264},
    { 1064, 56, 200},
    { 984, 24, 168},
    { 896, 8, 144},
    { 776, -16, 128},
    { 648, -8, 88},
    { 608, -56, 56},
    { 776, 8, -104},
    { 1040, 96, -232},
    { 1536, -120, -48},
    { 1696, -152, 264},
    { 1456, 264, -32},
    { 1368, 384, -208},
    { 1272, 312, 168},
    { 1136, 352, 280},
    { 1040, 248, 392},
    { 960, 232, 240},
    { 888, 312, 112},
    { 824, 392, 0},
    { 856, 472, -32},
    { 904, 512, -16},
    { 1184, 504, -56},
    // 29 seconds
    { 1376, 392, 72},
    { 1840, 360, 184},
    { 1384, 408, 96},
    { 1008, 240, 88},
    { 1304, 216, 88},
    { 1432, 40, 304},
    { 1248, 64, 296},
    { 1072, 80, 160},
    { 1000, 0, 200},
    { 904, -8, 168},
    { 808, -8, 104},
    { 736, -32, 88},
    { 744, -40, -32},
    { 872, 96, -136},
    { 1400, -152, 16},
    { 1512, -104, 160},
    { 1368, 224, -136},
    { 1224, 256, -216},
    { 1192, 240, 0},
    { 1128, 192, 184},
    { 1184, 320, 200},
    { 1128, 400, 312},
    { 976, 544, 240},
    { 808, 328, 184},
    { 864, 384, 72},
    // 30 seconds
    { 920, 320, 88},
    { 1144, 448, -56},
    { 1256, 400, 48},
    { 1816, 632, 72},
    { 1464, 560, 96},
    { 960, 352, 40},
    { 1176, 264, 56},
    { 1384, 96, 200},
    { 1264, 96, 256},
    { 1160, 96, 176},
    { 1048, 40, 200},
    { 928, 16, 232},
    { 832, 16, 168},
    { 752, -16, 144},
    { 656, -24, 96},
    { 696, -40, 24},
    { 880, 112, -136},
    { 960, 160, -264},
    { 1592, -384, 176},
    { 1680, -72, 16},
    { 1360, 264, -176},
    { 1288, 296, -144},
    { 1336, 248, 160},
    { 1264, 368, 256},
    { 1088, 448, 296},
    // 31 seconds
    { 968, 512, 240},
    { 776, 440, 136},
    { 720, 416, 80},
    { 848, 408, 24},
    { 1048, 568, -32},
    { 1088, 544, 88},
    { 1760, 632, 144},
    { 1432, 440, 184},
    { 1416, 256, 160},
    { 1576, 224, 176},
    { 1568, 144, 264},
    { 1328, 56, 248},
    { 1168, 80, 136},
    { 1032, 48, 128},
    { 896, -8, 128},
    { 792, -8, 72},
    { 672, -40, 24},
    { 632, -128, 0},
    { 776, -56, -104},
    { 1032, -8, -88},
    { 1472, -40, 16},
    { 1656, 328, 136},
    { 1176, 528, -16},
    { 1128, 392, -40},
    { 1392, 152, -160},
    // 32 seconds
    { 1008, 464, 336},
    { 1000, 304, 312},
    { 1000, 424, 208},
    { 936, 432, 264},
    { 824, 472, 168},
    { 832, 512, 88},
    { 968, 464, 120},
    { 1160, 592, 24},
    { 1480, 632, 96},
    { 1816, 752, 176},
    { 1160, 488, 88},
    { 1128, 384, 40},
    { 1424, 240, 144},
    { 1448, 176, 208},
    { 1320, 56, 288},
    { 1088, -16, 272},
    { 968, -24, 224},
    { 888, 0, 200},
    { 768, 8, 144},
    { 712, -32, 120},
    { 728, -80, 80},
    { 808, 40, -112},
    { 1392, 8, -88},
    { 1192, -232, -48},
    { 1256, -48, -264},
    // 33 seconds
    { 1528, 240, -320},
    { 1456, 288, -152},
    { 1184, 176, 16},
    { 1216, 400, 40},
    { 1080, 416, 136},
    { 968, 320, 56},
    { 944, 224, 80},
    { 944, 384, -16},
    { 928, 512, -88},
    { 1064, 704, -160},
    { 1168, 592, -136},
    { 1624, 328, -40},
    { 1808, 448, 112},
    { 1072, 336, 80},
    { 1320, 408, -8},
    { 1536, 288, 48},
    { 1432, 160, 240},
    { 1184, 96, 248},
    { 1088, 72, 144},
    { 920, 72, 104},
    { 792, 32, 104},
    { 680, -16, 72},
    { 624, -56, 56},
    { 672, -96, 0},
    { 800, -8, -96},
    // 34 seconds
    { 1392, -32, -72},
    { 1640, 32, 168},
    { 1320, 352, -96},
    { 1384, 496, -416},
    { 1424, 440, -16},
    { 1176, 312, 224},
    { 1048, 336, 184},
    { 1000, 320, 216},
    { 912, 432, 128},
    { 880, 392, 128},
    { 872, 400, 64},
    { 760, 400, 56},
    { 960, 528, -40},
    { 1192, 576, 16},
    { 1872, 632, 128},
    { 1520, 464, 24},
    { 1272, 352, 24},
    { 1432, 328, 72},
    { 1512, 240, 176},
    { 1208, 136, 168},
    { 1040, 96, 168},
    { 968, 8, 200},
    { 896, -72, 256},
    { 792, -16, 176},
    { 704, -24, 120},
    // 35 seconds
    { 656, -48, 80},
    { 712, 0, -48},
    { 1024, -24, -192},
    { 1616, -216, 192},
    { 1584, 144, 40},
    { 1360, 384, -184},
    { 1336, 336, -144},
    { 1192, 240, 184},
    { 1144, 240, 288},
    { 1112, 344, 352},
    { 1016, 376, 304},
    { 872, 384, 160},
    { 768, 424, 32},
    { 880, 456, -72},
    { 992, 400, -48},
    { 1272, 408, 32},
    { 1760, 256, 296},
    { 1920, 288, 416},
    { 1008, -40, 344},
    { 1152, 152, 224},
    { 1384, 272, -120},
    { 352, -2184, -768},
    { 1024, 376, -176},
    { 1016, 80, 360},
    { 832, 96, 240},
    // 36 seconds
    { 784, 120, 72},
    { 760, 104, 72},
    { 792, -32, 192},
    { 848, -88, 176},
    { 952, 0, 48},
    { 1504, -72, 56},
    { 1776, -8, 280},
    { 1200, 392, -8},
    { 1016, 512, -336},
    { 912, 120, -16},
    { 1024, 0, 224},
    { 1024, 200, 168},
    { 944, 272, 208},
    { 848, 400, 80},
    { 800, 312, 88},
    { 872, 344, -16},
    { 864, 256, 16},
    { 1128, 296, 0},
    { 1152, 296, 144},
    { 1520, 400, 128},
    { 1840, 496, 256},
    { 1240, 576, 256},
    { 1088, 256, 16},
    { 1152, 232, 40},
    { 1160, 144, 160},
    // 37 seconds
    { 1008, 64, 200},
    { 896, 48, 96},
    { 840, -32, 152},
    { 752, 16, 56},
    { 688, 0, 40},
    { 640, -32, 40},
    { 744, -32, -16},
    { 992, 120, -8},
    { 1616, -72, 232},
    { 1760, 192, 288},
    { 1144, 616, -144},
    { 1136, 480, -168},
    { 1008, 376, 160},
    { 856, 120, 192},
    { 864, 216, 176},
    { 872, 280, 184},
    { 816, 320, 176},
    { 792, 336, 152},
    { 832, 384, 96},
    { 880, 520, 16},
    { 1136, 432, 16},
    { 1368, 344, 216},
    { 1816, 384, 392},
    { 1440, 496, 128},
    { 904, 400, 168},
    // 38 seconds
    { 1256, 208, -72},
    { 816, -696, -152},
    { 1000, -80, 328},
    { 1032, 288, 24},
    { 824, 88, 104},
    { 768, 40, 128},
    { 720, -8, 112},
    { 720, -24, 64},
    { 768, -48, 24},
    { 1000, 72, -72},
    { 1264, -48, 96},
    { 1816, -96, 296},
    { 1384, 272, 128},
    { 1064, 504, -184},
    { 1000, 368, -24},
    { 872, 32, 240},
    { 856, 424, 40},
    { 856, 168, 160},
    { 816, 240, 128},
    { 856, 360, 24},
    { 840, 376, -8},
    { 976, 480, -96},
    { 1064, 408, -72},
    { 1240, 392, -96},
    { 1528, 344, -24},
    // 39 seconds
    { 1816, 296, 40},
    { 1112, 304, 8},
    { 968, 216, 24},
    { 1104, 144, 120},
    { 1200, 120, 200},
    { 1088, 96, 280},
    { 896, 40, 240},
    { 800, 72, 128},
    { 808, 8, 184},
    { 784, 56, 88},
    { 776, 0, 56},
    { 792, -88, 56},
    { 928, 40, -136},
    { 1272, -48, -80},
    { 1632, -96, -8},
    { 1400, 280, -264},
    { 1280, 296, -208},
    { 1232, 168, 104},
    { 1024, 328, 248},
    { 896, 344, 216},
    { 912, 136, 352},
    { 888, 248, 264},
    { 848, 320, 120},
    { 792, 328, 56},
    { 824, 352, 8},
    // 40 seconds
    { 952, 360, 16},
    { 1256, 432, 64},
    { 1520, 568, 200},
    { 1688, 480, 160},
    { 1216, 536, -72},
    { 1088, 384, 8},
    { 1248, 144, 88},
    { 1336, 144, 136},
    { 1232, 80, 272},
    { 1112, 48, 256},
    { 1008, -56, 256},
    { 864, -32, 120},
    { 840, 8, 24},
    { 776, 8, 0},
    { 744, -16, -88},
    { 736, 64, -248},
    { 1112, -96, -232},
    { 1544, -280, -16},
    { 1480, 152, -288},
    { 1456, 384, -368},
    { 1328, 328, -160},
    { 1144, 152, 144},
    { 1080, 216, 192},
    { 1072, 240, 280},
    { 1016, 344, 208},
    // 41 seconds
    { 864, 352, 128},
    { 864, 400, -8},
    { 888, 360, -24},
    { 1112, 456, -112},
    { 1216, 544, -144},
    { 1576, 528, -88},
    { 1672, 552, -72},
    { 1144, 248, 112},
    { 1336, 136, 96},
    { 1464, 72, 136},
    { 1264, -264, 200},
    { 1080, 112, 144},
    { 1000, 24, 208},
    { 920, 24, 160},
    { 912, 0, 144},
    { 840, 16, 80},
    { 768, 24, 40},
    { 832, 0, -48},
    { 896, 64, -200},
    { 1240, 0, -248},
    { 1400, -240, 32},
    { 1224, 24, -40},
    { 1184, 224, -200},
    { 1288, 240, -120},
    { 1240, 192, 176},
    // 42 seconds
    { 1192, 240, 208},
    { 1184, 392, 176},
    { 1032, 464, 168},
    { 824, 440, 16},
    { 832, 432, -72},
    { 880, 384, -96},
    { 1064, 344, -80},
    { 1248, 352, -24},
    { 1384, 360, 8},
    { 1712, 488, 8},
    { 1240, 368, 112},
    { 1232, 152, 128},
    { 1432, 104, 208},
    { 1384, 112, 224},
    { 1184, 88, 184},
    { 1112, 24, 176},
    { 1024, 40, 88},
    { 936, 0, 88},
    { 856, 40, 16},
    { 728, -24, 16},
    { 696, -64, -56},
    { 776, -16, -168},
    { 1104, -24, -264},
    { 1472, -328, 128},
    { 1432, 32, 96},
    // 43 seconds
    { 1312, 256, -128},
    { 1400, 192, -40},
    { 1368, 208, 304},
    { 1232, 272, 344},
    { 1192, 328, 384},
    { 1056, 408, 264},
    { 880, 352, 168},
    { 880, 384, 80},
    { 904, 384, 16},
    { 1008, 448, -56},
    { 1200, 576, -96},
    { 1536, 632, -64},
    { 1808, 600, 32},
    { 1176, 352, 32},
    { 1208, 208, 96},
    { 1456, 96, 184},
    { 1496, 136, 208},
    { 1296, 88, 232},
    { 1136, -16, 272},
    { 1016, 0, 200},
    { 928, 24, 136},
    { 840, 24, 104},
    { 768, -24, 96},
    { 704, -88, 32},
    { 768, -8, -112},
    // 44 seconds
    { 1064, -16, -248},
    { 1336, -248, 48},
    { 1384, -48, 64},
    { 1392, 272, -176},
    { 1448, 216, -80},
    { 1384, 184, 256},
    { 1280, 344, 280},
    { 1184, 416, 352},
    { 992, 232, 240},
    { 896, 264, 80},
    { 904, 360, 72},
    { 928, 464, -16},
    { 1032, 488, -104},
    { 1256, 608, -88},
    { 1688, 600, -8},
    { 1856, 432, 128},
    { 1072, 208, 104},
    { 1152, 152, 112},
    { 1488, 56, 16},
    { 1488, -32, 304},
    { 1304, 144, 152},
    { 1104, 0, 216},
    { 944, 24, 112},
    { 888, 24, 88},
    { 776, 8, 88},
    // 45 seconds
    { 656, -56, 64},
    { 608, -152, -16},
    { 768, -16, -144},
    { 1272, -80, -120},
    { 1528, -120, 136},
    { 1432, 224, 32},
    { 1504, 328, -208},
    { 1528, 208, 120},
    { 1312, 312, 328},
    { 1136, 352, 272},
    { 1032, 264, 240},
    { 976, 320, 168},
    { 872, 384, 56},
    { 816, 328, 0},
    { 872, 408, -56},
    { 1152, 496, -96},
    { 1264, 536, -16},
    { 1736, 504, 96},
    { 1672, 440, 136},
    { 968, 248, 104},
    { 1200, 176, 128},
    { 1608, 136, 176},
    { 1400, 168, 296},
    { 1184, 64, 248},
    { 1072, 32, 192},
    // 46 seconds
    { 1000, 48, 120},
    { 960, 32, 56},
    { 808, 32, -8},
    { 672, -32, -8},
    { 576, -112, 64},
    { 720, 72, -152},
    { 1240, 184, -104},
    { 1344, 352, 96},
    { 1296, 440, 16},
    { 1232, 320, -16},
    { 1192, 224, 168},
    { 1168, 152, 280},
    { 1232, 312, 296},
    { 1184, 400, 416},
    { 984, 432, 360},
    { 840, 280, 176},
    { 896, 392, 56},
    { 872, 488, 8},
    { 1112, 472, -48},
    { 1208, 512, 24},
    { 1664, 512, 104},
    { 1640, 528, 40},
    { 1088, 344, 48},
    { 1216, 224, 112},
    { 1416, 144, 256},
    // 47 seconds
    { 1296, 104, 280},
    { 1056, 40, 248},
    { 968, 8, 216},
    { 904, -8, 192},
    { 848, -16, 168},
    { 776, -8, 128},
    { 760, -24, 56},
    { 840, 32, -72},
    { 936, -208, -152},
    { 1464, -336, 8},
    { 1584, 136, 24},
    { 1400, 432, -232},
    { 1248, 208, -144},
    { 1144, 120, 208},
    { 1128, 200, 264},
    { 1128, 320, 208},
    { 1000, 384, 160},
    { 928, 392, 112},
    { 832, 336, 64},
    { 856, 360, -40},
    { 912, 360, -16},
    { 1208, 504, -104},
    { 1408, 432, 40},
    { 1856, 504, 32},
    { 1416, 416, 0},
    // 48 seconds
    { 1168, 280, 8},
    { 1336, 168, 120},
    { 1392, 112, 184},
    { 1240, 136, 176},
    { 1088, 64, 184},
    { 1000, 16, 208},
    { 952, -16, 200},
    { 872, -24, 168},
    { 760, -16, 96},
    { 704, -72, 40},
    { 736, 16, -104},
    { 888, 96, -216},
    { 1232, -256, -16},
    { 1440, -120, 32},
    { 1392, 208, -104},
    { 1456, 272, -184},
    { 1392, 288, 104},
    { 1192, 304, 208},
    { 1136, 376, 232},
    { 1048, 240, 200},
    { 968, 248, 64},
    { 856, 320, -40},
    { 896, 472, -48},
    { 1048, 616, -16},
    { 1280, 672, 48},
    // 49 seconds
    { 1488, 560, 168},
    { 1768, 408, 208},
    { 1184, 248, 128},
    { 1064, 240, 160},
    { 1368, 336, 232},
    { 1504, 208, 256},
    { 1312, 120, 208},
    { 1088, 112, 192},
    { 960, 112, 120},
    { 920, 104, 64},
    { 808, 24, 24},
    { 752, -40, 48},
    { 688, -48, -64},
    { 752, -16, -152},
    { 1176, -112, -104},
    { 1584, -32, 64},
    { 1472, 280, 48},
    { 1352, 512, -256},
    { 1360, 272, 32},
    { 1240, 136, 400},
    { 1248, 312, 272},
    { 1176, 336, 360},
    { 992, 392, 168},
    { 896, 344, 112},
    { 936, 472, -8},
    // 50 seconds
    { 952, 520, -24},
    { 1032, 504, -24},
    { 1160, 408, 0},
    { 1496, 424, 88},
    { 1600, 504, 112},
    { 1080, 360, 128},
    { 1128, 232, 128},
    { 1336, 144, 232},
    { 1368, 96, 256},
    { 1240, 88, 232},
    { 1096, 8, 240},
    { 1008, -8, 216},
    { 960, -8, 184},
    { 896, 48, 144},
    { 864, -16, 104},
    { 824, -136, 72},
    { 808, -80, -104},
    { 1192, -184, -104},
    { 1392, -136, 88},
    { 1392, 184, -8},
    { 1288, 448, -384},
    { 1192, 152, -104},
    { 1304, 304, 64},
    { 848, 1512, 280},
    { 1104, 440, 88},
    // 51 seconds
    { 784, 192, 88},
    { 792, 288, 136},
    { 792, 336, 184},
    { 848, 408, 88},
    { 1048, 424, 16},
    { 1136, 496, -8},
    { 1528, 392, 56},
    { 1688, 440, 80},
    { 1064, 344, 104},
    { 1152, 208, 96},
    { 1304, 88, 128},
    { 1328, -368, 168},
    { 1048, 256, 96},
    { 1032, -56, 144},
    { 936, 80, 56},
    { 888, 16, 104},
    { 800, 32, 16},
    { 768, -16, 0},
    { 760, -48, -80},
    { 912, 64, -208},
    { 1328, -128, -56},
    { 1712, -168, 272},
    { 1536, 336, 80},
    { 1232, 472, -160},
    { 1088, 256, 40},
    // 52 seconds
    { 928, 128, 320},
    { 912, 128, 312},
    { 968, 152, 304},
    { 912, 320, 208},
    { 816, 368, 104},
    { 856, 464, 16},
    { 848, 512, -48},
    { 1088, 488, -48},
    { 1240, 392, 8},
    { 1776, 384, 80},
    { 1640, 464, 96},
    { 1016, 304, 56},
    { 1160, 192, 104},
    { 1400, 88, 208},
    { 1240, 104, 200},
    { 1080, 64, 176},
    { 968, 56, 128},
    { 856, 32, 136},
    { 832, 8, 136},
    { 784, 0, 88},
    { 744, -24, 48},
    { 848, 72, -120},
    { 944, 24, -192},
    { 1400, -240, 40},
    { 1568, -104, 128},
    // 53 seconds
    { 1144, 280, -136},
    { 1168, 304, -232},
    { 1256, 168, 64},
    { 1184, 216, 240},
    { 1128, 312, 224},
    { 1032, 408, 184},
    { 904, 320, 128},
    { 808, 312, -24},
    { 880, 384, -64},
    { 928, 432, -48},
    { 1160, 440, -120},
    { 1288, 448, -8},
    { 1960, 520, 96},
    { 1664, 440, 192},
    { 928, 192, 80},
    { 1192, 144, 128},
    { 1448, 56, 248},
    { 1328, 80, 224},
    { 1144, 80, 216},
    { 1016, 32, 176},
    { 904, 32, 112},
    { 800, 16, 72},
    { 704, 8, 32},
    { 616, -64, 16},
    { 616, -96, -72},
    // 54 seconds
    { 856, 88, -200},
    { 1208, -48, -112},
    { 1512, -200, 240},
    { 1664, 88, 176},
    { 1456, 408, -136},
    { 1128, 344, 0},
    { 1032, 176, 224},
    { 1184, 168, 280},
    { 1168, 208, 304},
    { 1056, 312, 280},
    { 912, 464, 104},
    { 864, 448, 40},
    { 856, 504, -8},
    { 1072, 504, -24},
    { 1136, 480, 40},
    { 1576, 488, 80},
    { 1464, 504, 128},
    { 1304, 232, 264},
    { 1392, 176, 240},
    { 1440, 144, 224},
    { 1256, 184, 168},
    { 1136, 152, 136},
    { 1080, 64, 176},
    { 1008, -8, 176},
    { 912, -48, 152},
    // 55 seconds
    { 776, -40, 72},
    { 736, -64, 24},
    { 784, 16, -64},
    { 1112, -96, -48},
    { 1384, -136, 168},
    { 1184, 96, 104},
    { 1160, 248, -96},
    { 1296, 176, -16},
    { 1320, 152, 296},
    { 1320, 192, 272},
    { 1296, 584, 168},
    { 1072, 584, 144},
    { 880, 400, 64},
    { 872, 376, -16},
    { 928, 344, -24},
    { 1008, 432, -72},
    { 1128, 544, -56},
    { 1640, 624, 112},
    { 1728, 616, 216},
    { 1176, 160, 192},
    { 1232, 120, 128},
    { 1392, 112, 152},
    { 1320, 96, 216},
    { 1136, 88, 240},
    { 984, 32, 208},
    // 56 seconds
    { 936, 0, 200},
    { 880, 24, 160},
    { 816, 72, 96},
    { 784, 40, 48},
    { 880, 8, -40},
    { 984, -16, -104},
    { 1488, -296, 40},
    { 1440, -40, 32},
    { 1032, 248, -160},
    { 992, 200, -240},
    { 1208, 128, 0},
    { 1312, 128, 184},
    { 1456, 296, 224},
    { 1264, 624, 144},
    { 944, 680, 192},
    { 736, 360, 8},
    { 872, 320, 64},
    { 896, 304, 0},
    { 1112, 352, -48},
    { 1360, 496, 0},
    { 1800, 496, 160},
    { 1760, 544, 144},
    { 1152, 152, 104},
    { 1200, 120, 152},
    { 1448, 0, 248},
    // 57 seconds
    { 1400, 88, 176},
    { 1136, 72, 200},
    { 1000, -16, 168},
    { 896, -32, 136},
    { 792, -24, 160},
    { 728, -8, 136},
    { 648, -48, 48},
    { 736, 32, -144},
    { 1040, 8, -216},
    { 1472, -280, 104},
    { 1496, -120, 72},
    { 1184, 104, 32},
    { 1320, 312, -72},
    { 1448, 376, 64},
    { 1392, 400, 144},
    { 1264, 480, 256},
    { 976, 536, 256},
    { 760, 248, 144},
    { 800, 304, 80},
    { 864, 520, -88},
    { 888, 488, -128},
    { 1176, 576, -128},
    { 1368, 480, 88},
    { 1840, 576, 160},
    { 1312, 352, 96},
    // 58 seconds
    { 1104, 304, 80},
    { 1312, 224, 112},
    { 1400, 120, 152},
    { 1240, 136, 176},
    { 1104, 96, 160},
    { 1080, 24, 144},
    { 976, -32, 120},
    { 840, -24, 112},
    { 712, -16, 80},
    { 624, -48, 32},
    { 736, 24, -120},
    { 1032, -72, -160},
    { 1640, -312, 224},
    { 1576, 96, 184},
    { 1256, 432, -168},
    { 1248, 240, -136},
    { 1296, 304, 176},
    { 1256, 240, 224},
    { 1168, 320, 304},
    { 1024, 432, 168},
    { 848, 328, 80},
    { 888, 408, -32},
    { 928, 368, -24},
    { 960, 472, -88},
    { 1192, 528, -96},
    // 59 seconds
    { 1688, 656, 8},
    { 1944, 608, 88},
    { 1232, 328, 0},
    { 1184, 280, 24},
    { 1440, 144, 96},
    { 1448, 80, 120},
    { 1288, 88, 136},
    { 1112, 32, 160},
    { 984, 0, 200},
    { 904, -24, 184},
    { 800, 0, 120},
    { 712, -8, 72},
    { 720, -56, -16},
    { 768, 16, -200},
    { 1112, -144, -152},
    { 1440, -344, 152},
    { 1392, 144, -8},
    { 1360, 432, -264},
    { 1488, 440, -192},
    { 1400, 312, 208},
    { 1288, 408, 240},
    { 1168, 488, 280},
    { 944, 328, 184},
    { 856, 272, 160},
    { 856, 304, 128},
    // 60 seconds
    // elapsed: 1 minutes
    { 848, 368, 72},
    { 1064, 480, -48},
    { 1248, 560, 0},
    { 1744, 752, 120},
    { 1600, 520, 80},
    { 896, 392, 16},
    { 1104, 344, 48},
    { 1448, 208, 208},
    { 1400, 64, 280},
    { 1176, 56, 240},
    { 1008, -16, 240},
    { 880, 0, 216},
    { 824, 24, 144},
    { 784, 8, 128},
    { 776, -32, 96},
    { 856, -24, -48},
    { 960, 40, -128},
    { 1376, -112, -64},
    { 1536, -136, 40},
    { 1216, 208, -216},
    { 1232, 336, -312},
    { 1264, 192, 88},
    { 1160, 264, 256},
    { 1136, 352, 224},
    { 1016, 376, 232},
    // 61 seconds
    { 872, 344, 160},
    { 816, 280, 80},
    { 832, 320, 0},
    { 864, 352, -32},
    { 1096, 424, -88},
    { 1120, 472, -80},
    { 1688, 464, 80},
    { 1688, 568, 168},
    { 960, 272, 104},
    { 1200, 208, 112},
    { 1416, 192, 208},
    { 1256, 128, 256},
    { 1096, 32, 240},
    { 1000, 48, 168},
    { 968, 8, 160},
    { 936, -8, 152},
    { 816, 0, 120},
    { 712, -24, 48},
    { 720, 8, -120},
    { 928, 24, -248},
    { 1536, -272, -16},
    { 1464, -16, 32},
    { 1224, 352, -240},
    { 1216, 376, -232},
    { 1160, 320, 216},
    // 62 seconds
    { 1096, 192, 216},
    { 1104, 296, 224},
    { 1088, 440, 200},
    { 896, 592, 120},
    { 760, 544, 64},
    { 880, 528, -8},
    { 880, 504, -48},
    { 1072, 568, -88},
    { 1448, 528, -24},
    { 1776, 488, 176},
    { 1216, 448, 88},
    { 1080, 360, -24},
    { 1248, 392, 88},
    { 1416, 232, 168},
    { 1208, 72, 264},
    { 1024, 88, 144},
    { 1008, 64, 152},
    { 936, 32, 152},
    { 848, 24, 128},
    { 736, -56, 112},
    { 648, -192, 24},
    { 800, 144, -296},
    { 1264, 16, -248},
    { 1672, -272, 200},
    { 1392, 256, -96},
    // 63 seconds
    { 1392, 528, -376},
    { 1312, 272, -24},
    { 1136, 152, 264},
    { 1104, 200, 264},
    { 1056, 232, 288},
    { 1016, 400, 136},
    { 888, 432, 104},
    { 824, 360, 40},
    { 848, 280, 40},
    { 1080, 416, -16},
    { 1176, 552, -56},
    { 1608, 656, -24},
    { 1600, 488, 56},
    { 1056, 336, 8},
    { 1328, 328, -24},
    { 1504, 224, 64},
    { 1432, 128, 232},
    { 1240, 72, 208},
    { 1112, 48, 192},
    { 984, 24, 184},
    { 912, 8, 168},
    { 832, -8, 160},
    { 792, -40, 120},
    { 792, -104, 72},
    { 896, 0, -72},
    // 64 seconds
    { 1368, -272, 120},
    { 1416, -160, 240},
    { 1368, 296, -104},
    { 1168, 192, -168},
    { 1256, 248, 32},
    { 1328, 208, 208},
    { 1304, 416, 192},
    { 1208, 568, 184},
    { 936, 576, 112},
    { 728, 336, 40},
    { 824, 320, 0},
    { 936, 232, -8},
    { 1064, 376, -112},
    { 1192, 440, -32},
    { 1704, 480, 88},
    { 1680, 592, 232},
    { 1056, 344, 56},
    { 1216, 296, 24},
    { 1488, 224, 144},
    { 1520, 56, 208},
    { 1216, 32, 248},
    { 1088, 16, 200},
    { 1000, -32, 232},
    { 896, -40, 232},
    { 816, -24, 168},
    // 65 seconds
    { 720, -48, 144},
    { 728, -24, -16},
    { 928, 264, -272},
    { 1112, -152, -296},
    { 1376, -568, -112},
    { 1384, -40, -248},
    { 1240, 248, -328},
    { 1376, 168, -136},
    { 1288, 104, 192},
    { 1264, 144, 280},
    { 1216, 312, 280},
    { 1008, 408, 232},
    { 864, 320, 88},
    { 848, 280, 24},
    { 912, 336, 48},
    { 1112, 488, 56},
    { 1192, 688, 24},
    { 1632, 608, 104},
    { 1856, 504, 216},
    { 1152, 216, 168},
    { 1192, 112, 120},
    { 1520, 88, 272},
    { 1504, 80, 304},
    { 1296, 48, 256},
    { 1136, 0, 208},
    // 66 seconds
    { 1016, -32, 208},
    { 912, -24, 160},
    { 800, -8, 120},
    { 696, -32, 56},
    { 672, -80, -40},
    { 760, -32, -136},
    { 1216, -192, -80},
    { 1584, -168, 232},
    { 1408, 240, 16},
    { 1432, 336, -272},
    { 1576, 232, 48},
    { 1424, 368, 328},
    { 1216, 528, 280},
    { 1008, 384, 216},
    { 912, 288, 136},
    { 832, 272, 144},
    { 864, 280, 128},
    { 840, 400, 8},
    { 960, 368, 24},
    { 1144, 528, 88},
    { 1768, 1008, 288},
    { 1824, 496, 168},
    { 1184, 280, 120},
    { 1344, 280, 184},
    { 1656, 160, 280},
    // 67 seconds
    { 1536, 120, 272},
    { 1280, 40, 304},
    { 1104, -8, 240},
    { 984, -40, 216},
    { 864, 0, 144},
    { 744, 8, 80},
    { 632, -56, 32},
    { 624, -80, -88},
    { 752, 16, -184},
    { 1328, -168, -16},
    { 1584, -8, 208},
    { 1304, 456, 0},
    { 1296, 480, -200},
    { 1448, 432, 48},
    { 1288, 376, 360},
    { 1200, 352, 256},
    { 1136, 536, 144},
    { 920, 512, 128},
    { 792, 504, -8},
    { 832, 416, 0},
    { 912, 416, 0},
    { 1080, 400, -16},
    { 1176, 408, 64},
    { 1648, 472, 48},
    { 1608, 496, 96},
    // 68 seconds
    { 1088, 296, 152},
    { 1272, 192, 168},
    { 1400, 88, 256},
    { 1264, 56, 248},
    { 1120, 40, 208},
    { 1072, -24, 208},
    { 912, -88, 216},
    { 808, 16, 80},
    { 720, 48, -32},
    { 680, -32, -64},
    { 720, -96, -96},
    { 912, -120, -152},
    { 1456, -328, 152},
    { 1848, 32, 328},
    { 1680, 600, -128},
    { 1552, 360, -144},
    { 1512, 104, 384},
    { 1216, 360, 288},
    { 1096, 280, 312},
    { 992, 328, 280},
    { 872, 360, 176},
    { 768, 424, 32},
    { 784, 376, 16},
    { 864, 424, 40},
    { 1144, 480, 80},
    // 69 seconds
    { 1320, 544, 168},
    { 1896, 488, 336},
    { 1648, 376, 264},
    { 1280, 224, 112},
    { 1560, 248, 184},
    { 1736, 176, 288},
    { 1480, 80, 232},
    { 1240, -40, 296},
    { 1056, -40, 232},
    { 928, -24, 152},
    { 816, 8, 88},
    { 664, -56, 64},
    { 528, -64, -56},
    { 608, -48, -160},
    { 792, -104, -120},
    { 1376, -320, 176},
    { 1848, -72, 472},
    { 1800, 672, 48},
    { 1760, 728, -168},
    { 1584, 376, 272},
    { 1336, 392, 448},
    { 1152, 336, 456},
    { 976, 248, 312},
    { 920, 368, 336},
    { 792, 656, 216},
    // 70 seconds
    { 744, 688, 200},
    { 808, 768, 216},
    { 1040, 760, 256},
    { 1328, 736, 272},
    { 1864, 768, 320},
    { 1768, 688, 328},
    { 1488, 536, 264},
    { 1528, 432, 264},
    { 1576, 408, 400},
    { 1208, 176, 416},
    { 824, 56, 256},
    { 640, 32, 136},
    { 528, -16, 88},
    { 424, -88, 104},
    { 384, -136, 88},
    { 504, -48, -32},
    { 848, 152, -208},
    { 1000, 40, -240},
    { 1608, -416, 168},
    { 2680, -16, 440},
    { 2352, 808, -208},
    { 1744, 568, -88},
    { 1400, 328, 288},
    { 1208, 336, 416},
    { 1032, 328, 344},
    // 71 seconds
    { 864, 344, 320},
    { 784, 416, 288},
    { 728, 504, 176},
    { 704, 424, 168},
    { 728, 472, 88},
    { 1096, 616, 224},
    { 1336, 704, 384},
    { 2000, 552, 272},
    { 2072, 344, 240},
    { 1560, 392, 120},
    { 1888, 408, -72},
    { 1768, 112, 120},
    { 1456, -16, 208},
    { 1232, -32, 336},
    { 992, -16, 184},
    { 792, -24, 112},
    { 656, -72, 88},
    { 536, -104, 64},
    { 464, -104, 0},
    { 536, -80, -88},
    { 824, 8, -168},
    { 1480, -168, 144},
    { 2048, 0, 544},
    { 1944, 616, 32},
    { 1856, 592, -136},
    // 72 seconds
    { 1624, 384, 328},
    { 1280, 432, 400},
    { 1112, 288, 328},
    { 992, 216, 264},
    { 904, 320, 224},
    { 808, 392, 120},
    { 816, 408, 56},
    { 832, 456, 88},
    { 1080, 528, -8},
    { 1216, 560, -8},
    { 1752, 512, 0},
    { 1880, 488, 24},
    { 1280, 328, 56},
    { 1392, 264, 112},
    { 1720, 184, 280},
    { 1688, 256, 400},
    { 1624, 336, 408},
    { 1456, 336, 480},
    { 1352, 464, 576},
    { 1048, 520, 472},
    { 760, 624, 480},
    { 520, 840, 472},
    { 312, 1008, 336},
    { 144, 1024, -8},
    { 80, 792, -416},
    // 73 seconds
    { -208, 344, -664},
    { -224, 216, -624},
    { -112, 440, -608},
    { -304, 384, -456},
    { -392, 408, -392},
    { -520, 360, -336},
    { -624, 400, -272},
    { -624, 360, -184},
    { -664, 344, -312},
    { -528, 472, -392},
    { -624, 544, -312},
    { -952, 848, -224},
    { -1024, 920, -144},
    { -952, 968, -520},
    { -872, 768, -624},
    { -840, 728, -488},
    { -792, 368, -216},
    { -752, 184, -112},
    { -632, 592, -152},
    { -664, 608, -160},
    { -640, 520, -192},
    { -648, 488, -144},
    { -576, 728, -208},
    { -440, 584, -440},
    { -344, 632, -536},
    // 74 seconds
    { -424, 384, -328},
    { -416, 416, -352},
    { -96, 928, -712},
    { -96, 16, -208},
    { 304, -104, 800},
    { 960, 608, 120},
    { 1248, 984, 456},
    { 1088, 800, 736},
    { 1360, 584, 680},
    { 1568, 736, 544},
    { 2024, 616, 608},
    { 2152, 760, 488},
    { 1728, 1312, 184},
    { 992, 752, 424},
    { 1016, 176, 200},
    { 1296, 608, 40},
    { 1592, 920, 96},
    { 1728, 944, 312},
    { 1088, 384, 344},
    { 1232, 280, 104},
    { 1560, 328, 176},
    { 1520, 256, 216},
    { 1232, 176, 144},
    { 1152, 120, 152},
    { 1080, -56, 368},
    // 75 seconds
    { 912, -48, 328},
    { 784, 0, 184},
    { 688, 0, 88},
    { 704, -56, 56},
    { 712, 24, -104},
    { 1008, -96, -128},
    { 1592, -248, 304},
    { 1680, 168, 128},
    { 1464, 520, -424},
    { 1480, 248, -216},
    { 1432, -48, 152},
    { 1160, 368, 184},
    { 1152, 424, 264},
    { 968, 360, 224},
    { 864, 352, 88},
    { 816, 312, 40},
    { 920, 496, -72},
    { 1096, 480, -88},
    { 1256, 608, -40},
    { 1888, 584, 120},
    { 1520, 448, 136},
    { 1320, 328, 64},
    { 1448, 264, 48},
    { 1584, 232, 176},
    { 1472, 216, 144},
    // 76 seconds
    { 1224, -16, 176},
    { 984, -104, 168},
    { 864, -88, 168},
    { 752, -40, 160},
    { 704, -56, 160},
    { 720, -56, 120},
    { 888, -8, -24},
    { 1088, 8, -96},
    { 1544, -240, 144},
    { 1488, 16, 160},
    { 1360, 320, -120},
    { 1440, 328, -216},
    { 1384, 352, 64},
    { 1272, 360, 176},
    { 1224, 552, 264},
    { 984, 440, 224},
    { 832, 272, 72},
    { 920, 352, 32},
    { 960, 440, -16},
    { 1168, 448, -32},
    { 1256, 472, -8},
    { 1488, 376, 72},
    { 1632, 424, 96},
    { 1144, 328, 128},
    { 1072, 208, 40},
    // 77 seconds
    { 1304, 72, 272},
    { 1472, 144, 376},
    { 1192, 96, 248},
    { 1144, 16, 240},
    { 1120, 8, 232},
    { 1008, -16, 232},
    { 912, 8, 168},
    { 928, -16, 96},
    { 904, -24, -16},
    { 880, 24, -120},
    { 1240, -192, 48},
    { 1376, -152, 152},
    { 1200, 160, -80},
    { 1248, 240, -168},
    { 1376, 248, -64},
    { 1376, 296, 192},
    { 1312, 464, 208},
    { 1160, 672, 240},
    { 832, 312, 136},
    { 792, 160, 128},
    { 904, 168, 104},
    { 1000, 464, 64},
    { 1176, 600, -64},
    { 1248, 568, 64},
    { 1696, 640, 152},
    // 78 seconds
    { 1376, 496, 88},
    { 1120, 344, 104},
    { 1312, 208, 184},
    { 1448, 80, 288},
    { 1320, 64, 280},
    { 1144, 72, 216},
    { 992, 16, 232},
    { 912, -8, 224},
    { 848, -8, 160},
    { 776, -24, 112},
    { 792, -32, 24},
    { 880, 32, -208},
    { 936, 40, -304},
    { 1296, -280, 48},
    { 1480, -120, 288},
    { 1392, 360, 112},
    { 1432, 576, -184},
    { 1224, 304, 144},
    { 1040, 184, 376},
    { 1048, 152, 360},
    { 1016, 168, 312},
    { 912, 296, 200},
    { 872, 376, 40},
    { 920, 392, -64},
    { 1016, 328, -16},
    // 79 seconds
    { 1272, 600, -72},
    { 1408, 696, -40},
    { 2016, 856, 64},
    { 1280, 336, 64},
    { 1096, 272, 8},
    { 1368, 272, 104},
    { 1536, 232, 224},
    { 1416, 152, 240},
    { 1240, 128, 168},
    { 1128, 120, 144},
    { 984, -32, 288},
    { 864, -48, 232},
    { 728, -56, 112},
    { 704, -104, 16},
    { 744, -8, -216},
    { 824, -56, -184},
    { 1400, -232, 48},
    { 1504, -72, 232},
    { 1560, 320, 0},
    { 1768, 352, -64},
    { 1744, 424, 248},
    { 1392, 592, 312},
    { 1120, 504, 432},
    { 952, 208, 264},
    { 976, 240, 240},
    // 80 seconds
    { 856, 416, 88},
    { 840, 480, 0},
    { 904, 608, 56},
    { 1184, 696, 64},
    { 1208, 576, 184},
    { 1728, 536, 184},
    { 1544, 448, 200},
    { 1568, 264, 248},
    { 1696, 240, 240},
    { 1536, 56, 360},
    { 1336, 0, 320},
    { 1216, -16, 280},
    { 1088, -24, 232},
    { 960, -40, 216},
    { 792, -8, 112},
    { 728, -72, 24},
    { 656, -184, 0},
    { 784, -48, -152},
    { 992, -168, -64},
    { 1488, -168, 232},
    { 1664, 240, 136},
    { 1472, 416, -112},
    { 1456, 352, -128},
    { 1528, 304, 168},
    { 1440, 416, 336},
    // 81 seconds
    { 1208, 616, 320},
    { 968, 592, 296},
    { 752, 360, 88},
    { 768, 264, 88},
    { 888, 520, 40},
    { 984, 568, 104},
    { 1168, 672, 128},
    { 1776, 544, 360},
    { 1856, 376, 280},
    { 1360, 352, 80},
    { 1296, 368, 96},
    { 1600, 256, 168},
    { 1512, -16, 272},
    { 1360, 0, 272},
    { 1112, -48, 216},
    { 888, -56, 160},
    { 720, -24, 112},
    { 616, -32, 88},
    { 536, -56, 8},
    { 648, -56, -48},
    { 872, 72, -160},
    { 1344, -72, -48},
    { 1800, -128, 304},
    { 1648, 272, 144},
    { 1544, 472, -152},
    // 82 seconds
    { 1576, 328, 104},
    { 1320, 440, 272},
    { 1072, 344, 352},
    { 944, 192, 280},
    { 904, 256, 208},
    { 808, 304, 168},
    { 752, 456, 16},
    { 840, 456, 48},
    { 1104, 536, 0},
    { 1272, 528, 56},
    { 1752, 496, 128},
    { 1736, 472, 136},
    { 1248, 328, 80},
    { 1392, 208, 160},
    { 1680, 72, 320},
    { 1512, -40, 344},
    { 1216, 32, 168},
    { 976, -8, 184},
    { 800, -32, 192},
    { 680, -16, 104},
    { 616, -56, 88},
    { 552, -64, 24},
    { 608, -80, 0},
    { 832, 40, -128},
    { 1312, -112, -56},
    // 83 seconds
    { 2040, -80, 456},
    { 2024, 352, 112},
    { 1680, 536, -456},
    { 1336, 264, -56},
    { 1064, 8, 256},
    { 1032, 168, 288},
    { 1008, 192, 232},
    { 944, 248, 160},
    { 832, 376, 56},
    { 784, 424, -64},
    { 832, 480, -56},
    { 1072, 480, -48},
    { 1240, 448, 48},
    { 1808, 352, 160},
    { 1728, 296, 152},
    { 1336, 256, 136},
    { 1480, 152, 216},
    { 1560, 32, 208},
    { 1384, 16, 128},
    { 1128, -56, 232},
    { 928, 0, 168},
    { 840, -24, 152},
    { 792, -32, 160},
    { 720, -40, 144},
    { 632, -72, 40},
    // 84 seconds
    { 624, -24, -128},
    { 840, 80, -232},
    { 1160, -240, 56},
    { 1656, -280, 280},
    { 1840, 208, -112},
    { 1744, 352, -184},
    { 1544, 344, -32},
    { 1216, 264, 248},
    { 1032, 392, 312},
    { 976, 280, 304},
    { 920, 304, 264},
    { 800, 312, 184},
    { 736, 304, 56},
    { 760, 216, 120},
    { 872, 416, 136},
    { 1168, 696, 64},
    { 1664, 664, 152},
    { 1800, 440, 320},
    { 1216, 240, 200},
    { 1328, 248, 152},
    { 1464, 184, 208},
    { 1448, -560, 72},
    { 1112, 80, 264},
    { 944, -72, 256},
    { 936, 16, 120},
    // 85 seconds
    { 808, -40, 152},
    { 680, -40, 160},
    { 624, -48, 104},
    { 624, -48, 48},
    { 880, 136, -200},
    { 1488, -96, -24},
    { 1984, -160, 288},
    { 1728, 376, -64},
    { 1112, 408, -344},
    { 1008, -16, 48},
    { 1200, 776, 544},
    { 1152, 232, 320},
    { 1016, 280, 240},
    { 1008, 520, 176},
    { 840, 464, 224},
    { 736, 392, 96},
    { 712, 232, 8},
    { 1056, 488, -80},
    { 1160, 480, -80},
    { 1752, 472, 32},
    { 1584, 360, 176},
    { 1256, 336, 88},
    { 1504, 216, 168},
    { 1656, 176, 200},
    { 1352, -272, 56},
    // 86 seconds
    { 1064, -72, 200},
    { 1064, 24, 160},
    { 928, 16, 160},
    { 808, -16, 88},
    { 728, -24, 128},
    { 760, 8, 104},
    { 744, 40, -40},
    { 792, 40, -160},
    { 1296, -216, -112},
    { 1424, -272, 216},
    { 1616, 608, 160},
    { 1256, 1080, -136},
    { 1040, 816, 96},
    { 896, 280, 488},
    { 944, 296, 272},
    { 1064, 552, 328},
    { 832, 584, 544},
    { 592, 688, 512},
    { 544, 808, 256},
    { 680, 768, 216},
    { 864, 736, 256},
    { 1024, 648, 400},
    { 1360, 696, 416},
    { 1384, 760, 472},
    { 1240, 552, 720},
    // 87 seconds
    { 1312, 592, 488},
    { 1416, 536, 408},
    { 1216, 384, 376},
    { 1016, 224, 336},
    { 960, 80, 352},
    { 824, 56, 344},
    { 776, 200, 152},
    { 680, 224, 176},
    { 744, 160, 200},
    { 768, 328, 144},
    { 800, 520, 88},
    { 1352, 376, 280},
    { 1272, 512, 344},
    { 1104, 552, 296},
    { 1064, 584, 176},
    { 904, 344, 296},
    { 848, 224, 496},
    { 984, 304, 360},
    { 1160, 480, 248},
    { 936, 552, 256},
    { 792, 656, 40},
    { 840, 464, 16},
    { 1008, 592, -48},
    { 1200, 576, -16},
    { 1344, 616, -120},
    // 88 seconds
    { 1784, 824, -40},
    { 1208, 544, 112},
    { 1296, 368, 16},
    { 1552, 272, 96},
    { 1472, 112, 192},
    { 1232, 56, 184},
    { 1088, 32, 160},
    { 952, 32, 144},
    { 832, 40, 120},
    { 744, -8, 112},
    { 664, -56, 88},
    { 656, -112, 48},
    { 784, 8, -48},
    { 1240, -24, -72},
    { 1592, -56, 104},
    { 1568, 176, 104},
    { 1440, 448, -264},
    { 1384, 400, -176},
    { 1456, 368, 96},
    { 1200, 368, 192},
    { 1056, 504, 192},
    { 976, 424, 136},
    { 840, 384, 64},
    { 792, 336, 64},
    { 856, 448, -16},
    // 89 seconds
    { 1032, 432, -16},
    { 1280, 504, -48},
    { 1656, 464, -16},
    { 1832, 448, 32},
    { 1184, 320, 56},
    { 1032, 216, 88},
    { 1264, 152, 168},
    { 1328, 80, 256},
    { 1224, 88, 216},
    { 1112, 24, 232},
    { 992, -8, 240},
    { 856, 32, 160},
    { 800, -8, 168},
    { 744, -8, 88},
    { 800, -32, 24},
    { 976, 16, -104},
    { 1144, 0, -152},
    { 1544, -272, 144},
    { 1496, 56, 152},
    { 1152, 416, -200},
    { 1352, 360, -224},
    { 1368, 248, 216},
    { 1208, 368, 288},
    { 1104, 424, 264},
    { 912, 272, 200},
    // 90 seconds
    { 824, 288, 128},
    { 768, 328, 40},
    { 808, 416, -72},
    { 912, 416, -64},
    { 1160, 480, -96},
    { 1224, 400, 16},
    { 1632, 336, 72},
    { 1616, 344, 152},
    { 1040, 240, 144},
    { 1184, 208, 88},
    { 1336, 128, 184},
    { 1368, 112, 256},
    { 1192, 32, 256},
    { 1008, 40, 184},
    { 920, -8, 184},
    { 840, -8, 128},
    { 752, 0, 80},
    { 648, -40, 80},
    { 592, -32, -56},
    { 840, 40, -160},
    { 1288, -112, -48},
    { 1832, -184, 344},
    { 1808, 464, 104},
    { 1344, 800, -416},
    { 992, 72, 120},
    // 91 seconds
    { 1432, 336, 472},
    { 1208, 288, 392},
    { 1016, 344, 288},
    { 840, 384, 208},
    { 744, 352, 192},
    { 728, 304, 152},
    { 808, 312, 120},
    { 944, 400, 88},
    { 1152, 456, 32},
    { 1432, 408, 168},
    { 1824, 528, 208},
    { 1080, 408, 80},
    { 1056, 264, 72},
    { 1280, 184, 192},
    { 1424, 152, 264},
    { 1272, 112, 216},
    { 1112, 96, 160},
    { 1048, 56, 144},
    { 952, -40, 184},
    { 800, 24, 72},
    { 736, -56, 96},
    { 688, -80, 16},
    { 776, 0, -64},
    { 1168, -80, -32},
    { 1656, -160, 264},
    // 92 seconds
    { 1440, 256, 88},
    { 1288, 496, -296},
    { 1208, 240, -48},
    { 1128, 160, 296},
    { 1112, 264, 216},
    { 1080, 264, 296},
    { 960, 456, 208},
    { 832, 400, 176},
    { 800, 344, 136},
    { 816, 328, 64},
    { 1016, 368, 8},
    { 1192, 472, 0},
    { 1400, 424, 56},
    { 1824, 440, 112},
    { 1248, 384, 32},
    { 1032, 224, 24},
    { 1296, 184, 48},
    { 1440, 88, 184},
    { 1224, 120, 208},
    { 1080, 48, 280},
    { 992, 16, 248},
    { 904, -8, 216},
    { 848, -32, 168},
    { 736, -32, 88},
    { 688, -32, 48},
    // 93 seconds
    { 808, 136, -152},
    { 1040, 40, -264},
    { 1504, -400, 56},
    { 1480, -48, -16},
    { 1256, 328, -352},
    { 1320, 184, -184},
    { 1384, 112, 240},
    { 1080, 312, 296},
    { 1000, 392, 328},
    { 864, 216, 248},
    { 848, 200, 200},
    { 840, 248, 136},
    { 848, 304, 48},
    { 904, 448, -48},
    { 1224, 568, -112},
    { 1424, 520, 0},
    { 1624, 408, 32},
    { 1472, 256, 80},
    { 872, 192, 112},
    { 1056, 168, 136},
    { 1208, 96, 136},
    { 1192, 112, 168},
    { 1104, 72, 248},
    { 1008, 48, 216},
    { 976, -8, 240},
    // 94 seconds
    { 912, 32, 160},
    { 864, 16, 104},
    { 864, 160, -48},
    { 920, 64, -40},
    { 912, -72, -136},
    { 1392, -456, -24},
    { 1416, -168, -8},
    { 1128, 120, -208},
    { 1208, 152, -184},
    { 1360, 176, 104},
    { 1248, 256, 288},
    { 1184, 384, 304},
    { 1056, 488, 296},
    { 896, 376, 264},
    { 816, 288, 176},
    { 888, 336, 128},
    { 880, 336, 24},
    { 968, 376, -96},
    { 1152, 424, -72},
    { 1512, 576, -16},
    { 1712, 544, 96},
    { 1272, 344, 64},
    { 1240, 216, 96},
    { 1456, 96, 160},
    { 1464, 48, 176},
    // 95 seconds
    { 1216, 32, 56},
    { 1088, -32, 144},
    { 968, -72, 144},
    { 912, -32, 152},
    { 848, 184, 32},
    { 800, 72, -40},
    { 672, -128, 8},
    { 680, -104, -88},
    { 944, -224, -216},
    { 1400, -320, -16},
    { 1392, -24, 0},
    { 1224, 248, -240},
    { 1392, 192, -288},
    { 1408, 168, 16},
    { 1256, 56, 88},
    { 1128, 296, 120},
    { 1104, 320, 120},
    { 1000, 296, 104},
    { 888, 280, 24},
    { 936, 368, -64},
    { 912, 328, -16},
    { 1096, 488, -56},
    { 1256, 600, -8},
    { 1592, 648, 112},
    { 1592, 464, 184},
    // 96 seconds
    { 1224, 256, 144},
    { 1304, 152, 112},
    { 1504, 104, 224},
    { 1408, 80, 328},
    { 1200, 24, 280},
    { 1056, 8, 208},
    { 936, 16, 184},
    { 864, -8, 144},
    { 784, 8, 72},
    { 680, -48, 40},
    { 680, -64, -72},
    { 880, 56, -232},
    { 1336, -184, 24},
    { 1544, -136, 224},
    { 1336, 504, -128},
    { 1352, 392, -152},
    { 1472, 408, 24},
    { 1384, 512, 192},
    { 1248, 536, 400},
    { 1048, 440, 288},
    { 832, 312, 208},
    { 816, 328, 208},
    { 880, 312, 144},
    { 824, 440, -40},
    { 984, 504, -72},
    // 97 seconds
    { 1240, 520, 56},
    { 1824, 528, 152},
    { 1632, 544, 160},
    { 1024, 376, 16},
    { 1264, 312, 96},
    { 1424, 232, 392},
    { 1424, 0, 376},
    { 1184, -24, 312},
    { 992, -64, 216},
    { 888, -8, 200},
    { 808, 56, 144},
    { 736, 24, 112},
    { 664, -40, 88},
    { 696, -96, 40},
    { 864, 48, -280},
    { 1552, 72, -40},
    { 1544, 8, 56},
    { 1312, 264, -168},
    { 1336, 432, -240},
    { 1336, 312, -8},
    { 1184, 296, 208},
    { 1112, 440, 200},
    { 976, 424, 240},
    { 880, 328, 176},
    { 800, 296, 128},
    // 98 seconds
    { 824, 400, -16},
    { 888, 360, 16},
    { 1160, 512, -104},
    { 1232, 392, -8},
    { 1736, 456, 24},
    { 1488, 456, 104},
    { 1016, 240, 136},
    { 1256, 216, 112},
    { 1472, 168, 184},
    { 1336, 80, 248},
    { 1120, 64, 200},
    { 1008, 56, 136},
    { 936, 0, 144},
    { 872, 8, 112},
    { 776, 0, 88},
    { 688, -72, 32},
    { 752, -72, -88},
    { 928, 0, -176},
    { 1416, -96, 48},
    { 1728, 32, 264},
    { 1304, 416, -48},
    { 1312, 368, -256},
    { 1336, 200, 184},
    { 1232, 328, 328},
    { 1120, 368, 256},
    // 99 seconds
    { 968, 336, 200},
    { 848, 304, 152},
    { 808, 344, 40},
    { 832, 368, 32},
    { 904, 400, 48},
    { 1120, 512, 48},
    { 1368, 584, 216},
    { 1816, 512, 152},
    { 1608, 304, 96},
    { 1216, 256, 8},
    { 1408, 272, -32},
    { 1752, -736, -112},
    { 1352, 72, 256},
    { 1072, -80, 208},
    { 928, -8, 96},
    { 880, 16, 104},
    { 824, 40, 80},
    { 704, -8, 48},
    { 576, -152, 8},
    { 576, -88, -128},
    { 864, 128, -216},
    { 1480, -88, -24},
    { 1816, -24, 184},
    { 1736, 400, -104},
    { 1400, 424, -112},
    // 100 seconds
    { 1112, 392, 48},
    { 1032, 152, 232},
    { 1128, 112, 248},
    { 976, 200, 192},
    { 888, 280, 184},
    { 856, 392, 16},
    { 888, 368, -24},
    { 944, 480, -56},
    { 1192, 464, -48},
    { 1280, 384, -32},
    { 1752, 480, -48},
    { 1336, 400, 16},
    { 1112, 216, 72},
    { 1272, 168, 112},
    { 1424, 48, 208},
    { 1288, 88, 144},
    { 1104, 24, 208},
    { 992, 0, 184},
    { 896, 24, 128},
    { 808, 48, 80},
    { 696, -8, 72},
    { 640, -104, 24},
    { 816, -24, -80},
    { 1104, 56, -200},
    { 1664, -304, 208},
    // 101 seconds
    { 1576, 80, 136},
    { 1256, 584, -448},
    { 1232, 232, -184},
    { 1256, 200, 96},
    { 1160, 8, 256},
    { 1064, 216, 232},
    { 1008, 296, 272},
    { 888, 344, 176},
    { 768, 352, 104},
    { 792, 384, -8},
    { 848, 416, 24},
    { 1312, 512, -24},
    { 1264, 376, 128},
    { 1600, 512, 48},
    { 1376, 488, 24},
    { 1192, 280, 80},
    { 1408, 160, 136},
    { 1512, 88, 176},
    { 1344, 72, 208},
    { 1144, 80, 184},
    { 992, 48, 160},
    { 896, 16, 128},
    { 840, 8, 112},
    { 728, -144, 80},
    { 576, -176, -16},
    // 102 seconds
    { 848, 40, -72},
    { 904, 80, -160},
    { 1488, -80, 64},
    { 1632, 32, 168},
    { 1368, 368, -200},
    { 1368, 352, -192},
    { 1264, 176, 88},
    { 1152, 72, 168},
    { 1112, 168, 168},
    { 1064, 224, 144},
    { 1032, 352, 120},
    { 920, 368, 48},
    { 896, 424, -48},
    { 864, 400, -72},
    { 1120, 528, -136},
    { 1240, 496, -64},
    { 1688, 464, -80},
    { 1752, 488, -64},
    { 1136, 176, 0},
    { 1344, 96, 0},
    { 1600, 0, 88},
    { 1456, 40, 192},
    { 1208, 24, 216},
    { 1048, 16, 192},
    { 960, 32, 168},
    // 103 seconds
    { 920, 56, 160},
    { 840, 16, 112},
    { 784, 24, -88},
    { 816, 64, -184},
    { 800, -104, -112},
    { 1224, -448, 48},
    { 1288, -64, 104},
    { 1496, 192, 64},
    { 1696, 392, -72},
    { 1656, 512, 0},
    { 1336, 272, 224},
    { 1360, 328, 232},
    { 1216, 400, 352},
    { 1016, 352, 200},
    { 920, 320, 112},
    { 824, 488, 16},
    { 808, 528, 80},
    { 1064, 600, 96},
    { 1224, 552, 264},
    { 1824, 696, 256},
    { 1384, 344, 128},
    { 1296, 232, 192},
    { 1640, 128, 248},
    { 1672, 128, 192},
    { 1424, 40, 280},
    // 104 seconds
    { 1192, -40, 272},
    { 1008, 16, 112},
    { 904, 40, 64},
    { 840, 24, 80},
    { 784, -32, 104},
    { 720, -104, 48},
    { 808, -56, -96},
    { 1008, -96, -136},
    { 1464, -192, 80},
    { 1632, -72, 488},
    { 1184, 384, -128},
    { 1488, 312, -200},
    { 1616, 304, 224},
    { 1416, 288, 336},
    { 1224, 416, 376},
    { 976, 376, 280},
    { 928, 304, 288},
    { 872, 528, 176},
    { 800, 576, 48},
    { 888, 576, 24},
    { 1184, 552, 64},
    { 1456, 392, 168},
    { 2008, 440, 296},
    { 1432, 424, 128},
    { 1152, 368, 32},
    // 105 seconds
    { 1584, 224, 88},
    { 1720, 16, 152},
    { 1472, -32, 248},
    { 1168, -32, 200},
    { 944, 32, 56},
    { 784, 56, 48},
    { 664, -8, 96},
    { 560, -64, 24},
    { 520, -120, 0},
    { 632, -112, -104},
    { 904, -160, 40},
    { 1544, -112, 448},
    { 1840, 584, 544},
    { 1504, 1088, 128},
    { 1464, 984, -72},
    { 1248, 728, 344},
    { 944, 408, 448},
    { 928, 48, 384},
    { 920, 208, 280},
    { 872, 328, 224},
    { 816, 376, 184},
    { 808, 448, 152},
    { 936, 448, 96},
    { 1200, 568, 48},
    { 1384, 408, 128},
    // 106 seconds
    { 1784, 464, 192},
    { 1360, 448, 184},
    { 1160, 256, 120},
    { 1552, 312, 64},
    { 1416, -488, 240},
    { 1296, -64, 304},
    { 1088, -56, 216},
    { 928, 0, 128},
    { 800, 8, 72},
    { 696, 56, 16},
    { 608, -48, 32},
    { 624, -64, -16},
    { 816, 40, -176},
    { 1072, -32, -120},
    { 1568, -240, 184},
    { 1552, 128, 144},
    { 1504, 480, -240},
    { 1480, 320, -112},
    { 1256, 240, 256},
    { 1072, 200, 240},
    { 1016, 264, 256},
    { 904, 288, 168},
    { 864, 368, 128},
    { 888, 440, 96},
    { 896, 488, 48},
    // 107 seconds
    { 984, 568, 0},
    { 1168, 672, 104},
    { 1504, 568, 320},
    { 1792, 392, 328},
    { 1512, 584, 248},
    { 1464, 432, 72},
    { 1512, 288, 104},
    { 1456, 168, 176},
    { 1272, 120, 176},
    { 1120, 64, 168},
    { 928, 24, 160},
    { 768, 8, 104},
    { 672, -8, 64},
    { 544, -48, 8},
    { 504, -80, -96},
    { 704, 24, -128},
    { 952, 112, -64},
    { 1600, 48, 192},
    { 1672, 464, 184},
    { 1528, 568, -56},
    { 1448, 608, -32},
    { 1184, 584, 88},
    { 1032, 288, 248},
    { 968, 320, 264},
    { 920, 344, 208},
    // 108 seconds
    { 896, 352, 224},
    { 824, 416, 160},
    { 816, 536, 64},
    { 888, 528, 112},
    { 1144, 624, 192},
    { 1344, 560, 296},
    { 1768, 688, 352},
    { 1296, 560, 280},
    { 1104, 408, 88},
    { 1200, 208, 280},
    { 1304, 272, 136},
    { 1144, 224, 144},
    { 1000, 128, 144},
    { 904, 112, 48},
    { 824, 80, 80},
    { 736, 56, 96},
    { 632, 32, 64},
    { 600, -56, 48},
    { 776, 64, -64},
    { 984, 112, -64},
    { 1544, -40, 24},
    { 1816, -24, 264},
    { 1648, 400, -96},
    { 1480, 560, -280},
    { 1128, 408, 56},
    // 109 seconds
    { 904, 112, 296},
    { 952, 192, 280},
    { 928, 216, 240},
    { 864, 320, 184},
    { 784, 448, 0},
    { 784, 408, 24},
    { 888, 504, -16},
    { 1136, 432, 24},
    { 1256, 400, 120},
    { 1968, 432, 248},
    { 1592, 456, 152},
    { 1072, 240, 88},
    { 1296, 248, 88},
    { 1512, 144, 264},
    { 1280, 24, 296},
    { 1112, 24, 216},
    { 1016, 8, 176},
    { 888, 0, 152},
    { 752, -8, 120},
    { 648, -40, 104},
    { 560, -72, 40},
    { 608, -32, -48},
    { 912, 40, -152},
    { 1552, -216, 136},
    { 1808, -48, 328},
    // 110 seconds
    { 1632, 424, -24},
    { 1576, 504, -216},
    { 1312, 384, 192},
    { 1080, 360, 256},
    { 1048, 216, 312},
    { 960, 224, 224},
    { 888, 312, 136},
    { 816, 344, 40},
    { 816, 400, -16},
    { 880, 416, -48},
    { 1160, 408, 8},
    { 1448, 328, 128},
    { 1904, 424, 152},
    { 1544, 360, 160},
    { 1120, 152, 112},
    { 1368, 128, 104},
    { 1440, 96, 152},
    { 1152, 56, 264},
    { 968, -8, 224},
    { 840, -8, 184},
    { 768, -8, 192},
    { 728, -8, 160},
    { 688, -16, 136},
    { 680, 0, 24},
    { 872, 128, -168},
    // 111 seconds
    { 944, 64, -128},
    { 1544, -240, 104},
    { 1648, -88, 232},
    { 1248, 328, -16},
    { 1280, 360, -184},
    { 1208, 280, 56},
    { 1016, 160, 224},
    { 1072, 192, 216},
    { 1008, 280, 160},
    { 912, 304, 40},
    { 864, 328, -32},
    { 864, 376, -72},
    { 888, 360, -64},
    { 1096, 344, -40},
    { 1248, 272, 88},
    { 1832, 376, 96},
    { 1776, 424, 128},
    { 1096, 232, 48},
    { 1136, 192, 72},
    { 1264, 104, 144},
    { 1200, 88, 144},
    { 1040, 64, 176},
    { 904, -8, 192},
    { 800, -32, 176},
    { 704, -8, 128},
    // 112 seconds
    { 648, -16, 120},
    { 640, -32, 64},
    { 800, -24, -8},
    { 1016, 112, -152},
    { 1568, -88, 8},
    { 1984, -192, 328},
    { 1472, 352, -56},
    { 1192, 416, -336},
    { 1024, 176, 64},
    { 1048, 168, 296},
    { 1016, 248, 256},
    { 928, 312, 264},
    { 824, 400, 160},
    { 776, 312, 80},
    { 808, 328, 0},
    { 840, 336, -40},
    { 1024, 344, -56},
    { 1240, 376, -56},
    { 1640, 280, 8},
    { 1736, 288, 64},
    { 1160, 216, 112},
    { 1128, 144, 40},
    { 1344, 80, 152},
    { 1304, 56, 192},
    { 1160, 56, 176},
    // 113 seconds
    { 1000, 40, 144},
    { 912, 8, 152},
    { 840, -24, 136},
    { 736, 16, 64},
    { 680, -24, 16},
    { 664, 48, -88},
    { 816, 184, -272},
    { 1000, -56, -120},
    { 1568, -256, 136},
    { 1592, 56, 72},
    { 1320, 312, -88},
    { 1256, 288, -40},
    { 1168, 240, 176},
    { 1040, 216, 264},
    { 992, 224, 272},
    { 936, 288, 192},
    { 880, 288, 136},
    { 856, 360, 48},
    { 856, 408, -40},
    { 880, 368, -72},
    { 1000, 408, -168},
    { 1160, 312, -144},
    { 1360, 160, -8},
    { 1784, 160, 8},
    { 1608, 280, 192},
    // 114 seconds
    { 1360, 176, 200},
    { 1528, 240, 248},
    { 1464, 320, 432},
    { 1328, 208, 576},
    { 1176, 320, 472},
    { 1080, 416, 304},
    { 888, 312, 336},
    { 768, 320, 168},
    { 600, 368, -96},
    { 440, 464, -176},
    { 256, 528, -280},
    { 232, 664, -288},
    { 112, 632, -424},
    { 200, 904, -648},
    { 72, 1072, -696},
    { -8, 984, -520},
    { -8, 904, -512},
    { -40, 960, -624},
    { -64, 920, -664},
    { -96, 792, -672},
    { -48, 688, -672},
    { 176, 416, -728},
    { 144, 424, -992},
    { 104, 440, -816},
    { 184, 320, -704},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-03 09:08:35 local
AccelRawData *activity_sample_walk_200_pbl_25532_11(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25532_11
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -528, 32, -776},
    { -424, -448, -568},
    { -696, -416, -328},
    { -592, 280, -256},
    { -896, 1104, -320},
    { -1048, 1272, -424},
    { -608, 160, -632},
    { -256, 16, -1168},
    { -40, 176, -1448},
    { -88, -152, -1344},
    { 16, -200, -1304},
    { 8, -344, -1096},
    { 152, -168, -928},
    { -64, -216, -1072},
    { -24, -88, -1008},
    { -8, -96, -1024},
    { -104, -208, -1064},
    { 32, -152, -1064},
    { 56, -192, -1040},
    { -120, -280, -1048},
    { 56, -136, -1064},
    { 72, -176, -1048},
    { 0, -176, -1008},
    { 16, -72, -1032},
    { -112, -56, -1016},
    // 1 seconds
    { -176, -280, -1032},
    { 32, -200, -1016},
    { -24, -136, -1008},
    { 120, -184, -1120},
    { 24, -256, -1040},
    { 0, -152, -960},
    { 24, -216, -1008},
    { -8, -184, -984},
    { 8, -168, -1032},
    { -16, -192, -1120},
    { -264, -128, -912},
    { 1064, -104, -1040},
    { 200, -160, -952},
    { 248, -168, -824},
    { 200, -40, -696},
    { 168, -80, -648},
    { 176, 24, -600},
    { 32, 120, -592},
    { 96, 144, -496},
    { -32, 424, -496},
    { 80, 472, -360},
    { 224, 624, -120},
    { 448, 1032, -88},
    { 536, 1080, 280},
    { 864, 1392, 1048},
    // 2 seconds
    { 1096, 1752, 1080},
    { 608, 1752, 752},
    { 696, 1272, 432},
    { 608, 728, 320},
    { 496, 496, 448},
    { 760, 776, 400},
    { 584, 776, 352},
    { 600, 536, 328},
    { 568, 416, 328},
    { 792, 432, 264},
    { 1040, 440, 256},
    { 1272, 296, 368},
    { 1296, 240, 416},
    { 1080, 456, 240},
    { 672, 496, 48},
    { 720, 136, 216},
    { 872, 8, 296},
    { 840, 72, 328},
    { 616, 112, 400},
    { 832, 368, 120},
    { 712, 256, 128},
    { 696, 256, 136},
    { 768, 232, 184},
    { 840, 328, 136},
    { 920, 272, 208},
    // 3 seconds
    { 1256, 416, 232},
    { 1648, 416, 400},
    { 1768, 424, 400},
    { 968, 512, 248},
    { 568, 384, 136},
    { 1248, 472, -24},
    { 984, -96, 232},
    { 1048, 64, 416},
    { 832, 48, 288},
    { 792, 80, 176},
    { 816, 24, 208},
    { 808, 0, 256},
    { 760, 16, 200},
    { 792, 0, 88},
    { 936, -8, -56},
    { 1336, -16, -96},
    { 1888, -128, 312},
    { 1632, 16, 304},
    { 976, 488, -144},
    { 688, 136, -536},
    { 1016, 112, 64},
    { 936, 176, 232},
    { 856, 192, 280},
    { 872, 224, 224},
    { 800, 336, 152},
    // 4 seconds
    { 752, 368, 96},
    { 848, 392, 40},
    { 904, 256, 104},
    { 1280, 304, 144},
    { 1568, 280, 272},
    { 1736, 512, 264},
    { 1048, 512, 32},
    { 968, 296, 56},
    { 864, 424, 504},
    { 1248, 248, 240},
    { 1112, 56, 304},
    { 920, 40, 232},
    { 880, 120, 64},
    { 816, -16, 152},
    { 744, 64, 72},
    { 704, 16, 56},
    { 688, -72, 24},
    { 904, 16, -104},
    { 1288, -8, -8},
    { 1856, -152, 288},
    { 1568, 456, -40},
    { 1256, 592, -248},
    { 1096, 80, 104},
    { 1016, 96, 336},
    { 984, 224, 296},
    // 5 seconds
    { 936, 240, 304},
    { 856, 344, 224},
    { 776, 304, 216},
    { 760, 368, 80},
    { 768, 376, 8},
    { 968, 464, 72},
    { 1224, 616, 120},
    { 1520, 520, 208},
    { 1696, 504, 304},
    { 1248, 488, 104},
    { 1208, 360, 112},
    { 1384, 232, 216},
    { 1440, 144, 248},
    { 1224, 0, 304},
    { 952, 32, 176},
    { 864, 88, 64},
    { 736, 8, 120},
    { 672, 32, 48},
    { 592, -16, 32},
    { 640, -80, -8},
    { 896, 40, -120},
    { 1408, -80, 32},
    { 1864, -64, 240},
    { 1608, 248, -32},
    { 1304, 528, -312},
    // 6 seconds
    { 1264, 464, -64},
    { 1224, 304, 256},
    { 1064, 248, 320},
    { 992, 232, 320},
    { 928, 344, 256},
    { 824, 432, 96},
    { 720, 400, 40},
    { 824, 544, -48},
    { 1008, 464, 16},
    { 1200, 552, 56},
    { 1592, 568, 208},
    { 1888, 544, 328},
    { 1304, 368, 144},
    { 1352, 272, 192},
    { 984, 624, 752},
    { 1384, 112, 208},
    { 1192, -56, 320},
    { 1000, 24, 200},
    { 904, 0, 152},
    { 776, 0, 128},
    { 712, -8, 56},
    { 640, -48, 32},
    { 568, -104, -8},
    { 800, -16, -152},
    { 1056, -144, -56},
    // 7 seconds
    { 1744, -104, 240},
    { 1936, 200, 296},
    { 1784, 592, -32},
    { 1592, 464, 32},
    { 1216, 360, 320},
    { 1016, 216, 352},
    { 952, 120, 312},
    { 904, 160, 280},
    { 872, 360, 96},
    { 752, 416, 0},
    { 816, 536, -8},
    { 952, 576, -24},
    { 1232, 536, -40},
    { 1632, 376, 80},
    { 1856, 248, 168},
    { 1368, 304, 112},
    { 1296, 240, 168},
    { 1440, 152, 168},
    { 1368, 24, 232},
    { 1200, 16, 224},
    { 1088, 32, 184},
    { 1008, 8, 184},
    { 920, 56, 120},
    { 968, 48, 104},
    { 832, -64, 96},
    // 8 seconds
    { 760, -152, -16},
    { 800, -48, -152},
    { 1152, -88, -168},
    { 1392, -256, 192},
    { 1592, 24, 296},
    { 1728, 432, -16},
    { 1768, 368, 24},
    { 1520, 328, 400},
    { 1256, 560, 288},
    { 1032, 376, 360},
    { 888, 256, 248},
    { 760, 296, 112},
    { 808, 408, -40},
    { 808, 512, 16},
    { 1096, 632, 56},
    { 1280, 536, 184},
    { 1816, 384, 256},
    { 1776, 312, 272},
    { 1240, 320, 144},
    { 1448, 232, 248},
    { 1760, 136, 392},
    { 1608, 56, 304},
    { 1376, -16, 312},
    { 1200, 16, 192},
    { 1056, 0, 168},
    // 9 seconds
    { 896, 8, 96},
    { 760, -64, 16},
    { 528, -128, 8},
    { 456, -184, -16},
    { 488, -200, 80},
    { 1352, -96, -8},
    { 1696, 432, -248},
    { 1672, 48, 152},
    { 1760, 280, -80},
    { 1904, 288, 208},
    { 1768, 584, 488},
    { 1328, 592, 400},
    { 1096, 400, 360},
    { 920, 280, 400},
    { 784, 288, 296},
    { 784, 312, 168},
    { 856, 496, 168},
    { 928, 544, 168},
    { 1128, 584, 200},
    { 1768, 680, 176},
    { 1584, 464, 216},
    { 1368, 352, 152},
    { 1488, 256, 168},
    { 1648, 160, 224},
    { 1552, 48, 280},
    // 10 seconds
    { 1296, -16, 296},
    { 1112, 8, 200},
    { 952, -56, 216},
    { 832, 0, 160},
    { 728, -48, 176},
    { 656, -40, 96},
    { 680, -8, -56},
    { 888, 72, -136},
    { 1200, -128, -72},
    { 1472, -232, 8},
    { 1616, 96, -112},
    { 1616, 448, -344},
    { 1528, 248, 8},
    { 1480, 200, 360},
    { 1336, 264, 472},
    { 1176, 320, 520},
    { 1032, 336, 368},
    { 864, 360, 208},
    { 824, 320, 208},
    { 896, 480, 144},
    { 936, 496, 112},
    { 1120, 592, 80},
    { 1384, 608, 144},
    { 1616, 672, 152},
    { 1336, 464, 144},
    // 11 seconds
    { 1216, 328, 144},
    { 1528, 208, 208},
    { 1688, 88, 296},
    { 1464, -16, 288},
    { 1280, -24, 240},
    { 1136, -16, 184},
    { 936, -40, 192},
    { 776, -24, 144},
    { 648, -40, 64},
    { 568, -112, 16},
    { 696, -88, -56},
    { 1008, -24, -144},
    { 1520, -208, 104},
    { 1792, 0, 272},
    { 1568, 584, -160},
    { 1520, 464, -88},
    { 1504, 16, -336},
    { 928, 296, 544},
    { 1168, 352, 328},
    { 944, 184, 336},
    { 864, 208, 320},
    { 800, 352, 216},
    { 768, 448, 136},
    { 808, 472, 160},
    { 1048, 584, 128},
    // 12 seconds
    { 1384, 488, 208},
    { 1936, 592, 296},
    { 1288, 352, 200},
    { 1200, 376, 80},
    { 1520, 304, 176},
    { 1560, 232, 192},
    { 1344, 128, 160},
    { 1112, -16, 248},
    { 952, -88, 232},
    { 832, -40, 120},
    { 712, -24, 80},
    { 624, -40, 56},
    { 616, -72, 8},
    { 872, 72, -152},
    { 1072, -32, -96},
    { 1576, -320, 272},
    { 1728, 128, 248},
    { 1528, 568, -168},
    { 1344, 368, -72},
    { 1272, 256, 264},
    { 1312, 184, 392},
    { 1176, 296, 368},
    { 912, 448, 192},
    { 768, 368, 72},
    { 832, 488, -16},
    // 13 seconds
    { 824, 480, 8},
    { 1072, 496, 8},
    { 1336, 616, 192},
    { 1816, 416, 328},
    { 1856, 128, 240},
    { 1312, 200, 136},
    { 1416, 224, 216},
    { 1672, 632, 144},
    { 1432, 216, 240},
    { 1192, 0, 328},
    { 1128, 112, 104},
    { 912, -40, 176},
    { 696, -96, 144},
    { 592, -136, 72},
    { 504, -112, -16},
    { 552, -56, -136},
    { 760, 64, -216},
    { 1320, -112, -16},
    { 1976, -144, 400},
    { 1984, 440, 272},
    { 1816, 608, -88},
    { 1584, 496, 96},
    { 1104, 440, 384},
    { 928, 96, 384},
    { 920, -24, 280},
    // 14 seconds
    { 896, 256, 184},
    { 840, 448, 56},
    { 840, 480, -32},
    { 824, 408, 40},
    { 1064, 536, 24},
    { 1216, 432, 168},
    { 1912, 400, 296},
    { 1872, 424, 240},
    { 1160, 272, 128},
    { 1416, 216, 176},
    { 1400, 432, 232},
    { 1448, 168, 184},
    { 1272, -48, 296},
    { 1032, -48, 208},
    { 840, 0, 96},
    { 728, -8, 88},
    { 640, -32, 56},
    { 560, -112, 40},
    { 632, -104, -24},
    { 872, -16, -80},
    { 1312, -80, -72},
    { 1664, -136, 256},
    { 1904, 184, 304},
    { 1848, 512, 0},
    { 1632, 512, 88},
    // 15 seconds
    { 1200, 464, 352},
    { 1000, 264, 344},
    { 968, 104, 312},
    { 952, 160, 280},
    { 808, 416, 104},
    { 768, 448, 32},
    { 840, 552, 40},
    { 1080, 544, 72},
    { 1192, 472, 64},
    { 1736, 248, 288},
    { 1864, 592, 320},
    { 1416, 424, 144},
    { 1544, 304, 216},
    { 1776, 40, 384},
    { 1600, -96, 352},
    { 1352, -96, 296},
    { 1048, -64, 216},
    { 840, -48, 112},
    { 672, -48, 80},
    { 576, -24, -24},
    { 512, -72, -32},
    { 584, -72, -88},
    { 808, 32, -144},
    { 1464, -248, 176},
    { 1960, 48, 440},
    // 16 seconds
    { 1872, 456, 200},
    { 1712, 512, -48},
    { 1472, 504, 168},
    { 1232, 400, 312},
    { 1128, 224, 376},
    { 1048, 272, 256},
    { 968, 328, 160},
    { 912, 496, 40},
    { 896, 544, 24},
    { 896, 552, 40},
    { 1112, 456, 32},
    { 1536, 464, 144},
    { 1976, 496, 296},
    { 1288, 264, 200},
    { 1296, 176, 128},
    { 1640, 104, 248},
    { 1520, 32, 264},
    { 1328, 48, 184},
    { 1144, 24, 184},
    { 976, -24, 192},
    { 840, -24, 136},
    { 744, -32, 136},
    { 648, -32, 72},
    { 704, -64, 16},
    { 848, 16, -104},
    // 17 seconds
    { 1296, -64, -88},
    { 1608, -184, 144},
    { 1464, 208, -40},
    { 1456, 368, -232},
    { 1552, 296, 16},
    { 1392, 216, 336},
    { 1296, 376, 288},
    { 1120, 424, 320},
    { 944, 304, 224},
    { 872, 304, 160},
    { 824, 392, 48},
    { 824, 424, 80},
    { 1008, 544, 40},
    { 1232, 592, 40},
    { 1600, 592, 72},
    { 1784, 440, 128},
    { 1248, 288, 112},
    { 1344, 232, 72},
    { 1584, 80, 192},
    { 1528, 48, 288},
    { 1328, 160, 176},
    { 1152, 96, 152},
    { 984, -8, 200},
    { 880, -32, 168},
    { 776, -48, 104},
    // 18 seconds
    { 648, -72, 8},
    { 576, -144, -48},
    { 696, -88, -104},
    { 1072, -104, -96},
    { 1560, -144, 224},
    { 1688, 288, 240},
    { 1568, 544, -96},
    { 1536, 368, 40},
    { 1432, 328, 296},
    { 1248, 424, 336},
    { 1088, 336, 304},
    { 920, 320, 200},
    { 848, 376, 64},
    { 816, 392, 32},
    { 848, 488, 0},
    { 984, 472, 24},
    { 1200, 512, 32},
    { 1552, 432, 112},
    { 1760, 336, 184},
    { 1320, 208, 152},
    { 1248, 168, 72},
    { 1560, 80, 144},
    { 1568, 64, 208},
    { 1304, 80, 184},
    { 1072, 32, 152},
    // 19 seconds
    { 904, 0, 144},
    { 752, -56, 184},
    { 656, -72, 160},
    { 568, -56, 48},
    { 600, -56, -40},
    { 824, 8, -104},
    { 1184, -104, -32},
    { 1800, -248, 272},
    { 1856, 216, 168},
    { 1704, 560, -200},
    { 1600, 336, -88},
    { 1216, 304, 344},
    { 1000, 280, 360},
    { 936, 136, 304},
    { 920, 192, 240},
    { 808, 264, 192},
    { 768, 368, 16},
    { 744, 384, 64},
    { 912, 448, 48},
    { 1184, 400, 112},
    { 1552, 456, 144},
    { 1872, 472, 168},
    { 1424, 440, 32},
    { 1184, 328, 24},
    { 1520, 160, 152},
    // 20 seconds
    { 1760, 104, 176},
    { 1528, 32, 176},
    { 1248, -64, 208},
    { 952, -96, 144},
    { 736, -40, 64},
    { 592, -112, 64},
    { 456, -136, 0},
    { 448, -120, -48},
    { 632, -48, -56},
    { 944, -8, 40},
    { 1512, -248, 352},
    { 2232, 160, 560},
    { 2088, 752, 312},
    { 1712, 1112, -176},
    { 1176, 1040, 328},
    { 1072, 408, 304},
    { 952, 344, 232},
    { 896, 288, 264},
    { 784, 400, 216},
    { 624, 376, 176},
    { 672, 432, 64},
    { 824, 440, 40},
    { 1088, 416, 80},
    { 1264, 304, 168},
    { 1712, 336, 176},
    // 21 seconds
    { 1680, 432, 112},
    { 1248, 360, 88},
    { 1456, 256, 128},
    { 1584, -8, 24},
    { 1424, 32, 112},
    { 1160, -24, 176},
    { 984, -16, 48},
    { 824, -56, 112},
    { 752, 8, 56},
    { 680, 0, 0},
    { 592, -104, 8},
    { 608, -120, -32},
    { 752, 144, -72},
    { 1240, -104, -32},
    { 1936, -288, 144},
    { 1928, 176, 64},
    { 1776, 384, -184},
    { 1576, 320, -96},
    { 1208, 264, 320},
    { 1056, 152, 352},
    { 1000, 144, 280},
    { 888, 240, 216},
    { 800, 368, 96},
    { 776, 488, -56},
    { 808, 480, 56},
    // 22 seconds
    { 984, 328, 144},
    { 1144, 448, 128},
    { 1640, 400, 136},
    { 1720, 424, 48},
    { 1496, 328, 32},
    { 1528, 184, 64},
    { 2208, 40, -808},
    { 1552, -56, 120},
    { 1328, -136, 296},
    { 984, -40, 152},
    { 832, 40, -40},
    { 704, 8, 0},
    { 520, -104, 48},
    { 448, -112, -16},
    { 536, -120, -72},
    { 792, -32, -72},
    { 1168, -48, 0},
    { 1840, -136, 400},
    { 2360, 320, 352},
    { 2072, 672, -16},
    { 1416, 600, 16},
    { 920, 184, 344},
    { 864, 96, 368},
    { 952, 48, 392},
    { 896, 224, 384},
    // 23 seconds
    { 760, 440, 272},
    { 752, 496, 104},
    { 824, 520, 88},
    { 992, 480, 160},
    { 1192, 488, 224},
    { 1688, 528, 216},
    { 1856, 464, 232},
    { 1464, 376, 192},
    { 1752, 440, 56},
    { 1512, 1352, 944},
    { 1912, 208, -40},
    { 1160, -216, 440},
    { 984, -8, 232},
    { 656, -56, -64},
    { 512, -96, -16},
    { 416, -144, 8},
    { 440, -136, 16},
    { 664, -72, -32},
    { 1072, 8, 56},
    { 1832, -88, 400},
    { 2656, 128, 784},
    { 1680, 952, -32},
    { 1368, 688, -136},
    { 1248, 312, 320},
    { 904, 216, 384},
    // 24 seconds
    { 848, -40, 328},
    { 800, 72, 248},
    { 816, 248, 192},
    { 752, 352, 56},
    { 768, 320, 48},
    { 840, 296, 128},
    { 1168, 384, 64},
    { 1328, 328, 144},
    { 1600, 312, 112},
    { 1528, 256, 64},
    { 1136, 312, 40},
    { 1224, 176, 72},
    { 1048, 112, 584},
    { 1096, 160, 152},
    { 1112, -96, 224},
    { 904, 48, 152},
    { 816, 80, 64},
    { 728, 0, 104},
    { 680, 0, 48},
    { 664, -32, 48},
    { 720, -80, 32},
    { 952, -24, 0},
    { 1256, -152, 112},
    { 1784, -216, 400},
    { 1704, 312, 176},
    // 25 seconds
    { 1336, 664, -272},
    { 1272, 24, -344},
    { 632, -16, 712},
    { 816, 432, 152},
    { 864, 176, 320},
    { 808, 224, 264},
    { 736, 248, 200},
    { 720, 256, 136},
    { 840, 368, 64},
    { 984, 336, 96},
    { 1192, 352, 72},
    { 1448, 144, 208},
    { 1776, 328, 176},
    { 1216, 488, 24},
    { 968, 384, -24},
    { 1544, 480, 24},
    { 1216, -584, 96},
    { 1176, 256, 96},
    { 904, -96, 344},
    { 872, 80, 120},
    { 768, 72, 24},
    { 656, -32, 120},
    { 624, -24, 64},
    { 680, -24, 0},
    { 920, 40, -40},
    // 26 seconds
    { 1184, 8, 40},
    { 1840, -216, 352},
    { 1672, 232, 136},
    { 1280, 600, -240},
    { 1072, 272, 16},
    { 928, 72, 248},
    { 840, 224, 200},
    { 880, 112, 216},
    { 880, 184, 264},
    { 848, 392, 104},
    { 736, 304, 88},
    { 832, 424, -8},
    { 1016, 360, 16},
    { 1248, 424, 16},
    { 1472, 344, 128},
    { 1696, 336, 224},
    { 1216, 424, 104},
    { 1080, 248, 96},
    { 1384, 168, 160},
    { 1464, 64, 296},
    { 1168, 48, 240},
    { 992, 40, 160},
    { 864, 16, 136},
    { 736, -24, 120},
    { 632, -56, 104},
    // 27 seconds
    { 584, -80, 80},
    { 608, -104, 0},
    { 832, 0, -112},
    { 1192, -192, -8},
    { 1840, -288, 384},
    { 1752, 432, 296},
    { 1616, 840, -264},
    { 1392, 480, 48},
    { 976, 424, 320},
    { 824, 0, 320},
    { 856, 40, 264},
    { 848, 216, 208},
    { 792, 424, 40},
    { 768, 376, 24},
    { 840, 440, 0},
    { 1040, 376, 72},
    { 1200, 440, 80},
    { 1768, 352, 264},
    { 1792, 480, 224},
    { 1024, 328, 88},
    { 1096, 248, 136},
    { 1280, 200, 344},
    { 1368, 152, 200},
    { 1104, 16, 280},
    { 944, 8, 200},
    // 28 seconds
    { 872, -8, 128},
    { 784, -72, 176},
    { 720, -16, 104},
    { 680, -32, 48},
    { 752, -64, -8},
    { 880, -16, -8},
    { 1440, -128, 72},
    { 1808, -88, 288},
    { 1536, 432, -24},
    { 1432, 456, -272},
    { 1296, 328, -144},
    { 1104, 360, 480},
    { 1024, 400, 72},
    { 848, 176, 272},
    { 840, 320, 144},
    { 768, 296, 184},
    { 776, 312, 152},
    { 1016, 416, 128},
    { 1136, 440, 88},
    { 1416, 360, 144},
    { 1744, 376, 168},
    { 1144, 368, 144},
    { 968, 288, 64},
    { 1192, 232, 136},
    { 1368, 192, 216},
    // 29 seconds
    { 1296, 88, 240},
    { 1128, 32, 200},
    { 976, 16, 152},
    { 832, 8, 128},
    { 728, 0, 96},
    { 664, -8, 24},
    { 680, -64, -40},
    { 864, -40, -80},
    { 1232, -248, 136},
    { 1832, -104, 376},
    { 1656, 576, 0},
    { 1416, 720, -272},
    { 1080, 104, 120},
    { 968, 16, 296},
    { 1024, 184, 264},
    { 952, 296, 256},
    { 904, 368, 208},
    { 824, 368, 128},
    { 800, 336, 80},
    { 872, 408, 8},
    { 1176, 472, -32},
    { 1216, 440, -8},
    { 1800, 480, -48},
    { 1656, 544, -40},
    { 1032, 320, 40},
    // 30 seconds
    { 1208, 168, 96},
    { 1424, 16, 280},
    { 1280, 80, 248},
    { 1088, 64, 200},
    { 880, -16, 128},
    { 752, -40, 96},
    { 696, -56, 104},
    { 672, -48, 56},
    { 680, -80, 72},
    { 856, -8, 8},
    { 1032, 80, -112},
    { 1512, -136, 0},
    { 1648, -264, 376},
    { 1512, 376, -120},
    { 1512, 560, -280},
    { 1344, 472, 80},
    { 960, 288, 248},
    { 912, 176, 240},
    { 912, 48, 248},
    { 896, 248, 136},
    { 808, 352, 32},
    { 816, 368, -32},
    { 904, 312, 40},
    { 1160, 344, 24},
    { 1272, 264, 136},
    // 31 seconds
    { 1864, 312, 200},
    { 1488, 496, 64},
    { 1048, 320, 40},
    { 1304, 200, 112},
    { 1440, -96, 152},
    { 1200, 144, 120},
    { 1032, 16, 224},
    { 888, -64, 224},
    { 728, -64, 184},
    { 672, -56, 144},
    { 664, -40, 104},
    { 736, -64, 64},
    { 952, 32, -32},
    { 1264, 16, -48},
    { 1656, -152, 192},
    { 1392, 144, 40},
    { 1304, 256, -192},
    { 1440, 312, -224},
    { 1096, 320, 112},
    { 888, 360, 104},
    { 872, 144, 216},
    { 872, 216, 184},
    { 816, 200, 184},
    { 800, 368, 8},
    { 800, 296, 40},
    // 32 seconds
    { 1112, 472, -48},
    { 1240, 448, -24},
    { 1784, 312, 104},
    { 1776, 360, 112},
    { 928, 296, 104},
    { 960, 248, 48},
    { 1272, 136, 168},
    { 1304, 88, 256},
    { 1088, 56, 216},
    { 976, 16, 168},
    { 888, -8, 176},
    { 776, -32, 160},
    { 712, -40, 144},
    { 688, -48, 80},
    { 792, -24, -24},
    { 992, 112, -120},
    { 1392, -232, 80},
    { 1648, -168, 232},
    { 1456, 240, -8},
    { 1304, 384, -256},
    { 1232, 440, 16},
    { 1056, 336, 256},
    { 976, 360, 184},
    { 904, 288, 200},
    { 856, 432, 168},
    // 33 seconds
    { 776, 416, 104},
    { 784, 472, -48},
    { 832, 432, -32},
    { 1104, 552, -104},
    { 1192, 432, 64},
    { 1696, 568, 72},
    { 1344, 600, 72},
    { 1104, 416, 80},
    { 1344, 296, 128},
    { 1432, 176, 200},
    { 1208, 112, 208},
    { 1000, 72, 176},
    { 856, 24, 120},
    { 736, 0, 128},
    { 656, -8, 96},
    { 608, -56, 96},
    { 648, -72, 56},
    { 904, 24, -40},
    { 1184, -64, 24},
    { 1752, -208, 328},
    { 1824, 200, 248},
    { 1424, 704, -272},
    { 1152, 536, -24},
    { 1000, 200, 184},
    { 1024, 272, 160},
    // 34 seconds
    { 960, 376, 152},
    { 880, 440, 152},
    { 776, 400, 64},
    { 712, 328, 40},
    { 872, 368, 16},
    { 1032, 328, 72},
    { 1248, 408, 48},
    { 1688, 376, 160},
    { 1768, 416, 144},
    { 1152, 368, 104},
    { 1128, 352, 56},
    { 1416, 208, 168},
    { 1400, 128, 184},
    { 1160, 56, 192},
    { 968, 8, 160},
    { 824, -48, 160},
    { 696, -56, 136},
    { 608, -56, 80},
    { 576, -88, 64},
    { 664, -80, 8},
    { 952, 40, -56},
    { 1496, -112, 80},
    { 1984, -136, 496},
    { 1752, 480, 80},
    { 1512, 648, -256},
    // 35 seconds
    { 1272, 448, 120},
    { 1016, 288, 336},
    { 928, 176, 272},
    { 904, 160, 224},
    { 856, 320, 160},
    { 776, 376, 40},
    { 784, 336, 24},
    { 864, 408, 0},
    { 1112, 288, 96},
    { 1264, 400, 192},
    { 1848, 400, 496},
    { 1584, 536, 288},
    { 1176, 520, -16},
    { 1456, 360, 32},
    { 472, -760, -544},
    { 1160, 112, 32},
    { 1152, -88, 464},
    { 968, -8, 304},
    { 736, -32, 112},
    { 624, -24, 56},
    { 560, -56, 72},
    { 624, -72, 32},
    { 864, -8, -56},
    { 1128, -72, -32},
    { 1736, -296, 400},
    // 36 seconds
    { 1776, 224, 320},
    { 1568, 584, -168},
    { 1448, 424, -112},
    { 1152, 352, 344},
    { 976, 248, 312},
    { 992, 184, 224},
    { 912, 304, 120},
    { 824, 280, 104},
    { 784, 424, -8},
    { 808, 384, 32},
    { 1032, 456, 24},
    { 1184, 448, 96},
    { 1456, 488, 208},
    { 1792, 488, 176},
    { 1312, 400, 96},
    { 1328, 392, 40},
    { 1616, 416, 8},
    { 1472, 232, 192},
    { 1280, 40, 336},
    { 1096, -168, 376},
    { 928, -112, 224},
    { 800, -56, 104},
    { 664, 48, 32},
    { 632, -8, 40},
    { 664, -56, -16},
    // 37 seconds
    { 808, 56, -128},
    { 1432, 8, 16},
    { 1584, -128, 88},
    { 1544, 56, -32},
    { 1600, 224, -200},
    { 1528, 360, 16},
    { 1288, 248, 288},
    { 1280, 352, 312},
    { 1088, 344, 224},
    { 928, 360, 152},
    { 800, 328, 56},
    { 768, 344, 16},
    { 824, 416, 8},
    { 1128, 528, -16},
    { 1264, 584, 48},
    { 1648, 288, 96},
    { 1728, 144, 104},
    { 1408, 192, 88},
    { 1440, 208, 40},
    { 1608, 168, 136},
    { 1432, 88, 232},
    { 1232, 32, 216},
    { 1080, -32, 216},
    { 920, -72, 240},
    { 784, -72, 208},
    // 38 seconds
    { 680, -112, 176},
    { 632, -120, 72},
    { 696, -40, -40},
    { 880, 16, -136},
    { 1512, -288, 184},
    { 1704, 144, 120},
    { 1400, 296, -136},
    { 1504, 248, -208},
    { 1576, 384, 72},
    { 1344, 352, 296},
    { 1200, 528, 296},
    { 944, 360, 208},
    { 856, 248, 128},
    { 848, 264, 128},
    { 872, 392, 64},
    { 880, 384, 72},
    { 1176, 560, -8},
    { 1344, 480, 200},
    { 1824, 536, 224},
    { 1296, 248, 192},
    { 1144, 352, 104},
    { 1528, 304, 136},
    { 1608, 200, 224},
    { 1400, 88, 264},
    { 1144, -16, 264},
    // 39 seconds
    { 1016, -16, 216},
    { 952, -24, 152},
    { 832, -32, 144},
    { 712, -16, 48},
    { 672, -56, -32},
    { 776, -32, -96},
    { 1104, -120, -96},
    { 1512, -256, 232},
    { 1720, 152, 176},
    { 1384, 536, -192},
    { 1368, 432, -80},
    { 1408, 168, 368},
    { 1328, 408, 312},
    { 1176, 432, 400},
    { 920, 360, 208},
    { 720, 336, 80},
    { 752, 416, 0},
    { 816, 560, -8},
    { 1040, 576, 80},
    { 1264, 520, 168},
    { 1680, 424, 184},
    { 1720, 512, 144},
    { 1232, 328, 160},
    { 1376, 88, 272},
    { 1592, -56, 296},
    // 40 seconds
    { 1568, 56, 232},
    { 1264, 24, 200},
    { 944, 48, 32},
    { 776, 8, 0},
    { 520, -56, 40},
    { 432, -88, 16},
    { 504, -128, 0},
    { 680, -80, -40},
    { 1048, 16, 0},
    { 1536, -128, 288},
    { 2112, -40, 592},
    { 1728, 648, -40},
    { 1552, 608, -200},
    { 1280, 408, 128},
    { 968, 232, 256},
    { 896, 128, 184},
    { 904, 176, 168},
    { 880, 392, 128},
    { 768, 424, 64},
    { 744, 416, 16},
    { 792, 304, 120},
    { 1000, 360, 120},
    { 1240, 304, 224},
    { 1512, 208, 368},
    { 1976, 288, 472},
    // 41 seconds
    { 1512, 416, 264},
    { 1456, 288, 0},
    { 432, -544, -448},
    { 1104, -128, 272},
    { 1184, 8, 360},
    { 952, 104, 40},
    { 768, -8, 16},
    { 592, -72, 72},
    { 536, -40, 8},
    { 552, -56, -16},
    { 624, -64, -8},
    { 920, -24, -24},
    { 1224, -48, 88},
    { 2064, -200, 512},
    { 2136, 296, 432},
    { 1768, 912, -88},
    { 1336, 624, 40},
    { 960, 232, 416},
    { 784, -136, 392},
    { 896, 56, 264},
    { 872, 288, 200},
    { 824, 488, 128},
    { 776, 480, 88},
    { 808, 416, 120},
    { 904, 352, 160},
    // 42 seconds
    { 1232, 272, 144},
    { 1512, 272, 248},
    { 1960, 264, 304},
    { 1560, 304, 312},
    { 1208, 216, 144},
    { 904, -112, 176},
    { 1056, -240, -296},
    { 1120, 168, 288},
    { 912, 16, 336},
    { 832, 40, 112},
    { 720, -16, 80},
    { 648, -72, 160},
    { 664, -40, 104},
    { 720, -48, 72},
    { 976, 56, -24},
    { 1472, -120, 128},
    { 1896, -192, 424},
    { 1320, 368, 64},
    { 1192, 600, -264},
    { 1184, 232, 0},
    { 1048, 88, 288},
    { 992, 80, 240},
    { 936, 208, 160},
    { 904, 296, 104},
    { 848, 320, 80},
    // 43 seconds
    { 888, 376, -16},
    { 856, 336, 24},
    { 1104, 384, -8},
    { 1304, 368, 48},
    { 1856, 312, 216},
    { 1776, 312, 216},
    { 1144, 336, 24},
    { 1152, 264, 32},
    { 1456, 96, 160},
    { 1376, 40, 216},
    { 1072, -16, 232},
    { 872, -40, 168},
    { 720, -64, 144},
    { 600, -72, 152},
    { 576, -72, 120},
    { 592, -72, 80},
    { 696, 24, -88},
    { 984, 80, -104},
    { 1632, -240, 240},
    { 2288, -152, 592},
    { 1544, 752, -112},
    { 1256, 784, -392},
    { 968, 336, 152},
    { 824, -88, 416},
    { 888, 56, 200},
    // 44 seconds
    { 896, 120, 168},
    { 960, 432, 32},
    { 840, 464, -16},
    { 832, 424, -64},
    { 864, 312, 48},
    { 1096, 336, 64},
    { 1216, 296, 80},
    { 1664, 344, 184},
    { 1944, 376, 160},
    { 1120, 408, 144},
    { 1144, 352, 160},
    { 1384, 160, 256},
    { 1264, 104, 264},
    { 1056, 48, 232},
    { 848, 8, 168},
    { 688, -32, 136},
    { 560, -48, 112},
    { 528, -24, 88},
    { 544, -80, 152},
    { 648, 24, 136},
    { 920, 352, 56},
    { 1600, 224, 192},
    { 1976, 400, 408},
    { 1368, 912, -56},
    { 928, 448, -184},
    // 45 seconds
    { 904, 320, -16},
    { 880, 328, 184},
    { 832, 232, 208},
    { 816, 176, 184},
    { 816, 160, 304},
    { 800, 264, 344},
    { 776, 224, 336},
    { 848, 280, 360},
    { 1064, 376, 288},
    { 1200, 488, 208},
    { 1592, 600, 200},
    { 1624, 720, 216},
    { 1128, 608, 120},
    { 1048, 440, 8},
    { 1176, 200, 8},
    { 1248, 192, 32},
    { 1072, -48, 184},
    { 904, -48, 160},
    { 920, 64, 152},
    { 808, 24, 48},
    { 728, -8, 8},
    { 696, -120, 80},
    { 752, -112, 40},
    { 936, 32, -40},
    { 1576, -96, 64},
    // 46 seconds
    { 1648, -112, 184},
    { 1464, 272, -40},
    { 1272, 432, -224},
    { 1136, 320, -16},
    { 864, 176, 232},
    { 960, 144, 168},
    { 936, 128, 192},
    { 968, 344, 40},
    { 856, 400, -24},
    { 888, 408, -64},
    { 888, 312, 0},
    { 1136, 240, 32},
    { 1224, 216, 120},
    { 1824, 232, 168},
    { 1656, 368, 128},
    { 1096, 256, 120},
    { 1272, 72, 104},
    { 1432, -264, 232},
    { 1152, 40, 256},
    { 968, 32, 192},
    { 832, 8, 136},
    { 680, -40, 168},
    { 616, -64, 136},
    { 632, -64, 104},
    { 664, -56, 64},
    // 47 seconds
    { 872, 32, -48},
    { 1080, 24, -16},
    { 1704, -312, 328},
    { 1992, 8, 440},
    { 1584, 704, -136},
    { 1256, 656, -288},
    { 896, 328, 184},
    { 872, 72, 272},
    { 912, 96, 216},
    { 880, 152, 232},
    { 848, 384, 112},
    { 784, 392, 24},
    { 840, 352, 16},
    { 960, 320, 0},
    { 1168, 312, 8},
    { 1320, 224, 160},
    { 1776, 264, 152},
    { 1512, 336, 144},
    { 944, 304, 72},
    { 1176, 224, 24},
    { 1424, -216, 112},
    { 1160, 312, 176},
    { 968, 24, 272},
    { 880, -32, 192},
    { 808, -56, 160},
    // 48 seconds
    { 736, -48, 160},
    { 680, -16, 104},
    { 712, -40, 64},
    { 864, 24, -32},
    { 1024, 64, -96},
    { 1640, -120, 128},
    { 1808, -48, 376},
    { 1128, 552, -120},
    { 1176, 544, -336},
    { 1032, 208, 120},
    { 944, 136, 272},
    { 896, 72, 304},
    { 896, 200, 200},
    { 832, 320, 112},
    { 800, 384, 0},
    { 816, 344, -8},
    { 904, 328, 0},
    { 1184, 352, -8},
    { 1288, 336, 8},
    { 1888, 288, 144},
    { 1392, 400, 80},
    { 1056, 272, 32},
    { 1232, 216, 88},
    { 1344, 104, 160},
    { 1128, 96, 152},
    // 49 seconds
    { 936, 40, 176},
    { 816, 32, 112},
    { 720, -8, 120},
    { 664, -40, 128},
    { 656, -64, 120},
    { 696, -72, 80},
    { 904, 56, -40},
    { 1160, 56, -24},
    { 1680, -192, 272},
    { 1616, 128, 176},
    { 1336, 512, -232},
    { 1192, 400, -168},
    { 952, 184, 152},
    { 936, 208, 136},
    { 928, 160, 152},
    { 880, 280, 136},
    { 856, 344, 56},
    { 832, 344, -8},
    { 872, 336, -8},
    { 1064, 328, 0},
    { 1256, 376, -64},
    { 1640, 232, 112},
    { 1888, 392, 104},
    { 944, 320, 40},
    { 936, 288, -24},
    // 50 seconds
    { 1280, 160, 104},
    { 1272, 88, 152},
    { 1048, 96, 128},
    { 888, 8, 160},
    { 768, -8, 136},
    { 696, -40, 136},
    { 656, -48, 128},
    { 664, -64, 120},
    { 792, -8, 32},
    { 1032, 136, -88},
    { 1576, -112, 88},
    { 1920, -120, 336},
    { 1392, 488, -224},
    { 1128, 464, -336},
    { 976, 80, -56},
    { 808, -40, 232},
    { 968, 128, 184},
    { 944, 224, 168},
    { 880, 400, 120},
    { 768, 304, 48},
    { 792, 304, -16},
    { 936, 288, 0},
    { 1168, 312, -16},
    { 1232, 264, -24},
    { 1856, 128, 16},
    // 51 seconds
    { 1624, 256, -8},
    { 1104, 192, 32},
    { 1080, 128, 56},
    { 1080, -120, 248},
    { 1144, 48, 128},
    { 1000, 16, 208},
    { 920, 0, 192},
    { 856, 16, 136},
    { 752, -40, 168},
    { 712, -32, 128},
    { 688, -56, 96},
    { 832, -48, 32},
    { 1040, 8, 0},
    { 1576, -224, 168},
    { 1736, -40, 240},
    { 1312, 496, -272},
    { 1184, 416, -288},
    { 1104, 160, 8},
    { 1024, 88, 360},
    { 1016, 504, 96},
    { 960, 312, 296},
    { 832, 296, 120},
    { 744, 288, 40},
    { 768, 272, 24},
    { 832, 256, 16},
    // 52 seconds
    { 1064, 232, 32},
    { 1232, 272, 32},
    { 1704, 232, 72},
    { 1672, 424, 8},
    { 992, 264, 112},
    { 1048, 120, 104},
    { 1208, 128, 104},
    { 1168, 128, 136},
    { 1008, 88, 152},
    { 912, 72, 120},
    { 872, 0, 192},
    { 872, 0, 176},
    { 832, -32, 144},
    { 768, -32, 64},
    { 816, -16, -16},
    { 960, 80, -112},
    { 1320, -72, -72},
    { 1480, -240, 224},
    { 1296, 168, 40},
    { 1312, 352, -160},
    { 1272, 168, 40},
    { 1104, 136, 248},
    { 1056, 216, 256},
    { 1000, 344, 232},
    { 928, 312, 232},
    // 53 seconds
    { 856, 288, 168},
    { 832, 296, 56},
    { 864, 312, 0},
    { 1080, 360, -40},
    { 1224, 432, -32},
    { 1776, 416, 96},
    { 1888, 472, 208},
    { 1040, 264, 96},
    { 1120, 136, 112},
    { 1408, 32, 272},
    { 1488, 72, 304},
    { 1232, 16, 256},
    { 1048, -32, 208},
    { 936, -48, 216},
    { 832, -40, 184},
    { 768, -56, 160},
    { 760, -72, 88},
    { 768, -40, -32},
    { 856, 24, -136},
    { 1248, -248, 32},
    { 1680, 32, 216},
    { 1312, 392, 24},
    { 1312, 400, -96},
    { 1368, 424, 0},
    { 1168, 248, 224},
    // 54 seconds
    { 1120, 400, 184},
    { 1016, 328, 224},
    { 928, 328, 200},
    { 840, 360, 80},
    { 824, 464, 24},
    { 880, 528, -24},
    { 1224, 608, -72},
    { 1344, 584, 104},
    { 1776, 592, 128},
    { 1440, 416, 40},
    { 1128, 264, 104},
    { 1416, 200, 184},
    { 1496, 72, 232},
    { 1328, 96, 208},
    { 1080, 48, 208},
    { 944, 56, 128},
    { 824, 24, 104},
    { 752, 16, 96},
    { 672, -48, 112},
    { 648, -112, 96},
    { 784, 0, -96},
    { 960, -16, -104},
    { 1440, -232, 120},
    { 1632, 0, 240},
    { 1472, 368, 0},
    // 55 seconds
    { 1576, 472, -112},
    { 1384, 352, 232},
    { 1120, 176, 320},
    { 1104, 216, 232},
    { 1048, 264, 200},
    { 944, 376, 80},
    { 848, 432, -16},
    { 840, 496, -48},
    { 880, 472, -8},
    { 1128, 472, 16},
    { 1320, 400, 128},
    { 1816, 384, 192},
    { 1520, 344, 192},
    { 1256, 208, 176},
    { 1360, 128, 184},
    { 1408, 56, 224},
    { 1248, 88, 216},
    { 1016, 16, 200},
    { 896, 16, 112},
    { 808, 8, 96},
    { 736, -16, 128},
    { 672, -56, 120},
    { 672, -64, 88},
    { 824, 0, -32},
    { 1008, -40, -128},
    // 56 seconds
    { 1512, -176, 64},
    { 1624, 64, 128},
    { 1392, 448, -232},
    { 1304, 416, -248},
    { 1064, 192, 160},
    { 1120, 176, 168},
    { 1072, 312, 168},
    { 1016, 328, 144},
    { 912, 368, 80},
    { 800, 352, 16},
    { 832, 384, -40},
    { 960, 432, -80},
    { 1184, 384, -72},
    { 1272, 232, 40},
    { 1776, 264, 128},
    { 1368, 424, 88},
    { 912, 264, 72},
    { 1200, 216, 88},
    { 1392, 64, 224},
    { 1176, 32, 216},
    { 976, 64, 144},
    { 912, 64, 80},
    { 840, 32, 80},
    { 800, 16, 80},
    { 752, -8, 112},
    // 57 seconds
    { 768, -64, 72},
    { 904, 8, 24},
    { 1280, -112, -24},
    { 1496, -216, 96},
    { 1360, 88, 32},
    { 1120, 328, -216},
    { 1296, 344, -256},
    { 1192, 144, 64},
    { 1120, 272, 104},
    { 1040, 264, 216},
    { 952, 328, 176},
    { 840, 240, 120},
    { 744, 320, 24},
    { 792, 288, 32},
    { 1016, 280, 40},
    { 1208, 256, -24},
    { 1304, 320, -24},
    { 1888, 432, 96},
    { 1400, 544, 160},
    { 864, 248, 24},
    { 1208, 216, 80},
    { 1440, 120, 216},
    { 1264, 96, 184},
    { 1040, -24, 208},
    { 864, -24, 144},
    // 58 seconds
    { 736, -16, 112},
    { 696, -24, 120},
    { 672, -32, 88},
    { 752, -40, 72},
    { 896, 48, -40},
    { 1080, 56, -128},
    { 1544, -240, 152},
    { 1552, -48, 304},
    { 1232, 520, -64},
    { 1368, 616, -128},
    { 1032, 328, 88},
    { 904, 192, 320},
    { 864, 56, 328},
    { 864, 152, 248},
    { 816, 264, 264},
    { 824, 432, 136},
    { 896, 392, 192},
    { 936, 512, 144},
    { 1104, 480, 104},
    { 1392, 360, 216},
    { 1696, 440, 256},
    { 1192, 512, 192},
    { 960, 296, 144},
    { 1232, 136, 232},
    { 1368, 80, 272},
    // 59 seconds
    { 1128, 0, 320},
    { 960, -8, 224},
    { 896, 16, 152},
    { 840, -16, 136},
    { 784, -16, 120},
    { 736, -32, 80},
    { 760, -48, 8},
    { 864, -24, -48},
    { 1104, -88, 24},
    { 1560, -200, 200},
    { 1552, 136, 144},
    { 1368, 456, -184},
    { 1368, 320, -56},
    { 1112, 184, 256},
    { 1008, 224, 240},
    { 952, 208, 256},
    { 888, 200, 200},
    { 824, 272, 128},
    { 824, 280, 72},
    { 856, 376, -32},
    { 952, 368, -32},
    { 1248, 352, 16},
    { 1280, 256, 144},
    { 1784, 208, 152},
    { 1456, 328, 120},
    // 60 seconds
    // elapsed: 1 minutes
    { 1088, 232, 152},
    { 1256, 184, 160},
    { 1576, -704, -128},
    { 1200, 40, 208},
    { 960, 16, 248},
    { 800, 48, 104},
    { 680, 16, 48},
    { 616, -40, 104},
    { 656, -48, 120},
    { 720, -56, 64},
    { 1008, -16, 40},
    { 1200, 0, 40},
    { 1712, -216, 320},
    { 1792, 88, 360},
    { 1352, 848, -120},
    { 920, 432, 144},
    { 952, 160, 280},
    { 944, 176, 288},
    { 856, 80, 312},
    { 816, 256, 224},
    { 760, 312, 152},
    { 736, 304, 112},
    { 840, 320, 80},
    { 968, 360, 0},
    { 1184, 288, 56},
    // 61 seconds
    { 1312, 288, 112},
    { 1768, 296, 128},
    { 1432, 336, 80},
    { 928, 216, 160},
    { 1328, 296, 128},
    { 1296, -248, 64},
    { 1112, 128, 240},
    { 920, 0, 256},
    { 864, 24, 144},
    { 792, 0, 104},
    { 720, -16, 104},
    { 712, -40, 96},
    { 760, -40, 40},
    { 912, -16, -8},
    { 1120, -104, 16},
    { 1560, -216, 264},
    { 1520, 160, 304},
    { 1328, 536, -72},
    { 1272, 456, -144},
    { 1008, 152, 240},
    { 880, 320, 144},
    { 880, 88, 248},
    { 872, 160, 192},
    { 864, 312, 72},
    { 896, 320, -48},
    // 62 seconds
    { 896, 296, -72},
    { 1040, 256, -40},
    { 1272, 312, -24},
    { 1576, 232, 96},
    { 2032, 392, 88},
    { 1072, 360, 88},
    { 912, 144, 56},
    { 1336, 128, 104},
    { 1368, 72, 280},
    { 1152, 56, 216},
    { 976, -8, 224},
    { 824, 16, 168},
    { 768, 8, 136},
    { 720, 0, 120},
    { 688, -40, 104},
    { 760, -40, -8},
    { 920, -40, -56},
    { 1224, -264, 160},
    { 1744, -152, 288},
    { 1464, 424, -56},
    { 1256, 528, -400},
    { 1256, 184, -16},
    { 936, 272, 528},
    { 1032, 592, 72},
    { 960, 304, 256},
    // 63 seconds
    { 824, 408, 104},
    { 760, 296, 120},
    { 768, 320, 16},
    { 848, 296, 24},
    { 1104, 352, -24},
    { 1192, 328, -16},
    { 1680, 248, 48},
    { 1728, 368, 40},
    { 1088, 296, 96},
    { 1120, 192, 32},
    { 1328, 136, 152},
    { 1280, 112, 192},
    { 1104, 48, 200},
    { 960, 16, 176},
    { 888, -24, 160},
    { 832, 0, 88},
    { 800, 32, 72},
    { 784, -64, 96},
    { 768, -136, 16},
    { 832, -80, -112},
    { 1256, -264, 0},
    { 1696, 128, 184},
    { 1384, 488, 8},
    { 1472, 624, -168},
    { 1376, 704, 136},
    // 64 seconds
    { 1056, 536, 144},
    { 944, 288, 120},
    { 888, 392, 176},
    { 880, 288, 208},
    { 752, 344, 72},
    { 760, 368, 40},
    { 824, 488, -24},
    { 1080, 560, -56},
    { 1176, 560, 24},
    { 1784, 688, 96},
    { 1280, 592, 224},
    { 1112, 360, 136},
    { 1344, 384, 72},
    { 1440, 0, 88},
    { 1264, 152, 176},
    { 1080, 80, 184},
    { 896, 32, 136},
    { 768, 0, 120},
    { 712, -32, 120},
    { 656, -56, 136},
    { 608, -120, 120},
    { 840, -24, 16},
    { 1232, 48, -40},
    { 1768, -72, 192},
    { 1744, 288, 80},
    // 65 seconds
    { 1448, 672, -352},
    { 1264, 352, -168},
    { 872, 72, 704},
    { 936, 320, 104},
    { 920, 64, 248},
    { 888, 248, 208},
    { 784, 248, 176},
    { 752, 312, 96},
    { 808, 368, 40},
    { 1024, 392, 40},
    { 1192, 480, -16},
    { 1520, 376, 40},
    { 1696, 312, -48},
    { 1144, 328, -8},
    { 1024, 272, -24},
    { 1296, 152, 16},
    { 1328, 48, 96},
    { 1176, 32, 128},
    { 1088, 88, 144},
    { 1024, 32, 160},
    { 880, -40, 88},
    { 776, -72, 72},
    { 736, -96, 32},
    { 752, -104, -24},
    { 984, 40, -128},
    // 66 seconds
    { 1128, -56, -112},
    { 1504, -240, 152},
    { 1512, 24, 168},
    { 1360, 352, -64},
    { 1328, 248, -32},
    { 1216, 184, 248},
    { 1136, 256, 288},
    { 1056, 264, 376},
    { 968, 376, 272},
    { 856, 288, 200},
    { 832, 376, 72},
    { 872, 376, 16},
    { 1016, 448, -104},
    { 1192, 376, 0},
    { 1616, 456, 40},
    { 1824, 456, 72},
    { 1160, 376, 40},
    { 1184, 208, 96},
    { 1480, 48, 232},
    { 1480, -8, 264},
    { 1264, 8, 256},
    { 1024, -8, 200},
    { 840, -8, 160},
    { 728, 8, 88},
    { 656, -16, 104},
    // 67 seconds
    { 664, -40, 96},
    { 712, -72, 24},
    { 920, 16, -88},
    { 1200, -128, 16},
    { 1656, -200, 240},
    { 1624, 224, 64},
    { 1464, 528, -320},
    { 1408, 368, -120},
    { 1088, -8, 288},
    { 1088, 432, 152},
    { 1000, 176, 288},
    { 944, 224, 232},
    { 880, 280, 136},
    { 856, 288, 32},
    { 872, 344, -16},
    { 984, 344, -32},
    { 1232, 408, -32},
    { 1512, 344, -32},
    { 1768, 272, 40},
    { 1240, 320, 56},
    { 1064, 184, 80},
    { 1304, 152, 96},
    { 1368, 96, 200},
    { 1200, 96, 208},
    { 1040, 56, 208},
    // 68 seconds
    { 976, 40, 176},
    { 936, -32, 208},
    { 840, 8, 136},
    { 792, -32, 96},
    { 736, -48, 24},
    { 840, 48, -112},
    { 928, -32, -120},
    { 1376, -216, -24},
    { 1424, -104, 128},
    { 1288, 248, -112},
    { 1384, 264, -168},
    { 1416, 208, 152},
    { 1288, 208, 280},
    { 1200, 336, 304},
    { 1072, 424, 304},
    { 888, 328, 192},
    { 840, 296, 104},
    { 888, 424, 40},
    { 896, 392, 0},
    { 1120, 464, -56},
    { 1272, 432, 48},
    { 1800, 480, 120},
    { 1536, 448, 120},
    { 1064, 264, 96},
    { 1360, 160, 144},
    // 69 seconds
    { 1632, 56, 280},
    { 1472, 80, 280},
    { 1240, -24, 296},
    { 1072, -24, 232},
    { 968, 0, 168},
    { 888, 8, 128},
    { 792, -16, 96},
    { 672, -136, 56},
    { 696, -104, -88},
    { 880, 8, -208},
    { 1336, -176, 40},
    { 1560, -80, 128},
    { 1552, 256, -88},
    { 1640, 200, 8},
    { 1744, 184, 336},
    { 1504, 408, 408},
    { 1192, 440, 456},
    { 976, 248, 280},
    { 936, 264, 176},
    { 848, 320, 120},
    { 856, 416, 40},
    { 832, 528, 0},
    { 1104, 536, -24},
    { 1216, 504, 24},
    { 1680, 408, 96},
    // 70 seconds
    { 1696, 352, 176},
    { 1224, 224, 184},
    { 1400, 136, 192},
    { 1736, -8, 312},
    { 1552, -56, 376},
    { 1384, 16, 272},
    { 1176, 32, 192},
    { 1008, 0, 152},
    { 880, -16, 128},
    { 768, -48, 80},
    { 592, -144, 16},
    { 552, -168, -56},
    { 736, -48, -192},
    { 1208, -56, -104},
    { 1648, 16, 368},
    { 1560, 600, 184},
    { 1392, 672, -32},
    { 1352, 456, 120},
    { 1304, 280, 432},
    { 1232, 288, 416},
    { 1136, 328, 416},
    { 984, 472, 328},
    { 808, 352, 224},
    { 792, 416, 144},
    { 864, 424, 136},
    // 71 seconds
    { 1032, 472, 40},
    { 1160, 504, 40},
    { 1648, 552, 72},
    { 1664, 520, 144},
    { 1088, 328, 112},
    { 1248, 248, 96},
    { 1560, 152, 216},
    { 1520, 64, 296},
    { 1264, 16, 264},
    { 1112, 32, 152},
    { 992, -16, 168},
    { 864, -24, 144},
    { 760, -48, 104},
    { 656, -96, 56},
    { 672, -88, -32},
    { 840, 104, -224},
    { 1248, -96, -72},
    { 1544, -176, 272},
    { 1504, 264, 120},
    { 1480, 408, -40},
    { 1448, 416, 112},
    { 1272, 320, 304},
    { 1168, 320, 344},
    { 1072, 328, 368},
    { 952, 304, 288},
    // 72 seconds
    { 856, 344, 160},
    { 840, 392, 120},
    { 904, 472, 40},
    { 1104, 488, 40},
    { 1248, 528, 80},
    { 1744, 552, 144},
    { 1520, 464, 168},
    { 1096, 264, 96},
    { 1408, 224, 112},
    { 1696, 56, 224},
    { 1416, 48, 224},
    { 1208, 40, 208},
    { 1048, 0, 192},
    { 888, -32, 192},
    { 816, -24, 144},
    { 728, -48, 120},
    { 640, -96, 56},
    { 704, -88, -16},
    { 864, 48, -160},
    { 1344, -120, -24},
    { 1616, -200, 224},
    { 1520, 240, 72},
    { 1496, 432, -176},
    { 1480, 320, 72},
    { 1304, 296, 304},
    // 73 seconds
    { 1184, 368, 336},
    { 992, 264, 288},
    { 896, 272, 168},
    { 840, 304, 88},
    { 864, 424, -16},
    { 864, 416, 16},
    { 1160, 496, -48},
    { 1296, 424, 64},
    { 1704, 512, 112},
    { 1472, 464, 168},
    { 1144, 288, 120},
    { 1400, 224, 112},
    { 1576, 40, 256},
    { 1384, 40, 256},
    { 1208, 24, 216},
    { 1048, -16, 192},
    { 896, -32, 176},
    { 792, -40, 128},
    { 680, -64, 96},
    { 616, -104, 56},
    { 784, -24, -56},
    { 952, 40, -176},
    { 1472, -208, -16},
    { 1656, -88, 200},
    { 1512, 272, -16},
    // 74 seconds
    { 1520, 448, -232},
    { 1336, 400, 104},
    { 1144, 248, 256},
    { 1080, 296, 272},
    { 1008, 288, 304},
    { 896, 296, 232},
    { 768, 336, 160},
    { 808, 384, 88},
    { 880, 432, 72},
    { 1152, 408, 104},
    { 1568, 696, 96},
    { 1752, 704, 72},
    { 1352, 496, 24},
    { 1272, 344, 88},
    { 1544, 152, 192},
    { 1472, 0, 232},
    { 1312, 16, 224},
    { 1072, -40, 240},
    { 848, -48, 192},
    { 728, -40, 120},
    { 640, -32, 96},
    { 624, -32, 56},
    { 648, -48, -32},
    { 880, 24, -104},
    { 1184, -104, -16},
    // 75 seconds
    { 1800, -240, 296},
    { 1816, 208, 248},
    { 1440, 536, -112},
    { 1288, 360, -80},
    { 1064, 192, 272},
    { 1056, 128, 328},
    { 1040, 192, 264},
    { 936, 288, 168},
    { 824, 344, 88},
    { 824, 384, -96},
    { 824, 336, -40},
    { 992, 528, -32},
    { 1280, 456, 72},
    { 1488, 256, 264},
    { 1792, 192, 256},
    { 1392, 296, 120},
    { 1104, 264, 136},
    { 1392, 128, 240},
    { 1432, 40, 232},
    { 1240, 40, 192},
    { 968, 0, 192},
    { 792, 16, 96},
    { 696, -8, 64},
    { 624, -48, 64},
    { 576, -80, 64},
    // 76 seconds
    { 640, -88, 24},
    { 888, 8, -72},
    { 1160, 8, -24},
    { 1784, -216, 280},
    { 1880, 112, 352},
    { 1568, 648, -184},
    { 1336, 344, -80},
    { 1040, 200, 280},
    { 976, 128, 336},
    { 944, 160, 248},
    { 888, 248, 216},
    { 832, 352, 136},
    { 800, 360, 80},
    { 840, 416, 32},
    { 952, 360, 56},
    { 1176, 432, -24},
    { 1456, 304, 112},
    { 1912, 304, 200},
    { 1344, 320, 144},
    { 1136, 264, 96},
    { 1384, 120, 168},
    { 1504, -752, 80},
    { 1232, 40, 304},
    { 968, -48, 264},
    { 840, 40, 88},
    // 77 seconds
    { 744, 16, 72},
    { 648, -32, 96},
    { 624, -64, 80},
    { 656, -80, 24},
    { 976, 32, -96},
    { 1200, -24, -24},
    { 1792, -192, 208},
    { 1712, 224, 80},
    { 1576, 616, -272},
    { 1568, 272, -232},
    { 912, 136, 336},
    { 872, 192, 264},
    { 904, 112, 264},
    { 840, 168, 264},
    { 824, 296, 176},
    { 784, 336, 56},
    { 792, 344, 72},
    { 1024, 448, -8},
    { 1280, 320, 56},
    { 1544, 336, 88},
    { 1744, 320, 128},
    { 1168, 400, 72},
    { 1080, 264, 88},
    { 1360, 112, 160},
    { 1328, 0, 248},
    // 78 seconds
    { 1120, 16, 256},
    { 960, 16, 184},
    { 864, 16, 136},
    { 784, -32, 144},
    { 712, -40, 120},
    { 680, -48, 96},
    { 728, -56, 8},
    { 976, 56, -96},
    { 1312, -104, 0},
    { 1632, -216, 248},
    { 1560, 160, 136},
    { 1376, 448, -184},
    { 1216, 304, -88},
    { 800, -8, 632},
    { 1112, 520, 184},
    { 1016, 352, 216},
    { 872, 216, 232},
    { 792, 336, 72},
    { 728, 272, 120},
    { 880, 440, -24},
    { 960, 328, 24},
    { 1224, 464, -8},
    { 1776, 328, 144},
    { 1968, 440, 248},
    { 1112, 280, 96},
    // 79 seconds
    { 1120, 240, 64},
    { 1448, 160, 176},
    { 1504, 56, 248},
    { 1232, 48, 240},
    { 1120, 24, 168},
    { 1008, -48, 176},
    { 856, -16, 96},
    { 736, -16, 40},
    { 584, -56, 0},
    { 488, -104, -40},
    { 744, 8, -104},
    { 1048, -88, -88},
    { 1576, -264, 200},
    { 1776, 56, 304},
    { 1680, 392, 16},
    { 1640, 448, -48},
    { 1392, 384, 256},
    { 1080, 296, 360},
    { 984, 160, 296},
    { 976, 152, 224},
    { 912, 304, 136},
    { 856, 344, 8},
    { 840, 448, -48},
    { 920, 472, -32},
    { 1224, 512, -48},
    // 80 seconds
    { 1328, 320, 128},
    { 1816, 392, 104},
    { 1488, 384, 168},
    { 1224, 144, 160},
    { 1544, 80, 176},
    { 1600, 16, 296},
    { 1384, 24, 288},
    { 1168, 32, 208},
    { 1024, 0, 192},
    { 904, -40, 200},
    { 816, -64, 176},
    { 792, -104, 160},
    { 696, -184, 64},
    { 720, -168, -152},
    { 1072, -128, -200},
    { 1472, -248, 120},
    { 1760, 16, 304},
    { 1736, 480, -64},
    { 1672, 208, 184},
    { 1512, 208, 320},
    { 1384, 408, 344},
    { 1224, 456, 352},
    { 1016, 416, 344},
    { 800, 408, 200},
    { 744, 392, 96},
    // 81 seconds
    { 792, 432, 120},
    { 976, 480, 64},
    { 1192, 480, 40},
    { 1448, 368, 136},
    { 1848, 384, 184},
    { 1456, 312, 216},
    { 1400, 152, 184},
    { 1680, 8, 312},
    { 1592, -24, 304},
    { 1424, -32, 296},
    { 1160, -32, 264},
    { 976, -24, 192},
    { 832, -32, 144},
    { 720, -16, 88},
    { 624, -72, 40},
    { 592, -112, -24},
    { 784, -32, -184},
    { 1016, -120, -136},
    { 1560, -296, 104},
    { 1752, 104, 176},
    { 1624, 384, -88},
    { 1688, 312, -56},
    { 1480, 256, 280},
    { 1320, 304, 376},
    { 1208, 400, 408},
    // 82 seconds
    { 976, 288, 272},
    { 896, 248, 144},
    { 904, 344, 104},
    { 904, 472, 16},
    { 864, 456, -16},
    { 1240, 552, -40},
    { 1640, 424, 88},
    { 1856, 488, 104},
    { 1296, 280, 120},
    { 1360, 192, 96},
    { 1552, 96, 208},
    { 1624, 88, 264},
    { 1320, 0, 304},
    { 1088, -24, 224},
    { 944, -32, 192},
    { 824, -40, 168},
    { 768, -40, 128},
    { 688, -96, 128},
    { 680, -112, 40},
    { 816, -8, -144},
    { 1360, -184, -32},
    { 1752, -160, 312},
    { 1472, 336, 0},
    { 1456, 384, -216},
    { 1440, 176, 72},
    // 83 seconds
    { 1208, 152, 464},
    { 1248, 464, 320},
    { 1048, 384, 272},
    { 856, 336, 208},
    { 824, 304, 160},
    { 864, 312, 112},
    { 872, 424, 64},
    { 1072, 440, 40},
    { 1248, 448, 64},
    { 1872, 456, 144},
    { 1672, 416, 208},
    { 1088, 304, 48},
    { 1336, 320, 56},
    { 1504, 56, 24},
    { 1360, 8, 24},
    { 1160, -56, 104},
    { 992, -112, 88},
    { 872, -64, 144},
    { 792, -32, 168},
    { 728, 8, 144},
    { 648, 48, 40},
    { 768, 56, -16},
    { 896, -32, -176},
    { 1320, -280, 24},
    { 1544, -136, 200},
    // 84 seconds
    { 1416, 240, -32},
    { 1456, 336, -160},
    { 1344, 232, 64},
    { 1240, 72, 152},
    { 1192, 456, 152},
    { 1128, 344, 240},
    { 992, 296, 208},
    { 872, 400, 48},
    { 856, 416, -48},
    { 904, 456, -96},
    { 1136, 360, -24},
    { 1296, 296, 32},
    { 1624, 224, 176},
    { 1688, 304, 208},
    { 1152, 280, 216},
    { 1240, 128, 176},
    { 1488, 80, 248},
    { 1480, 16, 320},
    { 1240, 16, 232},
    { 1072, 16, 152},
    { 960, 24, 64},
    { 832, -72, 152},
    { 728, -48, 112},
    { 648, -32, 16},
    { 656, -96, 0},
    // 85 seconds
    { 824, 64, -152},
    { 1304, 16, -176},
    { 1712, -88, 240},
    { 1488, 272, 232},
    { 1392, 360, -96},
    { 1384, 160, 96},
    { 1296, 80, 424},
    { 1240, 256, 392},
    { 1168, 416, 384},
    { 936, 424, 216},
    { 816, 384, 128},
    { 840, 432, 80},
    { 904, 480, 72},
    { 1000, 464, 104},
    { 1192, 416, 136},
    { 1552, 296, 224},
    { 1872, 312, 272},
    { 1328, 368, 104},
    { 1208, 224, 64},
    { 1392, 72, 192},
    { 1496, 40, 216},
    { 1304, 16, 240},
    { 1080, -16, 232},
    { 968, -32, 168},
    { 832, -40, 168},
    // 86 seconds
    { 752, 0, 128},
    { 664, -40, 96},
    { 656, -72, 48},
    { 856, -32, -56},
    { 1032, 32, -128},
    { 1480, -216, 88},
    { 1656, -64, 192},
    { 1400, 376, -72},
    { 1408, 384, -144},
    { 1432, 216, 200},
    { 1296, 280, 376},
    { 1184, 416, 392},
    { 968, 328, 232},
    { 848, 264, 176},
    { 768, 376, 72},
    { 744, 376, 48},
    { 808, 432, -16},
    { 960, 400, 32},
    { 1200, 424, 40},
    { 1536, 296, 96},
    { 1792, 288, 120},
    { 1392, 152, 216},
    { 1536, 120, 200},
    { 1696, 24, 224},
    { 1568, 72, 200},
    // 87 seconds
    { 1192, -16, 216},
    { 872, -64, 88},
    { 648, -48, 32},
    { 472, -104, 72},
    { 456, -64, 8},
    { 488, -24, -16},
    { 616, 24, -8},
    { 824, 144, -48},
    { 1168, -48, 120},
    { 2280, -360, 536},
    { 2280, 504, 304},
    { 1432, 776, -224},
    { 1040, 152, -16},
    { 1000, 16, 352},
    { 1000, 96, 408},
    { 968, 152, 384},
    { 880, 280, 304},
    { 720, 384, 112},
    { 640, 384, 120},
    { 624, 304, 200},
    { 936, 504, 200},
    { 1224, 592, 240},
    { 1464, 432, 248},
    { 1984, 392, 104},
    { 1480, 296, 136},
    // 88 seconds
    { 1424, 272, 16},
    { 1720, 192, 56},
    { 1624, 104, 64},
    { 1272, -56, 112},
    { 880, -80, 48},
    { 616, -16, -64},
    { 480, 8, -104},
    { 392, -8, -40},
    { 320, 24, 0},
    { 432, 88, 32},
    { 760, 216, 72},
    { 1216, 512, 96},
    { 1992, 224, 264},
    { 2136, -152, 600},
    { 1696, 472, -344},
    { 1128, 208, -136},
    { 944, 232, 56},
    { 784, 152, 208},
    { 808, 128, 296},
    { 832, 168, 408},
    { 792, 272, 400},
    { 728, 304, 272},
    { 744, 376, 112},
    { 824, 416, 88},
    { 1056, 480, 24},
    // 89 seconds
    { 1208, 456, 24},
    { 1632, 536, 40},
    { 1616, 584, 56},
    { 1056, 456, 56},
    { 1096, 352, -24},
    { 1344, 176, 88},
    { 1280, 136, 112},
    { 1192, 136, 64},
    { 1072, 0, 160},
    { 888, 24, 80},
    { 808, -16, 88},
    { 752, -48, 88},
    { 784, -56, 40},
    { 904, -80, 0},
    { 1152, -40, -8},
    { 1472, -128, 96},
    { 1848, -152, 424},
    { 1336, 328, 280},
    { 1120, 472, -144},
    { 1232, 128, 40},
    { 1152, 168, 376},
    { 1000, 176, 384},
    { 936, 216, 320},
    { 808, 240, 216},
    { 752, 256, 112},
    // 90 seconds
    { 824, 288, 72},
    { 904, 272, 112},
    { 1152, 280, 56},
    { 1432, 216, -72},
    { 1656, 312, -112},
    { 1840, 256, -72},
    { 992, 336, 16},
    { 1008, 352, -80},
    { 1136, 352, -184},
    { 1256, 112, 144},
    { 1112, -88, 272},
    { 984, -32, 200},
    { 816, 0, 144},
    { 688, 40, 48},
    { 784, 104, 40},
    { 680, 0, 112},
    { 760, 8, 48},
    { 888, 0, 16},
    { 1216, 48, -32},
    { 1592, -88, 136},
    { 2040, -88, 424},
    { 1552, 456, 120},
    { 1232, 232, -720},
    { 928, 24, 72},
    { 928, 320, 248},
    // 91 seconds
    { 808, 88, 296},
    { 864, 96, 320},
    { 792, 240, 248},
    { 720, 328, 120},
    { 728, 352, 8},
    { 784, 184, 56},
    { 944, 312, 40},
    { 1304, 312, 112},
    { 1328, 288, 32},
    { 1640, 288, 40},
    { 1368, 496, 16},
    { 1072, 352, 80},
    { 1264, 240, 96},
    { 1280, 80, 216},
    { 1184, 96, 160},
    { 1008, 56, 152},
    { 824, 48, 120},
    { 736, 32, 64},
    { 656, -16, 80},
    { 624, -8, 40},
    { 648, -40, 40},
    { 864, -8, -32},
    { 1128, 8, -8},
    { 1768, -216, 256},
    { 1752, 168, 264},
    // 92 seconds
    { 1376, 600, -216},
    { 1200, 328, -136},
    { 968, 208, 256},
    { 904, 176, 256},
    { 904, 72, 280},
    { 872, 208, 216},
    { 832, 288, 160},
    { 832, 368, 48},
    { 872, 336, 56},
    { 1040, 400, 24},
    { 1288, 376, 0},
    { 1472, 312, 24},
    { 1824, 416, 88},
    { 1160, 496, 80},
    { 920, 280, 48},
    { 1280, 200, 80},
    { 1360, 32, 248},
    { 1200, 48, 224},
    { 1088, 0, 216},
    { 936, 0, 160},
    { 824, -16, 168},
    { 752, -24, 128},
    { 704, -56, 104},
    { 744, -64, 56},
    { 920, 40, -72},
    // 93 seconds
    { 1224, -32, -88},
    { 1688, -208, 232},
    { 1400, 128, 136},
    { 1248, 432, -224},
    { 1264, 272, -96},
    { 1080, 168, 264},
    { 1064, 264, 208},
    { 1000, 168, 312},
    { 944, 320, 240},
    { 824, 304, 168},
    { 840, 352, 72},
    { 920, 464, -40},
    { 1104, 432, -48},
    { 1272, 400, 0},
    { 1592, 256, 96},
    { 1736, 408, 216},
    { 968, 440, 192},
    { 1000, 256, 120},
    { 1424, 248, 72},
    { 1480, -40, 216},
    { 1232, -16, 336},
    { 1048, 8, 232},
    { 944, 24, 152},
    { 872, -48, 184},
    { 800, -48, 144},
    // 94 seconds
    { 688, -72, 96},
    { 656, -128, 48},
    { 824, -72, -56},
    { 1184, -16, -112},
    { 1576, -80, 72},
    { 1632, 80, 160},
    { 1632, 688, -248},
    { 1376, 552, 24},
    { 1136, 568, 320},
    { 904, 168, 272},
    { 888, 168, 240},
    { 880, 128, 376},
    { 824, 248, 256},
    { 752, 248, 216},
    { 848, 408, 104},
    { 1096, 464, 136},
    { 1176, 600, 112},
    { 1592, 512, 120},
    { 1632, 568, 96},
    { 968, 448, 88},
    { 1048, 304, 128},
    { 1472, 144, -48},
    { 1352, -384, -96},
    { 1120, 32, 320},
    { 1000, -32, 296},
    // 95 seconds
    { 960, -24, 248},
    { 896, 16, 160},
    { 864, 40, 104},
    { 880, 8, 72},
    { 968, -24, 16},
    { 1000, -112, -48},
    { 1416, -256, 96},
    { 1416, -128, 176},
    { 1120, 152, 96},
    { 1032, 168, 8},
    { 1128, 184, 40},
    { 1128, 168, 224},
    { 1200, 208, 256},
    { 1232, 336, 296},
    { 1088, 528, 280},
    { 872, 424, 200},
    { 840, 336, 56},
    { 904, 312, 32},
    { 1176, 440, -40},
    { 1280, 360, 32},
    { 1728, 520, 64},
    { 1488, 560, 184},
    { 1040, 256, 96},
    { 1328, 248, 104},
    { 1592, 144, 216},
    // 96 seconds
    { 1448, 88, 264},
    { 1256, 8, 296},
    { 1096, -40, 272},
    { 952, -32, 232},
    { 864, 0, 160},
    { 800, 56, 8},
    { 752, -104, 64},
    { 744, -184, 56},
    { 896, 8, -112},
    { 1248, 40, -152},
    { 1360, -80, 56},
    { 1272, 240, -32},
    { 1440, 272, -56},
    { 1536, 176, 208},
    { 1424, 272, 336},
    { 1288, 384, 344},
    { 1136, 424, 344},
    { 960, 264, 280},
    { 912, 256, 168},
    { 848, 344, 56},
    { 840, 440, 32},
    { 1048, 552, 0},
    { 1208, 568, 56},
    { 1720, 616, 136},
    { 1720, 440, 208},
    // 97 seconds
    { 1128, 240, 168},
    { 1280, 248, 168},
    { 1680, 192, 240},
    { 1600, 8, 312},
    { 1384, 0, 272},
    { 1200, -32, 248},
    { 1016, -40, 216},
    { 880, -40, 192},
    { 768, -24, 152},
    { 680, -56, 72},
    { 704, -128, 8},
    { 936, 112, -120},
    { 944, -168, -240},
    { 1296, -320, -64},
    { 1632, -224, -8},
    { 1536, 120, -152},
    { 1600, 248, -168},
    { 1520, 128, 200},
    { 1304, 296, 304},
    { 1152, 296, 328},
    { 1072, 208, 208},
    { 952, 208, 144},
    { 880, 360, 40},
    { 920, 424, 0},
    { 984, 464, -24},
    // 98 seconds
    { 1256, 448, 0},
    { 1472, 376, 80},
    { 1776, 392, 88},
    { 1272, 288, 80},
    { 1184, 136, 72},
    { 1472, 56, 112},
    { 1624, 0, 208},
    { 1464, 56, 240},
    { 1280, 24, 216},
    { 1128, 0, 208},
    { 1016, -16, 192},
    { 920, -8, 152},
    { 792, -40, 88},
    { 656, -144, 8},
    { 720, -88, -104},
    { 912, -64, -184},
    { 1272, -168, -16},
    { 1392, 8, 64},
    { 1424, 224, -88},
    { 1664, 184, 16},
    { 1600, 256, 280},
    { 1376, 360, 320},
    { 1216, 480, 336},
    { 984, 248, 264},
    { 920, 256, 168},
    // 99 seconds
    { 888, 232, 184},
    { 856, 392, 64},
    { 912, 392, 48},
    { 1240, 648, 32},
    { 1480, 688, 152},
    { 1656, 552, 56},
    { 1224, 392, 64},
    { 1304, 224, 136},
    { 1592, 120, 216},
    { 1584, 32, 272},
    { 1304, -16, 272},
    { 1112, 0, 200},
    { 984, 8, 168},
    { 904, -16, 168},
    { 832, -40, 152},
    { 736, -40, 96},
    { 776, -88, 48},
    { 896, 0, -96},
    { 1360, -144, -128},
    { 1656, -248, 80},
    { 1336, 168, -104},
    { 1248, 432, -432},
    { 1264, 192, -16},
    { 1376, 96, 376},
    { 1336, 336, 304},
    // 100 seconds
    { 1136, 480, 304},
    { 864, 456, 128},
    { 736, 240, 104},
    { 824, 352, 64},
    { 848, 312, 72},
    { 1144, 432, -48},
    { 1320, 504, 24},
    { 1816, 560, 88},
    { 1664, 400, 128},
    { 1048, 256, 72},
    { 1216, 208, 72},
    { 1464, 168, 104},
    { 1400, 8, 216},
    { 1168, -24, 208},
    { 992, -16, 144},
    { 800, 0, 120},
    { 712, 0, 88},
    { 656, -32, 80},
    { 584, -56, 56},
    { 696, -72, 0},
    { 1024, 72, -136},
    { 1720, -152, 48},
    { 1976, -56, 232},
    { 1288, 520, -256},
    { 1152, 328, -208},
    // 101 seconds
    { 1064, 40, 208},
    { 1072, 80, 232},
    { 1048, 168, 240},
    { 944, 280, 232},
    { 856, 416, 112},
    { 744, 288, 112},
    { 760, 312, 48},
    { 840, 288, 56},
    { 1200, 368, -16},
    { 1352, 336, 0},
    { 1752, 288, 16},
    { 1816, 368, -16},
    { 968, 256, 24},
    { 976, 192, 0},
    { 1160, 64, 72},
    { 1232, 56, 168},
    { 1064, 16, 224},
    { 960, -40, 224},
    { 872, 8, 184},
    { 800, 8, 152},
    { 728, -16, 144},
    { 696, 0, 56},
    { 816, 16, -8},
    { 992, 152, -176},
    { 1456, -104, -64},
    // 102 seconds
    { 1600, -224, 176},
    { 1304, 144, -32},
    { 1128, 328, -208},
    { 1016, 264, -48},
    { 840, 32, 240},
    { 960, 352, 88},
    { 960, 96, 256},
    { 952, 288, 184},
    { 896, 312, 136},
    { 880, 376, 40},
    { 912, 376, 24},
    { 1168, 368, -16},
    { 1280, 352, 16},
    { 1848, 376, 88},
    { 1536, 456, 72},
    { 888, 264, 80},
    { 1120, 176, 88},
    { 1304, 64, 200},
    { 1208, 48, 224},
    { 1080, 56, 176},
    { 968, 8, 192},
    { 840, -8, 192},
    { 800, -24, 160},
    { 728, -48, 152},
    { 704, -48, 88},
    // 103 seconds
    { 824, -16, -16},
    { 1008, 40, -96},
    { 1488, -96, -24},
    { 1584, -64, 72},
    { 1168, 256, -152},
    { 1136, 272, -264},
    { 1136, 208, 40},
    { 1072, 192, 200},
    { 1056, 240, 240},
    { 992, 320, 240},
    { 856, 352, 208},
    { 792, 304, 136},
    { 840, 312, 72},
    { 896, 352, 8},
    { 1192, 368, -64},
    { 1328, 456, -80},
    { 1792, 464, -40},
    { 1536, 448, 40},
    { 888, 272, 64},
    { 1096, 232, 80},
    { 1256, 112, 200},
    { 1296, 72, 232},
    { 1144, 0, 256},
    { 1048, 0, 224},
    { 968, 0, 176},
    // 104 seconds
    { 896, -24, 160},
    { 784, -8, 112},
    { 672, -8, 8},
    { 688, -16, -80},
    { 912, 64, -136},
    { 1424, -104, -80},
    { 1680, -64, 128},
    { 1160, 336, -96},
    { 1176, 312, -184},
    { 1256, 240, 104},
    { 1128, 288, 288},
    { 1000, 248, 288},
    { 912, 272, 232},
    { 888, 304, 200},
    { 824, 312, 136},
    { 856, 320, 64},
    { 920, 424, 8},
    { 1112, 384, -16},
    { 1296, 416, -8},
    { 1744, 432, 72},
    { 1664, 472, 96},
    { 920, 312, 72},
    { 1056, 232, 88},
    { 1256, 128, 160},
    { 1192, 72, 216},
    // 105 seconds
    { 1072, 32, 224},
    { 1000, 0, 216},
    { 912, 16, 192},
    { 856, 16, 152},
    { 808, 0, 120},
    { 784, -16, 72},
    { 896, 0, -8},
    { 1040, 72, -112},
    { 1496, -160, 16},
    { 1488, -144, 120},
    { 1112, 232, -128},
    { 1048, 288, -240},
    { 1008, 104, 8},
    { 1064, 48, 200},
    { 1120, 128, 224},
    { 1104, 312, 232},
    { 984, 496, 120},
    { 824, 392, 104},
    { 864, 376, 32},
    { 960, 328, 0},
    { 1152, 352, -48},
    { 1280, 352, -40},
    { 1760, 360, 32},
    { 1648, 424, 80},
    { 1064, 224, 128},
    // 106 seconds
    { 1152, 120, 136},
    { 1416, 0, -120},
    { 1208, 48, 216},
    { 1160, 32, 208},
    { 1048, 0, 224},
    { 976, 8, 184},
    { 912, -24, 184},
    { 864, -16, 128},
    { 816, -40, 64},
    { 840, 0, -40},
    { 904, 88, -184},
    { 1280, -160, -96},
    { 1472, -240, 72},
    { 1320, 56, -32},
    { 1200, 216, -136},
    { 1224, 144, 0},
    { 1296, 136, 248},
    { 1312, 208, 344},
    { 1232, 432, 352},
    { 1008, 560, 288},
    { 736, 368, 88},
    { 880, 360, 96},
    { 1024, 448, 48},
    { 1144, 432, -32},
    { 1240, 448, 16},
    // 107 seconds
    { 1760, 464, 24},
    { 1560, 464, 104},
    { 1048, 272, 112},
    { 1176, 192, 112},
    { 1480, 40, 256},
    { 1408, -32, 320},
    { 1272, 32, 264},
    { 1184, -80, 312},
    { 1000, -96, 304},
    { 872, -96, 248},
    { 776, -104, 176},
    { 696, -120, 104},
    { 800, -72, -16},
    { 952, 72, -216},
    { 1328, -208, -72},
    { 1400, -312, 96},
    { 1408, 0, -8},
    { 1384, 176, -120},
    { 1328, 104, 96},
    { 1280, 144, 264},
    { 1296, 312, 248},
    { 1168, 496, 320},
    { 904, 488, 240},
    { 736, 200, 120},
    { 872, 360, -48},
    // 108 seconds
    { 1024, 416, -72},
    { 1184, 368, -32},
    { 1296, 344, 24},
    { 2032, 256, 88},
    { 1672, 264, 264},
    { 1320, 56, 232},
    { 1400, -16, 240},
    { 1480, -80, 376},
    { 1416, 8, 288},
    { 1216, -64, 320},
    { 1032, -104, 320},
    { 872, -104, 288},
    { 712, -96, 248},
    { 568, -104, 240},
    { 544, -64, 128},
    { 544, 0, 8},
    { 784, 184, -200},
    { 960, 208, -264},
    { 1464, -216, -8},
    { 1920, -240, 184},
    { 1464, 264, -112},
    { 1440, 280, -144},
    { 1168, 216, 16},
    { 968, 128, 168},
    { 1032, 80, 184},
    // 109 seconds
    { 968, 192, 240},
    { 944, 328, 176},
    { 888, 448, 96},
    { 720, 440, -24},
    { 848, 424, -128},
    { 1120, 312, -64},
    { 1216, 216, -16},
    { 1368, 264, 16},
    { 2016, 168, 160},
    { 1536, 304, 264},
    { 1544, 128, 336},
    { 1472, 64, 344},
    { 1248, 64, 392},
    { 1128, 56, 352},
    { 1056, 32, 392},
    { 968, -8, 464},
    { 824, -8, 472},
    { 744, 72, 464},
    { 592, 176, 344},
    { 584, 184, 232},
    { 568, 128, 168},
    { 688, 128, 0},
    { 824, -80, -104},
    { 1488, -400, -184},
    { 1728, -320, -56},
    // 110 seconds
    { 2048, -88, -128},
    { 2040, -216, 48},
    { 1760, -16, 256},
    { 1232, 432, 40},
    { 952, 432, 64},
    { 928, 360, 168},
    { 824, 256, 272},
    { 896, 176, 272},
    { 1264, 320, 128},
    { 1392, 328, 192},
    { 1432, 488, -8},
    { 1344, 616, -112},
    { 1136, 544, -144},
    { 1184, 424, -208},
    { 1616, 472, 32},
    { 1520, 224, 336},
    { 1576, 80, 320},
    { 1840, -136, 544},
    { 1592, -48, 440},
    { 1432, -96, 392},
    { 1184, -48, 312},
    { 1024, -40, 312},
    { 888, -72, 280},
    { 760, -136, 232},
    { 576, -104, 40},
    // 111 seconds
    { 584, -32, -96},
    { 704, 72, -216},
    { 936, 256, -320},
    { 1560, 120, -72},
    { 1568, -200, 160},
    { 1800, 144, 24},
    { 1720, 96, 280},
    { 1400, 216, 360},
    { 1136, 296, 240},
    { 1008, 384, 184},
    { 968, 296, 312},
    { 1040, 160, 440},
    { 1112, 272, 344},
    { 1192, 384, 280},
    { 1280, 432, 272},
    { 1288, 480, 72},
    { 1312, 456, 56},
    { 1208, 544, 24},
    { 1432, 712, -192},
    { 1408, 728, -8},
    { 1440, 160, 344},
    { 1592, 16, 376},
    { 1800, -64, 408},
    { 1968, 64, 224},
    { 1696, -64, 360},
    // 112 seconds
    { 1264, -120, 296},
    { 928, -120, 248},
    { 696, -88, 168},
    { 504, -80, 96},
    { 392, 24, -8},
    { 384, 160, 24},
    { 464, 264, -8},
    { 616, 304, -16},
    { 920, 400, -16},
    { 1616, 272, 32},
    { 1704, 264, 232},
    { 1832, 320, 88},
    { 1680, 88, 160},
    { 1416, 72, 272},
    { 1040, 256, 192},
    { 864, 360, 176},
    { 832, 320, 216},
    { 888, 240, 312},
    { 896, 256, 272},
    { 880, 336, 160},
    { 1008, 400, 64},
    { 1168, 472, 0},
    { 1304, 400, 32},
    { 1368, 360, 0},
    { 1320, 240, 0},
    // 113 seconds
    { 1592, 472, -168},
    { 1448, 208, 128},
    { 1456, 64, 184},
    { 1544, -64, 320},
    { 1600, -40, 256},
    { 1296, -64, 248},
    { 1032, -72, 288},
    { 824, -56, 296},
    { 616, -8, 264},
    { 480, 72, 224},
    { 416, 160, 200},
    { 384, 304, 112},
    { 472, 408, 8},
    { 528, 408, 32},
    { 744, 440, -16},
    { 1208, 264, 0},
    { 1568, 8, 208},
    { 1592, 400, -40},
    { 1592, 216, -80},
    { 1392, -40, 128},
    { 992, 80, 112},
    { 752, 224, 96},
    { 784, 280, 104},
    { 856, 208, 176},
    { 952, 144, 280},
    // 114 seconds
    { 1016, 208, 256},
    { 960, 288, 176},
    { 992, 392, 104},
    { 984, 408, 80},
    { 976, 504, 0},
    { 936, 664, 56},
    { 1088, 784, 72},
    { 2064, 1384, -16},
    { 1960, 352, 864},
    { 2144, 584, 448},
    { 2296, 384, 744},
    { 1824, 64, 1080},
    { 1312, 96, 632},
    { 1176, 152, 424},
    { 864, 80, 280},
    { 760, 48, 56},
    { 480, 176, -104},
    { 376, 496, -168},
    { 264, 568, -320},
    { 296, 608, -336},
    { 96, 888, -784},
    { -8, 1016, -680},
    { -40, 936, -600},
    { -72, 792, -632},
    { -72, 864, -720},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-03 09:10:55 local
AccelRawData *activity_sample_walk_200_pbl_25532_12(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25532_12
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -8, -144, -1024},
    { -8, -152, -1016},
    { 0, -152, -1032},
    { -8, -160, -1032},
    { 8, -160, -1048},
    { 0, -160, -1048},
    { 0, -144, -1040},
    { 0, -168, -1024},
    { 0, -168, -1024},
    { 0, -176, -1040},
    { 16, -176, -1016},
    { 80, -192, -1016},
    { -216, -328, -960},
    { 48, -232, -1016},
    { -48, -200, -992},
    { -56, -232, -960},
    { -640, 104, -1096},
    { 16, -688, -1056},
    { 808, -128, -1304},
    { 112, -136, -904},
    { 80, -72, -760},
    { 8, 32, -728},
    { 24, 216, -736},
    { -80, 344, -744},
    { -104, 592, -808},
    // 1 seconds
    { -96, 648, -816},
    { -112, 696, -984},
    { -152, 736, -944},
    { -216, 608, -776},
    { -128, 760, -776},
    { -40, 760, -672},
    { -24, 680, -640},
    { -80, 440, -504},
    { 64, 816, -512},
    { 32, 784, -248},
    { 80, 752, -200},
    { 216, 1048, -360},
    { 184, 984, -312},
    { 256, 1016, -392},
    { 416, 1248, -424},
    { 368, 1096, -336},
    { 400, 1088, -416},
    { 368, 960, -408},
    { 392, 984, -408},
    { 376, 856, -432},
    { 376, 800, -408},
    { 384, 784, -432},
    { 320, 632, -424},
    { 392, 680, -464},
    { 368, 560, -424},
    // 2 seconds
    { 368, 424, -368},
    { 480, 360, -312},
    { 648, 304, -240},
    { 1040, 240, 32},
    { 1424, 216, 240},
    { 1000, 0, -80},
    { 1384, 232, 128},
    { 1248, 208, 232},
    { 1120, 312, 224},
    { 1112, 360, 184},
    { 1040, 360, 168},
    { 936, 312, 168},
    { 872, 240, 200},
    { 832, 320, 104},
    { 800, 296, 32},
    { 784, 312, -32},
    { 856, 296, -8},
    { 1096, 416, -152},
    { 1208, 360, -72},
    { 1768, 424, -56},
    { 1872, 400, 40},
    { 1080, 448, 8},
    { 856, 232, 80},
    { 1640, 160, -656},
    { 1112, -704, 608},
    // 3 seconds
    { 1000, 320, 144},
    { 952, 192, 152},
    { 872, 168, 176},
    { 784, 80, 144},
    { 728, -16, 152},
    { 672, 8, 40},
    { 736, 32, 0},
    { 984, 56, -32},
    { 1344, -104, 8},
    { 1856, -184, 216},
    { 1464, 160, 152},
    { 768, 544, -368},
    { 928, 256, -224},
    { 1056, 48, 232},
    { 1008, 168, 104},
    { 896, 232, 88},
    { 888, 328, 128},
    { 760, 360, 8},
    { 744, 264, 0},
    { 784, 328, -48},
    { 952, 376, -112},
    { 1304, 392, -160},
    { 1336, 312, -80},
    { 1800, 256, 32},
    { 1760, 312, 72},
    // 4 seconds
    { 800, 360, -8},
    { 960, 256, 64},
    { 1256, 32, 240},
    { 1240, 56, 296},
    { 1048, 48, 280},
    { 960, 16, 200},
    { 824, 32, 112},
    { 704, 32, 56},
    { 656, -32, 112},
    { 616, -32, 48},
    { 736, 8, -88},
    { 1024, 80, -104},
    { 1432, -96, 56},
    { 1720, -136, 304},
    { 1424, 232, 104},
    { 1144, 440, -184},
    { 1152, 312, 8},
    { 1048, 208, 168},
    { 936, 224, 208},
    { 960, 192, 192},
    { 904, 280, 136},
    { 784, 352, -8},
    { 792, 360, -72},
    { 912, 440, -120},
    { 1104, 352, -56},
    // 5 seconds
    { 1344, 304, -32},
    { 1704, 144, 120},
    { 1792, 232, 136},
    { 1088, 272, 136},
    { 1184, 104, 144},
    { 1320, 48, 248},
    { 1176, 16, 360},
    { 1032, 48, 232},
    { 888, 40, 208},
    { 888, 40, 200},
    { 832, -24, 184},
    { 776, -32, 80},
    { 768, -112, 136},
    { 768, -120, 96},
    { 912, 8, -56},
    { 1424, -96, 40},
    { 1536, 24, 248},
    { 1264, 312, -224},
    { 1248, 136, -288},
    { 1312, 136, 24},
    { 1296, 168, 144},
    { 1088, 464, 104},
    { 1008, 352, 184},
    { 888, 376, 168},
    { 816, 288, 112},
    // 6 seconds
    { 920, 392, -40},
    { 928, 296, -48},
    { 1192, 296, -56},
    { 1376, 208, 72},
    { 1864, 256, 136},
    { 1256, 368, 176},
    { 984, 208, 80},
    { 1176, 136, 160},
    { 1416, 144, 256},
    { 1216, 136, 192},
    { 1048, 96, 128},
    { 936, 16, 168},
    { 824, -40, 184},
    { 744, -16, 96},
    { 704, 0, -16},
    { 800, -104, 56},
    { 896, -64, 64},
    { 1160, -96, 40},
    { 1640, -80, 144},
    { 1488, 208, 168},
    { 1136, 448, -152},
    { 1128, 160, -32},
    { 1032, 120, 240},
    { 992, 152, 224},
    { 1024, 216, 192},
    // 7 seconds
    { 960, 360, 160},
    { 896, 408, 64},
    { 824, 320, 40},
    { 896, 424, -48},
    { 1056, 392, -8},
    { 1224, 448, -16},
    { 1456, 336, 120},
    { 1776, 368, 152},
    { 1192, 312, 72},
    { 1056, 216, 104},
    { 1288, 112, 168},
    { 1144, -1008, 152},
    { 1016, 144, 280},
    { 896, 0, 248},
    { 792, 64, 152},
    { 736, 88, 104},
    { 752, 0, 160},
    { 832, -16, 144},
    { 968, -32, 72},
    { 1064, 32, 0},
    { 1584, -176, 160},
    { 1520, -64, 184},
    { 1072, 304, -128},
    { 984, 304, -304},
    { 936, 104, 16},
    // 8 seconds
    { 936, 16, 192},
    { 952, 280, 88},
    { 920, 224, 136},
    { 904, 376, 128},
    { 808, 344, 96},
    { 832, 360, 40},
    { 952, 408, -32},
    { 1136, 352, -40},
    { 1320, 344, 24},
    { 1904, 472, 96},
    { 1368, 472, 24},
    { 904, 280, 0},
    { 1136, 232, 32},
    { 1320, 192, 240},
    { 1144, 64, 272},
    { 1008, 16, 224},
    { 920, 16, 184},
    { 856, 8, 192},
    { 808, 0, 152},
    { 800, -24, 120},
    { 856, -72, 96},
    { 960, 40, -24},
    { 1368, -96, 40},
    { 1456, -144, 128},
    { 1144, 88, 48},
    // 9 seconds
    { 1176, 200, -144},
    { 1208, 200, -112},
    { 1144, 208, 128},
    { 1144, 256, 184},
    { 1064, 432, 128},
    { 1008, 360, 224},
    { 864, 360, 200},
    { 800, 296, 128},
    { 856, 424, -32},
    { 1000, 392, -24},
    { 1232, 464, -40},
    { 1560, 448, 16},
    { 1728, 536, 56},
    { 1112, 392, 24},
    { 1064, 248, 64},
    { 1352, 144, 136},
    { 1456, 40, 272},
    { 1208, 48, 256},
    { 1056, -16, 248},
    { 976, 8, 192},
    { 888, 8, 168},
    { 816, 8, 136},
    { 800, -48, 136},
    { 872, -88, 64},
    { 952, 40, -112},
    // 10 seconds
    { 1320, -104, -144},
    { 1376, -192, 112},
    { 1256, 96, -88},
    { 1232, 272, -312},
    { 1216, 184, -8},
    { 1224, 168, 232},
    { 1216, 248, 272},
    { 1144, 328, 360},
    { 1040, 488, 288},
    { 840, 360, 144},
    { 840, 384, 8},
    { 984, 432, 8},
    { 1192, 528, -128},
    { 1488, 496, -120},
    { 1736, 608, -88},
    { 1256, 384, -16},
    { 1304, 224, 72},
    { 1536, 72, 208},
    { 1472, 48, 232},
    { 1272, 56, 232},
    { 1096, 32, 176},
    { 992, 40, 56},
    { 912, 0, 80},
    { 808, -56, 184},
    { 736, -64, 120},
    // 11 seconds
    { 720, -56, 16},
    { 824, 32, -64},
    { 1128, -48, -152},
    { 1392, -120, 72},
    { 1464, 40, 152},
    { 1384, 312, -112},
    { 1360, 392, -176},
    { 1112, 264, 160},
    { 1120, 200, 152},
    { 1040, 336, 184},
    { 1072, 320, 208},
    { 992, 392, 144},
    { 944, 464, 24},
    { 896, 488, -40},
    { 1040, 424, -64},
    { 1304, 504, -80},
    { 1800, 536, 0},
    { 1704, 536, 16},
    { 1176, 344, -8},
    { 1280, 232, 64},
    { 1448, 128, 168},
    { 1312, 80, 224},
    { 1104, 88, 208},
    { 976, 32, 216},
    { 872, 0, 208},
    // 12 seconds
    { 816, -24, 200},
    { 768, -8, 120},
    { 760, -48, 96},
    { 824, -64, 32},
    { 936, 32, -112},
    { 1344, -232, 24},
    { 1552, -80, 96},
    { 1288, 200, -40},
    { 1304, 320, -256},
    { 1384, 248, -48},
    { 1200, 168, 360},
    { 1224, 472, 160},
    { 1040, 400, 240},
    { 920, 328, 200},
    { 824, 280, 112},
    { 848, 352, 24},
    { 896, 416, -32},
    { 1136, 448, -32},
    { 1304, 496, -16},
    { 1824, 528, 32},
    { 1520, 424, 48},
    { 1240, 232, 48},
    { 1408, 152, 120},
    { 1544, 80, 200},
    { 1360, 56, 232},
    // 13 seconds
    { 1104, -8, 232},
    { 912, -16, 152},
    { 784, -16, 136},
    { 696, -24, 112},
    { 664, -64, 112},
    { 680, -64, 72},
    { 848, 0, -32},
    { 1152, -24, -64},
    { 1584, -216, 152},
    { 1632, -32, 224},
    { 1400, 392, -200},
    { 1392, 432, -272},
    { 1216, 288, 144},
    { 1088, 240, 208},
    { 1056, 280, 240},
    { 968, 352, 200},
    { 848, 344, 120},
    { 808, 368, 8},
    { 824, 336, -24},
    { 1016, 424, -120},
    { 1264, 392, -104},
    { 1648, 384, -24},
    { 1856, 440, 32},
    { 1248, 296, 72},
    { 1184, 176, 96},
    // 14 seconds
    { 1408, 72, 192},
    { 1376, 48, 240},
    { 1160, 16, 232},
    { 1064, -24, 240},
    { 968, -8, 200},
    { 880, 16, 152},
    { 800, 0, 120},
    { 776, -8, 64},
    { 800, -72, 16},
    { 880, -24, -104},
    { 1256, -160, -72},
    { 1368, -208, 120},
    { 1304, 64, 80},
    { 1288, 272, -184},
    { 1368, 248, -136},
    { 1368, 152, 232},
    { 1304, 264, 304},
    { 1192, 504, 376},
    { 952, 408, 272},
    { 800, 184, 136},
    { 888, 320, 64},
    { 952, 376, 0},
    { 1160, 400, -40},
    { 1240, 408, -16},
    { 1752, 472, 8},
    // 15 seconds
    { 1680, 592, 8},
    { 1144, 360, -8},
    { 1216, 208, 40},
    { 1424, 24, 136},
    { 1384, -80, 264},
    { 1208, 72, 256},
    { 1056, 16, 216},
    { 968, -32, 200},
    { 912, -56, 208},
    { 800, 0, 136},
    { 800, -32, 120},
    { 968, 48, 48},
    { 1016, 48, -224},
    { 1176, -232, -240},
    { 1256, -200, -136},
    { 1112, 8, -224},
    { 1256, 64, -184},
    { 1328, 96, 48},
    { 1216, 176, 152},
    { 1224, 256, 224},
    { 1144, 344, 264},
    { 928, 248, 272},
    { 832, 360, 168},
    { 912, 568, 88},
    { 960, 704, -16},
    // 16 seconds
    { 1176, 568, 56},
    { 1344, 440, 104},
    { 1720, 424, 136},
    { 1520, 440, 168},
    { 1096, 272, 64},
    { 1360, 120, 144},
    { 1560, -8, 352},
    { 1368, 56, 272},
    { 1104, 24, 208},
    { 896, -24, 160},
    { 760, -8, 104},
    { 664, -16, 104},
    { 600, -40, 96},
    { 560, -80, 8},
    { 880, 80, -160},
    { 1104, 8, -112},
    { 1568, -200, 152},
    { 1632, 32, 104},
    { 1376, 344, -192},
    { 1416, 320, -160},
    { 1248, 304, 128},
    { 1032, 248, 176},
    { 1016, 208, 256},
    { 968, 232, 248},
    { 872, 288, 144},
    // 17 seconds
    { 792, 328, 40},
    { 856, 384, -64},
    { 1024, 352, -72},
    { 1344, 432, -136},
    { 1712, 376, -56},
    { 1880, 448, -24},
    { 1176, 280, 40},
    { 1184, 184, 48},
    { 1384, 56, 184},
    { 1416, 40, 232},
    { 1248, 40, 240},
    { 1032, 0, 248},
    { 896, -16, 176},
    { 792, -16, 128},
    { 728, 0, 88},
    { 704, -16, 56},
    { 728, -56, 24},
    { 872, 0, -96},
    { 1296, -160, -24},
    { 1608, -168, 192},
    { 1464, 184, 56},
    { 1232, 376, -296},
    { 1304, 256, -72},
    { 1304, 216, 216},
    { 1144, 312, 200},
    // 18 seconds
    { 1016, 304, 248},
    { 920, 336, 200},
    { 840, 280, 136},
    { 840, 336, 32},
    { 888, 328, 24},
    { 1008, 400, -56},
    { 1232, 584, -64},
    { 1768, 680, 72},
    { 1920, 576, 80},
    { 1120, 392, -16},
    { 1256, 240, 80},
    { 1592, 24, 240},
    { 1416, 40, 264},
    { 1144, 72, 240},
    { 992, 48, 184},
    { 912, 32, 168},
    { 848, -16, 176},
    { 840, -16, 136},
    { 656, -72, 120},
    { 560, -112, 48},
    { 808, 40, -144},
    { 1176, 16, -184},
    { 1512, -144, 104},
    { 1528, 152, 48},
    { 1432, 400, -240},
    // 19 seconds
    { 1440, 392, -128},
    { 1344, 288, 200},
    { 1184, 344, 216},
    { 1096, 296, 280},
    { 968, 304, 216},
    { 872, 352, 120},
    { 776, 440, -24},
    { 808, 504, -208},
    { 920, 424, -176},
    { 1328, 376, -16},
    { 1624, 256, 264},
    { 1832, 328, 352},
    { 1312, 448, 184},
    { 1056, 168, 160},
    { 1376, 88, 288},
    { 1520, 64, 392},
    { 1312, 32, 336},
    { 1176, -24, 240},
    { 1080, -56, 200},
    { 976, -32, 96},
    { 816, -24, 88},
    { 696, 0, -8},
    { 648, -40, -88},
    { 784, -32, -144},
    { 960, -200, -48},
    // 20 seconds
    { 1408, -248, 256},
    { 1600, 136, 232},
    { 1544, 424, -56},
    { 1536, 208, 8},
    { 1456, 176, 344},
    { 1360, 360, 368},
    { 1192, 504, 368},
    { 992, 352, 216},
    { 888, 296, 120},
    { 840, 368, 24},
    { 896, 448, 0},
    { 1128, 568, 24},
    { 1352, 696, 0},
    { 1784, 592, 24},
    { 1728, 368, 80},
    { 1264, 176, 112},
    { 1464, 160, 160},
    { 1720, 48, 344},
    { 1504, 56, 336},
    { 1280, 32, 272},
    { 1144, 16, 248},
    { 992, -16, 232},
    { 872, -56, 208},
    { 736, -48, 144},
    { 592, -168, 88},
    // 21 seconds
    { 488, -240, -8},
    { 824, 8, -200},
    { 1560, -40, 32},
    { 1648, 0, 208},
    { 1536, 328, -168},
    { 1496, 392, -328},
    { 1464, 256, 248},
    { 1384, 360, 360},
    { 1216, 440, 352},
    { 1056, 320, 264},
    { 936, 328, 256},
    { 816, 320, 184},
    { 840, 376, 64},
    { 920, 416, 112},
    { 1144, 664, 24},
    { 1304, 624, 120},
    { 1728, 648, 88},
    { 1352, 496, 48},
    { 1216, 320, 56},
    { 1512, 216, 128},
    { 1608, 104, 248},
    { 1400, 72, 280},
    { 1216, 0, 264},
    { 1080, 0, 224},
    { 952, -16, 200},
    // 22 seconds
    { 864, -24, 168},
    { 776, -32, 112},
    { 688, -64, 0},
    { 752, 40, -104},
    { 984, 40, -168},
    { 1328, -272, 152},
    { 1384, -24, 128},
    { 1336, 368, -176},
    { 1352, 336, -32},
    { 1312, 312, 176},
    { 1256, 304, 264},
    { 1208, 424, 264},
    { 1160, 480, 312},
    { 984, 496, 312},
    { 856, 408, 232},
    { 856, 328, 120},
    { 1088, 392, -56},
    { 1184, 504, -64},
    { 1584, 840, -80},
    { 1720, 680, 136},
    { 1192, 416, 104},
    { 1288, 320, 120},
    { 1632, 208, 248},
    { 1536, 80, 336},
    { 1256, 104, 208},
    // 23 seconds
    { 1080, 0, 256},
    { 936, -32, 256},
    { 872, -40, 200},
    { 816, 8, 104},
    { 776, -32, 88},
    { 832, -64, 32},
    { 1008, -24, -160},
    { 1328, -176, -40},
    { 1472, -80, 168},
    { 1192, 256, -104},
    { 1248, 216, -128},
    { 1440, -32, 248},
    { 1608, 160, 512},
    { 1480, 656, 336},
    { 1176, 896, 376},
    { 712, 200, 32},
    { 824, 48, 104},
    { 824, 264, 152},
    { 912, 456, 88},
    { 1192, 552, 88},
    { 1448, 648, 312},
    { 1824, 752, 440},
    { 1584, 280, 136},
    { 1232, 264, 96},
    { 1480, 328, 200},
    // 24 seconds
    { 1760, 200, 360},
    { 1568, 96, 328},
    { 1264, -24, 312},
    { 1048, -32, 256},
    { 912, -56, 192},
    { 760, -88, 120},
    { 664, -96, 72},
    { 592, -240, 64},
    { 664, -184, -16},
    { 912, -16, -56},
    { 1720, -24, 304},
    { 1656, 400, 72},
    { 1304, 304, -176},
    { 1608, 504, -144},
    { 1432, 400, 64},
    { 1456, 368, 160},
    { 1224, 792, 152},
    { 960, 528, 176},
    { 840, 360, 144},
    { 840, 392, 56},
    { 880, 528, -104},
    { 952, 616, -64},
    { 1056, 544, -120},
    { 1456, 584, -112},
    { 1616, 712, -24},
    // 25 seconds
    { 1312, 632, -32},
    { 1408, 472, -88},
    { 1696, 304, -64},
    { 1736, 208, 168},
    { 1440, 128, 288},
    { 1200, 48, 216},
    { 1016, -8, 224},
    { 832, -24, 208},
    { 720, -16, 120},
    { 592, -64, 40},
    { 592, -104, 0},
    { 712, -80, -16},
    { 928, 64, -192},
    { 1424, -176, 24},
    { 1760, -24, 120},
    { 1792, 320, -40},
    { 1792, 656, -144},
    { 1448, 720, 72},
    { 1120, 544, 208},
    { 1056, 248, 200},
    { 968, 328, 264},
    { 888, 392, 176},
    { 768, 424, 32},
    { 808, 536, 8},
    { 960, 560, 16},
    // 26 seconds
    { 1136, 648, 16},
    { 1480, 592, 144},
    { 1776, 592, 248},
    { 1432, 440, 232},
    { 1288, 408, 168},
    { 1600, 288, 248},
    { 1704, 112, 288},
    { 1416, 8, 352},
    { 1208, 16, 256},
    { 1016, 56, 136},
    { 832, 16, 152},
    { 712, 24, 80},
    { 592, -96, 80},
    { 528, -168, 40},
    { 720, -112, 40},
    { 1056, 240, -72},
    { 1464, 320, 264},
    { 1432, 440, 336},
    { 1064, 560, 96},
    { 1184, 256, 104},
    { 1312, 48, 400},
    { 1384, 288, 400},
    { 1368, 432, 392},
    { 1152, 520, 472},
    { 864, 376, 216},
    // 27 seconds
    { 784, 312, 80},
    { 888, 440, 56},
    { 1008, 496, 104},
    { 1216, 640, 104},
    { 1496, 672, 152},
    { 1800, 600, 216},
    { 1216, 264, 168},
    { 1360, 232, 144},
    { 1656, 112, 280},
    { 1560, 88, 320},
    { 1296, 64, 224},
    { 1088, 8, 192},
    { 992, 8, 168},
    { 968, 32, 96},
    { 904, 72, 16},
    { 792, -24, 64},
    { 752, -192, 64},
    { 736, -136, -48},
    { 1192, -152, -16},
    { 1360, -112, 136},
    { 1312, 360, 24},
    { 1344, 624, -48},
    { 1456, 592, 0},
    { 1344, 440, 280},
    { 1304, 512, 312},
    // 28 seconds
    { 1240, 624, 344},
    { 1000, 680, 360},
    { 784, 544, 72},
    { 800, 312, 40},
    { 960, 400, 32},
    { 1128, 536, -72},
    { 1424, 608, 24},
    { 1832, 696, 104},
    { 1328, 408, 104},
    { 1176, 208, 80},
    { 1520, 192, 168},
    { 1608, 176, 232},
    { 1320, 112, 288},
    { 1168, 104, 200},
    { 1064, 32, 184},
    { 976, 16, 176},
    { 880, -24, 200},
    { 824, -16, 104},
    { 824, -80, 16},
    { 800, 24, -96},
    { 1208, -176, 24},
    { 1376, -88, -64},
    { 1304, 72, -48},
    { 1224, 104, -80},
    { 1472, 224, -48},
    // 29 seconds
    { 1520, 616, 96},
    { 1344, 656, 152},
    { 1112, 464, 160},
    { 888, 280, 96},
    { 856, 312, 96},
    { 872, 360, 24},
    { 896, 344, 40},
    { 1040, 496, -24},
    { 1336, 528, 128},
    { 1928, 784, 192},
    { 1440, 720, 248},
    { 928, 80, 144},
    { 1352, 168, 184},
    { 1560, 184, 224},
    { 1400, 112, 184},
    { 1248, 32, 216},
    { 1128, 0, 192},
    { 992, 0, 184},
    { 904, 8, 128},
    { 824, -8, 80},
    { 752, -80, 40},
    { 800, -176, -48},
    { 928, -96, -176},
    { 1464, -168, -72},
    { 1640, -24, 80},
    // 30 seconds
    { 1248, 184, -128},
    { 1328, 192, -208},
    { 1560, 136, 208},
    { 1496, 288, 368},
    { 1336, 360, 392},
    { 1112, 424, 408},
    { 864, 344, 216},
    { 792, 416, 0},
    { 848, 456, -8},
    { 920, 328, 32},
    { 1064, 264, 24},
    { 1176, 304, 96},
    { 1704, 448, 160},
    { 1488, 544, 216},
    { 968, 336, 104},
    { 1168, 272, 120},
    { 1504, 168, 232},
    { 1520, 96, 264},
    { 1320, 16, 280},
    { 1176, -8, 216},
    { 1064, -32, 192},
    { 952, -16, 144},
    { 864, 0, 88},
    { 832, -48, 48},
    { 888, -40, -64},
    // 31 seconds
    { 952, -96, -128},
    { 1304, -224, 0},
    { 1360, -144, 104},
    { 1168, 216, -80},
    { 1304, 200, -136},
    { 1472, 216, 152},
    { 1392, 264, 360},
    { 1272, 488, 256},
    { 1040, 488, 416},
    { 832, 280, 176},
    { 840, 280, 120},
    { 904, 360, 144},
    { 928, 384, 128},
    { 1096, 472, 48},
    { 1264, 552, 192},
    { 1768, 896, 336},
    { 1256, 320, 80},
    { 992, 312, 184},
    { 1336, 336, 264},
    { 1584, 640, 664},
    { 1064, 296, 240},
    { 1160, -32, 280},
    { 1024, -8, 256},
    { 984, 0, 200},
    { 904, -16, 192},
    // 32 seconds
    { 840, -16, 120},
    { 808, -32, 40},
    { 872, -24, -88},
    { 1048, -152, -24},
    { 1296, -240, 72},
    { 1360, 152, 8},
    { 1208, 456, -240},
    { 1160, 272, -248},
    { 1200, -48, 336},
    { 1352, 272, 392},
    { 1248, 512, 232},
    { 984, 544, 80},
    { 792, 456, 104},
    { 784, 392, 144},
    { 840, 504, 48},
    { 944, 488, 112},
    { 1104, 704, 104},
    { 1600, 824, 328},
    { 1680, 616, 192},
    { 1064, 568, 48},
    { 928, 448, 16},
    { 1200, 280, 40},
    { 1432, 96, 160},
    { 1304, 96, 208},
    { 1152, 120, 40},
    // 33 seconds
    { 1024, 32, 128},
    { 904, 32, 72},
    { 824, 0, 56},
    { 768, -32, 32},
    { 768, -80, -48},
    { 880, 48, -176},
    { 1232, 24, -104},
    { 1584, -152, 104},
    { 1232, 168, -176},
    { 1056, 264, -296},
    { 1336, 128, -32},
    { 1248, 152, 120},
    { 1184, 280, 120},
    { 1072, 296, 184},
    { 976, 432, 144},
    { 808, 384, 72},
    { 824, 368, 8},
    { 904, 408, -8},
    { 1040, 400, -40},
    { 1200, 480, -72},
    { 1600, 464, 24},
    { 1688, 424, 152},
    { 1080, 416, 24},
    { 1144, 208, 96},
    { 1456, 104, 168},
    // 34 seconds
    { 1400, 32, 224},
    { 1176, 24, 176},
    { 1056, 16, 176},
    { 992, -24, 176},
    { 936, -32, 136},
    { 848, -64, 128},
    { 776, -24, 72},
    { 784, -8, -48},
    { 864, 88, -224},
    { 1072, -72, -216},
    { 1328, -280, 80},
    { 1336, 24, 104},
    { 1328, 320, -72},
    { 1336, 360, -40},
    { 1184, 256, 248},
    { 1152, 272, 256},
    { 1120, 400, 256},
    { 1024, 432, 248},
    { 856, 360, 176},
    { 808, 368, 64},
    { 888, 448, -8},
    { 992, 520, -8},
    { 1248, 584, -64},
    { 1392, 456, 56},
    { 1680, 344, 104},
    // 35 seconds
    { 1312, 376, 88},
    { 1112, 240, 160},
    { 1312, 176, 200},
    { 1368, 120, 320},
    { 1240, 104, 304},
    { 1056, 56, 232},
    { 1000, 88, 152},
    { 944, 40, 128},
    { 824, 16, 72},
    { 672, 0, 24},
    { 560, -32, -48},
    { 680, 8, -168},
    { 960, 32, -160},
    { 1552, -112, 200},
    { 1744, 200, 272},
    { 1312, 600, -216},
    { 1216, 368, -136},
    { 1128, 200, 208},
    { 1184, 152, 208},
    { 1088, 248, 216},
    { 984, 400, 48},
    { 872, 344, 40},
    { 808, 352, -48},
    { 888, 424, -104},
    { 992, 504, -184},
    // 36 seconds
    { 1104, 392, -136},
    { 1248, 264, -48},
    { 1696, 200, 112},
    { 1688, 264, 192},
    { 1032, 248, 176},
    { 1072, 128, 136},
    { 1320, 80, 224},
    { 1336, 72, 296},
    { 1128, 32, 232},
    { 1008, 48, 168},
    { 960, 56, 112},
    { 880, 8, 120},
    { 816, 8, 96},
    { 800, -16, 72},
    { 776, -64, 0},
    { 816, 48, -208},
    { 1248, -80, -208},
    { 1544, -280, 152},
    { 1504, 72, 24},
    { 1312, 280, -88},
    { 1352, 160, 176},
    { 1376, 440, 368},
    { 1192, 416, 344},
    { 952, 456, 320},
    { 800, 304, 224},
    // 37 seconds
    { 792, 336, 120},
    { 848, 224, 40},
    { 904, 176, 16},
    { 944, 312, -8},
    { 1144, 472, -88},
    { 1368, 352, 64},
    { 1792, 304, 184},
    { 1344, 456, 256},
    { 984, 264, 256},
    { 1288, 64, 216},
    { 1416, 16, 376},
    { 1264, 96, 264},
    { 1232, 128, 184},
    { 1088, 48, 96},
    { 928, -48, 120},
    { 784, -56, 56},
    { 680, -64, 16},
    { 576, -120, -32},
    { 776, 8, -200},
    { 1080, -80, -128},
    { 1544, -240, 40},
    { 1720, 0, 128},
    { 1600, 336, -120},
    { 1448, 320, -56},
    { 1288, 360, 144},
    // 38 seconds
    { 1120, 200, 232},
    { 1032, 272, 280},
    { 968, 152, 312},
    { 880, 320, 168},
    { 840, 360, 48},
    { 832, 440, -80},
    { 952, 320, -176},
    { 1216, 280, -232},
    { 1672, 248, -176},
    { 1912, 408, -176},
    { 1296, 360, -160},
    { 1144, 176, -32},
    { 1376, 80, 56},
    { 1368, -8, 160},
    { 1216, 24, 136},
    { 1072, -48, 184},
    { 992, -64, 208},
    { 928, 0, 184},
    { 912, 80, 80},
    { 824, -8, 88},
    { 840, -48, 8},
    { 888, -24, -128},
    { 1144, -128, -128},
    { 1424, -128, 80},
    { 1288, 56, 128},
    // 39 seconds
    { 1048, 224, -216},
    { 1376, 200, -176},
    { 1376, 168, 200},
    { 1224, 232, 160},
    { 1120, 360, 192},
    { 1000, 256, 168},
    { 896, 184, 128},
    { 880, 160, 144},
    { 872, 392, -16},
    { 1024, 448, -8},
    { 1312, 632, -24},
    { 1656, 696, 168},
    { 1712, 448, 200},
    { 1096, 240, 96},
    { 1200, 192, 160},
    { 1680, 168, -240},
    { 1280, -1240, 560},
    { 1376, 136, 64},
    { 1008, -264, 384},
    { 1040, 64, 240},
    { 904, 24, 120},
    { 824, 64, 48},
    { 744, 8, 40},
    { 728, -88, 8},
    { 800, -16, -176},
    // 40 seconds
    { 1256, -312, 24},
    { 1640, -40, 200},
    { 1528, 352, -48},
    { 1344, 400, -208},
    { 1152, 160, 56},
    { 1040, -8, 368},
    { 1120, 288, 224},
    { 1048, 296, 184},
    { 968, 320, 152},
    { 904, 320, 72},
    { 848, 416, 16},
    { 920, 496, 0},
    { 1120, 536, 32},
    { 1264, 504, 112},
    { 1592, 360, 136},
    { 1816, 400, 256},
    { 1184, 392, 176},
    { 1288, 248, 184},
    { 1536, 176, 280},
    { 1424, 40, 328},
    { 1256, 16, 256},
    { 1144, -32, 248},
    { 936, -64, 200},
    { 728, -32, 120},
    { 544, -24, -40},
    // 41 seconds
    { 496, -104, -8},
    { 608, -128, -16},
    { 856, -48, -48},
    { 1568, -184, 144},
    { 1984, 200, 48},
    { 1616, 336, -40},
    { 1632, 544, -184},
    { 1400, 744, -104},
    { 1080, 328, 144},
    { 880, 424, 296},
    { 920, 256, 280},
    { 808, 408, 40},
    { 784, 368, 48},
    { 816, 520, -32},
    { 872, 512, -8},
    { 1112, 544, -80},
    { 1280, 488, -48},
    { 1864, 368, 88},
    { 1696, 296, 216},
    { 1160, 416, 24},
    { 1344, 280, 8},
    { 1256, 88, 136},
    { 1032, 48, 200},
    { 840, -24, 288},
    { 720, 72, 112},
    // 42 seconds
    { 680, 80, 80},
    { 656, 40, 152},
    { 736, 32, 96},
    { 752, 24, 96},
    { 856, 88, -72},
    { 1200, 96, -152},
    { 1656, -144, 40},
    { 1936, -56, 208},
    { 1192, 536, -216},
    { 1064, 376, -184},
    { 1040, 240, 120},
    { 896, 136, 352},
    { 888, 136, 312},
    { 840, 136, 296},
    { 832, 296, 216},
    { 752, 328, 64},
    { 784, 360, -32},
    { 832, 360, -24},
    { 1080, 368, -8},
    { 1352, 312, -8},
    { 1904, 248, 176},
    { 1488, 296, 144},
    { 976, 248, 32},
    { 1104, 264, 24},
    { 1312, 280, 0},
    // 43 seconds
    { 1248, 224, 24},
    { 1080, 96, 120},
    { 936, -104, 240},
    { 840, -120, 232},
    { 768, -72, 168},
    { 680, 0, 144},
    { 600, -8, 112},
    { 688, -16, 32},
    { 912, 112, -104},
    { 1504, 16, -16},
    { 1584, -88, 312},
    { 1392, 200, 72},
    { 1200, 344, -200},
    { 1080, 312, 8},
    { 1008, 200, 160},
    { 976, 240, 112},
    { 984, 240, 152},
    { 952, 360, 104},
    { 904, 312, 80},
    { 872, 552, -184},
    { 1024, 584, -152},
    { 1168, 504, -40},
    { 1296, 352, 80},
    { 1736, 312, 208},
    { 1752, 344, 216},
    // 44 seconds
    { 1176, 360, 88},
    { 1136, 248, 88},
    { 1392, 96, 224},
    { 1312, 0, 256},
    { 1056, 48, 216},
    { 920, 16, 168},
    { 856, 0, 152},
    { 768, 8, 120},
    { 712, -8, 104},
    { 672, -48, 72},
    { 728, -72, 16},
    { 896, 48, -112},
    { 1312, -64, -40},
    { 1624, -88, 176},
    { 1600, 168, 56},
    { 1496, 504, -296},
    { 1360, 384, -120},
    { 1024, 120, 232},
    { 1016, 288, 160},
    { 1008, 192, 272},
    { 968, 264, 240},
    { 856, 312, 144},
    { 792, 360, 32},
    { 832, 384, 40},
    { 1104, 432, 24},
    // 45 seconds
    { 1200, 424, 64},
    { 1592, 392, 120},
    { 1664, 472, 144},
    { 1024, 352, 112},
    { 1096, 240, 120},
    { 1424, 136, 208},
    { 1360, 136, 232},
    { 1176, 72, 232},
    { 1040, 24, 224},
    { 968, 8, 200},
    { 912, -32, 184},
    { 856, -48, 184},
    { 800, -32, 104},
    { 816, -40, 32},
    { 952, 120, -168},
    { 1400, 64, -88},
    { 1344, -328, 80},
    { 1072, -112, -136},
    { 1200, 192, -336},
    { 1416, 264, -176},
    { 1232, 144, 152},
    { 1160, 248, 208},
    { 1128, 336, 280},
    { 992, 232, 200},
    { 904, 232, 88},
    // 46 seconds
    { 864, 288, 0},
    { 872, 320, -32},
    { 1032, 400, -80},
    { 1248, 352, -32},
    { 1568, 392, 16},
    { 1808, 480, 24},
    { 1168, 376, 0},
    { 1096, 232, 40},
    { 1328, 120, 112},
    { 1448, 112, 192},
    { 1280, 64, 248},
    { 1104, 0, 208},
    { 984, -40, 224},
    { 896, 16, 144},
    { 848, 0, 120},
    { 776, 8, 64},
    { 800, -40, -16},
    { 912, 24, -112},
    { 1160, -144, -72},
    { 1360, -240, 48},
    { 1368, 112, -40},
    { 1312, 256, -192},
    { 1464, 256, -144},
    { 1344, 192, 144},
    { 1272, 264, 304},
    // 47 seconds
    { 1152, 432, 240},
    { 976, 416, 144},
    { 808, 240, 88},
    { 800, 288, -16},
    { 800, 328, -32},
    { 896, 408, -48},
    { 1192, 368, 8},
    { 1464, 360, 112},
    { 1936, 472, 208},
    { 1232, 288, 152},
    { 1216, 176, 80},
    { 1488, 208, 152},
    { 1488, 200, 200},
    { 1264, 152, 168},
    { 1120, 56, 192},
    { 976, -64, 240},
    { 856, -56, 144},
    { 760, -64, 104},
    { 672, -56, 40},
    { 672, -96, -8},
    { 904, 16, -136},
    { 1192, -80, -80},
    { 1600, -280, 200},
    { 1536, 112, 152},
    { 1352, 496, -208},
    // 48 seconds
    { 1416, 368, -24},
    { 1584, 808, 288},
    { 1096, 0, 440},
    { 976, 264, 256},
    { 944, 216, 312},
    { 864, 272, 272},
    { 848, 320, 152},
    { 832, 376, 8},
    { 1056, 576, 40},
    { 1280, 608, 176},
    { 1440, 720, 208},
    { 1728, 720, 256},
    { 1240, 600, 168},
    { 1232, 280, 184},
    { 1600, 184, 304},
    { 1600, 88, 384},
    { 1424, 128, 320},
    { 1224, 48, 288},
    { 944, 8, 240},
    { 776, 32, 112},
    { 648, -72, 96},
    { 536, -96, 40},
    { 520, -168, 0},
    { 744, -16, -160},
    { 1000, 144, -200},
    // 49 seconds
    { 1496, -56, 120},
    { 1776, 144, 216},
    { 1696, 384, -88},
    { 1496, 432, -168},
    { 1408, 184, -96},
    { 1128, 304, 272},
    { 1120, 368, 272},
    { 920, 320, 280},
    { 776, 336, 136},
    { 800, 336, 96},
    { 848, 488, 40},
    { 896, 432, 40},
    { 1192, 480, -24},
    { 1376, 384, 48},
    { 1752, 504, 56},
    { 1496, 432, 56},
    { 1176, 320, 32},
    { 1384, 216, 112},
    { 1480, 96, 200},
    { 1352, 56, 248},
    { 1232, 32, 232},
    { 1080, -24, 232},
    { 952, -32, 176},
    { 824, -16, 120},
    { 704, -32, 72},
    // 50 seconds
    { 688, -80, 24},
    { 768, -8, -96},
    { 856, -80, -80},
    { 1376, -200, 48},
    { 1496, 72, 72},
    { 1512, 400, -40},
    { 1496, 608, -136},
    { 1208, 376, 120},
    { 1136, 280, 224},
    { 1080, 224, 296},
    { 992, 280, 216},
    { 864, 288, 160},
    { 760, 296, 104},
    { 808, 344, 56},
    { 920, 408, 64},
    { 1056, 472, 24},
    { 1200, 560, 16},
    { 1752, 720, 96},
    { 1904, 744, 208},
    { 1200, 384, 104},
    { 1256, 264, 112},
    { 2560, 32, -1336},
    { 1280, -184, 208},
    { 1200, -80, 280},
    { 1056, 64, 192},
    // 51 seconds
    { 944, 8, 184},
    { 808, 8, 152},
    { 720, -32, 144},
    { 640, -64, 144},
    { 680, -72, 32},
    { 896, 8, -80},
    { 1256, 96, -72},
    { 1680, -128, 80},
    { 1472, -40, -144},
    { 1224, 232, -368},
    { 1400, 216, -192},
    { 1344, 184, 56},
    { 1192, 264, 176},
    { 1088, 320, 200},
    { 888, 400, 64},
    { 808, 312, 48},
    { 800, 424, 8},
    { 832, 368, -40},
    { 896, 464, -56},
    { 1120, 408, 0},
    { 1296, 424, 144},
    { 1840, 704, 160},
    { 1552, 608, 64},
    { 1080, 456, 40},
    { 1248, 344, 56},
    // 52 seconds
    { 1432, 184, 152},
    { 1320, 96, 248},
    { 1128, 120, 176},
    { 1016, 32, 192},
    { 824, -72, 208},
    { 704, -32, 120},
    { 656, -16, 64},
    { 640, -56, 40},
    { 688, -88, -32},
    { 896, 40, -192},
    { 1344, -176, -72},
    { 1880, 32, 312},
    { 1816, 600, 80},
    { 1592, 1008, -304},
    { 1128, 672, 152},
    { 944, 216, 296},
    { 928, 64, 296},
    { 904, 96, 304},
    { 888, 312, 232},
    { 816, 368, 120},
    { 776, 440, 8},
    { 856, 432, 56},
    { 992, 512, -8},
    { 1184, 520, 24},
    { 1944, 600, 128},
    // 53 seconds
    { 1616, 512, 200},
    { 1104, 344, 96},
    { 1344, 304, 80},
    { 1536, 288, 216},
    { 1344, 136, 176},
    { 1136, 0, 256},
    { 984, -8, 176},
    { 872, 0, 144},
    { 768, 8, 144},
    { 672, -8, 96},
    { 648, -88, 96},
    { 776, -72, 16},
    { 976, -8, -104},
    { 1592, -152, 80},
    { 1760, 24, 256},
    { 1296, 440, -136},
    { 1304, 376, -256},
    { 1272, 224, 104},
    { 1208, 224, 328},
    { 1112, 424, 176},
    { 1000, 360, 264},
    { 864, 336, 184},
    { 792, 288, 136},
    { 840, 320, 40},
    { 848, 368, 0},
    // 54 seconds
    { 1088, 488, -72},
    { 1208, 472, -32},
    { 1792, 488, 16},
    { 1576, 408, 96},
    { 1080, 280, 80},
    { 1232, 224, 48},
    { 1456, 184, 160},
    { 1296, 72, 208},
    { 1160, 40, 200},
    { 1008, 64, 136},
    { 928, 32, 152},
    { 824, -8, 168},
    { 736, -16, 144},
    { 704, -64, 128},
    { 784, -24, 8},
    { 944, 88, -128},
    { 1416, -96, -8},
    { 1544, -152, 160},
    { 1208, 216, -56},
    { 1224, 368, -304},
    { 1240, 232, 40},
    { 1208, 192, 256},
    { 1168, 336, 216},
    { 1056, 368, 240},
    { 928, 448, 208},
    // 55 seconds
    { 832, 320, 144},
    { 848, 360, 56},
    { 864, 344, 40},
    { 1064, 448, -64},
    { 1152, 480, -48},
    { 1584, 504, 24},
    { 1784, 448, 184},
    { 1128, 392, 80},
    { 1008, 288, 32},
    { 1368, 224, 80},
    { 1456, 72, 216},
    { 1192, 72, 216},
    { 1088, 16, 192},
    { 992, 0, 200},
    { 872, 16, 176},
    { 792, 0, 136},
    { 720, -24, 120},
    { 680, -24, 24},
    { 808, 56, -120},
    { 1064, -24, -80},
    { 1512, -176, 88},
    { 1496, -8, 96},
    { 1320, 288, -112},
    { 1352, 400, -144},
    { 1280, 248, 168},
    // 56 seconds
    { 1200, 312, 200},
    { 1136, 344, 256},
    { 1000, 376, 200},
    { 848, 320, 96},
    { 760, 360, 16},
    { 808, 400, -56},
    { 816, 312, 16},
    { 1160, 368, 0},
    { 1296, 392, 96},
    { 1792, 384, 192},
    { 1656, 344, 128},
    { 1120, 184, 104},
    { 1232, 200, 40},
    { 1416, 88, 128},
    { 1328, 48, 192},
    { 1144, 56, 192},
    { 1016, 0, 184},
    { 920, -32, 192},
    { 816, -8, 128},
    { 696, -16, 104},
    { 624, -16, 88},
    { 632, -56, 24},
    { 864, 8, -24},
    { 1328, 16, -104},
    { 1696, -24, 16},
    // 57 seconds
    { 1480, 64, 48},
    { 1080, 296, -280},
    { 1216, 224, -200},
    { 1216, 312, 72},
    { 1128, 384, 64},
    { 1024, 288, 160},
    { 984, 296, 224},
    { 840, 344, 96},
    { 776, 168, 136},
    { 848, 312, 112},
    { 904, 472, 120},
    { 1160, 624, 72},
    { 1312, 512, 176},
    { 1712, 672, 64},
    { 1448, 392, 40},
    { 976, -48, 152},
    { 1176, 32, 56},
    { 1296, 80, 40},
    { 1232, 104, 64},
    { 1088, 48, 168},
    { 944, 40, 112},
    { 872, 56, 40},
    { 816, 16, 40},
    { 760, -8, 24},
    { 704, -24, -24},
    // 58 seconds
    { 776, 0, -112},
    { 928, 8, -152},
    { 1384, -208, 8},
    { 1688, -96, 128},
    { 1592, 288, -16},
    { 1352, 504, -256},
    { 1088, 304, 88},
    { 1040, 232, 224},
    { 1000, 208, 264},
    { 968, 184, 264},
    { 888, 272, 216},
    { 784, 304, 88},
    { 752, 296, 0},
    { 832, 352, -56},
    { 952, 304, -24},
    { 1208, 392, -112},
    { 1512, 344, -32},
    { 1880, 424, 40},
    { 1360, 400, 112},
    { 936, 216, 72},
    { 1224, 136, 104},
    { 1272, 72, 160},
    { 1088, 88, 168},
    { 976, 24, 192},
    { 920, -24, 168},
    // 59 seconds
    { 816, 16, 136},
    { 736, -8, 152},
    { 696, 8, 80},
    { 696, 24, 16},
    { 904, 72, -64},
    { 1088, 72, -120},
    { 1544, -200, 96},
    { 1616, -104, 176},
    { 1152, 328, -120},
    { 1104, 408, -328},
    { 1024, 256, -16},
    { 984, 112, 144},
    { 960, 216, 152},
    { 952, 192, 224},
    { 864, 352, 48},
    { 824, 328, 32},
    { 856, 368, -24},
    { 912, 336, -24},
    { 1104, 328, -8},
    { 1264, 352, 0},
    { 1672, 384, 104},
    { 1840, 472, 112},
    { 1048, 312, 24},
    { 952, 208, 40},
    { 1360, -8, 8},
    // 60 seconds
    // elapsed: 1 minutes
    { 1144, -176, 312},
    { 1080, 208, 88},
    { 944, 16, 248},
    { 880, 112, 184},
    { 856, 32, 184},
    { 808, 32, 144},
    { 728, 8, 64},
    { 688, -16, 32},
    { 864, 104, -144},
    { 1216, -72, -64},
    { 1664, -184, 120},
    { 1512, 128, -32},
    { 1120, 344, -272},
    { 1128, 136, -80},
    { 1200, 64, -112},
    { 1040, 224, 168},
    { 1000, 208, 272},
    { 944, 312, 160},
    { 832, 248, 104},
    { 808, 352, 0},
    { 888, 400, -56},
    { 1008, 472, -112},
    { 1192, 248, -184},
    { 1344, 112, -40},
    { 1744, 144, 16},
    // 61 seconds
    { 1464, 336, 32},
    { 968, 184, 112},
    { 1144, 48, 152},
    { 1296, -24, 240},
    { 1200, 64, 248},
    { 1104, 136, 160},
    { 1024, 80, 72},
    { 944, 32, 72},
    { 872, -32, 120},
    { 760, -32, 80},
    { 720, -8, 32},
    { 800, -24, -136},
    { 904, -128, -184},
    { 1488, -360, 48},
    { 1608, -40, 96},
    { 1320, 312, -184},
    { 1272, 232, -184},
    { 1232, 168, 160},
    { 1168, 144, 256},
    { 1160, 248, 304},
    { 1032, 360, 192},
    { 864, 320, 72},
    { 840, 320, -24},
    { 864, 344, -32},
    { 1016, 384, -48},
    // 62 seconds
    { 1232, 400, -80},
    { 1488, 320, 32},
    { 1872, 344, 128},
    { 1152, 288, 96},
    { 1088, 160, 72},
    { 1368, 88, 152},
    { 1424, 16, 232},
    { 1144, 48, 192},
    { 1024, 24, 160},
    { 992, 8, 160},
    { 952, -8, 176},
    { 872, 8, 144},
    { 816, -40, 112},
    { 816, -72, 32},
    { 888, 96, -160},
    { 1136, -80, -152},
    { 1360, -248, 56},
    { 1216, -72, 104},
    { 1264, 240, -104},
    { 1448, 432, -216},
    { 1184, 296, 144},
    { 1088, 264, 216},
    { 1072, 256, 320},
    { 984, 280, 280},
    { 912, 304, 200},
    // 63 seconds
    { 888, 352, 112},
    { 864, 424, 72},
    { 1032, 456, -24},
    { 1184, 456, 16},
    { 1624, 568, 88},
    { 1792, 632, 144},
    { 1112, 520, 24},
    { 960, 360, 40},
    { 1240, 232, 88},
    { 1360, 64, 168},
    { 1240, 8, 320},
    { 1096, 16, 264},
    { 968, 24, 152},
    { 872, 16, 144},
    { 808, -16, 168},
    { 792, 56, 120},
    { 800, -32, 96},
    { 912, 16, -88},
    { 1072, -72, -104},
    { 1496, -336, 152},
    { 1496, 64, 72},
    { 1184, 552, -288},
    { 1136, 440, -240},
    { 1080, 168, 136},
    { 1112, 408, 208},
    // 64 seconds
    { 952, 488, 80},
    { 936, 352, 200},
    { 856, 376, 136},
    { 848, 384, 112},
    { 888, 440, 56},
    { 992, 408, 120},
    { 1168, 408, 112},
    { 1608, 480, 152},
    { 1728, 656, 144},
    { 1056, 448, 32},
    { 1152, 328, 0},
    { 1480, 216, 104},
    { 1384, 128, 176},
    { 1168, 96, 160},
    { 1032, 40, 152},
    { 912, -16, 192},
    { 840, -48, 232},
    { 784, -16, 144},
    { 760, -40, 104},
    { 840, -16, 16},
    { 912, 32, -80},
    { 1432, -120, 8},
    { 1664, -96, 200},
    { 1104, 328, 56},
    { 1096, 448, -288},
    // 65 seconds
    { 1136, 296, -88},
    { 1120, 200, 112},
    { 1160, 304, 128},
    { 1120, 288, 200},
    { 1008, 536, 176},
    { 776, 344, 136},
    { 792, 320, 24},
    { 968, 336, 64},
    { 1248, 480, -32},
    { 1216, 472, -16},
    { 1728, 560, 40},
    { 1640, 544, 120},
    { 992, 288, 56},
    { 1160, 208, 96},
    { 1440, 104, 232},
    { 1304, 8, 320},
    { 1088, 32, 256},
    { 976, 8, 208},
    { 912, 8, 184},
    { 896, -32, 192},
    { 840, -8, 136},
    { 824, -32, 64},
    { 896, -32, -32},
    { 968, -40, -104},
    { 1376, -216, 24},
    // 66 seconds
    { 1408, -56, 72},
    { 1208, 256, -216},
    { 1280, 248, -280},
    { 1288, 160, 96},
    { 1232, 200, 304},
    { 1272, 512, 232},
    { 1104, 544, 320},
    { 880, 392, 232},
    { 792, 384, 96},
    { 872, 416, 72},
    { 960, 464, 48},
    { 1144, 488, 0},
    { 1552, 464, 112},
    { 1832, 576, 176},
    { 1200, 424, 56},
    { 1112, 296, 16},
    { 1360, 144, 136},
    { 1416, 8, 216},
    { 1160, 48, 288},
    { 1016, 8, 232},
    { 936, 32, 176},
    { 872, 64, 152},
    { 824, 24, 160},
    { 848, 0, 144},
    { 944, -32, 16},
    // 67 seconds
    { 992, 56, -160},
    { 1304, -64, -128},
    { 1368, -176, 48},
    { 1160, -16, 48},
    { 1120, 144, 16},
    { 1320, 288, -8},
    { 1264, 312, 248},
    { 1192, 344, 320},
    { 1160, 416, 360},
    { 976, 392, 304},
    { 808, 288, 128},
    { 832, 440, 32},
    { 896, 552, 0},
    { 1064, 536, 72},
    { 1232, 456, 136},
    { 1648, 384, 192},
    { 1704, 440, 128},
    { 1160, 272, 120},
    { 1304, 208, 128},
    { 1552, 72, 224},
    { 1408, -16, 232},
    { 1176, 32, 168},
    { 1008, -32, 192},
    { 880, -32, 160},
    { 784, 8, 120},
    // 68 seconds
    { 712, -16, 120},
    { 696, -64, 96},
    { 800, -72, 8},
    { 904, 16, -80},
    { 1408, -80, -96},
    { 1600, -168, 112},
    { 1488, 120, 112},
    { 1496, 432, -264},
    { 1424, 272, 16},
    { 1176, 296, 304},
    { 1112, 384, 288},
    { 976, 216, 304},
    { 816, 280, 192},
    { 752, 320, 152},
    { 728, 448, 88},
    { 864, 528, 96},
    { 1024, 512, 64},
    { 1144, 448, 64},
    { 1616, 448, 112},
    { 1728, 488, 216},
    { 1192, 352, 136},
    { 1200, 304, 64},
    { 1440, 160, 192},
    { 1448, 120, 200},
    { 1232, 88, 184},
    // 69 seconds
    { 1024, 8, 200},
    { 888, -16, 160},
    { 832, -40, 128},
    { 776, -16, 80},
    { 704, -16, 64},
    { 712, -64, 16},
    { 864, 64, -176},
    { 1136, -88, -88},
    { 1616, -304, 96},
    { 1792, 184, 8},
    { 1544, 480, -216},
    { 1280, 264, -32},
    { 1312, 8, 264},
    { 1096, 328, 376},
    { 1024, 408, 320},
    { 872, 312, 288},
    { 800, 384, 136},
    { 720, 344, 56},
    { 784, 464, -24},
    { 952, 488, 16},
    { 1096, 552, -16},
    { 1240, 488, 80},
    { 1712, 560, 96},
    { 1352, 488, 88},
    { 1080, 264, 112},
    // 70 seconds
    { 1408, 144, 200},
    { 1544, 88, 264},
    { 1344, 40, 256},
    { 1160, 48, 192},
    { 1048, 72, 104},
    { 920, 32, 104},
    { 816, 0, 104},
    { 704, -48, 56},
    { 632, -104, 0},
    { 792, -16, -80},
    { 928, -104, -24},
    { 1456, -136, -96},
    { 1760, 24, 160},
    { 1400, 456, -224},
    { 1384, 440, -328},
    { 1152, 216, 120},
    { 1024, 152, 200},
    { 968, 168, 240},
    { 984, 200, 192},
    { 856, 248, 120},
    { 784, 288, 8},
    { 808, 312, -16},
    { 960, 336, 32},
    { 1232, 448, -16},
    { 1544, 416, 88},
    // 71 seconds
    { 1848, 528, 136},
    { 1072, 320, 104},
    { 1088, 176, 80},
    { 1408, 96, 184},
    { 1448, -760, 72},
    { 1128, 120, 168},
    { 1064, 72, 176},
    { 960, 0, 144},
    { 880, -8, 120},
    { 800, -8, 104},
    { 736, -24, 80},
    { 808, -80, 0},
    { 912, -8, -88},
    { 1280, -152, -64},
    { 1632, -192, 112},
    { 1360, 216, 0},
    { 1144, 400, -288},
    { 1208, 128, -48},
    { 1192, 104, 304},
    { 1176, 232, 328},
    { 1112, 312, 344},
    { 968, 400, 240},
    { 792, 296, 160},
    { 792, 368, 32},
    { 832, 336, 48},
    // 72 seconds
    { 1104, 264, 64},
    { 1264, 464, -16},
    { 1912, 648, 112},
    { 1768, 576, 160},
    { 1088, 192, 72},
    { 1184, 128, 80},
    { 1688, 8, -224},
    { 1392, -32, 264},
    { 1248, -8, 240},
    { 1056, -56, 216},
    { 944, -16, 152},
    { 848, -24, 160},
    { 736, -8, 120},
    { 656, -40, 64},
    { 728, -64, -32},
    { 856, 64, -184},
    { 1336, -184, -16},
    { 1560, -168, 168},
    { 1440, 296, -40},
    { 1488, 440, -184},
    { 1376, 344, 104},
    { 1096, 288, 240},
    { 1048, 288, 240},
    { 984, 304, 240},
    { 936, 360, 184},
    // 73 seconds
    { 840, 400, 88},
    { 792, 432, 16},
    { 912, 464, -8},
    { 1104, 440, 16},
    { 1224, 360, 120},
    { 1808, 408, 168},
    { 1592, 440, 168},
    { 896, 280, 56},
    { 1104, 240, 64},
    { 1376, 104, 176},
    { 1240, 48, 200},
    { 1080, 72, 144},
    { 952, 16, 136},
    { 808, 8, 104},
    { 776, -16, 64},
    { 736, -24, 64},
    { 728, -16, 16},
    { 848, 8, -80},
    { 1008, -8, -88},
    { 1568, -248, 120},
    { 1672, 8, 208},
    { 1288, 416, -104},
    { 1240, 368, -200},
    { 1120, 152, 168},
    { 1080, 184, 296},
    // 74 seconds
    { 1080, 280, 272},
    { 960, 352, 208},
    { 824, 336, 104},
    { 848, 352, -8},
    { 800, 424, -96},
    { 912, 464, -80},
    { 1160, 400, 8},
    { 1264, 248, 184},
    { 1880, 216, 232},
    { 1352, 312, 152},
    { 1192, 184, 112},
    { 1448, 88, 168},
    { 1512, 72, 240},
    { 1280, 32, 208},
    { 1072, 0, 128},
    { 944, -8, 64},
    { 816, -8, 56},
    { 704, 0, 16},
    { 616, -64, 16},
    { 568, -96, -32},
    { 720, -24, -104},
    { 1024, -136, 8},
    { 1680, -192, 368},
    { 1792, 264, 400},
    { 1488, 680, -96},
    // 75 seconds
    { 1320, 352, 8},
    { 1112, 280, 256},
    { 1064, 168, 336},
    { 992, 200, 264},
    { 864, 280, 176},
    { 808, 304, 136},
    { 808, 352, 56},
    { 776, 304, 72},
    { 984, 304, 80},
    { 1232, 336, 48},
    { 1720, 280, 120},
    { 1696, 416, 40},
    { 1032, 328, -64},
    { 1136, 264, -120},
    { 1280, 128, -48},
    { 1264, 112, -8},
    { 1008, 72, 0},
    { 832, -8, 40},
    { 744, 64, 24},
    { 680, 96, 16},
    { 616, 80, 16},
    { 624, 56, 0},
    { 752, 80, -16},
    { 1000, 160, -80},
    { 1192, 104, 0},
    // 76 seconds
    { 2128, -256, 392},
    { 1920, 288, 216},
    { 1128, 592, -256},
    { 832, -72, 56},
    { 920, -8, 200},
    { 792, 32, 304},
    { 856, 48, 384},
    { 832, 144, 448},
    { 744, 336, 240},
    { 712, 320, 160},
    { 768, 400, 104},
    { 904, 328, 104},
    { 1280, 336, 80},
    { 1280, 336, 104},
    { 1640, 520, -80},
    { 1584, 656, -24},
    { 1016, 416, -8},
    { 1168, 312, -24},
    { 1336, 192, 88},
    { 976, -128, 480},
    { 1040, 264, 32},
    { 1024, -88, 232},
    { 888, 40, 128},
    { 824, 48, 80},
    { 768, 32, 72},
    // 77 seconds
    { 752, -16, 80},
    { 824, -56, 32},
    { 976, 32, -96},
    { 1256, -112, -24},
    { 1632, -184, 184},
    { 1648, 208, 40},
    { 1280, 448, -288},
    { 992, 184, -48},
    { 968, 112, 208},
    { 1000, 264, 200},
    { 952, 192, 320},
    { 880, 336, 256},
    { 744, 288, 192},
    { 808, 368, 88},
    { 1040, 400, 64},
    { 1256, 400, 64},
    { 1216, 416, 56},
    { 1728, 496, 48},
    { 1288, 504, 72},
    { 1064, 360, 72},
    { 1304, 264, 104},
    { 1360, 320, 352},
    { 1152, -120, 112},
    { 1176, 48, 168},
    { 1072, 24, 216},
    // 78 seconds
    { 960, 16, 168},
    { 864, -24, 104},
    { 776, -72, 96},
    { 840, -112, 48},
    { 1040, -72, -48},
    { 1176, -192, -40},
    { 1560, 24, 112},
    { 1288, 272, 120},
    { 1240, 552, -136},
    { 1256, 720, -56},
    { 1008, 528, 216},
    { 936, 336, 256},
    { 944, 280, 248},
    { 880, 272, 264},
    { 776, 304, 208},
    { 800, 288, 120},
    { 960, 344, 64},
    { 1216, 408, 8},
    { 1336, 440, -64},
    { 1608, 400, -32},
    { 1632, 496, -40},
    { 936, 464, -24},
    { 984, 312, 24},
    { 1328, 96, 104},
    { 1256, 56, 256},
    // 79 seconds
    { 1136, 40, 216},
    { 1032, -16, 216},
    { 888, -16, 200},
    { 800, -8, 200},
    { 752, -32, 168},
    { 744, -24, 112},
    { 864, -16, 64},
    { 1152, 40, 0},
    { 1304, 24, 8},
    { 1600, -144, 184},
    { 1400, 32, 136},
    { 1088, 360, -240},
    { 1096, 312, -224},
    { 1056, 528, -400},
    { 1056, 176, 168},
    { 944, 288, 88},
    { 848, 176, 240},
    { 816, 312, 176},
    { 792, 216, 184},
    { 912, 328, 32},
    { 1040, 320, 32},
    { 1240, 392, -8},
    { 1280, 352, 72},
    { 1552, 456, -8},
    { 1200, 424, 56},
    // 80 seconds
    { 1120, 296, 104},
    { 1272, 136, 216},
    { 1288, 64, 256},
    { 1184, 24, 256},
    { 1056, 32, 216},
    { 944, 32, 192},
    { 896, 16, 176},
    { 864, -24, 160},
    { 888, -72, 136},
    { 928, -72, 64},
    { 960, 24, -40},
    { 1352, -144, 8},
    { 1408, -176, 184},
    { 1104, 136, 40},
    { 1136, 344, -248},
    { 1200, 296, -160},
    { 1088, 120, -56},
    { 1256, 528, 40},
    { 1096, 296, 168},
    { 1008, 408, 216},
    { 864, 328, 144},
    { 824, 344, 24},
    { 888, 360, -48},
    { 1088, 336, -56},
    { 1208, 328, -40},
    // 81 seconds
    { 1504, 296, 40},
    { 1600, 392, 64},
    { 1112, 360, 104},
    { 1072, 232, 96},
    { 1312, 112, 176},
    { 1328, 80, 232},
    { 1144, 80, 192},
    { 1040, 24, 168},
    { 976, 16, 128},
    { 912, -16, 120},
    { 832, 16, 72},
    { 760, -16, 40},
    { 760, -104, 32},
    { 928, 0, -88},
    { 1280, -88, -104},
    { 1520, -120, 136},
    { 1352, 128, 8},
    { 1304, 248, -248},
    { 1392, 184, -64},
    { 1184, 144, 256},
    { 1136, 296, 184},
    { 1040, 240, 248},
    { 936, 304, 232},
    { 816, 248, 112},
    { 792, 272, 40},
    // 82 seconds
    { 856, 344, -32},
    { 1024, 408, -16},
    { 1272, 488, -72},
    { 1560, 368, -32},
    { 1816, 360, 16},
    { 1248, 256, 96},
    { 1264, 184, 40},
    { 1464, 8, 136},
    { 1384, -56, 168},
    { 1240, 40, 184},
    { 1112, 32, 192},
    { 928, -32, 184},
    { 768, -40, 144},
    { 704, -16, 80},
    { 648, -64, 80},
    { 664, -96, 32},
    { 832, -8, -88},
    { 1136, -104, -48},
    { 1736, -160, 272},
    { 1824, 336, 280},
    { 1296, 816, -48},
    { 1080, 464, 104},
    { 1048, 32, 384},
    { 904, 112, 440},
    { 960, 264, 336},
    // 83 seconds
    { 944, 296, 352},
    { 840, 432, 328},
    { 728, 360, 280},
    { 792, 344, 152},
    { 920, 368, 96},
    { 1168, 496, 48},
    { 1384, 384, 96},
    { 1816, 496, 240},
    { 1368, 472, 296},
    { 1248, 264, 240},
    { 1496, 168, 288},
    { 1472, -224, 160},
    { 1104, 56, 216},
    { 992, 32, 200},
    { 872, -24, 208},
    { 768, -24, 160},
    { 696, -40, 112},
    { 656, -64, 80},
    { 704, -32, 24},
    { 816, 72, -136},
    { 976, 48, -184},
    { 1536, -336, 192},
    { 1760, -24, 256},
    { 1688, 440, 16},
    { 1504, 520, -160},
    // 84 seconds
    { 1168, 280, 192},
    { 1024, 224, 312},
    { 968, 208, 312},
    { 928, 184, 216},
    { 856, 280, 152},
    { 712, 408, -24},
    { 808, 440, -56},
    { 984, 528, -40},
    { 1280, 464, 40},
    { 1424, 184, 168},
    { 1912, 184, 184},
    { 1504, 312, 208},
    { 1224, 272, 56},
    { 1360, 104, 144},
    { 1136, -1240, 88},
    { 1144, -80, 136},
    { 1056, 56, 272},
    { 904, -16, 264},
    { 816, 8, 104},
    { 768, -40, 144},
    { 768, -64, 120},
    { 800, -176, 96},
    { 912, -176, -120},
    { 1152, -104, -120},
    { 1976, 168, 88},
    // 85 seconds
    { 1608, 312, 64},
    { 1168, 32, 16},
    { 1144, -40, -24},
    { 1128, 48, 152},
    { 1184, 352, 216},
    { 1080, 472, 232},
    { 936, 456, 168},
    { 832, 368, 64},
    { 840, 312, 24},
    { 992, 344, -72},
    { 1192, 408, -96},
    { 1328, 328, -56},
    { 1624, 56, 64},
    { 1600, 168, 48},
    { 1120, 256, 128},
    { 1160, 240, 88},
    { 1368, 120, 280},
    { 1296, 40, 304},
    { 1200, 0, 264},
    { 1080, -16, 240},
    { 992, -8, 184},
    { 896, -8, 168},
    { 800, 0, 104},
    { 744, -64, 88},
    { 816, -64, -16},
    // 86 seconds
    { 888, 64, -176},
    { 1296, -136, 8},
    { 1464, -184, 160},
    { 1336, 112, 80},
    { 1320, 224, -64},
    { 1392, 240, 32},
    { 1296, 288, 216},
    { 1184, 416, 200},
    { 1008, 360, 264},
    { 904, 248, 176},
    { 864, 168, 160},
    { 840, 248, 16},
    { 896, 328, 8},
    { 1104, 440, 0},
    { 1280, 448, -8},
    { 1608, 336, 72},
    { 1736, 352, 40},
    { 1080, 280, 72},
    { 1088, 104, 112},
    { 1304, 24, 232},
    { 1240, -1072, 40},
    { 1160, 96, 176},
    { 1112, 120, 256},
    { 992, 72, 200},
    { 928, 24, 176},
    // 87 seconds
    { 880, -16, 144},
    { 792, -64, 104},
    { 760, -72, 24},
    { 848, 32, -128},
    { 1048, -104, -56},
    { 1440, -224, 88},
    { 1408, 8, 136},
    { 1224, 288, -152},
    { 1408, 208, -112},
    { 1464, 312, 136},
    { 1232, 312, 248},
    { 1096, 352, 296},
    { 904, 264, 168},
    { 832, 176, 160},
    { 848, 320, 64},
    { 848, 320, 40},
    { 936, 392, 16},
    { 1240, 440, -24},
    { 1448, 408, 24},
    { 1856, 440, 104},
    { 1344, 392, 56},
    { 1032, 344, 0},
    { 1312, 248, 48},
    { 1392, -24, 144},
    { 1256, 64, 200},
    // 88 seconds
    { 1104, 32, 224},
    { 1024, 8, 192},
    { 936, 24, 144},
    { 864, 32, 128},
    { 752, 0, 104},
    { 704, -32, 16},
    { 824, 48, -184},
    { 896, 56, -184},
    { 1392, -232, 80},
    { 1520, -32, 160},
    { 1200, 328, -56},
    { 1248, 288, -120},
    { 1336, 296, 96},
    { 1216, 408, 272},
    { 1168, 560, 168},
    { 1040, 360, 256},
    { 928, 384, 160},
    { 840, 336, 80},
    { 872, 416, -24},
    { 928, 424, -64},
    { 1208, 440, -72},
    { 1240, 456, -48},
    { 1672, 424, 24},
    { 1616, 440, 96},
    { 992, 280, 112},
    // 89 seconds
    { 1200, 184, 128},
    { 1424, 16, 280},
    { 1304, 40, 288},
    { 1144, 48, 232},
    { 1024, 16, 200},
    { 944, 16, 176},
    { 880, 8, 136},
    { 808, -8, 112},
    { 736, -40, 64},
    { 832, -64, -48},
    { 920, 64, -224},
    { 1288, -208, 0},
    { 1488, -192, 192},
    { 1272, 248, -8},
    { 1248, 352, -184},
    { 1312, 184, 80},
    { 1296, 208, 312},
    { 1248, 328, 296},
    { 1088, 408, 280},
    { 896, 368, 152},
    { 800, 264, 72},
    { 832, 264, 32},
    { 952, 352, -16},
    { 1144, 392, -24},
    { 1264, 456, -72},
    // 90 seconds
    { 1840, 424, 40},
    { 1600, 440, 136},
    { 928, 200, 120},
    { 1200, 168, 96},
    { 1424, 128, 200},
    { 1344, 96, 264},
    { 1224, 80, 184},
    { 1104, 0, 208},
    { 992, 0, 176},
    { 864, -32, 152},
    { 736, -16, 128},
    { 680, -48, 64},
    { 752, -72, 8},
    { 880, 48, -112},
    { 1424, -56, -56},
    { 1616, -120, 288},
    { 1296, 192, 56},
    { 1256, 304, -184},
    { 1272, 288, 8},
    { 1008, 248, 504},
    { 1168, 520, 184},
    { 1032, 280, 304},
    { 944, 360, 240},
    { 832, 304, 152},
    { 864, 344, 80},
    // 91 seconds
    { 936, 400, 8},
    { 1176, 416, 0},
    { 1264, 448, 48},
    { 1896, 600, 80},
    { 1352, 496, 48},
    { 960, 240, 72},
    { 1256, 192, 104},
    { 1432, 128, 176},
    { 1288, 128, 152},
    { 1216, 16, 216},
    { 1096, -64, 264},
    { 952, -16, 176},
    { 888, -8, 144},
    { 808, -16, 96},
    { 760, -56, 88},
    { 816, -40, -24},
    { 832, 16, -112},
    { 1272, -144, 48},
    { 1448, 24, 184},
    { 1224, 296, 8},
    { 1224, 288, -64},
    { 1328, 312, 80},
    { 1232, 248, 328},
    { 1152, 568, 152},
    { 1040, 376, 216},
    // 92 seconds
    { 944, 392, 176},
    { 856, 360, 48},
    { 872, 304, 8},
    { 920, 392, -24},
    { 1232, 440, -88},
    { 1256, 440, -24},
    { 1832, 448, 48},
    { 1552, 392, 184},
    { 1040, 208, 104},
    { 1328, 184, 72},
    { 1520, 56, 232},
    { 1392, 56, 248},
    { 1152, 16, 208},
    { 968, 8, 128},
    { 816, -40, 168},
    { 744, -48, 128},
    { 648, -24, 72},
    { 600, -64, 40},
    { 744, -48, -56},
    { 968, 16, -96},
    { 1536, -96, 144},
    { 1648, 32, 288},
    { 1304, 392, -88},
    { 1368, 376, -216},
    { 1352, 208, 88},
    // 93 seconds
    { 1216, 176, 296},
    { 1152, 264, 272},
    { 1048, 392, 224},
    { 912, 352, 128},
    { 816, 408, 40},
    { 832, 416, 0},
    { 920, 488, 24},
    { 1168, 496, 32},
    { 1280, 440, 136},
    { 1840, 424, 152},
    { 1520, 368, 160},
    { 1128, 152, 128},
    { 1392, 96, 192},
    { 1584, 80, 280},
    { 1408, 72, 296},
    { 1184, 40, 184},
    { 1040, 24, 152},
    { 920, 8, 136},
    { 872, 16, 48},
    { 760, -40, 16},
    { 624, -168, -56},
    { 768, -88, -136},
    { 936, -104, -96},
    { 1336, -184, 96},
    { 1400, 96, 200},
    // 94 seconds
    { 1336, 368, 72},
    { 1608, 344, 40},
    { 1656, 424, 296},
    { 1480, 536, 344},
    { 1192, 544, 328},
    { 936, 280, 200},
    { 912, 272, 112},
    { 904, 416, -40},
    { 880, 528, -32},
    { 912, 584, -80},
    { 1160, 592, -32},
    { 1600, 584, 104},
    { 1944, 504, 288},
    { 1456, 200, 288},
    { 1328, 288, 0},
    { 1768, 168, 128},
    { 1744, 56, 200},
    { 1456, 24, 208},
    { 1184, 0, 200},
    { 888, -72, 200},
    { 680, -80, 176},
    { 584, -120, 128},
    { 592, -112, 56},
    { 608, -96, -8},
    { 760, -24, -136},
    // 95 seconds
    { 1184, -136, -32},
    { 1848, -160, 440},
    { 1968, 424, 448},
    { 1472, 736, -120},
    { 1352, 432, -24},
    { 1360, 416, 280},
    { 1176, 304, 392},
    { 1056, 232, 320},
    { 944, 288, 128},
    { 824, 344, 56},
    { 872, 464, -56},
    { 928, 504, -88},
    { 1088, 368, 8},
    { 1296, 384, -56},
    { 1624, 240, 104},
    { 1920, 296, 208},
    { 1312, 304, 168},
    { 1080, 120, 72},
    { 1400, 144, 136},
    { 1472, 112, 264},
    { 1240, 40, 248},
    { 1056, -8, 224},
    { 912, 8, 160},
    { 800, -8, 184},
    { 728, 0, 144},
    // 96 seconds
    { 624, -56, 112},
    { 616, -72, 40},
    { 808, 24, -136},
    { 1088, 16, -120},
    { 1544, -136, 128},
    { 1664, 176, 120},
    { 1200, 456, -224},
    { 1320, 424, -232},
    { 1376, 400, -16},
    { 1272, 240, 272},
    { 1080, 440, 144},
    { 936, 240, 240},
    { 832, 392, 40},
    { 752, 344, 48},
    { 840, 408, 8},
    { 984, 400, -8},
    { 1224, 432, -56},
    { 1400, 304, 96},
    { 1808, 344, 152},
    { 1536, 408, 104},
    { 984, 248, 72},
    { 1232, 200, 104},
    { 1344, 0, 232},
    { 1248, 40, 224},
    { 1040, 48, 216},
    // 97 seconds
    { 936, 16, 168},
    { 840, 16, 136},
    { 776, 8, 128},
    { 720, -24, 104},
    { 680, -24, 48},
    { 800, 8, -88},
    { 936, -16, -128},
    { 1536, -152, 0},
    { 1720, -16, 152},
    { 1208, 352, -192},
    { 1272, 392, -320},
    { 1248, 192, 72},
    { 1120, 264, 208},
    { 1024, 112, 336},
    { 1024, 200, 248},
    { 856, 296, 96},
    { 792, 344, -16},
    { 848, 352, -144},
    { 904, 96, 32},
    { 1096, 384, 104},
    { 1408, 616, 48},
    { 1816, 376, 192},
    { 1704, 208, 216},
    { 952, 272, 48},
    { 952, 144, 88},
    // 98 seconds
    { 1192, -16, 224},
    { 1256, -32, 272},
    { 1136, 56, 216},
    { 960, 24, 200},
    { 816, 8, 152},
    { 736, 40, 120},
    { 728, 32, 80},
    { 704, 8, 32},
    { 776, -16, -16},
    { 1000, 104, -168},
    { 1368, -208, 80},
    { 1680, -120, 192},
    { 1272, 304, -56},
    { 1112, 400, -184},
    { 1040, 232, 56},
    { 848, 32, 448},
    { 976, 400, 168},
    { 960, 144, 280},
    { 904, 304, 144},
    { 832, 280, 104},
    { 808, 312, 48},
    { 896, 376, -24},
    { 1040, 344, -8},
    { 1256, 352, 8},
    { 1712, 312, 80},
    // 99 seconds
    { 1680, 448, 104},
    { 984, 312, 96},
    { 1056, 224, 40},
    { 1232, 144, 128},
    { 1264, 104, 144},
    { 1176, 128, 128},
    { 1056, 64, 104},
    { 928, -32, 136},
    { 784, -56, 128},
    { 704, -48, 128},
    { 696, -48, 80},
    { 808, -32, 8},
    { 968, 40, -32},
    { 1456, -128, 128},
    { 1720, -48, 312},
    { 1184, 384, 24},
    { 984, 344, -192},
    { 1048, 224, 8},
    { 1032, 24, 264},
    { 1048, 376, 96},
    { 1000, 256, 152},
    { 880, 368, 56},
    { 784, 344, 24},
    { 912, 336, -16},
    { 1008, 344, -72},
    // 100 seconds
    { 1152, 312, -104},
    { 1280, 304, -40},
    { 1864, 272, 72},
    { 1560, 416, 64},
    { 880, 344, 24},
    { 1048, 208, 24},
    { 920, -928, 200},
    { 1064, 48, 184},
    { 1024, 88, 104},
    { 1016, 120, 120},
    { 936, 72, 160},
    { 832, -24, 200},
    { 768, -8, 136},
    { 768, -40, 40},
    { 856, 24, -120},
    { 992, 0, -120},
    { 1512, -272, 192},
    { 1664, 48, 216},
    { 1048, 432, -120},
    { 1040, 264, -224},
    { 1176, 176, 120},
    { 1224, 216, 280},
    { 1136, 368, 232},
    { 984, 488, 208},
    { 808, 448, 136},
    // 101 seconds
    { 736, 344, 48},
    { 840, 296, 40},
    { 952, 328, 8},
    { 1208, 336, -40},
    { 1304, 328, 40},
    { 1896, 392, 168},
    { 1480, 488, 120},
    { 896, 264, 88},
    { 1144, 248, 128},
    { 1448, 152, 264},
    { 1264, 0, 352},
    { 1072, 24, 256},
    { 984, 0, 208},
    { 896, -24, 224},
    { 808, 0, 176},
    { 744, -8, 112},
    { 736, -16, 40},
    { 864, 0, -96},
    { 1016, 32, -184},
    { 1528, -288, 192},
    { 1640, -88, 304},
    { 1192, 400, -96},
    { 1200, 360, -248},
    { 1248, 232, 312},
    { 1272, 136, 432},
    // 102 seconds
    { 1120, 304, 280},
    { 1000, 352, 264},
    { 904, 432, 208},
    { 808, 392, 112},
    { 856, 400, 48},
    { 976, 488, 16},
    { 1216, 536, -72},
    { 1360, 528, 72},
    { 1936, 608, 152},
    { 1376, 440, 128},
    { 1136, 288, 88},
    { 1464, 200, 200},
    { 1568, 8, 344},
    { 1392, 24, 264},
    { 1208, -40, 272},
    { 1040, -40, 256},
    { 896, -24, 200},
    { 808, -32, 184},
    { 752, -32, 128},
    { 736, -88, 56},
    { 840, -48, -80},
    { 1008, -64, -184},
    { 1376, -336, 200},
    { 1512, 64, 120},
    { 1480, 576, -296},
    // 103 seconds
    { 1512, 592, -80},
    { 1200, 360, 240},
    { 1104, 240, 312},
    { 1024, 184, 336},
    { 984, 240, 184},
    { 912, 168, 256},
    { 856, 384, 72},
    { 896, 376, 80},
    { 1048, 576, 128},
    { 1264, 536, 56},
    { 1552, 640, -8},
    { 1856, 720, 144},
    { 1296, 456, 64},
    { 1176, 368, -56},
    { 1280, 264, -48},
    { 1440, 32, 128},
    { 1344, 16, 296},
    { 1168, 40, 232},
    { 1008, -16, 216},
    { 864, -56, 224},
    { 768, -40, 176},
    { 712, -16, 104},
    { 736, -48, 32},
    { 856, 0, -80},
    { 1032, -24, -184},
    // 104 seconds
    { 1472, -272, 80},
    { 1496, -32, 72},
    { 1296, 296, -200},
    { 1384, 400, -304},
    { 1272, 224, 120},
    { 1256, 136, 304},
    { 1216, 312, 296},
    { 1032, 360, 296},
    { 904, 400, 152},
    { 864, 336, 104},
    { 936, 424, 64},
    { 1048, 400, 48},
    { 1192, 592, -120},
    { 1608, 592, -88},
    { 1856, 528, 72},
    { 1112, 304, 64},
    { 1176, 240, 40},
    { 1536, 128, 168},
    { 1576, 40, 328},
    { 1424, 48, 280},
    { 1232, 24, 208},
    { 1040, 0, 208},
    { 912, 0, 168},
    { 832, -32, 144},
    { 736, -64, 88},
    // 105 seconds
    { 704, -160, 0},
    { 832, -24, -208},
    { 1080, -176, -104},
    { 1440, -232, 160},
    { 1520, 232, 72},
    { 1376, 424, -192},
    { 1520, 336, 0},
    { 1576, 328, 368},
    { 1376, 496, 368},
    { 1136, 512, 344},
    { 888, 360, 176},
    { 816, 248, 160},
    { 824, 312, 120},
    { 896, 336, 56},
    { 1016, 440, 8},
    { 1216, 616, -64},
    { 1696, 656, 24},
    { 1744, 600, 80},
    { 1104, 344, -8},
    { 1208, 216, 40},
    { 1520, 112, 176},
    { 1480, 8, 312},
    { 1224, 40, 240},
    { 1096, 0, 208},
    { 1000, -16, 224},
    // 106 seconds
    { 872, -40, 224},
    { 784, -32, 168},
    { 752, -48, 112},
    { 768, -24, -40},
    { 960, 88, -176},
    { 1432, -256, 104},
    { 1456, -104, 104},
    { 1176, 216, -272},
    { 1184, 224, -224},
    { 1440, 440, 8},
    { 1288, 376, 344},
    { 1200, 536, 280},
    { 1048, 520, 208},
    { 888, 512, 136},
    { 776, 424, 136},
    { 800, 384, 152},
    { 904, 376, 184},
    { 1128, 424, 152},
    { 1408, 616, 248},
    { 1888, 760, 288},
    { 1376, 440, 104},
    { 1024, 280, 96},
    { 1352, 224, 192},
    { 1576, 88, 280},
    { 1376, 80, 240},
    // 107 seconds
    { 1136, -8, 272},
    { 952, -24, 200},
    { 872, -16, 160},
    { 792, -32, 160},
    { 752, -8, 88},
    { 720, -64, 48},
    { 880, -56, -136},
    { 1016, -384, -80},
    { 1520, -272, 152},
    { 1632, 112, 224},
    { 1408, 608, -104},
    { 1464, 448, -64},
    { 1424, 320, 400},
    { 1256, 392, 408},
    { 976, 136, 216},
    { 944, 192, 136},
    { 888, 264, 216},
    { 856, 408, 40},
    { 896, 480, -16},
    { 1144, 536, -24},
    { 1336, 680, -24},
    { 1512, 416, 72},
    { 1856, 376, 184},
    { 1200, 384, 128},
    { 1184, 296, 64},
    // 108 seconds
    { 1472, 128, 224},
    { 1504, 24, 352},
    { 1296, -24, 320},
    { 1152, -48, 280},
    { 1016, -16, 232},
    { 896, -48, 216},
    { 792, -56, 168},
    { 672, -24, 56},
    { 760, -32, -72},
    { 920, 104, -272},
    { 1280, -208, -40},
    { 1512, -408, 360},
    { 1384, 336, -88},
    { 1248, 272, -248},
    { 1392, 88, 16},
    { 1520, 216, 296},
    { 1456, 360, 328},
    { 1336, 480, 384},
    { 1040, 528, 416},
    { 808, 416, 256},
    { 872, 472, 192},
    { 896, 568, 136},
    { 1032, 648, 72},
    { 1152, 592, 144},
    { 1736, 648, 200},
    // 109 seconds
    { 1696, 648, 344},
    { 960, 296, 184},
    { 1264, 216, 80},
    { 1736, 184, 192},
    { 1704, 48, 344},
    { 1432, -8, 296},
    { 1224, -40, 224},
    { 1008, -32, 216},
    { 856, -8, 168},
    { 736, -24, 88},
    { 648, -112, 0},
    { 664, -128, -80},
    { 800, -32, -208},
    { 1144, -120, -24},
    { 1432, -88, 200},
    { 1456, 408, 104},
    { 1592, 512, 48},
    { 1624, 456, 168},
    { 1456, 392, 376},
    { 1288, 448, 376},
    { 1080, 416, 392},
    { 936, 312, 256},
    { 880, 360, 144},
    { 840, 472, 72},
    { 880, 512, 48},
    // 110 seconds
    { 1080, 592, 16},
    { 1208, 608, 128},
    { 1624, 576, 152},
    { 1632, 504, 160},
    { 1128, 280, 144},
    { 1384, 240, 112},
    { 1704, 120, 216},
    { 1480, -8, 352},
    { 1248, 32, 232},
    { 1120, 32, 168},
    { 968, 16, 200},
    { 848, 0, 152},
    { 744, -24, 104},
    { 640, -64, 32},
    { 608, -96, -16},
    { 800, 64, -208},
    { 1264, -48, -56},
    { 1616, -16, 152},
    { 1328, 360, 64},
    { 1264, 432, -56},
    { 1440, 488, -8},
    { 1328, 312, 264},
    { 1248, 456, 248},
    { 1208, 384, 304},
    { 992, 552, 200},
    // 111 seconds
    { 760, 384, 152},
    { 768, 376, 72},
    { 848, 352, 64},
    { 1104, 520, -16},
    { 1152, 584, 8},
    { 1688, 552, 72},
    { 1816, 600, 168},
    { 1160, 240, 120},
    { 1160, 136, 56},
    { 1440, 144, 112},
    { 1520, 80, 224},
    { 1344, 24, 256},
    { 1152, -24, 248},
    { 1016, -24, 224},
    { 904, -16, 208},
    { 832, -16, 144},
    { 784, 32, -16},
    { 888, 8, -240},
    { 808, -112, -168},
    { 944, -328, 8},
    { 1480, -240, 272},
    { 1576, 480, 208},
    { 1304, 616, -112},
    { 1368, 168, 8},
    { 1520, 152, 336},
    // 112 seconds
    { 1416, 312, 432},
    { 1248, 488, 344},
    { 976, 488, 192},
    { 800, 336, 104},
    { 840, 368, 80},
    { 856, 488, 0},
    { 976, 464, 16},
    { 1192, 520, 32},
    { 1448, 392, 136},
    { 1904, 360, 176},
    { 1392, 320, 168},
    { 1120, 176, 80},
    { 1440, 136, 128},
    { 1672, 48, 256},
    { 1432, 40, 256},
    { 1200, 0, 232},
    { 960, -48, 232},
    { 792, -32, 160},
    { 728, -24, 104},
    { 656, -32, 56},
    { 632, -112, 16},
    { 808, 8, -160},
    { 1096, -72, -104},
    { 1648, -224, 224},
    { 1696, 352, 160},
    // 113 seconds
    { 1240, 616, -136},
    { 1272, 608, -80},
    { 1248, 592, 264},
    { 1080, 448, 504},
    { 992, 736, 312},
    { 832, 872, 328},
    { 728, 840, 328},
    { 672, 816, 272},
    { 640, 880, 248},
    { 704, 888, 264},
    { 904, 1040, 272},
    { 952, 976, 328},
    { 1248, 1016, 520},
    { 1424, 1280, 472},
    { 1264, 944, 544},
    { 1080, 560, 424},
    { 848, 336, 176},
    { 712, 280, -16},
    { 544, 288, 40},
    { 456, 520, -96},
    { 312, 680, -144},
    { 264, 528, -56},
    { 272, 1016, -424},
    { 136, 1144, -336},
    { 8, 1056, -496},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

