/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:18:00 local
AccelRawData *activity_sample_walk_200_pbl_25299_7(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25299_7
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 0, -40, -1024},
    { 32, -8, -1016},
    { 24, -40, -1032},
    { 32, -8, -1064},
    { 0, -32, -1040},
    { 16, -32, -1032},
    { 0, 16, -1024},
    { 0, 0, -1056},
    { 16, -24, -1040},
    { 16, -8, -1024},
    { 24, -16, -1032},
    { 32, -24, -1024},
    { 48, -32, -1024},
    { 56, -8, -1024},
    { 40, -32, -1024},
    { 88, -56, -1040},
    { 16, 32, -1064},
    { 96, -24, -1056},
    { 40, -40, -992},
    { 120, -96, -904},
    { 128, -32, -792},
    { 160, 40, -696},
    { 168, 368, -584},
    { 112, 616, -496},
    { 120, 624, -336},
    // 1 seconds
    { 120, 816, -208},
    { 168, 968, 8},
    { 104, 928, 368},
    { 152, 1240, 680},
    { 120, 1360, 760},
    { -32, 1368, 696},
    { -152, 960, 752},
    { -136, 824, 752},
    { -120, 752, 680},
    { -72, 704, 768},
    { 32, 816, 816},
    { -48, 616, 784},
    { 8, 648, 712},
    { -16, 600, 736},
    { -8, 608, 704},
    { -16, 672, 848},
    { 56, 728, 912},
    { 112, 624, 808},
    { 64, 576, 840},
    { 88, 552, 496},
    { 64, 552, 432},
    { 80, 448, 672},
    { 112, 544, 576},
    { 48, 648, 488},
    { 0, 640, 576},
    // 2 seconds
    { 32, 664, 512},
    { 56, 752, 408},
    { 32, 920, 344},
    { 16, 928, 360},
    { 56, 992, 264},
    { -112, 928, 480},
    { 0, 1168, 512},
    { 80, 1272, 592},
    { 168, 1120, 576},
    { 272, 1008, 200},
    { 32, 600, 56},
    { -64, 544, 256},
    { 152, 928, 432},
    { 56, 616, 344},
    { 32, 568, 392},
    { 40, 760, 400},
    { -96, 680, 368},
    { -104, 640, 304},
    { -48, 840, 232},
    { 128, 1056, 320},
    { 320, 1312, 280},
    { 248, 984, 240},
    { 616, 840, 320},
    { 648, 544, 392},
    { 576, 600, 312},
    // 3 seconds
    { 640, 528, 176},
    { 648, 496, 176},
    { 552, 304, 248},
    { 608, 160, 328},
    { 904, 296, 272},
    { 1128, 520, 200},
    { 1024, 688, 248},
    { 1024, 736, 112},
    { 1080, 512, 280},
    { 1224, 520, 336},
    { 1664, 440, 584},
    { 1400, 560, 368},
    { 736, 672, 120},
    { 832, 504, -32},
    { 992, 400, 48},
    { 944, 376, 160},
    { 864, 232, 128},
    { 824, 152, 104},
    { 816, 72, 168},
    { 800, 104, 216},
    { 856, 120, 144},
    { 920, 16, 160},
    { 1216, 128, 152},
    { 1456, 16, 208},
    { 1536, 96, 288},
    // 4 seconds
    { 1024, 488, -88},
    { 768, 424, -192},
    { 840, 344, 72},
    { 728, 504, 72},
    { 584, 464, 16},
    { 680, 600, 176},
    { 608, 680, 144},
    { 480, 656, 128},
    { 464, 712, 72},
    { 504, 848, 104},
    { 768, 952, 160},
    { 936, 976, 232},
    { 1176, 888, 464},
    { 1096, 832, 480},
    { 728, 592, 384},
    { 672, 320, 304},
    { 616, 432, 320},
    { 512, 440, 168},
    { 408, 496, 56},
    { 328, 600, 80},
    { 248, 616, 192},
    { 256, 648, 304},
    { 240, 800, 304},
    { 440, 1008, 288},
    { 632, 1016, 344},
    // 5 seconds
    { 944, 1032, 608},
    { 1056, 912, 432},
    { 784, 656, 144},
    { 704, 400, 72},
    { 784, 344, 136},
    { 600, 400, 208},
    { 544, 448, 104},
    { 568, 480, 112},
    { 456, 416, 96},
    { 408, 360, 40},
    { 520, 504, 176},
    { 712, 624, 144},
    { 976, 584, 208},
    { 1184, 568, 296},
    { 1608, 584, 464},
    { 1296, 848, 368},
    { 744, 792, 168},
    { 808, 504, 168},
    { 952, 448, 248},
    { 832, 360, 200},
    { 704, 280, 80},
    { 672, 112, 104},
    { 744, 120, 88},
    { 824, 144, 24},
    { 928, 264, 120},
    // 6 seconds
    { 1208, 80, -56},
    { 1256, 40, -8},
    { 1816, 80, 192},
    { 1264, 288, 40},
    { 736, 408, -160},
    { 760, 176, -88},
    { 704, 280, 72},
    { 576, 112, 176},
    { 656, 248, 56},
    { 680, 192, 104},
    { 712, 368, 56},
    { 648, 376, 0},
    { 856, 512, -8},
    { 1080, 448, -8},
    { 1304, 352, 16},
    { 1736, 480, 32},
    { 1504, 592, 88},
    { 744, 440, -40},
    { 912, 336, 8},
    { 1040, 232, 152},
    { 928, 240, 136},
    { 784, 200, 48},
    { 728, 192, 24},
    { 704, 128, 24},
    { 736, 64, 56},
    // 7 seconds
    { 744, 32, 56},
    { 936, 0, -48},
    { 1184, 80, -8},
    { 1592, -16, 24},
    { 1784, 48, 224},
    { 1120, 504, -48},
    { 864, 392, -208},
    { 776, 376, 48},
    { 712, 248, 96},
    { 744, 104, 224},
    { 816, 312, 72},
    { 760, 296, 56},
    { 712, 448, -104},
    { 768, 464, -168},
    { 976, 240, -152},
    { 1112, 256, -120},
    { 1296, 248, 72},
    { 1808, 544, 48},
    { 1064, 560, 40},
    { 1000, 384, 152},
    { 1088, 264, 264},
    { 1040, 152, 256},
    { 816, 88, 200},
    { 752, 152, 80},
    { 760, 120, 96},
    // 8 seconds
    { 736, 88, 72},
    { 696, 56, 64},
    { 728, 48, 56},
    { 992, 64, 48},
    { 1176, 96, -24},
    { 1824, -8, 328},
    { 1512, 360, 48},
    { 904, 648, -232},
    { 904, 240, 24},
    { 840, 184, 200},
    { 632, 256, 144},
    { 744, 152, 168},
    { 688, 192, 200},
    { 712, 424, -16},
    { 728, 288, 64},
    { 928, 496, -96},
    { 1072, 424, -24},
    { 1320, 456, -48},
    { 1736, 264, 192},
    { 1776, 536, 64},
    { 736, 512, 0},
    { 1144, 192, -472},
    { 976, 120, -80},
    { 928, 256, 184},
    { 736, 128, 128},
    // 9 seconds
    { 688, 120, 128},
    { 624, 72, 120},
    { 632, 80, 32},
    { 680, 64, 72},
    { 840, 56, 64},
    { 1120, 112, 8},
    { 1432, 24, 176},
    { 1904, 128, 248},
    { 1304, 536, -88},
    { 848, 520, -136},
    { 856, 240, 40},
    { 752, 96, 56},
    { 688, 120, 72},
    { 760, 264, 8},
    { 800, 280, 56},
    { 768, 368, -104},
    { 768, 224, 16},
    { 944, 360, -56},
    { 1216, 320, 0},
    { 1296, 312, 120},
    { 1752, 336, 120},
    { 1464, 416, 96},
    { 800, 344, 48},
    { 848, 232, 16},
    { 1008, 104, 160},
    // 10 seconds
    { 872, 112, 216},
    { 752, 128, 152},
    { 752, 128, 104},
    { 720, 96, 128},
    { 744, 112, 56},
    { 752, 48, 112},
    { 952, 56, 56},
    { 1248, 216, -104},
    { 1504, 80, 16},
    { 1632, -24, 256},
    { 1072, 344, -16},
    { 864, 320, -88},
    { 760, 296, 0},
    { 656, 184, 152},
    { 656, 144, 152},
    { 760, 272, 56},
    { 736, 336, -8},
    { 808, 328, 0},
    { 976, 400, -104},
    { 1048, 352, -96},
    { 1216, 432, -120},
    { 1536, 288, 88},
    { 1768, 384, 120},
    { 1128, 432, 80},
    { 752, 264, 40},
    // 11 seconds
    { 992, 168, 144},
    { 896, 112, 248},
    { 744, 176, 88},
    { 736, 80, 128},
    { 712, 136, 48},
    { 736, 96, 56},
    { 752, 56, 64},
    { 864, 32, 32},
    { 1096, 96, 0},
    { 1128, 48, -16},
    { 1616, 24, 160},
    { 1232, 192, 160},
    { 1192, 480, -80},
    { 1024, 504, -88},
    { 648, 312, 88},
    { 648, 152, 104},
    { 768, 248, 56},
    { 832, 336, 48},
    { 752, 408, -24},
    { 776, 376, -32},
    { 896, 480, -120},
    { 1216, 432, -224},
    { 1192, 296, 112},
    { 1848, 264, 32},
    { 1256, 432, -8},
    // 12 seconds
    { 864, 392, -112},
    { 976, 256, 8},
    { 1072, 104, 144},
    { 848, 152, 96},
    { 712, 152, 40},
    { 688, 136, 32},
    { 680, 120, -24},
    { 712, 56, 40},
    { 808, 48, 8},
    { 1096, 56, -8},
    { 1184, 128, -48},
    { 1600, 8, 48},
    { 1416, 144, 96},
    { 992, 392, -136},
    { 944, 392, -152},
    { 776, 312, -40},
    { 664, 128, 56},
    { 696, 192, 24},
    { 776, 280, 24},
    { 800, 408, -48},
    { 760, 376, -40},
    { 856, 416, -104},
    { 1104, 320, -64},
    { 1272, 368, -112},
    { 1520, 280, 80},
    // 13 seconds
    { 1664, 400, 48},
    { 976, 352, 48},
    { 976, 320, 0},
    { 1040, 144, 168},
    { 952, 112, 184},
    { 824, 144, 120},
    { 752, 120, 96},
    { 696, 64, 104},
    { 712, 80, 40},
    { 720, 48, 72},
    { 896, 72, 24},
    { 1192, 120, -24},
    { 1160, 136, -48},
    { 1592, 16, 160},
    { 1248, 288, 8},
    { 1152, 328, -152},
    { 1056, 424, -152},
    { 600, 248, 32},
    { 560, 216, 24},
    { 728, 224, 32},
    { 816, 304, 16},
    { 744, 304, 32},
    { 776, 416, -80},
    { 920, 368, -56},
    { 1248, 400, -120},
    // 14 seconds
    { 1280, 256, 8},
    { 1840, 312, 24},
    { 1328, 424, -8},
    { 816, 352, 0},
    { 920, 248, 32},
    { 1096, 152, 192},
    { 904, 128, 160},
    { 776, 136, 96},
    { 736, 104, 88},
    { 696, 96, 48},
    { 720, 72, 72},
    { 800, 96, 8},
    { 992, 32, 8},
    { 1136, 80, -24},
    { 1384, -48, 32},
    { 1616, 96, 136},
    { 1120, 424, -40},
    { 1064, 392, -120},
    { 816, 384, 8},
    { 560, 136, 48},
    { 712, 192, 48},
    { 824, 216, 48},
    { 824, 320, 0},
    { 768, 336, -40},
    { 840, 352, -104},
    // 15 seconds
    { 1000, 344, -72},
    { 1256, 336, -80},
    { 1272, 192, 96},
    { 1816, 352, 120},
    { 1056, 472, 112},
    { 920, 360, 40},
    { 1088, 184, 168},
    { 1056, 136, 176},
    { 840, 160, 32},
    { 792, 32, 112},
    { 776, 120, 32},
    { 808, 64, 24},
    { 768, 16, 40},
    { 864, 32, 16},
    { 1016, 40, -40},
    { 1120, 48, -88},
    { 1752, -112, 184},
    { 1440, 312, 48},
    { 912, 480, -288},
    { 960, 328, -56},
    { 792, 288, 112},
    { 688, 184, 120},
    { 776, 240, 112},
    { 808, 376, 8},
    { 728, 360, 40},
    // 16 seconds
    { 760, 424, -72},
    { 888, 416, -120},
    { 1224, 416, -152},
    { 1256, 328, -120},
    { 1872, 368, -48},
    { 1360, 464, -8},
    { 880, 328, 16},
    { 1016, 280, 48},
    { 1120, 152, 184},
    { 904, 160, 152},
    { 776, 120, 112},
    { 720, 144, 40},
    { 752, 64, 56},
    { 752, 64, 24},
    { 784, 80, 16},
    { 896, -8, 16},
    { 1144, 96, -64},
    { 1480, -64, -32},
    { 1648, 72, 80},
    { 1048, 432, -104},
    { 1064, 408, -216},
    { 888, 344, 8},
    { 672, 160, 96},
    { 752, 240, 64},
    { 824, 248, 104},
    // 17 seconds
    { 792, 440, 0},
    { 720, 376, 8},
    { 808, 440, -88},
    { 1032, 528, -168},
    { 1152, 328, -64},
    { 1328, 296, 24},
    { 1664, 376, 16},
    { 1152, 480, -40},
    { 776, 352, -8},
    { 1000, 264, 56},
    { 1048, 152, 184},
    { 880, 176, 144},
    { 792, 192, 104},
    { 744, 128, 96},
    { 760, 80, 72},
    { 832, 96, 40},
    { 840, 40, 32},
    { 1024, 8, -8},
    { 1144, 72, -24},
    { 1528, -40, 0},
    { 1480, 48, 112},
    { 1008, 344, -136},
    { 1000, 376, -248},
    { 848, 264, -24},
    { 680, 208, 40},
    // 18 seconds
    { 712, 248, 32},
    { 792, 272, 64},
    { 792, 392, 8},
    { 744, 344, -16},
    { 864, 424, -104},
    { 1008, 392, -112},
    { 1232, 360, -128},
    { 1456, 256, -8},
    { 1648, 376, -8},
    { 1096, 424, -64},
    { 944, 352, -40},
    { 1000, 240, 32},
    { 928, 168, 104},
    { 832, 152, 88},
    { 776, 160, 40},
    { 688, 104, 32},
    { 672, 72, 48},
    { 728, 104, -8},
    { 832, 64, 0},
    { 1128, 112, -40},
    { 1200, 80, -32},
    { 1752, 104, 72},
    { 1240, 248, -32},
    { 832, 264, -184},
    { 1000, 336, -152},
    // 19 seconds
    { 728, 232, -56},
    { 616, 168, 8},
    { 712, 304, -40},
    { 792, 376, -32},
    { 776, 400, -40},
    { 792, 440, -104},
    { 888, 432, -160},
    { 1104, 384, -104},
    { 1256, 368, -48},
    { 1560, 408, 16},
    { 1592, 472, 80},
    { 928, 400, 32},
    { 888, 352, 0},
    { 1040, 184, 152},
    { 944, 128, 128},
    { 864, 136, 64},
    { 784, 104, 48},
    { 752, 80, 0},
    { 760, 40, -8},
    { 728, 56, -32},
    { 824, 0, -32},
    { 1176, 88, -64},
    { 1224, 24, -24},
    { 1824, 8, 168},
    { 1224, 328, 48},
    // 20 seconds
    { 1096, 408, -120},
    { 920, 488, -16},
    { 680, 288, 48},
    { 704, 216, 72},
    { 776, 320, -40},
    { 784, 336, 16},
    { 776, 456, -104},
    { 784, 416, -96},
    { 984, 496, -168},
    { 1184, 360, -88},
    { 1192, 280, -24},
    { 1744, 344, 56},
    { 1192, 408, 32},
    { 920, 296, 40},
    { 1096, 248, 112},
    { 1080, 120, 208},
    { 848, 144, 136},
    { 744, 160, 88},
    { 736, 136, 48},
    { 776, 80, 32},
    { 848, 72, 0},
    { 872, 64, -8},
    { 1008, 32, -16},
    { 1144, 64, -88},
    { 1496, -112, 48},
    // 21 seconds
    { 1400, 24, 144},
    { 1040, 328, -32},
    { 1016, 296, -200},
    { 888, 312, 16},
    { 680, 224, 24},
    { 744, 248, 24},
    { 896, 296, 80},
    { 816, 392, 8},
    { 768, 384, -40},
    { 880, 456, -136},
    { 1128, 424, -176},
    { 1272, 424, -128},
    { 1664, 360, -72},
    { 1624, 424, -16},
    { 920, 384, -56},
    { 872, 296, -8},
    { 1144, 168, 160},
    { 1032, 112, 184},
    { 864, 112, 152},
    { 760, 112, 96},
    { 728, 64, 88},
    { 728, 56, 40},
    { 760, 72, -48},
    { 936, 8, -32},
    { 1168, 40, -72},
    // 22 seconds
    { 1136, 40, -104},
    { 1616, -8, 24},
    { 1184, 304, -112},
    { 1064, 176, -136},
    { 1160, 376, -152},
    { 800, 336, 56},
    { 680, 304, 24},
    { 760, 296, 40},
    { 808, 304, 72},
    { 768, 368, 32},
    { 832, 464, 40},
    { 976, 576, -8},
    { 1080, 424, -96},
    { 1184, 368, 16},
    { 1864, 384, 8},
    { 1336, 432, 16},
    { 864, 296, 40},
    { 1136, 232, 88},
    { 1088, 64, 160},
    { 904, 72, 104},
    { 816, 72, 104},
    { 776, 48, 64},
    { 784, 24, 48},
    { 808, 32, -24},
    { 896, -24, 0},
    // 23 seconds
    { 1048, -64, -32},
    { 1104, -32, -80},
    { 1528, -176, 16},
    { 1408, 80, 48},
    { 1096, 296, -144},
    { 1144, 360, -160},
    { 864, 304, 56},
    { 728, 240, 64},
    { 816, 248, 104},
    { 856, 344, 56},
    { 800, 320, 40},
    { 768, 368, -56},
    { 904, 424, -144},
    { 1096, 416, -128},
    { 1224, 376, -104},
    { 1800, 368, -40},
    { 1504, 464, 56},
    { 832, 384, 0},
    { 984, 296, 32},
    { 1168, 144, 136},
    { 1040, 120, 104},
    { 888, 128, 80},
    { 784, 48, 112},
    { 752, 104, 8},
    { 752, 32, 40},
    // 24 seconds
    { 784, -8, 24},
    { 904, -32, 0},
    { 1024, 32, -72},
    { 1224, -104, -40},
    { 1640, -72, 128},
    { 1248, 296, -48},
    { 1160, 424, -224},
    { 944, 376, -56},
    { 672, 192, 56},
    { 776, 248, 72},
    { 856, 240, 112},
    { 848, 328, 80},
    { 808, 384, -40},
    { 800, 408, -80},
    { 952, 464, -160},
    { 1232, 424, -168},
    { 1248, 288, -24},
    { 1824, 432, 0},
    { 1200, 456, 24},
    { 872, 336, 8},
    { 1112, 224, 96},
    { 1128, 144, 184},
    { 928, 104, 176},
    { 800, 144, 56},
    { 800, 80, 80},
    // 25 seconds
    { 760, 56, 56},
    { 792, 56, 32},
    { 872, 0, 32},
    { 968, 0, -56},
    { 1040, 0, -96},
    { 1536, -120, -16},
    { 1424, 96, 112},
    { 1128, 368, -120},
    { 1168, 440, -208},
    { 856, 288, 48},
    { 664, 160, 80},
    { 776, 280, 48},
    { 864, 328, 56},
    { 832, 368, 48},
    { 784, 376, -48},
    { 904, 432, -120},
    { 1120, 456, -168},
    { 1272, 376, -104},
    { 1752, 384, -24},
    { 1512, 416, 56},
    { 872, 344, 32},
    { 888, 304, 24},
    { 1096, 200, 136},
    { 1000, 120, 200},
    { 784, 112, 144},
    // 26 seconds
    { 776, 112, 112},
    { 792, 48, 112},
    { 784, 48, 88},
    { 792, 56, 24},
    { 896, -8, 40},
    { 1088, 64, -72},
    { 1272, -40, -40},
    { 1664, -24, 72},
    { 1176, 240, 0},
    { 944, 272, -200},
    { 992, 312, -80},
    { 800, 248, 88},
    { 720, 224, 64},
    { 792, 216, 176},
    { 840, 344, 56},
    { 776, 336, 72},
    { 816, 448, -88},
    { 920, 432, -120},
    { 1240, 448, -168},
    { 1352, 360, -112},
    { 1832, 416, -16},
    { 1312, 480, -24},
    { 744, 352, -16},
    { 1008, 288, -48},
    { 1144, 112, 192},
    // 27 seconds
    { 904, 64, 200},
    { 816, 136, 104},
    { 792, 120, 112},
    { 704, 64, 72},
    { 736, 64, 40},
    { 840, 16, 48},
    { 1056, 16, -8},
    { 1088, 24, -72},
    { 1416, -128, 16},
    { 1504, -48, 200},
    { 1064, 400, -56},
    { 1208, 464, -208},
    { 904, 440, 24},
    { 592, 192, 72},
    { 792, 216, 112},
    { 840, 240, 104},
    { 808, 368, 64},
    { 768, 416, -40},
    { 808, 384, -48},
    { 1008, 440, -128},
    { 1312, 328, 0},
    { 1288, 336, 48},
    { 1792, 424, 88},
    { 1080, 480, 0},
    { 944, 328, 16},
    // 28 seconds
    { 1112, 168, 152},
    { 1064, 168, 184},
    { 952, 192, 144},
    { 840, 136, 112},
    { 800, 40, 104},
    { 784, 24, 104},
    { 824, 16, 56},
    { 888, -24, 56},
    { 984, -8, -24},
    { 984, 72, -112},
    { 1568, -88, 72},
    { 1344, 80, 96},
    { 1184, 392, -96},
    { 1232, 408, -104},
    { 880, 416, 104},
    { 680, 272, 104},
    { 824, 296, 144},
    { 856, 296, 184},
    { 800, 352, 128},
    { 808, 400, 104},
    { 920, 496, 0},
    { 992, 520, -48},
    { 1192, 568, -80},
    { 1576, 488, 48},
    { 1440, 472, 168},
    // 29 seconds
    { 920, 432, 104},
    { 1048, 328, 128},
    { 1200, 112, 256},
    { 1096, 80, 240},
    { 872, 64, 232},
    { 752, 120, 144},
    { 768, 112, 104},
    { 768, 48, 120},
    { 800, 24, 96},
    { 864, -72, 32},
    { 1024, -56, 24},
    { 1192, -160, 64},
    { 1584, -32, 120},
    { 1224, 320, -40},
    { 1184, 464, -200},
    { 1144, 400, 0},
    { 840, 272, 112},
    { 824, 312, 104},
    { 840, 368, 80},
    { 896, 480, 40},
    { 736, 376, 16},
    { 776, 456, -128},
    { 872, 416, -72},
    { 1232, 384, -64},
    { 1248, 344, 16},
    // 30 seconds
    { 1752, 368, 64},
    { 1320, 400, 48},
    { 872, 352, 24},
    { 1024, 232, 104},
    { 1152, 136, 192},
    { 928, 104, 208},
    { 816, 144, 128},
    { 800, 120, 96},
    { 752, 80, 72},
    { 760, 48, 16},
    { 880, -24, 80},
    { 1016, -40, 8},
    { 1040, 40, -56},
    { 1472, -80, 104},
    { 1432, -8, 208},
    { 1224, 392, -8},
    { 1176, 472, -104},
    { 840, 464, 24},
    { 608, 184, 112},
    { 784, 240, 24},
    { 808, 168, 96},
    { 840, 272, 72},
    { 784, 400, -16},
    { 872, 504, -96},
    { 992, 496, -96},
    // 31 seconds
    { 1208, 376, -24},
    { 1272, 256, 136},
    { 1776, 464, 88},
    { 1216, 504, 0},
    { 984, 288, 56},
    { 1160, 216, 120},
    { 1128, 144, 160},
    { 896, 88, 168},
    { 736, 72, 136},
    { 680, 48, 120},
    { 696, 8, 128},
    { 680, 8, 104},
    { 768, -32, 128},
    { 1024, 24, 40},
    { 1184, 64, 56},
    { 1816, -16, 152},
    { 1520, 200, 72},
    { 960, 616, -328},
    { 912, 352, -176},
    { 912, 48, 136},
    { 872, 184, 32},
    { 656, 128, 96},
    { 776, 280, 112},
    { 832, 416, 0},
    { 768, 264, 120},
    // 32 seconds
    { 920, 368, -32},
    { 1104, 376, -16},
    { 1272, 400, -72},
    { 1632, 208, 64},
    { 1584, 344, -24},
    { 1008, 336, -8},
    { 992, 224, -8},
    { 896, 200, -392},
    { 512, -432, 592},
    { 792, 128, 120},
    { 728, 288, 88},
    { 808, 168, 104},
    { 824, 40, 144},
    { 856, 24, 96},
    { 952, -88, 160},
    { 1168, 32, 48},
    { 1304, 8, 88},
    { 1608, 88, 8},
    { 1024, 152, -104},
    { 912, 192, -144},
    { 936, 112, -112},
    { 768, 128, 72},
    { 776, 432, 96},
    { 864, 384, 104},
    { 800, 352, 144},
    // 33 seconds
    { 744, 320, 120},
    { 792, 416, 8},
    { 888, 464, -64},
    { 912, 528, 0},
    { 1088, 416, -112},
    { 1776, 264, 72},
    { 1384, 416, -40},
    { 864, 264, -72},
    { 1072, 152, -40},
    { 1064, 112, 32},
    { 832, 152, 80},
    { 696, 112, 8},
    { 744, 72, 32},
    { 760, 32, 64},
    { 792, 16, -24},
    { 856, -16, 0},
    { 1080, 0, -64},
    { 1112, 32, -144},
    { 1560, 0, -168},
    { 1432, -40, -56},
    { 1088, 360, -224},
    { 1072, 296, -288},
    { 856, 328, -96},
    { 560, 160, -8},
    { 752, 136, 88},
    // 34 seconds
    { 832, 256, -24},
    { 792, 200, 8},
    { 792, 344, -128},
    { 888, 304, -128},
    { 1016, 304, -160},
    { 1192, 304, -152},
    { 1600, 208, -48},
    { 1744, 296, -32},
    { 1000, 376, -48},
    { 840, 304, -32},
    { 1136, 136, 56},
    { 976, 72, 104},
    { 816, 120, 64},
    { 760, 104, 16},
    { 736, 64, 8},
    { 760, 32, -8},
    { 776, 0, -16},
    { 976, -16, -16},
    { 1136, 64, -144},
    { 1272, -48, -88},
    { 1632, -64, 0},
    { 1072, 240, -144},
    { 1000, 264, -168},
    { 1008, 272, -88},
    { 664, 176, 40},
    // 35 seconds
    { 648, 208, 0},
    { 752, 184, 0},
    { 784, 216, -16},
    { 760, 264, -64},
    { 816, 320, -144},
    { 984, 360, -224},
    { 1144, 296, -200},
    { 1272, 232, -120},
    { 1872, 256, 16},
    { 1384, 424, -24},
    { 736, 352, -24},
    { 928, 288, 24},
    { 1080, 184, 80},
    { 864, 136, 128},
    { 768, 144, 64},
    { 768, 112, 32},
    { 776, 80, 8},
    { 864, 56, -32},
    { 928, -16, -16},
    { 1112, -8, -72},
    { 1112, -32, -72},
    { 1568, -56, -40},
    { 1320, 48, -16},
    { 872, 336, -192},
    { 984, 296, -184},
    // 36 seconds
    { 848, 192, 0},
    { 640, 192, -24},
    { 712, 216, -32},
    { 800, 256, -40},
    { 784, 248, -56},
    { 792, 264, -96},
    { 904, 352, -192},
    { 1056, 352, -192},
    { 1224, 272, -128},
    { 1480, 264, -8},
    { 1576, 296, 8},
    { 912, 376, -40},
    { 848, 304, 8},
    { 1024, 160, 72},
    { 984, 120, 88},
    { 808, 120, 88},
    { 752, 184, -8},
    { 752, 80, 16},
    { 808, 40, -32},
    { 840, 16, -40},
    { 944, -40, -32},
    { 1128, 8, -80},
    { 1352, -96, -32},
    { 1712, -32, 72},
    { 880, 304, -128},
    // 37 seconds
    { 936, 296, -160},
    { 1016, 272, -24},
    { 712, 128, 80},
    { 712, 208, 16},
    { 784, 264, -16},
    { 776, 280, -24},
    { 744, 280, -24},
    { 872, 360, -104},
    { 952, 368, -168},
    { 1184, 320, -144},
    { 1384, 224, -40},
    { 1816, 288, 0},
    { 1312, 448, -64},
    { 872, 376, -64},
    { 984, 232, 16},
    { 1032, 136, 80},
    { 824, 120, 72},
    { 704, 104, 48},
    { 680, 88, 32},
    { 728, 88, 24},
    { 840, 32, 56},
    { 904, 32, 48},
    { 1040, 0, 32},
    { 1136, 64, -56},
    { 1504, -32, -48},
    // 38 seconds
    { 1448, -24, 88},
    { 888, 408, -152},
    { 984, 288, -176},
    { 880, 168, 16},
    { 600, 120, 32},
    { 712, 232, -8},
    { 808, 248, 16},
    { 808, 312, 8},
    { 832, 368, -56},
    { 848, 392, -80},
    { 1056, 416, -88},
    { 1200, 304, -80},
    { 1360, 184, 120},
    { 1680, 160, 128},
    { 1184, 376, 40},
    { 920, 288, 40},
    { 1040, 136, 104},
    { 984, 32, 184},
    { 808, 48, 144},
    { 720, 88, 96},
    { 688, 32, 104},
    { 728, -32, 104},
    { 720, -72, 72},
    { 960, 48, 64},
    { 1152, -88, 8},
    // 39 seconds
    { 1176, -8, -32},
    { 1760, -120, 40},
    { 1304, 152, -72},
    { 952, 368, -192},
    { 1048, 264, -80},
    { 824, 200, 64},
    { 680, 168, 32},
    { 728, 152, 72},
    { 776, 200, 32},
    { 744, 176, 48},
    { 784, 224, -16},
    { 888, 264, -80},
    { 1064, 280, -96},
    { 1280, 216, -40},
    { 1664, 80, 40},
    { 1688, 280, -32},
    { 960, 352, -24},
    { 856, 272, 16},
    { 1008, 112, 144},
    { 960, 112, 152},
    { 768, 96, 136},
    { 680, 104, 96},
    { 672, 64, 80},
    { 744, 8, 88},
    { 864, 8, 56},
    // 40 seconds
    { 976, -40, 64},
    { 1224, 48, -8},
    { 1232, -16, -8},
    { 1656, -40, 48},
    { 1168, 176, 0},
    { 952, 352, -184},
    { 920, 232, -56},
    { 704, 176, 96},
    { 648, 96, 64},
    { 760, 136, 128},
    { 832, 280, 32},
    { 768, 296, 88},
    { 840, 352, 16},
    { 928, 432, -64},
    { 1192, 400, -104},
    { 1288, 312, -72},
    { 1768, 280, 8},
    { 1448, 336, 24},
    { 952, 304, 64},
    { 1016, 232, 112},
    { 1096, 128, 176},
    { 920, 40, 216},
    { 784, 40, 200},
    { 728, 72, 144},
    { 744, 40, 112},
    // 41 seconds
    { 720, 16, 104},
    { 864, 24, 88},
    { 936, -80, 80},
    { 1136, 24, -16},
    { 1320, -32, 40},
    { 1736, 96, 144},
    { 1040, 376, -216},
    { 928, 216, -232},
    { 960, -112, 80},
    { 776, 80, 168},
    { 712, 208, 72},
    { 776, 256, 120},
    { 840, 424, 24},
    { 760, 312, 160},
    { 848, 384, 8},
    { 944, 272, 72},
    { 1240, 496, -80},
    { 1280, 360, -24},
    { 1888, 408, 8},
    { 1512, 312, 0},
    { 864, 208, 24},
    { 1024, 184, 40},
    { 1112, 64, 144},
    { 872, 40, 184},
    { 784, 88, 136},
    // 42 seconds
    { 760, 40, 144},
    { 736, 8, 120},
    { 744, -32, 136},
    { 800, -24, 88},
    { 840, -32, 72},
    { 1072, 40, -40},
    { 1640, -64, 32},
    { 1576, 32, 64},
    { 1104, 320, -152},
    { 1128, 296, -144},
    { 920, 240, 80},
    { 632, 184, 72},
    { 704, 184, 72},
    { 736, 152, 136},
    { 776, 304, 48},
    { 768, 232, 104},
    { 888, 352, -48},
    { 1008, 320, -48},
    { 1288, 456, -168},
    { 1528, 272, 16},
    { 1848, 352, 48},
    { 1160, 440, 0},
    { 792, 304, 40},
    { 1064, 192, 32},
    { 1056, 104, 176},
    // 43 seconds
    { 856, 64, 192},
    { 848, 128, 120},
    { 808, 112, 128},
    { 768, 88, 112},
    { 728, -16, 176},
    { 744, -40, 144},
    { 1024, 32, 40},
    { 1024, 72, -24},
    { 1608, -96, 144},
    { 1424, 80, 128},
    { 1192, 440, -240},
    { 1160, 280, -112},
    { 920, 384, 88},
    { 720, 240, 56},
    { 760, 248, 48},
    { 824, 296, 104},
    { 816, 376, 48},
    { 792, 408, -8},
    { 904, 464, -48},
    { 1120, 360, 32},
    { 1144, 264, 64},
    { 1744, 328, 112},
    { 1504, 320, 192},
    { 1032, 304, 128},
    { 952, 160, 152},
    // 44 seconds
    { 1112, 112, 232},
    { 1016, 120, 224},
    { 832, 16, 216},
    { 752, 48, 152},
    { 768, 40, 96},
    { 784, 0, 128},
    { 824, 8, 48},
    { 864, -40, 48},
    { 1104, 8, 0},
    { 1288, -136, 64},
    { 1656, -144, 240},
    { 1184, 328, 0},
    { 1040, 384, -176},
    { 984, 184, 72},
    { 752, 144, 168},
    { 768, 160, 136},
    { 824, 200, 184},
    { 840, 312, 104},
    { 752, 264, 128},
    { 856, 328, 64},
    { 976, 408, 0},
    { 1224, 400, -72},
    { 1360, 200, 80},
    { 1904, 328, 96},
    { 1312, 432, 48},
    // 45 seconds
    { 864, 296, 32},
    { 1072, 184, 88},
    { 1112, 64, 232},
    { 896, 72, 256},
    { 832, 112, 120},
    { 784, 24, 192},
    { 792, 24, 152},
    { 792, -8, 152},
    { 816, -8, 128},
    { 1032, -40, 112},
    { 960, 64, -64},
    { 1536, 16, 24},
    { 1552, 8, 120},
    { 1208, 240, -112},
    { 1136, 208, -152},
    { 808, 208, 16},
    { 616, 64, 104},
    { 728, 136, 88},
    { 840, 176, 168},
    { 832, 224, 160},
    { 768, 256, 144},
    { 864, 288, 104},
    { 1072, 360, 96},
    { 1224, 528, 48},
    { 1528, 400, 208},
    // 46 seconds
    { 1880, 408, 264},
    { 992, 456, 168},
    { 856, 280, 64},
    { 1152, 168, 80},
    { 1080, -16, 184},
    { 872, 32, 160},
    { 816, 64, 72},
    { 784, 40, 96},
    { 736, -40, 104},
    { 792, 24, 112},
    { 848, 8, 72},
    { 1016, 8, 16},
    { 1120, 0, 16},
    { 1632, -136, 208},
    { 1424, 160, 88},
    { 1208, 408, -160},
    { 984, 248, -40},
    { 744, 184, 120},
    { 704, 136, 96},
    { 792, 152, 144},
    { 864, 288, 104},
    { 776, 320, 80},
    { 768, 352, 16},
    { 936, 384, -16},
    { 1240, 368, -48},
    // 47 seconds
    { 1264, 264, 8},
    { 1904, 248, 136},
    { 1472, 424, 104},
    { 824, 304, 80},
    { 1024, 248, 72},
    { 1112, 88, 216},
    { 896, 104, 184},
    { 848, 144, 80},
    { 824, 32, 144},
    { 744, 0, 136},
    { 720, 16, 56},
    { 800, 0, 80},
    { 880, -24, 48},
    { 1064, 64, -40},
    { 1304, 0, 8},
    { 1776, -72, 248},
    { 1312, 336, -8},
    { 1144, 464, -168},
    { 920, 264, -8},
    { 640, 48, 152},
    { 776, 104, 128},
    { 792, 208, 152},
    { 856, 368, 64},
    { 784, 376, 56},
    { 864, 392, 32},
    // 48 seconds
    { 976, 344, 40},
    { 1168, 376, -16},
    { 1240, 280, 88},
    { 1968, 328, 80},
    { 1336, 352, 96},
    { 944, 264, 72},
    { 1096, 160, 152},
    { 1072, 80, 216},
    { 904, 80, 168},
    { 776, 48, 160},
    { 744, 32, 144},
    { 712, 16, 104},
    { 776, 24, 56},
    { 800, 8, 96},
    { 928, -48, 64},
    { 1160, 24, 0},
    { 1520, -64, 48},
    { 1544, -32, 144},
    { 1232, 360, -104},
    { 1136, 456, -224},
    { 888, 352, 48},
    { 680, 232, 48},
    { 704, 192, 88},
    { 800, 240, 112},
    { 824, 296, 104},
    // 49 seconds
    { 752, 336, 72},
    { 856, 416, -16},
    { 976, 392, -16},
    { 1304, 368, -24},
    { 1368, 40, 248},
    { 1808, 336, 120},
    { 1192, 320, 112},
    { 912, 168, 80},
    { 1032, 136, 96},
    { 960, 80, 192},
    { 776, 56, 160},
    { 696, 72, 120},
    { 688, 56, 72},
    { 712, 16, 104},
    { 800, -40, 160},
    { 976, 0, 80},
    { 1112, -64, 64},
    { 1120, -24, 40},
    { 1648, -232, 176},
    { 1344, 80, 104},
    { 992, 392, -80},
    { 1088, 320, -48},
    { 824, 256, 96},
    { 624, 192, 48},
    { 712, 224, 24},
    // 50 seconds
    { 824, 168, 80},
    { 792, 184, 48},
    { 776, 240, 16},
    { 840, 288, -56},
    { 992, 272, -88},
    { 1160, 232, -32},
    { 1400, 80, 168},
    { 1928, 200, 216},
    { 1256, 456, 88},
    { 728, 320, 32},
    { 952, 232, 112},
    { 1000, 152, 120},
    { 752, -8, 176},
    { 712, 48, 96},
    { 744, 96, 96},
    { 768, 80, 96},
    { 832, 32, 96},
    { 952, 32, 72},
    { 1152, -16, 32},
    { 1144, 48, -8},
    { 1664, -208, 176},
    { 1296, 40, 120},
    { 912, 360, -144},
    { 968, 152, -64},
    { 800, 128, 136},
    // 51 seconds
    { 632, 152, 48},
    { 720, 176, 72},
    { 800, 184, 128},
    { 848, 296, 88},
    { 800, 352, 24},
    { 944, 376, -96},
    { 1136, 328, -144},
    { 1336, 264, -136},
    { 1768, 112, 96},
    { 1784, 304, 136},
    { 992, 392, 168},
    { 856, 176, 200},
    { 1120, 24, 296},
    { 920, 24, 296},
    { 760, 72, 136},
    { 688, 32, 152},
    { 720, 56, 56},
    { 720, -8, 64},
    { 752, -32, 112},
    { 888, -64, 88},
    { 1096, 8, -48},
    { 1176, 32, -48},
    { 1704, -136, 120},
    { 1440, 88, 112},
    { 1232, 400, -96},
    // 52 seconds
    { 1080, 432, -104},
    { 736, 264, 144},
    { 688, 72, 120},
    { 768, 184, 120},
    { 824, 304, 72},
    { 768, 360, 16},
    { 808, 296, 0},
    { 992, 384, -40},
    { 1216, 344, -8},
    { 1280, 240, 96},
    { 1832, 296, 56},
    { 1200, 264, 96},
    { 1072, 224, 88},
    { 1144, 136, 160},
    { 1008, 168, 136},
    { 928, 72, 184},
    { 792, 64, 96},
    { 744, 40, 40},
    { 712, -8, 48},
    { 744, 8, 40},
    { 800, -56, 16},
    { 992, -48, 16},
    { 1080, -8, -24},
    { 1632, -72, 88},
    { 1384, 120, 112},
    // 53 seconds
    { 1288, 320, -80},
    { 1152, 296, -24},
    { 816, 320, 96},
    { 712, 128, 104},
    { 776, 168, 104},
    { 848, 200, 88},
    { 816, 272, 64},
    { 864, 352, 0},
    { 984, 384, -48},
    { 1208, 360, -32},
    { 1272, 328, 16},
    { 1952, 264, 80},
    { 1296, 384, 96},
    { 1000, 264, 72},
    { 1096, 144, 160},
    { 1176, 56, 240},
    { 944, 40, 232},
    { 792, 24, 152},
    { 800, 16, 152},
    { 784, 0, 88},
    { 784, -48, 112},
    { 880, -64, 80},
    { 1040, -72, 40},
    { 1064, -32, -24},
    { 1488, -200, 56},
    // 54 seconds
    { 1352, -16, 96},
    { 960, 232, -72},
    { 1168, 256, -160},
    { 976, 296, 48},
    { 712, 144, 112},
    { 792, 216, 128},
    { 880, 256, 168},
    { 896, 352, 96},
    { 832, 344, 72},
    { 960, 440, -40},
    { 1152, 336, -48},
    { 1208, 288, -64},
    { 1976, 568, 160},
    { 1560, 360, 136},
    { 896, 240, 80},
    { 1080, 200, 112},
    { 1152, 64, 256},
    { 968, 56, 224},
    { 824, 96, 152},
    { 760, 72, 128},
    { 752, 32, 112},
    { 712, -8, 96},
    { 744, -24, 56},
    { 904, -56, 32},
    { 1144, 40, -64},
    // 55 seconds
    { 1408, -128, 0},
    { 1608, 16, 184},
    { 1232, 456, -8},
    { 1152, 496, -40},
    { 944, 480, 88},
    { 616, 168, 192},
    { 688, 240, 176},
    { 760, 248, 168},
    { 760, 288, 120},
    { 720, 312, 64},
    { 848, 360, 24},
    { 1056, 408, 0},
    { 1232, 360, 24},
    { 1504, 272, 144},
    { 1848, 384, 224},
    { 992, 408, 136},
    { 816, 312, 96},
    { 1032, 136, 200},
    { 1008, 64, 240},
    { 880, 112, 168},
    { 784, 48, 120},
    { 728, 64, 72},
    { 720, 56, 56},
    { 760, 8, 64},
    { 888, -16, 24},
    // 56 seconds
    { 1104, -8, 0},
    { 1224, -40, 8},
    { 1672, -112, 184},
    { 1224, 216, 48},
    { 1128, 344, -112},
    { 1040, 248, 24},
    { 696, 224, 136},
    { 664, 192, 120},
    { 784, 216, 144},
    { 824, 288, 112},
    { 768, 280, 104},
    { 808, 360, -16},
    { 904, 392, -64},
    { 1136, 368, -56},
    { 1248, 328, 8},
    { 1856, 352, 136},
    { 1392, 392, 176},
    { 944, 280, 136},
    { 1064, 224, 176},
    { 1112, 120, 272},
    { 912, 96, 232},
    { 768, 104, 152},
    { 752, 80, 136},
    { 784, 48, 112},
    { 792, 24, 96},
    // 57 seconds
    { 912, 8, 72},
    { 1104, -16, 24},
    { 1048, -16, -8},
    { 1456, -80, 32},
    { 1312, 24, 112},
    { 1120, 248, -40},
    { 1112, 304, -144},
    { 920, 240, 48},
    { 648, 112, 152},
    { 760, 232, 104},
    { 864, 264, 168},
    { 880, 328, 120},
    { 800, 376, 56},
    { 856, 440, -32},
    { 1160, 432, -80},
    { 1272, 360, -80},
    { 1664, 296, 24},
    { 1640, 400, 80},
    { 952, 352, 64},
    { 976, 272, 112},
    { 1280, 160, 192},
    { 1016, 96, 248},
    { 872, 88, 192},
    { 856, 88, 112},
    { 840, 48, 88},
    // 58 seconds
    { 776, 48, 48},
    { 768, -16, 56},
    { 864, -40, 16},
    { 1008, -8, -56},
    { 1104, -56, -40},
    { 1464, -32, 48},
    { 1320, 152, 96},
    { 1304, 360, -48},
    { 1184, 472, -80},
    { 752, 272, 144},
    { 744, 272, 152},
    { 808, 296, 168},
    { 896, 344, 144},
    { 808, 392, 112},
    { 808, 456, 48},
    { 928, 480, 24},
    { 1176, 448, 40},
    { 1288, 368, 136},
    { 1800, 480, 184},
    { 1272, 448, 152},
    { 1008, 304, 144},
    { 1144, 192, 216},
    { 1160, 104, 248},
    { 912, 56, 240},
    { 808, 64, 168},
    // 59 seconds
    { 784, 48, 120},
    { 720, 0, 120},
    { 720, -8, 72},
    { 784, -40, 64},
    { 976, -40, -8},
    { 1080, 16, -48},
    { 1584, -104, 48},
    { 1544, 32, 168},
    { 1288, 432, 16},
    { 1128, 480, -104},
    { 784, 360, 96},
    { 664, 176, 168},
    { 752, 280, 184},
    { 776, 264, 272},
    { 768, 368, 232},
    { 744, 480, 152},
    { 880, 576, 72},
    { 1000, 368, 96},
    { 1240, 400, 48},
    { 1608, 360, 144},
    { 1656, 456, 192},
    { 944, 392, 80},
    { 840, 296, 80},
    { 1096, 224, 160},
    { 992, 80, 224},
    // 60 seconds
    // elapsed: 1 minutes
    { 832, 96, 144},
    { 776, 104, 96},
    { 760, 96, 80},
    { 768, 48, 56},
    { 792, 40, 40},
    { 912, -8, 40},
    { 1128, 24, -24},
    { 1144, 72, -152},
    { 1576, -24, 24},
    { 1272, 144, 48},
    { 960, 288, -112},
    { 1048, 408, -176},
    { 848, 328, 56},
    { 680, 176, 136},
    { 744, 224, 128},
    { 816, 280, 136},
    { 776, 328, 80},
    { 776, 360, 0},
    { 888, 464, -128},
    { 1048, 392, -152},
    { 1320, 400, -128},
    { 1784, 368, 24},
    { 1664, 424, 96},
    { 808, 384, 16},
    { 848, 304, 32},
    // 61 seconds
    { 1104, 160, 152},
    { 976, 64, 200},
    { 832, 88, 144},
    { 792, 88, 96},
    { 720, 80, 48},
    { 728, 40, 72},
    { 824, 24, 48},
    { 968, -8, 32},
    { 1104, 24, -24},
    { 1400, -144, 16},
    { 1720, -40, 112},
    { 1136, 248, -80},
    { 1016, 376, -288},
    { 896, 256, -64},
    { 656, 176, 40},
    { 712, 144, 80},
    { 824, 184, 144},
    { 824, 280, 112},
    { 752, 320, 56},
    { 784, 424, -56},
    { 1008, 472, -144},
    { 1208, 400, -112},
    { 1376, 344, -40},
    { 1792, 376, 32},
    { 1432, 416, 16},
    // 62 seconds
    { 768, 280, 16},
    { 1000, 208, 72},
    { 1072, 120, 200},
    { 800, 104, 200},
    { 792, 112, 120},
    { 744, 96, 88},
    { 704, 32, 88},
    { 760, 16, 56},
    { 896, 32, 32},
    { 1056, 8, -32},
    { 1144, 80, -112},
    { 1152, -112, 176},
    { 1304, 112, 64},
    { 1072, 248, -96},
    { 1112, 304, -128},
    { 768, 280, 48},
    { 624, 176, 32},
    { 728, 176, 80},
    { 800, 216, 80},
    { 760, 240, 48},
    { 784, 296, 0},
    { 888, 408, -104},
    { 1056, 360, -112},
    { 1264, 280, -64},
    { 1672, 216, 64},
    // 63 seconds
    { 1688, 400, 104},
    { 888, 360, 24},
    { 880, 248, 48},
    { 1072, 176, 144},
    { 952, 96, 208},
    { 776, 80, 160},
    { 728, 80, 96},
    { 720, 40, 88},
    { 784, 48, 80},
    { 880, 48, 48},
    { 1040, -24, 32},
    { 1200, 8, 16},
    { 1264, -88, -48},
    { 1440, -32, 56},
    { 1088, 208, -56},
    { 984, 240, -160},
    { 960, 248, -88},
    { 680, 184, 32},
    { 656, 160, 72},
    { 760, 232, 80},
    { 832, 256, 88},
    { 792, 280, 48},
    { 880, 384, -72},
    { 1048, 400, -136},
    { 1232, 352, -128},
    // 64 seconds
    { 1328, 256, -24},
    { 1808, 344, 56},
    { 1256, 432, 72},
    { 816, 280, 48},
    { 1024, 224, 112},
    { 1096, 152, 192},
    { 856, 112, 152},
    { 760, 56, 120},
    { 752, 80, 80},
    { 776, 40, 64},
    { 808, 40, 48},
    { 936, 8, 48},
    { 1072, 16, -48},
    { 1080, 48, -152},
    { 1480, -128, -56},
    { 1424, 16, 72},
    { 1072, 264, -56},
    { 1096, 280, -176},
    { 888, 376, 16},
    { 664, 168, 112},
    { 760, 240, 112},
    { 808, 264, 160},
    { 784, 328, 112},
    { 760, 368, 56},
    { 896, 528, -104},
    // 65 seconds
    { 1064, 472, -56},
    { 1256, 280, -72},
    { 1512, 208, -48},
    { 1704, 384, -24},
    { 1040, 456, -32},
    { 848, 312, -64},
    { 1016, 184, 40},
    { 1032, 80, 136},
    { 896, 88, 104},
    { 768, 80, 64},
    { 712, 72, 48},
    { 752, 16, 56},
    { 824, 16, 40},
    { 1000, -56, 56},
    { 1136, 16, -16},
    { 1144, -16, -80},
    { 1496, -56, 152},
    { 1080, 232, -32},
    { 1120, 288, -176},
    { 968, 376, -128},
    { 600, 40, 152},
    { 720, 248, 112},
    { 776, 496, 88},
    { 816, 424, 56},
    { 776, 384, 56},
    // 66 seconds
    { 768, 360, -64},
    { 984, 360, -96},
    { 1128, 272, -64},
    { 1184, 208, -16},
    { 1840, 248, 56},
    { 1376, 432, 56},
    { 824, 360, 24},
    { 968, 296, 72},
    { 1080, 192, 128},
    { 912, 96, 144},
    { 776, 80, 96},
    { 768, 72, 56},
    { 800, 64, 24},
    { 776, 64, 8},
    { 912, 24, 0},
    { 1064, -32, -16},
    { 1136, 0, -32},
    { 1392, -88, -40},
    { 1392, 72, 8},
    { 1048, 224, -120},
    { 1160, 360, -160},
    { 888, 304, -8},
    { 632, 160, 16},
    { 680, 208, 40},
    { 728, 216, 32},
    // 67 seconds
    { 768, 264, 24},
    { 776, 304, -8},
    { 968, 360, -120},
    { 1064, 384, -168},
    { 1160, 304, -152},
    { 1464, 192, -32},
    { 1560, 360, -16},
    { 992, 456, -56},
    { 912, 368, -56},
    { 1056, 232, 32},
    { 1008, 160, 104},
    { 848, 136, 64},
    { 776, 128, 24},
    { 752, 112, 24},
    { 808, 64, 8},
    { 864, 16, 24},
    { 936, 8, 16},
    { 1096, 16, -24},
    { 1024, 96, -160},
    { 1512, -32, 96},
    { 1160, 224, 24},
    { 1040, 272, -168},
    { 1072, 272, -48},
    { 752, 208, 56},
    { 704, 152, 32},
    // 68 seconds
    { 736, 224, 16},
    { 824, 248, 24},
    { 800, 288, 8},
    { 800, 344, -56},
    { 952, 392, -120},
    { 1104, 328, -128},
    { 1280, 296, -120},
    { 1568, 160, 0},
    { 1664, 296, -24},
    { 968, 328, -48},
    { 800, 240, 0},
    { 1000, 176, 88},
    { 976, 80, 184},
    { 768, 112, 120},
    { 720, 72, 104},
    { 720, 48, 120},
    { 752, 32, 96},
    { 904, 32, 104},
    { 1040, 0, 88},
    { 1200, 112, -64},
    { 1152, -8, -128},
    { 1656, -40, -24},
    { 1120, 232, -136},
    { 968, 304, -328},
    { 936, 328, -184},
    // 69 seconds
    { 752, 192, -8},
    { 688, 208, 88},
    { 728, 232, 104},
    { 808, 264, 144},
    { 800, 352, 112},
    { 816, 328, 80},
    { 896, 416, -88},
    { 1152, 360, -176},
    { 1264, 336, -160},
    { 1768, 320, -128},
    { 1416, 400, -64},
    { 880, 312, -64},
    { 976, 256, 8},
    { 1112, 88, 176},
    { 904, 80, 176},
    { 776, 104, 96},
    { 744, 96, 64},
    { 720, 88, 16},
    { 736, 16, 48},
    { 824, 24, 8},
    { 1112, 0, -96},
    { 1120, -72, 24},
    { 968, -72, 8},
    { 1456, 72, -96},
    { 1040, 384, -288},
    // 70 seconds
    { 1160, 328, -152},
    { 992, 408, 32},
    { 712, 200, 136},
    { 752, 272, 72},
    { 768, 272, 80},
    { 744, 288, 88},
    { 704, 280, 16},
    { 824, 336, -88},
    { 1024, 520, -224},
    { 1136, 256, -8},
    { 1248, 64, 16},
    { 1840, 408, 64},
    { 1280, 408, 8},
    { 728, 312, 8},
    { 944, 256, 64},
    { 1024, 152, 168},
    { 880, 112, 136},
    { 760, 72, 96},
    { 752, 64, 72},
    { 768, 64, 40},
    { 680, -40, 96},
    { 984, -56, 24},
    { 1128, -72, 24},
    { 1120, 0, -96},
    { 1680, -224, 64},
    // 71 seconds
    { 1392, 104, 8},
    { 1016, 288, -184},
    { 1008, 344, -168},
    { 760, 160, 40},
    { 656, 144, 48},
    { 784, 120, 104},
    { 816, 224, 80},
    { 784, 296, 48},
    { 784, 320, -64},
    { 936, 384, -136},
    { 1072, 352, -144},
    { 1224, 184, -40},
    { 1464, 184, 16},
    { 1520, 392, -8},
    { 1088, 432, -16},
    { 936, 280, 72},
    { 1088, 176, 120},
    { 952, 88, 160},
    { 784, 88, 104},
    { 728, 80, 72},
    { 736, 56, 48},
    { 736, 0, 64},
    { 832, 8, 32},
    { 1040, -40, 40},
    { 1160, 24, -32},
    // 72 seconds
    { 1192, -32, -64},
    { 1560, -96, 96},
    { 1168, 280, -48},
    { 1032, 232, -176},
    { 920, 256, -56},
    { 632, 96, 88},
    { 656, 200, 48},
    { 808, 184, 120},
    { 880, 248, 56},
    { 728, 208, 24},
    { 776, 224, -48},
    { 976, 288, -104},
    { 1176, 232, -64},
    { 1272, 208, -32},
    { 1720, 280, 16},
    { 1424, 512, -8},
    { 880, 448, 8},
    { 1000, 280, 80},
    { 1128, 152, 184},
    { 904, 104, 152},
    { 856, 120, 88},
    { 824, 88, 56},
    { 824, 32, 40},
    { 800, 8, 16},
    { 864, -32, 8},
    // 73 seconds
    { 984, -48, -24},
    { 1024, 16, -80},
    { 1496, -192, -8},
    { 1512, 32, 112},
    { 1144, 248, -40},
    { 1120, 400, -136},
    { 888, 336, 80},
    { 680, 168, 96},
    { 768, 184, 112},
    { 840, 224, 96},
    { 776, 304, 56},
    { 680, 360, -16},
    { 784, 360, -56},
    { 1040, 376, -96},
    { 1264, 256, -8},
    { 1328, 248, 16},
    { 1856, 408, -32},
    { 1088, 448, -48},
    { 1024, 312, -56},
    { 1096, 152, 88},
    { 1008, 136, 120},
    { 896, 112, 152},
    { 784, 104, 96},
    { 768, 64, 96},
    { 784, -48, 112},
    // 74 seconds
    { 784, 8, 24},
    { 808, 80, -56},
    { 968, 0, -32},
    { 1104, 64, -32},
    { 1616, -88, 40},
    { 1384, 168, 88},
    { 1000, 360, -88},
    { 1144, 472, -144},
    { 896, 384, 16},
    { 584, 200, 40},
    { 720, 224, 48},
    { 792, 264, 24},
    { 784, 296, 40},
    { 792, 392, 8},
    { 888, 416, -48},
    { 1120, 504, -96},
    { 1296, 520, -80},
    { 1560, 416, -8},
    { 1616, 504, 0},
    { 1048, 480, 8},
    { 1032, 296, 32},
    { 1120, 104, 160},
    { 856, 72, 208},
    { 664, 64, 152},
    { 672, 96, 120},
    // 75 seconds
    { 672, 64, 88},
    { 736, 24, 88},
    { 752, 0, 88},
    { 792, -24, 48},
    { 1048, 24, -64},
    { 1200, 80, -120},
    { 1832, -80, 32},
    { 1432, 392, -160},
    { 928, 528, -360},
    { 960, 352, -40},
    { 784, 216, 56},
    { 680, 192, 16},
    { 736, 176, 64},
    { 768, 256, 24},
    { 736, 264, 8},
    { 808, 328, -24},
    { 888, 424, -168},
    { 1088, 264, 8},
    { 1264, 328, -112},
    { 1752, 200, 32},
    { 1720, 376, 72},
    { 856, 352, 8},
    { 856, 304, 16},
    { 1032, 88, 112},
    { 936, 16, 152},
    // 76 seconds
    { 808, 72, 88},
    { 760, 88, 48},
    { 720, 32, 40},
    { 736, 24, 24},
    { 784, 0, 24},
    { 928, 0, 8},
    { 1160, 32, -24},
    { 1248, -24, -32},
    { 1736, -72, 32},
    { 1200, 280, 24},
    { 784, 480, -208},
    { 936, 344, -16},
    { 792, 152, 72},
    { 704, 120, 104},
    { 808, 272, -16},
    { 824, 312, -32},
    { 792, 328, -32},
    { 784, 360, -112},
    { 928, 336, -160},
    { 1176, 184, -72},
    { 1328, 136, -8},
    { 1848, 184, 88},
    { 1472, 328, 48},
    { 848, 320, -32},
    { 872, 192, 24},
    // 77 seconds
    { 1008, 48, 104},
    { 872, 0, 136},
    { 752, 40, 88},
    { 712, 32, 96},
    { 680, 40, 64},
    { 696, 24, 48},
    { 768, 8, 32},
    { 904, -8, 16},
    { 1160, -24, 0},
    { 1328, 24, -48},
    { 1736, -24, 72},
    { 1400, 152, 48},
    { 864, 416, -160},
    { 904, 376, -96},
    { 768, 72, 24},
    { 616, 88, 24},
    { 728, 152, 16},
    { 784, 232, 8},
    { 792, 272, -24},
    { 824, 264, -40},
    { 896, 280, -96},
    { 1088, 240, -72},
    { 1280, 200, -72},
    { 1768, 136, 32},
    { 1496, 296, 16},
    // 78 seconds
    { 896, 360, -16},
    { 952, 280, 16},
    { 1048, 160, 104},
    { 904, 72, 128},
    { 776, 72, 104},
    { 712, 104, 40},
    { 712, 56, 40},
    { 792, 0, 40},
    { 848, 24, 8},
    { 968, -56, 40},
    { 1192, 8, -16},
    { 1272, -72, 24},
    { 1688, -48, 48},
    { 1072, 240, 24},
    { 864, 320, -144},
    { 912, 240, -32},
    { 648, 112, 40},
    { 656, 96, 72},
    { 752, 184, 48},
    { 848, 288, 40},
    { 784, 320, -8},
    { 840, 328, -24},
    { 1008, 352, -104},
    { 1192, 248, -96},
    { 1272, 176, -48},
    // 79 seconds
    { 1960, 240, 0},
    { 1224, 384, -16},
    { 856, 288, -24},
    { 984, 176, 72},
    { 976, 88, 120},
    { 792, 72, 120},
    { 704, 72, 88},
    { 720, 80, 48},
    { 720, 8, 72},
    { 744, 24, 32},
    { 824, 0, 32},
    { 1064, 8, 0},
    { 1240, 72, -88},
    { 1552, -80, -16},
    { 1624, -40, 104},
    { 864, 408, -176},
    { 904, 352, -192},
    { 960, 176, 72},
    { 632, 72, 80},
    { 720, 160, 112},
    { 752, 272, 72},
    { 744, 320, 24},
    { 752, 288, -8},
    { 816, 360, -144},
    { 1032, 288, -128},
    // 80 seconds
    { 1200, 248, -120},
    { 1392, 128, 0},
    { 1768, 272, 16},
    { 1144, 296, 64},
    { 976, 264, 24},
    { 984, 176, 88},
    { 848, 160, 64},
    { 728, 104, 96},
    { 648, 112, 32},
    { 664, 72, 32},
    { 704, 32, 56},
    { 736, 16, 32},
    { 888, 0, 32},
    { 1144, 32, 0},
    { 1328, 56, 0},
    { 1904, -32, 120},
    { 1368, 256, 24},
    { 712, 424, -152},
    { 896, 288, -72},
    { 752, 104, 24},
    { 664, 152, 40},
    { 760, 192, 24},
    { 816, 312, 0},
    { 728, 248, -40},
    { 768, 272, -112},
    // 81 seconds
    { 808, 240, -184},
    { 1120, 296, -80},
    { 1264, 280, 0},
    { 1728, 136, 112},
    { 1704, 320, 24},
    { 904, 384, -40},
    { 808, 272, -32},
    { 928, 120, 72},
    { 824, 96, 80},
    { 728, 88, 72},
    { 696, 96, 56},
    { 672, 80, 48},
    { 728, 24, 64},
    { 768, 56, 16},
    { 936, 32, 24},
    { 1256, 48, -24},
    { 1352, 56, 0},
    { 1840, -72, 160},
    { 1136, 352, -104},
    { 768, 400, -232},
    { 944, 112, -24},
    { 608, 72, 16},
    { 592, 120, 32},
    { 720, 184, 16},
    { 728, 208, 24},
    // 82 seconds
    { 712, 192, 24},
    { 832, 304, -56},
    { 984, 520, -168},
    { 1144, 88, -24},
    { 1224, 0, -16},
    { 1872, 88, 8},
    { 1376, 360, -120},
    { 848, 344, -168},
    { 944, 160, -48},
    { 672, -80, 112},
    { 872, 232, 48},
    { 768, 160, 64},
    { 736, 72, 32},
    { 760, 48, 40},
    { 736, 8, 16},
    { 800, 24, 0},
    { 1008, 0, 0},
    { 1248, 40, -32},
    { 1384, -32, 48},
    { 1760, -72, 248},
    { 1104, 384, -64},
    { 912, 376, -128},
    { 800, 160, 24},
    { 584, 32, 32},
    { 688, 96, 32},
    // 83 seconds
    { 712, 168, 16},
    { 768, 200, 16},
    { 744, 208, -24},
    { 776, 280, -104},
    { 896, 296, -144},
    { 1192, 248, -128},
    { 1232, 104, 16},
    { 1896, 136, 136},
    { 1472, 344, 48},
    { 712, 336, -8},
    { 920, 168, 40},
    { 896, 72, 64},
    { 752, 72, 88},
    { 712, 72, 56},
    { 672, 64, 56},
    { 688, 72, 24},
    { 720, 48, 48},
    { 824, 96, 24},
    { 960, 24, 56},
    { 1360, 72, 72},
    { 1400, 80, 96},
    { 1848, -48, 216},
    { 1480, 296, 32},
    { 520, 648, -296},
    { 624, 0, 0},
    // 84 seconds
    { 824, -80, 136},
    { 616, 72, 136},
    { 736, 144, 72},
    { 816, 272, 0},
    { 720, 232, 0},
    { 736, 256, -96},
    { 848, 216, -96},
    { 1152, 136, -112},
    { 1256, 192, -128},
    { 1760, 104, 40},
    { 1720, 368, -64},
    { 872, 432, -16},
    { 928, 200, 40},
    { 1072, 56, 120},
    { 888, 56, 48},
    { 768, 48, 56},
    { 728, 40, 32},
    { 696, 56, 0},
    { 648, 40, 16},
    { 600, 16, 32},
    { 752, 8, 48},
    { 1088, 48, 40},
    { 1344, 112, 104},
    { 1936, 40, 240},
    { 2032, 176, 264},
    // 85 seconds
    { 824, 752, -200},
    { 608, 48, 96},
    { 968, 8, 208},
    { 616, 56, 192},
    { 648, 88, 208},
    { 728, 168, 240},
    { 672, 264, 112},
    { 688, 272, 24},
    { 800, 280, -40},
    { 1112, 296, -80},
    { 1288, 312, -120},
    { 1712, 144, 64},
    { 1880, 336, 32},
    { 968, 496, 0},
    { 784, 240, 0},
    { 1048, 120, 104},
    { 920, 144, 80},
    { 768, 112, 40},
    { 744, 64, 64},
    { 728, 48, 56},
    { 712, 32, 48},
    { 688, 24, 48},
    { 768, 56, 40},
    { 1016, 88, -8},
    { 1192, 80, 0},
    // 86 seconds
    { 1576, -72, 160},
    { 2128, -72, 408},
    { 1208, 664, -136},
    { 504, 448, -232},
    { 872, 32, 144},
    { 640, -32, 120},
    { 640, 88, 160},
    { 720, 216, 136},
    { 680, 280, 128},
    { 696, 448, -8},
    { 776, 352, -56},
    { 960, 128, -216},
    { 1240, 240, -48},
    { 1520, 232, 64},
    { 1976, 320, 64},
    { 1008, 480, -24},
    { 832, 400, -56},
    { 952, 160, 8},
    { 912, 88, 64},
    { 808, 96, 56},
    { 696, 80, 0},
    { 672, 88, -40},
    { 656, 32, -16},
    { 704, 16, -16},
    { 792, 0, -24},
    // 87 seconds
    { 1096, 72, -96},
    { 1200, 64, -112},
    { 2080, -104, 144},
    { 1744, 128, 120},
    { 768, 632, -208},
    { 680, 392, -136},
    { 688, 64, 40},
    { 584, 64, 48},
    { 680, 120, 16},
    { 736, 168, 0},
    { 752, 240, 0},
    { 768, 344, -56},
    { 848, 312, -96},
    { 1144, 304, -120},
    { 1264, 240, -88},
    { 1832, 208, 32},
    { 1680, 312, 48},
    { 888, 400, 40},
    { 832, 296, 64},
    { 976, 152, 144},
    { 872, 112, 136},
    { 736, 80, 120},
    { 664, 104, 40},
    { 704, 80, 16},
    { 736, 24, 24},
    // 88 seconds
    { 776, 32, -8},
    { 936, 8, 24},
    { 1144, 56, -104},
    { 1608, -128, 72},
    { 1776, -24, 96},
    { 1256, 480, -200},
    { 864, 360, -224},
    { 632, 80, 72},
    { 632, 48, 80},
    { 704, 144, 56},
    { 720, 120, 112},
    { 800, 240, 80},
    { 800, 320, 24},
    { 848, 392, -64},
    { 1040, 344, -80},
    { 1200, 336, -104},
    { 1624, 240, 0},
    { 1808, 336, 40},
    { 1000, 392, 40},
    { 944, 336, 40},
    { 1128, 216, 112},
    { 992, 120, 160},
    { 776, 160, 96},
    { 720, 160, 24},
    { 736, 64, 40},
    // 89 seconds
    { 712, 0, 48},
    { 776, 0, 72},
    { 864, 16, 8},
    { 1016, 56, -56},
    { 1072, 104, -152},
    { 1824, -112, 112},
    { 1384, 56, 24},
    { 1264, 400, -128},
    { 920, 392, -136},
    { 672, 168, 72},
    { 720, 88, 80},
    { 728, 152, 64},
    { 808, 216, 48},
    { 840, 312, 0},
    { 816, 352, -16},
    { 888, 488, -152},
    { 1128, 432, -112},
    { 1248, 384, -56},
    { 1672, 352, 24},
    { 1576, 360, 80},
    { 976, 352, 64},
    { 1064, 248, 112},
    { 1184, 112, 192},
    { 960, 80, 208},
    { 784, 96, 168},
    // 90 seconds
    { 744, 104, 136},
    { 728, 40, 96},
    { 736, 0, 64},
    { 824, 40, 112},
    { 872, 40, 56},
    { 960, 16, -24},
    { 1080, 16, -88},
    { 1864, -96, -144},
    { 1296, 64, 40},
    { 1376, 496, -168},
    { 1160, 496, -168},
    { 712, 280, 120},
    { 784, 184, 104},
    { 744, 264, 72},
    { 752, 304, 48},
    { 752, 280, 64},
    { 800, 384, -16},
    { 832, 392, -32},
    { 992, 424, -96},
    { 1152, 504, -32},
    { 1704, 416, 96},
    { 1640, 432, 144},
    { 1024, 424, 88},
    { 1056, 344, 128},
    { 1168, 168, 216},
    // 91 seconds
    { 968, 136, 240},
    { 752, 120, 192},
    { 720, 120, 144},
    { 736, 32, 160},
    { 752, 0, 136},
    { 816, 40, 88},
    { 808, -40, 96},
    { 1064, 80, -8},
    { 1056, 96, -80},
    { 1592, -56, 128},
    { 1256, 168, 64},
    { 1376, 464, -112},
    { 1224, 552, -64},
    { 736, 392, 104},
    { 736, 224, 120},
    { 752, 280, 104},
    { 792, 344, 56},
    { 768, 360, 48},
    { 792, 368, -24},
    { 928, 472, -16},
    { 1128, 440, 0},
    { 1240, 336, 72},
    { 1728, 184, 184},
    { 1464, 344, 168},
    { 1008, 272, 160},
    // 92 seconds
    { 1032, 184, 200},
    { 1024, 64, 232},
    { 888, 24, 232},
    { 776, 32, 192},
    { 752, 8, 168},
    { 744, -8, 144},
    { 784, -24, 112},
    { 840, 0, 80},
    { 992, -40, 56},
    { 1144, -56, 8},
    { 1328, -184, 80},
    { 1488, -152, 112},
    { 1112, 232, -72},
    { 1208, 320, -216},
    { 984, 192, 32},
    { 752, 160, 80},
    { 768, 216, 80},
    { 768, 200, 128},
    { 824, 272, 96},
    { 808, 248, 112},
    { 872, 392, -16},
    { 984, 376, -40},
    { 1224, 384, -88},
    { 1336, 224, 80},
    { 1952, 304, 56},
    // 93 seconds
    { 1232, 368, 128},
    { 1000, 288, 88},
    { 1200, 88, 184},
    { 1160, -32, 288},
    { 880, 56, 192},
    { 848, 104, 120},
    { 832, 48, 128},
    { 744, -16, 72},
    { 688, -56, 80},
    { 728, -64, 64},
    { 912, -48, 8},
    { 992, -8, -64},
    { 1632, -248, 104},
    { 1704, -72, 184},
    { 1352, 400, -56},
    { 1240, 392, -56},
    { 912, 280, 184},
    { 760, 80, 176},
    { 808, 160, 184},
    { 816, 256, 120},
    { 768, 280, 120},
    { 792, 328, 56},
    { 904, 416, -40},
    { 1040, 392, -48},
    { 1224, 320, -56},
    // 94 seconds
    { 1400, 208, 96},
    { 1760, 304, 96},
    { 1176, 416, 48},
    { 1088, 256, 104},
    { 1216, -80, 232},
    { 1048, -40, 224},
    { 856, 40, 176},
    { 776, 56, 120},
    { 776, 40, 56},
    { 736, 0, 56},
    { 760, -24, 96},
    { 848, -80, 72},
    { 968, -96, 8},
    { 1032, -24, -72},
    { 1400, -224, 112},
    { 1504, 40, 0},
    { 1416, 256, -136},
    { 1168, 256, -56},
    { 856, 232, 40},
    { 728, 152, 88},
    { 752, 176, 96},
    { 792, 152, 112},
    { 760, 168, 72},
    { 784, 224, 8},
    { 856, 336, -96},
    // 95 seconds
    { 1000, 336, -88},
    { 1240, 328, -112},
    { 1624, 184, 40},
    { 1824, 240, 152},
    { 1080, 344, 80},
    { 904, 288, 40},
    { 1032, 144, 112},
    { 1016, 24, 200},
    { 872, 56, 200},
    { 760, 48, 168},
    { 720, 32, 152},
    { 784, 8, 144},
    { 864, 0, 168},
    { 832, -48, 104},
    { 1008, -48, 48},
    { 1032, -8, -8},
    { 1624, -128, 96},
    { 1512, 24, 112},
    { 1192, 488, -232},
    { 1024, 336, -176},
    { 872, 184, 104},
    { 736, 48, 144},
    { 760, 104, 160},
    { 808, 240, 128},
    { 784, 392, 16},
    // 96 seconds
    { 728, 264, 72},
    { 848, 456, -104},
    { 984, 264, 32},
    { 1224, 440, -104},
    { 1416, 240, 96},
    { 1824, 384, 80},
    { 1112, 408, 32},
    { 928, 328, 24},
    { 1184, 184, 128},
    { 1152, 136, 192},
    { 888, 48, 208},
    { 744, 64, 144},
    { 744, 48, 144},
    { 712, 8, 144},
    { 720, 24, 80},
    { 784, 8, 64},
    { 920, -40, 56},
    { 1080, -24, 48},
    { 1640, -80, 176},
    { 1400, 160, 160},
    { 1192, 448, -128},
    { 1248, 328, -72},
    { 880, 264, 120},
    { 712, 136, 64},
    { 768, 232, 112},
    // 97 seconds
    { 808, 264, 72},
    { 760, 232, 80},
    { 784, 272, 24},
    { 880, 336, -32},
    { 1112, 352, -40},
    { 1216, 264, 72},
    { 1480, 72, 80},
    { 1784, 80, 200},
    { 1208, 296, 88},
    { 960, 168, 112},
    { 1104, 88, 152},
    { 1000, -40, 272},
    { 816, 8, 216},
    { 752, 0, 168},
    { 744, 16, 136},
    { 720, -32, 152},
    { 728, -24, 120},
    { 784, -64, 120},
    { 976, -48, 40},
    { 1128, 16, 24},
    { 2136, -216, 136},
    { 1384, 136, -16},
    { 1216, 264, -288},
    { 1080, 176, -184},
    { 864, 120, 48},
    // 98 seconds
    { 744, 72, 64},
    { 712, 120, 112},
    { 792, 184, 144},
    { 832, 272, 112},
    { 792, 328, 40},
    { 896, 352, -40},
    { 1032, 360, -72},
    { 1272, 264, -56},
    { 1624, 152, 72},
    { 1808, 200, 168},
    { 1136, 288, 120},
    { 952, 208, 96},
    { 1096, 40, 216},
    { 1056, 16, 232},
    { 904, 56, 144},
    { 776, 32, 120},
    { 728, 24, 64},
    { 728, 0, 56},
    { 736, -40, 56},
    { 784, -72, 64},
    { 952, -64, 24},
    { 1096, -48, 24},
    { 1304, -216, 240},
    { 1528, 72, 216},
    { 1272, 456, -104},
    // 99 seconds
    { 1072, 400, -56},
    { 816, 176, 176},
    { 736, -8, 160},
    { 784, 160, 104},
    { 816, 216, 104},
    { 792, 304, 48},
    { 800, 296, 32},
    { 888, 368, -32},
    { 1144, 368, -40},
    { 1264, 272, -40},
    { 1576, 176, 96},
    { 1656, 288, 128},
    { 984, 336, 64},
    { 936, 232, 96},
    { 1160, 104, 192},
    { 1064, 80, 208},
    { 856, 56, 160},
    { 752, 24, 144},
    { 792, 48, 88},
    { 784, -24, 112},
    { 776, -16, 96},
    { 816, -56, 88},
    { 984, -40, 32},
    { 1056, 24, -40},
    { 1528, -80, 72},
    // 100 seconds
    { 1552, 64, 176},
    { 1280, 456, -128},
    { 1088, 416, -64},
    { 872, 280, 152},
    { 760, 136, 144},
    { 744, 136, 176},
    { 808, 232, 96},
    { 736, 224, 64},
    { 648, 280, -40},
    { 848, 304, -88},
    { 1104, 328, -80},
    { 1304, 264, -32},
    { 1552, 160, 104},
    { 1608, 272, 112},
    { 1088, 336, 144},
    { 1016, 272, 120},
    { 1088, 152, 192},
    { 1040, 112, 224},
    { 872, 88, 184},
    { 792, 88, 128},
    { 760, 24, 120},
    { 728, 0, 96},
    { 752, -16, 72},
    { 832, -72, 96},
    { 968, 8, 16},
    // 101 seconds
    { 1112, -32, 24},
    { 1544, -144, 304},
    { 1488, 208, 136},
    { 1272, 384, -96},
    { 968, 240, -16},
    { 736, 56, 168},
    { 768, 96, 160},
    { 784, 176, 152},
    { 824, 288, 120},
    { 792, 312, 160},
    { 832, 448, 40},
    { 896, 336, 40},
    { 1168, 400, -48},
    { 1232, 288, 32},
    { 1848, 312, 40},
    { 1488, 336, 32},
    { 1040, 240, 104},
    { 1176, 88, 200},
    { 1272, 64, 280},
    { 1024, 64, 256},
    { 776, 80, 176},
    { 784, 88, 120},
    { 816, 0, 136},
    { 800, -32, 120},
    { 760, -64, 104},
    // 102 seconds
    { 864, -88, 48},
    { 960, 0, -24},
    { 1296, -112, -32},
    { 1592, -112, 192},
    { 1296, 272, 8},
    { 1320, 360, -104},
    { 1184, 360, 136},
    { 872, 280, 216},
    { 800, 264, 176},
    { 832, 264, 168},
    { 784, 296, 152},
    { 744, 312, 72},
    { 856, 392, 0},
    { 1016, 408, -32},
    { 1176, 360, -40},
    { 1296, 288, 96},
    { 1744, 352, 104},
    { 1264, 464, 40},
    { 1080, 280, 72},
    { 1184, 24, 304},
    { 1192, 72, 256},
    { 1000, 16, 160},
    { 792, -8, 176},
    { 736, 0, 120},
    { 688, -56, 80},
    // 103 seconds
    { 632, -72, 64},
    { 744, -80, 56},
    { 936, -80, 64},
    { 1080, 0, 0},
    { 1552, -208, 152},
    { 1664, -40, 272},
    { 1312, 272, 32},
    { 1368, 384, -80},
    { 960, 352, 136},
    { 672, 96, 112},
    { 720, 152, 104},
    { 824, 200, 120},
    { 856, 312, 32},
    { 800, 304, 24},
    { 920, 408, -64},
    { 1056, 376, -56},
    { 1248, 272, -24},
    { 1544, 136, 144},
    { 1760, 272, 200},
    { 1088, 248, 208},
    { 1160, 168, 136},
    { 1192, 48, 264},
    { 1016, 40, 256},
    { 824, 48, 208},
    { 760, 40, 160},
    // 104 seconds
    { 776, 0, 128},
    { 800, -64, 152},
    { 848, -48, 112},
    { 896, -104, 112},
    { 1040, -8, -24},
    { 1080, -112, 0},
    { 1512, -232, 176},
    { 1400, 88, 144},
    { 1152, 312, -104},
    { 1136, 288, -24},
    { 864, 160, 264},
    { 872, 160, 208},
    { 880, 160, 256},
    { 928, 328, 152},
    { 848, 328, 128},
    { 832, 352, 0},
    { 936, 344, -40},
    { 1112, 360, -80},
    { 1176, 296, -16},
    { 1768, 344, 80},
    { 1512, 360, 200},
    { 1040, 264, 168},
    { 1168, 128, 240},
    { 1272, 64, 304},
    { 1056, 40, 272},
    // 105 seconds
    { 904, 24, 216},
    { 896, 8, 192},
    { 872, -16, 144},
    { 824, -40, 128},
    { 856, -56, 96},
    { 912, -96, 64},
    { 936, -56, 8},
    { 1104, -176, -8},
    { 1376, -168, 160},
    { 1280, 104, 120},
    { 1368, 256, -80},
    { 1312, 296, 32},
    { 944, 176, 256},
    { 952, 216, 224},
    { 904, 248, 240},
    { 872, 264, 192},
    { 848, 288, 96},
    { 840, 384, 24},
    { 944, 456, -40},
    { 1128, 464, -56},
    { 1200, 344, 112},
    { 1848, 376, 184},
    { 1400, 376, 200},
    { 1056, 248, 136},
    { 1272, 136, 216},
    // 106 seconds
    { 1280, 32, 296},
    { 1136, 40, 264},
    { 952, -8, 256},
    { 888, -8, 224},
    { 856, -24, 192},
    { 816, -32, 112},
    { 824, -96, 120},
    { 872, -152, 96},
    { 928, -48, -16},
    { 1208, -120, -88},
    { 1424, -112, 80},
    { 1296, 168, -48},
    { 1440, 208, -208},
    { 1248, 248, 8},
    { 1000, 136, 192},
    { 968, 224, 160},
    { 952, 240, 224},
    { 920, 320, 200},
    { 800, 312, 152},
    { 824, 464, -40},
    { 1056, 456, 0},
    { 1168, 504, 0},
    { 1440, 400, 112},
    { 1920, 472, 64},
    { 1288, 320, 0},
    // 107 seconds
    { 1248, 112, -8},
    { 1368, -8, -40},
    { 1192, 16, 40},
    { 1016, -72, 160},
    { 912, -16, 152},
    { 832, -16, 152},
    { 856, 8, 168},
    { 840, -48, 184},
    { 936, -104, 184},
    { 960, -232, 136},
    { 888, -208, -32},
    { 1344, -152, -136},
    { 1272, -120, 0},
    { 1424, 32, 0},
    { 1648, 296, -176},
    { 1344, 464, 48},
    { 936, 272, 256},
    { 904, 360, 256},
    { 904, 304, 304},
    { 832, 368, 216},
    { 728, 304, 176},
    { 736, 440, 32},
    { 800, 440, 0},
    { 1016, 456, -32},
    { 1120, 112, 152},
    // 108 seconds
    { 1976, 456, 48},
    { 1600, 176, 120},
    { 1624, -16, 184},
    { 1552, 200, 128},
    { 1376, 0, 264},
    { 1240, -184, 208},
    { 1080, -64, 152},
    { 1032, 48, 152},
    { 912, 272, 168},
    { 768, 416, 40},
    { 568, 448, -128},
    { 568, 672, -336},
    { 568, 720, -304},
    { 496, 688, -360},
    { 432, 560, -352},
    { 272, 440, -160},
    { 264, 704, -272},
    { 312, 872, -192},
    { 256, 744, -184},
    { 320, 992, 8},
    { 200, 1072, -40},
    { 136, 976, 56},
    { 64, 888, 88},
    { 160, 968, -48},
    { -32, 984, 184},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:20:14 local
AccelRawData *activity_sample_walk_200_pbl_25299_8(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25299_8
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 64, -384, -968},
    { 40, -392, -960},
    { 32, -384, -968},
    { 24, -392, -968},
    { 32, -400, -976},
    { 32, -392, -976},
    { 24, -400, -968},
    { 32, -400, -960},
    { 0, -400, -952},
    { 24, -424, -952},
    { 16, -400, -952},
    { 40, -400, -936},
    { -16, -392, -952},
    { 8, -456, -944},
    { 32, -424, -928},
    { 24, -416, -928},
    { -24, -400, -984},
    { 96, -440, -1088},
    { 24, -416, -976},
    { 56, -440, -968},
    { 16, -408, -920},
    { 32, -392, -896},
    { 16, -384, -904},
    { 40, -440, -936},
    { 56, -392, -952},
    // 1 seconds
    { 24, -400, -992},
    { 40, -408, -984},
    { 16, -352, -976},
    { -16, -424, -960},
    { 48, -360, -952},
    { -16, -408, -968},
    { 32, -408, -1008},
    { 16, -384, -1048},
    { 56, -400, -976},
    { 104, -376, -880},
    { 136, -456, -680},
    { 136, -440, -536},
    { 112, -400, -472},
    { 184, -192, -472},
    { 208, 240, -536},
    { 272, 728, -672},
    { 384, 1104, -704},
    { 272, 1344, -472},
    { 248, 1648, -208},
    { 328, 1624, -216},
    { 600, 1208, -440},
    { 160, 856, -240},
    { 160, 752, -192},
    { 264, 784, -256},
    { 384, 656, -352},
    // 2 seconds
    { 464, 592, -280},
    { 456, 400, -336},
    { 520, 512, -400},
    { 616, 408, -376},
    { 672, 312, -344},
    { 808, 376, -424},
    { 1152, 168, -384},
    { 1312, 56, -256},
    { 1976, 120, -320},
    { 1432, 304, -568},
    { 608, 296, -576},
    { 776, 16, -416},
    { 808, 88, -296},
    { 728, 312, -320},
    { 736, 136, -224},
    { 696, 104, -272},
    { 664, 248, -192},
    { 736, 352, -408},
    { 784, 272, -328},
    { 1088, 264, -320},
    { 1272, 264, -296},
    { 1640, 320, -328},
    { 1456, 424, -384},
    { 896, 368, -320},
    { 880, 272, -304},
    // 3 seconds
    { 1024, 192, -104},
    { 848, 160, -88},
    { 720, 216, -160},
    { 680, 232, -136},
    { 640, 40, -48},
    { 728, -24, -40},
    { 776, 160, -40},
    { 928, 32, -176},
    { 1144, 32, -168},
    { 1216, 56, -152},
    { 1896, 288, -112},
    { 1240, 864, -376},
    { 1072, 1096, -656},
    { 768, 696, -464},
    { 544, 424, -240},
    { 336, 504, -152},
    { 320, 544, -200},
    { 272, 440, -240},
    { 264, 384, -232},
    { 280, 536, -296},
    { 416, 752, -344},
    { 488, 880, -224},
    { 560, 1032, -120},
    { 776, 1136, -152},
    { 712, 1352, -24},
    // 4 seconds
    { 384, 800, 16},
    { 384, 696, -120},
    { 368, 680, -128},
    { 424, 608, -200},
    { 424, 352, -88},
    { 464, 128, -104},
    { 592, 8, -120},
    { 736, -16, -56},
    { 984, 160, -16},
    { 1264, 216, 160},
    { 1576, 264, 288},
    { 1808, 280, 408},
    { 2352, 384, 296},
    { -2480, 536, 384},
    { 360, 424, -72},
    { 968, 40, 128},
    { 640, 48, 184},
    { 552, 128, 112},
    { 688, 208, 96},
    { 648, 352, 24},
    { 760, 512, -120},
    { 792, 360, -96},
    { 952, 256, -32},
    { 1304, 400, -120},
    { 1384, 272, 24},
    // 5 seconds
    { 1872, 336, 96},
    { 1408, 464, 24},
    { 792, 384, 56},
    { 1296, 336, -392},
    { 1008, -200, 416},
    { 888, -16, 32},
    { 624, 264, 0},
    { 632, 88, 112},
    { 680, 168, 104},
    { 672, 104, 136},
    { 776, 40, 88},
    { 952, 16, 112},
    { 1200, 88, 120},
    { 1528, 48, 144},
    { 1600, 136, 256},
    { 976, 384, -32},
    { 1048, 264, -256},
    { 864, 216, -64},
    { 600, 312, 0},
    { 576, 336, -16},
    { 696, 240, 64},
    { 776, 304, 80},
    { 816, 296, 56},
    { 912, 352, -56},
    { 1056, 368, -64},
    // 6 seconds
    { 1400, 432, -104},
    { 1528, 192, 112},
    { 1976, 304, 48},
    { 920, 344, 24},
    { 976, 288, 16},
    { 1008, 128, 168},
    { 912, 136, 160},
    { 744, 160, 128},
    { 664, 144, 48},
    { 680, 120, 80},
    { 728, 80, 120},
    { 752, 80, 72},
    { 856, 48, 8},
    { 1040, 8, 88},
    { 1192, 88, 24},
    { 1672, -72, 96},
    { 1336, 168, 72},
    { 1072, 376, -256},
    { 984, 280, -160},
    { 824, 320, 40},
    { 720, 152, 104},
    { 704, 200, 112},
    { 776, 272, 72},
    { 776, 288, 32},
    { 776, 304, 160},
    // 7 seconds
    { 880, 616, -88},
    { 1080, 632, -160},
    { 1344, 448, -56},
    { 1848, 248, 152},
    { 1616, 392, 88},
    { 984, 472, 0},
    { 992, 232, 120},
    { 928, 104, 512},
    { 952, 272, 88},
    { 816, 136, 80},
    { 736, 112, 144},
    { 728, 112, 104},
    { 712, 56, 104},
    { 704, 48, 56},
    { 824, 24, 56},
    { 1008, 80, -48},
    { 1192, -16, 88},
    { 1896, -40, 312},
    { 1216, 320, -64},
    { 1000, 416, -232},
    { 1048, 336, -24},
    { 792, 240, 88},
    { 712, 144, 88},
    { 744, 248, 112},
    { 800, 344, 24},
    // 8 seconds
    { 752, 360, 16},
    { 832, 384, -56},
    { 1016, 384, -64},
    { 1200, 400, -112},
    { 1240, 320, -16},
    { 2080, 360, 96},
    { 1320, 448, 40},
    { 760, 320, -8},
    { 984, 240, 136},
    { 1112, 136, 264},
    { 936, 176, 192},
    { 856, 80, 248},
    { 736, 112, 184},
    { 720, 112, 104},
    { 712, 72, 64},
    { 712, 16, 144},
    { 824, -24, 56},
    { 1008, 72, 0},
    { 1280, -24, 136},
    { 1920, 112, 184},
    { 1224, 456, -184},
    { 1032, 360, -64},
    { 976, 320, -8},
    { 696, 112, 120},
    { 664, 144, 104},
    // 9 seconds
    { 664, 248, 96},
    { 744, 328, 56},
    { 752, 368, 40},
    { 888, 416, -64},
    { 1088, 440, -56},
    { 1176, 392, -112},
    { 1384, 320, 72},
    { 1984, 448, 96},
    { 1064, 408, 24},
    { 928, 304, 0},
    { 1112, 216, 168},
    { 1024, 152, 216},
    { 872, 176, 144},
    { 760, 136, 136},
    { 712, 88, 88},
    { 712, 40, 104},
    { 712, 48, 88},
    { 800, 24, 96},
    { 1000, 56, 32},
    { 1088, 72, -8},
    { 1800, 8, 224},
    { 1456, 248, 88},
    { 1096, 432, -200},
    { 1056, 280, -56},
    { 776, 232, 88},
    // 10 seconds
    { 728, 160, 16},
    { 696, 192, 80},
    { 760, 320, 48},
    { 744, 448, -64},
    { 864, 424, -56},
    { 936, 392, -104},
    { 1120, 304, -80},
    { 1168, 272, -56},
    { 1784, 240, 104},
    { 1496, 360, 64},
    { 968, 344, 0},
    { 968, 248, 96},
    { 1064, 176, 184},
    { 864, 160, 184},
    { 760, 160, 88},
    { 736, 128, 88},
    { 728, 104, 80},
    { 728, 88, 48},
    { 752, 40, 96},
    { 864, 48, 56},
    { 1096, 112, -16},
    { 1248, 8, 88},
    { 1752, 0, 192},
    { 1144, 248, -80},
    { 1024, 272, -56},
    // 11 seconds
    { 1056, 232, -40},
    { 696, 224, 88},
    { 640, 160, 128},
    { 752, 288, 112},
    { 760, 320, 120},
    { 680, 328, 24},
    { 880, 272, -72},
    { 1152, 248, -8},
    { 1248, 480, -88},
    { 1384, 368, 152},
    { 1800, 472, 96},
    { 1048, 480, 104},
    { 976, 304, 88},
    { 1064, 232, 200},
    { 1064, 176, 248},
    { 848, 168, 152},
    { 736, 56, 136},
    { 744, 136, 32},
    { 752, 72, 88},
    { 736, 24, -24},
    { 736, 88, 0},
    { 960, 56, 208},
    { 1056, 16, -104},
    { 1576, -232, 160},
    { 1320, 48, 112},
    // 12 seconds
    { 1272, 240, -136},
    { 1216, 336, -144},
    { 792, 320, -64},
    { 648, 136, -104},
    { 728, 120, -8},
    { 808, 176, 128},
    { 896, 448, 80},
    { 840, 536, -32},
    { 904, 536, -80},
    { 1056, 376, -88},
    { 1184, 360, -88},
    { 1464, 368, 168},
    { 1784, 504, 144},
    { 1000, 392, 64},
    { 864, 296, 48},
    { 1112, 168, 184},
    { 1032, 112, 208},
    { 856, 160, 192},
    { 760, 136, 112},
    { 760, 88, 48},
    { 744, 24, 72},
    { 800, 16, 32},
    { 944, -32, 88},
    { 1104, 24, 24},
    { 1104, 48, -24},
    // 13 seconds
    { 1736, -72, 152},
    { 1256, 216, -64},
    { 1152, 304, -232},
    { 1088, 288, -144},
    { 680, 176, -8},
    { 648, 96, -16},
    { 704, 104, 88},
    { 776, 248, 16},
    { 864, 312, 40},
    { 896, 392, -72},
    { 944, 384, -128},
    { 1200, 440, -208},
    { 1208, 280, -88},
    { 1960, 240, -16},
    { 1400, 376, 16},
    { 968, 384, -64},
    { 960, 384, 16},
    { 1088, 232, 136},
    { 920, 112, 184},
    { 784, 112, 112},
    { 736, 104, 88},
    { 776, 88, 88},
    { 776, 56, 72},
    { 832, 0, 136},
    { 960, -32, 80},
    // 14 seconds
    { 1024, 96, -72},
    { 1264, -152, 152},
    { 1512, 40, 96},
    { 1296, 312, -176},
    { 1208, 368, -224},
    { 920, 368, -32},
    { 752, 200, 0},
    { 768, 224, 72},
    { 776, 256, 96},
    { 808, 296, 168},
    { 808, 384, 48},
    { 816, 248, -40},
    { 1056, 344, -160},
    { 1264, 360, -152},
    { 1320, 264, -16},
    { 1688, 376, 48},
    { 1256, 480, 24},
    { 1016, 336, 40},
    { 1200, 184, 176},
    { 992, 160, 216},
    { 784, 176, 168},
    { 752, 128, 128},
    { 792, 64, 200},
    { 760, 32, 128},
    { 744, 0, 120},
    // 15 seconds
    { 840, 8, 128},
    { 1040, -8, 56},
    { 1120, 24, -8},
    { 1760, -104, 232},
    { 1208, 240, -16},
    { 1128, 352, -144},
    { 1144, 384, -184},
    { 864, 112, 0},
    { 400, 360, -88},
    { 768, 160, -16},
    { 824, 240, 56},
    { 792, 304, -64},
    { 856, 248, -24},
    { 984, 352, -144},
    { 1144, 360, -160},
    { 1304, 336, -160},
    { 1712, 256, 8},
    { 1560, 448, -136},
    { 1056, 184, 72},
    { 1168, 168, 144},
    { 1120, 160, 208},
    { 944, 152, 216},
    { 784, 104, 160},
    { 680, 56, 136},
    { 664, 40, 88},
    // 16 seconds
    { 680, 32, 40},
    { 680, 8, 24},
    { 824, -72, 64},
    { 1080, 0, 40},
    { 1176, -56, 72},
    { 1824, 40, 168},
    { 1400, 360, -128},
    { 1208, 360, -176},
    { 1040, 352, -8},
    { 720, 160, 32},
    { 720, 112, 56},
    { 728, 152, 80},
    { 776, 288, -8},
    { 752, 288, 40},
    { 792, 392, -56},
    { 928, 496, -128},
    { 1344, 448, -232},
    { 1368, 200, -96},
    { 2000, 304, -40},
    { 1464, 424, -56},
    { 1024, 312, -32},
    { 1152, 56, 200},
    { 1072, 0, 216},
    { 800, 40, 192},
    { 736, 136, 104},
    // 17 seconds
    { 720, 56, 112},
    { 672, 32, 72},
    { 656, 0, 64},
    { 672, 80, -8},
    { 760, -72, 40},
    { 1200, 120, -88},
    { 1352, -104, 48},
    { 1936, 64, 128},
    { 1352, 432, -240},
    { 1304, 456, -200},
    { 880, 392, -24},
    { 696, 72, 32},
    { 728, 104, 64},
    { 696, 192, 104},
    { 768, 376, -16},
    { 760, 320, 8},
    { 840, 400, -96},
    { 1000, 312, -72},
    { 1216, 280, -96},
    { 1280, 320, -24},
    { 1848, 456, 0},
    { 1296, 456, -40},
    { 1056, 328, 72},
    { 1328, 112, -136},
    { 1248, -520, 16},
    // 18 seconds
    { 840, 296, 224},
    { 824, 272, 192},
    { 808, 152, 184},
    { 728, -72, 208},
    { 640, -24, 64},
    { 656, -48, 96},
    { 848, -32, 0},
    { 1048, 72, -40},
    { 1504, -192, 208},
    { 1776, 112, 184},
    { 1488, 432, -192},
    { 1288, 480, -160},
    { 808, 392, 32},
    { 696, 144, 40},
    { 736, 144, 56},
    { 784, 184, 160},
    { 816, 344, 0},
    { 760, 320, 72},
    { 904, 456, -128},
    { 1016, 376, -72},
    { 1384, 472, -160},
    { 1528, 272, 48},
    { 1624, 400, 8},
    { 1152, 400, -48},
    { 1072, 264, 64},
    // 19 seconds
    { 1232, 192, 120},
    { 1024, 152, 224},
    { 872, 176, 128},
    { 760, 88, 144},
    { 720, 80, 112},
    { 736, 72, 64},
    { 704, 8, 96},
    { 776, -56, 128},
    { 1024, 24, 8},
    { 1064, 48, -24},
    { 1712, -120, 184},
    { 1432, 176, 16},
    { 1328, 392, -232},
    { 1024, 320, -72},
    { 776, 144, 48},
    { 736, 272, 72},
    { 824, 200, 96},
    { 840, 304, 112},
    { 832, 336, 16},
    { 808, 352, -32},
    { 944, 464, -168},
    { 1160, 464, -192},
    { 1216, 376, -136},
    { 1904, 376, 16},
    { 1464, 464, 24},
    // 20 seconds
    { 1040, 280, 16},
    { 1128, 232, 128},
    { 1104, 168, 200},
    { 880, 128, 168},
    { 776, 136, 144},
    { 768, 56, 144},
    { 712, 48, 32},
    { 704, 8, 64},
    { 784, -16, 80},
    { 856, -72, 64},
    { 1104, 40, 16},
    { 1320, -88, 40},
    { 1704, -40, 184},
    { 1392, 344, -96},
    { 1256, 440, -280},
    { 912, 304, -64},
    { 640, 56, 72},
    { 712, 128, 96},
    { 792, 184, 176},
    { 896, 344, 56},
    { 808, 336, 120},
    { 816, 368, -16},
    { 968, 336, 40},
    { 1280, 496, -144},
    { 1176, 376, -80},
    // 21 seconds
    { 1824, 360, -88},
    { 1448, 472, -152},
    { 1024, 256, -8},
    { 1176, 272, 96},
    { 1072, 456, 328},
    { 968, 160, 120},
    { 872, 40, 192},
    { 800, 80, 112},
    { 776, 8, 88},
    { 752, 32, 56},
    { 712, -8, 16},
    { 888, -56, 64},
    { 968, 48, -104},
    { 1416, -192, 80},
    { 1632, 8, 128},
    { 1328, 336, -216},
    { 1176, 376, -248},
    { 960, 376, 0},
    { 800, 112, 56},
    { 792, 224, 104},
    { 872, 304, 104},
    { 880, 416, 8},
    { 808, 424, -48},
    { 896, 472, -144},
    { 1032, 448, -184},
    // 22 seconds
    { 1168, 384, -144},
    { 1552, 336, 0},
    { 1720, 408, 48},
    { 1064, 384, -24},
    { 992, 288, 16},
    { 1320, 80, 8},
    { 1032, 96, 232},
    { 880, 168, 152},
    { 784, 160, 56},
    { 744, 104, 32},
    { 736, 48, 56},
    { 712, 56, -72},
    { 808, -64, 136},
    { 992, 16, -8},
    { 1064, 48, -16},
    { 1800, -160, 192},
    { 1296, 256, -40},
    { 1264, 352, -200},
    { 1232, 360, -24},
    { 808, 280, 48},
    { 736, 208, 96},
    { 736, 232, 128},
    { 768, 288, 176},
    { 776, 528, -40},
    { 736, 504, -80},
    // 23 seconds
    { 880, 592, -192},
    { 1056, 536, -200},
    { 1224, 624, -128},
    { 1992, 544, 8},
    { 1496, 520, -48},
    { 1096, 400, -16},
    { 1328, 304, 80},
    { 1248, 184, 232},
    { 928, 152, 216},
    { 848, 192, 120},
    { 720, 88, 160},
    { 656, 24, 120},
    { 640, 32, 88},
    { 616, 8, 32},
    { 616, -48, 80},
    { 904, -48, -56},
    { 1160, -16, 144},
    { 2072, 40, 280},
    { 1704, 520, -152},
    { 1448, 712, -360},
    { 984, 512, -64},
    { 744, -16, 96},
    { 816, 80, 96},
    { 664, 184, 64},
    { 688, 280, 136},
    // 24 seconds
    { 784, 392, 8},
    { 792, 392, 48},
    { 920, 512, -120},
    { 1168, 464, -152},
    { 1312, 424, -128},
    { 1928, 288, 24},
    { 1496, 392, 8},
    { 952, 352, 16},
    { 1064, 280, 96},
    { 1176, 136, 216},
    { 936, 160, 224},
    { 808, 176, 160},
    { 728, 80, 152},
    { 696, 80, 96},
    { 688, 48, 96},
    { 728, 16, 88},
    { 912, -24, 48},
    { 1056, 64, -16},
    { 1376, -144, 216},
    { 1896, 0, 360},
    { 1304, 560, -208},
    { 960, 496, -216},
    { 896, 192, 96},
    { 768, 120, 72},
    { 816, 272, 112},
    // 25 seconds
    { 856, 344, 40},
    { 808, 328, 96},
    { 792, 464, -80},
    { 816, 384, -40},
    { 1024, 392, -128},
    { 1192, 264, -104},
    { 1344, 296, 64},
    { 2184, 496, 32},
    { 1120, 480, 32},
    { 1120, 360, 32},
    { 1152, 216, 176},
    { 1000, 88, 256},
    { 912, 136, 192},
    { 768, 88, 184},
    { 688, 56, 160},
    { 720, 32, 136},
    { 752, 8, 88},
    { 792, -48, 88},
    { 880, -56, 48},
    { 1024, 16, -24},
    { 1720, -120, 248},
    { 1768, 296, 144},
    { 1128, 648, -392},
    { 992, 360, -104},
    { 904, 120, 80},
    // 26 seconds
    { 744, 24, 40},
    { 840, 168, 80},
    { 888, 328, -80},
    { 784, 320, -24},
    { 872, 392, -184},
    { 1032, 336, -168},
    { 1128, 280, -240},
    { 1240, 256, -200},
    { 1880, 240, -40},
    { 1616, 248, 16},
    { 1136, 256, -8},
    { 1088, 184, -24},
    { 1040, 96, 200},
    { 968, 120, 152},
    { 808, 96, 104},
    { 720, 96, 136},
    { 696, 72, 80},
    { 720, 24, 40},
    { 664, -40, 72},
    { 808, -96, 112},
    { 992, 0, 64},
    { 1096, 24, -24},
    { 1728, -104, 216},
    { 1528, 360, -64},
    { 1384, 408, -152},
    // 27 seconds
    { 1016, 336, -32},
    { 736, 56, 56},
    { 640, 128, 64},
    { 720, 128, 88},
    { 872, 232, 120},
    { 824, 392, 64},
    { 832, 432, 40},
    { 960, 560, -120},
    { 1208, 432, -176},
    { 1304, 240, 0},
    { 1952, 200, 88},
    { 1440, 328, 24},
    { 1192, 248, 88},
    { 1128, 168, 152},
    { 1024, 168, 168},
    { 840, 144, 160},
    { 680, 96, 136},
    { 624, 8, 136},
    { 600, -8, 128},
    { 640, 48, 40},
    { 704, -104, 232},
    { 960, 96, 96},
    { 1080, 80, 0},
    { 1456, -192, 208},
    { 1904, 24, 192},
    // 28 seconds
    { 1416, 464, -200},
    { 1000, 424, -336},
    { 864, 224, -32},
    { 744, 104, 104},
    { 768, 216, 112},
    { 728, 272, 96},
    { 808, 256, 80},
    { 800, 368, -56},
    { 864, 384, -88},
    { 1032, 360, -160},
    { 1128, 240, -96},
    { 1536, 152, 240},
    { 2016, 336, 216},
    { 960, 464, 48},
    { 992, 288, 80},
    { 1096, 104, 264},
    { 976, 104, 200},
    { 832, 136, 104},
    { 776, 80, 88},
    { 736, 64, 72},
    { 752, 0, 104},
    { 704, -32, 88},
    { 752, -80, 112},
    { 976, -16, 56},
    { 1096, 56, -40},
    // 29 seconds
    { 1848, -128, 224},
    { 1384, 240, 64},
    { 1360, 496, -168},
    { 1032, 304, -32},
    { 736, 64, 48},
    { 728, 24, 40},
    { 720, 152, 32},
    { 848, 224, 72},
    { 784, 328, 16},
    { 808, 400, -96},
    { 984, 440, -168},
    { 1152, 328, -120},
    { 1264, 224, -56},
    { 1656, 224, 120},
    { 1728, 384, 104},
    { 944, 352, 32},
    { 1024, 312, 56},
    { 1104, -152, 168},
    { 944, 136, 216},
    { 808, 144, 128},
    { 776, 160, 72},
    { 760, 112, 120},
    { 784, 56, 72},
    { 744, -16, 96},
    { 824, -32, 72},
    // 30 seconds
    { 1008, 0, 16},
    { 1064, -56, 64},
    { 1808, -64, 256},
    { 1672, 272, 40},
    { 1144, 640, -376},
    { 696, 200, 56},
    { 888, 0, 176},
    { 712, 120, 136},
    { 752, 168, 200},
    { 792, 352, 112},
    { 768, 376, 96},
    { 848, 352, 0},
    { 936, 280, -56},
    { 1192, 352, -184},
    { 1280, 328, -96},
    { 1832, 264, -8},
    { 1472, 344, 56},
    { 800, 416, -8},
    { 1064, 312, 104},
    { 1152, 216, 184},
    { 952, 160, 264},
    { 792, 128, 184},
    { 832, 168, 144},
    { 808, 40, 216},
    { 752, 40, 120},
    // 31 seconds
    { 728, 24, 128},
    { 800, -56, 120},
    { 1040, 24, -16},
    { 1176, -120, 104},
    { 1952, -16, 288},
    { 1216, 360, -112},
    { 1128, 480, -320},
    { 1064, 256, 64},
    { 792, 144, 128},
    { 760, 176, 72},
    { 800, 208, 184},
    { 824, 408, 32},
    { 776, 320, 80},
    { 856, 408, -72},
    { 944, 344, -64},
    { 1200, 432, -144},
    { 1256, 352, 16},
    { 1936, 472, 8},
    { 1296, 432, -40},
    { 1008, 304, 48},
    { 1112, 216, 192},
    { 1224, 152, 264},
    { 952, 128, 264},
    { 816, 136, 176},
    { 784, 96, 144},
    // 32 seconds
    { 752, 24, 184},
    { 712, 24, 104},
    { 768, -48, 144},
    { 936, -24, 72},
    { 968, 32, -32},
    { 1384, -136, 88},
    { 1552, -40, 176},
    { 1472, 360, -176},
    { 1248, 368, -184},
    { 888, 264, 64},
    { 736, 136, 80},
    { 824, 160, 160},
    { 800, 280, 152},
    { 840, 408, 104},
    { 832, 416, -24},
    { 912, 424, -120},
    { 1016, 424, -184},
    { 1208, 344, -208},
    { 1320, 200, -8},
    { 1808, 216, 48},
    { 1192, 360, 32},
    { 992, 320, 32},
    { 1160, 168, 144},
    { 1080, 72, 200},
    { 896, 96, 144},
    // 33 seconds
    { 768, 56, 96},
    { 744, 96, 8},
    { 688, 0, 16},
    { 736, -32, 48},
    { 952, -80, -8},
    { 984, 32, -72},
    { 1128, -144, 16},
    { 1496, -176, 248},
    { 1368, 256, -80},
    { 1200, 448, -224},
    { 936, 392, -224},
    { 728, -96, 48},
    { 704, 152, 24},
    { 712, 224, -64},
    { 776, 288, -24},
    { 792, 272, -40},
    { 872, 304, -136},
    { 968, 304, -184},
    { 1176, 216, -192},
    { 1240, 160, -80},
    { 1896, 248, 0},
    { 1400, 376, -80},
    { 872, 312, -24},
    { 1080, 216, -8},
    { 1104, 32, 80},
    // 34 seconds
    { 816, 32, 40},
    { 824, 112, -8},
    { 720, 56, -8},
    { 768, -32, 16},
    { 752, -24, -16},
    { 872, -64, 16},
    { 1024, -96, 24},
    { 1008, -32, -56},
    { 1672, -208, 96},
    { 1360, 32, 16},
    { 1248, 216, -112},
    { 1088, 288, -272},
    { 808, 152, -48},
    { 680, 120, 0},
    { 712, 232, -56},
    { 792, 264, -24},
    { 840, 272, -32},
    { 872, 296, -144},
    { 952, 312, -192},
    { 1200, 344, -192},
    { 1248, 272, -184},
    { 1704, 248, -64},
    { 1584, 368, -40},
    { 1000, 336, -16},
    { 1056, 232, 40},
    // 35 seconds
    { 1160, 104, 136},
    { 984, 80, 112},
    { 824, 88, 16},
    { 728, 72, 8},
    { 688, 64, -40},
    { 680, -24, -32},
    { 768, -88, 8},
    { 912, -104, -8},
    { 968, -56, -48},
    { 1112, -56, -32},
    { 1608, -96, 128},
    { 1544, 192, 80},
    { 1328, 368, -160},
    { 912, 512, -136},
    { 648, 64, 112},
    { 736, 280, 8},
    { 768, 384, -8},
    { 816, 552, -160},
    { 880, 472, -256},
    { 1040, 368, -232},
    { 1120, 256, -136},
    { 1160, 240, -48},
    { 1448, 232, 112},
    { 1576, 288, 120},
    { 1192, 312, 120},
    // 36 seconds
    { 1096, 248, 96},
    { 1080, 128, 136},
    { 880, 144, 64},
    { 744, 120, 24},
    { 640, 56, -8},
    { 640, 104, 48},
    { 712, 16, -24},
    { 744, 24, -32},
    { 944, -64, 16},
    { 1072, 0, -24},
    { 1208, -56, 64},
    { 1680, -8, 96},
    { 1344, 336, -72},
    { 1224, 368, -120},
    { 920, 408, -24},
    { 680, 136, 48},
    { 736, 184, 32},
    { 736, 232, -56},
    { 832, 288, -40},
    { 784, 328, -96},
    { 864, 360, -144},
    { 1040, 320, -160},
    { 1216, 240, -96},
    { 1440, 232, 48},
    { 1768, 376, 16},
    // 37 seconds
    { 1048, 408, -8},
    { 1032, 304, 8},
    { 1200, 240, 104},
    { 960, 168, 88},
    { 728, 120, 64},
    { 680, 112, 16},
    { 744, 40, 72},
    { 752, 16, 24},
    { 792, 8, 0},
    { 872, -72, 80},
    { 1080, -8, 24},
    { 1120, -8, 40},
    { 1696, 8, 120},
    { 1328, 288, -104},
    { 1152, 368, -216},
    { 1024, 256, -56},
    { 752, 128, 40},
    { 720, 248, -80},
    { 752, 208, 0},
    { 824, 304, -72},
    { 768, 264, -64},
    { 824, 368, -176},
    { 936, 312, -192},
    { 1176, 264, -176},
    { 1264, 200, -88},
    // 38 seconds
    { 1816, 232, 40},
    { 1456, 368, -48},
    { 792, 344, -32},
    { 1056, 240, 8},
    { 1024, 88, 104},
    { 816, 120, 72},
    { 744, 120, 24},
    { 696, 104, 32},
    { 704, 88, 16},
    { 720, 32, 8},
    { 800, 16, 16},
    { 1128, 40, 16},
    { 1040, -88, 104},
    { 1704, -56, 192},
    { 1448, 192, 48},
    { 1264, 296, -160},
    { 904, 280, -152},
    { 696, 144, -56},
    { 640, 192, -8},
    { 672, 168, 16},
    { 720, 160, 56},
    { 752, 224, -16},
    { 800, 296, -96},
    { 920, 320, -160},
    { 1128, 264, -152},
    // 39 seconds
    { 1248, 208, -128},
    { 1744, 96, 0},
    { 1840, 240, 40},
    { 928, 312, -40},
    { 768, 320, -56},
    { 920, 120, 32},
    { 904, 56, 64},
    { 720, 48, 24},
    { 704, 64, 16},
    { 688, 48, 24},
    { 696, 16, 40},
    { 864, -8, 24},
    { 1000, -64, 64},
    { 1152, 8, 16},
    { 1288, -64, 24},
    { 1656, -112, 120},
    { 1104, 240, -136},
    { 1016, 280, -256},
    { 904, 200, -104},
    { 648, 48, -32},
    { 688, 128, -8},
    { 704, 128, -16},
    { 784, 200, -56},
    { 808, 184, -96},
    { 920, 224, -168},
    // 40 seconds
    { 1088, 208, -192},
    { 1192, 184, -192},
    { 1400, 72, -8},
    { 1632, 168, 24},
    { 1232, 312, 48},
    { 944, 288, 32},
    { 1096, 160, 104},
    { 928, 64, 136},
    { 768, 96, 40},
    { 680, 80, 16},
    { 664, 48, -16},
    { 664, -24, 0},
    { 728, 16, 40},
    { 936, -8, 32},
    { 1056, -24, 16},
    { 1048, 64, -88},
    { 1816, -80, 40},
    { 1352, 184, -8},
    { 1264, 296, -240},
    { 944, 368, -168},
    { 656, 96, -8},
    { 664, 144, -56},
    { 664, 120, 24},
    { 744, 224, -56},
    { 776, 264, -32},
    // 41 seconds
    { 856, 272, -128},
    { 1016, 264, -144},
    { 1120, 264, -208},
    { 1296, 152, -8},
    { 1792, 232, 48},
    { 1296, 336, -16},
    { 984, 296, -56},
    { 1072, 200, 16},
    { 1032, 144, 80},
    { 784, 128, 24},
    { 696, 136, -16},
    { 712, 112, -16},
    { 688, 24, 16},
    { 744, 0, 72},
    { 912, -16, 56},
    { 1096, -40, 32},
    { 1104, -24, 16},
    { 1552, -104, 56},
    { 1224, 136, -16},
    { 1064, 352, -152},
    { 1256, 136, -120},
    { 816, 120, 48},
    { 632, 56, -40},
    { 720, 160, -80},
    { 784, 248, 24},
    // 42 seconds
    { 816, 304, -16},
    { 888, 280, -56},
    { 928, 320, -120},
    { 1120, 280, -120},
    { 1176, 288, -88},
    { 1600, 232, 72},
    { 1480, 336, 56},
    { 1064, 352, 16},
    { 1016, 272, 64},
    { 1064, 128, 128},
    { 888, 96, 152},
    { 736, 120, 72},
    { 720, 128, 56},
    { 744, 56, 40},
    { 816, 16, 32},
    { 880, 0, 0},
    { 1024, -112, 64},
    { 1160, -80, -8},
    { 1408, -192, 64},
    { 1392, -32, 8},
    { 1000, 256, -160},
    { 1112, 264, -224},
    { 936, 176, -56},
    { 712, 80, 8},
    { 736, 248, -16},
    // 43 seconds
    { 784, 272, -8},
    { 808, 304, -16},
    { 856, 344, -96},
    { 880, 352, -184},
    { 1056, 296, -176},
    { 1200, 232, -96},
    { 1696, 224, 48},
    { 1672, 288, 8},
    { 960, 240, 16},
    { 1096, 208, 8},
    { 1160, 88, 128},
    { 944, 48, 128},
    { 816, 88, 48},
    { 744, 48, 40},
    { 712, -40, -8},
    { 720, -152, -24},
    { 776, -160, 72},
    { 1008, -64, 32},
    { 1112, 16, -8},
    { 1544, -184, 56},
    { 1744, 72, 112},
    { 1264, 328, -136},
    { 992, 400, -160},
    { 824, 240, 8},
    { 704, 40, 64},
    // 44 seconds
    { 672, 32, 64},
    { 728, 168, 24},
    { 768, 256, 56},
    { 768, 280, 8},
    { 896, 280, -56},
    { 1136, 368, -120},
    { 1272, 312, -136},
    { 1880, 200, 72},
    { 1816, 312, 8},
    { 1048, 368, 0},
    { 944, 232, 56},
    { 1080, 184, 136},
    { 960, 72, 232},
    { 784, 56, 200},
    { 752, 88, 96},
    { 720, 40, 136},
    { 696, 16, 104},
    { 712, -48, 104},
    { 880, -64, 88},
    { 1032, 16, 32},
    { 1040, 8, -32},
    { 1728, -88, 192},
    { 1400, 336, -176},
    { 1408, 384, -256},
    { 1096, 272, -168},
    // 45 seconds
    { 728, 104, 40},
    { 704, 144, 32},
    { 696, 152, 48},
    { 784, 152, 56},
    { 792, 216, 56},
    { 864, 328, -88},
    { 952, 320, -48},
    { 1216, 408, -144},
    { 1272, 208, 48},
    { 1872, 232, 96},
    { 1240, 352, 32},
    { 968, 256, 40},
    { 1088, 152, 144},
    { 1104, 80, 168},
    { 896, 48, 184},
    { 784, 56, 96},
    { 784, 80, 64},
    { 760, -8, 96},
    { 760, -32, 24},
    { 880, -88, 96},
    { 992, -104, 64},
    { 1008, -40, -8},
    { 1600, -192, 192},
    { 1424, 112, 88},
    { 1320, 304, -128},
    // 46 seconds
    { 1112, 272, -48},
    { 752, 168, 128},
    { 736, 136, 16},
    { 776, 104, 152},
    { 864, 272, 72},
    { 840, 352, 56},
    { 864, 360, -56},
    { 944, 336, -96},
    { 1192, 336, -144},
    { 1248, 240, 8},
    { 1880, 304, 64},
    { 1328, 408, -8},
    { 968, 272, 80},
    { 1120, 184, 168},
    { 1088, 152, 192},
    { 840, 120, 128},
    { 752, 80, 120},
    { 776, 80, 64},
    { 800, 24, 80},
    { 808, 0, 72},
    { 936, -40, 104},
    { 1008, -72, 88},
    { 1040, 24, 32},
    { 1616, -112, 128},
    { 1344, 128, -72},
    // 47 seconds
    { 1032, 296, -208},
    { 1160, 8, 0},
    { 888, 128, 48},
    { 736, 128, 56},
    { 792, 200, 80},
    { 824, 280, 88},
    { 840, 296, 120},
    { 896, 344, 8},
    { 1000, 432, -88},
    { 1104, 384, -144},
    { 1200, 272, -112},
    { 1776, 256, 16},
    { 1520, 360, 16},
    { 992, 312, -8},
    { 1064, 208, 104},
    { 1144, 120, 192},
    { 912, 152, 144},
    { 816, 96, 136},
    { 776, 88, 160},
    { 744, 40, 128},
    { 728, -16, 152},
    { 864, -8, 152},
    { 984, -64, 88},
    { 1104, -56, 40},
    { 1352, -144, 56},
    // 48 seconds
    { 1320, -32, 40},
    { 1096, 200, -128},
    { 1272, 296, -240},
    { 1088, 328, 24},
    { 720, 248, -8},
    { 752, 192, 40},
    { 776, 200, 88},
    { 784, 264, 32},
    { 824, 304, -16},
    { 992, 352, -56},
    { 1032, 376, -120},
    { 1216, 344, -88},
    { 1576, 232, 80},
    { 1672, 320, 72},
    { 1024, 328, 0},
    { 976, 272, 48},
    { 1144, 168, 152},
    { 928, 112, 200},
    { 768, 104, 136},
    { 736, 104, 120},
    { 720, 56, 120},
    { 744, 8, 128},
    { 848, -16, 112},
    { 968, -48, 160},
    { 1056, -104, 120},
    // 49 seconds
    { 1136, -16, 56},
    { 1664, -96, 160},
    { 1256, 224, -24},
    { 1096, 224, -248},
    { 936, 256, -120},
    { 736, 88, 32},
    { 720, 184, 32},
    { 768, 184, 88},
    { 832, 256, 56},
    { 848, 280, 0},
    { 896, 320, -96},
    { 944, 352, -112},
    { 1200, 312, -120},
    { 1312, 192, 104},
    { 1936, 304, 96},
    { 1200, 360, 48},
    { 936, 264, 8},
    { 1040, 168, 128},
    { 1048, 104, 184},
    { 872, 80, 144},
    { 768, 72, 120},
    { 728, 72, 72},
    { 728, 8, 80},
    { 768, -24, 80},
    { 880, -32, 72},
    // 50 seconds
    { 1032, -48, 48},
    { 1056, -24, 0},
    { 1712, -152, 160},
    { 1456, 144, 48},
    { 1088, 304, -216},
    { 1064, 128, -96},
    { 784, 128, 112},
    { 680, 168, 64},
    { 744, 208, 80},
    { 824, 232, 48},
    { 800, 216, 64},
    { 856, 328, -48},
    { 976, 368, -120},
    { 1168, 328, -144},
    { 1232, 208, -24},
    { 1816, 152, 104},
    { 1456, 312, 64},
    { 952, 336, 8},
    { 952, 280, 48},
    { 1056, 200, 104},
    { 896, 176, 112},
    { 736, 88, 96},
    { 712, 96, 72},
    { 776, 56, 88},
    { 800, 8, 96},
    // 51 seconds
    { 904, -8, 112},
    { 1032, -32, 72},
    { 1024, 0, 64},
    { 1560, -184, 152},
    { 1528, 72, 136},
    { 912, 360, -200},
    { 1064, 16, -104},
    { 936, 152, 40},
    { 648, 144, 8},
    { 680, 152, 56},
    { 792, 256, 24},
    { 784, 256, 40},
    { 872, 288, -8},
    { 968, 376, -96},
    { 1088, 304, -96},
    { 1176, 288, -80},
    { 1632, 240, 64},
    { 1560, 368, 48},
    { 1016, 360, 64},
    { 1096, 272, 120},
    { 1144, 208, 176},
    { 912, 120, 200},
    { 792, 144, 112},
    { 768, 120, 56},
    { 744, 48, 40},
    // 52 seconds
    { 712, -16, 56},
    { 752, -56, 88},
    { 936, -40, 80},
    { 1080, 0, 32},
    { 1248, -120, 112},
    { 1688, -80, 192},
    { 1392, 216, -48},
    { 1152, 296, -240},
    { 856, 184, -16},
    { 632, 104, 40},
    { 696, 128, 72},
    { 744, 168, 152},
    { 832, 256, 112},
    { 840, 296, 72},
    { 920, 376, -96},
    { 984, 360, -96},
    { 1192, 344, -112},
    { 1392, 216, 112},
    { 1736, 352, 88},
    { 1112, 400, 8},
    { 1032, 328, 40},
    { 1112, 216, 160},
    { 1040, 160, 184},
    { 816, 112, 160},
    { 768, 128, 96},
    // 53 seconds
    { 776, 72, 96},
    { 736, 16, 104},
    { 776, 8, 88},
    { 832, -24, 88},
    { 1024, -24, 40},
    { 1048, 0, -16},
    { 1728, -168, 168},
    { 1424, 104, 88},
    { 1224, 288, -184},
    { 1016, 184, -120},
    { 816, 168, 64},
    { 696, 152, 48},
    { 744, 216, 144},
    { 792, 256, 120},
    { 792, 288, 104},
    { 808, 360, -8},
    { 944, 376, -112},
    { 1128, 320, -144},
    { 1224, 256, -112},
    { 1744, 208, 56},
    { 1520, 360, 8},
    { 1048, 304, 24},
    { 968, 216, 88},
    { 1080, 192, 136},
    { 872, 136, 152},
    // 54 seconds
    { 776, 144, 96},
    { 744, 88, 136},
    { 760, 48, 120},
    { 760, 24, 112},
    { 872, 0, 56},
    { 800, -184, 32},
    { 1048, 200, 112},
    { 1240, -144, 104},
    { 1744, -8, 144},
    { 1200, 328, -120},
    { 1064, 336, -256},
    { 880, 240, 16},
    { 664, 184, 40},
    { 688, 216, 72},
    { 680, 200, 96},
    { 776, 256, 96},
    { 784, 272, 56},
    { 824, 328, -32},
    { 920, 400, -104},
    { 1160, 368, -72},
    { 1184, 328, -8},
    { 1880, 440, 64},
    { 1496, 512, 48},
    { 808, 360, 56},
    { 952, 256, 112},
    // 55 seconds
    { 1048, 200, 192},
    { 904, 184, 152},
    { 760, 104, 120},
    { 752, 120, 32},
    { 768, 40, 56},
    { 768, -8, 56},
    { 792, -32, 80},
    { 960, -32, 56},
    { 1016, 0, 24},
    { 1816, -88, 168},
    { 1536, 184, 16},
    { 1128, 368, -248},
    { 1056, 152, -40},
    { 720, 168, 136},
    { 712, 208, 80},
    { 712, 208, 112},
    { 696, 192, 104},
    { 744, 216, 112},
    { 808, 312, 24},
    { 912, 392, -72},
    { 1136, 352, -88},
    { 1248, 280, -40},
    { 1392, 168, 80},
    { 1520, 304, 48},
    { 1088, 440, 24},
    // 56 seconds
    { 952, 344, 72},
    { 1072, 176, 200},
    { 944, 168, 224},
    { 736, 184, 120},
    { 712, 152, 104},
    { 768, 104, 96},
    { 768, 40, 104},
    { 856, 32, 112},
    { 944, 0, 112},
    { 1104, 24, 24},
    { 1048, -32, 40},
    { 1640, -80, 192},
    { 1280, 224, 24},
    { 1120, 320, -144},
    { 944, 192, -120},
    { 616, 96, 40},
    { 648, 120, 24},
    { 736, 168, 104},
    { 848, 232, 88},
    { 864, 312, 40},
    { 896, 368, -48},
    { 952, 376, -88},
    { 1168, 352, -48},
    { 1168, 280, 64},
    { 1896, 376, 112},
    // 57 seconds
    { 1280, 432, 64},
    { 1024, 336, 40},
    { 1064, 216, 104},
    { 1056, 136, 168},
    { 856, 136, 120},
    { 752, 120, 80},
    { 736, 72, 80},
    { 736, 40, 88},
    { 720, 0, 88},
    { 784, 0, 80},
    { 960, -16, 56},
    { 1088, 24, 16},
    { 1688, -152, 160},
    { 1464, 120, 80},
    { 1280, 432, -224},
    { 1096, 192, -112},
    { 824, 160, 56},
    { 696, 168, 80},
    { 712, 256, 120},
    { 768, 280, 88},
    { 744, 224, 120},
    { 784, 328, 16},
    { 888, 392, -56},
    { 1040, 408, -120},
    { 1240, 312, -56},
    // 58 seconds
    { 1520, 320, 40},
    { 1824, 376, 56},
    { 920, 376, 0},
    { 1016, 232, 24},
    { 1120, 184, 152},
    { 840, 176, 80},
    { 792, 128, 72},
    { 744, 56, 104},
    { 752, 88, 24},
    { 744, 0, 72},
    { 800, -16, 80},
    { 952, -8, 48},
    { 1128, 64, -40},
    { 1168, -8, 8},
    { 1688, 8, 88},
    { 1512, 288, -144},
    { 1048, 360, -176},
    { 872, 112, 8},
    { 720, 128, 64},
    { 608, 184, 120},
    { 712, 176, 192},
    { 776, 256, 184},
    { 712, 360, 96},
    { 744, 408, -32},
    { 960, 376, -104},
    // 59 seconds
    { 1216, 392, -152},
    { 1272, 272, -104},
    { 1856, 264, -56},
    { 1504, 424, -96},
    { 952, 360, -104},
    { 1152, 168, 24},
    { 1072, 128, 88},
    { 904, 160, 0},
    { 832, 64, 32},
    { 768, 88, -40},
    { 632, 8, -16},
    { 544, 0, 8},
    { 632, 0, 8},
    { 944, 72, -8},
    { 1176, 112, -40},
    { 1648, -144, 224},
    { 1920, 88, 280},
    { 1440, 512, -104},
    { 968, 368, -88},
    { 784, 224, 64},
    { 576, 48, 96},
    { 624, 56, 152},
    { 696, 168, 192},
    { 720, 336, 112},
    { 744, 320, 56},
    // 60 seconds
    // elapsed: 1 minutes
    { 912, 352, -64},
    { 1328, 368, -72},
    { 1352, 288, -96},
    { 1536, 8, 200},
    { 1624, 472, -136},
    { 1056, 392, -56},
    { 1064, 160, 16},
    { 1184, 136, 224},
    { 944, 160, 168},
    { 888, 104, 88},
    { 824, 32, 144},
    { 744, 16, 96},
    { 752, -32, 120},
    { 840, -64, 120},
    { 1064, -56, 64},
    { 1320, 24, 104},
    { 1376, -104, 136},
    { 1304, 88, 80},
    { 1224, 232, 0},
    { 1120, 248, -120},
    { 832, 184, 32},
    { 680, 104, 48},
    { 808, 136, 56},
    { 816, 152, 272},
    { 960, 408, 32},
    // 61 seconds
    { 936, 352, 40},
    { 1152, 448, -104},
    { 1192, 328, -48},
    { 1144, 232, -16},
    { 1504, 280, 32},
    { 1232, 408, -16},
    { 1152, 240, 72},
    { 1104, 40, 208},
    { 1120, 24, 232},
    { 1096, 120, 184},
    { 912, 64, 176},
    { 768, 48, 80},
    { 704, 56, 40},
    { 680, 8, 48},
    { 720, -32, 16},
    { 784, -64, 48},
    { 976, -24, 16},
    { 1096, -8, -24},
    { 1632, -168, 192},
    { 1576, 168, 160},
    { 1328, 448, -104},
    { 1120, 408, -56},
    { 824, 296, 88},
    { 712, 136, 80},
    { 744, 192, 128},
    // 62 seconds
    { 864, 296, 24},
    { 760, 320, 16},
    { 760, 408, -144},
    { 960, 360, -176},
    { 1104, 336, -176},
    { 1216, 208, -80},
    { 1720, 224, 112},
    { 1488, 408, 32},
    { 1080, 296, 56},
    { 1120, 192, 128},
    { 1152, 120, 240},
    { 872, 120, 176},
    { 736, 152, 128},
    { 688, 208, 48},
    { 680, 96, 88},
    { 704, 64, 56},
    { 816, 16, 72},
    { 1024, -64, 128},
    { 1104, -24, 96},
    { 1336, -48, 72},
    { 1456, 168, 64},
    { 1152, 456, -208},
    { 1144, 216, -24},
    { 1144, 328, 24},
    { 744, 200, 72},
    // 63 seconds
    { 664, 136, 96},
    { 696, 192, 56},
    { 752, 208, 112},
    { 856, 272, 8},
    { 992, 272, -40},
    { 1096, 312, -112},
    { 1312, 400, -248},
    { 1344, 144, 64},
    { 1640, 304, 32},
    { 1160, 424, 64},
    { 976, 256, 112},
    { 1112, 128, 256},
    { 992, 144, 240},
    { 784, 136, 168},
    { 696, 112, 120},
    { 736, 80, 120},
    { 728, 32, 96},
    { 752, 56, 64},
    { 864, -56, 136},
    { 1104, 16, 24},
    { 1112, 16, 16},
    { 1656, -48, 176},
    { 1352, 240, -8},
    { 1232, 400, -184},
    { 1080, 176, -8},
    // 64 seconds
    { 712, 112, 96},
    { 640, 152, 24},
    { 696, 200, 72},
    { 832, 272, 88},
    { 872, 288, 80},
    { 888, 392, -48},
    { 992, 352, -96},
    { 1168, 344, -128},
    { 1240, 192, 40},
    { 2040, 312, 104},
    { 1216, 360, 88},
    { 968, 256, 16},
    { 984, 160, 136},
    { 1080, 88, 200},
    { 832, 144, 48},
    { 712, 64, 96},
    { 672, 104, 8},
    { 688, 24, 24},
    { 696, 72, 16},
    { 904, -64, 144},
    { 968, -32, 120},
    { 1088, -16, 0},
    { 1776, -240, 240},
    { 1552, 192, 96},
    { 1208, 400, -256},
    // 65 seconds
    { 1136, 304, -184},
    { 816, 224, -32},
    { 664, 200, -40},
    { 720, 192, -16},
    { 792, 256, 24},
    { 784, 296, 24},
    { 816, 392, -120},
    { 928, 336, -80},
    { 1096, 328, -88},
    { 1200, 256, 0},
    { 1872, 312, 128},
    { 1624, 400, 88},
    { 848, 304, 8},
    { 976, 224, 72},
    { 1176, 80, 176},
    { 920, 112, 184},
    { 832, 144, 80},
    { 744, 88, 40},
    { 688, 16, 104},
    { 696, 8, 32},
    { 688, -40, 56},
    { 880, -24, 24},
    { 1128, 64, -40},
    { 1160, -88, 160},
    { 1888, -16, 240},
    // 66 seconds
    { 1288, 352, 16},
    { 1208, 344, -112},
    { 992, 488, -72},
    { 664, 120, 16},
    { 656, 144, 48},
    { 768, 232, 32},
    { 808, 280, 8},
    { 816, 256, -8},
    { 872, 352, -144},
    { 1056, 320, -144},
    { 1248, 352, -216},
    { 1192, 136, 8},
    { 1808, 280, -16},
    { 1176, 376, 40},
    { 968, 280, 48},
    { 1152, 152, 216},
    { 1032, 144, 256},
    { 840, 176, 160},
    { 712, 152, 104},
    { 688, 120, 64},
    { 728, 48, 80},
    { 776, 48, 88},
    { 880, -32, 128},
    { 1136, -32, 96},
    { 1088, 32, -40},
    // 67 seconds
    { 1472, -104, 32},
    { 1424, 64, 32},
    { 992, 216, -160},
    { 1208, 192, -72},
    { 952, 328, 16},
    { 696, 200, 32},
    { 760, 248, 40},
    { 808, 296, 48},
    { 768, 304, 16},
    { 840, 312, -80},
    { 920, 376, -184},
    { 1136, 352, -168},
    { 1200, 296, -104},
    { 1632, 256, 24},
    { 1480, 328, 120},
    { 1024, 352, 88},
    { 1032, 352, 112},
    { 1024, 232, 256},
    { 960, 168, 192},
    { 800, 120, 160},
    { 736, 80, 88},
    { 704, 16, 104},
    { 760, 24, 48},
    { 800, -16, 72},
    { 888, -56, 80},
    // 68 seconds
    { 1016, 24, -32},
    { 1088, -120, 112},
    { 1744, -48, 208},
    { 1504, 280, 40},
    { 1232, 496, -208},
    { 896, 384, -24},
    { 656, 112, 80},
    { 704, 104, 128},
    { 744, 208, 120},
    { 832, 336, 64},
    { 824, 328, 32},
    { 904, 416, -96},
    { 1096, 392, -112},
    { 1160, 304, -96},
    { 1544, 304, 72},
    { 1584, 472, 56},
    { 968, 368, 48},
    { 1112, 288, 112},
    { 1256, 224, 224},
    { 1000, 152, 184},
    { 832, 128, 120},
    { 760, 128, 56},
    { 744, 64, 72},
    { 760, 0, 48},
    { 808, -16, 48},
    // 69 seconds
    { 888, -88, 96},
    { 1048, 8, 24},
    { 984, -8, 16},
    { 1592, -32, 200},
    { 1272, 208, 64},
    { 1304, 304, -64},
    { 1160, 368, -48},
    { 800, 272, 24},
    { 736, 200, 32},
    { 736, 224, 40},
    { 856, 272, 72},
    { 864, 368, -16},
    { 936, 400, -48},
    { 976, 440, -144},
    { 1136, 368, -136},
    { 1288, 272, 40},
    { 1752, 392, 72},
    { 1296, 384, 56},
    { 1048, 296, 56},
    { 1168, 200, 160},
    { 1088, 120, 176},
    { 928, 120, 120},
    { 784, 96, 88},
    { 728, 80, 56},
    { 704, 24, 88},
    // 70 seconds
    { 672, -16, 56},
    { 792, -8, 40},
    { 944, -40, 80},
    { 1040, 48, 8},
    { 1800, -168, 224},
    { 1560, 216, 80},
    { 1128, 544, -312},
    { 1088, 360, -128},
    { 832, 112, 32},
    { 688, 104, 32},
    { 744, 184, 72},
    { 824, 320, 40},
    { 816, 400, 32},
    { 840, 384, -24},
    { 944, 448, -136},
    { 1136, 304, -64},
    { 1264, 264, -24},
    { 1744, 320, 88},
    { 1416, 464, -8},
    { 888, 344, 40},
    { 1080, 208, 168},
    { 1192, 152, 256},
    { 912, 152, 176},
    { 752, 136, 144},
    { 728, 120, 104},
    // 71 seconds
    { 744, 48, 128},
    { 760, 0, 88},
    { 840, -24, 104},
    { 968, -48, 96},
    { 1080, -24, 32},
    { 1184, -120, 160},
    { 1600, -112, 256},
    { 1144, 328, -24},
    { 1088, 320, -208},
    { 1048, 216, 8},
    { 736, 152, 32},
    { 712, 264, 80},
    { 832, 248, 88},
    { 808, 304, -16},
    { 768, 376, -96},
    { 872, 384, -232},
    { 992, 360, -232},
    { 1272, 312, -184},
    { 1200, 200, -24},
    { 1872, 384, 0},
    { 1296, 416, -32},
    { 968, 264, -16},
    { 1160, 152, 168},
    { 1112, 104, 224},
    { 880, 128, 168},
    // 72 seconds
    { 752, 88, 136},
    { 704, 48, 88},
    { 688, -8, 32},
    { 720, -40, 24},
    { 776, -80, 24},
    { 968, -80, -16},
    { 1048, -32, -32},
    { 1784, -144, 88},
    { 1608, 256, -112},
    { 1248, 392, -352},
    { 992, 264, -248},
    { 840, 264, 80},
    { 768, 248, 40},
    { 824, 176, 48},
    { 840, 184, 88},
    { 752, 272, -160},
    { 784, 152, -32},
    { 912, 320, -272},
    { 1112, 232, -224},
    { 1176, 232, -208},
    { 1792, 120, -24},
    { 1488, 304, 40},
    { 1000, 304, 64},
    { 1112, 248, 128},
    { 1184, 192, 208},
    // 73 seconds
    { 944, 128, 160},
    { 776, 80, 80},
    { 760, 64, 40},
    { 776, 24, 24},
    { 784, -16, 8},
    { 752, -24, -24},
    { 872, -96, 24},
    { 984, 24, -72},
    { 1240, -216, -16},
    { 1696, 8, 176},
    { 1384, 304, -24},
    { 1160, 400, -280},
    { 984, 496, -24},
    { 736, 144, 40},
    { 792, 144, 48},
    { 824, 224, 40},
    { 824, 344, 8},
    { 776, 384, -96},
    { 880, 400, -144},
    { 1080, 376, -176},
    { 1176, 288, -136},
    { 1664, 288, -16},
    { 1632, 360, 72},
    { 1032, 328, 24},
    { 1096, 256, 56},
    // 74 seconds
    { 1248, 104, 120},
    { 1016, 112, 160},
    { 864, 120, 72},
    { 776, 72, 56},
    { 736, 32, 40},
    { 728, 0, 40},
    { 760, -32, 16},
    { 920, -64, 64},
    { 1032, 16, -24},
    { 984, -16, -72},
    { 1520, -24, 104},
    { 1312, 96, 104},
    { 1480, 304, -80},
    { 1080, 504, -184},
    { 672, 224, -32},
    { 760, 232, -40},
    { 776, 184, 40},
    { 872, 272, -48},
    { 824, 296, -104},
    { 832, 408, -280},
    { 1008, 408, -248},
    { 1264, 368, -208},
    { 1344, 208, 48},
    { 1736, 368, 64},
    { 1136, 368, 8},
    // 75 seconds
    { 1000, 264, 40},
    { 1168, 136, 192},
    { 1160, 80, 208},
    { 912, 112, 96},
    { 792, 88, 48},
    { 728, 96, -24},
    { 728, 0, 16},
    { 736, -24, -80},
    { 664, -40, 40},
    { 928, -104, -8},
    { 1048, 96, -120},
    { 1504, -392, 144},
    { 1768, 0, 232},
    { 1400, 432, -104},
    { 1328, 472, -24},
    { 824, 328, -8},
    { 592, 32, 104},
    { 680, 104, 80},
    { 696, 192, 8},
    { 792, 256, 16},
    { 792, 248, -56},
    { 1000, 296, -128},
    { 1144, 232, -128},
    { 1192, 216, -144},
    { 1664, 112, 8},
    // 76 seconds
    { 1600, 248, 32},
    { 1064, 240, -80},
    { 1040, 104, 56},
    { 1184, 80, 136},
    { 1048, 160, 88},
    { 856, 96, 88},
    { 736, 64, 32},
    { 696, -8, 40},
    { 704, -24, 64},
    { 744, -64, 32},
    { 808, -104, 80},
    { 1088, 8, 40},
    { 1072, 8, -32},
    { 1784, -64, 160},
    { 1400, 296, -96},
    { 1256, 408, -224},
    { 1120, 280, 8},
    { 704, 136, 32},
    { 712, 168, 24},
    { 712, 160, 96},
    { 760, 256, 80},
    { 808, 280, 32},
    { 800, 280, -16},
    { 912, 352, -120},
    { 1192, 312, -96},
    // 77 seconds
    { 1176, 248, -80},
    { 1416, 320, 80},
    { 1520, 488, -40},
    { 888, 384, 16},
    { 1072, 304, 80},
    { 1216, 224, 128},
    { 904, 160, 120},
    { 784, 144, 40},
    { 768, 104, 56},
    { 808, 32, 72},
    { 744, -16, 40},
    { 816, 0, 40},
    { 904, -72, 80},
    { 1096, 24, 40},
    { 1080, -48, 32},
    { 1584, -32, 192},
    { 1152, 272, -16},
    { 1272, 320, -152},
    { 1056, 360, -136},
    { 720, 120, 24},
    { 704, 224, -8},
    { 744, 256, 24},
    { 816, 312, 16},
    { 776, 296, 0},
    { 848, 368, -120},
    // 78 seconds
    { 968, 368, -120},
    { 1200, 360, -144},
    { 1208, 200, 8},
    { 1848, 344, 40},
    { 1384, 392, 0},
    { 872, 288, 16},
    { 1064, 192, 88},
    { 1080, 72, 184},
    { 888, 96, 152},
    { 824, 104, 64},
    { 744, 96, 8},
    { 664, 0, 24},
    { 656, -32, -8},
    { 736, -16, -16},
    { 928, -48, -40},
    { 1152, 88, -88},
    { 1288, -80, 72},
    { 1752, 8, 200},
    { 1448, 336, 48},
    { 1080, 440, -160},
    { 752, 368, -8},
    { 664, 88, 112},
    { 584, 152, 128},
    { 696, 184, 152},
    { 792, 280, 104},
    // 79 seconds
    { 776, 320, 40},
    { 832, 416, -112},
    { 1064, 368, -144},
    { 1168, 304, -184},
    { 1576, 200, 8},
    { 1840, 368, 0},
    { 976, 392, -64},
    { 1024, 312, -24},
    { 1208, 176, 136},
    { 1024, 128, 136},
    { 856, 128, 72},
    { 784, 136, 8},
    { 736, 48, 40},
    { 688, -24, 48},
    { 680, -40, 24},
    { 688, -56, 32},
    { 912, -24, 32},
    { 1072, 56, -72},
    { 1704, -128, 160},
    { 1880, 120, 224},
    { 1184, 616, -264},
    { 1072, 336, -64},
    { 952, 232, 64},
    { 656, 112, 72},
    { 712, 168, 112},
    // 80 seconds
    { 760, 304, 64},
    { 720, 336, 16},
    { 728, 304, -40},
    { 832, 368, -144},
    { 1024, 312, -112},
    { 1312, 264, -80},
    { 1352, 128, 160},
    { 1584, 296, 40},
    { 1184, 432, -80},
    { 832, 320, -72},
    { 1104, 152, 80},
    { 1112, 136, 120},
    { 880, 192, 32},
    { 784, 160, 40},
    { 784, 112, 16},
    { 736, 8, 24},
    { 744, -40, 24},
    { 936, -32, -8},
    { 984, 64, 24},
    { 1152, 80, -56},
    { 1608, -104, 136},
    { 1376, 40, 136},
    { 1096, 336, -104},
    { 1056, 256, -120},
    { 800, 136, 0},
    // 81 seconds
    { 648, 56, 80},
    { 672, 168, 64},
    { 832, 216, 104},
    { 824, 336, 40},
    { 848, 368, -56},
    { 1000, 400, -104},
    { 1232, 344, -192},
    { 1288, 264, -128},
    { 1800, 272, -16},
    { 1632, 384, -96},
    { 808, 296, -72},
    { 952, 216, 64},
    { 1152, 96, 184},
    { 920, 64, 160},
    { 832, 80, 120},
    { 768, 88, 88},
    { 728, 24, 104},
    { 688, -32, 112},
    { 616, -40, 80},
    { 656, -56, 80},
    { 1032, 112, -40},
    { 1152, 24, -32},
    { 1936, -312, 144},
    { 1576, 72, -112},
    { 1288, 304, -192},
    // 82 seconds
    { 1160, 344, -64},
    { 816, 184, 48},
    { 656, 136, 72},
    { 624, 160, 80},
    { 672, 248, 112},
    { 784, 328, 120},
    { 800, 472, -24},
    { 928, 512, -88},
    { 1016, 312, 16},
    { 1160, 224, 24},
    { 1528, 216, 136},
    { 1480, 320, 112},
    { 1064, 392, -8},
    { 1032, 272, 56},
    { 1168, 136, 136},
    { 1008, 104, 112},
    { 888, 120, 64},
    { 744, 88, 64},
    { 712, 40, 40},
    { 736, -16, 72},
    { 744, -16, 40},
    { 832, -32, 40},
    { 1032, -40, 72},
    { 1136, -8, 72},
    { 1752, -80, 312},
    // 83 seconds
    { 1440, 312, 64},
    { 1008, 688, -208},
    { 1176, 336, 16},
    { 776, 32, 128},
    { 656, 104, 88},
    { 736, 232, 72},
    { 768, 328, 16},
    { 736, 264, 24},
    { 808, 280, -48},
    { 848, 240, -16},
    { 1256, 384, -200},
    { 1208, 232, -96},
    { 1864, 184, 0},
    { 1464, 264, -80},
    { 816, 288, -88},
    { 912, 312, -24},
    { 992, 208, 152},
    { 976, 136, 192},
    { 752, 64, 224},
    { 696, 96, 144},
    { 688, 96, 104},
    { 728, 88, 64},
    { 792, 40, 104},
    { 992, -24, 136},
    { 1168, 16, 104},
    // 84 seconds
    { 1120, 16, 160},
    { 1696, -40, 288},
    { 1232, 328, -56},
    { 968, 408, -296},
    { 904, -8, 8},
    { 160, 568, 224},
    { 456, 160, -48},
    { 832, 192, 104},
    { 752, 208, 72},
    { 768, 232, 96},
    { 808, 248, -48},
    { 968, 264, -32},
    { 1248, 248, -32},
    { 1360, 128, 136},
    { 2248, 224, 72},
    { 984, 440, -48},
    { 832, 272, -56},
    { 1440, -88, -264},
    { 528, -504, 576},
    { 856, 136, 160},
    { 696, 216, 80},
    { 696, 160, 96},
    { 736, 80, 128},
    { 792, 16, 104},
    { 896, -40, 128},
    // 85 seconds
    { 1072, -32, 120},
    { 1192, 72, 24},
    { 1768, -104, 208},
    { 1344, 120, 96},
    { 928, 344, -184},
    { 920, 192, -104},
    { 760, 144, 32},
    { 608, 104, 56},
    { 760, 144, 88},
    { 840, 304, -16},
    { 808, 288, 8},
    { 808, 304, -88},
    { 952, 240, -88},
    { 1168, 224, -96},
    { 1112, 160, -32},
    { 1720, 192, -8},
    { 1288, 320, -72},
    { 968, 360, -48},
    { 944, 240, 64},
    { 1088, 136, 152},
    { 928, 184, 168},
    { 808, 192, 96},
    { 768, 104, 96},
    { 776, 64, 88},
    { 800, 72, 32},
    // 86 seconds
    { 1200, -400, 16},
    { 712, -288, 48},
    { 1120, -72, 8},
    { 1744, -120, 64},
    { 1384, -64, 8},
    { 1112, 328, -160},
    { 1016, 200, -224},
    { 784, 104, -40},
    { 672, 80, -16},
    { 664, 96, 72},
    { 720, 152, 48},
    { 792, 176, 40},
    { 800, 224, -32},
    { 936, 272, -128},
    { 1112, 224, -112},
    { 1312, 208, -152},
    { 1600, 88, -8},
    { 1688, 216, -72},
    { 1008, 344, -152},
    { 840, 304, -96},
    { 1000, 128, 32},
    { 944, 72, 104},
    { 840, 88, 104},
    { 736, 128, 40},
    { 696, 80, 56},
    // 87 seconds
    { 712, 16, 72},
    { 808, -24, 96},
    { 968, -48, 80},
    { 1128, -72, 40},
    { 1160, -56, 16},
    { 1600, -168, 104},
    { 1256, 120, -16},
    { 1136, 272, -248},
    { 904, 232, -200},
    { 656, 56, -24},
    { 648, 128, -40},
    { 736, 104, 8},
    { 832, 176, 8},
    { 872, 200, -40},
    { 888, 256, -120},
    { 968, 296, -208},
    { 1136, 256, -216},
    { 1240, 168, -80},
    { 1904, 248, 16},
    { 1480, 384, -32},
    { 872, 352, -40},
    { 968, 224, 24},
    { 1080, 96, 104},
    { 912, 56, 160},
    { 816, 64, 112},
    // 88 seconds
    { 752, 72, 56},
    { 744, 0, 88},
    { 768, -32, 80},
    { 824, -40, 40},
    { 1016, -72, 16},
    { 1056, -24, -72},
    { 1568, -176, 32},
    { 1408, -56, 24},
    { 1088, 224, -112},
    { 1208, 224, -168},
    { 920, 240, -48},
    { 680, 152, -16},
    { 704, 136, 24},
    { 776, 176, 8},
    { 816, 232, -32},
    { 848, 256, -72},
    { 960, 336, -160},
    { 1112, 344, -184},
    { 1264, 240, -136},
    { 1448, 168, -40},
    { 1576, 264, -40},
    { 1104, 344, -88},
    { 936, 264, 0},
    { 1136, 136, 112},
    { 1048, 72, 192},
    // 89 seconds
    { 872, 88, 168},
    { 760, 104, 120},
    { 712, 56, 96},
    { 712, 32, 40},
    { 712, -48, 56},
    { 824, -72, 40},
    { 1080, -104, 32},
    { 1136, -80, 40},
    { 1680, -160, 128},
    { 1352, 40, 56},
    { 1168, 352, -208},
    { 1168, 256, -176},
    { 896, 208, 0},
    { 680, 104, -8},
    { 760, 144, 0},
    { 792, 176, 24},
    { 832, 248, -56},
    { 856, 248, -16},
    { 920, 368, -160},
    { 1088, 264, -144},
    { 1224, 216, -128},
    { 1616, 112, 8},
    { 1704, 224, 24},
    { 1016, 288, -24},
    { 944, 200, 16},
    // 90 seconds
    { 1224, 56, 160},
    { 992, 56, 200},
    { 832, 128, 112},
    { 768, 120, 56},
    { 736, 48, 48},
    { 704, -16, 40},
    { 672, -64, 56},
    { 880, -80, 16},
    { 1080, -64, -32},
    { 1216, -96, 16},
    { 1640, -136, 160},
    { 1336, 232, -48},
    { 1216, 392, -240},
    { 1112, 328, -40},
    { 752, 152, 32},
    { 736, 176, 48},
    { 776, 224, 32},
    { 792, 272, -8},
    { 768, 264, -8},
    { 880, 328, -88},
    { 968, 360, -160},
    { 1208, 256, -136},
    { 1248, 184, -32},
    { 1848, 248, 32},
    { 1400, 368, -56},
    // 91 seconds
    { 848, 288, 8},
    { 1096, 200, 48},
    { 1128, 32, 176},
    { 880, 88, 168},
    { 776, 88, 128},
    { 728, 88, 96},
    { 712, 24, 88},
    { 768, 56, 16},
    { 704, -72, 72},
    { 976, -80, 48},
    { 1024, -40, -48},
    { 1536, -224, 112},
    { 1776, -48, 264},
    { 1200, 480, -104},
    { 1072, 376, -184},
    { 904, 160, 24},
    { 704, 112, 80},
    { 744, 168, 72},
    { 768, 216, 32},
    { 752, 192, 48},
    { 784, 256, -40},
    { 872, 256, -88},
    { 1000, 272, -104},
    { 1248, 272, -120},
    { 1408, 160, 40},
    // 92 seconds
    { 1920, 240, 16},
    { 1184, 376, -40},
    { 816, 280, -32},
    { 1016, 152, 80},
    { 1064, 40, 176},
    { 888, 40, 160},
    { 816, 72, 104},
    { 760, 56, 56},
    { 744, 8, 56},
    { 760, -24, 56},
    { 864, -56, 40},
    { 1008, -80, 8},
    { 1024, -56, -24},
    { 1680, -192, 176},
    { 1464, 56, 72},
    { 1080, 360, -296},
    { 968, 112, -112},
    { 832, 104, 64},
    { 728, 104, 32},
    { 808, 152, 64},
    { 888, 216, 56},
    { 840, 288, 16},
    { 872, 336, -56},
    { 984, 336, -152},
    { 1192, 264, -176},
    // 93 seconds
    { 1208, 184, -96},
    { 1816, 200, 24},
    { 1488, 352, -24},
    { 880, 320, 32},
    { 1016, 208, 88},
    { 1176, 112, 160},
    { 944, 32, 208},
    { 808, 80, 128},
    { 776, 80, 104},
    { 752, -8, 128},
    { 712, -32, 88},
    { 840, -40, 104},
    { 976, -88, 80},
    { 1072, -32, 0},
    { 1400, -192, 48},
    { 1448, -160, 176},
    { 1176, 176, -40},
    { 1128, 240, -200},
    { 952, 248, -88},
    { 696, 96, 40},
    { 760, 168, 32},
    { 832, 152, 128},
    { 888, 264, 64},
    { 872, 288, 16},
    { 904, 352, -120},
    // 94 seconds
    { 984, 352, -184},
    { 1160, 280, -136},
    { 1520, 152, 64},
    { 1712, 304, 32},
    { 1176, 376, -8},
    { 1064, 280, 32},
    { 1184, 136, 136},
    { 1016, 72, 152},
    { 904, 112, 120},
    { 832, 112, 72},
    { 792, 16, 112},
    { 760, -40, 88},
    { 736, -48, 88},
    { 816, -96, 96},
    { 968, -80, 64},
    { 1112, -120, 80},
    { 1688, -192, 264},
    { 1368, 192, 0},
    { 1136, 400, -272},
    { 1136, 224, -40},
    { 880, 136, 96},
    { 800, 128, 8},
    { 848, 216, 96},
    { 896, 408, 96},
    { 744, 296, 0},
    // 95 seconds
    { 864, 328, -64},
    { 984, 304, -144},
    { 1128, 296, -136},
    { 1280, 272, -40},
    { 1920, 304, 72},
    { 1416, 424, 8},
    { 840, 328, -16},
    { 968, 224, 88},
    { 1136, 152, 168},
    { 912, 104, 232},
    { 840, 128, 184},
    { 800, 96, 168},
    { 752, 48, 168},
    { 760, 16, 136},
    { 784, 8, 128},
    { 920, -8, 96},
    { 1072, 8, 0},
    { 1360, -128, 112},
    { 1624, -144, 168},
    { 1184, 208, -152},
    { 1104, 272, -280},
    { 960, 184, -32},
    { 736, 184, 72},
    { 792, 272, 48},
    { 784, 272, 152},
    // 96 seconds
    { 816, 344, 120},
    { 776, 360, 40},
    { 832, 400, -32},
    { 952, 432, -112},
    { 1184, 344, -40},
    { 1376, 256, 104},
    { 1888, 368, 128},
    { 1248, 432, 0},
    { 680, 344, -16},
    { 976, 176, 104},
    { 1120, 48, 240},
    { 896, 176, 104},
    { 848, 112, 128},
    { 728, 80, 64},
    { 736, 48, 128},
    { 728, -136, 128},
    { 728, 32, 128},
    { 1000, 56, 72},
    { 1096, 96, 40},
    { 1584, -216, 304},
    { 1520, 64, 304},
    { 952, 352, 24},
    { 1120, 360, -16},
    { 888, 200, 136},
    { 736, 168, 96},
    // 97 seconds
    { 736, 176, 136},
    { 832, 216, 72},
    { 760, 240, 40},
    { 768, 248, 0},
    { 856, 288, -72},
    { 984, 264, -56},
    { 1248, 264, 0},
    { 1352, 232, 184},
    { 1944, 280, 256},
    { 1240, 440, 96},
    { 744, 264, 72},
    { 992, 168, 168},
    { 1152, 168, 208},
    { 960, 64, 264},
    { 808, -40, 200},
    { 744, -16, 104},
    { 704, 8, 72},
    { 704, 32, 24},
    { 784, -8, 64},
    { 936, -64, 64},
    { 1048, -32, 24},
    { 1384, -168, 208},
    { 1704, 8, 256},
    { 1224, 368, -72},
    { 992, 312, -184},
    // 98 seconds
    { 968, 280, 8},
    { 776, 24, 144},
    { 760, 136, 88},
    { 784, 200, 120},
    { 848, 352, 8},
    { 784, 272, 24},
    { 880, 392, -136},
    { 1104, 360, -200},
    { 1352, 192, -136},
    { 1416, -16, 64},
    { 1656, 72, 40},
    { 1176, 288, 64},
    { 888, 232, 104},
    { 1064, 128, 208},
    { 1056, 56, 288},
    { 856, 120, 184},
    { 728, 120, 128},
    { 760, 112, 88},
    { 800, 16, 128},
    { 784, 0, 120},
    { 872, -24, 104},
    { 1032, -32, 48},
    { 1088, -8, -40},
    { 1640, -152, 176},
    { 1432, 80, 104},
    // 99 seconds
    { 1008, 224, -240},
    { 1016, 128, -136},
    { 960, 176, 24},
    { 776, 88, 104},
    { 824, 200, 88},
    { 904, 272, 56},
    { 808, 336, 32},
    { 800, 320, -40},
    { 936, 304, -120},
    { 1128, 240, -96},
    { 1272, 192, -88},
    { 1528, 136, 40},
    { 1584, 224, 56},
    { 1064, 304, 8},
    { 976, 224, 56},
    { 1144, 144, 160},
    { 1048, 104, 216},
    { 928, 72, 168},
    { 832, 72, 104},
    { 760, 40, 112},
    { 752, -8, 88},
    { 736, -24, 104},
    { 776, -32, 40},
    { 984, -56, 8},
    { 1040, 8, -24},
    // 100 seconds
    { 1720, -184, 168},
    { 1616, 72, 168},
    { 1192, 408, -200},
    { 1040, 256, -128},
    { 896, 200, 80},
    { 784, 24, 128},
    { 832, 192, 104},
    { 872, 312, 88},
    { 800, 408, -24},
    { 784, 312, 0},
    { 944, 416, -168},
    { 1080, 320, -112},
    { 1256, 304, -160},
    { 1616, 232, 16},
    { 1680, 344, 72},
    { 1096, 328, 32},
    { 1088, 248, 120},
    { 1256, 112, 256},
    { 1144, 16, 336},
    { 928, 24, 272},
    { 760, 24, 184},
    { 704, 8, 112},
    { 680, 0, 80},
    { 696, -8, 72},
    { 752, -64, 48},
    // 101 seconds
    { 936, -80, 24},
    { 1072, -40, -48},
    { 1640, -136, 152},
    { 1432, 104, 112},
    { 1528, 336, -136},
    { 1296, 376, -56},
    { 832, 328, 96},
    { 744, 168, 88},
    { 800, 192, 112},
    { 856, 272, 96},
    { 808, 320, 56},
    { 808, 352, -16},
    { 944, 424, -120},
    { 1120, 376, -136},
    { 1224, 280, -72},
    { 1824, 280, 56},
    { 1520, 304, 88},
    { 1048, 256, 72},
    { 1168, 144, 168},
    { 1224, 80, 232},
    { 1024, 80, 216},
    { 840, 72, 192},
    { 752, 40, 152},
    { 696, 48, 56},
    { 664, -48, 64},
    // 102 seconds
    { 664, -72, 112},
    { 856, 8, -16},
    { 984, -48, 56},
    { 1320, 160, 56},
    { 1848, 176, 128},
    { 1312, 448, -56},
    { 1080, 440, -200},
    { 928, 352, 16},
    { 776, 240, 104},
    { 736, 200, 144},
    { 776, 264, 152},
    { 792, 320, 120},
    { 760, 336, 72},
    { 792, 360, -32},
    { 920, 344, -48},
    { 1120, 328, -80},
    { 1256, 224, 88},
    { 1896, 376, 160},
    { 1232, 480, 56},
    { 872, 312, 56},
    { 1088, 200, 184},
    { 1168, 168, 240},
    { 984, 72, 216},
    { 848, 72, 144},
    { 800, 80, 56},
    // 103 seconds
    { 784, 32, 56},
    { 800, 16, 8},
    { 824, -56, 32},
    { 992, -80, 8},
    { 984, -88, -8},
    { 1616, -208, 112},
    { 1480, 72, 160},
    { 1240, 264, -32},
    { 1304, 312, -56},
    { 976, 360, 112},
    { 712, 168, 112},
    { 784, 200, 168},
    { 872, 256, 120},
    { 824, 320, 56},
    { 792, 344, -24},
    { 856, 392, -112},
    { 1056, 376, -112},
    { 1240, 360, -64},
    { 1704, 248, 56},
    { 1688, 392, 64},
    { 1040, 288, 32},
    { 1136, 192, 72},
    { 1312, 88, 176},
    { 1088, 40, 248},
    { 824, 32, 200},
    // 104 seconds
    { 784, 32, 176},
    { 672, 48, 144},
    { 704, -24, 96},
    { 736, -72, 128},
    { 872, -64, 56},
    { 1024, -80, 16},
    { 1048, -88, 0},
    { 1656, -144, 144},
    { 1504, 176, 40},
    { 1208, 312, -208},
    { 1240, 272, -128},
    { 928, 280, 128},
    { 656, 208, 152},
    { 856, 208, 112},
    { 864, 264, 128},
    { 808, 312, 64},
    { 800, 368, -40},
    { 920, 392, -144},
    { 1168, 344, -120},
    { 1208, 304, -80},
    { 1832, 304, 40},
    { 1576, 400, 40},
    { 936, 264, 48},
    { 1048, 184, 64},
    { 1256, 72, 224},
    // 105 seconds
    { 1064, 80, 224},
    { 920, 72, 200},
    { 848, 48, 168},
    { 768, 16, 144},
    { 760, -16, 104},
    { 776, -32, 80},
    { 880, -88, 40},
    { 1024, -48, -16},
    { 1280, -224, 112},
    { 1664, -40, 256},
    { 1208, 256, -56},
    { 1136, 192, -152},
    { 1112, 240, 40},
    { 888, 144, 128},
    { 896, 208, 128},
    { 928, 304, 96},
    { 896, 376, 56},
    { 824, 408, -40},
    { 904, 392, -112},
    { 928, 376, -120},
    { 1256, 368, -128},
    { 1320, 240, 48},
    { 1648, 408, -8},
    { 1304, 352, -24},
    { 1048, 200, 48},
    // 106 seconds
    { 1176, 144, 176},
    { 1176, 48, 232},
    { 984, 64, 248},
    { 864, 40, 200},
    { 808, 32, 192},
    { 768, -24, 136},
    { 816, -8, 136},
    { 896, -48, 112},
    { 984, -64, 40},
    { 984, -56, -48},
    { 1400, -184, -8},
    { 1352, -24, 88},
    { 1144, 168, -168},
    { 1264, 136, -160},
    { 1040, 216, 104},
    { 800, 184, 128},
    { 896, 288, 168},
    { 904, 368, 176},
    { 832, 368, 152},
    { 800, 408, 32},
    { 856, 376, -56},
    { 1008, 352, -88},
    { 1248, 288, -40},
    { 1512, 224, 112},
    { 1656, 328, 64},
    // 107 seconds
    { 1120, 360, -40},
    { 1040, 224, 64},
    { 1280, 96, 208},
    { 1152, 96, 208},
    { 952, 56, 216},
    { 864, 16, 168},
    { 712, -16, 136},
    { 624, -40, 112},
    { 584, -32, 120},
    { 648, 40, 104},
    { 760, 72, 320},
    { 1104, 576, 128},
    { 1080, 784, 88},
    { 1576, 432, 312},
    { 1136, 528, 176},
    { 1128, 616, 48},
    { 840, 536, 48},
    { 744, 384, 104},
    { 688, 312, 216},
    { 728, 520, 264},
    { 816, 528, 304},
    { 776, 552, 272},
    { 728, 560, 216},
    { 728, 608, 120},
    { 760, 600, 88},
    // 108 seconds
    { 752, 592, 96},
    { 792, 608, 72},
    { 760, 672, 88},
    { 656, 672, 136},
    { 640, 688, 24},
    { 624, 712, 96},
    { 576, 704, 104},
    { 512, 760, -48},
    { 448, 720, -56},
    { 384, 736, -80},
    { 408, 872, -80},
    { 400, 968, -40},
    { 352, 896, -16},
    { 280, 808, -48},
    { 280, 776, 48},
    { 368, 976, 136},
    { 352, 1160, -128},
    { 336, 856, -128},
    { 72, 1056, -240},
    { 240, 1176, -200},
    { 152, 1120, -232},
    { -16, 1008, -496},
    { 0, 792, -648},
    { -32, 560, -720},
    { -24, 304, -792},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:22:20 local
AccelRawData *activity_sample_walk_200_pbl_25299_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25299_9
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -152, -256, -1000},
    { -152, -256, -992},
    { -168, -248, -992},
    { -176, -248, -976},
    { -144, -256, -1000},
    { -168, -240, -992},
    { -120, -264, -1000},
    { -120, -288, -1008},
    { -160, -264, -992},
    { -160, -256, -1016},
    { -104, -256, -1016},
    { -48, -256, -1016},
    { -80, -264, -1008},
    { -72, -288, -984},
    { -128, -344, -992},
    { -40, -320, -992},
    { -128, -272, -1008},
    { -120, -288, -984},
    { -344, -128, -1016},
    { 80, -704, -1064},
    { -8, -176, -1000},
    { -80, -264, -1016},
    { -104, -264, -984},
    { -120, -176, -928},
    { -120, 0, -864},
    // 1 seconds
    { -120, 200, -744},
    { -136, 328, -712},
    { -88, 488, -680},
    { -64, 776, -568},
    { -48, 984, -544},
    { -48, 976, -504},
    { -40, 896, -488},
    { -64, 960, -288},
    { -40, 952, -240},
    { -8, 1040, -224},
    { -8, 960, -224},
    { -64, 592, -168},
    { 168, 928, -56},
    { 208, 872, -96},
    { 136, 776, 0},
    { 320, 888, -152},
    { 264, 856, -40},
    { 448, 1112, -144},
    { 408, 944, -184},
    { 456, 1080, -248},
    { 552, 912, -288},
    { 488, 880, -280},
    { 584, 824, -296},
    { 504, 736, -232},
    { 576, 672, -216},
    // 2 seconds
    { 608, 504, -168},
    { 712, 488, -104},
    { 864, 440, -112},
    { 968, 320, -80},
    { 1024, 168, 64},
    { 1832, 104, 232},
    { 1752, 320, 80},
    { 1016, 480, -24},
    { 680, 336, -312},
    { 992, 104, 40},
    { 832, 432, 144},
    { 824, 352, 48},
    { 712, 200, 144},
    { 784, 232, 40},
    { 752, 192, 32},
    { 784, 256, -192},
    { 776, 224, -56},
    { 848, 256, -224},
    { 1128, 192, -144},
    { 1312, 112, 8},
    { 1984, 240, 168},
    { 1648, 384, 144},
    { 888, 552, -72},
    { 344, 352, -16},
    { 944, 48, 96},
    // 3 seconds
    { 1032, 128, 176},
    { 744, 168, 136},
    { 680, 136, 104},
    { 680, 128, 88},
    { 664, 120, 112},
    { 760, 136, 80},
    { 800, 104, 32},
    { 1032, 152, -24},
    { 1408, 96, 128},
    { 1928, -8, 280},
    { 1512, 328, 16},
    { 792, 576, -416},
    { 656, 160, -192},
    { 720, -64, 8},
    { 712, 256, 40},
    { 656, 288, 64},
    { 824, 224, 32},
    { 712, 296, -96},
    { 720, 232, -64},
    { 776, 328, -176},
    { 1080, 240, -48},
    { 1400, 208, 40},
    { 1856, 272, 144},
    { 1600, 440, 16},
    { 744, 448, -32},
    // 4 seconds
    { 752, 264, 32},
    { 1040, 152, 176},
    { 928, 160, 168},
    { 760, 168, 40},
    { 664, 128, 8},
    { 680, 88, 48},
    { 760, 72, 32},
    { 808, 72, 32},
    { 928, 0, 72},
    { 1184, 48, 64},
    { 1472, -16, 184},
    { 1840, 160, 224},
    { 1040, 608, -304},
    { 736, 200, -240},
    { 872, 16, 80},
    { 616, 104, 24},
    { 656, 192, 56},
    { 720, 248, 88},
    { 768, 344, -16},
    { 744, 296, -16},
    { 912, 328, -120},
    { 1088, 272, -72},
    { 1304, 280, -88},
    { 1512, 232, 24},
    { 1752, 368, 40},
    // 5 seconds
    { 1000, 520, -64},
    { 704, 344, 0},
    { 952, 280, 152},
    { 1024, 104, 168},
    { 768, 112, 144},
    { 688, 120, 112},
    { 680, 128, 56},
    { 712, 96, 80},
    { 816, 88, 64},
    { 912, 16, 104},
    { 1184, 8, 64},
    { 1200, 32, 80},
    { 1616, 72, 104},
    { 1336, 304, -152},
    { 976, 336, -336},
    { 880, 128, -144},
    { 648, 120, 8},
    { 584, 168, 0},
    { 712, 168, 56},
    { 776, 272, 64},
    { 784, 320, -24},
    { 800, 336, -96},
    { 840, 344, -96},
    { 1328, 504, -232},
    { 1456, 296, 72},
    // 6 seconds
    { 1984, 280, 0},
    { 1152, 296, -56},
    { 912, 264, -8},
    { 1080, 208, 88},
    { 1064, 192, 136},
    { 816, 152, 104},
    { 656, 136, -8},
    { 640, 64, 48},
    { 704, 56, 72},
    { 720, 72, 96},
    { 840, 24, 152},
    { 1136, 48, 8},
    { 1160, 24, -128},
    { 1688, -104, 40},
    { 1224, 168, -200},
    { 1152, 352, -352},
    { 1160, 296, -56},
    { 776, 296, 80},
    { 688, 240, 64},
    { 688, 192, 112},
    { 768, 216, 88},
    { 720, 264, 128},
    { 784, 424, -32},
    { 936, 336, 16},
    { 1232, 416, -120},
    // 7 seconds
    { 1296, 400, 32},
    { 2032, 712, 16},
    { 1160, 520, -16},
    { 944, 224, -40},
    { 1080, 208, 72},
    { 992, 224, 88},
    { 888, 88, 128},
    { 728, 80, 56},
    { 720, 88, 48},
    { 768, 80, 80},
    { 760, 40, 88},
    { 808, 0, 88},
    { 968, 16, 24},
    { 1040, 40, -8},
    { 1648, -104, 104},
    { 1624, 160, 56},
    { 1048, 464, -296},
    { 1088, 184, -176},
    { 912, 288, 16},
    { 664, 160, 24},
    { 768, 224, 32},
    { 768, 280, 48},
    { 824, 352, -48},
    { 800, 304, -96},
    { 928, 368, -192},
    // 8 seconds
    { 1216, 344, -184},
    { 1232, 232, -80},
    { 1936, 368, 0},
    { 1368, 424, 24},
    { 864, 336, -24},
    { 992, 248, 112},
    { 1208, 200, 128},
    { 928, 144, 176},
    { 792, 112, 120},
    { 728, 128, 64},
    { 688, 72, 72},
    { 696, 32, 48},
    { 768, 0, 72},
    { 944, -40, 40},
    { 1168, 8, 40},
    { 1328, -48, 64},
    { 1608, 40, 120},
    { 1128, 304, -160},
    { 1128, 304, -296},
    { 856, 296, -48},
    { 632, 176, 8},
    { 800, 216, 32},
    { 824, 304, 24},
    { 816, 264, -24},
    { 768, 280, -56},
    // 9 seconds
    { 912, 368, -176},
    { 1000, 352, -160},
    { 1240, 328, -160},
    { 1576, 232, -8},
    { 1608, 312, 48},
    { 1104, 344, -8},
    { 896, 288, 24},
    { 1112, 168, 136},
    { 1032, 176, 168},
    { 864, 136, 160},
    { 752, 104, 104},
    { 736, 80, 40},
    { 728, 8, 80},
    { 736, 48, 16},
    { 952, -40, 64},
    { 1112, 48, -40},
    { 1072, -32, -24},
    { 1704, -48, 88},
    { 1328, 232, -72},
    { 1240, 320, -176},
    { 928, 352, -144},
    { 584, 160, 40},
    { 800, 176, 72},
    { 864, 256, 80},
    { 848, 336, 96},
    // 10 seconds
    { 760, 296, 0},
    { 776, 280, -48},
    { 960, 448, -136},
    { 1288, 392, -152},
    { 1248, 304, -88},
    { 1760, 448, -112},
    { 1352, 464, -120},
    { 896, 272, 0},
    { 1200, 568, -256},
    { 808, -80, 344},
    { 1072, 144, 160},
    { 648, 104, 192},
    { 752, 96, 216},
    { 680, 80, 160},
    { 664, 56, 104},
    { 768, 0, 88},
    { 968, -32, 40},
    { 1200, 8, 40},
    { 1584, -128, 288},
    { 1520, 280, 88},
    { 1312, 568, -248},
    { 1056, 408, -136},
    { 768, 296, 88},
    { 640, 64, 120},
    { 800, 56, 152},
    // 11 seconds
    { 784, 192, 48},
    { 840, 312, 56},
    { 752, 408, -152},
    { 872, 240, -16},
    { 1120, 400, -128},
    { 1336, 288, -48},
    { 1696, 176, 56},
    { 1440, 256, 32},
    { 1024, 288, 24},
    { 960, 224, 64},
    { 1112, 104, 192},
    { 968, 104, 216},
    { 800, 168, 80},
    { 728, 112, 112},
    { 664, 152, 8},
    { 688, 56, 48},
    { 776, 40, 40},
    { 1000, -32, -8},
    { 1112, 24, -32},
    { 1264, -128, 112},
    { 1768, 56, 136},
    { 1240, 408, -96},
    { 1128, 376, -136},
    { 832, 344, 16},
    { 552, 72, 136},
    // 12 seconds
    { 656, 40, 96},
    { 784, 136, 152},
    { 904, 320, 8},
    { 776, 272, 16},
    { 1016, 512, -232},
    { 1152, 384, -288},
    { 1328, 432, -328},
    { 1792, 216, -192},
    { 1688, 416, -200},
    { 888, 400, -176},
    { 856, 328, -152},
    { 1192, 112, 104},
    { 1000, 88, 200},
    { 768, 152, 64},
    { 696, 152, 40},
    { 688, 72, 24},
    { 736, -24, 88},
    { 744, 56, -32},
    { 864, -8, -8},
    { 1072, 32, -32},
    { 1248, 56, -96},
    { 1680, -56, 72},
    { 1264, 240, -152},
    { 1152, 288, -168},
    { 1072, 328, -72},
    // 13 seconds
    { 704, 216, -88},
    { 624, 144, 8},
    { 744, 208, 16},
    { 792, 256, 0},
    { 816, 296, -24},
    { 936, 344, -88},
    { 1080, 424, -216},
    { 1328, 416, -288},
    { 1384, 216, -136},
    { 1800, 352, -168},
    { 1176, 408, -192},
    { 856, 280, -104},
    { 1064, 152, 136},
    { 1096, 160, 184},
    { 872, 144, 144},
    { 776, 88, 128},
    { 696, 80, 64},
    { 720, 32, 56},
    { 752, 56, 48},
    { 832, -32, 72},
    { 1128, -8, 8},
    { 1144, -24, 32},
    { 1536, -56, 104},
    { 1312, 224, -96},
    { 1104, 304, -272},
    // 14 seconds
    { 1096, 208, -120},
    { 792, 208, -72},
    { 728, 192, -72},
    { 792, 256, -32},
    { 856, 280, -56},
    { 792, 256, -144},
    { 856, 272, -136},
    { 1024, 384, -280},
    { 1192, 288, -200},
    { 1288, 256, -120},
    { 1696, 304, -80},
    { 1296, 392, -56},
    { 856, 336, -32},
    { 1056, 256, 80},
    { 1176, 152, 184},
    { 952, 152, 168},
    { 808, 120, 88},
    { 736, 112, 40},
    { 728, 64, 24},
    { 760, 24, -24},
    { 928, -24, -16},
    { 1080, -40, -24},
    { 1064, -24, -56},
    { 1656, -120, -16},
    { 1304, 64, 48},
    // 15 seconds
    { 1264, 280, -104},
    { 1144, 264, -128},
    { 800, 296, 8},
    { 624, 184, 24},
    { 712, 128, 120},
    { 800, 224, 72},
    { 832, 280, 72},
    { 848, 432, -80},
    { 1048, 408, -160},
    { 1136, 384, -208},
    { 1208, 248, -80},
    { 1840, 336, 0},
    { 1344, 488, -48},
    { 992, 360, -16},
    { 1072, 200, 120},
    { 1136, 184, 168},
    { 864, 128, 128},
    { 752, 88, 104},
    { 832, 80, 104},
    { 792, 32, 104},
    { 824, 8, 48},
    { 952, -40, 88},
    { 1112, -48, 24},
    { 1064, 8, -32},
    { 1496, 16, 56},
    // 16 seconds
    { 1144, 72, -112},
    { 1056, 104, -216},
    { 1128, 96, -128},
    { 880, 176, -56},
    { 720, 176, -48},
    { 832, 240, 80},
    { 832, 272, 56},
    { 832, 248, -24},
    { 912, 336, -184},
    { 1048, 288, -232},
    { 1280, 296, -280},
    { 1320, 152, -184},
    { 1800, 240, -136},
    { 1304, 280, -80},
    { 944, 208, -32},
    { 1048, 152, 80},
    { 1120, 56, 176},
    { 952, 120, 128},
    { 800, 120, 80},
    { 736, 56, 32},
    { 720, 0, 72},
    { 736, -40, 40},
    { 808, -184, 88},
    { 1056, 128, -32},
    { 1240, 160, 0},
    // 17 seconds
    { 1784, 112, 72},
    { 1192, 288, -80},
    { 1000, 344, -248},
    { 1032, 240, -24},
    { 800, 232, 56},
    { 696, 168, 56},
    { 776, 216, 48},
    { 800, 256, 40},
    { 848, 344, -104},
    { 824, 344, -136},
    { 1072, 296, -184},
    { 1216, 528, -104},
    { 1320, 352, 8},
    { 1808, 424, 56},
    { 1376, 512, -48},
    { 736, 320, -40},
    { 936, 224, 8},
    { 1104, 136, 136},
    { 976, 128, 112},
    { 832, 120, 96},
    { 760, 88, 56},
    { 760, 48, 104},
    { 808, 48, 40},
    { 944, -24, 48},
    { 928, -80, 32},
    // 18 seconds
    { 1064, -16, -120},
    { 1664, -184, 64},
    { 1264, 112, -24},
    { 1112, 200, -168},
    { 1040, 280, -232},
    { 816, 192, -24},
    { 680, 144, -32},
    { 728, 168, 0},
    { 832, 264, 64},
    { 888, 408, 32},
    { 960, 456, -88},
    { 1024, 472, -176},
    { 1192, 360, -160},
    { 1112, 160, -8},
    { 1784, 552, 72},
    { 1272, 768, 48},
    { 848, 496, 80},
    { 1080, 240, 256},
    { 1200, 80, 344},
    { 928, 136, 224},
    { 864, 144, 112},
    { 904, 40, 144},
    { 808, 8, 48},
    { 784, 8, 24},
    { 824, -48, 32},
    // 19 seconds
    { 944, -88, 0},
    { 1000, -24, -80},
    { 1512, -184, 128},
    { 1384, 136, 24},
    { 1208, 304, -184},
    { 1184, 320, -144},
    { 880, 280, 8},
    { 736, 152, 0},
    { 808, 200, 24},
    { 864, 256, 48},
    { 840, 304, -8},
    { 848, 320, -104},
    { 1040, 400, -200},
    { 1208, 376, -224},
    { 1232, 232, -24},
    { 1912, 352, 32},
    { 1328, 512, 8},
    { 888, 288, 16},
    { 1160, 152, 184},
    { 1160, 120, 208},
    { 928, 88, 128},
    { 832, 0, 136},
    { 760, 24, 72},
    { 776, 8, 80},
    { 768, -32, 32},
    // 20 seconds
    { 856, -88, 72},
    { 968, -112, 16},
    { 1000, 16, -120},
    { 1560, -168, 248},
    { 1488, 360, -48},
    { 1016, 424, -288},
    { 1176, 160, -56},
    { 760, 24, 24},
    { 704, 104, -8},
    { 840, 216, 40},
    { 856, 344, 16},
    { 832, 352, -24},
    { 896, 400, -112},
    { 1024, 400, -176},
    { 1232, 344, -208},
    { 1256, 192, -80},
    { 1760, 312, -88},
    { 1272, 384, -56},
    { 928, 280, -24},
    { 1128, 168, 112},
    { 1112, 128, 208},
    { 840, 168, 112},
    { 744, 104, 104},
    { 720, 64, 104},
    { 736, 8, 72},
    // 21 seconds
    { 768, 0, 96},
    { 984, 0, 96},
    { 1192, 8, 8},
    { 1144, 0, 56},
    { 1640, -24, 8},
    { 1144, 168, -248},
    { 1000, -72, -168},
    { 1192, 152, -280},
    { 840, 224, -112},
    { 696, 272, -56},
    { 760, 344, 32},
    { 808, 368, 40},
    { 768, 272, 64},
    { 816, 272, 0},
    { 928, 304, -144},
    { 1200, 312, -192},
    { 1336, 288, -104},
    { 1784, 328, -168},
    { 1488, 376, -200},
    { 808, 288, -120},
    { 992, 232, -16},
    { 1080, 216, 72},
    { 904, 184, 104},
    { 824, 120, 120},
    { 800, 88, 72},
    // 22 seconds
    { 800, 40, 120},
    { 816, 56, 24},
    { 888, -16, 56},
    { 1016, -64, 56},
    { 1160, 0, -8},
    { 1584, -216, 264},
    { 1416, 120, 88},
    { 936, 392, -288},
    { 976, 216, -256},
    { 896, 168, 40},
    { 792, 112, 24},
    { 848, 384, -8},
    { 848, 360, 40},
    { 824, 160, -80},
    { 840, 240, -112},
    { 888, 328, -216},
    { 1128, 368, -160},
    { 1320, 392, -264},
    { 1688, 224, -32},
    { 1776, 352, -24},
    { 1168, 384, -64},
    { 1264, 408, -8},
    { 1248, 0, 88},
    { 1064, -216, 216},
    { 848, -176, 64},
    // 23 seconds
    { 672, -56, 0},
    { 672, 16, 8},
    { 680, 0, -40},
    { 712, -72, 24},
    { 816, -176, 80},
    { 976, -24, -24},
    { 1144, -192, 8},
    { 1696, -32, 112},
    { 1280, 96, -88},
    { 1320, 280, -200},
    { 1024, 304, -208},
    { 792, -88, -8},
    { 752, 72, -72},
    { 832, 208, -48},
    { 944, 256, -24},
    { 856, 312, -64},
    { 944, 368, -200},
    { 984, 272, -48},
    { 1344, 408, -272},
    { 1288, 352, -16},
    { 1984, 416, -128},
    { 1288, 352, -120},
    { 1072, 240, -40},
    { 1224, 104, 80},
    { 1192, 72, 160},
    // 24 seconds
    { 936, 48, 152},
    { 800, 40, 72},
    { 768, 40, 80},
    { 760, 24, 64},
    { 784, -48, 64},
    { 816, -88, 104},
    { 928, -40, -48},
    { 896, -64, -96},
    { 1624, -256, 88},
    { 1432, 128, 32},
    { 1176, 360, -288},
    { 1368, 488, -88},
    { 936, 528, 8},
    { 736, 192, 80},
    { 760, 264, 80},
    { 792, 312, 64},
    { 784, 368, -24},
    { 800, 408, -64},
    { 984, 504, -160},
    { 1120, 456, -136},
    { 1240, 448, -120},
    { 1760, 440, -24},
    { 1472, 640, -64},
    { 912, 448, -32},
    { 1208, 296, 88},
    // 25 seconds
    { 1264, 168, 192},
    { 1072, 120, 208},
    { 888, 112, 120},
    { 792, 104, 88},
    { 736, 40, 104},
    { 704, 16, 48},
    { 752, -64, 104},
    { 824, -104, 48},
    { 944, -24, -24},
    { 1328, -168, 40},
    { 1792, -8, 120},
    { 1296, 384, -168},
    { 1328, 512, -256},
    { 1008, 576, -24},
    { 616, 112, 48},
    { 856, 144, 112},
    { 864, 208, 112},
    { 808, 304, 40},
    { 776, 352, -24},
    { 928, 392, -160},
    { 1032, 344, -128},
    { 1272, 320, -96},
    { 1496, 336, 72},
    { 1528, 448, 16},
    { 1072, 480, -48},
    // 26 seconds
    { 880, 336, 32},
    { 1104, 224, 168},
    { 1064, 168, 184},
    { 872, 96, 192},
    { 832, 112, 112},
    { 792, 96, 96},
    { 792, 80, 104},
    { 856, -16, 56},
    { 960, -80, 96},
    { 976, 0, -48},
    { 1056, -88, -80},
    { 1216, -64, 72},
    { 1224, 144, 8},
    { 1272, 280, -128},
    { 1024, 432, -96},
    { 672, 232, 48},
    { 744, 200, 48},
    { 808, 104, 200},
    { 784, 232, 152},
    { 816, 328, 88},
    { 856, 424, -64},
    { 1056, 440, -104},
    { 1200, 384, -144},
    { 1408, 224, 72},
    { 1616, 440, 40},
    // 27 seconds
    { 1112, 536, 0},
    { 968, 416, 24},
    { 1216, 168, 192},
    { 1080, 136, 208},
    { 880, 168, 120},
    { 792, 120, 120},
    { 784, 112, 88},
    { 816, 24, 136},
    { 848, 64, 112},
    { 1032, -24, 64},
    { 1056, 8, -32},
    { 1080, -104, 24},
    { 1504, -160, 192},
    { 1088, 208, -24},
    { 1064, 264, -120},
    { 1240, 240, -16},
    { 856, 304, 96},
    { 680, 264, 48},
    { 840, 296, 96},
    { 880, 312, 64},
    { 832, 344, 0},
    { 912, 424, -168},
    { 1048, 328, -208},
    { 1224, 264, -112},
    { 1400, 112, 128},
    // 28 seconds
    { 1776, 280, 120},
    { 1032, 488, 0},
    { 1016, 304, 104},
    { 1232, 160, 256},
    { 1080, 120, 264},
    { 856, 104, 176},
    { 776, 96, 88},
    { 808, 48, 48},
    { 824, 0, 8},
    { 800, -48, 0},
    { 840, -200, 96},
    { 960, -112, 64},
    { 1064, -96, 72},
    { 1720, -160, 168},
    { 1232, 272, -64},
    { 1112, 288, -160},
    { 1208, 248, 0},
    { 848, 232, 16},
    { 752, 176, 48},
    { 792, 168, 64},
    { 792, 288, 24},
    { 808, 360, -8},
    { 896, 304, -144},
    { 976, 264, -192},
    { 1256, 208, -152},
    // 29 seconds
    { 1376, 200, 40},
    { 1744, 288, 16},
    { 1272, 400, -24},
    { 936, 208, -32},
    { 1080, 80, 96},
    { 1032, 24, 88},
    { 856, 32, 136},
    { 720, 16, 96},
    { 688, 80, 64},
    { 712, 24, 88},
    { 800, -32, 120},
    { 872, -160, 144},
    { 1152, -152, 80},
    { 1200, -104, 112},
    { 1576, -208, 112},
    { 1248, 64, -56},
    { 920, 224, -216},
    { 944, 256, -184},
    { 800, 200, -48},
    { 688, 176, 40},
    { 784, 152, 24},
    { 808, 200, 16},
    { 768, 256, -64},
    { 848, 240, -112},
    { 1016, 232, -136},
    // 30 seconds
    { 1216, 192, -136},
    { 1248, 120, -40},
    { 1808, 192, 24},
    { 1280, 360, -48},
    { 880, 368, -32},
    { 984, 248, 88},
    { 1040, 160, 160},
    { 920, 136, 160},
    { 784, 136, 80},
    { 744, 88, 48},
    { 752, 32, 24},
    { 808, 16, 40},
    { 960, -32, 96},
    { 1032, -72, 64},
    { 1056, 16, 16},
    { 1616, -152, 136},
    { 1440, 96, 120},
    { 944, 440, -168},
    { 976, 144, -24},
    { 904, 160, 80},
    { 656, 88, 56},
    { 624, 176, 88},
    { 792, 296, -24},
    { 800, 232, 80},
    { 832, 352, -64},
    // 31 seconds
    { 1080, 320, -96},
    { 1192, 376, -192},
    { 1288, 248, -144},
    { 1800, 208, -32},
    { 1552, 328, -88},
    { 856, 288, -32},
    { 1080, 200, 32},
    { 1144, -256, -152},
    { 1032, 168, 48},
    { 696, 168, 112},
    { 776, 128, 32},
    { 768, 72, 160},
    { 760, 24, 72},
    { 784, -24, 88},
    { 888, -88, 88},
    { 1048, 24, 32},
    { 1208, -48, 104},
    { 1440, 16, 224},
    { 1200, 320, -88},
    { 1184, 344, -200},
    { 1000, 256, -32},
    { 824, 96, -136},
    { 584, 80, -16},
    { 800, 256, 104},
    { 784, 272, 32},
    // 32 seconds
    { 808, 248, 40},
    { 896, 344, -136},
    { 1072, 328, -120},
    { 1248, 352, -160},
    { 1544, 224, 16},
    { 1632, 344, -24},
    { 1048, 392, 8},
    { 1032, 352, 16},
    { 1136, 256, 136},
    { 968, 136, 200},
    { 840, 160, 160},
    { 768, 192, 88},
    { 752, 88, 128},
    { 760, 96, 64},
    { 776, 48, 72},
    { 888, -48, 96},
    { 1016, 0, 16},
    { 1216, -72, 96},
    { 1576, -72, 128},
    { 1208, 208, -88},
    { 1200, 392, -208},
    { 1064, 456, -16},
    { 648, 216, 128},
    { 648, 384, 48},
    { 768, 312, 128},
    // 33 seconds
    { 760, 440, 72},
    { 728, 328, 16},
    { 864, 712, 64},
    { 1008, 232, -152},
    { 1224, 504, -40},
    { 1280, 352, 88},
    { 1576, 448, 72},
    { 1216, 496, -136},
    { 920, 344, -24},
    { 1048, 152, 112},
    { 1080, 176, 176},
    { 872, 168, 176},
    { 736, 168, 144},
    { 736, 112, 120},
    { 752, 0, 104},
    { 792, 48, 24},
    { 896, -48, 40},
    { 1080, -16, 56},
    { 1056, 40, -40},
    { 1632, -48, 16},
    { 1336, 120, -16},
    { 1048, 296, -296},
    { 1096, 248, -176},
    { 880, 216, -16},
    { 688, 192, 16},
    // 34 seconds
    { 664, 184, -48},
    { 888, 232, 64},
    { 776, 312, -32},
    { 824, 344, -80},
    { 936, 368, -160},
    { 1096, 344, -160},
    { 1208, 320, -136},
    { 1840, 224, -8},
    { 1568, 424, -48},
    { 768, 408, -72},
    { 968, 272, 16},
    { 1248, 120, 40},
    { 952, 112, 136},
    { 792, 144, 64},
    { 752, 120, 40},
    { 736, 24, 88},
    { 736, 8, -40},
    { 888, 32, 24},
    { 968, -72, 24},
    { 1088, 24, -32},
    { 1368, 16, -8},
    { 1576, 0, 64},
    { 1176, 296, -264},
    { 872, 336, -360},
    { 960, 16, -8},
    // 35 seconds
    { 712, 8, 24},
    { 752, 168, 16},
    { 784, 240, -24},
    { 808, 328, -80},
    { 792, 352, -136},
    { 864, 336, -192},
    { 1040, 304, -224},
    { 1208, 240, -192},
    { 1328, 200, -24},
    { 1824, 304, -8},
    { 1144, 392, 0},
    { 1000, 320, -32},
    { 1168, 168, 80},
    { 1104, 120, 72},
    { 840, 112, 32},
    { 752, 80, 24},
    { 696, 64, 0},
    { 680, 0, -8},
    { 792, 24, 32},
    { 896, -56, 32},
    { 1064, -32, -32},
    { 1136, -72, 32},
    { 1704, -88, 80},
    { 1344, 192, -56},
    { 960, 376, -208},
    // 36 seconds
    { 984, 216, -80},
    { 824, 112, 32},
    { 720, 136, 24},
    { 784, 200, -40},
    { 832, 240, -8},
    { 808, 344, -120},
    { 912, 280, -136},
    { 1016, 280, -224},
    { 1216, 176, -160},
    { 1280, 160, -104},
    { 1768, 232, -56},
    { 1344, 304, -56},
    { 824, 304, -40},
    { 1056, 200, 80},
    { 1104, 120, 192},
    { 952, 104, 192},
    { 856, 80, 152},
    { 792, 48, 112},
    { 720, 16, 80},
    { 752, 48, 8},
    { 848, -8, -16},
    { 984, -80, -16},
    { 1048, -48, -104},
    { 1344, -200, 32},
    { 1504, -64, 112},
    // 37 seconds
    { 1160, 320, -80},
    { 1096, 304, -104},
    { 928, 304, 72},
    { 704, 168, 120},
    { 760, 192, 128},
    { 824, 264, 144},
    { 808, 400, -40},
    { 784, 200, 120},
    { 984, 424, -144},
    { 1144, 328, -120},
    { 1240, 416, -264},
    { 1576, 216, 8},
    { 1768, 344, -8},
    { 1088, 376, 32},
    { 1056, 320, 56},
    { 1208, 176, 216},
    { 1008, 112, 248},
    { 816, 128, 208},
    { 736, 120, 152},
    { 712, 56, 160},
    { 712, -8, 160},
    { 768, 40, 72},
    { 832, -72, 80},
    { 928, -24, 8},
    { 1120, -32, 8},
    // 38 seconds
    { 1712, -136, 136},
    { 1440, 208, -56},
    { 1104, 472, -416},
    { 1056, 248, -56},
    { 832, 200, 96},
    { 768, 248, 8},
    { 816, 360, 88},
    { 816, 464, 32},
    { 760, 416, -16},
    { 816, 368, -56},
    { 1040, 416, -64},
    { 1168, 392, -64},
    { 1320, 208, 112},
    { 1856, 224, 168},
    { 1232, 360, 64},
    { 928, 256, 40},
    { 1032, 136, 120},
    { 984, 48, 232},
    { 904, 48, 184},
    { 800, 40, 128},
    { 736, 16, 88},
    { 720, -16, 96},
    { 752, -32, 88},
    { 864, -56, 80},
    { 1008, -96, 40},
    // 39 seconds
    { 1056, -72, -16},
    { 1656, -304, 152},
    { 1400, -32, 152},
    { 1080, 240, -88},
    { 1120, 288, -152},
    { 880, 280, -8},
    { 696, 128, 56},
    { 760, 152, 88},
    { 824, 224, 96},
    { 840, 272, 40},
    { 864, 304, -32},
    { 992, 392, -160},
    { 1192, 320, -136},
    { 1232, 240, -80},
    { 1864, 216, 80},
    { 1576, 392, 8},
    { 912, 336, -24},
    { 960, 208, 56},
    { 1120, 64, 192},
    { 1000, 64, 200},
    { 840, 96, 152},
    { 792, 48, 144},
    { 752, 32, 88},
    { 808, 0, 80},
    { 848, -40, 16},
    // 40 seconds
    { 976, -112, 16},
    { 1032, -128, 32},
    { 1280, -160, 96},
    { 1408, -40, 72},
    { 1216, 208, -80},
    { 1280, 272, -216},
    { 1016, 240, -56},
    { 680, 136, -40},
    { 792, 184, 0},
    { 840, 248, 24},
    { 888, 288, 16},
    { 880, 312, -88},
    { 904, 328, -168},
    { 1088, 312, -208},
    { 1208, 216, -136},
    { 1496, 184, -8},
    { 1648, 312, 0},
    { 1104, 344, 56},
    { 1064, 256, 56},
    { 1152, 112, 160},
    { 976, 80, 152},
    { 840, 80, 104},
    { 784, 72, 80},
    { 808, 24, 48},
    { 800, -16, 40},
    // 41 seconds
    { 824, -48, 40},
    { 936, -112, 48},
    { 1032, -88, 48},
    { 1288, -144, 48},
    { 1456, -136, 96},
    { 1128, 200, -104},
    { 1216, 200, -184},
    { 1088, 184, 0},
    { 760, 184, 64},
    { 824, 200, 88},
    { 840, 256, 120},
    { 880, 288, 120},
    { 856, 328, 8},
    { 928, 368, -120},
    { 1032, 368, -208},
    { 1184, 336, -192},
    { 1648, 160, 16},
    { 1784, 320, 8},
    { 960, 344, 0},
    { 1080, 200, 48},
    { 1200, 120, 160},
    { 976, 56, 208},
    { 808, 104, 144},
    { 744, 88, 104},
    { 688, 24, 128},
    // 42 seconds
    { 696, 8, 64},
    { 912, -48, 128},
    { 736, -96, 48},
    { 1072, -88, 8},
    { 1208, -168, 120},
    { 1504, -48, 184},
    { 1192, 336, -152},
    { 1328, 80, 0},
    { 1032, 192, 96},
    { 744, 224, 40},
    { 800, 304, 72},
    { 808, 256, 64},
    { 824, 232, 64},
    { 848, 264, 8},
    { 936, 360, -80},
    { 1104, 384, -168},
    { 1176, 352, -208},
    { 1408, 232, -40},
    { 1832, 320, 8},
    { 1152, 408, 24},
    { 984, 296, 88},
    { 1176, 160, 216},
    { 1080, 96, 248},
    { 904, 64, 248},
    { 792, 56, 184},
    // 43 seconds
    { 752, 48, 184},
    { 800, 24, 120},
    { 816, -8, 120},
    { 848, -64, 104},
    { 976, -96, 16},
    { 1112, -88, -40},
    { 1568, -208, 144},
    { 1280, 112, -48},
    { 1208, 264, -264},
    { 1280, 120, -48},
    { 1024, 272, 112},
    { 824, 344, 8},
    { 848, 320, 128},
    { 856, 296, 104},
    { 808, 312, 40},
    { 824, 344, -24},
    { 1008, 416, -88},
    { 1088, 448, -192},
    { 1256, 352, -64},
    { 1864, 304, 48},
    { 1432, 376, 64},
    { 1080, 192, 32},
    { 1184, 160, 88},
    { 1216, 40, 248},
    { 992, 48, 176},
    // 44 seconds
    { 848, 48, 112},
    { 776, 8, 104},
    { 720, -24, 80},
    { 696, -24, 80},
    { 784, -64, 120},
    { 888, -88, 48},
    { 1008, -40, -24},
    { 1416, -184, 96},
    { 1648, -48, 160},
    { 1392, 272, -120},
    { 1280, 376, -224},
    { 976, 360, 16},
    { 744, 104, 40},
    { 792, 80, 168},
    { 824, 192, 96},
    { 792, 224, 96},
    { 832, 304, -8},
    { 960, 336, -112},
    { 1120, 304, -128},
    { 1256, 304, -128},
    { 1680, 272, 40},
    { 1576, 368, 32},
    { 1016, 360, 8},
    { 1016, 248, 64},
    { 1200, 152, 184},
    // 45 seconds
    { 1032, 104, 192},
    { 864, 96, 160},
    { 808, 72, 120},
    { 800, 16, 120},
    { 776, -24, 96},
    { 888, -32, 104},
    { 1040, -80, 104},
    { 944, -40, 96},
    { 1072, -32, -16},
    { 1432, -112, 96},
    { 1120, 80, 16},
    { 1416, 136, -40},
    { 1232, 328, -88},
    { 792, 296, 32},
    { 776, 216, 32},
    { 824, 224, 112},
    { 920, 272, 104},
    { 864, 360, -8},
    { 920, 384, -80},
    { 1032, 408, -128},
    { 1200, 320, -136},
    { 1512, 232, 40},
    { 1768, 360, 72},
    { 1152, 304, 88},
    { 1136, 208, 112},
    // 46 seconds
    { 1224, 88, 216},
    { 1072, 40, 240},
    { 872, 56, 200},
    { 744, 56, 144},
    { 728, 0, 120},
    { 728, 0, 56},
    { 800, -8, -64},
    { 944, -152, 24},
    { 1064, -160, 112},
    { 1080, -48, 64},
    { 1392, 88, 32},
    { 1176, 264, -32},
    { 1488, 216, -16},
    { 1192, 304, 48},
    { 784, 272, 8},
    { 840, 232, 56},
    { 816, 296, 32},
    { 880, 320, 24},
    { 824, 384, -72},
    { 928, 408, -168},
    { 1000, 376, -176},
    { 1184, 288, -136},
    { 1352, 168, 88},
    { 1840, 352, 104},
    { 1272, 392, 64},
    // 47 seconds
    { 928, 264, 40},
    { 1136, 144, 160},
    { 1104, 40, 256},
    { 928, 96, 192},
    { 808, 104, 120},
    { 792, 64, 104},
    { 776, 24, 88},
    { 784, 8, 48},
    { 832, -40, 64},
    { 1032, -48, -8},
    { 1072, 0, -80},
    { 1584, -144, 176},
    { 1368, 200, 40},
    { 1184, 488, -216},
    { 1224, 384, -56},
    { 960, 296, 184},
    { 720, 248, 72},
    { 728, 328, 192},
    { 760, 520, 72},
    { 744, 416, 96},
    { 792, 384, 0},
    { 864, 336, -32},
    { 1104, 376, -80},
    { 1248, 408, -16},
    { 1880, 296, 40},
    // 48 seconds
    { 1488, 456, 0},
    { 984, 488, -64},
    { 1072, 312, 48},
    { 1288, 144, 152},
    { 1040, 104, 192},
    { 848, 48, 160},
    { 760, 32, 128},
    { 720, 32, 72},
    { 704, -16, 56},
    { 760, -72, 80},
    { 944, -104, 16},
    { 1032, -56, -16},
    { 1304, -168, 32},
    { 1512, -64, 80},
    { 1448, 200, -120},
    { 1400, 448, -136},
    { 1008, 488, 96},
    { 728, 264, 112},
    { 768, 160, 104},
    { 776, 152, 136},
    { 800, 224, 88},
    { 768, 256, 16},
    { 904, 288, -72},
    { 1128, 400, -128},
    { 1128, 128, 32},
    // 49 seconds
    { 1512, 128, 128},
    { 1584, 360, 64},
    { 1064, 296, 80},
    { 1080, 216, 72},
    { 1184, 112, 208},
    { 984, 80, 224},
    { 872, 56, 176},
    { 784, 32, 144},
    { 792, 16, 120},
    { 824, -8, 120},
    { 864, -40, 120},
    { 928, -80, 136},
    { 1000, -48, 40},
    { 1192, -256, 96},
    { 1464, -120, 120},
    { 1136, 152, -32},
    { 1256, 200, -176},
    { 1056, 176, 48},
    { 744, 168, 72},
    { 816, 184, 112},
    { 848, 248, 160},
    { 880, 280, 120},
    { 864, 312, 32},
    { 984, 368, -104},
    { 1128, 304, -104},
    // 50 seconds
    { 1216, 264, -64},
    { 1800, 264, 88},
    { 1536, 392, 48},
    { 912, 304, 32},
    { 1024, 200, 96},
    { 1200, 144, 200},
    { 1008, 136, 208},
    { 792, 72, 168},
    { 736, 40, 128},
    { 728, 8, 136},
    { 776, -8, 120},
    { 840, -16, 104},
    { 960, -80, 104},
    { 1040, -56, 56},
    { 1296, -144, 112},
    { 1520, -88, 168},
    { 1072, 216, -64},
    { 1152, 168, -96},
    { 1064, 192, 32},
    { 744, 152, 32},
    { 720, 104, 64},
    { 832, 152, 104},
    { 848, 248, 88},
    { 856, 328, 16},
    { 976, 360, -64},
    // 51 seconds
    { 1088, 376, -80},
    { 1280, 304, -96},
    { 1328, 208, 80},
    { 1648, 424, 48},
    { 1216, 528, -8},
    { 920, 312, 80},
    { 1072, 200, 184},
    { 1104, 112, 248},
    { 928, 48, 272},
    { 824, 88, 208},
    { 808, 80, 144},
    { 792, 16, 120},
    { 800, -8, 72},
    { 856, -40, 40},
    { 992, -72, -16},
    { 992, -56, -32},
    { 1496, -168, 72},
    { 1352, 48, 104},
    { 1272, 208, -88},
    { 1264, 256, -96},
    { 944, 320, 32},
    { 752, 112, 56},
    { 792, 152, 80},
    { 848, 200, 80},
    { 856, 272, 48},
    // 52 seconds
    { 864, 336, -56},
    { 952, 384, -160},
    { 1168, 352, -184},
    { 1248, 328, -136},
    { 1608, 296, -40},
    { 1608, 376, 24},
    { 1032, 288, 56},
    { 1032, 200, 136},
    { 1264, 184, 184},
    { 1104, 64, 264},
    { 880, 56, 168},
    { 792, 56, 144},
    { 784, 64, 104},
    { 784, 24, 64},
    { 792, -24, 96},
    { 960, -112, 64},
    { 1096, -72, 0},
    { 1128, -112, 16},
    { 1440, -96, 56},
    { 1264, 168, -112},
    { 1328, 200, -272},
    { 1304, 232, -80},
    { 928, 304, 80},
    { 792, 328, 48},
    { 800, 296, 120},
    // 53 seconds
    { 816, 296, 136},
    { 816, 344, 32},
    { 816, 280, -32},
    { 960, 248, -128},
    { 1344, 272, -128},
    { 1480, 272, 40},
    { 1760, 400, -64},
    { 1208, 376, 0},
    { 1200, 216, 64},
    { 1328, 80, 216},
    { 1160, 24, 280},
    { 944, 8, 248},
    { 848, 24, 200},
    { 824, -8, 184},
    { 768, -48, 112},
    { 736, -24, 48},
    { 824, -96, 48},
    { 992, -128, -16},
    { 1064, -88, -80},
    { 1448, -304, 96},
    { 1328, -24, 112},
    { 1520, 184, 8},
    { 1232, 592, 32},
    { 776, 424, 144},
    { 696, 224, 184},
    // 54 seconds
    { 736, 200, 248},
    { 824, 288, 264},
    { 856, 528, 176},
    { 856, 584, 240},
    { 928, 552, 80},
    { 1184, 480, 192},
    { 1104, 432, 344},
    { 1584, 312, 344},
    { 1328, 408, 216},
    { 1088, 344, 208},
    { 1112, 136, 280},
    { 1096, 48, 272},
    { 896, 120, 208},
    { 784, 168, 96},
    { 744, 96, 104},
    { 752, 16, 72},
    { 728, -72, 80},
    { 776, -96, 80},
    { 1000, -112, 8},
    { 1096, -72, -8},
    { 1584, -208, 160},
    { 1440, 104, 144},
    { 1192, 256, -40},
    { 1312, 280, -24},
    { 928, 408, 128},
    // 55 seconds
    { 800, 216, 120},
    { 816, 200, 104},
    { 784, 208, 88},
    { 760, 232, 16},
    { 792, 320, -56},
    { 968, 376, -176},
    { 1080, 312, -248},
    { 1216, 224, -168},
    { 1544, 96, 40},
    { 1648, 232, 120},
    { 1128, 384, 128},
    { 1040, 248, 136},
    { 1192, 136, 256},
    { 1096, 136, 232},
    { 936, 48, 216},
    { 848, 48, 144},
    { 808, 40, 120},
    { 792, 8, 80},
    { 816, -48, 96},
    { 872, -96, 96},
    { 904, -40, 8},
    { 1024, -72, -56},
    { 1152, -160, 88},
    { 1360, 0, 72},
    { 1360, 200, -128},
    // 56 seconds
    { 1184, 128, -16},
    { 928, 200, 184},
    { 928, 240, 184},
    { 904, 336, 224},
    { 936, 384, 240},
    { 880, 424, 152},
    { 896, 416, 24},
    { 1016, 384, -32},
    { 1192, 472, -144},
    { 1224, 368, 40},
    { 1800, 504, 56},
    { 1152, 424, 104},
    { 1160, 264, 152},
    { 1384, 168, 288},
    { 1240, 112, 296},
    { 1000, 80, 216},
    { 872, 64, 160},
    { 856, 24, 152},
    { 800, -8, 104},
    { 784, -40, 96},
    { 848, -64, 80},
    { 928, -80, 8},
    { 936, -72, -64},
    { 1408, -232, 128},
    { 1520, 24, 160},
    // 57 seconds
    { 1464, 312, -152},
    { 1280, 288, -144},
    { 984, 224, 88},
    { 824, 168, 112},
    { 944, 272, 104},
    { 952, 328, 104},
    { 848, 336, 48},
    { 808, 360, -64},
    { 856, 360, -120},
    { 1112, 400, -152},
    { 1320, 344, -56},
    { 1504, 280, 88},
    { 1552, 416, 16},
    { 1040, 304, 80},
    { 1192, 208, 168},
    { 1304, 120, 280},
    { 1112, 160, 216},
    { 960, 112, 136},
    { 832, 128, 56},
    { 832, 24, 48},
    { 760, 0, 64},
    { 696, -48, 16},
    { 696, -104, 64},
    { 888, -32, -32},
    { 984, 40, 24},
    // 58 seconds
    { 1704, 0, 160},
    { 1584, 264, 48},
    { 1360, 288, -120},
    { 1080, 32, -8},
    { 840, 32, 96},
    { 736, 136, 160},
    { 800, 248, 248},
    { 872, 328, 232},
    { 848, 360, 192},
    { 800, 368, 128},
    { 912, 424, 8},
    { 1136, 416, -72},
    { 1264, 304, -40},
    { 1744, 304, 40},
    { 1640, 688, -8},
    { 920, 432, -72},
    { 1152, 280, 24},
    { 1320, 216, 144},
    { 1128, 184, 80},
    { 928, 152, 72},
    { 824, 104, 16},
    { 760, 24, 40},
    { 664, -32, 48},
    { 624, -24, 48},
    { 696, -80, 152},
    // 59 seconds
    { 1040, 144, 16},
    { 1120, 456, -80},
    { 1584, 128, 192},
    { 1448, 256, 264},
    { 1216, 560, 24},
    { 1064, 432, 72},
    { 808, 320, 200},
    { 688, 200, 216},
    { 704, 280, 216},
    { 760, 264, 208},
    { 728, 368, 184},
    { 704, 408, 104},
    { 856, 432, 16},
    { 1168, 528, -72},
    { 1328, 496, -56},
    { 1456, 304, -48},
    { 1320, 336, -32},
    { 1160, 448, -88},
    { 1040, 296, 48},
    { 1200, 168, 184},
    { 1024, 120, 224},
    { 864, 136, 96},
    { 808, 104, 88},
    { 768, 56, 80},
    { 760, 16, 32},
    // 60 seconds
    // elapsed: 1 minutes
    { 744, 16, 48},
    { 760, -32, 32},
    { 896, -16, -24},
    { 1072, 32, -72},
    { 1400, -152, 64},
    { 1736, 0, 136},
    { 1424, 344, -168},
    { 1096, 296, -168},
    { 912, 288, 8},
    { 680, 112, 80},
    { 712, 120, 184},
    { 768, 232, 160},
    { 752, 240, 184},
    { 760, 360, 40},
    { 896, 408, -24},
    { 1104, 424, -80},
    { 1240, 312, -40},
    { 1640, 272, 16},
    { 1608, 432, -16},
    { 984, 336, 0},
    { 1056, 272, 56},
    { 1200, 200, 128},
    { 1056, 200, 152},
    { 944, 144, 88},
    { 856, 64, 24},
    // 61 seconds
    { 768, -32, 0},
    { 720, -32, -8},
    { 768, -32, 0},
    { 808, -96, 40},
    { 1000, -8, 16},
    { 1080, -56, 24},
    { 1696, -48, 128},
    { 1416, 256, -80},
    { 1032, 160, -224},
    { 1184, 104, -8},
    { 832, 296, 128},
    { 744, 200, 120},
    { 776, 168, 136},
    { 832, 168, 176},
    { 728, 240, 48},
    { 768, 216, -8},
    { 992, 392, -224},
    { 1200, 336, -208},
    { 1336, 288, -128},
    { 1792, 336, -96},
    { 1424, 376, -96},
    { 912, 272, -80},
    { 952, 192, 8},
    { 1088, 128, 88},
    { 1024, 144, 88},
    // 62 seconds
    { 880, 80, 96},
    { 832, 48, 40},
    { 800, 40, 32},
    { 768, 32, 0},
    { 792, 8, -16},
    { 1024, -8, -16},
    { 1072, 0, -40},
    { 1336, -224, 96},
    { 1424, -56, 152},
    { 1064, 280, -176},
    { 1112, 152, -216},
    { 960, 144, -136},
    { 680, 48, -24},
    { 712, 72, -32},
    { 760, 320, 88},
    { 824, 352, 24},
    { 840, 344, -72},
    { 968, 352, -120},
    { 1064, 336, -128},
    { 1288, 328, -120},
    { 1520, 304, 72},
    { 1640, 392, 72},
    { 1128, 360, -8},
    { 872, 216, 48},
    { 1264, -448, 232},
    // 63 seconds
    { 1128, 192, 8},
    { 784, 104, 176},
    { 768, 96, 88},
    { 704, 32, 48},
    { 712, 16, 24},
    { 760, 8, -16},
    { 888, -64, -8},
    { 1096, 0, -112},
    { 1176, 80, -184},
    { 1848, -80, -8},
    { 1536, 152, -48},
    { 1024, 296, -88},
    { 896, 216, -48},
    { 728, 120, 104},
    { 640, 56, 104},
    { 736, 128, 16},
    { 776, 96, 208},
    { 816, 312, 88},
    { 840, 368, 64},
    { 960, 496, -128},
    { 1216, 352, -152},
    { 1272, 208, -160},
    { 1896, 232, -104},
    { 1512, 336, -96},
    { 904, 216, -56},
    // 64 seconds
    { 952, 248, 0},
    { 1112, 192, 104},
    { 984, 144, 152},
    { 808, 96, 120},
    { 736, 88, 80},
    { 752, 64, 80},
    { 776, 16, 80},
    { 848, 24, 120},
    { 1024, 24, 16},
    { 992, -16, -56},
    { 1496, -224, 112},
    { 1336, 0, 32},
    { 1232, 192, -168},
    { 1216, 240, -296},
    { 936, 256, -32},
    { 720, 208, -96},
    { 736, 240, 32},
    { 800, 280, 32},
    { 864, 304, 48},
    { 856, 328, -80},
    { 856, 432, -232},
    { 1008, 552, -256},
    { 1384, 168, 16},
    { 1824, 152, -32},
    { 1544, 312, -32},
    // 65 seconds
    { 888, 320, -128},
    { 960, 256, -24},
    { 1168, 176, 120},
    { 984, 112, 96},
    { 816, 40, 80},
    { 776, 96, 72},
    { 760, 72, 16},
    { 744, 8, 48},
    { 832, -16, 32},
    { 968, -72, 48},
    { 1024, -16, -48},
    { 1120, -48, -16},
    { 1568, -48, 8},
    { 1168, 128, -104},
    { 1336, 40, -120},
    { 1128, 224, -64},
    { 640, 208, -16},
    { 664, 184, 32},
    { 728, 168, 112},
    { 856, 264, 120},
    { 840, 312, 72},
    { 920, 312, -56},
    { 952, 328, -168},
    { 1304, 304, -144},
    { 1248, 216, 0},
    // 66 seconds
    { 1976, 352, 40},
    { 1272, 352, -24},
    { 888, 232, -48},
    { 1048, 104, 56},
    { 1088, 88, 152},
    { 912, 120, 144},
    { 768, 96, 64},
    { 712, 80, 96},
    { 712, 64, 40},
    { 760, -16, 88},
    { 920, -48, 104},
    { 1080, -16, 24},
    { 1048, -24, 0},
    { 1672, -120, 168},
    { 1336, 168, 48},
    { 1144, 224, -208},
    { 1056, 208, -184},
    { 768, 176, -64},
    { 760, 144, -32},
    { 800, 176, 8},
    { 856, 200, 72},
    { 848, 320, -80},
    { 888, 304, -88},
    { 968, 336, -224},
    { 1184, 240, -168},
    // 67 seconds
    { 1216, 216, -112},
    { 1808, 224, -32},
    { 1384, 328, -48},
    { 936, 208, 0},
    { 1104, 200, 40},
    { 1216, 128, 144},
    { 976, 80, 144},
    { 768, 48, 88},
    { 736, 64, 80},
    { 768, 48, 72},
    { 712, -8, 32},
    { 824, -72, 64},
    { 1000, -88, 32},
    { 1064, 0, -48},
    { 1488, -216, 24},
    { 1512, 16, -8},
    { 1040, 224, -216},
    { 1208, 160, -176},
    { 976, 264, -8},
    { 704, 168, 0},
    { 744, 152, 56},
    { 776, 192, 72},
    { 816, 256, 32},
    { 864, 264, -32},
    { 976, 320, -136},
    // 68 seconds
    { 1072, 288, -184},
    { 1224, 248, -200},
    { 1424, 128, -32},
    { 1704, 288, -32},
    { 1104, 344, -56},
    { 944, 248, 0},
    { 1152, 168, 104},
    { 1080, 128, 184},
    { 840, 32, 144},
    { 752, -16, 104},
    { 728, 64, 64},
    { 760, 48, 72},
    { 768, 16, 32},
    { 888, -48, 64},
    { 1048, -32, 32},
    { 1040, -32, 24},
    { 1608, -64, 184},
    { 1232, 160, 80},
    { 1192, 192, -120},
    { 1056, 168, -104},
    { 776, 144, 0},
    { 632, 552, -32},
    { 816, 184, -80},
    { 824, 88, 56},
    { 872, 288, -56},
    // 69 seconds
    { 864, 320, -128},
    { 960, 344, -224},
    { 1240, 288, -168},
    { 1176, 192, -64},
    { 1840, 272, 40},
    { 1312, 368, 24},
    { 856, 320, -8},
    { 1032, 256, 96},
    { 1208, 152, 224},
    { 984, 144, 160},
    { 792, 64, 144},
    { 712, 64, 0},
    { 744, 32, -16},
    { 832, 56, -32},
    { 824, -8, -16},
    { 976, -88, -24},
    { 1072, 56, -176},
    { 1392, -264, -32},
    { 1544, 120, 56},
    { 1144, 240, -232},
    { 1256, 192, -184},
    { 864, 336, -40},
    { 592, 176, -48},
    { 704, 192, 32},
    { 760, 232, 32},
    // 70 seconds
    { 840, 272, 0},
    { 896, 400, -120},
    { 888, 368, -168},
    { 1248, 560, -168},
    { 1040, 392, -328},
    { 1736, 416, -192},
    { 1496, 520, -160},
    { 936, 384, -112},
    { 1008, 336, -32},
    { 1136, 176, 104},
    { 992, 152, 112},
    { 840, 136, 48},
    { 744, 16, 96},
    { 776, 48, -16},
    { 856, 128, -64},
    { 768, 40, -80},
    { 920, -24, -80},
    { 992, 72, -168},
    { 1272, -64, -152},
    { 1632, 40, -24},
    { 1176, 304, -256},
    { 1160, 368, -368},
    { 1016, 368, -104},
    { 704, 224, -56},
    { 728, 184, -8},
    // 71 seconds
    { 784, 208, 32},
    { 776, 304, -80},
    { 824, 248, -80},
    { 880, 416, -304},
    { 984, 360, -288},
    { 1168, 344, -256},
    { 1640, 312, -88},
    { 1720, 416, -48},
    { 984, 408, -48},
    { 1024, 320, 16},
    { 1192, 240, 96},
    { 992, 128, 152},
    { 808, 152, 64},
    { 760, 120, 40},
    { 760, 72, 56},
    { 800, 40, 32},
    { 872, -8, 48},
    { 976, -80, 48},
    { 1080, 0, -40},
    { 1232, -104, -56},
    { 1504, -8, 88},
    { 1064, 128, -88},
    { 1280, 152, -192},
    { 984, 232, -144},
    { 624, 144, -40},
    // 72 seconds
    { 712, 248, -16},
    { 776, 224, 64},
    { 824, 240, 40},
    { 856, 304, 24},
    { 952, 352, -72},
    { 1080, 376, -136},
    { 1256, 344, -144},
    { 1464, 272, 24},
    { 1656, 424, -40},
    { 1080, 536, 8},
    { 1040, 448, -8},
    { 1192, 296, 136},
    { 968, 200, 136},
    { 896, 104, 136},
    { 856, 40, 128},
    { 840, 40, 80},
    { 792, 8, 72},
    { 784, -8, 48},
    { 968, -48, 48},
    { 1040, 0, -40},
    { 960, -80, -88},
    { 1592, -168, 128},
    { 1216, 160, -48},
    { 1248, 264, -232},
    { 1160, 352, -168},
    // 73 seconds
    { 784, 160, 72},
    { 768, 200, 56},
    { 784, 232, 104},
    { 912, 312, 80},
    { 832, 376, 8},
    { 840, 416, -168},
    { 944, 440, -240},
    { 1192, 400, -272},
    { 1256, 256, -144},
    { 1720, 408, -96},
    { 1360, 464, -40},
    { 1096, 336, 32},
    { 1152, 232, 136},
    { 1128, 160, 216},
    { 976, 136, 160},
    { 808, 80, 112},
    { 768, 72, 56},
    { 784, 8, 72},
    { 816, 0, -8},
    { 864, -24, 0},
    { 1008, -104, -8},
    { 976, -32, -112},
    { 1416, -224, 64},
    { 1360, 64, -24},
    { 1208, 184, -104},
    // 74 seconds
    { 1232, 256, -128},
    { 1016, 360, -64},
    { 792, 224, -32},
    { 840, 224, 48},
    { 832, 296, 16},
    { 840, 312, -8},
    { 816, 352, -96},
    { 920, 392, -192},
    { 1128, 416, -184},
    { 1224, 336, -176},
    { 1776, 352, -96},
    { 1480, 456, -112},
    { 968, 344, -72},
    { 1136, 288, 8},
    { 1272, 216, 104},
    { 1088, 104, 104},
    { 904, 96, 80},
    { 832, 96, 24},
    { 824, 32, 24},
    { 760, -24, 8},
    { 776, -88, 40},
    { 848, -136, 40},
    { 936, -24, -72},
    { 1336, -208, 64},
    { 1464, 72, 80},
    // 75 seconds
    { 1240, 232, -104},
    { 1408, 392, -248},
    { 1072, 432, -24},
    { 736, 200, -24},
    { 800, 248, 0},
    { 824, 304, -32},
    { 912, 368, -64},
    { 840, 352, -208},
    { 952, 384, -232},
    { 1136, 240, -248},
    { 1168, 240, -184},
    { 1848, 224, -56},
    { 1528, 392, -32},
    { 952, 248, -24},
    { 1032, 184, 32},
    { 1160, 64, 152},
    { 936, 8, 176},
    { 800, 24, 128},
    { 760, 24, 104},
    { 752, -16, 72},
    { 808, 16, 40},
    { 896, -56, 32},
    { 1008, -144, 40},
    { 1048, -104, -24},
    { 1184, -264, -40},
    // 76 seconds
    { 1376, -136, 56},
    { 1144, 144, -88},
    { 1208, 192, -176},
    { 1056, 240, -72},
    { 816, 112, 24},
    { 776, 176, -8},
    { 824, 168, 56},
    { 888, 264, -16},
    { 904, 264, -24},
    { 976, 336, -160},
    { 1112, 328, -216},
    { 1296, 264, -216},
    { 1568, 104, -96},
    { 1696, 280, -32},
    { 920, 296, -32},
    { 976, 224, 32},
    { 1168, 64, 208},
    { 1112, 8, 272},
    { 896, 72, 200},
    { 776, 72, 96},
    { 760, 32, 72},
    { 760, -16, 32},
    { 816, -40, 24},
    { 840, -128, 40},
    { 1024, -104, -16},
    // 77 seconds
    { 1048, -56, -104},
    { 1520, -176, 64},
    { 1408, 112, 32},
    { 1128, 264, -152},
    { 1104, 288, -120},
    { 872, 160, 56},
    { 608, 160, 88},
    { 784, 176, 40},
    { 832, 256, 40},
    { 840, 312, -40},
    { 904, 368, -104},
    { 976, 392, -192},
    { 1208, 320, -216},
    { 1296, 176, -88},
    { 1896, 312, 0},
    { 1240, 376, -32},
    { 896, 280, 0},
    { 1072, 168, 104},
    { 1120, 96, 176},
    { 1000, 56, 160},
    { 864, 56, 112},
    { 776, 48, 16},
    { 800, 24, 40},
    { 776, -8, 0},
    { 864, -80, 24},
    // 78 seconds
    { 1016, -112, 8},
    { 992, -56, -48},
    { 1448, -232, 64},
    { 1440, 0, 112},
    { 1120, 240, -48},
    { 1192, 288, -176},
    { 936, 232, 16},
    { 712, 184, 40},
    { 808, 184, 56},
    { 888, 264, 48},
    { 848, 304, 40},
    { 816, 360, -104},
    { 952, 384, -192},
    { 1072, 360, -240},
    { 1192, 264, -184},
    { 1648, 184, -40},
    { 1536, 312, 8},
    { 1000, 344, -16},
    { 1024, 272, 40},
    { 1168, 160, 152},
    { 1072, 144, 112},
    { 928, 104, 128},
    { 808, 88, 16},
    { 792, 8, 48},
    { 736, -32, 16},
    // 79 seconds
    { 792, -56, 24},
    { 936, -112, 32},
    { 944, -48, 16},
    { 1016, -96, -16},
    { 1608, -56, 144},
    { 1336, 184, 24},
    { 1496, 408, -176},
    { 1032, 440, -152},
    { 704, 120, -16},
    { 768, 168, 24},
    { 704, 184, 40},
    { 800, 224, 72},
    { 856, 336, 0},
    { 928, 376, -56},
    { 992, 400, -120},
    { 1152, 432, -176},
    { 1408, 272, 8},
    { 1632, 352, 24},
    { 1072, 328, 16},
    { 1096, 272, 56},
    { 1216, 176, 152},
    { 1104, 72, 168},
    { 952, 80, 120},
    { 848, 80, 40},
    { 800, 16, 40},
    // 80 seconds
    { 784, -8, -32},
    { 808, -40, -40},
    { 880, -96, -16},
    { 1056, -80, -48},
    { 1080, -96, -64},
    { 1544, -168, 120},
    { 1376, 168, -16},
    { 1168, 304, -152},
    { 1208, 216, -48},
    { 784, 176, 64},
    { 744, 184, 96},
    { 800, 296, 136},
    { 832, 328, 104},
    { 808, 352, 48},
    { 800, 320, -64},
    { 968, 464, 40},
    { 1136, 440, -256},
    { 1264, 136, -128},
    { 1752, 272, -56},
    { 1240, 432, -184},
    { 896, 264, -104},
    { 1088, 160, 8},
    { 1136, 168, 16},
    { 984, 88, 40},
    { 856, 104, -56},
    // 81 seconds
    { 792, 48, -56},
    { 784, -16, -24},
    { 776, -48, -8},
    { 776, -72, 0},
    { 952, -64, 16},
    { 1016, 32, -88},
    { 1344, -192, 96},
    { 1664, -72, 304},
    { 1336, 328, -64},
    { 1072, 488, -240},
    { 960, 352, -56},
    { 664, 128, 56},
    { 720, 152, 96},
    { 752, 232, 112},
    { 776, 280, 96},
    { 736, 384, -48},
    { 856, 376, -120},
    { 1104, 336, -200},
    { 1344, 288, -144},
    { 1720, 288, -16},
    { 1648, 320, 40},
    { 1008, 368, -64},
    { 848, 304, -40},
    { 992, 104, 40},
    { 1104, 40, 96},
    // 82 seconds
    { 880, 64, 88},
    { 736, 80, -8},
    { 728, 40, -8},
    { 712, -32, 16},
    { 640, -72, 32},
    { 600, -48, 48},
    { 800, 8, 24},
    { 1216, 24, 8},
    { 1416, 0, 80},
    { 1960, 32, 232},
    { 1464, 448, -112},
    { 976, 544, -184},
    { 976, 328, 0},
    { 712, 128, 24},
    { 624, 72, 128},
    { 616, 168, 80},
    { 664, 280, 64},
    { 696, 256, 96},
    { 776, 336, -16},
    { 1024, 400, -80},
    { 1184, 312, -80},
    { 1272, 264, -56},
    { 1648, 248, -48},
    { 1352, 392, -72},
    { 936, 344, -8},
    // 83 seconds
    { 1104, 200, 120},
    { 1128, 120, 176},
    { 888, 168, 136},
    { 816, 200, 48},
    { 784, 128, 24},
    { 792, 32, 64},
    { 768, -32, 56},
    { 792, -40, 40},
    { 944, -40, 40},
    { 976, 32, -24},
    { 1464, -184, 168},
    { 1528, -16, 240},
    { 1176, 376, -112},
    { 1080, 360, -168},
    { 912, 224, 56},
    { 704, 64, 56},
    { 728, 144, 88},
    { 808, 272, 40},
    { 840, 360, 16},
    { 832, 360, -64},
    { 968, 368, -144},
    { 1144, 304, -152},
    { 1176, 240, -112},
    { 1672, 224, -8},
    { 1536, 336, 24},
    // 84 seconds
    { 984, 352, -16},
    { 1000, 256, 88},
    { 1208, 136, 152},
    { 1000, 120, 200},
    { 824, 112, 128},
    { 752, 104, 56},
    { 760, 48, 96},
    { 728, -8, 72},
    { 728, 0, 56},
    { 848, -72, 96},
    { 1008, -24, 40},
    { 1208, -80, 128},
    { 1608, -88, 232},
    { 1320, 256, -32},
    { 1208, 400, -176},
    { 992, 304, -32},
    { 728, 112, 32},
    { 736, 152, 48},
    { 760, 160, 104},
    { 784, 280, -8},
    { 824, 256, -8},
    { 880, 312, -152},
    { 1040, 336, -200},
    { 1248, 248, -168},
    { 1328, 160, 32},
    // 85 seconds
    { 1640, 296, 48},
    { 1264, 440, -8},
    { 872, 328, 64},
    { 1104, 184, 160},
    { 1096, 160, 200},
    { 936, 120, 192},
    { 824, 128, 128},
    { 776, 80, 112},
    { 752, 32, 16},
    { 824, -32, 48},
    { 888, -56, 88},
    { 928, -64, 32},
    { 1056, 32, -24},
    { 1520, -136, 72},
    { 1376, 104, 48},
    { 1240, 368, -144},
    { 1160, 208, -48},
    { 832, 240, 56},
    { 672, 168, 104},
    { 736, 224, 72},
    { 760, 208, 112},
    { 816, 360, 80},
    { 856, 512, -88},
    { 1176, 464, -416},
    { 1064, 280, -160},
    // 86 seconds
    { 1216, 224, 24},
    { 1920, 224, -128},
    { 1208, 464, -56},
    { 1048, 344, -144},
    { 1064, 80, 16},
    { 1104, 72, 128},
    { 856, 136, 104},
    { 768, 144, 48},
    { 736, 72, 64},
    { 736, -8, 88},
    { 808, -8, 48},
    { 904, -64, 120},
    { 1048, -96, 104},
    { 1096, -88, 120},
    { 1576, -184, 208},
    { 1392, 40, 72},
    { 1048, 304, -184},
    { 920, 200, -280},
    { 880, 0, -72},
    { 736, 88, -64},
    { 720, 72, -40},
    { 848, 320, -136},
    { 840, 232, -112},
    { 880, 232, -152},
    { 936, 224, -192},
    // 87 seconds
    { 1104, 216, -192},
    { 1200, 168, -104},
    { 1656, 160, -8},
    { 1544, 264, -8},
    { 1000, 280, -8},
    { 1040, 200, 64},
    { 1216, 112, 120},
    { 976, 32, 184},
    { 840, 64, 80},
    { 768, 56, 8},
    { 736, 8, 8},
    { 760, -32, -32},
    { 736, -72, -24},
    { 792, -136, 0},
    { 1032, -112, -48},
    { 1136, -152, 32},
    { 1592, -88, 88},
    { 1496, 152, -8},
    { 1352, 304, -160},
    { 984, 296, -64},
    { 752, 144, 32},
    { 712, 176, 24},
    { 720, 144, 72},
    { 800, 184, 40},
    { 848, 232, 16},
    // 88 seconds
    { 872, 352, -128},
    { 1032, 368, -240},
    { 1272, 320, -272},
    { 1328, 152, -56},
    { 1768, 264, -40},
    { 1160, 360, -16},
    { 1104, 264, 40},
    { 1248, 112, 192},
    { 1072, 56, 200},
    { 896, 96, 128},
    { 800, 88, 72},
    { 752, 32, 64},
    { 776, -32, 80},
    { 776, -56, 56},
    { 800, -88, 72},
    { 960, -104, 16},
    { 1032, -80, -24},
    { 1472, -216, 24},
    { 1296, -88, 72},
    { 1288, 136, -24},
    { 1344, 296, -152},
    { 1040, 304, 24},
    { 848, 256, 40},
    { 824, 240, 56},
    { 840, 256, 40},
    // 89 seconds
    { 824, 304, 0},
    { 800, 304, -72},
    { 896, 376, -176},
    { 1120, 344, -184},
    { 1136, 312, -192},
    { 1344, 200, 32},
    { 1496, 320, 56},
    { 1288, 400, 0},
    { 1104, 296, 96},
    { 1224, 160, 176},
    { 1096, 112, 216},
    { 936, 104, 192},
    { 904, 112, 112},
    { 856, 24, 112},
    { 784, -24, 88},
    { 800, -48, 56},
    { 864, -104, 56},
    { 904, -80, -16},
    { 928, -56, -168},
    { 1480, -280, 56},
    { 1304, 8, 40},
    { 1448, 232, -96},
    { 1352, 416, -176},
    { 912, 304, 48},
    { 824, 264, 80},
    // 90 seconds
    { 792, 224, 128},
    { 848, 288, 80},
    { 768, 336, 24},
    { 824, 360, -72},
    { 984, 416, -168},
    { 1128, 376, -200},
    { 1208, 336, -96},
    { 2000, 432, 8},
    { 1272, 456, 64},
    { 1120, 368, 40},
    { 1248, 216, 176},
    { 1256, 80, 272},
    { 1008, 64, 208},
    { 880, 104, 144},
    { 824, 48, 112},
    { 784, -40, 112},
    { 776, -48, 72},
    { 768, -96, 72},
    { 864, -120, 24},
    { 960, -88, -24},
    { 1416, -248, 64},
    { 1528, -104, 136},
    { 1400, 224, -64},
    { 1360, 416, -208},
    { 1072, 272, 88},
    // 91 seconds
    { 816, 248, 112},
    { 880, 240, 120},
    { 864, 304, 88},
    { 840, 304, 104},
    { 896, 408, -24},
    { 808, 384, -96},
    { 1088, 384, -144},
    { 1216, 304, -112},
    { 1656, 264, -64},
    { 1496, 360, 0},
    { 1136, 256, 64},
    { 1136, 176, 144},
    { 1248, 72, 224},
    { 1088, 40, 232},
    { 952, 56, 176},
    { 880, 40, 112},
    { 856, -16, 96},
    { 840, -64, 64},
    { 808, -112, 48},
    { 864, -152, 32},
    { 888, -120, -40},
    { 968, -192, -88},
    { 1408, -336, 40},
    { 1272, 8, 16},
    { 1392, 104, -104},
    // 92 seconds
    { 1392, 176, -32},
    { 1032, 208, 104},
    { 872, 232, 112},
    { 888, 232, 112},
    { 904, 184, 168},
    { 864, 288, 0},
    { 872, 384, -112},
    { 968, 392, -176},
    { 1200, 344, -216},
    { 1280, 248, -72},
    { 1752, 272, 16},
    { 1520, 360, 8},
    { 944, 272, 40},
    { 1136, 152, 120},
    { 1288, 16, 240},
    { 1072, 8, 208},
    { 944, 48, 144},
    { 856, 48, 72},
    { 776, 8, 48},
    { 728, -32, 24},
    { 728, -96, 16},
    { 792, -144, -16},
    { 896, -120, -88},
    { 1112, -272, 0},
    { 1528, -128, 128},
    // 93 seconds
    { 1448, 152, 48},
    { 1480, 336, -120},
    { 1160, 368, 24},
    { 856, 192, 80},
    { 864, 224, 120},
    { 864, 248, 104},
    { 848, 336, 32},
    { 808, 344, -24},
    { 872, 448, -208},
    { 1048, 408, -216},
    { 1224, 384, -184},
    { 1392, 216, 72},
    { 1672, 296, 96},
    { 1328, 280, 120},
    { 1352, 160, 200},
    { 1360, 32, 280},
    { 1128, 32, 256},
    { 904, 24, 200},
    { 800, 32, 136},
    { 768, -24, 80},
    { 736, -88, 72},
    { 736, -104, 40},
    { 792, -128, 8},
    { 880, -128, -64},
    { 976, -152, -104},
    // 94 seconds
    { 1584, -272, 144},
    { 1592, 40, 48},
    { 1536, 280, -168},
    { 1312, 264, -16},
    { 912, 216, 104},
    { 856, 168, 136},
    { 872, 176, 120},
    { 832, 248, 104},
    { 792, 312, 0},
    { 840, 344, -88},
    { 992, 384, -144},
    { 1192, 360, -168},
    { 1296, 280, -72},
    { 1832, 320, -8},
    { 1456, 384, 0},
    { 976, 272, 40},
    { 1168, 200, 80},
    { 1312, -8, 240},
    { 1056, 16, 224},
    { 920, 48, 160},
    { 848, 48, 128},
    { 816, -16, 96},
    { 760, -96, 80},
    { 744, -176, 32},
    { 848, -208, 0},
    // 95 seconds
    { 960, -120, -56},
    { 1472, -208, 32},
    { 1528, -96, 72},
    { 1336, 216, -128},
    { 1392, 184, -88},
    { 1184, 360, 48},
    { 888, 280, 80},
    { 888, 264, 96},
    { 824, 200, 88},
    { 800, 232, 40},
    { 784, 224, -24},
    { 904, 352, -128},
    { 1072, 344, -128},
    { 1240, 360, -152},
    { 1648, 248, 0},
    { 1616, 272, 40},
    { 1072, 304, 0},
    { 1080, 224, 56},
    { 1328, 56, 184},
    { 1176, 24, 240},
    { 960, 72, 208},
    { 824, 104, 120},
    { 792, 16, 112},
    { 784, -32, 80},
    { 808, -80, 88},
    // 96 seconds
    { 880, -112, 48},
    { 944, -112, -16},
    { 1064, -224, 48},
    { 1536, -224, 136},
    { 1256, 112, -32},
    { 1272, 152, -136},
    { 1272, 176, -16},
    { 920, 168, 112},
    { 904, 240, 40},
    { 952, 248, 160},
    { 912, 392, 72},
    { 832, 360, 16},
    { 928, 400, -104},
    { 1048, 360, -168},
    { 1216, 296, -136},
    { 1464, 160, 24},
    { 1696, 224, 120},
    { 1136, 280, 80},
    { 1120, 128, 128},
    { 1216, 56, 224},
    { 1064, 0, 264},
    { 904, 16, 216},
    { 784, 40, 128},
    { 784, 0, 128},
    { 816, -24, 112},
    // 97 seconds
    { 792, -56, 88},
    { 880, -112, 80},
    { 1000, -104, 8},
    { 1136, -256, 120},
    { 1464, -264, 192},
    { 1248, 128, 8},
    { 1208, 152, -128},
    { 1208, 112, -40},
    { 928, 112, 136},
    { 864, 216, 88},
    { 888, 296, 136},
    { 896, 368, 104},
    { 880, 296, 24},
    { 912, 320, -104},
    { 1008, 336, -176},
    { 1184, 304, -184},
    { 1304, 184, 48},
    { 1736, 264, 88},
    { 1264, 376, 24},
    { 1008, 240, 104},
    { 1176, 120, 232},
    { 1200, 40, 264},
    { 1000, 32, 240},
    { 888, 48, 184},
    { 848, 24, 120},
    // 98 seconds
    { 784, 0, 96},
    { 760, -16, 72},
    { 808, -64, 88},
    { 960, -72, -16},
    { 928, -88, -64},
    { 1384, -192, 8},
    { 1416, -32, 24},
    { 1376, 184, -152},
    { 1344, 192, -112},
    { 1096, 248, 104},
    { 896, 232, 48},
    { 840, 224, 160},
    { 864, 296, 96},
    { 776, 312, 136},
    { 728, 400, -32},
    { 880, 392, -120},
    { 1168, 392, -136},
    { 1360, 408, -168},
    { 1736, 320, -104},
    { 1656, 264, -16},
    { 1000, 192, 40},
    { 1120, 112, 144},
    { 1312, 96, 208},
    { 1040, 8, 296},
    { 840, 40, 224},
    // 99 seconds
    { 744, 96, 152},
    { 824, 72, 144},
    { 792, -32, 152},
    { 768, -32, 104},
    { 840, -72, 32},
    { 856, -80, -16},
    { 1000, -56, -104},
    { 1504, -144, 64},
    { 1440, 120, 8},
    { 1440, 208, -96},
    { 1304, 248, -24},
    { 904, 296, 112},
    { 752, 288, 72},
    { 784, 216, 168},
    { 848, 272, 136},
    { 840, 296, 88},
    { 872, 368, -56},
    { 936, 384, -128},
    { 1240, 416, -216},
    { 1304, 280, -40},
    { 1840, 280, 40},
    { 1352, 376, 24},
    { 960, 272, 80},
    { 1168, 128, 216},
    { 1232, 24, 280},
    // 100 seconds
    { 984, 56, 232},
    { 840, 72, 160},
    { 824, 72, 64},
    { 792, -32, 128},
    { 824, 16, 72},
    { 888, 0, 32},
    { 888, -72, -8},
    { 960, -72, -72},
    { 1288, -208, 24},
    { 1352, -112, 152},
    { 1224, 216, 0},
    { 1432, 272, -24},
    { 1200, 384, 104},
    { 840, 328, 80},
    { 792, 144, 144},
    { 824, 176, 112},
    { 792, 272, 48},
    { 784, 344, -40},
    { 968, 376, -136},
    { 1048, 368, -144},
    { 1248, 360, -96},
    { 1304, 312, 96},
    { 1648, 344, 120},
    { 1160, 360, 16},
    { 1064, 240, 64},
    // 101 seconds
    { 1256, 136, 152},
    { 1160, 56, 232},
    { 944, 24, 224},
    { 856, 64, 160},
    { 832, 24, 144},
    { 760, -16, 96},
    { 720, -32, 112},
    { 784, -40, 48},
    { 920, -72, -8},
    { 960, -88, -56},
    { 1528, -168, 128},
    { 1456, 72, 64},
    { 1408, 296, -152},
    { 1288, 200, -72},
    { 912, 152, 168},
    { 840, 192, 120},
    { 872, 240, 112},
    { 904, 296, 152},
    { 856, 344, 112},
    { 856, 424, 32},
    { 976, 440, -136},
    { 1128, 392, -136},
    { 1160, 64, 48},
    { 1744, 320, 72},
    { 1408, 408, 48},
    // 102 seconds
    { 976, 216, 80},
    { 1160, 144, 192},
    { 1280, 40, 320},
    { 1048, 72, 272},
    { 936, 40, 240},
    { 904, 40, 160},
    { 856, -8, 152},
    { 840, -24, 112},
    { 824, -72, 112},
    { 896, -144, 48},
    { 968, -136, -24},
    { 1128, -264, 16},
    { 1224, -136, 104},
    { 1184, 104, 0},
    { 1352, 136, -104},
    { 1296, 184, 56},
    { 960, 232, 120},
    { 904, 296, 152},
    { 920, 304, 152},
    { 872, 248, 144},
    { 912, 256, 64},
    { 880, 312, -104},
    { 1064, 312, -176},
    { 1232, 304, -160},
    { 1656, 216, -64},
    // 103 seconds
    { 1536, 288, 64},
    { 968, 184, 120},
    { 1136, 176, 128},
    { 1304, 32, 296},
    { 1112, -8, 304},
    { 992, 0, 280},
    { 864, 40, 184},
    { 824, 16, 120},
    { 824, -32, 112},
    { 832, -72, 128},
    { 928, -112, 96},
    { 1104, 32, 64},
    { 912, -312, 8},
    { 1256, -304, 88},
    { 1312, 0, 32},
    { 1232, 136, -152},
    { 1168, 88, -80},
    { 1016, 144, 56},
    { 960, 168, 104},
    { 968, 192, 120},
    { 944, 232, 120},
    { 896, 288, 0},
    { 880, 272, -48},
    { 960, 336, -160},
    { 1160, 304, -176},
    // 104 seconds
    { 1264, 216, -8},
    { 1936, 240, 48},
    { 1352, 336, 48},
    { 1048, 176, 64},
    { 1208, 72, 144},
    { 1280, 80, 192},
    { 1064, -16, 224},
    { 832, -24, 176},
    { 808, -16, 136},
    { 824, -80, 152},
    { 768, -64, 104},
    { 784, -40, 96},
    { 840, -72, 40},
    { 920, -64, -16},
    { 1208, -248, 56},
    { 1408, -160, 232},
    { 1432, 320, 48},
    { 1304, 480, -80},
    { 1064, 432, 8},
    { 880, 256, 120},
    { 872, 280, 144},
    { 888, 304, 168},
    { 872, 384, 64},
    { 792, 320, 16},
    { 840, 384, -160},
    // 105 seconds
    { 1008, 312, -120},
    { 1216, 352, -120},
    { 1456, 256, 80},
    { 1480, 384, 48},
    { 1032, 400, 8},
    { 1272, 240, 152},
    { 1320, 168, 264},
    { 1096, 136, 232},
    { 920, 72, 208},
    { 840, 112, 168},
    { 832, 56, 152},
    { 840, 0, 144},
    { 840, -16, 88},
    { 888, -72, 104},
    { 944, -96, 40},
    { 984, -72, -56},
    { 1400, -216, 64},
    { 1360, 32, 72},
    { 1304, 240, -128},
    { 1248, 176, -112},
    { 1040, 184, 152},
    { 880, 216, 136},
    { 928, 280, 128},
    { 912, 312, 160},
    { 856, 352, 88},
    // 106 seconds
    { 816, 344, -16},
    { 928, 400, -120},
    { 1040, 376, -128},
    { 1216, 384, -136},
    { 1696, 296, 56},
    { 1784, 328, 96},
    { 968, 320, 16},
    { 1040, 264, 24},
    { 1256, 56, 192},
    { 1112, 40, 224},
    { 944, 64, 168},
    { 864, 56, 120},
    { 800, 24, 96},
    { 712, -16, 72},
    { 712, -40, 56},
    { 760, -64, 64},
    { 888, -64, 16},
    { 1120, -176, 80},
    { 1768, -168, 280},
    { 1448, 288, 64},
    { 1160, 496, -264},
    { 1184, 296, 104},
    { 904, 280, 200},
    { 896, 208, 160},
    { 872, 200, 216},
    // 107 seconds
    { 824, 320, 144},
    { 736, 328, 56},
    { 760, 360, -104},
    { 816, 296, -88},
    { 992, 312, -152},
    { 1128, 280, -88},
    { 1544, 136, 96},
    { 1616, 224, 144},
    { 1656, 152, 336},
    { 1304, 120, 232},
    { 1232, 152, 264},
    { 1104, 48, 256},
    { 984, -104, 264},
    { 936, -216, 256},
    { 936, 64, 200},
    { 872, 176, 192},
    { 784, 344, 216},
    { 760, 680, 88},
    { 672, 680, 56},
    { 608, 704, -88},
    { 568, 768, -160},
    { 496, 872, -128},
    { 360, 768, -64},
    { 248, 832, -80},
    { 320, 824, -136},
    // 108 seconds
    { 280, 776, -48},
    { 368, 896, 56},
    { 416, 848, 152},
    { 344, 976, 24},
    { 120, 848, 168},
    { 48, 792, 328},
    { -80, 1048, 32},
    { -56, 1016, 0},
    { -48, 1264, -168},
    { -48, 1320, -272},
    { -152, 832, -296},
    { -288, 496, -544},
    { -144, 448, -752},
    { -72, 192, -768},
    { 8, -8, -864},
    { 96, 8, -928},
    { 184, 24, -1032},
    { 136, -96, -1048},
    { 40, -16, -1024},
    { 176, 0, -1048},
    { 128, -72, -1048},
    { 96, -80, -1040},
    { 56, -104, -1032},
    { 104, -72, -1008},
    { 32, -152, -1016},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

