/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#pragma once

#include <stddef.h>

//! @file ${filename}
//! This file is autogenerated by tools/applib_malloc.py


//! Allocate memory for applib for a given size
void* applib_malloc(size_t size);

//! Allocate memory for applib for a given size and zero the buffer
void* applib_zalloc(size_t size);

//! Deallocate memory previously allocated using applib_malloc
void applib_free(void *ptr);

//! Allocate the appropriate amount of memory for the given type.
#define applib_type_malloc(malloc_type) \
  _applib_type_malloc_## malloc_type()

//! Allocate the appropriate amount of memory for the given type.
#define applib_type_zalloc(malloc_type) \
  _applib_type_zalloc_## malloc_type()

//! Get the size we should allocate for the given type.
#define applib_type_size(malloc_type) \
  _applib_type_size_## malloc_type()
