/* SPDX-FileCopyrightText: 2014-2016 Samsung Electronics Co., Ltd. */
/* SPDX-FileCopyrightText: 2016 University of Szeged */
/* SPDX-License-Identifier: Apache-2.0 */

#ifndef BUILTIN_UNDERSCORED_ID
# error "Please, define BUILTIN_UNDERSCORED_ID"
#endif /* !BUILTIN_UNDERSCORED_ID */

#ifndef BUILTIN_INC_HEADER_NAME
# error "Please, define BUILTIN_INC_HEADER_NAME"
#endif /* !BUILTIN_INC_HEADER_NAME */

#include "ecma-objects.h"

#define PASTE__(x, y) x ## y
#define PASTE_(x, y) PASTE__ (x, y)
#define PASTE(x, y) PASTE_ (x, y)

#define PROPERTY_DESCRIPTOR_LIST_NAME \
  PASTE (PASTE (ecma_builtin_, BUILTIN_UNDERSCORED_ID), _property_descriptor_list)
#define DISPATCH_ROUTINE_ROUTINE_NAME \
  PASTE (PASTE (ecma_builtin_, BUILTIN_UNDERSCORED_ID), _dispatch_routine)

#define ROUTINE_ARG(n) , ecma_value_t arg ## n
#define ROUTINE_ARG_LIST_0 ecma_value_t this_arg
#define ROUTINE_ARG_LIST_1 ROUTINE_ARG_LIST_0 ROUTINE_ARG(1)
#define ROUTINE_ARG_LIST_2 ROUTINE_ARG_LIST_1 ROUTINE_ARG(2)
#define ROUTINE_ARG_LIST_3 ROUTINE_ARG_LIST_2 ROUTINE_ARG(3)
#define ROUTINE_ARG_LIST_NON_FIXED ROUTINE_ARG_LIST_0, \
  const ecma_value_t *arguments_list_p, ecma_length_t arguments_list_len
#define ROUTINE(name, c_function_name, args_number, length_prop_value) \
  static ecma_value_t c_function_name (ROUTINE_ARG_LIST_ ## args_number);
#include BUILTIN_INC_HEADER_NAME
#undef ROUTINE_ARG_LIST_NON_FIXED
#undef ROUTINE_ARG_LIST_3
#undef ROUTINE_ARG_LIST_2
#undef ROUTINE_ARG_LIST_1
#undef ROUTINE_ARG_LIST_0
#undef ROUTINE_ARG

enum
{
  PASTE (ECMA_ROUTINE_START_, BUILTIN_UNDERSCORED_ID) = ECMA_BUILTIN_ID__COUNT - 1,
#define ROUTINE(name, c_function_name, args_number, length_prop_value) \
  ECMA_ROUTINE_ ## name ## c_function_name,
#include BUILTIN_INC_HEADER_NAME
};

/**
 * Built-in property list of the built-in object.
 */
const ecma_builtin_property_descriptor_t PROPERTY_DESCRIPTOR_LIST_NAME[] =
{
#define ROUTINE(name, c_function_name, args_number, length_prop_value) \
  { \
    name, \
    ECMA_BUILTIN_PROPERTY_ROUTINE, \
    ECMA_PROPERTY_CONFIGURABLE_WRITABLE, \
    ECMA_ROUTINE_VALUE (ECMA_ROUTINE_ ## name ## c_function_name, length_prop_value) \
  },
#define OBJECT_VALUE(name, obj_builtin_id, prop_attributes) \
  { \
    name, \
    ECMA_BUILTIN_PROPERTY_OBJECT, \
    prop_attributes, \
    obj_builtin_id \
  },
#define SIMPLE_VALUE(name, simple_value, prop_attributes) \
  { \
    name, \
    ECMA_BUILTIN_PROPERTY_SIMPLE, \
    prop_attributes, \
    simple_value \
  },
#define NUMBER_VALUE(name, number_value, prop_attributes) \
  { \
    name, \
    ECMA_BUILTIN_PROPERTY_NUMBER, \
    prop_attributes, \
    number_value \
  },
#define STRING_VALUE(name, magic_string_id, prop_attributes) \
  { \
    name, \
    ECMA_BUILTIN_PROPERTY_STRING, \
    prop_attributes, \
    magic_string_id \
  },
#include BUILTIN_INC_HEADER_NAME
  {
    LIT_MAGIC_STRING__COUNT,
    ECMA_BUILTIN_PROPERTY_END,
    0,
    0
  }
};

/**
 * Dispatcher of the built-in's routines
 *
 * @return ecma value
 *         Returned value must be freed with ecma_free_value.
 */
ecma_value_t
DISPATCH_ROUTINE_ROUTINE_NAME (uint16_t builtin_routine_id, /**< built-in wide routine
                                                                 identifier */
                               ecma_value_t this_arg_value, /**< 'this' argument
                                                                 value */
                               const ecma_value_t arguments_list[], /**< list of arguments
                                                                         passed to routine */
                               ecma_length_t arguments_number) /**< length of
                                                                    arguments' list */
{
  /* the arguments may be unused for some built-ins */
  JERRY_UNUSED (this_arg_value);
  JERRY_UNUSED (arguments_list);
  JERRY_UNUSED (arguments_number);

  switch (builtin_routine_id)
  {
#define ROUTINE_ARG(n) (arguments_number >= n ? arguments_list[n - 1] \
                                              : ecma_make_simple_value (ECMA_SIMPLE_VALUE_UNDEFINED))
#define ROUTINE_ARG_LIST_0
#define ROUTINE_ARG_LIST_1 , ROUTINE_ARG(1)
#define ROUTINE_ARG_LIST_2 ROUTINE_ARG_LIST_1, ROUTINE_ARG(2)
#define ROUTINE_ARG_LIST_3 ROUTINE_ARG_LIST_2, ROUTINE_ARG(3)
#define ROUTINE_ARG_LIST_NON_FIXED , arguments_list, arguments_number
#define ROUTINE(name, c_function_name, args_number, length_prop_value) \
       case ECMA_ROUTINE_ ## name ## c_function_name: \
       { \
         return c_function_name (this_arg_value ROUTINE_ARG_LIST_ ## args_number); \
       }
#include BUILTIN_INC_HEADER_NAME
#undef ROUTINE_ARG
#undef ROUTINE_ARG_LIST_0
#undef ROUTINE_ARG_LIST_1
#undef ROUTINE_ARG_LIST_2
#undef ROUTINE_ARG_LIST_3
#undef ROUTINE_ARG_LIST_NON_FIXED

    default:
    {
      JERRY_UNREACHABLE ();
    }
  }
} /* DISPATCH_ROUTINE_ROUTINE_NAME */

#undef PASTE__
#undef PASTE_
#undef PASTE
#undef PROPERTY_DESCRIPTOR_LIST_NAME
#undef DISPATCH_ROUTINE_ROUTINE_NAME
#undef BUILTIN_UNDERSCORED_ID
#undef BUILTIN_INC_HEADER_NAME
#undef ECMA_BUILTIN_PROPERTY_NAME_INDEX
