/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#include "resource/resource_ids.auto.h"
#include "resource/resource_storage.h"
#include "resource/resource_storage_impl.h"

#include <limits.h>

#include "clar.h"
#include "fixtures/load_test_resources.h"

// Fakes
#include "fake_app_manager.h"
#include "fake_bootbits.h"

// Stubs
#include "stubs_analytics.h"
#include "stubs_logging.h"
#include "stubs_mutex.h"
#include "stubs_passert.h"
#include "stubs_pbl_malloc.h"
#include "stubs_pebble_tasks.h"
#include "stubs_print.h"
#include "stubs_prompt.h"
#include "stubs_queue.h"
#include "stubs_serial.h"
#include "stubs_sleep.h"
#include "stubs_task_watchdog.h"
#include "stubs_memory_layout.h"

static const uint8_t pug[] = {
    0x08, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3e, 0x00, 0xff, 0xff, 0xfd, 0xff, /* bytes 0 - 16 */
    0xff, 0xff, 0xff, 0x0f, 0x3f, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x07, 0x43, 0xc0, 0xff, /* bytes 16 - 32 */
    0xff, 0xff, 0xff, 0x0f, 0x01, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x80, 0x61, 0x00, 0xff, /* bytes 32 - 48 */
    0xff, 0xff, 0xff, 0x0f, 0x61, 0x00, 0x03, 0xfe, 0xff, 0xff, 0xff, 0x0f, 0x01, 0x02, 0x00, 0xfe, /* bytes 48 - 64 */
    0xff, 0xff, 0xff, 0x0f, 0x11, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x0f, 0x01, 0x00, 0x00, 0xff, /* bytes 64 - 80 */
    0xff, 0xff, 0xff, 0x0f, 0x01, 0x00, 0x00, 0xfe, 0xff, 0x01, 0xff, 0x0f, 0x03, 0x00, 0x00, 0xfe, /* bytes 80 - 96 */
    0xff, 0x4e, 0xfe, 0x0f, 0x03, 0x00, 0x48, 0xf9, 0x7f, 0x86, 0xfc, 0x0f, 0x03, 0x00, 0x18, 0xf3, /* bytes 96 - 112 */
    0x7f, 0x03, 0xf9, 0x0f, 0x07, 0x00, 0x10, 0x02, 0x3e, 0x4b, 0xfb, 0x0f, 0x07, 0x00, 0x00, 0x0b, /* bytes 112 - 128 */
    0x00, 0x78, 0xf8, 0x0f, 0x07, 0x00, 0x60, 0xa6, 0xcb, 0x00, 0xfa, 0x0f, 0x07, 0x00, 0x80, 0x25, /* bytes 128 - 144 */
    0x36, 0x07, 0xfa, 0x0f, 0x0f, 0x00, 0x20, 0x67, 0x34, 0xf9, 0xf3, 0x0f, 0x1f, 0x00, 0x98, 0x49, /* bytes 144 - 160 */
    0xcb, 0xb2, 0xf7, 0x0f, 0x1f, 0x00, 0xc0, 0x4e, 0xda, 0xa6, 0xf6, 0x0f, 0xdf, 0x00, 0x61, 0xd3, /* bytes 160 - 176 */
    0xd4, 0xec, 0xe6, 0x0f, 0xdf, 0x70, 0x36, 0xcf, 0xac, 0x9b, 0xef, 0x0f, 0x5f, 0xc7, 0xd8, 0x4e, /* bytes 176 - 192 */
    0xae, 0x53, 0xfb, 0x0f, 0x5f, 0x4c, 0xdb, 0xd9, 0xba, 0x4d, 0xdb, 0x0f, 0x9f, 0x79, 0xb5, 0xd7, /* bytes 192 - 208 */
    0xda, 0x6d, 0xf6, 0x0f, 0xbf, 0x9b, 0xad, 0x76, 0x76, 0xb7, 0xff, 0x0f, 0xbf, 0xe6, 0xfa, 0x6d, /* bytes 208 - 224 */
    0xb6, 0x93, 0x3c, 0x0f, 0xbf, 0x34, 0x5b, 0xdb, 0xee, 0x6e, 0x77, 0x0f, 0xbf, 0xd5, 0x6d, 0x5b, /* bytes 224 - 240 */
    0xd9, 0x6d, 0xdb, 0x0f, 0xbf, 0x4d, 0xb7, 0x6d, 0x37, 0x93, 0x6d, 0x0f, 0xbf, 0x79, 0xdb, 0x3d, /* bytes 240 - 256 */
    0xed, 0xb6, 0xfd, 0x0f, 0x3f, 0xb7, 0x6c, 0x33, 0xdb, 0x6d, 0xb6, 0x0e, 0xbf, 0xed, 0xf7, 0x96, /* bytes 256 - 272 */
    0x36, 0x21, 0xfb, 0x0e, 0xbf, 0x4e, 0xdb, 0x9e, 0x75, 0xc0, 0xf9, 0x0e, 0xbf, 0x7b, 0xbd, 0xcb, /* bytes 272 - 288 */
    0x1d, 0x00, 0xef, 0x0e, 0x7f, 0xc7, 0x6c, 0x4a, 0x0a, 0x3e, 0xcb, 0x0d, 0x7f, 0x8d, 0xf3, 0x6d, /* bytes 288 - 304 */
    0x83, 0x6d, 0xb6, 0x0d, 0x7f, 0x3a, 0xd2, 0xcd, 0x80, 0x6c, 0xb6, 0x0f, 0xff, 0x1a, 0x26, 0x0f, /* bytes 304 - 320 */
    0x9c, 0x1b, 0x6c, 0x0e, 0xff, 0x66, 0xc8, 0x99, 0x3f, 0xf3, 0xed, 0x0c, 0xff, 0x6c, 0xc2, 0xe5, /* bytes 320 - 336 */
    0x3f, 0xff, 0xd9, 0x0d, 0xff, 0x4c, 0x4e, 0xef, 0x3f, 0xd9, 0x73, 0x0f, 0xff, 0x5c, 0x9e, 0xf9, /* bytes 336 - 352 */
    0x7f, 0xd7, 0xb7, 0x0d, 0xff, 0x55, 0x9e, 0xf6, 0x7f, 0xd6, 0xef, 0x0d, 0xff, 0x6d, 0xbe, 0xdb, /* bytes 352 - 368 */
    0xff, 0xdc, 0x6f, 0x09, 0xff, 0x2d, 0x3f, 0xeb, 0xff, 0xbc, 0x5f, 0x0b, 0xff, 0x5b, 0xbf, 0xec, /* bytes 368 - 384 */
    0xff, 0xa5, 0xdf, 0x0b, 0xff, 0x59, 0xbf, 0xff, 0xff, 0xd5, 0xbf, 0x0a, 0xff, 0xd9, 0x3f, 0xf9, /* bytes 384 - 400 */
    0xff, 0xd9, 0xbf, 0x09, 0xff, 0x6b, 0xbf, 0xed, 0xff, 0xdc, 0xbf, 0x09, 0xff, 0x6b, 0xbf, 0xee, /* bytes 400 - 416 */
    0xff, 0xdc, 0x3f, 0x0b, 0xff, 0xdb, 0xbf, 0xfa, 0xff, 0xec, 0x3f, 0x0b, 0xff, 0x33, 0x3f, 0xeb, /* bytes 416 - 432 */
    0x7f, 0xea, 0x3f, 0x0b, 0xff, 0x6b, 0xbf, 0xed, 0x3f, 0xc8, 0x3f, 0x03, 0xff, 0x33, 0xbf, 0xfc, /* bytes 432 - 448 */
    0x3f, 0xe0, 0x3f, 0x09, 0xff, 0x53, 0x3f, 0xf3, 0x7f, 0xe0, 0x9f, 0x03, 0xff, 0x49, 0x3f, 0xf7, /* bytes 448 - 464 */
    0xff, 0xff, 0x1f, 0x02, 0xff, 0x29, 0x9f, 0xe4, 0xff, 0xff, 0x1f, 0x00, 0xff, 0x01, 0x9f, 0xf4, /* bytes 464 - 480 */
    0xff, 0xff, 0x3f, 0x08, 0xff, 0x83, 0x1f, 0xe6, 0xff, 0xff, 0xff, 0x0f, 0xff, 0xff, 0x0f, 0xf0, /* bytes 480 - 496 */
    0xff, 0xff, 0xff, 0x0f, 0xff, 0xff, 0x1f, 0xf0, 0xff, 0xff, 0xff, 0x0f,                         /* bytes 496 - 508 */
};

static const uint8_t no_litter[] =
{
  0x14, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0xa8, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 0 - 16 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 16 - 32 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 32 - 48 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 48 - 64 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 64 - 80 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 80 - 96 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 96 - 112 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 112 - 128 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, /* bytes 128 - 144 */
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 144 - 160 */
  0xff, 0xff, 0xff, 0x07, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 160 - 176 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 176 - 192 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0xfc, 0xff, 0xff, /* bytes 192 - 208 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, /* bytes 208 - 224 */
  0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 224 - 240 */
  0xff, 0xff, 0x7f, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 240 - 256 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 256 - 272 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0xf0, 0xff, 0xff, /* bytes 272 - 288 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, /* bytes 288 - 304 */
  0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 304 - 320 */
  0xff, 0xff, 0x3f, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 320 - 336 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 336 - 352 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0xe0, 0xff, 0xff, /* bytes 352 - 368 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, /* bytes 368 - 384 */
  0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 384 - 400 */
  0xff, 0xff, 0x3f, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 400 - 416 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 416 - 432 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0xf0, 0xff, 0xff, /* bytes 432 - 448 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, /* bytes 448 - 464 */
  0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 464 - 480 */
  0xff, 0xff, 0x7f, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 480 - 496 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 496 - 512 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0xfc, 0xff, 0xff, /* bytes 512 - 528 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, /* bytes 528 - 544 */
  0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 544 - 560 */
  0xff, 0xff, 0xff, 0x0f, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 560 - 576 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 576 - 592 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 592 - 608 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 608 - 624 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 624 - 640 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 640 - 656 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 656 - 672 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0xf8, 0xff, /* bytes 672 - 688 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, /* bytes 688 - 704 */
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 704 - 720 */
  0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 720 - 736 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 736 - 752 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, /* bytes 752 - 768 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, /* bytes 768 - 784 */
  0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 784 - 800 */
  0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 800 - 816 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x00, 0x00, /* bytes 816 - 832 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, /* bytes 832 - 848 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, /* bytes 848 - 864 */
  0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 864 - 880 */
  0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 880 - 896 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, /* bytes 896 - 912 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, /* bytes 912 - 928 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, /* bytes 928 - 944 */
  0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 944 - 960 */
  0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 960 - 976 */
  0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, /* bytes 976 - 992 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, /* bytes 992 - 1008 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, /* bytes 1008 - 1024 */
  0x00, 0x00, 0x01, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 1024 - 1040 */
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 1040 - 1056 */
  0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, /* bytes 1056 - 1072 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, /* bytes 1072 - 1088 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, /* bytes 1088 - 1104 */
  0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, /* bytes 1104 - 1120 */
  0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 1120 - 1136 */
  0xff, 0x0f, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, /* bytes 1136 - 1152 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, /* bytes 1152 - 1168 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x00, /* bytes 1168 - 1184 */
  0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, /* bytes 1184 - 1200 */
  0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 1200 - 1216 */
  0xff, 0x07, 0x00, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, /* bytes 1216 - 1232 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, /* bytes 1232 - 1248 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0xfc, 0x03, 0x00, /* bytes 1248 - 1264 */
  0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, /* bytes 1264 - 1280 */
  0x00, 0xfe, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 1280 - 1296 */
  0xff, 0x3f, 0x00, 0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, /* bytes 1296 - 1312 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, /* bytes 1312 - 1328 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, /* bytes 1328 - 1344 */
  0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 1344 - 1360 */
  0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 1360 - 1376 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, /* bytes 1376 - 1392 */
  0xff, 0xff, 0xff, 0xff, 0x7f, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, /* bytes 1392 - 1408 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, /* bytes 1408 - 1424 */
  0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xf8, 0xff, 0xff, /* bytes 1424 - 1440 */
  0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 1440 - 1456 */
  0x0f, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, /* bytes 1456 - 1472 */
  0xff, 0xff, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, /* bytes 1472 - 1488 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, /* bytes 1488 - 1504 */
  0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, /* bytes 1504 - 1520 */
  0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 1520 - 1536 */
  0x07, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, /* bytes 1536 - 1552 */
  0xff, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, /* bytes 1552 - 1568 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, /* bytes 1568 - 1584 */
  0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, /* bytes 1584 - 1600 */
  0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 1600 - 1616 */
  0x7f, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, /* bytes 1616 - 1632 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, /* bytes 1632 - 1648 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, /* bytes 1648 - 1664 */
  0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0xfe, 0xff, /* bytes 1664 - 1680 */
  0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 1680 - 1696 */
  0xff, 0x03, 0xfc, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0x00, 0x00, /* bytes 1696 - 1712 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0xf8, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x03, 0xf0, /* bytes 1712 - 1728 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xf0, 0xff, 0xff, 0xff, 0x03, 0x00, /* bytes 1728 - 1744 */
  0x00, 0x00, 0x07, 0xf8, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xf0, 0xff, /* bytes 1744 - 1760 */
  0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x0f, 0xfc, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x0f, 0xf0, /* bytes 1760 - 1776 */
  0xff, 0x01, 0xf8, 0x3f, 0xc0, 0xff, 0x03, 0x00, 0x03, 0x00, 0x3f, 0xfe, 0xff, 0xff, 0x00, 0x00, /* bytes 1776 - 1792 */
  0xff, 0xff, 0x0f, 0xf0, 0xff, 0x03, 0xfc, 0x3f, 0xc0, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, /* bytes 1792 - 1808 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0x07, 0xfe, 0x3f, 0xc0, 0xff, 0x03, 0x80, /* bytes 1808 - 1824 */
  0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x0f, 0xe0, 0xff, 0x0f, 0xff, 0x1f, /* bytes 1824 - 1840 */
  0xc0, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x0f, 0xe0, /* bytes 1840 - 1856 */
  0xff, 0x9f, 0xff, 0x1f, 0xc0, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 1856 - 1872 */
  0xff, 0xff, 0x1f, 0xe0, 0xff, 0xff, 0xff, 0x1f, 0xc0, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, /* bytes 1872 - 1888 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x1f, 0xe0, 0xff, 0xff, 0xff, 0x1f, 0xe0, 0xff, 0x03, 0x80, /* bytes 1888 - 1904 */
  0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x1f, 0xe0, 0xff, 0xff, 0xff, 0x1f, /* bytes 1904 - 1920 */
  0xe0, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x1f, 0xc0, /* bytes 1920 - 1936 */
  0xff, 0xff, 0xff, 0x1f, 0xe0, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 1936 - 1952 */
  0xff, 0xff, 0x1f, 0xc0, 0xff, 0xff, 0xff, 0x0f, 0xe0, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, /* bytes 1952 - 1968 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x3f, 0xc0, 0x7f, 0x80, 0xff, 0x0f, 0xe0, 0xff, 0x03, 0x80, /* bytes 1968 - 1984 */
  0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x3f, 0xc0, 0x7f, 0x80, 0xff, 0x0f, /* bytes 1984 - 2000 */
  0xf0, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x3f, 0xc0, /* bytes 2000 - 2016 */
  0x7f, 0x80, 0xff, 0x0f, 0xf0, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2016 - 2032 */
  0xff, 0xff, 0x3f, 0x80, 0x7f, 0x80, 0xff, 0x0f, 0xf0, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, /* bytes 2032 - 2048 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x3f, 0x80, 0x7f, 0x80, 0xff, 0x07, 0xf0, 0xff, 0x03, 0x80, /* bytes 2048 - 2064 */
  0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x3f, 0x80, 0x7f, 0x80, 0xff, 0x07, /* bytes 2064 - 2080 */
  0xf0, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x7f, 0x80, /* bytes 2080 - 2096 */
  0x7f, 0x80, 0xff, 0x07, 0xf8, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2096 - 2112 */
  0xff, 0xff, 0x7f, 0x80, 0x7f, 0x80, 0xff, 0x07, 0xf8, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, /* bytes 2112 - 2128 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x7f, 0x80, 0xff, 0xff, 0xff, 0x07, 0xf8, 0xff, 0x03, 0x80, /* bytes 2128 - 2144 */
  0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x7f, 0x00, 0xff, 0xff, 0xff, 0x03, /* bytes 2144 - 2160 */
  0xf8, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x7f, 0x00, /* bytes 2160 - 2176 */
  0xff, 0xff, 0xff, 0x03, 0xf8, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2176 - 2192 */
  0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x03, 0xf8, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, /* bytes 2192 - 2208 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x03, 0xfc, 0xff, 0x03, 0x80, /* bytes 2208 - 2224 */
  0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x03, /* bytes 2224 - 2240 */
  0xfc, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, /* bytes 2240 - 2256 */
  0xfe, 0xff, 0xff, 0x01, 0xfc, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2256 - 2272 */
  0xff, 0xff, 0xff, 0x00, 0xfe, 0xff, 0xff, 0x01, 0xfc, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, /* bytes 2272 - 2288 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xfe, 0xff, 0xff, 0x01, 0xfc, 0xff, 0x03, 0x80, /* bytes 2288 - 2304 */
  0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x01, 0xfe, 0xff, 0xff, 0x01, /* bytes 2304 - 2320 */
  0xfe, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x01, /* bytes 2320 - 2336 */
  0xfe, 0xff, 0xff, 0x01, 0xfe, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2336 - 2352 */
  0xff, 0xff, 0xff, 0x01, 0xfc, 0xff, 0xff, 0x01, 0xfe, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, /* bytes 2352 - 2368 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x01, 0xfc, 0xff, 0xff, 0x00, 0xfe, 0xff, 0x03, 0x80, /* bytes 2368 - 2384 */
  0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x01, 0xfc, 0xff, 0xff, 0x00, /* bytes 2384 - 2400 */
  0xfe, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x03, /* bytes 2400 - 2416 */
  0xfc, 0xff, 0xff, 0x00, 0xff, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2416 - 2432 */
  0xff, 0xff, 0xff, 0x03, 0xfc, 0xff, 0xff, 0x00, 0xff, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, /* bytes 2432 - 2448 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x03, 0xfc, 0xff, 0xff, 0x00, 0xff, 0xff, 0x03, 0x80, /* bytes 2448 - 2464 */
  0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x03, 0xf8, 0xff, 0x7f, 0x00, /* bytes 2464 - 2480 */
  0xff, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x03, /* bytes 2480 - 2496 */
  0xf8, 0xff, 0x7f, 0x00, 0xff, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2496 - 2512 */
  0xff, 0xff, 0xff, 0x03, 0xf8, 0xff, 0x7f, 0x00, 0xff, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, /* bytes 2512 - 2528 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x07, 0xf8, 0xff, 0x7f, 0x80, 0xff, 0xff, 0x03, 0x80, /* bytes 2528 - 2544 */
  0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x07, 0xf8, 0xff, 0x7f, 0x80, /* bytes 2544 - 2560 */
  0xff, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x07, /* bytes 2560 - 2576 */
  0xf0, 0xff, 0x3f, 0x80, 0xff, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2576 - 2592 */
  0xff, 0xff, 0xff, 0x07, 0xf0, 0xff, 0x3f, 0x80, 0xff, 0xff, 0x03, 0x80, 0x03, 0x00, 0xff, 0xff, /* bytes 2592 - 2608 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x07, 0xf0, 0xff, 0x3f, 0x80, 0xff, 0xff, 0x03, 0x80, /* bytes 2608 - 2624 */
  0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0x3f, 0xc0, /* bytes 2624 - 2640 */
  0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x0f, /* bytes 2640 - 2656 */
  0xf0, 0xff, 0x3f, 0xc0, 0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2656 - 2672 */
  0xff, 0xff, 0xff, 0x0f, 0xe0, 0xff, 0x1f, 0xc0, 0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0xff, 0xff, /* bytes 2672 - 2688 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x0f, 0xe0, 0xff, 0x1f, 0xc0, 0xff, 0xff, 0x03, 0x80, /* bytes 2688 - 2704 */
  0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x0f, 0xe0, 0xff, 0x1f, 0xc0, /* bytes 2704 - 2720 */
  0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x1f, /* bytes 2720 - 2736 */
  0xe0, 0xff, 0x1f, 0xe0, 0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2736 - 2752 */
  0xff, 0xff, 0xff, 0x1f, 0xe0, 0xff, 0x1f, 0xe0, 0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0xff, 0xff, /* bytes 2752 - 2768 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x1f, 0xe0, 0xff, 0x0f, 0xe0, 0xff, 0xff, 0x03, 0x80, /* bytes 2768 - 2784 */
  0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x1f, 0xc0, 0xff, 0x0f, 0xe0, /* bytes 2784 - 2800 */
  0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x1f, /* bytes 2800 - 2816 */
  0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2816 - 2832 */
  0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0xff, 0xff, /* bytes 2832 - 2848 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x03, 0x80, /* bytes 2848 - 2864 */
  0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0xf0, /* bytes 2864 - 2880 */
  0xff, 0xff, 0x07, 0x80, 0x07, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x3f, /* bytes 2880 - 2896 */
  0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x07, 0x80, 0x07, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2896 - 2912 */
  0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x0f, 0xc0, 0x0f, 0xc0, 0xff, 0xff, /* bytes 2912 - 2928 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0xe0, /* bytes 2928 - 2944 */
  0x1f, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0xf8, /* bytes 2944 - 2960 */
  0xff, 0xff, 0x7f, 0xf8, 0x7f, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 2960 - 2976 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 2976 - 2992 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 2992 - 3008 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3008 - 3024 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3024 - 3040 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 3040 - 3056 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 3056 - 3072 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3072 - 3088 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3088 - 3104 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3104 - 3120 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 3120 - 3136 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 3136 - 3152 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3152 - 3168 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3168 - 3184 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3184 - 3200 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 3200 - 3216 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 3216 - 3232 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3232 - 3248 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3248 - 3264 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3264 - 3280 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* bytes 3280 - 3296 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, /* bytes 3296 - 3312 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3312 - 3328 */
  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3328 - 3344 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* bytes 3344 - 3360 */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,                         /* bytes 3360 - 3372 */
};

extern uint32_t prv_get_data_section_length(ResourceStoreEntry *entry, ResourceManifest *manifest);
extern uint32_t prv_get_store_length(ResourceStoreEntry *entry, ResourceManifest *manifest);

void test_resource__initialize(void) {
  fake_spi_flash_init(0, 0x1000000);
  pfs_init(false);
  load_resource_fixture_in_flash(RESOURCES_FIXTURE_PATH, SYSTEM_RESOURCES_FIXTURE_NAME, false /* is_next */);
  pfs_format(false /* write erase headers */);
}

void test_resource__cleanup(void) {

}

void test_resource__system_resource_init(void) {
}


void test_resource__resource_update(void) {
  load_resource_fixture_in_flash(RESOURCES_FIXTURE_PATH, SYSTEM_RESOURCES_FIXTURE_NAME, true /* is_next */);
  fake_boot_bit_set(BOOT_BIT_NEW_SYSTEM_RESOURCES_AVAILABLE);
  resource_init();
}

void test_resource__pug(void) {
  load_resource_fixture_on_pfs(RESOURCES_FIXTURE_PATH, PUG_FIXTURE_NAME, "pug");
  size_t pug_size = resource_size(SYSTEM_APP, RESOURCE_ID_PUG);
  cl_assert_equal_i(pug_size, sizeof(pug));
  uint8_t pug_buf[pug_size];
  cl_assert_equal_i(
      resource_load_byte_range_system(SYSTEM_APP, RESOURCE_ID_PUG, 0, pug_buf, pug_size),
      pug_size);
  for (unsigned int i = 0; i < sizeof(pug); i++) {
    cl_assert(pug[i] == pug_buf[i]);
  }
}

static const uint32_t resource_bank = 5;
static const uint32_t no_litter_res_id = 1;

void test_resource__no_litter(void) {
  char filename[32];
  resource_storage_get_file_name(filename, sizeof(filename), resource_bank);

  load_resource_fixture_on_pfs(RESOURCES_FIXTURE_PATH, APP_RESOURCES_FIXTURE_NAME, filename);

  size_t image_size = resource_size(resource_bank, no_litter_res_id);
  cl_assert_equal_i(image_size, sizeof(no_litter));
  uint8_t image_buf[image_size];
  cl_assert_equal_i( resource_load_byte_range_system(resource_bank, no_litter_res_id, 0,
    image_buf, image_size), image_size);

  for (unsigned int i = 0; i < sizeof(no_litter); i++) {
    cl_assert(no_litter[i] == image_buf[i]);
  }
  return;
}

void test_resource__read_last_byte_resource(void) {
  char filename[32];
  resource_storage_get_file_name(filename, sizeof(filename), resource_bank);

  load_resource_fixture_on_pfs(RESOURCES_FIXTURE_PATH, APP_RESOURCES_FIXTURE_NAME, filename);
  size_t image_size = resource_size(resource_bank, no_litter_res_id);
  uint8_t image_buf[image_size];

  // read the last byte, and make sure it returns a successful 1 byte return value
  cl_assert_equal_i( resource_load_byte_range_system(resource_bank, no_litter_res_id, image_size - 1,
    image_buf, 1), 1);

  return;
}

void test_resource__read_past_last_byte_resource(void) {
  char filename[32];
  snprintf(filename, 32, "res_bank%u", resource_bank);

  load_resource_fixture_on_pfs(RESOURCES_FIXTURE_PATH, APP_RESOURCES_FIXTURE_NAME, filename);
  size_t image_size = resource_size(resource_bank, no_litter_res_id);
  uint8_t image_buf[image_size];

  // read the last byte, and make sure it returns a a failure 0 byte return value
  cl_assert_equal_i( resource_load_byte_range_system(resource_bank, no_litter_res_id, image_size,
    image_buf, 1), 0);

  return;
  }

static uint32_t s_watch_res_callback_called_count = 0;
static void prv_res_changed_callback(void *data) {
  s_watch_res_callback_called_count++;
}

void test_resource__watch(void) {
  load_resource_fixture_on_pfs(RESOURCES_FIXTURE_PATH, PUG_FIXTURE_NAME, "pug");

  ResourceCallbackHandle cb_handle = resource_watch(SYSTEM_APP, RESOURCE_ID_PUG,
      prv_res_changed_callback, NULL);
  cl_assert(cb_handle);

  // Callback should get invoked if resource was written to
  s_watch_res_callback_called_count = 0;
  load_resource_fixture_on_pfs(RESOURCES_FIXTURE_PATH, PUG_FIXTURE_NAME, "pug");
  cl_assert(s_watch_res_callback_called_count == 1);

  // Turn off watch
  resource_unwatch(cb_handle);

  // Callback should get invoked if resource was written to
  s_watch_res_callback_called_count = 0;
  load_resource_fixture_on_pfs(RESOURCES_FIXTURE_PATH, PUG_FIXTURE_NAME, "pug");
  cl_assert(s_watch_res_callback_called_count == 0);
}

static uint32_t prv_mock_resource_storage_app_read(ResourceStoreEntry *entry, uint32_t offset,
                                                   void *data,
                                                   size_t num_bytes) {
  ResTableEntry res_entry = {
    .resource_id = 0,
    .offset = 0,
    .length = UINT32_MAX,
    .crc = 0
  };
  memcpy(data, &res_entry, sizeof(ResTableEntry));
  return 1;
}

void test_resource__overflow_data_section_length(void) {
  ResourceManifest manifest = {
    .num_resources = 1,
    .version = SYSTEM_RESOURCE_VERSION
  };

  ResourceStoreImplementation impl = {
    .type = ResourceStoreTypeAppFile,
    .get_crc = NULL,
    .write = NULL,
    .read = &prv_mock_resource_storage_app_read,
    .clear = NULL
  };

  ResourceStoreEntry entry = {
    // app_num
    .store_data = (void*)(uintptr_t)10,
    .impl = &impl
  };

  cl_assert_equal_i(prv_get_store_length(&entry, &manifest), 0);
}

