/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#include <stdint.h>

/****************  ANCS SMS  ****************/
// 00 0c 00 00 00 06 00 00  07 05 00 43 6c 65 61 72   ........ ...Clear
// 00 13 00 63 6f 6d 2e 61  70 70 6c 65 2e 4d 6f 62   ...com.a pple.Mob
// 69 6c 65 53 4d 53 01 08  00 50 68 69 6c 69 70 20   ileSMS.. .Philip
// 47 02 00 00 03 12 00 43  61 6e 61 64 61 20 69 73   G......C anada is
// 20 74 68 65 20 62 65 73  74 05 0f 00 32 30 31 35    the bes t...2015
// 30 38 33 31 54 31 30 32  34 34 33                  0831T102 443
static const uint8_t s_sms_ancs_data[] = {
  0x00, 0x0c, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x07, 0x05, 0x00, 0x43, 0x6c, 0x65, 0x61, 0x72,
  0x00, 0x13, 0x00, 0x63, 0x6f, 0x6d, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x65, 0x2e, 0x4d, 0x6f, 0x62,
  0x69, 0x6c, 0x65, 0x53, 0x4d, 0x53, 0x01, 0x08, 0x00, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x20,
  0x47, 0x02, 0x00, 0x00, 0x03, 0x12, 0x00, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x61, 0x20, 0x69, 0x73,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x65, 0x73, 0x74, 0x05, 0x0f, 0x00, 0x32, 0x30, 0x31, 0x35,
  0x30, 0x38, 0x33, 0x31, 0x54, 0x31, 0x30, 0x32, 0x34, 0x34, 0x33
};

// 03 00 00 00 00 00 00 00  00 00 00 00 00 00 00 00  ........ ........
// 00 0c 06 0c 08 00 50 68  69 6c 69 70 20 47 01 08  ......Ph ilip G..
// 00 50 68 69 6c 69 70 20  47 03 12 00 43 61 6e 61  .Philip  G...Cana
// 64 61 20 69 73 20 74 68  65 20 62 65 73 74 20 13  da is th e best .
// 00 63 6f 6d 2e 61 70 70  6c 65 2e 4d 6f 62 69 6c  .com.app le.Mobil
// 65 53 4d 53 04 04 00 00  00 00 00 25 04 00 00 00  eSMS.... ...%....
// 00 00                                             ..

static const uint8_t s_sms_action_data[] = {
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0c, 0x06, 0x0c, 0x08, 0x00, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x20, 0x47, 0x01, 0x08,
  0x00, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x20, 0x47, 0x03, 0x12, 0x00, 0x43, 0x61, 0x6e, 0x61,
  0x64, 0x61, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x65, 0x73, 0x74, 0x20, 0x13,
  0x00, 0x63, 0x6f, 0x6d, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x65, 0x2e, 0x4d, 0x6f, 0x62, 0x69, 0x6c,
  0x65, 0x53, 0x4d, 0x53, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00
};

/****************  Group SMS  ****************/
// 00 0d 00 00 00 06 00 00  07 05 00 43 6c 65 61 72   ........ ...Clear
// 00 13 00 63 6f 6d 2e 61  70 70 6c 65 2e 4d 6f 62   ...com.a pple.Mob
// 69 6c 65 53 4d 53 01 10  00 62 6a 65 74 74 40 70   ileSMS.. .bjett@p
// 65 62 62 6c 65 2e 63 6f  6d 02 17 00 54 6f 20 79   ebble.co m...To y
// 6f 75 20 26 20 28 33 31  37 29 20 33 37 30 2d 32   ou & (31 7) 370-2
// 38 32 39 03 08 00 54 65  73 74 69 6e 67 20 05 0f   829...Te sting ..
// 00 32 30 31 35 30 39 30  32 54 31 36 31 39 32 32   .2015090 2T161922
static const uint8_t s_group_sms_ancs_data[] = {
  0x00, 0x0d, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x07, 0x05, 0x00, 0x43, 0x6c, 0x65, 0x61, 0x72,
  0x00, 0x13, 0x00, 0x63, 0x6f, 0x6d, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x65, 0x2e, 0x4d, 0x6f, 0x62,
  0x69, 0x6c, 0x65, 0x53, 0x4d, 0x53, 0x01, 0x10, 0x00, 0x62, 0x6a, 0x65, 0x74, 0x74, 0x40, 0x70,
  0x65, 0x62, 0x62, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x02, 0x17, 0x00, 0x54, 0x6f, 0x20, 0x79,
  0x6f, 0x75, 0x20, 0x26, 0x20, 0x28, 0x33, 0x31, 0x37, 0x29, 0x20, 0x33, 0x37, 0x30, 0x2d, 0x32,
  0x38, 0x32, 0x39, 0x03, 0x08, 0x00, 0x54, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x05, 0x0f,
  0x00, 0x32, 0x30, 0x31, 0x35, 0x30, 0x39, 0x30, 0x32, 0x54, 0x31, 0x36, 0x31, 0x39, 0x32, 0x32
};

// 03 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
// 00 0d 05 01 05 00 52 65 70 6c 79 21 01 00 01 0c  ......Reply!....
// 10 00 62 6a 65 74 74 40 70 65 62 62 6c 65 2e 63  ..bjett@pebble.c
// 6f 6d 20 13 00 63 6f 6d 2e 61 70 70 6c 65 2e 4d  om ..com.apple.M
// 6f 62 69 6c 65 53 4d 53 02 17 00 54 6f 20 79 6f  obileSMS...To yo
// 75 20 26 20 28 33 31 37 29 20 33 37 30 2d 32 38  u & (317) 370-28
// 32 39                                            29

static const uint8_t s_group_sms_action_data[] = {
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0d, 0x05, 0x01, 0x05, 0x00, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x21, 0x01, 0x00, 0x01, 0x0c,
  0x10, 0x00, 0x62, 0x6a, 0x65, 0x74, 0x74, 0x40, 0x70, 0x65, 0x62, 0x62, 0x6c, 0x65, 0x2e, 0x63,
  0x6f, 0x6d, 0x20, 0x13, 0x00, 0x63, 0x6f, 0x6d, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x65, 0x2e, 0x4d,
  0x6f, 0x62, 0x69, 0x6c, 0x65, 0x53, 0x4d, 0x53, 0x02, 0x17, 0x00, 0x54, 0x6f, 0x20, 0x79, 0x6f,
  0x75, 0x20, 0x26, 0x20, 0x28, 0x33, 0x31, 0x37, 0x29, 0x20, 0x33, 0x37, 0x30, 0x2d, 0x32, 0x38,
  0x32, 0x39
};


/****************  Email  ****************/
static const uint8_t s_email_ancs_data[] = {
  0x00, 0x0d, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x07, 0x05, 0x00, 0x43, 0x6c, 0x65, 0x61, 0x72,
  0x00, 0x14, 0x00, 0x63, 0x6f, 0x6d, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x62,
  0x69, 0x6c, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x01, 0x0e, 0x00, 0x50, 0x68, 0x69, 0x6c, 0x20, 0x47,
  0x75, 0x6e, 0x6e, 0x65, 0x77, 0x69, 0x65, 0x6b, 0x02, 0x0b, 0x00, 0x54, 0x68, 0x65, 0x20, 0x53,
  0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x03, 0x08, 0x00, 0x54, 0x68, 0x65, 0x20, 0x42, 0x6f, 0x64,
  0x79, 0x05, 0x0f, 0x00, 0x32, 0x30, 0x31, 0x35, 0x30, 0x38, 0x33, 0x31, 0x54, 0x31, 0x31, 0x30,
  0x33, 0x35, 0x39
};

/****************  Send Text  ****************/
// 02 0f 71 aa ba 58 14 4b 5c 96 e2 c9 82 8c 97 34  ..q..X.K \......4
// cb 00 02 01 0e 00 59 6f 2c 20 77 68 61 74 27 73  ......Yo , what's
// 20 75 70 3f 0c 0c 00 35 35 35 2d 31 32 33 2d 34   up?...5 55-123-4
// 35 36 37                                         567

static const uint8_t s_send_text_data[] = {
  0x02, 0x0f, 0x71, 0xaa, 0xba, 0x58, 0x14, 0x4b, 0x5c, 0x96, 0xe2, 0xc9, 0x82, 0x8c, 0x97, 0x34,
  0xcb, 0x00, 0x02, 0x01, 0x0e, 0x00, 0x59, 0x6f, 0x2c, 0x20, 0x77, 0x68, 0x61, 0x74, 0x27, 0x73,
  0x20, 0x75, 0x70, 0x3f, 0x0c, 0x0c, 0x00, 0x35, 0x35, 0x35, 0x2d, 0x31, 0x32, 0x33, 0x2d, 0x34,
  0x35, 0x36, 0x37
};

/**************** PP SMS ****************/
// 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ........ ........
// 00 00 01 01 0e 00 59 6f 2c 20 77 68 61 74 27 73  ......Yo , what's
// 20 75 70 3f                                       up?

static const uint8_t s_sms_reply_action_data[] = {
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x01, 0x0e, 0x00, 0x59, 0x6f, 0x2c, 0x20, 0x77, 0x68, 0x61, 0x74, 0x27, 0x73,
  0x20, 0x75, 0x70, 0x3f
};
