/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#include "applib/graphics/gbitmap_png.h"

#include "clar.h"
#include "util.h"

#include <string.h>
#include <stdio.h>

// Stubs
////////////////////////////////////
#include "stubs_applib_resource.h"
#include "stubs_app_state.h"
#include "stubs_heap.h"
#include "stubs_resources.h"
#include "stubs_syscalls.h"
#include "stubs_passert.h"
#include "stubs_pbl_malloc.h"
#include "stubs_logging.h"

// Tests
////////////////////////////////////

// Reference PNGs reside in "tests/fw/graphics/test_images/"
// and are created at build time, with the PNG file copied to TEST_IMAGES_PATH 
// and a separate PBI generated by bitmapgen.py from the PNG copied to TEST_IMAGES_PATH
// covers 1,2,4,8 bit palettized
// covers 1,2,4,8 bit palettized with transparency
// covers 1, 2 bit greyscale
// covers 1, 2 bit greyscale with transparency
// covers 4 bit greyscale with transparency (black, white, dark_grey, light_grey, transparent)


// Tests 1-bit jazzberry_jam colored palettized PNG loading into gbitmap
// tests covers an old bug in image tooling where 1 color was 2 power 0
// so bitdepth was detected as 0 (incorrectly)
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__color_1_bit_jazzberry_jam(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(1bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(1bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat1BitPalette);
}

// Tests 1-bit red&white palettized PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__color_1_bit(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(1bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(1bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat1BitPalette);
}

// Tests 2-bit palettized PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__color_2_bit(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(2bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(2bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat2BitPalette);
}

// Tests 4-bit palettized PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__color_4_bit(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(4bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(4bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat4BitPalette);
}

// Tests 8-bit palettized 64-color PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__color_8_bit(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(8bit));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(8bit)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat8Bit);
}

// Tests 1-bit transparent palettized PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__color_1_bit_transparent(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(1bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(1bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat1BitPalette);
}

// Tests 2-bit transparent palettized PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__color_2_bit_transparent(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(2bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(2bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat2BitPalette);
}

// Tests 4-bit transparent palettized PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__color_4_bit_transparent(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(4bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(4bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat4BitPalette);
}

// Tests 8-bit transparent palettized PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__color_8_bit_transparent(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(8bit));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(8bit)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat8Bit);
}

// Tests 1-bit all black greyscale PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__greyscale_1_bit_black(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(1bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(1bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat1BitPalette);
}

// Tests 1-bit b&w greyscale PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__greyscale_1_bit(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(1bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(1bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat1BitPalette);
}

// Tests 2-bit greyscale PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__greyscale_2_bit(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(2bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(2bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat2BitPalette);
}

// Tests 1-bit transparent greyscale PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__greyscale_1_bit_transparent(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(1bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(1bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat1BitPalette);
}

// Tests 2-bit transparent greyscale PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__greyscale_2_bit_transparent(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(2bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(2bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat2BitPalette);
}

// Tests 4-bit transparent greyscale PNG loading into gbitmap
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__greyscale_4_bit_transparent(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(4bitpalette));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(4bitpalette)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat4BitPalette);
}

// Tests 8-bit transparent color PNG with 4-bit number of colors (<= 16 colors)
// loading into gbitmap
// Checks for bug fixed for PBL-15809, where GBitmap depth was based off
// number of colors and not index value bits-per-pixel (bpp).
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__color_8_bit_transparent_bpp_check(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(8bit));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(8bit)));
  // Make sure bpp detection doesn't fail in the future
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat8Bit);
}

// Tests 8-bit transparent color PNG with 256 Colors
// loading into gbitmap
// Checks for bug fixed for PBL-16549, where uint8_t limit was 255
// causing failure to load palette
// Result:
//   - gbitmap matches platform loaded PNG
void test_png__color_256_colors_check(void) {
  GBitmap *bitmap = setup_png_test(TEST_PNG_FILE_FMT(raw));
  cl_assert(gbitmap_pbi_eq(bitmap, TEST_PBI_FILE_FMT(raw)));
  cl_assert_equal_i(gbitmap_get_format(bitmap), GBitmapFormat8Bit);
}
