/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#include "resource/resource_ids.auto.h"
#include "resource/resource_storage.h"
#include "resource/resource_storage_builtin.h"

__attribute__ ((aligned (8)))
static const uint8_t ACTION_BAR_ICON_CHECK_builtin_bytes[] = {
  0x05, 0x00, 0x06, 0x10, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x18, /* bytes 0 - 16 */
  0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x01, 0xff, 0x80, 0x00, 0x00, 0x07, 0xff, 0x80, /* bytes 16 - 32 */
  0x04, 0x00, 0x1f, 0xfe, 0x00, 0x1e, 0x00, 0x7f, 0xf8, 0x00, 0x7f, 0x81, 0xff, 0xe0, 0x00, 0xbf, /* bytes 32 - 48 */
  0xe7, 0xff, 0x80, 0x00, 0x3f, 0xff, 0xfe, 0x00, 0x00, 0x1f, 0xff, 0xf8, 0x00, 0x00, 0x07, 0xff, /* bytes 48 - 64 */
  0xe0, 0x00, 0x00, 0x01, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, /* bytes 64 - 80 */
  0x00, 0x00, 0x00, 0x7f, 0xbf, 0xff, 
};
__attribute__ ((aligned (8)))
static const uint8_t GENERIC_WARNING_LARGE_builtin_bytes[] = {
  0x50, 0x44, 0x43, 0x49, 0xe9, 0x00, 0x00, 0x00, 0x01, 0x00, 0x50, 0x00, 0x50, 0x00, 0x0d, 0x00, /* bytes 0 - 16 */
  0x03, 0x00, 0xc0, 0x03, 0xff, 0x01, 0x00, 0x02, 0x00, 0x20, 0x01, 0x48, 0x02, 0x20, 0x01, 0xa8, /* bytes 16 - 32 */
  0x01, 0x03, 0x00, 0xc0, 0x03, 0xff, 0x01, 0x00, 0x02, 0x00, 0x48, 0x01, 0xb0, 0x01, 0x48, 0x01, /* bytes 32 - 48 */
  0x48, 0x02, 0x03, 0x00, 0xc0, 0x04, 0xff, 0x00, 0x00, 0x03, 0x00, 0x54, 0x00, 0x6c, 0x01, 0x94, /* bytes 48 - 64 */
  0x01, 0x24, 0x00, 0x14, 0x02, 0xdc, 0x01, 0x03, 0x00, 0xc0, 0x04, 0xff, 0x01, 0x00, 0x02, 0x00, /* bytes 64 - 80 */
  0x5c, 0x01, 0x04, 0x01, 0x74, 0x01, 0xa4, 0x00, 0x03, 0x00, 0xc0, 0x04, 0x00, 0x01, 0x00, 0x02, /* bytes 80 - 96 */
  0x00, 0x4c, 0x01, 0x44, 0x01, 0x44, 0x01, 0x64, 0x01, 0x03, 0x00, 0xc0, 0x03, 0xff, 0x01, 0x00, /* bytes 96 - 112 */
  0x02, 0x00, 0x78, 0x00, 0x48, 0x02, 0x78, 0x00, 0x10, 0x02, 0x03, 0x00, 0xc0, 0x03, 0xff, 0x01, /* bytes 112 - 128 */
  0x00, 0x02, 0x00, 0x40, 0x00, 0x28, 0x02, 0x40, 0x00, 0x48, 0x02, 0x03, 0x00, 0xc0, 0x03, 0xff, /* bytes 128 - 144 */
  0x01, 0x00, 0x02, 0x00, 0xb0, 0x00, 0x28, 0x02, 0xb0, 0x00, 0x48, 0x02, 0x03, 0x00, 0xc0, 0x03, /* bytes 144 - 160 */
  0xff, 0x01, 0x00, 0x02, 0x00, 0xe8, 0x00, 0x20, 0x02, 0xe8, 0x00, 0x48, 0x02, 0x03, 0x00, 0xc0, /* bytes 160 - 176 */
  0x03, 0xff, 0x01, 0x00, 0x02, 0x00, 0xb8, 0x01, 0x48, 0x02, 0xb8, 0x01, 0x28, 0x02, 0x03, 0x00, /* bytes 176 - 192 */
  0xc0, 0x03, 0xff, 0x01, 0x00, 0x02, 0x00, 0x80, 0x01, 0x28, 0x02, 0x80, 0x01, 0x48, 0x02, 0x03, /* bytes 192 - 208 */
  0x00, 0xc0, 0x03, 0xff, 0x01, 0x00, 0x02, 0x00, 0xf0, 0x01, 0x28, 0x02, 0xf0, 0x01, 0x48, 0x02, /* bytes 208 - 224 */
  0x03, 0x00, 0xc0, 0x03, 0xff, 0x01, 0x00, 0x02, 0x00, 0x28, 0x02, 0x28, 0x02, 0x28, 0x02, 0x48, /* bytes 224 - 240 */
  0x02, 
};
__attribute__ ((aligned (8)))
static const uint8_t FONT_FALLBACK_INTERNAL_builtin_bytes[] = {
  0x03, 0x0e, 0x13, 0x00, 0xaf, 0x25, 0xff, 0x02, 0x0a, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, /* bytes 0 - 16 */
  0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00, /* bytes 16 - 32 */
  0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x09, 0x00, /* bytes 32 - 48 */
  0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00, /* bytes 48 - 64 */
  0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, /* bytes 64 - 80 */
  0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x15, 0x00, /* bytes 80 - 96 */
  0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x19, 0x00, /* bytes 96 - 112 */
  0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1d, 0x00, /* bytes 112 - 128 */
  0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x21, 0x00, /* bytes 128 - 144 */
  0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x25, 0x00, /* bytes 144 - 160 */
  0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x29, 0x00, /* bytes 160 - 176 */
  0x00, 0x00, 0x2a, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x2d, 0x00, /* bytes 176 - 192 */
  0x00, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x30, 0x01, 0x00, 0x00, 0x31, 0x01, /* bytes 192 - 208 */
  0x04, 0x00, 0x32, 0x01, 0x08, 0x00, 0x33, 0x01, 0x0c, 0x00, 0x34, 0x01, 0x10, 0x00, 0x35, 0x01, /* bytes 208 - 224 */
  0x14, 0x00, 0x36, 0x01, 0x18, 0x00, 0x37, 0x01, 0x1c, 0x00, 0x38, 0x01, 0x20, 0x00, 0x39, 0x01, /* bytes 224 - 240 */
  0x24, 0x00, 0x3a, 0x00, 0x28, 0x00, 0x3b, 0x00, 0x28, 0x00, 0x3c, 0x00, 0x28, 0x00, 0x3d, 0x00, /* bytes 240 - 256 */
  0x28, 0x00, 0x3e, 0x00, 0x28, 0x00, 0x3f, 0x00, 0x28, 0x00, 0x40, 0x00, 0x28, 0x00, 0x41, 0x00, /* bytes 256 - 272 */
  0x28, 0x00, 0x42, 0x00, 0x28, 0x00, 0x43, 0x00, 0x28, 0x00, 0x44, 0x00, 0x28, 0x00, 0x45, 0x00, /* bytes 272 - 288 */
  0x28, 0x00, 0x46, 0x01, 0x28, 0x00, 0x47, 0x00, 0x2c, 0x00, 0x48, 0x00, 0x2c, 0x00, 0x49, 0x00, /* bytes 288 - 304 */
  0x2c, 0x00, 0x4a, 0x00, 0x2c, 0x00, 0x4b, 0x00, 0x2c, 0x00, 0x4c, 0x00, 0x2c, 0x00, 0x4d, 0x00, /* bytes 304 - 320 */
  0x2c, 0x00, 0x4e, 0x00, 0x2c, 0x00, 0x4f, 0x00, 0x2c, 0x00, 0x50, 0x00, 0x2c, 0x00, 0x51, 0x00, /* bytes 320 - 336 */
  0x2c, 0x00, 0x52, 0x00, 0x2c, 0x00, 0x53, 0x00, 0x2c, 0x00, 0x54, 0x00, 0x2c, 0x00, 0x55, 0x00, /* bytes 336 - 352 */
  0x2c, 0x00, 0x56, 0x00, 0x2c, 0x00, 0x57, 0x00, 0x2c, 0x00, 0x58, 0x00, 0x2c, 0x00, 0x59, 0x00, /* bytes 352 - 368 */
  0x2c, 0x00, 0x5a, 0x00, 0x2c, 0x00, 0x5b, 0x00, 0x2c, 0x00, 0x5c, 0x00, 0x2c, 0x00, 0x5d, 0x00, /* bytes 368 - 384 */
  0x2c, 0x00, 0x5e, 0x00, 0x2c, 0x00, 0x5f, 0x00, 0x2c, 0x00, 0x60, 0x00, 0x2c, 0x00, 0x61, 0x01, /* bytes 384 - 400 */
  0x2c, 0x00, 0x62, 0x01, 0x30, 0x00, 0x63, 0x01, 0x34, 0x00, 0x64, 0x01, 0x38, 0x00, 0x65, 0x01, /* bytes 400 - 416 */
  0x3c, 0x00, 0x66, 0x01, 0x40, 0x00, 0x67, 0x00, 0x44, 0x00, 0x68, 0x00, 0x44, 0x00, 0x69, 0x00, /* bytes 416 - 432 */
  0x44, 0x00, 0x6a, 0x00, 0x44, 0x00, 0x6b, 0x00, 0x44, 0x00, 0x6c, 0x00, 0x44, 0x00, 0x6d, 0x00, /* bytes 432 - 448 */
  0x44, 0x00, 0x6e, 0x00, 0x44, 0x00, 0x6f, 0x00, 0x44, 0x00, 0x70, 0x00, 0x44, 0x00, 0x71, 0x00, /* bytes 448 - 464 */
  0x44, 0x00, 0x72, 0x00, 0x44, 0x00, 0x73, 0x00, 0x44, 0x00, 0x74, 0x00, 0x44, 0x00, 0x75, 0x00, /* bytes 464 - 480 */
  0x44, 0x00, 0x76, 0x00, 0x44, 0x00, 0x77, 0x00, 0x44, 0x00, 0x78, 0x01, 0x44, 0x00, 0x79, 0x00, /* bytes 480 - 496 */
  0x48, 0x00, 0x7a, 0x00, 0x48, 0x00, 0x7b, 0x00, 0x48, 0x00, 0x7c, 0x00, 0x48, 0x00, 0x7d, 0x00, /* bytes 496 - 512 */
  0x48, 0x00, 0x7e, 0x00, 0x48, 0x00, 0x7f, 0x00, 0x48, 0x00, 0x80, 0x00, 0x48, 0x00, 0x81, 0x00, /* bytes 512 - 528 */
  0x48, 0x00, 0x82, 0x00, 0x48, 0x00, 0x83, 0x00, 0x48, 0x00, 0x84, 0x00, 0x48, 0x00, 0x85, 0x00, /* bytes 528 - 544 */
  0x48, 0x00, 0x86, 0x00, 0x48, 0x00, 0x87, 0x00, 0x48, 0x00, 0x88, 0x00, 0x48, 0x00, 0x89, 0x00, /* bytes 544 - 560 */
  0x48, 0x00, 0x8a, 0x00, 0x48, 0x00, 0x8b, 0x00, 0x48, 0x00, 0x8c, 0x00, 0x48, 0x00, 0x8d, 0x00, /* bytes 560 - 576 */
  0x48, 0x00, 0x8e, 0x00, 0x48, 0x00, 0x8f, 0x00, 0x48, 0x00, 0x90, 0x00, 0x48, 0x00, 0x91, 0x00, /* bytes 576 - 592 */
  0x48, 0x00, 0x92, 0x00, 0x48, 0x00, 0x93, 0x00, 0x48, 0x00, 0x94, 0x00, 0x48, 0x00, 0x95, 0x00, /* bytes 592 - 608 */
  0x48, 0x00, 0x96, 0x00, 0x48, 0x00, 0x97, 0x00, 0x48, 0x00, 0x98, 0x00, 0x48, 0x00, 0x99, 0x00, /* bytes 608 - 624 */
  0x48, 0x00, 0x9a, 0x00, 0x48, 0x00, 0x9b, 0x00, 0x48, 0x00, 0x9c, 0x00, 0x48, 0x00, 0x9d, 0x00, /* bytes 624 - 640 */
  0x48, 0x00, 0x9e, 0x00, 0x48, 0x00, 0x9f, 0x00, 0x48, 0x00, 0xa0, 0x00, 0x48, 0x00, 0xa1, 0x00, /* bytes 640 - 656 */
  0x48, 0x00, 0xa2, 0x00, 0x48, 0x00, 0xa3, 0x00, 0x48, 0x00, 0xa4, 0x00, 0x48, 0x00, 0xa5, 0x00, /* bytes 656 - 672 */
  0x48, 0x00, 0xa6, 0x00, 0x48, 0x00, 0xa7, 0x00, 0x48, 0x00, 0xa8, 0x00, 0x48, 0x00, 0xa9, 0x00, /* bytes 672 - 688 */
  0x48, 0x00, 0xaa, 0x00, 0x48, 0x00, 0xab, 0x00, 0x48, 0x00, 0xac, 0x00, 0x48, 0x00, 0xad, 0x00, /* bytes 688 - 704 */
  0x48, 0x00, 0xae, 0x00, 0x48, 0x00, 0xaf, 0x00, 0x48, 0x00, 0xb0, 0x00, 0x48, 0x00, 0xb1, 0x00, /* bytes 704 - 720 */
  0x48, 0x00, 0xb2, 0x00, 0x48, 0x00, 0xb3, 0x00, 0x48, 0x00, 0xb4, 0x00, 0x48, 0x00, 0xb5, 0x00, /* bytes 720 - 736 */
  0x48, 0x00, 0xb6, 0x00, 0x48, 0x00, 0xb7, 0x00, 0x48, 0x00, 0xb8, 0x00, 0x48, 0x00, 0xb9, 0x00, /* bytes 736 - 752 */
  0x48, 0x00, 0xba, 0x00, 0x48, 0x00, 0xbb, 0x00, 0x48, 0x00, 0xbc, 0x00, 0x48, 0x00, 0xbd, 0x00, /* bytes 752 - 768 */
  0x48, 0x00, 0xbe, 0x00, 0x48, 0x00, 0xbf, 0x00, 0x48, 0x00, 0xc0, 0x00, 0x48, 0x00, 0xc1, 0x00, /* bytes 768 - 784 */
  0x48, 0x00, 0xc2, 0x00, 0x48, 0x00, 0xc3, 0x00, 0x48, 0x00, 0xc4, 0x00, 0x48, 0x00, 0xc5, 0x00, /* bytes 784 - 800 */
  0x48, 0x00, 0xc6, 0x00, 0x48, 0x00, 0xc7, 0x00, 0x48, 0x00, 0xc8, 0x00, 0x48, 0x00, 0xc9, 0x00, /* bytes 800 - 816 */
  0x48, 0x00, 0xca, 0x00, 0x48, 0x00, 0xcb, 0x00, 0x48, 0x00, 0xcc, 0x00, 0x48, 0x00, 0xcd, 0x00, /* bytes 816 - 832 */
  0x48, 0x00, 0xce, 0x00, 0x48, 0x00, 0xcf, 0x00, 0x48, 0x00, 0xd0, 0x00, 0x48, 0x00, 0xd1, 0x00, /* bytes 832 - 848 */
  0x48, 0x00, 0xd2, 0x00, 0x48, 0x00, 0xd3, 0x00, 0x48, 0x00, 0xd4, 0x01, 0x48, 0x00, 0xd5, 0x00, /* bytes 848 - 864 */
  0x4c, 0x00, 0xd6, 0x00, 0x4c, 0x00, 0xd7, 0x00, 0x4c, 0x00, 0xd8, 0x00, 0x4c, 0x00, 0xd9, 0x00, /* bytes 864 - 880 */
  0x4c, 0x00, 0xda, 0x00, 0x4c, 0x00, 0xdb, 0x00, 0x4c, 0x00, 0xdc, 0x00, 0x4c, 0x00, 0xdd, 0x00, /* bytes 880 - 896 */
  0x4c, 0x00, 0xde, 0x00, 0x4c, 0x00, 0xdf, 0x00, 0x4c, 0x00, 0xe0, 0x00, 0x4c, 0x00, 0xe1, 0x00, /* bytes 896 - 912 */
  0x4c, 0x00, 0xe2, 0x00, 0x4c, 0x00, 0xe3, 0x00, 0x4c, 0x00, 0xe4, 0x00, 0x4c, 0x00, 0xe5, 0x00, /* bytes 912 - 928 */
  0x4c, 0x00, 0xe6, 0x00, 0x4c, 0x00, 0xe7, 0x00, 0x4c, 0x00, 0xe8, 0x00, 0x4c, 0x00, 0xe9, 0x00, /* bytes 928 - 944 */
  0x4c, 0x00, 0xea, 0x00, 0x4c, 0x00, 0xeb, 0x00, 0x4c, 0x00, 0xec, 0x00, 0x4c, 0x00, 0xed, 0x00, /* bytes 944 - 960 */
  0x4c, 0x00, 0xee, 0x00, 0x4c, 0x00, 0xef, 0x00, 0x4c, 0x00, 0xf0, 0x00, 0x4c, 0x00, 0xf1, 0x00, /* bytes 960 - 976 */
  0x4c, 0x00, 0xf2, 0x00, 0x4c, 0x00, 0xf3, 0x00, 0x4c, 0x00, 0xf4, 0x00, 0x4c, 0x00, 0xf5, 0x00, /* bytes 976 - 992 */
  0x4c, 0x00, 0xf6, 0x00, 0x4c, 0x00, 0xf7, 0x00, 0x4c, 0x00, 0xf8, 0x00, 0x4c, 0x00, 0xf9, 0x00, /* bytes 992 - 1008 */
  0x4c, 0x00, 0xfa, 0x00, 0x4c, 0x00, 0xfb, 0x00, 0x4c, 0x00, 0xfc, 0x00, 0x4c, 0x00, 0xfd, 0x00, /* bytes 1008 - 1024 */
  0x4c, 0x00, 0xfe, 0x00, 0x4c, 0x00, 0x30, 0x00, 0x11, 0x00, 0x31, 0x00, 0x1e, 0x00, 0x32, 0x00, /* bytes 1024 - 1040 */
  0x27, 0x00, 0x33, 0x00, 0x34, 0x00, 0x34, 0x00, 0x41, 0x00, 0x35, 0x00, 0x4e, 0x00, 0x36, 0x00, /* bytes 1040 - 1056 */
  0x5b, 0x00, 0x37, 0x00, 0x68, 0x00, 0x38, 0x00, 0x75, 0x00, 0x39, 0x00, 0x82, 0x00, 0x26, 0x20, /* bytes 1056 - 1072 */
  0xda, 0x00, 0x61, 0x00, 0x8f, 0x00, 0x62, 0x00, 0x98, 0x00, 0x63, 0x00, 0xa5, 0x00, 0x64, 0x00, /* bytes 1072 - 1088 */
  0xae, 0x00, 0x65, 0x00, 0xbb, 0x00, 0x66, 0x00, 0xc4, 0x00, 0x78, 0x00, 0xd1, 0x00, 0xaf, 0x25, /* bytes 1088 - 1104 */
  0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0c, 0x01, 0x02, 0x07, 0x3f, 0xc6, 0x18, 0x63, 0x8c, /* bytes 1104 - 1120 */
  0x31, 0xc6, 0x0f, 0x04, 0x09, 0x01, 0x05, 0x06, 0x96, 0x99, 0x99, 0x99, 0x06, 0x00, 0x00, 0x00, /* bytes 1120 - 1136 */
  0x03, 0x09, 0x02, 0x05, 0x06, 0x9a, 0x24, 0x49, 0x07, 0x04, 0x09, 0x01, 0x05, 0x06, 0x96, 0x89, /* bytes 1136 - 1152 */
  0x24, 0x11, 0x0f, 0x00, 0x00, 0x00, 0x04, 0x09, 0x01, 0x05, 0x06, 0x96, 0x88, 0x86, 0x98, 0x06, /* bytes 1152 - 1168 */
  0x00, 0x00, 0x00, 0x05, 0x09, 0x00, 0x05, 0x06, 0x88, 0x31, 0xa5, 0x3e, 0x42, 0x08, 0x00, 0x00, /* bytes 1168 - 1184 */
  0x04, 0x09, 0x01, 0x05, 0x06, 0x1f, 0x71, 0x89, 0x99, 0x06, 0x00, 0x00, 0x00, 0x04, 0x09, 0x01, /* bytes 1184 - 1200 */
  0x05, 0x06, 0x96, 0x19, 0x97, 0x99, 0x06, 0x00, 0x00, 0x00, 0x04, 0x09, 0x01, 0x05, 0x06, 0x8f, /* bytes 1200 - 1216 */
  0x44, 0x24, 0x22, 0x02, 0x00, 0x00, 0x00, 0x04, 0x09, 0x01, 0x05, 0x06, 0x96, 0x99, 0x96, 0x99, /* bytes 1216 - 1232 */
  0x06, 0x00, 0x00, 0x00, 0x04, 0x09, 0x01, 0x05, 0x06, 0x96, 0x99, 0x8e, 0x99, 0x06, 0x00, 0x00, /* bytes 1232 - 1248 */
  0x00, 0x04, 0x07, 0x01, 0x07, 0x06, 0x96, 0xe8, 0x99, 0x0e, 0x04, 0x09, 0x01, 0x05, 0x06, 0x11, /* bytes 1248 - 1264 */
  0x97, 0x99, 0x99, 0x07, 0x00, 0x00, 0x00, 0x04, 0x07, 0x01, 0x07, 0x06, 0x96, 0x11, 0x91, 0x06, /* bytes 1264 - 1280 */
  0x04, 0x09, 0x01, 0x05, 0x06, 0x88, 0x9e, 0x99, 0x99, 0x0e, 0x00, 0x00, 0x00, 0x04, 0x07, 0x01, /* bytes 1280 - 1296 */
  0x07, 0x06, 0x96, 0xf9, 0x91, 0x06, 0x04, 0x09, 0x00, 0x05, 0x04, 0x2c, 0x27, 0x22, 0x22, 0x02, /* bytes 1296 - 1312 */
  0x00, 0x00, 0x00, 0x04, 0x07, 0x01, 0x07, 0x06, 0x99, 0x66, 0x96, 0x09, 0x07, 0x02, 0x01, 0x0c, /* bytes 1312 - 1328 */
  0x09, 0xc9, 0x24, 0x00, 0x00, 
};
__attribute__ ((aligned (8)))
static const uint8_t ACTION_BAR_ICON_UP_builtin_bytes[] = {
  0x03, 0x00, 0x06, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x07, 0x00, 0x00, 0x18, 0x00, 0x00, /* bytes 0 - 16 */
  0xbc, 0x00, 0x02, 0xff, 0x00, 0x0b, 0xff, 0x40, 0x0f, 0xff, 0xd0, 0x1f, 0xff, 0xf4, 0x7f, 0xff, /* bytes 16 - 32 */
  0xfd, 0x00, 0xbf, 0x7f, 0xff, 
};
__attribute__ ((aligned (8)))
static const uint8_t ACTION_BAR_ICON_DOWN_builtin_bytes[] = {
  0x03, 0x00, 0x06, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x07, 0x00, 0x15, 0x55, 0x54, 0x85, /* bytes 0 - 16 */
  0x55, 0x52, 0xa1, 0x55, 0x4a, 0xa8, 0x55, 0x6a, 0xaa, 0x15, 0xea, 0xaa, 0x87, 0xaa, 0xaa, 0xae, /* bytes 16 - 32 */
  0xaa, 0xbf, 0xff, 0x00, 0x7f, 
};
__attribute__ ((aligned (8)))
static const uint8_t GENERIC_WARNING_TINY_builtin_bytes[] = {
  0x50, 0x44, 0x43, 0x49, 0x3f, 0x00, 0x00, 0x00, 0x01, 0x00, 0x19, 0x00, 0x19, 0x00, 0x03, 0x00, /* bytes 0 - 16 */
  0x03, 0x00, 0xc0, 0x02, 0xff, 0x00, 0x00, 0x03, 0x00, 0x04, 0x00, 0xac, 0x00, 0x5c, 0x00, 0x0c, /* bytes 16 - 32 */
  0x00, 0xb4, 0x00, 0xac, 0x00, 0x03, 0x00, 0xc0, 0x02, 0x00, 0x01, 0x00, 0x02, 0x00, 0x5c, 0x00, /* bytes 32 - 48 */
  0x3c, 0x00, 0x5c, 0x00, 0x6c, 0x00, 0x03, 0x00, 0xc0, 0x02, 0x00, 0x01, 0x00, 0x02, 0x00, 0x5c, /* bytes 48 - 64 */
  0x00, 0x84, 0x00, 0x5c, 0x00, 0x94, 0x00, 
};
__attribute__ ((aligned (8)))
static const uint8_t CHECK_INTERNET_CONNECTION_LARGE_builtin_bytes[] = {
  0x50, 0x44, 0x43, 0x49, 0xe7, 0x00, 0x00, 0x00, 0x01, 0x00, 0x50, 0x00, 0x50, 0x00, 0x0b, 0x00, /* bytes 0 - 16 */
  0x03, 0x00, 0xc0, 0x04, 0xff, 0x01, 0x00, 0x07, 0x00, 0x24, 0x01, 0x0c, 0x02, 0x7c, 0x01, 0xa4, /* bytes 16 - 32 */
  0x00, 0x44, 0x01, 0x6c, 0x00, 0x64, 0x00, 0x6c, 0x00, 0x0c, 0x00, 0xd4, 0x01, 0x44, 0x00, 0x0c, /* bytes 32 - 48 */
  0x02, 0x24, 0x01, 0x0c, 0x02, 0x03, 0x00, 0xc0, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0xac, 0x00, /* bytes 48 - 64 */
  0x6c, 0x00, 0xbc, 0x00, 0x2c, 0x00, 0x03, 0x00, 0xc0, 0x04, 0x00, 0x01, 0x00, 0x03, 0x00, 0x44, /* bytes 64 - 80 */
  0x01, 0x6c, 0x00, 0xec, 0x00, 0xd4, 0x01, 0x0c, 0x00, 0xd4, 0x01, 0x03, 0x00, 0xc0, 0x03, 0x00, /* bytes 80 - 96 */
  0x01, 0x00, 0x02, 0x00, 0xf0, 0x00, 0xd8, 0x01, 0x20, 0x01, 0x08, 0x02, 0x03, 0x00, 0xc0, 0x03, /* bytes 96 - 112 */
  0x00, 0x00, 0x00, 0x05, 0x00, 0xf8, 0x00, 0xe0, 0x00, 0x78, 0x00, 0xe0, 0x00, 0x88, 0x00, 0xa0, /* bytes 112 - 128 */
  0x00, 0x08, 0x01, 0xa0, 0x00, 0xf8, 0x00, 0xe0, 0x00, 0x03, 0x00, 0xc0, 0x04, 0x00, 0x01, 0x00, /* bytes 128 - 144 */
  0x02, 0x00, 0xcc, 0x01, 0x44, 0x00, 0x2c, 0x02, 0xa4, 0x00, 0x03, 0x00, 0xc0, 0x04, 0x00, 0x01, /* bytes 144 - 160 */
  0x00, 0x02, 0x00, 0x2c, 0x02, 0x14, 0x00, 0xcc, 0x01, 0xa4, 0x00, 0x03, 0x00, 0xc0, 0x04, 0x00, /* bytes 160 - 176 */
  0x01, 0x00, 0x02, 0x00, 0xa4, 0x01, 0x94, 0x01, 0xa4, 0x01, 0x6c, 0x01, 0x03, 0x00, 0xc0, 0x04, /* bytes 176 - 192 */
  0x00, 0x01, 0x00, 0x02, 0x00, 0xdc, 0x01, 0x94, 0x01, 0xdc, 0x01, 0x44, 0x01, 0x03, 0x00, 0xc0, /* bytes 192 - 208 */
  0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x14, 0x02, 0x94, 0x01, 0x14, 0x02, 0x14, 0x01, 0x03, 0x00, /* bytes 208 - 224 */
  0xc0, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x4c, 0x02, 0x94, 0x01, 0x4c, 0x02, 0xe4, 0x00, 
};
__attribute__ ((aligned (8)))
static const uint8_t WATCH_DISCONNECTED_LARGE_builtin_bytes[] = {
  0x50, 0x44, 0x43, 0x49, 0x09, 0x01, 0x00, 0x00, 0x01, 0x00, 0x50, 0x00, 0x50, 0x00, 0x0d, 0x00, /* bytes 0 - 16 */
  0x03, 0x00, 0xc0, 0x04, 0xff, 0x01, 0x00, 0x07, 0x00, 0x34, 0x01, 0x04, 0x02, 0x8c, 0x01, 0x9c, /* bytes 16 - 32 */
  0x00, 0x54, 0x01, 0x64, 0x00, 0x74, 0x00, 0x64, 0x00, 0x1c, 0x00, 0xcc, 0x01, 0x54, 0x00, 0x04, /* bytes 32 - 48 */
  0x02, 0x34, 0x01, 0x04, 0x02, 0x03, 0x00, 0xc0, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0xbc, 0x00, /* bytes 48 - 64 */
  0x64, 0x00, 0xcc, 0x00, 0x24, 0x00, 0x03, 0x00, 0xc0, 0x04, 0x00, 0x01, 0x00, 0x03, 0x00, 0x14, /* bytes 64 - 80 */
  0x01, 0x6c, 0x01, 0xfc, 0x00, 0xcc, 0x01, 0x1c, 0x00, 0xcc, 0x01, 0x03, 0x00, 0xc0, 0x04, 0x00, /* bytes 80 - 96 */
  0x01, 0x00, 0x02, 0x00, 0x54, 0x01, 0x64, 0x00, 0x2c, 0x01, 0x0c, 0x01, 0x03, 0x00, 0xc0, 0x03, /* bytes 96 - 112 */
  0x00, 0x01, 0x00, 0x02, 0x00, 0xa0, 0x00, 0x38, 0x01, 0xc0, 0x00, 0x38, 0x01, 0x03, 0x00, 0xc0, /* bytes 112 - 128 */
  0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0xf0, 0x00, 0x38, 0x01, 0x10, 0x01, 0x38, 0x01, 0x03, 0x00, /* bytes 128 - 144 */
  0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x40, 0x02, 0x38, 0x01, 0x60, 0x02, 0x38, 0x01, 0x03, /* bytes 144 - 160 */
  0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x48, 0x01, 0x38, 0x01, 0x68, 0x01, 0x38, 0x01, /* bytes 160 - 176 */
  0x03, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x98, 0x01, 0x38, 0x01, 0xb8, 0x01, 0x38, /* bytes 176 - 192 */
  0x01, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x00, 0x01, 0xd0, 0x01, 0x30, 0x01, /* bytes 192 - 208 */
  0x00, 0x02, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x05, 0x00, 0x08, 0x01, 0xd8, 0x00, 0x88, /* bytes 208 - 224 */
  0x00, 0xd8, 0x00, 0x98, 0x00, 0x98, 0x00, 0x18, 0x01, 0x98, 0x00, 0x08, 0x01, 0xd8, 0x00, 0x03, /* bytes 224 - 240 */
  0x00, 0xc0, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0xd4, 0x01, 0x0c, 0x01, 0x34, 0x02, 0x6c, 0x01, /* bytes 240 - 256 */
  0x03, 0x00, 0xc0, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x34, 0x02, 0xdc, 0x00, 0xd4, 0x01, 0x6c, /* bytes 256 - 272 */
  0x01, 
};
__attribute__ ((aligned (8)))
static const uint8_t ARROW_DOWN_builtin_bytes[] = {
  0x03, 0x00, 0x06, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x06, 0x00, 0x15, 0x55, 0x54, 0x85, /* bytes 0 - 16 */
  0x55, 0x52, 0xa1, 0x55, 0x4a, 0xa8, 0x55, 0x2a, 0xaa, 0x14, 0xaa, 0xaa, 0x82, 0xaa, 0x80, 0xc0, /* bytes 16 - 32 */
  0x00, 0x00, 
};
__attribute__ ((aligned (8)))
static const uint8_t VOICE_MICROPHONE_LARGE_builtin_bytes[] = {
  0x50, 0x44, 0x43, 0x49, 0x09, 0x01, 0x00, 0x00, 0x01, 0x00, 0x50, 0x00, 0x50, 0x00, 0x0d, 0x00, /* bytes 0 - 16 */
  0x03, 0x00, 0xc0, 0x04, 0xff, 0x00, 0x00, 0x09, 0x00, 0x64, 0x01, 0xdc, 0x01, 0xa4, 0x01, 0x9c, /* bytes 16 - 32 */
  0x01, 0xa4, 0x01, 0xb4, 0x00, 0x64, 0x01, 0x74, 0x00, 0x1c, 0x01, 0x74, 0x00, 0xdc, 0x00, 0xb4, /* bytes 32 - 48 */
  0x00, 0xdc, 0x00, 0x9c, 0x01, 0x1c, 0x01, 0xdc, 0x01, 0x64, 0x01, 0xdc, 0x01, 0x03, 0x00, 0xc0, /* bytes 48 - 64 */
  0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0xf4, 0x00, 0x6c, 0x02, 0x8c, 0x01, 0x6c, 0x02, 0x03, 0x00, /* bytes 64 - 80 */
  0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x40, 0x01, 0x38, 0x00, 0x40, 0x01, 0x08, 0x00, 0x03, /* bytes 80 - 96 */
  0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0xb0, 0x01, 0x68, 0x00, 0xe8, 0x01, 0x30, 0x00, /* bytes 96 - 112 */
  0x03, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0xd0, 0x00, 0x68, 0x00, 0x98, 0x00, 0x30, /* bytes 112 - 128 */
  0x00, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0xa0, 0x01, 0xe0, 0x00, 0x40, 0x01, /* bytes 128 - 144 */
  0xc8, 0x00, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x40, 0x01, 0x88, 0x01, 0xa0, /* bytes 144 - 160 */
  0x01, 0x70, 0x01, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0xe0, 0x00, 0xe0, 0x00, /* bytes 160 - 176 */
  0x40, 0x01, 0xc8, 0x00, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x40, 0x01, 0x88, /* bytes 176 - 192 */
  0x01, 0xe0, 0x00, 0x70, 0x01, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x40, 0x01, /* bytes 192 - 208 */
  0x78, 0x00, 0x40, 0x01, 0xd8, 0x01, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0xd8, /* bytes 208 - 224 */
  0x00, 0x28, 0x01, 0xa0, 0x01, 0x28, 0x01, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x04, 0x00, /* bytes 224 - 240 */
  0xd0, 0x01, 0xb8, 0x01, 0x78, 0x01, 0x10, 0x02, 0x08, 0x01, 0x10, 0x02, 0xb0, 0x00, 0xb8, 0x01, /* bytes 240 - 256 */
  0x03, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x40, 0x01, 0x10, 0x02, 0x40, 0x01, 0x68, /* bytes 256 - 272 */
  0x02, 
};
__attribute__ ((aligned (8)))
static const uint8_t JS_TICTOC_builtin_bytes[] = {
  0x50, 0x4a, 0x53, 0x00, 0x01, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xa8, 0x02, 0x00, 0x00, /* bytes 0 - 16 */
  0xc0, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x01, 0x00, 0x01, 0x00, 0x05, 0x00, /* bytes 16 - 32 */
  0x00, 0x06, 0x14, 0x18, 0x1f, 0x00, 0x1a, 0x00, 0x26, 0x00, 0x34, 0x00, 0x15, 0x00, 0x0e, 0x00, /* bytes 32 - 48 */
  0x2a, 0x00, 0x69, 0x00, 0x21, 0x00, 0x5b, 0x00, 0xab, 0x00, 0x59, 0x00, 0x2c, 0x00, 0x23, 0x00, /* bytes 48 - 64 */
  0xad, 0x00, 0x17, 0x00, 0x08, 0x00, 0x0a, 0x00, 0x01, 0x00, 0x03, 0x00, 0x12, 0x00, 0x24, 0x00, /* bytes 64 - 80 */
  0x32, 0x00, 0x4c, 0x00, 0x41, 0x03, 0xcb, 0x04, 0x00, 0xcb, 0x14, 0x01, 0x14, 0x14, 0x28, 0x08, /* bytes 80 - 96 */
  0x18, 0x07, 0x28, 0x0a, 0x18, 0x09, 0x31, 0x18, 0x0b, 0x18, 0x06, 0x14, 0x28, 0x0d, 0x18, 0x07, /* bytes 96 - 112 */
  0x28, 0x0e, 0x18, 0x09, 0x31, 0x18, 0x0b, 0x18, 0x0c, 0xc8, 0x02, 0xcb, 0x15, 0x03, 0x3b, 0x00, /* bytes 112 - 128 */
  0x0f, 0x29, 0x10, 0x16, 0xc4, 0x3b, 0x00, 0x0f, 0x29, 0x11, 0x17, 0xc4, 0x3b, 0x05, 0x12, 0x28, /* bytes 128 - 144 */
  0x13, 0xbe, 0x46, 0x61, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x01, 0x00, 0x01, 0x00, 0x03, 0x01, /* bytes 144 - 160 */
  0x01, 0x07, 0x0d, 0x0e, 0x00, 0x00, 0x90, 0x00, 0x97, 0x00, 0x89, 0x00, 0x9b, 0x00, 0x9d, 0x00, /* bytes 160 - 176 */
  0xa1, 0x00, 0x94, 0x00, 0x86, 0x00, 0x8d, 0x00, 0x7b, 0x00, 0x7f, 0x00, 0x83, 0x00, 0x20, 0x00, /* bytes 176 - 192 */
  0x41, 0x03, 0x42, 0x04, 0x00, 0x42, 0x05, 0x0d, 0x28, 0x04, 0x1d, 0x05, 0x28, 0x06, 0x3e, 0xc8, /* bytes 192 - 208 */
  0x04, 0x3b, 0x04, 0x07, 0xb7, 0x32, 0x3b, 0x8d, 0xc8, 0x01, 0x3b, 0x04, 0x08, 0xb7, 0x32, 0x3b, /* bytes 208 - 224 */
  0x8d, 0xc8, 0x02, 0x3b, 0x04, 0x09, 0xb7, 0x32, 0x0b, 0x90, 0x85, 0x02, 0x32, 0x0b, 0x8d, 0xc8, /* bytes 224 - 240 */
  0x03, 0x29, 0x05, 0x01, 0xba, 0xd1, 0x0a, 0x29, 0x05, 0x02, 0xba, 0xd1, 0x0b, 0x29, 0x05, 0x03, /* bytes 240 - 256 */
  0xba, 0xd1, 0x0c, 0x46, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x01, 0x00, 0x21, 0x00, 0x02, 0x01, /* bytes 256 - 272 */
  0x01, 0x02, 0x04, 0x04, 0x00, 0x00, 0xa6, 0x00, 0xa9, 0x00, 0xa8, 0x00, 0x89, 0x02, 0x00, 0x32, /* bytes 272 - 288 */
  0x01, 0x8a, 0x36, 0x01, 0x03, 0x8a, 0x45, 0x00, 0x0e, 0x00, 0x01, 0x00, 0x21, 0x00, 0x09, 0x05, /* bytes 288 - 304 */
  0x05, 0x06, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0x00, /* bytes 304 - 320 */
  0x72, 0x00, 0x65, 0x00, 0x69, 0x00, 0x6b, 0x00, 0x5f, 0x00, 0x61, 0x00, 0x63, 0x00, 0x59, 0x00, /* bytes 320 - 336 */
  0x5b, 0x00, 0x5d, 0x00, 0x51, 0x00, 0x29, 0x01, 0x06, 0x32, 0x07, 0xc5, 0x2a, 0x01, 0x07, 0x00, /* bytes 336 - 352 */
  0x35, 0x08, 0xc5, 0x3b, 0x01, 0x09, 0xb6, 0x3b, 0x01, 0x0a, 0x29, 0x02, 0x03, 0xc2, 0x3b, 0x01, /* bytes 352 - 368 */
  0x0b, 0x29, 0x02, 0x05, 0x3a, 0x0c, 0x36, 0x00, 0x0d, 0xbd, 0x36, 0x00, 0x0e, 0x8a, 0x8b, 0x04, /* bytes 368 - 384 */
  0x84, 0x29, 0x03, 0x05, 0x3a, 0x0f, 0x36, 0x00, 0x0d, 0xbd, 0x36, 0x00, 0x0e, 0x8a, 0x8b, 0x04, /* bytes 384 - 400 */
  0x84, 0xc2, 0x3b, 0x01, 0x10, 0xb6, 0x46, 0x00, 0x1a, 0x00, 0x01, 0x00, 0x21, 0x00, 0x07, 0x01, /* bytes 400 - 416 */
  0x07, 0x0a, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* bytes 416 - 432 */
  0x00, 0x00, 0xa6, 0x00, 0x34, 0x00, 0x26, 0x00, 0x56, 0x00, 0x4a, 0x00, 0x4c, 0x00, 0x41, 0x00, /* bytes 432 - 448 */
  0x46, 0x00, 0x37, 0x00, 0x39, 0x00, 0x3c, 0x00, 0x2e, 0x00, 0x32, 0x00, 0x2a, 0x00, 0x2c, 0x00, /* bytes 448 - 464 */
  0x69, 0x00, 0x21, 0x00, 0x5b, 0x00, 0x59, 0x00, 0x23, 0x00, 0x36, 0x00, 0x0a, 0xc8, 0x01, 0x36, /* bytes 464 - 480 */
  0x01, 0x0b, 0x35, 0x0c, 0xc8, 0x02, 0x36, 0x01, 0x0b, 0x35, 0x0d, 0xc8, 0x03, 0x2a, 0x01, 0x0e, /* bytes 480 - 496 */
  0x0f, 0xc5, 0x3b, 0x01, 0x10, 0x31, 0x31, 0x36, 0x01, 0x0b, 0x35, 0x11, 0x36, 0x01, 0x0b, 0x35, /* bytes 496 - 512 */
  0x12, 0xb0, 0x04, 0x28, 0x02, 0x32, 0x01, 0x8d, 0xc8, 0x04, 0x28, 0x03, 0x32, 0x01, 0x8d, 0xc8, /* bytes 512 - 528 */
  0x05, 0x3b, 0x07, 0x13, 0x29, 0x02, 0x03, 0x32, 0x01, 0x32, 0x09, 0x8a, 0x87, 0xc3, 0x32, 0x01, /* bytes 528 - 544 */
  0x8d, 0xc8, 0x06, 0x29, 0x08, 0x09, 0x35, 0x14, 0x2a, 0x01, 0x04, 0x05, 0x28, 0x06, 0xad, 0x05, /* bytes 544 - 560 */
  0x29, 0x08, 0x09, 0x35, 0x15, 0x2a, 0x01, 0x04, 0x05, 0x28, 0x06, 0xad, 0x05, 0x28, 0x08, 0x14, /* bytes 560 - 576 */
  0x28, 0x17, 0x18, 0x16, 0x31, 0x18, 0x18, 0x31, 0x18, 0x19, 0x29, 0x01, 0x04, 0x32, 0x07, 0x31, /* bytes 576 - 592 */
  0xad, 0x05, 0x28, 0x08, 0x14, 0x28, 0x1a, 0x18, 0x16, 0x31, 0x18, 0x18, 0x31, 0x18, 0x19, 0x2a, /* bytes 592 - 608 */
  0x01, 0x04, 0x05, 0x31, 0xad, 0x05, 0x46, 0x00, 0x09, 0x00, 0x01, 0x00, 0x21, 0x00, 0x03, 0x01, /* bytes 608 - 624 */
  0x02, 0x05, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x26, 0x00, 0x1f, 0x00, 0x9b, 0x00, /* bytes 624 - 640 */
  0x2a, 0x00, 0x59, 0x00, 0x7f, 0x00, 0x2c, 0x00, 0x83, 0x00, 0x11, 0x00, 0x29, 0x02, 0x00, 0x35, /* bytes 640 - 656 */
  0x05, 0x3f, 0xc8, 0x01, 0x36, 0x03, 0x06, 0x36, 0x01, 0x08, 0xce, 0x07, 0x36, 0x03, 0x09, 0x36, /* bytes 656 - 672 */
  0x01, 0x0a, 0xce, 0x07, 0x3b, 0x04, 0x0b, 0xb6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* bytes 672 - 688 */
  0x3e, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x6c, 0x6f, 0x67, 0x00, 0x00, 0x00, /* bytes 688 - 704 */
  0x0f, 0x00, 0x54, 0x69, 0x63, 0x54, 0x6f, 0x63, 0x20, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x65, /* bytes 704 - 720 */
  0x64, 0x00, 0x00, 0x00, 0x04, 0x00, 0x64, 0x72, 0x61, 0x77, 0x00, 0x00, 0x0c, 0x00, 0x6d, 0x69, /* bytes 720 - 736 */
  0x6e, 0x75, 0x74, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x00, 0x00, 0x07, 0x00, 0x63, 0x6f, /* bytes 736 - 752 */
  0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, /* bytes 752 - 768 */
  0x74, 0x44, 0x72, 0x61, 0x77, 0x00, 0x00, 0x00, 0x06, 0x00, 0x5f, 0x72, 0x6f, 0x63, 0x6b, 0x79, /* bytes 768 - 784 */
  0x02, 0x00, 0x6f, 0x6e, 0x03, 0x00, 0x77, 0x66, 0x68, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x57, 0x61, /* bytes 784 - 800 */
  0x74, 0x63, 0x68, 0x66, 0x61, 0x63, 0x65, 0x48, 0x65, 0x6c, 0x70, 0x65, 0x72, 0x00, 0x00, 0x00, /* bytes 800 - 816 */
  0x05, 0x00, 0x72, 0x6f, 0x63, 0x6b, 0x79, 0x00, 0x05, 0x00, 0x77, 0x68, 0x69, 0x74, 0x65, 0x00, /* bytes 816 - 832 */
  0x03, 0x00, 0x72, 0x65, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0x65, 0x00, 0x0b, 0x00, 0x72, 0x65, /* bytes 832 - 848 */
  0x6e, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x00, 0x00, 0x00, 0x06, 0x00, 0x6d, 0x69, /* bytes 848 - 864 */
  0x6e, 0x75, 0x74, 0x65, 0x04, 0x00, 0x68, 0x6f, 0x75, 0x72, 0x00, 0x00, 0x0c, 0x00, 0x63, 0x6c, /* bytes 864 - 880 */
  0x69, 0x65, 0x6e, 0x74, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x00, 0x00, 0x03, 0x00, 0x6d, 0x69, /* bytes 880 - 896 */
  0x6e, 0x00, 0x00, 0x00, 0x08, 0x00, 0x64, 0x72, 0x61, 0x77, 0x48, 0x61, 0x6e, 0x64, 0x00, 0x00, /* bytes 896 - 912 */
  0x05, 0x00, 0x62, 0x6c, 0x61, 0x63, 0x6b, 0x00, 0x08, 0x00, 0x66, 0x69, 0x6c, 0x6c, 0x52, 0x65, /* bytes 912 - 928 */
  0x63, 0x74, 0x00, 0x00, 0x0b, 0x00, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x57, 0x69, 0x64, 0x74, /* bytes 928 - 944 */
  0x68, 0x00, 0x00, 0x00, 0x01, 0x00, 0x68, 0x00, 0x12, 0x00, 0x75, 0x6e, 0x6f, 0x62, 0x73, 0x74, /* bytes 944 - 960 */
  0x72, 0x75, 0x63, 0x74, 0x65, 0x64, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x09, 0x00, 0x66, 0x69, /* bytes 960 - 976 */
  0x6c, 0x6c, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x00, 0x01, 0x00, 0x77, 0x00, 0x06, 0x00, 0x63, 0x61, /* bytes 976 - 992 */
  0x6e, 0x76, 0x61, 0x73, 0x11, 0x00, 0x75, 0x6e, 0x6f, 0x62, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, /* bytes 992 - 1008 */
  0x65, 0x64, 0x57, 0x69, 0x64, 0x74, 0x68, 0x00, 0x06, 0x00, 0x73, 0x74, 0x72, 0x6f, 0x6b, 0x65, /* bytes 1008 - 1024 */
  0x09, 0x00, 0x64, 0x72, 0x61, 0x77, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x00, 0x07, 0x00, 0x63, 0x6f, /* bytes 1024 - 1040 */
  0x6e, 0x74, 0x65, 0x78, 0x74, 0x00, 0x00, 0x00, 0x05, 0x00, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x00, /* bytes 1040 - 1056 */
  0x05, 0x00, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x00, 0x03, 0x00, 0x63, 0x6f, 0x73, 0x00, 0x00, 0x00, /* bytes 1056 - 1072 */
  0x06, 0x00, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x6f, 0x06, 0x00, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x6f, /* bytes 1072 - 1088 */
  0x03, 0x00, 0x73, 0x69, 0x6e, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x73, 0x74, 0x72, 0x6f, 0x6b, 0x65, /* bytes 1088 - 1104 */
  0x53, 0x74, 0x79, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x05, 0x00, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x00, /* bytes 1104 - 1120 */
  0x09, 0x00, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x00, 0x02, 0x00, 0x63, 0x79, /* bytes 1120 - 1136 */
  0x09, 0x00, 0x6d, 0x61, 0x78, 0x52, 0x61, 0x64, 0x69, 0x75, 0x73, 0x00, 0x09, 0x00, 0x6c, 0x69, /* bytes 1136 - 1152 */
  0x6e, 0x65, 0x57, 0x69, 0x64, 0x74, 0x68, 0x00, 0x09, 0x00, 0x68, 0x61, 0x6e, 0x64, 0x53, 0x74, /* bytes 1152 - 1168 */
  0x61, 0x74, 0x65, 0x00, 0x03, 0x00, 0x63, 0x74, 0x78, 0x00, 0x00, 0x00, 0x02, 0x00, 0x63, 0x78, /* bytes 1168 - 1184 */
  0x0b, 0x00, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x41, 0x6e, 0x67, 0x6c, 0x65, 0x00, 0x00, 0x00, /* bytes 1184 - 1200 */
  0x0b, 0x00, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x41, 0x6e, 0x67, 0x6c, 0x65, 0x00, 0x00, 0x00, /* bytes 1200 - 1216 */
  0x09, 0x00, 0x68, 0x6f, 0x75, 0x72, 0x41, 0x6e, 0x67, 0x6c, 0x65, 0x00, 0x0a, 0x00, 0x67, 0x65, /* bytes 1216 - 1232 */
  0x74, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x0c, 0x00, 0x68, 0x6f, 0x75, 0x72, 0x46, 0x72, /* bytes 1232 - 1248 */
  0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x00, 0x08, 0x00, 0x67, 0x65, 0x74, 0x48, 0x6f, 0x75, /* bytes 1248 - 1264 */
  0x72, 0x73, 0x00, 0x00, 0x0e, 0x00, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x46, 0x72, 0x61, 0x63, /* bytes 1264 - 1280 */
  0x74, 0x69, 0x6f, 0x6e, 0x0a, 0x00, 0x67, 0x65, 0x74, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, /* bytes 1280 - 1296 */
  0x0e, 0x00, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, /* bytes 1296 - 1312 */
  0x04, 0x00, 0x64, 0x61, 0x74, 0x65, 0x00, 0x00, 0x0c, 0x00, 0x63, 0x6c, 0x6f, 0x63, 0x6b, 0x77, /* bytes 1312 - 1328 */
  0x69, 0x73, 0x65, 0x52, 0x61, 0x64, 0x00, 0x00, 0x04, 0x00, 0x44, 0x61, 0x74, 0x65, 0x00, 0x00, /* bytes 1328 - 1344 */
  0x08, 0x00, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x00, 0x04, 0x00, 0x4d, 0x61, /* bytes 1344 - 1360 */
  0x74, 0x68, 0x00, 0x00, 0x02, 0x00, 0x50, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x3f, /* bytes 1360 - 1376 */
  0x9a, 0x99, 0x99, 0x99, 0x99, 0x99, 0xe9, 0x3f, 0x52, 0xb8, 0x1e, 0x85, 0xeb, 0x51, 0xe0, 0x3f, 
};

const uint32_t g_num_builtin_resources = 11;
const BuiltInResourceData g_builtin_resources[] = {
  { RESOURCE_ID_ACTION_BAR_ICON_CHECK, ACTION_BAR_ICON_CHECK_builtin_bytes, sizeof(ACTION_BAR_ICON_CHECK_builtin_bytes) },
  { RESOURCE_ID_GENERIC_WARNING_LARGE, GENERIC_WARNING_LARGE_builtin_bytes, sizeof(GENERIC_WARNING_LARGE_builtin_bytes) },
  { RESOURCE_ID_FONT_FALLBACK_INTERNAL, FONT_FALLBACK_INTERNAL_builtin_bytes, sizeof(FONT_FALLBACK_INTERNAL_builtin_bytes) },
  { RESOURCE_ID_ACTION_BAR_ICON_UP, ACTION_BAR_ICON_UP_builtin_bytes, sizeof(ACTION_BAR_ICON_UP_builtin_bytes) },
  { RESOURCE_ID_ACTION_BAR_ICON_DOWN, ACTION_BAR_ICON_DOWN_builtin_bytes, sizeof(ACTION_BAR_ICON_DOWN_builtin_bytes) },
  { RESOURCE_ID_GENERIC_WARNING_TINY, GENERIC_WARNING_TINY_builtin_bytes, sizeof(GENERIC_WARNING_TINY_builtin_bytes) },
  { RESOURCE_ID_CHECK_INTERNET_CONNECTION_LARGE, CHECK_INTERNET_CONNECTION_LARGE_builtin_bytes, sizeof(CHECK_INTERNET_CONNECTION_LARGE_builtin_bytes) },
  { RESOURCE_ID_WATCH_DISCONNECTED_LARGE, WATCH_DISCONNECTED_LARGE_builtin_bytes, sizeof(WATCH_DISCONNECTED_LARGE_builtin_bytes) },
  { RESOURCE_ID_ARROW_DOWN, ARROW_DOWN_builtin_bytes, sizeof(ARROW_DOWN_builtin_bytes) },
  { RESOURCE_ID_VOICE_MICROPHONE_LARGE, VOICE_MICROPHONE_LARGE_builtin_bytes, sizeof(VOICE_MICROPHONE_LARGE_builtin_bytes) },
  { RESOURCE_ID_JS_TICTOC, JS_TICTOC_builtin_bytes, sizeof(JS_TICTOC_builtin_bytes) },
};
