/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */



// ----------------------------------------------------------------
// Sample captured: 2015-10-16 17:23:19 local
AccelRawData *activity_sample_walk_200_pbl_28396_8(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_28396_8
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 180
  //> TEST_EXPECTED_MAX 220
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -112, -208, -992},
    { -136, -216, -1000},
    { -144, -200, -1000},
    { -136, -208, -1000},
    { -144, -168, -984},
    { -144, -264, -928},
    { -200, -256, -944},
    { -312, -192, -960},
    { 80, -232, -1040},
    { -232, -592, -1008},
    { -544, 8, -992},
    { -216, -96, -1032},
    { -160, -112, -992},
    { -80, -24, -992},
    { -48, -16, -968},
    { -48, -48, -984},
    { -8, -40, -984},
    { -16, -32, -936},
    { -16, 184, -856},
    { -56, 344, -848},
    { -32, 416, -864},
    { -40, 448, -856},
    { 0, 320, -832},
    { 32, 288, -896},
    { -56, 360, -824},
    // 1 seconds
    { -120, 344, -728},
    { -104, 224, -680},
    { -256, 360, -496},
    { -272, 728, -272},
    { -248, 936, -32},
    { -120, 1152, 320},
    { -24, 1128, 520},
    { 0, 976, 464},
    { 40, 872, 552},
    { 56, 912, 528},
    { 48, 880, 520},
    { 16, 808, 440},
    { -8, 848, 432},
    { -32, 808, 400},
    { 16, 776, 408},
    { -16, 808, 392},
    { -24, 896, 368},
    { -16, 816, 344},
    { -40, 816, 344},
    { -16, 880, 152},
    { 8, 936, 88},
    { -8, 848, -40},
    { -72, 672, -120},
    { -240, 536, -160},
    { -432, 288, -240},
    // 2 seconds
    { -832, 296, -232},
    { -1544, 288, 16},
    { -1912, 192, 104},
    { -2104, 424, -344},
    { -1768, 384, -240},
    { -1192, 184, -144},
    { -896, 48, -96},
    { -928, 128, -16},
    { -848, 192, 56},
    { -768, 160, 104},
    { -688, 160, 104},
    { -648, 184, 24},
    { -704, 264, -152},
    { -816, 448, -136},
    { -1152, 608, -168},
    { -1472, 808, -104},
    { -1832, 592, -328},
    { -1264, 400, -464},
    { -1464, 328, -320},
    { -1496, 224, -336},
    { -1296, 120, -280},
    { -1176, 32, -120},
    { -1040, -16, 0},
    { -944, 8, -24},
    { -872, 80, -24},
    // 3 seconds
    { -784, 32, 32},
    { -792, 16, 112},
    { -768, -120, 384},
    { -1024, 256, 96},
    { -1400, 328, -176},
    { -1384, 328, -328},
    { -1464, 296, -416},
    { -1384, 0, -216},
    { -1184, 152, -344},
    { -936, 216, -168},
    { -760, 272, -16},
    { -776, 328, -40},
    { -800, 288, -16},
    { -840, 224, 48},
    { -1200, 480, -112},
    { -1624, 512, 672},
    { -1304, 928, 800},
    { -1224, 1112, -8},
    { -1112, 688, 272},
    { -1328, 432, 160},
    { -1616, 472, 168},
    { -1376, 448, 80},
    { -1088, 240, 80},
    { -952, -96, 400},
    { -1096, 88, 200},
    // 4 seconds
    { -1144, 96, 152},
    { -1072, 72, 112},
    { -1104, 56, 104},
    { -1032, 16, 80},
    { -968, -72, 56},
    { -1192, 112, -176},
    { -1120, 112, -368},
    { -1264, 152, -304},
    { -1408, -168, -144},
    { -1336, -48, -168},
    { -1104, 120, -136},
    { -896, 280, -24},
    { -976, 344, -72},
    { -1136, 232, -48},
    { -1096, 184, -136},
    { -1320, 304, -288},
    { -1400, 608, -224},
    { -1440, 464, -256},
    { -1536, 328, -344},
    { -960, 360, -400},
    { -1216, 384, -200},
    { -1544, 224, 56},
    { -1496, 64, 56},
    { -1168, 48, -8},
    { -1072, 88, 0},
    // 5 seconds
    { -1112, 88, 56},
    { -1152, 72, 64},
    { -1120, 64, 40},
    { -1280, 56, 104},
    { -1192, -144, 208},
    { -1232, -200, 112},
    { -1192, -88, -248},
    { -976, -152, -184},
    { -1200, -16, -192},
    { -1264, -48, -232},
    { -1080, -24, -200},
    { -952, 56, -128},
    { -960, 160, -72},
    { -1168, 296, -176},
    { -1296, 416, -240},
    { -1256, 584, -280},
    { -1248, 1016, -336},
    { -1168, 200, -256},
    { -1584, 576, -152},
    { -1296, 312, -160},
    { -1224, 304, -216},
    { -1352, 248, -96},
    { -1360, 200, -32},
    { -1240, 232, -88},
    { -1072, 184, -48},
    // 6 seconds
    { -1056, 120, -8},
    { -1056, 88, 40},
    { -944, 64, 24},
    { -960, 72, -16},
    { -1072, 8, -16},
    { -896, -152, 0},
    { -1224, -48, -136},
    { -1296, 72, -312},
    { -1120, 88, -248},
    { -1384, 88, -416},
    { -1504, 72, -152},
    { -1328, 112, 16},
    { -1128, 288, 136},
    { -1088, 544, 0},
    { -1152, 664, -240},
    { -1024, 640, 8},
    { -888, 720, -120},
    { -912, 776, -168},
    { -864, 896, -144},
    { -1200, 896, -64},
    { -1296, 688, -56},
    { -1160, 656, -120},
    { -1240, 544, -96},
    { -1472, 512, 24},
    { -1520, 488, 88},
    // 7 seconds
    { -1368, 408, 120},
    { -1296, 264, 120},
    { -1216, 248, 168},
    { -1120, 216, 144},
    { -968, 168, 88},
    { -1032, 24, 144},
    { -848, -184, 104},
    { -864, 8, -80},
    { -1256, 144, -80},
    { -1288, 336, -176},
    { -1096, 416, -408},
    { -1232, 224, -200},
    { -1288, 104, -24},
    { -1168, 88, 72},
    { -1112, 248, 176},
    { -1128, 456, 112},
    { -1176, 496, 48},
    { -1152, 512, -40},
    { -984, 528, 0},
    { -1136, 784, -168},
    { -1080, 352, -248},
    { -1488, 560, -288},
    { -1424, 656, -224},
    { -1096, 384, -296},
    { -1128, 352, -200},
    // 8 seconds
    { -1368, 360, -16},
    { -1560, 280, 120},
    { -1296, 136, 120},
    { -1136, 80, 96},
    { -1104, 88, 128},
    { -1056, 88, 104},
    { -1000, 96, -56},
    { -1112, 80, 56},
    { -1232, 64, -8},
    { -1120, -48, -112},
    { -1184, -136, -24},
    { -1024, 0, -88},
    { -1136, 16, -144},
    { -1232, 8, -56},
    { -1280, 48, 72},
    { -1240, 88, 80},
    { -1264, 200, 136},
    { -1360, 328, 184},
    { -1392, 456, 176},
    { -1248, 760, -80},
    { -1104, 320, -128},
    { -1304, 416, -192},
    { -1184, 464, -128},
    { -1528, 856, -112},
    { -1352, 512, -128},
    // 9 seconds
    { -1008, 264, -184},
    { -1072, 336, -48},
    { -1504, 416, 104},
    { -1720, 272, 248},
    { -1400, 88, 264},
    { -1216, -48, 200},
    { -1168, 8, 200},
    { -1152, 48, 184},
    { -1128, 96, 208},
    { -1152, 64, 240},
    { -1024, -16, 232},
    { -1136, -8, 256},
    { -1184, 208, -56},
    { -1120, 136, -608},
    { -1232, -112, -184},
    { -1176, -456, -224},
    { -1096, -240, -272},
    { -1032, -24, -184},
    { -1080, 120, -40},
    { -1152, 240, 128},
    { -1256, 408, 24},
    { -1400, 792, -208},
    { -1208, 1792, -312},
    { -912, -296, -24},
    { -1640, 304, -312},
    // 10 seconds
    { -1488, 480, -144},
    { -1168, 232, -232},
    { -1288, 144, -192},
    { -1384, 216, -64},
    { -1224, 176, -40},
    { -1016, 200, -96},
    { -992, 384, -16},
    { -1040, 384, 168},
    { -1064, 248, 152},
    { -1072, 208, 176},
    { -1152, 168, 216},
    { -1072, 128, 168},
    { -1256, 112, 240},
    { -1392, 72, 48},
    { -1064, 184, -144},
    { -1104, 248, -200},
    { -1272, 144, -64},
    { -1184, 120, 80},
    { -1096, 208, 136},
    { -1096, 392, 168},
    { -1128, 456, 192},
    { -1192, 536, 176},
    { -1120, 680, 64},
    { -1040, 656, -40},
    { -1320, 1048, 48},
    // 11 seconds
    { -1024, 176, 88},
    { -1248, 856, -280},
    { -1208, 736, -232},
    { -1208, 696, -200},
    { -1432, 616, -88},
    { -1696, 536, 24},
    { -1528, 408, 184},
    { -1440, 128, 800},
    { -1344, 160, 224},
    { -1240, 208, 144},
    { -1176, 200, 160},
    { -1152, 144, 232},
    { -1072, -8, 216},
    { -800, -176, 224},
    { -1144, -24, 56},
    { -1088, 56, -104},
    { -1112, 200, -104},
    { -1424, 184, -128},
    { -1400, -16, 72},
    { -1296, 8, 104},
    { -1352, 344, -64},
    { -1352, 456, 32},
    { -1320, 472, -8},
    { -1240, 696, -112},
    { -1216, 888, -336},
    // 12 seconds
    { -1376, 472, -264},
    { -1320, 616, -368},
    { -1488, 752, -264},
    { -1200, 456, -256},
    { -1200, 440, -160},
    { -1328, 360, -40},
    { -1448, 304, 16},
    { -1240, 248, 48},
    { -1128, 200, 64},
    { -1096, 128, 136},
    { -1104, 88, 152},
    { -1168, 128, 112},
    { -1384, 48, 56},
    { -1032, -624, 288},
    { -1232, -288, -8},
    { -1384, -40, -24},
    { -1384, 296, -344},
    { -1464, 264, -368},
    { -1352, 184, 56},
    { -1208, 72, 136},
    { -1128, 216, 160},
    { -1120, 360, 192},
    { -1160, 552, 48},
    { -1184, 624, 8},
    { -944, 1024, -120},
    // 13 seconds
    { -816, 480, -80},
    { -1056, 440, -16},
    { -1088, 512, 0},
    { -1448, 680, -128},
    { -1272, 456, -80},
    { -1584, 280, 144},
    { -1640, 256, 24},
    { -1560, 208, -184},
    { -1384, 288, -256},
    { -1280, 280, 0},
    { -1176, 184, 104},
    { -1088, 96, 104},
    { -992, 80, 104},
    { -976, 48, 160},
    { -1008, -56, 240},
    { -960, -24, 192},
    { -1176, 72, 72},
    { -1096, 248, -328},
    { -1304, 48, -352},
    { -1416, -208, -40},
    { -1392, -88, -48},
    { -1112, 192, -232},
    { -1048, 248, -176},
    { -1112, 240, 24},
    { -1216, 304, -16},
    // 14 seconds
    { -1224, 360, -48},
    { -1392, 576, -184},
    { -1320, 816, -176},
    { -1464, 600, -256},
    { -1384, 648, -152},
    { -1056, 496, -256},
    { -1216, 408, -232},
    { -1424, 376, -48},
    { -1448, 248, 8},
    { -1256, 216, 16},
    { -1136, 152, 8},
    { -1128, 128, 64},
    { -1192, 176, 152},
    { -1200, 136, 144},
    { -1336, 168, 200},
    { -1224, -72, 184},
    { -1112, -424, 248},
    { -1280, 32, -40},
    { -1248, 152, -256},
    { -1304, 120, -224},
    { -1336, -160, 32},
    { -1288, -88, 16},
    { -1192, 192, -80},
    { -1080, 256, 32},
    { -1064, 352, 128},
    // 15 seconds
    { -1056, 368, -224},
    { -1088, 616, -176},
    { -1344, 624, 0},
    { -1352, 744, 32},
    { -1144, 736, -48},
    { -1344, 792, 0},
    { -1064, 616, 8},
    { -1088, 488, -64},
    { -1184, 488, -48},
    { -1336, 424, 8},
    { -1280, 368, 56},
    { -1192, 280, 112},
    { -1200, 224, 144},
    { -1272, 216, 152},
    { -1296, 192, 168},
    { -1280, 192, 200},
    { -1256, 152, 152},
    { -1144, -72, 120},
    { -1240, -152, 88},
    { -1160, 128, -328},
    { -1144, -48, -152},
    { -1320, 152, -24},
    { -1264, 200, 16},
    { -1064, 328, 32},
    { -944, 408, 56},
    // 16 seconds
    { -904, 264, 232},
    { -1248, 680, 40},
    { -1104, 136, 136},
    { -1264, 872, 64},
    { -1344, 888, 48},
    { -1160, 912, 144},
    { -1304, 1256, 80},
    { -1016, 976, 16},
    { -928, 896, -104},
    { -1128, 696, 24},
    { -1352, 560, 192},
    { -1312, 440, 216},
    { -1208, 360, 216},
    { -1200, 344, 232},
    { -1248, 328, 272},
    { -1232, 248, 232},
    { -1128, 56, 192},
    { -1240, 128, 200},
    { -1072, -88, 136},
    { -1280, -32, 176},
    { -1232, 264, -184},
    { -1096, 200, -176},
    { -1200, 88, -120},
    { -1152, 8, 56},
    { -1008, 64, -8},
    // 17 seconds
    { -920, 184, -64},
    { -1008, 208, 48},
    { -1152, 232, 168},
    { -1312, 368, 72},
    { -1336, 456, -32},
    { -1600, 712, 8},
    { -1280, 656, -64},
    { -1584, 464, -272},
    { -1024, 528, -224},
    { -1048, 616, -144},
    { -1296, 520, 16},
    { -1408, 344, 64},
    { -1192, 216, 56},
    { -1056, 184, 56},
    { -1056, 128, 96},
    { -1120, 176, 144},
    { -1168, 120, 152},
    { -1264, 120, 192},
    { -1296, 104, 160},
    { -1144, 0, 88},
    { -1304, -40, -16},
    { -1200, 240, -384},
    { -1032, 64, -160},
    { -1176, -112, 48},
    { -1160, -232, 24},
    // 18 seconds
    { -1000, -24, -40},
    { -872, 152, 24},
    { -888, 176, 144},
    { -1088, 368, 24},
    { -1192, 408, -96},
    { -1480, 472, 56},
    { -1440, 1280, 208},
    { -1520, 688, 0},
    { -1280, 832, 72},
    { -832, 824, -32},
    { -1128, 600, 80},
    { -1456, 480, 296},
    { -1392, 480, 240},
    { -1120, 400, 128},
    { -1032, 320, 200},
    { -1088, 224, 200},
    { -1112, 176, 232},
    { -1096, 176, 216},
    { -1176, 144, 256},
    { -1016, -120, 224},
    { -1032, -104, 64},
    { -1264, 152, -24},
    { -1136, 384, -168},
    { -1176, 280, -256},
    { -1368, 160, -48},
    // 19 seconds
    { -1288, 40, 56},
    { -1096, 176, 24},
    { -896, 264, 72},
    { -928, 72, 200},
    { -1152, 456, 184},
    { -1160, 584, 240},
    { -1152, 712, 256},
    { -984, 912, 432},
    { -976, 848, 208},
    { -1328, 832, 320},
    { -968, 696, 272},
    { -1000, 824, 136},
    { -1272, 640, 264},
    { -1368, 440, 328},
    { -1120, 392, 232},
    { -1064, 288, 224},
    { -1152, 232, 288},
    { -1200, 224, 304},
    { -1192, 112, 272},
    { -1128, 104, 272},
    { -1144, 144, 256},
    { -912, 288, -24},
    { -1152, 296, -24},
    { -952, 576, -144},
    { -928, 472, -200},
    // 20 seconds
    { -1104, 400, -152},
    { -1032, 32, 144},
    { -944, 176, 32},
    { -824, 240, 112},
    { -880, 184, 192},
    { -1016, 256, 192},
    { -1240, 568, -8},
    { -1328, 672, -8},
    { -1288, 1104, 624},
    { -1216, 744, -464},
    { -1568, 912, -200},
    { -1040, 616, -32},
    { -1104, 584, -32},
    { -1328, 384, 104},
    { -1336, 208, 128},
    { -1048, 232, 144},
    { -896, 200, 120},
    { -936, 208, 144},
    { -1008, 104, 272},
    { -1120, 112, 232},
    { -1288, 24, 328},
    { -1208, 56, 296},
    { -1192, 96, 208},
    { -1208, 72, 144},
    { -944, 280, -152},
    // 21 seconds
    { -824, 232, -248},
    { -1328, 176, -64},
    { -1376, 40, 56},
    { -1208, 112, -80},
    { -1024, 152, 8},
    { -968, 232, 208},
    { -1064, 248, 216},
    { -1136, 512, 152},
    { -864, 408, 224},
    { -952, 248, 168},
    { -1144, 776, 144},
    { -1448, 1008, 40},
    { -1032, 720, 8},
    { -1064, 672, -88},
    { -1240, 664, 160},
    { -1296, 520, 136},
    { -1120, 512, 120},
    { -1016, 344, 176},
    { -1040, 240, 240},
    { -1096, 168, 256},
    { -1136, 216, 264},
    { -1112, 136, 272},
    { -1176, 120, 304},
    { -1096, 56, 256},
    { -1256, -112, 216},
    // 22 seconds
    { -1248, 392, -72},
    { -1032, 456, -184},
    { -1152, 336, -96},
    { -1240, 272, 0},
    { -1112, 312, -32},
    { -928, 328, 40},
    { -904, 208, 144},
    { -1032, 256, 160},
    { -1120, 280, -32},
    { -1144, 424, -80},
    { -1288, 752, -136},
    { -1192, 744, -120},
    { -1416, 624, -344},
    { -1480, 664, -88},
    { -1224, 432, -8},
    { -1400, 328, 56},
    { -1448, 248, 16},
    { -1312, 192, -32},
    { -1104, 152, -24},
    { -1008, 56, 16},
    { -1032, 48, 16},
    { -1080, 80, 8},
    { -1160, 224, -104},
    { -1240, 144, -48},
    { -1040, -128, 80},
    // 23 seconds
    { -1032, -304, -16},
    { -1248, -144, -200},
    { -1112, 32, -248},
    { -1112, -104, -192},
    { -1256, -24, -16},
    { -1248, 0, 24},
    { -1064, 96, -8},
    { -1008, 168, 104},
    { -1152, 224, 128},
    { -1312, 320, 88},
    { -1264, 400, 8},
    { -1216, 656, -160},
    { -1344, 688, -272},
    { -1496, 432, -408},
    { -1552, 408, -552},
    { -1112, 296, -408},
    { -1472, 336, -296},
    { -1728, 224, 24},
    { -1576, 136, 16},
    { -1224, 128, 0},
    { -1120, 152, 56},
    { -1216, 224, 72},
    { -1208, 152, 120},
    { -1144, 64, 152},
    { -1080, -8, 168},
    // 24 seconds
    { -960, -104, 216},
    { -928, -184, 184},
    { -1104, -16, 40},
    { -1112, -8, -296},
    { -1272, 40, -184},
    { -1488, -48, -160},
    { -1432, -96, -168},
    { -1232, 32, -160},
    { -1136, 152, -80},
    { -1120, 232, 104},
    { -1160, 312, -48},
    { -1192, 344, -128},
    { -1264, 528, -80},
    { -1376, 592, -112},
    { -1320, 376, -216},
    { -1528, 320, -200},
    { -1064, 272, -208},
    { -1192, 336, -224},
    { -1440, 344, -32},
    { -1512, 248, 48},
    { -1320, 192, 0},
    { -1176, 136, 80},
    { -1200, 104, 216},
    { -1248, 112, 176},
    { -1184, 56, 168},
    // 25 seconds
    { -1160, 96, 168},
    { -1152, 224, 104},
    { -1096, 96, 192},
    { -1168, -40, 48},
    { -952, -64, -400},
    { -1072, -96, -192},
    { -1296, -216, -80},
    { -1224, -168, -64},
    { -1072, 32, -16},
    { -1000, 240, 32},
    { -1072, 232, 48},
    { -1232, 328, 72},
    { -1288, 448, -16},
    { -1320, 520, 88},
    { -1392, 864, -88},
    { -1352, 376, -64},
    { -1640, 392, -232},
    { -1112, 408, -344},
    { -1184, 360, -384},
    { -1376, 328, -160},
    { -1472, 240, 8},
    { -1272, 136, 32},
    { -1128, 96, 96},
    { -1144, 104, 144},
    { -1160, 152, 168},
    // 26 seconds
    { -1128, 152, 144},
    { -1128, 184, 144},
    { -1120, 72, 216},
    { -928, -200, 240},
    { -1152, -64, 16},
    { -1232, 8, -288},
    { -1216, 56, -192},
    { -1432, -184, -280},
    { -1376, -208, -32},
    { -1256, -32, -160},
    { -1064, 280, -32},
    { -992, 256, 104},
    { -1104, 432, 296},
    { -1136, 536, 264},
    { -968, 560, 296},
    { -1240, 280, -200},
    { -1064, 760, 280},
    { -1248, 1024, 152},
    { -1120, 912, 160},
    { -880, 920, -32},
    { -1104, 784, 0},
    { -1352, 600, 216},
    { -1264, 552, 272},
    { -1144, 440, 304},
    { -1144, 304, 344},
    // 27 seconds
    { -1232, 248, 328},
    { -1224, 288, 352},
    { -1176, 176, 272},
    { -1160, 152, 304},
    { -1184, 104, 184},
    { -1200, -56, 184},
    { -1216, -40, 144},
    { -944, 168, -208},
    { -920, 64, -80},
    { -1128, 8, 32},
    { -1232, 40, 24},
    { -1056, 72, -8},
    { -1064, 208, -72},
    { -1216, 176, 0},
    { -1376, 344, -136},
    { -1360, 440, -296},
    { -1320, 464, -336},
    { -1424, 400, -280},
    { -1184, 56, -248},
    { -1608, 264, -256},
    { -1200, 336, -128},
    { -1184, 264, -16},
    { -1352, 264, 72},
    { -1392, 200, 136},
    { -1200, 144, 88},
    // 28 seconds
    { -1104, 96, 80},
    { -1096, 96, 88},
    { -1184, 40, 136},
    { -1192, 24, 88},
    { -1120, -40, 152},
    { -1136, -120, 168},
    { -960, -112, 120},
    { -1240, -104, 232},
    { -1200, 272, -72},
    { -984, 288, -16},
    { -1120, -248, 56},
    { -1240, -440, 16},
    { -1128, -152, 80},
    { -1072, 152, 144},
    { -1120, 304, 176},
    { -1168, 424, 344},
    { -1216, 480, 160},
    { -1224, 424, 40},
    { -1296, 512, -24},
    { -1152, 416, -40},
    { -1592, 352, -32},
    { -1296, 416, -112},
    { -1304, 376, -80},
    { -1456, 368, 16},
    { -1456, 272, 120},
    // 29 seconds
    { -1312, 64, 104},
    { -1184, -48, 128},
    { -1088, -32, 224},
    { -1088, -56, 152},
    { -1000, 80, 320},
    { -1040, 208, 272},
    { -1008, 104, 328},
    { -864, 216, 144},
    { -1104, 88, 216},
    { -1240, 312, -192},
    { -1056, 280, -192},
    { -1192, -24, -64},
    { -1304, -8, -72},
    { -1128, 104, -72},
    { -936, 168, 0},
    { -936, 208, 128},
    { -1096, 296, 200},
    { -1288, 512, 112},
    { -1208, 528, 112},
    { -1360, 744, 72},
    { -1032, 792, 72},
    { -1608, 664, 88},
    { -1168, 608, -16},
    { -904, 672, -160},
    { -1216, 560, -8},
    // 30 seconds
    { -1416, 424, 104},
    { -1272, 408, 104},
    { -1136, 272, 120},
    { -1032, 208, 208},
    { -1048, 168, 216},
    { -1080, 176, 144},
    { -1192, 344, 144},
    { -944, -528, 520},
    { -1032, -56, 56},
    { -1256, -112, 232},
    { -1512, -88, 24},
    { -1264, -120, -360},
    { -1192, -144, -304},
    { -1184, -128, -64},
    { -1144, 0, -56},
    { -912, 8, -80},
    { -792, 24, -32},
    { -904, 152, 56},
    { -1032, 256, 48},
    { -1160, 384, -88},
    { -1200, 408, -64},
    { -1328, 1176, -320},
    { -1168, 320, -104},
    { -1776, 392, -128},
    { -952, 440, -256},
    // 31 seconds
    { -1256, 496, -152},
    { -1544, 392, 104},
    { -1376, 272, 72},
    { -1104, 256, 48},
    { -1008, 128, 120},
    { -1008, 80, 160},
    { -1024, 32, 200},
    { -1024, 24, 160},
    { -1048, 88, 136},
    { -1064, 64, 144},
    { -1112, 48, 128},
    { -1368, 184, -16},
    { -1160, 408, -424},
    { -1008, 192, -296},
    { -1272, 72, -152},
    { -1296, 24, 48},
    { -1088, 232, 40},
    { -920, 232, 192},
    { -960, 456, 328},
    { -928, 240, 304},
    { -904, 368, 240},
    { -896, 304, 80},
    { -1360, 616, -200},
    { -1376, 448, 344},
    { -1136, 1624, 136},
    // 32 seconds
    { -1208, 1208, -400},
    { -888, 720, -192},
    { -1152, 480, 0},
    { -1336, 480, 120},
    { -1296, 400, 160},
    { -1136, 288, 240},
    { -1096, 192, 224},
    { -1128, 104, 200},
    { -1128, 120, 240},
    { -1120, 96, 248},
    { -1312, -32, 296},
    { -1168, -136, 104},
    { -1280, 0, 168},
    { -1264, 264, -32},
    { -984, 368, -216},
    { -1080, 216, -152},
    { -1160, 112, -56},
    { -1040, -8, -40},
    { -936, 320, -24},
    { -872, 368, 104},
    { -928, 376, 64},
    { -960, 480, 88},
    { -960, 472, 144},
    { -1360, 592, 208},
    { -1432, 640, 488},
    // 33 seconds
    { -1664, 1080, 312},
    { -968, 688, -40},
    { -736, 624, -96},
    { -960, 504, 96},
    { -1184, 336, 216},
    { -1176, 320, 248},
    { -992, 248, 224},
    { -936, 272, 184},
    { -992, 192, 248},
    { -1008, 208, 264},
    { -1072, 152, 272},
    { -1328, 144, 288},
    { -1296, 128, 184},
    { -1440, 168, 168},
    { -1216, 448, -128},
    { -928, 400, -200},
    { -960, 336, -144},
    { -992, 192, -96},
    { -912, 152, -8},
    { -808, 168, 64},
    { -792, 176, 144},
    { -872, 152, 168},
    { -984, 360, 136},
    { -936, 320, 88},
    { -1136, 432, 104},
    // 34 seconds
    { -1352, 584, 312},
    { -1224, 720, 128},
    { -1504, 776, 88},
    { -928, 544, -16},
    { -1080, 576, 16},
    { -1272, 448, 88},
    { -1192, 352, 64},
    { -976, 272, 80},
    { -944, 176, 120},
    { -992, 128, 144},
    { -1040, 144, 200},
    { -1024, 120, 176},
    { -1160, 168, 256},
    { -1296, 176, 272},
    { -1232, -112, 168},
    { -1408, -48, 128},
    { -1064, 248, -168},
    { -1024, 280, -160},
    { -1176, 176, -24},
    { -1128, 56, 96},
    { -1008, 184, 120},
    { -872, 288, 136},
    { -928, 232, 184},
    { -1040, 248, 232},
    { -1040, 352, 176},
    // 35 seconds
    { -944, 504, 72},
    { -1080, 576, 200},
    { -1016, 488, 136},
    { -1448, 656, -24},
    { -1328, 528, 72},
    { -1304, 512, 80},
    { -1664, 392, 40},
    { -1560, 312, 48},
    { -1136, 240, 0},
    { -1000, 176, 88},
    { -960, 136, 136},
    { -944, 128, 152},
    { -912, 56, 192},
    { -952, -8, 200},
    { -1128, -336, 376},
    { -960, -232, 424},
    { -1232, -32, 144},
    { -1328, 288, -16},
    { -1416, 216, 96},
    { -1640, 320, 152},
    { -1480, 344, 32},
    { -1232, 424, -80},
    { -904, 280, 88},
    { -800, 272, 216},
    { -880, 320, 144},
    // 36 seconds
    { -1008, 360, 112},
    { -1104, 448, 96},
    { -1200, 552, 296},
    { -936, 776, 256},
    { -1512, 616, 168},
    { -1224, 400, 176},
    { -1272, 560, 80},
    { -1512, 480, 240},
    { -1656, 360, 296},
    { -1352, 256, 280},
    { -1144, 144, 256},
    { -1104, 64, 256},
    { -1064, 112, 264},
    { -1056, 112, 232},
    { -1032, 56, 256},
    { -1064, 72, 296},
    { -936, 120, 72},
    { -1264, -24, 264},
    { -1144, 128, 80},
    { -976, 400, -144},
    { -1256, 360, -112},
    { -1536, 184, -32},
    { -1416, 280, 152},
    { -1272, 152, 240},
    { -1224, 480, 440},
    // 37 seconds
    { -1256, 624, 432},
    { -1248, 496, 200},
    { -1056, 480, 376},
    { -1120, 608, 192},
    { -904, 648, 224},
    { -1264, 984, 256},
    { -1104, 712, 192},
    { -1136, 584, 176},
    { -1280, 536, 200},
    { -1504, 512, 264},
    { -1296, 392, 304},
    { -1200, 256, 336},
    { -1072, 136, 744},
    { -1256, 176, 344},
    { -1248, 160, 328},
    { -1232, 136, 344},
    { -1240, 64, 376},
    { -1040, 0, 224},
    { -1168, -16, 232},
    { -1264, 280, -32},
    { -1008, 568, -232},
    { -976, 64, 112},
    { -1288, -96, 56},
    { -1288, 240, -16},
    { -1072, 264, 40},
    // 38 seconds
    { -1056, 312, 64},
    { -1216, 384, 136},
    { -1248, 456, 96},
    { -1136, 520, 32},
    { -1240, 576, -16},
    { -1144, 488, 32},
    { -1472, 544, -16},
    { -1216, 672, -88},
    { -1032, 560, -112},
    { -1360, 536, 24},
    { -1632, 440, 176},
    { -1440, 336, 128},
    { -1232, 232, 160},
    { -1224, 184, 208},
    { -1232, 104, 256},
    { -1240, 104, 248},
    { -1256, 96, 232},
    { -1200, 48, 280},
    { -1016, -16, 160},
    { -1048, 0, 144},
    { -1008, 64, -48},
    { -976, 400, -272},
    { -1184, 168, -104},
    { -1496, -8, 8},
    { -1352, 160, -40},
    // 39 seconds
    { -1144, 168, 24},
    { -1080, 280, 128},
    { -1104, 352, 192},
    { -1184, 448, 72},
    { -1176, 424, 24},
    { -1368, 544, -8},
    { -1272, 1096, -48},
    { -1336, 648, -304},
    { -1368, 672, -272},
    { -1184, 544, -152},
    { -1344, 424, -24},
    { -1464, 344, 120},
    { -1368, 288, 120},
    { -1160, 288, 104},
    { -1080, 240, 152},
    { -1096, 176, 192},
    { -1088, 120, 184},
    { -1016, 72, 176},
    { -1096, 48, 144},
    { -960, -232, 40},
    { -968, -88, -16},
    { -1320, 88, -112},
    { -1328, 232, -392},
    { -1528, 40, -112},
    { -1504, -272, 128},
    // 40 seconds
    { -1336, 80, -24},
    { -1056, 248, -48},
    { -912, 232, 64},
    { -968, 288, 16},
    { -1096, 312, -24},
    { -1168, 296, -24},
    { -1296, 440, -112},
    { -1200, 1024, -280},
    { -1264, 216, -8},
    { -1520, 448, -40},
    { -1000, 496, -192},
    { -1232, 488, -168},
    { -1408, 360, -8},
    { -1296, 248, -56},
    { -1112, 200, -24},
    { -1136, 168, 80},
    { -1344, 88, 168},
    { -1192, 72, 152},
    { -1184, 144, 128},
    { -1216, 144, 136},
    { -1192, -176, 192},
    { -1176, -344, 240},
    { -1224, 200, -216},
    { -1272, 88, -304},
    { -1504, 272, -144},
    // 41 seconds
    { -1288, -224, 136},
    { -1072, -168, 112},
    { -976, 136, 104},
    { -880, 312, 168},
    { -968, 344, 112},
    { -1096, 432, -24},
    { -1120, 440, -56},
    { -1368, 544, -16},
    { -1312, 1352, -40},
    { -1376, -56, -72},
    { -1544, 296, -144},
    { -912, 392, -312},
    { -1144, 496, -168},
    { -1392, 368, 80},
    { -1472, 192, 112},
    { -1176, 88, 120},
    { -1048, 88, 152},
    { -1064, 88, 192},
    { -1072, 80, 192},
    { -1096, 88, 168},
    { -1200, 112, 160},
    { -1248, -216, 320},
    { -1192, -160, 264},
    { -1232, 128, -96},
    { -1192, 120, -216},
    // 42 seconds
    { -1240, -56, -104},
    { -1336, 8, -80},
    { -1224, 192, 96},
    { -1072, 384, -32},
    { -912, 328, 96},
    { -912, 336, 248},
    { -992, 240, 272},
    { -1040, 352, 200},
    { -912, 624, 48},
    { -1216, 520, 192},
    { -1104, 752, 272},
    { -1392, 864, 208},
    { -1272, 744, 72},
    { -904, 624, -96},
    { -1096, 616, -40},
    { -1296, 488, 104},
    { -1248, 392, 192},
    { -1064, 272, 216},
    { -1040, 200, 264},
    { -1096, 192, 264},
    { -1104, 152, 240},
    { -1096, 176, 248},
    { -1208, 88, 296},
    { -1224, -64, 192},
    { -1152, -40, 160},
    // 43 seconds
    { -1288, 176, -32},
    { -1056, 400, -248},
    { -1088, 336, -136},
    { -1216, 88, -8},
    { -1040, -184, -48},
    { -928, -192, -96},
    { -904, -32, -24},
    { -968, 64, 72},
    { -1056, 344, -56},
    { -1120, 456, -216},
    { -1344, 344, -200},
    { -1440, 736, -320},
    { -1304, 32, -240},
    { -1816, 256, -168},
    { -1152, 360, -200},
    { -1192, 360, -104},
    { -1480, 272, 136},
    { -1424, 216, 32},
    { -1048, 224, 80},
    { -944, 136, 168},
    { -1024, 24, 256},
    { -984, -32, 264},
    { -944, -16, 160},
    { -1104, 32, 240},
    { -1120, -104, 176},
    // 44 seconds
    { -808, -136, 24},
    { -1240, -16, -160},
    { -1296, 112, -224},
    { -1224, 208, -360},
    { -1376, 160, -352},
    { -1336, 0, -160},
    { -1184, 128, -160},
    { -920, 240, -24},
    { -896, 368, -96},
    { -1000, 264, -24},
    { -1040, 232, -32},
    { -936, 216, -80},
    { -1200, 264, -120},
    { -1128, 552, -32},
    { -1504, 576, -56},
    { -1384, 312, -128},
    { -1104, 352, -88},
    { -1344, 352, 56},
    { -1472, 280, 160},
    { -1144, 256, 96},
    { -896, 192, 96},
    { -944, 56, 112},
    { -936, 48, 160},
    { -968, 56, 160},
    { -1064, 160, 144},
    // 45 seconds
    { -1160, 48, 256},
    { -1032, -80, 192},
    { -1280, -32, 200},
    { -1520, 256, 72},
    { -1256, 384, -160},
    { -1264, 64, -104},
    { -1224, 0, -32},
    { -1048, 112, -64},
    { -832, 168, 8},
    { -744, 184, 120},
    { -848, 224, 112},
    { -944, 344, 40},
    { -968, 328, 0},
    { -1264, 456, -24},
    { -1352, 680, 184},
    { -1200, 360, 16},
    { -1640, 488, -24},
    { -1032, 376, -72},
    { -1168, 424, -80},
    { -1504, 368, 48},
    { -1520, 272, 80},
    { -1216, 216, 104},
    { -1040, 128, 152},
    { -912, 56, 192},
    { -864, 48, 160},
    // 46 seconds
    { -896, 56, 192},
    { -1016, 40, 272},
    { -1112, 48, 296},
    { -928, 104, 128},
    { -1168, 120, 96},
    { -1360, 232, -152},
    { -1176, 312, -312},
    { -1152, -72, -88},
    { -1336, -336, 0},
    { -1328, -96, 24},
    { -1088, 168, 72},
    { -920, 288, 168},
    { -976, 328, 152},
    { -1048, 320, 80},
    { -992, 288, 24},
    { -1192, 264, 64},
    { -1416, 392, 80},
    { -1320, 784, -64},
    { -1504, 440, -104},
    { -1088, 232, -256},
    { -1088, 384, -208},
    { -1352, 328, -16},
    { -1624, 192, 136},
    { -1296, 120, 128},
    { -1184, 136, 120},
    // 47 seconds
    { -1216, 152, 144},
    { -1224, 88, 176},
    { -1192, 184, 176},
    { -1168, 136, 192},
    { -1112, 56, 184},
    { -832, -80, 88},
    { -1016, -320, 104},
    { -1152, 272, -200},
    { -1040, 248, -304},
    { -1400, 0, -32},
    { -1424, -32, 232},
    { -1336, 64, 144},
    { -1240, 288, 72},
    { -1176, 360, 168},
    { -1344, 120, 64},
    { -1216, 88, 8},
    { -1144, 368, -32},
    { -1344, 640, -40},
    { -1168, 584, -32},
    { -1376, 344, -168},
    { -1136, 568, -232},
    { -1024, 584, -216},
    { -1280, 392, -40},
    { -1512, 400, 56},
    { -1424, 352, 88},
    // 48 seconds
    { -1272, 248, 152},
    { -1304, 168, 200},
    { -1296, 136, 248},
    { -1240, 120, 248},
    { -1184, 120, 176},
    { -1200, 56, 184},
    { -1024, -144, 184},
    { -1192, -88, 192},
    { -1288, 56, 48},
    { -1040, 280, -224},
    { -1016, 184, -144},
    { -1168, -32, 120},
    { -1256, -136, 168},
    { -1208, 72, 88},
    { -1200, 280, 32},
    { -1232, 392, 24},
    { -1216, 368, 112},
    { -1088, 408, 0},
    { -1016, 448, -152},
    { -1240, 272, -160},
    { -1184, 360, -104},
    { -1792, 592, -96},
    { -1248, 344, -72},
    { -1288, 248, 0},
    { -1536, 304, 96},
    // 49 seconds
    { -1528, 256, 88},
    { -1296, 200, 56},
    { -1184, 104, 168},
    { -1120, -40, 232},
    { -1080, 64, 144},
    { -1024, 80, 112},
    { -1032, 72, 200},
    { -1136, -8, 328},
    { -1072, -272, 448},
    { -1368, 160, 16},
    { -1160, 344, -352},
    { -1144, 224, -264},
    { -1304, -48, -8},
    { -1320, -184, 176},
    { -1208, 0, 32},
    { -1064, 200, -40},
    { -1064, 296, 16},
    { -1176, 376, -16},
    { -1168, 368, -128},
    { -1072, 432, -144},
    { -1256, 456, -120},
    { -1152, 240, -64},
    { -1712, 600, -128},
    { -1192, 432, -112},
    { -1200, 400, -112},
    // 50 seconds
    { -1480, 368, 56},
    { -1680, 328, 80},
    { -1432, 248, 112},
    { -1248, 136, 176},
    { -1168, 104, 192},
    { -1088, 96, 168},
    { -992, 64, 176},
    { -904, 8, 176},
    { -944, -32, 200},
    { -880, -136, 184},
    { -1048, 8, 80},
    { -1336, 352, 112},
    { -1184, 816, 344},
    { -1048, 648, 208},
    { -1192, 568, 152},
    { -1176, 368, 408},
    { -960, 192, 368},
    { -848, 200, 280},
    { -888, 64, 368},
    { -1080, 368, 200},
    { -1072, 168, 384},
    { -976, 928, 440},
    { -952, 920, 752},
    { -984, 1096, 632},
    { -1272, 904, 744},
    // 51 seconds
    { -904, 704, 568},
    { -1088, 672, 528},
    { -1416, 464, 624},
    { -1448, 384, 680},
    { -1160, 200, 648},
    { -1040, 296, 576},
    { -936, 120, 592},
    { -880, 312, 536},
    { -784, 240, 568},
    { -712, 256, 592},
    { -640, 280, 512},
    { -424, 384, 576},
    { -504, 384, 736},
    { -256, 760, 984},
    { -88, 928, 760},
    { -192, 880, 880},
    { -128, 800, 720},
    { 8, 680, 560},
    { 160, 408, 432},
    { 200, 504, 288},
    { 216, 400, 312},
    { 384, 456, 456},
    { 288, 592, 376},
    { 216, 800, 576},
    { 232, 1048, 520},
    // 52 seconds
    { 320, 1072, 632},
    { 328, 1376, 560},
    { 336, 960, 416},
    { 344, 752, 272},
    { 272, 728, 312},
    { 192, 560, 32},
    { 96, 336, 8},
    { 8, 152, 16},
    { -112, 32, 0},
    { -232, 88, -16},
    { -536, 248, -32},
    { -1008, 120, 56},
    { -1776, 256, 272},
    { -2632, 272, 624},
    { -2664, 544, 288},
    { -1888, 616, -376},
    { -1112, -208, 40},
    { -1176, -424, 168},
    { -1120, 24, 200},
    { -1016, 368, -8},
    { -640, 368, 56},
    { -576, 344, -16},
    { -616, 192, 96},
    { -688, 136, 584},
    { -864, 32, -64},
    // 53 seconds
    { -1296, 808, -120},
    { -1232, 704, 80},
    { -1624, 832, 72},
    { -1208, 488, -40},
    { -1304, 512, -128},
    { -1472, 664, 56},
    { -1704, 360, -96},
    { -1224, 336, 40},
    { -1048, 248, 80},
    { -984, 160, 72},
    { -824, 152, 176},
    { -800, 104, 208},
    { -840, 40, 248},
    { -928, 56, 288},
    { -896, 104, 184},
    { -1136, 176, 216},
    { -1336, 288, -24},
    { -1152, 440, -320},
    { -1192, 328, -96},
    { -1360, -64, 88},
    { -1552, 112, -152},
    { -1080, 64, -32},
    { -880, 184, -48},
    { -928, 264, 0},
    { -1056, 280, -24},
    // 54 seconds
    { -952, 272, -32},
    { -1128, 368, 24},
    { -1296, 520, 8},
    { -1128, 592, -64},
    { -1624, 576, -56},
    { -1200, 352, -8},
    { -1184, 304, 104},
    { -1272, 328, 232},
    { -1432, 488, 216},
    { -1304, 384, 240},
    { -1200, 320, 240},
    { -1184, 184, 256},
    { -1112, 40, 232},
    { -1016, -48, 224},
    { -872, -64, 208},
    { -928, -56, 264},
    { -848, -32, 200},
    { -1096, 112, 184},
    { -1216, 384, -136},
    { -1152, 608, -472},
    { -1408, 336, 112},
    { -1360, -400, 312},
    { -1288, -224, 112},
    { -968, 272, -64},
    { -792, 448, -64},
    // 55 seconds
    { -800, 496, 88},
    { -928, 520, 120},
    { -904, 1056, 80},
    { -824, 1464, 96},
    { -880, 1256, 408},
    { -1120, 1368, 648},
    { -1000, 1624, 824},
    { -992, 1504, 808},
    { -1024, 1376, 1000},
    { -944, 1368, 1216},
    { -744, 1136, 1080},
    { -536, 1160, 864},
    { -512, 712, 784},
    { -376, 320, 560},
    { -328, 144, 368},
    { -144, -48, 24},
    { -184, 128, -88},
    { -96, 264, -280},
    { -280, 560, -712},
    { -312, 1040, -1432},
    { 80, 952, -864},
    { 304, 872, -376},
    { 352, 752, -184},
    { -8, 672, -688},
    { 32, 600, -616},
    // 56 seconds
    { 16, 832, -464},
    { 0, 616, -440},
    { -176, 496, -544},
    { -40, 240, -600},
    { -48, 72, -752},
    { -24, 168, -824},
    { -40, 96, -880},
    { 72, 336, -736},
    { -200, 896, -560},
    { -424, 1824, -504},
    { -128, 1856, -312},
    { -88, 1176, -392},
    { -208, 616, -376},
    { -280, 488, -256},
    { -280, 400, -128},
    { -240, 392, -280},
    { -136, 432, 32},
    { -304, -16, 64},
    { -744, 976, -504},
    { -1176, 1000, -824},
    { -936, 920, -384},
    { -1080, 936, -224},
    { -1072, 1192, -224},
    { -880, 1008, 48},
    { -952, 800, 104},
    // 57 seconds
    { -960, 1136, -128},
    { -360, 424, -184},
    { -64, 288, -216},
    { 160, 264, -1112},
    { 144, -672, -216},
    { -88, -608, -384},
    { -680, 120, -744},
    { -1112, 216, -936},
    { -832, 416, -576},
    { -808, 712, -544},
    { -592, 416, -528},
    { -1216, 760, -1136},
    { -976, 760, -968},
    { -528, 1056, -680},
    { -456, 736, -712},
    { -456, 480, -624},
    { -448, 360, -376},
    { -480, 32, -296},
    { -504, -104, -448},
    { -328, -680, -576},
    { -728, -408, -944},
    { -584, -32, -952},
    { -736, -112, -904},
    { -1256, 144, -1040},
    { -816, -104, -888},
    // 58 seconds
    { -368, 296, -432},
    { -504, 888, -288},
    { -872, 984, -648},
    { -672, 344, -592},
    { -600, -16, -712},
    { -560, -184, -664},
    { -768, -224, -664},
    { -808, -248, -616},
    { -536, -160, -464},
    { -184, -64, -288},
    { 128, 336, -216},
    { 176, 568, -488},
    { 688, 592, -232},
    { 680, 960, -488},
    { 528, 944, -392},
    { 520, 272, -64},
    { -248, 136, 632},
    { 344, 1248, 384},
    { -424, 752, 728},
    { -128, 1216, 184},
    { -544, 768, 96},
    { -848, 752, 72},
    { -1176, 680, 168},
    { -1968, 424, 288},
    { -2032, 600, 240},
    // 59 seconds
    { -1904, 672, -136},
    { -2128, 8, 48},
    { -1504, -24, -144},
    { -968, 80, -192},
    { -832, 144, -120},
    { -880, 136, -8},
    { -864, 152, 40},
    { -672, 144, 56},
    { -584, 176, 56},
    { -632, 224, 48},
    { -696, 328, -40},
    { -856, 400, -80},
    { -1152, 296, -144},
    { -1496, 328, -112},
    { -2088, 560, 224},
    { -1056, 576, -416},
    { -1096, 616, -424},
    { -1376, 648, 120},
    { -1424, 384, 248},
    { -1160, 176, 152},
    { -912, 40, 128},
    { -808, 24, 136},
    { -824, 40, 128},
    { -856, 64, 136},
    { -1088, -128, 264},
    // 60 seconds
    // elapsed: 1 minutes
    { -1232, -432, 424},
    { -1112, -72, 288},
    { -1496, 312, 72},
    { -1264, 608, -360},
    { -1184, 416, -112},
    { -1312, -16, 56},
    { -1304, -368, -32},
    { -1200, -24, 32},
    { -1016, 440, 72},
    { -984, 400, 96},
    { -1048, 360, 40},
    { -1032, 400, 8},
    { -992, 416, -48},
    { -1168, 352, 72},
    { -1104, 320, 216},
    { -1504, 696, 24},
    { -1032, 584, -56},
    { -1192, 640, 8},
    { -1392, 616, 88},
    { -1408, 424, 72},
    { -1184, 224, 136},
    { -1120, 176, 216},
    { -1184, 152, 288},
    { -1208, 104, 248},
    { -1176, 144, 224},
    // 61 seconds
    { -1224, 184, 232},
    { -1272, 8, 256},
    { -1000, -192, 232},
    { -1264, 72, 48},
    { -1072, 216, -240},
    { -1008, 328, -296},
    { -1152, 72, -24},
    { -1288, -144, 56},
    { -1120, -240, 88},
    { -1072, 16, 88},
    { -1176, 288, 8},
    { -1320, 528, -72},
    { -1328, 568, -192},
    { -1192, 1264, -256},
    { -1128, 304, -232},
    { -1264, 496, -136},
    { -1536, 608, -48},
    { -1112, 536, -80},
    { -1208, 440, -8},
    { -1416, 392, 128},
    { -1496, 360, 184},
    { -1280, 248, 152},
    { -1152, 200, 160},
    { -1168, 152, 168},
    { -1224, 136, 168},
    // 62 seconds
    { -1168, 40, 96},
    { -1192, 120, 112},
    { -1192, -96, 176},
    { -1000, -224, 88},
    { -1280, -40, 64},
    { -1136, 248, -120},
    { -1032, 224, -144},
    { -1200, 176, -80},
    { -1352, -64, 160},
    { -1408, -16, 280},
    { -1440, 224, 264},
    { -1368, 432, 208},
    { -1280, 560, 64},
    { -1248, 584, -56},
    { -1112, 256, -64},
    { -1168, 408, -104},
    { -1096, 512, -56},
    { -1408, 504, -80},
    { -1160, 600, -120},
    { -1192, 480, -96},
    { -1560, 448, 32},
    { -1936, 352, 136},
    { -1688, 176, 128},
    { -1568, 104, 216},
    { -1432, 32, 248},
    // 63 seconds
    { -1272, 40, 160},
    { -1120, 72, 152},
    { -1112, 152, 120},
    { -1200, 32, 208},
    { -1008, -184, 168},
    { -1040, -200, 224},
    { -1136, 216, -112},
    { -1024, 48, -168},
    { -1240, 104, 8},
    { -1336, 72, -16},
    { -1312, 280, 176},
    { -1304, 368, 128},
    { -1384, 440, 152},
    { -1488, 408, 400},
    { -1488, 536, 464},
    { -1152, 648, 128},
    { -1224, 928, -8},
    { -1128, 816, 160},
    { -1208, 992, 120},
    { -840, 904, 64},
    { -912, 808, -56},
    { -1176, 616, 72},
    { -1504, 560, 232},
    { -1648, 584, 216},
    { -1632, 432, 272},
    // 64 seconds
    { -1688, 376, 344},
    { -1664, 312, 272},
    { -1592, 208, 192},
    { -1352, 184, 56},
    { -1232, 144, -112},
    { -928, -32, -336},
    { -856, -136, -408},
    { -632, -96, -800},
    { -616, -176, -760},
    { -624, -288, -736},
    { -552, -376, -704},
    { -400, -392, -648},
    { -232, -392, -688},
    { -184, -384, -664},
    { -152, -368, -672},
    { -112, -344, -736},
    { -104, -352, -824},
    { -168, -352, -928},
    { -216, -376, -976},
    { -160, -392, -1160},
    { -184, -296, -1312},
    { -232, -248, -1216},
    { -128, -184, -1192},
    { -208, -120, -1120},
    { -288, -80, -952},
    // 65 seconds
    { -224, -128, -856},
    { -232, -224, -728},
    { -216, -288, -616},
    { -168, -360, -520},
    { -112, -416, -400},
    { -152, -384, -344},
    { -256, -408, -256},
    { -656, -216, -48},
    { -1680, 296, 176},
    { -2120, 776, 816},
    { -1880, 1264, 520},
    { -1704, 1304, 168},
    { -1304, 696, 224},
    { -1064, 272, 88},
    { -872, 88, 128},
    { -872, 160, 144},
    { -904, 288, 184},
    { -944, 424, 48},
    { -808, 352, -96},
    { -1128, 416, -96},
    { -1400, 472, 168},
    { -1592, 880, 472},
    { -1408, 664, 88},
    { -872, 1000, -56},
    { -992, 752, 264},
    // 66 seconds
    { -1496, 600, 576},
    { -1592, 576, 592},
    { -1232, 448, 560},
    { -1000, 264, 528},
    { -840, 152, 472},
    { -704, 224, 416},
    { -680, 272, 392},
    { -632, 464, 328},
    { -640, 280, 464},
    { -424, 704, 344},
    { -448, 880, 504},
    { -248, 1016, 432},
    { -224, 1232, 336},
    { -240, 992, 320},
    { -160, 832, 312},
    { -32, 800, 288},
    { 64, 792, 248},
    { 168, 1056, 328},
    { 264, 904, 360},
    { 432, 1096, -64},
    { 408, 1256, -120},
    { 448, 1312, -432},
    { 552, 1048, -368},
    { 632, 1064, -560},
    { 480, 664, -480},
    // 67 seconds
    { 464, 312, -400},
    { 544, 224, -432},
    { 568, 128, -504},
    { 480, 24, -400},
    { 360, -72, -472},
    { 384, -176, -392},
    { 328, -256, -352},
    { 328, -288, -280},
    { 360, -504, -432},
    { 568, -416, -800},
    { 640, -400, -872},
    { 1024, -456, -1016},
    { 848, -328, -944},
    { 640, -456, -536},
    { 472, -304, -432},
    { 488, -312, -472},
    { 512, -344, -456},
    { 384, -416, -400},
    { 320, -400, -400},
    { 384, -496, -352},
    { 512, -472, -240},
    { 664, -256, -464},
    { 840, -104, -568},
    { 1120, -16, -264},
    { 1136, 280, -232},
    // 68 seconds
    { 856, 696, -88},
    { 704, 400, 168},
    { 392, 1016, 664},
    { 432, 808, 680},
    { 400, 832, 560},
    { 432, 696, 408},
    { 360, 656, 312},
    { 384, 632, 288},
    { 416, 600, 248},
    { 472, 560, 376},
    { 488, 648, 480},
    { 480, 904, 432},
    { 344, 1168, 712},
    { 208, 1312, 640},
    { 72, 1288, 512},
    { 8, 976, 384},
    { -16, 752, 208},
    { 80, 536, 104},
    { 168, 368, 104},
    { 240, 288, 88},
    { 304, 168, 184},
    { 232, 400, 160},
    { 152, 392, 448},
    { 40, 1280, 688},
    { -32, 1368, 1176},
    // 69 seconds
    { -16, 1584, 952},
    { -48, 1248, 728},
    { 32, 904, 560},
    { -56, 824, 616},
    { -120, 792, 656},
    { -88, 696, 472},
    { -48, 512, 368},
    { 8, 528, 352},
    { 48, 584, 384},
    { 56, 680, 408},
    { 0, 808, 424},
    { -56, 824, 504},
    { -96, 928, 464},
    { -96, 1056, 552},
    { -32, 1152, 520},
    { -40, 1128, 544},
    { -112, 896, 528},
    { -168, 848, 456},
    { -152, 656, 384},
    { -88, 640, 248},
    { -16, 608, 184},
    { 56, 568, 152},
    { 88, 632, 136},
    { 120, 696, 200},
    { 80, 872, 264},
    // 70 seconds
    { 80, 976, 480},
    { 64, 1032, 520},
    { 104, 1144, 632},
    { 40, 1064, 664},
    { 168, 808, 608},
    { 136, 696, 680},
    { 112, 744, 688},
    { 8, 760, 536},
    { 80, 552, 360},
    { 184, 496, 232},
    { 216, 480, 304},
    { 152, 648, 344},
    { 128, 744, 416},
    { 88, 864, 520},
    { 128, 952, 488},
    { 216, 1072, 576},
    { 120, 1160, 720},
    { 24, 1352, 624},
    { -64, 1008, 568},
    { -24, 816, 344},
    { 8, 624, 240},
    { 120, 456, 160},
    { 224, 424, 96},
    { 248, 408, 112},
    { 312, 456, 192},
    // 71 seconds
    { 344, 616, 280},
    { 312, 832, 400},
    { 224, 936, 520},
    { 248, 1272, 608},
    { 120, 1216, 624},
    { 168, 1016, 560},
    { 168, 840, 584},
    { 144, 800, 472},
    { 208, 632, 312},
    { 232, 488, 224},
    { 232, 504, 216},
    { 232, 512, 272},
    { 216, 600, 344},
    { 184, 736, 464},
    { 80, 920, 568},
    { 40, 1032, 648},
    { 144, 1208, 664},
    { 136, 1400, 496},
    { 24, 1272, 424},
    { 16, 864, 432},
    { 0, 688, 296},
    { 32, 576, 184},
    { 72, 392, 144},
    { 80, 368, 72},
    { 120, 320, 136},
    // 72 seconds
    { 184, 448, 168},
    { 200, 808, 384},
    { 112, 1240, 624},
    { 128, 1280, 632},
    { 144, 1488, 816},
    { 144, 1112, 560},
    { 168, 928, 480},
    { 152, 840, 480},
    { 104, 736, 440},
    { 72, 680, 344},
    { 112, 576, 248},
    { 136, 544, 240},
    { 200, 560, 224},
    { 280, 776, 216},
    { 360, 904, 232},
    { 360, 1072, 368},
    { 192, 1152, 296},
    { 136, 1064, 168},
    { 200, 1008, 520},
    { 8, 1304, 152},
    { -184, 1072, 344},
    { -176, 896, 200},
    { -104, 632, 120},
    { 120, 448, 96},
    { 256, 416, 64},
    // 73 seconds
    { 360, 440, 64},
    { 352, 488, 80},
    { 384, 552, 128},
    { 472, 632, 120},
    { 472, 800, 160},
    { 440, 840, 344},
    { 536, 1200, 544},
    { 328, 1296, 664},
    { 304, 1064, 536},
    { 328, 968, 448},
    { 224, 880, 400},
    { 144, 720, 288},
    { 112, 576, 152},
    { 128, 480, 128},
    { 136, 392, 160},
    { 96, 416, 200},
    { 72, 432, 232},
    { -8, 616, 344},
    { -136, 904, 496},
    { -120, 1208, 552},
    { -184, 1696, 792},
    { -160, 1800, 584},
    { -144, 1624, 456},
    { -56, 1008, 368},
    { -56, 696, 248},
    // 74 seconds
    { -72, 384, 184},
    { -16, 160, 112},
    { 8, 152, 160},
    { 8, 200, 272},
    { 32, 320, 296},
    { 144, 360, 232},
    { -176, 608, 480},
    { -48, 1416, 1192},
    { -16, 2088, 1432},
    { 320, 1408, 840},
    { 296, 864, 656},
    { 168, 704, 600},
    { 136, 664, 360},
    { 72, 344, 312},
    { 24, 408, 216},
    { 16, 328, 120},
    { -48, 280, 56},
    { -160, 200, 8},
    { -400, 232, 80},
    { -912, 232, 168},
    { -1504, 144, 264},
    { -2480, 384, 264},
    { -2640, 896, -784},
    { -1712, 432, 24},
    { -1336, -24, -264},
    // 75 seconds
    { -1248, 240, 8},
    { -1000, 296, 32},
    { -736, 312, 64},
    { -624, 328, -64},
    { -632, 352, -136},
    { -560, 304, -96},
    { -840, 400, -56},
    { -1336, 320, 80},
    { -1296, 1096, 128},
    { -1640, 296, -136},
    { -1240, 536, -232},
    { -1256, 656, -296},
    { -1376, 400, -144},
    { -1480, 336, -96},
    { -1288, 304, 16},
    { -1200, 272, 88},
    { -1056, -16, 144},
    { -976, 16, 96},
    { -952, 64, 64},
    { -976, 104, 96},
    { -1080, 64, 168},
    { -992, 16, 112},
    { -1168, 80, 8},
    { -1112, 320, -368},
    { -1208, 168, -536},
    // 76 seconds
    { -1488, -216, 152},
    { -1696, 304, 168},
    { -1192, 456, 256},
    { -832, 544, 152},
    { -864, 496, 128},
    { -992, 248, 208},
    { -1072, 264, 208},
    { -944, 248, 248},
    { -1168, 368, 280},
    { -1144, 848, 320},
    { -1616, 760, 112},
    { -1016, 312, -280},
    { -1096, 1128, -336},
    { -1296, 344, -216},
    { -1528, 280, -104},
    { -1328, 208, -64},
    { -1152, 120, -16},
    { -1184, 136, 48},
    { -1224, 144, 120},
    { -1200, 136, 128},
    { -1144, 104, 144},
    { -1176, 32, 288},
    { -1064, -80, 104},
    { -1128, -72, 40},
    { -1072, -16, -176},
    // 77 seconds
    { -1128, -128, -144},
    { -1448, 112, -272},
    { -1408, 24, -248},
    { -1184, 0, -160},
    { -1040, 112, -128},
    { -936, 192, -56},
    { -1136, 296, -48},
    { -1288, 408, -160},
    { -1208, 440, -168},
    { -1304, 520, -120},
    { -1208, 336, -176},
    { -1552, 320, -216},
    { -1416, 528, -112},
    { -1016, 400, -176},
    { -1200, 312, -104},
    { -1392, 232, 80},
    { -1304, 200, 48},
    { -1120, 160, 32},
    { -1064, 136, 72},
    { -1096, 136, 96},
    { -1112, 136, 112},
    { -1128, 136, 112},
    { -1232, 88, 208},
    { -1168, -152, 216},
    { -1200, -104, 192},
    // 78 seconds
    { -1240, 64, -128},
    { -1152, 144, -208},
    { -1272, 120, -192},
    { -1256, -64, -160},
    { -1104, -168, -144},
    { -960, -16, -152},
    { -848, 136, -24},
    { -912, 232, 8},
    { -1136, 312, -80},
    { -1224, 384, -112},
    { -1232, 392, -80},
    { -1248, 1200, -128},
    { -1088, -40, -104},
    { -1736, 320, -96},
    { -1064, 384, -104},
    { -1264, 408, -64},
    { -1568, 368, 0},
    { -1400, 288, -32},
    { -1184, 144, -144},
    { -1096, 88, -72},
    { -1176, 144, 16},
    { -1168, 96, 40},
    { -1160, 152, 32},
    { -1232, 136, 24},
    { -1184, 96, 88},
    // 79 seconds
    { -960, 56, -112},
    { -1136, 56, -88},
    { -992, 88, -216},
    { -936, 256, -376},
    { -1096, 440, -192},
    { -1064, 392, -224},
    { -872, 360, -56},
    { -800, 280, 104},
    { -912, 384, 168},
    { -1112, 384, 320},
    { -1480, 984, -96},
    { -1352, 688, -24},
    { -1200, 888, 56},
    { -920, 832, -96},
    { -1400, 928, -232},
    { -1040, 608, -176},
    { -888, 632, -184},
    { -1240, 592, -32},
    { -1432, 536, 0},
    { -1248, 448, 32},
    { -1176, 336, 72},
    { -1184, 272, 168},
    { -1192, 224, 184},
    { -1152, 224, 176},
    { -1080, 184, 160},
    // 80 seconds
    { -1104, 128, 216},
    { -1032, 96, 224},
    { -1160, 152, 160},
    { -1200, 264, -160},
    { -992, 456, -592},
    { -1160, 400, -376},
    { -1192, -488, 112},
    { -1200, -424, -32},
    { -1080, 264, -240},
    { -856, 256, -80},
    { -968, 176, -16},
    { -1176, 256, 8},
    { -1248, 192, 32},
    { -1328, 296, 168},
    { -1416, 1552, -88},
    { -1200, 216, -112},
    { -1616, 560, 24},
    { -1168, 592, -88},
    { -1024, 432, -56},
    { -1184, 376, 56},
    { -1360, 312, 104},
    { -1152, 200, 80},
    { -1064, 160, 112},
    { -1136, 144, 160},
    { -1224, 40, 176},
    // 81 seconds
    { -1152, 16, 128},
    { -1168, 72, 136},
    { -1208, -120, 184},
    { -912, -184, 72},
    { -1432, 128, -56},
    { -1472, 176, -48},
    { -1080, -32, -248},
    { -1240, -48, -88},
    { -1176, -8, 128},
    { -1064, 128, 48},
    { -936, 216, 112},
    { -936, 208, 216},
    { -984, 304, 112},
    { -1104, 432, -56},
    { -1032, 552, -176},
    { -1096, 1152, -112},
    { -1064, -24, -56},
    { -1712, 336, -208},
    { -1472, 560, -152},
    { -1168, 400, -152},
    { -1408, 296, 32},
    { -1544, 224, 160},
    { -1336, 168, 104},
    { -1120, 184, 88},
    { -1064, 160, 120},
    // 82 seconds
    { -1168, 152, 176},
    { -1136, 96, 144},
    { -1184, 136, 24},
    { -1264, -112, 192},
    { -880, -464, 56},
    { -1160, -232, 16},
    { -1240, 72, -24},
    { -1144, 200, -80},
    { -1336, 120, -8},
    { -1440, 64, 64},
    { -1264, -16, 80},
    { -1152, 40, 120},
    { -1136, 200, 176},
    { -1224, 336, 128},
    { -1200, 416, -8},
    { -1064, 376, -72},
    { -1184, 408, -96},
    { -1176, 552, -96},
    { -1560, 464, -48},
    { -1456, 304, -56},
    { -1040, 200, -224},
    { -1168, 456, -168},
    { -1424, 688, 64},
    { -1584, 560, 128},
    { -1448, 216, 184},
    // 83 seconds
    { -1296, -88, 264},
    { -1232, -136, 56},
    { -1120, -152, 136},
    { -1032, 184, 200},
    { -1104, 200, 128},
    { -1040, 160, 24},
    { -960, 112, 24},
    { -1032, 56, -24},
    { -872, 280, -288},
    { -776, 168, -128},
    { -1280, 136, -80},
    { -1448, 112, -120},
    { -1184, 72, -40},
    { -1024, 64, 40},
    { -1096, 176, -16},
    { -1192, 224, 40},
    { -1136, 288, -104},
    { -1184, 384, -184},
    { -1416, 656, -200},
    { -1504, 944, -208},
    { -1736, 272, -160},
    { -1048, 152, -256},
    { -1112, 448, -176},
    { -1352, 520, 0},
    { -1504, 288, 88},
    // 84 seconds
    { -1288, 168, 72},
    { -1064, 80, 88},
    { -1048, 320, 160},
    { -1032, 152, 200},
    { -1000, 184, 184},
    { -976, 464, 120},
    { -1064, 528, 232},
    { -776, 656, 336},
    { -784, 952, 368},
    { -480, 1160, 576},
    { -360, 1128, 328},
    { -432, 840, 528},
    { -312, 640, 408},
    { -88, 552, 280},
    { 160, 392, 288},
    { 336, 528, 168},
    { 200, 392, 560},
    { 256, 272, 136},
    { 184, 376, 128},
    { 152, 352, 192},
    { -24, 336, 56},
    { -224, 560, 496},
    { -328, 1648, 1080},
    { -320, 1616, 1192},
    { -184, 1016, 712},
    // 85 seconds
    { 144, 944, 464},
    { 168, 800, 512},
    { 48, 712, 360},
    { 0, 632, 256},
    { -72, 480, 120},
    { -152, 304, 72},
    { -224, 344, -80},
    { -376, 280, 144},
    { -872, 104, 168},
    { -1392, 152, 176},
    { -2144, 264, 376},
    { -2480, 704, -72},
    { -1376, 1648, -104},
    { -848, -224, -496},
    { -1272, 384, -112},
    { -1072, 224, -40},
    { -696, 176, -32},
    { -584, 176, -56},
    { -656, 352, 16},
    { -712, 280, -8},
    { -696, 368, -64},
    { -888, 488, -32},
    { -1104, 624, 152},
    { -1488, 712, 80},
    { -1776, 640, 168},
    // 86 seconds
    { -1128, 416, -64},
    { -1336, 592, -304},
    { -1584, 592, -112},
    { -1384, 496, 32},
    { -1200, 1040, -128},
    { -1112, 920, 80},
    { -792, 912, -40},
    { -576, 1136, -32},
    { -344, 944, -152},
    { -312, 1024, -152},
    { -32, 496, 96},
    { -136, -32, -248},
    { 136, -248, -616},
    { 88, -328, -1136},
    { -56, -432, -1064},
    { 40, -592, -720},
    { 288, -344, -664},
    { 344, -304, -480},
    { 368, -368, -424},
    { 392, -376, -416},
    { 248, -488, -448},
    { 208, -512, -480},
    { 424, -592, -352},
    { 392, -608, -472},
    { 472, -512, -744},
    // 87 seconds
    { 768, -680, -704},
    { 904, -560, -904},
    { 1008, -360, -592},
    { 1056, -288, -368},
    { 1056, 40, -440},
    { 1056, -24, -496},
    { 856, -104, -488},
    { 720, -312, -240},
    { 552, -344, -168},
    { 528, -384, 80},
    { 584, -544, 8},
    { 896, -696, -144},
    { 952, -696, -272},
    { 1032, -824, -272},
    { 1176, -848, -344},
    { 952, -608, -608},
    { 696, -464, -616},
    { 496, -456, -304},
    { 552, -472, -200},
    { 568, -568, -152},
    { 624, -544, -104},
    { 528, -536, -192},
    { 576, -520, -336},
    { 592, -576, -344},
    { 664, -672, -256},
    // 88 seconds
    { 856, -648, -336},
    { 768, -560, -400},
    { 1168, -648, -424},
    { 984, -552, -240},
    { 968, -552, -88},
    { 880, -424, -64},
    { 872, -232, -64},
    { 688, -248, -40},
    { 560, -216, -144},
    { 304, -144, -152},
    { 88, -88, -96},
    { -160, 32, -64},
    { -488, 256, -80},
    { -1040, 608, -176},
    { -1384, 464, -104},
    { -1992, 216, 80},
    { -2968, 272, 56},
    { -2672, 520, -456},
    { -1888, 304, -328},
    { -1616, -344, -96},
    { -1504, 128, 120},
    { -1208, 448, 96},
    { -880, 400, 80},
    { -712, 368, 24},
    { -720, 288, 32},
    // 89 seconds
    { -792, 320, -24},
    { -832, 280, 88},
    { -1080, 424, 56},
    { -1048, 896, 8},
    { -1576, 480, -8},
    { -1272, 408, -128},
    { -1368, 576, -88},
    { -1648, 608, 0},
    { -1696, 448, 32},
    { -1520, 240, 24},
    { -1360, 160, 88},
    { -1392, 160, 192},
    { -1192, 136, 104},
    { -1064, 184, 96},
    { -952, 88, 160},
    { -888, -48, 104},
    { -832, 24, 152},
    { -736, 112, 48},
    { -976, 128, -72},
    { -992, 184, -232},
    { -1176, 208, -384},
    { -1544, 232, -408},
    { -1648, 192, -240},
    { -1528, 240, -152},
    { -1304, 272, 16},
    // 90 seconds
    { -1232, 432, 104},
    { -1208, 360, 56},
    { -1176, 584, 56},
    { -984, 488, 48},
    { -952, 520, 88},
    { -968, 976, 384},
    { -1128, 736, -48},
    { -1200, 776, 80},
    { -1104, 728, -112},
    { -1296, 640, -160},
    { -1472, 568, -48},
    { -1544, 600, 8},
    { -1456, 432, 56},
    { -1424, 320, 136},
    { -1384, 232, 184},
    { -1272, 200, 160},
    { -1104, 192, 72},
    { -968, 120, 112},
    { -944, -16, 192},
    { -808, -104, 152},
    { -1008, 0, 104},
    { -1072, 184, -112},
    { -1128, 272, -400},
    { -1392, 304, -128},
    { -1408, -144, 160},
    // 91 seconds
    { -1464, -48, 16},
    { -1408, 384, -56},
    { -1208, 400, 160},
    { -1224, 392, 80},
    { -1240, 384, 16},
    { -1144, 424, -24},
    { -1328, 512, 48},
    { -1288, 712, 104},
    { -1112, 360, -112},
    { -1152, 656, -160},
    { -1016, 616, -104},
    { -1248, 600, 72},
    { -1584, 480, 200},
    { -1584, 280, 184},
    { -1280, 160, 112},
    { -1224, 168, 120},
    { -1360, 152, 216},
    { -1400, 72, 208},
    { -1264, 72, 128},
    { -1192, 88, 168},
    { -1144, -208, 144},
    { -752, -504, 96},
    { -1288, -8, -104},
    { -1224, 136, -192},
    { -1408, 192, -328},
    // 92 seconds
    { -1464, 104, -40},
    { -1352, -192, 200},
    { -1264, -56, 112},
    { -1184, 240, 192},
    { -1112, 384, 240},
    { -1168, 488, 56},
    { -1096, 512, -72},
    { -1048, 504, -24},
    { -1208, 1112, -168},
    { -1032, -8, -128},
    { -1664, 328, -296},
    { -1112, 368, -256},
    { -1128, 488, -160},
    { -1496, 496, 16},
    { -1504, 304, 16},
    { -1208, 160, -64},
    { -1104, 168, 16},
    { -1120, 160, 112},
    { -1176, 104, 152},
    { -1176, 40, 152},
    { -1160, 48, 136},
    { -1200, 40, 160},
    { -968, -232, 64},
    { -1064, -192, 8},
    { -1312, 72, -224},
    // 93 seconds
    { -1144, 88, -312},
    { -1272, 104, -272},
    { -1320, -216, -72},
    { -1344, -160, 16},
    { -1232, 120, 48},
    { -1128, 312, 144},
    { -1136, 376, 144},
    { -1160, 488, 32},
    { -1008, 472, -8},
    { -1000, 456, -48},
    { -1192, 464, -16},
    { -1312, 344, -48},
    { -1624, 376, -56},
    { -1016, 304, -176},
    { -1096, 360, -160},
    { -1360, 520, 56},
    { -1584, 392, 96},
    { -1328, 32, 0},
    { -1232, 64, -40},
    { -1304, 208, 48},
    { -1264, 128, 64},
    { -1128, 104, 24},
    { -1056, 88, 40},
    { -1064, 32, 160},
    { -824, -160, 176},
    // 94 seconds
    { -984, -32, 80},
    { -1120, 24, -120},
    { -1112, 0, -232},
    { -1280, 48, -256},
    { -1360, -104, -16},
    { -1400, -40, 56},
    { -1280, 168, 8},
    { -1120, 304, 112},
    { -1104, 344, 112},
    { -1224, 416, -32},
    { -1128, 384, -32},
    { -1040, 464, -80},
    { -1152, 552, -144},
    { -1056, 280, -96},
    { -1488, 432, -160},
    { -1192, 400, -160},
    { -1192, 384, -152},
    { -1440, 352, -32},
    { -1616, 320, 40},
    { -1416, 192, 8},
    { -1248, 128, 64},
    { -1216, 112, 136},
    { -1200, 72, 144},
    { -1104, 56, 104},
    { -1000, 80, 112},
    // 95 seconds
    { -912, 24, 144},
    { -896, 80, 224},
    { -744, -16, 128},
    { -992, 128, 136},
    { -1192, 144, -96},
    { -1160, 264, -232},
    { -1528, 144, -208},
    { -1696, 440, -136},
    { -1360, 184, 16},
    { -1144, 288, 128},
    { -1128, 448, 168},
    { -1168, 392, 152},
    { -1096, 392, 136},
    { -968, 712, -88},
    { -880, 352, 136},
    { -976, 768, 24},
    { -1248, 872, 8},
    { -1280, 816, 16},
    { -992, 648, -144},
    { -1152, 616, -96},
    { -1384, 472, 48},
    { -1480, 392, 72},
    { -1336, 344, 120},
    { -1240, 280, 176},
    { -1240, 232, 208},
    // 96 seconds
    { -1200, 192, 200},
    { -1096, 160, 192},
    { -984, 152, 176},
    { -1088, -24, 224},
    { -968, -728, 360},
    { -1192, -280, 232},
    { -1424, 8, 88},
    { -1552, 488, -400},
    { -1760, 144, -96},
    { -1696, 104, -80},
    { -1448, 176, -112},
    { -1264, 320, -40},
    { -1072, 344, 56},
    { -1064, 368, 8},
    { -1080, 384, -8},
    { -936, 408, -48},
    { -840, 536, -40},
    { -968, 712, -24},
    { -1216, 352, -40},
    { -1680, 464, 48},
    { -1184, 296, -24},
    { -1320, 320, -16},
    { -1584, 352, 80},
    { -1672, 304, 88},
    { -1496, 224, 120},
    // 97 seconds
    { -1408, 144, 200},
    { -1384, 72, 192},
    { -1328, 48, 144},
    { -1136, 40, 168},
    { -992, 48, 152},
    { -968, -280, 208},
    { -552, -456, 64},
    { -1016, 16, 8},
    { -1232, 80, -40},
    { -1232, 88, -216},
    { -1456, 128, -32},
    { -1608, -88, 176},
    { -1600, 16, 96},
    { -1344, 256, 56},
    { -1216, 424, 120},
    { -1240, 336, 160},
    { -1280, 208, 168},
    { -1064, 200, 112},
    { -1120, 368, 128},
    { -1128, 640, 216},
    { -1056, 712, 80},
    { -1312, 496, 160},
    { -1112, 424, 88},
    { -1080, 392, 64},
    { -1264, 448, 128},
    // 98 seconds
    { -1488, 440, 200},
    { -1376, 328, 168},
    { -1296, 312, 160},
    { -1408, 272, 296},
    { -1456, 136, 336},
    { -1360, 96, 320},
    { -1216, 96, 336},
    { -1144, 152, 264},
    { -824, 176, 264},
    { -904, 416, 120},
    { -824, 480, 104},
    { -584, 744, -96},
    { -688, 656, -40},
    { -768, 664, 16},
    { -712, 560, 32},
    { -600, 456, 40},
    { -544, 416, 0},
    { -552, 344, 72},
    { -600, 288, 56},
    { -696, 296, 56},
    { -848, 328, 48},
    { -1472, 440, 48},
    { -1856, 504, 152},
    { -1904, 592, -16},
    { -1448, -312, -192},
    // 99 seconds
    { -1248, 192, -120},
    { -1064, 488, -8},
    { -1008, 592, -40},
    { -1008, 416, -112},
    { -808, 248, -72},
    { -712, 104, -48},
    { -776, 120, -40},
    { -928, 160, 0},
    { -984, 88, 56},
    { -1200, 232, 56},
    { -1496, 240, 88},
    { -1432, 176, 96},
    { -1656, 152, 112},
    { -1368, 136, -8},
    { -984, 128, -184},
    { -1040, -80, -80},
    { -1024, -328, 64},
    { -816, -208, 40},
    { -656, -72, -32},
    { -648, 24, -16},
    { -792, 128, 48},
    { -984, 184, 96},
    { -1064, 280, 16},
    { -1176, 384, -40},
    { -1552, 568, -184},
    // 100 seconds
    { -1472, 912, 80},
    { -1608, 248, -296},
    { -1128, 520, -320},
    { -936, 520, -232},
    { -1208, 448, -72},
    { -1344, 304, 0},
    { -1160, 232, 8},
    { -944, 136, 56},
    { -928, 144, 80},
    { -1000, 128, 88},
    { -1008, 136, 104},
    { -1032, 128, 176},
    { -1112, 80, 224},
    { -1152, -56, 296},
    { -1304, -8, 256},
    { -1288, 136, 8},
    { -1112, 32, -192},
    { -1080, 552, -40},
    { -1104, 896, -16},
    { -936, 896, 88},
    { -712, 832, 216},
    { -576, 568, 344},
    { -408, 456, 376},
    { -328, 336, 440},
    { -280, 208, 448},
    // 101 seconds
    { -264, 360, 408},
    { -568, 120, 192},
    { -1248, 200, 744},
    { -2000, 704, 680},
    { -1504, 440, 1080},
    { -792, 840, 408},
    { -768, 688, 424},
    { -1160, 368, 608},
    { -1216, 384, 568},
    { -1032, 480, 408},
    { -960, 344, 416},
    { -896, 264, 456},
    { -864, 352, 384},
    { -776, 200, 376},
    { -704, 280, 344},
    { -696, 360, 368},
    { -536, 568, 376},
    { -568, 656, 616},
    { -288, 1104, 656},
    { -128, 1040, 424},
    { -240, 1008, 448},
    { -408, 616, 448},
    { -352, 416, 344},
    { -304, 336, 264},
    { -256, 256, 216},
    // 102 seconds
    { -280, 176, 184},
    { -392, 184, 248},
    { -568, 280, 784},
    { -864, 608, 960},
    { -1016, 832, 408},
    { -1200, 720, 368},
    { -1736, 480, 1240},
    { -1544, 904, 912},
    { -808, 592, 544},
    { -896, 896, 416},
    { -968, 816, 544},
    { -920, 712, 472},
    { -816, 528, 336},
    { -832, 344, 280},
    { -904, 304, 272},
    { -936, 272, 256},
    { -992, 232, 272},
    { -1072, 88, 424},
    { -1184, 32, 376},
    { -1104, 32, 184},
    { -1360, 256, 40},
    { -1256, 504, -88},
    { -880, 368, -184},
    { -1112, 88, -96},
    { -1064, -32, -56},
    // 103 seconds
    { -888, -16, -72},
    { -848, 144, -80},
    { -880, 184, 0},
    { -968, 288, -24},
    { -1024, 320, -80},
    { -1016, 360, -160},
    { -1192, 496, -216},
    { -1264, 688, -240},
    { -1544, 144, -304},
    { -1704, 192, -336},
    { -1112, 264, -208},
    { -1352, 400, -152},
    { -1560, 272, -8},
    { -1272, 144, 8},
    { -1008, 104, -8},
    { -960, 128, 96},
    { -976, 88, 104},
    { -960, 88, 80},
    { -920, 88, 112},
    { -912, 88, 168},
    { -1016, 64, 168},
    { -856, 80, 104},
    { -1224, 112, 72},
    { -1216, 336, -360},
    { -1256, 344, -288},
    // 104 seconds
    { -1312, -72, -56},
    { -1144, -344, 40},
    { -1016, -96, -56},
    { -936, 136, 32},
    { -944, 512, -216},
    { -816, 304, -40},
    { -888, 184, -176},
    { -872, 120, -192},
    { -1208, 192, -144},
    { -1464, 360, -88},
    { -1656, 736, -184},
    { -1608, -112, -56},
    { -1096, 56, -168},
    { -1152, 368, -176},
    { -1336, 368, -32},
    { -1376, 184, -24},
    { -1128, 96, 8},
    { -1024, -48, -8},
    { -944, 112, 168},
    { -920, 200, 184},
    { -896, 192, 160},
    { -904, 136, 184},
    { -984, 112, 232},
    { -1008, 96, 152},
    { -1208, 56, 232},
    // 105 seconds
    { -1296, 280, -176},
    { -1104, 408, -288},
    { -1120, 128, -96},
    { -1216, -128, 8},
    { -1200, -32, 0},
    { -1064, 216, -16},
    { -960, 368, 0},
    { -952, 400, 8},
    { -944, 392, -24},
    { -880, 392, -48},
    { -856, 352, -24},
    { -1104, 424, -72},
    { -1112, 616, -72},
    { -1560, 504, -32},
    { -1360, 256, -32},
    { -1048, 264, -32},
    { -1192, 448, 8},
    { -1352, 448, 56},
    { -1296, 392, -48},
    { -1120, 312, 8},
    { -1064, 232, 144},
    { -1032, 112, 144},
    { -952, 160, 128},
    { -848, 120, 136},
    { -800, 96, 184},
    // 106 seconds
    { -864, 72, 216},
    { -840, 80, 192},
    { -1064, 104, 384},
    { -1248, 632, 248},
    { -1104, 1096, 56},
    { -1088, 1112, 120},
    { -1008, 872, 56},
    { -776, 800, 232},
    { -616, 720, 256},
    { -544, 624, 280},
    { -520, 608, 432},
    { -488, 656, 448},
    { -448, 656, 416},
    { -440, 640, 416},
    { -400, 640, 400},
    { -408, 664, 400},
    { -384, 640, 376},
    { -424, 632, 504},
    { -512, 888, 424},
    { -384, 768, 528},
    { -328, 672, 472},
    { -336, 736, 488},
    { -272, 736, 464},
    { -216, 760, 376},
    { -184, 768, 304},
    // 107 seconds
    { -160, 824, 312},
    { -152, 784, 312},
    { -144, 880, 312},
    { -120, 856, 304},
    { -104, 824, 248},
    { -64, 856, 352},
    { -56, 848, 376},
    { -64, 936, 400},
    { -40, 864, 352},
    { 0, 840, 392},
    { -8, 864, 352},
    { 24, 856, 360},
    { -8, 904, 288},
    { 64, 984, 264},
    { 8, 1200, 280},
    { 136, 864, 176},
    { 32, 688, -16},
    { 88, 928, 64},
    { 112, 1168, -232},
    { 120, 920, -216},
    { 120, 656, -264},
    { 128, 824, -416},
    { 168, 648, -600},
    { 136, 440, -664},
    { 24, 152, -856},
    // 108 seconds
    { -24, -16, -936},
    { 0, 0, -952},
    { 32, -24, -1000},
    { -8, -128, -920},
    { 0, -136, -832},
    { -72, -304, -848},
    { -168, -160, -904},
    { -176, -192, -976},
    { -152, -224, -1008},
    { -168, -264, -1008},
    { -112, -224, -1000},
    { -88, -248, -1032},
    { -240, -256, -1000},
    { -136, -272, -1032},
    { -120, -256, -984},
    { -128, -280, -1000},
    { -112, -232, -944},
    { -96, -288, -968},
    { -88, -256, -968},
    { -80, -272, -984},
    { -80, -272, -952},
    { -72, -288, -968},
    { -88, -288, -960},
    { -64, -288, -984},
    { -80, -280, -984},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-10-16 17:27:13 local
AccelRawData *activity_sample_walk_200_pbl_28396_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_28396_10
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 160
  //> TEST_EXPECTED_MAX 220
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -64, 568, -776},
    { 8, 416, -912},
    { -40, 328, -624},
    { 48, 184, -736},
    { 120, 72, -920},
    { -16, 88, -784},
    { 72, -32, -960},
    { -64, -80, -960},
    { -40, -8, -936},
    { 64, -56, -1032},
    { 48, -24, -976},
    { -24, -40, -992},
    { 0, -72, -1048},
    { -48, -80, -1040},
    { -16, -24, -1024},
    { -24, -72, -1016},
    { -32, -96, -984},
    { -64, -104, -984},
    { -88, -104, -952},
    { -112, -144, -968},
    { -96, -152, -1000},
    { -128, -72, -1032},
    { -24, 192, -1080},
    { 16, 40, -952},
    { 48, 16, -992},
    // 1 seconds
    { 40, -8, -976},
    { 48, -16, -976},
    { 40, -8, -992},
    { 32, -16, -992},
    { 48, -32, -1000},
    { 56, 8, -984},
    { 88, 64, -976},
    { 48, 232, -920},
    { 40, 256, -960},
    { 72, 216, -992},
    { 72, 216, -984},
    { 56, 176, -984},
    { 64, 152, -976},
    { 64, 136, -984},
    { 64, 112, -976},
    { 56, 168, -904},
    { 88, 72, -1016},
    { 56, 200, -960},
    { 56, 144, -928},
    { 88, 152, -936},
    { 104, 152, -944},
    { 112, 152, -912},
    { 120, 168, -944},
    { 144, 136, -864},
    { 160, 184, -928},
    // 2 seconds
    { 152, 216, -904},
    { 112, 328, -872},
    { 136, 328, -752},
    { 144, 392, -744},
    { 144, 456, -600},
    { 56, 384, -408},
    { 32, 760, -424},
    { -128, 888, -184},
    { -216, 944, 40},
    { -272, 1008, 136},
    { -256, 944, 296},
    { -200, 1024, 416},
    { -168, 952, 608},
    { -48, 856, 560},
    { -32, 808, 576},
    { -40, 880, 624},
    { -48, 784, 616},
    { -48, 744, 520},
    { -72, 696, 560},
    { -80, 704, 464},
    { -80, 720, 512},
    { -128, 704, 640},
    { -128, 736, 664},
    { -120, 696, 672},
    { -128, 696, 608},
    // 3 seconds
    { -120, 616, 592},
    { -128, 664, 600},
    { -160, 648, 512},
    { -200, 648, 400},
    { -296, 504, 280},
    { -400, 504, 120},
    { -536, 552, 184},
    { -688, 552, 152},
    { -880, 536, 64},
    { -1008, 360, -88},
    { -1168, 288, -312},
    { -1440, 464, 48},
    { -1496, 440, -56},
    { -1376, 512, 16},
    { -1184, 632, -16},
    { -1040, 352, -8},
    { -1072, 296, 40},
    { -1016, 256, 40},
    { -960, 304, -8},
    { -912, 312, -16},
    { -936, 328, -24},
    { -1072, 320, 88},
    { -1216, 640, -72},
    { -1240, 632, -152},
    { -1200, 488, -248},
    // 4 seconds
    { -1120, 248, -448},
    { -1344, 320, -32},
    { -1440, 24, 24},
    { -1192, -16, 208},
    { -1096, 312, 96},
    { -1008, 280, 96},
    { -888, 192, 216},
    { -832, 184, 176},
    { -792, 136, 128},
    { -776, 104, 248},
    { -920, 104, 200},
    { -1024, 64, 200},
    { -1168, 72, 136},
    { -1376, 88, 8},
    { -1472, 200, -256},
    { -1304, 120, -464},
    { -1288, -64, -384},
    { -1384, -48, -248},
    { -1240, 96, -64},
    { -960, 184, 56},
    { -888, 248, 48},
    { -856, 256, 96},
    { -800, 72, 312},
    { -808, 352, 432},
    { -648, 856, 824},
    // 5 seconds
    { -992, 792, 1280},
    { -1344, 816, 1424},
    { -1464, 376, 1248},
    { -1176, 184, 928},
    { -968, 16, 520},
    { -632, -32, 184},
    { -640, 32, -112},
    { -288, 1440, 368},
    { 88, -104, 472},
    { -208, -40, 632},
    { -112, -512, 952},
    { -320, -96, 856},
    { -312, -536, 840},
    { -656, -112, 1080},
    { -752, -72, 1088},
    { -1040, -168, 1448},
    { -1192, -120, 960},
    { -1112, -112, 752},
    { -1128, -352, 464},
    { -1024, -320, 472},
    { -624, -344, 320},
    { -816, 200, 368},
    { -424, -152, 232},
    { -536, 80, 472},
    { -728, 304, 608},
    // 6 seconds
    { -584, 336, 672},
    { -688, -120, 648},
    { -1088, 688, 416},
    { -1304, 184, 312},
    { -1824, 352, 288},
    { -1216, 192, 208},
    { -1360, 528, -336},
    { -1512, 624, -32},
    { -1328, 472, 104},
    { -1040, 232, 88},
    { -912, 48, 96},
    { -880, -16, 112},
    { -848, -16, 88},
    { -808, 16, 80},
    { -864, 32, 176},
    { -1008, 56, 176},
    { -984, 72, 120},
    { -1352, 104, 88},
    { -1328, 344, -232},
    { -1072, 272, -400},
    { -1240, 96, -328},
    { -1352, -120, -168},
    { -1216, -112, -96},
    { -1000, 112, 8},
    { -896, 272, 40},
    // 7 seconds
    { -944, 408, -112},
    { -1024, 432, -128},
    { -976, 384, -96},
    { -1192, 472, -64},
    { -1160, 864, -96},
    { -1584, 304, -248},
    { -1432, 352, -248},
    { -1176, 296, -200},
    { -1320, 272, -128},
    { -1520, 232, -16},
    { -1392, 120, 72},
    { -1128, 72, 56},
    { -1080, 80, 72},
    { -1088, 96, 88},
    { -1024, 88, 112},
    { -960, 112, 112},
    { -1064, 64, 128},
    { -1008, -168, 144},
    { -1040, -136, 48},
    { -1280, 8, -32},
    { -1264, 128, -144},
    { -1464, 128, -184},
    { -1424, -224, 16},
    { -1320, -216, 56},
    { -1232, 40, 8},
    // 8 seconds
    { -1120, 208, 168},
    { -1128, 328, 160},
    { -1152, 520, 128},
    { -1112, 464, 40},
    { -1064, 472, -32},
    { -1136, 584, -96},
    { -1104, 248, -120},
    { -1632, 368, -144},
    { -1280, 360, -176},
    { -1376, 312, -112},
    { -1592, 384, -72},
    { -1736, 264, -16},
    { -1600, 144, 56},
    { -1456, -32, 160},
    { -1368, -96, 184},
    { -1224, -16, 160},
    { -1056, 40, 144},
    { -952, 120, 160},
    { -928, 96, 152},
    { -840, 0, 184},
    { -976, -24, 176},
    { -1024, 120, -56},
    { -992, 288, -240},
    { -1080, 168, -224},
    { -1416, 0, -112},
    // 9 seconds
    { -1528, -192, 8},
    { -1576, 16, -64},
    { -1464, 288, 0},
    { -1272, 344, 264},
    { -1280, 552, 32},
    { -1216, 448, 0},
    { -1232, 392, -8},
    { -1328, 552, -32},
    { -1176, 576, -120},
    { -1600, 712, -272},
    { -1152, 408, -264},
    { -1232, 368, -240},
    { -1568, 328, -32},
    { -1800, 264, 40},
    { -1648, 96, -8},
    { -1432, 96, -32},
    { -1368, 120, -8},
    { -1344, 104, 40},
    { -1280, 136, 48},
    { -1160, 112, 72},
    { -1064, -16, 8},
    { -752, -248, -184},
    { -976, -280, -128},
    { -1168, -104, -80},
    { -1256, 168, -104},
    // 10 seconds
    { -1432, 224, -48},
    { -1528, 184, -32},
    { -1352, 144, -120},
    { -1216, 208, -64},
    { -1184, 224, 176},
    { -1304, 344, -24},
    { -1496, 656, -104},
    { -1192, 1592, -192},
    { -1192, 576, -408},
    { -1056, 688, -328},
    { -1432, 976, -144},
    { -1400, 744, -16},
    { -1368, 456, 32},
    { -1576, 360, 160},
    { -1696, 296, 240},
    { -1536, 216, 176},
    { -1264, 152, 136},
    { -1128, 104, 152},
    { -1080, 88, 96},
    { -1040, 88, 112},
    { -888, 24, 40},
    { -704, -272, 48},
    { -824, -48, -56},
    { -1112, -72, -96},
    { -1336, 64, -136},
    // 11 seconds
    { -1440, 168, -264},
    { -1688, -16, -88},
    { -1640, -120, 16},
    { -1504, 120, -184},
    { -1240, 256, 16},
    { -1024, 248, 96},
    { -1040, 344, 64},
    { -1080, 392, -32},
    { -952, 352, -56},
    { -1024, 344, -24},
    { -1152, 632, 224},
    { -1368, 888, 16},
    { -1544, 464, -128},
    { -1056, 432, -168},
    { -1312, 488, -48},
    { -1600, 368, 96},
    { -1480, 224, 0},
    { -1272, 176, 8},
    { -1152, 224, 88},
    { -1176, 112, 128},
    { -1200, 80, 112},
    { -1216, 72, 64},
    { -1264, 24, 136},
    { -1000, -216, 256},
    { -1176, -48, 8},
    // 12 seconds
    { -1232, 32, -160},
    { -1112, 176, -336},
    { -1368, -40, -160},
    { -1376, -232, 32},
    { -1392, 336, -200},
    { -1128, 440, -88},
    { -1016, 272, 40},
    { -1080, 272, 24},
    { -1232, 288, -16},
    { -1272, 352, -128},
    { -1288, 552, -256},
    { -1184, 544, -256},
    { -1488, 368, -304},
    { -1448, 504, -264},
    { -1168, 360, -296},
    { -1368, 336, -200},
    { -1592, 320, -56},
    { -1544, 296, -24},
    { -1360, 184, 32},
    { -1304, 88, 144},
    { -1256, 32, 144},
    { -1136, 40, 120},
    { -1016, 168, -8},
    { -1096, 104, 32},
    { -984, -160, 272},
    // 13 seconds
    { -808, -416, 376},
    { -1208, 96, 48},
    { -1304, 104, -232},
    { -1408, -80, -40},
    { -1544, -128, -48},
    { -1416, 32, 72},
    { -1328, 264, 160},
    { -1216, 456, 152},
    { -1184, 520, 112},
    { -1200, 488, 104},
    { -1136, 432, 32},
    { -1096, 496, 32},
    { -1104, 904, -48},
    { -968, 744, 40},
    { -1288, 936, -48},
    { -1248, 904, -120},
    { -1360, 688, -160},
    { -1600, 488, -24},
    { -1768, 400, 160},
    { -1544, 240, 152},
    { -1336, 248, 160},
    { -1232, 304, 144},
    { -1208, 248, 128},
    { -1136, 272, 184},
    { -1056, 152, 184},
    // 14 seconds
    { -960, 72, 296},
    { -720, -224, 312},
    { -896, -400, -504},
    { -1232, 136, -80},
    { -1544, 488, -152},
    { -1656, 376, -240},
    { -1680, 440, 360},
    { -1656, 480, -40},
    { -1440, 664, -40},
    { -1200, 672, 64},
    { -1128, 656, 184},
    { -1248, 352, 168},
    { -1120, 432, 216},
    { -992, 528, 216},
    { -944, 704, 280},
    { -784, 1000, 224},
    { -1264, 840, 120},
    { -1104, 1360, 168},
    { -1192, 1088, -8},
    { -1552, 896, 80},
    { -2040, 688, 312},
    { -2088, 568, 392},
    { -2048, 664, 424},
    { -2040, 632, 656},
    { -2048, 1456, 672},
    // 15 seconds
    { -1968, 1808, 736},
    { -1528, 1536, 480},
    { -1096, 1128, 288},
    { -816, 688, -16},
    { -688, 400, -224},
    { -312, -232, -400},
    { -112, -656, -392},
    { -232, -592, -632},
    { -200, -632, -576},
    { -96, -856, -296},
    { -80, -816, -240},
    { -16, -696, -256},
    { 16, -664, -272},
    { 168, -720, -416},
    { 368, -672, -416},
    { 480, -824, -368},
    { 720, -920, -336},
    { 728, -1200, -248},
    { 944, -928, 128},
    { 896, -1008, -72},
    { 736, -752, -208},
    { 552, -664, -184},
    { 360, -568, -168},
    { 240, -664, -536},
    { 240, -608, -704},
    // 16 seconds
    { 624, -888, -280},
    { 840, -544, -352},
    { 712, -680, -272},
    { 576, -784, -128},
    { 488, -1080, -352},
    { 504, -1264, -432},
    { 456, -952, -736},
    { 424, -928, -432},
    { 240, -600, -280},
    { 136, -448, -288},
    { 96, -528, -200},
    { -8, -280, -40},
    { 88, -264, 80},
    { -48, -280, 24},
    { -40, -184, -120},
    { 48, -96, -200},
    { 88, 464, -480},
    { -552, 1816, -408},
    { -1064, 3240, -624},
    { -1336, 2304, -928},
    { -912, 1848, -712},
    { -776, 1080, -704},
    { -784, 704, -552},
    { -696, 504, -384},
    { -608, 280, -312},
    // 17 seconds
    { -584, 248, -168},
    { -568, 112, -152},
    { -624, 168, -120},
    { -696, -8, -88},
    { -832, -128, -48},
    { -1248, -112, 48},
    { -1800, 24, 144},
    { -2000, 264, -232},
    { -2336, 536, -656},
    { -1736, 112, 56},
    { -1280, -200, -168},
    { -1080, 88, 96},
    { -1032, 376, 184},
    { -1008, 336, 184},
    { -928, 336, 0},
    { -688, 248, 96},
    { -928, 352, 64},
    { -1224, 432, 240},
    { -1408, 1632, 360},
    { -1288, 872, 16},
    { -1136, 584, -184},
    { -1304, 408, -48},
    { -1600, 384, 80},
    { -1480, 352, 40},
    { -1248, 248, 96},
    // 18 seconds
    { -1216, 232, 80},
    { -1352, 112, 128},
    { -1360, 56, 96},
    { -1376, 120, 120},
    { -1320, -88, 80},
    { -976, -352, 184},
    { -1000, -384, 176},
    { -1176, 56, -120},
    { -1328, 320, -280},
    { -1648, 40, -304},
    { -1648, 80, -216},
    { -1336, 216, -96},
    { -1048, 304, 160},
    { -984, 440, 40},
    { -1072, 368, 56},
    { -1104, 392, 80},
    { -1104, 304, 168},
    { -1128, 680, 416},
    { -832, 776, 160},
    { -1528, 808, 248},
    { -1208, 624, 184},
    { -1280, 672, 56},
    { -1568, 472, 128},
    { -1592, 336, 104},
    { -1344, 336, 80},
    // 19 seconds
    { -1240, 264, 104},
    { -1240, 248, 96},
    { -1200, 128, 104},
    { -1096, 128, 152},
    { -1000, -8, 152},
    { -904, -136, 192},
    { -720, -56, 128},
    { -928, 0, -16},
    { -1240, 144, -152},
    { -1376, 248, -488},
    { -1608, 168, -208},
    { -1544, -16, -120},
    { -1384, 208, -80},
    { -1088, 272, 40},
    { -1024, 288, 88},
    { -1072, 296, 144},
    { -1096, 272, 128},
    { -960, 288, 80},
    { -1080, 328, 56},
    { -1320, 432, 304},
    { -1464, 1488, 392},
    { -1216, 192, -240},
    { -904, 656, -416},
    { -1120, 912, -224},
    { -1328, 352, -104},
    // 20 seconds
    { -1384, 192, -88},
    { -1224, 184, -104},
    { -1120, 184, -120},
    { -1184, 224, -120},
    { -1256, 216, -32},
    { -1264, 208, 0},
    { -1376, 168, 64},
    { -1320, -272, 240},
    { -1176, -560, 224},
    { -1248, -120, -264},
    { -1088, -152, -440},
    { -1512, 0, -536},
    { -1496, -64, -336},
    { -1592, 40, -360},
    { -1288, -24, -48},
    { -1072, 232, 128},
    { -1016, 400, 0},
    { -1056, 432, -64},
    { -992, 360, -64},
    { -888, 400, -48},
    { -992, 312, -24},
    { -1056, 488, 48},
    { -1656, 680, 248},
    { -1016, 552, 8},
    { -1208, 584, -48},
    // 21 seconds
    { -1352, 472, -64},
    { -1472, 432, -40},
    { -1344, 312, -64},
    { -1128, 264, -16},
    { -1088, 392, -72},
    { -1104, 384, 16},
    { -1120, 368, 16},
    { -1184, 232, 80},
    { -1208, -168, -56},
    { -1160, -272, -72},
    { -1304, 48, 24},
    { -1304, 528, -128},
    { -1416, 568, 16},
    { -1464, 464, 120},
    { -1288, 312, 160},
    { -1104, 376, 208},
    { -912, 352, 168},
    { -880, 440, 176},
    { -976, 344, 120},
    { -944, 424, 48},
    { -1112, 712, 120},
    { -1152, 608, 40},
    { -1352, 968, -8},
    { -1600, 232, -72},
    { -1072, 272, -344},
    // 22 seconds
    { -1168, 440, -344},
    { -1328, 472, -96},
    { -1408, 280, 0},
    { -1280, 216, 16},
    { -1160, 160, 40},
    { -1176, 176, 88},
    { -1256, 368, 184},
    { -1272, 96, 168},
    { -1368, 248, 256},
    { -1096, -352, 504},
    { -1120, -288, 232},
    { -1104, -200, 24},
    { -1120, -184, -152},
    { -1416, -32, -232},
    { -1456, 56, -136},
    { -1288, 160, -128},
    { -1056, 344, -80},
    { -936, 384, -8},
    { -1008, 432, -112},
    { -1144, 328, -48},
    { -1152, 328, -88},
    { -1224, 528, -192},
    { -1104, 672, -296},
    { -1592, 680, -264},
    { -1272, 328, -320},
    // 23 seconds
    { -1160, 424, -376},
    { -1360, 400, -152},
    { -1552, 168, 48},
    { -1344, 240, 48},
    { -1136, 168, 48},
    { -1064, 152, 88},
    { -1120, 192, 112},
    { -1128, 176, 96},
    { -1168, 280, 80},
    { -1304, -112, 320},
    { -888, -352, 200},
    { -1152, -304, 128},
    { -1376, -152, -144},
    { -1392, -120, -80},
    { -1504, -184, -128},
    { -1352, -128, -80},
    { -1160, 56, -56},
    { -1032, 168, 32},
    { -992, 192, 96},
    { -1104, 376, -40},
    { -1216, 424, -32},
    { -1288, 928, -232},
    { -1144, 680, -40},
    { -1104, 488, -208},
    { -1488, 840, -320},
    // 24 seconds
    { -1224, 664, -216},
    { -1512, 632, 0},
    { -1768, 504, 256},
    { -1752, 528, 264},
    { -1280, 552, 144},
    { -1208, 480, 248},
    { -1160, 296, 184},
    { -1024, 232, 208},
    { -896, 168, 144},
    { -768, -368, -16},
    { -688, -640, -352},
    { -856, -88, -168},
    { -1496, 24, 248},
    { -1872, 560, -96},
    { -1704, 616, -8},
    { -1600, 464, 56},
    { -1488, 552, -24},
    { -1264, 608, -72},
    { -1096, 504, 96},
    { -1104, 496, 184},
    { -1120, 552, 120},
    { -1048, 552, 104},
    { -880, 504, 192},
    { -832, 768, 152},
    { -736, 800, 256},
    // 25 seconds
    { -1496, 784, 360},
    { -1112, 576, 328},
    { -1192, 680, 48},
    { -1336, 584, 104},
    { -1520, 464, 152},
    { -1432, 448, 152},
    { -1320, 424, 152},
    { -1376, 240, 120},
    { -1328, 184, 152},
    { -1216, 256, 184},
    { -1264, 272, 384},
    { -1176, -160, 88},
    { -752, -320, -144},
    { -1112, -184, 64},
    { -1344, 296, -40},
    { -1312, 360, -56},
    { -1256, 64, 232},
    { -1120, 136, 64},
    { -1064, 240, -16},
    { -928, 288, -24},
    { -960, 240, -56},
    { -1128, 312, -56},
    { -1280, 400, 16},
    { -1344, 600, 104},
    { -1416, 1192, 280},
    // 26 seconds
    { -1168, 576, -264},
    { -1584, 920, -16},
    { -1144, 736, 0},
    { -1104, 704, -144},
    { -1352, 480, -24},
    { -1544, 352, 104},
    { -1304, 256, 120},
    { -1088, 160, 88},
    { -1024, 104, 96},
    { -1064, 104, 136},
    { -1128, 128, 104},
    { -1248, 152, 80},
    { -1488, -32, 104},
    { -1112, -304, 144},
    { -1200, -176, 40},
    { -1000, 392, -248},
    { -896, 408, -320},
    { -1168, 16, -184},
    { -1512, 56, -80},
    { -1328, 80, 144},
    { -1280, 336, 240},
    { -1080, 528, 72},
    { -1064, 304, -136},
    { -1216, 352, -136},
    { -1368, 472, 56},
    // 27 seconds
    { -1256, 888, -48},
    { -1312, 456, -56},
    { -1528, 432, -72},
    { -1096, 416, -216},
    { -1280, 512, -120},
    { -1496, 432, 88},
    { -1464, 208, 80},
    { -1256, 96, 40},
    { -1184, 96, 72},
    { -1264, 128, 112},
    { -1312, 96, 120},
    { -1272, 64, 112},
    { -1320, 32, 136},
    { -1152, -112, 8},
    { -1088, 128, -56},
    { -992, -40, -56},
    { -872, 56, -288},
    { -936, 128, -400},
    { -1264, 112, -416},
    { -1352, 200, -328},
    { -1320, 312, -224},
    { -1184, 384, 32},
    { -1072, 496, 88},
    { -1032, 480, -24},
    { -1136, 488, 0},
    // 28 seconds
    { -1120, 432, 96},
    { -1088, 384, 72},
    { -936, 560, -8},
    { -1464, 864, -48},
    { -1136, 528, -152},
    { -1168, 600, -208},
    { -1424, 520, -48},
    { -1464, 376, 8},
    { -1136, 264, -32},
    { -1024, 232, 8},
    { -1088, 184, 72},
    { -1176, 144, 96},
    { -1256, 144, 48},
    { -1496, 32, 104},
    { -1344, -144, 248},
    { -1056, -384, 176},
    { -1448, 88, -128},
    { -1128, 128, -160},
    { -1080, 168, -312},
    { -1192, 136, -240},
    { -1184, 136, -112},
    { -1128, 264, -176},
    { -1072, 336, -120},
    { -1120, 416, -104},
    { -1184, 448, -88},
    // 29 seconds
    { -1152, 672, -64},
    { -1112, 424, -144},
    { -1192, 544, -192},
    { -1304, 576, -192},
    { -1536, 632, -136},
    { -1048, 360, -216},
    { -1216, 408, -232},
    { -1432, 408, -80},
    { -1552, 320, -8},
    { -1344, 216, 48},
    { -1184, 120, 96},
    { -1088, 88, 96},
    { -1064, 104, 88},
    { -1032, 104, 64},
    { -1096, 96, 128},
    { -1176, -152, 224},
    { -1008, -200, 168},
    { -1216, -48, 64},
    { -1248, 160, -88},
    { -1272, 192, -208},
    { -1424, 120, -232},
    { -1400, 120, -280},
    { -1248, 176, -192},
    { -1104, 232, -40},
    { -1088, 344, 64},
    // 30 seconds
    { -1168, 408, 16},
    { -1112, 360, -48},
    { -1080, 344, -40},
    { -1152, 448, -24},
    { -1040, 368, 8},
    { -1480, 432, -88},
    { -1184, 432, -112},
    { -1256, 504, -120},
    { -1504, 432, -64},
    { -1488, 360, -56},
    { -1240, 176, -80},
    { -1240, 112, -8},
    { -1472, -176, 0},
    { -1336, 136, 8},
    { -1032, 176, -32},
    { -992, 96, 0},
    { -1128, 32, 160},
    { -976, 24, 128},
    { -1264, 24, -32},
    { -1376, 216, -168},
    { -1040, 96, -320},
    { -1184, 80, -304},
    { -1272, 8, -200},
    { -1176, 48, -136},
    { -1064, 152, -72},
    // 31 seconds
    { -1072, 320, -48},
    { -1160, 384, -120},
    { -1176, 408, -128},
    { -1056, 472, -136},
    { -1096, 408, -176},
    { -1072, 328, -136},
    { -1376, 456, -144},
    { -1376, 480, -128},
    { -1008, 344, -192},
    { -1280, 352, -152},
    { -1448, 320, -88},
    { -1312, 192, -120},
    { -1136, 120, -96},
    { -1104, 112, -32},
    { -1112, 88, 16},
    { -1040, 88, 16},
    { -928, 96, 32},
    { -952, 80, 64},
    { -1128, -24, 112},
    { -1176, -96, 152},
    { -1344, 40, 40},
    { -1248, 192, -320},
    { -1280, 192, -272},
    { -1232, -88, -168},
    { -1152, -24, -272},
    // 32 seconds
    { -1040, 144, -240},
    { -896, 200, -120},
    { -944, 248, -168},
    { -1088, 296, -128},
    { -1072, 320, -168},
    { -960, 392, -144},
    { -1024, 600, -144},
    { -1056, 216, -120},
    { -1744, 480, -64},
    { -1216, 336, -80},
    { -1096, 320, -128},
    { -1304, 296, -72},
    { -1352, 248, -56},
    { -1128, 176, -64},
    { -1008, 112, -40},
    { -992, 72, -8},
    { -1000, 88, 16},
    { -960, 88, 24},
    { -912, 88, 40},
    { -1072, 96, 72},
    { -1224, 80, 0},
    { -1192, 80, 32},
    { -1288, 104, -216},
    { -1024, 120, -312},
    { -1184, 80, -352},
    // 33 seconds
    { -1288, 0, -160},
    { -1184, -40, -80},
    { -984, 168, -24},
    { -784, 224, 88},
    { -848, 296, 40},
    { -968, 400, -88},
    { -928, 368, -80},
    { -1160, 448, -104},
    { -1216, 672, -8},
    { -1432, 432, -120},
    { -1584, 240, -168},
    { -1040, 344, -216},
    { -1080, 416, -200},
    { -1288, 328, -56},
    { -1344, 192, -32},
    { -1088, 152, -24},
    { -944, 88, 24},
    { -952, 80, 40},
    { -984, 72, 56},
    { -1072, 144, 80},
    { -1344, -32, 184},
    { -1200, -200, 168},
    { -1240, -136, 112},
    { -1312, 24, -32},
    { -1136, 184, -256},
    // 34 seconds
    { -1208, 136, -168},
    { -1208, 96, -120},
    { -1128, 128, -96},
    { -936, 200, -56},
    { -816, 184, 0},
    { -888, 312, 88},
    { -1000, 288, 64},
    { -1032, 408, 88},
    { -1144, 496, 48},
    { -1248, 656, 72},
    { -1136, 696, -80},
    { -1408, 592, -120},
    { -1008, 480, -136},
    { -1224, 560, -56},
    { -1616, 416, 128},
    { -1456, 320, 120},
    { -1080, 248, 80},
    { -944, 224, 112},
    { -936, 192, 136},
    { -928, 104, 184},
    { -1224, 424, 16},
    { -1104, -200, 272},
    { -1016, -160, 160},
    { -1064, -216, 200},
    { -1568, 200, 48},
    // 35 seconds
    { -1376, 296, -200},
    { -1240, 280, -184},
    { -1224, 256, -152},
    { -1136, 336, -256},
    { -928, 296, -168},
    { -784, 288, -72},
    { -824, 336, -24},
    { -984, 440, -56},
    { -1064, 440, 0},
    { -1136, 584, -16},
    { -928, 936, 104},
    { -1248, 768, -72},
    { -1320, 560, 32},
    { -1216, 584, 40},
    { -1488, 576, 160},
    { -1408, 416, 200},
    { -1072, 360, 88},
    { -920, 296, 88},
    { -912, 320, 56},
    { -984, 208, 144},
    { -984, 160, 160},
    { -1096, 120, 144},
    { -1352, -16, 264},
    { -1216, -144, 216},
    { -1376, -24, 104},
    // 36 seconds
    { -1472, 384, -352},
    { -1344, 208, -200},
    { -1368, -96, -112},
    { -1192, 48, -168},
    { -904, 192, -128},
    { -688, 200, -8},
    { -720, 200, 88},
    { -896, 248, 88},
    { -1016, 304, 32},
    { -1160, 408, 56},
    { -1392, 752, 384},
    { -1072, 664, 312},
    { -1360, 1064, 232},
    { -984, 984, 240},
    { -1232, 632, 352},
    { -1528, 376, 392},
    { -1368, 344, 200},
    { -1072, 328, 136},
    { -960, 264, 128},
    { -976, 216, 120},
    { -1000, 144, 176},
    { -1104, 112, 160},
    { -1376, -104, 280},
    { -1160, -280, 144},
    { -1048, -184, 0},
    // 37 seconds
    { -1456, 56, -48},
    { -1312, 280, -296},
    { -1376, 88, -104},
    { -1400, -88, -104},
    { -1272, 24, -112},
    { -1104, 248, -88},
    { -952, 280, 40},
    { -1032, 312, 40},
    { -1072, 352, 24},
    { -1016, 416, 24},
    { -1112, 576, -72},
    { -1208, 568, -64},
    { -1416, 448, -112},
    { -1360, 552, -112},
    { -1040, 488, -184},
    { -1336, 488, -112},
    { -1600, 344, 24},
    { -1672, 248, 56},
    { -1392, 152, 48},
    { -1176, 96, 72},
    { -1096, 96, 72},
    { -1056, 96, 80},
    { -1024, 112, 80},
    { -1024, 48, 160},
    { -1016, -232, 184},
    // 38 seconds
    { -872, -160, 64},
    { -1152, -24, 136},
    { -1184, 176, -176},
    { -1328, 232, -232},
    { -1640, 56, -168},
    { -1704, 120, -272},
    { -1408, 216, -200},
    { -1120, 320, -40},
    { -1048, 424, -8},
    { -1144, 304, 24},
    { -1184, 344, 8},
    { -1080, 352, 48},
    { -1104, 560, 64},
    { -952, 656, 104},
    { -1536, 472, 0},
    { -1104, 424, -88},
    { -1224, 360, -80},
    { -1552, 480, 16},
    { -1656, 408, -88},
    { -1320, 248, -168},
    { -1200, 264, -80},
    { -1248, 216, 96},
    { -1280, 80, 112},
    { -1200, 56, 24},
    { -1216, 56, 88},
    // 39 seconds
    { -1208, -32, 152},
    { -800, -144, -64},
    { -1040, -80, -24},
    { -1240, 136, -88},
    { -1176, 152, -248},
    { -1416, 160, -280},
    { -1392, 16, -176},
    { -1144, -88, -152},
    { -1072, 40, 16},
    { -1248, 224, 96},
    { -1416, 440, -104},
    { -1256, 464, -144},
    { -1096, 944, -272},
    { -1072, 216, -216},
    { -1440, 352, -120},
    { -1720, 592, -64},
    { -1168, 392, -192},
    { -1184, 304, -184},
    { -1392, 320, -72},
    { -1464, 272, -32},
    { -1304, 168, -24},
    { -1208, 96, 64},
    { -1208, 72, 96},
    { -1168, 72, 96},
    { -1064, 64, 120},
    // 40 seconds
    { -1016, 72, 128},
    { -1184, -80, 152},
    { -992, -192, 56},
    { -1080, -96, -24},
    { -1272, 56, -144},
    { -1104, 160, -296},
    { -1248, 112, -296},
    { -1432, -56, -128},
    { -1424, -168, -8},
    { -1240, 96, 16},
    { -1120, 408, -56},
    { -1080, 416, -184},
    { -1096, 368, -248},
    { -1008, 376, -192},
    { -1120, 824, -392},
    { -1088, 368, -192},
    { -1440, 472, -320},
    { -1432, 472, -216},
    { -1192, 384, -200},
    { -1336, 344, -104},
    { -1480, 272, 32},
    { -1376, 232, 24},
    { -1200, 200, 40},
    { -1144, 136, 64},
    { -1160, 104, 112},
    // 41 seconds
    { -1096, 88, 104},
    { -1024, 88, 104},
    { -1096, 8, 24},
    { -968, -168, 16},
    { -920, -144, -184},
    { -1240, -40, -288},
    { -1200, -32, -344},
    { -1360, -48, -344},
    { -1496, -48, -208},
    { -1440, -32, -56},
    { -1208, 96, -8},
    { -976, 232, 80},
    { -936, 280, 112},
    { -1024, 328, -16},
    { -1056, 256, -40},
    { -1104, 320, -144},
    { -1224, 472, -192},
    { -1080, 704, -232},
    { -1648, 152, -200},
    { -1152, 224, -240},
    { -1176, 368, -176},
    { -1472, 392, -40},
    { -1584, 216, -32},
    { -1272, 104, -32},
    { -1088, 64, -16},
    // 42 seconds
    { -1120, 72, 32},
    { -1136, 56, 48},
    { -1128, 56, 56},
    { -1232, -96, 208},
    { -1192, -528, 320},
    { -992, -424, 328},
    { -1424, -144, 104},
    { -1360, 216, -352},
    { -1384, 328, -320},
    { -1432, 72, 40},
    { -1280, -360, 24},
    { -1200, 16, -136},
    { -1040, 272, -24},
    { -944, 320, 0},
    { -1040, 384, -120},
    { -1024, 288, -72},
    { -1032, 344, -120},
    { -1136, 552, -120},
    { -1112, 352, -176},
    { -1632, 408, -216},
    { -1424, 368, -160},
    { -1144, 296, -192},
    { -1376, 328, -56},
    { -1592, 272, 88},
    { -1480, 184, 72},
    // 43 seconds
    { -1208, 96, 96},
    { -1104, 48, 128},
    { -1096, 40, 152},
    { -1048, 72, 120},
    { -992, 104, 96},
    { -1088, -56, 136},
    { -1024, -288, 128},
    { -960, -184, 88},
    { -1360, 16, 8},
    { -1216, 216, -296},
    { -1296, 184, -328},
    { -1424, -144, -112},
    { -1360, -176, 344},
    { -1352, 440, -72},
    { -992, 320, 64},
    { -952, 392, 8},
    { -1008, 360, 32},
    { -960, 264, -32},
    { -1032, 288, -48},
    { -1136, 728, -184},
    { -1304, 272, -88},
    { -1712, 256, -96},
    { -1152, 272, -192},
    { -1272, 408, -136},
    { -1480, 360, 0},
    // 44 seconds
    { -1296, 176, -16},
    { -1104, 96, -24},
    { -1152, 96, 32},
    { -1256, 72, 80},
    { -1200, 80, 16},
    { -1080, 72, 64},
    { -1048, -40, 128},
    { -1040, -160, 88},
    { -936, -48, 8},
    { -1080, 56, -56},
    { -992, 168, -376},
    { -1136, 176, -336},
    { -1432, -64, -168},
    { -1480, -136, -48},
    { -1280, 56, -96},
    { -1064, 200, -48},
    { -1104, 144, 8},
    { -1104, 240, -32},
    { -1072, 464, -160},
    { -968, 784, -296},
    { -960, 712, -168},
    { -1096, 368, -184},
    { -1568, 784, -192},
    { -1360, 504, -112},
    { -1584, 440, 40},
    // 45 seconds
    { -1888, 312, 232},
    { -1688, 296, 168},
    { -1376, 272, 128},
    { -1264, 224, 144},
    { -1248, 200, 240},
    { -1224, 144, 184},
    { -1096, 96, 264},
    { -944, 96, 200},
    { -1016, -216, 432},
    { -424, -288, 120},
    { -816, 0, 8},
    { -1112, -72, -96},
    { -1080, 64, -400},
    { -1232, -176, -360},
    { -1496, 16, -176},
    { -1520, 320, -168},
    { -1232, 608, -312},
    { -1008, 880, -136},
    { -792, 1176, -8},
    { -656, 1216, 192},
    { -384, 1216, 320},
    { -360, 920, 424},
    { -520, 832, 608},
    { -640, 688, 680},
    { -1128, 712, 992},
    // 46 seconds
    { -968, 856, 816},
    { -864, 568, 728},
    { -832, 768, 552},
    { -864, 648, 584},
    { -640, 696, 384},
    { -440, 464, 232},
    { -296, 392, 136},
    { -176, 464, 24},
    { -104, 520, -56},
    { -144, 552, -8},
    { -264, 264, -16},
    { -416, -32, -48},
    { -552, -48, -16},
    { -744, 64, -24},
    { -1592, 32, 576},
    { -2696, 432, 456},
    { -2560, 1032, -152},
    { -2064, 744, 176},
    { -1352, 376, -56},
    { -1064, 48, 72},
    { -1032, 360, 56},
    { -1008, 368, -72},
    { -992, 248, -112},
    { -888, 496, -88},
    { -1048, 512, 96},
    // 47 seconds
    { -1104, 1192, 16},
    { -1504, 688, -8},
    { -1040, 632, 0},
    { -1456, 584, 128},
    { -1872, 488, 336},
    { -1856, 168, 384},
    { -1584, 32, 312},
    { -1352, -8, 256},
    { -1264, 40, 208},
    { -1272, 64, 224},
    { -1344, 88, 248},
    { -1592, 88, 240},
    { -1264, -208, 312},
    { -1192, -216, 240},
    { -984, 40, -128},
    { -896, 128, -320},
    { -960, 32, -64},
    { -1032, -160, -80},
    { -1120, -144, -96},
    { -1248, 96, -64},
    { -1408, 256, -8},
    { -1720, 736, -80},
    { -1632, 816, -200},
    { -1160, 576, -304},
    { -1520, 216, -336},
    // 48 seconds
    { -1464, 328, -416},
    { -1600, 760, -408},
    { -1160, 296, -312},
    { -1248, 192, -128},
    { -1360, 248, 32},
    { -1168, 224, 56},
    { -1016, 176, 24},
    { -968, 120, 88},
    { -1032, 104, 144},
    { -1112, 96, 160},
    { -1336, 112, 184},
    { -1560, -168, 320},
    { -1328, -240, 176},
    { -1416, -112, 56},
    { -1280, 8, -192},
    { -1232, -8, -144},
    { -1184, -144, -88},
    { -1056, -168, -112},
    { -960, -32, -32},
    { -896, 168, -24},
    { -912, 216, 64},
    { -1016, 432, 0},
    { -1096, 456, -72},
    { -1232, 568, -24},
    { -1216, 1176, 32},
    // 49 seconds
    { -1576, 208, -72},
    { -1480, 512, -136},
    { -1200, 512, -216},
    { -1368, 352, -120},
    { -1552, 232, 0},
    { -1344, 112, 24},
    { -1080, 136, 48},
    { -1032, 112, 88},
    { -1048, 104, 128},
    { -1072, 64, 160},
    { -1200, 72, 200},
    { -1336, 32, 272},
    { -1056, 0, -80},
    { -1240, 0, -56},
    { -1176, -8, 80},
    { -1056, 64, -328},
    { -1168, 160, -264},
    { -1248, 136, -136},
    { -1096, 56, -80},
    { -952, 16, -24},
    { -872, 80, 72},
    { -1048, 176, -64},
    { -1224, 272, -136},
    { -1352, 176, 72},
    { -1472, 904, -168},
    // 50 seconds
    { -1216, 352, -88},
    { -1568, 504, -240},
    { -1240, 592, -256},
    { -1216, 512, -128},
    { -1496, 384, 8},
    { -1608, 168, 88},
    { -1416, 80, 96},
    { -1224, 80, 120},
    { -1160, 72, 152},
    { -1144, 72, 144},
    { -1120, 64, 160},
    { -1136, 72, 160},
    { -1224, -16, 184},
    { -984, -336, 224},
    { -1040, -112, 120},
    { -1136, 96, -96},
    { -1328, 152, -224},
    { -1488, 136, -104},
    { -1408, -240, -48},
    { -1400, -96, -112},
    { -1232, 96, -8},
    { -1048, 352, 184},
    { -1128, 504, 8},
    { -1152, 488, 24},
    { -1256, 456, 16},
    // 51 seconds
    { -1184, 624, -24},
    { -1064, 488, -40},
    { -1600, 616, 8},
    { -1104, 576, -32},
    { -1392, 568, 56},
    { -1608, 448, 80},
    { -1512, 304, 16},
    { -1272, 184, -32},
    { -1264, 160, 48},
    { -1344, 24, 168},
    { -1336, -16, 136},
    { -1296, 24, 104},
    { -1504, -120, 176},
    { -1152, -264, 296},
    { -1016, -360, 144},
    { -1144, -136, -88},
    { -1320, 0, -144},
    { -1536, -40, -96},
    { -1456, -152, 0},
    { -1384, -80, 48},
    { -1296, 144, 184},
    { -1232, 272, 336},
    { -1328, 464, 96},
    { -1192, 504, 48},
    { -1016, 544, 8},
    // 52 seconds
    { -1064, 736, -16},
    { -1072, 304, 24},
    { -1696, 640, -40},
    { -1176, 360, -160},
    { -1432, 456, -56},
    { -1792, 344, 48},
    { -1656, 216, -88},
    { -1304, 120, -96},
    { -1184, 120, 0},
    { -1240, 104, 96},
    { -1320, 144, 88},
    { -1360, 72, 88},
    { -1472, -312, 272},
    { -1088, -232, 176},
    { -1048, -392, 232},
    { -1088, -144, 56},
    { -1152, -64, -48},
    { -1440, -136, 40},
    { -1608, 8, -136},
    { -1416, -8, -232},
    { -1232, 48, -312},
    { -1072, 24, -136},
    { -1208, 120, 0},
    { -1272, 296, -152},
    { -1176, 520, -312},
    // 53 seconds
    { -1216, 280, -296},
    { -1352, 152, -272},
    { -2144, 440, -296},
    { -1472, 128, -264},
    { -1616, -8, -112},
    { -1768, -40, -16},
    { -1536, -48, -56},
    { -1280, -56, -40},
    { -1176, -88, 56},
    { -1160, 24, 72},
    { -1040, -24, 24},
    { -928, -168, 136},
    { -976, -216, 168},
    { -856, -208, 240},
    { -880, -216, 272},
    { -1160, -16, 168},
    { -1312, 40, -16},
    { -1640, -8, -224},
    { -1848, -144, -184},
    { -1584, -216, -112},
    { -1176, -32, -240},
    { -1176, 24, -280},
    { -1264, 88, -24},
    { -1176, 232, -32},
    { -1120, 520, -200},
    // 54 seconds
    { -1240, 592, -288},
    { -1168, 480, -176},
    { -1488, 400, -336},
    { -1328, 464, -200},
    { -1144, 416, -200},
    { -1320, 376, -168},
    { -1656, 320, -136},
    { -1440, 208, -104},
    { -1232, 168, -72},
    { -1240, 136, 0},
    { -1216, 112, 64},
    { -1152, 96, 72},
    { -1144, 88, 72},
    { -1184, -32, 136},
    { -1048, -88, 112},
    { -1304, 56, -8},
    { -1216, 96, -224},
    { -1312, 176, -368},
    { -1344, 0, -208},
    { -1144, -176, -80},
    { -904, -16, -176},
    { -848, 24, -120},
    { -984, 224, 88},
    { -1240, 200, 0},
    { -1400, 312, 176},
    // 55 seconds
    { -1712, 752, -160},
    { -1304, 1256, 176},
    { -1408, 1200, -392},
    { -1192, 1144, -304},
    { -976, 600, -304},
    { -1336, 672, -240},
    { -1704, 224, -16},
    { -1648, 352, 88},
    { -1392, 160, 112},
    { -1248, 232, 144},
    { -1168, 200, 144},
    { -1112, 112, 176},
    { -1208, 544, 64},
    { -1096, -792, 192},
    { -1080, -472, -208},
    { -1520, -192, 128},
    { -1696, 376, -120},
    { -1480, 520, -240},
    { -1480, 320, 96},
    { -1288, 376, 40},
    { -1216, 400, -24},
    { -1136, 400, 0},
    { -1032, 376, 40},
    { -1048, 376, 104},
    { -1056, 424, 80},
    // 56 seconds
    { -1016, 496, -24},
    { -1224, 600, -16},
    { -1208, 824, -40},
    { -1536, 768, -184},
    { -1160, 880, -272},
    { -800, 808, -440},
    { -1120, 704, -280},
    { -1560, 584, -48},
    { -1856, 472, 160},
    { -1704, 288, 264},
    { -1520, 232, 216},
    { -1384, 168, 136},
    { -1232, 160, 112},
    { -1136, 152, 72},
    { -1024, -32, 80},
    { -872, 112, -80},
    { -904, 120, -112},
    { -1056, 128, -224},
    { -952, 184, -224},
    { -1088, 88, -272},
    { -1312, 40, -88},
    { -1328, -40, 24},
    { -1328, 56, -16},
    { -1432, 280, 40},
    { -1656, 360, 72},
    // 57 seconds
    { -1688, 408, 56},
    { -1376, 720, -88},
    { -1400, 448, -216},
    { -1256, 424, -224},
    { -1648, 640, -264},
    { -1416, 560, -176},
    { -1104, 368, -272},
    { -1272, 384, -120},
    { -1456, 336, 56},
    { -1424, 240, 56},
    { -1264, 144, 96},
    { -1224, 80, 144},
    { -1240, 24, 184},
    { -1288, 48, 192},
    { -1384, 72, 224},
    { -1488, 40, 256},
    { -1112, -392, 208},
    { -1112, -280, 136},
    { -1008, -64, -184},
    { -1264, -48, -96},
    { -1448, -128, 56},
    { -1232, -160, 24},
    { -1024, -24, 8},
    { -1016, 112, 80},
    { -1160, 184, 192},
    // 58 seconds
    { -1304, 344, 56},
    { -1424, 472, -48},
    { -1616, 728, -96},
    { -1320, 736, -136},
    { -1488, 320, -136},
    { -1456, 744, 112},
    { -960, 816, 168},
    { -1192, 608, 240},
    { -1400, 432, 264},
    { -1408, 400, 216},
    { -1128, 352, 120},
    { -1096, 264, 256},
    { -1168, 192, 280},
    { -1232, 216, 296},
    { -1232, 216, 304},
    { -1456, -160, 376},
    { -1232, -552, 248},
    { -1192, -216, 272},
    { -1224, -80, -24},
    { -1248, -208, 40},
    { -1416, 48, -16},
    { -1368, 104, -8},
    { -1216, 152, 16},
    { -1176, 256, 24},
    { -1256, 288, 96},
    // 59 seconds
    { -1408, 344, 216},
    { -1312, 568, -56},
    { -1272, 912, -8},
    { -1000, 528, -128},
    { -1344, 816, -88},
    { -1408, 728, 8},
    { -1184, 520, -80},
    { -1496, 504, -24},
    { -1680, 296, 80},
    { -1536, 232, 80},
    { -1416, 200, 112},
    { -1384, 112, 144},
    { -1384, 80, 152},
    { -1360, 88, 184},
    { -1208, 64, 216},
    { -1232, -56, 208},
    { -1024, -400, 312},
    { -1016, -320, 192},
    { -1216, 88, 48},
    { -1176, 280, -336},
    { -1232, -88, -224},
    { -1472, 0, 56},
    { -1256, -144, -168},
    { -1328, 136, -120},
    { -1440, 296, 72},
    // 60 seconds
    // elapsed: 1 minutes
    { -1480, 392, 104},
    { -1416, 688, -104},
    { -1152, 776, -112},
    { -1232, 232, -152},
    { -1152, 240, -96},
    { -1600, 512, -8},
    { -1304, 464, -40},
    { -1232, 288, -104},
    { -1352, 264, -24},
    { -1512, 304, 48},
    { -1448, 264, 56},
    { -1272, 128, 80},
    { -1232, 24, 184},
    { -1248, -24, 176},
    { -1208, 8, 144},
    { -1240, 48, 184},
    { -1368, 16, 288},
    { -1152, -280, 312},
    { -1248, -8, 136},
    { -1080, -16, -208},
    { -1192, -272, 24},
    { -1384, -224, -32},
    { -1320, -112, -72},
    { -1184, -16, -56},
    { -1120, 32, 8},
    // 61 seconds
    { -1176, 176, 168},
    { -1336, 336, 120},
    { -1464, 512, 72},
    { -1320, 824, -16},
    { -1248, 408, -40},
    { -1176, 192, -40},
    { -1576, 600, -144},
    { -1104, 472, -208},
    { -1336, 320, -112},
    { -1568, 288, -8},
    { -1512, 192, 8},
    { -1336, 184, 24},
    { -1192, 40, 88},
    { -1144, 120, 96},
    { -1232, 80, 96},
    { -1200, 40, 128},
    { -1304, -208, 328},
    { -1152, -176, 200},
    { -1120, -312, 288},
    { -1352, -32, 24},
    { -1368, 16, -168},
    { -1456, -184, 24},
    { -1240, -368, 40},
    { -1136, -112, -80},
    { -1024, 136, -128},
    // 62 seconds
    { -984, 136, 8},
    { -1144, 176, 96},
    { -1272, 232, 40},
    { -1248, 256, -40},
    { -1464, 384, -112},
    { -1312, 976, -168},
    { -1768, 440, -480},
    { -1504, 400, -472},
    { -1312, 440, -304},
    { -1560, 440, 0},
    { -1624, 288, 128},
    { -1384, 72, 56},
    { -1168, 24, 88},
    { -1216, 96, 200},
    { -1288, 128, 232},
    { -1320, 128, 200},
    { -1296, 80, 240},
    { -1160, -352, 400},
    { -832, -224, 208},
    { -1360, -272, 256},
    { -1200, -72, -136},
    { -1448, -80, -400},
    { -1632, -352, -384},
    { -1560, -128, -384},
    { -1424, 144, -272},
    // 63 seconds
    { -1280, 368, -64},
    { -1208, 472, 56},
    { -1184, 728, -144},
    { -1216, 440, -200},
    { -1136, 584, -280},
    { -1104, 672, -320},
    { -1640, 560, -128},
    { -1440, 328, -144},
    { -1128, 304, -112},
    { -1392, 448, -24},
    { -1496, 344, 40},
    { -1328, 240, -80},
    { -1184, 160, -168},
    { -1184, 416, -224},
    { -1392, 104, -96},
    { -1344, 64, -8},
    { -1232, 32, -8},
    { -1112, -24, 32},
    { -1088, -80, 176},
    { -1040, 24, 160},
    { -1056, 224, -48},
    { -1200, 248, -96},
    { -1176, 176, 120},
    { -1072, -16, 272},
    { -992, 48, 72},
    // 64 seconds
    { -1008, 192, 96},
    { -1088, 240, 184},
    { -1328, 400, 184},
    { -1384, 696, -72},
    { -1448, 848, -32},
    { -1400, 816, -56},
    { -1848, 800, -264},
    { -1256, 688, -176},
    { -1056, 624, -232},
    { -1328, 312, -8},
    { -1448, 256, 104},
    { -1184, 208, 88},
    { -984, 144, 104},
    { -936, 128, 104},
    { -968, 120, 144},
    { -1072, 120, 80},
    { -1344, 56, 216},
    { -1440, -440, 472},
    { -1384, -96, 232},
    { -1256, 280, -200},
    { -1104, 184, -192},
    { -1136, 112, 48},
    { -936, -208, -104},
    { -896, -192, -184},
    { -816, 104, -128},
    // 65 seconds
    { -896, 232, -248},
    { -1040, 216, -112},
    { -1232, 280, -88},
    { -1272, 584, -40},
    { -1200, 1320, -40},
    { -1392, 584, -136},
    { -1720, 984, 96},
    { -1240, 728, -128},
    { -1448, 704, -48},
    { -1624, 608, 216},
    { -1528, 552, 152},
    { -1208, 328, 192},
    { -1072, 280, 208},
    { -1056, 240, 232},
    { -1008, 120, 288},
    { -768, 0, 328},
    { -992, 176, -88},
    { -680, 512, 288},
    { -728, 776, 432},
    { -352, 1040, 416},
    { -120, 1224, 408},
    { -112, 1120, 416},
    { -120, 952, 424},
    { 64, 696, 280},
    { 200, 544, 208},
    // 66 seconds
    { 440, 424, 96},
    { 416, 368, 448},
    { 304, 256, 256},
    { 400, 464, 248},
    { 424, 544, 432},
    { 440, 904, 616},
    { 776, 1480, 816},
    { 680, 1616, 656},
    { 568, 992, 392},
    { 416, 928, 296},
    { 120, 712, 128},
    { 224, 320, -24},
    { 64, 264, -184},
    { 8, 264, -120},
    { -104, 0, -40},
    { -200, -112, -64},
    { -296, -152, -8},
    { -664, -56, 32},
    { -1424, 360, 48},
    { -2168, 216, 384},
    { -3072, 344, 400},
    { -2832, 656, -536},
    { -1904, 256, 120},
    { -1664, -248, -24},
    { -1344, 16, 160},
    // 67 seconds
    { -1120, 368, 192},
    { -896, 456, 80},
    { -792, 336, 24},
    { -864, 336, 80},
    { -888, 392, 184},
    { -1120, 640, 240},
    { -1024, 1768, 208},
    { -1576, 104, 96},
    { -1208, 96, -128},
    { -1488, 288, -24},
    { -1976, 424, 104},
    { -1992, 248, 96},
    { -1712, 96, 48},
    { -1584, 72, 152},
    { -1512, 56, 200},
    { -1416, 144, 184},
    { -1336, 128, 192},
    { -1232, 112, 224},
    { -1216, -88, 280},
    { -896, -360, 312},
    { -1056, -136, 128},
    { -1008, 264, -240},
    { -1048, 120, -8},
    { -1160, 72, -16},
    { -1296, -88, -88},
    // 68 seconds
    { -1360, -32, 32},
    { -1536, 208, 240},
    { -1720, 376, 344},
    { -1752, 624, 184},
    { -1400, 656, -56},
    { -1456, 208, -128},
    { -1352, 312, 24},
    { -1128, 464, 104},
    { -1368, 928, 48},
    { -984, 616, -32},
    { -1112, 528, 104},
    { -1400, 488, 168},
    { -1424, 384, 144},
    { -1296, 256, 144},
    { -1352, 80, 168},
    { -1472, -88, 248},
    { -1440, -104, 176},
    { -1304, 0, 152},
    { -1312, 208, 72},
    { -1304, 0, 168},
    { -1232, -256, 32},
    { -1128, 0, -128},
    { -1000, 8, -216},
    { -1320, 0, 0},
    { -1224, -48, 16},
    // 69 seconds
    { -1040, -64, -64},
    { -896, 80, -96},
    { -864, 136, 24},
    { -1008, 168, 176},
    { -1248, 208, 384},
    { -1352, 448, 192},
    { -1400, 1200, 176},
    { -1112, 176, -152},
    { -1688, 520, -24},
    { -1536, 656, 104},
    { -1200, 784, -64},
    { -1448, 600, 24},
    { -1472, 400, 72},
    { -1160, 232, 96},
    { -984, 104, 152},
    { -1032, 64, 184},
    { -1088, 72, 176},
    { -1088, 72, 184},
    { -1120, 104, 160},
    { -1224, -208, 312},
    { -1040, -160, 232},
    { -1256, -64, 168},
    { -1096, 184, -120},
    { -1248, 232, -120},
    { -1448, 64, 104},
    // 70 seconds
    { -1320, -56, 80},
    { -1040, -104, -16},
    { -912, 96, -72},
    { -976, 216, -8},
    { -1104, 320, -16},
    { -1168, 392, -80},
    { -1280, 448, -144},
    { -1552, 736, -200},
    { -1712, 256, 8},
    { -1736, -248, 72},
    { -1184, -64, -168},
    { -1232, 168, -16},
    { -1400, 288, 232},
    { -1400, 232, 312},
    { -1136, 144, 168},
    { -960, -16, 72},
    { -904, -88, 80},
    { -1008, 136, 160},
    { -1096, 144, 184},
    { -1496, -112, 408},
    { -1000, -392, 280},
    { -1152, -264, 304},
    { -1232, 8, -16},
    { -1280, 8, -88},
    { -1368, -104, -128},
    // 71 seconds
    { -1168, -176, -152},
    { -1016, -128, -264},
    { -976, -16, -192},
    { -960, 104, -32},
    { -1112, 224, -8},
    { -1328, 312, -80},
    { -1344, 344, -64},
    { -1368, 616, -168},
    { -1168, 176, -48},
    { -1768, 136, 64},
    { -1168, 224, -136},
    { -1272, 312, -104},
    { -1448, 352, 16},
    { -1352, 216, 24},
    { -1120, 88, 16},
    { -1040, -32, 104},
    { -1072, -56, 168},
    { -1136, -24, 136},
    { -1232, 72, 112},
    { -1304, 88, 208},
    { -1208, -112, 256},
    { -1136, -168, 184},
    { -1216, -56, 80},
    { -984, 200, -152},
    { -1064, 160, -152},
    // 72 seconds
    { -1160, -32, -104},
    { -1064, -104, -168},
    { -960, 8, -160},
    { -952, 144, -32},
    { -1120, 272, 16},
    { -1320, 360, -40},
    { -1208, 464, -136},
    { -1224, 664, -192},
    { -1200, 152, -48},
    { -1640, 144, 24},
    { -1408, 288, -56},
    { -1144, 304, -56},
    { -1336, 336, 40},
    { -1440, 344, 48},
    { -1088, 240, -24},
    { -840, 120, 0},
    { -816, -120, 384},
    { -808, -128, 192},
    { -1024, 24, 88},
    { -1240, 56, 152},
    { -1456, 40, 192},
    { -1336, -120, 328},
    { -1408, 88, 80},
    { -1104, 136, -408},
    { -1296, -120, -112},
    // 73 seconds
    { -1208, -296, 96},
    { -1064, -296, 64},
    { -960, 32, 40},
    { -808, 152, 88},
    { -872, 176, 256},
    { -1016, 216, 208},
    { -1136, 344, 72},
    { -1224, 464, 16},
    { -1424, 624, 40},
    { -1424, 880, 40},
    { -1648, -16, -40},
    { -1072, 0, -192},
    { -1344, 328, -72},
    { -1552, 344, 128},
    { -1400, 392, -16},
    { -1216, 336, -24},
    { -1104, 32, -24},
    { -952, 80, -112},
    { -888, 192, 24},
    { -896, 184, 144},
    { -968, 96, 280},
    { -1128, -112, 408},
    { -1144, -112, 368},
    { -1320, 104, 128},
    { -1408, 360, -248},
    // 74 seconds
    { -1288, 488, -248},
    { -1160, -32, 40},
    { -1120, -328, -128},
    { -1072, 0, -248},
    { -912, 152, -160},
    { -904, 272, -56},
    { -1016, 312, -104},
    { -1056, 320, -136},
    { -1088, 352, -104},
    { -1272, 584, -64},
    { -1208, 168, -72},
    { -1616, 280, -48},
    { -1376, 336, -32},
    { -1064, 288, -152},
    { -1192, 296, -104},
    { -1392, 264, -40},
    { -1296, 112, -56},
    { -1048, 56, -24},
    { -960, 56, 24},
    { -976, 88, 40},
    { -1000, 104, 72},
    { -1048, 104, 112},
    { -1136, 112, 168},
    { -1184, 8, 168},
    { -1112, -48, 64},
    // 75 seconds
    { -1240, 40, 24},
    { -1144, 152, -256},
    { -1128, 80, -216},
    { -1248, -16, -248},
    { -1200, -40, -256},
    { -1040, 32, -224},
    { -904, 112, -112},
    { -880, 160, -64},
    { -1032, 264, -80},
    { -1056, 296, -96},
    { -1008, 224, -128},
    { -1112, 344, -160},
    { -1136, 328, -80},
    { -1488, 384, -104},
    { -1528, 360, -72},
    { -1096, 296, -152},
    { -1264, 280, -96},
    { -1416, 208, -40},
    { -1440, 168, -24},
    { -1280, 112, -8},
    { -1072, 48, 32},
    { -976, 104, 16},
    { -944, 136, 24},
    { -840, 144, 48},
    { -816, 112, 272},
    // 76 seconds
    { -840, -112, 128},
    { -816, 0, -16},
    { -960, 64, -104},
    { -1440, 80, 64},
    { -1416, 256, -192},
    { -1440, 464, -400},
    { -1352, 176, -80},
    { -1272, 80, -64},
    { -1016, 232, 24},
    { -912, 320, 8},
    { -1008, 336, -16},
    { -1072, 296, -32},
    { -968, 368, -112},
    { -912, 360, -72},
    { -1000, 608, -96},
    { -992, 472, -96},
    { -1728, 352, 8},
    { -1280, 288, 40},
    { -1504, 384, 48},
    { -1664, 288, 40},
    { -1312, 216, -32},
    { -1104, 176, -8},
    { -1160, 152, 56},
    { -1136, 72, 128},
    { -1016, 72, 56},
    // 77 seconds
    { -968, 88, 64},
    { -1064, -32, 200},
    { -1032, -248, 288},
    { -912, -128, 208},
    { -1280, 200, -112},
    { -1248, 384, -328},
    { -1400, 160, 40},
    { -1384, -128, 104},
    { -1296, 40, 48},
    { -1160, 256, 0},
    { -1008, 352, 104},
    { -1064, 384, 32},
    { -1152, 432, -48},
    { -1048, 408, -104},
    { -1072, 424, -128},
    { -1120, 648, -88},
    { -1200, 248, -96},
    { -1464, 392, -120},
    { -1216, 416, -80},
    { -1504, 440, -8},
    { -1664, 304, 16},
    { -1352, 176, -56},
    { -1176, 104, -16},
    { -1192, 72, 96},
    { -1192, 104, 120},
    // 78 seconds
    { -1064, 112, 96},
    { -976, 104, 96},
    { -1112, 56, 184},
    { -1120, -80, 176},
    { -1144, -32, 152},
    { -1096, 160, -104},
    { -1080, 216, -240},
    { -1256, 184, -224},
    { -1264, -88, -80},
    { -1176, -136, -88},
    { -1104, 88, -112},
    { -1032, 208, -40},
    { -1128, 320, -24},
    { -1272, 432, -136},
    { -1256, 472, -120},
    { -1432, 912, -280},
    { -1168, 216, -112},
    { -1608, 440, -136},
    { -1144, 448, -232},
    { -1160, 496, -232},
    { -1280, 424, -48},
    { -1304, 304, 16},
    { -1088, 240, 24},
    { -960, 160, 64},
    { -1016, 144, 104},
    // 79 seconds
    { -1136, 128, 112},
    { -1248, 112, 64},
    { -1512, 72, 56},
    { -1400, -192, 408},
    { -1272, -88, 160},
    { -1256, 192, -184},
    { -944, 376, -600},
    { -1080, 288, -416},
    { -1112, -328, 80},
    { -1104, -304, 24},
    { -1000, 184, -136},
    { -856, 288, -80},
    { -880, 264, -80},
    { -1096, 296, -88},
    { -1136, 336, -72},
    { -1448, 880, -72},
    { -1048, 736, -8},
    { -1872, 792, -112},
    { -1216, 608, -48},
    { -1048, 544, -152},
    { -1320, 448, 48},
    { -1384, 272, 128},
    { -1064, 280, 0},
    { -960, 232, 16},
    { -1048, 192, 80},
    // 80 seconds
    { -1080, 176, 96},
    { -1080, 104, 88},
    { -1176, 112, 176},
    { -1216, 168, 216},
    { -1296, 496, 368},
    { -1176, 840, 352},
    { -584, 1112, 64},
    { -720, 832, 152},
    { -624, 768, 80},
    { -368, 696, -32},
    { -144, 584, 0},
    { -48, 456, 96},
    { 40, 512, 208},
    { 104, 408, 296},
    { -176, 632, 576},
    { -72, 800, 520},
    { -128, 1032, 600},
    { -392, 1216, 712},
    { -344, 1344, 688},
    { -176, 976, 448},
    { -200, 984, 360},
    { -248, 912, 392},
    { -216, 816, 232},
    { -176, 576, 144},
    { -176, 376, 80},
    // 81 seconds
    { -200, 368, 0},
    { -256, 304, 8},
    { -432, 336, 264},
    { -936, 1408, 464},
    { -904, 1664, 616},
    { -472, 1824, 792},
    { 160, 1880, 312},
    { 280, 1656, 360},
    { -240, 1648, 424},
    { -184, 1200, 344},
    { -160, 936, 296},
    { -48, 520, 352},
    { 240, 240, 272},
    { 528, 48, 48},
    { 720, -24, -136},
    { 736, -280, -216},
    { 616, -240, -344},
    { 752, -512, -624},
    { 600, -544, -688},
    { 600, -664, -872},
    { 400, -544, -744},
    { 184, -568, -648},
    { 104, -576, -656},
    { 48, -432, -400},
    { -40, -368, -256},
    // 82 seconds
    { -248, -560, -224},
    { -352, -752, -384},
    { -56, -624, -288},
    { 104, -480, -800},
    { 368, -512, -1288},
    { 160, -1272, -1496},
    { 520, -808, -1304},
    { 768, -72, -1104},
    { 376, -328, -728},
    { 144, -224, -960},
    { 232, -224, -784},
    { 216, -240, -552},
    { 192, -16, -536},
    { -8, -456, -744},
    { -24, -480, -680},
    { 256, -336, -752},
    { 176, -288, -1040},
    { 528, -400, -1112},
    { 848, -224, -1488},
    { 1000, -192, -1256},
    { 880, -224, -1040},
    { 672, -192, -608},
    { 472, -232, -632},
    { 272, -240, -704},
    { 232, -208, -608},
    // 83 seconds
    { 288, -296, -384},
    { 288, -240, -472},
    { 448, -160, -536},
    { 632, -40, -1008},
    { 896, -312, -1208},
    { 992, -176, -1528},
    { 808, -520, -1240},
    { 752, -280, -896},
    { 400, 40, -728},
    { 64, -8, -688},
    { 24, 8, -536},
    { 136, -88, -504},
    { 160, -48, -696},
    { 144, 48, -680},
    { 264, 8, -656},
    { 208, -56, -792},
    { 128, -280, -800},
    { 176, -48, -904},
    { 104, 136, -824},
    { 200, 48, -720},
    { 344, 136, -272},
    { 600, 528, 272},
    { 576, 1424, -32},
    { 544, 912, 304},
    { 408, 792, -160},
    // 84 seconds
    { 232, 888, -312},
    { 128, 664, -264},
    { -184, 792, -360},
    { -264, 304, -248},
    { -720, 280, -152},
    { -952, 560, -328},
    { -1456, 528, -384},
    { -1672, 568, -240},
    { -2136, 616, -776},
    { -1696, 568, -1032},
    { -1336, -24, -616},
    { -1216, -88, -664},
    { -904, -48, -408},
    { -584, 0, -424},
    { -440, 8, -352},
    { -472, 152, -400},
    { -448, 24, -520},
    { -512, 176, -712},
    { -600, 224, -912},
    { -784, 224, -1072},
    { -976, 296, -1216},
    { -1008, 424, -1312},
    { -912, 296, -1152},
    { -736, 288, -992},
    { -648, 160, -848},
    // 85 seconds
    { -512, 112, -704},
    { -400, 0, -584},
    { -352, -80, -488},
    { -296, -128, -504},
    { -288, -184, -568},
    { -288, -248, -640},
    { -392, -272, -856},
    { -512, -384, -880},
    { -520, -320, -1216},
    { -552, -352, -1264},
    { -568, -304, -1248},
    { -592, -296, -1024},
    { -512, -328, -824},
    { -400, -344, -640},
    { -328, -376, -520},
    { -240, -384, -488},
    { -200, -400, -424},
    { -176, -328, -528},
    { -168, -312, -656},
    { -192, -248, -920},
    { -320, -184, -1120},
    { -264, -128, -1240},
    { -392, -128, -1456},
    { -440, 104, -1272},
    { -360, 64, -1408},
    // 86 seconds
    { -400, 256, -1352},
    { -432, 248, -1192},
    { -352, 24, -872},
    { -296, 208, -680},
    { -192, 32, -584},
    { -192, 8, -504},
    { -248, 40, -488},
    { -296, -16, -416},
    { -432, -112, -320},
    { -744, 120, -280},
    { -1056, 216, -296},
    { -1368, 400, -352},
    { -1432, 392, -344},
    { -1632, 240, -184},
    { -1776, 288, -72},
    { -1504, 280, -32},
    { -1176, 312, -96},
    { -1016, 328, -72},
    { -1000, 280, -40},
    { -992, 240, -40},
    { -864, 256, -96},
    { -896, 296, -136},
    { -1176, 368, -96},
    { -1328, 336, -80},
    { -1632, 456, -208},
    // 87 seconds
    { -1296, 352, -208},
    { -1080, 152, -240},
    { -1456, 224, -304},
    { -1528, 128, -216},
    { -1448, 48, -160},
    { -1256, 64, -64},
    { -1064, 88, 8},
    { -944, 256, 48},
    { -888, 256, 152},
    { -720, 216, 248},
    { -632, 288, 256},
    { -672, 352, 352},
    { -616, 400, 416},
    { -368, 504, 368},
    { -320, 672, 568},
    { -192, 1024, 872},
    { 0, 1080, 560},
    { -112, 864, 752},
    { -160, 856, 704},
    { -120, 680, 504},
    { -72, 416, 384},
    { -48, 400, 344},
    { -8, 392, 256},
    { 32, 344, 264},
    { 72, 368, 344},
    // 88 seconds
    { 0, 696, 528},
    { -120, 808, 904},
    { -360, 1376, 1408},
    { -400, 1376, 1072},
    { -232, 944, 880},
    { -240, 1112, 704},
    { -216, 968, 392},
    { -200, 656, 136},
    { -184, 440, -24},
    { -176, 328, -56},
    { -176, 200, -72},
    { -248, 136, -88},
    { -600, 480, -48},
    { -880, 528, 80},
    { -944, 128, 264},
    { -1640, 160, 176},
    { -1840, 488, 32},
    { -2104, 432, -456},
    { -1808, 456, -160},
    { -1392, 80, -48},
    { -1008, -32, 16},
    { -904, 152, 64},
    { -816, 408, -40},
    { -832, 408, -40},
    { -840, 360, -64},
    // 89 seconds
    { -1048, 248, 0},
    { -1256, 432, 176},
    { -1824, 872, 80},
    { -1208, 288, -152},
    { -1160, 392, -192},
    { -1640, 608, 56},
    { -1648, 176, -56},
    { -1280, 80, -200},
    { -1160, 168, -248},
    { -1240, 192, -176},
    { -1256, 152, -104},
    { -1216, 152, -72},
    { -1216, 80, 16},
    { -1312, -16, 144},
    { -1072, -128, 216},
    { -1304, 0, 80},
    { -1096, 40, -80},
    { -1112, 8, -272},
    { -1200, 152, -368},
    { -1064, -8, -312},
    { -888, -160, -256},
    { -936, -32, -224},
    { -1040, 144, -224},
    { -1240, 200, -176},
    { -1432, 360, -208},
    // 90 seconds
    { -1376, 952, -304},
    { -1128, 272, -432},
    { -1216, 408, -528},
    { -1664, 600, -272},
    { -1376, 520, -88},
    { -1184, 264, -120},
    { -1248, 248, -80},
    { -1264, 304, -8},
    { -1128, 264, -8},
    { -1064, 200, 32},
    { -1072, 128, 56},
    { -1128, 184, 152},
    { -1184, 152, 56},
    { -1144, 112, 80},
    { -1136, 88, 136},
    { -984, 112, 24},
    { -1088, 104, -48},
    { -1104, 176, -384},
    { -960, 112, -344},
    { -1152, -112, -304},
    { -1392, 72, -272},
    { -1360, 96, -32},
    { -1192, 240, 40},
    { -1000, 304, 160},
    { -1048, 352, 128},
    // 91 seconds
    { -1112, 392, 64},
    { -1032, 328, 80},
    { -1104, 368, 64},
    { -1160, 600, 120},
    { -1376, 440, 200},
    { -1504, 272, 160},
    { -1048, 408, -8},
    { -1112, 496, -72},
    { -1208, 640, 0},
    { -1192, 536, 24},
    { -984, 176, 8},
    { -1008, 88, 32},
    { -1128, 144, 80},
    { -1208, 136, 104},
    { -1192, 144, 72},
    { -1312, 128, 96},
    { -1536, -128, 136},
    { -1392, -256, 176},
    { -1280, -120, 72},
    { -1088, 56, -232},
    { -1152, 96, -152},
    { -1184, 0, 24},
    { -1112, -40, 80},
    { -976, 0, 0},
    { -888, 120, 0},
    // 92 seconds
    { -904, 200, 48},
    { -1112, 296, 16},
    { -1312, 408, -104},
    { -1136, 400, -144},
    { -1328, 656, -120},
    { -1168, 904, -176},
    { -1720, 72, -192},
    { -1232, 280, -232},
    { -1288, 544, -128},
    { -1440, 424, 40},
    { -1384, 264, -8},
    { -1176, 112, -24},
    { -1112, -16, 48},
    { -1160, -72, 112},
    { -1072, -24, 152},
    { -1008, 48, 112},
    { -952, 104, 120},
    { -1080, 104, 216},
    { -1048, 56, 104},
    { -1304, 120, -40},
    { -1376, 392, -344},
    { -1024, -96, -408},
    { -1056, -488, -304},
    { -1224, -448, -184},
    { -1208, -72, -104},
    // 93 seconds
    { -1096, 136, 48},
    { -1048, 328, 72},
    { -1128, 392, 40},
    { -1240, 344, -56},
    { -1272, 464, -32},
    { -1288, 520, -80},
    { -1232, 184, 72},
    { -1648, 336, 48},
    { -1264, 408, -152},
    { -1040, 408, -256},
    { -1344, 480, -48},
    { -1552, 352, 136},
    { -1416, 184, 72},
    { -1184, 32, 56},
    { -1120, -88, 136},
    { -1120, -104, 184},
    { -1112, 96, 104},
    { -1152, 120, 64},
    { -1264, -152, 248},
    { -1152, -160, 112},
    { -1240, -104, 88},
    { -1144, 64, -264},
    { -1208, 80, -304},
    { -1328, -128, -32},
    { -1208, -240, -24},
    // 94 seconds
    { -1096, -32, -88},
    { -936, 160, -40},
    { -864, 248, 56},
    { -984, 360, -8},
    { -1176, 440, -72},
    { -1232, 392, -88},
    { -1408, 904, -216},
    { -1152, -72, -88},
    { -1776, 168, -192},
    { -1352, 448, -208},
    { -1120, 464, -176},
    { -1360, 376, 40},
    { -1432, 208, 104},
    { -1200, 96, 48},
    { -1056, 56, 64},
    { -1048, 72, 104},
    { -1088, 128, 168},
    { -1088, 120, 88},
    { -1144, 184, 216},
    { -1368, -48, 328},
    { -1072, -192, 152},
    { -1288, -104, 80},
    { -1176, 168, -216},
    { -1080, 168, -232},
    { -1248, 8, -136},
    // 95 seconds
    { -1224, -200, -40},
    { -1120, -88, 32},
    { -976, 176, 72},
    { -968, 336, 48},
    { -1088, 448, -56},
    { -1160, 408, -16},
    { -1104, 440, -96},
    { -1112, 648, -208},
    { -1096, 192, -104},
    { -1840, 272, -16},
    { -1448, 408, -112},
    { -1104, 352, -224},
    { -1312, 304, -144},
    { -1424, 256, -72},
    { -1336, 200, -48},
    { -1208, 120, 32},
    { -1152, 72, 104},
    { -1096, 32, 120},
    { -1008, 16, 104},
    { -1008, 88, 120},
    { -1128, 56, 128},
    { -1024, -72, 40},
    { -1016, -96, 136},
    { -1144, 248, 8},
    { -1176, 248, -400},
    // 96 seconds
    { -1328, -64, -152},
    { -1544, -200, -32},
    { -1408, 32, -40},
    { -1128, 272, -80},
    { -928, 384, -48},
    { -888, 312, -8},
    { -984, 328, 32},
    { -928, 320, -104},
    { -1048, 368, -104},
    { -1216, 576, -168},
    { -1064, 784, -120},
    { -1696, 152, -64},
    { -1232, 312, -248},
    { -1336, 440, -264},
    { -1424, 304, -136},
    { -1472, 200, -80},
    { -1344, 128, -24},
    { -1184, 304, 56},
    { -1160, 200, 176},
    { -1128, 152, 184},
    { -1024, 160, 160},
    { -944, 136, 176},
    { -960, 104, 216},
    { -832, 168, 176},
    { -960, -112, -64},
    // 97 seconds
    { -1248, 408, -312},
    { -1328, 336, -288},
    { -1592, 480, -520},
    { -1408, 80, -112},
    { -1104, 248, -96},
    { -912, 240, -56},
    { -864, 360, -8},
    { -920, 272, 40},
    { -968, 328, 72},
    { -984, 408, -16},
    { -968, 496, 8},
    { -1128, 824, 48},
    { -864, 592, 128},
    { -1448, 864, -8},
    { -1224, 568, 32},
    { -968, 576, -48},
    { -1312, 568, 16},
    { -1488, 488, 56},
    { -1320, 472, 24},
    { -1240, 424, 64},
    { -1272, 344, 168},
    { -1192, 464, 152},
    { -1048, 312, 240},
    { -808, 456, 128},
    { -744, 536, 112},
    // 98 seconds
    { -608, 512, 96},
    { -496, 616, 88},
    { -600, 824, 176},
    { -376, 1032, 232},
    { -280, 1336, 64},
    { -152, 1056, 128},
    { -312, 792, 128},
    { -168, 632, 136},
    { 40, 600, 48},
    { 136, 560, 56},
    { 192, 576, 80},
    { 232, 744, 128},
    { 360, 800, 80},
    { 344, 1096, 216},
    { 440, 1256, 344},
    { 448, 1520, 184},
    { 736, 1152, 264},
    { 712, 1344, 24},
    { 744, 992, 64},
    { 536, 456, -248},
    { 504, 16, -288},
    { 480, 0, -320},
    { 376, -40, -232},
    { 360, 32, -248},
    { 328, -88, -368},
    // 99 seconds
    { 288, -144, -416},
    { 448, -136, -552},
    { 560, -280, -704},
    { 896, -80, -752},
    { 832, 40, -1096},
    { 904, -352, -1000},
    { 704, -208, -1072},
    { 488, -32, -824},
    { 352, -16, -704},
    { 376, -32, -632},
    { 416, -104, -616},
    { 464, -152, -624},
    { 408, -320, -616},
    { 432, -288, -568},
    { 384, -376, -648},
    { 384, -456, -648},
    { 520, -424, -688},
    { 640, -440, -704},
    { 624, -552, -880},
    { 752, -736, -936},
    { 760, -864, -664},
    { 752, -824, -448},
    { 736, -528, -416},
    { 672, -384, -480},
    { 536, -472, -480},
    // 100 seconds
    { 440, -552, -520},
    { 416, -512, -472},
    { 560, -504, -400},
    { 576, -528, -400},
    { 640, -672, -584},
    { 600, -800, -600},
    { 608, -888, -480},
    { 632, -984, -512},
    { 680, -976, -616},
    { 552, -920, -552},
    { 288, -840, -568},
    { 224, -696, -576},
    { 264, -632, -552},
    { 280, -600, -464},
    { 288, -664, -336},
    { 288, -584, -336},
    { 344, -600, -344},
    { 360, -568, -448},
    { 360, -672, -504},
    { 368, -600, -744},
    { 456, -1016, -608},
    { 656, -1016, -664},
    { 752, -808, -960},
    { 752, -896, -696},
    { 744, -624, -536},
    // 101 seconds
    { 680, -592, -520},
    { 600, -688, -432},
    { 424, -776, -416},
    { 328, -632, -336},
    { 360, -600, -216},
    { 376, -472, -400},
    { 384, -528, -560},
    { 368, -616, -576},
    { 568, -544, -520},
    { 792, -576, -856},
    { 552, -568, -920},
    { 360, -368, -1024},
    { 152, 40, -1016},
    { 72, 96, -704},
    { 128, 104, -544},
    { 136, 40, -408},
    { 136, 80, -320},
    { 0, -16, -72},
    { -208, -24, 96},
    { -304, 360, 24},
    { -400, 712, 576},
    { -416, 1640, 368},
    { -784, 1360, 936},
    { -1000, 1840, 1264},
    { -1096, 1808, 1304},
    // 102 seconds
    { -816, 1688, 968},
    { -488, 1480, 888},
    { -304, 920, 576},
    { -448, 920, 720},
    { -456, 776, 512},
    { -480, 576, 432},
    { -440, 520, 312},
    { -416, 376, 288},
    { -424, 320, 232},
    { -416, 328, 32},
    { -496, 472, 8},
    { -640, 88, 192},
    { -856, 64, 80},
    { -1296, 24, 144},
    { -1816, 264, 24},
    { -2168, 912, -752},
    { -1608, 560, 256},
    { -1224, 640, -272},
    { -992, 368, -112},
    { -800, 280, 8},
    { -680, 240, 80},
    { -688, 232, 80},
    { -752, 256, 152},
    { -704, 408, 144},
    { -928, 480, 192},
    // 103 seconds
    { -1224, 552, 376},
    { -1688, 760, 568},
    { -1376, 744, 200},
    { -1064, 280, -128},
    { -1176, 376, 8},
    { -1392, 384, 144},
    { -1288, 416, 128},
    { -1064, 232, 120},
    { -936, 264, 248},
    { -936, 360, 288},
    { -880, 400, 384},
    { -808, 440, 280},
    { -816, 416, 480},
    { -768, 528, 432},
    { -504, 520, 480},
    { -552, 624, 472},
    { -240, 904, 680},
    { -160, 1024, 464},
    { -288, 784, 656},
    { -328, 680, 592},
    { -256, 536, 456},
    { -176, 360, 392},
    { -96, 304, 320},
    { -112, 272, 376},
    { -104, 384, 400},
    // 104 seconds
    { -88, 504, 640},
    { -112, 760, 656},
    { -192, 896, 920},
    { -280, 1136, 1024},
    { -344, 1424, 1200},
    { -168, 1224, 776},
    { -128, 808, 712},
    { -96, 776, 640},
    { -128, 728, 584},
    { -176, 624, 568},
    { -168, 512, 424},
    { -184, 440, 336},
    { -216, 376, 288},
    { -280, 264, 216},
    { -496, 216, 192},
    { -848, 216, 304},
    { -1048, 88, 360},
    { -1608, 40, 368},
    { -2120, 608, 232},
    { -1824, 808, 0},
    { -1472, 336, 72},
    { -1208, 272, -72},
    { -1032, -48, -8},
    { -920, 144, 96},
    { -832, 272, 128},
    // 105 seconds
    { -784, 296, 56},
    { -776, 320, -8},
    { -672, 344, -64},
    { -1048, 408, -48},
    { -1304, 552, 40},
    { -1624, 632, 40},
    { -1480, -48, -184},
    { -1088, 128, -256},
    { -1216, 648, -200},
    { -1488, 728, -72},
    { -1504, 352, 56},
    { -1184, 72, 152},
    { -1048, 40, 144},
    { -1008, 40, 144},
    { -1000, 112, 128},
    { -944, 64, 136},
    { -896, 40, 208},
    { -1008, 72, 216},
    { -1000, 160, -136},
    { -1168, 88, -168},
    { -1064, 128, -136},
    { -1064, 8, -224},
    { -1424, 136, -464},
    { -1496, 200, -288},
    { -1264, 112, -232},
    // 106 seconds
    { -992, 232, -40},
    { -928, 360, -160},
    { -1016, 320, 0},
    { -1032, 272, 56},
    { -1096, 264, 16},
    { -1208, 272, 8},
    { -1144, 424, 96},
    { -1496, 592, 128},
    { -1296, 432, 80},
    { -952, 488, -120},
    { -1192, 512, -104},
    { -1376, 480, -40},
    { -1216, 176, -48},
    { -976, -24, -72},
    { -1000, 96, -48},
    { -1112, 104, -8},
    { -1168, 112, 24},
    { -1256, 152, 8},
    { -1264, 16, 80},
    { -1120, -16, -40},
    { -1232, 0, -32},
    { -1080, 72, -184},
    { -848, 80, -512},
    { -1064, -32, -352},
    { -1256, -128, -184},
    // 107 seconds
    { -1224, -72, -112},
    { -1024, 88, -136},
    { -984, 160, -120},
    { -992, 104, 136},
    { -1144, 200, 176},
    { -1152, 352, 72},
    { -952, 352, 48},
    { -1168, 496, 64},
    { -1152, 824, -24},
    { -1496, 256, 48},
    { -1344, 232, -32},
    { -1168, 392, -144},
    { -1200, 464, -64},
    { -1384, 440, 16},
    { -1432, 264, 8},
    { -1248, 224, 40},
    { -1296, 240, 112},
    { -1280, 288, 184},
    { -1192, 400, 168},
    { -1040, 344, 112},
    { -952, 776, 120},
    { -1160, 1056, -40},
    { -752, 224, 120},
    { -720, 864, -664},
    { -392, 384, -592},
    // 108 seconds
    { -336, 512, -952},
    { -320, 64, -808},
    { -496, 88, -888},
    { -472, -32, -792},
    { -328, -248, -880},
    { -232, -224, -768},
    { -216, -240, -840},
    { -160, -288, -816},
    { -248, -192, -920},
    { -256, -256, -896},
    { -224, -200, -1040},
    { -176, -360, -944},
    { -232, -480, -936},
    { -240, -528, -872},
    { -256, -576, -792},
    { -304, -560, -816},
    { -288, -544, -768},
    { -264, -496, -856},
    { -280, -592, -808},
    { -344, -304, -872},
    { -248, -464, -760},
    { -208, -360, -864},
    { -288, 104, -936},
    { -104, -168, -976},
    { -96, 24, -1088},
    // 109 seconds
    { -56, 200, -1136},
    { 24, 192, -952},
    { 24, 216, -960},
    { 8, 256, -784},
    { 56, 256, -784},
    { 40, 480, -672},
    { 48, 576, -624},
    { 8, 992, -680},
    { 72, 792, -392},
    { -136, 944, -576},
    { 24, 744, -464},
    { 32, 856, -336},
    { 104, 696, -152},
    { 32, 888, -144},
    { 88, 840, -272},
    { 64, 896, -280},
    { 8, 1128, -288},
    { -48, 872, -296},
    { -16, 872, -296},
    { 0, 832, -432},
    { -24, 792, -528},
    { -192, 640, -608},
    { -312, 392, -808},
    { -344, 40, -872},
    { -392, 264, -1032},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 17:29:13 local
AccelRawData *activity_sample_walk_200_pbl_28396_11(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_28396_11
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 180
  //> TEST_EXPECTED_MAX 220
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 88, 912, 128},
    { 64, 944, -24},
    { 224, 904, -96},
    { 0, 960, -112},
    { 112, 896, -152},
    { 24, 1064, 16},
    { 144, 776, 56},
    { 136, 848, -152},
    { 152, 960, -176},
    { 128, 784, -280},
    { 136, 936, -320},
    { 80, 832, -304},
    { -24, 744, -528},
    { -64, 592, -616},
    { -144, 560, -760},
    { -208, 304, -832},
    { -296, 96, -944},
    { -328, -80, -984},
    { -392, -24, -1064},
    { -384, -200, -968},
    { -352, -184, -1016},
    { -304, -240, -896},
    { -288, -248, -944},
    { -104, -248, -1040},
    { -288, -176, -928},
    // 1 seconds
    { -320, -304, -952},
    { -272, -216, -936},
    { -224, -224, -976},
    { -264, -248, -936},
    { -336, -256, -912},
    { -304, -248, -1056},
    { -376, -160, -1088},
    { -112, -200, -1096},
    { 40, -48, -872},
    { -176, -168, -992},
    { -152, -120, -992},
    { -176, -128, -1024},
    { -136, -88, -1008},
    { -104, -56, -1024},
    { -56, 40, -1016},
    { -40, -8, -976},
    { -32, 8, -1008},
    { -24, -56, -984},
    { -8, -56, -968},
    { -8, -56, -976},
    { 8, -72, -960},
    { 16, -32, -960},
    { 24, -24, -944},
    { 24, 160, -896},
    { 40, 184, -904},
    // 2 seconds
    { 64, 72, -912},
    { 96, 72, -1048},
    { 120, 40, -936},
    { 128, 80, -856},
    { 112, 32, -848},
    { 80, -8, -824},
    { 32, -104, -664},
    { -48, 144, -640},
    { -304, 536, -528},
    { -512, 944, -64},
    { -520, 1264, 480},
    { -344, 1072, 256},
    { -256, 768, 296},
    { -224, 672, 232},
    { -280, 560, 224},
    { -392, 680, 256},
    { -584, 728, 280},
    { -792, 552, 72},
    { -936, 648, 0},
    { -1000, 488, 72},
    { -1256, 544, 24},
    { -1376, 632, 56},
    { -1232, 584, 104},
    { -1176, 696, -192},
    { -1072, 584, -32},
    // 3 seconds
    { -1040, 416, -64},
    { -1264, 536, -176},
    { -1512, 648, -88},
    { -1296, 528, -168},
    { -960, 360, -296},
    { -1120, 392, -136},
    { -1352, 280, 24},
    { -1336, 216, 120},
    { -1136, 152, 88},
    { -1000, 224, 168},
    { -944, 320, 136},
    { -984, 416, 168},
    { -976, 504, 120},
    { -1064, 608, 208},
    { -1064, 640, 256},
    { -912, 952, 72},
    { -920, 944, 256},
    { -640, 2152, 328},
    { -416, 1864, 208},
    { -336, 1184, 312},
    { -112, 648, 400},
    { 200, 320, 288},
    { 488, 136, 272},
    { 488, -72, 128},
    { 512, -96, -16},
    // 4 seconds
    { 512, -224, -216},
    { 440, 32, -448},
    { 288, 200, -624},
    { 112, 456, -800},
    { -32, 776, -1272},
    { 48, 392, -1096},
    { 264, 392, -728},
    { 432, 544, -784},
    { 528, 352, -600},
    { 392, 432, -648},
    { 200, 624, -712},
    { 336, 192, -624},
    { 560, -360, -152},
    { 80, 648, -400},
    { -216, 912, -272},
    { 112, 1448, -400},
    { -384, 1024, -776},
    { -200, 1352, -736},
    { -424, 760, -728},
    { -248, 1088, -656},
    { -24, 976, 8},
    { -120, 792, -360},
    { -200, 784, -624},
    { -456, 296, -584},
    { -376, 192, -480},
    // 5 seconds
    { -472, 184, -448},
    { -456, 216, -400},
    { -264, 400, -664},
    { 184, 376, -560},
    { 264, 488, -512},
    { -56, 1080, -1040},
    { -168, 1176, -1200},
    { 88, 1016, -952},
    { 528, 760, -360},
    { 320, 648, -248},
    { -120, 808, -304},
    { -432, 832, -496},
    { -168, 1064, -104},
    { -216, 696, 0},
    { -248, -64, -136},
    { -480, 280, -424},
    { -904, 920, -440},
    { -1000, 936, -352},
    { -1080, 1168, -296},
    { -1208, 1144, -456},
    { -1056, 1472, -464},
    { -520, 944, 112},
    { -368, 560, -88},
    { -328, 360, -456},
    { -496, 464, -760},
    // 6 seconds
    { -320, 856, -560},
    { -256, 984, -104},
    { -112, 248, 496},
    { -480, -1384, -304},
    { -1056, -1576, -800},
    { -712, -344, -944},
    { -648, -504, -504},
    { -1064, -216, -1192},
    { -504, -696, -1080},
    { -536, -464, -816},
    { -672, 312, -1232},
    { -216, -144, -816},
    { 24, -248, -496},
    { -136, -104, -776},
    { 80, -80, -248},
    { 256, -48, -424},
    { 208, -208, -392},
    { 32, 128, -248},
    { 56, 256, -144},
    { -256, 232, 112},
    { -624, 744, 848},
    { -1160, 1360, 1136},
    { -1288, 2400, 408},
    { -1872, 744, 712},
    { -2152, 992, 592},
    // 7 seconds
    { -2256, 640, 296},
    { -1728, 480, 448},
    { -1280, 760, 64},
    { -1152, 528, 120},
    { -1248, 512, 72},
    { -1032, 432, 136},
    { -1224, 616, 344},
    { -936, 664, 320},
    { -1136, 528, 424},
    { -1264, 496, 336},
    { -1032, 664, 72},
    { -1152, 616, 136},
    { -1368, 456, 160},
    { -1504, 432, 128},
    { -1272, 320, 160},
    { -1152, 192, 152},
    { -1176, 192, 216},
    { -1176, 208, 216},
    { -1168, 240, 224},
    { -1224, 136, 184},
    { -1176, 136, 200},
    { -1024, -224, 392},
    { -1176, -176, 96},
    { -1112, 184, -152},
    { -1176, 144, -120},
    // 8 seconds
    { -1312, 48, -120},
    { -1296, 80, -8},
    { -1136, 128, 32},
    { -1032, 192, 88},
    { -1056, 224, 168},
    { -1296, 288, 232},
    { -1416, 456, 96},
    { -1232, 648, 168},
    { -1200, 936, -40},
    { -936, 512, 16},
    { -1464, 664, 40},
    { -1152, 536, -32},
    { -1128, 608, -112},
    { -1344, 424, 40},
    { -1520, 488, 80},
    { -1384, 424, 96},
    { -1176, 296, 128},
    { -1104, 176, 168},
    { -1080, 96, 112},
    { -1344, 192, 144},
    { -1464, 264, 56},
    { -1432, -104, 136},
    { -1088, -176, 176},
    { -1096, -264, 224},
    { -1152, -112, 200},
    // 9 seconds
    { -1024, 24, 120},
    { -1152, 56, 8},
    { -1200, 120, 32},
    { -1136, 72, 168},
    { -1056, 144, 88},
    { -1016, 288, 24},
    { -1272, 272, -8},
    { -1504, 424, -24},
    { -1360, 600, 192},
    { -1096, 1216, -288},
    { -1280, 800, -160},
    { -1232, 608, -72},
    { -1288, 736, 8},
    { -1064, 640, -40},
    { -1352, 592, 96},
    { -1552, 472, 184},
    { -1440, 344, 200},
    { -1176, 288, 192},
    { -1128, 248, 216},
    { -1120, 168, 232},
    { -1104, 160, 224},
    { -1168, 152, 224},
    { -1376, 64, 232},
    { -1208, -224, 280},
    { -1176, -168, 144},
    // 10 seconds
    { -1120, 168, -264},
    { -992, 208, -176},
    { -1216, -120, -40},
    { -1376, -104, 8},
    { -1240, 136, 56},
    { -1112, 256, 80},
    { -1088, 296, 144},
    { -1192, 344, 200},
    { -1320, 464, 48},
    { -1248, 552, 8},
    { -1304, 776, -24},
    { -1056, 320, -96},
    { -1480, 552, -64},
    { -1096, 520, -56},
    { -1136, 512, -64},
    { -1312, 480, 8},
    { -1488, 376, 64},
    { -1256, 216, 40},
    { -1136, 168, 8},
    { -1152, 216, 40},
    { -1208, 128, 200},
    { -1208, 208, 72},
    { -1456, 184, 112},
    { -1384, -296, 312},
    { -1160, -296, 248},
    // 11 seconds
    { -1352, -8, 56},
    { -1240, 240, -248},
    { -1320, 176, -104},
    { -1320, -128, -24},
    { -1144, -96, -72},
    { -952, 120, -120},
    { -904, 264, -56},
    { -984, 384, -8},
    { -1080, 464, -88},
    { -1208, 528, -176},
    { -1520, 856, -208},
    { -1088, 656, -48},
    { -1360, 952, -488},
    { -1240, 944, -168},
    { -1064, 392, -232},
    { -1304, 384, -168},
    { -1576, 368, -112},
    { -1376, 320, -104},
    { -1184, 240, -64},
    { -1216, 216, -24},
    { -1288, 216, 24},
    { -1336, 208, 56},
    { -1400, 176, 64},
    { -1336, -72, 104},
    { -1168, -168, 80},
    // 12 seconds
    { -1080, -64, -80},
    { -984, 32, -360},
    { -1168, 104, -280},
    { -1184, -136, -120},
    { -1024, -96, -48},
    { -896, 144, -56},
    { -984, 264, 48},
    { -1312, 288, 96},
    { -1632, 384, 80},
    { -1672, 672, -32},
    { -1376, 1312, 16},
    { -1352, 704, -224},
    { -1368, 600, -328},
    { -1240, 728, -208},
    { -1248, 848, -216},
    { -1232, 648, -72},
    { -1440, 592, 104},
    { -1432, 400, 200},
    { -1296, 280, 176},
    { -1264, 344, 184},
    { -1184, 264, 320},
    { -1120, 304, 200},
    { -1064, 256, 280},
    { -1152, 264, 240},
    { -1032, 64, 320},
    // 13 seconds
    { -1064, -344, -184},
    { -1024, 176, -448},
    { -1008, 464, -232},
    { -1192, 552, -64},
    { -1208, 384, 200},
    { -1248, 488, 184},
    { -1160, 496, 232},
    { -1120, 488, 360},
    { -1128, 584, 320},
    { -1184, 696, 288},
    { -1008, 824, 216},
    { -1104, 840, 224},
    { -936, 872, 232},
    { -1072, 976, 232},
    { -1136, 896, 280},
    { -968, 776, 136},
    { -1176, 720, 216},
    { -1408, 544, 368},
    { -1360, 392, 424},
    { -1096, 392, 296},
    { -968, 392, 224},
    { -1080, 376, 320},
    { -1400, 784, 384},
    { -1656, 1032, 712},
    { -1704, 1536, 600},
    // 14 seconds
    { -1224, 1368, 528},
    { -720, 1296, 264},
    { -40, 1488, -312},
    { -256, 928, -416},
    { -232, 360, -144},
    { -192, -104, -200},
    { -88, -328, -224},
    { -24, -552, -128},
    { -8, -600, -224},
    { 0, -512, -304},
    { 128, -384, -544},
    { 392, -736, -448},
    { 496, -736, -640},
    { 888, -1144, -416},
    { 864, -992, -424},
    { 1056, -760, -552},
    { 1128, -568, -312},
    { 928, -568, -264},
    { 576, -480, -328},
    { 232, -528, -344},
    { 152, -488, -432},
    { 160, -456, -288},
    { 176, -520, -176},
    { 192, -856, -384},
    { 216, -896, -448},
    // 15 seconds
    { 320, -720, -376},
    { 384, -784, -256},
    { 568, -184, -48},
    { -272, 256, -360},
    { -464, 648, -440},
    { -824, 872, -528},
    { -888, 976, -808},
    { -704, 1120, -536},
    { -704, 1192, -784},
    { -496, 1056, -744},
    { -568, 1160, -1032},
    { -464, 1240, -1368},
    { -448, 1288, -1096},
    { -344, 1192, -880},
    { -528, 1568, -640},
    { -504, 1272, -568},
    { -400, 1056, -360},
    { -528, 1112, -336},
    { -648, 1032, -288},
    { -624, 640, -200},
    { -512, 312, -136},
    { -432, 248, -120},
    { -400, 248, -48},
    { -480, 48, -48},
    { -856, -16, -40},
    // 16 seconds
    { -1016, 56, 24},
    { -1328, 48, 160},
    { -1680, 208, 32},
    { -2320, 504, -440},
    { -1976, 384, -248},
    { -1480, 208, -192},
    { -1048, 24, -112},
    { -968, 120, -16},
    { -1072, 232, -56},
    { -1192, 400, -216},
    { -1232, 608, -360},
    { -1304, 448, -432},
    { -1184, 1024, -472},
    { -1584, 72, -344},
    { -1480, 200, -216},
    { -1400, 360, -32},
    { -1680, 296, 16},
    { -1664, 272, 64},
    { -1312, 168, 16},
    { -1176, 256, 104},
    { -1200, 280, 160},
    { -1280, 208, 216},
    { -1264, 128, 176},
    { -1256, 184, 152},
    { -1296, -64, 192},
    // 17 seconds
    { -1008, -280, 352},
    { -1096, -64, 184},
    { -1024, 168, -88},
    { -1136, 328, -104},
    { -1264, 184, -168},
    { -1392, -104, -264},
    { -1512, -24, -320},
    { -1456, 328, -8},
    { -1288, 432, 72},
    { -1328, 568, -128},
    { -1368, 528, 8},
    { -1208, 576, 88},
    { -1088, 592, 112},
    { -976, 464, 272},
    { -1472, 664, 104},
    { -976, 568, 0},
    { -1232, 520, 48},
    { -1472, 288, 48},
    { -1392, 296, 0},
    { -1224, 232, -56},
    { -1184, 120, -8},
    { -1320, 136, 56},
    { -1384, 104, 48},
    { -1544, 248, 32},
    { -1608, -152, 112},
    // 18 seconds
    { -1256, -504, 112},
    { -1144, -480, 72},
    { -1208, -256, -40},
    { -1288, -88, -96},
    { -1360, -24, -120},
    { -1256, -80, -64},
    { -1080, -96, -40},
    { -952, 8, 24},
    { -944, 96, 136},
    { -1040, 216, 168},
    { -1344, 424, -168},
    { -1280, 696, -448},
    { -1368, 848, -368},
    { -1200, 0, -280},
    { -1856, 56, -88},
    { -1328, 400, -152},
    { -1264, 392, -152},
    { -1432, 320, 8},
    { -1560, 256, 96},
    { -1360, 160, 112},
    { -1104, 128, 112},
    { -1008, 56, 88},
    { -1008, 32, 112},
    { -1032, 96, 104},
    { -1248, 184, 56},
    // 19 seconds
    { -1408, -32, -16},
    { -1184, -432, 208},
    { -1288, -88, -96},
    { -1240, -88, -728},
    { -1328, -200, -232},
    { -1384, 24, 120},
    { -1272, 104, 32},
    { -1096, 208, 0},
    { -1016, 256, -96},
    { -984, 272, -40},
    { -1200, 288, -104},
    { -1264, 448, -16},
    { -1320, 1128, -416},
    { -1152, 336, -136},
    { -1240, 440, -264},
    { -1304, 664, -400},
    { -1072, 480, -344},
    { -1432, 464, -216},
    { -1632, 400, 0},
    { -1496, 208, -48},
    { -1232, 112, -88},
    { -1064, 528, -240},
    { -1240, 120, 184},
    { -1264, 120, 192},
    { -1256, 160, 120},
    // 20 seconds
    { -1424, 32, 192},
    { -1104, -440, 216},
    { -992, -344, 160},
    { -1144, 16, -88},
    { -1200, 72, -192},
    { -1472, 0, -104},
    { -1504, 24, -88},
    { -1296, 64, -16},
    { -1104, 240, 96},
    { -1016, 368, 152},
    { -1184, 456, -16},
    { -1296, 488, -32},
    { -1264, 664, -64},
    { -1256, 1064, -112},
    { -1048, 320, -264},
    { -1576, 632, -176},
    { -1136, 632, -232},
    { -1144, 488, -280},
    { -1304, 352, -160},
    { -1408, 400, -128},
    { -1288, 304, -128},
    { -1144, 232, -24},
    { -1144, 200, 16},
    { -1176, 176, 64},
    { -1296, 168, 64},
    // 21 seconds
    { -1416, 112, 184},
    { -1264, -384, 192},
    { -1008, -328, -24},
    { -1224, -16, -192},
    { -1264, 64, -432},
    { -1440, 128, -240},
    { -1408, -264, -80},
    { -1192, -96, -96},
    { -1064, 184, -136},
    { -928, 328, -112},
    { -1016, 392, -160},
    { -1224, 448, -120},
    { -1320, 608, -32},
    { -1224, 1384, -56},
    { -1008, 280, -184},
    { -1600, 608, -296},
    { -1544, 680, -88},
    { -1272, 480, -200},
    { -1432, 352, -72},
    { -1552, 296, 40},
    { -1328, 224, -24},
    { -1144, 152, 8},
    { -1128, 112, 64},
    { -1176, 136, 56},
    { -1216, 136, 64},
    // 22 seconds
    { -1272, 112, 64},
    { -1192, -384, 184},
    { -848, -456, 56},
    { -1128, -80, -40},
    { -1320, 72, -136},
    { -1624, 144, -384},
    { -1536, 8, -168},
    { -1288, -128, -152},
    { -1152, 112, -312},
    { -984, 168, -56},
    { -984, 328, -48},
    { -1136, 336, -80},
    { -1144, 312, -56},
    { -1176, 400, -96},
    { -1296, 1144, -48},
    { -1200, 656, -88},
    { -1440, 544, -392},
    { -1120, 464, -328},
    { -1632, 544, -296},
    { -1760, 328, -320},
    { -1672, 336, -264},
    { -1416, 240, -152},
    { -1384, 152, 8},
    { -1368, 96, 104},
    { -1248, 120, 96},
    // 23 seconds
    { -1048, 0, 104},
    { -992, -728, 536},
    { -608, -96, -184},
    { -1144, -200, -128},
    { -1664, 216, -176},
    { -1872, 504, -424},
    { -1656, 304, -136},
    { -1408, 184, -8},
    { -1248, 392, -184},
    { -1096, 296, -88},
    { -1120, 336, 24},
    { -1248, 464, -104},
    { -1336, 536, -232},
    { -1248, 576, -96},
    { -1032, 1640, -112},
    { -1016, 400, -400},
    { -1384, 856, -216},
    { -1176, 632, -120},
    { -1248, 496, -120},
    { -1384, 440, -24},
    { -1600, 376, 64},
    { -1456, 312, 88},
    { -1328, 208, 128},
    { -1232, 576, 216},
    { -1312, -16, 152},
    // 24 seconds
    { -1352, 120, 184},
    { -1504, 144, 232},
    { -1400, -104, 176},
    { -960, -600, 176},
    { -1168, -112, -16},
    { -1192, 16, -328},
    { -1456, 0, -144},
    { -1384, -16, -80},
    { -1304, -96, -112},
    { -1240, 120, -88},
    { -1208, 272, 24},
    { -1232, 400, 48},
    { -1312, 440, -48},
    { -1336, 600, -120},
    { -1384, 1064, -48},
    { -1160, 200, -56},
    { -1472, 416, -80},
    { -1176, 536, -120},
    { -1040, 496, -264},
    { -1248, 512, -224},
    { -1360, 400, -200},
    { -1200, 280, -248},
    { -1096, 216, -144},
    { -1112, 136, -24},
    { -1192, 128, 40},
    // 25 seconds
    { -1248, 136, 24},
    { -1360, 176, 160},
    { -1472, -376, 168},
    { -1216, -360, 104},
    { -1296, -256, 24},
    { -1304, 168, -544},
    { -1512, 112, -272},
    { -1376, -408, -24},
    { -1112, -472, -24},
    { -952, 96, -208},
    { -824, 200, -144},
    { -864, 208, -80},
    { -1104, 256, -168},
    { -1256, 264, -128},
    { -1504, 624, 48},
    { -1200, 1208, -136},
    { -1464, 584, -248},
    { -1296, 512, -96},
    { -1176, 576, -176},
    { -1440, 400, -40},
    { -1640, 280, 72},
    { -1360, 264, -8},
    { -1064, 232, -40},
    { -1032, 208, 16},
    { -1088, 184, 80},
    // 26 seconds
    { -1152, 168, 104},
    { -1328, 160, 112},
    { -1384, -184, 256},
    { -984, -240, 8},
    { -992, -216, 40},
    { -1264, -16, -144},
    { -1448, 168, -360},
    { -1600, 40, -184},
    { -1432, -152, -72},
    { -1200, 16, -112},
    { -960, 264, 0},
    { -880, 328, 152},
    { -1048, 448, 216},
    { -1024, 352, 208},
    { -1080, 312, 168},
    { -1224, 432, 224},
    { -1232, 648, 384},
    { -1560, 1000, 224},
    { -1024, 600, -96},
    { -1032, 888, 8},
    { -1312, 712, 232},
    { -1408, 456, 176},
    { -1136, 424, 96},
    { -1072, 344, 120},
    { -1160, 248, 168},
    // 27 seconds
    { -1208, 216, 192},
    { -1232, 224, 184},
    { -1392, 88, 232},
    { -1312, -376, 232},
    { -1080, -424, 56},
    { -1312, -152, 32},
    { -1400, 80, -200},
    { -1576, 264, -240},
    { -1408, 48, -112},
    { -1072, -192, -40},
    { -928, 32, -88},
    { -816, 264, 80},
    { -960, 448, 96},
    { -1160, 568, -32},
    { -1120, 544, -56},
    { -1312, 600, 56},
    { -1216, 1192, 208},
    { -1512, 96, -232},
    { -1280, 512, -208},
    { -1104, 608, -80},
    { -1448, 584, 24},
    { -1600, 280, 120},
    { -1440, 136, -32},
    { -1120, 24, -160},
    { -1088, 128, -160},
    // 28 seconds
    { -1152, 128, -56},
    { -1184, 112, -72},
    { -1312, 136, -8},
    { -1328, -200, 216},
    { -968, -368, 200},
    { -1328, -264, 32},
    { -1288, 160, -328},
    { -1264, 80, -368},
    { -1304, 88, -336},
    { -1104, 48, -312},
    { -984, 184, -336},
    { -960, 296, -280},
    { -1080, 304, -88},
    { -1264, 392, -40},
    { -1240, 496, -120},
    { -1240, 808, -192},
    { -1152, 416, -192},
    { -1544, 520, -192},
    { -1472, 576, -208},
    { -928, 424, -320},
    { -1240, 400, -256},
    { -1504, 376, -88},
    { -1320, 248, -104},
    { -1112, 224, -88},
    { -1088, 192, -40},
    // 29 seconds
    { -1200, 144, 32},
    { -1272, 136, 32},
    { -1256, 120, 48},
    { -1312, -40, 88},
    { -992, -368, 112},
    { -1160, -248, 64},
    { -1312, 40, -208},
    { -1384, 136, -424},
    { -1496, 192, -288},
    { -1256, -200, -104},
    { -1136, -112, -232},
    { -976, 224, -144},
    { -864, 312, -88},
    { -992, 368, -200},
    { -1104, 432, -208},
    { -1152, 768, -384},
    { -1224, 632, -256},
    { -1480, 232, -264},
    { -1696, 464, -160},
    { -1240, 440, -208},
    { -1296, 376, -152},
    { -1424, 328, 0},
    { -1296, 272, -32},
    { -1064, 184, 0},
    { -1000, 136, 40},
    // 30 seconds
    { -1056, 120, 72},
    { -1088, 104, 80},
    { -1224, 80, 112},
    { -1256, -288, 256},
    { -1056, -232, 144},
    { -1216, -80, 96},
    { -1432, 112, -176},
    { -1416, 312, -360},
    { -1432, 136, -40},
    { -1272, -256, 96},
    { -1176, -80, -16},
    { -968, 208, 32},
    { -832, 280, 176},
    { -912, 352, 160},
    { -1056, 360, -24},
    { -1184, 312, 16},
    { -1616, 512, 72},
    { -1224, 1624, 32},
    { -1568, 0, -240},
    { -1144, 360, -248},
    { -1240, 552, 8},
    { -1344, 496, 32},
    { -1312, 176, -64},
    { -1008, 0, -192},
    { -1016, 184, -216},
    // 31 seconds
    { -1216, 248, -104},
    { -1328, 248, -80},
    { -1352, 184, 0},
    { -1504, 112, 88},
    { -1384, -168, 176},
    { -1320, -216, 136},
    { -1208, -40, 104},
    { -1016, 64, -8},
    { -1176, 120, -32},
    { -1160, 160, -48},
    { -1024, 104, -48},
    { -976, 176, -104},
    { -1032, 232, -72},
    { -1224, 384, -320},
    { -1424, 480, -432},
    { -1264, 864, -328},
    { -1320, 296, -584},
    { -1400, 528, -432},
    { -1872, 472, -168},
    { -1208, 296, -200},
    { -1208, 264, -248},
    { -1360, 320, -128},
    { -1360, 272, -32},
    { -1112, 160, 32},
    { -1016, 120, 64},
    // 32 seconds
    { -1016, 112, 104},
    { -1016, 88, 112},
    { -1080, 120, 136},
    { -1352, -144, 272},
    { -1216, -192, 200},
    { -1392, -80, 112},
    { -1424, 120, -280},
    { -1288, 0, -120},
    { -1328, -80, 40},
    { -1160, -104, -112},
    { -992, -40, -144},
    { -920, 136, -136},
    { -904, -24, 168},
    { -1144, 400, 136},
    { -1216, 520, 8},
    { -1304, 640, 224},
    { -1256, 1120, 376},
    { -944, 752, 144},
    { -1352, 976, 248},
    { -928, 848, 176},
    { -1112, 1056, 136},
    { -1464, 680, 384},
    { -1480, 584, 336},
    { -1264, 464, 352},
    { -1144, 328, 344},
    // 33 seconds
    { -1112, 280, 368},
    { -1088, 240, 352},
    { -1000, 200, 616},
    { -1200, -176, 168},
    { -904, 64, 0},
    { -848, 96, 184},
    { -1048, 984, 144},
    { -632, 1464, 144},
    { -608, 1136, 256},
    { -456, 1096, 112},
    { -320, 864, 32},
    { -128, 600, 24},
    { -40, 464, -8},
    { -88, 456, 168},
    { -104, 432, 448},
    { 80, 632, 480},
    { 96, 448, 632},
    { 48, 640, 608},
    { -168, 752, 840},
    { -456, 1368, 1024},
    { -448, 1752, 632},
    { -280, 1312, 568},
    { -304, 848, 440},
    { -232, 792, 360},
    { -176, 672, 224},
    // 34 seconds
    { -184, 744, -104},
    { -208, 304, -56},
    { -264, 184, 8},
    { -400, 160, 136},
    { -696, 152, 184},
    { -1192, 120, 424},
    { -1480, 272, 376},
    { -2440, 456, 248},
    { -2120, 912, -72},
    { -1424, 72, 576},
    { -984, -48, -64},
    { -1200, 504, 64},
    { -744, 424, 112},
    { -560, 296, 64},
    { -688, 232, 104},
    { -768, 320, 88},
    { -904, 336, 216},
    { -1128, 408, 328},
    { -848, 728, 528},
    { -1712, 1104, 248},
    { -1096, 768, 80},
    { -1104, 704, 192},
    { -1336, 544, 320},
    { -1416, 408, 312},
    { -1192, 280, 272},
    // 35 seconds
    { -1088, 200, 256},
    { -1072, 184, 208},
    { -1096, 216, 208},
    { -1104, 160, 208},
    { -1184, 104, 264},
    { -1352, -136, 312},
    { -1120, -240, 176},
    { -1208, -32, 0},
    { -1040, 136, -312},
    { -1152, 216, -272},
    { -1248, -24, -208},
    { -1192, -112, -176},
    { -1056, 56, -120},
    { -1072, 232, -8},
    { -1176, 312, 48},
    { -1256, 400, 56},
    { -1160, 392, -40},
    { -1176, 472, -104},
    { -1168, 504, -152},
    { -1592, 392, -120},
    { -1456, 528, -184},
    { -1120, 440, -232},
    { -1304, 400, -80},
    { -1384, 328, 40},
    { -1200, 208, 48},
    // 36 seconds
    { -1024, 152, 56},
    { -1008, 64, 104},
    { -1032, 64, 120},
    { -1128, 184, 128},
    { -1304, 168, 200},
    { -1528, -264, 496},
    { -1160, -176, 216},
    { -1344, -64, 80},
    { -1168, 208, -312},
    { -1224, 168, -240},
    { -1320, 32, -48},
    { -1184, -248, -16},
    { -1016, -88, -40},
    { -848, 176, -72},
    { -880, 320, -112},
    { -1048, 352, -152},
    { -1184, 432, -248},
    { -1288, 568, -296},
    { -1192, 936, -216},
    { -1032, -200, -152},
    { -1720, 296, -112},
    { -1272, 448, -56},
    { -1304, 488, -32},
    { -1520, 392, 128},
    { -1368, 216, 168},
    // 37 seconds
    { -1008, 160, 120},
    { -936, 160, 120},
    { -1008, 128, 136},
    { -1056, 112, 168},
    { -1088, 96, 176},
    { -1224, 64, 232},
    { -1256, -96, 312},
    { -1200, -72, 256},
    { -1432, 40, 56},
    { -968, 256, -408},
    { -848, 72, -216},
    { -1040, 8, -96},
    { -1176, -40, -56},
    { -1112, 56, -104},
    { -1040, 152, -88},
    { -1096, 288, -128},
    { -1136, 280, -80},
    { -992, 200, -232},
    { -1008, 608, -384},
    { -1256, 584, -304},
    { -1352, 368, -224},
    { -1632, 504, -336},
    { -1296, 416, -256},
    { -1248, 384, -152},
    { -1432, 344, 32},
    // 38 seconds
    { -1504, 280, 96},
    { -1264, 232, 112},
    { -1112, 176, 136},
    { -1112, 144, 160},
    { -1104, 104, 184},
    { -1016, 112, 176},
    { -1024, 96, 216},
    { -1216, 8, 280},
    { -1136, -112, 240},
    { -1320, 0, 56},
    { -1016, 128, -216},
    { -1104, 176, -288},
    { -1216, 136, -184},
    { -1168, -104, -152},
    { -1056, -136, -120},
    { -1048, 40, -80},
    { -1080, 208, -64},
    { -1224, 320, -72},
    { -1312, 376, -144},
    { -1200, 416, -224},
    { -1296, 776, -336},
    { -1256, 160, -240},
    { -1888, 320, -240},
    { -1416, 384, -184},
    { -1048, 304, -200},
    // 39 seconds
    { -1200, 296, -24},
    { -1328, 272, 104},
    { -1304, 200, 128},
    { -1144, 120, 168},
    { -1096, 64, 184},
    { -1080, 56, 200},
    { -1088, 56, 216},
    { -1064, 72, 248},
    { -1120, 144, 184},
    { -1304, 280, -120},
    { -1384, 72, 96},
    { -1112, 136, -384},
    { -968, -32, -264},
    { -1000, -160, -184},
    { -976, -288, -56},
    { -1000, -128, -64},
    { -840, 72, -160},
    { -712, 176, -152},
    { -808, 168, -80},
    { -1024, 200, -128},
    { -1216, 232, -216},
    { -1584, 376, -184},
    { -1400, 1664, -400},
    { -1120, -416, -272},
    { -1728, 200, -512},
    // 40 seconds
    { -1128, 744, -392},
    { -1240, 552, -248},
    { -1464, 176, 0},
    { -1416, 48, 72},
    { -1104, 48, 16},
    { -1048, 144, 24},
    { -1064, 168, 72},
    { -1000, 160, 64},
    { -944, 136, 48},
    { -1216, 56, 128},
    { -1256, -256, 176},
    { -1320, -184, 128},
    { -1272, 40, -64},
    { -1160, 184, -216},
    { -1120, 96, -64},
    { -1144, -8, 72},
    { -1200, -80, 128},
    { -1200, 56, 176},
    { -1152, 248, 200},
    { -1208, 432, -8},
    { -1232, 536, -72},
    { -1104, 632, -136},
    { -1192, 464, -224},
    { -1304, 368, -152},
    { -1576, 464, -176},
    // 41 seconds
    { -1360, 400, -208},
    { -1064, 272, -184},
    { -1320, 392, -56},
    { -1536, 272, 80},
    { -1520, 360, 56},
    { -1216, 168, 88},
    { -1080, 200, 96},
    { -1016, 152, 136},
    { -1016, 120, 120},
    { -1080, 144, 168},
    { -1248, 96, 192},
    { -1120, 48, 216},
    { -1304, 120, 152},
    { -1248, 248, -216},
    { -936, 176, -232},
    { -1096, 88, -232},
    { -1128, -24, -136},
    { -1040, 16, -96},
    { -968, 160, -56},
    { -936, 272, 64},
    { -1088, 424, 32},
    { -1224, 512, 8},
    { -1208, 648, 0},
    { -1192, 1200, -96},
    { -1224, 736, -120},
    // 42 seconds
    { -1552, 560, -32},
    { -1008, 472, -184},
    { -1088, 544, -264},
    { -1264, 464, -96},
    { -1320, 400, -8},
    { -1096, 320, -16},
    { -536, -712, 408},
    { -1192, 208, 200},
    { -952, 216, 96},
    { -1128, 296, 88},
    { -1248, 120, 168},
    { -1328, 48, 216},
    { -1024, 16, 24},
    { -1256, 24, -32},
    { -1168, 112, -184},
    { -1120, 152, -280},
    { -1288, 40, -152},
    { -1176, -80, 32},
    { -1000, 32, 64},
    { -848, 248, 96},
    { -832, 536, 104},
    { -856, 232, 32},
    { -1104, 416, -72},
    { -1080, 536, 0},
    { -1208, 992, 88},
    // 43 seconds
    { -936, 1104, 104},
    { -1520, 840, 24},
    { -1200, 560, 56},
    { -1104, 432, 0},
    { -1424, 464, 80},
    { -1528, 360, 88},
    { -1088, 512, 32},
    { -944, 344, 0},
    { -1024, 296, 104},
    { -1008, 216, 96},
    { -904, 184, 168},
    { -1056, 464, -24},
    { -984, 312, -88},
    { -976, 488, -24},
    { -1128, 216, 112},
    { -1184, 408, -128},
    { -992, 464, -176},
    { -1112, 456, -296},
    { -1280, 480, -112},
    { -1096, 408, -56},
    { -888, 392, 16},
    { -880, 384, 48},
    { -944, 432, 96},
    { -1000, 424, 72},
    { -864, 456, -8},
    // 44 seconds
    { -1064, 480, -64},
    { -1128, 720, 96},
    { -1344, 704, 8},
    { -1224, 672, -128},
    { -888, 608, -144},
    { -1320, 544, -56},
    { -1552, 464, 8},
    { -1280, 368, 8},
    { -1096, 288, 24},
    { -1088, 248, 72},
    { -1096, 200, 128},
    { -1032, 184, 120},
    { -944, 160, 96},
    { -928, 88, 144},
    { -888, 24, 128},
    { -1056, 8, 200},
    { -1280, 152, 64},
    { -1344, 512, -400},
    { -1264, 384, -296},
    { -1320, 104, -184},
    { -1256, -64, -88},
    { -984, -16, -56},
    { -936, 128, 56},
    { -952, 296, 120},
    { -1136, 432, -24},
    // 45 seconds
    { -1072, 376, 24},
    { -1264, 704, 16},
    { -1128, 1312, 344},
    { -1160, 296, -224},
    { -1352, 720, 24},
    { -1064, 600, 72},
    { -1096, 552, 72},
    { -1280, 424, 184},
    { -1400, 304, 184},
    { -1112, 248, 136},
    { -984, 200, 96},
    { -1016, 168, 96},
    { -1080, 216, 112},
    { -1112, 184, 104},
    { -1040, 0, 128},
    { -1184, -48, 32},
    { -1112, -152, -8},
    { -1408, 24, -24},
    { -1344, 152, -208},
    { -1088, 200, -352},
    { -1128, 48, -160},
    { -1168, -88, 48},
    { -1192, 24, 56},
    { -1080, 256, 104},
    { -976, 312, 88},
    // 46 seconds
    { -960, 360, 0},
    { -1056, 376, -128},
    { -1008, 392, -224},
    { -1240, 560, -256},
    { -1240, 528, -296},
    { -1768, 360, -304},
    { -1320, 416, -280},
    { -984, 336, -280},
    { -1200, 288, -144},
    { -1456, 248, 16},
    { -1392, 160, 72},
    { -1168, 136, 64},
    { -1080, 152, 80},
    { -1080, 168, 112},
    { -1048, 152, 88},
    { -976, 144, 120},
    { -1200, -24, 136},
    { -1104, -216, 104},
    { -1216, -88, 104},
    { -1296, 40, -40},
    { -1184, 176, -368},
    { -1280, 176, -224},
    { -1368, -136, -104},
    { -1328, -80, 32},
    { -1216, 168, 96},
    // 47 seconds
    { -1072, 416, 192},
    { -1032, 472, 40},
    { -1080, 432, -64},
    { -1032, 424, -56},
    { -1040, 528, -88},
    { -1088, 600, -88},
    { -1216, 328, -104},
    { -1512, 536, -112},
    { -1136, 424, -160},
    { -1544, 384, 32},
    { -1736, 272, 128},
    { -1512, 232, -16},
    { -1256, 216, -48},
    { -1120, 272, -24},
    { -1216, 184, 72},
    { -1160, 48, 128},
    { -1112, 136, 88},
    { -1144, -88, 240},
    { -1024, -256, 160},
    { -832, -176, -32},
    { -1152, -104, 88},
    { -1272, 160, -160},
    { -1440, 232, -184},
    { -1720, 160, -40},
    { -1656, 48, 80},
    // 48 seconds
    { -1360, 176, -8},
    { -1008, 320, 0},
    { -976, 376, -32},
    { -1072, 392, -8},
    { -1024, 376, -96},
    { -1032, 424, -64},
    { -1136, 784, -136},
    { -1096, 552, -80},
    { -1640, 344, -56},
    { -1192, 384, -120},
    { -1192, 448, -128},
    { -1472, 392, 56},
    { -1640, 304, 104},
    { -1472, 216, 104},
    { -1288, 136, 96},
    { -1232, 112, 136},
    { -1208, 120, 120},
    { -1168, 128, 96},
    { -1168, 128, 136},
    { -1136, -72, 120},
    { -872, -248, 72},
    { -1096, -48, 72},
    { -1152, 104, -136},
    { -1088, 160, -232},
    { -1296, 112, -136},
    // 49 seconds
    { -1400, -72, 72},
    { -1432, 80, 88},
    { -1328, 288, 48},
    { -1144, 376, 104},
    { -1128, 416, 40},
    { -1200, 376, -24},
    { -1128, 320, -24},
    { -1232, 488, -40},
    { -1216, 784, -112},
    { -1424, 312, -88},
    { -1400, 336, -136},
    { -1040, 368, -176},
    { -1184, 432, -104},
    { -1360, 392, 24},
    { -1472, 208, 80},
    { -1296, 120, 88},
    { -1208, 112, 104},
    { -1248, 136, 104},
    { -1232, 128, 120},
    { -1184, 136, 112},
    { -1264, 112, 176},
    { -1160, -152, 120},
    { -1000, -184, 128},
    { -1064, 88, -128},
    { -1080, 160, -272},
    // 50 seconds
    { -1144, 192, -136},
    { -1208, -104, 0},
    { -1312, -72, -8},
    { -1184, 152, -80},
    { -1032, 296, -64},
    { -992, 280, 48},
    { -1096, 328, -32},
    { -1032, 272, -48},
    { -1176, 304, -56},
    { -1384, 616, -136},
    { -1456, 512, -88},
    { -1656, 304, -128},
    { -1224, 296, -216},
    { -1136, 376, -216},
    { -1280, 336, -72},
    { -1392, 160, -16},
    { -1224, 40, -24},
    { -1112, 72, -80},
    { -1080, 128, -8},
    { -1096, 136, 24},
    { -1112, 112, 88},
    { -1248, 96, 152},
    { -1360, -144, 200},
    { -1224, -208, 72},
    { -1160, 80, -136},
    // 51 seconds
    { -1112, 216, -272},
    { -1008, 24, -80},
    { -1064, -96, 72},
    { -1128, -136, -40},
    { -1088, 80, -80},
    { -1080, 240, 24},
    { -1160, 376, -8},
    { -1320, 392, -32},
    { -1256, 536, -152},
    { -1264, 784, -216},
    { -1320, 56, -104},
    { -1424, 240, -8},
    { -1288, 712, 112},
    { -952, 616, 8},
    { -1136, 584, 72},
    { -1424, 528, 200},
    { -1416, 376, 168},
    { -1160, 296, 224},
    { -1128, 176, 312},
    { -1160, -24, 312},
    { -1064, 24, 256},
    { -1072, 120, 232},
    { -1144, 96, 392},
    { -1000, 216, 264},
    { -1120, 176, 376},
    // 52 seconds
    { -1168, 520, 272},
    { -960, 696, 192},
    { -736, 552, 128},
    { -888, 280, 200},
    { -920, 304, 256},
    { -768, 272, 272},
    { -720, 312, 272},
    { -800, 400, 336},
    { -864, 256, 336},
    { -1040, 472, 96},
    { -1184, 368, 184},
    { -1520, 856, 416},
    { -1552, 560, -184},
    { -1592, 584, -184},
    { -1008, 592, -112},
    { -928, 752, -112},
    { -1256, 456, 0},
    { -1296, 432, 48},
    { -1096, 392, 24},
    { -1048, 264, 112},
    { -1120, 224, 160},
    { -1184, 224, 176},
    { -1104, 144, 200},
    { -1032, 152, 152},
    { -1208, 88, 296},
    // 53 seconds
    { -992, -152, 96},
    { -1224, -136, 120},
    { -1080, 112, -128},
    { -952, 312, -232},
    { -1144, 112, -168},
    { -1336, -208, -56},
    { -1328, -216, -72},
    { -1240, 40, -48},
    { -1136, 232, 48},
    { -1080, 320, 104},
    { -1096, 440, -24},
    { -1080, 344, -40},
    { -1288, 624, -160},
    { -1176, 696, -144},
    { -1536, 696, -400},
    { -1496, 560, -328},
    { -1200, 440, -248},
    { -1440, 520, -96},
    { -1648, 352, 64},
    { -1536, 360, 48},
    { -1264, 232, 88},
    { -1176, 152, 104},
    { -1152, 112, 136},
    { -1040, 24, 96},
    { -960, 464, -40},
    // 54 seconds
    { -1128, 208, -88},
    { -912, -32, -32},
    { -800, -56, -136},
    { -1120, 128, -72},
    { -1216, 472, -248},
    { -1136, 624, -456},
    { -1224, 472, -272},
    { -1232, 328, -88},
    { -1176, 320, -168},
    { -1040, 376, -80},
    { -992, 376, -56},
    { -1064, 344, -16},
    { -1136, 376, -64},
    { -984, 416, -72},
    { -1200, 640, -240},
    { -1304, 872, -184},
    { -1888, 504, -416},
    { -1208, 432, -464},
    { -1040, 456, -472},
    { -1248, 296, -224},
    { -1368, 208, -48},
    { -1256, 192, 24},
    { -1136, 192, 48},
    { -1088, 160, 80},
    { -1112, 168, 112},
    // 55 seconds
    { -1128, 144, 128},
    { -1208, 160, 216},
    { -1256, 128, 104},
    { -1200, -24, 24},
    { -1256, 104, -104},
    { -992, 88, -352},
    { -1080, 112, -296},
    { -1112, -264, -40},
    { -1144, -192, 0},
    { -1016, 128, -64},
    { -1008, 328, -120},
    { -1120, 360, -24},
    { -1280, 360, 32},
    { -1296, 480, -96},
    { -1272, 1080, -200},
    { -1232, 224, -168},
    { -1392, 448, -256},
    { -1544, 872, -208},
    { -1112, 552, -184},
    { -1264, 288, -264},
    { -1472, 184, -104},
    { -1544, 200, -80},
    { -1344, 256, -120},
    { -1144, 216, 0},
    { -1096, 144, 48},
    // 56 seconds
    { -1016, 128, 64},
    { -976, 112, 88},
    { -1120, -168, 280},
    { -1336, -520, 504},
    { -1272, -232, 376},
    { -1504, -104, 208},
    { -1448, 264, -144},
    { -1488, 240, -248},
    { -1632, 152, -272},
    { -1608, 400, -216},
    { -1280, 440, 160},
    { -944, 744, 112},
    { -880, 192, 0},
    { -1024, 320, 56},
    { -864, 376, 72},
    { -936, 432, 120},
    { -984, 600, 336},
    { -1304, 544, 56},
    { -1424, 384, 32},
    { -1184, 376, 88},
    { -1440, 512, 144},
    { -1616, 392, 152},
    { -1632, 368, -8},
    { -1440, 288, -56},
    { -1304, 48, 248},
    // 57 seconds
    { -1192, 32, 128},
    { -1048, 144, 104},
    { -944, 152, 136},
    { -952, 0, 200},
    { -928, -24, 272},
    { -928, -8, 152},
    { -1184, 128, 128},
    { -1168, 360, 88},
    { -1184, 360, -96},
    { -1424, 312, -16},
    { -1448, 288, 48},
    { -1240, 368, -16},
    { -1032, 344, 128},
    { -992, 392, 160},
    { -1056, 456, -32},
    { -1088, 376, 120},
    { -1152, 544, 72},
    { -1176, 656, 208},
    { -1080, 672, -8},
    { -1456, 472, -48},
    { -1248, 488, -88},
    { -1104, 400, -176},
    { -1272, 336, -80},
    { -1424, 264, -24},
    { -1280, 224, -16},
    // 58 seconds
    { -1200, 208, 16},
    { -1240, 160, 72},
    { -1320, 128, 104},
    { -1240, 112, 120},
    { -1136, 128, 72},
    { -1128, -112, 120},
    { -816, -264, 24},
    { -1128, -72, 0},
    { -1296, 0, -16},
    { -1216, 200, -304},
    { -1328, 216, -312},
    { -1392, -24, -16},
    { -1336, -96, 0},
    { -1168, 112, 24},
    { -984, 272, 152},
    { -968, 352, 112},
    { -1040, 384, 8},
    { -968, 328, -16},
    { -1056, 344, 16},
    { -1432, 584, -16},
    { -1392, 856, -64},
    { -1328, 160, -344},
    { -992, 344, -336},
    { -1232, 512, -144},
    { -1560, 424, 24},
    // 59 seconds
    { -1552, 160, 32},
    { -1200, 72, -48},
    { -1104, 176, -32},
    { -1216, 144, 120},
    { -1224, 56, 88},
    { -1080, 24, 64},
    { -1072, -48, 136},
    { -1128, -232, 184},
    { -1112, -256, 224},
    { -1328, 128, 104},
    { -1104, 200, -240},
    { -1312, 248, -208},
    { -1336, 112, -8},
    { -1152, -152, 96},
    { -1000, 8, 40},
    { -928, 224, 24},
    { -1040, 352, -8},
    { -1144, 440, -112},
    { -1160, 384, -208},
    { -1272, 440, -240},
    { -1272, 616, -256},
    { -1432, 104, -312},
    { -1560, 352, -280},
    { -1040, 344, -256},
    { -1272, 368, -128},
    // 60 seconds
    // elapsed: 1 minutes
    { -1560, 304, 72},
    { -1408, 208, 64},
    { -1112, 120, 32},
    { -1016, 120, 64},
    { -1080, 136, 112},
    { -1168, 136, 112},
    { -1064, 104, 96},
    { -1136, 0, 184},
    { -1080, -280, 160},
    { -1072, -184, 64},
    { -1240, 8, -56},
    { -1160, 120, -192},
    { -1440, 184, -224},
    { -1400, -104, -32},
    { -1200, -96, -8},
    { -1056, 216, -48},
    { -920, 384, 32},
    { -952, 368, -24},
    { -1136, 376, -24},
    { -1104, 320, 40},
    { -1216, 536, -40},
    { -1056, 1016, -96},
    { -1416, 280, -216},
    { -1400, 536, -144},
    { -1024, 552, -160},
    // 61 seconds
    { -1288, 488, -80},
    { -1496, 344, 88},
    { -1344, 248, 64},
    { -1136, 216, 72},
    { -1080, 176, 88},
    { -1088, 144, 96},
    { -1056, 128, 112},
    { -1104, 128, 120},
    { -1264, -32, 208},
    { -1152, -272, 144},
    { -1032, -128, 32},
    { -1264, -48, -40},
    { -1328, 216, -280},
    { -1344, 216, -208},
    { -1344, -24, -112},
    { -1232, -128, -112},
    { -1104, 88, -152},
    { -888, 224, -104},
    { -864, 328, -112},
    { -976, 344, -136},
    { -952, 288, -120},
    { -1208, 400, -200},
    { -1296, 712, -152},
    { -1328, 192, -168},
    { -1688, 280, -192},
    // 62 seconds
    { -1272, 384, -296},
    { -1096, 384, -256},
    { -1304, 312, -8},
    { -1296, 208, 88},
    { -1064, 160, 56},
    { -976, 120, 88},
    { -1032, 104, 136},
    { -1104, 88, 160},
    { -1056, 80, 152},
    { -1040, 72, 176},
    { -1136, -104, 272},
    { -1344, -160, 296},
    { -1424, 424, -208},
    { -1024, 296, -568},
    { -1224, 64, -272},
    { -1248, -528, -184},
    { -1232, -136, -216},
    { -1040, 232, -96},
    { -944, 304, 56},
    { -848, 376, 32},
    { -1064, 432, -32},
    { -984, 496, 48},
    { -1168, 600, 192},
    { -1192, 760, 432},
    { -1424, 688, 192},
    // 63 seconds
    { -1392, 784, 128},
    { -1072, 696, 136},
    { -1136, 560, 104},
    { -1392, 424, 168},
    { -1416, 272, 208},
    { -1208, 200, 120},
    { -1064, 136, 88},
    { -1040, 96, 120},
    { -992, 88, 120},
    { -1048, 136, 120},
    { -1224, 56, 200},
    { -1120, -136, 144},
    { -1168, 32, 96},
    { -1248, 232, -304},
    { -1288, 296, -320},
    { -1240, 8, -56},
    { -1256, -168, -40},
    { -1216, 168, -128},
    { -1048, 344, -16},
    { -872, 360, 72},
    { -992, 288, 96},
    { -1112, 280, 80},
    { -896, 336, 56},
    { -1096, 464, 80},
    { -1216, 976, 640},
    // 64 seconds
    { -1488, 656, 224},
    { -1256, 696, 168},
    { -1032, 888, 328},
    { -1288, 872, 384},
    { -1552, 480, 320},
    { -1448, 504, 248},
    { -1216, 408, 216},
    { -1144, 352, 264},
    { -1000, 176, 200},
    { -912, 200, 192},
    { -816, 24, 64},
    { -848, 40, 72},
    { -896, -56, -64},
    { -808, 64, 0},
    { -1184, 320, 184},
    { -1144, 1456, -152},
    { -1056, 1456, 352},
    { -808, 1520, 192},
    { -448, 1008, 304},
    { -216, 768, 288},
    { -144, 792, 320},
    { -104, 520, 432},
    { 8, 512, 400},
    { 104, 496, 296},
    { 136, 536, 408},
    // 65 seconds
    { 152, 720, 504},
    { 128, 944, 688},
    { 88, 1376, 920},
    { 64, 1424, 768},
    { 136, 936, 568},
    { 200, 864, 280},
    { 128, 712, 344},
    { 128, 712, 184},
    { 32, 528, 88},
    { 16, 336, 0},
    { -8, 328, 24},
    { -32, 312, 16},
    { -64, 248, -40},
    { -224, 216, 48},
    { -640, 352, 200},
    { -1272, 640, 400},
    { -1912, 368, 432},
    { -2528, 1080, -64},
    { -2040, 1000, 48},
    { -1376, 0, 376},
    { -1288, 400, 128},
    { -928, 416, 144},
    { -768, 384, 88},
    { -744, 344, 104},
    { -752, 376, 56},
    // 66 seconds
    { -744, 344, 64},
    { -968, 440, 112},
    { -1056, 528, 280},
    { -1216, 832, 256},
    { -1488, 584, 216},
    { -1200, 552, 0},
    { -1200, 536, 0},
    { -1488, 472, 176},
    { -1488, 360, 240},
    { -1232, 264, 224},
    { -1128, 184, 248},
    { -1136, 176, 216},
    { -1160, 176, 192},
    { -1112, 136, 192},
    { -1264, -16, 280},
    { -1208, -280, 352},
    { -992, -88, 168},
    { -1032, -96, 240},
    { -1080, 200, 64},
    { -1096, 272, -96},
    { -1456, 200, -8},
    { -1672, 200, 120},
    { -1560, 304, 88},
    { -1264, 408, -88},
    { -1040, 352, -40},
    // 67 seconds
    { -1096, 376, -48},
    { -1072, 392, -64},
    { -896, 352, -64},
    { -992, 440, -88},
    { -1096, 520, 32},
    { -1640, 472, 56},
    { -1352, 328, -8},
    { -1232, 352, -56},
    { -1360, 456, -32},
    { -1656, 328, 104},
    { -1488, 144, 112},
    { -1232, -72, 56},
    { -1200, 40, 8},
    { -1240, 120, 32},
    { -1256, 120, 32},
    { -1472, 48, 216},
    { -1288, -312, 344},
    { -1056, -240, 80},
    { -1104, -144, 8},
    { -1048, 0, -208},
    { -1168, -16, -88},
    { -1320, -72, -88},
    { -1208, -64, -120},
    { -1136, 40, -232},
    { -1120, 112, -128},
    // 68 seconds
    { -1200, 160, 64},
    { -1328, 320, 40},
    { -1288, 496, -200},
    { -1232, 456, -184},
    { -1344, 448, -168},
    { -1560, 288, -80},
    { -1520, 424, -128},
    { -1072, 304, -168},
    { -1216, 328, -88},
    { -1392, 352, 48},
    { -1480, 288, 88},
    { -1304, 152, 80},
    { -1136, 16, 128},
    { -1120, 56, 96},
    { -1104, 96, 56},
    { -1080, 136, 120},
    { -1120, 168, 176},
    { -1272, -80, 248},
    { -1080, -200, 208},
    { -1288, 48, 104},
    { -1160, 232, -240},
    { -1184, 240, -224},
    { -1360, 120, -136},
    { -1248, -152, -80},
    { -1104, -56, -64},
    // 69 seconds
    { -952, 216, -24},
    { -976, 376, 16},
    { -1152, 448, -56},
    { -1184, 360, -8},
    { -1184, 472, -56},
    { -1200, 880, -32},
    { -1248, 192, -40},
    { -1592, 392, -32},
    { -1152, 392, -96},
    { -1136, 456, -88},
    { -1312, 464, 8},
    { -1400, 304, 40},
    { -1200, 200, 16},
    { -1064, 112, 0},
    { -1064, 64, -16},
    { -1144, 88, 8},
    { -1080, 120, 8},
    { -1200, 120, 64},
    { -1312, -192, 224},
    { -952, -152, 40},
    { -1272, 120, -72},
    { -1128, 176, -112},
    { -1104, 128, -152},
    { -1304, 88, -96},
    { -1168, -16, -112},
    // 70 seconds
    { -1016, 24, -128},
    { -896, 96, 16},
    { -960, 304, -64},
    { -1128, 344, -112},
    { -1152, 328, -120},
    { -1200, 432, -184},
    { -1256, 688, -272},
    { -1152, 248, -248},
    { -1800, 312, -224},
    { -1248, 336, -264},
    { -1160, 312, -232},
    { -1392, 296, -96},
    { -1376, 240, -48},
    { -1176, 168, -24},
    { -1104, 120, 64},
    { -1104, 80, 136},
    { -1056, 56, 128},
    { -952, 72, 88},
    { -936, 104, 120},
    { -1184, -184, 288},
    { -1024, -112, 200},
    { -1232, 32, 232},
    { -1240, 192, -160},
    { -1064, 120, -272},
    { -1320, 104, 0},
    // 71 seconds
    { -1488, 200, -136},
    { -1304, 272, -160},
    { -1072, 392, -48},
    { -944, 360, 80},
    { -984, 336, -24},
    { -1056, 344, 16},
    { -1016, 568, 56},
    { -1136, 472, 32},
    { -1064, 608, 24},
    { -1376, 632, 8},
    { -1264, 408, -24},
    { -1048, 416, -88},
    { -1344, 448, 32},
    { -1640, 408, 136},
    { -1304, 280, 8},
    { -1072, 216, 8},
    { -1456, -128, 96},
    { -1392, 56, 176},
    { -1072, 88, 104},
    { -1120, 80, 136},
    { -1216, -64, 192},
    { -1304, -216, 216},
    { -1200, 32, 96},
    { -1224, 240, -280},
    { -1216, 232, -232},
    // 72 seconds
    { -1256, 72, -32},
    { -1200, -144, -40},
    { -1016, 56, -144},
    { -872, 184, -104},
    { -840, 296, -40},
    { -1064, 336, -128},
    { -1144, 360, -112},
    { -1304, 576, -160},
    { -1392, 872, -168},
    { -1416, 208, -240},
    { -1544, 368, -192},
    { -1152, 408, -184},
    { -1168, 384, -96},
    { -1312, 320, 56},
    { -1248, 192, 56},
    { -1008, 160, -8},
    { -944, 96, 56},
    { -984, 272, 96},
    { -1048, 96, 152},
    { -1096, 184, 136},
    { -1296, -144, 328},
    { -1256, -216, 16},
    { -1208, -304, 80},
    { -1464, 112, -232},
    { -1264, 240, -584},
    // 73 seconds
    { -1296, 248, -304},
    { -1184, -328, 96},
    { -1208, -152, 120},
    { -1104, 240, 64},
    { -864, 400, 40},
    { -768, 392, -32},
    { -840, 312, -16},
    { -888, 280, -48},
    { -1112, 344, -40},
    { -1328, 472, 40},
    { -1512, 808, -32},
    { -1648, 120, -112},
    { -1064, 208, -224},
    { -1232, 464, -168},
    { -1352, 360, -16},
    { -1328, 200, 8},
    { -1072, 112, 24},
    { -936, 120, 72},
    { -936, 104, 96},
    { -1000, 72, 112},
    { -1088, 176, 104},
    { -1408, -40, 264},
    { -1272, -104, 248},
    { -1232, -136, 224},
    { -1328, 40, 8},
    // 74 seconds
    { -1208, 112, -184},
    { -1256, -16, -88},
    { -1216, -88, -64},
    { -1104, 32, -64},
    { -992, 144, -72},
    { -832, 224, 8},
    { -880, 312, 80},
    { -1056, 416, 72},
    { -1088, 560, -8},
    { -1104, 632, -8},
    { -1064, 888, -96},
    { -1456, 408, -16},
    { -1528, 440, -200},
    { -1200, 544, -376},
    { -1352, 312, -280},
    { -1376, 224, -168},
    { -1400, 280, -120},
    { -1232, 200, -72},
    { -1120, 200, 48},
    { -1072, 208, 40},
    { -1048, 224, 96},
    { -992, 200, 96},
    { -1008, 400, -32},
    { -1208, 712, 96},
    { -1080, -256, 608},
    // 75 seconds
    { -1168, -304, 688},
    { -1416, -152, 16},
    { -1664, -240, -280},
    { -1704, -112, 224},
    { -1456, 304, 8},
    { -1296, 744, -136},
    { -992, 520, 24},
    { -952, 640, -16},
    { -1000, 720, -168},
    { -1112, 544, -64},
    { -1088, 488, -64},
    { -1080, 736, -280},
    { -1032, 552, -120},
    { -1416, 696, -72},
    { -1232, 720, -152},
    { -1216, 568, -88},
    { -1456, 472, 88},
    { -1696, 408, 232},
    { -1776, 432, 232},
    { -1616, 296, 288},
    { -1440, 216, 288},
    { -1320, 168, 264},
    { -1192, 160, 224},
    { -1064, 168, 184},
    { -1096, 136, 184},
    // 76 seconds
    { -1008, -64, 128},
    { -824, -248, 168},
    { -920, -72, -80},
    { -1000, 208, -264},
    { -1304, 264, -320},
    { -1648, -32, -120},
    { -1816, 8, 88},
    { -1680, 368, 192},
    { -1272, 672, 288},
    { -1120, 696, 40},
    { -1344, 560, 96},
    { -1120, 400, 120},
    { -1168, 360, 176},
    { -1160, 656, 136},
    { -1160, 1136, 80},
    { -1240, 216, -136},
    { -952, 360, -256},
    { -1168, 560, -88},
    { -1464, 544, 136},
    { -1440, 288, 80},
    { -1224, 144, 16},
    { -1288, 200, 88},
    { -1440, 144, 184},
    { -1512, -8, 216},
    { -1416, 88, 168},
    // 77 seconds
    { -1408, 104, 152},
    { -1336, -184, 176},
    { -1184, -480, 168},
    { -1024, -64, -176},
    { -1032, -24, -280},
    { -1352, 56, -176},
    { -1296, -64, -80},
    { -1120, -144, -56},
    { -1040, 56, -8},
    { -1080, 208, 112},
    { -1256, 376, 32},
    { -1424, 512, -176},
    { -1400, 832, -192},
    { -1152, 608, -400},
    { -1200, 576, -808},
    { -1416, 864, -664},
    { -1488, 576, -216},
    { -1416, 264, -48},
    { -1640, 280, 48},
    { -1712, 352, 104},
    { -1648, 472, 0},
    { -1528, 240, 120},
    { -1440, 56, 168},
    { -1400, 48, 32},
    { -1104, -136, -16},
    // 78 seconds
    { -792, -272, -40},
    { -592, -240, -304},
    { -520, -256, -560},
    { -496, -304, -664},
    { -480, -200, -1000},
    { -616, -296, -952},
    { -704, -320, -864},
    { -752, -272, -640},
    { -640, -240, -320},
    { -568, -224, -200},
    { -624, -80, -88},
    { -656, 80, 80},
    { -752, 152, 192},
    { -944, 264, 256},
    { -1416, 304, 120},
    { -2232, 576, -120},
    { -2320, 1280, 408},
    { -1664, -56, -304},
    { -1448, 400, -792},
    { -1064, 1184, -416},
    { -1040, 616, -352},
    { -1136, 416, -448},
    { -968, 304, -368},
    { -800, 280, -200},
    { -856, 336, 32},
    // 79 seconds
    { -1040, 440, 136},
    { -1184, 824, 408},
    { -1416, 872, 576},
    { -1320, 896, 424},
    { -952, 648, 248},
    { -800, 328, 224},
    { -440, 568, 72},
    { -248, 752, 24},
    { -488, 952, 144},
    { -440, 848, 88},
    { -280, 648, 88},
    { -144, 464, 112},
    { -72, 360, 80},
    { -64, 352, 56},
    { -64, 248, 56},
    { -152, 264, 32},
    { -408, 336, 368},
    { -824, 1200, 600},
    { -1008, 2416, 360},
    { -1016, 1472, 896},
    { -632, 1440, 312},
    { -488, 1088, 264},
    { -448, 928, 272},
    { -512, 872, 184},
    { -464, 744, 120},
    // 80 seconds
    { -416, 552, 112},
    { -408, 472, 104},
    { -432, 352, 120},
    { -504, 336, 80},
    { -864, 464, 168},
    { -1376, 680, 464},
    { -976, 400, 208},
    { -1216, 496, -160},
    { -944, 936, 32},
    { -712, 752, -416},
    { -872, 456, -256},
    { -896, 96, -8},
    { -832, -32, -24},
    { -792, 152, -8},
    { -880, 320, -32},
    { -1000, 432, -80},
    { -1176, 400, -48},
    { -1144, 512, 40},
    { -1144, 648, -56},
    { -1464, 632, -144},
    { -1632, 688, -8},
    { -1080, 608, -40},
    { -1360, 432, 64},
    { -1392, 368, 32},
    { -1040, 368, -96},
    // 81 seconds
    { -816, 320, -88},
    { -872, 232, 56},
    { -952, 128, 128},
    { -960, 88, 88},
    { -928, 104, 80},
    { -968, 64, 144},
    { -1072, -64, 128},
    { -1112, 32, 16},
    { -1288, 192, -208},
    { -1144, 280, -336},
    { -1320, 56, -152},
    { -1296, -240, -16},
    { -1200, -32, -144},
    { -992, 248, -232},
    { -816, 288, -128},
    { -920, 312, -136},
    { -1016, 248, -136},
    { -984, 232, -160},
    { -1160, 296, -168},
    { -1304, 464, -112},
    { -1432, 328, -168},
    { -1688, 232, -120},
    { -1232, 280, -168},
    { -1200, 336, -176},
    { -1384, 304, -88},
    // 82 seconds
    { -1312, 240, -80},
    { -1056, 128, -88},
    { -952, 16, 16},
    { -912, 24, 32},
    { -976, 48, 64},
    { -968, 64, 96},
    { -1104, 88, 176},
    { -1096, -88, 280},
    { -1064, -8, 224},
    { -1248, 192, 40},
    { -1104, 304, -208},
    { -1200, 328, -240},
    { -1352, -56, -144},
    { -1320, -288, -136},
    { -1152, -8, -200},
    { -992, 216, -128},
    { -936, 280, -8},
    { -976, 304, 72},
    { -920, 328, -8},
    { -912, 272, -32},
    { -1200, 296, 8},
    { -1344, 400, 56},
    { -1656, 440, -88},
    { -1032, 256, -224},
    { -1184, 360, -104},
    // 83 seconds
    { -1416, 328, 0},
    { -1288, 152, -56},
    { -1072, 136, -120},
    { -1000, 152, -40},
    { -1072, 176, 64},
    { -1096, 160, 120},
    { -1072, 144, 96},
    { -1264, 168, 200},
    { -1272, -176, 320},
    { -1264, -264, 408},
    { -1400, -64, 304},
    { -1152, 288, -376},
    { -1224, 288, -48},
    { -1352, 152, -136},
    { -1224, 272, -120},
    { -1000, 272, -40},
    { -856, 328, 64},
    { -896, 360, 16},
    { -1000, 384, -24},
    { -920, 376, -48},
    { -1080, 544, -96},
    { -1272, 816, 0},
    { -1392, 360, -208},
    { -1424, 424, -192},
    { -1104, 472, -232},
    // 84 seconds
    { -1280, 448, -40},
    { -1464, 320, 144},
    { -1384, 232, 152},
    { -1144, 168, 120},
    { -1016, 120, 120},
    { -1032, 120, 144},
    { -1096, 56, 160},
    { -1048, 128, 96},
    { -1144, 232, 152},
    { -1288, -128, 256},
    { -1272, -8, 104},
    { -1248, 136, -64},
    { -1016, 464, -424},
    { -936, 152, -288},
    { -1096, -264, -168},
    { -1104, -320, -160},
    { -1032, -16, -152},
    { -944, 152, -96},
    { -984, 256, -96},
    { -1128, 288, -184},
    { -1088, 360, -168},
    { -1192, 544, -264},
    { -1200, 496, -248},
    { -1744, 512, -192},
    { -1408, 440, -200},
    // 85 seconds
    { -1072, 432, -256},
    { -1216, 352, -160},
    { -1408, 392, -40},
    { -1264, 352, -24},
    { -992, 336, -24},
    { -912, 280, 0},
    { -936, 312, 16},
    { -944, 224, 32},
    { -848, 136, 120},
    { -1016, 344, -248},
    { -744, -288, 168},
    { -928, 16, -224},
    { -1392, -32, -192},
    { -1400, 96, -296},
    { -1248, 208, -592},
    { -1328, 8, -344},
    { -1368, 96, -144},
    { -1168, 216, -112},
    { -920, 208, -96},
    { -856, 184, -32},
    { -944, 280, -24},
    { -992, 288, -48},
    { -928, 280, -64},
    { -1184, 424, -160},
    { -1200, 1200, -120},
    // 86 seconds
    { -1440, 104, -192},
    { -1304, 352, -256},
    { -1000, 432, -184},
    { -1416, 512, -40},
    { -1600, 296, 16},
    { -1464, 264, -88},
    { -1240, 216, -32},
    { -1160, 120, 80},
    { -1112, 48, 88},
    { -1016, 40, 32},
    { -976, 16, 40},
    { -1024, -80, 152},
    { -1008, -96, 160},
    { -1168, -64, 136},
    { -1352, 128, 48},
    { -1168, 200, -136},
    { -1296, 280, -224},
    { -1304, 96, 24},
    { -1216, -160, 88},
    { -1032, 8, -56},
    { -928, 240, -136},
    { -992, 288, -88},
    { -1120, 360, -200},
    { -1144, 336, -192},
    { -1328, 504, -272},
    // 87 seconds
    { -1232, 768, -160},
    { -1416, 120, -248},
    { -1520, 424, -144},
    { -1056, 504, -184},
    { -1160, 384, -184},
    { -1304, 296, -24},
    { -1424, 232, 56},
    { -1232, 200, 64},
    { -1072, 144, 80},
    { -1016, 112, 104},
    { -1120, 32, 152},
    { -1008, 104, 104},
    { -1136, 104, 160},
    { -1248, -112, 176},
    { -1176, -216, 136},
    { -1240, 64, -112},
    { -1128, 96, -328},
    { -1320, 224, -376},
    { -1360, -24, -232},
    { -1120, -144, -144},
    { -936, 136, -128},
    { -840, 272, -48},
    { -976, 368, -48},
    { -1152, 384, -56},
    { -1128, 368, -56},
    // 88 seconds
    { -1056, 432, -80},
    { -1160, 1024, -104},
    { -1032, 64, -112},
    { -1520, 344, -144},
    { -1440, 472, -64},
    { -1008, 440, -200},
    { -1088, 400, -64},
    { -1336, 304, 88},
    { -1312, 208, 128},
    { -1088, 152, 128},
    { -1016, 72, 136},
    { -1016, 64, 152},
    { -1000, 72, 144},
    { -1016, 88, 144},
    { -1136, 88, 200},
    { -1056, 48, 272},
    { -848, 104, 208},
    { -1264, 600, 112},
    { -992, 928, 8},
    { -736, 904, 80},
    { -832, 1144, -32},
    { -880, 944, 40},
    { -672, 712, 96},
    { -448, 552, 16},
    { -352, 488, 96},
    // 89 seconds
    { -296, 376, 160},
    { -224, 544, 128},
    { -144, 568, 240},
    { -48, 592, 272},
    { -136, 1000, 400},
    { -280, 1272, 744},
    { -384, 1288, 672},
    { -264, 1064, 640},
    { -240, 992, 696},
    { -216, 928, 544},
    { -176, 704, 440},
    { -152, 584, 352},
    { -136, 568, 256},
    { -136, 464, 216},
    { -144, 344, 176},
    { -176, 304, 112},
    { -304, 264, 120},
    { -568, 344, 96},
    { -1016, 504, 240},
    { -1560, 600, 560},
    { -1696, 624, 80},
    { -1696, 1088, -96},
    { -1352, 816, 248},
    { -1104, 416, 208},
    { -960, 408, 264},
    // 90 seconds
    { -864, 392, 240},
    { -840, 408, 216},
    { -824, 368, 240},
    { -680, 408, 192},
    { -712, 368, 120},
    { -1040, 416, 56},
    { -1176, 424, 152},
    { -1512, 608, -64},
    { -1248, 296, -80},
    { -1200, 384, -136},
    { -1440, 464, -56},
    { -1472, 376, 24},
    { -1304, 288, 48},
    { -1168, 232, 120},
    { -1064, 144, 144},
    { -1016, 104, 96},
    { -976, 96, 104},
    { -912, 72, 128},
    { -960, 56, 176},
    { -1008, -56, 216},
    { -1008, -64, 184},
    { -1136, 88, 80},
    { -1176, 296, -152},
    { -1096, 376, -272},
    { -1304, 296, -224},
    // 91 seconds
    { -1424, -128, -160},
    { -1336, -208, -72},
    { -1152, 40, -32},
    { -984, 312, 40},
    { -1040, 408, 16},
    { -1064, 384, -40},
    { -888, 320, -96},
    { -888, 312, -104},
    { -1112, 472, 8},
    { -1160, 520, 8},
    { -1656, 392, -32},
    { -1312, 344, -56},
    { -1304, 368, -80},
    { -1448, 440, -56},
    { -1464, 360, -8},
    { -1352, 208, 8},
    { -1264, 72, 88},
    { -1176, 32, 168},
    { -1072, 56, 24},
    { -976, 72, 0},
    { -872, 88, 72},
    { -896, 88, 120},
    { -888, 64, 112},
    { -960, 80, 48},
    { -1144, 96, -40},
    // 92 seconds
    { -1120, 256, -272},
    { -1128, 208, -240},
    { -1408, 0, -192},
    { -1496, -64, -48},
    { -1320, 80, -104},
    { -1056, 240, -32},
    { -952, 320, 48},
    { -1032, 288, 80},
    { -1048, 264, 16},
    { -968, 248, -32},
    { -1248, 296, -24},
    { -1272, 592, 56},
    { -1544, 760, -72},
    { -1384, 176, -88},
    { -1032, 192, -152},
    { -1272, 432, -56},
    { -1416, 440, 48},
    { -1312, 296, 48},
    { -1128, 168, 88},
    { -1096, 112, 160},
    { -1120, 56, 176},
    { -1136, 64, 136},
    { -1096, 96, 80},
    { -1184, 40, 256},
    { -1176, -280, 336},
    // 93 seconds
    { -1056, -120, 152},
    { -1328, 88, 64},
    { -1216, 336, -304},
    { -1024, 224, -168},
    { -1224, 8, -136},
    { -1216, -248, -32},
    { -1096, -40, 16},
    { -968, 224, 88},
    { -944, 360, 96},
    { -1088, 456, 0},
    { -1104, 376, 8},
    { -1136, 424, -48},
    { -1240, 640, -96},
    { -1184, 296, -112},
    { -1672, 296, -96},
    { -1240, 344, -80},
    { -1224, 368, -80},
    { -1424, 368, 48},
    { -1456, 280, 56},
    { -1192, 224, 24},
    { -1032, 144, 88},
    { -1000, 128, 104},
    { -1056, 128, 80},
    { -1128, 128, 56},
    { -1248, 40, 200},
    // 94 seconds
    { -1208, -144, 400},
    { -896, -160, 288},
    { -1304, 48, 120},
    { -1192, 120, -8},
    { -1080, 72, -72},
    { -1256, 56, -24},
    { -1256, -40, 32},
    { -1168, -8, -48},
    { -984, 168, -48},
    { -920, 224, 24},
    { -1040, 384, -32},
    { -1232, 392, -152},
    { -1232, 528, -256},
    { -1256, 1336, -424},
    { -1104, -184, 40},
    { -1704, 0, 24},
    { -1280, 400, -136},
    { -1232, 328, -96},
    { -1472, 344, 96},
    { -1536, 256, 160},
    { -1208, 224, 0},
    { -968, 192, 16},
    { -952, 280, 200},
    { -1072, 232, 288},
    { -1096, 144, 248},
    // 95 seconds
    { -1056, 88, 272},
    { -1144, -80, 392},
    { -960, -104, 248},
    { -1080, 40, 232},
    { -1160, 240, -184},
    { -1328, 328, -160},
    { -1608, -40, 24},
    { -1480, -264, 24},
    { -1280, 152, -64},
    { -992, 360, -24},
    { -784, 320, 48},
    { -880, 328, 56},
    { -1016, 312, 56},
    { -944, 384, 112},
    { -1184, 640, -24},
    { -1048, 1040, 72},
    { -1776, 736, 184},
    { -1216, 200, 8},
    { -1056, 440, -192},
    { -1296, 440, -40},
    { -1432, 224, 48},
    { -1480, 368, -16},
    { -1360, 480, 56},
    { -1296, 256, 192},
    { -1224, 376, 120},
    // 96 seconds
    { -944, 280, 128},
    { -736, 192, 96},
    { -656, 112, 184},
    { -528, 40, 424},
    { -456, 24, 16},
    { -960, 768, 400},
    { -736, 1696, 136},
    { -408, 1672, 32},
    { -312, 1488, -168},
    { -248, 1040, -80},
    { -160, 952, -32},
    { -32, 672, 64},
    { 56, 576, 112},
    { 104, 480, 96},
    { 152, 496, 120},
    { 216, 528, 88},
    { 256, 656, 160},
    { 280, 992, 264},
    { 400, 1272, 464},
    { 472, 1264, 344},
    { 504, 1184, 112},
    { 488, 760, 80},
    { 424, 608, 112},
    { 360, 544, -8},
    { 216, 400, 0},
    // 97 seconds
    { 24, 376, -104},
    { -80, 296, -80},
    { -160, 160, -8},
    { -368, 216, 192},
    { -664, 728, -80},
    { -976, 432, 128},
    { -1544, 208, 80},
    { -2184, 104, 96},
    { -2464, 240, 72},
    { -1912, 312, -400},
    { -1344, 264, -224},
    { -1272, 176, -112},
    { -1096, 112, 16},
    { -832, 176, 80},
    { -680, 232, 56},
    { -640, 256, 40},
    { -704, 264, 0},
    { -664, 304, -32},
    { -808, 336, -8},
    { -1224, 440, 32},
    { -1312, 728, 8},
    { -1536, 216, -144},
    { -1360, 144, -168},
    { -1616, 432, -96},
    { -1576, 456, -64},
    // 98 seconds
    { -1352, 304, -128},
    { -1168, 176, 0},
    { -1088, 48, 96},
    { -1008, -32, 80},
    { -952, 48, 32},
    { -888, 56, 16},
    { -904, 56, 128},
    { -872, -184, 336},
    { -1032, 304, 152},
    { -1264, 232, 128},
    { -1152, 560, -456},
    { -1104, 624, -632},
    { -1256, 448, -352},
    { -1328, -88, -48},
    { -1120, 0, 0},
    { -824, 288, -40},
    { -752, 440, -80},
    { -864, 400, -144},
    { -912, 392, -96},
    { -984, 560, -88},
    { -1128, 608, -152},
    { -1176, 984, -88},
    { -1608, 712, -88},
    { -1224, 568, -192},
    { -1120, 536, -232},
    // 99 seconds
    { -1320, 448, -88},
    { -1384, 368, 24},
    { -1176, 296, -24},
    { -1016, 224, 8},
    { -672, 8, -8},
    { -952, 136, 128},
    { -1048, 112, 112},
    { -1016, 152, 144},
    { -1024, 168, 152},
    { -920, 32, 136},
    { -1112, 56, 184},
    { -1288, 240, -152},
    { -1120, 416, -416},
    { -1344, 64, -312},
    { -1432, -40, -48},
    { -1344, 48, 48},
    { -1072, 272, 80},
    { -848, 368, 112},
    { -864, 408, 80},
    { -936, 352, 64},
    { -864, 376, 16},
    { -968, 416, -24},
    { -1224, 504, 80},
    { -1120, 1040, -40},
    { -1664, 376, -256},
    // 100 seconds
    { -1280, 528, -328},
    { -1288, 512, -352},
    { -1424, 376, -232},
    { -1512, 304, -160},
    { -1336, 288, -120},
    { -1112, 208, -64},
    { -1048, 160, 32},
    { -1024, 152, -48},
    { -1000, 72, 8},
    { -1000, 224, 48},
    { -1088, 112, 112},
    { -1064, 248, -72},
    { -1096, -72, -104},
    { -1072, -80, 24},
    { -1104, 400, -328},
    { -1216, 480, -536},
    { -1288, 280, -424},
    { -1216, 240, -328},
    { -1008, 264, -208},
    { -904, 256, -48},
    { -1000, 336, 0},
    { -1096, 360, -48},
    { -1008, 344, -72},
    { -1048, 440, -112},
    { -1240, 544, -24},
    // 101 seconds
    { -1448, 768, 72},
    { -1496, 840, -24},
    { -1048, 616, -168},
    { -912, 520, -200},
    { -1080, 528, -144},
    { -1248, 392, -32},
    { -1176, 256, 40},
    { -1064, 264, -136},
    { -1088, 376, -112},
    { -1104, 272, -96},
    { -1048, 216, -120},
    { -1168, 128, -56},
    { -1192, -72, -16},
    { -1040, -176, -72},
    { -1264, -24, -112},
    { -1296, 216, -432},
    { -1296, 256, -488},
    { -1216, 160, -392},
    { -1080, 248, -296},
    { -880, 184, -216},
    { -752, 128, -32},
    { -768, 224, -24},
    { -1040, 336, -40},
    { -1176, 336, 72},
    { -1160, 472, 200},
    // 102 seconds
    { -1200, 1248, -24},
    { -1032, 344, 24},
    { -1624, 256, 136},
    { -1200, 616, -72},
    { -1024, 552, -216},
    { -1296, 512, 16},
    { -1496, 416, 128},
    { -1328, 256, 96},
    { -1120, 184, 80},
    { -1040, 104, 72},
    { -1064, 160, 96},
    { -1048, 224, 104},
    { -1120, 272, 48},
    { -1184, 24, 152},
    { -824, -160, 88},
    { -1104, 0, -128},
    { -1168, 344, -416},
    { -1240, 384, -456},
    { -1376, -56, -112},
    { -1320, -168, 136},
    { -1168, 80, 24},
    { -984, 312, -32},
    { -896, 320, 120},
    { -1048, 360, 88},
    { -1240, 408, 8},
    // 103 seconds
    { -1168, 448, -32},
    { -1248, 1184, -136},
    { -1048, 480, -128},
    { -1288, 712, -64},
    { -1480, 864, 96},
    { -1240, 704, 32},
    { -1448, 496, 152},
    { -1544, 376, 224},
    { -1400, 288, 184},
    { -1192, 240, 184},
    { -1088, 80, 240},
    { -1056, 64, 200},
    { -1080, 96, 184},
    { -1104, 112, 184},
    { -1224, -232, 248},
    { -1008, -424, 224},
    { -1032, -32, 96},
    { -1480, 80, 144},
    { -1336, 344, -144},
    { -1472, 264, -56},
    { -1568, 120, 88},
    { -1392, 208, 120},
    { -1192, 312, 136},
    { -1032, 384, 176},
    { -1088, 456, 48},
    // 104 seconds
    { -1200, 464, 48},
    { -1168, 544, 64},
    { -1016, 656, 40},
    { -1000, 488, -56},
    { -1080, 592, -48},
    { -1488, 640, 80},
    { -1232, 440, 40},
    { -1400, 392, -8},
    { -1584, 392, 88},
    { -1592, 352, 136},
    { -1408, 72, 200},
    { -1360, 168, 136},
    { -1344, 144, 248},
    { -1232, 152, 224},
    { -1144, 184, 224},
    { -1112, 104, 280},
    { -1064, 0, 152},
    { -928, -120, 96},
    { -1352, 16, 280},
    { -1120, 304, 104},
    { -1080, 304, -72},
    { -1320, 8, 64},
    { -1408, 232, -24},
    { -1184, 296, 32},
    { -1104, 440, 72},
    // 105 seconds
    { -1248, 432, 144},
    { -1408, 528, 96},
    { -1352, 656, 368},
    { -1128, 968, 256},
    { -1048, 392, -32},
    { -1240, 696, 136},
    { -1432, 712, 384},
    { -1088, 472, 96},
    { -1176, 496, -8},
    { -1416, 456, 120},
    { -1440, 336, 128},
    { -1200, 272, 72},
    { -1192, 224, 104},
    { -1280, 176, 144},
    { -1288, 144, 184},
    { -1224, 160, 176},
    { -1120, 88, 160},
    { -1080, -176, 136},
    { -1080, -320, 160},
    { -1216, 40, -104},
    { -1200, 32, -232},
    { -1384, 160, -232},
    { -1432, 48, -112},
    { -1280, 24, -72},
    { -1080, 176, -80},
    // 106 seconds
    { -920, 208, 48},
    { -1072, 280, 104},
    { -1232, 496, 48},
    { -1192, 576, 48},
    { -1072, 1152, 80},
    { -1024, 832, -8},
    { -1256, 800, -72},
    { -1568, 720, 224},
    { -1104, 728, -24},
    { -1368, 704, 168},
    { -1648, 624, 336},
    { -1536, 720, 328},
    { -1320, 432, 352},
    { -1104, 304, 336},
    { -856, 240, 248},
    { -672, 160, 216},
    { -504, 160, 336},
    { -384, 24, 304},
    { -496, 400, -224},
    { -528, 752, 304},
    { -480, 912, 512},
    { -360, 1280, 480},
    { -208, 1416, 408},
    { -232, 1088, 224},
    { -232, 944, 232},
    // 107 seconds
    { -240, 720, 224},
    { -184, 672, 216},
    { -120, 592, 232},
    { -72, 576, 256},
    { -48, 632, 344},
    { 8, 656, 344},
    { 8, 728, 304},
    { -32, 848, 360},
    { -24, 904, 368},
    { -112, 1144, 520},
    { -32, 1576, 128},
    { -152, 1808, -168},
    { -304, 1448, -304},
    { -368, 424, -304},
    { -360, 104, -744},
    { -296, 160, -712},
    { -240, 0, -656},
    { -248, 104, -728},
    { -224, 136, -864},
    { -256, 24, -848},
    { -264, 40, -968},
    { -256, 0, -992},
    { -256, -96, -1016},
    { -232, -128, -1000},
    { -200, -192, -936},
    // 108 seconds
    { -160, -184, -952},
    { -136, -272, -896},
    { -96, -176, -928},
    { -72, 72, -968},
    { -64, 64, -976},
    { -80, 96, -896},
    { -112, 264, -1000},
    { -120, 248, -952},
    { -136, 464, -984},
    { -120, 376, -1008},
    { -32, 552, -912},
    { 8, 592, -912},
    { 64, 480, -656},
    { -104, 568, -600},
    { 56, 736, -736},
    { 64, 696, -456},
    { 96, 632, -472},
    { 120, 656, -416},
    { 96, 544, -672},
    { 72, 688, -600},
    { 56, 904, -456},
    { 88, 552, -440},
    { 96, 640, -648},
    { 48, 456, -912},
    { -56, 456, -1040},
    // 109 seconds
    { -96, 232, -1040},
    { -128, 200, -1080},
    { -128, 88, -1040},
    { -72, 72, -992},
    { -80, -88, -1016},
    { -112, -152, -968},
    { -88, -144, -1000},
    { -120, -64, -960},
    { -72, -120, -1016},
    { -152, -136, -952},
    { -152, -136, -984},
    { -48, -112, -1040},
    { -56, -152, -976},
    { -216, -136, -1024},
    { -368, 8, -1168},
    { -216, -160, -1064},
    { 8, -72, -1040},
    { -88, -176, -1064},
    { -64, -112, -976},
    { -32, -128, -952},
    { -112, -128, -968},
    { -32, -152, -944},
    { -24, -152, -960},
    { -24, -152, -968},
    { -24, -160, -992},
    // 110 seconds
    { -32, -168, -984},
    { -32, -160, -1000},
    { -32, -184, -992},
    { -32, -152, -976},
    { -24, -192, -992},
    { -24, -176, -992},
    { -16, -192, -984},
    { -16, -184, -992},
    { -24, -168, -976},
    { -16, -168, -992},
    { -8, -184, -976},
    { -8, -160, -984},
    { 0, -168, -992},
    { 0, -176, -992},
    { 8, -168, -984},
    { 8, -176, -984},
    { 8, -176, -1000},
    { 8, -168, -984},
    { 16, -168, -1000},
    { 8, -184, -992},
    { 16, -176, -984},
    { 8, -184, -992},
    { 16, -184, -992},
    { 16, -152, -976},
    { 16, -168, -984},
    // 111 seconds
    { 24, -168, -992},
    { 8, -168, -984},
    { 24, -160, -992},
    { 32, -160, -1000},
    { 32, -176, -992},
    { 24, -168, -976},
    { 32, -176, -992},
    { 40, -176, -984},
    { 40, -184, -992},
    { 32, -176, -976},
    { 32, -160, -992},
    { 24, -152, -984},
    { 32, -152, -992},
    { 32, -152, -1000},
    { 40, -152, -984},
    { 40, -128, -1000},
    { 32, -144, -1000},
    { 40, -144, -992},
    { 40, -136, -992},
    { 40, -136, -992},
    { 48, -136, -992},
    { 48, -128, -1000},
    { 56, -136, -992},
    { 56, -128, -1000},
    { 56, -136, -992},
    // 112 seconds
    { 64, -168, -968},
    { 72, -160, -960},
    { 72, -168, -976},
    { 56, -192, -968},
    { 32, -176, -968},
    { 8, -168, -992},
    { 0, -184, -984},
    { 8, -168, -992},
    { 16, -184, -984},
    { 32, -184, -984},
    { 16, -192, -1000},
    { 16, -176, -992},
    { -8, -192, -984},
    { 0, -176, -992},
    { 8, -176, -1000},
    { -8, -176, -1000},
    { -8, -192, -984},
    { 16, -168, -1008},
    { 16, -176, -992},
    { -56, -184, -984},
    { -32, -184, -992},
    { 0, -192, -1000},
    { -8, -192, -976},
    { 0, -200, -992},
    { 8, -208, -984},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


