/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured: 2015-10-22 10:08:25 local
AccelRawData *activity_sample_walk_200_pbl_28360_1(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_28360_1
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 100
  //> TEST_EXPECTED_MAX 220
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 1080, -40, -192},
    { 1448, 128, -536},
    { 1696, 168, -96},
    { 1960, 416, -144},
    { 2048, 992, -272},
    { 1944, 1032, -64},
    { 1832, 800, -64},
    { 1312, 1320, -144},
    { 816, 1280, -184},
    { 640, 1480, -152},
    { 952, 1352, 40},
    { 1232, 1000, 16},
    { 1528, 816, -80},
    { 1720, 648, -216},
    { 1608, 464, -128},
    { 1592, 392, -72},
    { 1736, 320, -96},
    { 1864, 304, -64},
    { 1800, 224, 112},
    { 1336, 128, 16},
    { 1024, 40, -184},
    { 808, -1336, 280},
    { 760, -120, -232},
    { 760, -104, -472},
    { 1288, -32, 48},
    // 1 seconds
    { 1496, 96, -272},
    { 1512, 192, 120},
    { 1728, 408, -80},
    { 1984, 632, -64},
    { 1896, 1136, -648},
    { 1776, 752, -424},
    { 1296, 792, -584},
    { 896, 1352, -704},
    { 720, 1360, -640},
    { 1144, 1368, -304},
    { 1320, 704, -136},
    { 1712, 536, -120},
    { 1984, 624, -248},
    { 1840, 400, -96},
    { 1632, 304, -24},
    { 1536, 296, -32},
    { 1568, 272, -48},
    { 1640, 304, 24},
    { 1456, 240, 48},
    { 1288, 120, -24},
    { 640, -1496, 104},
    { 632, -200, -24},
    { 848, -312, -424},
    { 1496, -8, 24},
    { 1616, 152, -32},
    // 2 seconds
    { 1896, 344, 16},
    { 1800, 496, -56},
    { 1896, 760, -264},
    { 1968, 912, -376},
    { 1984, 984, -400},
    { 1600, 1496, -200},
    { 848, 1648, -544},
    { 536, 1416, -472},
    { 808, 1384, -320},
    { 984, 1032, -208},
    { 1472, 992, -88},
    { 2048, 912, -112},
    { 1968, 568, -112},
    { 1792, 400, -104},
    { 1744, 400, -96},
    { 1768, 432, -48},
    { 1792, 360, 104},
    { 1488, 264, -8},
    { 1088, 160, -72},
    { 896, -1200, 432},
    { 584, -376, 368},
    { 672, -384, -552},
    { 976, -48, -224},
    { 1192, 176, -48},
    { 1584, 208, 168},
    // 3 seconds
    { 1864, 432, 16},
    { 1992, 680, -152},
    { 1976, 1072, -424},
    { 1840, 840, -432},
    { 1440, 816, -680},
    { 1016, 1648, -728},
    { 832, 1448, -768},
    { 1120, 1168, -440},
    { 960, 744, -296},
    { 1328, 704, -176},
    { 1736, 824, -184},
    { 1824, 584, -64},
    { 1696, 376, -40},
    { 1632, 320, 16},
    { 1720, 384, 0},
    { 1728, 312, 48},
    { 1528, 224, -48},
    { 1160, 240, -104},
    { 936, -512, -56},
    { 896, -552, 8},
    { 600, -424, -240},
    { 928, -8, -424},
    { 1248, 16, -200},
    { 1616, 184, 16},
    { 1664, 352, -104},
    // 4 seconds
    { 1712, 552, -320},
    { 1880, 744, -280},
    { 1920, 1176, -360},
    { 1672, 808, -376},
    { 1240, 1072, -552},
    { 712, 1544, -472},
    { 832, 1296, -416},
    { 896, 1216, -352},
    { 776, 880, -328},
    { 1096, 848, -200},
    { 1680, 992, -112},
    { 1944, 688, -16},
    { 1760, 384, -72},
    { 1680, 368, -72},
    { 1712, 448, -88},
    { 1712, 368, 8},
    { 1624, 304, 40},
    { 1328, 272, -88},
    { 984, -968, 128},
    { 808, -488, 136},
    { 648, -376, -416},
    { 992, -112, -296},
    { 1288, 24, -120},
    { 1608, 104, 72},
    { 1800, 408, 8},
    // 5 seconds
    { 1848, 760, -336},
    { 1848, 1008, -352},
    { 1768, 1032, -248},
    { 1608, 728, -448},
    { 1096, 1352, -560},
    { 776, 1304, -648},
    { 840, 1080, -472},
    { 976, 1072, -464},
    { 1040, 608, -264},
    { 1432, 720, -224},
    { 1744, 776, -80},
    { 1784, 480, 32},
    { 1648, 328, -64},
    { 1584, 360, -48},
    { 1592, 352, -24},
    { 1616, 312, 48},
    { 1464, 296, -80},
    { 1288, 264, -48},
    { 1024, -656, 48},
    { 432, -360, -128},
    { 592, -336, -456},
    { 896, -64, -184},
    { 1200, 208, 0},
    { 1648, 176, 88},
    { 1904, 480, -144},
    // 6 seconds
    { 1936, 792, -224},
    { 1872, 1296, -304},
    { 1728, 520, -304},
    { 1536, 664, -496},
    { 984, 1344, -488},
    { 728, 1288, -456},
    { 768, 1312, -368},
    { 976, 912, -368},
    { 1304, 720, -200},
    { 1552, 752, -184},
    { 1784, 640, -104},
    { 1712, 448, -32},
    { 1608, 368, 8},
    { 1624, 368, -80},
    { 1800, 336, 40},
    { 1536, 232, 104},
    { 1280, 280, -32},
    { 1120, -456, 72},
    { 824, -608, 88},
    { 608, -536, -312},
    { 1072, -64, -384},
    { 1608, 120, -392},
    { 1656, 288, 96},
    { 1640, 232, 112},
    { 1736, 400, 32},
    // 7 seconds
    { 1776, 1008, -344},
    { 1744, 968, -296},
    { 1552, 800, -312},
    { 1240, 968, -320},
    { 936, 984, -464},
    { 808, 992, -392},
    { 1008, 1456, -632},
    { 976, 856, -304},
    { 1312, 728, -168},
    { 1688, 808, -120},
    { 1712, 592, -72},
    { 1616, 384, 32},
    { 1520, 376, -56},
    { 1568, 376, 48},
    { 1720, 400, 96},
    { 1600, 280, 168},
    { 1328, 272, 104},
    { 1136, -768, 192},
    { 328, -352, 128},
    { 488, -696, -40},
    { 1040, 0, -112},
    { 1208, 240, -80},
    { 1448, 232, 88},
    { 1608, 256, 96},
    { 1808, 496, -224},
    // 8 seconds
    { 1880, 792, -176},
    { 1904, 1056, -352},
    { 1752, 592, -312},
    { 1408, 1064, -592},
    { 760, 1400, -896},
    { 752, 1264, -616},
    { 1024, 1168, -368},
    { 1016, 624, -224},
    { 1416, 760, -208},
    { 1888, 840, -88},
    { 1792, 456, 24},
    { 1680, 320, -16},
    { 1616, 360, 0},
    { 1704, 368, 24},
    { 1624, 288, 64},
    { 1384, 216, 56},
    { 1184, 88, 24},
    { 536, -1072, 64},
    { 616, -240, -304},
    { 632, -512, 32},
    { 1120, 120, -232},
    { 1352, 216, -128},
    { 1600, 280, 40},
    { 1784, 352, 0},
    { 1864, 568, -112},
    // 9 seconds
    { 1848, 1112, -248},
    { 1784, 640, -232},
    { 1552, 696, -432},
    { 1128, 1312, -544},
    { 880, 1168, -952},
    { 800, 1144, -528},
    { 888, 1096, -400},
    { 1240, 848, -192},
    { 1840, 864, -88},
    { 2088, 592, 16},
    { 1832, 312, -48},
    { 1648, 352, -64},
    { 1680, 440, -16},
    { 1784, 360, 64},
    { 1568, 240, 120},
    { 1312, 184, 72},
    { 888, -320, 136},
    { 592, -720, 72},
    { 536, -136, -112},
    { 736, -144, -336},
    { 960, -8, -224},
    { 1256, 224, -80},
    { 1208, 136, 168},
    { 1456, 240, 144},
    { 1816, 568, -16},
    // 10 seconds
    { 2112, 856, -200},
    { 2040, 1104, -376},
    { 1624, 840, -368},
    { 1120, 800, -624},
    { 888, 1408, -648},
    { 872, 2016, -560},
    { 1072, 1064, -208},
    { 1368, 936, -192},
    { 1736, 984, -104},
    { 1952, 808, 24},
    { 1960, 792, 344},
    { 2168, 1520, 544},
    { 2680, 816, 472},
    { 2360, 760, 216},
    { 2048, 784, 104},
    { 1328, 560, -24},
    { 792, 408, -152},
    { 808, 416, 40},
    { 696, -192, 224},
    { 360, -248, 64},
    { 544, -280, -56},
    { 560, -536, -248},
    { 272, -808, -144},
    { 128, -840, -304},
    { 88, -792, -448},
    // 11 seconds
    { -16, -920, -360},
    { -8, -984, -376},
    { -8, -1128, -392},
    { 80, -1288, -464},
    { 144, -984, -616},
    { 32, -896, -696},
    { 32, -928, -768},
    { -8, -776, -872},
    { -88, -736, -920},
    { -120, -712, -864},
    { 48, -632, -904},
    { 104, -592, -880},
    { 136, -592, -808},
    { 96, -600, -752},
    { 128, -576, -752},
    { 168, -664, -744},
    { 152, -832, -720},
    { 160, -808, -704},
    { 136, -760, -720},
    { 280, -792, -568},
    { 440, -632, -272},
    { 408, -136, -16},
    { 408, 264, 24},
    { 592, 440, -624},
    { 888, 592, -608},
    // 12 seconds
    { 1264, 488, -336},
    { 1816, 696, 32},
    { 2408, 1064, 208},
    { 2680, 976, 8},
    { 2792, 1552, -424},
    { 2328, 2408, 1128},
    { 1072, 384, 648},
    { 1128, 1264, 256},
    { 576, 1496, 184},
    { 584, 1384, 152},
    { 576, 864, 168},
    { 792, 896, 216},
    { 1248, 920, 176},
    { 1800, 920, 48},
    { 1920, 672, 32},
    { 1800, 528, 48},
    { 1736, 456, 48},
    { 1680, 400, 0},
    { 1552, 408, 48},
    { 1360, 320, 72},
    { 1360, 240, -96},
    { 1176, -936, 240},
    { 720, -472, 384},
    { 896, -296, -488},
    { 1160, -16, -344},
    // 13 seconds
    { 1544, 104, -16},
    { 1592, 216, 104},
    { 1640, 408, -120},
    { 1752, 704, -96},
    { 1760, 1056, -264},
    { 1704, 880, -344},
    { 1400, 904, -216},
    { 1000, 1368, -208},
    { 712, 1248, -72},
    { 808, 1368, -144},
    { 840, 888, -104},
    { 1200, 880, -160},
    { 1720, 904, -176},
    { 1760, 632, -200},
    { 1672, 456, -168},
    { 1648, 408, -88},
    { 1696, 400, -184},
    { 1680, 264, 32},
    { 1528, 256, 8},
    { 1272, 192, -80},
    { 744, -664, 72},
    { 936, -432, -16},
    { 760, -440, -104},
    { 1000, 0, -560},
    { 1272, 0, -224},
    // 14 seconds
    { 1528, 128, -8},
    { 1632, 328, -48},
    { 1888, 664, -296},
    { 2024, 992, -440},
    { 1608, 928, -424},
    { 1224, 768, -208},
    { 832, 1736, -168},
    { 656, 1488, 144},
    { 848, 1400, 272},
    { 920, 1136, 56},
    { 1320, 896, 40},
    { 1704, 904, -40},
    { 1808, 808, -144},
    { 1640, 624, -96},
    { 1656, 536, 8},
    { 1688, 328, -32},
    { 1680, 256, -224},
    { 1552, 216, -128},
    { 1264, 112, -216},
    { 840, -528, 280},
    { 688, -832, -224},
    { 808, -400, 144},
    { 960, 64, -640},
    { 1136, 0, -352},
    { 1536, 104, -72},
    // 15 seconds
    { 1744, 312, 48},
    { 1744, 552, -240},
    { 1680, 896, -424},
    { 1576, 840, -520},
    { 1648, 696, -416},
    { 1224, 1144, -544},
    { 768, 1328, -512},
    { 712, 1304, -448},
    { 864, 1152, -440},
    { 1056, 792, -336},
    { 1352, 912, -376},
    { 1744, 880, -312},
    { 1608, 552, -224},
    { 1568, 368, -88},
    { 1592, 352, -152},
    { 1696, 392, -192},
    { 1664, 280, 24},
    { 1512, 240, 32},
    { 1200, 232, -80},
    { 944, -552, 288},
    { 608, -424, 296},
    { 624, -256, -440},
    { 880, -96, -320},
    { 1136, 120, -80},
    { 1424, 280, 48},
    // 16 seconds
    { 1496, 360, -120},
    { 1768, 592, -192},
    { 1952, 896, -560},
    { 1760, 968, -696},
    { 1360, 704, -584},
    { 1016, 1312, -816},
    { 688, 1432, -808},
    { 1000, 1408, -584},
    { 984, 880, -384},
    { 1256, 672, -248},
    { 1656, 808, -216},
    { 1800, 672, -216},
    { 1608, 448, -96},
    { 1536, 376, -112},
    { 1576, 408, -16},
    { 1512, 368, 64},
    { 1264, 280, 8},
    { 1176, 264, -72},
    { 944, -120, 192},
    { 832, -520, 280},
    { 472, -360, -88},
    { 864, -104, -336},
    { 1200, 96, -256},
    { 1480, 200, 48},
    { 1600, 304, 72},
    // 17 seconds
    { 1792, 512, -112},
    { 1936, 864, -208},
    { 1720, 1072, -648},
    { 1624, 472, -392},
    { 1280, 856, -656},
    { 840, 1192, -784},
    { 736, 1128, -728},
    { 1008, 1240, -520},
    { 1064, 744, -360},
    { 1384, 760, -264},
    { 1688, 800, -272},
    { 1632, 568, -144},
    { 1464, 432, -88},
    { 1464, 408, -72},
    { 1656, 408, -72},
    { 1752, 384, 48},
    { 1432, 264, 72},
    { 1144, 296, -80},
    { 976, -736, 176},
    { 824, -288, 104},
    { 648, -216, -200},
    { 928, 16, -280},
    { 1048, 192, -136},
    { 1264, 232, 64},
    { 1336, 336, 16},
    // 18 seconds
    { 1632, 536, -64},
    { 1992, 872, -144},
    { 1992, 1392, -480},
    { 1616, 912, -312},
    { 1160, 888, -352},
    { 816, 1136, -464},
    { 760, 1536, -560},
    { 696, 1168, -432},
    { 984, 832, -272},
    { 1368, 832, -248},
    { 1648, 704, -256},
    { 1504, 496, -112},
    { 1448, 424, -112},
    { 1632, 448, -144},
    { 1936, 472, 72},
    { 1704, 368, 152},
    { 1360, 312, 80},
    { 1080, -264, 88},
    { 744, -384, 152},
    { 432, -352, -176},
    { 824, -56, -280},
    { 1064, 200, -360},
    { 1312, 296, -144},
    { 1368, 304, 64},
    { 1568, 456, -56},
    // 19 seconds
    { 1856, 848, -168},
    { 1640, 1328, -656},
    { 1480, 752, -424},
    { 1048, 1128, -608},
    { 888, 1464, -808},
    { 864, 1152, -440},
    { 1112, 1152, -336},
    { 1056, 672, -184},
    { 1328, 776, -176},
    { 1600, 864, -192},
    { 1568, 584, -40},
    { 1480, 440, 0},
    { 1480, 384, 8},
    { 1600, 368, -40},
    { 1488, 280, 104},
    { 1264, 288, 8},
    { 1136, -8, 48},
    { 696, -696, 200},
    { 752, -200, -232},
    { 816, -216, -88},
    { 1080, 152, -240},
    { 1448, 264, 56},
    { 1632, 312, 128},
    { 1656, 504, -72},
    { 1736, 760, -128},
    // 20 seconds
    { 1752, 1184, -416},
    { 1656, 744, -288},
    { 1344, 840, -360},
    { 992, 1288, -384},
    { 672, 1440, -432},
    { 848, 1240, -344},
    { 840, 904, -304},
    { 1088, 736, -216},
    { 1456, 912, -184},
    { 1824, 840, -120},
    { 1640, 480, 56},
    { 1528, 344, -16},
    { 1536, 336, -40},
    { 1592, 384, -32},
    { 1560, 368, 136},
    { 1328, 304, 96},
    { 1112, 272, 32},
    { 936, -1024, 160},
    { 576, -240, 32},
    { 840, -296, -264},
    { 1432, -48, 40},
    { 1416, 296, -40},
    { 1496, 280, 72},
    { 1616, 480, -64},
    { 1760, 768, -80},
    // 21 seconds
    { 1704, 1328, -456},
    { 1816, 608, -304},
    { 1472, 880, -368},
    { 1120, 1112, -328},
    { 832, 960, -304},
    { 840, 1144, -568},
    { 792, 768, -432},
    { 1088, 816, -320},
    { 1568, 824, -192},
    { 1600, 536, -72},
    { 1368, 272, 40},
    { 1472, 592, 16},
    { 1616, 1080, 136},
    { 1600, 1192, 232},
    { 1504, 960, -64},
    { 1368, 880, -16},
    { 968, 856, -208},
    { 920, 1016, 288},
    { 664, 792, -288},
    { 1016, 368, -216},
    { 912, -160, -128},
    { 664, -416, -288},
    { 512, -664, -200},
    { 200, -808, -232},
    { 176, -760, -368},
    // 22 seconds
    { 64, -616, -600},
    { -40, -912, -696},
    { 24, -976, -832},
    { 88, -624, -1112},
    { -16, -672, -1200},
    { 16, -456, -1216},
    { -192, -552, -1128},
    { -288, -384, -1080},
    { -184, -248, -1104},
    { -72, -360, -968},
    { -8, -384, -840},
    { -24, -360, -784},
    { -40, -448, -784},
    { -40, -376, -776},
    { -32, -480, -824},
    { 32, -616, -864},
    { -24, -488, -1024},
    { -24, -616, -1224},
    { -40, -440, -1256},
    { -16, -208, -1264},
    { 72, -424, -1048},
    { -8, -328, -944},
    { -104, -376, -856},
    { -176, -408, -792},
    { -160, -360, -824},
    // 23 seconds
    { -224, -440, -864},
    { -200, -432, -944},
    { -120, -480, -968},
    { -128, -528, -936},
    { -128, -568, -928},
    { -160, -536, -912},
    { -192, -544, -928},
    { -208, -496, -952},
    { -232, -368, -1016},
    { -200, -400, -984},
    { -272, -288, -960},
    { -312, -232, -1000},
    { -240, -312, -984},
    { -240, -288, -936},
    { -208, -336, -944},
    { -232, -328, -960},
    { -272, -304, -960},
    { -288, -280, -968},
    { -288, -288, -984},
    { -272, -224, -1032},
    { -280, -216, -1040},
    { -280, -248, -1000},
    { -280, -280, -984},
    { -312, -256, -992},
    { -312, -304, -976},
    // 24 seconds
    { -328, -248, -976},
    { -328, -280, -960},
    { -336, -272, -968},
    { -336, -248, -984},
    { -376, -216, -968},
    { -392, -200, -928},
    { -392, -200, -960},
    { -416, -168, -960},
    { -400, -192, -960},
    { -376, -184, -976},
    { -352, -248, -976},
    { -344, -216, -992},
    { -336, -232, -992},
    { -328, -240, -1000},
    { -328, -248, -976},
    { -336, -264, -968},
    { -344, -232, -976},
    { -336, -264, -968},
    { -352, -224, -960},
    { -352, -224, -968},
    { -344, -248, -968},
    { -336, -256, -944},
    { -344, -264, -944},
    { -352, -240, -952},
    { -352, -192, -928},
    // 25 seconds
    { -352, -192, -944},
    { -392, -104, -1016},
    { -392, -56, -992},
    { -424, 16, -1016},
    { -408, -32, -968},
    { -408, -48, -968},
    { -424, -24, -984},
    { -432, -40, -928},
    { -400, -72, -928},
    { -368, -128, -1008},
    { -304, -88, -1000},
    { -224, -80, -888},
    { -216, 112, -784},
    { -344, 376, -736},
    { -360, 680, -600},
    { -488, 824, -416},
    { -496, 864, -336},
    { -512, 888, -352},
    { -400, 752, -280},
    { -496, 808, -264},
    { -472, 888, -312},
    { -480, 840, -224},
    { -560, 968, -160},
    { -496, 904, -240},
    { -504, 744, -168},
    // 26 seconds
    { -520, 736, -96},
    { -544, 912, -56},
    { -432, 848, -64},
    { -400, 888, 48},
    { -432, 752, -16},
    { -368, 768, 312},
    { -488, 920, 496},
    { -360, 976, 464},
    { -344, 888, 368},
    { -360, 880, 472},
    { -368, 928, 288},
    { -272, 856, 328},
    { -336, 832, 272},
    { -248, 1008, 96},
    { -248, 744, 48},
    { -272, 680, 8},
    { -312, 800, 264},
    { -360, 880, 200},
    { -288, 712, 232},
    { -320, 960, 0},
    { -320, 800, 232},
    { -288, 1008, -80},
    { -328, 816, 72},
    { -288, 888, 272},
    { -216, 952, 16},
    // 27 seconds
    { -280, 1296, 96},
    { -328, 1152, 352},
    { -360, 1176, 368},
    { -408, 608, 440},
    { -488, 832, 264},
    { -280, 472, 40},
    { -104, 784, -152},
    { -176, 1104, 96},
    { -248, 1096, -32},
    { -120, 760, -168},
    { -160, 944, -144},
    { -208, 888, -128},
    { -200, 888, -152},
    { -192, 768, -120},
    { -208, 888, 8},
    { -176, 1008, 16},
    { -40, 1200, 64},
    { -64, 1040, 88},
    { -32, 920, 104},
    { 0, 920, 80},
    { -16, 872, 56},
    { -32, 880, 64},
    { -64, 912, 64},
    { -48, 888, 72},
    { -48, 856, 80},
    // 28 seconds
    { -24, 848, 64},
    { 24, 928, 40},
    { 8, 960, 32},
    { 8, 944, 48},
    { -8, 888, 48},
    { 0, 904, 56},
    { -8, 904, 48},
    { -8, 912, 24},
    { -8, 936, 40},
    { 0, 936, 48},
    { 8, 920, 32},
    { 24, 912, 40},
    { 16, 928, 56},
    { 16, 936, 56},
    { 24, 920, 48},
    { 0, 920, 48},
    { 8, 928, 32},
    { 0, 928, 32},
    { 16, 928, 48},
    { -24, 920, 80},
    { -16, 920, 80},
    { 24, 904, 24},
    { 24, 936, 0},
    { 0, 928, 32},
    { -24, 928, 80},
    // 29 seconds
    { -32, 928, 96},
    { -16, 944, 64},
    { -8, 944, 32},
    { 16, 928, 32},
    { -8, 912, 24},
    { -16, 928, 40},
    { -8, 944, 56},
    { -8, 912, 72},
    { -24, 904, 56},
    { -40, 928, 40},
    { -16, 944, 16},
    { -16, 960, 16},
    { -8, 944, 56},
    { -8, 904, 80},
    { -8, 904, 56},
    { -8, 928, 16},
    { -16, 952, 16},
    { -32, 944, 56},
    { -16, 896, 64},
    { -8, 920, 32},
    { -8, 944, 24},
    { -8, 920, 24},
    { -32, 912, 64},
    { -40, 920, 64},
    { -16, 944, 24},
    // 30 seconds
    { -24, 968, 32},
    { 0, 912, 48},
    { -16, 904, 56},
    { -8, 896, 24},
    { -48, 944, 24},
    { -56, 936, 16},
    { -64, 928, 40},
    { -32, 936, -104},
    { -184, 968, -160},
    { -408, 1000, -152},
    { -528, 1080, -104},
    { -488, 1000, -24},
    { -344, 1104, -56},
    { -280, 1048, 56},
    { 288, 944, -592},
    { 288, 432, -584},
    { 320, 72, -936},
    { 232, -80, -1136},
    { 168, 152, -1128},
    { 48, -64, -1008},
    { -24, -120, -912},
    { -216, -24, -968},
    { -144, -64, -960},
    { -144, 24, -976},
    { -104, -72, -1040},
    // 31 seconds
    { -168, -88, -1048},
    { -168, -32, -1016},
    { -200, -88, -1016},
    { -192, -40, -1008},
    { -152, -176, -1008},
    { -168, -64, -1032},
    { -152, -56, -1008},
    { -224, -80, -1080},
    { -216, -128, -1056},
    { -288, 16, -1064},
    { -232, -8, -1024},
    { -272, -112, -1040},
    { -248, -8, -968},
    { -272, -56, -984},
    { -296, -64, -1000},
    { -352, -64, -1056},
    { -424, -120, -904},
    { -376, -16, -936},
    { -320, 0, -968},
    { -280, 32, -1016},
    { -280, -8, -1024},
    { -240, -8, -968},
    { -216, -128, -1032},
    { -520, -104, -1008},
    { 344, -152, -1152},
    // 32 seconds
    { -304, -224, -1000},
    { -256, -104, -1024},
    { -232, -96, -1008},
    { -232, -184, -1000},
    { -304, -128, -1008},
    { -272, -176, -1008},
    { -280, -192, -1008},
    { -368, -200, -944},
    { -272, -208, -952},
    { -8, -176, -1104},
    { -232, -208, -984},
    { -128, -216, -1032},
    { -104, -120, -1032},
    { -136, -328, -1064},
    { -192, -24, -1048},
    { -128, -120, -1072},
    { -192, -136, -1040},
    { -264, 40, -1112},
    { -312, -80, -984},
    { -264, -48, -992},
    { -280, -40, -992},
    { -304, -56, -1000},
    { -320, -56, -992},
    { -320, -56, -968},
    { -312, -128, -976},
    // 33 seconds
    { -288, -104, -960},
    { -280, -120, -968},
    { -296, -96, -1016},
    { -328, -72, -968},
    { -224, -128, -1024},
    { -272, -120, -1016},
    { -256, -104, -1024},
    { -248, -96, -1016},
    { -264, -120, -1016},
    { -256, -136, -1032},
    { -232, -160, -1064},
    { -304, 8, -944},
    { -280, -176, -1040},
    { -280, -48, -992},
    { -272, -64, -992},
    { -272, -96, -984},
    { -280, -88, -992},
    { -288, -80, -968},
    { -280, -104, -992},
    { -280, -88, -960},
    { -280, -88, -968},
    { -312, -64, -1024},
    { -520, -24, -944},
    { -312, 16, -1056},
    { -280, -72, -888},
    // 34 seconds
    { -240, 16, -1024},
    { -272, -8, -1008},
    { -280, 8, -1016},
    { -264, 48, -1024},
    { -256, 24, -992},
    { -264, 16, -1000},
    { -240, 32, -1000},
    { -272, 16, -1008},
    { -256, 40, -976},
    { -280, 24, -992},
    { -272, 24, -1008},
    { -280, 40, -1008},
    { -272, 40, -1008},
    { -280, 32, -1000},
    { -280, 32, -1000},
    { -272, 24, -1000},
    { -264, 8, -1000},
    { -240, 0, -1000},
    { -216, 40, -1024},
    { -176, 0, -1024},
    { -128, 32, -1040},
    { -64, -64, -1016},
    { -16, -120, -1016},
    { -16, 120, -936},
    { -112, 440, -832},
    // 35 seconds
    { -160, 584, -712},
    { -224, 784, -472},
    { -280, 1224, -152},
    { -440, 904, -336},
    { -320, 536, -240},
    { -336, 840, -8},
    { -264, 960, -56},
    { -256, 1112, -88},
    { -208, 968, -64},
    { -80, 920, -72},
    { -56, 856, -16},
    { -24, 1040, -8},
    { -24, 992, -40},
    { -8, 960, -72},
    { 0, 1016, -16},
    { 8, 984, -8},
    { 16, 944, 8},
    { 32, 864, 0},
    { 96, 904, -80},
    { 72, 936, 0},
    { 72, 912, 24},
    { 72, 904, 0},
    { 104, 880, -32},
    { 80, 904, -48},
    { 64, 936, -8},
    // 36 seconds
    { 96, 928, -32},
    { 64, 944, -8},
    { 48, 936, 16},
    { 32, 888, 40},
    { 96, 944, -40},
    { 80, 936, -24},
    { 88, 912, -8},
    { 88, 928, 24},
    { 88, 904, -8},
    { 96, 936, -32},
    { 96, 936, -16},
    { 72, 928, -8},
    { 72, 920, -8},
    { 72, 912, -16},
    { 72, 928, -16},
    { 80, 904, -16},
    { 96, 904, -32},
    { 96, 920, -32},
    { 72, 912, -24},
    { 48, 912, 0},
    { 56, 936, -32},
    { 40, 936, -40},
    { 56, 928, -40},
    { 64, 888, -40},
    { 56, 928, -64},
    // 37 seconds
    { 56, 936, -32},
    { 32, 904, -8},
    { 48, 920, -40},
    { 48, 944, -48},
    { 64, 928, -32},
    { 48, 920, -40},
    { 48, 912, -40},
    { 32, 936, -24},
    { 40, 912, -40},
    { 32, 936, -64},
    { 64, 952, -56},
    { 72, 896, -16},
    { 48, 888, -24},
    { 8, 920, -40},
    { 24, 960, -80},
    { 64, 936, -72},
    { 48, 912, -32},
    { 40, 904, -32},
    { 32, 944, -40},
    { 56, 936, -48},
    { 40, 928, -16},
    { 48, 896, -40},
    { 40, 936, -72},
    { 64, 960, -64},
    { 56, 904, -24},
    // 38 seconds
    { 48, 912, -24},
    { 24, 912, -32},
    { 32, 920, -88},
    { 40, 952, -64},
    { 24, 936, -32},
    { 56, 912, -8},
    { 80, 912, -48},
    { 64, 912, -56},
    { 24, 928, -32},
    { 16, 928, -16},
    { 56, 944, -40},
    { 56, 920, -72},
    { 64, 920, -80},
    { 72, 912, -104},
    { 112, 920, -104},
    { 48, 928, -72},
    { 24, 992, -48},
    { -8, 936, -16},
    { -48, 936, -72},
    { -24, 936, -72},
    { -16, 928, -64},
    { 0, 920, -80},
    { 0, 928, -96},
    { -16, 928, -104},
    { -88, 976, -176},
    // 39 seconds
    { -232, 1056, -160},
    { -352, 1064, -32},
    { -392, 944, -112},
    { -344, 960, -88},
    { -264, 568, -208},
    { -184, 584, -336},
    { -32, 632, -608},
    { 8, 600, -776},
    { 80, 592, -848},
    { 152, 240, -1080},
    { 136, 408, -992},
    { 72, 392, -992},
    { 88, 248, -984},
    { 80, 272, -960},
    { 8, 216, -952},
    { 40, 192, -992},
    { 40, 208, -968},
    { 72, 144, -1000},
    { 104, 152, -1008},
    { 112, 112, -1024},
    { 128, 144, -1008},
    { 152, -32, -1144},
    { 96, -216, -920},
    { 72, -32, -1088},
    { -24, 112, -1016},
    // 40 seconds
    { 8, 136, -1064},
    { 96, 208, -1048},
    { 144, -232, -1016},
    { -16, -216, -992},
    { 0, -168, -1008},
    { 136, -128, -952},
    { 24, 8, -1064},
    { 152, -272, -1000},
    { 200, -248, -976},
    { 120, -112, -1048},
    { 136, -248, -1048},
    { 184, -216, -1104},
    { 200, -152, -1104},
    { 152, -224, -1080},
    { 192, -224, -1048},
    { 152, -200, -1128},
    { 184, -232, -1056},
    { 48, -240, -992},
    { -16, -240, -952},
    { -152, -408, -880},
    { -96, -336, -856},
    { -112, -400, -856},
    { -104, -344, -768},
    { 16, -416, -688},
    { -16, -440, -664},
    // 41 seconds
    { 32, -296, -432},
    { 72, -176, -272},
    { 496, 248, -432},
    { 552, 648, -640},
    { 464, 568, -384},
    { 688, 896, -440},
    { 824, 968, -592},
    { 1152, 632, -808},
    { 1456, 512, -560},
    { 1640, 664, -480},
    { 1376, 568, -304},
    { 1160, 456, -256},
    { 952, 656, -56},
    { 880, 728, 128},
    { 896, 688, 80},
    { 704, 632, -120},
    { 584, 608, -136},
    { 696, 432, -96},
    { 856, 312, -128},
    { 1000, 376, -240},
    { 1136, 344, -144},
    { 1160, 336, -168},
    { 1240, 368, -208},
    { 1328, 440, -48},
    { 1376, 440, -176},
    // 42 seconds
    { 1240, 384, -288},
    { 1272, -64, -112},
    { 776, -8, -144},
    { 624, -8, -424},
    { 952, -24, -328},
    { 920, 40, -280},
    { 848, 40, -360},
    { 736, 192, -336},
    { 672, 272, -336},
    { 776, 328, -312},
    { 848, 408, -368},
    { 840, 320, -392},
    { 1048, 552, -488},
    { 1168, 704, -528},
    { 1040, 832, -488},
    { 1152, 872, -336},
    { 800, 872, -352},
    { 704, 680, -232},
    { 944, 656, -160},
    { 1232, 680, -224},
    { 1096, 224, -184},
    { 992, 208, -232},
    { 960, 200, -232},
    { 944, 312, -296},
    { 1024, 408, -280},
    // 43 seconds
    { 1112, 376, -288},
    { 1128, 312, -272},
    { 896, 224, -328},
    { 784, 360, -400},
    { 624, 80, -328},
    { 456, -8, -336},
    { 584, 160, -440},
    { 792, 280, -408},
    { 752, 248, -368},
    { 712, 280, -408},
    { 824, 376, -296},
    { 1024, 432, -328},
    { 1184, 592, -392},
    { 1120, 696, -432},
    { 1056, 856, -488},
    { 1048, 848, -448},
    { 960, 808, -368},
    { 896, 888, -336},
    { 720, 736, -240},
    { 832, 736, -152},
    { 1072, 712, -176},
    { 920, 448, -152},
    { 832, 272, -256},
    { 952, 264, -240},
    { 1088, 280, -256},
    // 44 seconds
    { 1224, 376, -352},
    { 1336, 368, -192},
    { 1232, 400, -232},
    { 1088, 344, -280},
    { 1136, 296, -96},
    { 400, -136, -400},
    { 608, 32, -488},
    { 992, 56, -256},
    { 792, 192, -288},
    { 592, 232, -408},
    { 680, 320, -288},
    { 808, 360, -304},
    { 968, 360, -392},
    { 1264, 384, -432},
    { 1400, 864, -712},
    { 1176, 864, -432},
    { 1200, 712, -456},
    { 688, 680, -456},
    { 720, 616, -240},
    { 800, 736, -200},
    { 896, 744, -256},
    { 824, 312, -184},
    { 840, 256, -280},
    { 1016, 232, -320},
    { 1216, 320, -296},
    // 45 seconds
    { 1288, 336, -264},
    { 1328, 296, -232},
    { 1144, 288, -200},
    { 968, 288, -256},
    { 824, 264, -200},
    { 496, 112, -280},
    { 608, 184, -344},
    { 784, 264, -408},
    { 656, 232, -328},
    { 600, 192, -344},
    { 608, 256, -304},
    { 792, 288, -392},
    { 1088, 456, -488},
    { 1088, 744, -648},
    { 1136, 816, -608},
    { 1160, 544, -416},
    { 968, 536, -448},
    { 864, 800, -600},
    { 776, 680, -416},
    { 912, 688, -336},
    { 1040, 736, -384},
    { 1008, 552, -216},
    { 872, 624, -264},
    { 1168, 856, -280},
    { 1264, 736, -208},
    // 46 seconds
    { 936, 776, -320},
    { 600, 808, -376},
    { 488, 824, -368},
    { 184, 600, -320},
    { 48, 840, -552},
    { -48, 448, -408},
    { -56, 656, -744},
    { -56, 576, -496},
    { 40, 400, -640},
    { -112, 248, -640},
    { -256, 104, -608},
    { -400, 192, -768},
    { -592, 64, -872},
    { -752, 208, -1096},
    { -768, 240, -1120},
    { -872, 256, -1048},
    { -1032, 360, -992},
    { -736, 40, -704},
    { -728, 80, -504},
    { -808, -24, -408},
    { -608, -136, -304},
    { -136, -24, -376},
    { -144, 8, -232},
    { -80, 24, -168},
    { 40, 8, -192},
    // 47 seconds
    { 1384, 1448, 88},
    { 2048, 520, -248},
    { 2488, 656, -144},
    { 2656, 832, 32},
    { 2256, 1072, -320},
    { 1856, 952, -104},
    { 1552, 800, -80},
    { 1200, 568, -144},
    { 888, 448, -80},
    { 936, 600, 16},
    { 808, 832, 40},
    { 696, 1096, 112},
    { 472, 1168, -64},
    { 568, 904, -200},
    { 936, 872, -144},
    { 1232, 824, -272},
    { 1232, 584, -112},
    { 1616, 720, -144},
    { 1880, 792, -128},
    { 1672, 584, -88},
    { 1504, 424, -64},
    { 1552, 408, -88},
    { 1512, 344, -104},
    { 1288, 184, -160},
    { 1184, 184, -80},
    // 48 seconds
    { 1000, 16, 0},
    { 728, -704, 248},
    { 848, 48, -16},
    { 856, 120, -576},
    { 1296, 16, -224},
    { 1504, 288, -136},
    { 1512, 384, -72},
    { 1608, 520, -120},
    { 1680, 792, -120},
    { 1672, 1088, -240},
    { 1704, 1136, -48},
    { 1208, 1208, -48},
    { 776, 1272, -112},
    { 672, 1032, -120},
    { 744, 1360, -184},
    { 880, 1032, -112},
    { 1144, 976, -120},
    { 1600, 968, -120},
    { 1680, 728, -96},
    { 1616, 544, -72},
    { 1640, 472, -104},
    { 1688, 424, -40},
    { 1664, 376, -8},
    { 1504, 336, 64},
    { 1120, 288, 24},
    // 49 seconds
    { 864, -288, 24},
    { 888, -272, 248},
    { 608, -320, -192},
    { 760, 40, -560},
    { 1360, -96, -136},
    { 1304, 136, 104},
    { 1600, 240, 88},
    { 1896, 752, -128},
    { 1888, 1168, -416},
    { 1672, 1176, -528},
    { 1472, 664, -416},
    { 1032, 904, -600},
    { 760, 1000, -480},
    { 832, 1392, -496},
    { 776, 1072, -248},
    { 1080, 792, -256},
    { 1360, 752, -328},
    { 1352, 576, -272},
    { 1264, 408, -256},
    { 1368, 400, -144},
    { 1576, 504, -160},
    { 1728, 440, -168},
    { 1584, 304, -104},
    { 1256, 208, -8},
    { 912, -360, 72},
    // 50 seconds
    { 1000, 8, 240},
    { 664, -8, -304},
    { 784, 48, -432},
    { 1000, 32, -312},
    { 976, 128, 8},
    { 952, 256, -120},
    { 1064, 464, -224},
    { 1360, 504, -184},
    { 1752, 760, -256},
    { 1744, 1296, -416},
    { 1328, 1120, -296},
    { 1008, 800, -360},
    { 1032, 1456, -416},
    { 752, 1088, -120},
    { 800, 1016, -128},
    { 1064, 904, -152},
    { 1184, 720, -136},
    { 1144, 592, -32},
    { 1136, 408, -96},
    { 1216, 392, 192},
    { 1360, 536, -8},
    { 1456, 448, 0},
    { 1512, 432, -136},
    { 1360, 120, -128},
    { 920, -432, -80},
    // 51 seconds
    { 744, -296, -104},
    { 848, -48, -480},
    { 904, -16, -504},
    { 1144, 40, -168},
    { 1168, 152, -40},
    { 1176, 328, -216},
    { 1288, 544, -152},
    { 1432, 696, -344},
    { 1600, 1016, -288},
    { 1352, 1040, -136},
    { 1056, 1016, -152},
    { 752, 1176, -240},
    { 968, 1296, -240},
    { 880, 936, -136},
    { 1128, 904, -104},
    { 1336, 832, -88},
    { 1288, 616, -144},
    { 1224, 424, -120},
    { 1200, 296, -104},
    { 1328, 344, -120},
    { 1584, 392, -120},
    { 1456, 288, 80},
    { 1400, 304, 40},
    { 1192, -224, 160},
    { 928, -552, 288},
    // 52 seconds
    { 576, -72, -240},
    { 856, -48, -416},
    { 1128, 40, -240},
    { 1240, 200, -16},
    { 1360, 216, -56},
    { 1440, 416, -16},
    { 1520, 768, -112},
    { 1552, 1024, -400},
    { 1600, 800, -376},
    { 1160, 1064, -424},
    { 792, 1312, -360},
    { 752, 1272, -360},
    { 888, 1080, -328},
    { 1048, 696, -304},
    { 1368, 768, -320},
    { 1592, 720, -264},
    { 1440, 504, -104},
    { 1432, 376, -104},
    { 1504, 336, -160},
    { 1536, 304, -72},
    { 1440, 304, 16},
    { 1288, 272, 16},
    { 976, 224, -24},
    { 696, -352, 88},
    { 856, -184, 224},
    // 53 seconds
    { 656, -64, -368},
    { 920, 96, -480},
    { 1112, 240, -440},
    { 1456, 168, -64},
    { 1440, 192, 0},
    { 1592, 456, -48},
    { 1808, 920, -272},
    { 1704, 832, -512},
    { 1536, 784, -504},
    { 1160, 1160, -480},
    { 864, 1352, -608},
    { 1072, 1168, -360},
    { 752, 544, -296},
    { 1056, 608, -248},
    { 1160, 728, -288},
    { 1320, 704, -248},
    { 1432, 504, -64},
    { 1496, 400, 24},
    { 1504, 320, -40},
    { 1608, 288, -8},
    { 1432, 224, 0},
    { 1296, 248, 0},
    { 1064, -352, 128},
    { 904, -336, -8},
    { 800, -448, 168},
    // 54 seconds
    { 904, 120, -496},
    { 960, 48, -352},
    { 1296, 136, -88},
    { 1360, 344, -104},
    { 1336, 432, -256},
    { 1472, 552, -120},
    { 1744, 776, -200},
    { 1688, 1160, -192},
    { 1208, 1600, -240},
    { 672, 1400, -384},
    { 720, 1376, -304},
    { 1032, 1128, -72},
    { 1160, 848, -72},
    { 1384, 880, -112},
    { 1584, 832, -64},
    { 1512, 608, -40},
    { 1504, 480, 16},
    { 1496, 400, -24},
    { 1528, 336, -72},
    { 1592, 320, -24},
    { 1464, 264, 8},
    { 1200, 128, 8},
    { 760, -888, 152},
    { 680, -176, 80},
    { 656, -136, -464},
    // 55 seconds
    { 984, 64, -240},
    { 1328, 272, -40},
    { 1568, 192, 152},
    { 1640, 376, -112},
    { 1712, 688, -152},
    { 1600, 1064, -528},
    { 1720, 568, -424},
    { 1488, 824, -472},
    { 1016, 1208, -512},
    { 792, 1456, -640},
    { 960, 1136, -440},
    { 824, 696, -368},
    { 1080, 680, -224},
    { 1448, 880, -256},
    { 1752, 824, -152},
    { 1704, 512, -56},
    { 1600, 352, -40},
    { 1480, 312, -48},
    { 1440, 280, -88},
    { 1408, 272, -24},
    { 1320, 272, -16},
    { 1096, -360, 168},
    { 672, -648, 216},
    { 704, -360, -112},
    { 920, -56, -304},
    // 56 seconds
    { 1280, 152, -312},
    { 1504, 288, -56},
    { 1776, 240, 128},
    { 1848, 416, -16},
    { 1768, 888, -312},
    { 1656, 768, -304},
    { 1688, 536, -336},
    { 1416, 1104, -328},
    { 952, 1568, -384},
    { 696, 1168, -456},
    { 904, 1032, -408},
    { 824, 720, -384},
    { 1152, 720, -256},
    { 1648, 880, -232},
    { 1880, 648, -152},
    { 1744, 376, -72},
    { 1592, 256, -104},
    { 1560, 312, -104},
    { 1680, 328, -56},
    { 1560, 264, 24},
    { 1416, 232, -40},
    { 1448, -424, 200},
    { 992, -1136, 576},
    { 496, -336, -1032},
    { 880, -312, -200},
    // 57 seconds
    { 1440, 248, -120},
    { 1832, -32, 328},
    { 1952, 296, 48},
    { 1928, 752, -272},
    { 1592, 1160, -520},
    { 1456, 448, -360},
    { 1544, 568, -384},
    { 1256, 1264, -312},
    { 888, 1320, -392},
    { 728, 1344, -552},
    { 864, 944, -376},
    { 840, 752, -312},
    { 1160, 768, -224},
    { 1664, 896, -176},
    { 1904, 696, -112},
    { 1760, 400, -88},
    { 1672, 192, -8},
    { 1536, 264, -120},
    { 1568, 264, -96},
    { 1336, 248, 24},
    { 1128, 200, -40},
    { 888, -648, 184},
    { 896, -336, 240},
    { 768, -304, -432},
    { 1072, 24, -320},
    // 58 seconds
    { 1304, 216, -128},
    { 1520, 104, -16},
    { 1584, 248, -24},
    { 1744, 544, -160},
    { 1664, 888, -368},
    { 1608, 728, -352},
    { 1544, 624, -288},
    { 1248, 952, -224},
    { 1064, 1216, -176},
    { 792, 1320, -232},
    { 808, 1304, -296},
    { 928, 784, -256},
    { 1168, 728, -176},
    { 1648, 856, -176},
    { 1912, 528, -72},
    { 1816, 304, 0},
    { 1720, 280, -72},
    { 1704, 392, -80},
    { 1752, 368, -32},
    { 1520, 256, 96},
    { 1224, 272, -48},
    { 1144, -144, 88},
    { 592, -960, 224},
    { 424, -536, -184},
    { 712, -312, -56},
    // 59 seconds
    { 1448, 240, -640},
    { 1736, 288, -80},
    { 1872, 336, 208},
    { 1896, 432, -96},
    { 1768, 680, -384},
    { 1696, 640, -344},
    { 1736, 424, -528},
    { 1496, 1024, -600},
    { 832, 1504, -1184},
    { 672, 1496, -912},
    { 1160, 688, -544},
    { 1360, 960, -496},
    { 1360, 616, -272},
    { 1776, 768, -208},
    { 2232, 792, -176},
    { 2048, 384, 0},
    { 1760, 232, 16},
    { 1632, 280, 0},
    { 1520, 312, 24},
    { 1424, 288, 40},
    { 1288, 200, 88},
    { 1088, 104, 72},
    { 544, -616, 200},
    { 384, -416, 72},
    { 288, -304, -344},
    // 60 seconds
    // elapsed: 1 minutes
    { 840, 24, -328},
    { 1400, 8, -560},
    { 1512, 200, -192},
    { 1592, 408, -96},
    { 1528, 392, -128},
    { 1680, 328, -408},
    { 1960, 648, -632},
    { 1728, 864, -640},
    { 928, 1192, -408},
    { 1048, 1128, -832},
    { 848, 1048, -720},
    { 904, 1160, -512},
    { 976, 1016, -232},
    { 1344, 992, -96},
    { 1712, 720, -112},
    { 1608, 408, -96},
    { 1440, 336, -104},
    { 1480, 400, -88},
    { 1664, 448, -88},
    { 1672, 336, 56},
    { 1448, 272, 48},
    { 1192, 128, -80},
    { 744, -864, 40},
    { 552, -464, -184},
    { 808, -480, 24},
    // 61 seconds
    { 1144, 128, -136},
    { 1240, 200, -200},
    { 1232, 120, -240},
    { 1488, 112, -40},
    { 1928, 440, -304},
    { 2096, 760, -424},
    { 1920, 1136, -520},
    { 1416, 976, -624},
    { 840, 1520, -1048},
    { 608, 1392, -632},
    { 920, 1240, -440},
    { 1040, 936, -320},
    { 1552, 920, -176},
    { 2048, 792, -112},
    { 1800, 480, -112},
    { 1528, 344, -144},
    { 1520, 376, -112},
    { 1696, 312, -120},
    { 1744, 312, 8},
    { 1512, 232, -64},
    { 1128, 128, -48},
    { 664, -912, 120},
    { 576, -600, -56},
    { 736, -360, -240},
    { 1184, 8, -192},
    // 62 seconds
    { 1392, 152, -144},
    { 1592, 160, -136},
    { 1832, 288, -88},
    { 2032, 760, -136},
    { 2000, 1176, -568},
    { 2136, 504, -240},
    { 1776, 1024, -328},
    { 1176, 1456, -384},
    { 728, 1440, -488},
    { 808, 1384, -416},
    { 824, 840, -328},
    { 1296, 824, -264},
    { 1784, 840, -200},
    { 1872, 584, -144},
    { 1808, 320, -120},
    { 1608, 272, -152},
    { 1648, 280, -104},
    { 1872, 304, -56},
    { 1608, 200, 32},
    { 1344, 184, -48},
    { 768, -728, 144},
    { 872, -376, -144},
    { 680, -512, -72},
    { 1176, -16, -248},
    { 1368, 32, -184},
    // 63 seconds
    { 1424, 176, -208},
    { 1480, 328, -200},
    { 1568, 496, -224},
    { 1840, 648, -152},
    { 2064, 1072, -240},
    { 1872, 952, -112},
    { 1232, 1312, -280},
    { 704, 1472, -328},
    { 792, 1408, -16},
    { 856, 1088, 24},
    { 1120, 816, -16},
    { 1576, 824, -64},
    { 1880, 648, -80},
    { 1840, 504, -128},
    { 1704, 104, -40},
    { 1576, 248, -120},
    { 1648, 272, -240},
    { 1592, 176, -8},
    { 1328, 104, -80},
    { 848, -528, 88},
    { 864, -528, -152},
    { 720, -464, -32},
    { 1072, -48, -368},
    { 1280, 64, -208},
    { 1336, 224, -328},
    // 64 seconds
    { 1408, 296, -248},
    { 1512, 416, -232},
    { 1776, 584, -128},
    { 2008, 1000, -280},
    { 1712, 1064, -112},
    { 1072, 1224, -248},
    { 656, 1384, -280},
    { 632, 1400, -192},
    { 792, 1000, -40},
    { 1112, 896, -96},
    { 1560, 832, -72},
    { 1768, 648, -136},
    { 1632, 472, -128},
    { 1568, 392, -104},
    { 1624, 328, -80},
    { 1720, 352, -128},
    { 1632, 272, -24},
    { 1344, 192, -24},
    { 976, -40, -64},
    { 840, -624, -16},
    { 544, -480, 80},
    { 896, -160, -576},
    { 1128, 24, -112},
    { 1240, 144, -328},
    { 1336, 192, -280},
    // 65 seconds
    { 1560, 440, -232},
    { 1840, 696, -152},
    { 1984, 1192, -336},
    { 1896, 984, -128},
    { 1472, 968, -200},
    { 992, 1312, -120},
    { 792, 1424, -96},
    { 760, 1208, -64},
    { 872, 840, -40},
    { 1056, 856, -152},
    { 1368, 864, -168},
    { 1576, 648, -152},
    { 1680, 456, -112},
    { 1648, 296, -136},
    { 1656, 280, -200},
    { 1704, 288, -160},
    { 1592, 232, -56},
    { 1296, 224, -176},
    { 1040, -688, 128},
    { 512, -640, 32},
    { 864, -152, -544},
    { 1240, -136, -128},
    { 1400, 168, -208},
    { 1456, 232, -64},
    { 1464, 488, -280},
    // 66 seconds
    { 1760, 608, -168},
    { 1896, 952, -408},
    { 1824, 1128, -256},
    { 1384, 1104, -320},
    { 888, 1616, -296},
    { 512, 1448, -272},
    { 832, 1336, -192},
    { 856, 896, -152},
    { 1224, 888, -184},
    { 1808, 912, -208},
    { 1864, 520, -160},
    { 1840, 432, -56},
    { 1896, 488, -56},
    { 1760, 208, 64},
    { 1464, 248, -128},
    { 1472, 80, 16},
    { 1128, -328, 232},
    { 872, -432, 64},
    { 840, -528, 72},
    { 840, 8, -424},
    { 1104, 8, -624},
    { 1616, 72, -128},
    { 1608, 264, -328},
    { 1592, 448, -528},
    { 1640, 600, -544},
    // 67 seconds
    { 1648, 952, -592},
    { 1656, 744, -400},
    { 1288, 1008, -328},
    { 800, 1400, -592},
    { 640, 1240, -400},
    { 928, 1080, -328},
    { 1080, 784, -256},
    { 1280, 792, -240},
    { 1664, 776, -224},
    { 1632, 512, -160},
    { 1536, 336, -264},
    { 1616, 296, -160},
    { 1584, 288, -136},
    { 1632, 272, -160},
    { 1472, 168, -64},
    { 976, -320, 56},
    { 672, -408, 56},
    { 592, -360, -168},
    { 688, -40, -320},
    { 872, 56, -448},
    { 1328, 152, -128},
    { 1344, 264, -128},
    { 1360, 368, -304},
    { 1448, 408, -352},
    { 1816, 632, -368},
    // 68 seconds
    { 1720, 1088, -592},
    { 1376, 968, -576},
    { 992, 1160, -616},
    { 784, 1160, -480},
    { 968, 1200, -408},
    { 976, 760, -240},
    { 1152, 712, -232},
    { 1384, 608, -240},
    { 1312, 488, -200},
    { 1200, 304, -160},
    { 1280, 280, -264},
    { 1432, 256, -160},
    { 1512, 264, -136},
    { 1496, 224, -104},
    { 1272, 176, -144},
    { 896, -384, -104},
    { 848, -288, -24},
    { 480, -56, -448},
    { 648, 112, -632},
    { 1040, 24, -320},
    { 1208, 56, -112},
    { 1208, 152, -232},
    { 1360, 424, -232},
    { 1648, 624, -344},
    { 1712, 976, -512},
    // 69 seconds
    { 1520, 952, -248},
    { 1144, 936, -376},
    { 976, 1088, -312},
    { 1064, 1336, -360},
    { 760, 744, -216},
    { 1008, 720, -232},
    { 1304, 824, -272},
    { 1464, 632, -272},
    { 1376, 216, -200},
    { 1360, 184, -208},
    { 1440, 192, -232},
    { 1584, 264, -184},
    { 1632, 224, -112},
    { 1376, 200, -16},
    { 992, -88, -96},
    { 680, -672, -112},
    { 488, -208, -56},
    { 720, -16, -496},
    { 904, 72, -416},
    { 1352, 184, -168},
    { 1504, 200, -72},
    { 1528, 312, -128},
    { 1728, 640, -128},
    { 1640, 1008, -520},
    { 1528, 656, -408},
    // 70 seconds
    { 1328, 824, -464},
    { 1064, 1456, -520},
    { 776, 1088, -392},
    { 1024, 1072, -352},
    { 768, 600, -272},
    { 1120, 648, -304},
    { 1672, 864, -392},
    { 1776, 568, -240},
    { 1576, 264, -184},
    { 1480, 184, -152},
    { 1352, 232, -160},
    { 1408, 232, -192},
    { 1440, 200, -88},
    { 1248, 176, -72},
    { 912, -328, -40},
    { 840, -808, -88},
    { 536, -88, -192},
    { 776, 8, -504},
    { 1072, 88, -328},
    { 1488, 168, -240},
    { 1680, 288, -80},
    { 1680, 448, -152},
    { 1760, 800, -256},
    { 1768, 696, -360},
    { 1672, 560, -448},
    // 71 seconds
    { 1408, 1080, -456},
    { 904, 1344, -480},
    { 704, 1112, -448},
    { 944, 1064, -448},
    { 792, 664, -376},
    { 1080, 640, -328},
    { 1528, 752, -320},
    { 1888, 648, -168},
    { 1760, 400, -152},
    { 1616, 288, -200},
    { 1600, 296, -192},
    { 1584, 272, -104},
    { 1512, 184, -64},
    { 1312, 128, -16},
    { 896, 112, -184},
    { 536, 864, -344},
    { 352, 1008, -376},
    { 56, 120, 88},
    { 8, 784, -968},
    { 40, 392, -776},
    { 208, 112, -792},
    { 248, -136, -496},
    { 120, -448, -552},
    { -24, -656, -512},
    { -8, -696, -600},
    // 72 seconds
    { -40, -896, -584},
    { 32, -1160, -504},
    { -40, -1296, -392},
    { -160, -1176, -544},
    { 24, -752, -960},
    { -80, -680, -768},
    { 16, -512, -888},
    { 32, -304, -832},
    { -56, -584, -688},
    { 8, -544, -760},
    { 16, -568, -872},
    { 56, -496, -920},
    { -112, -672, -856},
    { -184, -768, -792},
    { -304, -736, -856},
    { -288, -720, -888},
    { -280, -440, -984},
    { -64, -384, -1048},
    { -80, -592, -864},
    { -80, -408, -808},
    { -192, -544, -672},
    { -256, -632, -584},
    { -384, -664, -560},
    { -400, -608, -640},
    { -464, -576, -744},
    // 73 seconds
    { -256, -720, -888},
    { -176, -720, -976},
    { -240, -888, -968},
    { -112, -712, -1032},
    { -272, -600, -912},
    { -288, -584, -856},
    { -160, -584, -872},
    { -88, -576, -824},
    { -48, -528, -920},
    { -40, -688, -624},
    { -16, -608, -696},
    { -8, -784, -616},
    { -96, -832, -640},
    { -88, -776, -704},
    { 192, -920, -840},
    { 104, -944, -784},
    { 296, -632, -528},
    { 472, -528, -104},
    { 784, -256, 136},
    { 792, -120, 416},
    { 1512, 136, 200},
    { 1328, 440, 160},
    { 1536, 648, 104},
    { 1784, 776, 64},
    { 2096, 792, -64},
    // 74 seconds
    { 2616, 592, -336},
    { 2544, 1280, -704},
    { 1952, 360, -256},
    { 1560, 632, -288},
    { 864, 1144, -512},
    { 680, 1336, -248},
    { 928, 1160, -176},
    { 1144, 600, -144},
    { 1144, 176, -144},
    { 1152, 16, -224},
    { 1336, -56, -184},
    { 1728, 64, -152},
    { 1952, 240, -80},
    { 1760, 176, -88},
    { 1416, -144, 48},
    { 1008, -592, 312},
    { 592, -568, -128},
    { 1064, -424, -56},
    { 1320, -504, 48},
    { 1152, -232, -48},
    { 1128, 88, -216},
    { 1184, 168, -208},
    { 1416, 224, -176},
    { 1656, 336, -192},
    { 1744, 736, -304},
    // 75 seconds
    { 1320, 912, -320},
    { 976, 816, -376},
    { 992, 920, -312},
    { 928, 816, -304},
    { 984, 512, -16},
    { 1424, 568, -16},
    { 1448, 408, -240},
    { 1344, 232, -288},
    { 1224, 128, -200},
    { 1336, 152, -168},
    { 1568, 176, -96},
    { 1672, 160, -24},
    { 1456, 96, -16},
    { 1248, -184, 48},
    { 728, -904, 264},
    { 600, 120, 8},
    { 720, -112, -344},
    { 1144, 64, -200},
    { 1224, 192, -152},
    { 1248, -32, -24},
    { 1512, -56, -120},
    { 1816, 384, -48},
    { 1880, 880, -464},
    { 1696, 688, -232},
    { 1304, 792, -304},
    // 76 seconds
    { 1024, 1120, -408},
    { 816, 1000, -400},
    { 1016, 1000, -376},
    { 1000, 608, -224},
    { 1288, 576, -184},
    { 1712, 624, -264},
    { 1784, 424, -168},
    { 1592, 144, -104},
    { 1592, 104, -96},
    { 1624, 200, -48},
    { 1560, 112, -112},
    { 1560, 80, -48},
    { 1328, 40, -8},
    { 752, -776, 256},
    { 656, -184, -64},
    { 552, -344, 16},
    { 800, 48, -176},
    { 992, 136, -216},
    { 1296, 72, -264},
    { 1608, 136, -248},
    { 1776, 280, -184},
    { 1904, 752, -288},
    { 1920, 648, -176},
    { 1776, 608, -272},
    { 1360, 1008, -200},
    // 77 seconds
    { 984, 1464, -440},
    { 1064, 1416, -440},
    { 1056, 800, -168},
    { 1232, 664, -264},
    { 1312, 640, -200},
    { 1440, 536, -160},
    { 1456, 320, -112},
    { 1472, 200, -72},
    { 1608, 192, -136},
    { 1776, 152, -40},
    { 1488, 56, 56},
    { 1376, 56, -72},
    { 1120, 32, 0},
    { 672, -664, -16},
    { 584, -432, 16},
    { 784, -72, -248},
    { 992, 32, -216},
    { 1344, 80, -112},
    { 1576, 120, 40},
    { 1696, 408, -168},
    { 1736, 544, -264},
    { 1792, 808, -264},
    { 1704, 528, -216},
    { 1520, 1040, -176},
    { 1048, 1352, -296},
    // 78 seconds
    { 856, 1400, -304},
    { 1096, 1248, -272},
    { 1216, 696, -96},
    { 1352, 600, -232},
    { 1592, 648, -216},
    { 1624, 336, -80},
    { 1536, 248, -88},
    { 1544, 216, -40},
    { 1584, 168, -96},
    { 1560, 256, -88},
    { 1376, 72, 56},
    { 1096, 64, -32},
    { 776, -312, 136},
    { 736, -496, 88},
    { 664, -368, 64},
    { 1056, 64, -320},
    { 1240, 112, -120},
    { 1424, 192, -256},
    { 1480, 144, -232},
    { 1680, 160, -216},
    { 1952, 496, -472},
    { 2008, 704, -560},
    { 1720, 496, -576},
    { 1304, 608, -728},
    { 1152, 904, -704},
    // 79 seconds
    { 1048, 1032, -648},
    { 888, 792, -504},
    { 944, 520, -256},
    { 896, 584, -240},
    { 1064, 656, -280},
    { 1352, 520, -152},
    { 1504, 392, -72},
    { 1544, 296, -56},
    { 1536, 216, -56},
    { 1464, 128, -112},
    { 1576, 112, 24},
    { 1384, 136, -8},
    { 1232, 96, -96},
    { 944, -648, 248},
    { 592, -392, 160},
    { 736, 144, -408},
    { 864, 328, -256},
    { 1008, 152, -216},
    { 1048, -328, -88},
    { 1344, -120, -160},
    { 1792, 384, -168},
    { 2056, 904, -392},
    { 1616, 1544, -504},
    { 1288, 416, -400},
    { 1176, 656, -552},
    // 80 seconds
    { 944, 760, -408},
    { 920, 1128, -384},
    { 640, 1024, -352},
    { 936, 768, -312},
    { 1216, 688, -288},
    { 1424, 528, -240},
    { 1480, 336, -184},
    { 1456, 264, -168},
    { 1472, 232, -144},
    { 1416, 216, -192},
    { 1504, 200, -112},
    { 1384, 128, -24},
    { 1056, 56, -48},
    { 984, -592, 256},
    { 648, -264, 80},
    { 664, 24, -432},
    { 928, 112, -352},
    { 1248, 32, -184},
    { 1288, -64, -56},
    { 1368, 72, -352},
    { 1648, 552, -176},
    { 1592, 1120, -232},
    { 1232, 1096, -96},
    { 872, 784, -256},
    { 704, 776, -288},
    // 81 seconds
    { 680, 1000, -240},
    { 1112, 1376, -152},
    { 1568, 1136, -8},
    { 1544, 608, -128},
    { 1424, 592, -216},
    { 1552, 712, -448},
    { 1664, 616, 16},
    { 1584, 544, -184},
    { 1816, 472, 32},
    { 1648, 544, -40},
    { 1248, 480, -232},
    { 824, 144, -264},
    { 200, -160, -88},
    { 432, -416, -1160},
    { 288, -1360, -128},
    { 640, -1456, -224},
    { 760, -800, -240},
    { 336, 512, -864},
    { 264, -736, -560},
    { 488, -408, -288},
    { 296, -360, 352},
    { -56, 0, 328},
    { -256, 656, 112},
    { -584, 1128, -1144},
    { -184, 1800, -64},
    // 82 seconds
    { -88, 896, 520},
    { 96, 432, 288},
    { 408, 408, 200},
    { 992, 144, 160},
    { 232, -3416, -280},
    { -120, -584, 560},
    { -8, -1448, -1776},
    { 536, -1048, -632},
    { 1168, -1464, -24},
    { 1088, -1704, -536},
    { 952, -1152, -416},
    { 608, -760, -456},
    { 384, -824, -504},
    { 288, -744, -440},
    { 288, -640, -464},
    { 216, -560, -528},
    { 128, -664, -504},
    { -104, -936, -680},
    { 208, -800, -512},
    { 80, -792, -520},
    { 48, -784, -552},
    { 56, -784, -616},
    { 144, -776, -696},
    { 184, -848, -688},
    { 160, -912, -616},
    // 83 seconds
    { 160, -904, -608},
    { 112, -824, -632},
    { 152, -768, -664},
    { 256, -784, -688},
    { 240, -808, -648},
    { 240, -816, -640},
    { 216, -776, -664},
    { 200, -784, -680},
    { 176, -808, -672},
    { 160, -800, -672},
    { 160, -776, -672},
    { 168, -776, -688},
    { 152, -784, -680},
    { 160, -792, -680},
    { 136, -800, -672},
    { 112, -800, -664},
    { 120, -800, -656},
    { 112, -816, -656},
    { 120, -832, -656},
    { 144, -824, -680},
    { 136, -824, -704},
    { 152, -816, -720},
    { 128, -808, -704},
    { 112, -808, -696},
    { 88, -808, -664},
    // 84 seconds
    { 96, -800, -640},
    { 88, -808, -624},
    { 80, -784, -616},
    { 48, -768, -632},
    { 48, -776, -672},
    { 56, -792, -696},
    { 64, -816, -712},
    { 56, -832, -704},
    { 32, -816, -696},
    { 40, -824, -688},
    { 40, -808, -688},
    { 48, -792, -672},
    { 56, -776, -680},
    { 64, -776, -688},
    { 72, -776, -688},
    { 64, -784, -688},
    { 104, -784, -680},
    { 168, -776, -640},
    { 152, -736, -632},
    { 64, -696, -664},
    { 8, -704, -728},
    { 0, -704, -816},
    { 32, -712, -856},
    { 40, -736, -872},
    { 48, -760, -864},
    // 85 seconds
    { 48, -728, -856},
    { 64, -680, -832},
    { 88, -664, -768},
    { 88, -552, -768},
    { 40, -392, -776},
    { -112, -360, -856},
    { -256, -400, -944},
    { -304, -552, -1064},
    { -240, -568, -1128},
    { -200, -576, -1096},
    { -200, -600, -1032},
    { -184, -632, -976},
    { -192, -568, -904},
    { -200, -520, -888},
    { -216, -520, -848},
    { -232, -512, -832},
    { -240, -528, -872},
    { -264, -536, -872},
    { -280, -528, -864},
    { -280, -536, -880},
    { -280, -560, -864},
    { -272, -568, -888},
    { -280, -552, -888},
    { -280, -528, -888},
    { -272, -488, -880},
    // 86 seconds
    { -272, -544, -888},
    { -272, -544, -880},
    { -256, -536, -872},
    { -240, -576, -872},
    { -224, -608, -856},
    { -248, -640, -888},
    { -232, -512, -888},
    { -240, -424, -896},
    { -200, -320, -912},
    { -152, -224, -848},
    { -136, -96, -920},
    { -64, -160, -840},
    { -280, -336, -824},
    { -376, -168, -840},
    { -408, 16, -712},
    { -352, 144, -416},
    { -560, 992, -288},
    { -528, 1048, -328},
    { -768, 1176, -152},
    { -624, 1144, 224},
    { -400, 696, -120},
    { -512, 888, 160},
    { -376, 1048, 64},
    { -320, 1064, 16},
    { -280, 1080, -72},
    // 87 seconds
    { -240, 912, -136},
    { -256, 648, -32},
    { -360, 960, -392},
    { -152, 912, -496},
    { -352, 896, -272},
    { -320, 840, -512},
    { -328, 768, -496},
    { -312, 856, -544},
    { -320, 896, -400},
    { -336, 824, -432},
    { -360, 896, -464},
    { -392, 752, -416},
    { -400, 776, -464},
    { -400, 712, -424},
    { -392, 672, -488},
    { -368, 576, -488},
    { -304, 472, -440},
    { -312, 608, -520},
    { -304, 584, -320},
    { -184, 960, -408},
    { -216, 1048, -320},
    { -184, 984, -56},
    { -288, 1144, 664},
    { -264, 720, 304},
    { -200, 944, 360},
    // 88 seconds
    { -136, 832, 432},
    { -64, 664, 504},
    { -64, 720, 680},
    { -24, 696, 768},
    { -64, 632, 824},
    { -80, 640, 736},
    { -32, 584, 840},
    { -24, 520, 792},
    { -8, 528, 784},
    { -16, 560, 808},
    { -32, 488, 824},
    { -32, 712, 768},
    { -24, 456, 792},
    { 0, 336, 832},
    { 8, 352, 696},
    { 16, 728, 816},
    { -32, 584, 784},
    { -16, 792, 648},
    { -48, 928, 800},
    { -80, 688, 800},
    { -136, 840, 720},
    { -192, 952, 664},
    { -232, 1000, 552},
    { -200, 1000, 560},
    { -168, 864, 312},
    // 89 seconds
    { -48, 728, -616},
    { -344, 784, -368},
    { -192, 544, -400},
    { -184, 48, -928},
    { -104, 128, -832},
    { -192, 88, -968},
    { -152, -48, -928},
    { -88, 24, -944},
    { -72, -96, -1008},
    { -88, 0, -1024},
    { -96, 56, -1040},
    { -80, -56, -1072},
    { -48, -16, -1048},
    { -64, 8, -1016},
    { -64, -24, -1000},
    { -40, -16, -984},
    { 40, -200, -976},
    { 128, -248, -928},
    { 272, -96, -672},
    { 192, 248, -384},
    { 240, 752, -112},
    { 408, 1032, 240},
    { 64, 1224, 632},
    { -328, 1248, 752},
    { -344, 1680, 968},
    // 90 seconds
    { -48, 864, 800},
    { -88, 520, 616},
    { 0, 792, 672},
    { 56, 432, 704},
    { 48, 544, 768},
    { 144, 392, 608},
    { 248, 600, 464},
    { 280, 736, 360},
    { 304, 864, 400},
    { 344, 904, 480},
    { 288, 936, 536},
    { 304, 784, 504},
    { 264, 736, 528},
    { 240, 736, 528},
    { 216, 672, 568},
    { 184, 584, 616},
    { 128, 624, 640},
    { 128, 504, 672},
    { 168, 568, 696},
    { 232, 624, 720},
    { 304, 560, 688},
    { 336, 576, 632},
    { 352, 648, 648},
    { 344, 616, 672},
    { 288, 560, 688},
    // 91 seconds
    { 256, 560, 736},
    { 216, 584, 744},
    { 216, 560, 704},
    { 224, 528, 672},
    { 256, 584, 696},
    { 288, 600, 728},
    { 280, 664, 824},
    { 208, 576, 744},
    { 152, 648, 584},
    { 136, 664, 608},
    { 144, 608, 592},
    { 144, 616, 544},
    { 168, 736, 584},
    { 160, 760, 600},
    { 112, 744, 640},
    { 72, 680, 472},
    { 64, 760, 384},
    { 24, 776, 328},
    { 8, 832, 456},
    { -8, 848, 456},
    { 0, 784, 480},
    { 184, 648, 520},
    { 192, 648, 600},
    { 232, 720, 560},
    { 136, 752, 576},
    // 92 seconds
    { 128, 800, 592},
    { 104, 872, 536},
    { 64, 904, 472},
    { 64, 928, 416},
    { 80, 768, 464},
    { 160, 664, 472},
    { 136, 640, 544},
    { 160, 560, 728},
    { 208, 400, 736},
    { 208, 336, 680},
    { 264, 264, 688},
    { 280, 472, 696},
    { 288, 640, 704},
    { 320, 544, 624},
    { 368, 696, 600},
    { 368, 712, 632},
    { 400, 792, 704},
    { 368, 784, 776},
    { 304, 696, 784},
    { 352, 704, 776},
    { 320, 576, 712},
    { 296, 616, 728},
    { 272, 520, 664},
    { 288, 496, 608},
    { 256, 536, 632},
    // 93 seconds
    { 248, 544, 624},
    { 264, 608, 680},
    { 272, 560, 720},
    { 256, 560, 728},
    { 240, 536, 736},
    { 248, 608, 744},
    { 232, 600, 720},
    { 216, 568, 720},
    { 216, 568, 696},
    { 192, 608, 664},
    { 200, 712, 672},
    { 216, 832, 624},
    { 200, 872, 512},
    { 248, 952, 432},
    { 200, 1016, 216},
    { 208, 1040, 184},
    { 200, 976, 72},
    { 192, 864, -48},
    { 232, 832, -176},
    { 96, 904, -256},
    { 136, 488, -456},
    { 192, 312, -736},
    { 56, 240, -912},
    { 32, 232, -904},
    { -8, 240, -904},
    // 94 seconds
    { -24, 296, -880},
    { -32, 208, -936},
    { -32, 176, -944},
    { -32, 256, -920},
    { -16, 160, -984},
    { 48, 152, -1048},
    { 72, -144, -1192},
    { 88, -128, -1120},
    { 184, 48, -936},
    { 416, 432, -456},
    { 248, 800, 336},
    { 72, 864, 720},
    { 48, 776, 936},
    { 504, 1160, 896},
    { 64, 920, 544},
    { -96, 536, 264},
    { 112, 824, 536},
    { 216, 824, 456},
    { 240, 784, 576},
    { 232, 704, 536},
    { 248, 728, 496},
    { 288, 728, 488},
    { 320, 648, 472},
    { 328, 768, 552},
    { 344, 736, 568},
    // 95 seconds
    { 368, 704, 560},
    { 392, 720, 568},
    { 384, 712, 608},
    { 360, 704, 576},
    { 368, 792, 584},
    { 312, 688, 608},
    { 296, 664, 600},
    { 264, 624, 632},
    { 264, 616, 656},
    { 264, 640, 640},
    { 280, 664, 632},
    { 288, 600, 616},
    { 304, 584, 616},
    { 288, 608, 608},
    { 280, 624, 624},
    { 296, 632, 632},
    { 288, 616, 648},
    { 312, 616, 616},
    { 312, 616, 584},
    { 304, 616, 584},
    { 280, 648, 640},
    { 272, 632, 656},
    { 240, 600, 640},
    { 264, 616, 632},
    { 264, 608, 640},
    // 96 seconds
    { 288, 624, 608},
    { 304, 656, 592},
    { 288, 640, 640},
    { 280, 608, 688},
    { 264, 584, 640},
    { 296, 632, 568},
    { 304, 640, 616},
    { 304, 632, 640},
    { 296, 608, 656},
    { 256, 592, 640},
    { 256, 584, 616},
    { 272, 616, 656},
    { 288, 632, 648},
    { 288, 640, 632},
    { 304, 632, 584},
    { 304, 640, 600},
    { 288, 608, 656},
    { 272, 592, 688},
    { 264, 616, 648},
    { 280, 640, 600},
    { 296, 648, 568},
    { 312, 648, 624},
    { 280, 584, 656},
    { 256, 600, 648},
    { 256, 608, 632},
    // 97 seconds
    { 280, 648, 640},
    { 296, 656, 624},
    { 296, 640, 576},
    { 280, 656, 608},
    { 264, 640, 648},
    { 240, 800, 656},
    { 248, 1008, 632},
    { 224, 1168, 616},
    { 232, 1072, 600},
    { 248, 1128, 592},
    { 176, 976, 384},
    { 184, 760, 72},
    { 64, 624, -112},
    { -48, 768, -208},
    { 48, 520, -424},
    { -8, 504, -560},
    { -64, 264, -664},
    { -168, 448, -744},
    { -240, 240, -800},
    { -232, 448, -808},
    { -296, 448, -840},
    { -256, 440, -816},
    { -272, 488, -864},
    { -328, 416, -872},
    { -312, 480, -816},
    // 98 seconds
    { -344, 408, -872},
    { -296, 512, -864},
    { -320, 504, -816},
    { -336, 424, -856},
    { -328, 456, -864},
    { -344, 496, -864},
    { -344, 496, -808},
    { -328, 464, -872},
    { -320, 528, -784},
    { -328, 472, -824},
    { -336, 496, -832},
    { -352, 512, -792},
    { -344, 472, -776},
    { -344, 488, -848},
    { -296, 408, -840},
    { -296, 440, -856},
    { -272, 416, -872},
    { -216, 384, -888},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

