/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured: 2015-10-19 11:02:53 local
AccelRawData *activity_sample_walk_200_pbl_27927_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_27927_10
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 180
  //> TEST_EXPECTED_MAX 220
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -24, -64, -992},
    { -48, -56, -984},
    { -48, -32, -968},
    { -48, -24, -960},
    { -48, -24, -968},
    { -48, -40, -960},
    { -48, -40, -984},
    { -40, -40, -1000},
    { -64, -56, -1000},
    { -80, -24, -968},
    { -80, -24, -944},
    { -80, 0, -936},
    { -72, -16, -928},
    { -56, -48, -944},
    { -80, -8, -976},
    { -64, -32, -984},
    { -72, -24, -1000},
    { -72, -32, -976},
    { -64, -16, -968},
    { -72, -16, -952},
    { -80, -8, -968},
    { -64, -16, -976},
    { -64, -32, -976},
    { -72, -16, -968},
    { -32, -16, -960},
    // 1 seconds
    { 104, 192, -896},
    { -56, -40, -976},
    { -80, -48, -976},
    { -96, -24, -936},
    { -16, -64, -952},
    { -296, -88, -976},
    { 336, 152, -1000},
    { -16, -64, -928},
    { 32, -152, -904},
    { 64, -72, -960},
    { 128, -96, -992},
    { 192, -96, -952},
    { 96, -64, -944},
    { 120, -24, -824},
    { 72, 88, -688},
    { -96, 312, -536},
    { -152, 624, -472},
    { -232, 960, -400},
    { -224, 1144, -264},
    { -168, 1200, -240},
    { -168, 1224, -192},
    { -144, 1096, -176},
    { -64, 1048, -208},
    { -64, 1128, -128},
    { -56, 960, -128},
    // 2 seconds
    { -48, 1024, -32},
    { -48, 1056, -48},
    { -88, 1016, 0},
    { -104, 1008, 40},
    { -120, 1008, 48},
    { -96, 912, -72},
    { -72, 800, -120},
    { -48, 976, -144},
    { -88, 1000, -72},
    { -112, 1024, 24},
    { -64, 912, 16},
    { -96, 1112, -56},
    { -64, 1048, -176},
    { -80, 912, -184},
    { -72, 1016, -288},
    { -40, 896, -280},
    { -8, 808, -496},
    { -56, 752, -208},
    { -40, 1040, -320},
    { -56, 1040, -248},
    { -72, 1048, -224},
    { -64, 896, -248},
    { -40, 928, -248},
    { -40, 1008, -304},
    { -64, 920, -296},
    // 3 seconds
    { -96, 968, -200},
    { -80, 944, -416},
    { -40, 672, -520},
    { -104, 848, -376},
    { -32, 680, -568},
    { -96, 992, -160},
    { -120, 1128, -168},
    { -120, 912, 120},
    { -120, 1064, 56},
    { -112, 976, 40},
    { -96, 912, 80},
    { -80, 872, 112},
    { -48, 960, 96},
    { -56, 944, 136},
    { -72, 936, 192},
    { -80, 912, 360},
    { -80, 1136, 208},
    { -80, 976, 304},
    { -64, 800, 520},
    { -24, 912, 512},
    { -40, 1032, 536},
    { -64, 1216, 472},
    { -72, 1152, 392},
    { -56, 904, 344},
    { -64, 1064, 216},
    // 4 seconds
    { -160, 944, 280},
    { -184, 888, 200},
    { -176, 944, 184},
    { -128, 888, 112},
    { -104, 920, 32},
    { 32, 848, -48},
    { 80, 840, -256},
    { 120, 1152, -152},
    { 112, 1032, -16},
    { 8, 1048, -56},
    { -64, 880, 16},
    { -112, 600, 0},
    { -64, 968, -72},
    { -184, 936, 112},
    { -32, 1096, 264},
    { -128, 1216, 512},
    { -64, 1184, 432},
    { -24, 1008, 264},
    { -24, 1008, 224},
    { 32, 832, 280},
    { 32, 1056, 168},
    { 48, 976, 176},
    { 16, 1016, 136},
    { -8, 904, 64},
    { 16, 1024, 24},
    // 5 seconds
    { 64, 816, -64},
    { 32, 920, -48},
    { 32, 992, 8},
    { 88, 952, 24},
    { 128, 880, 64},
    { 152, 896, 240},
    { 96, 952, 440},
    { 56, 1000, 504},
    { -48, 856, 568},
    { -120, 1048, 464},
    { -120, 1048, 416},
    { -40, 896, 440},
    { 64, 1024, 256},
    { 208, 968, 208},
    { 312, 968, 208},
    { 360, 952, 296},
    { 392, 1112, 312},
    { 232, 872, 376},
    { 168, 824, 304},
    { 128, 856, 312},
    { 120, 944, 424},
    { 96, 1032, 400},
    { 120, 1056, 352},
    { 136, 936, 400},
    { 136, 928, 384},
    // 6 seconds
    { 168, 960, 296},
    { 224, 952, 280},
    { 256, 936, 272},
    { 272, 944, 272},
    { 296, 936, 272},
    { 288, 936, 224},
    { 272, 872, 248},
    { 256, 912, 224},
    { 280, 968, 208},
    { 312, 960, 240},
    { 296, 952, 216},
    { 272, 920, 232},
    { 280, 928, 216},
    { 280, 952, 232},
    { 288, 968, 224},
    { 312, 952, 224},
    { 304, 920, 240},
    { 320, 904, 216},
    { 320, 928, 240},
    { 328, 936, 256},
    { 368, 944, 240},
    { 392, 912, 208},
    { 384, 872, 208},
    { 408, 872, 200},
    { 416, 872, 192},
    // 7 seconds
    { 448, 888, 208},
    { 504, 912, 168},
    { 488, 872, 120},
    { 536, 872, 80},
    { 608, 904, 32},
    { 624, 912, 40},
    { 696, 976, -88},
    { 744, 872, -152},
    { 616, 672, -200},
    { 576, 672, -360},
    { 640, 704, -472},
    { 712, 720, -520},
    { 744, 600, -640},
    { 712, 424, -632},
    { 656, 464, -648},
    { 616, 280, -616},
    { 584, 272, -608},
    { 528, 296, -608},
    { 480, 336, -464},
    { 440, 440, -456},
    { 440, 520, -544},
    { 432, 552, -616},
    { 376, 608, -520},
    { 392, 696, -640},
    { 400, 880, -568},
    // 8 seconds
    { 488, 1000, -552},
    { 552, 1056, -488},
    { 752, 912, -488},
    { 744, 832, -344},
    { 568, 1072, -376},
    { 352, 1064, -224},
    { 144, 984, -136},
    { 128, 880, -176},
    { 64, 776, -224},
    { 168, 720, -240},
    { 96, 912, -392},
    { 80, 888, -360},
    { 32, 864, -392},
    { -32, 944, -288},
    { -88, 888, -280},
    { -72, 768, -248},
    { -88, 872, -392},
    { -80, 912, -384},
    { -96, 840, -304},
    { -168, 824, -384},
    { -160, 888, -384},
    { -184, 896, -344},
    { -152, 696, -400},
    { -176, 824, -384},
    { -176, 880, -384},
    // 9 seconds
    { -168, 800, -432},
    { -192, 848, -416},
    { -192, 888, -424},
    { -184, 832, -472},
    { -192, 824, -416},
    { -200, 800, -456},
    { -192, 776, -496},
    { -184, 768, -464},
    { -192, 800, -464},
    { -176, 800, -504},
    { -184, 808, -488},
    { -160, 816, -496},
    { -176, 840, -488},
    { -168, 832, -504},
    { -152, 800, -512},
    { -160, 792, -512},
    { -160, 768, -504},
    { -152, 792, -504},
    { -136, 832, -512},
    { -152, 832, -504},
    { -152, 784, -520},
    { -144, 800, -512},
    { -144, 792, -512},
    { -144, 808, -528},
    { -144, 832, -528},
    // 10 seconds
    { -144, 800, -520},
    { -144, 760, -512},
    { -128, 768, -520},
    { -136, 864, -456},
    { -152, 832, -408},
    { -152, 840, -472},
    { -136, 840, -520},
    { -152, 912, -408},
    { -112, 816, -488},
    { -72, 736, -560},
    { -48, 792, -592},
    { -48, 720, -520},
    { -72, 728, -368},
    { -32, 824, -448},
    { -80, 1088, -320},
    { -120, 976, -152},
    { -144, 992, -80},
    { -128, 984, 0},
    { -96, 984, -8},
    { -96, 1056, 64},
    { -120, 984, 136},
    { -96, 984, 80},
    { -112, 976, 136},
    { -88, 936, 112},
    { -112, 960, 120},
    // 11 seconds
    { -88, 984, 96},
    { -88, 1024, 192},
    { -88, 1072, 168},
    { -88, 1048, 208},
    { -104, 1008, 200},
    { -104, 968, 200},
    { -128, 936, 224},
    { -120, 952, 208},
    { -96, 920, 248},
    { -96, 920, 272},
    { -80, 928, 280},
    { -88, 928, 304},
    { -96, 920, 304},
    { -128, 888, 384},
    { -128, 952, 392},
    { -120, 880, 408},
    { -88, 840, 352},
    { -64, 816, 248},
    { -40, 848, 312},
    { 16, 920, 464},
    { 16, 856, 544},
    { 48, 960, 656},
    { 64, 1032, 800},
    { 40, 912, 712},
    { 8, 864, 496},
    // 12 seconds
    { 40, 856, 440},
    { 32, 1008, 480},
    { 40, 1048, 464},
    { 96, 1008, 320},
    { 88, 928, 352},
    { 80, 976, 312},
    { 72, 928, 264},
    { 40, 912, 216},
    { 24, 960, 240},
    { 16, 984, 240},
    { 0, 984, 248},
    { 24, 1024, 208},
    { 16, 1000, 272},
    { 8, 952, 280},
    { 8, 960, 264},
    { 0, 984, 240},
    { -16, 968, 256},
    { -8, 952, 256},
    { -8, 960, 256},
    { 8, 992, 240},
    { 24, 1024, 168},
    { 16, 968, 200},
    { 24, 976, 184},
    { 16, 1032, 216},
    { -8, 1128, 232},
    // 13 seconds
    { -16, 1072, 224},
    { -72, 1120, 144},
    { -120, 1008, 88},
    { -200, 840, 168},
    { -152, 872, 88},
    { -192, 1304, 24},
    { -216, 928, 88},
    { -192, 1080, 0},
    { -160, 880, -288},
    { -208, 592, -400},
    { -184, 568, -512},
    { -160, 776, -552},
    { -176, 856, -440},
    { -184, 1048, -352},
    { -128, 912, -232},
    { -168, 928, -152},
    { -160, 912, -104},
    { -168, 936, -112},
    { -192, 872, -120},
    { -224, 960, -120},
    { -248, 960, -120},
    { -256, 936, -112},
    { -248, 904, -120},
    { -240, 888, -112},
    { -192, 944, -104},
    // 14 seconds
    { -88, 952, -296},
    { -88, 1008, -248},
    { -80, 1168, -400},
    { -160, 1120, -416},
    { -280, 1256, -384},
    { -400, 1016, -360},
    { -432, 552, -368},
    { -504, 128, -304},
    { -360, -16, -384},
    { -248, 40, -568},
    { -128, 336, -808},
    { -184, 424, -952},
    { -176, 576, -1168},
    { -152, 336, -1080},
    { -120, 280, -992},
    { -56, 256, -1008},
    { -64, 288, -744},
    { -8, 296, -928},
    { -16, 224, -904},
    { -24, 200, -840},
    { 0, 168, -1008},
    { -24, 200, -1008},
    { -32, 200, -968},
    { -32, 144, -904},
    { -32, 120, -912},
    // 15 seconds
    { -40, 96, -872},
    { -8, 88, -944},
    { 8, 96, -944},
    { 56, 144, -1008},
    { 64, 104, -1080},
    { -64, 208, -920},
    { -64, 72, -720},
    { 0, 216, -824},
    { -24, 568, -936},
    { -56, 512, -760},
    { 24, 480, -712},
    { 48, 400, -800},
    { 128, 600, -896},
    { 104, 680, -776},
    { 64, 776, -440},
    { 0, 1320, -192},
    { 40, 1112, -208},
    { 56, 984, -232},
    { 96, 1080, -360},
    { 104, 928, -400},
    { 144, 760, -344},
    { 136, 712, -336},
    { 136, 760, -264},
    { 136, 792, -216},
    { 120, 928, -176},
    // 16 seconds
    { 112, 904, -120},
    { 136, 896, -40},
    { 160, 856, -64},
    { 216, 1136, 96},
    { 232, 1144, 256},
    { 216, 1032, 296},
    { 216, 1040, 328},
    { 224, 992, 296},
    { 264, 936, 280},
    { 248, 928, 408},
    { 256, 936, 400},
    { 248, 896, 352},
    { 256, 952, 192},
    { 216, 760, 224},
    { 144, 1000, 104},
    { 168, 784, 32},
    { 128, 864, 0},
    { 96, 816, 120},
    { 168, 824, 296},
    { 240, 976, 264},
    { 296, 936, 368},
    { 360, 752, 440},
    { 528, 936, 304},
    { 712, 736, 328},
    { 784, 680, 200},
    // 17 seconds
    { 1016, 512, 40},
    { 1240, 544, 0},
    { 1296, 520, -48},
    { 1192, 552, -104},
    { 1048, 544, -136},
    { 1040, 568, -184},
    { 976, 456, -152},
    { 928, 400, -152},
    { 816, 344, -192},
    { 848, 384, -112},
    { 960, 368, -208},
    { 1008, 312, -256},
    { 952, 304, -224},
    { 960, 96, -296},
    { 1016, 136, -376},
    { 976, 408, -384},
    { 944, 360, -392},
    { 944, 264, -352},
    { 912, 368, -256},
    { 976, 208, -336},
    { 1008, 256, -240},
    { 1016, 216, -248},
    { 992, 232, -288},
    { 920, 320, -296},
    { 840, 272, -280},
    // 18 seconds
    { 784, 296, -112},
    { 824, 504, -408},
    { 1008, 224, -392},
    { 1168, 352, -160},
    { 1224, 264, -208},
    { 1232, 168, -176},
    { 1192, 104, -72},
    { 1176, 368, -104},
    { 1168, 320, -208},
    { 1088, 352, -232},
    { 968, 352, -208},
    { 864, 352, -216},
    { 888, 320, -216},
    { 872, 304, -144},
    { 920, 296, -88},
    { 920, 312, -88},
    { 944, 216, -80},
    { 896, 240, 16},
    { 896, 312, 40},
    { 856, 376, 104},
    { 800, 376, 96},
    { 776, 392, 128},
    { 832, 456, 136},
    { 928, 488, 184},
    { 968, 576, 120},
    // 19 seconds
    { 912, 616, 120},
    { 888, 680, -56},
    { 888, 696, -64},
    { 904, 688, -120},
    { 1112, 736, -176},
    { 1160, 816, -232},
    { 1176, 792, -296},
    { 1176, 664, -192},
    { 984, 568, -200},
    { 720, 520, -216},
    { 808, 528, -264},
    { 976, 440, -168},
    { 1184, 424, -104},
    { 1216, 376, -80},
    { 1144, 400, -96},
    { 1080, 408, -128},
    { 960, 392, -184},
    { 832, 376, -216},
    { 696, 344, -248},
    { 576, 392, -272},
    { 544, 448, -304},
    { 512, 480, -280},
    { 592, 544, -336},
    { 728, 528, -360},
    { 824, 440, -280},
    // 20 seconds
    { 1016, 440, -264},
    { 936, 504, -432},
    { 1008, 536, -560},
    { 1144, 488, -392},
    { 968, 360, -176},
    { 872, 424, -168},
    { 752, 504, -208},
    { 824, 520, -144},
    { 880, 504, -232},
    { 792, 472, -304},
    { 816, 472, -400},
    { 872, 464, -480},
    { 840, 344, -328},
    { 848, 336, -272},
    { 896, 400, -232},
    { 904, 440, -128},
    { 1280, 504, -80},
    { 1032, 648, -64},
    { 920, 592, -40},
    { 1352, 688, 8},
    { 1560, 704, 104},
    { 1256, 488, 160},
    { 1160, 408, 128},
    { 1112, 400, 112},
    { 984, 352, 88},
    // 21 seconds
    { 872, 344, 16},
    { 856, 352, -112},
    { 856, 328, -200},
    { 928, 272, -208},
    { 1048, 176, -160},
    { 872, 80, -200},
    { 784, 64, -200},
    { 840, 80, -168},
    { 736, 168, -240},
    { 1072, 288, -480},
    { 1416, 352, -360},
    { 1208, 248, -216},
    { 904, 336, -312},
    { 720, 472, -368},
    { 648, 480, -360},
    { 760, 472, -400},
    { 864, 472, -472},
    { 824, 424, -440},
    { 848, 472, -496},
    { 880, 448, -400},
    { 992, 464, -264},
    { 1280, 560, -184},
    { 1248, 736, -320},
    { 1512, 840, -176},
    { 1528, 688, -8},
    // 22 seconds
    { 1416, 520, -40},
    { 1168, 448, -24},
    { 984, 376, -16},
    { 816, 280, 24},
    { 744, 248, 24},
    { 760, 240, 0},
    { 872, 216, -8},
    { 1008, 224, -80},
    { 936, 128, -56},
    { 944, 24, -72},
    { 1008, 56, -88},
    { 1200, 224, -184},
    { 1432, 312, -240},
    { 1352, 312, -200},
    { 1104, 384, -272},
    { 864, 480, -344},
    { 704, 440, -264},
    { 736, 464, -272},
    { 776, 512, -328},
    { 784, 600, -456},
    { 800, 680, -520},
    { 864, 688, -488},
    { 1040, 664, -376},
    { 1472, 752, -288},
    { 1320, 728, -208},
    // 23 seconds
    { 1512, 680, -160},
    { 1560, 608, -40},
    { 1328, 480, -40},
    { 1048, 376, -8},
    { 896, 288, -16},
    { 864, 280, -40},
    { 816, 176, -32},
    { 832, 88, -16},
    { 896, 16, 40},
    { 984, -32, 80},
    { 1048, 24, 8},
    { 1136, 80, 0},
    { 1152, 224, -176},
    { 1560, 376, -352},
    { 1624, 336, -208},
    { 1272, 312, -208},
    { 1024, 496, -384},
    { 760, 528, -328},
    { 696, 536, -328},
    { 696, 584, -320},
    { 792, 624, -392},
    { 816, 656, -384},
    { 864, 688, -392},
    { 864, 688, -312},
    { 1216, 680, -240},
    // 24 seconds
    { 1336, 720, -264},
    { 1448, 688, -264},
    { 1576, 616, -128},
    { 1544, 536, -40},
    { 1248, 424, -72},
    { 976, 368, -48},
    { 848, 296, -72},
    { 792, 248, -56},
    { 768, 192, -80},
    { 792, 128, -56},
    { 952, 80, -96},
    { 928, -8, -40},
    { 1016, 64, -24},
    { 1080, 152, -56},
    { 1256, 280, -200},
    { 1560, 384, -232},
    { 1552, 360, -168},
    { 1264, 424, -288},
    { 960, 504, -336},
    { 768, 520, -264},
    { 728, 536, -256},
    { 712, 576, -328},
    { 784, 560, -464},
    { 848, 568, -424},
    { 960, 640, -448},
    // 25 seconds
    { 896, 664, -344},
    { 1272, 712, -264},
    { 1240, 736, -280},
    { 1472, 680, -144},
    { 1528, 600, 0},
    { 1584, 496, -80},
    { 1384, 392, -96},
    { 968, 328, -16},
    { 888, 296, -216},
    { 800, 256, -152},
    { 696, 160, -144},
    { 616, 120, -128},
    { 792, 16, -104},
    { 880, -176, -64},
    { 1016, -48, 48},
    { 1320, 160, 0},
    { 1776, 368, -272},
    { 1824, 392, -64},
    { 1592, 416, -128},
    { 1240, 592, -432},
    { 856, 584, -368},
    { 760, 496, -296},
    { 696, 616, -296},
    { 704, 768, -344},
    { 800, 720, -432},
    // 26 seconds
    { 904, 632, -312},
    { 896, 712, -328},
    { 1136, 664, -256},
    { 1400, 640, -264},
    { 1320, 624, -288},
    { 1480, 704, -280},
    { 1664, 648, -152},
    { 1488, 440, -48},
    { 1152, 248, -64},
    { 984, 240, -136},
    { 936, 200, -128},
    { 896, 160, -88},
    { 816, 112, -32},
    { 776, 80, -24},
    { 896, 64, 0},
    { 872, 32, 24},
    { 1056, 96, 64},
    { 1240, 224, 64},
    { 1512, 320, -128},
    { 1576, 376, -112},
    { 1424, 416, -136},
    { 1192, 528, -456},
    { 928, 576, -368},
    { 824, 576, -248},
    { 792, 624, -272},
    // 27 seconds
    { 832, 696, -376},
    { 840, 624, -320},
    { 968, 680, -344},
    { 904, 704, -248},
    { 1168, 720, -208},
    { 1296, 760, -256},
    { 1288, 728, -272},
    { 1440, 648, -232},
    { 1600, 576, -128},
    { 1280, 464, -136},
    { 1016, 392, -128},
    { 864, 296, -88},
    { 752, 216, -56},
    { 696, 168, -24},
    { 720, 152, -48},
    { 880, 168, -88},
    { 952, 120, -8},
    { 1048, 136, -32},
    { 1232, 152, 48},
    { 1400, 288, -136},
    { 1624, 408, -288},
    { 1480, 360, -192},
    { 1152, 312, -312},
    { 848, 416, -352},
    { 688, 440, -280},
    // 28 seconds
    { 632, 504, -272},
    { 712, 576, -344},
    { 880, 664, -432},
    { 984, 616, -336},
    { 992, 736, -408},
    { 864, 680, -312},
    { 1216, 680, -224},
    { 1256, 696, -264},
    { 1392, 672, -288},
    { 1624, 600, -88},
    { 1608, 520, -96},
    { 1264, 432, -144},
    { 992, 376, -136},
    { 840, 272, -120},
    { 744, 208, -64},
    { 720, 184, -40},
    { 720, 160, -24},
    { 872, 160, -64},
    { 872, 136, 0},
    { 1040, 136, 48},
    { 1200, 240, -8},
    { 1288, 280, -120},
    { 1520, 296, -216},
    { 1536, 520, -232},
    { 1184, 624, -288},
    // 29 seconds
    { 888, 600, -200},
    { 704, 608, -112},
    { 688, 584, -64},
    { 744, 632, -104},
    { 832, 672, -128},
    { 880, 648, -192},
    { 904, 752, -264},
    { 1008, 688, -216},
    { 1328, 712, -224},
    { 1200, 776, -312},
    { 1512, 712, -184},
    { 1696, 552, -80},
    { 1472, 432, -128},
    { 1096, 328, -120},
    { 880, 312, -88},
    { 832, 256, -24},
    { 744, 216, -40},
    { 768, 200, -48},
    { 776, 160, 0},
    { 936, 144, -32},
    { 936, -16, 72},
    { 1144, -16, 64},
    { 1304, 160, -8},
    { 1416, 336, -152},
    { 1472, 256, -120},
    // 30 seconds
    { 1464, 232, -192},
    { 1192, 384, -312},
    { 952, 456, -296},
    { 824, 480, -272},
    { 760, 504, -240},
    { 792, 544, -352},
    { 880, 560, -368},
    { 920, 512, -424},
    { 968, 528, -488},
    { 1032, 536, -392},
    { 1176, 512, -376},
    { 1240, 552, -344},
    { 1416, 608, -384},
    { 1640, 496, -208},
    { 1696, 392, -136},
    { 1312, 328, -176},
    { 920, 280, -104},
    { 672, 216, -64},
    { 560, 160, -64},
    { 624, 160, -40},
    { 704, 160, 0},
    { 896, 192, -88},
    { 1096, 176, -80},
    { 1176, 32, 48},
    { 1208, 104, 88},
    // 31 seconds
    { 1352, 368, -120},
    { 1600, 360, -144},
    { 1360, 296, -144},
    { 1048, 296, -280},
    { 816, 384, -296},
    { 640, 416, -312},
    { 632, 432, -312},
    { 704, 528, -440},
    { 904, 576, -600},
    { 968, 552, -504},
    { 1016, 664, -544},
    { 952, 640, -328},
    { 1184, 672, -304},
    { 1168, 816, -384},
    { 1680, 848, -160},
    { 1824, 576, 48},
    { 1744, 552, -24},
    { 1432, 520, -8},
    { 1176, 328, 72},
    { 824, 48, 48},
    { 696, 136, -24},
    { 696, 80, -112},
    { 728, 8, -32},
    { 784, -72, -16},
    { 856, -40, -80},
    // 32 seconds
    { 984, 80, -112},
    { 1280, 168, 0},
    { 1448, 312, -176},
    { 1688, 368, -256},
    { 1688, 368, -96},
    { 1440, 400, -360},
    { 1040, 480, -360},
    { 784, 520, -272},
    { 704, 544, -352},
    { 760, 592, -376},
    { 792, 552, -368},
    { 832, 584, -304},
    { 888, 680, -344},
    { 800, 712, -264},
    { 1184, 696, -168},
    { 1352, 736, -248},
    { 1520, 752, -192},
    { 1648, 592, -8},
    { 1672, 552, -64},
    { 1376, 464, -88},
    { 1120, 360, -32},
    { 1000, 304, -16},
    { 920, 224, -40},
    { 864, 184, -40},
    { 800, 96, -16},
    // 33 seconds
    { 888, 32, -48},
    { 840, -88, 80},
    { 1008, -8, 128},
    { 1296, 112, 120},
    { 1480, 296, 56},
    { 1568, 432, -144},
    { 1576, 480, -176},
    { 1408, 536, -376},
    { 1120, 592, -312},
    { 928, 608, -160},
    { 784, 712, -200},
    { 760, 736, -288},
    { 800, 688, -360},
    { 824, 664, -328},
    { 816, 688, -304},
    { 856, 648, -216},
    { 1200, 680, -128},
    { 1320, 824, -272},
    { 1464, 760, -176},
    { 1512, 704, -72},
    { 1664, 640, -88},
    { 1432, 528, 0},
    { 1176, 376, 56},
    { 1008, 296, 48},
    { 904, 264, 24},
    // 34 seconds
    { 832, 208, 32},
    { 776, 160, 40},
    { 856, 120, 0},
    { 840, -8, 72},
    { 1040, 8, 56},
    { 1200, 112, 48},
    { 1552, 296, -72},
    { 1728, 392, -168},
    { 1544, 376, -112},
    { 1248, 440, -296},
    { 952, 464, -336},
    { 840, 464, -216},
    { 848, 504, -224},
    { 920, 616, -352},
    { 976, 688, -392},
    { 888, 672, -392},
    { 896, 704, -376},
    { 872, 624, -248},
    { 1120, 592, -184},
    { 1328, 576, -272},
    { 1384, 632, -104},
    { 1480, 696, -80},
    { 1568, 656, -168},
    { 1360, 560, -96},
    { 1144, 456, -24},
    // 35 seconds
    { 1080, 336, 0},
    { 912, 168, 88},
    { 840, 152, 24},
    { 776, 112, -16},
    { 784, 72, 0},
    { 824, 48, 16},
    { 936, 104, 16},
    { 1200, 200, 48},
    { 1200, 392, -384},
    { 1504, 216, -304},
    { 1496, 184, -120},
    { 1176, 304, -448},
    { 888, 440, -568},
    { 680, 368, -384},
    { 696, 288, -296},
    { 824, 280, -304},
    { 920, 296, -472},
    { 896, 408, -536},
    { 984, 488, -584},
    { 968, 536, -416},
    { 1392, 624, -392},
    { 1296, 664, -464},
    { 1440, 688, -368},
    { 1736, 576, -208},
    { 1656, 408, -144},
    // 36 seconds
    { 1288, 296, -136},
    { 1032, 280, -72},
    { 912, 272, -88},
    { 824, 216, -88},
    { 728, 128, -40},
    { 640, 64, 8},
    { 696, 88, -24},
    { 776, 96, 8},
    { 944, 152, -16},
    { 1264, 184, 8},
    { 1456, 288, -112},
    { 1584, 312, -232},
    { 1624, 272, -96},
    { 1368, 304, -232},
    { 1056, 368, -320},
    { 904, 408, -168},
    { 824, 512, -208},
    { 872, 632, -248},
    { 968, 752, -288},
    { 960, 776, -248},
    { 992, 880, -320},
    { 864, 744, -280},
    { 1224, 576, -192},
    { 1240, 752, -216},
    { 1392, 784, -304},
    // 37 seconds
    { 1816, 592, -104},
    { 1816, 496, -40},
    { 1472, 440, -72},
    { 1224, 336, 0},
    { 1120, 216, 8},
    { 976, 64, 56},
    { 816, 0, 8},
    { 704, 16, 40},
    { 696, 96, -8},
    { 736, 72, 0},
    { 936, -80, 24},
    { 1248, -72, 48},
    { 1752, 248, 8},
    { 1896, 488, -168},
    { 1840, 312, -152},
    { 1536, 400, -384},
    { 1136, 512, -256},
    { 888, 600, -312},
    { 808, 672, -344},
    { 840, 632, -304},
    { 816, 616, -320},
    { 760, 696, -304},
    { 776, 720, -256},
    { 944, 712, -112},
    { 1456, 736, -88},
    // 38 seconds
    { 1328, 656, -112},
    { 1528, 656, -104},
    { 1784, 632, -32},
    { 1536, 504, -32},
    { 1280, 408, -128},
    { 1096, 256, -48},
    { 1016, 216, -88},
    { 952, 168, -88},
    { 848, 80, -64},
    { 744, 8, 0},
    { 856, -72, 32},
    { 888, -128, 80},
    { 1120, 80, 16},
    { 1352, 224, -8},
    { 1584, 312, -88},
    { 1696, 312, -136},
    { 1600, 344, -216},
    { 1216, 472, -328},
    { 952, 528, -280},
    { 800, 480, -224},
    { 752, 528, -240},
    { 784, 552, -320},
    { 840, 568, -384},
    { 992, 624, -352},
    { 976, 760, -336},
    // 39 seconds
    { 1168, 800, -256},
    { 1360, 696, -240},
    { 1272, 696, -264},
    { 1528, 664, -248},
    { 1576, 456, -40},
    { 1408, 360, -72},
    { 1208, 336, -88},
    { 1024, 296, -72},
    { 920, 240, -48},
    { 848, 136, -16},
    { 816, 72, 8},
    { 832, 64, -16},
    { 976, 8, 16},
    { 992, -120, 96},
    { 1312, 120, 32},
    { 1344, 304, -152},
    { 1640, 296, -152},
    { 1536, 200, -40},
    { 1352, 304, -184},
    { 1152, 544, -320},
    { 880, 584, -248},
    { 800, 600, -288},
    { 856, 648, -392},
    { 896, 648, -464},
    { 872, 656, -480},
    // 40 seconds
    { 968, 664, -416},
    { 944, 648, -296},
    { 1280, 600, -192},
    { 1280, 616, -216},
    { 1368, 680, -264},
    { 1568, 576, -80},
    { 1560, 456, -8},
    { 1312, 384, -88},
    { 1096, 328, -96},
    { 944, 304, -136},
    { 920, 232, -128},
    { 872, 88, -64},
    { 832, 8, 0},
    { 896, -8, -56},
    { 912, -96, 48},
    { 1056, -168, 136},
    { 1328, 112, 96},
    { 1480, 384, -136},
    { 1624, 328, -144},
    { 1544, 216, -88},
    { 1288, 392, -296},
    { 1008, 528, -336},
    { 808, 520, -224},
    { 800, 568, -296},
    { 816, 632, -352},
    // 41 seconds
    { 904, 688, -472},
    { 872, 696, -512},
    { 952, 664, -408},
    { 1056, 624, -256},
    { 1280, 616, -184},
    { 1184, 696, -288},
    { 1472, 704, -216},
    { 1672, 504, 16},
    { 1504, 408, -136},
    { 1184, 376, -144},
    { 1016, 352, -128},
    { 960, 256, -64},
    { 880, 176, -48},
    { 792, 136, -32},
    { 744, 112, -32},
    { 896, 24, -88},
    { 1032, 0, 64},
    { 1200, -256, 280},
    { 1472, 72, 64},
    { 1680, 168, -128},
    { 1760, 152, -128},
    { 1592, 192, -232},
    { 1392, 520, -368},
    { 1032, 664, -272},
    { 888, 632, -288},
    // 42 seconds
    { 888, 624, -320},
    { 904, 648, -456},
    { 784, 608, -408},
    { 816, 616, -376},
    { 888, 616, -232},
    { 1408, 632, -192},
    { 1192, 696, -264},
    { 1440, 680, -208},
    { 1688, 608, -48},
    { 1728, 480, -128},
    { 1368, 376, -152},
    { 1200, 336, -152},
    { 1184, 232, -152},
    { 1056, 8, -64},
    { 848, -120, -32},
    { 728, -136, -24},
    { 792, -56, 8},
    { 784, 8, 24},
    { 1080, 96, 136},
    { 1256, 192, 176},
    { 1512, 312, 40},
    { 1672, 344, 88},
    { 1544, 384, 16},
    { 1216, 456, -312},
    { 968, 464, -408},
    // 43 seconds
    { 832, 384, -320},
    { 896, 384, -352},
    { 936, 520, -448},
    { 960, 616, -552},
    { 944, 648, -536},
    { 952, 736, -480},
    { 1048, 720, -304},
    { 1328, 744, -328},
    { 1240, 760, -280},
    { 1448, 720, -216},
    { 1760, 664, -72},
    { 1752, 472, -32},
    { 1352, 296, 0},
    { 1088, 288, -8},
    { 936, 232, 8},
    { 856, 176, 16},
    { 704, 112, 32},
    { 632, 80, 32},
    { 704, 80, 16},
    { 792, 96, -8},
    { 1048, 112, 56},
    { 1200, 224, -24},
    { 1456, 304, -160},
    { 1728, 280, -40},
    { 1560, 336, -40},
    // 44 seconds
    { 1296, 456, -328},
    { 1032, 552, -400},
    { 856, 464, -176},
    { 984, 568, -336},
    { 1048, 664, -328},
    { 920, 680, -400},
    { 888, 672, -432},
    { 856, 696, -344},
    { 1048, 672, -248},
    { 1360, 776, -112},
    { 1376, 832, -80},
    { 1544, 672, 48},
    { 1720, 496, 96},
    { 1528, 384, 32},
    { 1216, 296, -16},
    { 1024, 312, -40},
    { 944, 264, -8},
    { 880, 200, 40},
    { 864, 160, 24},
    { 800, 112, 24},
    { 904, 80, 56},
    { 936, 64, 56},
    { 1200, 112, 72},
    { 1296, 248, -40},
    { 1528, 288, -112},
    // 45 seconds
    { 1520, 272, -24},
    { 1336, 360, -136},
    { 1112, 504, -320},
    { 896, 536, -320},
    { 840, 488, -240},
    { 952, 664, -360},
    { 984, 712, -368},
    { 872, 632, -352},
    { 912, 656, -344},
    { 864, 640, -256},
    { 1208, 608, -208},
    { 1304, 696, -312},
    { 1504, 680, -280},
    { 1600, 520, -80},
    { 1648, 480, -112},
    { 1488, 392, -136},
    { 1152, 304, -56},
    { 1000, 232, -56},
    { 816, 128, -40},
    { 792, 104, -24},
    { 656, 56, 16},
    { 672, 56, -8},
    { 728, 96, 16},
    { 912, 192, -16},
    { 1192, 224, 16},
    // 46 seconds
    { 1632, 312, -56},
    { 1688, 336, -168},
    { 1552, 368, -200},
    { 1176, 368, -248},
    { 920, 424, -304},
    { 808, 480, -272},
    { 800, 576, -328},
    { 792, 672, -352},
    { 896, 784, -520},
    { 936, 728, -440},
    { 952, 728, -464},
    { 984, 608, -304},
    { 1392, 600, -280},
    { 1440, 544, -224},
    { 1576, 544, -160},
    { 1808, 560, -64},
    { 1720, 488, -88},
    { 1304, 368, -104},
    { 976, 272, -56},
    { 808, 192, -40},
    { 712, 104, -64},
    { 664, 64, -56},
    { 680, 32, -32},
    { 840, 56, -96},
    { 944, 24, -144},
    // 47 seconds
    { 1128, 88, 0},
    { 1384, 184, 40},
    { 1360, 392, -176},
    { 1560, 416, -232},
    { 1648, 424, -144},
    { 1296, 480, -288},
    { 976, 536, -312},
    { 816, 664, -344},
    { 784, 552, -424},
    { 784, 512, -576},
    { 776, 472, -568},
    { 808, 480, -544},
    { 936, 472, -464},
    { 1056, 480, -312},
    { 1456, 560, -328},
    { 1280, 584, -336},
    { 1632, 576, -224},
    { 1904, 464, -8},
    { 1672, 368, -56},
    { 1264, 312, -56},
    { 1008, 296, -72},
    { 872, 264, -64},
    { 824, 312, -96},
    { 816, 48, -32},
    { 736, -16, -48},
    // 48 seconds
    { 760, -40, -48},
    { 776, -48, -56},
    { 968, 0, -56},
    { 1168, 112, -88},
    { 1424, 72, -232},
    { 1728, 128, -192},
    { 1672, 120, -256},
    { 1384, 120, -344},
    { 1080, 560, -456},
    { 760, 600, -680},
    { 792, 504, -664},
    { 864, 504, -672},
    { 776, 352, -688},
    { 736, 568, -816},
    { 800, 584, -808},
    { 960, 640, -888},
    { 1528, 736, -880},
    { 1960, 664, -560},
    { 2136, 432, -352},
    { 1936, 456, -200},
    { 1528, 328, -208},
    { 1128, 208, -144},
    { 832, 80, -144},
    { 640, 8, -184},
    { 512, -96, -248},
    // 49 seconds
    { 408, -64, -328},
    { 328, 0, -464},
    { 424, 8, -768},
    { 480, -16, -800},
    { 680, -104, -928},
    { 600, -128, -824},
    { 632, -16, -1032},
    { 544, -80, -976},
    { 472, -40, -992},
    { 280, -96, -872},
    { 184, -144, -752},
    { 152, -200, -624},
    { 152, -232, -584},
    { 160, -216, -672},
    { 248, -184, -896},
    { 224, -256, -968},
    { 288, -224, -1056},
    { 328, -256, -1216},
    { 352, -104, -1280},
    { 168, 192, -1136},
    { 16, 448, -1104},
    { 48, 496, -1168},
    { 168, 184, -976},
    { 152, -32, -800},
    { 128, -144, -648},
    // 50 seconds
    { 56, -272, -664},
    { 56, -336, -744},
    { 80, -280, -768},
    { 96, -200, -672},
    { 184, -272, -416},
    { 616, 80, -368},
    { 792, 312, 40},
    { 1440, 912, 24},
    { 1824, 840, -144},
    { 1880, 824, -88},
    { 1936, 896, -24},
    { 1728, 720, -40},
    { 1392, 760, -128},
    { 1000, 848, -16},
    { 840, 712, -128},
    { 808, 728, -192},
    { 784, 608, -144},
    { 664, 632, -128},
    { 704, 744, -40},
    { 784, 1056, -224},
    { 1176, 912, -144},
    { 1336, 824, -264},
    { 1472, 824, -280},
    { 1592, 608, -160},
    { 1768, 552, -128},
    // 51 seconds
    { 1736, 520, -88},
    { 1352, 384, -80},
    { 1112, 296, -88},
    { 960, 200, -32},
    { 808, 144, 24},
    { 736, 120, -32},
    { 664, 32, -112},
    { 808, 40, -232},
    { 856, -40, -160},
    { 1080, -80, -8},
    { 1232, 184, 16},
    { 1504, 408, -80},
    { 1704, 472, 0},
    { 1648, 496, 8},
    { 1392, 624, -424},
    { 1000, 696, -240},
    { 832, 536, -248},
    { 880, 528, -320},
    { 904, 536, -536},
    { 864, 512, -440},
    { 832, 496, -344},
    { 888, 656, -352},
    { 880, 720, -264},
    { 1064, 728, -208},
    { 1128, 784, -296},
    // 52 seconds
    { 1544, 784, -160},
    { 1744, 712, -88},
    { 1672, 544, -104},
    { 1384, 408, -96},
    { 1232, 368, -136},
    { 1088, 272, -136},
    { 904, 160, -152},
    { 800, -120, -200},
    { 624, -344, -80},
    { 552, -240, 96},
    { 696, 16, -24},
    { 1120, 256, -144},
    { 1376, 328, -80},
    { 1728, 400, -280},
    { 1856, 520, -280},
    { 1640, 384, -32},
    { 1280, 376, -280},
    { 944, 536, -368},
    { 784, 464, -248},
    { 752, 440, -304},
    { 752, 488, -352},
    { 792, 560, -424},
    { 872, 680, -456},
    { 968, 904, -464},
    { 968, 848, -296},
    // 53 seconds
    { 1304, 672, -224},
    { 1272, 712, -224},
    { 1608, 672, -136},
    { 1776, 576, 64},
    { 1672, 512, 8},
    { 1304, 384, -64},
    { 1048, 328, -24},
    { 976, 272, -48},
    { 872, 168, 8},
    { 760, 72, -16},
    { 672, 56, 0},
    { 760, 56, 0},
    { 784, 64, -16},
    { 1040, 200, -64},
    { 1256, 240, 16},
    { 1352, 480, -256},
    { 1608, 392, -88},
    { 1536, 472, 16},
    { 1232, 848, -384},
    { 832, 704, -360},
    { 736, 320, -352},
    { 696, 384, -424},
    { 720, 440, -480},
    { 864, 336, -520},
    { 888, 392, -488},
    // 54 seconds
    { 960, 464, -496},
    { 984, 480, -432},
    { 1392, 600, -400},
    { 1152, 672, -416},
    { 1416, 616, -312},
    { 1712, 592, -152},
    { 1584, 552, -200},
    { 1216, 416, -168},
    { 1016, 360, -136},
    { 888, 280, -128},
    { 816, 232, -72},
    { 776, 168, -64},
    { 736, 152, 8},
    { 784, 128, 8},
    { 888, 128, 56},
    { 984, 184, 72},
    { 1152, 240, 112},
    { 1184, 312, -112},
    { 1536, 368, -152},
    { 1552, 376, -64},
    { 1320, 360, -320},
    { 1080, 488, -544},
    { 800, 416, -296},
    { 808, 440, -440},
    { 816, 536, -472},
    // 55 seconds
    { 888, 568, -512},
    { 936, 544, -440},
    { 928, 632, -384},
    { 896, 656, -272},
    { 1224, 640, -184},
    { 1256, 712, -336},
    { 1456, 672, -232},
    { 1624, 584, -48},
    { 1712, 568, -104},
    { 1384, 440, -112},
    { 1120, 368, -112},
    { 1016, 288, -96},
    { 944, 216, -96},
    { 840, 32, -64},
    { 704, 16, -40},
    { 784, 272, -96},
    { 784, 224, -88},
    { 920, 184, -16},
    { 1032, 264, 48},
    { 1192, 328, -96},
    { 1344, 344, -128},
    { 1448, 360, 128},
    { 1432, 608, -88},
    { 1048, 1144, -312},
    { 784, 840, -32},
    // 56 seconds
    { 656, 696, -160},
    { 728, 768, -256},
    { 840, 800, -272},
    { 896, 816, -288},
    { 904, 864, -272},
    { 872, 768, -152},
    { 1200, 784, -88},
    { 1216, 912, -248},
    { 1568, 848, -88},
    { 1648, 600, 72},
    { 1536, 520, -96},
    { 1168, 432, -128},
    { 968, 336, -32},
    { 896, 232, -64},
    { 832, 168, -40},
    { 744, 144, -56},
    { 688, 136, -32},
    { 824, 128, -40},
    { 832, 104, 16},
    { 1040, 160, -16},
    { 1048, 224, -8},
    { 1296, 288, -160},
    { 1560, 328, -176},
    { 1488, 352, -152},
    { 1320, 464, -520},
    // 57 seconds
    { 992, 472, -408},
    { 800, 432, -272},
    { 800, 520, -384},
    { 832, 552, -408},
    { 832, 552, -424},
    { 944, 552, -400},
    { 896, 640, -320},
    { 1048, 688, -208},
    { 1304, 728, -208},
    { 1400, 784, -280},
    { 1608, 688, -96},
    { 1648, 552, -48},
    { 1424, 416, -136},
    { 1144, 304, -136},
    { 984, 296, -128},
    { 904, 224, -104},
    { 832, 168, -56},
    { 728, 144, -16},
    { 712, 128, 16},
    { 816, 80, 32},
    { 888, -64, 176},
    { 1104, 72, 128},
    { 1296, 288, -80},
    { 1632, 392, -168},
    { 1688, 280, -72},
    // 58 seconds
    { 1440, 312, -240},
    { 1168, 520, -520},
    { 864, 464, -288},
    { 808, 440, -296},
    { 832, 560, -352},
    { 888, 632, -456},
    { 920, 600, -424},
    { 904, 640, -424},
    { 904, 656, -320},
    { 1328, 680, -216},
    { 1192, 752, -368},
    { 1456, 728, -256},
    { 1608, 576, -24},
    { 1728, 488, -48},
    { 1480, 424, -48},
    { 1192, 360, -24},
    { 1048, 304, -16},
    { 968, 232, -8},
    { 904, 184, -24},
    { 760, 136, 0},
    { 736, 72, 16},
    { 800, -32, 64},
    { 864, 16, 56},
    { 1152, 152, 64},
    { 1392, 296, -112},
    // 59 seconds
    { 1672, 336, -216},
    { 1704, 288, -88},
    { 1472, 320, -296},
    { 1184, 488, -448},
    { 952, 504, -304},
    { 888, 528, -336},
    { 864, 592, -328},
    { 856, 648, -392},
    { 928, 672, -328},
    { 984, 744, -288},
    { 984, 784, -192},
    { 1168, 768, -184},
    { 1048, 696, -224},
    { 1344, 688, -240},
    { 1728, 648, -56},
    { 1872, 536, -40},
    { 1472, 384, -56},
    { 1168, 296, -48},
    { 1080, 312, -64},
    { 1000, 264, -72},
    { 896, 184, -48},
    { 704, 8, 56},
    { 512, -256, -64},
    { 576, -176, -40},
    { 960, -80, -56},
    // 60 seconds
    // elapsed: 1 minutes
    { 1440, 112, 64},
    { 1712, 248, -8},
    { 1832, 392, -312},
    { 1704, 416, -176},
    { 1416, 416, -232},
    { 1016, 480, -384},
    { 808, 448, -320},
    { 704, 456, -312},
    { 672, 512, -376},
    { 712, 608, -544},
    { 760, 688, -472},
    { 920, 736, -512},
    { 992, 768, -344},
    { 1240, 736, -328},
    { 1272, 664, -280},
    { 1280, 584, -176},
    { 1616, 536, -200},
    { 1760, 488, -96},
    { 1448, 432, -200},
    { 1080, 384, -256},
    { 904, 304, -264},
    { 840, 216, -208},
    { 744, 96, -112},
    { 640, 48, -48},
    { 568, 56, -56},
    // 61 seconds
    { 656, 112, -48},
    { 896, 80, -8},
    { 1352, 184, 56},
    { 1440, 328, -176},
    { 1680, 368, -416},
    { 1624, 344, -192},
    { 1432, 240, -208},
    { 1136, 416, -456},
    { 792, 448, -336},
    { 680, 512, -336},
    { 728, 552, -352},
    { 816, 632, -432},
    { 768, 648, -392},
    { 840, 656, -408},
    { 864, 656, -280},
    { 1072, 608, -184},
    { 1368, 640, -176},
    { 1456, 696, -200},
    { 1688, 672, -72},
    { 1760, 624, -72},
    { 1440, 456, -144},
    { 1144, 360, -168},
    { 1024, 304, -176},
    { 904, 200, -160},
    { 792, 112, -168},
    // 62 seconds
    { 744, 64, -176},
    { 968, 48, -208},
    { 984, -8, -104},
    { 784, -48, -8},
    { 928, 88, -16},
    { 1088, 248, -48},
    { 1328, 336, -112},
    { 1688, 400, -232},
    { 1728, 464, -344},
    { 1392, 496, -288},
    { 1000, 536, -224},
    { 784, 616, -256},
    { 736, 520, -296},
    { 720, 560, -400},
    { 736, 608, -408},
    { 912, 616, -384},
    { 1000, 712, -360},
    { 1144, 720, -304},
    { 1416, 688, -296},
    { 1360, 664, -240},
    { 1568, 592, -176},
    { 1792, 544, -96},
    { 1512, 408, -104},
    { 1200, 288, -56},
    { 992, 240, -16},
    // 63 seconds
    { 856, 200, 8},
    { 792, 128, -48},
    { 696, 104, -72},
    { 592, 80, -40},
    { 720, 104, -48},
    { 824, 152, -80},
    { 1072, 168, -24},
    { 1360, 208, 48},
    { 1552, 352, -184},
    { 1520, 312, -280},
    { 1480, 304, -232},
    { 1120, 320, -312},
    { 824, 360, -352},
    { 672, 376, -288},
    { 592, 416, -336},
    { 680, 464, -424},
    { 848, 472, -432},
    { 1080, 488, -432},
    { 1080, 600, -432},
    { 1136, 616, -336},
    { 1328, 608, -384},
    { 1304, 600, -376},
    { 1600, 560, -208},
    { 1704, 520, -104},
    { 1528, 392, -184},
    // 64 seconds
    { 1144, 320, -208},
    { 992, 296, -152},
    { 880, 200, -160},
    { 768, 128, -192},
    { 632, 32, -208},
    { 528, -24, -144},
    { 536, 32, -144},
    { 720, 120, -208},
    { 1000, 232, -96},
    { 1400, 264, -48},
    { 1584, 344, -256},
    { 1536, 328, -184},
    { 1432, 240, -104},
    { 1184, 256, -336},
    { 904, 256, -496},
    { 752, 288, -416},
    { 784, 416, -408},
    { 792, 576, -360},
    { 912, 704, -344},
    { 832, 720, -280},
    { 904, 728, -256},
    { 880, 656, -128},
    { 1160, 608, -64},
    { 1240, 704, -144},
    { 1248, 776, -208},
    // 65 seconds
    { 1584, 752, -120},
    { 1608, 592, -88},
    { 1360, 408, -120},
    { 1200, 312, -160},
    { 1096, 264, -160},
    { 936, 64, -96},
    { 776, 224, -168},
    { 640, 192, -128},
    { 632, 128, -96},
    { 728, 144, -96},
    { 768, 112, -80},
    { 1056, 56, 32},
    { 1440, 344, 8},
    { 1544, 656, -288},
    { 1528, 424, -96},
    { 1384, 456, -8},
    { 1040, 576, -104},
    { 776, 560, -64},
    { 648, 536, 24},
    { 648, 552, 16},
    { 704, 616, -80},
    { 808, 688, -144},
    { 920, 752, -72},
    { 968, 784, -224},
    { 960, 712, -216},
    // 66 seconds
    { 1272, 728, -192},
    { 1096, 744, -304},
    { 1328, 800, -288},
    { 1592, 648, -120},
    { 1672, 496, -80},
    { 1352, 416, -96},
    { 1136, 384, -128},
    { 984, 312, -112},
    { 896, 256, -128},
    { 808, 184, -128},
    { 704, 112, -56},
    { 624, 56, -56},
    { 688, 112, -88},
    { 824, 152, -152},
    { 1112, 192, -64},
    { 1312, 256, -240},
    { 1624, 280, -448},
    { 1592, 264, -96},
    { 1280, 240, -200},
    { 992, 432, -416},
    { 784, 568, -328},
    { 688, 448, -200},
    { 768, 448, -224},
    { 896, 608, -240},
    { 960, 656, -256},
    // 67 seconds
    { 1024, 736, -304},
    { 952, 800, -312},
    { 1088, 648, -264},
    { 1136, 632, -304},
    { 1232, 648, -352},
    { 1520, 520, -216},
    { 1632, 440, -152},
    { 1504, 408, -216},
    { 1160, 328, -232},
    { 984, 288, -200},
    { 880, 208, -168},
    { 760, 152, -96},
    { 648, 120, -56},
    { 576, 80, 0},
    { 568, 128, -80},
    { 712, 152, -160},
    { 976, 168, -216},
    { 1272, 192, -144},
    { 1520, 272, -256},
    { 1696, 328, -256},
    { 1528, 288, -160},
    { 1208, 312, -248},
    { 840, 384, -264},
    { 688, 400, -200},
    { 656, 392, -152},
    // 68 seconds
    { 784, 464, -200},
    { 856, 520, -216},
    { 824, 552, -280},
    { 832, 600, -392},
    { 872, 576, -432},
    { 992, 440, -240},
    { 1216, 464, -136},
    { 1112, 680, -368},
    { 1424, 720, -312},
    { 1664, 592, -120},
    { 1536, 448, -280},
    { 1240, 408, -360},
    { 1144, 344, -320},
    { 992, 208, -264},
    { 776, 120, -240},
    { 608, 96, -224},
    { 528, 72, -208},
    { 504, 72, -152},
    { 584, 96, -160},
    { 760, 192, -168},
    { 1192, 240, -32},
    { 1464, 312, 40},
    { 1464, 352, -192},
    { 1536, 376, -224},
    { 1424, 304, -112},
    // 69 seconds
    { 1120, 240, -256},
    { 872, 416, -344},
    { 728, 448, -312},
    { 696, 464, -232},
    { 768, 528, -224},
    { 888, 624, -232},
    { 872, 632, -168},
    { 880, 656, -200},
    { 880, 672, -160},
    { 1216, 624, -144},
    { 1376, 672, -328},
    { 1200, 616, -344},
    { 1496, 496, -392},
    { 1688, 336, -352},
    { 1392, 248, -448},
    { 1072, 240, -360},
    { 824, 160, -304},
    { 664, 56, -152},
    { 496, -72, -104},
    { 472, 96, -176},
    { 632, 232, -136},
    { 896, 216, -128},
    { 1176, 184, -120},
    { 1248, 176, -56},
    { 1416, 240, -40},
    // 70 seconds
    { 1272, 320, -224},
    { 1368, 232, -280},
    { 1488, 72, -88},
    { 1136, 200, -152},
    { 808, 312, -296},
    { 624, 360, -272},
    { 608, 392, -256},
    { 664, 440, -280},
    { 784, 456, -288},
    { 904, 464, -288},
    { 928, 512, -328},
    { 968, 520, -328},
    { 1288, 488, -304},
    { 1480, 472, -400},
    { 1272, 448, -336},
    { 1512, 440, -328},
    { 1552, 392, -272},
    { 1336, 328, -272},
    { 1024, 272, -224},
    { 848, 200, -176},
    { 752, 176, -152},
    { 656, 160, -152},
    { 616, 136, -112},
    { 656, 120, -40},
    { 856, 256, -72},
    // 71 seconds
    { 1008, 360, -112},
    { 1080, 328, -144},
    { 1152, 176, -32},
    { 1288, 24, -64},
    { 1520, 152, -232},
    { 1568, 192, -224},
    { 1304, 240, -272},
    { 896, 296, -336},
    { 712, 360, -304},
    { 560, 360, -336},
    { 568, 376, -320},
    { 672, 424, -360},
    { 752, 472, -344},
    { 912, 560, -344},
    { 1016, 608, -304},
    { 1272, 592, -312},
    { 1336, 576, -480},
    { 1280, 544, -384},
    { 1464, 544, -312},
    { 1568, 464, -328},
    { 1336, 384, -312},
    { 952, 296, -312},
    { 712, 192, -424},
    { 600, 112, -336},
    { 512, 24, -288},
    // 72 seconds
    { 568, 64, -320},
    { 632, 176, -280},
    { 728, 192, -240},
    { 960, 280, -272},
    { 1200, 296, -224},
    { 1296, 248, -48},
    { 1416, 312, 24},
    { 1280, 440, -176},
    { 1488, 432, -112},
    { 1384, 232, 0},
    { 1112, 280, -112},
    { 688, 496, -272},
    { 520, 472, -248},
    { 664, 368, -160},
    { 696, 448, -176},
    { 736, 488, -280},
    { 840, 504, -280},
    { 1056, 608, -352},
    { 1120, 576, -304},
    { 1152, 520, -296},
    { 1232, 560, -336},
    { 1112, 584, -432},
    { 1296, 576, -456},
    { 1456, 464, -256},
    { 1624, 352, -384},
    // 73 seconds
    { 1408, 248, -296},
    { 1048, 144, -216},
    { 832, 136, -264},
    { 680, 144, -264},
    { 568, 152, -200},
    { 536, 160, -192},
    { 576, 176, -184},
    { 696, 176, -168},
    { 944, 208, -232},
    { 1320, 176, -80},
    { 1272, 64, 264},
    { 1296, 248, 128},
    { 1472, 480, -48},
    { 1408, 424, -40},
    { 1152, 328, -208},
    { 808, 280, -376},
    { 656, 264, -216},
    { 616, 296, -312},
    { 752, 408, -448},
    { 808, 400, -392},
    { 936, 472, -344},
    { 1008, 560, -432},
    { 1064, 600, -344},
    { 1000, 512, -248},
    { 944, 520, -224},
    // 74 seconds
    { 1176, 632, -416},
    { 1624, 664, -360},
    { 1616, 432, -144},
    { 1576, 384, -208},
    { 1256, 376, -288},
    { 1040, 360, -288},
    { 856, 240, -248},
    { 680, 128, -208},
    { 568, 56, -168},
    { 520, 48, -120},
    { 544, 96, -112},
    { 720, 144, -112},
    { 944, 200, -72},
    { 1408, 120, 160},
    { 1664, 272, 88},
    { 1608, 400, -224},
    { 1552, 384, -40},
    { 1328, 232, -48},
    { 1008, 336, -208},
    { 808, 440, -224},
    { 688, 424, -208},
    { 744, 480, -280},
    { 824, 560, -376},
    { 896, 552, -432},
    { 896, 640, -520},
    // 75 seconds
    { 968, 640, -456},
    { 968, 560, -344},
    { 1176, 600, -280},
    { 1232, 720, -392},
    { 1552, 736, -280},
    { 1768, 672, -88},
    { 1752, 496, -40},
    { 1456, 408, -64},
    { 1248, 376, -120},
    { 1064, 304, -120},
    { 912, 208, -144},
    { 768, 40, -144},
    { 584, -72, -88},
    { 504, -80, -64},
    { 600, -88, -64},
    { 720, -112, 16},
    { 952, 48, 104},
    { 1472, 328, 48},
    { 1920, 512, -368},
    { 2000, 520, -240},
    { 1688, 392, -144},
    { 1112, 472, -408},
    { 776, 456, -304},
    { 688, 416, -176},
    { 720, 424, -208},
    // 76 seconds
    { 736, 472, -256},
    { 800, 584, -304},
    { 848, 712, -256},
    { 904, 848, -296},
    { 960, 888, -264},
    { 1504, 768, -144},
    { 1360, 728, -152},
    { 1544, 672, -176},
    { 1576, 616, -136},
    { 1488, 512, -152},
    { 1192, 344, -64},
    { 944, 232, -24},
    { 864, 248, -40},
    { 848, 240, -16},
    { 776, 216, 24},
    { 736, 160, 48},
    { 768, 72, 64},
    { 816, -40, 120},
    { 1072, 0, 48},
    { 1272, 120, 64},
    { 1680, 320, -256},
    { 1824, 288, -200},
    { 1608, 208, -88},
    { 1208, 288, -368},
    { 808, 360, -352},
    // 77 seconds
    { 712, 328, -216},
    { 672, 416, -208},
    { 696, 520, -240},
    { 808, 592, -360},
    { 888, 616, -336},
    { 1024, 688, -392},
    { 984, 696, -320},
    { 1224, 648, -248},
    { 1344, 672, -288},
    { 1176, 640, -280},
    { 1456, 536, -152},
    { 1624, 560, -128},
    { 1472, 440, -152},
    { 1176, 352, -144},
    { 1016, 304, -136},
    { 936, 256, -160},
    { 856, 192, -128},
    { 776, 136, -136},
    { 624, 72, -208},
    { 600, 40, -200},
    { 624, 56, -176},
    { 1016, 232, -64},
    { 1592, 360, -152},
    { 1616, 312, -368},
    { 1664, 312, -160},
    // 78 seconds
    { 1240, 200, -160},
    { 808, 48, -208},
    { 784, 312, 48},
    { 760, 760, -208},
    { 768, 976, -160},
    { 720, 1056, -256},
    { 752, 712, -336},
    { 848, 680, -200},
    { 976, 736, -216},
    { 848, 800, -48},
    { 1240, 928, -216},
    { 1120, 1056, -264},
    { 1480, 952, -288},
    { 1704, 728, -176},
    { 1400, 456, -240},
    { 1056, 192, -248},
    { 784, 216, -296},
    { 656, 168, -200},
    { 592, 88, -96},
    { 624, 112, -152},
    { 648, 152, -96},
    { 728, 160, -64},
    { 848, 208, -72},
    { 1048, 168, -56},
    { 1280, 200, -40},
    // 79 seconds
    { 1424, 344, -160},
    { 1736, 328, -232},
    { 1648, 320, -120},
    { 1192, 304, -296},
    { 824, 376, -384},
    { 656, 376, -280},
    { 640, 376, -272},
    { 728, 480, -392},
    { 840, 504, -448},
    { 928, 496, -408},
    { 960, 592, -432},
    { 936, 600, -304},
    { 1336, 584, -248},
    { 1240, 592, -256},
    { 1464, 632, -240},
    { 1720, 592, -136},
    { 1560, 496, -72},
    { 1208, 384, -72},
    { 960, 328, -40},
    { 824, 280, -24},
    { 736, 224, -8},
    { 704, 192, -8},
    { 720, 192, 24},
    { 840, 168, 24},
    { 1008, 176, 0},
    // 80 seconds
    { 984, 88, 32},
    { 1280, 96, -16},
    { 1320, 240, -80},
    { 1360, 288, -296},
    { 1416, 240, -208},
    { 1200, 224, -192},
    { 904, 336, -328},
    { 808, 456, -312},
    { 736, 464, -304},
    { 744, 528, -384},
    { 832, 560, -528},
    { 960, 536, -504},
    { 1120, 560, -544},
    { 992, 552, -440},
    { 1176, 544, -344},
    { 1264, 576, -328},
    { 1360, 672, -376},
    { 1648, 568, -120},
    { 1680, 488, -8},
    { 1320, 352, -16},
    { 1016, 336, -24},
    { 896, 336, -32},
    { 816, 280, -16},
    { 776, 200, -40},
    { 704, 200, -24},
    // 81 seconds
    { 768, 152, -40},
    { 904, 24, -64},
    { 856, -152, 32},
    { 1240, 40, -48},
    { 1312, 224, -24},
    { 1464, 272, -80},
    { 1464, 280, -48},
    { 1400, 416, -128},
    { 1064, 456, -280},
    { 824, 472, -400},
    { 664, 376, -272},
    { 728, 392, -344},
    { 920, 440, -448},
    { 960, 448, -536},
    { 944, 496, -632},
    { 944, 488, -576},
    { 928, 352, -296},
    { 1208, 488, -200},
    { 1272, 688, -328},
    { 1464, 800, -344},
    { 1624, 752, -144},
    { 1592, 472, 0},
    { 1264, 296, 0},
    { 1056, 320, -16},
    { 936, 320, -8},
    // 82 seconds
    { 848, 280, 24},
    { 824, 216, 56},
    { 760, 192, 80},
    { 800, 184, 40},
    { 840, 160, 40},
    { 960, 136, -16},
    { 1152, 208, -168},
    { 1032, 232, -248},
    { 1232, 264, -400},
    { 1368, 168, -248},
    { 1240, 224, -216},
    { 1016, 352, -376},
    { 864, 440, -376},
    { 800, 464, -344},
    { 832, 440, -376},
    { 848, 456, -448},
    { 856, 424, -544},
    { 912, 400, -496},
    { 1144, 392, -392},
    { 1056, 432, -296},
    { 1160, 504, -224},
    { 1144, 600, -272},
    { 1128, 640, -264},
    { 1432, 656, -224},
    { 1512, 480, 24},
    // 83 seconds
    { 1280, 352, 40},
    { 1088, 368, -24},
    { 928, 384, -8},
    { 832, 328, 56},
    { 792, 232, 104},
    { 792, 232, 32},
    { 808, 248, 0},
    { 952, 272, -40},
    { 968, 184, -72},
    { 992, 112, -104},
    { 1024, 24, -144},
    { 1072, 144, -248},
    { 1136, 208, -416},
    { 1320, 176, -272},
    { 1136, 184, -288},
    { 864, 280, -400},
    { 760, 336, -352},
    { 696, 328, -352},
    { 736, 384, -368},
    { 896, 432, -480},
    { 976, 392, -536},
    { 880, 328, -488},
    { 936, 328, -448},
    { 952, 360, -328},
    { 1128, 456, -200},
    // 84 seconds
    { 1304, 656, -312},
    { 1208, 816, -320},
    { 1432, 848, -144},
    { 1536, 568, -16},
    { 1280, 440, 8},
    { 1080, 472, -8},
    { 1008, 536, -40},
    { 856, 368, 8},
    { 712, 248, -8},
    { 656, 200, 8},
    { 704, 144, 16},
    { 864, 104, -16},
    { 992, -48, 16},
    { 1336, -32, -40},
    { 1344, 136, -64},
    { 1408, 240, -304},
    { 1624, 288, -296},
    { 1472, 248, -144},
    { 1160, 344, -272},
    { 968, 560, -280},
    { 832, 744, -272},
    { 744, 728, -272},
    { 784, 640, -264},
    { 800, 624, -320},
    { 824, 608, -360},
    // 85 seconds
    { 824, 640, -352},
    { 928, 560, -280},
    { 1288, 536, -168},
    { 1264, 632, -192},
    { 1248, 632, -144},
    { 1448, 712, -64},
    { 1872, 576, 96},
    { 1448, 232, 72},
    { 1040, 72, 56},
    { 928, 216, -88},
    { 904, 304, -120},
    { 824, 216, -104},
    { 736, 80, -24},
    { 664, -40, 0},
    { 736, 0, -16},
    { 864, 16, -96},
    { 1264, 72, 0},
    { 1464, 288, -104},
    { 1544, 296, -240},
    { 1680, 296, -32},
    { 1488, 248, -72},
    { 1112, 392, -208},
    { 888, 496, -224},
    { 784, 496, -248},
    { 768, 480, -264},
    // 86 seconds
    { 776, 504, -288},
    { 816, 544, -312},
    { 872, 640, -352},
    { 960, 696, -336},
    { 1072, 608, -232},
    { 1368, 632, -248},
    { 1168, 680, -344},
    { 1528, 664, -248},
    { 1744, 512, -32},
    { 1648, 416, -40},
    { 1296, 344, -56},
    { 1072, 320, -56},
    { 936, 272, -16},
    { 880, 200, -16},
    { 816, 176, -16},
    { 736, 128, 40},
    { 784, 104, 32},
    { 800, 80, 40},
    { 952, 104, 0},
    { 1128, 152, 24},
    { 1296, 280, -120},
    { 1560, 328, -200},
    { 1544, 240, -112},
    { 1296, 296, -344},
    { 1008, 432, -520},
    // 87 seconds
    { 776, 184, -424},
    { 824, 400, -528},
    { 784, 424, -528},
    { 816, 392, -496},
    { 848, 368, -464},
    { 1000, 480, -456},
    { 1008, 480, -368},
    { 1136, 520, -272},
    { 1160, 488, -320},
    { 1208, 560, -416},
    { 1584, 496, -288},
    { 1752, 392, -96},
    { 1576, 328, -144},
    { 1168, 328, -224},
    { 928, 328, -224},
    { 784, 232, -176},
    { 688, 136, -144},
    { 632, 72, -144},
    { 592, 72, -80},
    { 672, 104, -112},
    { 872, 136, -120},
    { 1096, 192, -24},
    { 1320, 264, -16},
    { 1504, 312, -344},
    { 1568, 328, -136},
    // 88 seconds
    { 1416, 200, -32},
    { 1176, 312, -296},
    { 896, 480, -424},
    { 696, 400, -248},
    { 680, 376, -256},
    { 768, 448, -320},
    { 888, 504, -368},
    { 904, 552, -424},
    { 1040, 600, -392},
    { 1056, 608, -320},
    { 1344, 600, -288},
    { 1104, 624, -400},
    { 1336, 600, -312},
    { 1600, 464, -144},
    { 1624, 392, -136},
    { 1272, 352, -160},
    { 1024, 328, -152},
    { 912, 264, -136},
    { 816, 192, -136},
    { 736, 144, -160},
    { 696, 112, -120},
    { 736, 88, -64},
    { 848, 88, -72},
    { 888, 104, -8},
    { 1096, 152, 56},
    // 89 seconds
    { 1376, 328, -80},
    { 1648, 352, -160},
    { 1640, 328, -16},
    { 1368, 320, -248},
    { 968, 408, -392},
    { 712, 376, -280},
    { 640, 376, -256},
    { 760, 448, -264},
    { 880, 544, -304},
    { 896, 616, -264},
    { 944, 744, -352},
    { 896, 744, -272},
    { 1176, 640, -232},
    { 1280, 624, -280},
    { 1344, 704, -296},
    { 1520, 552, -152},
    { 1552, 472, -144},
    { 1256, 408, -224},
    { 976, 360, -232},
    { 856, 296, -216},
    { 776, 192, -152},
    { 776, 160, -160},
    { 776, 136, -160},
    { 928, 160, -200},
    { 1072, 64, -168},
    // 90 seconds
    { 976, -80, -32},
    { 1056, -32, 112},
    { 1200, 256, -8},
    { 1480, 424, -200},
    { 1456, 336, -40},
    { 1336, 304, -56},
    { 1144, 464, -352},
    { 816, 544, -240},
    { 736, 552, -296},
    { 800, 576, -312},
    { 888, 608, -392},
    { 904, 568, -392},
    { 960, 632, -400},
    { 920, 616, -312},
    { 1192, 592, -208},
    { 1352, 696, -336},
    { 1336, 688, -280},
    { 1448, 592, -176},
    { 1624, 464, -104},
    { 1368, 376, -136},
    { 1064, 336, -144},
    { 944, 312, -144},
    { 880, 248, -104},
    { 832, 184, -88},
    { 784, 144, -56},
    // 91 seconds
    { 768, 120, -32},
    { 848, 16, 32},
    { 888, 24, -24},
    { 1144, 160, -72},
    { 1288, 240, -64},
    { 1472, 304, -312},
    { 1584, 320, -224},
    { 1424, 336, -328},
    { 1024, 360, -376},
    { 800, 376, -232},
    { 720, 448, -248},
    { 728, 536, -256},
    { 800, 552, -312},
    { 872, 568, -248},
    { 984, 688, -256},
    { 968, 776, -248},
    { 1232, 744, -176},
    { 1224, 728, -304},
    { 1192, 736, -272},
    { 1528, 648, -184},
    { 1616, 456, -112},
    { 1304, 368, -136},
    { 1112, 368, -200},
    { 1040, 320, -160},
    { 944, 232, -120},
    // 92 seconds
    { 776, 136, -136},
    { 600, 80, -88},
    { 640, 72, -40},
    { 696, 72, -48},
    { 784, 80, -72},
    { 1112, 88, -56},
    { 1464, 208, -8},
    { 1616, 344, -128},
    { 1784, 336, -208},
    { 1568, 424, -296},
    { 1112, 408, -344},
    { 816, 392, -224},
    { 688, 472, -240},
    { 704, 568, -272},
    { 768, 600, -296},
    { 824, 576, -248},
    { 984, 640, -264},
    { 1016, 704, -240},
    { 1112, 640, -168},
    { 1088, 592, -224},
    { 1152, 640, -272},
    { 1528, 624, -256},
    { 1600, 440, -88},
    { 1520, 368, -216},
    { 1152, 344, -312},
    // 93 seconds
    { 920, 288, -248},
    { 832, 208, -248},
    { 744, 136, -200},
    { 672, 88, -176},
    { 600, 72, -104},
    { 656, 120, -104},
    { 832, 120, -112},
    { 1064, 112, 0},
    { 1384, 248, -24},
    { 1552, 320, -120},
    { 1672, 288, -88},
    { 1504, 272, -40},
    { 1208, 352, -312},
    { 792, 352, -304},
    { 680, 376, -208},
    { 648, 424, -264},
    { 728, 512, -272},
    { 840, 624, -336},
    { 960, 640, -248},
    { 1032, 776, -304},
    { 920, 760, -240},
    { 1240, 672, -216},
    { 1184, 664, -272},
    { 1344, 672, -264},
    { 1632, 552, -128},
    // 94 seconds
    { 1576, 456, -152},
    { 1280, 368, -256},
    { 1056, 312, -240},
    { 984, 280, -216},
    { 952, 200, -192},
    { 840, 144, -168},
    { 728, 80, -104},
    { 664, 32, -88},
    { 768, -16, -32},
    { 872, -24, 8},
    { 1192, 168, -8},
    { 1512, 336, -24},
    { 1592, 400, -296},
    { 1856, 400, -456},
    { 1456, 304, -352},
    { 960, 144, -272},
    { 792, 296, -280},
    { 664, 480, -296},
    { 632, 512, -280},
    { 720, 576, -368},
    { 744, 688, -344},
    { 864, 928, -440},
    { 840, 1016, -384},
    { 848, 768, -248},
    { 1104, 800, -240},
    // 95 seconds
    { 1248, 848, -280},
    { 1680, 880, -256},
    { 1840, 632, -96},
    { 1536, 416, -176},
    { 1288, 368, -280},
    { 1232, 328, -256},
    { 1256, 184, -104},
    { 1080, -40, -80},
    { 736, -112, -112},
    { 424, -80, -80},
    { 416, -24, -112},
    { 512, 0, -96},
    { 808, 96, -72},
    { 1360, 248, -16},
    { 1816, 352, -256},
    { 2232, 384, -120},
    { 1968, 528, -80},
    { 1312, 648, -472},
    { 856, 640, -288},
    { 704, 568, -248},
    { 704, 512, -288},
    { 728, 568, -352},
    { 704, 520, -304},
    { 912, 624, -320},
    { 928, 664, -288},
    // 96 seconds
    { 1040, 624, -200},
    { 1328, 608, -120},
    { 1288, 688, -240},
    { 1552, 624, -144},
    { 1664, 560, -40},
    { 1504, 408, -72},
    { 1168, 288, -96},
    { 992, 296, -96},
    { 920, 264, -72},
    { 824, 184, -56},
    { 768, 144, -72},
    { 792, 168, -96},
    { 808, 176, -96},
    { 800, 8, -16},
    { 1072, 48, 72},
    { 1208, 152, -72},
    { 1552, 352, -248},
    { 1504, 232, 8},
    { 1360, 160, -80},
    { 1048, 384, -360},
    { 808, 488, -440},
    { 728, 320, -192},
    { 832, 312, -248},
    { 936, 456, -344},
    { 928, 528, -400},
    // 97 seconds
    { 1024, 616, -472},
    { 1032, 640, -424},
    { 1136, 568, -320},
    { 1288, 608, -336},
    { 1224, 664, -368},
    { 1512, 592, -240},
    { 1712, 488, -72},
    { 1648, 384, -64},
    { 1256, 320, -104},
    { 1000, 320, -80},
    { 856, 264, -88},
    { 736, 184, -64},
    { 688, 104, -24},
    { 616, 104, -24},
    { 688, 168, -88},
    { 792, 112, -56},
    { 1040, 136, -40},
    { 1336, 256, -64},
    { 1328, 296, -264},
    { 1488, 224, -256},
    { 1416, 184, 24},
    { 1240, 352, -224},
    { 888, 576, -360},
    { 776, 544, -256},
    { 776, 416, -176},
    // 98 seconds
    { 856, 504, -232},
    { 936, 536, -312},
    { 960, 592, -400},
    { 1008, 680, -560},
    { 1040, 600, -448},
    { 1144, 464, -296},
    { 1216, 568, -208},
    { 1080, 688, -224},
    { 1384, 824, -240},
    { 1672, 784, 24},
    { 1648, 400, 128},
    { 1288, 208, 64},
    { 1056, 264, 32},
    { 920, 328, 32},
    { 856, 264, 48},
    { 832, 224, 32},
    { 744, 176, 80},
    { 816, 184, -32},
    { 848, 32, -16},
    { 1112, -80, 128},
    { 1152, 80, 40},
    { 1312, 320, -232},
    { 1480, 336, -208},
    { 1368, 240, -120},
    { 1112, 232, -224},
    // 99 seconds
    { 992, 384, -344},
    { 816, 448, -320},
    { 816, 432, -312},
    { 840, 480, -360},
    { 1008, 384, -536},
    { 968, 312, -344},
    { 1024, 512, -576},
    { 984, 496, -496},
    { 1312, 480, -456},
    { 1288, 560, -416},
    { 1344, 584, -288},
    { 1544, 536, -248},
    { 1648, 448, -88},
    { 1248, 328, 8},
    { 984, 304, 0},
    { 864, 312, 16},
    { 832, 296, 56},
    { 872, 256, 40},
    { 832, 216, 40},
    { 824, 184, -24},
    { 864, 128, -96},
    { 824, 64, -8},
    { 984, 144, -144},
    { 1072, 280, -272},
    { 1184, 280, -344},
    // 100 seconds
    { 1272, 208, -208},
    { 1184, 224, -336},
    { 936, 288, -344},
    { 824, 392, -240},
    { 784, 560, -320},
    { 824, 608, -392},
    { 928, 544, -424},
    { 1000, 504, -448},
    { 952, 512, -480},
    { 912, 504, -384},
    { 968, 488, -256},
    { 1384, 568, -208},
    { 1280, 744, -184},
    { 1416, 816, -192},
    { 1592, 648, -104},
    { 1408, 408, -48},
    { 1112, 312, -96},
    { 984, 296, -72},
    { 896, 272, -64},
    { 848, 240, -40},
    { 864, 216, -8},
    { 808, 160, 48},
    { 888, 136, 32},
    { 832, 24, 72},
    { 1040, 104, 24},
    // 101 seconds
    { 1120, 248, -72},
    { 1120, 296, -240},
    { 1392, 296, -232},
    { 1384, 280, -288},
    { 1120, 272, -360},
    { 944, 360, -336},
    { 840, 456, -328},
    { 784, 552, -384},
    { 808, 512, -416},
    { 896, 456, -448},
    { 912, 448, -440},
    { 904, 424, -392},
    { 912, 416, -272},
    { 1200, 504, -200},
    { 1392, 736, -328},
    { 1520, 928, -368},
    { 1752, 816, 24},
    { 1712, 440, -8},
    { 1240, 336, -80},
    { 1040, 336, -32},
    { 912, 328, -24},
    { 840, 240, 0},
    { 720, 152, 32},
    { 584, 128, 64},
    { 664, 168, 24},
    // 102 seconds
    { 816, 184, -40},
    { 872, 208, -128},
    { 1168, 192, -144},
    { 968, 176, 56},
    { 1136, 360, -360},
    { 1456, 584, -496},
    { 1536, 416, -408},
    { 1136, 136, -392},
    { 920, 376, -648},
    { 744, 400, -688},
    { 832, 248, -640},
    { 832, 184, -576},
    { 888, 208, -592},
    { 936, 200, -456},
    { 856, 248, -400},
    { 960, 368, -304},
    { 1312, 448, -248},
    { 1528, 608, -288},
    { 1584, 568, 64},
    { 1712, 408, 16},
    { 1280, 320, -144},
    { 640, 344, -472},
    { 544, 376, -528},
    { 712, 80, -248},
    { 600, -152, -136},
    // 103 seconds
    { 480, -40, -152},
    { 520, 40, -120},
    { 752, 128, -96},
    { 800, 184, 8},
    { 976, 224, 16},
    { 1456, 336, 56},
    { 1552, 528, -312},
    { 1776, 528, -552},
    { 1640, 512, -176},
    { 1072, 112, -280},
    { 880, 272, -304},
    { 624, 416, -272},
    { 584, 360, -288},
    { 672, 416, -240},
    { 760, 512, -288},
    { 808, 632, -232},
    { 992, 776, -304},
    { 1016, 744, -232},
    { 1432, 688, -224},
    { 1272, 792, -448},
    { 1432, 688, -368},
    { 1696, 416, -104},
    { 1632, 360, -136},
    { 1184, 336, -128},
    { 936, 320, -56},
    // 104 seconds
    { 864, 280, -24},
    { 832, 240, -16},
    { 792, 200, 0},
    { 728, 176, 24},
    { 816, 160, 8},
    { 880, 40, 48},
    { 1072, 8, -56},
    { 1256, 128, -8},
    { 1352, 264, -136},
    { 1544, 304, -240},
    { 1504, 256, -96},
    { 1304, 296, -304},
    { 1024, 384, -344},
    { 840, 416, -240},
    { 744, 496, -264},
    { 776, 560, -320},
    { 888, 592, -376},
    { 936, 632, -336},
    { 1016, 720, -344},
    { 960, 744, -264},
    { 1360, 720, -192},
    { 1168, 680, -280},
    { 1336, 680, -280},
    { 1608, 544, -112},
    { 1776, 392, -40},
    // 105 seconds
    { 1376, 368, -120},
    { 1048, 328, -72},
    { 832, 80, 0},
    { 736, 320, -128},
    { 752, 320, -112},
    { 728, 208, -24},
    { 808, 200, 0},
    { 928, 176, -8},
    { 928, 136, -32},
    { 984, 136, 48},
    { 1200, 160, -64},
    { 1592, 472, -176},
    { 1616, 432, 0},
    { 1504, 560, -184},
    { 1120, 752, -320},
    { 752, 576, -184},
    { 592, 512, -152},
    { 584, 536, -168},
    { 704, 568, -168},
    { 880, 632, -192},
    { 768, 680, -184},
    { 904, 712, -184},
    { 896, 664, -64},
    { 1216, 680, -40},
    { 1336, 800, -192},
    // 106 seconds
    { 1576, 720, -112},
    { 1648, 584, -56},
    { 1568, 480, -232},
    { 1216, 472, -336},
    { 1048, 312, -192},
    { 840, 168, -112},
    { 704, 64, -136},
    { 632, 112, -144},
    { 696, 176, -168},
    { 824, 192, -128},
    { 1000, 200, -176},
    { 1048, 120, -152},
    { 1024, 40, 64},
    { 1232, 184, 80},
    { 1352, 320, 104},
    { 1296, 352, 96},
    { 1200, 344, -32},
    { 1048, 400, -272},
    { 792, 416, -320},
    { 672, 368, -312},
    { 752, 392, -424},
    { 824, 488, -464},
    { 928, 544, -464},
    { 1160, 616, -528},
    { 1216, 616, -488},
    // 107 seconds
    { 1008, 536, -408},
    { 1112, 520, -336},
    { 1072, 512, -264},
    { 1224, 664, -392},
    { 1424, 664, -200},
    { 1728, 584, -48},
    { 1512, 304, -64},
    { 1176, 264, -64},
    { 1056, 288, -56},
    { 944, 248, -24},
    { 760, 160, -16},
    { 616, 8, -8},
    { 480, -392, 0},
    { 608, 24, 8},
    { 840, 288, 144},
    { 1408, 224, 112},
    { 1648, 352, -352},
    { 1584, 536, -592},
    { 1544, 304, -128},
    { 1376, 120, -120},
    { 1080, 280, -408},
    { 688, 376, -352},
    { 576, 320, -264},
    { 624, 344, -264},
    { 752, 384, -264},
    // 108 seconds
    { 872, 440, -296},
    { 848, 472, -376},
    { 920, 488, -392},
    { 936, 536, -336},
    { 1280, 584, -224},
    { 1384, 776, -352},
    { 1416, 744, -152},
    { 1536, 608, -48},
    { 1648, 488, -112},
    { 1384, 384, -40},
    { 1112, 320, -80},
    { 880, 264, -104},
    { 776, 216, -72},
    { 744, 168, -24},
    { 712, 144, -8},
    { 696, 152, -24},
    { 800, 80, 0},
    { 928, 8, 24},
    { 1112, 88, 40},
    { 1272, 280, -88},
    { 1744, 400, -376},
    { 1616, 320, -80},
    { 1336, 272, -152},
    { 1008, 512, -392},
    { 760, 472, -312},
    // 109 seconds
    { 656, 408, -176},
    { 744, 408, -200},
    { 832, 480, -200},
    { 904, 512, -264},
    { 960, 624, -312},
    { 960, 744, -344},
    { 1144, 744, -224},
    { 1352, 736, -304},
    { 1256, 712, -312},
    { 1424, 608, -248},
    { 1584, 552, -144},
    { 1504, 456, -128},
    { 1160, 352, -64},
    { 984, 296, -64},
    { 880, 248, -48},
    { 856, 208, -48},
    { 832, 168, -40},
    { 872, 104, -224},
    { 928, 64, -128},
    { 856, 0, 96},
    { 992, 80, -168},
    { 1176, 256, -264},
    { 1184, 352, -448},
    { 1480, 312, -216},
    { 1424, 192, 8},
    // 110 seconds
    { 1176, 304, -384},
    { 840, 480, -360},
    { 744, 352, -224},
    { 760, 384, -232},
    { 824, 464, -320},
    { 856, 552, -312},
    { 864, 632, -296},
    { 952, 800, -320},
    { 936, 720, -296},
    { 1304, 704, -256},
    { 1296, 768, -376},
    { 1392, 696, -288},
    { 1736, 592, -120},
    { 1728, 488, -88},
    { 1328, 376, -72},
    { 1088, 312, -48},
    { 888, 144, -48},
    { 712, 88, -32},
    { 728, 112, -72},
    { 768, 96, -64},
    { 800, 152, -24},
    { 872, 152, -88},
    { 832, 168, -56},
    { 1088, 80, -128},
    { 1360, 176, -168},
    // 111 seconds
    { 1400, 240, -296},
    { 1648, 248, -288},
    { 1376, 184, -272},
    { 1016, 256, -376},
    { 760, 344, -376},
    { 584, 400, -200},
    { 648, 464, -248},
    { 800, 520, -304},
    { 936, 536, -312},
    { 920, 608, -368},
    { 1040, 600, -344},
    { 960, 496, -224},
    { 1224, 560, -224},
    { 1208, 712, -304},
    { 1408, 768, -336},
    { 1736, 656, -112},
    { 1568, 392, -64},
    { 1232, 312, -152},
    { 1016, 360, -168},
    { 952, 336, -88},
    { 912, 224, -80},
    { 816, 168, -72},
    { 728, 120, -32},
    { 648, 104, -8},
    { 680, 136, -48},
    // 112 seconds
    { 760, 160, -80},
    { 1024, 192, -120},
    { 1384, 240, -80},
    { 1504, 272, -240},
    { 1528, 264, -152},
    { 1456, 280, -200},
    { 1168, 368, -328},
    { 896, 456, -368},
    { 744, 408, -240},
    { 752, 448, -320},
    { 848, 472, -360},
    { 864, 512, -408},
    { 888, 544, -384},
    { 976, 616, -336},
    { 936, 680, -240},
    { 1168, 672, -208},
    { 1248, 752, -240},
    { 1344, 840, -248},
    { 1552, 784, -104},
    { 1616, 544, -24},
    { 1392, 368, -112},
    { 1176, 336, -80},
    { 1048, 328, -104},
    { 904, 232, -72},
    { 752, 168, -144},
    // 113 seconds
    { 680, 104, -128},
    { 672, 64, -120},
    { 872, 24, -136},
    { 936, -64, -48},
    { 1080, 56, 0},
    { 1384, 216, -24},
    { 1448, 352, -200},
    { 1544, 296, -144},
    { 1640, 336, -104},
    { 1384, 408, -144},
    { 1112, 552, -248},
    { 872, 624, -120},
    { 824, 752, -264},
    { 840, 768, -312},
    { 816, 680, -344},
    { 768, 600, -296},
    { 768, 664, -392},
    { 968, 664, -344},
    { 1304, 584, -184},
    { 1424, 632, -264},
    { 1440, 656, -248},
    { 1688, 560, -104},
    { 1632, 472, -8},
    { 1344, 400, -72},
    { 1072, 344, -16},
    // 114 seconds
    { 888, 288, 16},
    { 832, 232, -48},
    { 816, 200, -104},
    { 752, 136, 8},
    { 824, 112, -8},
    { 904, 152, -48},
    { 896, 80, 0},
    { 1144, -176, -16},
    { 1440, -72, 64},
    { 1632, 304, -240},
    { 1776, 368, -384},
    { 1520, 232, -288},
    { 1008, 328, -448},
    { 840, 536, -560},
    { 752, 672, -432},
    { 680, 696, -304},
    { 664, 632, -200},
    { 784, 632, -136},
    { 832, 608, -80},
    { 912, 560, -64},
    { 888, 512, -72},
    { 1176, 576, -112},
    { 1288, 696, -272},
    { 1528, 720, -288},
    { 1648, 544, -144},
    // 115 seconds
    { 1592, 560, -328},
    { 1424, 408, -192},
    { 1192, 200, -112},
    { 968, 144, -128},
    { 776, 96, -136},
    { 648, 64, -80},
    { 576, 40, -8},
    { 560, 80, 0},
    { 648, 152, 56},
    { 896, 296, -40},
    { 1264, 256, 24},
    { 1464, 320, -120},
    { 1464, 336, -256},
    { 1464, 312, -152},
    { 1312, 296, -152},
    { 976, 320, -456},
    { 736, 256, -360},
    { 696, 320, -264},
    { 712, 352, -320},
    { 776, 440, -360},
    { 840, 504, -408},
    { 952, 528, -456},
    { 1080, 536, -424},
    { 1016, 392, -312},
    { 1280, 432, -288},
    // 116 seconds
    { 1248, 488, -376},
    { 1104, 544, -408},
    { 1472, 472, -304},
    { 1600, 368, -160},
    { 1360, 280, -192},
    { 1024, 280, -176},
    { 896, 312, -160},
    { 808, 256, -128},
    { 720, 184, -104},
    { 680, 128, -64},
    { 632, 104, -24},
    { 752, 176, -56},
    { 856, 176, -112},
    { 1128, 224, -104},
    { 1160, 240, -112},
    { 1184, 304, -312},
    { 1432, 256, -264},
    { 1416, 168, -112},
    { 1120, 264, -280},
    { 800, 416, -368},
    { 680, 376, -272},
    { 688, 336, -232},
    { 784, 392, -256},
    { 856, 448, -288},
    { 896, 480, -328},
    // 117 seconds
    { 1040, 528, -360},
    { 1096, 552, -336},
    { 1008, 528, -264},
    { 1080, 552, -272},
    { 1136, 704, -432},
    { 1296, 760, -344},
    { 1648, 640, -128},
    { 1696, 376, -120},
    { 1288, 312, -184},
    { 1064, 376, -216},
    { 968, 336, -152},
    { 816, 192, -128},
    { 672, 160, -144},
    { 584, 128, -104},
    { 552, 112, -32},
    { 680, 136, -48},
    { 816, 96, 24},
    { 1040, 136, 8},
    { 1304, 256, -8},
    { 1400, 352, -184},
    { 1608, 336, -248},
    { 1544, 240, -208},
    { 1264, 264, -328},
    { 960, 432, -408},
    { 752, 448, -312},
    // 118 seconds
    { 720, 432, -272},
    { 792, 488, -304},
    { 888, 536, -336},
    { 856, 576, -296},
    { 928, 656, -384},
    { 912, 664, -296},
    { 1144, 656, -232},
    { 1248, 664, -232},
    { 1304, 744, -288},
    { 1632, 656, -104},
    { 1752, 544, -48},
    { 1544, 392, -80},
    { 1232, 312, -56},
    { 1032, 320, -56},
    { 912, 256, -48},
    { 824, 200, -48},
    { 744, 136, -8},
    { 680, 104, -32},
    { 688, 120, -40},
    { 712, 80, -48},
    { 952, 88, -88},
    { 1184, 144, -48},
    { 1408, 272, -216},
    { 1592, 248, -200},
    { 1632, 240, -136},
    // 119 seconds
    { 1480, 328, -344},
    { 1128, 464, -416},
    { 856, 480, -320},
    { 744, 528, -320},
    { 808, 544, -312},
    { 816, 560, -336},
    { 792, 520, -272},
    { 848, 624, -272},
    { 864, 720, -256},
    { 1144, 672, -144},
    { 1344, 648, -200},
    { 1232, 640, -208},
    { 1464, 584, -216},
    { 1600, 496, -128},
    { 1416, 400, -224},
    { 1056, 320, -200},
    { 856, 280, -200},
    { 880, 240, -160},
    { 888, 192, -128},
    { 824, 168, -112},
    { 784, 152, -64},
    { 832, 128, -56},
    { 824, -48, 112},
    { 1096, -8, 128},
    { 1192, 256, -32},
    // 120 seconds
    // elapsed: 2 minutes
    { 1432, 408, -280},
    { 1600, 304, -112},
    { 1440, 248, -120},
    { 1176, 376, -328},
    { 896, 472, -336},
    { 760, 392, -272},
    { 744, 408, -248},
    { 776, 464, -280},
    { 824, 512, -440},
    { 840, 544, -440},
    { 968, 576, -464},
    { 976, 560, -352},
    { 1200, 568, -248},
    { 1360, 608, -288},
    { 1456, 608, -216},
    { 1528, 584, -152},
    { 1632, 496, -72},
    { 1384, 392, -72},
    { 1016, 344, -96},
    { 840, 312, -64},
    { 792, 256, -16},
    { 760, 216, 8},
    { 776, 200, -8},
    { 816, 208, -8},
    { 936, -40, 56},
    // 121 seconds
    { 920, -72, 8},
    { 1152, 112, -64},
    { 1312, 176, 0},
    { 1392, 272, -192},
    { 1544, 272, -168},
    { 1496, 280, -144},
    { 1144, 320, -216},
    { 864, 448, -288},
    { 744, 480, -312},
    { 744, 432, -240},
    { 808, 456, -352},
    { 944, 416, -424},
    { 1008, 472, -616},
    { 1096, 456, -656},
    { 1000, 384, -400},
    { 1112, 456, -320},
    { 992, 664, -288},
    { 960, 776, -320},
    { 1408, 840, -168},
    { 1552, 696, 48},
    { 1464, 496, -56},
    { 1240, 456, -80},
    { 1096, 416, -80},
    { 1080, 352, -72},
    { 1000, 256, -88},
    // 122 seconds
    { 904, 176, -88},
    { 824, 24, -48},
    { 808, -24, -104},
    { 752, -64, -128},
    { 872, -136, -144},
    { 1144, 0, -72},
    { 1376, 216, -128},
    { 1592, 320, -328},
    { 1632, 272, -256},
    { 1440, 232, -136},
    { 1088, 312, -248},
    { 864, 440, -256},
    { 768, 512, -248},
    { 840, 528, -304},
    { 896, 568, -336},
    { 920, 592, -360},
    { 968, 648, -440},
    { 920, 720, -416},
    { 912, 672, -336},
    { 1224, 608, -224},
    { 1032, 648, -328},
    { 1344, 616, -256},
    { 1608, 488, -128},
    { 1736, 424, -120},
    { 1432, 352, -152},
    // 123 seconds
    { 1144, 336, -152},
    { 968, 296, -168},
    { 856, 216, -144},
    { 728, 168, -136},
    { 664, 144, -136},
    { 624, 112, -72},
    { 728, 136, -104},
    { 832, 200, -152},
    { 1088, 224, -176},
    { 1288, 200, -136},
    { 1360, 248, -248},
    { 1440, 272, -328},
    { 1384, 240, -112},
    { 1240, 296, -200},
    { 1008, 416, -352},
    { 832, 424, -272},
    { 752, 392, -240},
    { 816, 448, -328},
    { 848, 472, -328},
    { 920, 528, -376},
    { 960, 584, -344},
    { 960, 664, -368},
    { 880, 552, -272},
    { 1104, 528, -232},
    { 1240, 648, -288},
    // 124 seconds
    { 1248, 680, -328},
    { 1504, 632, -160},
    { 1584, 480, -88},
    { 1384, 336, -120},
    { 1152, 312, -88},
    { 1016, 304, -80},
    { 872, 232, -80},
    { 768, 184, -72},
    { 672, 160, -80},
    { 640, 136, -40},
    { 736, 160, -64},
    { 872, 184, -88},
    { 960, 152, -80},
    { 1232, 168, -96},
    { 1344, 272, -104},
    { 1432, 312, -248},
    { 1488, 264, -264},
    { 1256, 208, -248},
    { 944, 280, -352},
    { 744, 376, -408},
    { 648, 376, -328},
    { 680, 408, -296},
    { 824, 464, -312},
    { 968, 520, -312},
    { 872, 496, -328},
    // 125 seconds
    { 912, 520, -328},
    { 1016, 480, -248},
    { 1344, 520, -192},
    { 1152, 624, -360},
    { 1224, 616, -320},
    { 1400, 536, -168},
    { 1584, 448, -128},
    { 1328, 328, -136},
    { 1032, 272, -152},
    { 888, 288, -208},
    { 824, 216, -192},
    { 760, 152, -160},
    { 680, 104, -112},
    { 608, 96, -64},
    { 664, 168, -120},
    { 880, 208, -168},
    { 1184, 216, -88},
    { 1448, 272, -136},
    { 1312, 312, -328},
    { 1416, 264, -160},
    { 1392, 192, -40},
    { 1160, 304, -240},
    { 808, 416, -280},
    { 640, 392, -216},
    { 616, 352, -208},
    // 126 seconds
    { 728, 384, -208},
    { 856, 440, -256},
    { 904, 504, -248},
    { 880, 640, -384},
    { 888, 712, -392},
    { 1072, 608, -232},
    { 1320, 624, -280},
    { 1152, 664, -376},
    { 1408, 600, -232},
    { 1632, 528, -104},
    { 1624, 424, -96},
    { 1296, 352, -80},
    { 1136, 352, -56},
    { 1016, 296, -56},
    { 888, 184, -112},
    { 712, 104, -120},
    { 576, 8, -48},
    { 512, -8, -40},
    { 568, 88, -64},
    { 728, 200, -112},
    { 1064, 264, -88},
    { 1512, 280, -176},
    { 1664, 384, -376},
    { 1608, 352, -360},
    { 1520, 184, -64},
    // 127 seconds
    { 1280, 232, -216},
    { 912, 392, -216},
    { 744, 456, -184},
    { 640, 448, -176},
    { 680, 408, -136},
    { 792, 392, -168},
    { 792, 400, -176},
    { 704, 432, -256},
    { 776, 560, -344},
    { 944, 568, -272},
    { 1304, 592, -264},
    { 1416, 808, -536},
    { 1256, 640, -240},
    { 1376, 512, -200},
    { 1552, 392, -152},
    { 1352, 344, -104},
    { 1088, 344, -136},
    { 960, 304, -144},
    { 864, 240, -136},
    { 776, 184, -120},
    { 704, 128, -128},
    { 656, 104, -128},
    { 704, 168, -152},
    { 768, 184, -168},
    { 896, 176, -144},
    // 128 seconds
    { 1272, 208, -88},
    { 1536, 336, -200},
    { 1368, 304, -336},
    { 1368, 200, -152},
    { 1312, 184, -40},
    { 1064, 368, -144},
    { 832, 504, -192},
    { 760, 528, -184},
    { 760, 488, -160},
    { 848, 504, -200},
    { 872, 560, -272},
    { 832, 544, -280},
    { 864, 544, -344},
    { 880, 568, -288},
    { 944, 544, -224},
    { 1184, 584, -200},
    { 1160, 696, -376},
    { 1288, 616, -232},
    { 1432, 464, -80},
    { 1528, 456, -136},
    { 1376, 424, -120},
    { 1216, 344, -72},
    { 1152, 256, -56},
    { 1016, 216, -48},
    { 888, 200, -120},
    // 129 seconds
    { 768, 184, -168},
    { 648, 144, -184},
    { 504, 136, -240},
    { 496, 152, -312},
    { 688, 128, -304},
    { 1112, 48, -224},
    { 1216, 152, -216},
    { 1600, 312, -200},
    { 1272, 344, -296},
    { 1152, 288, -256},
    { 1112, 232, -176},
    { 912, 264, -184},
    { 760, 352, -240},
    { 800, 384, -240},
    { 848, 376, -264},
    { 888, 408, -280},
    { 896, 472, -424},
    { 864, 472, -480},
    { 840, 408, -480},
    { 928, 360, -472},
    { 936, 344, -416},
    { 1032, 352, -336},
    { 1312, 392, -280},
    { 1552, 512, -416},
    { 1224, 344, -80},
    // 130 seconds
    { 1160, 376, -144},
    { 1200, 400, -176},
    { 1240, 368, -160},
    { 1032, 248, -88},
    { 880, 200, -96},
    { 800, 256, -152},
    { 776, 320, -144},
    { 728, 480, -208},
    { 704, 856, -152},
    { 600, 720, -152},
    { 496, 640, -176},
    { 504, 616, -168},
    { 560, 528, -280},
    { 736, 480, -256},
    { 1024, 176, -40},
    { 1448, 208, -144},
    { 1352, 248, -328},
    { 1344, 208, -192},
    { 1256, 208, -80},
    { 1104, 304, -104},
    { 1000, 424, -88},
    { 984, 496, -128},
    { 904, 520, -120},
    { 840, 544, -216},
    { 800, 536, -240},
    // 131 seconds
    { 728, 536, -352},
    { 696, 488, -352},
    { 752, 488, -392},
    { 784, 456, -408},
    { 848, 408, -360},
    { 920, 440, -336},
    { 1304, 456, -296},
    { 1424, 464, -392},
    { 1144, 464, -304},
    { 1432, 392, -128},
    { 1440, 400, -176},
    { 1600, 392, -248},
    { 1344, 360, -120},
    { 1216, 288, -80},
    { 1048, 208, -96},
    { 880, 160, -40},
    { 752, 152, -48},
    { 656, 192, -128},
    { 584, 408, -184},
    { 544, 656, -184},
    { 512, 704, -208},
    { 504, 800, -240},
    { 512, 824, -208},
    { 568, 792, -176},
    { 624, 728, -144},
    // 132 seconds
    { 664, 624, -136},
    { 792, 560, -144},
    { 1032, 560, -96},
    { 1432, 624, -144},
    { 1312, 656, -512},
    { 928, 464, -552},
    { 1008, 296, -240},
    { 896, 216, -144},
    { 808, 280, -176},
    { 800, 352, -200},
    { 784, 368, -200},
    { 832, 384, -272},
    { 912, 416, -328},
    { 888, 448, -360},
    { 872, 432, -352},
    { 856, 496, -416},
    { 760, 544, -320},
    { 672, 632, -312},
    { 592, 696, -272},
    { 568, 792, -192},
    { 552, 808, -160},
    { 504, 768, -104},
    { 488, 800, -72},
    { 480, 832, -8},
    { 552, 896, 16},
    // 133 seconds
    { 592, 896, 64},
    { 688, 944, 120},
    { 664, 848, 128},
    { 584, 712, 96},
    { 632, 688, 128},
    { 664, 624, 200},
    { 744, 648, 216},
    { 768, 712, 264},
    { 736, 712, 272},
    { 752, 768, 352},
    { 728, 848, 384},
    { 688, 832, 448},
    { 608, 856, 440},
    { 568, 864, 472},
    { 528, 832, 472},
    { 552, 784, 408},
    { 504, 720, 400},
    { 520, 744, 416},
    { 560, 840, 392},
    { 560, 776, 432},
    { 624, 800, 440},
    { 616, 776, 416},
    { 664, 744, 456},
    { 640, 760, 456},
    { 504, 776, 496},
    // 134 seconds
    { 576, 816, 568},
    { 600, 888, 624},
    { 632, 920, 680},
    { 696, 856, 720},
    { 704, 792, 696},
    { 704, 736, 648},
    { 640, 688, 608},
    { 584, 696, 600},
    { 664, 696, 224},
    { 352, 704, 336},
    { 288, 952, 288},
    { 208, 952, 192},
    { 224, 960, 232},
    { 208, 1016, 160},
    { 216, 1072, 200},
    { 168, 1040, 224},
    { 152, 1032, 176},
    { 88, 1040, 200},
    { 136, 1064, 200},
    { 152, 960, 104},
    { 168, 864, 104},
    { 168, 880, 0},
    { 168, 888, -24},
    { 136, 920, -104},
    { 120, 888, -192},
    // 135 seconds
    { 96, 864, -264},
    { 72, 928, -304},
    { 24, 952, -248},
    { 8, 992, -184},
    { 0, 1008, -320},
    { -40, 944, -272},
    { -56, 960, -384},
    { -48, 968, -320},
    { -32, 920, -432},
    { -136, 1160, -600},
    { -72, 640, -776},
    { -64, 672, -928},
    { -24, 192, -848},
    { -8, 72, -728},
    { 40, 16, -824},
    { 56, -80, -816},
    { 32, -160, -760},
    { 32, -96, -888},
    { -16, -128, -888},
    { -40, -88, -936},
    { -40, -80, -968},
    { -40, -40, -976},
    { -48, -24, -968},
    { -48, -40, -968},
    { -40, -72, -960},
    // 136 seconds
    { -40, -64, -976},
    { -48, -56, -976},
    { -48, -56, -960},
    { -48, -48, -920},
    { -40, -88, -872},
    { -56, -16, -792},
    { -48, 248, -800},
    { -56, 512, -776},
    { -96, 680, -744},
    { -120, 760, -688},
    { -104, 816, -696},
    { -80, 784, -624},
    { -88, 792, -440},
    { -160, 952, -344},
    { -216, 1024, -320},
    { -224, 1104, -248},
    { -208, 1000, -272},
    { -208, 976, -248},
    { -224, 928, -256},
    { -192, 912, -288},
    { -200, 920, -256},
    { -256, 768, -264},
    { -264, 864, -224},
    { -280, 872, -168},
    { -240, 872, -192},
    // 137 seconds
    { -200, 896, -288},
    { -200, 880, -184},
    { -176, 848, -144},
    { -136, 752, -96},
    { -136, 960, 96},
    { -168, 1152, 312},
    { -192, 1088, 416},
    { -216, 1104, 416},
    { -208, 1056, 288},
    { -224, 912, 312},
    { -208, 920, 192},
    { -152, 808, 144},
    { -144, 872, 88},
    { -128, 928, 16},
    { -128, 912, 112},
    { -112, 1088, 216},
    { -112, 1000, 256},
    { -88, 888, 352},
    { -72, 736, 224},
    { -88, 744, 432},
    { -96, 1016, 712},
    { -256, 984, 656},
    { -320, 1064, 624},
    { -296, 1024, 504},
    { -200, 1000, 384},
    // 138 seconds
    { -128, 896, 552},
    { -136, 1008, 528},
    { -72, 696, 496},
    { -48, 880, 536},
    { -32, 912, 544},
    { -8, 776, 536},
    { -24, 952, 520},
    { -72, 824, 584},
    { -136, 856, 696},
    { -168, 1120, 600},
    { -216, 728, 672},
    { -224, 872, 576},
    { -176, 1064, 480},
    { -160, 720, 368},
    { -176, 864, 312},
    { -200, 728, 352},
    { -176, 712, 448},
    { -216, 912, 376},
    { -216, 944, 488},
    { -280, 936, 360},
    { -336, 744, 344},
    { -352, 920, 224},
    { -320, 992, 120},
    { -296, 904, 176},
    { -176, 936, 104},
    // 139 seconds
    { -232, 984, 40},
    { -240, 944, 176},
    { -256, 840, 40},
    { -280, 848, 48},
    { -280, 896, -56},
    { -280, 888, -56},
    { -272, 944, 40},
    { -264, 1008, 24},
    { -264, 984, -16},
    { -192, 984, -16},
    { -176, 888, 40},
    { -224, 1000, -128},
    { -232, 944, -120},
    { -264, 1080, -176},
    { -248, 1096, -152},
    { -240, 1048, -128},
    { -240, 1080, -200},
    { -160, 936, -184},
    { -136, 848, -280},
    { -88, 792, -272},
    { -64, 880, -328},
    { -48, 888, -336},
    { -48, 864, -344},
    { -88, 928, -320},
    { -128, 904, -128},
    // 140 seconds
    { -240, 952, -48},
    { -272, 992, -56},
    { -312, 976, -160},
    { -384, 1032, -8},
    { -416, 904, 32},
    { -496, 920, 64},
    { -520, 800, 248},
    { -640, 800, 368},
    { -624, 664, 320},
    { -616, 776, 304},
    { -512, 600, 248},
    { -416, 816, 160},
    { -344, 800, 40},
    { -224, 760, -112},
    { -176, 616, -168},
    { -200, 872, -240},
    { -304, 928, -128},
    { -432, 1112, -248},
    { -448, 848, -272},
    { -464, 904, -256},
    { -416, 944, -312},
    { -368, 936, -296},
    { -296, 936, -320},
    { -288, 808, -416},
    { -288, 760, -456},
    // 141 seconds
    { -360, 912, -536},
    { -408, 760, -544},
    { -424, 744, -560},
    { -432, 792, -576},
    { -424, 696, -576},
    { -344, 568, -608},
    { -336, 552, -640},
    { -320, 488, -688},
    { -312, 440, -720},
    { -344, 424, -760},
    { -336, 320, -792},
    { -368, 336, -784},
    { -368, 352, -784},
    { -408, 440, -712},
    { -448, 512, -728},
    { -440, 472, -616},
    { -480, 416, -648},
    { -464, 448, -632},
    { -464, 576, -608},
    { -440, 520, -576},
    { -432, 520, -584},
    { -448, 312, -792},
    { -512, 448, -592},
    { -600, 488, -616},
    { -632, 344, -584},
    // 142 seconds
    { -608, 384, -672},
    { -720, 496, -544},
    { -664, 432, -472},
    { -768, 456, -336},
    { -832, 792, -224},
    { -1008, 560, -56},
    { -912, 656, -40},
    { -872, 672, -112},
    { -664, 792, -312},
    { -608, 560, -328},
    { -520, 568, -488},
    { -464, 568, -504},
    { -464, 512, -376},
    { -528, 528, -296},
    { -408, 624, -344},
    { -440, 544, -304},
    { -296, 456, -512},
    { -472, 432, -272},
    { -592, 344, -192},
    { -584, 240, -608},
    { -792, 320, -568},
    { -920, 312, -584},
    { -864, 248, -632},
    { -768, 296, -896},
    { -792, 448, -848},
    // 143 seconds
    { -384, 776, -936},
    { -656, 440, -576},
    { -608, 440, -608},
    { -712, 656, -480},
    { -592, 456, -528},
    { -624, 448, -536},
    { -648, 464, -512},
    { -608, 432, -552},
    { -656, 432, -520},
    { -624, 424, -520},
    { -656, 432, -400},
    { -712, 416, -592},
    { -640, 456, -552},
    { -728, 520, -584},
    { -680, 344, -512},
    { -656, 528, -576},
    { -704, 472, -496},
    { -648, 344, -512},
    { -664, 400, -520},
    { -656, 384, -544},
    { -640, 384, -560},
    { -664, 392, -544},
    { -648, 384, -552},
    { -672, 400, -528},
    { -664, 384, -536},
    // 144 seconds
    { -672, 392, -528},
    { -664, 392, -536},
    { -664, 392, -536},
    { -672, 384, -536},
    { -680, 408, -520},
    { -664, 384, -536},
    { -672, 400, -520},
    { -664, 408, -536},
    { -664, 376, -536},
    { -672, 392, -528},
    { -672, 392, -520},
    { -672, 392, -520},
    { -664, 392, -528},
    { -664, 392, -528},
    { -672, 400, -528},
    { -664, 392, -536},
    { -664, 392, -536},
    { -672, 392, -536},
    { -664, 392, -536},
    { -656, 392, -536},
    { -656, 384, -528},
    { -664, 392, -528},
    { -672, 392, -520},
    { -656, 392, -544},
    { -664, 392, -544},
    // 145 seconds
    { -656, 400, -544},
    { -656, 392, -544},
    { -664, 408, -536},
    { -664, 392, -536},
    { -664, 400, -528},
    { -664, 400, -536},
    { -664, 400, -520},
    { -680, 392, -528},
    { -680, 392, -520},
    { -688, 400, -512},
    { -664, 392, -520},
    { -680, 392, -520},
    { -680, 384, -520},
    { -680, 392, -512},
    { -680, 392, -512},
    { -680, 384, -520},
    { -688, 392, -512},
    { -672, 376, -520},
    { -696, 384, -504},
    { -680, 384, -512},
    { -680, 392, -520},
    { -680, 392, -512},
    { -688, 384, -512},
    { -680, 384, -512},
    { -672, 392, -520},
    // 146 seconds
    { -688, 400, -520},
    { -688, 384, -512},
    { -688, 384, -512},
    { -680, 392, -512},
    { -688, 392, -504},
    { -688, 384, -504},
    { -688, 384, -512},
    { -688, 392, -504},
    { -688, 384, -512},
    { -688, 384, -496},
    { -696, 384, -496},
    { -688, 384, -512},
    { -680, 392, -520},
    { -672, 392, -520},
    { -616, 256, -472},
    { -728, 408, -576},
    { -640, 488, -536},
    { -616, 272, -368},
    { -488, 288, -608},
    { -496, 432, -664},
    { -616, 616, -528},
    { -712, 720, -416},
    { -760, 912, -248},
    { -792, 792, -72},
    { -752, 720, -88},
    // 147 seconds
    { -784, 576, -24},
    { -736, 528, -128},
    { -792, 632, -368},
    { -696, 416, -224},
    { -736, 888, -168},
    { -744, 736, -64},
    { -752, 656, -136},
    { -616, 416, -320},
    { -648, 440, -320},
    { -632, 488, -288},
    { -568, 616, -432},
    { -480, 696, -344},
    { -512, 696, -176},
    { -552, 720, -40},
    { -544, 712, -32},
    { -512, 744, -48},
    { -384, 896, -152},
    { -384, 776, -104},
    { -408, 896, -88},
    { -432, 976, -16},
    { -416, 944, 0},
    { -408, 880, -112},
    { -336, 808, -104},
    { -552, 744, -80},
    { -576, 808, -96},
    // 148 seconds
    { -712, 744, -152},
    { -824, 704, -184},
    { -816, 648, -176},
    { -864, 632, -192},
    { -616, 560, -128},
    { -552, 344, -216},
    { -552, 240, -256},
    { -536, 280, -304},
    { -592, 464, -408},
    { -600, 440, -216},
    { -672, 720, -296},
    { -696, 688, -128},
    { -792, 736, -80},
    { -680, 760, -104},
    { -760, 712, -120},
    { -632, 808, -80},
    { -608, 720, -128},
    { -616, 704, -56},
    { -664, 856, -48},
    { -560, 872, -32},
    { -576, 792, -8},
    { -528, 816, -56},
    { -520, 808, -16},
    { -512, 768, 16},
    { -512, 808, -112},
    // 149 seconds
    { -536, 864, -112},
    { -488, 1064, -160},
    { -416, 928, -184},
    { -288, 520, -160},
    { -208, 584, -280},
    { -320, 608, -352},
    { -392, 616, -360},
    { -424, 720, -384},
    { -440, 712, -464},
    { -544, 792, -616},
    { -672, 760, -744},
    { -576, 496, -696},
    { -592, 840, -736},
    { -432, 560, -728},
    { -432, 600, -600},
    { -432, 768, -688},
    { -376, 656, -728},
    { -344, 728, -688},
    { -416, 656, -736},
    { -416, 552, -712},
    { -344, 376, -648},
    { -280, 176, -736},
    { -232, 144, -824},
    { -184, 56, -856},
    { -176, 176, -1000},
    // 150 seconds
    { -152, 104, -960},
    { -80, 16, -848},
    { -64, 0, -944},
    { -16, -56, -1040},
    { 48, -136, -960},
    { 72, -152, -920},
    { 136, -112, -936},
    { 152, -136, -864},
    { 192, -96, -856},
    { 160, -184, -968},
    { 192, -128, -1024},
    { 192, -136, -1016},
    { 208, -136, -1024},
    { 200, -152, -976},
    { 200, -160, -960},
    { 184, -128, -984},
    { 176, -168, -960},
    { 152, -160, -952},
    { 144, -56, -944},
    { 152, -152, -944},
    { 504, -328, -912},
    { 112, -120, -952},
    { 112, -136, -976},
    { 80, -112, -976},
    { 48, -96, -976},
    // 151 seconds
    { 40, -80, -976},
    { 64, -80, -992},
    { 40, -80, -992},
    { 56, -72, -984},
    { 64, -72, -976},
    { 56, -88, -960},
    { 40, -96, -952},
    { 40, -80, -960},
    { 48, -80, -960},
    { 48, -88, -944},
    { 72, -88, -984},
    { 96, -80, -992},
    { 112, -136, -976},
    { 136, -136, -968},
    { 152, -128, -968},
    { 168, -144, -952},
    { 168, -160, -960},
    { 344, -240, -904},
    { 128, -120, -1000},
    { 168, -152, -968},
    { 152, -176, -952},
    { 88, -160, -960},
    { 16, -40, -936},
    { 120, -208, -944},
    { 136, -232, -976},
    // 152 seconds
    { 160, -184, -1016},
    { 160, -192, -1008},
    { 88, -144, -968},
    { 72, -144, -920},
    { 88, -176, -952},
    { 80, -184, -984},
    { 232, -400, -944},
    { 264, -384, -1032},
    { 352, -368, -952},
    { 328, -240, -912},
    { 104, 64, -912},
    { -72, 368, -784},
    { -336, 600, -648},
    { -464, 760, -608},
    { -472, 784, -552},
    { -408, 720, -456},
    { -360, 744, -496},
    { -368, 752, -488},
    { -336, 744, -472},
    { -344, 744, -472},
    { -344, 760, -448},
    { -360, 760, -432},
    { -376, 752, -432},
    { -344, 776, -384},
    { -320, 784, -344},
    // 153 seconds
    { -328, 832, -312},
    { -296, 952, -256},
    { -344, 920, -352},
    { -336, 824, -448},
    { -384, 768, -224},
    { -376, 800, -120},
    { -424, 912, -248},
    { -416, 840, -152},
    { -424, 880, -96},
    { -448, 936, -120},
    { -432, 912, -56},
    { -416, 928, -56},
    { -384, 928, -136},
    { -384, 864, -136},
    { -376, 864, -144},
    { -424, 968, -128},
    { -440, 1008, -88},
    { -440, 992, -88},
    { -424, 888, -152},
    { -432, 808, -288},
    { -432, 720, -304},
    { -456, 648, -456},
    { -488, 552, -456},
    { -504, 608, -528},
    { -504, 616, -432},
    // 154 seconds
    { -552, 624, -360},
    { -528, 776, -360},
    { -520, 792, -456},
    { -480, 640, -440},
    { -456, 656, -472},
    { -448, 896, -424},
    { -504, 904, -352},
    { -576, 896, -288},
    { -576, 360, -456},
    { -536, 248, -696},
    { -640, 32, -808},
    { -728, 24, -744},
    { -760, -80, -680},
    { -760, -144, -656},
    { -672, 48, -744},
    { -584, 120, -736},
    { -536, 320, -856},
    { -488, 368, -824},
    { -560, 288, -680},
    { -456, 336, -720},
    { -480, 352, -656},
    { -496, 488, -600},
    { -536, 480, -600},
    { -552, 504, -568},
    { -616, 432, -584},
    // 155 seconds
    { -680, 352, -536},
    { -640, 328, -544},
    { -616, 304, -520},
    { -608, 336, -536},
    { -512, 296, -600},
    { -568, 376, -616},
    { -552, 376, -720},
    { -632, 264, -584},
    { -664, 240, -472},
    { -728, 328, -432},
    { -768, 472, -424},
    { -720, 600, -448},
    { -776, 248, -496},
    { -744, 336, -504},
    { -728, 200, -480},
    { -768, 248, -432},
    { -792, 304, -480},
    { -736, 248, -480},
    { -800, 208, -464},
    { -784, 232, -432},
    { -792, 264, -416},
    { -792, 272, -440},
    { -808, 272, -408},
    { -784, 256, -416},
    { -816, 256, -408},
    // 156 seconds
    { -800, 256, -408},
    { -824, 256, -384},
    { -816, 240, -392},
    { -816, 232, -384},
    { -832, 232, -376},
    { -832, 232, -376},
    { -824, 224, -376},
    { -840, 224, -376},
    { -832, 224, -376},
    { -832, 240, -368},
    { -824, 216, -376},
    { -840, 240, -360},
    { -832, 224, -368},
    { -840, 232, -368},
    { -824, 216, -368},
    { -840, 224, -368},
    { -832, 232, -360},
    { -840, 232, -368},
    { -824, 224, -360},
    { -832, 224, -360},
    { -824, 224, -368},
    { -832, 224, -352},
    { -832, 232, -352},
    { -824, 216, -368},
    { -832, 240, -352},
    // 157 seconds
    { -824, 224, -360},
    { -832, 240, -360},
    { -832, 232, -360},
    { -840, 240, -360},
    { -832, 224, -360},
    { -832, 232, -360},
    { -832, 232, -360},
    { -856, 240, -352},
    { -840, 224, -360},
    { -824, 224, -360},
    { -816, 240, -376},
    { -832, 216, -360},
    { -816, 224, -344},
    { -824, 208, -368},
    { -848, 240, -360},
    { -824, 216, -360},
    { -832, 216, -360},
    { -832, 224, -360},
    { -824, 232, -368},
    { -832, 224, -360},
    { -840, 216, -352},
    { -840, 216, -368},
    { -840, 224, -360},
    { -832, 224, -360},
    { -832, 216, -360},
    // 158 seconds
    { -832, 224, -360},
    { -832, 232, -360},
    { -832, 216, -360},
    { -832, 216, -360},
    { -832, 224, -368},
    { -840, 224, -352},
    { -840, 224, -360},
    { -832, 208, -360},
    { -832, 216, -352},
    { -832, 224, -360},
    { -832, 216, -360},
    { -832, 216, -360},
    { -824, 216, -360},
    { -840, 224, -360},
    { -832, 224, -360},
    { -832, 224, -360},
    { -832, 224, -360},
    { -832, 216, -360},
    { -840, 216, -352},
    { -832, 216, -360},
    { -840, 240, -368},
    { -832, 216, -368},
    { -832, 224, -360},
    { -832, 224, -368},
    { -848, 224, -352},
    // 159 seconds
    { -824, 216, -360},
    { -832, 232, -368},
    { -840, 232, -368},
    { -832, 216, -368},
    { -832, 208, -360},
    { -832, 216, -368},
    { -832, 224, -368},
    { -824, 208, -368},
    { -840, 232, -368},
    { -832, 232, -368},
    { -832, 224, -368},
    { -832, 224, -360},
    { -840, 232, -360},
    { -832, 216, -376},
    { -840, 232, -360},
    { -832, 224, -368},
    { -832, 224, -368},
    { -832, 224, -360},
    { -832, 232, -352},
    { -824, 216, -360},
    { -840, 232, -368},
    { -824, 224, -376},
    { -840, 232, -368},
    { -832, 224, -360},
    { -824, 248, -376},
    // 160 seconds
    { -840, 240, -360},
    { -824, 248, -384},
    { -824, 248, -392},
    { -824, 256, -384},
    { -808, 256, -416},
    { -784, 272, -440},
    { -768, 280, -464},
    { -752, 320, -496},
    { -712, 336, -544},
    { -664, 344, -608},
    { -672, 504, -704},
    { -624, 392, -664},
    { -624, 304, -600},
    { -616, 272, -600},
    { -656, 280, -648},
    { -592, 200, -648},
    { -528, 248, -672},
    { -456, 432, -848},
    { -432, 328, -832},
    { -376, 320, -720},
    { -296, 488, -640},
    { -200, 504, -784},
    { -168, 488, -744},
    { -400, 648, -368},
    { -544, 656, -576},
    // 161 seconds
    { -616, 480, -408},
    { -712, 480, -280},
    { -704, 352, -264},
    { -672, 264, -200},
    { -784, 272, -464},
    { -552, 200, -296},
    { -488, 312, -448},
    { -344, 160, -512},
    { -352, 464, -336},
    { -304, 856, -808},
    { -392, 1536, -1144},
    { -744, 1448, -824},
    { -816, 1000, -672},
    { -832, 872, -616},
    { -560, 128, -368},
    { -232, -224, -528},
    { -120, -280, -768},
    { 0, -240, -1032},
    { 136, -240, -984},
    { 160, 0, -960},
    { 112, -224, -1064},
    { 312, -376, -1104},
    { 376, -392, -912},
    { 264, -368, -848},
    { 440, -320, -848},
    // 162 seconds
    { 336, -352, -848},
    { 256, -368, -840},
    { 392, -384, -848},
    { 304, -440, -824},
    { 440, -304, -904},
    { 360, -432, -888},
    { 280, -368, -904},
    { 312, -360, -936},
    { 272, -328, -928},
    { 232, -400, -856},
    { 296, -472, -816},
    { 320, -440, -872},
    { 240, -416, -864},
    { 184, -416, -888},
    { 192, -376, -872},
    { 232, -384, -944},
    { 200, -344, -912},
    { 192, -360, -904},
    { 184, -368, -880},
    { 200, -368, -888},
    { 200, -336, -912},
    { 200, -328, -912},
    { 184, -352, -912},
    { 176, -336, -912},
    { 184, -360, -920},
    // 163 seconds
    { 184, -368, -936},
    { 192, -400, -920},
    { 128, -360, -912},
    { 104, -304, -904},
    { 120, -304, -912},
    { 136, -304, -912},
    { 152, -320, -912},
    { 160, -344, -920},
    { 160, -360, -912},
    { 176, -384, -920},
    { 200, -400, -936},
    { 240, -448, -944},
    { 264, -416, -896},
    { 240, -376, -872},
    { 272, -352, -816},
    { 184, -304, -864},
    { 160, -232, -928},
    { 136, -168, -1000},
    { 128, -200, -1000},
    { 152, -256, -960},
    { 80, -240, -1008},
    { 48, -160, -1064},
    { -32, -80, -1064},
    { -136, -16, -1008},
    { -232, 88, -920},
    // 164 seconds
    { -224, 64, -928},
    { -256, 88, -712},
    { -288, 128, -808},
    { -408, 152, -728},
    { -496, 288, -760},
    { -488, 584, -720},
    { -552, 776, -640},
    { -624, 520, -360},
    { -624, 608, -568},
    { -640, 328, -576},
    { -768, 352, -608},
    { -832, 232, -584},
    { -792, 176, -496},
    { -640, 112, -544},
    { -552, 296, -536},
    { -560, 512, -640},
    { -504, 552, -592},
    { -456, 488, -648},
    { -456, 544, -608},
    { -488, 464, -624},
    { -528, 520, -680},
    { -544, 440, -664},
    { -688, 440, -560},
    { -696, 440, -480},
    { -688, 456, -568},
    // 165 seconds
    { -632, 416, -584},
    { -624, 424, -592},
    { -616, 392, -592},
    { -768, 336, -568},
    { -680, 256, -624},
    { -640, 144, -568},
    { -648, 144, -528},
    { -704, 184, -576},
    { -720, 184, -688},
    { -656, 176, -656},
    { -624, 136, -680},
    { -704, 120, -632},
    { -680, 112, -640},
    { -696, 136, -624},
    { -672, 144, -624},
    { -656, 144, -608},
    { -712, 192, -584},
    { -704, 152, -584},
    { -696, 112, -592},
    { -744, 240, -568},
    { -736, 272, -576},
    { -720, 216, -544},
    { -752, 224, -528},
    { -736, 248, -536},
    { -728, 240, -536},
    // 166 seconds
    { -736, 240, -528},
    { -760, 280, -536},
    { -736, 240, -536},
    { -712, 216, -544},
    { -720, 248, -544},
    { -696, 200, -600},
    { -736, 256, -536},
    { -704, 224, -552},
    { -728, 248, -536},
    { -720, 248, -544},
    { -728, 240, -552},
    { -736, 256, -536},
    { -712, 224, -536},
    { -736, 240, -528},
    { -760, 256, -528},
    { -720, 224, -528},
    { -728, 216, -528},
    { -728, 232, -536},
    { -728, 224, -520},
    { -728, 224, -528},
    { -728, 232, -520},
    { -744, 320, -504},
    { -776, 304, -496},
    { -744, 232, -520},
    { -736, 264, -496},
    // 167 seconds
    { -744, 248, -512},
    { -744, 264, -520},
    { -720, 240, -504},
    { -752, 304, -488},
    { -744, 288, -488},
    { -752, 320, -480},
    { -752, 288, -480},
    { -752, 304, -480},
    { -752, 288, -472},
    { -752, 304, -480},
    { -752, 296, -480},
    { -744, 296, -480},
    { -752, 296, -472},
    { -744, 288, -488},
    { -760, 312, -472},
    { -744, 296, -472},
    { -752, 288, -488},
    { -752, 296, -480},
    { -744, 288, -480},
    { -744, 288, -472},
    { -744, 288, -480},
    { -752, 296, -480},
    { -752, 280, -480},
    { -760, 288, -464},
    { -752, 288, -472},
    // 168 seconds
    { -760, 280, -464},
    { -752, 288, -472},
    { -760, 288, -472},
    { -760, 288, -464},
    { -760, 296, -464},
    { -768, 312, -464},
    { -752, 288, -472},
    { -760, 288, -472},
    { -760, 296, -464},
    { -752, 288, -464},
    { -760, 288, -464},
    { -760, 288, -464},
    { -760, 288, -472},
    { -752, 288, -472},
    { -760, 288, -472},
    { -760, 288, -464},
    { -760, 288, -464},
    { -752, 280, -448},
    { -744, 304, -488},
    { -744, 304, -448},
    { -768, 304, -456},
    { -768, 296, -456},
    { -760, 280, -456},
    { -752, 288, -456},
    { -760, 304, -456},
    // 169 seconds
    { -752, 288, -456},
    { -760, 296, -456},
    { -760, 288, -464},
    { -760, 304, -464},
    { -760, 296, -464},
    { -760, 296, -456},
    { -768, 296, -464},
    { -760, 296, -456},
    { -760, 296, -456},
    { -760, 296, -456},
    { -760, 288, -464},
    { -768, 296, -456},
    { -760, 296, -464},
    { -752, 288, -456},
    { -760, 296, -456},
    { -744, 272, -464},
    { -776, 288, -456},
    { -760, 288, -448},
    { -760, 288, -456},
    { -768, 288, -456},
    { -768, 288, -456},
    { -768, 288, -464},
    { -784, 312, -448},
    { -760, 288, -464},
    { -768, 296, -456},
    // 170 seconds
    { -760, 280, -464},
    { -768, 296, -456},
    { -760, 288, -456},
    { -768, 288, -448},
    { -760, 288, -464},
    { -760, 288, -456},
    { -760, 296, -464},
    { -760, 296, -448},
    { -768, 288, -456},
    { -752, 296, -464},
    { -752, 304, -464},
    { -760, 328, -464},
    { -728, 304, -456},
    { -776, 320, -480},
    { -736, 328, -504},
    { -712, 320, -472},
    { -600, 312, -432},
    { -640, 416, -440},
    { -568, 456, -480},
    { -528, 520, -496},
    { -472, 536, -632},
    { -424, 696, -816},
    { -416, 712, -760},
    { -504, 488, -496},
    { -576, 640, -552},
    // 171 seconds
    { -544, 520, -568},
    { -512, 480, -536},
    { -456, 552, -600},
    { -432, 544, -608},
    { -360, 608, -720},
    { -312, 656, -768},
    { -216, 528, -800},
    { -120, 528, -568},
    { -40, 504, -664},
    { -16, 496, -512},
    { -240, 440, -584},
    { -256, 440, -520},
    { -88, 408, -408},
    { 112, 696, -392},
    { -32, 848, 24},
    { -640, 800, 200},
    { -1272, 672, 216},
    { -1288, 480, 144},
    { -1128, 576, -112},
    { -728, 592, -272},
    { -504, 952, -400},
    { -304, 1184, -880},
    { -440, 680, -752},
    { -384, 760, -720},
    { -376, 672, -384},
    // 172 seconds
    { -288, 728, -456},
    { -256, 872, -248},
    { -168, 1312, -64},
    { -272, 1192, -136},
    { -248, 944, -32},
    { -232, 1032, -32},
    { -208, 856, -8},
    { -184, 1072, 64},
    { -144, 1144, 152},
    { -136, 1056, 120},
    { -88, 1224, -8},
    { -80, 1040, -200},
    { -104, 800, -200},
    { -152, 760, -240},
    { -152, 912, -304},
    { -24, 1000, -384},
    { -72, 920, -336},
    { -104, 984, -304},
    { -144, 968, -264},
    { -112, 904, -176},
    { -112, 896, -224},
    { -64, 1080, -264},
    { -64, 944, -256},
    { -88, 936, -296},
    { -120, 968, -328},
    // 173 seconds
    { -128, 880, -376},
    { -104, 688, -384},
    { -88, 712, -544},
    { -120, 720, -632},
    { -104, 576, -632},
    { -96, 640, -704},
    { -96, 552, -704},
    { -160, 664, -744},
    { -248, 768, -824},
    { -336, 936, -864},
    { -192, 544, -784},
    { 8, 104, -800},
    { 24, -56, -832},
    { 48, -48, -824},
    { 96, -96, -840},
    { 120, -40, -896},
    { 96, -32, -968},
    { 136, 0, -1000},
    { 168, -24, -984},
    { 216, -56, -984},
    { 256, -144, -960},
    { 288, -120, -936},
    { 296, -136, -936},
    { 280, -112, -928},
    { 288, -96, -920},
    // 174 seconds
    { 296, -112, -944},
    { 304, -88, -1016},
    { 408, -200, -1144},
    { 448, -336, -1016},
    { 392, 64, -896},
    { 216, 520, -720},
    { -56, 824, -576},
    { -200, 800, -520},
    { -216, 720, -448},
    { -240, 864, -448},
    { -232, 880, -504},
    { -184, 776, -512},
    { -200, 864, -552},
    { -216, 1040, -616},
    { -192, 896, -672},
    { -168, 800, -640},
    { -120, 488, -672},
    { -80, 344, -808},
    { -80, 336, -824},
    { -112, 432, -848},
    { -112, 416, -856},
    { -136, 384, -856},
    { -144, 368, -864},
    { -136, 344, -864},
    { -136, 344, -872},
    // 175 seconds
    { -144, 328, -880},
    { -136, 328, -896},
    { -136, 288, -896},
    { -152, 280, -888},
    { -136, 272, -896},
    { -128, 240, -904},
    { -120, 256, -912},
    { -120, 248, -904},
    { -120, 248, -912},
    { -104, 248, -928},
    { -80, 232, -904},
    { -96, 240, -872},
    { -112, 360, -856},
    { -112, 392, -848},
    { -112, 408, -824},
    { -120, 472, -816},
    { -112, 552, -800},
    { -120, 568, -760},
    { -128, 600, -736},
    { -144, 632, -696},
    { -128, 688, -680},
    { -128, 704, -664},
    { -120, 704, -640},
    { -112, 760, -608},
    { -128, 792, -592},
    // 176 seconds
    { -128, 808, -584},
    { -128, 784, -568},
    { -120, 768, -576},
    { -120, 776, -576},
    { -120, 760, -568},
    { -120, 784, -560},
    { -120, 784, -560},
    { -120, 792, -544},
    { -120, 784, -536},
    { -120, 792, -520},
    { -120, 800, -512},
    { -120, 816, -496},
    { -128, 824, -472},
    { -136, 840, -456},
    { -144, 848, -424},
    { -152, 872, -432},
    { -136, 872, -416},
    { -120, 872, -440},
    { -112, 864, -432},
    { -128, 888, -432},
    { -120, 920, -424},
    { -112, 880, -456},
    { -120, 864, -456},
    { -96, 760, -496},
    { -72, 696, -600},
    // 177 seconds
    { -64, 696, -640},
    { -64, 728, -656},
    { -48, 704, -664},
    { -64, 712, -648},
    { -72, 712, -616},
    { -64, 760, -600},
    { -72, 768, -568},
    { -64, 784, -560},
    { -72, 808, -568},
    { -64, 792, -576},
    { -72, 784, -544},
    { -88, 832, -520},
    { -96, 856, -472},
    { -88, 848, -448},
    { -80, 848, -416},
    { -80, 872, -384},
    { -88, 872, -368},
    { -96, 944, -360},
    { -96, 952, -328},
    { -120, 928, -328},
    { -128, 1000, -344},
    { -144, 1016, -360},
    { -128, 952, -408},
    { -104, 920, -416},
    { -96, 752, -408},
    // 178 seconds
    { -80, 680, -504},
    { -88, 608, -664},
    { -96, 680, -664},
    { -112, 704, -672},
    { -112, 616, -680},
    { -104, 680, -672},
    { -96, 648, -680},
    { -80, 544, -752},
    { -72, 464, -784},
    { -64, 464, -800},
    { -48, 448, -832},
    { -24, 416, -856},
    { -16, 440, -816},
    { -16, 480, -792},
    { -24, 544, -632},
    { 8, 688, -664},
    { 40, 736, -640},
    { 0, 624, -568},
    { 40, 632, -512},
    { -32, 808, -336},
    { -112, 920, -216},
    { -8, 1008, -120},
    { -16, 1056, 136},
    { 16, 1184, 152},
    { 0, 1224, 184},
    // 179 seconds
    { 0, 1104, 304},
    { 32, 1128, 352},
    { 72, 1032, 424},
    { 96, 920, 400},
    { 120, 960, 416},
    { 104, 928, 392},
    { 88, 920, 384},
    { 72, 944, 384},
    { 88, 944, 328},
    { 96, 960, 280},
    { 72, 952, 296},
    { 80, 960, 280},
    { 80, 1008, 248},
    { 80, 976, 184},
    { 88, 888, 208},
    { 80, 1008, 160},
    { 80, 1008, 168},
    { 56, 984, 200},
    { 40, 952, 224},
    { 56, 952, 264},
    { 56, 976, 280},
    { 48, 992, 328},
    { 40, 936, 360},
    { 40, 976, 360},
    { 48, 976, 392},
    // 180 seconds
    // elapsed: 3 minutes
    { 48, 952, 392},
    { 56, 960, 384},
    { 80, 928, 392},
    { 80, 928, 384},
    { 72, 952, 352},
    { 64, 928, 368},
    { 56, 920, 384},
    { 48, 976, 344},
    { 32, 992, 336},
    { 32, 904, 328},
    { 32, 928, 272},
    { 32, 944, 256},
    { 40, 976, 216},
    { 40, 992, 224},
    { 64, 976, 232},
    { 64, 992, 200},
    { 56, 992, 200},
    { 40, 976, 208},
    { 48, 1000, 184},
    { 64, 992, 184},
    { 64, 1024, 160},
    { 64, 944, 136},
    { 56, 952, 136},
    { 56, 1000, 112},
    { 72, 992, 128},
    // 181 seconds
    { 48, 992, 112},
    { 32, 976, 128},
    { 24, 1000, 112},
    { 16, 968, 136},
    { 24, 976, 152},
    { 24, 1024, 176},
    { 48, 992, 184},
    { 48, 1000, 200},
    { 48, 1000, 216},
    { 40, 984, 224},
    { 48, 1008, 208},
    { 40, 960, 216},
    { 24, 944, 232},
    { 24, 976, 216},
    { 24, 1000, 224},
    { 24, 976, 216},
    { 16, 1024, 208},
    { 16, 1048, 160},
    { 8, 1064, 72},
    { 40, 960, -16},
    { 56, 952, -88},
    { 80, 928, -224},
    { 56, 984, -288},
    { 80, 816, -304},
    { 48, 912, -352},
    // 182 seconds
    { 72, 872, -320},
    { 64, 920, -296},
    { 56, 936, -272},
    { 48, 968, -216},
    { 32, 976, -168},
    { 32, 1024, -136},
    { 32, 1016, -112},
    { 40, 968, -96},
    { 32, 976, -96},
    { 40, 960, -88},
    { 40, 960, -64},
    { 40, 984, -24},
    { 40, 960, 24},
    { 40, 1048, 64},
    { 40, 928, 152},
    { 16, 1024, 200},
    { 16, 992, 240},
    { 16, 976, 272},
    { 16, 992, 288},
    { 32, 968, 272},
    { 16, 976, 288},
    { 24, 952, 288},
    { 24, 968, 304},
    { 24, 984, 296},
    { 32, 960, 288},
    // 183 seconds
    { 24, 1024, 264},
    { 32, 1064, 200},
    { 24, 968, 168},
    { 40, 928, 88},
    { 8, 1224, -32},
    { 24, 864, -96},
    { 24, 1080, -240},
    { -8, 824, -320},
    { 40, 976, -528},
    { 16, 720, -584},
    { 96, 576, -720},
    { 56, 544, -848},
    { 96, 424, -896},
    { 80, 464, -872},
    { 120, 272, -912},
    { 120, 288, -928},
    { 128, 248, -936},
    { 128, 248, -1016},
    { 104, 256, -1024},
    { 152, 200, -968},
    { 176, 184, -976},
    { 176, 32, -960},
    { 152, -8, -920},
    { 48, 48, -928},
    { 8, -72, -904},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-19 11:06:02 local
AccelRawData *activity_sample_walk_200_pbl_27927_11(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_27927_11
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 180
  //> TEST_EXPECTED_MAX 220
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 24, 24, -936},
    { -32, -216, -968},
    { -24, 136, -912},
    { -8, 88, -896},
    { -48, -176, -928},
    { 72, 24, -912},
    { 48, 256, -992},
    { -128, -56, -984},
    { -24, -16, -904},
    { 64, -24, -960},
    { 112, -32, -928},
    { 48, -64, -968},
    { -16, -72, -1000},
    { 72, -32, -944},
    { -96, -32, -896},
    { 48, -160, -952},
    { -104, -24, -1000},
    { -40, -32, -1024},
    { -40, -72, -1000},
    { -40, -88, -992},
    { 16, -128, -976},
    { 0, -104, -1016},
    { 8, -80, -952},
    { 16, -80, -928},
    { 8, -80, -960},
    // 1 seconds
    { 80, -112, -968},
    { -40, -80, -1000},
    { 16, -80, -1000},
    { -16, -72, -992},
    { -8, -88, -960},
    { 16, -88, -952},
    { 0, -72, -952},
    { 32, -40, -928},
    { -64, -56, -976},
    { 24, -104, -1024},
    { 8, -112, -1000},
    { 48, -136, -944},
    { -64, -144, -968},
    { -40, -128, -984},
    { -24, -104, -1000},
    { 112, -120, -976},
    { 8, -56, -944},
    { 16, -56, -936},
    { 40, -64, -952},
    { 48, -72, -984},
    { 32, -80, -992},
    { 32, -88, -992},
    { 16, -88, -984},
    { 16, -72, -984},
    { 40, -72, -976},
    // 2 seconds
    { 32, -96, -968},
    { 16, -88, -960},
    { 32, -104, -976},
    { -8, -64, -984},
    { 24, -72, -984},
    { 32, -80, -968},
    { -40, -96, -944},
    { 32, -104, -960},
    { 80, -48, -936},
    { 32, -120, -904},
    { -32, -112, -984},
    { 16, -104, -928},
    { -48, -192, -984},
    { -32, -176, -968},
    { -48, -128, -992},
    { -56, -144, -984},
    { -80, -112, -952},
    { -8, -88, -960},
    { 72, -64, -968},
    { 40, -80, -960},
    { 72, -80, -952},
    { 48, -64, -992},
    { 8, -80, -992},
    { 136, -128, -1008},
    { 16, -80, -976},
    // 3 seconds
    { 24, -80, -968},
    { 32, -88, -976},
    { 16, -80, -976},
    { 24, -80, -968},
    { 8, -88, -968},
    { 24, -96, -968},
    { 32, -80, -960},
    { 24, -80, -976},
    { 16, -72, -968},
    { 16, -80, -976},
    { 24, -88, -968},
    { 8, -80, -984},
    { 8, -88, -976},
    { 8, -104, -968},
    { 24, -96, -976},
    { 24, -80, -976},
    { 16, -80, -976},
    { 8, -88, -976},
    { 8, -88, -976},
    { 8, -80, -968},
    { 0, -80, -976},
    { 8, -80, -968},
    { 8, -80, -968},
    { 16, -96, -976},
    { 8, -88, -976},
    // 4 seconds
    { 8, -88, -968},
    { 16, -80, -968},
    { 0, -88, -976},
    { 8, -80, -976},
    { 8, -80, -976},
    { 8, -80, -960},
    { 8, -80, -976},
    { 16, -80, -976},
    { 24, -88, -976},
    { 16, -72, -976},
    { 8, -80, -976},
    { 16, -64, -976},
    { 16, -64, -976},
    { 16, -72, -976},
    { 16, -72, -968},
    { 16, -72, -976},
    { 16, -64, -968},
    { 16, -64, -976},
    { 8, -64, -976},
    { 16, -64, -976},
    { 16, -64, -976},
    { 16, -64, -976},
    { 16, -48, -968},
    { 8, -48, -968},
    { 16, -56, -992},
    // 5 seconds
    { 8, -64, -984},
    { 16, -56, -968},
    { 16, -56, -960},
    { 16, -48, -976},
    { 8, -48, -976},
    { 16, -56, -976},
    { 24, -64, -976},
    { 24, -56, -968},
    { 16, -64, -976},
    { 16, -48, -984},
    { 24, -48, -976},
    { 24, -48, -976},
    { 32, -56, -968},
    { 24, -48, -960},
    { 40, -56, -960},
    { 16, -16, -976},
    { 48, -40, -968},
    { 24, -32, -968},
    { 40, -48, -960},
    { 80, -56, -960},
    { 96, -56, -960},
    { 120, -64, -928},
    { 120, -48, -896},
    { 104, -8, -896},
    { 96, 120, -816},
    // 6 seconds
    { 64, 296, -776},
    { 16, 544, -736},
    { -32, 784, -648},
    { -112, 936, -544},
    { -144, 1048, -392},
    { -112, 976, -256},
    { -88, 1096, -152},
    { -64, 1048, -56},
    { -48, 1056, 40},
    { -56, 1048, 72},
    { -40, 968, 152},
    { -48, 1056, 160},
    { -32, 1032, 184},
    { 8, 1048, 184},
    { -16, 1024, 200},
    { -16, 1008, 208},
    { 0, 960, 192},
    { 8, 976, 200},
    { 0, 976, 232},
    { 0, 992, 208},
    { -8, 968, 216},
    { 0, 984, 216},
    { 16, 992, 184},
    { 24, 992, 176},
    { 32, 984, 160},
    // 7 seconds
    { 40, 984, 152},
    { 48, 992, 160},
    { 48, 992, 136},
    { 56, 984, 112},
    { 56, 992, 104},
    { 64, 984, 120},
    { 56, 1000, 96},
    { 56, 1000, 80},
    { 64, 992, 96},
    { 64, 992, 112},
    { 72, 984, 104},
    { 88, 984, 104},
    { 104, 976, 112},
    { 104, 984, 120},
    { 112, 1000, 120},
    { 112, 1016, 104},
    { 120, 992, 112},
    { 120, 992, 96},
    { 144, 968, 104},
    { 168, 968, 104},
    { 168, 1000, 88},
    { 208, 992, 56},
    { 200, 952, 40},
    { 192, 960, 16},
    { 200, 936, 32},
    // 8 seconds
    { 208, 976, 32},
    { 232, 960, 32},
    { 216, 904, 16},
    { 240, 1064, 32},
    { 256, 1048, 88},
    { 224, 1072, 96},
    { 192, 1040, 96},
    { 152, 984, 64},
    { 144, 960, 80},
    { 112, 992, 64},
    { 112, 1008, 56},
    { 88, 1016, 56},
    { 104, 952, 56},
    { 112, 904, 72},
    { 88, 912, 56},
    { 112, 864, 64},
    { 96, 880, 104},
    { 56, 888, 128},
    { 56, 968, 152},
    { 56, 992, 160},
    { 32, 1016, 168},
    { 48, 1016, 232},
    { 64, 1000, 256},
    { 64, 1016, 288},
    { 96, 992, 352},
    // 9 seconds
    { 128, 944, 432},
    { 176, 960, 392},
    { 216, 976, 384},
    { 232, 992, 368},
    { 200, 1008, 296},
    { 256, 904, 152},
    { 280, 880, 208},
    { 352, 880, 184},
    { 352, 1080, 160},
    { 344, 1096, 192},
    { 320, 1024, 152},
    { 256, 1112, 80},
    { 272, 952, 80},
    { 288, 928, 48},
    { 288, 992, 16},
    { 280, 928, 32},
    { 280, 976, -32},
    { 288, 960, -16},
    { 280, 984, -48},
    { 280, 920, -8},
    { 320, 904, 0},
    { 352, 952, -32},
    { 368, 920, -8},
    { 424, 992, -48},
    { 456, 984, -96},
    // 10 seconds
    { 432, 912, -136},
    { 456, 904, -168},
    { 512, 920, -232},
    { 576, 840, -240},
    { 560, 792, -256},
    { 592, 784, -264},
    { 600, 776, -248},
    { 664, 800, -304},
    { 704, 792, -256},
    { 704, 704, -232},
    { 704, 704, -248},
    { 688, 704, -248},
    { 704, 712, -288},
    { 696, 664, -264},
    { 696, 680, -288},
    { 656, 696, -296},
    { 640, 728, -320},
    { 608, 736, -328},
    { 584, 736, -336},
    { 552, 728, -328},
    { 504, 736, -352},
    { 464, 728, -360},
    { 432, 752, -352},
    { 472, 776, -376},
    { 456, 808, -392},
    // 11 seconds
    { 456, 800, -416},
    { 416, 768, -432},
    { 376, 752, -448},
    { 344, 736, -432},
    { 336, 760, -424},
    { 336, 816, -424},
    { 320, 848, -432},
    { 320, 888, -440},
    { 312, 904, -472},
    { 312, 880, -488},
    { 280, 824, -496},
    { 264, 824, -528},
    { 224, 896, -600},
    { 216, 704, -600},
    { 208, 736, -688},
    { 208, 736, -752},
    { 232, 712, -784},
    { 240, 656, -784},
    { 224, 616, -728},
    { 168, 592, -712},
    { 104, 496, -728},
    { 88, 496, -784},
    { 88, 424, -744},
    { 32, 432, -776},
    { 16, 376, -760},
    // 12 seconds
    { 16, 376, -752},
    { 16, 400, -744},
    { 24, 408, -840},
    { -24, 400, -856},
    { -32, 360, -848},
    { -40, 288, -824},
    { -64, 352, -856},
    { -56, 376, -896},
    { 16, 416, -896},
    { 104, 456, -912},
    { 256, 536, -976},
    { 376, 528, -960},
    { 456, 520, -976},
    { 696, 560, -1024},
    { 736, 440, -840},
    { 576, 304, -664},
    { 472, 368, -584},
    { 352, 408, -544},
    { 288, 448, -544},
    { 304, 568, -656},
    { 304, 536, -704},
    { 216, 528, -680},
    { 152, 608, -752},
    { 112, 624, -752},
    { 96, 560, -744},
    // 13 seconds
    { 56, 584, -736},
    { 0, 632, -760},
    { 64, 704, -760},
    { 96, 736, -752},
    { 160, 912, -848},
    { 240, 1056, -928},
    { 400, 1000, -912},
    { 376, 736, -768},
    { 344, 776, -776},
    { 352, 744, -728},
    { 344, 568, -648},
    { 280, 592, -640},
    { 184, 464, -584},
    { 96, 504, -672},
    { 16, 560, -672},
    { 88, 456, -688},
    { 120, 368, -736},
    { 120, 248, -696},
    { 200, 248, -744},
    { 336, 168, -752},
    { 448, 200, -760},
    { 544, 80, -656},
    { 624, 136, -672},
    { 880, 272, -848},
    { 896, 192, -680},
    // 14 seconds
    { 776, 216, -624},
    { 704, 232, -496},
    { 728, 160, -352},
    { 816, 272, -400},
    { 960, 272, -384},
    { 1088, 256, -504},
    { 1120, 496, -672},
    { 1040, 376, -768},
    { 936, 608, -944},
    { 992, 616, -1024},
    { 976, 632, -1096},
    { 984, 544, -1016},
    { 1160, 536, -904},
    { 1152, 560, -592},
    { 1016, 456, -256},
    { 960, 624, -216},
    { 816, 864, -64},
    { 480, 832, 32},
    { 408, 744, 16},
    { 424, 808, 184},
    { 288, 808, 112},
    { 192, 840, 184},
    { 128, 848, 128},
    { 48, 808, 104},
    { -40, 840, 96},
    // 15 seconds
    { -72, 792, 96},
    { -144, 888, 88},
    { -152, 904, 64},
    { -192, 904, 80},
    { -200, 952, 64},
    { -208, 952, 72},
    { -200, 992, 80},
    { -168, 1032, 104},
    { -72, 1080, 56},
    { -72, 1072, 40},
    { 16, 1120, 48},
    { 200, 1136, -16},
    { 200, 1048, -64},
    { 168, 928, -8},
    { 168, 896, 0},
    { 136, 848, -16},
    { 72, 784, -8},
    { 24, 824, -40},
    { 0, 848, 0},
    { 8, 928, -8},
    { 16, 992, 0},
    { 8, 952, 0},
    { -40, 912, 16},
    { -80, 888, 64},
    { -96, 912, 120},
    // 16 seconds
    { -72, 992, 184},
    { -40, 960, 192},
    { -88, 992, 272},
    { -24, 1552, 608},
    { 248, 1496, 464},
    { 344, 1408, 488},
    { 312, 1312, 472},
    { 296, 1008, 256},
    { 240, 736, 96},
    { 176, 536, 8},
    { 136, 520, -88},
    { 136, 680, -120},
    { 176, 936, -128},
    { 200, 912, -136},
    { 200, 816, -128},
    { 256, 728, -152},
    { 408, 648, -248},
    { 528, 624, -264},
    { 760, 728, -240},
    { 984, 512, -320},
    { 1336, 256, -480},
    { 1704, 320, -256},
    { 1480, 432, -88},
    { 1232, 544, -24},
    { 968, 736, -72},
    // 17 seconds
    { 792, 776, -72},
    { 768, 608, -64},
    { 744, 520, -160},
    { 736, 440, -232},
    { 632, 544, -304},
    { 672, 672, -440},
    { 792, 648, -368},
    { 1216, 712, -224},
    { 1280, 808, -296},
    { 1096, 776, -160},
    { 1368, 752, -112},
    { 1528, 688, -56},
    { 1400, 496, 8},
    { 1216, 352, 16},
    { 1032, 288, -16},
    { 944, 288, -8},
    { 872, 264, -16},
    { 800, 224, -32},
    { 752, 184, -24},
    { 832, 192, -104},
    { 872, 176, -128},
    { 960, 176, -288},
    { 1104, 120, -248},
    { 1016, 176, -368},
    { 1128, 232, -488},
    // 18 seconds
    { 1368, 248, -336},
    { 1200, 248, -256},
    { 984, 352, -216},
    { 888, 488, -240},
    { 864, 560, -200},
    { 832, 552, -240},
    { 800, 560, -320},
    { 824, 600, -392},
    { 776, 656, -480},
    { 832, 688, -464},
    { 936, 640, -336},
    { 1384, 688, -232},
    { 1336, 792, -328},
    { 1512, 672, -152},
    { 1592, 552, -56},
    { 1520, 456, -56},
    { 1280, 368, -48},
    { 1056, 312, -32},
    { 920, 280, -24},
    { 848, 232, -32},
    { 752, 200, -16},
    { 672, 248, -72},
    { 632, 160, -32},
    { 704, 136, -96},
    { 912, 216, -280},
    // 19 seconds
    { 1160, 176, -176},
    { 1120, 136, -304},
    { 1280, 184, -456},
    { 1368, 192, -224},
    { 1168, 224, -152},
    { 1032, 400, -336},
    { 984, 520, -432},
    { 872, 712, -216},
    { 880, 512, -304},
    { 856, 640, -344},
    { 856, 632, -448},
    { 856, 568, -432},
    { 824, 616, -432},
    { 880, 592, -328},
    { 1240, 680, -280},
    { 1280, 808, -280},
    { 1448, 848, -272},
    { 1688, 792, -200},
    { 1656, 576, -112},
    { 1416, 416, -72},
    { 1192, 328, -56},
    { 1016, 296, -16},
    { 888, 240, 24},
    { 744, 208, 40},
    { 624, 112, 56},
    // 20 seconds
    { 584, 104, -56},
    { 640, 152, -208},
    { 728, 112, -368},
    { 1016, 136, -312},
    { 1224, 96, -416},
    { 1304, 16, -448},
    { 1576, 176, -304},
    { 1496, 352, -296},
    { 1296, 488, -336},
    { 1104, 632, -240},
    { 896, 768, -240},
    { 848, 656, -264},
    { 792, 576, -288},
    { 736, 608, -264},
    { 720, 656, -296},
    { 792, 712, -224},
    { 1032, 768, -208},
    { 1464, 888, -320},
    { 1464, 792, -368},
    { 1560, 576, -288},
    { 1696, 480, -232},
    { 1480, 368, -240},
    { 1200, 272, -224},
    { 1040, 248, -200},
    { 928, 176, -144},
    // 21 seconds
    { 808, 144, -112},
    { 688, 104, -56},
    { 640, 48, -64},
    { 776, 24, -96},
    { 808, -32, -144},
    { 1040, 0, -104},
    { 1232, 176, -152},
    { 1416, 248, -448},
    { 1704, 456, -280},
    { 1504, 328, -368},
    { 1128, 280, -376},
    { 912, 320, -320},
    { 856, 320, -344},
    { 896, 344, -448},
    { 872, 368, -512},
    { 856, 440, -616},
    { 832, 496, -696},
    { 856, 528, -688},
    { 1240, 504, -512},
    { 1528, 584, -520},
    { 1408, 544, -512},
    { 1688, 432, -240},
    { 1696, 424, -112},
    { 1400, 336, -192},
    { 1128, 288, -168},
    // 22 seconds
    { 976, 272, -128},
    { 848, 192, -88},
    { 704, 56, -64},
    { 656, -8, -40},
    { 856, -24, -72},
    { 1048, -176, -64},
    { 976, -192, 88},
    { 1184, -32, 96},
    { 1360, 296, -136},
    { 1656, 384, -320},
    { 1824, 272, -32},
    { 1560, 352, 40},
    { 1224, 664, -288},
    { 800, 840, -384},
    { 696, 568, -184},
    { 696, 472, -288},
    { 688, 568, -296},
    { 736, 600, -472},
    { 792, 632, -560},
    { 864, 616, -496},
    { 1200, 608, -376},
    { 1672, 696, -400},
    { 1440, 608, -296},
    { 1544, 584, -216},
    { 1848, 552, -208},
    // 23 seconds
    { 1568, 464, -88},
    { 1136, 272, 24},
    { 968, 272, -8},
    { 896, 264, -16},
    { 896, 224, 8},
    { 864, 104, 56},
    { 832, 64, 88},
    { 848, 48, 40},
    { 824, 24, 8},
    { 864, -144, 104},
    { 1112, 144, 8},
    { 1744, 368, -416},
    { 1896, 296, -320},
    { 1656, 288, -72},
    { 1248, 544, -512},
    { 848, 600, -472},
    { 656, 472, -248},
    { 728, 400, -248},
    { 736, 440, -288},
    { 848, 512, -448},
    { 968, 592, -512},
    { 920, 640, -520},
    { 1000, 632, -400},
    { 1456, 656, -384},
    { 1360, 672, -456},
    // 24 seconds
    { 1656, 592, -280},
    { 1920, 528, -112},
    { 1816, 408, -176},
    { 1360, 368, -128},
    { 1008, 288, -72},
    { 816, 224, -40},
    { 704, 160, -40},
    { 656, 144, -40},
    { 632, 120, 16},
    { 736, 112, 8},
    { 760, 88, 48},
    { 784, 56, -128},
    { 1032, -456, -8},
    { 1520, 344, 40},
    { 1928, 544, -456},
    { 2096, 224, -656},
    { 1688, 864, -920},
    { 1080, 160, -344},
    { 832, 144, -336},
    { 688, 320, -408},
    { 576, 264, -336},
    { 584, 328, -400},
    { 648, 336, -392},
    { 736, 416, -424},
    { 880, 464, -376},
    // 25 seconds
    { 960, 632, -288},
    { 1384, 776, -344},
    { 1608, 728, -352},
    { 1688, 616, -328},
    { 1976, 448, -312},
    { 1752, 336, -192},
    { 1184, 272, -256},
    { 792, 264, -168},
    { 664, 240, -96},
    { 728, 144, -8},
    { 736, 104, 16},
    { 824, 112, -88},
    { 928, 120, -48},
    { 920, 104, 24},
    { 1168, 64, 40},
    { 1352, 96, 176},
    { 1480, 328, -32},
    { 1520, 336, -184},
    { 1544, 352, -184},
    { 1456, 504, -384},
    { 1216, 792, -336},
    { 888, 624, -440},
    { 616, 648, -448},
    { 456, 856, -480},
    { 440, 800, -424},
    // 26 seconds
    { 480, 688, -264},
    { 360, 744, -224},
    { 304, 808, -192},
    { 496, 944, -144},
    { 1152, 1320, -464},
    { 2392, 1296, -304},
    { 1816, 608, -216},
    { 1816, 512, -352},
    { 1008, 440, -288},
    { 648, 320, -240},
    { 520, 240, -152},
    { 560, 232, -120},
    { 648, 160, -88},
    { 760, 168, -24},
    { 776, 184, -48},
    { 760, 208, -40},
    { 1064, 168, -48},
    { 1440, 152, 40},
    { 1672, 296, -240},
    { 1632, 136, -184},
    { 1440, 328, -128},
    { 1200, 1064, -208},
    { 736, 1408, -376},
    { 440, 824, -208},
    { 464, 904, -280},
    // 27 seconds
    { 568, 864, -288},
    { 696, 696, -144},
    { 752, 696, -64},
    { 496, 824, -48},
    { 752, 832, 56},
    { 1240, 1056, 32},
    { 1752, 1232, 0},
    { 1728, 1040, 232},
    { 1552, 928, -64},
    { 1312, 984, -256},
    { 1040, 680, -144},
    { 832, 472, -32},
    { 648, 224, 152},
    { 528, -16, 304},
    { 632, 72, 304},
    { 768, 200, 80},
    { 808, 208, -32},
    { 1192, 464, -96},
    { 1408, 680, -192},
    { 1392, 1416, -360},
    { 1104, 1472, -176},
    { 576, 1624, 8},
    { 112, 1512, 88},
    { -40, 1176, 72},
    { -224, 1048, 184},
    // 28 seconds
    { -288, 872, 112},
    { -400, 560, 40},
    { -392, 408, -24},
    { -352, 504, -120},
    { -424, 536, 192},
    { -600, 1384, 440},
    { 128, 2568, 584},
    { 544, 2336, 448},
    { 704, 2368, 424},
    { 808, 1440, 240},
    { 592, 808, 56},
    { 448, 416, 144},
    { 392, 192, 40},
    { 352, 216, 0},
    { 448, 112, 0},
    { 528, 32, -24},
    { 624, 184, -24},
    { 904, 888, 16},
    { 1016, 2640, -232},
    { 880, 2648, -560},
    { 88, 1784, -304},
    { -56, 1368, -40},
    { -152, 984, -120},
    { -272, 584, -176},
    { -336, 304, -104},
    // 29 seconds
    { -352, 16, -144},
    { -240, 104, -152},
    { -328, 184, 0},
    { -792, 1168, 136},
    { -576, 2920, 320},
    { 280, 3512, 88},
    { 656, 2424, 120},
    { 808, 1168, 88},
    { 624, 600, 0},
    { 408, 160, 64},
    { 360, 24, 72},
    { 328, 16, 128},
    { 408, 128, 40},
    { 520, 168, 0},
    { 792, 352, -144},
    { 1040, 1664, -112},
    { 1248, 2584, -360},
    { 528, 2088, -600},
    { 232, 1640, -272},
    { 208, 1112, 8},
    { -144, 720, 128},
    { -496, 600, 24},
    { -424, 336, -160},
    { -432, 296, -120},
    { -456, 368, -96},
    // 30 seconds
    { -560, 552, 56},
    { -616, 1584, 88},
    { -264, 2568, 296},
    { 368, 3016, 64},
    { 1136, 2360, -40},
    { 1320, 1072, 96},
    { 808, 496, 72},
    { 416, 248, 8},
    { 320, 96, 96},
    { 480, -16, 200},
    { 752, -104, 208},
    { 792, -400, -8},
    { 1096, 504, 480},
    { 1360, 2448, 464},
    { 1240, 2872, 64},
    { 392, 2000, 264},
    { 208, 1176, 504},
    { 40, 992, 248},
    { -128, 624, 176},
    { -248, 416, 48},
    { -280, 168, 24},
    { -344, -16, 48},
    { -288, 272, 96},
    { -216, 1408, 504},
    { 240, 2648, 696},
    // 31 seconds
    { 696, 2896, 904},
    { 904, 2312, 656},
    { 1032, 1560, 408},
    { 896, 648, 312},
    { 544, 264, 200},
    { 472, 176, 80},
    { 592, 80, 112},
    { 608, 32, 88},
    { 680, 32, 0},
    { 768, 152, 24},
    { 960, 984, 360},
    { 1160, 2368, 320},
    { 664, 2432, 320},
    { 160, 1872, 400},
    { -24, 1392, 264},
    { -272, 928, 128},
    { -384, 488, 0},
    { -408, 352, -112},
    { -376, 176, -136},
    { -336, 336, -88},
    { -432, 480, 56},
    { -792, 1968, 696},
    { -216, 3096, 936},
    { 400, 3048, 1064},
    { 640, 1984, 648},
    // 32 seconds
    { 816, 976, 392},
    { 640, 472, 248},
    { 464, 176, 208},
    { 504, 136, 240},
    { 576, 80, 216},
    { 608, 104, 40},
    { 648, 64, -32},
    { 736, 152, -24},
    { 456, 2128, 400},
    { 904, 3016, 384},
    { 264, 2448, -128},
    { -128, 1376, 200},
    { -160, 976, 136},
    { -232, 728, 48},
    { -232, 552, 128},
    { -304, 576, 256},
    { -256, 424, -88},
    { -240, 328, -144},
    { -472, 544, -120},
    { -792, 2200, 160},
    { -96, 3128, 712},
    { 216, 2864, 264},
    { 320, 1600, 280},
    { 544, 680, 240},
    { 416, 184, 120},
    // 33 seconds
    { 224, 104, 72},
    { 280, 56, 168},
    { 472, 0, 152},
    { 552, 8, -64},
    { 920, 208, -176},
    { 1144, 1216, 392},
    { 848, 3288, 664},
    { 456, 2744, -56},
    { -16, 1840, 816},
    { -240, 984, 520},
    { -264, 712, 328},
    { -312, 480, 272},
    { -368, 312, 152},
    { -400, 232, 72},
    { -440, 504, 168},
    { -600, 896, 240},
    { -360, 2112, 536},
    { 128, 2424, 456},
    { 160, 2448, 600},
    { 336, 2128, 440},
    { 400, 1448, 296},
    { 320, 808, 104},
    { 376, 320, 152},
    { 368, 64, 144},
    { 448, -72, 112},
    // 34 seconds
    { 504, -120, 40},
    { 536, -8, -56},
    { 616, 616, 296},
    { 888, 2536, 248},
    { 376, 2976, 144},
    { 8, 2112, 48},
    { -200, 1472, -40},
    { -256, 1224, -40},
    { -208, 984, -368},
    { 136, 696, -384},
    { -480, 248, -176},
    { -888, -184, -96},
    { -760, -152, 24},
    { -856, 280, 8},
    { -576, 2824, 144},
    { 632, 3848, -232},
    { 792, 2784, -152},
    { 784, 1144, -72},
    { 600, 376, 8},
    { 520, 144, 0},
    { 432, 24, 48},
    { 464, 24, 128},
    { 624, 72, 8},
    { 752, 128, -136},
    { 1056, 472, -256},
    // 35 seconds
    { 1160, 2048, -264},
    { 1320, 2816, -712},
    { 528, 2056, -520},
    { 112, 1384, -224},
    { 32, 1008, -240},
    { -80, 752, -272},
    { -80, 648, -320},
    { -176, 432, -368},
    { -312, 240, -408},
    { -272, 176, -296},
    { -440, 408, -48},
    { -608, 2320, -240},
    { 440, 3344, -280},
    { 1264, 2800, -248},
    { 792, 1344, -216},
    { 688, 680, -136},
    { 528, 272, -56},
    { 336, 176, -16},
    { 416, 144, 48},
    { 504, 160, 16},
    { 624, 176, 32},
    { 640, 112, -16},
    { 848, 544, -168},
    { 1048, 2056, 80},
    { 1176, 2296, -344},
    // 36 seconds
    { 832, 2200, -576},
    { 392, 1312, 56},
    { 224, 1008, 112},
    { 152, 952, 128},
    { -104, 1128, 152},
    { -360, 896, -88},
    { -504, 616, -256},
    { -496, 384, -264},
    { -400, 416, -96},
    { -408, 672, 152},
    { -112, 2384, 296},
    { 784, 2856, -128},
    { 528, 2296, -408},
    { 280, 1488, -432},
    { 272, 904, -144},
    { 328, 448, -48},
    { 352, 272, -72},
    { 416, 232, 8},
    { 408, 240, 120},
    { 448, 248, 16},
    { 520, 168, -64},
    { 760, 448, -168},
    { 800, 1344, -160},
    { 1040, 2240, -760},
    { 680, 2280, -776},
    // 37 seconds
    { 312, 1656, -440},
    { 32, 1152, -128},
    { 40, 936, -312},
    { 24, 688, -312},
    { -72, 512, -224},
    { -96, 512, -328},
    { -152, 408, -464},
    { -224, 328, -344},
    { -136, 504, -216},
    { 200, 1440, -304},
    { 1208, 1464, -480},
    { 1584, 2320, -736},
    { 1264, 1416, -432},
    { 1008, 792, -280},
    { 904, 416, -208},
    { 752, 240, -16},
    { 648, 160, 32},
    { 680, 120, 40},
    { 608, 64, 128},
    { 672, -144, 288},
    { 888, -160, 288},
    { 1592, 184, 376},
    { 2024, 608, -8},
    { 2176, 1128, -440},
    { 1944, 1872, -232},
    // 38 seconds
    { 1184, 1368, -104},
    { 680, 1136, 24},
    { 432, 1064, -16},
    { 184, 760, 56},
    { -160, 616, -120},
    { -480, 392, 64},
    { -480, 424, -152},
    { -368, 728, 32},
    { 184, 1704, 272},
    { 1680, 2584, 184},
    { 1832, 2088, -80},
    { 1888, 1032, 80},
    { 1528, 544, 96},
    { 1160, 352, 8},
    { 904, 208, -24},
    { 704, 64, 128},
    { 672, 64, 216},
    { 496, 80, 152},
    { 512, 24, 88},
    { 840, 104, 16},
    { 1384, 944, 256},
    { 1536, 1976, -152},
    { 1304, 1344, -592},
    { 808, 1144, 32},
    { 392, 1240, 136},
    // 39 seconds
    { 296, 1200, 40},
    { 72, 1024, -8},
    { -136, 712, 8},
    { -264, 424, -48},
    { -256, 296, -144},
    { -216, 392, -64},
    { -360, 752, -128},
    { 312, 2280, 32},
    { 952, 2552, 104},
    { 816, 1896, 256},
    { 560, 1280, 344},
    { 472, 600, 184},
    { 296, 288, 184},
    { 224, 216, 104},
    { 288, 160, 128},
    { 448, 352, 152},
    { 648, 288, 144},
    { 832, 400, 56},
    { 1200, 936, 240},
    { 1464, 2032, 312},
    { 1112, 2112, -320},
    { 544, 1576, 96},
    { 200, 1152, 112},
    { 0, 1136, -48},
    { -72, 928, -40},
    // 40 seconds
    { -136, 728, -40},
    { -224, 608, -64},
    { -248, 448, -72},
    { -224, 416, -128},
    { -192, 632, -96},
    { 96, 1392, -72},
    { 776, 1824, -8},
    { 944, 1824, 24},
    { 1024, 1720, -48},
    { 952, 1368, 112},
    { 648, 864, -56},
    { 416, 496, -120},
    { 344, 320, -64},
    { 424, 256, -88},
    { 504, 232, -64},
    { 688, 248, -40},
    { 816, 320, -56},
    { 1248, 520, -128},
    { 1600, 1064, 128},
    { 1536, 1504, -376},
    { 1072, 1224, -392},
    { 672, 1120, -24},
    { 336, 1072, -112},
    { 176, 976, -144},
    { 80, 872, -144},
    // 41 seconds
    { 64, 920, -152},
    { 56, 888, -248},
    { 96, 936, -344},
    { -72, 816, -248},
    { -120, 712, -152},
    { -56, 1128, -264},
    { 448, 1992, -408},
    { 760, 2168, -576},
    { 1048, 1896, -432},
    { 848, 1376, -264},
    { 664, 936, -200},
    { 472, 608, -120},
    { 384, 472, -96},
    { 472, 368, -120},
    { 488, 256, -72},
    { 600, 184, -176},
    { 656, 104, -88},
    { 752, 104, -192},
    { 904, 512, -168},
    { 1176, 1296, -552},
    { 1352, 1800, -1056},
    { 952, 1736, -784},
    { 496, 1368, -672},
    { 216, 960, -496},
    { 48, 744, -320},
    // 42 seconds
    { -24, 704, -256},
    { -48, 720, -216},
    { -96, 792, -328},
    { -96, 768, -248},
    { -80, 848, -256},
    { 48, 1200, -264},
    { 648, 1880, -248},
    { 1016, 1952, -384},
    { 1112, 1648, -272},
    { 1040, 1192, -272},
    { 784, 760, -320},
    { 432, 416, -168},
    { 232, 376, -136},
    { 352, 312, -128},
    { 352, 352, -96},
    { 488, 360, -80},
    { 664, 424, -72},
    { 784, 352, -72},
    { 1176, 768, -56},
    { 1352, 1312, -296},
    { 1424, 1408, -632},
    { 880, 1216, -320},
    { 448, 1056, -288},
    { 224, 1000, -320},
    { 56, 864, -256},
    // 43 seconds
    { 32, 776, -160},
    { 32, 776, -72},
    { 40, 776, -40},
    { 0, 744, -72},
    { 8, 840, -104},
    { 32, 1056, -96},
    { 128, 1544, -152},
    { 672, 1960, -104},
    { 976, 1952, -88},
    { 784, 1456, -104},
    { 608, 976, -80},
    { 480, 632, -88},
    { 376, 392, -96},
    { 312, 304, -56},
    { 392, 328, -56},
    { 520, 328, -48},
    { 640, 336, -8},
    { 752, 440, -40},
    { 1032, 624, -168},
    { 1152, 1064, -256},
    { 1264, 1256, -712},
    { 1040, 1184, -720},
    { 736, 1040, -608},
    { 440, 968, -480},
    { 232, 904, -368},
    // 44 seconds
    { 96, 784, -240},
    { 64, 752, -160},
    { 48, 792, -192},
    { 24, 792, -256},
    { 8, 792, -288},
    { 80, 864, -264},
    { 280, 1392, -192},
    { 752, 1824, -256},
    { 1016, 1848, -312},
    { 888, 1624, -136},
    { 800, 1312, -88},
    { 640, 904, -192},
    { 496, 600, -216},
    { 408, 376, -128},
    { 472, 304, -176},
    { 488, 256, -208},
    { 576, 256, -256},
    { 592, 248, -168},
    { 712, 320, -128},
    { 1056, 664, -48},
    { 1216, 1280, -216},
    { 1312, 1416, -536},
    { 976, 1416, -392},
    { 552, 1160, -440},
    { 288, 976, -520},
    // 45 seconds
    { 120, 760, -360},
    { 56, 648, -232},
    { 40, 704, -176},
    { 16, 816, -160},
    { -8, 912, -112},
    { 16, 1024, -184},
    { 72, 1040, -184},
    { 160, 1312, -360},
    { 560, 1760, -480},
    { 1168, 1872, -592},
    { 1040, 1520, -368},
    { 728, 1048, -248},
    { 488, 680, -184},
    { 352, 472, -144},
    { 336, 360, -104},
    { 384, 344, -56},
    { 528, 392, -128},
    { 608, 408, -104},
    { 672, 368, -104},
    { 736, 296, -160},
    { 904, 384, -152},
    { 1128, 680, -296},
    { 1480, 1160, -512},
    { 1288, 1568, -440},
    { 816, 1792, -528},
    // 46 seconds
    { 432, 1456, -512},
    { 104, 1096, -280},
    { -32, 856, -184},
    { -40, 824, -240},
    { -112, 728, -304},
    { -136, 528, -280},
    { -144, 512, -304},
    { -136, 696, -248},
    { -104, 1560, -184},
    { 760, 2768, -328},
    { 1072, 2624, -264},
    { 1136, 1624, -200},
    { 1000, 928, -72},
    { 720, 432, -32},
    { 496, 224, 32},
    { 472, 112, 112},
    { 448, 64, 152},
    { 480, 16, 184},
    { 352, 24, 64},
    { 584, 304, -272},
    { 992, 1320, -264},
    { 1992, 2104, -736},
    { 1208, 1808, -792},
    { 448, 1240, -312},
    { 288, 1104, -336},
    // 47 seconds
    { 88, 856, -344},
    { -144, 568, -232},
    { -240, 392, -208},
    { -344, 360, -344},
    { -480, 440, -352},
    { -504, 936, -208},
    { -80, 2128, -440},
    { 816, 2624, -888},
    { 1128, 2248, -600},
    { 1144, 1520, -392},
    { 760, 776, -208},
    { 592, 400, -168},
    { 536, 192, -56},
    { 544, 144, 40},
    { 432, 128, 64},
    { 360, 152, -8},
    { 576, 224, -96},
    { 1136, 504, -168},
    { 1560, 1224, -176},
    { 1616, 1704, -520},
    { 1048, 1904, -432},
    { 400, 1600, -336},
    { -8, 1328, -304},
    { -208, 1000, -152},
    { -256, 864, -160},
    // 48 seconds
    { -304, 840, -216},
    { -336, 640, -240},
    { -264, 608, -208},
    { -152, 760, -136},
    { -144, 1192, -64},
    { 464, 2272, 8},
    { 896, 2520, -256},
    { 1040, 2120, -144},
    { 800, 1344, -72},
    { 520, 688, -136},
    { 416, 352, -72},
    { 352, 256, -32},
    { 472, 200, -32},
    { 512, 200, 32},
    { 672, 224, 40},
    { 816, 240, -32},
    { 1240, 592, 120},
    { 1216, 1640, 0},
    { 1232, 2008, -472},
    { 816, 1880, -280},
    { 328, 1464, -120},
    { 112, 1200, -120},
    { -48, 1008, -96},
    { -136, 904, -32},
    { -200, 816, -48},
    // 49 seconds
    { -304, 752, -64},
    { -368, 648, -72},
    { -352, 688, 8},
    { -384, 1104, 168},
    { 160, 2216, 304},
    { 824, 2456, 56},
    { 656, 2056, 112},
    { 1000, 1560, 80},
    { 664, 784, 8},
    { 520, 424, -96},
    { 504, 216, -40},
    { 528, 216, -8},
    { 456, 200, 24},
    { 512, 296, 0},
    { 576, 384, -8},
    { 888, 696, 40},
    { 984, 1264, 136},
    { 1240, 1912, -400},
    { 872, 1688, -216},
    { 416, 1520, -88},
    { 176, 1240, -272},
    { 8, 952, -200},
    { -96, 872, -104},
    { -152, 848, -96},
    { -208, 760, -128},
    // 50 seconds
    { -248, 712, -80},
    { -232, 800, -96},
    { -248, 888, -48},
    { -248, 1864, 0},
    { 416, 2160, 16},
    { 488, 2120, -128},
    { 648, 1784, 0},
    { 536, 1144, 40},
    { 416, 664, -40},
    { 248, 328, 0},
    { 216, 216, 16},
    { 264, 200, 24},
    { 368, 296, 16},
    { 544, 464, 56},
    { 856, 632, -8},
    { 1144, 920, -120},
    { 1008, 1448, 16},
    { 912, 1696, -528},
    { 592, 1696, -448},
    { 296, 1504, -328},
    { 48, 1240, -280},
    { -64, 936, -216},
    { -80, 728, -192},
    { -128, 680, -152},
    { -208, 656, -88},
    // 51 seconds
    { -216, 680, -56},
    { -208, 784, -96},
    { -160, 1096, -64},
    { 240, 2160, 64},
    { 696, 2240, -200},
    { 856, 1968, -216},
    { 888, 1384, 0},
    { 632, 840, 0},
    { 384, 544, -112},
    { 368, 392, -56},
    { 368, 328, -40},
    { 400, 320, -16},
    { 416, 368, 0},
    { 536, 560, 32},
    { 616, 504, 64},
    { 896, 472, 48},
    { 1112, 1152, 240},
    { 1616, 1752, -408},
    { 1128, 1872, -400},
    { 448, 1456, -232},
    { 72, 1232, -224},
    { -56, 904, -224},
    { -120, 880, -264},
    { -128, 664, -224},
    { -144, 728, -96},
    // 52 seconds
    { -152, 696, 64},
    { -104, 776, 128},
    { 0, 1144, 368},
    { 240, 2104, 640},
    { 840, 2240, 448},
    { 792, 1784, 232},
    { 720, 1432, 360},
    { 560, 1008, 264},
    { 384, 656, 64},
    { 280, 400, -56},
    { 208, 296, 0},
    { 304, 376, 88},
    { 536, 488, 56},
    { 728, 640, 136},
    { 576, 512, 24},
    { 624, 632, -16},
    { 792, 1232, 184},
    { 1128, 1600, -208},
    { 968, 1592, -208},
    { 608, 1432, -48},
    { 208, 1192, -152},
    { 72, 1016, -120},
    { -48, 856, -72},
    { -112, 792, -104},
    { -176, 760, -192},
    // 53 seconds
    { -256, 632, -48},
    { -256, 768, 136},
    { -80, 1104, 240},
    { 200, 1704, 440},
    { 688, 2080, 560},
    { 864, 1872, 504},
    { 720, 1568, 448},
    { 760, 1264, 344},
    { 568, 808, 176},
    { 424, 520, 48},
    { 328, 344, 80},
    { 320, 344, 40},
    { 424, 368, 40},
    { 552, 448, 40},
    { 600, 392, 32},
    { 824, 488, -32},
    { 1040, 1008, 240},
    { 1112, 1584, -112},
    { 1024, 1608, -216},
    { 664, 1488, 64},
    { 280, 1232, 0},
    { 128, 1024, -8},
    { -16, 840, 40},
    { -72, 752, 88},
    { -96, 792, 64},
    // 54 seconds
    { -152, 856, 48},
    { -208, 856, 40},
    { -160, 944, 48},
    { -88, 1080, 256},
    { 248, 2024, 680},
    { 872, 2056, 240},
    { 776, 1704, 368},
    { 616, 1336, 352},
    { 480, 952, 192},
    { 344, 608, 112},
    { 248, 472, 64},
    { 272, 432, 64},
    { 360, 448, 56},
    { 424, 536, 32},
    { 496, 384, -8},
    { 656, 504, -16},
    { 1280, 864, -96},
    { 1176, 1256, 40},
    { 1120, 1344, -416},
    { 896, 1272, -152},
    { 624, 1256, 136},
    { 320, 1184, 80},
    { 184, 1040, 128},
    { 56, 928, 224},
    { -64, 928, 232},
    // 55 seconds
    { -136, 872, 248},
    { -216, 824, 272},
    { -224, 816, 280},
    { -152, 968, 304},
    { 0, 1360, 416},
    { 480, 1824, 488},
    { 728, 1920, 304},
    { 1016, 1752, 304},
    { 856, 1384, 312},
    { 696, 1000, 184},
    { 504, 672, 80},
    { 352, 488, 56},
    { 352, 408, 40},
    { 456, 368, 24},
    { 584, 408, -24},
    { 640, 400, -8},
    { 704, 328, 0},
    { 1024, 496, 0},
    { 1120, 1304, 248},
    { 1344, 1656, -280},
    { 1000, 1648, -184},
    { 520, 1336, -24},
    { 232, 1104, -72},
    { 112, 888, -72},
    { 0, 752, -8},
    // 56 seconds
    { 0, 736, 16},
    { -56, 816, -16},
    { -72, 880, -8},
    { -96, 928, -40},
    { -40, 992, -24},
    { 0, 1088, 72},
    { 224, 1824, 320},
    { 648, 2136, 40},
    { 944, 1968, 240},
    { 824, 1608, 192},
    { 696, 1088, 72},
    { 496, 608, 0},
    { 336, 368, -8},
    { 304, 272, 40},
    { 360, 296, -24},
    { 392, 360, -32},
    { 520, 456, -40},
    { 600, 488, -40},
    { 832, 736, -88},
    { 1000, 1184, 72},
    { 1256, 1512, -168},
    { 1088, 1496, -96},
    { 608, 1456, 112},
    { 352, 1264, 104},
    { 104, 1016, -112},
    // 57 seconds
    { 0, 896, 8},
    { -64, 800, -248},
    { -96, 968, 96},
    { -240, 840, 400},
    { -184, 992, 320},
    { -80, 1008, 512},
    { 160, 1416, 736},
    { 512, 1728, 632},
    { 544, 1904, 520},
    { 688, 1864, 496},
    { 792, 1640, 392},
    { 720, 1112, 256},
    { 520, 544, 32},
    { 360, 256, 24},
    { 312, 168, 0},
    { 408, 296, -32},
    { 568, 440, -16},
    { 744, 448, 40},
    { 672, 376, -64},
    { 912, 616, 0},
    { 992, 1336, 144},
    { 1200, 1728, -200},
    { 896, 1656, -168},
    { 496, 1384, -104},
    { 232, 1120, -328},
    // 58 seconds
    { 72, 848, -184},
    { -8, 712, -32},
    { -8, 784, 32},
    { -40, 840, 160},
    { -56, 888, 208},
    { -56, 904, 160},
    { -16, 1016, 296},
    { 264, 1904, 480},
    { 824, 2064, 200},
    { 920, 1728, 208},
    { 744, 1416, 256},
    { 640, 1160, 152},
    { 504, 784, 56},
    { 360, 536, 16},
    { 288, 400, 8},
    { 360, 368, -24},
    { 456, 320, -56},
    { 624, 392, 0},
    { 632, 368, 64},
    { 832, 520, -24},
    { 864, 808, 256},
    { 872, 1184, -192},
    { 1128, 1712, -224},
    { 1024, 1768, 24},
    { 512, 1376, -80},
    // 59 seconds
    { 208, 976, -96},
    { 112, 704, -32},
    { 0, 592, -24},
    { -16, 552, -72},
    { -72, 656, 0},
    { -8, 912, -8},
    { 56, 1280, 32},
    { 304, 1488, 248},
    { 600, 1768, 400},
    { 752, 1688, 208},
    { 816, 1592, 320},
    { 816, 1376, 336},
    { 656, 1000, 160},
    { 464, 616, 24},
    { 336, 408, 48},
    { 344, 392, 64},
    { 408, 392, 16},
    { 480, 424, -56},
    { 616, 440, -40},
    { 672, 464, -64},
    { 920, 680, -56},
    { 936, 1304, -8},
    { 1120, 1464, -336},
    { 896, 1424, -160},
    { 464, 1192, -32},
    // 60 seconds
    // elapsed: 1 minutes
    { 248, 1000, -104},
    { 104, 864, -64},
    { 40, 720, -8},
    { 0, 752, 16},
    { 8, 824, 24},
    { 32, 872, -8},
    { 72, 992, -40},
    { 96, 1152, 32},
    { 304, 1832, 240},
    { 504, 1688, 64},
    { 640, 1632, 80},
    { 832, 1376, 48},
    { 736, 904, -88},
    { 488, 536, -96},
    { 296, 328, -64},
    { 304, 232, -104},
    { 416, 216, -112},
    { 552, 248, -32},
    { 744, 264, 0},
    { 880, 296, 104},
    { 1240, 344, 56},
    { 1856, 688, 392},
    { 1824, 1152, 136},
    { 1808, 1216, -104},
    { 1288, 1200, 40},
    // 61 seconds
    { 664, 1136, -56},
    { 312, 992, -24},
    { 120, 896, 88},
    { 96, 856, 88},
    { 104, 848, 112},
    { 80, 824, 64},
    { 8, 752, 16},
    { 32, 784, 48},
    { 136, 936, 184},
    { 352, 1816, 360},
    { 1216, 2056, 256},
    { 1320, 1816, 88},
    { 1304, 1304, 200},
    { 896, 848, 104},
    { 656, 632, -16},
    { 440, 416, 8},
    { 408, 408, -80},
    { 424, 336, -32},
    { 504, 336, -32},
    { 568, 336, -56},
    { 648, 312, 8},
    { 800, 520, -72},
    { 1248, 824, 40},
    { 1280, 1496, 112},
    { 1232, 1792, -160},
    // 62 seconds
    { 904, 1672, -24},
    { 392, 1192, -24},
    { 120, 944, -16},
    { -8, 744, 8},
    { -64, 704, 24},
    { -104, 720, 56},
    { -88, 816, 96},
    { -64, 800, 64},
    { -40, 784, 16},
    { 128, 920, 64},
    { 456, 1520, 232},
    { 976, 1976, 32},
    { 1136, 1704, 64},
    { 1032, 1344, -24},
    { 680, 984, -128},
    { 456, 816, -232},
    { 320, 664, -208},
    { 224, 560, -176},
    { 176, 480, -120},
    { 128, 528, -120},
    { 144, 552, -104},
    { 208, 520, -80},
    { 392, 744, -56},
    { 552, 920, 24},
    { 920, 1256, 128},
    // 63 seconds
    { 1096, 1432, 88},
    { 1200, 1456, -8},
    { 776, 1280, 256},
    { 320, 1104, 136},
    { 88, 920, 96},
    { -32, 736, 96},
    { -8, 680, 56},
    { 0, 688, 88},
    { 0, 744, 96},
    { 0, 832, 72},
    { 0, 840, 48},
    { -32, 856, 64},
    { -128, 1040, 104},
    { -8, 1920, 192},
    { 592, 2248, 0},
    { 744, 1992, -56},
    { 840, 1472, 40},
    { 544, 960, 0},
    { 368, 600, -88},
    { 272, 376, -48},
    { 224, 296, -64},
    { 152, 352, -56},
    { 208, 448, -96},
    { 296, 592, -128},
    { 424, 696, -24},
    // 64 seconds
    { 608, 1096, -48},
    { 768, 1408, 16},
    { 752, 1792, -48},
    { 696, 1704, -128},
    { 400, 1392, -112},
    { 96, 1000, -104},
    { 8, 792, -24},
    { -16, 776, 16},
    { 0, 720, -8},
    { 32, 632, -8},
    { -40, 520, -16},
    { -200, 648, -136},
    { -336, 728, -168},
    { -368, 1152, -104},
    { -208, 1896, 8},
    { 64, 2120, -64},
    { 296, 2112, 80},
    { 392, 1752, 48},
    { 448, 1056, -32},
    { 288, 520, -120},
    { 216, 368, -88},
    { 192, 328, -56},
    { 256, 472, -120},
    { 408, 648, -32},
    { 496, 608, 8},
    // 65 seconds
    { 432, 800, -32},
    { 488, 1128, -32},
    { 568, 1808, 64},
    { 432, 1608, -216},
    { 160, 1768, -384},
    { -88, 1400, -488},
    { -232, 1200, -432},
    { -296, 808, -248},
    { -328, 600, -240},
    { -352, 560, -160},
    { -376, 616, -64},
    { -392, 776, -88},
    { -400, 520, -72},
    { -448, 592, 40},
    { -696, 928, 56},
    { -528, 2608, 240},
    { -72, 2320, 128},
    { 24, 2336, 184},
    { 176, 1384, 64},
    { 224, 944, -48},
    { 248, 448, 0},
    { 136, 264, 16},
    { 128, 168, -32},
    { 72, 464, -352},
    { 96, 952, -480},
    // 66 seconds
    { 352, 208, -352},
    { 232, 632, -248},
    { 296, 1480, -448},
    { 64, 1856, -328},
    { -424, 1664, -480},
    { -512, 1296, -384},
    { -392, 936, -416},
    { -344, 640, -344},
    { -368, 544, -208},
    { -592, 560, -144},
    { -728, 520, -296},
    { -648, 328, -280},
    { -792, 624, -240},
    { -720, 1416, -544},
    { -472, 2272, -600},
    { -96, 2456, -744},
    { 120, 1584, -696},
    { 184, 760, -304},
    { 184, 344, -208},
    { 240, 176, -120},
    { 336, 128, -16},
    { 496, 144, -152},
    { 632, 232, -168},
    { 736, 456, -224},
    { 312, 1872, -288},
    // 67 seconds
    { 272, 2608, -600},
    { 8, 2048, -640},
    { -376, 1472, -288},
    { -208, 1048, -280},
    { -176, 784, -288},
    { -240, 512, -248},
    { -216, 400, -408},
    { -216, 264, -480},
    { -320, -40, -96},
    { -976, 24, 136},
    { -928, 2112, -224},
    { -632, 2968, -496},
    { -256, 2504, -336},
    { 272, 1776, -368},
    { 576, 952, -200},
    { 360, 472, -104},
    { 400, 376, -152},
    { 424, 248, -80},
    { 536, 256, -264},
    { 624, 336, -264},
    { 864, 312, -288},
    { 568, 1376, -416},
    { 600, 2104, -768},
    { 120, 2096, -864},
    { -200, 1488, -472},
    // 68 seconds
    { -176, 1088, -408},
    { -232, 752, -256},
    { -288, 536, -160},
    { -336, 408, -120},
    { -336, 336, -168},
    { -328, 360, -144},
    { -464, 504, -88},
    { -856, 1584, 0},
    { -504, 2912, -120},
    { 64, 2552, -24},
    { 144, 1864, -104},
    { 416, 1048, -96},
    { 296, 496, -40},
    { 200, 368, 0},
    { 256, 312, 0},
    { 320, 264, -32},
    { 360, 280, -32},
    { 440, 552, -88},
    { 712, 776, -224},
    { 408, 1640, -88},
    { 472, 2208, -504},
    { 280, 1872, -592},
    { -8, 1400, -304},
    { -184, 1016, -216},
    { -200, 800, -208},
    // 69 seconds
    { -256, 648, -136},
    { -232, 576, -72},
    { -272, 536, -64},
    { -272, 544, -80},
    { -304, 576, -48},
    { -512, 968, 72},
    { -504, 2432, 160},
    { 216, 2744, -40},
    { 320, 2064, 16},
    { 328, 1384, 0},
    { 248, 904, 0},
    { 192, 568, -8},
    { 200, 384, -24},
    { 232, 304, -48},
    { 360, 344, -136},
    { 392, 448, -64},
    { 496, 816, -48},
    { 648, 944, -184},
    { 512, 1392, -48},
    { 368, 1768, -248},
    { 144, 1720, -224},
    { -80, 1648, -184},
    { -200, 1192, -168},
    { -208, 824, -128},
    { -240, 672, -136},
    // 70 seconds
    { -272, 608, -96},
    { -264, 592, -56},
    { -312, 568, -120},
    { -400, 632, -120},
    { -680, 1040, 24},
    { -424, 2312, 120},
    { -120, 2272, -136},
    { 88, 2072, 16},
    { 328, 1304, 16},
    { 336, 920, -24},
    { 232, 512, 40},
    { 176, 376, 0},
    { 256, 320, -80},
    { 416, 368, -152},
    { 552, 504, -176},
    { 616, 528, -176},
    { 648, 584, -296},
    { 688, 1064, -192},
    { 824, 1752, -368},
    { 912, 1992, -648},
    { 656, 1624, -424},
    { 240, 1144, -248},
    { -8, 1000, -184},
    { -136, 864, -152},
    { -256, 768, -88},
    // 71 seconds
    { -312, 728, -40},
    { -416, 728, -64},
    { -456, 784, -80},
    { -368, 920, -120},
    { -320, 1184, -16},
    { -176, 2352, -40},
    { 296, 2456, -248},
    { 616, 2152, -208},
    { 600, 1656, -152},
    { 560, 1072, -136},
    { 392, 608, -24},
    { 256, 376, -48},
    { 240, 288, -96},
    { 312, 232, -168},
    { 368, 192, -168},
    { 416, 264, -312},
    { 544, 416, -336},
    { 872, 744, -376},
    { 928, 1496, -200},
    { 944, 2000, -712},
    { 592, 1608, -568},
    { 304, 1496, -248},
    { 88, 1312, -240},
    { -56, 1048, -192},
    { -208, 928, -104},
    // 72 seconds
    { -304, 840, -40},
    { -376, 840, -112},
    { -416, 936, -136},
    { -336, 904, -192},
    { -296, 888, -88},
    { -240, 1496, 16},
    { 296, 2296, 136},
    { 600, 1928, -96},
    { 384, 1736, -128},
    { 472, 1376, -104},
    { 472, 960, -128},
    { 344, 568, -120},
    { 240, 448, -128},
    { 280, 408, -136},
    { 376, 456, -120},
    { 456, 560, -208},
    { 576, 432, -152},
    { 680, 496, -272},
    { 896, 896, -240},
    { 952, 1680, -432},
    { 912, 1744, -704},
    { 512, 1512, -376},
    { 200, 1280, -248},
    { 56, 1048, -208},
    { -80, 832, -112},
    // 73 seconds
    { -168, 760, -40},
    { -224, 744, -8},
    { -320, 816, -40},
    { -296, 1008, -80},
    { -200, 1072, -112},
    { -80, 1192, -104},
    { -48, 1568, -120},
    { 208, 1632, -80},
    { 328, 1824, -208},
    { 576, 1760, -96},
    { 560, 1392, -56},
    { 456, 960, -72},
    { 336, 600, -32},
    { 248, 368, -16},
    { 240, 504, -88},
    { 408, 624, -104},
    { 624, 688, -208},
    { 824, 440, -208},
    { 744, 416, -312},
    { 888, 544, -432},
    { 840, 1128, -432},
    { 832, 1256, -688},
    { 672, 1288, -592},
    { 408, 1216, -432},
    { 136, 944, -320},
    // 74 seconds
    { -32, 840, -296},
    { -88, 760, -256},
    { -120, 800, -296},
    { -96, 888, -336},
    { -48, 912, -368},
    { -48, 960, -392},
    { -16, 1032, -432},
    { 96, 1104, -376},
    { 224, 1496, -344},
    { 392, 1648, -360},
    { 472, 1576, -296},
    { 512, 1552, -216},
    { 480, 1192, -144},
    { 384, 720, -176},
    { 280, 480, -232},
    { 184, 352, -328},
    { 184, 336, -560},
    { 184, 568, -480},
    { 304, 568, -288},
    { 384, 496, -456},
    { 448, 544, -360},
    { 672, 760, -488},
    { 800, 896, -640},
    { 896, 968, -696},
    { 752, 1000, -744},
    // 75 seconds
    { 504, 976, -584},
    { 264, 952, -536},
    { 88, 776, -464},
    { -16, 688, -352},
    { -48, 704, -320},
    { -96, 904, -384},
    { -80, 1184, -424},
    { -72, 1088, -288},
    { -72, 1168, -304},
    { 16, 1168, -216},
    { 8, 1272, -24},
    { 24, 1656, -8},
    { 320, 1912, -88},
    { 616, 1736, -24},
    { 584, 1368, -8},
    { 448, 920, 8},
    { 312, 656, -8},
    { 216, 496, -88},
    { 168, 392, -88},
    { 192, 392, -136},
    { 216, 488, -88},
    { 392, 768, -216},
    { 504, 672, -184},
    { 656, 832, -328},
    { 648, 1368, -88},
    // 76 seconds
    { 656, 1880, -248},
    { 744, 1128, 24},
    { 352, 1000, 136},
    { 104, 912, 120},
    { 16, 744, 120},
    { -16, 728, 80},
    { -80, 728, 64},
    { -88, 760, 24},
    { -144, 1016, -56},
    { -248, 1096, 16},
    { -280, 1168, 112},
    { -184, 1240, 176},
    { -136, 1504, 392},
    { 136, 1808, 392},
    { 416, 1728, 344},
    { 424, 1696, 448},
    { 488, 1320, 312},
    { 352, 832, -40},
    { 224, 472, -184},
    { 144, 256, -200},
    { 88, 160, -248},
    { 16, 272, -232},
    { 120, 48, -144},
    { 512, 40, -184},
    { 1016, 80, -144},
    // 77 seconds
    { 1488, 128, -64},
    { 2064, 360, 48},
    { 2272, 552, -16},
    { 2408, 496, -16},
    { 2200, 808, -168},
    { 1472, 856, -344},
    { 1008, 608, -240},
    { 808, 576, -272},
    { 680, 680, -240},
    { 640, 752, -280},
    { 712, 744, -240},
    { 736, 736, -184},
    { 896, 704, -296},
    { 848, 616, -208},
    { 1200, 696, -240},
    { 1144, 744, -368},
    { 1528, 832, -440},
    { 1992, 648, -80},
    { 2008, 512, -152},
    { 1720, 384, -104},
    { 1376, 352, 16},
    { 1088, 200, 96},
    { 984, 24, 144},
    { 976, 8, 168},
    { 816, -80, 200},
    // 78 seconds
    { 800, -88, 144},
    { 744, -112, 56},
    { 1128, 88, 0},
    { 1392, 216, -88},
    { 1392, 288, -264},
    { 1592, 256, -128},
    { 1440, 264, -128},
    { 1256, 376, -280},
    { 1064, 536, -376},
    { 888, 712, -432},
    { 864, 656, -440},
    { 816, 664, -416},
    { 808, 624, -392},
    { 848, 464, -448},
    { 952, 544, -456},
    { 1024, 528, -336},
    { 1392, 648, -344},
    { 1136, 664, -352},
    { 1360, 648, -272},
    { 1776, 544, -128},
    { 1528, 408, -24},
    { 1184, 368, -48},
    { 928, 312, -32},
    { 768, 264, 8},
    { 728, 216, -32},
    // 79 seconds
    { 752, 232, -24},
    { 792, 216, 8},
    { 872, 176, -32},
    { 944, 128, 8},
    { 1032, 128, 0},
    { 1344, 144, 64},
    { 1152, 144, -72},
    { 1448, 216, -192},
    { 1648, 320, -144},
    { 1360, 392, -256},
    { 1152, 544, -384},
    { 856, 576, -304},
    { 744, 624, -272},
    { 696, 680, -320},
    { 688, 656, -328},
    { 704, 648, -312},
    { 904, 688, -304},
    { 1000, 688, -232},
    { 1384, 704, -248},
    { 1232, 560, -272},
    { 1336, 400, -256},
    { 1624, 472, -240},
    { 1824, 384, -128},
    { 1360, 336, -80},
    { 1016, 344, -72},
    // 80 seconds
    { 816, 304, -24},
    { 752, 224, 8},
    { 728, 160, 40},
    { 776, 168, 24},
    { 816, 152, 8},
    { 840, 56, 40},
    { 864, 88, 8},
    { 1144, 128, -80},
    { 1336, 272, -216},
    { 1440, 384, -464},
    { 1592, 256, -240},
    { 1424, 280, -128},
    { 1000, 424, -328},
    { 632, 488, -424},
    { 568, 432, -320},
    { 608, 408, -376},
    { 704, 440, -400},
    { 752, 464, -416},
    { 808, 488, -456},
    { 968, 512, -440},
    { 1128, 464, -432},
    { 1488, 536, -536},
    { 1224, 472, -504},
    { 1488, 408, -360},
    { 1728, 408, -152},
    // 81 seconds
    { 1376, 408, -56},
    { 984, 424, -112},
    { 760, 384, -128},
    { 672, 304, -120},
    { 640, 200, -72},
    { 640, 144, -128},
    { 632, 56, -136},
    { 704, -40, -192},
    { 880, 56, -256},
    { 1192, 128, -224},
    { 1384, 160, -48},
    { 1288, 360, -120},
    { 1472, 384, -240},
    { 1488, 320, -64},
    { 1208, 256, -224},
    { 896, 368, -552},
    { 728, 280, -448},
    { 704, 328, -416},
    { 760, 416, -496},
    { 784, 464, -480},
    { 760, 536, -456},
    { 840, 576, -464},
    { 896, 504, -360},
    { 1040, 504, -264},
    { 1416, 608, -320},
    // 82 seconds
    { 1312, 688, -424},
    { 1648, 552, -160},
    { 1808, 456, 56},
    { 1608, 400, -24},
    { 1200, 336, -88},
    { 880, 416, -80},
    { 744, 424, -8},
    { 720, 432, -16},
    { 672, 440, -48},
    { 576, 528, -64},
    { 616, 600, -64},
    { 560, 704, -144},
    { 520, 760, -152},
    { 488, 944, -120},
    { 592, 992, -328},
    { 616, 1152, -368},
    { 400, 1008, -224},
    { 200, 952, -240},
    { 72, 792, -312},
    { -8, 704, -288},
    { -80, 672, -248},
    { -128, 760, -296},
    { -136, 896, -392},
    { -160, 952, -336},
    { -112, 1016, -352},
    // 83 seconds
    { -32, 1064, -296},
    { -40, 1040, -248},
    { 8, 1264, -80},
    { 8, 1288, -160},
    { 48, 1776, -384},
    { 64, 1320, -176},
    { 128, 920, -256},
    { 104, 624, -352},
    { 96, 440, -288},
    { 40, 528, -312},
    { 32, 576, -368},
    { 48, 464, -336},
    { -8, 720, -352},
    { 16, 848, -384},
    { 64, 872, -416},
    { 8, 1000, -376},
    { 120, 1232, -384},
    { 272, 1400, -528},
    { 232, 1280, -384},
    { 24, 1080, -304},
    { -128, 952, -312},
    { -152, 752, -320},
    { -168, 608, -304},
    { -192, 560, -320},
    { -192, 568, -352},
    // 84 seconds
    { -232, 672, -384},
    { -248, 816, -416},
    { -232, 888, -400},
    { -224, 960, -408},
    { -336, 1056, -320},
    { -312, 1256, -336},
    { -296, 1400, -344},
    { -192, 1448, -328},
    { -80, 1080, -192},
    { -72, 648, -144},
    { -96, 688, -232},
    { -112, 480, -216},
    { -144, 464, -184},
    { -192, 616, -176},
    { -256, 712, -144},
    { -264, 1088, -168},
    { -144, 1224, -184},
    { -56, 1064, -264},
    { 56, 1208, -248},
    { 184, 1160, -232},
    { 288, 1264, -336},
    { 136, 1248, -176},
    { 208, 1112, -224},
    { 104, 736, -168},
    { -32, 696, -120},
    // 85 seconds
    { -128, 680, -88},
    { -256, 704, -56},
    { -376, 840, -72},
    { -392, 872, -96},
    { -424, 888, -120},
    { -472, 944, -136},
    { -448, 1048, -184},
    { -512, 1400, -168},
    { -320, 1352, -136},
    { -296, 1240, -216},
    { -176, 1264, -280},
    { -32, 952, -296},
    { 64, 848, -336},
    { 16, 552, -320},
    { -104, 512, -376},
    { -120, 544, -440},
    { -144, 528, -512},
    { -128, 536, -640},
    { -64, 728, -744},
    { 0, 632, -784},
    { 40, 552, -920},
    { 24, 576, -816},
    { 136, 776, -960},
    { 312, 904, -984},
    { 304, 528, -896},
    // 86 seconds
    { 168, 256, -832},
    { 72, 88, -744},
    { 88, 144, -728},
    { 88, 128, -744},
    { 104, 184, -776},
    { 56, 288, -816},
    { -8, 320, -856},
    { -32, 376, -920},
    { -40, 448, -984},
    { -136, 496, -1112},
    { -144, 648, -1056},
    { -272, 720, -968},
    { -200, 816, -952},
    { -32, 624, -880},
    { -16, 376, -768},
    { -32, 216, -592},
    { -104, 360, -664},
    { -120, 312, -664},
    { -88, 368, -696},
    { -136, 368, -704},
    { -80, 488, -808},
    { 16, 504, -872},
    { 40, 536, -960},
    { 88, 648, -840},
    { 176, 984, -968},
    // 87 seconds
    { 112, 920, -888},
    { 40, 824, -880},
    { -8, 568, -792},
    { -40, 384, -672},
    { -16, 288, -592},
    { -24, 320, -568},
    { -64, 384, -568},
    { -32, 464, -664},
    { -8, 456, -712},
    { -40, 496, -800},
    { -40, 600, -840},
    { -64, 616, -816},
    { -256, 912, -832},
    { -160, 1208, -784},
    { -200, 1160, -672},
    { -160, 1048, -560},
    { -64, 896, -512},
    { -64, 696, -560},
    { -40, 424, -552},
    { 0, 432, -544},
    { 0, 448, -576},
    { 0, 504, -592},
    { -16, 536, -624},
    { 8, 632, -696},
    { 32, 712, -712},
    // 88 seconds
    { 80, 720, -792},
    { 120, 904, -728},
    { 216, 1200, -624},
    { 248, 1232, -568},
    { 208, 1104, -472},
    { 112, 952, -512},
    { 24, 744, -480},
    { -16, 568, -440},
    { -48, 480, -408},
    { -40, 496, -416},
    { -40, 552, -496},
    { -72, 608, -544},
    { -144, 712, -616},
    { -224, 752, -656},
    { -256, 728, -648},
    { -384, 920, -616},
    { -352, 1064, -568},
    { -368, 1208, -512},
    { -256, 1376, -608},
    { -112, 1056, -544},
    { -48, 696, -488},
    { 40, 512, -504},
    { -16, 352, -512},
    { -64, 440, -560},
    { -152, 560, -640},
    // 89 seconds
    { -88, 576, -640},
    { -144, 672, -648},
    { -24, 784, -704},
    { 56, 600, -688},
    { 160, 752, -832},
    { 176, 752, -800},
    { 232, 1112, -1048},
    { 224, 880, -864},
    { 160, 768, -760},
    { 96, 496, -712},
    { 32, 288, -608},
    { 64, 256, -552},
    { 48, 288, -592},
    { 48, 336, -672},
    { 72, 376, -784},
    { 24, 456, -816},
    { -24, 472, -912},
    { -64, 496, -896},
    { -160, 592, -944},
    { -120, 800, -928},
    { -200, 856, -840},
    { -192, 920, -848},
    { -80, 752, -776},
    { -64, 552, -696},
    { -64, 480, -720},
    // 90 seconds
    { -40, 360, -648},
    { -48, 344, -616},
    { -72, 360, -640},
    { -64, 408, -680},
    { -112, 504, -752},
    { -56, 608, -824},
    { 56, 616, -872},
    { 104, 520, -912},
    { 176, 720, -792},
    { 208, 944, -808},
    { 224, 984, -928},
    { 144, 848, -792},
    { 96, 704, -720},
    { -8, 536, -656},
    { -16, 408, -576},
    { 16, 384, -560},
    { -32, 360, -544},
    { -32, 424, -680},
    { -8, 424, -704},
    { -8, 480, -696},
    { -88, 592, -712},
    { -152, 688, -808},
    { -384, 760, -848},
    { -352, 1040, -824},
    { -312, 1240, -824},
    // 91 seconds
    { -184, 984, -768},
    { -96, 696, -672},
    { 80, 624, -584},
    { 56, 504, -616},
    { 24, 376, -600},
    { -16, 336, -632},
    { -32, 360, -664},
    { -40, 392, -728},
    { -40, 544, -872},
    { 56, 576, -896},
    { 72, 424, -888},
    { 144, 528, -904},
    { 160, 640, -760},
    { 232, 1048, -960},
    { 296, 904, -880},
    { 280, 704, -848},
    { 176, 528, -808},
    { 56, 376, -688},
    { 24, 336, -600},
    { -8, 368, -576},
    { -16, 432, -624},
    { -32, 448, -688},
    { -96, 376, -704},
    { -136, 440, -792},
    { -136, 512, -848},
    // 92 seconds
    { -136, 504, -864},
    { -136, 864, -984},
    { -112, 944, -904},
    { -184, 944, -856},
    { -120, 800, -816},
    { -24, 592, -688},
    { 32, 464, -664},
    { 48, 248, -544},
    { 48, 176, -536},
    { 72, 112, -584},
    { 128, 176, -648},
    { 200, 296, -728},
    { 304, 440, -776},
    { 448, 288, -480},
    { 592, 264, -208},
    { 1000, 416, -40},
    { 1520, 720, -56},
    { 1768, 536, 8},
    { 2136, 656, 176},
    { 1848, 864, 168},
    { 1288, 840, -200},
    { 912, 704, -24},
    { 672, 640, -96},
    { 656, 584, -128},
    { 656, 552, -64},
    // 93 seconds
    { 664, 672, -56},
    { 688, 960, -280},
    { 808, 800, -216},
    { 896, 664, -200},
    { 1016, 608, -160},
    { 1136, 656, -200},
    { 1160, 720, -304},
    { 1536, 680, -208},
    { 1648, 552, -80},
    { 1368, 480, -128},
    { 976, 424, -216},
    { 752, 368, -224},
    { 680, 256, -184},
    { 648, 176, -136},
    { 632, 152, -120},
    { 656, 176, -144},
    { 720, 176, -160},
    { 856, 192, -168},
    { 1088, 256, -208},
    { 1360, 296, -128},
    { 1192, 352, -368},
    { 1520, 392, -336},
    { 1328, 352, -136},
    { 1112, 416, -232},
    { 888, 544, -344},
    // 94 seconds
    { 672, 512, -264},
    { 608, 456, -240},
    { 640, 472, -248},
    { 704, 480, -280},
    { 728, 520, -344},
    { 760, 624, -488},
    { 872, 816, -528},
    { 808, 784, -400},
    { 1104, 760, -272},
    { 1136, 832, -240},
    { 1312, 776, -152},
    { 1592, 688, -8},
    { 1504, 560, 32},
    { 1160, 440, -24},
    { 888, 392, -72},
    { 776, 304, -104},
    { 744, 240, -96},
    { 720, 200, -88},
    { 688, 176, -112},
    { 712, 176, -120},
    { 816, 160, -144},
    { 880, 184, -216},
    { 1056, 208, -192},
    { 1216, 224, -200},
    { 1280, 272, -312},
    // 95 seconds
    { 1472, 296, -280},
    { 1384, 264, -184},
    { 1168, 320, -272},
    { 920, 424, -344},
    { 728, 456, -264},
    { 640, 456, -224},
    { 680, 480, -280},
    { 728, 528, -360},
    { 800, 488, -368},
    { 840, 504, -408},
    { 912, 544, -424},
    { 896, 464, -312},
    { 1136, 504, -256},
    { 1296, 608, -368},
    { 1360, 600, -368},
    { 1536, 512, -176},
    { 1640, 472, -128},
    { 1288, 368, -80},
    { 976, 360, -88},
    { 840, 352, -104},
    { 752, 256, -48},
    { 728, 208, -32},
    { 736, 176, -24},
    { 696, 160, -16},
    { 728, 184, -72},
    // 96 seconds
    { 784, 216, -144},
    { 1112, 232, -176},
    { 1512, 224, -128},
    { 1368, 288, -376},
    { 1496, 240, -400},
    { 1368, 200, -152},
    { 1080, 240, -200},
    { 848, 392, -232},
    { 712, 464, -208},
    { 664, 456, -176},
    { 728, 472, -216},
    { 744, 512, -312},
    { 784, 552, -360},
    { 888, 608, -408},
    { 960, 616, -392},
    { 904, 584, -328},
    { 1272, 584, -392},
    { 1432, 352, -216},
    { 1240, 528, -256},
    { 1488, 600, -344},
    { 1384, 440, -120},
    { 1040, 384, -64},
    { 840, 352, -96},
    { 720, 296, -32},
    { 672, 240, 0},
    // 97 seconds
    { 760, 304, -72},
    { 824, 280, -72},
    { 904, 264, -40},
    { 1040, 232, -40},
    { 1024, 168, -56},
    { 1216, 152, -144},
    { 1352, 88, -88},
    { 1104, 112, -240},
    { 1328, 200, -288},
    { 1320, 200, -184},
    { 1048, 248, -184},
    { 880, 392, -280},
    { 760, 424, -256},
    { 696, 392, -232},
    { 752, 416, -272},
    { 808, 408, -312},
    { 784, 424, -384},
    { 760, 512, -464},
    { 824, 528, -456},
    { 888, 496, -352},
    { 1136, 544, -256},
    { 1216, 656, -328},
    { 1368, 680, -312},
    { 1360, 472, -56},
    { 1504, 464, -128},
    // 98 seconds
    { 1360, 392, -128},
    { 1096, 344, -112},
    { 896, 320, -184},
    { 800, 288, -192},
    { 816, 240, -192},
    { 848, 192, -176},
    { 872, 144, -144},
    { 968, 136, -152},
    { 928, 112, -144},
    { 968, 144, -88},
    { 1072, 192, -56},
    { 1104, 280, -216},
    { 1440, 256, -264},
    { 1416, 256, -104},
    { 1248, 312, -312},
    { 1000, 384, -408},
    { 792, 320, -248},
    { 736, 288, -264},
    { 720, 384, -352},
    { 744, 456, -432},
    { 784, 496, -440},
    { 848, 560, -504},
    { 1024, 576, -496},
    { 1192, 520, -448},
    { 1320, 408, -448},
    // 99 seconds
    { 1232, 360, -440},
    { 1264, 376, -312},
    { 1416, 344, -160},
    { 1640, 392, -88},
    { 1160, 408, -128},
    { 952, 392, -192},
    { 872, 264, -152},
    { 816, 216, -72},
    { 752, 184, -56},
    { 648, 160, 0},
    { 680, 168, -72},
    { 824, 152, -72},
    { 968, 136, -136},
    { 1232, 128, -56},
    { 1144, 224, -224},
    { 1360, 232, -384},
    { 1376, 184, -160},
    { 1240, 216, -208},
    { 1064, 400, -392},
    { 824, 400, -344},
    { 688, 472, -280},
    { 712, 456, -304},
    { 768, 504, -376},
    { 808, 488, -432},
    { 840, 528, -496},
    // 100 seconds
    { 896, 544, -552},
    { 968, 552, -416},
    { 1352, 608, -264},
    { 1296, 648, -264},
    { 1328, 616, -232},
    { 1544, 560, -72},
    { 1600, 464, -80},
    { 1288, 368, -112},
    { 992, 312, -136},
    { 856, 288, -192},
    { 784, 232, -152},
    { 752, 176, -120},
    { 672, 144, -72},
    { 640, 144, -72},
    { 760, 168, -120},
    { 848, 176, -160},
    { 1104, 160, -176},
    { 1224, 176, -80},
    { 1256, 264, -336},
    { 1464, 256, -288},
    { 1408, 216, -216},
    { 1160, 288, -352},
    { 936, 408, -440},
    { 752, 408, -344},
    { 712, 448, -280},
    // 101 seconds
    { 776, 496, -344},
    { 848, 464, -320},
    { 752, 512, -336},
    { 760, 608, -376},
    { 896, 648, -344},
    { 1136, 608, -240},
    { 1336, 664, -192},
    { 1232, 720, -288},
    { 1392, 632, -144},
    { 1672, 512, -72},
    { 1496, 424, -96},
    { 1152, 328, -120},
    { 944, 304, -128},
    { 832, 248, -128},
    { 776, 208, -224},
    { 696, 128, -72},
    { 632, 112, -48},
    { 720, 192, -128},
    { 840, 224, -136},
    { 944, 208, -224},
    { 1264, 128, -192},
    { 1280, 136, -200},
    { 1328, 264, -448},
    { 1488, 232, -232},
    { 1296, 304, -224},
    // 102 seconds
    { 992, 448, -384},
    { 800, 448, -328},
    { 672, 368, -184},
    { 664, 440, -184},
    { 696, 520, -240},
    { 760, 600, -280},
    { 872, 680, -272},
    { 1080, 800, -288},
    { 992, 784, -240},
    { 1248, 712, -224},
    { 1216, 728, -280},
    { 1088, 720, -352},
    { 1456, 672, -288},
    { 1720, 408, -24},
    { 1360, 336, -104},
    { 1016, 360, -160},
    { 832, 328, -80},
    { 752, 256, -32},
    { 752, 200, -8},
    { 736, 184, -32},
    { 736, 160, 8},
    { 904, 216, -112},
    { 976, 160, -200},
    { 1112, 96, -248},
    { 1288, 40, -64},
    // 103 seconds
    { 1272, 224, -296},
    { 1392, 320, -360},
    { 1448, 280, -240},
    { 1120, 304, -352},
    { 800, 360, -328},
    { 664, 384, -208},
    { 648, 464, -240},
    { 696, 504, -264},
    { 792, 536, -312},
    { 760, 568, -368},
    { 912, 600, -432},
    { 984, 616, -344},
    { 1176, 624, -280},
    { 1424, 696, -336},
    { 1208, 720, -368},
    { 1384, 616, -216},
    { 1616, 504, -152},
    { 1448, 368, -168},
    { 1112, 280, -104},
    { 920, 280, -144},
    { 816, 248, -96},
    { 752, 216, -72},
    { 704, 160, -40},
    { 728, 152, -16},
    { 880, 144, -72},
    // 104 seconds
    { 880, 136, -88},
    { 1048, 136, -128},
    { 1192, 136, -112},
    { 1136, 248, -240},
    { 1368, 280, -304},
    { 1528, 288, -208},
    { 1224, 352, -320},
    { 872, 456, -408},
    { 704, 432, -320},
    { 688, 424, -296},
    { 688, 456, -312},
    { 784, 512, -336},
    { 736, 560, -320},
    { 896, 632, -376},
    { 984, 656, -264},
    { 1240, 616, -192},
    { 1312, 672, -320},
    { 1296, 664, -336},
    { 1432, 560, -160},
    { 1576, 416, -88},
    { 1304, 368, -112},
    { 976, 336, -128},
    { 824, 312, -112},
    { 792, 248, -48},
    { 848, 208, -40},
    // 105 seconds
    { 872, 200, -16},
    { 896, 192, -88},
    { 1016, 128, -112},
    { 952, 56, -152},
    { 1152, 40, -96},
    { 1248, 128, -176},
    { 1224, 232, -312},
    { 1400, 224, -224},
    { 1432, 248, -208},
    { 1096, 360, -376},
    { 816, 400, -312},
    { 648, 448, -240},
    { 656, 496, -240},
    { 696, 536, -296},
    { 776, 576, -336},
    { 736, 576, -360},
    { 872, 600, -360},
    { 976, 568, -264},
    { 1496, 648, -232},
    { 1176, 496, -296},
    { 1128, 600, -360},
    { 1512, 528, -280},
    { 1584, 448, -184},
    { 1168, 432, -240},
    { 880, 360, -248},
    // 106 seconds
    { 752, 288, -152},
    { 720, 232, -128},
    { 736, 216, -104},
    { 776, 200, -88},
    { 800, 176, -64},
    { 1040, 216, -152},
    { 1040, 144, -144},
    { 1192, 72, -64},
    { 1304, 72, -48},
    { 1224, 184, -448},
    { 1480, 264, -208},
    { 1352, 248, -104},
    { 1104, 392, -248},
    { 808, 408, -280},
    { 648, 376, -176},
    { 616, 408, -184},
    { 696, 448, -288},
    { 744, 496, -320},
    { 800, 544, -368},
    { 992, 672, -384},
    { 1008, 696, -392},
    { 1272, 608, -352},
    { 1240, 624, -432},
    { 1200, 560, -360},
    { 1472, 512, -216},
    // 107 seconds
    { 1600, 440, -128},
    { 1264, 368, -160},
    { 992, 296, -144},
    { 864, 264, -136},
    { 824, 240, -128},
    { 864, 248, -112},
    { 848, 200, -64},
    { 840, 168, -24},
    { 896, 160, -40},
    { 912, 80, -88},
    { 1136, -96, -48},
    { 1456, 0, -48},
    { 1400, 144, -208},
    { 1512, 240, -272},
    { 1368, 208, -232},
    { 1016, 272, -296},
    { 792, 384, -296},
    { 696, 464, -248},
    { 704, 576, -280},
    { 800, 696, -304},
    { 768, 704, -296},
    { 736, 704, -320},
    { 912, 720, -264},
    { 1032, 656, -216},
    { 1312, 656, -224},
    // 108 seconds
    { 1408, 712, -296},
    { 1376, 568, -208},
    { 1600, 488, -144},
    { 1576, 448, -152},
    { 1224, 328, -200},
    { 944, 224, -120},
    { 840, 224, -176},
    { 744, 168, -176},
    { 680, 120, -112},
    { 672, 120, -128},
    { 696, 112, -128},
    { 784, 136, -104},
    { 960, 152, -160},
    { 1216, 136, -112},
    { 1544, 240, -216},
    { 1408, 272, -312},
    { 1536, 264, -280},
    { 1464, 280, -176},
    { 1184, 376, -240},
    { 880, 512, -240},
    { 704, 496, -216},
    { 648, 488, -216},
    { 760, 528, -296},
    { 784, 528, -288},
    { 704, 552, -312},
    // 109 seconds
    { 824, 544, -304},
    { 896, 560, -232},
    { 1216, 552, -224},
    { 1400, 584, -368},
    { 1312, 520, -280},
    { 1488, 488, -240},
    { 1576, 432, -160},
    { 1320, 352, -224},
    { 976, 304, -168},
    { 864, 304, -128},
    { 816, 240, -144},
    { 840, 192, -128},
    { 816, 136, -96},
    { 800, 104, -80},
    { 880, 112, -112},
    { 912, 144, -136},
    { 1120, 184, -112},
    { 1280, 176, -80},
    { 1248, 248, -256},
    { 1360, 216, -232},
    { 1352, 232, -184},
    { 1080, 296, -256},
    { 832, 432, -336},
    { 696, 504, -288},
    { 688, 504, -280},
    // 110 seconds
    { 856, 472, -288},
    { 912, 464, -336},
    { 784, 520, -400},
    { 880, 496, -392},
    { 968, 456, -352},
    { 1168, 504, -224},
    { 1216, 600, -216},
    { 1264, 760, -376},
    { 1592, 720, -200},
    { 1584, 480, -16},
    { 1352, 392, -96},
    { 1040, 336, -88},
    { 880, 296, -40},
    { 800, 232, -40},
    { 736, 176, 0},
    { 688, 160, 0},
    { 704, 160, 32},
    { 720, 176, 32},
    { 864, 208, -8},
    { 1048, 320, -144},
    { 1416, 336, -464},
    { 1528, 216, -280},
    { 1392, 136, -432},
    { 1336, 160, -304},
    { 1176, 192, -192},
    // 111 seconds
    { 872, 304, -200},
    { 672, 384, -184},
    { 632, 424, -144},
    { 640, 448, -136},
    { 768, 472, -184},
    { 848, 480, -248},
    { 792, 504, -264},
    { 856, 568, -408},
    { 896, 520, -368},
    { 1256, 472, -272},
    { 1448, 560, -352},
    { 1240, 632, -384},
    { 1416, 568, -256},
    { 1592, 352, -40},
    { 1216, 360, -136},
    { 976, 416, -136},
    { 832, 392, -152},
    { 832, 576, -200},
    { 824, 592, -264},
    { 824, 744, -384},
    { 688, 608, -416},
    { 696, 672, -624},
    { 640, 456, -688},
    { 696, 312, -784},
    { 720, 48, -744},
    // 112 seconds
    { 696, -56, -744},
    { 736, -72, -712},
    { 728, -80, -752},
    { 584, -184, -664},
    { 336, -216, -616},
    { 192, -256, -600},
    { 176, -304, -584},
    { 176, -312, -600},
    { 184, -384, -664},
    { 144, -368, -776},
    { 168, -352, -864},
    { 200, -304, -928},
    { 208, -312, -1016},
    { 240, -232, -1064},
    { 168, 48, -1040},
    { 64, 216, -976},
    { 160, 272, -1000},
    { 200, 128, -576},
    { 184, 160, -568},
    { 344, 72, -872},
    { 432, 144, -1128},
    { 448, -32, -1104},
    { 448, -72, -1040},
    { 440, -104, -864},
    { 464, -56, -704},
    // 113 seconds
    { 560, -8, -632},
    { 704, 144, -544},
    { 864, 216, -464},
    { 1112, 272, -232},
    { 1424, 408, -136},
    { 1376, 424, -184},
    { 1432, 392, -144},
    { 1352, 568, -248},
    { 1104, 408, -224},
    { 896, 512, -344},
    { 760, 384, -408},
    { 720, 240, -248},
    { 776, 408, -200},
    { 808, 600, -264},
    { 832, 600, -360},
    { 936, 448, -312},
    { 1024, 504, -360},
    { 1008, 424, -296},
    { 1376, 400, -240},
    { 1200, 456, -280},
    { 1224, 448, -176},
    { 1304, 304, -80},
    { 1448, 280, -88},
    { 1192, 168, 56},
    { 896, 256, -168},
    // 114 seconds
    { 768, 280, -120},
    { 720, 328, -88},
    { 744, 344, -64},
    { 784, 368, -24},
    { 832, 376, -24},
    { 896, 384, -56},
    { 984, 320, -104},
    { 984, 256, -152},
    { 1208, 208, -80},
    { 1256, 208, -32},
    { 1104, 472, -384},
    { 1200, 352, -296},
    { 1072, 288, -64},
    { 848, 472, -136},
    { 632, 464, -152},
    { 568, 464, -104},
    { 656, 472, -104},
    { 744, 504, -144},
    { 800, 552, -160},
    { 776, 576, -256},
    { 800, 584, -312},
    { 984, 560, -232},
    { 1016, 488, -160},
    { 1152, 600, -184},
    { 1000, 656, -240},
    // 115 seconds
    { 1080, 664, -208},
    { 1344, 544, -16},
    { 1552, 472, 32},
    { 1208, 344, -32},
    { 992, 272, -56},
    { 872, 336, -136},
    { 776, 344, -136},
    { 744, 360, -192},
    { 680, 360, -192},
    { 624, 312, -136},
    { 656, 328, -160},
    { 752, 392, -240},
    { 992, 408, -288},
    { 1424, 352, -184},
    { 1488, 400, -208},
    { 1384, 304, -288},
    { 1200, 200, -56},
    { 936, 512, -136},
    { 760, 600, -240},
    { 680, 696, -288},
    { 560, 616, -296},
    { 520, 568, -256},
    { 616, 584, -304},
    { 712, 656, -320},
    { 696, 752, -416},
    // 116 seconds
    { 616, 712, -472},
    { 640, 656, -520},
    { 712, 584, -448},
    { 824, 672, -328},
    { 992, 976, -472},
    { 1080, 960, -472},
    { 1296, 864, -296},
    { 1160, 760, -280},
    { 1104, 672, -320},
    { 872, 520, -240},
    { 760, 456, -224},
    { 632, 408, -224},
    { 560, 424, -304},
    { 480, 416, -272},
    { 480, 408, -312},
    { 480, 400, -304},
    { 504, 400, -296},
    { 600, 368, -264},
    { 736, 352, -304},
    { 1032, 336, -200},
    { 1296, 328, -176},
    { 1440, 328, -216},
    { 1384, 368, -248},
    { 1336, 312, -192},
    { 1136, 344, -152},
    // 117 seconds
    { 936, 432, -200},
    { 856, 544, -200},
    { 816, 608, -240},
    { 832, 656, -280},
    { 816, 656, -288},
    { 848, 624, -312},
    { 768, 576, -344},
    { 728, 536, -384},
    { 752, 520, -416},
    { 864, 512, -352},
    { 1136, 536, -264},
    { 1120, 608, -368},
    { 1256, 600, -224},
    { 1496, 552, -136},
    { 1552, 504, -144},
    { 1432, 448, -120},
    { 1280, 376, -104},
    { 1128, 304, -144},
    { 984, 256, -224},
    { 872, 240, -328},
    { 696, 248, -440},
    { 496, 520, -432},
    { 448, 752, -424},
    { 368, 600, -264},
    { 328, 520, -192},
    // 118 seconds
    { 328, 488, -96},
    { 536, 496, -144},
    { 912, 376, -160},
    { 1192, 336, -32},
    { 1096, 256, -120},
    { 1344, 408, -296},
    { 1352, 384, -168},
    { 1248, 360, -144},
    { 1208, 496, -176},
    { 1144, 616, -96},
    { 1056, 744, -184},
    { 944, 712, -200},
    { 864, 656, -240},
    { 848, 624, -296},
    { 808, 584, -320},
    { 744, 544, -336},
    { 776, 520, -368},
    { 824, 480, -328},
    { 984, 432, -256},
    { 1136, 456, -256},
    { 1472, 536, -352},
    { 1296, 424, -168},
    { 1416, 424, -160},
    { 1416, 416, -240},
    { 1280, 320, -200},
    // 119 seconds
    { 1176, 256, -168},
    { 1032, 200, -136},
    { 896, 224, -144},
    { 840, 320, -168},
    { 744, 336, -152},
    { 672, 408, -192},
    { 600, 488, -208},
    { 568, 552, -224},
    { 528, 592, -224},
    { 568, 688, -264},
    { 592, 720, -272},
    { 640, 664, -280},
    { 680, 504, -192},
    { 872, 536, -272},
    { 1184, 512, -360},
    { 1288, 520, -272},
    { 952, 512, -448},
    { 936, 392, -632},
    { 992, 240, -368},
    { 872, 120, -128},
    { 848, 232, -264},
    { 872, 296, -280},
    { 896, 320, -264},
    { 848, 304, -280},
    { 800, 328, -336},
    // 120 seconds
    // elapsed: 2 minutes
    { 784, 344, -392},
    { 768, 312, -400},
    { 752, 304, -416},
    { 728, 320, -416},
    { 736, 328, -424},
    { 768, 368, -408},
    { 824, 368, -384},
    { 904, 368, -328},
    { 1040, 408, -320},
    { 1080, 432, -328},
    { 1144, 456, -400},
    { 1128, 296, -280},
    { 1168, 136, -240},
    { 1264, 112, -232},
    { 1240, 80, -112},
    { 1216, 136, -104},
    { 1112, 184, -88},
    { 1080, 200, -96},
    { 1056, 176, -56},
    { 1032, 208, -24},
    { 992, 288, -24},
    { 968, 424, -48},
    { 912, 472, -40},
    { 856, 632, -64},
    { 808, 712, -96},
    // 121 seconds
    { 768, 704, -56},
    { 712, 704, -64},
    { 648, 664, -56},
    { 640, 664, -40},
    { 600, 640, -32},
    { 544, 640, -32},
    { 632, 728, -32},
    { 744, 840, -56},
    { 672, 768, -224},
    { 600, 744, -384},
    { 600, 632, -512},
    { 608, 536, -504},
    { 728, 472, -472},
    { 824, 440, -448},
    { 896, 376, -344},
    { 960, 408, -296},
    { 960, 424, -248},
    { 912, 424, -232},
    { 880, 432, -224},
    { 848, 424, -208},
    { 848, 448, -216},
    { 856, 456, -216},
    { 904, 496, -264},
    { 904, 512, -272},
    { 920, 544, -304},
    // 122 seconds
    { 904, 560, -336},
    { 880, 568, -400},
    { 856, 552, -448},
    { 832, 496, -480},
    { 864, 440, -480},
    { 872, 392, -448},
    { 864, 376, -432},
    { 824, 352, -384},
    { 800, 344, -344},
    { 816, 344, -304},
    { 848, 352, -216},
    { 1032, 432, -224},
    { 1232, 520, -208},
    { 968, 512, -160},
    { 856, 464, -128},
    { 912, 480, -88},
    { 1000, 488, -80},
    { 1112, 520, -104},
    { 1216, 504, -96},
    { 1200, 376, 24},
    { 1136, 344, 32},
    { 1144, 384, -16},
    { 1168, 408, -48},
    { 1136, 344, -72},
    { 1064, 288, -48},
    // 123 seconds
    { 952, 224, -40},
    { 912, 272, -104},
    { 784, 304, -168},
    { 664, 384, -216},
    { 688, 528, -256},
    { 784, 688, -192},
    { 832, 936, -152},
    { 752, 1008, -136},
    { 704, 920, -80},
    { 704, 816, 0},
    { 736, 784, -16},
    { 744, 776, 16},
    { 792, 704, 0},
    { 752, 688, 24},
    { 728, 704, -8},
    { 672, 712, 24},
    { 656, 768, 24},
    { 648, 808, 16},
    { 632, 976, -120},
    { 656, 872, -136},
    { 648, 808, -240},
    { 616, 656, -456},
    { 640, 720, -608},
    { 616, 424, -632},
    { 608, 296, -712},
    // 124 seconds
    { 560, 296, -776},
    { 528, 216, -736},
    { 488, 232, -768},
    { 456, 184, -728},
    { 416, 184, -752},
    { 400, 192, -768},
    { 384, 192, -784},
    { 392, 208, -840},
    { 400, 184, -840},
    { 392, 184, -856},
    { 392, 176, -872},
    { 392, 176, -896},
    { 408, 200, -904},
    { 416, 176, -904},
    { 416, 176, -912},
    { 416, 160, -880},
    { 400, 136, -880},
    { 400, 136, -864},
    { 392, 120, -848},
    { 392, 144, -864},
    { 384, 112, -848},
    { 392, 128, -872},
    { 384, 64, -840},
    { 376, 152, -736},
    { 336, 176, -544},
    // 125 seconds
    { 264, 344, -336},
    { 248, 896, -136},
    { 256, 1376, -8},
    { 264, 1312, 160},
    { 296, 1264, 328},
    { 280, 1160, 312},
    { 264, 1016, 296},
    { 272, 888, 312},
    { 280, 888, 320},
    { 216, 904, 472},
    { 224, 1048, 544},
    { 192, 1080, 528},
    { 144, 1024, 488},
    { 128, 936, 424},
    { 120, 936, 440},
    { 136, 984, 440},
    { 144, 1008, 400},
    { 168, 928, 368},
    { 184, 960, 280},
    { 168, 968, 240},
    { 168, 824, 168},
    { 104, 912, 224},
    { 32, 888, 152},
    { -48, 864, 128},
    { -176, 856, 224},
    // 126 seconds
    { -296, 896, 272},
    { -312, 1080, 360},
    { -416, 1000, 416},
    { -456, 928, 472},
    { -496, 1008, 440},
    { -488, 872, 416},
    { -488, 912, 352},
    { -496, 992, 256},
    { -496, 864, 216},
    { -464, 976, 104},
    { -440, 856, -40},
    { -456, 864, -176},
    { -504, 848, -160},
    { -592, 760, -256},
    { -576, 576, -320},
    { -632, 472, -440},
    { -664, 656, -536},
    { -776, 576, -696},
    { -848, 568, -552},
    { -496, -408, -528},
    { -152, -296, -752},
    { -80, -400, -696},
    { -40, -448, -640},
    { 96, -472, -720},
    { 40, -552, -704},
    // 127 seconds
    { -8, -624, -712},
    { 16, -696, -672},
    { 8, -776, -632},
    { 40, -776, -616},
    { 8, -776, -584},
    { 8, -776, -592},
    { 16, -768, -616},
    { 24, -736, -648},
    { 24, -704, -688},
    { -32, -712, -680},
    { -16, -680, -760},
    { -48, -720, -672},
    { -40, -784, -616},
    { -16, -744, -672},
    { -40, -672, -712},
    { -64, -680, -736},
    { -88, -696, -712},
    { -88, -696, -712},
    { -96, -696, -728},
    { -96, -696, -720},
    { -88, -712, -728},
    { -80, -680, -768},
    { -96, -832, -672},
    { -96, -688, -736},
    { -120, -560, -648},
    // 128 seconds
    { -104, -616, -696},
    { -72, -688, -712},
    { -80, -664, -800},
    { -96, -624, -752},
    { -96, -648, -760},
    { -80, -632, -808},
    { -80, -616, -800},
    { -128, -600, -800},
    { -120, -560, -808},
    { -128, -560, -784},
    { -88, -584, -864},
    { -128, -584, -792},
    { -136, -528, -792},
    { -144, -544, -760},
    { -176, -488, -840},
    { -152, -568, -784},
    { -120, -568, -800},
    { -80, -568, -840},
    { -56, -608, -800},
    { -72, -640, -784},
    { -80, -608, -816},
    { -120, -592, -800},
    { -112, -576, -776},
    { -104, -552, -784},
    { -80, -504, -848},
    // 129 seconds
    { -120, -520, -872},
    { -120, -544, -904},
    { -72, -648, -808},
    { 16, -920, -792},
    { -16, -1008, -616},
    { -8, -888, -584},
    { -8, -912, -480},
    { -48, -920, -312},
    { 16, -920, -304},
    { 88, -880, -320},
    { 128, -952, -336},
    { 136, -992, -296},
    { 112, -976, -216},
    { 152, -728, -224},
    { 56, -768, -192},
    { 144, -1024, -312},
    { 120, -1040, -240},
    { 144, -920, -304},
    { 120, -1000, -256},
    { 136, -1000, -304},
    { 112, -1024, -272},
    { 104, -944, -248},
    { 120, -968, -320},
    { 88, -984, -280},
    { 88, -952, -336},
    // 130 seconds
    { 120, -984, -344},
    { 104, -960, -312},
    { 136, -968, -376},
    { 128, -952, -320},
    { 128, -960, -328},
    { 128, -960, -344},
    { 128, -968, -336},
    { 128, -936, -312},
    { 120, -960, -368},
    { 120, -952, -336},
    { 128, -928, -352},
    { 136, -960, -368},
    { 112, -936, -384},
    { 112, -944, -416},
    { 104, -936, -400},
    { 96, -936, -392},
    { 96, -936, -400},
    { 96, -944, -392},
    { 112, -936, -400},
    { 104, -928, -384},
    { 96, -944, -368},
    { 104, -928, -424},
    { 96, -928, -416},
    { 96, -936, -408},
    { 96, -928, -408},
    // 131 seconds
    { 104, -944, -416},
    { 88, -920, -400},
    { 96, -936, -408},
    { 96, -936, -416},
    { 96, -928, -400},
    { 88, -936, -400},
    { 104, -928, -424},
    { 96, -928, -424},
    { 104, -928, -440},
    { 88, -928, -408},
    { 96, -928, -416},
    { 104, -928, -416},
    { 96, -920, -416},
    { 88, -936, -400},
    { 112, -920, -432},
    { 96, -928, -416},
    { 96, -928, -424},
    { 104, -928, -424},
    { 104, -936, -416},
    { 96, -920, -416},
    { 96, -928, -416},
    { 88, -928, -408},
    { 104, -920, -424},
    { 96, -928, -416},
    { 96, -920, -416},
    // 132 seconds
    { 96, -936, -416},
    { 96, -920, -416},
    { 96, -928, -432},
    { 96, -920, -432},
    { 96, -920, -424},
    { 96, -920, -432},
    { 88, -920, -416},
    { 96, -912, -432},
    { 88, -920, -424},
    { 96, -920, -440},
    { 88, -920, -424},
    { 96, -920, -440},
    { 88, -912, -424},
    { 96, -912, -424},
    { 88, -912, -456},
    { 96, -920, -440},
    { 96, -928, -432},
    { 88, -912, -408},
    { 104, -920, -440},
    { 104, -920, -424},
    { 96, -920, -432},
    { 88, -920, -440},
    { 96, -912, -432},
    { 96, -912, -424},
    { 88, -920, -440},
    // 133 seconds
    { 96, -920, -440},
    { 96, -912, -448},
    { 88, -928, -440},
    { 88, -920, -424},
    { 96, -920, -440},
    { 88, -920, -432},
    { 96, -920, -432},
    { 96, -912, -432},
    { 96, -920, -440},
    { 96, -912, -440},
    { 88, -920, -440},
    { 96, -912, -440},
    { 96, -912, -440},
    { 88, -920, -432},
    { 104, -920, -440},
    { 88, -912, -432},
    { 80, -920, -424},
    { 88, -912, -440},
    { 96, -912, -448},
    { 88, -912, -448},
    { 80, -904, -456},
    { 88, -912, -448},
    { 88, -920, -440},
    { 80, -920, -424},
    { 88, -920, -440},
    { 88, -920, -440},
    { 88, -920, -424},
    { 88, -920, -440},
    { 88, -920, -432},
    { 88, -920, -432},
    { 80, -936, -424},
    { 88, -912, -432},
    { 88, -928, -416},
    { 80, -912, -432},
    { 80, -936, -416},
    { 88, -920, -440},
    { 88, -928, -408},
    { 72, -912, -416},
    { 88, -944, -432},
    { 80, -920, -416},
    { 104, -920, -456},
    { 80, -912, -440},
    { 80, -912, -448},
    { 72, -896, -440},
    { 64, -920, -416},
    { 72, -912, -448},
    { 64, -928, -440},
    { 48, -920, -440},
    { 56, -920, -448},
    { 64, -904, -456},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-19 11:08:45 local
AccelRawData *activity_sample_walk_200_pbl_27927_12(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_27927_12
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 180
  //> TEST_EXPECTED_MAX 220
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 56, 168, -1024},
    { 48, 256, -1016},
    { 64, 328, -1032},
    { 72, 368, -1008},
    { 72, 352, -1000},
    { 48, 320, -976},
    { 8, 312, -968},
    { -32, 360, -984},
    { -32, 416, -984},
    { -48, 376, -936},
    { -40, 352, -904},
    { -32, 344, -864},
    { -8, 328, -880},
    { -16, 320, -880},
    { 8, 304, -912},
    { 8, 296, -928},
    { 16, 288, -936},
    { -16, 264, -920},
    { -56, 280, -928},
    { -72, 288, -920},
    { -56, 280, -944},
    { -64, 256, -928},
    { -40, 232, -920},
    { -96, 208, -920},
    { 0, 240, -920},
    // 1 seconds
    { -16, 240, -928},
    { 8, 208, -920},
    { 32, 232, -936},
    { 64, 200, -944},
    { -24, 144, -936},
    { 48, 24, -880},
    { 136, 136, -792},
    { 256, 120, -816},
    { 304, 192, -840},
    { 352, 152, -792},
    { 368, 192, -832},
    { 392, 424, -824},
    { 352, 496, -704},
    { 312, 792, -656},
    { 224, 992, -504},
    { 128, 1120, -344},
    { 16, 1176, -192},
    { -8, 1152, -72},
    { 0, 1080, -8},
    { 16, 1088, 32},
    { 40, 984, 112},
    { 72, 1056, 112},
    { 96, 984, 112},
    { 104, 992, 96},
    { 96, 952, 192},
    // 2 seconds
    { 88, 984, 224},
    { 80, 960, 256},
    { 80, 888, 288},
    { 64, 944, 312},
    { 64, 848, 336},
    { 56, 880, 368},
    { 104, 904, 344},
    { 120, 936, 264},
    { 112, 968, 304},
    { 152, 920, 272},
    { 176, 1008, 112},
    { 136, 984, 224},
    { 152, 912, 112},
    { 120, 936, 160},
    { 128, 960, 128},
    { 168, 912, 136},
    { 216, 952, 128},
    { 264, 1000, 144},
    { 296, 1040, 128},
    { 376, 1016, 96},
    { 328, 944, 112},
    { 312, 800, 152},
    { 248, 952, 40},
    { 416, 688, 240},
    { 224, 1272, 40},
    // 3 seconds
    { 408, 960, 80},
    { 424, 920, 80},
    { 464, 888, 72},
    { 448, 888, 136},
    { 488, 896, 184},
    { 504, 936, 208},
    { 520, 928, 224},
    { 480, 880, 232},
    { 464, 872, 272},
    { 440, 872, 248},
    { 424, 880, 248},
    { 440, 904, 256},
    { 480, 952, 248},
    { 488, 920, 224},
    { 488, 872, 224},
    { 504, 872, 208},
    { 528, 880, 232},
    { 568, 1008, 224},
    { 664, 1096, 232},
    { 624, 1048, 200},
    { 608, 1024, 192},
    { 576, 936, 160},
    { 528, 920, 112},
    { 512, 896, 96},
    { 480, 888, 72},
    // 4 seconds
    { 448, 912, 48},
    { 416, 904, 40},
    { 376, 936, 8},
    { 368, 944, 8},
    { 320, 968, 8},
    { 304, 1008, 0},
    { 280, 992, 0},
    { 248, 976, -16},
    { 232, 960, -8},
    { 216, 960, -16},
    { 176, 952, -32},
    { 152, 952, -16},
    { 192, 928, -88},
    { 64, 1128, 32},
    { 64, 1088, 200},
    { -32, 1104, 184},
    { -40, 880, 88},
    { -48, 760, 40},
    { -80, 888, -112},
    { -64, 888, -152},
    { -96, 824, -216},
    { -88, 864, -400},
    { -24, 808, -384},
    { -152, 832, -408},
    { -208, 968, -472},
    // 5 seconds
    { -192, 696, -496},
    { -248, 960, -488},
    { -264, 904, -512},
    { -272, 624, -568},
    { -272, 616, -592},
    { -368, 672, -544},
    { -296, 536, -600},
    { -320, 528, -632},
    { -376, 560, -592},
    { -368, 536, -576},
    { -376, 544, -624},
    { -368, 592, -728},
    { -368, 560, -712},
    { -360, 520, -648},
    { -360, 528, -680},
    { -392, 568, -648},
    { -376, 496, -696},
    { -376, 544, -704},
    { -368, 512, -680},
    { -368, 480, -664},
    { -368, 544, -720},
    { -392, 552, -704},
    { -408, 488, -696},
    { -392, 512, -696},
    { -376, 496, -640},
    // 6 seconds
    { -376, 576, -712},
    { -352, 504, -696},
    { -352, 528, -768},
    { -384, 512, -768},
    { -392, 560, -744},
    { -400, 544, -688},
    { -432, 528, -664},
    { -408, 472, -680},
    { -400, 472, -672},
    { -400, 488, -704},
    { -392, 488, -728},
    { -360, 432, -744},
    { -376, 424, -760},
    { -400, 432, -704},
    { -392, 424, -704},
    { -440, 424, -728},
    { -416, 472, -760},
    { -384, 416, -776},
    { -392, 424, -776},
    { -392, 440, -752},
    { -384, 400, -736},
    { -384, 400, -744},
    { -384, 400, -776},
    { -384, 376, -776},
    { -392, 384, -744},
    // 7 seconds
    { -384, 360, -792},
    { -384, 376, -824},
    { -384, 376, -784},
    { -376, 344, -768},
    { -392, 320, -784},
    { -384, 320, -816},
    { -384, 312, -816},
    { -376, 296, -816},
    { -376, 280, -792},
    { -384, 288, -832},
    { -376, 296, -864},
    { -384, 248, -848},
    { -384, 240, -872},
    { -400, 256, -848},
    { -368, 224, -856},
    { -376, 200, -848},
    { -368, 216, -872},
    { -376, 208, -840},
    { -360, 192, -848},
    { -360, 192, -856},
    { -352, 184, -864},
    { -360, 152, -840},
    { -336, 120, -872},
    { -352, 136, -848},
    { -352, 120, -856},
    // 8 seconds
    { -360, 96, -864},
    { -344, 136, -896},
    { -368, 104, -896},
    { -360, 120, -872},
    { -360, 120, -864},
    { -360, 104, -888},
    { -360, 96, -880},
    { -360, 112, -864},
    { -360, 128, -848},
    { -352, 104, -832},
    { -336, 88, -848},
    { -344, 168, -888},
    { -352, 176, -856},
    { -352, 152, -848},
    { -360, 144, -856},
    { -360, 176, -864},
    { -376, 224, -840},
    { -376, 240, -976},
    { -384, 224, -912},
    { -352, 192, -840},
    { -312, 112, -880},
    { -280, 144, -912},
    { -248, 96, -824},
    { -208, 64, -848},
    { -176, 24, -720},
    // 9 seconds
    { -160, 120, -696},
    { -152, 512, -784},
    { -152, 720, -576},
    { -152, 936, -456},
    { -128, 1024, -432},
    { -136, 1000, -344},
    { -176, 888, -352},
    { -184, 1040, -360},
    { -184, 912, -400},
    { -152, 872, -464},
    { -120, 776, -544},
    { -112, 808, -648},
    { -64, 632, -688},
    { -8, 496, -744},
    { 8, 384, -760},
    { 80, 320, -832},
    { 88, 408, -896},
    { 160, 304, -984},
    { 176, 440, -1072},
    { 208, 424, -1088},
    { 200, 376, -992},
    { 144, 392, -928},
    { 128, 376, -968},
    { 144, 384, -968},
    { 160, 344, -944},
    // 10 seconds
    { 128, 296, -872},
    { 136, 200, -816},
    { 144, 232, -848},
    { 176, 120, -896},
    { 192, 88, -992},
    { 168, 8, -960},
    { 136, -16, -912},
    { 72, -32, -904},
    { 64, -48, -904},
    { 48, -72, -888},
    { 64, -48, -840},
    { 240, -56, -832},
    { 568, -112, -872},
    { 776, -40, -712},
    { 1048, -48, -664},
    { 1200, 240, -640},
    { 1104, 56, -376},
    { 1032, 536, -592},
    { 816, 424, -560},
    { 720, 512, -552},
    { 536, 664, -592},
    { 520, 496, -632},
    { 504, 464, -680},
    { 488, 552, -760},
    { 376, 488, -752},
    // 11 seconds
    { 336, 560, -800},
    { 464, 888, -816},
    { 736, 1088, -888},
    { 728, 928, -728},
    { 664, 968, -688},
    { 744, 1040, -680},
    { 840, 896, -632},
    { 776, 704, -568},
    { 632, 504, -464},
    { 528, 496, -464},
    { 520, 400, -440},
    { 488, 320, -416},
    { 488, 232, -368},
    { 528, 240, -400},
    { 656, 152, -384},
    { 728, 64, -432},
    { 984, 24, -416},
    { 1096, 72, -360},
    { 1200, 184, -432},
    { 1440, 232, -448},
    { 1480, 224, -344},
    { 1304, 336, -328},
    { 1136, 512, -312},
    { 992, 552, -256},
    { 888, 728, -368},
    // 12 seconds
    { 856, 800, -432},
    { 848, 744, -504},
    { 776, 688, -576},
    { 696, 656, -600},
    { 728, 616, -520},
    { 752, 560, -320},
    { 1224, 648, -176},
    { 1336, 808, -176},
    { 1352, 896, -104},
    { 1800, 1184, 88},
    { 1920, 696, 376},
    { 1672, 344, 304},
    { 1400, 328, 208},
    { 1096, 288, 16},
    { 880, 232, -32},
    { 728, 192, -16},
    { 648, 176, -104},
    { 616, 144, -72},
    { 656, 136, -152},
    { 712, 144, -224},
    { 856, 160, -336},
    { 1088, 184, -456},
    { 832, 88, -504},
    { 1176, 240, -584},
    { 1496, 320, -440},
    // 13 seconds
    { 1336, 360, -152},
    { 1240, 552, -256},
    { 1088, 664, -432},
    { 832, 648, -392},
    { 728, 520, -448},
    { 664, 552, -520},
    { 672, 624, -536},
    { 688, 648, -480},
    { 784, 568, -384},
    { 1072, 504, -232},
    { 1200, 472, -160},
    { 1400, 472, -96},
    { 1784, 520, -256},
    { 1216, 424, 24},
    { 1416, 432, -96},
    { 1336, 464, -8},
    { 1016, 352, 32},
    { 704, 368, -144},
    { 576, 352, -192},
    { 616, 312, -176},
    { 664, 296, -280},
    { 640, 288, -256},
    { 560, 296, -480},
    { 584, 304, -432},
    { 840, 248, -832},
    // 14 seconds
    { 872, 64, -280},
    { 1184, 232, -264},
    { 1192, 256, -384},
    { 1280, 104, -304},
    { 1184, 160, -88},
    { 1032, 128, -128},
    { 856, 272, -272},
    { 752, 328, -312},
    { 824, 392, -232},
    { 864, 528, -288},
    { 880, 568, -240},
    { 888, 744, -296},
    { 768, 776, -352},
    { 776, 688, -328},
    { 896, 592, -224},
    { 1128, 568, -128},
    { 1496, 624, -176},
    { 1096, 512, -80},
    { 1264, 480, -72},
    { 1392, 480, 32},
    { 1272, 536, 24},
    { 992, 488, 24},
    { 816, 384, 56},
    { 784, 336, 56},
    { 832, 328, 40},
    // 15 seconds
    { 856, 296, 32},
    { 872, 232, 16},
    { 944, 240, 40},
    { 992, 168, -32},
    { 1016, 120, 24},
    { 1336, -56, 152},
    { 944, 264, -184},
    { 1248, 312, -264},
    { 1368, 272, -88},
    { 1088, 480, -264},
    { 784, 784, -384},
    { 560, 648, -376},
    { 512, 480, -312},
    { 568, 456, -248},
    { 640, 448, -192},
    { 800, 496, -208},
    { 776, 480, -168},
    { 872, 504, -224},
    { 920, 464, -160},
    { 1240, 496, -152},
    { 1416, 624, -200},
    { 1136, 600, -120},
    { 1352, 648, -96},
    { 1368, 592, -48},
    { 1016, 416, -72},
    // 16 seconds
    { 768, 352, -144},
    { 648, 352, -136},
    { 632, 320, -96},
    { 680, 264, -64},
    { 728, 296, -72},
    { 736, 264, -40},
    { 896, 288, -64},
    { 992, 360, -112},
    { 1032, 392, -200},
    { 1184, 432, -224},
    { 1024, 448, -288},
    { 1096, 440, -368},
    { 1240, 384, -160},
    { 984, 328, -160},
    { 728, 520, -216},
    { 608, 608, -248},
    { 568, 496, -232},
    { 592, 368, -232},
    { 656, 328, -224},
    { 784, 488, -216},
    { 744, 592, -240},
    { 832, 584, -192},
    { 800, 560, -144},
    { 1088, 656, -88},
    { 1248, 824, -208},
    // 17 seconds
    { 1208, 744, -144},
    { 1336, 664, -96},
    { 1288, 496, -80},
    { 992, 304, -152},
    { 680, 168, -200},
    { 616, 120, -160},
    { 664, 144, -128},
    { 696, 184, -120},
    { 800, 200, -88},
    { 920, 288, -88},
    { 1080, 304, -40},
    { 1064, 304, -128},
    { 1264, 496, -304},
    { 1208, 776, -200},
    { 808, 904, -472},
    { 1128, 592, -384},
    { 1120, 248, -152},
    { 792, 192, -232},
    { 624, 64, -224},
    { 648, 80, -80},
    { 632, 160, -88},
    { 696, 256, -128},
    { 872, 344, -168},
    { 856, 424, -208},
    { 896, 456, -280},
    // 18 seconds
    { 944, 376, -264},
    { 1064, 352, -248},
    { 1456, 584, -384},
    { 1168, 488, -232},
    { 1400, 400, -192},
    { 1528, 360, -144},
    { 1032, 112, -152},
    { 736, 96, -128},
    { 608, 64, -128},
    { 616, 144, -136},
    { 744, 200, -96},
    { 912, 264, -112},
    { 992, 272, -120},
    { 1088, 360, -168},
    { 1128, 272, -88},
    { 1080, 248, -136},
    { 1296, 88, 24},
    { 864, 136, -152},
    { 1032, 216, -312},
    { 1392, 160, -216},
    { 1144, 240, -264},
    { 800, 320, -312},
    { 592, 240, -248},
    { 528, 320, -232},
    { 584, 336, -200},
    // 19 seconds
    { 744, 320, -200},
    { 920, 320, -200},
    { 920, 280, -208},
    { 1032, 224, -176},
    { 1080, 176, -128},
    { 1584, 320, -112},
    { 1288, 392, -136},
    { 1056, 512, -232},
    { 1176, 320, -112},
    { 1240, 136, -24},
    { 960, 24, 0},
    { 768, 104, -88},
    { 704, 32, -104},
    { 760, 120, -40},
    { 832, 232, -88},
    { 944, 288, -40},
    { 1088, 352, -64},
    { 1160, 320, -48},
    { 1104, 176, -112},
    { 1264, 208, -80},
    { 1088, 240, -136},
    { 832, 176, -352},
    { 1128, 80, -256},
    { 1088, 64, -176},
    { 848, 120, -184},
    // 20 seconds
    { 712, 168, -168},
    { 704, 168, -152},
    { 792, 176, -120},
    { 952, 144, -128},
    { 1040, 240, -152},
    { 808, 416, -224},
    { 864, 328, -208},
    { 904, 280, -136},
    { 1264, 328, -176},
    { 1544, 376, -128},
    { 1304, 288, -40},
    { 1280, 176, -80},
    { 1176, 96, -120},
    { 880, 136, -168},
    { 744, 192, -136},
    { 728, 176, -72},
    { 744, 168, -64},
    { 816, 200, -48},
    { 920, 272, -64},
    { 1056, 336, -72},
    { 1160, 320, -80},
    { 1056, 128, -152},
    { 1200, 208, -176},
    { 1208, 80, -64},
    { 912, 216, -232},
    // 21 seconds
    { 1224, 112, -232},
    { 1328, 8, -176},
    { 968, -32, -208},
    { 736, 40, -176},
    { 640, 152, -152},
    { 648, 232, -120},
    { 712, 312, -136},
    { 848, 368, -152},
    { 896, 352, -184},
    { 1008, 368, -352},
    { 1064, 216, -328},
    { 1320, 200, -224},
    { 1536, 216, -120},
    { 1080, 256, -152},
    { 1328, 304, -136},
    { 1320, 40, 64},
    { 992, 136, -96},
    { 728, 120, -168},
    { 584, 208, -80},
    { 736, 232, -160},
    { 880, 224, -144},
    { 1000, 200, -120},
    { 1000, 224, -152},
    { 1128, 232, -144},
    { 1072, 184, -136},
    // 22 seconds
    { 1088, 184, -208},
    { 1144, 48, -160},
    { 992, 32, -144},
    { 1224, 56, -320},
    { 1264, -24, -192},
    { 1024, 48, -232},
    { 672, 104, -216},
    { 568, 152, -176},
    { 608, 224, -136},
    { 720, 280, -120},
    { 856, 336, -128},
    { 944, 344, -192},
    { 968, 384, -248},
    { 1048, 400, -288},
    { 1000, 304, -264},
    { 1240, 376, -216},
    { 1328, 392, -256},
    { 1136, 384, -224},
    { 1336, 352, -160},
    { 1304, 208, -112},
    { 1000, 112, -168},
    { 720, 120, -136},
    { 696, 184, -88},
    { 736, 224, -104},
    { 880, 224, -16},
    // 23 seconds
    { 952, 224, -56},
    { 960, 224, -96},
    { 1056, 240, -80},
    { 1176, 160, -88},
    { 1272, 200, -152},
    { 1152, 160, -184},
    { 752, 32, -232},
    { 1104, 16, -248},
    { 1264, 32, -120},
    { 1056, 200, -184},
    { 776, 208, -208},
    { 648, 224, -184},
    { 616, 256, -160},
    { 704, 320, -192},
    { 800, 304, -272},
    { 840, 296, -264},
    { 952, 352, -352},
    { 1104, 376, -296},
    { 1112, 352, -224},
    { 1272, 448, -240},
    { 1160, 448, -224},
    { 1328, 528, -192},
    { 1312, 360, -112},
    { 1160, 168, -96},
    { 880, 184, -112},
    // 24 seconds
    { 736, 120, -96},
    { 656, 104, -88},
    { 752, 168, -128},
    { 840, 176, -80},
    { 936, 152, -96},
    { 1056, 240, -128},
    { 1160, 208, -128},
    { 1152, 184, -152},
    { 1320, 184, -184},
    { 984, 208, -264},
    { 920, 16, -336},
    { 1304, -184, -96},
    { 1232, 8, -48},
    { 840, 216, -192},
    { 648, 240, -160},
    { 568, 216, -112},
    { 656, 288, -144},
    { 760, 312, -168},
    { 832, 352, -288},
    { 896, 392, -328},
    { 1144, 456, -368},
    { 1184, 392, -336},
    { 1360, 424, -296},
    { 1160, 360, -288},
    { 1024, 376, -280},
    // 25 seconds
    { 1264, 272, -112},
    { 1232, 216, -32},
    { 968, 288, -72},
    { 848, 296, -64},
    { 704, 200, -80},
    { 696, 240, -128},
    { 768, 240, -144},
    { 856, 216, -120},
    { 1016, 192, -112},
    { 1096, 144, -144},
    { 1144, 104, -112},
    { 1408, 112, -136},
    { 1064, 56, -200},
    { 1032, 40, -288},
    { 1320, -80, -88},
    { 1136, 160, -152},
    { 808, 272, -200},
    { 640, 256, -144},
    { 568, 304, -152},
    { 640, 304, -160},
    { 816, 376, -208},
    { 912, 232, -208},
    { 960, 272, -384},
    { 1112, 400, -416},
    { 1064, 200, -208},
    // 26 seconds
    { 1496, 440, -184},
    { 1168, 328, -120},
    { 1248, 296, -120},
    { 1376, 160, -16},
    { 1112, 248, -176},
    { 800, 184, -152},
    { 712, 120, -152},
    { 632, 144, -96},
    { 688, 176, -64},
    { 952, 120, -8},
    { 1096, 112, 56},
    { 1208, 16, 72},
    { 1160, 24, -16},
    { 1184, 40, -80},
    { 1232, -48, -8},
    { 976, -16, -104},
    { 1312, -72, -152},
    { 1336, -56, -32},
    { 992, 112, -136},
    { 688, 144, -152},
    { 552, 184, -152},
    { 576, 240, -152},
    { 728, 312, -144},
    { 936, 368, -184},
    { 992, 320, -160},
    // 27 seconds
    { 1104, 216, -192},
    { 1152, 168, -232},
    { 1224, 136, -136},
    { 1440, 320, -128},
    { 1144, 408, -224},
    { 1336, 264, -88},
    { 1368, 64, 8},
    { 1048, 120, -64},
    { 848, 192, -104},
    { 704, 112, -64},
    { 640, 120, -96},
    { 696, 96, -80},
    { 896, 96, -24},
    { 1096, 184, -24},
    { 1256, 200, 40},
    { 1208, 56, 56},
    { 1272, 56, -32},
    { 1088, -40, -16},
    { 1040, -104, -120},
    { 1296, -128, -136},
    { 1240, -88, -32},
    { 1000, 192, -128},
    { 704, 240, -168},
    { 576, 264, -144},
    { 608, 304, -128},
    // 28 seconds
    { 752, 352, -128},
    { 936, 368, -208},
    { 904, 352, -288},
    { 1024, 336, -352},
    { 1048, 312, -296},
    { 1184, 328, -184},
    { 1592, 496, -152},
    { 1096, 496, -176},
    { 1248, 440, -96},
    { 1288, 312, -24},
    { 1120, 304, -24},
    { 848, 296, -32},
    { 696, 272, -16},
    { 696, 176, -32},
    { 784, 152, -64},
    { 904, 32, -32},
    { 952, 24, -80},
    { 1120, 128, -72},
    { 1160, 56, -24},
    { 1280, 80, -64},
    { 1280, 136, -104},
    { 1032, 112, -128},
    { 1296, 16, -176},
    { 1368, 32, -88},
    { 976, 184, -152},
    // 29 seconds
    { 696, 240, -152},
    { 592, 288, -112},
    { 576, 360, -128},
    { 688, 320, -216},
    { 768, 312, -64},
    { 760, 592, -136},
    { 848, 736, -248},
    { 1016, 640, -232},
    { 1184, 584, -144},
    { 1320, 632, -112},
    { 1064, 712, -152},
    { 1312, 712, -48},
    { 1472, 576, 40},
    { 1200, 312, 40},
    { 872, 232, -72},
    { 672, 256, -64},
    { 656, 120, -32},
    { 752, 144, -48},
    { 816, 128, -24},
    { 944, 168, -24},
    { 1072, 176, -48},
    { 1088, 128, -104},
    { 1280, 184, -152},
    { 1352, 184, -128},
    { 1144, 232, -248},
    // 30 seconds
    { 1280, 128, -184},
    { 1288, 144, -48},
    { 936, 320, -64},
    { 704, 472, -64},
    { 560, 456, -136},
    { 464, 536, 104},
    { 616, 800, -120},
    { 752, 568, -152},
    { 856, 504, -232},
    { 1080, 384, -288},
    { 1104, 288, -256},
    { 1240, 368, -96},
    { 1544, 704, -96},
    { 1096, 632, -152},
    { 1352, 392, -104},
    { 1336, 160, 8},
    { 968, 64, 16},
    { 704, 32, -64},
    { 616, 32, -40},
    { 656, 24, -40},
    { 792, 56, 0},
    { 984, 160, 40},
    { 1112, 192, 32},
    { 1200, 96, 80},
    { 1080, 32, -40},
    // 31 seconds
    { 1296, 176, -184},
    { 1264, 200, -160},
    { 1456, 216, -200},
    { 1136, -80, -136},
    { 1168, 88, -32},
    { 872, 272, -64},
    { 656, 312, -128},
    { 576, 344, -112},
    { 576, 344, -80},
    { 680, 400, -144},
    { 776, 424, -208},
    { 912, 472, -248},
    { 1024, 384, -264},
    { 1144, 384, -248},
    { 1560, 456, -208},
    { 1192, 312, -128},
    { 1288, 504, -224},
    { 1376, 288, -32},
    { 1168, 256, -72},
    { 896, 248, -64},
    { 712, 72, -24},
    { 656, 8, -48},
    { 696, 120, -64},
    { 760, 128, -56},
    { 904, 80, -24},
    // 32 seconds
    { 1136, 264, -32},
    { 1136, 200, -56},
    { 1200, 224, -168},
    { 1288, 128, -104},
    { 1080, 56, -168},
    { 1160, 48, -272},
    { 1360, -16, -64},
    { 1096, 224, -120},
    { 744, 272, -152},
    { 592, 264, -144},
    { 576, 304, -152},
    { 680, 376, -160},
    { 848, 424, -248},
    { 816, 424, -280},
    { 848, 544, -304},
    { 1040, 512, -224},
    { 1216, 272, -120},
    { 1496, 376, -128},
    { 1272, 264, -112},
    { 1392, 320, -40},
    { 1360, 168, -24},
    { 1128, 72, -48},
    { 904, -40, -24},
    { 656, -16, -88},
    { 640, 48, -80},
    // 33 seconds
    { 728, 88, -64},
    { 856, 144, -168},
    { 912, 248, -160},
    { 1256, 352, -104},
    { 1160, 184, -8},
    { 1216, 80, -32},
    { 1216, 0, 64},
    { 1000, 24, -64},
    { 1144, -80, -120},
    { 1376, -88, 8},
    { 1008, 16, -96},
    { 728, 136, -128},
    { 632, 192, -120},
    { 640, 272, -136},
    { 752, 344, -128},
    { 952, 376, -264},
    { 880, 344, -208},
    { 1032, 304, -184},
    { 1072, 216, -184},
    { 1320, 320, -192},
    { 1440, 528, -288},
    { 1144, 376, -176},
    { 1312, 312, -64},
    { 1352, 240, -24},
    { 1088, 232, -40},
    // 34 seconds
    { 856, 224, -72},
    { 720, 136, -64},
    { 760, 72, -48},
    { 824, 72, -40},
    { 888, 96, -48},
    { 1016, 128, 16},
    { 1168, 48, 72},
    { 1040, -112, 16},
    { 1248, -56, -56},
    { 1248, 8, -80},
    { 1176, 40, -152},
    { 1272, -96, -144},
    { 1328, -16, -136},
    { 1008, 208, -192},
    { 760, 232, -160},
    { 624, 256, -160},
    { 632, 272, -160},
    { 744, 320, -224},
    { 832, 312, -320},
    { 824, 248, -336},
    { 968, 432, -304},
    { 1112, 488, -288},
    { 1328, 192, -208},
    { 1312, 288, -160},
    { 1120, 384, -176},
    // 35 seconds
    { 1432, 208, -168},
    { 1344, 24, -96},
    { 1056, 168, -144},
    { 816, 160, -112},
    { 680, 104, -112},
    { 752, 136, -184},
    { 896, 144, -136},
    { 976, 80, -40},
    { 992, 176, -88},
    { 1080, 224, -104},
    { 960, 176, -56},
    { 1224, 144, -88},
    { 1176, -120, 0},
    { 1136, -160, -8},
    { 1336, -104, -72},
    { 1336, -24, -80},
    { 984, 176, -112},
    { 712, 280, -152},
    { 600, 312, -208},
    { 608, 312, -216},
    { 696, 320, -272},
    { 816, 304, -280},
    { 872, 288, -296},
    { 1064, 376, -392},
    { 1128, 344, -384},
    // 36 seconds
    { 1432, 288, -264},
    { 1312, 440, -328},
    { 960, 448, -288},
    { 1248, 392, -208},
    { 1432, 232, -112},
    { 1112, 200, -128},
    { 880, 208, -120},
    { 792, 160, -136},
    { 736, 40, -64},
    { 760, 40, -56},
    { 816, 40, -24},
    { 944, 80, -40},
    { 1152, 0, -8},
    { 1112, -120, -40},
    { 1320, -88, -24},
    { 1352, -96, -48},
    { 1104, 16, -240},
    { 1344, -192, -120},
    { 1320, -184, -96},
    { 1008, 168, -256},
    { 744, 232, -240},
    { 592, 208, -216},
    { 616, 216, -216},
    { 728, 232, -256},
    { 824, 240, -376},
    // 37 seconds
    { 832, 224, -400},
    { 1088, 208, -392},
    { 1144, 168, -328},
    { 1416, 200, -208},
    { 1264, 384, -320},
    { 1112, 456, -344},
    { 1408, 352, -176},
    { 1472, 184, -48},
    { 1136, 200, -96},
    { 864, 280, -120},
    { 744, 328, -112},
    { 744, 136, -40},
    { 736, -8, -96},
    { 824, -48, -128},
    { 928, -8, -72},
    { 1128, 72, -80},
    { 1040, 80, -104},
    { 1320, 184, -160},
    { 1328, 168, -216},
    { 1136, -400, 80},
    { 1360, -520, 168},
    { 1312, -72, -16},
    { 952, 176, -136},
    { 768, 216, -120},
    { 688, 216, -120},
    // 38 seconds
    { 712, 264, -256},
    { 824, 216, -336},
    { 952, 128, -224},
    { 848, 560, -232},
    { 944, 928, -520},
    { 1024, 680, -416},
    { 1216, 464, -208},
    { 1328, 704, -304},
    { 1336, 584, -72},
    { 1392, 520, 32},
    { 1440, 416, 56},
    { 1232, 208, 56},
    { 944, 88, -8},
    { 688, 8, -64},
    { 704, 80, -96},
    { 800, 120, -96},
    { 872, 88, -56},
    { 912, 112, -72},
    { 1032, 136, -104},
    { 976, -32, -16},
    { 1328, -96, -64},
    { 1408, -96, -96},
    { 1328, -64, -240},
    { 1504, -96, -120},
    { 1328, -8, -64},
    // 39 seconds
    { 984, 264, -192},
    { 768, 360, -192},
    { 632, 384, -168},
    { 664, 424, -160},
    { 768, 464, -160},
    { 784, 456, -208},
    { 904, 496, -280},
    { 984, 400, -272},
    { 1056, 384, -184},
    { 1400, 536, -160},
    { 1168, 472, -168},
    { 1304, 536, -88},
    { 1600, 256, 96},
    { 1344, -80, 64},
    { 1016, -48, -32},
    { 720, -80, 16},
    { 624, 40, -32},
    { 680, 64, -8},
    { 824, 104, -48},
    { 1008, 200, 16},
    { 1088, 352, 0},
    { 1160, 400, 56},
    { 1240, 304, -40},
    { 1336, 120, -24},
    { 928, 40, -192},
    // 40 seconds
    { 1280, 160, -176},
    { 1464, 120, -168},
    { 1088, 144, -200},
    { 736, 344, -272},
    { 544, 176, -208},
    { 552, 192, -200},
    { 688, 192, -176},
    { 760, 256, -192},
    { 800, 400, -312},
    { 800, 424, -392},
    { 928, 272, -296},
    { 1160, 176, -200},
    { 1440, 208, -192},
    { 1168, 368, -248},
    { 1352, 384, -280},
    { 1384, 296, -168},
    { 1136, 160, -144},
    { 896, 168, -184},
    { 704, 184, -208},
    { 592, 80, -152},
    { 648, 56, -136},
    { 808, 24, -112},
    { 936, 64, -56},
    { 1112, 24, -56},
    { 1200, -40, -24},
    // 41 seconds
    { 1296, -88, -16},
    { 1424, -32, 48},
    { 1040, 16, -168},
    { 1440, -192, 48},
    { 1304, -112, 56},
    { 912, 104, -168},
    { 688, 168, -200},
    { 544, 176, -216},
    { 560, 184, -224},
    { 712, 264, -312},
    { 824, 208, -368},
    { 832, 216, -392},
    { 912, 240, -440},
    { 1000, 192, -320},
    { 1384, 264, -176},
    { 1344, 432, -312},
    { 1424, 528, -272},
    { 1472, 448, -136},
    { 1408, 280, -112},
    { 1072, 224, -136},
    { 784, 248, -200},
    { 656, 208, -160},
    { 664, 192, -176},
    { 696, 152, -160},
    { 768, 128, -136},
    // 42 seconds
    { 856, 128, -152},
    { 1008, 104, -96},
    { 1008, 48, -80},
    { 1256, -16, -56},
    { 1280, 24, -56},
    { 1304, 136, -272},
    { 1488, 24, -120},
    { 1312, 8, -56},
    { 992, 280, -280},
    { 728, 360, -288},
    { 576, 312, -272},
    { 608, 328, -264},
    { 656, 408, -328},
    { 744, 408, -400},
    { 808, 432, -472},
    { 960, 424, -440},
    { 944, 448, -384},
    { 1320, 472, -256},
    { 1256, 616, -384},
    { 1472, 680, -368},
    { 1512, 520, -112},
    { 1392, 392, -80},
    { 1072, 328, -120},
    { 824, 328, -176},
    { 720, 248, -120},
    // 43 seconds
    { 744, 184, -144},
    { 768, 184, -144},
    { 776, 160, -136},
    { 880, 136, -144},
    { 976, 32, -128},
    { 1008, -24, -64},
    { 1192, -152, -48},
    { 1368, -64, 16},
    { 1528, 248, -136},
    { 1544, 272, -80},
    { 1288, 288, -136},
    { 936, 408, -248},
    { 744, 456, -312},
    { 600, 400, -176},
    { 616, 472, -312},
    { 728, 488, -408},
    { 728, 504, -512},
    { 864, 496, -536},
    { 1008, 472, -448},
    { 1128, 504, -312},
    { 1416, 608, -312},
    { 1192, 672, -384},
    { 1440, 648, -256},
    { 1568, 528, -104},
    { 1360, 424, -136},
    // 44 seconds
    { 1120, 360, -128},
    { 920, 296, -112},
    { 776, 208, -72},
    { 712, 136, -56},
    { 744, 120, -112},
    { 800, 40, -48},
    { 928, 48, -32},
    { 968, -64, -32},
    { 1192, 0, -80},
    { 1216, 64, -32},
    { 1248, 224, -296},
    { 1512, 256, -224},
    { 1496, 264, -80},
    { 1176, 336, -208},
    { 904, 448, -312},
    { 696, 440, -208},
    { 632, 432, -192},
    { 672, 448, -216},
    { 776, 520, -368},
    { 800, 520, -416},
    { 1168, 568, -480},
    { 1104, 536, -400},
    { 1336, 592, -368},
    { 1168, 640, -416},
    { 1216, 632, -432},
    // 45 seconds
    { 1472, 496, -192},
    { 1512, 368, -32},
    { 1280, 384, -80},
    { 1032, 384, -64},
    { 912, 384, -32},
    { 848, 208, 0},
    { 768, 136, -32},
    { 752, 96, -48},
    { 768, 64, -48},
    { 912, 88, -144},
    { 968, -40, -128},
    { 1240, -144, -120},
    { 1472, 56, -96},
    { 1480, 288, -312},
    { 1504, 232, -232},
    { 1344, 176, -88},
    { 1016, 344, -248},
    { 792, 376, -224},
    { 680, 416, -184},
    { 672, 472, -208},
    { 752, 528, -248},
    { 736, 600, -208},
    { 760, 848, -440},
    { 936, 1144, -264},
    { 1240, 1128, -136},
    // 46 seconds
    { 1384, 952, -176},
    { 1312, 728, -152},
    { 1528, 608, -136},
    { 1584, 400, -8},
    { 1416, 352, -24},
    { 1104, 264, 0},
    { 864, 128, 8},
    { 712, -112, -16},
    { 760, -64, -24},
    { 792, -64, -48},
    { 840, -88, -8},
    { 928, -24, -88},
    { 928, -48, -128},
    { 1304, -8, -88},
    { 1320, 8, -88},
    { 1128, 248, -368},
    { 1360, -16, -256},
    { 1360, 32, -304},
    { 1088, 248, -456},
    { 752, 264, -368},
    { 608, 328, -248},
    { 560, 360, -200},
    { 624, 352, -200},
    { 736, 432, -312},
    { 792, 448, -288},
    // 47 seconds
    { 1000, 520, -344},
    { 1104, 464, -272},
    { 1192, 536, -272},
    { 1304, 544, -304},
    { 1184, 640, -368},
    { 1592, 568, -240},
    { 1464, 216, -88},
    { 1104, 96, -208},
    { 728, 160, -312},
    { 616, 152, -240},
    { 624, 152, -224},
    { 696, 144, -184},
    { 800, 136, -112},
    { 904, 168, -112},
    { 1048, 120, -72},
    { 1048, 136, -120},
    { 1280, 128, -48},
    { 1152, 112, -32},
    { 1184, 160, -256},
    { 1384, 24, -144},
    { 1312, -72, -64},
    { 992, 160, -264},
    { 696, 248, -256},
    { 560, 240, -240},
    { 584, 264, -240},
    // 48 seconds
    { 680, 320, -264},
    { 832, 368, -384},
    { 912, 392, -432},
    { 1064, 376, -416},
    { 1088, 360, -360},
    { 1256, 456, -272},
    { 1312, 544, -320},
    { 1216, 656, -384},
    { 1392, 624, -232},
    { 1336, 424, -64},
    { 1144, 272, -88},
    { 888, 264, -88},
    { 720, 296, -80},
    { 704, 272, -96},
    { 752, 224, -88},
    { 768, 208, -80},
    { 792, 232, -80},
    { 952, 208, -104},
    { 1032, 144, -88},
    { 1248, 152, -160},
    { 1192, 216, -192},
    { 1224, 200, -304},
    { 1432, 56, -128},
    { 1248, 16, -40},
    { 880, 288, -224},
    // 49 seconds
    { 648, 360, -264},
    { 528, 296, -192},
    { 552, 352, -232},
    { 696, 408, -256},
    { 896, 472, -408},
    { 1048, 440, -360},
    { 1240, 464, -416},
    { 1168, 496, -392},
    { 1272, 464, -336},
    { 1072, 552, -432},
    { 1288, 600, -360},
    { 1432, 456, -112},
    { 1344, 392, -144},
    { 1040, 360, -168},
    { 848, 336, -128},
    { 760, 272, -96},
    { 728, 216, -96},
    { 736, 208, -136},
    { 752, 184, -96},
    { 840, 184, -128},
    { 944, 104, -128},
    { 976, 56, -128},
    { 1280, 72, -160},
    { 1296, 152, -192},
    { 1312, 152, -232},
    // 50 seconds
    { 1464, 120, -136},
    { 1200, 192, -160},
    { 864, 344, -256},
    { 656, 392, -232},
    { 576, 392, -216},
    { 648, 416, -272},
    { 776, 424, -368},
    { 880, 488, -392},
    { 1040, 560, -504},
    { 1080, 632, -472},
    { 992, 544, -304},
    { 1192, 568, -320},
    { 1280, 688, -368},
    { 1528, 584, -160},
    { 1496, 432, -40},
    { 1448, 328, -88},
    { 1120, 320, -120},
    { 848, 304, -120},
    { 760, 248, -128},
    { 744, 184, -144},
    { 720, 144, -160},
    { 720, 104, -88},
    { 792, 168, -168},
    { 928, 192, -160},
    { 1120, 160, -144},
    // 51 seconds
    { 1288, 168, -144},
    { 1152, 320, -256},
    { 1296, 328, -368},
    { 1352, 256, -192},
    { 1104, 288, -368},
    { 800, 232, -280},
    { 688, 312, -264},
    { 664, 368, -256},
    { 704, 408, -248},
    { 776, 472, -376},
    { 808, 496, -416},
    { 984, 472, -392},
    { 1080, 504, -376},
    { 1008, 480, -296},
    { 1200, 464, -256},
    { 1160, 568, -352},
    { 1376, 624, -328},
    { 1544, 432, -56},
    { 1344, 304, -96},
    { 1000, 320, -192},
    { 800, 328, -176},
    { 696, 296, -152},
    { 696, 208, -144},
    { 712, 200, -160},
    { 712, 184, -136},
    // 52 seconds
    { 816, 376, -192},
    { 992, 160, -64},
    { 1000, -32, 32},
    { 1192, 64, -112},
    { 1304, 128, -192},
    { 1336, 40, -216},
    { 1448, -8, -72},
    { 1296, 184, -160},
    { 960, 296, -320},
    { 704, 328, -320},
    { 576, 336, -296},
    { 624, 344, -256},
    { 784, 376, -368},
    { 896, 368, -376},
    { 936, 432, -392},
    { 1000, 496, -432},
    { 984, 440, -320},
    { 1272, 424, -272},
    { 1280, 544, -368},
    { 1304, 608, -344},
    { 1352, 456, -144},
    { 1352, 320, -72},
    { 1136, 304, -64},
    { 880, 312, -56},
    { 720, 312, -72},
    // 53 seconds
    { 712, 272, -56},
    { 784, 248, -40},
    { 824, 216, -24},
    { 928, 152, -24},
    { 1000, 64, -24},
    { 1064, 40, -24},
    { 1192, 8, 8},
    { 1216, 160, -144},
    { 1416, 200, -224},
    { 1416, 80, -112},
    { 1160, 128, -208},
    { 800, 288, -320},
    { 648, 312, -304},
    { 608, 328, -328},
    { 672, 344, -296},
    { 880, 392, -408},
    { 920, 328, -352},
    { 880, 392, -448},
    { 952, 376, -424},
    { 1088, 304, -288},
    { 1456, 416, -256},
    { 1256, 560, -368},
    { 1352, 568, -280},
    { 1400, 440, -136},
    { 1240, 312, -136},
    // 54 seconds
    { 896, 296, -120},
    { 736, 320, -128},
    { 680, 288, -104},
    { 712, 232, -88},
    { 752, 224, -128},
    { 776, 208, -104},
    { 920, 184, -112},
    { 1072, 144, -120},
    { 1152, 96, -120},
    { 1224, 136, -128},
    { 1080, 216, -304},
    { 1368, 176, -208},
    { 1352, 152, -144},
    { 976, 272, -312},
    { 712, 328, -344},
    { 576, 296, -272},
    { 584, 296, -216},
    { 656, 352, -240},
    { 816, 392, -328},
    { 872, 400, -392},
    { 1152, 472, -424},
    { 1088, 496, -456},
    { 1224, 480, -400},
    { 1272, 496, -400},
    { 1168, 528, -360},
    // 55 seconds
    { 1320, 504, -256},
    { 1512, 424, -136},
    { 1232, 280, -120},
    { 872, 288, -176},
    { 744, 328, -200},
    { 704, 296, -168},
    { 664, 192, -136},
    { 712, 200, -240},
    { 784, 176, -216},
    { 920, 168, -168},
    { 992, 80, -88},
    { 1200, 104, 0},
    { 1160, 152, 40},
    { 1160, 272, -96},
    { 1288, 200, -48},
    { 1264, 200, -96},
    { 1064, 272, -272},
    { 808, 296, -288},
    { 712, 304, -320},
    { 696, 176, -272},
    { 776, 216, -320},
    { 840, 352, -480},
    { 848, 384, -504},
    { 1008, 488, -528},
    { 1080, 536, -408},
    // 56 seconds
    { 1280, 496, -336},
    { 1384, 472, -296},
    { 1184, 440, -232},
    { 1336, 384, -152},
    { 1360, 320, -32},
    { 1160, 272, -72},
    { 864, 248, -104},
    { 688, 232, -96},
    { 664, 232, -72},
    { 776, 264, -32},
    { 912, 248, -64},
    { 952, 168, -24},
    { 1024, 136, -32},
    { 1048, 128, -64},
    { 1200, 176, -88},
    { 1216, 240, -120},
    { 1168, 208, -352},
    { 1384, 88, -184},
    { 1232, 8, -112},
    { 848, 216, -256},
    { 584, 296, -256},
    { 504, 256, -208},
    { 496, 256, -176},
    { 616, 328, -240},
    { 840, 416, -328},
    // 57 seconds
    { 960, 432, -336},
    { 1032, 536, -408},
    { 1056, 520, -352},
    { 1264, 512, -296},
    { 1360, 600, -352},
    { 1264, 672, -384},
    { 1336, 496, -224},
    { 1432, 304, -112},
    { 1040, 256, -144},
    { 768, 296, -152},
    { 648, 288, -136},
    { 632, 232, -128},
    { 704, 232, -136},
    { 792, 240, -120},
    { 960, 200, -88},
    { 1136, 128, -72},
    { 1040, 128, -96},
    { 1208, 128, -152},
    { 1072, 104, -184},
    { 1216, 184, -264},
    { 1416, 184, -208},
    { 1048, 216, -280},
    { 704, 296, -328},
    { 568, 320, -296},
    { 528, 312, -264},
    // 58 seconds
    { 600, 352, -288},
    { 728, 400, -376},
    { 768, 424, -360},
    { 1008, 496, -408},
    { 1120, 512, -408},
    { 1504, 520, -328},
    { 1064, 568, -400},
    { 1120, 584, -392},
    { 1416, 496, -272},
    { 1392, 304, -128},
    { 1088, 272, -144},
    { 832, 312, -192},
    { 720, 312, -184},
    { 688, 216, -128},
    { 720, 176, -128},
    { 712, 160, -96},
    { 768, 168, -56},
    { 896, 216, -96},
    { 944, 176, -136},
    { 1368, 72, -168},
    { 1344, 0, -296},
    { 1360, 72, -376},
    { 1520, 128, -280},
    { 1272, 256, -288},
    { 832, 400, -168},
    // 59 seconds
    { 624, 512, -240},
    { 544, 408, -128},
    { 624, 328, -40},
    { 736, 408, -144},
    { 736, 480, -288},
    { 944, 536, -384},
    { 1104, 560, -528},
    { 1392, 464, -360},
    { 1224, 512, -400},
    { 1016, 600, -376},
    { 1320, 616, -232},
    { 1504, 448, -112},
    { 1208, 376, -104},
    { 976, 344, -160},
    { 816, 296, -160},
    { 816, 280, -144},
    { 880, 240, -168},
    { 912, 192, -136},
    { 912, 144, -72},
    { 984, 128, -96},
    { 920, 56, -112},
    { 1032, 80, -152},
    { 1264, 96, -152},
    { 1112, 176, -264},
    { 1336, 176, -232},
    // 60 seconds
    // elapsed: 1 minutes
    { 1352, 176, -144},
    { 1072, 248, -256},
    { 824, 344, -344},
    { 696, 360, -288},
    { 656, 344, -216},
    { 712, 392, -272},
    { 840, 424, -352},
    { 864, 424, -376},
    { 1024, 488, -480},
    { 1064, 424, -408},
    { 1056, 376, -296},
    { 1144, 440, -248},
    { 1232, 608, -352},
    { 1256, 648, -384},
    { 1336, 448, -144},
    { 1328, 304, -80},
    { 1144, 304, -152},
    { 896, 304, -80},
    { 792, 312, -80},
    { 776, 248, -56},
    { 744, 200, -48},
    { 832, 200, -56},
    { 920, 136, -32},
    { 1072, 96, 8},
    { 992, 160, -128},
    // 61 seconds
    { 1216, 168, -192},
    { 1088, 120, -216},
    { 1320, 224, -360},
    { 1448, 120, -232},
    { 1088, 184, -272},
    { 768, 248, -304},
    { 608, 312, -304},
    { 552, 336, -256},
    { 640, 336, -288},
    { 752, 344, -312},
    { 864, 360, -368},
    { 952, 400, -424},
    { 1120, 416, -488},
    { 1064, 296, -344},
    { 1208, 384, -368},
    { 1224, 512, -448},
    { 1176, 528, -376},
    { 1400, 432, -208},
    { 1352, 352, -144},
    { 1048, 320, -192},
    { 800, 312, -160},
    { 728, 304, -152},
    { 704, 264, -152},
    { 736, 224, -144},
    { 760, 184, -120},
    // 62 seconds
    { 856, 176, -120},
    { 1080, 152, -128},
    { 1000, 64, -104},
    { 1104, 136, -144},
    { 1184, 216, -208},
    { 1224, 224, -384},
    { 1376, 72, -160},
    { 1232, 120, -128},
    { 920, 320, -288},
    { 672, 392, -296},
    { 536, 376, -288},
    { 528, 296, -192},
    { 632, 320, -240},
    { 792, 392, -240},
    { 864, 424, -272},
    { 1072, 528, -376},
    { 1056, 464, -352},
    { 1360, 512, -368},
    { 1176, 664, -488},
    { 1072, 688, -504},
    { 1336, 568, -336},
    { 1392, 472, -232},
    { 1064, 384, -184},
    { 896, 336, -160},
    { 816, 296, -96},
    // 63 seconds
    { 792, 256, -24},
    { 800, 320, -112},
    { 760, 208, -96},
    { 720, 232, -136},
    { 848, 208, -232},
    { 912, 128, -296},
    { 1144, 56, -288},
    { 1216, 0, -176},
    { 1248, 40, -384},
    { 1408, 136, -320},
    { 1200, 144, -312},
    { 880, 168, -400},
    { 696, 72, -352},
    { 624, 96, -216},
    { 648, 192, -208},
    { 776, 288, -304},
    { 920, 344, -344},
    { 896, 416, -384},
    { 1000, 472, -496},
    { 1032, 384, -352},
    { 1368, 392, -312},
    { 1232, 488, -464},
    { 1200, 568, -480},
    { 1544, 328, -272},
    { 1440, 160, -200},
    // 64 seconds
    { 1072, 192, -240},
    { 872, 264, -264},
    { 736, 224, -216},
    { 664, 176, -184},
    { 616, 176, -168},
    { 616, 184, -128},
    { 592, 192, -128},
    { 712, 184, -144},
    { 960, 208, -224},
    { 1256, 264, -288},
    { 1304, 232, -240},
    { 1240, 136, -256},
    { 1464, 128, -240},
    { 1328, 104, -184},
    { 928, 160, -288},
    { 624, 216, -264},
    { 560, 232, -224},
    { 624, 288, -192},
    { 744, 376, -232},
    { 840, 408, -280},
    { 848, 416, -304},
    { 896, 424, -392},
    { 1024, 400, -376},
    { 968, 312, -264},
    { 1208, 400, -328},
    // 65 seconds
    { 1368, 560, -544},
    { 1304, 504, -400},
    { 1536, 280, -176},
    { 1392, 232, -240},
    { 1120, 240, -288},
    { 864, 200, -216},
    { 688, 176, -184},
    { 592, 152, -208},
    { 544, 144, -200},
    { 600, 176, -184},
    { 696, 192, -168},
    { 872, 232, -176},
    { 1008, 216, -184},
    { 1144, 200, -200},
    { 1464, 256, -192},
    { 1208, 288, -280},
    { 1464, 152, -304},
    { 1440, 40, -144},
    { 1024, 112, -208},
    { 672, 208, -208},
    { 520, 264, -216},
    { 496, 280, -192},
    { 584, 336, -240},
    { 728, 384, -248},
    { 800, 448, -272},
    // 66 seconds
    { 1040, 528, -312},
    { 1288, 472, -256},
    { 1616, 464, -312},
    { 1072, 448, -416},
    { 1024, 376, -400},
    { 1432, 272, -344},
    { 1472, 160, -184},
    { 1120, 224, -256},
    { 864, 280, -320},
    { 752, 248, -312},
    { 728, 208, -288},
    { 704, 176, -280},
    { 736, 152, -208},
    { 872, 200, -208},
    { 1024, 216, -208},
    { 1104, 192, -152},
    { 1192, 160, -32},
    { 1216, 208, -8},
    { 1136, 376, -312},
    { 1288, 240, -336},
    { 1344, 64, -32},
    { 1016, 88, -104},
    { 744, 248, -280},
    { 544, 336, -304},
    { 520, 248, -184},
    // 67 seconds
    { 608, 304, -248},
    { 760, 384, -320},
    { 896, 392, -336},
    { 984, 416, -376},
    { 1096, 424, -384},
    { 1096, 368, -304},
    { 1200, 400, -328},
    { 1120, 504, -440},
    { 1216, 456, -336},
    { 1408, 336, -176},
    { 1344, 336, -192},
    { 1096, 328, -224},
    { 864, 288, -184},
    { 768, 248, -176},
    { 720, 216, -192},
    { 736, 192, -192},
    { 848, 192, -192},
    { 888, 184, -232},
    { 1024, 144, -232},
    { 1064, 40, -168},
    { 1232, 72, -56},
    { 1144, 216, -40},
    { 1208, 288, -168},
    { 1432, 176, 32},
    { 1264, 160, 32},
    // 68 seconds
    { 968, 280, -264},
    { 712, 280, -272},
    { 600, 264, -248},
    { 608, 320, -280},
    { 680, 320, -336},
    { 792, 336, -368},
    { 904, 360, -384},
    { 1000, 376, -408},
    { 1096, 352, -408},
    { 1200, 312, -312},
    { 1320, 384, -336},
    { 1176, 464, -456},
    { 1288, 392, -336},
    { 1344, 256, -200},
    { 1272, 216, -200},
    { 1080, 256, -240},
    { 872, 248, -200},
    { 736, 240, -208},
    { 672, 144, -168},
    { 664, 96, -160},
    { 632, 112, -160},
    { 672, 152, -144},
    { 856, 176, -184},
    { 1056, 232, -232},
    { 1400, 248, -176},
    // 69 seconds
    { 1456, 296, -248},
    { 1200, 224, -440},
    { 1312, -72, -64},
    { 1192, -136, -88},
    { 912, 88, -336},
    { 656, 88, -272},
    { 560, 80, -312},
    { 584, 152, -304},
    { 752, 184, -336},
    { 872, 240, -360},
    { 896, 288, -416},
    { 944, 296, -488},
    { 1024, 200, -440},
    { 1064, 160, -312},
    { 1360, 312, -312},
    { 1328, 504, -592},
    { 1144, 456, -448},
    { 1408, 272, -280},
    { 1416, 136, -232},
    { 1104, 184, -360},
    { 848, 208, -352},
    { 800, 160, -296},
    { 680, 112, -256},
    { 624, 112, -224},
    { 600, 152, -160},
    // 70 seconds
    { 672, 208, -152},
    { 896, 256, -176},
    { 1040, 232, -216},
    { 1080, 128, -80},
    { 1296, 192, -160},
    { 1144, 288, -296},
    { 1296, 256, -312},
    { 1296, 256, -224},
    { 992, 264, -280},
    { 704, 304, -248},
    { 568, 360, -216},
    { 568, 392, -216},
    { 648, 384, -240},
    { 776, 392, -312},
    { 800, 432, -320},
    { 928, 488, -392},
    { 968, 536, -368},
    { 1096, 512, -320},
    { 1352, 624, -352},
    { 1408, 744, -392},
    { 1416, 672, -304},
    { 1392, 448, -168},
    { 1256, 320, -168},
    { 992, 304, -168},
    { 824, 304, -160},
    // 71 seconds
    { 752, 248, -104},
    { 736, 216, -80},
    { 712, 200, -72},
    { 664, 192, -32},
    { 736, 232, -40},
    { 896, 264, -120},
    { 1064, 280, -240},
    { 1224, 216, -120},
    { 1280, 64, -272},
    { 1288, 136, -392},
    { 1424, 112, -312},
    { 1048, 112, -224},
    { 728, 248, -240},
    { 632, 368, -224},
    { 632, 408, -192},
    { 744, 416, -216},
    { 808, 432, -264},
    { 904, 448, -312},
    { 976, 520, -400},
    { 992, 496, -400},
    { 1112, 472, -304},
    { 1384, 568, -336},
    { 1184, 648, -384},
    { 1368, 664, -312},
    { 1480, 480, -168},
    // 72 seconds
    { 1312, 312, -152},
    { 1000, 304, -160},
    { 864, 336, -152},
    { 816, 280, -96},
    { 808, 224, -104},
    { 760, 192, -96},
    { 656, 24, -32},
    { 672, -96, 16},
    { 880, 128, -160},
    { 1240, 192, -224},
    { 1496, 112, -56},
    { 1144, 272, -384},
    { 1456, 296, -296},
    { 1352, 192, -200},
    { 1008, 224, -352},
    { 720, 328, -392},
    { 576, 336, -328},
    { 600, 360, -288},
    { 720, 400, -320},
    { 840, 408, -352},
    { 880, 448, -392},
    { 944, 464, -440},
    { 936, 424, -368},
    { 1064, 392, -296},
    { 1320, 528, -296},
    // 73 seconds
    { 1208, 648, -360},
    { 1416, 648, -304},
    { 1528, 432, -104},
    { 1112, 296, -128},
    { 896, 312, -144},
    { 752, 352, -136},
    { 736, 272, -64},
    { 752, 208, -104},
    { 768, 216, -96},
    { 808, 184, -64},
    { 984, 192, -88},
    { 984, 152, -144},
    { 1128, 184, -288},
    { 1240, 160, -168},
    { 1176, 144, -288},
    { 1264, 160, -256},
    { 1192, 160, -256},
    { 848, 224, -280},
    { 664, 296, -288},
    { 600, 352, -288},
    { 656, 376, -280},
    { 808, 376, -336},
    { 896, 376, -368},
    { 952, 376, -376},
    { 1056, 448, -504},
    // 74 seconds
    { 992, 384, -424},
    { 1104, 312, -272},
    { 1296, 456, -312},
    { 1288, 640, -368},
    { 1448, 584, -200},
    { 1504, 512, -104},
    { 1224, 328, -64},
    { 976, 296, -72},
    { 800, 320, -104},
    { 728, 288, -80},
    { 712, 200, -56},
    { 704, 208, -80},
    { 808, 240, -104},
    { 976, 264, -152},
    { 1088, 176, -88},
    { 1176, 88, -128},
    { 1192, 144, -208},
    { 1104, 208, -344},
    { 1256, 184, -264},
    { 1160, 160, -168},
    { 896, 232, -264},
    { 712, 280, -272},
    { 616, 304, -216},
    { 632, 352, -208},
    { 760, 400, -256},
    // 75 seconds
    { 880, 424, -312},
    { 896, 424, -352},
    { 1024, 432, -424},
    { 1024, 392, -416},
    { 1112, 344, -320},
    { 1224, 440, -320},
    { 1112, 552, -400},
    { 1256, 616, -360},
    { 1432, 560, -208},
    { 1320, 384, -88},
    { 1024, 296, -72},
    { 880, 296, -72},
    { 800, 304, -80},
    { 800, 280, -72},
    { 848, 264, -72},
    { 864, 248, -32},
    { 960, 200, -16},
    { 1040, 136, -16},
    { 1096, 160, -64},
    { 1112, 152, -88},
    { 1024, 184, -224},
    { 1200, 160, -264},
    { 1248, 64, -152},
    { 1024, 112, -224},
    { 768, 208, -296},
    // 76 seconds
    { 672, 248, -272},
    { 624, 272, -248},
    { 704, 288, -280},
    { 840, 328, -360},
    { 880, 344, -392},
    { 1072, 376, -456},
    { 1136, 368, -472},
    { 1032, 376, -304},
    { 1160, 552, -240},
    { 1144, 824, -400},
    { 1184, 816, -336},
    { 1344, 624, -128},
    { 1424, 472, -72},
    { 1088, 344, -72},
    { 872, 352, -64},
    { 776, 328, -48},
    { 752, 256, 8},
    { 744, 288, 24},
    { 688, 232, -8},
    { 728, 104, 24},
    { 944, 120, -40},
    { 1024, 80, -56},
    { 1304, 88, -80},
    { 1296, 144, -144},
    { 1344, 184, -240},
    // 77 seconds
    { 1384, 80, -168},
    { 1216, 136, -256},
    { 880, 216, -304},
    { 704, 296, -312},
    { 616, 320, -256},
    { 680, 360, -240},
    { 784, 400, -208},
    { 776, 512, -128},
    { 880, 720, -472},
    { 1120, 112, -176},
    { 1144, 104, -304},
    { 1272, 304, -368},
    { 1272, 536, -376},
    { 1144, 328, -288},
    { 1304, 400, -200},
    { 1432, 392, -128},
    { 1176, 256, -104},
    { 872, 256, -88},
    { 696, 48, -32},
    { 576, 160, -136},
    { 704, 128, 104},
    { 920, 40, 48},
    { 1048, 72, -8},
    { 1160, 16, 32},
    { 1176, -16, -64},
    // 78 seconds
    { 1336, -16, -96},
    { 1168, -40, -192},
    { 968, 16, -200},
    { 1224, -16, -128},
    { 1256, 72, -128},
    { 976, 192, -216},
    { 712, 240, -256},
    { 576, 288, -232},
    { 592, 128, -216},
    { 728, 176, -232},
    { 864, 248, -264},
    { 920, 304, -344},
    { 1040, 352, -456},
    { 1128, 248, -504},
    { 1280, 256, -384},
    { 1336, 440, -384},
    { 1120, 464, -400},
    { 1224, 408, -328},
    { 1360, 456, -160},
    { 1192, 384, -80},
    { 840, 312, -72},
    { 704, 304, -112},
    { 680, 280, -112},
    { 752, 256, -88},
    { 856, 240, -72},
    // 79 seconds
    { 904, 216, -56},
    { 1056, 176, -88},
    { 1048, 88, -104},
    { 1200, 168, -128},
    { 1264, 24, -120},
    { 1008, 16, -176},
    { 1240, -80, -56},
    { 1216, 72, -88},
    { 952, 216, -216},
    { 760, 256, -280},
    { 656, 352, -248},
    { 648, 440, -280},
    { 728, 352, -304},
    { 856, 320, -312},
    { 840, 360, -360},
    { 976, 512, -448},
    { 984, 528, -368},
    { 1224, 640, -240},
    { 1304, 720, -240},
    { 1120, 712, -224},
    { 1240, 672, -160},
    { 1328, 576, -104},
    { 1128, 424, -80},
    { 848, 304, -40},
    { 712, 296, -88},
    // 80 seconds
    { 656, 240, -72},
    { 648, 224, -88},
    { 696, 256, -112},
    { 728, 232, -80},
    { 952, 256, -136},
    { 1104, 248, -128},
    { 1312, 208, -96},
    { 1224, 304, -280},
    { 1064, 304, -416},
    { 1296, 176, -240},
    { 1200, 160, -200},
    { 888, 280, -296},
    { 672, 312, -352},
    { 528, 272, -296},
    { 496, 208, -248},
    { 584, 376, -288},
    { 736, 496, -368},
    { 856, 448, -320},
    { 1088, 560, -368},
    { 1056, 568, -312},
    { 1264, 600, -312},
    { 1232, 592, -272},
    { 1048, 608, -288},
    { 1192, 584, -280},
    { 1400, 552, -176},
    // 81 seconds
    { 1184, 400, -136},
    { 864, 344, -144},
    { 744, 344, -192},
    { 704, 312, -144},
    { 696, 248, -120},
    { 712, 240, -120},
    { 736, 208, -96},
    { 880, 224, -184},
    { 1056, 192, -184},
    { 1192, 104, -136},
    { 1112, 160, -144},
    { 1200, 120, -264},
    { 1288, 40, -88},
    { 1304, 32, -152},
    { 1000, 152, -248},
    { 736, 232, -328},
    { 616, 232, -336},
    { 592, 264, -280},
    { 744, 344, -344},
    { 888, 376, -368},
    { 960, 392, -408},
    { 1088, 432, -440},
    { 1000, 384, -408},
    { 1192, 400, -352},
    { 1272, 480, -360},
    // 82 seconds
    { 1024, 520, -392},
    { 1312, 536, -344},
    { 1456, 440, -192},
    { 1312, 304, -128},
    { 912, 240, -128},
    { 712, 200, -160},
    { 696, 200, -128},
    { 792, 208, -96},
    { 904, 176, -104},
    { 896, 112, -128},
    { 968, 128, -104},
    { 1000, 136, -128},
    { 1064, 216, -216},
    { 1024, 256, -336},
    { 976, 400, -472},
    { 1176, 704, -792},
    { 1312, 504, -720},
    { 1032, 512, -712},
    { 880, 352, -728},
    { 792, 160, -568},
    { 640, 96, -512},
    { 632, 16, -688},
    { 592, -88, -760},
    { 560, -88, -736},
    { 568, -96, -896},
    // 83 seconds
    { 504, -104, -800},
    { 472, -104, -848},
    { 384, -80, -864},
    { 304, -40, -808},
    { 264, -16, -856},
    { 280, 8, -840},
    { 328, -56, -800},
    { 256, -16, -832},
    { 176, -56, -776},
    { 168, -160, -712},
    { 144, -160, -816},
    { 152, -280, -816},
    { 192, -240, -856},
    { 272, -264, -928},
    { 352, -232, -992},
    { 504, -320, -960},
    { 592, -264, -912},
    { 640, -176, -904},
    { 712, -168, -720},
    { 672, -128, -704},
    { 560, -88, -688},
    { 280, -112, -752},
    { 152, -136, -840},
    { 200, -72, -840},
    { 264, 32, -880},
    // 84 seconds
    { 232, 16, -864},
    { 224, -16, -944},
    { 264, -56, -1024},
    { 288, -88, -1056},
    { 256, -88, -1016},
    { 360, 80, -1120},
    { 464, 296, -992},
    { 584, 408, -984},
    { 648, 368, -776},
    { 728, 168, -592},
    { 720, 320, -744},
    { 576, 152, -576},
    { 584, 40, -600},
    { 640, 80, -536},
    { 768, 104, -512},
    { 880, 104, -456},
    { 1072, 128, -360},
    { 1272, 112, -312},
    { 1400, 88, 8},
    { 1192, 288, -80},
    { 1016, 328, -448},
    { 1144, 144, -336},
    { 1264, 48, -120},
    { 1048, 88, -256},
    { 768, 216, -336},
    // 85 seconds
    { 648, 272, -344},
    { 576, 216, -296},
    { 720, 424, -344},
    { 832, 312, -408},
    { 912, 264, -400},
    { 992, 312, -456},
    { 1040, 328, -416},
    { 1040, 264, -280},
    { 1152, 384, -328},
    { 1184, 456, -448},
    { 1328, 512, -392},
    { 1464, 464, -272},
    { 1416, 376, -184},
    { 1072, 352, -216},
    { 856, 312, -256},
    { 736, 248, -240},
    { 664, 184, -152},
    { 616, 104, -136},
    { 616, 128, -160},
    { 752, 168, -160},
    { 1016, 144, -208},
    { 1032, 128, -240},
    { 1160, 136, -144},
    { 1256, 232, -264},
    { 1240, 256, -448},
    // 86 seconds
    { 1288, 216, -368},
    { 1104, 40, -272},
    { 832, 112, -272},
    { 640, 208, -320},
    { 528, 248, -296},
    { 608, 256, -280},
    { 792, 280, -336},
    { 952, 208, -432},
    { 1000, 304, -496},
    { 1040, 384, -528},
    { 1048, 336, -392},
    { 1248, 360, -408},
    { 1160, 472, -480},
    { 1336, 464, -360},
    { 1512, 448, -224},
    { 1400, 392, -168},
    { 1016, 320, -200},
    { 800, 288, -208},
    { 728, 224, -176},
    { 712, 200, -152},
    { 712, 184, -168},
    { 696, 152, -112},
    { 808, 176, -152},
    { 976, 200, -176},
    { 1112, 224, -272},
    // 87 seconds
    { 1136, 128, -176},
    { 1152, 168, -256},
    { 1216, 184, -304},
    { 1304, 32, -112},
    { 1120, 112, -192},
    { 824, 224, -280},
    { 640, 312, -280},
    { 560, 320, -256},
    { 632, 304, -208},
    { 824, 304, -288},
    { 928, 304, -368},
    { 944, 392, -264},
    { 1048, 704, -584},
    { 984, 712, -424},
    { 1280, 592, -272},
    { 1240, 760, -352},
    { 1384, 784, -312},
    { 1464, 544, -80},
    { 1400, 440, -80},
    { 1104, 376, -144},
    { 920, 344, -72},
    { 840, 280, -8},
    { 784, 208, -64},
    { 704, 136, -104},
    { 632, 144, -40},
    // 88 seconds
    { 680, 96, -48},
    { 840, 112, -136},
    { 976, 152, -136},
    { 1152, 216, -152},
    { 1096, 312, -288},
    { 1408, 360, -400},
    { 1432, 224, -224},
    { 1192, 160, -272},
    { 800, 208, -320},
    { 648, 256, -304},
    { 600, 272, -288},
    { 656, 336, -280},
    { 808, 368, -296},
    { 904, 400, -312},
    { 1016, 472, -440},
    { 1104, 440, -464},
    { 1256, 384, -376},
    { 1328, 432, -368},
    { 960, 512, -432},
    { 1224, 560, -344},
    { 1480, 528, -184},
    { 1344, 376, -96},
    { 1016, 312, -128},
    { 872, 320, -136},
    { 784, 296, -128},
    // 89 seconds
    { 712, 224, -120},
    { 648, 160, -120},
    { 624, 144, -112},
    { 736, 168, -104},
    { 960, 200, -176},
    { 1024, 248, -264},
    { 1184, 184, -368},
    { 1184, 128, -232},
    { 1248, 248, -400},
    { 1360, 304, -224},
    { 1104, 360, -240},
    { 816, 432, -336},
    { 608, 368, -216},
    { 568, 304, -160},
    { 624, 344, -152},
    { 728, 392, -208},
    { 808, 456, -304},
    { 992, 528, -352},
    { 1120, 584, -440},
    { 1088, 592, -424},
    { 1272, 632, -424},
    { 1112, 664, -440},
    { 1160, 640, -400},
    { 1336, 520, -192},
    { 1368, 416, -128},
    // 90 seconds
    { 1064, 296, -88},
    { 864, 312, -80},
    { 760, 296, -120},
    { 736, 240, -112},
    { 760, 224, -120},
    { 792, 184, -88},
    { 848, 200, -144},
    { 944, 200, -200},
    { 1032, 168, -192},
    { 1200, 144, -120},
    { 960, 232, -336},
    { 1216, 272, -416},
    { 1312, 160, -200},
    { 1064, 216, -312},
    { 776, 328, -320},
    { 616, 368, -336},
    { 568, 344, -272},
    { 696, 360, -288},
    { 776, 392, -296},
    { 912, 464, -328},
    { 976, 584, -416},
    { 1040, 608, -360},
    { 992, 552, -296},
    { 1184, 560, -248},
    { 1232, 696, -432},
    // 91 seconds
    { 1168, 688, -392},
    { 1304, 512, -176},
    { 1440, 408, -176},
    { 1096, 368, -152},
    { 864, 336, -176},
    { 744, 264, -120},
    { 688, 216, -96},
    { 728, 176, -96},
    { 712, 176, -80},
    { 768, 208, -128},
    { 968, 232, -160},
    { 1024, 240, -232},
    { 1176, 160, -200},
    { 1192, 184, -184},
    { 1328, 160, -360},
    { 1312, -16, -216},
    { 1192, 96, -248},
    { 896, 256, -288},
    { 696, 328, -336},
    { 608, 288, -256},
    { 616, 328, -264},
    { 752, 400, -320},
    { 904, 392, -384},
    { 976, 408, -440},
    { 1032, 472, -544},
    // 92 seconds
    { 1016, 376, -456},
    { 1224, 400, -384},
    { 1288, 496, -392},
    { 1104, 472, -344},
    { 1304, 440, -224},
    { 1464, 352, -128},
    { 1232, 304, -128},
    { 960, 304, -136},
    { 784, 312, -152},
    { 704, 256, -120},
    { 712, 216, -112},
    { 744, 192, -120},
    { 760, 168, -72},
    { 896, 192, -120},
    { 976, 176, -200},
    { 1136, 160, -208},
    { 1152, 72, -160},
    { 1088, 200, -320},
    { 1400, 184, -416},
    { 1336, 48, -136},
    { 1064, 184, -296},
    { 808, 312, -376},
    { 680, 352, -320},
    { 640, 320, -272},
    { 712, 352, -304},
    // 93 seconds
    { 816, 360, -304},
    { 880, 392, -328},
    { 952, 448, -416},
    { 992, 432, -416},
    { 1152, 416, -352},
    { 1360, 496, -344},
    { 1128, 536, -392},
    { 1352, 544, -360},
    { 1408, 464, -216},
    { 1328, 400, -152},
    { 1032, 328, -136},
    { 848, 304, -152},
    { 752, 272, -104},
    { 736, 216, -88},
    { 712, 192, -112},
    { 680, 184, -104},
    { 808, 184, -88},
    { 912, 240, -168},
    { 1024, 240, -288},
    { 1152, 176, -168},
    { 1176, 208, -344},
    { 1336, 120, -296},
    { 1376, -32, -96},
    { 1096, 80, -184},
    { 840, 240, -288},
    // 94 seconds
    { 704, 280, -328},
    { 648, 248, -272},
    { 728, 312, -280},
    { 816, 376, -240},
    { 872, 440, -328},
    { 944, 528, -408},
    { 1000, 528, -504},
    { 912, 440, -368},
    { 1208, 488, -376},
    { 1312, 608, -416},
    { 1208, 672, -416},
    { 1384, 576, -240},
    { 1448, 448, -168},
    { 1168, 360, -144},
    { 936, 320, -144},
    { 848, 288, -128},
    { 760, 232, -88},
    { 720, 208, -104},
    { 704, 200, -80},
    { 800, 192, -96},
    { 928, 224, -128},
    { 960, 184, -112},
    { 1136, 184, -176},
    { 1216, 160, -264},
    { 1264, 144, -264},
    // 95 seconds
    { 1304, 88, -128},
    { 1128, 208, -296},
    { 880, 304, -384},
    { 696, 312, -336},
    { 624, 304, -304},
    { 696, 384, -304},
    { 832, 480, -344},
    { 960, 560, -368},
    { 1096, 592, -528},
    { 1000, 648, -520},
    { 1008, 568, -400},
    { 1264, 552, -336},
    { 1184, 648, -384},
    { 1352, 608, -256},
    { 1536, 472, -16},
    { 1552, 512, -104},
    { 1280, 424, -112},
    { 1048, 560, -168},
    { 896, 296, -64},
    { 712, 200, -256},
    { 704, 256, -432},
    { 712, 200, -528},
    { 704, 216, -656},
    { 656, 160, -752},
    { 832, 256, -928},
    // 96 seconds
    { 704, 208, -808},
    { 624, 72, -744},
    { 584, -80, -704},
    { 472, -104, -760},
    { 320, -104, -768},
    { 208, -128, -736},
    { 208, -144, -728},
    { 184, -104, -688},
    { 184, -168, -728},
    { 192, -224, -792},
    { 176, -200, -864},
    { 136, -176, -944},
    { 176, -104, -1072},
    { 88, -96, -1032},
    { 48, -24, -1136},
    { 56, 136, -1128},
    { 80, 304, -1192},
    { 192, 216, -1000},
    { 312, 96, -880},
    { 320, -48, -728},
    { 224, -56, -624},
    { 176, -64, -624},
    { 192, -80, -712},
    { 256, -96, -736},
    { 400, -48, -736},
    // 97 seconds
    { 560, -112, -592},
    { 816, 24, -552},
    { 1032, 216, -464},
    { 1344, 472, -400},
    { 1352, 432, -408},
    { 1576, 352, -392},
    { 1472, 352, -320},
    { 1136, 288, -320},
    { 888, 440, -520},
    { 712, 328, -320},
    { 808, 400, -440},
    { 816, 384, -496},
    { 872, 352, -600},
    { 880, 352, -664},
    { 952, 328, -600},
    { 960, 336, -464},
    { 1200, 448, -464},
    { 1200, 488, -488},
    { 1152, 504, -528},
    { 1416, 536, -424},
    { 1560, 472, -296},
    { 1304, 376, -256},
    { 1112, 336, -248},
    { 968, 272, -192},
    { 848, 216, -128},
    // 98 seconds
    { 760, 136, -80},
    { 696, 120, -104},
    { 640, 96, -88},
    { 704, 80, -120},
    { 792, 104, -152},
    { 1112, 152, -208},
    { 1368, 168, -136},
    { 1256, 192, -304},
    { 1440, 280, -384},
    { 1440, 240, -272},
    { 1120, 240, -272},
    { 888, 320, -336},
    { 720, 392, -280},
    { 672, 440, -280},
    { 760, 520, -360},
    { 864, 544, -376},
    { 896, 560, -368},
    { 928, 632, -512},
    { 920, 576, -408},
    { 1088, 472, -336},
    { 1352, 504, -272},
    { 1120, 512, -328},
    { 1344, 512, -280},
    { 1512, 472, -144},
    { 1440, 424, -128},
    // 99 seconds
    { 1112, 360, -112},
    { 896, 336, -88},
    { 776, 272, -64},
    { 792, 240, -64},
    { 808, 224, -72},
    { 776, 200, -56},
    { 800, 176, -104},
    { 888, 160, -120},
    { 1064, 128, -144},
    { 1280, 144, -96},
    { 1120, 216, -256},
    { 1384, 256, -344},
    { 1376, 184, -80},
    { 1112, 248, -216},
    { 848, 320, -400},
    { 688, 384, -320},
    { 648, 368, -280},
    { 744, 384, -280},
    { 928, 448, -352},
    { 912, 488, -376},
    { 936, 528, -520},
    { 1008, 472, -440},
    { 1072, 384, -328},
    { 1104, 456, -312},
    { 1064, 584, -456},
    // 100 seconds
    { 1320, 608, -368},
    { 1560, 480, -120},
    { 1496, 400, -80},
    { 1168, 328, -136},
    { 960, 336, -152},
    { 872, 288, -112},
    { 816, 224, -56},
    { 776, 176, -56},
    { 664, 136, -48},
    { 648, 152, -88},
    { 736, 160, -128},
    { 960, 184, -176},
    { 1208, 200, -104},
    { 1152, 256, -200},
    { 1480, 304, -216},
    { 1600, 280, -224},
    { 1312, 216, -232},
    { 1016, 352, -440},
    { 824, 336, -336},
    { 592, 352, -208},
    { 696, 664, -320},
    { 792, 672, -224},
    { 800, 592, -152},
    { 936, 656, -176},
    { 1008, 672, -168},
    // 101 seconds
    { 1104, 592, -112},
    { 1352, 616, -128},
    { 1064, 592, -216},
    { 1328, 616, -192},
    { 1480, 560, -88},
    { 1456, 472, -48},
    { 1176, 344, -48},
    { 984, 264, -32},
    { 912, 256, -72},
    { 880, 240, -96},
    { 856, 216, -112},
    { 792, 168, -48},
    { 784, 112, -120},
    { 840, 80, -96},
    { 1024, 112, -152},
    { 1192, 144, -104},
    { 1064, 240, -280},
    { 1408, 264, -384},
    { 1448, 208, -24},
    { 1192, 280, -160},
    { 928, 472, -408},
    { 728, 496, -280},
    { 656, 408, -216},
    { 712, 456, -256},
    { 808, 488, -320},
    // 102 seconds
    { 792, 504, -344},
    { 984, 544, -392},
    { 1040, 600, -344},
    { 1072, 584, -272},
    { 1224, 656, -312},
    { 1120, 720, -400},
    { 1352, 648, -360},
    { 1528, 496, -128},
    { 1440, 392, -96},
    { 1128, 360, -104},
    { 952, 360, -128},
    { 880, 304, -88},
    { 824, 264, -72},
    { 776, 192, -96},
    { 624, 48, -48},
    { 672, 80, -120},
    { 848, 136, -152},
    { 1056, 136, -264},
    { 1256, 96, -136},
    { 1288, 320, -336},
    { 1344, 104, -280},
    { 1368, 128, -184},
    { 1120, 264, -312},
    { 888, 312, -328},
    { 824, 416, -272},
    // 103 seconds
    { 744, 536, -240},
    { 784, 600, -280},
    { 872, 568, -296},
    { 920, 536, -328},
    { 1024, 528, -400},
    { 992, 496, -432},
    { 1080, 432, -360},
    { 1288, 472, -352},
    { 1128, 568, -464},
    { 1344, 552, -368},
    { 1504, 344, -72},
    { 1376, 216, -80},
    { 1024, 216, -96},
    { 792, 248, -120},
    { 704, 192, -120},
    { 752, 160, -136},
    { 856, 144, -120},
    { 992, 128, -120},
    { 1200, 48, -144},
    { 968, 16, -112},
    { 1088, 56, -224},
    { 1160, 40, -208},
    { 1128, 24, -280},
    { 1216, 80, -104},
    { 1184, 208, -160},
    // 104 seconds
    { 960, 344, -344},
    { 784, 400, -344},
    { 680, 408, -272},
    { 704, 440, -272},
    { 816, 392, -296},
    { 952, 408, -416},
    { 840, 336, -456},
    { 968, 392, -496},
    { 976, 352, -400},
    { 1272, 472, -440},
    { 1408, 720, -584},
    { 1368, 776, -384},
    { 1744, 856, -280},
    { 1800, 592, -160},
    { 1368, 560, -296},
    { 1272, 352, -96},
    { 936, 224, -88},
    { 696, 216, -200},
    { 552, 112, -304},
    { 416, 32, -384},
    { 352, 24, -448},
    { 344, 16, -632},
    { 392, -40, -808},
    { 480, -32, -888},
    { 440, 8, -912},
    // 105 seconds
    { 464, 48, -1064},
    { 544, -48, -992},
    { 440, -144, -784},
    { 368, -160, -736},
    { 264, -216, -656},
    { 232, -232, -624},
    { 192, -280, -600},
    { 216, -232, -760},
    { 192, -200, -808},
    { 200, -152, -992},
    { 208, -184, -1000},
    { 200, -152, -1016},
    { 176, -32, -1128},
    { 224, 296, -1232},
    { 192, 376, -1176},
    { 264, 208, -1048},
    { 280, -96, -856},
    { 328, -96, -824},
    { 320, 0, -800},
    { 248, -40, -784},
    { 280, 8, -832},
    { 336, -24, -800},
    { 344, -8, -736},
    { 344, 48, -736},
    { 512, -40, -688},
    // 106 seconds
    { 760, -40, -496},
    { 1112, 176, -288},
    { 1400, 296, -136},
    { 1520, 344, -256},
    { 1632, 240, -136},
    { 1480, 360, -80},
    { 1200, 464, -168},
    { 960, 752, -424},
    { 760, 496, -368},
    { 792, 560, -504},
    { 800, 384, -576},
    { 712, 288, -664},
    { 672, 312, -792},
    { 800, 280, -792},
    { 896, 376, -664},
    { 1080, 440, -640},
    { 1248, 608, -688},
    { 1280, 536, -632},
    { 1424, 456, -464},
    { 1488, 344, -296},
    { 1312, 280, -216},
    { 1000, 272, -200},
    { 784, 248, -216},
    { 736, 192, -160},
    { 744, 160, -200},
    // 107 seconds
    { 768, 104, -184},
    { 792, 96, -160},
    { 888, 96, -224},
    { 824, 48, -216},
    { 1056, 48, -320},
    { 1344, 40, -232},
    { 1136, 48, -336},
    { 1272, 112, -416},
    { 1288, 128, -296},
    { 1032, 216, -304},
    { 824, 384, -352},
    { 720, 392, -304},
    { 776, 432, -280},
    { 856, 496, -368},
    { 896, 512, -408},
    { 832, 552, -536},
    { 864, 576, -568},
    { 1008, 592, -512},
    { 968, 552, -416},
    { 1040, 624, -336},
    { 1216, 688, -400},
    { 1232, 600, -240},
    { 1368, 584, -136},
    { 1560, 464, -80},
    { 1272, 344, -72},
    // 108 seconds
    { 984, 232, -88},
    { 824, 160, -112},
    { 824, 160, -128},
    { 872, 144, -128},
    { 856, 96, -136},
    { 808, 72, -184},
    { 840, 120, -216},
    { 824, 40, -272},
    { 1136, 48, -328},
    { 1168, 96, -240},
    { 1160, 136, -312},
    { 1232, 96, -280},
    { 1304, 120, -192},
    { 1096, 160, -256},
    { 864, 240, -296},
    { 760, 240, -312},
    { 728, 312, -344},
    { 824, 304, -376},
    { 856, 336, -456},
    { 856, 376, -528},
    { 936, 384, -520},
    { 1024, 416, -456},
    { 1096, 424, -400},
    { 1376, 496, -408},
    { 1224, 432, -424},
    // 109 seconds
    { 1184, 440, -408},
    { 1400, 360, -256},
    { 1376, 288, -160},
    { 1072, 280, -168},
    { 856, 272, -152},
    { 784, 224, -120},
    { 760, 200, -104},
    { 768, 184, -128},
    { 792, 136, -112},
    { 840, 112, -80},
    { 952, 136, -104},
    { 992, 136, -152},
    { 1232, 184, -224},
    { 1192, 192, -200},
    { 1144, 144, -304},
    { 1304, 144, -216},
    { 1280, 144, -168},
    { 1024, 248, -192},
    { 776, 344, -232},
    { 680, 392, -264},
    { 632, 376, -248},
    { 704, 392, -264},
    { 800, 416, -368},
    { 800, 432, -368},
    { 872, 488, -456},
    // 110 seconds
    { 1000, 472, -424},
    { 1080, 464, -344},
    { 1400, 496, -304},
    { 1184, 568, -408},
    { 1208, 520, -328},
    { 1368, 448, -208},
    { 1424, 384, -168},
    { 1144, 328, -120},
    { 936, 296, -80},
    { 800, 264, -104},
    { 752, 248, -120},
    { 736, 224, -120},
    { 752, 200, -112},
    { 816, 176, -88},
    { 960, 168, -96},
    { 1008, 160, -104},
    { 1176, 168, -152},
    { 1136, 272, -216},
    { 1048, 288, -368},
    { 1248, 240, -248},
    { 1208, 184, -176},
    { 960, 280, -264},
    { 776, 384, -312},
    { 680, 376, -280},
    { 648, 360, -240},
    // 111 seconds
    { 696, 392, -264},
    { 808, 432, -352},
    { 848, 432, -384},
    { 1040, 432, -416},
    { 1088, 424, -400},
    { 1168, 456, -320},
    { 1304, 536, -352},
    { 1136, 656, -440},
    { 1296, 624, -360},
    { 1480, 464, -112},
    { 1376, 352, -80},
    { 1064, 320, -80},
    { 872, 336, -96},
    { 776, 296, -56},
    { 752, 232, 8},
    { 696, 192, 48},
    { 592, 168, 64},
    { 752, 176, -40},
    { 1080, 72, -32},
    { 1312, -40, -144},
    { 1344, 16, -48},
    { 1328, 224, -408},
    { 1384, 176, -336},
    { 1400, 40, -104},
    { 1152, 184, -232},
    // 112 seconds
    { 808, 304, -304},
    { 600, 328, -304},
    { 560, 312, -272},
    { 624, 336, -272},
    { 728, 368, -296},
    { 840, 424, -328},
    { 896, 520, -464},
    { 1088, 568, -584},
    { 1144, 480, -400},
    { 1264, 416, -392},
    { 1192, 408, -456},
    { 1360, 344, -336},
    { 1432, 416, -248},
    { 1416, 424, -280},
    { 1080, 440, -168},
    { 864, 384, -176},
    { 744, 296, -144},
    { 680, 248, -104},
    { 560, 208, -152},
    { 640, 240, -112},
    { 792, 208, -64},
    { 1048, 256, -144},
    { 1048, 232, -136},
    { 1128, 128, -136},
    { 1144, 144, -184},
    // 113 seconds
    { 1016, 176, -352},
    { 1152, 232, -256},
    { 1272, 272, -264},
    { 1040, 360, -376},
    { 808, 456, -536},
    { 704, 304, -392},
    { 672, 160, -256},
    { 736, 328, -384},
    { 800, 392, -432},
    { 824, 368, -408},
    { 944, 448, -480},
    { 1072, 472, -424},
    { 1120, 480, -360},
    { 1336, 520, -344},
    { 1128, 576, -432},
    { 1368, 584, -376},
    { 1528, 504, -216},
    { 1528, 352, -136},
    { 1128, 304, -136},
    { 976, 320, -168},
    { 872, 280, -144},
    { 768, 184, -128},
    { 648, 120, -88},
    { 512, 104, -96},
    { 504, 120, -88},
    // 114 seconds
    { 696, 168, -120},
    { 856, 216, -176},
    { 1200, 216, -48},
    { 1400, 248, 0},
    { 1440, 288, -304},
    { 1568, 272, -232},
    { 1440, 160, -72},
    { 1120, 216, -336},
    { 856, 368, -456},
    { 664, 304, -320},
    { 640, 288, -328},
    { 720, 360, -336},
    { 816, 400, -368},
    { 848, 408, -368},
    { 952, 448, -392},
    { 1000, 472, -424},
    { 1072, 424, -360},
    { 1232, 416, -352},
    { 1192, 504, -432},
    { 1344, 496, -336},
    { 1464, 480, -184},
    { 1488, 384, -168},
    { 1160, 304, -120},
    { 960, 304, -128},
    { 872, 272, -128},
    // 115 seconds
    { 808, 224, -120},
    { 760, 184, -112},
    { 696, 160, -104},
    { 696, 144, -96},
    { 808, 168, -120},
    { 912, 160, -136},
    { 1192, 192, -184},
    { 1304, 192, -152},
    { 1232, 280, -360},
    { 1368, 232, -280},
    { 1272, 176, -168},
    { 976, 248, -248},
    { 776, 368, -328},
    { 672, 392, -272},
    { 680, 368, -232},
    { 792, 416, -296},
    { 888, 464, -344},
    { 912, 480, -352},
    { 992, 560, -440},
    { 976, 512, -392},
    { 1160, 488, -360},
    { 1392, 568, -392},
    { 1144, 608, -408},
    { 1344, 504, -328},
    { 1472, 552, -240},
    // 116 seconds
    { 1416, 664, -352},
    { 1272, 328, -48},
    { 1128, 176, -32},
    { 1024, 312, -200},
    { 864, 200, -152},
    { 712, 184, -264},
    { 608, 144, -312},
    { 592, 112, -448},
    { 640, 144, -608},
    { 656, 104, -696},
    { 736, 88, -808},
    { 816, 112, -952},
    { 1120, -24, -744},
    { 992, -40, -560},
    { 760, -24, -520},
    { 472, -8, -464},
    { 384, 16, -448},
    { 368, 72, -416},
    { 272, 184, -480},
    { 360, 416, -768},
    { 368, 528, -864},
    { 328, 632, -1024},
    { 304, 592, -1072},
    { 312, 528, -1040},
    { 344, 424, -976},
    // 117 seconds
    { 424, 528, -1056},
    { 592, 688, -1184},
    { 744, 752, -1128},
    { 872, 640, -1032},
    { 856, 488, -896},
    { 680, 312, -696},
    { 520, 248, -568},
    { 424, 208, -520},
    { 400, 136, -464},
    { 432, 112, -472},
    { 504, 64, -416},
    { 600, 8, -304},
    { 744, 32, -224},
    { 920, 88, -216},
    { 1056, 176, -200},
    { 1344, 232, -208},
    { 1544, 336, -312},
    { 1496, 328, -360},
    { 1512, 248, -248},
    { 1344, 248, -232},
    { 1000, 368, -240},
    { 760, 488, -264},
    { 648, 488, -272},
    { 656, 456, -272},
    { 744, 400, -288},
    // 118 seconds
    { 864, 400, -360},
    { 848, 416, -424},
    { 944, 400, -440},
    { 1080, 376, -440},
    { 1248, 416, -328},
    { 1264, 544, -400},
    { 1000, 600, -440},
    { 1352, 576, -320},
    { 1728, 512, -232},
    { 1680, 360, -80},
    { 1368, 296, -40},
    { 1152, 296, -64},
    { 984, 304, -88},
    { 904, 240, -120},
    { 760, 168, -136},
    { 648, 96, -104},
    { 544, 40, -96},
    { 640, 56, -160},
    { 776, 80, -184},
    { 1112, 104, -112},
    { 1304, 144, 0},
    { 1320, 248, -200},
    { 1616, 296, -184},
    { 1640, 256, 0},
    { 1384, 328, -176},
    // 119 seconds
    { 1152, 472, -384},
    { 960, 432, -312},
    { 864, 504, -224},
    { 832, 704, -264},
    { 760, 832, -264},
    { 864, 768, -208},
    { 872, 688, -176},
    { 856, 680, -200},
    { 896, 616, -160},
    { 1184, 624, -208},
    { 1056, 664, -368},
    { 1264, 600, -304},
    { 1464, 496, -176},
    { 1592, 424, -200},
    { 1288, 360, -184},
    { 1120, 328, -192},
    { 1000, 256, -168},
    { 888, 200, -176},
    { 744, 168, -216},
    { 656, 168, -296},
    { 608, 152, -280},
    { 632, 136, -232},
    { 760, 152, -272},
    { 912, 112, -192},
    { 1264, 24, -88},
    // 120 seconds
    // elapsed: 2 minutes
    { 1408, 136, -40},
    { 1304, 320, -240},
    { 1392, 256, -216},
    { 1416, 120, -40},
    { 1152, 240, -176},
    { 864, 376, -272},
    { 744, 416, -256},
    { 680, 408, -272},
    { 752, 400, -280},
    { 872, 400, -296},
    { 912, 456, -304},
    { 856, 568, -416},
    { 968, 656, -456},
    { 952, 616, -408},
    { 1176, 536, -320},
    { 1232, 664, -344},
    { 1048, 704, -352},
    { 1240, 688, -232},
    { 1432, 624, -104},
    { 1504, 456, -40},
    { 1392, 368, -24},
    { 1280, 336, -8},
    { 1056, 328, -56},
    { 960, 288, -152},
    { 776, 240, -216},
    // 121 seconds
    { 608, 208, -280},
    { 496, 224, -304},
    { 520, 208, -296},
    { 656, 216, -344},
    { 784, 40, -216},
    { 1088, 32, -184},
    { 1344, 112, 48},
    { 1376, 376, -232},
    { 1464, 352, -200},
    { 1416, 232, -16},
    { 1208, 272, -104},
    { 1008, 400, -152},
    { 944, 488, -200},
    { 912, 456, -152},
    { 944, 520, -224},
    { 968, 584, -248},
    { 968, 640, -352},
    { 832, 624, -416},
    { 864, 640, -456},
    { 928, 592, -416},
    { 1048, 608, -328},
    { 1160, 624, -280},
    { 1088, 584, -296},
    { 1216, 544, -152},
    { 1320, 528, -80},
    // 122 seconds
    { 1512, 552, -80},
    { 1464, 464, -16},
    { 1320, 384, 24},
    { 1144, 312, 0},
    { 1008, 296, -72},
    { 872, 256, -120},
    { 736, 176, -144},
    { 680, 128, -184},
    { 664, 88, -152},
    { 832, 128, -224},
    { 856, 136, -216},
    { 1032, 112, -216},
    { 1176, 96, -168},
    { 1232, 264, -200},
    { 1216, 320, -280},
    { 1432, 296, -232},
    { 1328, 336, -168},
    { 1136, 416, -224},
    { 968, 480, -200},
    { 848, 536, -200},
    { 832, 544, -200},
    { 760, 536, -216},
    { 840, 472, -296},
    { 904, 384, -384},
    { 896, 272, -352},
    // 123 seconds
    { 936, 304, -408},
    { 936, 344, -416},
    { 1120, 408, -448},
    { 1224, 552, -648},
    { 1160, 608, -632},
    { 1376, 472, -376},
    { 1576, 264, -200},
    { 1456, 248, -104},
    { 1240, 328, -80},
    { 1120, 392, -96},
    { 1000, 408, -160},
    { 928, 288, -136},
    { 768, 240, -168},
    { 680, 176, -232},
    { 536, 128, -240},
    { 504, 112, -248},
    { 576, 152, -288},
    { 744, 168, -288},
    { 952, 144, -272},
    { 1192, 88, -208},
    { 1488, 208, -160},
    { 1224, 296, -360},
    { 1272, 248, -416},
    { 1256, 176, -264},
    { 1024, 168, -208},
    // 124 seconds
    { 944, 280, -328},
    { 896, 376, -328},
    { 840, 376, -312},
    { 856, 384, -368},
    { 840, 384, -392},
    { 824, 384, -424},
    { 824, 360, -424},
    { 864, 336, -432},
    { 832, 320, -400},
    { 880, 304, -400},
    { 904, 280, -368},
    { 992, 264, -280},
    { 1216, 328, -272},
    { 1376, 416, -344},
    { 1128, 360, -152},
    { 1384, 376, -104},
    { 1320, 384, -72},
    { 1224, 376, -120},
    { 1152, 384, -144},
    { 1096, 288, -88},
    { 1008, 232, -80},
    { 1000, 224, -120},
    { 888, 232, -80},
    { 792, 248, -72},
    { 776, 416, -128},
    // 125 seconds
    { 744, 592, -136},
    { 744, 624, -120},
    { 800, 848, -224},
    { 776, 920, -160},
    { 728, 1048, -152},
    { 728, 1016, -24},
    { 728, 1032, 48},
    { 552, 952, -16},
    { 392, 800, 64},
    { 288, 848, 48},
    { 296, 848, 80},
    { 304, 840, 144},
    { 304, 920, 128},
    { 280, 912, 128},
    { 256, 968, 72},
    { 264, 928, 88},
    { 272, 968, 80},
    { 248, 936, 32},
    { 224, 912, 16},
    { 192, 912, 24},
    { 160, 912, 40},
    { 128, 912, 48},
    { 96, 872, 40},
    { 56, 848, 48},
    { 56, 968, 88},
    // 126 seconds
    { 48, 1064, 120},
    { 24, 1144, 168},
    { 8, 1288, -40},
    { -16, 1368, -312},
    { -64, 992, -496},
    { -48, 936, -704},
    { -24, 624, -696},
    { 104, 104, -776},
    { 64, 208, -896},
    { 64, 32, -856},
    { 32, -24, -832},
    { 24, -80, -824},
    { 0, -112, -808},
    { 0, -152, -832},
    { 8, -160, -864},
    { 24, -192, -888},
    { 24, -176, -952},
    { 32, -184, -968},
    { 24, -200, -968},
    { 32, -184, -992},
    { 24, -208, -952},
    { 32, -208, -960},
    { 32, -184, -952},
    { 32, -208, -944},
    { 24, -176, -960},
    // 127 seconds
    { 24, -168, -968},
    { 24, -160, -976},
    { 24, -152, -968},
    { 32, -168, -968},
    { 24, -168, -976},
    { 24, -192, -944},
    { 32, -160, -944},
    { 24, -160, -944},
    { 0, -144, -936},
    { -24, -128, -944},
    { -16, -112, -960},
    { -16, -104, -960},
    { -24, -88, -968},
    { -32, -80, -976},
    { -32, -80, -976},
    { -56, -96, -936},
    { -72, -72, -952},
    { -72, -56, -968},
    { -56, -40, -984},
    { -72, -48, -976},
    { -72, -64, -952},
    { -88, -56, -936},
    { -88, -32, -912},
    { -96, -8, -904},
    { -72, 0, -968},
    // 128 seconds
    { -48, 16, -976},
    { -48, -40, -984},
    { -32, -48, -984},
    { -16, -32, -968},
    { 40, 8, -968},
    { 80, 16, -944},
    { 112, 24, -968},
    { 160, 8, -952},
    { 200, 24, -936},
    { 248, 64, -936},
    { 312, 64, -936},
    { 368, 72, -920},
    { 448, 152, -1024},
    { 648, 144, -1000},
    { 568, 64, -792},
    { 528, 112, -824},
    { 480, 144, -800},
    { 464, 176, -824},
    { 464, 216, -888},
    { 472, 192, -904},
    { 504, 192, -904},
    { 504, 168, -880},
    { 480, 136, -840},
    { 472, 144, -832},
    { 488, 152, -832},
    // 129 seconds
    { 520, 192, -888},
    { 536, 184, -888},
    { 536, 176, -888},
    { 520, 160, -864},
    { 536, 160, -864},
    { 536, 152, -864},
    { 528, 160, -872},
    { 544, 168, -904},
    { 528, 176, -936},
    { 496, 144, -920},
    { 464, 144, -912},
    { 440, 120, -896},
    { 416, 144, -880},
    { 384, 136, -856},
    { 328, 192, -872},
    { 288, 200, -880},
    { 240, 200, -896},
    { 200, 216, -880},
    { 152, 208, -864},
    { 88, 240, -880},
    { 16, 232, -872},
    { -48, 280, -920},
    { -112, 312, -912},
    { -136, 328, -944},
    { -136, 304, -944},
    // 130 seconds
    { -128, 280, -936},
    { -144, 168, -952},
    { -168, 240, -920},
    { -176, 200, -920},
    { -224, 240, -888},
    { -216, 240, -888},
    { -216, 224, -856},
    { -176, 232, -856},
    { -136, 280, -912},
    { -80, 264, -912},
    { -72, 224, -896},
    { -80, 200, -864},
    { -56, 208, -904},
    { -40, 304, -928},
    { 24, 112, -816},
    { 104, 88, -872},
    { 216, 80, -904},
    { 312, 80, -872},
    { 416, 128, -952},
    { 440, 120, -856},
    { 472, 136, -888},
    { 504, 176, -888},
    { 544, 176, -896},
    { 608, 176, -976},
    { 624, 136, -896},
    // 131 seconds
    { 648, 160, -888},
    { 640, 168, -864},
    { 608, 176, -824},
    { 568, 152, -824},
    { 536, 144, -824},
    { 536, 104, -808},
    { 512, 120, -848},
    { 456, 120, -872},
    { 472, 80, -792},
    { 488, 120, -784},
    { 480, 128, -880},
    { 472, 120, -856},
    { 472, 128, -840},
    { 448, 128, -848},
    { 432, 152, -824},
    { 384, 168, -816},
    { 384, 200, -872},
    { 408, 216, -840},
    { 464, 216, -880},
    { 512, 224, -864},
    { 456, 224, -824},
    { 416, 256, -856},
    { 424, 288, -880},
    { 440, 304, -912},
    { 456, 296, -952},
    // 132 seconds
    { 440, 280, -920},
    { 416, 288, -896},
    { 408, 296, -872},
    { 400, 320, -864},
    { 392, 312, -856},
    { 416, 280, -888},
    { 376, 192, -840},
    { 344, 280, -792},
    { 328, 280, -752},
    { 360, 320, -792},
    { 392, 312, -768},
    { 456, 184, -784},
    { 512, 248, -712},
    { 448, 408, -632},
    { 368, 560, -664},
    { 128, 416, -568},
    { 24, 464, -680},
    { 176, 560, -752},
    { 256, 512, -600},
    { 472, 552, -608},
    { 728, 600, -656},
    { 896, 440, -744},
    { 1040, 488, -680},
    { 1024, 352, -672},
    { 904, 272, -544},
    // 133 seconds
    { 832, 192, -480},
    { 840, 160, -528},
    { 904, 72, -480},
    { 952, 152, -656},
    { 904, 104, -584},
    { 848, 112, -576},
    { 800, 176, -544},
    { 800, 152, -568},
    { 880, 288, -608},
    { 1000, 104, -648},
    { 824, 184, -560},
    { 816, 216, -544},
    { 816, 232, -568},
    { 824, 208, -568},
    { 800, 248, -568},
    { 776, 272, -576},
    { 768, 232, -616},
    { 744, 296, -608},
    { 712, 392, -648},
    { 728, 360, -624},
    { 704, 376, -584},
    { 712, 376, -600},
    { 704, 376, -600},
    { 712, 368, -592},
    { 720, 400, -568},
    // 134 seconds
    { 720, 400, -576},
    { 720, 416, -584},
    { 736, 392, -560},
    { 736, 384, -576},
    { 752, 368, -560},
    { 752, 384, -536},
    { 760, 384, -512},
    { 768, 392, -528},
    { 688, 432, -528},
    { 760, 376, -528},
    { 744, 408, -544},
    { 736, 376, -528},
    { 768, 352, -536},
    { 736, 400, -552},
    { 744, 384, -544},
    { 744, 392, -552},
    { 744, 400, -544},
    { 744, 392, -544},
    { 744, 400, -536},
    { 752, 392, -544},
    { 760, 392, -584},
    { 728, 328, -560},
    { 752, 368, -560},
    { 752, 360, -568},
    { 736, 416, -552},
    // 135 seconds
    { 736, 408, -544},
    { 728, 400, -552},
    { 736, 400, -552},
    { 728, 400, -552},
    { 736, 408, -544},
    { 736, 408, -552},
    { 736, 400, -552},
    { 728, 400, -552},
    { 736, 400, -544},
    { 744, 400, -544},
    { 744, 400, -552},
    { 736, 392, -544},
    { 744, 392, -552},
    { 744, 392, -544},
    { 752, 392, -536},
    { 744, 400, -544},
    { 744, 392, -544},
    { 744, 392, -552},
    { 744, 392, -544},
    { 744, 392, -544},
    { 744, 392, -544},
    { 744, 392, -544},
    { 752, 392, -544},
    { 744, 384, -552},
    { 744, 384, -552},
    // 136 seconds
    { 744, 384, -544},
    { 744, 392, -552},
    { 744, 392, -552},
    { 744, 392, -544},
    { 744, 392, -552},
    { 744, 392, -552},
    { 744, 392, -552},
    { 744, 384, -552},
    { 744, 384, -544},
    { 744, 392, -552},
    { 744, 392, -544},
    { 744, 384, -544},
    { 744, 392, -544},
    { 744, 392, -552},
    { 744, 392, -552},
    { 736, 384, -552},
    { 744, 392, -552},
    { 744, 384, -552},
    { 744, 392, -552},
    { 744, 384, -544},
    { 752, 384, -560},
    { 744, 392, -552},
    { 744, 392, -552},
    { 744, 392, -552},
    { 744, 384, -544},
    // 137 seconds
    { 744, 392, -552},
    { 744, 384, -544},
    { 744, 392, -552},
    { 744, 392, -552},
    { 744, 392, -552},
    { 744, 392, -552},
    { 744, 392, -552},
    { 736, 392, -560},
    { 744, 384, -552},
    { 744, 384, -552},
    { 744, 384, -552},
    { 736, 392, -560},
    { 736, 392, -552},
    { 736, 392, -552},
    { 736, 392, -560},
    { 736, 392, -552},
    { 736, 392, -552},
    { 736, 392, -560},
    { 736, 392, -552},
    { 736, 392, -560},
    { 736, 392, -560},
    { 736, 392, -560},
    { 736, 392, -560},
    { 744, 392, -552},
    { 736, 392, -560},
    // 138 seconds
    { 744, 392, -552},
    { 736, 392, -560},
    { 736, 392, -560},
    { 736, 392, -560},
    { 744, 392, -552},
    { 744, 384, -560},
    { 728, 392, -560},
    { 736, 352, -552},
    { 720, 400, -552},
    { 704, 408, -600},
    { 696, 400, -600},
    { 672, 416, -608},
    { 688, 400, -616},
    { 680, 400, -616},
    { 680, 392, -608},
    { 680, 392, -600},
    { 672, 392, -624},
    { 672, 416, -632},
    { 664, 400, -632},
    { 672, 376, -632},
    { 680, 376, -648},
    { 688, 304, -560},
    { 624, 392, -672},
    { 632, 400, -696},
    { 608, 416, -720},
    // 139 seconds
    { 616, 368, -704},
    { 664, 352, -696},
    { 696, 352, -688},
    { 816, 312, -712},
    { 1016, 416, -768},
    { 1096, 424, -832},
    { 1008, 408, -736},
    { 912, 312, -680},
    { 840, 296, -632},
    { 840, 360, -696},
    { 712, 328, -760},
    { 672, 328, -864},
    { 624, 272, -800},
    { 672, 272, -832},
    { 600, 328, -848},
    { 512, 224, -632},
    { 632, 136, -872},
    { 560, 160, -864},
    { 536, 120, -808},
    { 448, 72, -712},
    { 416, 0, -696},
    { 304, -48, -720},
    { 208, -120, -736},
    { 176, -176, -760},
    { 160, -216, -808},
    // 140 seconds
    { 120, -328, -744},
    { 120, -248, -816},
    { 96, -192, -824},
    { 88, -256, -816},
    { 96, -176, -888},
    { 112, -144, -936},
    { 128, -192, -960},
    { 136, -160, -1008},
    { 128, -200, -944},
    { 88, -232, -968},
    { 136, -216, -984},
    { 192, -264, -944},
    { 136, -200, -928},
    { 144, -248, -896},
    { 160, -280, -912},
    { 104, -328, -912},
    { 128, -296, -936},
    { 208, -240, -944},
    { 232, -208, -936},
    { 192, -192, -920},
    { 232, -224, -904},
    { 208, -240, -880},
    { 200, -224, -904},
    { 248, -224, -928},
    { 328, -232, -928},
    // 141 seconds
    { 288, -248, -944},
    { 288, -224, -960},
    { 216, -232, -944},
    { 232, -232, -912},
    { 224, -256, -912},
    { 208, -256, -920},
    { 216, -240, -928},
    { 216, -264, -936},
    { 176, -264, -936},
    { 184, -256, -928},
    { 200, -280, -936},
    { 216, -256, -944},
    { 232, -256, -920},
    { 216, -264, -904},
    { 184, -240, -912},
    { 224, -240, -936},
    { 168, -240, -936},
    { 136, -232, -904},
    { 184, -280, -912},
    { 168, -256, -960},
    { 160, -216, -960},
    { 144, -224, -920},
    { 176, -208, -928},
    { 264, -208, -960},
    { 288, -240, -952},
    // 142 seconds
    { 224, -216, -944},
    { 272, -240, -944},
    { 248, -256, -920},
    { 296, -232, -952},
    { 240, -248, -936},
    { 312, -232, -968},
    { 192, -224, -936},
    { 288, -248, -936},
    { 200, -216, -936},
    { 224, -232, -936},
    { 232, -232, -936},
    { 248, -248, -928},
    { 240, -256, -920},
    { 256, -256, -920},
    { 240, -264, -912},
    { 216, -280, -904},
    { 280, -216, -928},
    { 280, -256, -912},
    { 264, -264, -920},
    { 208, -168, -920},
    { 224, -304, -896},
    { 248, -288, -928},
    { 264, -264, -960},
    { 280, -264, -952},
    { 272, -288, -920},
    // 143 seconds
    { 248, -264, -896},
    { 248, -256, -840},
    { 248, -272, -776},
    { 216, -328, -664},
    { 192, -248, -688},
    { 192, -232, -704},
    { 216, -256, -608},
    { 256, -256, -560},
    { 288, -184, -600},
    { 344, -128, -616},
    { 480, 144, -720},
    { 608, 488, -896},
    { 656, 528, -704},
    { 608, 656, -968},
    { 480, 448, -984},
    { 360, 312, -912},
    { 512, 200, -888},
    { 664, 104, -904},
    { 824, 168, -688},
    { 1088, 184, -640},
    { 1200, 328, -480},
    { 1160, 224, -472},
    { 1112, 208, -520},
    { 984, 144, -544},
    { 920, 176, -512},
    // 144 seconds
    { 904, 160, -496},
    { 888, 168, -488},
    { 960, 80, -552},
    { 912, 72, -536},
    { 968, 104, -776},
    { 888, 64, -536},
    { 880, 48, -512},
    { 888, 104, -608},
    { 936, 128, -616},
    { 912, 160, -576},
    { 856, 80, -528},
    { 824, 168, -560},
    { 856, 184, -528},
    { 864, 200, -504},
    { 832, 168, -536},
    { 832, 200, -528},
    { 824, 224, -528},
    { 824, 224, -544},
    { 832, 248, -552},
    { 832, 208, -528},
    { 856, 264, -512},
    { 840, 288, -512},
    { 840, 224, -472},
    { 856, 224, -488},
    { 832, 256, -512},
    // 145 seconds
    { 832, 256, -520},
    { 824, 280, -520},
    { 832, 256, -520},
    { 848, 176, -560},
    { 816, 256, -544},
    { 824, 256, -520},
    { 832, 272, -520},
    { 824, 288, -520},
    { 808, 280, -512},
    { 824, 264, -512},
    { 824, 264, -504},
    { 816, 264, -512},
    { 824, 264, -528},
    { 832, 264, -512},
    { 832, 216, -520},
    { 824, 256, -520},
    { 808, 264, -528},
    { 816, 256, -536},
    { 824, 240, -528},
    { 824, 256, -536},
    { 816, 272, -520},
    { 840, 288, -520},
    { 816, 264, -528},
    { 824, 264, -520},
    { 824, 264, -512},
    // 146 seconds
    { 832, 272, -512},
    { 832, 280, -512},
    { 832, 272, -504},
    { 832, 264, -512},
    { 832, 272, -512},
    { 824, 280, -512},
    { 832, 264, -496},
    { 832, 272, -512},
    { 824, 272, -496},
    { 832, 272, -512},
    { 832, 280, -504},
    { 832, 272, -504},
    { 824, 280, -512},
    { 848, 232, -512},
    { 840, 264, -504},
    { 832, 272, -504},
    { 832, 264, -504},
    { 832, 264, -504},
    { 832, 264, -504},
    { 832, 264, -504},
    { 832, 264, -496},
    { 840, 264, -504},
    { 840, 272, -512},
    { 824, 272, -512},
    { 840, 264, -504},
    // 147 seconds
    { 832, 272, -496},
    { 840, 272, -504},
    { 832, 272, -504},
    { 832, 272, -504},
    { 840, 272, -504},
    { 832, 272, -504},
    { 840, 264, -496},
    { 832, 272, -496},
    { 832, 264, -504},
    { 840, 264, -496},
    { 832, 264, -496},
    { 832, 272, -504},
    { 832, 272, -512},
    { 840, 272, -496},
    { 840, 272, -496},
    { 832, 272, -504},
    { 840, 272, -496},
    { 840, 272, -496},
    { 832, 264, -496},
    { 840, 264, -504},
    { 840, 264, -504},
    { 832, 264, -496},
    { 832, 264, -496},
    { 840, 264, -496},
    { 832, 272, -496},
    { 832, 272, -496},
    { 840, 264, -504},
    { 840, 272, -504},
    { 840, 264, -504},
    { 840, 264, -504},
    { 840, 272, -504},
    { 832, 272, -496},
    { 832, 272, -504},
    { 824, 264, -496},
    { 832, 272, -504},
    { 840, 280, -504},
    { 832, 272, -496},
    { 832, 264, -512},
    { 832, 264, -504},
    { 832, 264, -496},
    { 840, 264, -496},
    { 832, 264, -496},
    { 832, 264, -496},
    { 840, 272, -504},
    { 832, 272, -512},
    { 832, 272, -496},
    { 832, 272, -504},
    { 832, 280, -512},
    { 832, 280, -504},
    { 832, 280, -496},
    // 149 seconds
    { 832, 272, -504},
    { 832, 272, -504},
    { 832, 280, -496},
    { 832, 272, -504},
    { 832, 272, -504},
    { 832, 280, -504},
    { 832, 280, -496},
    { 832, 280, -496},
    { 832, 280, -504},
    { 832, 272, -496},
    { 840, 280, -496},
    { 832, 280, -496},
    { 832, 280, -496},
    { 832, 280, -496},
    { 840, 280, -496},
    { 832, 272, -496},
    { 832, 272, -496},
    { 832, 272, -504},
    { 840, 272, -496},
    { 832, 272, -504},
    { 832, 280, -496},
    { 840, 272, -496},
    { 840, 280, -504},
    { 832, 272, -504},
    { 832, 272, -496},
    { 832, 272, -496},
    { 832, 272, -496},
    { 840, 280, -496},
    { 832, 272, -496},
    { 832, 280, -504},
    { 832, 272, -512},
    { 832, 272, -496},
    { 832, 272, -504},
    { 832, 272, -496},
    { 832, 280, -504},
    { 832, 272, -504},
    { 832, 272, -496},
    { 832, 272, -504},
    { 832, 280, -504},
    { 832, 280, -496},
    { 832, 272, -496},
    { 840, 272, -496},
    { 832, 280, -504},
    { 832, 280, -504},
    { 832, 280, -496},
    { 832, 280, -496},
    { 832, 280, -504},
    { 832, 280, -496},
    { 832, 280, -496},
    { 832, 280, -496},
    // 151 seconds
    { 832, 272, -496},
    { 832, 280, -496},
    { 832, 280, -504},
    { 832, 288, -504},
    { 832, 280, -504},
    { 824, 280, -496},
    { 824, 280, -496},
    { 832, 280, -504},
    { 832, 280, -504},
    { 832, 280, -496},
    { 824, 280, -496},
    { 824, 288, -504},
    { 832, 280, -504},
    { 824, 280, -504},
    { 832, 280, -504},
    { 824, 288, -496},
    { 832, 280, -504},
    { 824, 280, -504},
    { 832, 280, -504},
    { 832, 280, -504},
    { 832, 280, -504},
    { 832, 280, -496},
    { 832, 288, -504},
    { 824, 280, -504},
    { 832, 280, -496},
    // 152 seconds
    { 832, 280, -504},
    { 824, 280, -496},
    { 832, 288, -504},
    { 832, 280, -496},
    { 832, 280, -496},
    { 824, 280, -496},
    { 824, 280, -504},
    { 832, 280, -496},
    { 832, 280, -504},
    { 824, 280, -504},
    { 824, 280, -496},
    { 832, 280, -504},
    { 832, 280, -504},
    { 832, 272, -504},
    { 832, 280, -496},
    { 832, 288, -496},
    { 832, 288, -504},
    { 824, 272, -512},
    { 824, 288, -520},
    { 824, 288, -512},
    { 824, 264, -520},
    { 816, 272, -520},
    { 816, 280, -528},
    { 808, 272, -536},
    { 800, 256, -552},
    // 153 seconds
    { 808, 256, -544},
    { 800, 264, -552},
    { 800, 248, -552},
    { 808, 232, -560},
    { 816, 224, -560},
    { 816, 232, -560},
    { 816, 224, -568},
    { 824, 200, -544},
    { 816, 192, -560},
    { 824, 208, -552},
    { 824, 184, -528},
    { 832, 200, -560},
    { 824, 176, -568},
    { 824, 168, -568},
    { 824, 136, -584},
    { 824, 152, -584},
    { 848, 128, -560},
    { 872, 208, -568},
    { 936, 152, -608},
    { 1032, 216, -640},
    { 1088, 328, -648},
    { 1160, 392, -568},
    { 1096, 272, -416},
    { 1024, 144, -576},
    { 920, 120, -704},
    // 154 seconds
    { 736, 328, -656},
    { 600, 632, -688},
    { 368, 752, -552},
    { 368, 824, -576},
    { 344, 704, -488},
    { 320, 560, -392},
    { 328, 592, -256},
    { 360, 592, -16},
    { 344, 1072, -40},
    { 384, 928, 392},
    { 296, 952, 456},
    { 216, 872, 480},
    { 144, 704, 608},
    { 208, 752, 552},
    { 200, 616, 672},
    { 224, 632, 680},
    { 240, 848, 592},
    { 232, 792, 656},
    { 264, 904, 560},
    { 192, 656, 736},
    { 176, 808, 888},
    { 160, 720, 768},
    { 160, 648, 864},
    { 56, 608, 872},
    { 8, 568, 888},
    // 155 seconds
    { -136, 704, 976},
    { -128, 568, 752},
    { -88, 720, 560},
    { -64, 704, 568},
    { -88, 848, 544},
    { -112, 936, 448},
    { -128, 984, 384},
    { -120, 824, 304},
    { -144, 848, 256},
    { -136, 1000, 152},
    { -136, 840, 168},
    { -160, 1024, 56},
    { -136, 856, 40},
    { -144, 960, 16},
    { -144, 992, 40},
    { -128, 960, 56},
    { -104, 984, 40},
    { -96, 952, 96},
    { -120, 1008, 128},
    { -120, 968, 168},
    { -112, 984, 232},
    { -104, 976, 216},
    { -128, 952, 232},
    { -136, 968, 264},
    { -128, 976, 248},
    // 156 seconds
    { -128, 976, 256},
    { -128, 1000, 240},
    { -112, 1024, 208},
    { -104, 1016, 192},
    { -128, 944, 152},
    { -144, 976, 144},
    { -160, 968, 128},
    { -168, 944, 104},
    { -192, 952, 88},
    { -192, 920, 104},
    { -208, 928, 112},
    { -192, 952, 112},
    { -184, 952, 128},
    { -152, 976, 96},
    { -160, 928, 72},
    { -176, 920, 72},
    { -184, 944, 48},
    { -184, 968, 48},
    { -184, 984, 64},
    { -176, 984, 72},
    { -168, 944, 80},
    { -192, 968, 104},
    { -176, 984, 104},
    { -168, 944, 96},
    { -168, 1000, 104},
    // 157 seconds
    { -160, 992, 128},
    { -120, 992, 112},
    { -152, 976, 88},
    { -152, 960, 136},
    { -160, 976, 144},
    { -152, 984, 160},
    { -144, 1000, 184},
    { -144, 976, 192},
    { -144, 944, 208},
    { -168, 960, 184},
    { -168, 968, 208},
    { -168, 984, 200},
    { -160, 984, 224},
    { -160, 976, 200},
    { -176, 960, 168},
    { -184, 920, 176},
    { -192, 944, 176},
    { -184, 1000, 168},
    { -184, 1000, 136},
    { -192, 936, 112},
    { -192, 968, 48},
    { -208, 952, 48},
    { -216, 936, 56},
    { -216, 936, 32},
    { -200, 960, 32},
    // 158 seconds
    { -200, 952, 40},
    { -208, 944, 40},
    { -232, 944, 40},
    { -240, 928, 56},
    { -240, 952, 56},
    { -232, 960, 64},
    { -224, 960, 64},
    { -216, 952, 64},
    { -208, 936, 56},
    { -216, 944, 48},
    { -216, 944, 48},
    { -224, 968, 56},
    { -224, 968, 56},
    { -232, 960, 64},
    { -232, 960, 64},
    { -232, 968, 64},
    { -224, 944, 88},
    { -224, 976, 96},
    { -232, 952, 80},
    { -224, 968, 88},
    { -224, 960, 88},
    { -224, 960, 96},
    { -216, 952, 80},
    { -208, 952, 72},
    { -200, 952, 72},
    // 159 seconds
    { -208, 944, 64},
    { -216, 952, 80},
    { -232, 952, 88},
    { -224, 976, 88},
    { -232, 976, 80},
    { -224, 968, 80},
    { -224, 952, 72},
    { -224, 944, 80},
    { -232, 936, 88},
    { -224, 952, 96},
    { -216, 936, 88},
    { -208, 944, 80},
    { -232, 944, 88},
    { -240, 952, 80},
    { -256, 968, 88},
    { -248, 976, 96},
    { -240, 968, 88},
    { -232, 928, 88},
    { -240, 960, 96},
    { -232, 928, 120},
    { -224, 976, 104},
    { -224, 920, 152},
    { -224, 936, 168},
    { -232, 912, 152},
    { -232, 952, 160},
    // 160 seconds
    { -240, 976, 176},
    { -240, 1000, 184},
    { -232, 968, 176},
    { -232, 944, 176},
    { -240, 952, 176},
    { -240, 960, 184},
    { -248, 944, 184},
    { -248, 944, 168},
    { -256, 936, 160},
    { -272, 928, 160},
    { -248, 928, 152},
    { -248, 936, 160},
    { -232, 920, 152},
    { -248, 920, 160},
    { -256, 936, 152},
    { -264, 936, 160},
    { -272, 944, 144},
    { -280, 920, 176},
    { -312, 936, 160},
    { -304, 928, 192},
    { -288, 944, 192},
    { -288, 920, 200},
    { -304, 888, 216},
    { -328, 928, 208},
    { -344, 896, 224},
    // 161 seconds
    { -352, 936, 216},
    { -328, 912, 216},
    { -320, 888, 208},
    { -320, 888, 200},
    { -312, 896, 200},
    { -304, 920, 192},
    { -296, 928, 176},
    { -304, 928, 168},
    { -312, 912, 192},
    { -320, 912, 208},
    { -320, 912, 216},
    { -320, 904, 216},
    { -328, 912, 216},
    { -320, 920, 216},
    { -336, 896, 216},
    { -336, 904, 224},
    { -352, 888, 224},
    { -360, 864, 224},
    { -368, 864, 224},
    { -368, 864, 224},
    { -376, 880, 248},
    { -384, 872, 240},
    { -384, 872, 224},
    { -392, 872, 224},
    { -392, 872, 216},
    { -392, 872, 216},
    { -400, 880, 224},
    { -392, 872, 224},
    { -400, 872, 232},
    { -400, 872, 224},
    { -392, 864, 232},
    { -392, 872, 232},
    { -400, 856, 232},
    { -416, 848, 232},
    { -416, 856, 248},
    { -408, 872, 240},
    { -400, 864, 248},
    { -384, 864, 248},
    { -400, 840, 248},
    { -408, 864, 240},
    { -416, 864, 248},
    { -400, 864, 264},
    { -400, 856, 280},
    { -408, 840, 304},
    { -416, 848, 296},
    { -408, 840, 288},
    { -400, 848, 296},
    { -408, 840, 288},
    { -416, 840, 288},
    { -416, 816, 296},
    // 163 seconds
    { -424, 816, 312},
    { -432, 824, 304},
    { -432, 832, 304},
    { -440, 824, 304},
    { -432, 824, 304},
    { -432, 832, 312},
    { -432, 848, 304},
    { -432, 840, 296},
    { -432, 840, 304},
    { -440, 840, 296},
    { -440, 832, 296},
    { -440, 832, 304},
    { -432, 840, 304},
    { -408, 848, 288},
    { -416, 832, 272},
    { -416, 840, 272},
    { -416, 832, 280},
    { -408, 840, 272},
    { -408, 840, 272},
    { -416, 848, 248},
    { -440, 840, 248},
    { -432, 848, 248},
    { -424, 864, 240},
    { -416, 856, 248},
    { -416, 864, 240},
    // 164 seconds
    { -408, 856, 240},
    { -408, 848, 248},
    { -424, 832, 256},
    { -424, 824, 264},
    { -424, 848, 240},
    { -416, 840, 240},
    { -432, 832, 232},
    { -416, 872, 224},
    { -424, 888, 208},
    { -424, 872, 216},
    { -424, 880, 224},
    { -432, 896, 216},
    { -432, 896, 208},
    { -408, 824, 216},
    { -408, 840, 184},
    { -424, 832, 192},
    { -432, 840, 192},
    { -432, 856, 176},
    { -424, 856, 184},
    { -432, 896, 208},
    { -408, 872, 208},
    { -408, 880, 192},
    { -400, 848, 208},
    { -400, 848, 208},
    { -408, 848, 232},
    // 165 seconds
    { -416, 864, 224},
    { -424, 872, 216},
    { -424, 872, 200},
    { -424, 872, 184},
    { -424, 864, 176},
    { -416, 896, 152},
    { -432, 888, 160},
    { -416, 880, 144},
    { -408, 888, 136},
    { -400, 872, 144},
    { -392, 872, 128},
    { -408, 864, 128},
    { -408, 888, 128},
    { -400, 864, 112},
    { -400, 888, 96},
    { -400, 872, 96},
    { -384, 864, 112},
    { -384, 904, 136},
    { -376, 888, 120},
    { -360, 888, 136},
    { -368, 896, 128},
    { -384, 896, 128},
    { -392, 912, 120},
    { -392, 872, 128},
    { -400, 912, 120},
    // 166 seconds
    { -400, 896, 136},
    { -392, 896, 128},
    { -384, 888, 128},
    { -392, 896, 120},
    { -384, 912, 136},
    { -376, 912, 112},
    { -360, 896, 96},
    { -352, 888, 56},
    { -360, 920, 32},
    { -368, 888, 40},
    { -360, 904, -8},
    { -360, 912, -8},
    { -368, 888, -16},
    { -360, 904, -32},
    { -352, 912, -48},
    { -344, 896, -56},
    { -336, 896, -64},
    { -336, 888, -64},
    { -336, 896, -72},
    { -336, 896, -72},
    { -344, 896, -64},
    { -344, 928, -56},
    { -336, 952, -56},
    { -328, 912, -40},
    { -336, 920, -16},
    // 167 seconds
    { -344, 928, 24},
    { -344, 920, 56},
    { -352, 928, 64},
    { -352, 920, 96},
    { -344, 896, 104},
    { -360, 920, 112},
    { -352, 912, 128},
    { -352, 912, 136},
    { -352, 912, 128},
    { -344, 896, 152},
    { -344, 880, 144},
    { -368, 904, 184},
    { -360, 920, 208},
    { -360, 896, 208},
    { -352, 872, 216},
    { -376, 864, 232},
    { -376, 888, 240},
    { -376, 904, 264},
    { -376, 896, 264},
    { -376, 888, 256},
    { -368, 864, 248},
    { -368, 856, 264},
    { -376, 856, 264},
    { -360, 864, 272},
    { -368, 888, 272},
    // 168 seconds
    { -376, 872, 256},
    { -376, 848, 272},
    { -392, 864, 288},
    { -392, 880, 264},
    { -376, 872, 264},
    { -368, 872, 264},
    { -376, 872, 264},
    { -368, 888, 272},
    { -360, 872, 256},
    { -360, 888, 256},
    { -368, 904, 264},
    { -368, 888, 240},
    { -360, 872, 232},
    { -344, 864, 224},
    { -360, 864, 224},
    { -368, 872, 232},
    { -368, 848, 232},
    { -376, 872, 232},
    { -384, 880, 240},
    { -384, 928, 232},
    { -384, 896, 240},
    { -368, 872, 240},
    { -376, 864, 216},
    { -376, 856, 192},
    { -384, 864, 208},
    // 169 seconds
    { -392, 904, 200},
    { -384, 920, 216},
    { -376, 912, 216},
    { -384, 928, 184},
    { -368, 808, 160},
    { -368, 816, 144},
    { -368, 880, 104},
    { -360, 888, 88},
    { -376, 928, 120},
    { -400, 912, 144},
    { -408, 888, 152},
    { -392, 872, 168},
    { -384, 864, 144},
    { -384, 880, 144},
    { -368, 880, 168},
    { -368, 880, 128},
    { -352, 928, 104},
    { -336, 904, 112},
    { -344, 896, 112},
    { -352, 880, 128},
    { -360, 888, 136},
    { -368, 912, 112},
    { -376, 920, 128},
    { -360, 896, 152},
    { -360, 896, 144},
    // 170 seconds
    { -376, 904, 144},
    { -376, 888, 160},
    { -368, 904, 144},
    { -360, 880, 144},
    { -368, 896, 152},
    { -368, 904, 192},
    { -368, 904, 184},
    { -360, 904, 168},
    { -344, 896, 184},
    { -344, 864, 184},
    { -360, 888, 192},
    { -360, 888, 208},
    { -376, 880, 216},
    { -376, 888, 232},
    { -384, 880, 240},
    { -384, 888, 232},
    { -384, 888, 232},
    { -384, 880, 240},
    { -376, 880, 232},
    { -368, 880, 232},
    { -376, 896, 224},
    { -376, 856, 200},
    { -360, 848, 200},
    { -376, 920, 200},
    { -376, 896, 184},
    // 171 seconds
    { -376, 912, 184},
    { -368, 896, 192},
    { -360, 912, 176},
    { -360, 872, 184},
    { -360, 872, 176},
    { -360, 880, 152},
    { -368, 888, 168},
    { -368, 896, 160},
    { -376, 904, 160},
    { -376, 904, 160},
    { -376, 912, 152},
    { -368, 888, 144},
    { -376, 872, 152},
    { -392, 888, 160},
    { -384, 928, 160},
    { -344, 952, 152},
    { -344, 936, 160},
    { -344, 888, 136},
    { -344, 856, 144},
    { -352, 912, 160},
    { -360, 888, 184},
    { -368, 904, 192},
    { -360, 872, 208},
    { -368, 896, 240},
    { -368, 888, 248},
    // 172 seconds
    { -384, 872, 288},
    { -376, 896, 304},
    { -368, 840, 312},
    { -368, 872, 304},
    { -360, 832, 304},
    { -368, 824, 312},
    { -368, 840, 360},
    { -392, 864, 384},
    { -384, 872, 376},
    { -368, 832, 368},
    { -368, 848, 368},
    { -368, 856, 360},
    { -360, 864, 344},
    { -360, 856, 336},
    { -368, 864, 320},
    { -360, 864, 296},
    { -360, 856, 288},
    { -368, 872, 288},
    { -368, 864, 296},
    { -368, 880, 304},
    { -352, 872, 288},
    { -352, 864, 288},
    { -352, 856, 296},
    { -344, 872, 296},
    { -352, 872, 288},
    // 173 seconds
    { -360, 848, 296},
    { -368, 856, 304},
    { -376, 848, 304},
    { -384, 864, 312},
    { -392, 880, 312},
    { -384, 880, 320},
    { -368, 864, 312},
    { -368, 872, 304},
    { -360, 864, 320},
    { -360, 856, 320},
    { -368, 864, 336},
    { -368, 872, 336},
    { -360, 872, 328},
    { -360, 832, 328},
    { -360, 816, 344},
    { -368, 832, 368},
    { -384, 832, 400},
    { -368, 848, 392},
    { -368, 864, 384},
    { -360, 832, 376},
    { -360, 848, 384},
    { -352, 856, 376},
    { -352, 848, 368},
    { -360, 848, 368},
    { -360, 848, 368},
    // 174 seconds
    { -368, 840, 368},
    { -368, 856, 360},
    { -368, 856, 360},
    { -368, 864, 352},
    { -360, 872, 336},
    { -344, 848, 320},
    { -352, 864, 296},
    { -360, 888, 288},
    { -352, 864, 264},
    { -360, 888, 272},
    { -352, 872, 240},
    { -344, 920, 176},
    { -360, 872, 208},
    { -360, 872, 208},
    { -368, 872, 240},
    { -344, 840, 224},
    { -352, 888, 160},
    { -352, 928, 176},
    { -352, 888, 192},
    { -368, 904, 232},
    { -368, 864, 208},
    { -360, 896, 208},
    { -368, 896, 232},
    { -360, 896, 192},
    { -344, 880, 168},
    // 175 seconds
    { -368, 888, 192},
    { -344, 896, 120},
    { -328, 960, 56},
    { -344, 904, 72},
    { -336, 888, 64},
    { -336, 888, 32},
    { -320, 920, -72},
    { -344, 888, -88},
    { -344, 928, -64},
    { -312, 968, -120},
    { -336, 912, -24},
    { -344, 888, -32},
    { -336, 936, -112},
    { -352, 936, -32},
    { -352, 896, -56},
    { -320, 920, -80},
    { -328, 904, -56},
    { -328, 920, -48},
    { -320, 880, -80},
    { -312, 896, -72},
    { -312, 928, -88},
    { -312, 896, -120},
    { -336, 904, -96},
    { -328, 928, -128},
    { -352, 912, -24},
    // 176 seconds
    { -336, 928, -48},
    { -328, 928, -56},
    { -320, 944, -48},
    { -312, 912, -32},
    { -296, 928, -80},
    { -312, 944, -24},
    { -288, 864, -40},
    { -272, 912, -56},
    { -280, 888, -32},
    { -288, 880, -24},
    { -296, 952, 48},
    { -288, 912, 64},
    { -296, 928, 128},
    { -312, 968, 160},
    { -320, 960, 216},
    { -320, 912, 256},
    { -320, 928, 264},
    { -304, 936, 256},
    { -320, 896, 256},
    { -320, 904, 264},
    { -304, 864, 272},
    { -320, 912, 240},
    { -304, 936, 208},
    { -288, 928, 184},
    { -288, 912, 200},
    // 177 seconds
    { -304, 912, 200},
    { -280, 912, 184},
    { -280, 904, 232},
    { -304, 920, 248},
    { -280, 936, 248},
    { -264, 848, 224},
    { -288, 912, 248},
    { -296, 896, 200},
    { -304, 896, 216},
    { -296, 904, 240},
    { -296, 912, 264},
    { -296, 912, 224},
    { -312, 896, 264},
    { -320, 920, 296},
    { -304, 864, 312},
    { -304, 864, 312},
    { -312, 904, 320},
    { -312, 864, 352},
    { -320, 888, 360},
    { -320, 856, 360},
    { -320, 848, 376},
    { -328, 864, 392},
    { -320, 864, 384},
    { -328, 864, 376},
    { -336, 864, 384},
    // 178 seconds
    { -336, 856, 392},
    { -336, 856, 400},
    { -344, 848, 384},
    { -344, 856, 392},
    { -336, 848, 384},
    { -328, 848, 384},
    { -328, 840, 392},
    { -328, 848, 408},
    { -328, 848, 416},
    { -320, 848, 400},
    { -320, 832, 392},
    { -320, 832, 400},
    { -328, 840, 392},
    { -328, 856, 384},
    { -328, 840, 392},
    { -336, 848, 384},
    { -328, 864, 376},
    { -352, 904, 360},
    { -336, 880, 352},
    { -336, 792, 376},
    { -304, 904, 336},
    { -288, 928, 296},
    { -264, 888, 304},
    { -256, 896, 296},
    { -240, 888, 296},
    // 179 seconds
    { -248, 880, 296},
    { -240, 872, 288},
    { -224, 888, 320},
    { -208, 856, 320},
    { -192, 872, 320},
    { -144, 904, 304},
    { -112, 864, 280},
    { -64, 960, 328},
    { -16, 936, 304},
    { 16, 880, 288},
    { 48, 872, 304},
    { 96, 896, 288},
    { 144, 856, 320},
    { 168, 824, 248},
    { 224, 808, 272},
    { 304, 832, 224},
    { 360, 808, 248},
    { 456, 800, 176},
    { 536, 704, 248},
    { 640, 824, 160},
    { 744, 672, 216},
    { 848, 808, 208},
    { 928, 736, 160},
    { 928, 688, 136},
    { 960, 672, 128},
    // 180 seconds
    // elapsed: 3 minutes
    { 960, 568, 112},
    { 984, 624, 80},
    { 960, 520, 112},
    { 968, 552, 72},
    { 992, 512, 120},
    { 968, 536, 72},
    { 960, 544, 96},
    { 984, 528, 80},
    { 976, 528, 72},
    { 968, 576, 72},
    { 928, 504, 48},
    { 912, 528, 88},
    { 904, 576, 88},
    { 888, 528, 96},
    { 928, 568, 80},
    { 872, 424, 48},
    { 896, 496, 24},
    { 904, 480, 40},
    { 904, 488, 24},
    { 896, 472, 32},
    { 896, 480, 24},
    { 888, 496, 16},
    { 872, 536, 0},
    { 888, 608, -32},
    { 888, 584, -24},
    // 181 seconds
    { 888, 600, -64},
    { 880, 592, -48},
    { 856, 616, -56},
    { 840, 568, -72},
    { 840, 608, -80},
    { 848, 584, -112},
    { 856, 640, -152},
    { 864, 592, -200},
    { 872, 696, -240},
    { 880, 592, -288},
    { 952, 656, -440},
    { 912, 552, -400},
    { 872, 552, -464},
    { 808, 448, -456},
    { 736, 392, -504},
    { 672, 288, -536},
    { 632, 288, -584},
    { 576, 264, -576},
    { 536, 240, -680},
    { 544, 248, -712},
    { 544, 264, -752},
    { 544, 256, -792},
    { 560, 256, -816},
    { 552, 272, -848},
    { 576, 280, -912},
    // 182 seconds
    { 552, 256, -896},
    { 520, 248, -880},
    { 456, 184, -824},
    { 416, 104, -816},
    { 376, 24, -872},
    { 360, -32, -928},
    { 392, 96, -1088},
    { 376, 64, -1120},
    { 288, 72, -944},
    { 208, 16, -904},
    { 144, -72, -896},
    { 96, -48, -816},
    { 88, 16, -896},
    { 88, -64, -864},
    { -32, -32, -872},
    { 8, -128, -904},
    { 0, -176, -912},
    { -40, -200, -912},
    { -72, -208, -944},
    { -48, -216, -920},
    { -72, -256, -928},
    { -88, -272, -912},
    { -72, -248, -912},
    { -88, -264, -904},
    { -128, -320, -872},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

