/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured: 2015-10-07 13:47:46 local
AccelRawData *activity_sample_walk_200_pbl_25820_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25820_9
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 184, 8, -968},
    { 184, 0, -968},
    { 192, -24, -960},
    { 168, -8, -968},
    { 128, -16, -968},
    { 176, -40, -984},
    { 152, -40, -968},
    { 160, 0, -968},
    { 216, -56, -1144},
    { -104, -328, -952},
    { 136, -32, -960},
    { 184, -16, -976},
    { 184, 8, -960},
    { 176, -16, -960},
    { 168, -32, -936},
    { 176, -24, -936},
    { 176, -8, -928},
    { 200, -48, -904},
    { 256, -32, -872},
    { 272, -48, -896},
    { 304, 56, -848},
    { 264, 144, -832},
    { 264, 192, -936},
    { 280, 160, -944},
    { 320, 152, -960},
    // 1 seconds
    { 272, 176, -920},
    { 256, 208, -872},
    { 328, 288, -840},
    { 344, 376, -840},
    { 352, 352, -816},
    { 336, 336, -808},
    { 344, 368, -792},
    { 360, 400, -816},
    { 336, 432, -760},
    { 288, 480, -728},
    { 304, 488, -784},
    { 304, 480, -792},
    { 288, 512, -744},
    { 504, 600, -776},
    { 512, 664, -824},
    { 552, 656, -832},
    { 480, 528, -744},
    { 352, 512, -696},
    { 280, 552, -632},
    { 384, 608, -672},
    { 528, 624, -720},
    { 520, 552, -720},
    { 440, 456, -696},
    { 352, 432, -592},
    { 312, 392, -544},
    // 2 seconds
    { 328, 440, -560},
    { 336, 440, -608},
    { 360, 472, -672},
    { 320, 456, -616},
    { 272, 456, -592},
    { 280, 512, -680},
    { 480, 560, -784},
    { 760, 704, -896},
    { 728, 680, -992},
    { 608, 488, -888},
    { 568, 280, -712},
    { 568, 352, -624},
    { 648, 416, -648},
    { 544, 352, -600},
    { 392, 288, -584},
    { 272, 232, -576},
    { 272, 336, -608},
    { 264, 392, -640},
    { 280, 408, -696},
    { 336, 488, -792},
    { 448, 528, -856},
    { 544, 640, -928},
    { 760, 680, -1040},
    { 608, 488, -824},
    { 504, 536, -728},
    // 3 seconds
    { 416, 512, -640},
    { 560, 640, -728},
    { 552, 488, -648},
    { 392, 368, -616},
    { 448, 464, -632},
    { 304, 288, -544},
    { 224, 352, -640},
    { 184, 336, -720},
    { 344, 392, -696},
    { 392, 392, -784},
    { 304, 368, -768},
    { 464, 496, -992},
    { 472, 496, -936},
    { 480, 560, -808},
    { 416, 488, -752},
    { 440, 456, -688},
    { 536, 552, -712},
    { 408, 416, -640},
    { 256, 288, -536},
    { 176, 288, -488},
    { 184, 392, -568},
    { 248, 464, -656},
    { 264, 568, -760},
    { 296, 592, -848},
    { 328, 672, -896},
    // 4 seconds
    { 792, 888, -1032},
    { 712, 760, -808},
    { 560, 712, -816},
    { 488, 640, -696},
    { 528, 600, -720},
    { 448, 464, -616},
    { 376, 440, -600},
    { 248, 328, -528},
    { 256, 376, -472},
    { 296, 432, -544},
    { 296, 440, -656},
    { 296, 504, -672},
    { 352, 552, -720},
    { 408, 664, -840},
    { 496, 456, -768},
    { 272, 432, -744},
    { 480, 576, -760},
    { 640, 600, -784},
    { 464, 416, -712},
    { 368, 440, -720},
    { 320, 336, -592},
    { 224, 288, -528},
    { 176, 336, -560},
    { 144, 352, -592},
    { 240, 520, -712},
    // 5 seconds
    { 256, 584, -736},
    { 304, 600, -824},
    { 456, 712, -976},
    { 600, 736, -856},
    { 432, 680, -744},
    { 360, 624, -672},
    { 448, 696, -696},
    { 528, 576, -656},
    { 368, 384, -584},
    { 240, 352, -528},
    { 216, 416, -496},
    { 256, 416, -512},
    { 328, 464, -520},
    { 360, 488, -528},
    { 448, 560, -584},
    { 648, 464, -728},
    { 832, 392, -848},
    { 672, 392, -720},
    { 600, 624, -720},
    { 640, 488, -520},
    { 800, 544, -624},
    { 584, 432, -544},
    { 424, 240, -400},
    { 360, 248, -360},
    { 464, 248, -464},
    // 6 seconds
    { 520, 256, -472},
    { 672, 360, -552},
    { 784, 464, -624},
    { 864, 384, -576},
    { 1104, 392, -608},
    { 1032, 400, -504},
    { 952, 328, -504},
    { 944, 216, -320},
    { 1040, 280, -408},
    { 952, 224, -352},
    { 760, 192, -296},
    { 656, 96, -184},
    { 696, 136, -216},
    { 768, 128, -224},
    { 816, 104, -224},
    { 936, 112, -384},
    { 1120, -8, -328},
    { 1368, 8, -408},
    { 1248, 168, -384},
    { 776, 240, -376},
    { 888, 144, -408},
    { 944, 160, -344},
    { 832, 88, -312},
    { 720, 72, -376},
    { 616, 40, -240},
    // 7 seconds
    { 536, 48, -232},
    { 552, 56, -200},
    { 680, 112, -288},
    { 808, 144, -344},
    { 920, 200, -440},
    { 1088, 48, -440},
    { 1552, 8, -520},
    { 1288, 128, -440},
    { 1048, 72, -384},
    { 1032, 56, -336},
    { 1144, 40, -328},
    { 1008, 48, -272},
    { 744, 64, -240},
    { 608, 48, -208},
    { 592, -48, -184},
    { 656, -32, -184},
    { 760, -8, -184},
    { 864, -80, -184},
    { 1216, -136, -288},
    { 1728, -144, -344},
    { 1360, 64, -232},
    { 1000, 8, -384},
    { 1000, 40, -480},
    { 944, -80, -344},
    { 808, -80, -280},
    // 8 seconds
    { 616, 40, -256},
    { 544, 16, -240},
    { 608, 104, -280},
    { 680, 104, -320},
    { 728, 184, -336},
    { 856, 208, -416},
    { 1040, 224, -432},
    { 1200, 240, -416},
    { 1280, 184, -480},
    { 944, 216, -296},
    { 1024, 104, -456},
    { 1144, 128, -336},
    { 992, 144, -368},
    { 720, 152, -376},
    { 640, 120, -312},
    { 664, 176, -280},
    { 712, 216, -352},
    { 768, 240, -344},
    { 760, 312, -360},
    { 816, 376, -464},
    { 920, 424, -464},
    { 1080, 504, -600},
    { 792, 456, -536},
    { 712, 408, -632},
    { 736, 432, -664},
    // 9 seconds
    { 672, 456, -592},
    { 504, 376, -528},
    { 440, 408, -456},
    { 336, 384, -480},
    { 272, 456, -488},
    { 192, 504, -544},
    { 136, 640, -648},
    { 136, 656, -728},
    { 104, 728, -680},
    { 160, 952, -904},
    { 64, 776, -552},
    { 48, 928, -584},
    { 72, 888, -472},
    { 152, 984, -440},
    { 64, 672, -288},
    { 16, 584, -352},
    { 8, 624, -272},
    { 48, 816, -208},
    { 24, 712, -360},
    { -32, 736, -248},
    { 0, 848, -288},
    { -24, 1024, -464},
    { 80, 1000, -432},
    { -40, 848, -416},
    { 112, 888, -528},
    // 10 seconds
    { 136, 864, -432},
    { 104, 920, -440},
    { -72, 592, -408},
    { -64, 408, -8},
    { -48, 704, -184},
    { -32, 784, -184},
    { -112, 880, -216},
    { -96, 928, -368},
    { -24, 1056, -368},
    { -184, 1200, -416},
    { 112, 1184, -328},
    { 24, 1080, -312},
    { 8, 976, -152},
    { 48, 1040, -224},
    { 104, 856, -192},
    { 64, 752, -392},
    { -40, 520, -96},
    { -24, 648, -272},
    { -8, 632, -96},
    { 24, 816, -288},
    { 64, 976, -296},
    { 48, 1064, -360},
    { 232, 1104, -424},
    { 144, 1152, -496},
    { 192, 960, -480},
    // 11 seconds
    { 120, 792, -504},
    { 8, 608, -336},
    { -56, 536, -280},
    { -72, 536, -176},
    { -96, 664, -264},
    { -104, 784, -272},
    { -136, 904, -368},
    { -96, 1040, -504},
    { -96, 1064, -488},
    { 136, 1304, -672},
    { 24, 1024, -368},
    { 16, 1024, -400},
    { 40, 960, -320},
    { 152, 984, -488},
    { 72, 704, -368},
    { -8, 520, -288},
    { -40, 512, -328},
    { -48, 576, -296},
    { 0, 664, -272},
    { 16, 896, -432},
    { 88, 904, -440},
    { 32, 1048, -728},
    { 160, 968, -512},
    { 112, 1032, -696},
    { 168, 848, -576},
    // 12 seconds
    { 136, 760, -568},
    { 24, 632, -432},
    { -24, 512, -312},
    { -56, 520, -304},
    { -104, 552, -248},
    { -120, 720, -392},
    { -168, 848, -368},
    { -88, 1008, -536},
    { -72, 1112, -608},
    { 64, 1240, -656},
    { 128, 1112, -528},
    { 96, 1040, -368},
    { 96, 1000, -360},
    { 40, 776, -256},
    { 56, 664, -272},
    { -16, 632, -472},
    { -56, 544, -192},
    { -8, 712, -240},
    { 16, 736, -304},
    { 32, 840, -336},
    { 160, 968, -464},
    { 120, 1136, -568},
    { 160, 744, -488},
    { 56, 968, -592},
    { 160, 1000, -496},
    // 13 seconds
    { 184, 912, -504},
    { 32, 576, -416},
    { -32, 488, -328},
    { -64, 480, -280},
    { -72, 592, -240},
    { -136, 808, -416},
    { -160, 856, -440},
    { -120, 1072, -576},
    { -152, 1104, -584},
    { 112, 1144, -616},
    { 88, 1168, -504},
    { 168, 1096, -488},
    { 144, 976, -488},
    { 48, 784, -416},
    { 0, 584, -320},
    { -32, 440, -312},
    { -32, 496, -240},
    { -8, 648, -336},
    { 24, 768, -344},
    { 96, 952, -520},
    { 120, 968, -520},
    { 272, 1088, -736},
    { 208, 920, -528},
    { 144, 952, -592},
    { 240, 920, -600},
    // 14 seconds
    { 136, 712, -488},
    { -8, 536, -384},
    { -56, 472, -296},
    { -96, 528, -288},
    { -136, 608, -336},
    { -136, 776, -368},
    { -168, 912, -504},
    { -16, 1072, -648},
    { -120, 1208, -704},
    { 88, 992, -512},
    { 56, 1040, -536},
    { 96, 1032, -416},
    { 104, 848, -360},
    { 128, 728, -416},
    { 64, 568, -344},
    { 32, 520, -312},
    { 0, 592, -264},
    { 56, 744, -344},
    { 104, 864, -464},
    { 160, 912, -400},
    { 104, 1096, -760},
    { 216, 976, -552},
    { 88, 952, -584},
    { 128, 952, -664},
    { 128, 784, -512},
    // 15 seconds
    { 72, 656, -456},
    { -48, 456, -288},
    { -56, 480, -264},
    { -88, 552, -168},
    { -112, 744, -320},
    { -152, 936, -488},
    { -96, 1040, -568},
    { -136, 1080, -672},
    { 168, 1176, -664},
    { 64, 1088, -568},
    { 112, 1048, -480},
    { 192, 944, -472},
    { 160, 784, -464},
    { 32, 552, -376},
    { 0, 456, -312},
    { -8, 520, -352},
    { -8, 640, -352},
    { 24, 768, -392},
    { 56, 912, -520},
    { 144, 968, -552},
    { 304, 1048, -712},
    { 128, 936, -560},
    { 128, 920, -584},
    { 240, 816, -584},
    { 144, 664, -512},
    // 16 seconds
    { 40, 528, -392},
    { -24, 472, -296},
    { -96, 560, -256},
    { -88, 744, -336},
    { -104, 736, -392},
    { -128, 800, -528},
    { -72, 816, -672},
    { -40, 984, -776},
    { 344, 1176, -760},
    { 200, 1064, -616},
    { 184, 1000, -488},
    { 176, 976, -472},
    { 176, 824, -488},
    { 48, 528, -416},
    { -40, 416, -336},
    { -40, 512, -312},
    { 8, 656, -336},
    { 80, 768, -448},
    { 88, 832, -472},
    { 208, 888, -536},
    { 304, 1136, -664},
    { 224, 1064, -600},
    { 216, 1032, -648},
    { 184, 776, -576},
    { 120, 656, -528},
    // 17 seconds
    { 8, 560, -376},
    { -56, 488, -312},
    { -96, 504, -280},
    { -112, 608, -280},
    { -160, 704, -384},
    { -168, 872, -512},
    { -112, 976, -528},
    { -48, 896, -680},
    { 144, 1120, -616},
    { 112, 1192, -488},
    { 184, 1064, -536},
    { 248, 1184, -600},
    { 152, 872, -368},
    { 56, 584, -408},
    { -32, 392, -272},
    { 16, 472, -288},
    { 8, 664, -320},
    { 72, 784, -384},
    { 112, 840, -528},
    { 88, 872, -568},
    { 280, 1064, -592},
    { 176, 1008, -688},
    { 104, 960, -640},
    { 224, 920, -624},
    { 160, 736, -520},
    // 18 seconds
    { 96, 600, -352},
    { -16, 424, -352},
    { -48, 416, -288},
    { -96, 552, -280},
    { -136, 752, -384},
    { -160, 856, -504},
    { -200, 912, -552},
    { -128, 1032, -672},
    { 160, 1344, -640},
    { 104, 1056, -432},
    { 120, 1008, -440},
    { 216, 1064, -440},
    { 184, 872, -456},
    { 88, 664, -424},
    { 16, 392, -360},
    { 0, 400, -256},
    { -40, 544, -264},
    { 0, 672, -328},
    { 56, 864, -520},
    { 128, 928, -536},
    { 56, 1120, -720},
    { 280, 1248, -688},
    { 144, 1112, -608},
    { 128, 680, -560},
    { 136, 576, -568},
    // 19 seconds
    { 88, 696, -520},
    { 8, 488, -368},
    { -56, 400, -344},
    { -120, 528, -344},
    { -160, 648, -392},
    { -144, 888, -528},
    { -48, 952, -584},
    { 0, 1048, -568},
    { 208, 1360, -664},
    { 144, 1136, -512},
    { 200, 1168, -456},
    { 240, 1104, -416},
    { 216, 712, -512},
    { 80, 456, -456},
    { 32, 448, -336},
    { -8, 504, -280},
    { 8, 544, -352},
    { 16, 672, -432},
    { 0, 752, -472},
    { 88, 936, -632},
    { 88, 1104, -712},
    { 248, 944, -536},
    { 200, 952, -632},
    { 176, 824, -576},
    { 136, 736, -608},
    // 20 seconds
    { 64, 616, -416},
    { -16, 416, -328},
    { -48, 440, -280},
    { -88, 544, -248},
    { -96, 704, -360},
    { -136, 760, -464},
    { -88, 976, -632},
    { -40, 1120, -504},
    { 96, 1432, -544},
    { 120, 1112, -440},
    { 152, 1096, -392},
    { 160, 1104, -272},
    { 96, 832, -416},
    { -72, 584, -432},
    { -48, 440, -352},
    { -64, 488, -280},
    { -96, 544, -232},
    { -24, 688, -336},
    { -24, 808, -384},
    { 64, 968, -600},
    { 16, 1080, -672},
    { 168, 1112, -528},
    { 184, 984, -568},
    { 280, 744, -464},
    { 216, 768, -432},
    // 21 seconds
    { 80, 832, -440},
    { -40, 472, -400},
    { -56, 400, -328},
    { -104, 528, -304},
    { -72, 736, -416},
    { -88, 808, -512},
    { 48, 1008, -648},
    { 32, 1096, -640},
    { 208, 1232, -696},
    { 72, 992, -456},
    { 104, 1008, -480},
    { 192, 1032, -424},
    { 216, 872, -456},
    { 136, 720, -424},
    { 64, 512, -320},
    { 40, 488, -328},
    { 32, 504, -248},
    { 56, 624, -400},
    { 96, 776, -472},
    { 144, 944, -568},
    { 240, 1104, -600},
    { 280, 1136, -696},
    { 200, 1032, -712},
    { 200, 792, -608},
    { 200, 768, -544},
    // 22 seconds
    { 128, 704, -392},
    { 40, 520, -320},
    { -32, 416, -288},
    { -64, 456, -224},
    { -80, 664, -344},
    { -152, 768, -424},
    { -160, 896, -504},
    { -56, 984, -640},
    { -88, 1144, -664},
    { 216, 1224, -608},
    { 184, 1184, -552},
    { 208, 1096, -440},
    { 272, 1024, -456},
    { 216, 800, -432},
    { 96, 560, -376},
    { 40, 456, -336},
    { -8, 504, -264},
    { 24, 584, -296},
    { 56, 696, -352},
    { 96, 856, -576},
    { 128, 920, -600},
    { 192, 1112, -688},
    { 192, 1024, -672},
    { 192, 984, -648},
    { 256, 832, -624},
    // 23 seconds
    { 200, 752, -576},
    { 96, 632, -384},
    { -8, 432, -280},
    { -56, 456, -272},
    { -80, 568, -248},
    { -112, 704, -400},
    { -128, 760, -472},
    { -104, 896, -576},
    { -32, 984, -632},
    { 88, 1216, -704},
    { 48, 1136, -560},
    { 120, 992, -536},
    { 224, 1088, -520},
    { 224, 920, -488},
    { 120, 616, -432},
    { 32, 464, -400},
    { 0, 432, -296},
    { 16, 568, -320},
    { 56, 696, -416},
    { 104, 744, -392},
    { 208, 888, -600},
    { 224, 976, -624},
    { 184, 1112, -576},
    { 200, 1096, -656},
    { 184, 744, -528},
    // 24 seconds
    { 224, 776, -608},
    { 96, 664, -408},
    { 32, 512, -296},
    { -16, 448, -208},
    { 24, 584, -240},
    { -144, 784, -352},
    { -168, 928, -392},
    { -152, 1024, -568},
    { -216, 1056, -624},
    { 24, 1320, -416},
    { 48, 1224, -432},
    { 120, 1136, -416},
    { 160, 984, -288},
    { 144, 816, -296},
    { 88, 608, -352},
    { 24, 424, -168},
    { -88, 504, -192},
    { -16, 504, -400},
    { 72, 728, -352},
    { 40, 864, -568},
    { 72, 880, -624},
    { 128, 984, -680},
    { 200, 1240, -504},
    { 184, 1144, -616},
    { 152, 920, -512},
    // 25 seconds
    { 160, 728, -600},
    { 16, 568, -392},
    { -32, 464, -280},
    { -32, 496, -272},
    { -88, 464, -328},
    { -48, 576, -360},
    { -80, 904, -504},
    { -72, 1104, -544},
    { -80, 1232, -616},
    { 96, 1368, -600},
    { 48, 1104, -376},
    { 72, 1032, -536},
    { 120, 1032, -592},
    { 112, 752, -368},
    { 64, 584, -392},
    { 8, 464, -304},
    { 16, 592, -304},
    { 24, 648, -320},
    { 0, 744, -352},
    { 24, 904, -472},
    { 104, 1008, -472},
    { 176, 992, -592},
    { 96, 832, -440},
    { 64, 800, -504},
    { 184, 856, -480},
    // 26 seconds
    { 176, 776, -480},
    { 32, 552, -400},
    { -24, 504, -360},
    { -72, 544, -320},
    { -152, 624, -288},
    { -136, 800, -384},
    { -176, 904, -424},
    { -112, 1024, -552},
    { -48, 1280, -576},
    { 216, 1392, -528},
    { 168, 1056, -472},
    { 112, 968, -456},
    { 136, 912, -368},
    { 96, 712, -328},
    { 64, 632, -344},
    { 16, 488, -256},
    { -24, 568, -280},
    { 0, 720, -304},
    { 8, 784, -384},
    { 96, 888, -504},
    { 104, 944, -568},
    { 200, 1024, -592},
    { 120, 1056, -552},
    { 184, 1024, -584},
    { 248, 864, -576},
    // 27 seconds
    { 136, 720, -440},
    { 24, 552, -336},
    { -24, 440, -248},
    { -64, 440, -208},
    { -144, 592, -288},
    { -152, 792, -272},
    { -128, 960, -432},
    { -112, 1000, -544},
    { -208, 1096, -584},
    { 160, 1288, -576},
    { 88, 1200, -432},
    { 176, 1152, -416},
    { 248, 1056, -480},
    { 184, 824, -448},
    { 104, 544, -408},
    { 32, 376, -360},
    { -8, 416, -256},
    { 48, 688, -368},
    { 40, 704, -416},
    { 72, 800, -544},
    { 176, 936, -664},
    { 200, 1072, -648},
    { 216, 960, -504},
    { 240, 952, -584},
    { 280, 680, -472},
    // 28 seconds
    { 256, 728, -504},
    { 128, 608, -424},
    { 24, 472, -320},
    { -8, 488, -320},
    { -56, 584, -320},
    { -72, 720, -424},
    { -72, 952, -504},
    { 40, 1152, -600},
    { -24, 1040, -648},
    { 184, 1296, -704},
    { 120, 1008, -440},
    { 16, 1008, -456},
    { 232, 1192, -456},
    { 280, 896, -392},
    { 120, 512, -352},
    { 40, 424, -296},
    { 56, 496, -176},
    { 0, 616, -264},
    { 8, 704, -344},
    { 128, 936, -496},
    { 160, 960, -600},
    { 112, 912, -792},
    { 224, 960, -408},
    { 112, 968, -672},
    { 304, 976, -584},
    // 29 seconds
    { 312, 856, -680},
    { 48, 536, -432},
    { -48, 408, -384},
    { -72, 456, -296},
    { 0, 616, -384},
    { -88, 704, -456},
    { -200, 824, -512},
    { -48, 928, -600},
    { -80, 1000, -608},
    { 56, 1112, -624},
    { 88, 1104, -488},
    { 128, 992, -544},
    { 160, 1040, -488},
    { 104, 792, -448},
    { 40, 528, -376},
    { 96, 544, -344},
    { -24, 432, -312},
    { 16, 640, -424},
    { 48, 768, -352},
    { 184, 888, -648},
    { 120, 800, -632},
    { 168, 1088, -568},
    { 320, 1088, -568},
    { 192, 1048, -536},
    { 256, 800, -552},
    // 30 seconds
    { 160, 736, -496},
    { 24, 592, -336},
    { -16, 496, -248},
    { -64, 488, -144},
    { -56, 600, -256},
    { -48, 792, -368},
    { -80, 872, -376},
    { -32, 968, -600},
    { -112, 1296, -648},
    { 248, 1248, -384},
    { 120, 1032, -560},
    { 96, 968, -440},
    { 112, 784, -424},
    { 168, 848, -432},
    { 112, 712, -352},
    { -8, 528, -288},
    { -24, 696, -328},
    { -16, 720, -320},
    { 24, 816, -424},
    { 32, 912, -568},
    { 80, 912, -560},
    { 192, 976, -496},
    { 48, 1008, -592},
    { 112, 912, -480},
    { 144, 752, -592},
    // 31 seconds
    { 120, 712, -464},
    { 0, 576, -336},
    { -80, 480, -240},
    { -96, 592, -280},
    { -152, 640, -336},
    { -184, 768, -376},
    { -136, 952, -512},
    { 0, 1000, -600},
    { 80, 1208, -616},
    { 64, 1152, -472},
    { 112, 1192, -440},
    { 208, 1056, -416},
    { 136, 816, -424},
    { 120, 704, -384},
    { 40, 512, -288},
    { -32, 512, -248},
    { -48, 608, -240},
    { -40, 728, -256},
    { 72, 920, -408},
    { 32, 992, -464},
    { 208, 1216, -656},
    { 176, 1032, -512},
    { 152, 1048, -568},
    { 248, 920, -528},
    { 208, 704, -544},
    // 32 seconds
    { 88, 584, -384},
    { -24, 440, -256},
    { -32, 464, -240},
    { -112, 544, -216},
    { -184, 672, -288},
    { -184, 904, -400},
    { -80, 1040, -512},
    { -40, 928, -656},
    { 32, 1176, -608},
    { 96, 1288, -400},
    { 256, 1136, -528},
    { 264, 960, -456},
    { 216, 920, -504},
    { 96, 624, -336},
    { 16, 464, -320},
    { -24, 464, -264},
    { 0, 632, -280},
    { 72, 776, -336},
    { 112, 872, -480},
    { 136, 920, -496},
    { 104, 920, -720},
    { 144, 928, -360},
    { 24, 1024, -536},
    { 232, 1016, -472},
    { 208, 768, -584},
    // 33 seconds
    { 80, 576, -408},
    { -24, 520, -320},
    { -56, 448, -256},
    { -96, 624, -216},
    { -112, 800, -216},
    { -184, 880, -288},
    { -120, 1080, -408},
    { -112, 1160, -520},
    { 256, 1344, -528},
    { 144, 1248, -496},
    { 136, 1072, -376},
    { 168, 952, -344},
    { 144, 816, -352},
    { 72, 576, -288},
    { 48, 504, -264},
    { -8, 536, -208},
    { 0, 688, -200},
    { 56, 832, -264},
    { 96, 880, -344},
    { 224, 1032, -448},
    { 240, 1184, -552},
    { 224, 1056, -536},
    { 208, 1168, -488},
    { 320, 944, -536},
    { 184, 728, -480},
    // 34 seconds
    { 96, 672, -304},
    { 0, 528, -200},
    { -32, 536, -152},
    { -48, 576, -192},
    { -88, 768, -272},
    { -184, 904, -320},
    { -160, 1136, -408},
    { -184, 1112, -456},
    { 56, 1176, -336},
    { -48, 1168, -280},
    { 64, 1168, -272},
    { 168, 1112, -312},
    { 88, 840, -320},
    { 16, 648, -272},
    { 8, 544, -264},
    { -96, 432, -216},
    { -32, 600, -240},
    { -8, 744, -272},
    { 56, 880, -336},
    { 104, 928, -432},
    { 248, 1048, -536},
    { 208, 1064, -432},
    { 176, 1016, -528},
    { 320, 920, -616},
    { 256, 792, -472},
    // 35 seconds
    { 64, 584, -304},
    { -16, 552, -280},
    { -80, 552, -224},
    { -104, 728, -256},
    { -104, 792, -368},
    { -64, 944, -448},
    { -24, 1024, -616},
    { -56, 1248, -672},
    { 184, 1184, -472},
    { 192, 1160, -448},
    { 184, 1064, -384},
    { 184, 920, -360},
    { 176, 792, -360},
    { 80, 552, -288},
    { 56, 632, -256},
    { 8, 640, -240},
    { 40, 648, -256},
    { 88, 664, -360},
    { 144, 752, -424},
    { 200, 952, -608},
    { 312, 1000, -448},
    { 208, 960, -576},
    { 176, 880, -624},
    { 272, 928, -576},
    { 200, 736, -504},
    // 36 seconds
    { 96, 464, -392},
    { 24, 400, -352},
    { -16, 536, -312},
    { -64, 640, -248},
    { -72, 864, -432},
    { -64, 1080, -424},
    { -40, 1216, -312},
    { 48, 1328, -456},
    { 224, 1248, -304},
    { 192, 1112, -280},
    { 168, 1040, -232},
    { 192, 928, -288},
    { 128, 656, -272},
    { 88, 576, -272},
    { 16, 488, -184},
    { 8, 576, -208},
    { 32, 704, -208},
    { 64, 856, -352},
    { 144, 952, -448},
    { 120, 1000, -632},
    { 248, 1040, -440},
    { 176, 1200, -536},
    { 248, 928, -544},
    { 232, 640, -560},
    { 168, 616, -424},
    // 37 seconds
    { 56, 576, -288},
    { 8, 480, -232},
    { -56, 504, -200},
    { -80, 728, -264},
    { -96, 888, -328},
    { -56, 1056, -416},
    { 16, 1128, -560},
    { 8, 1392, -568},
    { 144, 1264, -440},
    { 128, 1112, -376},
    { 176, 1032, -456},
    { 120, 864, -328},
    { 136, 808, -288},
    { 64, 608, -328},
    { 24, 528, -336},
    { -16, 552, -208},
    { 56, 776, -312},
    { 64, 848, -384},
    { 16, 872, -352},
    { -16, 968, -544},
    { 72, 928, -568},
    { -16, 904, -512},
    { 0, 760, -544},
    { 104, 736, -536},
    { 104, 680, -448},
    // 38 seconds
    { 0, 520, -360},
    { -32, 472, -312},
    { -80, 568, -272},
    { -168, 728, -328},
    { -224, 832, -400},
    { -224, 968, -448},
    { -128, 1048, -576},
    { -88, 1224, -568},
    { 112, 1200, -432},
    { 120, 1104, -480},
    { 56, 952, -368},
    { 160, 984, -376},
    { 104, 728, -344},
    { 16, 496, -312},
    { -32, 440, -272},
    { -40, 680, -256},
    { 24, 776, -336},
    { 32, 808, -432},
    { 48, 936, -504},
    { 48, 1096, -688},
    { 96, 1016, -384},
    { 128, 1000, -600},
    { 144, 824, -512},
    { 160, 744, -552},
    { 96, 656, -384},
    // 39 seconds
    { 0, 552, -288},
    { -64, 512, -224},
    { -104, 568, -264},
    { -144, 704, -336},
    { -216, 840, -448},
    { -208, 1040, -488},
    { -80, 1096, -528},
    { 24, 1224, -600},
    { 48, 1120, -456},
    { 88, 1072, -352},
    { 160, 1056, -368},
    { 176, 912, -368},
    { 144, 760, -376},
    { 72, 608, -296},
    { 40, 544, -216},
    { -16, 584, -224},
    { -8, 744, -256},
    { 56, 800, -360},
    { 72, 872, -504},
    { 56, 904, -544},
    { 104, 1024, -560},
    { 40, 880, -544},
    { 40, 968, -552},
    { 272, 992, -528},
    { 160, 840, -560},
    // 40 seconds
    { 48, 648, -432},
    { -48, 592, -312},
    { -120, 608, -320},
    { -168, 600, -280},
    { -184, 712, -368},
    { -168, 784, -384},
    { -168, 848, -440},
    { -144, 928, -520},
    { -288, 976, -504},
    { 48, 1296, -504},
    { -48, 1032, -360},
    { 48, 1144, -360},
    { 32, 1064, -328},
    { 104, 800, -352},
    { 64, 504, -368},
    { 32, 416, -352},
    { 0, 496, -320},
    { -8, 584, -392},
    { 48, 720, -360},
    { -112, 792, -512},
    { -192, 944, -472},
    { -192, 1192, -440},
    { 8, 1360, -368},
    { 184, 1064, -592},
    { 248, 832, -496},
    // 41 seconds
    { 216, 744, -440},
    { 104, 792, -336},
    { 64, 680, -312},
    { 8, 592, -320},
    { -48, 584, -368},
    { -104, 640, -432},
    { -128, 704, -368},
    { -120, 800, -456},
    { -144, 840, -472},
    { -96, 944, -544},
    { -208, 1072, -592},
    { 72, 1096, -488},
    { -8, 1096, -464},
    { -24, 1040, -416},
    { 56, 1056, -456},
    { 80, 784, -440},
    { 0, 592, -392},
    { -56, 480, -320},
    { -88, 592, -272},
    { -120, 672, -312},
    { -168, 696, -272},
    { -112, 904, -360},
    { -128, 896, -488},
    { -56, 968, -632},
    { 40, 1144, -456},
    // 42 seconds
    { -8, 1096, -488},
    { 40, 936, -424},
    { 200, 976, -432},
    { 72, 800, -400},
    { -40, 496, -296},
    { -56, 456, -296},
    { -120, 480, -232},
    { -136, 632, -304},
    { -192, 704, -368},
    { -208, 896, -464},
    { -120, 1096, -576},
    { -208, 1136, -640},
    { 120, 1200, -592},
    { 24, 1144, -440},
    { 152, 1256, -384},
    { 184, 1048, -344},
    { 120, 696, -448},
    { 16, 568, -416},
    { 16, 568, -304},
    { -24, 576, -264},
    { -96, 616, -264},
    { -80, 720, -320},
    { -72, 792, -472},
    { -80, 840, -528},
    { -104, 1008, -704},
    // 43 seconds
    { 80, 1128, -464},
    { 56, 1064, -576},
    { 120, 880, -568},
    { 152, 800, -568},
    { 48, 744, -424},
    { -72, 520, -368},
    { -112, 464, -280},
    { -120, 560, -288},
    { -144, 648, -360},
    { -168, 744, -424},
    { -168, 904, -512},
    { -152, 1000, -592},
    { -288, 1048, -616},
    { 88, 1152, -496},
    { -48, 1184, -424},
    { 0, 1040, -384},
    { 40, 888, -328},
    { 160, 880, -408},
    { 56, 672, -352},
    { -16, 464, -272},
    { -88, 400, -264},
    { -80, 560, -160},
    { 48, 1112, -232},
    { 32, 968, -392},
    { 0, 864, -512},
    // 44 seconds
    { -56, 960, -656},
    { 168, 1056, -504},
    { 232, 1048, -320},
    { 280, 664, -416},
    { 288, 776, -488},
    { 168, 824, -336},
    { 88, 616, -400},
    { 0, 472, -288},
    { 8, 584, -296},
    { -32, 824, -408},
    { -104, 872, -440},
    { 16, 1064, -592},
    { 72, 1104, -616},
    { 136, 1176, -560},
    { 216, 1016, -504},
    { 200, 936, -392},
    { 296, 1080, -288},
    { 296, 1032, -336},
    { 216, 760, -400},
    { 72, 472, -344},
    { 88, 496, -224},
    { 32, 584, -208},
    { 24, 704, -232},
    { 24, 752, -520},
    { 96, 816, -544},
    // 45 seconds
    { 152, 960, -632},
    { 248, 1152, -488},
    { 56, 920, -544},
    { 96, 864, -520},
    { 328, 912, -592},
    { 200, 704, -528},
    { 96, 552, -424},
    { 8, 480, -264},
    { 40, 624, -264},
    { -56, 640, -328},
    { -56, 808, -448},
    { -168, 968, -528},
    { -88, 1056, -584},
    { 24, 1400, -576},
    { 208, 1072, -472},
    { 112, 1008, -416},
    { 136, 1120, -416},
    { 152, 888, -336},
    { 232, 888, -392},
    { 160, 640, -360},
    { 48, 488, -272},
    { 0, 568, -296},
    { 56, 696, -344},
    { 32, 784, -384},
    { 40, 880, -472},
    // 46 seconds
    { 88, 992, -512},
    { 80, 1120, -488},
    { 120, 1048, -528},
    { 232, 840, -608},
    { 160, 704, -536},
    { 72, 664, -336},
    { 0, 528, -272},
    { -80, 432, -240},
    { -112, 528, -264},
    { -160, 704, -352},
    { -184, 936, -440},
    { -168, 1056, -504},
    { -112, 984, -608},
    { 48, 1184, -584},
    { 40, 1192, -472},
    { 80, 1080, -432},
    { 112, 960, -392},
    { 200, 872, -424},
    { 112, 648, -416},
    { 16, 480, -312},
    { 0, 488, -240},
    { -8, 672, -264},
    { 8, 776, -304},
    { 40, 880, -448},
    { 112, 928, -488},
    // 47 seconds
    { 112, 1000, -664},
    { 272, 1040, -512},
    { 224, 976, -640},
    { 368, 864, -568},
    { 264, 800, -576},
    { 88, 592, -424},
    { 0, 464, -312},
    { -64, 424, -216},
    { -120, 472, -200},
    { -112, 712, -320},
    { -160, 840, -416},
    { -96, 944, -512},
    { 16, 1072, -688},
    { -56, 1120, -656},
    { 96, 1152, -496},
    { 256, 1256, -480},
    { 280, 1040, -408},
    { 176, 784, -448},
    { 184, 720, -432},
    { 56, 504, -312},
    { 24, 552, -256},
    { -48, 616, -224},
    { 8, 736, -296},
    { 32, 768, -448},
    { 64, 872, -536},
    // 48 seconds
    { 40, 1008, -632},
    { 336, 1000, -424},
    { 176, 1000, -616},
    { 248, 896, -528},
    { 248, 840, -552},
    { 96, 640, -440},
    { -8, 480, -320},
    { -40, 456, -272},
    { -88, 504, -216},
    { -80, 744, -392},
    { -104, 816, -440},
    { -16, 1040, -576},
    { 64, 1160, -592},
    { 232, 1280, -584},
    { 160, 1136, -432},
    { 224, 1040, -400},
    { 248, 1040, -320},
    { 192, 816, -400},
    { 144, 744, -368},
    { 104, 528, -264},
    { 48, 472, -248},
    { -8, 512, -248},
    { 0, 600, -152},
    { 40, 776, -472},
    { 184, 1016, -408},
    // 49 seconds
    { 296, 1336, -544},
    { 272, 1064, -656},
    { 232, 1016, -560},
    { 272, 936, -520},
    { 224, 784, -496},
    { 104, 584, -376},
    { 32, 480, -272},
    { 24, 472, -176},
    { -16, 600, -320},
    { -56, 672, -320},
    { -104, 856, -432},
    { 8, 1000, -552},
    { 40, 1048, -496},
    { 376, 1344, -616},
    { 120, 1136, -456},
    { 192, 1080, -432},
    { 240, 960, -368},
    { 200, 816, -408},
    { 104, 600, -320},
    { 120, 472, -168},
    { 80, 464, -216},
    { 48, 608, -248},
    { 192, 840, -360},
    { 200, 920, -512},
    { 232, 928, -512},
    // 50 seconds
    { 256, 1192, -592},
    { 256, 1056, -496},
    { 200, 1032, -360},
    { 320, 944, -496},
    { 216, 752, -496},
    { 104, 544, -344},
    { 8, 472, -272},
    { 8, 536, -216},
    { 8, 648, -272},
    { 8, 768, -416},
    { -56, 864, -488},
    { 8, 976, -632},
    { -16, 1024, -600},
    { 328, 1176, -560},
    { 224, 1208, -496},
    { 248, 1080, -424},
    { 264, 888, -392},
    { 192, 776, -384},
    { 88, 496, -312},
    { 16, 400, -288},
    { 0, 472, -264},
    { 56, 664, -320},
    { 72, 728, -368},
    { 160, 936, -552},
    { 264, 968, -608},
    // 51 seconds
    { 368, 1080, -632},
    { 208, 1000, -608},
    { 192, 992, -608},
    { 328, 896, -640},
    { 216, 672, -560},
    { 72, 520, -392},
    { 24, 472, -352},
    { -32, 432, -248},
    { -96, 568, -288},
    { -120, 688, -384},
    { -160, 776, -456},
    { -32, 960, -600},
    { -144, 1040, -672},
    { 232, 1184, -632},
    { 128, 1232, -552},
    { 120, 1040, -480},
    { 200, 984, -464},
    { 208, 840, -464},
    { 112, 656, -400},
    { 40, 480, -320},
    { -32, 472, -288},
    { -16, 544, -280},
    { -8, 736, -320},
    { 48, 872, -400},
    { 72, 864, -496},
    // 52 seconds
    { 88, 944, -672},
    { 360, 1056, -472},
    { 80, 1120, -568},
    { 192, 1048, -560},
    { 184, 800, -600},
    { 104, 680, -464},
    { 40, 568, -312},
    { -40, 448, -240},
    { -80, 480, -240},
    { -160, 632, -256},
    { -96, 936, -392},
    { -168, 936, -584},
    { -48, 936, -712},
    { -72, 1168, -608},
    { 64, 1136, -400},
    { 40, 1032, -464},
    { 192, 1048, -376},
    { 176, 816, -352},
    { 176, 744, -376},
    { 136, 672, -296},
    { 64, 552, -280},
    { -24, 480, -320},
    { 24, 696, -368},
    { 56, 880, -448},
    { 96, 920, -560},
    // 53 seconds
    { 176, 1008, -616},
    { 328, 1160, -504},
    { 232, 840, -584},
    { 168, 960, -552},
    { 312, 912, -520},
    { 200, 704, -512},
    { 112, 560, -440},
    { 40, 448, -280},
    { -32, 520, -264},
    { -32, 696, -320},
    { -80, 720, -384},
    { -136, 848, -440},
    { -8, 1040, -568},
    { -64, 1096, -664},
    { 176, 1096, -488},
    { 128, 1160, -432},
    { 184, 1120, -408},
    { 248, 976, -400},
    { 184, 712, -408},
    { 48, 544, -312},
    { 8, 480, -264},
    { -8, 528, -240},
    { 0, 672, -296},
    { 40, 776, -368},
    { 128, 880, -504},
    // 54 seconds
    { 208, 920, -656},
    { 504, 1128, -592},
    { 264, 1240, -696},
    { 160, 824, -592},
    { 216, 712, -672},
    { 144, 712, -520},
    { 24, 544, -344},
    { -24, 480, -256},
    { -80, 552, -264},
    { -120, 632, -336},
    { -112, 792, -416},
    { -24, 888, -528},
    { 32, 968, -616},
    { 184, 1352, -752},
    { 176, 1144, -496},
    { 136, 976, -464},
    { 192, 1024, -464},
    { 216, 872, -456},
    { 144, 648, -416},
    { 32, 440, -368},
    { -24, 320, -248},
    { -24, 576, -280},
    { 16, 784, -176},
    { 160, 1056, -312},
    { 256, 1104, -536},
    // 55 seconds
    { 192, 1112, -528},
    { 312, 1016, -392},
    { 248, 992, -624},
    { 264, 784, -560},
    { 232, 680, -528},
    { 152, 648, -416},
    { 40, 464, -208},
    { -24, 488, -240},
    { -88, 640, -296},
    { -128, 736, -376},
    { -88, 840, -496},
    { -96, 904, -648},
    { -96, 928, -696},
    { 144, 1272, -656},
    { 104, 1256, -480},
    { 184, 1040, -472},
    { 336, 1096, -544},
    { 176, 792, -464},
    { 96, 512, -368},
    { 16, 432, -320},
    { 0, 472, -264},
    { -40, 632, -224},
    { 0, 800, -344},
    { 64, 888, -472},
    { 128, 904, -656},
    // 56 seconds
    { 264, 1064, -560},
    { 232, 1176, -568},
    { 240, 912, -656},
    { 176, 712, -608},
    { 144, 672, -384},
    { 24, 480, -304},
    { -48, 368, -304},
    { -56, 560, -272},
    { -152, 720, -352},
    { -192, 904, -424},
    { -96, 1008, -536},
    { -104, 1040, -648},
    { 72, 1248, -664},
    { 80, 1224, -504},
    { 104, 1032, -400},
    { 152, 992, -408},
    { 200, 920, -400},
    { 96, 608, -352},
    { 8, 416, -312},
    { -32, 392, -232},
    { -40, 656, -248},
    { -8, 792, -304},
    { 72, 904, -400},
    { 144, 944, -552},
    { 176, 984, -648},
    // 57 seconds
    { 136, 1008, -536},
    { 112, 984, -568},
    { 256, 912, -528},
    { 224, 704, -568},
    { 56, 568, -400},
    { -24, 512, -320},
    { -64, 448, -240},
    { -128, 504, -200},
    { -120, 760, -376},
    { -152, 880, -472},
    { -120, 944, -608},
    { -24, 904, -688},
    { 200, 1336, -680},
    { 24, 1152, -456},
    { 104, 1088, -448},
    { 216, 1064, -456},
    { 200, 864, -464},
    { 128, 680, -424},
    { 80, 584, -304},
    { 96, 520, -304},
    { 24, 568, -296},
    { -16, 712, -248},
    { 56, 904, -328},
    { 120, 928, -336},
    { 8, 1088, -496},
    // 58 seconds
    { 240, 1080, -408},
    { 192, 1112, -560},
    { 240, 856, -528},
    { 168, 672, -552},
    { 88, 656, -392},
    { 16, 600, -328},
    { -48, 472, -256},
    { -56, 560, -280},
    { -104, 640, -336},
    { -152, 816, -400},
    { -152, 960, -448},
    { -200, 1120, -552},
    { 264, 1320, -608},
    { 152, 1216, -536},
    { 96, 1032, -408},
    { 160, 992, -392},
    { 152, 784, -368},
    { 64, 592, -360},
    { 16, 488, -296},
    { 24, 544, -248},
    { 40, 680, -280},
    { 72, 728, -352},
    { 136, 888, -528},
    { 168, 888, -584},
    { 280, 992, -624},
    // 59 seconds
    { 240, 848, -648},
    { 192, 1000, -656},
    { 336, 904, -640},
    { 200, 672, -576},
    { 104, 656, -424},
    { 40, 552, -336},
    { 0, 496, -280},
    { -48, 568, -296},
    { -112, 672, -384},
    { -136, 864, -488},
    { -136, 984, -512},
    { -176, 1096, -632},
    { 248, 1240, -664},
    { 72, 1152, -504},
    { 104, 1096, -456},
    { 112, 960, -416},
    { 144, 880, -416},
    { 104, 656, -384},
    { 40, 440, -328},
    { -24, 472, -256},
    { -24, 656, -296},
    { 48, 736, -368},
    { 120, 848, -552},
    { 64, 856, -568},
    { 112, 1096, -640},
    // 60 seconds
    // elapsed: 1 minutes
    { 144, 976, -512},
    { 56, 960, -592},
    { 168, 872, -488},
    { 144, 720, -424},
    { 144, 688, -408},
    { 48, 512, -424},
    { 0, 480, -280},
    { -88, 592, -328},
    { -112, 784, -376},
    { -160, 880, -448},
    { -72, 1000, -568},
    { -88, 1136, -592},
    { 296, 1344, -664},
    { 128, 1176, -512},
    { 120, 1032, -392},
    { 184, 912, -392},
    { 160, 696, -344},
    { 136, 664, -336},
    { 48, 544, -312},
    { 8, 552, -224},
    { 88, 784, -272},
    { 136, 808, -296},
    { 240, 920, -432},
    { 224, 952, -528},
    { 320, 1016, -528},
    // 61 seconds
    { 160, 976, -512},
    { 136, 864, -552},
    { 328, 864, -528},
    { 296, 768, -528},
    { 104, 472, -424},
    { 16, 376, -352},
    { -48, 440, -256},
    { -48, 704, -304},
    { -128, 856, -416},
    { -112, 928, -520},
    { 0, 984, -640},
    { 136, 1368, -688},
    { 192, 1088, -456},
    { 152, 976, -432},
    { 168, 992, -400},
    { 208, 872, -376},
    { 232, 800, -408},
    { 112, 560, -344},
    { 64, 448, -312},
    { 0, 560, -256},
    { 32, 720, -296},
    { 88, 832, -400},
    { 160, 856, -472},
    { 152, 824, -632},
    { 328, 1056, -504},
    // 62 seconds
    { 176, 1168, -576},
    { 328, 1080, -640},
    { 304, 752, -688},
    { 176, 584, -528},
    { 88, 536, -416},
    { 24, 392, -312},
    { -24, 488, -328},
    { -96, 608, -360},
    { -112, 784, -488},
    { -120, 904, -592},
    { -16, 992, -632},
    { 40, 1096, -680},
    { 352, 1224, -584},
    { 224, 1104, -480},
    { 200, 968, -448},
    { 296, 920, -368},
    { 216, 808, -424},
    { 168, 728, -440},
    { 72, 504, -320},
    { -24, 488, -312},
    { -72, 568, -336},
    { -24, 696, -328},
    { 72, 816, -432},
    { 64, 840, -496},
    { 64, 880, -664},
    // 63 seconds
    { 168, 1064, -480},
    { 128, 1032, -608},
    { 152, 952, -512},
    { 272, 920, -536},
    { 160, 752, -488},
    { 40, 616, -384},
    { -16, 544, -280},
    { -48, 568, -240},
    { -64, 608, -288},
    { -24, 728, -384},
    { -48, 816, -504},
    { -80, 848, -520},
    { -24, 992, -656},
    { -128, 1104, -624},
    { 192, 1088, -544},
    { 32, 1008, -464},
    { 40, 960, -336},
    { 216, 1024, -408},
    { 264, 792, -416},
    { 144, 672, -408},
    { 40, 536, -312},
    { 8, 544, -248},
    { 16, 688, -272},
    { 88, 808, -376},
    { 136, 856, -448},
    // 64 seconds
    { 176, 944, -584},
    { 320, 1072, -592},
    { 208, 992, -600},
    { 112, 888, -576},
    { 176, 728, -552},
    { 192, 728, -472},
    { 112, 632, -384},
    { 32, 488, -352},
    { -32, 424, -280},
    { -40, 592, -328},
    { -64, 784, -392},
    { -104, 880, -480},
    { 8, 1016, -632},
    { -72, 968, -600},
    { 296, 1200, -584},
    { 112, 1264, -488},
    { 216, 1096, -432},
    { 248, 928, -440},
    { 224, 824, -496},
    { 136, 648, -424},
    { 40, 456, -320},
    { -40, 504, -320},
    { -16, 576, -312},
    { 48, 688, -392},
    { 144, 856, -504},
    // 65 seconds
    { 192, 872, -560},
    { 104, 872, -728},
    { 208, 896, -456},
    { 232, 1144, -680},
    { 352, 920, -568},
    { 264, 680, -552},
    { 88, 520, -424},
    { -16, 488, -352},
    { -40, 496, -272},
    { -48, 456, -216},
    { 48, 776, -456},
    { -96, 760, -456},
    { -136, 840, -568},
    { -64, 952, -648},
    { -72, 1248, -784},
    { 168, 1128, -424},
    { 216, 1160, -608},
    { 152, 1024, -440},
    { 56, 648, -424},
    { 296, 816, -592},
    { 192, 632, -360},
    { 48, 456, -384},
    { 16, 528, -368},
    { 88, 688, -384},
    { 104, 744, -416},
    // 66 seconds
    { 200, 904, -528},
    { 144, 864, -656},
    { 192, 888, -400},
    { 40, 1056, -552},
    { 216, 1048, -592},
    { 192, 728, -608},
    { 160, 576, -488},
    { 64, 472, -480},
    { -8, 416, -264},
    { -64, 560, -296},
    { -136, 680, -360},
    { -152, 832, -392},
    { -112, 1000, -568},
    { -88, 928, -584},
    { 40, 1320, -568},
    { 144, 1248, -464},
    { 160, 1192, -416},
    { 192, 1144, -344},
    { 128, 896, -424},
    { 88, 624, -432},
    { 64, 512, -328},
    { -8, 432, -264},
    { -104, 504, -216},
    { -72, 720, -312},
    { -16, 848, -360},
    // 67 seconds
    { 80, 1000, -384},
    { 112, 1232, -688},
    { 16, 960, -424},
    { 176, 1288, -608},
    { 312, 1056, -640},
    { 160, 776, -512},
    { 64, 592, -360},
    { -40, 480, -272},
    { -80, 392, -192},
    { -72, 552, -264},
    { -168, 680, -312},
    { -144, 864, -424},
    { -112, 1072, -544},
    { -104, 1128, -576},
    { 176, 1328, -488},
    { 184, 1352, -424},
    { 168, 1096, -352},
    { 224, 928, -328},
    { 216, 800, -376},
    { 72, 576, -336},
    { 16, 456, -272},
    { -32, 472, -240},
    { -24, 648, -264},
    { 32, 880, -328},
    { 80, 912, -416},
    // 68 seconds
    { 136, 1000, -536},
    { 128, 1024, -672},
    { 144, 1024, -416},
    { 112, 904, -520},
    { 240, 840, -480},
    { 312, 808, -488},
    { 168, 680, -408},
    { 32, 480, -328},
    { -56, 360, -240},
    { -80, 520, -272},
    { -112, 736, -360},
    { -48, 912, -496},
    { 48, 1016, -584},
    { 112, 1016, -680},
    { 152, 1128, -576},
    { 184, 960, -408},
    { 152, 960, -432},
    { 320, 1176, -512},
    { 280, 960, -496},
    { 96, 600, -408},
    { 24, 528, -424},
    { 8, 448, -312},
    { 24, 512, -264},
    { -64, 640, -336},
    { -8, 872, -392},
    // 69 seconds
    { 144, 1032, -480},
    { 112, 1040, -656},
    { 264, 1128, -480},
    { 184, 1064, -608},
    { 136, 872, -568},
    { 232, 720, -504},
    { 128, 592, -408},
    { 48, 560, -328},
    { 16, 448, -280},
    { -112, 432, -288},
    { -80, 688, -368},
    { -96, 808, -440},
    { -88, 952, -552},
    { 0, 1032, -688},
    { -64, 1176, -560},
    { 264, 1264, -520},
    { 128, 1128, -456},
    { 128, 992, -392},
    { 128, 736, -344},
    { 136, 688, -416},
    { 0, 504, -352},
    { -40, 424, -296},
    { -48, 512, -296},
    { 0, 744, -392},
    { 0, 800, -408},
    // 70 seconds
    { 136, 1064, -520},
    { 160, 1144, -760},
    { 256, 920, -360},
    { 120, 1008, -608},
    { 176, 888, -488},
    { 272, 712, -520},
    { 208, 800, -496},
    { -8, 520, -384},
    { -48, 440, -296},
    { -144, 432, -288},
    { -128, 600, -416},
    { -48, 816, -528},
    { -24, 960, -672},
    { -24, 984, -664},
    { 48, 1216, -592},
    { 160, 1112, -456},
    { 168, 1000, -448},
    { 136, 960, -400},
    { 160, 880, -376},
    { 144, 704, -384},
    { 72, 592, -344},
    { 0, 408, -264},
    { -40, 480, -256},
    { -24, 696, -328},
    { 80, 904, -432},
    // 71 seconds
    { 240, 872, -528},
    { 240, 1048, -704},
    { 336, 936, -336},
    { 104, 1080, -560},
    { 144, 992, -416},
    { 152, 776, -528},
    { 216, 792, -544},
    { 64, 544, -360},
    { 24, 472, -224},
    { 24, 568, -264},
    { -16, 680, -344},
    { -64, 816, -440},
    { 0, 952, -584},
    { 8, 952, -608},
    { 160, 1240, -632},
    { 136, 1200, -464},
    { 168, 1024, -448},
    { 184, 928, -416},
    { 208, 824, -432},
    { 144, 664, -392},
    { 56, 496, -312},
    { 0, 448, -248},
    { 8, 568, -256},
    { 56, 688, -288},
    { 72, 808, -368},
    // 72 seconds
    { 128, 912, -504},
    { 152, 992, -712},
    { 360, 1056, -456},
    { 208, 1248, -688},
    { 304, 984, -560},
    { 248, 712, -632},
    { 192, 672, -544},
    { 64, 520, -384},
    { 0, 400, -280},
    { -48, 464, -272},
    { -64, 608, -288},
    { -88, 768, -416},
    { -88, 888, -544},
    { -16, 952, -632},
    { -80, 952, -760},
    { 152, 1056, -512},
    { 216, 1168, -560},
    { 240, 1080, -440},
    { 280, 1096, -448},
    { 200, 832, -432},
    { 88, 600, -432},
    { 8, 424, -384},
    { 8, 424, -288},
    { 8, 584, -344},
    { 48, 752, -312},
    // 73 seconds
    { 168, 920, -488},
    { 192, 904, -600},
    { 256, 992, -808},
    { 344, 944, -448},
    { 160, 936, -632},
    { 240, 928, -512},
    { 224, 792, -560},
    { 104, 544, -464},
    { -16, 408, -384},
    { -8, 448, -304},
    { -72, 576, -368},
    { -24, 760, -440},
    { -40, 856, -632},
    { 40, 888, -736},
    { 0, 920, -680},
    { 200, 1168, -640},
    { 160, 1104, -576},
    { 192, 968, -488},
    { 192, 872, -456},
    { 264, 824, -480},
    { 160, 624, -392},
    { 48, 448, -384},
    { 32, 472, -344},
    { -8, 584, -368},
    { 64, 736, -456},
    // 74 seconds
    { 144, 832, -504},
    { 168, 880, -544},
    { 120, 872, -864},
    { 256, 912, -472},
    { 152, 1064, -736},
    { 176, 928, -528},
    { 280, 720, -592},
    { 192, 640, -512},
    { 56, 472, -400},
    { 24, 424, -328},
    { -56, 552, -448},
    { -16, 664, -472},
    { 72, 704, -432},
    { 32, 848, -624},
    { 64, 920, -704},
    { 24, 1032, -720},
    { 216, 1032, -568},
    { 160, 1048, -584},
    { 200, 1064, -480},
    { 288, 928, -504},
    { 232, 624, -480},
    { 144, 512, -464},
    { 48, 440, -424},
    { -8, 480, -320},
    { 8, 696, -416},
    // 75 seconds
    { 136, 880, -456},
    { 232, 904, -504},
    { 232, 752, -584},
    { 432, 1024, -720},
    { 200, 816, -544},
    { 184, 848, -536},
    { 264, 912, -568},
    { 216, 720, -536},
    { 104, 584, -496},
    { 48, 520, -432},
    { 8, 472, -304},
    { -16, 616, -400},
    { -56, 752, -424},
    { -104, 784, -520},
    { -32, 880, -624},
    { 8, 976, -680},
    { 384, 1248, -680},
    { 320, 1080, -632},
    { 192, 752, -552},
    { 152, 880, -464},
    { 192, 728, -408},
    { 200, 568, -448},
    { 176, 680, -528},
    { 32, 472, -288},
    { 72, 584, -408},
    // 76 seconds
    { 128, 728, -488},
    { 160, 632, -472},
    { 216, 744, -576},
    { 144, 840, -704},
    { 408, 784, -456},
    { 152, 1136, -744},
    { 240, 992, -592},
    { 256, 720, -528},
    { 160, 664, -512},
    { 48, 648, -496},
    { 24, 528, -336},
    { 0, 496, -328},
    { -8, 656, -376},
    { -48, 688, -400},
    { 8, 856, -552},
    { 40, 896, -680},
    { 104, 1128, -672},
    { 296, 1232, -568},
    { 360, 1072, -568},
    { 264, 904, -472},
    { 320, 912, -496},
    { 336, 840, -424},
    { 128, 576, -432},
    { 56, 480, -360},
    { 96, 552, -296},
    // 77 seconds
    { 160, 616, -344},
    { 160, 592, -440},
    { 224, 624, -424},
    { 232, 768, -464},
    { 128, 928, -688},
    { 280, 720, -512},
    { 400, 1088, -672},
    { 264, 992, -632},
    { 288, 856, -584},
    { 240, 768, -600},
    { 136, 624, -496},
    { 64, 536, -352},
    { 40, 560, -376},
    { 48, 616, -336},
    { 40, 672, -392},
    { 8, 656, -464},
    { -32, 776, -520},
    { -40, 864, -528},
    { 48, 808, -624},
    { 120, 1152, -648},
    { 536, 1152, -552},
    { 384, 920, -632},
    { 240, 872, -512},
    { 200, 928, -416},
    { 248, 792, -448},
    // 78 seconds
    { 256, 680, -440},
    { 176, 680, -368},
    { 264, 696, -368},
    { 200, 664, -384},
    { 136, 600, -328},
    { 136, 704, -440},
    { 40, 592, -360},
    { 88, 696, -464},
    { 8, 728, -424},
    { -104, 872, -424},
    { 256, 920, -504},
    { 48, 832, -536},
    { 112, 936, -584},
    { 240, 1144, -552},
    { 216, 896, -544},
    { 304, 864, -520},
    { 336, 840, -488},
    { 288, 768, -496},
    { 264, 744, -520},
    { 184, 664, -432},
    { 184, 688, -488},
    { 176, 720, -456},
    { 192, 720, -464},
    { 144, 664, -512},
    { 112, 720, -472},
    // 79 seconds
    { 144, 768, -440},
    { 120, 752, -424},
    { 80, 728, -432},
    { 88, 680, -456},
    { 112, 680, -472},
    { 80, 712, -544},
    { 104, 736, -512},
    { 112, 776, -560},
    { 112, 776, -576},
    { 160, 896, -600},
    { 352, 1000, -560},
    { 360, 944, -536},
    { 240, 752, -552},
    { 248, 720, -512},
    { 296, 752, -464},
    { 192, 664, -448},
    { 168, 736, -416},
    { 184, 800, -416},
    { 176, 808, -424},
    { 184, 824, -424},
    { 168, 808, -384},
    { 112, 792, -376},
    { 120, 848, -416},
    { 216, 960, -464},
    { 200, 920, -536},
    // 80 seconds
    { 192, 848, -528},
    { 152, 720, -432},
    { 104, 720, -432},
    { 136, 832, -440},
    { 144, 792, -424},
    { 144, 744, -504},
    { 120, 736, -488},
    { 96, 736, -456},
    { 64, 760, -448},
    { 112, 800, -440},
    { 168, 840, -456},
    { 160, 848, -456},
    { 144, 840, -432},
    { 128, 824, -448},
    { 120, 784, -472},
    { 120, 784, -488},
    { 160, 768, -496},
    { 176, 728, -512},
    { 160, 712, -520},
    { 160, 760, -488},
    { 192, 816, -488},
    { 176, 832, -480},
    { 176, 856, -512},
    { 192, 840, -528},
    { 168, 776, -520},
    // 81 seconds
    { 160, 744, -528},
    { 152, 704, -504},
    { 168, 736, -520},
    { 176, 752, -512},
    { 184, 736, -520},
    { 192, 768, -536},
    { 184, 736, -504},
    { 160, 728, -512},
    { 136, 720, -496},
    { 144, 752, -480},
    { 168, 792, -488},
    { 176, 800, -504},
    { 160, 752, -496},
    { 144, 776, -488},
    { 152, 776, -472},
    { 160, 800, -488},
    { 152, 800, -472},
    { 144, 760, -480},
    { 168, 752, -512},
    { 136, 752, -496},
    { 160, 808, -488},
    { 144, 800, -496},
    { 136, 768, -480},
    { 120, 744, -488},
    { 144, 752, -448},
    // 82 seconds
    { 144, 784, -488},
    { 152, 792, -464},
    { 152, 792, -496},
    { 144, 792, -496},
    { 152, 760, -512},
    { 128, 760, -512},
    { 128, 776, -520},
    { 128, 744, -496},
    { 136, 760, -512},
    { 144, 776, -520},
    { 160, 784, -536},
    { 168, 784, -528},
    { 168, 784, -520},
    { 176, 784, -512},
    { 168, 752, -512},
    { 184, 760, -488},
    { 152, 744, -496},
    { 136, 744, -480},
    { 160, 792, -456},
    { 200, 824, -496},
    { 208, 792, -480},
    { 216, 800, -504},
    { 200, 768, -488},
    { 160, 728, -464},
    { 144, 768, -464},
    // 83 seconds
    { 152, 808, -472},
    { 184, 824, -512},
    { 192, 800, -520},
    { 192, 808, -504},
    { 192, 792, -528},
    { 192, 784, -536},
    { 192, 768, -536},
    { 184, 712, -528},
    { 160, 696, -520},
    { 160, 688, -496},
    { 184, 720, -512},
    { 200, 752, -512},
    { 240, 792, -504},
    { 240, 752, -504},
    { 208, 720, -488},
    { 200, 768, -488},
    { 216, 752, -504},
    { 208, 736, -504},
    { 208, 744, -512},
    { 192, 728, -512},
    { 200, 744, -504},
    { 208, 768, -496},
    { 232, 752, -496},
    { 208, 728, -480},
    { 192, 704, -456},
    // 84 seconds
    { 176, 704, -488},
    { 192, 728, -456},
    { 224, 824, -488},
    { 224, 816, -512},
    { 216, 800, -488},
    { 200, 792, -464},
    { 168, 744, -464},
    { 160, 744, -440},
    { 160, 776, -432},
    { 152, 832, -488},
    { 184, 856, -512},
    { 232, 864, -512},
    { 208, 824, -512},
    { 200, 792, -488},
    { 224, 808, -488},
    { 232, 744, -440},
    { 200, 728, -432},
    { 184, 752, -448},
    { 208, 768, -456},
    { 216, 792, -480},
    { 208, 768, -488},
    { 208, 776, -456},
    { 224, 800, -496},
    { 224, 792, -488},
    { 264, 768, -472},
    // 85 seconds
    { 256, 768, -496},
    { 256, 736, -464},
    { 264, 720, -456},
    { 232, 736, -472},
    { 240, 736, -464},
    { 248, 776, -464},
    { 232, 760, -464},
    { 216, 760, -464},
    { 184, 744, -440},
    { 192, 760, -440},
    { 192, 792, -440},
    { 216, 824, -464},
    { 240, 848, -488},
    { 208, 784, -480},
    { 208, 792, -504},
    { 208, 776, -480},
    { 192, 792, -472},
    { 192, 784, -456},
    { 200, 784, -472},
    { 184, 792, -480},
    { 184, 776, -456},
    { 192, 792, -464},
    { 208, 776, -448},
    { 216, 760, -448},
    { 216, 744, -448},
    // 86 seconds
    { 208, 752, -440},
    { 240, 792, -472},
    { 264, 792, -472},
    { 248, 776, -480},
    { 232, 760, -472},
    { 240, 760, -456},
    { 240, 784, -480},
    { 232, 768, -472},
    { 232, 744, -448},
    { 224, 760, -456},
    { 232, 760, -464},
    { 232, 760, -472},
    { 248, 768, -472},
    { 240, 768, -456},
    { 224, 760, -448},
    { 232, 752, -456},
    { 232, 768, -464},
    { 224, 792, -440},
    { 232, 808, -440},
    { 240, 808, -448},
    { 232, 808, -440},
    { 232, 808, -432},
    { 232, 784, -424},
    { 224, 776, -432},
    { 208, 776, -440},
    // 87 seconds
    { 216, 808, -440},
    { 216, 800, -456},
    { 248, 752, -464},
    { 280, 776, -472},
    { 248, 760, -456},
    { 208, 776, -448},
    { 200, 800, -432},
    { 184, 784, -440},
    { 152, 800, -416},
    { 152, 832, -424},
    { 184, 856, -440},
    { 200, 832, -440},
    { 224, 824, -440},
    { 216, 792, -432},
    { 224, 768, -432},
    { 192, 760, -424},
    { 160, 720, -408},
    { 176, 752, -408},
    { 208, 816, -448},
    { 272, 888, -488},
    { 248, 872, -496},
    { 192, 816, -496},
    { 184, 784, -488},
    { 160, 768, -472},
    { 128, 760, -480},
    // 88 seconds
    { 176, 768, -480},
    { 216, 768, -488},
    { 240, 784, -504},
    { 224, 744, -472},
    { 224, 704, -456},
    { 184, 704, -472},
    { 192, 720, -472},
    { 208, 784, -512},
    { 224, 776, -544},
    { 208, 744, -520},
    { 184, 728, -504},
    { 168, 736, -496},
    { 176, 776, -496},
    { 216, 784, -504},
    { 232, 760, -512},
    { 184, 752, -496},
    { 160, 744, -464},
    { 168, 752, -472},
    { 184, 792, -488},
    { 248, 776, -488},
    { 240, 760, -480},
    { 216, 760, -464},
    { 184, 760, -472},
    { 184, 792, -520},
    { 168, 800, -512},
    // 89 seconds
    { 168, 736, -504},
    { 152, 728, -456},
    { 168, 768, -416},
    { 192, 808, -432},
    { 224, 832, -456},
    { 232, 808, -456},
    { 200, 776, -440},
    { 200, 800, -424},
    { 232, 824, -448},
    { 320, 840, -448},
    { 304, 784, -352},
    { 352, 728, -440},
    { 288, 656, -464},
    { 296, 736, -424},
    { 328, 856, -464},
    { 328, 752, -416},
    { 288, 720, -440},
    { 264, 720, -360},
    { 344, 880, -424},
    { 312, 848, -528},
    { 320, 760, -472},
    { 344, 744, -424},
    { 368, 720, -392},
    { 360, 720, -360},
    { 376, 752, -408},
    // 90 seconds
    { 360, 768, -424},
    { 376, 760, -408},
    { 368, 760, -424},
    { 344, 768, -440},
    { 344, 744, -400},
    { 320, 728, -400},
    { 296, 776, -424},
    { 320, 752, -424},
    { 336, 776, -440},
    { 328, 736, -440},
    { 304, 744, -416},
    { 280, 768, -416},
    { 296, 792, -424},
    { 312, 800, -432},
    { 288, 776, -416},
    { 296, 792, -416},
    { 320, 792, -408},
    { 320, 776, -424},
    { 304, 752, -408},
    { 304, 768, -400},
    { 288, 744, -408},
    { 280, 760, -416},
    { 280, 808, -432},
    { 288, 800, -432},
    { 248, 760, -392},
    // 91 seconds
    { 208, 760, -416},
    { 208, 816, -456},
    { 240, 888, -472},
    { 216, 848, -456},
    { 176, 800, -464},
    { 168, 776, -432},
    { 168, 768, -440},
    { 184, 784, -456},
    { 224, 784, -448},
    { 216, 776, -424},
    { 192, 728, -416},
    { 184, 712, -432},
    { 208, 736, -432},
    { 216, 760, -432},
    { 208, 784, -456},
    { 208, 800, -472},
    { 232, 832, -472},
    { 240, 832, -480},
    { 240, 816, -464},
    { 248, 792, -456},
    { 248, 792, -432},
    { 248, 808, -456},
    { 248, 792, -472},
    { 240, 776, -472},
    { 224, 760, -488},
    // 92 seconds
    { 240, 760, -488},
    { 264, 768, -512},
    { 232, 736, -464},
    { 224, 728, -424},
    { 216, 744, -472},
    { 200, 752, -528},
    { 208, 800, -512},
    { 176, 824, -512},
    { 136, 808, -480},
    { 264, 816, -568},
    { 328, 696, -472},
    { 280, 592, -536},
    { 232, 576, -488},
    { 256, 728, -496},
    { 280, 696, -472},
    { 320, 704, -456},
    { 296, 776, -344},
    { 272, 816, -424},
    { 280, 792, -488},
    { 312, 768, -520},
    { 288, 856, -512},
    { 264, 856, -488},
    { 256, 872, -528},
    { 256, 776, -488},
    { 272, 720, -416},
    // 93 seconds
    { 272, 736, -456},
    { 264, 760, -456},
    { 256, 768, -456},
    { 256, 784, -496},
    { 248, 768, -440},
    { 232, 768, -416},
    { 208, 736, -400},
    { 192, 744, -416},
    { 176, 768, -432},
    { 168, 800, -448},
    { 152, 824, -496},
    { 144, 752, -536},
    { 176, 784, -448},
    { 152, 800, -544},
    { 144, 776, -480},
    { 152, 808, -536},
    { 144, 776, -488},
    { 168, 840, -392},
    { 160, 872, -536},
    { 120, 824, -488},
    { 104, 824, -576},
    { 88, 800, -656},
    { 120, 872, -384},
    { 48, 840, -624},
    { 88, 840, -568},
    // 94 seconds
    { 48, 720, -472},
    { 32, 728, -528},
    { 64, 776, -416},
    { 24, 800, -512},
    { 16, 792, -264},
    { 40, 768, -384},
    { -16, 712, -328},
    { -64, 664, -416},
    { -40, 728, -360},
    { -104, 744, -464},
    { -40, 856, -424},
    { -104, 800, -472},
    { -104, 912, -440},
    { -144, 856, -352},
    { -88, 904, -504},
    { -88, 832, -320},
    { -32, 896, -432},
    { -104, 920, -480},
    { -136, 936, -408},
    { -96, 912, -552},
    { -136, 896, -552},
    { -136, 848, -528},
    { -160, 800, -520},
    { -176, 784, -512},
    { -192, 816, -536},
    // 95 seconds
    { -160, 824, -544},
    { -160, 768, -552},
    { -216, 680, -544},
    { -256, 664, -608},
    { -304, 680, -560},
    { -344, 672, -560},
    { -368, 672, -584},
    { -376, 608, -520},
    { -336, 608, -632},
    { -392, 568, -512},
    { -312, 608, -552},
    { -384, 520, -584},
    { -312, 616, -568},
    { -352, 528, -624},
    { -312, 632, -568},
    { -288, 624, -584},
    { -312, 592, -568},
    { -328, 560, -576},
    { -368, 584, -592},
    { -368, 616, -600},
    { -384, 688, -608},
    { -424, 672, -640},
    { -416, 648, -640},
    { -400, 648, -568},
    { -352, 640, -544},
    // 96 seconds
    { -336, 616, -552},
    { -344, 592, -568},
    { -336, 592, -624},
    { -328, 592, -624},
    { -328, 632, -616},
    { -336, 648, -632},
    { -352, 656, -648},
    { -320, 664, -648},
    { -296, 672, -640},
    { -312, 664, -600},
    { -328, 632, -584},
    { -336, 624, -576},
    { -344, 640, -600},
    { -352, 632, -584},
    { -320, 672, -600},
    { -304, 688, -576},
    { -304, 712, -584},
    { -312, 704, -568},
    { -320, 712, -536},
    { -336, 704, -536},
    { -336, 720, -536},
    { -328, 736, -552},
    { -304, 728, -560},
    { -328, 728, -584},
    { -360, 696, -536},
    // 97 seconds
    { -352, 688, -536},
    { -328, 664, -512},
    { -320, 680, -536},
    { -304, 680, -520},
    { -280, 720, -560},
    { -344, 696, -528},
    { -328, 752, -520},
    { -368, 792, -528},
    { -368, 768, -496},
    { -336, 712, -480},
    { -336, 680, -488},
    { -304, 680, -488},
    { -288, 672, -496},
    { -304, 664, -488},
    { -376, 672, -472},
    { -400, 736, -472},
    { -416, 784, -472},
    { -432, 792, -464},
    { -440, 816, -456},
    { -448, 808, -440},
    { -456, 808, -424},
    { -416, 792, -424},
    { -368, 752, -408},
    { -344, 736, -448},
    { -344, 704, -456},
    // 98 seconds
    { -368, 696, -472},
    { -344, 720, -456},
    { -328, 760, -456},
    { -312, 768, -456},
    { -312, 776, -456},
    { -296, 776, -456},
    { -296, 792, -464},
    { -304, 792, -456},
    { -296, 776, -448},
    { -296, 752, -448},
    { -272, 728, -432},
    { -256, 720, -448},
    { -248, 728, -480},
    { -264, 720, -456},
    { -280, 744, -440},
    { -288, 784, -416},
    { -288, 832, -416},
    { -304, 832, -416},
    { -328, 824, -424},
    { -328, 816, -424},
    { -336, 816, -448},
    { -328, 800, -424},
    { -320, 760, -408},
    { -328, 752, -416},
    { -312, 744, -416},
    // 99 seconds
    { -296, 744, -448},
    { -304, 728, -440},
    { -312, 776, -456},
    { -320, 808, -448},
    { -336, 816, -432},
    { -312, 824, -432},
    { -328, 808, -424},
    { -320, 792, -440},
    { -320, 768, -432},
    { -304, 776, -432},
    { -296, 768, -432},
    { -280, 768, -424},
    { -264, 760, -448},
    { -288, 720, -448},
    { -296, 704, -440},
    { -304, 752, -416},
    { -288, 824, -408},
    { -296, 832, -432},
    { -320, 800, -448},
    { -344, 776, -424},
    { -328, 800, -424},
    { -312, 792, -432},
    { -312, 760, -448},
    { -328, 736, -448},
    { -304, 752, -456},
    // 100 seconds
    { -304, 736, -448},
    { -296, 744, -432},
    { -288, 776, -424},
    { -320, 792, -424},
    { -344, 800, -448},
    { -352, 776, -472},
    { -344, 792, -440},
    { -336, 800, -432},
    { -368, 840, -416},
    { -384, 832, -376},
    { -376, 816, -400},
    { -416, 784, -424},
    { -408, 768, -432},
    { -408, 792, -424},
    { -424, 784, -392},
    { -448, 736, -392},
    { -488, 776, -488},
    { -560, 792, -464},
    { -520, 744, -408},
    { -544, 688, -416},
    { -528, 648, -424},
    { -520, 624, -384},
    { -464, 616, -352},
    { -440, 672, -432},
    { -472, 672, -400},
    // 101 seconds
    { -472, 688, -464},
    { -464, 704, -432},
    { -464, 736, -440},
    { -440, 760, -480},
    { -456, 704, -480},
    { -472, 672, -456},
    { -480, 680, -488},
    { -472, 624, -472},
    { -464, 616, -496},
    { -448, 608, -472},
    { -504, 568, -528},
    { -536, 576, -520},
    { -544, 576, -560},
    { -544, 584, -536},
    { -544, 560, -544},
    { -560, 568, -536},
    { -544, 592, -536},
    { -544, 568, -504},
    { -536, 584, -544},
    { -536, 560, -568},
    { -520, 552, -584},
    { -512, 560, -584},
    { -520, 552, -568},
    { -536, 568, -600},
    { -552, 544, -592},
    // 102 seconds
    { -544, 512, -616},
    { -552, 496, -616},
    { -544, 496, -608},
    { -528, 520, -640},
    { -520, 520, -624},
    { -496, 520, -664},
    { -496, 504, -640},
    { -504, 512, -656},
    { -528, 480, -680},
    { -528, 472, -672},
    { -520, 472, -696},
    { -528, 432, -712},
    { -544, 432, -720},
    { -544, 416, -712},
    { -520, 408, -712},
    { -544, 368, -720},
    { -552, 344, -728},
    { -528, 360, -728},
    { -520, 344, -752},
    { -512, 328, -760},
    { -528, 336, -760},
    { -520, 304, -784},
    { -528, 280, -792},
    { -528, 296, -768},
    { -512, 320, -760},
    // 103 seconds
    { -544, 280, -808},
    { -528, 288, -816},
    { -536, 344, -792},
    { -536, 264, -808},
    { -544, 248, -792},
    { -544, 232, -792},
    { -528, 240, -768},
    { -552, 168, -784},
    { -576, 152, -768},
    { -568, 200, -784},
    { -552, 208, -816},
    { -560, 192, -800},
    { -552, 176, -816},
    { -552, 176, -808},
    { -560, 144, -760},
    { -552, 152, -832},
    { -568, 80, -824},
    { -560, 112, -824},
    { -568, 88, -824},
    { -560, 80, -808},
    { -584, 112, -824},
    { -568, 112, -808},
    { -568, 72, -832},
    { -544, 96, -824},
    { -560, 88, -808},
    // 104 seconds
    { -552, 72, -816},
    { -576, 8, -848},
    { -560, 40, -816},
    { -560, 64, -840},
    { -568, 48, -840},
    { -584, 40, -824},
    { -568, 48, -816},
    { -576, 24, -840},
    { -568, 48, -832},
    { -568, 24, -856},
    { -568, 24, -840},
    { -568, 32, -832},
    { -592, 16, -840},
    { -568, 16, -848},
    { -568, -16, -840},
    { -560, -8, -840},
    { -568, -40, -840},
    { -552, 16, -824},
    { -568, -16, -816},
    { -552, -16, -832},
    { -544, -16, -848},
    { -560, -16, -808},
    { -552, -16, -824},
    { -560, -24, -840},
    { -560, -32, -824},
    // 105 seconds
    { -544, -40, -840},
    { -528, -40, -800},
    { -536, -16, -824},
    { -528, 0, -840},
    { -552, 24, -856},
    { -552, 0, -848},
    { -544, 8, -824},
    { -528, 8, -808},
    { -504, 16, -784},
    { -496, 40, -800},
    { -560, 72, -752},
    { -512, 184, -808},
    { -560, 216, -768},
    { -552, 296, -800},
    { -560, 296, -768},
    { -552, 368, -736},
    { -504, 392, -736},
    { -456, 360, -720},
    { -416, 408, -688},
    { -384, 424, -584},
    { -360, 560, -504},
    { -352, 624, -448},
    { -376, 576, -416},
    { -392, 640, -432},
    { -440, 576, -368},
    // 106 seconds
    { -432, 656, -352},
    { -352, 768, -304},
    { -432, 704, -344},
    { -392, 832, -264},
    { -408, 936, -384},
    { -352, 864, -424},
    { -296, 848, -392},
    { -200, 824, -544},
    { -136, 776, -640},
    { -104, 872, -648},
    { -40, 968, -640},
    { -88, 1000, -536},
    { -80, 952, -536},
    { -96, 880, -528},
    { -104, 864, -464},
    { -112, 832, -472},
    { -120, 776, -424},
    { -104, 776, -464},
    { -120, 776, -528},
    { -176, 784, -512},
    { -232, 768, -512},
    { -248, 792, -528},
    { -264, 792, -504},
    { -240, 904, -624},
    { -48, 1024, -472},
    // 107 seconds
    { 104, 976, -552},
    { 240, 936, -496},
    { 448, 888, -520},
    { 368, 768, -392},
    { 224, 872, -432},
    { 144, 656, -360},
    { 80, 632, -344},
    { -32, 576, -368},
    { -32, 592, -368},
    { -96, 608, -376},
    { -128, 664, -480},
    { -160, 776, -536},
    { -128, 1000, -640},
    { -168, 1160, -664},
    { 176, 1272, -680},
    { 104, 904, -504},
    { -40, 984, -424},
    { -24, 1112, -408},
    { 104, 944, -328},
    { 72, 752, -376},
    { 8, 552, -360},
    { -8, 464, -280},
    { -56, 504, -256},
    { -104, 648, -304},
    { -88, 872, -272},
    // 108 seconds
    { -40, 888, -336},
    { -8, 984, -448},
    { 40, 1144, -640},
    { 224, 1224, -408},
    { 200, 1112, -544},
    { 392, 1072, -552},
    { 288, 968, -664},
    { 144, 688, -416},
    { 48, 488, -376},
    { -16, 320, -280},
    { -32, 248, -136},
    { -72, 504, -240},
    { -152, 952, -336},
    { -176, 984, -408},
    { -112, 1152, -520},
    { -112, 1224, -528},
    { 208, 1240, -512},
    { 16, 960, -360},
    { 24, 648, -416},
    { 120, 816, -320},
    { 56, 752, -200},
    { -40, 600, -200},
    { 8, 568, -328},
    { 0, 544, -320},
    { -56, 664, -280},
    // 109 seconds
    { -8, 824, -392},
    { 32, 984, -408},
    { 168, 1008, -496},
    { 264, 1264, -600},
    { 360, 1304, -456},
    { 296, 920, -656},
    { 248, 744, -504},
    { 312, 824, -464},
    { 256, 784, -360},
    { 200, 560, -224},
    { 56, 392, -288},
    { -8, 360, -232},
    { -16, 624, -344},
    { -56, 760, -448},
    { -24, 912, -464},
    { 80, 1072, -688},
    { 176, 1272, -600},
    { 280, 1120, -336},
    { 56, 1040, -248},
    { 200, 1112, -272},
    { 216, 960, -272},
    { 144, 768, -320},
    { 88, 600, -232},
    { 80, 552, -184},
    { -16, 472, -200},
    // 110 seconds
    { -64, 600, -168},
    { 8, 792, -280},
    { 64, 904, -384},
    { 56, 896, -440},
    { 248, 1176, -632},
    { 296, 1176, -552},
    { 240, 1112, -600},
    { 336, 992, -560},
    { 232, 800, -488},
    { 160, 592, -360},
    { 56, 408, -304},
    { 0, 368, -272},
    { -32, 408, -232},
    { -72, 576, -392},
    { -104, 696, -416},
    { -112, 904, -600},
    { 32, 1192, -656},
    { 104, 1616, -648},
    { 240, 1160, -488},
    { 168, 1160, -368},
    { 272, 1152, -344},
    { 208, 856, -352},
    { 112, 608, -344},
    { 48, 536, -336},
    { 40, 448, -288},
    // 111 seconds
    { 16, 520, -320},
    { 80, 696, -392},
    { 120, 864, -344},
    { 272, 1016, -440},
    { 200, 1136, -544},
    { 328, 936, -336},
    { 208, 1064, -632},
    { 344, 1000, -496},
    { 272, 712, -544},
    { 80, 488, -384},
    { -32, 416, -216},
    { -48, 520, -200},
    { -64, 632, -280},
    { 16, 752, -312},
    { 64, 952, -440},
    { 216, 1040, -512},
    { 152, 1208, -600},
    { 336, 1112, -512},
    { 272, 1096, -416},
    { 456, 1168, -376},
    { 384, 1024, -400},
    { 232, 736, -344},
    { 96, 552, -304},
    { 72, 456, -232},
    { 96, 624, -216},
    // 112 seconds
    { 128, 688, -304},
    { 224, 816, -296},
    { 272, 936, -424},
    { 312, 904, -472},
    { 424, 1000, -312},
    { 256, 1080, -616},
    { 344, 1016, -560},
    { 312, 816, -544},
    { 208, 648, -472},
    { 48, 432, -304},
    { 24, 456, -208},
    { -40, 504, -176},
    { -96, 616, -256},
    { -120, 888, -384},
    { -120, 984, -440},
    { 8, 1056, -488},
    { 360, 1584, -632},
    { 32, 1024, -304},
    { 392, 1208, -424},
    { 280, 960, -344},
    { 224, 816, -336},
    { 128, 656, -320},
    { 72, 560, -336},
    { 56, 640, -280},
    { 72, 704, -320},
    // 113 seconds
    { 24, 736, -360},
    { 32, 864, -408},
    { 48, 888, -488},
    { 56, 1032, -712},
    { 88, 824, -376},
    { -16, 968, -512},
    { 208, 936, -544},
    { 40, 656, -416},
    { 64, 576, -464},
    { -40, 360, -240},
    { -16, 472, -280},
    { -160, 528, -304},
    { -200, 776, -368},
    { -224, 912, -536},
    { -152, 1072, -648},
    { -184, 1056, -656},
    { 160, 1224, -544},
    { 104, 1272, -424},
    { 56, 1056, -312},
    { 96, 920, -344},
    { 80, 728, -392},
    { 16, 608, -344},
    { 0, 472, -272},
    { -32, 448, -280},
    { -24, 672, -328},
    // 114 seconds
    { 8, 832, -376},
    { 40, 952, -480},
    { 32, 1000, -544},
    { 216, 1160, -584},
    { 72, 1000, -512},
    { 200, 1072, -592},
    { 256, 936, -488},
    { 128, 656, -464},
    { -24, 512, -328},
    { -56, 488, -264},
    { -72, 504, -272},
    { -112, 616, -272},
    { -136, 720, -408},
    { -120, 936, -504},
    { -24, 1040, -584},
    { -40, 1192, -632},
    { 64, 1104, -344},
    { 96, 1272, -504},
    { 184, 1168, -352},
    { 192, 904, -448},
    { 80, 624, -400},
    { -24, 448, -312},
    { -40, 448, -256},
    { -64, 560, -264},
    { -104, 656, -288},
    // 115 seconds
    { -8, 840, -376},
    { 32, 912, -488},
    { 0, 968, -672},
    { 192, 1000, -368},
    { 8, 1056, -672},
    { 192, 1112, -568},
    { 224, 856, -600},
    { 88, 648, -512},
    { -56, 520, -352},
    { -80, 456, -208},
    { -152, 488, -184},
    { -192, 640, -280},
    { -224, 840, -384},
    { -184, 896, -456},
    { -24, 1048, -632},
    { 32, 1256, -656},
    { 112, 1208, -512},
    { 216, 1224, -512},
    { 200, 1064, -408},
    { 120, 760, -520},
    { 8, 560, -392},
    { 8, 584, -384},
    { -56, 472, -296},
    { -40, 568, -336},
    { -32, 600, -368},
    // 116 seconds
    { -8, 792, -408},
    { 16, 856, -504},
    { -112, 976, -680},
    { 136, 792, -656},
    { 48, 1048, -688},
    { 56, 1200, -648},
    { 32, 800, -624},
    { -8, 528, -520},
    { -48, 504, -480},
    { -96, 440, -288},
    { -168, 488, -328},
    { -224, 520, -384},
    { -232, 632, -360},
    { -24, 920, -512},
    { 0, 904, -656},
    { 232, 1376, -640},
    { 40, 1200, -560},
    { 104, 1048, -552},
    { 176, 992, -536},
    { 208, 920, -576},
    { 96, 616, -448},
    { -8, 408, -376},
    { -24, 496, -360},
    { -64, 520, -328},
    { 8, 728, -384},
    // 117 seconds
    { 40, 896, -480},
    { 80, 880, -648},
    { 184, 1104, -848},
    { -64, 936, -520},
    { 96, 1072, -736},
    { 272, 984, -688},
    { 96, 600, -512},
    { -80, 488, -408},
    { -96, 520, -304},
    { -80, 496, -312},
    { -40, 624, -472},
    { -120, 640, -432},
    { -40, 896, -600},
    { -8, 960, -736},
    { -40, 976, -736},
    { 56, 1080, -528},
    { 112, 1048, -680},
    { 256, 1048, -448},
    { 144, 824, -496},
    { 40, 568, -560},
    { 40, 728, -456},
    { 8, 520, -360},
    { 48, 496, -352},
    { 64, 648, -328},
    { 64, 984, -504},
    // 118 seconds
    { 96, 968, -624},
    { 128, 1112, -472},
    { 176, 1040, -560},
    { 88, 800, -512},
    { 160, 784, -432},
    { 144, 840, -568},
    { 0, 608, -432},
    { -48, 464, -352},
    { -40, 504, -336},
    { -104, 600, -232},
    { -160, 728, -392},
    { -128, 840, -432},
    { -72, 880, -592},
    { 216, 1416, -720},
    { 192, 1320, -576},
    { 120, 976, -376},
    { 128, 856, -312},
    { 88, 816, -264},
    { 128, 912, -360},
    { 48, 696, -280},
    { 32, 600, -168},
    { 40, 688, -336},
    { 0, 792, -296},
    { 40, 936, -456},
    { 80, 1000, -496},
    // 119 seconds
    { 192, 1072, -440},
    { 160, 824, -504},
    { 96, 784, -504},
    { 280, 832, -456},
    { 160, 728, -416},
    { 48, 616, -392},
    { 8, 536, -256},
    { -88, 472, -208},
    { -120, 656, -352},
    { -192, 720, -408},
    { -224, 888, -448},
    { -120, 1088, -576},
    { -184, 1016, -560},
    { 176, 1120, -560},
    { 120, 1152, -464},
    { 152, 1136, -376},
    { 200, 1000, -376},
    { 192, 776, -368},
    { 128, 648, -400},
    { 24, 512, -320},
    { -40, 504, -304},
    { -16, 648, -336},
    { -16, 752, -352},
    { 88, 928, -520},
    { 128, 920, -592},
    // 120 seconds
    // elapsed: 2 minutes
    { 224, 1040, -600},
    { 128, 976, -600},
    { 88, 928, -560},
    { 160, 800, -520},
    { 128, 752, -440},
    { 0, 536, -368},
    { -72, 456, -296},
    { -80, 488, -264},
    { -96, 696, -344},
    { -56, 936, -416},
    { -152, 968, -576},
    { -32, 888, -792},
    { -152, 1064, -664},
    { 88, 1112, -424},
    { 0, 1168, -432},
    { 144, 1112, -376},
    { 112, 880, -384},
    { 72, 608, -456},
    { 40, 448, -296},
    { 96, 536, -224},
    { 24, 576, -272},
    { 40, 776, -296},
    { 136, 960, -440},
    { 168, 920, -504},
    { 144, 1008, -696},
    // 121 seconds
    { 176, 888, -440},
    { 48, 992, -512},
    { 192, 1080, -504},
    { 168, 832, -480},
    { 128, 656, -424},
    { 0, 544, -408},
    { -8, 656, -424},
    { -16, 488, -272},
    { 40, 608, -184},
    { -128, 776, -384},
    { -16, 1000, -680},
    { -200, 1048, -576},
    { 328, 1208, -544},
    { 152, 1352, -632},
    { 128, 984, -408},
    { 176, 808, -320},
    { 184, 704, -392},
    { 144, 624, -312},
    { 88, 480, -216},
    { 96, 592, -288},
    { 136, 776, -240},
    { 256, 952, -488},
    { 368, 912, -472},
    { 288, 928, -672},
    { 344, 912, -384},
    // 122 seconds
    { 264, 1064, -576},
    { 352, 880, -456},
    { 280, 696, -504},
    { 192, 632, -416},
    { 80, 528, -280},
    { 32, 560, -272},
    { -32, 640, -304},
    { -24, 808, -336},
    { -32, 904, -496},
    { 64, 1056, -584},
    { 32, 1160, -592},
    { 232, 1136, -352},
    { 192, 1104, -472},
    { 296, 1096, -344},
    { 264, 968, -424},
    { 200, 760, -368},
    { 144, 576, -248},
    { 72, 488, -248},
    { 40, 528, -248},
    { 64, 688, -312},
    { 192, 936, -400},
    { 280, 1040, -472},
    { 272, 1200, -528},
    { 232, 840, -408},
    { 40, 888, -544},
    // 123 seconds
    { 328, 1088, -504},
    { 264, 768, -536},
    { 152, 488, -432},
    { 88, 568, -376},
    { -48, 432, -304},
    { -88, 664, -312},
    { 0, 840, -384},
    { -8, 896, -440},
    { 96, 888, -616},
    { -96, 1064, -576},
    { 272, 984, -408},
    { 56, 1056, -512},
    { 176, 1072, -440},
    { 248, 968, -336},
    { 192, 800, -552},
    { 80, 664, -440},
    { 72, 392, -216},
    { 24, 416, -296},
    { 40, 632, -408},
    { 176, 888, -520},
    { 240, 856, -584},
    { 216, 1064, -736},
    { 288, 912, -400},
    { 208, 984, -600},
    { 408, 1016, -592},
    // 124 seconds
    { 288, 760, -488},
    { 144, 576, -336},
    { 56, 584, -304},
    { 0, 560, -312},
    { -64, 552, -384},
    { -80, 568, -424},
    { -8, 792, -608},
    { 48, 1000, -728},
    { -24, 1112, -712},
    { 248, 1208, -544},
    { 208, 1192, -584},
    { 200, 1000, -488},
    { 224, 944, -376},
    { 232, 792, -464},
    { 112, 568, -344},
    { 112, 496, -280},
    { 32, 496, -240},
    { 96, 712, -320},
    { 120, 800, -328},
    { 224, 920, -488},
    { 208, 904, -544},
    { 304, 1024, -440},
    { 224, 1080, -640},
    { 336, 968, -616},
    { 352, 808, -576},
    // 125 seconds
    { 160, 600, -448},
    { -16, 464, -280},
    { -64, 456, -224},
    { -112, 528, -208},
    { -96, 752, -296},
    { -64, 912, -464},
    { -56, 920, -496},
    { 40, 1000, -584},
    { -48, 1104, -632},
    { 200, 1128, -456},
    { 232, 1216, -480},
    { 384, 1144, -384},
    { 320, 1032, -408},
    { 256, 720, -440},
    { 152, 576, -288},
    { 48, 400, -272},
    { -40, 440, -216},
    { -16, 608, -280},
    { 152, 944, -376},
    { 296, 1000, -520},
    { 256, 944, -760},
    { 296, 928, -336},
    { 136, 1016, -640},
    { 216, 1064, -576},
    { 272, 832, -568},
    // 126 seconds
    { 144, 488, -424},
    { 32, 392, -288},
    { 40, 512, -272},
    { -40, 552, -256},
    { -32, 800, -376},
    { -24, 888, -480},
    { 40, 1016, -584},
    { -40, 1128, -552},
    { 352, 1128, -480},
    { 328, 1184, -552},
    { 360, 912, -384},
    { 304, 968, -440},
    { 216, 744, -352},
    { 168, 536, -280},
    { 120, 472, -296},
    { 96, 520, -224},
    { 152, 696, -376},
    { 280, 896, -464},
    { 416, 976, -376},
    { 504, 1024, -680},
    { 392, 848, -328},
    { 384, 1056, -504},
    { 368, 904, -616},
    { 320, 656, -480},
    { 208, 560, -408},
    // 127 seconds
    { 72, 480, -288},
    { 48, 624, -232},
    { 0, 632, -288},
    { 0, 752, -344},
    { 40, 896, -512},
    { 176, 984, -456},
    { 360, 1424, -600},
    { 384, 1192, -416},
    { 280, 1064, -520},
    { 336, 1000, -472},
    { 312, 904, -368},
    { 192, 656, -368},
    { 160, 520, -392},
    { 144, 496, -240},
    { 120, 496, -344},
    { 128, 680, -336},
    { 256, 920, -448},
    { 416, 856, -448},
    { 400, 960, -544},
    { 344, 856, -400},
    { 280, 928, -552},
    { 384, 920, -488},
    { 328, 680, -496},
    { 120, 448, -392},
    { 16, 472, -312},
    // 128 seconds
    { -8, 600, -232},
    { -40, 664, -280},
    { -48, 840, -416},
    { 8, 1056, -504},
    { 104, 1072, -544},
    { 72, 1216, -568},
    { 296, 1120, -368},
    { 208, 1080, -376},
    { 296, 1080, -344},
    { 272, 952, -296},
    { 304, 784, -376},
    { 176, 544, -248},
    { 128, 488, -208},
    { 88, 544, -280},
    { 120, 664, -280},
    { 224, 896, -384},
    { 280, 920, -448},
    { 224, 880, -552},
    { 368, 992, -360},
    { 176, 1008, -536},
    { 272, 1008, -472},
    { 328, 888, -496},
    { 192, 600, -456},
    { 64, 560, -320},
    { 32, 600, -272},
    // 129 seconds
    { 0, 672, -272},
    { -32, 696, -264},
    { -8, 840, -416},
    { 40, 896, -456},
    { 160, 928, -600},
    { 192, 1192, -672},
    { 328, 1056, -360},
    { 328, 1048, -504},
    { 304, 960, -408},
    { 296, 928, -384},
    { 344, 816, -360},
    { 312, 680, -312},
    { 224, 632, -336},
    { 192, 608, -264},
    { 176, 688, -336},
    { 152, 728, -352},
    { 88, 664, -360},
    { 32, 720, -424},
    { -16, 760, -400},
    { 120, 1000, -512},
    { 112, 984, -496},
    { 176, 1048, -544},
    { 224, 1000, -632},
    { 256, 832, -488},
    { 312, 856, -480},
    // 130 seconds
    { 288, 792, -424},
    { 280, 736, -424},
    { 176, 720, -488},
    { 120, 760, -456},
    { 128, 696, -392},
    { 208, 744, -416},
    { 264, 760, -424},
    { 208, 712, -432},
    { 160, 816, -432},
    { 152, 856, -448},
    { 152, 848, -496},
    { 104, 816, -488},
    { 88, 808, -464},
    { 104, 784, -456},
    { 104, 744, -456},
    { 112, 784, -456},
    { 120, 792, -480},
    { 88, 784, -504},
    { 72, 824, -560},
    { 88, 848, -560},
    { 24, 760, -488},
    { 32, 792, -608},
    { 32, 784, -584},
    { 40, 768, -688},
    { 16, 608, -680},
    // 131 seconds
    { 40, 632, -728},
    { 32, 592, -744},
    { 56, 368, -768},
    { 48, 408, -784},
    { 136, 368, -832},
    { 112, 376, -856},
    { 128, 336, -944},
    { 104, 408, -912},
    { 136, 200, -776},
    { 128, 336, -968},
    { 128, 208, -920},
    { 136, 248, -944},
    { 96, 176, -952},
    { 112, 256, -960},
    { 88, 168, -808},
    { 160, 144, -976},
    { 136, 152, -928},
    { 168, 160, -960},
    { 144, 72, -920},
    { 184, 112, -976},
    { 216, 160, -960},
    { 192, 96, -992},
    { 192, 112, -984},
    { 208, 184, -968},
    { 168, 160, -952},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-07 13:50:14 local
AccelRawData *activity_sample_walk_200_pbl_25820_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25820_10
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 304, 128, -944},
    { 280, 120, -944},
    { 320, 96, -968},
    { 312, 88, -976},
    { 272, 80, -944},
    { 240, 40, -928},
    { 272, 48, -936},
    { 200, 16, -904},
    { 224, 0, -992},
    { 288, 0, -968},
    { 168, -32, -928},
    { 200, -8, -936},
    { 168, 0, -960},
    { 168, 16, -968},
    { 200, -24, -984},
    { 200, -8, -968},
    { 208, 0, -976},
    { 216, -8, -984},
    { 200, -40, -1000},
    { 208, -24, -992},
    { 216, -64, -976},
    { 192, -56, -952},
    { 184, -56, -1008},
    { 152, -104, -968},
    { 136, -88, -952},
    // 1 seconds
    { 136, -112, -976},
    { 152, -96, -976},
    { 88, -112, -976},
    { 120, -88, -992},
    { 104, -56, -1016},
    { 256, -120, -1024},
    { 144, -64, -976},
    { 152, -48, -952},
    { 136, -56, -920},
    { 144, 0, -920},
    { 152, 0, -904},
    { 136, 8, -920},
    { 136, -32, -928},
    { 152, -8, -944},
    { 200, 32, -1000},
    { 208, 56, -1040},
    { 352, 168, -1096},
    { 328, 328, -1032},
    { 200, 184, -1040},
    { 160, 128, -1040},
    { 144, 352, -928},
    { 192, 360, -872},
    { 232, 304, -920},
    { 288, 240, -936},
    { 168, 136, -864},
    // 2 seconds
    { 120, 160, -800},
    { 120, 120, -752},
    { 136, 152, -712},
    { 128, 168, -680},
    { 136, 192, -704},
    { 200, 208, -696},
    { 312, 312, -744},
    { 360, 312, -800},
    { 688, 400, -912},
    { 832, 568, -952},
    { 824, 520, -920},
    { 632, 424, -776},
    { 568, 328, -616},
    { 584, 272, -496},
    { 536, 248, -496},
    { 496, 216, -464},
    { 496, 240, -456},
    { 536, 240, -456},
    { 616, 312, -568},
    { 752, 360, -648},
    { 936, 336, -776},
    { 1136, 328, -744},
    { 1216, 368, -688},
    { 808, 272, -544},
    { 840, 240, -528},
    // 3 seconds
    { 992, 264, -496},
    { 928, 200, -456},
    { 744, 112, -376},
    { 680, 24, -336},
    { 688, 48, -304},
    { 648, 40, -288},
    { 776, 40, -392},
    { 944, 16, -432},
    { 1088, 24, -464},
    { 1184, 0, -552},
    { 1032, 64, -392},
    { 1040, 192, -536},
    { 1056, 168, -512},
    { 848, 8, -424},
    { 672, 0, -320},
    { 504, 56, -272},
    { 480, 80, -296},
    { 544, 120, -256},
    { 680, 200, -424},
    { 776, 224, -480},
    { 1024, 296, -632},
    { 1248, 176, -576},
    { 1384, 168, -624},
    { 1096, 232, -416},
    { 1096, -64, -296},
    // 4 seconds
    { 1104, 80, -368},
    { 928, 48, -384},
    { 696, -8, -280},
    { 552, 64, -280},
    { 600, 112, -200},
    { 728, 120, -272},
    { 832, -88, -280},
    { 952, -216, -400},
    { 1072, -168, -408},
    { 1400, -272, -496},
    { 1104, 48, -384},
    { 1008, 80, -488},
    { 944, -32, -504},
    { 880, -152, -368},
    { 728, -104, -320},
    { 552, 0, -264},
    { 464, -8, -248},
    { 552, 0, -264},
    { 744, 64, -376},
    { 840, 96, -480},
    { 1000, 96, -616},
    { 1120, 8, -528},
    { 1472, 40, -536},
    { 1112, 216, -400},
    { 1216, 40, -400},
    // 5 seconds
    { 1344, 0, -320},
    { 1120, -24, -304},
    { 752, -48, -312},
    { 560, -32, -256},
    { 520, 8, -216},
    { 568, -16, -192},
    { 736, -32, -232},
    { 936, -120, -256},
    { 1104, -136, -288},
    { 1256, -168, -344},
    { 1104, -80, -328},
    { 1072, -16, -392},
    { 976, -56, -424},
    { 904, -88, -400},
    { 760, -32, -304},
    { 552, 40, -288},
    { 504, 32, -216},
    { 592, 32, -192},
    { 768, 144, -256},
    { 864, 136, -400},
    { 1064, 136, -480},
    { 1152, 104, -464},
    { 1464, 96, -424},
    { 1200, 200, -312},
    { 1296, 96, -304},
    // 6 seconds
    { 1344, 24, -240},
    { 1128, -8, -216},
    { 736, 16, -224},
    { 504, -8, -208},
    { 448, -8, -160},
    { 608, 24, -200},
    { 864, 32, -232},
    { 1120, -8, -304},
    { 1184, -56, -344},
    { 1576, -176, -504},
    { 896, 144, -328},
    { 984, -40, -512},
    { 1112, 24, -456},
    { 936, -32, -336},
    { 656, -24, -248},
    { 488, 0, -216},
    { 416, 40, -200},
    { 552, 120, -200},
    { 768, 160, -312},
    { 880, 296, -456},
    { 1008, 200, -560},
    { 1152, 192, -544},
    { 1368, 256, -592},
    { 1160, 272, -416},
    { 1216, 72, -432},
    // 7 seconds
    { 1264, -96, -240},
    { 984, -16, -320},
    { 704, 0, -224},
    { 512, 48, -224},
    { 392, 64, -232},
    { 528, -16, -232},
    { 920, 24, -248},
    { 1216, 16, -280},
    { 1288, -160, -384},
    { 1600, -304, -344},
    { 928, 96, -304},
    { 1016, -32, -376},
    { 1032, 72, -392},
    { 848, -64, -520},
    { 632, -48, -272},
    { 496, 16, -256},
    { 432, 8, -168},
    { 568, 24, -160},
    { 728, 72, -304},
    { 960, 136, -360},
    { 1192, 168, -616},
    { 1448, 64, -400},
    { 1200, 160, -576},
    { 1184, 88, -288},
    { 1296, 40, -416},
    // 8 seconds
    { 1200, -24, -184},
    { 864, 24, -288},
    { 632, 16, -232},
    { 520, 32, -200},
    { 576, 48, -216},
    { 696, 64, -232},
    { 880, 16, -296},
    { 1064, -56, -328},
    { 1144, -80, -392},
    { 1360, -104, -352},
    { 888, 232, -400},
    { 968, 88, -408},
    { 920, 80, -416},
    { 800, 0, -312},
    { 616, -24, -256},
    { 488, 16, -184},
    { 488, 56, -208},
    { 632, 136, -248},
    { 784, 232, -376},
    { 936, 256, -424},
    { 1176, 208, -472},
    { 1664, 120, -432},
    { 1144, 256, -288},
    { 1224, 96, -368},
    { 1232, 16, -264},
    // 9 seconds
    { 1096, -8, -216},
    { 752, 48, -200},
    { 584, 88, -248},
    { 512, 48, -216},
    { 688, 104, -224},
    { 776, 64, -272},
    { 920, 160, -384},
    { 1056, 152, -416},
    { 1120, 56, -472},
    { 1088, 112, -424},
    { 656, 200, -440},
    { 984, 32, -392},
    { 912, 112, -472},
    { 696, 56, -344},
    { 480, 136, -248},
    { 440, 144, -264},
    { 472, 144, -224},
    { 560, 184, -344},
    { 736, 168, -384},
    { 904, 272, -512},
    { 992, 176, -560},
    { 1408, 120, -552},
    { 1104, 264, -344},
    { 1304, 160, -416},
    { 1272, 136, -392},
    // 10 seconds
    { 984, 80, -336},
    { 656, 32, -328},
    { 488, 8, -336},
    { 504, 0, -264},
    { 656, 64, -256},
    { 808, 48, -296},
    { 992, 0, -304},
    { 1248, 8, -416},
    { 1472, -56, -416},
    { 1208, 48, -288},
    { 1008, -96, -352},
    { 1056, 136, -472},
    { 960, 72, -360},
    { 632, 8, -280},
    { 424, 8, -224},
    { 400, 40, -168},
    { 552, 96, -192},
    { 704, 200, -312},
    { 896, 224, -392},
    { 1048, 256, -464},
    { 1152, 240, -384},
    { 1264, 248, -488},
    { 1160, 200, -312},
    { 1312, 160, -328},
    { 1280, 96, -256},
    // 11 seconds
    { 1024, 56, -280},
    { 744, 32, -208},
    { 544, 24, -208},
    { 496, 0, -192},
    { 592, 32, -224},
    { 744, 64, -248},
    { 920, 56, -312},
    { 1096, -16, -360},
    { 1216, -48, -456},
    { 1216, -64, -280},
    { 792, 120, -464},
    { 1024, 8, -360},
    { 1040, 32, -360},
    { 864, -24, -312},
    { 624, 0, -264},
    { 488, 24, -208},
    { 464, 32, -184},
    { 608, 120, -192},
    { 784, 176, -312},
    { 984, 208, -440},
    { 1152, 128, -496},
    { 1400, 88, -408},
    { 1264, 144, -456},
    { 1160, 104, -368},
    { 1288, 16, -256},
    // 12 seconds
    { 1288, -40, -240},
    { 928, 8, -232},
    { 632, -40, -216},
    { 536, -40, -208},
    { 648, -24, -208},
    { 768, 32, -232},
    { 904, -8, -256},
    { 1136, 0, -376},
    { 1232, -8, -344},
    { 1496, -104, -432},
    { 880, 176, -384},
    { 1080, 0, -408},
    { 992, 96, -456},
    { 760, 0, -392},
    { 512, 64, -296},
    { 424, 96, -288},
    { 456, 120, -184},
    { 560, 192, -280},
    { 656, 240, -336},
    { 768, 312, -400},
    { 928, 432, -496},
    { 1320, 424, -584},
    { 1208, 448, -528},
    { 1152, 336, -448},
    { 1176, 208, -344},
    // 13 seconds
    { 1016, 152, -336},
    { 816, 96, -288},
    { 632, 80, -248},
    { 520, 48, -248},
    { 592, 24, -208},
    { 704, 88, -272},
    { 840, 80, -288},
    { 1072, 32, -352},
    { 1136, 32, -456},
    { 1480, -192, -376},
    { 832, 240, -400},
    { 1088, 0, -392},
    { 1056, 88, -392},
    { 968, 16, -368},
    { 696, -16, -232},
    { 536, 8, -232},
    { 456, 16, -200},
    { 560, 80, -200},
    { 728, 192, -288},
    { 928, 184, -360},
    { 1072, 192, -496},
    { 1136, 136, -440},
    { 1448, 88, -448},
    { 928, 232, -352},
    { 1160, 72, -376},
    // 14 seconds
    { 1328, 40, -312},
    { 1176, 24, -280},
    { 808, 0, -232},
    { 568, -8, -216},
    { 456, -32, -184},
    { 552, -8, -192},
    { 728, 40, -264},
    { 1000, -24, -328},
    { 1168, 16, -344},
    { 1400, -80, -504},
    { 1128, 48, -264},
    { 1096, 136, -488},
    { 1160, 104, -480},
    { 1000, 8, -352},
    { 704, -40, -272},
    { 488, -24, -208},
    { 408, 24, -208},
    { 528, 56, -224},
    { 704, 152, -352},
    { 848, 272, -416},
    { 1072, 216, -504},
    { 1152, 104, -408},
    { 1392, 104, -496},
    { 1288, 192, -352},
    { 1384, 80, -304},
    // 15 seconds
    { 1264, 0, -248},
    { 872, 24, -256},
    { 520, 32, -240},
    { 496, 8, -240},
    { 552, 24, -248},
    { 624, 8, -224},
    { 856, -16, -200},
    { 1136, 72, -216},
    { 1200, 80, -288},
    { 1320, -96, -464},
    { 896, 136, -184},
    { 1080, -8, -472},
    { 1184, 56, -376},
    { 1000, 144, -384},
    { 616, 120, -360},
    { 456, 56, -184},
    { 464, 112, -200},
    { 560, 120, -208},
    { 696, 208, -312},
    { 832, 224, -320},
    { 1048, 248, -528},
    { 1128, 176, -384},
    { 1384, 136, -448},
    { 1136, 264, -392},
    { 1208, 72, -368},
    // 16 seconds
    { 1200, 128, -304},
    { 952, 64, -320},
    { 704, 24, -232},
    { 576, 40, -200},
    { 520, 72, -208},
    { 576, 56, -208},
    { 848, 64, -216},
    { 1104, -8, -352},
    { 1136, 8, -360},
    { 1360, -88, -368},
    { 1128, 200, -472},
    { 960, 160, -504},
    { 904, 56, -464},
    { 768, 16, -288},
    { 568, 40, -216},
    { 464, 96, -216},
    { 552, 144, -192},
    { 656, 216, -384},
    { 744, 152, -360},
    { 1104, 160, -544},
    { 1128, 288, -488},
    { 1368, 208, -480},
    { 992, 232, -344},
    { 1136, 48, -368},
    { 1200, 112, -360},
    // 17 seconds
    { 912, 152, -392},
    { 720, 56, -320},
    { 536, 72, -288},
    { 440, 96, -256},
    { 608, 104, -176},
    { 872, 32, -144},
    { 1160, 16, -296},
    { 1192, 80, -416},
    { 1712, -160, -440},
    { 968, 224, -456},
    { 992, 80, -464},
    { 952, 120, -480},
    { 760, 88, -408},
    { 528, 40, -296},
    { 456, 48, -248},
    { 344, 72, -200},
    { 544, 136, -256},
    { 768, 192, -320},
    { 984, 208, -432},
    { 1024, 208, -576},
    { 1456, 184, -568},
    { 1000, 336, -464},
    { 1288, 128, -440},
    { 1248, 152, -360},
    { 936, 120, -328},
    // 18 seconds
    { 696, 88, -280},
    { 592, 80, -264},
    { 488, 96, -280},
    { 544, 104, -288},
    { 800, 88, -336},
    { 1032, 96, -392},
    { 1208, 48, -456},
    { 1712, -72, -576},
    { 928, 256, -520},
    { 1080, 88, -512},
    { 1048, 152, -464},
    { 784, 64, -368},
    { 456, 88, -280},
    { 424, 144, -240},
    { 536, 168, -272},
    { 648, 208, -288},
    { 712, 280, -416},
    { 912, 272, -592},
    { 1048, 256, -440},
    { 1192, 376, -544},
    { 1024, 440, -512},
    { 1112, 264, -432},
    { 1112, 152, -368},
    { 864, 152, -368},
    { 656, 120, -320},
    // 19 seconds
    { 456, 48, -288},
    { 520, 24, -272},
    { 712, 96, -320},
    { 832, 136, -384},
    { 1000, 80, -448},
    { 1112, 136, -520},
    { 1424, 80, -600},
    { 936, 264, -512},
    { 920, 152, -416},
    { 920, 152, -504},
    { 712, 96, -400},
    { 512, 88, -400},
    { 432, 64, -312},
    { 456, 128, -320},
    { 576, 152, -384},
    { 752, 256, -536},
    { 872, 304, -640},
    { 984, 256, -640},
    { 1336, 224, -656},
    { 1040, 320, -496},
    { 1048, 240, -456},
    { 1120, 112, -360},
    { 1016, 64, -368},
    { 744, 104, -344},
    { 576, 96, -376},
    // 20 seconds
    { 584, 104, -408},
    { 640, 48, -416},
    { 720, 144, -384},
    { 904, 152, -448},
    { 1016, 128, -432},
    { 1048, 160, -584},
    { 936, 208, -560},
    { 872, 312, -520},
    { 800, 224, -472},
    { 632, 152, -416},
    { 448, 88, -424},
    { 432, 160, -352},
    { 456, 160, -384},
    { 584, 240, -384},
    { 640, 360, -536},
    { 720, 408, -608},
    { 872, 432, -712},
    { 1304, 376, -680},
    { 1152, 400, -568},
    { 1064, 368, -456},
    { 1056, 304, -424},
    { 968, 272, -408},
    { 840, 264, -408},
    { 568, 200, -328},
    { 432, 120, -336},
    // 21 seconds
    { 528, 120, -272},
    { 672, 184, -336},
    { 856, 240, -408},
    { 1032, 200, -480},
    { 1280, 144, -624},
    { 1096, 416, -456},
    { 936, 424, -608},
    { 912, 120, -480},
    { 776, 136, -448},
    { 608, 160, -328},
    { 448, 136, -264},
    { 408, 144, -344},
    { 480, 152, -304},
    { 656, 264, -480},
    { 840, 264, -552},
    { 984, 280, -680},
    { 1040, 336, -640},
    { 1008, 392, -584},
    { 1024, 400, -352},
    { 1120, 240, -376},
    { 1168, 80, -288},
    { 1008, 200, -304},
    { 624, 88, -264},
    { 456, 8, -328},
    { 464, 24, -344},
    // 22 seconds
    { 648, 64, -352},
    { 848, 64, -376},
    { 976, 64, -448},
    { 1128, 72, -488},
    { 1296, 32, -464},
    { 1032, 296, -504},
    { 1008, 136, -488},
    { 880, 104, -352},
    { 736, 16, -376},
    { 520, 48, -336},
    { 424, 8, -264},
    { 520, 72, -224},
    { 696, 152, -352},
    { 816, 128, -408},
    { 992, 128, -488},
    { 1056, 144, -480},
    { 1320, 152, -464},
    { 1112, 240, -368},
    { 1288, 40, -368},
    { 1224, -24, -232},
    { 1040, 72, -256},
    { 720, 72, -248},
    { 512, 32, -200},
    { 480, 40, -240},
    { 592, 24, -176},
    // 23 seconds
    { 840, 88, -256},
    { 1056, 80, -320},
    { 1232, -24, -296},
    { 1608, -64, -280},
    { 776, 344, -392},
    { 1008, 24, -464},
    { 1040, 88, -448},
    { 840, 8, -368},
    { 528, 0, -256},
    { 448, 8, -208},
    { 448, 8, -184},
    { 712, 128, -272},
    { 824, 168, -320},
    { 952, 192, -440},
    { 1048, 176, -472},
    { 1384, 48, -392},
    { 1080, 232, -288},
    { 1160, 72, -384},
    { 1328, 8, -296},
    { 1160, 96, -280},
    { 752, 88, -272},
    { 512, 16, -208},
    { 448, -24, -176},
    { 560, 0, -208},
    { 712, -88, -144},
    // 24 seconds
    { 1072, -72, -208},
    { 1280, -40, -288},
    { 1552, -216, -496},
    { 1144, 32, -272},
    { 1168, 32, -440},
    { 1048, 80, -464},
    { 904, -16, -352},
    { 672, -32, -256},
    { 576, 8, -216},
    { 504, -32, -200},
    { 632, 24, -224},
    { 640, 80, -272},
    { 824, 192, -440},
    { 1144, 232, -488},
    { 1432, 152, -496},
    { 1304, 248, -488},
    { 1000, 192, -360},
    { 1064, 88, -344},
    { 1120, 48, -248},
    { 944, 88, -240},
    { 664, 80, -240},
    { 480, 64, -224},
    { 440, 24, -176},
    { 608, 40, -216},
    { 824, 40, -256},
    // 25 seconds
    { 1064, 16, -320},
    { 1224, 32, -344},
    { 1744, -192, -440},
    { 984, 184, -304},
    { 1048, 56, -512},
    { 1024, 48, -376},
    { 912, -16, -320},
    { 632, 72, -280},
    { 488, 96, -264},
    { 416, 56, -184},
    { 472, 120, -272},
    { 624, 136, -272},
    { 896, 216, -368},
    { 1024, 312, -456},
    { 1096, 208, -416},
    { 1432, 168, -416},
    { 1304, 288, -504},
    { 1072, 120, -368},
    { 1176, 32, -312},
    { 1080, 16, -248},
    { 728, 24, -208},
    { 472, 24, -232},
    { 416, 8, -168},
    { 584, 40, -200},
    { 832, 40, -224},
    // 26 seconds
    { 1112, -8, -336},
    { 1208, -8, -368},
    { 1504, -128, -376},
    { 1216, 96, -384},
    { 960, 160, -568},
    { 992, 64, -376},
    { 880, 24, -344},
    { 632, 16, -272},
    { 496, 64, -256},
    { 472, 72, -280},
    { 608, 160, -248},
    { 688, 176, -360},
    { 816, 272, -456},
    { 1024, 280, -440},
    { 1224, 264, -384},
    { 1072, 352, -416},
    { 1120, 248, -312},
    { 1184, 200, -376},
    { 1136, 96, -272},
    { 912, 8, -240},
    { 664, 8, -224},
    { 544, 0, -192},
    { 544, -8, -168},
    { 712, 8, -200},
    { 960, 16, -280},
    // 27 seconds
    { 1200, -32, -352},
    { 1376, -64, -376},
    { 1184, 88, -376},
    { 1024, 160, -424},
    { 920, 128, -464},
    { 992, 32, -416},
    { 832, 40, -304},
    { 632, 48, -240},
    { 496, 96, -240},
    { 472, 80, -216},
    { 616, 128, -312},
    { 792, 168, -336},
    { 1128, 216, -432},
    { 1384, 184, -408},
    { 1384, 208, -456},
    { 1144, 216, -344},
    { 1240, 104, -336},
    { 1072, 40, -168},
    { 712, 24, -240},
    { 472, 16, -216},
    { 400, 8, -224},
    { 592, 40, -216},
    { 760, 32, -216},
    { 1048, 56, -304},
    { 1200, 72, -336},
    // 28 seconds
    { 1720, -64, -424},
    { 928, 296, -296},
    { 1040, 80, -408},
    { 1096, 136, -344},
    { 888, 56, -312},
    { 648, 32, -200},
    { 456, 56, -184},
    { 368, 64, -160},
    { 520, 144, -232},
    { 736, 152, -312},
    { 992, 144, -384},
    { 1240, 208, -424},
    { 1544, 144, -440},
    { 1192, 192, -328},
    { 1256, 104, -336},
    { 1328, 72, -224},
    { 960, 48, -184},
    { 600, 40, -272},
    { 552, 8, -176},
    { 536, 48, -208},
    { 640, 104, -176},
    { 768, 64, -200},
    { 896, 48, -320},
    { 1136, 32, -296},
    { 1608, -24, -496},
    // 29 seconds
    { 1064, 360, -344},
    { 968, 152, -472},
    { 1024, 72, -448},
    { 896, -16, -352},
    { 608, 16, -248},
    { 416, 48, -200},
    { 384, 80, -176},
    { 576, 136, -232},
    { 808, 216, -368},
    { 1000, 208, -408},
    { 1264, 208, -488},
    { 1440, 152, -456},
    { 1192, 232, -392},
    { 1256, 168, -360},
    { 1328, 120, -280},
    { 1064, 48, -216},
    { 752, 96, -192},
    { 512, 104, -240},
    { 440, 88, -232},
    { 568, 144, -176},
    { 808, 144, -232},
    { 1064, 96, -288},
    { 1264, 120, -312},
    { 1480, 80, -384},
    { 1016, 280, -304},
    // 30 seconds
    { 912, 248, -400},
    { 944, 136, -464},
    { 800, -8, -344},
    { 632, 40, -256},
    { 488, 120, -216},
    { 408, 80, -160},
    { 584, 144, -192},
    { 720, 224, -296},
    { 856, 304, -360},
    { 1096, 352, -464},
    { 1312, 272, -440},
    { 1264, 312, -432},
    { 1256, 264, -312},
    { 1272, 208, -296},
    { 1144, 104, -208},
    { 880, 88, -224},
    { 600, 72, -208},
    { 480, 64, -208},
    { 528, 32, -160},
    { 640, 96, -208},
    { 880, 128, -272},
    { 1176, 136, -328},
    { 1184, 144, -384},
    { 1616, -72, -472},
    { 856, 272, -320},
    // 31 seconds
    { 1072, 80, -392},
    { 1064, 184, -400},
    { 896, 88, -368},
    { 512, 72, -360},
    { 400, 56, -216},
    { 432, 120, -192},
    { 616, 224, -272},
    { 752, 240, -352},
    { 928, 256, -416},
    { 1168, 256, -448},
    { 1536, 176, -424},
    { 1272, 304, -400},
    { 1208, 176, -384},
    { 1304, 96, -304},
    { 1104, 80, -264},
    { 752, 48, -256},
    { 552, 32, -232},
    { 440, 24, -192},
    { 488, 24, -160},
    { 672, 64, -224},
    { 848, 48, -192},
    { 1120, -80, -184},
    { 1184, 64, -504},
    { 1376, -64, -304},
    { 944, 192, -496},
    // 32 seconds
    { 1048, 80, -576},
    { 1040, 136, -472},
    { 800, 168, -360},
    { 528, 152, -304},
    { 456, 176, -272},
    { 408, 144, -240},
    { 512, 256, -304},
    { 656, 336, -400},
    { 888, 384, -408},
    { 1112, 352, -448},
    { 1120, 448, -488},
    { 1032, 320, -512},
    { 1128, 104, -488},
    { 1064, 80, -272},
    { 888, 136, -320},
    { 720, 168, -200},
    { 552, 96, -192},
    { 544, 24, -168},
    { 712, 8, -192},
    { 928, -8, -264},
    { 1200, -96, -328},
    { 1400, -144, -328},
    { 1416, -24, -200},
    { 976, 152, -464},
    { 992, 24, -432},
    // 33 seconds
    { 968, -72, -312},
    { 792, -48, -312},
    { 584, -8, -248},
    { 416, 8, -208},
    { 464, -16, -208},
    { 608, 0, -184},
    { 808, 112, -472},
    { 1088, 136, -360},
    { 1328, 160, -368},
    { 1352, 232, -464},
    { 1016, 200, -216},
    { 1312, 88, -280},
    { 1176, 80, -144},
    { 936, 32, -168},
    { 664, 40, -176},
    { 464, 0, -192},
    { 456, -72, -168},
    { 720, -56, -184},
    { 944, -104, -160},
    { 1336, -128, -216},
    { 1336, -176, -272},
    { 1360, -200, -184},
    { 1112, 56, -416},
    { 1120, 40, -392},
    { 912, -40, -320},
    // 34 seconds
    { 704, -96, -256},
    { 528, -16, -152},
    { 432, -32, -184},
    { 560, 72, -208},
    { 712, 184, -256},
    { 936, 248, -352},
    { 1208, 392, -304},
    { 1224, 376, -424},
    { 1128, 416, -392},
    { 1064, 272, -280},
    { 1192, 160, -272},
    { 1144, 192, -176},
    { 824, 184, -248},
    { 584, 104, -200},
    { 448, 80, -184},
    { 520, 32, -168},
    { 752, 32, -208},
    { 1040, 144, -272},
    { 1264, 48, -296},
    { 1608, -8, -464},
    { 1016, 256, -256},
    { 1088, 88, -480},
    { 1016, 112, -464},
    { 864, 56, -288},
    { 592, 72, -232},
    // 35 seconds
    { 448, 104, -176},
    { 448, 120, -144},
    { 608, 88, -264},
    { 768, 160, -312},
    { 896, 176, -416},
    { 1160, 208, -496},
    { 1584, 168, -416},
    { 1152, 336, -400},
    { 1328, 144, -344},
    { 1336, 120, -232},
    { 1144, 16, -176},
    { 776, 8, -144},
    { 504, 16, -160},
    { 416, 16, -176},
    { 552, 32, -184},
    { 728, 72, -224},
    { 936, 72, -280},
    { 1224, 64, -304},
    { 1440, 96, -512},
    { 1104, 240, -224},
    { 936, 144, -448},
    { 1088, 32, -264},
    { 1024, 104, -312},
    { 688, 184, -464},
    { 440, 176, -304},
    // 36 seconds
    { 512, 280, -288},
    { 504, 128, -280},
    { 720, 280, -416},
    { 744, 160, -192},
    { 968, 240, -392},
    { 1048, 224, -368},
    { 1104, 368, -448},
    { 1072, 376, -400},
    { 1160, 200, -344},
    { 1184, 208, -264},
    { 896, 160, -256},
    { 672, 104, -192},
    { 544, 120, -240},
    { 624, 32, -200},
    { 720, 40, -192},
    { 920, 48, -264},
    { 1176, -8, -232},
    { 1184, 64, -336},
    { 1224, 192, -416},
    { 784, 424, -520},
    { 1080, 168, -400},
    { 1008, 128, -368},
    { 808, -32, -320},
    { 528, -72, -168},
    { 432, -16, -200},
    // 37 seconds
    { 448, 72, -184},
    { 664, 184, -256},
    { 792, 208, -392},
    { 928, 232, -496},
    { 1048, 224, -456},
    { 1296, 328, -512},
    { 1312, 392, -560},
    { 1336, 200, -408},
    { 1200, 160, -376},
    { 976, 120, -288},
    { 664, 40, -280},
    { 504, 48, -288},
    { 488, 40, -192},
    { 600, 56, -208},
    { 776, 96, -232},
    { 992, -32, -264},
    { 1168, 88, -368},
    { 1608, -24, -376},
    { 1056, 312, -424},
    { 1072, 176, -496},
    { 1008, 120, -408},
    { 848, 16, -312},
    { 552, 40, -240},
    { 416, 40, -184},
    { 416, 136, -208},
    // 38 seconds
    { 624, 104, -200},
    { 808, 232, -416},
    { 1000, 280, -480},
    { 1064, 296, -512},
    { 1440, 280, -456},
    { 1112, 400, -400},
    { 1168, 216, -376},
    { 1248, 192, -304},
    { 1072, 104, -224},
    { 736, 56, -216},
    { 536, 48, -216},
    { 464, 8, -200},
    { 648, 16, -184},
    { 824, 24, -248},
    { 1096, -40, -264},
    { 1184, 16, -328},
    { 1616, -72, -320},
    { 904, 248, -320},
    { 1048, 24, -416},
    { 1048, 56, -400},
    { 856, -48, -320},
    { 584, -40, -288},
    { 472, 24, -216},
    { 456, 104, -200},
    { 584, 160, -272},
    // 39 seconds
    { 680, 240, -336},
    { 856, 272, -416},
    { 1040, 328, -504},
    { 1496, 248, -424},
    { 1120, 400, -368},
    { 1288, 240, -288},
    { 1280, 208, -256},
    { 1168, 72, -200},
    { 840, 16, -256},
    { 656, 32, -184},
    { 584, 96, -152},
    { 552, 72, -88},
    { 640, 72, -168},
    { 832, 72, -232},
    { 1032, 24, -280},
    { 1200, -32, -264},
    { 1200, -48, -296},
    { 1120, 104, -336},
    { 992, 176, -504},
    { 976, 24, -384},
    { 864, 32, -232},
    { 688, 120, -192},
    { 496, 160, -248},
    { 448, 128, -200},
    { 624, 176, -208},
    // 40 seconds
    { 776, 224, -264},
    { 992, 208, -344},
    { 1104, 160, -240},
    { 1320, 200, -480},
    { 1368, 128, -424},
    { 1352, 112, -296},
    { 1232, 160, -248},
    { 824, 152, -248},
    { 560, 80, -216},
    { 528, 112, -200},
    { 688, 216, -256},
    { 824, 208, -128},
    { 944, 16, -392},
    { 1200, -64, -336},
    { 1384, -64, -448},
    { 1040, 112, -360},
    { 1160, 168, -520},
    { 1120, 104, -520},
    { 928, 40, -416},
    { 656, 112, -352},
    { 472, 168, -352},
    { 480, 208, -320},
    { 480, 144, -360},
    { 512, 64, -416},
    { 664, 88, -496},
    // 41 seconds
    { 936, 224, -504},
    { 1224, 288, -464},
    { 1064, 264, -560},
    { 1128, 8, -488},
    { 1176, 168, -392},
    { 1048, 136, -328},
    { 872, 48, -400},
    { 616, 104, -424},
    { 424, 224, -408},
    { 496, 56, -456},
    { 696, 88, -320},
    { 968, 96, -328},
    { 1120, 56, -416},
    { 1536, -96, -480},
    { 960, 208, -616},
    { 1176, 16, -416},
    { 1144, 144, -376},
    { 944, 128, -312},
    { 576, 96, -216},
    { 432, 80, -208},
    { 416, 88, -200},
    { 560, 168, -240},
    { 720, 232, -376},
    { 1048, 240, -432},
    { 1152, 240, -512},
    // 42 seconds
    { 1384, 200, -432},
    { 1192, 264, -352},
    { 1288, 136, -360},
    { 1240, 72, -256},
    { 936, 80, -272},
    { 616, 24, -272},
    { 472, 0, -240},
    { 536, 56, -248},
    { 728, 96, -280},
    { 920, 40, -336},
    { 1232, -32, -376},
    { 1376, 0, -320},
    { 1192, 64, -240},
    { 1040, 136, -464},
    { 1088, 64, -496},
    { 1008, -24, -472},
    { 664, 24, -376},
    { 408, 48, -272},
    { 320, 16, -152},
    { 448, 96, -176},
    { 680, 144, -200},
    { 984, 256, -272},
    { 1320, 208, -360},
    { 1416, 200, -336},
    { 1184, 280, -424},
    // 43 seconds
    { 1128, 176, -312},
    { 1264, 112, -208},
    { 1128, 80, -192},
    { 848, 56, -152},
    { 552, 80, -208},
    { 456, 48, -200},
    { 536, 0, -144},
    { 784, 16, -176},
    { 1144, 8, -264},
    { 1320, -40, -288},
    { 1552, -136, -392},
    { 976, 200, -216},
    { 1080, -8, -368},
    { 1184, 64, -400},
    { 904, -8, -360},
    { 568, -40, -280},
    { 408, -16, -224},
    { 480, 16, -152},
    { 664, 136, -376},
    { 864, 160, -216},
    { 1056, 184, -336},
    { 1144, 176, -304},
    { 1560, 144, -288},
    { 1008, 256, -304},
    { 1288, 40, -280},
    // 44 seconds
    { 1256, 72, -144},
    { 1000, 32, -160},
    { 752, -16, -152},
    { 560, 8, -192},
    { 520, -48, -176},
    { 696, -48, -160},
    { 920, -80, -168},
    { 1168, -136, -240},
    { 1288, -160, -208},
    { 1672, -304, -160},
    { 856, 136, -280},
    { 1056, -56, -376},
    { 1048, 16, -368},
    { 904, -56, -256},
    { 592, -24, -184},
    { 440, -16, -176},
    { 456, -56, -152},
    { 656, 32, -264},
    { 896, 80, -352},
    { 1160, 40, -392},
    { 1224, 56, -384},
    { 1520, 40, -392},
    { 1096, 184, -272},
    { 1384, -24, -240},
    { 1360, -24, -136},
    // 45 seconds
    { 1040, -80, -176},
    { 672, -32, -192},
    { 480, 16, -168},
    { 464, -32, -120},
    { 600, -24, -152},
    { 840, 16, -200},
    { 1096, -8, -256},
    { 1248, -80, -280},
    { 1704, -264, -304},
    { 976, 128, -336},
    { 1160, -56, -408},
    { 1168, 120, -440},
    { 952, -32, -336},
    { 600, -64, -224},
    { 432, 0, -200},
    { 400, 16, -144},
    { 576, 64, -160},
    { 752, 184, -304},
    { 960, 224, -360},
    { 1136, 232, -456},
    { 1200, 152, -312},
    { 1408, 168, -440},
    { 1176, 160, -280},
    { 1312, 16, -248},
    { 1264, 24, -160},
    // 46 seconds
    { 928, 40, -224},
    { 640, 40, -200},
    { 512, 40, -176},
    { 504, 40, -208},
    { 656, 40, -208},
    { 880, 16, -240},
    { 1152, -48, -304},
    { 1264, -96, -336},
    { 1240, -144, -296},
    { 808, 112, -376},
    { 984, 24, -424},
    { 1024, 72, -400},
    { 840, -24, -296},
    { 560, -16, -216},
    { 432, 16, -224},
    { 456, 56, -192},
    { 624, 120, -240},
    { 832, 240, -360},
    { 1144, 192, -408},
    { 1200, 216, -368},
    { 1480, 200, -440},
    { 1032, 240, -264},
    { 1240, 112, -272},
    { 1264, 96, -160},
    { 944, 56, -224},
    // 47 seconds
    { 648, 8, -192},
    { 528, 8, -184},
    { 528, 24, -152},
    { 664, 88, -208},
    { 864, 48, -184},
    { 1208, -24, -304},
    { 1240, 8, -352},
    { 1360, -56, -232},
    { 800, 136, -264},
    { 1120, 0, -424},
    { 1016, 0, -360},
    { 752, -16, -336},
    { 456, 0, -216},
    { 376, -8, -184},
    { 432, 8, -136},
    { 728, 152, -248},
    { 1032, 224, -264},
    { 1216, 224, -336},
    { 1416, 96, -328},
    { 1288, 208, -352},
    { 1272, 112, -352},
    { 1288, 64, -184},
    { 1152, 32, -152},
    { 776, 56, -176},
    { 552, 40, -176},
    // 48 seconds
    { 472, 24, -160},
    { 592, 0, -168},
    { 760, 0, -160},
    { 1056, -40, -216},
    { 1280, -128, -320},
    { 1600, -304, -304},
    { 1080, -8, -192},
    { 1144, -32, -352},
    { 1144, 104, -416},
    { 984, -32, -320},
    { 648, -16, -296},
    { 464, -24, -192},
    { 384, 0, -176},
    { 568, 120, -136},
    { 752, 248, -288},
    { 944, 264, -336},
    { 1128, 296, -384},
    { 1616, 200, -360},
    { 1120, 424, -368},
    { 1264, 160, -272},
    { 1336, 160, -168},
    { 1144, 64, -128},
    { 744, 56, -200},
    { 528, 64, -192},
    { 464, 32, -168},
    // 49 seconds
    { 552, 32, -160},
    { 768, 24, -160},
    { 1080, -24, -232},
    { 1320, -56, -192},
    { 1680, -144, -328},
    { 1016, 144, -248},
    { 1016, -8, -376},
    { 1160, 112, -336},
    { 1000, 48, -272},
    { 640, -24, -240},
    { 488, -8, -192},
    { 424, -40, -104},
    { 584, 56, -176},
    { 792, 160, -240},
    { 1024, 240, -336},
    { 1256, 232, -344},
    { 1744, 96, -280},
    { 1184, 240, -280},
    { 1272, 88, -184},
    { 1312, 64, -128},
    { 1136, 24, -136},
    { 704, 56, -192},
    { 488, 48, -176},
    { 472, 32, -168},
    { 632, 24, -136},
    // 50 seconds
    { 856, 64, -200},
    { 1152, 24, -304},
    { 1224, -96, -288},
    { 1832, -296, -104},
    { 992, 152, -160},
    { 1112, 40, -248},
    { 1064, 136, -328},
    { 824, 8, -280},
    { 544, -32, -248},
    { 424, 48, -176},
    { 432, 120, -120},
    { 600, 184, -192},
    { 832, 288, -272},
    { 1048, 320, -384},
    { 1208, 224, -312},
    { 1488, 232, -392},
    { 1328, 264, -312},
    { 1336, 96, -184},
    { 1280, 24, -120},
    { 896, 24, -192},
    { 608, 40, -208},
    { 456, 40, -200},
    { 504, 48, -160},
    { 672, 48, -160},
    { 936, -8, -184},
    // 51 seconds
    { 1176, -24, -256},
    { 1272, -120, -248},
    { 1256, -128, -216},
    { 872, 128, -320},
    { 1072, 24, -344},
    { 1032, -72, -328},
    { 784, -72, -272},
    { 560, -16, -224},
    { 456, 0, -176},
    { 488, 64, -120},
    { 672, 152, -232},
    { 832, 256, -328},
    { 1048, 240, -392},
    { 1168, 208, -344},
    { 1536, 192, -360},
    { 1072, 224, -232},
    { 1328, 80, -192},
    { 1408, 56, -128},
    { 1024, 32, -160},
    { 624, 24, -216},
    { 456, 64, -288},
    { 496, 16, -176},
    { 680, 0, -152},
    { 840, 32, -184},
    { 1120, -48, -248},
    // 52 seconds
    { 1264, -88, -248},
    { 1592, -104, -336},
    { 976, 120, -304},
    { 1072, 88, -392},
    { 1040, 80, -360},
    { 816, -40, -312},
    { 560, -48, -256},
    { 440, 8, -232},
    { 416, 24, -168},
    { 616, 112, -208},
    { 816, 160, -288},
    { 1080, 160, -384},
    { 1200, 136, -464},
    { 1576, 64, -392},
    { 1216, 208, -344},
    { 1192, -80, -320},
    { 1232, -64, -96},
    { 968, -40, -328},
    { 696, 40, -304},
    { 512, 48, -288},
    { 440, 64, -256},
    { 568, 32, -208},
    { 928, 48, -256},
    { 1200, 8, -360},
    { 1232, -16, -376},
    // 53 seconds
    { 1528, -120, -552},
    { 808, 96, -336},
    { 952, -24, -416},
    { 1088, 88, -400},
    { 880, 24, -384},
    { 568, 0, -280},
    { 440, -8, -184},
    { 456, 56, -208},
    { 624, 120, -232},
    { 712, 216, -312},
    { 800, 232, -344},
    { 1024, 208, -368},
    { 1624, 208, -424},
    { 1160, 296, -352},
    { 1208, 168, -400},
    { 1280, 144, -320},
    { 1136, 80, -272},
    { 768, 80, -240},
    { 512, 64, -232},
    { 440, 40, -240},
    { 576, 0, -184},
    { 808, 48, -248},
    { 1032, 0, -240},
    { 1176, -64, -280},
    { 1632, -152, -576},
    // 54 seconds
    { 992, 160, -248},
    { 1136, 144, -472},
    { 1072, 240, -416},
    { 872, 8, -184},
    { 632, -40, -152},
    { 480, -16, -128},
    { 464, -24, -120},
    { 608, 40, -144},
    { 768, 224, -272},
    { 920, 248, -352},
    { 1144, 200, -376},
    { 1464, 288, -368},
    { 1344, 264, -424},
    { 1296, 128, -280},
    { 1248, 120, -272},
    { 912, 120, -256},
    { 624, 88, -232},
    { 504, 72, -224},
    { 480, 40, -176},
    { 632, 40, -192},
    { 824, 40, -256},
    { 1160, -56, -256},
    { 1248, -96, -256},
    { 1776, -192, -384},
    { 824, 136, -240},
    // 55 seconds
    { 992, 64, -376},
    { 1072, 256, -448},
    { 856, 80, -352},
    { 592, 16, -296},
    { 520, 96, -240},
    { 512, 72, -168},
    { 656, 112, -224},
    { 752, 224, -320},
    { 896, 224, -400},
    { 1096, 240, -464},
    { 1536, 240, -472},
    { 1120, 384, -360},
    { 1248, 176, -384},
    { 1288, 152, -240},
    { 1016, 96, -248},
    { 696, 32, -200},
    { 504, 48, -208},
    { 512, 80, -216},
    { 656, 8, -144},
    { 880, 32, -240},
    { 1120, -48, -280},
    { 1144, -88, -304},
    { 1608, -200, -504},
    { 896, 216, -248},
    { 1040, 24, -424},
    // 56 seconds
    { 1088, 112, -408},
    { 864, 8, -336},
    { 552, 16, -256},
    { 424, 8, -192},
    { 440, 88, -168},
    { 608, 112, -208},
    { 800, 256, -320},
    { 1040, 304, -408},
    { 1112, 240, -392},
    { 1536, 224, -416},
    { 1152, 304, -352},
    { 1368, 136, -304},
    { 1352, 120, -224},
    { 984, 136, -256},
    { 664, 64, -232},
    { 456, 56, -184},
    { 456, 64, -200},
    { 624, 120, -184},
    { 816, 0, -264},
    { 1072, -48, -288},
    { 1200, -48, -264},
    { 1512, -88, -368},
    { 896, 232, -280},
    { 960, 112, -432},
    { 1000, 144, -448},
    // 57 seconds
    { 824, -32, -272},
    { 544, -8, -248},
    { 520, 72, -208},
    { 504, 152, -216},
    { 640, 200, -296},
    { 720, 296, -392},
    { 936, 336, -480},
    { 1072, 344, -472},
    { 1352, 344, -480},
    { 1080, 344, -296},
    { 1200, 200, -288},
    { 1288, 152, -232},
    { 1056, 72, -224},
    { 760, 24, -216},
    { 576, 40, -192},
    { 552, 88, -200},
    { 656, 40, -176},
    { 840, 80, -248},
    { 1088, 48, -304},
    { 1112, -32, -288},
    { 1584, -120, -448},
    { 848, 224, -240},
    { 1160, 8, -376},
    { 1112, 200, -448},
    { 848, 88, -376},
    // 58 seconds
    { 496, 40, -272},
    { 368, 56, -216},
    { 392, 112, -168},
    { 640, 184, -224},
    { 840, 288, -328},
    { 1040, 320, -432},
    { 1160, 280, -536},
    { 1552, 224, -448},
    { 984, 256, -280},
    { 1208, 104, -336},
    { 1280, 160, -184},
    { 1032, 96, -184},
    { 712, 56, -176},
    { 568, 40, -224},
    { 592, -32, -192},
    { 736, 160, -208},
    { 912, 152, -312},
    { 1104, 16, -296},
    { 1080, 0, -352},
    { 1272, -64, -352},
    { 872, 200, -296},
    { 928, 96, -464},
    { 1016, 80, -456},
    { 864, 48, -384},
    { 680, 40, -368},
    // 59 seconds
    { 544, 112, -176},
    { 432, 80, -224},
    { 616, 208, -248},
    { 712, 296, -304},
    { 896, 416, -496},
    { 1120, 376, -352},
    { 1504, 344, -448},
    { 1480, 376, -384},
    { 1272, 208, -272},
    { 1160, 160, -192},
    { 1024, 144, -240},
    { 712, 96, -168},
    { 488, 48, -184},
    { 528, 40, -176},
    { 744, 24, -192},
    { 984, 8, -272},
    { 1136, -40, -296},
    { 1112, -40, -344},
    { 1240, -56, -344},
    { 1216, 128, -352},
    { 1112, 200, -512},
    { 1032, 136, -440},
    { 768, 64, -344},
    { 520, 64, -232},
    { 392, 64, -152},
    // 60 seconds
    // elapsed: 1 minutes
    { 456, 136, -160},
    { 664, 224, -240},
    { 784, 328, -296},
    { 896, 376, -408},
    { 1112, 384, -456},
    { 1432, 336, -368},
    { 1272, 320, -304},
    { 1384, 200, -344},
    { 1336, 104, -216},
    { 1112, 56, -192},
    { 824, 56, -184},
    { 592, 32, -192},
    { 480, 0, -168},
    { 584, 0, -144},
    { 752, 16, -152},
    { 976, 32, -208},
    { 1184, 16, -272},
    { 1616, -104, -376},
    { 1088, 136, -176},
    { 1096, 160, -416},
    { 1056, 200, -448},
    { 928, 96, -320},
    { 672, 72, -296},
    { 512, 40, -168},
    { 432, 64, -160},
    // 61 seconds
    { 560, 136, -208},
    { 736, 136, -304},
    { 912, 208, -408},
    { 1216, 200, -432},
    { 1544, 208, -408},
    { 1160, 328, -424},
    { 1336, 192, -240},
    { 1360, 144, -120},
    { 1152, 64, -88},
    { 824, -8, -88},
    { 584, -24, -144},
    { 464, -8, -184},
    { 544, -16, -144},
    { 728, -40, -176},
    { 1016, -64, -208},
    { 1256, -48, -264},
    { 1688, -184, -312},
    { 1056, 232, -256},
    { 1112, 64, -368},
    { 1104, 88, -384},
    { 912, -8, -336},
    { 528, -8, -240},
    { 344, 32, -168},
    { 408, 120, -216},
    { 672, 176, -224},
    // 62 seconds
    { 864, 224, -368},
    { 1248, 248, -440},
    { 1296, 256, -376},
    { 1432, 296, -496},
    { 1240, 232, -368},
    { 1216, 104, -248},
    { 1184, 120, -168},
    { 880, 144, -224},
    { 576, 80, -152},
    { 424, 64, -200},
    { 512, 48, -160},
    { 760, 168, -248},
    { 1216, 88, -208},
    { 1416, 32, -296},
    { 1400, -24, -408},
    { 1088, 32, -312},
    { 888, 112, -368},
    { 960, -32, -432},
    { 856, -112, -344},
    { 608, -24, -256},
    { 384, 80, -216},
    { 368, 112, -160},
    { 528, 96, -160},
    { 760, 208, -272},
    { 928, 176, -328},
    // 63 seconds
    { 1176, 216, -448},
    { 1240, 152, -408},
    { 1216, 232, -408},
    { 1024, 240, -248},
    { 1360, 136, -312},
    { 1288, 104, -144},
    { 1048, 56, -152},
    { 736, -16, -128},
    { 488, -16, -184},
    { 432, -24, -128},
    { 616, 96, -144},
    { 1000, 64, -168},
    { 1208, -8, -352},
    { 1224, -88, -280},
    { 1328, -88, -176},
    { 1096, 112, -272},
    { 1088, -8, -408},
    { 1008, -72, -320},
    { 712, -56, -256},
    { 448, 0, -232},
    { 400, 8, -96},
    { 488, 96, -136},
    { 720, 184, -176},
    { 952, 232, -288},
    { 1096, 264, -384},
    // 64 seconds
    { 1264, 176, -384},
    { 1376, 184, -400},
    { 1368, 184, -304},
    { 1368, 112, -216},
    { 1312, -8, -152},
    { 976, -8, -152},
    { 624, -16, -184},
    { 432, -24, -176},
    { 456, -32, -120},
    { 576, -8, -168},
    { 856, -72, -88},
    { 1144, -72, -176},
    { 1256, -8, -280},
    { 1568, -128, -136},
    { 792, 112, -504},
    { 1152, -96, -160},
    { 1080, 160, -512},
    { 800, 72, -384},
    { 520, 32, -296},
    { 512, 64, -320},
    { 552, 72, -176},
    { 736, 136, -304},
    { 808, 168, -320},
    { 968, 208, -312},
    { 1072, 256, -312},
    // 65 seconds
    { 1264, 256, -360},
    { 1000, 344, -312},
    { 1040, 216, -376},
    { 1200, 152, -160},
    { 1024, 112, -160},
    { 848, 24, -144},
    { 640, 56, -184},
    { 568, 32, -160},
    { 672, 0, -192},
    { 888, 0, -216},
    { 1104, -40, -296},
    { 1216, -96, -264},
    { 1656, -184, -320},
    { 952, 160, -248},
    { 1080, 0, -328},
    { 1184, 56, -264},
    { 912, 8, -288},
    { 544, -32, -240},
    { 432, 16, -184},
    { 424, 32, -136},
    { 656, 80, -176},
    { 832, 208, -264},
    { 992, 184, -376},
    { 1168, 160, -376},
    { 1528, 152, -368},
    // 66 seconds
    { 1264, 232, -352},
    { 1184, 88, -272},
    { 1224, -32, -168},
    { 968, -8, -224},
    { 608, 40, -272},
    { 496, 104, -288},
    { 496, 120, -232},
    { 680, 96, -216},
    { 968, 56, -248},
    { 1192, 32, -336},
    { 1200, 24, -320},
    { 1064, 88, -264},
    { 960, 216, -376},
    { 1000, 152, -392},
    { 800, 120, -336},
    { 648, 64, -368},
    { 528, 104, -336},
    { 448, 128, -216},
    { 504, 176, -272},
    { 624, 200, -280},
    { 808, 288, -320},
    { 1040, 352, -496},
    { 1352, 232, -344},
    { 1112, 360, -424},
    { 1224, 232, -288},
    // 67 seconds
    { 1216, 176, -224},
    { 1056, 104, -96},
    { 872, 56, -184},
    { 584, 112, -240},
    { 480, 112, -280},
    { 536, 80, -176},
    { 896, 56, -224},
    { 1136, 32, -208},
    { 1320, 112, -328},
    { 1752, 32, -464},
    { 1064, 328, -296},
    { 1064, 160, -456},
    { 1024, 104, -368},
    { 832, 128, -392},
    { 568, 128, -280},
    { 432, 152, -264},
    { 464, 168, -240},
    { 560, 208, -224},
    { 704, 248, -248},
    { 856, 296, -360},
    { 1040, 232, -368},
    { 1336, 456, -440},
    { 1152, 408, -408},
    { 1144, 144, -312},
    { 1104, 40, -280},
    // 68 seconds
    { 912, 96, -256},
    { 680, 112, -248},
    { 520, 96, -256},
    { 488, 0, -160},
    { 704, -48, -152},
    { 920, -80, -168},
    { 1208, -192, -184},
    { 1320, -136, -232},
    { 1512, -64, -216},
    { 824, 256, -280},
    { 1096, 24, -408},
    { 1144, 168, -352},
    { 832, 64, -376},
    { 520, 0, -304},
    { 432, 24, -224},
    { 488, 40, -184},
    { 632, 112, -272},
    { 808, 200, -296},
    { 1048, 208, -336},
    { 1144, 200, -336},
    { 1328, 304, -352},
    { 1048, 336, -272},
    { 1272, 80, -256},
    { 1312, 80, -144},
    { 1056, 56, -184},
    // 69 seconds
    { 680, 40, -160},
    { 472, 0, -184},
    { 488, -32, -136},
    { 656, 32, -200},
    { 912, 48, -240},
    { 1168, 32, -288},
    { 1224, 56, -312},
    { 1392, -24, -328},
    { 984, 232, -280},
    { 1032, 168, -440},
    { 1064, 112, -344},
    { 896, 0, -280},
    { 616, 16, -208},
    { 408, 32, -176},
    { 400, 64, -120},
    { 592, 144, -160},
    { 824, 280, -280},
    { 960, 280, -320},
    { 1240, 296, -408},
    { 1568, 232, -384},
    { 1104, 320, -312},
    { 1288, 120, -264},
    { 1424, 120, -136},
    { 1264, 48, -136},
    { 848, 24, -136},
    // 70 seconds
    { 576, -8, -168},
    { 464, 16, -176},
    { 576, 8, -144},
    { 744, 40, -160},
    { 968, 40, -216},
    { 1160, 24, -176},
    { 1408, -120, -296},
    { 1144, 48, -128},
    { 656, 96, -280},
    { 968, 8, -248},
    { 1056, 32, -264},
    { 856, 16, -224},
    { 600, 24, -200},
    { 504, 80, -152},
    { 496, 88, -120},
    { 640, 160, -216},
    { 768, 216, -264},
    { 880, 208, -304},
    { 1056, 184, -344},
    { 1352, 104, -240},
    { 1208, 168, -232},
    { 1456, 40, -304},
    { 1440, 88, -200},
    { 1224, 16, -248},
    { 880, -16, -248},
    // 71 seconds
    { 696, -24, -184},
    { 568, 24, -160},
    { 512, 32, -160},
    { 640, 0, -136},
    { 808, 16, -184},
    { 1096, -40, -216},
    { 1184, -32, -248},
    { 1400, 0, -344},
    { 864, 208, -312},
    { 1032, 80, -472},
    { 1120, 160, -432},
    { 904, -56, -344},
    { 664, 16, -392},
    { 536, 136, -296},
    { 448, 120, -200},
    { 504, 216, -256},
    { 576, 248, -272},
    { 672, 280, -400},
    { 1000, 304, -472},
    { 1064, 240, -304},
    { 1368, 272, -456},
    { 1408, 256, -344},
    { 1344, 176, -216},
    { 1200, 152, -280},
    { 1008, 48, -184},
    // 72 seconds
    { 736, 8, -184},
    { 520, 32, -160},
    { 480, 80, -192},
    { 608, 112, -192},
    { 784, 152, -184},
    { 1040, 16, -336},
    { 1192, 96, -320},
    { 1656, -48, -512},
    { 1256, 336, -232},
    { 960, 312, -552},
    { 1080, 144, -352},
    { 864, 112, -344},
    { 536, 104, -240},
    { 352, 104, -192},
    { 440, 184, -200},
    { 648, 144, -200},
    { 888, 264, -336},
    { 1136, 176, -400},
    { 1424, 208, -352},
    { 1232, 256, -320},
    { 1296, 160, -288},
    { 1448, 80, -288},
    { 1144, 24, -128},
    { 840, 56, -224},
    { 632, 40, -184},
    // 73 seconds
    { 504, 88, -184},
    { 496, 40, -136},
    { 768, 48, -216},
    { 1024, 0, -200},
    { 1400, -24, -320},
    { 1720, -104, -408},
    { 1136, 368, -280},
    { 992, 192, -600},
    { 984, 144, -376},
    { 856, 112, -328},
    { 664, 120, -320},
    { 432, 176, -280},
    { 376, 120, -200},
    { 560, 232, -312},
    { 600, 248, -352},
    { 872, 304, -408},
    { 1056, 384, -448},
    { 1200, 432, -424},
    { 1008, 512, -384},
    { 1104, 392, -360},
    { 1176, 208, -296},
    { 920, 144, -232},
    { 688, 152, -232},
    { 480, 128, -232},
    { 432, 80, -240},
    // 74 seconds
    { 576, 64, -208},
    { 808, 128, -256},
    { 1144, 80, -360},
    { 1224, 40, -336},
    { 1632, 48, -456},
    { 1056, 400, -344},
    { 944, 216, -440},
    { 944, 184, -328},
    { 928, 88, -296},
    { 712, 104, -280},
    { 488, 80, -240},
    { 360, 64, -200},
    { 504, 72, -152},
    { 664, 184, -272},
    { 880, 296, -416},
    { 1104, 336, -456},
    { 1600, 232, -432},
    { 1168, 448, -336},
    { 1016, 264, -328},
    { 1112, 104, -232},
    { 1144, 32, -216},
    { 832, 40, -224},
    { 584, 16, -240},
    { 552, 96, -248},
    { 624, 112, -216},
    // 75 seconds
    { 800, 88, -288},
    { 960, 104, -336},
    { 1152, 40, -384},
    { 1560, 16, -600},
    { 1168, 256, -352},
    { 976, 184, -400},
    { 960, 88, -328},
    { 864, 32, -272},
    { 600, 24, -208},
    { 424, 64, -208},
    { 384, 64, -176},
    { 536, 200, -184},
    { 656, 264, -256},
    { 808, 280, -432},
    { 1088, 296, -552},
    { 1408, 272, -392},
    { 1120, 328, -384},
    { 1464, 264, -384},
    { 1304, 232, -344},
    { 1056, 136, -280},
    { 704, 112, -304},
    { 496, 80, -272},
    { 408, 88, -216},
    { 536, 40, -136},
    { 728, 40, -272},
    // 76 seconds
    { 1040, -72, -280},
    { 1160, -24, -392},
    { 1584, -16, -464},
    { 760, 232, -496},
    { 1328, 0, -480},
    { 1256, 80, -456},
    { 928, -16, -400},
    { 536, 24, -256},
    { 304, 8, -200},
    { 288, -32, -168},
    { 616, 104, -152},
    { 816, 168, -240},
    { 960, 136, -384},
    { 1144, 168, -528},
    { 1616, 112, -456},
    { 1104, 232, -280},
    { 1440, 64, -352},
    { 1344, 112, -272},
    { 1088, 8, -216},
    { 752, 0, -200},
    { 512, 32, -288},
    { 400, 72, -288},
    { 560, 56, -232},
    { 784, 80, -240},
    { 1024, 136, -264},
    // 77 seconds
    { 1304, 120, -232},
    { 1232, 8, -272},
    { 904, 80, -192},
    { 1304, 8, -264},
    { 1264, 104, -368},
    { 944, 24, -288},
    { 504, 24, -280},
    { 352, 8, -224},
    { 360, 64, -176},
    { 496, 136, -192},
    { 680, 144, -296},
    { 976, 112, -320},
    { 1256, 200, -408},
    { 1232, 72, -224},
    { 1152, 136, -312},
    { 1512, 120, -328},
    { 1552, 40, -216},
    { 1288, 56, -216},
    { 768, 64, -208},
    { 496, -16, -192},
    { 392, 24, -208},
    { 528, -72, -128},
    { 848, 80, -232},
    { 1200, -48, -224},
    { 1440, 24, -352},
    // 78 seconds
    { 1376, 104, -424},
    { 912, 136, -248},
    { 1040, -16, -328},
    { 1176, -32, -296},
    { 936, -56, -320},
    { 800, -24, -232},
    { 608, 64, -232},
    { 400, 40, -240},
    { 464, 72, -224},
    { 704, 104, -264},
    { 976, 96, -232},
    { 1280, -96, -200},
    { 1296, 24, -392},
    { 1080, 120, -376},
    { 1088, 96, -336},
    { 1264, 88, -360},
    { 1312, 40, -136},
    { 1032, 32, -136},
    { 664, 48, -184},
    { 424, 56, -208},
    { 344, -88, -136},
    { 632, -160, -48},
    { 968, -64, -184},
    { 1280, -88, -168},
    { 1416, -32, -176},
    // 79 seconds
    { 1424, 24, -120},
    { 1000, 128, -240},
    { 960, 96, -392},
    { 896, -88, -296},
    { 792, -72, -240},
    { 736, 112, -264},
    { 608, 96, -208},
    { 648, 192, -272},
    { 600, 248, -160},
    { 704, 192, -248},
    { 840, 168, -264},
    { 960, 192, -344},
    { 1208, 216, -424},
    { 952, 256, -256},
    { 1224, 72, -304},
    { 1232, 128, -176},
    { 1040, 72, -208},
    { 848, 0, -200},
    { 656, 24, -232},
    { 552, -8, -176},
    { 616, -32, -160},
    { 816, -32, -200},
    { 1096, -8, -232},
    { 1168, -64, -288},
    { 1640, -184, -208},
    // 80 seconds
    { 952, 232, -328},
    { 1400, 128, -256},
    { 1056, 88, -264},
    { 792, -48, -296},
    { 584, -56, -224},
    { 496, 24, -152},
    { 408, 80, -152},
    { 552, 128, -176},
    { 776, 232, -272},
    { 1008, 216, -288},
    { 1384, 136, -272},
    { 1384, 248, -456},
    { 1448, 40, -320},
    { 1432, -56, -208},
    { 1120, -24, -224},
    { 768, -48, -160},
    { 608, 0, -208},
    { 528, 96, -240},
    { 584, 56, -208},
    { 712, 96, -256},
    { 984, -8, -248},
    { 1272, -96, -248},
    { 1624, -176, -304},
    { 1032, 96, -296},
    { 1160, 32, -368},
    // 81 seconds
    { 1112, -16, -320},
    { 896, -96, -248},
    { 624, -64, -240},
    { 400, 0, -184},
    { 312, 16, -168},
    { 480, 104, -192},
    { 752, 192, -216},
    { 1032, 264, -336},
    { 1160, 272, -392},
    { 1328, 112, -240},
    { 1080, 216, -376},
    { 1416, 8, -240},
    { 1480, 72, -136},
    { 1248, 0, -104},
    { 784, 56, -200},
    { 512, 32, -160},
    { 416, -24, -200},
    { 552, 16, -144},
    { 752, 72, -224},
    { 976, 16, -120},
    { 1272, -56, -152},
    { 1320, -96, -240},
    { 1024, 40, -104},
    { 1176, -56, -360},
    { 1160, 16, -352},
    // 82 seconds
    { 968, -8, -280},
    { 664, 0, -224},
    { 440, 32, -160},
    { 392, -32, -152},
    { 536, 40, -128},
    { 832, 144, -160},
    { 1128, 120, -192},
    { 1304, 72, -320},
    { 1776, -80, -328},
    { 896, 136, -328},
    { 1440, -72, -208},
    { 1424, -8, 0},
    { 1136, -32, -80},
    { 808, -56, -112},
    { 624, -56, -136},
    { 496, 8, -168},
    { 520, 96, -144},
    { 664, 72, -216},
    { 1080, -16, -144},
    { 1336, -72, -232},
    { 1592, -232, -232},
    { 768, 136, -248},
    { 1272, -128, -264},
    { 1224, 40, -336},
    { 928, 0, -352},
    // 83 seconds
    { 560, -16, -264},
    { 424, 0, -176},
    { 400, 8, -184},
    { 544, 56, -224},
    { 784, 176, -256},
    { 1112, 144, -208},
    { 1200, 144, -248},
    { 1544, 8, -288},
    { 1088, 144, -256},
    { 1552, -24, -232},
    { 1400, 48, -56},
    { 1072, -64, -104},
    { 792, -48, -208},
    { 536, 24, -216},
    { 424, 8, -184},
    { 464, -64, -152},
    { 736, 104, -248},
    { 1168, 104, -264},
    { 1344, 56, -328},
    { 1872, -112, -288},
    { 864, 168, -304},
    { 1224, 16, -544},
    { 1216, 160, -160},
    { 968, 64, -328},
    { 600, 40, -304},
    // 84 seconds
    { 488, 80, -216},
    { 464, 104, -160},
    { 512, 80, -128},
    { 704, 216, -264},
    { 912, 256, -304},
    { 1064, 192, -336},
    { 1480, 152, -264},
    { 1120, 264, -344},
    { 1176, 96, -304},
    { 1328, 104, -248},
    { 1192, 40, -184},
    { 920, -8, -232},
    { 656, 24, -224},
    { 480, 56, -264},
    { 472, 16, -232},
    { 760, 24, -208},
    { 1040, -8, -240},
    { 1320, -80, -256},
    { 1472, -136, -328},
    { 984, 88, -192},
    { 1296, 32, -304},
    { 1208, 56, -312},
    { 944, 16, -136},
    { 528, 40, -216},
    { 376, 48, -192},
    // 85 seconds
    { 432, 40, -80},
    { 576, 96, -248},
    { 864, 56, -240},
    { 1064, 80, -424},
    { 1200, 96, -504},
    { 1576, 8, -456},
    { 1112, 304, -264},
    { 1376, 40, -288},
    { 1352, 104, -136},
    { 1200, -32, -104},
    { 816, -8, -184},
    { 552, 8, -184},
    { 376, -8, -176},
    { 464, 24, -168},
    { 712, 16, -136},
    { 1120, 24, -256},
    { 1392, 8, -248},
    { 1440, -24, -312},
    { 872, 192, -56},
    { 1256, -24, -360},
    { 1184, 192, -336},
    { 960, 64, -288},
    { 584, 48, -264},
    { 416, -56, -104},
    { 416, 48, -168},
    // 86 seconds
    { 656, 176, -224},
    { 864, 144, -136},
    { 1072, 144, -264},
    { 1200, 192, -320},
    { 1680, 48, -352},
    { 1016, 232, -192},
    { 1464, 80, -336},
    { 1392, 128, -72},
    { 1120, 64, -152},
    { 704, 0, -152},
    { 496, -16, -216},
    { 472, 16, -192},
    { 536, 16, -168},
    { 832, 24, -168},
    { 1232, 24, -96},
    { 1232, -48, -128},
    { 1632, -168, -40},
    { 856, 224, -176},
    { 1256, -24, -200},
    { 1104, 112, -288},
    { 712, 8, -256},
    { 440, 64, -312},
    { 392, -40, -72},
    { 528, 8, -72},
    { 696, 40, -208},
    // 87 seconds
    { 896, 128, -288},
    { 1200, 144, -320},
    { 1400, 112, -224},
    { 1240, 168, -344},
    { 1352, 96, -296},
    { 1400, 40, -168},
    { 1248, -24, -96},
    { 856, 16, -160},
    { 600, 8, -192},
    { 448, 8, -176},
    { 488, 0, -136},
    { 672, 24, -128},
    { 1024, -16, -184},
    { 1344, -64, -184},
    { 1408, -160, -224},
    { 1120, -56, -192},
    { 1208, -40, -312},
    { 1104, 88, -432},
    { 1016, 0, -328},
    { 712, -40, -264},
    { 520, -40, -200},
    { 472, -8, -152},
    { 560, 80, -128},
    { 664, 104, -216},
    { 816, 248, -312},
    // 88 seconds
    { 1064, 312, -344},
    { 1160, 208, -272},
    { 1432, 208, -304},
    { 1192, 248, -256},
    { 1368, 104, -256},
    { 1400, 24, -104},
    { 1032, 16, -192},
    { 616, 24, -192},
    { 448, 16, -216},
    { 464, -8, -128},
    { 624, 48, -128},
    { 824, 104, -168},
    { 1112, 56, -280},
    { 1168, 72, -248},
    { 1648, -128, -480},
    { 936, 248, -112},
    { 1352, 32, -472},
    { 1296, 232, -248},
    { 1016, 80, -320},
    { 600, 48, -264},
    { 392, 8, -232},
    { 384, 88, -144},
    { 584, 104, -128},
    { 784, 248, -240},
    { 984, 224, -328},
    // 89 seconds
    { 1192, 200, -392},
    { 1720, 128, -384},
    { 1056, 232, -328},
    { 1360, 96, -344},
    { 1408, 80, -144},
    { 1160, -16, -136},
    { 728, -32, -120},
    { 592, -8, -208},
    { 544, -48, -200},
    { 592, 48, -232},
    { 784, 136, -280},
    { 1008, 120, -336},
    { 1160, 80, -272},
    { 1608, 16, -304},
    { 864, 336, -176},
    { 1160, 32, -544},
    { 1096, 80, -360},
    { 816, -48, -312},
    { 520, -8, -336},
    { 408, 24, -208},
    { 408, 88, -144},
    { 552, 168, -200},
    { 688, 264, -280},
    { 952, 320, -384},
    { 1160, 360, -440},
    // 90 seconds
    { 1608, 240, -384},
    { 1216, 304, -280},
    { 1368, 120, -312},
    { 1384, 80, -168},
    { 1040, 16, -160},
    { 672, 8, -272},
    { 400, -88, -224},
    { 496, 72, -160},
    { 752, 120, -144},
    { 984, 128, -136},
    { 1152, 104, -232},
    { 1248, -8, -312},
    { 1208, -32, -168},
    { 928, 80, -72},
    { 1056, 136, -312},
    { 1104, -8, -224},
    { 880, -32, -248},
    { 592, 24, -240},
    { 448, 8, -192},
    { 472, 96, -144},
    { 664, 136, -208},
    { 880, 208, -264},
    { 1088, 192, -272},
    { 1336, 200, -224},
    { 1408, 280, -320},
    // 91 seconds
    { 1216, 240, -200},
    { 1280, 112, -160},
    { 1272, 32, -56},
    { 920, 8, -144},
    { 592, 0, -176},
    { 416, 16, -208},
    { 464, -8, -160},
    { 808, 64, -128},
    { 1024, 16, -192},
    { 1232, 16, -224},
    { 1144, -64, -352},
    { 1160, 8, -256},
    { 984, 72, -208},
    { 1016, 64, -272},
    { 1072, 40, -272},
    { 752, 24, -248},
    { 496, -16, -160},
    { 440, 24, -96},
    { 496, 112, -128},
    { 672, 192, -208},
    { 960, 264, -264},
    { 1176, 272, -312},
    { 1128, 176, -264},
    { 1296, 136, -328},
    { 1256, 160, -240},
    // 92 seconds
    { 1344, 80, -160},
    { 1248, 56, -64},
    { 904, 16, -168},
    { 624, 8, -168},
    { 480, 0, -184},
    { 504, 0, -144},
    { 704, 32, -152},
    { 984, 16, -192},
    { 1272, -80, -192},
    { 1504, -136, -216},
    { 1088, 24, -192},
    { 1168, 32, -336},
    { 1192, 112, -416},
    { 1040, -24, -344},
    { 680, -48, -248},
    { 496, -8, -160},
    { 432, 56, -128},
    { 496, 72, -112},
    { 688, 184, -168},
    { 936, 248, -296},
    { 1176, 248, -320},
    { 1280, 192, -224},
    { 1200, 224, -336},
    { 1264, 120, -256},
    { 1440, 64, -184},
    // 93 seconds
    { 1320, -16, -80},
    { 928, -8, -152},
    { 592, -8, -192},
    { 480, -24, -144},
    { 544, 32, -136},
    { 656, 96, -144},
    { 912, 104, -184},
    { 1152, 88, -208},
    { 1192, 96, -328},
    { 1464, -16, -272},
    { 752, 328, -320},
    { 1104, 80, -320},
    { 1112, 192, -304},
    { 976, 104, -240},
    { 616, 96, -192},
    { 464, 88, -136},
    { 424, 160, -80},
    { 592, 232, -152},
    { 736, 296, -200},
    { 1016, 360, -280},
    { 1208, 328, -352},
    { 1608, 232, -280},
    { 1064, 376, -304},
    { 1264, 144, -272},
    { 1368, 96, -96},
    // 94 seconds
    { 1088, 64, -136},
    { 664, 72, -168},
    { 480, 32, -168},
    { 456, 24, -160},
    { 648, 48, -144},
    { 960, 72, -88},
    { 1240, 40, -160},
    { 1296, -72, -208},
    { 1624, -256, -136},
    { 840, 200, -264},
    { 1080, 32, -328},
    { 1112, 80, -368},
    { 848, 40, -320},
    { 488, -16, -240},
    { 424, 8, -152},
    { 528, 168, -96},
    { 808, 240, -168},
    { 792, 192, -168},
    { 952, 288, -368},
    { 1120, 232, -352},
    { 1408, 376, -320},
    { 1184, 360, -216},
    { 1320, 152, -120},
    { 1280, 160, -144},
    { 984, 64, -168},
    // 95 seconds
    { 664, 40, -160},
    { 512, 64, -216},
    { 624, 80, -136},
    { 736, 56, -152},
    { 872, 112, -224},
    { 1112, 16, -232},
    { 1192, 48, -312},
    { 1184, 144, -256},
    { 1072, 144, -288},
    { 1104, 56, -368},
    { 952, -48, -312},
    { 712, -48, -304},
    { 496, 0, -240},
    { 472, 40, -176},
    { 496, 216, -256},
    { 664, 200, -256},
    { 888, 312, -368},
    { 1144, 272, -424},
    { 1424, 176, -312},
    { 1128, 256, -424},
    { 1240, 216, -248},
    { 1352, 152, -184},
    { 1248, 64, -128},
    { 864, 64, -184},
    { 592, -8, -208},
    // 96 seconds
    { 576, -88, -160},
    { 536, -88, -208},
    { 816, -64, -240},
    { 1088, -72, -304},
    { 1216, -96, -344},
    { 1456, -264, -336},
    { 984, 136, -272},
    { 1272, -80, -312},
    { 1248, 40, -288},
    { 960, 0, -304},
    { 568, -24, -304},
    { 384, -48, -216},
    { 368, -48, -104},
    { 536, 64, -152},
    { 752, 192, -232},
    { 976, 248, -328},
    { 1184, 272, -408},
    { 1520, 104, -344},
    { 1160, 216, -360},
    { 1440, 48, -248},
    { 1424, 40, -136},
    { 1224, -24, -120},
    { 840, 8, -160},
    { 592, 0, -168},
    { 456, 16, -192},
    // 97 seconds
    { 520, 32, -176},
    { 704, 32, -168},
    { 912, 8, -168},
    { 1248, -88, -144},
    { 1264, -120, -256},
    { 1056, -48, -200},
    { 1192, 8, -320},
    { 1296, 96, -400},
    { 1144, -24, -312},
    { 752, -96, -248},
    { 488, -64, -168},
    { 392, -8, -144},
    { 488, 88, -112},
    { 664, 160, -208},
    { 784, 240, -288},
    { 968, 264, -344},
    { 1160, 240, -440},
    { 1632, 96, -352},
    { 1176, 152, -216},
    { 1480, 8, -240},
    { 1416, 0, -112},
    { 1152, -120, -208},
    { 888, -152, -152},
    { 784, -104, -176},
    { 752, -88, -136},
    // 98 seconds
    { 768, -56, -136},
    { 808, 24, -168},
    { 768, 8, -184},
    { 928, -40, -176},
    { 1552, 0, -112},
    { 1048, 280, -544},
    { 768, 104, -552},
    { 776, 184, -392},
    { 944, 408, -352},
    { 928, 336, -400},
    { 816, 312, -440},
    { 720, 240, -392},
    { 736, 312, -504},
    { 744, 384, -504},
    { 712, 328, -536},
    { 760, 360, -568},
    { 744, 288, -608},
    { 712, 176, -600},
    { 728, 160, -656},
    { 664, 120, -656},
    { 664, 128, -704},
    { 600, 112, -736},
    { 624, 168, -800},
    { 512, 88, -816},
    { 512, 104, -808},
    // 99 seconds
    { 480, 24, -832},
    { 440, 24, -808},
    { 408, 8, -856},
    { 384, -8, -808},
    { 256, 16, -736},
    { 360, 64, -848},
    { 312, 56, -912},
    { 296, 0, -984},
    { 256, 136, -560},
    { 256, 56, -880},
    { 312, 48, -912},
    { 344, 24, -928},
    { 208, 0, -944},
    { 216, 24, -952},
    { 224, -48, -1024},
    { 208, -24, -984},
    { 136, -16, -968},
    { 136, -56, -960},
    { 184, -16, -1016},
    { 120, -56, -976},
    { 160, -56, -944},
    { 160, -64, -992},
    { 88, -88, -992},
    { 120, -72, -992},
    { 48, -88, -952},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-07 13:52:19 local
AccelRawData *activity_sample_walk_200_pbl_25820_11(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25820_11
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 120, -496, -904},
    { 72, -488, -872},
    { 64, -472, -880},
    { 48, -512, -856},
    { 128, -472, -888},
    { 32, -560, -816},
    { 56, -504, -856},
    { 16, -528, -840},
    { 88, -584, -888},
    { 48, -552, -872},
    { 40, -504, -872},
    { 40, -496, -944},
    { 40, -528, -896},
    { -16, -608, -928},
    { -64, -352, -952},
    { 120, -472, -808},
    { 72, -344, -808},
    { 72, -304, -840},
    { 120, -344, -792},
    { 48, -272, -904},
    { 224, -280, -1088},
    { 408, -304, -1096},
    { 392, -496, -976},
    { 272, -648, -640},
    { 240, -632, -280},
    // 1 seconds
    { 376, -176, -216},
    { 432, -304, -160},
    { 680, -96, -232},
    { 896, 24, -376},
    { 992, -32, -200},
    { 1584, 232, -136},
    { 1584, 392, -24},
    { 1544, 392, -192},
    { 1496, 328, 0},
    { 1440, 312, -8},
    { 1376, 240, 16},
    { 1360, 96, 112},
    { 1368, 280, -48},
    { 1240, 272, 48},
    { 1216, 248, 64},
    { 1264, 168, 168},
    { 1368, 128, 144},
    { 1248, 48, 136},
    { 1096, -32, 112},
    { 1056, -24, 40},
    { 960, -80, 120},
    { 840, -40, 152},
    { 808, 16, 64},
    { 808, 72, 8},
    { 848, 48, 32},
    // 2 seconds
    { 856, -56, 56},
    { 936, -192, 160},
    { 1376, -232, 88},
    { 1136, -32, -32},
    { 928, -120, 40},
    { 1288, -144, 56},
    { 1336, -216, 224},
    { 1176, -136, 232},
    { 944, 8, 136},
    { 888, 64, 72},
    { 872, 88, 128},
    { 1096, 104, 152},
    { 1176, 232, 56},
    { 1344, 392, -16},
    { 1320, 280, 72},
    { 1744, 464, 128},
    { 1072, 336, 208},
    { 1432, 168, 96},
    { 1696, 40, 304},
    { 1736, -64, 328},
    { 1384, -72, 288},
    { 1224, -80, 264},
    { 1128, -104, 232},
    { 1112, -152, 192},
    { 1224, -288, 184},
    // 3 seconds
    { 1248, -464, 336},
    { 1064, -376, 64},
    { 928, -600, 104},
    { 920, -312, 32},
    { 1240, -152, -16},
    { 1416, -168, 120},
    { 1400, -72, 144},
    { 1096, 56, 72},
    { 952, 64, 128},
    { 976, 104, 120},
    { 1416, 88, 80},
    { 1760, 192, 152},
    { 1784, 560, 192},
    { 1608, 624, 200},
    { 1264, 400, 40},
    { 1144, 240, 136},
    { 1688, 208, 280},
    { 1928, -32, 448},
    { 1600, -176, 288},
    { 1320, -136, 160},
    { 1216, -80, 192},
    { 1136, -80, 184},
    { 1184, -176, 192},
    { 1112, -288, 168},
    { 992, -368, 208},
    // 4 seconds
    { 752, -232, -96},
    { 1104, -536, 104},
    { 736, -288, 24},
    { 1448, -232, 24},
    { 1568, -152, 96},
    { 1528, -8, 136},
    { 1096, 8, 160},
    { 960, 32, 64},
    { 1048, 24, 104},
    { 1288, 8, 152},
    { 1664, 48, 224},
    { 1680, 344, 248},
    { 1616, 744, 456},
    { 1552, 512, 144},
    { 904, 456, -32},
    { 1344, 368, 144},
    { 1880, 264, 392},
    { 2088, -248, 560},
    { 1776, -312, 360},
    { 1480, -176, 216},
    { 1312, -104, 176},
    { 1224, -120, 224},
    { 1144, -216, 152},
    { 944, -336, 48},
    { 984, -280, 24},
    // 5 seconds
    { 992, -536, -88},
    { 856, -552, 128},
    { 1096, -304, 80},
    { 1288, -136, -40},
    { 1688, -136, 48},
    { 1712, -104, 208},
    { 1408, 8, 304},
    { 1200, 64, 160},
    { 1168, 64, 192},
    { 1400, 40, 168},
    { 1568, 144, 160},
    { 1672, 456, 400},
    { 1632, 1024, 488},
    { 1440, 544, 96},
    { 1112, 272, 56},
    { 1496, 168, 176},
    { 2024, -96, 424},
    { 1840, -240, 464},
    { 1544, -208, 248},
    { 1272, -128, 208},
    { 1152, -88, 192},
    { 1128, -112, 144},
    { 1104, -168, 176},
    { 1032, -288, 88},
    { 824, -320, 8},
    // 6 seconds
    { 1224, -496, -48},
    { 672, -384, -64},
    { 1144, -232, -56},
    { 1296, -200, 40},
    { 1600, -96, 104},
    { 1496, -8, 184},
    { 1200, 24, 200},
    { 1088, 16, 96},
    { 1184, 8, 136},
    { 1488, 0, 48},
    { 1704, 128, 192},
    { 1776, 584, 216},
    { 1856, 896, 288},
    { 936, 384, -40},
    { 1384, 232, 104},
    { 1816, 72, 312},
    { 1896, -176, 384},
    { 1512, -200, 232},
    { 1320, -96, 176},
    { 1224, -96, 200},
    { 1128, -120, 216},
    { 1096, -184, 136},
    { 1112, -280, 192},
    { 1136, -312, 192},
    { 1048, -392, 96},
    // 7 seconds
    { 816, -392, 136},
    { 976, -224, -96},
    { 1208, -160, -48},
    { 1504, -184, 64},
    { 1488, -80, 72},
    { 1104, 32, 144},
    { 960, 96, 32},
    { 968, 16, 168},
    { 1264, -48, 72},
    { 1624, 56, 136},
    { 1704, 400, 184},
    { 1616, 536, 256},
    { 1256, 472, 192},
    { 984, 168, 96},
    { 1360, 160, 224},
    { 1664, 16, 400},
    { 1536, -72, 256},
    { 1192, -56, 184},
    { 1048, -48, 160},
    { 984, -64, 144},
    { 1040, -128, 160},
    { 1232, -240, 96},
    { 1448, -376, 24},
    { 968, -576, 80},
    { 1024, -504, 72},
    // 8 seconds
    { 744, -216, -128},
    { 1272, -208, -200},
    { 1400, -208, 16},
    { 1272, -144, 152},
    { 1008, -24, 48},
    { 872, 96, 64},
    { 832, 72, 96},
    { 1096, 32, 40},
    { 1472, 88, 112},
    { 1704, 336, 232},
    { 1824, 568, 256},
    { 1208, 504, 112},
    { 1136, 240, 56},
    { 1632, 72, 352},
    { 1904, -104, 472},
    { 1424, -80, 224},
    { 1104, -64, 88},
    { 1056, -64, 136},
    { 1032, -72, 136},
    { 1016, -152, 184},
    { 1120, -232, 64},
    { 1096, -192, 224},
    { 1056, -320, 200},
    { 880, -216, 144},
    { 936, -192, -24},
    // 9 seconds
    { 1208, -200, 16},
    { 1432, -80, 88},
    { 1176, 16, 112},
    { 864, 0, 48},
    { 872, -40, 96},
    { 968, 16, 144},
    { 1216, 16, 72},
    { 1480, 104, 128},
    { 1768, 320, 176},
    { 1560, 512, 232},
    { 1568, 480, 96},
    { 896, 224, 104},
    { 1384, 152, 200},
    { 1696, -16, 416},
    { 1496, -112, 320},
    { 1176, -120, 232},
    { 1088, -72, 144},
    { 1064, -72, 144},
    { 1104, -128, 144},
    { 1072, -176, 96},
    { 1112, -288, 64},
    { 968, -304, 56},
    { 1184, -416, -16},
    { 856, -344, 112},
    { 1200, -208, 64},
    // 10 seconds
    { 1384, -112, 56},
    { 1328, -104, 72},
    { 976, -80, 152},
    { 872, -24, 176},
    { 896, 24, 160},
    { 1120, -24, 152},
    { 1432, -8, 160},
    { 1608, 152, 232},
    { 1672, 544, 184},
    { 1672, 512, 240},
    { 984, 336, 48},
    { 1376, 240, 144},
    { 1768, 64, 392},
    { 1704, -192, 480},
    { 1416, -184, 272},
    { 1224, -80, 192},
    { 1136, -80, 176},
    { 1104, -120, 200},
    { 1136, -176, 144},
    { 1104, -256, 120},
    { 1112, -336, 120},
    { 1008, -392, 0},
    { 784, -384, 24},
    { 992, -288, 72},
    { 1184, -160, -8},
    // 11 seconds
    { 1304, -152, 64},
    { 1216, -112, 48},
    { 976, -88, 160},
    { 984, 8, 96},
    { 1128, 8, 192},
    { 1488, 48, 136},
    { 1672, 192, 224},
    { 1840, 632, 240},
    { 1312, 304, 64},
    { 1328, 584, 40},
    { 976, 536, 16},
    { 1536, 256, 240},
    { 1872, -64, 528},
    { 1832, -312, 472},
    { 1480, -288, 288},
    { 1296, -120, 232},
    { 1224, -96, 224},
    { 1256, -144, 176},
    { 1248, -320, 144},
    { 1072, -416, 112},
    { 832, -416, 16},
    { 1192, -488, -64},
    { 536, -360, 64},
    { 1032, -336, 104},
    { 1376, -128, 40},
    // 12 seconds
    { 1640, -88, 104},
    { 1448, 64, 96},
    { 1096, 104, 104},
    { 1000, 8, 120},
    { 1232, -56, 112},
    { 1560, 80, 88},
    { 1792, 384, 136},
    { 1672, 632, 144},
    { 1248, 184, 64},
    { 1376, 344, 0},
    { 1560, -120, 200},
    { 1512, -288, 280},
    { 1280, -168, 16},
    { 1040, -64, 40},
    { 920, -48, 64},
    { 912, -32, 88},
    { 952, -248, 128},
    { 1144, -312, 88},
    { 1240, -384, 144},
    { 1504, -512, 80},
    { 1024, -544, 240},
    { 1008, -232, -88},
    { 1168, -200, -112},
    { 1240, -256, 32},
    { 1080, -120, 8},
    // 13 seconds
    { 752, 16, -64},
    { 656, 88, -104},
    { 760, 8, 8},
    { 1128, -24, 16},
    { 1408, 80, 128},
    { 1672, 272, 176},
    { 1928, 400, 312},
    { 1160, 512, 72},
    { 1280, 216, 152},
    { 1592, 56, 352},
    { 1592, -136, 392},
    { 1200, -128, 200},
    { 1072, -64, 120},
    { 1016, -56, 96},
    { 1000, -112, 96},
    { 1080, -248, 72},
    { 1136, -352, 48},
    { 1040, -352, -72},
    { 1080, -552, 0},
    { 792, -488, 88},
    { 1264, -280, 80},
    { 1256, -144, -48},
    { 1360, -152, 24},
    { 1136, -88, 64},
    { 936, -48, 112},
    // 14 seconds
    { 912, 16, 80},
    { 1008, 16, 24},
    { 1264, 48, 16},
    { 1504, 216, 112},
    { 1656, 624, 160},
    { 1224, 504, 248},
    { 1448, 552, 144},
    { 1248, 296, 216},
    { 1712, -8, 392},
    { 1616, -216, 504},
    { 1560, -240, 328},
    { 1200, -128, 272},
    { 1024, -80, 200},
    { 1000, -80, 144},
    { 984, -208, 128},
    { 952, -320, 72},
    { 1032, -360, 56},
    { 872, -360, -16},
    { 1128, -456, 24},
    { 848, -280, -64},
    { 1160, -264, -8},
    { 1440, -208, 40},
    { 1512, -144, 48},
    { 1144, -8, 16},
    { 888, 0, 8},
    // 15 seconds
    { 952, 0, 40},
    { 1160, -24, 24},
    { 1264, 40, -8},
    { 1424, 192, 48},
    { 1536, 504, 104},
    { 1632, 328, 344},
    { 1256, 320, 168},
    { 1168, 280, 144},
    { 1464, 16, 248},
    { 1584, -128, 296},
    { 1384, -120, 280},
    { 1096, -96, 216},
    { 976, -48, 144},
    { 1032, -56, 112},
    { 1144, -144, 104},
    { 1272, -280, 80},
    { 1008, -416, -16},
    { 1232, -568, -64},
    { 840, -400, -24},
    { 968, -152, -88},
    { 1096, -88, -80},
    { 1208, -248, -16},
    { 1168, -96, 8},
    { 968, -8, -40},
    { 944, 48, -40},
    // 16 seconds
    { 1032, -8, 64},
    { 1304, 32, -40},
    { 1408, 168, -88},
    { 1544, 368, -88},
    { 1744, 400, 160},
    { 1296, 352, 104},
    { 1200, 112, 112},
    { 1480, -64, 288},
    { 1552, -184, 344},
    { 1352, -120, 184},
    { 1032, -56, 120},
    { 896, -40, 104},
    { 904, -88, 104},
    { 1088, -232, 176},
    { 1136, -304, 16},
    { 1064, -464, 80},
    { 1312, -688, 192},
    { 936, -392, 152},
    { 1168, -144, -16},
    { 1264, -112, -24},
    { 1248, -96, -24},
    { 960, -48, -56},
    { 776, -40, 0},
    { 792, 16, -8},
    { 1080, -16, 8},
    // 17 seconds
    { 1376, 56, -16},
    { 1584, 232, 40},
    { 1616, 448, 72},
    { 1760, 376, 128},
    { 920, 224, 72},
    { 1336, 56, 176},
    { 1592, -64, 368},
    { 1424, -112, 288},
    { 1120, -64, 136},
    { 960, -24, 80},
    { 904, -40, 96},
    { 1016, -152, 144},
    { 1160, -240, 8},
    { 1136, -392, 8},
    { 1000, -608, 56},
    { 1136, -584, 128},
    { 1176, -336, 104},
    { 1360, -88, -104},
    { 1360, -104, 72},
    { 1056, -24, 32},
    { 768, -32, 48},
    { 712, 40, 104},
    { 880, 48, 136},
    { 1128, 168, -24},
    { 1264, 264, 32},
    // 18 seconds
    { 1536, 344, 288},
    { 1928, 424, 440},
    { 1216, 344, 208},
    { 1360, 160, 152},
    { 1672, 48, 296},
    { 1600, -88, 280},
    { 1208, -128, 136},
    { 1000, -48, 80},
    { 896, -56, 40},
    { 896, -120, 48},
    { 912, -200, 16},
    { 1072, -288, 24},
    { 1120, -328, 48},
    { 1384, -416, 24},
    { 808, -312, 168},
    { 1312, -152, -88},
    { 1424, -176, -40},
    { 1296, -96, 32},
    { 864, -40, -16},
    { 720, 40, -32},
    { 784, 24, 40},
    { 1064, 40, 48},
    { 1256, 160, 16},
    { 1504, 264, 144},
    { 1584, 360, 192},
    // 19 seconds
    { 1832, 344, 264},
    { 952, 400, 40},
    { 1288, 216, 96},
    { 1560, 0, 296},
    { 1440, -104, 304},
    { 1192, -120, 160},
    { 1000, -24, 64},
    { 976, -24, 40},
    { 1088, -136, 88},
    { 1176, -232, 16},
    { 1208, -304, -16},
    { 1128, -448, 56},
    { 960, -368, 0},
    { 880, -200, -40},
    { 1064, -160, -152},
    { 1264, -176, 0},
    { 1176, -104, 56},
    { 856, -16, 48},
    { 760, 48, 56},
    { 808, 88, 56},
    { 1016, 104, 8},
    { 1184, 136, -40},
    { 1480, 160, 64},
    { 1544, 224, 136},
    { 1648, 216, 48},
    // 20 seconds
    { 1160, 240, -48},
    { 1312, 144, 40},
    { 1544, -32, 216},
    { 1368, -104, 256},
    { 1080, -88, 104},
    { 912, -16, 32},
    { 872, -40, 40},
    { 896, -152, 72},
    { 904, -176, 8},
    { 920, -240, -16},
    { 968, -240, -48},
    { 1208, -408, -56},
    { 1040, -264, 0},
    { 1080, -144, -24},
    { 1208, -120, -80},
    { 1232, -120, -16},
    { 968, -120, 128},
    { 792, -24, 80},
    { 768, 72, 64},
    { 840, 104, 32},
    { 1088, 112, -40},
    { 1400, 128, 48},
    { 1616, 288, 72},
    { 1392, 320, 160},
    { 1288, 288, 48},
    // 21 seconds
    { 1144, 224, 72},
    { 1584, 32, 168},
    { 1544, -112, 336},
    { 1272, -160, 208},
    { 1008, -80, 88},
    { 840, -24, 48},
    { 848, -56, 24},
    { 944, -176, 72},
    { 944, -224, 16},
    { 1072, -256, -56},
    { 1016, -264, -160},
    { 1264, -376, -16},
    { 784, -376, 264},
    { 1336, -184, 16},
    { 1360, -16, -136},
    { 1136, -40, 24},
    { 888, -64, 96},
    { 896, 32, 8},
    { 936, 112, 16},
    { 1080, 328, -96},
    { 1152, 392, -48},
    { 1416, 408, 96},
    { 1392, 416, 224},
    { 1320, 520, -48},
    { 1688, 176, 168},
    // 22 seconds
    { 1720, -40, 296},
    { 1776, -216, 368},
    { 1384, -160, 208},
    { 1024, -72, 104},
    { 920, -48, -24},
    { 848, -112, 56},
    { 888, -152, 96},
    { 1120, -192, 32},
    { 1056, -128, -96},
    { 1344, -272, -56},
    { 840, -352, 240},
    { 1096, -168, 0},
    { 1272, -120, -40},
    { 1320, 120, -128},
    { 1064, 72, 32},
    { 896, 64, 88},
    { 928, 120, 8},
    { 1144, 248, 0},
    { 1272, 304, -16},
    { 1440, 432, 72},
    { 1336, 504, 120},
    { 1824, 440, 64},
    { 1064, 320, 64},
    { 1664, 160, 168},
    { 1728, -72, 392},
    // 23 seconds
    { 1464, -176, 256},
    { 1104, -112, 112},
    { 944, -48, 80},
    { 904, -56, 40},
    { 888, -136, 64},
    { 864, -232, 0},
    { 944, -272, -24},
    { 904, -296, -40},
    { 1160, -224, -176},
    { 1240, -376, 72},
    { 1192, -184, 24},
    { 1432, -56, -16},
    { 1344, 16, -8},
    { 952, 136, -48},
    { 784, 64, -40},
    { 904, 96, 32},
    { 1232, 168, 32},
    { 1272, 336, -16},
    { 1480, 416, 32},
    { 1536, 296, 176},
    { 1200, 352, 88},
    { 1424, 216, 112},
    { 1600, 64, 320},
    { 1632, -136, 408},
    { 1304, -136, 200},
    // 24 seconds
    { 1032, -24, 88},
    { 952, 0, 40},
    { 1024, -128, 104},
    { 1016, -256, 56},
    { 1112, -336, -16},
    { 1112, -472, -128},
    { 1440, -640, 0},
    { 1016, -432, 144},
    { 1304, -112, -184},
    { 1336, -176, -88},
    { 1224, -200, 24},
    { 856, -80, 24},
    { 792, 8, 24},
    { 848, 64, 16},
    { 1200, 160, -32},
    { 1392, 240, 40},
    { 1504, 320, 72},
    { 1448, 384, 136},
    { 1504, 496, 88},
    { 1256, 384, 48},
    { 1520, 168, 208},
    { 1696, -64, 376},
    { 1472, -120, 256},
    { 1152, -64, 120},
    { 1008, -48, 72},
    // 25 seconds
    { 1064, -104, 64},
    { 1096, -232, 88},
    { 1184, -320, 0},
    { 1120, -376, -96},
    { 1384, -568, 0},
    { 848, -416, 120},
    { 1216, -232, -48},
    { 1200, -208, -64},
    { 1248, -168, 16},
    { 976, -88, -48},
    { 784, -8, -40},
    { 744, 16, -8},
    { 1048, 160, -8},
    { 1376, 344, -80},
    { 1328, 208, -48},
    { 1408, 256, 16},
    { 1752, 272, 144},
    { 1208, 552, -48},
    { 1120, 240, 96},
    { 1440, 104, 160},
    { 1552, 48, 272},
    { 1208, -40, 112},
    { 1000, -24, 64},
    { 920, 24, 0},
    { 992, -80, 16},
    // 26 seconds
    { 1144, -224, 48},
    { 1224, -264, -8},
    { 1240, -320, 0},
    { 1584, -456, 0},
    { 816, -264, 40},
    { 1040, -248, 32},
    { 1112, -144, -80},
    { 1072, -88, -80},
    { 864, -32, -96},
    { 648, -24, 40},
    { 672, 16, 40},
    { 936, 16, -8},
    { 1304, 128, -40},
    { 1528, 336, 72},
    { 1600, 376, 32},
    { 1760, 200, 184},
    { 1104, 320, 80},
    { 1448, 176, 176},
    { 1512, 104, 304},
    { 1320, -24, 224},
    { 992, -8, 64},
    { 832, 8, 32},
    { 800, -32, 48},
    { 872, -160, 88},
    { 952, -216, 32},
    // 27 seconds
    { 1152, -288, 40},
    { 1176, -368, -8},
    { 1632, -480, 8},
    { 904, -376, 160},
    { 1136, -152, -40},
    { 1208, -112, -64},
    { 1072, -80, -80},
    { 776, -64, -64},
    { 648, -48, -40},
    { 712, 16, -48},
    { 1016, 72, -40},
    { 1200, 144, 16},
    { 1472, 312, 192},
    { 1664, 384, 336},
    { 1440, 432, 168},
    { 1176, 192, 104},
    { 1304, -32, 192},
    { 1400, -96, 248},
    { 1112, -24, 128},
    { 888, -24, 104},
    { 728, -72, 104},
    { 752, -80, 48},
    { 872, -136, 24},
    { 1080, -256, 168},
    { 1264, -344, 224},
    // 28 seconds
    { 1592, -560, 176},
    { 1024, -480, 504},
    { 1264, -320, 160},
    { 1320, -8, -240},
    { 1184, -224, -32},
    { 888, -232, -112},
    { 784, 88, -80},
    { 744, 200, 32},
    { 816, 192, -16},
    { 1072, 152, 40},
    { 1288, 96, 192},
    { 1528, 224, 232},
    { 1736, 328, 288},
    { 848, 288, 128},
    { 1728, 208, 296},
    { 1712, 16, 456},
    { 1512, -192, 288},
    { 1224, -128, 144},
    { 1088, -64, 80},
    { 1040, -80, 96},
    { 1072, -216, 128},
    { 1056, -320, 8},
    { 1080, -424, 16},
    { 968, -464, -32},
    { 896, -464, 40},
    // 29 seconds
    { 1248, -336, 64},
    { 1272, -200, -40},
    { 1368, -120, -32},
    { 1264, -64, -56},
    { 920, -48, 104},
    { 952, 16, 56},
    { 1096, 32, 160},
    { 1256, 88, 112},
    { 1424, 160, 216},
    { 1632, 608, 144},
    { 1608, 488, 96},
    { 1048, 368, 16},
    { 1392, 392, 104},
    { 1696, 136, 360},
    { 1736, -176, 408},
    { 1456, -216, 248},
    { 1176, -96, 104},
    { 1112, -88, 80},
    { 1144, -120, 112},
    { 1088, -272, 56},
    { 1096, -384, 8},
    { 944, -416, -64},
    { 1376, -640, 96},
    { 736, -336, 152},
    { 1352, -224, 48},
    // 30 seconds
    { 1400, -56, -128},
    { 1352, -64, -24},
    { 1064, -128, 16},
    { 960, -104, 224},
    { 1040, -8, 80},
    { 1232, 56, 16},
    { 1424, 120, -8},
    { 1672, 208, 152},
    { 1768, 616, 456},
    { 1624, 464, 224},
    { 816, 376, -48},
    { 1496, 256, 200},
    { 1816, 40, 336},
    { 1608, -96, 208},
    { 1304, -16, 80},
    { 1136, 0, 144},
    { 1152, -56, 72},
    { 1272, -168, 232},
    { 1384, -264, 112},
    { 1208, -344, 112},
    { 992, -480, -80},
    { 1024, -488, -8},
    { 888, -264, -240},
    { 1120, -168, -224},
    { 1232, -136, -24},
    // 31 seconds
    { 1104, -48, 88},
    { 928, 32, 40},
    { 832, 88, -72},
    { 912, 160, -48},
    { 1208, 376, -192},
    { 1480, 416, 40},
    { 1616, 512, 128},
    { 1536, 568, 208},
    { 1360, 672, 80},
    { 1040, 424, 88},
    { 1584, 240, 176},
    { 1632, 56, 376},
    { 1448, -88, 208},
    { 1088, -80, 112},
    { 928, -64, 80},
    { 896, -80, 56},
    { 984, -208, 56},
    { 1008, -256, -40},
    { 1080, -384, 40},
    { 1304, -496, 40},
    { 936, -376, 24},
    { 1064, -192, 0},
    { 1224, -136, -40},
    { 1280, -72, -88},
    { 1048, -8, -96},
    // 32 seconds
    { 800, -40, -16},
    { 808, 0, -8},
    { 1080, 0, -16},
    { 1304, 168, -120},
    { 1536, 456, -160},
    { 1608, 400, 16},
    { 1608, 160, -72},
    { 1184, 368, 48},
    { 1448, 240, 144},
    { 1600, -64, 304},
    { 1440, -160, 288},
    { 1048, -80, 112},
    { 912, -8, 40},
    { 952, -40, 48},
    { 976, -216, 120},
    { 912, -328, 104},
    { 1104, -280, 56},
    { 1088, -136, -16},
    { 1104, -168, 80},
    { 1008, -200, 88},
    { 1240, -120, -24},
    { 1416, -40, -8},
    { 1136, 48, 48},
    { 712, 64, 24},
    { 664, 72, 96},
    // 33 seconds
    { 808, 56, 128},
    { 1168, 16, 72},
    { 1448, 56, 120},
    { 1608, 184, 176},
    { 1896, 456, 256},
    { 1008, 464, 104},
    { 1112, 152, 128},
    { 1504, 88, 288},
    { 1600, -80, 392},
    { 1192, -72, 224},
    { 976, -24, 112},
    { 880, -8, 112},
    { 936, -88, 112},
    { 1000, -232, 104},
    { 1240, -328, 64},
    { 1208, -320, -24},
    { 1392, -616, 136},
    { 960, -504, 160},
    { 1128, -184, -208},
    { 1256, -152, -208},
    { 1168, -200, -96},
    { 784, -104, -40},
    { 656, -48, 0},
    { 704, 0, 48},
    { 1056, 136, -56},
    // 34 seconds
    { 1392, 256, 48},
    { 1688, 360, 208},
    { 1504, 608, 184},
    { 1488, 424, 96},
    { 1192, 232, 88},
    { 1584, 96, 192},
    { 1680, -64, 312},
    { 1440, -216, 328},
    { 1152, -120, 184},
    { 984, -64, 88},
    { 800, -120, 40},
    { 816, -168, 0},
    { 952, -296, -16},
    { 928, -368, -80},
    { 1072, -496, -88},
    { 944, -456, 8},
    { 1360, -320, 24},
    { 1336, -192, -80},
    { 1496, -88, 32},
    { 1200, -24, 96},
    { 920, -8, 88},
    { 896, 0, 80},
    { 1160, 232, 16},
    { 1448, 224, 88},
    { 1504, 600, -96},
    // 35 seconds
    { 1440, 560, -136},
    { 1640, 352, 16},
    { 1128, 376, -112},
    { 1744, 88, 48},
    { 1712, -112, 248},
    { 1704, -256, 296},
    { 1488, -184, 168},
    { 1264, -120, 160},
    { 1024, -216, 112},
    { 928, -192, 40},
    { 888, -352, 56},
    { 904, -392, -32},
    { 752, -472, -8},
    { 1344, -568, 40},
    { 816, -368, 24},
    { 1192, -176, -16},
    { 1504, -104, -80},
    { 1656, 0, -64},
    { 1208, -24, 144},
    { 1000, -64, -24},
    { 1016, -88, 16},
    { 1136, -8, -8},
    { 1240, 104, -40},
    { 1464, 248, -40},
    { 1640, 576, 32},
    // 36 seconds
    { 1640, 352, 88},
    { 1032, 192, -48},
    { 1584, 24, 168},
    { 1784, -104, 344},
    { 1616, -224, 336},
    { 1248, -152, 80},
    { 1040, -56, 48},
    { 1024, -40, 72},
    { 1024, -128, 80},
    { 1000, -256, 0},
    { 1000, -424, 24},
    { 904, -408, -80},
    { 1336, -624, 48},
    { 816, -440, 72},
    { 1504, -296, -88},
    { 1504, -160, -248},
    { 1368, -136, -72},
    { 992, -192, -16},
    { 856, -96, 168},
    { 904, -16, 56},
    { 1352, 32, 56},
    { 1576, 160, 56},
    { 1800, 472, 80},
    { 1536, 480, 200},
    { 1120, 416, 16},
    // 37 seconds
    { 1224, 280, 56},
    { 1608, 152, 168},
    { 1832, -72, 368},
    { 1568, -200, 272},
    { 1336, -136, 152},
    { 1264, -120, 128},
    { 1208, -192, 160},
    { 1216, -280, 48},
    { 1248, -392, -56},
    { 1000, -520, -88},
    { 1096, -648, -48},
    { 800, -456, 0},
    { 1040, -280, -64},
    { 1136, -232, -160},
    { 1312, -192, -112},
    { 1200, -128, -96},
    { 992, -48, 48},
    { 1024, 32, -24},
    { 1232, 56, -72},
    { 1376, 208, -40},
    { 1664, 448, 24},
    { 1584, 576, 176},
    { 1856, 296, 208},
    { 952, 368, 96},
    { 1472, 152, 152},
    // 38 seconds
    { 1696, -64, 312},
    { 1608, -208, 328},
    { 1344, -160, 176},
    { 1136, -120, 128},
    { 1024, -144, 112},
    { 984, -208, 88},
    { 944, -288, -8},
    { 1040, -336, -80},
    { 936, -504, 56},
    { 1032, -464, -16},
    { 1000, -264, -120},
    { 1192, -208, -232},
    { 1352, -232, -88},
    { 1184, -160, -104},
    { 936, -120, -32},
    { 864, -32, -80},
    { 936, 64, 24},
    { 1336, 160, -72},
    { 1464, 352, -32},
    { 1544, 424, -16},
    { 1392, 296, 40},
    { 1400, 224, -24},
    { 1296, 224, -16},
    { 1536, 64, 144},
    { 1648, -112, 280},
    // 39 seconds
    { 1424, -160, 224},
    { 1104, -128, 184},
    { 984, -96, 168},
    { 928, -112, 136},
    { 928, -160, 168},
    { 944, -200, 160},
    { 992, -192, 144},
    { 1096, -224, 56},
    { 984, -40, 16},
    { 872, 144, -168},
    { 1264, 88, -192},
    { 1128, 168, -296},
    { 712, 128, -352},
    { 400, 160, -360},
    { 424, 296, -264},
    { 592, 384, -240},
    { 848, 392, -344},
    { 1120, 288, -200},
    { 1328, 184, -184},
    { 1664, 104, -72},
    { 1256, 96, -96},
    { 1064, 112, 8},
    { 1272, -64, 288},
    { 1248, 152, 320},
    { 720, 320, -48},
    // 40 seconds
    { 528, 264, -200},
    { 504, 192, -184},
    { 768, -160, -216},
    { 904, -240, -192},
    { 1008, -152, -344},
    { 1056, -176, -248},
    { 1568, -376, -72},
    { 976, 96, -384},
    { 1144, -192, -24},
    { 1304, -128, 320},
    { 1080, 96, 256},
    { 528, 408, 72},
    { 376, 312, 24},
    { 384, 224, -80},
    { 568, 224, -304},
    { 864, 184, -424},
    { 1240, 80, -456},
    { 1512, 40, -440},
    { 2080, -240, -416},
    { 936, 64, -416},
    { 1456, -216, 80},
    { 1360, -80, 208},
    { 1000, -16, 80},
    { 648, 80, -80},
    { 464, 0, -160},
    // 41 seconds
    { 360, -24, -312},
    { 440, -208, -216},
    { 672, -360, -104},
    { 1032, -320, 0},
    { 1280, -248, -48},
    { 1640, -136, -8},
    { 1472, -240, -192},
    { 1480, -216, 0},
    { 1208, -120, 152},
    { 752, 0, 104},
    { 488, 40, 112},
    { 528, -96, 88},
    { 496, -88, 56},
    { 992, 128, -40},
    { 1360, 224, -56},
    { 1712, 336, 192},
    { 2152, 368, 368},
    { 736, 408, -112},
    { 1752, 72, 80},
    { 1768, 16, 384},
    { 1560, -152, 288},
    { 1208, -192, 144},
    { 896, -72, 64},
    { 816, -72, -16},
    { 808, -192, -16},
    // 42 seconds
    { 896, -304, -8},
    { 848, -360, -24},
    { 984, -328, -128},
    { 1224, -480, 48},
    { 1128, -328, 112},
    { 1400, -192, 32},
    { 1560, -88, 32},
    { 1360, -32, 112},
    { 904, 0, 48},
    { 808, 8, -8},
    { 808, -8, 0},
    { 1016, -16, -8},
    { 1248, 72, 64},
    { 1472, 320, 72},
    { 1592, 536, 112},
    { 1456, 560, 152},
    { 1344, 264, 72},
    { 1672, 24, 304},
    { 1840, -200, 368},
    { 1424, -176, 232},
    { 1160, -72, 88},
    { 1040, -112, 96},
    { 1032, -40, 72},
    { 1104, -184, 32},
    { 1048, -320, -64},
    // 43 seconds
    { 1104, -384, -56},
    { 1168, -496, -16},
    { 904, -488, 48},
    { 1208, -200, -80},
    { 1312, -64, -152},
    { 1400, -80, 24},
    { 1160, -40, -40},
    { 880, -120, 112},
    { 880, 16, 56},
    { 1096, 8, 128},
    { 1440, 96, 56},
    { 1648, 272, 272},
    { 1696, 728, 256},
    { 1248, 384, 216},
    { 1144, 472, 168},
    { 1168, 360, 176},
    { 1720, 136, 304},
    { 1792, -120, 464},
    { 1600, -192, 304},
    { 1360, -128, 184},
    { 1248, -88, 136},
    { 1240, -136, 160},
    { 1216, -272, 112},
    { 1024, -344, -88},
    { 976, -440, -96},
    // 44 seconds
    { 816, -544, -136},
    { 840, -520, -72},
    { 1168, -376, 16},
    { 1368, -192, -120},
    { 1512, -120, -48},
    { 1232, -32, -56},
    { 984, -96, 128},
    { 1024, -24, 64},
    { 1136, 24, 48},
    { 1392, 64, 56},
    { 1608, 304, 112},
    { 1672, 728, 104},
    { 1200, 304, 48},
    { 1552, 352, 136},
    { 1200, 288, 88},
    { 1736, 8, 256},
    { 1736, -200, 424},
    { 1728, -216, 240},
    { 1312, -120, 192},
    { 1128, -96, 152},
    { 1080, -136, 152},
    { 1080, -168, 144},
    { 976, -224, 8},
    { 888, -280, 8},
    { 832, -352, 32},
    // 45 seconds
    { 1144, -376, 16},
    { 856, -264, 48},
    { 1232, -144, -72},
    { 1552, -104, -40},
    { 1480, -32, 8},
    { 1048, -40, 168},
    { 920, 32, 88},
    { 944, 72, 64},
    { 1112, 152, -8},
    { 1376, 256, -56},
    { 1616, 440, 0},
    { 1608, 464, 152},
    { 1784, 120, 96},
    { 1064, 200, -8},
    { 1512, 40, 104},
    { 1704, -96, 336},
    { 1592, -176, 384},
    { 1272, -136, 256},
    { 992, -184, 232},
    { 944, -152, 192},
    { 968, -224, 192},
    { 880, -320, 112},
    { 800, -304, 32},
    { 832, -280, -96},
    { 1272, -328, -104},
    // 46 seconds
    { 776, -304, 48},
    { 1280, -208, 0},
    { 1624, -104, -80},
    { 1448, 40, -16},
    { 976, 8, 104},
    { 840, 104, 8},
    { 872, 176, 104},
    { 1064, 264, -32},
    { 1256, 480, -120},
    { 1464, 488, -24},
    { 1416, 256, 48},
    { 1928, 24, 232},
    { 1208, 104, 64},
    { 1624, -128, 208},
    { 1520, -152, 392},
    { 1232, -168, 264},
    { 936, -104, 152},
    { 832, -96, 96},
    { 776, -112, 72},
    { 808, -128, 16},
    { 776, -176, -32},
    { 864, -256, -8},
    { 1056, -296, -96},
    { 1160, -192, 64},
    { 1232, -32, 88},
    // 47 seconds
    { 1456, 144, -80},
    { 1336, 176, -16},
    { 904, 176, -128},
    { 600, 104, 48},
    { 512, 184, 136},
    { 792, 416, 208},
    { 928, 488, 312},
    { 1216, 376, 560},
    { 1352, 504, 384},
    { 1728, 384, 344},
    { 1048, 368, 248},
    { 1560, 176, 408},
    { 1392, 32, 512},
    { 1192, -168, 512},
    { 880, -72, 408},
    { 648, -16, 352},
    { 568, 56, 176},
    { 536, -40, 224},
    { 632, -72, 184},
    { 808, -88, 160},
    { 1120, -136, 336},
    { 1688, -304, 400},
    { 1096, 8, 320},
    { 1552, -48, 240},
    { 1568, 88, 160},
    // 48 seconds
    { 1112, 72, 160},
    { 680, 8, 64},
    { 552, 128, -16},
    { 552, 160, 72},
    { 752, 112, 48},
    { 880, 48, 248},
    { 1248, 248, 200},
    { 1456, 432, 304},
    { 1872, 208, 264},
    { 872, 168, 112},
    { 1712, -112, 232},
    { 1696, -208, 416},
    { 1544, -224, 336},
    { 1080, -104, 144},
    { 824, 24, 0},
    { 760, 0, -8},
    { 840, -88, 16},
    { 848, -152, 0},
    { 832, -264, -88},
    { 872, -336, -160},
    { 1408, -536, -32},
    { 912, -320, 40},
    { 1336, -200, 80},
    { 1528, -96, 48},
    { 1592, 64, 112},
    // 49 seconds
    { 1104, 80, 80},
    { 792, 16, -32},
    { 864, 64, 0},
    { 1016, 72, 40},
    { 1264, 104, 48},
    { 1512, 360, -8},
    { 1552, 840, 192},
    { 1696, 176, 240},
    { 1264, 168, 192},
    { 1528, 152, 256},
    { 1688, -56, 392},
    { 1712, -216, 352},
    { 1312, -128, 216},
    { 1064, -112, 168},
    { 984, -72, 160},
    { 1056, -128, 152},
    { 1016, -328, 32},
    { 1016, -472, 88},
    { 920, -448, -40},
    { 1320, -560, -40},
    { 904, -392, 16},
    { 1392, -264, 48},
    { 1464, -128, -24},
    { 1400, -8, -120},
    { 1080, -24, -24},
    // 50 seconds
    { 936, -80, 72},
    { 1008, -48, 64},
    { 1400, -32, 72},
    { 1480, 160, 80},
    { 1600, 480, 56},
    { 1432, 528, 104},
    { 1440, 352, 96},
    { 928, 280, 96},
    { 1680, 112, 224},
    { 1696, -72, 400},
    { 1624, -240, 336},
    { 1264, -144, 152},
    { 1136, -88, 88},
    { 1176, -96, 120},
    { 1216, -200, 80},
    { 1120, -392, 40},
    { 1048, -480, -8},
    { 1008, -544, -80},
    { 976, -576, 88},
    { 1104, -224, -48},
    { 1312, -192, 0},
    { 1456, -152, 56},
    { 1128, -32, -88},
    { 904, -88, 80},
    { 920, 80, -32},
    // 51 seconds
    { 1216, 104, 72},
    { 1560, 296, 168},
    { 1664, 720, 296},
    { 1416, 520, 64},
    { 1712, 312, 320},
    { 1096, 480, 224},
    { 1480, 232, 288},
    { 1544, 56, 392},
    { 1600, -128, 392},
    { 1296, -160, 216},
    { 1064, -64, 80},
    { 1024, -32, 72},
    { 1128, -128, 104},
    { 1216, -256, 80},
    { 1152, -536, -32},
    { 880, -632, -200},
    { 1104, -712, 56},
    { 960, -480, -32},
    { 1280, -240, -184},
    { 1432, -168, -120},
    { 1200, -184, -48},
    { 840, -152, 64},
    { 832, -80, 64},
    { 912, -64, 48},
    { 1328, -80, 56},
    // 52 seconds
    { 1568, 104, 64},
    { 1840, 448, 88},
    { 1776, 832, 400},
    { 952, 392, -32},
    { 1192, 296, 128},
    { 1648, 136, 352},
    { 1688, -120, 384},
    { 1480, -240, 200},
    { 1296, -144, 160},
    { 1208, -112, 120},
    { 1208, -136, 128},
    { 1248, -224, 64},
    { 1096, -424, -56},
    { 1000, -624, -104},
    { 1064, -800, -24},
    { 824, -568, 0},
    { 1360, -336, -24},
    { 1320, -208, -104},
    { 1392, -112, -48},
    { 1192, -32, -56},
    { 984, -72, 88},
    { 1024, -48, 88},
    { 1312, 0, 80},
    { 1424, 184, 56},
    { 1624, 536, 16},
    // 53 seconds
    { 1448, 608, 64},
    { 1640, 272, 176},
    { 1112, 416, 32},
    { 1480, 168, 176},
    { 1720, -64, 360},
    { 1784, -296, 440},
    { 1432, -240, 224},
    { 1160, -96, 64},
    { 1096, -88, 80},
    { 1128, -120, 128},
    { 1024, -200, 16},
    { 1032, -336, -32},
    { 880, -488, -32},
    { 1352, -632, -16},
    { 1024, -464, 8},
    { 1328, -200, -120},
    { 1448, -184, -24},
    { 1424, -152, 24},
    { 1096, -64, -16},
    { 944, -72, 96},
    { 976, 0, 80},
    { 1328, 72, 32},
    { 1448, 240, 152},
    { 1704, 592, 128},
    { 1552, 720, 256},
    // 54 seconds
    { 1440, 384, 120},
    { 1024, 288, 96},
    { 1600, 160, 256},
    { 1792, -64, 424},
    { 1632, -232, 344},
    { 1288, -168, 168},
    { 1120, -80, 96},
    { 1144, -72, 72},
    { 1144, -224, 104},
    { 1072, -312, -80},
    { 1064, -480, -16},
    { 920, -584, -96},
    { 888, -616, -48},
    { 1296, -408, 40},
    { 1376, -248, -64},
    { 1488, -152, 8},
    { 1248, -112, -56},
    { 952, -120, 120},
    { 960, 0, 64},
    { 1144, 24, 104},
    { 1360, 40, 56},
    { 1552, 176, 160},
    { 1728, 704, 200},
    { 1512, 400, 144},
    { 1104, 376, 120},
    // 55 seconds
    { 1440, 264, 216},
    { 1672, 56, 392},
    { 1688, -152, 360},
    { 1424, -152, 200},
    { 1232, -112, 144},
    { 1152, -96, 144},
    { 1160, -104, 160},
    { 1128, -232, 80},
    { 984, -328, 8},
    { 1120, -472, 16},
    { 1296, -600, 24},
    { 872, -480, 104},
    { 1056, -192, -24},
    { 1280, -184, -16},
    { 1496, -120, 72},
    { 1280, -64, 40},
    { 1000, -88, 144},
    { 968, 72, 16},
    { 1192, 72, 40},
    { 1440, 48, 96},
    { 1576, 296, 160},
    { 1616, 656, 176},
    { 1536, 216, 216},
    { 1056, 376, 72},
    { 1464, 240, 192},
    // 56 seconds
    { 1688, -8, 384},
    { 1640, -184, 352},
    { 1376, -176, 208},
    { 1200, -128, 128},
    { 1160, -112, 96},
    { 1216, -136, 176},
    { 1240, -272, 40},
    { 1000, -520, 80},
    { 1024, -392, 24},
    { 1224, -432, 128},
    { 872, -272, 128},
    { 1208, -128, -96},
    { 1280, -144, -48},
    { 1152, -80, -32},
    { 920, -48, -40},
    { 864, -32, 80},
    { 960, 24, 120},
    { 1288, 88, 56},
    { 1600, 168, 112},
    { 1752, 432, 200},
    { 1760, 400, 256},
    { 1104, 288, 104},
    { 1304, 256, 152},
    { 1488, 8, 336},
    { 1496, -144, 368},
    // 57 seconds
    { 1152, -64, 168},
    { 952, -16, 56},
    { 936, -32, 80},
    { 992, -120, 120},
    { 1040, -208, 88},
    { 1096, -312, 24},
    { 1168, -472, 56},
    { 1400, -656, 80},
    { 920, -464, 160},
    { 1224, -104, -184},
    { 1352, -144, -56},
    { 1224, -160, -32},
    { 768, -176, 8},
    { 624, -80, 0},
    { 688, 40, 24},
    { 952, 48, 24},
    { 1160, 32, 128},
    { 1496, 112, 144},
    { 1736, 448, 128},
    { 1656, 552, 112},
    { 1056, 192, -8},
    { 1552, -16, 288},
    { 1696, -96, 440},
    { 1336, -144, 304},
    { 984, -88, 40},
    // 58 seconds
    { 952, -32, 24},
    { 1024, -40, 64},
    { 1112, -184, 96},
    { 1056, -264, -8},
    { 1128, -424, 16},
    { 1224, -576, 24},
    { 960, -464, 136},
    { 1200, -184, -24},
    { 1248, -88, -56},
    { 1288, -72, -8},
    { 1056, -40, 8},
    { 776, -56, 88},
    { 744, 80, -8},
    { 904, 64, 64},
    { 1256, 32, 64},
    { 1488, 176, 152},
    { 1656, 608, 96},
    { 1736, 448, 200},
    { 992, 312, 40},
    { 1528, 112, 160},
    { 1696, -32, 368},
    { 1616, -160, 352},
    { 1200, -112, 168},
    { 976, -48, 80},
    { 944, -32, 88},
    // 59 seconds
    { 1064, -96, 320},
    { 1352, 832, 312},
    { 1568, 480, 520},
    { 1680, 920, 224},
    { 1512, 864, 128},
    { 1072, 720, -104},
    { 728, 312, -112},
    { 568, 360, -312},
    { 480, 320, -528},
    { 488, 272, -472},
    { 88, 0, -624},
    { 112, 112, -568},
    { 8, 200, -464},
    { -256, 648, -352},
    { -280, 1072, -640},
    { -232, 1232, -560},
    { -400, 1024, -720},
    { -480, 976, -488},
    { -464, 992, -136},
    { -568, 664, 48},
    { -248, 688, -448},
    { 112, 664, -608},
    { -128, 304, -280},
    { -96, 264, -200},
    { -144, 480, -624},
    // 60 seconds
    // elapsed: 1 minutes
    { -48, 784, -552},
    { -112, 1176, -336},
    { -80, 1352, -520},
    { 80, 1664, -552},
    { -208, 1336, 120},
    { -240, 1432, 168},
    { 160, 1120, -568},
    { -8, 320, -696},
    { -304, 168, -328},
    { -168, 392, -280},
    { 8, 408, -360},
    { -8, 592, -544},
    { -80, 1120, -728},
    { -112, 1056, -968},
    { -288, 1352, -1456},
    { -136, 552, -992},
    { -344, 1128, -720},
    { -616, 960, -8},
    { -336, 848, -960},
    { -144, 256, -664},
    { -256, 352, -432},
    { -192, 200, -16},
    { -456, 24, -336},
    { -192, -392, -816},
    { -144, 704, -704},
    // 61 seconds
    { -136, 96, -1224},
    { 72, 640, -976},
    { -192, 1392, -1368},
    { -24, 904, -768},
    { 368, 424, -752},
    { 496, 288, -360},
    { 368, 280, -176},
    { 368, -80, 0},
    { 384, -48, 112},
    { 352, -160, 168},
    { 432, -72, 8},
    { 32, 440, -104},
    { -624, 3232, -8},
    { -560, 1928, 8},
    { 736, 3632, 248},
    { -120, 2776, 616},
    { 208, 2160, -40},
    { 136, 1088, -32},
    { 192, 544, -80},
    { 80, 72, -136},
    { 96, -144, -184},
    { 160, -48, -216},
    { 336, 8, -168},
    { 704, -8, -72},
    { 1136, -128, 16},
    // 62 seconds
    { 1656, -104, 320},
    { 2072, 312, 360},
    { 2216, 184, 248},
    { 2088, 216, 344},
    { 1600, 288, 280},
    { 1224, 232, 256},
    { 1104, 120, 296},
    { 1184, 144, 296},
    { 1248, 272, 336},
    { 1304, 456, 264},
    { 1472, 688, 280},
    { 1656, 648, 640},
    { 1056, 712, 272},
    { 1376, 264, 256},
    { 1912, 240, 520},
    { 2088, -144, 584},
    { 1768, -240, 400},
    { 1512, -136, 256},
    { 1368, -128, 264},
    { 1312, -168, 288},
    { 1336, -216, 0},
    { 1280, -376, 80},
    { 920, -688, 48},
    { 1024, -1056, 120},
    { 856, -488, 104},
    // 63 seconds
    { 1552, -136, 56},
    { 1608, -136, 160},
    { 1664, -128, 184},
    { 1456, -96, 272},
    { 1344, -16, 328},
    { 1360, -8, 288},
    { 1536, 8, 224},
    { 1744, 64, 272},
    { 1824, 496, 456},
    { 1712, 1368, 688},
    { 1240, 496, 320},
    { 808, 472, 64},
    { 1616, 368, 464},
    { 2200, -64, 704},
    { 2080, -400, 512},
    { 1936, -320, 320},
    { 1680, -168, 296},
    { 1456, -152, 240},
    { 1432, -208, 280},
    { 1288, -296, 24},
    { 1088, -488, 16},
    { 840, -712, -64},
    { 720, -760, -16},
    { 976, -392, -56},
    { 1288, -208, -176},
    // 64 seconds
    { 1496, -208, 88},
    { 1560, -208, 232},
    { 1376, -152, 352},
    { 1344, 24, 216},
    { 1304, 136, 200},
    { 1648, 48, 144},
    { 1768, 224, 256},
    { 1776, 592, 464},
    { 1232, 336, 136},
    { 1568, 504, 304},
    { 944, 488, 176},
    { 1440, 256, 248},
    { 1744, -80, 480},
    { 1768, -288, 408},
    { 1536, -200, 224},
    { 1408, -112, 200},
    { 1296, -144, 200},
    { 1216, -184, 184},
    { 1080, -296, 72},
    { 920, -392, 48},
    { 848, -464, -16},
    { 960, -536, -88},
    { 704, -496, -48},
    { 1328, -352, 56},
    { 1368, -272, 16},
    // 65 seconds
    { 1552, -192, 80},
    { 1384, -136, 16},
    { 1240, -120, 184},
    { 1176, 56, 80},
    { 1144, 88, 144},
    { 1352, 112, 48},
    { 1424, 224, 96},
    { 1408, 392, 152},
    { 1304, 432, 192},
    { 1704, 344, 256},
    { 912, 240, 168},
    { 1552, -48, 272},
    { 1688, -160, 352},
    { 1696, -232, 280},
    { 1432, -200, 216},
    { 1144, -120, 120},
    { 1024, -120, 72},
    { 952, -192, 8},
    { 952, -280, -16},
    { 928, -320, -120},
    { 888, -360, -160},
    { 1120, -544, -72},
    { 928, -424, -72},
    { 1272, -224, -88},
    { 1424, -240, -80},
    // 66 seconds
    { 1704, -208, -8},
    { 1232, -40, -32},
    { 864, 16, 8},
    { 832, 104, 0},
    { 1160, 64, 56},
    { 1240, 240, 40},
    { 1384, 536, 168},
    { 1368, 584, 288},
    { 1128, 288, 304},
    { 1576, 240, 256},
    { 1184, 136, 192},
    { 1744, -160, 232},
    { 1800, -280, 432},
    { 1688, -312, 256},
    { 1248, -192, 136},
    { 912, -72, -48},
    { 712, -128, -112},
    { 760, -208, -96},
    { 808, -328, -240},
    { 920, -408, -272},
    { 888, -536, -224},
    { 1568, -648, 48},
    { 1264, -400, 240},
    { 1688, -96, -144},
    { 2000, -112, 112},
    // 67 seconds
    { 1448, 96, 232},
    { 808, 136, 24},
    { 776, 32, 48},
    { 904, 8, 64},
    { 1224, 96, -8},
    { 1472, 240, 48},
    { 1712, 384, 112},
    { 1520, 280, 208},
    { 888, 216, 72},
    { 1448, 80, 224},
    { 1784, -128, 448},
    { 1656, -232, 392},
    { 1480, -248, 248},
    { 1256, -144, 200},
    { 1032, -56, 112},
    { 1016, -136, 80},
    { 1192, -312, 56},
    { 1208, -464, -8},
    { 936, -472, -152},
    { 1168, -640, -224},
    { 904, -552, -56},
    { 1160, -296, -88},
    { 1304, -248, 48},
    { 1336, -232, 184},
    { 1120, -32, 32},
    // 68 seconds
    { 896, 40, -56},
    { 816, 56, 0},
    { 1016, 56, 64},
    { 1512, -56, 32},
    { 1872, 184, 32},
    { 2088, 800, 552},
    { 1360, 72, 16},
    { 1048, 304, 48},
    { 1592, 320, 216},
    { 1776, -88, 384},
    { 1640, -304, 360},
    { 1360, -224, 184},
    { 1160, -120, 104},
    { 1104, -96, 72},
    { 1168, -264, 96},
    { 1080, -392, 32},
    { 1128, -472, -48},
    { 1040, -528, -104},
    { 1120, -592, 80},
    { 1016, -280, 8},
    { 1368, -280, 64},
    { 1472, -184, 56},
    { 1224, -96, -24},
    { 952, -72, 8},
    { 904, 8, 40},
    // 69 seconds
    { 1096, -16, 96},
    { 1456, 40, 88},
    { 1696, 280, 160},
    { 1848, 624, 416},
    { 1400, 176, 176},
    { 1016, 408, 144},
    { 1336, 288, 216},
    { 1624, 56, 384},
    { 1720, -240, 496},
    { 1560, -272, 312},
    { 1224, -112, 96},
    { 1072, -24, 32},
    { 1168, -136, 136},
    { 1232, -344, 40},
    { 1144, -512, -8},
    { 992, -520, -184},
    { 1192, -688, -96},
    { 848, -432, 0},
    { 1376, -280, 48},
    { 1424, -184, 72},
    { 1320, -104, 96},
    { 1040, -80, 104},
    { 944, -40, 144},
    { 1032, -16, 80},
    { 1320, -56, 112},
    // 70 seconds
    { 1560, -16, 288},
    { 1776, 384, 256},
    { 1664, 720, 424},
    { 1104, 432, 152},
    { 1064, 336, 120},
    { 1560, 288, 368},
    { 1680, -56, 480},
    { 1448, -200, 328},
    { 1304, -160, 232},
    { 1240, -112, 184},
    { 1240, -160, 184},
    { 1264, -240, 120},
    { 1272, -480, 32},
    { 1080, -656, 40},
    { 1024, -728, -64},
    { 704, -576, 120},
    { 1432, -376, 56},
    { 1376, -248, -64},
    { 1488, -144, 32},
    { 1168, -136, 48},
    { 896, -104, 192},
    { 944, 0, 80},
    { 1032, -40, 136},
    { 1456, 96, 24},
    { 1664, 240, 232},
    // 71 seconds
    { 1768, 520, 392},
    { 1856, 704, 488},
    { 744, 512, 64},
    { 1616, 224, 232},
    { 1952, 64, 520},
    { 1920, -208, 368},
    { 1592, -304, 312},
    { 1360, -184, 240},
    { 1256, -160, 200},
    { 1192, -232, 128},
    { 1088, -328, -8},
    { 1040, -496, 0},
    { 792, -632, -168},
    { 984, -872, 24},
    { 1152, -592, 64},
    { 1568, -328, -24},
    { 1832, -224, 80},
    { 1696, -104, 40},
    { 1288, -168, 248},
    { 1192, -104, 296},
    { 1224, 24, 144},
    { 1552, 64, 144},
    { 1624, 200, 392},
    { 1912, 1080, 672},
    { 1072, 448, 168},
    // 72 seconds
    { 1424, 616, 336},
    { 1160, 312, 224},
    { 1968, 24, 440},
    { 2024, -384, 512},
    { 1920, -360, 296},
    { 1680, -240, 256},
    { 1456, -176, 208},
    { 1304, -152, 176},
    { 1152, -216, 128},
    { 1016, -384, -56},
    { 1016, -448, -208},
    { 808, -672, -176},
    { 832, -816, 56},
    { 1328, -560, 96},
    { 1424, -272, -72},
    { 1704, -256, 152},
    { 1848, -200, 168},
    { 1632, -80, 272},
    { 1440, -24, 272},
    { 1376, -8, 312},
    { 1552, -32, 264},
    { 1712, 232, 328},
    { 1880, 1104, 552},
    { 1264, 656, 224},
    { 1600, 728, 440},
    // 73 seconds
    { 1256, 240, 224},
    { 2160, -24, 480},
    { 2304, -384, 520},
    { 2224, -416, 352},
    { 1752, -232, 296},
    { 1448, -112, 160},
    { 1344, -152, 184},
    { 1304, -272, 296},
    { 1088, -400, 48},
    { 904, -416, -144},
    { 656, -600, -120},
    { 480, -544, -168},
    { 1784, -640, 240},
    { 1904, -480, 248},
    { 1656, -264, 176},
    { 1480, -184, 80},
    { 1544, 48, -104},
    { 1304, 8, 216},
    { 1184, 208, 112},
    { 1288, 216, -8},
    { 1312, 216, 16},
    { 1504, 232, 176},
    { 1544, 280, 296},
    { 1440, 424, 304},
    { 1168, 360, 152},
    // 74 seconds
    { 1648, 104, 352},
    { 1792, -192, 408},
    { 1696, -264, 280},
    { 1416, -168, 208},
    { 1256, -120, 184},
    { 1272, -184, 200},
    { 1224, -312, 48},
    { 1256, -512, 56},
    { 1152, -592, -40},
    { 1104, -640, -104},
    { 752, -672, 216},
    { 1376, -352, 80},
    { 1384, -208, -32},
    { 1392, -112, 0},
    { 1200, -192, 160},
    { 1088, -128, 200},
    { 1144, 64, 80},
    { 1376, 80, 120},
    { 1632, 256, 88},
    { 1696, 520, 200},
    { 1360, 168, 136},
    { 1584, 296, 264},
    { 920, 464, 120},
    { 1504, 232, 248},
    { 1728, -24, 432},
    // 75 seconds
    { 1736, -288, 408},
    { 1512, -272, 272},
    { 1352, -152, 200},
    { 1280, -136, 184},
    { 1296, -216, 184},
    { 1296, -344, -8},
    { 1200, -552, 88},
    { 968, -600, -56},
    { 856, -608, -48},
    { 872, -368, -104},
    { 1264, -352, -16},
    { 1424, -280, 48},
    { 1232, -176, -24},
    { 1048, -200, 144},
    { 1088, -88, 224},
    { 1272, -88, 224},
    { 1696, -72, 200},
    { 1856, 80, 344},
    { 2096, 848, 656},
    { 1416, 296, 224},
    { 1160, 320, 360},
    { 1112, 416, 312},
    { 1432, 248, 416},
    { 1640, -128, 432},
    { 1576, -208, 336},
    // 76 seconds
    { 1432, -200, 248},
    { 1288, -144, 200},
    { 1280, -184, 216},
    { 1384, -280, 160},
    { 1280, -432, 48},
    { 1000, -552, 72},
    { 960, -648, -56},
    { 840, -696, 56},
    { 928, -328, -48},
    { 1288, -272, -144},
    { 1472, -208, -64},
    { 1344, -240, 32},
    { 1088, -160, -24},
    { 1040, -80, 40},
    { 1072, -48, 8},
    { 1344, 0, -48},
    { 1544, 224, -16},
    { 1736, 608, 104},
    { 1328, 184, 152},
    { 1536, 72, 272},
    { 1008, 384, 112},
    { 1464, 152, 192},
    { 1768, -136, 456},
    { 1736, -296, 400},
    { 1440, -240, 200},
    // 77 seconds
    { 1232, -88, 72},
    { 1168, -72, 88},
    { 1160, -272, 56},
    { 1056, -360, -56},
    { 976, -512, -208},
    { 856, -600, -368},
    { 1032, -792, -184},
    { 960, -416, -168},
    { 1368, -352, -16},
    { 1528, -280, 152},
    { 1552, -216, 184},
    { 1304, -112, 168},
    { 1176, -16, 168},
    { 1104, 32, 160},
    { 1240, -96, 192},
    { 1464, -16, 152},
    { 1680, 336, 136},
    { 1560, 808, 288},
    { 1448, 240, 184},
    { 1112, 320, 136},
    { 1408, 136, 184},
    { 1648, -96, 312},
    { 1760, -200, 296},
    { 1608, -200, 208},
    { 1440, -168, 192},
    // 78 seconds
    { 1344, -160, 184},
    { 1320, -208, 152},
    { 1208, -392, 168},
    { 1072, -432, 40},
    { 936, -456, -16},
    { 1200, -624, 120},
    { 896, -432, 128},
    { 1208, -152, -160},
    { 1328, -160, 24},
    { 1320, -200, 88},
    { 1016, -192, 240},
    { 1040, -16, 168},
    { 1128, 184, 200},
    { 1352, 312, 176},
    { 1312, 488, 104},
    { 1352, 232, 96},
    { 1496, 96, 264},
    { 1752, 96, 280},
    { 984, 344, 120},
    { 1256, 240, 120},
    { 1512, 8, 280},
    { 1560, -208, 336},
    { 1336, -192, 200},
    { 1056, -80, 16},
    { 896, -72, -56},
    // 79 seconds
    { 832, -184, -64},
    { 944, -272, -104},
    { 928, -416, -120},
    { 848, -424, -152},
    { 1168, -544, -80},
    { 896, -432, 128},
    { 1360, -232, 56},
    { 1448, -248, 96},
    { 1600, -160, 176},
    { 1240, -64, 136},
    { 944, 0, 56},
    { 896, 48, 80},
    { 968, -24, 96},
    { 1208, -8, 128},
    { 1384, 168, 176},
    { 1656, 568, 288},
    { 1592, 496, 384},
    { 912, 240, 120},
    { 1384, 296, 264},
    { 1704, 96, 352},
    { 1832, -208, 440},
    { 1696, -296, 376},
    { 1392, -184, 248},
    { 1232, -168, 184},
    { 1264, -232, 200},
    // 80 seconds
    { 1320, -344, 80},
    { 1128, -480, 32},
    { 896, -576, 16},
    { 1216, -720, -8},
    { 904, -536, -40},
    { 1168, -336, -112},
    { 1336, -304, 40},
    { 1432, -248, 88},
    { 1264, -168, 128},
    { 1184, -128, 176},
    { 1224, -64, 184},
    { 1488, 8, 16},
    { 1672, 96, 152},
    { 1928, 776, 240},
    { 1336, 384, 8},
    { 1704, 352, 248},
    { 1088, 336, 136},
    { 1480, 168, 224},
    { 1768, -80, 352},
    { 1712, -320, 368},
    { 1408, -200, 152},
    { 1320, -128, 184},
    { 1344, -144, 224},
    { 1408, -320, 232},
    { 1256, -496, 208},
    // 81 seconds
    { 1184, -680, 128},
    { 992, -960, 104},
    { 640, -752, 184},
    { 1184, -400, -48},
    { 1152, -360, -32},
    { 1312, -232, -64},
    { 1160, -216, -64},
    { 1080, -208, 120},
    { 1216, -72, 128},
    { 1368, 24, 160},
    { 1632, 232, 48},
    { 1768, 672, 144},
    { 1376, 336, 16},
    { 1536, 280, 296},
    { 1248, 456, 192},
    { 1392, 280, 168},
    { 1712, -8, 336},
    { 1840, -312, 448},
    { 1752, -344, 312},
    { 1496, -200, 240},
    { 1336, -160, 208},
    { 1240, -240, 168},
    { 1064, -392, 56},
    { 1152, -480, 0},
    { 872, -848, -216},
    // 82 seconds
    { 1168, -1080, -112},
    { 800, -672, -72},
    { 1648, -416, 16},
    { 1624, -272, 88},
    { 1584, -176, 152},
    { 1400, -112, 160},
    { 1360, -80, 256},
    { 1384, 0, 240},
    { 1520, 40, 264},
    { 1776, 288, 280},
    { 1744, 856, 344},
    { 1288, 624, 192},
    { 1616, 712, 312},
    { 1080, 352, 88},
    { 1624, 144, 256},
    { 2008, -184, 456},
    { 2048, -376, 432},
    { 1872, -336, 256},
    { 1608, -224, 264},
    { 1432, -208, 232},
    { 1392, -272, 248},
    { 1200, -400, 80},
    { 1032, -616, 136},
    { 848, -648, -72},
    { 904, -792, -8},
    // 83 seconds
    { 680, -496, -168},
    { 1384, -408, 8},
    { 1576, -304, 104},
    { 1704, -200, 72},
    { 1432, -72, -32},
    { 1288, -144, 224},
    { 1392, -80, 72},
    { 1680, -40, 16},
    { 1792, 216, -24},
    { 1800, 672, 144},
    { 1424, 400, 136},
    { 1536, 544, 248},
    { 936, 520, 96},
    { 1576, 256, 272},
    { 1824, -64, 432},
    { 1896, -328, 424},
    { 1728, -312, 312},
    { 1472, -176, 144},
    { 1528, -112, 160},
    { 1336, -416, -24},
    { 1216, -632, -8},
    { 1032, -864, -160},
    { 888, -880, -312},
    { 584, -776, -32},
    { 1192, -568, 0},
    // 84 seconds
    { 1288, -400, 64},
    { 1552, -296, 120},
    { 1472, -176, 112},
    { 1312, -104, 48},
    { 1304, -104, 152},
    { 1472, 24, -96},
    { 1792, 224, 48},
    { 1632, 328, -8},
    { 1592, 376, 48},
    { 1648, 392, 88},
    { 1040, 504, -32},
    { 1384, 248, 56},
    { 1768, -8, 264},
    { 2016, -344, 408},
    { 1864, -344, 288},
    { 1504, -224, 176},
    { 1256, -160, 144},
    { 1232, -224, 80},
    { 1168, -384, 24},
    { 1072, -560, 0},
    { 856, -640, -104},
    { 1048, -768, -24},
    { 800, -544, -8},
    { 1352, -352, -80},
    { 1520, -296, 80},
    // 85 seconds
    { 1544, -216, 96},
    { 1328, -136, -32},
    { 1176, -208, 184},
    { 1248, -80, 72},
    { 1576, -96, 24},
    { 1672, 24, 128},
    { 1744, 448, 88},
    { 1416, 480, 120},
    { 1544, 408, 240},
    { 1048, 320, 120},
    { 1448, 160, 152},
    { 1712, -88, 328},
    { 1760, -280, 320},
    { 1552, -248, 168},
    { 1400, -152, 112},
    { 1368, -176, 96},
    { 1312, -288, 80},
    { 1120, -488, 8},
    { 1128, -520, -136},
    { 1104, -736, -40},
    { 816, -696, -48},
    { 1152, -416, -8},
    { 1208, -272, -152},
    { 1336, -216, -8},
    { 1168, -176, 24},
    // 86 seconds
    { 928, -136, 104},
    { 928, -8, -40},
    { 1080, -32, 32},
    { 1368, 24, -48},
    { 1840, 240, 160},
    { 1760, 832, 248},
    { 1704, 312, 240},
    { 1216, 352, 176},
    { 1384, 232, 176},
    { 1504, 40, 344},
    { 1576, -176, 376},
    { 1416, -232, 240},
    { 1240, -168, 152},
    { 1168, -120, 104},
    { 1168, -192, 32},
    { 1144, -272, -112},
    { 1072, -528, -208},
    { 888, -744, -304},
    { 1376, -920, -120},
    { 928, -504, -96},
    { 1336, -256, -32},
    { 1352, -192, 56},
    { 1368, -144, 128},
    { 1200, -144, 104},
    { 1128, -104, 176},
    // 87 seconds
    { 1128, -32, 216},
    { 1344, 48, 192},
    { 1472, 320, 160},
    { 1704, 1072, 344},
    { 1176, 352, 120},
    { 1632, 408, 416},
    { 1384, 192, 224},
    { 1544, 40, 280},
    { 1808, -192, 304},
    { 1784, -248, 320},
    { 1496, -224, 248},
    { 1288, -168, 184},
    { 1176, -160, 184},
    { 1096, -248, 160},
    { 952, -368, 8},
    { 1000, -512, 64},
    { 880, -568, -40},
    { 1192, -624, -24},
    { 976, -424, -16},
    { 1424, -304, -64},
    { 1576, -248, 24},
    { 1400, -192, -32},
    { 1128, -184, 112},
    { 1144, -40, 168},
    { 1136, 48, 88},
    // 88 seconds
    { 1448, 8, 120},
    { 1584, 192, 200},
    { 1792, 760, 424},
    { 1240, 280, 168},
    { 1288, 472, 416},
    { 1224, 448, 280},
    { 1736, 152, 464},
    { 1848, -240, 480},
    { 1688, -336, 336},
    { 1440, -232, 208},
    { 1352, -168, 184},
    { 1304, -200, 184},
    { 1136, -344, 8},
    { 1080, -464, -16},
    { 968, -584, -120},
    { 1024, -704, -168},
    { 656, -720, -56},
    { 1360, -464, 80},
    { 1424, -320, 24},
    { 1592, -216, 128},
    { 1376, -136, 112},
    { 1128, -88, 112},
    { 1128, -24, 72},
    { 1304, -64, 8},
    { 1576, -40, 80},
    // 89 seconds
    { 1816, 328, 112},
    { 1656, 848, 320},
    { 1328, 240, 160},
    { 1000, 408, 160},
    { 1400, 240, 232},
    { 1664, 8, 376},
    { 1776, -232, 392},
    { 1560, -248, 288},
    { 1384, -192, 224},
    { 1328, -160, 184},
    { 1392, -200, 224},
    { 1400, -312, 80},
    { 1272, -592, 96},
    { 928, -760, 40},
    { 1192, -936, 120},
    { 760, -464, 56},
    { 1480, -280, 16},
    { 1480, -152, -16},
    { 1384, -184, 8},
    { 1088, -216, 56},
    { 968, -184, 280},
    { 1096, -32, 200},
    { 1400, 56, 232},
    { 1792, 96, 256},
    { 1944, 608, 408},
    // 90 seconds
    { 1416, 664, 288},
    { 1008, 352, 184},
    { 1152, 416, 200},
    { 1784, 160, 504},
    { 1816, -176, 512},
    { 1608, -248, 296},
    { 1352, -192, 200},
    { 1248, -128, 176},
    { 1240, -160, 200},
    { 1288, -272, 232},
    { 1216, -392, 64},
    { 1208, -464, -24},
    { 1088, -648, -136},
    { 704, -728, 168},
    { 1416, -336, 56},
    { 1440, -256, 24},
    { 1480, -112, -72},
    { 1216, -80, -56},
    { 1080, -168, 152},
    { 1160, -72, 184},
    { 1264, -32, 264},
    { 1656, 32, 248},
    { 1904, 376, 400},
    { 1624, 1112, 488},
    { 1248, 280, 128},
    // 91 seconds
    { 1024, 448, 120},
    { 1664, 256, 440},
    { 1960, -120, 544},
    { 1840, -296, 376},
    { 1480, -232, 224},
    { 1304, -144, 144},
    { 1232, -144, 168},
    { 1336, -168, 56},
    { 1424, -272, -80},
    { 1248, -552, -72},
    { 768, -840, -8},
    { 712, -816, 40},
    { 1240, -336, -80},
    { 1344, -248, 24},
    { 1384, -184, 152},
    { 1248, -104, 136},
    { 1080, 40, -16},
    { 1088, 16, 80},
    { 1344, -96, 120},
    { 1736, -80, 256},
    { 2096, 704, 160},
    { 1424, 352, -128},
    { 1496, 232, 96},
    { 1216, 616, -16},
    { 1480, 376, 176},
    // 92 seconds
    { 1664, -32, 416},
    { 1824, -296, 400},
    { 1544, -232, 208},
    { 1344, -136, 128},
    { 1296, -104, 160},
    { 1320, -168, 184},
    { 1224, -264, -56},
    { 1128, -528, 64},
    { 928, -680, 24},
    { 1136, -872, 0},
    { 640, -680, 128},
    { 1592, -336, 136},
    { 1528, -200, 40},
    { 1464, -128, 56},
    { 1232, -128, 144},
    { 1144, -168, 328},
    { 1168, -40, 232},
    { 1368, -8, 232},
    { 1472, 128, 208},
    { 1824, 608, 352},
    { 1392, 928, 168},
    { 1744, 312, 488},
    { 1272, 424, 192},
    { 1280, 224, 160},
    { 1776, 0, 400},
    // 93 seconds
    { 1992, -312, 576},
    { 1632, -320, 296},
    { 1360, -192, 168},
    { 1216, -144, 136},
    { 1232, -232, 200},
    { 1168, -280, 232},
    { 1304, -64, 72},
    { 1072, -320, 176},
    { 864, -648, 168},
    { 712, -504, 32},
    { 1136, -296, -80},
    { 1376, -232, 80},
    { 1368, -160, 32},
    { 1240, -96, -56},
    { 1152, -104, 104},
    { 1168, -120, 208},
    { 1576, -40, 144},
    { 1880, 248, 56},
    { 2008, 624, 472},
    { 1424, 360, 264},
    { 1272, 320, 264},
    { 1088, 416, 184},
    { 1480, 304, 240},
    { 1792, -80, 456},
    { 1696, -280, 400},
    // 94 seconds
    { 1384, -264, 248},
    { 1224, -176, 192},
    { 1184, -136, 184},
    { 1200, -216, 168},
    { 1240, -320, 48},
    { 1224, -392, 32},
    { 1056, -632, 64},
    { 864, -528, 64},
    { 880, -288, 0},
    { 1000, -216, 0},
    { 1280, -200, 96},
    { 1440, -192, 112},
    { 1296, -112, 208},
    { 1168, 8, 264},
    { 1144, 56, 208},
    { 1344, 40, 112},
    { 1376, 48, 104},
    { 1456, 280, 144},
    { 1368, 552, 288},
    { 1616, 344, 168},
    { 1008, 336, 24},
    { 1304, 224, 104},
    { 1704, 0, 320},
    { 1808, -248, 424},
    { 1544, -248, 272},
    // 95 seconds
    { 1296, -176, 192},
    { 1184, -128, 120},
    { 1184, -152, 152},
    { 1144, -192, 80},
    { 1048, -312, -48},
    { 936, -432, -16},
    { 936, -656, 32},
    { 816, -536, 72},
    { 1104, -256, -40},
    { 1240, -232, 24},
    { 1528, -160, 128},
    { 1384, -104, 168},
    { 1184, -96, 208},
    { 1184, 0, 208},
    { 1208, 16, 256},
    { 1344, 32, 240},
    { 1344, 184, 192},
    { 1280, 472, 80},
    { 1496, 904, 424},
    { 1624, 568, 344},
    { 1624, 304, 128},
    { 1688, 56, 248},
    { 2168, -256, 368},
    { 2112, -392, 448},
    { 1952, -488, 432},
    // 96 seconds
    { 1592, -504, 272},
    { 1432, -408, 336},
    { 1040, -272, 272},
    { 1008, -320, 184},
    { 792, -240, 200},
    { 752, -304, 216},
    { 704, -240, 184},
    { 408, 64, -336},
    { 408, 24, -368},
    { 768, -240, -16},
    { 1384, -200, 80},
    { 2112, -112, 168},
    { 2112, 160, 184},
    { 1688, 280, -72},
    { 1344, 200, -72},
    { 1296, 96, 64},
    { 1176, 96, 32},
    { 1064, 128, 8},
    { 1064, 176, -8},
    { 1168, 224, 24},
    { 1320, 224, 16},
    { 1416, 224, 72},
    { 1592, 440, -32},
    { 1512, 256, -8},
    { 1464, 208, -88},
    // 97 seconds
    { 1248, 88, -192},
    { 1000, 56, -200},
    { 840, 8, -376},
    { 624, 0, -416},
    { 472, -8, -600},
    { 344, -32, -584},
    { 264, -96, -760},
    { 208, -192, -784},
    { 144, -200, -760},
    { 176, -192, -816},
    { 120, -296, -792},
    { 168, -280, -880},
    { 144, -288, -880},
    { 112, -336, -880},
    { 120, -352, -880},
    { 104, -384, -912},
    { 96, -424, -848},
    { 112, -328, -952},
    { 120, -456, -864},
    { 160, -424, -928},
    { 64, -432, -888},
    { 136, -400, -952},
    { 104, -440, -928},
    { 64, -456, -920},
    { 104, -448, -912},
    // 98 seconds
    { 80, -432, -944},
    { 48, -488, -896},
    { 56, -432, -896},
    { -8, -520, -896},
    { 48, -480, -848},
    { 24, -456, -920},
    { -8, -528, -896},
    { 8, -528, -904},
    { 16, -480, -904},
    { 16, -504, -896},
    { 48, -528, -904},
    { 0, -480, -880},
    { 8, -488, -912},
    { 8, -480, -904},
    { -8, -512, -896},
    { 8, -472, -912},
    { 8, -480, -912},
    { 0, -488, -928},
    { 0, -488, -888},
    { -8, -480, -872},
    { -16, -504, -904},
    { 0, -464, -904},
    { -40, -520, -896},
    { -40, -504, -880},
    { -24, -480, -872},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

