/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

// ----------------------------------------------------------------
// Sample captured: 2015-10-05 20:28:54 local
AccelRawData *activity_sample_walk_200_pbl_25675_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25675_10
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 120
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 1192, -64, -144},
    { 1224, -40, -96},
    { 1096, -64, -88},
    { 1024, -80, -64},
    { 1000, -48, -80},
    { 944, -32, -56},
    { 936, -32, -32},
    { 904, -40, -16},
    { 896, -48, -8},
    { 920, -48, -24},
    { 976, -72, -40},
    { 1088, -80, -80},
    { 1656, -64, -136},
    { 1544, -128, -224},
    { 1256, -88, -472},
    { 848, -96, -472},
    { 944, -112, -384},
    { 1112, -96, -272},
    { 1080, -64, -200},
    { 952, -16, -184},
    { 848, 8, -192},
    { 792, 24, -200},
    { 872, 72, -256},
    { 960, 0, -192},
    { 928, -72, -216},
    // 1 seconds
    { 952, -112, -280},
    { 936, -152, -496},
    { 1104, -144, -528},
    { 1120, -240, -416},
    { 1240, -208, -320},
    { 1896, -96, -280},
    { 1520, -96, -136},
    { 936, -104, -120},
    { 1080, -104, -144},
    { 1168, -176, 24},
    { 1088, -176, 152},
    { 1016, -136, 40},
    { 1104, -112, -128},
    { 1144, -24, -168},
    { 1096, -88, -120},
    { 1088, -112, -104},
    { 1008, -128, -168},
    { 904, -144, -280},
    { 848, -176, -320},
    { 880, -184, -320},
    { 888, -192, -240},
    { 936, -120, -200},
    { 1048, -16, -168},
    { 1144, 160, -216},
    { 1208, 136, -232},
    // 2 seconds
    { 1640, 136, -152},
    { 1760, 176, -208},
    { 1208, 208, -280},
    { 640, 184, -232},
    { 712, 112, -216},
    { 1064, 64, -112},
    { 1152, 56, -32},
    { 1080, 56, -64},
    { 816, 104, -200},
    { 664, 184, -376},
    { 744, 176, -456},
    { 800, 160, -480},
    { 760, 168, -608},
    { 800, 224, -632},
    { 752, 200, -632},
    { 760, 264, -648},
    { 800, 280, -592},
    { 840, 296, -520},
    { 864, 304, -448},
    { 1136, 312, -440},
    { 1264, 256, -440},
    { 1184, 216, -488},
    { 960, 112, -344},
    { 808, 48, -344},
    { 952, 72, -328},
    // 3 seconds
    { 1088, 48, -272},
    { 1064, 8, -192},
    { 1000, 0, -144},
    { 968, 8, -168},
    { 944, 32, -208},
    { 952, -8, -208},
    { 968, -16, -208},
    { 952, -48, -208},
    { 976, -64, -184},
    { 984, -64, -176},
    { 1000, -40, -176},
    { 1016, -24, -208},
    { 1472, -48, -216},
    { 1432, -40, -152},
    { 1240, 8, -168},
    { 872, 16, -232},
    { 744, 24, -232},
    { 1056, 32, -176},
    { 1120, -8, -120},
    { 1048, -8, -104},
    { 968, -8, -168},
    { 912, -8, -200},
    { 944, -24, -224},
    { 976, -56, -248},
    { 1008, -96, -264},
    // 4 seconds
    { 976, -112, -256},
    { 952, -104, -304},
    { 928, -96, -312},
    { 936, -88, -304},
    { 976, -64, -272},
    { 1008, -48, -248},
    { 1040, -56, -264},
    { 1008, -80, -256},
    { 1032, -120, -200},
    { 1120, -120, -192},
    { 1296, -136, -120},
    { 1072, -168, -112},
    { 1112, -176, 16},
    { 1064, -256, 216},
    { 1056, -320, 288},
    { 1144, -280, 312},
    { 1048, -232, 328},
    { 1160, -240, 288},
    { 1080, -216, 232},
    { 1008, -200, 224},
    { 1024, -192, 200},
    { 1032, -184, 200},
    { 1048, -176, 168},
    { 1112, -184, 176},
    { 1040, -208, 224},
    // 5 seconds
    { 1032, -232, 232},
    { 1040, -280, 248},
    { 1048, -328, 288},
    { 1048, -376, 352},
    { 1072, -384, 376},
    { 1072, -408, 392},
    { 1072, -352, 264},
    { 992, -352, 224},
    { 1000, -352, 216},
    { 984, -384, 240},
    { 1000, -376, 264},
    { 992, -376, 320},
    { 1032, -344, 312},
    { 1000, -344, 320},
    { 992, -344, 344},
    { 1016, -352, 360},
    { 1064, -344, 360},
    { 1088, -312, 328},
    { 1040, -280, 288},
    { 1024, -264, 248},
    { 1120, -264, 248},
    { 1160, -248, 304},
    { 1144, -216, 304},
    { 1128, -192, 288},
    { 1096, -200, 312},
    // 6 seconds
    { 1064, -136, 224},
    { 1040, -96, 200},
    { 1000, -144, 248},
    { 1056, -136, 232},
    { 1032, -112, 224},
    { 1088, -88, 240},
    { 1152, -104, 264},
    { 1072, -120, 256},
    { 1280, -184, 240},
    { 1184, -200, 240},
    { 992, -192, 136},
    { 864, -216, -32},
    { 832, -336, -48},
    { 976, -488, 112},
    { 896, -464, 48},
    { 896, -368, -128},
    { 1048, -400, -144},
    { 984, -432, -88},
    { 952, -392, -128},
    { 968, -312, -192},
    { 968, -296, -152},
    { 960, -248, -168},
    { 920, -208, -192},
    { 928, -168, -184},
    { 984, -120, -216},
    // 7 seconds
    { 992, -112, -208},
    { 992, -112, -216},
    { 1040, -120, -232},
    { 1128, -128, -240},
    { 1240, -168, -216},
    { 1544, -120, -296},
    { 1264, -184, -232},
    { 1032, -128, -224},
    { 848, -144, -248},
    { 992, -160, -184},
    { 1168, -120, -216},
    { 1168, -88, -152},
    { 1008, -88, -96},
    { 944, -8, -152},
    { 872, 16, -168},
    { 920, 8, -136},
    { 880, 16, -160},
    { 888, 32, -184},
    { 928, 16, -192},
    { 952, 8, -216},
    { 992, -16, -208},
    { 1088, -16, -216},
    { 1048, -16, -232},
    { 1152, -32, -272},
    { 1592, -24, -256},
    // 8 seconds
    { 1304, -88, -272},
    { 1096, -64, -288},
    { 728, -16, -344},
    { 664, 16, -320},
    { 1048, 8, -272},
    { 1280, 24, -192},
    { 1160, 32, -168},
    { 1064, 64, -184},
    { 992, 96, -184},
    { 960, 112, -168},
    { 1000, 80, -152},
    { 1008, 72, -144},
    { 968, 72, -136},
    { 960, 96, -152},
    { 960, 112, -144},
    { 936, 112, -112},
    { 952, 120, -88},
    { 1056, 128, -72},
    { 1112, 128, -80},
    { 1048, 144, -72},
    { 1040, 144, -80},
    { 1056, 112, -64},
    { 1120, 104, -56},
    { 1160, 112, -40},
    { 1120, 136, -48},
    // 9 seconds
    { 1104, 160, -80},
    { 1064, 144, -64},
    { 1072, 144, -80},
    { 1056, 136, -88},
    { 1048, 152, -80},
    { 1032, 160, -128},
    { 1040, 136, -136},
    { 1064, 120, -120},
    { 1072, 104, -136},
    { 1056, 80, -128},
    { 1016, 48, -136},
    { 984, 16, -160},
    { 1224, -24, -136},
    { 1176, -56, -80},
    { 1184, -8, -152},
    { 1032, 16, -216},
    { 880, -8, -288},
    { 1056, -40, -248},
    { 1088, -104, -200},
    { 1088, -120, -168},
    { 1056, -112, -184},
    { 1024, -96, -168},
    { 984, -112, -144},
    { 1000, -120, -136},
    { 1016, -120, -128},
    // 10 seconds
    { 1000, -112, -152},
    { 976, -88, -184},
    { 936, -72, -256},
    { 920, -72, -264},
    { 944, -56, -320},
    { 928, -8, -328},
    { 968, 40, -416},
    { 1008, 48, -424},
    { 1008, 56, -424},
    { 960, 80, -424},
    { 928, 80, -456},
    { 1208, 112, -456},
    { 1336, 120, -488},
    { 1176, 112, -400},
    { 912, 104, -360},
    { 912, 80, -328},
    { 976, 64, -256},
    { 1048, 64, -264},
    { 952, 48, -256},
    { 888, 72, -288},
    { 888, 112, -336},
    { 872, 128, -312},
    { 840, 136, -328},
    { 824, 160, -384},
    { 840, 176, -408},
    // 11 seconds
    { 808, 208, -480},
    { 800, 264, -552},
    { 768, 280, -640},
    { 720, 328, -704},
    { 688, 344, -768},
    { 648, 336, -760},
    { 648, 304, -696},
    { 696, 272, -592},
    { 720, 160, -424},
    { 1000, 176, -400},
    { 1040, 128, -288},
    { 1168, 136, -296},
    { 1016, 112, -400},
    { 936, 48, -352},
    { 1104, -24, -256},
    { 1184, -64, -120},
    { 1088, -24, -48},
    { 976, 24, -88},
    { 856, 32, -136},
    { 848, 0, -112},
    { 912, -16, -144},
    { 1008, -16, -176},
    { 1008, -24, -224},
    { 1032, -8, -288},
    { 1048, 0, -344},
    // 12 seconds
    { 1072, 24, -384},
    { 1088, 48, -440},
    { 1088, 64, -456},
    { 1136, 64, -424},
    { 1576, 80, -400},
    { 1432, 64, -328},
    { 1168, 48, -248},
    { 896, 56, -224},
    { 896, 48, -176},
    { 1168, 64, -80},
    { 1312, 32, 112},
    { 1144, 64, 152},
    { 1048, 104, 136},
    { 992, 168, 32},
    { 984, 280, 16},
    { 920, 216, -8},
    { 952, 152, 16},
    { 944, 216, -136},
    { 960, 224, -216},
    { 912, 168, -272},
    { 936, 144, -296},
    { 904, 112, -320},
    { 928, 112, -368},
    { 968, 80, -392},
    { 1344, 80, -360},
    // 13 seconds
    { 1192, 80, -352},
    { 1080, 136, -488},
    { 904, 112, -496},
    { 808, 136, -448},
    { 960, 72, -344},
    { 1160, 40, -240},
    { 1144, 40, -80},
    { 1000, 64, -64},
    { 904, 72, -88},
    { 856, 72, -80},
    { 864, 64, -80},
    { 912, 24, -88},
    { 968, 16, -128},
    { 984, 16, -208},
    { 968, -8, -312},
    { 1024, -8, -384},
    { 1080, -16, -400},
    { 1112, -8, -416},
    { 1208, -8, -480},
    { 1384, -32, -496},
    { 1272, -32, -456},
    { 1024, -40, -360},
    { 824, -16, -296},
    { 832, 32, -296},
    { 1040, 48, -280},
    // 14 seconds
    { 1336, 48, -192},
    { 1304, 64, -120},
    { 1168, 56, -96},
    { 1024, 0, -88},
    { 952, 16, -136},
    { 952, 0, -224},
    { 944, -24, -208},
    { 928, -48, -232},
    { 960, -64, -216},
    { 936, -88, -248},
    { 944, -104, -272},
    { 1024, -112, -232},
    { 1352, -104, -224},
    { 1344, -64, -248},
    { 1184, -48, -304},
    { 928, -8, -312},
    { 824, 80, -232},
    { 1080, 64, -176},
    { 1256, 64, -96},
    { 1096, 72, -72},
    { 920, 64, -120},
    { 856, 72, -160},
    { 840, 40, -208},
    { 904, 48, -216},
    { 936, 24, -264},
    // 15 seconds
    { 920, 16, -304},
    { 936, 0, -368},
    { 976, -8, -384},
    { 1000, -24, -440},
    { 1040, -40, -440},
    { 1448, -64, -488},
    { 1472, -64, -424},
    { 1168, -64, -368},
    { 1016, -32, -368},
    { 864, 0, -320},
    { 856, 8, -272},
    { 960, 16, -224},
    { 1088, 48, -120},
    { 1120, 16, -72},
    { 1056, 8, -24},
    { 1024, 16, -32},
    { 968, 48, -32},
    { 944, 40, -104},
    { 968, 72, -168},
    { 952, 40, -192},
    { 928, 24, -248},
    { 928, 0, -264},
    { 992, -16, -272},
    { 1016, -8, -280},
    { 1056, 8, -296},
    // 16 seconds
    { 1096, 0, -288},
    { 1480, -8, -304},
    { 1392, 0, -272},
    { 1208, 0, -304},
    { 984, 24, -328},
    { 688, 40, -312},
    { 712, 32, -264},
    { 952, 32, -256},
    { 1160, 24, -176},
    { 1088, 16, -152},
    { 992, 40, -192},
    { 944, 24, -192},
    { 1016, 24, -208},
    { 1072, 8, -136},
    { 1088, -8, -160},
    { 1008, 8, -152},
    { 976, 8, -152},
    { 984, 16, -144},
    { 992, 24, -136},
    { 1048, 32, -120},
    { 1120, 24, -96},
    { 1104, 40, -104},
    { 1072, 32, -128},
    { 1072, 32, -120},
    { 1080, 56, -72},
    // 17 seconds
    { 1064, 64, -32},
    { 1096, 104, -8},
    { 1160, 184, 80},
    { 1088, 160, 136},
    { 1072, 216, 56},
    { 1072, 216, 16},
    { 1112, 216, 16},
    { 1088, 136, 48},
    { 1104, 120, 32},
    { 1120, 32, 0},
    { 1088, 16, -48},
    { 1120, 24, -96},
    { 1096, 8, -56},
    { 1096, 0, -40},
    { 1104, 0, -48},
    { 1072, 0, -64},
    { 1096, 0, -104},
    { 1272, -32, -48},
    { 1072, -16, -40},
    { 1072, -8, -112},
    { 928, -8, -248},
    { 880, -16, -256},
    { 1136, -16, -192},
    { 1064, -48, -208},
    { 1024, -56, -256},
    // 18 seconds
    { 1016, -64, -264},
    { 952, -80, -296},
    { 896, -120, -304},
    { 944, -144, -280},
    { 984, -136, -240},
    { 976, -120, -232},
    { 936, -96, -216},
    { 936, -64, -256},
    { 944, -56, -224},
    { 968, -48, -216},
    { 968, -32, -240},
    { 984, -32, -256},
    { 1016, -24, -280},
    { 992, -24, -256},
    { 1112, -16, -272},
    { 1440, 32, -352},
    { 1280, 32, -256},
    { 952, 24, -200},
    { 752, 64, -296},
    { 960, 96, -328},
    { 1200, 56, -304},
    { 1320, 24, -200},
    { 1272, 0, -160},
    { 1176, -8, -144},
    { 1064, -48, -88},
    // 19 seconds
    { 1016, -24, -88},
    { 1008, 0, -88},
    { 944, -32, -144},
    { 872, -48, -176},
    { 840, -56, -184},
    { 896, -72, -160},
    { 904, -72, -160},
    { 936, -56, -184},
    { 1016, -32, -208},
    { 1312, -16, -144},
    { 1512, 32, -176},
    { 1344, 64, -280},
    { 1080, 56, -304},
    { 792, 56, -336},
    { 992, 88, -280},
    { 1176, 88, -192},
    { 1144, 80, -168},
    { 1080, 160, -224},
    { 832, 160, -232},
    { 800, 216, -344},
    { 968, 256, -368},
    { 1040, 200, -296},
    { 992, 216, -304},
    { 952, 144, -288},
    { 1024, 136, -280},
    // 20 seconds
    { 1008, 64, -280},
    { 1464, 136, -240},
    { 1336, 80, -88},
    { 1272, 160, -96},
    { 1192, 144, -32},
    { 1032, 152, -32},
    { 984, 96, -96},
    { 976, 72, -88},
    { 976, 48, -96},
    { 1024, 40, -136},
    { 1032, 40, -128},
    { 1000, 16, -216},
    { 1016, 0, -280},
    { 960, -24, -304},
    { 936, -72, -360},
    { 944, -112, -384},
    { 960, -160, -392},
    { 952, -184, -384},
    { 976, -168, -408},
    { 936, -200, -392},
    { 928, -192, -384},
    { 1160, -176, -352},
    { 1376, -144, -184},
    { 1256, -56, -216},
    { 1144, -48, -200},
    // 21 seconds
    { 816, -24, -208},
    { 680, -8, -200},
    { 912, 16, -208},
    { 1112, 8, -120},
    { 1144, -24, -48},
    { 1040, 0, -88},
    { 904, 16, -176},
    { 896, 0, -232},
    { 936, -32, -288},
    { 984, -80, -328},
    { 1016, -96, -376},
    { 1008, -112, -456},
    { 1032, -120, -488},
    { 1032, -112, -496},
    { 1048, -104, -480},
    { 1072, -80, -432},
    { 1200, -56, -424},
    { 1376, -16, -424},
    { 1272, -8, -336},
    { 1072, -16, -240},
    { 936, 24, -184},
    { 1048, 152, -176},
    { 1224, 224, -104},
    { 1176, 240, -8},
    { 1152, 272, -16},
    // 22 seconds
    { 1064, 240, -72},
    { 1048, 208, -48},
    { 1000, 200, -48},
    { 984, 56, 0},
    { 968, -152, -32},
    { 992, -240, -48},
    { 984, -400, -120},
    { 904, -336, -24},
    { 976, -496, -96},
    { 1040, -408, -176},
    { 1392, -464, -256},
    { 1200, -304, -312},
    { 1392, -328, -296},
    { 864, -144, -392},
    { 784, -336, -264},
    { 856, -312, -176},
    { 992, -208, -160},
    { 1104, -56, -144},
    { 1024, 16, -216},
    { 888, -88, -184},
    { 896, -232, -168},
    { 928, -256, -192},
    { 952, -264, -264},
    { 968, -272, -280},
    { 992, -344, -240},
    // 23 seconds
    { 1112, -352, -272},
    { 1112, -392, -336},
    { 1008, -472, -288},
    { 1024, -512, -240},
    { 1440, -944, -160},
    { 1424, -464, -384},
    { 1000, -184, -296},
    { 944, -72, -312},
    { 592, -80, -184},
    { 760, -144, -304},
    { 976, -144, -344},
    { 976, -112, -384},
    { 1096, -40, -328},
    { 992, -56, -320},
    { 888, -104, -320},
    { 904, -304, -336},
    { 952, -368, -360},
    { 1136, -544, -320},
    { 968, -320, -376},
    { 896, -424, -408},
    { 856, -432, -472},
    { 904, -360, -544},
    { 856, -240, -488},
    { 888, -144, -456},
    { 1136, -56, -424},
    // 24 seconds
    { 1440, 88, -472},
    { 1272, -128, -368},
    { 1112, -224, -272},
    { 880, -360, -200},
    { 832, -344, -120},
    { 1064, -328, -112},
    { 1072, -272, -128},
    { 1072, -176, -104},
    { 1048, -112, -144},
    { 1080, -128, -224},
    { 936, -168, -176},
    { 1032, -160, -272},
    { 1008, -184, -280},
    { 1016, -144, -304},
    { 1096, -128, -288},
    { 1024, -104, -328},
    { 936, -80, -328},
    { 816, -144, -296},
    { 856, -184, -264},
    { 1072, -152, -360},
    { 1152, -56, -464},
    { 1088, 24, -400},
    { 808, 40, -392},
    { 768, -128, -320},
    { 1168, -224, -400},
    // 25 seconds
    { 1120, -240, -256},
    { 976, -232, -184},
    { 1000, -136, -176},
    { 1192, -112, -144},
    { 1184, -104, -176},
    { 1056, -112, -176},
    { 1048, -80, -288},
    { 1008, -296, -160},
    { 1080, -312, -32},
    { 1112, 8, 0},
    { 952, 184, -200},
    { 928, 248, -224},
    { 896, 232, -216},
    { 936, 216, -168},
    { 976, 232, -88},
    { 992, 216, -120},
    { 1080, 216, -112},
    { 1224, 248, -112},
    { 1232, 296, -216},
    { 1136, 264, -240},
    { 1056, 216, -224},
    { 880, 144, -216},
    { 928, 144, -248},
    { 1008, 88, -280},
    { 1056, 56, -168},
    // 26 seconds
    { 1000, 88, -192},
    { 960, 144, -240},
    { 960, 168, -240},
    { 928, 120, -232},
    { 968, 80, -232},
    { 992, 56, -240},
    { 1008, 0, -272},
    { 1056, -32, -288},
    { 1056, -120, -232},
    { 1144, -120, -240},
    { 1264, -80, -232},
    { 1456, -40, -240},
    { 1208, -56, -176},
    { 976, -24, -256},
    { 736, -16, -248},
    { 744, -8, -144},
    { 1072, -16, -136},
    { 1112, -24, -56},
    { 1000, 0, -96},
    { 856, 8, -192},
    { 808, -8, -240},
    { 872, -48, -232},
    { 928, -88, -264},
    { 960, -120, -320},
    { 936, -112, -360},
    // 27 seconds
    { 944, -96, -416},
    { 1016, -96, -400},
    { 1080, -88, -360},
    { 1160, -32, -360},
    { 1208, 16, -360},
    { 1336, 96, -368},
    { 1232, 56, -288},
    { 1088, 64, -240},
    { 808, 40, -208},
    { 968, 48, -248},
    { 1256, -24, -152},
    { 1408, 88, -24},
    { 1208, -32, -32},
    { 1088, -56, -72},
    { 1040, -80, -16},
    { 1000, -88, -32},
    { 984, -72, -48},
    { 960, -120, -56},
    { 904, -96, -64},
    { 960, -128, -80},
    { 968, -104, -72},
    { 960, -176, -72},
    { 1448, -136, -80},
    { 1480, -48, -80},
    { 1176, -56, -176},
    // 28 seconds
    { 896, -32, -392},
    { 752, -8, -288},
    { 1048, -24, -200},
    { 1344, -48, -72},
    { 1104, -24, -48},
    { 1000, 8, -72},
    { 864, 24, -80},
    { 920, 32, -112},
    { 1008, 32, -112},
    { 1056, 48, -176},
    { 1016, 40, -264},
    { 1024, 48, -304},
    { 1088, 24, -336},
    { 1128, -40, -304},
    { 1096, -64, -224},
    { 1552, -8, -320},
    { 1296, 0, -232},
    { 1096, 8, -152},
    { 840, 16, -136},
    { 1040, 88, -168},
    { 1392, 80, -104},
    { 1376, 32, -8},
    { 1224, 8, 0},
    { 1120, -40, -8},
    { 1088, -40, 8},
    // 29 seconds
    { 1024, -40, 8},
    { 920, -40, -32},
    { 920, -40, -88},
    { 816, -48, -96},
    { 808, -80, -120},
    { 880, -80, -144},
    { 928, -104, -168},
    { 968, -112, -128},
    { 1280, -104, -88},
    { 1704, -48, -64},
    { 1392, -48, -120},
    { 1240, 0, -200},
    { 928, 72, -272},
    { 888, 104, -288},
    { 1080, 96, -216},
    { 1184, 80, -152},
    { 1136, 48, -136},
    { 1000, 48, -112},
    { 912, 56, -176},
    { 872, 48, -128},
    { 952, 40, -192},
    { 1048, 40, -192},
    { 1008, 16, -248},
    { 992, -8, -240},
    { 1048, -8, -272},
    // 30 seconds
    { 1104, -32, -248},
    { 1088, -72, -216},
    { 1104, -48, -208},
    { 1192, -48, -200},
    { 1560, 8, -248},
    { 1256, -24, -184},
    { 1048, 0, -168},
    { 840, 16, -176},
    { 1000, 64, -168},
    { 1176, 32, -120},
    { 1256, 24, -48},
    { 1048, -24, -24},
    { 984, -24, -32},
    { 960, -32, -24},
    { 936, -24, -24},
    { 928, -8, -56},
    { 904, -16, -104},
    { 912, -40, -144},
    { 912, -32, -192},
    { 944, -64, -192},
    { 992, -88, -208},
    { 1024, -80, -200},
    { 1088, -48, -216},
    { 1408, -64, -144},
    { 1736, -8, -136},
    // 31 seconds
    { 1392, 16, -144},
    { 1088, 72, -272},
    { 704, 112, -296},
    { 648, 152, -328},
    { 1000, 112, -256},
    { 1144, 40, -160},
    { 1056, 24, -136},
    { 1024, 64, -160},
    { 1032, 80, -160},
    { 1056, 72, -112},
    { 1136, 48, -32},
    { 1072, 24, 32},
    { 1040, 24, 56},
    { 1016, 32, 88},
    { 984, 32, 120},
    { 992, 40, 128},
    { 1168, 64, 144},
    { 1144, 96, 112},
    { 984, 112, 72},
    { 1064, 152, 120},
    { 1096, 200, 224},
    { 1128, 168, 296},
    { 1136, 160, 280},
    { 1112, 184, 176},
    { 1128, 256, 112},
    // 32 seconds
    { 1112, 248, 104},
    { 1128, 160, 120},
    { 1128, 80, 112},
    { 1152, 48, 96},
    { 1128, 48, 72},
    { 1104, 56, 48},
    { 1096, 48, 40},
    { 1088, 24, 24},
    { 1064, 24, 40},
    { 1064, -48, 64},
    { 1232, -56, 104},
    { 1184, -32, 56},
    { 976, -24, 16},
    { 872, 0, -80},
    { 976, 48, -248},
    { 992, 16, -96},
    { 1224, -16, -104},
    { 1088, -32, -152},
    { 984, 0, -192},
    { 1024, 16, -216},
    { 968, -48, -200},
    { 936, -96, -184},
    { 896, -136, -168},
    { 920, -136, -152},
    { 944, -104, -184},
    // 33 seconds
    { 960, -72, -200},
    { 968, -72, -216},
    { 1016, -56, -224},
    { 1088, -40, -216},
    { 1096, -32, -176},
    { 1144, 16, -168},
    { 1552, 72, -264},
    { 1248, 64, -216},
    { 1080, 48, -168},
    { 936, 48, -168},
    { 904, 40, -136},
    { 1080, 32, -96},
    { 1240, 0, -40},
    { 1136, 16, 8},
    { 1000, 0, 0},
    { 1112, 24, 0},
    { 1136, 48, 48},
    { 1080, 40, 72},
    { 1128, 40, 56},
    { 1072, 32, 72},
    { 1032, 40, 64},
    { 1016, 24, 64},
    { 1024, 8, 64},
    { 1088, 8, 16},
    { 1304, -24, 48},
    // 34 seconds
    { 1168, -56, 40},
    { 1048, -48, -72},
    { 784, -32, -272},
    { 688, -8, -288},
    { 1080, 24, -320},
    { 1320, -24, -248},
    { 1152, -48, -200},
    { 1032, -72, -248},
    { 1008, -56, -256},
    { 976, -72, -224},
    { 1032, -64, -176},
    { 1096, -56, -144},
    { 1024, 0, -152},
    { 968, 64, -168},
    { 944, 104, -168},
    { 976, 152, -184},
    { 1064, 152, -168},
    { 1264, 160, -144},
    { 1520, 248, -296},
    { 1232, 128, -296},
    { 1016, 144, -264},
    { 832, 136, -216},
    { 968, 48, -176},
    { 1104, 24, -120},
    { 1048, 8, -96},
    // 35 seconds
    { 984, -16, -184},
    { 960, -40, -184},
    { 880, -48, -208},
    { 968, -72, -248},
    { 952, -104, -216},
    { 968, -112, -216},
    { 1000, -104, -200},
    { 992, -136, -208},
    { 1024, -152, -176},
    { 1048, -152, -176},
    { 1360, -168, -200},
    { 1344, -144, -216},
    { 1232, -176, -208},
    { 944, -152, -224},
    { 784, -72, -192},
    { 1112, -24, -176},
    { 1192, -8, -96},
    { 1096, 24, -40},
    { 944, 40, -40},
    { 864, 32, -112},
    { 872, 32, -128},
    { 928, -24, -200},
    { 976, -64, -232},
    { 1000, -88, -312},
    { 1056, -88, -376},
    // 36 seconds
    { 1112, -80, -408},
    { 1104, -80, -400},
    { 1096, -64, -384},
    { 1432, -8, -416},
    { 1296, -32, -336},
    { 1072, -32, -264},
    { 840, 0, -256},
    { 1096, 24, -232},
    { 1384, -8, -136},
    { 1224, -32, -72},
    { 1088, -40, -64},
    { 1008, -32, -80},
    { 1072, 0, -80},
    { 1112, -8, -8},
    { 1056, -32, 24},
    { 976, -16, -16},
    { 912, -8, -96},
    { 848, -8, -112},
    { 880, -40, -104},
    { 960, -40, -88},
    { 1024, -64, -136},
    { 1152, -72, -128},
    { 1624, -32, -96},
    { 1400, -40, -168},
    { 1264, -24, -224},
    // 37 seconds
    { 912, 16, -352},
    { 808, 48, -440},
    { 944, 96, -432},
    { 976, 48, -392},
    { 1056, -24, -360},
    { 1040, -48, -312},
    { 976, -96, -288},
    { 960, -72, -280},
    { 944, -72, -272},
    { 968, -48, -248},
    { 992, -48, -240},
    { 984, -48, -216},
    { 984, -56, -200},
    { 976, -56, -200},
    { 1008, -56, -200},
    { 1064, -32, -184},
    { 1072, -32, -200},
    { 1152, -24, -216},
    { 1592, -16, -272},
    { 1368, -40, -200},
    { 1016, -8, -192},
    { 752, 24, -264},
    { 976, 48, -224},
    { 1184, -24, -128},
    { 1312, -16, -96},
    // 38 seconds
    { 1096, -80, -56},
    { 984, -56, -120},
    { 1016, -48, -88},
    { 944, -32, -64},
    { 984, -32, -96},
    { 1024, -40, -64},
    { 952, -24, -112},
    { 960, -16, -144},
    { 928, 0, -176},
    { 944, -8, -200},
    { 1016, 24, -184},
    { 1064, 40, -176},
    { 1112, 64, -160},
    { 1168, 48, -144},
    { 1416, 48, -152},
    { 1672, 96, -64},
    { 1320, 64, -104},
    { 1088, 96, -176},
    { 864, 128, -272},
    { 744, 64, -224},
    { 944, -8, -248},
    { 968, -96, -232},
    { 920, -160, -256},
    { 912, -216, -272},
    { 992, -272, -248},
    // 39 seconds
    { 1016, -296, -232},
    { 1096, -264, -264},
    { 1072, -216, -224},
    { 992, -160, -248},
    { 960, -120, -232},
    { 1008, -96, -224},
    { 1056, -72, -192},
    { 1064, -56, -216},
    { 1008, -40, -192},
    { 1048, -24, -200},
    { 1112, -32, -192},
    { 1088, -40, -184},
    { 1128, -64, -224},
    { 1128, -96, -176},
    { 1112, -88, -200},
    { 1112, -64, -152},
    { 1120, 16, -248},
    { 1120, -64, -200},
    { 984, 0, -200},
    { 896, -24, -208},
    { 952, 24, -168},
    { 936, 24, -136},
    { 928, 88, -176},
    { 920, 96, -176},
    { 904, 144, -216},
    // 40 seconds
    { 928, 136, -216},
    { 1008, 184, -232},
    { 992, 168, -232},
    { 976, 168, -208},
    { 1344, 192, -352},
    { 1488, 200, -344},
    { 1248, 192, -288},
    { 920, 128, -312},
    { 920, 112, -328},
    { 1112, 64, -256},
    { 976, 32, -208},
    { 944, 8, -192},
    { 968, 40, -176},
    { 1040, 88, -168},
    { 1112, 152, -144},
    { 1072, 216, -224},
    { 1048, 224, -200},
    { 1016, 224, -256},
    { 984, 200, -248},
    { 992, 184, -256},
    { 976, 168, -232},
    { 968, 184, -280},
    { 1032, 184, -320},
    { 1224, 200, -344},
    { 1072, 200, -392},
    // 41 seconds
    { 864, 168, -432},
    { 640, 136, -416},
    { 784, 112, -352},
    { 1112, 104, -336},
    { 1048, 128, -272},
    { 936, 104, -248},
    { 856, 160, -328},
    { 840, 160, -376},
    { 856, 136, -336},
    { 856, 88, -344},
    { 848, 64, -328},
    { 816, 56, -376},
    { 792, 80, -400},
    { 784, 88, -432},
    { 832, 88, -432},
    { 888, 72, -416},
    { 904, 80, -392},
    { 952, 80, -392},
    { 1064, 224, -328},
    { 1504, 288, -432},
    { 1280, 264, -400},
    { 944, 304, -272},
    { 768, 232, -328},
    { 968, 192, -256},
    { 1192, 160, -192},
    // 42 seconds
    { 1080, 104, -120},
    { 952, 88, -152},
    { 928, 88, -160},
    { 976, 80, -120},
    { 984, 72, -128},
    { 1024, 64, -136},
    { 1016, 56, -144},
    { 960, 32, -160},
    { 928, 24, -168},
    { 984, 16, -160},
    { 1016, 0, -160},
    { 1048, 24, -152},
    { 1088, 24, -160},
    { 1432, 56, -232},
    { 1480, 104, -264},
    { 1256, 128, -288},
    { 912, 104, -328},
    { 632, 120, -328},
    { 768, 152, -352},
    { 1144, 104, -264},
    { 1184, 64, -216},
    { 1032, 64, -224},
    { 920, 64, -248},
    { 912, 104, -272},
    { 944, 136, -280},
    // 43 seconds
    { 984, 120, -272},
    { 944, 136, -296},
    { 920, 144, -296},
    { 912, 136, -320},
    { 888, 144, -304},
    { 944, 128, -304},
    { 984, 120, -288},
    { 1344, 152, -304},
    { 1376, 168, -304},
    { 1112, 160, -320},
    { 920, 88, -264},
    { 816, 16, -224},
    { 984, -8, -216},
    { 1136, 0, -200},
    { 1056, 8, -176},
    { 976, 24, -168},
    { 936, 80, -240},
    { 888, 72, -264},
    { 936, 72, -272},
    { 952, 24, -232},
    { 968, 24, -224},
    { 992, 24, -200},
    { 1024, 40, -192},
    { 1040, 64, -176},
    { 1032, 72, -200},
    // 44 seconds
    { 1304, 80, -216},
    { 1280, 64, -184},
    { 1224, 64, -208},
    { 1016, 48, -264},
    { 776, 64, -272},
    { 872, 48, -288},
    { 1128, 24, -256},
    { 1184, 8, -168},
    { 1000, 8, -216},
    { 880, 32, -240},
    { 856, 32, -312},
    { 904, 24, -288},
    { 904, -40, -296},
    { 920, -40, -296},
    { 880, -88, -352},
    { 928, -80, -368},
    { 952, -48, -392},
    { 1008, -16, -360},
    { 1136, 0, -344},
    { 1496, 40, -352},
    { 1352, 64, -320},
    { 1088, 56, -296},
    { 824, 64, -272},
    { 800, 56, -288},
    { 1112, 56, -296},
    // 45 seconds
    { 1304, 40, -200},
    { 1168, -8, -120},
    { 1024, -24, -112},
    { 976, -8, -128},
    { 976, 8, -176},
    { 992, -16, -176},
    { 976, -40, -184},
    { 928, -48, -184},
    { 880, -48, -184},
    { 920, -40, -176},
    { 1008, 8, -184},
    { 1072, 48, -160},
    { 1152, 104, -128},
    { 1624, 96, -120},
    { 1592, 168, -24},
    { 1248, 192, -104},
    { 848, 176, -248},
    { 736, 168, -176},
    { 984, 128, -128},
    { 1056, 64, -40},
    { 1056, 56, -40},
    { 936, 80, -40},
    { 840, 104, -144},
    { 840, 88, -232},
    { 896, 88, -296},
    // 46 seconds
    { 936, 48, -344},
    { 920, 8, -432},
    { 936, -40, -432},
    { 976, -112, -456},
    { 1008, -136, -408},
    { 1080, -112, -400},
    { 1088, -48, -376},
    { 1096, -8, -352},
    { 1432, 16, -368},
    { 1416, 96, -344},
    { 1160, 80, -216},
    { 952, 72, -240},
    { 904, 88, -160},
    { 1072, 72, -88},
    { 1344, 56, 0},
    { 1232, 8, 112},
    { 1112, 8, 88},
    { 1040, 32, 64},
    { 1056, 24, 0},
    { 1040, -16, -16},
    { 1016, -32, 8},
    { 1064, -56, -40},
    { 1056, -72, -48},
    { 1064, -48, -80},
    { 1128, -24, -152},
    // 47 seconds
    { 1136, -40, -112},
    { 1168, -24, -112},
    { 1224, -16, -80},
    { 1224, 8, -32},
    { 1208, 32, 0},
    { 1232, 56, 48},
    { 1240, 128, 40},
    { 1168, 136, 112},
    { 1168, 144, 144},
    { 1112, 192, 96},
    { 1000, 160, -48},
    { 872, 128, -112},
    { 872, 88, -192},
    { 912, 40, -224},
    { 928, -24, -160},
    { 896, -48, -232},
    { 904, -56, -200},
    { 968, -24, -200},
    { 1016, 16, -208},
    { 1088, 72, -200},
    { 1072, 136, -200},
    { 1056, 144, -232},
    { 1312, 192, -320},
    { 1280, 192, -352},
    { 1232, 160, -344},
    // 48 seconds
    { 1064, 96, -320},
    { 920, 80, -312},
    { 1024, 48, -288},
    { 1104, 8, -216},
    { 1096, 0, -176},
    { 1072, -24, -128},
    { 1024, -40, -96},
    { 992, -24, -96},
    { 952, 0, -112},
    { 1000, 8, -160},
    { 1032, -8, -160},
    { 1064, 0, -192},
    { 1016, 8, -192},
    { 992, 8, -208},
    { 1008, 16, -232},
    { 1032, -8, -200},
    { 1096, -8, -208},
    { 1328, 8, -200},
    { 1424, 32, -168},
    { 1216, 72, -176},
    { 832, 64, -264},
    { 552, 96, -256},
    { 816, 96, -248},
    { 1248, 72, -152},
    { 1192, 64, -136},
    // 49 seconds
    { 992, 48, -168},
    { 888, 40, -192},
    { 944, 40, -216},
    { 1008, 16, -208},
    { 1016, 0, -224},
    { 976, -8, -192},
    { 920, 16, -224},
    { 1024, 96, -248},
    { 992, 80, -208},
    { 1056, 72, -184},
    { 1360, 128, -200},
    { 1248, 144, -192},
    { 1120, 192, -160},
    { 904, 216, -104},
    { 1016, 240, -32},
    { 1128, 256, 16},
    { 1136, 272, 32},
    { 1032, 240, -24},
    { 1024, 224, -48},
    { 928, 176, -80},
    { 976, 152, -88},
    { 976, 144, -160},
    { 992, 120, -192},
    { 1024, 104, -208},
    { 1056, 88, -240},
    // 50 seconds
    { 1080, 112, -264},
    { 1064, 120, -296},
    { 1328, 152, -328},
    { 1080, 112, -408},
    { 968, 72, -536},
    { 736, 80, -472},
    { 840, 144, -424},
    { 1024, 160, -360},
    { 1000, 176, -312},
    { 856, 176, -288},
    { 784, 168, -312},
    { 712, 160, -320},
    { 736, 104, -352},
    { 776, 64, -336},
    { 792, 24, -360},
    { 816, 0, -392},
    { 872, -40, -408},
    { 984, -64, -440},
    { 1096, -80, -464},
    { 1152, -56, -456},
    { 1560, -32, -416},
    { 1368, 24, -408},
    { 952, 16, -352},
    { 728, 0, -320},
    { 992, 32, -296},
    // 51 seconds
    { 1232, 16, -192},
    { 1112, -16, -120},
    { 888, -40, -72},
    { 840, 0, -104},
    { 904, 64, -152},
    { 952, 64, -168},
    { 984, 64, -184},
    { 952, 48, -224},
    { 992, 40, -224},
    { 952, 24, -224},
    { 968, 24, -264},
    { 1048, 8, -256},
    { 1104, 8, -200},
    { 1080, 0, -192},
    { 1344, 16, -192},
    { 1432, 48, -208},
    { 1160, 96, -304},
    { 712, 160, -384},
    { 552, 176, -456},
    { 992, 288, -400},
    { 1296, 328, -272},
    { 1056, 296, -200},
    { 1008, 368, -192},
    { 960, 336, -112},
    { 984, 312, -80},
    // 52 seconds
    { 976, 264, -64},
    { 896, 232, -56},
    { 904, 312, -80},
    { 824, 256, -72},
    { 848, 320, -72},
    { 904, 264, -136},
    { 896, 384, -120},
    { 960, 344, -120},
    { 952, 344, -136},
    { 928, 416, -200},
    { 1104, 368, -232},
    { 1136, 368, -216},
    { 1048, 392, -288},
    { 808, 368, -344},
    { 824, 384, -352},
    { 1080, 336, -288},
    { 968, 304, -232},
    { 832, 336, -248},
    { 848, 336, -272},
    { 856, 304, -288},
    { 888, 296, -264},
    { 928, 288, -264},
    { 952, 296, -272},
    { 896, 288, -248},
    { 952, 272, -216},
    // 53 seconds
    { 928, 280, -192},
    { 960, 304, -208},
    { 968, 304, -216},
    { 992, 296, -216},
    { 1368, 288, -192},
    { 1000, 216, -152},
    { 792, 272, -216},
    { 560, 296, -312},
    { 600, 280, -288},
    { 1016, 288, -336},
    { 1120, 248, -336},
    { 1000, 200, -408},
    { 928, 216, -416},
    { 840, 152, -400},
    { 904, 104, -376},
    { 896, 88, -400},
    { 928, 80, -296},
    { 912, 40, -344},
    { 936, 88, -312},
    { 952, 88, -328},
    { 984, 104, -304},
    { 1008, 112, -312},
    { 1056, 96, -280},
    { 1064, 72, -256},
    { 1608, 48, -256},
    // 54 seconds
    { 1360, 32, -208},
    { 1000, -56, -136},
    { 856, -96, -160},
    { 1024, -128, -104},
    { 1224, -144, -8},
    { 1064, -160, 64},
    { 1032, -120, 40},
    { 1080, -64, 16},
    { 1048, -16, 8},
    { 1064, 16, -72},
    { 1224, 0, -48},
    { 1080, -24, -16},
    { 1152, -16, -64},
    { 1072, -16, -80},
    { 1024, -40, -168},
    { 1064, -80, -144},
    { 1144, -96, -56},
    { 1128, -112, -16},
    { 1048, -96, 40},
    { 1088, -40, 32},
    { 1144, 32, -8},
    { 1144, 40, -64},
    { 1120, 56, -112},
    { 1064, 40, -136},
    { 1072, 24, -80},
    // 55 seconds
    { 1088, 64, -48},
    { 1072, 48, -40},
    { 1032, 96, -32},
    { 976, 96, -40},
    { 968, 112, -64},
    { 960, 104, -128},
    { 864, 144, -184},
    { 872, 128, -288},
    { 976, 128, -280},
    { 1008, 120, -256},
    { 968, 136, -264},
    { 1208, 112, -416},
    { 1616, 224, -480},
    { 1248, 160, -344},
    { 792, 112, -392},
    { 1024, 136, -416},
    { 1264, 72, -264},
    { 1064, 24, -184},
    { 896, -8, -152},
    { 880, 0, -152},
    { 944, -16, -104},
    { 1016, -8, -96},
    { 1000, -16, -96},
    { 1072, -8, -112},
    { 1080, 8, -168},
    // 56 seconds
    { 1008, 16, -168},
    { 928, 0, -216},
    { 976, -8, -264},
    { 1056, -8, -256},
    { 1104, -24, -224},
    { 1216, -32, -216},
    { 1488, 16, -176},
    { 1304, 0, -152},
    { 1064, -16, -176},
    { 728, -48, -200},
    { 792, -120, -176},
    { 1128, -96, -80},
    { 1040, -120, -48},
    { 944, -80, -88},
    { 904, -72, -128},
    { 896, -104, -104},
    { 1016, -96, -72},
    { 1024, -88, -80},
    { 1000, -40, -168},
    { 976, -88, -200},
    { 952, -88, -248},
    { 992, -104, -280},
    { 1064, -96, -248},
    { 1144, -24, -208},
    { 1240, -32, -112},
    // 57 seconds
    { 1248, -152, -80},
    { 1264, -208, 152},
    { 1328, -160, 136},
    { 1352, -64, 96},
    { 1104, -192, 216},
    { 992, -352, 24},
    { 832, -288, 320},
    { 1008, -184, 336},
    { 1104, -224, 440},
    { 1008, -280, 312},
    { 1032, -360, 432},
    { 880, -152, 320},
    { 936, -32, 280},
    { 912, -16, 144},
    { 992, -64, 104},
    { 1024, -32, 56},
    { 1048, -48, 56},
    { 1112, -40, 40},
    { 1192, -16, 0},
    { 1224, 0, -24},
    { 1208, 8, -40},
    { 1672, 40, -128},
    { 1304, 72, -64},
    { 968, 0, -72},
    { 744, -32, -88},
    // 58 seconds
    { 976, -48, 8},
    { 1256, 72, 32},
    { 1200, 96, 8},
    { 1200, 200, -48},
    { 976, 184, -40},
    { 864, 216, -128},
    { 888, 232, -208},
    { 872, 240, -152},
    { 840, 200, -304},
    { 824, 232, -376},
    { 832, 208, -440},
    { 832, 176, -472},
    { 832, 160, -536},
    { 832, 152, -544},
    { 1088, 216, -584},
    { 1112, 272, -648},
    { 872, 168, -528},
    { 704, 168, -416},
    { 808, 208, -464},
    { 968, 264, -456},
    { 944, 248, -416},
    { 880, 216, -440},
    { 832, 256, -440},
    { 752, 184, -376},
    { 728, 168, -432},
    // 59 seconds
    { 760, 160, -464},
    { 704, 136, -408},
    { 760, 136, -424},
    { 808, 176, -408},
    { 864, 176, -400},
    { 912, 208, -376},
    { 1064, 200, -328},
    { 1208, 176, -304},
    { 1096, 152, -296},
    { 944, 104, -296},
    { 792, 96, -216},
    { 1016, 136, -184},
    { 1248, 120, -168},
    { 1208, 72, -120},
    { 1048, 32, -112},
    { 960, 80, -184},
    { 952, 64, -232},
    { 1032, 24, -200},
    { 1080, 8, -256},
    { 1056, -16, -256},
    { 1032, -16, -304},
    { 1056, 0, -304},
    { 1080, -16, -288},
    { 1088, 0, -264},
    { 1080, 16, -248},
    // 60 seconds
    // elapsed: 1 minutes
    { 1136, 8, -216},
    { 1288, 16, -232},
    { 1264, -24, -192},
    { 1152, -48, -192},
    { 1008, -48, -176},
    { 960, -8, -208},
    { 1136, -32, -176},
    { 1352, -32, -160},
    { 1312, -56, -96},
    { 1144, -64, -88},
    { 1040, -48, -88},
    { 992, -40, -96},
    { 960, -40, -96},
    { 928, -40, -120},
    { 872, -64, -208},
    { 824, -80, -264},
    { 864, -112, -264},
    { 912, -144, -208},
    { 1024, -144, -176},
    { 1096, -112, -184},
    { 1360, -128, -72},
    { 1688, 32, 8},
    { 1456, 96, -32},
    { 1096, 72, -160},
    { 832, 104, -136},
    // 61 seconds
    { 848, 104, -88},
    { 1216, 80, -48},
    { 1176, 24, 24},
    { 1064, 32, 24},
    { 856, 24, -32},
    { 856, 88, -72},
    { 928, 88, -152},
    { 960, 32, -152},
    { 1000, 16, -224},
    { 952, -8, -272},
    { 984, -24, -312},
    { 1032, -48, -352},
    { 1088, -72, -376},
    { 1088, -96, -344},
    { 1112, -72, -344},
    { 1160, -56, -320},
    { 1408, -8, -352},
    { 1304, -16, -272},
    { 1136, -16, -240},
    { 968, 8, -240},
    { 880, 8, -176},
    { 1040, 0, -144},
    { 1200, 0, -56},
    { 1320, -8, -16},
    { 1192, -40, 40},
    // 62 seconds
    { 1128, -48, 32},
    { 1016, -48, 16},
    { 976, -40, -48},
    { 984, -8, -32},
    { 896, -8, -56},
    { 944, 16, -128},
    { 912, 16, -136},
    { 968, 48, -176},
    { 984, 72, -192},
    { 1000, 144, -224},
    { 1016, 216, -280},
    { 1048, 248, -264},
    { 1104, 280, -248},
    { 1112, 248, -208},
    { 1160, 216, -168},
    { 1088, 208, -120},
    { 1072, 176, -104},
    { 1072, 168, -88},
    { 1104, 136, -88},
    { 1344, 56, -40},
    { 1840, 80, 8},
    { 992, -24, -8},
    { 776, -184, -176},
    { 952, -192, -200},
    { 960, -320, -112},
    // 63 seconds
    { 912, -448, -16},
    { 864, -456, -88},
    { 936, -464, -48},
    { 1000, -528, 0},
    { 968, -480, 8},
    { 936, -464, -24},
    { 888, -440, -16},
    { 928, -424, 16},
    { 936, -400, 16},
    { 1080, -416, 48},
    { 1064, -360, 32},
    { 1064, -336, -64},
    { 1088, -352, -96},
    { 1056, -360, -160},
    { 1016, -360, -176},
    { 1120, -336, -200},
    { 1160, -256, -248},
    { 1016, -248, -344},
    { 944, -232, -352},
    { 968, -208, -312},
    { 952, -144, -328},
    { 952, -80, -344},
    { 928, -56, -344},
    { 864, -80, -384},
    { 832, -64, -448},
    // 64 seconds
    { 840, -88, -488},
    { 856, -136, -488},
    { 864, -160, -464},
    { 848, -160, -440},
    { 840, -112, -416},
    { 856, -64, -368},
    { 832, -16, -264},
    { 1304, 48, -288},
    { 1272, 80, -296},
    { 1136, 56, -200},
    { 1344, 88, -152},
    { 1320, 176, -120},
    { 1008, 32, -88},
    { 848, 24, -160},
    { 912, 48, -192},
    { 1024, 16, -152},
    { 1064, 16, -128},
    { 1048, 8, -168},
    { 1088, 32, -184},
    { 1056, 32, -200},
    { 1008, 56, -224},
    { 936, 56, -256},
    { 928, 56, -256},
    { 952, 56, -216},
    { 992, 64, -176},
    // 65 seconds
    { 1048, 80, -168},
    { 1064, 88, -160},
    { 1112, 80, -176},
    { 1504, 48, -160},
    { 1392, 24, -88},
    { 1128, 40, -176},
    { 792, 48, -264},
    { 696, 32, -232},
    { 1016, 48, -192},
    { 1080, -32, -144},
    { 1104, -48, -128},
    { 992, -16, -160},
    { 888, -16, -200},
    { 848, -88, -184},
    { 904, -112, -200},
    { 968, -112, -232},
    { 960, -104, -248},
    { 992, -80, -280},
    { 976, -64, -280},
    { 1024, -72, -264},
    { 1040, -64, -256},
    { 1048, -48, -248},
    { 1208, -32, -240},
    { 1424, 8, -256},
    { 1368, -8, -200},
    // 66 seconds
    { 1128, -8, -160},
    { 880, 24, -184},
    { 968, 48, -192},
    { 1152, 8, -136},
    { 1184, -24, -80},
    { 1088, -40, -64},
    { 1072, -56, -48},
    { 992, -40, -24},
    { 952, -8, -48},
    { 960, -8, -64},
    { 936, -24, -48},
    { 952, -48, -40},
    { 968, -48, -48},
    { 1008, -40, -72},
    { 1096, -56, -96},
    { 1128, -80, -112},
    { 1464, -56, -160},
    { 1312, -64, -144},
    { 1112, -32, -224},
    { 784, -16, -264},
    { 752, 0, -240},
    { 1064, 8, -184},
    { 1184, -24, -144},
    { 1088, -24, -112},
    { 952, 16, -144},
    // 67 seconds
    { 872, 24, -184},
    { 888, 8, -184},
    { 1008, -24, -208},
    { 1040, -40, -216},
    { 1032, -32, -248},
    { 1024, -16, -288},
    { 1056, -16, -304},
    { 1056, -48, -288},
    { 1128, -32, -256},
    { 1576, 8, -352},
    { 1368, -24, -208},
    { 1008, -8, -152},
    { 784, 32, -176},
    { 1016, 80, -192},
    { 1288, 48, -96},
    { 1312, 24, -40},
    { 1144, -24, 8},
    { 1048, -56, 24},
    { 992, -40, 32},
    { 952, 8, 32},
    { 960, 48, -8},
    { 912, 0, -48},
    { 912, -8, -40},
    { 944, -24, -56},
    { 984, -40, -64},
    // 68 seconds
    { 1024, -56, -96},
    { 1304, -72, -104},
    { 1464, -40, -128},
    { 1264, -16, -200},
    { 1056, 32, -336},
    { 784, 16, -344},
    { 984, 0, -312},
    { 1280, -40, -200},
    { 1176, -80, -120},
    { 1000, -24, -112},
    { 904, 24, -120},
    { 880, 56, -160},
    { 928, 56, -144},
    { 984, 0, -152},
    { 1016, -8, -176},
    { 1008, -40, -160},
    { 1032, -24, -216},
    { 1104, -8, -240},
    { 1112, -32, -200},
    { 1296, -40, -192},
    { 1512, 8, -264},
    { 1184, 16, -184},
    { 912, 16, -128},
    { 792, 32, -144},
    { 1080, 80, -176},
    // 69 seconds
    { 1368, 88, -120},
    { 1336, 32, -32},
    { 1136, -24, 8},
    { 1024, -40, 8},
    { 952, -40, 24},
    { 928, -16, -8},
    { 936, -8, -24},
    { 952, -32, -16},
    { 928, -48, -24},
    { 936, -72, -56},
    { 984, -48, -104},
    { 1136, -72, -96},
    { 1536, -32, -152},
    { 1376, -88, -176},
    { 1160, -16, -256},
    { 952, -72, -296},
    { 944, 64, -208},
    { 1248, 88, -168},
    { 1104, 160, -280},
    { 920, 192, -272},
    { 832, 120, -344},
    { 728, 256, -408},
    { 808, 144, -440},
    { 800, -72, -488},
    { 752, -24, -456},
    // 70 seconds
    { 760, 96, -456},
    { 728, 128, -448},
    { 920, 232, -576},
    { 1008, -56, -368},
    { 1048, -168, -496},
    { 1104, 56, -648},
    { 1160, 112, -520},
    { 1232, 64, -304},
    { 1176, 88, -200},
    { 1016, 328, -232},
    { 872, 24, 48},
    { 1048, -144, 152},
    { 1200, -112, 216},
    { 1208, -152, 216},
    { 1080, -56, 72},
    { 1096, -8, 0},
    { 1168, -40, 8},
    { 1144, 0, 32},
    { 1152, 144, -8},
    { 1176, 192, -40},
    { 1176, 200, 64},
    { 1280, 184, 120},
    { 1176, 160, 136},
    { 976, 160, 96},
    { 904, 128, 32},
    // 71 seconds
    { 968, 56, -144},
    { 1248, -760, -824},
    { 1088, 40, -256},
    { 968, 40, -256},
    { 1032, 120, -136},
    { 904, 72, -80},
    { 896, 8, -72},
    { 912, -88, -152},
    { 920, 0, -304},
    { 872, 32, -344},
    { 912, 144, -408},
    { 920, 40, -440},
    { 952, 24, -360},
    { 1008, -32, -376},
    { 1032, -104, -432},
    { 1168, -152, -552},
    { 1376, 8, -536},
    { 1208, 128, -296},
    { 1024, 152, -136},
    { 880, 8, -32},
    { 1128, 48, 32},
    { 1184, 32, 112},
    { 1032, 8, 160},
    { 896, 16, 176},
    { 952, 40, 192},
    // 72 seconds
    { 960, 88, 192},
    { 1024, 64, 152},
    { 1080, 72, 72},
    { 1112, 88, 8},
    { 1072, 120, -56},
    { 1072, 112, -32},
    { 1080, 192, -128},
    { 1064, 208, -144},
    { 1056, 184, -144},
    { 1064, 184, -128},
    { 1064, 160, -128},
    { 1088, 168, -176},
    { 1464, 216, -120},
    { 1352, 288, -208},
    { 1016, 344, -248},
    { 728, 128, -240},
    { 768, -56, -232},
    { 1120, -88, -40},
    { 1304, -112, 88},
    { 1256, -144, 192},
    { 1040, -64, 144},
    { 904, 32, 48},
    { 888, 120, -32},
    { 904, 224, -136},
    { 960, 192, -176},
    // 73 seconds
    { 944, 120, -216},
    { 936, 24, -160},
    { 920, -8, -176},
    { 944, 48, -216},
    { 976, 128, -248},
    { 1016, 264, -264},
    { 1056, 288, -232},
    { 1128, 208, -240},
    { 1616, -80, -312},
    { 1296, 24, -264},
    { 928, 304, -232},
    { 768, -16, -40},
    { 888, -16, -8},
    { 1232, -56, 56},
    { 1088, 56, 24},
    { 1008, 48, 32},
    { 1024, 80, -32},
    { 968, 56, -16},
    { 976, -24, 72},
    { 1008, -32, 64},
    { 1024, -32, 8},
    { 1048, -40, -8},
    { 1080, -40, -32},
    { 1112, -32, -88},
    { 1104, 0, -160},
    // 74 seconds
    { 1320, 64, -216},
    { 1656, 136, -224},
    { 1152, 40, -224},
    { 728, -16, -288},
    { 704, -72, -144},
    { 1056, -136, 8},
    { 1232, -176, 168},
    { 968, -256, 192},
    { 936, -184, 88},
    { 936, -96, -216},
    { 936, -80, -352},
    { 896, 0, -312},
    { 904, 160, -232},
    { 880, 160, -192},
    { 912, 160, -184},
    { 1032, 168, -264},
    { 1128, 240, -376},
    { 1112, 296, -432},
    { 1440, 216, -472},
    { 1440, -240, -368},
    { 1136, 120, -240},
    { 872, 168, -248},
    { 832, 112, -72},
    { 1248, 0, 128},
    { 1192, 40, 280},
    // 75 seconds
    { 1024, -40, 288},
    { 912, 32, 208},
    { 928, 40, 128},
    { 976, 56, 128},
    { 1016, 16, 104},
    { 1064, 80, 8},
    { 1104, 120, -56},
    { 1088, 120, -80},
    { 1080, 88, -88},
    { 1104, 80, -128},
    { 1096, 64, -144},
    { 1032, 88, -136},
    { 1280, 152, -112},
    { 1408, 200, -56},
    { 1248, 128, -56},
    { 944, 72, -96},
    { 736, -40, -184},
    { 1048, -72, -184},
    { 1280, -536, -152},
    { 1168, -536, -200},
    { 984, -312, 0},
    { 904, -24, 16},
    { 936, 8, -16},
    { 920, 48, -40},
    { 952, 80, 24},
    // 76 seconds
    { 952, 176, -64},
    { 936, 200, -160},
    { 928, 168, -280},
    { 976, 16, -400},
    { 1024, 160, -504},
    { 1112, 336, -504},
    { 1128, 192, -328},
    { 1096, -32, -280},
    { 1408, -112, -336},
    { 1400, -208, -216},
    { 1072, 112, -72},
    { 912, 112, -80},
    { 848, -24, 32},
    { 1080, -8, 48},
    { 1144, -24, 168},
    { 936, -40, 168},
    { 952, 32, 72},
    { 968, 64, 0},
    { 992, 64, 0},
    { 1040, 72, -32},
    { 1104, 48, -80},
    { 1080, 80, -128},
    { 1040, 48, -120},
    { 1040, 16, -112},
    { 1032, 48, -112},
    // 77 seconds
    { 1040, 88, -104},
    { 1064, 168, -72},
    { 1032, 248, -120},
    { 1040, 328, -112},
    { 1208, 352, -64},
    { 1368, 368, -144},
    { 1024, 320, -168},
    { 1048, 120, -328},
    { 744, -416, -264},
    { 984, -160, -336},
    { 1264, -240, -120},
    { 1232, -32, 0},
    { 1112, 8, 24},
    { 984, 72, 56},
    { 904, 96, 0},
    { 944, 72, -48},
    { 936, 8, -152},
    { 960, 192, -176},
    { 928, 200, -120},
    { 928, 128, -152},
    { 944, 192, -272},
    { 944, 104, -256},
    { 976, 208, -288},
    { 1008, 312, -320},
    { 1008, 320, -296},
    // 78 seconds
    { 1040, 216, -320},
    { 1456, -24, -376},
    { 1400, -56, -152},
    { 1096, 440, -304},
    { 752, 88, -48},
    { 872, -16, 48},
    { 1144, -16, 72},
    { 1160, 96, 104},
    { 984, 40, 144},
    { 968, 48, 80},
    { 992, 24, 24},
    { 1024, 16, 40},
    { 1056, 24, -8},
    { 1032, 40, -88},
    { 1032, 88, -120},
    { 1024, 40, -80},
    { 1016, 24, -72},
    { 960, 32, -104},
    { 1000, 120, -120},
    { 1016, 168, -160},
    { 1072, 224, -168},
    { 1104, 288, -200},
    { 1392, 320, -224},
    { 1424, 288, -144},
    { 1000, 248, -152},
    // 79 seconds
    { 816, 112, -240},
    { 840, -56, -280},
    { 1248, 0, -72},
    { 1216, -176, -48},
    { 1208, -120, -32},
    { 1088, -112, 24},
    { 920, -48, 40},
    { 824, 176, -88},
    { 912, 272, -216},
    { 904, 200, -200},
    { 880, 136, -128},
    { 888, 128, -128},
    { 872, 120, -152},
    { 888, 96, -168},
    { 912, 128, -192},
    { 1064, 112, -264},
    { 1152, 336, -336},
    { 1600, 376, -384},
    { 1328, 336, -376},
    { 1136, 24, -272},
    { 832, 16, -176},
    { 896, -72, -72},
    { 1080, -48, -56},
    { 1128, 24, 88},
    { 1072, 16, 208},
    // 80 seconds
    { 1048, 56, 216},
    { 992, -16, 144},
    { 968, 32, 40},
    { 1000, 56, -16},
    { 1024, 104, -88},
    { 1024, 136, -176},
    { 992, 136, -216},
    { 1024, 144, -224},
    { 1040, 128, -256},
    { 1048, 112, -272},
    { 1024, 104, -256},
    { 1024, 104, -248},
    { 1392, 136, -232},
    { 1368, 160, -160},
    { 1208, 144, -176},
    { 952, 88, -232},
    { 760, -8, -184},
    { 944, -56, -72},
    { 1232, -136, 128},
    { 1152, -64, 128},
    { 1056, -48, 88},
    { 992, -48, -16},
    { 976, -24, -72},
    { 1024, 16, -128},
    { 1008, 120, -192},
    // 81 seconds
    { 1048, 216, -184},
    { 1032, 288, -176},
    { 1016, 184, -128},
    { 1000, 136, -120},
    { 1024, 144, -80},
    { 1008, 160, -48},
    { 992, 144, -32},
    { 1064, 120, -16},
    { 1096, 72, 16},
    { 1104, 64, -8},
    { 1088, 72, 40},
    { 1064, 56, 48},
    { 1032, 64, 40},
    { 1016, 144, 40},
    { 992, 192, 16},
    { 1000, 184, 0},
    { 1056, 216, -40},
    { 1056, 264, -56},
    { 1056, 256, -16},
    { 1040, 200, -16},
    { 1032, 152, 0},
    { 1024, 160, -8},
    { 1048, 136, -16},
    { 1072, 136, 8},
    { 1088, 128, 16},
    // 82 seconds
    { 1080, 160, -40},
    { 1040, 192, -64},
    { 1008, 208, -64},
    { 1024, 200, -32},
    { 992, 184, -8},
    { 1000, 176, 8},
    { 1048, 168, 24},
    { 1032, 176, -24},
    { 960, 200, -56},
    { 1208, 224, -56},
    { 1080, 232, -16},
    { 1104, 192, -64},
    { 1152, 200, -192},
    { 944, 112, -176},
    { 984, -8, -88},
    { 1160, -112, -56},
    { 1128, -248, -56},
    { 1080, -216, -48},
    { 1072, -136, 8},
    { 1040, -72, -40},
    { 1008, -56, -48},
    { 992, 112, -104},
    { 992, 152, -144},
    { 936, 176, -200},
    { 912, 200, -264},
    // 83 seconds
    { 880, 72, -248},
    { 896, 32, -256},
    { 936, 56, -240},
    { 976, 136, -272},
    { 1016, 264, -264},
    { 1024, 272, -272},
    { 1168, 120, -360},
    { 1480, 48, -432},
    { 1264, 120, -152},
    { 992, 368, -192},
    { 800, 32, -24},
    { 880, -24, 8},
    { 1096, 48, 32},
    { 1112, 152, 96},
    { 1000, 216, 64},
    { 952, 264, -56},
    { 976, 224, -128},
    { 960, 120, 16},
    { 984, 112, -64},
    { 944, 64, -176},
    { 1000, 56, -168},
    { 984, 160, -136},
    { 1032, 184, -56},
    { 1024, 200, -56},
    { 1088, -8, 128},
    // 84 seconds
    { 1032, 96, -104},
    { 1176, 424, 24},
    { 1112, 608, -176},
    { 1280, -400, 1960},
    { 1000, 1304, -424},
    { 1216, 736, -144},
    { 680, 184, -296},
    { 632, -40, -272},
    { 1656, -216, -200},
    { 1152, -320, -16},
    { 1296, -344, 96},
    { 1040, -360, 112},
    { 1112, -240, 112},
    { 888, -160, 96},
    { 896, 24, -80},
    { 896, 200, -216},
    { 840, 280, -208},
    { 800, 176, -144},
    { 800, 224, -184},
    { 880, 224, -232},
    { 936, 224, -248},
    { 1048, 72, -288},
    { 1088, 176, -320},
    { 1144, 344, -448},
    { 1640, 136, -472},
    // 85 seconds
    { 1504, -40, -88},
    { 944, 176, -8},
    { 824, 64, -8},
    { 928, 8, 72},
    { 1080, 80, 200},
    { 920, 80, 256},
    { 936, 128, 192},
    { 1024, 256, 56},
    { 1000, 184, 8},
    { 1000, 112, 24},
    { 968, 88, -16},
    { 1088, 128, -112},
    { 1096, 96, -112},
    { 1096, 64, -72},
    { 1096, 56, -40},
    { 1096, 56, -32},
    { 1112, 96, -8},
    { 1512, 280, -56},
    { 1232, 496, -96},
    { 848, 400, -152},
    { 664, 136, -224},
    { 1000, -24, -160},
    { 1472, -496, -328},
    { 1072, -264, 24},
    { 1040, -16, 56},
    // 86 seconds
    { 960, 176, -80},
    { 888, 216, -80},
    { 904, 56, 56},
    { 936, -64, 48},
    { 960, 32, -72},
    { 968, 104, -72},
    { 1008, 88, -88},
    { 1096, 96, -168},
    { 1112, 312, -296},
    { 1184, 280, -392},
    { 1496, 144, -496},
    { 1256, 192, -280},
    { 928, 240, -120},
    { 728, -136, 40},
    { 1064, 32, 104},
    { 1312, 24, 320},
    { 1040, 40, 376},
    { 968, -24, 320},
    { 960, 16, 200},
    { 912, -56, 192},
    { 1000, -16, 112},
    { 1088, 24, 8},
    { 1088, 96, -88},
    { 1096, 104, -136},
    { 1120, 112, -152},
    // 87 seconds
    { 1096, 88, -184},
    { 1088, 72, -160},
    { 1552, 80, -168},
    { 1256, 16, -40},
    { 1000, 16, -80},
    { 864, -48, -192},
    { 928, -48, -112},
    { 1056, -152, 56},
    { 1168, -312, 120},
    { 1168, -528, 128},
    { 976, -392, -104},
    { 848, -56, -128},
    { 944, 16, -80},
    { 952, 152, -72},
    { 936, 216, -40},
    { 920, 216, -40},
    { 896, 232, -160},
    { 936, 192, -216},
    { 1056, 176, -216},
    { 1112, 176, -344},
    { 1328, 224, -560},
    { 1728, -40, -800},
    { 1328, 192, -176},
    { 888, 120, -88},
    { 792, 8, -56},
    // 88 seconds
    { 880, -16, 88},
    { 1152, 8, 192},
    { 1160, 128, 240},
    { 1008, 40, 224},
    { 968, 80, 136},
    { 968, 96, 72},
    { 1000, 48, 56},
    { 1016, 48, 48},
    { 1064, 32, 8},
    { 1072, 32, -40},
    { 1072, 32, -64},
    { 1080, 48, -80},
    { 1080, 72, -96},
    { 1088, 120, -128},
    { 1144, 160, -104},
    { 1432, 168, -136},
    { 1120, 184, -96},
    { 1040, 232, -168},
    { 928, 168, -200},
    { 848, 32, -88},
    { 976, -104, 16},
    { 1144, -112, 104},
    { 1176, -64, 120},
    { 1160, -216, 168},
    { 1032, -304, 192},
    // 89 seconds
    { 952, -200, -8},
    { 960, 160, -168},
    { 960, 304, -168},
    { 992, 352, -160},
    { 960, 296, -152},
    { 888, 264, -128},
    { 960, 152, -184},
    { 1032, 104, -280},
    { 1048, 184, -248},
    { 1048, 128, -176},
    { 1048, 152, -136},
    { 1080, 120, -56},
    { 1464, 112, -112},
    { 1288, -72, -40},
    { 1080, 168, 24},
    { 944, 120, 96},
    { 856, -112, 184},
    { 1000, -24, 208},
    { 1040, 88, 248},
    { 1112, 160, 216},
    { 1056, 192, 200},
    { 1016, 88, 192},
    { 992, 32, 144},
    { 1080, -24, 120},
    { 1136, 16, 160},
    // 90 seconds
    { 1152, 104, 192},
    { 1120, 96, 216},
    { 1080, 96, 192},
    { 1072, 120, 208},
    { 1096, 104, 216},
    { 1080, 96, 184},
    { 1104, 128, 168},
    { 1160, 160, 152},
    { 1112, 168, 152},
    { 928, 208, 112},
    { 936, 144, 96},
    { 1024, 96, 88},
    { 1104, 80, -8},
    { 1128, 40, -120},
    { 1072, -224, -608},
    { 1088, 112, -376},
    { 880, 112, -176},
    { 944, 152, -152},
    { 928, 56, -72},
    { 904, 64, -128},
    { 952, -8, -256},
    { 952, -184, -360},
    { 944, -288, -368},
    { 880, -24, -368},
    { 888, -80, -320},
    // 91 seconds
    { 952, -128, -288},
    { 1008, -200, -192},
    { 1120, -272, -272},
    { 1416, -496, -320},
    { 1480, -320, -352},
    { 1096, 48, -248},
    { 1032, -56, -40},
    { 936, -88, 104},
    { 1032, -40, 176},
    { 1000, 24, 208},
    { 960, 8, 120},
    { 1056, 136, -8},
    { 1064, 296, -104},
    { 1008, 128, -104},
    { 1008, 24, -120},
    { 1064, 48, -184},
    { 1072, 48, -224},
    { 1016, -32, -224},
    { 1016, -56, -216},
    { 1072, -16, -208},
    { 1104, -8, -208},
    { 1112, -8, -184},
    { 1224, 80, -200},
    { 1496, 80, -208},
    { 1264, 72, -216},
    // 92 seconds
    { 976, 96, -240},
    { 728, -56, -200},
    { 944, -40, -80},
    { 1128, -56, 120},
    { 1096, -232, 264},
    { 1040, -232, 256},
    { 1008, -304, 128},
    { 1000, 304, -312},
    { 840, 160, -192},
    { 976, 176, -296},
    { 984, 168, -352},
    { 960, 40, -256},
    { 1008, -120, -280},
    { 1000, 8, -336},
    { 1056, 200, -344},
    { 1064, 192, -248},
    { 1320, 112, -160},
    { 1280, -432, -104},
    { 1064, 264, -440},
    { 912, 136, -160},
    { 944, -48, 40},
    { 976, 304, 56},
    { 1064, 248, 136},
    { 1032, 240, 152},
    { 976, 112, 176},
    // 93 seconds
    { 1024, -128, 96},
    { 1048, -128, 8},
    { 1048, -24, -96},
    { 1104, 104, -88},
    { 1048, 104, -16},
    { 1048, 56, 56},
    { 1064, 40, 72},
    { 1088, 88, 24},
    { 1160, 184, 48},
    { 1160, 104, -64},
    { 1280, 48, -240},
    { 1160, 88, -168},
    { 1120, 112, -264},
    { 872, 48, -256},
    { 904, -80, -160},
    { 1096, -184, 48},
    { 1240, -168, 176},
    { 1120, -216, 168},
    { 984, 8, 32},
    { 888, -8, 48},
    { 936, 32, 32},
    { 1024, 24, -168},
    { 968, 128, -304},
    { 968, 0, -176},
    { 936, 24, -168},
    // 94 seconds
    { 968, 112, -160},
    { 1000, 304, -120},
    { 1128, 288, -128},
    { 1288, 144, -152},
    { 1456, -40, -384},
    { 1224, 216, -304},
    { 912, 152, -88},
    { 776, 64, 40},
    { 888, -16, 32},
    { 1128, 96, 80},
    { 1152, 80, 200},
    { 1064, 184, 80},
    { 992, 112, 80},
    { 984, 104, 0},
    { 1056, 72, -24},
    { 1120, 64, -72},
    { 1112, 112, -184},
    { 1072, 168, -240},
    { 1000, 264, -168},
    { 976, 232, -136},
    { 1352, 280, -176},
    { 1376, 408, -112},
    { 880, 288, -152},
    { 616, 88, -224},
    { 976, 48, -168},
    // 95 seconds
    { 1312, -216, -72},
    { 1208, -176, -216},
    { 1040, -368, -176},
    { 888, -8, -128},
    { 936, 88, -128},
    { 928, 88, -96},
    { 960, 144, -120},
    { 944, 120, -112},
    { 984, 104, -168},
    { 1024, 80, -224},
    { 1064, 80, -288},
    { 1048, 192, -384},
    { 1160, 128, -496},
    { 1432, 112, -456},
    { 1200, 200, -192},
    { 904, -8, -16},
    { 832, -16, -24},
    { 1152, -32, 40},
    { 1184, 80, 192},
    { 1008, -48, 232},
    { 1000, 40, 136},
    { 1024, 0, 64},
    { 1024, 80, 8},
    { 1032, 88, -8},
    { 1040, 104, -96},
    // 96 seconds
    { 1032, 136, -136},
    { 1032, 144, -136},
    { 1016, 144, -128},
    { 1000, 168, -160},
    { 1008, 248, -152},
    { 1016, 280, -144},
    { 1024, 280, -136},
    { 1016, 280, -144},
    { 1192, 272, -144},
    { 1296, 296, -96},
    { 1160, 232, -72},
    { 920, 144, -184},
    { 832, -168, -352},
    { 1040, -192, -272},
    { 1232, 104, -144},
    { 1232, 32, -8},
    { 1120, -16, 72},
    { 936, 72, 80},
    { 920, 272, -80},
    { 888, 288, -160},
    { 928, 256, -104},
    { 936, 120, -88},
    { 960, 40, -88},
    { 960, -152, -88},
    { 992, 0, -128},
    // 97 seconds
    { 1000, 88, -168},
    { 976, 128, -152},
    { 984, 152, -168},
    { 1040, 304, -216},
    { 1216, 472, -336},
    { 1512, 328, -336},
    { 1328, -240, -216},
    { 944, 120, -296},
    { 800, 120, -208},
    { 952, -32, -80},
    { 1192, -8, 24},
    { 1104, -16, 112},
    { 1024, 32, 96},
    { 1008, 40, 32},
    { 960, 32, 64},
    { 944, 32, 88},
    { 944, 24, 24},
    { 952, -8, 0},
    { 1024, 16, -16},
    { 1080, -16, -32},
    { 1048, -16, -72},
    { 1128, 48, -104},
    { 1096, 120, -144},
    { 1128, 208, -232},
    { 1576, 224, -296},
    // 98 seconds
    { 1336, 152, -200},
    { 1048, 72, -248},
    { 736, 8, -280},
    { 704, -24, -240},
    { 1272, -344, -96},
    { 1256, -216, 192},
    { 1088, -120, 312},
    { 1024, -128, 224},
    { 992, -8, 128},
    { 1016, 16, 88},
    { 1040, 8, 0},
    { 1056, 96, -88},
    { 1048, 232, -152},
    { 1016, 176, -152},
    { 976, 104, -144},
    { 1008, 112, -160},
    { 1016, 96, -112},
    { 1048, 56, -72},
    { 1128, 80, 8},
    { 1088, 128, 32},
    { 1088, 224, 104},
    { 968, 280, 200},
    { 992, 328, 232},
    { 1024, 296, 248},
    { 1096, 304, 216},
    // 99 seconds
    { 1032, 240, 128},
    { 1032, 256, 32},
    { 1048, 184, 8},
    { 1064, 168, 64},
    { 1072, 120, 104},
    { 1064, 80, 128},
    { 1024, 40, 136},
    { 1024, 104, 136},
    { 1032, 136, 136},
    { 1040, 208, 72},
    { 1056, 240, 40},
    { 1008, 240, 0},
    { 1000, 264, -40},
    { 1200, 240, 0},
    { 1104, 208, 96},
    { 1104, 192, 48},
    { 1032, 216, -72},
    { 984, 16, -296},
    { 1192, -352, -304},
    { 1112, -232, -80},
    { 1072, -80, -24},
    { 1104, 64, -8},
    { 1040, -48, 88},
    { 968, 8, 80},
    { 976, 72, -40},
    // 100 seconds
    { 976, 224, -144},
    { 952, 120, -96},
    { 952, 64, -120},
    { 960, 8, -120},
    { 944, -56, -152},
    { 992, -48, -216},
    { 1048, 8, -240},
    { 1048, 112, -256},
    { 1040, 304, -288},
    { 1240, 128, -280},
    { 1520, -176, -320},
    { 1160, -88, -120},
    { 1008, 304, -112},
    { 896, -32, 96},
    { 912, -32, 96},
    { 1152, 56, 112},
    { 1096, 96, 16},
    { 1016, 192, -8},
    { 984, 200, -56},
    { 944, 136, -16},
    { 976, 120, -40},
    { 1016, 120, -88},
    { 1048, 112, -120},
    { 1032, 32, -120},
    { 1056, 16, -112},
    // 101 seconds
    { 1072, 32, -136},
    { 1088, 56, -160},
    { 1168, 88, -128},
    { 1200, 192, -144},
    { 1144, 112, -96},
    { 1040, 120, -88},
    { 912, 120, -64},
    { 984, 88, 24},
    { 1296, -16, 72},
    { 1288, -480, 184},
    { 1000, -336, -24},
    { 928, 144, -144},
    { 880, 360, -248},
    { 808, 320, -176},
    { 816, 240, -112},
    { 816, 232, -144},
    { 872, 256, -176},
    { 920, 224, -176},
    { 1024, 184, -296},
    { 1056, 192, -352},
    { 1152, 336, -344},
    { 1448, 304, -336},
    { 1336, 72, -264},
    { 1136, 304, -208},
    { 984, 144, -24},
    // 102 seconds
    { 832, 104, 8},
    { 808, 88, 48},
    { 936, 120, 120},
    { 1080, 208, 208},
    { 1056, 200, 296},
    { 1064, 216, 264},
    { 1000, 104, 192},
    { 968, 96, 128},
    { 1040, 104, 72},
    { 1080, 72, 16},
    { 1120, 72, -48},
    { 1088, 48, -56},
    { 1064, 16, -72},
    { 1104, 0, -80},
    { 1104, 0, -96},
    { 1136, 16, -136},
    { 1072, 32, -160},
    { 1256, 184, -168},
    { 1480, 152, -104},
    { 1000, 112, -72},
    { 696, 120, -152},
    { 896, 32, -144},
    { 1272, 8, 48},
    { 1168, -144, 216},
    { 952, -104, 152},
    // 103 seconds
    { 904, -120, 128},
    { 1000, -376, -40},
    { 976, -24, -304},
    { 912, 248, -280},
    { 920, 320, -248},
    { 904, 144, -176},
    { 912, 96, -144},
    { 1048, 304, -232},
    { 1432, 568, -304},
    { 1576, 256, -328},
    { 1088, -96, -184},
    { 792, -88, 32},
    { 800, 88, 48},
    { 1064, 24, 120},
    { 1200, 136, 200},
    { 1008, 64, 272},
    { 992, 152, 120},
    { 952, 136, -40},
    { 1000, 152, -32},
    { 992, 216, 40},
    { 1000, 264, -24},
    { 1024, 224, -88},
    { 1072, 216, -152},
    { 1080, 296, -160},
    { 1056, 280, -120},
    // 104 seconds
    { 1128, 288, -152},
    { 1376, 360, -120},
    { 1168, 400, -120},
    { 944, 280, -176},
    { 768, 64, -200},
    { 864, -48, -80},
    { 1232, -40, 0},
    { 1288, -112, -56},
    { 1160, -256, -88},
    { 896, -232, -8},
    { 872, -96, -104},
    { 888, 96, -152},
    { 912, 152, -136},
    { 888, 144, -128},
    { 920, 184, -144},
    { 944, 136, -160},
    { 1032, 160, -232},
    { 1040, 280, -312},
    { 1208, 232, -408},
    { 1576, 96, -456},
    { 1272, 8, -208},
    { 968, -80, -8},
    { 928, -8, 8},
    { 944, -64, 88},
    { 1008, 0, 136},
    // 105 seconds
    { 1160, 16, 160},
    { 1184, 0, 168},
    { 1048, 16, 104},
    { 960, 40, 40},
    { 1000, 64, -16},
    { 1048, 48, -24},
    { 1080, 48, -40},
    { 1088, 64, -56},
    { 1032, 64, -120},
    { 1008, 72, -160},
    { 1040, 40, -176},
    { 1080, 72, -208},
    { 1064, 56, -192},
    { 1304, 88, -192},
    { 1392, 48, -104},
    { 1216, 56, -104},
    { 992, 0, -168},
    { 840, -40, -152},
    { 816, -128, -24},
    { 976, -168, 64},
    { 1192, -256, 160},
    { 1192, -184, 120},
    { 1128, -760, -56},
    { 944, -24, -320},
    { 848, 152, -336},
    // 106 seconds
    { 880, 296, -216},
    { 880, 240, -128},
    { 840, 216, -160},
    { 856, 264, -216},
    { 896, 136, -296},
    { 960, 88, -400},
    { 1040, 216, -528},
    { 1080, 384, -608},
    { 1184, 232, -696},
    { 1512, 128, -456},
    { 1392, -88, -120},
    { 1032, 152, -128},
    { 920, 144, 0},
    { 864, 16, 88},
    { 976, 24, 160},
    { 1048, 48, 160},
    { 1120, 96, 176},
    { 1064, 104, 184},
    { 1048, 136, 160},
    { 1032, 72, 112},
    { 1056, 40, 96},
    { 1120, 24, 104},
    { 1152, 0, 64},
    { 1136, 0, 8},
    { 1088, -16, -40},
    // 107 seconds
    { 1104, 16, -48},
    { 1144, 48, -8},
    { 1104, 48, 48},
    { 1088, 48, 72},
    { 1080, 72, 96},
    { 1000, 80, 80},
    { 1008, 80, 8},
    { 1088, -16, 96},
    { 1088, -24, 40},
    { 1080, -144, 72},
    { 1072, -224, -56},
    { 1128, -152, -128},
    { 1016, 0, -64},
    { 1056, 0, 48},
    { 1064, 64, 32},
    { 1000, 112, 40},
    { 952, 152, -48},
    { 960, -8, -80},
    { 1000, -32, -184},
    { 1000, 72, -264},
    { 1000, 152, -384},
    { 976, 120, -344},
    { 944, 112, -304},
    { 936, 104, -288},
    { 976, 112, -296},
    // 108 seconds
    { 1112, 104, -472},
    { 1304, -64, -720},
    { 1088, 168, -328},
    { 1128, 272, -120},
    { 1120, 24, 24},
    { 1120, -8, 176},
    { 1064, -24, 168},
    { 1016, 8, 176},
    { 960, 40, 128},
    { 944, 80, 96},
    { 968, 112, 56},
    { 1032, 128, 8},
    { 1104, 128, -8},
    { 1104, 144, -72},
    { 1080, 112, -112},
    { 1064, 80, -136},
    { 1072, 32, -128},
    { 1056, 16, -136},
    { 1040, 24, -128},
    { 1056, 80, -112},
    { 1080, 96, -88},
    { 1072, 96, -72},
    { 1056, 128, -96},
    { 1432, 168, -96},
    { 1400, 256, -80},
    // 109 seconds
    { 1000, 288, -160},
    { 624, 112, -176},
    { 712, 56, -160},
    { 1232, 32, 48},
    { 1280, 64, 8},
    { 1144, 72, 120},
    { 960, 96, 24},
    { 912, 216, -56},
    { 968, 432, -120},
    { 976, 312, -32},
    { 992, 152, -32},
    { 1000, 40, 40},
    { 968, -24, 144},
    { 960, -136, 176},
    { 952, -72, 104},
    { 984, 40, 24},
    { 1048, 144, -24},
    { 1064, 336, -72},
    { 1096, 632, -240},
    { 1504, 432, -152},
    { 1504, -256, -256},
    { 1152, 160, -264},
    { 912, 128, 8},
    { 968, -48, 200},
    { 880, -104, 152},
    // 110 seconds
    { 976, 64, 152},
    { 1056, 144, 64},
    { 1024, 208, 104},
    { 944, 160, 16},
    { 1016, 128, -16},
    { 1040, 152, 0},
    { 1064, 200, -32},
    { 1008, 144, -24},
    { 1008, 168, 0},
    { 1048, 192, 32},
    { 1072, 192, 56},
    { 1064, 224, 24},
    { 1064, 248, 8},
    { 1064, 288, -40},
    { 1008, 304, -80},
    { 1224, 384, -120},
    { 1368, 392, -48},
    { 1048, 320, -24},
    { 888, 160, -136},
    { 776, -88, -288},
    { 1008, -360, -288},
    { 1256, -408, 40},
    { 1168, -200, 104},
    { 1112, -80, 32},
    { 1000, -8, 16},
    // 111 seconds
    { 952, 16, -24},
    { 928, -8, -88},
    { 968, 40, -168},
    { 984, 160, -248},
    { 960, 144, -240},
    { 928, 80, -224},
    { 944, 24, -192},
    { 984, 64, -176},
    { 968, 160, -200},
    { 976, 144, -208},
    { 1000, 48, -232},
    { 1016, 56, -232},
    { 1008, 120, -256},
    { 960, 248, -280},
    { 1136, 240, -296},
    { 1496, 88, -464},
    { 1232, 416, -320},
    { 904, 168, -112},
    { 808, 0, 0},
    { 1056, -56, 40},
    { 1248, 96, 120},
    { 1040, 64, 192},
    { 960, 64, 144},
    { 960, 40, 48},
    { 984, 24, 48},
    // 112 seconds
    { 1032, 40, 56},
    { 1072, 40, 8},
    { 1104, 72, -64},
    { 1056, 48, -80},
    { 1056, 56, -104},
    { 1064, 72, -168},
    { 1080, 104, -200},
    { 1072, 160, -232},
    { 1232, 176, -304},
    { 1520, 216, -312},
    { 1352, 64, -304},
    { 1104, 24, -296},
    { 1000, -112, -560},
    { 1168, -88, -376},
    { 1328, -152, -320},
    { 1264, -112, -192},
    { 1144, 40, -496},
    { 928, -232, -272},
    { 1088, 176, -712},
    { 888, -152, -512},
    { 808, -136, -584},
    { 624, -272, -640},
    { 464, -320, -536},
    { 344, -448, -480},
    { 264, -472, -568},
    // 113 seconds
    { 248, -544, -488},
    { 200, -568, -592},
    { 192, -584, -688},
    { 152, -624, -736},
    { 120, -664, -768},
    { 72, -656, -864},
    { 96, -632, -888},
    { 96, -600, -912},
    { 88, -544, -904},
    { 0, -496, -824},
    { -64, -408, -808},
    { -88, -384, -808},
    { -88, -384, -808},
    { 0, -344, -928},
    { 8, -408, -864},
    { 0, -400, -864},
    { -56, -416, -856},
    { -64, -448, -856},
    { -40, -464, -864},
    { -32, -488, -864},
    { -16, -480, -864},
    { -24, -488, -824},
    { 8, -464, -784},
    { 24, -440, -608},
    { -8, -440, -616},
    // 114 seconds
    { 288, -336, -648},
    { 336, -328, -512},
    { 488, -192, -736},
    { 576, -152, -664},
    { 632, -264, -712},
    { 952, -248, -664},
    { 1016, -280, -696},
    { 1144, -88, -808},
    { 1064, -104, -808},
    { 960, -80, -808},
    { 904, -160, -776},
    { 840, -200, -744},
    { 840, -192, -776},
    { 816, -160, -768},
    { 832, -128, -752},
    { 856, -120, -688},
    { 904, -104, -656},
    { 928, -64, -560},
    { 952, 16, -496},
    { 1240, 136, -320},
    { 1352, 144, -328},
    { 1176, 160, -192},
    { 1256, 184, -136},
    { 1120, 144, -64},
    { 992, 160, -24},
    // 115 seconds
    { 1000, 160, 0},
    { 920, 184, -24},
    { 936, 192, -24},
    { 1048, 176, -32},
    { 1056, 48, -48},
    { 1128, 160, -160},
    { 1128, 112, -240},
    { 1096, 48, -208},
    { 1096, 8, -232},
    { 1056, -16, -280},
    { 928, -80, -280},
    { 1056, -112, -224},
    { 1120, -96, -200},
    { 984, -48, -224},
    { 872, -64, -200},
    { 808, -80, -168},
    { 960, -48, -176},
    { 1104, -64, -184},
    { 992, -48, -256},
    { 1024, -48, -256},
    { 1064, -48, -216},
    { 1136, -24, -216},
    { 1112, -16, -176},
    { 1096, -16, -168},
    { 1064, -24, -176},
    // 116 seconds
    { 1032, -40, -168},
    { 1016, -80, -160},
    { 1032, -104, -168},
    { 1064, -112, -176},
    { 1048, -120, -168},
    { 1064, -80, -152},
    { 1064, -40, -136},
    { 1096, -32, -136},
    { 1104, -16, -128},
    { 1184, -56, -112},
    { 1400, -48, -40},
    { 1168, -64, -64},
    { 1136, -72, -128},
    { 1000, -144, -168},
    { 880, -168, -176},
    { 920, -248, -104},
    { 1176, -264, -144},
    { 1208, -152, -264},
    { 1232, -112, -256},
    { 1384, 0, -392},
    { 1368, 8, -376},
    { 1336, 32, -416},
    { 1248, -32, -456},
    { 1152, -80, -496},
    { 952, -120, -448},
    // 117 seconds
    { 728, -184, -496},
    { 608, -168, -456},
    { 496, -288, -504},
    { 400, -296, -552},
    { 328, -344, -648},
    { 256, -408, -696},
    { 192, -464, -760},
    { 168, -448, -840},
    { 144, -464, -816},
    { 32, -432, -1000},
    { 120, -456, -992},
    { 184, -336, -904},
    { 160, -272, -792},
    { 88, -248, -768},
    { 176, -192, -904},
    { 256, -200, -848},
    { 248, -216, -768},
    { 232, -136, -816},
    { 240, -184, -744},
    { 280, -136, -824},
    { 240, -80, -856},
    { 248, -80, -904},
    { 320, -136, -1000},
    { 336, -152, -1016},
    { 360, -160, -1064},
    // 118 seconds
    { 296, -168, -1048},
    { 232, -120, -1048},
    { 168, -112, -984},
    { 128, -72, -896},
    { 144, -56, -720},
    { 184, 32, -752},
    { 440, 16, -632},
    { 552, -40, -304},
    { 1200, -48, -240},
    { 1648, -152, -296},
    { 1664, -216, -296},
    { 1672, -256, -264},
    { 1608, -192, -184},
    { 1336, -248, -80},
    { 1072, -200, -32},
    { 1040, -104, -80},
    { 968, -48, -136},
    { 840, -64, -160},
    { 864, -56, -192},
    { 920, -64, -240},
    { 912, -64, -320},
    { 872, -96, -360},
    { 952, -128, -368},
    { 1096, -144, -352},
    { 1112, -152, -360},
    // 119 seconds
    { 1096, -96, -360},
    { 1128, -104, -336},
    { 1648, 16, -320},
    { 1352, -96, -216},
    { 1224, -72, -120},
    { 1024, -88, 16},
    { 1312, 8, -64},
    { 1376, -8, 24},
    { 1216, -24, -24},
    { 1072, 8, -80},
    { 1040, 72, -128},
    { 960, 112, -96},
    { 840, 200, -232},
    { 864, 232, -304},
    { 880, 144, -304},
    { 904, 72, -336},
    { 928, -96, -368},
    { 880, -192, -392},
    { 840, -328, -360},
    { 976, -392, -280},
    { 1080, -296, -416},
    { 992, -280, -496},
    { 888, -488, -416},
    { 944, -368, -296},
    { 1208, -240, -232},
    // 120 seconds
    // elapsed: 2 minutes
    { 1312, -112, -192},
    { 1144, -48, -104},
    { 1032, 16, -96},
    { 936, 80, -96},
    { 880, 56, -88},
    { 960, 56, -80},
    { 1008, -24, -40},
    { 1096, -64, -96},
    { 1032, -72, -176},
    { 1192, -120, -296},
    { 1296, -104, -352},
    { 1176, -96, -376},
    { 1488, -96, -400},
    { 1296, -40, -400},
    { 1048, -56, -232},
    { 1144, 0, -240},
    { 1024, 0, -176},
    { 1040, -16, -152},
    { 1152, -8, -104},
    { 1176, 16, -48},
    { 1176, 16, -32},
    { 1200, 0, 0},
    { 1240, 24, 64},
    { 1240, 112, 72},
    { 1248, 200, 64},
    // 121 seconds
    { 1184, 160, 88},
    { 1080, 136, 112},
    { 1024, 104, 112},
    { 992, 120, 80},
    { 992, 112, 32},
    { 992, 32, 32},
    { 1168, 64, -56},
    { 1008, -64, -144},
    { 888, -216, -248},
    { 840, -72, -408},
    { 824, -168, -464},
    { 1080, -200, -424},
    { 1256, -160, -472},
    { 1144, -168, -432},
    { 1008, -128, -392},
    { 952, -96, -360},
    { 920, -64, -304},
    { 1008, -32, -272},
    { 1024, -24, -240},
    { 992, -24, -168},
    { 984, -32, -120},
    { 992, -8, -80},
    { 1032, 88, -56},
    { 1088, 48, -40},
    { 1096, 40, -8},
    // 122 seconds
    { 1272, 72, -8},
    { 1528, 80, -64},
    { 1376, 112, -72},
    { 1096, 24, -8},
    { 952, 24, -40},
    { 1248, 40, -80},
    { 1352, 16, -16},
    { 1256, -48, 64},
    { 1136, 0, 16},
    { 928, -72, 8},
    { 912, -80, -16},
    { 960, -64, -40},
    { 920, -88, -40},
    { 904, -96, -40},
    { 944, -80, -40},
    { 960, -112, -32},
    { 1088, -88, -80},
    { 1160, -48, -48},
    { 1528, -48, -48},
    { 1552, -8, -72},
    { 1312, -8, -184},
    { 936, -24, -312},
    { 736, 0, -288},
    { 976, -24, -184},
    { 1248, -8, -128},
    // 123 seconds
    { 1144, -16, -120},
    { 960, -32, -112},
    { 928, -24, -136},
    { 896, -8, -240},
    { 960, 0, -256},
    { 992, -64, -296},
    { 1024, -72, -256},
    { 1048, -64, -288},
    { 1112, -64, -264},
    { 1144, -88, -232},
    { 1144, -80, -176},
    { 1352, -64, -200},
    { 1424, -48, -192},
    { 1224, -40, -120},
    { 920, -32, -96},
    { 904, 0, -136},
    { 1184, 16, -144},
    { 1184, -16, -48},
    { 1120, -8, -48},
    { 1080, 0, -56},
    { 1000, 0, -64},
    { 928, 24, -96},
    { 928, 40, -120},
    { 920, 0, -128},
    { 920, -16, -120},
    // 124 seconds
    { 936, -24, -136},
    { 952, -40, -152},
    { 1024, -56, -208},
    { 1112, -88, -192},
    { 1456, -72, -208},
    { 1256, -96, -216},
    { 1088, -72, -288},
    { 888, -72, -344},
    { 736, -64, -248},
    { 944, -80, -192},
    { 1160, -80, -168},
    { 1136, -56, -136},
    { 968, -24, -144},
    { 912, -8, -208},
    { 896, -24, -192},
    { 928, -64, -200},
    { 944, -72, -216},
    { 1000, -64, -256},
    { 1008, -64, -280},
    { 1048, -72, -312},
    { 1104, -64, -328},
    { 1104, -56, -320},
    { 1104, -40, -312},
    { 1336, -48, -352},
    { 1456, -8, -312},
    // 125 seconds
    { 1224, 48, -232},
    { 888, -72, -200},
    { 944, 0, -224},
    { 1256, -32, -160},
    { 1392, -16, -56},
    { 1240, -72, 0},
    { 1144, -72, 24},
    { 1088, -56, 24},
    { 1032, -40, -8},
    { 992, -24, 0},
    { 928, -40, 8},
    { 872, -56, -8},
    { 880, -64, -8},
    { 952, -56, -40},
    { 1040, -96, -72},
    { 1064, -112, -40},
    { 1496, -152, -40},
    { 1424, -168, -72},
    { 1184, -144, -152},
    { 880, -120, -256},
    { 912, -64, -296},
    { 1224, -48, -216},
    { 1304, -112, -128},
    { 1128, -104, -152},
    { 936, -40, -184},
    // 126 seconds
    { 912, 0, -208},
    { 936, -24, -216},
    { 984, -104, -192},
    { 1040, -136, -216},
    { 1072, -128, -208},
    { 1080, -112, -208},
    { 1096, -120, -200},
    { 1104, -120, -200},
    { 1040, -136, -160},
    { 1248, -152, -128},
    { 1488, -64, -232},
    { 1296, -72, -168},
    { 952, -48, -88},
    { 1016, -24, -120},
    { 1424, 8, -80},
    { 1368, -40, 24},
    { 1112, -80, 48},
    { 984, -136, 40},
    { 1008, -96, 8},
    { 968, -80, -8},
    { 880, -104, 16},
    { 800, -104, 16},
    { 832, -80, -48},
    { 832, -96, -48},
    { 984, -112, -88},
    // 127 seconds
    { 1104, -120, -80},
    { 1552, -120, -72},
    { 1704, -96, -168},
    { 1416, -120, -272},
    { 1056, -112, -368},
    { 768, -48, -368},
    { 920, -56, -240},
    { 1160, -104, -160},
    { 1160, -96, -144},
    { 936, -56, -112},
    { 896, -40, -136},
    { 928, -32, -112},
    { 952, -48, -128},
    { 1008, -72, -160},
    { 1000, -56, -208},
    { 1000, -112, -216},
    { 1008, -112, -216},
    { 1080, -120, -240},
    { 1024, -136, -200},
    { 1096, -136, -128},
    { 1632, -56, -288},
    { 1408, -40, -240},
    { 992, -32, -120},
    { 872, -48, -88},
    { 1288, 24, -112},
    // 128 seconds
    { 1408, -40, -24},
    { 1112, -80, 0},
    { 1000, -88, 0},
    { 1008, -72, 0},
    { 960, -80, 16},
    { 920, -80, 32},
    { 856, -72, 8},
    { 872, -80, -32},
    { 912, -64, -40},
    { 976, -72, -48},
    { 1072, -88, -104},
    { 1112, -112, -112},
    { 1472, -144, -40},
    { 1616, -104, -128},
    { 1280, -96, -240},
    { 904, -72, -296},
    { 800, -16, -328},
    { 976, -24, -184},
    { 1072, -64, -120},
    { 1104, -48, -88},
    { 960, -8, -96},
    { 936, 0, -120},
    { 888, 8, -144},
    { 944, -24, -176},
    { 992, -48, -208},
    // 129 seconds
    { 968, -80, -208},
    { 1016, -96, -248},
    { 1048, -112, -264},
    { 1088, -120, -240},
    { 1096, -128, -224},
    { 1072, -104, -200},
    { 1192, -112, -128},
    { 1608, -24, -264},
    { 1256, -64, -144},
    { 952, -56, -88},
    { 880, -32, -104},
    { 1216, 16, -88},
    { 1304, -16, 32},
    { 1096, -48, 64},
    { 1056, -56, 56},
    { 1032, -40, 48},
    { 1032, -32, 48},
    { 1040, -16, 40},
    { 1032, -24, 56},
    { 1024, -32, 32},
    { 1016, -40, 8},
    { 1032, -32, -48},
    { 1184, -72, -24},
    { 976, -48, -112},
    { 976, -80, -256},
    // 130 seconds
    { 1224, -40, -280},
    { 1056, -64, -240},
    { 1032, -40, -248},
    { 1080, 0, -272},
    { 1072, 0, -248},
    { 1072, -24, -232},
    { 1096, -32, -176},
    { 968, -88, -104},
    { 944, -88, -64},
    { 1048, -72, -32},
    { 1088, -48, 0},
    { 1120, 0, 40},
    { 1088, 56, 64},
    { 1072, 72, 112},
    { 1120, 112, 128},
    { 1144, 120, 144},
    { 1168, 136, 168},
    { 1080, 120, 160},
    { 1120, 128, 128},
    { 1120, 136, 80},
    { 1160, 120, 72},
    { 1168, 88, 80},
    { 1144, 48, 64},
    { 1112, 16, 56},
    { 1096, 16, 64},
    // 131 seconds
    { 1096, -16, 64},
    { 1032, -24, 64},
    { 1048, -56, 16},
    { 1136, -80, 0},
    { 1168, -88, -56},
    { 1104, -120, -64},
    { 1024, -120, -112},
    { 1008, -80, -256},
    { 1008, -88, -272},
    { 1080, -128, -248},
    { 1128, -176, -288},
    { 1016, -216, -256},
    { 992, -224, -224},
    { 936, -232, -232},
    { 944, -208, -224},
    { 960, -200, -200},
    { 984, -192, -168},
    { 1008, -152, -176},
    { 1008, -112, -192},
    { 1024, -96, -168},
    { 1080, -88, -176},
    { 1080, -64, -176},
    { 1088, -56, -176},
    { 1128, -40, -168},
    { 1488, 32, -288},
    // 132 seconds
    { 1272, 64, -232},
    { 1048, 56, -192},
    { 832, 48, -136},
    { 1024, 128, -136},
    { 1272, 72, -64},
    { 1376, 0, -8},
    { 1248, -24, 16},
    { 1224, -32, 16},
    { 1184, -112, 32},
    { 1096, -120, 40},
    { 1048, -104, 32},
    { 960, -112, -8},
    { 920, -112, -24},
    { 896, -112, -32},
    { 920, -128, -56},
    { 968, -136, -48},
    { 1032, -136, -120},
    { 1352, -200, -64},
    { 1400, -152, -128},
    { 1232, -152, -224},
    { 944, -152, -328},
    { 960, -72, -360},
    { 1128, -56, -256},
    { 1168, -88, -168},
    { 1064, -80, -192},
    // 133 seconds
    { 944, -48, -160},
    { 912, -40, -176},
    { 936, -32, -200},
    { 976, -48, -176},
    { 1016, -64, -200},
    { 1016, -64, -232},
    { 1016, -72, -248},
    { 1056, -104, -264},
    { 1120, -120, -272},
    { 1080, -136, -248},
    { 1416, -136, -288},
    { 1560, -120, -304},
    { 1048, -88, -152},
    { 776, -104, -136},
    { 1096, 8, -192},
    { 1416, -32, -56},
    { 1328, -56, -16},
    { 1088, -120, 32},
    { 1056, -96, -16},
    { 1040, -88, -32},
    { 960, -104, -64},
    { 872, -144, -64},
    { 840, -136, -112},
    { 840, -160, -144},
    { 856, -160, -128},
    // 134 seconds
    { 944, -176, -88},
    { 1048, -144, -96},
    { 1136, -136, -56},
    { 1480, -152, 40},
    { 1672, -48, -80},
    { 1304, -24, -192},
    { 1000, -24, -336},
    { 872, -16, -320},
    { 1064, -16, -208},
    { 1152, -16, -112},
    { 1056, -40, -128},
    { 936, -32, -144},
    { 936, 0, -144},
    { 920, -8, -160},
    { 984, -64, -136},
    { 1064, -80, -160},
    { 1064, -88, -168},
    { 1104, -104, -192},
    { 1128, -120, -200},
    { 1080, -128, -184},
    { 1080, -136, -176},
    { 1440, -136, -200},
    { 1408, -88, -264},
    { 1000, -56, -160},
    { 832, -64, -88},
    // 135 seconds
    { 1200, 48, -128},
    { 1384, 16, -32},
    { 1184, -24, 40},
    { 1024, -64, 48},
    { 1032, -48, 8},
    { 1008, -40, 32},
    { 1000, -72, 48},
    { 960, -64, 56},
    { 944, -64, 40},
    { 952, -48, 16},
    { 992, -48, -32},
    { 1008, -64, -48},
    { 1232, -136, -48},
    { 1464, -120, -152},
    { 1256, -168, -256},
    { 1048, -144, -416},
    { 880, -152, -496},
    { 1056, -184, -280},
    { 1128, -232, -128},
    { 1040, -136, -136},
    { 944, -64, -112},
    { 920, -40, -104},
    { 912, -40, -80},
    { 952, -56, -80},
    { 952, -64, -104},
    // 136 seconds
    { 968, -48, -152},
    { 1008, -64, -216},
    { 1088, -80, -264},
    { 1120, -112, -312},
    { 1296, -128, -288},
    { 1648, -96, -400},
    { 1232, -48, -272},
    { 824, -24, -216},
    { 912, 48, -256},
    { 1296, 24, -152},
    { 1400, -40, -24},
    { 1144, -32, -16},
    { 1032, -128, 16},
    { 1000, -104, -32},
    { 904, -72, -24},
    { 848, -72, -40},
    { 848, -104, -40},
    { 888, -104, -48},
    { 936, -96, -64},
    { 1024, -104, -64},
    { 1080, -120, -96},
    { 1232, -144, -8},
    { 1704, -96, -72},
    { 1400, -72, -136},
    { 912, -88, -248},
    // 137 seconds
    { 784, -104, -344},
    { 1048, -8, -280},
    { 1016, -104, -128},
    { 1008, -128, -136},
    { 928, -80, -160},
    { 904, -48, -168},
    { 872, -16, -192},
    { 856, -24, -200},
    { 1008, -48, -176},
    { 1032, -56, -160},
    { 984, -88, -200},
    { 1096, -112, -224},
    { 1208, -128, -248},
    { 1288, -184, -224},
    { 1112, -160, -216},
    { 1168, -200, -216},
    { 1624, -64, -408},
    { 1232, -128, -160},
    { 1192, -16, -40},
    { 1304, 24, -24},
    { 1376, -64, 96},
    { 1232, 40, 168},
    { 1024, 8, 72},
    { 1056, 88, -16},
    { 1000, 64, -56},
    // 138 seconds
    { 864, 16, -48},
    { 864, -112, -136},
    { 952, -48, -176},
    { 856, -96, -368},
    { 800, -112, -376},
    { 752, -168, -440},
    { 672, -144, -512},
    { 688, -144, -400},
    { 768, -144, -256},
    { 952, -272, -536},
    { 1104, -344, -360},
    { 1056, -400, 40},
    { 1280, 0, -80},
    { 1248, -104, -296},
    { 1472, -280, -376},
    { 1208, -432, -216},
    { 1240, -456, -240},
    { 1232, -488, -168},
    { 1192, -376, -96},
    { 1152, -240, -112},
    { 1160, -200, -96},
    { 1136, -168, -32},
    { 1048, -72, -88},
    { 984, -56, -104},
    { 896, -16, -64},
    // 139 seconds
    { 848, 16, -128},
    { 800, 24, -144},
    { 720, 72, -264},
    { 608, 104, -392},
    { 584, 88, -672},
    { 616, 152, -904},
    { 728, 152, -1024},
    { 800, 144, -976},
    { 768, 136, -800},
    { 872, 248, -592},
    { 872, 288, -528},
    { 1144, 312, -424},
    { 1280, 240, -376},
    { 1024, 136, -328},
    { 1064, 176, -288},
    { 968, 88, -288},
    { 1088, 0, -280},
    { 1120, -48, -152},
    { 1064, -72, -160},
    { 1080, -56, -192},
    { 1176, -72, -176},
    { 1328, -8, -216},
    { 1232, 8, -232},
    { 912, 16, -344},
    { 720, -56, -288},
    // 140 seconds
    { 904, 40, -376},
    { 888, 152, -368},
    { 864, 160, -472},
    { 912, 280, -440},
    { 872, 304, -472},
    { 744, 152, -304},
    { 600, 64, -152},
    { 760, 88, -24},
    { 1048, 88, -104},
    { 1000, 200, -48},
    { 1064, -72, -384},
    { 1368, 0, -424},
    { 1600, -48, -376},
    { 1344, -40, -336},
    { 1168, -32, -424},
    { 1200, -104, -256},
    { 1144, -144, -208},
    { 1168, -80, -208},
    { 1168, -16, -304},
    { 1064, 72, -312},
    { 1016, 208, -376},
    { 864, 216, -288},
    { 888, 320, -312},
    { 712, 336, -168},
    { 800, 424, -208},
    // 141 seconds
    { 784, 600, -120},
    { 984, 720, -136},
    { 1056, 856, -88},
    { 1016, 912, -104},
    { 896, 856, -32},
    { 736, 984, -32},
    { 616, 824, 16},
    { 512, 792, 0},
    { 360, 856, 8},
    { 288, 824, -72},
    { 248, 736, -80},
    { 224, 792, -56},
    { 176, 816, -64},
    { 160, 832, -120},
    { 120, 816, -176},
    { 64, 824, -200},
    { -24, 832, -200},
    { -32, 888, -288},
    { 8, 864, -312},
    { 16, 856, -360},
    { 32, 776, -296},
    { 24, 848, -312},
    { 32, 832, -232},
    { 72, 880, -312},
    { 48, 880, -312},
    // 142 seconds
    { 48, 728, -312},
    { 72, 800, -336},
    { 128, 768, -408},
    { 176, 784, -360},
    { 168, 712, -400},
    { 176, 840, -416},
    { 64, 840, -360},
    { 80, 824, -424},
    { -24, 696, -256},
    { -88, 664, -208},
    { -72, 848, -160},
    { -96, 976, -288},
    { -16, 768, -136},
    { 0, 880, -320},
    { 64, 768, -320},
    { 96, 912, -296},
    { 128, 752, -328},
    { 120, 792, -400},
    { 120, 888, -224},
    { 120, 856, -216},
    { 128, 920, -232},
    { 136, 792, -168},
    { 80, 928, -112},
    { 96, 840, -200},
    { 144, 824, -248},
    // 143 seconds
    { 200, 856, -104},
    { 96, 1000, -296},
    { 136, 888, -112},
    { 104, 936, -152},
    { 48, 976, -96},
    { 16, 984, 96},
    { -48, 800, 104},
    { -88, 944, 584},
    { 8, 1032, 80},
    { 248, 864, -264},
    { 184, 752, -280},
    { 168, 824, -296},
    { 184, 816, -320},
    { 136, 736, -280},
    { 128, 896, -384},
    { 176, 816, -384},
    { 224, 832, -400},
    { 328, 848, -472},
    { 416, 704, -512},
    { 344, 776, -584},
    { 320, 744, -552},
    { 200, 952, -536},
    { 112, 736, -696},
    { -56, 632, -808},
    { -8, 320, -784},
    // 144 seconds
    { 176, 72, -928},
    { 80, -312, -864},
    { 120, -112, -816},
    { 120, -288, -952},
    { 120, -368, -848},
    { 72, -432, -848},
    { 64, -416, -864},
    { 80, -424, -864},
    { 56, -224, -984},
    { 56, -200, -960},
    { 16, -160, -912},
    { -8, -128, -880},
    { 40, -144, -952},
    { -16, -184, -904},
    { -8, -88, -1040},
    { -16, -128, -1008},
    { -88, -208, -992},
    { -104, -192, -856},
    { -88, -168, -936},
    { -72, -80, -904},
    { -128, -120, -856},
    { -96, -56, -880},
    { -64, 32, -944},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 20:31:39 local
AccelRawData *activity_sample_walk_200_pbl_25675_11(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25675_11
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 100
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -24, -136, -944},
    { -24, -128, -952},
    { -24, -128, -960},
    { -16, -136, -952},
    { -32, -128, -960},
    { -24, -120, -960},
    { -32, -112, -960},
    { -56, -112, -960},
    { -40, -120, -952},
    { -40, -112, -952},
    { -48, -112, -952},
    { -32, -112, -952},
    { -40, -112, -960},
    { -48, -112, -960},
    { -48, -104, -960},
    { -48, -120, -944},
    { -48, -104, -952},
    { -32, -112, -952},
    { -56, -96, -960},
    { -40, -96, -968},
    { -48, -104, -960},
    { -48, -104, -968},
    { -32, -112, -952},
    { -56, -104, -960},
    { 48, -104, -920},
    // 1 seconds
    { -32, -160, -936},
    { -88, -144, -984},
    { 16, -32, -960},
    { -160, -48, -920},
    { -48, -136, -984},
    { 32, -136, -960},
    { 40, -192, -944},
    { -48, -104, -968},
    { 16, -168, -936},
    { -8, -144, -952},
    { 24, -144, -944},
    { 0, -160, -936},
    { 32, -152, -936},
    { 48, -200, -920},
    { 80, -200, -888},
    { 96, -168, -896},
    { 144, -128, -912},
    { 152, -112, -920},
    { 176, -112, -912},
    { 240, 64, -1024},
    { 232, 136, -968},
    { 224, 288, -1016},
    { 200, 288, -896},
    { 160, 336, -840},
    { 176, 520, -800},
    // 2 seconds
    { 160, 496, -720},
    { 176, 600, -664},
    { 192, 688, -592},
    { 192, 728, -528},
    { 144, 792, -472},
    { 112, 752, -440},
    { 128, 784, -368},
    { 144, 800, -352},
    { 136, 760, -296},
    { 120, 784, -296},
    { 136, 832, -296},
    { 144, 824, -264},
    { 168, 880, -296},
    { 184, 856, -280},
    { 200, 856, -288},
    { 208, 848, -248},
    { 248, 888, -280},
    { 320, 896, -304},
    { 360, 888, -272},
    { 376, 880, -248},
    { 368, 784, -200},
    { 320, 760, -248},
    { 336, 800, -272},
    { 328, 768, -240},
    { 304, 792, -312},
    // 3 seconds
    { 304, 776, -352},
    { 272, 776, -408},
    { 256, 752, -456},
    { 240, 760, -544},
    { 256, 720, -568},
    { 264, 656, -600},
    { 224, 584, -584},
    { 216, 552, -632},
    { 232, 576, -696},
    { 280, 528, -776},
    { 304, 432, -824},
    { 328, 368, -824},
    { 304, 256, -744},
    { 336, 56, -696},
    { 472, 24, -616},
    { 896, -64, -632},
    { 1136, -64, -688},
    { 920, -184, -680},
    { 968, -176, -528},
    { 1016, -216, -440},
    { 1064, -136, -376},
    { 1096, -88, -384},
    { 992, -40, -456},
    { 872, -48, -312},
    { 848, -144, -344},
    // 4 seconds
    { 840, -152, -360},
    { 880, -192, -296},
    { 928, -232, -320},
    { 1000, -200, -376},
    { 976, -216, -408},
    { 1008, -256, -384},
    { 1064, -256, -368},
    { 1160, -224, -360},
    { 1160, -208, -328},
    { 1152, -208, -328},
    { 1576, -232, -280},
    { 1296, -304, -224},
    { 1104, -312, -144},
    { 920, -232, -104},
    { 1000, -232, -32},
    { 1160, -208, -8},
    { 1072, -184, -8},
    { 1080, -208, -8},
    { 1040, -184, -24},
    { 1056, -176, -16},
    { 1024, -152, -56},
    { 1064, -128, -104},
    { 1072, -72, -168},
    { 1056, -32, -208},
    { 1040, -24, -232},
    // 5 seconds
    { 984, 8, -288},
    { 952, 32, -320},
    { 920, 72, -328},
    { 928, 104, -360},
    { 920, 120, -360},
    { 936, 152, -368},
    { 952, 168, -432},
    { 976, 208, -464},
    { 992, 192, -472},
    { 1008, 208, -512},
    { 1064, 240, -560},
    { 1152, 328, -592},
    { 1160, 440, -640},
    { 1000, 488, -648},
    { 864, 512, -632},
    { 752, 608, -640},
    { 664, 592, -664},
    { 624, 472, -624},
    { 520, 392, -600},
    { 472, 384, -624},
    { 408, 312, -544},
    { 320, 184, -552},
    { 216, 248, -560},
    { 128, 328, -576},
    { 104, 464, -544},
    // 6 seconds
    { 80, 320, -512},
    { 48, 648, -704},
    { -48, 592, -664},
    { -48, 728, -640},
    { -72, 440, -560},
    { -56, 696, -752},
    { -40, 568, -648},
    { -168, 576, -560},
    { -144, 472, -592},
    { -160, 648, -680},
    { -128, 552, -680},
    { -104, 552, -744},
    { -128, 544, -680},
    { -152, 592, -592},
    { -176, 544, -584},
    { -184, 752, -640},
    { -184, 536, -592},
    { -136, 712, -544},
    { -144, 624, -632},
    { -96, 560, -600},
    { -152, 608, -616},
    { -160, 632, -624},
    { -168, 576, -608},
    { -184, 592, -632},
    { -184, 616, -576},
    // 7 seconds
    { -200, 560, -600},
    { -184, 712, -616},
    { -152, 592, -616},
    { -184, 576, -624},
    { -152, 680, -648},
    { -176, 504, -664},
    { -160, 536, -656},
    { -184, 608, -624},
    { -176, 536, -632},
    { -176, 544, -688},
    { -184, 560, -736},
    { -168, 472, -720},
    { -176, 504, -720},
    { -192, 424, -696},
    { -192, 480, -752},
    { -192, 416, -776},
    { -184, 424, -792},
    { -184, 400, -784},
    { -176, 368, -792},
    { -200, 344, -824},
    { -192, 264, -856},
    { -192, 248, -840},
    { -200, 288, -848},
    { -160, 192, -888},
    { -200, 240, -896},
    // 8 seconds
    { -176, 128, -880},
    { -192, 160, -848},
    { -184, 128, -872},
    { -192, 96, -952},
    { -192, 88, -888},
    { -160, 72, -864},
    { -176, 80, -832},
    { -152, 96, -840},
    { -136, 200, -808},
    { -192, 416, -792},
    { -104, 416, -904},
    { -152, 408, -864},
    { -112, 304, -792},
    { -104, 400, -840},
    { -80, 360, -832},
    { -80, 424, -808},
    { 24, 344, -800},
    { 64, 360, -768},
    { 64, 256, -768},
    { 88, 304, -792},
    { 160, 336, -808},
    { 224, 256, -856},
    { 232, 248, -776},
    { 288, 424, -968},
    { 216, 64, -784},
    // 9 seconds
    { 312, 176, -888},
    { 352, 240, -944},
    { 400, 208, -912},
    { 424, 152, -880},
    { 512, 120, -848},
    { 512, 48, -832},
    { 568, 160, -928},
    { 528, 120, -880},
    { 552, 120, -896},
    { 536, 88, -888},
    { 568, 128, -864},
    { 560, 128, -920},
    { 616, 280, -1064},
    { 680, 376, -872},
    { 496, 280, -696},
    { 488, 288, -696},
    { 456, 280, -688},
    { 568, 216, -624},
    { 528, 272, -736},
    { 664, 336, -768},
    { 672, 288, -800},
    { 664, 168, -784},
    { 608, 168, -808},
    { 528, 144, -800},
    { 496, 96, -832},
    // 10 seconds
    { 440, 64, -872},
    { 392, 0, -848},
    { 320, 104, -952},
    { 304, -32, -952},
    { 224, 48, -936},
    { 248, 8, -912},
    { 248, 152, -824},
    { 256, 480, -752},
    { 440, 1136, -664},
    { 376, 1000, -608},
    { 224, 664, -416},
    { 304, 552, -272},
    { 368, 616, -232},
    { 416, 776, -88},
    { 408, 776, -32},
    { 416, 808, -56},
    { 424, 824, -176},
    { 352, 800, -152},
    { 328, 712, -192},
    { 352, 840, -144},
    { 328, 888, -136},
    { 328, 832, -184},
    { 400, 936, -136},
    { 344, 928, -152},
    { 376, 880, -120},
    // 11 seconds
    { 376, 968, -48},
    { 392, 928, 48},
    { 560, 1120, -24},
    { 624, 984, -16},
    { 552, 704, -88},
    { 488, 592, -16},
    { 464, 592, -48},
    { 632, 704, -48},
    { 616, 744, -48},
    { 640, 832, -112},
    { 608, 744, -88},
    { 576, 680, -152},
    { 544, 632, -136},
    { 528, 728, -256},
    { 472, 744, -256},
    { 448, 688, -344},
    { 456, 704, -384},
    { 472, 704, -432},
    { 472, 696, -496},
    { 472, 584, -472},
    { 520, 680, -480},
    { 520, 648, -368},
    { 768, 752, -464},
    { 680, 720, -472},
    { 656, 664, -552},
    // 12 seconds
    { 696, 568, -536},
    { 800, 480, -448},
    { 808, 368, -376},
    { 776, 376, -368},
    { 712, 400, -336},
    { 632, 352, -360},
    { 584, 376, -424},
    { 592, 328, -456},
    { 632, 384, -472},
    { 680, 344, -568},
    { 672, 352, -568},
    { 680, 360, -576},
    { 688, 376, -592},
    { 728, 328, -544},
    { 864, 312, -464},
    { 1264, 312, -472},
    { 1232, 224, -440},
    { 952, 128, -392},
    { 872, 80, -280},
    { 1112, 104, -272},
    { 1208, 40, -208},
    { 1056, 24, -216},
    { 960, 48, -240},
    { 880, 72, -232},
    { 872, 120, -280},
    // 13 seconds
    { 840, 144, -344},
    { 880, 112, -368},
    { 888, 112, -368},
    { 944, 64, -416},
    { 952, 64, -392},
    { 896, 72, -368},
    { 936, 56, -312},
    { 1008, 56, -216},
    { 1112, 80, -120},
    { 1608, 128, -64},
    { 1256, 96, -72},
    { 1144, 64, -112},
    { 872, 48, -160},
    { 896, 56, -152},
    { 1120, 24, -88},
    { 1080, 8, -48},
    { 944, -24, -64},
    { 960, -8, -96},
    { 912, -8, -112},
    { 904, -40, -128},
    { 960, -48, -96},
    { 1048, -40, -144},
    { 1048, -80, -184},
    { 1096, -272, -216},
    { 1248, -48, -400},
    // 14 seconds
    { 1224, -40, -432},
    { 1168, 16, -304},
    { 1328, -216, -248},
    { 1728, -96, -304},
    { 1272, -144, -144},
    { 872, -104, -104},
    { 936, -24, -192},
    { 1408, 0, -88},
    { 1296, -32, 8},
    { 1168, -48, -16},
    { 1016, -48, -16},
    { 944, -24, -48},
    { 896, -48, -48},
    { 832, -8, -120},
    { 816, 0, -216},
    { 768, -32, -296},
    { 800, -64, -344},
    { 824, -80, -312},
    { 872, -120, -312},
    { 1032, -80, -272},
    { 1072, -48, -248},
    { 1192, -48, -208},
    { 1736, -16, -104},
    { 1480, 24, -152},
    { 1232, 24, -280},
    // 15 seconds
    { 888, 32, -336},
    { 744, 48, -344},
    { 968, 72, -288},
    { 1136, -64, -152},
    { 1112, -24, -152},
    { 992, -16, -176},
    { 968, 0, -200},
    { 928, -48, -200},
    { 1040, -72, -184},
    { 1032, -96, -200},
    { 1032, -120, -192},
    { 1024, -72, -216},
    { 1056, -48, -256},
    { 1096, -24, -240},
    { 1176, -16, -232},
    { 1136, 56, -240},
    { 1072, -80, -216},
    { 1352, -40, -240},
    { 1168, -72, -248},
    { 1192, -88, -256},
    { 984, -72, -200},
    { 984, -40, -216},
    { 1120, -64, -192},
    { 1200, -72, -136},
    { 1112, -48, -120},
    // 16 seconds
    { 1048, -136, -40},
    { 1056, -96, -72},
    { 1024, -120, -48},
    { 1056, -72, -48},
    { 1048, -8, -120},
    { 944, 16, -160},
    { 976, -16, -160},
    { 1000, 8, -136},
    { 992, 16, -152},
    { 1064, 8, -104},
    { 1176, 40, -72},
    { 1160, 72, -64},
    { 1200, 112, 96},
    { 1216, 136, -24},
    { 1176, 176, -104},
    { 1168, 72, -128},
    { 1136, -40, -96},
    { 1112, -96, -64},
    { 1120, -128, -48},
    { 1056, -112, 32},
    { 1024, 16, 80},
    { 1048, 88, 72},
    { 1000, 64, -40},
    { 920, 64, -144},
    { 928, -56, -400},
    // 17 seconds
    { 944, -152, -352},
    { 952, -264, -216},
    { 968, -256, -192},
    { 920, -136, -168},
    { 1056, -56, -136},
    { 1832, 24, -272},
    { 1432, 56, -264},
    { 1024, -8, -208},
    { 728, -104, -224},
    { 1016, -112, -136},
    { 1296, -256, -32},
    { 1048, -208, 8},
    { 1024, -120, -32},
    { 968, -80, -32},
    { 960, -32, -16},
    { 944, -32, 24},
    { 992, -32, 32},
    { 1056, 8, 0},
    { 1056, 32, 0},
    { 1040, 32, -16},
    { 1112, 16, -8},
    { 1192, 0, -8},
    { 1224, -8, -16},
    { 1272, -32, 16},
    { 1544, -16, -24},
    // 18 seconds
    { 1232, 8, -64},
    { 888, 48, -152},
    { 568, 40, -200},
    { 848, 80, -216},
    { 1152, 72, -128},
    { 1176, -40, -96},
    { 1008, -104, -96},
    { 952, -48, -120},
    { 1000, -16, -136},
    { 1040, -8, -128},
    { 1104, -48, -88},
    { 1024, -64, -64},
    { 976, -48, -96},
    { 960, -40, -88},
    { 1032, -32, -40},
    { 1064, -24, -24},
    { 1064, -32, -16},
    { 1408, -8, -64},
    { 1352, 112, -216},
    { 1152, 144, -168},
    { 880, 104, -40},
    { 1056, 72, 80},
    { 1352, 64, 96},
    { 1088, -8, 120},
    { 984, -32, 80},
    // 19 seconds
    { 1080, -8, 56},
    { 1112, 40, 80},
    { 1064, 16, 144},
    { 1040, 16, 128},
    { 1000, 0, 128},
    { 960, 8, 112},
    { 968, 0, 128},
    { 1032, 0, 112},
    { 1096, -16, 64},
    { 1136, -16, 24},
    { 1320, -72, -24},
    { 1552, -56, 48},
    { 1320, -40, -64},
    { 936, 0, -280},
    { 624, 64, -376},
    { 800, 104, -400},
    { 1184, 24, -288},
    { 1304, -120, -176},
    { 1056, -144, -144},
    { 1008, -64, -136},
    { 1000, 16, -176},
    { 1024, 40, -136},
    { 1096, 64, -104},
    { 1104, 80, -56},
    { 1016, 112, -72},
    // 20 seconds
    { 1016, 112, -104},
    { 976, 120, -112},
    { 984, 104, -152},
    { 960, 72, -192},
    { 1024, 40, -152},
    { 1352, -8, -192},
    { 1416, 24, -272},
    { 1064, -32, -224},
    { 848, -112, -56},
    { 1120, -88, -56},
    { 1272, 0, -152},
    { 1008, -88, -80},
    { 848, -136, -80},
    { 888, -144, -96},
    { 896, -112, -128},
    { 936, -136, -104},
    { 1000, -128, -112},
    { 1024, -112, -96},
    { 1096, -80, -104},
    { 1208, -64, -48},
    { 1256, -56, -8},
    { 1536, -32, 0},
    { 1512, 24, -64},
    { 1232, 64, -104},
    { 840, 40, -192},
    // 21 seconds
    { 592, 0, -72},
    { 1064, 40, -48},
    { 1240, 56, -64},
    { 976, 32, -64},
    { 904, 40, -96},
    { 920, 40, -176},
    { 904, -8, -160},
    { 952, -48, -160},
    { 984, -80, -200},
    { 1016, -96, -240},
    { 1024, -112, -272},
    { 1040, -112, -288},
    { 1072, -136, -240},
    { 1128, -104, -216},
    { 1384, -72, -208},
    { 1456, -8, -232},
    { 1208, -8, -136},
    { 952, 0, -96},
    { 848, 8, -32},
    { 1096, 16, -32},
    { 1304, 16, -40},
    { 1096, 24, 0},
    { 976, 0, 8},
    { 1072, 24, -8},
    { 1080, 32, 56},
    // 22 seconds
    { 1080, 16, 64},
    { 1088, 0, 64},
    { 1088, 0, 64},
    { 1072, -8, 32},
    { 1064, -8, 40},
    { 1096, -40, 8},
    { 1136, -56, -8},
    { 1136, -104, 48},
    { 1448, -72, -8},
    { 1056, -80, -16},
    { 888, -40, -144},
    { 792, -16, -432},
    { 944, 24, -544},
    { 1048, 0, -288},
    { 1096, -136, -176},
    { 1088, -120, -256},
    { 1032, -40, -288},
    { 928, -24, -280},
    { 896, -48, -232},
    { 928, -56, -176},
    { 992, -48, -160},
    { 1032, -32, -160},
    { 1000, -16, -168},
    { 960, -16, -168},
    { 1008, -24, -160},
    // 23 seconds
    { 1144, -16, -152},
    { 1176, -24, -128},
    { 1360, -32, -80},
    { 1648, 8, -216},
    { 1240, -8, -160},
    { 872, -80, -152},
    { 856, -8, -136},
    { 1256, 32, -120},
    { 1432, -32, -32},
    { 1256, -80, 16},
    { 1024, -88, 56},
    { 984, -40, 0},
    { 1024, -16, 0},
    { 944, -32, 8},
    { 952, 0, -16},
    { 944, 16, -80},
    { 960, 8, -112},
    { 920, -8, -104},
    { 912, -8, -120},
    { 936, 32, -160},
    { 1008, 48, -160},
    { 1056, 56, -144},
    { 1160, 16, -96},
    { 1568, -32, 16},
    { 1704, 0, 184},
    // 24 seconds
    { 1480, 112, 80},
    { 1104, 192, -64},
    { 832, 208, -232},
    { 784, 112, -136},
    { 976, -8, -112},
    { 1136, -64, -136},
    { 1032, -72, -160},
    { 984, -48, -256},
    { 952, -96, -264},
    { 1000, -144, -256},
    { 1000, -224, -224},
    { 1024, -256, -232},
    { 1064, -272, -232},
    { 1104, -248, -216},
    { 1112, -200, -192},
    { 1080, -168, -152},
    { 1056, -136, -136},
    { 1016, -104, -136},
    { 984, -64, -184},
    { 968, -16, -192},
    { 984, 64, -240},
    { 944, 104, -256},
    { 928, 128, -264},
    { 888, 144, -296},
    { 864, 168, -280},
    // 25 seconds
    { 864, 160, -328},
    { 832, 144, -352},
    { 832, 144, -360},
    { 904, 136, -352},
    { 920, 112, -328},
    { 1064, 80, -320},
    { 1272, 80, -432},
    { 1288, 80, -368},
    { 1232, 112, -264},
    { 1288, 128, -232},
    { 1264, 96, -104},
    { 1024, 64, -88},
    { 896, 56, -104},
    { 920, 8, -48},
    { 960, -16, 0},
    { 1112, 88, -40},
    { 1112, 72, -16},
    { 1104, 152, -64},
    { 1080, 192, -80},
    { 1032, 280, -248},
    { 968, 256, -296},
    { 936, 240, -328},
    { 912, 168, -312},
    { 920, 160, -344},
    { 928, 160, -360},
    // 26 seconds
    { 928, 200, -344},
    { 984, 240, -352},
    { 1144, 296, -408},
    { 1016, 288, -456},
    { 856, 264, -480},
    { 752, 216, -392},
    { 856, 216, -368},
    { 1032, 216, -448},
    { 944, 160, -384},
    { 872, 96, -320},
    { 808, 88, -344},
    { 752, 112, -416},
    { 704, 112, -416},
    { 704, 120, -480},
    { 696, 128, -544},
    { 696, 136, -552},
    { 696, 160, -584},
    { 712, 176, -568},
    { 760, 240, -608},
    { 816, 256, -576},
    { 928, 256, -560},
    { 1128, 240, -600},
    { 1096, 200, -504},
    { 976, 160, -352},
    { 848, 216, -360},
    // 27 seconds
    { 912, 232, -336},
    { 1136, 264, -352},
    { 1008, 112, -296},
    { 936, 96, -232},
    { 920, 112, -208},
    { 904, 96, -176},
    { 952, 80, -152},
    { 992, 56, -104},
    { 1000, 40, -96},
    { 1016, 40, -88},
    { 1008, 0, -80},
    { 1088, -8, -56},
    { 1144, 0, -48},
    { 1208, 0, -56},
    { 1224, -16, -32},
    { 1528, -32, -32},
    { 1392, -8, -32},
    { 952, 24, -160},
    { 808, 32, -288},
    { 784, 0, -248},
    { 1008, -56, -216},
    { 1224, -80, -208},
    { 1080, -72, -240},
    { 1008, -64, -256},
    { 984, -48, -312},
    // 28 seconds
    { 976, -56, -296},
    { 1040, -8, -336},
    { 1056, 24, -360},
    { 1008, 48, -344},
    { 896, 104, -408},
    { 856, 168, -408},
    { 808, 184, -408},
    { 848, 208, -384},
    { 896, 208, -320},
    { 1104, 272, -392},
    { 1168, 288, -368},
    { 1064, 264, -384},
    { 936, 192, -328},
    { 1016, 144, -288},
    { 1128, 120, -280},
    { 1056, 112, -280},
    { 952, 128, -288},
    { 880, 128, -328},
    { 784, 104, -288},
    { 776, 88, -352},
    { 792, 72, -440},
    { 808, 16, -416},
    { 848, -24, -408},
    { 904, -24, -392},
    { 944, 0, -392},
    // 29 seconds
    { 976, -24, -304},
    { 952, -16, -240},
    { 1184, -48, -160},
    { 1408, -40, -104},
    { 1192, 16, -112},
    { 984, 32, -160},
    { 936, 64, -136},
    { 1176, 144, -64},
    { 1312, 96, -32},
    { 1120, 16, -24},
    { 944, 8, -56},
    { 936, 48, -168},
    { 912, 48, -152},
    { 928, 24, -248},
    { 1000, 16, -272},
    { 984, 16, -296},
    { 976, 8, -320},
    { 984, 0, -288},
    { 1056, 32, -248},
    { 1088, -16, -232},
    { 1104, -16, -200},
    { 1224, -16, -160},
    { 1560, -32, -176},
    { 1320, -56, -168},
    { 1040, -48, -152},
    // 30 seconds
    { 792, -32, -192},
    { 904, -8, -144},
    { 1400, -8, -96},
    { 1328, -80, -64},
    { 1024, -56, -56},
    { 872, -88, -72},
    { 848, -64, -96},
    { 952, -72, -144},
    { 976, -80, -152},
    { 936, -88, -200},
    { 952, -32, -264},
    { 912, -16, -272},
    { 928, -8, -216},
    { 1000, 32, -200},
    { 1080, 88, -160},
    { 1128, 96, -120},
    { 1552, 96, -72},
    { 1576, 88, -48},
    { 1272, 80, -128},
    { 928, 64, -216},
    { 672, 32, -152},
    { 856, -48, -56},
    { 1144, -48, 16},
    { 1112, -24, 56},
    { 1000, 16, 48},
    // 31 seconds
    { 832, 48, 32},
    { 920, 128, -112},
    { 856, 120, -216},
    { 920, 56, -208},
    { 984, -16, -232},
    { 1008, -64, -240},
    { 1032, -64, -272},
    { 1088, -32, -296},
    { 1152, 0, -312},
    { 1136, 24, -304},
    { 1184, 0, -304},
    { 1480, -32, -248},
    { 1376, -24, -248},
    { 1120, -56, -184},
    { 976, -48, -176},
    { 960, -112, -64},
    { 1200, -224, 64},
    { 1272, -216, 144},
    { 1056, -320, 256},
    { 936, -288, 184},
    { 992, -216, 48},
    { 976, -152, 40},
    { 936, -120, 16},
    { 1032, -56, -64},
    { 1088, -24, -96},
    // 32 seconds
    { 1040, -64, -152},
    { 960, -56, -104},
    { 984, -16, -136},
    { 1016, 40, -120},
    { 1184, 88, -72},
    { 1224, 40, -80},
    { 1272, 16, 0},
    { 1480, 16, -32},
    { 1160, 16, -80},
    { 960, -64, -104},
    { 928, -80, -152},
    { 880, -120, -176},
    { 1040, -160, -176},
    { 1152, -192, -184},
    { 1016, -224, -176},
    { 1080, -208, -208},
    { 1128, -176, -240},
    { 1104, -208, -216},
    { 1160, -184, -192},
    { 1136, -144, -184},
    { 1080, -80, -184},
    { 1016, -24, -176},
    { 944, 16, -232},
    { 936, 72, -240},
    { 904, 96, -256},
    // 33 seconds
    { 840, 120, -280},
    { 816, 128, -264},
    { 896, 168, -336},
    { 864, 176, -352},
    { 880, 176, -392},
    { 856, 200, -464},
    { 864, 192, -440},
    { 936, 200, -528},
    { 1032, 160, -600},
    { 920, 72, -536},
    { 1056, 80, -464},
    { 992, 56, -360},
    { 888, 56, -288},
    { 880, 64, -200},
    { 968, 96, -176},
    { 952, 64, -120},
    { 960, 72, -88},
    { 944, 88, -64},
    { 1040, 104, -48},
    { 1120, 104, 0},
    { 1136, 192, -24},
    { 1096, 192, -16},
    { 1024, 184, -16},
    { 1128, 160, -64},
    { 1088, 88, -32},
    // 34 seconds
    { 1152, 0, -16},
    { 1232, -48, 16},
    { 1360, -64, -16},
    { 1360, -72, -40},
    { 1256, -88, -96},
    { 1112, -64, -120},
    { 1040, -40, -200},
    { 976, -32, -168},
    { 896, -56, -176},
    { 912, -56, -160},
    { 888, -72, -184},
    { 896, -96, -168},
    { 992, 24, -152},
    { 1040, 88, -160},
    { 1040, 56, -160},
    { 1032, -40, -184},
    { 992, -56, -136},
    { 1024, -40, -200},
    { 1024, -16, -208},
    { 992, 8, -176},
    { 1048, -24, -208},
    { 1000, -24, -232},
    { 992, -72, -272},
    { 1056, -192, -336},
    { 936, -192, -304},
    // 35 seconds
    { 896, -232, -296},
    { 960, -184, -312},
    { 904, -144, -232},
    { 1104, -64, -224},
    { 952, 0, -200},
    { 1104, 24, -64},
    { 1528, 128, -88},
    { 1360, 216, -64},
    { 1320, 200, -24},
    { 1104, 136, -96},
    { 1024, 112, -184},
    { 1032, 48, -152},
    { 1056, -72, -176},
    { 1096, -136, -200},
    { 1128, -136, -272},
    { 1072, -176, -232},
    { 1000, -176, -264},
    { 920, -120, -248},
    { 880, -24, -224},
    { 856, 16, -208},
    { 832, 64, -192},
    { 856, 72, -176},
    { 976, 104, -184},
    { 1048, 64, -160},
    { 1328, 8, -80},
    // 36 seconds
    { 1792, 48, -144},
    { 1176, 120, -208},
    { 728, 32, -312},
    { 848, 48, -136},
    { 1024, 80, -40},
    { 1072, -16, 0},
    { 1096, 8, 0},
    { 984, 64, -24},
    { 936, 56, -112},
    { 912, 80, -152},
    { 1016, 48, -184},
    { 1072, -8, -160},
    { 1056, -80, -144},
    { 1120, -72, -176},
    { 1128, -72, -184},
    { 1144, -64, -168},
    { 1088, -80, -152},
    { 1432, -48, -192},
    { 1384, -24, -216},
    { 1136, -24, -88},
    { 904, -32, -32},
    { 1104, 24, -56},
    { 1248, 0, 48},
    { 1112, 0, 56},
    { 968, -24, 72},
    // 37 seconds
    { 992, -16, 40},
    { 1104, 32, 40},
    { 1080, 0, 120},
    { 1072, -8, 96},
    { 1056, 16, 64},
    { 1056, 16, 40},
    { 1056, 0, 24},
    { 1048, -32, 16},
    { 1112, -80, -8},
    { 1384, -48, -16},
    { 1144, -72, -112},
    { 856, -32, -272},
    { 592, -32, -280},
    { 848, -24, -272},
    { 1344, -8, -224},
    { 1216, -96, -128},
    { 1000, -136, -168},
    { 936, -80, -160},
    { 952, 8, -152},
    { 1000, 176, -152},
    { 1032, 496, -216},
    { 1056, 584, -192},
    { 1000, 272, -40},
    { 1000, 328, -152},
    { 1136, 248, -72},
    // 38 seconds
    { 1336, 72, 184},
    { 1672, 208, -24},
    { 1392, 256, 64},
    { 1080, 240, 80},
    { 888, 200, 112},
    { 928, 144, 168},
    { 1080, 232, 48},
    { 1008, 208, 64},
    { 936, 224, -80},
    { 896, 240, -88},
    { 800, 216, -120},
    { 760, 152, -272},
    { 848, -16, -344},
    { 904, -24, -384},
    { 976, -80, -336},
    { 1080, -192, -248},
    { 1120, -152, -256},
    { 1480, -184, -176},
    { 1576, -144, -192},
    { 1112, -176, -240},
    { 736, -24, -248},
    { 912, -128, -216},
    { 1152, -24, -136},
    { 1104, -88, -72},
    { 1032, -16, -48},
    // 39 seconds
    { 944, 40, -64},
    { 848, 72, -192},
    { 872, 104, -296},
    { 960, 144, -360},
    { 936, 96, -424},
    { 936, 96, -480},
    { 984, 72, -504},
    { 976, 56, -488},
    { 920, 40, -432},
    { 984, 88, -464},
    { 1232, 80, -496},
    { 1288, -32, -392},
    { 984, -112, -280},
    { 864, -8, -360},
    { 1104, -64, -344},
    { 1224, -80, -248},
    { 984, -112, -200},
    { 920, -56, -240},
    { 928, -112, -208},
    { 952, -120, -184},
    { 976, -88, -176},
    { 1016, -88, -200},
    { 1048, -72, -256},
    { 1016, -104, -248},
    { 1040, -128, -240},
    // 40 seconds
    { 1008, -152, -296},
    { 1160, -128, -336},
    { 1480, -128, -296},
    { 1136, -136, -272},
    { 752, -168, -392},
    { 576, -176, -312},
    { 1040, -192, -272},
    { 1056, -160, -248},
    { 944, -176, -232},
    { 968, -168, -272},
    { 848, -136, -272},
    { 816, -136, -288},
    { 952, -96, -248},
    { 920, -72, -272},
    { 912, -80, -240},
    { 976, -96, -256},
    { 1072, -80, -288},
    { 992, -96, -264},
    { 1040, -80, -256},
    { 1048, -104, -248},
    { 1184, -120, -184},
    { 1264, -128, -176},
    { 1312, -112, -168},
    { 1168, -144, -136},
    { 944, -168, -160},
    // 41 seconds
    { 976, -176, -200},
    { 1056, -144, -176},
    { 1096, -112, -64},
    { 1136, -80, -16},
    { 1064, -64, -32},
    { 1008, -64, -16},
    { 1056, -72, -32},
    { 1080, -64, -8},
    { 1072, -96, -8},
    { 1104, -104, 0},
    { 1072, -88, 0},
    { 1128, -56, 0},
    { 1144, -48, -24},
    { 1112, -56, -48},
    { 1104, -80, -40},
    { 1368, -40, -56},
    { 1128, -64, -56},
    { 880, -48, -88},
    { 728, -32, -168},
    { 944, 16, -192},
    { 1296, 32, -168},
    { 1152, -48, -80},
    { 1032, -48, -112},
    { 976, -24, -160},
    { 936, 0, -200},
    // 42 seconds
    { 1008, 16, -160},
    { 1064, 24, -176},
    { 1000, 24, -208},
    { 952, 96, -248},
    { 944, 120, -256},
    { 944, 128, -264},
    { 992, 160, -280},
    { 984, 144, -264},
    { 1024, 184, -256},
    { 1000, 168, -208},
    { 1024, 152, -168},
    { 1192, 144, -104},
    { 1320, 232, -128},
    { 1072, 192, -80},
    { 1128, 128, 72},
    { 1024, 88, 64},
    { 1080, 104, 88},
    { 1096, 184, 64},
    { 1088, 336, -40},
    { 1000, 264, -56},
    { 1064, 320, -72},
    { 1080, 328, -128},
    { 1096, 304, -200},
    { 1080, 400, -272},
    { 1032, 264, -296},
    // 43 seconds
    { 1016, 304, -280},
    { 984, 216, -304},
    { 896, 112, -320},
    { 896, 192, -392},
    { 848, 176, -416},
    { 824, 192, -456},
    { 800, 176, -464},
    { 848, 176, -496},
    { 848, 200, -520},
    { 840, 80, -496},
    { 864, 136, -576},
    { 856, 104, -584},
    { 864, 48, -576},
    { 856, 80, -592},
    { 832, 40, -568},
    { 808, 96, -576},
    { 792, 72, -624},
    { 800, 56, -656},
    { 776, 16, -632},
    { 752, -80, -632},
    { 744, -96, -632},
    { 728, -40, -616},
    { 688, 0, -568},
    { 672, 0, -656},
    { 640, -8, -656},
    // 44 seconds
    { 672, 8, -736},
    { 648, 16, -824},
    { 632, -8, -808},
    { 704, -8, -808},
    { 760, 32, -864},
    { 792, 200, -888},
    { 784, 200, -888},
    { 664, 200, -696},
    { 640, 192, -576},
    { 656, 184, -568},
    { 688, 200, -624},
    { 784, 224, -696},
    { 824, 232, -640},
    { 856, 256, -576},
    { 832, 248, -616},
    { 776, 200, -584},
    { 776, 216, -592},
    { 752, 184, -632},
    { 744, 168, -608},
    { 776, 144, -600},
    { 800, 112, -608},
    { 792, 104, -568},
    { 832, 96, -520},
    { 944, 80, -480},
    { 992, 72, -456},
    // 45 seconds
    { 1104, 56, -368},
    { 1264, 0, -248},
    { 1112, -16, -224},
    { 1280, 24, -240},
    { 1152, -64, -192},
    { 896, -96, -144},
    { 888, -128, -128},
    { 912, -152, -56},
    { 920, -160, 16},
    { 960, -96, -96},
    { 976, -112, -184},
    { 984, -160, -200},
    { 1008, -144, -208},
    { 1000, -200, -216},
    { 976, -224, -240},
    { 968, -184, -264},
    { 984, -136, -312},
    { 920, -144, -304},
    { 880, -112, -344},
    { 896, -56, -424},
    { 896, -56, -440},
    { 928, -16, -480},
    { 944, 48, -512},
    { 944, 128, -536},
    { 1000, 200, -568},
    // 46 seconds
    { 1032, 248, -592},
    { 1032, 320, -488},
    { 936, 280, -432},
    { 904, 288, -392},
    { 920, 288, -376},
    { 936, 328, -392},
    { 896, 232, -424},
    { 856, 248, -456},
    { 808, 144, -464},
    { 760, 160, -488},
    { 752, 144, -520},
    { 752, 120, -568},
    { 696, 120, -600},
    { 656, 144, -704},
    { 624, 48, -712},
    { 616, 56, -696},
    { 624, 128, -736},
    { 640, 120, -784},
    { 640, 144, -768},
    { 680, 288, -744},
    { 712, 88, -728},
    { 896, 168, -864},
    { 816, 72, -736},
    { 752, 24, -640},
    { 776, 0, -560},
    // 47 seconds
    { 848, 32, -520},
    { 952, 104, -536},
    { 904, 168, -488},
    { 768, 184, -496},
    { 640, 200, -528},
    { 576, 224, -584},
    { 568, 232, -624},
    { 576, 304, -680},
    { 520, 288, -704},
    { 480, 304, -784},
    { 440, 312, -784},
    { 440, 272, -816},
    { 464, 272, -808},
    { 520, 288, -816},
    { 688, 320, -720},
    { 808, 432, -624},
    { 912, 576, -464},
    { 824, 464, -432},
    { 784, 376, -392},
    { 880, 312, -264},
    { 1008, 344, -224},
    { 1080, 272, -176},
    { 1152, 312, -208},
    { 1024, 296, -128},
    { 944, 264, -264},
    // 48 seconds
    { 904, 256, -272},
    { 872, 208, -320},
    { 912, 184, -352},
    { 888, 144, -312},
    { 896, 120, -328},
    { 936, 152, -280},
    { 952, 192, -272},
    { 1080, 208, -184},
    { 1336, 216, -144},
    { 1184, 248, -168},
    { 1056, 264, -200},
    { 832, 232, -192},
    { 736, 192, -160},
    { 928, 168, -120},
    { 1192, 144, -56},
    { 1176, 136, -8},
    { 976, 160, -56},
    { 864, 176, -144},
    { 896, 184, -216},
    { 984, 136, -208},
    { 1048, 128, -224},
    { 1024, 96, -256},
    { 1032, 104, -280},
    { 992, 88, -312},
    { 992, 96, -288},
    // 49 seconds
    { 1024, 112, -296},
    { 1192, 144, -264},
    { 1224, 152, -288},
    { 912, 152, -208},
    { 1200, 168, -208},
    { 1256, 168, -120},
    { 1080, 144, -56},
    { 960, 128, -48},
    { 1152, 144, -48},
    { 1184, 208, 8},
    { 1144, 200, 48},
    { 1112, 152, 96},
    { 1128, 160, 80},
    { 1112, 184, 56},
    { 1112, 152, 104},
    { 1096, 136, 128},
    { 1072, 120, 128},
    { 1056, 128, 96},
    { 1080, 112, 64},
    { 1104, 80, 40},
    { 1120, 48, -40},
    { 1176, 64, -80},
    { 1272, 8, -96},
    { 1080, -16, -208},
    { 944, 0, -512},
    // 50 seconds
    { 656, -80, -600},
    { 896, -96, -688},
    { 1184, -168, -584},
    { 1248, -240, -392},
    { 1096, -184, -336},
    { 960, -120, -304},
    { 872, -48, -248},
    { 848, -24, -216},
    { 896, 24, -216},
    { 960, 40, -184},
    { 952, 24, -224},
    { 968, 32, -232},
    { 976, 24, -256},
    { 976, 24, -264},
    { 992, 24, -312},
    { 1008, 24, -336},
    { 1024, 16, -376},
    { 1200, 16, -408},
    { 1208, 56, -424},
    { 1080, 64, -368},
    { 928, 56, -288},
    { 848, 40, -256},
    { 992, 72, -272},
    { 1152, 56, -232},
    { 1176, 64, -192},
    // 51 seconds
    { 1080, 48, -168},
    { 1008, 40, -144},
    { 984, 40, -120},
    { 1016, 32, -112},
    { 1008, 24, -160},
    { 984, 32, -144},
    { 944, 8, -160},
    { 952, 0, -160},
    { 1008, 8, -176},
    { 1048, 0, -160},
    { 1184, 0, -160},
    { 1456, 16, -184},
    { 1232, 40, -224},
    { 968, 40, -304},
    { 720, 48, -312},
    { 760, 64, -296},
    { 1040, 80, -224},
    { 1168, 80, -200},
    { 1120, 88, -208},
    { 920, 72, -232},
    { 824, 64, -272},
    { 856, 56, -264},
    { 896, 24, -232},
    { 944, 8, -216},
    { 976, 0, -248},
    // 52 seconds
    { 1016, 8, -272},
    { 1056, 8, -312},
    { 1088, 16, -336},
    { 1072, 8, -336},
    { 1184, 40, -352},
    { 1576, 64, -384},
    { 1312, 80, -280},
    { 976, 96, -256},
    { 768, 104, -264},
    { 912, 112, -216},
    { 1144, 96, -176},
    { 1256, 88, -120},
    { 1080, 56, -72},
    { 984, 48, -72},
    { 960, 64, -80},
    { 912, 64, -72},
    { 912, 80, -80},
    { 920, 112, -152},
    { 920, 136, -200},
    { 904, 112, -240},
    { 896, 112, -336},
    { 952, 96, -336},
    { 936, 56, -336},
    { 904, 16, -360},
    { 1152, 40, -312},
    // 53 seconds
    { 1328, 64, -240},
    { 1232, 112, -320},
    { 1128, 136, -424},
    { 840, 128, -472},
    { 584, 88, -472},
    { 816, 48, -464},
    { 1160, 56, -320},
    { 1112, 16, -264},
    { 1056, 48, -256},
    { 976, 80, -240},
    { 992, 96, -200},
    { 1000, 88, -120},
    { 1008, 96, -64},
    { 1048, 120, 8},
    { 1016, 160, 64},
    { 1016, 168, 40},
    { 1136, 208, 8},
    { 1176, 224, 40},
    { 1000, 216, 16},
    { 1048, 248, 16},
    { 1176, 296, 112},
    { 1136, 296, 104},
    { 1120, 296, -32},
    { 1120, 304, -8},
    { 1136, 216, 8},
    // 54 seconds
    { 1136, 192, -40},
    { 1104, 152, -32},
    { 1056, 120, -48},
    { 1032, 80, -48},
    { 1024, 56, -32},
    { 992, 40, -32},
    { 992, 40, -48},
    { 984, 72, -72},
    { 984, 64, -80},
    { 976, 72, -88},
    { 1080, 64, -112},
    { 1160, 56, -96},
    { 1168, 72, -152},
    { 1128, 88, -208},
    { 928, 88, -424},
    { 832, 144, -440},
    { 1072, 16, -344},
    { 1128, 16, -320},
    { 1008, -40, -304},
    { 1112, -40, -304},
    { 1216, -56, -272},
    { 1104, -96, -224},
    { 1064, -72, -192},
    { 1008, -72, -168},
    { 960, -56, -152},
    // 55 seconds
    { 880, -64, -104},
    { 800, -40, -152},
    { 744, -64, -176},
    { 824, -40, -160},
    { 920, -56, -224},
    { 992, -32, -240},
    { 1112, -40, -264},
    { 1192, -8, -264},
    { 1344, 16, -280},
    { 1616, 104, -344},
    { 1440, 232, -384},
    { 1056, 232, -304},
    { 656, 240, -240},
    { 680, 200, -224},
    { 1008, 184, -176},
    { 1280, 184, -88},
    { 1200, 176, -80},
    { 1112, 144, -120},
    { 1056, 80, -80},
    { 1072, 88, -112},
    { 1024, 40, -120},
    { 1024, 16, -120},
    { 992, 0, -152},
    { 960, -16, -168},
    { 968, -32, -128},
    // 56 seconds
    { 976, -32, -128},
    { 960, -16, -160},
    { 1008, 24, -184},
    { 1416, 48, -208},
    { 1512, 80, -216},
    { 1368, 144, -280},
    { 960, 120, -256},
    { 656, 128, -304},
    { 920, 104, -256},
    { 1120, 72, -144},
    { 1056, 64, -104},
    { 904, 64, -112},
    { 848, 80, -152},
    { 824, 80, -152},
    { 888, 88, -272},
    { 920, 80, -280},
    { 960, 72, -368},
    { 944, 40, -368},
    { 1008, 8, -376},
    { 1032, -8, -352},
    { 1024, -40, -320},
    { 1008, -16, -336},
    { 1232, 8, -352},
    { 1400, 48, -352},
    { 1216, 72, -248},
    // 57 seconds
    { 1016, 104, -256},
    { 808, 128, -272},
    { 936, 120, -248},
    { 1080, 120, -200},
    { 1248, 120, -136},
    { 1136, 72, -80},
    { 1032, 64, -96},
    { 1000, 56, -80},
    { 1000, 80, -88},
    { 1016, 88, -176},
    { 944, 112, -200},
    { 856, 104, -240},
    { 856, 120, -296},
    { 856, 120, -296},
    { 880, 96, -296},
    { 904, 112, -296},
    { 920, 136, -304},
    { 1024, 144, -312},
    { 1360, 152, -280},
    { 1352, 152, -192},
    { 1168, 160, -232},
    { 928, 168, -280},
    { 744, 144, -280},
    { 928, 136, -240},
    { 1048, 120, -176},
    // 58 seconds
    { 1096, 120, -152},
    { 1064, 120, -192},
    { 944, 128, -208},
    { 840, 104, -256},
    { 840, 88, -272},
    { 904, 72, -296},
    { 976, 64, -280},
    { 992, 48, -256},
    { 1016, 48, -288},
    { 1008, 56, -272},
    { 1024, 64, -280},
    { 1064, 56, -264},
    { 1184, 80, -256},
    { 1496, 104, -304},
    { 1320, 120, -248},
    { 1088, 112, -200},
    { 904, 120, -184},
    { 960, 104, -184},
    { 1144, 96, -168},
    { 1248, 88, -120},
    { 1144, 56, -64},
    { 1064, 32, -48},
    { 1024, 32, -32},
    { 952, 32, -48},
    { 912, 32, -72},
    // 59 seconds
    { 864, 32, -80},
    { 880, 24, -96},
    { 904, 8, -112},
    { 944, 0, -112},
    { 1024, 8, -136},
    { 1080, 16, -168},
    { 1256, 32, -200},
    { 1664, 64, -184},
    { 1424, 80, -256},
    { 1176, 88, -392},
    { 824, 72, -456},
    { 632, 16, -400},
    { 776, -32, -320},
    { 1056, -56, -264},
    { 1144, -56, -152},
    { 1040, 8, -176},
    { 944, 56, -208},
    { 888, 72, -288},
    { 920, 56, -304},
    { 944, 8, -256},
    { 944, 16, -288},
    { 928, -32, -256},
    { 904, -40, -280},
    { 992, -40, -280},
    { 1056, -24, -272},
    // 60 seconds
    // elapsed: 1 minutes
    { 1024, -8, -248},
    { 1016, 0, -248},
    { 1040, 0, -240},
    { 1248, 0, -216},
    { 1304, -56, -184},
    { 1224, -96, -160},
    { 1160, -96, -120},
    { 976, -104, -104},
    { 888, -112, -104},
    { 992, -128, -88},
    { 1184, -80, -16},
    { 1160, -104, 96},
    { 1080, -64, 72},
    { 1000, -40, 16},
    { 1032, 0, -48},
    { 1064, -8, -40},
    { 1088, -8, -24},
    { 1120, -8, -24},
    { 1144, 16, -16},
    { 1120, 24, -24},
    { 1096, 24, -24},
    { 1088, 8, -40},
    { 1104, 0, 0},
    { 1168, 32, 24},
    { 1208, 56, 32},
    // 61 seconds
    { 1080, 40, 40},
    { 952, 48, -16},
    { 1016, 40, -80},
    { 1072, 8, -112},
    { 1048, 24, -120},
    { 984, 24, -184},
    { 984, 64, -312},
    { 960, 48, -352},
    { 936, 24, -352},
    { 960, 8, -312},
    { 976, 16, -296},
    { 968, 40, -312},
    { 936, 64, -328},
    { 888, 48, -344},
    { 904, 48, -344},
    { 944, 40, -352},
    { 912, 16, -376},
    { 888, 0, -408},
    { 928, -24, -424},
    { 952, -32, -448},
    { 912, -56, -448},
    { 936, -88, -456},
    { 1120, -64, -440},
    { 1104, -56, -376},
    { 1080, -8, -328},
    // 62 seconds
    { 952, 16, -320},
    { 920, 32, -272},
    { 1000, 24, -256},
    { 1144, 40, -216},
    { 1160, 40, -168},
    { 1072, 64, -136},
    { 976, 88, -128},
    { 952, 120, -160},
    { 968, 112, -176},
    { 984, 96, -192},
    { 992, 64, -200},
    { 992, 88, -224},
    { 984, 88, -296},
    { 984, 104, -312},
    { 976, 96, -336},
    { 992, 104, -336},
    { 992, 96, -320},
    { 1048, 120, -296},
    { 1056, 120, -248},
    { 1056, 136, -224},
    { 1240, 128, -200},
    { 1232, 112, -168},
    { 1056, 128, -168},
    { 904, 128, -240},
    { 832, 120, -224},
    // 63 seconds
    { 864, 80, -208},
    { 992, 64, -200},
    { 1008, 48, -192},
    { 1048, 56, -216},
    { 1072, 56, -256},
    { 1000, 40, -272},
    { 944, 0, -264},
    { 920, -24, -272},
    { 952, -32, -264},
    { 1000, -48, -264},
    { 992, -40, -280},
    { 960, -8, -280},
    { 952, 8, -280},
    { 1000, 40, -288},
    { 1048, 56, -264},
    { 1352, 64, -272},
    { 1280, 120, -280},
    { 1064, 120, -256},
    { 1048, 120, -248},
    { 1016, 120, -200},
    { 1024, 88, -152},
    { 1104, 80, -104},
    { 1088, 72, -56},
    { 1000, 80, -40},
    { 1040, 88, -48},
    // 64 seconds
    { 1056, 96, -16},
    { 1064, 96, -24},
    { 1088, 96, 0},
    { 1056, 96, -8},
    { 1072, 104, -32},
    { 1072, 88, -56},
    { 1072, 64, -64},
    { 1080, 24, -72},
    { 1064, 24, -144},
    { 1176, 0, -152},
    { 1104, -8, -144},
    { 976, -8, -216},
    { 960, 0, -288},
    { 848, 32, -360},
    { 824, 32, -392},
    { 1064, 24, -408},
    { 1208, -8, -320},
    { 1144, -32, -312},
    { 1024, -8, -312},
    { 960, -8, -272},
    { 928, 24, -256},
    { 944, 16, -208},
    { 976, 24, -232},
    { 968, 48, -224},
    { 936, 96, -320},
    // 65 seconds
    { 944, 104, -336},
    { 944, 104, -368},
    { 968, 96, -344},
    { 960, 120, -360},
    { 1056, 152, -360},
    { 1280, 200, -376},
    { 1152, 248, -360},
    { 1008, 256, -320},
    { 904, 240, -256},
    { 976, 216, -208},
    { 1008, 184, -176},
    { 1016, 176, -160},
    { 968, 160, -200},
    { 952, 128, -240},
    { 936, 120, -232},
    { 880, 88, -256},
    { 952, 80, -296},
    { 888, 40, -360},
    { 944, 0, -376},
    { 952, -32, -352},
    { 944, -64, -336},
    { 952, -48, -336},
    { 984, -48, -328},
    { 1080, -32, -328},
    { 1384, -16, -288},
    // 66 seconds
    { 1272, -24, -224},
    { 1136, -8, -216},
    { 848, 32, -232},
    { 840, 48, -192},
    { 1032, 72, -152},
    { 1160, 80, -80},
    { 1080, 96, -48},
    { 928, 128, -96},
    { 864, 96, -200},
    { 864, 128, -288},
    { 904, 80, -360},
    { 944, 64, -392},
    { 936, 96, -424},
    { 952, 64, -448},
    { 992, 64, -432},
    { 1080, 8, -424},
    { 1080, -8, -400},
    { 1072, 0, -360},
    { 1352, 32, -400},
    { 1216, -56, -344},
    { 1064, -80, -240},
    { 880, -72, -224},
    { 896, -136, -208},
    { 1200, -152, -184},
    { 1144, -152, -128},
    // 67 seconds
    { 1032, -128, -80},
    { 1016, -96, -88},
    { 992, -112, -48},
    { 1016, -56, -96},
    { 1016, -24, -128},
    { 1064, -32, -80},
    { 1032, 64, -160},
    { 944, 16, -152},
    { 944, 64, -200},
    { 976, 80, -224},
    { 1032, 56, -240},
    { 1008, 112, -272},
    { 1016, 104, -320},
    { 1264, 104, -264},
    { 1184, 64, -280},
    { 1016, -8, -216},
    { 696, 32, -368},
    { 752, 0, -392},
    { 1016, 16, -424},
    { 968, -48, -424},
    { 856, -40, -464},
    { 888, -80, -416},
    { 856, -80, -408},
    { 912, -24, -400},
    { 1040, 0, -384},
    // 68 seconds
    { 992, -32, -376},
    { 984, -32, -400},
    { 984, -32, -416},
    { 976, -64, -360},
    { 976, -24, -440},
    { 944, -40, -432},
    { 904, -56, -416},
    { 1016, 48, -368},
    { 1304, 40, -416},
    { 1136, -16, -280},
    { 1288, 152, -296},
    { 984, -8, -264},
    { 816, 32, -216},
    { 912, -8, -136},
    { 992, 8, -152},
    { 1112, 32, -160},
    { 1160, -32, -88},
    { 1120, -40, -120},
    { 1064, -16, -152},
    { 1088, -40, -168},
    { 1128, -32, -160},
    { 1088, -40, -168},
    { 1112, -8, -168},
    { 1072, -32, -168},
    { 1064, -32, -168},
    // 69 seconds
    { 1080, -32, -152},
    { 1080, -32, -144},
    { 1120, -32, -184},
    { 1472, -16, -208},
    { 1296, -16, -88},
    { 832, 0, -224},
    { 632, 24, -320},
    { 808, 56, -344},
    { 1184, 96, -296},
    { 1152, 32, -240},
    { 1000, 48, -320},
    { 832, 80, -376},
    { 832, 144, -384},
    { 904, 168, -360},
    { 960, 152, -280},
    { 1000, 104, -288},
    { 960, 72, -264},
    { 944, 40, -240},
    { 944, 56, -248},
    { 992, 64, -248},
    { 976, 56, -232},
    { 984, 72, -200},
    { 992, 64, -144},
    { 1144, 56, -88},
    { 1312, 72, -56},
    // 70 seconds
    { 1168, 40, -40},
    { 1112, 48, -32},
    { 1168, 104, 8},
    { 1152, 144, 40},
    { 1008, 200, 32},
    { 1000, 264, -104},
    { 944, 408, -176},
    { 1072, 408, -112},
    { 1160, 456, -160},
    { 1128, 400, -152},
    { 1136, 392, -168},
    { 1128, 336, -184},
    { 1056, 256, -272},
    { 952, 240, -352},
    { 872, 216, -392},
    { 880, 248, -448},
    { 928, 136, -456},
    { 856, 72, -520},
    { 760, 56, -536},
    { 752, 96, -560},
    { 752, 16, -568},
    { 736, 40, -560},
    { 760, -32, -552},
    { 784, -64, -640},
    { 808, -16, -640},
    // 71 seconds
    { 840, 24, -664},
    { 840, 48, -664},
    { 800, 8, -624},
    { 760, 0, -632},
    { 776, -64, -624},
    { 776, -120, -600},
    { 808, -104, -608},
    { 792, -128, -568},
    { 752, -104, -544},
    { 744, -136, -552},
    { 728, -136, -544},
    { 736, -168, -616},
    { 720, -208, -704},
    { 768, -232, -792},
    { 752, -336, -888},
    { 848, -320, -920},
    { 968, -48, -944},
    { 928, -48, -920},
    { 824, 0, -856},
    { 672, 8, -720},
    { 600, -16, -576},
    { 560, -8, -648},
    { 568, -16, -640},
    { 632, 0, -800},
    { 648, -48, -736},
    // 72 seconds
    { 800, -48, -600},
    { 816, 40, -680},
    { 768, 16, -560},
    { 760, -8, -504},
    { 792, 0, -568},
    { 792, -40, -584},
    { 800, -64, -512},
    { 832, -16, -544},
    { 816, -104, -520},
    { 840, -56, -536},
    { 856, -56, -512},
    { 904, -48, -496},
    { 976, -32, -496},
    { 1064, -16, -440},
    { 1224, -32, -352},
    { 1312, -48, -264},
    { 1432, 0, -280},
    { 1184, -8, -288},
    { 1040, -56, -280},
    { 928, -96, -176},
    { 896, -200, 40},
    { 904, -224, 88},
    { 968, -152, 40},
    { 1016, -120, -48},
    { 1056, -168, -112},
    // 73 seconds
    { 1000, -272, -56},
    { 992, -304, -64},
    { 1016, -312, -128},
    { 968, -328, -96},
    { 992, -296, -136},
    { 976, -272, -168},
    { 992, -232, -192},
    { 976, -200, -208},
    { 960, -184, -248},
    { 968, -128, -264},
    { 1016, -96, -272},
    { 1160, -40, -280},
    { 1232, 0, -272},
    { 1248, 56, -232},
    { 1192, 80, -232},
    { 1008, 56, -200},
    { 1000, 88, -144},
    { 1032, 104, -152},
    { 1008, 120, -152},
    { 960, 168, -184},
    { 904, 216, -272},
    { 912, 240, -336},
    { 896, 256, -352},
    { 880, 264, -360},
    { 880, 256, -384},
    // 74 seconds
    { 816, 240, -384},
    { 792, 256, -344},
    { 752, 336, -328},
    { 752, 416, -336},
    { 728, 440, -200},
    { 752, 520, -104},
    { 832, 624, 56},
    { 1120, 728, 256},
    { 1208, 600, 520},
    { 1008, 752, 360},
    { 776, 616, 280},
    { 672, 504, 336},
    { 848, 360, 280},
    { 912, 472, 360},
    { 1040, 432, 328},
    { 888, 448, 224},
    { 784, 472, 144},
    { 672, 480, 160},
    { 640, 480, 144},
    { 656, 536, 168},
    { 656, 584, 264},
    { 664, 648, 216},
    { 600, 680, 176},
    { 576, 688, 176},
    { 560, 704, 168},
    // 75 seconds
    { 560, 712, 144},
    { 608, 728, 168},
    { 672, 752, 160},
    { 736, 808, 152},
    { 840, 792, 56},
    { 1000, 792, 64},
    { 976, 768, 24},
    { 832, 632, -16},
    { 704, 584, -48},
    { 648, 544, -40},
    { 728, 536, 48},
    { 864, 608, 56},
    { 968, 600, 56},
    { 944, 616, -48},
    { 856, 552, -120},
    { 792, 512, -152},
    { 744, 488, -200},
    { 752, 440, -232},
    { 784, 488, -240},
    { 848, 504, -344},
    { 808, 488, -344},
    { 832, 488, -368},
    { 776, 400, -400},
    { 696, 320, -392},
    { 712, 264, -376},
    // 76 seconds
    { 824, 184, -328},
    { 1072, 128, -256},
    { 1016, 72, -240},
    { 1008, 48, -176},
    { 1040, 120, -160},
    { 1064, 128, -240},
    { 1136, 184, -272},
    { 1176, 168, -184},
    { 1184, 152, -168},
    { 1088, 144, -112},
    { 992, 96, -168},
    { 960, 128, -216},
    { 944, 88, -256},
    { 952, 16, -192},
    { 976, 0, -264},
    { 912, 16, -288},
    { 928, 24, -384},
    { 944, 72, -352},
    { 968, 80, -392},
    { 1024, 88, -352},
    { 1032, 120, -360},
    { 1192, 120, -336},
    { 1312, 120, -352},
    { 1264, 120, -304},
    { 1144, 72, -256},
    // 77 seconds
    { 1008, -16, -208},
    { 976, 24, -240},
    { 984, 0, -216},
    { 1088, -16, -160},
    { 1232, 16, -168},
    { 1144, -8, -128},
    { 1000, 0, -160},
    { 928, 16, -216},
    { 936, 40, -232},
    { 944, 24, -256},
    { 920, 16, -288},
    { 904, 8, -320},
    { 896, -8, -344},
    { 960, -8, -328},
    { 984, -32, -272},
    { 1056, -32, -256},
    { 1376, -16, -224},
    { 1336, 8, -160},
    { 1240, 24, -112},
    { 1104, 56, -144},
    { 936, 96, -176},
    { 856, 96, -160},
    { 960, 56, -120},
    { 1064, 40, -24},
    { 1160, 56, 8},
    // 78 seconds
    { 1072, 88, 0},
    { 904, 112, -72},
    { 840, 112, -216},
    { 896, 80, -192},
    { 936, 48, -240},
    { 960, 32, -256},
    { 952, 24, -336},
    { 1000, 0, -376},
    { 1056, 0, -424},
    { 1056, -16, -408},
    { 1040, 0, -408},
    { 1152, 24, -432},
    { 1400, 80, -400},
    { 1288, 64, -280},
    { 1112, 80, -280},
    { 960, 80, -248},
    { 976, 56, -176},
    { 1136, 56, -176},
    { 1272, -8, -48},
    { 1256, 32, -24},
    { 1184, 8, -16},
    { 1120, 0, -48},
    { 1088, 16, -80},
    { 1032, 16, -96},
    { 1032, 0, -144},
    // 79 seconds
    { 1032, 0, -128},
    { 968, 0, -176},
    { 936, -24, -192},
    { 920, 8, -240},
    { 904, 40, -272},
    { 912, 96, -288},
    { 992, 120, -304},
    { 1072, 160, -240},
    { 1120, 176, -240},
    { 1136, 176, -232},
    { 1528, 136, -184},
    { 1320, 144, -80},
    { 1096, 144, -160},
    { 968, 104, -224},
    { 912, 48, -224},
    { 856, -24, -192},
    { 936, -104, -152},
    { 1000, -120, -168},
    { 1056, -128, -184},
    { 984, -136, -248},
    { 920, -176, -272},
    { 984, -200, -280},
    { 1032, -240, -272},
    { 1080, -232, -264},
    { 1072, -224, -288},
    // 80 seconds
    { 1064, -232, -288},
    { 1080, -232, -264},
    { 1040, -240, -256},
    { 1048, -224, -248},
    { 1024, -200, -232},
    { 1008, -192, -272},
    { 976, -176, -272},
    { 952, -152, -272},
    { 920, -128, -296},
    { 968, -96, -288},
    { 944, -88, -304},
    { 912, -72, -312},
    { 944, -56, -344},
    { 912, -80, -376},
    { 944, -88, -384},
    { 968, -96, -408},
    { 968, -112, -432},
    { 904, -128, -488},
    { 872, -144, -512},
    { 864, -176, -504},
    { 880, -192, -488},
    { 880, -200, -464},
    { 864, -184, -448},
    { 960, -136, -432},
    { 1104, -72, -424},
    // 81 seconds
    { 1040, -48, -376},
    { 1040, -24, -328},
    { 1144, -8, -256},
    { 1296, 0, -264},
    { 1328, -8, -176},
    { 1080, 16, -192},
    { 920, 0, -224},
    { 984, 8, -240},
    { 1040, 16, -192},
    { 1016, 0, -184},
    { 1000, 8, -200},
    { 920, 32, -256},
    { 904, 40, -328},
    { 888, 48, -368},
    { 888, 48, -368},
    { 888, 40, -352},
    { 936, 64, -320},
    { 992, 80, -304},
    { 1064, 80, -328},
    { 1232, 48, -288},
    { 1488, 48, -240},
    { 1200, 64, -248},
    { 1016, 88, -304},
    { 712, 96, -280},
    { 864, 104, -264},
    // 82 seconds
    { 976, 88, -224},
    { 1024, 48, -184},
    { 1064, 48, -192},
    { 960, 32, -224},
    { 864, 32, -248},
    { 888, 40, -312},
    { 968, 24, -344},
    { 992, 0, -320},
    { 968, -16, -296},
    { 936, -16, -320},
    { 976, -8, -296},
    { 1008, 0, -264},
    { 1072, 8, -232},
    { 1336, 24, -224},
    { 1256, 56, -224},
    { 1152, 80, -176},
    { 1008, 96, -112},
    { 960, 104, -56},
    { 1192, 176, 88},
    { 1224, 240, 120},
    { 1120, 240, 72},
    { 1080, 200, 40},
    { 1048, 152, 8},
    { 1008, 104, -40},
    { 1000, 40, -104},
    // 83 seconds
    { 1048, 48, -96},
    { 1000, 56, -112},
    { 976, 8, -136},
    { 992, 16, -152},
    { 1064, 64, -184},
    { 1072, 48, -264},
    { 1096, 136, -336},
    { 1344, 240, -368},
    { 1144, 120, -336},
    { 976, 200, -440},
    { 776, 224, -392},
    { 752, 168, -336},
    { 920, 208, -408},
    { 968, 224, -352},
    { 928, 240, -328},
    { 928, 400, -296},
    { 832, 256, -240},
    { 752, 280, -336},
    { 776, 248, -296},
    { 768, 288, -296},
    { 760, 280, -336},
    { 736, 256, -304},
    { 744, 304, -344},
    { 784, 296, -328},
    { 856, 360, -304},
    // 84 seconds
    { 984, 360, -272},
    { 1384, 408, -344},
    { 1464, 320, -328},
    { 1096, 304, -264},
    { 728, 320, -216},
    { 824, 176, -328},
    { 1168, 192, -304},
    { 1192, 136, -200},
    { 1000, 104, -176},
    { 880, 64, -200},
    { 880, 96, -192},
    { 888, 104, -232},
    { 928, 112, -240},
    { 936, 96, -248},
    { 944, 88, -232},
    { 1000, 168, -232},
    { 1040, 144, -272},
    { 1048, 176, -328},
    { 1416, 160, -320},
    { 1328, 176, -296},
    { 936, 184, -336},
    { 536, 184, -384},
    { 680, 200, -384},
    { 1016, 160, -328},
    { 1040, 104, -280},
    // 85 seconds
    { 936, 128, -312},
    { 816, 144, -368},
    { 792, 144, -400},
    { 872, 168, -368},
    { 864, 144, -384},
    { 832, 160, -416},
    { 776, 176, -416},
    { 808, 184, -400},
    { 856, 192, -384},
    { 920, 200, -392},
    { 1296, 160, -328},
    { 1208, 192, -336},
    { 920, 160, -296},
    { 800, 152, -264},
    { 944, 176, -296},
    { 1176, 88, -184},
    { 1096, 168, -184},
    { 976, 128, -176},
    { 952, 136, -176},
    { 960, 144, -184},
    { 960, 168, -192},
    { 1000, 152, -160},
    { 1000, 160, -144},
    { 976, 184, -192},
    { 984, 168, -176},
    // 86 seconds
    { 1032, 184, -208},
    { 1032, 192, -208},
    { 1040, 176, -232},
    { 1232, 168, -248},
    { 992, 128, -256},
    { 872, 96, -280},
    { 808, 112, -352},
    { 888, 72, -264},
    { 1072, 136, -288},
    { 1048, 104, -264},
    { 912, 120, -424},
    { 848, 72, -408},
    { 904, 48, -416},
    { 1000, 64, -408},
    { 1016, 56, -352},
    { 1024, 32, -432},
    { 960, 8, -416},
    { 952, 8, -408},
    { 1008, 56, -392},
    { 1040, 48, -360},
    { 1024, 64, -336},
    { 1008, 72, -336},
    { 1056, 96, -344},
    { 1168, 104, -368},
    { 1200, 112, -336},
    // 87 seconds
    { 1168, 144, -296},
    { 992, 152, -312},
    { 832, 112, -336},
    { 872, 96, -296},
    { 880, 128, -336},
    { 904, 96, -272},
    { 1016, 80, -192},
    { 1056, 96, -216},
    { 1032, 96, -256},
    { 1016, 32, -232},
    { 1064, 24, -264},
    { 1072, 16, -208},
    { 1056, 16, -176},
    { 1056, 72, -144},
    { 1024, 96, -184},
    { 976, 120, -160},
    { 944, 144, -144},
    { 856, 152, -160},
    { 856, 160, -144},
    { 960, 200, -168},
    { 1264, 256, -248},
    { 1328, 320, -208},
    { 1064, 336, -312},
    { 848, 360, -352},
    { 720, 328, -360},
    // 88 seconds
    { 1008, 328, -296},
    { 1152, 304, -232},
    { 1096, 304, -264},
    { 1032, 296, -256},
    { 912, 360, -240},
    { 864, 328, -224},
    { 856, 344, -232},
    { 816, 280, -256},
    { 792, 248, -296},
    { 736, 288, -360},
    { 768, 344, -352},
    { 784, 384, -360},
    { 864, 432, -360},
    { 904, 424, -280},
    { 1000, 424, -272},
    { 960, 592, -168},
    { 800, 544, -80},
    { 704, 656, 0},
    { 648, 672, 168},
    { 648, 688, 272},
    { 608, 648, 392},
    { 648, 696, 320},
    { 640, 648, 376},
    { 664, 632, 392},
    { 680, 640, 376},
    // 89 seconds
    { 656, 656, 312},
    { 632, 696, 328},
    { 656, 712, 328},
    { 664, 680, 248},
    { 672, 696, 288},
    { 760, 704, 280},
    { 704, 672, 272},
    { 704, 656, 208},
    { 704, 648, 184},
    { 696, 656, 160},
    { 792, 632, 184},
    { 808, 616, 176},
    { 784, 616, 216},
    { 768, 600, 152},
    { 744, 592, 80},
    { 736, 600, 88},
    { 752, 560, 112},
    { 760, 552, 64},
    { 744, 576, 112},
    { 800, 600, 8},
    { 776, 656, -64},
    { 840, 440, -112},
    { 856, 328, -104},
    { 888, 328, -152},
    { 936, 336, -152},
    // 90 seconds
    { 920, 288, -176},
    { 952, 288, -176},
    { 1032, 224, -128},
    { 1328, 184, -80},
    { 1664, 232, -88},
    { 1416, 208, -16},
    { 1024, 112, 40},
    { 856, 32, 0},
    { 1224, 112, -48},
    { 1272, 112, 40},
    { 1120, 72, 72},
    { 960, 48, -16},
    { 880, 48, -64},
    { 920, 72, -96},
    { 984, 64, -88},
    { 1000, 40, -88},
    { 1008, 8, -136},
    { 1000, -40, -152},
    { 960, -72, -160},
    { 1016, -104, -184},
    { 1056, -128, -216},
    { 1048, -160, -192},
    { 1232, -168, -96},
    { 1560, -160, -160},
    { 1352, -272, -56},
    // 91 seconds
    { 1176, -384, -32},
    { 864, -512, 64},
    { 736, -408, 120},
    { 936, -296, 104},
    { 1016, -216, 24},
    { 896, -176, -16},
    { 928, -168, -56},
    { 944, -176, -88},
    { 984, -176, -72},
    { 1000, -208, -64},
    { 1000, -216, -96},
    { 984, -192, -160},
    { 1008, -160, -176},
    { 1048, -112, -160},
    { 1072, -88, -224},
    { 1008, -104, -240},
    { 968, -120, -184},
    { 976, -72, -200},
    { 960, -56, -216},
    { 1152, 8, -160},
    { 1240, 112, -216},
    { 1280, 88, -56},
    { 1248, 152, -40},
    { 992, 112, -16},
    { 1008, 112, 48},
    // 92 seconds
    { 1048, 208, 64},
    { 1024, 256, 56},
    { 952, 312, 48},
    { 1016, 408, 16},
    { 976, 472, -16},
    { 936, 456, 32},
    { 952, 456, 16},
    { 920, 424, 24},
    { 888, 472, 0},
    { 832, 480, 16},
    { 816, 496, 64},
    { 768, 576, 64},
    { 752, 688, 64},
    { 744, 528, 152},
    { 672, 784, 256},
    { 752, 808, 184},
    { 592, 616, 296},
    { 576, 552, 208},
    { 968, 680, 192},
    { 952, 656, 128},
    { 888, 560, -8},
    { 712, 488, 8},
    { 768, 472, 16},
    { 928, 504, 16},
    { 976, 552, 48},
    // 93 seconds
    { 960, 552, 96},
    { 840, 528, 72},
    { 720, 536, 8},
    { 640, 584, -56},
    { 648, 624, -80},
    { 640, 624, -104},
    { 624, 656, -128},
    { 600, 664, -184},
    { 600, 656, -184},
    { 600, 672, -200},
    { 592, 680, -232},
    { 584, 656, -248},
    { 616, 696, -320},
    { 696, 712, -392},
    { 760, 680, -400},
    { 952, 672, -472},
    { 904, 640, -456},
    { 856, 600, -336},
    { 776, 496, -312},
    { 672, 400, -344},
    { 624, 392, -280},
    { 680, 352, -200},
    { 856, 408, -224},
    { 912, 408, -224},
    { 904, 384, -224},
    // 94 seconds
    { 864, 368, -352},
    { 840, 376, -304},
    { 872, 328, -336},
    { 840, 296, -408},
    { 864, 288, -432},
    { 872, 296, -456},
    { 880, 296, -456},
    { 856, 272, -488},
    { 824, 240, -472},
    { 832, 224, -472},
    { 920, 224, -360},
    { 1152, 232, -328},
    { 1168, 248, -336},
    { 1040, 128, -320},
    { 864, 136, -352},
    { 776, 120, -304},
    { 864, 96, -232},
    { 1024, 80, -208},
    { 1112, 128, -176},
    { 1056, 112, -208},
    { 984, 128, -232},
    { 960, 80, -304},
    { 1000, 64, -320},
    { 1000, 24, -384},
    { 976, 0, -392},
    // 95 seconds
    { 952, -8, -408},
    { 928, -32, -408},
    { 920, -56, -376},
    { 952, -40, -368},
    { 960, -56, -344},
    { 1016, -56, -352},
    { 1080, -80, -312},
    { 1112, -96, -272},
    { 1272, -96, -256},
    { 1208, -128, -200},
    { 1144, -88, -184},
    { 1072, -104, -232},
    { 1072, -104, -176},
    { 1056, -136, -224},
    { 1040, -48, -288},
    { 1112, -40, -232},
    { 1144, -80, -152},
    { 1096, -56, -168},
    { 1040, -72, -240},
    { 960, -40, -256},
    { 952, -16, -360},
    { 928, -8, -320},
    { 904, -24, -344},
    { 872, -24, -336},
    { 816, -8, -328},
    // 96 seconds
    { 848, 8, -336},
    { 872, 8, -296},
    { 896, 40, -272},
    { 1016, 48, -288},
    { 1120, 48, -208},
    { 1272, 0, -176},
    { 1496, -24, -120},
    { 1304, -24, -144},
    { 1208, -48, -200},
    { 984, -24, -216},
    { 768, -88, -64},
    { 944, -128, 32},
    { 1048, -80, 72},
    { 1072, 48, 120},
    { 976, 112, 32},
    { 864, 80, -72},
    { 856, 120, -176},
    { 896, 72, -216},
    { 968, 40, -240},
    { 968, -64, -248},
    { 1008, -88, -256},
    { 1064, -40, -264},
    { 1136, -16, -248},
    { 1336, 0, -184},
    { 1592, 120, -312},
    // 97 seconds
    { 1240, 80, -208},
    { 1056, 16, -136},
    { 928, 24, -112},
    { 1008, 8, -64},
    { 1240, 56, -40},
    { 1240, 56, 72},
    { 1136, 32, 96},
    { 1064, 8, 80},
    { 1016, 16, 48},
    { 1016, 48, -8},
    { 1032, 104, -56},
    { 1024, 40, -136},
    { 952, 32, -128},
    { 880, 80, -272},
    { 856, 40, -272},
    { 864, 24, -304},
    { 864, -16, -320},
    { 912, 0, -328},
    { 976, -64, -264},
    { 1216, -24, -264},
    { 1104, 16, -248},
    { 1288, 136, -344},
    { 1296, 56, -272},
    { 1040, 8, -232},
    { 880, -24, -184},
    // 98 seconds
    { 944, 40, -168},
    { 1048, 56, -152},
    { 1040, 32, -136},
    { 992, 48, -176},
    { 1016, 64, -208},
    { 992, 80, -208},
    { 968, 48, -280},
    { 944, 56, -264},
    { 920, 40, -264},
    { 896, 32, -240},
    { 928, 72, -200},
    { 976, 48, -216},
    { 1128, 24, -112},
    { 1168, 32, -96},
    { 1120, 24, -72},
    { 1032, 72, 0},
    { 1080, 72, 72},
    { 1200, 136, 184},
    { 1136, 160, 312},
    { 1112, 128, 264},
    { 1128, 152, 168},
    { 1128, 168, 168},
    { 1104, 152, 152},
    { 1112, 136, 160},
    { 1112, 112, 144},
    // 99 seconds
    { 1128, 120, 136},
    { 1168, 96, 152},
    { 1112, 48, 144},
    { 1048, 0, 112},
    { 1080, -16, 104},
    { 1120, 0, 104},
    { 1040, 64, 32},
    { 1048, 32, 8},
    { 1176, 56, 24},
    { 1360, 72, 88},
    { 1208, -96, 128},
    { 856, -288, -64},
    { 752, -208, -152},
    { 1056, -112, -192},
    { 1040, -160, -136},
    { 1000, -216, -144},
    { 1032, -184, -176},
    { 1032, -128, -216},
    { 992, -128, -208},
    { 944, -128, -176},
    { 976, -120, -160},
    { 1040, -128, -144},
    { 1032, -152, -144},
    { 1024, -136, -128},
    { 1072, -104, -128},
    // 100 seconds
    { 1072, -80, -120},
    { 1048, -48, -96},
    { 1144, -80, -80},
    { 1472, -40, -160},
    { 1192, -24, -136},
    { 952, 0, -104},
    { 848, 0, -64},
    { 1200, 40, -96},
    { 1440, 48, -24},
    { 1184, 16, 24},
    { 1040, -56, 24},
    { 968, -32, -16},
    { 968, -16, -24},
    { 984, -40, -8},
    { 1000, -56, 0},
    { 912, -72, -16},
    { 880, -72, -8},
    { 928, -64, -32},
    { 1056, -64, -48},
    { 1104, -64, -48},
    { 1368, -88, -40},
    { 1624, -48, -104},
    { 1152, -40, -168},
    { 872, -16, -304},
    { 664, 16, -304},
    // 101 seconds
    { 952, 32, -248},
    { 1208, -24, -160},
    { 1232, -48, -128},
    { 1032, -32, -136},
    { 952, 16, -152},
    { 952, 8, -112},
    { 1064, -24, -72},
    { 1112, -48, -40},
    { 1048, -64, -8},
    { 992, -16, -16},
    { 1000, 8, -24},
    { 1056, 24, -16},
    { 1072, 16, 8},
    { 1104, 56, 0},
    { 1040, 80, 32},
    { 1136, 72, 0},
    { 1288, 72, -72},
    { 1264, 80, -96},
    { 1072, 56, -56},
    { 984, 0, 16},
    { 1152, 64, -64},
    { 1208, 56, -48},
    { 1224, -24, 16},
    { 1032, -152, 200},
    { 1096, -72, -24},
    // 102 seconds
    { 1048, 72, -64},
    { 1032, 96, -112},
    { 1016, 0, -152},
    { 968, 48, -168},
    { 992, -72, -192},
    { 1024, -40, -160},
    { 1000, -72, -128},
    { 1056, -80, -88},
    { 1032, -72, -72},
    { 1128, -104, 32},
    { 1440, -104, 32},
    { 1200, -32, -24},
    { 856, -32, -96},
    { 688, -72, -120},
    { 984, 8, -80},
    { 1248, 0, -16},
    { 1208, -64, -8},
    { 976, -64, -32},
    { 880, -48, -72},
    { 928, 16, -136},
    { 968, 24, -128},
    { 1096, -8, -168},
    { 1096, -80, -160},
    { 1120, -80, -232},
    { 1088, -80, -240},
    // 103 seconds
    { 1184, -56, -320},
    { 1088, -96, -256},
    { 1416, -96, -288},
    { 1464, -72, -272},
    { 1184, -48, -168},
    { 832, -48, -128},
    { 944, -16, -128},
    { 1464, 24, -64},
    { 1392, 8, 48},
    { 1120, -8, 104},
    { 1088, -16, 48},
    { 1136, 8, 32},
    { 1080, 0, 80},
    { 1032, -24, 88},
    { 952, -24, 40},
    { 904, -8, -32},
    { 848, -16, -64},
    { 904, -64, -56},
    { 936, -72, -80},
    { 1048, -56, -96},
    { 1184, -96, -40},
    { 1568, -64, -72},
    { 1392, -32, -168},
    { 1184, -24, -320},
    { 968, 24, -344},
    // 104 seconds
    { 1056, 80, -408},
    { 1232, 24, -304},
    { 1144, -128, -232},
    { 1080, -120, -296},
    { 1016, -80, -304},
    { 968, -88, -272},
    { 992, -56, -240},
    { 1008, -64, -176},
    { 1056, -72, -176},
    { 1016, -56, -136},
    { 1000, -64, -120},
    { 1032, -72, -120},
    { 1040, -88, -96},
    { 1032, -32, -56},
    { 1016, -16, -40},
    { 1144, -96, -48},
    { 1592, -40, -88},
    { 1264, -96, -48},
    { 984, -48, -96},
    { 936, -32, -152},
    { 1168, -8, -96},
    { 1192, -72, -24},
    { 1072, -72, 8},
    { 952, -112, -24},
    { 936, -24, -120},
    // 105 seconds
    { 904, -48, -72},
    { 912, -24, -72},
    { 944, -8, -128},
    { 920, -96, -64},
    { 992, -96, -88},
    { 1032, -136, -80},
    { 1120, -80, -56},
    { 1200, -104, -96},
    { 1400, -112, -72},
    { 1576, -128, -96},
    { 1240, -96, -160},
    { 992, -72, -304},
    { 760, -48, -296},
    { 856, 16, -256},
    { 1096, -32, -200},
    { 1168, -40, -152},
    { 1032, -48, -136},
    { 992, -16, -200},
    { 944, 8, -200},
    { 952, 24, -208},
    { 1008, -16, -176},
    { 1032, -8, -192},
    { 1016, 24, -200},
    { 1016, 16, -224},
    { 1000, 24, -208},
    // 106 seconds
    { 1024, 32, -200},
    { 1088, 48, -144},
    { 1232, 64, -56},
    { 1568, 120, -24},
    { 1136, 128, 40},
    { 1088, 112, 136},
    { 1136, 120, 184},
    { 992, 200, 200},
    { 1024, 176, 240},
    { 984, 184, 240},
    { 968, 240, 192},
    { 1048, 280, 96},
    { 1072, 152, 112},
    { 1056, 104, 72},
    { 1112, 32, 16},
    { 1168, 64, -40},
    { 1088, 32, -48},
    { 1072, -8, -72},
    { 1080, -24, -80},
    { 1120, -32, -80},
    { 1120, -56, -56},
    { 1184, -80, -56},
    { 1104, -40, -96},
    { 984, 0, -120},
    { 1016, 0, -56},
    // 107 seconds
    { 1144, -8, 0},
    { 1144, -16, 0},
    { 1032, -24, -64},
    { 928, -64, -88},
    { 952, -96, -88},
    { 1016, -64, -48},
    { 1128, -16, -128},
    { 1032, -96, -96},
    { 968, -96, -48},
    { 968, -80, -64},
    { 1000, -64, -88},
    { 1032, -80, -80},
    { 1072, -88, -64},
    { 1088, -128, -48},
    { 1128, -112, -40},
    { 1144, -80, -72},
    { 1032, -80, -104},
    { 968, -80, -136},
    { 1208, -112, -160},
    { 1448, -72, -224},
    { 1304, -88, -136},
    { 944, -104, -56},
    { 744, -72, -112},
    { 1024, 0, -176},
    { 1136, 24, -88},
    // 108 seconds
    { 1200, 16, -32},
    { 1144, -8, -24},
    { 1048, 8, -16},
    { 1008, 40, 8},
    { 1016, 24, -8},
    { 1064, 64, -64},
    { 1032, 40, -120},
    { 1016, -16, -120},
    { 1064, 48, -128},
    { 1064, 32, -192},
    { 1032, 48, -264},
    { 1096, -16, -264},
    { 1256, 32, -384},
    { 1064, -8, -408},
    { 976, -40, -480},
    { 848, -48, -464},
    { 792, -40, -320},
    { 1000, -56, -360},
    { 960, -16, -328},
    { 888, -24, -256},
    { 880, 32, -280},
    { 824, 72, -288},
    { 808, 72, -304},
    { 808, 56, -360},
    { 816, 112, -392},
    // 109 seconds
    { 840, 128, -424},
    { 816, 144, -472},
    { 872, 120, -488},
    { 936, 112, -472},
    { 992, 72, -440},
    { 984, 64, -352},
    { 1208, 56, -328},
    { 1528, 88, -424},
    { 1344, 72, -376},
    { 928, 24, -224},
    { 800, 40, -272},
    { 1128, 88, -296},
    { 1216, 0, -136},
    { 1048, -24, -104},
    { 1000, -24, -136},
    { 1016, -16, -80},
    { 1000, 8, -72},
    { 992, 24, -64},
    { 1008, 24, -104},
    { 968, 48, -136},
    { 920, 56, -216},
    { 904, 88, -232},
    { 912, 104, -320},
    { 944, 104, -336},
    { 960, 80, -336},
    // 110 seconds
    { 944, 56, -320},
    { 1008, 80, -328},
    { 1264, 64, -280},
    { 1456, 80, -224},
    { 1168, 64, -264},
    { 848, 64, -328},
    { 808, 24, -320},
    { 1032, 0, -216},
    { 1104, -24, -112},
    { 1064, 0, -152},
    { 976, 64, -232},
    { 912, 128, -240},
    { 912, 168, -312},
    { 920, 136, -296},
    { 1000, 152, -264},
    { 960, 184, -368},
    { 928, 224, -336},
    { 880, 200, -336},
    { 912, 200, -328},
    { 952, 176, -296},
    { 952, 160, -304},
    { 1112, 168, -232},
    { 1264, 200, -280},
    { 1184, 176, -256},
    { 1040, 144, -224},
    // 111 seconds
    { 936, 136, -208},
    { 1072, 96, -200},
    { 1112, 80, -176},
    { 1056, 80, -192},
    { 960, 64, -272},
    { 896, 56, -272},
    { 872, 64, -288},
    { 856, 96, -336},
    { 848, 112, -352},
    { 856, 104, -360},
    { 912, 128, -368},
    { 912, 136, -384},
    { 928, 144, -376},
    { 952, 128, -352},
    { 1088, 136, -272},
    { 1280, 152, -216},
    { 1144, 144, -208},
    { 944, 104, -272},
    { 832, 72, -240},
    { 840, 40, -192},
    { 1112, 16, -160},
    { 1264, 0, -96},
    { 1152, 0, -128},
    { 944, 24, -192},
    { 856, 48, -256},
    // 112 seconds
    { 888, 32, -232},
    { 960, 16, -216},
    { 1000, 24, -224},
    { 1000, 48, -248},
    { 1016, 40, -248},
    { 1008, 16, -264},
    { 1056, -40, -248},
    { 1104, -80, -224},
    { 1224, -120, -256},
    { 1488, -96, -312},
    { 1280, -96, -240},
    { 1064, -88, -208},
    { 880, -56, -224},
    { 1040, -56, -208},
    { 1200, -40, -160},
    { 1408, -56, -128},
    { 1200, -72, -64},
    { 1056, -40, -80},
    { 976, -16, -128},
    { 1000, -8, -120},
    { 1000, -32, -136},
    { 928, -8, -168},
    { 880, -16, -224},
    { 848, -8, -232},
    { 824, -8, -224},
    // 113 seconds
    { 904, 8, -208},
    { 984, 56, -192},
    { 1080, 80, -144},
    { 1544, 120, -160},
    { 1456, 144, -136},
    { 1248, 144, -200},
    { 952, 112, -272},
    { 784, 88, -224},
    { 1032, 56, -128},
    { 1144, 8, -56},
    { 1128, 16, -40},
    { 984, 56, -32},
    { 848, 64, -104},
    { 880, 96, -152},
    { 952, 40, -184},
    { 968, -16, -232},
    { 928, -72, -288},
    { 920, -96, -328},
    { 944, -104, -352},
    { 1008, -120, -312},
    { 1088, -96, -288},
    { 1104, -72, -272},
    { 1200, -64, -200},
    { 1544, -24, -280},
    { 1248, -48, -152},
    // 114 seconds
    { 1136, -80, -152},
    { 1024, -40, -168},
    { 936, -40, -112},
    { 1040, -96, -64},
    { 1160, -96, -48},
    { 1264, -96, 32},
    { 1176, -112, 48},
    { 1064, -88, 64},
    { 1056, -64, 0},
    { 1032, -48, 8},
    { 1080, -56, 0},
    { 1088, -72, 16},
    { 1048, -64, 0},
    { 1064, -56, -16},
    { 1080, -72, -40},
    { 1192, -72, -8},
    { 1248, -88, 8},
    { 1224, -24, 8},
    { 1128, -32, 32},
    { 1136, -16, 48},
    { 1144, 32, 40},
    { 1176, 72, -8},
    { 1176, 64, 0},
    { 1088, 40, 8},
    { 1024, 72, -8},
    // 115 seconds
    { 1000, 80, -40},
    { 1000, 72, -64},
    { 1000, 56, -88},
    { 1008, 56, -176},
    { 968, 24, -216},
    { 952, 16, -304},
    { 968, -16, -344},
    { 1008, -48, -368},
    { 960, -80, -376},
    { 928, -80, -416},
    { 944, -40, -432},
    { 952, -88, -408},
    { 944, -88, -400},
    { 896, -72, -368},
    { 936, -64, -360},
    { 1016, -80, -328},
    { 1440, -56, -352},
    { 1304, -104, -264},
    { 1120, -56, -224},
    { 1064, -48, -240},
    { 1104, -24, -168},
    { 1160, -32, -136},
    { 1088, -16, -128},
    { 984, -40, -80},
    { 1008, -8, -88},
    // 116 seconds
    { 1016, 0, -72},
    { 968, 8, -72},
    { 1000, 56, -96},
    { 1072, 88, -136},
    { 1072, 72, -112},
    { 1040, 64, -152},
    { 976, 56, -184},
    { 952, 48, -192},
    { 992, 24, -192},
    { 1016, 16, -192},
    { 1040, 0, -200},
    { 1112, 16, -176},
    { 1160, 16, -176},
    { 1152, 16, -168},
    { 1392, 16, -152},
    { 1224, 16, -128},
    { 1120, 56, -160},
    { 816, 72, -200},
    { 616, 72, -224},
    { 864, 48, -224},
    { 1136, 0, -144},
    { 1176, -24, -96},
    { 1032, -8, -136},
    { 1000, 16, -184},
    { 1024, -8, -120},
    // 117 seconds
    { 1072, -64, -64},
    { 1064, -80, -24},
    { 1032, -80, -24},
    { 1000, -56, -32},
    { 992, -48, -40},
    { 968, -48, -16},
    { 1000, -24, -64},
    { 1072, -24, -56},
    { 1136, -40, 8},
    { 1528, 16, -64},
    { 1336, -16, -64},
    { 1008, 0, -40},
    { 984, 48, 8},
    { 1280, 40, 24},
    { 1192, -8, 72},
    { 1048, -24, 72},
    { 1088, -16, 72},
    { 1016, -64, 72},
    { 984, -64, 72},
    { 968, -80, 48},
    { 984, -56, 32},
    { 992, -48, 24},
    { 1008, -80, 48},
    { 1048, -56, 72},
    { 1056, -16, 24},
    // 118 seconds
    { 1064, -16, 32},
    { 1520, -40, 40},
    { 1280, 24, 40},
    { 1152, 48, -48},
    { 888, 8, -200},
    { 848, 32, -176},
    { 1112, 8, -88},
    { 1184, -56, -104},
    { 1080, -88, -104},
    { 1008, -56, -120},
    { 936, -32, -176},
    { 944, -40, -160},
    { 1016, -80, -128},
    { 1008, -104, -96},
    { 1016, -88, -104},
    { 1024, -56, -112},
    { 1088, -56, -128},
    { 1096, -64, -112},
    { 1152, -64, -72},
    { 1472, -48, -128},
    { 1352, -32, -96},
    { 1064, 16, -64},
    { 880, 16, -88},
    { 1024, 32, -88},
    { 1352, 0, -16},
    // 119 seconds
    { 1200, -8, 64},
    { 1024, -8, 32},
    { 992, 0, 32},
    { 976, 8, 32},
    { 1024, 8, 56},
    { 992, -8, 72},
    { 992, 0, 48},
    { 952, 0, 40},
    { 984, 0, 8},
    { 1040, -16, -32},
    { 1112, -32, -32},
    { 1040, -40, -80},
    { 1376, -56, -40},
    { 1488, -32, -64},
    { 1216, 8, -184},
    { 752, 0, -264},
    { 688, 32, -376},
    { 1072, 72, -376},
    { 1280, -48, -216},
    { 1104, -144, -160},
    { 1080, -88, -232},
    { 1024, -40, -240},
    { 968, -80, -184},
    { 1008, -88, -184},
    { 944, -96, -176},
    // 120 seconds
    // elapsed: 2 minutes
    { 912, -80, -152},
    { 944, -48, -168},
    { 952, -56, -152},
    { 960, -64, -136},
    { 984, -40, -120},
    { 1040, -32, -168},
    { 992, -24, -144},
    { 1376, -40, -200},
    { 1504, -32, -120},
    { 1216, -48, -56},
    { 888, -64, -112},
    { 864, 0, -176},
    { 1144, 40, -160},
    { 1184, -64, -72},
    { 1112, -112, -32},
    { 1016, -56, -40},
    { 952, -48, -64},
    { 952, -8, -40},
    { 912, -16, -32},
    { 968, -16, -32},
    { 976, -16, -32},
    { 1016, -24, -16},
    { 1072, -24, -8},
    { 1128, -16, -16},
    { 1144, -16, -32},
    // 121 seconds
    { 1528, -16, -16},
    { 1536, 32, -144},
    { 1056, 40, -184},
    { 712, -8, -296},
    { 680, 8, -320},
    { 1048, 56, -184},
    { 1200, -16, -112},
    { 1024, -64, -112},
    { 1016, 16, -168},
    { 944, 64, -208},
    { 952, 88, -168},
    { 1016, 72, -128},
    { 1072, 80, -144},
    { 1032, 104, -136},
    { 1032, 144, -128},
    { 1024, 152, -104},
    { 1032, 152, -48},
    { 1080, 152, -40},
    { 1112, 128, -8},
    { 1584, 208, 40},
    { 1128, 240, 96},
    { 968, 184, 112},
    { 1072, 152, 192},
    { 1112, 208, 288},
    { 1024, 184, 304},
    // 122 seconds
    { 1008, 88, 216},
    { 1064, 112, 168},
    { 1088, 176, 144},
    { 1080, 152, 112},
    { 1064, 104, 112},
    { 1072, 56, 88},
    { 1096, 72, 72},
    { 1088, 72, 64},
    { 1064, 48, 48},
    { 1128, 48, 32},
    { 1296, 48, 32},
    { 1144, 24, 16},
    { 944, 24, -32},
    { 976, 40, -56},
    { 1056, 56, 0},
    { 1072, 32, 88},
    { 1200, -8, 64},
    { 1024, 0, 0},
    { 1016, 8, -80},
    { 1024, 24, -72},
    { 1024, -8, -56},
    { 1040, -40, -40},
    { 1016, -56, -32},
    { 1000, -72, -64},
    { 968, -56, -56},
    // 123 seconds
    { 984, -64, -40},
    { 1024, -64, -32},
    { 1056, -48, -24},
    { 1032, -16, -40},
    { 1040, -8, -64},
    { 1128, -32, -48},
    { 1512, -48, -88},
    { 1448, -56, -80},
    { 1016, -16, -80},
    { 736, -40, -80},
    { 1008, 0, -112},
    { 1232, 8, -64},
    { 1168, -32, -40},
    { 992, -48, -8},
    { 928, -24, -48},
    { 968, 32, -64},
    { 992, 0, -40},
    { 984, -32, -40},
    { 984, -32, -40},
    { 1000, -24, -56},
    { 1048, -40, -56},
    { 1104, -40, -56},
    { 1120, -56, -16},
    { 1488, -16, -72},
    { 1376, 8, -48},
    // 124 seconds
    { 1040, 24, -96},
    { 720, -32, -200},
    { 824, -72, -80},
    { 1192, -56, -104},
    { 1072, -112, -80},
    { 936, -96, -112},
    { 912, -24, -176},
    { 896, 48, -232},
    { 984, -56, -128},
    { 1064, -120, -40},
    { 1032, -152, -16},
    { 984, -88, -32},
    { 992, -56, -64},
    { 1072, -168, -128},
    { 1144, -272, -64},
    { 1176, -168, -72},
    { 1192, 80, -56},
    { 1168, 168, -16},
    { 1400, -72, 24},
    { 1472, 96, 32},
    { 1144, -160, 168},
    { 696, -120, 264},
    { 880, -136, 312},
    { 1088, 40, 280},
    { 1200, 80, 120},
    // 125 seconds
    { 1024, 72, 136},
    { 1064, -32, 104},
    { 1048, -32, 96},
    { 1080, -72, 104},
    { 1088, -24, 64},
    { 1064, 8, 0},
    { 1088, -32, -8},
    { 1008, -40, 32},
    { 1000, -72, 24},
    { 1072, -56, 16},
    { 1000, -8, -8},
    { 960, -16, 0},
    { 968, -16, -32},
    { 1104, -48, -40},
    { 1496, -8, -88},
    { 1280, 64, -192},
    { 872, 0, -264},
    { 728, -120, -176},
    { 1232, 56, -200},
    { 1168, -8, -200},
    { 1032, -48, -280},
    { 936, -8, -288},
    { 888, 16, -344},
    { 944, 24, -304},
    { 984, 8, -320},
    // 126 seconds
    { 904, 40, -360},
    { 864, 88, -368},
    { 840, 128, -352},
    { 880, 168, -352},
    { 1000, 200, -320},
    { 1368, 224, -264},
    { 1352, 240, -304},
    { 1080, 208, -240},
    { 832, 136, -176},
    { 848, 120, -112},
    { 1104, 128, -208},
    { 1104, 104, -176},
    { 1048, 48, -184},
    { 968, 8, -232},
    { 896, 24, -216},
    { 928, 32, -264},
    { 928, 0, -272},
    { 952, -16, -264},
    { 1024, -24, -224},
    { 1056, -32, -208},
    { 1040, -16, -200},
    { 1024, -16, -168},
    { 1184, 0, -112},
    { 1336, 40, -136},
    { 1144, 32, -136},
    // 127 seconds
    { 944, 40, -160},
    { 776, 64, -128},
    { 848, 64, -88},
    { 1168, 88, -72},
    { 1192, 48, -16},
    { 1072, 64, -56},
    { 944, 96, -144},
    { 912, 120, -232},
    { 976, 88, -248},
    { 1048, 32, -280},
    { 1056, -40, -264},
    { 1032, -40, -296},
    { 1080, -24, -336},
    { 1056, -16, -360},
    { 1072, -40, -328},
    { 1064, -40, -288},
    { 1056, -24, -240},
    { 1232, -8, -192},
    { 1400, 48, -192},
    { 1072, 8, -48},
    { 1152, 8, -16},
    { 1176, 32, 56},
    { 1000, 64, 96},
    { 1008, 24, 152},
    { 1072, 64, 136},
    // 128 seconds
    { 1008, 96, 128},
    { 1072, 112, 144},
    { 1072, 96, 104},
    { 1096, 112, 72},
    { 1088, 136, 72},
    { 1072, 96, 48},
    { 1072, 72, 32},
    { 1088, 32, 8},
    { 1120, 0, -24},
    { 1176, -8, -32},
    { 1144, -56, -48},
    { 1320, -40, -120},
    { 1296, -104, -120},
    { 1040, -144, -240},
    { 848, -168, -360},
    { 720, -184, -232},
    { 960, -168, -152},
    { 1208, -120, -152},
    { 1040, -80, -128},
    { 984, -48, -128},
    { 992, -8, -144},
    { 992, -32, -128},
    { 968, -48, -104},
    { 1000, -32, -136},
    { 1032, -8, -160},
    // 129 seconds
    { 1048, -8, -184},
    { 1016, -24, -208},
    { 1032, -32, -224},
    { 1048, -24, -224},
    { 1072, -24, -208},
    { 1112, 0, -208},
    { 1088, -16, -192},
    { 1272, -16, -176},
    { 1328, -8, -168},
    { 1160, -32, -136},
    { 1048, -40, -120},
    { 936, -8, -96},
    { 968, 8, -96},
    { 1184, 96, -72},
    { 1224, 120, -16},
    { 1112, 112, 16},
    { 1040, 96, -16},
    { 984, 80, -24},
    { 976, 72, -32},
    { 944, 96, -72},
    { 912, 128, -136},
    { 856, 152, -136},
    { 840, 240, -336},
    { 864, 176, -312},
    { 920, 168, -352},
    // 130 seconds
    { 1008, 160, -400},
    { 1344, 120, -360},
    { 1264, 80, -456},
    { 1048, -48, -376},
    { 864, -112, -296},
    { 1008, -128, -304},
    { 1080, -136, -168},
    { 1072, -184, -160},
    { 1016, -128, -144},
    { 872, -16, -184},
    { 840, -96, -256},
    { 848, -152, -216},
    { 984, -152, -304},
    { 1008, -192, -352},
    { 976, -160, -424},
    { 1008, -216, -368},
    { 1088, -240, -384},
    { 1064, -208, -368},
    { 1184, -280, -400},
    { 1328, -280, -320},
    { 1088, -160, -352},
    { 816, -136, -304},
    { 720, -136, -288},
    { 792, -96, -288},
    { 888, -112, -256},
    // 131 seconds
    { 1160, -8, -328},
    { 1136, 24, -384},
    { 1000, -40, -344},
    { 920, -40, -352},
    { 912, -56, -384},
    { 904, -112, -376},
    { 928, -136, -384},
    { 936, -128, -408},
    { 968, -144, -432},
    { 992, -168, -392},
    { 984, -136, -376},
    { 1096, -136, -352},
    { 1320, -104, -368},
    { 1184, -56, -336},
    { 1096, -16, -344},
    { 792, -16, -320},
    { 768, -144, -256},
    { 952, -88, -248},
    { 1120, -80, -240},
    { 1072, 0, -248},
    { 920, -16, -248},
    { 904, -8, -280},
    { 888, -16, -280},
    { 920, -24, -264},
    { 960, 8, -296},
    // 132 seconds
    { 992, 40, -344},
    { 1048, 48, -304},
    { 1064, 64, -272},
    { 1088, 32, -152},
    { 1160, 88, -168},
    { 1232, 120, -152},
    { 1128, 112, -136},
    { 1024, 152, -168},
    { 976, 192, -208},
    { 872, 232, -232},
    { 816, 240, -248},
    { 840, 312, -264},
    { 848, 368, -280},
    { 880, 408, -304},
    { 944, 392, -304},
    { 1032, 368, -312},
    { 1040, 312, -296},
    { 1000, 272, -288},
    { 1000, 240, -272},
    { 968, 200, -248},
    { 952, 168, -208},
    { 1016, 152, -208},
    { 1120, 168, -192},
    { 1016, 176, -192},
    { 928, 136, -192},
    // 133 seconds
    { 1040, 80, -192},
    { 1048, 72, -224},
    { 1112, 56, -264},
    { 1056, 16, -184},
    { 960, 32, -216},
    { 976, -24, -232},
    { 928, -16, -240},
    { 904, -56, -224},
    { 848, -32, -256},
    { 912, -40, -320},
    { 992, -24, -408},
    { 1048, -16, -432},
    { 1064, -16, -448},
    { 1096, -8, -432},
    { 1248, -16, -384},
    { 1400, 8, -368},
    { 1264, 72, -296},
    { 968, 88, -256},
    { 736, 104, -192},
    { 800, 152, -160},
    { 944, 216, -136},
    { 984, 240, -112},
    { 1024, 264, -112},
    { 944, 280, -160},
    { 912, 256, -192},
    // 134 seconds
    { 896, 192, -224},
    { 912, 128, -248},
    { 928, 96, -256},
    { 944, 64, -224},
    { 976, 40, -224},
    { 1048, 32, -184},
    { 1128, 16, -152},
    { 1128, -16, -112},
    { 1392, -24, -40},
    { 1336, 0, -88},
    { 1088, 32, -128},
    { 840, 40, -200},
    { 736, -8, -128},
    { 1056, 16, -104},
    { 1200, -8, -48},
    { 1056, 8, -48},
    { 944, 0, -72},
    { 912, 8, -120},
    { 912, 0, -144},
    { 984, 0, -200},
    { 1008, 0, -264},
    { 1000, -24, -296},
    { 992, -56, -288},
    { 1096, -64, -304},
    { 1144, -72, -288},
    // 135 seconds
    { 1200, -72, -224},
    { 1640, -8, -304},
    { 1416, -64, -208},
    { 1048, -56, -152},
    { 760, -56, -152},
    { 1016, 8, -152},
    { 1288, -8, -128},
    { 1288, -16, -48},
    { 1056, -56, -24},
    { 992, -56, -56},
    { 944, -16, -48},
    { 904, 16, -88},
    { 904, -16, -88},
    { 904, -16, -88},
    { 912, -24, -88},
    { 952, -40, -120},
    { 1040, -32, -136},
    { 1096, -64, -64},
    { 1584, -32, -128},
    { 1336, -32, -152},
    { 1008, 0, -336},
    { 712, -56, -344},
    { 992, -56, -208},
    { 1264, -56, -152},
    { 1152, -24, -144},
    // 136 seconds
    { 968, -8, -144},
    { 848, 0, -144},
    { 856, 24, -168},
    { 920, 8, -160},
    { 1040, -24, -232},
    { 1064, -24, -280},
    { 1080, -24, -336},
    { 1112, -64, -312},
    { 1112, -64, -264},
    { 1160, -48, -232},
    { 1512, -24, -288},
    { 1280, -24, -200},
    { 968, -24, -104},
    { 856, 8, -120},
    { 1144, 64, -136},
    { 1432, 0, -72},
    { 1296, 8, -16},
    { 1168, -96, 16},
    { 1096, -104, 8},
    { 1056, -88, 16},
    { 1000, -64, 24},
    { 912, -80, 8},
    { 848, -112, -16},
    { 864, -88, -8},
    { 896, -72, -64},
    // 137 seconds
    { 936, -80, -80},
    { 1040, -72, -112},
    { 1248, -88, -48},
    { 1560, -40, -64},
    { 1408, -16, -96},
    { 1112, -24, -200},
    { 792, -40, -232},
    { 1016, 72, -184},
    { 1312, 96, -136},
    { 1264, 0, -88},
    { 1016, -64, -104},
    { 904, -56, -184},
    { 856, -16, -224},
    { 952, -32, -248},
    { 1024, -64, -216},
    { 1008, -152, -200},
    { 984, -160, -168},
    { 1064, -104, -160},
    { 1208, -24, -224},
    { 1160, -112, -192},
    { 1392, -120, -96},
    { 1400, 104, -144},
    { 1272, 224, -128},
    { 1016, 184, -88},
    { 1000, 96, -64},
    // 138 seconds
    { 1216, 104, -16},
    { 1312, 120, 40},
    { 1200, 40, 80},
    { 1048, -24, 80},
    { 976, -8, 8},
    { 968, -40, -16},
    { 888, -40, -48},
    { 896, -104, -144},
    { 920, -120, -88},
    { 968, -48, -112},
    { 968, -64, -160},
    { 1016, -64, -128},
    { 1128, 16, -32},
    { 1464, 104, -144},
    { 1240, 72, -128},
    { 1048, 56, -200},
    { 776, 32, -240},
    { 960, 0, -176},
    { 1240, 40, -184},
    { 1128, 8, -168},
    { 976, 16, -144},
    { 904, 48, -152},
    { 936, 80, -176},
    { 976, 72, -176},
    { 992, 24, -176},
    // 139 seconds
    { 1024, 8, -184},
    { 1088, 0, -240},
    { 1080, -88, -232},
    { 1240, -200, -272},
    { 1128, -192, -192},
    { 1136, -176, -176},
    { 1392, -176, -88},
    { 1360, -88, -128},
    { 1160, -96, -48},
    { 976, -80, -24},
    { 936, -72, 0},
    { 1120, -64, 56},
    { 1272, -40, 112},
    { 1160, -88, 168},
    { 1120, -88, 160},
    { 1048, -112, 152},
    { 984, -96, 136},
    { 1088, 8, 0},
    { 1024, -8, -16},
    { 1112, -72, -48},
    { 1120, -24, -72},
    { 1056, 0, -120},
    { 1128, 16, -136},
    { 1232, 56, -96},
    { 1200, 104, 8},
    // 140 seconds
    { 1000, 120, 8},
    { 1008, 144, -56},
    { 1048, 168, -128},
    { 1088, 152, -176},
    { 1056, 128, -184},
    { 1008, 120, -184},
    { 960, 136, -200},
    { 936, 144, -232},
    { 920, 152, -256},
    { 888, 160, -296},
    { 880, 160, -320},
    { 880, 184, -352},
    { 872, 200, -520},
    { 848, 168, -552},
    { 880, 128, -536},
    { 896, 136, -528},
    { 904, 144, -512},
    { 856, 112, -536},
    { 968, 96, -488},
    { 1168, 168, -488},
    { 1104, 192, -568},
    { 1024, 112, -360},
    { 1064, 264, -296},
    { 1040, 224, -216},
    { 1096, 200, -136},
    // 141 seconds
    { 984, 184, -112},
    { 936, 536, 240},
    { 448, 168, 488},
    { 1176, 352, -856},
    { 1104, 136, -48},
    { 1160, 56, -296},
    { 1000, 144, -200},
    { 896, 216, -264},
    { 896, 56, -496},
    { 880, 0, -392},
    { 992, -72, -480},
    { 968, -128, -392},
    { 936, -176, -344},
    { 968, -112, -232},
    { 1000, -80, -192},
    { 1288, -80, -128},
    { 1560, -40, -32},
    { 1296, 0, 24},
    { 1112, 48, -56},
    { 832, 88, -56},
    { 872, 72, -56},
    { 1016, 88, -24},
    { 1080, 72, 0},
    { 1048, 64, 0},
    { 968, 88, -48},
    // 142 seconds
    { 928, 128, -256},
    { 912, 88, -280},
    { 952, 24, -352},
    { 1024, -32, -376},
    { 1040, -104, -336},
    { 1056, -104, -352},
    { 1040, -40, -368},
    { 1096, 8, -352},
    { 1088, -16, -288},
    { 1544, 0, -200},
    { 1408, 16, -80},
    { 1152, -48, 8},
    { 984, 8, -32},
    { 1160, 72, -16},
    { 1352, 0, 96},
    { 1176, 0, 192},
    { 1024, -24, 144},
    { 1040, 8, 64},
    { 1160, 56, 48},
    { 1080, 32, 64},
    { 1016, 8, 64},
    { 1040, 48, 32},
    { 1008, 48, -16},
    { 1016, 24, -16},
    { 1056, 8, -32},
    // 143 seconds
    { 1056, -8, -112},
    { 1176, -40, -96},
    { 1384, -8, -160},
    { 1024, -8, -232},
    { 704, -72, -344},
    { 776, -56, -296},
    { 1328, 40, -344},
    { 1272, -48, -208},
    { 1072, -56, -192},
    { 944, -64, -184},
    { 952, 40, -184},
    { 928, 40, -176},
    { 1000, -40, -128},
    { 1000, -96, -96},
    { 1032, -56, -104},
    { 1008, -40, -136},
    { 1048, -16, -144},
    { 1136, 8, -128},
    { 1160, 32, -104},
    { 1488, 16, -120},
    { 1464, -8, -80},
    { 1248, -24, -120},
    { 896, -96, 8},
    { 888, -56, -16},
    { 1128, -56, -88},
    // 144 seconds
    { 1120, -104, -16},
    { 1040, -8, -72},
    { 1032, 32, -72},
    { 960, -32, -32},
    { 920, -56, -88},
    { 912, -96, -112},
    { 920, -80, -112},
    { 960, -64, -168},
    { 1000, -24, -104},
    { 1032, -8, -136},
    { 1080, 0, -160},
    { 1128, -160, -160},
    { 1520, -128, -152},
    { 1344, -80, -328},
    { 1000, -72, -392},
    { 776, -144, -312},
    { 1024, -64, -224},
    { 1056, -80, -144},
    { 968, -80, -80},
    { 912, -88, -72},
    { 856, -64, -88},
    { 856, 8, -136},
    { 872, -24, -208},
    { 960, -48, -288},
    { 968, -16, -320},
    // 145 seconds
    { 1000, 8, -344},
    { 1096, 8, -360},
    { 1120, 56, -344},
    { 1184, -16, -344},
    { 1400, -40, -288},
    { 1320, -16, -344},
    { 960, -16, -272},
    { 808, -104, -224},
    { 1024, -64, -184},
    { 1224, -112, -88},
    { 1056, -120, -56},
    { 920, -104, -32},
    { 928, -88, -32},
    { 960, -136, 8},
    { 992, -136, -8},
    { 1024, -144, -16},
    { 1040, -120, -40},
    { 1032, -88, -64},
    { 1064, -64, -88},
    { 1088, -88, -88},
    { 1096, -72, -112},
    { 1160, -96, -160},
    { 1552, -32, -104},
    { 1400, -24, -88},
    { 984, -32, -160},
    // 146 seconds
    { 552, -56, -248},
    { 848, -88, -184},
    { 1192, -184, -152},
    { 1120, -216, -168},
    { 960, -208, -208},
    { 968, -192, -192},
    { 928, -120, -152},
    { 944, -128, -144},
    { 1016, -80, -144},
    { 1024, -88, -112},
    { 1024, -40, -208},
    { 1064, -40, -176},
    { 1024, -8, -208},
    { 1024, -88, -104},
    { 1048, -64, -168},
    { 1232, -136, -104},
    { 1552, -136, -88},
    { 1264, -152, -96},
    { 888, -160, -144},
    { 808, -144, -184},
    { 1088, -80, -168},
    { 1192, -168, -80},
    { 1040, -184, -48},
    { 1024, -160, -24},
    { 992, -136, -40},
    // 147 seconds
    { 984, -144, -32},
    { 960, -120, -40},
    { 960, -96, -32},
    { 1064, -96, -32},
    { 1088, -80, -40},
    { 1064, -112, -48},
    { 1096, -112, -96},
    { 1136, -112, -112},
    { 1488, -128, -120},
    { 1400, -8, -176},
    { 936, -64, -224},
    { 680, -80, -272},
    { 640, -96, -224},
    { 1056, -40, -128},
    { 1208, -16, -144},
    { 1104, -40, -96},
    { 1080, 8, -56},
    { 976, 24, -136},
    { 1008, 160, -232},
    { 1024, 160, -304},
    { 928, 96, -280},
    { 920, 176, -304},
    { 888, 200, -336},
    { 896, 208, -312},
    { 1040, 392, -256},
    // 148 seconds
    { 1080, 400, -280},
    { 1040, 600, -232},
    { 888, 624, -48},
    { 800, 480, 96},
    { 784, 520, 168},
    { 736, 464, 336},
    { 800, 552, 168},
    { 824, 448, 200},
    { 840, 448, 200},
    { 936, 456, 152},
    { 960, 440, 48},
    { 1016, 432, -32},
    { 992, 464, 0},
    { 1000, 408, 24},
    { 1024, 424, -24},
    { 1000, 368, 0},
    { 1016, 360, -16},
    { 960, 352, -40},
    { 992, 320, -64},
    { 984, 328, -72},
    { 960, 272, -72},
    { 1016, 272, -80},
    { 1016, 240, -72},
    { 1056, 224, -136},
    { 1208, 208, -104},
    // 149 seconds
    { 1264, 200, -48},
    { 1088, 176, -80},
    { 912, 160, -184},
    { 824, 128, -264},
    { 1048, 176, -296},
    { 1128, 152, -240},
    { 1072, 32, -176},
    { 1008, 16, -192},
    { 992, 48, -224},
    { 1000, -8, -200},
    { 1016, -48, -176},
    { 1024, -24, -152},
    { 1024, -32, -144},
    { 984, -8, -160},
    { 968, 8, -192},
    { 944, 40, -224},
    { 880, 16, -272},
    { 872, 8, -304},
    { 864, 0, -304},
    { 872, -16, -336},
    { 904, 0, -360},
    { 1280, 40, -456},
    { 1368, 56, -480},
    { 1160, 96, -368},
    { 824, 96, -384},
    // 150 seconds
    { 976, 176, -408},
    { 1208, 184, -416},
    { 1152, 200, -328},
    { 1048, 168, -288},
    { 992, 144, -280},
    { 960, 136, -288},
    { 944, 120, -280},
    { 920, 72, -304},
    { 888, 40, -304},
    { 856, 0, -320},
    { 848, -40, -312},
    { 976, 24, -408},
    { 1192, 232, -576},
    { 1016, 320, -720},
    { 984, 216, -1040},
    { 904, 144, -968},
    { 768, -56, -816},
    { 776, -160, -848},
    { 608, -232, -752},
    { 448, -264, -688},
    { 384, -264, -624},
    { 376, -320, -688},
    { 328, -344, -696},
    { 296, -432, -736},
    { 248, -480, -792},
    // 151 seconds
    { 192, -544, -856},
    { 184, -536, -848},
    { 160, -552, -968},
    { 160, -584, -960},
    { 56, -544, -888},
    { 136, -568, -1080},
    { -24, -520, -984},
    { -80, -416, -912},
    { -192, -376, -880},
    { -400, -400, -904},
    { -280, -352, -960},
    { -128, -432, -920},
    { -136, -432, -864},
    { -88, -544, -776},
    { -88, -568, -696},
    { -104, -608, -664},
    { -152, -640, -616},
    { -168, -648, -592},
    { -184, -696, -576},
    { -216, -704, -560},
    { -216, -760, -520},
    { -216, -792, -512},
    { -208, -824, -496},
    { -264, -872, -544},
    { -248, -904, -560},
    // 152 seconds
    { -264, -880, -552},
    { -288, -864, -704},
    { -224, -880, -680},
    { -160, -880, -664},
    { -224, -808, -720},
    { -152, -768, -640},
    { -152, -760, -552},
    { -120, -736, -536},
    { -208, -712, -536},
    { -240, -744, -520},
    { -280, -768, -480},
    { -304, -728, -488},
    { -296, -728, -488},
    { -304, -760, -480},
    { -368, -776, -464},
    { -400, -752, -456},
    { -408, -728, -432},
    { -360, -648, -392},
    { -312, -592, -392},
    { -328, -624, -280},
    { -320, -480, -376},
    { -280, -200, -520},
    { -360, -168, -552},
    { -256, 184, -696},
    { -216, 256, -760},
    // 153 seconds
    { -72, 296, -728},
    { 200, 456, -1032},
    { 720, 392, -1136},
    { 752, 88, -1208},
    { 696, -88, -1128},
    { 680, -224, -1016},
    { 616, -272, -848},
    { 680, -312, -792},
    { 728, -280, -648},
    { 856, -168, -584},
    { 1056, -160, -432},
    { 1464, -144, -368},
    { 1432, -96, -392},
    { 1160, -48, -384},
    { 888, 8, -376},
    { 920, 32, -320},
    { 1216, 0, -280},
    { 1200, -40, -184},
    { 1144, -48, -184},
    { 1032, -96, -232},
    { 912, -112, -208},
    { 992, -72, -288},
    { 1056, -72, -312},
    { 1040, -72, -328},
    { 1048, -112, -352},
    // 154 seconds
    { 1032, -96, -392},
    { 1120, -72, -376},
    { 1072, -88, -392},
    { 1120, -80, -288},
    { 1432, -40, -288},
    { 1584, -32, -248},
    { 1152, -72, -136},
    { 888, 0, -192},
    { 1096, -8, -192},
    { 1488, -152, -80},
    { 1384, -256, -16},
    { 1160, -192, -24},
    { 1032, -160, -96},
    { 976, -112, -192},
    { 968, -80, -176},
    { 880, -128, -176},
    { 848, -104, -208},
    { 784, -96, -224},
    { 720, -120, -192},
    { 800, -72, -184},
    { 880, -72, -152},
    { 1328, 24, -200},
    { 1408, 64, -192},
    { 1328, -32, -144},
    { 1248, 16, -320},
    // 155 seconds
    { 1064, 48, -208},
    { 1208, 48, 32},
    { 1328, 56, 136},
    { 1224, 96, 136},
    { 1000, 200, 128},
    { 864, 208, 56},
    { 896, 192, -128},
    { 920, 176, -144},
    { 1040, 136, -216},
    { 968, 40, -240},
    { 928, -56, -208},
    { 1032, -96, -288},
    { 1104, -112, -248},
    { 1336, -96, -224},
    { 1672, -40, -368},
    { 1296, -56, -200},
    { 808, -32, -104},
    { 576, -32, -72},
    { 1128, 8, -176},
    { 1640, 64, -152},
    { 1232, 16, -40},
    { 1136, 0, -72},
    { 1120, 0, -80},
    { 1128, 40, -16},
    { 1080, 8, -8},
    // 156 seconds
    { 1048, -32, 0},
    { 984, -72, -40},
    { 960, -48, -64},
    { 880, -72, -56},
    { 872, -72, -80},
    { 992, -80, -16},
    { 1416, 40, -96},
    { 1248, 24, -104},
    { 1136, 32, -176},
    { 832, 40, -296},
    { 832, 56, -112},
    { 1360, 16, -32},
    { 1264, -96, 16},
    { 1048, -112, 8},
    { 960, -40, -56},
    { 920, 16, -72},
    { 976, 80, -96},
    { 1048, 64, -112},
    { 1080, -24, -144},
    { 1096, -56, -152},
    { 1048, -96, -184},
    { 1192, -112, -264},
    { 1088, -120, -256},
    { 1272, -216, -232},
    { 1568, -160, -168},
    // 157 seconds
    { 1288, -112, -96},
    { 992, -144, -8},
    { 872, -136, 24},
    { 1048, -96, 88},
    { 1272, -112, 112},
    { 1208, -72, 128},
    { 1096, -40, 144},
    { 992, -48, 88},
    { 1176, -32, 96},
    { 1008, -48, 112},
    { 1184, 16, 104},
    { 1032, -8, 80},
    { 1048, -8, 48},
    { 1040, -8, 32},
    { 1000, 0, 0},
    { 1064, 40, -88},
    { 1064, 8, -56},
    { 1120, 56, -136},
    { 1096, 56, -72},
    { 1120, 0, -112},
    { 1200, 72, -144},
    { 1248, 120, -96},
    { 1264, 112, -24},
    { 1296, 120, 32},
    { 1088, 96, 160},
    // 158 seconds
    { 1072, 168, 72},
    { 1120, 168, -16},
    { 1104, 104, -16},
    { 1072, 64, -24},
    { 1000, 24, -96},
    { 952, 0, -168},
    { 1024, -16, -224},
    { 1048, 0, -264},
    { 1024, -56, -312},
    { 976, -144, -408},
    { 1048, -80, -304},
    { 1056, 40, -184},
    { 952, -56, -144},
    { 960, -80, -192},
    { 1040, -32, -280},
    { 1024, -56, -296},
    { 1016, -72, -304},
    { 1032, -88, -280},
    { 976, -128, -224},
    { 1176, -120, -216},
    { 1256, -80, -280},
    { 1344, -120, -216},
    { 1312, -32, -296},
    { 1192, -120, -160},
    { 1088, -72, -184},
    // 159 seconds
    { 1208, -96, -136},
    { 1224, -80, -72},
    { 1208, -104, -24},
    { 1104, -104, -8},
    { 992, -64, -48},
    { 912, -16, -96},
    { 840, -40, -80},
    { 848, -24, -80},
    { 856, -48, -72},
    { 928, -32, -56},
    { 1072, -32, -104},
    { 1176, -48, -112},
    { 1320, -80, -64},
    { 1736, -80, -64},
    { 1360, -88, -64},
    { 952, -24, -216},
    { 800, 0, -192},
    { 1072, 40, -120},
    { 1192, -8, -64},
    { 1048, -24, -96},
    { 928, 24, -176},
    { 904, 32, -240},
    { 896, -16, -264},
    { 992, -48, -288},
    { 984, -40, -336},
    // 160 seconds
    { 1008, -88, -320},
    { 1040, -80, -320},
    { 1080, -128, -288},
    { 1176, -144, -264},
    { 1488, -72, -352},
    { 1240, -24, -224},
    { 1200, -32, -144},
    { 1112, -16, -104},
    { 1144, -24, 8},
    { 1248, -64, 40},
    { 1200, -64, 56},
    { 1056, -32, 48},
    { 1136, -24, 32},
    { 1144, 8, 32},
    { 1080, -8, 80},
    { 1024, -24, 104},
    { 1032, -24, 88},
    { 968, -16, 48},
    { 992, -16, 8},
    { 984, -32, -64},
    { 944, -64, -192},
    { 1312, -104, -96},
    { 1144, -112, -256},
    { 872, -96, -344},
    { 776, -120, -336},
    // 161 seconds
    { 1176, -96, -248},
    { 1312, -104, -192},
    { 1160, -112, -216},
    { 1048, -128, -248},
    { 960, -96, -264},
    { 960, -48, -200},
    { 1048, -104, -112},
    { 1000, -144, -64},
    { 1016, -120, -32},
    { 1000, -64, -8},
    { 992, -64, 0},
    { 1056, -88, 48},
    { 1128, -112, 56},
    { 1184, -120, 104},
    { 1168, -152, 144},
    { 1464, -96, 48},
    { 1304, -104, 0},
    { 1000, -200, 24},
    { 848, -336, 120},
    { 1056, -264, 56},
    { 1200, -224, 32},
    { 1056, -264, 224},
    { 1048, -224, 224},
    { 968, -168, 184},
    { 944, -96, 168},
    // 162 seconds
    { 976, -96, 136},
    { 984, -88, 112},
    { 984, -80, 88},
    { 1008, -72, 104},
    { 1096, -48, 112},
    { 1168, -48, 152},
    { 1152, -56, 128},
    { 1096, -104, 176},
    { 1512, -96, 200},
    { 1192, 32, 88},
    { 880, 88, -64},
    { 760, 32, -32},
    { 1160, -24, 32},
    { 1352, -48, -48},
    { 1024, -144, -112},
    { 1144, -1040, -248},
    { 744, -304, 192},
    { 848, -40, -16},
    { 1128, -16, -152},
    { 1104, 32, -32},
    { 1064, 24, -48},
    { 1032, -24, 8},
    { 1104, 0, -56},
    { 1160, 80, -104},
    { 1104, 40, -72},
    // 163 seconds
    { 1360, 16, -104},
    { 1376, 16, -136},
    { 1168, 8, -96},
    { 912, -24, -48},
    { 976, 64, -72},
    { 1328, 56, -96},
    { 1224, -80, -8},
    { 1000, -104, 16},
    { 1008, -56, -32},
    { 1024, -32, -16},
    { 1008, -32, 32},
    { 1024, 0, 56},
    { 1056, -32, 40},
    { 1008, -56, 40},
    { 1040, -40, 16},
    { 1064, -72, 8},
    { 1120, -72, -8},
    { 1456, -96, 16},
    { 1328, -96, 8},
    { 1096, -32, -144},
    { 784, -24, -344},
    { 752, -56, -320},
    { 1104, -104, -200},
    { 1192, -184, -120},
    { 1024, -192, -136},
    // 164 seconds
    { 952, -112, -184},
    { 968, -48, -176},
    { 976, -8, -168},
    { 968, -8, -136},
    { 920, -56, -96},
    { 992, -64, -80},
    { 1064, -40, -112},
    { 1112, -16, -128},
    { 1080, -48, -120},
    { 1112, -104, -96},
    { 1176, -136, -120},
    { 1536, -192, -120},
    { 1496, -80, -160},
    { 1000, -80, -96},
    { 720, -32, -88},
    { 992, -48, -88},
    { 1272, -64, -56},
    { 1264, -64, 0},
    { 1072, -40, 32},
    { 992, -64, 8},
    { 984, 0, 0},
    { 960, 0, 40},
    { 936, 8, 24},
    { 904, -16, 8},
    { 952, -32, 8},
    // 165 seconds
    { 976, -48, 8},
    { 1048, -72, -32},
    { 1096, -72, -56},
    { 1168, -136, -72},
    { 1768, -96, -88},
    { 1280, -88, -192},
    { 1088, -48, -304},
    { 800, -48, -448},
    { 768, 40, -424},
    { 1048, -48, -248},
    { 1208, -112, -200},
    { 1144, -120, -176},
    { 1120, -24, -192},
    { 1048, -8, -168},
    { 960, -24, -104},
    { 992, -8, -72},
    { 1008, 0, -64},
    { 992, -40, -24},
    { 928, -8, -8},
    { 936, 8, -32},
    { 976, 8, -16},
    { 1096, 72, -32},
    { 1368, 32, -16},
    { 1016, 32, -8},
    { 936, 16, -16},
    // 166 seconds
    { 1136, 88, -8},
    { 1168, 96, 88},
    { 1160, 96, 168},
    { 1080, 64, 168},
    { 1168, 56, 104},
    { 1088, 112, 112},
    { 1104, 120, 120},
    { 1104, 88, 120},
    { 1168, 64, 88},
    { 1176, 64, 120},
    { 1152, 56, 120},
    { 1176, 40, 104},
    { 1152, 16, 96},
    { 1160, 8, 72},
    { 1112, -8, 48},
    { 1064, -16, 40},
    { 1040, -8, 24},
    { 992, -8, 8},
    { 1008, -24, -40},
    { 1016, -40, -88},
    { 1080, -72, -152},
    { 1312, -136, -112},
    { 1136, -128, -104},
    { 976, -136, -104},
    { 896, -64, -328},
    // 167 seconds
    { 1136, 0, -360},
    { 1120, -16, -304},
    { 968, -88, -216},
    { 968, -144, -200},
    { 1024, -72, -152},
    { 1032, 8, -160},
    { 1008, -16, -128},
    { 976, 32, -128},
    { 1024, 112, -104},
    { 1032, 128, -96},
    { 1080, 96, -160},
    { 1096, 104, -192},
    { 1112, 0, -176},
    { 1168, -64, -240},
    { 1104, -72, -248},
    { 1224, -72, -296},
    { 1264, -16, -392},
    { 1048, 8, -392},
    { 824, -24, -272},
    { 896, 0, -208},
    { 1088, 24, -280},
    { 992, -8, -296},
    { 936, -32, -272},
    { 920, -40, -280},
    { 936, 0, -360},
    // 168 seconds
    { 1008, 8, -344},
    { 984, -48, -288},
    { 928, 0, -312},
    { 912, 16, -296},
    { 920, 40, -264},
    { 952, 56, -232},
    { 1016, 56, -184},
    { 1040, 88, -128},
    { 1056, 144, -72},
    { 1152, 128, 16},
    { 1632, 176, -40},
    { 1384, 240, -32},
    { 1168, 224, -240},
    { 800, 168, -304},
    { 856, 88, -272},
    { 1112, 8, -192},
    { 1000, -56, -136},
    { 992, -64, -192},
    { 952, -56, -256},
    { 872, -96, -240},
    { 880, -128, -264},
    { 896, -128, -272},
    { 896, -144, -264},
    { 1000, -128, -280},
    { 1040, -112, -312},
    // 169 seconds
    { 1000, -96, -320},
    { 1064, -40, -320},
    { 1016, 40, -256},
    { 1304, 104, -304},
    { 1480, 168, -328},
    { 1336, 104, -216},
    { 952, 16, -120},
    { 968, 8, -128},
    { 1440, 80, -80},
    { 1376, 128, 0},
    { 1192, 96, 24},
    { 1112, 80, -24},
    { 1088, 160, -64},
    { 1080, 152, -64},
    { 1016, 96, -80},
    { 944, 64, -176},
    { 872, 80, -272},
    { 768, 40, -384},
    { 720, 24, -408},
    { 688, -16, -528},
    { 728, -32, -544},
    { 752, -72, -560},
    { 864, -56, -472},
    { 1152, -24, -456},
    { 1008, 0, -448},
    // 170 seconds
    { 936, -40, -416},
    { 896, -56, -424},
    { 968, -88, -336},
    { 1152, -32, -288},
    { 1128, -56, -224},
    { 1032, -32, -216},
    { 920, -24, -256},
    { 880, 0, -256},
    { 920, -32, -272},
    { 1016, -80, -256},
    { 1056, -104, -264},
    { 1032, -104, -256},
    { 1008, -56, -272},
    { 976, -40, -288},
    { 992, -96, -296},
    { 1056, -128, -296},
    { 1144, -136, -304},
    { 1168, -136, -312},
    { 1224, -128, -296},
    { 1464, -72, -328},
    { 1256, -96, -256},
    { 1016, -160, -128},
    { 816, -200, -56},
    { 1112, -168, -16},
    { 1360, -120, 96},
    // 171 seconds
    { 1048, -144, 184},
    { 1104, -120, 128},
    { 1008, -144, 128},
    { 1160, -184, 104},
    { 1040, -192, 136},
    { 976, -184, 8},
    { 1152, -224, -8},
    { 1168, -232, -16},
    { 1216, -176, -64},
    { 1136, -160, -96},
    { 976, -112, -184},
    { 1064, -64, -256},
    { 1120, -88, -272},
    { 1032, -72, -320},
    { 952, -72, -272},
    { 936, -32, -288},
    { 920, -8, -272},
    { 888, -16, -272},
    { 800, -40, -344},
    { 752, 8, -400},
    { 776, 24, -456},
    { 752, 24, -520},
    { 920, -24, -528},
    { 1048, -88, -464},
    { 976, -24, -472},
    // 172 seconds
    { 1168, -24, -544},
    { 1192, -24, -560},
    { 1200, -8, -496},
    { 1024, 0, -472},
    { 1016, -40, -360},
    { 1064, -64, -344},
    { 976, -48, -272},
    { 928, 40, -272},
    { 984, 136, -344},
    { 952, 136, -280},
    { 944, 184, -304},
    { 880, 224, -360},
    { 816, 256, -400},
    { 760, 256, -496},
    { 752, 216, -520},
    { 728, 168, -528},
    { 728, 136, -520},
    { 760, 152, -488},
    { 776, 184, -448},
    { 864, 208, -392},
    { 1072, 312, -416},
    { 1192, 360, -448},
    { 1072, 288, -352},
    { 904, 336, -472},
    { 736, 288, -472},
    // 173 seconds
    { 960, 232, -440},
    { 984, 184, -376},
    { 896, 120, -304},
    { 872, 184, -368},
    { 800, 184, -400},
    { 768, 144, -400},
    { 768, 128, -392},
    { 784, 112, -408},
    { 752, 120, -424},
    { 752, 144, -488},
    { 824, 176, -520},
    { 880, 200, -576},
    { 896, 200, -544},
    { 904, 232, -528},
    { 864, 256, -528},
    { 896, 248, -536},
    { 1296, 224, -544},
    { 1360, 176, -432},
    { 1064, 104, -264},
    { 1040, 96, -256},
    { 1208, 96, -144},
    { 1184, 48, -32},
    { 1096, 80, -48},
    { 976, 112, -136},
    { 1008, 88, -136},
    // 174 seconds
    { 944, 64, -72},
    { 936, 128, -136},
    { 864, 120, -112},
    { 840, 104, -136},
    { 872, 128, -192},
    { 960, 184, -184},
    { 992, 232, -224},
    { 1040, 264, -288},
    { 1048, 256, -216},
    { 1048, 280, -208},
    { 1048, 272, -168},
    { 1064, 256, -104},
    { 1088, 240, -56},
    { 1128, 232, 24},
    { 1184, 216, -24},
    { 1304, 248, -144},
    { 1416, 264, -352},
    { 1600, 216, -296},
    { 1048, 248, -464},
    { 576, 312, -824},
    { 632, 288, -736},
    { 832, 192, -760},
    { 856, 88, -504},
    { 920, -8, -288},
    { 944, -40, -176},
    // 175 seconds
    { 904, -32, -80},
    { 864, 64, -48},
    { 920, 184, -56},
    { 1000, 256, -16},
    { 1040, 288, 8},
    { 1040, 312, 16},
    { 1136, 336, 56},
    { 1288, 344, 56},
    { 1392, 312, 48},
    { 1296, 272, 72},
    { 1296, 288, 32},
    { 1312, 304, 24},
    { 1264, 304, 40},
    { 1168, 328, 24},
    { 1072, 384, -40},
    { 984, 504, -96},
    { 904, 520, -112},
    { 792, 584, -152},
    { 656, 544, -264},
    { 536, 648, -328},
    { 464, 576, -496},
    { 328, 600, -560},
    { 320, 552, -568},
    { 256, 560, -600},
    { 248, 608, -592},
    // 176 seconds
    { 168, 600, -520},
    { 160, 640, -512},
    { 48, 704, -528},
    { 8, 808, -520},
    { -72, 896, -504},
    { -96, 896, -504},
    { -152, 1032, -488},
    { 16, 968, -520},
    { -72, 808, -368},
    { -160, 776, -352},
    { -288, 624, -256},
    { -400, 640, -296},
    { -328, 568, -376},
    { -384, 592, -320},
    { -208, 864, -400},
    { -296, 752, -288},
    { -184, 728, -344},
    { -184, 920, -416},
    { -160, 744, -312},
    { -64, 792, -528},
    { -24, 800, -552},
    { -160, 648, -528},
    { -72, 824, -728},
    { -72, 648, -704},
    { -200, 528, -728},
    // 177 seconds
    { -160, 608, -1024},
    { -72, 136, -832},
    { -112, -288, -728},
    { -104, -288, -776},
    { -120, -416, -824},
    { -120, -352, -920},
    { -184, -472, -880},
    { -200, -448, -872},
    { -216, -448, -856},
    { -224, -384, -848},
    { -200, -360, -888},
    { -176, -296, -936},
    { -184, -304, -936},
    { -200, -320, -896},
    { -256, -304, -888},
    { -240, -336, -856},
    { -280, -360, -784},
    { -248, -376, -768},
    { -328, -272, -856},
    { -368, -248, -792},
    { -400, -312, -816},
    { -400, -344, -840},
    { -360, -328, -824},
    { -344, -344, -856},
    { -368, -304, -832},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 20:34:58 local
AccelRawData *activity_sample_walk_200_pbl_25675_12(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25675_12
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 140
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -152, -336, -864},
    { -152, -392, -880},
    { -168, -352, -904},
    { -176, -384, -920},
    { -216, -344, -920},
    { -224, -360, -928},
    { -288, -320, -864},
    { -304, -256, -872},
    { -344, -232, -784},
    { -360, -280, -784},
    { -280, -176, -808},
    { -312, -144, -808},
    { -368, -304, -840},
    { -480, -312, -752},
    { -448, -368, -728},
    { -480, -192, -816},
    { -440, -256, -816},
    { -472, -296, -816},
    { -408, -296, -824},
    { -384, -272, -864},
    { -328, -232, -856},
    { -384, -248, -848},
    { -336, -240, -832},
    { -360, -240, -824},
    { -424, -248, -824},
    // 1 seconds
    { -368, -272, -808},
    { -464, -232, -816},
    { -368, -88, -832},
    { -424, -360, -784},
    { -384, -248, -816},
    { -448, -136, -840},
    { -424, -192, -816},
    { -392, -264, -816},
    { -472, -216, -848},
    { -384, -248, -816},
    { -440, -232, -824},
    { -384, -240, -824},
    { -408, -240, -816},
    { -408, -240, -816},
    { -392, -256, -816},
    { -392, -240, -824},
    { -392, -256, -824},
    { -392, -256, -808},
    { -384, -248, -816},
    { -400, -248, -824},
    { -416, -240, -840},
    { -344, -264, -848},
    { -376, -256, -832},
    { -336, -280, -816},
    { -296, -304, -792},
    // 2 seconds
    { -224, -296, -728},
    { -160, -264, -664},
    { -160, -264, -648},
    { -264, -152, -704},
    { -248, -72, -784},
    { -248, 272, -864},
    { -328, 584, -848},
    { -328, 600, -800},
    { -336, 752, -736},
    { -296, 848, -552},
    { -272, 936, -472},
    { -176, 928, -496},
    { -168, 800, -360},
    { -56, 904, -304},
    { -72, 904, -240},
    { -72, 928, -136},
    { -56, 920, -192},
    { -192, 800, -144},
    { -152, 824, -208},
    { -120, 808, -240},
    { -120, 904, -296},
    { -136, 800, -240},
    { -152, 872, -368},
    { -136, 768, -304},
    { -216, 864, -360},
    // 3 seconds
    { -208, 760, -408},
    { -296, 872, -432},
    { -240, 832, -440},
    { -272, 768, -608},
    { -232, 632, -616},
    { -280, 504, -568},
    { -272, 344, -648},
    { -304, 344, -520},
    { -376, 312, -600},
    { -360, 224, -536},
    { -400, 680, -528},
    { -448, 496, -632},
    { -400, 552, -656},
    { -480, 480, -544},
    { -456, 440, -520},
    { -504, 584, -584},
    { -480, 448, -520},
    { -488, 496, -568},
    { -464, 456, -552},
    { -448, 496, -536},
    { -456, 504, -544},
    { -464, 576, -456},
    { -464, 472, -544},
    { -464, 576, -536},
    { -464, 424, -584},
    // 4 seconds
    { -480, 632, -496},
    { -464, 712, -480},
    { -464, 680, -480},
    { -456, 568, -488},
    { -448, 440, -536},
    { -488, 408, -512},
    { -472, 520, -576},
    { -464, 472, -552},
    { -536, 520, -544},
    { -496, 464, -536},
    { -496, 496, -552},
    { -504, 416, -560},
    { -480, 448, -560},
    { -504, 456, -568},
    { -464, 400, -568},
    { -480, 424, -576},
    { -464, 480, -608},
    { -488, 368, -608},
    { -472, 448, -680},
    { -488, 360, -664},
    { -488, 256, -616},
    { -472, 320, -712},
    { -496, 288, -696},
    { -480, 176, -656},
    { -464, 176, -672},
    // 5 seconds
    { -472, 152, -656},
    { -480, 216, -640},
    { -504, 288, -608},
    { -448, 392, -664},
    { -440, 408, -624},
    { -456, 432, -560},
    { -448, 424, -568},
    { -424, 424, -544},
    { -344, 448, -640},
    { -400, 512, -608},
    { -392, 464, -552},
    { -328, 408, -528},
    { -264, 256, -664},
    { -176, 560, -608},
    { -208, 592, -592},
    { -176, 608, -600},
    { 0, 624, -584},
    { 112, 440, -544},
    { 248, 824, -480},
    { 416, 936, -568},
    { 584, 752, -304},
    { 632, 952, -344},
    { 752, 1096, -416},
    { 696, 960, -336},
    { 648, 800, -384},
    // 6 seconds
    { 592, 672, -392},
    { 608, 568, -392},
    { 600, 408, -400},
    { 640, 336, -384},
    { 704, 312, -424},
    { 744, 368, -448},
    { 808, 320, -416},
    { 792, 304, -448},
    { 832, 320, -512},
    { 816, 248, -472},
    { 864, 208, -432},
    { 904, 128, -392},
    { 1000, 80, -328},
    { 1216, 48, -408},
    { 1336, 0, -424},
    { 1600, -16, -352},
    { 1304, -8, -392},
    { 1032, -32, -504},
    { 712, -32, -488},
    { 656, -88, -408},
    { 944, -72, -296},
    { 1160, 0, -152},
    { 1312, 8, -96},
    { 1120, 16, -80},
    { 1016, 120, -128},
    // 7 seconds
    { 952, 128, -104},
    { 920, 112, -160},
    { 888, 104, -168},
    { 848, 120, -216},
    { 808, 80, -280},
    { 872, 144, -392},
    { 936, 192, -400},
    { 1008, 208, -408},
    { 1000, 152, -464},
    { 1216, 240, -448},
    { 1176, 224, -392},
    { 1200, 280, -384},
    { 1136, 200, -336},
    { 952, 256, -272},
    { 936, 288, -296},
    { 840, 248, -280},
    { 824, 240, -256},
    { 824, 216, -312},
    { 936, 160, -336},
    { 920, 80, -336},
    { 952, 80, -352},
    { 1000, -8, -368},
    { 1136, -96, -408},
    { 1168, -112, -392},
    { 1008, -80, -400},
    // 8 seconds
    { 1032, -40, -416},
    { 952, -56, -344},
    { 928, -40, -272},
    { 904, -40, -256},
    { 872, -40, -216},
    { 856, -32, -232},
    { 912, -16, -232},
    { 1040, -32, -280},
    { 1008, -56, -288},
    { 1040, -64, -304},
    { 1152, -80, -296},
    { 1152, -72, -256},
    { 1056, -24, -224},
    { 1040, 16, -264},
    { 992, 40, -272},
    { 984, 8, -264},
    { 1016, -32, -272},
    { 1048, -56, -248},
    { 1024, -48, -216},
    { 1056, -48, -216},
    { 1136, -16, -208},
    { 1120, -32, -184},
    { 1280, -24, -160},
    { 1320, -32, -184},
    { 1056, -64, -168},
    // 9 seconds
    { 1024, -48, -320},
    { 968, 8, -328},
    { 1104, -48, -216},
    { 1232, -56, -72},
    { 1176, -48, -16},
    { 1160, -8, -32},
    { 1080, 16, -40},
    { 1072, 120, -104},
    { 1040, 136, -208},
    { 952, 120, -176},
    { 856, 112, -248},
    { 792, 160, -336},
    { 696, 160, -416},
    { 640, 216, -448},
    { 680, 320, -560},
    { 696, 336, -408},
    { 1056, 576, -680},
    { 976, 440, -600},
    { 776, 408, -480},
    { 840, 304, -384},
    { 944, 264, -384},
    { 776, 232, -392},
    { 768, 176, -352},
    { 888, 168, -448},
    { 888, 176, -432},
    // 10 seconds
    { 848, 152, -464},
    { 848, 48, -448},
    { 760, 96, -544},
    { 792, 64, -648},
    { 816, -8, -544},
    { 840, -32, -424},
    { 936, -24, -304},
    { 1032, 48, -224},
    { 1104, 48, -144},
    { 1384, 80, 56},
    { 1744, 232, 80},
    { 1152, 200, -24},
    { 808, 96, -296},
    { 1016, 144, -264},
    { 1192, 64, -48},
    { 952, -96, -24},
    { 952, -120, -48},
    { 1032, 24, -216},
    { 872, 0, -256},
    { 824, -64, -240},
    { 1024, -48, -288},
    { 1032, -72, -328},
    { 1040, -144, -288},
    { 1072, -152, -296},
    { 1096, -88, -320},
    // 11 seconds
    { 1096, -104, -312},
    { 1344, -136, -240},
    { 1712, -72, -192},
    { 1168, -16, -152},
    { 888, 40, -104},
    { 1136, 88, -24},
    { 1296, 120, 16},
    { 968, 296, 96},
    { 952, -144, 168},
    { 992, 104, -256},
    { 992, 216, -208},
    { 936, 24, -128},
    { 912, -136, -192},
    { 920, -144, -264},
    { 936, -152, -256},
    { 1016, -192, -232},
    { 1056, -264, -176},
    { 1024, -288, -184},
    { 1400, -280, -176},
    { 1392, -168, -272},
    { 1008, -80, -312},
    { 704, -16, -272},
    { 888, 16, -256},
    { 1128, 72, -128},
    { 1008, -8, -64},
    // 12 seconds
    { 944, 32, -64},
    { 848, 40, -88},
    { 864, 8, -224},
    { 952, 16, -256},
    { 936, -96, -312},
    { 1072, -128, -344},
    { 1064, -168, -352},
    { 1096, -144, -344},
    { 1104, -192, -312},
    { 1080, -192, -288},
    { 1264, -232, -256},
    { 1704, -232, -288},
    { 1328, -160, -176},
    { 864, -72, -96},
    { 848, -24, -104},
    { 1136, 40, -112},
    { 1176, -96, 16},
    { 1024, -224, 176},
    { 1032, -152, -16},
    { 1080, -8, -88},
    { 1048, -56, -88},
    { 1056, -80, -112},
    { 976, -88, -192},
    { 920, -120, -232},
    { 976, -136, -216},
    // 13 seconds
    { 928, -136, -192},
    { 896, -96, -192},
    { 984, -16, -200},
    { 1120, 0, -176},
    { 1336, -48, -176},
    { 1664, -40, -208},
    { 1168, -88, -136},
    { 952, -104, -168},
    { 864, -104, -160},
    { 1136, -128, -64},
    { 1104, -72, -32},
    { 992, -24, -8},
    { 896, 8, 16},
    { 832, 128, 48},
    { 800, 168, -56},
    { 888, 96, -144},
    { 976, 48, -176},
    { 984, -24, -248},
    { 1016, -72, -320},
    { 1136, -72, -376},
    { 1168, -112, -368},
    { 1176, -96, -360},
    { 1248, -88, -384},
    { 1224, -160, -240},
    { 1392, -328, -48},
    // 14 seconds
    { 1544, -320, -72},
    { 1072, -312, 32},
    { 816, -296, 32},
    { 800, -264, 104},
    { 1264, -264, 184},
    { 1104, -240, 256},
    { 944, -296, 336},
    { 1016, -240, 248},
    { 1088, -184, 264},
    { 1128, -208, 232},
    { 1136, -224, 232},
    { 1056, -208, 152},
    { 1152, -224, 120},
    { 1032, -248, 112},
    { 1128, -256, 96},
    { 1096, -240, 112},
    { 1104, -216, 120},
    { 1016, -224, 120},
    { 1024, -152, 64},
    { 1016, -104, 56},
    { 984, -104, 16},
    { 1024, -96, 32},
    { 1048, -144, 48},
    { 1152, -144, 16},
    { 1104, -176, 8},
    // 15 seconds
    { 1080, -152, -32},
    { 1024, -136, -48},
    { 1024, -120, -96},
    { 1016, -136, -64},
    { 1032, -120, -56},
    { 1032, -112, -64},
    { 1000, -88, -56},
    { 1048, -96, -72},
    { 1072, -96, -80},
    { 1040, -112, -112},
    { 1056, -96, -152},
    { 1048, -168, -144},
    { 1032, -256, -120},
    { 1064, -344, -112},
    { 1080, -360, -224},
    { 1160, -584, -360},
    { 1320, -456, -376},
    { 1152, -280, -160},
    { 1128, -120, -136},
    { 984, -80, -112},
    { 1056, -88, -128},
    { 1344, -104, -80},
    { 1304, -72, -24},
    { 1072, -16, -24},
    { 952, -16, -48},
    // 16 seconds
    { 952, 0, -16},
    { 968, 48, -24},
    { 944, -32, -16},
    { 936, -40, -104},
    { 904, -48, -128},
    { 936, -64, -136},
    { 992, -56, -144},
    { 1048, -80, -104},
    { 1112, -72, -96},
    { 1256, -120, -48},
    { 1672, -96, -64},
    { 1264, -72, -128},
    { 944, -64, -256},
    { 688, -104, -272},
    { 1024, -88, -120},
    { 1304, -48, -32},
    { 1112, -48, -40},
    { 896, -32, -144},
    { 880, -48, -168},
    { 896, -40, -136},
    { 1024, -40, -176},
    { 1064, -64, -168},
    { 1024, -80, -168},
    { 1080, -72, -136},
    { 1184, -80, -144},
    // 17 seconds
    { 1168, -72, -88},
    { 1416, -40, -72},
    { 1392, -56, -192},
    { 1184, -24, -144},
    { 976, -80, -72},
    { 952, -112, -80},
    { 1272, -8, -128},
    { 1288, -40, 0},
    { 1112, -104, 32},
    { 1072, -144, 0},
    { 992, -128, 40},
    { 920, -72, -8},
    { 904, -64, -40},
    { 888, -40, -32},
    { 872, -72, -16},
    { 920, -96, -56},
    { 968, -120, -96},
    { 1136, -136, -24},
    { 1632, -80, -88},
    { 1360, -88, -128},
    { 1072, -80, -280},
    { 768, -72, -288},
    { 1048, -64, -120},
    { 1296, -104, -56},
    { 1160, -96, -88},
    // 18 seconds
    { 1016, -72, -176},
    { 904, -80, -224},
    { 904, -96, -184},
    { 984, -80, -192},
    { 1016, -168, -160},
    { 1056, -184, -176},
    { 992, -224, -152},
    { 1040, -232, -136},
    { 1104, -224, -128},
    { 1096, -232, -120},
    { 1312, -224, -72},
    { 1440, -208, -128},
    { 1216, -192, -96},
    { 896, -168, -56},
    { 912, -136, 16},
    { 1216, -136, 24},
    { 1296, -136, -8},
    { 1016, -72, -80},
    { 992, -96, -104},
    { 944, -80, -24},
    { 952, -48, -24},
    { 1064, -32, -48},
    { 992, 0, -40},
    { 976, 0, -48},
    { 944, 8, -16},
    // 19 seconds
    { 1040, 32, -16},
    { 1136, 40, -16},
    { 1328, -8, 72},
    { 1576, 32, 0},
    { 1288, 40, -144},
    { 936, 56, -328},
    { 688, -40, -424},
    { 944, -16, -296},
    { 1224, -208, -96},
    { 1112, -224, -224},
    { 1016, -160, -368},
    { 1016, -160, -328},
    { 968, -184, -192},
    { 1080, -136, -136},
    { 1056, -160, -80},
    { 1072, -168, -96},
    { 992, -176, -88},
    { 976, -112, -104},
    { 984, -120, -144},
    { 968, -136, -136},
    { 976, -112, -192},
    { 936, -120, -184},
    { 1104, -136, -128},
    { 1440, -64, -192},
    { 1272, -8, -328},
    // 20 seconds
    { 1008, -16, -224},
    { 960, -24, -72},
    { 1232, 24, -72},
    { 1168, -64, -88},
    { 1000, -88, -96},
    { 936, -88, -88},
    { 928, -88, -104},
    { 952, -112, -80},
    { 960, -112, -112},
    { 984, -144, -136},
    { 944, -96, -120},
    { 1040, -48, -200},
    { 992, -40, -168},
    { 1256, -48, -168},
    { 1416, -32, -224},
    { 1144, -8, -320},
    { 792, -64, -304},
    { 888, -104, -192},
    { 1200, -88, -152},
    { 1096, -104, -112},
    { 1056, -88, -96},
    { 1024, -32, -88},
    { 1032, 40, -80},
    { 1032, 24, -40},
    { 1040, 0, 0},
    // 21 seconds
    { 1048, 0, 8},
    { 1048, 16, 48},
    { 1104, 8, 88},
    { 1152, 72, 72},
    { 1136, 128, 96},
    { 1176, 104, 144},
    { 1064, 72, 168},
    { 1056, 32, 176},
    { 1064, 96, 136},
    { 1024, 120, 104},
    { 1016, 112, 96},
    { 1024, 144, 112},
    { 1064, 120, 128},
    { 1088, 56, 128},
    { 1128, 32, 152},
    { 1128, 16, 112},
    { 1184, -32, 88},
    { 1280, -104, 88},
    { 1248, -168, 128},
    { 1200, -184, -40},
    { 968, -160, -88},
    { 776, -200, -32},
    { 1008, -200, 24},
    { 1192, -96, -48},
    { 1008, -120, -40},
    // 22 seconds
    { 1080, -96, -112},
    { 1080, -32, -88},
    { 1064, -32, -72},
    { 1008, -16, -8},
    { 1008, -64, -80},
    { 1000, -56, -80},
    { 936, -64, -144},
    { 904, -80, -232},
    { 904, -24, -336},
    { 968, -72, -416},
    { 960, -120, -344},
    { 984, -136, -392},
    { 984, -56, -400},
    { 1064, -16, -392},
    { 1360, 40, -408},
    { 1192, -8, -440},
    { 960, -24, -384},
    { 728, -8, -288},
    { 960, 64, -312},
    { 1096, 72, -288},
    { 1008, 80, -304},
    { 1000, 104, -320},
    { 1016, 144, -360},
    { 976, 104, -368},
    { 1016, 40, -408},
    // 23 seconds
    { 960, -8, -400},
    { 1008, -56, -424},
    { 944, -112, -448},
    { 904, -160, -408},
    { 864, -168, -440},
    { 784, -224, -440},
    { 856, -216, -440},
    { 768, -216, -448},
    { 768, -240, -416},
    { 1056, -200, -232},
    { 1424, -128, -288},
    { 1256, -200, -304},
    { 888, -296, -360},
    { 976, -288, -304},
    { 1112, -256, -304},
    { 1064, -248, -200},
    { 1000, -320, -184},
    { 888, -240, -168},
    { 792, -224, -240},
    { 848, -152, -248},
    { 824, -184, -232},
    { 864, -152, -240},
    { 880, -128, -296},
    { 928, -128, -320},
    { 1008, -192, -328},
    // 24 seconds
    { 1096, -208, -280},
    { 1160, -192, -288},
    { 1160, -208, -256},
    { 1416, -216, -328},
    { 1368, -264, -344},
    { 1104, -256, -288},
    { 824, -192, -280},
    { 856, -144, -296},
    { 1144, -184, -264},
    { 1280, -184, -240},
    { 1112, -192, -160},
    { 976, -160, -184},
    { 976, -128, -192},
    { 992, -128, -144},
    { 976, -160, -104},
    { 976, -152, -96},
    { 944, -144, -72},
    { 976, -128, -64},
    { 1008, -128, -56},
    { 1032, -128, -80},
    { 1080, -152, -80},
    { 1440, -144, -120},
    { 1352, -152, -144},
    { 1072, -136, -216},
    { 736, -168, -248},
    // 25 seconds
    { 880, -136, -192},
    { 1208, -96, -152},
    { 1064, -112, -104},
    { 952, -88, -128},
    { 912, -72, -136},
    { 888, -80, -152},
    { 952, -128, -128},
    { 984, -112, -168},
    { 984, -104, -168},
    { 1000, -112, -208},
    { 1088, -128, -208},
    { 1160, -128, -208},
    { 1144, -136, -200},
    { 1328, -136, -240},
    { 1352, -120, -312},
    { 1168, -80, -264},
    { 856, -104, -168},
    { 952, -64, -144},
    { 1264, -24, -152},
    { 1344, -48, -64},
    { 1168, -72, -16},
    { 1088, -80, 8},
    { 1056, -48, 16},
    { 1024, -32, 40},
    { 984, -16, 48},
    // 26 seconds
    { 952, -56, 8},
    { 976, -80, -8},
    { 936, -96, 0},
    { 976, -104, -32},
    { 1024, -112, -48},
    { 1176, -152, -48},
    { 1448, -104, -88},
    { 1120, -128, -112},
    { 1000, -104, -256},
    { 840, -96, -264},
    { 1008, -104, -160},
    { 1304, -104, -88},
    { 1128, -88, -80},
    { 1000, -40, -136},
    { 928, -8, -160},
    { 872, -48, -152},
    { 952, -80, -128},
    { 1008, -80, -176},
    { 1016, -80, -176},
    { 1048, -88, -216},
    { 1016, -96, -208},
    { 1096, -104, -216},
    { 1112, -128, -200},
    { 1168, -120, -168},
    { 1432, -144, -128},
    // 27 seconds
    { 1432, -160, -104},
    { 1112, -208, -32},
    { 896, -216, -24},
    { 832, -208, 24},
    { 1224, -200, 72},
    { 1264, -200, 144},
    { 1080, -208, 144},
    { 1064, -144, 96},
    { 1056, -152, 88},
    { 1064, -88, 96},
    { 1096, -176, 56},
    { 1064, -160, 16},
    { 1088, -168, -72},
    { 1120, -192, -48},
    { 1128, -192, -40},
    { 1312, -208, 40},
    { 1304, -120, -24},
    { 1352, 112, -176},
    { 1136, 176, -272},
    { 1136, 256, -496},
    { 1048, 312, -496},
    { 968, 456, -568},
    { 856, 504, -480},
    { 688, 544, -496},
    { 584, 496, -320},
    // 28 seconds
    { 456, 592, -344},
    { 352, 616, -288},
    { 256, 592, -208},
    { 80, 672, -216},
    { 16, 624, -208},
    { -88, 656, -192},
    { -152, 632, -176},
    { -176, 648, -168},
    { -208, 744, -240},
    { -208, 816, -216},
    { -216, 840, -248},
    { -256, 864, -248},
    { -272, 1016, -216},
    { -200, 976, -160},
    { -40, 984, -104},
    { 32, 840, -176},
    { -88, 840, -104},
    { -144, 816, -96},
    { -32, 840, -112},
    { -72, 832, -64},
    { -96, 872, -48},
    { -128, 872, -72},
    { -120, 808, -72},
    { -152, 824, -80},
    { -176, 864, -112},
    // 29 seconds
    { -152, 888, -128},
    { -112, 912, -168},
    { -120, 864, -200},
    { -128, 824, -176},
    { -96, 800, -216},
    { 0, 728, -280},
    { 24, 680, -424},
    { 104, 632, -336},
    { 248, 272, -336},
    { 600, 416, -552},
    { 648, 184, -544},
    { 560, 40, -512},
    { 736, -152, -392},
    { 984, -136, -496},
    { 1224, 0, -560},
    { 1248, -16, -552},
    { 1152, -136, -432},
    { 1168, -152, -424},
    { 1264, -200, -472},
    { 1240, -112, -512},
    { 1144, -144, -456},
    { 1128, -48, -432},
    { 1120, 16, -472},
    { 1056, 72, -456},
    { 1296, 88, -256},
    // 30 seconds
    { 1216, 72, -224},
    { 1184, 112, -128},
    { 1064, 224, -8},
    { 1048, 160, 144},
    { 1456, 304, 328},
    { 1464, 272, 432},
    { 1432, 184, 448},
    { 1304, 184, 368},
    { 1272, 232, 336},
    { 1144, 184, 280},
    { 1184, 88, 176},
    { 1192, 112, -32},
    { 1160, 128, -64},
    { 1192, 152, -104},
    { 1120, 128, -256},
    { 1128, 168, -360},
    { 1240, 160, -560},
    { 1200, 208, -768},
    { 872, 24, -704},
    { 640, 72, -696},
    { 512, 184, -744},
    { 480, 160, -720},
    { 408, 360, -728},
    { 296, 384, -744},
    { 176, 528, -696},
    // 31 seconds
    { 32, 416, -552},
    { -136, 376, -480},
    { -144, 544, -520},
    { -120, 464, -552},
    { -168, 472, -448},
    { -240, 464, -384},
    { -320, 480, -440},
    { -384, 632, -496},
    { -448, 520, -464},
    { -480, 456, -432},
    { -592, 640, -536},
    { -296, 1000, -576},
    { 48, 888, -480},
    { 128, 688, -344},
    { -248, 616, -288},
    { -384, 800, -264},
    { -64, 760, -360},
    { -32, 704, -424},
    { -232, 664, -440},
    { -224, 592, -448},
    { -232, 680, -480},
    { -296, 712, -456},
    { -352, 736, -376},
    { -336, 792, -360},
    { -352, 776, -328},
    // 32 seconds
    { -352, 768, -336},
    { -352, 720, -288},
    { -368, 696, -288},
    { -352, 784, -368},
    { -288, 880, -376},
    { -248, 976, -408},
    { -112, 968, -496},
    { -16, 848, -472},
    { -40, 672, -448},
    { -96, 640, -392},
    { -32, 696, -392},
    { 0, 704, -384},
    { -32, 744, -384},
    { -128, 768, -392},
    { -128, 752, -440},
    { -152, 752, -456},
    { -144, 728, -496},
    { -152, 688, -504},
    { -176, 664, -544},
    { -192, 632, -520},
    { -224, 632, -504},
    { -248, 656, -496},
    { -240, 624, -464},
    { -200, 648, -488},
    { -144, 680, -416},
    // 33 seconds
    { -120, 960, -416},
    { 72, 1104, -448},
    { 288, 1120, -400},
    { 344, 760, -368},
    { 104, 704, -400},
    { -56, 784, -376},
    { 88, 824, -384},
    { 136, 816, -384},
    { -8, 824, -424},
    { -24, 728, -392},
    { 8, 656, -360},
    { -32, 680, -360},
    { -40, 704, -368},
    { -56, 752, -376},
    { -72, 776, -352},
    { -112, 800, -328},
    { -88, 824, -328},
    { -80, 864, -328},
    { -72, 1096, -384},
    { 80, 1072, -328},
    { 72, 1024, -360},
    { 72, 848, -344},
    { 56, 704, -336},
    { 56, 760, -368},
    { 104, 800, -320},
    // 34 seconds
    { 112, 768, -312},
    { 48, 768, -344},
    { 0, 712, -344},
    { 8, 664, -336},
    { -40, 672, -360},
    { -80, 688, -360},
    { -104, 736, -408},
    { -128, 784, -424},
    { -144, 800, -432},
    { -192, 832, -416},
    { -168, 840, -416},
    { -160, 848, -360},
    { -232, 1232, -456},
    { 112, 1072, -320},
    { 136, 1008, -352},
    { 24, 816, -264},
    { 16, 760, -192},
    { -8, 760, -128},
    { 8, 776, -120},
    { -16, 800, -128},
    { -40, 824, -136},
    { -40, 824, -128},
    { -56, 880, -136},
    { -48, 952, -168},
    { -48, 1016, -208},
    // 35 seconds
    { -8, 992, -232},
    { 16, 912, -296},
    { 0, 864, -304},
    { 24, 832, -312},
    { 0, 808, -312},
    { -40, 800, -256},
    { -64, 872, -264},
    { -56, 936, -264},
    { -24, 920, -256},
    { -24, 920, -256},
    { -24, 864, -256},
    { -32, 808, -240},
    { -24, 752, -248},
    { -48, 752, -264},
    { -88, 816, -280},
    { 0, 968, -352},
    { 120, 928, -352},
    { 24, 824, -344},
    { -8, 736, -312},
    { 56, 768, -376},
    { 88, 752, -384},
    { 88, 760, -416},
    { 96, 760, -440},
    { 112, 736, -440},
    { 112, 696, -488},
    // 36 seconds
    { 64, 672, -488},
    { 48, 672, -512},
    { 40, 680, -544},
    { 64, 752, -584},
    { 64, 736, -600},
    { -32, 800, -608},
    { -40, 904, -592},
    { -16, 1008, -576},
    { 48, 936, -512},
    { 32, 632, -376},
    { -72, 512, -272},
    { -120, 560, -264},
    { -112, 688, -304},
    { -32, 1032, -376},
    { 72, 968, -376},
    { 16, 888, -384},
    { 0, 744, -336},
    { 0, 672, -344},
    { 8, 688, -376},
    { 16, 704, -400},
    { 8, 736, -432},
    { 8, 784, -464},
    { 24, 840, -512},
    { 56, 856, -528},
    { 56, 992, -600},
    // 37 seconds
    { 176, 944, -560},
    { 200, 832, -528},
    { 184, 640, -456},
    { 112, 544, -424},
    { 80, 664, -496},
    { 224, 736, -440},
    { 264, 728, -464},
    { 152, 704, -488},
    { 80, 624, -464},
    { 72, 616, -488},
    { 72, 600, -488},
    { 16, 632, -512},
    { -16, 672, -536},
    { -56, 688, -568},
    { -72, 720, -600},
    { -40, 736, -592},
    { -24, 776, -624},
    { 40, 784, -608},
    { 56, 872, -560},
    { 104, 1040, -600},
    { 304, 1016, -520},
    { 312, 808, -432},
    { 104, 584, -320},
    { 8, 680, -312},
    { 128, 728, -328},
    // 38 seconds
    { 144, 784, -328},
    { 96, 840, -368},
    { 72, 752, -360},
    { 48, 688, -368},
    { 40, 704, -392},
    { 16, 728, -432},
    { 48, 744, -472},
    { 16, 712, -472},
    { -32, 704, -504},
    { -32, 752, -536},
    { -32, 768, -536},
    { 0, 784, -520},
    { -16, 832, -464},
    { -48, 1104, -520},
    { 160, 1104, -424},
    { 224, 1032, -464},
    { 272, 808, -464},
    { 224, 616, -432},
    { 192, 584, -360},
    { 144, 608, -360},
    { 120, 632, -392},
    { 16, 688, -416},
    { -104, 640, -416},
    { -136, 664, -400},
    { -184, 680, -416},
    // 39 seconds
    { -144, 712, -440},
    { -152, 744, -456},
    { -200, 728, -424},
    { -240, 752, -408},
    { -240, 760, -360},
    { -320, 880, -360},
    { -136, 1120, -400},
    { -48, 1048, -360},
    { -8, 832, -280},
    { -208, 776, -256},
    { -120, 808, -264},
    { -72, 832, -248},
    { -24, 840, -312},
    { 0, 832, -320},
    { -32, 760, -288},
    { -56, 720, -304},
    { -32, 688, -312},
    { -56, 680, -352},
    { -96, 688, -360},
    { -104, 704, -400},
    { -112, 760, -424},
    { -112, 792, -424},
    { -112, 880, -440},
    { -64, 984, -472},
    { 16, 1000, -488},
    // 40 seconds
    { 112, 856, -448},
    { 72, 640, -392},
    { 8, 648, -424},
    { 88, 792, -448},
    { 240, 904, -464},
    { 264, 832, -488},
    { 80, 648, -408},
    { -216, 592, -464},
    { -88, 640, -504},
    { 0, 736, -552},
    { -8, 720, -552},
    { 64, 704, -552},
    { 88, 720, -560},
    { 104, 768, -584},
    { 160, 816, -600},
    { 232, 920, -696},
    { 320, 808, -616},
    { 280, 632, -536},
    { 96, 488, -464},
    { -8, 584, -440},
    { 32, 760, -424},
    { 152, 904, -408},
    { 184, 944, -432},
    { 80, 792, -392},
    { 40, 712, -360},
    // 41 seconds
    { 88, 688, -392},
    { 48, 736, -448},
    { 32, 752, -448},
    { 24, 768, -432},
    { 0, 792, -456},
    { 24, 808, -440},
    { 48, 840, -456},
    { 40, 976, -480},
    { 224, 1112, -504},
    { 280, 1040, -488},
    { 288, 808, -456},
    { 200, 560, -384},
    { 160, 544, -400},
    { 200, 632, -368},
    { 240, 664, -360},
    { 280, 736, -432},
    { 184, 720, -432},
    { 88, 664, -432},
    { 32, 664, -408},
    { 32, 688, -464},
    { 16, 728, -480},
    { -16, 760, -488},
    { -32, 776, -496},
    { -32, 808, -512},
    { 0, 832, -472},
    // 42 seconds
    { 24, 856, -400},
    { 8, 1168, -488},
    { 232, 1152, -472},
    { 304, 1072, -440},
    { 248, 736, -320},
    { 144, 632, -264},
    { 216, 768, -304},
    { 352, 856, -304},
    { 328, 784, -312},
    { 216, 728, -312},
    { 200, 696, -288},
    { 216, 696, -312},
    { 200, 792, -408},
    { 208, 784, -432},
    { 240, 808, -448},
    { 192, 776, -440},
    { 184, 776, -456},
    { 200, 880, -440},
    { 240, 952, -512},
    { 248, 752, -416},
    { 240, 744, -496},
    { 264, 656, -552},
    { 240, 592, -592},
    { 200, 552, -664},
    { 200, 472, -816},
    // 43 seconds
    { 224, 464, -888},
    { 200, 504, -808},
    { 200, 488, -760},
    { 216, 520, -728},
    { 200, 472, -680},
    { 176, 408, -688},
    { 168, 360, -752},
    { 200, 328, -824},
    { 224, 312, -832},
    { 216, 328, -840},
    { 216, 320, -832},
    { 200, 320, -864},
    { 200, 304, -912},
    { 184, 304, -912},
    { 168, 464, -1048},
    { 296, 672, -1072},
    { 256, 600, -856},
    { 184, 424, -648},
    { 80, 376, -528},
    { 32, 456, -568},
    { 64, 648, -720},
    { 168, 720, -768},
    { 104, 600, -632},
    { 40, 512, -544},
    { 8, 504, -536},
    // 44 seconds
    { 8, 528, -568},
    { -8, 568, -592},
    { 8, 648, -656},
    { 80, 688, -728},
    { 56, 664, -704},
    { 16, 592, -680},
    { 8, 600, -688},
    { 0, 640, -688},
    { 0, 736, -744},
    { 120, 968, -888},
    { 200, 888, -800},
    { 152, 672, -624},
    { 96, 520, -504},
    { 112, 504, -520},
    { 176, 592, -560},
    { 176, 600, -512},
    { 168, 624, -520},
    { 112, 600, -536},
    { 32, 568, -528},
    { 0, 576, -544},
    { -16, 616, -576},
    { 8, 624, -576},
    { 8, 648, -576},
    { -32, 648, -544},
    { -80, 712, -568},
    // 45 seconds
    { -72, 784, -616},
    { -72, 1072, -744},
    { 72, 1088, -744},
    { 176, 992, -664},
    { 144, 640, -416},
    { -16, 528, -280},
    { -8, 608, -328},
    { 80, 808, -400},
    { 176, 880, -424},
    { 144, 856, -448},
    { 72, 712, -432},
    { 48, 680, -464},
    { 72, 632, -464},
    { 56, 632, -488},
    { 72, 616, -512},
    { 64, 608, -544},
    { 48, 624, -584},
    { 16, 720, -680},
    { 144, 952, -848},
    { 224, 936, -904},
    { 184, 728, -800},
    { 144, 504, -688},
    { 160, 424, -704},
    { 256, 480, -696},
    { 248, 520, -592},
    // 46 seconds
    { 176, 528, -544},
    { 144, 568, -536},
    { 56, 552, -528},
    { -48, 576, -552},
    { -128, 600, -568},
    { -104, 616, -584},
    { -96, 664, -616},
    { -112, 704, -656},
    { -88, 760, -672},
    { -24, 800, -688},
    { -48, 824, -712},
    { -8, 816, -688},
    { 144, 816, -736},
    { 272, 736, -664},
    { 152, 648, -576},
    { 176, 688, -576},
    { 248, 584, -512},
    { 128, 480, -528},
    { 80, 440, -544},
    { 8, 424, -544},
    { 40, 456, -632},
    { 56, 456, -656},
    { 16, 464, -672},
    { 32, 496, -680},
    { 32, 552, -672},
    // 47 seconds
    { 96, 600, -664},
    { 80, 752, -736},
    { 248, 1064, -864},
    { 384, 944, -800},
    { 304, 720, -640},
    { 120, 512, -472},
    { 136, 552, -536},
    { 240, 648, -536},
    { 248, 680, -488},
    { 232, 688, -536},
    { 192, 648, -544},
    { 152, 616, -552},
    { 136, 616, -584},
    { 120, 616, -608},
    { 104, 616, -640},
    { 56, 608, -648},
    { 16, 616, -640},
    { 16, 632, -640},
    { -8, 632, -584},
    { -40, 688, -560},
    { -8, 1032, -720},
    { 240, 968, -688},
    { 192, 712, -528},
    { -64, 544, -360},
    { -56, 608, -424},
    // 48 seconds
    { 8, 768, -512},
    { 104, 904, -576},
    { 160, 856, -584},
    { 104, 696, -504},
    { 128, 584, -472},
    { 128, 560, -528},
    { 128, 536, -528},
    { 136, 568, -576},
    { 160, 576, -608},
    { 160, 544, -576},
    { 48, 640, -632},
    { 192, 984, -840},
    { 304, 856, -840},
    { 256, 672, -712},
    { 152, 528, -584},
    { 184, 504, -608},
    { 200, 592, -608},
    { 168, 592, -536},
    { 208, 632, -552},
    { 168, 616, -584},
    { 120, 592, -576},
    { 96, 568, -568},
    { 96, 576, -584},
    { 96, 592, -616},
    { 72, 600, -616},
    // 49 seconds
    { 48, 600, -624},
    { 72, 600, -624},
    { 80, 632, -640},
    { 160, 704, -600},
    { 288, 1000, -696},
    { 368, 1048, -728},
    { 320, 744, -544},
    { 128, 512, -424},
    { 104, 584, -512},
    { 264, 840, -608},
    { 456, 856, -592},
    { 256, 616, -456},
    { 168, 584, -464},
    { 256, 608, -488},
    { 192, 600, -472},
    { 160, 640, -512},
    { 152, 664, -568},
    { 136, 656, -592},
    { 144, 632, -632},
    { 136, 648, -632},
    { 112, 656, -608},
    { 96, 672, -576},
    { 112, 992, -728},
    { 424, 912, -688},
    { 384, 848, -616},
    // 50 seconds
    { 320, 616, -488},
    { 360, 496, -496},
    { 456, 544, -528},
    { 536, 584, -456},
    { 496, 592, -448},
    { 432, 656, -520},
    { 392, 648, -576},
    { 352, 632, -544},
    { 312, 616, -520},
    { 288, 680, -528},
    { 240, 696, -552},
    { 208, 712, -552},
    { 208, 696, -544},
    { 216, 704, -536},
    { 248, 720, -536},
    { 312, 776, -536},
    { 352, 760, -520},
    { 288, 624, -464},
    { 272, 576, -464},
    { 352, 600, -464},
    { 392, 696, -512},
    { 448, 736, -544},
    { 376, 704, -512},
    { 304, 696, -568},
    { 312, 720, -632},
    // 51 seconds
    { 304, 720, -616},
    { 280, 712, -616},
    { 296, 656, -600},
    { 264, 584, -560},
    { 232, 536, -536},
    { 192, 528, -576},
    { 200, 536, -656},
    { 240, 552, -712},
    { 224, 560, -680},
    { 152, 592, -672},
    { 120, 616, -632},
    { 96, 640, -608},
    { 96, 704, -632},
    { 72, 872, -760},
    { 280, 1000, -800},
    { 280, 896, -688},
    { 184, 616, -504},
    { 80, 504, -424},
    { 64, 536, -440},
    { 64, 640, -448},
    { 152, 736, -472},
    { 96, 776, -496},
    { 16, 696, -440},
    { -8, 648, -432},
    { -64, 656, -496},
    // 52 seconds
    { -48, 696, -536},
    { -32, 736, -592},
    { 32, 712, -648},
    { -16, 640, -624},
    { -24, 616, -608},
    { -16, 616, -608},
    { -24, 664, -592},
    { -32, 720, -592},
    { 16, 936, -704},
    { 168, 960, -680},
    { 168, 832, -584},
    { 136, 616, -464},
    { 136, 544, -472},
    { 168, 592, -520},
    { 256, 704, -560},
    { 336, 696, -568},
    { 208, 592, -544},
    { 120, 536, -544},
    { 112, 552, -568},
    { 88, 560, -584},
    { 64, 568, -592},
    { 24, 608, -632},
    { -16, 624, -648},
    { -48, 656, -640},
    { -56, 688, -632},
    // 53 seconds
    { -40, 752, -648},
    { 8, 864, -648},
    { 96, 1016, -672},
    { 256, 1064, -664},
    { 248, 824, -496},
    { 88, 568, -296},
    { 0, 616, -328},
    { 112, 800, -376},
    { 216, 848, -352},
    { 104, 816, -368},
    { 40, 712, -320},
    { 8, 680, -320},
    { -24, 704, -368},
    { -72, 712, -384},
    { -96, 760, -440},
    { -80, 776, -464},
    { -120, 768, -504},
    { -136, 728, -504},
    { -160, 688, -480},
    { -184, 656, -448},
    { -208, 680, -424},
    { -176, 744, -472},
    { -88, 944, -552},
    { 112, 1040, -584},
    { 144, 976, -592},
    // 54 seconds
    { 112, 824, -568},
    { 176, 664, -528},
    { 256, 592, -560},
    { 376, 680, -592},
    { 424, 624, -480},
    { 248, 568, -472},
    { 152, 632, -528},
    { 80, 608, -552},
    { 40, 664, -536},
    { -8, 640, -512},
    { -48, 664, -560},
    { -56, 712, -592},
    { -88, 672, -568},
    { -80, 640, -568},
    { -104, 632, -560},
    { -80, 640, -552},
    { -40, 656, -504},
    { -48, 1072, -688},
    { 280, 1072, -656},
    { 320, 928, -568},
    { 176, 640, -448},
    { 40, 568, -392},
    { 48, 680, -448},
    { 200, 784, -480},
    { 120, 736, -464},
    // 55 seconds
    { 48, 632, -464},
    { 40, 632, -488},
    { 40, 632, -480},
    { 24, 656, -504},
    { 24, 672, -512},
    { 32, 680, -512},
    { -8, 696, -528},
    { -16, 744, -536},
    { 8, 760, -520},
    { 0, 832, -552},
    { 24, 1056, -736},
    { 264, 992, -688},
    { 216, 808, -560},
    { 160, 576, -488},
    { 160, 520, -536},
    { 248, 568, -600},
    { 304, 592, -544},
    { 232, 544, -536},
    { 152, 544, -560},
    { 96, 560, -592},
    { 64, 608, -624},
    { 56, 592, -600},
    { 24, 592, -608},
    { -16, 608, -600},
    { -112, 640, -640},
    // 56 seconds
    { -112, 704, -640},
    { -80, 752, -696},
    { -24, 816, -720},
    { -8, 944, -784},
    { 208, 976, -792},
    { 272, 816, -696},
    { 256, 528, -528},
    { 176, 360, -408},
    { 176, 432, -424},
    { 280, 504, -440},
    { 288, 560, -472},
    { 320, 576, -472},
    { 232, 576, -528},
    { 280, 568, -576},
    { 312, 488, -480},
    { 368, 448, -440},
    { 520, 504, -424},
    { 584, 464, -328},
    { 768, 504, -256},
    { 952, 464, -168},
    { 1144, 400, -64},
    { 1840, 400, 136},
    { 2280, 480, 216},
    { 1832, 472, 88},
    { 1168, 656, -368},
    // 57 seconds
    { 648, 376, 8},
    { 1080, 200, 8},
    { 1304, 80, 48},
    { 1048, 72, 56},
    { 856, 128, -8},
    { 760, 72, -112},
    { 800, 48, -224},
    { 912, 64, -312},
    { 928, 0, -400},
    { 984, -16, -496},
    { 1032, -24, -504},
    { 1120, -96, -464},
    { 1112, -64, -424},
    { 1104, 40, -400},
    { 1520, 72, -344},
    { 1288, 88, -184},
    { 1032, 80, -120},
    { 888, 88, -80},
    { 1200, 136, 8},
    { 1504, 112, 168},
    { 1360, 80, 240},
    { 1272, 80, 168},
    { 1232, 32, 128},
    { 1152, 8, 72},
    { 1160, 8, 64},
    // 58 seconds
    { 1120, 0, 32},
    { 1056, -32, -8},
    { 1032, -16, -48},
    { 952, 8, -96},
    { 920, 80, -232},
    { 872, 64, -200},
    { 832, 96, -328},
    { 840, 32, -192},
    { 984, 104, -368},
    { 1040, 184, -480},
    { 1104, 256, -448},
    { 1128, 264, -456},
    { 1096, 176, -440},
    { 1064, 120, -352},
    { 1040, 96, -336},
    { 960, 40, -240},
    { 992, 32, -192},
    { 904, 64, -176},
    { 888, 72, -216},
    { 920, 48, -256},
    { 952, 56, -296},
    { 1056, 0, -368},
    { 1112, -32, -296},
    { 1072, 0, -376},
    { 1000, -56, -408},
    // 59 seconds
    { 912, -16, -416},
    { 880, -48, -456},
    { 856, 0, -440},
    { 840, 8, -488},
    { 728, 56, -576},
    { 648, 128, -520},
    { 576, 168, -576},
    { 552, 200, -576},
    { 664, 240, -512},
    { 824, 336, -648},
    { 1120, 448, -832},
    { 1168, 520, -704},
    { 1160, 448, -632},
    { 1128, 336, -584},
    { 1016, 264, -464},
    { 888, 200, -384},
    { 776, 96, -328},
    { 712, 32, -200},
    { 776, 16, -216},
    { 800, 184, -216},
    { 840, 184, -248},
    { 896, 216, -176},
    { 888, 256, -136},
    { 952, 280, -168},
    { 1008, 240, -136},
    // 60 seconds
    // elapsed: 1 minutes
    { 1048, 208, -176},
    { 1184, 264, -152},
    { 1760, 376, -64},
    { 1344, 264, -72},
    { 688, 384, -328},
    { 760, 240, -312},
    { 1024, 320, -288},
    { 992, 224, -192},
    { 952, 184, -216},
    { 904, 160, -184},
    { 872, 168, -232},
    { 856, 168, -264},
    { 920, 160, -288},
    { 960, 160, -264},
    { 944, 152, -248},
    { 992, 152, -240},
    { 1024, 144, -176},
    { 1120, 168, -136},
    { 1408, 224, -160},
    { 1088, 120, -96},
    { 1104, 208, -80},
    { 1088, 296, 8},
    { 1288, 352, 152},
    { 1152, 320, 160},
    { 1024, 352, 152},
    // 61 seconds
    { 984, 360, 168},
    { 1000, 400, 184},
    { 1016, 312, 128},
    { 1040, 224, 80},
    { 1056, 192, 0},
    { 1056, 144, -104},
    { 1040, 88, -104},
    { 1080, 64, -168},
    { 1096, 96, -248},
    { 1176, 72, -304},
    { 1376, 96, -328},
    { 1232, 128, -408},
    { 968, 88, -448},
    { 720, 72, -488},
    { 792, 88, -392},
    { 952, 96, -384},
    { 928, 104, -336},
    { 856, 136, -280},
    { 720, 200, -304},
    { 624, 232, -400},
    { 592, 208, -496},
    { 648, 208, -496},
    { 632, 184, -528},
    { 648, 168, -552},
    { 696, 192, -624},
    // 62 seconds
    { 784, 232, -576},
    { 872, 272, -608},
    { 968, 184, -560},
    { 1208, 176, -528},
    { 1144, 120, -520},
    { 840, 48, -464},
    { 912, 40, -392},
    { 1312, 48, -360},
    { 1176, 0, -256},
    { 968, -32, -280},
    { 832, -32, -320},
    { 824, -32, -336},
    { 920, -56, -304},
    { 968, -96, -256},
    { 960, -72, -240},
    { 984, -64, -224},
    { 1048, -56, -216},
    { 1120, -48, -184},
    { 1264, -32, -152},
    { 1560, -16, -144},
    { 1296, -8, -128},
    { 944, 16, -144},
    { 696, 64, -184},
    { 1112, 80, -184},
    { 1144, 56, -120},
    // 63 seconds
    { 1024, 48, -112},
    { 880, 64, -160},
    { 840, 48, -240},
    { 880, 40, -256},
    { 944, 40, -304},
    { 976, -8, -344},
    { 976, -8, -400},
    { 984, -48, -456},
    { 1016, -72, -448},
    { 1048, -80, -416},
    { 1040, -64, -376},
    { 1184, -8, -384},
    { 1336, 32, -392},
    { 1296, 40, -304},
    { 1016, 24, -224},
    { 944, 24, -216},
    { 1176, 32, -192},
    { 1368, 8, -104},
    { 1168, -16, -48},
    { 1032, -24, -48},
    { 1000, -16, -64},
    { 944, 0, -56},
    { 976, 0, -32},
    { 1016, -16, -24},
    { 960, -32, 0},
    // 64 seconds
    { 960, 0, -56},
    { 968, -8, -56},
    { 1040, -16, -96},
    { 1064, -24, -144},
    { 1336, -32, -120},
    { 1536, -8, -96},
    { 1224, 8, -128},
    { 896, 24, -288},
    { 752, 88, -424},
    { 952, 128, -464},
    { 1064, 24, -384},
    { 1144, -72, -296},
    { 1008, -48, -376},
    { 960, -48, -368},
    { 888, -80, -304},
    { 952, -56, -240},
    { 992, -48, -208},
    { 1000, -56, -168},
    { 1024, -32, -160},
    { 1008, -8, -184},
    { 1040, -16, -184},
    { 1064, -32, -192},
    { 1096, -40, -192},
    { 1424, -24, -192},
    { 1512, -16, -160},
    // 65 seconds
    { 1120, 8, -128},
    { 864, 32, -216},
    { 1120, 80, -192},
    { 1296, 8, -88},
    { 1120, -32, -48},
    { 1048, -32, -104},
    { 1104, -32, -80},
    { 1040, -40, -64},
    { 1056, -40, -56},
    { 976, -40, -40},
    { 960, 16, -96},
    { 952, 40, -96},
    { 968, 48, -96},
    { 1000, 96, -128},
    { 1024, 104, -168},
    { 1056, 80, -152},
    { 1096, 24, -176},
    { 1192, 32, -80},
    { 1464, 80, -56},
    { 1512, 128, -24},
    { 1408, 176, 16},
    { 1056, 192, -48},
    { 832, 208, -240},
    { 976, 120, -320},
    { 1016, 24, -232},
    // 66 seconds
    { 952, -40, -248},
    { 888, -64, -272},
    { 848, -88, -296},
    { 856, -88, -320},
    { 920, -96, -360},
    { 984, -136, -416},
    { 1080, -152, -440},
    { 1040, -168, -488},
    { 992, -208, -488},
    { 944, -216, -464},
    { 952, -200, -408},
    { 928, -152, -360},
    { 928, -88, -360},
    { 888, -32, -368},
    { 856, 8, -392},
    { 840, 64, -440},
    { 848, 72, -456},
    { 824, 104, -472},
    { 792, 120, -496},
    { 768, 112, -512},
    { 760, 128, -512},
    { 776, 128, -504},
    { 800, 120, -496},
    { 1008, 144, -472},
    { 1176, 184, -544},
    // 67 seconds
    { 1168, 168, -496},
    { 1072, 136, -384},
    { 1032, 128, -296},
    { 1264, 128, -264},
    { 1224, 152, -224},
    { 968, 104, -200},
    { 904, 112, -184},
    { 920, 168, -208},
    { 936, 208, -200},
    { 912, 264, -248},
    { 920, 296, -248},
    { 896, 360, -336},
    { 928, 384, -424},
    { 936, 336, -408},
    { 936, 304, -440},
    { 904, 272, -432},
    { 864, 240, -448},
    { 824, 248, -456},
    { 816, 280, -424},
    { 976, 360, -496},
    { 920, 360, -448},
    { 816, 384, -488},
    { 720, 368, -400},
    { 784, 384, -384},
    { 912, 352, -384},
    // 68 seconds
    { 840, 328, -336},
    { 776, 360, -344},
    { 728, 384, -368},
    { 632, 392, -376},
    { 608, 392, -384},
    { 584, 448, -432},
    { 552, 456, -448},
    { 528, 488, -456},
    { 552, 536, -496},
    { 568, 560, -480},
    { 624, 600, -456},
    { 672, 632, -464},
    { 680, 584, -416},
    { 880, 616, -464},
    { 928, 552, -456},
    { 896, 528, -416},
    { 760, 448, -368},
    { 792, 448, -344},
    { 976, 448, -304},
    { 928, 392, -264},
    { 888, 384, -288},
    { 864, 384, -272},
    { 800, 328, -256},
    { 792, 304, -272},
    { 792, 296, -272},
    // 69 seconds
    { 800, 264, -280},
    { 832, 256, -280},
    { 856, 208, -240},
    { 936, 152, -192},
    { 1016, 112, -152},
    { 1088, 96, -120},
    { 1272, 152, -80},
    { 1760, 200, -64},
    { 1496, 224, -112},
    { 1128, 224, -232},
    { 768, 216, -320},
    { 656, 192, -264},
    { 1016, 64, -216},
    { 1216, 40, -208},
    { 1072, 16, -208},
    { 936, -16, -216},
    { 872, -8, -248},
    { 912, 32, -328},
    { 976, 40, -304},
    { 1000, 24, -328},
    { 960, 32, -368},
    { 944, 80, -376},
    { 904, 96, -368},
    { 928, 136, -328},
    { 936, 176, -256},
    // 70 seconds
    { 1024, 224, -200},
    { 1432, 328, -256},
    { 1304, 376, -256},
    { 1088, 320, -184},
    { 824, 176, -104},
    { 1000, 80, -88},
    { 1096, 112, -32},
    { 1064, 152, -72},
    { 936, 136, -112},
    { 872, 128, -152},
    { 872, 136, -200},
    { 936, 88, -280},
    { 1008, 24, -224},
    { 1024, 0, -208},
    { 1032, 64, -264},
    { 1032, 64, -184},
    { 984, -144, -112},
    { 1048, -32, -128},
    { 1384, -16, -176},
    { 1288, -24, -168},
    { 1008, 0, -168},
    { 728, -16, -176},
    { 944, 24, -184},
    { 1200, 64, -136},
    { 1040, 8, -112},
    // 71 seconds
    { 944, -8, -216},
    { 920, -24, -240},
    { 928, -24, -272},
    { 984, -24, -328},
    { 1008, -56, -304},
    { 1008, -48, -312},
    { 1000, -24, -344},
    { 1008, -16, -344},
    { 1072, -16, -312},
    { 1112, -8, -296},
    { 1096, -8, -264},
    { 1360, 8, -264},
    { 1320, -8, -248},
    { 1200, -24, -232},
    { 984, -16, -192},
    { 944, -56, -192},
    { 1200, -48, -136},
    { 1224, -24, -120},
    { 1120, -48, -88},
    { 1072, -40, -112},
    { 1048, -40, -128},
    { 1032, -32, -128},
    { 1032, -56, -192},
    { 984, -104, -216},
    { 952, -120, -248},
    // 72 seconds
    { 920, -144, -248},
    { 920, -144, -256},
    { 944, -128, -256},
    { 992, -96, -240},
    { 1216, -48, -192},
    { 1472, -40, -152},
    { 1216, -16, -128},
    { 944, -32, -208},
    { 808, 40, -200},
    { 896, 72, -152},
    { 1160, 56, -104},
    { 1216, 72, -16},
    { 1064, 80, -48},
    { 880, 128, -176},
    { 848, 88, -248},
    { 952, 0, -280},
    { 1008, -40, -304},
    { 968, -80, -384},
    { 1008, -104, -440},
    { 1048, -96, -424},
    { 1064, -96, -392},
    { 1144, -104, -352},
    { 1280, -72, -320},
    { 1368, -88, -328},
    { 1272, -80, -304},
    // 73 seconds
    { 1104, -136, -240},
    { 952, -56, -280},
    { 912, -96, -184},
    { 1088, -152, -128},
    { 1232, -184, -104},
    { 1144, -120, -88},
    { 1088, -104, -112},
    { 984, -120, -88},
    { 944, -112, -112},
    { 984, -64, -136},
    { 944, -96, -112},
    { 1000, -112, -104},
    { 992, -112, -80},
    { 1032, -128, -80},
    { 1064, -112, -88},
    { 1216, -144, -80},
    { 1416, -104, -64},
    { 1264, -128, -80},
    { 1160, -112, -120},
    { 1064, -112, -184},
    { 984, -152, -160},
    { 1064, -136, -176},
    { 1032, -224, -152},
    { 1024, -224, -136},
    { 984, -224, -144},
    // 74 seconds
    { 992, -192, -184},
    { 976, -208, -208},
    { 1000, -208, -224},
    { 1016, -192, -256},
    { 1000, -200, -304},
    { 992, -192, -344},
    { 944, -200, -352},
    { 912, -192, -368},
    { 904, -200, -368},
    { 896, -200, -384},
    { 848, -200, -392},
    { 848, -216, -392},
    { 880, -192, -432},
    { 896, -208, -416},
    { 912, -184, -440},
    { 896, -192, -416},
    { 912, -168, -432},
    { 864, -192, -416},
    { 840, -168, -384},
    { 1184, -160, -432},
    { 1200, -152, -480},
    { 1176, -160, -352},
    { 1152, -120, -296},
    { 1152, -64, -224},
    { 1096, -24, -224},
    // 75 seconds
    { 1040, -32, -200},
    { 928, -32, -184},
    { 904, -32, -224},
    { 976, -24, -176},
    { 992, -8, -192},
    { 1008, -8, -200},
    { 1056, 0, -232},
    { 1048, -24, -264},
    { 1008, -32, -256},
    { 968, -24, -296},
    { 960, -24, -288},
    { 976, -40, -288},
    { 1000, -40, -264},
    { 1024, 0, -264},
    { 1048, 16, -264},
    { 1136, 24, -288},
    { 1448, 24, -256},
    { 1128, 16, -288},
    { 824, 0, -320},
    { 760, 16, -320},
    { 1056, 24, -264},
    { 1144, -8, -192},
    { 1024, -8, -216},
    { 992, -8, -224},
    { 920, 16, -256},
    // 76 seconds
    { 904, 8, -288},
    { 944, -16, -272},
    { 992, -40, -264},
    { 912, -40, -232},
    { 920, 0, -248},
    { 1008, 16, -240},
    { 1272, 32, -216},
    { 1304, 40, -200},
    { 1192, 40, -112},
    { 1192, 48, -48},
    { 992, 64, -56},
    { 1104, 72, 0},
    { 1176, 64, 88},
    { 1048, 16, 160},
    { 1032, 8, 168},
    { 992, 16, 112},
    { 992, 16, 112},
    { 1000, 72, 136},
    { 1032, 32, 136},
    { 1032, 16, 96},
    { 1080, 8, 96},
    { 1152, -8, 112},
    { 1176, -40, 104},
    { 1184, -64, 96},
    { 1240, -120, 112},
    // 77 seconds
    { 1624, -120, 136},
    { 1320, -104, -16},
    { 1024, -72, -280},
    { 664, -144, -416},
    { 584, -224, -232},
    { 1040, -248, -192},
    { 1264, -136, -224},
    { 1160, -104, -208},
    { 1112, -80, -168},
    { 1056, -72, -96},
    { 1104, 0, -64},
    { 1096, -32, -24},
    { 1096, -16, -16},
    { 1040, 32, -56},
    { 920, 72, -136},
    { 888, 16, -208},
    { 904, 0, -216},
    { 968, -24, -264},
    { 992, -48, -272},
    { 1016, -72, -288},
    { 1280, -128, -240},
    { 1480, -80, -336},
    { 1280, -72, -344},
    { 832, -112, -304},
    { 632, -24, -288},
    // 78 seconds
    { 1088, 0, -368},
    { 1184, -16, -192},
    { 1024, -96, -112},
    { 1032, -56, -176},
    { 1000, -16, -200},
    { 944, -24, -184},
    { 968, -32, -184},
    { 968, -56, -192},
    { 952, -80, -176},
    { 1008, -56, -136},
    { 1048, -32, -120},
    { 1096, -24, -96},
    { 1144, -40, -96},
    { 1568, -32, -88},
    { 1528, -24, -88},
    { 1144, 32, -96},
    { 656, 48, -224},
    { 752, 88, -184},
    { 1296, 112, -136},
    { 1144, 64, -80},
    { 968, 32, -112},
    { 888, 24, -192},
    { 848, 24, -200},
    { 888, 0, -216},
    { 1008, -8, -240},
    // 79 seconds
    { 1008, -40, -272},
    { 984, -64, -256},
    { 976, -72, -296},
    { 1032, -72, -296},
    { 992, -72, -272},
    { 1248, -56, -272},
    { 1496, -8, -312},
    { 1296, -64, -200},
    { 1016, -56, -168},
    { 848, 0, -192},
    { 1072, 32, -192},
    { 1224, -24, -72},
    { 1232, -24, -8},
    { 1008, -24, -8},
    { 1064, -16, -32},
    { 1048, -16, 24},
    { 1048, 8, 8},
    { 1088, 16, 16},
    { 1064, 0, 40},
    { 1016, -8, 40},
    { 968, -8, 16},
    { 976, -16, -8},
    { 1008, -16, -32},
    { 1120, -40, -80},
    { 1168, -72, -80},
    // 80 seconds
    { 1624, -56, -40},
    { 1352, -40, -32},
    { 1168, -8, -120},
    { 920, 48, -344},
    { 704, 88, -408},
    { 848, 72, -416},
    { 1088, 8, -384},
    { 1112, -48, -368},
    { 1056, -80, -336},
    { 1000, -80, -304},
    { 960, -80, -256},
    { 992, -80, -184},
    { 1016, -72, -128},
    { 1016, -56, -104},
    { 960, -56, -96},
    { 936, -48, -112},
    { 952, -48, -120},
    { 1000, -56, -128},
    { 1080, -56, -128},
    { 1152, -64, -112},
    { 1656, -24, -208},
    { 1424, 0, -232},
    { 992, -32, -176},
    { 768, -8, -200},
    { 1152, 80, -184},
    // 81 seconds
    { 1256, -16, -80},
    { 1192, -56, -40},
    { 1040, -64, -48},
    { 1048, -56, -88},
    { 1008, -64, -32},
    { 976, -88, -8},
    { 1000, -72, -48},
    { 960, -48, -40},
    { 952, -24, -72},
    { 904, -16, -152},
    { 920, 0, -176},
    { 968, -8, -192},
    { 1032, 24, -240},
    { 1304, 56, -208},
    { 1496, 104, -272},
    { 1344, 72, -272},
    { 1032, 48, -376},
    { 752, 56, -384},
    { 712, 56, -296},
    { 1080, 48, -208},
    { 1288, 72, -200},
    { 1168, 136, -176},
    { 1096, 88, -96},
    { 1088, 112, -24},
    { 1088, 96, 24},
    // 82 seconds
    { 1104, 72, 48},
    { 1016, 136, 0},
    { 944, 176, 16},
    { 944, 240, 24},
    { 944, 328, 16},
    { 912, 312, 48},
    { 936, 280, 80},
    { 1000, 304, 56},
    { 1064, 312, 48},
    { 1040, 288, 40},
    { 1080, 256, 24},
    { 1088, 248, 0},
    { 1120, 216, -24},
    { 1080, 192, -40},
    { 1088, 184, -56},
    { 1072, 200, -88},
    { 1080, 168, -96},
    { 1064, 112, -120},
    { 1016, 88, -112},
    { 1000, 72, -80},
    { 1024, 56, -56},
    { 1032, 32, -48},
    { 1072, 8, -40},
    { 1064, 8, -32},
    { 1240, -16, 16},
    // 83 seconds
    { 1256, 56, 16},
    { 1208, 64, 24},
    { 1256, 88, -208},
    { 856, 120, -264},
    { 904, 88, -168},
    { 1112, -8, -48},
    { 1032, -56, 16},
    { 1192, -24, -48},
    { 1168, 16, -80},
    { 1088, 56, -96},
    { 1048, 32, -104},
    { 968, 40, -80},
    { 968, 64, -120},
    { 936, 96, -144},
    { 912, 160, -248},
    { 872, 160, -336},
    { 880, 224, -416},
    { 864, 232, -440},
    { 848, 248, -496},
    { 856, 256, -504},
    { 960, 320, -424},
    { 1080, 424, -512},
    { 1072, 472, -560},
    { 848, 312, -392},
    { 736, 240, -296},
    // 84 seconds
    { 904, 312, -408},
    { 880, 328, -392},
    { 752, 288, -344},
    { 768, 328, -368},
    { 768, 320, -368},
    { 784, 336, -400},
    { 776, 368, -416},
    { 776, 408, -448},
    { 760, 424, -504},
    { 704, 384, -488},
    { 656, 320, -528},
    { 608, 312, -504},
    { 528, 248, -464},
    { 544, 296, -424},
    { 704, 424, -480},
    { 784, 360, -472},
    { 1016, 248, -376},
    { 1456, 264, -320},
    { 1392, 224, -264},
    { 1040, 128, -304},
    { 1064, 80, -648},
    { 1128, 96, -424},
    { 1344, -56, -280},
    { 1080, -16, -240},
    { 928, -8, -320},
    // 85 seconds
    { 824, -48, -272},
    { 760, -48, -248},
    { 792, -40, -216},
    { 864, -48, -232},
    { 904, -48, -264},
    { 856, -48, -304},
    { 864, -64, -400},
    { 920, -64, -432},
    { 952, -96, -424},
    { 976, -104, -432},
    { 968, -104, -440},
    { 944, -80, -408},
    { 992, -40, -416},
    { 1384, 0, -464},
    { 1296, 24, -376},
    { 1120, 48, -256},
    { 912, 80, -216},
    { 1088, 96, -208},
    { 1216, 136, -96},
    { 1168, 120, -48},
    { 1144, 120, -56},
    { 1072, 128, -72},
    { 1048, 160, -48},
    { 992, 128, -120},
    { 976, 152, -128},
    // 86 seconds
    { 912, 128, -232},
    { 880, 112, -312},
    { 840, 88, -424},
    { 816, 56, -488},
    { 832, 40, -520},
    { 832, 72, -560},
    { 880, 56, -552},
    { 1064, 104, -504},
    { 1280, 80, -408},
    { 1048, 64, -448},
    { 984, 48, -384},
    { 744, 24, -376},
    { 896, 72, -296},
    { 1016, 8, -232},
    { 1080, 32, -152},
    { 1024, 56, -160},
    { 888, 72, -216},
    { 824, 88, -264},
    { 832, 72, -264},
    { 904, 72, -256},
    { 960, 80, -264},
    { 968, 56, -320},
    { 960, 40, -360},
    { 992, 32, -416},
    { 1088, 8, -432},
    // 87 seconds
    { 1104, -8, -432},
    { 1064, -8, -424},
    { 1144, -8, -456},
    { 1368, -8, -464},
    { 1304, 0, -376},
    { 1096, -16, -312},
    { 920, -8, -280},
    { 872, 8, -288},
    { 1040, 0, -240},
    { 1280, -8, -192},
    { 1296, 0, -128},
    { 1136, -8, -88},
    { 1040, -32, -80},
    { 960, -24, -104},
    { 904, -32, -152},
    { 848, -48, -216},
    { 872, -64, -256},
    { 880, -96, -304},
    { 888, -120, -336},
    { 976, -160, -336},
    { 1008, -168, -344},
    { 1048, -144, -376},
    { 1056, -120, -288},
    { 1400, -48, -280},
    { 1520, -64, -216},
    // 88 seconds
    { 1184, -40, -280},
    { 856, -48, -384},
    { 712, -56, -336},
    { 848, -88, -232},
    { 1040, -96, -144},
    { 1152, -72, -32},
    { 1160, 24, 8},
    { 952, 88, 0},
    { 864, 88, -96},
    { 856, 136, -240},
    { 904, 0, -264},
    { 896, 104, -368},
    { 848, 40, -392},
    { 920, 48, -432},
    { 936, 24, -488},
    { 968, -8, -472},
    { 1032, 72, -512},
    { 1080, -88, -360},
    { 1296, -200, -304},
    { 1424, -32, -392},
    { 1360, -24, -320},
    { 1048, -80, -272},
    { 776, -48, -184},
    { 904, -32, -168},
    { 1216, -32, -96},
    // 89 seconds
    { 1256, -32, -72},
    { 1144, -56, 8},
    { 1072, -64, -56},
    { 1008, -48, -48},
    { 1056, 16, -80},
    { 1000, -48, -8},
    { 1016, -40, -96},
    { 1000, -80, -128},
    { 1000, -88, -112},
    { 928, -72, -192},
    { 936, -40, -224},
    { 920, -88, -248},
    { 968, -56, -232},
    { 1048, -32, -208},
    { 1088, -32, -208},
    { 1136, -56, -168},
    { 1392, -16, -104},
    { 1248, -8, -112},
    { 1232, -8, -144},
    { 1088, 0, -168},
    { 920, 8, -224},
    { 856, -24, -256},
    { 984, -8, -208},
    { 1128, 0, -48},
    { 1200, -16, -16},
    // 90 seconds
    { 1056, -120, 56},
    { 1000, -96, -24},
    { 944, -56, -32},
    { 928, -120, -56},
    { 1032, -328, 112},
    { 800, 48, 24},
    { 896, 176, -72},
    { 1016, 48, 24},
    { 968, -72, 88},
    { 1176, -16, -64},
    { 1064, -80, -8},
    { 1144, -16, -48},
    { 1120, -8, -88},
    { 1576, -48, -88},
    { 1280, -176, -24},
    { 1152, -192, -24},
    { 952, -152, 0},
    { 856, -176, 48},
    { 968, -96, -40},
    { 1128, -56, -40},
    { 1208, -56, 80},
    { 1136, -104, 80},
    { 1120, -16, 8},
    { 1088, -72, 96},
    { 1032, -64, 64},
    // 91 seconds
    { 1088, -16, 16},
    { 1088, -64, 16},
    { 1096, -64, -32},
    { 1064, -136, -24},
    { 1112, -120, 8},
    { 1112, -88, -32},
    { 1120, -64, 16},
    { 1144, -72, 32},
    { 1232, 24, 24},
    { 1208, -32, 88},
    { 1208, 56, 152},
    { 1080, 120, 136},
    { 1136, 176, 64},
    { 1096, 128, 96},
    { 1096, 80, 136},
    { 1096, 152, 24},
    { 1064, 184, -56},
    { 1000, 120, -16},
    { 1024, 48, -16},
    { 1056, 8, -80},
    { 1016, 16, -56},
    { 1040, -8, -104},
    { 1032, 16, -136},
    { 1040, 40, -176},
    { 1000, 8, -248},
    // 92 seconds
    { 1064, 32, -376},
    { 1024, -80, -472},
    { 1016, -160, -416},
    { 1016, -136, -408},
    { 976, -168, -312},
    { 1040, -256, -312},
    { 1528, -288, -360},
    { 1520, -280, -264},
    { 1296, -288, -112},
    { 1064, -280, -48},
    { 968, -16, -168},
    { 992, -48, -72},
    { 1128, 72, -48},
    { 1136, 80, -32},
    { 1216, 64, -16},
    { 1072, -8, 8},
    { 1040, -16, -40},
    { 960, -32, -72},
    { 1016, -40, -128},
    { 960, -136, -176},
    { 944, -200, -240},
    { 912, -256, -240},
    { 880, -288, -200},
    { 928, -248, -176},
    { 1008, -176, -168},
    // 93 seconds
    { 1032, -168, -120},
    { 1104, -192, -8},
    { 1664, -152, 48},
    { 1440, -112, -8},
    { 1144, -48, -136},
    { 736, -24, -208},
    { 720, -32, -208},
    { 1024, 24, -152},
    { 1224, -56, -56},
    { 1184, -88, -64},
    { 1008, -72, -104},
    { 952, 0, -176},
    { 896, -40, -280},
    { 960, -152, -256},
    { 1088, -160, -272},
    { 1048, -168, -256},
    { 1056, -160, -232},
    { 1104, -136, -224},
    { 1096, -152, -192},
    { 1160, -144, -160},
    { 1328, -152, -120},
    { 1440, -80, -152},
    { 1232, 0, -144},
    { 992, -8, -56},
    { 952, 64, -88},
    // 94 seconds
    { 1192, 40, -40},
    { 1248, 8, 40},
    { 1104, 24, 56},
    { 1000, 8, 32},
    { 1112, 0, 24},
    { 1192, 32, 56},
    { 1096, 32, 104},
    { 1056, 16, 104},
    { 968, 0, 40},
    { 840, -40, -40},
    { 920, -32, -88},
    { 936, -96, -104},
    { 968, -160, -96},
    { 1072, -112, -136},
    { 1088, -88, -128},
    { 1200, -104, -56},
    { 1472, -96, -48},
    { 1264, -104, -96},
    { 1112, -88, -208},
    { 824, -16, -304},
    { 912, 48, -280},
    { 1248, 24, -280},
    { 1216, -56, -184},
    { 1016, -64, -144},
    { 960, -16, -176},
    // 95 seconds
    { 952, -48, -136},
    { 928, -80, -96},
    { 1024, -80, -120},
    { 1104, -32, -136},
    { 1072, 16, -72},
    { 1040, 72, -32},
    { 1056, 96, 0},
    { 1160, 120, 8},
    { 1144, 136, -16},
    { 1392, 144, -16},
    { 1384, 80, -72},
    { 1264, 80, -88},
    { 984, 96, -56},
    { 872, 144, -56},
    { 960, 160, 88},
    { 1256, 88, 16},
    { 1240, 224, -40},
    { 1096, 112, -40},
    { 952, 80, -96},
    { 864, 32, -128},
    { 896, 16, -184},
    { 936, 0, -256},
    { 840, -72, -328},
    { 888, -128, -288},
    { 848, -104, -240},
    // 96 seconds
    { 936, -104, -352},
    { 912, -104, -320},
    { 896, -168, -320},
    { 1240, -208, -168},
    { 1344, -160, -192},
    { 1304, -176, -224},
    { 1080, -168, -248},
    { 840, -184, -208},
    { 920, -144, -200},
    { 1096, -104, -144},
    { 1080, -112, -40},
    { 1032, -96, -24},
    { 944, -40, -16},
    { 896, 0, -40},
    { 912, -48, -88},
    { 976, -72, -112},
    { 1032, -112, -176},
    { 1072, -112, -248},
    { 1136, -128, -272},
    { 1168, -104, -320},
    { 1208, -88, -328},
    { 1168, -48, -344},
    { 1104, -48, -328},
    { 1456, -8, -344},
    { 1296, -48, -272},
    // 97 seconds
    { 1152, -56, -208},
    { 952, -32, -168},
    { 1056, 0, -152},
    { 1368, -24, -64},
    { 1384, -40, -16},
    { 1144, -80, 24},
    { 1088, -64, 24},
    { 1152, -24, 0},
    { 1104, -32, 48},
    { 1056, -40, 72},
    { 968, -48, 32},
    { 896, -56, -48},
    { 832, -56, -112},
    { 816, -96, -112},
    { 872, -168, -64},
    { 944, -168, -88},
    { 1064, -152, -104},
    { 1384, -120, -16},
    { 1536, -40, -24},
    { 1352, -16, -96},
    { 1048, -72, -256},
    { 840, -64, -320},
    { 920, -48, -272},
    { 1152, -128, -200},
    { 1136, -192, -168},
    // 98 seconds
    { 1128, -136, -224},
    { 1088, -112, -256},
    { 912, -168, -200},
    { 936, -184, -192},
    { 992, -160, -176},
    { 976, -136, -144},
    { 968, -112, -120},
    { 1032, -104, -128},
    { 1104, -120, -120},
    { 1080, -128, -112},
    { 1072, -104, -120},
    { 1056, -96, -104},
    { 1152, -96, -72},
    { 1560, -96, -112},
    { 1352, -96, -88},
    { 1056, -48, -88},
    { 792, -24, -104},
    { 1032, 0, -128},
    { 1240, -80, -64},
    { 1200, -96, 0},
    { 1088, -64, 0},
    { 1072, -48, -16},
    { 976, -40, 8},
    { 968, -32, 8},
    { 952, -48, 24},
    // 99 seconds
    { 880, -72, 8},
    { 920, -80, -8},
    { 952, -96, -8},
    { 1000, -96, -8},
    { 1040, -80, -32},
    { 1072, -80, -72},
    { 1560, -128, -80},
    { 1488, -128, -104},
    { 1216, -120, -168},
    { 904, -112, -296},
    { 752, -32, -320},
    { 936, -40, -240},
    { 1280, -88, -152},
    { 1200, -104, -104},
    { 1016, -32, -128},
    { 1000, -8, -136},
    { 952, -8, -128},
    { 992, -48, -104},
    { 1024, -64, -88},
    { 1016, -48, -96},
    { 1024, -8, -104},
    { 1000, -16, -104},
    { 992, -16, -112},
    { 1032, -16, -120},
    { 1048, 8, -112},
    // 100 seconds
    { 1152, 0, -56},
    { 1400, 64, -56},
    { 1112, 96, -48},
    { 1080, 104, 56},
    { 1176, 120, 128},
    { 1040, 168, 184},
    { 992, 192, 200},
    { 952, 184, 176},
    { 1024, 232, 160},
    { 1032, 184, 176},
    { 1080, 128, 200},
    { 1096, 168, 24},
    { 1064, 8, 48},
    { 1160, -32, -112},
    { 1072, -40, -56},
    { 1040, 24, -24},
    { 1088, 88, -72},
    { 1176, 96, -56},
    { 1144, 72, 56},
    { 840, 136, 48},
    { 952, 64, 8},
    { 1152, 104, -32},
    { 1160, 144, 24},
    { 1096, 72, 48},
    { 1104, 8, 32},
    // 101 seconds
    { 1088, -8, 8},
    { 1072, 32, 8},
    { 1128, 0, 32},
    { 1000, -8, 32},
    { 984, 16, 8},
    { 1016, 16, 40},
    { 1032, 0, 40},
    { 1040, -24, 72},
    { 1056, -24, 72},
    { 1024, -16, 40},
    { 1024, 8, 0},
    { 1056, -48, -16},
    { 1016, -32, -32},
    { 1328, -80, -80},
    { 1328, -96, -112},
    { 1344, -64, -48},
    { 1008, -40, -16},
    { 696, -24, -72},
    { 928, 64, -144},
    { 1208, 112, -72},
    { 1224, 128, -8},
    { 1112, 136, -24},
    { 1024, 104, -32},
    { 984, 152, -80},
    { 984, 168, -104},
    // 102 seconds
    { 1008, 112, -120},
    { 992, 64, -120},
    { 1000, 72, -112},
    { 1040, 56, -144},
    { 1032, 8, -168},
    { 1008, 32, -152},
    { 1096, -64, -184},
    { 1376, 32, -328},
    { 1160, -32, -376},
    { 1024, -40, -488},
    { 792, -40, -440},
    { 856, -16, -344},
    { 1056, -8, -304},
    { 1008, 0, -240},
    { 920, 64, -216},
    { 816, 64, -272},
    { 768, 56, -272},
    { 744, 48, -304},
    { 824, 40, -360},
    { 800, 32, -344},
    { 816, 56, -392},
    { 864, 72, -448},
    { 960, 72, -432},
    { 1032, 16, -392},
    { 1440, 80, -392},
    // 103 seconds
    { 1392, 64, -384},
    { 1184, 120, -408},
    { 872, 112, -368},
    { 808, 48, -352},
    { 1104, 32, -312},
    { 1152, -24, -232},
    { 1024, -40, -200},
    { 968, -32, -232},
    { 984, -32, -168},
    { 1000, -40, -112},
    { 1024, 0, -128},
    { 1008, 0, -112},
    { 984, -8, -88},
    { 984, -16, -72},
    { 1032, -8, -80},
    { 1120, -24, -56},
    { 1120, -16, -40},
    { 1056, -16, -88},
    { 1312, 0, -136},
    { 1448, -24, -96},
    { 1168, -32, -160},
    { 872, -40, -280},
    { 648, -32, -360},
    { 872, -24, -352},
    { 1136, -80, -240},
    // 104 seconds
    { 1136, -112, -200},
    { 984, -88, -224},
    { 896, -48, -312},
    { 944, 16, -336},
    { 944, 16, -360},
    { 968, 40, -400},
    { 904, 80, -432},
    { 880, 112, -432},
    { 848, 128, -456},
    { 896, 152, -448},
    { 920, 168, -432},
    { 944, 176, -368},
    { 1272, 192, -336},
    { 1272, 216, -352},
    { 1104, 208, -320},
    { 880, 112, -272},
    { 824, 8, -192},
    { 984, 0, -184},
    { 1120, -8, -192},
    { 1096, 32, -232},
    { 976, 8, -248},
    { 928, 16, -256},
    { 904, 8, -304},
    { 920, -8, -280},
    { 904, 0, -312},
    // 105 seconds
    { 880, 0, -304},
    { 936, 0, -280},
    { 960, 24, -248},
    { 976, 48, -240},
    { 968, 40, -240},
    { 1032, 24, -224},
    { 1384, -8, -128},
    { 1360, 16, -112},
    { 1120, -16, -168},
    { 1032, -16, -208},
    { 880, 0, -184},
    { 1056, 8, -168},
    { 1240, -32, -88},
    { 1152, -32, -48},
    { 984, -32, -56},
    { 936, 0, -128},
    { 880, 24, -184},
    { 888, -40, -256},
    { 976, -72, -240},
    { 1000, -112, -224},
    { 1008, -80, -216},
    { 1040, -72, -232},
    { 1080, -64, -216},
    { 1064, -40, -184},
    { 1096, -56, -176},
    // 106 seconds
    { 1320, -48, -152},
    { 1504, -16, -208},
    { 1208, -32, -144},
    { 968, -80, -120},
    { 816, -56, -144},
    { 968, -40, -136},
    { 1320, -56, -56},
    { 1320, -72, 8},
    { 1096, -96, 32},
    { 976, -40, 0},
    { 968, 8, -56},
    { 984, -16, -80},
    { 1008, -80, -64},
    { 1000, -104, -112},
    { 928, -144, -160},
    { 912, -160, -152},
    { 968, -136, -152},
    { 1040, -56, -144},
    { 1096, 24, -144},
    { 1224, 56, -112},
    { 1624, 80, -104},
    { 1384, 96, -144},
    { 1152, 80, -200},
    { 792, 72, -176},
    { 672, 64, -128},
    // 107 seconds
    { 1016, 64, -88},
    { 1208, 40, 32},
    { 1136, 48, 72},
    { 880, 48, 72},
    { 784, 96, -200},
    { 888, 64, -296},
    { 928, -96, -248},
    { 992, -168, -272},
    { 968, -232, -272},
    { 1008, -184, -304},
    { 1080, -128, -320},
    { 1104, -112, -288},
    { 1128, -64, -248},
    { 1728, 8, -256},
    { 1440, 0, -152},
    { 1208, -8, -80},
    { 888, 0, -112},
    { 896, 8, -72},
    { 1176, -32, 24},
    { 1312, -56, 184},
    { 1080, -136, 264},
    { 1128, -120, 112},
    { 1048, -96, 72},
    { 984, -112, 48},
    { 1080, -72, -16},
    // 108 seconds
    { 1048, -104, -8},
    { 1056, -104, -24},
    { 1064, -112, -24},
    { 1112, -72, -64},
    { 1192, -88, -48},
    { 1208, -80, -16},
    { 1256, -72, -16},
    { 1312, -32, 24},
    { 1368, -24, 96},
    { 1272, 24, 160},
    { 1184, 160, 88},
    { 1104, 136, 96},
    { 1120, 160, 128},
    { 1072, 144, 104},
    { 984, 96, 40},
    { 896, 88, 16},
    { 872, -8, -80},
    { 960, -104, -72},
    { 984, -96, -56},
    { 992, -80, -120},
    { 1000, -72, -192},
    { 1032, -96, -224},
    { 1088, -160, -224},
    { 1112, -128, -240},
    { 1088, -120, -272},
    // 109 seconds
    { 1064, -112, -296},
    { 1224, -120, -352},
    { 1208, -144, -352},
    { 1232, -168, -312},
    { 1224, -208, -272},
    { 1080, -144, -256},
    { 1048, -112, -240},
    { 1072, -176, -144},
    { 1160, -168, -96},
    { 1168, -160, -72},
    { 1088, -144, -32},
    { 1024, -96, -40},
    { 984, -24, -56},
    { 984, -24, -32},
    { 1040, -32, -40},
    { 1064, -48, -48},
    { 1024, -72, -88},
    { 984, -112, -96},
    { 960, -128, -96},
    { 1016, -104, -120},
    { 1080, -104, -128},
    { 1096, -120, -104},
    { 1192, -144, -80},
    { 1504, -112, -80},
    { 1312, -96, -64},
    // 110 seconds
    { 1176, -24, -136},
    { 928, -40, -216},
    { 664, -8, -232},
    { 752, -32, -144},
    { 1064, -56, -96},
    { 1288, -80, -104},
    { 1120, -72, -88},
    { 1024, -24, -128},
    { 944, -40, -120},
    { 960, -112, -80},
    { 992, -128, -112},
    { 1016, -112, -128},
    { 944, -96, -144},
    { 1000, -8, -176},
    { 1016, -16, -112},
    { 1056, 32, -112},
    { 1240, 32, -32},
    { 1408, 104, -56},
    { 1272, 160, -48},
    { 1072, 184, -32},
    { 856, 176, 40},
    { 1168, 208, 96},
    { 1144, 232, 136},
    { 1032, 240, 216},
    { 1008, 248, 168},
    // 111 seconds
    { 1008, 240, 160},
    { 1008, 240, 96},
    { 1008, 200, 32},
    { 1048, 152, 16},
    { 1072, 144, -24},
    { 1072, 144, -64},
    { 1104, 96, -88},
    { 1064, 24, -72},
    { 1440, 56, -144},
    { 1280, 8, -184},
    { 1032, 0, -272},
    { 760, 48, -408},
    { 824, 96, -360},
    { 1080, -8, -264},
    { 1192, -8, -208},
    { 1072, -40, -120},
    { 920, 16, -176},
    { 792, 56, -240},
    { 792, 0, -248},
    { 832, -32, -288},
    { 856, -48, -320},
    { 840, -72, -376},
    { 872, -72, -408},
    { 912, -72, -392},
    { 968, -88, -376},
    // 112 seconds
    { 1016, -88, -352},
    { 1104, -112, -336},
    { 1496, -80, -320},
    { 1344, -48, -336},
    { 928, -56, -296},
    { 680, -40, -288},
    { 1112, -16, -256},
    { 1336, -56, -120},
    { 1056, -96, -80},
    { 912, -56, -184},
    { 928, -24, -208},
    { 952, -48, -192},
    { 976, -64, -176},
    { 984, -88, -192},
    { 992, -72, -192},
    { 1000, -64, -192},
    { 1032, -72, -192},
    { 1120, -88, -176},
    { 1136, -80, -152},
    { 1432, -48, -208},
    { 1352, -80, -168},
    { 1040, -72, -216},
    { 720, -88, -264},
    { 824, -64, -288},
    { 1216, -48, -240},
    // 113 seconds
    { 1112, -128, -160},
    { 1008, -104, -200},
    { 920, -80, -256},
    { 920, -96, -256},
    { 936, -144, -224},
    { 952, -144, -240},
    { 920, -136, -264},
    { 920, -136, -256},
    { 896, -152, -256},
    { 896, -128, -256},
    { 912, -120, -248},
    { 984, -104, -256},
    { 1080, -104, -248},
    { 1144, -96, -272},
    { 1120, -96, -304},
    { 1576, -56, -424},
    { 1544, -104, -352},
    { 992, -144, -224},
    { 552, -88, -320},
    { 944, 16, -352},
    { 1432, -96, -144},
    { 1312, -152, -64},
    { 1080, -176, -56},
    { 1040, -120, -104},
    { 1000, -16, -160},
    // 114 seconds
    { 952, 48, -216},
    { 952, 168, -344},
    { 944, 216, -584},
    { 872, 280, -848},
    { 864, 272, -1088},
    { 760, -24, -1040},
    { 672, -72, -1048},
    { 608, -64, -1016},
    { 528, -128, -832},
    { 432, -176, -752},
    { 392, -160, -768},
    { 432, -240, -760},
    { 320, -232, -744},
    { 248, -208, -816},
    { 288, -280, -768},
    { 280, -288, -744},
    { 272, -336, -800},
    { 184, -360, -800},
    { 136, -368, -816},
    { 56, -376, -792},
    { -32, -376, -776},
    { -80, -392, -792},
    { -80, -408, -784},
    { -80, -400, -784},
    { -80, -408, -808},
    // 115 seconds
    { -72, -384, -888},
    { -64, -392, -920},
    { -64, -416, -888},
    { -64, -432, -888},
    { -64, -448, -848},
    { -56, -384, -880},
    { 112, -344, -1112},
    { 112, -256, -960},
    { 208, -256, -928},
    { 176, -184, -728},
    { 176, -88, -824},
    { 336, -128, -864},
    { 432, -160, -872},
    { 496, -112, -816},
    { 512, -88, -856},
    { 536, -40, -832},
    { 664, -32, -792},
    { 768, 8, -816},
    { 792, 16, -936},
    { 856, 32, -1048},
    { 808, -80, -960},
    { 816, 104, -1176},
    { 696, -32, -1160},
    { 816, -64, -1192},
    { 800, -96, -1120},
    // 116 seconds
    { 752, -120, -1040},
    { 640, -120, -968},
    { 544, -168, -816},
    { 400, -168, -744},
    { 328, -240, -680},
    { 240, -256, -672},
    { 136, -272, -640},
    { 64, -256, -696},
    { 64, -240, -744},
    { 80, -248, -784},
    { 32, -168, -896},
    { 24, -152, -936},
    { -16, -152, -912},
    { -40, -176, -928},
    { -56, -200, -904},
    { -64, -200, -824},
    { -64, -176, -856},
    { -48, -104, -912},
    { -8, -32, -992},
    { 0, -16, -1040},
    { -32, -64, -984},
    { -40, -96, -952},
    { -56, -112, -928},
    { -64, -72, -928},
    { -64, -48, -928},
    // 117 seconds
    { -136, 32, -808},
    { -40, 240, -1056},
    { 104, 152, -872},
    { 72, 152, -936},
    { 152, 192, -928},
    { 24, 88, -792},
    { 184, -48, -640},
    { 192, 328, -720},
    { 216, 560, -816},
    { 200, 552, -712},
    { 280, 640, -768},
    { 288, 656, -800},
    { 256, 784, -768},
    { 168, 832, -640},
    { 144, 912, -624},
    { 144, 800, -608},
    { 128, 584, -472},
    { 176, 624, -448},
    { 200, 688, -416},
    { 216, 608, -400},
    { 240, 680, -464},
    { 424, 672, -464},
    { 496, 720, -560},
    { 496, 776, -680},
    { 424, 640, -616},
    // 118 seconds
    { 392, 512, -536},
    { 480, 480, -600},
    { 584, 528, -656},
    { 520, 448, -632},
    { 472, 400, -624},
    { 448, 336, -616},
    { 464, 360, -680},
    { 512, 352, -728},
    { 520, 320, -736},
    { 512, 232, -744},
    { 512, 144, -720},
    { 536, 128, -752},
    { 584, 160, -776},
    { 584, 120, -776},
    { 656, 96, -744},
    { 712, 104, -720},
    { 776, 112, -664},
    { 1048, 152, -696},
    { 1136, 120, -600},
    { 976, 128, -512},
    { 896, 176, -448},
    { 920, 128, -416},
    { 968, 64, -336},
    { 928, 48, -288},
    { 960, 40, -288},
    // 119 seconds
    { 992, 24, -232},
    { 984, 0, -176},
    { 1000, 8, -144},
    { 1080, 32, -176},
    { 1080, 16, -152},
    { 1048, -32, -112},
    { 1088, -24, -136},
    { 1120, -40, -128},
    { 1120, -64, -96},
    { 1240, -88, 16},
    { 1744, -24, -56},
    { 1224, 0, -104},
    { 952, 0, -248},
    { 672, 48, -416},
    { 792, 64, -352},
    { 1176, -32, -200},
    { 1192, -128, -128},
    { 1016, -152, -120},
    { 984, -56, -224},
    { 936, 24, -264},
    { 904, 0, -296},
    { 872, 32, -272},
    { 880, 8, -288},
    { 840, 0, -272},
    { 856, 24, -312},
    // 120 seconds
    // elapsed: 2 minutes
    { 888, 56, -344},
    { 968, 72, -384},
    { 1048, 96, -408},
    { 1192, 48, -288},
    { 1528, 104, -328},
    { 1304, 136, -344},
    { 1048, 80, -312},
    { 840, -32, -192},
    { 944, -24, -168},
    { 1120, 40, -216},
    { 1088, 56, -208},
    { 1000, 56, -200},
    { 960, 8, -200},
    { 880, -8, -192},
    { 888, 8, -216},
    { 872, -16, -200},
    { 904, -32, -192},
    { 952, -16, -144},
    { 1008, 24, -128},
    { 1072, 56, -112},
    { 1224, 24, 16},
    { 1552, 88, -48},
    { 1328, 72, -104},
    { 992, 40, -192},
    { 784, -8, -120},
    // 121 seconds
    { 1032, 32, -16},
    { 1288, 64, 40},
    { 1120, 48, 0},
    { 1008, 88, -128},
    { 896, 72, -152},
    { 856, 56, -160},
    { 1024, 32, -160},
    { 1040, 0, -128},
    { 1048, -40, -160},
    { 1064, -48, -200},
    { 1144, -16, -216},
    { 1128, -48, -216},
    { 1216, -56, -176},
    { 1592, -40, -256},
    { 1328, -32, -176},
    { 1000, -24, -160},
    { 864, -8, -144},
    { 1264, 32, -120},
    { 1560, -24, 0},
    { 1288, -88, 40},
    { 1168, -112, 0},
    { 1056, -48, 8},
    { 1000, -24, -32},
    { 952, -32, -40},
    { 896, -72, -56},
    // 122 seconds
    { 856, -8, -40},
    { 824, -144, -48},
    { 912, -88, -88},
    { 928, -24, -128},
    { 1080, -208, -128},
    { 1400, 16, -224},
    { 1352, -16, -296},
    { 1240, -72, -344},
    { 1064, -16, -368},
    { 1040, 16, -224},
    { 1328, -8, -248},
    { 1160, 120, -264},
    { 1096, 208, -360},
    { 928, 232, -296},
    { 712, 128, -296},
    { 696, 208, -328},
    { 616, -8, -336},
    { 712, 160, -424},
    { 912, 168, -472},
    { 904, 56, -352},
    { 952, 88, -576},
    { 1096, 168, -320},
    { 1432, -352, -336},
    { 1424, 136, -264},
    { 1208, -16, -192},
    // 123 seconds
    { 984, 144, -176},
    { 888, 112, -32},
    { 896, 240, -120},
    { 848, 408, -104},
    { 736, 560, -168},
    { 800, 472, -168},
    { 800, 488, -176},
    { 872, 128, -104},
    { 872, 280, -208},
    { 920, 160, -64},
    { 960, 88, -232},
    { 1184, 128, -128},
    { 1104, -24, -88},
    { 1080, -72, -152},
    { 1208, 192, -280},
    { 1112, 224, -248},
    { 1136, 528, -128},
    { 1000, 112, 120},
    { 1168, 584, -336},
    { 1392, 376, -160},
    { 1240, 328, -232},
    { 1064, 256, -248},
    { 840, 72, -176},
    { 744, -56, -88},
    { 856, -72, 0},
    // 124 seconds
    { 1208, -136, 160},
    { 1456, -560, 376},
    { 1216, -520, 504},
    { 1032, -200, 272},
    { 928, 24, 128},
    { 992, -64, 48},
    { 984, -136, -32},
    { 1032, 48, -224},
    { 968, 72, -304},
    { 936, 48, -320},
    { 912, -56, -184},
    { 968, -56, -152},
    { 1024, -104, -128},
    { 1112, -96, -104},
    { 1128, -56, -72},
    { 1096, -96, -64},
    { 1232, -120, -32},
    { 1392, -256, 0},
    { 1104, -400, 152},
    { 1024, -192, 128},
    { 1008, 72, 48},
    { 936, 152, 72},
    { 1032, 168, 88},
    { 1000, 152, 144},
    { 1088, 192, 120},
    // 125 seconds
    { 1096, 96, 128},
    { 1088, 0, 128},
    { 1032, 8, 112},
    { 1072, 48, 80},
    { 1088, 144, 16},
    { 1072, 200, 24},
    { 1072, 176, 64},
    { 1048, 144, 80},
    { 1072, 80, 72},
    { 1096, 96, 80},
    { 1080, 112, 80},
    { 1184, 104, 136},
    { 1176, 104, 208},
    { 968, 96, 248},
    { 896, -80, 216},
    { 1128, -64, 0},
    { 1144, 136, -120},
    { 1152, 240, -160},
    { 1072, 168, -160},
    { 1016, 136, -168},
    { 968, 64, -160},
    { 976, -40, -152},
    { 1024, -56, -176},
    { 1040, -104, -192},
    { 1040, -112, -144},
    // 126 seconds
    { 1016, -48, -112},
    { 944, -80, -192},
    { 960, -112, -248},
    { 968, -80, -288},
    { 952, -88, -288},
    { 960, -56, -296},
    { 976, -112, -288},
    { 944, -184, -232},
    { 944, -192, -272},
    { 1312, -392, -392},
    { 1352, -160, -448},
    { 1160, 288, -312},
    { 1024, 88, 48},
    { 1040, 40, 144},
    { 1000, 24, 112},
    { 920, -8, 104},
    { 976, -8, 104},
    { 1144, 0, 96},
    { 1144, 8, 184},
    { 1096, 32, 168},
    { 1024, 48, 128},
    { 1032, 32, 96},
    { 1072, 8, 64},
    { 1096, -8, 32},
    { 1104, -32, -16},
    // 127 seconds
    { 1128, 16, -56},
    { 1072, 0, -56},
    { 1040, -8, -64},
    { 1048, 40, -96},
    { 1096, 80, -152},
    { 1088, 80, -168},
    { 1176, 80, -168},
    { 1408, 136, -256},
    { 1344, 120, -272},
    { 1080, 0, -240},
    { 768, -144, -160},
    { 800, -168, -48},
    { 1288, -288, 64},
    { 1128, -184, 376},
    { 1096, -680, 392},
    { 880, -392, 336},
    { 880, 24, 56},
    { 952, 40, -144},
    { 968, 152, -264},
    { 928, 216, -272},
    { 912, 96, -264},
    { 968, 120, -384},
    { 984, 56, -352},
    { 1032, 216, -424},
    { 1088, 368, -568},
    // 128 seconds
    { 1136, 248, -552},
    { 1360, 136, -400},
    { 1384, -64, -152},
    { 1128, 56, -120},
    { 896, 128, -72},
    { 784, -24, 88},
    { 920, 56, 128},
    { 1136, 96, 112},
    { 1104, 16, 64},
    { 1056, 120, -32},
    { 992, 104, -72},
    { 944, 48, -40},
    { 1000, -8, -40},
    { 1032, 0, -96},
    { 1032, -64, -88},
    { 1064, -32, -120},
    { 1072, -80, -112},
    { 1120, -16, -128},
    { 1128, -24, -160},
    { 1360, 8, -232},
    { 1384, 88, -272},
    { 1160, 144, -296},
    { 936, 152, -312},
    { 744, 0, -168},
    { 840, -232, 56},
    // 129 seconds
    { 1240, -168, 48},
    { 1408, -272, 184},
    { 880, -592, 392},
    { 856, -248, 256},
    { 952, 248, -136},
    { 896, 72, -160},
    { 952, 64, -168},
    { 896, 208, -296},
    { 904, 136, -336},
    { 984, 0, -368},
    { 1096, 8, -416},
    { 1136, 280, -568},
    { 1048, 360, -576},
    { 1360, 160, -368},
    { 1472, -280, -240},
    { 1112, -112, -136},
    { 960, 336, -160},
    { 808, 24, 128},
    { 1008, 120, 280},
    { 1112, 64, 280},
    { 1032, 48, 160},
    { 1016, 120, 24},
    { 968, 88, -56},
    { 992, 56, -48},
    { 1040, 0, -88},
    // 130 seconds
    { 1048, -32, -152},
    { 1048, -56, -176},
    { 1056, -40, -168},
    { 1096, -32, -160},
    { 1112, -8, -152},
    { 1080, 40, -152},
    { 1080, 56, -152},
    { 1336, 56, -208},
    { 1360, 96, -216},
    { 1112, 136, -160},
    { 816, 72, -104},
    { 776, -40, -8},
    { 1352, 0, -8},
    { 1344, -144, 296},
    { 976, -704, 408},
    { 952, -216, 136},
    { 952, 120, -80},
    { 952, 112, -80},
    { 984, 104, -192},
    { 928, 64, -224},
    { 976, 72, -296},
    { 968, 64, -328},
    { 976, 32, -208},
    { 1048, 16, -176},
    { 1080, 104, -152},
    // 131 seconds
    { 1072, 8, -160},
    { 1264, -144, -176},
    { 1200, -8, -96},
    { 1144, 48, -184},
    { 1144, 64, -144},
    { 968, -16, -32},
    { 888, -8, -56},
    { 920, -8, -8},
    { 1088, 32, 16},
    { 1200, 56, 16},
    { 1008, 8, 0},
    { 968, 48, -32},
    { 992, 48, -16},
    { 1064, 96, -16},
    { 1024, 0, 8},
    { 1064, -40, -24},
    { 1088, -8, -56},
    { 1056, 0, -32},
    { 1080, -40, 24},
    { 1120, -32, 8},
    { 1104, -40, -16},
    { 1376, -40, -64},
    { 1368, 32, -152},
    { 1040, 48, -208},
    { 848, -32, -112},
    // 132 seconds
    { 784, -64, 8},
    { 1064, -48, 104},
    { 1384, -40, 144},
    { 1072, 56, 240},
    { 1024, -480, 192},
    { 944, -456, 160},
    { 976, -248, 120},
    { 960, -24, -40},
    { 976, 264, -200},
    { 960, 296, -120},
    { 896, 240, -112},
    { 912, 232, -216},
    { 1024, 120, -352},
    { 1136, -8, -440},
    { 1152, 48, -464},
    { 1512, -48, -352},
    { 1432, -24, -224},
    { 1120, 296, -208},
    { 1000, 240, -56},
    { 856, 0, 104},
    { 864, -24, 216},
    { 1032, 80, 256},
    { 1032, 240, 248},
    { 1016, 264, 264},
    { 992, 120, 248},
    // 133 seconds
    { 1000, 40, 184},
    { 1096, 72, 144},
    { 1144, 48, 136},
    { 1120, 40, 136},
    { 1096, 56, 136},
    { 1104, 32, 136},
    { 1064, 48, 168},
    { 1096, 104, 224},
    { 1088, 216, 264},
    { 1176, 224, 296},
    { 1144, 248, 304},
    { 1016, 312, 200},
    { 1024, 248, 72},
    { 1080, 48, -64},
    { 1128, -152, -288},
    { 1136, 32, -504},
    { 984, 176, -368},
    { 1008, 248, -288},
    { 1008, 8, -88},
    { 1040, -16, 0},
    { 1016, -104, 8},
    { 1072, -368, -72},
    { 1008, -200, -64},
    { 984, 24, -104},
    { 1016, 48, -216},
    // 134 seconds
    { 992, 32, -216},
    { 944, -72, -216},
    { 976, -80, -312},
    { 944, 16, -336},
    { 992, 0, -392},
    { 1064, -160, -328},
    { 1088, -104, -328},
    { 1184, -88, -336},
    { 1304, -368, -328},
    { 1248, -192, -16},
    { 1136, 168, 48},
    { 936, 48, 128},
    { 888, -120, 184},
    { 1064, 16, 200},
    { 992, 128, 192},
    { 1088, 104, 264},
    { 1040, 40, 160},
    { 1080, -64, 64},
    { 1064, -96, 72},
    { 1008, 80, 24},
    { 1112, 208, 8},
    { 1040, 120, 8},
    { 992, 72, -40},
    { 1048, -72, -48},
    { 1048, -16, 72},
    // 135 seconds
    { 1176, 312, -32},
    { 1008, 272, -8},
    { 1032, 168, 24},
    { 1064, 136, 16},
    { 1088, 120, -56},
    { 1072, 176, -64},
    { 1024, 152, -64},
    { 1048, 128, -80},
    { 1136, 120, -40},
    { 1192, 208, -64},
    { 1216, 280, -72},
    { 1008, 280, -56},
    { 1056, 0, 16},
    { 1312, -176, 32},
    { 1328, -304, 312},
    { 1208, -352, 240},
    { 1048, -168, 104},
    { 960, -32, 48},
    { 976, 168, -32},
    { 880, 128, -184},
    { 944, 152, -264},
    { 928, 160, -136},
    { 960, 248, -24},
    { 976, 104, -40},
    { 976, 112, -136},
    // 136 seconds
    { 928, 88, -64},
    { 960, 112, 8},
    { 1024, 80, -40},
    { 1040, -24, -64},
    { 1080, -120, 72},
    { 1056, -80, 64},
    { 976, -16, 8},
    { 936, 64, -112},
    { 944, 80, -88},
    { 1048, 40, -112},
    { 1040, 32, -112},
    { 1144, -72, -144},
    { 1104, 24, -88},
    { 1120, 288, -264},
    { 1672, 144, -304},
    { 1472, -160, 56},
    { 1056, 80, 232},
    { 864, -48, 104},
    { 880, -136, 192},
    { 984, -40, 296},
    { 1064, 24, 312},
    { 1176, 48, 296},
    { 1096, 8, 224},
    { 984, -48, 136},
    { 992, -56, 112},
    // 137 seconds
    { 1016, -40, 136},
    { 1056, -8, 104},
    { 1040, 48, 80},
    { 1000, 112, 72},
    { 1024, 128, 32},
    { 1040, 136, 48},
    { 1056, 160, 32},
    { 1112, 216, -16},
    { 1128, 184, -40},
    { 1136, 128, -80},
    { 1464, 112, -120},
    { 1480, 72, -128},
    { 1008, 8, -136},
    { 768, -48, -104},
    { 944, -72, -24},
    { 1224, -112, 176},
    { 1128, -176, 296},
    { 1064, -96, 256},
    { 968, -144, 200},
    { 872, -224, 80},
    { 928, -40, -64},
    { 952, 72, -192},
    { 952, 168, -224},
    { 1008, 144, -192},
    { 984, 64, -120},
    // 138 seconds
    { 944, 56, -80},
    { 1008, -8, -56},
    { 1064, 64, -80},
    { 1096, 176, -144},
    { 1096, 216, -216},
    { 1344, 136, -200},
    { 1368, -320, -264},
    { 1064, -216, -104},
    { 1200, 744, -184},
    { 1064, 104, 32},
    { 944, -88, 160},
    { 920, -56, 264},
    { 1040, -40, 216},
    { 1088, 120, 120},
    { 1120, 232, 80},
    { 1136, 176, 88},
    { 1008, 192, 40},
    { 968, 224, 16},
    { 992, 296, -40},
    { 984, 448, -128},
    { 1000, 496, -88},
    { 928, 488, -64},
    { 936, 408, -168},
    { 992, 256, -376},
    { 912, 160, -216},
    // 139 seconds
    { 920, 224, -120},
    { 1016, 304, -144},
    { 1096, 352, -96},
    { 1088, 352, 24},
    { 984, 328, 104},
    { 1088, 336, 200},
    { 1280, 328, 192},
    { 960, 296, 176},
    { 1104, 264, 72},
    { 944, 104, 0},
    { 928, -24, -48},
    { 1000, -296, -80},
    { 1208, -440, -128},
    { 1232, -288, -168},
    { 1296, -272, 0},
    { 1000, -208, 24},
    { 896, -64, 0},
    { 872, 80, -56},
    { 896, 256, -112},
    { 928, 240, -96},
    { 984, 128, -96},
    { 952, 88, -120},
    { 912, 56, -80},
    { 936, 8, -80},
    { 1040, 48, -136},
    // 140 seconds
    { 1112, 312, -200},
    { 1184, 456, -152},
    { 1288, 104, -160},
    { 1512, -240, -64},
    { 1344, -360, 32},
    { 1056, 640, -144},
    { 760, 616, -80},
    { 896, 64, 128},
    { 1096, -152, 184},
    { 1152, -8, 320},
    { 1072, 64, 272},
    { 1056, 80, 184},
    { 1000, 0, 160},
    { 1000, 8, 144},
    { 1056, 56, 144},
    { 1088, 88, 96},
    { 1072, 120, 40},
    { 1040, 224, 8},
    { 992, 328, 0},
    { 976, 336, 40},
    { 960, 360, 24},
    { 928, 416, -8},
    { 888, 432, 0},
    { 960, 360, 32},
    { 1120, 280, 96},
    // 141 seconds
    { 1448, 224, 152},
    { 1320, 0, -80},
    { 936, -488, -584},
    { 912, -712, -416},
    { 960, -272, -344},
    { 1088, -152, 56},
    { 1216, -88, 128},
    { 968, -120, 168},
    { 896, -80, 128},
    { 992, -32, 32},
    { 1064, -56, -176},
    { 1056, -144, -520},
    { 1048, 528, -360},
    { 1024, 160, -88},
    { 1128, -80, -24},
    { 1104, -56, -48},
    { 1096, -16, -128},
    { 1104, -88, -200},
    { 1128, -168, -128},
    { 1080, -160, -24},
    { 1088, -176, 0},
    { 1072, -144, -8},
    { 1048, -104, -48},
    { 1064, -120, -64},
    { 1072, -168, -96},
    // 142 seconds
    { 1064, -200, -128},
    { 1080, -240, -144},
    { 1048, -216, -96},
    { 1072, -192, -96},
    { 1112, -256, -104},
    { 1104, -352, -160},
    { 1152, -296, -256},
    { 1056, -232, -224},
    { 1048, -168, -288},
    { 1032, -144, -312},
    { 968, -176, -496},
    { 888, -160, -504},
    { 832, -128, -672},
    { 848, -80, -672},
    { 832, -216, -528},
    { 784, -232, -360},
    { 720, -376, -272},
    { 720, -456, -288},
    { 712, -496, -288},
    { 672, -504, -344},
    { 704, -520, -424},
    { 680, -552, -496},
    { 760, -488, -536},
    { 752, -488, -480},
    { 848, -536, -392},
    // 143 seconds
    { 904, -584, -320},
    { 872, -504, -240},
    { 880, -504, -200},
    { 880, -544, -224},
    { 904, -648, -288},
    { 848, -616, -368},
    { 824, -584, -424},
    { 832, -504, -528},
    { 936, -464, -552},
    { 848, -440, -352},
    { 760, -432, -192},
    { 672, -312, -88},
    { 752, -232, -56},
    { 1112, -96, -168},
    { 1368, -32, -56},
    { 1272, 112, 56},
    { 1448, 248, 0},
    { 1384, 336, -176},
    { 1128, 392, -280},
    { 984, 248, -256},
    { 1040, 80, -80},
    { 1104, 0, 8},
    { 1120, -24, 0},
    { 1096, -40, -40},
    { 1088, 16, -80},
    // 144 seconds
    { 1120, 56, -120},
    { 1120, 40, -160},
    { 1144, -8, -160},
    { 1176, -80, -144},
    { 1312, -136, -16},
    { 1592, -80, -32},
    { 1168, -72, -48},
    { 624, 0, -152},
    { 536, -40, -128},
    { 1008, -40, -32},
    { 1312, -152, 136},
    { 1040, -24, 224},
    { 904, -120, 200},
    { 880, -16, -88},
    { 984, 80, -240},
    { 1000, -16, -344},
    { 896, 80, -384},
    { 880, 216, -352},
    { 936, 344, -416},
    { 1000, 400, -424},
    { 1008, 456, -352},
    { 1136, 88, -200},
    { 1536, -56, -192},
    { 1312, 160, -192},
    { 1176, 208, 24},
    // 145 seconds
    { 1000, 112, 72},
    { 848, 88, 128},
    { 960, 176, 208},
    { 976, 176, 216},
    { 920, 224, 32},
    { 1008, 440, -152},
    { 1032, 336, -112},
    { 976, 184, -32},
    { 976, 152, -24},
    { 1024, 168, -48},
    { 1032, 152, -48},
    { 1056, 136, 32},
    { 1152, 32, 56},
    { 1216, -48, 96},
    { 1200, -24, 48},
    { 1552, -8, -48},
    { 1328, 104, -288},
    { 984, 192, -392},
    { 760, -48, -200},
    { 880, -128, -88},
    { 1160, -168, 112},
    { 1264, -208, 288},
    { 1008, -56, 320},
    { 920, -128, 280},
    { 912, -32, 104},
    // 146 seconds
    { 920, 24, -24},
    { 1008, -8, -88},
    { 992, 80, -264},
    { 928, 224, -264},
    { 904, 88, -152},
    { 936, 0, -136},
    { 1064, 24, -104},
    { 1032, 304, -168},
    { 1080, 312, -104},
    { 1616, 184, -176},
    { 1496, -384, -16},
    { 976, 296, 64},
    { 752, 152, 96},
    { 912, -112, 168},
    { 1192, 24, 312},
    { 1120, -8, 360},
    { 1024, 24, 208},
    { 992, 96, 16},
    { 976, 32, 64},
    { 1016, 8, 72},
    { 1096, -40, 24},
    { 1088, -40, -8},
    { 1072, -8, -16},
    { 1112, -48, 24},
    { 1104, 0, -32},
    // 147 seconds
    { 1256, 56, 48},
    { 1608, 64, 56},
    { 1280, 88, 24},
    { 784, 32, -64},
    { 560, 0, -48},
    { 1048, -80, 128},
    { 1264, -120, 232},
    { 920, -176, 312},
    { 904, -344, 144},
    { 832, 40, -168},
    { 904, 224, -288},
    { 920, 288, -264},
    { 928, 288, -160},
    { 920, 192, -120},
    { 984, 176, -184},
    { 1072, 208, -216},
    { 1072, 520, -272},
    { 1104, 536, -320},
    { 1600, 16, -424},
    { 1248, 160, -208},
    { 1000, 408, -112},
    { 872, 184, -48},
    { 1000, 144, 104},
    { 1216, 240, 152},
    { 920, 200, 240},
    // 148 seconds
    { 936, 264, 240},
    { 944, 176, 232},
    { 936, 104, 192},
    { 1000, 120, 152},
    { 1064, 88, 128},
    { 1064, 112, 40},
    { 1040, 112, -8},
    { 1032, 96, 0},
    { 1064, 72, 16},
    { 1128, 80, -8},
    { 1120, 136, -32},
    { 1104, 248, -72},
    { 1352, 384, -40},
    { 1264, 320, -16},
    { 1000, 352, -32},
    { 864, 232, -104},
    { 696, 48, -192},
    { 1296, -336, -424},
    { 1256, -424, -224},
    { 1088, -352, 32},
    { 1040, -128, 16},
    { 1008, 144, 8},
    { 928, 184, 32},
    { 864, 72, 72},
    { 864, 8, 64},
    // 149 seconds
    { 904, 88, -48},
    { 936, 112, -56},
    { 976, 40, -80},
    { 1024, -16, -128},
    { 1064, -8, -184},
    { 1152, 208, -264},
    { 1216, 624, -288},
    { 1584, 336, -272},
    { 1456, -424, -88},
    { 992, 304, -152},
    { 816, 272, -8},
    { 752, 16, 8},
    { 928, -8, 72},
    { 1208, 96, 136},
    { 1136, 120, 152},
    { 1096, 136, 104},
    { 992, 112, 120},
    { 896, 80, 136},
    { 936, 48, 128},
    { 960, -8, 104},
    { 1000, -32, 72},
    { 1056, -56, 40},
    { 1128, -16, -8},
    { 1112, 40, -48},
    { 1128, 80, -88},
    // 150 seconds
    { 1376, 136, -96},
    { 1480, 184, -200},
    { 1080, 160, -184},
    { 984, 72, -240},
    { 856, 8, -168},
    { 752, -96, 16},
    { 1064, -128, 112},
    { 1352, -160, 152},
    { 1024, 80, 168},
    { 968, 152, 184},
    { 928, 24, 104},
    { 992, -16, 96},
    { 1056, -32, -16},
    { 1032, 72, -144},
    { 976, 104, -168},
    { 976, 128, -144},
    { 1032, 160, -104},
    { 1248, 168, -48},
    { 1176, 136, 64},
    { 1024, 208, 216},
    { 992, 200, 328},
    { 1000, 328, 472},
    { 976, 256, 440},
    { 1024, 304, 256},
    { 1040, 328, 112},
    // 151 seconds
    { 1072, 216, 48},
    { 1072, 104, 32},
    { 1104, 192, 8},
    { 1072, 144, 64},
    { 1088, 128, 96},
    { 1056, 152, 96},
    { 1048, 232, 64},
    { 1032, 280, 64},
    { 1000, 256, 72},
    { 992, 208, 112},
    { 1000, 136, 80},
    { 1016, 160, 40},
    { 1024, 208, 16},
    { 1040, 240, -16},
    { 1008, 208, 0},
    { 1216, 240, 56},
    { 1112, 264, 80},
    { 1240, 216, -8},
    { 1048, 184, -176},
    { 1144, -320, -168},
    { 1160, -312, -64},
    { 1080, -272, 112},
    { 1088, -24, 160},
    { 1040, -160, 280},
    { 944, -168, 192},
    // 152 seconds
    { 944, 40, 64},
    { 928, 88, -88},
    { 968, 72, -72},
    { 928, -56, -80},
    { 912, -32, -96},
    { 928, -224, -88},
    { 1112, 80, -336},
    { 1120, 360, -464},
    { 1464, 96, -344},
    { 1416, -96, -160},
    { 1136, 96, -104},
    { 968, 176, 0},
    { 840, 24, 120},
    { 784, -8, 224},
    { 1016, 72, 232},
    { 1184, 32, 152},
    { 1112, 144, 0},
    { 1064, 264, -56},
    { 992, 192, -24},
    { 1040, 192, 8},
    { 1048, 128, -40},
    { 1072, 24, -24},
    { 1096, -8, -64},
    { 1072, -56, -88},
    { 1064, 56, -120},
    // 153 seconds
    { 1112, 80, -168},
    { 1352, 176, -128},
    { 1208, 152, -88},
    { 1040, 136, -128},
    { 936, 80, -88},
    { 880, 0, 40},
    { 1176, -64, 120},
    { 1416, -304, 224},
    { 1048, -672, 272},
    { 856, -440, 272},
    { 872, 16, -8},
    { 936, 264, -240},
    { 912, 264, -104},
    { 904, 168, -48},
    { 904, 136, -80},
    { 992, 176, -208},
    { 1064, 88, -280},
    { 1080, 224, -296},
    { 1096, 528, -360},
    { 1304, 232, -376},
    { 1608, -112, -336},
    { 1200, 136, -128},
    { 1000, 312, -56},
    { 856, 16, 56},
    { 824, -40, 112},
    // 154 seconds
    { 1064, -24, 184},
    { 1168, 64, 248},
    { 1032, 72, 288},
    { 1064, 72, 256},
    { 1000, 0, 160},
    { 960, 32, 120},
    { 1048, 64, 48},
    { 1064, 32, -8},
    { 1072, 24, -48},
    { 1040, 8, -40},
    { 1048, -40, -16},
    { 1080, -40, -24},
    { 1120, -8, -32},
    { 1080, 8, -40},
    { 1088, 104, -72},
    { 1472, 176, -56},
    { 1312, 176, -72},
    { 1032, 224, -120},
    { 760, 40, -184},
    { 856, -72, -152},
    { 1272, -56, -72},
    { 1280, -208, 16},
    { 1136, -648, 56},
    { 864, -272, 8},
    { 856, -24, -32},
    // 155 seconds
    { 872, 48, -80},
    { 912, 216, -120},
    { 912, 184, -144},
    { 880, 112, -96},
    { 912, 104, -152},
    { 976, -40, -192},
    { 1040, 136, -256},
    { 1096, 424, -296},
    { 1440, 264, -288},
    { 1432, 168, -200},
    { 1280, 216, -144},
    { 992, 224, -8},
    { 776, 88, 16},
    { 784, 64, 24},
    { 1000, 112, 24},
    { 1216, 168, 64},
    { 1120, 248, 56},
    { 1000, 88, 152},
    { 968, 64, 104},
    { 944, 80, 48},
    { 952, 32, 32},
    { 984, 40, -8},
    { 1096, 112, -104},
    { 1120, 216, -80},
    { 1104, 288, -32},
    // 156 seconds
    { 1072, 296, 0},
    { 1392, 312, 8},
    { 1288, 336, 0},
    { 1048, 336, -80},
    { 792, 112, -168},
    { 744, -24, -64},
    { 1296, -504, -200},
    { 1192, -336, 128},
    { 1088, -288, 272},
    { 968, -8, 112},
    { 896, 376, -200},
    { 896, 272, -64},
    { 928, 48, 8},
    { 904, 56, -32},
    { 904, 72, -64},
    { 976, 80, -72},
    { 1064, 192, -128},
    { 1120, 352, -168},
    { 1272, 288, -264},
    { 1608, 88, -304},
    { 1344, 8, -72},
    { 1024, 0, 8},
    { 776, 56, 88},
    { 824, -16, 192},
    { 1216, 96, 304},
    // 157 seconds
    { 1120, 64, 448},
    { 1000, 0, 384},
    { 1000, -8, 248},
    { 1000, 24, 136},
    { 1032, 8, 120},
    { 1064, -24, 72},
    { 1104, -32, 0},
    { 1104, 0, -56},
    { 1080, 16, -80},
    { 1072, 24, -56},
    { 1064, 16, -72},
    { 1264, 24, -8},
    { 1512, 32, 64},
    { 1224, 48, 64},
    { 904, 24, -48},
    { 776, 32, -32},
    { 896, -176, 136},
    { 1120, -280, 280},
    { 1448, -1136, 192},
    { 896, -728, 304},
    { 872, -80, 200},
    { 920, 256, -64},
    { 928, 456, -168},
    { 912, 344, -72},
    { 864, 136, -16},
    // 158 seconds
    { 920, 264, -144},
    { 1040, -40, -352},
    { 1112, 152, -528},
    { 1152, 416, -672},
    { 1336, 480, -648},
    { 1552, 216, -416},
    { 1264, 32, 40},
    { 1080, 40, 80},
    { 856, 16, 104},
    { 824, -72, 160},
    { 1008, 32, 184},
    { 1160, 112, 248},
    { 1048, 72, 232},
    { 992, 8, 184},
    { 984, -16, 88},
    { 1000, -8, 40},
    { 1024, 0, 40},
    { 1048, -8, -8},
    { 1080, -8, -40},
    { 1072, 8, -40},
    { 1080, 0, -32},
    { 1104, 16, -56},
    { 1104, 80, -64},
    { 1088, 136, -80},
    { 1112, 168, -88},
    // 159 seconds
    { 1488, 176, -104},
    { 1176, 152, -80},
    { 1000, 176, -72},
    { 912, 104, -160},
    { 744, -16, -72},
    { 1072, -72, -40},
    { 1368, -112, 16},
    { 1104, -128, 32},
    { 1040, -440, 64},
    { 936, -104, 0},
    { 968, 64, 24},
    { 936, 128, -16},
    { 960, 248, -120},
    { 904, 232, -80},
    { 936, 160, -120},
    { 968, 64, -168},
    { 984, 96, -120},
    { 1016, 104, -128},
    { 1064, 144, -112},
    { 1072, 224, -136},
    { 1112, 320, -184},
    { 1248, 192, -160},
    { 1328, 176, -208},
    { 1064, 184, -96},
    { 1072, 328, -80},
    // 160 seconds
    { 992, 136, 8},
    { 944, 56, 64},
    { 880, 72, 56},
    { 952, 120, 8},
    { 1160, 184, 32},
    { 1152, 152, 104},
    { 1040, 32, 160},
    { 968, -16, 168},
    { 1024, 40, 152},
    { 1080, 80, 176},
    { 1080, 120, 168},
    { 1096, 152, 136},
    { 1088, 152, 136},
    { 1072, 160, 112},
    { 1088, 184, 120},
    { 1072, 168, 96},
    { 1064, 144, 96},
    { 1072, 160, 48},
    { 1152, 200, 32},
    { 1176, 176, 96},
    { 1072, 128, 136},
    { 1032, 88, 152},
    { 1032, 40, 80},
    { 992, -240, -200},
    { 1176, -344, -352},
    // 161 seconds
    { 1088, -72, -184},
    { 1056, -8, -56},
    { 928, 16, 16},
    { 928, -8, -40},
    { 928, -40, -112},
    { 960, -176, -200},
    { 1032, -368, -160},
    { 992, -64, -120},
    { 976, -8, -280},
    { 952, -16, -320},
    { 896, -24, -424},
    { 880, -8, -440},
    { 976, 0, -392},
    { 952, 8, -296},
    { 960, -32, -240},
    { 920, -64, -280},
    { 952, -48, -344},
    { 936, 8, -336},
    { 1200, -112, -440},
    { 1600, -144, -288},
    { 1248, 240, -240},
    { 1024, 232, -112},
    { 896, -104, 208},
    { 1048, 136, 376},
    { 1168, 384, 368},
    // 162 seconds
    { 1064, 112, 144},
    { 896, -144, -432},
    { 976, -400, 40},
    { 1000, -400, 264},
    { 1072, -16, 320},
    { 1088, 88, 248},
    { 1048, 16, 248},
    { 1064, -80, 192},
    { 1040, -160, 184},
    { 1040, -152, 144},
    { 1080, 0, 40},
    { 1144, 32, 24},
    { 1136, -16, 56},
    { 1176, -24, 64},
    { 1240, -48, 56},
    { 1544, -48, -8},
    { 1352, -40, -32},
    { 968, 64, -128},
    { 656, 96, -88},
    { 736, 8, -48},
    { 1024, 40, 64},
    { 1160, 32, 144},
    { 1016, 8, 288},
    { 936, -296, 200},
    { 896, 0, -128},
    // 163 seconds
    { 912, 208, -360},
    { 936, 168, -408},
    { 888, 208, -352},
    { 856, 208, -280},
    { 936, 192, -304},
    { 968, 208, -320},
    { 1024, 328, -432},
    { 1040, 464, -432},
    { 1376, 176, -232},
    { 1392, -56, -160},
    { 1112, 304, -144},
    { 1008, 168, 64},
    { 912, 128, 112},
    { 848, 136, 208},
    { 928, 184, 200},
    { 1000, 256, 88},
    { 968, 288, 56},
    { 1032, 240, -16},
    { 1056, 176, -24},
    { 1040, 192, -8},
    { 1072, 32, 16},
    { 1072, 32, 16},
    { 1056, 72, 16},
    { 1096, 48, 32},
    { 1112, 56, 48},
    // 164 seconds
    { 1136, 72, 40},
    { 1136, 64, -8},
    { 1224, 96, -64},
    { 1320, 168, -136},
    { 1048, 304, -200},
    { 880, 176, -208},
    { 672, 56, -80},
    { 912, 16, 0},
    { 1280, 96, 64},
    { 1168, 168, 224},
    { 1080, 120, 264},
    { 1016, 56, 176},
    { 992, 128, 32},
    { 992, 104, -48},
    { 992, -24, -80},
    { 1088, -384, -16},
    { 976, -96, 0},
    { 968, 176, -88},
    { 960, 160, -120},
    { 1056, 168, -128},
    { 1096, 248, -48},
    { 1456, 360, -80},
    { 1312, 224, -88},
    { 1104, 136, -144},
    { 944, 152, 8},
    // 165 seconds
    { 816, 184, 168},
    { 840, 264, 128},
    { 1016, 160, 56},
    { 1072, 152, 48},
    { 1064, 136, 32},
    { 992, 152, 0},
    { 1000, 200, -56},
    { 992, 248, -8},
    { 984, 248, 32},
    { 1024, 200, -24},
    { 1064, 176, 0},
    { 1104, 144, 48},
    { 1056, 120, 112},
    { 1064, 168, 48},
    { 1048, 200, 56},
    { 1376, 296, 48},
    { 1216, 352, 64},
    { 1056, 256, -24},
    { 816, 80, -88},
    { 880, -248, -224},
    { 1336, -712, -408},
    { 1160, -152, 168},
    { 984, -24, 72},
    { 904, 240, -88},
    { 968, 256, -104},
    // 166 seconds
    { 888, -48, -104},
    { 912, 56, -168},
    { 864, 224, -200},
    { 912, 280, -152},
    { 952, 200, -104},
    { 984, 192, -128},
    { 1032, 304, -256},
    { 1048, 456, -360},
    { 1000, 608, -336},
    { 1192, 248, -216},
    { 1480, 112, -240},
    { 1224, 232, -176},
    { 896, 392, -64},
    { 840, 104, 32},
    { 1016, 160, 200},
    { 1056, 200, 280},
    { 944, 152, 336},
    { 968, 160, 232},
    { 1024, 160, 96},
    { 992, 144, 64},
    { 1032, 168, 48},
    { 1080, 176, -56},
    { 1072, 216, -168},
    { 1040, 168, -144},
    { 1024, 88, -88},
    // 167 seconds
    { 1040, 72, -80},
    { 1040, 80, -88},
    { 1064, 128, -72},
    { 1104, 192, -40},
    { 1112, 248, -24},
    { 1144, 304, -48},
    { 1416, 392, -72},
    { 1160, 368, -64},
    { 984, 256, -104},
    { 824, 16, -128},
    { 752, -80, -112},
    { 1144, -96, -64},
    { 1464, -312, -48},
    { 1120, -536, 136},
    { 1016, -176, 104},
    { 1016, 112, 24},
    { 888, 288, -128},
    { 952, 336, -208},
    { 856, 80, -208},
    { 840, 112, -256},
    { 792, 136, -200},
    { 808, 136, -168},
    { 872, 160, -152},
    { 952, 168, -168},
    { 1040, 152, -240},
    // 168 seconds
    { 1096, 56, -328},
    { 1104, 256, -392},
    { 1352, 400, -352},
    { 1696, 176, -408},
    { 1072, -48, -104},
    { 888, 272, -104},
    { 792, 8, -48},
    { 912, -8, 8},
    { 1024, 72, 56},
    { 1008, 40, 80},
    { 1088, 160, 48},
    { 1048, 64, 48},
    { 1000, 72, 8},
    { 968, 64, -8},
    { 968, 80, -40},
    { 1000, 64, -56},
    { 1032, 72, -64},
    { 1056, 72, -80},
    { 1064, 104, -112},
    { 1080, 128, -144},
    { 1064, 128, -152},
    { 1176, 136, -152},
    { 1552, 192, -256},
    { 1240, 192, -200},
    { 1024, 144, -232},
    // 169 seconds
    { 776, 0, -192},
    { 904, -64, -168},
    { 1264, -80, 0},
    { 1208, -48, 216},
    { 1096, 48, 264},
    { 976, -72, 336},
    { 928, -56, 192},
    { 976, 24, 16},
    { 992, 64, -192},
    { 960, 160, -288},
    { 952, 112, -312},
    { 936, 96, -288},
    { 952, 48, -232},
    { 960, 48, -200},
    { 1008, -24, -168},
    { 1040, 24, -112},
    { 1056, 48, -16},
    { 1448, 104, 56},
    { 1296, 208, -8},
    { 928, -24, 120},
    { 1120, 240, 192},
    { 992, 224, 200},
    { 944, 232, 192},
    { 968, 184, 168},
    { 928, 192, 128},
    // 170 seconds
    { 992, 256, 152},
    { 1056, 264, 88},
    { 976, 184, 72},
    { 1008, 168, 88},
    { 1024, 200, 136},
    { 1160, 216, 112},
    { 1176, 160, 200},
    { 1072, 120, 256},
    { 1072, 96, 144},
    { 1048, 64, 48},
    { 1056, 160, -48},
    { 1008, 256, -24},
    { 1000, 296, 24},
    { 1008, 264, 88},
    { 992, 200, 160},
    { 1048, 160, 216},
    { 1032, 112, 288},
    { 1048, 136, 280},
    { 1016, 200, 184},
    { 1024, 200, 120},
    { 1128, 224, 128},
    { 1216, 192, 120},
    { 968, 192, 80},
    { 1104, 152, -16},
    { 1208, -264, -248},
    // 171 seconds
    { 1264, -152, -112},
    { 1048, -208, 208},
    { 1032, -8, 248},
    { 1104, 64, 288},
    { 920, -152, 304},
    { 912, -80, 240},
    { 952, 8, 112},
    { 1008, 184, -80},
    { 984, 16, -104},
    { 896, -144, -32},
    { 896, -176, 8},
    { 984, -96, -40},
    { 1160, 208, -136},
    { 1168, 528, -240},
    { 1696, 144, -144},
    { 1576, -216, -88},
    { 992, 200, -224},
    { 736, 152, 0},
    { 792, -40, 120},
    { 1104, 248, 312},
    { 1096, 136, 280},
    { 880, 64, 200},
    { 1008, 224, 112},
    { 984, 152, 120},
    { 1048, 192, 144},
    // 172 seconds
    { 984, 120, 128},
    { 1072, 104, 72},
    { 1112, 88, 72},
    { 1136, -24, 32},
    { 1064, -88, -32},
    { 1360, -32, 8},
    { 1528, 40, 8},
    { 976, 216, -48},
    { 624, 80, -48},
    { 1032, -24, -56},
    { 1352, -168, 136},
    { 1024, -176, 200},
    { 1000, -48, 96},
    { 816, 280, -184},
    { 776, 344, -264},
    { 760, 200, -176},
    { 832, 176, -168},
    { 840, 168, -144},
    { 840, 192, -88},
    { 1000, 96, -176},
    { 1088, -24, -312},
    { 1056, 232, -336},
    { 1128, 496, -288},
    { 1792, 168, -312},
    { 1336, -64, -80},
    // 173 seconds
    { 1056, 200, 56},
    { 872, 184, 160},
    { 896, 56, 256},
    { 1064, 8, 472},
    { 1016, -24, 536},
    { 1048, 16, 400},
    { 1128, 136, 232},
    { 1072, 184, 176},
    { 1056, 184, 104},
    { 1056, 144, 64},
    { 1088, 96, 96},
    { 1152, 112, 184},
    { 1080, 136, 256},
    { 1048, 128, 264},
    { 1024, 184, 232},
    { 1048, 240, 200},
    { 1048, 296, 176},
    { 1040, 312, 168},
    { 1056, 336, 120},
    { 1112, 312, 88},
    { 1072, 224, 136},
    { 992, 88, 80},
    { 928, -288, -728},
    { 1256, -40, -200},
    { 1112, 208, -24},
    // 174 seconds
    { 960, 0, 40},
    { 920, -40, 96},
    { 1016, 40, -88},
    { 936, -56, -8},
    { 976, 112, -80},
    { 960, 216, -192},
    { 960, 232, -296},
    { 912, 176, -288},
    { 888, 104, -264},
    { 952, 96, -272},
    { 1040, 80, -240},
    { 1064, 72, -136},
    { 1136, 32, -216},
    { 1312, 40, -400},
    { 1376, -72, -328},
    { 1408, 112, -128},
    { 1040, 24, 72},
    { 896, -168, 168},
    { 1096, -112, 152},
    { 1016, -136, 264},
    { 968, -80, 304},
    { 944, -128, 272},
    { 1024, -16, 144},
    { 1048, 16, 64},
    { 1072, 24, 16},
    // 175 seconds
    { 1056, 24, -48},
    { 1080, 80, -96},
    { 1056, 112, -112},
    { 1032, 176, -120},
    { 1016, 120, -136},
    { 1032, 128, -160},
    { 1064, 128, -176},
    { 1080, 96, -152},
    { 1104, 40, -104},
    { 1416, 64, -120},
    { 1360, 96, -112},
    { 1192, 120, -176},
    { 1104, 32, -240},
    { 824, 0, -80},
    { 784, -136, 32},
    { 1032, -80, 168},
    { 1216, 72, 280},
    { 1088, 192, 408},
    { 1040, 88, 288},
    { 944, 152, 104},
    { 992, 296, -152},
    { 984, 432, -240},
    { 944, 256, -88},
    { 1032, -24, -56},
    { 1040, 40, -56},
    // 176 seconds
    { 1040, 104, 48},
    { 1024, 80, 96},
    { 976, 48, 48},
    { 936, 168, -48},
    { 952, 192, -64},
    { 1056, 176, -128},
    { 1088, 128, -168},
    { 1272, 0, -80},
    { 1272, -96, -16},
    { 1192, 40, -56},
    { 1192, 232, -16},
    { 1064, 248, 16},
    { 936, 240, 56},
    { 904, 176, 112},
    { 992, 208, 160},
    { 1056, 288, 176},
    { 1016, 232, 208},
    { 1040, 216, 112},
    { 1016, 208, 40},
    { 1008, 224, -24},
    { 1088, 208, -120},
    { 1112, 200, -184},
    { 1104, 80, -216},
    { 1072, 160, -216},
    { 1088, 160, -232},
    // 177 seconds
    { 1072, 208, -208},
    { 1056, 112, -184},
    { 1072, 152, -280},
    { 968, 112, -352},
    { 896, 88, -352},
    { 864, 232, -416},
    { 840, 208, -480},
    { 816, 144, -528},
    { 800, 208, -592},
    { 792, 232, -592},
    { 744, 216, -576},
    { 712, 160, -592},
    { 736, 112, -648},
    { 880, -8, -760},
    { 896, -40, -736},
    { 848, -56, -760},
    { 648, -88, -736},
    { 600, -16, -824},
    { 560, -120, -800},
    { 560, -104, -808},
    { 504, -128, -824},
    { 440, -136, -848},
    { 384, -144, -848},
    { 320, -128, -880},
    { 272, -192, -920},
    // 178 seconds
    { 224, -200, -952},
    { 160, -304, -936},
    { 144, -232, -944},
    { 144, -280, -1064},
    { 168, -296, -1016},
    { 216, -216, -1016},
    { 224, -240, -936},
    { 144, -192, -784},
    { 48, -168, -760},
    { 0, -144, -760},
    { -88, -120, -792},
    { -40, -160, -808},
    { -128, -120, -880},
    { -120, -64, -896},
    { -256, 104, -1000},
    { -208, 80, -1072},
    { -304, -64, -904},
    { -464, -280, -880},
    { -536, -384, -744},
    { -624, -280, -808},
    { -584, -240, -736},
    { -544, -112, -648},
    { -496, -8, -704},
    { -496, 168, -624},
    { -536, 312, -560},
    // 179 seconds
    { -504, 448, -592},
    { -456, 448, -456},
    { -464, 448, -408},
    { -392, 600, -472},
    { -424, 528, -456},
    { -424, 528, -400},
    { -416, 784, -456},
    { -424, 712, -392},
    { -360, 728, -392},
    { -272, 864, -424},
    { -192, 856, -384},
    { -104, 808, -376},
    { -104, 792, -288},
    { -88, 832, -400},
    { -144, 824, -464},
    { -232, 752, -432},
    { -200, 792, -432},
    { -120, 776, -432},
    { -144, 760, -384},
    { -112, 736, -384},
    { -112, 824, -488},
    { -168, 816, -464},
    { -248, 752, -520},
    { -240, 632, -536},
    { -344, 664, -520},
    // 180 seconds
    // elapsed: 3 minutes
    { -384, 552, -608},
    { -416, 448, -720},
    { -384, 264, -736},
    { -328, 176, -784},
    { -272, -56, -832},
    { -224, -16, -856},
    { -248, -200, -880},
    { -216, -408, -944},
    { -192, -240, -1064},
    { -160, -248, -1104},
    { -184, -352, -1032},
    { -208, -360, -960},
    { -224, -312, -928},
    { -224, -288, -896},
    { -248, -288, -848},
    { -224, -232, -840},
    { -232, -280, -824},
    { -208, -272, -792},
    { -224, -320, -768},
    { -216, -272, -808},
    { -224, -312, -792},
    { -224, -216, -832},
    { -224, -240, -816},
    { -168, -200, -816},
    { -176, -312, -920},
    // 181 seconds
    { -152, -432, -968},
    { -136, -440, -968},
    { -112, -424, -976},
    { -88, -320, -912},
    { -136, -264, -896},
    { -144, -320, -896},
    { -192, -280, -912},
    { -216, -344, -960},
    { -200, -280, -928},
    { -208, -288, -912},
    { -176, -256, -936},
    { -184, -264, -936},
    { -176, -256, -960},
    { -168, -224, -960},
    { -184, -208, -928},
    { -184, -216, -936},
    { -192, -200, -936},
    { -200, -200, -928},
    { -192, -184, -912},
    { -192, -192, -936},
    { -184, -200, -952},
    { -192, -192, -968},
    { -208, -208, -944},
    { -216, -240, -920},
    { -232, -240, -888},
    // 182 seconds
    { -216, -200, -904},
    { -184, -208, -912},
    { -160, -208, -928},
    { -152, -208, -912},
    { -176, -168, -912},
    { -192, -216, -920},
    { -184, -208, -928},
    { -216, -192, -936},
    { -208, -232, -888},
    { -224, -216, -904},
    { -224, -224, -920},
    { -224, -200, -912},
    { -208, -216, -936},
    { -192, -208, -912},
    { -200, -224, -904},
    { -200, -216, -896},
    { -208, -224, -896},
    { -208, -224, -896},
    { -216, -216, -888},
    { -200, -200, -912},
    { -208, -192, -920},
    { -216, -208, -912},
    { -248, -200, -936},
    { -256, -240, -936},
    { -344, -176, -1032},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

