/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:12:50 local
AccelRawData *activity_sample_walk_200_pbl_25670_11(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25670_11
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -112, 376, -1032},
    { -128, 312, -1024},
    { -80, 288, -1064},
    { -72, 304, -1040},
    { -24, 176, -1016},
    { -40, 128, -976},
    { -24, 136, -936},
    { -32, 112, -928},
    { -40, 80, -936},
    { 8, 16, -920},
    { -64, 16, -976},
    { -16, -56, -1008},
    { 80, -88, -952},
    { -120, -16, -1000},
    { -112, -64, -1008},
    { -72, 48, -968},
    { -48, 24, -976},
    { -112, -64, -976},
    { -104, -72, -1056},
    { -80, -96, -1016},
    { -88, -72, -968},
    { -120, -72, -992},
    { -144, -88, -1008},
    { -96, -48, -968},
    { -104, -40, -960},
    // 1 seconds
    { -104, -72, -952},
    { -104, -88, -992},
    { -80, -88, -944},
    { 24, -160, -816},
    { 128, -112, -760},
    { 120, 32, -592},
    { 152, 176, -496},
    { 248, 240, -616},
    { 320, 240, -696},
    { 384, 272, -736},
    { 520, 264, -760},
    { 632, 336, -808},
    { 696, 360, -712},
    { 736, 472, -664},
    { 832, 536, -776},
    { 888, 608, -688},
    { 928, 576, -560},
    { 928, 512, -376},
    { 896, 512, -328},
    { 976, 480, -440},
    { 1064, 448, -248},
    { 1024, 344, -200},
    { 912, 328, -224},
    { 816, 264, -200},
    { 784, 232, -176},
    // 2 seconds
    { 784, 216, -176},
    { 848, 248, -200},
    { 976, 272, -120},
    { 1136, 312, -8},
    { 1072, 336, -40},
    { 1104, 256, -24},
    { 952, -120, 64},
    { 1072, -32, -56},
    { 1032, 0, 0},
    { 976, -64, 48},
    { 808, -192, 8},
    { 720, -160, 8},
    { 952, -64, -32},
    { 1088, 64, -176},
    { 1080, 168, -240},
    { 936, 184, -152},
    { 784, 240, -168},
    { 656, 224, -80},
    { 632, 256, -64},
    { 680, 208, -40},
    { 800, 208, -24},
    { 1072, 304, -48},
    { 1216, 296, 8},
    { 1192, 224, 96},
    { 1328, 296, 48},
    // 3 seconds
    { 672, 216, -104},
    { 856, 296, -216},
    { 1048, 376, -280},
    { 1216, 440, -336},
    { 1440, 480, -328},
    { 1296, 496, -328},
    { 1104, 392, -184},
    { 1080, 368, -184},
    { 1056, 344, -152},
    { 968, 280, -72},
    { 848, 216, -48},
    { 768, 184, -40},
    { 784, 152, -48},
    { 832, 136, -40},
    { 864, 160, -24},
    { 912, 168, -16},
    { 1032, 168, -64},
    { 1096, 136, -160},
    { 1160, 136, -216},
    { 1232, 128, -104},
    { 1048, 16, -176},
    { 1120, 72, -184},
    { 1152, 120, -152},
    { 1032, 136, -120},
    { 856, 168, -112},
    // 4 seconds
    { 696, 176, -152},
    { 584, 176, -96},
    { 560, 232, -112},
    { 640, 304, -112},
    { 760, 392, -208},
    { 968, 424, -248},
    { 1096, 400, -240},
    { 1176, 360, -240},
    { 1448, 408, -208},
    { 1288, 424, -176},
    { 1160, 400, -152},
    { 1024, 336, -200},
    { 1048, 352, -120},
    { 1008, 264, -80},
    { 800, 192, -40},
    { 712, 152, 8},
    { 688, 152, -8},
    { 752, 152, 32},
    { 848, 128, 40},
    { 1000, 136, 16},
    { 1112, 120, -8},
    { 1136, 88, 0},
    { 1128, 64, -136},
    { 1240, 80, -48},
    { 1136, 72, 16},
    // 5 seconds
    { 1224, 120, -56},
    { 1336, 136, -96},
    { 1168, 168, -88},
    { 840, 168, -72},
    { 560, 160, -64},
    { 376, 176, -160},
    { 400, 208, -216},
    { 584, 200, -208},
    { 832, 256, -224},
    { 1176, 320, -296},
    { 1272, 400, -336},
    { 1192, 344, -320},
    { 1272, 344, -288},
    { 1152, 336, -248},
    { 1216, 328, -144},
    { 1264, 320, -112},
    { 1128, 288, -40},
    { 904, 248, -24},
    { 672, 192, -40},
    { 584, 144, -48},
    { 640, 96, -56},
    { 752, 120, -16},
    { 896, 80, -24},
    { 1048, 56, -40},
    { 1208, 80, -64},
    // 6 seconds
    { 1088, 48, -24},
    { 1200, 152, -104},
    { 1192, 96, -24},
    { 1144, 64, 8},
    { 1344, 120, -64},
    { 1328, 176, -112},
    { 1016, 224, -120},
    { 656, 208, -120},
    { 448, 200, -176},
    { 392, 176, -168},
    { 504, 200, -136},
    { 704, 224, -224},
    { 912, 280, -240},
    { 1088, 328, -296},
    { 1136, 336, -304},
    { 1184, 328, -232},
    { 1256, 360, -224},
    { 1144, 368, -200},
    { 1216, 336, -112},
    { 1200, 296, -64},
    { 1072, 256, -64},
    { 824, 216, -40},
    { 664, 168, -56},
    { 624, 112, -88},
    { 648, 104, -32},
    // 7 seconds
    { 720, 112, -24},
    { 848, 104, -64},
    { 1040, 104, -64},
    { 1200, 96, -72},
    { 1128, 56, -112},
    { 1344, 120, -72},
    { 1152, 120, -32},
    { 1304, 144, -136},
    { 1392, 176, -104},
    { 1112, 192, -104},
    { 736, 192, -80},
    { 472, 192, -88},
    { 392, 208, -136},
    { 400, 240, -32},
    { 528, 200, -16},
    { 792, 232, -152},
    { 1128, 312, -192},
    { 1208, 312, -256},
    { 1208, 296, -248},
    { 1344, 280, -232},
    { 1200, 336, -248},
    { 1136, 352, -184},
    { 1208, 256, -208},
    { 1088, 232, -144},
    { 928, 240, -136},
    // 8 seconds
    { 728, 200, -104},
    { 608, 184, -64},
    { 632, 168, -80},
    { 760, 136, -32},
    { 880, 96, 8},
    { 1040, 104, 0},
    { 1208, 224, -16},
    { 1128, 144, -32},
    { 1248, 80, -64},
    { 1264, 48, 0},
    { 1104, 8, 0},
    { 1328, 168, -120},
    { 1232, 208, -208},
    { 904, 184, -248},
    { 584, 120, -224},
    { 440, 112, -184},
    { 408, 152, -152},
    { 536, 208, -88},
    { 712, 264, -160},
    { 1008, 368, -192},
    { 1168, 528, -256},
    { 1016, 584, -256},
    { 1200, 584, -168},
    { 1096, 600, -128},
    { 1056, 528, -160},
    // 9 seconds
    { 1256, 352, -24},
    { 1336, 312, 0},
    { 1208, 240, 64},
    { 928, 184, -8},
    { 712, 168, -72},
    { 632, 184, -64},
    { 632, 136, 8},
    { 688, 136, 24},
    { 840, 96, -56},
    { 1032, 128, -96},
    { 1088, 152, -184},
    { 1080, 136, -232},
    { 1176, 144, -176},
    { 1096, 128, -128},
    { 1224, 160, -208},
    { 1344, 240, -144},
    { 1184, 280, -128},
    { 832, 272, -184},
    { 552, 232, -152},
    { 456, 184, -72},
    { 504, 176, -56},
    { 640, 176, -64},
    { 864, 248, -184},
    { 1024, 288, -240},
    { 1096, 352, -272},
    // 10 seconds
    { 1120, 400, -280},
    { 1256, 408, -256},
    { 1072, 408, -240},
    { 1112, 376, -152},
    { 1232, 328, -112},
    { 1224, 320, -64},
    { 1112, 264, -64},
    { 888, 208, -72},
    { 744, 176, -32},
    { 720, 144, -56},
    { 784, 120, -32},
    { 832, 80, -40},
    { 920, 96, -64},
    { 1024, 128, -96},
    { 1096, 144, -96},
    { 1064, 120, -88},
    { 1184, 152, -16},
    { 1104, 184, 40},
    { 1240, 160, -48},
    { 1328, 208, -48},
    { 1144, 248, -88},
    { 840, 264, -144},
    { 592, 256, -176},
    { 472, 232, -128},
    { 488, 192, -144},
    // 11 seconds
    { 640, 200, -88},
    { 920, 256, -160},
    { 1232, 336, -216},
    { 1120, 376, -280},
    { 1096, 360, -264},
    { 1264, 336, -232},
    { 1160, 400, -232},
    { 1104, 352, -144},
    { 1184, 304, -128},
    { 1192, 272, -80},
    { 1024, 224, -16},
    { 824, 168, -32},
    { 704, 120, -72},
    { 688, 128, -48},
    { 792, 112, -32},
    { 880, 128, 16},
    { 1032, 88, -8},
    { 1184, 80, 0},
    { 1104, 160, 16},
    { 1144, 200, -120},
    { 1136, 184, -112},
    { 1096, 144, -56},
    { 1280, 96, -56},
    { 1272, 136, -56},
    { 1016, 200, -104},
    // 12 seconds
    { 712, 208, -160},
    { 504, 216, -152},
    { 448, 168, -136},
    { 512, 160, -88},
    { 696, 192, -128},
    { 912, 304, -224},
    { 1144, 448, -312},
    { 1136, 416, -344},
    { 1216, 384, -256},
    { 1392, 400, -264},
    { 1064, 392, -184},
    { 1040, 304, -144},
    { 1120, 336, -136},
    { 1088, 272, -88},
    { 928, 224, -56},
    { 728, 152, -32},
    { 624, 136, -56},
    { 672, 136, -40},
    { 768, 136, -8},
    { 896, 88, 0},
    { 1056, 96, -8},
    { 1144, 120, -32},
    { 1088, 88, -80},
    { 1248, 112, -88},
    { 1168, 72, 56},
    // 13 seconds
    { 1216, 72, -8},
    { 1376, 184, -80},
    { 1232, 192, -104},
    { 928, 216, -160},
    { 616, 208, -176},
    { 456, 176, -168},
    { 424, 160, -112},
    { 512, 232, -88},
    { 704, 232, -176},
    { 928, 312, -232},
    { 1088, 368, -320},
    { 1056, 376, -304},
    { 1328, 376, -256},
    { 1360, 384, -216},
    { 1128, 360, -128},
    { 1184, 280, -80},
    { 1176, 296, -72},
    { 1048, 280, -56},
    { 840, 208, -32},
    { 744, 176, -56},
    { 720, 152, -16},
    { 760, 128, 0},
    { 792, 96, 8},
    { 864, 72, 0},
    { 1024, 96, -24},
    // 14 seconds
    { 1104, 128, -96},
    { 976, 80, -184},
    { 1160, 80, -232},
    { 1104, 104, 64},
    { 1200, 168, -168},
    { 1424, 232, -232},
    { 1280, 264, -184},
    { 928, 248, -168},
    { 608, 192, -168},
    { 480, 192, -136},
    { 472, 192, -88},
    { 576, 224, -96},
    { 736, 248, -152},
    { 944, 296, -200},
    { 1064, 336, -288},
    { 1104, 352, -264},
    { 1336, 336, -208},
    { 1224, 312, -232},
    { 1040, 272, -160},
    { 1152, 304, -120},
    { 1192, 296, -136},
    { 1136, 264, -104},
    { 904, 160, -56},
    { 712, 152, -40},
    { 672, 144, -80},
    // 15 seconds
    { 688, 144, -32},
    { 752, 136, -16},
    { 856, 80, -48},
    { 1000, 104, -40},
    { 1168, 128, -48},
    { 1208, 144, -80},
    { 1336, 184, -88},
    { 1072, 216, -96},
    { 960, 168, -184},
    { 1232, 176, -120},
    { 1144, 200, -112},
    { 880, 224, -152},
    { 616, 192, -144},
    { 512, 176, -176},
    { 504, 160, -144},
    { 568, 192, -112},
    { 696, 216, -168},
    { 952, 296, -248},
    { 1080, 368, -296},
    { 1096, 384, -264},
    { 1312, 376, -240},
    { 1280, 392, -256},
    { 1024, 328, -184},
    { 1184, 312, -144},
    { 1200, 320, -144},
    // 16 seconds
    { 1040, 264, -80},
    { 856, 208, -72},
    { 720, 168, -56},
    { 624, 136, -32},
    { 664, 160, -56},
    { 728, 120, -24},
    { 872, 112, -24},
    { 1024, 112, -64},
    { 1128, 136, -88},
    { 1080, 104, -120},
    { 1280, 144, -96},
    { 1136, 152, -56},
    { 1168, 168, -104},
    { 1328, 200, -120},
    { 1176, 240, -136},
    { 824, 264, -144},
    { 536, 200, -144},
    { 448, 160, -128},
    { 488, 152, -96},
    { 632, 184, -96},
    { 800, 224, -160},
    { 1016, 272, -176},
    { 1080, 368, -280},
    { 1064, 384, -280},
    { 1176, 352, -208},
    // 17 seconds
    { 1192, 376, -232},
    { 1072, 352, -192},
    { 1200, 328, -128},
    { 1224, 304, -104},
    { 1136, 264, -80},
    { 896, 200, -24},
    { 712, 160, -32},
    { 648, 152, -64},
    { 656, 128, -24},
    { 776, 128, -16},
    { 848, 80, -24},
    { 1008, 112, -40},
    { 1120, 136, -24},
    { 1096, 136, -32},
    { 1256, 168, -48},
    { 1184, 152, -40},
    { 1192, 120, -16},
    { 1320, 232, -96},
    { 1128, 256, -176},
    { 784, 232, -152},
    { 496, 184, -160},
    { 416, 136, -176},
    { 456, 128, -64},
    { 640, 192, -104},
    { 880, 256, -168},
    // 18 seconds
    { 1112, 272, -184},
    { 1120, 344, -304},
    { 1160, 368, -288},
    { 1368, 360, -232},
    { 1112, 376, -248},
    { 1128, 360, -176},
    { 1248, 328, -120},
    { 1200, 272, -64},
    { 1048, 232, -72},
    { 816, 184, -48},
    { 696, 152, -80},
    { 664, 144, -56},
    { 728, 136, 0},
    { 800, 112, -40},
    { 848, 56, -16},
    { 1032, 104, -48},
    { 1080, 120, -40},
    { 1144, 144, -72},
    { 1192, 200, -40},
    { 1096, 160, -64},
    { 1216, 184, -104},
    { 1312, 216, -96},
    { 1176, 232, -160},
    { 856, 240, -152},
    { 600, 224, -176},
    // 19 seconds
    { 496, 168, -184},
    { 520, 144, -80},
    { 656, 224, -80},
    { 808, 240, -128},
    { 1048, 272, -216},
    { 1016, 312, -248},
    { 1088, 312, -240},
    { 1416, 352, -248},
    { 1264, 352, -256},
    { 1072, 280, -136},
    { 1072, 280, -200},
    { 1080, 288, -160},
    { 1032, 240, -128},
    { 864, 168, -72},
    { 688, 176, -48},
    { 680, 144, -64},
    { 712, 128, -24},
    { 800, 144, 0},
    { 880, 112, -8},
    { 1040, 144, -32},
    { 1144, 168, -64},
    { 1040, 160, -72},
    { 1152, 152, -64},
    { 1088, 136, -40},
    { 1072, 104, -24},
    // 20 seconds
    { 1320, 176, -48},
    { 1272, 216, -120},
    { 960, 248, -152},
    { 640, 224, -144},
    { 496, 192, -144},
    { 480, 192, -120},
    { 592, 192, -88},
    { 768, 224, -184},
    { 968, 248, -152},
    { 1136, 288, -240},
    { 1136, 336, -264},
    { 1176, 296, -224},
    { 1184, 328, -232},
    { 1032, 328, -232},
    { 1168, 336, -160},
    { 1256, 288, -88},
    { 1160, 280, -48},
    { 936, 208, -64},
    { 768, 192, -32},
    { 704, 160, -40},
    { 768, 160, -48},
    { 824, 120, 0},
    { 912, 80, -8},
    { 1040, 104, -32},
    { 1064, 112, -8},
    // 21 seconds
    { 1096, 152, -32},
    { 1168, 152, -56},
    { 1080, 128, -32},
    { 1168, 112, -80},
    { 1320, 184, -80},
    { 1200, 224, -80},
    { 904, 240, -168},
    { 632, 224, -176},
    { 528, 192, -168},
    { 544, 184, -128},
    { 664, 208, -112},
    { 832, 200, -200},
    { 1000, 288, -208},
    { 1016, 328, -280},
    { 1088, 336, -288},
    { 1400, 376, -288},
    { 1272, 328, -256},
    { 984, 232, -136},
    { 1176, 288, -152},
    { 1320, 288, -176},
    { 1216, 232, -144},
    { 936, 192, -112},
    { 760, 160, -120},
    { 696, 160, -56},
    { 728, 152, -16},
    // 22 seconds
    { 744, 88, -16},
    { 776, 80, -48},
    { 816, 88, -56},
    { 920, 96, -64},
    { 1040, 112, -96},
    { 1208, 160, -48},
    { 1392, 224, 32},
    { 1176, 240, -56},
    { 1400, 312, -136},
    { 1368, 256, -120},
    { 1032, 264, -112},
    { 648, 224, -184},
    { 472, 200, -168},
    { 432, 152, -72},
    { 520, 144, -48},
    { 696, 192, -56},
    { 944, 280, -120},
    { 1072, 312, -208},
    { 1144, 336, -160},
    { 1240, 328, -160},
    { 1200, 360, -192},
    { 1064, 384, -216},
    { 1024, 280, -168},
    { 1168, 312, -208},
    { 1200, 272, -192},
    // 23 seconds
    { 1008, 192, -168},
    { 856, 160, -160},
    { 760, 152, -128},
    { 736, 120, -120},
    { 784, 40, -64},
    { 712, -64, -48},
    { 816, -88, -48},
    { 936, -8, -40},
    { 944, 72, -40},
    { 1144, 128, -16},
    { 1312, 208, 144},
    { 1520, 232, 104},
    { 1656, 320, -48},
    { 1432, 304, -112},
    { 1016, 264, -128},
    { 608, 200, -224},
    { 384, 152, -200},
    { 368, 152, -168},
    { 488, 256, -80},
    { 808, 312, -112},
    { 1160, 368, -232},
    { 1128, 352, -56},
    { 1160, 336, -8},
    { 1568, 400, -184},
    { 1352, 472, -88},
    // 24 seconds
    { 1328, 488, -72},
    { 1168, 304, -72},
    { 992, 200, -104},
    { 808, 96, -112},
    { 640, 72, -168},
    { 648, 88, -176},
    { 944, 0, -176},
    { 1216, -16, -168},
    { 1368, -24, -128},
    { 1224, -16, -136},
    { 1352, 224, -104},
    { 1344, 152, 128},
    { 1392, 216, 32},
    { 1400, 240, -152},
    { 1128, 216, -152},
    { 744, 128, -112},
    { 472, 96, -136},
    { 328, 80, -168},
    { 304, 128, -136},
    { 456, 200, -64},
    { 792, 344, -168},
    { 1120, 512, -192},
    { 1216, 472, -224},
    { 1288, 464, -256},
    { 1312, 440, -256},
    // 25 seconds
    { 1272, 472, -264},
    { 1104, 344, -168},
    { 1056, 328, -128},
    { 992, 280, -104},
    { 808, 232, -56},
    { 656, 160, -56},
    { 616, 160, -48},
    { 712, 200, 16},
    { 904, 144, 0},
    { 1104, 128, -32},
    { 1192, 128, -48},
    { 1224, 32, -72},
    { 1232, 48, -144},
    { 1320, 120, -40},
    { 1136, 128, -8},
    { 1240, 200, -56},
    { 1288, 200, -72},
    { 1128, 216, -120},
    { 808, 200, -128},
    { 520, 208, -144},
    { 384, 192, -128},
    { 352, 208, -104},
    { 464, 176, -8},
    { 776, 208, -64},
    { 1248, 280, -192},
    // 26 seconds
    { 1240, 344, -232},
    { 1280, 328, -200},
    { 1320, 304, -208},
    { 1136, 360, -240},
    { 992, 272, -144},
    { 1088, 248, -104},
    { 1072, 256, -80},
    { 920, 224, -48},
    { 680, 200, -64},
    { 576, 168, -104},
    { 592, 160, -64},
    { 768, 144, -8},
    { 984, 88, -32},
    { 1104, 56, -56},
    { 1312, 128, -128},
    { 1256, 56, -80},
    { 1280, 88, -64},
    { 1144, 96, -48},
    { 1064, 112, -40},
    { 1240, 72, 16},
    { 1240, 128, 0},
    { 1008, 184, -104},
    { 680, 168, -88},
    { 464, 152, -128},
    { 360, 128, -104},
    // 27 seconds
    { 368, 160, -40},
    { 520, 216, -40},
    { 856, 312, -136},
    { 1264, 456, -240},
    { 1096, 408, -256},
    { 1256, 320, -200},
    { 1344, 408, -296},
    { 1016, 352, -216},
    { 1008, 272, -184},
    { 1136, 344, -200},
    { 1128, 296, -120},
    { 936, 224, -64},
    { 696, 136, -72},
    { 552, 160, -88},
    { 544, 160, -72},
    { 640, 176, -40},
    { 840, 120, -40},
    { 1040, 128, -72},
    { 1248, 136, -136},
    { 1208, 152, -112},
    { 1312, 112, -56},
    { 1184, 104, 40},
    { 1088, 96, -16},
    { 1272, 120, 16},
    { 1248, 136, -24},
    // 28 seconds
    { 992, 192, -72},
    { 688, 160, -96},
    { 472, 144, -144},
    { 360, 128, -128},
    { 376, 176, -48},
    { 536, 200, -80},
    { 840, 248, -144},
    { 1128, 336, -280},
    { 1112, 376, -280},
    { 1216, 224, -152},
    { 1416, 336, -168},
    { 1144, 376, -144},
    { 1072, 344, -128},
    { 1168, 344, -120},
    { 1120, 264, -120},
    { 928, 216, -112},
    { 688, 144, -96},
    { 568, 144, -88},
    { 568, 152, -88},
    { 712, 128, -48},
    { 816, 112, -48},
    { 1112, 96, -112},
    { 1144, 96, -96},
    { 1064, 72, -64},
    { 1344, 128, 0},
    // 29 seconds
    { 1144, 128, 8},
    { 1232, 136, -32},
    { 1408, 168, -24},
    { 1208, 208, -112},
    { 848, 184, -136},
    { 536, 168, -168},
    { 392, 152, -112},
    { 408, 120, -64},
    { 600, 176, -104},
    { 808, 232, -160},
    { 968, 248, -192},
    { 1056, 280, -232},
    { 1144, 312, -288},
    { 1344, 328, -256},
    { 1216, 320, -200},
    { 1216, 328, -136},
    { 1296, 312, -176},
    { 1264, 304, -72},
    { 1016, 248, -24},
    { 744, 168, -32},
    { 616, 120, -40},
    { 608, 112, 8},
    { 664, 72, 24},
    { 736, 72, 8},
    { 856, 88, -32},
    // 30 seconds
    { 976, 96, -32},
    { 1088, 72, -16},
    { 936, 96, -48},
    { 1216, 136, -56},
    { 1384, 128, 96},
    { 1424, 232, 32},
    { 1416, 296, -160},
    { 1160, 296, -176},
    { 768, 240, -144},
    { 520, 168, -128},
    { 456, 184, -120},
    { 504, 192, -152},
    { 672, 264, -192},
    { 864, 312, -200},
    { 1024, 328, -256},
    { 1160, 328, -216},
    { 1112, 320, -192},
    { 1208, 344, -208},
    { 1176, 320, -232},
    { 1352, 320, -144},
    { 1424, 280, -112},
    { 1216, 280, -40},
    { 960, 240, -80},
    { 776, 184, -64},
    { 696, 152, -40},
    // 31 seconds
    { 720, 120, -48},
    { 760, 24, -24},
    { 944, 64, -80},
    { 1136, 64, -216},
    { 1240, 24, -144},
    { 1296, 24, -80},
    { 1464, 128, 48},
    { 1336, 168, -72},
    { 1376, 272, -104},
    { 1256, 240, -64},
    { 952, 296, -112},
    { 616, 216, -104},
    { 456, 160, -80},
    { 400, 176, -56},
    { 464, 168, -40},
    { 688, 224, 0},
    { 1104, 336, -144},
    { 1392, 480, -136},
    { 1384, 512, -128},
    { 1368, 544, -192},
    { 1144, 576, -232},
    { 952, 456, -200},
    { 824, 296, -216},
    { 1040, 312, -248},
    { 1144, 168, -144},
    // 32 seconds
    { 1040, 72, -96},
    { 984, 104, -144},
    { 856, 152, -128},
    { 696, 112, -16},
    { 720, 136, -32},
    { 760, 96, -64},
    { 904, 136, -88},
    { 992, 128, -104},
    { 1096, 80, -128},
    { 1360, 136, -104},
    { 1320, 160, -80},
    { 1072, 192, -160},
    { 1176, 224, -104},
    { 1264, 152, -72},
    { 1120, 224, -72},
    { 848, 208, -64},
    { 584, 192, -88},
    { 480, 184, -88},
    { 480, 176, -48},
    { 640, 200, 24},
    { 904, 296, -88},
    { 1056, 464, -168},
    { 1296, 496, -200},
    { 1464, 512, -208},
    { 1280, 520, -192},
    // 33 seconds
    { 1040, 440, -200},
    { 976, 400, -264},
    { 1024, 376, -176},
    { 928, 280, -152},
    { 760, 176, -128},
    { 640, 168, -128},
    { 632, 160, -104},
    { 744, 176, -88},
    { 880, 136, -80},
    { 1112, 56, -48},
    { 1280, 32, -16},
    { 1536, 80, -32},
    { 1448, 40, 64},
    { 1312, 80, -24},
    { 1224, 128, -64},
    { 1232, 40, 0},
    { 1128, 128, -48},
    { 808, 136, -128},
    { 512, 112, -144},
    { 368, 120, -120},
    { 336, 136, -112},
    { 496, 176, -80},
    { 800, 272, -144},
    { 1072, 368, -168},
    { 1192, 440, -216},
    // 34 seconds
    { 1264, 416, -200},
    { 1184, 408, -136},
    { 976, 424, -192},
    { 904, 384, -200},
    { 1056, 352, -184},
    { 1184, 312, -112},
    { 1160, 216, -80},
    { 960, 192, -88},
    { 752, 176, -136},
    { 632, 112, -128},
    { 560, 80, -72},
    { 616, 72, -64},
    { 720, 72, -112},
    { 952, 80, -152},
    { 856, 56, -152},
    { 792, 16, -152},
    { 1144, 88, -96},
    { 1472, 168, 48},
    { 1440, 224, 32},
    { 1608, 320, -72},
    { 1440, 328, -152},
    { 888, 288, -192},
    { 440, 160, -184},
    { 336, 160, -184},
    { 328, 192, -160},
    // 35 seconds
    { 488, 168, -136},
    { 784, 248, -200},
    { 1096, 312, -240},
    { 1160, 328, -248},
    { 1160, 328, -200},
    { 1232, 344, -192},
    { 1232, 384, -120},
    { 1376, 352, -64},
    { 1336, 336, -56},
    { 1176, 296, -24},
    { 840, 224, -24},
    { 616, 168, -56},
    { 584, 128, -120},
    { 616, 104, -56},
    { 768, 72, -56},
    { 920, 88, -88},
    { 1104, 32, -112},
    { 1192, 72, -96},
    { 1352, 160, -88},
    { 1312, 176, 16},
    { 1176, 160, -80},
    { 1440, 160, -24},
    { 1360, 232, -88},
    { 992, 304, -152},
    { 560, 216, -304},
    // 36 seconds
    { 392, 136, -200},
    { 352, 80, -112},
    { 400, 200, -96},
    { 584, 256, -112},
    { 1048, 336, -208},
    { 1344, 384, -296},
    { 1192, 256, -176},
    { 1304, 312, -152},
    { 1160, 384, -336},
    { 1088, 368, -224},
    { 1208, 312, -168},
    { 1216, 288, -168},
    { 1104, 248, -112},
    { 872, 200, -104},
    { 656, 136, -80},
    { 584, 200, -32},
    { 640, 168, -16},
    { 792, 136, -8},
    { 952, 112, -8},
    { 1136, 104, -96},
    { 1144, 88, -72},
    { 1088, 48, -72},
    { 1224, 112, -88},
    { 1104, 72, 0},
    { 1128, 128, -80},
    // 37 seconds
    { 1288, 184, -48},
    { 1216, 232, -88},
    { 968, 256, -152},
    { 648, 224, -168},
    { 496, 184, -152},
    { 472, 160, -112},
    { 576, 192, -120},
    { 800, 256, -208},
    { 1128, 264, -232},
    { 1144, 280, -264},
    { 1088, 312, -296},
    { 1232, 320, -232},
    { 1168, 352, -208},
    { 984, 296, -112},
    { 1080, 312, -152},
    { 1192, 368, -160},
    { 1152, 272, -56},
    { 928, 224, -16},
    { 752, 216, -88},
    { 736, 184, -40},
    { 784, 168, -32},
    { 888, 96, -32},
    { 952, -16, 8},
    { 1072, 8, -72},
    { 1224, 40, -112},
    // 38 seconds
    { 1136, 32, 32},
    { 1248, 32, 24},
    { 1120, 56, 96},
    { 1184, 96, -8},
    { 1288, 96, -24},
    { 1168, 112, -48},
    { 920, 152, -120},
    { 656, 160, -168},
    { 552, 160, -168},
    { 576, 144, -112},
    { 704, 216, -112},
    { 888, 264, -232},
    { 1176, 320, -272},
    { 1208, 360, -328},
    { 1272, 376, -312},
    { 1280, 440, -320},
    { 1032, 344, -240},
    { 1120, 256, -160},
    { 1168, 200, -104},
    { 1224, 128, -48},
    { 1096, 96, 88},
    { 848, 56, -8},
    { 688, 80, -24},
    { 696, 120, 24},
    { 744, 96, 32},
    // 39 seconds
    { 832, 88, 16},
    { 992, 80, 0},
    { 1128, 80, -104},
    { 1176, 24, -96},
    { 1368, 72, -48},
    { 1320, 80, -40},
    { 1064, 80, -56},
    { 1280, 168, -112},
    { 1208, 208, -136},
    { 936, 216, -112},
    { 624, 168, -168},
    { 472, 144, -120},
    { 472, 144, -104},
    { 568, 176, -96},
    { 744, 216, -160},
    { 1000, 376, -144},
    { 1200, 496, -256},
    { 1184, 560, -320},
    { 1352, 512, -224},
    { 1192, 552, -216},
    { 1144, 480, -128},
    { 1256, 368, -40},
    { 1200, 280, 16},
    { 1040, 216, 64},
    { 824, 168, -56},
    // 40 seconds
    { 704, 128, 32},
    { 664, 32, 24},
    { 688, 32, -32},
    { 800, 120, -40},
    { 928, 144, -48},
    { 1056, 120, -136},
    { 1128, 136, -104},
    { 1208, 104, -104},
    { 1232, 192, -80},
    { 1104, 192, -112},
    { 1168, 216, -136},
    { 1288, 224, -96},
    { 1088, 232, -144},
    { 784, 240, -120},
    { 560, 192, -136},
    { 464, 208, -136},
    { 472, 192, -80},
    { 608, 224, -72},
    { 864, 264, -184},
    { 1168, 320, -240},
    { 1176, 296, -216},
    { 1280, 320, -232},
    { 1328, 384, -216},
    { 1040, 376, -176},
    { 1088, 320, -80},
    // 41 seconds
    { 1200, 344, -112},
    { 1152, 264, -72},
    { 960, 208, -56},
    { 784, 208, -48},
    { 728, 152, -16},
    { 720, 160, -16},
    { 824, 128, -40},
    { 976, -8, 8},
    { 1064, -64, 40},
    { 1088, 16, -40},
    { 1072, 120, -56},
    { 1216, 136, -16},
    { 1192, 168, 0},
    { 1144, 184, -40},
    { 1328, 192, -16},
    { 1376, 224, -88},
    { 1112, 240, -192},
    { 736, 200, -192},
    { 496, 144, -168},
    { 416, 168, -120},
    { 464, 192, -120},
    { 608, 216, -112},
    { 912, 248, -160},
    { 1224, 288, -272},
    { 1184, 352, -312},
    // 42 seconds
    { 1192, 288, -248},
    { 1272, 336, -256},
    { 1080, 344, -208},
    { 1208, 296, -112},
    { 1264, 304, -96},
    { 1200, 288, -56},
    { 984, 256, -40},
    { 800, 160, -40},
    { 680, 136, -40},
    { 680, 120, -16},
    { 760, 88, 24},
    { 952, 104, -24},
    { 1096, 144, -96},
    { 1128, 88, -56},
    { 1112, 56, 16},
    { 1264, 128, 32},
    { 1168, 176, 32},
    { 1192, 200, -40},
    { 1344, 224, -40},
    { 1208, 240, -120},
    { 864, 232, -232},
    { 544, 176, -184},
    { 448, 176, -168},
    { 456, 192, -152},
    { 608, 200, -168},
    // 43 seconds
    { 880, 256, -192},
    { 1160, 304, -280},
    { 1112, 336, -288},
    { 1144, 360, -248},
    { 1288, 368, -216},
    { 1128, 392, -184},
    { 1160, 360, -136},
    { 1264, 328, -152},
    { 1328, 280, -120},
    { 1048, 232, -24},
    { 800, 144, -24},
    { 632, 120, -56},
    { 624, 144, -32},
    { 744, 120, -8},
    { 840, 32, 8},
    { 968, 32, 24},
    { 1104, 96, -24},
    { 1176, 128, -48},
    { 1376, 176, 16},
    { 1240, 216, 16},
    { 1280, 152, -64},
    { 1392, 256, -64},
    { 1184, 224, -152},
    { 808, 232, -240},
    { 488, 200, -264},
    // 44 seconds
    { 376, 168, -240},
    { 392, 152, -152},
    { 544, 200, -136},
    { 864, 264, -208},
    { 1200, 336, -264},
    { 1112, 336, -232},
    { 1160, 360, -192},
    { 1248, 352, -208},
    { 1104, 416, -184},
    { 1128, 392, -112},
    { 1336, 352, -64},
    { 1304, 304, 16},
    { 1064, 240, 56},
    { 784, 160, 0},
    { 624, 152, -48},
    { 608, 144, 24},
    { 648, 96, 72},
    { 856, 96, 0},
    { 1128, 112, 8},
    { 1288, 128, -32},
    { 1152, 96, -32},
    { 1264, 120, -72},
    { 1248, 176, -24},
    { 1144, 160, -80},
    { 1248, 144, -64},
    // 45 seconds
    { 1176, 168, -64},
    { 944, 224, -144},
    { 640, 208, -136},
    { 472, 176, -128},
    { 424, 176, -80},
    { 488, 192, -80},
    { 720, 248, -176},
    { 1112, 376, -224},
    { 1280, 424, -248},
    { 1160, 384, -224},
    { 1304, 424, -224},
    { 1200, 400, -216},
    { 1128, 336, -152},
    { 1096, 296, -144},
    { 1184, 272, -112},
    { 1096, 224, -32},
    { 856, 152, 0},
    { 672, 160, -56},
    { 600, 128, -32},
    { 600, 136, 8},
    { 800, 152, -72},
    { 912, 104, -40},
    { 1056, 80, -32},
    { 1104, 40, -32},
    { 1032, 24, 16},
    // 46 seconds
    { 1344, 96, 0},
    { 1312, 128, 56},
    { 1240, 144, -24},
    { 1368, 136, 8},
    { 1280, 184, -64},
    { 920, 232, -168},
    { 544, 184, -168},
    { 408, 144, -168},
    { 360, 144, -104},
    { 464, 208, -48},
    { 736, 224, -96},
    { 1184, 320, -152},
    { 1128, 424, -256},
    { 1208, 400, -192},
    { 1328, 400, -208},
    { 1184, 440, -240},
    { 1096, 368, -160},
    { 1208, 280, -136},
    { 1216, 288, -128},
    { 1048, 232, -88},
    { 848, 192, -64},
    { 712, 136, -64},
    { 672, 128, -48},
    { 720, 144, -8},
    { 824, 32, 0},
    // 47 seconds
    { 984, 8, 32},
    { 1080, 56, 40},
    { 1112, 104, 8},
    { 1296, 128, -48},
    { 1360, 112, -8},
    { 1208, 40, -8},
    { 1352, 176, -24},
    { 1320, 176, -120},
    { 1016, 192, -216},
    { 640, 168, -208},
    { 424, 144, -176},
    { 376, 112, -112},
    { 448, 168, -48},
    { 688, 224, -152},
    { 1032, 272, -160},
    { 1208, 384, -288},
    { 1144, 360, -256},
    { 1240, 352, -184},
    { 1184, 392, -240},
    { 1080, 344, -168},
    { 1208, 296, -112},
    { 1296, 312, -96},
    { 1152, 256, -48},
    { 848, 216, -56},
    { 672, 176, -64},
    // 48 seconds
    { 616, 136, -56},
    { 632, 144, -8},
    { 792, 88, -16},
    { 976, 72, -8},
    { 1208, 88, -48},
    { 1224, 72, -48},
    { 1264, 112, -88},
    { 1264, 128, -16},
    { 1096, 128, 0},
    { 1128, 152, -40},
    { 1272, 168, -64},
    { 1128, 184, -80},
    { 824, 184, -104},
    { 576, 176, -128},
    { 424, 152, -128},
    { 392, 160, -104},
    { 536, 152, -88},
    { 816, 216, -152},
    { 1264, 400, -312},
    { 1144, 416, -296},
    { 1136, 392, -224},
    { 1272, 440, -216},
    { 1096, 448, -216},
    { 1056, 368, -136},
    { 1136, 336, -104},
    // 49 seconds
    { 1216, 264, -96},
    { 1120, 240, -16},
    { 912, 192, -24},
    { 760, 168, -56},
    { 664, 128, 0},
    { 696, 136, 0},
    { 768, 80, 8},
    { 880, 112, -56},
    { 1016, 88, -16},
    { 1120, 56, 16},
    { 1064, 72, -32},
    { 1264, 88, -16},
    { 1208, 80, 56},
    { 1168, 128, 16},
    { 1368, 240, -32},
    { 1256, 240, -168},
    { 896, 232, -168},
    { 576, 208, -144},
    { 448, 184, -136},
    { 424, 200, -120},
    { 568, 248, -112},
    { 784, 240, -144},
    { 1144, 328, -184},
    { 1184, 352, -280},
    { 1176, 336, -208},
    // 50 seconds
    { 1208, 312, -184},
    { 1024, 352, -216},
    { 1016, 312, -160},
    { 1208, 304, -104},
    { 1272, 264, -56},
    { 1112, 240, -32},
    { 848, 192, -72},
    { 696, 176, -72},
    { 656, 104, -40},
    { 696, 184, -16},
    { 880, 104, 8},
    { 1008, 88, 16},
    { 1160, 112, -48},
    { 1088, 128, -80},
    { 1176, 96, -104},
    { 1264, 96, 0},
    { 1160, 128, -48},
    { 1240, 152, -112},
    { 1296, 184, -96},
    { 1112, 224, -168},
    { 736, 184, -248},
    { 488, 152, -168},
    { 400, 144, -128},
    { 456, 160, -104},
    { 656, 208, -112},
    // 51 seconds
    { 920, 264, -144},
    { 1176, 344, -264},
    { 1112, 376, -296},
    { 1208, 352, -208},
    { 1264, 368, -184},
    { 1072, 376, -176},
    { 1176, 312, -104},
    { 1272, 296, -80},
    { 1208, 280, -48},
    { 952, 224, -16},
    { 656, 160, -48},
    { 552, 152, -64},
    { 568, 128, -24},
    { 704, 104, 16},
    { 840, 56, 0},
    { 1016, 64, -8},
    { 1144, 120, -56},
    { 1128, 72, -64},
    { 1392, 128, 16},
    { 1256, 128, 40},
    { 1248, 136, -80},
    { 1368, 192, -88},
    { 1200, 208, -136},
    { 824, 216, -176},
    { 488, 160, -200},
    // 52 seconds
    { 368, 112, -152},
    { 344, 120, -104},
    { 504, 176, -88},
    { 784, 288, -176},
    { 1048, 408, -208},
    { 1032, 456, -256},
    { 1088, 448, -200},
    { 1296, 416, -152},
    { 1176, 440, -176},
    { 1200, 392, -96},
    { 1296, 360, -16},
    { 1232, 320, 0},
    { 936, 264, -32},
    { 680, 176, -32},
    { 584, 128, -24},
    { 608, 152, -24},
    { 736, 112, -16},
    { 872, 104, -32},
    { 1000, 96, -40},
    { 1104, 64, -56},
    { 1160, 88, -64},
    { 1344, 128, -88},
    { 1312, 160, 72},
    { 1160, 208, -64},
    { 1264, 264, -136},
    // 53 seconds
    { 1184, 168, -96},
    { 896, 192, -112},
    { 584, 160, -152},
    { 432, 152, -112},
    { 408, 168, -112},
    { 488, 168, -56},
    { 688, 224, -152},
    { 1016, 344, -216},
    { 1184, 416, -264},
    { 1136, 392, -224},
    { 1312, 376, -192},
    { 1208, 424, -240},
    { 1160, 344, -112},
    { 1216, 304, -48},
    { 1160, 280, -64},
    { 992, 248, -32},
    { 752, 160, -56},
    { 576, 120, -48},
    { 520, 136, -40},
    { 608, 152, 0},
    { 768, 144, -8},
    { 952, 96, 0},
    { 1256, 168, -56},
    { 1216, 168, -64},
    { 1352, 128, -32},
    // 54 seconds
    { 1216, 288, 64},
    { 672, 488, -24},
    { 1696, 712, 152},
    { 736, -24, -176},
    { 568, -560, -336},
    { 344, -736, -376},
    { 728, -480, -240},
    { 352, -624, -328},
    { 456, 544, 16},
    { 576, 104, -32},
    { 920, 208, -152},
    { 1232, 256, -216},
    { 1176, 296, -248},
    { 1224, 304, -256},
    { 1280, 352, -248},
    { 1072, 320, -224},
    { 1040, 304, -176},
    { 1144, 248, -168},
    { 1144, 248, -104},
    { 992, 216, -64},
    { 832, 184, -96},
    { 776, 144, -80},
    { 728, 192, -16},
    { 776, 144, -16},
    { 920, 152, -40},
    // 55 seconds
    { 920, 104, -8},
    { 936, 120, -56},
    { 1008, 136, -64},
    { 1064, 136, -72},
    { 1208, 184, -56},
    { 1064, 176, -112},
    { 1152, 152, -48},
    { 1256, 208, -48},
    { 1120, 264, -112},
    { 888, 312, -144},
    { 680, 248, -200},
    { 640, 184, -120},
    { 672, 264, -120},
    { 720, 352, -136},
    { 728, 320, -160},
    { 784, 328, -192},
    { 816, 304, -224},
    { 864, 264, -184},
    { 1064, 224, -128},
    { 1552, 304, -144},
    { 1424, 296, -104},
    { 1088, 280, -72},
    { 1008, 256, 16},
    { 1008, 64, 64},
    { 864, 48, -16},
    // 56 seconds
    { 912, 136, 0},
    { 1072, 208, 24},
    { 1256, 392, -56},
    { 1216, 352, -96},
    { 1152, 392, -152},
    { 1048, 432, -248},
    { 936, 360, -264},
    { 792, 440, -376},
    { 664, 344, -512},
    { 584, 280, -560},
    { 472, 176, -680},
    { 376, 72, -688},
    { 288, 72, -760},
    { 224, 0, -832},
    { 280, -80, -920},
    { 168, -48, -848},
    { 184, -40, -976},
    { 152, -144, -928},
    { 56, -8, -944},
    { 24, -32, -976},
    { 40, -40, -984},
    { 104, -48, -960},
    { 40, -96, -960},
    { 72, -96, -984},
    { 72, -112, -984},
    // 57 seconds
    { 56, -144, -976},
    { -24, -24, -960},
    { 40, -184, -976},
    { 96, -192, -968},
    { 64, -176, -936},
    { 48, -184, -960},
    { 40, -136, -1008},
    { 32, -104, -984},
    { 72, -144, -936},
    { 40, -128, -1000},
    { 24, -144, -984},
    { -48, -120, -960},
    { 40, -144, -928},
    { 56, -136, -904},
    { 32, -112, -848},
    { 96, 16, -832},
    { -152, 24, -896},
    { 32, -296, -736},
    { 40, 88, -848},
    { 96, -40, -776},
    { 184, 288, -856},
    { 200, 296, -832},
    { 224, 504, -856},
    { 264, 512, -928},
    { 360, 528, -1016},
    // 58 seconds
    { 376, 512, -920},
    { 392, 512, -856},
    { 416, 440, -776},
    { 448, 360, -688},
    { 536, 456, -648},
    { 584, 272, -584},
    { 656, 264, -504},
    { 720, 320, -512},
    { 808, 272, -528},
    { 912, 256, -504},
    { 1112, 192, -408},
    { 1288, 224, -344},
    { 1288, 280, -264},
    { 1136, 384, -248},
    { 856, 360, -200},
    { 840, 312, -88},
    { 936, 280, 24},
    { 1024, 216, 80},
    { 920, 120, 80},
    { 832, 128, 8},
    { 808, 176, -16},
    { 768, 160, -16},
    { 744, 184, -56},
    { 712, 184, -136},
    { 728, 200, -144},
    // 59 seconds
    { 784, 216, -264},
    { 840, 240, -360},
    { 952, 184, -312},
    { 1128, 232, -424},
    { 1176, 224, -416},
    { 1544, 264, -384},
    { 1448, 264, -352},
    { 856, 208, -192},
    { 736, 200, -120},
    { 1008, 304, -72},
    { 1184, 272, 0},
    { 1080, 192, -16},
    { 864, 160, -16},
    { 784, 192, -32},
    { 712, 152, -16},
    { 768, 136, -16},
    { 912, 120, -72},
    { 1136, 80, -136},
    { 1200, 64, -128},
    { 1336, 40, -112},
    { 1288, 104, -56},
    { 1136, 160, -80},
    { 1152, 176, -96},
    { 1208, 144, -64},
    { 1048, 144, -88},
    // 60 seconds
    // elapsed: 1 minutes
    { 752, 160, -128},
    { 520, 144, -160},
    { 392, 176, -168},
    { 408, 152, -160},
    { 584, 192, -152},
    { 880, 248, -232},
    { 1216, 352, -248},
    { 1168, 344, -248},
    { 1248, 368, -224},
    { 1256, 416, -248},
    { 1072, 400, -256},
    { 1176, 352, -160},
    { 1192, 312, -128},
    { 1224, 280, -88},
    { 1080, 240, -16},
    { 848, 200, -24},
    { 712, 176, -64},
    { 688, 152, -16},
    { 696, 112, 32},
    { 816, 104, 0},
    { 976, 120, -8},
    { 1056, 136, -32},
    { 1040, 96, -24},
    { 1024, 96, -64},
    { 1168, 128, -136},
    // 61 seconds
    { 1136, 128, -128},
    { 1152, 128, -96},
    { 1248, 176, -144},
    { 1280, 240, -192},
    { 1024, 240, -200},
    { 696, 208, -168},
    { 536, 192, -160},
    { 456, 216, -152},
    { 528, 184, -168},
    { 664, 232, -168},
    { 880, 288, -208},
    { 1032, 376, -248},
    { 1088, 400, -232},
    { 1096, 368, -144},
    { 1232, 400, -168},
    { 1224, 392, -136},
    { 1320, 320, -64},
    { 1368, 312, -8},
    { 1248, 288, 24},
    { 936, 184, -24},
    { 728, 136, -48},
    { 680, 112, 0},
    { 672, 176, -8},
    { 760, 112, -24},
    { 888, 104, -16},
    // 62 seconds
    { 1016, 72, -24},
    { 1120, 72, -16},
    { 1144, 56, -16},
    { 1256, 136, -48},
    { 1152, 112, -24},
    { 1088, 96, -56},
    { 1288, 152, -72},
    { 1256, 216, -144},
    { 1008, 240, -168},
    { 704, 224, -176},
    { 544, 216, -168},
    { 544, 208, -128},
    { 608, 200, -176},
    { 736, 184, -136},
    { 936, 232, -176},
    { 1128, 304, -248},
    { 1096, 296, -248},
    { 1032, 272, -240},
    { 1240, 296, -224},
    { 1224, 304, -232},
    { 1280, 272, -160},
    { 1240, 248, -120},
    { 1048, 240, -120},
    { 848, 208, -104},
    { 744, 144, -80},
    // 63 seconds
    { 688, 176, -64},
    { 776, 128, -64},
    { 912, 88, -88},
    { 896, 0, -120},
    { 1008, -48, -136},
    { 1072, 16, -136},
    { 1256, 40, -128},
    { 1584, 152, 8},
    { 1360, 152, -80},
    { 1304, 128, -104},
    { 1256, 120, -96},
    { 976, 184, -144},
    { 576, 120, -176},
    { 384, 112, -120},
    { 320, 168, -72},
    { 392, 168, -40},
    { 608, 288, -80},
    { 992, 384, -112},
    { 1192, 432, -200},
    { 1184, 440, -216},
    { 1304, 384, -200},
    { 1280, 448, -256},
    { 1144, 408, -232},
    { 1152, 392, -200},
    { 1224, 328, -160},
    // 64 seconds
    { 1128, 280, -80},
    { 912, 224, -64},
    { 744, 160, -32},
    { 696, 168, -56},
    { 736, 152, 0},
    { 792, 96, 32},
    { 888, 104, 32},
    { 1016, 96, 0},
    { 1040, 112, -8},
    { 1088, 40, 8},
    { 1296, 120, 40},
    { 1256, 152, 32},
    { 1160, 176, -112},
    { 1328, 168, -88},
    { 1192, 216, -128},
    { 880, 240, -160},
    { 592, 200, -176},
    { 504, 176, -136},
    { 536, 168, -136},
    { 656, 192, -144},
    { 808, 216, -208},
    { 1008, 240, -232},
    { 1112, 312, -272},
    { 1104, 328, -272},
    { 1208, 344, -216},
    // 65 seconds
    { 1240, 376, -232},
    { 1160, 344, -152},
    { 1296, 304, -80},
    { 1296, 272, -80},
    { 1160, 264, 0},
    { 880, 216, -16},
    { 736, 176, 8},
    { 712, 200, 56},
    { 768, 120, 56},
    { 848, 112, 48},
    { 920, 96, 32},
    { 1000, 128, -16},
    { 1008, 80, -8},
    { 1208, 104, -32},
    { 1328, 104, -24},
    { 1232, 152, -88},
    { 1232, 144, -160},
    { 1296, 176, -128},
    { 1136, 200, -200},
    { 792, 208, -240},
    { 544, 184, -192},
    { 464, 152, -184},
    { 488, 144, -144},
    { 680, 200, -136},
    { 920, 256, -184},
    // 66 seconds
    { 1128, 344, -248},
    { 1080, 384, -288},
    { 1104, 352, -232},
    { 1304, 384, -216},
    { 1152, 360, -192},
    { 1040, 320, -192},
    { 1168, 320, -152},
    { 1240, 280, -112},
    { 1128, 240, -64},
    { 968, 200, -72},
    { 792, 160, -48},
    { 720, 176, -56},
    { 784, 168, -40},
    { 840, 120, -24},
    { 936, 16, 8},
    { 1048, -32, 8},
    { 1128, 0, -64},
    { 1168, 64, -96},
    { 1288, 88, -24},
    { 1144, 152, -56},
    { 1248, 136, -120},
    { 1312, 168, -80},
    { 1136, 192, -144},
    { 848, 216, -184},
    { 608, 184, -184},
    // 67 seconds
    { 496, 168, -160},
    { 520, 152, -136},
    { 648, 208, -136},
    { 848, 256, -192},
    { 1104, 280, -216},
    { 1160, 304, -288},
    { 1104, 320, -248},
    { 1200, 320, -200},
    { 1168, 344, -216},
    { 992, 320, -184},
    { 1064, 320, -136},
    { 1200, 264, -120},
    { 1224, 248, -64},
    { 1016, 232, -16},
    { 848, 192, -48},
    { 752, 184, -48},
    { 800, 184, -16},
    { 864, 136, -24},
    { 856, 72, 16},
    { 976, 96, -16},
    { 968, 136, -56},
    { 992, 128, -96},
    { 1080, 136, -128},
    { 1144, 136, -88},
    { 1184, 120, -64},
    // 68 seconds
    { 1320, 184, -88},
    { 1400, 240, -128},
    { 1160, 264, -160},
    { 784, 248, -184},
    { 528, 208, -160},
    { 464, 208, -120},
    { 544, 176, -64},
    { 752, 216, -120},
    { 912, 248, -184},
    { 1104, 272, -216},
    { 1088, 280, -232},
    { 1352, 304, -216},
    { 1352, 336, -256},
    { 1048, 296, -176},
    { 1072, 280, -136},
    { 1192, 288, -160},
    { 1152, 240, -96},
    { 968, 200, -80},
    { 768, 160, -64},
    { 664, 168, -64},
    { 712, 160, -48},
    { 776, 136, -8},
    { 864, 88, -16},
    { 1024, 112, -16},
    { 1048, 160, -72},
    // 69 seconds
    { 1056, 120, -64},
    { 1224, 176, -64},
    { 1216, 152, -16},
    { 1144, 136, -80},
    { 1280, 160, -88},
    { 1256, 200, -144},
    { 1016, 232, -184},
    { 680, 216, -168},
    { 496, 152, -184},
    { 432, 104, -184},
    { 496, 112, -64},
    { 688, 200, -128},
    { 968, 352, -168},
    { 1160, 440, -248},
    { 1088, 416, -288},
    { 1144, 392, -224},
    { 1280, 448, -216},
    { 1120, 400, -200},
    { 1224, 336, -136},
    { 1264, 304, -88},
    { 1168, 264, -56},
    { 960, 224, -48},
    { 768, 184, -48},
    { 704, 152, -96},
    { 712, 152, -32},
    // 70 seconds
    { 808, 168, -8},
    { 840, 128, -40},
    { 920, 160, -64},
    { 984, 128, -88},
    { 1048, 120, -96},
    { 1240, 152, -112},
    { 1216, 144, -72},
    { 1072, 152, -104},
    { 1184, 160, -120},
    { 1232, 176, -88},
    { 1048, 208, -128},
    { 784, 224, -136},
    { 608, 192, -152},
    { 528, 184, -128},
    { 552, 168, -96},
    { 688, 216, -128},
    { 904, 288, -152},
    { 1112, 392, -200},
    { 1104, 440, -216},
    { 1152, 384, -224},
    { 1312, 416, -224},
    { 1096, 368, -192},
    { 1120, 320, -160},
    { 1144, 288, -152},
    { 1104, 248, -88},
    // 71 seconds
    { 992, 192, -16},
    { 792, 200, -56},
    { 672, 192, -56},
    { 664, 184, -40},
    { 760, 160, 8},
    { 848, 128, -16},
    { 1008, 136, -56},
    { 1152, 128, -104},
    { 1168, 64, -32},
    { 1328, 72, -64},
    { 1248, 96, 8},
    { 1080, 112, -72},
    { 1216, 136, -96},
    { 1192, 160, -112},
    { 944, 192, -128},
    { 656, 200, -168},
    { 472, 152, -136},
    { 448, 192, -80},
    { 544, 176, -112},
    { 736, 296, -152},
    { 1016, 376, -192},
    { 1168, 416, -216},
    { 1152, 432, -256},
    { 1256, 416, -192},
    { 1312, 456, -192},
    // 72 seconds
    { 1128, 408, -136},
    { 1112, 344, -128},
    { 1152, 288, -120},
    { 1136, 264, -72},
    { 896, 208, -40},
    { 704, 152, -24},
    { 656, 168, -56},
    { 752, 192, 0},
    { 896, 136, 56},
    { 1000, 88, 56},
    { 1056, 88, 8},
    { 1040, 64, -8},
    { 1136, 72, -80},
    { 1232, 88, -8},
    { 1112, 112, -16},
    { 1184, 152, -88},
    { 1336, 224, -120},
    { 1200, 240, -176},
    { 848, 240, -200},
    { 560, 184, -184},
    { 456, 176, -168},
    { 464, 168, -120},
    { 600, 200, -144},
    { 856, 240, -200},
    { 1120, 304, -272},
    // 73 seconds
    { 1120, 344, -288},
    { 1144, 336, -248},
    { 1248, 360, -216},
    { 1048, 352, -208},
    { 976, 304, -160},
    { 1136, 288, -128},
    { 1248, 288, -96},
    { 1200, 272, -24},
    { 984, 248, 0},
    { 784, 192, -16},
    { 704, 160, -16},
    { 728, 168, 8},
    { 776, 136, 16},
    { 848, 104, 0},
    { 1024, 144, -24},
    { 992, 168, -96},
    { 1032, 80, -120},
    { 1176, 112, -104},
    { 1216, 112, -56},
    { 1200, 160, -112},
    { 1288, 216, -128},
    { 1256, 216, -144},
    { 1024, 232, -176},
    { 720, 208, -176},
    { 488, 192, -160},
    // 74 seconds
    { 416, 208, -176},
    { 464, 176, -120},
    { 664, 208, -128},
    { 952, 208, -224},
    { 1136, 240, -304},
    { 1088, 256, -264},
    { 1256, 272, -184},
    { 1344, 376, -216},
    { 1144, 384, -168},
    { 1056, 320, -128},
    { 1136, 328, -136},
    { 1096, 248, -96},
    { 896, 184, -56},
    { 696, 168, -56},
    { 640, 168, -88},
    { 656, 168, -64},
    { 768, 144, -24},
    { 968, 88, -64},
    { 1112, -24, 8},
    { 1136, -16, -32},
    { 1168, 56, -96},
    { 1296, 104, 0},
    { 1192, 144, -16},
    { 1152, 152, -88},
    { 1272, 176, -96},
    // 75 seconds
    { 1184, 200, -144},
    { 904, 192, -200},
    { 616, 240, -192},
    { 464, 192, -200},
    { 432, 168, -120},
    { 512, 168, -152},
    { 664, 184, -160},
    { 1000, 248, -240},
    { 1192, 248, -272},
    { 1056, 248, -240},
    { 1288, 288, -160},
    { 1288, 376, -280},
    { 1112, 304, -144},
    { 1200, 280, -112},
    { 1176, 288, -96},
    { 1080, 264, -48},
    { 904, 208, -8},
    { 768, 216, -8},
    { 704, 208, -8},
    { 712, 120, -16},
    { 744, 128, 16},
    { 848, 80, -72},
    { 976, 128, -72},
    { 1064, 0, -72},
    { 1128, 80, -112},
    // 76 seconds
    { 1288, 176, -80},
    { 1120, 152, -104},
    { 1120, 184, -144},
    { 1280, 200, -96},
    { 1264, 216, -120},
    { 992, 248, -152},
    { 664, 248, -192},
    { 472, 152, -176},
    { 424, 152, -64},
    { 512, 168, -64},
    { 696, 248, -96},
    { 960, 312, -176},
    { 1168, 384, -296},
    { 1064, 392, -288},
    { 1104, 320, -232},
    { 1288, 392, -248},
    { 1080, 352, -240},
    { 1024, 320, -176},
    { 1176, 288, -160},
    { 1176, 256, -88},
    { 1016, 240, -56},
    { 792, 192, -32},
    { 696, 184, -56},
    { 672, 160, -32},
    { 776, 136, -32},
    // 77 seconds
    { 816, 88, -24},
    { 1032, 80, -48},
    { 1120, 104, -80},
    { 1096, 72, -144},
    { 1256, 136, -88},
    { 1256, 144, -104},
    { 1128, 144, -72},
    { 1272, 216, -88},
    { 1232, 264, -160},
    { 968, 264, -200},
    { 688, 200, -200},
    { 520, 184, -168},
    { 440, 168, -168},
    { 440, 152, -120},
    { 592, 184, -120},
    { 864, 224, -184},
    { 1184, 288, -280},
    { 1120, 264, -264},
    { 1200, 280, -232},
    { 1376, 384, -256},
    { 1104, 344, -216},
    { 976, 304, -136},
    { 1120, 328, -120},
    { 1192, 296, -112},
    { 1056, 224, -88},
    // 78 seconds
    { 816, 168, -72},
    { 640, 176, -64},
    { 600, 184, -72},
    { 672, 160, -72},
    { 824, 96, -40},
    { 1016, 80, 0},
    { 1184, 104, -24},
    { 1144, 152, -72},
    { 1232, 152, -96},
    { 1256, 152, -80},
    { 1096, 144, -144},
    { 1112, 152, -152},
    { 1224, 184, -144},
    { 1080, 224, -184},
    { 784, 216, -184},
    { 544, 200, -200},
    { 440, 152, -144},
    { 472, 144, -96},
    { 624, 192, -112},
    { 864, 224, -160},
    { 1096, 288, -208},
    { 1048, 344, -328},
    { 1008, 336, -280},
    { 1336, 368, -224},
    { 1304, 416, -200},
    // 79 seconds
    { 1128, 368, -88},
    { 1144, 360, -128},
    { 1160, 344, -80},
    { 1064, 288, -16},
    { 832, 200, -16},
    { 696, 152, -40},
    { 680, 160, -48},
    { 736, 152, -24},
    { 744, 120, 24},
    { 960, 72, -8},
    { 1152, 104, -48},
    { 1168, 64, -56},
    { 1296, 112, -80},
    { 1248, 96, -32},
    { 1128, 112, -120},
    { 1264, 104, -96},
    { 1304, 208, -120},
    { 1048, 280, -160},
    { 736, 240, -200},
    { 536, 192, -216},
    { 440, 112, -136},
    { 464, 144, -56},
    { 648, 232, -136},
    { 920, 312, -216},
    { 1144, 288, -232},
    // 80 seconds
    { 1096, 296, -240},
    { 1152, 352, -192},
    { 1296, 400, -152},
    { 1080, 352, -128},
    { 1032, 352, -120},
    { 1168, 376, -112},
    { 1224, 296, -96},
    { 1104, 240, -56},
    { 904, 192, -64},
    { 720, 152, -80},
    { 664, 176, -64},
    { 696, 144, -24},
    { 776, 152, -24},
    { 880, 120, -32},
    { 1040, 112, -72},
    { 1080, 88, -96},
    { 1072, 64, -144},
    { 1232, 120, -120},
    { 1136, 120, -96},
    { 1056, 152, -104},
    { 1216, 168, -104},
    { 1264, 224, -88},
    { 1096, 272, -144},
    { 784, 264, -160},
    { 552, 216, -168},
    // 81 seconds
    { 472, 192, -128},
    { 512, 176, -96},
    { 664, 224, -136},
    { 904, 240, -208},
    { 1128, 280, -264},
    { 1088, 296, -256},
    { 1168, 280, -264},
    { 1392, 336, -224},
    { 1096, 320, -176},
    { 976, 256, -128},
    { 1176, 272, -120},
    { 1168, 248, -128},
    { 1016, 240, -88},
    { 808, 184, -64},
    { 640, 152, -80},
    { 600, 152, -32},
    { 664, 128, -16},
    { 792, 64, -16},
    { 1072, 96, -64},
    { 1168, 120, -88},
    { 1136, 120, -56},
    { 1208, 176, -56},
    { 1192, 176, -64},
    { 1080, 16, -88},
    { 1272, 56, -112},
    // 82 seconds
    { 1312, 128, -112},
    { 1072, 168, -144},
    { 744, 152, -152},
    { 520, 152, -192},
    { 464, 216, -112},
    { 520, 184, -48},
    { 680, 216, -152},
    { 880, 240, -224},
    { 1064, 224, -280},
    { 1096, 248, -320},
    { 1216, 264, -296},
    { 1336, 320, -288},
    { 1048, 320, -224},
    { 1176, 280, -144},
    { 1256, 296, -104},
    { 1216, 272, -80},
    { 1000, 248, -40},
    { 776, 168, -48},
    { 680, 128, -88},
    { 664, 96, -40},
    { 728, 112, -8},
    { 808, 176, -16},
    { 976, 120, -40},
    { 1112, 168, -32},
    { 1048, 128, -40},
    // 83 seconds
    { 1208, 200, -120},
    { 1160, 144, -88},
    { 1056, 136, -112},
    { 1144, 128, -144},
    { 1248, 160, -144},
    { 1144, 168, -184},
    { 888, 216, -208},
    { 632, 216, -216},
    { 512, 152, -160},
    { 504, 168, -144},
    { 616, 224, -136},
    { 808, 248, -200},
    { 1056, 296, -216},
    { 1112, 336, -280},
    { 1056, 320, -224},
    { 1296, 352, -200},
    { 1280, 368, -224},
    { 1040, 280, -128},
    { 1128, 296, -88},
    { 1200, 296, -80},
    { 1112, 256, -48},
    { 896, 216, -32},
    { 736, 136, -40},
    { 656, 152, -24},
    { 704, 168, -32},
    // 84 seconds
    { 792, 120, -40},
    { 840, 88, -8},
    { 1008, 96, -64},
    { 1072, 104, -72},
    { 1096, 80, -104},
    { 1232, 160, -96},
    { 1160, 160, -88},
    { 1032, 160, -136},
    { 1216, 168, -80},
    { 1248, 224, -120},
    { 1032, 248, -136},
    { 720, 224, -152},
    { 544, 192, -152},
    { 496, 160, -128},
    { 568, 176, -104},
    { 696, 208, -160},
    { 800, 272, -192},
    { 1064, 352, -248},
    { 1128, 384, -288},
    { 1048, 336, -216},
    { 1328, 384, -216},
    { 1176, 376, -248},
    { 1056, 304, -168},
    { 1064, 296, -120},
    { 1104, 272, -120},
    // 85 seconds
    { 1024, 248, -72},
    { 824, 192, -56},
    { 672, 192, -56},
    { 656, 152, -48},
    { 696, 144, -24},
    { 832, 128, -32},
    { 856, 120, -8},
    { 1040, 120, -24},
    { 1168, 136, -48},
    { 1152, 120, -104},
    { 1208, 144, -120},
    { 1072, 112, -72},
    { 1048, 104, -80},
    { 1248, 104, -56},
    { 1264, 160, -80},
    { 1016, 216, -88},
    { 696, 200, -104},
    { 504, 184, -120},
    { 424, 176, -88},
    { 480, 160, -56},
    { 664, 160, -104},
    { 888, 184, -176},
    { 1128, 264, -240},
    { 1064, 280, -360},
    { 1240, 304, -304},
    // 86 seconds
    { 1488, 376, -344},
    { 1112, 296, -232},
    { 1088, 320, -152},
    { 1152, 400, -160},
    { 1096, 400, -48},
    { 928, 304, 72},
    { 768, 304, 168},
    { 680, 232, 120},
    { 560, 384, 136},
    { 688, 264, 112},
    { 848, 312, 136},
    { 1056, 296, 8},
    { 1200, 200, 0},
    { 1136, 16, 40},
    { 1008, -40, -96},
    { 1184, 72, -120},
    { 1104, -32, -120},
    { 1072, 24, -104},
    { 1168, 40, -80},
    { 1304, 120, -88},
    { 1176, 168, -80},
    { 880, 192, -24},
    { 640, 192, -8},
    { 520, 280, -56},
    { 488, 288, -56},
    // 87 seconds
    { 552, 264, -16},
    { 768, 208, -40},
    { 1064, 384, -120},
    { 1184, 408, -176},
    { 1232, 392, -248},
    { 1280, 392, -216},
    { 1104, 416, -272},
    { 1008, 400, -240},
    { 1088, 416, -216},
    { 1152, 352, -176},
    { 1120, 280, -128},
    { 936, 208, -120},
    { 768, 184, -128},
    { 704, 80, -96},
    { 696, 216, -32},
    { 776, 128, -64},
    { 760, 136, -48},
    { 848, 128, -80},
    { 952, 120, -128},
    { 1104, 152, -168},
    { 1200, 120, -168},
    { 1216, 64, -64},
    { 1248, 152, -16},
    { 1232, 72, -96},
    { 1272, 72, -40},
    // 88 seconds
    { 1088, 168, -136},
    { 808, 208, -136},
    { 576, 192, -136},
    { 464, 144, -144},
    { 456, 128, -96},
    { 576, 224, -80},
    { 808, 232, -192},
    { 1048, 312, -184},
    { 1080, 392, -248},
    { 1080, 392, -200},
    { 1264, 392, -144},
    { 1200, 416, -192},
    { 1088, 368, -136},
    { 1160, 344, -112},
    { 1176, 288, -96},
    { 1088, 248, -72},
    { 880, 192, -64},
    { 744, 176, -48},
    { 704, 136, -24},
    { 720, 168, -40},
    { 784, 152, -40},
    { 840, 144, -96},
    { 1024, 64, -144},
    { 1072, 64, -80},
    { 1096, 48, -80},
    // 89 seconds
    { 1280, 152, -40},
    { 1224, 176, -16},
    { 1008, 184, -24},
    { 1160, 168, -24},
    { 1232, 184, -56},
    { 1048, 224, -168},
    { 784, 184, -120},
    { 568, 168, -136},
    { 488, 160, -160},
    { 520, 184, -128},
    { 672, 192, -152},
    { 896, 224, -184},
    { 1176, 280, -288},
    { 1096, 312, -320},
    { 1096, 280, -272},
    { 1344, 352, -232},
    { 1120, 344, -240},
    { 1032, 288, -144},
    { 1168, 304, -120},
    { 1272, 280, -80},
    { 1112, 232, -32},
    { 864, 208, -32},
    { 712, 176, -40},
    { 680, 160, -32},
    { 736, 160, -16},
    // 90 seconds
    { 880, 136, -16},
    { 1000, 104, -40},
    { 1072, 64, -24},
    { 1064, 48, -16},
    { 1120, 96, -64},
    { 1168, 168, -64},
    { 1040, 168, -80},
    { 1096, 152, -88},
    { 1280, 184, -64},
    { 1192, 216, -136},
    { 944, 240, -136},
    { 680, 216, -136},
    { 568, 192, -152},
    { 552, 168, -136},
    { 648, 184, -128},
    { 760, 224, -168},
    { 1040, 280, -232},
    { 1168, 296, -296},
    { 1088, 304, -272},
    { 1256, 336, -208},
    { 1240, 368, -256},
    { 1032, 320, -176},
    { 1136, 304, -136},
    { 1216, 264, -88},
    { 1144, 248, -48},
    // 91 seconds
    { 952, 216, -16},
    { 776, 184, -40},
    { 720, 152, -40},
    { 720, 152, 0},
    { 824, 128, 8},
    { 880, 96, 32},
    { 1056, 152, -24},
    { 1104, 96, -8},
    { 1064, 64, -24},
    { 1280, 96, -48},
    { 1184, 16, -16},
    { 1112, 80, -80},
    { 1224, 104, -64},
    { 1272, 160, -56},
    { 1120, 224, -112},
    { 824, 240, -152},
    { 616, 200, -192},
    { 536, 176, -136},
    { 576, 192, -152},
    { 720, 200, -152},
    { 856, 240, -216},
    { 1064, 288, -248},
    { 1128, 312, -304},
    { 1064, 288, -264},
    { 1288, 312, -240},
    // 92 seconds
    { 1216, 320, -232},
    { 992, 296, -160},
    { 968, 280, -136},
    { 1104, 288, -136},
    { 1176, 272, -72},
    { 1040, 224, -48},
    { 888, 184, -16},
    { 816, 176, -32},
    { 800, 176, -8},
    { 856, 144, -16},
    { 824, 104, 8},
    { 952, 112, 8},
    { 1064, 168, -56},
    { 920, 120, -72},
    { 1080, 144, -72},
    { 1104, 168, -80},
    { 1096, 144, -128},
    { 1168, 136, -56},
    { 1264, 168, -72},
    { 1200, 216, -128},
    { 984, 240, -176},
    { 712, 224, -176},
    { 568, 216, -160},
    { 552, 176, -144},
    { 656, 168, -120},
    // 93 seconds
    { 832, 216, -152},
    { 960, 256, -184},
    { 1064, 312, -288},
    { 1008, 320, -312},
    { 1104, 304, -256},
    { 1264, 352, -240},
    { 1048, 352, -208},
    { 1048, 320, -144},
    { 1152, 352, -144},
    { 1240, 288, -96},
    { 1144, 240, -48},
    { 960, 208, -24},
    { 792, 200, -24},
    { 768, 192, -56},
    { 808, 152, -64},
    { 800, 120, -24},
    { 824, 64, 8},
    { 952, 120, -48},
    { 1000, 184, -56},
    { 1088, 144, -112},
    { 1176, 184, -152},
    { 1040, 152, -120},
    { 960, 136, -184},
    { 1152, 128, -96},
    { 1248, 208, -136},
    // 94 seconds
    { 1112, 248, -168},
    { 864, 224, -176},
    { 648, 176, -168},
    { 552, 160, -152},
    { 568, 184, -112},
    { 736, 208, -160},
    { 856, 272, -168},
    { 1104, 304, -224},
    { 1096, 368, -256},
    { 1136, 384, -280},
    { 1264, 400, -240},
    { 1000, 384, -224},
    { 1048, 368, -184},
    { 1200, 320, -128},
    { 1288, 288, -88},
    { 1168, 240, -48},
    { 936, 216, -40},
    { 800, 152, -48},
    { 760, 152, -24},
    { 784, 144, 8},
    { 832, 120, -16},
    { 832, 80, -32},
    { 880, 144, -80},
    { 976, 120, -88},
    { 960, 112, -136},
    // 95 seconds
    { 1160, 168, -160},
    { 1120, 152, -96},
    { 1112, 160, -120},
    { 1272, 232, -128},
    { 1224, 232, -120},
    { 976, 240, -104},
    { 720, 208, -120},
    { 600, 208, -112},
    { 592, 208, -96},
    { 704, 224, -88},
    { 824, 272, -160},
    { 952, 352, -184},
    { 1104, 408, -248},
    { 1168, 416, -256},
    { 1152, 360, -240},
    { 1224, 408, -272},
    { 1072, 384, -256},
    { 1176, 312, -128},
    { 1160, 224, -64},
    { 1064, 184, -80},
    { 872, 168, -32},
    { 744, 208, -56},
    { 760, 208, -32},
    { 776, 216, 48},
    { 888, 192, 16},
    // 96 seconds
    { 904, 184, -8},
    { 992, 192, -40},
    { 1080, 160, -56},
    { 1024, 88, -64},
    { 1064, 48, -144},
    { 1232, 88, -200},
    { 1112, 48, -88},
    { 1224, 64, -144},
    { 1272, 168, -208},
    { 1104, 192, -160},
    { 824, 184, -144},
    { 592, 192, -136},
    { 536, 160, -80},
    { 576, 216, -64},
    { 712, 304, -48},
    { 896, 368, -88},
    { 1048, 408, -112},
    { 1128, 440, -208},
    { 1088, 384, -192},
    { 1304, 376, -200},
    { 1136, 344, -240},
    { 1016, 280, -216},
    { 1136, 304, -192},
    { 1176, 264, -160},
    { 1072, 216, -88},
    // 97 seconds
    { 912, 216, -88},
    { 768, 208, -80},
    { 760, 184, -56},
    { 808, 168, -8},
    { 896, 168, 8},
    { 968, 152, -16},
    { 1120, 184, -32},
    { 1032, 152, -56},
    { 984, 64, -72},
    { 1136, 88, -96},
    { 1160, 128, -152},
    { 992, 96, -200},
    { 1160, 144, -144},
    { 1280, 144, -144},
    { 1112, 200, -104},
    { 808, 232, -144},
    { 576, 192, -160},
    { 504, 184, -128},
    { 576, 184, -120},
    { 688, 184, -112},
    { 800, 200, -216},
    { 992, 264, -312},
    { 1088, 272, -360},
    { 1184, 272, -360},
    { 1320, 296, -272},
    // 98 seconds
    { 1128, 352, -312},
    { 1112, 320, -240},
    { 1168, 296, -152},
    { 1192, 272, -112},
    { 1104, 224, -72},
    { 904, 232, -56},
    { 744, 200, -40},
    { 688, 144, -32},
    { 736, 216, 0},
    { 816, 128, -16},
    { 856, 144, -8},
    { 984, 112, -72},
    { 1032, 128, -80},
    { 1088, 56, -152},
    { 1216, 88, -160},
    { 1096, 104, -88},
    { 1080, 136, -112},
    { 1232, 168, -104},
    { 1264, 240, -160},
    { 1032, 256, -184},
    { 728, 200, -144},
    { 584, 192, -168},
    { 504, 240, -160},
    { 568, 240, -136},
    { 704, 352, -136},
    // 99 seconds
    { 856, 336, -184},
    { 1024, 392, -240},
    { 1016, 376, -256},
    { 1032, 368, -224},
    { 1328, 424, -224},
    { 1104, 376, -208},
    { 1112, 336, -136},
    { 1216, 328, -112},
    { 1216, 296, -64},
    { 1056, 248, -16},
    { 824, 184, 0},
    { 720, 160, -24},
    { 696, 152, -40},
    { 776, 168, -16},
    { 840, 168, 0},
    { 896, 128, -8},
    { 1024, 136, -32},
    { 1024, 168, -48},
    { 1104, 128, -120},
    { 1208, 184, -144},
    { 1104, 176, -144},
    { 1008, 136, -152},
    { 1168, 168, -120},
    { 1184, 232, -128},
    { 992, 248, -176},
    // 100 seconds
    { 712, 184, -144},
    { 560, 192, -136},
    { 528, 224, -128},
    { 544, 184, -96},
    { 680, 208, -120},
    { 880, 272, -144},
    { 1136, 344, -240},
    { 1136, 336, -240},
    { 1208, 304, -248},
    { 1344, 360, -256},
    { 1120, 392, -208},
    { 1088, 304, -144},
    { 1128, 320, -160},
    { 1096, 280, -104},
    { 976, 256, -48},
    { 800, 192, -48},
    { 696, 152, -40},
    { 664, 144, -32},
    { 776, 176, -24},
    { 832, 160, 0},
    { 1024, 120, -32},
    { 1200, 128, -32},
    { 1088, 32, 8},
    { 1200, 88, -72},
    { 1184, 112, -56},
    // 101 seconds
    { 1096, 120, -72},
    { 1184, 152, -120},
    { 1200, 208, -144},
    { 1080, 240, -208},
    { 800, 184, -168},
    { 576, 176, -152},
    { 480, 184, -144},
    { 488, 200, -136},
    { 616, 208, -120},
    { 800, 216, -152},
    { 1056, 256, -216},
    { 1128, 280, -304},
    { 1096, 312, -280},
    { 1256, 320, -224},
    { 1232, 360, -264},
    { 1016, 344, -232},
    { 1040, 304, -168},
    { 1152, 296, -128},
    { 1144, 280, -80},
    { 1000, 240, -80},
    { 840, 200, -40},
    { 736, 192, -16},
    { 736, 176, -40},
    { 800, 136, -32},
    { 776, 104, -32},
    // 102 seconds
    { 912, 0, -32},
    { 992, -40, -32},
    { 1032, 48, -56},
    { 1192, 112, -120},
    { 1272, 88, 0},
    { 1184, 176, -24},
    { 1264, 168, -112},
    { 1320, 256, -144},
    { 1120, 280, -192},
    { 776, 256, -160},
    { 552, 224, -176},
    { 504, 200, -128},
    { 560, 184, -88},
    { 688, 224, -120},
    { 824, 248, -160},
    { 1056, 280, -208},
    { 1072, 320, -280},
    { 1104, 312, -240},
    { 1232, 264, -184},
    { 1144, 296, -224},
    { 992, 320, -216},
    { 1120, 312, -128},
    { 1272, 272, -96},
    { 1192, 240, -56},
    { 936, 192, -40},
    // 103 seconds
    { 752, 144, -112},
    { 672, 128, -80},
    { 656, 144, -8},
    { 752, 120, -16},
    { 896, 64, -48},
    { 1104, 96, -40},
    { 1176, 128, -64},
    { 1128, 152, -112},
    { 1192, 168, -88},
    { 1104, 152, -104},
    { 1096, 120, -96},
    { 1272, 176, -120},
    { 1176, 208, -176},
    { 888, 232, -152},
    { 600, 152, -208},
    { 472, 136, -136},
    { 472, 160, -120},
    { 584, 192, -128},
    { 760, 224, -176},
    { 1008, 256, -232},
    { 1104, 280, -264},
    { 1072, 312, -216},
    { 1176, 336, -160},
    { 1208, 376, -160},
    { 1032, 376, -112},
    // 104 seconds
    { 1152, 368, -112},
    { 1200, 352, -104},
    { 1144, 288, -48},
    { 912, 240, -40},
    { 728, 200, -48},
    { 664, 152, -56},
    { 704, 152, -24},
    { 800, 120, -24},
    { 880, 120, 8},
    { 1088, 184, -64},
    { 1056, 128, -80},
    { 1144, 88, -96},
    { 1272, 128, -64},
    { 1144, 192, -48},
    { 1000, 160, -128},
    { 1168, 192, -104},
    { 1200, 184, -88},
    { 992, 208, -128},
    { 696, 200, -136},
    { 520, 160, -168},
    { 480, 160, -176},
    { 536, 144, -144},
    { 728, 168, -200},
    { 944, 240, -248},
    { 1120, 280, -312},
    // 105 seconds
    { 1064, 296, -336},
    { 1136, 288, -264},
    { 1352, 336, -240},
    { 1096, 312, -224},
    { 1032, 304, -168},
    { 1144, 304, -128},
    { 1160, 280, -96},
    { 1008, 232, -64},
    { 800, 208, -72},
    { 680, 168, -72},
    { 656, 168, -56},
    { 680, 128, -24},
    { 752, 144, -32},
    { 944, 120, -72},
    { 1128, 88, -16},
    { 1152, 48, -56},
    { 1112, 72, -112},
    { 1184, 120, -128},
    { 1120, 152, -128},
    { 1120, 152, -168},
    { 1232, 200, -168},
    { 1160, 240, -216},
    { 888, 224, -208},
    { 624, 184, -184},
    { 496, 208, -120},
    // 106 seconds
    { 472, 224, -112},
    { 568, 184, -128},
    { 752, 248, -136},
    { 992, 256, -176},
    { 1096, 312, -248},
    { 1080, 288, -264},
    { 1192, 280, -208},
    { 1272, 320, -216},
    { 1040, 320, -200},
    { 1112, 304, -152},
    { 1192, 296, -120},
    { 1120, 272, -88},
    { 952, 256, -72},
    { 792, 224, -72},
    { 696, 160, -16},
    { 696, 160, -40},
    { 752, 96, 8},
    { 840, 96, 8},
    { 976, 64, 16},
    { 1056, 144, -40},
    { 1096, 232, -176},
    { 1232, 120, -160},
    { 1160, 176, -112},
    { 1024, 192, -200},
    { 1088, 160, -176},
    // 107 seconds
    { 1208, 232, -160},
    { 1064, 240, -152},
    { 808, 192, -152},
    { 592, 232, -168},
    { 504, 208, -160},
    { 520, 200, -80},
    { 664, 232, -80},
    { 832, 256, -144},
    { 1040, 280, -192},
    { 1040, 328, -264},
    { 1024, 304, -248},
    { 1280, 344, -224},
    { 1176, 336, -248},
    { 1040, 296, -192},
    { 1080, 336, -192},
    { 1104, 320, -144},
    { 1072, 264, -72},
    { 920, 200, -40},
    { 768, 176, -40},
    { 688, 160, -64},
    { 704, 168, -40},
    { 760, 168, -16},
    { 816, 152, -16},
    { 976, 144, -40},
    { 1080, 176, -72},
    // 108 seconds
    { 1088, 144, -128},
    { 1216, 144, -120},
    { 1152, 144, -104},
    { 1112, 152, -80},
    { 1144, 200, -104},
    { 1152, 184, -152},
    { 1016, 240, -184},
    { 776, 200, -160},
    { 592, 176, -160},
    { 520, 192, -144},
    { 520, 200, -136},
    { 632, 216, -112},
    { 816, 232, -152},
    { 1040, 256, -216},
    { 1088, 296, -272},
    { 1176, 280, -256},
    { 1488, 336, -280},
    { 1216, 304, -208},
    { 976, 264, -168},
    { 1000, 288, -184},
    { 1040, 280, -112},
    { 960, 232, -56},
    { 784, 176, -32},
    { 672, 136, -80},
    { 688, 168, -64},
    // 109 seconds
    { 768, 216, -24},
    { 808, 128, -8},
    { 912, 112, -48},
    { 1096, 144, -48},
    { 1104, 168, -56},
    { 1176, 176, -88},
    { 1128, 152, -80},
    { 1000, 128, -80},
    { 1120, 96, -72},
    { 1288, 168, -72},
    { 1152, 232, -168},
    { 880, 200, -168},
    { 616, 176, -168},
    { 496, 168, -184},
    { 480, 128, -120},
    { 568, 176, -128},
    { 728, 216, -200},
    { 968, 256, -232},
    { 1104, 272, -296},
    { 1064, 280, -272},
    { 1184, 280, -200},
    { 1248, 328, -200},
    { 1008, 304, -200},
    { 1104, 312, -144},
    { 1136, 280, -104},
    // 110 seconds
    { 1120, 256, -80},
    { 960, 232, -40},
    { 760, 184, -48},
    { 672, 160, -64},
    { 680, 160, -56},
    { 752, 168, -32},
    { 816, 128, -24},
    { 1000, 128, -16},
    { 1104, 144, -64},
    { 1152, 144, -136},
    { 1248, 112, -120},
    { 1224, 104, -80},
    { 1016, 104, -72},
    { 1160, 128, -96},
    { 1208, 192, -128},
    { 976, 200, -104},
    { 688, 184, -136},
    { 520, 152, -112},
    { 464, 168, -96},
    { 480, 200, -120},
    { 624, 224, -136},
    { 856, 192, -168},
    { 1136, 240, -216},
    { 1152, 280, -296},
    { 1184, 288, -272},
    // 111 seconds
    { 1448, 320, -272},
    { 1168, 336, -224},
    { 1000, 272, -144},
    { 1008, 304, -168},
    { 1040, 304, -120},
    { 960, 240, -64},
    { 784, 184, -24},
    { 664, 168, -48},
    { 664, 160, -48},
    { 768, 192, -16},
    { 816, 160, 0},
    { 952, 160, -32},
    { 1088, 168, -120},
    { 1160, 96, -120},
    { 1256, 72, -88},
    { 1256, 48, 0},
    { 1104, 120, -16},
    { 1104, 128, -72},
    { 1208, 168, -112},
    { 1072, 184, -168},
    { 792, 176, -160},
    { 560, 176, -160},
    { 472, 152, -216},
    { 504, 136, -128},
    { 648, 224, -176},
    // 112 seconds
    { 832, 232, -200},
    { 1104, 240, -256},
    { 1096, 296, -312},
    { 1032, 288, -256},
    { 1256, 304, -176},
    { 1184, 328, -192},
    { 1088, 280, -152},
    { 1136, 288, -104},
    { 1104, 280, -88},
    { 1056, 256, -80},
    { 872, 232, -48},
    { 720, 184, -56},
    { 656, 160, -48},
    { 688, 176, -48},
    { 760, 152, -40},
    { 864, 120, -24},
    { 1000, 64, 0},
    { 1144, 64, -8},
    { 1152, 120, -64},
    { 1248, 120, -112},
    { 1144, 104, -40},
    { 1008, 88, -88},
    { 1248, 128, -80},
    { 1312, 216, -152},
    { 1088, 232, -168},
    // 113 seconds
    { 760, 216, -176},
    { 528, 208, -160},
    { 448, 144, -184},
    { 512, 128, -96},
    { 672, 200, -152},
    { 880, 216, -176},
    { 1088, 264, -248},
    { 1040, 288, -288},
    { 1064, 256, -240},
    { 1352, 320, -200},
    { 1192, 328, -224},
    { 1088, 320, -176},
    { 1072, 272, -120},
    { 1136, 272, -88},
    { 1088, 248, -72},
    { 872, 208, -48},
    { 720, 184, -48},
    { 664, 176, -56},
    { 712, 152, -56},
    { 760, 144, -16},
    { 784, 104, -8},
    { 984, 136, -80},
    { 1056, 160, -96},
    { 1104, 96, -80},
    { 1224, 160, -80},
    // 114 seconds
    { 1176, 160, -88},
    { 1024, 168, -104},
    { 1176, 144, -104},
    { 1272, 224, -136},
    { 1072, 224, -168},
    { 752, 208, -160},
    { 544, 192, -152},
    { 480, 184, -120},
    { 544, 184, -80},
    { 680, 224, -120},
    { 824, 264, -152},
    { 1104, 272, -208},
    { 1088, 312, -256},
    { 1064, 288, -232},
    { 1296, 320, -216},
    { 1200, 352, -248},
    { 1048, 296, -152},
    { 1040, 296, -120},
    { 1120, 272, -128},
    { 1072, 248, -96},
    { 928, 208, -72},
    { 784, 184, -56},
    { 712, 160, -56},
    { 728, 152, -40},
    { 784, 144, -16},
    // 115 seconds
    { 800, 120, 0},
    { 944, 144, -40},
    { 1048, 144, -80},
    { 1064, 112, -120},
    { 1264, 152, -104},
    { 1160, 152, -88},
    { 1008, 176, -96},
    { 1168, 152, -72},
    { 1280, 240, -96},
    { 1120, 248, -152},
    { 808, 224, -152},
    { 584, 208, -152},
    { 504, 176, -136},
    { 512, 176, -104},
    { 640, 216, -128},
    { 784, 240, -184},
    { 1032, 280, -232},
    { 1088, 296, -280},
    { 1056, 288, -272},
    { 1264, 328, -224},
    { 1240, 344, -248},
    { 1016, 296, -184},
    { 1128, 280, -128},
    { 1200, 280, -104},
    { 1136, 280, -56},
    // 116 seconds
    { 912, 216, -40},
    { 752, 184, -40},
    { 696, 168, -40},
    { 736, 160, -32},
    { 840, 136, -8},
    { 1040, 96, 0},
    { 1112, 136, -8},
    { 1072, 176, -72},
    { 1152, 152, -96},
    { 1160, 176, -32},
    { 1064, 168, -136},
    { 952, 176, -200},
    { 1080, 144, -104},
    { 1160, 176, -136},
    { 1016, 208, -184},
    { 792, 224, -152},
    { 616, 200, -184},
    { 520, 184, -128},
    { 520, 184, -96},
    { 632, 216, -112},
    { 832, 248, -192},
    { 1080, 304, -248},
    { 1048, 312, -272},
    { 1000, 280, -240},
    { 1360, 360, -216},
    // 117 seconds
    { 1232, 352, -248},
    { 1088, 304, -136},
    { 1136, 280, -128},
    { 1144, 272, -96},
    { 1024, 264, -56},
    { 864, 200, -8},
    { 760, 160, -24},
    { 704, 144, -16},
    { 728, 128, -16},
    { 760, 128, -24},
    { 760, 104, -16},
    { 992, 128, -80},
    { 1048, 88, -48},
    { 1088, 72, -80},
    { 1336, 144, -64},
    { 1200, 160, -24},
    { 1192, 192, -112},
    { 1304, 184, -128},
    { 1216, 232, -128},
    { 944, 248, -176},
    { 608, 208, -168},
    { 488, 184, -168},
    { 480, 184, -136},
    { 600, 200, -112},
    { 792, 256, -168},
    // 118 seconds
    { 1024, 272, -240},
    { 1104, 296, -312},
    { 1088, 288, -280},
    { 1280, 272, -216},
    { 1256, 328, -224},
    { 960, 288, -152},
    { 1096, 272, -112},
    { 1224, 296, -112},
    { 1160, 280, -72},
    { 936, 216, -56},
    { 736, 168, -88},
    { 648, 144, -64},
    { 672, 152, -64},
    { 752, 144, -24},
    { 848, 120, -8},
    { 1056, 128, -56},
    { 1128, 168, -88},
    { 1096, 112, -80},
    { 1208, 128, -64},
    { 1112, 168, -88},
    { 984, 136, -144},
    { 1200, 88, -112},
    { 1272, 128, -128},
    { 1040, 256, -176},
    { 760, 200, -192},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:15:10 local
AccelRawData *activity_sample_walk_200_pbl_25670_12(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25670_12
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -624, 800, -16},
    { -544, 832, -232},
    { -512, 1072, -312},
    { -504, 880, -96},
    { -496, 968, -144},
    { -528, 848, -136},
    { -480, 616, -216},
    { -464, 360, -488},
    { -376, 328, -896},
    { -360, 240, -896},
    { -312, 112, -936},
    { -296, 128, -1008},
    { -488, 96, -944},
    { -280, 96, -1032},
    { -200, 88, -992},
    { -328, 72, -992},
    { -376, 64, -992},
    { -304, 8, -968},
    { -304, 40, -1008},
    { -184, -32, -984},
    { -312, 80, -1000},
    { -304, 16, -992},
    { -200, -128, -840},
    { -120, 56, -904},
    { -408, -136, -992},
    // 1 seconds
    { -232, -72, -936},
    { -216, -40, -1024},
    { -288, -128, -1104},
    { -256, -48, -1024},
    { -120, -80, -984},
    { -160, -152, -960},
    { -176, -56, -952},
    { -192, -8, -984},
    { -152, -32, -992},
    { -160, -40, -976},
    { -144, -56, -944},
    { -128, -112, -904},
    { -88, -136, -872},
    { -56, -48, -800},
    { 8, -40, -776},
    { 88, 40, -704},
    { 176, 64, -632},
    { 280, 48, -696},
    { 368, 176, -840},
    { 424, 120, -808},
    { 536, 184, -856},
    { 608, 224, -832},
    { 688, 248, -832},
    { 768, 232, -768},
    { 848, 424, -784},
    // 2 seconds
    { 840, 296, -656},
    { 864, 320, -632},
    { 936, 280, -536},
    { 992, 224, -440},
    { 976, 312, -472},
    { 920, 384, -392},
    { 928, 256, -360},
    { 936, 248, -344},
    { 912, 296, -288},
    { 896, 296, -280},
    { 880, 256, -232},
    { 864, 232, -256},
    { 880, 224, -232},
    { 904, 184, -256},
    { 904, 184, -232},
    { 904, 168, -240},
    { 912, 208, -232},
    { 904, 216, -224},
    { 880, 160, -216},
    { 888, 144, -216},
    { 896, 136, -216},
    { 904, 136, -224},
    { 912, 136, -216},
    { 896, 128, -224},
    { 880, 120, -224},
    // 3 seconds
    { 904, 96, -232},
    { 904, 128, -224},
    { 920, 88, -232},
    { 944, 80, -232},
    { 904, 88, -208},
    { 912, 104, -200},
    { 920, 128, -216},
    { 880, 176, -224},
    { 824, 176, -232},
    { 816, 216, -216},
    { 816, 208, -232},
    { 840, 216, -240},
    { 856, 216, -280},
    { 880, 224, -296},
    { 912, 224, -304},
    { 944, 232, -312},
    { 1000, 240, -288},
    { 1160, 264, -312},
    { 1168, 256, -288},
    { 960, 264, -208},
    { 872, 264, -160},
    { 840, 280, -136},
    { 1016, 272, -136},
    { 1096, 312, -152},
    { 1080, 240, -48},
    // 4 seconds
    { 1056, 208, -104},
    { 976, 192, -88},
    { 888, 168, -80},
    { 808, 160, -56},
    { 768, 136, -96},
    { 728, 96, -168},
    { 744, 64, -208},
    { 912, 120, -240},
    { 1080, 80, -208},
    { 1248, 112, -200},
    { 1272, 160, -128},
    { 1080, 240, -120},
    { 928, 256, -192},
    { 1064, 184, -192},
    { 1168, 216, -144},
    { 992, 216, -184},
    { 760, 216, -200},
    { 584, 176, -208},
    { 504, 168, -208},
    { 512, 152, -224},
    { 624, 144, -256},
    { 800, 152, -352},
    { 1112, 152, -360},
    { 1096, 216, -408},
    { 1120, 224, -304},
    // 5 seconds
    { 1336, 328, -280},
    { 1104, 352, -288},
    { 1056, 312, -224},
    { 1032, 296, -200},
    { 1168, 296, -184},
    { 1056, 232, -104},
    { 888, 208, -104},
    { 768, 176, -80},
    { 688, 176, -88},
    { 712, 144, -64},
    { 824, 128, -56},
    { 952, 168, -8},
    { 1112, 168, -48},
    { 1136, 168, -56},
    { 1072, 152, -72},
    { 1176, 160, -48},
    { 1008, 104, -16},
    { 1112, 96, -64},
    { 1240, 128, -56},
    { 1136, 128, -120},
    { 944, 184, -128},
    { 720, 176, -176},
    { 592, 160, -168},
    { 560, 136, -176},
    { 600, 184, -184},
    // 6 seconds
    { 736, 184, -216},
    { 1016, 232, -256},
    { 1240, 256, -304},
    { 1192, 272, -328},
    { 1168, 240, -248},
    { 1256, 280, -240},
    { 1048, 296, -256},
    { 976, 288, -184},
    { 1008, 288, -144},
    { 1120, 288, -120},
    { 1008, 248, -40},
    { 936, 200, -56},
    { 784, 184, -40},
    { 736, 176, -64},
    { 784, 160, -48},
    { 832, 152, -56},
    { 928, 104, -48},
    { 1072, 96, -80},
    { 1120, 144, -120},
    { 1104, 72, -136},
    { 1248, 120, -168},
    { 1064, 104, -88},
    { 1032, 112, -152},
    { 1192, 160, -120},
    { 1208, 176, -136},
    // 7 seconds
    { 1016, 208, -136},
    { 736, 200, -120},
    { 544, 184, -152},
    { 480, 160, -200},
    { 528, 200, -96},
    { 688, 216, -136},
    { 880, 304, -192},
    { 1040, 384, -272},
    { 1072, 424, -288},
    { 1152, 432, -288},
    { 1264, 448, -240},
    { 1120, 424, -240},
    { 1096, 400, -216},
    { 1200, 360, -136},
    { 1160, 296, -128},
    { 1008, 240, -88},
    { 832, 200, -96},
    { 712, 184, -88},
    { 688, 176, -80},
    { 744, 192, -32},
    { 800, 112, -48},
    { 928, 120, -56},
    { 1112, 88, -96},
    { 1120, 72, -104},
    { 1168, 24, -120},
    // 8 seconds
    { 1216, 104, -104},
    { 1088, 128, -80},
    { 1224, 152, -104},
    { 1264, 200, -112},
    { 1080, 232, -168},
    { 784, 232, -168},
    { 552, 208, -176},
    { 448, 168, -168},
    { 472, 192, -192},
    { 624, 176, -176},
    { 864, 224, -240},
    { 1120, 248, -280},
    { 1168, 280, -320},
    { 1184, 280, -296},
    { 1416, 344, -280},
    { 1152, 336, -280},
    { 992, 288, -216},
    { 1096, 312, -208},
    { 1120, 264, -160},
    { 992, 240, -80},
    { 792, 216, -72},
    { 712, 240, -96},
    { 736, 184, -88},
    { 800, 168, -32},
    { 864, 128, -40},
    // 9 seconds
    { 976, 96, -56},
    { 1104, 64, -80},
    { 1112, 56, -120},
    { 1168, 40, -184},
    { 1152, 72, -104},
    { 1080, 88, -104},
    { 1120, 128, -184},
    { 1248, 152, -176},
    { 1144, 192, -176},
    { 848, 208, -176},
    { 576, 192, -152},
    { 456, 208, -176},
    { 464, 192, -168},
    { 608, 208, -144},
    { 856, 192, -192},
    { 1160, 240, -240},
    { 1120, 248, -296},
    { 1136, 312, -336},
    { 1304, 328, -288},
    { 1192, 328, -296},
    { 1072, 312, -272},
    { 1080, 272, -200},
    { 1160, 272, -160},
    { 1064, 264, -112},
    { 912, 216, -112},
    // 10 seconds
    { 760, 168, -48},
    { 680, 168, -48},
    { 704, 168, -48},
    { 776, 136, -8},
    { 856, 120, -8},
    { 992, 168, -104},
    { 1112, 256, -128},
    { 1088, 96, -152},
    { 1200, 104, -136},
    { 1128, 136, -152},
    { 1024, 128, -168},
    { 1272, 168, -168},
    { 1248, 144, -152},
    { 992, 192, -176},
    { 712, 168, -128},
    { 528, 168, -128},
    { 456, 184, -128},
    { 496, 232, -120},
    { 624, 264, -96},
    { 880, 240, -128},
    { 1144, 240, -224},
    { 1152, 312, -248},
    { 1304, 288, -296},
    { 1352, 336, -360},
    { 1128, 352, -352},
    // 11 seconds
    { 1072, 304, -240},
    { 1128, 280, -192},
    { 1120, 328, -136},
    { 976, 208, -88},
    { 768, 160, -56},
    { 696, 168, -80},
    { 680, 176, -32},
    { 752, 192, -16},
    { 824, 136, -8},
    { 904, 96, -16},
    { 1056, 168, -32},
    { 1088, 192, -88},
    { 1224, 176, -136},
    { 1184, 200, -104},
    { 1000, 200, -168},
    { 1152, 168, -96},
    { 1272, 224, -104},
    { 1048, 208, -120},
    { 792, 216, -96},
    { 568, 152, -160},
    { 480, 152, -160},
    { 504, 168, -96},
    { 632, 136, -120},
    { 752, 280, -216},
    { 896, 424, -360},
    // 12 seconds
    { 1040, 456, -376},
    { 1104, 432, -344},
    { 1448, 528, -312},
    { 1160, 512, -288},
    { 1000, 464, -216},
    { 1000, 416, -176},
    { 1072, 352, -168},
    { 992, 280, -88},
    { 848, 248, -72},
    { 720, 248, -40},
    { 688, 216, -32},
    { 680, 200, -32},
    { 768, 168, -48},
    { 848, 104, -32},
    { 1032, 120, -80},
    { 1056, 80, -40},
    { 1144, 112, -64},
    { 1184, 168, -152},
    { 1032, 176, -160},
    { 1128, 192, -208},
    { 1256, 216, -200},
    { 1104, 232, -176},
    { 808, 256, -184},
    { 544, 232, -240},
    { 456, 248, -248},
    // 13 seconds
    { 472, 296, -184},
    { 536, 328, -240},
    { 736, 424, -288},
    { 984, 536, -384},
    { 1032, 576, -408},
    { 1264, 600, -288},
    { 1496, 584, -320},
    { 1248, 456, -136},
    { 1064, 400, -160},
    { 1112, 400, -136},
    { 1040, 296, -80},
    { 840, 200, -16},
    { 688, 176, -40},
    { 640, 184, -48},
    { 656, 136, -56},
    { 704, 112, -72},
    { 864, 96, -128},
    { 1000, 64, -120},
    { 1208, 88, -128},
    { 1320, 144, -152},
    { 1280, 192, -200},
    { 1024, 216, -240},
    { 992, 192, -192},
    { 1064, 264, -184},
    { 976, 296, -160},
    // 14 seconds
    { 760, 296, -168},
    { 544, 320, -176},
    { 392, 304, -184},
    { 400, 288, -120},
    { 536, 360, -88},
    { 808, 424, -152},
    { 1032, 456, -160},
    { 1008, 488, -208},
    { 1336, 552, -208},
    { 1304, 552, -232},
    { 1096, 504, -168},
    { 1056, 384, -144},
    { 1144, 408, -120},
    { 1072, 336, -56},
    { 816, 256, -72},
    { 632, 208, -40},
    { 576, 176, -48},
    { 640, 176, -24},
    { 840, 144, -24},
    { 920, 88, 8},
    { 1064, 80, -72},
    { 1184, 64, -80},
    { 1216, 48, -64},
    { 1320, 112, -32},
    { 1168, 112, -72},
    // 15 seconds
    { 1272, 160, -208},
    { 1256, 160, -184},
    { 976, 208, -216},
    { 632, 192, -160},
    { 480, 176, -192},
    { 400, 168, -248},
    { 496, 200, -56},
    { 672, 264, -136},
    { 896, 304, -216},
    { 1152, 432, -272},
    { 1024, 464, -288},
    { 1104, 424, -232},
    { 1296, 456, -232},
    { 1112, 432, -240},
    { 1296, 368, -168},
    { 1416, 352, -136},
    { 1256, 264, -80},
    { 904, 232, -88},
    { 688, 192, -56},
    { 640, 176, -64},
    { 712, 176, 0},
    { 800, 120, 8},
    { 880, 128, 24},
    { 920, 40, 24},
    { 912, -8, 0},
    // 16 seconds
    { 992, 112, -88},
    { 1248, 136, -80},
    { 1304, 192, -16},
    { 1392, 192, -88},
    { 1488, 296, -144},
    { 1328, 288, -200},
    { 904, 280, -216},
    { 536, 200, -232},
    { 416, 200, -184},
    { 424, 208, -168},
    { 536, 120, -160},
    { 752, 184, -184},
    { 1056, 240, -184},
    { 1184, 288, -240},
    { 1160, 320, -224},
    { 1280, 328, -184},
    { 1160, 360, -216},
    { 1064, 312, -176},
    { 1176, 296, -160},
    { 1208, 288, -176},
    { 1080, 240, -104},
    { 840, 168, -32},
    { 688, 152, -80},
    { 656, 160, -72},
    { 680, 160, -48},
    // 17 seconds
    { 752, 112, -8},
    { 968, 136, -32},
    { 1136, 144, -48},
    { 1128, 120, -8},
    { 1216, 152, -16},
    { 1232, 160, 32},
    { 1112, 152, -48},
    { 1256, 192, -40},
    { 1272, 152, -40},
    { 1104, 224, -144},
    { 792, 224, -192},
    { 512, 192, -200},
    { 400, 152, -176},
    { 408, 168, -168},
    { 552, 224, -184},
    { 840, 248, -248},
    { 1176, 304, -344},
    { 1208, 272, -304},
    { 1136, 224, -208},
    { 1336, 288, -208},
    { 1160, 336, -240},
    { 968, 320, -144},
    { 1112, 320, -128},
    { 1192, 312, -112},
    { 1072, 280, -64},
    // 18 seconds
    { 872, 216, -48},
    { 728, 184, -48},
    { 712, 184, -64},
    { 736, 160, -40},
    { 840, 168, -24},
    { 888, 80, 0},
    { 1072, 104, -40},
    { 1112, 128, -88},
    { 1080, 112, -128},
    { 1168, 144, -136},
    { 1136, 112, -112},
    { 1120, 120, -32},
    { 1264, 232, -80},
    { 1248, 264, -160},
    { 960, 272, -160},
    { 648, 232, -216},
    { 480, 176, -168},
    { 456, 192, -88},
    { 568, 192, -88},
    { 776, 232, -152},
    { 1016, 304, -168},
    { 1160, 368, -280},
    { 1112, 352, -264},
    { 1304, 344, -232},
    { 1264, 368, -248},
    // 19 seconds
    { 968, 328, -200},
    { 1048, 304, -184},
    { 1160, 296, -168},
    { 1120, 272, -96},
    { 968, 232, -88},
    { 776, 192, -56},
    { 704, 152, -72},
    { 736, 168, -40},
    { 792, 160, -24},
    { 968, 64, -48},
    { 1120, 48, 32},
    { 1104, 88, 0},
    { 1112, 168, -120},
    { 1096, 192, -104},
    { 1080, 208, -120},
    { 1120, 160, -192},
    { 1280, 192, -88},
    { 1264, 224, -112},
    { 1000, 248, -160},
    { 680, 248, -192},
    { 488, 168, -200},
    { 424, 128, -96},
    { 504, 152, -104},
    { 688, 216, -168},
    { 968, 272, -208},
    // 20 seconds
    { 1168, 344, -280},
    { 1112, 392, -304},
    { 1208, 360, -264},
    { 1280, 392, -248},
    { 1056, 344, -216},
    { 1040, 296, -176},
    { 1144, 296, -184},
    { 1144, 256, -112},
    { 1032, 216, -72},
    { 776, 184, -24},
    { 648, 184, -56},
    { 632, 168, -32},
    { 720, 168, 8},
    { 888, 120, -8},
    { 1088, 120, -32},
    { 1136, 128, -40},
    { 1104, 120, -72},
    { 1192, 128, -128},
    { 1144, 160, -104},
    { 1064, 160, -136},
    { 1144, 168, -136},
    { 1208, 192, -144},
    { 1000, 232, -160},
    { 696, 224, -200},
    { 536, 184, -152},
    // 21 seconds
    { 488, 192, -144},
    { 568, 208, -112},
    { 696, 288, -176},
    { 904, 400, -208},
    { 1096, 408, -256},
    { 1048, 392, -280},
    { 1088, 368, -240},
    { 1296, 416, -240},
    { 1128, 384, -216},
    { 1104, 336, -128},
    { 1176, 328, -104},
    { 1192, 312, -88},
    { 1032, 264, -32},
    { 776, 192, -24},
    { 640, 176, -48},
    { 648, 144, -48},
    { 736, 144, -32},
    { 824, 136, -16},
    { 1000, 128, -56},
    { 1096, 128, -56},
    { 1128, 112, -64},
    { 1200, 144, -64},
    { 1208, 152, -120},
    { 1112, 160, -32},
    { 1200, 208, -88},
    // 22 seconds
    { 1216, 224, -144},
    { 1032, 240, -176},
    { 728, 232, -216},
    { 496, 192, -176},
    { 432, 208, -160},
    { 496, 176, -152},
    { 720, 208, -112},
    { 992, 264, -152},
    { 1184, 304, -248},
    { 1056, 312, -272},
    { 1136, 304, -272},
    { 1320, 360, -248},
    { 1064, 360, -224},
    { 1056, 328, -208},
    { 1160, 360, -200},
    { 1152, 240, -144},
    { 984, 224, -88},
    { 792, 200, -112},
    { 688, 184, -72},
    { 672, 176, -56},
    { 776, 192, -56},
    { 944, 144, -64},
    { 1008, 24, 0},
    { 1112, 0, -32},
    { 1144, 136, -80},
    // 23 seconds
    { 1088, 160, -128},
    { 1168, 112, -88},
    { 1064, 128, -56},
    { 1264, 136, -88},
    { 1336, 208, -104},
    { 1104, 240, -152},
    { 704, 216, -184},
    { 456, 160, -176},
    { 384, 144, -200},
    { 464, 168, -128},
    { 640, 272, -160},
    { 904, 360, -240},
    { 1080, 432, -296},
    { 1144, 448, -304},
    { 1272, 448, -256},
    { 1240, 480, -240},
    { 1152, 440, -176},
    { 1280, 400, -184},
    { 1256, 352, -152},
    { 1112, 288, -88},
    { 856, 200, -104},
    { 672, 192, -112},
    { 640, 112, -72},
    { 632, 136, -80},
    { 752, 128, -8},
    // 24 seconds
    { 872, 0, -48},
    { 992, 0, -136},
    { 1008, 120, -96},
    { 960, 32, -280},
    { 1096, 144, -280},
    { 1016, -16, -288},
    { 1048, 24, -288},
    { 1408, 160, -264},
    { 1400, 152, -272},
    { 1032, 40, -176},
    { 688, 72, -144},
    { 488, 328, -216},
    { 480, 280, -152},
    { 584, 184, -168},
    { 680, 208, -200},
    { 864, 360, -328},
    { 952, 432, -376},
    { 1096, 464, -304},
    { 1304, 512, -256},
    { 1208, 528, -232},
    { 1304, 464, -176},
    { 1296, 368, -96},
    { 1224, 320, -80},
    { 936, 240, -8},
    { 712, 176, -56},
    // 25 seconds
    { 656, 160, -80},
    { 704, 128, -16},
    { 720, 72, 0},
    { 896, 32, 16},
    { 1128, 96, -16},
    { 1168, 64, 32},
    { 1472, 128, 72},
    { 1208, 160, -64},
    { 1104, 136, -152},
    { 1288, 144, -72},
    { 1104, 184, -144},
    { 760, 248, -216},
    { 552, 224, -240},
    { 496, 288, -248},
    { 576, 320, -192},
    { 792, 320, -200},
    { 920, 400, -216},
    { 1056, 440, -240},
    { 1216, 456, -256},
    { 1216, 456, -200},
    { 1208, 488, -264},
    { 1144, 432, -184},
    { 1328, 392, -104},
    { 1328, 320, -56},
    { 1112, 272, -56},
    // 26 seconds
    { 896, 216, -48},
    { 752, 152, -48},
    { 688, 112, -80},
    { 680, 128, 16},
    { 800, 144, -24},
    { 992, 80, -48},
    { 1128, 120, -40},
    { 1008, 184, -16},
    { 1064, 144, -176},
    { 1312, 224, -40},
    { 1200, 152, -72},
    { 1384, 224, -208},
    { 1416, 224, -184},
    { 984, 296, -256},
    { 472, 104, -304},
    { 376, 136, -312},
    { 456, 168, -216},
    { 672, 216, -144},
    { 920, 272, -160},
    { 1344, 360, -256},
    { 1288, 392, -184},
    { 1296, 400, -168},
    { 1224, 416, -184},
    { 1152, 432, -168},
    { 1072, 376, -120},
    // 27 seconds
    { 1136, 336, -136},
    { 1080, 288, -96},
    { 912, 224, -88},
    { 712, 192, -96},
    { 656, 136, -72},
    { 696, 152, -64},
    { 872, 112, -40},
    { 1088, 64, -24},
    { 1208, 56, -32},
    { 1288, 88, -96},
    { 1248, 136, -48},
    { 1176, 160, -16},
    { 1136, 160, -88},
    { 1216, 160, -56},
    { 1224, 160, -32},
    { 1040, 192, -120},
    { 736, 200, -184},
    { 488, 192, -184},
    { 392, 184, -208},
    { 416, 160, -128},
    { 632, 216, -144},
    { 1008, 304, -176},
    { 1344, 416, -264},
    { 1192, 424, -280},
    { 1264, 360, -216},
    // 28 seconds
    { 1232, 400, -216},
    { 1120, 392, -168},
    { 1016, 376, -144},
    { 1104, 376, -144},
    { 1032, 296, -96},
    { 904, 248, -64},
    { 760, 208, -80},
    { 688, 176, -48},
    { 728, 200, -64},
    { 888, 136, -24},
    { 1008, 48, 8},
    { 1120, 120, -88},
    { 1176, 88, -152},
    { 1144, 32, -104},
    { 1280, 56, -24},
    { 1136, 112, 0},
    { 1152, 112, -32},
    { 1288, 216, -32},
    { 1184, 240, -144},
    { 880, 208, -160},
    { 560, 176, -160},
    { 424, 176, -184},
    { 408, 192, -176},
    { 536, 208, -144},
    { 800, 208, -152},
    // 29 seconds
    { 1160, 248, -168},
    { 1176, 320, -288},
    { 1176, 360, -256},
    { 1272, 400, -216},
    { 1120, 432, -240},
    { 1072, 376, -184},
    { 1192, 320, -136},
    { 1216, 304, -136},
    { 1112, 256, -80},
    { 904, 216, -56},
    { 760, 184, -48},
    { 704, 184, -40},
    { 744, 160, -16},
    { 800, 136, 0},
    { 856, 88, 8},
    { 1032, 88, -56},
    { 1072, 120, -88},
    { 1064, 80, -96},
    { 1240, 144, -96},
    { 1064, 120, -48},
    { 1168, 152, -88},
    { 1336, 272, -88},
    { 1240, 280, -152},
    { 952, 264, -192},
    { 640, 224, -208},
    // 30 seconds
    { 488, 208, -160},
    { 456, 200, -144},
    { 536, 248, -112},
    { 712, 312, -136},
    { 1016, 400, -224},
    { 1064, 440, -240},
    { 1072, 424, -200},
    { 1288, 448, -200},
    { 1304, 488, -208},
    { 1056, 384, -128},
    { 1120, 344, -136},
    { 1168, 328, -136},
    { 1128, 280, -64},
    { 912, 200, -8},
    { 720, 168, -40},
    { 680, 152, -32},
    { 712, 144, -24},
    { 760, 144, 0},
    { 808, 104, 0},
    { 1016, 160, -80},
    { 1104, 144, -80},
    { 1144, 104, -144},
    { 1200, 136, -104},
    { 1144, 144, -104},
    { 1152, 168, -176},
    // 31 seconds
    { 1288, 216, -128},
    { 1152, 200, -128},
    { 928, 224, -128},
    { 648, 200, -160},
    { 504, 208, -160},
    { 472, 224, -120},
    { 584, 224, -112},
    { 752, 240, -176},
    { 968, 288, -264},
    { 1032, 320, -312},
    { 1096, 336, -288},
    { 1256, 360, -240},
    { 1216, 392, -272},
    { 1136, 400, -224},
    { 1280, 368, -144},
    { 1328, 328, -96},
    { 1208, 280, -64},
    { 944, 224, -56},
    { 752, 184, -48},
    { 704, 136, -104},
    { 688, 128, -24},
    { 760, 136, -16},
    { 808, 136, -24},
    { 840, 96, -56},
    { 928, 104, -48},
    // 32 seconds
    { 984, 104, -72},
    { 1160, 88, -160},
    { 1416, 168, -32},
    { 1240, 168, -112},
    { 1304, 184, -200},
    { 1320, 256, -216},
    { 1096, 240, -200},
    { 768, 200, -240},
    { 576, 136, -224},
    { 512, 168, -128},
    { 568, 224, -120},
    { 688, 256, -128},
    { 792, 288, -200},
    { 920, 336, -216},
    { 936, 400, -224},
    { 1024, 416, -192},
    { 1312, 456, -192},
    { 1304, 480, -184},
    { 1360, 376, -72},
    { 1464, 336, -64},
    { 1320, 272, -48},
    { 1008, 232, -48},
    { 840, 96, -40},
    { 664, -40, 56},
    { 592, 32, 40},
    // 33 seconds
    { 728, 24, -16},
    { 728, 8, -8},
    { 888, 48, -24},
    { 1136, 72, -88},
    { 1080, 24, -112},
    { 1544, 56, -184},
    { 1544, 88, 24},
    { 1528, 168, -168},
    { 1536, 232, -264},
    { 1176, 224, -168},
    { 712, 176, -128},
    { 536, 144, -144},
    { 496, 184, -144},
    { 584, 264, -168},
    { 680, 312, -184},
    { 880, 392, -184},
    { 1272, 472, -256},
    { 1192, 464, -200},
    { 1296, 440, -160},
    { 1072, 440, -232},
    { 1096, 368, -104},
    { 1200, 328, -56},
    { 1168, 288, -32},
    { 1040, 280, -48},
    { 888, 224, -40},
    // 34 seconds
    { 808, 160, -40},
    { 760, 136, -24},
    { 832, 120, 0},
    { 1088, 72, -24},
    { 1176, 40, 8},
    { 1136, 96, -64},
    { 1160, 160, -48},
    { 1256, 120, -40},
    { 1184, 184, -16},
    { 1152, 216, -64},
    { 1224, 200, -16},
    { 1160, 216, -16},
    { 960, 240, -64},
    { 664, 216, -128},
    { 480, 152, -88},
    { 440, 176, -112},
    { 560, 208, -152},
    { 800, 208, -104},
    { 1104, 256, -152},
    { 1264, 328, -224},
    { 1232, 352, -264},
    { 1216, 376, -240},
    { 1080, 392, -256},
    { 1000, 416, -264},
    { 1048, 400, -224},
    // 35 seconds
    { 1128, 304, -152},
    { 1128, 256, -80},
    { 984, 216, -48},
    { 864, 192, -56},
    { 784, 192, -56},
    { 824, 192, -80},
    { 936, 120, -8},
    { 944, 80, 56},
    { 992, 40, -16},
    { 1064, 80, -80},
    { 1040, 56, -56},
    { 1184, 16, -32},
    { 1248, 104, 16},
    { 1184, 152, -16},
    { 1280, 184, -16},
    { 1264, 192, -8},
    { 1048, 240, -104},
    { 752, 248, -160},
    { 552, 232, -192},
    { 480, 184, -136},
    { 568, 152, -80},
    { 744, 184, -168},
    { 984, 248, -184},
    { 1152, 296, -328},
    { 1064, 312, -296},
    // 36 seconds
    { 1264, 328, -296},
    { 1360, 384, -360},
    { 1128, 328, -232},
    { 1112, 336, -160},
    { 1184, 344, -144},
    { 1192, 296, -64},
    { 1016, 224, -40},
    { 832, 184, -8},
    { 776, 200, -8},
    { 760, 176, 32},
    { 776, 144, 88},
    { 816, 88, 56},
    { 968, 168, -40},
    { 1120, 144, -96},
    { 1112, 48, -80},
    { 1208, 64, -96},
    { 1232, 72, -48},
    { 1088, 120, -112},
    { 1224, 184, -128},
    { 1248, 216, -80},
    { 1040, 240, -96},
    { 744, 240, -168},
    { 576, 224, -152},
    { 528, 200, -80},
    { 624, 200, -80},
    // 37 seconds
    { 768, 280, -168},
    { 984, 312, -224},
    { 1096, 360, -304},
    { 1032, 336, -272},
    { 1232, 344, -208},
    { 1480, 424, -240},
    { 1088, 328, -160},
    { 1088, 296, -152},
    { 1160, 296, -168},
    { 1128, 264, -120},
    { 976, 200, -64},
    { 856, 176, -24},
    { 776, 208, -56},
    { 776, 152, -16},
    { 800, 160, 8},
    { 800, 112, 8},
    { 968, 112, -16},
    { 1032, 152, -80},
    { 1040, 96, -120},
    { 1176, 112, -152},
    { 1200, 128, -56},
    { 1096, 144, -104},
    { 1224, 200, -120},
    { 1264, 224, -104},
    { 1104, 248, -144},
    // 38 seconds
    { 800, 264, -168},
    { 608, 216, -152},
    { 552, 200, -120},
    { 584, 176, -128},
    { 696, 248, -176},
    { 840, 264, -232},
    { 1056, 304, -272},
    { 1104, 352, -288},
    { 1136, 352, -248},
    { 1288, 392, -208},
    { 1096, 392, -200},
    { 1160, 344, -128},
    { 1248, 328, -104},
    { 1208, 296, -64},
    { 1024, 248, -32},
    { 848, 200, -48},
    { 744, 168, -32},
    { 752, 152, -48},
    { 864, 144, -64},
    { 952, 88, 16},
    { 1024, 96, 32},
    { 1008, 96, -32},
    { 960, 104, -88},
    { 1088, 136, -136},
    { 1152, 152, -240},
    // 39 seconds
    { 1128, 152, -16},
    { 1256, 152, 8},
    { 1336, 208, -120},
    { 1192, 304, -200},
    { 824, 312, -232},
    { 560, 264, -216},
    { 472, 240, -128},
    { 528, 192, -96},
    { 696, 256, -112},
    { 960, 296, -176},
    { 1224, 368, -248},
    { 1024, 376, -272},
    { 1048, 368, -240},
    { 1328, 392, -232},
    { 1184, 336, -168},
    { 1144, 304, -128},
    { 1184, 304, -136},
    { 1192, 280, -96},
    { 1008, 256, -40},
    { 784, 200, -48},
    { 696, 192, -64},
    { 704, 168, -48},
    { 816, 160, 0},
    { 872, 152, 0},
    { 1000, 112, -8},
    // 40 seconds
    { 1160, 104, -56},
    { 1096, 96, -32},
    { 1216, 80, -64},
    { 1232, 152, -64},
    { 1160, 184, -96},
    { 1256, 144, -112},
    { 1216, 184, -112},
    { 1016, 224, -144},
    { 704, 224, -200},
    { 520, 200, -160},
    { 488, 160, -128},
    { 560, 192, -80},
    { 704, 240, -88},
    { 952, 288, -120},
    { 1280, 392, -288},
    { 1136, 328, -224},
    { 1144, 272, -240},
    { 1320, 376, -328},
    { 1080, 344, -288},
    { 1040, 312, -216},
    { 1120, 280, -200},
    { 1152, 264, -152},
    { 1040, 224, -72},
    { 840, 184, -48},
    { 720, 184, -24},
    // 41 seconds
    { 704, 208, -24},
    { 800, 176, -16},
    { 888, 152, 24},
    { 1128, 144, -8},
    { 1168, 136, -8},
    { 1056, 80, -8},
    { 1176, 88, -72},
    { 1152, 88, -128},
    { 1064, 56, -24},
    { 1192, 128, -24},
    { 1224, 224, -72},
    { 1056, 264, -144},
    { 784, 264, -192},
    { 560, 224, -160},
    { 504, 192, -152},
    { 600, 192, -112},
    { 800, 240, -152},
    { 1024, 264, -200},
    { 1224, 328, -288},
    { 1072, 336, -312},
    { 1096, 328, -264},
    { 1248, 376, -248},
    { 1104, 376, -240},
    { 1104, 344, -176},
    { 1192, 312, -128},
    // 42 seconds
    { 1232, 256, -96},
    { 1112, 240, -48},
    { 912, 208, -16},
    { 760, 184, -24},
    { 752, 184, -40},
    { 896, 192, -40},
    { 928, 120, 24},
    { 968, 40, 24},
    { 968, 48, 48},
    { 968, 128, 16},
    { 1064, 152, -48},
    { 1088, 176, -56},
    { 1104, 168, -80},
    { 1216, 128, -56},
    { 1328, 176, -80},
    { 1264, 232, -184},
    { 944, 256, -224},
    { 648, 200, -208},
    { 520, 200, -192},
    { 520, 168, -184},
    { 656, 232, -128},
    { 864, 248, -224},
    { 1160, 296, -240},
    { 1144, 328, -304},
    { 1040, 336, -296},
    // 43 seconds
    { 1216, 352, -256},
    { 1184, 336, -216},
    { 1112, 280, -152},
    { 1160, 256, -128},
    { 1272, 248, -88},
    { 1208, 288, -72},
    { 976, 264, -48},
    { 768, 208, -72},
    { 712, 176, -56},
    { 728, 184, 40},
    { 824, 136, 136},
    { 920, 112, 128},
    { 1104, 168, 72},
    { 1024, 72, -8},
    { 1072, 64, -48},
    { 1184, 112, -64},
    { 1088, 104, -104},
    { 1112, 152, -184},
    { 1296, 232, -200},
    { 1240, 256, -200},
    { 968, 240, -200},
    { 664, 192, -176},
    { 552, 176, -160},
    { 544, 216, -168},
    { 640, 248, -152},
    // 44 seconds
    { 784, 272, -184},
    { 1072, 320, -240},
    { 1072, 360, -288},
    { 1040, 368, -280},
    { 1296, 392, -256},
    { 1200, 384, -232},
    { 1048, 304, -152},
    { 1128, 312, -224},
    { 1208, 320, -168},
    { 1112, 256, -80},
    { 944, 200, -16},
    { 800, 184, -56},
    { 744, 192, -40},
    { 768, 184, -32},
    { 808, 136, -8},
    { 936, 88, 0},
    { 1056, 96, -16},
    { 1032, 120, -56},
    { 1088, 152, -104},
    { 1136, 160, -96},
    { 1128, 168, -104},
    { 1184, 192, -88},
    { 1320, 192, -64},
    { 1280, 232, -136},
    { 1016, 280, -176},
    // 45 seconds
    { 712, 248, -192},
    { 544, 224, -168},
    { 528, 184, -88},
    { 576, 232, -112},
    { 744, 280, -168},
    { 992, 288, -192},
    { 1128, 320, -272},
    { 1048, 320, -296},
    { 1160, 336, -224},
    { 1272, 352, -224},
    { 1072, 336, -168},
    { 1048, 328, -136},
    { 1152, 336, -136},
    { 1176, 296, -96},
    { 1024, 256, -64},
    { 856, 192, -64},
    { 736, 160, -64},
    { 744, 160, -32},
    { 800, 160, -40},
    { 872, 136, -40},
    { 1008, 48, -8},
    { 1136, 16, 0},
    { 1112, 48, -24},
    { 1288, 112, -8},
    { 1280, 160, 56},
    // 46 seconds
    { 1152, 152, -32},
    { 1272, 144, -48},
    { 1248, 168, -48},
    { 1008, 248, -136},
    { 720, 256, -160},
    { 560, 216, -144},
    { 496, 208, -144},
    { 576, 232, -136},
    { 776, 264, -216},
    { 992, 304, -256},
    { 1128, 312, -288},
    { 1120, 328, -256},
    { 1216, 336, -216},
    { 1256, 344, -232},
    { 1064, 328, -168},
    { 1064, 312, -160},
    { 1144, 296, -128},
    { 1152, 288, -112},
    { 1024, 240, -80},
    { 856, 184, -56},
    { 744, 144, -80},
    { 744, 136, -56},
    { 800, 152, -16},
    { 872, 136, -56},
    { 1024, 64, -8},
    // 47 seconds
    { 1088, 88, -64},
    { 1056, 96, -112},
    { 1200, 120, -120},
    { 1176, 136, -104},
    { 1096, 112, -112},
    { 1240, 120, -56},
    { 1232, 176, -80},
    { 1032, 192, -152},
    { 760, 192, -152},
    { 576, 152, -168},
    { 520, 160, -128},
    { 584, 176, -88},
    { 736, 240, -160},
    { 912, 328, -208},
    { 1136, 464, -280},
    { 1112, 536, -264},
    { 1160, 520, -200},
    { 1288, 536, -192},
    { 1120, 456, -152},
    { 1104, 376, -112},
    { 1144, 352, -104},
    { 1168, 304, -80},
    { 1056, 248, -40},
    { 888, 208, -32},
    { 760, 168, -8},
    // 48 seconds
    { 736, 160, -32},
    { 768, 152, -8},
    { 784, 136, -16},
    { 904, 136, -32},
    { 1104, 176, -80},
    { 1056, 96, -96},
    { 1080, 88, -120},
    { 1144, 104, -96},
    { 1032, 152, -112},
    { 1128, 192, -128},
    { 1288, 264, -104},
    { 1240, 192, -168},
    { 944, 256, -168},
    { 672, 208, -168},
    { 552, 168, -160},
    { 520, 232, -112},
    { 600, 224, -88},
    { 768, 256, -152},
    { 1120, 320, -224},
    { 1192, 344, -328},
    { 1088, 320, -280},
    { 1256, 328, -248},
    { 1216, 360, -232},
    { 1040, 320, -152},
    { 1104, 296, -136},
    // 49 seconds
    { 1184, 296, -136},
    { 1136, 216, -104},
    { 928, 216, -16},
    { 752, 216, -48},
    { 720, 168, -40},
    { 784, 152, -8},
    { 816, 136, 0},
    { 888, 80, -16},
    { 1096, 56, -56},
    { 1096, 24, -32},
    { 1192, 56, -112},
    { 1232, 120, -56},
    { 1088, 88, -104},
    { 1232, 128, -112},
    { 1288, 152, -64},
    { 1120, 176, -128},
    { 824, 184, -176},
    { 560, 184, -216},
    { 456, 152, -160},
    { 504, 144, -136},
    { 720, 192, -176},
    { 896, 240, -248},
    { 1144, 288, -320},
    { 1112, 272, -344},
    { 1128, 256, -264},
    // 50 seconds
    { 1320, 312, -256},
    { 1144, 344, -240},
    { 1080, 336, -168},
    { 1128, 344, -152},
    { 1168, 320, -136},
    { 1112, 248, -64},
    { 872, 192, -40},
    { 712, 184, -48},
    { 712, 176, -80},
    { 808, 168, -48},
    { 880, 96, 0},
    { 928, 32, 32},
    { 1072, 64, -16},
    { 1072, 120, -32},
    { 1168, 128, -64},
    { 1248, 128, -24},
    { 1112, 112, -80},
    { 1160, 112, -112},
    { 1256, 136, -88},
    { 1168, 200, -160},
    { 872, 232, -168},
    { 584, 208, -208},
    { 480, 152, -232},
    { 480, 120, -104},
    { 648, 160, -128},
    // 51 seconds
    { 784, 224, -216},
    { 1048, 264, -224},
    { 1144, 296, -288},
    { 1144, 328, -264},
    { 1232, 328, -232},
    { 1104, 368, -256},
    { 1000, 336, -208},
    { 1160, 320, -152},
    { 1232, 288, -144},
    { 1192, 256, -88},
    { 968, 224, -56},
    { 760, 184, -48},
    { 680, 144, -40},
    { 720, 168, -56},
    { 832, 136, -32},
    { 920, 88, -16},
    { 1096, 88, -32},
    { 1080, 56, -32},
    { 1040, 32, -24},
    { 1208, 136, -16},
    { 1152, 152, 16},
    { 1152, 192, -80},
    { 1272, 184, -72},
    { 1280, 208, -96},
    { 1032, 256, -160},
    // 52 seconds
    { 696, 240, -176},
    { 512, 176, -144},
    { 472, 160, -120},
    { 584, 192, -144},
    { 760, 216, -184},
    { 1000, 264, -216},
    { 1136, 296, -288},
    { 1120, 304, -280},
    { 1240, 320, -240},
    { 1176, 320, -264},
    { 1024, 312, -208},
    { 1200, 296, -128},
    { 1280, 296, -112},
    { 1184, 272, -64},
    { 928, 240, -64},
    { 728, 208, -56},
    { 672, 192, -32},
    { 704, 168, -24},
    { 864, 176, -32},
    { 968, 56, 48},
    { 1112, -16, 56},
    { 1216, 72, -40},
    { 1240, 96, -56},
    { 1384, 40, 56},
    { 1184, 80, -40},
    // 53 seconds
    { 1248, 96, -80},
    { 1248, 128, -56},
    { 1088, 184, -104},
    { 776, 200, -160},
    { 536, 208, -192},
    { 448, 216, -160},
    { 504, 200, -120},
    { 656, 232, -168},
    { 960, 272, -232},
    { 1280, 344, -352},
    { 1144, 360, -296},
    { 1192, 312, -256},
    { 1272, 312, -240},
    { 1064, 384, -240},
    { 1128, 336, -152},
    { 1184, 304, -136},
    { 1192, 264, -88},
    { 1072, 240, -88},
    { 880, 192, -80},
    { 784, 184, -64},
    { 776, 144, -32},
    { 832, 184, -40},
    { 896, 96, -24},
    { 1040, 24, -24},
    { 1048, 64, -80},
    // 54 seconds
    { 992, 64, -112},
    { 1112, 104, -160},
    { 1088, 96, -208},
    { 1032, 120, -192},
    { 1160, 104, -216},
    { 1288, 88, -168},
    { 1232, 176, -160},
    { 960, 224, -248},
    { 672, 120, -192},
    { 536, 136, -184},
    { 496, 200, -168},
    { 576, 192, -168},
    { 760, 216, -256},
    { 1120, 272, -328},
    { 1168, 320, -360},
    { 1112, 320, -304},
    { 1272, 320, -272},
    { 1120, 416, -280},
    { 1112, 296, -216},
    { 1200, 288, -136},
    { 1232, 272, -152},
    { 1136, 224, -112},
    { 880, 176, -80},
    { 688, 152, -88},
    { 632, 176, -80},
    // 55 seconds
    { 696, 136, -48},
    { 824, 88, -32},
    { 1080, 32, -8},
    { 1136, 8, 8},
    { 1168, 40, -32},
    { 1248, 80, -56},
    { 1312, 40, -48},
    { 1136, 72, -16},
    { 1216, 120, -96},
    { 1296, 144, -88},
    { 1120, 224, -120},
    { 776, 232, -192},
    { 520, 184, -200},
    { 424, 120, -152},
    { 456, 152, -96},
    { 648, 192, -152},
    { 888, 240, -200},
    { 1184, 360, -288},
    { 1152, 360, -288},
    { 1104, 360, -280},
    { 1288, 384, -224},
    { 1176, 384, -224},
    { 1136, 312, -136},
    { 1224, 304, -80},
    { 1224, 280, -64},
    // 56 seconds
    { 1072, 224, -16},
    { 824, 176, 16},
    { 648, 160, -32},
    { 600, 160, 0},
    { 680, 120, 40},
    { 888, 80, 64},
    { 1096, 48, 168},
    { 1176, 24, 16},
    { 1152, 0, -152},
    { 1248, 48, -80},
    { 1288, 16, -16},
    { 1136, 24, -16},
    { 1320, 104, -24},
    { 1296, 136, -96},
    { 1032, 240, -184},
    { 656, 264, -232},
    { 456, 200, -160},
    { 400, 160, -88},
    { 504, 168, -104},
    { 672, 192, -192},
    { 952, 224, -184},
    { 1224, 288, -248},
    { 1152, 312, -288},
    { 1144, 304, -248},
    { 1224, 336, -208},
    // 57 seconds
    { 1048, 344, -232},
    { 1120, 296, -136},
    { 1232, 296, -48},
    { 1296, 264, 16},
    { 1064, 216, 32},
    { 768, 176, -32},
    { 632, 160, -32},
    { 592, 160, 8},
    { 696, 120, 64},
    { 872, 112, 56},
    { 1016, 104, 0},
    { 1120, 136, -40},
    { 1136, 112, -56},
    { 1288, 120, -40},
    { 1256, 112, 0},
    { 1080, 152, -48},
    { 1144, 136, -56},
    { 1240, 168, -48},
    { 1072, 224, -120},
    { 728, 224, -160},
    { 472, 184, -176},
    { 392, 136, -136},
    { 432, 144, -80},
    { 696, 192, -136},
    { 968, 240, -224},
    // 58 seconds
    { 1200, 280, -312},
    { 1136, 368, -392},
    { 1240, 384, -336},
    { 1344, 408, -280},
    { 1120, 368, -184},
    { 1208, 264, -104},
    { 1248, 256, -64},
    { 1184, 264, -32},
    { 960, 208, -8},
    { 712, 168, -48},
    { 608, 152, -64},
    { 624, 136, -8},
    { 728, 112, 8},
    { 872, 88, 0},
    { 1040, 120, -40},
    { 1120, 128, -48},
    { 1128, 80, -80},
    { 1192, 112, -104},
    { 1112, 128, -104},
    { 1072, 152, -160},
    { 1240, 136, -96},
    { 1240, 176, -128},
    { 1064, 216, -184},
    { 736, 208, -216},
    { 520, 160, -200},
    // 59 seconds
    { 424, 136, -168},
    { 504, 176, -80},
    { 728, 232, -168},
    { 1016, 264, -200},
    { 1176, 344, -288},
    { 1064, 336, -280},
    { 1296, 360, -256},
    { 1496, 456, -272},
    { 1184, 344, -120},
    { 952, 256, -112},
    { 1152, 280, -64},
    { 1080, 248, 8},
    { 912, 208, 24},
    { 776, 144, -24},
    { 760, 120, 16},
    { 728, 152, 56},
    { 712, 152, 24},
    { 808, 248, 8},
    { 904, 240, -16},
    { 984, 248, -32},
    { 1080, 232, -48},
    { 1208, 232, -104},
    { 1144, 224, -48},
    { 1032, 184, -48},
    { 1112, 192, -112},
    // 60 seconds
    // elapsed: 1 minutes
    { 1216, 192, -80},
    { 1192, 216, -120},
    { 1016, 240, -208},
    { 752, 248, -200},
    { 568, 224, -152},
    { 488, 192, -136},
    { 512, 200, -136},
    { 696, 232, -120},
    { 1032, 280, -208},
    { 1096, 280, -240},
    { 1064, 280, -280},
    { 1112, 272, -248},
    { 1312, 328, -216},
    { 1208, 304, -224},
    { 1088, 256, -200},
    { 1176, 248, -136},
    { 1208, 256, -104},
    { 1048, 208, -48},
    { 840, 160, -64},
    { 736, 160, -96},
    { 704, 160, -32},
    { 800, 168, -24},
    { 856, 120, -8},
    { 960, 88, -32},
    { 1032, 72, -40},
    // 61 seconds
    { 1048, 72, -88},
    { 1136, 96, -144},
    { 1112, 120, -16},
    { 976, 144, -24},
    { 1224, 184, -72},
    { 1376, 240, -88},
    { 1216, 288, -168},
    { 872, 288, -192},
    { 616, 200, -152},
    { 520, 176, -136},
    { 544, 184, -72},
    { 696, 208, -88},
    { 864, 216, -176},
    { 1040, 288, -256},
    { 1136, 328, -280},
    { 1176, 328, -256},
    { 1240, 336, -240},
    { 1088, 344, -248},
    { 1056, 344, -168},
    { 1192, 344, -176},
    { 1224, 280, -144},
    { 1128, 232, -96},
    { 936, 200, -96},
    { 800, 160, -64},
    { 736, 160, -56},
    // 62 seconds
    { 752, 136, -40},
    { 840, 120, -8},
    { 888, 88, -32},
    { 1056, 176, -120},
    { 1040, 160, -168},
    { 1032, 104, -200},
    { 1144, 96, -136},
    { 1072, 96, -64},
    { 1136, 80, -112},
    { 1328, 192, -88},
    { 1256, 208, -176},
    { 952, 224, -240},
    { 616, 192, -136},
    { 512, 200, -112},
    { 496, 232, -152},
    { 600, 216, -88},
    { 752, 216, -120},
    { 1088, 256, -184},
    { 1184, 288, -256},
    { 1080, 320, -280},
    { 1200, 328, -248},
    { 1216, 360, -248},
    { 1048, 344, -224},
    { 1144, 288, -144},
    { 1248, 272, -120},
    // 63 seconds
    { 1184, 256, -48},
    { 984, 224, -40},
    { 792, 168, -56},
    { 704, 160, -72},
    { 696, 152, -40},
    { 752, 128, 0},
    { 840, 128, 0},
    { 1000, 112, -32},
    { 1136, 120, -72},
    { 1048, 88, -56},
    { 1152, 96, -104},
    { 1144, 160, -48},
    { 1096, 136, -64},
    { 1296, 168, -96},
    { 1360, 208, -104},
    { 1112, 240, -144},
    { 776, 208, -152},
    { 560, 168, -152},
    { 480, 168, -128},
    { 544, 176, -88},
    { 696, 200, -144},
    { 904, 248, -216},
    { 1136, 280, -304},
    { 1112, 288, -360},
    { 1144, 264, -288},
    // 64 seconds
    { 1328, 320, -304},
    { 1056, 288, -232},
    { 1104, 320, -208},
    { 1184, 320, -208},
    { 1264, 312, -144},
    { 1184, 256, -64},
    { 960, 216, -16},
    { 792, 176, -24},
    { 736, 184, -48},
    { 784, 144, -8},
    { 808, 104, 24},
    { 904, 48, 24},
    { 1008, 96, -48},
    { 1008, 88, -64},
    { 1072, 56, -80},
    { 1144, 104, -64},
    { 1048, 104, -24},
    { 1192, 152, -80},
    { 1368, 192, -120},
    { 1240, 216, -120},
    { 968, 224, -152},
    { 696, 216, -160},
    { 600, 216, -176},
    { 592, 216, -136},
    { 696, 216, -88},
    // 65 seconds
    { 856, 256, -224},
    { 1072, 312, -288},
    { 1112, 352, -328},
    { 1096, 352, -304},
    { 1272, 376, -272},
    { 1096, 360, -264},
    { 1088, 280, -144},
    { 1208, 296, -120},
    { 1336, 280, -136},
    { 1256, 272, -72},
    { 1032, 216, -24},
    { 824, 176, -56},
    { 728, 184, -16},
    { 760, 152, 16},
    { 792, 128, 16},
    { 864, 128, 32},
    { 1072, 152, 32},
    { 1048, 160, 24},
    { 1048, 160, -40},
    { 1128, 152, -136},
    { 1096, 144, -88},
    { 1104, 112, -80},
    { 1216, 160, -96},
    { 1264, 216, -136},
    { 1112, 272, -256},
    // 66 seconds
    { 816, 200, -312},
    { 624, 136, -240},
    { 568, 128, -144},
    { 624, 200, -72},
    { 800, 304, -120},
    { 960, 352, -152},
    { 1168, 376, -176},
    { 1088, 392, -216},
    { 1096, 368, -184},
    { 1280, 384, -168},
    { 1080, 392, -176},
    { 1056, 312, -144},
    { 1176, 288, -136},
    { 1272, 304, -96},
    { 1184, 224, -56},
    { 960, 160, -56},
    { 824, 144, -88},
    { 760, 152, -48},
    { 768, 136, -8},
    { 832, 128, -8},
    { 824, 104, 16},
    { 952, 128, -16},
    { 1040, 184, -88},
    { 1008, 144, -120},
    { 1152, 160, -120},
    // 67 seconds
    { 1168, 152, -80},
    { 1080, 136, -120},
    { 1232, 128, -96},
    { 1272, 192, -88},
    { 1096, 256, -168},
    { 800, 256, -192},
    { 608, 208, -160},
    { 552, 168, -136},
    { 608, 200, -104},
    { 736, 224, -176},
    { 928, 264, -224},
    { 1176, 304, -304},
    { 1072, 296, -320},
    { 1136, 280, -280},
    { 1312, 328, -248},
    { 1136, 328, -256},
    { 1048, 280, -160},
    { 1144, 272, -128},
    { 1240, 264, -80},
    { 1144, 232, -64},
    { 976, 176, -48},
    { 832, 152, -56},
    { 760, 176, -40},
    { 776, 144, -48},
    { 776, 136, -40},
    // 68 seconds
    { 840, 80, 8},
    { 1016, 112, -40},
    { 1016, 104, -72},
    { 992, 104, -128},
    { 1104, 136, -128},
    { 1128, 144, -152},
    { 1040, 104, -120},
    { 1176, 160, -72},
    { 1320, 208, -128},
    { 1184, 280, -192},
    { 896, 256, -184},
    { 672, 224, -176},
    { 592, 208, -168},
    { 632, 232, -112},
    { 752, 248, -152},
    { 888, 264, -224},
    { 1088, 320, -312},
    { 1048, 296, -360},
    { 1024, 272, -272},
    { 1296, 280, -216},
    { 1248, 296, -200},
    { 1072, 288, -144},
    { 1080, 296, -120},
    { 1136, 280, -88},
    { 1080, 248, -56},
    // 69 seconds
    { 912, 192, -16},
    { 800, 160, -48},
    { 760, 176, -56},
    { 776, 168, -48},
    { 800, 128, -24},
    { 824, 88, -72},
    { 984, 72, -32},
    { 1088, 96, -96},
    { 1080, 72, -160},
    { 1256, 96, -120},
    { 1224, 104, -112},
    { 1008, 136, -144},
    { 1192, 136, -104},
    { 1248, 208, -120},
    { 1072, 224, -160},
    { 784, 160, -192},
    { 608, 184, -184},
    { 528, 176, -152},
    { 568, 176, -104},
    { 656, 208, -192},
    { 832, 248, -248},
    { 1144, 304, -360},
    { 1088, 304, -352},
    { 1104, 264, -224},
    { 1352, 328, -216},
    // 70 seconds
    { 1200, 360, -216},
    { 1104, 280, -120},
    { 1056, 264, -112},
    { 1136, 264, -128},
    { 1056, 232, -88},
    { 840, 192, -32},
    { 704, 144, -48},
    { 704, 160, -64},
    { 760, 152, -48},
    { 840, 120, 0},
    { 992, 128, -48},
    { 1096, 96, -16},
    { 1136, 112, -64},
    { 1080, 56, -160},
    { 1112, 96, -96},
    { 1136, 120, 16},
    { 1136, 160, -128},
    { 1208, 208, -152},
    { 1168, 216, -184},
    { 944, 208, -208},
    { 664, 184, -168},
    { 544, 152, -176},
    { 560, 144, -128},
    { 680, 200, -152},
    { 792, 224, -224},
    // 71 seconds
    { 976, 240, -232},
    { 1128, 264, -296},
    { 1056, 288, -336},
    { 1264, 280, -256},
    { 1368, 320, -280},
    { 976, 240, -152},
    { 1064, 248, -136},
    { 1176, 256, -136},
    { 1176, 272, -80},
    { 968, 224, 0},
    { 768, 200, -64},
    { 672, 160, -48},
    { 648, 168, -16},
    { 728, 152, 8},
    { 888, 144, -24},
    { 1024, 112, 8},
    { 1072, 112, -16},
    { 1048, 120, -48},
    { 1176, 152, -112},
    { 1200, 160, -112},
    { 1168, 128, -80},
    { 1200, 160, -112},
    { 1232, 208, -136},
    { 1080, 224, -208},
    { 792, 216, -200},
    // 72 seconds
    { 536, 184, -200},
    { 456, 152, -184},
    { 512, 144, -184},
    { 680, 152, -168},
    { 856, 208, -216},
    { 1120, 240, -264},
    { 1144, 272, -328},
    { 1056, 256, -296},
    { 1232, 272, -216},
    { 1176, 296, -240},
    { 1008, 264, -168},
    { 1072, 256, -128},
    { 1184, 272, -128},
    { 1160, 248, -64},
    { 944, 192, -32},
    { 720, 160, -64},
    { 616, 152, -72},
    { 616, 112, -104},
    { 728, 128, -24},
    { 920, 104, 0},
    { 1136, 112, -32},
    { 1144, 152, -72},
    { 1072, 176, -104},
    { 1176, 168, -96},
    { 1136, 160, -72},
    // 73 seconds
    { 1128, 120, -120},
    { 1184, 232, -104},
    { 1136, 200, -128},
    { 944, 120, -176},
    { 672, 128, -184},
    { 520, 120, -208},
    { 488, 112, -120},
    { 584, 144, -128},
    { 776, 184, -168},
    { 968, 224, -216},
    { 1120, 272, -264},
    { 1080, 288, -344},
    { 1192, 264, -264},
    { 1336, 280, -264},
    { 1064, 288, -240},
    { 944, 240, -136},
    { 1032, 264, -136},
    { 1112, 296, -144},
    { 1096, 264, -112},
    { 896, 192, -48},
    { 720, 144, -40},
    { 664, 144, -56},
    { 688, 152, -48},
    { 792, 200, -88},
    { 960, 160, -16},
    // 74 seconds
    { 1080, -32, 48},
    { 1072, 8, -48},
    { 1184, 32, -96},
    { 1240, 112, -56},
    { 1184, 120, -32},
    { 1176, 72, -40},
    { 1248, 144, -8},
    { 1184, 216, -144},
    { 912, 216, -224},
    { 608, 168, -200},
    { 448, 128, -176},
    { 424, 128, -168},
    { 568, 168, -144},
    { 768, 168, -192},
    { 992, 200, -208},
    { 1160, 264, -336},
    { 1080, 240, -304},
    { 1248, 232, -240},
    { 1328, 248, -232},
    { 1104, 280, -136},
    { 1024, 272, -136},
    { 1064, 272, -136},
    { 1080, 288, -72},
    { 968, 232, -40},
    { 784, 152, 0},
    // 75 seconds
    { 680, 136, -24},
    { 688, 144, -56},
    { 792, 152, -56},
    { 856, 128, -16},
    { 1056, 128, -24},
    { 1136, 128, -8},
    { 1136, 144, -64},
    { 1176, 160, -128},
    { 1056, 152, -96},
    { 1016, 144, -120},
    { 1184, 128, -88},
    { 1304, 104, -8},
    { 1104, 192, -48},
    { 792, 224, -144},
    { 536, 208, -168},
    { 456, 144, -176},
    { 488, 88, -136},
    { 648, 96, -112},
    { 864, 168, -160},
    { 1128, 280, -280},
    { 1128, 336, -328},
    { 1176, 272, -264},
    { 1280, 288, -272},
    { 1064, 336, -264},
    { 1032, 264, -176},
    // 76 seconds
    { 1120, 264, -128},
    { 1208, 256, -120},
    { 1104, 224, -72},
    { 888, 192, -32},
    { 712, 160, -48},
    { 656, 160, -48},
    { 712, 136, -32},
    { 840, 128, -40},
    { 944, 88, 16},
    { 1064, 128, -24},
    { 1016, 176, -64},
    { 1064, 128, -80},
    { 1168, 144, -24},
    { 1104, 128, -72},
    { 1040, 136, -96},
    { 1208, 136, -64},
    { 1240, 160, -80},
    { 1048, 200, -112},
    { 760, 216, -168},
    { 560, 176, -176},
    { 488, 136, -144},
    { 536, 152, -64},
    { 696, 200, -144},
    { 864, 240, -184},
    { 1120, 256, -280},
    // 77 seconds
    { 1136, 272, -296},
    { 1176, 256, -240},
    { 1360, 320, -256},
    { 1128, 296, -240},
    { 984, 224, -144},
    { 1048, 264, -144},
    { 1104, 256, -128},
    { 1080, 224, -72},
    { 904, 192, -16},
    { 728, 168, -32},
    { 680, 152, -56},
    { 704, 152, -32},
    { 760, 152, 8},
    { 888, 104, 0},
    { 1104, 120, -32},
    { 1136, 96, -56},
    { 1136, 64, -96},
    { 1208, 128, -96},
    { 1128, 144, -88},
    { 976, 104, -128},
    { 1160, 120, -72},
    { 1224, 160, -88},
    { 1040, 232, -136},
    { 792, 200, -136},
    { 600, 184, -168},
    // 78 seconds
    { 528, 160, -128},
    { 536, 144, -120},
    { 664, 144, -128},
    { 816, 200, -200},
    { 1056, 232, -296},
    { 1072, 248, -328},
    { 1048, 240, -296},
    { 1336, 272, -264},
    { 1264, 320, -272},
    { 1120, 304, -144},
    { 1040, 272, -136},
    { 1048, 296, -144},
    { 1024, 304, -136},
    { 912, 208, -56},
    { 760, 160, -24},
    { 712, 152, -32},
    { 720, 144, -40},
    { 792, 152, -40},
    { 872, 144, -8},
    { 1024, 144, -16},
    { 1128, 160, -32},
    { 1016, 88, -48},
    { 1176, 56, -80},
    { 1096, 112, -120},
    { 992, 104, -112},
    // 79 seconds
    { 1040, 104, -104},
    { 1192, 136, -80},
    { 1152, 168, -64},
    { 952, 232, -96},
    { 688, 232, -136},
    { 552, 216, -152},
    { 528, 176, -104},
    { 632, 192, -104},
    { 792, 224, -208},
    { 968, 240, -288},
    { 1112, 272, -384},
    { 1128, 272, -336},
    { 1368, 296, -280},
    { 1264, 344, -328},
    { 1088, 320, -168},
    { 1184, 336, -56},
    { 1144, 280, -24},
    { 1072, 208, 8},
    { 880, 144, -24},
    { 744, 152, -32},
    { 672, 120, -16},
    { 696, 136, 0},
    { 784, 160, 0},
    { 904, 144, -8},
    { 1024, 136, -16},
    // 80 seconds
    { 1064, 128, -88},
    { 1048, 120, -160},
    { 1208, 128, -160},
    { 1144, 120, -112},
    { 984, 152, -96},
    { 1128, 192, -104},
    { 1304, 248, -120},
    { 1096, 200, -200},
    { 816, 224, -168},
    { 600, 184, -200},
    { 512, 216, -232},
    { 520, 176, -160},
    { 592, 216, -136},
    { 736, 320, -208},
    { 968, 392, -240},
    { 1136, 416, -224},
    { 960, 352, -184},
    { 1200, 352, -128},
    { 1328, 400, -144},
    { 1176, 384, -144},
    { 1080, 336, -152},
    { 1096, 296, -144},
    { 992, 288, -64},
    { 744, 208, -32},
    { 584, 120, -40},
    // 81 seconds
    { 552, 88, -56},
    { 608, 128, -48},
    { 784, 144, -40},
    { 968, 88, 32},
    { 1240, 96, 0},
    { 1120, 80, 0},
    { 1240, 80, -16},
    { 1208, 104, 64},
    { 1256, 72, -48},
    { 1424, 88, -72},
    { 1328, 144, -112},
    { 992, 160, -168},
    { 624, 120, -192},
    { 440, 104, -208},
    { 352, 120, -176},
    { 408, 184, -104},
    { 568, 288, -168},
    { 840, 328, -208},
    { 1000, 376, -280},
    { 1152, 376, -264},
    { 1656, 432, -280},
    { 1432, 384, -168},
    { 1288, 288, -64},
    { 1296, 248, -88},
    { 1120, 248, -80},
    // 82 seconds
    { 832, 224, -72},
    { 632, 128, -80},
    { 536, 112, -48},
    { 552, 112, -40},
    { 744, 64, -16},
    { 1048, 40, -48},
    { 1192, 64, -16},
    { 1216, 176, -32},
    { 1344, 192, -112},
    { 1256, 168, -16},
    { 1304, 192, -88},
    { 1392, 216, -88},
    { 1200, 208, -120},
    { 784, 216, -120},
    { 496, 216, -144},
    { 376, 192, -184},
    { 376, 112, -112},
    { 504, 120, -104},
    { 720, 152, -128},
    { 1200, 280, -240},
    { 1184, 376, -288},
    { 1208, 424, -264},
    { 1352, 400, -264},
    { 1144, 416, -320},
    { 1072, 384, -200},
    // 83 seconds
    { 1168, 296, -120},
    { 1208, 264, -80},
    { 1056, 224, -16},
    { 824, 184, -24},
    { 656, 128, -32},
    { 584, 144, -40},
    { 640, 176, 8},
    { 792, 96, 16},
    { 968, 80, 0},
    { 1080, 128, -24},
    { 1160, 152, -72},
    { 1136, 152, -152},
    { 1128, 160, -88},
    { 1064, 128, -32},
    { 1328, 104, -32},
    { 1416, 216, -40},
    { 1168, 264, -88},
    { 792, 256, -168},
    { 520, 208, -160},
    { 424, 168, -136},
    { 456, 136, -64},
    { 632, 168, -88},
    { 888, 232, -152},
    { 1168, 288, -216},
    { 1184, 312, -280},
    // 84 seconds
    { 1168, 312, -240},
    { 1248, 328, -248},
    { 1088, 376, -272},
    { 1064, 336, -168},
    { 1144, 320, -128},
    { 1208, 280, -80},
    { 1112, 240, -24},
    { 920, 200, -40},
    { 792, 160, -32},
    { 736, 136, -24},
    { 736, 136, 8},
    { 808, 96, 24},
    { 928, 80, 8},
    { 1072, 120, -16},
    { 1056, 120, -24},
    { 1104, 88, -64},
    { 1200, 120, -16},
    { 1120, 144, -40},
    { 1216, 144, -96},
    { 1360, 144, -32},
    { 1296, 184, -64},
    { 1000, 224, -168},
    { 648, 232, -224},
    { 480, 184, -200},
    { 448, 176, -112},
    // 85 seconds
    { 576, 184, -96},
    { 752, 248, -192},
    { 1064, 304, -232},
    { 1200, 384, -304},
    { 992, 376, -256},
    { 1192, 368, -184},
    { 1368, 416, -216},
    { 1096, 344, -96},
    { 1200, 280, -88},
    { 1232, 264, -104},
    { 1120, 264, -72},
    { 912, 208, -48},
    { 784, 144, -24},
    { 720, 120, -24},
    { 680, 88, 8},
    { 792, 80, -24},
    { 1000, 96, -32},
    { 1200, 120, -128},
    { 1224, 104, -152},
    { 1224, 96, -120},
    { 1328, 128, -16},
    { 1120, 160, -64},
    { 1064, 152, -144},
    { 1208, 208, -80},
    { 1064, 224, -72},
    // 86 seconds
    { 800, 208, -96},
    { 568, 184, -128},
    { 472, 176, -96},
    { 488, 176, -104},
    { 608, 152, -56},
    { 832, 200, -112},
    { 1192, 280, -176},
    { 1208, 328, -392},
    { 1120, 320, -352},
    { 1264, 328, -248},
    { 1208, 344, -264},
    { 1064, 336, -264},
    { 952, 296, -232},
    { 1016, 264, -160},
    { 1104, 272, -104},
    { 1032, 168, -40},
    { 856, 152, -40},
    { 720, 152, -80},
    { 656, 160, -48},
    { 728, 144, -24},
    { 848, 136, -8},
    { 1000, 144, -8},
    { 1096, 168, -56},
    { 1048, 152, -48},
    { 1216, 128, -64},
    // 87 seconds
    { 1208, 120, -128},
    { 1136, 136, -112},
    { 1008, 128, -96},
    { 1096, 112, -64},
    { 1104, 144, -88},
    { 960, 208, -128},
    { 736, 216, -136},
    { 576, 184, -144},
    { 496, 136, -152},
    { 520, 136, -96},
    { 648, 184, -112},
    { 872, 224, -216},
    { 1168, 288, -304},
    { 1128, 296, -376},
    { 1120, 264, -296},
    { 1336, 280, -280},
    { 1152, 304, -216},
    { 1016, 256, -136},
    { 1040, 224, -128},
    { 1112, 272, -160},
    { 1072, 264, -104},
    { 936, 200, -48},
    { 808, 160, -56},
    { 728, 144, -48},
    { 704, 144, -24},
    // 88 seconds
    { 744, 128, -8},
    { 840, 112, 0},
    { 1112, 128, 24},
    { 1168, 168, -64},
    { 1112, 128, -176},
    { 1240, 136, -184},
    { 1152, 136, -224},
    { 1040, 80, -184},
    { 1072, 56, -168},
    { 1184, 176, -184},
    { 1056, 216, -160},
    { 800, 216, -136},
    { 616, 152, -184},
    { 504, 184, -112},
    { 512, 184, -88},
    { 624, 192, -40},
    { 752, 232, -192},
    { 952, 312, -240},
    { 1072, 344, -312},
    { 1120, 344, -288},
    { 1352, 400, -264},
    { 1216, 448, -264},
    { 1024, 376, -176},
    { 1096, 296, -128},
    { 1192, 296, -88},
    // 89 seconds
    { 1152, 264, -72},
    { 944, 208, -64},
    { 752, 168, -72},
    { 664, 168, -56},
    { 680, 136, -32},
    { 760, 152, -40},
    { 928, 48, 0},
    { 1080, 8, 16},
    { 1040, 88, -72},
    { 1104, 80, -168},
    { 1288, 112, -128},
    { 1256, 144, -24},
    { 1152, 144, -88},
    { 1208, 168, -112},
    { 1160, 208, -112},
    { 928, 224, -128},
    { 632, 200, -136},
    { 480, 168, -120},
    { 464, 152, -136},
    { 584, 168, -88},
    { 768, 200, -168},
    { 952, 240, -192},
    { 1112, 288, -304},
    { 1008, 304, -312},
    { 1120, 288, -224},
    // 90 seconds
    { 1304, 352, -192},
    { 1128, 336, -232},
    { 1072, 304, -160},
    { 1136, 296, -136},
    { 1192, 264, -144},
    { 1024, 192, -88},
    { 784, 176, -88},
    { 656, 168, -56},
    { 656, 160, -56},
    { 776, 144, -48},
    { 824, 120, -16},
    { 912, 96, -8},
    { 1112, 136, -56},
    { 1144, 176, -48},
    { 1176, 168, -56},
    { 1160, 176, -48},
    { 1032, 176, -32},
    { 1088, 136, -104},
    { 1232, 144, -64},
    { 1160, 192, -96},
    { 912, 208, -120},
    { 664, 200, -144},
    { 536, 176, -168},
    { 512, 152, -152},
    { 616, 184, -120},
    // 91 seconds
    { 760, 208, -168},
    { 1000, 256, -264},
    { 1112, 312, -352},
    { 1088, 352, -304},
    { 1336, 360, -232},
    { 1240, 352, -232},
    { 1104, 312, -152},
    { 1160, 288, -120},
    { 1192, 264, -80},
    { 1112, 248, -32},
    { 912, 216, -32},
    { 744, 168, -40},
    { 656, 144, -16},
    { 664, 136, 0},
    { 736, 144, 0},
    { 840, 104, 16},
    { 1080, 128, 0},
    { 1080, 104, -16},
    { 1072, 112, -32},
    { 1240, 152, -72},
    { 1168, 184, -24},
    { 1048, 152, -96},
    { 1240, 136, -56},
    { 1312, 176, -88},
    { 1152, 224, -184},
    // 92 seconds
    { 760, 224, -184},
    { 512, 168, -168},
    { 432, 144, -128},
    { 488, 160, -72},
    { 640, 232, -112},
    { 848, 248, -200},
    { 1144, 328, -264},
    { 1144, 360, -296},
    { 1112, 352, -232},
    { 1304, 376, -232},
    { 1064, 376, -176},
    { 1136, 312, -112},
    { 1224, 304, -104},
    { 1232, 304, -40},
    { 1064, 256, 16},
    { 856, 160, 48},
    { 720, 160, -8},
    { 672, 64, 24},
    { 752, 152, 24},
    { 832, 88, 16},
    { 960, 176, 0},
    { 1056, 160, -24},
    { 1080, 144, -56},
    { 1168, 152, -88},
    { 1176, 152, -8},
    // 93 seconds
    { 1088, 120, 16},
    { 1240, 96, 8},
    { 1328, 144, 24},
    { 1200, 208, -48},
    { 864, 224, -112},
    { 600, 184, -144},
    { 488, 184, -208},
    { 456, 176, -144},
    { 576, 120, -80},
    { 800, 168, -192},
    { 1040, 216, -272},
    { 1136, 240, -352},
    { 1144, 232, -304},
    { 1248, 232, -272},
    { 1240, 304, -296},
    { 1008, 304, -232},
    { 1120, 280, -104},
    { 1224, 264, -48},
    { 1152, 256, -32},
    { 952, 224, -32},
    { 784, 176, -64},
    { 680, 168, -40},
    { 664, 184, -8},
    { 744, 136, -8},
    { 832, 136, -40},
    // 94 seconds
    { 1032, 24, -8},
    { 1128, 48, -48},
    { 1064, 72, -72},
    { 1248, 128, -56},
    { 1168, 152, 0},
    { 1104, 176, -64},
    { 1256, 152, -32},
    { 1336, 160, 32},
    { 1144, 248, -80},
    { 800, 272, -152},
    { 568, 224, -176},
    { 464, 168, -128},
    { 488, 144, -96},
    { 648, 168, -112},
    { 912, 232, -192},
    { 1088, 256, -232},
    { 1088, 264, -264},
    { 1096, 264, -264},
    { 1272, 304, -232},
    { 1184, 336, -232},
    { 1080, 288, -168},
    { 1232, 272, -136},
    { 1272, 264, -88},
    { 1112, 240, -56},
    { 872, 200, -48},
    // 95 seconds
    { 728, 152, -56},
    { 672, 152, -40},
    { 712, 144, -16},
    { 832, 104, 0},
    { 992, 16, 24},
    { 1128, 24, 8},
    { 1096, 80, -24},
    { 1272, 128, 0},
    { 1256, 168, 80},
    { 1104, 152, -8},
    { 1328, 112, -24},
    { 1336, 176, 16},
    { 1104, 232, -72},
    { 744, 240, -152},
    { 536, 224, -200},
    { 480, 168, -160},
    { 536, 160, -120},
    { 704, 176, -168},
    { 912, 200, -248},
    { 1088, 240, -296},
    { 1104, 248, -376},
    { 1136, 248, -296},
    { 1312, 248, -264},
    { 1144, 264, -216},
    { 1120, 280, -152},
    // 96 seconds
    { 1176, 256, -112},
    { 1192, 264, -104},
    { 1072, 264, -64},
    { 864, 216, -48},
    { 728, 192, -56},
    { 712, 168, -24},
    { 744, 144, 8},
    { 840, 144, 16},
    { 912, 104, 24},
    { 1104, 88, 40},
    { 1040, 80, 0},
    { 1072, 64, -56},
    { 1232, 64, -96},
    { 1176, 80, -24},
    { 1048, 112, -80},
    { 1208, 144, -120},
    { 1232, 208, -144},
    { 1032, 256, -160},
    { 720, 232, -184},
    { 560, 184, -160},
    { 520, 160, -112},
    { 576, 152, -88},
    { 704, 208, -104},
    { 880, 256, -200},
    { 1104, 280, -288},
    // 97 seconds
    { 1088, 320, -360},
    { 1120, 304, -304},
    { 1304, 304, -272},
    { 1136, 336, -248},
    { 1064, 304, -192},
    { 1120, 272, -144},
    { 1232, 272, -104},
    { 1128, 256, -40},
    { 896, 208, -8},
    { 768, 152, -16},
    { 704, 208, 8},
    { 736, 184, 8},
    { 768, 176, -16},
    { 848, 88, 32},
    { 1016, 104, -8},
    { 1080, 168, -64},
    { 1200, 152, -80},
    { 1256, 176, -72},
    { 1064, 176, -160},
    { 1008, 136, -152},
    { 1200, 144, -72},
    { 1112, 200, -88},
    { 888, 232, -104},
    { 664, 240, -136},
    { 568, 216, -160},
    // 98 seconds
    { 584, 200, -120},
    { 688, 160, -96},
    { 832, 192, -168},
    { 976, 232, -200},
    { 1056, 272, -264},
    { 1104, 272, -248},
    { 1296, 312, -240},
    { 1288, 336, -256},
    { 1064, 312, -192},
    { 1016, 256, -184},
    { 1120, 304, -184},
    { 1160, 216, -128},
    { 1000, 176, -56},
    { 824, 152, -40},
    { 696, 152, -32},
    { 680, 176, -16},
    { 720, 160, 8},
    { 808, 144, 24},
    { 1008, 152, -8},
    { 1088, 160, -48},
    { 1008, 96, -16},
    { 1272, 112, 16},
    { 1176, 136, 24},
    { 1048, 160, -16},
    { 1056, 120, -48},
    // 99 seconds
    { 1216, 144, -48},
    { 1184, 192, -120},
    { 944, 208, -176},
    { 664, 192, -176},
    { 568, 184, -168},
    { 560, 160, -168},
    { 656, 176, -160},
    { 768, 208, -192},
    { 904, 248, -232},
    { 1048, 272, -304},
    { 1120, 288, -288},
    { 1416, 320, -248},
    { 1264, 352, -264},
    { 1072, 280, -152},
    { 1160, 312, -184},
    { 1168, 328, -184},
    { 1088, 288, -120},
    { 928, 160, -40},
    { 784, 144, -40},
    { 728, 136, -24},
    { 752, 144, -16},
    { 832, 160, -16},
    { 1000, 168, -24},
    { 1096, 120, 0},
    { 1056, 80, 0},
    // 100 seconds
    { 1120, 64, 0},
    { 1128, 136, -32},
    { 1112, 160, -40},
    { 1048, 152, -40},
    { 1144, 176, -64},
    { 1128, 184, -96},
    { 984, 216, -88},
    { 776, 224, -104},
    { 632, 216, -136},
    { 608, 200, -144},
    { 688, 192, -136},
    { 848, 216, -184},
    { 984, 256, -280},
    { 1120, 272, -392},
    { 1112, 272, -416},
    { 1160, 248, -336},
    { 1320, 304, -344},
    { 1072, 288, -304},
    { 992, 248, -184},
    { 1144, 264, -136},
    { 1176, 264, -72},
    { 1080, 264, -40},
    { 928, 224, -32},
    { 808, 192, -16},
    { 760, 176, 0},
    // 101 seconds
    { 792, 176, 0},
    { 848, 144, -8},
    { 904, 80, -16},
    { 1064, 56, 8},
    { 1048, 88, -72},
    { 1128, 104, -128},
    { 1192, 120, -128},
    { 1064, 128, -128},
    { 992, 168, -232},
    { 1184, 208, -160},
    { 1176, 216, -112},
    { 968, 200, -112},
    { 736, 192, -88},
    { 584, 176, -152},
    { 576, 152, -176},
    { 712, 136, -80},
    { 824, 184, -184},
    { 968, 256, -240},
    { 1144, 320, -328},
    { 1152, 384, -336},
    { 1160, 336, -280},
    { 1208, 352, -248},
    { 1008, 336, -232},
    { 1080, 304, -144},
    { 1208, 280, -72},
    // 102 seconds
    { 1144, 264, -32},
    { 992, 264, -48},
    { 832, 208, -88},
    { 736, 160, -56},
    { 728, 136, -16},
    { 792, 160, 0},
    { 864, 168, 0},
    { 1000, 136, -24},
    { 1112, 120, -80},
    { 1088, 56, -32},
    { 1096, 24, -112},
    { 1216, 56, -128},
    { 1056, 56, -112},
    { 1120, 88, -168},
    { 1264, 168, -184},
    { 1152, 200, -160},
    { 912, 200, -112},
    { 680, 168, -120},
    { 584, 160, -152},
    { 568, 168, -96},
    { 696, 200, -56},
    { 824, 224, -168},
    { 1000, 256, -184},
    { 1152, 304, -312},
    { 1152, 312, -304},
    // 103 seconds
    { 1200, 304, -256},
    { 1192, 360, -264},
    { 936, 328, -256},
    { 1096, 320, -208},
    { 1184, 320, -168},
    { 1208, 296, -56},
    { 1080, 248, 8},
    { 896, 192, 24},
    { 784, 144, 8},
    { 776, 136, -16},
    { 840, 160, -24},
    { 936, 160, -16},
    { 1088, 128, -24},
    { 1128, 136, -24},
    { 1008, 64, 0},
    { 1112, 64, -112},
    { 1040, 64, -112},
    { 984, 88, -120},
    { 1120, 144, -152},
    { 1272, 160, -144},
    { 1176, 224, -144},
    { 944, 224, -144},
    { 720, 208, -112},
    { 624, 232, -136},
    { 640, 208, -136},
    // 104 seconds
    { 752, 216, -72},
    { 856, 240, -168},
    { 1000, 352, -328},
    { 1088, 424, -464},
    { 1088, 408, -416},
    { 1336, 408, -352},
    { 1240, 416, -296},
    { 1088, 360, -192},
    { 1192, 296, -72},
    { 1288, 272, 24},
    { 1200, 264, -8},
    { 1000, 200, -48},
    { 768, 168, -24},
    { 680, 160, 0},
    { 672, 160, 0},
    { 752, 152, -40},
    { 840, 136, -32},
    { 1032, 144, -88},
    { 1096, 136, -144},
    { 1048, 72, -152},
    { 1128, 72, -88},
    { 1112, 128, -128},
    { 1016, 176, -176},
    { 1112, 184, -136},
    { 1280, 216, -96},
    // 105 seconds
    { 1200, 264, -104},
    { 928, 240, -104},
    { 728, 232, -104},
    { 664, 264, -136},
    { 696, 256, -88},
    { 792, 224, -96},
    { 872, 248, -192},
    { 968, 304, -256},
    { 1048, 296, -272},
    { 1056, 304, -296},
    { 1216, 280, -256},
    { 1040, 320, -296},
    { 992, 328, -256},
    { 1112, 280, -160},
    { 1248, 232, -144},
    { 1232, 224, -120},
    { 1128, 200, -96},
    { 1008, 168, -56},
    { 880, 128, -8},
    { 808, 136, -24},
    { 816, 160, -24},
    { 824, 160, -24},
    { 920, 112, -16},
    { 1024, 80, -24},
    { 1048, 96, -56},
    // 106 seconds
    { 1136, 48, -112},
    { 1120, 112, -88},
    { 936, 128, -144},
    { 984, 136, -160},
    { 1248, 168, -144},
    { 1288, 200, -168},
    { 1088, 208, -128},
    { 816, 216, -152},
    { 648, 256, -184},
    { 592, 256, -168},
    { 648, 240, -104},
    { 768, 264, -152},
    { 968, 344, -224},
    { 1112, 416, -272},
    { 1056, 400, -264},
    { 1120, 384, -232},
    { 1280, 416, -200},
    { 1056, 384, -160},
    { 984, 352, -152},
    { 1136, 312, -88},
    { 1264, 288, -88},
    { 1200, 216, -32},
    { 944, 152, -32},
    { 768, 176, -56},
    { 720, 176, -24},
    // 107 seconds
    { 728, 144, 0},
    { 776, 104, 24},
    { 936, 104, 0},
    { 1064, 72, -24},
    { 1144, 96, -64},
    { 1168, 72, -96},
    { 1208, 72, -96},
    { 1184, 120, -40},
    { 1144, 128, -96},
    { 1224, 192, -104},
    { 1168, 192, -96},
    { 944, 232, -128},
    { 696, 224, -168},
    { 576, 192, -136},
    { 552, 176, -104},
    { 632, 216, -72},
    { 768, 232, -136},
    { 976, 272, -192},
    { 1136, 336, -288},
    { 1008, 360, -304},
    { 1272, 392, -272},
    { 1344, 360, -224},
    { 1024, 288, -160},
    { 1088, 256, -168},
    { 1152, 264, -152},
    // 108 seconds
    { 1176, 272, -88},
    { 1024, 240, -56},
    { 872, 176, -56},
    { 736, 168, -56},
    { 720, 160, -16},
    { 768, 144, 0},
    { 792, 128, 8},
    { 944, 120, -24},
    { 1096, 160, -80},
    { 1008, 104, -112},
    { 1184, 96, -96},
    { 1136, 136, -104},
    { 1048, 152, -152},
    { 1088, 160, -144},
    { 1272, 104, -96},
    { 1216, 208, -152},
    { 952, 256, -192},
    { 704, 216, -168},
    { 576, 208, -136},
    { 552, 232, -120},
    { 632, 224, -88},
    { 736, 224, -136},
    { 896, 256, -176},
    { 1088, 304, -256},
    { 1032, 312, -256},
    // 109 seconds
    { 1096, 280, -232},
    { 1352, 312, -224},
    { 1104, 272, -216},
    { 960, 272, -200},
    { 1040, 240, -144},
    { 1168, 224, -128},
    { 1072, 192, -96},
    { 912, 232, -56},
    { 784, 192, -72},
    { 720, 144, -32},
    { 744, 160, -32},
    { 840, 128, -24},
    { 896, 104, -32},
    { 992, 80, -48},
    { 1080, 16, -48},
    { 1056, 0, -104},
    { 1232, 88, -144},
    { 1192, 112, -88},
    { 1056, 144, -104},
    { 1168, 152, -112},
    { 1288, 200, -128},
    { 1112, 216, -104},
    { 832, 208, -96},
    { 608, 184, -136},
    { 520, 184, -112},
    // 110 seconds
    { 528, 152, -80},
    { 688, 176, -80},
    { 824, 232, -176},
    { 984, 256, -224},
    { 1048, 312, -288},
    { 1120, 328, -264},
    { 1400, 368, -232},
    { 1112, 392, -224},
    { 968, 312, -152},
    { 1136, 344, -152},
    { 1224, 288, -152},
    { 1152, 208, -56},
    { 936, 176, -40},
    { 768, 192, -48},
    { 728, 160, -56},
    { 776, 144, -24},
    { 848, 56, 0},
    { 872, -8, 32},
    { 976, 48, -48},
    { 1024, 80, -56},
    { 1056, 56, -64},
    { 1216, 120, -72},
    { 1136, 128, -32},
    { 1144, 152, -72},
    { 1288, 216, -80},
    // 111 seconds
    { 1240, 232, -128},
    { 1016, 232, -120},
    { 752, 208, -136},
    { 600, 184, -144},
    { 552, 200, -128},
    { 632, 208, -144},
    { 776, 232, -200},
    { 920, 280, -256},
    { 1096, 312, -296},
    { 1048, 320, -336},
    { 1064, 328, -272},
    { 1320, 360, -200},
    { 1120, 336, -160},
    { 1088, 288, -104},
    { 1176, 280, -72},
    { 1176, 216, -72},
    { 1088, 192, -64},
    { 888, 192, -40},
    { 768, 160, -48},
    { 744, 168, -32},
    { 760, 176, -8},
    { 824, 136, -32},
    { 872, 112, -8},
    { 976, 128, -32},
    { 1080, 112, -40},
    // 112 seconds
    { 1048, 112, -88},
    { 1152, 112, -96},
    { 1096, 136, -96},
    { 1064, 152, -88},
    { 1272, 208, -128},
    { 1288, 232, -136},
    { 1080, 232, -88},
    { 800, 216, -96},
    { 616, 216, -136},
    { 544, 208, -128},
    { 608, 200, -112},
    { 760, 224, -120},
    { 888, 240, -208},
    { 1040, 272, -256},
    { 1104, 288, -288},
    { 1104, 256, -240},
    { 1336, 320, -264},
    { 1128, 320, -288},
    { 1176, 296, -248},
    { 1136, 120, -96},
    { 1080, 8, -48},
    { 928, 80, -96},
    { 760, 112, -48},
    { 688, 144, -40},
    { 672, 176, -40},
    // 113 seconds
    { 744, 184, -16},
    { 840, 192, -24},
    { 992, 136, -16},
    { 1224, 120, -48},
    { 1128, 104, 24},
    { 1160, 88, 0},
    { 1192, 128, -56},
    { 1008, 88, -64},
    { 1000, 48, -80},
    { 1168, 96, -96},
    { 1200, 80, -136},
    { 1008, 152, -112},
    { 752, 144, -120},
    { 584, 144, -160},
    { 544, 144, -168},
    { 568, 128, -104},
    { 688, 168, -136},
    { 864, 200, -184},
    { 1112, 248, -232},
    { 1128, 264, -272},
    { 1112, 264, -256},
    { 1328, 304, -280},
    { 1104, 320, -224},
    { 1016, 304, -168},
    { 1072, 280, -64},
    // 114 seconds
    { 1168, 312, -16},
    { 1088, 288, -40},
    { 952, 248, -64},
    { 840, 176, -56},
    { 776, 120, -64},
    { 752, 224, 0},
    { 768, 152, 24},
    { 776, 160, 56},
    { 944, 160, 16},
    { 960, 160, -8},
    { 976, 128, -48},
    { 1216, 200, -136},
    { 1136, 184, -88},
    { 1040, 144, -168},
    { 1112, 144, -152},
    { 1224, 192, -144},
    { 1112, 208, -136},
    { 816, 232, -120},
    { 608, 192, -136},
    { 528, 184, -120},
    { 560, 184, -80},
    { 680, 208, -80},
    { 824, 232, -144},
    { 1000, 296, -200},
    { 1096, 344, -248},
    // 115 seconds
    { 1128, 336, -256},
    { 1384, 352, -216},
    { 1240, 360, -224},
    { 1008, 304, -152},
    { 1080, 312, -112},
    { 1192, 280, -32},
    { 1088, 192, 64},
    { 840, 168, 8},
    { 688, 168, -16},
    { 624, 192, -16},
    { 672, 112, 24},
    { 776, 112, 8},
    { 984, 96, 8},
    { 1144, 80, -16},
    { 1192, 128, -40},
    { 1312, 136, -48},
    { 1264, 168, 24},
    { 968, 152, -56},
    { 1128, 152, -96},
    { 1288, 144, -56},
    { 1096, 160, -96},
    { 808, 160, -112},
    { 592, 176, -152},
    { 488, 168, -152},
    { 536, 152, -144},
    // 116 seconds
    { 672, 184, -184},
    { 840, 216, -232},
    { 1032, 240, -256},
    { 1056, 280, -320},
    { 1112, 280, -296},
    { 1296, 296, -232},
    { 1144, 296, -240},
    { 1016, 288, -184},
    { 1176, 264, -112},
    { 1288, 272, -40},
    { 1200, 288, -16},
    { 968, 248, -8},
    { 776, 208, -56},
    { 704, 184, -48},
    { 704, 152, 0},
    { 752, 128, -8},
    { 824, 144, -40},
    { 928, 136, -40},
    { 1032, 136, -72},
    { 1024, 96, -104},
    { 1192, 112, -128},
    { 1144, 144, -112},
    { 1064, 184, -120},
    { 1264, 176, -144},
    { 1304, 232, -128},
    // 117 seconds
    { 1096, 232, -128},
    { 824, 216, -144},
    { 632, 200, -152},
    { 528, 208, -136},
    { 568, 208, -80},
    { 680, 232, -112},
    { 840, 272, -200},
    { 1024, 320, -240},
    { 1096, 328, -248},
    { 1192, 368, -200},
    { 1296, 416, -184},
    { 1104, 384, -184},
    { 1128, 328, -144},
    { 1224, 376, -88},
    { 1208, 240, -64},
    { 1080, 176, -48},
    { 848, 168, -64},
    { 704, 160, -48},
    { 696, 136, -32},
    { 768, 152, -16},
    { 824, 184, -16},
    { 912, 80, 0},
    { 1016, 88, -16},
    { 1048, 80, -56},
    { 1192, 88, -120},
    // 118 seconds
    { 1288, 120, -104},
    { 1128, 128, -72},
    { 1136, 176, -152},
    { 1224, 184, -152},
    { 1128, 192, -112},
    { 904, 216, -152},
    { 680, 192, -120},
    { 560, 208, -144},
    { 536, 224, -128},
    { 648, 208, -96},
    { 840, 272, -216},
    { 960, 296, -248},
    { 1072, 344, -328},
    { 952, 288, -328},
    { 1136, 304, -224},
    { 1296, 376, -264},
    { 1128, 320, -176},
    { 1112, 296, -128},
    { 1216, 288, -96},
    { 1216, 288, -40},
    { 1040, 232, 0},
    { 856, 152, -32},
    { 776, 128, -56},
    { 760, 128, -72},
    { 760, 144, -16},
    // 119 seconds
    { 752, 136, -8},
    { 840, 104, -16},
    { 1016, 168, -112},
    { 1000, 104, -120},
    { 1160, 96, -128},
    { 1160, 136, -128},
    { 1096, 152, -184},
    { 1096, 128, -176},
    { 1248, 168, -112},
    { 1176, 200, -152},
    { 984, 248, -160},
    { 752, 232, -144},
    { 624, 256, -128},
    { 600, 248, -96},
    { 680, 240, -72},
    { 800, 256, -120},
    { 960, 280, -176},
    { 1048, 296, -232},
    { 960, 296, -264},
    { 1192, 304, -264},
    { 1384, 360, -272},
    { 1096, 280, -232},
    { 1024, 248, -160},
    { 1088, 256, -120},
    { 1104, 232, -64},
    // 120 seconds
    // elapsed: 2 minutes
    { 1000, 200, -40},
    { 896, 184, -56},
    { 856, 184, -48},
    { 888, 184, -24},
    { 928, 192, 24},
    { 944, 288, 40},
    { 936, 344, -16},
    { 944, 512, -8},
    { 912, 648, -16},
    { 824, 696, 72},
    { 800, 824, 48},
    { 896, 840, 312},
    { 712, 1016, 512},
    { 440, 1016, 568},
    { 264, 856, 416},
    { 184, 736, 472},
    { 72, 632, 488},
    { -24, 544, 544},
    { -56, 584, 592},
    { -88, 536, 624},
    { -184, 568, 560},
    { -272, 496, 456},
    { -352, 584, 512},
    { -408, 528, 568},
    { -440, 536, 496},
    // 121 seconds
    { -480, 568, 552},
    { -536, 632, 384},
    { -528, 592, 368},
    { -536, 672, 304},
    { -504, 672, 304},
    { -480, 712, 120},
    { -528, 856, 120},
    { -512, 592, 136},
    { -456, 840, -16},
    { -496, 912, -96},
    { -512, 800, -160},
    { -616, 752, -232},
    { -584, 800, -200},
    { -584, 768, -152},
    { -648, 768, 96},
    { -584, 744, 96},
    { -528, 792, -120},
    { -560, 848, -184},
    { -528, 736, -224},
    { -528, 712, -360},
    { -480, 800, -408},
    { -600, 736, -312},
    { -592, 680, -240},
    { -560, 728, -280},
    { -592, 752, -376},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:17:23 local
AccelRawData *activity_sample_walk_200_pbl_25670_13(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25670_13
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -448, 160, -888},
    { -432, 16, -864},
    { -424, -40, -792},
    { -392, 424, -824},
    { -336, 480, -608},
    { -392, 584, -544},
    { -424, 584, -576},
    { -456, 712, -568},
    { -472, 792, -576},
    { -432, 536, -512},
    { -312, 336, -392},
    { -224, 640, -232},
    { -144, 1024, -256},
    { -176, 952, 320},
    { -224, 1584, 408},
    { -296, 1024, 368},
    { -328, 976, 352},
    { -336, 1400, 168},
    { -360, 992, -48},
    { -384, 656, -328},
    { -392, 376, -552},
    { -320, 376, -792},
    { -312, 560, -832},
    { -360, 320, -832},
    { -248, 304, -752},
    // 1 seconds
    { -288, 248, -808},
    { -240, 104, -880},
    { -432, 56, -1000},
    { -264, 104, -952},
    { 0, 32, -912},
    { -352, 16, -912},
    { -360, 64, -896},
    { -400, 152, -928},
    { -560, 256, -1096},
    { 264, 256, -952},
    { -456, 280, -1000},
    { -144, 24, -904},
    { -192, 128, -856},
    { -192, 40, -760},
    { -128, 136, -752},
    { -40, 344, -608},
    { -32, 528, -464},
    { 8, 736, -544},
    { 16, 776, -408},
    { 24, 768, -424},
    { 72, 912, -408},
    { 104, 816, -472},
    { 144, 832, -464},
    { 280, 656, -520},
    { 376, 616, -544},
    // 2 seconds
    { 432, 568, -512},
    { 520, 768, -544},
    { 584, 672, -496},
    { 640, 664, -480},
    { 696, 712, -512},
    { 704, 640, -472},
    { 744, 560, -448},
    { 728, 576, -440},
    { 728, 496, -392},
    { 784, 432, -368},
    { 784, 368, -344},
    { 832, 336, -344},
    { 824, 280, -288},
    { 888, 272, -256},
    { 904, 296, -240},
    { 928, 264, -176},
    { 912, 288, -184},
    { 864, 240, -184},
    { 864, 208, -168},
    { 904, 216, -160},
    { 928, 232, -152},
    { 952, 240, -176},
    { 920, 240, -184},
    { 864, 240, -192},
    { 840, 240, -192},
    // 3 seconds
    { 824, 224, -168},
    { 832, 224, -176},
    { 856, 240, -184},
    { 896, 256, -224},
    { 912, 240, -240},
    { 936, 232, -240},
    { 944, 248, -240},
    { 984, 224, -240},
    { 1024, 216, -200},
    { 1072, 272, -216},
    { 1096, 272, -216},
    { 1032, 280, -128},
    { 888, 264, -80},
    { 824, 256, -88},
    { 1000, 288, -136},
    { 1072, 448, -80},
    { 1120, 152, -56},
    { 1016, 96, -32},
    { 880, 168, -8},
    { 792, 192, -56},
    { 744, 184, -72},
    { 720, 232, -32},
    { 744, 160, -24},
    { 888, 184, -112},
    { 992, 200, -192},
    // 4 seconds
    { 1096, 128, -208},
    { 1312, 128, -128},
    { 1184, 128, -112},
    { 1136, 216, -96},
    { 1024, 192, -136},
    { 1128, 208, -72},
    { 1128, 248, -104},
    { 944, 272, -120},
    { 672, 248, -128},
    { 520, 200, -152},
    { 464, 168, -120},
    { 520, 208, -144},
    { 680, 248, -216},
    { 888, 248, -232},
    { 1144, 296, -288},
    { 1000, 312, -328},
    { 1112, 288, -272},
    { 1248, 336, -272},
    { 1080, 304, -208},
    { 1288, 288, -144},
    { 1192, 328, -88},
    { 1176, 312, -104},
    { 904, 248, -16},
    { 672, 192, -16},
    { 616, 168, -48},
    // 5 seconds
    { 616, 152, -24},
    { 744, 160, -16},
    { 904, 112, -8},
    { 1200, 168, 0},
    { 1200, 128, -16},
    { 1072, 120, -32},
    { 1216, 160, -80},
    { 1096, 104, -72},
    { 968, 112, -96},
    { 1144, 160, -112},
    { 1248, 200, -120},
    { 1080, 248, -136},
    { 784, 240, -160},
    { 560, 200, -160},
    { 472, 144, -160},
    { 512, 144, -144},
    { 656, 176, -192},
    { 824, 224, -248},
    { 1072, 256, -280},
    { 1064, 280, -368},
    { 1120, 248, -328},
    { 1272, 304, -280},
    { 1144, 328, -272},
    { 1064, 304, -168},
    { 1160, 312, -104},
    // 6 seconds
    { 1264, 312, -40},
    { 1072, 264, 0},
    { 832, 216, -40},
    { 728, 184, -56},
    { 680, 184, -56},
    { 776, 160, -40},
    { 840, 96, 0},
    { 976, 96, -24},
    { 1064, 128, -72},
    { 1072, 104, -64},
    { 1136, 136, -40},
    { 1192, 184, -56},
    { 1112, 184, -88},
    { 1160, 168, -104},
    { 1272, 144, -88},
    { 1160, 200, -72},
    { 912, 256, -160},
    { 624, 280, -192},
    { 496, 264, -160},
    { 512, 200, -136},
    { 608, 200, -176},
    { 744, 224, -240},
    { 960, 280, -248},
    { 1064, 320, -288},
    { 1016, 304, -288},
    // 7 seconds
    { 1200, 312, -216},
    { 1304, 328, -240},
    { 1072, 328, -184},
    { 1080, 328, -128},
    { 1192, 312, -128},
    { 1136, 272, -56},
    { 856, 232, -24},
    { 696, 208, -64},
    { 672, 168, -72},
    { 696, 160, -72},
    { 784, 144, -56},
    { 864, 120, -56},
    { 1120, 112, -112},
    { 1208, 96, -104},
    { 1088, 24, -104},
    { 1240, 136, -144},
    { 1144, 96, -64},
    { 1080, 88, -64},
    { 1256, 184, -160},
    { 1184, 216, -168},
    { 944, 208, -120},
    { 664, 216, -168},
    { 496, 176, -152},
    { 464, 152, -128},
    { 560, 192, -152},
    // 8 seconds
    { 696, 240, -112},
    { 936, 312, -176},
    { 1120, 328, -280},
    { 1040, 328, -344},
    { 1208, 296, -288},
    { 1336, 344, -320},
    { 1128, 328, -216},
    { 1160, 312, -144},
    { 1128, 328, -96},
    { 1088, 312, -56},
    { 872, 240, -80},
    { 728, 176, -56},
    { 648, 112, -96},
    { 696, 168, -56},
    { 744, 128, -56},
    { 840, 136, -40},
    { 1048, 128, 8},
    { 1208, 152, -32},
    { 1096, 120, -32},
    { 1272, 136, -112},
    { 1184, 120, -104},
    { 1048, 120, -136},
    { 1136, 160, -176},
    { 1168, 136, -112},
    { 1024, 192, -160},
    // 9 seconds
    { 760, 200, -152},
    { 552, 192, -184},
    { 472, 192, -176},
    { 504, 176, -136},
    { 672, 200, -184},
    { 856, 240, -200},
    { 1088, 256, -288},
    { 1136, 312, -304},
    { 1152, 288, -272},
    { 1368, 344, -256},
    { 1112, 344, -256},
    { 1128, 296, -144},
    { 1184, 296, -104},
    { 1192, 280, -72},
    { 1000, 232, -8},
    { 760, 184, -40},
    { 664, 136, -96},
    { 680, 112, -32},
    { 784, 136, -24},
    { 872, 136, -64},
    { 920, 136, -40},
    { 1096, 128, -64},
    { 1104, 56, -16},
    { 1200, 96, -72},
    { 1232, 120, -56},
    // 10 seconds
    { 1080, 176, -56},
    { 1168, 168, -112},
    { 1240, 216, -112},
    { 1088, 248, -128},
    { 784, 216, -184},
    { 584, 184, -152},
    { 504, 184, -176},
    { 536, 184, -112},
    { 688, 216, -136},
    { 880, 280, -216},
    { 1064, 304, -280},
    { 1072, 312, -296},
    { 1128, 312, -272},
    { 1312, 376, -280},
    { 1200, 368, -256},
    { 1200, 288, -136},
    { 1208, 288, -112},
    { 1160, 280, -112},
    { 1008, 232, -72},
    { 800, 176, -48},
    { 688, 144, -48},
    { 672, 176, -40},
    { 776, 152, 0},
    { 872, 112, 16},
    { 976, 56, 32},
    // 11 seconds
    { 1112, 56, 8},
    { 1096, 64, -32},
    { 1264, 96, -48},
    { 1240, 96, -24},
    { 1128, 136, -120},
    { 1328, 184, -112},
    { 1288, 176, -104},
    { 1000, 248, -152},
    { 656, 232, -208},
    { 504, 192, -184},
    { 472, 168, -128},
    { 592, 208, -112},
    { 800, 272, -192},
    { 952, 264, -248},
    { 1120, 304, -320},
    { 1112, 320, -320},
    { 1248, 336, -280},
    { 1264, 368, -248},
    { 1056, 320, -200},
    { 1248, 312, -120},
    { 1288, 288, -88},
    { 1160, 288, -16},
    { 928, 256, -8},
    { 744, 184, -24},
    { 712, 152, -24},
    // 12 seconds
    { 760, 128, -16},
    { 808, 120, 16},
    { 888, 136, -8},
    { 1008, 160, -72},
    { 1048, 80, -104},
    { 1040, 72, -136},
    { 1160, 80, -136},
    { 1120, 144, -96},
    { 1152, 160, -120},
    { 1328, 248, -120},
    { 1288, 232, -128},
    { 1048, 264, -128},
    { 728, 232, -136},
    { 552, 248, -120},
    { 496, 216, -112},
    { 592, 216, -88},
    { 744, 280, -80},
    { 992, 320, -160},
    { 1152, 376, -224},
    { 1040, 336, -240},
    { 1080, 320, -232},
    { 1256, 352, -256},
    { 1096, 360, -224},
    { 1056, 344, -176},
    { 1144, 280, -144},
    // 13 seconds
    { 1184, 256, -88},
    { 1008, 216, -32},
    { 784, 184, -64},
    { 672, 168, -48},
    { 680, 168, -40},
    { 816, 176, -8},
    { 1000, 128, 32},
    { 1096, 48, 32},
    { 1152, 64, -24},
    { 1088, 24, -72},
    { 1216, 24, -64},
    { 1224, 64, 0},
    { 1120, 112, -88},
    { 1296, 192, -112},
    { 1304, 192, -96},
    { 1096, 248, -128},
    { 744, 232, -144},
    { 504, 200, -144},
    { 416, 144, -120},
    { 488, 160, -88},
    { 680, 216, -152},
    { 992, 248, -144},
    { 1256, 296, -272},
    { 1152, 304, -240},
    { 1288, 304, -208},
    // 14 seconds
    { 1200, 352, -256},
    { 1048, 336, -200},
    { 1168, 312, -128},
    { 1168, 296, -136},
    { 1096, 248, -72},
    { 920, 200, -16},
    { 736, 160, -16},
    { 696, 176, -64},
    { 752, 120, -16},
    { 856, 144, 16},
    { 920, 88, 16},
    { 1096, 128, 8},
    { 1088, 40, 16},
    { 1112, 64, -40},
    { 1272, 80, -40},
    { 1232, 72, 24},
    { 1128, 120, -32},
    { 1208, 192, -8},
    { 1224, 248, -24},
    { 1040, 296, -128},
    { 696, 256, -184},
    { 512, 184, -144},
    { 448, 120, -136},
    { 520, 128, -136},
    { 760, 200, -152},
    // 15 seconds
    { 1048, 272, -224},
    { 1176, 256, -280},
    { 1136, 256, -240},
    { 1280, 264, -264},
    { 1328, 328, -280},
    { 960, 304, -176},
    { 1040, 272, -152},
    { 1200, 320, -152},
    { 1136, 280, -80},
    { 920, 200, -56},
    { 712, 152, -56},
    { 656, 168, -32},
    { 688, 200, -32},
    { 816, 176, 0},
    { 976, 104, 64},
    { 1176, 96, 56},
    { 1144, 104, 56},
    { 1160, 112, -32},
    { 1136, 128, -32},
    { 1072, 104, -64},
    { 1216, 128, -40},
    { 1336, 208, -96},
    { 1176, 240, -120},
    { 872, 240, -160},
    { 600, 224, -192},
    // 16 seconds
    { 448, 192, -176},
    { 440, 184, -192},
    { 584, 176, -176},
    { 832, 224, -256},
    { 1104, 304, -304},
    { 1120, 304, -304},
    { 1112, 312, -232},
    { 1344, 360, -200},
    { 1232, 360, -168},
    { 1136, 296, -88},
    { 1128, 288, -96},
    { 1104, 272, -120},
    { 1016, 224, -56},
    { 824, 176, -32},
    { 680, 192, -64},
    { 648, 88, -8},
    { 704, 168, -40},
    { 792, 128, -40},
    { 920, 104, -56},
    { 1040, 40, -48},
    { 1128, 56, -56},
    { 1168, 80, -80},
    { 1232, 136, -80},
    { 1064, 176, -40},
    { 1240, 264, -144},
    // 17 seconds
    { 1344, 248, -128},
    { 1168, 264, -120},
    { 824, 248, -120},
    { 552, 216, -144},
    { 472, 144, -120},
    { 456, 120, -128},
    { 568, 128, -112},
    { 728, 208, -176},
    { 936, 312, -232},
    { 984, 400, -248},
    { 1064, 408, -200},
    { 1272, 456, -200},
    { 1176, 464, -184},
    { 1288, 408, -104},
    { 1344, 336, -80},
    { 1240, 312, -72},
    { 1040, 264, -56},
    { 768, 200, -64},
    { 624, 184, -40},
    { 568, 64, 16},
    { 632, 168, 0},
    { 784, 144, -8},
    { 992, 144, -80},
    { 1120, 112, -48},
    { 1024, 48, -16},
    // 18 seconds
    { 1200, 88, -112},
    { 1248, 136, -80},
    { 1120, 192, -80},
    { 1208, 152, -88},
    { 1280, 208, -64},
    { 1144, 256, -128},
    { 848, 264, -152},
    { 600, 200, -120},
    { 496, 184, -88},
    { 504, 192, -80},
    { 616, 248, -104},
    { 792, 328, -168},
    { 1048, 368, -216},
    { 1128, 352, -296},
    { 1128, 272, -240},
    { 1288, 336, -224},
    { 1144, 368, -248},
    { 1128, 344, -144},
    { 1264, 320, -80},
    { 1224, 304, -40},
    { 1016, 280, -24},
    { 784, 224, -40},
    { 696, 152, -88},
    { 648, 24, 16},
    { 704, 112, 0},
    // 19 seconds
    { 792, 104, -8},
    { 912, 80, 0},
    { 1128, 136, 8},
    { 1168, 56, 8},
    { 1240, 112, 24},
    { 1272, 152, 8},
    { 1056, 136, -24},
    { 1144, 128, -32},
    { 1264, 192, -72},
    { 1144, 232, -168},
    { 840, 232, -168},
    { 568, 176, -144},
    { 480, 184, -176},
    { 496, 200, -128},
    { 648, 224, -200},
    { 880, 248, -240},
    { 1160, 296, -320},
    { 1040, 280, -296},
    { 1120, 272, -256},
    { 1312, 312, -224},
    { 1104, 344, -184},
    { 1096, 336, -112},
    { 1256, 376, -96},
    { 1240, 312, -48},
    { 1056, 256, 0},
    // 20 seconds
    { 808, 208, -24},
    { 696, 168, -24},
    { 664, 168, -8},
    { 744, 144, 8},
    { 832, 72, 32},
    { 976, 40, 16},
    { 1120, 80, -16},
    { 1080, 64, -40},
    { 1200, 112, -16},
    { 1288, 88, 8},
    { 1176, 88, -32},
    { 1328, 184, -88},
    { 1312, 208, -112},
    { 1072, 264, -168},
    { 736, 232, -192},
    { 528, 200, -168},
    { 464, 184, -176},
    { 512, 168, -112},
    { 696, 240, -152},
    { 928, 264, -192},
    { 1144, 328, -256},
    { 1080, 328, -296},
    { 1136, 312, -240},
    { 1296, 360, -224},
    { 1048, 360, -176},
    // 21 seconds
    { 1184, 320, -144},
    { 1288, 296, -104},
    { 1208, 280, -72},
    { 1000, 248, -32},
    { 776, 184, -56},
    { 688, 184, -40},
    { 680, 168, -8},
    { 760, 128, -8},
    { 840, 104, 8},
    { 1008, 64, 8},
    { 1168, 80, -8},
    { 1120, 80, -32},
    { 1224, 112, -48},
    { 1136, 160, -32},
    { 1080, 176, -120},
    { 1296, 104, -80},
    { 1280, 168, -48},
    { 1056, 232, -128},
    { 752, 216, -184},
    { 568, 208, -160},
    { 504, 160, -112},
    { 552, 176, -96},
    { 712, 216, -160},
    { 920, 256, -184},
    { 1136, 280, -272},
    // 22 seconds
    { 1104, 304, -288},
    { 1248, 320, -264},
    { 1408, 392, -280},
    { 1048, 336, -208},
    { 1096, 328, -160},
    { 1208, 280, -160},
    { 1208, 256, -112},
    { 1032, 200, -48},
    { 816, 200, -88},
    { 728, 144, -128},
    { 672, 80, -16},
    { 720, 96, -32},
    { 792, 112, -32},
    { 984, 112, -40},
    { 1072, 112, -40},
    { 1056, 104, -48},
    { 1232, 152, -88},
    { 1232, 176, -80},
    { 1056, 120, -152},
    { 1240, 160, -112},
    { 1272, 208, -128},
    { 1056, 248, -176},
    { 744, 224, -192},
    { 544, 184, -192},
    { 480, 168, -160},
    // 23 seconds
    { 560, 192, -160},
    { 720, 216, -208},
    { 928, 256, -264},
    { 1176, 304, -296},
    { 1080, 288, -296},
    { 1192, 312, -248},
    { 1288, 328, -248},
    { 1032, 312, -184},
    { 1136, 296, -120},
    { 1296, 296, -96},
    { 1272, 288, -40},
    { 1024, 224, -16},
    { 776, 184, -40},
    { 672, 208, -24},
    { 720, 192, -32},
    { 744, 80, 16},
    { 784, 56, 32},
    { 1040, 88, 32},
    { 1048, 96, 8},
    { 1040, 112, -56},
    { 1192, 144, -96},
    { 1072, 96, -96},
    { 1096, 104, -104},
    { 1336, 176, -72},
    { 1408, 264, -136},
    // 24 seconds
    { 1112, 272, -160},
    { 752, 240, -216},
    { 568, 200, -208},
    { 520, 192, -184},
    { 576, 176, -200},
    { 680, 224, -208},
    { 808, 256, -224},
    { 968, 288, -224},
    { 1088, 344, -240},
    { 1192, 312, -160},
    { 1400, 344, -104},
    { 1080, 376, -160},
    { 992, 368, -200},
    { 1200, 376, -152},
    { 1360, 320, -8},
    { 1224, 256, 72},
    { 936, 200, 48},
    { 752, 208, 48},
    { 704, 168, 72},
    { 744, 128, 72},
    { 840, 120, 80},
    { 1112, 240, 56},
    { 1128, 240, 104},
    { 1096, 216, 120},
    { 1176, 240, 80},
    // 25 seconds
    { 1072, 264, -32},
    { 864, 248, -160},
    { 960, 168, -120},
    { 1120, 96, -80},
    { 1088, 104, -144},
    { 896, 112, -216},
    { 712, 136, -224},
    { 640, 168, -240},
    { 656, 152, -280},
    { 680, 168, -256},
    { 808, 144, -296},
    { 960, 200, -344},
    { 1080, 264, -336},
    { 1152, 312, -312},
    { 1320, 344, -248},
    { 1232, 328, -136},
    { 1056, 352, -64},
    { 1088, 360, -40},
    { 1200, 328, 32},
    { 1096, 304, 88},
    { 920, 272, 24},
    { 784, 216, 40},
    { 704, 168, 40},
    { 736, 192, 40},
    { 792, 200, 72},
    // 26 seconds
    { 920, 168, 112},
    { 1144, 184, 136},
    { 1072, 160, 80},
    { 1128, 96, 48},
    { 1288, 64, 32},
    { 1128, 48, -104},
    { 1080, 48, -160},
    { 1200, 80, -80},
    { 1160, 152, -96},
    { 960, 224, -232},
    { 648, 160, -200},
    { 616, 272, -248},
    { 576, 256, -136},
    { 752, 64, -216},
    { 936, 440, -168},
    { 968, 320, -240},
    { 1056, 304, -240},
    { 1056, 336, -280},
    { 1176, 320, -208},
    { 1184, 328, -216},
    { 1032, 328, -184},
    { 1120, 280, -104},
    { 1264, 288, -56},
    { 1248, 248, -8},
    { 1008, 208, 24},
    // 27 seconds
    { 784, 184, -48},
    { 712, 176, -48},
    { 752, 184, -24},
    { 880, 128, -8},
    { 872, 72, 32},
    { 984, 64, -8},
    { 1024, 72, -64},
    { 1008, 24, -80},
    { 1192, 96, -96},
    { 1128, 96, -40},
    { 1056, 112, -48},
    { 1296, 184, -64},
    { 1352, 232, -96},
    { 1144, 248, -152},
    { 848, 248, -144},
    { 632, 240, -192},
    { 544, 224, -160},
    { 576, 160, -104},
    { 728, 240, -184},
    { 904, 288, -240},
    { 1088, 320, -288},
    { 1064, 336, -280},
    { 1136, 320, -216},
    { 1360, 376, -200},
    { 992, 328, -168},
    // 28 seconds
    { 1088, 288, -96},
    { 1248, 296, -72},
    { 1288, 272, -16},
    { 1144, 216, 56},
    { 936, 192, -8},
    { 816, 216, -24},
    { 760, 168, 8},
    { 768, 120, 48},
    { 792, 88, 40},
    { 920, 136, 8},
    { 1040, 176, -80},
    { 944, 72, -112},
    { 1064, 56, -136},
    { 1168, 72, -136},
    { 1072, 136, -144},
    { 1120, 168, -160},
    { 1328, 152, -160},
    { 1248, 168, -136},
    { 976, 184, -104},
    { 728, 176, -120},
    { 600, 224, -176},
    { 592, 224, -120},
    { 680, 208, -112},
    { 776, 264, -192},
    { 968, 320, -256},
    // 29 seconds
    { 1128, 136, -80},
    { 1200, 160, -72},
    { 1056, 216, -80},
    { 784, 184, -72},
    { 664, 312, -168},
    { 536, 312, -96},
    { 664, 144, -136},
    { 776, 392, -64},
    { 864, 280, -176},
    { 1096, 344, -216},
    { 1160, 336, -272},
    { 1216, 312, -216},
    { 1352, 352, -248},
    { 1080, 360, -184},
    { 976, 288, -96},
    { 1072, 304, -80},
    { 1264, 248, 24},
    { 1056, 200, 112},
    { 832, 176, 24},
    { 688, 176, -72},
    { 648, 48, -8},
    { 800, 224, 8},
    { 880, 136, 0},
    { 928, 104, -32},
    { 1016, 88, -88},
    // 30 seconds
    { 1072, 96, -88},
    { 1216, 32, -72},
    { 1272, 136, -64},
    { 1024, 152, -72},
    { 1040, 136, -96},
    { 1240, 152, -64},
    { 1152, 208, -72},
    { 920, 216, -88},
    { 672, 208, -128},
    { 568, 232, -144},
    { 552, 200, -104},
    { 656, 216, -120},
    { 792, 240, -224},
    { 984, 216, -240},
    { 1096, 288, -352},
    { 1088, 312, -344},
    { 1360, 352, -304},
    { 1184, 368, -280},
    { 984, 280, -168},
    { 1216, 296, -136},
    { 1312, 288, -72},
    { 1208, 232, 32},
    { 960, 208, -8},
    { 784, 168, -40},
    { 712, 72, 0},
    // 31 seconds
    { 736, 176, 0},
    { 816, 128, 8},
    { 784, 96, 16},
    { 928, 112, -48},
    { 1008, 128, -64},
    { 1024, 64, -128},
    { 1176, 104, -96},
    { 1120, 88, -64},
    { 1080, 120, -88},
    { 1312, 224, -104},
    { 1312, 240, -112},
    { 1120, 264, -88},
    { 832, 240, -120},
    { 656, 224, -160},
    { 600, 208, -144},
    { 640, 176, -80},
    { 752, 232, -160},
    { 832, 256, -208},
    { 1064, 288, -280},
    { 1096, 336, -304},
    { 1128, 288, -288},
    { 1344, 336, -280},
    { 1024, 304, -240},
    { 1120, 320, -136},
    { 1288, 280, -56},
    // 32 seconds
    { 1264, 240, 40},
    { 1168, 208, 40},
    { 928, 208, -24},
    { 784, 200, -48},
    { 736, 8, 120},
    { 728, 232, 8},
    { 856, 136, -24},
    { 960, 112, -8},
    { 1080, 16, 8},
    { 1056, 48, -8},
    { 1056, 64, -64},
    { 1152, 88, -96},
    { 1104, 88, -72},
    { 1136, 112, -88},
    { 1320, 216, -104},
    { 1296, 232, -104},
    { 1024, 256, -144},
    { 712, 296, -160},
    { 576, 240, -136},
    { 576, 176, -120},
    { 688, 192, -120},
    { 808, 248, -152},
    { 1016, 272, -200},
    { 1144, 304, -256},
    { 1024, 304, -256},
    // 33 seconds
    { 1280, 336, -224},
    { 1320, 352, -232},
    { 1096, 296, -168},
    { 1048, 264, -144},
    { 1144, 256, -112},
    { 1176, 232, -48},
    { 1032, 224, -24},
    { 888, 192, -64},
    { 792, 0, 72},
    { 800, 200, -16},
    { 808, 152, 48},
    { 864, 96, 40},
    { 984, 96, 16},
    { 1104, 160, -32},
    { 1096, 104, -64},
    { 1208, 120, -64},
    { 1248, 120, -48},
    { 1112, 112, -88},
    { 1224, 144, -112},
    { 1264, 160, -64},
    { 1088, 232, -104},
    { 776, 216, -136},
    { 552, 200, -128},
    { 480, 176, -152},
    { 528, 176, -80},
    // 34 seconds
    { 704, 200, -112},
    { 928, 336, -184},
    { 1144, 472, -312},
    { 1032, 448, -336},
    { 1104, 408, -304},
    { 1352, 440, -280},
    { 1136, 384, -200},
    { 1056, 328, -104},
    { 1160, 320, -128},
    { 1208, 304, -80},
    { 1088, 248, -24},
    { 896, 184, -24},
    { 712, 184, -16},
    { 656, 192, -32},
    { 696, 240, -48},
    { 776, 152, -16},
    { 848, 64, -8},
    { 1016, 80, -48},
    { 992, 80, -104},
    { 976, 48, -72},
    { 1192, 128, -80},
    { 1160, 168, -56},
    { 1176, 192, -96},
    { 1312, 168, -40},
    { 1320, 240, -80},
    // 35 seconds
    { 1088, 248, -176},
    { 768, 248, -184},
    { 560, 200, -184},
    { 488, 160, -144},
    { 592, 192, -136},
    { 720, 240, -208},
    { 872, 272, -240},
    { 968, 288, -264},
    { 1000, 304, -288},
    { 1168, 312, -224},
    { 1512, 376, -264},
    { 1080, 296, -176},
    { 1176, 264, -104},
    { 1280, 272, -120},
    { 1216, 288, -88},
    { 992, 192, -40},
    { 784, 168, -32},
    { 696, 136, -48},
    { 712, 160, -56},
    { 776, 128, -24},
    { 768, 96, -16},
    { 848, 72, -32},
    { 1008, 48, -40},
    { 1048, 8, -32},
    { 1216, -32, -144},
    // 36 seconds
    { 1328, 88, 72},
    { 1168, 144, 8},
    { 1312, 200, -128},
    { 1416, 232, -192},
    { 1232, 232, -184},
    { 856, 184, -168},
    { 600, 192, -176},
    { 488, 216, -144},
    { 496, 200, -112},
    { 656, 232, -112},
    { 840, 264, -184},
    { 1064, 312, -232},
    { 1040, 304, -280},
    { 1104, 296, -224},
    { 1272, 312, -232},
    { 1096, 336, -192},
    { 1088, 264, -128},
    { 1208, 272, -112},
    { 1296, 296, -96},
    { 1160, 312, -16},
    { 920, 216, -64},
    { 768, 160, -56},
    { 696, 184, -64},
    { 728, 152, -32},
    { 832, 64, -16},
    // 37 seconds
    { 864, -16, 16},
    { 1024, 24, -24},
    { 1088, 104, -48},
    { 1080, 104, -88},
    { 1232, 160, -120},
    { 1072, 184, -168},
    { 1112, 120, -168},
    { 1296, 120, -80},
    { 1296, 128, -48},
    { 1072, 288, -144},
    { 712, 288, -224},
    { 528, 248, -160},
    { 456, 184, -136},
    { 504, 168, -96},
    { 688, 224, -176},
    { 1016, 288, -240},
    { 1176, 288, -264},
    { 1016, 264, -224},
    { 1192, 296, -192},
    { 1352, 360, -232},
    { 1016, 288, -144},
    { 1112, 264, -112},
    { 1176, 264, -104},
    { 1112, 248, -72},
    { 880, 192, -16},
    // 38 seconds
    { 768, 160, 0},
    { 680, 176, 16},
    { 760, 160, 40},
    { 864, 152, 16},
    { 872, 96, 16},
    { 1024, 112, -8},
    { 1120, 104, -48},
    { 1200, 128, -72},
    { 1336, 136, 0},
    { 1048, 104, 16},
    { 1208, 176, -56},
    { 1280, 208, -80},
    { 1176, 208, -128},
    { 792, 192, -72},
    { 592, 328, -160},
    { 448, 320, -152},
    { 392, -224, -88},
    { 648, 320, -192},
    { 872, 304, -176},
    { 1104, 296, -176},
    { 1096, 328, -232},
    { 1096, 264, -208},
    { 1192, 312, -208},
    { 1136, 336, -224},
    { 1096, 272, -184},
    // 39 seconds
    { 1312, 272, -144},
    { 1328, 232, -112},
    { 1120, 224, -56},
    { 872, 184, -64},
    { 712, 176, -72},
    { 664, 160, -64},
    { 688, 152, 0},
    { 760, 32, 32},
    { 872, 56, -16},
    { 1016, 88, -96},
    { 1128, 128, -104},
    { 1256, 144, -64},
    { 1296, 184, -8},
    { 1056, 152, -136},
    { 1248, 160, -88},
    { 1336, 160, -56},
    { 1144, 216, -104},
    { 784, 216, -136},
    { 528, 224, -144},
    { 448, 216, -160},
    { 480, 168, -112},
    { 616, 168, -144},
    { 864, 192, -184},
    { 1120, 248, -248},
    { 1144, 264, -288},
    // 40 seconds
    { 1176, 272, -288},
    { 1296, 304, -288},
    { 1024, 320, -240},
    { 1064, 280, -152},
    { 1272, 312, -128},
    { 1240, 288, -80},
    { 1040, 240, -56},
    { 824, 160, 8},
    { 680, 120, 0},
    { 648, 128, -40},
    { 720, 128, 8},
    { 816, 72, 32},
    { 952, 16, 32},
    { 1144, 88, -32},
    { 1136, 32, -40},
    { 1288, 96, -56},
    { 1240, 96, -24},
    { 1080, 120, -48},
    { 1168, 112, -56},
    { 1320, 160, -48},
    { 1224, 208, -120},
    { 888, 216, -168},
    { 560, 192, -152},
    { 416, 160, -176},
    { 368, 96, -144},
    // 41 seconds
    { 448, 176, -128},
    { 776, 184, -216},
    { 1232, 200, -192},
    { 1184, 232, -256},
    { 1192, 248, -208},
    { 1336, 304, -208},
    { 1016, 344, -232},
    { 1016, 272, -160},
    { 1232, 232, -120},
    { 1256, 248, -112},
    { 1104, 200, -48},
    { 864, 192, -8},
    { 712, 272, -88},
    { 664, 112, -56},
    { 704, 128, 0},
    { 808, 0, 48},
    { 1016, -8, 64},
    { 1152, 40, 0},
    { 1144, 32, -24},
    { 1160, 48, -72},
    { 1216, 48, -32},
    { 1080, 40, 16},
    { 1152, 96, -24},
    { 1296, 160, -56},
    { 1224, 208, -144},
    // 42 seconds
    { 912, 184, -152},
    { 616, 144, -136},
    { 472, 144, -136},
    { 408, 176, -144},
    { 488, 160, -128},
    { 672, 208, -200},
    { 976, 232, -248},
    { 1216, 248, -336},
    { 1032, 248, -312},
    { 1168, 248, -200},
    { 1352, 320, -232},
    { 1136, 320, -184},
    { 1160, 304, -88},
    { 1232, 312, -80},
    { 1200, 288, -16},
    { 960, 208, -8},
    { 744, 152, -16},
    { 648, 128, -24},
    { 632, 96, 0},
    { 736, 80, 0},
    { 816, 16, 8},
    { 1056, 48, -40},
    { 1152, 72, -32},
    { 1112, 64, -24},
    { 1296, 120, -48},
    // 43 seconds
    { 1216, 120, 8},
    { 1104, 88, -56},
    { 1304, 128, -16},
    { 1272, 192, -48},
    { 992, 232, -128},
    { 640, 192, -136},
    { 464, 208, -144},
    { 400, 184, -112},
    { 472, 176, -96},
    { 680, 184, -144},
    { 1032, 240, -240},
    { 1192, 336, -296},
    { 1096, 304, -296},
    { 1232, 312, -248},
    { 1272, 336, -240},
    { 1048, 312, -184},
    { 1192, 312, -128},
    { 1320, 296, -72},
    { 1192, 232, 16},
    { 928, 184, 24},
    { 736, 176, 8},
    { 640, 128, -8},
    { 632, 128, 32},
    { 744, 72, 32},
    { 896, 32, 24},
    // 44 seconds
    { 1048, 80, 8},
    { 1160, 72, -24},
    { 1144, 48, -16},
    { 1272, 88, 8},
    { 1208, 80, -40},
    { 1200, 104, -32},
    { 1296, 184, -72},
    { 1184, 232, -136},
    { 904, 216, -208},
    { 600, 176, -192},
    { 440, 160, -160},
    { 432, 144, -120},
    { 576, 200, -128},
    { 800, 240, -192},
    { 1096, 280, -232},
    { 1080, 288, -304},
    { 1072, 264, -264},
    { 1328, 288, -208},
    { 1232, 312, -240},
    { 1032, 272, -168},
    { 1144, 304, -120},
    { 1224, 264, -104},
    { 1152, 232, -24},
    { 888, 184, -16},
    { 680, 160, -48},
    // 45 seconds
    { 608, 128, -32},
    { 632, 120, -32},
    { 768, 128, 0},
    { 856, 96, -16},
    { 1064, 136, -32},
    { 1104, 160, -56},
    { 1088, 104, -64},
    { 1280, 152, -64},
    { 1120, 136, -56},
    { 1144, 120, -80},
    { 1312, 168, -96},
    { 1208, 192, -152},
    { 920, 192, -152},
    { 616, 176, -168},
    { 480, 160, -184},
    { 480, 160, -120},
    { 608, 160, -80},
    { 776, 240, -168},
    { 936, 312, -208},
    { 1040, 352, -288},
    { 1080, 344, -304},
    { 1256, 344, -248},
    { 1296, 384, -248},
    { 1040, 320, -168},
    { 1152, 312, -128},
    // 46 seconds
    { 1192, 312, -104},
    { 1152, 264, -88},
    { 960, 184, -24},
    { 768, 152, -56},
    { 656, 136, -40},
    { 656, 144, -40},
    { 744, 112, -16},
    { 848, 88, 0},
    { 976, 64, -24},
    { 1072, 96, -88},
    { 1080, 56, -80},
    { 1264, 88, -64},
    { 1176, 128, -96},
    { 992, 88, -112},
    { 1208, 96, -32},
    { 1288, 152, -56},
    { 1088, 216, -88},
    { 816, 224, -120},
    { 616, 216, -136},
    { 528, 184, -136},
    { 544, 168, -112},
    { 664, 200, -168},
    { 848, 232, -256},
    { 1064, 248, -296},
    { 1136, 272, -352},
    // 47 seconds
    { 1096, 272, -304},
    { 1360, 328, -256},
    { 1184, 344, -256},
    { 1008, 264, -152},
    { 1120, 264, -96},
    { 1192, 272, -80},
    { 1136, 224, 8},
    { 928, 160, 0},
    { 800, 168, -40},
    { 720, 128, -8},
    { 712, 104, 16},
    { 816, 128, -32},
    { 880, 72, -16},
    { 1048, 48, -40},
    { 1080, -16, -64},
    { 1072, -24, -120},
    { 1176, 16, -96},
    { 1200, 104, -88},
    { 1072, 104, -120},
    { 1288, 136, -56},
    { 1368, 176, -16},
    { 1136, 264, -48},
    { 792, 280, -136},
    { 560, 248, -152},
    { 464, 224, -160},
    // 48 seconds
    { 520, 192, -120},
    { 672, 208, -144},
    { 896, 272, -232},
    { 1152, 280, -280},
    { 1024, 296, -312},
    { 1032, 248, -264},
    { 1360, 328, -224},
    { 1192, 312, -208},
    { 1136, 272, -152},
    { 1224, 280, -64},
    { 1224, 240, -24},
    { 1136, 176, 0},
    { 816, 96, 16},
    { 624, 120, 0},
    { 584, 112, -8},
    { 632, 144, 8},
    { 728, 96, 8},
    { 872, 96, 0},
    { 1096, 144, -24},
    { 1208, 144, -32},
    { 1272, 128, -32},
    { 1280, 168, -24},
    { 1056, 144, -112},
    { 1088, 112, -152},
    { 1296, 104, -104},
    // 49 seconds
    { 1232, 120, -128},
    { 944, 176, -112},
    { 648, 192, -128},
    { 496, 152, -160},
    { 472, 144, -104},
    { 560, 160, -96},
    { 752, 224, -184},
    { 976, 232, -216},
    { 1144, 264, -312},
    { 1048, 248, -320},
    { 1224, 216, -264},
    { 1352, 264, -208},
    { 1096, 256, -192},
    { 1088, 248, -104},
    { 1096, 240, -48},
    { 1056, 256, -32},
    { 880, 208, -16},
    { 688, 152, 0},
    { 632, 136, -16},
    { 664, 104, 0},
    { 816, 120, 0},
    { 912, 96, -8},
    { 1128, 112, -24},
    { 1128, 80, 0},
    { 1184, 32, -24},
    // 50 seconds
    { 1304, 56, -16},
    { 1296, 72, 48},
    { 1096, 64, -56},
    { 1200, 56, -24},
    { 1224, 72, 8},
    { 1000, 160, -64},
    { 688, 152, -112},
    { 520, 128, -128},
    { 456, 128, -152},
    { 520, 152, -120},
    { 752, 176, -176},
    { 960, 208, -232},
    { 1088, 224, -272},
    { 1104, 256, -264},
    { 1200, 272, -248},
    { 1312, 320, -200},
    { 1056, 328, -208},
    { 1016, 304, -120},
    { 1168, 304, -96},
    { 1136, 256, -24},
    { 984, 216, -8},
    { 824, 160, -32},
    { 720, 136, -32},
    { 736, 64, 0},
    { 784, 152, 8},
    // 51 seconds
    { 872, 128, 0},
    { 1040, 128, 24},
    { 1096, 64, 0},
    { 1160, 8, -56},
    { 1288, 48, -8},
    { 1144, 88, -8},
    { 1144, 96, -72},
    { 1280, 96, -16},
    { 1208, 144, -56},
    { 976, 208, -192},
    { 688, 184, -208},
    { 504, 184, -160},
    { 464, 200, -112},
    { 576, 208, -144},
    { 728, 216, -216},
    { 968, 248, -256},
    { 1096, 296, -280},
    { 1192, 344, -272},
    { 1344, 328, -208},
    { 1272, 304, -208},
    { 1040, 272, -168},
    { 1040, 256, -104},
    { 1160, 264, -72},
    { 1128, 232, -56},
    { 952, 184, -16},
    // 52 seconds
    { 744, 168, -40},
    { 664, 120, -48},
    { 656, 168, -16},
    { 728, 280, -40},
    { 792, 40, -16},
    { 1000, -8, 24},
    { 1152, -16, -64},
    { 1192, -24, -112},
    { 1320, 16, -80},
    { 1320, 96, -40},
    { 1064, 136, -80},
    { 1160, 168, -80},
    { 1272, 240, -104},
    { 1072, 256, -152},
    { 760, 184, -88},
    { 512, 264, -144},
    { 496, 216, -144},
    { 496, 224, -48},
    { 640, 168, -136},
    { 928, 208, -184},
    { 1192, 264, -264},
    { 1080, 256, -224},
    { 1256, 288, -200},
    { 1344, 328, -224},
    { 1016, 296, -160},
    // 53 seconds
    { 1032, 232, -96},
    { 1104, 280, -88},
    { 1144, 248, -80},
    { 1008, 184, 8},
    { 824, 144, -16},
    { 680, 176, -56},
    { 648, 80, 0},
    { 696, 184, 0},
    { 816, 112, -8},
    { 1008, 72, 8},
    { 1144, 64, -24},
    { 1088, 48, -56},
    { 1168, 64, -88},
    { 1160, 24, -32},
    { 1104, 24, -24},
    { 1184, 96, -32},
    { 1296, 160, -32},
    { 1192, 216, -88},
    { 920, 240, -136},
    { 648, 216, -152},
    { 512, 152, -120},
    { 488, 152, -128},
    { 608, 200, -152},
    { 768, 200, -208},
    { 1048, 232, -256},
    // 54 seconds
    { 1072, 240, -312},
    { 1056, 224, -304},
    { 1248, 248, -200},
    { 1288, 280, -240},
    { 1024, 240, -152},
    { 1120, 264, -48},
    { 1216, 272, -48},
    { 1176, 256, -24},
    { 936, 216, -32},
    { 760, 160, -40},
    { 656, 128, -16},
    { 696, 120, 0},
    { 800, 120, 0},
    { 864, 80, 8},
    { 960, 80, -32},
    { 1056, 120, -72},
    { 1112, 64, -120},
    { 1328, 152, -104},
    { 1264, 136, -48},
    { 1024, 136, -112},
    { 1160, 144, -64},
    { 1184, 152, -64},
    { 1008, 184, -88},
    { 736, 184, -104},
    { 560, 160, -112},
    // 55 seconds
    { 496, 136, -112},
    { 512, 144, -104},
    { 664, 168, -128},
    { 896, 216, -176},
    { 1128, 272, -232},
    { 1104, 312, -280},
    { 1168, 344, -280},
    { 1384, 392, -232},
    { 1088, 360, -216},
    { 1008, 296, -136},
    { 1096, 320, -120},
    { 1192, 280, -104},
    { 1072, 216, -40},
    { 872, 152, -24},
    { 696, 136, -48},
    { 608, 112, -24},
    { 664, 120, -40},
    { 792, 104, -24},
    { 944, 80, 8},
    { 1128, 120, -40},
    { 1136, 128, -56},
    { 1184, 136, -56},
    { 1280, 144, -40},
    { 1144, 128, -80},
    { 1168, 112, -104},
    // 56 seconds
    { 1224, 104, -64},
    { 1080, 168, -72},
    { 832, 176, -112},
    { 608, 184, -136},
    { 488, 168, -128},
    { 512, 160, -128},
    { 592, 168, -128},
    { 792, 200, -200},
    { 1016, 248, -240},
    { 1096, 288, -280},
    { 1168, 296, -264},
    { 1360, 328, -208},
    { 1192, 328, -224},
    { 1064, 288, -152},
    { 1216, 264, -80},
    { 1192, 264, 16},
    { 1056, 248, -8},
    { 872, 184, -16},
    { 680, 128, -16},
    { 632, 96, -16},
    { 640, 104, -24},
    { 696, 120, -40},
    { 856, 96, -56},
    { 1056, 120, -72},
    { 1192, 152, -72},
    // 57 seconds
    { 1296, 152, -64},
    { 1248, 224, -40},
    { 1144, 176, -88},
    { 1088, 136, -80},
    { 1176, 120, -32},
    { 1128, 136, -64},
    { 944, 208, -120},
    { 696, 144, -144},
    { 536, 152, -144},
    { 456, 144, -128},
    { 520, 136, -64},
    { 696, 200, -128},
    { 912, 248, -176},
    { 1144, 272, -240},
    { 1064, 288, -296},
    { 1096, 224, -208},
    { 1416, 296, -240},
    { 1184, 344, -232},
    { 1032, 272, -136},
    { 1120, 288, -152},
    { 1144, 280, -128},
    { 1040, 248, -88},
    { 848, 160, -48},
    { 744, 144, -32},
    { 728, 80, -80},
    // 58 seconds
    { 776, 96, -32},
    { 824, 160, -32},
    { 920, 136, -40},
    { 1112, 112, -64},
    { 1088, 88, -64},
    { 1176, 88, -112},
    { 1160, 136, -24},
    { 1032, 128, -40},
    { 1144, 136, -128},
    { 1256, 152, -112},
    { 1136, 208, -144},
    { 872, 224, -160},
    { 640, 200, -136},
    { 560, 184, -136},
    { 568, 152, -112},
    { 672, 184, -104},
    { 792, 248, -160},
    { 1072, 280, -184},
    { 1064, 312, -248},
    { 1112, 336, -296},
    { 1264, 328, -240},
    { 1144, 344, -256},
    { 976, 280, -208},
    { 1160, 280, -176},
    { 1248, 240, -128},
    // 59 seconds
    { 1216, 216, -40},
    { 960, 192, 24},
    { 736, 168, -32},
    { 704, 72, 8},
    { 744, 184, 16},
    { 864, 184, 64},
    { 896, 72, 120},
    { 1024, 136, 40},
    { 1048, 128, -64},
    { 1048, 88, -120},
    { 1168, 88, -104},
    { 1072, 104, -80},
    { 1080, 128, -80},
    { 1288, 192, -80},
    { 1248, 208, -128},
    { 1000, 224, -144},
    { 728, 216, -160},
    { 576, 200, -144},
    { 536, 184, -120},
    { 608, 176, -136},
    { 744, 216, -184},
    { 992, 240, -264},
    { 1112, 272, -304},
    { 1104, 272, -312},
    { 1328, 304, -256},
    // 60 seconds
    // elapsed: 1 minutes
    { 1328, 336, -256},
    { 1080, 272, -152},
    { 1088, 272, -112},
    { 1128, 288, -136},
    { 1080, 240, -80},
    { 944, 176, -24},
    { 752, 144, -32},
    { 664, 152, -32},
    { 736, 184, 32},
    { 912, 184, 128},
    { 864, 112, 72},
    { 968, 160, 40},
    { 1016, 104, -8},
    { 1024, 48, -32},
    { 1200, 72, -80},
    { 1144, 32, -96},
    { 1072, 72, -104},
    { 1248, 152, -96},
    { 1288, 160, -128},
    { 1096, 208, -160},
    { 736, 160, -208},
    { 568, 200, -192},
    { 496, 240, -96},
    { 616, 168, -136},
    { 784, 336, -160},
    // 61 seconds
    { 936, 280, -208},
    { 1056, 280, -272},
    { 1040, 280, -272},
    { 1184, 280, -224},
    { 1384, 344, -208},
    { 1080, 320, -160},
    { 1048, 280, -96},
    { 1136, 328, -144},
    { 1224, 288, -104},
    { 1056, 232, -72},
    { 840, 224, -56},
    { 744, 120, -96},
    { 736, 80, -72},
    { 752, 64, -40},
    { 808, 40, -8},
    { 864, -32, -8},
    { 1024, 8, -64},
    { 1096, 80, -64},
    { 1136, 16, -112},
    { 1272, 48, -8},
    { 1040, 24, -40},
    { 1216, 120, -104},
    { 1344, 168, -120},
    { 1232, 200, -152},
    { 928, 200, -152},
    // 62 seconds
    { 648, 224, -184},
    { 520, 200, -160},
    { 504, 184, -120},
    { 624, 192, -136},
    { 808, 240, -176},
    { 1032, 304, -248},
    { 1064, 344, -280},
    { 1152, 312, -264},
    { 1360, 328, -248},
    { 1104, 304, -168},
    { 1096, 312, -64},
    { 1200, 296, -8},
    { 1136, 288, 0},
    { 1000, 240, -24},
    { 856, 184, -8},
    { 752, 144, -24},
    { 752, 8, 40},
    { 784, 184, -24},
    { 832, 144, -48},
    { 864, 104, -8},
    { 1016, 112, -40},
    { 1112, 96, -56},
    { 1088, 72, -96},
    { 1160, 112, -96},
    { 1120, 144, -80},
    // 63 seconds
    { 1080, 112, -88},
    { 1304, 168, -48},
    { 1256, 200, -64},
    { 1016, 216, -112},
    { 728, 208, -144},
    { 560, 216, -184},
    { 488, 176, -120},
    { 544, 160, -96},
    { 696, 216, -176},
    { 960, 280, -208},
    { 1168, 280, -312},
    { 1040, 232, -304},
    { 1200, 208, -232},
    { 1440, 304, -288},
    { 1112, 288, -208},
    { 1048, 232, -128},
    { 1112, 288, -144},
    { 1136, 304, -80},
    { 968, 176, 24},
    { 744, 128, 8},
    { 664, 136, 0},
    { 648, 144, 16},
    { 728, 168, 80},
    { 800, 136, 80},
    { 944, 168, 64},
    // 64 seconds
    { 1136, 192, -48},
    { 1128, 80, -32},
    { 1320, 48, -40},
    { 1208, 48, -80},
    { 1112, 88, -136},
    { 1128, 128, -72},
    { 1240, 200, -128},
    { 1104, 240, -144},
    { 808, 184, -216},
    { 568, 136, -160},
    { 464, 200, -144},
    { 496, 160, -128},
    { 560, 48, -24},
    { 752, 208, -184},
    { 992, 272, -200},
    { 1080, 312, -224},
    { 1064, 312, -256},
    { 1304, 344, -216},
    { 1304, 368, -224},
    { 984, 320, -136},
    { 1056, 336, -88},
    { 1160, 312, -96},
    { 1112, 256, -40},
    { 888, 192, -16},
    { 704, 184, -40},
    // 65 seconds
    { 656, 144, -56},
    { 720, 136, -48},
    { 792, 104, -24},
    { 864, 80, -8},
    { 1056, 96, -8},
    { 1120, 80, -32},
    { 1144, 48, -80},
    { 1312, 88, -32},
    { 1192, 88, -8},
    { 1136, 128, -104},
    { 1272, 168, -72},
    { 1208, 184, -128},
    { 920, 200, -168},
    { 608, 152, -168},
    { 480, 144, -144},
    { 472, 144, -128},
    { 600, 176, -112},
    { 728, 248, -216},
    { 912, 288, -240},
    { 1104, 320, -288},
    { 1136, 320, -280},
    { 1264, 328, -208},
    { 1296, 360, -224},
    { 1040, 320, -160},
    { 1128, 288, -96},
    // 66 seconds
    { 1136, 288, -48},
    { 1032, 264, -16},
    { 896, 248, -32},
    { 736, 168, -8},
    { 680, 136, -24},
    { 704, 144, -16},
    { 784, 136, -24},
    { 816, 136, -32},
    { 984, 112, -56},
    { 1048, 80, -64},
    { 1088, 48, -112},
    { 1296, 104, -96},
    { 1208, 152, -88},
    { 1064, 152, -112},
    { 1232, 144, -40},
    { 1240, 200, -32},
    { 1016, 264, -112},
    { 704, 224, -136},
    { 544, 168, -120},
    { 480, 136, -112},
    { 536, 160, -88},
    { 664, 184, -112},
    { 880, 264, -176},
    { 1072, 328, -288},
    { 1032, 352, -336},
    // 67 seconds
    { 1088, 328, -280},
    { 1352, 368, -192},
    { 1200, 352, -176},
    { 1032, 296, -112},
    { 1088, 320, -96},
    { 1176, 296, -80},
    { 1032, 256, -24},
    { 800, 216, -16},
    { 688, 160, -64},
    { 664, 112, -32},
    { 680, 184, -32},
    { 808, 144, -40},
    { 912, 104, -32},
    { 1056, 136, -80},
    { 1144, 112, -80},
    { 1280, 96, -72},
    { 1352, 128, -40},
    { 1096, 120, -56},
    { 1000, 104, -80},
    { 1200, 96, -48},
    { 1160, 176, -64},
    { 920, 208, -112},
    { 640, 176, -128},
    { 496, 160, -136},
    { 472, 144, -120},
    // 68 seconds
    { 600, 160, -88},
    { 760, 208, -176},
    { 976, 256, -248},
    { 1120, 288, -328},
    { 1064, 320, -328},
    { 1296, 344, -208},
    { 1288, 392, -224},
    { 1112, 344, -160},
    { 1048, 336, -96},
    { 1072, 328, -88},
    { 1120, 272, -40},
    { 984, 208, 24},
    { 808, 176, -8},
    { 720, 184, -24},
    { 720, 160, -24},
    { 792, 144, -8},
    { 832, 136, -8},
    { 888, 128, -24},
    { 1024, 184, -96},
    { 1024, 128, -80},
    { 1112, 120, -136},
    { 1224, 152, -144},
    { 1128, 128, -64},
    { 944, 128, -88},
    { 1104, 152, -88},
    // 69 seconds
    { 1128, 208, -64},
    { 984, 216, -72},
    { 776, 192, -64},
    { 648, 224, -120},
    { 608, 264, -104},
    { 688, 232, -96},
    { 784, 328, -112},
    { 872, 312, -224},
    { 1064, 360, -280},
    { 1136, 368, -264},
    { 1216, 352, -248},
    { 1320, 400, -256},
    { 1040, 368, -200},
    { 1048, 328, -112},
    { 1160, 328, -88},
    { 1144, 272, -32},
    { 1008, 168, 88},
    { 840, 136, 48},
    { 712, 120, 48},
    { 672, 48, 32},
    { 736, 208, -32},
    { 832, 184, -24},
    { 928, 104, 0},
    { 1040, 88, -72},
    { 1040, 96, -56},
    // 70 seconds
    { 1256, 136, -88},
    { 1232, 136, -120},
    { 1080, 120, -112},
    { 1080, 176, -120},
    { 1200, 152, -96},
    { 1112, 200, -128},
    { 872, 192, -104},
    { 640, 200, -112},
    { 536, 176, -160},
    { 512, 136, -112},
    { 584, 160, -104},
    { 752, 200, -144},
    { 1016, 312, -216},
    { 1104, 384, -320},
    { 1096, 408, -352},
    { 1376, 312, -280},
    { 1328, 304, -248},
    { 968, 288, -192},
    { 1024, 296, -152},
    { 1152, 264, -104},
    { 1056, 232, -48},
    { 896, 200, -72},
    { 728, 200, -96},
    { 640, 168, -40},
    { 664, 152, -24},
    // 71 seconds
    { 768, 128, -8},
    { 848, 120, 8},
    { 976, 144, -8},
    { 1144, 200, -64},
    { 1112, 104, -56},
    { 1280, 160, -80},
    { 1136, 136, -120},
    { 952, 136, -120},
    { 1104, 184, -144},
    { 1184, 200, -128},
    { 1040, 224, -48},
    { 792, 208, -64},
    { 608, 216, -112},
    { 528, 216, -144},
    { 560, 192, -112},
    { 664, 96, -104},
    { 880, 184, -192},
    { 1072, 240, -240},
    { 1160, 256, -320},
    { 1136, 240, -312},
    { 1312, 264, -256},
    { 1040, 288, -248},
    { 992, 288, -184},
    { 1152, 312, -152},
    { 1160, 320, -88},
    // 72 seconds
    { 1024, 320, -16},
    { 864, 264, -56},
    { 744, 216, -24},
    { 720, 160, 0},
    { 768, 144, -16},
    { 864, 152, -56},
    { 904, 120, -40},
    { 992, 88, -72},
    { 1056, 104, -56},
    { 1136, 48, -72},
    { 1256, 104, -80},
    { 1064, 48, -80},
    { 1112, 80, -80},
    { 1264, 128, -64},
    { 1192, 192, -96},
    { 960, 192, -144},
    { 704, 136, -136},
    { 576, 160, -144},
    { 544, 200, -128},
    { 616, 224, -128},
    { 768, 240, -144},
    { 968, 320, -256},
    { 1056, 344, -296},
    { 1112, 344, -296},
    { 1240, 312, -208},
    // 73 seconds
    { 1360, 392, -232},
    { 1040, 336, -200},
    { 1024, 304, -152},
    { 1136, 280, -136},
    { 1168, 288, -72},
    { 1024, 168, 16},
    { 832, 128, -32},
    { 760, 168, -64},
    { 776, 168, -64},
    { 816, 120, -24},
    { 816, 72, -16},
    { 936, 88, -48},
    { 1016, 136, -88},
    { 936, 104, -120},
    { 1088, 88, -152},
    { 1184, 112, -176},
    { 1104, 104, -192},
    { 1016, 136, -184},
    { 1168, 176, -160},
    { 1208, 216, -144},
    { 1024, 240, -104},
    { 776, 232, -96},
    { 624, 208, -136},
    { 576, 208, -128},
    { 608, 168, -96},
    // 74 seconds
    { 712, 184, -136},
    { 872, 248, -224},
    { 1000, 272, -224},
    { 1080, 320, -264},
    { 1152, 328, -256},
    { 1352, 360, -264},
    { 1104, 328, -248},
    { 1056, 296, -128},
    { 1128, 296, -96},
    { 1088, 232, -48},
    { 1000, 176, 0},
    { 856, 144, -24},
    { 728, 144, -48},
    { 672, 80, -16},
    { 728, 136, -32},
    { 776, 136, -48},
    { 928, 120, -40},
    { 1136, 144, -40},
    { 1144, 136, -48},
    { 1176, 120, -112},
    { 1176, 152, -112},
    { 1056, 128, -104},
    { 1024, 120, -80},
    { 1176, 184, -56},
    { 1160, 208, -96},
    // 75 seconds
    { 1024, 240, -112},
    { 776, 200, -160},
    { 592, 184, -136},
    { 496, 208, -144},
    { 520, 112, -120},
    { 672, 208, -128},
    { 936, 248, -176},
    { 1176, 264, -208},
    { 1104, 280, -256},
    { 1056, 264, -264},
    { 1280, 288, -224},
    { 1096, 288, -184},
    { 952, 240, -104},
    { 1104, 264, -120},
    { 1184, 280, -64},
    { 1112, 240, 32},
    { 904, 192, 8},
    { 744, 184, -56},
    { 664, 144, -32},
    { 728, 128, -32},
    { 824, 104, 0},
    { 912, 56, -32},
    { 1096, 72, -48},
    { 1168, 64, -40},
    { 1168, 64, -72},
    // 76 seconds
    { 1168, 128, -72},
    { 1128, 136, -56},
    { 1064, 136, -80},
    { 1176, 160, -64},
    { 1176, 176, -80},
    { 1008, 216, -112},
    { 744, 232, -136},
    { 560, 208, -128},
    { 480, 168, -128},
    { 520, 152, -112},
    { 664, 208, -144},
    { 920, 240, -216},
    { 1160, 264, -304},
    { 1000, 264, -280},
    { 1088, 248, -232},
    { 1344, 312, -208},
    { 1160, 312, -192},
    { 1080, 280, -96},
    { 1104, 288, -104},
    { 1160, 272, -80},
    { 1000, 208, -32},
    { 776, 160, -16},
    { 680, 160, -48},
    { 648, 136, -16},
    { 744, 112, -8},
    // 77 seconds
    { 848, 56, -8},
    { 912, 48, 0},
    { 1032, 80, -40},
    { 1128, 104, -64},
    { 1336, 144, -24},
    { 1288, 184, 16},
    { 1008, 168, -56},
    { 1176, 88, -40},
    { 1272, 80, -8},
    { 1112, 152, -48},
    { 808, 200, -112},
    { 552, 192, -120},
    { 464, 160, -128},
    { 488, 136, -112},
    { 616, 144, -88},
    { 760, 192, -192},
    { 1008, 216, -248},
    { 1144, 272, -336},
    { 1168, 320, -312},
    { 1248, 328, -224},
    { 1104, 352, -224},
    { 960, 352, -168},
    { 1104, 312, -64},
    { 1296, 296, -32},
    { 1208, 224, 32},
    // 78 seconds
    { 952, 200, 32},
    { 728, 168, -16},
    { 632, 216, -48},
    { 656, 160, -16},
    { 760, 104, 8},
    { 856, 96, 0},
    { 1024, 112, -24},
    { 1112, 160, -72},
    { 1056, 144, -104},
    { 1272, 192, -104},
    { 1240, 152, -40},
    { 1056, 112, -96},
    { 1216, 112, -48},
    { 1272, 160, -64},
    { 1040, 208, -104},
    { 688, 192, -136},
    { 488, 176, -128},
    { 400, 192, -104},
    { 448, 192, -80},
    { 640, 200, -136},
    { 904, 248, -184},
    { 1232, 296, -264},
    { 1040, 320, -304},
    { 1048, 288, -256},
    { 1296, 328, -192},
    // 79 seconds
    { 1128, 312, -184},
    { 1120, 280, -144},
    { 1168, 280, -96},
    { 1240, 296, -112},
    { 1104, 216, -96},
    { 856, 152, -32},
    { 696, 128, -72},
    { 632, 120, -48},
    { 672, 120, -24},
    { 752, 120, 0},
    { 952, 88, 24},
    { 1136, 120, 32},
    { 1128, 160, -8},
    { 1200, 144, -80},
    { 1192, 144, -48},
    { 1048, 136, -96},
    { 1080, 120, -64},
    { 1240, 184, -64},
    { 1216, 216, -144},
    { 952, 232, -168},
    { 656, 192, -184},
    { 504, 168, -168},
    { 456, 144, -128},
    { 512, 160, -112},
    { 656, 208, -176},
    // 80 seconds
    { 944, 296, -224},
    { 1120, 368, -296},
    { 1008, 360, -320},
    { 1336, 344, -232},
    { 1368, 320, -176},
    { 1208, 320, -88},
    { 1120, 320, -104},
    { 1112, 296, -104},
    { 1016, 272, -72},
    { 824, 200, -40},
    { 664, 184, -40},
    { 632, 176, -40},
    { 664, 120, -16},
    { 720, 120, 16},
    { 840, 88, 32},
    { 984, 88, 0},
    { 1128, 104, -64},
    { 1128, 64, -48},
    { 1400, 96, -8},
    { 1256, 96, 8},
    { 1072, 80, -80},
    { 1200, 136, -72},
    { 1232, 136, -56},
    { 1048, 216, -112},
    { 736, 176, -152},
    // 81 seconds
    { 536, 184, -136},
    { 464, 144, -136},
    { 512, 176, -80},
    { 624, 216, -88},
    { 824, 256, -128},
    { 1176, 312, -256},
    { 1112, 280, -280},
    { 1176, 240, -232},
    { 1384, 288, -248},
    { 1168, 272, -272},
    { 968, 240, -152},
    { 1056, 288, -144},
    { 1176, 280, -104},
    { 1128, 216, 8},
    { 896, 168, 24},
    { 736, 192, 24},
    { 688, 104, 24},
    { 688, 152, 32},
    { 792, 120, 32},
    { 888, 120, 24},
    { 1008, 112, -8},
    { 1048, 72, -24},
    { 1128, 40, -24},
    { 1208, 120, -56},
    { 1184, 128, -88},
    // 82 seconds
    { 1008, 128, -72},
    { 1152, 176, -16},
    { 1216, 208, -40},
    { 1032, 248, -80},
    { 744, 232, -88},
    { 584, 200, -96},
    { 528, 216, -96},
    { 568, 192, -88},
    { 720, 200, -168},
    { 832, 200, -232},
    { 1016, 256, -320},
    { 1048, 272, -376},
    { 1112, 248, -248},
    { 1376, 312, -168},
    { 1136, 336, -176},
    { 1088, 312, -96},
    { 1136, 280, -72},
    { 1168, 280, -88},
    { 1080, 232, -56},
    { 912, 184, -16},
    { 776, 168, -40},
    { 720, 80, 0},
    { 704, 216, -24},
    { 776, 120, -16},
    { 808, 104, 0},
    // 83 seconds
    { 952, 88, -48},
    { 1072, 80, -64},
    { 1048, 64, -56},
    { 1232, 120, -56},
    { 1136, 128, 8},
    { 1008, 136, 0},
    { 1240, 184, -24},
    { 1288, 208, -48},
    { 1120, 232, -112},
    { 840, 200, -96},
    { 640, 224, -160},
    { 544, 280, -80},
    { 560, 224, -72},
    { 696, 200, -112},
    { 816, 256, -208},
    { 1000, 256, -240},
    { 1104, 272, -296},
    { 1064, 280, -264},
    { 1288, 288, -200},
    { 1176, 336, -208},
    { 1024, 288, -136},
    { 1208, 272, -72},
    { 1216, 248, 0},
    { 1120, 256, -24},
    { 896, 200, -32},
    // 84 seconds
    { 688, 144, 8},
    { 640, 112, 16},
    { 720, 152, 16},
    { 840, 168, 72},
    { 1104, 136, 120},
    { 1256, 176, 64},
    { 1112, 208, -16},
    { 1176, 136, -24},
    { 1208, 88, -24},
    { 1096, 96, -112},
    { 1040, 72, -128},
    { 1128, 80, -40},
    { 1136, 112, -48},
    { 960, 168, -112},
    { 736, 184, -120},
    { 568, 144, -160},
    { 520, 136, -136},
    { 568, 128, -112},
    { 664, 128, -144},
    { 776, 248, -288},
    { 1048, 296, -328},
    { 1080, 328, -352},
    { 1128, 336, -320},
    { 1432, 400, -288},
    { 1192, 344, -200},
    // 85 seconds
    { 1064, 272, -64},
    { 1200, 256, -48},
    { 1272, 288, 8},
    { 1096, 240, 48},
    { 872, 208, -8},
    { 704, 176, -24},
    { 680, 176, -32},
    { 712, 144, -8},
    { 808, 128, -24},
    { 888, 48, -32},
    { 1040, 64, -48},
    { 1032, 32, -80},
    { 1184, 64, -80},
    { 1304, 128, -56},
    { 1184, 192, -48},
    { 1208, 184, -112},
    { 1272, 176, -112},
    { 1128, 192, -120},
    { 856, 200, -152},
    { 616, 200, -144},
    { 528, 176, -136},
    { 568, 208, -112},
    { 704, 248, -120},
    { 872, 256, -200},
    { 1032, 296, -280},
    // 86 seconds
    { 1088, 304, -344},
    { 1040, 264, -312},
    { 1296, 264, -240},
    { 1328, 272, -232},
    { 1032, 272, -160},
    { 1032, 256, -136},
    { 1160, 280, -136},
    { 1176, 280, -64},
    { 1032, 176, -16},
    { 848, 160, -16},
    { 736, 160, -24},
    { 768, 200, -40},
    { 816, 136, -8},
    { 840, 64, 16},
    { 952, 48, -16},
    { 1048, 56, -104},
    { 1040, -8, -104},
    { 1232, 56, -112},
    { 1216, 72, -112},
    { 1088, 120, -152},
    { 1144, 104, -144},
    { 1272, 136, -64},
    { 1168, 200, -80},
    { 888, 280, -160},
    { 656, 240, -152},
    // 87 seconds
    { 568, 216, -152},
    { 624, 200, -128},
    { 744, 224, -144},
    { 888, 248, -232},
    { 976, 264, -264},
    { 1048, 272, -368},
    { 1080, 200, -352},
    { 1344, 208, -240},
    { 1248, 288, -208},
    { 1016, 336, -176},
    { 1080, 312, -104},
    { 1184, 288, -32},
    { 1136, 248, 48},
    { 960, 208, 48},
    { 808, 192, 48},
    { 728, 168, 8},
    { 736, 168, -32},
    { 744, 120, 0},
    { 816, 64, -16},
    { 976, 96, -72},
    { 1152, 64, -88},
    { 1096, 16, -104},
    { 1288, 56, -136},
    { 1208, 88, -104},
    { 1024, 96, -144},
    // 88 seconds
    { 1160, 128, -128},
    { 1240, 120, -120},
    { 1104, 208, -128},
    { 808, 216, -168},
    { 608, 216, -144},
    { 536, 224, -120},
    { 584, 216, -96},
    { 720, 224, -120},
    { 840, 272, -224},
    { 1032, 328, -288},
    { 1064, 312, -320},
    { 976, 280, -288},
    { 1272, 336, -192},
    { 1248, 344, -184},
    { 1056, 304, -128},
    { 1152, 304, -112},
    { 1208, 288, -80},
    { 1160, 224, -40},
    { 960, 168, 0},
    { 784, 160, -40},
    { 744, 152, -32},
    { 744, 128, 0},
    { 800, 112, -16},
    { 848, 64, -24},
    { 920, 48, -40},
    // 89 seconds
    { 992, 72, -104},
    { 1040, 56, -120},
    { 1208, 88, -128},
    { 1240, 112, -136},
    { 1064, 136, -144},
    { 1072, 120, -144},
    { 1232, 152, -152},
    { 1160, 224, -144},
    { 912, 240, -144},
    { 648, 248, -144},
    { 528, 224, -120},
    { 512, 216, -64},
    { 616, 232, -56},
    { 744, 232, -112},
    { 952, 280, -160},
    { 1136, 368, -304},
    { 976, 312, -288},
    { 1088, 264, -208},
    { 1304, 368, -256},
    { 1136, 336, -200},
    { 1080, 312, -136},
    { 1120, 304, -112},
    { 1184, 280, -88},
    { 1088, 208, -24},
    { 920, 184, 8},
    // 90 seconds
    { 800, 208, -24},
    { 728, 200, -24},
    { 744, 160, -24},
    { 768, 112, -8},
    { 824, 104, -16},
    { 976, 168, -64},
    { 960, 192, -112},
    { 1032, 120, -152},
    { 1176, 128, -144},
    { 1216, 128, -136},
    { 912, 120, -224},
    { 1080, 128, -184},
    { 1232, 136, -136},
    { 1088, 192, -152},
    { 832, 184, -160},
    { 680, 176, -136},
    { 616, 208, -160},
    { 632, 224, -128},
    { 720, 256, -152},
    { 776, 240, -256},
    { 1000, 264, -280},
    { 1096, 288, -328},
    { 1008, 272, -296},
    { 1360, 328, -248},
    { 1264, 328, -272},
    // 91 seconds
    { 960, 240, -176},
    { 1064, 272, -120},
    { 1184, 304, -96},
    { 1216, 272, 16},
    { 1080, 200, 24},
    { 848, 184, 8},
    { 712, 160, -8},
    { 696, 160, 0},
    { 736, 152, -24},
    { 792, 136, -48},
    { 904, 120, -24},
    { 1088, 120, -104},
    { 1048, 40, -64},
    { 1088, 40, -112},
    { 1120, 96, -136},
    { 1128, 128, -120},
    { 976, 120, -112},
    { 1192, 168, -112},
    { 1288, 208, -128},
    { 1056, 224, -128},
    { 760, 184, -120},
    { 608, 224, -144},
    { 576, 216, -128},
    { 648, 224, -104},
    { 768, 240, -176},
    // 92 seconds
    { 920, 304, -240},
    { 1088, 328, -320},
    { 1024, 312, -320},
    { 1072, 272, -232},
    { 1328, 344, -224},
    { 1080, 304, -208},
    { 992, 288, -144},
    { 1128, 280, -120},
    { 1224, 256, -88},
    { 1160, 216, -56},
    { 976, 176, -8},
    { 824, 176, -24},
    { 784, 168, -64},
    { 784, 136, -8},
    { 856, 88, -8},
    { 832, 48, 0},
    { 944, 64, -40},
    { 1032, 72, -104},
    { 1024, 40, -96},
    { 1120, 96, -136},
    { 1160, 120, -96},
    { 1152, 136, -120},
    { 1240, 208, -104},
    { 1264, 208, -144},
    { 1080, 264, -168},
    // 93 seconds
    { 784, 224, -176},
    { 592, 192, -168},
    { 536, 168, -136},
    { 568, 176, -120},
    { 704, 216, -144},
    { 824, 248, -216},
    { 1064, 272, -240},
    { 1056, 288, -320},
    { 1040, 256, -288},
    { 1368, 336, -240},
    { 1216, 304, -200},
    { 1040, 264, -128},
    { 1104, 248, -168},
    { 1192, 280, -104},
    { 1136, 248, -24},
    { 912, 200, 0},
    { 760, 176, -40},
    { 688, 168, -16},
    { 704, 136, -48},
    { 760, 112, -8},
    { 824, 104, -32},
    { 936, 112, -96},
    { 992, 168, -120},
    { 1008, 88, -152},
    { 1240, 184, -208},
    // 94 seconds
    { 1184, 112, -104},
    { 1024, 112, -168},
    { 1128, 176, -128},
    { 1248, 160, -112},
    { 1160, 264, -128},
    { 880, 256, -136},
    { 616, 248, -120},
    { 520, 216, -128},
    { 552, 176, -112},
    { 672, 208, -120},
    { 792, 232, -176},
    { 1008, 288, -240},
    { 1056, 296, -328},
    { 1024, 272, -304},
    { 1328, 336, -232},
    { 1280, 344, -256},
    { 1056, 248, -176},
    { 1088, 272, -136},
    { 1176, 304, -152},
    { 1136, 256, -32},
    { 920, 136, -24},
    { 752, 128, -32},
    { 656, 120, -40},
    { 664, 144, -32},
    { 744, 128, -8},
    // 95 seconds
    { 776, 112, -8},
    { 896, 152, -24},
    { 1072, 152, -120},
    { 1040, 104, -104},
    { 1296, 96, -128},
    { 1280, 128, -88},
    { 1072, 152, -152},
    { 1008, 152, -160},
    { 1184, 168, -128},
    { 1128, 216, -144},
    { 888, 216, -128},
    { 640, 208, -136},
    { 528, 208, -144},
    { 528, 192, -120},
    { 632, 200, -128},
    { 792, 232, -208},
    { 888, 264, -240},
    { 1096, 296, -288},
    { 1000, 296, -312},
    { 1112, 296, -240},
    { 1328, 336, -232},
    { 968, 272, -200},
    { 1112, 280, -176},
    { 1272, 272, -96},
    { 1200, 232, -80},
    // 96 seconds
    { 1032, 192, -32},
    { 800, 152, -32},
    { 696, 152, -40},
    { 648, 152, -16},
    { 680, 120, 0},
    { 784, 144, -8},
    { 936, 128, -16},
    { 1096, 168, -72},
    { 1072, 120, -56},
    { 1168, 72, -88},
    { 1160, 88, -112},
    { 1032, 88, -128},
    { 1008, 112, -128},
    { 1160, 168, -104},
    { 1192, 200, -120},
    { 1008, 208, -112},
    { 744, 208, -128},
    { 600, 192, -136},
    { 552, 152, -120},
    { 616, 192, -104},
    { 720, 216, -168},
    { 840, 232, -208},
    { 1056, 264, -272},
    { 1064, 272, -320},
    { 1088, 256, -272},
    // 97 seconds
    { 1464, 320, -256},
    { 1112, 280, -192},
    { 1040, 272, -128},
    { 1120, 272, -104},
    { 1128, 264, -64},
    { 1016, 200, 0},
    { 824, 192, 0},
    { 696, 168, 0},
    { 656, 160, -16},
    { 744, 144, 0},
    { 816, 120, 8},
    { 920, 136, 0},
    { 1088, 144, -40},
    { 1064, 72, -32},
    { 1048, 16, -104},
    { 1280, 72, -96},
    { 1248, 48, -16},
    { 1000, 88, -136},
    { 1136, 112, -96},
    { 1224, 120, -80},
    { 1056, 216, -136},
    { 768, 184, -136},
    { 584, 184, -144},
    { 536, 160, -128},
    { 608, 176, -136},
    // 98 seconds
    { 720, 216, -192},
    { 824, 200, -200},
    { 1024, 240, -232},
    { 1080, 256, -248},
    { 1096, 256, -272},
    { 1336, 296, -256},
    { 1208, 280, -224},
    { 952, 232, -112},
    { 1064, 248, -112},
    { 1192, 280, -104},
    { 1120, 240, -16},
    { 944, 200, 0},
    { 784, 168, -32},
    { 704, 160, -40},
    { 736, 136, -24},
    { 816, 144, -32},
    { 856, 88, -24},
    { 968, 104, -24},
    { 1088, 160, -104},
    { 1000, 112, -80},
    { 1184, 152, -112},
    { 1072, 168, -64},
    { 1024, 160, -80},
    { 1016, 136, -32},
    { 1168, 200, -80},
    // 99 seconds
    { 1224, 232, -96},
    { 1024, 296, -64},
    { 776, 256, -120},
    { 616, 264, -152},
    { 576, 224, -136},
    { 632, 200, -88},
    { 712, 216, -128},
    { 824, 248, -200},
    { 1024, 344, -280},
    { 1008, 344, -304},
    { 992, 304, -272},
    { 1288, 344, -200},
    { 1200, 328, -192},
    { 1008, 304, -112},
    { 1024, 288, -88},
    { 1200, 280, -72},
    { 1192, 280, 0},
    { 1024, 232, 8},
    { 872, 184, -40},
    { 744, 136, -8},
    { 720, 152, -32},
    { 784, 112, -16},
    { 792, 112, -24},
    { 840, 104, -32},
    { 936, 144, -120},
    // 100 seconds
    { 952, 104, -144},
    { 1168, 96, -152},
    { 1352, 152, -136},
    { 1000, 168, -176},
    { 920, 168, -192},
    { 1184, 200, -104},
    { 1224, 232, -88},
    { 1040, 256, -72},
    { 808, 232, -96},
    { 664, 240, -128},
    { 568, 208, -96},
    { 568, 168, -80},
    { 672, 200, -104},
    { 816, 240, -184},
    { 1016, 280, -288},
    { 1056, 272, -296},
    { 1296, 232, -216},
    { 1440, 360, -176},
    { 1080, 384, -176},
    { 952, 336, -112},
    { 1040, 272, -72},
    { 1064, 288, -80},
    { 1016, 200, -24},
    { 856, 160, -16},
    { 744, 168, -40},
    // 101 seconds
    { 720, 144, -32},
    { 760, 128, -56},
    { 840, 112, -32},
    { 872, 112, -8},
    { 1032, 152, -88},
    { 1064, 168, -152},
    { 1016, 48, -120},
    { 1128, 40, -144},
    { 1072, 80, -144},
    { 1000, 120, -136},
    { 1120, 152, -120},
    { 1288, 200, -80},
    { 1200, 240, -96},
    { 904, 240, -128},
    { 648, 216, -144},
    { 552, 200, -120},
    { 560, 184, -96},
    { 648, 192, -120},
    { 752, 216, -184},
    { 920, 232, -216},
    { 1016, 264, -232},
    { 1072, 264, -240},
    { 1192, 280, -216},
    { 1352, 352, -240},
    { 992, 304, -216},
    // 102 seconds
    { 1008, 240, -112},
    { 1192, 264, -112},
    { 1184, 280, -80},
    { 1056, 224, -40},
    { 896, 200, -40},
    { 760, 192, -48},
    { 696, 160, -32},
    { 720, 120, -24},
    { 768, 136, -24},
    { 800, 112, -16},
    { 936, 128, -40},
    { 1024, 168, -120},
    { 1056, 104, -120},
    { 1200, 160, -128},
    { 1168, 144, -112},
    { 1080, 192, -136},
    { 1088, 184, -144},
    { 1200, 216, -160},
    { 1104, 200, -128},
    { 832, 192, -144},
    { 640, 208, -136},
    { 552, 184, -112},
    { 560, 136, -104},
    { 664, 248, -112},
    { 768, 312, -184},
    // 103 seconds
    { 928, 360, -216},
    { 1040, 360, -264},
    { 1032, 320, -240},
    { 1184, 336, -184},
    { 1208, 376, -208},
    { 976, 320, -184},
    { 976, 328, -144},
    { 1160, 296, -104},
    { 1216, 256, -72},
    { 1056, 200, -16},
    { 864, 192, -32},
    { 736, 184, -48},
    { 728, 184, -40},
    { 792, 104, -72},
    { 848, 112, -40},
    { 880, 88, -24},
    { 1000, 152, -80},
    { 1000, 136, -128},
    { 1152, 152, -112},
    { 1248, 176, -88},
    { 1040, 168, -80},
    { 936, 176, -144},
    { 1152, 192, -112},
    { 1168, 208, -64},
    { 976, 224, -72},
    // 104 seconds
    { 760, 216, -72},
    { 632, 224, -128},
    { 600, 216, -112},
    { 664, 184, -80},
    { 752, 224, -136},
    { 888, 240, -192},
    { 1080, 296, -248},
    { 1024, 280, -280},
    { 1024, 280, -240},
    { 1368, 336, -224},
    { 1232, 336, -208},
    { 960, 280, -128},
    { 1032, 280, -104},
    { 1176, 288, -88},
    { 1104, 232, -48},
    { 960, 200, -32},
    { 808, 168, -48},
    { 736, 104, -56},
    { 728, 136, -48},
    { 768, 144, 0},
    { 832, 144, -8},
    { 984, 176, -16},
    { 1040, 192, -64},
    { 1024, 160, -104},
    { 1192, 176, -144},
    // 105 seconds
    { 1152, 176, -120},
    { 920, 120, -120},
    { 1016, 168, -136},
    { 1176, 192, -152},
    { 1096, 208, -120},
    { 904, 216, -96},
    { 728, 184, -144},
    { 632, 168, -136},
    { 640, 184, -104},
    { 704, 216, -104},
    { 800, 224, -160},
    { 904, 280, -232},
    { 1056, 320, -280},
    { 1056, 312, -264},
    { 1216, 296, -216},
    { 1256, 336, -248},
    { 1064, 304, -200},
    { 1072, 280, -112},
    { 1144, 288, -104},
    { 1112, 264, -72},
    { 1016, 232, -32},
    { 864, 192, -24},
    { 776, 192, -24},
    { 776, 136, -24},
    { 808, 152, -16},
    // 106 seconds
    { 856, 136, -16},
    { 896, 104, -16},
    { 968, 112, -16},
    { 1016, 96, -64},
    { 1080, 72, -96},
    { 1288, 96, -88},
    { 1288, 160, -80},
    { 944, 176, -152},
    { 1024, 208, -200},
    { 1160, 176, -120},
    { 1064, 216, -128},
    { 800, 168, -144},
    { 632, 224, -160},
    { 552, 264, -112},
    { 592, 8, -96},
    { 752, 304, -128},
    { 816, 296, -192},
    { 976, 280, -240},
    { 1104, 272, -296},
    { 976, 224, -280},
    { 1256, 256, -208},
    { 1240, 312, -248},
    { 1048, 288, -168},
    { 1040, 272, -104},
    { 1104, 280, -128},
    // 107 seconds
    { 1128, 264, -88},
    { 1024, 208, -48},
    { 856, 168, -24},
    { 744, 160, -64},
    { 760, 160, -56},
    { 816, 160, -32},
    { 824, 112, -8},
    { 864, 152, -40},
    { 960, 136, -80},
    { 992, 80, -80},
    { 1056, 112, -136},
    { 1096, 128, -152},
    { 1128, 128, -152},
    { 1064, 112, -136},
    { 1120, 152, -144},
    { 1200, 152, -136},
    { 1088, 152, -136},
    { 840, 184, -152},
    { 640, 160, -176},
    { 552, 160, -160},
    { 576, 208, -120},
    { 720, 224, -176},
    { 808, 232, -232},
    { 1016, 224, -288},
    { 1040, 248, -328},
    // 108 seconds
    { 992, 216, -304},
    { 1280, 264, -216},
    { 1296, 312, -232},
    { 992, 248, -168},
    { 1024, 264, -120},
    { 1160, 256, -120},
    { 1208, 264, -88},
    { 1056, 200, -48},
    { 832, 176, -72},
    { 688, 160, -56},
    { 680, 144, -32},
    { 728, 128, -48},
    { 800, 128, -48},
    { 896, 88, -24},
    { 984, 112, -80},
    { 984, 112, -104},
    { 1104, 80, -88},
    { 1168, 96, -112},
    { 1024, 104, -128},
    { 1040, 136, -160},
    { 1144, 144, -88},
    { 1208, 176, -104},
    { 1064, 216, -112},
    { 832, 208, -136},
    { 672, 216, -176},
    // 109 seconds
    { 576, 192, -136},
    { 600, 208, -104},
    { 696, 192, -184},
    { 808, 200, -224},
    { 976, 224, -264},
    { 1016, 224, -304},
    { 1040, 232, -312},
    { 1296, 280, -256},
    { 1280, 288, -288},
    { 1136, 240, -216},
    { 1008, 232, -168},
    { 1048, 264, -144},
    { 1080, 232, -104},
    { 1024, 192, -88},
    { 864, 160, -48},
    { 776, 160, -56},
    { 760, 152, -40},
    { 824, 128, -24},
    { 848, 96, -24},
    { 816, 80, -56},
    { 936, 88, -96},
    { 976, 80, -120},
    { 952, 72, -168},
    { 1128, 112, -248},
    { 1216, 112, -144},
    // 110 seconds
    { 1088, 152, -128},
    { 976, 152, -160},
    { 1152, 192, -128},
    { 1184, 208, -48},
    { 1024, 240, -16},
    { 776, 240, -56},
    { 624, 200, -64},
    { 592, 200, -48},
    { 632, 192, -32},
    { 720, 192, -72},
    { 864, 256, -120},
    { 1000, 264, -216},
    { 992, 304, -288},
    { 1032, 248, -272},
    { 1328, 296, -264},
    { 1352, 360, -224},
    { 1080, 392, -240},
    { 880, 320, -208},
    { 928, 296, -168},
    { 984, 248, -144},
    { 1112, 208, -136},
    { 1040, 112, -40},
    { 952, 80, -56},
    { 976, 120, -72},
    { 896, 136, -32},
    // 111 seconds
    { 856, 152, -48},
    { 800, 128, -72},
    { 752, 104, -88},
    { 792, 96, -120},
    { 832, 80, -168},
    { 776, 48, -168},
    { 1160, 128, -152},
    { 1472, 176, -128},
    { 1200, 200, -224},
    { 856, 216, -216},
    { 984, 216, -152},
    { 1192, 256, -80},
    { 1104, 264, -32},
    { 864, 216, -56},
    { 688, 200, -96},
    { 624, 232, -112},
    { 664, 248, -80},
    { 768, 256, -88},
    { 840, 280, -160},
    { 832, 328, -224},
    { 784, 272, -216},
    { 840, 280, -232},
    { 1104, 248, -208},
    { 1496, 288, -176},
    { 1360, 224, -120},
    // 112 seconds
    { 1016, 128, -80},
    { 832, 48, -16},
    { 896, -8, 32},
    { 912, 24, 8},
    { 928, 8, 56},
    { 928, 48, 72},
    { 960, 72, 104},
    { 976, 8, 128},
    { 1000, 32, 104},
    { 944, 80, 80},
    { 952, 136, 32},
    { 960, 184, 8},
    { 960, 184, -16},
    { 944, 160, 8},
    { 952, 160, -8},
    { 928, 168, -32},
    { 920, 184, -48},
    { 920, 192, -80},
    { 888, 176, -72},
    { 912, 192, -112},
    { 936, 208, -88},
    { 936, 152, -96},
    { 928, 168, -104},
    { 912, 184, -136},
    { 904, 184, -136},
    // 113 seconds
    { 904, 200, -128},
    { 904, 208, -120},
    { 912, 216, -128},
    { 920, 208, -136},
    { 928, 200, -128},
    { 920, 200, -136},
    { 920, 208, -152},
    { 928, 200, -160},
    { 928, 192, -176},
    { 928, 176, -176},
    { 912, 160, -168},
    { 912, 152, -168},
    { 880, 128, -184},
    { 896, 80, -168},
    { 904, 64, -152},
    { 912, 96, -160},
    { 904, 96, -152},
    { 904, 128, -136},
    { 912, 160, -144},
    { 896, 184, -144},
    { 872, 216, -136},
    { 888, 216, -176},
    { 912, 192, -176},
    { 928, 168, -208},
    { 928, 136, -240},
    // 114 seconds
    { 928, 104, -264},
    { 912, 120, -256},
    { 920, 128, -200},
    { 920, 144, -176},
    { 912, 136, -144},
    { 920, 128, -128},
    { 928, 112, -128},
    { 928, 96, -144},
    { 936, 96, -152},
    { 936, 96, -152},
    { 928, 104, -152},
    { 928, 120, -160},
    { 928, 128, -152},
    { 920, 128, -136},
    { 920, 128, -128},
    { 928, 112, -120},
    { 928, 104, -128},
    { 944, 112, -144},
    { 928, 136, -144},
    { 928, 136, -152},
    { 936, 136, -152},
    { 920, 120, -144},
    { 912, 120, -144},
    { 920, 128, -144},
    { 928, 128, -128},
    // 115 seconds
    { 920, 136, -136},
    { 912, 144, -152},
    { 920, 168, -168},
    { 928, 176, -160},
    { 920, 160, -136},
    { 928, 136, -104},
    { 936, 104, -120},
    { 936, 88, -144},
    { 920, 96, -152},
    { 928, 120, -160},
    { 928, 128, -136},
    { 928, 144, -128},
    { 920, 152, -120},
    { 920, 152, -120},
    { 920, 136, -144},
    { 904, 112, -128},
    { 936, 112, -136},
    { 944, 120, -152},
    { 944, 136, -144},
    { 920, 128, -128},
    { 904, 104, -120},
    { 920, 112, -136},
    { 936, 152, -160},
    { 936, 176, -152},
    { 944, 168, -128},
    // 116 seconds
    { 952, 120, -112},
    { 928, 88, -112},
    { 904, 80, -104},
    { 912, 72, -128},
    { 928, 112, -144},
    { 960, 144, -136},
    { 936, 160, -128},
    { 920, 144, -120},
    { 920, 128, -104},
    { 928, 112, -112},
    { 920, 112, -120},
    { 944, 112, -120},
    { 928, 128, -120},
    { 944, 128, -128},
    { 920, 136, -120},
    { 936, 128, -136},
    { 944, 120, -136},
    { 952, 112, -144},
    { 952, 120, -144},
    { 936, 104, -144},
    { 928, 88, -128},
    { 928, 88, -120},
    { 928, 88, -144},
    { 920, 112, -200},
    { 912, 128, -232},
    // 117 seconds
    { 928, 128, -216},
    { 928, 128, -208},
    { 904, 136, -200},
    { 896, 128, -208},
    { 904, 112, -216},
    { 904, 104, -200},
    { 880, 96, -208},
    { 896, 88, -200},
    { 920, 64, -200},
    { 904, 72, -200},
    { 896, 120, -224},
    { 904, 168, -224},
    { 912, 160, -224},
    { 904, 120, -224},
    { 912, 80, -208},
    { 920, 104, -200},
    { 912, 112, -200},
    { 912, 112, -192},
    { 912, 104, -192},
    { 920, 104, -184},
    { 912, 120, -152},
    { 920, 120, -144},
    { 928, 120, -152},
    { 928, 120, -160},
    { 928, 112, -152},
    // 118 seconds
    { 936, 112, -144},
    { 936, 112, -144},
    { 936, 112, -128},
    { 944, 104, -104},
    { 960, 120, -112},
    { 944, 104, -104},
    { 928, 104, -88},
    { 928, 112, -96},
    { 920, 136, -96},
    { 936, 160, -96},
    { 936, 176, -96},
    { 928, 160, -96},
    { 912, 184, -88},
    { 920, 168, -96},
    { 936, 176, -88},
    { 936, 176, -96},
    { 936, 176, -88},
    { 912, 176, -88},
    { 888, 176, -80},
    { 904, 184, -80},
    { 912, 184, -72},
    { 928, 192, -80},
    { 928, 192, -80},
    { 944, 184, -88},
    { 936, 184, -72},
    // 119 seconds
    { 920, 208, -96},
    { 904, 200, -96},
    { 896, 192, -96},
    { 904, 192, -104},
    { 904, 208, -96},
    { 920, 216, -112},
    { 920, 208, -104},
    { 920, 200, -96},
    { 928, 184, -96},
    { 928, 144, -80},
    { 888, 168, -88},
    { 896, 200, -104},
    { 896, 208, -96},
    { 936, 216, -112},
    { 928, 224, -120},
    { 920, 208, -144},
    { 904, 200, -136},
    { 912, 208, -144},
    { 912, 200, -120},
    { 920, 176, -104},
    { 904, 184, -72},
    { 912, 176, -88},
    { 904, 192, -72},
    { 904, 192, -96},
    { 912, 192, -88},
    // 120 seconds
    // elapsed: 2 minutes
    { 920, 200, -104},
    { 904, 216, -112},
    { 912, 200, -112},
    { 912, 176, -112},
    { 896, 184, -128},
    { 888, 208, -104},
    { 904, 216, -112},
    { 912, 208, -112},
    { 904, 208, -112},
    { 904, 200, -120},
    { 896, 216, -136},
    { 880, 200, -136},
    { 904, 192, -120},
    { 960, 168, -112},
    { 936, 144, -104},
    { 904, 160, -104},
    { 912, 192, -104},
    { 936, 224, -104},
    { 904, 216, -88},
    { 896, 208, -72},
    { 888, 224, -72},
    { 880, 232, -72},
    { 848, 216, -72},
    { 856, 200, -88},
    { 864, 232, -112},
    // 121 seconds
    { 856, 224, -136},
    { 872, 192, -136},
    { 912, 200, -152},
    { 984, 184, -144},
    { 1048, 176, -136},
    { 1168, 176, -128},
    { 1304, 160, -128},
    { 1184, 136, -8},
    { 808, 72, 8},
    { 608, -24, 24},
    { 856, -56, 72},
    { 1184, 8, 80},
    { 1216, 96, 24},
    { 976, 96, -40},
    { 752, 104, -96},
    { 608, 112, -128},
    { 560, 80, -112},
    { 640, 112, -144},
    { 776, 160, -168},
    { 944, 176, -208},
    { 1016, 192, -240},
    { 1032, 216, -288},
    { 1112, 216, -256},
    { 1184, 208, -192},
    { 1376, 288, -176},
    // 122 seconds
    { 1192, 320, -216},
    { 1176, 240, -104},
    { 1200, 184, -48},
    { 992, 160, 32},
    { 744, 152, -16},
    { 640, 136, -32},
    { 664, 104, 8},
    { 752, 88, 0},
    { 888, 104, -24},
    { 1128, 112, -40},
    { 1272, 120, -48},
    { 1296, 88, -64},
    { 1184, 72, -72},
    { 1232, 88, -32},
    { 1128, 96, 16},
    { 1176, 88, -24},
    { 1184, 112, -24},
    { 1088, 128, -32},
    { 896, 176, -96},
    { 672, 152, -112},
    { 528, 144, -128},
    { 440, 136, -112},
    { 464, 144, -96},
    { 608, 176, -128},
    { 920, 208, -200},
    // 123 seconds
    { 1200, 280, -272},
    { 1216, 256, -280},
    { 1336, 248, -240},
    { 1288, 296, -224},
    { 1072, 320, -224},
    { 1008, 296, -184},
    { 1024, 296, -136},
    { 1088, 256, -80},
    { 952, 224, -40},
    { 800, 192, -48},
    { 680, 152, -32},
    { 640, 120, -32},
    { 728, 128, -40},
    { 912, 104, -16},
    { 1088, 88, 8},
    { 1224, 216, -40},
    { 1264, 176, -64},
    { 1224, 80, -24},
    { 1248, 112, -8},
    { 1112, 112, -64},
    { 1008, 64, -88},
    { 1112, 80, -8},
    { 1120, 128, -40},
    { 984, 192, -80},
    { 744, 208, -120},
    // 124 seconds
    { 544, 184, -128},
    { 432, 176, -136},
    { 464, 136, -112},
    { 616, 136, -128},
    { 928, 192, -192},
    { 1216, 256, -280},
    { 1192, 280, -296},
    { 1208, 264, -264},
    { 1336, 312, -248},
    { 1088, 288, -264},
    { 928, 256, -208},
    { 1000, 248, -128},
    { 1152, 248, -88},
    { 1072, 240, -24},
    { 888, 200, 0},
    { 728, 176, -24},
    { 688, 152, -24},
    { 712, 120, 0},
    { 832, 112, 24},
    { 952, 120, 40},
    { 1144, 104, 16},
    { 1096, 40, 8},
    { 1152, 32, -32},
    { 1352, 120, -48},
    { 1184, 120, -56},
    // 125 seconds
    { 1064, 112, -104},
    { 1208, 120, -72},
    { 1192, 160, -88},
    { 984, 216, -120},
    { 696, 192, -168},
    { 504, 152, -160},
    { 440, 112, -112},
    { 512, 144, -120},
    { 688, 184, -144},
    { 896, 200, -192},
    { 1168, 272, -272},
    { 1088, 280, -328},
    { 1160, 264, -264},
    { 1288, 296, -248},
    { 1096, 288, -216},
    { 984, 256, -136},
    { 1096, 280, -96},
    { 1232, 328, -96},
    { 1136, 272, -64},
    { 888, 184, -24},
    { 672, 144, -16},
    { 592, 128, -64},
    { 640, 168, -80},
    { 784, 112, -40},
    { 1024, 40, -32},
    // 126 seconds
    { 1224, 96, -48},
    { 1128, 160, -64},
    { 1048, 160, -128},
    { 1112, 184, -104},
    { 1040, 136, -88},
    { 1168, 48, -96},
    { 1304, 136, -80},
    { 1200, 184, -104},
    { 872, 232, -104},
    { 600, 208, -128},
    { 504, 208, -168},
    { 512, 200, -88},
    { 624, 224, -88},
    { 760, 224, -176},
    { 904, 288, -232},
    { 1080, 320, -304},
    { 1088, 280, -280},
    { 1392, 288, -216},
    { 1208, 304, -232},
    { 1184, 296, -152},
    { 1248, 304, -88},
    { 1208, 264, -72},
    { 1040, 248, -32},
    { 784, 200, -48},
    { 656, 160, -40},
    // 127 seconds
    { 624, 32, 24},
    { 688, 136, 0},
    { 760, 120, -16},
    { 800, 96, -48},
    { 952, 80, -32},
    { 1048, 64, -40},
    { 1032, 104, -56},
    { 1208, 128, -80},
    { 1160, 152, -32},
    { 1136, 144, -72},
    { 1360, 176, -56},
    { 1416, 216, -96},
    { 1136, 256, -144},
    { 704, 216, -152},
    { 496, 176, -168},
    { 424, 160, -136},
    { 488, 160, -104},
    { 608, 176, -168},
    { 800, 216, -232},
    { 984, 216, -232},
    { 1056, 248, -248},
    { 1096, 240, -216},
    { 1320, 288, -184},
    { 1280, 344, -232},
    { 1264, 296, -112},
    // 128 seconds
    { 1336, 272, -48},
    { 1264, 288, 8},
    { 1032, 248, -48},
    { 776, 176, -16},
    { 656, 136, 8},
    { 632, 64, 16},
    { 664, 80, 24},
    { 784, 96, -8},
    { 800, 64, -16},
    { 904, 40, 8},
    { 1000, 64, -16},
    { 912, 64, -32},
    { 1312, 144, -48},
    { 1344, 152, 40},
    { 1528, 168, -16},
    { 1600, 240, -96},
    { 1320, 264, -184},
    { 848, 200, -144},
    { 544, 136, -184},
    { 400, 128, -176},
    { 416, 128, -120},
    { 560, 176, -160},
    { 776, 264, -256},
    { 960, 376, -272},
    { 1024, 416, -320},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

