/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:58:08 local
AccelRawData *activity_sample_walk_200_pbl_25669_7(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25669_7
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -96, -16, -920},
    { -64, -24, -904},
    { -72, 32, -952},
    { -64, 8, -928},
    { -80, -40, -936},
    { -80, -32, -896},
    { -112, -8, -904},
    { -144, -32, -880},
    { -192, -24, -944},
    { -168, -16, -928},
    { -176, -112, -912},
    { -176, 32, -1000},
    { -96, -192, -808},
    { -104, 192, -1040},
    { -216, -32, -856},
    { -112, 24, -920},
    { -120, 16, -912},
    { -88, 64, -912},
    { -88, 8, -920},
    { -88, 32, -904},
    { -80, 16, -920},
    { -72, 0, -808},
    { 0, 392, -896},
    { 56, 296, -536},
    { 160, 904, -704},
    // 1 seconds
    { 160, 704, -432},
    { 192, 928, -280},
    { 200, 1040, -232},
    { 264, 896, -32},
    { 240, 1312, -176},
    { 240, 768, 200},
    { 256, 1176, 32},
    { 224, 968, 128},
    { 184, 864, 200},
    { 200, 1088, 40},
    { 200, 856, 208},
    { 200, 984, 128},
    { 224, 952, 136},
    { 200, 952, 144},
    { 232, 1032, 56},
    { 248, 1328, -40},
    { 264, 824, 8},
    { 256, 1048, -336},
    { 256, 560, -240},
    { 264, 768, -560},
    { 264, 544, -560},
    { 256, 656, -680},
    { 256, 368, -632},
    { 296, 544, -808},
    { 288, 408, -704},
    // 2 seconds
    { 264, 504, -864},
    { 240, 328, -784},
    { 224, 344, -840},
    { 216, 336, -808},
    { 240, 344, -840},
    { 240, 344, -792},
    { 256, 344, -784},
    { 256, 384, -792},
    { 256, 360, -720},
    { 256, 384, -688},
    { 256, 600, -816},
    { 248, 440, -448},
    { 232, 944, -576},
    { 288, 984, -424},
    { 296, 848, -272},
    { 344, 952, -240},
    { 312, 880, -112},
    { 288, 968, -88},
    { 272, 888, 40},
    { 288, 1040, -24},
    { 272, 872, 120},
    { 288, 1032, 24},
    { 272, 872, 176},
    { 280, 960, 88},
    { 272, 920, 120},
    // 3 seconds
    { 264, 912, 128},
    { 264, 1008, 104},
    { 272, 928, 128},
    { 280, 920, 168},
    { 296, 1000, 120},
    { 288, 920, 176},
    { 312, 904, 152},
    { 304, 984, 96},
    { 320, 840, 168},
    { 344, 928, 72},
    { 336, 904, 136},
    { 320, 872, 144},
    { 320, 912, 88},
    { 352, 872, 88},
    { 384, 880, 72},
    { 336, 944, 184},
    { 336, 992, 104},
    { 416, 936, 72},
    { 480, 832, 48},
    { 464, 808, 64},
    { 432, 840, 80},
    { 392, 832, 32},
    { 392, 832, 16},
    { 424, 760, 120},
    { 296, 912, -80},
    // 4 seconds
    { 416, 936, 72},
    { 368, 1096, 136},
    { 176, 1208, 296},
    { 352, 1288, 296},
    { 360, 1296, 376},
    { 336, 888, 248},
    { 272, 776, 304},
    { 184, 784, 224},
    { 264, 664, 232},
    { 256, 768, 232},
    { 376, 672, 248},
    { 424, 1088, -16},
    { 448, 952, 224},
    { 264, 1248, 312},
    { 256, 1328, 368},
    { 256, 1384, 376},
    { 240, 1096, 16},
    { 264, 872, 184},
    { 208, 840, 120},
    { 200, 688, 96},
    { 288, 640, 64},
    { 320, 664, 104},
    { 344, 648, 160},
    { 392, 720, 304},
    { 328, 848, 224},
    // 5 seconds
    { 496, 1152, 272},
    { 336, 1208, 432},
    { 392, 1520, 296},
    { 216, 1040, 376},
    { 376, 1048, 232},
    { 256, 888, 288},
    { 248, 720, 264},
    { 256, 584, 168},
    { 304, 600, 192},
    { 352, 664, 288},
    { 256, 712, 304},
    { 128, 920, 248},
    { 184, 1168, 360},
    { 240, 1176, 176},
    { 32, 1168, 376},
    { 88, 1192, 216},
    { 120, 912, 128},
    { 184, 816, 80},
    { 312, 624, 16},
    { 384, 544, 48},
    { 392, 624, 72},
    { 392, 968, 176},
    { 544, 1168, -96},
    { 520, 1152, 184},
    { 248, 1056, 456},
    // 6 seconds
    { 272, 1440, 640},
    { -8, 1296, 400},
    { 240, 1200, 384},
    { 200, 848, 200},
    { 208, 664, 152},
    { 272, 536, 168},
    { 280, 576, 152},
    { 296, 688, 368},
    { 32, 912, 344},
    { 104, 1064, 336},
    { 48, 1256, 344},
    { 80, 1200, 80},
    { 24, 1048, 368},
    { 32, 1192, 64},
    { 144, 1096, 72},
    { 184, 816, 88},
    { 240, 664, -16},
    { 304, 544, -16},
    { 336, 528, 80},
    { 312, 720, 40},
    { 144, 816, 112},
    { 376, 1160, 120},
    { 216, 1232, 280},
    { 352, 1304, 416},
    { 72, 1416, 424},
    // 7 seconds
    { 192, 1192, 312},
    { 112, 912, 272},
    { 112, 760, 144},
    { 216, 632, 112},
    { 264, 776, 112},
    { 392, 1080, 16},
    { 232, 944, 136},
    { 128, 1016, 280},
    { 64, 1296, 232},
    { 80, 1192, 96},
    { -64, 1104, 224},
    { 56, 1176, 8},
    { 56, 1120, 72},
    { 112, 904, 88},
    { 184, 792, -16},
    { 240, 608, -8},
    { 256, 576, 56},
    { 288, 880, 80},
    { 368, 1144, 112},
    { 344, 1344, 216},
    { 168, 1296, 320},
    { 280, 1016, 320},
    { 192, 1256, 200},
    { 152, 1056, 416},
    { 104, 1192, 344},
    // 8 seconds
    { 40, 896, 296},
    { 120, 704, 144},
    { 224, 584, 80},
    { 264, 576, 200},
    { 248, 632, 200},
    { -72, 920, 176},
    { 72, 1168, 320},
    { -8, 1112, 328},
    { -32, 1136, 184},
    { -56, 920, 248},
    { 0, 1224, 32},
    { 48, 1008, 240},
    { 120, 968, 144},
    { 240, 800, 8},
    { 272, 552, 48},
    { 264, 680, 80},
    { 184, 752, 96},
    { 328, 1288, 24},
    { 328, 1472, 192},
    { 24, 1048, 424},
    { 288, 1232, 288},
    { 72, 1360, 384},
    { 16, 1304, 472},
    { -8, 1168, 344},
    { 48, 832, 160},
    // 9 seconds
    { 184, 536, 104},
    { 208, 672, 80},
    { 232, 632, 256},
    { 112, 1032, 104},
    { -112, 544, 224},
    { 16, 1128, 88},
    { -48, 1120, 208},
    { -136, 1112, 208},
    { -48, 1224, 136},
    { 16, 1008, 8},
    { 40, 936, 144},
    { 128, 800, 56},
    { 240, 608, -40},
    { 288, 560, 32},
    { 288, 752, 72},
    { 296, 880, 160},
    { 296, 1304, -216},
    { 88, 984, 248},
    { 64, 1096, 120},
    { 112, 1400, 304},
    { -224, 1360, 280},
    { -24, 1224, 464},
    { 8, 976, 320},
    { 96, 752, 168},
    { 136, 536, 144},
    // 10 seconds
    { 184, 576, 144},
    { 208, 600, 224},
    { 120, 504, 200},
    { -32, 1232, 280},
    { -64, 1104, 288},
    { 120, 1336, 264},
    { -144, 1240, 400},
    { 32, 1256, 48},
    { 56, 992, 144},
    { 64, 952, 88},
    { 136, 752, 32},
    { 200, 632, 16},
    { 216, 624, 72},
    { 232, 808, 72},
    { 264, 840, 168},
    { 208, 576, 120},
    { 72, 1272, 136},
    { 48, 1136, 312},
    { 64, 1552, 536},
    { -152, 1312, 184},
    { 32, 1120, 392},
    { 72, 880, 224},
    { 104, 640, 136},
    { 176, 512, 112},
    { 248, 632, 112},
    // 11 seconds
    { 192, 1024, 168},
    { 8, 976, 0},
    { 24, 1120, 160},
    { -80, 1064, 248},
    { -32, 1088, 64},
    { -136, 1280, 408},
    { -96, 1216, 160},
    { 40, 1000, 0},
    { 80, 832, 136},
    { 96, 856, 48},
    { 184, 680, 16},
    { 200, 672, 32},
    { 208, 792, 64},
    { 232, 1016, 168},
    { 288, 952, 408},
    { 248, 1432, 256},
    { 112, 1392, 256},
    { 32, 1472, 544},
    { -104, 1344, 368},
    { -16, 1008, 256},
    { -72, 736, 264},
    { 64, 688, 120},
    { 152, 544, 184},
    { 176, 728, 200},
    { 192, 752, 256},
    // 12 seconds
    { 192, 736, 360},
    { 200, 832, 112},
    { -16, 1264, 312},
    { -80, 1240, 160},
    { -96, 1408, 368},
    { -96, 1272, 184},
    { -32, 1120, 56},
    { 16, 944, 72},
    { 64, 904, 48},
    { 160, 712, -8},
    { 208, 664, -24},
    { 208, 696, 88},
    { 168, 880, 120},
    { 160, 1120, 200},
    { 248, 1352, -88},
    { 40, 1168, 104},
    { 152, 1160, 352},
    { 56, 1728, 536},
    { -8, 1448, 464},
    { -8, 1032, 416},
    { 24, 768, 240},
    { 120, 584, 176},
    { 200, 592, 168},
    { 232, 712, 224},
    { 152, 992, 176},
    // 13 seconds
    { 80, 1024, 304},
    { 64, 992, 200},
    { -112, 1144, 48},
    { -64, 1280, 344},
    { -184, 1200, 408},
    { -136, 1128, 112},
    { -96, 984, 288},
    { -8, 888, 112},
    { 64, 664, 24},
    { 192, 640, -8},
    { 200, 720, 72},
    { 264, 872, 160},
    { 248, 944, 80},
    { 280, 1192, 136},
    { 72, 1288, 368},
    { 144, 1280, 544},
    { -128, 1504, 264},
    { -8, 1168, 456},
    { -112, 952, 352},
    { -112, 848, 208},
    { 56, 576, 160},
    { 176, 568, 168},
    { 168, 672, 184},
    { 128, 736, 384},
    { -64, 848, 160},
    // 14 seconds
    { -96, 1208, 240},
    { -184, 1064, 296},
    { -80, 1120, 432},
    { -120, 1072, 304},
    { 112, 1288, 40},
    { 24, 936, 184},
    { 0, 952, 80},
    { 64, 728, 88},
    { 112, 680, 40},
    { 144, 736, 56},
    { 144, 784, 184},
    { 200, 856, 56},
    { 200, 992, 200},
    { 72, 1176, 256},
    { 160, 1400, 520},
    { 48, 1440, 512},
    { -32, 1296, 424},
    { -24, 1160, 424},
    { 24, 816, 288},
    { 96, 688, 152},
    { 144, 584, 152},
    { 192, 824, 232},
    { 120, 1032, 224},
    { 112, 968, 144},
    { 8, 1008, 512},
    // 15 seconds
    { -64, 1176, 304},
    { 80, 1160, 304},
    { -120, 1144, 360},
    { -104, 1216, 152},
    { -40, 1008, 192},
    { 16, 920, 176},
    { 112, 768, 48},
    { 200, 576, 72},
    { 232, 712, 80},
    { 280, 936, 184},
    { 168, 1096, 120},
    { 208, 1040, 248},
    { 144, 1272, 320},
    { 40, 1384, 488},
    { -104, 1368, 520},
    { 16, 1088, 336},
    { 88, 896, 232},
    { 120, 760, 200},
    { 128, 600, 216},
    { 112, 760, 128},
    { 88, 800, 216},
    { 120, 848, 328},
    { 16, 1016, 296},
    { 80, 1152, 392},
    { -104, 1208, 248},
    // 16 seconds
    { -192, 1320, 408},
    { -320, 1112, 296},
    { -152, 1248, 8},
    { -120, 784, 200},
    { 8, 1096, 64},
    { 104, 736, -72},
    { 144, 672, 0},
    { 112, 696, 160},
    { 168, 1160, 312},
    { 240, 1040, 232},
    { 280, 1184, 352},
    { 128, 1280, 488},
    { 72, 1312, 680},
    { -40, 1112, 384},
    { 128, 904, 408},
    { 152, 944, 216},
    { 112, 728, 88},
    { 232, 616, 304},
    { 200, 776, 416},
    { 128, 984, 464},
    { 112, 1032, 304},
    { 16, 1088, 376},
    { -56, 1056, 440},
    { 24, 1200, 232},
    { -88, 1096, 472},
    // 17 seconds
    { -104, 1152, 200},
    { -8, 920, 144},
    { -24, 832, 208},
    { 40, 848, -72},
    { 160, 528, -136},
    { 216, 656, 112},
    { 200, 904, 232},
    { 224, 1024, 64},
    { 232, 944, 240},
    { 88, 1232, 336},
    { -48, 1416, 608},
    { -168, 1472, 584},
    { -24, 1264, 472},
    { 0, 1024, 400},
    { 80, 832, 368},
    { 56, 496, 264},
    { 48, 456, 144},
    { 128, 672, 80},
    { 96, 744, 336},
    { -8, 1104, 208},
    { -144, 1064, 368},
    { -216, 1256, 288},
    { -88, 1120, 264},
    { -96, 968, 336},
    { -64, 1120, 208},
    // 18 seconds
    { -24, 1048, 192},
    { 72, 872, 136},
    { 208, 624, 136},
    { 256, 576, 344},
    { 144, 832, -32},
    { 128, 776, 376},
    { 176, 1128, 192},
    { 96, 1328, 208},
    { 16, 1136, 464},
    { -24, 1408, 376},
    { -80, 1280, 392},
    { -64, 1120, 400},
    { -48, 920, 288},
    { 32, 592, 224},
    { 16, 632, 184},
    { -16, 464, 88},
    { 152, 792, 312},
    { 0, 1072, 440},
    { -32, 1024, 312},
    { -32, 1160, 312},
    { -48, 1304, 352},
    { -136, 1056, 352},
    { -56, 1096, 0},
    { -64, 840, 136},
    { -40, 920, 88},
    // 19 seconds
    { 88, 688, -16},
    { 168, 584, 0},
    { 232, 280, 96},
    { 120, 984, 0},
    { 136, 1048, 232},
    { 296, 1368, 200},
    { 72, 1352, 384},
    { -40, 1480, 376},
    { 8, 1208, 328},
    { 88, 1000, 280},
    { 40, 784, 328},
    { 72, 664, 240},
    { 152, 560, 192},
    { 144, 720, 104},
    { 24, 832, 88},
    { 64, 928, 256},
    { 16, 1024, 184},
    { -56, 1088, 312},
    { 0, 1160, 224},
    { -224, 1152, 328},
    { -248, 1264, 136},
    { -136, 976, 32},
    { -48, 936, -40},
    { 120, 816, -56},
    { 88, 760, -200},
    // 20 seconds
    { 56, 472, -168},
    { 208, 896, 56},
    { 152, 872, 256},
    { 184, 944, 152},
    { 224, 1032, 320},
    { 64, 1184, 472},
    { -48, 1592, 624},
    { -64, 1344, 448},
    { 24, 1040, 328},
    { 32, 840, 224},
    { 72, 616, 168},
    { 136, 624, 152},
    { 160, 808, 264},
    { 176, 1000, 168},
    { 80, 1024, 240},
    { 8, 1000, 304},
    { 0, 1040, 328},
    { 0, 1008, 296},
    { -144, 1272, 288},
    { -144, 1136, 328},
    { -48, 1144, 216},
    { -40, 968, 232},
    { 80, 768, 112},
    { 200, 568, 104},
    { 240, 408, 72},
    // 21 seconds
    { 176, 712, 88},
    { 176, 952, 304},
    { 240, 992, 368},
    { 80, 1280, 384},
    { -16, 1104, 456},
    { 32, 1416, 416},
    { -120, 1176, 400},
    { 16, 1024, 336},
    { 24, 824, 336},
    { 40, 648, 208},
    { 152, 592, 200},
    { 192, 600, 272},
    { 208, 984, 408},
    { 80, 1136, 392},
    { 64, 1088, 336},
    { -64, 1088, 424},
    { -136, 1216, 304},
    { -224, 1176, 488},
    { -56, 1160, 64},
    { -104, 800, 136},
    { -112, 904, 144},
    { 40, 720, 64},
    { 128, 840, -80},
    { 40, 616, -40},
    { 216, 728, 40},
    // 22 seconds
    { 184, 920, 328},
    { 192, 968, 208},
    { 56, 1192, 456},
    { -80, 1304, 480},
    { -192, 1576, 504},
    { -56, 1256, 480},
    { 0, 1008, 336},
    { 8, 816, 320},
    { 56, 624, 224},
    { 104, 552, 200},
    { 232, 520, 192},
    { -16, 696, 304},
    { -32, 968, 328},
    { -40, 1104, 392},
    { -152, 1184, 264},
    { -208, 1312, 328},
    { -312, 1088, 408},
    { -80, 1256, 8},
    { -120, 840, 192},
    { -64, 888, 104},
    { 48, 872, 48},
    { 144, 416, -96},
    { 216, 672, 48},
    { 192, 832, 208},
    { 168, 1048, 296},
    // 23 seconds
    { 288, 1240, 224},
    { 48, 1168, 296},
    { 168, 1248, 472},
    { 8, 1296, 408},
    { 96, 1240, 408},
    { 64, 1064, 384},
    { 40, 832, 304},
    { 72, 600, 184},
    { 160, 480, 176},
    { 80, 488, 144},
    { 48, 720, 344},
    { 48, 1064, 320},
    { 16, 1176, 336},
    { -120, 1000, 280},
    { -80, 1200, 480},
    { -64, 1192, 184},
    { -8, 952, 192},
    { -80, 1008, 168},
    { -8, 1048, 56},
    { 72, 584, -152},
    { 184, 632, -40},
    { 216, 600, 112},
    { 168, 752, 128},
    { 152, 1016, 240},
    { 200, 1112, 288},
    // 24 seconds
    { -40, 1240, 376},
    { -48, 1640, 496},
    { -176, 1320, 432},
    { -8, 1152, 288},
    { -8, 912, 224},
    { 64, 736, 200},
    { 152, 640, 160},
    { 64, 464, 112},
    { 40, 736, 240},
    { 32, 872, 216},
    { 32, 1088, 232},
    { -48, 1208, 400},
    { -32, 1176, 232},
    { -224, 1240, 408},
    { -208, 1216, 304},
    { -136, 1056, 24},
    { -72, 760, 144},
    { 32, 784, 48},
    { 120, 640, 40},
    { 168, 616, 88},
    { 168, 736, -64},
    { 176, 960, 152},
    { 208, 960, 136},
    { 272, 1000, 208},
    { 208, 1136, 192},
    // 25 seconds
    { 200, 1128, 416},
    { 80, 1448, 448},
    { 8, 1312, 360},
    { 112, 1016, 272},
    { 112, 840, 200},
    { 120, 640, 176},
    { 144, 624, 168},
    { 192, 736, 240},
    { 152, 888, 112},
    { 80, 1088, 176},
    { 72, 1000, 224},
    { 8, 976, 232},
    { -32, 1360, 184},
    { -192, 1224, 408},
    { -152, 1224, -16},
    { -104, 920, 56},
    { -112, 880, 104},
    { 16, 792, 0},
    { 104, 656, -8},
    { 112, 704, -80},
    { 80, 688, -200},
    { 80, 920, -8},
    { 192, 952, 112},
    { 296, 928, 176},
    { 96, 1128, 224},
    // 26 seconds
    { 96, 1344, 544},
    { -296, 1696, 568},
    { -16, 1208, 336},
    { 112, 864, 232},
    { 120, 832, 232},
    { 80, 800, 200},
    { 112, 696, 184},
    { 128, 656, 216},
    { 168, 760, 216},
    { 160, 928, 256},
    { 176, 1064, 272},
    { 120, 1000, 272},
    { 16, 1176, 384},
    { -88, 1496, 200},
    { -176, 1360, 272},
    { -200, 1104, 8},
    { -176, 840, 56},
    { -104, 840, 0},
    { 32, 672, 8},
    { 88, 608, 24},
    { 152, 632, 64},
    { 152, 808, 160},
    { 104, 1080, 264},
    { 192, 1104, -80},
    { 288, 912, 80},
    // 27 seconds
    { 224, 1056, 168},
    { 112, 1128, 168},
    { 312, 1504, 256},
    { -256, 1672, 376},
    { 112, 1064, 256},
    { 72, 992, 240},
    { -32, 880, 272},
    { 72, 656, 184},
    { 120, 680, 176},
    { 120, 664, 272},
    { 40, 584, 288},
    { 64, 648, 176},
    { 152, 936, 216},
    { 32, 1080, 208},
    { -64, 1344, 224},
    { -160, 1232, 336},
    { -80, 1296, -112},
    { -120, 800, -8},
    { -120, 912, 40},
    { 16, 1008, 8},
    { 104, 784, -24},
    { 184, 680, -56},
    { 184, 712, 24},
    { 96, 544, 312},
    { 80, 792, -120},
    // 28 seconds
    { 168, 824, 240},
    { 224, 1096, 216},
    { 32, 1168, 176},
    { 160, 1208, 216},
    { -24, 1520, 416},
    { -56, 1480, 440},
    { -8, 1264, 296},
    { 8, 976, 192},
    { 88, 624, 144},
    { 160, 512, 96},
    { 112, 576, 192},
    { 104, 784, 168},
    { 144, 880, 176},
    { 224, 1024, 64},
    { 168, 1120, 176},
    { 16, 1040, 208},
    { -160, 1256, 280},
    { -232, 1408, 128},
    { -192, 1112, 184},
    { -208, 984, 48},
    { -176, 928, 56},
    { -64, 872, 32},
    { 8, 760, 72},
    { 24, 712, 64},
    { 56, 744, 80},
    // 29 seconds
    { 88, 792, 160},
    { 48, 736, 112},
    { 136, 816, 160},
    { 160, 888, 168},
    { 232, 1064, 224},
    { 48, 1136, 288},
    { 72, 1576, 376},
    { -224, 1568, 320},
    { -16, 1136, 256},
    { 16, 1072, 216},
    { -32, 904, 176},
    { 8, 672, 144},
    { 32, 640, 168},
    { 48, 704, 200},
    { 48, 832, 296},
    { 104, 984, 248},
    { 112, 800, 112},
    { 176, 912, 224},
    { 64, 936, 184},
    { 0, 1104, 64},
    { -176, 1264, 48},
    { -224, 1328, 0},
    { -120, 1080, -112},
    { -168, 912, -16},
    { -104, 1016, 8},
    // 30 seconds
    { 32, 880, -24},
    { 136, 680, 0},
    { 168, 688, 16},
    { 184, 736, 64},
    { 168, 800, 56},
    { 208, 992, 64},
    { 232, 944, -176},
    { 200, 968, -8},
    { 72, 1200, 144},
    { 48, 1272, 176},
    { -48, 1696, 160},
    { -376, 1544, 248},
    { -120, 1184, 88},
    { -192, 880, 232},
    { -128, 704, 160},
    { -16, 608, 136},
    { -24, 592, 192},
    { -16, 672, 232},
    { 32, 824, 248},
    { 120, 896, 264},
    { 192, 1112, 184},
    { 320, 1072, 24},
    { 192, 1032, 128},
    { 96, 1072, 8},
    { -24, 1016, 8},
    // 31 seconds
    { -256, 1216, 16},
    { -384, 1304, -152},
    { -392, 1080, -136},
    { -360, 1048, -120},
    { -160, 904, -144},
    { -8, 608, -104},
    { 80, 568, -96},
    { 144, 608, -8},
    { 184, 704, 56},
    { 208, 1008, 56},
    { 184, 1064, 208},
    { 200, 1136, 104},
    { 64, 1232, 80},
    { -24, 1080, 32},
    { 16, 1480, -32},
    { -488, 1744, 32},
    { -376, 1064, 112},
    { -336, 888, 96},
    { -200, 704, 112},
    { -24, 560, 48},
    { 48, 632, 64},
    { 24, 904, 0},
    { 24, 696, -88},
    { 160, 840, 0},
    { 144, 848, 40},
    // 32 seconds
    { 8, 984, 144},
    { -56, 1048, 32},
    { -264, 1320, 152},
    { -520, 1488, 264},
    { -336, 1464, -40},
    { -176, 1064, 48},
    { -88, 944, 40},
    { 72, 680, -8},
    { 120, 624, -96},
    { 144, 560, -16},
    { 184, 648, -24},
    { 256, 488, 56},
    { 328, 1048, 16},
    { 328, 1088, 8},
    { 120, 1240, -40},
    { -32, 1336, 224},
    { -224, 1760, 56},
    { -360, 1096, 256},
    { -176, 1008, 120},
    { -200, 880, 200},
    { -128, 768, 168},
    { 16, 648, 96},
    { 112, 656, 184},
    { 120, 784, 104},
    { 160, 992, 128},
    // 33 seconds
    { 160, 1024, 168},
    { 64, 1248, 112},
    { -168, 1216, 104},
    { -256, 1376, 56},
    { -360, 1160, 200},
    { -224, 992, 112},
    { -184, 832, 0},
    { -240, 776, 88},
    { -160, 976, 16},
    { -96, 784, 8},
    { -8, 656, -56},
    { 32, 696, -104},
    { 16, 648, -24},
    { 80, 880, -128},
    { 184, 1008, -40},
    { 184, 1120, -8},
    { 8, 1128, 40},
    { 56, 1280, 56},
    { -136, 1680, 56},
    { -80, 1104, 280},
    { -32, 1144, 104},
    { -32, 792, 192},
    { 56, 680, 88},
    { 144, 600, 104},
    { 152, 640, 160},
    // 34 seconds
    { 192, 728, 192},
    { 240, 928, 160},
    { 192, 1000, 144},
    { 96, 984, 232},
    { -56, 1632, -32},
    { -216, 1016, 88},
    { -288, 1016, -24},
    { -272, 1208, 8},
    { -208, 1056, 128},
    { -136, 1096, 56},
    { 24, 848, 120},
    { 232, 752, 112},
    { 296, 712, 40},
    { 328, 456, 144},
    { 296, 600, -72},
    { 272, 856, 224},
    { 288, 1088, 240},
    { 312, 1272, 240},
    { 296, 1312, 232},
    { 464, 1096, 368},
    { 320, 1512, 368},
    { 112, 1384, 488},
    { 56, 1160, 424},
    { -16, 872, 272},
    { 16, 656, 200},
    // 35 seconds
    { 80, 608, 176},
    { 136, 568, 152},
    { 136, 520, 248},
    { 120, 696, -208},
    { 176, 872, 96},
    { 184, 936, 136},
    { 72, 1224, 8},
    { 168, 1200, -40},
    { 56, 1224, 64},
    { -8, 1056, 96},
    { 136, 1120, -136},
    { 216, 920, -112},
    { 144, 856, -200},
    { 224, 600, -120},
    { 280, 576, -200},
    { 296, 680, -72},
    { 232, 760, -8},
    { 232, 824, 16},
    { 248, 808, -24},
    { 168, 1272, 0},
    { 136, 968, 184},
    { 296, 1320, 240},
    { 32, 1728, 264},
    { -64, 1432, 424},
    { -120, 1248, 232},
    // 36 seconds
    { -16, 880, 200},
    { 104, 608, 144},
    { 200, 528, 136},
    { 248, 576, 192},
    { 288, 496, 320},
    { 136, 1040, 232},
    { 40, 1184, 416},
    { -16, 1048, 296},
    { -64, 1096, 88},
    { -88, 1112, 96},
    { -80, 1048, 320},
    { -32, 1232, 120},
    { -40, 1016, 192},
    { -32, 1080, 136},
    { 72, 920, 128},
    { 184, 640, 96},
    { 208, 608, 96},
    { 224, 688, 200},
    { 184, 1104, 296},
    { 288, 928, 288},
    { 352, 1032, 368},
    { 304, 1264, 368},
    { 280, 1208, 280},
    { 280, 1456, 328},
    { 0, 1680, 376},
    // 37 seconds
    { -72, 1320, 264},
    { -128, 928, 232},
    { -72, 616, 296},
    { 48, 704, 56},
    { 120, 520, 152},
    { 176, 872, -120},
    { 128, 632, 56},
    { 160, 488, -184},
    { 32, 856, -272},
    { -72, 1056, -296},
    { 0, 1352, -344},
    { 0, 1488, -352},
    { 16, 952, -144},
    { 192, 1592, -584},
    { 8, 632, -72},
    { 88, 848, -344},
    { 160, 592, -256},
    { 224, 544, -184},
    { 280, 584, -152},
    { 288, 824, 24},
    { 256, 944, -744},
    { 216, 1072, -328},
    { 192, 1088, -528},
    { 144, 944, -152},
    { 272, 1408, -456},
    // 38 seconds
    { -72, 1496, -376},
    { -8, 1120, -176},
    { -32, 976, -192},
    { -24, 760, -120},
    { 40, 504, 40},
    { 104, 648, -64},
    { 120, 680, -16},
    { 88, 856, 32},
    { 80, 984, -120},
    { -24, 1192, -48},
    { -96, 1152, -64},
    { -136, 1056, 112},
    { -224, 1320, 96},
    { 32, 1280, -160},
    { 24, 936, -96},
    { 24, 944, -200},
    { 80, 816, -184},
    { 200, 608, -200},
    { 264, 568, -152},
    { 264, 664, -208},
    { 304, 712, 24},
    { 272, 896, -144},
    { 264, 904, -40},
    { 176, 1112, 32},
    { 64, 1104, 112},
    // 39 seconds
    { 136, 1616, -112},
    { -104, 1480, 296},
    { -24, 1088, 48},
    { -16, 936, 144},
    { 16, 816, -16},
    { 216, 752, 192},
    { 232, 712, 72},
    { 200, 712, 264},
    { 176, 720, 208},
    { 176, 952, 232},
    { -136, 1000, 424},
    { -48, 1168, 168},
    { -208, 1312, 248},
    { -200, 976, 400},
    { 104, 1224, 144},
    { 128, 976, 72},
    { 56, 928, 16},
    { 184, 800, 32},
    { 184, 696, 96},
    { 144, 744, 96},
    { 152, 776, 88},
    { 176, 776, -120},
    { 296, 1032, 48},
    { 224, 1032, 144},
    { 208, 1112, 168},
    // 40 seconds
    { 160, 1312, 368},
    { -24, 1456, 368},
    { 32, 1280, 448},
    { -32, 1000, 392},
    { 24, 800, 128},
    { 184, 552, 64},
    { 216, 544, 136},
    { 248, 784, 128},
    { 184, 848, 192},
    { 208, 896, 184},
    { 192, 1160, 208},
    { 40, 1224, 168},
    { 32, 1096, 32},
    { -144, 1248, 112},
    { -192, 1360, 480},
    { -56, 1184, -32},
    { -40, 920, 104},
    { 16, 856, 56},
    { 152, 744, 8},
    { 224, 624, 8},
    { 256, 640, 16},
    { 312, 816, -168},
    { 344, 1016, 176},
    { 352, 936, 184},
    { 184, 1168, 288},
    // 41 seconds
    { 104, 1112, 344},
    { 168, 1416, 312},
    { -152, 1552, 208},
    { -64, 1240, 376},
    { -64, 1048, 208},
    { -72, 704, 184},
    { 48, 488, 160},
    { 128, 528, 152},
    { 168, 656, 200},
    { 184, 768, 176},
    { 160, 984, 152},
    { 168, 1064, 264},
    { 24, 1176, 224},
    { -80, 1280, 88},
    { -256, 1536, 200},
    { -352, 1248, 192},
    { -304, 1232, -40},
    { -288, 912, 88},
    { -112, 800, -16},
    { 56, 568, -8},
    { 144, 560, -24},
    { 256, 632, 0},
    { 288, 888, -64},
    { 216, 928, 56},
    { 168, 1128, 56},
    // 42 seconds
    { 64, 1168, 160},
    { -96, 976, 184},
    { -24, 1304, 280},
    { -240, 1432, 320},
    { -104, 1272, 408},
    { -120, 1024, 248},
    { 16, 744, 104},
    { 128, 672, 16},
    { 152, 624, -216},
    { 112, 776, 96},
    { 64, 1136, -208},
    { 56, 1040, 376},
    { 80, 1136, 80},
    { 0, 1168, 16},
    { 80, 1096, 152},
    { -96, 1032, 208},
    { -16, 1088, 0},
    { 40, 864, 8},
    { -8, 824, 64},
    { 32, 752, 40},
    { 136, 600, 0},
    { 136, 528, 0},
    { 168, 1000, 64},
    { 136, 984, 136},
    { 104, 1168, 112},
    // 43 seconds
    { 152, 1248, 80},
    { 104, 1096, 56},
    { 128, 1424, 208},
    { -208, 1368, 208},
    { 8, 1096, 208},
    { -8, 944, 176},
    { 24, 680, 200},
    { 120, 568, 72},
    { 136, 544, 120},
    { 104, 848, 160},
    { 16, 1024, 144},
    { -8, 1008, 160},
    { -24, 1080, 80},
    { -104, 784, 40},
    { -24, 1128, 208},
    { -232, 1328, 328},
    { -64, 1344, -8},
    { -128, 952, 80},
    { -64, 832, 88},
    { 104, 688, -8},
    { 200, 720, -24},
    { 168, 728, -208},
    { 200, 936, 0},
    { 192, 976, 216},
    { 272, 960, 168},
    // 44 seconds
    { 88, 1080, 248},
    { 96, 1224, 328},
    { -24, 1720, 408},
    { -224, 1264, 488},
    { -96, 1064, 288},
    { -24, 768, 248},
    { 56, 624, 128},
    { 120, 600, 144},
    { 128, 616, 184},
    { 152, 728, 288},
    { 136, 1080, 280},
    { 120, 1008, 352},
    { 40, 1184, 248},
    { 48, 1096, 0},
    { -104, 1192, 352},
    { -160, 1184, 48},
    { -24, 968, -32},
    { -80, 920, 136},
    { 8, 952, 104},
    { 112, 600, 48},
    { 152, 680, -232},
    { 200, 736, -72},
    { 144, 808, 136},
    { 128, 952, 160},
    { 208, 1016, 200},
    // 45 seconds
    { 24, 1216, 232},
    { 120, 1320, 408},
    { -112, 1616, 360},
    { 8, 1136, 400},
    { 16, 984, 232},
    { -40, 824, 248},
    { 56, 704, 184},
    { 160, 536, 168},
    { 104, 648, 168},
    { 160, 832, 336},
    { 200, 1008, 232},
    { 128, 904, 264},
    { 8, 1104, 136},
    { -72, 1160, 208},
    { -208, 1264, 360},
    { -168, 1192, 208},
    { -96, 1080, 32},
    { -72, 776, 192},
    { -24, 936, 136},
    { 48, 816, 160},
    { 120, 720, -208},
    { 72, 768, 96},
    { 96, 1008, -56},
    { 104, 920, 0},
    { 128, 864, 8},
    // 46 seconds
    { 16, 1216, 24},
    { -72, 1096, 320},
    { 0, 1504, 344},
    { -192, 1560, 328},
    { -72, 1128, 288},
    { 80, 776, 176},
    { 128, 640, 24},
    { 176, 496, 152},
    { 216, 728, 144},
    { 232, 824, 152},
    { 208, 968, 120},
    { 168, 944, 232},
    { 96, 1056, -48},
    { -152, 1200, 40},
    { -176, 1168, 0},
    { -240, 1008, 200},
    { -152, 1352, -144},
    { -120, 1040, -128},
    { -80, 904, -104},
    { 40, 672, -80},
    { 136, 552, -120},
    { 168, 568, -16},
    { 208, 800, -48},
    { 184, 840, 56},
    { 304, 1032, 80},
    // 47 seconds
    { 320, 1096, 152},
    { 96, 1392, 208},
    { 128, 1496, 424},
    { -200, 1568, 216},
    { -8, 1216, 272},
    { -48, 936, 200},
    { -16, 784, 144},
    { 40, 528, 160},
    { 112, 680, 96},
    { 168, 720, 176},
    { 160, 816, 248},
    { 144, 824, 320},
    { 208, 736, 80},
    { 136, 1104, 232},
    { 72, 1280, 720},
    { -240, 1568, 256},
    { -528, 1120, -216},
    { -424, 832, -296},
    { -232, 832, -176},
    { -176, 928, 120},
    { 160, 816, 64},
    { 304, 656, 64},
    { 320, 640, 72},
    { 216, 1064, 0},
    { 256, 808, -128},
    // 48 seconds
    { 264, 1104, 136},
    { 0, 1256, 128},
    { -16, 1368, 424},
    { -192, 1672, 272},
    { -32, 1056, 312},
    { 8, 968, 264},
    { 8, 768, 288},
    { 80, 616, 200},
    { 112, 608, 208},
    { 120, 720, 224},
    { 64, 720, 152},
    { 64, 832, 0},
    { 80, 1016, 168},
    { -16, 1040, 96},
    { -80, 1296, 136},
    { -216, 1208, 200},
    { -160, 1256, -8},
    { -48, 904, -32},
    { -48, 912, 32},
    { 80, 800, 40},
    { 176, 624, 40},
    { 240, 576, 48},
    { 192, 840, 128},
    { 168, 856, 24},
    { 160, 920, 136},
    // 49 seconds
    { 192, 1144, 136},
    { -8, 1160, 184},
    { 176, 1200, 304},
    { -160, 1792, 216},
    { -136, 1168, 424},
    { -16, 1064, 192},
    { -16, 840, 216},
    { 120, 624, 168},
    { 216, 656, 112},
    { 224, 664, 200},
    { 224, 928, 120},
    { 192, 872, -32},
    { 104, 1008, 72},
    { -72, 1096, 144},
    { -72, 1024, 96},
    { -192, 1096, 216},
    { -280, 1440, 144},
    { -80, 1192, 16},
    { 48, 976, 24},
    { 112, 816, 96},
    { 216, 720, 64},
    { 304, 592, -336},
    { 248, 608, -72},
    { 232, 848, 56},
    { 224, 840, 136},
    // 50 seconds
    { 288, 1128, 40},
    { 56, 1200, 144},
    { 168, 1056, 240},
    { 40, 1632, 208},
    { -16, 1288, 320},
    { -24, 1168, 248},
    { -40, 840, 152},
    { 88, 552, 88},
    { 208, 584, 32},
    { 248, 736, 192},
    { 200, 816, 192},
    { 128, 936, 88},
    { 40, 936, 224},
    { 8, 1240, 120},
    { -24, 1288, 32},
    { -368, 1504, 400},
    { -272, 1320, 16},
    { -152, 840, 16},
    { -80, 960, 24},
    { -8, 784, -128},
    { 160, 600, -32},
    { 184, 648, 32},
    { 216, 760, 64},
    { 168, 1064, 64},
    { 224, 968, 72},
    // 51 seconds
    { 240, 1104, 104},
    { 88, 1200, 200},
    { 88, 1112, 288},
    { 64, 1384, 272},
    { -176, 1304, 352},
    { -64, 1120, 256},
    { -48, 856, 248},
    { 24, 680, 152},
    { 176, 496, 216},
    { 232, 704, 88},
    { 184, 824, 136},
    { 152, 896, 144},
    { 96, 1136, 328},
    { -24, 1160, 112},
    { -24, 1032, 48},
    { -192, 1264, 160},
    { -160, 1128, 88},
    { -64, 1000, -24},
    { -64, 880, 96},
    { 8, 1120, -40},
    { 40, 600, -120},
    { 152, 744, -80},
    { 136, 664, 48},
    { 184, 808, 32},
    { 168, 936, 120},
    // 52 seconds
    { 240, 1040, 56},
    { 40, 1176, 128},
    { 56, 1304, 288},
    { -176, 1800, 208},
    { -128, 1320, 296},
    { -88, 1088, 208},
    { 16, 864, 160},
    { 80, 640, 80},
    { 136, 568, 80},
    { 96, 672, 136},
    { 152, 760, 104},
    { 208, 824, 152},
    { 208, 1008, 168},
    { 32, 1160, 56},
    { 16, 1072, 96},
    { -40, 1328, 16},
    { -256, 1320, 160},
    { -104, 1112, -24},
    { -8, 848, 8},
    { -8, 952, 72},
    { 48, 952, 32},
    { 128, 728, 0},
    { 160, 624, -40},
    { 176, 632, 16},
    { 200, 784, 88},
    // 53 seconds
    { 240, 984, 88},
    { 256, 1032, 56},
    { 184, 1128, 40},
    { 16, 1176, 208},
    { -48, 1904, 160},
    { -336, 1352, 344},
    { -104, 1232, 56},
    { -176, 904, 176},
    { -104, 720, 160},
    { 0, 624, 120},
    { 24, 616, 136},
    { 40, 664, 208},
    { 136, 808, 232},
    { 256, 952, 152},
    { 176, 792, 216},
    { 88, 1208, 256},
    { 40, 1192, 128},
    { -144, 1304, 208},
    { -256, 1440, 88},
    { -200, 1216, -112},
    { -240, 840, 0},
    { -240, 904, 80},
    { -56, 816, 16},
    { 64, 592, -16},
    { 72, 584, 16},
    // 54 seconds
    { 120, 632, 24},
    { 120, 696, 24},
    { 144, 784, 96},
    { 120, 696, 128},
    { 112, 1200, 240},
    { -40, 1184, 304},
    { -144, 2072, 280},
    { -504, 1504, 384},
    { -168, 1312, 112},
    { -120, 880, 168},
    { -80, 760, 144},
    { -8, 624, 136},
    { 24, 640, 152},
    { -24, 720, 184},
    { 8, 832, 184},
    { 72, 816, 208},
    { 152, 816, 136},
    { 160, 696, 112},
    { 40, 992, 248},
    { 24, 1048, 64},
    { -144, 1184, 80},
    { -168, 1392, 112},
    { -224, 1240, -24},
    { -328, 1024, 80},
    { -224, 1048, 8},
    // 55 seconds
    { -80, 840, -8},
    { 40, 648, -24},
    { 80, 648, -24},
    { 112, 712, -24},
    { 72, 744, 24},
    { 56, 872, 0},
    { 64, 848, 48},
    { 208, 864, 136},
    { 104, 1208, -112},
    { -8, 968, 120},
    { -8, 1584, 224},
    { -408, 1624, 528},
    { -192, 1480, 344},
    { -144, 1056, 368},
    { -40, 816, 248},
    { 24, 712, 160},
    { -8, 648, 192},
    { -56, 648, 216},
    { -48, 760, 192},
    { -8, 848, 160},
    { 40, 904, 152},
    { 96, 968, 176},
    { 32, 1040, 136},
    { -24, 688, 88},
    { -104, 1224, 8},
    // 56 seconds
    { -376, 1312, 328},
    { -352, 1352, -56},
    { -208, 760, 8},
    { -152, 776, -120},
    { -136, 752, 56},
    { -168, 936, 120},
    { -112, 1120, 104},
    { -24, 1072, 112},
    { 48, 1112, 80},
    { 64, 976, 112},
    { 72, 928, 96},
    { 8, 952, 88},
    { -128, 928, 80},
    { -184, 888, 24},
    { -216, 832, -16},
    { -176, 800, 0},
    { -128, 912, -72},
    { -112, 1040, -32},
    { -8, 1120, -96},
    { 56, 952, -144},
    { 56, 856, -96},
    { 128, 800, -112},
    { 184, 728, -72},
    { 184, 896, -184},
    { 232, 816, -152},
    // 57 seconds
    { 352, 1104, -192},
    { 336, 1088, -360},
    { 424, 992, -72},
    { 376, 1176, 88},
    { 216, 1120, 264},
    { -232, 1480, 288},
    { -496, 1432, 416},
    { -456, 1224, 200},
    { -456, 1216, 208},
    { -312, 904, 192},
    { -96, 728, 8},
    { 0, 480, 72},
    { 144, 688, 112},
    { 200, 824, 64},
    { 128, 1232, 264},
    { 32, 1408, 144},
    { 0, 1440, 200},
    { -80, 1104, 72},
    { -232, 1024, -48},
    { -224, 800, 88},
    { -336, 1040, 40},
    { -392, 904, 200},
    { -216, 936, -72},
    { 0, 616, 48},
    { 136, 472, -48},
    // 58 seconds
    { 328, 552, 160},
    { 128, 672, -8},
    { 128, 968, 48},
    { 104, 1272, 144},
    { 16, 1480, 48},
    { -72, 1160, 144},
    { -88, 1368, 184},
    { -136, 1272, 288},
    { -56, 1080, 224},
    { -64, 872, 288},
    { -96, 632, 200},
    { -56, 448, 176},
    { 0, 488, 160},
    { -8, 736, 328},
    { -168, 1056, 288},
    { -272, 1272, 136},
    { -344, 1168, 152},
    { -336, 1272, 232},
    { -344, 952, 432},
    { -280, 1248, -8},
    { -280, 832, 248},
    { -152, 768, 56},
    { 40, 368, 344},
    { -16, 272, 72},
    { -24, 568, -16},
    // 59 seconds
    { -48, 936, 8},
    { -32, 1320, -192},
    { 144, 1376, 312},
    { -264, 1496, 136},
    { -120, 1440, 360},
    { -248, 1312, 416},
    { -336, 1248, 208},
    { -184, 896, 272},
    { -200, 784, 336},
    { -96, 568, 208},
    { 56, 544, 56},
    { 104, 520, 184},
    { 352, 792, -40},
    { 192, 1040, 8},
    { 16, 1288, 24},
    { -208, 1232, -16},
    { -320, 1040, 192},
    { -368, 912, 416},
    { -216, 1320, -152},
    { -592, 736, 328},
    { -328, 1104, -88},
    { -192, 848, -56},
    { 0, 656, -312},
    { 120, 552, -32},
    { 200, 432, -88},
    // 60 seconds
    // elapsed: 1 minutes
    { 256, 760, 96},
    { 184, 840, -184},
    { 232, 1056, 168},
    { 96, 1256, 216},
    { 88, 952, 392},
    { 48, 1464, 400},
    { -288, 1640, 424},
    { -136, 1304, 344},
    { 8, 856, 216},
    { 112, 608, 80},
    { 160, 528, 32},
    { 192, 480, 136},
    { 80, 928, -216},
    { 72, 616, 8},
    { -8, 952, 296},
    { -232, 1392, 136},
    { -312, 1424, 248},
    { -424, 1144, 376},
    { -240, 1264, 0},
    { -96, 832, 160},
    { 24, 848, 168},
    { 176, 800, 176},
    { 232, 712, 112},
    { 216, 656, 144},
    { 192, 848, 112},
    // 61 seconds
    { 168, 1072, 232},
    { 168, 888, -40},
    { 80, 1040, 208},
    { -24, 912, 104},
    { 120, 1224, 464},
    { -232, 1680, 536},
    { -168, 1496, 552},
    { -168, 984, 288},
    { -64, 696, 144},
    { 80, 520, 160},
    { 152, 520, 112},
    { 152, 624, 200},
    { 80, 488, 104},
    { 8, 1160, 96},
    { -144, 960, 192},
    { -56, 1144, 0},
    { -168, 1072, 336},
    { -264, 1280, 360},
    { -80, 1344, 80},
    { -16, 1000, 160},
    { 16, 904, 112},
    { 144, 712, -8},
    { 136, 568, 64},
    { 136, 632, 48},
    { 128, 808, 88},
    // 62 seconds
    { 112, 904, -96},
    { 168, 952, -16},
    { 200, 1032, 136},
    { 40, 1128, 200},
    { 200, 1280, 328},
    { -152, 1664, 504},
    { -320, 1456, 424},
    { -264, 1080, 360},
    { -80, 824, 144},
    { 56, 512, 144},
    { 144, 400, 136},
    { 128, 520, 160},
    { 64, 792, 416},
    { -8, 1032, 152},
    { -120, 1104, 208},
    { -136, 992, -8},
    { -184, 1240, 176},
    { -408, 1088, 248},
    { -208, 1416, -96},
    { -208, 1072, 208},
    { -120, 1200, 48},
    { 40, 872, -16},
    { 136, 576, -32},
    { 192, 536, -40},
    { 208, 600, 80},
    // 63 seconds
    { 224, 768, -112},
    { 152, 872, 88},
    { 112, 1160, 160},
    { -88, 1064, 472},
    { -112, 1880, 448},
    { -544, 1624, 480},
    { -240, 1328, 216},
    { -184, 936, 208},
    { -72, 728, 144},
    { 56, 576, 88},
    { 136, 504, 120},
    { 120, 632, 96},
    { 152, 816, 168},
    { 136, 1192, 88},
    { -24, 1280, -8},
    { -232, 1192, 184},
    { -288, 1224, 8},
    { -416, 904, 216},
    { -376, 1408, 8},
    { -584, 960, 112},
    { -336, 1112, -24},
    { -120, 824, 48},
    { 40, 704, -48},
    { 168, 664, -200},
    { 120, 840, -376},
    // 64 seconds
    { -32, 568, -16},
    { 48, 976, -112},
    { 208, 1040, 88},
    { 272, 1256, 96},
    { 184, 1000, 216},
    { 320, 1024, 272},
    { 160, 1344, 144},
    { -80, 1144, 216},
    { -168, 1048, 40},
    { -152, 912, -96},
    { 8, 584, -48},
    { 88, 680, -184},
    { 72, 760, -80},
    { -40, 944, -128},
    { -48, 1136, -208},
    { -232, 1104, -88},
    { -184, 1064, -80},
    { -408, 1368, -64},
    { -256, 1200, 8},
    { -112, 1008, -288},
    { -128, 768, -56},
    { -32, 720, -64},
    { 96, 616, -104},
    { 136, 624, -56},
    { 168, 680, 24},
    // 65 seconds
    { 216, 928, -8},
    { 256, 936, 24},
    { 216, 1232, 88},
    { 32, 1304, 168},
    { 0, 1536, 312},
    { -224, 1768, 232},
    { -16, 1024, 272},
    { 48, 888, 208},
    { 72, 736, 208},
    { 72, 592, 200},
    { 136, 576, 160},
    { 144, 656, 192},
    { 144, 792, 200},
    { 152, 944, 192},
    { 88, 1048, 160},
    { 56, 1096, -16},
    { 0, 1088, 120},
    { -24, 1224, 56},
    { -120, 1056, 280},
    { -176, 1144, 80},
    { -64, 944, -8},
    { -72, 824, 16},
    { -8, 744, 40},
    { 88, 672, -32},
    { 128, 656, 16},
    // 66 seconds
    { 144, 768, 0},
    { 160, 800, 24},
    { 216, 864, 24},
    { 168, 984, 64},
    { 0, 1040, 0},
    { 16, 1232, 272},
    { -64, 1696, 184},
    { -112, 1288, 344},
    { -88, 1200, 240},
    { -32, 920, 200},
    { 16, 632, 160},
    { 112, 528, 136},
    { 184, 592, 144},
    { 168, 704, 200},
    { 168, 816, 208},
    { 80, 1032, 136},
    { -64, 1008, -48},
    { -80, 1040, 152},
    { -208, 1408, 176},
    { -248, 1344, 208},
    { -120, 1144, 24},
    { -112, 944, 24},
    { -8, 800, 64},
    { 160, 576, -16},
    { 208, 576, 32},
    // 67 seconds
    { 256, 712, 56},
    { 272, 968, 40},
    { 288, 928, 224},
    { 224, 1408, -200},
    { -32, 1144, 144},
    { -64, 1032, 192},
    { -64, 1576, 200},
    { -184, 1240, 520},
    { -64, 1240, 304},
    { -32, 864, 296},
    { 40, 664, 240},
    { 160, 576, 160},
    { 200, 576, 136},
    { 168, 656, 168},
    { 72, 856, 208},
    { 112, 904, 272},
    { 32, 1096, 384},
    { -40, 1168, 344},
    { 48, 1304, 192},
    { -72, 1176, 448},
    { -24, 1240, 112},
    { -16, 896, 168},
    { -56, 1016, 96},
    { -16, 784, 48},
    { 88, 608, 72},
    // 68 seconds
    { 168, 720, 8},
    { 192, 784, 48},
    { 264, 896, 80},
    { 296, 920, 136},
    { 264, 1248, 32},
    { 56, 1168, 80},
    { 120, 1040, 368},
    { 24, 1328, 272},
    { 8, 1224, 472},
    { 56, 984, 472},
    { 80, 984, 336},
    { 144, 744, 144},
    { 240, 464, 304},
    { 256, 576, 280},
    { 248, 648, 328},
    { 256, 808, 400},
    { 176, 1080, 248},
    { 48, 824, 32},
    { 16, 1136, 80},
    { -88, 1184, 360},
    { -224, 1336, 320},
    { -56, 1304, 24},
    { -40, 896, 256},
    { -40, 1112, 184},
    { 16, 960, 88},
    // 69 seconds
    { 64, 640, 112},
    { 80, 608, 80},
    { 128, 688, 120},
    { 176, 792, 184},
    { 240, 1032, -184},
    { 344, 912, 296},
    { 136, 1016, 248},
    { 248, 1512, 448},
    { -104, 1720, 552},
    { 8, 1272, 552},
    { -8, 968, 440},
    { 8, 768, 256},
    { 80, 584, 160},
    { 192, 432, 160},
    { 264, 576, 200},
    { 224, 768, 248},
    { 232, 880, 288},
    { 280, 992, 136},
    { 280, 1016, 208},
    { 128, 1064, 32},
    { 8, 1288, 232},
    { -192, 1176, 480},
    { -104, 1200, 160},
    { -136, 736, 224},
    { -24, 904, 48},
    // 70 seconds
    { 72, 744, 56},
    { 176, 672, -24},
    { 216, 720, -56},
    { 248, 696, -8},
    { 232, 840, 0},
    { 184, 784, 160},
    { 288, 1112, 152},
    { 88, 1200, 72},
    { 248, 1128, 384},
    { 24, 1576, 296},
    { 40, 1256, 456},
    { 56, 1128, 352},
    { 96, 920, 256},
    { 40, 728, 232},
    { 160, 704, 152},
    { 248, 616, 168},
    { 248, 752, 200},
    { 256, 1128, 136},
    { 256, 704, -8},
    { 216, 912, 304},
    { 152, 1120, 176},
    { 160, 1184, 280},
    { 0, 1304, 280},
    { -112, 1176, 272},
    { -24, 1184, -64},
    // 71 seconds
    { -32, 808, 128},
    { 32, 952, -16},
    { 112, 800, 16},
    { 192, 664, -40},
    { 240, 680, -72},
    { 232, 736, -8},
    { 272, 840, 0},
    { 280, 728, 112},
    { 256, 1264, 272},
    { 88, 1152, 272},
    { 192, 1432, 272},
    { -112, 1432, 368},
    { 64, 1344, 368},
    { 72, 1120, 304},
    { 72, 856, 272},
    { 136, 632, 144},
    { 200, 512, 112},
    { 224, 528, 152},
    { 224, 648, 136},
    { 240, 880, 32},
    { 216, 944, 0},
    { 192, 1136, 64},
    { 56, 1072, 136},
    { 80, 1200, 64},
    { -112, 1240, 264},
    // 72 seconds
    { -88, 1176, 96},
    { -32, 1064, 32},
    { -72, 1008, 128},
    { 16, 968, 80},
    { 120, 736, 24},
    { 160, 616, -32},
    { 208, 664, 16},
    { 248, 728, 48},
    { 208, 760, 24},
    { 288, 1008, 40},
    { 224, 1208, 208},
    { 40, 1232, 264},
    { 288, 1832, 352},
    { -72, 1432, 408},
    { 56, 960, 304},
    { 88, 816, 200},
    { 72, 592, 216},
    { 152, 528, 136},
    { 256, 512, 136},
    { 264, 536, 216},
    { 280, 744, 152},
    { 320, 856, -16},
    { 248, 1024, 208},
    { 168, 1152, 232},
    { 96, 1200, 256},
    // 73 seconds
    { 0, 1336, 344},
    { -112, 1232, 168},
    { 48, 1008, 80},
    { -16, 1024, 264},
    { 72, 944, 144},
    { 144, 704, 56},
    { 192, 560, 72},
    { 216, 624, 80},
    { 240, 880, 184},
    { 264, 912, 96},
    { 312, 992, 120},
    { 312, 1200, 32},
    { 184, 1072, 392},
    { 336, 1120, 336},
    { 112, 1600, 312},
    { 56, 1152, 416},
    { 120, 1040, 264},
    { 64, 744, 272},
    { 80, 696, 152},
    { 176, 592, 112},
    { 192, 624, 104},
    { 120, 816, 184},
    { 152, 904, 152},
    { 168, 1000, 168},
    { 136, 1088, 176},
    // 74 seconds
    { 16, 1064, 200},
    { 0, 1032, 208},
    { -144, 1256, 152},
    { -128, 1344, 24},
    { -56, 904, 152},
    { -40, 1048, 8},
    { 48, 752, 104},
    { 152, 600, 16},
    { 168, 688, 40},
    { 192, 712, 56},
    { 192, 800, 40},
    { 264, 864, 104},
    { 320, 984, 96},
    { 104, 1016, 192},
    { 80, 1328, 368},
    { -16, 1824, 360},
    { -88, 1160, 376},
    { -16, 1072, 216},
    { 32, 944, 312},
    { 40, 712, 248},
    { 128, 632, 168},
    { 224, 576, 200},
    { 216, 680, 232},
    { 224, 824, 232},
    { 240, 928, 256},
    // 75 seconds
    { 200, 1024, 320},
    { 64, 984, 224},
    { 64, 1208, 144},
    { -96, 1248, 320},
    { -216, 1216, 232},
    { -80, 1104, -96},
    { -160, 968, 168},
    { -96, 1064, 24},
    { 56, 728, 40},
    { 120, 592, 24},
    { 192, 616, -8},
    { 216, 688, 32},
    { 248, 824, 40},
    { 312, 920, 88},
    { 264, 1360, 48},
    { 88, 1104, 112},
    { 168, 1416, 288},
    { -88, 1504, 296},
    { 8, 1160, 296},
    { -40, 1064, 312},
    { -8, 760, 256},
    { 40, 616, 192},
    { 128, 568, 192},
    { 160, 600, 200},
    { 152, 736, 208},
    // 76 seconds
    { 248, 840, 256},
    { 320, 936, 304},
    { 360, 1224, -8},
    { 184, 1064, 144},
    { 168, 1200, 56},
    { 16, 1144, 456},
    { -128, 1360, 176},
    { -64, 1136, 144},
    { -72, 872, 224},
    { 16, 888, 152},
    { 168, 664, 120},
    { 224, 664, 88},
    { 248, 728, 128},
    { 256, 808, 152},
    { 232, 888, 144},
    { 240, 920, 80},
    { 272, 960, 0},
    { 224, 1040, 72},
    { 136, 1208, 208},
    { 40, 1768, 336},
    { -200, 1280, 416},
    { 32, 1080, 256},
    { 40, 880, 264},
    { 40, 728, 264},
    { 128, 656, 176},
    // 77 seconds
    { 168, 672, 208},
    { 184, 760, 200},
    { 216, 784, 184},
    { 232, 952, 192},
    { 200, 960, -40},
    { 72, 1072, 96},
    { 48, 1128, 112},
    { -24, 1184, 264},
    { -216, 1192, 224},
    { -16, 1200, 24},
    { 16, 880, 16},
    { -64, 984, 128},
    { 32, 856, 72},
    { 128, 696, 32},
    { 136, 704, 32},
    { 152, 712, 48},
    { 216, 992, 72},
    { 184, 968, 80},
    { 256, 1008, 160},
    { 160, 1256, 128},
    { 80, 1184, 296},
    { 48, 1584, 232},
    { -176, 1240, 384},
    { -8, 1200, 240},
    { 0, 912, 272},
    // 78 seconds
    { 32, 752, 168},
    { 152, 608, 120},
    { 216, 584, 136},
    { 232, 688, 168},
    { 272, 792, 176},
    { 328, 1048, 192},
    { 368, 896, -16},
    { 288, 1072, 128},
    { 88, 1104, 232},
    { 40, 1032, 32},
    { -96, 1088, 224},
    { -152, 1224, 200},
    { -16, 1144, -112},
    { -48, 912, 160},
    { 40, 1008, 112},
    { 104, 736, 88},
    { 176, 624, 48},
    { 192, 672, 48},
    { 184, 720, 96},
    { 200, 752, 72},
    { 248, 928, 72},
    { 256, 1088, 168},
    { 184, 1240, 128},
    { 200, 1128, 360},
    { 120, 1360, 216},
    // 79 seconds
    { -56, 1280, 280},
    { 72, 1184, 224},
    { 40, 912, 288},
    { 32, 752, 200},
    { 136, 656, 152},
    { 168, 712, 128},
    { 192, 720, 168},
    { 224, 832, 168},
    { 232, 864, 208},
    { 168, 904, 568},
    { -16, 1192, 224},
    { 16, 1104, 56},
    { -8, 1088, 176},
    { -120, 1136, 368},
    { -80, 1272, 184},
    { 24, 1064, 88},
    { 48, 984, 232},
    { 136, 848, 128},
    { 232, 608, 72},
    { 248, 584, 112},
    { 264, 768, 96},
    { 248, 848, 80},
    { 264, 1024, -96},
    { 232, 960, 80},
    { 96, 1128, 200},
    // 80 seconds
    { 112, 992, 336},
    { 256, 1488, 240},
    { -160, 1640, 520},
    { 32, 1456, 432},
    { 56, 1088, 344},
    { 64, 744, 336},
    { 184, 568, 128},
    { 256, 464, 64},
    { 200, 504, 192},
    { 192, 680, 272},
    { 176, 1056, 40},
    { 112, 1200, 312},
    { 72, 1048, 200},
    { -24, 1120, 240},
    { -96, 1112, 296},
    { -272, 952, 376},
    { -40, 944, 272},
    { 16, 1032, 184},
    { -8, 1168, 200},
    { 80, 1080, 24},
    { 160, 760, 48},
    { 176, 712, 80},
    { 216, 816, 88},
    { 232, 744, 248},
    { 136, 616, -8},
    // 81 seconds
    { 160, 984, 296},
    { 112, 1152, 168},
    { -16, 1152, 176},
    { 88, 1288, 232},
    { -128, 1296, 328},
    { -16, 1128, 376},
    { -24, 1080, 360},
    { -32, 824, 296},
    { 72, 648, 216},
    { 160, 576, 176},
    { 168, 656, 192},
    { 168, 808, 264},
    { 120, 768, 112},
    { 32, 1176, 304},
    { -80, 1248, 160},
    { -120, 952, 184},
    { -152, 1104, 200},
    { -296, 1432, 176},
    { -256, 1192, 72},
    { -232, 1000, 112},
    { -64, 832, 64},
    { 56, 624, 32},
    { 72, 544, 96},
    { 88, 720, 88},
    { 168, 768, 80},
    // 82 seconds
    { 192, 904, 112},
    { 224, 976, 160},
    { 248, 1120, 160},
    { 112, 1416, 256},
    { 96, 1216, 168},
    { -168, 1416, 368},
    { -40, 1192, 344},
    { -88, 1064, 384},
    { -88, 912, 304},
    { 24, 760, 80},
    { 104, 520, 240},
    { 176, 696, 144},
    { 168, 760, 168},
    { 216, 816, 208},
    { 216, 816, 232},
    { 232, 1120, 264},
    { 56, 1032, 136},
    { -40, 1072, 0},
    { -168, 1168, 192},
    { -320, 1304, 168},
    { -192, 1136, -16},
    { -216, 904, 56},
    { -120, 1024, 0},
    { -8, 784, 40},
    { 104, 648, 8},
    // 83 seconds
    { 144, 544, 0},
    { 176, 536, -112},
    { 216, 792, -8},
    { 152, 1040, 64},
    { 128, 984, 176},
    { -48, 1064, 152},
    { 72, 1456, 272},
    { -368, 1544, 328},
    { -80, 1232, 280},
    { -40, 952, 288},
    { -8, 744, 240},
    { 24, 632, 208},
    { 104, 632, 128},
    { 80, 680, 240},
    { 32, 816, 232},
    { 136, 968, 272},
    { 64, 1200, 184},
    { -80, 1192, 168},
    { -144, 1232, 208},
    { -104, 1136, 72},
    { -312, 1056, 256},
    { -272, 1280, 128},
    { -192, 1008, 0},
    { -144, 824, 112},
    { -24, 760, 40},
    // 84 seconds
    { 80, 624, 32},
    { 104, 624, 56},
    { 144, 728, 112},
    { 168, 856, 208},
    { 144, 1120, -56},
    { 120, 1200, 136},
    { -32, 1184, 160},
    { -48, 1232, 288},
    { -32, 1432, 336},
    { -144, 1288, 312},
    { -24, 1024, 320},
    { 16, 872, 312},
    { 0, 704, 240},
    { 104, 640, 192},
    { 152, 672, 216},
    { 136, 760, 248},
    { 176, 928, 304},
    { 152, 1256, 64},
    { 0, 1032, 144},
    { -48, 1120, 96},
    { -96, 1192, 152},
    { -224, 1152, 248},
    { -256, 1032, 152},
    { -112, 1016, -72},
    { -96, 840, 136},
    // 85 seconds
    { 40, 880, 72},
    { 136, 728, 24},
    { 152, 664, 64},
    { 200, 736, 40},
    { 240, 728, 200},
    { 232, 1160, -168},
    { 224, 1208, 200},
    { -48, 1232, 208},
    { 120, 1312, 360},
    { -104, 1632, 416},
    { -120, 1336, 384},
    { -48, 1064, 256},
    { 8, 792, 216},
    { 64, 608, 128},
    { 160, 592, 144},
    { 216, 680, 176},
    { 184, 840, 248},
    { 184, 936, 368},
    { 152, 1080, 96},
    { 56, 1144, 296},
    { 40, 1000, 192},
    { -112, 1248, 352},
    { -216, 1208, 312},
    { -104, 1080, 24},
    { -96, 808, 144},
    // 86 seconds
    { -80, 968, 96},
    { 48, 760, 72},
    { 128, 736, 0},
    { 160, 704, 16},
    { 184, 792, 24},
    { 216, 840, 160},
    { 256, 1320, -40},
    { 184, 1192, 160},
    { -64, 1056, 312},
    { 48, 1448, 256},
    { -128, 1320, 464},
    { -32, 1128, 384},
    { 0, 1008, 336},
    { -40, 752, 352},
    { 32, 648, 272},
    { 112, 648, 232},
    { 136, 680, 264},
    { 120, 776, 256},
    { 160, 1120, 256},
    { 16, 920, 56},
    { -88, 1080, 232},
    { -112, 1216, 200},
    { -136, 1264, 240},
    { -296, 1240, 312},
    { -88, 1176, 48},
    // 87 seconds
    { -96, 816, 136},
    { -64, 824, 160},
    { 48, 736, 104},
    { 96, 616, 40},
    { 88, 696, 72},
    { 56, 808, 96},
    { 72, 952, 32},
    { 120, 992, 120},
    { 128, 1136, 112},
    { -8, 1280, 240},
    { -72, 1240, 216},
    { -216, 1536, 280},
    { -128, 1120, 384},
    { -32, 984, 264},
    { -24, 832, 192},
    { 64, 760, 128},
    { 144, 608, 104},
    { 120, 696, 144},
    { 168, 744, 152},
    { 192, 1248, 88},
    { 64, 792, 112},
    { 24, 1104, 200},
    { 0, 1184, 184},
    { -48, 1312, 328},
    { -232, 1216, 200},
    // 88 seconds
    { -40, 1040, 112},
    { -120, 1000, 200},
    { -64, 920, 152},
    { 104, 696, 32},
    { 168, 584, 40},
    { 192, 696, 16},
    { 200, 760, 32},
    { 216, 888, 72},
    { 232, 1120, 144},
    { 152, 1024, 48},
    { 40, 1072, 296},
    { 128, 1256, 152},
    { -168, 1496, 288},
    { -16, 1224, 464},
    { -32, 1120, 328},
    { -16, 896, 184},
    { 128, 600, 120},
    { 232, 584, 40},
    { 240, 640, 120},
    { 240, 712, 144},
    { 232, 856, 200},
    { 120, 1200, 104},
    { -32, 1352, 272},
    { -72, 1024, 56},
    { -256, 1248, 160},
    // 89 seconds
    { -208, 1312, 328},
    { -224, 1296, 112},
    { -224, 1120, 120},
    { -56, 864, 40},
    { 104, 600, 0},
    { 168, 536, 24},
    { 200, 624, 40},
    { 216, 720, 64},
    { 224, 976, 72},
    { 200, 1192, -152},
    { 136, 1208, 80},
    { 32, 1208, 272},
    { -120, 1832, 296},
    { -392, 1320, 608},
    { -104, 1360, 136},
    { -16, 688, 280},
    { 40, 648, 104},
    { 112, 560, 112},
    { 208, 568, 112},
    { 224, 688, 184},
    { 232, 800, 280},
    { 208, 1256, 208},
    { 48, 1192, 256},
    { 0, 1200, 168},
    { -48, 1072, 144},
    // 90 seconds
    { -200, 1168, 216},
    { -176, 1232, 184},
    { -104, 1064, 80},
    { -120, 968, 160},
    { 0, 776, 88},
    { 128, 552, 40},
    { 160, 536, 56},
    { 192, 720, 64},
    { 192, 832, 144},
    { 144, 1040, 168},
    { 184, 1096, 96},
    { 16, 1176, 240},
    { 56, 1344, 296},
    { -216, 1528, 424},
    { -64, 1224, 376},
    { -32, 1032, 304},
    { -8, 816, 280},
    { 72, 648, 184},
    { 160, 640, 136},
    { 192, 712, 184},
    { 176, 808, 248},
    { 176, 904, 224},
    { 176, 1112, 248},
    { 80, 912, -16},
    { -64, 1088, 104},
    // 91 seconds
    { -104, 1240, 160},
    { -264, 1256, 392},
    { -216, 1272, 104},
    { -128, 960, 56},
    { -128, 960, 72},
    { 8, 744, 24},
    { 144, 592, 24},
    { 168, 648, 64},
    { 176, 760, 144},
    { 200, 856, 248},
    { 200, 1128, 208},
    { 176, 1240, 304},
    { 16, 1168, 160},
    { 48, 976, 136},
    { 88, 1376, 312},
    { -448, 1600, 376},
    { -272, 1288, 328},
    { -216, 816, 192},
    { -32, 536, 112},
    { 112, 472, 88},
    { 176, 440, 256},
    { 176, 656, 248},
    { 120, 816, -80},
    { 72, 1056, 24},
    { -72, 1128, 192},
    // 92 seconds
    { -136, 1080, 184},
    { -176, 1216, 88},
    { -328, 1088, 400},
    { -272, 1056, 176},
    { -240, 1088, 40},
    { -232, 888, 200},
    { -144, 896, 96},
    { 8, 712, 56},
    { -40, 512, 80},
    { 8, 512, 136},
    { -48, 200, -48},
    { -168, 1160, 200},
    { -168, 1304, 160},
    { -272, 1424, 224},
    { -296, 1064, 304},
    { -424, 1584, 216},
    { -752, 1416, 320},
    { -536, 1032, 280},
    { -360, 800, 200},
    { -216, 560, 216},
    { -128, 384, 168},
    { -112, 408, 136},
    { -248, 600, 96},
    { -440, 568, -8},
    { -288, 1008, 168},
    // 93 seconds
    { -392, 1040, 272},
    { -584, 1096, 152},
    { -592, 1160, 120},
    { -744, 1120, 200},
    { -744, 1080, 104},
    { -536, 872, 40},
    { -584, 776, 24},
    { -496, 728, 40},
    { -264, 632, 56},
    { -112, 584, 24},
    { -112, 576, 128},
    { -176, 696, -64},
    { -264, 568, 40},
    { -192, 968, 192},
    { -216, 1040, 168},
    { -472, 1024, 168},
    { -528, 1312, 368},
    { -920, 1360, 208},
    { -664, 880, 200},
    { -608, 880, 184},
    { -632, 792, 152},
    { -392, 632, 152},
    { -280, 568, 120},
    { -336, 560, 200},
    { -352, 616, 336},
    // 94 seconds
    { -464, 880, -160},
    { -336, 856, 240},
    { -432, 1048, 288},
    { -568, 1168, 280},
    { -848, 1408, 384},
    { -472, 1304, 40},
    { -648, 1080, 96},
    { -504, 704, 264},
    { -280, 792, -8},
    { -160, 496, 16},
    { -56, 448, -24},
    { 16, 480, 48},
    { 64, 456, -24},
    { 56, 960, 128},
    { 88, 1024, 168},
    { -120, 1304, 200},
    { -88, 1336, 496},
    { -408, 1648, 344},
    { -424, 992, 376},
    { -240, 1000, 96},
    { -264, 824, 256},
    { -144, 720, 168},
    { -56, 568, 136},
    { -32, 520, 240},
    { -120, 1056, 296},
    // 95 seconds
    { -304, 960, 536},
    { -152, 1672, 216},
    { -144, 952, 608},
    { -224, 1272, 272},
    { -152, 1048, 296},
    { -384, 928, 456},
    { -328, 936, 152},
    { -336, 952, 40},
    { -304, 656, 328},
    { -184, 776, 112},
    { -40, 592, 176},
    { -16, 616, 184},
    { 0, 744, 168},
    { -80, 840, 88},
    { -72, 960, -24},
    { -112, 1080, 200},
    { -352, 1008, 224},
    { -352, 1304, 200},
    { -632, 1192, 232},
    { -512, 896, 160},
    { -536, 760, 56},
    { -568, 744, 48},
    { -440, 592, 88},
    { -352, 568, 40},
    { -368, 584, 48},
    // 96 seconds
    { -320, 704, 80},
    { -864, 384, -48},
    { -936, 544, -16},
    { -1240, 408, 120},
    { -1360, 672, -120},
    { -1560, 728, -152},
    { -1368, 608, -128},
    { -512, 672, -248},
    { -904, 552, -88},
    { -832, 424, -80},
    { -568, 504, -48},
    { -536, 472, 16},
    { -528, 504, -40},
    { -568, 496, 64},
    { -648, 840, -8},
    { -720, 688, -88},
    { -744, 800, -16},
    { -872, 800, 184},
    { -1224, 840, 40},
    { -976, 816, -56},
    { -856, 600, 72},
    { -696, 568, 72},
    { -592, 440, 120},
    { -528, 536, 88},
    { -528, 528, 144},
    // 97 seconds
    { -592, 560, 168},
    { -568, 672, 288},
    { -520, 808, 160},
    { -728, 880, 192},
    { -944, 848, 136},
    { -824, 960, -96},
    { -1264, 800, 128},
    { -960, 680, 56},
    { -736, 624, -56},
    { -872, 576, -32},
    { -672, 448, -88},
    { -464, 392, 32},
    { -400, 576, -40},
    { -336, 600, -16},
    { -352, 632, 112},
    { -528, 832, -112},
    { -520, 872, -80},
    { -512, 1064, 40},
    { -744, 976, 8},
    { -800, 1072, 128},
    { -1200, 1240, -184},
    { -872, 656, 104},
    { -688, 528, -24},
    { -680, 264, -48},
    { -408, 128, 40},
    // 98 seconds
    { -416, 568, -104},
    { -488, 584, 144},
    { -568, 768, 144},
    { -552, 560, -8},
    { -576, 792, 208},
    { -752, 944, -136},
    { -784, 912, -152},
    { -1264, 728, 48},
    { -752, 720, -208},
    { -800, 504, -80},
    { -760, 496, -48},
    { -544, 384, -40},
    { -376, 368, -144},
    { -328, 504, -88},
    { -368, 584, -208},
    { -480, 648, 56},
    { -672, 976, -336},
    { -624, 800, -120},
    { -832, 984, -88},
    { -824, 880, 48},
    { -1200, 1160, -208},
    { -1088, 792, 160},
    { -920, 600, 72},
    { -624, 472, 120},
    { -640, 304, 144},
    // 99 seconds
    { -512, 288, 48},
    { -520, 384, 40},
    { -608, 440, 64},
    { -664, 648, 128},
    { -728, 904, -40},
    { -984, 784, 48},
    { -1040, 816, 32},
    { -952, 784, -64},
    { -1040, 688, 0},
    { -1184, 640, 72},
    { -768, 624, -8},
    { -696, 736, -200},
    { -608, 528, -64},
    { -456, 360, 40},
    { -344, 472, -96},
    { -360, 456, 40},
    { -480, 736, 72},
    { -544, 888, -192},
    { -536, 736, 32},
    { -648, 968, -80},
    { -760, 768, -16},
    { -992, 960, 16},
    { -1072, 936, -48},
    { -904, 440, 224},
    { -1048, 584, 0},
    // 100 seconds
    { -920, 320, 176},
    { -656, 304, 48},
    { -544, 496, -72},
    { -560, 424, 88},
    { -768, 512, -216},
    { -824, 648, -8},
    { -808, 832, 8},
    { -920, 904, 32},
    { -840, 688, 8},
    { -784, 736, 0},
    { -1160, 624, 88},
    { -800, 488, 32},
    { -944, 584, -64},
    { -848, 512, 8},
    { -624, 408, 8},
    { -472, 384, 0},
    { -440, 448, -48},
    { -456, 448, 48},
    { -704, 496, -256},
    { -728, 544, -88},
    { -712, 936, -72},
    { -856, 728, 104},
    { -1000, 960, -96},
    { -1208, 1016, -48},
    { -1056, 712, 80},
    // 101 seconds
    { -872, 480, 88},
    { -712, 432, 24},
    { -584, 304, 24},
    { -464, 344, -16},
    { -536, 392, 32},
    { -624, 408, 8},
    { -752, 408, 88},
    { -896, 184, 112},
    { -1368, 400, -184},
    { -1040, 472, -120},
    { -1248, 584, -112},
    { -1400, 400, -152},
    { -688, 368, -152},
    { -864, 544, -232},
    { -800, 312, -120},
    { -552, 312, -64},
    { -504, 376, -72},
    { -552, 360, -48},
    { -632, 456, -40},
    { -696, 456, -48},
    { -672, 448, 72},
    { -1048, 536, -376},
    { -952, 272, -16},
    { -1648, 848, -136},
    { -1448, 552, 64},
    // 102 seconds
    { -1168, 448, -72},
    { -936, 424, -32},
    { -720, 192, 56},
    { -504, 280, -40},
    { -520, 264, 72},
    { -648, 328, 16},
    { -752, 400, 72},
    { -736, 464, 32},
    { -904, 560, 32},
    { -888, 536, -16},
    { -1376, 744, -136},
    { -1520, 568, -152},
    { -824, 312, -168},
    { -1040, 344, -392},
    { -920, 104, -88},
    { -552, 144, -72},
    { -488, 184, -160},
    { -528, 184, -104},
    { -608, 240, -96},
    { -752, 288, -136},
    { -896, 432, -128},
    { -872, 472, -320},
    { -1184, 312, -152},
    { -1336, 416, -304},
    { -1704, 552, -328},
    // 103 seconds
    { -960, 32, -8},
    { -1032, 232, -240},
    { -1008, 216, -120},
    { -680, 128, -16},
    { -552, 256, -64},
    { -584, 216, 16},
    { -672, 280, 0},
    { -864, 288, 0},
    { -848, 256, -8},
    { -1016, 232, -24},
    { -1040, 256, -8},
    { -1016, 72, -16},
    { -2064, 184, 128},
    { -408, 360, -416},
    { -1000, 256, -304},
    { -976, 200, -192},
    { -592, 288, -152},
    { -496, 192, -168},
    { -496, 160, -128},
    { -592, 240, -136},
    { -688, 248, -88},
    { -800, 344, -136},
    { -912, 728, -232},
    { -1336, 360, -376},
    { -1128, 368, -216},
    // 104 seconds
    { -1608, 472, -384},
    { -1512, 344, -280},
    { -1056, 256, -152},
    { -960, 240, -192},
    { -864, 104, -48},
    { -552, 120, -40},
    { -576, 216, -32},
    { -712, 200, 40},
    { -752, 168, 16},
    { -784, 312, -40},
    { -880, 608, -16},
    { -1080, 720, -120},
    { -1280, 504, -32},
    { -992, 520, -160},
    { -1368, 296, -64},
    { -1184, 272, -32},
    { -896, 416, -224},
    { -944, 344, -160},
    { -632, 272, -176},
    { -424, 336, -128},
    { -384, 304, -40},
    { -504, 544, -72},
    { -552, 496, -32},
    { -576, 672, -112},
    { -616, 632, -48},
    // 105 seconds
    { -632, 824, -80},
    { -744, 680, -88},
    { -1144, 872, -104},
    { -1192, 904, -192},
    { -1080, 448, -40},
    { -880, 496, -64},
    { -704, 368, 32},
    { -584, 336, 24},
    { -616, 368, 0},
    { -648, 336, -8},
    { -792, 368, -32},
    { -872, 416, -40},
    { -888, 392, -96},
    { -1080, 520, -192},
    { -824, 584, -32},
    { -888, 680, -248},
    { -1448, 792, -160},
    { -984, 928, -152},
    { -1192, 832, -264},
    { -1016, 576, -120},
    { -528, 344, -48},
    { -384, 264, -56},
    { -336, 360, -8},
    { -312, 448, -8},
    { -328, 664, 8},
    // 106 seconds
    { -264, 832, 48},
    { -264, 1080, 208},
    { -112, 1448, 64},
    { -536, 1488, 208},
    { -568, 1176, 328},
    { -464, 1200, 280},
    { -464, 976, 352},
    { -304, 768, 192},
    { -128, 664, 56},
    { -88, 624, 64},
    { -24, 704, 112},
    { -80, 808, 144},
    { -56, 952, 88},
    { -80, 944, 168},
    { -168, 1048, 136},
    { -272, 1160, 112},
    { -176, 1064, 0},
    { -304, 1032, 216},
    { -336, 1184, 200},
    { -464, 1128, 184},
    { -392, 1224, 88},
    { -184, 1256, 8},
    { 8, 1032, -56},
    { 72, 968, -80},
    { 80, 488, -152},
    // 107 seconds
    { -64, 776, -480},
    { -208, 464, -568},
    { -224, 512, -856},
    { -264, 296, -752},
    { -200, 272, -752},
    { -216, 104, -784},
    { -112, 80, -792},
    { -96, 72, -848},
    { -40, 160, -936},
    { 8, 256, -936},
    { 40, 312, -984},
    { 80, 464, -920},
    { -64, 240, -888},
    { -32, 184, -856},
    { -16, 192, -856},
    { 8, 184, -840},
    { -24, 240, -888},
    { -88, 392, -952},
    { -96, 328, -992},
    { -112, 160, -936},
    { -96, 80, -936},
    { -112, 80, -936},
    { -104, 64, -976},
    { -144, 24, -904},
    { -128, -40, -888},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:01:41 local
AccelRawData *activity_sample_walk_200_pbl_25669_8(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25669_8
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -296, 576, -680},
    { -256, 512, -792},
    { -304, 360, -800},
    { -384, 312, -784},
    { -408, 264, -848},
    { -392, 200, -824},
    { -416, 192, -816},
    { -224, 72, -808},
    { -376, 320, -912},
    { -232, 304, -920},
    { -464, 72, -840},
    { -472, 88, -808},
    { -448, 104, -816},
    { -424, 136, -824},
    { -384, 48, -768},
    { -448, 232, -808},
    { -416, 144, -816},
    { -352, 56, -816},
    { -432, 104, -808},
    { -408, 136, -792},
    { -440, 96, -808},
    { -400, 96, -792},
    { -448, 128, -800},
    { -456, 152, -824},
    { -464, 128, -824},
    // 1 seconds
    { -416, 160, -816},
    { -400, 144, -808},
    { -408, 136, -800},
    { -392, 136, -824},
    { -424, 144, -816},
    { -432, 160, -808},
    { -424, 144, -800},
    { -432, 128, -792},
    { -440, 136, -792},
    { -464, 128, -776},
    { -496, 104, -784},
    { -536, 152, -736},
    { -528, 24, -592},
    { -432, 192, -664},
    { -472, 208, -752},
    { -464, 232, -864},
    { -496, 216, -896},
    { -480, 192, -904},
    { -496, 160, -848},
    { -512, 144, -816},
    { -504, 152, -792},
    { -512, 128, -760},
    { -504, 168, -752},
    { -496, 144, -720},
    { -496, 160, -712},
    // 2 seconds
    { -520, 168, -728},
    { -560, 152, -720},
    { -600, 104, -640},
    { -608, 104, -584},
    { -648, 72, -448},
    { -664, 184, -416},
    { -656, 208, -336},
    { -704, 360, -336},
    { -696, 584, -392},
    { -704, 496, -288},
    { -760, 712, -248},
    { -824, 768, -256},
    { -984, 720, -200},
    { -1120, 632, -320},
    { -1144, 736, -264},
    { -1048, 480, -88},
    { -984, 352, -56},
    { -848, 280, -88},
    { -864, 328, -160},
    { -816, 280, -96},
    { -768, 256, -176},
    { -880, 312, -152},
    { -1008, 328, -248},
    { -992, 192, -152},
    { -960, 232, -176},
    // 3 seconds
    { -920, 216, -216},
    { -944, 200, -176},
    { -1048, 200, -128},
    { -1128, 128, -56},
    { -1400, 216, -264},
    { -1272, 144, -16},
    { -936, 160, -112},
    { -592, -104, -32},
    { -800, -168, -8},
    { -856, 136, -112},
    { -808, 64, -128},
    { -776, -32, -120},
    { -760, 16, -160},
    { -776, 112, -224},
    { -728, 40, -216},
    { -648, -120, -200},
    { -752, -160, -288},
    { -1248, 368, -504},
    { -1336, -16, -192},
    { -1792, 320, -464},
    { -1184, -80, -104},
    { -832, 216, -248},
    { -800, 96, -80},
    { -824, 80, 32},
    { -720, 152, -8},
    // 4 seconds
    { -784, 232, -8},
    { -896, 200, -24},
    { -928, 144, -24},
    { -824, 152, -8},
    { -992, 64, -56},
    { -1224, -96, 56},
    { -1200, 144, -96},
    { -1432, 56, -104},
    { -720, 0, -136},
    { -792, 8, -64},
    { -1040, 56, -144},
    { -744, 176, -232},
    { -496, 160, -224},
    { -528, 136, -224},
    { -664, 224, -272},
    { -824, 264, -296},
    { -808, 296, -152},
    { -1096, 736, -584},
    { -1064, 160, -392},
    { -1040, -48, -168},
    { -1680, 448, -752},
    { -1544, -144, 56},
    { -1336, 256, -248},
    { -1032, 232, -160},
    { -840, -56, 64},
    // 5 seconds
    { -504, 56, -16},
    { -488, 160, -48},
    { -600, 216, 0},
    { -816, 160, 72},
    { -1264, 136, -96},
    { -1064, -8, 232},
    { -1176, 216, -80},
    { -1000, 144, -232},
    { -1512, 128, -64},
    { -1096, 224, -192},
    { -976, 96, -256},
    { -936, 56, -152},
    { -536, 112, -136},
    { -368, 136, -72},
    { -456, 272, -128},
    { -640, 344, -176},
    { -816, 376, -88},
    { -864, 744, -504},
    { -1160, 584, -448},
    { -1024, 264, -368},
    { -1272, 504, -512},
    { -1744, 696, -528},
    { -1336, 48, -96},
    { -1200, 168, -200},
    { -960, -112, 80},
    // 6 seconds
    { -576, 16, 64},
    { -504, 40, 88},
    { -520, 96, 80},
    { -624, 160, 48},
    { -640, -88, -88},
    { -1048, -8, -128},
    { -1336, 240, -248},
    { -1248, 160, -176},
    { -1632, 272, -176},
    { -1024, 184, -200},
    { -1008, 248, -272},
    { -1120, 72, -160},
    { -760, 16, -128},
    { -416, 136, -200},
    { -336, 160, -160},
    { -400, 256, -224},
    { -624, 280, -160},
    { -888, 416, -184},
    { -1120, 256, -208},
    { -1160, 432, -368},
    { -952, 296, -288},
    { -1920, 696, -712},
    { -1624, 24, -48},
    { -1456, 48, -264},
    { -1160, -104, -120},
    // 7 seconds
    { -600, 0, -120},
    { -352, -32, -16},
    { -376, 24, -8},
    { -488, 160, -32},
    { -704, 208, -8},
    { -840, 232, 32},
    { -1312, -72, -128},
    { -1256, -16, -8},
    { -1096, 24, -96},
    { -1904, 96, -200},
    { -888, 120, -336},
    { -1224, 48, -280},
    { -1096, -144, -8},
    { -592, 200, -240},
    { -352, 144, -200},
    { -344, 208, -192},
    { -424, 312, -200},
    { -624, 384, -136},
    { -912, 144, -328},
    { -1080, -152, -232},
    { -1096, 320, -472},
    { -1136, 88, -184},
    { -2184, 624, -696},
    { -1624, -104, 0},
    { -1616, -40, -136},
    // 8 seconds
    { -1104, -208, 48},
    { -472, -48, 16},
    { -328, -40, 72},
    { -400, 48, 64},
    { -560, 64, 64},
    { -720, 96, 88},
    { -1120, 536, -352},
    { -1480, -80, 136},
    { -1128, -16, -48},
    { -1712, 376, -328},
    { -1096, 184, -32},
    { -856, 104, -224},
    { -1008, 16, -168},
    { -688, 48, -168},
    { -448, 144, -184},
    { -432, 216, -248},
    { -600, 320, -312},
    { -784, 296, -312},
    { -888, 96, -184},
    { -792, 280, -448},
    { -1184, 288, -328},
    { -1224, -80, -200},
    { -2064, 752, -632},
    { -1344, -184, -96},
    { -1184, 56, -144},
    // 9 seconds
    { -904, 0, -48},
    { -600, 8, 24},
    { -504, 104, -32},
    { -560, 144, 16},
    { -680, 192, -8},
    { -824, 432, -40},
    { -1152, 688, -248},
    { -1120, 144, -184},
    { -952, 80, -272},
    { -1552, 264, -280},
    { -1176, 152, -200},
    { -952, 128, -296},
    { -1128, 176, -312},
    { -752, 104, -200},
    { -424, 104, -240},
    { -456, 120, -248},
    { -520, 72, -240},
    { -648, 504, -344},
    { -736, 160, -392},
    { -832, 296, -496},
    { -1072, 152, -424},
    { -1464, 272, -208},
    { -2048, 504, -416},
    { -1048, -8, 24},
    { -1064, 208, -184},
    // 10 seconds
    { -864, 184, -120},
    { -616, 8, 32},
    { -568, 176, -16},
    { -632, 160, -56},
    { -672, 96, -104},
    { -904, 176, 24},
    { -1064, 224, -352},
    { -1152, 232, -280},
    { -1208, 280, -248},
    { -1560, 184, -208},
    { -688, 232, -112},
    { -896, 192, -160},
    { -880, 136, -136},
    { -552, 120, -152},
    { -424, 200, -168},
    { -696, 608, -248},
    { -960, 208, -384},
    { -944, 264, -344},
    { -824, 176, -432},
    { -1024, 288, -512},
    { -1056, 328, -304},
    { -1752, 416, -528},
    { -1512, 160, -200},
    { -1088, 96, -152},
    { -808, 216, -232},
    // 11 seconds
    { -520, -40, 16},
    { -384, 88, 8},
    { -600, -32, 72},
    { -936, 88, -32},
    { -1008, 256, -128},
    { -1040, 376, -176},
    { -1296, 152, -160},
    { -984, 72, -152},
    { -1808, 144, -120},
    { -864, 48, -192},
    { -888, 96, -240},
    { -992, 24, -144},
    { -584, 72, -152},
    { -424, 192, -176},
    { -432, 240, -232},
    { -664, 216, -216},
    { -1104, 104, -352},
    { -800, -208, -232},
    { -968, 336, -456},
    { -1096, 184, -304},
    { -1464, 320, -360},
    { -1784, 584, -520},
    { -1096, -64, -56},
    { -968, 176, -216},
    { -776, 104, -56},
    // 12 seconds
    { -576, 64, -24},
    { -584, 80, 8},
    { -544, 168, 88},
    { -848, 512, -328},
    { -1056, -24, 88},
    { -1232, 160, -88},
    { -1080, -152, -32},
    { -1448, 176, -168},
    { -1488, 48, -160},
    { -728, 136, -256},
    { -984, 200, -304},
    { -704, 96, -152},
    { -312, 80, -120},
    { -280, 224, -160},
    { -568, 312, -248},
    { -840, 456, -184},
    { -1008, 264, -544},
    { -1128, 200, -280},
    { -1264, 304, -248},
    { -1488, 248, -216},
    { -1784, 224, -296},
    { -1104, 48, -96},
    { -1048, 200, -272},
    { -792, 40, 8},
    { -480, 64, -32},
    // 13 seconds
    { -480, 96, 16},
    { -624, 56, 160},
    { -808, -304, -48},
    { -1040, 176, -24},
    { -1232, 200, -56},
    { -1248, -88, -48},
    { -1080, 136, -120},
    { -1480, 72, -48},
    { -960, 136, -224},
    { -896, 112, -248},
    { -736, 72, -168},
    { -456, 24, -152},
    { -456, 152, -152},
    { -624, 224, -136},
    { -776, 72, -240},
    { -688, -160, -272},
    { -920, 384, -440},
    { -1096, 264, -368},
    { -1256, 104, -296},
    { -2000, 680, -592},
    { -1016, -232, 24},
    { -1048, 200, -296},
    { -960, -8, -8},
    { -720, -40, 112},
    { -552, 128, 48},
    // 14 seconds
    { -784, 384, 200},
    { -952, -336, -120},
    { -752, 632, -336},
    { -1088, 136, -40},
    { -1128, 216, 8},
    { -1208, 216, -160},
    { -1696, 72, -160},
    { -992, 96, -112},
    { -800, 280, -336},
    { -800, 208, -320},
    { -504, 80, -224},
    { -520, 96, -208},
    { -696, 168, -168},
    { -608, 496, -376},
    { -984, 208, -176},
    { -912, 312, -344},
    { -1168, 264, -424},
    { -1368, 120, -56},
    { -1800, 512, -448},
    { -1088, 8, 24},
    { -952, 416, -456},
    { -944, 80, 72},
    { -568, -48, 112},
    { -488, 104, 64},
    { -736, 32, 176},
    // 15 seconds
    { -896, 168, 16},
    { -1112, 560, 176},
    { -1192, -88, -256},
    { -1080, 136, -40},
    { -1528, 192, -168},
    { -1536, 128, -216},
    { -736, 344, -272},
    { -1064, -32, -144},
    { -656, -80, -136},
    { -336, 80, -152},
    { -416, 72, -168},
    { -584, 488, -264},
    { -1032, 584, -392},
    { -1008, 88, -240},
    { -968, 304, -424},
    { -1280, 208, -304},
    { -1656, 200, -328},
    { -1664, 344, -424},
    { -960, 64, -112},
    { -1040, 280, -280},
    { -816, 24, -16},
    { -472, 24, -48},
    { -576, 152, -16},
    { -680, 160, 0},
    { -776, 80, 0},
    // 16 seconds
    { -1088, -24, 0},
    { -1104, -104, -24},
    { -1256, 112, -32},
    { -1424, 176, -136},
    { -1192, 16, 40},
    { -680, 112, -120},
    { -1096, -16, -152},
    { -864, -8, -104},
    { -528, 104, -176},
    { -408, 152, -216},
    { -656, 208, -232},
    { -896, -80, -544},
    { -920, 224, -448},
    { -904, -32, -312},
    { -1192, 224, -408},
    { -1168, 96, -160},
    { -1704, 520, -464},
    { -1344, 48, -96},
    { -1272, 168, -64},
    { -992, -32, 104},
    { -592, -112, 216},
    { -544, 0, 144},
    { -496, 200, 184},
    { -872, -176, 40},
    { -888, 152, 8},
    // 17 seconds
    { -976, 48, -88},
    { -1240, 184, -56},
    { -1216, 216, -56},
    { -1696, 208, -8},
    { -1072, 72, -24},
    { -912, -176, 40},
    { -1136, -16, -24},
    { -864, 32, 80},
    { -768, 296, -160},
    { -416, -392, -112},
    { -632, 136, -88},
    { -760, -32, -152},
    { -1048, -352, -176},
    { -1216, -136, -224},
    { -1256, 88, -88},
    { -1192, 304, 200},
    { -1784, 832, 216},
    { -1112, -80, 752},
    { -1032, 160, 472},
    { -792, 112, 440},
    { -480, -104, 328},
    { -456, 96, 88},
    { -600, -256, 32},
    { -832, 312, -136},
    { -904, 520, -128},
    // 18 seconds
    { -1104, 400, 48},
    { -1208, -64, 296},
    { -1192, 120, 360},
    { -1528, 184, 208},
    { -792, -264, 328},
    { -984, -32, 8},
    { -912, 104, 56},
    { -544, -8, -48},
    { -600, 136, -40},
    { -656, 168, -72},
    { -840, 88, -88},
    { -1216, 96, 104},
    { -888, -208, -64},
    { -1088, 264, -392},
    { -1064, 72, -176},
    { -1648, 368, -328},
    { -1680, 304, -160},
    { -1096, -152, 176},
    { -840, 304, -72},
    { -672, 304, -32},
    { -576, 152, 24},
    { -568, 280, -48},
    { -744, 200, 104},
    { -864, 32, -64},
    { -1000, 160, 176},
    // 19 seconds
    { -1064, 152, -72},
    { -1200, 48, -40},
    { -1296, 88, -56},
    { -1584, -336, 104},
    { -880, 336, -384},
    { -960, 112, -400},
    { -880, 16, -240},
    { -440, 152, -288},
    { -352, 136, -208},
    { -440, 296, -248},
    { -544, 512, -480},
    { -832, 552, -560},
    { -848, 312, -424},
    { -1152, 336, -424},
    { -1088, 168, -168},
    { -1856, 632, -576},
    { -1424, 56, -40},
    { -1264, 464, -360},
    { -1072, 96, -8},
    { -568, -64, -48},
    { -472, -48, -24},
    { -696, 40, 24},
    { -712, -64, 256},
    { -920, 904, -264},
    { -1088, 0, -288},
    // 20 seconds
    { -1112, 320, -40},
    { -928, 400, -304},
    { -1480, 368, -136},
    { -1224, 352, -168},
    { -824, 480, -416},
    { -1000, 208, -208},
    { -600, 144, -152},
    { -320, 288, -232},
    { -400, 280, -144},
    { -408, 744, -608},
    { -824, 392, -168},
    { -880, 288, -312},
    { -1184, 336, -432},
    { -1056, 136, 48},
    { -1712, 288, -392},
    { -1104, 0, 24},
    { -1144, 112, -184},
    { -1032, 264, -136},
    { -736, -8, 40},
    { -560, 216, -72},
    { -544, 192, -80},
    { -832, 240, -216},
    { -960, 112, -168},
    { -1160, 272, -168},
    { -1184, 360, -248},
    // 21 seconds
    { -1576, 320, -296},
    { -976, 208, -144},
    { -912, 32, -152},
    { -1056, -128, -80},
    { -688, 88, -192},
    { -456, 64, -208},
    { -544, 48, -232},
    { -656, 80, -256},
    { -888, 176, -320},
    { -952, 128, -352},
    { -744, -160, -672},
    { -1152, 360, -400},
    { -1640, 296, -408},
    { -1656, 224, -256},
    { -1064, 160, -256},
    { -952, 200, -144},
    { -752, 16, 120},
    { -656, -48, 168},
    { -528, 0, 56},
    { -720, 112, 40},
    { -936, 168, -88},
    { -792, -224, 200},
    { -952, 1368, -392},
    { -1096, -640, 696},
    { -1448, 232, -24},
    // 22 seconds
    { -1352, -680, 24},
    { -936, 320, -304},
    { -976, 528, -248},
    { -760, 152, -160},
    { -392, 192, -224},
    { -400, 248, -200},
    { -648, 304, -200},
    { -904, 280, -184},
    { -896, 312, -48},
    { -672, 344, -256},
    { -1040, 424, -280},
    { -1008, 48, -16},
    { -1608, 408, -304},
    { -1448, 208, -280},
    { -1256, 160, -168},
    { -992, 240, -160},
    { -664, 112, -48},
    { -480, 128, -96},
    { -560, 160, 24},
    { -744, 200, -24},
    { -832, 272, 32},
    { -776, 448, -120},
    { -1264, 112, -64},
    { -1104, 24, -88},
    { -1408, 264, -248},
    // 23 seconds
    { -1280, 0, -136},
    { -792, 392, -424},
    { -1056, 192, -280},
    { -736, 64, -160},
    { -320, 64, -144},
    { -448, 136, -336},
    { -696, 136, -312},
    { -888, -128, -64},
    { -1032, 40, -152},
    { -976, 272, -408},
    { -1072, 312, -376},
    { -944, -56, -136},
    { -1312, 528, -688},
    { -1520, 192, -368},
    { -1416, 208, -512},
    { -1072, -96, -64},
    { -752, -176, -48},
    { -608, 48, -48},
    { -744, -96, -24},
    { -800, -56, 40},
    { -768, -16, 24},
    { -928, 264, 240},
    { -1024, 48, -120},
    { -1208, 224, -248},
    { -1168, -48, -152},
    // 24 seconds
    { -1616, -168, -72},
    { -1016, 32, -192},
    { -984, 104, -304},
    { -976, 88, -304},
    { -784, -16, -168},
    { -648, 64, -240},
    { -584, 160, -304},
    { -688, 256, -384},
    { -720, 240, -424},
    { -968, 160, -672},
    { -880, 80, -792},
    { -1008, -728, -480},
    { -1288, -40, -472},
    { -1600, 368, -344},
    { -1504, 232, -96},
    { -1288, 120, 40},
    { -880, -24, 96},
    { -624, -24, -16},
    { -520, -24, -16},
    { -864, 168, -24},
    { -1088, 216, 136},
    { -784, 504, -192},
    { -736, -104, -32},
    { -952, 176, -176},
    { -1016, 0, -168},
    // 25 seconds
    { -1536, 168, -256},
    { -952, 136, -176},
    { -904, 456, -472},
    { -1040, 264, -296},
    { -1000, -16, -152},
    { -824, 152, -248},
    { -656, 216, -256},
    { -624, 280, -288},
    { -736, 472, -424},
    { -808, 152, -248},
    { -912, 296, -336},
    { -920, 432, -344},
    { -1240, 48, 8},
    { -1808, 360, -144},
    { -1352, -128, 72},
    { -1216, -40, -104},
    { -1176, -224, 8},
    { -768, -88, -24},
    { -608, -264, 16},
    { -608, -48, 64},
    { -704, 96, 120},
    { -776, 56, 136},
    { -920, 192, 16},
    { -1136, 88, 72},
    { -1288, 96, 112},
    // 26 seconds
    { -1040, 144, -40},
    { -1648, -208, 168},
    { -784, -72, -64},
    { -1096, 24, -120},
    { -1064, -112, -144},
    { -856, -56, -112},
    { -656, -96, -72},
    { -600, 56, -160},
    { -608, 64, -96},
    { -656, -120, 32},
    { -888, -32, 288},
    { -1040, 120, 16},
    { -1168, -192, 16},
    { -1456, 56, -24},
    { -1992, 152, -168},
    { -1008, -144, -112},
    { -1064, 136, -368},
    { -904, -112, -32},
    { -688, -144, 40},
    { -600, 24, -104},
    { -600, 184, -264},
    { -800, 128, -160},
    { -1040, -200, 104},
    { -1096, 40, 152},
    { -1232, 296, 152},
    // 27 seconds
    { -1176, -248, 360},
    { -1392, 320, 88},
    { -1256, 40, -72},
    { -456, -32, -104},
    { -928, -192, -104},
    { -1000, -152, -24},
    { -720, -112, -96},
    { -664, 32, -312},
    { -616, 96, -232},
    { -536, 176, -392},
    { -728, 176, -296},
    { -784, 424, -440},
    { -960, 448, -312},
    { -1168, 144, -80},
    { -1968, 584, -232},
    { -1440, 128, 8},
    { -1000, 256, -208},
    { -880, 184, -216},
    { -720, -32, -104},
    { -560, 16, -48},
    { -616, 120, -104},
    { -776, 136, -32},
    { -856, 328, -128},
    { -864, 344, -80},
    { -952, 216, -32},
    // 28 seconds
    { -1176, 288, -280},
    { -1144, -24, -200},
    { -1464, 504, -200},
    { -1240, 176, -144},
    { -520, 304, -296},
    { -1024, 0, -88},
    { -888, -56, -96},
    { -544, 128, -192},
    { -464, 136, -192},
    { -560, 192, -240},
    { -720, 208, -216},
    { -824, 176, -240},
    { -912, 256, -256},
    { -984, 272, -392},
    { -1120, 40, -256},
    { -1520, 248, -344},
    { -2184, 168, -152},
    { -1208, -384, 104},
    { -912, 0, -192},
    { -600, 312, -208},
    { -432, -120, -32},
    { -632, -64, -56},
    { -776, 104, 0},
    { -896, 160, 0},
    { -936, 152, -88},
    // 29 seconds
    { -856, 152, -88},
    { -944, -8, -136},
    { -1144, 152, -104},
    { -1088, 112, -16},
    { -1488, 72, 24},
    { -1264, -72, -16},
    { -816, -112, 8},
    { -1144, -80, -8},
    { -968, -72, -176},
    { -656, -136, -128},
    { -600, -56, -144},
    { -600, 8, -208},
    { -712, 88, -200},
    { -784, 88, -168},
    { -848, 416, -312},
    { -1112, 96, -328},
    { -1152, 64, -248},
    { -1688, 464, -496},
    { -1264, -64, -152},
    { -1328, 160, -248},
    { -1184, 120, -144},
    { -752, -48, -16},
    { -464, 88, -48},
    { -504, 208, -88},
    { -688, 72, 64},
    // 30 seconds
    { -800, -40, -128},
    { -872, 304, -72},
    { -1000, 208, -128},
    { -1216, 192, -128},
    { -1024, 168, -48},
    { -1504, -32, -184},
    { -760, 8, -80},
    { -976, 688, -440},
    { -1080, 536, -624},
    { -648, 248, -392},
    { -416, 160, -208},
    { -464, 120, -224},
    { -600, 200, -184},
    { -744, 472, -304},
    { -1104, 664, -472},
    { -872, 480, -392},
    { -1016, 424, -408},
    { -1040, 248, -96},
    { -1600, 680, -624},
    { -1200, 72, 48},
    { -1192, 408, -352},
    { -1040, 368, -248},
    { -664, 72, -24},
    { -360, 104, -224},
    { -368, 312, -272},
    // 31 seconds
    { -656, 128, -128},
    { -824, 208, -56},
    { -848, 64, -104},
    { -1032, 528, -208},
    { -1080, 304, -160},
    { -1600, 344, -192},
    { -760, 72, -280},
    { -968, 304, -360},
    { -1176, 96, -232},
    { -856, 104, -328},
    { -432, 160, -384},
    { -368, 80, -296},
    { -408, -152, -344},
    { -472, 344, -624},
    { -840, 216, -296},
    { -856, 480, -488},
    { -1008, 416, -448},
    { -992, 280, -184},
    { -1784, 504, -416},
    { -1304, 80, -56},
    { -1088, 368, -384},
    { -936, 80, -288},
    { -632, -200, -96},
    { -464, -88, -128},
    { -576, 64, -144},
    // 32 seconds
    { -616, -344, 48},
    { -728, 48, -192},
    { -1008, 16, -104},
    { -1136, 264, -216},
    { -1272, 64, -80},
    { -1032, 160, -184},
    { -1392, 24, -128},
    { -808, 88, -184},
    { -984, 112, -240},
    { -952, -32, -160},
    { -576, 24, -216},
    { -472, 40, -160},
    { -584, 88, -184},
    { -584, -384, -488},
    { -840, 152, -72},
    { -888, 96, -368},
    { -1080, 336, -472},
    { -1064, -64, -152},
    { -1944, 528, -472},
    { -1152, -56, -8},
    { -984, 208, -168},
    { -928, -40, 16},
    { -664, -40, 64},
    { -560, 144, -112},
    { -632, 168, -40},
    // 33 seconds
    { -1072, 464, -120},
    { -872, -200, -128},
    { -976, 8, 0},
    { -1288, 200, -112},
    { -1200, 104, -144},
    { -1344, -56, 80},
    { -808, 192, -240},
    { -1152, 232, -264},
    { -1384, 144, -152},
    { -928, 104, -208},
    { -536, 152, -216},
    { -352, 168, -240},
    { -416, 120, -200},
    { -552, 0, -32},
    { -760, 384, -568},
    { -1032, 136, -336},
    { -1208, 408, -368},
    { -1264, -152, -8},
    { -2096, 448, -544},
    { -1208, -32, -16},
    { -1000, 96, -272},
    { -880, -168, -48},
    { -560, -104, -16},
    { -504, 24, -16},
    { -592, -48, 24},
    // 34 seconds
    { -1200, 72, 168},
    { -952, -48, -48},
    { -1120, 72, -112},
    { -1096, 8, -176},
    { -912, -160, -128},
    { -1656, 232, -280},
    { -936, 176, -256},
    { -848, -16, -152},
    { -936, -248, -8},
    { -640, 24, -136},
    { -504, 64, -152},
    { -568, 72, -160},
    { -632, 64, -136},
    { -784, -544, -320},
    { -760, 8, -224},
    { -968, 136, -320},
    { -1128, -8, -136},
    { -1432, -128, 72},
    { -1736, 392, -376},
    { -1208, -72, 88},
    { -1192, 208, -280},
    { -936, 16, -32},
    { -560, 176, -24},
    { -608, 184, -144},
    { -656, -56, 96},
    // 35 seconds
    { -656, 208, -96},
    { -928, -232, -344},
    { -1088, 16, -40},
    { -1232, -72, 8},
    { -1448, -56, 40},
    { -1600, -184, 48},
    { -544, -168, -120},
    { -1304, 120, -248},
    { -768, -232, -88},
    { -416, -136, -64},
    { -464, 72, -128},
    { -616, 232, -120},
    { -784, 384, -112},
    { -1008, 176, -192},
    { -904, 72, -280},
    { -1112, -16, -184},
    { -1056, -128, 64},
    { -1744, 440, -448},
    { -1632, -48, 120},
    { -1368, 128, -120},
    { -952, 104, -224},
    { -712, -40, 32},
    { -424, 0, -8},
    { -496, 64, 80},
    { -696, 64, -64},
    // 36 seconds
    { -840, -104, 168},
    { -1200, 336, -232},
    { -1064, 192, -256},
    { -1128, 128, -112},
    { -1240, 0, -32},
    { -1632, -8, -32},
    { -712, 192, -416},
    { -1064, -24, -216},
    { -936, -216, -104},
    { -536, 0, -168},
    { -416, 112, -224},
    { -440, 112, -152},
    { -424, -128, -456},
    { -864, 200, -200},
    { -1000, 432, -472},
    { -1104, 368, -472},
    { -1096, 280, -192},
    { -1624, 496, -552},
    { -1472, 104, -152},
    { -1440, 144, -144},
    { -1040, 184, -152},
    { -576, 144, -120},
    { -376, 96, -96},
    { -408, 128, -88},
    { -560, 184, -32},
    // 37 seconds
    { -704, 120, 96},
    { -864, 328, -208},
    { -1272, 216, -72},
    { -1368, 280, -208},
    { -1200, 64, -184},
    { -1624, -24, -128},
    { -800, 192, -256},
    { -984, 120, -264},
    { -992, 64, -208},
    { -584, 40, -160},
    { -384, 96, -200},
    { -456, 136, -192},
    { -608, 232, -240},
    { -816, 248, -248},
    { -824, 144, -216},
    { -1104, 336, -288},
    { -1152, 176, -440},
    { -1440, 96, -368},
    { -1928, 208, -200},
    { -1112, -8, -32},
    { -1088, -16, -88},
    { -800, -200, 16},
    { -440, 56, -120},
    { -520, 32, -112},
    { -848, -240, 264},
    // 38 seconds
    { -968, 280, 424},
    { -1128, 992, -224},
    { -808, 688, -496},
    { -1176, 32, -104},
    { -1168, -8, -128},
    { -1864, 96, -176},
    { -784, 144, -384},
    { -984, -40, -264},
    { -1080, -160, -80},
    { -664, 104, -200},
    { -496, 264, -184},
    { -464, 200, -160},
    { -552, 248, -168},
    { -744, 256, -120},
    { -728, 104, 32},
    { -776, 504, -328},
    { -1128, 624, -656},
    { -1288, -264, -56},
    { -1992, 608, -600},
    { -1368, 56, -200},
    { -1208, 344, -200},
    { -944, -8, 16},
    { -480, -144, 168},
    { -464, -72, 16},
    { -472, -72, 152},
    // 39 seconds
    { -704, -376, -16},
    { -872, 232, 88},
    { -1056, 232, -104},
    { -1240, 320, -104},
    { -976, 320, -104},
    { -1800, 0, 8},
    { -1096, -136, -80},
    { -1008, -264, -24},
    { -1056, -288, 56},
    { -576, 264, -144},
    { -392, 256, -208},
    { -440, 224, -224},
    { -536, 312, -288},
    { -968, 592, -376},
    { -1088, -40, -136},
    { -1088, 120, -392},
    { -1136, 16, -120},
    { -1616, 448, -344},
    { -1600, 80, -64},
    { -1240, 240, -184},
    { -1024, 256, -192},
    { -784, 48, 0},
    { -464, 104, -64},
    { -456, 80, 0},
    { -544, 160, -32},
    // 40 seconds
    { -992, 0, 8},
    { -992, -128, -80},
    { -1168, 240, -96},
    { -1344, 232, -192},
    { -1008, 152, -208},
    { -1296, -96, -64},
    { -768, 56, -208},
    { -1032, 104, -232},
    { -1104, 56, -192},
    { -720, -8, -192},
    { -504, 56, -176},
    { -512, 168, -216},
    { -624, 120, -336},
    { -672, -216, -200},
    { -832, 104, -360},
    { -1096, 256, -408},
    { -1296, 112, -144},
    { -2136, 368, -536},
    { -1488, -48, -64},
    { -1024, 112, -264},
    { -824, -16, -248},
    { -584, 104, -248},
    { -456, 72, -208},
    { -520, 160, -200},
    { -736, 248, -112},
    // 41 seconds
    { -792, 264, -104},
    { -768, 192, -88},
    { -1088, 344, -152},
    { -1072, 240, 48},
    { -1000, 184, -128},
    { -1224, 120, -184},
    { -960, 144, -248},
    { -968, 232, -336},
    { -1016, 368, -480},
    { -512, 120, -264},
    { -400, 200, -368},
    { -552, 288, -352},
    { -720, 256, -472},
    { -896, 64, -280},
    { -1128, 104, -640},
    { -1040, 448, -656},
    { -1112, 56, -104},
    { -1872, 704, -600},
    { -1296, 216, -120},
    { -1232, 376, -208},
    { -888, 376, -120},
    { -568, 16, 48},
    { -456, 208, -56},
    { -544, 128, 88},
    { -712, 216, 80},
    // 42 seconds
    { -896, 392, -72},
    { -1120, 344, -8},
    { -1288, 216, -80},
    { -1056, 96, -8},
    { -1576, 304, 96},
    { -1304, 496, -280},
    { -952, 344, -304},
    { -1088, 88, -368},
    { -704, 48, -192},
    { -392, 136, -264},
    { -432, 208, -256},
    { -584, 296, -200},
    { -752, 328, -200},
    { -872, 312, -168},
    { -992, 504, -376},
    { -1144, 320, -248},
    { -976, 160, -48},
    { -1648, 864, -520},
    { -1456, -16, 80},
    { -1352, 432, -264},
    { -968, 208, -104},
    { -544, 104, -64},
    { -352, 192, -80},
    { -456, 224, -8},
    { -696, 248, 128},
    // 43 seconds
    { -792, 368, 120},
    { -752, 592, -112},
    { -1072, 400, -88},
    { -1232, 360, -72},
    { -1632, 376, -152},
    { -1176, -32, -128},
    { -856, 456, -480},
    { -1264, 184, -288},
    { -936, -96, -88},
    { -496, 80, -144},
    { -248, 40, -136},
    { -256, 288, -304},
    { -416, 504, -288},
    { -696, 704, -216},
    { -848, 472, -296},
    { -1128, 416, -152},
    { -1536, 424, -160},
    { -1880, 520, -160},
    { -1208, 104, -72},
    { -1064, 304, -280},
    { -800, 312, -144},
    { -544, 176, -56},
    { -376, 192, -96},
    { -504, 248, -24},
    { -632, 344, -136},
    // 44 seconds
    { -768, 136, -8},
    { -1088, 48, -136},
    { -1328, 424, -216},
    { -992, 384, -264},
    { -1688, 152, -16},
    { -888, 256, -184},
    { -776, 344, -376},
    { -1008, 200, -176},
    { -608, -56, -104},
    { -376, 88, -168},
    { -472, 280, -152},
    { -688, 440, -288},
    { -856, 200, -296},
    { -872, 272, -336},
    { -1040, 408, -456},
    { -1144, 240, -264},
    { -1416, 408, -432},
    { -1520, 544, -496},
    { -1192, 88, -32},
    { -1032, 160, -136},
    { -856, 128, -72},
    { -600, 136, 48},
    { -648, 312, -72},
    { -792, 176, 200},
    { -768, 344, -32},
    // 45 seconds
    { -856, -24, 72},
    { -896, 288, -112},
    { -928, 224, 40},
    { -1408, -88, 272},
    { -1800, 232, 96},
    { -1040, 496, -240},
    { -1104, 416, -336},
    { -848, 224, -176},
    { -416, 88, -136},
    { -480, 168, -232},
    { -616, 136, -128},
    { -960, 288, -384},
    { -888, 224, -216},
    { -848, 240, -240},
    { -1096, 392, -352},
    { -1368, 192, -48},
    { -1560, 208, -224},
    { -1320, 240, -224},
    { -1088, 192, -48},
    { -888, 272, -128},
    { -800, 296, -96},
    { -696, 192, 0},
    { -768, 296, 0},
    { -888, 272, 8},
    { -880, 256, 120},
    // 46 seconds
    { -872, 328, 32},
    { -1032, 48, -40},
    { -1008, 40, 80},
    { -1216, 168, -128},
    { -1576, 80, -80},
    { -624, 312, -304},
    { -936, 232, -200},
    { -896, 16, -80},
    { -672, -8, -144},
    { -568, 168, -216},
    { -568, 272, -192},
    { -728, 264, -272},
    { -824, -64, -296},
    { -920, 296, -408},
    { -992, 528, -560},
    { -1032, 368, -440},
    { -904, 240, -312},
    { -1544, 640, -688},
    { -1800, 296, -88},
    { -1496, -64, -8},
    { -984, 208, -112},
    { -560, 200, -64},
    { -528, 144, -48},
    { -568, 288, -112},
    { -608, 112, 80},
    // 47 seconds
    { -760, 168, -32},
    { -1000, 56, -136},
    { -1248, 40, 88},
    { -1104, 440, -232},
    { -1504, 72, -128},
    { -992, 88, -216},
    { -1088, 72, -176},
    { -1104, -104, -136},
    { -880, 0, -200},
    { -560, 224, -272},
    { -408, 216, -152},
    { -432, 128, -344},
    { -672, 232, -240},
    { -808, 200, -480},
    { -976, 224, -440},
    { -920, 328, -560},
    { -1000, 96, -368},
    { -1440, 368, -512},
    { -1520, 544, -576},
    { -1336, 240, -232},
    { -1192, 352, -288},
    { -888, 232, -128},
    { -648, 176, -64},
    { -616, 224, -128},
    { -704, 88, -8},
    // 48 seconds
    { -752, -120, 80},
    { -800, -312, -8},
    { -1104, -24, 8},
    { -1032, -232, -72},
    { -1720, -96, -72},
    { -1736, -208, -136},
    { -944, 216, -448},
    { -1112, 256, -440},
    { -888, 64, -160},
    { -600, 136, -184},
    { -552, 88, -480},
    { -432, -256, -376},
    { -504, 360, -432},
    { -768, 432, -528},
    { -856, 552, -680},
    { -888, 568, -664},
    { -968, 248, -536},
    { -1728, 464, -696},
    { -1576, 280, -480},
    { -1280, 160, -288},
    { -1168, 296, -288},
    { -1040, 256, -160},
    { -768, 192, -56},
    { -688, 256, -64},
    { -840, 232, 136},
    // 49 seconds
    { -704, -32, -64},
    { -728, 16, -32},
    { -848, 136, -120},
    { -976, -208, -88},
    { -1056, -176, -344},
    { -1672, -264, 8},
    { -1264, 168, -272},
    { -1376, 376, -392},
    { -1232, 296, -328},
    { -912, 200, -280},
    { -752, 232, -232},
    { -840, 112, -464},
    { -760, 240, -320},
    { -888, 632, -592},
    { -1048, 472, -696},
    { -912, 424, -680},
    { -1048, 392, -568},
    { -864, 264, -512},
    { -1464, 696, -864},
    { -1696, 320, -296},
    { -1704, -40, -72},
    { -1392, 168, -8},
    { -1128, 200, 24},
    { -920, 184, 48},
    { -952, 152, -64},
    // 50 seconds
    { -904, 216, 248},
    { -992, 264, -104},
    { -864, -112, 56},
    { -800, 112, -112},
    { -936, 136, -200},
    { -704, 240, -136},
    { -1232, 176, -80},
    { -1384, 280, -104},
    { -1208, 368, -264},
    { -1200, 456, -376},
    { -1104, 448, -344},
    { -816, 256, -136},
    { -656, 376, -384},
    { -744, 144, -352},
    { -704, 384, -376},
    { -728, 488, -544},
    { -712, 504, -776},
    { -784, 392, -624},
    { -1120, 24, -432},
    { -1904, -64, -808},
    { -1800, 24, -368},
    { -1648, 176, -368},
    { -1120, 56, -88},
    { -784, 0, 128},
    { -576, 16, 72},
    // 51 seconds
    { -640, 168, 104},
    { -688, -88, 192},
    { -1016, 232, 152},
    { -1120, -112, 88},
    { -1256, -256, 184},
    { -1512, -48, 176},
    { -1720, 256, -184},
    { -1104, 448, -384},
    { -1088, 224, -536},
    { -968, -200, -344},
    { -688, -240, -344},
    { -520, 112, -440},
    { -536, 128, -352},
    { -552, 624, -400},
    { -1112, 432, -312},
    { -1024, 384, -512},
    { -1024, 272, -400},
    { -1264, 264, -336},
    { -1872, 408, -472},
    { -1328, 80, -104},
    { -1128, 168, -264},
    { -864, 232, -200},
    { -568, 80, -48},
    { -488, 144, -56},
    { -608, 168, -32},
    // 52 seconds
    { -592, 32, 152},
    { -560, 464, -96},
    { -1136, 640, 24},
    { -1152, 488, -24},
    { -1288, 592, 32},
    { -1368, 592, 0},
    { -680, 728, -56},
    { -880, 704, 8},
    { -680, 640, 32},
    { -328, 568, 112},
    { -240, 608, 112},
    { -240, 592, 192},
    { -272, 672, 216},
    { -280, 808, 200},
    { -296, 984, 400},
    { -400, 1024, 416},
    { -488, 952, 440},
    { -784, 1296, 424},
    { -720, 1088, 440},
    { -680, 896, 416},
    { -520, 656, 280},
    { -368, 456, 248},
    { -264, 512, 168},
    { -232, 592, 240},
    { -360, 512, 368},
    // 53 seconds
    { -472, 752, 280},
    { -464, 744, 320},
    { -816, 1096, 376},
    { -848, 1072, 208},
    { -1200, 1296, 328},
    { -528, 1072, 208},
    { -592, 936, 128},
    { -704, 896, 304},
    { -424, 728, 176},
    { -200, 568, 152},
    { -112, 512, 184},
    { -80, 576, 208},
    { -128, 728, 224},
    { -152, 808, 328},
    { -96, 992, 384},
    { -280, 792, 408},
    { -448, 1232, 728},
    { -520, 1288, 472},
    { -568, 864, 616},
    { -520, 992, 528},
    { -504, 640, 480},
    { -288, 632, 344},
    { -72, 560, 288},
    { -16, 544, 288},
    { -144, 680, 368},
    // 54 seconds
    { -248, 768, 456},
    { -392, 968, 480},
    { -528, 1328, 488},
    { -720, 952, 304},
    { -968, 1096, 456},
    { -640, 1008, 296},
    { -728, 1032, 192},
    { -640, 784, 248},
    { -392, 672, 144},
    { -120, 504, 88},
    { -32, 464, 112},
    { -24, 680, 40},
    { -8, 936, 88},
    { -224, 1128, 176},
    { -424, 1064, 240},
    { -552, 1216, 288},
    { -344, 880, 440},
    { -552, 1104, 440},
    { -720, 1072, 640},
    { -864, 1024, 480},
    { -648, 840, 296},
    { -328, 544, 288},
    { -88, 440, 80},
    { -8, 488, 56},
    { -80, 536, 152},
    // 55 seconds
    { -160, 824, 112},
    { -392, 968, 376},
    { -904, 1184, 216},
    { -760, 1080, 48},
    { -856, 864, 216},
    { -624, 1080, 208},
    { -624, 1040, 96},
    { -552, 1008, 72},
    { -320, 744, 88},
    { -128, 624, 88},
    { -48, 616, 80},
    { -56, 696, 136},
    { -176, 808, 224},
    { -248, 1056, 192},
    { -424, 816, 0},
    { -448, 992, 32},
    { -480, 704, 64},
    { -944, 792, -96},
    { -1400, 208, 112},
    { -1392, 736, -184},
    { -1216, 552, -160},
    { -904, 632, -136},
    { -464, 512, 64},
    { -680, 360, 112},
    { -776, -88, -16},
    // 56 seconds
    { -984, 200, -120},
    { -968, -168, -216},
    { -1272, 400, -192},
    { -1352, 152, -80},
    { -1368, 184, -192},
    { -536, 168, -200},
    { -1240, -56, -80},
    { -928, -144, 24},
    { -504, 0, -184},
    { -448, 112, -256},
    { -520, 136, -216},
    { -656, 152, -224},
    { -832, 224, -136},
    { -1096, 568, -344},
    { -1168, 384, -184},
    { -1072, 272, -184},
    { -1752, 608, -248},
    { -1224, 288, 96},
    { -1048, 392, -296},
    { -784, 384, -184},
    { -640, 160, -24},
    { -552, 184, 32},
    { -496, 288, -40},
    { -600, 288, 32},
    { -808, 416, -8},
    // 57 seconds
    { -920, 144, 104},
    { -1160, 192, 72},
    { -1256, 456, -176},
    { -1264, 296, -8},
    { -1392, 136, -24},
    { -704, 440, -312},
    { -1008, 152, -280},
    { -864, 144, -184},
    { -512, 88, -152},
    { -440, 144, -160},
    { -488, 248, -168},
    { -664, 344, -176},
    { -856, 456, -208},
    { -920, 680, -312},
    { -1016, 632, -504},
    { -1072, 488, -168},
    { -1656, 888, -560},
    { -1296, 488, -160},
    { -1160, 576, -272},
    { -848, 344, -184},
    { -624, 152, 24},
    { -480, 264, -112},
    { -440, 256, -32},
    { -608, 200, 32},
    { -984, 40, 104},
    // 58 seconds
    { -744, 64, 64},
    { -1040, 184, -32},
    { -1096, 128, -112},
    { -1016, 160, -224},
    { -1968, 0, -48},
    { -1120, -8, -72},
    { -1264, 360, -432},
    { -1040, 328, -296},
    { -688, 296, -208},
    { -480, 248, -200},
    { -480, 240, -144},
    { -680, 408, -336},
    { -808, 416, -352},
    { -928, 72, -528},
    { -872, 368, -400},
    { -1016, 328, -400},
    { -1272, 248, -304},
    { -1544, 584, -584},
    { -1256, -112, 0},
    { -1184, 248, -272},
    { -840, 216, -152},
    { -648, 56, -80},
    { -752, 48, 40},
    { -824, 168, 56},
    { -952, 240, -16},
    // 59 seconds
    { -752, 344, 96},
    { -1096, 392, -200},
    { -1160, 32, -64},
    { -1176, 272, -152},
    { -1648, -168, 168},
    { -1136, 688, -376},
    { -1272, 248, -264},
    { -1024, 448, -280},
    { -464, 304, -216},
    { -272, 272, -104},
    { -384, 376, -104},
    { -592, 488, -88},
    { -816, 616, -64},
    { -1024, 456, -312},
    { -944, 720, -328},
    { -1072, 208, -48},
    { -1376, 648, -352},
    { -1464, 352, -112},
    { -1288, 392, -224},
    { -1224, 312, -200},
    { -808, 80, -8},
    { -448, 112, -72},
    { -480, 192, -56},
    { -656, 128, 72},
    { -800, 224, -8},
    // 60 seconds
    // elapsed: 1 minutes
    { -816, 216, -32},
    { -1216, 192, 0},
    { -1168, 248, -152},
    { -1752, 88, -8},
    { -1200, 288, -176},
    { -792, 384, -456},
    { -1120, 168, -264},
    { -784, 104, -184},
    { -424, 192, -240},
    { -360, 136, -264},
    { -504, 360, -336},
    { -672, 344, -264},
    { -832, 552, -296},
    { -776, 608, -608},
    { -1088, 472, -256},
    { -1088, 200, -184},
    { -1752, 840, -632},
    { -1120, 176, 16},
    { -1296, 336, -256},
    { -1104, 176, -144},
    { -672, 80, -80},
    { -472, 160, -104},
    { -568, 152, -24},
    { -792, 160, -24},
    { -896, 112, 16},
    // 61 seconds
    { -872, 72, 56},
    { -936, -288, -272},
    { -1128, -48, 64},
    { -1216, 256, -208},
    { -1720, 16, 48},
    { -904, 304, -240},
    { -920, 344, -400},
    { -840, 112, -208},
    { -488, 0, -184},
    { -400, 152, -216},
    { -512, 216, -248},
    { -648, 336, -256},
    { -848, 40, -336},
    { -888, 200, -312},
    { -1016, 528, -480},
    { -1032, 88, -232},
    { -1560, 560, -600},
    { -1304, 80, -192},
    { -1256, -32, -120},
    { -1096, 248, -248},
    { -704, 16, -8},
    { -464, 168, -128},
    { -576, 208, -80},
    { -688, 72, 8},
    { -776, 184, 160},
    // 62 seconds
    { -976, 408, -176},
    { -1176, 208, 112},
    { -1032, 232, -168},
    { -1200, 152, -136},
    { -1688, 8, 88},
    { -928, 344, -304},
    { -1104, 72, -240},
    { -944, 16, -256},
    { -552, -56, -208},
    { -448, 64, -248},
    { -472, 120, -296},
    { -560, 264, -352},
    { -704, 208, -376},
    { -1008, 408, -288},
    { -1152, 384, -416},
    { -1112, 56, -208},
    { -1632, 888, -808},
    { -1488, -64, -160},
    { -1344, 232, -232},
    { -936, 112, -176},
    { -680, 16, -32},
    { -496, 8, 16},
    { -496, 32, 24},
    { -736, 56, 128},
    { -1176, 192, -288},
    // 63 seconds
    { -928, -80, -144},
    { -1080, 216, -264},
    { -1072, -128, 8},
    { -1144, -16, -192},
    { -1712, -200, -8},
    { -848, 104, -160},
    { -1024, 264, -328},
    { -856, 16, -192},
    { -672, 16, -200},
    { -536, 216, -264},
    { -528, 240, -256},
    { -640, 200, -280},
    { -848, 88, -400},
    { -952, 208, -408},
    { -960, 392, -568},
    { -1192, 88, -376},
    { -1408, 192, -304},
    { -1640, 376, -384},
    { -1120, -16, -56},
    { -1056, 200, -184},
    { -904, 0, -8},
    { -656, 0, -32},
    { -544, 80, -56},
    { -600, 88, -32},
    { -672, 64, 56},
    // 64 seconds
    { -728, 64, -288},
    { -960, 64, 8},
    { -1208, 320, -240},
    { -1112, -88, -72},
    { -1280, 96, -248},
    { -1712, 16, -200},
    { -880, 176, -312},
    { -920, 320, -488},
    { -704, -32, -176},
    { -304, -120, -208},
    { -336, 312, -392},
    { -808, 72, -272},
    { -864, 288, -384},
    { -1016, -24, -344},
    { -1032, 184, -584},
    { -1128, 256, -544},
    { -1104, -8, -256},
    { -1632, 424, -624},
    { -1104, 112, -216},
    { -1064, 224, -224},
    { -976, 392, -280},
    { -720, 80, -8},
    { -568, 48, -24},
    { -632, 192, -72},
    { -736, 520, -264},
    // 65 seconds
    { -728, 56, -48},
    { -872, 128, -248},
    { -1184, 8, -192},
    { -1272, 152, -288},
    { -1616, 144, -232},
    { -704, 240, -408},
    { -920, -136, -424},
    { -872, -64, -344},
    { -480, 64, -328},
    { -336, 120, -328},
    { -560, 256, -456},
    { -640, -112, -496},
    { -848, 368, -456},
    { -856, 296, -392},
    { -1096, 272, -464},
    { -1168, 216, -288},
    { -2096, 480, -608},
    { -1016, 80, -96},
    { -992, 240, -384},
    { -736, 240, -264},
    { -488, 32, -64},
    { -464, 120, -152},
    { -568, 192, -48},
    { -1024, 128, -168},
    { -912, -64, -96},
    // 66 seconds
    { -816, 72, -152},
    { -1096, 184, -216},
    { -1128, -80, -144},
    { -1624, 336, -296},
    { -1536, 88, -160},
    { -656, 360, -464},
    { -936, 24, -264},
    { -672, -152, -112},
    { -384, 64, -256},
    { -400, 160, -176},
    { -648, 280, -272},
    { -992, 360, -328},
    { -960, 360, -224},
    { -736, 424, -464},
    { -1048, 464, -464},
    { -1024, 104, -224},
    { -1544, 512, -536},
    { -1256, 352, -416},
    { -1008, 216, -144},
    { -1000, 160, -152},
    { -712, 64, -64},
    { -520, 152, -72},
    { -592, 248, -96},
    { -736, 176, 0},
    { -1088, 448, -224},
    // 67 seconds
    { -928, -152, -88},
    { -960, 184, -168},
    { -1104, 232, -200},
    { -928, -200, -104},
    { -1584, 440, -368},
    { -1152, 488, -312},
    { -1032, 576, -576},
    { -1008, 536, -424},
    { -528, 136, -104},
    { -312, 256, -200},
    { -376, 248, -120},
    { -496, 248, -104},
    { -672, 320, -72},
    { -952, 216, -280},
    { -952, 16, -200},
    { -984, 384, -384},
    { -880, 120, -168},
    { -1360, 576, -456},
    { -1808, 464, -272},
    { -960, 216, -168},
    { -1168, 432, -312},
    { -816, 56, -80},
    { -408, 96, -136},
    { -448, 176, -88},
    { -608, 200, 48},
    // 68 seconds
    { -632, -24, -104},
    { -864, 88, -24},
    { -1152, 24, -64},
    { -1152, 256, -216},
    { -1072, 320, -168},
    { -2016, -8, -88},
    { -640, 136, -304},
    { -1160, 208, -368},
    { -1032, -160, -88},
    { -392, -16, -264},
    { -368, 120, -184},
    { -448, 232, -240},
    { -640, 216, -208},
    { -776, 240, -256},
    { -1016, 272, -360},
    { -960, -72, -240},
    { -1016, 144, -232},
    { -2000, 656, -688},
    { -1472, 16, -24},
    { -1152, 120, -224},
    { -984, 72, -184},
    { -736, 64, -128},
    { -576, 120, -96},
    { -616, 24, -16},
    { -536, -32, 72},
    // 69 seconds
    { -800, 248, -112},
    { -1080, -120, 120},
    { -1328, 112, -144},
    { -1384, -32, -80},
    { -1168, 16, -264},
    { -1608, -72, -80},
    { -832, 128, -352},
    { -840, 144, -304},
    { -848, -216, -128},
    { -448, -80, -136},
    { -400, 80, -136},
    { -528, 144, -152},
    { -688, 192, -144},
    { -896, 528, -320},
    { -1200, 432, -248},
    { -1032, 208, -448},
    { -1288, 0, -192},
    { -1344, 88, -320},
    { -1888, 584, -608},
    { -1104, -56, -192},
    { -976, 136, -304},
    { -880, 24, -112},
    { -616, -8, -8},
    { -616, 152, -24},
    { -760, 152, 0},
    // 70 seconds
    { -992, 376, -48},
    { -1136, 48, 24},
    { -944, 152, -112},
    { -1088, 64, -144},
    { -1048, 144, 0},
    { -1192, 184, -176},
    { -1736, 136, -56},
    { -656, 472, -392},
    { -776, 480, -304},
    { -832, 376, -192},
    { -496, 552, -128},
    { -416, 488, -80},
    { -440, 928, -200},
    { -544, 336, -152},
    { -480, 864, 184},
    { -320, 976, 256},
    { -432, 1344, 128},
    { -608, 920, 176},
    { -728, 1136, 344},
    { -816, 1256, 128},
    { -664, 784, 232},
    { -392, 704, 80},
    { -328, 552, 176},
    { -216, 488, 128},
    { -96, 672, 184},
    // 71 seconds
    { -72, 832, 304},
    { -152, 1032, 160},
    { -192, 984, 288},
    { -128, 1000, 424},
    { -400, 1264, 360},
    { -400, 1448, 440},
    { -632, 1040, 424},
    { -328, 1008, 64},
    { -176, 720, -8},
    { -152, 536, -24},
    { -8, 528, -48},
    { 24, 496, -24},
    { -40, 568, 216},
    { 8, 1048, 208},
    { -40, 1048, 168},
    { 0, 808, 80},
    { -168, 824, -16},
    { -280, 704, 208},
    { -664, 848, 192},
    { -1152, 1112, -168},
    { -1096, 1016, -40},
    { -904, 784, -40},
    { -808, 568, -128},
    { -720, 584, -184},
    { -744, 784, -232},
    // 72 seconds
    { -960, 832, -304},
    { -936, 256, -96},
    { -928, 88, -128},
    { -1200, 176, -136},
    { -1192, 200, -72},
    { -1264, 168, -136},
    { -1856, -16, -8},
    { -528, -56, -88},
    { -1080, -176, -88},
    { -872, -136, -16},
    { -568, 72, -112},
    { -488, 80, -160},
    { -592, 88, -128},
    { -824, 96, -336},
    { -992, 64, -64},
    { -800, 344, -440},
    { -1096, 208, -360},
    { -1168, -40, -96},
    { -1712, 440, -424},
    { -1744, 200, -96},
    { -1136, -8, 8},
    { -936, 272, -232},
    { -712, -48, 8},
    { -424, 80, -24},
    { -528, 184, -40},
    // 73 seconds
    { -624, 200, 8},
    { -760, 200, -64},
    { -1000, -48, 72},
    { -1064, 248, -96},
    { -1248, 120, -112},
    { -1088, 184, -56},
    { -1960, 248, -240},
    { -760, 32, -160},
    { -768, 64, -224},
    { -792, -88, -160},
    { -520, 40, -160},
    { -512, 128, -152},
    { -680, 216, -192},
    { -792, 272, -224},
    { -888, 592, -200},
    { -992, 648, -368},
    { -920, 424, -424},
    { -1088, 216, -296},
    { -1704, 336, -360},
    { -1824, 664, -448},
    { -1064, -88, -8},
    { -888, 296, -328},
    { -736, 160, -152},
    { -536, 120, -64},
    { -640, 120, -16},
    // 74 seconds
    { -744, 152, 32},
    { -872, 240, -24},
    { -760, 176, -200},
    { -864, 224, -72},
    { -1008, 120, -160},
    { -1072, 112, -136},
    { -1336, 408, -248},
    { -1480, 88, -104},
    { -816, 280, -304},
    { -1000, 240, -336},
    { -936, 128, -232},
    { -624, 48, -208},
    { -480, 72, -224},
    { -512, 112, -240},
    { -672, 248, -296},
    { -784, 216, -272},
    { -792, 280, -368},
    { -1048, 136, -360},
    { -1120, 296, -400},
    { -1280, 232, -328},
    { -1792, 552, -536},
    { -1096, 8, -64},
    { -928, 376, -376},
    { -920, 184, -200},
    { -800, 120, -40},
    // 75 seconds
    { -648, 120, -16},
    { -640, 208, -16},
    { -648, 152, 88},
    { -672, 80, 144},
    { -728, 80, -72},
    { -832, 216, 24},
    { -1080, 256, -104},
    { -1104, 168, -128},
    { -1848, 328, -168},
    { -1080, 176, -256},
    { -704, 368, -392},
    { -1056, -168, -176},
    { -856, -144, -168},
    { -664, 80, -248},
    { -560, 80, -216},
    { -592, 192, -208},
    { -720, 264, -288},
    { -888, 48, -176},
    { -736, 280, -224},
    { -712, 328, -256},
    { -1080, 312, -440},
    { -1080, 128, -136},
    { -1736, 768, -704},
    { -1344, 112, -128},
    { -1136, 144, -264},
    // 76 seconds
    { -1016, 224, -192},
    { -752, 40, -32},
    { -576, 24, 0},
    { -640, 152, 24},
    { -728, 168, 24},
    { -848, 152, 80},
    { -776, 360, -8},
    { -816, 464, -104},
    { -1000, 296, -48},
    { -968, 176, -16},
    { -1128, 200, -144},
    { -1696, 176, -112},
    { -1072, 136, -264},
    { -1216, 264, -432},
    { -1144, -104, -224},
    { -736, 24, -272},
    { -592, 96, -272},
    { -608, 208, -312},
    { -584, 208, -272},
    { -608, 160, -248},
    { -760, 184, -240},
    { -888, 600, -312},
    { -1328, 360, -392},
    { -1096, 528, -424},
    { -1328, 272, -288},
    // 77 seconds
    { -1584, 192, -256},
    { -1184, 152, -112},
    { -1032, 256, -288},
    { -984, 240, -176},
    { -864, 24, 32},
    { -720, 48, 24},
    { -736, 96, 24},
    { -808, 128, 40},
    { -856, 232, -16},
    { -872, 312, -64},
    { -856, 320, -104},
    { -848, 296, -128},
    { -832, 280, -104},
    { -1472, 496, -200},
    { -728, 256, -152},
    { -1312, 328, -216},
    { -1616, 144, -48},
    { -768, 416, -152},
    { -856, 512, -120},
    { -888, 376, 64},
    { -752, 584, 72},
    { -776, 560, 128},
    { -704, 720, 56},
    { -672, 696, 80},
    { -616, 680, 96},
    // 78 seconds
    { -536, 760, 96},
    { -464, 784, 168},
    { -416, 840, 184},
    { -368, 800, 216},
    { -344, 800, 272},
    { -320, 888, 256},
    { -336, 872, 312},
    { -328, 840, 304},
    { -312, 808, 304},
    { -248, 816, 328},
    { -200, 848, 344},
    { -176, 856, 360},
    { -160, 888, 392},
    { -128, 920, 408},
    { -152, 968, 416},
    { -176, 952, 408},
    { -208, 888, 400},
    { -240, 888, 376},
    { -224, 880, 368},
    { -248, 856, 376},
    { -240, 864, 384},
    { -256, 872, 376},
    { -264, 848, 392},
    { -248, 864, 384},
    { -248, 904, 392},
    // 79 seconds
    { -272, 968, 400},
    { -288, 992, 400},
    { -304, 968, 360},
    { -304, 904, 312},
    { -296, 872, 296},
    { -280, 896, 304},
    { -296, 928, 304},
    { -304, 920, 312},
    { -272, 896, 296},
    { -240, 896, 296},
    { -224, 920, 320},
    { -200, 960, 336},
    { -184, 952, 336},
    { -144, 952, 344},
    { -136, 968, 344},
    { -128, 968, 352},
    { -128, 1000, 368},
    { -144, 992, 360},
    { -152, 952, 352},
    { -120, 920, 320},
    { -112, 896, 304},
    { -88, 832, 328},
    { -72, 856, 344},
    { -72, 944, 344},
    { -48, 968, 344},
    // 80 seconds
    { -80, 992, 344},
    { -80, 928, 336},
    { -88, 904, 296},
    { -96, 880, 304},
    { -128, 864, 296},
    { -144, 872, 288},
    { -136, 896, 296},
    { -120, 968, 288},
    { -128, 968, 328},
    { -144, 1016, 288},
    { -136, 928, 272},
    { -136, 904, 248},
    { -168, 912, 272},
    { -184, 920, 264},
    { -176, 872, 256},
    { -216, 872, 232},
    { -208, 880, 240},
    { -264, 968, 232},
    { -344, 1056, 224},
    { -376, 936, 224},
    { -352, 1000, 120},
    { -312, 896, 104},
    { -344, 872, 104},
    { -312, 848, 128},
    { -248, 864, 120},
    // 81 seconds
    { -160, 864, 96},
    { -136, 840, 192},
    { -72, 888, 224},
    { 0, 912, 216},
    { 16, 880, 224},
    { 48, 920, 216},
    { 80, 1040, 184},
    { 96, 1216, 144},
    { 48, 1248, 216},
    { 32, 1280, 128},
    { 144, 1144, 240},
    { 152, 1128, 128},
    { 56, 768, 240},
    { -168, 736, 512},
    { -536, 1448, 744},
    { -984, 1256, 720},
    { -568, 904, 408},
    { -264, 904, 280},
    { -128, 536, 328},
    { 48, 720, 168},
    { 128, 640, 256},
    { 112, 768, 424},
    { 32, 1000, 272},
    { 8, 1296, 272},
    { -144, 1152, 472},
    // 82 seconds
    { -192, 1232, 312},
    { -104, 1128, 216},
    { -272, 872, 312},
    { -368, 912, 272},
    { -312, 832, 224},
    { -160, 696, 136},
    { 32, 472, 112},
    { 144, 384, 104},
    { 152, 512, 88},
    { 48, 664, 240},
    { 80, 920, 80},
    { -272, 1088, 56},
    { -608, 1144, 56},
    { -1296, 1232, 256},
    { -1424, 1112, -48},
    { -1368, 600, -64},
    { -1064, 576, -248},
    { -640, 424, -96},
    { -504, 344, -144},
    { -456, 400, -176},
    { -664, 296, 48},
    { -776, 152, -368},
    { -1216, -72, 96},
    { -1440, 400, -288},
    { -1264, 96, -32},
    // 83 seconds
    { -1600, 120, -112},
    { -576, -40, -152},
    { -760, 328, -280},
    { -912, 104, -176},
    { -512, 248, -72},
    { -296, 304, -112},
    { -344, 472, -128},
    { -400, 288, 56},
    { -616, 448, 8},
    { -816, 944, 96},
    { -864, 968, -56},
    { -1008, 912, 0},
    { -976, 640, 80},
    { -1256, 912, 32},
    { -1136, 728, 56},
    { -1048, 672, 16},
    { -792, 520, 56},
    { -440, 272, 152},
    { -320, 400, 136},
    { -272, 104, 296},
    { -560, 392, 272},
    { -832, 488, 32},
    { -1032, 424, -40},
    { -1400, 512, -136},
    { -1256, 584, -232},
    // 84 seconds
    { -1944, 424, -88},
    { -432, 272, -200},
    { -952, 184, -24},
    { -712, 0, -48},
    { -304, 184, -64},
    { -288, 224, -128},
    { -552, 256, -168},
    { -848, 392, -248},
    { -1168, 336, -344},
    { -1008, 544, -424},
    { -1072, 256, -248},
    { -1456, 312, -184},
    { -1976, 472, -424},
    { -1280, 0, 16},
    { -1064, 136, -192},
    { -760, -16, -8},
    { -368, 80, -80},
    { -368, 64, 0},
    { -528, 136, 16},
    { -904, 456, -128},
    { -1184, 480, -200},
    { -1264, 224, -168},
    { -1288, 24, -80},
    { -1248, 216, -152},
    { -1736, 72, -24},
    // 85 seconds
    { -784, 264, -352},
    { -824, 200, -352},
    { -800, -32, -184},
    { -464, -8, -240},
    { -440, 40, -192},
    { -496, 344, -368},
    { -544, 376, -312},
    { -952, 592, -424},
    { -768, 168, -248},
    { -1024, 288, -368},
    { -1072, -136, -32},
    { -2152, 656, -544},
    { -1320, -64, -88},
    { -1232, 16, -208},
    { -848, -176, -88},
    { -480, -48, -96},
    { -392, 96, -88},
    { -536, 144, -88},
    { -632, 56, 32},
    { -696, 264, -112},
    { -1224, 88, -40},
    { -1168, -160, -40},
    { -912, 120, -208},
    { -2008, -24, -104},
    { -1016, 192, -232},
    // 86 seconds
    { -856, 128, -368},
    { -888, -144, -152},
    { -536, -8, -216},
    { -400, 8, -144},
    { -488, 160, -168},
    { -608, 232, -248},
    { -688, 216, -304},
    { -960, 432, -360},
    { -992, 216, -400},
    { -928, 8, -160},
    { -1976, 784, -712},
    { -2024, 112, -224},
    { -1440, -8, -144},
    { -912, 160, -224},
    { -360, -40, -88},
    { -232, 80, -104},
    { -352, 112, -40},
    { -608, 192, -32},
    { -784, -184, 88},
    { -1136, 128, 96},
    { -1200, -112, 8},
    { -944, 24, -136},
    { -1784, -32, -152},
    { -1160, 240, -336},
    { -1280, 240, -488},
    // 87 seconds
    { -952, 24, -320},
    { -424, -96, -184},
    { -280, -72, -208},
    { -352, -8, -208},
    { -520, 192, -256},
    { -800, 216, -272},
    { -1040, 248, -328},
    { -928, 320, -496},
    { -1568, 200, -464},
    { -928, -40, -184},
    { -2024, 744, -848},
    { -1480, -344, 32},
    { -1264, 424, -416},
    { -1104, 200, -232},
    { -568, 80, -112},
    { -384, 128, -104},
    { -376, 184, -144},
    { -280, 296, -368},
    { -936, 376, -320},
    { -1072, -32, 0},
    { -1376, -48, 136},
    { -1408, -224, -160},
    { -1280, -192, 224},
    { -1296, 184, -184},
    { -1520, -360, 152},
    // 88 seconds
    { -1360, 56, -200},
    { -1160, 8, -184},
    { -768, 136, -216},
    { -424, 120, -240},
    { -320, 136, -400},
    { -408, 216, -520},
    { -824, -40, -464},
    { -1120, 16, -368},
    { -792, -512, -624},
    { -1088, 1112, -840},
    { -920, -328, -40},
    { -1576, 768, -640},
    { -1568, 0, -16},
    { -1264, 144, -32},
    { -960, 128, -184},
    { -680, -40, 40},
    { -448, 80, -8},
    { -440, 104, -128},
    { -528, 104, -184},
    { -800, -8, -168},
    { -1144, -96, -88},
    { -1056, 96, -136},
    { -1944, -8, -344},
    { -1288, 184, -216},
    { -1544, -168, 8},
    // 89 seconds
    { -672, 296, -384},
    { -832, -112, -40},
    { -792, -72, -192},
    { -488, 80, -304},
    { -416, 96, -224},
    { -512, 152, -392},
    { -736, 160, -280},
    { -992, 120, -312},
    { -944, 64, -336},
    { -1032, 672, -544},
    { -1176, -48, -168},
    { -1304, 232, -376},
    { -1712, 344, -504},
    { -1456, -200, -48},
    { -1208, 176, -192},
    { -824, -16, -112},
    { -376, -24, -64},
    { -528, 184, -72},
    { -568, 200, -224},
    { -712, 312, -328},
    { -808, 8, 16},
    { -1392, 320, -224},
    { -1200, 160, 32},
    { -1040, 160, -120},
    { -1328, -136, 104},
    // 90 seconds
    { -920, 464, -160},
    { -1008, 464, -328},
    { -816, 120, -224},
    { -440, 8, -168},
    { -352, 112, -304},
    { -496, 104, -296},
    { -720, 232, -392},
    { -840, 112, -168},
    { -1096, 560, -992},
    { -1176, 256, -240},
    { -984, 152, -200},
    { -1928, 672, -704},
    { -1432, -240, 8},
    { -1368, 312, -360},
    { -1032, 56, -144},
    { -472, 88, -96},
    { -344, 192, -40},
    { -392, 8, 168},
    { -448, -408, 152},
    { -976, 424, -320},
    { -1080, 568, -224},
    { -1288, 472, -128},
    { -1208, 72, 16},
    { -1408, 24, 16},
    { -1096, 56, -160},
    // 91 seconds
    { -1024, 128, -208},
    { -1024, 88, -168},
    { -736, 72, -160},
    { -456, 16, -168},
    { -464, 96, -176},
    { -608, 184, -200},
    { -776, 312, -288},
    { -752, 272, -432},
    { -1008, 312, -208},
    { -1200, 416, -440},
    { -1392, 136, -184},
    { -1760, 320, -384},
    { -1256, -208, -24},
    { -1072, 96, -176},
    { -808, 0, -88},
    { -528, 40, -40},
    { -464, 104, -48},
    { -584, 104, 24},
    { -848, 176, -40},
    { -960, 56, 112},
    { -1344, 552, -208},
    { -1376, 64, 40},
    { -1120, -104, 32},
    { -1304, 0, -48},
    { -1512, -96, 80},
    // 92 seconds
    { -768, 136, -312},
    { -896, -88, -264},
    { -728, -96, -152},
    { -512, -56, -160},
    { -488, 56, -208},
    { -624, 120, -240},
    { -840, 192, -200},
    { -976, 432, -296},
    { -1048, 208, -344},
    { -1048, 88, -304},
    { -1120, -40, -176},
    { -1976, 736, -632},
    { -1304, -152, 72},
    { -1064, 200, -264},
    { -872, -24, -72},
    { -600, -8, 0},
    { -592, 128, -16},
    { -656, 24, 72},
    { -800, -144, -88},
    { -744, -208, -32},
    { -1104, 24, -32},
    { -1288, 32, -96},
    { -1008, -48, -160},
    { -1960, 728, -360},
    { -992, 264, -160},
    // 93 seconds
    { -1008, -168, -56},
    { -1032, -136, -96},
    { -656, 16, -192},
    { -448, 32, -192},
    { -432, 104, -232},
    { -608, 136, -248},
    { -880, 200, -256},
    { -784, -56, -432},
    { -1048, 288, -216},
    { -992, 128, -352},
    { -1080, 0, -120},
    { -1848, 728, -768},
    { -1696, -96, 56},
    { -1192, -88, -80},
    { -768, 184, -160},
    { -560, -32, -80},
    { -560, -48, 40},
    { -680, 80, 8},
    { -704, 128, 16},
    { -784, -96, 0},
    { -840, 40, 24},
    { -1168, 168, -120},
    { -1088, -40, -72},
    { -1632, 432, -336},
    { -1472, 208, -144},
    // 94 seconds
    { -816, 224, -360},
    { -1016, -176, -128},
    { -832, -88, -200},
    { -512, -80, -184},
    { -496, 0, -208},
    { -600, 40, -264},
    { -752, 80, -312},
    { -952, 72, -272},
    { -936, 72, -360},
    { -952, 192, -496},
    { -920, 80, -496},
    { -1256, 40, -216},
    { -1784, 400, -608},
    { -1304, 0, 104},
    { -1112, 144, -296},
    { -952, 136, -160},
    { -576, 16, -24},
    { -528, 144, -64},
    { -656, 200, -48},
    { -792, 176, 0},
    { -824, 152, 56},
    { -896, 360, 56},
    { -1184, 824, -152},
    { -1240, 632, 736},
    { -1576, 1864, -64},
    // 95 seconds
    { -744, 384, 344},
    { -464, 1112, -320},
    { -544, 888, -168},
    { -440, 808, -32},
    { -208, 632, 24},
    { -48, 600, 8},
    { -8, 560, 120},
    { 24, 704, 56},
    { 40, 736, 72},
    { 16, 848, 40},
    { -8, 928, 96},
    { -208, 1072, 8},
    { -384, 576, 48},
    { -288, 752, -152},
    { -752, 768, -136},
    { -896, 536, 32},
    { -1056, 512, 112},
    { -1456, 472, 424},
    { -1480, 784, 288},
    { -640, 832, -16},
    { -704, 648, 24},
    { -728, 616, 112},
    { -792, 472, 168},
    { -888, 472, 0},
    { -1112, 720, -72},
    // 96 seconds
    { -1184, 600, -368},
    { -1720, 248, -256},
    { -840, 0, -240},
    { -1152, -168, 8},
    { -1032, -352, 24},
    { -616, 40, -184},
    { -472, 144, -216},
    { -520, 192, -104},
    { -584, 232, 48},
    { -784, 384, -224},
    { -984, 184, -224},
    { -776, 552, -576},
    { -1032, 440, -440},
    { -1264, 64, -16},
    { -1400, 184, -152},
    { -1688, 304, -256},
    { -1080, 80, 48},
    { -864, 360, -304},
    { -928, 184, -56},
    { -616, 0, -32},
    { -672, 128, -64},
    { -736, 56, 96},
    { -672, 280, 32},
    { -792, 464, -96},
    { -936, 360, -88},
    // 97 seconds
    { -1240, 424, -176},
    { -1056, 144, -120},
    { -1320, 344, -128},
    { -1400, 72, -8},
    { -808, 208, -216},
    { -1048, 184, -224},
    { -872, -24, -104},
    { -552, 48, -160},
    { -424, 176, -168},
    { -496, 200, -184},
    { -648, 232, -200},
    { -808, 296, -200},
    { -848, 280, -248},
    { -832, 344, -336},
    { -1416, 784, -376},
    { -1152, -200, -128},
    { -1936, 1008, -784},
    { -1256, -24, -16},
    { -1184, 480, -360},
    { -1024, 160, -112},
    { -664, 112, -48},
    { -560, 152, -24},
    { -624, 200, 8},
    { -720, 216, 8},
    { -776, 192, 32},
    // 98 seconds
    { -776, 136, 56},
    { -1080, 512, -48},
    { -1464, 144, -144},
    { -1096, 0, -80},
    { -1992, 256, -216},
    { -1248, 240, -152},
    { -760, 496, -416},
    { -920, 176, -264},
    { -584, 96, -216},
    { -384, 200, -152},
    { -528, 160, -112},
    { -832, 608, -288},
    { -1064, 152, -448},
    { -728, 576, -480},
    { -544, 376, -336},
    { -1008, 456, -280},
    { -1416, 112, 136},
    { -2264, 840, -320},
    { -1320, 56, 136},
    { -1208, 512, -184},
    { -784, 200, -56},
    { -496, 32, -16},
    { -424, 184, -32},
    { -584, 128, 120},
    { -896, 336, -8},
    // 99 seconds
    { -1296, 352, -168},
    { -1048, -32, 48},
    { -1288, 304, -168},
    { -1176, 16, -160},
    { -960, 104, -184},
    { -1592, -152, -24},
    { -1040, 256, -224},
    { -736, 368, -312},
    { -880, 304, -160},
    { -688, 168, -128},
    { -576, 232, -128},
    { -520, 320, -152},
    { -632, 488, -136},
    { -784, 264, -280},
    { -896, 144, -144},
    { -1040, 312, -328},
    { -1464, -176, 40},
    { -1680, 80, -168},
    { -1512, -48, -56},
    { -1008, -88, 32},
    { -952, -136, 112},
    { -616, -72, 136},
    { -544, 88, 16},
    { -728, -40, 216},
    { -832, 144, 184},
    // 100 seconds
    { -904, 136, 152},
    { -1016, 96, 16},
    { -1056, 104, -8},
    { -1304, 216, -104},
    { -880, 24, -248},
    { -1792, -144, 168},
    { -1376, -160, 56},
    { -752, -416, 168},
    { -824, -160, 32},
    { -488, -32, -72},
    { -440, 88, -88},
    { -592, 152, -144},
    { -776, 200, -120},
    { -888, 288, -208},
    { -912, 464, -96},
    { -1200, 432, -488},
    { -1080, 280, -264},
    { -1576, 464, -176},
    { -2032, 688, -200},
    { -1384, 464, -48},
    { -1432, 520, -48},
    { -1032, 336, 0},
    { -616, 176, 96},
    { -464, 176, 56},
    { -360, 216, 56},
    // 101 seconds
    { -296, 328, 80},
    { -256, 496, -24},
    { -288, 960, 136},
    { -776, 640, -152},
    { -512, 768, -32},
    { -1184, 1104, 128},
    { -1032, 1440, 152},
    { -912, 1096, -88},
    { -488, 712, 8},
    { -208, 624, 128},
    { -168, 704, 40},
    { -152, 656, 128},
    { -168, 816, -16},
    { -224, 736, 112},
    { -176, 920, -8},
    { -152, 848, 24},
    { -240, 1256, 168},
    { -416, 232, -144},
    { -712, 696, 56},
    { -1152, 896, 320},
    { -1208, 960, 32},
    { -984, 856, 240},
    { -760, 656, 128},
    { -544, 640, -32},
    { -456, 528, 56},
    // 102 seconds
    { -536, 472, 40},
    { -736, 544, -16},
    { -864, 456, 48},
    { -832, 424, -72},
    { -1392, 376, -56},
    { -1000, 440, -232},
    { -1592, 352, -96},
    { -920, 200, -96},
    { -864, 328, -272},
    { -1008, 240, -144},
    { -696, 120, -80},
    { -440, 160, -144},
    { -440, 216, -120},
    { -528, 272, -128},
    { -696, 368, -168},
    { -872, 416, -184},
    { -800, 632, -160},
    { -1008, 752, -256},
    { -1088, 488, -176},
    { -1472, 744, -368},
    { -1432, 560, -152},
    { -1248, 368, 24},
    { -1088, 432, -56},
    { -800, 256, 56},
    { -544, 320, 32},
    // 103 seconds
    { -512, 336, 72},
    { -560, 376, 80},
    { -704, 440, 120},
    { -656, 488, 176},
    { -832, 760, -88},
    { -880, 1224, 176},
    { -856, 1200, 144},
    { -936, 1296, -56},
    { -936, 720, -16},
    { -672, 760, -264},
    { -584, 608, -264},
    { -424, 496, -72},
    { -192, 488, 16},
    { -104, 504, 8},
    { -56, 552, 64},
    { -24, 720, 24},
    { 0, 832, 88},
    { 16, 1016, 56},
    { 96, 992, 96},
    { 32, 1544, 80},
    { -168, 736, 160},
    { -80, 1536, 248},
    { -360, 1328, 376},
    { -296, 1224, 408},
    { -240, 1048, 288},
    // 104 seconds
    { -200, 768, 312},
    { -56, 632, 192},
    { 24, 584, 184},
    { 40, 624, 200},
    { 96, 792, 224},
    { 80, 904, 232},
    { 88, 952, 368},
    { 40, 1120, 416},
    { -184, 1192, 328},
    { -16, 1312, 464},
    { -136, 1136, 600},
    { 56, 1160, 128},
    { -48, 840, 216},
    { -136, 856, 176},
    { -80, 816, 184},
    { 48, 704, 104},
    { 96, 616, 88},
    { 80, 704, 120},
    { 136, 792, 104},
    { 192, 960, 120},
    { 208, 1000, 368},
    { -8, 1624, 376},
    { 72, 1208, 384},
    { 280, 1088, 552},
    { 48, 1256, 440},
    // 105 seconds
    { -168, 1072, 584},
    { -144, 888, 440},
    { -24, 736, 264},
    { 192, 536, 216},
    { 280, 568, 200},
    { 256, 680, 280},
    { 264, 840, 304},
    { 288, 952, 328},
    { 256, 952, 384},
    { 168, 1120, 384},
    { 144, 1512, 128},
    { -8, 1336, 280},
    { -72, 1304, 544},
    { -136, 1272, 328},
    { 8, 968, 112},
    { -16, 776, 96},
    { 16, 552, 72},
    { 88, 552, 56},
    { 88, 656, 144},
    { 136, 712, 128},
    { 184, 912, 208},
    { 328, 832, 240},
    { 296, 992, 240},
    { 208, 1080, 352},
    { 304, 1520, 632},
    // 106 seconds
    { -152, 1592, 544},
    { -8, 1152, 608},
    { 64, 976, 392},
    { 56, 752, 416},
    { 72, 696, 304},
    { 104, 632, 296},
    { 80, 616, 288},
    { 80, 712, 240},
    { 152, 744, 264},
    { 296, 816, 240},
    { 104, 944, 208},
    { 96, 1144, 408},
    { 40, 1128, 320},
    { -64, 1184, 432},
    { -224, 1264, 480},
    { -144, 1200, 248},
    { -112, 936, 248},
    { -16, 832, 200},
    { 136, 688, 160},
    { 168, 616, 160},
    { 200, 664, 160},
    { 184, 776, 224},
    { 160, 880, 240},
    { 168, 960, 200},
    { 280, 856, 240},
    // 107 seconds
    { 344, 1120, 24},
    { 176, 824, 0},
    { 96, 912, 376},
    { -56, 1512, 736},
    { -328, 1440, 768},
    { -192, 1240, 704},
    { -208, 1040, 600},
    { -168, 736, 456},
    { -72, 712, 312},
    { -64, 656, 336},
    { -104, 664, 376},
    { -128, 752, 408},
    { -160, 880, 496},
    { -176, 976, 536},
    { -136, 968, 480},
    { -56, 880, 424},
    { -40, 840, 352},
    { -64, 896, 400},
    { -104, 856, 432},
    { -168, 1008, 448},
    { -192, 912, 288},
    { -184, 856, 152},
    { -232, 976, 176},
    { -168, 1032, 48},
    { -200, 776, 88},
    // 108 seconds
    { -320, 992, 0},
    { -312, 1016, -216},
    { -400, 712, -304},
    { -408, 400, -416},
    { -288, 848, -584},
    { -232, 960, -432},
    { -208, 992, -304},
    { -224, 912, -400},
    { -320, 776, -240},
    { -400, 872, -152},
    { -592, 904, -304},
    { -656, 784, -232},
    { -728, 848, -328},
    { -768, 312, -448},
    { -584, 672, -536},
    { -416, 824, -144},
    { -320, 1000, -200},
    { -296, 768, -328},
    { -344, 856, -344},
    { -416, 952, -200},
    { -400, 1048, -368},
    { -408, 496, -200},
    { -360, 896, -400},
    { -328, 496, -512},
    { -376, 720, -640},
    // 109 seconds
    { -320, 648, -560},
    { -312, 528, -440},
    { -272, 512, -424},
    { -304, 568, -552},
    { -360, 768, -504},
    { -408, 560, -416},
    { -392, 808, -400},
    { -480, 960, -352},
    { -488, 944, -440},
    { -392, 576, -512},
    { -288, 728, -416},
    { -384, 768, -520},
    { -304, 768, -352},
    { -392, 744, -432},
    { -424, 320, -728},
    { -488, 384, -528},
    { -528, 648, -544},
    { -464, 536, -608},
    { -384, 896, -568},
    { -312, 632, -520},
    { -288, 664, -640},
    { -296, 600, -608},
    { -368, 736, -640},
    { -376, 632, -592},
    { -376, 568, -704},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:04:21 local
AccelRawData *activity_sample_walk_200_pbl_25669_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25669_9
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 192, 472, -776},
    { 72, 616, -928},
    { -32, 328, -872},
    { -72, 256, -968},
    { -56, 168, -912},
    { -224, 32, -616},
    { 120, 136, -1000},
    { -48, 176, -864},
    { 40, 176, -872},
    { 24, 104, -856},
    { 72, -32, -912},
    { -56, 24, -896},
    { -80, 104, -960},
    { -56, 104, -952},
    { -56, 72, -920},
    { -32, 96, -952},
    { -72, 64, -928},
    { -64, 56, -952},
    { -96, 64, -912},
    { -56, 32, -960},
    { -96, 8, -960},
    { -104, 24, -928},
    { -128, 48, -904},
    { -104, -24, -912},
    { -112, 96, -944},
    // 1 seconds
    { -56, -32, -920},
    { -104, -32, -936},
    { -88, 8, -912},
    { -104, -24, -880},
    { -160, -64, -920},
    { -224, -96, -912},
    { -216, 24, -904},
    { -40, 88, -1040},
    { -112, 216, -952},
    { 0, -120, -920},
    { 48, 128, -1048},
    { -128, -56, -872},
    { -152, 48, -912},
    { -160, -8, -864},
    { -176, 0, -856},
    { -384, -144, -824},
    { -232, -112, -904},
    { -176, 8, -936},
    { -144, 224, -984},
    { -128, 368, -1032},
    { -112, 328, -904},
    { -56, 344, -920},
    { -24, 272, -848},
    { -24, 328, -912},
    { -16, 232, -904},
    // 2 seconds
    { 8, 200, -888},
    { 48, 128, -856},
    { 80, 120, -824},
    { 56, 96, -864},
    { 32, 56, -832},
    { -8, 24, -888},
    { 0, 0, -896},
    { 8, -40, -864},
    { 8, 56, -888},
    { 16, 40, -792},
    { -120, 408, -1016},
    { 16, 424, -784},
    { -352, 648, -640},
    { -368, 968, -352},
    { -368, 448, 40},
    { -472, 1256, -80},
    { -520, 896, -160},
    { -520, 448, 168},
    { -640, 680, 72},
    { -648, 824, -72},
    { -672, 856, 40},
    { -664, 912, -120},
    { -952, 1176, -352},
    { -1072, 960, 8},
    { -1096, 960, -96},
    // 3 seconds
    { -1184, 800, -104},
    { -1232, 680, -8},
    { -440, 296, -24},
    { -664, 328, -112},
    { -824, 96, 152},
    { -696, 280, 8},
    { -592, 360, -80},
    { -616, 384, -72},
    { -680, 448, -64},
    { -712, 520, -136},
    { -760, 952, -376},
    { -904, 488, -72},
    { -808, 632, -256},
    { -1056, 600, -184},
    { -1416, 664, -168},
    { -1328, 592, -120},
    { -1272, 424, 0},
    { -944, 512, -120},
    { -688, 376, 8},
    { -600, 336, -8},
    { -608, 344, 8},
    { -648, 352, 48},
    { -728, 424, 72},
    { -768, 344, 16},
    { -992, 192, 48},
    // 4 seconds
    { -1096, 456, -168},
    { -856, 296, -120},
    { -1568, 424, -64},
    { -1112, 320, 40},
    { -984, 472, -144},
    { -952, 512, -208},
    { -608, 304, -56},
    { -336, 344, -32},
    { -432, 408, -32},
    { -520, 496, -48},
    { -864, 752, -128},
    { -928, 200, -288},
    { -888, 664, -320},
    { -1048, 672, -344},
    { -1504, 648, -456},
    { -2032, 664, -432},
    { -1472, 240, -256},
    { -1144, 224, -208},
    { -776, 232, -104},
    { -584, 152, 56},
    { -544, 136, 112},
    { -592, 216, 56},
    { -632, 136, 96},
    { -520, 384, -280},
    { -848, 248, 128},
    // 5 seconds
    { -1024, 408, -104},
    { -1000, 320, -144},
    { -1696, 576, -120},
    { -1280, 296, -112},
    { -1008, 496, -352},
    { -1072, 352, -192},
    { -696, 96, -144},
    { -312, 392, -480},
    { -520, 216, -344},
    { -576, 280, -408},
    { -784, 696, -376},
    { -1120, 280, -544},
    { -776, 288, -256},
    { -984, 488, -368},
    { -1040, 448, -232},
    { -1760, 728, -408},
    { -1344, 448, -280},
    { -984, 288, -240},
    { -760, 328, -256},
    { -704, 152, -120},
    { -648, 64, 16},
    { -632, 128, 0},
    { -720, 184, -40},
    { -960, 296, -48},
    { -864, -232, -272},
    // 6 seconds
    { -1128, 8, -144},
    { -1120, -224, 64},
    { -1712, 544, -248},
    { -1496, 136, -80},
    { -936, 312, -264},
    { -960, 248, -240},
    { -640, 8, 8},
    { -344, 120, -120},
    { -480, 256, -96},
    { -640, 384, -104},
    { -800, 656, -240},
    { -1136, 816, -624},
    { -1016, 408, -312},
    { -1048, 336, -376},
    { -1160, 232, -264},
    { -1760, 672, -504},
    { -1280, 104, -320},
    { -1192, 136, -184},
    { -968, -176, 56},
    { -544, -56, 24},
    { -544, 152, -56},
    { -656, 136, -40},
    { -696, 272, 128},
    { -1176, 488, -312},
    { -1176, -40, 24},
    // 7 seconds
    { -1288, 184, -176},
    { -1088, 280, -232},
    { -1520, 88, -120},
    { -952, 232, -248},
    { -1056, 200, -248},
    { -936, 56, -104},
    { -552, 128, -152},
    { -440, 240, -200},
    { -528, 304, -232},
    { -688, 440, -344},
    { -776, 352, -256},
    { -1296, 728, -352},
    { -1000, 296, -320},
    { -1032, 72, -240},
    { -1616, 616, -576},
    { -1376, -40, -56},
    { -1120, 120, -184},
    { -1064, 16, -48},
    { -792, -136, 120},
    { -496, 120, -88},
    { -640, 128, 32},
    { -816, 128, 0},
    { -912, 216, -72},
    { -872, 672, -472},
    { -1312, 40, -48},
    // 8 seconds
    { -1160, 360, -184},
    { -1576, 320, -192},
    { -456, 304, -264},
    { -1016, 288, -192},
    { -984, -64, 120},
    { -648, 40, -24},
    { -504, 184, -184},
    { -568, 144, -128},
    { -680, 192, -176},
    { -808, 272, -240},
    { -1016, 640, -376},
    { -1080, -24, -488},
    { -1016, 216, -352},
    { -1464, 288, -280},
    { -1976, 456, -432},
    { -1184, 80, 16},
    { -1040, 280, -304},
    { -800, 40, -24},
    { -416, 56, 48},
    { -512, 184, -40},
    { -640, 136, 32},
    { -1000, 728, -368},
    { -1024, 128, 48},
    { -1248, 120, -40},
    { -1176, 208, -160},
    // 9 seconds
    { -1328, 408, -272},
    { -1544, 160, -72},
    { -728, 248, -280},
    { -1024, 256, -320},
    { -824, -16, -56},
    { -488, 128, -160},
    { -440, 200, -176},
    { -520, 224, -192},
    { -752, 360, -256},
    { -1152, 600, -456},
    { -1056, 328, -296},
    { -1088, 392, -464},
    { -1080, 64, -152},
    { -1544, 472, -840},
    { -1408, 72, -96},
    { -1216, 176, -152},
    { -960, 208, -240},
    { -544, 72, -168},
    { -480, 168, -152},
    { -608, 208, -72},
    { -624, 48, 160},
    { -488, 592, -296},
    { -808, 384, -24},
    { -1000, 352, -96},
    { -1048, 352, -280},
    // 10 seconds
    { -1048, 360, -72},
    { -1664, 216, -120},
    { -680, 424, -568},
    { -1112, 280, -296},
    { -992, -40, -56},
    { -648, 56, -128},
    { -400, 48, -192},
    { -312, 56, -128},
    { -432, 232, -280},
    { -656, 488, -312},
    { -1264, 664, -456},
    { -1112, 568, -512},
    { -1288, 184, -144},
    { -2240, 736, -432},
    { -1264, 208, 80},
    { -1056, 248, -176},
    { -1000, 128, -200},
    { -520, -112, -16},
    { -344, 136, -128},
    { -352, 56, -24},
    { -768, -56, 16},
    { -1152, 144, -160},
    { -1104, -8, -24},
    { -1384, 96, -232},
    { -1352, 128, -24},
    // 11 seconds
    { -1416, 192, -112},
    { -1048, 64, -240},
    { -640, 56, -216},
    { -1064, 24, -160},
    { -864, 64, -40},
    { -504, 144, -144},
    { -464, 192, -192},
    { -560, 208, -200},
    { -776, 248, -240},
    { -880, 96, -224},
    { -1008, 360, -384},
    { -1432, 608, -536},
    { -1088, 48, -240},
    { -1752, 456, -624},
    { -1632, 64, -104},
    { -1168, 224, -112},
    { -1064, 112, -168},
    { -544, -48, -32},
    { -296, 48, -8},
    { -440, 72, 56},
    { -640, 128, 72},
    { -920, 168, 0},
    { -1088, 584, -40},
    { -1520, -56, -216},
    { -1240, 32, -144},
    // 12 seconds
    { -1264, 64, -96},
    { -1504, 72, -104},
    { -880, 192, -248},
    { -976, 184, -304},
    { -808, -32, -200},
    { -504, -24, -176},
    { -368, 112, -272},
    { -456, 184, -240},
    { -584, 344, -248},
    { -896, -16, -352},
    { -960, -24, -208},
    { -1096, 400, -576},
    { -1064, 112, -280},
    { -1936, 456, -728},
    { -1568, -64, 0},
    { -1256, 112, -176},
    { -1056, 432, -248},
    { -680, 64, 32},
    { -376, 32, -64},
    { -344, 88, -96},
    { -480, 720, -216},
    { -1000, -224, 176},
    { -944, 200, -80},
    { -1240, 368, -224},
    { -1056, -16, -152},
    // 13 seconds
    { -1112, 72, -184},
    { -1560, 16, -152},
    { -936, 144, -376},
    { -968, 40, -288},
    { -760, -96, -200},
    { -416, -48, -96},
    { -360, 232, -168},
    { -552, 232, -192},
    { -912, 776, -440},
    { -1408, 96, -256},
    { -1024, 176, -408},
    { -1184, 216, -368},
    { -1384, 224, -352},
    { -1560, 384, -440},
    { -1192, 144, -176},
    { -1088, 272, -304},
    { -864, 24, -56},
    { -552, 24, -8},
    { -488, 32, 8},
    { -696, 56, 32},
    { -904, -184, 176},
    { -680, 632, -56},
    { -1296, 200, -24},
    { -1256, -80, -8},
    { -1392, 192, -184},
    // 14 seconds
    { -1224, 240, -72},
    { -856, 376, -304},
    { -960, 216, -216},
    { -760, 112, -176},
    { -448, 112, -176},
    { -384, 168, -240},
    { -464, 296, -288},
    { -696, 368, -304},
    { -1384, 560, -152},
    { -952, 72, -136},
    { -1176, 440, -472},
    { -1024, 96, -168},
    { -1384, 512, -384},
    { -1464, 328, -240},
    { -1216, 40, -56},
    { -968, 248, -120},
    { -688, 64, 0},
    { -456, 128, 0},
    { -624, 208, -40},
    { -904, 224, -64},
    { -880, 256, -128},
    { -1008, 408, -80},
    { -1136, -304, -296},
    { -1152, 16, -96},
    { -1640, 32, -88},
    // 15 seconds
    { -816, 440, -272},
    { -872, 104, -240},
    { -968, 184, -232},
    { -600, -24, -184},
    { -400, 8, -216},
    { -408, 96, -256},
    { -640, 264, -280},
    { -1048, 608, -512},
    { -1152, -240, -424},
    { -1016, 432, -520},
    { -1032, 184, -344},
    { -1576, 512, -712},
    { -1504, -16, -112},
    { -1216, 176, -176},
    { -1080, 176, -144},
    { -808, 0, -72},
    { -616, 96, -64},
    { -560, 64, -32},
    { -720, 32, 8},
    { -712, 24, 104},
    { -904, 688, -288},
    { -1120, 56, -48},
    { -1288, -88, 8},
    { -1272, 0, -160},
    { -1480, 48, 8},
    // 16 seconds
    { -920, 328, -104},
    { -944, 352, -352},
    { -864, 24, -232},
    { -512, -72, -184},
    { -440, 8, -224},
    { -528, 184, -328},
    { -696, 280, -360},
    { -792, 416, -304},
    { -1336, 552, -424},
    { -928, 152, -432},
    { -1000, 64, -296},
    { -1680, 528, -608},
    { -1792, 152, -176},
    { -1232, 16, -96},
    { -936, 464, -336},
    { -848, -64, 24},
    { -792, -96, 80},
    { -648, -32, 40},
    { -656, 24, -24},
    { -768, 40, 32},
    { -856, 40, -112},
    { -872, 64, 32},
    { -1256, 288, -64},
    { -1152, 80, 56},
    { -1720, 488, -176},
    // 17 seconds
    { -784, 272, -72},
    { -920, 312, -304},
    { -976, 48, -248},
    { -616, -104, -224},
    { -488, 56, -264},
    { -616, 160, -232},
    { -816, 256, -304},
    { -888, 8, -112},
    { -1080, 416, -328},
    { -1216, -200, -496},
    { -1128, 152, -296},
    { -1328, 312, -408},
    { -1784, 720, -584},
    { -1408, 16, 56},
    { -952, 160, -104},
    { -704, 40, 8},
    { -552, 128, -24},
    { -656, 256, 0},
    { -800, 344, -56},
    { -944, 48, 160},
    { -848, -256, 184},
    { -904, 200, 24},
    { -1208, 120, -96},
    { -1288, 200, -176},
    { -1672, 216, -176},
    // 18 seconds
    { -696, 400, -168},
    { -984, 0, -176},
    { -920, -40, -112},
    { -528, 88, -216},
    { -448, 160, -208},
    { -568, 200, -168},
    { -744, 248, -256},
    { -1208, 8, -312},
    { -928, 256, -336},
    { -888, 320, -408},
    { -1160, 312, -472},
    { -1368, 280, -424},
    { -1760, 392, -408},
    { -1096, 8, -96},
    { -1008, 280, -264},
    { -888, 248, -152},
    { -632, 88, 0},
    { -488, 152, 0},
    { -576, 192, 40},
    { -744, 120, -128},
    { -976, -104, -104},
    { -920, 64, 8},
    { -1184, 240, -168},
    { -1136, 40, -120},
    { -1512, 88, -32},
    // 19 seconds
    { -1248, 88, -80},
    { -736, 160, -200},
    { -896, 176, -224},
    { -816, 104, -208},
    { -568, 56, -216},
    { -504, 144, -248},
    { -568, 176, -264},
    { -984, 344, -432},
    { -752, -432, -216},
    { -832, 240, -472},
    { -1056, 272, -440},
    { -920, 56, -216},
    { -1064, 104, -304},
    { -1896, 624, -672},
    { -1368, 64, -40},
    { -1208, 264, -288},
    { -872, 144, -120},
    { -472, -8, -32},
    { -400, 176, -104},
    { -568, 528, 112},
    { -1088, 608, -368},
    { -984, 144, -240},
    { -992, 208, -264},
    { -1176, 328, -264},
    { -1168, 152, -80},
    // 20 seconds
    { -1624, -88, -96},
    { -800, 64, -136},
    { -1176, 8, -184},
    { -1096, 0, -200},
    { -656, -88, -112},
    { -432, 160, -288},
    { -448, -304, -112},
    { -496, -200, -480},
    { -808, 152, -496},
    { -920, 248, -624},
    { -1008, 288, -632},
    { -1136, -168, -232},
    { -1760, 312, -720},
    { -1328, 32, -184},
    { -1120, 192, -320},
    { -840, 304, -336},
    { -648, 32, 32},
    { -520, 64, -16},
    { -440, -112, 80},
    { -600, -200, -88},
    { -872, 24, -8},
    { -968, 336, -272},
    { -1240, 264, -320},
    { -1456, 0, -152},
    { -1568, -80, 0},
    // 21 seconds
    { -896, 184, -280},
    { -872, 8, -152},
    { -1104, -104, -64},
    { -952, 0, -128},
    { -560, 0, -216},
    { -416, -120, -112},
    { -384, -304, -384},
    { -576, 96, -432},
    { -776, 176, -424},
    { -800, 216, -472},
    { -1048, 288, -648},
    { -1128, 144, -272},
    { -1608, 416, -656},
    { -1424, 312, -408},
    { -1408, 136, -256},
    { -1184, 320, -360},
    { -632, 32, -56},
    { -400, 96, -72},
    { -424, 240, -112},
    { -680, 8, -80},
    { -792, 112, -32},
    { -944, 304, -248},
    { -1152, 200, -224},
    { -1152, -16, -96},
    { -1560, 168, -216},
    // 22 seconds
    { -1376, 40, -96},
    { -656, 192, -376},
    { -960, 232, -240},
    { -864, 64, -232},
    { -560, 48, -224},
    { -336, 264, -408},
    { -536, -8, -80},
    { -472, 96, -600},
    { -872, 184, -352},
    { -920, 280, -400},
    { -1072, 552, -656},
    { -1472, 216, -424},
    { -1936, 512, -624},
    { -1072, -32, -80},
    { -1072, 208, -336},
    { -760, 264, -240},
    { -480, -24, -32},
    { -736, -120, -168},
    { -464, -688, 64},
    { -720, 368, -48},
    { -848, 512, -184},
    { -1152, 272, -256},
    { -1128, 144, -392},
    { -1368, -40, -80},
    { -1440, 192, -520},
    // 23 seconds
    { -704, 336, -664},
    { -1056, 120, -368},
    { -736, -88, -136},
    { -456, 216, -320},
    { -368, 264, -160},
    { -392, 256, -224},
    { -608, 248, -176},
    { -680, 88, -424},
    { -944, 576, -472},
    { -1032, 408, -384},
    { -936, 376, -360},
    { -1760, 584, -576},
    { -1240, 176, -240},
    { -1240, 344, -456},
    { -944, 312, -296},
    { -568, 256, -208},
    { -632, 272, -96},
    { -480, 320, 192},
    { -712, 976, 0},
    { -840, 800, -248},
    { -1208, 392, -168},
    { -1200, 64, -216},
    { -904, -136, -328},
    { -1680, -240, -104},
    { -1216, 56, -192},
    // 24 seconds
    { -1048, 296, -400},
    { -1016, 88, -176},
    { -808, -64, -120},
    { -640, 192, -264},
    { -600, 232, -232},
    { -632, 304, -304},
    { -800, 512, -248},
    { -1152, 64, -304},
    { -1000, 472, -424},
    { -920, 512, -504},
    { -1016, 504, -368},
    { -1504, 656, -648},
    { -1224, 312, -224},
    { -1016, 64, -152},
    { -944, 248, -176},
    { -792, 120, -56},
    { -712, 64, 16},
    { -736, 256, -8},
    { -896, 24, 176},
    { -1072, -216, -168},
    { -640, 8, -24},
    { -1032, 168, -184},
    { -1152, 136, -16},
    { -2040, 240, -184},
    { -520, 352, -200},
    // 25 seconds
    { -1016, 192, -144},
    { -960, -288, 0},
    { -624, -328, -72},
    { -448, 80, -264},
    { -520, 208, -312},
    { -640, 328, -416},
    { -824, 280, -384},
    { -888, 248, -360},
    { -1272, 256, -400},
    { -1096, 376, -544},
    { -1744, 592, -760},
    { -1432, 128, -272},
    { -1176, 184, -200},
    { -936, 448, -384},
    { -648, 192, -168},
    { -656, 328, -112},
    { -656, 200, 72},
    { -632, 240, 8},
    { -664, 32, 288},
    { -800, 128, 48},
    { -920, 24, 56},
    { -1064, 120, 40},
    { -1304, 248, 8},
    { -1456, 80, 88},
    { -960, 248, -176},
    // 26 seconds
    { -1408, 368, -392},
    { -1192, 112, -32},
    { -896, 120, -232},
    { -584, 264, -256},
    { -504, 128, -216},
    { -368, 208, -440},
    { -584, 336, -288},
    { -880, 464, -536},
    { -976, 376, -600},
    { -920, 200, -416},
    { -1272, 112, -224},
    { -2096, 664, -464},
    { -1168, 96, -128},
    { -1200, 296, -344},
    { -976, 376, -200},
    { -704, 144, -24},
    { -672, 240, -64},
    { -688, 160, 16},
    { -744, 96, -16},
    { -840, 160, -120},
    { -888, -248, -208},
    { -1152, 40, -224},
    { -952, -392, -8},
    { -1720, -24, -96},
    { -1496, 16, -184},
    // 27 seconds
    { -1048, 184, -240},
    { -1216, 136, -240},
    { -984, 96, -152},
    { -704, 208, -200},
    { -600, 288, -248},
    { -712, 216, -384},
    { -984, 320, -528},
    { -880, 376, -568},
    { -848, 368, -520},
    { -928, 464, -656},
    { -1088, 280, -368},
    { -1720, 504, -712},
    { -1360, 128, -248},
    { -1104, 80, -240},
    { -1096, 256, -264},
    { -1008, 176, -40},
    { -872, 144, -24},
    { -808, 32, 40},
    { -808, -168, -24},
    { -912, 32, 152},
    { -904, 144, 40},
    { -912, 136, -16},
    { -856, -184, 224},
    { -1080, 184, -64},
    { -1528, 56, 48},
    // 28 seconds
    { -840, 272, -240},
    { -1152, 192, -296},
    { -1216, -40, -192},
    { -896, 16, -328},
    { -576, 416, -576},
    { -544, 280, -496},
    { -712, 344, -504},
    { -792, 344, -448},
    { -888, 528, -480},
    { -976, 272, -568},
    { -1120, 408, -360},
    { -1624, 528, -456},
    { -1672, 192, -152},
    { -1240, 224, -192},
    { -1048, 408, -304},
    { -840, 344, -128},
    { -600, 136, 24},
    { -536, 120, -8},
    { -656, 128, 0},
    { -840, 0, 96},
    { -912, -240, 120},
    { -696, -48, -168},
    { -1032, 128, -192},
    { -1016, 136, -152},
    { -1656, 64, -120},
    // 29 seconds
    { -1096, 400, -344},
    { -1032, 304, -312},
    { -1128, 136, -216},
    { -896, 128, -240},
    { -536, 176, -288},
    { -488, 184, -288},
    { -608, 216, -248},
    { -696, 208, -264},
    { -936, -8, -384},
    { -832, 344, -456},
    { -928, 424, -440},
    { -1064, 200, -336},
    { -1176, 280, -360},
    { -1520, 488, -448},
    { -1256, 128, -136},
    { -1168, 352, -328},
    { -1032, 280, -112},
    { -784, 120, -40},
    { -640, 168, -40},
    { -728, 248, 0},
    { -832, 136, 56},
    { -880, 152, 0},
    { -808, -24, -176},
    { -864, 128, -88},
    { -1032, 128, -88},
    // 30 seconds
    { -1160, 224, -256},
    { -1440, 40, -168},
    { -1144, 120, -288},
    { -1016, 120, -320},
    { -968, 80, -344},
    { -864, 96, -328},
    { -648, 152, -328},
    { -584, 168, -320},
    { -624, 192, -352},
    { -696, 152, -320},
    { -816, 184, -496},
    { -952, 232, -408},
    { -800, 88, -544},
    { -952, 144, -496},
    { -1112, 168, -424},
    { -1792, 608, -776},
    { -1400, 24, -136},
    { -1184, -48, -176},
    { -1040, 256, -264},
    { -952, 24, 0},
    { -672, 32, -8},
    { -648, 184, 0},
    { -792, 248, 32},
    { -824, 248, -56},
    { -680, 280, -136},
    // 31 seconds
    { -600, 320, -176},
    { -656, 304, -200},
    { -680, 384, -208},
    { -1072, 784, -568},
    { -920, 232, -320},
    { -1336, 128, -296},
    { -1584, 64, -248},
    { -1208, 352, -544},
    { -1232, 64, -288},
    { -1056, -224, -144},
    { -696, -64, -240},
    { -464, 120, -264},
    { -432, 200, -280},
    { -528, 240, -304},
    { -672, 280, -240},
    { -768, 192, -240},
    { -744, -8, -144},
    { -792, -40, -176},
    { -880, 96, -232},
    { -896, 72, -368},
    { -960, 280, -376},
    { -784, 520, -720},
    { -920, 656, -696},
    { -856, 376, -424},
    { -2288, 528, -448},
    // 32 seconds
    { -1456, -312, 16},
    { -1672, -56, -80},
    { -1248, -264, -72},
    { -688, -128, -64},
    { -552, -120, 64},
    { -504, -184, 80},
    { -664, 56, -8},
    { -840, 216, -80},
    { -856, 232, -24},
    { -816, 40, -384},
    { -1528, 200, -144},
    { -1312, 264, -352},
    { -1424, 72, -80},
    { -1048, 272, -128},
    { -1008, 192, -128},
    { -1080, 64, -144},
    { -848, -32, -152},
    { -504, 48, -208},
    { -352, 56, -216},
    { -376, 160, -264},
    { -520, 128, -240},
    { -816, 288, -328},
    { -1104, 384, -360},
    { -1072, 536, -336},
    { -1544, 848, -616},
    // 33 seconds
    { -1200, 384, -456},
    { -1336, 688, -624},
    { -1216, 8, -56},
    { -944, 296, -224},
    { -840, 240, -104},
    { -640, 112, 32},
    { -600, 232, 16},
    { -728, 352, 24},
    { -904, 344, 96},
    { -1096, 216, -88},
    { -992, -304, -72},
    { -1256, 168, -184},
    { -1120, -16, -48},
    { -1616, 48, -80},
    { -1064, -104, -96},
    { -872, 216, -264},
    { -920, -56, -136},
    { -744, -88, -120},
    { -560, 32, -192},
    { -488, 40, -168},
    { -584, 136, -200},
    { -688, 184, -216},
    { -896, 400, -296},
    { -744, 768, -624},
    { -1104, 304, -448},
    // 34 seconds
    { -1216, 272, -608},
    { -1120, 32, -384},
    { -1528, 352, -624},
    { -1576, 96, -184},
    { -1112, -8, -112},
    { -936, 192, -208},
    { -800, 136, -80},
    { -576, 160, -88},
    { -512, 160, -120},
    { -688, 96, -120},
    { -864, -16, -120},
    { -1064, -24, -264},
    { -1056, -48, -160},
    { -1408, 200, -176},
    { -1136, -48, 40},
    { -1728, 56, 128},
    { -1120, 0, -48},
    { -1000, 72, -88},
    { -944, 56, -144},
    { -696, 128, -200},
    { -416, 176, -216},
    { -400, 144, -192},
    { -560, 192, -184},
    { -880, 352, -320},
    { -1120, 272, -344},
    // 35 seconds
    { -1160, 216, -336},
    { -1032, 64, -376},
    { -912, 120, -440},
    { -1512, 528, -696},
    { -1360, -112, -136},
    { -1216, -16, -232},
    { -1216, 112, -144},
    { -760, -184, 24},
    { -568, 56, 8},
    { -672, -8, 144},
    { -784, 112, 112},
    { -888, 192, 184},
    { -960, 688, -232},
    { -1128, 112, 48},
    { -1248, 256, -96},
    { -1048, 24, -40},
    { -2040, 144, -16},
    { -864, 520, -320},
    { -920, 392, -472},
    { -1008, -144, -104},
    { -568, 184, -192},
    { -344, 144, -136},
    { -416, 168, -96},
    { -592, 272, -88},
    { -680, 360, -136},
    // 36 seconds
    { -416, 424, -552},
    { -904, 408, -256},
    { -1072, 120, -328},
    { -1024, 168, -360},
    { -1792, 1160, -1184},
    { -1992, -216, 136},
    { -1432, 112, -144},
    { -1040, -72, -80},
    { -712, -80, 48},
    { -464, 32, 72},
    { -496, 72, 0},
    { -568, -72, 64},
    { -992, 240, -168},
    { -824, -88, -72},
    { -1120, -32, -16},
    { -1264, 120, -136},
    { -1800, 440, -80},
    { -1240, 528, -384},
    { -792, 360, -384},
    { -992, 72, -216},
    { -768, -8, -176},
    { -464, 80, -208},
    { -400, 144, -224},
    { -512, 184, -232},
    { -680, 264, -112},
    // 37 seconds
    { -608, 736, -448},
    { -944, 168, -256},
    { -1000, 136, -432},
    { -992, -64, -160},
    { -1696, 584, -664},
    { -1616, 440, -200},
    { -1504, 80, -224},
    { -1248, 64, -144},
    { -704, -96, -56},
    { -384, 72, -112},
    { -576, 136, -104},
    { -816, 192, -104},
    { -960, 128, -264},
    { -784, 88, -184},
    { -920, 336, -240},
    { -1000, 112, -40},
    { -888, 280, -112},
    { -1488, 352, -128},
    { -952, 208, -216},
    { -1336, -160, -96},
    { -1168, 16, -192},
    { -736, 168, -208},
    { -424, 256, -232},
    { -344, 176, -184},
    { -488, 184, -200},
    // 38 seconds
    { -792, 160, -184},
    { -960, 96, -8},
    { -1304, 304, -496},
    { -1056, 384, -528},
    { -1336, 176, -320},
    { -2120, 424, -496},
    { -1408, -640, 400},
    { -1328, 280, -240},
    { -984, -48, -64},
    { -576, 8, 24},
    { -376, 184, -24},
    { -312, 280, -88},
    { -472, 288, -216},
    { -664, 720, -376},
    { -832, 1552, -720},
    { -1136, 792, -456},
    { -1784, 1080, -400},
    { -1608, 280, -24},
    { -1184, -208, 16},
    { -1040, -664, 312},
    { -1512, -344, 112},
    { -1488, -320, 104},
    { -1312, 96, -200},
    { -1016, 232, -232},
    { -736, 200, -200},
    // 39 seconds
    { -568, 184, -120},
    { -520, 304, -144},
    { -696, 464, -272},
    { -712, 704, -208},
    { -1392, 456, -528},
    { -736, 824, -704},
    { -720, 656, -648},
    { -712, 704, -624},
    { -1040, 792, -464},
    { -1672, 824, -696},
    { -1624, 280, -48},
    { -1184, 320, -24},
    { -824, 352, -88},
    { -680, 104, 112},
    { -984, 440, -208},
    { -920, -152, 8},
    { -936, 128, 128},
    { -1232, 320, -64},
    { -1208, -208, 24},
    { -1216, 272, -120},
    { -1120, 152, -280},
    { -1248, 232, -120},
    { -1120, 304, -192},
    { -824, 176, -168},
    { -536, 112, -120},
    // 40 seconds
    { -584, 248, -136},
    { -688, 472, -360},
    { -920, 416, -232},
    { -1312, -8, -528},
    { -1000, 416, -384},
    { -1072, 504, -560},
    { -984, 288, -360},
    { -1336, 456, -464},
    { -1368, 384, -416},
    { -1008, 32, -24},
    { -1024, 144, -88},
    { -944, 48, 16},
    { -648, 80, 0},
    { -688, 184, 16},
    { -728, 256, 8},
    { -1000, 144, 32},
    { -944, -184, -72},
    { -1224, 192, -176},
    { -1504, 200, -160},
    { -1344, -8, 40},
    { -1288, 40, 56},
    { -704, 344, -336},
    { -1000, 296, -184},
    { -1104, 184, -72},
    { -816, 80, -120},
    // 41 seconds
    { -480, 128, -120},
    { -400, 224, -184},
    { -536, 248, -176},
    { -744, 432, -432},
    { -920, -144, -256},
    { -888, 224, -360},
    { -1168, 408, -512},
    { -1168, 192, -112},
    { -1952, 544, -592},
    { -1224, 120, -112},
    { -1016, 184, -184},
    { -968, 256, -144},
    { -552, 64, -16},
    { -480, 72, 72},
    { -592, 104, -24},
    { -784, 488, 112},
    { -920, 496, -120},
    { -1128, 32, 120},
    { -1408, 16, 0},
    { -1096, -80, -32},
    { -1760, -8, 248},
    { -1360, 112, -64},
    { -592, 384, -432},
    { -952, 232, -264},
    { -616, -48, -80},
    // 42 seconds
    { -408, 120, -168},
    { -456, 104, -144},
    { -656, 152, -160},
    { -872, 280, -200},
    { -920, 368, -256},
    { -792, 64, -304},
    { -1112, 400, -312},
    { -1120, 24, -104},
    { -1960, 680, -688},
    { -1688, 112, -16},
    { -1208, -80, -112},
    { -912, -104, -72},
    { -544, -72, 0},
    { -408, 168, 48},
    { -600, 256, 88},
    { -680, 584, 0},
    { -1168, 568, -104},
    { -976, -240, 96},
    { -1384, -344, 200},
    { -1080, -168, 24},
    { -1736, -104, 32},
    { -848, 40, -288},
    { -1288, -432, 152},
    { -1008, -296, -24},
    { -472, -56, -144},
    // 43 seconds
    { -424, -56, -160},
    { -472, -8, -192},
    { -664, 136, -256},
    { -824, -16, -248},
    { -1152, 272, -256},
    { -1376, 16, -592},
    { -1160, -184, -264},
    { -1232, -416, -120},
    { -1592, -184, -424},
    { -1240, -216, -72},
    { -1288, 8, -368},
    { -1176, -80, -128},
    { -856, -40, -16},
    { -480, 32, -64},
    { -672, -328, 176},
    { -648, 64, 152},
    { -1296, 1016, -384},
    { -936, 88, -48},
    { -1120, 160, -176},
    { -1224, 72, -120},
    { -1632, 264, -168},
    { -992, 240, -320},
    { -816, 200, -280},
    { -1064, 48, -288},
    { -784, -8, -168},
    // 44 seconds
    { -432, 64, -224},
    { -456, 136, -256},
    { -568, 192, -272},
    { -720, 232, -96},
    { -504, -360, -688},
    { -704, -128, -296},
    { -1168, 488, -672},
    { -1040, -56, -136},
    { -1576, 408, -472},
    { -1384, 352, -256},
    { -1256, 152, -160},
    { -1136, 176, -104},
    { -728, 0, 24},
    { -480, 64, -56},
    { -576, 328, -104},
    { -784, -8, 72},
    { -1032, 384, -64},
    { -1056, 16, -16},
    { -1216, 136, -8},
    { -1320, 176, -56},
    { -1288, 40, -64},
    { -1360, 104, 24},
    { -704, 344, -336},
    { -968, 424, -360},
    { -888, 176, -200},
    // 45 seconds
    { -528, -56, -128},
    { -472, 64, -144},
    { -528, 144, -192},
    { -688, 256, -216},
    { -920, 384, -360},
    { -1016, 296, -400},
    { -1048, 304, -488},
    { -1088, 24, -216},
    { -1632, 88, -184},
    { -1488, 272, -200},
    { -1056, 208, -128},
    { -928, 368, -304},
    { -872, 32, 40},
    { -512, -56, 32},
    { -576, 128, -32},
    { -736, 80, 80},
    { -952, 208, 184},
    { -1080, 152, -40},
    { -1280, -40, -56},
    { -1368, 8, -24},
    { -1200, 248, -120},
    { -1528, -112, -88},
    { -784, 72, -216},
    { -928, 16, -280},
    { -784, -120, -120},
    // 46 seconds
    { -464, -24, -168},
    { -408, 96, -192},
    { -536, 216, -184},
    { -776, 264, -264},
    { -912, 232, -248},
    { -1032, 168, -216},
    { -1152, 248, -416},
    { -1248, 24, 24},
    { -1000, -56, -176},
    { -1600, 376, -504},
    { -1440, 48, 8},
    { -1176, 40, -88},
    { -968, 104, -16},
    { -520, 32, -48},
    { -472, 144, -80},
    { -656, 176, 56},
    { -760, 136, 16},
    { -832, 216, 24},
    { -1088, 248, -88},
    { -1272, -72, 16},
    { -1040, 16, -48},
    { -1456, 272, -128},
    { -1272, -112, -88},
    { -968, 176, -264},
    { -1104, 112, -264},
    // 47 seconds
    { -760, -56, -128},
    { -424, -8, -200},
    { -440, 128, -184},
    { -536, 184, -256},
    { -704, 264, -224},
    { -896, 256, -328},
    { -976, 184, -328},
    { -1128, 176, -456},
    { -1280, 120, -280},
    { -2184, 744, -744},
    { -1376, -288, 168},
    { -1144, 320, -320},
    { -768, 80, -136},
    { -336, -112, -32},
    { -296, 104, -56},
    { -512, 240, -32},
    { -944, 432, -56},
    { -1256, 344, 16},
    { -1248, 160, 232},
    { -1080, -24, 80},
    { -1048, -40, 80},
    { -1184, 264, -136},
    { -1192, 296, -400},
    { -848, 344, -384},
    { -1152, -144, -128},
    // 48 seconds
    { -1000, -176, -144},
    { -600, -112, -176},
    { -488, 24, -216},
    { -424, 104, -264},
    { -696, 152, -272},
    { -968, 184, -256},
    { -1072, 152, -464},
    { -1216, 304, -472},
    { -1088, 64, -200},
    { -1504, 344, -424},
    { -1400, 344, -352},
    { -1160, 264, -136},
    { -1160, 176, -160},
    { -824, 48, -32},
    { -496, 72, -72},
    { -568, 216, -96},
    { -720, 192, -16},
    { -968, 368, -8},
    { -1088, 32, 48},
    { -1024, 152, -136},
    { -1384, 248, -208},
    { -1064, -88, -72},
    { -1600, -64, 152},
    { -1128, -32, -72},
    { -688, 424, -368},
    // 49 seconds
    { -856, 216, -352},
    { -728, -136, -96},
    { -512, 56, -224},
    { -472, 56, -152},
    { -544, 96, -72},
    { -720, 32, -320},
    { -872, 232, -208},
    { -936, 432, -400},
    { -992, 296, -424},
    { -1112, 216, -312},
    { -1664, 648, -528},
    { -1224, 216, -248},
    { -1144, 304, -240},
    { -1128, 416, -272},
    { -928, 216, -80},
    { -744, 240, -96},
    { -640, 104, -96},
    { -664, 16, 8},
    { -896, 64, 64},
    { -928, 8, -8},
    { -1040, 24, -72},
    { -1192, -224, -40},
    { -992, -160, -248},
    { -1728, -176, 224},
    { -1272, 176, -144},
    // 50 seconds
    { -976, 272, -288},
    { -872, 144, -200},
    { -688, 64, -144},
    { -552, 136, -208},
    { -680, 232, -240},
    { -800, 136, -352},
    { -1112, 480, -320},
    { -792, 48, -488},
    { -928, 248, -528},
    { -1056, 304, -576},
    { -1216, 192, -352},
    { -1664, 584, -680},
    { -1216, 88, -208},
    { -1376, 192, -192},
    { -1248, 256, -96},
    { -864, 144, 104},
    { -744, 208, 64},
    { -744, 192, 72},
    { -752, 40, -56},
    { -824, -72, -112},
    { -1040, 24, 80},
    { -1272, 0, -56},
    { -1104, -88, -48},
    { -1632, -16, 24},
    { -1400, -48, -72},
    // 51 seconds
    { -976, 248, -208},
    { -1168, 240, -256},
    { -1008, 160, -152},
    { -760, 112, -216},
    { -720, 224, -336},
    { -768, 184, -288},
    { -880, 352, -424},
    { -984, 384, -216},
    { -904, 344, -568},
    { -888, 224, -576},
    { -968, 248, -536},
    { -1128, 232, -600},
    { -1400, 608, -736},
    { -1328, 128, -280},
    { -1408, 296, -288},
    { -1280, 216, -96},
    { -1016, 112, 32},
    { -1072, 216, 0},
    { -1064, 32, 40},
    { -856, -304, -96},
    { -792, -200, -16},
    { -1008, -128, -88},
    { -1096, -272, -120},
    { -1176, -88, -88},
    { -1552, -104, 0},
    // 52 seconds
    { -1112, 240, -176},
    { -1144, 304, -232},
    { -1104, 344, -256},
    { -904, 160, -168},
    { -840, 216, -312},
    { -864, 208, -304},
    { -936, 280, -448},
    { -952, 256, -536},
    { -936, 360, -664},
    { -1064, 680, -656},
    { -864, 400, -696},
    { -1120, 432, -672},
    { -1616, 408, -592},
    { -1440, -168, -160},
    { -1376, 216, -184},
    { -1320, 208, -40},
    { -1000, 216, 32},
    { -896, 272, 48},
    { -992, 288, 136},
    { -904, 72, 176},
    { -1016, -56, 168},
    { -904, -120, 104},
    { -1168, -240, -80},
    { -1336, -336, 32},
    { -1736, -544, 232},
    // 53 seconds
    { -1176, 184, -120},
    { -1024, 336, -296},
    { -1128, 280, -248},
    { -1032, 192, -160},
    { -856, 184, -224},
    { -744, 240, -312},
    { -696, 272, -352},
    { -800, 272, -456},
    { -928, 224, -488},
    { -848, 280, -672},
    { -952, 408, -656},
    { -1000, 232, -488},
    { -1464, 624, -880},
    { -1504, 104, -384},
    { -1440, -40, -232},
    { -1408, 256, -168},
    { -1144, 264, -64},
    { -952, 168, 0},
    { -888, 232, -64},
    { -1072, 240, -80},
    { -984, -136, -64},
    { -856, -96, 40},
    { -968, -16, -64},
    { -792, -184, -32},
    { -1376, -56, -8},
    // 54 seconds
    { -1224, -96, -112},
    { -1160, 312, -320},
    { -1288, 280, -240},
    { -1200, 280, -264},
    { -960, 216, -336},
    { -760, 280, -368},
    { -736, 240, -376},
    { -824, 168, -416},
    { -912, 240, -504},
    { -984, 160, -624},
    { -936, 176, -624},
    { -1024, 288, -648},
    { -1360, 352, -736},
    { -1488, 256, -520},
    { -1184, -248, -56},
    { -1064, 88, -168},
    { -976, 344, -216},
    { -960, 232, -40},
    { -736, 240, -24},
    { -824, 136, -56},
    { -856, 16, 56},
    { -912, 72, 32},
    { -952, -48, -192},
    { -1232, -336, 144},
    { -1128, -208, -64},
    // 55 seconds
    { -1824, -128, 72},
    { -1016, 176, -288},
    { -1232, 320, -224},
    { -1136, 336, -224},
    { -848, 248, -248},
    { -632, 176, -248},
    { -640, 280, -232},
    { -840, 224, -352},
    { -904, 344, -512},
    { -920, 416, -648},
    { -824, 384, -584},
    { -592, -64, -624},
    { -1064, 232, -408},
    { -1608, 560, -552},
    { -1432, 32, 56},
    { -1192, 200, -104},
    { -1312, 448, -64},
    { -1088, 144, 120},
    { -1016, 56, 216},
    { -904, 112, 272},
    { -888, 264, 264},
    { -1096, 64, 128},
    { -872, 488, 32},
    { -1104, 408, 152},
    { -944, 704, 96},
    // 56 seconds
    { -1288, 960, 128},
    { -600, 888, 232},
    { -504, 880, 16},
    { -384, 720, 40},
    { -240, 712, 0},
    { -64, 576, -32},
    { 16, 616, -24},
    { 40, 616, 56},
    { 16, 752, 80},
    { 8, 920, 136},
    { 0, 928, 216},
    { 8, 1112, 248},
    { -24, 1152, 408},
    { -248, 472, 120},
    { -232, 1616, 464},
    { -400, 1168, 512},
    { -344, 1176, 480},
    { -304, 912, 464},
    { -128, 712, 376},
    { 40, 552, 232},
    { 40, 584, 264},
    { 8, 656, 432},
    { -232, 680, 144},
    { -120, 944, 488},
    { -208, 1160, 352},
    // 57 seconds
    { -168, 1112, 360},
    { -464, 1240, 432},
    { -352, 1096, 296},
    { -328, 960, 176},
    { -360, 760, 200},
    { -240, 792, 72},
    { -96, 608, 104},
    { -8, 552, 80},
    { 8, 640, 88},
    { 0, 768, 128},
    { 8, 888, 144},
    { 48, 1000, 136},
    { 128, 1064, 208},
    { 144, 1136, 424},
    { -288, 1240, 640},
    { -648, 1600, 872},
    { -600, 1296, 432},
    { -424, 1040, 416},
    { -368, 888, 368},
    { -176, 744, 240},
    { 24, 520, 168},
    { 88, 568, 144},
    { 88, 672, 336},
    { 136, 1208, 8},
    { -168, 888, 200},
    // 58 seconds
    { -400, 1200, 256},
    { -624, 1248, 488},
    { -768, 1184, 424},
    { -408, 976, 296},
    { -416, 904, 152},
    { -416, 672, 216},
    { -336, 664, 48},
    { -232, 488, 0},
    { -168, 376, -152},
    { -216, 224, -40},
    { -480, -344, 264},
    { -568, 504, 8},
    { -768, 1200, -312},
    { -1216, 976, 128},
    { -1480, 1024, -392},
    { -1224, 288, -88},
    { -1608, 808, -416},
    { -1264, 568, -392},
    { -1328, 704, -304},
    { -888, 288, -144},
    { -472, 128, -120},
    { -416, 208, -80},
    { -528, 280, -16},
    { -744, 304, 48},
    { -920, 224, 40},
    // 59 seconds
    { -648, -152, -64},
    { -1160, 264, 16},
    { -1208, 328, -24},
    { -1040, 288, -248},
    { -1352, 272, -120},
    { -1216, 144, -160},
    { -784, 280, -280},
    { -904, 136, -256},
    { -656, 56, -144},
    { -440, 152, -184},
    { -456, 224, -184},
    { -632, 360, -240},
    { -760, 416, -256},
    { -856, 416, -304},
    { -864, 472, -328},
    { -984, 480, -424},
    { -1032, 912, -424},
    { -792, -56, -192},
    { -1400, 656, -472},
    { -1760, 48, -56},
    { -1576, 360, -104},
    { -1200, 224, 16},
    { -632, 112, -24},
    { -432, 208, 0},
    { -376, 160, 0},
    // 60 seconds
    // elapsed: 1 minutes
    { -456, 160, 40},
    { -896, 424, -120},
    { -1048, 368, 88},
    { -768, -232, -8},
    { -1144, 184, 16},
    { -1240, 136, -64},
    { -1392, 216, -176},
    { -784, 208, -184},
    { -896, 312, -384},
    { -928, 312, -280},
    { -640, 200, -184},
    { -480, 184, -152},
    { -520, 232, -200},
    { -584, 184, -216},
    { -760, 344, -240},
    { -976, 432, -408},
    { -1096, 400, -512},
    { -1272, 712, -560},
    { -760, -24, -72},
    { -1576, 488, -776},
    { -1592, -264, 144},
    { -1496, 160, 40},
    { -1104, 224, -112},
    { -560, 72, -32},
    { -424, 64, -8},
    // 61 seconds
    { -480, 96, 56},
    { -672, 232, -40},
    { -872, 160, 112},
    { -1024, 488, -288},
    { -1360, -264, 208},
    { -976, 120, -64},
    { -1688, -32, -96},
    { -1112, 144, -304},
    { -1080, 72, -432},
    { -1096, 48, -288},
    { -584, -176, -168},
    { -392, 16, -240},
    { -456, 168, -296},
    { -592, 168, -312},
    { -808, 200, -264},
    { -896, 240, -312},
    { -896, 288, -320},
    { -960, 280, -368},
    { -1384, 536, -472},
    { -808, -344, -360},
    { -1448, 808, -792},
    { -1672, 120, -168},
    { -1360, 56, 16},
    { -1168, 248, -80},
    { -736, 184, -120},
    // 62 seconds
    { -544, 152, -32},
    { -528, 200, 8},
    { -592, 216, 56},
    { -704, 256, 24},
    { -784, 288, -64},
    { -888, 600, -64},
    { -1312, 672, -176},
    { -1200, 296, -184},
    { -1384, 304, -176},
    { -1216, 168, -216},
    { -944, 368, -360},
    { -1264, 112, -144},
    { -1112, 96, -152},
    { -688, 256, -224},
    { -440, 248, -224},
    { -352, 232, -248},
    { -416, 264, -224},
    { -656, 240, -224},
    { -904, 632, -640},
    { -1184, 264, -344},
    { -1104, 336, -512},
    { -944, 264, -392},
    { -1648, 760, -912},
    { -1392, -8, 40},
    { -1336, 160, -168},
    // 63 seconds
    { -1056, 368, -192},
    { -760, 152, 48},
    { -608, 184, 88},
    { -600, 184, 120},
    { -712, 152, 144},
    { -864, 488, 88},
    { -1208, -304, 16},
    { -1136, 368, -80},
    { -1064, 344, -248},
    { -1104, 184, -144},
    { -1456, 192, -232},
    { -984, 296, -320},
    { -1064, 128, -256},
    { -824, -16, -120},
    { -528, 120, -168},
    { -464, 184, -176},
    { -480, 240, -264},
    { -616, 384, -320},
    { -880, 240, -256},
    { -880, 160, -296},
    { -1032, 624, -856},
    { -880, -144, -304},
    { -1408, 776, -768},
    { -1424, 656, -520},
    { -1456, 72, -192},
    // 64 seconds
    { -1224, 264, -288},
    { -664, 240, -152},
    { -472, 200, -120},
    { -520, 232, -72},
    { -648, 240, -40},
    { -776, 232, -64},
    { -808, 184, -8},
    { -1128, 576, -208},
    { -1176, -8, -40},
    { -1008, 104, -112},
    { -1920, 136, -80},
    { -1112, 144, 24},
    { -1080, 344, -304},
    { -1008, 192, -224},
    { -768, 56, -112},
    { -512, 216, -232},
    { -456, 304, -248},
    { -616, 408, -336},
    { -792, 416, -360},
    { -944, 264, -368},
    { -464, -176, -688},
    { -1112, 592, -760},
    { -1088, 0, -416},
    { -1848, 464, -592},
    { -1320, -128, 0},
    // 65 seconds
    { -1120, 208, -224},
    { -1096, 288, -64},
    { -840, -32, 208},
    { -624, 112, 96},
    { -632, 256, 96},
    { -768, 424, 88},
    { -1200, 680, -48},
    { -960, 224, -48},
    { -1024, 72, -64},
    { -1224, 104, -216},
    { -1048, 112, -248},
    { -1640, 48, -120},
    { -896, 192, -224},
    { -1040, 312, -344},
    { -912, 24, -184},
    { -512, -128, -200},
    { -424, -416, 104},
    { -472, 368, -200},
    { -648, 552, -328},
    { -848, 560, -392},
    { -1008, -96, -56},
    { -904, 536, -232},
    { -1088, 504, -344},
    { -1720, 616, -560},
    { -1568, 320, -216},
    // 66 seconds
    { -1120, 56, -128},
    { -1040, 224, -256},
    { -832, -48, -24},
    { -576, 128, -48},
    { -496, 192, 0},
    { -624, 152, 96},
    { -1160, 96, 40},
    { -1008, 264, 208},
    { -928, 456, -40},
    { -1104, 400, -152},
    { -984, 464, -208},
    { -1216, 552, -176},
    { -936, 424, -112},
    { -704, 624, -224},
    { -936, 560, -280},
    { -624, 480, -192},
    { -328, 600, -288},
    { -304, 680, -192},
    { -296, 560, -64},
    { -352, 608, -80},
    { -336, 792, -176},
    { -296, 608, -40},
    { -392, 488, -464},
    { -344, 960, 112},
    { -312, 1048, -64},
    // 67 seconds
    { -648, 1304, 128},
    { -640, 1168, 120},
    { -480, 1240, 216},
    { -472, 920, 200},
    { -312, 752, 152},
    { -168, 592, 128},
    { -24, 520, 104},
    { 80, 456, 144},
    { -176, 1024, -96},
    { -296, 360, 184},
    { -568, 1136, -32},
    { -792, 1136, 96},
    { -1344, 1248, 136},
    { -520, 1032, -312},
    { -760, 800, -200},
    { -600, 832, -200},
    { -368, 576, -136},
    { -136, 440, -136},
    { -112, 416, -104},
    { -160, 400, -8},
    { -248, 688, -80},
    { -304, 872, -72},
    { -416, 976, -40},
    { -632, 936, 16},
    { -1280, 1472, -80},
    // 68 seconds
    { -1456, 624, -200},
    { -1400, 1000, -248},
    { -960, 480, -104},
    { -672, 408, -48},
    { -416, 360, -200},
    { -400, 216, -96},
    { -520, 336, -80},
    { -792, 344, -168},
    { -904, 336, -8},
    { -1024, 544, -40},
    { -1368, 224, -8},
    { -960, 240, -72},
    { -1552, 432, -32},
    { -776, 536, -216},
    { -1016, 600, -304},
    { -1056, 512, -368},
    { -456, 352, -184},
    { -336, 376, -192},
    { -368, 376, -136},
    { -440, 408, -112},
    { -488, 432, -192},
    { -568, 440, -120},
    { -728, 584, -192},
    { -1040, 640, -184},
    { -1144, 488, -56},
    // 69 seconds
    { -1400, 672, -208},
    { -1336, 616, -168},
    { -1208, 816, -128},
    { -1240, 976, -104},
    { -808, 496, -152},
    { -424, 384, -16},
    { -232, 344, -80},
    { -448, 416, 56},
    { -632, 480, 104},
    { -784, 512, 104},
    { -800, 560, 144},
    { -760, -16, -136},
    { -992, 536, -176},
    { -1488, 560, -88},
    { -1168, 792, -176},
    { -896, 616, -376},
    { -824, 312, -240},
    { -440, 152, -136},
    { -328, 224, -144},
    { -392, 208, 16},
    { -440, 560, -64},
    { -576, 688, -8},
    { -568, 896, -72},
    { -464, 992, -48},
    { -472, 1016, -56},
    // 70 seconds
    { -600, 928, 0},
    { -736, 904, 8},
    { -1264, 1088, 104},
    { -1232, 784, 360},
    { -1312, 1200, -240},
    { -1104, 480, 256},
    { -848, 632, 88},
    { -504, 640, 208},
    { -344, 488, 128},
    { -232, 488, 56},
    { -232, 520, 96},
    { -208, 640, 144},
    { -312, 984, -88},
    { -200, 464, 176},
    { -328, 1032, 80},
    { -448, 1080, 176},
    { -496, 1288, 200},
    { -584, 1112, 176},
    { -560, 968, 152},
    { -576, 1008, 64},
    { -536, 816, 104},
    { -312, 776, -8},
    { -136, 536, 24},
    { -24, 480, -24},
    { -32, 552, 16},
    // 71 seconds
    { -112, 768, 112},
    { -144, 1000, 96},
    { -352, 1488, 152},
    { -216, 880, 208},
    { -216, 880, 328},
    { -552, 1776, 112},
    { -920, 1336, 616},
    { -728, 1288, 264},
    { -384, 712, 208},
    { -128, 456, 128},
    { -24, 512, 96},
    { -48, 520, 216},
    { -96, 752, 192},
    { -144, 952, 368},
    { -200, 1656, -152},
    { -608, 1032, 152},
    { -376, 1008, 88},
    { -648, 912, 216},
    { -568, 1128, 264},
    { -544, 1264, 32},
    { -448, 896, 112},
    { -208, 680, -16},
    { -8, 496, 24},
    { 56, 536, 32},
    { 16, 696, 200},
    // 72 seconds
    { 8, 840, 40},
    { -136, 1024, 176},
    { -88, 1152, 176},
    { -224, 1208, 280},
    { -216, 1072, 232},
    { -352, 1568, 112},
    { -776, 1520, 328},
    { -592, 1088, 360},
    { -488, 1000, 400},
    { -152, 608, 112},
    { -8, 536, 48},
    { -16, 448, 96},
    { -48, 672, 24},
    { -144, 896, 120},
    { -232, 1048, 40},
    { -464, 1056, 120},
    { -576, 992, -192},
    { -328, 1056, -240},
    { -504, 960, -8},
    { -456, 1208, 16},
    { -448, 1120, 32},
    { -384, 1040, 48},
    { -88, 688, -128},
    { 96, 496, -64},
    { 120, 496, 32},
    // 73 seconds
    { 88, 712, 40},
    { 40, 832, 144},
    { -8, 1080, 160},
    { 8, 1176, 224},
    { -56, 1416, 264},
    { -104, 1464, -24},
    { -248, 1280, 168},
    { -552, 1432, 352},
    { -456, 1232, 496},
    { -472, 1040, 400},
    { -296, 800, 320},
    { -48, 576, 216},
    { 48, 600, 160},
    { 16, 512, 256},
    { 0, 632, 272},
    { -88, 816, 264},
    { -496, 680, 568},
    { -520, 968, 128},
    { -536, 1176, 32},
    { -768, 1112, 624},
    { -600, 1312, 184},
    { -448, 1168, 64},
    { -416, 584, 312},
    { -184, 712, 64},
    { -136, 624, 24},
    // 74 seconds
    { -136, 568, 80},
    { -136, 752, 56},
    { -168, 848, 128},
    { -88, 1072, 64},
    { -40, 1136, 264},
    { -136, 1208, 168},
    { -40, 1040, 272},
    { -272, 1360, 8},
    { -600, 1216, 376},
    { -616, 1360, 392},
    { -472, 1016, 336},
    { -184, 696, 216},
    { 24, 600, 88},
    { 88, 512, 104},
    { 64, 584, 192},
    { 112, 720, 112},
    { -48, 816, 8},
    { -136, 976, 64},
    { -288, 1184, 224},
    { -176, 1176, 184},
    { -360, 1184, 272},
    { -368, 1360, 40},
    { -352, 1040, 112},
    { -296, 960, 24},
    { -96, 672, 16},
    // 75 seconds
    { 16, 560, -32},
    { 48, 560, -48},
    { 32, 624, -8},
    { 64, 768, -32},
    { 56, 872, 48},
    { 88, 992, 96},
    { 64, 1176, 80},
    { -32, 1112, 176},
    { -280, 1120, 104},
    { -424, 1688, 256},
    { -432, 1272, 496},
    { -312, 1160, 320},
    { -184, 920, 248},
    { -8, 672, 120},
    { 104, 576, 88},
    { 112, 608, 168},
    { 104, 664, 336},
    { 224, 1192, -72},
    { 16, 1040, 64},
    { -48, 1032, 280},
    { -136, 1120, 328},
    { -448, 1216, 400},
    { -496, 1304, 272},
    { -552, 1120, 216},
    { -552, 896, 200},
    // 76 seconds
    { -368, 872, 112},
    { -208, 760, 96},
    { -56, 592, 48},
    { 32, 552, 40},
    { 16, 648, 56},
    { 40, 744, 104},
    { 24, 872, 136},
    { 32, 1040, 200},
    { 120, 1128, 304},
    { -120, 1312, -72},
    { -80, 1432, 112},
    { -280, 1224, 304},
    { -368, 1088, 384},
    { -304, 1312, 200},
    { -200, 968, 192},
    { -80, 704, 184},
    { 24, 616, 136},
    { 40, 632, 168},
    { 24, 744, 368},
    { 96, 1312, -144},
    { -136, 784, 72},
    { -224, 1208, 144},
    { -320, 1272, 48},
    { -392, 1448, -24},
    { -360, 1184, 72},
    // 77 seconds
    { -384, 1080, -136},
    { -288, 816, -112},
    { -144, 696, -120},
    { 0, 600, -128},
    { 64, 544, -88},
    { 112, 568, -56},
    { 136, 736, -56},
    { 112, 1064, -152},
    { 80, 976, -16},
    { 64, 1208, -296},
    { 0, 1136, -232},
    { -336, 1368, -536},
    { -312, 1680, -376},
    { -512, 1416, -64},
    { -568, 1344, -128},
    { -312, 864, 96},
    { -248, 560, 112},
    { 72, 784, -288},
    { 32, 464, -8},
    { -32, 592, -16},
    { -104, 840, -16},
    { -248, 520, -192},
    { -112, 808, -176},
    { -288, 1120, -232},
    { -288, 1264, -280},
    // 78 seconds
    { -424, 1360, -56},
    { -320, 1096, -88},
    { -432, 920, -88},
    { -352, 848, -192},
    { -240, 816, -208},
    { -56, 624, -192},
    { 32, 576, -216},
    { 128, 608, -216},
    { 144, 744, -192},
    { 128, 864, -144},
    { 120, 1024, -128},
    { 160, 1160, -112},
    { 72, 1216, -8},
    { -208, 1304, -104},
    { -136, 1576, -96},
    { -424, 1480, 176},
    { -368, 1376, -40},
    { -320, 856, 120},
    { -88, 568, 120},
    { 120, 536, 40},
    { 144, 712, 0},
    { 120, 728, 96},
    { 152, 1064, 88},
    { -32, 1008, 48},
    { -88, 976, 8},
    // 79 seconds
    { -248, 1136, -32},
    { -192, 1216, -200},
    { -320, 1136, -40},
    { -208, 1232, -208},
    { -224, 1032, -128},
    { -240, 1232, -312},
    { -80, 880, -288},
    { 32, 240, -56},
    { 112, 328, -280},
    { 160, 432, -224},
    { 208, 552, -440},
    { 336, 672, -576},
    { 264, 712, -752},
    { 272, 1344, -584},
    { 64, 1296, -80},
    { -184, 1856, 64},
    { -240, 1304, -64},
    { 8, 1256, -32},
    { -32, 688, -32},
    { -48, 456, -64},
    { 24, 608, -200},
    { 88, 424, -160},
    { -56, 360, 88},
    { 80, 816, -640},
    { 96, 1312, -776},
    // 80 seconds
    { 48, 936, -152},
    { -24, 1040, -416},
    { -16, 1112, -216},
    { -120, 936, 40},
    { -64, 1168, -200},
    { -112, 936, -16},
    { -88, 880, -56},
    { 56, 792, -216},
    { 144, 600, -160},
    { 192, 648, -200},
    { 184, 816, -224},
    { 224, 792, -200},
    { 208, 880, -120},
    { 168, 1040, -152},
    { 64, 1024, 72},
    { 136, 1312, -312},
    { -144, 1328, -16},
    { -184, 1144, 392},
    { -152, 1184, 160},
    { -56, 1112, 144},
    { 48, 760, 64},
    { 104, 632, -16},
    { 136, 584, 64},
    { 176, 864, 72},
    { 72, 936, 16},
    // 81 seconds
    { 40, 1032, 0},
    { -96, 1280, 40},
    { -168, 1192, 8},
    { -336, 1384, 56},
    { -312, 1152, 8},
    { -264, 1104, -104},
    { -256, 928, -128},
    { -184, 824, -112},
    { -40, 624, -136},
    { 40, 504, -176},
    { 80, 632, -160},
    { 48, 744, -120},
    { 48, 864, -128},
    { 88, 912, -144},
    { 136, 968, -88},
    { 80, 1120, -16},
    { -56, 688, 64},
    { 48, 1624, 24},
    { -240, 1360, 296},
    { -168, 1256, 264},
    { -224, 1080, 384},
    { -216, 872, 320},
    { 0, 776, 152},
    { 104, 608, 136},
    { 104, 512, 208},
    // 82 seconds
    { 152, 824, 352},
    { 112, 952, 296},
    { 128, 1056, 208},
    { -104, 976, 640},
    { -40, 1168, 392},
    { -312, 1016, 696},
    { -256, 1056, 624},
    { -328, 1112, 600},
    { -344, 1008, 496},
    { -232, 848, 296},
    { -48, 688, 216},
    { 72, 640, 80},
    { 96, 544, 160},
    { 152, 704, 160},
    { 144, 824, 208},
    { 128, 984, 368},
    { 152, 1088, 264},
    { -16, 1232, 392},
    { -240, 1184, 576},
    { -248, 1392, 792},
    { -464, 1360, 576},
    { -144, 880, 504},
    { -160, 904, 440},
    { -96, 752, 344},
    { 24, 704, 200},
    // 83 seconds
    { 128, 552, 240},
    { 168, 712, 432},
    { 136, 1200, 232},
    { -8, 976, 368},
    { -56, 992, 440},
    { -152, 1048, 448},
    { -72, 1096, 560},
    { -280, 1216, 336},
    { -272, 1216, 376},
    { -408, 1056, 440},
    { -424, 992, 384},
    { -208, 688, 256},
    { -64, 688, 160},
    { 8, 576, 168},
    { 48, 608, 176},
    { 48, 728, 248},
    { -32, 856, 328},
    { -8, 1008, 392},
    { -8, 1096, 488},
    { -152, 968, 656},
    { -256, 1416, 696},
    { -408, 1616, 576},
    { -144, 776, 648},
    { -104, 1000, 264},
    { -64, 664, 336},
    // 84 seconds
    { -32, 576, 272},
    { 24, 584, 288},
    { 24, 616, 440},
    { 48, 648, 528},
    { -160, 872, 304},
    { -112, 1144, 568},
    { -256, 1224, 568},
    { -224, 1376, 192},
    { -344, 1184, 472},
    { -368, 1128, 264},
    { -296, 992, 104},
    { -96, 784, 200},
    { 96, 624, 176},
    { 136, 576, 128},
    { 96, 584, 200},
    { -8, 768, 152},
    { -56, 992, 104},
    { -104, 1032, 0},
    { 40, 984, -8},
    { 56, 1056, 264},
    { -104, 744, 72},
    { 104, 1160, 536},
    { -184, 1528, 496},
    { -64, 1248, 664},
    { 0, 1056, 752},
    // 85 seconds
    { 0, 856, 376},
    { 112, 600, 216},
    { 160, 536, 176},
    { 104, 480, 336},
    { 16, 688, 360},
    { -72, 864, 344},
    { -24, 1176, 320},
    { -216, 1240, 488},
    { -208, 1192, 272},
    { -336, 1184, 536},
    { -152, 1104, 280},
    { -160, 920, 208},
    { -96, 720, 224},
    { 48, 704, 112},
    { 168, 624, 96},
    { 184, 632, 168},
    { 184, 728, 152},
    { 160, 856, 168},
    { 184, 920, 208},
    { 176, 1096, 264},
    { 120, 1096, 384},
    { 32, 1184, 288},
    { -112, 2144, 896},
    { -344, 1320, 640},
    { -112, 1192, 208},
    // 86 seconds
    { -40, 800, 248},
    { 0, 560, 216},
    { 104, 536, 104},
    { 152, 512, 176},
    { 128, 632, 216},
    { 120, 904, 464},
    { 48, 1096, -136},
    { 56, 1104, 40},
    { -72, 1160, 136},
    { 56, 1392, 488},
    { -296, 792, 440},
    { -80, 1184, 136},
    { -40, 1128, 48},
    { -64, 1112, 0},
    { 56, 840, -24},
    { 152, 568, -24},
    { 208, 672, -32},
    { 200, 728, 24},
    { 192, 880, 56},
    { 136, 968, 184},
    { 232, 1120, 96},
    { 208, 1152, 224},
    { 232, 1048, 112},
    { 112, 992, 88},
    { -24, 1144, 56},
    // 87 seconds
    { -264, 1200, 488},
    { -48, 1336, 352},
    { -96, 1096, 400},
    { 8, 808, 328},
    { 136, 728, 136},
    { 144, 600, 224},
    { 120, 688, 224},
    { 120, 824, 304},
    { 160, 960, 336},
    { 88, 1480, 96},
    { -136, 1032, 248},
    { -136, 1328, 216},
    { -120, 1200, 344},
    { -152, 1248, 32},
    { -144, 1000, 72},
    { -136, 864, 16},
    { 24, 656, -56},
    { 56, 544, -96},
    { 56, 720, -80},
    { 0, 848, -56},
    { 8, 896, 16},
    { 96, 1048, -80},
    { 144, 968, 48},
    { 152, 888, 160},
    { 152, 968, 88},
    // 88 seconds
    { 144, 920, 176},
    { 232, 1368, 280},
    { -120, 1840, 336},
    { -200, 1160, 504},
    { -120, 1152, 352},
    { -104, 976, 352},
    { 40, 784, 272},
    { 120, 648, 128},
    { 120, 520, 224},
    { 136, 704, 128},
    { 136, 800, 240},
    { -96, 656, 208},
    { -88, 1400, 224},
    { -232, 1320, 24},
    { -352, 1352, 256},
    { -408, 1392, 72},
    { -360, 1184, -160},
    { -104, 904, -264},
    { 8, 464, -192},
    { 88, 368, -144},
    { 264, 448, -128},
    { 280, 704, -8},
    { 160, 1008, -24},
    { 224, 952, -56},
    { 232, 872, 24},
    // 89 seconds
    { 136, 1024, 48},
    { -32, 976, 336},
    { 96, 1720, 176},
    { -328, 1392, 472},
    { -160, 1328, 216},
    { -176, 1080, 464},
    { -136, 1072, 96},
    { 24, 808, 168},
    { 184, 584, 96},
    { 160, 528, 168},
    { 136, 632, 376},
    { 216, 1528, -16},
    { -152, 1016, 136},
    { -296, 1296, 120},
    { -352, 1408, 392},
    { -496, 1312, 400},
    { -248, 992, 48},
    { -224, 816, -88},
    { -224, 656, 128},
    { -136, 736, 40},
    { -24, 704, -40},
    { -16, 656, 40},
    { 48, 784, -32},
    { 72, 896, 24},
    { 168, 1008, 72},
    // 90 seconds
    { 160, 1144, 96},
    { 88, 1080, 192},
    { 88, 1040, 128},
    { 136, 840, 344},
    { -360, 1592, 608},
    { -560, 1496, 600},
    { -384, 1368, 432},
    { -168, 896, 304},
    { 168, 656, 216},
    { 80, 384, 144},
    { 72, 536, 224},
    { 96, 648, 320},
    { 32, 800, 112},
    { -88, 1216, 384},
    { -304, 1168, 272},
    { -248, 1168, 232},
    { -456, 1200, 352},
    { -328, 1344, 152},
    { -240, 1032, -40},
    { -160, 800, 96},
    { -56, 704, 24},
    { 40, 592, -16},
    { 64, 624, 88},
    { 88, 744, 72},
    { 56, 920, 80},
    // 91 seconds
    { 88, 960, 128},
    { 96, 1032, 96},
    { 104, 1096, 168},
    { -16, 1112, 184},
    { -16, 1200, 368},
    { -168, 1456, 392},
    { -392, 1040, 616},
    { -240, 1368, 440},
    { -192, 792, 368},
    { -24, 704, 128},
    { 160, 432, 176},
    { 136, 560, 160},
    { 160, 784, 168},
    { 184, 920, 360},
    { 184, 1272, 240},
    { 80, 1128, 456},
    { -104, 1200, 152},
    { -120, 1200, 144},
    { -168, 960, 8},
    { -360, 1024, 312},
    { -504, 1312, 232},
    { -296, 1200, 112},
    { -136, 928, 32},
    { 8, 608, 72},
    { 120, 528, 24},
    // 92 seconds
    { 176, 512, 144},
    { 184, 680, 152},
    { 176, 856, 136},
    { 120, 1104, 144},
    { 128, 1056, 200},
    { 40, 1392, -88},
    { -24, 1112, 16},
    { -24, 1040, 136},
    { -304, 1712, 248},
    { -368, 1248, 496},
    { -248, 1192, 192},
    { -184, 728, 248},
    { -32, 512, 216},
    { 136, 616, 192},
    { 104, 976, 104},
    { 24, 1048, 80},
    { -24, 816, 296},
    { -48, 1096, 296},
    { -200, 1176, 232},
    { -272, 1200, 184},
    { -464, 1232, 304},
    { -424, 1344, 72},
    { -352, 1040, 24},
    { -280, 760, 0},
    { -80, 584, -56},
    // 93 seconds
    { 80, 496, -64},
    { 120, 560, -48},
    { 168, 792, -72},
    { 152, 912, 64},
    { 128, 1120, 72},
    { 152, 1040, 152},
    { -32, 1208, 200},
    { -48, 1384, 192},
    { -352, 1496, 296},
    { -216, 1288, 416},
    { -216, 1016, 456},
    { -136, 784, 288},
    { 104, 608, 168},
    { 176, 600, 168},
    { 184, 600, 376},
    { 216, 872, 160},
    { 88, 1008, 336},
    { -40, 1096, 304},
    { -144, 1376, 344},
    { -160, 1216, 272},
    { -312, 1304, 232},
    { -248, 1120, 48},
    { -232, 960, 32},
    { -192, 880, 0},
    { 0, 616, -72},
    // 94 seconds
    { 96, 480, -64},
    { 120, 504, 0},
    { 64, 736, 32},
    { -24, 952, 48},
    { 0, 912, 16},
    { -80, 864, 16},
    { -256, 736, -328},
    { -240, 688, -160},
    { -488, 640, 88},
    { -1128, 752, 16},
    { -1512, 1032, -72},
    { -1432, 600, 56},
    { -1336, 792, -360},
    { -680, 584, -136},
    { -520, 280, -48},
    { -696, 256, -88},
    { -920, 376, -192},
    { -1080, 232, -136},
    { -1056, 392, -176},
    { -1272, 296, -184},
    { -1152, 184, -48},
    { -1440, 136, -160},
    { -624, 328, -336},
    { -896, 408, -464},
    { -792, -16, -128},
    // 95 seconds
    { -440, 56, -168},
    { -376, 0, -96},
    { -456, 64, -88},
    { -728, 136, -128},
    { -960, 264, -168},
    { -960, 248, -240},
    { -1144, 280, -392},
    { -976, 312, -272},
    { -1480, 392, -288},
    { -2016, 600, -336},
    { -1152, -32, 72},
    { -1104, 232, -160},
    { -752, 176, -88},
    { -448, 88, -16},
    { -504, 176, -48},
    { -576, 144, 56},
    { -728, -32, 104},
    { -904, 240, -16},
    { -1120, 176, -40},
    { -1232, 256, -168},
    { -984, 256, -144},
    { -1608, 184, -136},
    { -728, 256, -248},
    { -1072, 24, -160},
    { -896, -88, -64},
    // 96 seconds
    { -464, -16, -136},
    { -368, 8, -128},
    { -448, 32, -176},
    { -688, 136, -224},
    { -784, 88, -248},
    { -896, -8, -448},
    { -1056, 304, -224},
    { -984, 304, -448},
    { -1264, 152, -264},
    { -1984, 616, -552},
    { -1256, -168, 192},
    { -1072, 264, -176},
    { -880, 192, -160},
    { -512, 40, -80},
    { -528, 128, -32},
    { -600, 48, 56},
    { -672, -184, 112},
    { -1120, 152, 144},
    { -1080, 264, -96},
    { -1176, 200, -72},
    { -1088, 216, -120},
    { -1520, 120, -56},
    { -1032, 520, -440},
    { -984, 600, -376},
    { -728, 528, -152},
    // 97 seconds
    { -448, 728, -184},
    { -416, 648, -160},
    { -448, 616, -120},
    { -416, 456, -40},
    { -336, 848, -192},
    { -224, 688, -112},
    { -96, 944, -104},
    { -176, 960, 96},
    { -200, 888, 112},
    { -528, 1568, 184},
    { -696, 1240, 328},
    { -432, 1176, 216},
    { -304, 952, 200},
    { -184, 720, 120},
    { -32, 624, 112},
    { -16, 576, 120},
    { 24, 600, 144},
    { 80, 824, 144},
    { -96, 1000, 160},
    { -64, 1040, 152},
    { -256, 1096, 272},
    { -360, 1688, 240},
    { -368, 1208, 208},
    { -288, 1152, -56},
    { -312, 784, 32},
    // 98 seconds
    { -136, 648, -144},
    { 0, 496, -64},
    { 32, 480, -32},
    { 56, 672, -24},
    { -16, 872, 72},
    { -40, 1072, 8},
    { 64, 976, 56},
    { 104, 1176, 144},
    { -48, 1072, 392},
    { -88, 1792, 384},
    { -528, 1488, 456},
    { -208, 1192, 328},
    { -144, 992, 304},
    { -64, 728, 368},
    { 56, 640, 224},
    { 128, 592, 184},
    { 120, 624, 304},
    { 56, 928, 296},
    { 40, 1072, 472},
    { -184, 1208, 360},
    { -264, 1160, 224},
    { -200, 1080, 200},
    { -368, 1200, 328},
    { -336, 1176, 232},
    { -200, 1064, -8},
    // 99 seconds
    { -128, 784, -8},
    { -72, 656, 56},
    { 88, 608, -32},
    { 96, 568, 40},
    { 120, 720, 40},
    { 104, 848, 88},
    { 120, 976, 248},
    { 208, 1048, 296},
    { -72, 1376, 320},
    { -96, 1016, 408},
    { -216, 1680, 408},
    { -360, 1296, 552},
    { -224, 1184, 368},
    { -176, 936, 408},
    { -32, 632, 288},
    { 72, 552, 224},
    { 72, 576, 280},
    { 48, 672, 328},
    { 8, 1184, 280},
    { -32, 1376, 184},
    { -184, 1336, 168},
    { -232, 1024, 144},
    { -360, 1440, 240},
    { -360, 1224, 112},
    { -344, 1072, -56},
    // 100 seconds
    { -312, 808, 8},
    { -128, 712, -32},
    { 16, 616, -48},
    { 48, 560, -40},
    { 80, 592, -8},
    { 64, 808, -80},
    { 32, 848, 72},
    { 104, 944, 48},
    { 136, 1360, 184},
    { -40, 1184, 96},
    { 8, 1496, 120},
    { -248, 1536, 8},
    { -120, 1096, 408},
    { -24, 1176, 208},
    { 0, 920, 272},
    { -40, 672, 256},
    { 40, 792, 360},
    { 80, 816, 296},
    { 16, 808, 272},
    { -16, 976, 168},
    { -96, 944, 160},
    { -168, 1192, 88},
    { -216, 1248, -16},
    { -408, 1328, 224},
    { -152, 1088, -136},
    // 101 seconds
    { -72, 872, -120},
    { -64, 792, 0},
    { 40, 760, -72},
    { 168, 624, -48},
    { 168, 640, 24},
    { 200, 752, 0},
    { 152, 816, 24},
    { 232, 912, -40},
    { 256, 1072, 80},
    { 56, 1336, -64},
    { 24, 1344, 328},
    { -248, 1824, 208},
    { -112, 1200, 376},
    { 48, 1296, 240},
    { -8, 984, 240},
    { 64, 656, 200},
    { 176, 600, 112},
    { 184, 640, 136},
    { 160, 648, 184},
    { 56, 888, -128},
    { 128, 824, 144},
    { 120, 968, 232},
    { 16, 1144, 56},
    { -160, 1200, 152},
    { -240, 1384, 160},
    // 102 seconds
    { -336, 1360, 32},
    { -344, 1000, 8},
    { -240, 856, -80},
    { -200, 680, -104},
    { -136, 456, 24},
    { 32, 472, -128},
    { 144, 520, 32},
    { 152, 808, 24},
    { 144, 1048, 232},
    { 120, 1200, 208},
    { -136, 1376, 272},
    { -40, 1320, 408},
    { -344, 1632, 392},
    { -184, 1144, 464},
    { -144, 1160, 336},
    { -136, 840, 360},
    { -32, 592, 192},
    { 48, 592, 192},
    { 88, 576, 312},
    { -8, 536, 296},
    { -80, 1200, 336},
    { -200, 1136, 320},
    { -304, 1176, 144},
    { -280, 1112, 288},
    { -384, 1216, 112},
    // 103 seconds
    { -144, 984, -32},
    { -136, 976, -112},
    { -200, 880, -40},
    { -16, 672, -120},
    { 112, 624, -136},
    { 120, 584, -48},
    { 152, 720, -32},
    { 112, 856, 8},
    { 112, 1000, 64},
    { 120, 1048, 168},
    { -48, 1488, -280},
    { -88, 1664, 136},
    { -416, 1272, 280},
    { -168, 1240, 248},
    { -168, 1048, 320},
    { -112, 784, 328},
    { -8, 680, 144},
    { 48, 648, 200},
    { 40, 688, 264},
    { 40, 1192, 240},
    { -128, 736, 24},
    { -16, 1008, 328},
    { -128, 1144, 232},
    { -80, 1112, 224},
    { -232, 1032, 208},
    // 104 seconds
    { -144, 1104, 112},
    { -208, 1064, -40},
    { -256, 952, 24},
    { -104, 848, -120},
    { 16, 616, -64},
    { 72, 592, -64},
    { 96, 672, -32},
    { 80, 856, -72},
    { 80, 904, -16},
    { 96, 968, -16},
    { 96, 1104, -8},
    { 32, 1048, 16},
    { 128, 1120, 176},
    { -288, 1280, 216},
    { -128, 1544, 440},
    { -128, 1184, 328},
    { -40, 920, 288},
    { 16, 680, 320},
    { 56, 576, 136},
    { 88, 752, 240},
    { 24, 712, 248},
    { 48, 848, 288},
    { 0, 744, 120},
    { -136, 1208, 280},
    { -152, 1120, 280},
    // 105 seconds
    { -232, 1344, 288},
    { -184, 1296, 200},
    { -184, 1112, 16},
    { -152, 928, 48},
    { -120, 784, 16},
    { -32, 656, -24},
    { -32, 648, 24},
    { -16, 720, 56},
    { -48, 856, 96},
    { 24, 928, 72},
    { 72, 976, 128},
    { 96, 1096, 200},
    { 80, 1056, 464},
    { -96, 1544, 416},
    { -104, 1248, 544},
    { -120, 1104, 448},
    { -104, 888, 384},
    { -16, 720, 312},
    { -16, 776, 280},
    { -56, 744, 312},
    { -64, 848, 312},
    { -24, 920, 384},
    { 24, 888, 344},
    { 56, 848, 296},
    { 24, 1072, 344},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

