/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:42:19 local
AccelRawData *activity_sample_walk_100_pbl_25666_1(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25666_1
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 96, 136, -960},
    { 152, 152, -976},
    { 144, 136, -960},
    { 184, 96, -968},
    { 216, 72, -952},
    { 240, 72, -928},
    { 240, 56, -944},
    { 208, 64, -968},
    { 216, 80, -992},
    { 224, 88, -1008},
    { 216, 88, -1000},
    { 256, 72, -984},
    { 288, 96, -992},
    { 296, 136, -992},
    { 224, 168, -968},
    { 224, 200, -960},
    { 152, 192, -928},
    { 104, 208, -944},
    { 40, 200, -960},
    { 32, 200, -976},
    { -8, 208, -1008},
    { 8, 192, -1048},
    { -64, 192, -1024},
    { 16, 176, -968},
    { 32, 136, -944},
    // 1 seconds
    { 8, 104, -896},
    { 56, 88, -944},
    { 88, 40, -952},
    { 168, 48, -992},
    { 216, 40, -1000},
    { 208, 40, -992},
    { 224, 24, -1016},
    { 232, 48, -1048},
    { 272, 112, -1032},
    { 48, -32, -912},
    { 192, -80, -960},
    { 80, -48, -936},
    { 8, 24, -928},
    { -32, -8, -944},
    { 64, 16, -968},
    { 112, 32, -976},
    { 8, 80, -992},
    { 40, 64, -992},
    { 64, 40, -968},
    { 80, 48, -968},
    { 112, 8, -960},
    { 136, -56, -944},
    { 160, -112, -960},
    { 120, -104, -968},
    { 184, -72, -1008},
    // 2 seconds
    { 208, -32, -800},
    { 656, 56, -1232},
    { 408, 224, -1000},
    { 496, 464, -856},
    { 384, 648, -728},
    { 376, 752, -616},
    { 352, 800, -544},
    { 264, 760, -440},
    { 160, 736, -344},
    { 112, 744, -296},
    { 88, 824, -280},
    { 120, 872, -264},
    { 112, 880, -264},
    { 72, 864, -312},
    { 72, 1040, -216},
    { 80, 1008, -168},
    { 80, 1384, 184},
    { 320, 1416, 192},
    { 120, 1144, 200},
    { 88, 936, 272},
    { 88, 952, 360},
    { 168, 1024, 256},
    { 144, 848, 272},
    { 80, 680, 208},
    { 40, 760, 200},
    // 3 seconds
    { 80, 704, 288},
    { 8, 872, 312},
    { 24, 992, 352},
    { 48, 1032, 440},
    { 56, 1136, 368},
    { 112, 1136, 568},
    { 280, 1344, 520},
    { 152, 1152, 376},
    { 176, 960, 408},
    { 240, 896, 376},
    { 224, 800, 328},
    { 96, 640, 272},
    { 24, 576, 208},
    { -8, 736, 200},
    { -32, 760, 232},
    { -24, 920, 248},
    { -24, 984, 272},
    { -104, 1008, 160},
    { -40, 1128, 272},
    { -136, 1120, 392},
    { 248, 1344, 480},
    { 144, 1016, 416},
    { 56, 960, 320},
    { 88, 944, 376},
    { 208, 1000, 392},
    // 4 seconds
    { 160, 824, 280},
    { 96, 680, 208},
    { 96, 728, 112},
    { 112, 736, 128},
    { 112, 760, 184},
    { 112, 848, 216},
    { 80, 1024, 272},
    { 120, 1176, 272},
    { 96, 1216, 328},
    { 192, 1328, 424},
    { 256, 1256, 192},
    { 112, 1072, 216},
    { 208, 912, 240},
    { 312, 936, 328},
    { 216, 704, 272},
    { 96, 632, 224},
    { 0, 656, 200},
    { -48, 768, 232},
    { -112, 912, 256},
    { -128, 976, 264},
    { -136, 1008, 248},
    { -120, 1040, 304},
    { -128, 1296, 584},
    { 176, 1360, 624},
    { 184, 1168, 496},
    // 5 seconds
    { 56, 968, 416},
    { 96, 864, 448},
    { 144, 792, 368},
    { 208, 728, 216},
    { 112, 616, 160},
    { 88, 616, 120},
    { 80, 760, 80},
    { 72, 784, 104},
    { 8, 976, 160},
    { 64, 1136, 296},
    { -24, 1232, 240},
    { 208, 1472, 408},
    { 176, 1432, 384},
    { 40, 1016, 384},
    { 176, 872, 448},
    { 200, 848, 512},
    { 168, 672, 432},
    { 32, 504, 376},
    { -24, 416, 408},
    { -72, 424, 536},
    { -152, 664, 584},
    { -152, 800, 568},
    { -232, 832, 608},
    { -232, 912, 528},
    { -160, 1016, 552},
    // 6 seconds
    { 24, 1168, 568},
    { 232, 1304, 560},
    { 152, 1112, 496},
    { 208, 1040, 368},
    { 296, 1112, 256},
    { 272, 976, 168},
    { 224, 744, 64},
    { 192, 672, 8},
    { 200, 728, -40},
    { 216, 768, -88},
    { 200, 768, -72},
    { 240, 968, -104},
    { 256, 1080, -112},
    { 240, 1096, -144},
    { 280, 1304, -224},
    { 368, 1464, -416},
    { 184, 1008, -472},
    { 280, 824, -568},
    { 400, 904, -584},
    { 360, 696, -544},
    { 240, 408, -432},
    { 176, 344, -448},
    { 192, 376, -528},
    { 184, 376, -552},
    { 152, 696, -728},
    // 7 seconds
    { 144, 664, -872},
    { 152, 616, -904},
    { 296, 560, -904},
    { 352, 752, -1096},
    { 536, 720, -1056},
    { 440, 464, -808},
    { 528, 504, -912},
    { 488, 400, -832},
    { 472, 272, -712},
    { 392, 200, -568},
    { 312, 96, -504},
    { 288, 64, -440},
    { 280, -32, -352},
    { 472, 168, -480},
    { 528, 280, -528},
    { 696, 408, -528},
    { 888, 688, -568},
    { 944, 632, -416},
    { 1272, 720, -400},
    { 1336, 904, -224},
    { 1232, 944, -88},
    { 1328, 920, -32},
    { 1160, 832, 200},
    { 760, 632, 96},
    { 656, 456, 96},
    // 8 seconds
    { 640, 360, 176},
    { 664, 368, 40},
    { 736, 360, 112},
    { 712, 440, -8},
    { 896, 568, -40},
    { 1208, 720, -248},
    { 1912, 912, -208},
    { 1448, 960, -328},
    { 1144, 680, -320},
    { 1336, 592, -248},
    { 1248, 408, -160},
    { 1072, 272, -128},
    { 920, 168, -64},
    { 880, 160, -24},
    { 832, 104, -16},
    { 752, 32, -24},
    { 744, 80, -40},
    { 752, -8, -72},
    { 920, 32, -152},
    { 1024, -8, -232},
    { 1560, 248, -336},
    { 1232, 320, -504},
    { 1272, 296, -560},
    { 1456, 288, -520},
    { 1200, 336, -352},
    // 9 seconds
    { 816, 328, -184},
    { 664, 296, -112},
    { 632, 176, -48},
    { 736, 176, -128},
    { 840, 224, -160},
    { 952, 408, -192},
    { 1072, 512, -304},
    { 1272, 600, -368},
    { 1824, 528, -256},
    { 1592, 608, -376},
    { 1136, 432, -272},
    { 1320, 304, -152},
    { 1248, 224, -144},
    { 984, 152, -96},
    { 776, 152, -88},
    { 744, 112, -64},
    { 768, 96, -48},
    { 792, 136, -32},
    { 800, 160, -48},
    { 848, 144, -72},
    { 1008, 96, -120},
    { 1144, 88, -184},
    { 1656, 176, -152},
    { 1352, 400, -408},
    { 1096, 440, -608},
    // 10 seconds
    { 1296, 368, -560},
    { 1232, 88, -248},
    { 888, 128, -144},
    { 736, 264, -128},
    { 680, 184, -128},
    { 744, 120, -112},
    { 856, 136, -144},
    { 952, 168, -240},
    { 984, 256, -264},
    { 1160, 312, -376},
    { 1472, 248, -280},
    { 1912, 408, -328},
    { 1368, 480, -368},
    { 1256, 360, -224},
    { 1344, 264, -192},
    { 1216, 248, -152},
    { 928, 224, -112},
    { 784, 232, -88},
    { 752, 176, -64},
    { 720, 96, 8},
    { 720, 80, -32},
    { 752, 80, -56},
    { 816, 48, -56},
    { 1016, 72, -112},
    { 1584, -16, -32},
    // 11 seconds
    { 1632, 264, -344},
    { 1184, 232, -544},
    { 1368, 344, -616},
    { 1320, 160, -320},
    { 1056, 88, -112},
    { 840, 232, -184},
    { 712, 176, -152},
    { 664, 216, -152},
    { 720, 200, -208},
    { 896, 224, -208},
    { 1024, 360, -264},
    { 1176, 464, -280},
    { 1416, 432, -296},
    { 1864, 464, -272},
    { 1536, 480, -304},
    { 1216, 392, -144},
    { 1352, 288, -104},
    { 1296, 216, -88},
    { 1000, 208, -64},
    { 824, 208, -56},
    { 792, 168, -40},
    { 792, 144, -8},
    { 728, 120, 8},
    { 704, 112, -8},
    { 752, 96, -24},
    // 12 seconds
    { 992, 136, -88},
    { 1096, 88, -192},
    { 1560, 144, -160},
    { 1296, 352, -464},
    { 1176, 416, -568},
    { 1400, 384, -552},
    { 1304, 416, -352},
    { 896, 392, -272},
    { 696, 328, -200},
    { 640, 288, -136},
    { 672, 208, -96},
    { 816, 240, -176},
    { 912, 336, -208},
    { 976, 400, -296},
    { 1224, 440, -344},
    { 1616, 384, -312},
    { 1664, 440, -320},
    { 1192, 440, -272},
    { 1328, 384, -168},
    { 1232, 272, -152},
    { 1000, 208, -152},
    { 824, 232, -128},
    { 744, 248, -120},
    { 752, 176, -80},
    { 808, 136, -48},
    // 13 seconds
    { 824, 120, -16},
    { 880, 96, -16},
    { 1016, 56, -64},
    { 1064, 40, -88},
    { 1472, -48, -80},
    { 1520, 248, -400},
    { 1088, 232, -360},
    { 1224, 280, -432},
    { 1312, 208, -320},
    { 968, 216, -240},
    { 736, 272, -176},
    { 704, 280, -240},
    { 704, 184, -200},
    { 832, 176, -184},
    { 968, 240, -264},
    { 1064, 184, -304},
    { 1272, 304, -336},
    { 1520, 208, -184},
    { 1864, 336, -336},
    { 1304, 400, -224},
    { 1480, 288, -176},
    { 1480, 192, -128},
    { 1176, 144, -80},
    { 936, 160, -48},
    { 784, 104, -24},
    // 14 seconds
    { 712, 16, 24},
    { 688, 24, 8},
    { 680, 32, 16},
    { 720, 96, 0},
    { 872, 136, -80},
    { 1032, 96, -168},
    { 1648, 120, -192},
    { 1384, 272, -432},
    { 1176, 352, -472},
    { 1424, 368, -584},
    { 1288, 248, -376},
    { 936, 336, -280},
    { 728, 384, -200},
    { 672, 272, -168},
    { 680, 208, -104},
    { 832, 256, -168},
    { 944, 240, -224},
    { 1072, 336, -256},
    { 1280, 360, -304},
    { 1632, 288, -200},
    { 1800, 400, -360},
    { 1304, 368, -296},
    { 1400, 304, -176},
    { 1384, 168, -120},
    { 1160, 144, -104},
    // 15 seconds
    { 920, 208, -72},
    { 816, 152, -16},
    { 768, 88, 16},
    { 712, 48, 0},
    { 688, 72, 8},
    { 688, 64, 8},
    { 824, 72, 8},
    { 1032, 144, -64},
    { 1496, 56, -56},
    { 1592, 240, -328},
    { 1216, 312, -448},
    { 1352, 336, -440},
    { 1368, 264, -328},
    { 1128, 240, -256},
    { 856, 272, -232},
    { 688, 280, -176},
    { 712, 256, -240},
    { 800, 224, -224},
    { 952, 312, -256},
    { 1064, 328, -232},
    { 1288, 360, -264},
    { 1384, 304, -184},
    { 1880, 320, -192},
    { 1416, 328, -240},
    { 1168, 272, -112},
    // 16 seconds
    { 1368, 224, -96},
    { 1280, 192, -72},
    { 976, 184, -40},
    { 808, 200, -24},
    { 792, 160, -24},
    { 776, 120, 0},
    { 744, 128, 16},
    { 704, 120, 0},
    { 736, 96, -8},
    { 912, 112, -48},
    { 1048, 80, -104},
    { 1560, 24, -136},
    { 1592, 248, -360},
    { 1216, 352, -432},
    { 1360, 312, -400},
    { 1408, 296, -368},
    { 1024, 280, -240},
    { 736, 256, -184},
    { 664, 240, -176},
    { 712, 248, -160},
    { 824, 200, -200},
    { 944, 280, -200},
    { 1080, 384, -256},
    { 1288, 368, -256},
    { 1560, 272, -152},
    // 17 seconds
    { 1840, 376, -192},
    { 1296, 408, -232},
    { 1272, 336, -112},
    { 1320, 208, -80},
    { 1216, 184, -56},
    { 952, 192, -56},
    { 832, 200, -24},
    { 808, 168, -16},
    { 768, 96, 16},
    { 728, 152, 8},
    { 672, 112, 8},
    { 760, 64, -16},
    { 1008, 176, -48},
    { 1192, 0, -64},
    { 1624, 120, -216},
    { 1312, 264, -536},
    { 1288, 280, -560},
    { 1448, 232, -448},
    { 1304, 168, -272},
    { 952, 224, -216},
    { 744, 192, -184},
    { 704, 184, -216},
    { 736, 208, -184},
    { 800, 136, -152},
    { 920, 272, -200},
    // 18 seconds
    { 1064, 336, -256},
    { 1344, 320, -280},
    { 1808, 224, -184},
    { 1720, 384, -360},
    { 1344, 384, -192},
    { 1480, 216, -120},
    { 1440, 160, -136},
    { 1080, 168, -128},
    { 832, 192, -104},
    { 776, 136, -56},
    { 792, 96, -32},
    { 688, 32, 32},
    { 648, 32, 24},
    { 720, 32, 24},
    { 904, 112, -16},
    { 1008, 64, -120},
    { 1584, 0, -144},
    { 1456, 256, -400},
    { 1408, 352, -480},
    { 1592, 360, -456},
    { 1368, 328, -312},
    { 968, 216, -168},
    { 744, 136, -168},
    { 672, 224, -200},
    { 656, 208, -152},
    // 19 seconds
    { 776, 256, -192},
    { 944, 280, -176},
    { 1120, 344, -184},
    { 1392, 352, -248},
    { 1640, 416, -208},
    { 1616, 544, -288},
    { 1264, 552, -288},
    { 1472, 400, -184},
    { 1496, 304, -88},
    { 1184, 240, -64},
    { 928, 232, -40},
    { 784, 160, 0},
    { 672, 16, 112},
    { 624, 168, 16},
    { 744, 208, 24},
    { 760, 112, 8},
    { 952, 176, -40},
    { 1032, 144, -160},
    { 1472, 96, -104},
    { 1304, 280, -384},
    { 1248, 288, -448},
    { 1528, 336, -392},
    { 1400, 328, -272},
    { 1000, 224, -152},
    { 776, 224, -112},
    // 20 seconds
    { 752, 232, -120},
    { 768, 208, -88},
    { 856, 208, -152},
    { 960, 304, -112},
    { 1088, 448, -144},
    { 1376, 560, -232},
    { 1672, 400, -104},
    { 1736, 472, -152},
    { 1280, 384, -104},
    { 1360, 280, 16},
    { 1344, 256, 40},
    { 1128, 296, 40},
    { 896, 248, 72},
    { 792, 160, 112},
    { 768, 120, 120},
    { 792, 152, 112},
    { 808, 152, 120},
    { 816, 168, 88},
    { 992, 128, 56},
    { 1048, 128, 8},
    { 1312, 16, 56},
    { 1456, 240, -184},
    { 1200, 184, -280},
    { 1448, 200, -280},
    { 1440, 152, -200},
    // 21 seconds
    { 1072, 208, -152},
    { 816, 256, -152},
    { 816, 304, -176},
    { 808, 256, -160},
    { 840, 176, -160},
    { 928, 240, -200},
    { 1016, 328, -224},
    { 1288, 296, -240},
    { 1456, 304, -136},
    { 1928, 312, -128},
    { 1360, 312, -208},
    { 1432, 240, 16},
    { 1576, 248, 40},
    { 1312, 160, 24},
    { 1024, 176, -8},
    { 888, 216, 0},
    { 856, 120, 48},
    { 776, 56, 72},
    { 680, 0, 88},
    { 648, 56, 24},
    { 696, 64, -40},
    { 800, 136, -40},
    { 1008, -88, 16},
    { 1584, 88, -248},
    { 1456, 112, -528},
    // 22 seconds
    { 1680, 144, -520},
    { 1624, 32, -288},
    { 1072, 0, -120},
    { 800, 72, -128},
    { 776, 312, -88},
    { 824, 304, -72},
    { 856, 240, -104},
    { 984, 392, -200},
    { 888, 312, -152},
    { 1096, 352, -144},
    { 1312, 432, -176},
    { 1640, 264, -56},
    { 1704, 440, -192},
    { 1392, 320, 64},
    { 1536, 280, 56},
    { 1392, 248, -16},
    { 1120, 192, 24},
    { 832, 120, 24},
    { 760, 112, 16},
    { 712, 48, 40},
    { 680, 8, -8},
    { 728, 56, -8},
    { 816, 136, -48},
    { 976, 32, -64},
    { 1112, 32, -40},
    // 23 seconds
    { 1680, 152, -136},
    { 1264, 232, -360},
    { 1424, 256, -328},
    { 1512, 224, -272},
    { 1128, 56, -72},
    { 872, 216, -136},
    { 808, 144, -176},
    { 760, 152, -160},
    { 800, 224, -160},
    { 928, 128, -176},
    { 1008, 224, -168},
    { 1128, 336, -256},
    { 1384, 360, -336},
    { 1408, 232, -160},
    { 1712, 320, -200},
    { 1320, 432, -112},
    { 1360, 288, -32},
    { 1368, 264, -56},
    { 1144, 240, 8},
    { 952, 264, 24},
    { 824, 208, 32},
    { 832, 160, 72},
    { 816, 80, 88},
    { 760, -32, 64},
    { 792, 32, 0},
    // 24 seconds
    { 832, 0, -16},
    { 936, 0, -56},
    { 1336, 0, 32},
    { 1616, 248, -248},
    { 1320, 304, -456},
    { 1424, 272, -520},
    { 1448, 280, -224},
    { 1144, 192, 32},
    { 856, 232, 40},
    { 736, 368, 8},
    { 688, 296, -48},
    { 728, 192, -112},
    { 816, 256, -56},
    { 920, 448, -120},
    { 1104, 504, -152},
    { 1392, 552, -208},
    { 1752, 456, -128},
    { 1544, 504, -224},
    { 1240, 408, -64},
    { 1544, 336, -24},
    { 1448, 200, 32},
    { 1192, 192, 40},
    { 920, 200, 16},
    { 824, 168, 8},
    { 784, 128, 32},
    // 25 seconds
    { 728, 64, 56},
    { 704, 96, 40},
    { 752, 88, 24},
    { 888, 112, 32},
    { 1128, 80, 0},
    { 1624, 168, 24},
    { 1264, 296, -288},
    { 1288, 344, -408},
    { 1488, 344, -424},
    { 1296, 224, -184},
    { 960, 208, -176},
    { 776, 264, -208},
    { 728, 240, -136},
    { 768, 192, -136},
    { 928, 208, -200},
    { 1048, 272, -152},
    { 1160, 424, -272},
    { 1320, 368, -216},
    { 1512, 248, -120},
    { 1712, 320, -152},
    { 1344, 368, -144},
    { 1288, 320, -40},
    { 1360, 216, 40},
    { 1288, 160, 40},
    { 1048, 208, 16},
    // 26 seconds
    { 824, 160, 16},
    { 736, 176, 16},
    { 728, 120, 32},
    { 736, 80, 24},
    { 744, 120, -8},
    { 792, 96, 32},
    { 1016, 128, 0},
    { 1128, 184, -72},
    { 1600, 112, -16},
    { 1560, 320, -192},
    { 1136, 400, -360},
    { 1288, 320, -320},
    { 1360, 160, -128},
    { 1072, 240, -80},
    { 808, 304, -96},
    { 744, 224, -144},
    { 776, 152, -128},
    { 880, 192, -152},
    { 1008, 192, -160},
    { 976, 280, -120},
    { 1200, 400, -240},
    { 1384, 336, -208},
    { 1576, 224, -24},
    { 1680, 376, -96},
    { 1216, 440, -56},
    // 27 seconds
    { 1400, 280, 0},
    { 1376, 240, 48},
    { 1088, 176, 80},
    { 864, 192, 56},
    { 776, 152, 32},
    { 744, 80, 32},
    { 760, 48, -24},
    { 752, 88, 40},
    { 792, 64, 24},
    { 984, 112, 8},
    { 1072, 144, -8},
    { 1424, 32, 0},
    { 1504, 280, -240},
    { 1216, 264, -240},
    { 1440, 336, -304},
    { 1392, 264, -272},
    { 1048, 144, -152},
    { 784, 232, -120},
    { 784, 296, -176},
    { 760, 200, -120},
    { 832, 200, -160},
    { 920, 280, -120},
    { 1088, 344, -144},
    { 1320, 384, -176},
    { 1560, 216, 0},
    // 28 seconds
    { 1888, 328, -96},
    { 1376, 392, -112},
    { 1264, 288, 16},
    { 1328, 208, -32},
    { 1216, 160, -8},
    { 904, 168, 16},
    { 784, 208, 8},
    { 736, 176, 40},
    { 712, 88, 80},
    { 720, 152, 40},
    { 744, 128, 32},
    { 848, 88, 56},
    { 1064, 136, -24},
    { 1296, 48, 40},
    { 1712, 264, -112},
    { 1248, 408, -376},
    { 1296, 472, -464},
    { 1424, 360, -352},
    { 1208, 136, -144},
    { 904, 200, -128},
    { 736, 216, -112},
    { 696, 192, -128},
    { 736, 160, -168},
    { 872, 224, -152},
    { 1008, 248, -160},
    // 29 seconds
    { 1168, 296, -160},
    { 1352, 360, -168},
    { 1640, 216, -24},
    { 1600, 296, -64},
    { 1192, 384, -104},
    { 1296, 304, -32},
    { 1320, 208, -40},
    { 1112, 216, -8},
    { 888, 264, 0},
    { 784, 208, -8},
    { 768, 152, 8},
    { 768, 168, 32},
    { 760, 128, 48},
    { 760, 88, 48},
    { 912, 120, 48},
    { 1104, 128, 16},
    { 1624, 48, 48},
    { 1568, 296, -288},
    { 1208, 408, -400},
    { 1336, 432, -384},
    { 1384, 264, -184},
    { 1056, 192, -104},
    { 800, 248, -128},
    { 680, 200, -128},
    { 632, 184, -96},
    // 30 seconds
    { 720, 208, -40},
    { 896, 272, -168},
    { 1008, 280, -160},
    { 1240, 408, -248},
    { 1384, 392, -240},
    { 1656, 208, -136},
    { 1512, 416, -272},
    { 1216, 408, -144},
    { 1408, 288, -128},
    { 1448, 272, -72},
    { 1112, 208, 8},
    { 856, 248, -24},
    { 792, 240, -40},
    { 760, 152, 40},
    { 728, 144, 112},
    { 712, 152, 80},
    { 768, 96, 112},
    { 936, 96, 104},
    { 1128, 112, 32},
    { 1616, 80, 128},
    { 1400, 424, -328},
    { 1192, 336, -312},
    { 1416, 352, -320},
    { 1376, 152, -80},
    { 1016, 184, -144},
    // 31 seconds
    { 792, 232, -176},
    { 696, 256, -120},
    { 720, 240, -136},
    { 808, 208, -128},
    { 992, 240, -176},
    { 1080, 256, -184},
    { 1336, 296, -264},
    { 1400, 216, -120},
    { 1720, 336, -128},
    { 1312, 528, -192},
    { 1360, 336, -24},
    { 1440, 232, -24},
    { 1216, 224, 8},
    { 936, 248, -48},
    { 808, 168, -8},
    { 784, 144, 8},
    { 728, 136, -16},
    { 760, 208, 16},
    { 760, 120, 32},
    { 872, 80, 56},
    { 1048, 48, 16},
    { 1416, -40, 56},
    { 1568, 272, -240},
    { 1168, 288, -376},
    { 1320, 296, -352},
    // 32 seconds
    { 1408, 248, -264},
    { 1152, 144, -128},
    { 848, 248, -136},
    { 728, 240, -168},
    { 672, 152, -112},
    { 768, 256, -200},
    { 888, 264, -176},
    { 1016, 264, -176},
    { 1272, 296, -240},
    { 1448, 328, -160},
    { 1912, 328, -96},
    { 1456, 504, -200},
    { 1168, 256, -24},
    { 1328, 168, -72},
    { 1312, 152, -40},
    { 1040, 168, -16},
    { 816, 200, -16},
    { 752, 208, 0},
    { 784, 136, 56},
    { 776, 96, 80},
    { 784, 80, 72},
    { 848, 88, 24},
    { 1040, 128, 0},
    { 1176, 72, -24},
    { 1560, 152, -16},
    // 33 seconds
    { 1216, 352, -296},
    { 1232, 336, -400},
    { 1408, 312, -400},
    { 1240, 312, -232},
    { 928, 280, -176},
    { 752, 272, -168},
    { 680, 264, -112},
    { 680, 264, -64},
    { 872, 336, -104},
    { 1016, 472, -128},
    { 1144, 432, -152},
    { 1296, 448, -152},
    { 1512, 352, -104},
    { 1568, 448, -120},
    { 1112, 416, -120},
    { 1304, 400, -88},
    { 1400, 336, -96},
    { 1192, 224, 8},
    { 936, 216, -48},
    { 840, 216, -40},
    { 808, 200, 8},
    { 816, 152, 32},
    { 784, 128, 48},
    { 776, 128, 56},
    { 856, 128, 64},
    // 34 seconds
    { 1000, 200, -8},
    { 1232, 96, 24},
    { 1592, 360, -64},
    { 1216, 584, -312},
    { 1360, 608, -344},
    { 1416, 544, -240},
    { 1096, 136, -88},
    { 880, 240, -128},
    { 720, 320, -144},
    { 664, 312, -80},
    { 696, 328, -64},
    { 792, 304, -112},
    { 880, 328, -96},
    { 1056, 376, -152},
    { 1264, 456, -192},
    { 1304, 352, -88},
    { 1648, 552, -192},
    { 1184, 560, -184},
    { 1384, 440, -176},
    { 1496, 360, -112},
    { 1240, 224, 8},
    { 976, 224, -40},
    { 880, 240, -72},
    { 896, 160, 32},
    { 864, 120, 96},
    // 35 seconds
    { 760, 136, 32},
    { 664, 32, 16},
    { 664, -24, -8},
    { 800, 32, -32},
    { 1312, 224, 56},
    { 1728, 656, -120},
    { 1448, 800, -368},
    { 1592, 912, -264},
    { 1280, 640, -72},
    { 904, 352, -104},
    { 776, 344, -40},
    { 608, 280, 16},
    { 568, 296, 16},
    { 624, 240, -16},
    { 808, 288, -24},
    { 1000, 392, -112},
    { 1256, 528, -208},
    { 1432, 504, -192},
    { 1744, 648, -232},
    { 1248, 616, -256},
    { 1168, 520, -248},
    { 1248, 448, -208},
    { 1232, 336, -80},
    { 976, 280, -8},
    { 808, 288, -8},
    // 36 seconds
    { 744, 256, 64},
    { 720, 216, 160},
    { 824, 232, 192},
    { 880, 248, 128},
    { 904, 144, 144},
    { 1016, 104, 128},
    { 1112, 32, 152},
    { 1696, 216, 200},
    { 1224, 632, -96},
    { 1096, 712, -304},
    { 1304, 728, -384},
    { 1256, 528, -248},
    { 968, 336, -136},
    { 744, 296, -32},
    { 720, 328, 0},
    { 744, 296, -40},
    { 784, 224, -40},
    { 824, 312, -48},
    { 904, 304, -64},
    { 1184, 408, -88},
    { 1280, 384, -72},
    { 1808, 456, -96},
    { 1328, 544, -240},
    { 1232, 440, -128},
    { 1408, 376, -112},
    // 37 seconds
    { 1368, 280, -56},
    { 1056, 360, -72},
    { 832, 256, -88},
    { 784, 160, -32},
    { 784, 88, 40},
    { 784, 64, 48},
    { 784, 144, 24},
    { 824, 88, 32},
    { 976, 128, 48},
    { 1056, 24, 32},
    { 1496, 56, 24},
    { 1360, 296, -288},
    { 1176, 328, -336},
    { 1472, 640, -464},
    { 1336, 256, -200},
    { 1016, 120, -168},
    { 784, 184, -136},
    { 760, 256, -176},
    { 744, 160, -112},
    { 888, 224, -176},
    { 960, 208, -200},
    { 1040, 184, -200},
    { 1184, 176, -176},
    { 1312, 184, -80},
    { 1808, 224, -88},
    // 38 seconds
    { 1456, 504, -208},
    { 1232, 432, -128},
    { 1432, 336, -80},
    { 1416, 160, -40},
    { 1088, 152, -32},
    { 832, 168, -40},
    { 768, 232, -40},
    { 752, 160, 0},
    { 784, 240, 16},
    { 752, 80, 80},
    { 808, 56, 8},
    { 936, 104, 56},
    { 1080, 120, -16},
    { 1272, 0, -48},
    { 1416, 136, -192},
    { 1216, 232, -176},
    { 1408, 304, -328},
    { 1480, 272, -328},
    { 1128, 312, -256},
    { 800, 336, -200},
    { 712, 280, -184},
    { 744, 280, -136},
    { 848, 256, -144},
    { 960, 304, -160},
    { 1056, 368, -176},
    // 39 seconds
    { 1256, 368, -168},
    { 1360, 384, -176},
    { 1840, 312, -80},
    { 1360, 432, -264},
    { 1152, 344, -136},
    { 1464, 200, -56},
    { 1424, 184, 72},
    { 1176, 224, 32},
    { 896, 224, -24},
    { 768, 208, -8},
    { 752, 136, 16},
    { 728, 80, 40},
    { 704, 40, 16},
    { 720, 80, 16},
    { 856, 112, 24},
    { 992, 104, 0},
    { 1488, 96, 56},
    { 1512, 312, -344},
    { 1440, 296, -440},
    { 1664, 440, -336},
    { 1344, 288, -96},
    { 1008, 168, -8},
    { 832, 152, -72},
    { 672, 256, -96},
    { 616, 248, -144},
    // 40 seconds
    { 744, 240, -152},
    { 920, 256, -136},
    { 1176, 336, -168},
    { 1400, 384, -216},
    { 1456, 360, -152},
    { 1544, 184, -32},
    { 1544, 344, -192},
    { 1160, 328, -56},
    { 1432, 216, 8},
    { 1408, 208, 16},
    { 1176, 184, 32},
    { 880, 232, 32},
    { 768, 208, 16},
    { 760, 144, 64},
    { 776, 144, 88},
    { 728, 112, 72},
    { 744, 112, 16},
    { 888, 112, 48},
    { 1032, 104, 0},
    { 1352, 32, -16},
    { 1656, 248, -200},
    { 1256, 360, -336},
    { 1352, 392, -392},
    { 1456, 448, -320},
    { 1120, 264, -144},
    // 41 seconds
    { 800, 224, -144},
    { 720, 320, -128},
    { 728, 248, -104},
    { 824, 240, -144},
    { 928, 304, -144},
    { 1016, 352, -144},
    { 1208, 328, -136},
    { 1352, 376, -128},
    { 1816, 280, 24},
    { 1480, 448, -176},
    { 1224, 344, -48},
    { 1416, 256, 0},
    { 1408, 200, 8},
    { 1112, 224, -24},
    { 872, 216, -16},
    { 760, 176, -8},
    { 768, 144, 32},
    { 760, 88, 80},
    { 736, 56, 80},
    { 808, 152, 16},
    { 904, 184, -32},
    { 1048, 120, -32},
    { 1464, 296, -128},
    { 1208, 304, -448},
    { 1200, 368, -560},
    // 42 seconds
    { 1440, 376, -536},
    { 1400, 312, -320},
    { 1096, 352, -240},
    { 832, 352, -184},
    { 712, 248, -144},
    { 672, 208, -120},
    { 752, 152, -112},
    { 880, 256, -168},
    { 976, 280, -128},
    { 1248, 328, -200},
    { 1408, 360, -160},
    { 1920, 376, -144},
    { 1400, 416, -208},
    { 1192, 432, -160},
    { 1408, 320, -152},
    { 1336, 192, -96},
    { 1072, 248, -80},
    { 832, 200, -48},
    { 776, 216, -32},
    { 736, 160, 32},
    { 712, 128, 56},
    { 688, 152, 32},
    { 728, 88, 32},
    { 952, 80, -40},
    { 1192, 88, -48},
    // 43 seconds
    { 1632, 200, -128},
    { 1312, 336, -416},
    { 1312, 336, -496},
    { 1488, 304, -400},
    { 1328, 144, -128},
    { 920, 192, -72},
    { 752, 192, -64},
    { 680, 200, -80},
    { 688, 232, -88},
    { 776, 248, -112},
    { 896, 320, -152},
    { 992, 288, -104},
    { 1304, 360, -184},
    { 1488, 232, -32},
    { 1848, 408, -144},
    { 1320, 448, -160},
    { 1304, 368, -144},
    { 1344, 248, -72},
    { 1296, 192, -40},
    { 976, 232, -64},
    { 800, 232, -64},
    { 736, 184, -48},
    { 720, 160, -32},
    { 720, 120, -16},
    { 728, 96, 0},
    // 44 seconds
    { 840, 136, 16},
    { 1008, 160, 48},
    { 1128, 208, -32},
    { 1680, 144, -72},
    { 1400, 336, -328},
    { 1192, 352, -328},
    { 1312, 440, -368},
    { 1248, 256, -208},
    { 984, 272, -144},
    { 752, 304, -96},
    { 712, 216, -96},
    { 752, 304, -144},
    { 880, 272, -144},
    { 944, 272, -120},
    { 1024, 304, -88},
    { 1224, 312, -200},
    { 1368, 192, -72},
    { 1792, 384, -216},
    { 1368, 488, -248},
    { 1304, 344, -192},
    { 1384, 248, -152},
    { 1296, 224, -80},
    { 1008, 216, -48},
    { 848, 184, -16},
    { 776, 136, 16},
    // 45 seconds
    { 760, 184, -40},
    { 744, 136, 56},
    { 752, 152, -8},
    { 776, 104, 56},
    { 944, 144, 32},
    { 1040, 176, -16},
    { 1488, 184, -40},
    { 1448, 424, -192},
    { 1144, 528, -384},
    { 1384, 704, -448},
    { 1304, 528, -200},
    { 1040, 368, -144},
    { 800, 360, -120},
    { 704, 328, -64},
    { 672, 328, -72},
    { 752, 312, -72},
    { 856, 360, -112},
    { 920, 360, -104},
    { 1136, 408, -144},
    { 1296, 448, -136},
    { 1480, 336, -48},
    { 1464, 488, -168},
    { 1112, 544, -184},
    { 1208, 448, -136},
    { 1392, 416, -152},
    // 46 seconds
    { 1240, 336, -64},
    { 936, 312, -32},
    { 800, 296, -40},
    { 800, 224, -24},
    { 816, 176, 0},
    { 824, 176, 8},
    { 832, 144, 0},
    { 872, 168, 24},
    { 1024, 128, 8},
    { 1136, 96, -16},
    { 1520, 192, -72},
    { 1264, 312, -264},
    { 1040, 344, -320},
    { 1328, 488, -376},
    { 1384, 344, -232},
    { 1096, 224, -144},
    { 816, 296, -136},
    { 720, 336, -160},
    { 688, 264, -112},
    { 792, 272, -168},
    { 904, 328, -168},
    { 1008, 336, -136},
    { 1256, 384, -184},
    { 1336, 384, -200},
    { 1744, 304, -72},
    // 47 seconds
    { 1488, 440, -168},
    { 1144, 360, -144},
    { 1352, 264, -96},
    { 1424, 200, -80},
    { 1184, 184, -24},
    { 944, 192, -48},
    { 840, 176, -32},
    { 808, 128, 16},
    { 760, 80, 24},
    { 736, 88, -8},
    { 680, 88, -8},
    { 792, 80, 16},
    { 984, 168, -56},
    { 1224, 72, -72},
    { 1640, 240, -168},
    { 1280, 352, -360},
    { 1256, 408, -440},
    { 1400, 440, -384},
    { 1232, 200, -216},
    { 952, 296, -240},
    { 776, 256, -192},
    { 712, 192, -128},
    { 824, 328, -248},
    { 904, 256, -208},
    { 968, 256, -216},
    // 48 seconds
    { 1128, 376, -312},
    { 1264, 304, -256},
    { 1448, 184, -136},
    { 1664, 384, -256},
    { 1240, 344, -176},
    { 1336, 296, -144},
    { 1456, 256, -168},
    { 1264, 192, -88},
    { 984, 240, -80},
    { 800, 208, -96},
    { 768, 184, -80},
    { 752, 152, -48},
    { 752, 120, -32},
    { 728, 144, -56},
    { 768, 112, -72},
    { 920, 104, -112},
    { 1264, -24, -72},
    { 1528, 248, -248},
    { 1128, 384, -472},
    { 1240, 488, -544},
    { 1384, 560, -416},
    { 1224, 288, -176},
    { 976, 376, -192},
    { 752, 312, -160},
    { 672, 272, -176},
    // 49 seconds
    { 696, 264, -160},
    { 816, 312, -176},
    { 928, 376, -208},
    { 1104, 456, -296},
    { 1296, 472, -296},
    { 1560, 360, -216},
    { 1584, 512, -280},
    { 1120, 456, -216},
    { 1248, 384, -208},
    { 1360, 328, -208},
    { 1240, 264, -120},
    { 976, 280, -96},
    { 848, 264, -120},
    { 824, 192, -64},
    { 808, 152, -32},
    { 792, 152, -32},
    { 744, 120, -32},
    { 776, 64, -24},
    { 936, 128, -96},
    { 1152, 88, -96},
    { 1504, 320, -248},
    { 1120, 384, -400},
    { 1152, 440, -488},
    { 1352, 536, -480},
    { 1256, 368, -256},
    // 50 seconds
    { 984, 376, -192},
    { 784, 344, -176},
    { 728, 272, -144},
    { 760, 304, -152},
    { 840, 328, -176},
    { 928, 344, -120},
    { 1088, 392, -144},
    { 1344, 480, -200},
    { 1424, 360, -120},
    { 1808, 464, -208},
    { 1272, 416, -192},
    { 1288, 328, -120},
    { 1464, 264, -152},
    { 1352, 160, -64},
    { 1048, 216, -64},
    { 848, 216, -56},
    { 776, 176, -64},
    { 736, 152, -8},
    { 688, 128, 24},
    { 664, 136, -8},
    { 680, 56, 16},
    { 856, 104, -32},
    { 1016, 168, -96},
    { 1528, 176, -120},
    { 1536, 384, -312},
    // 51 seconds
    { 1232, 432, -424},
    { 1456, 504, -576},
    { 1400, 184, -304},
    { 1128, 312, -248},
    { 848, 384, -200},
    { 704, 280, -168},
    { 640, 208, -144},
    { 792, 304, -208},
    { 880, 312, -168},
    { 1008, 360, -144},
    { 1216, 488, -216},
    { 1312, 496, -128},
    { 1672, 408, -56},
    { 1432, 488, -112},
    { 1056, 416, -88},
    { 1320, 392, -128},
    { 1392, 328, -88},
    { 1184, 256, -24},
    { 960, 240, -32},
    { 864, 248, -56},
    { 816, 176, -8},
    { 768, 176, 0},
    { 744, 192, -16},
    { 712, 88, 32},
    { 864, 96, 16},
    // 52 seconds
    { 1248, 48, 40},
    { 1560, 280, -88},
    { 1184, 336, -368},
    { 1208, 496, -528},
    { 1256, 568, -472},
    { 1296, 184, -96},
    { 1144, 248, -80},
    { 896, 224, -104},
    { 744, 176, -104},
    { 680, 176, -88},
    { 760, 248, -144},
    { 864, 280, -152},
    { 976, 336, -144},
    { 1256, 456, -216},
    { 1456, 440, -80},
    { 2024, 624, -120},
    { 1232, 576, -88},
    { 1296, 448, -72},
    { 1456, 344, -64},
    { 1296, 288, -8},
    { 1040, 224, 8},
    { 936, 240, -16},
    { 880, 176, 32},
    { 824, 152, 40},
    { 784, 104, 64},
    // 53 seconds
    { 736, 80, 64},
    { 816, 72, 24},
    { 960, 136, -32},
    { 1328, -16, 88},
    { 1352, 320, -192},
    { 1056, 280, -472},
    { 1392, 376, -632},
    { 1432, 304, -392},
    { 1224, 288, -296},
    { 960, 376, -288},
    { 816, 336, -232},
    { 704, 296, -120},
    { 696, 240, -88},
    { 784, 296, -120},
    { 824, 288, -152},
    { 1088, 368, -168},
    { 1352, 488, -216},
    { 1352, 392, -136},
    { 1696, 680, -296},
    { 1200, 552, -248},
    { 1208, 416, -144},
    { 1424, 368, -160},
    { 1312, 240, 24},
    { 1016, 272, -24},
    { 864, 248, -64},
    // 54 seconds
    { 832, 184, -24},
    { 816, 160, 16},
    { 760, 128, 16},
    { 720, 104, 0},
    { 768, 48, 32},
    { 960, 112, -24},
    { 1280, 24, -16},
    { 1504, 256, -192},
    { 1200, 384, -384},
    { 1416, 528, -560},
    { 1392, 528, -400},
    { 1216, 432, -280},
    { 952, 360, -248},
    { 768, 296, -184},
    { 632, 248, -152},
    { 632, 216, -160},
    { 720, 240, -160},
    { 872, 264, -176},
    { 1112, 384, -264},
    { 1432, 656, -296},
    { 1712, 480, -160},
    { 1600, 520, -232},
    { 1136, 480, -256},
    { 1264, 416, -176},
    { 1344, 296, -96},
    // 55 seconds
    { 1176, 224, -48},
    { 928, 232, -24},
    { 816, 248, -16},
    { 808, 192, 48},
    { 800, 144, 80},
    { 720, 128, 72},
    { 688, 104, 24},
    { 824, 96, 40},
    { 1040, 72, 0},
    { 1272, 32, -112},
    { 1640, 256, -256},
    { 1240, 376, -432},
    { 1312, 520, -528},
    { 1448, 584, -424},
    { 1168, 384, -216},
    { 928, 496, -184},
    { 744, 360, -96},
    { 696, 264, -24},
    { 680, 272, -88},
    { 752, 304, -80},
    { 816, 360, -80},
    { 1064, 424, -136},
    { 1288, 472, -152},
    { 1552, 416, -96},
    { 1584, 632, -248},
    // 56 seconds
    { 1096, 520, -168},
    { 1352, 512, -184},
    { 1432, 432, -112},
    { 1192, 304, -48},
    { 928, 288, -64},
    { 872, 272, -64},
    { 880, 208, 24},
    { 848, 176, 40},
    { 760, 120, 48},
    { 672, 104, 48},
    { 672, 120, 32},
    { 832, 136, -16},
    { 968, 192, -184},
    { 1480, 160, -168},
    { 1568, 472, -384},
    { 1336, 520, -368},
    { 1520, 672, -496},
    { 1344, 496, -176},
    { 976, 424, -56},
    { 768, 464, -32},
    { 664, 408, -16},
    { 608, 352, 8},
    { 736, 384, -8},
    { 848, 432, -16},
    { 1008, 504, -32},
    // 57 seconds
    { 1232, 584, -120},
    { 1200, 504, -112},
    { 1392, 336, -88},
    { 1536, 632, -256},
    { 1096, 504, -136},
    { 1448, 472, -272},
    { 1664, 304, -184},
    { 1328, 200, -80},
    { 1024, 280, -168},
    { 896, 256, -136},
    { 824, 144, -48},
    { 688, 80, -32},
    { 552, 56, -32},
    { 488, 64, -8},
    { 560, 96, -24},
    { 744, 128, -48},
    { 912, 216, -168},
    { 1672, 224, -160},
    { 1864, 672, -168},
    { 1456, 696, -264},
    { 1408, 856, -384},
    { 1216, 464, -32},
    { 896, 344, -8},
    { 728, 368, -32},
    { 624, 360, 24},
    // 58 seconds
    { 624, 400, 24},
    { 752, 472, -48},
    { 920, 488, -48},
    { 1112, 632, -104},
    { 1336, 688, -104},
    { 1200, 552, -40},
    { 1712, 560, -176},
    { 1384, 616, -184},
    { 1320, 544, -104},
    { 1632, 472, -200},
    { 1536, 264, -64},
    { 1224, 224, -104},
    { 1008, 208, -120},
    { 912, 128, -88},
    { 784, 88, -64},
    { 640, 112, -72},
    { 520, 48, -24},
    { 528, 40, -24},
    { 736, 144, -40},
    { 944, 256, -72},
    { 1488, 248, 16},
    { 1640, 552, -168},
    { 1408, 616, -296},
    { 1616, 824, -400},
    { 1360, 600, -96},
    // 59 seconds
    { 992, 320, -64},
    { 840, 328, -40},
    { 688, 312, 16},
    { 608, 336, 64},
    { 688, 384, 40},
    { 800, 368, 48},
    { 904, 432, -88},
    { 1104, 432, -112},
    { 1320, 496, -184},
    { 1336, 488, -144},
    { 1552, 592, -192},
    { 1272, 624, -216},
    { 1056, 544, -224},
    { 1336, 456, -224},
    { 1432, 352, -120},
    { 1216, 272, -32},
    { 984, 264, -56},
    { 904, 272, -8},
    { 856, 232, 8},
    { 776, 152, 32},
    { 728, 136, 64},
    { 648, 96, 48},
    { 744, 104, 64},
    { 952, 152, 8},
    { 1216, 152, -8},
    // 60 seconds
    // elapsed: 1 minutes
    { 1680, 344, 40},
    { 1280, 536, -248},
    { 1272, 688, -448},
    { 1344, 776, -376},
    { 1224, 432, -56},
    { 1008, 400, -56},
    { 824, 352, -40},
    { 696, 312, 24},
    { 664, 312, -24},
    { 792, 336, -56},
    { 912, 328, -64},
    { 968, 376, -80},
    { 1144, 384, -160},
    { 1264, 384, -144},
    { 1680, 400, -104},
    { 1528, 472, -120},
    { 1168, 480, -136},
    { 1288, 416, -136},
    { 1264, 320, -80},
    { 1104, 256, -16},
    { 912, 256, -8},
    { 864, 272, -40},
    { 840, 208, 24},
    { 808, 176, 40},
    { 768, 168, 32},
    // 61 seconds
    { 736, 152, 48},
    { 816, 144, 40},
    { 984, 176, 8},
    { 1048, 184, -48},
    { 1520, 192, -8},
    { 1488, 488, -200},
    { 1016, 520, -232},
    { 1216, 688, -392},
    { 1272, 504, -160},
    { 1064, 368, -56},
    { 848, 456, -48},
    { 752, 440, -32},
    { 736, 400, -8},
    { 840, 432, -40},
    { 896, 464, -16},
    { 928, 512, -88},
    { 1088, 456, -96},
    { 1232, 440, -88},
    { 1216, 336, 8},
    { 1584, 544, -112},
    { 1328, 528, -112},
    { 1152, 440, -64},
    { 1360, 408, -96},
    { 1344, 328, -8},
    { 1096, 320, -16},
    // 62 seconds
    { 960, 336, -8},
    { 896, 288, -24},
    { 872, 216, 24},
    { 784, 136, 72},
    { 664, 128, 48},
    { 632, 136, 8},
    { 736, 96, -32},
    { 912, 136, -88},
    { 1208, 64, -32},
    { 1824, 344, -216},
    { 1328, 464, -424},
    { 1104, 488, -456},
    { 1400, 656, -400},
    { 1312, 424, -136},
    { 1088, 408, -88},
    { 872, 328, -40},
    { 736, 352, 0},
    { 736, 416, -24},
    { 784, 432, -8},
    { 824, 440, -16},
    { 896, 368, -40},
    { 1008, 376, -24},
    { 1096, 528, -24},
    { 1104, 568, 0},
    { 1528, 528, 56},
    // 63 seconds
    { 1640, 528, 152},
    { 1032, 648, 168},
    { 968, 536, 136},
    { 1208, 360, 336},
    { 1192, 472, 408},
    { 1080, 480, 408},
    { 1064, 712, 416},
    { 1104, 608, 496},
    { 1040, 632, 432},
    { 1088, 656, 168},
    { 1096, 584, -24},
    { 1128, 248, -272},
    { 920, 96, -368},
    { 952, 216, -640},
    { 640, 104, -512},
    { 552, 64, -560},
    { 512, 104, -816},
    { 448, 72, -768},
    { 416, 272, -880},
    { 320, 160, -880},
    { 256, 80, -864},
    { 184, 120, -864},
    { 168, 216, -1016},
    { 208, 144, -1016},
    { 200, 216, -1056},
    // 64 seconds
    { 200, 336, -1128},
    { 208, 232, -1120},
    { 176, 72, -936},
    { 144, 224, -808},
    { 192, 112, -648},
    { 288, 384, -744},
    { 248, 464, -592},
    { 256, 520, -592},
    { 200, 552, -576},
    { 88, 568, -488},
    { 120, 872, -744},
    { 152, 640, -656},
    { 136, 832, -496},
    { 112, 864, -488},
    { 232, 920, -552},
    { 80, 976, -320},
    { 104, 1144, -432},
    { 96, 1144, -384},
    { 208, 1040, -512},
    { 200, 552, -520},
    { 320, 528, -712},
    { 224, 464, -720},
    { 336, 80, -840},
    { 264, 328, -712},
    { 248, 384, -784},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:44:04 local
AccelRawData *activity_sample_walk_100_pbl_25666_2(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25666_2
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 432, 368, -848},
    { 448, 352, -864},
    { 424, 328, -856},
    { 416, 328, -840},
    { 408, 336, -848},
    { 400, 336, -856},
    { 408, 336, -856},
    { 440, 360, -896},
    { 448, 376, -912},
    { 440, 384, -904},
    { 432, 376, -872},
    { 424, 368, -840},
    { 400, 352, -832},
    { 424, 344, -848},
    { 432, 344, -856},
    { 440, 344, -888},
    { 424, 336, -880},
    { 424, 312, -864},
    { 416, 296, -864},
    { 408, 280, -832},
    { 408, 272, -856},
    { 400, 272, -856},
    { 408, 272, -872},
    { 408, 264, -872},
    { 400, 272, -888},
    // 1 seconds
    { 408, 288, -896},
    { 408, 296, -888},
    { 408, 296, -904},
    { 416, 288, -888},
    { 400, 288, -896},
    { 400, 304, -888},
    { 392, 296, -888},
    { 400, 296, -880},
    { 416, 304, -864},
    { 384, 304, -904},
    { 408, 296, -880},
    { 408, 296, -888},
    { 408, 328, -904},
    { 440, 280, -896},
    { 408, 360, -904},
    { 424, 312, -848},
    { 352, 248, -864},
    { 360, 272, -888},
    { 312, 288, -920},
    { 248, 216, -840},
    { 888, 376, -1168},
    { 48, -272, -816},
    { 440, 216, -856},
    { 464, 368, -904},
    { 448, 264, -864},
    // 2 seconds
    { 448, 184, -808},
    { 504, 208, -752},
    { 560, 280, -648},
    { 568, 432, -544},
    { 536, 608, -424},
    { 528, 768, -280},
    { 552, 920, -144},
    { 440, 976, -32},
    { 304, 960, 0},
    { 272, 992, 176},
    { 248, 1048, 256},
    { 248, 1024, 368},
    { 232, 1080, 376},
    { 272, 1024, 536},
    { 320, 976, 528},
    { 312, 952, 704},
    { 456, 1176, 872},
    { 456, 1136, 792},
    { 408, 912, 624},
    { 416, 776, 592},
    { 464, 760, 616},
    { 440, 680, 544},
    { 376, 544, 456},
    { 352, 520, 424},
    { 376, 512, 496},
    // 3 seconds
    { 336, 544, 464},
    { 336, 592, 576},
    { 288, 680, 600},
    { 400, 864, 760},
    { 488, 920, 1000},
    { 456, 1128, 1032},
    { 288, 1064, 776},
    { 392, 992, 720},
    { 432, 792, 632},
    { 416, 584, 520},
    { 344, 536, 488},
    { 280, 464, 408},
    { 176, 568, 424},
    { 128, 560, 376},
    { 88, 856, 480},
    { 88, 1000, 448},
    { 8, 904, 272},
    { 40, 984, 344},
    { 32, 1128, 536},
    { 400, 1272, 472},
    { 224, 1048, 488},
    { 240, 992, 472},
    { 256, 888, 472},
    { 248, 832, 352},
    { 184, 664, 232},
    // 4 seconds
    { 168, 584, 256},
    { 152, 688, 288},
    { 184, 800, 328},
    { 200, 864, 432},
    { 272, 960, 464},
    { 288, 1032, 480},
    { 368, 1176, 728},
    { 360, 1336, 424},
    { 240, 960, 400},
    { 312, 864, 312},
    { 352, 864, 424},
    { 264, 864, 304},
    { 184, 704, 216},
    { 128, 648, 168},
    { 88, 728, 208},
    { 152, 856, 256},
    { 136, 968, 232},
    { 104, 1024, 224},
    { 176, 1064, 224},
    { 120, 1096, 392},
    { 368, 1304, 496},
    { 240, 1040, 456},
    { 224, 1016, 464},
    { 288, 904, 432},
    { 376, 920, 432},
    // 5 seconds
    { 296, 808, 288},
    { 248, 720, 200},
    { 216, 640, 240},
    { 192, 712, 184},
    { 176, 832, 256},
    { 168, 864, 344},
    { 256, 1056, 432},
    { 248, 1096, 496},
    { 504, 1296, 688},
    { 296, 1104, 344},
    { 264, 920, 400},
    { 360, 840, 408},
    { 320, 864, 440},
    { 256, 720, 360},
    { 112, 592, 296},
    { 56, 624, 320},
    { 64, 736, 408},
    { 104, 872, 480},
    { 80, 920, 504},
    { 88, 968, 504},
    { 152, 1000, 528},
    { 168, 1112, 832},
    { 384, 1176, 752},
    { 200, 888, 552},
    { 176, 864, 632},
    // 6 seconds
    { 232, 928, 680},
    { 280, 856, 544},
    { 296, 688, 440},
    { 232, 528, 336},
    { 208, 480, 296},
    { 248, 536, 384},
    { 240, 608, 392},
    { 280, 656, 480},
    { 400, 752, 640},
    { 416, 904, 688},
    { 536, 1000, 912},
    { 656, 1216, 768},
    { 504, 984, 584},
    { 632, 856, 624},
    { 648, 704, 528},
    { 520, 536, 344},
    { 368, 472, 184},
    { 376, 392, 184},
    { 392, 400, 232},
    { 504, 352, 384},
    { 664, 496, 416},
    { 800, 456, 416},
    { 1144, 512, 504},
    { 1864, 568, 864},
    { 1648, 872, 1024},
    // 7 seconds
    { 1072, 832, 816},
    { 1096, 640, 648},
    { 1008, 480, 640},
    { 712, 384, 520},
    { 512, 424, 528},
    { 552, 392, 560},
    { 664, 368, 664},
    { 864, 448, 808},
    { 824, 320, 744},
    { 888, 600, 688},
    { 944, 568, 696},
    { 1008, 720, 416},
    { 1136, 960, 592},
    { 936, 1072, 184},
    { 832, 872, 64},
    { 824, 816, -176},
    { 720, 512, -104},
    { 608, 456, -120},
    { 512, 568, -208},
    { 360, 304, -200},
    { 344, 336, -296},
    { 424, 488, -488},
    { 416, 768, -464},
    { 464, 736, -400},
    { 464, 936, -352},
    // 8 seconds
    { 600, 1120, -8},
    { 688, 1576, -144},
    { 392, 1128, 96},
    { 472, 872, 32},
    { 400, 912, 160},
    { 424, 944, 88},
    { 384, 784, 80},
    { 288, 552, 96},
    { 312, 512, 32},
    { 376, 464, 24},
    { 520, 624, 160},
    { 728, 592, 280},
    { 880, 224, 192},
    { 1104, 88, 640},
    { 1528, -32, 1088},
    { 2016, 776, 920},
    { 1416, 1144, 480},
    { 1392, 288, 560},
    { 1232, 488, 592},
    { 960, 424, 328},
    { 808, 520, 232},
    { 688, 552, 192},
    { 576, 528, 160},
    { 688, 512, 184},
    { 880, 656, 136},
    // 9 seconds
    { 1032, 712, 216},
    { 1400, 848, 160},
    { 1792, 536, 344},
    { 1880, 520, 400},
    { 1424, 416, 416},
    { 1648, 368, 264},
    { 1536, -232, 368},
    { 1088, 168, 416},
    { 864, 224, 328},
    { 664, 184, 184},
    { 600, 144, 184},
    { 600, 72, 224},
    { 640, 48, 216},
    { 688, 40, 224},
    { 920, 72, 280},
    { 1144, 176, 344},
    { 1664, 232, 416},
    { 1904, 584, 456},
    { 1456, 1184, 80},
    { 1288, 1000, 0},
    { 1224, 320, 344},
    { 1056, 184, 240},
    { 808, 288, 112},
    { 664, 424, 8},
    { 600, 512, -48},
    // 10 seconds
    { 760, 544, -8},
    { 896, 512, 40},
    { 1016, 464, 152},
    { 1232, 592, 96},
    { 1472, 552, 216},
    { 2008, 544, 296},
    { 1336, 456, 384},
    { 1432, 296, 320},
    { 1352, 200, 336},
    { 1184, 304, 336},
    { 952, 296, 296},
    { 728, 208, 232},
    { 680, 192, 208},
    { 720, 144, 216},
    { 672, 104, 224},
    { 664, 72, 216},
    { 800, 96, 232},
    { 952, 168, 248},
    { 1464, 168, 336},
    { 1784, 504, 448},
    { 1544, 1048, 128},
    { 1368, 976, -16},
    { 1136, 304, 296},
    { 968, 64, 176},
    { 792, 416, 8},
    // 11 seconds
    { 608, 480, 48},
    { 664, 520, 80},
    { 648, 424, -96},
    { 800, 456, 120},
    { 1040, 464, 216},
    { 1368, 704, 216},
    { 1480, 648, 360},
    { 1808, 592, 328},
    { 1224, 480, 264},
    { 1176, 400, 216},
    { 1328, 544, 352},
    { 1304, 240, 368},
    { 960, 208, 320},
    { 760, 248, 200},
    { 664, 208, 184},
    { 672, 168, 216},
    { 648, 104, 208},
    { 632, 80, 216},
    { 696, 88, 224},
    { 952, 160, 256},
    { 1216, 144, 368},
    { 1936, 360, 520},
    { 1472, 904, 264},
    { 1424, 1200, -120},
    { 1288, 544, 312},
    // 12 seconds
    { 1112, 80, 280},
    { 936, 328, 32},
    { 704, 456, 40},
    { 664, 440, 0},
    { 632, 448, -248},
    { 688, 336, -8},
    { 944, 392, 144},
    { 1144, 496, 216},
    { 1328, 600, 248},
    { 1640, 448, 376},
    { 1568, 672, 272},
    { 1176, 440, 288},
    { 1472, 336, 256},
    { 1384, 328, 368},
    { 1024, 352, 288},
    { 800, 272, 160},
    { 704, 232, 152},
    { 728, 160, 184},
    { 672, 96, 184},
    { 656, 48, 168},
    { 664, 40, 184},
    { 840, 120, 232},
    { 984, 136, 280},
    { 1840, 168, 496},
    { 1616, 800, 384},
    // 13 seconds
    { 1648, 1320, -176},
    { 1352, 808, 240},
    { 1040, 200, 312},
    { 792, 64, 168},
    { 760, 160, 56},
    { 656, 120, -120},
    { 680, 544, -160},
    { 840, 592, -56},
    { 952, 568, 104},
    { 1192, 488, 176},
    { 1424, 680, 184},
    { 1880, 696, 280},
    { 1336, 568, 232},
    { 1376, 400, 240},
    { 1528, 408, 264},
    { 1424, 320, 296},
    { 992, 328, 264},
    { 808, 240, 160},
    { 704, 176, 160},
    { 744, 152, 200},
    { 672, 80, 208},
    { 616, 40, 192},
    { 664, 40, 208},
    { 832, 96, 272},
    { 1184, 64, 368},
    // 14 seconds
    { 1784, 352, 520},
    { 1536, 984, 80},
    { 1568, 1344, -352},
    { 1328, 544, 488},
    { 1072, -8, 168},
    { 888, -168, 56},
    { 600, 600, 88},
    { 624, 560, 32},
    { 768, 808, 32},
    { 704, 400, 56},
    { 960, 488, 40},
    { 1296, 712, 32},
    { 1544, 704, 344},
    { 2008, 696, 424},
    { 1280, 464, 264},
    { 1288, 280, 176},
    { 1472, 296, 256},
    { 1272, 400, 352},
    { 936, 352, 264},
    { 768, 240, 152},
    { 704, 160, 184},
    { 728, 120, 216},
    { 696, 72, 216},
    { 632, 48, 216},
    { 712, 80, 208},
    // 15 seconds
    { 880, 112, 248},
    { 1112, 32, 336},
    { 1800, 336, 448},
    { 1608, 960, 112},
    { 1640, 1344, -296},
    { 1328, 680, 448},
    { 1128, -136, 256},
    { 864, 304, 64},
    { 784, 288, 24},
    { 696, 432, -48},
    { 744, 616, -120},
    { 792, 560, 8},
    { 928, 488, 96},
    { 1192, 464, 80},
    { 1416, 536, 232},
    { 1968, 568, 328},
    { 1440, 560, 376},
    { 1288, 344, 240},
    { 1424, 336, 296},
    { 1280, 312, 336},
    { 1008, 304, 280},
    { 768, 216, 208},
    { 648, 176, 192},
    { 640, 136, 208},
    { 632, 88, 200},
    // 16 seconds
    { 600, 56, 216},
    { 720, 88, 216},
    { 904, 136, 256},
    { 1112, 160, 320},
    { 1888, 280, 464},
    { 1640, 824, 288},
    { 1528, 1064, -96},
    { 1320, 784, 96},
    { 1160, 312, 248},
    { 992, -72, 64},
    { 760, 336, 24},
    { 680, 280, 24},
    { 688, 416, -104},
    { 792, 480, 24},
    { 928, 464, 88},
    { 1000, 400, 104},
    { 1256, 504, 120},
    { 1344, 432, 288},
    { 1848, 536, 304},
    { 1152, 520, 328},
    { 1312, 384, 208},
    { 1400, 408, 224},
    { 1184, 392, 304},
    { 920, 280, 240},
    { 768, 264, 184},
    // 17 seconds
    { 768, 224, 216},
    { 792, 160, 232},
    { 760, 136, 224},
    { 744, 112, 216},
    { 792, 112, 232},
    { 952, 136, 272},
    { 1256, 104, 320},
    { 1600, 432, 336},
    { 1336, 872, 8},
    { 1528, 960, -144},
    { 1384, 496, 336},
    { 1040, -40, 240},
    { 840, 96, 0},
    { 640, 432, 56},
    { 632, 496, 56},
    { 704, 576, 0},
    { 752, 528, 64},
    { 936, 488, 112},
    { 1256, 632, 88},
    { 1352, 640, 232},
    { 1920, 408, 240},
    { 1368, 456, 168},
    { 1328, 304, 192},
    { 1512, 224, 192},
    { 1344, 296, 304},
    // 18 seconds
    { 1056, 368, 216},
    { 824, 304, 120},
    { 744, 208, 144},
    { 760, 160, 200},
    { 720, 104, 200},
    { 664, 64, 184},
    { 616, 80, 184},
    { 744, 120, 192},
    { 912, 64, 264},
    { 1656, 128, 448},
    { 1640, 712, 352},
    { 1848, 1360, -200},
    { 1432, 944, 320},
    { 1104, 72, 360},
    { 840, -24, 152},
    { 808, 168, 96},
    { 648, 368, 40},
    { 672, 560, 8},
    { 768, 704, -56},
    { 824, 488, 144},
    { 1080, 504, 104},
    { 1424, 584, 96},
    { 1720, 424, 344},
    { 1696, 576, 328},
    { 1176, 472, 256},
    // 19 seconds
    { 1264, 352, 104},
    { 1344, 304, 248},
    { 1152, 320, 240},
    { 856, 240, 264},
    { 768, 224, 216},
    { 720, 184, 232},
    { 744, 144, 240},
    { 728, 128, 248},
    { 760, 112, 256},
    { 856, 112, 296},
    { 1016, 176, 312},
    { 1456, 72, 424},
    { 1504, 440, 432},
    { 1336, 912, -40},
    { 1384, 1016, -232},
    { 1312, 288, 384},
    { 1024, -176, 232},
    { 728, 664, -64},
    { 560, 696, -80},
    { 824, 592, 72},
    { 672, 336, -32},
    { 824, 400, 40},
    { 976, 512, 96},
    { 1184, 592, 160},
    { 1544, 464, 408},
    // 20 seconds
    { 1880, 576, 432},
    { 1224, 504, 272},
    { 1272, 312, 160},
    { 1344, 304, 248},
    { 1248, 408, 304},
    { 960, 360, 248},
    { 784, 240, 184},
    { 736, 160, 200},
    { 752, 128, 224},
    { 720, 96, 200},
    { 688, 112, 176},
    { 760, 112, 192},
    { 920, 136, 256},
    { 1080, 72, 296},
    { 1608, 248, 376},
    { 1336, 752, 176},
    { 1528, 912, -152},
    { 1560, 576, 144},
    { 1176, 288, 240},
    { 816, 232, 112},
    { 776, 240, 24},
    { 688, 352, -32},
    { 744, 544, -64},
    { 832, 608, -32},
    { 904, 592, 24},
    // 21 seconds
    { 1168, 624, -16},
    { 1472, 568, 88},
    { 1784, 376, 272},
    { 1560, 376, 280},
    { 1200, 384, 224},
    { 1296, 352, 152},
    { 1448, 352, 200},
    { 1280, 384, 232},
    { 992, 232, 240},
    { 848, 152, 192},
    { 768, 128, 216},
    { 696, 96, 200},
    { 600, 104, 168},
    { 528, 96, 168},
    { 600, 88, 176},
    { 840, 96, 224},
    { 1096, 128, 312},
    { 1960, 368, 400},
    { 1808, 1104, 32},
    { 1400, 1288, -144},
    { 1320, 424, 312},
    { 1264, -120, 200},
    { 1040, 192, 152},
    { 800, 368, 104},
    { 664, 504, 16},
    // 22 seconds
    { 648, 544, -24},
    { 752, 560, -40},
    { 824, 392, 80},
    { 1064, 464, -16},
    { 1312, 472, 32},
    { 1368, 464, 160},
    { 1752, 328, 288},
    { 1592, 432, 288},
    { 944, 448, 208},
    { 1208, 296, 16},
    { 1304, 336, 184},
    { 1208, 304, 368},
    { 1008, 184, 328},
    { 904, 120, 288},
    { 824, 136, 288},
    { 768, 168, 264},
    { 672, 184, 232},
    { 640, 176, 184},
    { 704, 112, 232},
    { 864, 160, 232},
    { 904, 304, 128},
    { 1368, 400, 80},
    { 2144, 792, 176},
    { 1288, 904, 112},
    { 1032, 496, -48},
    // 23 seconds
    { 1240, -96, 56},
    { 1160, 296, 48},
    { 776, 728, 120},
    { 816, 632, 128},
    { 720, 456, 48},
    { 800, 464, 104},
    { 840, 480, 136},
    { 928, 512, 168},
    { 1048, 496, 272},
    { 1320, 368, 480},
    { 1456, 336, 592},
    { 1264, 464, 360},
    { 1112, 504, 328},
    { 1168, 552, 440},
    { 1088, 504, 520},
    { 952, 464, 432},
    { 856, 512, 464},
    { 824, 440, 336},
    { 680, 448, 256},
    { 680, 432, 272},
    { 688, 376, 232},
    { 752, 296, 208},
    { 856, 240, 208},
    { 1088, 264, 240},
    { 1440, 376, 248},
    // 24 seconds
    { 1832, 328, 416},
    { 1288, 696, 96},
    { 888, 800, -192},
    { 1056, 400, 32},
    { 1200, 216, 232},
    { 1192, 40, 176},
    { 928, 280, -160},
    { 768, 440, -216},
    { 776, 520, -104},
    { 760, 408, -32},
    { 800, 248, 72},
    { 1008, 256, 200},
    { 920, 240, 216},
    { 1056, 320, 152},
    { 1032, 320, 208},
    { 1136, 160, 304},
    { 1384, 520, 216},
    { 1640, 808, 184},
    { 1896, 920, 232},
    { 1712, 688, 576},
    { 1112, 200, 256},
    { 720, 144, 120},
    { 712, 192, 96},
    { 712, 272, 128},
    { 864, 336, 136},
    // 25 seconds
    { 984, 208, 112},
    { 1064, 24, 192},
    { 952, -32, 328},
    { 1008, 72, 312},
    { 1008, 184, 400},
    { 1392, 512, 32},
    { 1752, 712, -160},
    { 1504, 568, 176},
    { 880, 432, 256},
    { 568, 232, 136},
    { 704, 208, 64},
    { 896, 264, 8},
    { 992, 480, 40},
    { 1040, 616, 48},
    { 1080, 648, 64},
    { 1304, 736, 64},
    { 2136, 624, 160},
    { 1392, 600, 288},
    { 1752, 264, 304},
    { 1720, 208, 384},
    { 1528, 288, 344},
    { 1088, 384, 216},
    { 832, 264, 120},
    { 672, 160, 152},
    { 664, 72, 192},
    // 26 seconds
    { 560, -16, 184},
    { 480, -72, 152},
    { 560, -88, 168},
    { 784, -16, 264},
    { 1040, 88, 376},
    { 1888, 288, 536},
    { 2072, 920, 168},
    { 2104, 1632, -408},
    { 1392, 648, 688},
    { 936, -40, 240},
    { 800, -48, 112},
    { 704, 56, 112},
    { 640, 192, -136},
    { 648, 608, -8},
    { 696, 504, 24},
    { 936, 592, 128},
    { 1144, 472, 120},
    { 1560, 592, 120},
    { 2200, 784, 248},
    { 1432, 568, 368},
    { 1456, 296, 256},
    { 1480, 240, 288},
    { 1288, 312, 328},
    { 944, 336, 200},
    { 736, 256, 104},
    // 27 seconds
    { 664, 192, 152},
    { 712, 136, 192},
    { 648, 40, 224},
    { 688, -8, 240},
    { 776, 8, 272},
    { 936, 112, 304},
    { 1144, 176, 344},
    { 1648, 376, 416},
    { 1632, 856, 56},
    { 1704, 1208, -160},
    { 1368, 496, 480},
    { 992, 24, 248},
    { 768, 32, 80},
    { 728, 88, -80},
    { 680, 48, -208},
    { 656, 840, -48},
    { 904, 552, 72},
    { 1024, 632, 168},
    { 1280, 632, 168},
    { 1504, 592, 352},
    { 1920, 544, 432},
    { 1248, 504, 336},
    { 1312, 416, 240},
    { 1528, 368, 160},
    { 1328, 256, 368},
    // 28 seconds
    { 968, 304, 280},
    { 768, 232, 184},
    { 680, 184, 192},
    { 688, 120, 224},
    { 648, 56, 216},
    { 600, 32, 200},
    { 672, 48, 232},
    { 896, 128, 264},
    { 1024, 168, 320},
    { 1800, 344, 448},
    { 1648, 704, 328},
    { 1760, 1200, 56},
    { 1368, 640, 408},
    { 1024, 240, 280},
    { 896, 48, 112},
    { 696, 608, 40},
    { 592, 432, 32},
    { 576, 448, -208},
    { 696, 600, -8},
    { 904, 472, 176},
    { 1136, 632, 216},
    { 1400, 624, 384},
    { 1880, 568, 376},
    { 1288, 592, 328},
    { 1344, 384, 160},
    // 29 seconds
    { 1520, 448, 272},
    { 1520, 456, 432},
    { 1144, 296, 368},
    { 904, 208, 208},
    { 760, 160, 184},
    { 744, 128, 208},
    { 616, 72, 184},
    { 536, 40, 168},
    { 496, 8, 144},
    { 632, 40, 176},
    { 760, 64, 208},
    { 1464, 208, 368},
    { 1864, 720, 312},
    { 1992, 1048, 32},
    { 1704, 816, 328},
    { 1120, 376, 168},
    { 816, 152, 112},
    { 760, 352, 88},
    { 696, 536, -32},
    { 640, 624, -32},
    { 688, 576, 8},
    { 832, 504, 96},
    { 1152, 584, 88},
    { 1416, 616, 280},
    { 2184, 584, 368},
    // 30 seconds
    { 1320, 520, 288},
    { 1384, 296, 232},
    { 1480, 320, 272},
    { 1384, 432, 344},
    { 1024, 336, 288},
    { 792, 224, 192},
    { 720, 160, 200},
    { 696, 128, 224},
    { 624, 104, 200},
    { 576, 88, 184},
    { 648, 64, 200},
    { 808, 88, 240},
    { 1024, 24, 336},
    { 1768, 336, 512},
    { 1696, 824, 272},
    { 1720, 992, -8},
    { 1440, 736, 264},
    { 896, 328, 192},
    { 728, 248, 144},
    { 816, 360, 56},
    { 792, 248, -80},
    { 832, 760, -144},
    { 872, 600, -16},
    { 912, 472, 24},
    { 1200, 488, 16},
    // 31 seconds
    { 1664, 408, 296},
    { 1856, 624, 336},
    { 1264, 456, 344},
    { 1504, 312, 192},
    { 1456, 384, 304},
    { 1168, 384, 320},
    { 888, 264, 216},
    { 744, 208, 168},
    { 720, 176, 208},
    { 720, 120, 216},
    { 616, 72, 208},
    { 616, 48, 208},
    { 680, 88, 232},
    { 832, 112, 248},
    { 1288, 80, 352},
    { 1640, 568, 392},
    { 1808, 1024, -16},
    { 1784, 1128, 8},
    { 1312, 520, 400},
    { 888, -24, 56},
    { 776, 216, 32},
    { 704, 264, -72},
    { 680, 504, -160},
    { 768, 664, -72},
    { 864, 592, 32},
    // 32 seconds
    { 1016, 528, 80},
    { 1288, 496, 136},
    { 1416, 360, 384},
    { 2032, 520, 328},
    { 1216, 488, 336},
    { 1544, 352, 216},
    { 1592, 376, 344},
    { 1272, 400, 360},
    { 920, 240, 264},
    { 736, 192, 168},
    { 720, 176, 208},
    { 672, 128, 224},
    { 624, 80, 208},
    { 600, 8, 192},
    { 712, 16, 208},
    { 856, 104, 272},
    { 1256, 72, 424},
    { 1728, 312, 616},
    { 2008, 1160, 192},
    { 1600, 1560, 264},
    { 1328, 424, 696},
    { 896, 24, 144},
    { 840, 296, 32},
    { 704, 896, 8},
    { 816, 440, -264},
    // 33 seconds
    { 360, 192, 88},
    { 752, 272, 224},
    { 880, 456, 184},
    { 1312, 656, 176},
    { 1456, 536, 440},
    { 1960, 496, 408},
    { 1248, 544, 320},
    { 1352, 376, 216},
    { 1432, 384, 240},
    { 1368, 408, 152},
    { 1032, 224, 288},
    { 776, 232, 192},
    { 768, 200, 152},
    { 760, 144, 184},
    { 680, 104, 184},
    { 648, 64, 184},
    { 720, 48, 208},
    { 928, 104, 264},
    { 1184, 200, 344},
    { 1816, 344, 432},
    { 1608, 832, 224},
    { 1592, 1216, -72},
    { 1296, 648, 320},
    { 1064, 72, 312},
    { 968, 72, 168},
    // 34 seconds
    { 784, 272, 72},
    { 600, 416, 0},
    { 632, 456, -136},
    { 600, 336, -104},
    { 736, 336, 40},
    { 1016, 360, 144},
    { 1368, 648, 128},
    { 1472, 576, 312},
    { 1856, 560, 344},
    { 1328, 560, 288},
    { 1272, 368, 224},
    { 1424, 248, 320},
    { 1296, 360, 336},
    { 1016, 344, 208},
    { 792, 264, 176},
    { 712, 224, 184},
    { 688, 192, 216},
    { 688, 136, 208},
    { 680, 88, 208},
    { 728, 64, 224},
    { 944, 80, 296},
    { 1080, 144, 360},
    { 1400, 176, 376},
    { 1688, 464, 384},
    { 1400, 928, -8},
    // 35 seconds
    { 1368, 1128, -208},
    { 1280, 376, 416},
    { 1112, -8, 288},
    { 808, 280, 96},
    { 720, 288, 32},
    { 648, 400, -24},
    { 768, 512, -96},
    { 800, 656, -24},
    { 896, 488, 128},
    { 1120, 576, 16},
    { 1424, 584, 136},
    { 1952, 536, 328},
    { 1432, 568, 328},
    { 1256, 392, 232},
    { 1504, 320, 312},
    { 1448, 304, 376},
    { 1088, 344, 296},
    { 856, 272, 192},
    { 776, 224, 200},
    { 784, 176, 224},
    { 752, 96, 232},
    { 648, 32, 216},
    { 584, 16, 208},
    { 736, 56, 224},
    { 880, 32, 296},
    // 36 seconds
    { 1608, 120, 504},
    { 1616, 688, 400},
    { 1880, 1496, -296},
    { 1392, 1192, 304},
    { 1176, 32, 424},
    { 968, -408, -56},
    { 736, 376, 0},
    { 776, 280, -64},
    { 736, 944, -48},
    { 720, 272, 24},
    { 856, 456, 112},
    { 1080, 416, 96},
    { 1328, 552, 144},
    { 1672, 448, 344},
    { 1584, 472, 320},
    { 1152, 480, 216},
    { 1328, 320, 224},
    { 1352, 320, 376},
    { 1160, 384, 264},
    { 880, 296, 192},
    { 768, 224, 168},
    { 760, 184, 224},
    { 736, 120, 232},
    { 688, 104, 208},
    { 664, 128, 208},
    // 37 seconds
    { 776, 136, 208},
    { 968, 144, 256},
    { 1392, 56, 408},
    { 1608, 408, 456},
    { 1520, 960, 48},
    { 1520, 1104, -48},
    { 1288, 344, 424},
    { 1024, 120, 256},
    { 920, 32, 40},
    { 632, 656, 8},
    { 688, 408, 96},
    { 680, 440, -40},
    { 744, 544, 16},
    { 904, 352, 136},
    { 1192, 608, 120},
    { 1328, 624, 240},
    { 1936, 496, 344},
    { 1368, 528, 304},
    { 1176, 416, 176},
    { 1424, 176, 280},
    { 1368, 328, 336},
    { 1112, 328, 280},
    { 880, 240, 240},
    { 792, 216, 224},
    { 768, 160, 240},
    // 38 seconds
    { 696, 152, 216},
    { 664, 160, 192},
    { 664, 112, 200},
    { 840, 112, 240},
    { 984, 152, 280},
    { 1384, 128, 376},
    { 1696, 392, 496},
    { 1464, 912, 184},
    { 1392, 1032, -16},
    { 1240, 456, 320},
    { 1016, 232, 208},
    { 824, 408, 112},
    { 720, 368, 80},
    { 664, 320, 24},
    { 752, 576, -72},
    { 864, 576, 88},
    { 944, 448, 152},
    { 1160, 456, 136},
    { 1344, 544, 216},
    { 1840, 488, 352},
    { 1320, 520, 328},
    { 1160, 432, 240},
    { 1416, 312, 280},
    { 1336, 264, 376},
    { 1080, 384, 296},
    // 39 seconds
    { 824, 248, 264},
    { 720, 240, 216},
    { 728, 208, 232},
    { 752, 136, 240},
    { 728, 88, 256},
    { 736, 96, 256},
    { 848, 120, 288},
    { 1016, 168, 288},
    { 1472, 184, 336},
    { 1640, 584, 200},
    { 1264, 864, -80},
    { 1440, 688, 40},
    { 1296, 448, 192},
    { 1072, 288, 40},
    { 832, 360, 64},
    { 760, 376, 96},
    { 632, 416, 88},
    { 688, 448, 88},
    { 736, 408, 104},
    { 808, 400, 136},
    { 1072, 544, 128},
    { 1272, 664, 224},
    { 1528, 488, 376},
    { 1528, 800, 192},
    { 1192, 480, 272},
    // 40 seconds
    { 1456, 448, 176},
    { 1576, 456, 224},
    { 1288, 328, 272},
    { 984, 288, 184},
    { 896, 200, 160},
    { 856, 152, 176},
    { 776, 128, 176},
    { 720, 104, 168},
    { 656, 144, 152},
    { 728, 136, 176},
    { 816, 136, 232},
    { 1088, 120, 352},
    { 1504, 352, 384},
    { 1328, 688, 232},
    { 1680, 888, 0},
    { 1576, 768, 320},
    { 1192, 312, 384},
    { 880, 200, 176},
    { 848, 264, 96},
    { 744, 368, 72},
    { 768, 528, 48},
    { 792, 592, 24},
    { 840, 568, 32},
    { 984, 536, 24},
    { 1248, 592, 64},
    // 41 seconds
    { 1544, 360, 288},
    { 1848, 528, 336},
    { 1360, 480, 344},
    { 1288, 336, 224},
    { 1352, 344, 224},
    { 1304, 344, 216},
    { 1072, 280, 240},
    { 896, 192, 256},
    { 800, 192, 232},
    { 784, 160, 240},
    { 720, 120, 224},
    { 648, 80, 224},
    { 648, 48, 216},
    { 824, 104, 240},
    { 984, 176, 264},
    { 1384, 144, 328},
    { 1880, 504, 376},
    { 1488, 976, 96},
    { 1400, 904, -40},
    { 1296, 424, 288},
    { 1168, 152, 248},
    { 936, 240, 160},
    { 760, 384, 56},
    { 640, 512, -16},
    { 720, 616, -72},
    // 42 seconds
    { 824, 552, 0},
    { 952, 456, 104},
    { 1128, 520, 96},
    { 1304, 544, 160},
    { 1432, 368, 344},
    { 1760, 536, 312},
    { 1216, 488, 288},
    { 1216, 328, 160},
    { 1328, 424, 336},
    { 1320, 288, 328},
    { 1040, 248, 296},
    { 832, 208, 248},
    { 728, 208, 232},
    { 720, 184, 232},
    { 688, 136, 232},
    { 664, 120, 224},
    { 672, 112, 224},
    { 880, 128, 248},
    { 1120, 152, 296},
    { 1288, 248, 320},
    { 1864, 472, 328},
    { 1384, 928, 80},
    { 1264, 848, -64},
    { 1424, 376, 112},
    { 1440, -504, 48},
    // 43 seconds
    { 664, 912, -40},
    { 768, 320, 120},
    { 608, 432, 32},
    { 624, 408, -8},
    { 728, 360, 80},
    { 896, 400, 80},
    { 1056, 432, 80},
    { 1312, 552, 72},
    { 1536, 336, 312},
    { 1728, 536, 224},
    { 1224, 440, 240},
    { 1248, 288, 152},
    { 1416, 472, 240},
    { 1248, 360, 248},
    { 936, 272, 192},
    { 760, 248, 128},
    { 728, 192, 176},
    { 736, 160, 192},
    { 720, 120, 192},
    { 664, 112, 192},
    { 720, 112, 184},
    { 928, 160, 232},
    { 1208, 80, 352},
    { 1784, 376, 408},
    { 1416, 800, 104},
    // 44 seconds
    { 1472, 928, -192},
    { 1400, 528, 232},
    { 1136, 0, 320},
    { 984, -48, 40},
    { 656, 488, 64},
    { 712, 536, 104},
    { 704, 496, 32},
    { 712, 472, 32},
    { 840, 424, 56},
    { 1032, 432, 64},
    { 1296, 512, 112},
    { 1608, 384, 288},
    { 1576, 560, 336},
    { 1272, 520, 232},
    { 1328, 352, 112},
    { 1384, 248, 288},
    { 1248, 392, 288},
    { 976, 280, 216},
    { 832, 192, 232},
    { 800, 192, 224},
    { 784, 176, 216},
    { 768, 152, 224},
    { 696, 112, 224},
    { 712, 80, 232},
    { 928, 136, 264},
    // 45 seconds
    { 1048, 168, 320},
    { 1760, 232, 456},
    { 1376, 624, 360},
    { 1352, 856, 8},
    { 1448, 752, 72},
    { 1288, 368, 304},
    { 1016, 80, 120},
    { 792, 360, 56},
    { 728, 344, 80},
    { 696, 448, -8},
    { 776, 496, -8},
    { 880, 472, 48},
    { 1056, 496, 80},
    { 1296, 528, 128},
    { 1432, 432, 304},
    { 1784, 472, 296},
    { 1360, 504, 232},
    { 1160, 336, 208},
    { 1320, 376, 264},
    { 1416, 264, 296},
    { 1096, 352, 288},
    { 888, 224, 248},
    { 744, 176, 208},
    { 704, 192, 240},
    { 680, 176, 240},
    // 46 seconds
    { 688, 232, 272},
    { 712, 184, 256},
    { 864, 232, 272},
    { 1032, 264, 288},
    { 1152, 248, 288},
    { 1400, 448, 272},
    { 1096, 680, 40},
    { 1536, 560, 104},
    { 1504, 392, 352},
    { 1344, 632, 64},
    { 768, 232, 32},
    { 720, 496, 56},
    { 664, 368, 104},
    { 744, 448, 96},
    { 816, 464, 96},
    { 904, 512, 96},
    { 1112, 440, 160},
    { 1304, 472, 240},
    { 1624, 440, 344},
    { 1528, 568, 328},
    { 1128, 544, 200},
    { 1256, 560, 40},
    { 1520, 256, 144},
    { 1152, -64, 264},
    { 1000, 192, 320},
    // 47 seconds
    { 808, 256, 248},
    { 736, 200, 208},
    { 728, 216, 216},
    { 720, 184, 208},
    { 728, 136, 216},
    { 880, 120, 240},
    { 1024, 144, 288},
    { 1072, 160, 312},
    { 1632, 256, 368},
    { 1208, 632, 200},
    { 1376, 784, -48},
    { 1520, 512, 216},
    { 1224, 232, 280},
    { 1000, 32, -64},
    { 752, 480, -8},
    { 768, 440, 64},
    { 744, 408, -64},
    { 784, 504, -40},
    { 912, 464, 24},
    { 1120, 464, 40},
    { 1328, 464, 152},
    { 1896, 424, 304},
    { 1488, 616, 240},
    { 1176, 432, 168},
    { 1456, 232, 240},
    // 48 seconds
    { 1472, 288, 320},
    { 1184, 360, 280},
    { 888, 304, 184},
    { 744, 216, 176},
    { 712, 152, 232},
    { 696, 104, 224},
    { 680, 80, 208},
    { 680, 88, 216},
    { 864, 104, 264},
    { 1080, 144, 216},
    { 1064, 216, 192},
    { 1656, 200, 336},
    { 1392, 632, 160},
    { 1408, 824, -80},
    { 1536, 688, 80},
    { 1344, 432, 272},
    { 888, 232, 120},
    { 800, 272, 48},
    { 712, 304, 32},
    { 736, 472, 0},
    { 840, 528, 32},
    { 912, 512, 48},
    { 1080, 496, 64},
    { 1328, 552, 80},
    { 1648, 456, 240},
    // 49 seconds
    { 1608, 520, 240},
    { 1240, 464, 256},
    { 1392, 328, 232},
    { 1296, 352, 368},
    { 1184, 320, 288},
    { 888, 272, 232},
    { 752, 248, 184},
    { 808, 232, 216},
    { 776, 168, 240},
    { 720, 136, 224},
    { 696, 96, 208},
    { 768, 112, 216},
    { 888, 184, 264},
    { 1120, 128, 360},
    { 1664, 320, 552},
    { 1368, 664, 328},
    { 1576, 1192, -72},
    { 1344, 656, 336},
    { 1328, 360, -24},
    { 712, 56, -400},
    { 784, 808, -24},
    { 664, 336, 176},
    { 568, 328, 48},
    { 712, 200, 80},
    { 832, 416, 208},
    // 50 seconds
    { 1008, 456, 248},
    { 1280, 576, 280},
    { 1584, 512, 440},
    { 1600, 608, 432},
    { 1208, 584, 232},
    { 1208, 448, 208},
    { 1312, 488, 192},
    { 1200, 160, 584},
    { 920, 448, 336},
    { 896, 128, 240},
    { 752, 312, 184},
    { 824, 288, 216},
    { 776, 192, 232},
    { 736, 136, 216},
    { 760, 128, 208},
    { 872, 160, 240},
    { 960, 184, 264},
    { 1512, 96, 400},
    { 1320, 456, 392},
    { 1320, 736, 64},
    { 1568, 840, -24},
    { 1360, 512, 336},
    { 920, 248, 248},
    { 784, 296, 136},
    { 784, 328, 88},
    // 51 seconds
    { 744, 424, 80},
    { 872, 568, 72},
    { 856, 584, 56},
    { 952, 632, 64},
    { 1152, 664, 64},
    { 1328, 544, 224},
    { 1960, 544, 248},
    { 1400, 480, 304},
    { 1296, 336, 296},
    { 1432, 328, 312},
    { 1408, 336, 336},
    { 1104, 368, 264},
    { 888, 216, 248},
    { 784, 176, 232},
    { 776, 168, 256},
    { 704, 104, 248},
    { 624, 88, 216},
    { 616, 80, 208},
    { 768, 136, 280},
    { 920, 168, 320},
    { 1280, 168, 424},
    { 1616, 472, 512},
    { 1440, 904, 208},
    { 1616, 896, 40},
    { 1432, 480, 448},
    // 52 seconds
    { 1224, -64, 280},
    { 624, 1144, 8},
    { 704, 208, 192},
    { 664, 544, 176},
    { 656, 368, -24},
    { 752, 416, 64},
    { 928, 448, 120},
    { 1120, 520, 160},
    { 1272, 528, 224},
    { 1608, 432, 304},
    { 1664, 544, 336},
    { 1216, 440, 336},
    { 1344, 304, 184},
    { 1312, 264, 152},
    { 1056, 112, 232},
    { 1000, 256, 288},
    { 816, 232, 280},
    { 744, 224, 232},
    { 768, 176, 248},
    { 744, 144, 248},
    { 728, 112, 256},
    { 864, 128, 256},
    { 1032, 144, 312},
    { 1360, 64, 384},
    { 1600, 344, 472},
    // 53 seconds
    { 1304, 760, 200},
    { 1344, 760, -48},
    { 1336, 432, 288},
    { 1184, 248, 392},
    { 840, 560, -24},
    { 688, 304, 144},
    { 736, 448, 168},
    { 680, 368, 24},
    { 816, 416, 128},
    { 896, 472, 168},
    { 1064, 512, 160},
    { 1248, 552, 200},
    { 1816, 392, 344},
    { 1496, 520, 360},
    { 1240, 456, 168},
    { 1248, 16, 96},
    { 1184, 32, 376},
    { 1320, 200, 136},
    { 960, 384, 312},
    { 784, 312, 296},
    { 752, 256, 264},
    { 776, 248, 280},
    { 776, 200, 248},
    { 800, 200, 232},
    { 856, 264, 280},
    // 54 seconds
    { 1128, 320, 360},
    { 1184, 536, 344},
    { 1416, 392, 544},
    { 864, 584, 272},
    { 616, 504, -96},
    { 1392, 664, 104},
    { 1192, 328, 328},
    { 928, 184, 552},
    { 888, 1024, -32},
    { 568, 72, 128},
    { 752, 448, 216},
    { 800, 352, 248},
    { 968, 480, 120},
    { 968, 448, 216},
    { 1168, 744, 112},
    { 1384, 912, 80},
    { 1800, 728, 216},
    { 1480, 720, 328},
    { 1376, 664, 192},
    { 1344, 592, 248},
    { 1352, 672, 288},
    { 1304, 632, 320},
    { 1064, 608, 256},
    { 880, 408, 224},
    { 736, 336, 184},
    // 55 seconds
    { 504, 104, 136},
    { 400, 32, 32},
    { 384, 48, -32},
    { 448, 200, -72},
    { 600, 184, 56},
    { 768, 168, 24},
    { 1160, 240, 88},
    { 1328, 424, 120},
    { 1488, 552, 104},
    { 1960, 696, 72},
    { 1880, 800, 272},
    { 1464, 768, 264},
    { 944, 512, 128},
    { 816, 352, 192},
    { 792, 368, 176},
    { 736, 504, 144},
    { 736, 576, 104},
    { 712, 536, 88},
    { 816, 472, 120},
    { 1160, 568, 112},
    { 1504, 544, 320},
    { 2032, 832, 256},
    { 1072, 592, 264},
    { 1376, 408, 88},
    { 1544, 360, 160},
    // 56 seconds
    { 1432, 608, 384},
    { 976, 192, 312},
    { 800, 72, 208},
    { 808, 280, 216},
    { 880, 288, 272},
    { 800, 224, 272},
    { 720, 144, 264},
    { 800, 168, 272},
    { 928, 192, 240},
    { 1168, 200, 256},
    { 1128, 328, 312},
    { 1128, 584, 128},
    { 1448, 680, 16},
    { 1504, 648, 200},
    { 1272, 432, 240},
    { 864, 248, 112},
    { 760, 240, 80},
    { 816, 336, 88},
    { 848, 416, 104},
    { 872, 456, 80},
    { 912, 480, 88},
    { 1016, 552, 64},
    { 1176, 600, 72},
    { 1408, 456, 248},
    { 1816, 568, 248},
    // 57 seconds
    { 1328, 592, 256},
    { 1200, 400, 208},
    { 1384, 360, 184},
    { 1368, 472, 344},
    { 1168, 376, 280},
    { 1008, 320, 296},
    { 976, 392, 288},
    { 976, 488, 328},
    { 1040, 656, 248},
    { 960, 672, 232},
    { 848, 672, 96},
    { 736, 648, -40},
    { 672, 656, -304},
    { 488, 440, -368},
    { 504, 304, -472},
    { 648, 376, -736},
    { 648, 224, -800},
    { 712, 168, -776},
    { 800, 56, -776},
    { 840, 264, -672},
    { 720, 560, -656},
    { 520, 504, -624},
    { 320, 688, -496},
    { 376, 736, -392},
    { 336, 936, -488},
    // 58 seconds
    { 296, 688, -432},
    { 296, 672, -408},
    { 304, 936, -416},
    { 384, 888, -512},
    { 288, 872, -520},
    { 264, 856, -520},
    { 232, 848, -416},
    { 264, 744, -592},
    { 224, 568, -560},
    { 184, 512, -656},
    { 192, 352, -704},
    { 296, 512, -744},
    { 320, 440, -776},
    { 368, 456, -816},
    { 432, 504, -904},
    { 448, 408, -888},
    { 448, 376, -872},
    { 424, 304, -872},
    { 448, 296, -904},
    { 432, 256, -856},
    { 336, 176, -808},
    { 464, 328, -912},
    { 472, 328, -904},
    { 472, 280, -880},
    { 424, 272, -920},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:45:19 local
AccelRawData *activity_sample_walk_100_pbl_25666_3(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25666_3
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 368, 304, -912},
    { 336, 312, -912},
    { 384, 248, -904},
    { 328, 288, -904},
    { 336, 280, -936},
    { 336, 344, -896},
    { 304, 280, -912},
    { 440, 216, -944},
    { 368, 256, -912},
    { 312, 248, -864},
    { 352, 304, -896},
    { 312, 336, -912},
    { 376, 256, -944},
    { 368, 352, -904},
    { 328, 328, -904},
    { 352, 304, -928},
    { 320, 296, -912},
    { 344, 344, -904},
    { 320, 288, -904},
    { 336, 304, -888},
    { 328, 296, -880},
    { 320, 320, -880},
    { 360, 344, -864},
    { 336, 328, -896},
    { 368, 376, -912},
    // 1 seconds
    { 368, 368, -904},
    { 352, 344, -904},
    { 368, 360, -880},
    { 352, 336, -896},
    { 344, 336, -880},
    { 360, 352, -848},
    { 352, 336, -856},
    { 360, 352, -864},
    { 376, 352, -864},
    { 360, 352, -880},
    { 360, 352, -880},
    { 352, 336, -888},
    { 408, 392, -848},
    { 360, 328, -872},
    { 320, 264, -896},
    { 376, 312, -888},
    { 368, 320, -920},
    { 240, 312, -944},
    { 504, 232, -984},
    { 480, 568, -960},
    { 336, 296, -856},
    { 448, 256, -880},
    { 320, 208, -832},
    { 248, 96, -736},
    { 272, 32, -600},
    // 2 seconds
    { 328, -24, -528},
    { 488, 48, -440},
    { 624, 192, -376},
    { 808, 320, -360},
    { 912, 160, -360},
    { 1032, 152, -256},
    { 1288, 288, -136},
    { 1584, 392, -56},
    { 1888, 320, 24},
    { 2160, 472, 40},
    { 1936, 536, -24},
    { 1584, 600, -80},
    { 1136, 552, -72},
    { 1000, 280, -16},
    { 856, 24, -16},
    { 712, 8, -32},
    { 624, 144, -96},
    { 648, 232, -72},
    { 824, 272, -144},
    { 1032, 208, -176},
    { 1160, 240, -200},
    { 1288, 176, -208},
    { 1440, 168, -216},
    { 1608, 72, -112},
    { 1752, 112, -176},
    // 3 seconds
    { 1384, 192, -136},
    { 1376, 112, 48},
    { 1432, 56, 56},
    { 1264, 80, 56},
    { 1024, 96, 8},
    { 824, 104, 16},
    { 752, 64, 16},
    { 720, 40, 48},
    { 768, 96, 48},
    { 776, 168, -48},
    { 856, 96, -8},
    { 1056, 176, 0},
    { 1120, 80, 8},
    { 1544, 184, 16},
    { 1272, 352, -312},
    { 1240, 344, -312},
    { 1480, 256, -216},
    { 1344, 328, -120},
    { 984, 248, -112},
    { 768, 248, -96},
    { 696, 200, -96},
    { 768, 280, -104},
    { 904, 320, -200},
    { 968, 368, -168},
    { 1152, 504, -232},
    // 4 seconds
    { 1352, 576, -264},
    { 1752, 480, -192},
    { 1552, 520, -296},
    { 1344, 400, -184},
    { 1576, 360, -24},
    { 1432, 320, 32},
    { 1056, 280, 64},
    { 800, 272, 104},
    { 776, 344, 112},
    { 768, 280, 160},
    { 752, 408, 264},
    { 680, 408, 152},
    { 624, 568, 256},
    { 624, 720, 240},
    { 600, 800, 24},
    { 728, 912, 208},
    { 776, 1048, 104},
    { 568, 1080, -112},
    { 640, 976, 120},
    { 640, 904, 368},
    { 560, 1048, 168},
    { 360, 600, 0},
    { 200, 560, 64},
    { 152, 640, 136},
    { 232, 688, 216},
    // 5 seconds
    { 336, 968, 312},
    { 448, 808, 376},
    { 512, 1008, 320},
    { 560, 1136, 368},
    { 704, 1176, 528},
    { 584, 1104, 528},
    { 616, 1120, 344},
    { 584, 784, 584},
    { 608, 936, 368},
    { 464, 720, 288},
    { 400, 672, 256},
    { 400, 480, 56},
    { 440, 384, -16},
    { 632, 368, 144},
    { 600, 424, 120},
    { 712, 440, 160},
    { 856, 304, 320},
    { 1128, 144, 600},
    { 1952, 224, 912},
    { 1704, 1048, 576},
    { 1712, 1192, 8},
    { 1432, 816, 352},
    { 960, 248, 384},
    { 792, 160, 280},
    { 768, 256, 288},
    // 6 seconds
    { 600, 376, 240},
    { 552, 488, 224},
    { 640, 520, 96},
    { 720, 448, 152},
    { 912, 496, 128},
    { 1328, 824, -64},
    { 1880, 832, 160},
    { 1776, 912, 104},
    { 1344, 248, 208},
    { 1608, 144, 216},
    { 1632, 96, 376},
    { 1240, 376, 248},
    { 904, 336, 144},
    { 808, 256, 128},
    { 760, 192, 216},
    { 744, 136, 248},
    { 680, 88, 224},
    { 648, 56, 208},
    { 744, 56, 216},
    { 904, 80, 240},
    { 1408, 56, 368},
    { 1496, 472, 384},
    { 1504, 816, 32},
    { 1720, 1104, -184},
    { 1368, 624, 368},
    // 7 seconds
    { 1160, 80, 216},
    { 888, 232, 104},
    { 816, 320, 64},
    { 720, 496, 0},
    { 792, 680, -24},
    { 840, 656, 16},
    { 904, 616, 24},
    { 1264, 664, -8},
    { 1416, 624, 216},
    { 1944, 512, 288},
    { 1344, 488, 288},
    { 1392, 352, 232},
    { 1504, 288, 248},
    { 1384, 392, 304},
    { 1040, 336, 280},
    { 816, 232, 208},
    { 744, 168, 208},
    { 792, 152, 248},
    { 728, 112, 240},
    { 752, 88, 216},
    { 768, 64, 208},
    { 896, 128, 208},
    { 1120, 32, 288},
    { 1512, 240, 400},
    { 1360, 648, 144},
    // 8 seconds
    { 1704, 976, -216},
    { 1608, 864, 136},
    { 1184, 288, 304},
    { 944, -112, 32},
    { 688, 600, 72},
    { 768, 280, 64},
    { 752, 568, 16},
    { 816, 560, -56},
    { 840, 480, 32},
    { 1072, 504, 32},
    { 1448, 600, 96},
    { 1944, 464, 312},
    { 1496, 568, 216},
    { 1208, 432, 216},
    { 1392, 320, 248},
    { 1352, 352, 344},
    { 1136, 360, 240},
    { 880, 312, 184},
    { 768, 224, 176},
    { 712, 160, 224},
    { 712, 128, 216},
    { 688, 88, 208},
    { 680, 72, 216},
    { 856, 120, 248},
    { 968, 144, 240},
    // 9 seconds
    { 1384, 136, 304},
    { 1608, 480, 272},
    { 1480, 912, -112},
    { 1544, 960, -152},
    { 1392, 392, 328},
    { 1016, -24, 208},
    { 816, 72, 64},
    { 728, 176, 24},
    { 688, 400, -48},
    { 800, 640, -48},
    { 912, 696, -32},
    { 936, 608, 8},
    { 1272, 448, -32},
    { 1504, 368, 64},
    { 1824, 144, 264},
    { 1528, 336, 104},
    { 1160, 184, 256},
    { 1320, 80, 280},
    { 1200, 264, 216},
    { 1104, 384, 224},
    { 856, 416, 200},
    { 728, 288, 192},
    { 712, 184, 216},
    { 760, 144, 248},
    { 736, 120, 216},
    // 10 seconds
    { 712, 136, 200},
    { 896, 160, 192},
    { 1040, 176, 216},
    { 1192, 208, 264},
    { 1784, 368, 296},
    { 1384, 896, -56},
    { 1384, 896, -96},
    { 1360, 168, 312},
    { 1048, 144, 232},
    { 760, 320, 64},
    { 664, 376, 8},
    { 632, 448, 8},
    { 800, 536, -72},
    { 928, 456, 16},
    { 976, 488, 80},
    { 1160, 496, 64},
    { 1392, 544, 88},
    { 1568, 392, 272},
    { 1584, 560, 216},
    { 1160, 464, 272},
    { 1384, 328, 240},
    { 1392, 352, 312},
    { 1144, 360, 296},
    { 840, 280, 224},
    { 760, 216, 200},
    // 11 seconds
    { 800, 168, 224},
    { 760, 144, 224},
    { 696, 136, 200},
    { 712, 88, 184},
    { 824, 80, 200},
    { 928, 128, 232},
    { 1416, 120, 312},
    { 1560, 528, 256},
    { 1448, 864, -72},
    { 1480, 904, -72},
    { 1304, 544, 304},
    { 1064, 104, 208},
    { 888, 224, 88},
    { 808, 304, -24},
    { 728, 440, -56},
    { 840, 584, -96},
    { 856, 512, -16},
    { 952, 440, 64},
    { 1192, 472, 56},
    { 1544, 352, 248},
    { 1936, 608, 288},
    { 1288, 480, 296},
    { 1328, 312, 160},
    { 1312, 304, 240},
    { 1216, 360, 272},
    // 12 seconds
    { 920, 272, 224},
    { 728, 208, 160},
    { 664, 184, 160},
    { 648, 168, 176},
    { 672, 136, 168},
    { 656, 120, 184},
    { 776, 104, 192},
    { 1048, 208, 208},
    { 1240, 224, 296},
    { 1832, 376, 384},
    { 1328, 728, 184},
    { 1392, 792, 8},
    { 1304, 648, 160},
    { 1168, 304, 176},
    { 904, 272, 136},
    { 720, 208, 120},
    { 648, 432, -56},
    { 608, 296, -64},
    { 728, 504, 32},
    { 920, 456, 160},
    { 1224, 584, 160},
    { 1360, 616, 216},
    { 1736, 480, 280},
    { 1520, 536, 320},
    { 1112, 488, 240},
    // 13 seconds
    { 1320, 344, 152},
    { 1352, 264, 272},
    { 1184, 208, 200},
    { 896, 312, 272},
    { 840, 272, 200},
    { 872, 232, 224},
    { 832, 184, 248},
    { 816, 152, 224},
    { 776, 104, 208},
    { 880, 120, 224},
    { 960, 168, 280},
    { 1168, 128, 328},
    { 1448, 288, 424},
    { 1104, 584, 256},
    { 1256, 648, -24},
    { 1376, 488, 136},
    { 1176, 264, 320},
    { 944, 264, 232},
    { 864, 432, 88},
    { 808, 448, 104},
    { 952, 560, 104},
    { 952, 592, 72},
    { 904, 624, 80},
    { 1008, 656, 80},
    { 1232, 728, 176},
    // 14 seconds
    { 1288, 528, 392},
    { 1688, 800, 176},
    { 1200, 552, 272},
    { 1592, 480, 216},
    { 1824, 440, 248},
    { 1536, 408, 168},
    { 1192, 272, 104},
    { 992, 192, 96},
    { 872, 136, 104},
    { 760, 96, 96},
    { 640, 80, 80},
    { 576, 48, 104},
    { 584, 72, 208},
    { 776, 40, 288},
    { 960, 224, 304},
    { 1248, 320, 584},
    { 1256, 760, 640},
    { 1248, 1088, 400},
    { 1560, 624, 632},
    { 1584, 928, 640},
    { 944, 728, 528},
    { 672, 696, 264},
    { 760, 632, 224},
    { 744, 664, 216},
    { 816, 712, 216},
    // 15 seconds
    { 824, 544, 248},
    { 976, 576, 264},
    { 1232, 488, 360},
    { 1464, 424, 496},
    { 1872, 392, 520},
    { 1336, 472, 384},
    { 1576, 304, 280},
    { 1600, 304, 424},
    { 1336, 360, 456},
    { 984, 240, 352},
    { 784, 192, 256},
    { 680, 128, 232},
    { 624, 128, 216},
    { 616, 72, 208},
    { 616, 40, 200},
    { 744, 40, 208},
    { 952, 96, 232},
    { 1184, 128, 296},
    { 1712, 288, 392},
    { 1536, 680, 176},
    { 1816, 1072, -224},
    { 1696, 928, 152},
    { 1288, 288, 344},
    { 888, 288, 64},
    { 712, 328, -24},
    // 16 seconds
    { 544, 400, -48},
    { 680, 448, -24},
    { 952, 552, -16},
    { 984, 560, 104},
    { 1136, 440, 256},
    { 1368, 512, 288},
    { 2112, 504, 296},
    { 1464, 640, 360},
    { 1688, 352, 336},
    { 1576, 272, 384},
    { 1160, 336, 368},
    { 768, 320, 248},
    { 568, 232, 160},
    { 576, 152, 192},
    { 744, 96, 216},
    { 912, 112, 272},
    { 912, 48, 312},
    { 1104, 144, 344},
    { 1040, 248, 368},
    { 1344, 272, 408},
    { 1464, 408, 304},
    { 1808, 592, 176},
    { 1560, 688, 168},
    { 928, 712, 64},
    { 432, 360, 8},
    // 17 seconds
    { 568, 288, 112},
    { 944, 352, 200},
    { 1280, 768, 56},
    { 1128, 1016, 56},
    { 1280, 888, 32},
    { 1904, 760, 168},
    { 1808, 640, 400},
    { 1904, 296, 584},
    { 1832, 288, 528},
    { 1328, 472, 328},
    { 1016, 432, 216},
    { 992, 200, 192},
    { 992, 40, 304},
    { 1056, -112, 352},
    { 832, -128, 272},
    { 864, -96, 272},
    { 800, -16, 296},
    { 1136, -40, 416},
    { 1232, 216, 488},
    { 1976, 624, 216},
    { 1808, 824, 88},
    { 1200, 864, 128},
    { 616, 568, 200},
    { 928, 168, 264},
    { 1448, 408, 136},
    // 18 seconds
    { 1160, 800, 32},
    { 1152, 832, -96},
    { 1200, 848, 32},
    { 2072, 848, 136},
    { 1920, 520, 544},
    { 2000, 256, 648},
    { 1632, 288, 440},
    { 1160, 528, 144},
    { 1040, 456, 152},
    { 1080, 160, 192},
    { 1000, -160, 280},
    { 984, -168, 232},
    { 800, -208, 176},
    { 784, -96, 192},
    { 1104, -56, 256},
    { 1040, 96, 544},
    { 1616, 408, 368},
    { 1952, 616, 216},
    { 1736, 712, 272},
    { 1104, 968, 152},
    { 544, 480, 248},
    { 808, 208, 328},
    { 1424, 592, 232},
    { 1136, 1024, 216},
    { 1256, 976, 104},
    // 19 seconds
    { 1248, 936, 104},
    { 1976, 944, 80},
    { 1736, 664, 432},
    { 2272, 464, 504},
    { 1944, 368, 216},
    { 1312, 56, 216},
    { 968, 328, 88},
    { 1128, 160, 128},
    { 1056, -136, 216},
    { 936, -216, 264},
    { 704, -328, 120},
    { 552, -264, 40},
    { 592, -128, 0},
    { 1120, -152, 240},
    { 1728, 200, 464},
    { 2536, 504, 480},
    { 2520, 720, 592},
    { 1664, 1032, 104},
    { 632, 520, 144},
    { 856, 216, 424},
    { 1288, 504, 472},
    { 1112, 1032, 472},
    { 872, 1136, 536},
    { 904, 1096, 496},
    { 1432, 1208, 224},
    // 20 seconds
    { 1760, 1000, 304},
    { 2304, 264, 416},
    { 2152, 328, 472},
    { 1664, 624, 136},
    { 1328, 568, -32},
    { 1144, 24, 16},
    { 1112, -352, 48},
    { 1000, -344, 32},
    { 752, -408, 0},
    { 696, -264, 152},
    { 1176, -208, 656},
    { 1288, 280, 704},
    { 2264, 696, 312},
    { 2336, 648, 248},
    { 1720, 808, 288},
    { 920, 728, 368},
    { 856, 536, 400},
    { 1264, 352, 320},
    { 1240, 680, 256},
    { 1040, 744, 328},
    { 928, 888, 280},
    { 1568, 1152, 248},
    { 1728, 984, 432},
    { 2160, 408, 616},
    { 2056, 216, 664},
    // 21 seconds
    { 1584, 288, 440},
    { 1384, 320, 200},
    { 1240, 32, 184},
    { 1176, -144, 264},
    { 880, -376, 216},
    { 608, -344, 120},
    { 712, -104, 240},
    { 1080, 24, 344},
    { 1168, 104, 528},
    { 1520, 280, 360},
    { 2176, 520, 320},
    { 2048, 832, 392},
    { 1184, 936, 360},
    { 704, 624, 248},
    { 1000, 304, 280},
    { 1248, 552, 144},
    { 1056, 944, 160},
    { 1032, 912, 120},
    { 1384, 792, 320},
    { 2160, 1000, 344},
    { 2016, 488, 560},
    { 1904, 288, 536},
    { 1480, 256, 448},
    { 1120, 376, 328},
    { 1032, 256, 232},
    // 22 seconds
    { 1128, 64, 296},
    { 1040, -72, 432},
    { 928, -184, 432},
    { 768, -232, 344},
    { 736, -80, 264},
    { 1200, -64, 312},
    { 888, 72, 552},
    { 1800, 472, 224},
    { 1984, 728, 120},
    { 1848, 768, 336},
    { 1032, 952, 304},
    { 648, 336, 248},
    { 1040, 344, 136},
    { 1272, 632, 88},
    { 1072, 896, 168},
    { 1144, 912, 32},
    { 1320, 784, 288},
    { 2088, 904, 360},
    { 1776, 472, 560},
    { 1840, 312, 456},
    { 1600, 344, 440},
    { 1104, 464, 320},
    { 952, 304, 208},
    { 936, 136, 248},
    { 904, 16, 304},
    // 23 seconds
    { 920, -80, 296},
    { 768, -176, 328},
    { 816, -176, 312},
    { 888, -16, 368},
    { 1144, 80, 576},
    { 1160, 328, 432},
    { 1784, 688, 112},
    { 2080, 880, 296},
    { 1376, 1088, 432},
    { 584, 464, 352},
    { 768, 328, 104},
    { 1128, 432, 24},
    { 1168, 776, 0},
    { 1144, 952, 48},
    { 1264, 720, 144},
    { 1728, 520, 312},
    { 1904, 704, 416},
    { 1944, 416, 552},
    { 1696, 184, 568},
    { 1312, 264, 368},
    { 1064, 320, 240},
    { 960, 256, 192},
    { 896, 24, 304},
    { 872, -152, 360},
    { 784, -176, 304},
    // 24 seconds
    { 744, -152, 280},
    { 688, -40, 280},
    { 1120, -24, 432},
    { 1096, 272, 504},
    { 2032, 704, 136},
    { 2032, 744, 224},
    { 1472, 960, 352},
    { 648, 688, 280},
    { 672, 272, 96},
    { 1088, 456, 56},
    { 1160, 816, 72},
    { 1072, 1120, 104},
    { 1248, 912, 160},
    { 2048, 880, 224},
    { 1608, 712, 424},
    { 1880, 216, 440},
    { 1736, 216, 504},
    { 1272, 448, 376},
    { 992, 432, 264},
    { 936, 192, 168},
    { 912, -40, 288},
    { 856, -160, 336},
    { 664, -200, 272},
    { 584, -128, 264},
    { 744, 48, 248},
    // 25 seconds
    { 1192, 56, 432},
    { 1352, 352, 568},
    { 1936, 640, 136},
    { 1928, 784, 104},
    { 1408, 864, 312},
    { 728, 632, 160},
    { 680, 352, 88},
    { 1040, 376, 104},
    { 1056, 640, 48},
    { 1032, 920, -8},
    { 1192, 880, 24},
    { 1688, 800, 392},
    { 1760, 824, 424},
    { 1616, 280, 280},
    { 1696, 264, 368},
    { 1496, 440, 552},
    { 1032, 440, 376},
    { 920, 256, 192},
    { 880, 88, 216},
    { 872, 32, 264},
    { 816, -64, 296},
    { 760, -88, 336},
    { 760, -8, 280},
    { 1320, -112, 432},
    { 1016, 200, 568},
    // 26 seconds
    { 1872, 664, 192},
    { 1928, 712, 80},
    { 1472, 776, 352},
    { 664, 640, 264},
    { 680, 232, 144},
    { 1024, 248, 120},
    { 1104, 552, 64},
    { 968, 944, 72},
    { 1040, 880, 8},
    { 1192, 760, 240},
    { 2168, 824, 152},
    { 1640, 552, 440},
    { 2000, 280, 512},
    { 1760, 312, 504},
    { 1272, 392, 352},
    { 944, 344, 200},
    { 856, 192, 176},
    { 792, 8, 248},
    { 720, -96, 280},
    { 632, -200, 200},
    { 624, -216, 232},
    { 872, -16, 264},
    { 1288, -8, 472},
    { 1544, 264, 488},
    { 2136, 736, 208},
    // 27 seconds
    { 2192, 856, 192},
    { 1360, 976, 184},
    { 488, 520, -16},
    { 864, 240, 88},
    { 1184, 368, 168},
    { 1216, 936, -16},
    { 1200, 952, -80},
    { 1232, 784, 72},
    { 1408, 568, 240},
    { 1784, 656, 408},
    { 1720, 392, 496},
    { 1664, 392, 472},
    { 1560, 344, 472},
    { 1344, 328, 376},
    { 1160, 248, 336},
    { 968, 152, 344},
    { 920, 72, 344},
    { 888, -72, 328},
    { 816, -184, 328},
    { 832, -120, 296},
    { 808, 88, 240},
    { 1240, 0, 360},
    { 968, 72, 472},
    { 1624, 448, 184},
    { 1992, 728, 80},
    // 28 seconds
    { 1600, 920, 240},
    { 888, 800, 272},
    { 960, 312, 192},
    { 1200, 344, 56},
    { 1168, 472, -96},
    { 1056, 696, -80},
    { 1176, 768, -32},
    { 1360, 568, 256},
    { 2040, 816, 232},
    { 1984, 320, 672},
    { 1760, 128, 608},
    { 1408, 248, 384},
    { 1032, 424, 272},
    { 936, 344, 224},
    { 872, 184, 288},
    { 944, 48, 328},
    { 888, -104, 368},
    { 840, -176, 360},
    { 760, -32, 320},
    { 1216, -56, 424},
    { 880, 216, 472},
    { 1488, 408, 200},
    { 1904, 608, 176},
    { 1456, 952, 384},
    { 1032, 704, 248},
    // 29 seconds
    { 688, 328, 360},
    { 1056, 520, 120},
    { 1168, 648, 152},
    { 1080, 872, 192},
    { 1152, 832, 232},
    { 1424, 808, 448},
    { 1792, 960, 472},
    { 1616, 432, 536},
    { 1568, 304, 448},
    { 1328, 376, 592},
    { 936, 320, 392},
    { 784, 200, 288},
    { 856, 88, 384},
    { 952, 24, 416},
    { 960, -32, 424},
    { 920, -72, 408},
    { 880, 8, 344},
    { 1408, 72, 360},
    { 1024, 152, 480},
    { 1472, 480, 112},
    { 1504, 456, 48},
    { 1304, 504, 248},
    { 824, 560, 232},
    { 712, 448, 160},
    { 840, 496, 120},
    // 30 seconds
    { 1136, 576, 192},
    { 1112, 808, 144},
    { 1272, 872, 96},
    { 1456, 712, 360},
    { 1976, 912, 328},
    { 1552, 488, 432},
    { 1624, 376, 400},
    { 1472, 296, 512},
    { 1088, 344, 376},
    { 920, 240, 248},
    { 840, 160, 272},
    { 960, 64, 320},
    { 936, -56, 376},
    { 848, -136, 360},
    { 896, -80, 336},
    { 1032, 64, 368},
    { 1264, 104, 464},
    { 1360, 384, 304},
    { 1784, 696, 56},
    { 1736, 632, 224},
    { 1136, 680, 240},
    { 584, 400, 120},
    { 832, 288, 88},
    { 1080, 416, 80},
    { 1144, 784, 48},
    // 31 seconds
    { 1048, 960, -40},
    { 1184, 848, 16},
    { 1568, 520, 376},
    { 1872, 664, 336},
    { 1832, 328, 520},
    { 1800, 240, 472},
    { 1488, 392, 392},
    { 1112, 464, 256},
    { 928, 264, 176},
    { 856, 136, 224},
    { 864, 32, 264},
    { 768, -80, 232},
    { 728, -144, 208},
    { 712, -128, 256},
    { 1000, -64, 328},
    { 1080, 320, 624},
    { 1312, 704, 256},
    { 1776, 800, -192},
    { 1904, 640, 312},
    { 1312, 760, 368},
    { 712, 536, 184},
    { 720, 272, 104},
    { 944, 264, 48},
    { 1112, 592, 24},
    { 1048, 904, 32},
    // 32 seconds
    { 1176, 1008, 16},
    { 1488, 832, 216},
    { 2096, 704, 304},
    { 1288, 520, 336},
    { 1672, 376, 264},
    { 1752, 384, 424},
    { 1376, 224, 408},
    { 920, 288, 304},
    { 776, 168, 208},
    { 704, 112, 240},
    { 776, 72, 248},
    { 776, -8, 256},
    { 784, -56, 304},
    { 856, -24, 304},
    { 1112, 16, 328},
    { 1280, 200, 520},
    { 1536, 464, 336},
    { 2112, 776, 24},
    { 1760, 984, 128},
    { 944, 800, 296},
    { 592, 192, 144},
    { 928, 184, 40},
    { 1088, 280, -8},
    { 1112, 760, -64},
    { 1152, 936, -88},
    // 33 seconds
    { 1304, 848, 24},
    { 2184, 720, 120},
    { 1552, 584, 360},
    { 1896, 168, 448},
    { 1800, 104, 520},
    { 1256, 376, 400},
    { 928, 448, 256},
    { 896, 304, 128},
    { 864, 96, 272},
    { 912, -56, 328},
    { 720, -176, 304},
    { 736, -112, 280},
    { 856, 56, 280},
    { 1360, 0, 456},
    { 1048, 352, 544},
    { 1648, 640, 16},
    { 1864, 656, -32},
    { 1544, 840, 168},
    { 784, 536, 208},
    { 768, 352, 16},
    { 1008, 232, 96},
    { 1152, 560, 24},
    { 1096, 1008, -48},
    { 1224, 936, -64},
    { 1576, 672, 256},
    // 34 seconds
    { 1880, 720, 328},
    { 1816, 272, 504},
    { 1728, 272, 464},
    { 1488, 408, 360},
    { 1136, 472, 256},
    { 1000, 264, 168},
    { 896, 104, 232},
    { 872, -32, 232},
    { 768, -144, 216},
    { 696, -184, 184},
    { 688, -72, 232},
    { 1000, -56, 248},
    { 1104, 304, 600},
    { 1512, 512, 288},
    { 1896, 704, -64},
    { 1872, 888, 80},
    { 1176, 912, 240},
    { 592, 304, 136},
    { 880, 312, 40},
    { 1104, 368, 40},
    { 1080, 712, -48},
    { 1112, 824, -96},
    { 1312, 720, 32},
    { 1912, 496, 240},
    { 1552, 696, 288},
    // 35 seconds
    { 1800, 336, 320},
    { 1760, 232, 408},
    { 1392, 336, 384},
    { 1000, 376, 248},
    { 832, 248, 176},
    { 792, 136, 216},
    { 840, 48, 232},
    { 816, -64, 240},
    { 832, -96, 264},
    { 800, -48, 288},
    { 1208, -104, 376},
    { 984, 256, 624},
    { 1448, 592, 160},
    { 1816, 792, -224},
    { 1760, 856, 152},
    { 1088, 656, 328},
    { 616, 464, 32},
    { 896, 320, 80},
    { 1096, 432, 72},
    { 1032, 816, 32},
    { 1088, 920, -48},
    { 1232, 768, 104},
    { 2032, 752, 176},
    { 1464, 616, 376},
    { 1856, 232, 408},
    // 36 seconds
    { 1832, 216, 456},
    { 1384, 400, 384},
    { 1024, 432, 248},
    { 856, 264, 160},
    { 800, 96, 200},
    { 832, 32, 232},
    { 752, -96, 224},
    { 672, -128, 232},
    { 680, -64, 232},
    { 1008, -80, 256},
    { 1016, 224, 536},
    { 1544, 504, 248},
    { 2096, 800, -112},
    { 1976, 904, 144},
    { 1160, 768, 304},
    { 568, 368, 56},
    { 840, 320, 104},
    { 984, 448, 152},
    { 1040, 792, 144},
    { 992, 928, 88},
    { 1184, 864, 88},
    { 1512, 712, 320},
    { 1888, 752, 336},
    { 1576, 416, 344},
    { 1792, 352, 320},
    // 37 seconds
    { 1656, 368, 440},
    { 1136, 392, 264},
    { 880, 224, 192},
    { 768, 136, 192},
    { 744, 72, 224},
    { 832, 8, 192},
    { 720, -72, 216},
    { 744, -72, 248},
    { 872, -8, 304},
    { 1248, 168, 584},
    { 1184, 504, 344},
    { 1896, 640, 8},
    { 1944, 528, 368},
    { 1416, 672, 416},
    { 808, 616, 88},
    { 720, 440, 16},
    { 960, 448, 16},
    { 1112, 656, 136},
    { 976, 832, 160},
    { 1168, 880, 112},
    { 1392, 728, 304},
    { 2088, 768, 232},
    { 1400, 472, 336},
    { 1768, 352, 368},
    { 1696, 280, 504},
    // 38 seconds
    { 1240, 352, 384},
    { 1016, 296, 232},
    { 872, 160, 192},
    { 848, 80, 256},
    { 776, -24, 264},
    { 688, -96, 232},
    { 752, -96, 248},
    { 976, -72, 336},
    { 1240, 88, 584},
    { 1272, 432, 408},
    { 2112, 888, -80},
    { 2008, 608, 328},
    { 1224, 576, 416},
    { 632, 472, 48},
    { 696, 312, 24},
    { 824, 232, 40},
    { 1040, 440, 72},
    { 1064, 840, 104},
    { 1240, 912, 112},
    { 1480, 920, 216},
    { 2080, 624, 152},
    { 1336, 536, 248},
    { 1864, 376, 320},
    { 1856, 296, 520},
    { 1352, 264, 456},
    // 39 seconds
    { 920, 240, 304},
    { 760, 120, 152},
    { 768, 32, 184},
    { 784, -40, 240},
    { 720, -120, 280},
    { 744, -128, 320},
    { 1088, 16, 336},
    { 1512, 56, 528},
    { 1512, 416, 448},
    { 2008, 792, 56},
    { 1944, 688, 216},
    { 1296, 720, 400},
    { 624, 472, 200},
    { 720, 320, 48},
    { 848, 416, 0},
    { 920, 672, -40},
    { 1008, 864, 16},
    { 1280, 768, 112},
    { 1752, 504, 392},
    { 1992, 608, 392},
    { 1952, 416, 408},
    { 1832, 176, 392},
    { 1504, 320, 368},
    { 1224, 328, 328},
    { 944, 160, 272},
    // 40 seconds
    { 848, 16, 264},
    { 976, -112, 264},
    { 776, -224, 272},
    { 688, -152, 272},
    { 712, -56, 216},
    { 1120, -96, 432},
    { 1080, 224, 592},
    { 2080, 744, 96},
    { 2200, 784, -64},
    { 1648, 960, 208},
    { 632, 696, 192},
    { 720, 256, 72},
    { 1032, 240, 120},
    { 1192, 576, -8},
    { 968, 920, 16},
    { 1088, 712, -64},
    { 1128, 712, 104},
    { 1600, 544, 200},
    { 1848, 680, 312},
    { 2032, 288, 600},
    { 1736, 192, 520},
    { 1384, 304, 296},
    { 1048, 408, 208},
    { 944, 296, 152},
    { 872, 96, 232},
    // 41 seconds
    { 800, -64, 256},
    { 656, -168, 192},
    { 592, -144, 176},
    { 600, -104, 160},
    { 1104, 88, 320},
    { 1184, 664, 304},
    { 1616, 600, -200},
    { 1904, 448, 56},
    { 1672, 520, 232},
    { 1000, 584, 80},
    { 664, 456, 40},
    { 784, 304, 176},
    { 1128, 424, 80},
    { 1112, 864, 8},
    { 1112, 808, -8},
    { 1240, 832, 112},
    { 1816, 576, 240},
    { 1472, 776, 280},
    { 1872, 344, 400},
    { 1816, 288, 424},
    { 1336, 408, 360},
    { 952, 384, 216},
    { 904, 216, 144},
    { 928, 112, 240},
    { 920, -16, 256},
    // 42 seconds
    { 776, -128, 272},
    { 648, -152, 256},
    { 696, -56, 224},
    { 1160, -8, 232},
    { 1064, 224, 472},
    { 1688, 592, 152},
    { 2088, 648, 120},
    { 1968, 776, 480},
    { 968, 760, 264},
    { 520, 392, -16},
    { 712, 296, 72},
    { 960, 456, 88},
    { 976, 744, 128},
    { 992, 736, 128},
    { 1256, 712, 264},
    { 2488, 808, 400},
    { 1552, 560, 424},
    { 1792, 344, 240},
    { 1728, 344, 376},
    { 1232, 464, 328},
    { 968, 304, 240},
    { 824, 128, 184},
    { 792, 8, 240},
    { 784, -72, 248},
    { 704, -136, 240},
    // 43 seconds
    { 728, -72, 280},
    { 872, 48, 296},
    { 1280, -72, 440},
    { 1224, 344, 520},
    { 2096, 832, 40},
    { 1968, 736, 144},
    { 1416, 744, 272},
    { 592, 464, 144},
    { 696, 288, 80},
    { 920, 328, 88},
    { 1088, 608, 72},
    { 1040, 928, 72},
    { 1152, 944, -64},
    { 1384, 784, 168},
    { 2152, 632, 232},
    { 1496, 456, 392},
    { 1816, 240, 432},
    { 1696, 208, 456},
    { 1240, 408, 328},
    { 992, 320, 208},
    { 904, 168, 184},
    { 832, 8, 280},
    { 736, -72, 256},
    { 648, -128, 240},
    { 608, -120, 248},
    // 44 seconds
    { 720, 0, 216},
    { 1048, 112, 240},
    { 1304, 400, 496},
    { 1680, 680, 192},
    { 2104, 728, 120},
    { 1776, 816, 432},
    { 936, 776, 216},
    { 592, 344, 32},
    { 792, 344, 104},
    { 992, 536, 32},
    { 928, 744, 128},
    { 1016, 848, 8},
    { 1248, 784, 176},
    { 2208, 736, 248},
    { 1552, 624, 344},
    { 1768, 264, 328},
    { 1672, 200, 392},
    { 1304, 376, 376},
    { 1024, 360, 288},
    { 904, 176, 200},
    { 840, 32, 248},
    { 776, -56, 264},
    { 648, -120, 248},
    { 640, -104, 216},
    { 720, 16, 248},
    // 45 seconds
    { 1136, -32, 288},
    { 1216, 432, 632},
    { 1720, 792, 176},
    { 1936, 736, -48},
    { 1672, 848, 280},
    { 904, 624, 248},
    { 664, 280, 104},
    { 840, 280, 40},
    { 904, 432, -8},
    { 1040, 784, -8},
    { 1128, 864, -48},
    { 1312, 752, 72},
    { 2032, 520, 224},
    { 1568, 608, 288},
    { 1792, 272, 400},
    { 1680, 128, 432},
    { 1432, 344, 376},
    { 1056, 400, 272},
    { 896, 208, 120},
    { 688, -32, 216},
    { 672, -16, 240},
    { 632, -80, 192},
    { 608, -88, 216},
    { 744, -32, 264},
    { 1056, -8, 368},
    // 46 seconds
    { 1352, 296, 672},
    { 1632, 800, 320},
    { 2056, 1040, -144},
    { 1768, 632, 464},
    { 944, 488, 368},
    { 680, 360, 96},
    { 680, 440, 72},
    { 664, 440, 80},
    { 952, 792, 144},
    { 1040, 1088, 112},
    { 1232, 912, 176},
    { 1744, 496, 320},
    { 1992, 728, 400},
    { 1568, 512, 424},
    { 1528, 336, 312},
    { 1456, 384, 352},
    { 1120, 360, 344},
    { 944, 184, 272},
    { 896, 128, 272},
    { 824, 72, 328},
    { 800, 16, 304},
    { 720, -64, 296},
    { 784, -48, 296},
    { 848, 48, 328},
    { 1368, 64, 512},
    // 47 seconds
    { 1104, 336, 536},
    { 1752, 728, 128},
    { 1904, 856, 56},
    { 1272, 832, 176},
    { 552, 472, 64},
    { 728, 304, 16},
    { 872, 256, 128},
    { 1160, 568, 32},
    { 1128, 928, 16},
    { 1352, 760, 32},
    { 1512, 576, 264},
    { 2280, 784, 120},
    { 1424, 440, 344},
    { 1688, 312, 336},
    { 1496, 288, 352},
    { 968, 360, 280},
    { 800, 248, 168},
    { 752, 160, 184},
    { 784, 88, 240},
    { 840, 0, 304},
    { 832, -32, 320},
    { 808, -16, 312},
    { 1088, 16, 352},
    { 1168, 224, 504},
    { 1440, 472, 264},
    // 48 seconds
    { 1904, 712, 8},
    { 1640, 592, 272},
    { 1032, 624, 224},
    { 600, 416, 32},
    { 792, 336, 0},
    { 1000, 400, 16},
    { 1040, 688, 64},
    { 1080, 832, -16},
    { 1264, 736, 72},
    { 1592, 528, 336},
    { 1920, 648, 264},
    { 1576, 400, 360},
    { 1656, 328, 376},
    { 1432, 376, 408},
    { 992, 432, 288},
    { 808, 272, 200},
    { 720, 144, 224},
    { 800, 64, 264},
    { 832, -32, 320},
    { 832, -112, 336},
    { 824, -32, 328},
    { 1040, 8, 352},
    { 1352, 32, 544},
    { 1352, 488, 464},
    { 1888, 920, -88},
    // 49 seconds
    { 1776, 880, 112},
    { 1328, 656, 464},
    { 608, 376, 160},
    { 688, 296, 24},
    { 832, 288, -48},
    { 1000, 528, -80},
    { 1088, 920, -64},
    { 1208, 744, 32},
    { 1440, 608, 216},
    { 2184, 528, 216},
    { 1448, 536, 296},
    { 1728, 256, 368},
    { 1688, 96, 552},
    { 1192, 360, 416},
    { 896, 288, 280},
    { 752, 216, 192},
    { 816, 72, 272},
    { 784, -16, 296},
    { 720, -88, 288},
    { 768, -32, 280},
    { 808, 32, 280},
    { 1336, 16, 376},
    { 1168, 352, 472},
    { 1784, 648, 96},
    { 2184, 848, 80},
    // 50 seconds
    { 1496, 776, 384},
    { 704, 520, 136},
    { 712, 248, 48},
    { 888, 336, 96},
    { 1032, 584, 48},
    { 984, 1000, 48},
    { 1136, 928, -56},
    { 1304, 752, 136},
    { 2088, 512, 176},
    { 1520, 496, 344},
    { 1856, 272, 448},
    { 1808, 184, 496},
    { 1520, 368, 424},
    { 1088, 344, 328},
    { 880, 184, 176},
    { 776, 40, 224},
    { 680, -40, 256},
    { 648, -104, 240},
    { 608, -128, 224},
    { 688, -88, 256},
    { 1016, -56, 280},
    { 1352, 376, 640},
    { 1512, 776, 304},
    { 1864, 880, -256},
    { 1968, 688, 304},
    // 51 seconds
    { 1320, 656, 424},
    { 800, 552, 136},
    { 744, 344, 96},
    { 880, 392, 8},
    { 984, 688, -104},
    { 944, 752, -32},
    { 856, 768, -24},
    { 1120, 712, 0},
    { 1752, 504, 280},
    { 2016, 656, 416},
    { 1800, 288, 688},
    { 1904, 40, 664},
    { 1576, 432, 472},
    { 1304, 312, 600},
    { 928, 8, 552},
    { 832, 144, 448},
    { 728, 80, 528},
    { 632, 80, 480},
    { 456, 144, 344},
    { 464, 472, 400},
    { 352, 712, 320},
    { 384, 880, 424},
    { 456, 1392, 496},
    { 600, 1896, -144},
    { 776, 648, 216},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:47:41 local
AccelRawData *activity_sample_walk_100_pbl_25666_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25666_4
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 384, 152, -920},
    { 376, 152, -896},
    { 376, 128, -912},
    { 392, 128, -920},
    { 392, 128, -928},
    { 392, 128, -920},
    { 392, 128, -944},
    { 408, 128, -936},
    { 400, 120, -928},
    { 416, 128, -928},
    { 408, 128, -944},
    { 400, 120, -928},
    { 408, 112, -928},
    { 416, 120, -944},
    { 416, 96, -944},
    { 408, 112, -936},
    { 408, 120, -944},
    { 376, 112, -928},
    { 376, 112, -936},
    { 384, 104, -928},
    { 384, 128, -936},
    { 392, 128, -952},
    { 384, 136, -944},
    { 384, 128, -944},
    { 400, 104, -928},
    // 1 seconds
    { 352, 120, -920},
    { 368, 112, -912},
    { 360, 128, -920},
    { 368, 112, -920},
    { 360, 120, -936},
    { 376, 136, -960},
    { 392, 152, -944},
    { 424, 136, -952},
    { 440, 160, -912},
    { 360, 112, -904},
    { 376, 120, -904},
    { 448, 144, -936},
    { 416, 112, -928},
    { 264, 184, -904},
    { 328, 72, -888},
    { 144, 224, -848},
    { 336, 160, -936},
    { 392, 168, -944},
    { 304, 56, -848},
    { 304, 80, -776},
    { 320, 32, -680},
    { 312, -48, -536},
    { 360, -56, -432},
    { 464, -72, -336},
    { 656, -40, -304},
    // 2 seconds
    { 928, -16, -280},
    { 1320, -96, -216},
    { 1816, 40, -8},
    { 2528, 376, 16},
    { 2104, 536, -48},
    { 1560, 792, -176},
    { 1408, 976, -136},
    { 1216, 576, 56},
    { 1168, 392, 16},
    { 880, 224, 24},
    { 736, 224, 8},
    { 664, 240, 8},
    { 704, 328, -80},
    { 808, 392, -104},
    { 896, 368, -96},
    { 1064, 384, -120},
    { 1168, 336, -128},
    { 1144, 240, -64},
    { 1424, 200, -24},
    { 1760, 368, -64},
    { 1424, 472, -72},
    { 1104, 320, 32},
    { 1224, 192, 16},
    { 1240, 152, 32},
    { 1128, 176, 40},
    // 3 seconds
    { 1008, 224, 64},
    { 928, 216, 96},
    { 888, 216, 104},
    { 864, 208, 104},
    { 824, 184, 80},
    { 808, 200, 40},
    { 824, 168, 0},
    { 952, 168, -8},
    { 1072, 176, -24},
    { 1136, 240, -136},
    { 1304, 144, -80},
    { 1680, 296, -128},
    { 1312, 488, -360},
    { 1024, 448, -352},
    { 1160, 360, -192},
    { 1296, 160, -88},
    { 1152, 64, -80},
    { 904, 144, -56},
    { 776, 176, -32},
    { 760, 200, -80},
    { 848, 232, -184},
    { 928, 72, -232},
    { 1000, 16, -232},
    { 1112, 200, -160},
    { 1248, 368, -64},
    // 4 seconds
    { 1336, 400, -40},
    { 1592, 272, 0},
    { 1480, 392, -88},
    { 1160, 424, -80},
    { 1056, 312, 0},
    { 1128, 264, -16},
    { 1208, 232, -16},
    { 1064, 232, 48},
    { 968, 208, 96},
    { 936, 200, 88},
    { 936, 184, 48},
    { 904, 184, 56},
    { 840, 152, 48},
    { 848, 152, -24},
    { 856, 120, -24},
    { 960, 88, -64},
    { 1048, 104, -112},
    { 1400, 8, -16},
    { 1560, 248, -184},
    { 1160, 288, -376},
    { 1224, 144, -248},
    { 1336, 48, -208},
    { 1248, 40, -64},
    { 1024, 192, -80},
    { 904, 192, -200},
    // 5 seconds
    { 872, 112, -400},
    { 808, 160, -256},
    { 768, 104, -48},
    { 824, 224, -48},
    { 912, 216, -136},
    { 1040, 176, -176},
    { 1248, 384, -104},
    { 1320, 320, -8},
    { 1728, 304, -88},
    { 1608, 496, -224},
    { 1088, 384, -88},
    { 1192, 280, -64},
    { 1248, 192, -64},
    { 1272, 128, 0},
    { 1120, 152, 40},
    { 1040, 112, 48},
    { 1024, 168, 48},
    { 960, 136, 48},
    { 832, 72, 16},
    { 760, 104, -48},
    { 712, 80, -56},
    { 768, 48, -72},
    { 824, -40, -144},
    { 856, -112, -184},
    { 1272, -120, -48},
    // 6 seconds
    { 2008, 40, -224},
    { 1544, 208, -464},
    { 1376, 128, -240},
    { 1344, 104, -104},
    { 1144, 48, 88},
    { 984, 152, 168},
    { 856, 296, 176},
    { 752, 392, 96},
    { 720, 344, 8},
    { 744, 304, 96},
    { 784, 408, -16},
    { 880, 512, -168},
    { 1064, 288, -240},
    { 1232, 376, -352},
    { 1312, 464, -296},
    { 1536, 360, -136},
    { 1528, 440, -184},
    { 1320, 440, -184},
    { 1192, 320, -96},
    { 1216, 192, -24},
    { 1280, 112, 0},
    { 1200, 120, 0},
    { 1064, 120, 0},
    { 976, 104, 24},
    { 896, 80, 16},
    // 7 seconds
    { 832, 80, 8},
    { 776, 112, 0},
    { 744, 96, 16},
    { 784, 88, 0},
    { 896, 64, 0},
    { 1024, 56, -8},
    { 1376, 24, 80},
    { 1904, 288, -80},
    { 1552, 432, -416},
    { 1088, 440, -440},
    { 1224, 272, -320},
    { 1216, 104, -88},
    { 1128, 56, -8},
    { 976, 56, -80},
    { 832, 168, -96},
    { 720, 160, -56},
    { 744, 152, -88},
    { 824, 184, -80},
    { 920, 168, -136},
    { 1048, 96, -296},
    { 1288, 176, -392},
    { 1176, 320, -152},
    { 1304, 144, -160},
    { 1648, 232, -144},
    { 1600, 488, -136},
    // 8 seconds
    { 1072, 432, -96},
    { 1056, 288, -56},
    { 1136, 232, -24},
    { 1200, 176, 8},
    { 1096, 176, 16},
    { 1000, 176, 16},
    { 976, 168, 40},
    { 968, 152, 40},
    { 928, 152, 40},
    { 872, 144, 24},
    { 848, 88, -40},
    { 880, 0, -104},
    { 992, -16, -64},
    { 1120, 0, 24},
    { 1528, 240, -64},
    { 1376, 232, -408},
    { 1048, 80, -344},
    { 1312, 120, -240},
    { 1256, 80, -96},
    { 1056, 64, -48},
    { 920, 280, -120},
    { 816, 280, -96},
    { 776, 208, -88},
    { 888, 248, -136},
    { 944, 352, -80},
    // 9 seconds
    { 1096, 488, -88},
    { 1216, 496, -168},
    { 1256, 360, -152},
    { 1208, 232, -120},
    { 1424, 192, -32},
    { 1576, 368, -80},
    { 1128, 448, -16},
    { 1176, 264, 32},
    { 1360, 224, 8},
    { 1280, 208, 80},
    { 1072, 144, 112},
    { 984, 136, 80},
    { 944, 160, 48},
    { 912, 168, 104},
    { 848, 152, 88},
    { 768, 104, 48},
    { 728, 80, 32},
    { 800, 40, 48},
    { 984, 16, -112},
    { 1144, 272, -16},
    { 1600, 320, -144},
    { 1440, 328, -472},
    { 1080, 248, -416},
    { 1288, 280, -328},
    { 1352, 136, -40},
    // 10 seconds
    { 1200, 168, 24},
    { 928, 224, -16},
    { 792, 224, -32},
    { 752, 248, -56},
    { 792, 304, -72},
    { 904, 312, -192},
    { 928, -24, -184},
    { 1176, 200, -184},
    { 1224, 520, 96},
    { 1328, 568, 152},
    { 1368, 320, 200},
    { 1384, 344, 56},
    { 1208, 424, -64},
    { 1112, 304, 112},
    { 1272, 184, 72},
    { 1224, 168, 48},
    { 1048, 224, 0},
    { 896, 224, 0},
    { 872, 184, 8},
    { 904, 120, 56},
    { 936, 144, 112},
    { 928, 248, 16},
    { 912, 264, 96},
    { 952, 280, -32},
    { 968, 48, -32},
    // 11 seconds
    { 1032, 40, -48},
    { 1360, 32, -48},
    { 1504, 192, -192},
    { 1200, 336, -432},
    { 1144, 208, -360},
    { 1240, 144, -192},
    { 1184, 200, -72},
    { 968, 312, -32},
    { 784, 304, -24},
    { 768, 296, -24},
    { 816, 192, -128},
    { 920, 248, -184},
    { 912, 304, -128},
    { 1048, 192, -128},
    { 1152, 256, -32},
    { 1264, 304, -64},
    { 1240, 240, 16},
    { 1696, 240, 0},
    { 1408, 496, -104},
    { 992, 320, -32},
    { 1216, 232, 16},
    { 1328, 192, 16},
    { 1192, 216, 40},
    { 984, 176, 8},
    { 880, 184, 8},
    // 12 seconds
    { 848, 144, 24},
    { 848, 120, 16},
    { 800, 136, 8},
    { 760, 128, -32},
    { 816, 96, -24},
    { 992, 152, -32},
    { 1096, 144, -80},
    { 1512, 88, -16},
    { 1640, 320, -184},
    { 1280, 440, -416},
    { 1088, 408, -344},
    { 1200, 304, -208},
    { 1192, 248, -56},
    { 1008, 224, -32},
    { 848, 264, -80},
    { 768, 240, -72},
    { 776, 216, -64},
    { 880, 216, -88},
    { 920, 184, -200},
    { 1088, -104, -208},
    { 1184, 184, -192},
    { 1352, 392, -160},
    { 1456, 296, -24},
    { 1560, 296, -48},
    { 1368, 400, -80},
    // 13 seconds
    { 1048, 304, -32},
    { 1128, 264, 0},
    { 1224, 216, 24},
    { 1136, 168, 72},
    { 1000, 160, 56},
    { 920, 216, 40},
    { 888, 208, 40},
    { 896, 176, 56},
    { 840, 112, 80},
    { 800, 112, 8},
    { 832, 168, -24},
    { 920, 160, -16},
    { 1040, 168, -88},
    { 1256, 64, -56},
    { 1624, 176, -120},
    { 1456, 384, -320},
    { 1088, 368, -328},
    { 1208, 256, -160},
    { 1224, 64, -24},
    { 1120, 32, -8},
    { 928, 152, -72},
    { 816, 224, -48},
    { 832, 104, -176},
    { 928, 120, -192},
    { 952, 264, 72},
    // 14 seconds
    { 1024, 272, 40},
    { 1104, 256, -32},
    { 1144, 216, 40},
    { 1208, 248, -32},
    { 1280, 176, 88},
    { 1608, 296, 32},
    { 1256, 560, -104},
    { 1080, 376, 16},
    { 1296, 280, 40},
    { 1312, 112, 56},
    { 1088, 32, 32},
    { 928, 160, -8},
    { 872, 192, 24},
    { 864, 160, 40},
    { 872, 104, 56},
    { 832, 80, 48},
    { 816, 88, 24},
    { 864, 64, 40},
    { 1040, 96, 16},
    { 1240, 136, -16},
    { 1592, 144, -72},
    { 1456, 232, -280},
    { 1104, 232, -384},
    { 1160, 176, -288},
    { 1208, 72, -40},
    // 15 seconds
    { 1216, 184, 0},
    { 976, 272, 56},
    { 824, 328, -8},
    { 760, 304, -8},
    { 776, 288, -32},
    { 896, 192, -136},
    { 976, 160, -176},
    { 1128, 152, -184},
    { 1208, 440, -40},
    { 1448, 304, 16},
    { 1696, 328, 32},
    { 1440, 384, 48},
    { 1088, 368, 48},
    { 1152, 280, 40},
    { 1152, 248, 40},
    { 1168, 232, 32},
    { 976, 168, 80},
    { 904, 136, 88},
    { 880, 144, 72},
    { 888, 184, 64},
    { 848, 152, 80},
    { 832, 144, 80},
    { 832, 112, 80},
    { 992, 88, 48},
    { 1160, 128, 16},
    // 16 seconds
    { 1400, 64, 88},
    { 1672, 256, -64},
    { 1264, 384, -296},
    { 952, 264, -264},
    { 1184, 152, -168},
    { 1248, -16, -56},
    { 1064, 48, 0},
    { 888, 136, 16},
    { 800, 264, 0},
    { 800, 344, 0},
    { 960, 320, -176},
    { 968, 240, -64},
    { 1024, 168, -24},
    { 1176, 176, 48},
    { 1280, 312, 32},
    { 1200, 376, 48},
    { 1536, 224, 104},
    { 1496, 368, -32},
    { 1048, 416, -8},
    { 1096, 216, 40},
    { 1264, 104, 8},
    { 1272, 144, 48},
    { 1072, 104, 88},
    { 968, 168, 72},
    { 920, 160, 56},
    // 17 seconds
    { 896, 136, 64},
    { 848, 96, 32},
    { 808, 144, 24},
    { 800, 104, 16},
    { 880, 96, 0},
    { 1040, 120, 0},
    { 1128, 112, -40},
    { 1584, 64, 48},
    { 1600, 272, -208},
    { 1184, 304, -312},
    { 1248, 192, -160},
    { 1344, 208, -16},
    { 1184, 176, 48},
    { 912, 200, 40},
    { 816, 240, -24},
    { 768, 264, 0},
    { 832, 104, -144},
    { 872, 120, -104},
    { 920, 168, -56},
    { 1080, 192, -96},
    { 1232, 320, -8},
    { 1328, 360, 0},
    { 1344, 280, 80},
    { 1520, 416, -24},
    { 1416, 528, -104},
    // 18 seconds
    { 992, 408, -48},
    { 1112, 328, -16},
    { 1232, 184, 40},
    { 1232, 216, 48},
    { 1048, 184, 112},
    { 944, 192, 96},
    { 936, 176, 104},
    { 936, 152, 128},
    { 920, 160, 104},
    { 880, 192, 80},
    { 856, 136, 80},
    { 952, 120, 72},
    { 1032, 128, 16},
    { 1288, 24, 64},
    { 1520, 168, -96},
    { 1224, 320, -328},
    { 992, 216, -304},
    { 1200, 96, -200},
    { 1288, 0, -56},
    { 1160, 32, -16},
    { 936, 120, -24},
    { 832, 272, -40},
    { 832, 312, -40},
    { 920, 352, -16},
    { 1032, 360, -112},
    // 19 seconds
    { 1064, 160, -104},
    { 1168, 112, -72},
    { 1240, 384, 16},
    { 1504, 272, 96},
    { 1576, 328, 64},
    { 1336, 368, 48},
    { 1064, 352, 8},
    { 1040, 304, 40},
    { 1120, 248, 48},
    { 1168, 176, 120},
    { 1008, 128, 128},
    { 968, 216, 120},
    { 880, 208, 152},
    { 888, 200, 160},
    { 872, 224, 136},
    { 840, 184, 128},
    { 896, 144, 112},
    { 1032, 176, 88},
    { 1160, 48, 80},
    { 1528, 88, 88},
    { 1416, 296, -80},
    { 1152, 336, -288},
    { 1128, 272, -392},
    { 1200, 72, -184},
    { 1256, -112, -88},
    // 20 seconds
    { 1128, -152, -232},
    { 904, 176, -88},
    { 816, 432, 80},
    { 800, 456, 128},
    { 840, 472, 136},
    { 896, 392, 56},
    { 952, 304, 72},
    { 1024, 216, 72},
    { 1208, 248, 72},
    { 1320, 240, 136},
    { 1736, 312, 96},
    { 1424, 360, -24},
    { 1232, 168, -40},
    { 1072, 152, -16},
    { 1152, 144, 8},
    { 1176, 184, 24},
    { 1024, 184, 64},
    { 928, 216, 80},
    { 912, 192, 112},
    { 904, 192, 104},
    { 856, 184, 104},
    { 840, 160, 80},
    { 840, 176, 40},
    { 872, -24, -128},
    { 984, -32, -8},
    // 21 seconds
    { 1136, 216, 0},
    { 1344, 112, 40},
    { 1840, 360, -168},
    { 1400, 592, -512},
    { 920, 544, -344},
    { 1096, 608, -280},
    { 1144, 456, -128},
    { 1104, 336, -24},
    { 920, 296, 8},
    { 768, 256, 0},
    { 688, 248, 24},
    { 736, 200, -16},
    { 800, 232, -56},
    { 872, 232, -80},
    { 1024, 248, -160},
    { 1192, 304, -200},
    { 1296, 272, -144},
    { 1656, 320, -168},
    { 1520, 408, -232},
    { 1184, 400, -208},
    { 1168, 328, -120},
    { 1200, 288, -104},
    { 1176, 224, -40},
    { 1040, 216, -16},
    { 968, 208, 0},
    // 22 seconds
    { 920, 184, 40},
    { 904, 176, 64},
    { 912, 176, 80},
    { 832, 136, 80},
    { 808, 152, 56},
    { 840, 112, 48},
    { 928, 96, 40},
    { 1040, 72, 24},
    { 1488, 104, 40},
    { 1648, 240, -216},
    { 1312, 344, -416},
    { 1224, 464, -480},
    { 1288, 376, -312},
    { 1272, 272, -184},
    { 1104, 256, -120},
    { 848, 232, -64},
    { 744, 216, -48},
    { 728, 192, -40},
    { 792, 168, -64},
    { 864, 168, -80},
    { 936, 192, -88},
    { 1128, 232, -128},
    { 1264, 208, -160},
    { 1328, 176, -96},
    { 1608, 288, -208},
    // 23 seconds
    { 1464, 320, -232},
    { 1160, 320, -232},
    { 1168, 280, -160},
    { 1224, 224, -88},
    { 1240, 200, -40},
    { 1040, 200, 8},
    { 936, 224, 8},
    { 952, 200, 40},
    { 976, 176, 88},
    { 936, 136, 88},
    { 872, 144, 56},
    { 832, 120, 48},
    { 848, 88, 32},
    { 960, 168, 16},
    { 1016, 128, -32},
    { 1296, -64, -40},
    { 1400, -8, -168},
    { 1264, 120, -384},
    { 1312, 96, -392},
    { 1392, 120, -232},
    { 1312, 160, -96},
    { 1096, 224, -80},
    { 896, 296, -104},
    { 824, 248, -96},
    { 816, 120, -128},
    // 24 seconds
    { 872, 136, -200},
    { 920, 224, -80},
    { 1056, 168, -80},
    { 1208, 240, -96},
    { 1264, 360, -88},
    { 1240, 248, -32},
    { 1632, 168, -40},
    { 1488, 288, -112},
    { 1144, 304, -64},
    { 1200, 224, -24},
    { 1264, 128, 0},
    { 1192, 128, 8},
    { 1016, 144, 40},
    { 928, 160, 32},
    { 904, 152, 40},
    { 888, 136, 40},
    { 832, 112, 56},
    { 776, 112, 40},
    { 784, 128, 16},
    { 872, 64, 16},
    { 1024, 96, 16},
    { 1144, 0, 24},
    { 1576, 8, 56},
    { 1688, 240, -192},
    { 1264, 360, -344},
    // 25 seconds
    { 1192, 344, -248},
    { 1288, 368, -96},
    { 1232, 320, -56},
    { 1008, 304, -80},
    { 824, 312, -88},
    { 768, 264, -40},
    { 824, 224, -88},
    { 944, 160, -160},
    { 1000, 32, -56},
    { 1184, -8, -40},
    { 1256, 176, -64},
    { 1272, 416, -48},
    { 1552, 216, 72},
    { 1424, 264, -56},
    { 1112, 392, -112},
    { 1048, 304, -24},
    { 1200, 200, -40},
    { 1296, 136, 16},
    { 1152, 128, 32},
    { 1040, 184, 48},
    { 936, 192, 32},
    { 904, 184, 32},
    { 864, 128, 40},
    { 800, 40, 16},
    { 800, 72, 0},
    // 26 seconds
    { 880, 104, -24},
    { 984, 56, -72},
    { 1040, -24, -40},
    { 1512, 16, 8},
    { 1568, 248, -280},
    { 1200, 312, -304},
    { 1296, 408, -208},
    { 1352, 384, -40},
    { 1184, 232, 0},
    { 928, 248, -56},
    { 784, 256, -48},
    { 744, 216, -8},
    { 784, 264, -48},
    { 928, 304, -96},
    { 1032, 288, -168},
    { 1168, 224, -184},
    { 1208, 280, -56},
    { 1272, 360, -64},
    { 1336, 256, 48},
    { 1432, 296, -48},
    { 1328, 408, -48},
    { 1032, 360, 32},
    { 1176, 272, 40},
    { 1232, 264, 48},
    { 1120, 256, 40},
    // 27 seconds
    { 1008, 232, 64},
    { 936, 216, 72},
    { 896, 176, 88},
    { 936, 192, 72},
    { 880, 176, 80},
    { 824, 200, 56},
    { 832, 152, 16},
    { 944, 88, 32},
    { 1088, 112, -16},
    { 1176, 24, 32},
    { 1552, 40, 48},
    { 1480, 296, -280},
    { 1032, 320, -408},
    { 1088, 208, -304},
    { 1208, 192, -128},
    { 1240, 144, -64},
    { 1056, 216, -64},
    { 888, 240, -64},
    { 800, 200, -64},
    { 848, 264, -128},
    { 920, 296, -72},
    { 952, 216, -56},
    { 1048, 232, -128},
    { 1200, 216, -104},
    { 1280, 288, -128},
    // 28 seconds
    { 1432, 264, 0},
    { 1592, 344, -80},
    { 1384, 472, -120},
    { 984, 416, -64},
    { 1136, 192, -32},
    { 1240, 40, 8},
    { 1168, 144, 24},
    { 1024, 208, 40},
    { 952, 232, 56},
    { 920, 184, 72},
    { 904, 152, 64},
    { 856, 168, 48},
    { 808, 136, 24},
    { 824, 112, 40},
    { 968, 112, 40},
    { 1088, 64, -8},
    { 1368, 0, 72},
    { 1584, 144, -104},
    { 1304, 312, -352},
    { 1088, 256, -368},
    { 1176, 184, -248},
    { 1256, 56, -88},
    { 1136, 128, -120},
    { 936, 128, -144},
    { 832, 152, -128},
    // 29 seconds
    { 848, 168, -128},
    { 912, 144, -168},
    { 1008, 184, -184},
    { 1064, 200, -208},
    { 1096, 184, -192},
    { 1264, 176, -200},
    { 1296, 216, -184},
    { 1208, 208, -96},
    { 1672, 208, -40},
    { 1352, 424, -304},
    { 1048, 288, -40},
    { 1296, 184, 56},
    { 1432, 168, 48},
    { 1200, 128, 88},
    { 976, 200, 96},
    { 864, 208, 80},
    { 824, 168, 56},
    { 776, 136, 64},
    { 720, 136, 24},
    { 696, 72, 8},
    { 768, 56, -8},
    { 936, 72, -24},
    { 1144, -40, 48},
    { 1664, 72, 8},
    { 1592, 304, -368},
    // 30 seconds
    { 1368, 336, -424},
    { 1424, 192, -256},
    { 1320, -32, 0},
    { 1168, 128, -24},
    { 928, 280, -64},
    { 776, 288, -80},
    { 664, 248, -40},
    { 752, 320, -80},
    { 912, 304, -96},
    { 1032, 296, -112},
    { 1200, 248, -160},
    { 1280, 304, -104},
    { 1264, 344, -120},
    { 1512, 192, 0},
    { 1496, 344, -80},
    { 1168, 400, -40},
    { 1056, 256, 48},
    { 1256, 248, 0},
    { 1280, 248, 80},
    { 1064, 168, 112},
    { 1008, 344, 80},
    { 928, 176, 128},
    { 912, 72, 120},
    { 880, 136, 80},
    { 824, 152, 48},
    // 31 seconds
    { 776, 104, 32},
    { 808, 128, 8},
    { 904, 64, 0},
    { 992, 56, -56},
    { 1448, 32, 8},
    { 1672, 224, -240},
    { 1320, 328, -376},
    { 1232, 352, -312},
    { 1360, 336, -232},
    { 1304, 184, -128},
    { 1048, 248, -120},
    { 840, 272, -136},
    { 744, 224, -112},
    { 760, 232, -104},
    { 856, 208, -136},
    { 936, 248, -152},
    { 1040, 256, -160},
    { 1240, 256, -200},
    { 1296, 248, -176},
    { 1432, 160, -24},
    { 1528, 280, -128},
    { 1328, 312, -80},
    { 1056, 256, -40},
    { 1160, 240, -48},
    { 1176, 200, -24},
    // 32 seconds
    { 1112, 168, 16},
    { 984, 192, 32},
    { 920, 216, 32},
    { 904, 192, 40},
    { 888, 168, 56},
    { 840, 168, 64},
    { 784, 128, 40},
    { 824, 120, 40},
    { 952, 104, 48},
    { 1080, 80, 16},
    { 1464, 88, 16},
    { 1648, 304, -288},
    { 1376, 336, -424},
    { 1088, 304, -376},
    { 1200, 336, -232},
    { 1264, 248, -152},
    { 1112, 264, -144},
    { 872, 256, -104},
    { 768, 216, -72},
    { 776, 200, -72},
    { 800, 168, -88},
    { 832, 176, -104},
    { 896, 200, -136},
    { 1088, 216, -176},
    { 1240, 224, -176},
    // 33 seconds
    { 1208, 232, -160},
    { 1488, 168, -64},
    { 1640, 352, -184},
    { 1096, 392, -192},
    { 1080, 296, -120},
    { 1224, 272, -128},
    { 1216, 200, -40},
    { 1048, 208, -16},
    { 920, 248, -24},
    { 944, 216, -8},
    { 920, 144, 40},
    { 912, 136, 56},
    { 824, 136, 48},
    { 752, 96, 48},
    { 888, 32, 72},
    { 1216, 104, -24},
    { 1296, -8, 80},
    { 1512, 136, -48},
    { 1400, 272, -320},
    { 1184, 296, -424},
    { 1120, 176, -248},
    { 1152, 32, -32},
    { 1168, 152, -32},
    { 1024, 248, -56},
    { 888, 312, -80},
    // 34 seconds
    { 816, 216, -24},
    { 856, 200, -16},
    { 920, 184, -88},
    { 944, 160, -64},
    { 1056, 128, -184},
    { 1144, -24, -168},
    { 1208, 192, -88},
    { 1624, 256, -32},
    { 1512, 344, -80},
    { 1304, 400, -56},
    { 1152, 288, 24},
    { 1200, 240, 0},
    { 1216, 136, 24},
    { 1080, 168, 40},
    { 960, 208, 48},
    { 904, 192, 80},
    { 888, 184, 64},
    { 880, 160, 72},
    { 848, 152, 72},
    { 848, 144, 40},
    { 904, 120, 24},
    { 1056, 120, 32},
    { 1120, 72, 24},
    { 1472, 40, 104},
    { 1576, 256, -136},
    // 35 seconds
    { 1176, 320, -280},
    { 1176, 272, -256},
    { 1296, 160, -168},
    { 1224, 128, -16},
    { 984, 200, -48},
    { 856, 192, -72},
    { 776, 184, -40},
    { 768, 184, -48},
    { 832, 208, -104},
    { 888, 184, -112},
    { 1000, 200, -160},
    { 1200, 216, -120},
    { 1328, 232, -128},
    { 1552, 168, 0},
    { 1528, 312, -104},
    { 1392, 432, -136},
    { 1152, 288, 24},
    { 1200, 216, 16},
    { 1232, 232, 8},
    { 1072, 184, 40},
    { 936, 152, 96},
    { 936, 152, 96},
    { 960, 224, 88},
    { 920, 168, 144},
    { 872, 104, 112},
    // 36 seconds
    { 856, 104, 96},
    { 832, 64, 136},
    { 920, 136, 120},
    { 1112, 192, 104},
    { 1528, 352, 40},
    { 1392, 136, -192},
    { 1152, 64, -408},
    { 1216, 80, -376},
    { 1288, 32, -200},
    { 1248, 0, -96},
    { 1064, 152, -184},
    { 904, 264, -200},
    { 792, 176, -96},
    { 824, 176, -104},
    { 920, 120, -160},
    { 936, 120, -120},
    { 1064, 88, -112},
    { 1176, 216, -128},
    { 1280, 328, -96},
    { 1488, 136, 56},
    { 1592, 328, -64},
    { 1304, 448, -112},
    { 1048, 288, 0},
    { 1184, 240, -56},
    { 1248, 200, -40},
    // 37 seconds
    { 1096, 152, 24},
    { 976, 152, 32},
    { 936, 152, 40},
    { 928, 160, 64},
    { 920, 168, 80},
    { 864, 128, 80},
    { 816, 128, 56},
    { 848, 128, 40},
    { 960, 72, 40},
    { 1056, 56, -32},
    { 1384, -8, 56},
    { 1600, 168, -128},
    { 1280, 288, -296},
    { 1192, 304, -264},
    { 1336, 408, -256},
    { 1288, 264, -144},
    { 1064, 240, -120},
    { 848, 256, -88},
    { 768, 264, -64},
    { 768, 216, -32},
    { 832, 256, -80},
    { 896, 248, -104},
    { 1008, 248, -112},
    { 1216, 272, -152},
    { 1312, 280, -144},
    // 38 seconds
    { 1328, 216, -32},
    { 1576, 272, -72},
    { 1480, 384, -136},
    { 1032, 336, -120},
    { 1080, 240, -64},
    { 1152, 200, -48},
    { 1200, 128, -8},
    { 1056, 200, 48},
    { 936, 232, 80},
    { 888, 208, 104},
    { 856, 192, 104},
    { 848, 184, 112},
    { 840, 184, 88},
    { 832, 152, 56},
    { 944, 112, 72},
    { 1080, 88, 72},
    { 1464, 64, 80},
    { 1496, 88, -144},
    { 1352, 264, -400},
    { 1112, 392, -432},
    { 1128, 360, -288},
    { 1272, 272, -176},
    { 1208, 288, -168},
    { 936, 288, -104},
    { 792, 256, -56},
    // 39 seconds
    { 760, 256, -48},
    { 800, 232, -40},
    { 848, 272, -80},
    { 880, 280, -96},
    { 1088, 304, -120},
    { 1312, 320, -160},
    { 1600, 232, -32},
    { 1664, 392, -152},
    { 1360, 432, -168},
    { 1016, 312, -144},
    { 1080, 248, -112},
    { 1144, 192, -56},
    { 1104, 160, -56},
    { 992, 208, 24},
    { 936, 208, 40},
    { 944, 176, 40},
    { 944, 168, 56},
    { 904, 152, 88},
    { 880, 160, 80},
    { 936, 112, 72},
    { 1024, 104, 96},
    { 1096, 72, 128},
    { 1480, 152, 96},
    { 1352, 176, -184},
    { 1000, 232, -328},
    // 40 seconds
    { 1144, 272, -328},
    { 1320, 184, -200},
    { 1256, 112, -104},
    { 1024, 160, -104},
    { 880, 240, -136},
    { 824, 240, -136},
    { 888, 256, -152},
    { 944, 256, -200},
    { 1032, 264, -120},
    { 1168, 240, -120},
    { 1264, 224, -112},
    { 1360, 304, -96},
    { 1576, 240, 48},
    { 1552, 392, -32},
    { 1200, 384, -64},
    { 1032, 168, 24},
    { 1152, 208, -32},
    { 1224, 136, -8},
    { 1096, 88, 40},
    { 960, 160, 56},
    { 880, 184, 56},
    { 856, 168, 40},
    { 856, 144, 48},
    { 832, 120, 48},
    { 800, 64, 16},
    // 41 seconds
    { 872, 40, 16},
    { 1032, 32, 8},
    { 1224, 8, 40},
    { 1584, 8, 8},
    { 1496, 136, -272},
    { 1168, 144, -416},
    { 1168, 0, -264},
    { 1240, 24, -240},
    { 1256, 216, -64},
    { 1096, 408, 8},
    { 864, 448, 32},
    { 800, 376, 0},
    { 912, 184, -160},
    { 944, 144, -112},
    { 960, 160, 8},
    { 1072, 200, -48},
    { 1184, 208, -16},
    { 1256, 312, -48},
    { 1456, 256, 88},
    { 1544, 360, -40},
    { 1168, 440, -72},
    { 1128, 288, 40},
    { 1288, 224, -32},
    { 1304, 128, 40},
    { 1112, 184, 48},
    // 42 seconds
    { 952, 176, 40},
    { 856, 136, 56},
    { 872, 144, 32},
    { 840, 104, 64},
    { 792, 120, 40},
    { 792, 104, 8},
    { 888, 88, 8},
    { 1024, 64, 8},
    { 1400, 64, 48},
    { 1528, 104, -136},
    { 1384, 184, -408},
    { 1264, 216, -480},
    { 1272, 64, -288},
    { 1256, -48, -80},
    { 1152, 104, 0},
    { 976, 224, -72},
    { 840, 232, -64},
    { 824, 104, -112},
    { 776, -8, -176},
    { 784, 184, -136},
    { 872, 176, -144},
    { 1088, 184, -104},
    { 1416, 288, -144},
    { 1688, 288, -24},
    { 1616, 344, -88},
    // 43 seconds
    { 1384, 360, -104},
    { 1104, 296, -64},
    { 1136, 232, -24},
    { 1168, 144, -24},
    { 1088, 128, 8},
    { 960, 144, 48},
    { 912, 176, 80},
    { 912, 168, 72},
    { 864, 128, 96},
    { 832, 128, 104},
    { 824, 136, 88},
    { 936, 112, 88},
    { 1112, 120, 96},
    { 1296, 96, 80},
    { 1664, 56, 128},
    { 1408, 232, -128},
    { 960, 288, -320},
    { 1008, 136, -232},
    { 1104, 80, -136},
    { 1256, 152, -104},
    { 1064, 256, -64},
    { 880, 320, -64},
    { 872, 400, -88},
    { 976, 360, -128},
    { 1024, 264, -128},
    // 44 seconds
    { 992, 248, -136},
    { 1040, 240, -128},
    { 1200, 264, -152},
    { 1248, 280, -112},
    { 1600, 192, 32},
    { 1432, 352, -96},
    { 1160, 304, 8},
    { 1240, 232, 80},
    { 1336, 216, 24},
    { 1224, 136, 72},
    { 1032, 184, 88},
    { 936, 192, 56},
    { 872, 160, 72},
    { 864, 144, 80},
    { 848, 144, 80},
    { 800, 144, 48},
    { 776, 112, 40},
    { 904, 40, 56},
    { 1064, 64, -16},
    { 1320, -16, 96},
    { 1544, 80, -40},
    { 1456, 248, -352},
    { 1280, 304, -368},
    { 1296, 352, -304},
    { 1304, 240, -104},
    // 45 seconds
    { 1128, 232, -112},
    { 896, 240, -88},
    { 760, 288, -88},
    { 744, 288, -48},
    { 816, 224, -48},
    { 912, 248, -72},
    { 976, 280, -96},
    { 1160, 272, -128},
    { 1296, 280, -160},
    { 1440, 200, -16},
    { 1600, 312, -128},
    { 1368, 416, -64},
    { 1048, 344, -24},
    { 1136, 248, -16},
    { 1152, 216, -64},
    { 1144, 160, 0},
    { 1032, 248, 16},
    { 952, 248, 64},
    { 944, 184, 88},
    { 960, 184, 88},
    { 936, 168, 104},
    { 880, 152, 88},
    { 904, 136, 88},
    { 1032, 104, 72},
    { 1128, 40, 104},
    // 46 seconds
    { 1376, 104, 48},
    { 1304, 152, -176},
    { 1168, 152, -344},
    { 1120, 112, -328},
    { 1208, 64, -176},
    { 1272, 104, -128},
    { 1120, 248, -160},
    { 880, 256, -128},
    { 800, 224, -88},
    { 880, 224, -144},
    { 960, 232, -176},
    { 992, 216, -200},
    { 1072, 232, -208},
    { 1240, 272, -272},
    { 1320, 224, -256},
    { 1528, 160, -144},
    { 1568, 216, -160},
    { 1320, 320, -128},
    { 1072, 272, -56},
    { 1152, 216, -64},
    { 1232, 192, -32},
    { 1120, 160, 32},
    { 960, 192, 72},
    { 896, 192, 72},
    { 912, 208, 64},
    // 47 seconds
    { 896, 176, 88},
    { 848, 168, 96},
    { 816, 144, 48},
    { 888, 112, 48},
    { 1008, 80, 32},
    { 1128, 32, 16},
    { 1464, 48, 40},
    { 1464, 184, -192},
    { 1224, 224, -384},
    { 1224, 192, -336},
    { 1296, 112, -232},
    { 1336, 184, -96},
    { 1128, 272, -48},
    { 872, 272, -32},
    { 744, 240, -24},
    { 728, 304, -40},
    { 840, 328, -104},
    { 896, 352, -96},
    { 1040, 288, -120},
    { 1272, 480, -80},
    { 1384, 440, -72},
    { 1736, 368, -56},
    { 1472, 400, -32},
    { 1208, 384, -64},
    { 1160, 296, -32},
    // 48 seconds
    { 1160, 200, -48},
    { 1224, 192, -48},
    { 1088, 184, 16},
    { 952, 168, 48},
    { 928, 176, 64},
    { 888, 168, 88},
    { 848, 176, 96},
    { 816, 160, 56},
    { 752, 136, 56},
    { 848, 144, 40},
    { 960, 96, 8},
    { 1128, 0, 40},
    { 1632, 136, -32},
    { 1520, 328, -344},
    { 1120, 296, -336},
    { 1232, 248, -224},
    { 1280, 104, -32},
    { 1176, 64, 16},
    { 952, 152, -32},
    { 840, 296, -104},
    { 816, 272, -112},
    { 920, 296, -160},
    { 1040, 256, -160},
    { 1056, 208, -128},
    { 1072, 256, -104},
    // 49 seconds
    { 1248, 48, -48},
    { 1336, 184, -64},
    { 1432, 216, 32},
    { 1392, 264, 8},
    { 1256, 392, -72},
    { 1040, 336, -40},
    { 1240, 256, -40},
    { 1352, 224, 24},
    { 1168, 192, 88},
    { 1000, 176, 72},
    { 920, 192, 64},
    { 880, 184, 80},
    { 856, 136, 80},
    { 840, 136, 64},
    { 840, 128, 88},
    { 904, 64, 88},
    { 1048, 88, 32},
    { 1128, 40, 8},
    { 1512, 72, -8},
    { 1416, 224, -296},
    { 1016, 152, -304},
    { 1192, 136, -288},
    { 1352, 168, -248},
    { 1264, 248, -64},
    { 960, 264, 8},
    // 50 seconds
    { 832, 240, -32},
    { 824, 296, -96},
    { 848, 304, -96},
    { 920, 296, -88},
    { 976, 304, -72},
    { 1128, 312, -72},
    { 1288, 312, -16},
    { 1408, 304, 96},
    { 1680, 360, 24},
    { 1488, 408, -56},
    { 1016, 416, -24},
    { 1096, -40, 144},
    { 1120, 88, -24},
    { 1192, 296, -24},
    { 1056, 264, 72},
    { 944, 144, 120},
    { 920, 120, 120},
    { 920, 200, 120},
    { 888, 184, 104},
    { 856, 184, 80},
    { 840, 128, 96},
    { 952, 120, 104},
    { 1008, 136, 56},
    { 1232, 16, 112},
    { 1600, 248, -32},
    // 51 seconds
    { 1168, 400, -232},
    { 1240, 360, -192},
    { 1472, 320, -208},
    { 1272, 184, -120},
    { 904, 192, -72},
    { 792, 248, -144},
    { 760, 280, -104},
    { 768, 240, -120},
    { 856, 248, -160},
    { 944, 288, -176},
    { 1072, 312, -200},
    { 1264, 280, -200},
    { 1272, 336, -136},
    { 1528, 264, -104},
    { 1592, 400, -160},
    { 1152, 384, 8},
    { 1272, 368, -24},
    { 1424, 360, -72},
    { 1280, 264, 32},
    { 1024, 192, 96},
    { 960, 200, 56},
    { 920, 192, 56},
    { 888, 160, 88},
    { 840, 160, 96},
    { 752, 112, 80},
    // 52 seconds
    { 736, 104, 96},
    { 848, 112, 56},
    { 944, 80, 16},
    { 1280, -8, 56},
    { 1544, 112, -128},
    { 1320, 240, -296},
    { 1352, 264, -296},
    { 1456, 360, -280},
    { 1384, 296, -176},
    { 1048, 192, -88},
    { 856, 256, -136},
    { 784, 288, -144},
    { 768, 248, -136},
    { 880, 320, -352},
    { 944, 232, -160},
    { 1088, 416, -48},
    { 1320, 552, -216},
    { 1384, 464, -136},
    { 1568, 264, 72},
    { 1632, 400, 0},
    { 1216, 456, -8},
    { 1032, 240, 72},
    { 1184, 216, 0},
    { 1248, 192, -8},
    { 1064, 160, 96},
    // 53 seconds
    { 912, 168, 128},
    { 840, 160, 72},
    { 816, 160, 64},
    { 784, 160, 80},
    { 752, 160, 72},
    { 768, 112, 32},
    { 912, 64, 24},
    { 1056, 64, 40},
    { 1520, 40, 152},
    { 1664, 272, -104},
    { 1416, 440, -408},
    { 1224, 416, -416},
    { 1280, 328, -272},
    { 1296, 136, -104},
    { 1120, 128, -96},
    { 888, 144, -112},
    { 784, 144, -144},
    { 760, 176, -128},
    { 832, 192, -160},
    { 904, 136, -168},
    { 1048, -32, -144},
    { 1248, 40, -192},
    { 1424, 280, -248},
    { 1512, 240, -24},
    { 1624, 272, -120},
    // 54 seconds
    { 1312, 368, -128},
    { 1136, 248, 8},
    { 1216, 232, -40},
    { 1248, 200, -32},
    { 1096, 200, 8},
    { 968, 168, 48},
    { 912, 144, 40},
    { 920, 136, 40},
    { 904, 144, 72},
    { 848, 104, 48},
    { 816, 96, 48},
    { 840, 80, 24},
    { 936, 48, 24},
    { 1104, -8, 32},
    { 1488, 40, 8},
    { 1504, 160, -200},
    { 1280, 264, -328},
    { 1272, 96, -216},
    { 1360, 216, -176},
    { 1240, 352, -104},
    { 1016, 320, -48},
    { 856, 288, -48},
    { 792, 272, -64},
    { 824, 280, -56},
    { 880, 336, -40},
    // 55 seconds
    { 976, 368, -48},
    { 1040, 352, -16},
    { 1280, 328, -40},
    { 1352, 336, -16},
    { 1568, 288, 48},
    { 1528, 344, 8},
    { 1336, 392, -16},
    { 1064, 280, 0},
    { 1128, 248, -16},
    { 1208, 120, 56},
    { 1096, 136, 88},
    { 960, 176, 112},
    { 896, 192, 80},
    { 888, 208, 96},
    { 864, 192, 104},
    { 840, 168, 112},
    { 808, 136, 72},
    { 888, 96, 64},
    { 1048, 88, 64},
    { 1184, 0, 96},
    { 1552, 80, 96},
    { 1456, 272, -176},
    { 1152, 376, -368},
    { 1168, 304, -336},
    { 1272, 304, -208},
    // 56 seconds
    { 1264, 272, -88},
    { 992, 328, -128},
    { 824, 328, -120},
    { 760, 296, -104},
    { 784, 256, -104},
    { 848, 248, -128},
    { 856, 304, -144},
    { 992, 312, -136},
    { 1208, 320, -168},
    { 1448, 200, 48},
    { 1912, 432, -32},
    { 1496, 472, -104},
    { 1136, 272, 32},
    { 1264, 280, -40},
    { 1272, 136, 16},
    { 1096, 48, 8},
    { 944, 160, 8},
    { 880, 184, 32},
    { 856, 152, 48},
    { 800, 120, 48},
    { 752, 160, 32},
    { 768, 128, 32},
    { 872, 120, 56},
    { 1032, 112, 56},
    { 1496, 64, 184},
    // 57 seconds
    { 1544, 304, -64},
    { 1184, 376, -304},
    { 1360, 400, -384},
    { 1400, 432, -256},
    { 1264, 152, -16},
    { 1000, 224, -104},
    { 816, 312, -144},
    { 704, 288, -120},
    { 704, 248, -104},
    { 808, 280, -168},
    { 896, 312, -160},
    { 1064, 328, -176},
    { 1296, 352, -184},
    { 1392, 328, -56},
    { 1768, 456, -120},
    { 1384, 488, -96},
    { 1184, 352, 0},
    { 1272, 312, 0},
    { 1328, 288, 16},
    { 1104, 248, 40},
    { 904, 232, 56},
    { 856, 248, 40},
    { 896, 216, 80},
    { 936, 200, 96},
    { 872, 136, 88},
    // 58 seconds
    { 784, 136, 88},
    { 840, 72, 64},
    { 920, 40, 56},
    { 1216, -24, 24},
    { 1352, 144, -56},
    { 1392, 272, -320},
    { 1304, 360, -432},
    { 1416, 536, -496},
    { 1392, 432, -272},
    { 1160, 296, -128},
    { 888, 224, -24},
    { 728, 208, -8},
    { 736, 288, -32},
    { 808, 336, -8},
    { 872, 344, 40},
    { 888, 232, 72},
    { 1008, 280, 64},
    { 1264, 456, 16},
    { 1448, 472, 56},
    { 1704, 592, -32},
    { 1424, 496, -80},
    { 1080, 528, -88},
    { 1264, 488, -24},
    { 1176, 144, 32},
    { 1152, 144, 16},
    // 59 seconds
    { 960, 184, 24},
    { 888, 184, 72},
    { 936, 264, 72},
    { 920, 216, 112},
    { 888, 144, 136},
    { 864, 136, 144},
    { 904, 136, 104},
    { 1008, 192, 40},
    { 1032, 216, 72},
    { 1248, 104, 72},
    { 1432, 168, 0},
    { 1088, 352, -296},
    { 1040, 288, -248},
    { 1344, 336, -208},
    { 1376, 304, -88},
    { 1056, 208, 16},
    { 856, 200, 40},
    { 808, 240, -8},
    { 816, 320, -16},
    { 928, 248, -184},
    { 952, 232, -256},
    { 1064, 184, -168},
    { 1248, 416, -104},
    { 1368, 424, -96},
    { 1232, 272, 40},
    // 60 seconds
    // elapsed: 1 minutes
    { 1544, 248, 0},
    { 1400, 400, -64},
    { 1080, 416, -48},
    { 1152, 344, 8},
    { 1312, 248, -16},
    { 1256, 176, 64},
    { 1048, 240, 80},
    { 920, 192, 64},
    { 864, 112, 16},
    { 832, 88, 24},
    { 808, 80, 32},
    { 776, 88, 40},
    { 784, 96, 8},
    { 920, 96, 32},
    { 1216, 32, -24},
    { 1576, 16, 32},
    { 1496, 168, -64},
    { 1392, 312, -320},
    { 1376, 376, -472},
    { 1216, 216, -272},
    { 1160, 32, -80},
    { 1128, 112, -88},
    { 912, 200, -72},
    { 792, 296, -64},
    { 776, 272, -48},
    // 61 seconds
    { 784, 200, -56},
    { 888, 232, -88},
    { 944, 272, -104},
    { 1008, 208, -152},
    { 1176, 184, -248},
    { 1376, 208, -120},
    { 1776, 248, -16},
    { 1568, 304, -48},
    { 1336, 408, -64},
    { 1048, 312, -64},
    { 1080, 240, -8},
    { 1176, 184, 24},
    { 1064, 168, 32},
    { 936, 192, 88},
    { 872, 192, 96},
    { 872, 192, 88},
    { 864, 176, 88},
    { 856, 176, 88},
    { 848, 120, 64},
    { 936, 104, 64},
    { 1056, 104, 56},
    { 1216, 8, 128},
    { 1560, 160, 56},
    { 1288, 368, -312},
    { 1064, 320, -328},
    // 62 seconds
    { 1216, 232, -208},
    { 1280, 72, -40},
    { 1144, 64, -32},
    { 928, 232, -104},
    { 824, 264, -96},
    { 816, 312, -120},
    { 912, 320, -136},
    { 992, 240, -144},
    { 1032, 208, -176},
    { 1248, 48, -200},
    { 1280, 120, -96},
    { 1344, 208, -32},
    { 1672, 312, -96},
    { 1536, 328, -88},
    { 1112, 304, -8},
    { 1200, 224, 56},
    { 1280, 160, 56},
    { 1144, 200, 72},
    { 952, 192, 96},
    { 880, 200, 104},
    { 888, 208, 104},
    { 904, 176, 120},
    { 864, 144, 120},
    { 832, 136, 88},
    { 832, 136, 48},
    // 63 seconds
    { 936, 104, 40},
    { 1040, 136, -8},
    { 1464, 72, 72},
    { 1536, 208, -232},
    { 1232, 208, -416},
    { 1256, 152, -392},
    { 1360, 160, -288},
    { 1296, -24, -120},
    { 1072, 56, -96},
    { 888, 192, -144},
    { 784, 200, -120},
    { 784, 208, -128},
    { 856, 216, -144},
    { 944, 184, -160},
    { 1024, 168, -160},
    { 1160, 168, -168},
    { 1216, 184, -176},
    { 1176, 176, -128},
    { 1576, 136, -64},
    { 1552, 336, -168},
    { 1296, 424, -176},
    { 1200, 392, -104},
    { 1400, 440, -56},
    { 1400, 432, 24},
    { 1248, 440, 8},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:49:13 local
AccelRawData *activity_sample_walk_100_pbl_25666_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25666_5
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 328, 304, -912},
    { 344, 280, -904},
    { 376, 288, -912},
    { 400, 272, -928},
    { 408, 256, -936},
    { 456, 248, -920},
    { 664, -352, -848},
    { 456, 304, -968},
    { 424, 280, -1000},
    { 480, 264, -1032},
    { 456, 216, -992},
    { 440, 184, -888},
    { 472, 136, -848},
    { 368, 152, -808},
    { 480, 88, -840},
    { 448, 72, -888},
    { 440, 48, -872},
    { 440, 48, -872},
    { 360, 64, -848},
    { 384, 16, -880},
    { 392, 32, -912},
    { 368, 56, -968},
    { 360, 64, -984},
    { 368, 80, -976},
    { 328, 56, -976},
    // 1 seconds
    { 360, 40, -944},
    { 336, -32, -912},
    { 400, 16, -952},
    { 408, 40, -952},
    { 376, 40, -904},
    { 328, -88, -920},
    { 520, -72, -888},
    { 304, -56, -696},
    { 472, -56, -776},
    { 288, -112, -576},
    { 416, -240, -480},
    { 520, -184, -440},
    { 624, -88, -448},
    { 856, 56, -496},
    { 1096, 48, -672},
    { 1112, 56, -416},
    { 1232, 248, -160},
    { 1576, 504, -168},
    { 1584, 592, -40},
    { 1736, 640, -128},
    { 1856, 1128, -464},
    { 1240, 736, -24},
    { 904, 320, -112},
    { 856, 272, -208},
    { 896, 416, -184},
    // 2 seconds
    { 880, 336, -88},
    { 976, 224, -56},
    { 1144, 168, -40},
    { 1296, 64, -16},
    { 1240, 176, -104},
    { 1584, 32, -112},
    { 1264, 144, -248},
    { 1336, -112, -48},
    { 1328, -176, 112},
    { 1104, 16, 136},
    { 800, 240, 32},
    { 624, 184, -72},
    { 504, 296, -16},
    { 488, 176, 40},
    { 592, 80, 8},
    { 752, 72, -40},
    { 984, 96, -64},
    { 1264, 144, -104},
    { 1584, 16, -56},
    { 1936, 320, -152},
    { 1376, 712, -224},
    { 1504, 472, -112},
    { 1648, 256, -112},
    { 1392, 280, -80},
    { 1008, 264, -56},
    // 3 seconds
    { 920, 208, -64},
    { 888, 184, 8},
    { 856, 128, 56},
    { 792, 56, 48},
    { 744, 56, 32},
    { 768, 40, 32},
    { 872, 96, 8},
    { 1064, 8, -24},
    { 1512, 112, -160},
    { 1248, 256, -408},
    { 1224, 144, -424},
    { 1512, 184, -344},
    { 1424, 336, -136},
    { 1040, 400, 0},
    { 792, 424, -40},
    { 776, 232, -88},
    { 688, 192, 8},
    { 736, 224, -64},
    { 840, 304, -72},
    { 904, 360, -136},
    { 1184, 384, -184},
    { 1464, 408, -152},
    { 2144, 496, -144},
    { 1448, 400, -216},
    { 1312, 376, -176},
    // 4 seconds
    { 1472, 336, -104},
    { 1432, 280, -32},
    { 1136, 296, 8},
    { 888, 336, 24},
    { 792, 440, 80},
    { 720, 504, 152},
    { 672, 552, 232},
    { 616, 624, 256},
    { 504, 600, 296},
    { 416, 632, 304},
    { 344, 776, 360},
    { 272, 832, 336},
    { 280, 1048, 464},
    { 352, 1200, 328},
    { 216, 1120, 160},
    { 552, 1392, -296},
    { 552, 1096, 0},
    { 560, 888, -8},
    { 392, 368, -32},
    { 248, 128, -88},
    { 200, 120, -184},
    { 280, 296, -232},
    { 448, 504, -232},
    { 512, 488, -128},
    { 648, 392, -56},
    // 5 seconds
    { 968, 360, 72},
    { 1936, 0, 248},
    { 2376, 1168, 416},
    { 1968, 1760, 200},
    { 1080, 1384, 424},
    { 1160, 520, 408},
    { 1072, 400, 296},
    { 880, 128, 64},
    { 800, 64, 56},
    { 744, 216, 112},
    { 720, 328, 144},
    { 744, 360, 152},
    { 728, 296, 176},
    { 960, 224, 176},
    { 1272, 240, 248},
    { 1336, 256, 344},
    { 1848, 384, 288},
    { 1176, 712, -32},
    { 1112, 456, -80},
    { 1376, 24, -160},
    { 1184, -504, 96},
    { 792, 552, 72},
    { 720, 320, 144},
    { 584, 344, 176},
    { 560, 360, 136},
    // 6 seconds
    { 672, 360, 152},
    { 792, 392, 72},
    { 976, 400, 72},
    { 1160, 432, 64},
    { 1288, 464, 112},
    { 1656, 416, 248},
    { 1536, 712, 200},
    { 1216, 680, 8},
    { 1136, 408, 152},
    { 1296, 416, 288},
    { 1208, 480, 376},
    { 912, 304, 224},
    { 792, 216, 184},
    { 752, 248, 168},
    { 784, 240, 192},
    { 840, 192, 232},
    { 824, 184, 224},
    { 880, 176, 208},
    { 1056, 336, 248},
    { 1264, 600, 408},
    { 1552, 880, 408},
    { 1160, 1216, 152},
    { 824, 1160, -56},
    { 696, 1000, -120},
    { 752, 816, -56},
    // 7 seconds
    { 864, 560, -152},
    { 800, 368, -272},
    { 632, 128, -112},
    { 576, 256, -112},
    { 648, 496, -136},
    { 640, 520, -56},
    { 608, 768, 56},
    { 536, 864, 16},
    { 512, 1008, 280},
    { 504, 1120, 400},
    { 432, 1040, 496},
    { 600, 960, 696},
    { 712, 1048, 680},
    { 472, 984, 456},
    { 432, 728, 368},
    { 536, 760, 568},
    { 544, 672, 632},
    { 552, 512, 568},
    { 456, 536, 544},
    { 440, 456, 568},
    { 400, 304, 640},
    { 384, 416, 688},
    { 280, 528, 784},
    { 200, 592, 848},
    { 240, 552, 936},
    // 8 seconds
    { 376, 640, 1000},
    { 552, 712, 1376},
    { 352, 896, 1008},
    { 488, 888, 688},
    { 592, 696, 712},
    { 648, 520, 664},
    { 616, 472, 608},
    { 480, 368, 440},
    { 400, 336, 496},
    { 296, 480, 504},
    { 288, 496, 624},
    { 208, 640, 728},
    { 192, 744, 808},
    { 256, 824, 848},
    { 368, 872, 912},
    { 520, 784, 984},
    { 568, 752, 1096},
    { 464, 664, 1016},
    { 536, 544, 776},
    { 544, 528, 776},
    { 512, 544, 792},
    { 472, 464, 664},
    { 416, 408, 544},
    { 448, 392, 504},
    { 464, 352, 496},
    // 9 seconds
    { 488, 408, 504},
    { 480, 528, 528},
    { 536, 544, 520},
    { 728, 648, 488},
    { 880, 520, 496},
    { 1168, 552, 496},
    { 1232, 648, 504},
    { 1016, 1032, 216},
    { 1056, 944, 136},
    { 1200, 608, 200},
    { 1160, 504, 112},
    { 904, 392, 152},
    { 712, 384, 168},
    { 632, 288, 176},
    { 672, 216, -16},
    { 704, 184, 8},
    { 784, 264, -24},
    { 904, 256, -56},
    { 1288, 504, -280},
    { 1920, 632, -296},
    { 1824, 936, -328},
    { 1440, 648, -384},
    { 1280, 496, -344},
    { 1184, 288, -224},
    { 1200, 200, -104},
    // 10 seconds
    { 1120, 176, -64},
    { 1016, 176, 16},
    { 944, 184, 32},
    { 880, 144, 64},
    { 856, 152, 64},
    { 816, 160, 48},
    { 768, 80, 56},
    { 888, 88, 8},
    { 1032, 88, -24},
    { 1256, -8, 32},
    { 1528, 112, -104},
    { 1224, 192, -328},
    { 1240, 176, -288},
    { 1408, 360, -344},
    { 1304, 288, -200},
    { 1008, 192, -56},
    { 808, 384, -80},
    { 768, 328, -120},
    { 752, 424, -120},
    { 824, 320, -184},
    { 960, 400, -224},
    { 1088, 504, -272},
    { 1376, 528, -296},
    { 1664, 456, -136},
    { 1840, 512, -136},
    // 11 seconds
    { 1256, 496, -120},
    { 1200, 352, -40},
    { 1200, 312, 0},
    { 1128, 232, 32},
    { 968, 240, 80},
    { 848, 208, 104},
    { 816, 248, 96},
    { 824, 200, 128},
    { 864, 192, 96},
    { 856, 144, 72},
    { 880, 136, 48},
    { 1008, 120, 32},
    { 1128, 16, 40},
    { 1424, 88, 16},
    { 1296, 248, -296},
    { 1112, 240, -360},
    { 1320, 344, -360},
    { 1376, 472, -288},
    { 1200, 456, -144},
    { 920, 392, -48},
    { 840, 336, -112},
    { 800, 264, -80},
    { 832, 320, -120},
    { 920, 384, -152},
    { 920, 440, -144},
    // 12 seconds
    { 1144, 488, -248},
    { 1304, 440, -168},
    { 1736, 352, -32},
    { 1608, 456, -64},
    { 1136, 376, -16},
    { 1344, 336, 48},
    { 1376, 296, 40},
    { 1168, 216, 48},
    { 944, 216, 72},
    { 840, 264, 32},
    { 832, 216, 24},
    { 840, 152, 48},
    { 832, 136, 40},
    { 792, 104, 16},
    { 824, 80, 0},
    { 928, 32, -16},
    { 1176, -80, 88},
    { 1432, 112, -16},
    { 1256, 272, -304},
    { 1344, 328, -368},
    { 1456, 456, -344},
    { 1320, 600, -200},
    { 1040, 360, -40},
    { 880, 304, -88},
    { 768, 288, -24},
    // 13 seconds
    { 728, 376, -32},
    { 816, 432, -80},
    { 896, 456, -80},
    { 1048, 520, -144},
    { 1288, 568, -184},
    { 1376, 464, -72},
    { 1720, 464, -80},
    { 1504, 480, -72},
    { 1048, 384, -56},
    { 1176, 336, -32},
    { 1248, 288, 8},
    { 1168, 208, 80},
    { 992, 192, 104},
    { 896, 240, 96},
    { 872, 192, 104},
    { 888, 192, 96},
    { 856, 200, 88},
    { 832, 120, 40},
    { 816, 80, -16},
    { 912, 104, 0},
    { 1032, 168, -40},
    { 1392, 232, -48},
    { 1624, 432, -280},
    { 1152, 448, -464},
    { 1120, 536, -576},
    // 14 seconds
    { 1192, 312, -384},
    { 1184, 288, -296},
    { 992, 320, -224},
    { 824, 232, -176},
    { 768, 288, -144},
    { 816, 400, -184},
    { 872, 248, -152},
    { 896, 232, -176},
    { 1000, 272, -200},
    { 1192, 312, -272},
    { 1272, 280, -232},
    { 1680, 288, -208},
    { 1528, 296, -264},
    { 1128, 296, -232},
    { 1088, 304, -192},
    { 1184, 240, -152},
    { 1160, 232, -80},
    { 1016, 256, -56},
    { 920, 232, -72},
    { 864, 192, -56},
    { 864, 184, -72},
    { 824, 176, -16},
    { 816, 176, -48},
    { 832, 152, -48},
    { 976, 160, -56},
    // 15 seconds
    { 1120, 128, -56},
    { 1344, 88, 16},
    { 1520, 232, -144},
    { 1280, 392, -344},
    { 1032, 312, -392},
    { 1152, 376, -384},
    { 1168, 280, -112},
    { 1064, 256, -40},
    { 864, 336, -56},
    { 776, 384, -112},
    { 776, 320, -48},
    { 848, 304, -104},
    { 928, 328, -128},
    { 968, 424, -160},
    { 1160, 432, -208},
    { 1304, 432, -192},
    { 1256, 352, -88},
    { 1696, 424, -120},
    { 1296, 448, -80},
    { 992, 368, -88},
    { 1192, 376, -104},
    { 1312, 336, -48},
    { 1168, 248, 32},
    { 992, 248, 32},
    { 888, 256, -8},
    // 16 seconds
    { 880, 208, 8},
    { 872, 192, 40},
    { 808, 192, 16},
    { 728, 128, 16},
    { 728, 96, 16},
    { 904, 128, -56},
    { 1024, 88, -104},
    { 1528, 104, -8},
    { 1592, 328, -400},
    { 1248, 328, -432},
    { 1400, 400, -424},
    { 1424, 488, -288},
    { 1192, 288, -96},
    { 880, 232, -64},
    { 744, 320, -96},
    { 632, 240, -32},
    { 680, 248, -72},
    { 840, 296, -112},
    { 968, 328, -128},
    { 1120, 392, -168},
    { 1336, 432, -232},
    { 1592, 464, -120},
    { 1648, 488, -112},
    { 1368, 424, -144},
    { 1120, 344, -96},
    // 17 seconds
    { 1192, 256, -48},
    { 1208, 240, -40},
    { 1056, 208, 16},
    { 896, 200, 48},
    { 856, 192, 48},
    { 840, 176, 48},
    { 824, 112, 80},
    { 792, 120, 104},
    { 808, 184, 56},
    { 912, 200, 56},
    { 1144, 200, 80},
    { 1232, 192, 64},
    { 1512, 200, -16},
    { 1352, 312, -392},
    { 1064, 440, -408},
    { 1160, 432, -360},
    { 1256, 624, -272},
    { 1200, 456, -112},
    { 912, 376, -104},
    { 736, 336, -40},
    { 672, 352, -64},
    { 712, 360, -40},
    { 864, 416, -88},
    { 904, 416, -88},
    { 1064, 440, -152},
    // 18 seconds
    { 1256, 456, -144},
    { 1296, 416, -8},
    { 1552, 456, -16},
    { 1400, 472, 24},
    { 1120, 496, -40},
    { 1104, 416, -16},
    { 1200, 376, 0},
    { 1200, 360, 80},
    { 1008, 304, 104},
    { 880, 304, 56},
    { 832, 280, 80},
    { 784, 272, 56},
    { 784, 216, 56},
    { 768, 208, 40},
    { 816, 344, -16},
    { 944, 168, 24},
    { 1040, 136, 0},
    { 1352, 88, 40},
    { 1456, 232, -80},
    { 1240, 352, -248},
    { 1192, 456, -352},
    { 1280, 488, -232},
    { 1256, 296, -8},
    { 1040, 296, -24},
    { 848, 328, -64},
    // 19 seconds
    { 720, 320, -16},
    { 752, 352, -96},
    { 848, 368, -96},
    { 952, 416, -152},
    { 1000, 416, -152},
    { 1232, 472, -248},
    { 1296, 432, -160},
    { 1608, 360, -80},
    { 1568, 416, -48},
    { 1168, 456, -72},
    { 1104, 352, -24},
    { 1200, 296, -48},
    { 1240, 280, 48},
    { 1024, 200, 96},
    { 904, 256, 64},
    { 888, 232, 80},
    { 880, 184, 104},
    { 848, 176, 120},
    { 800, 184, 72},
    { 784, 160, 48},
    { 928, 120, 24},
    { 1032, 96, -48},
    { 1368, 32, -8},
    { 1536, 216, -208},
    { 1264, 296, -336},
    // 20 seconds
    { 1224, 320, -328},
    { 1368, 424, -232},
    { 1248, 280, -64},
    { 976, 280, -88},
    { 792, 304, -88},
    { 736, 320, -96},
    { 800, 352, -120},
    { 912, 384, -144},
    { 920, 352, -112},
    { 1040, 384, -144},
    { 1256, 432, -192},
    { 1312, 336, -40},
    { 1720, 424, -120},
    { 1464, 368, 0},
    { 1056, 336, -16},
    { 1232, 320, -48},
    { 1264, 272, -24},
    { 1144, 224, 32},
    { 968, 240, 48},
    { 872, 216, 48},
    { 896, 208, 24},
    { 864, 176, 64},
    { 808, 160, 72},
    { 752, 160, 40},
    { 808, 128, 32},
    // 21 seconds
    { 1008, 104, 24},
    { 1200, 56, 64},
    { 1488, 208, -72},
    { 1400, 256, -248},
    { 1192, 336, -304},
    { 1264, 440, -320},
    { 1304, 456, -176},
    { 1152, 312, -88},
    { 912, 288, -96},
    { 776, 304, -96},
    { 728, 280, -64},
    { 792, 280, -88},
    { 880, 304, -128},
    { 928, 320, -120},
    { 1104, 360, -184},
    { 1248, 352, -160},
    { 1344, 296, -32},
    { 1656, 464, -160},
    { 1456, 504, -88},
    { 984, 344, -24},
    { 1208, 368, -72},
    { 1272, 352, -40},
    { 1088, 264, 72},
    { 944, 240, 88},
    { 896, 272, 80},
    // 22 seconds
    { 888, 232, 104},
    { 880, 200, 136},
    { 848, 216, 120},
    { 816, 168, 88},
    { 912, 96, 96},
    { 1056, 96, 64},
    { 1256, 24, 96},
    { 1424, 184, -72},
    { 1288, 288, -320},
    { 1104, 264, -296},
    { 1288, 352, -272},
    { 1384, 360, -144},
    { 1152, 408, -112},
    { 872, 360, -96},
    { 736, 320, -72},
    { 728, 336, -64},
    { 792, 360, -64},
    { 848, 368, -64},
    { 976, 392, -80},
    { 1176, 472, -136},
    { 1312, 464, -88},
    { 1736, 456, -56},
    { 1424, 416, 16},
    { 1192, 424, -88},
    { 1136, 352, -64},
    // 23 seconds
    { 1128, 304, -48},
    { 1168, 248, -16},
    { 1024, 224, 48},
    { 912, 232, 64},
    { 888, 216, 72},
    { 856, 200, 88},
    { 824, 184, 96},
    { 808, 192, 72},
    { 824, 144, 80},
    { 992, 120, 80},
    { 1144, 160, 64},
    { 1504, 104, 120},
    { 1520, 344, -120},
    { 1208, 408, -336},
    { 1120, 392, -320},
    { 1256, 504, -256},
    { 1264, 344, -88},
    { 1040, 312, -72},
    { 840, 312, -48},
    { 728, 312, -40},
    { 664, 280, -40},
    { 776, 264, -224},
    { 792, 240, -80},
    { 960, 248, -88},
    { 1136, 456, -136},
    // 24 seconds
    { 1232, 440, -96},
    { 1184, 368, -32},
    { 1648, 568, -192},
    { 1472, 640, -120},
    { 904, 392, 32},
    { 1184, 480, -112},
    { 1328, 448, 24},
    { 1160, 320, 128},
    { 1000, 288, 144},
    { 920, 320, 88},
    { 896, 264, 96},
    { 928, 248, 120},
    { 872, 216, 112},
    { 856, 192, 64},
    { 936, 152, 80},
    { 1032, 112, 80},
    { 1080, 24, -24},
    { 1480, 112, -80},
    { 1368, 200, -464},
    { 1000, 88, -304},
    { 1176, 312, -376},
    { 1280, 304, -232},
    { 1104, 200, -104},
    { 896, 248, -88},
    { 800, 304, -112},
    // 25 seconds
    { 792, 256, -112},
    { 880, 304, -120},
    { 976, 336, -128},
    { 992, 376, -128},
    { 1128, 384, -208},
    { 1288, 344, -176},
    { 1456, 248, -112},
    { 1616, 304, -128},
    { 1456, 344, -120},
    { 1104, 288, -104},
    { 1144, 264, -88},
    { 1176, 240, -56},
    { 1088, 192, 0},
    { 928, 176, 48},
    { 872, 200, 56},
    { 872, 200, 64},
    { 848, 168, 88},
    { 824, 160, 96},
    { 840, 184, 80},
    { 896, 144, 56},
    { 1040, 128, 64},
    { 1136, 136, 8},
    { 1520, 104, 64},
    { 1520, 360, -208},
    { 1112, 504, -440},
    // 26 seconds
    { 1152, 480, -440},
    { 1264, 480, -352},
    { 1176, 272, -144},
    { 896, 264, -96},
    { 792, 304, -88},
    { 752, 288, -56},
    { 784, 328, -72},
    { 872, 320, -96},
    { 872, 328, -104},
    { 968, 352, -120},
    { 1152, 384, -136},
    { 1248, 392, -104},
    { 1720, 440, -64},
    { 1568, 560, -112},
    { 1176, 496, -136},
    { 1168, 384, -120},
    { 1208, 288, -72},
    { 1224, 208, -8},
    { 1040, 200, 16},
    { 928, 216, 32},
    { 864, 200, 40},
    { 840, 184, 64},
    { 808, 160, 80},
    { 768, 136, 40},
    { 784, 104, 40},
    // 27 seconds
    { 912, 128, 24},
    { 1088, 168, -16},
    { 1488, 152, 56},
    { 1568, 392, -120},
    { 1184, 504, -312},
    { 1224, 496, -280},
    { 1336, 456, -144},
    { 1232, 248, 24},
    { 952, 272, -24},
    { 784, 296, -72},
    { 744, 320, -104},
    { 752, 312, -80},
    { 856, 360, -136},
    { 952, 392, -136},
    { 1088, 432, -160},
    { 1336, 472, -208},
    { 1344, 416, -112},
    { 1632, 376, -72},
    { 1472, 440, -56},
    { 1040, 376, -8},
    { 1216, 328, 32},
    { 1296, 328, 56},
    { 1184, 264, 112},
    { 992, 240, 136},
    { 872, 248, 88},
    // 28 seconds
    { 856, 208, 56},
    { 864, 136, 96},
    { 848, 152, 104},
    { 784, 184, 48},
    { 808, 168, 48},
    { 928, 144, 16},
    { 1096, 24, 40},
    { 1448, 112, -24},
    { 1432, 232, -192},
    { 1368, 448, -360},
    { 1416, 520, -360},
    { 1344, 320, -8},
    { 1216, 232, 8},
    { 968, 280, -32},
    { 744, 288, -8},
    { 656, 296, 56},
    { 712, 376, -8},
    { 816, 336, -64},
    { 896, 304, -72},
    { 1088, 312, -144},
    { 1304, 472, -168},
    { 1344, 464, -112},
    { 1752, 376, -48},
    { 1520, 456, -88},
    { 1016, 432, -48},
    // 29 seconds
    { 1200, 392, -32},
    { 1256, 344, 24},
    { 1184, 248, 128},
    { 1008, 208, 152},
    { 920, 248, 128},
    { 880, 216, 144},
    { 864, 168, 152},
    { 848, 144, 120},
    { 800, 216, 136},
    { 832, 376, 8},
    { 896, 216, 144},
    { 952, -40, 80},
    { 1336, -136, 120},
    { 1488, 112, -128},
    { 1320, 256, -272},
    { 1424, 488, -344},
    { 1424, 592, -88},
    { 1240, 224, -64},
    { 952, 232, -152},
    { 776, 264, -88},
    { 744, 288, -96},
    { 792, 336, -80},
    { 920, 408, -88},
    { 960, 392, -88},
    { 1104, 400, -120},
    // 30 seconds
    { 1264, 392, -144},
    { 1264, 336, -112},
    { 1576, 312, -88},
    { 1480, 392, -88},
    { 1040, 400, -32},
    { 1152, 376, 8},
    { 1272, 376, 0},
    { 1224, 320, 64},
    { 1016, 264, 112},
    { 896, 256, 96},
    { 896, 280, 104},
    { 920, 224, 144},
    { 912, 192, 144},
    { 824, 136, 80},
    { 784, 128, 48},
    { 848, 88, 16},
    { 936, 32, -24},
    { 1224, -64, -8},
    { 1504, 72, -216},
    { 1472, 232, -456},
    { 1440, 240, -344},
    { 1512, 528, -272},
    { 1344, 464, -56},
    { 1040, 352, -72},
    { 824, 312, -32},
    // 31 seconds
    { 680, 328, -24},
    { 680, 352, -48},
    { 776, 376, -80},
    { 896, 368, -48},
    { 1000, 392, -24},
    { 1208, 416, -88},
    { 1280, 400, -96},
    { 1528, 256, 24},
    { 1496, 320, -16},
    { 1192, 424, -24},
    { 1112, 328, 24},
    { 1248, 336, -32},
    { 1312, 288, 32},
    { 1112, 208, 112},
    { 968, 184, 120},
    { 904, 168, 112},
    { 872, 224, 104},
    { 832, 160, 120},
    { 768, 120, 88},
    { 736, 128, 72},
    { 864, 120, 88},
    { 1040, 88, 64},
    { 1232, 16, 72},
    { 1680, 200, -8},
    { 1424, 384, -304},
    // 32 seconds
    { 1072, 328, -336},
    { 1272, 416, -288},
    { 1320, 384, -32},
    { 1144, 296, 80},
    { 888, 272, 40},
    { 760, 280, -56},
    { 776, 320, -88},
    { 872, 352, -96},
    { 912, 344, -96},
    { 968, 360, -96},
    { 1112, 384, -152},
    { 1288, 384, -152},
    { 1416, 240, 40},
    { 1600, 400, -40},
    { 1248, 472, -48},
    { 1248, 288, 64},
    { 1384, 304, 32},
    { 1312, 264, 56},
    { 1048, 208, 72},
    { 912, 216, 72},
    { 864, 216, 64},
    { 856, 176, 88},
    { 816, 144, 112},
    { 744, 120, 120},
    { 736, 136, 72},
    // 33 seconds
    { 864, 144, 56},
    { 992, 104, 72},
    { 1208, 56, 40},
    { 1720, 128, 56},
    { 1536, 392, -256},
    { 1104, 400, -280},
    { 1264, 504, -264},
    { 1344, 392, -48},
    { 1168, 280, -56},
    { 912, 264, -96},
    { 728, 280, -56},
    { 728, 352, -72},
    { 832, 392, -64},
    { 952, 384, -56},
    { 1008, 432, -88},
    { 1144, 408, -104},
    { 1296, 392, -80},
    { 1776, 336, 0},
    { 1544, 456, -48},
    { 1136, 392, -16},
    { 1240, 304, 0},
    { 1312, 256, 48},
    { 1272, 232, 104},
    { 1072, 200, 96},
    { 944, 192, 112},
    // 34 seconds
    { 872, 168, 112},
    { 872, 160, 112},
    { 792, 168, 104},
    { 736, 144, 112},
    { 752, 168, 72},
    { 856, 120, 80},
    { 992, 48, 80},
    { 1448, 80, 152},
    { 1592, 208, -48},
    { 1432, 392, -368},
    { 1416, 504, -424},
    { 1360, 608, -216},
    { 1224, 248, 8},
    { 1048, 216, -64},
    { 840, 240, -24},
    { 688, 320, -24},
    { 672, 320, -8},
    { 792, 376, -48},
    { 888, 376, -64},
    { 992, 360, -40},
    { 1296, 360, -40},
    { 1560, 352, 0},
    { 1872, 416, -16},
    { 1464, 464, -72},
    { 1032, 440, -160},
    // 35 seconds
    { 1048, 344, -72},
    { 1136, 256, 0},
    { 1136, 232, 32},
    { 976, 232, 104},
    { 872, 264, 112},
    { 864, 256, 128},
    { 872, 224, 152},
    { 840, 184, 160},
    { 832, 216, 112},
    { 880, 168, 128},
    { 1048, 168, 88},
    { 1112, 176, 32},
    { 1360, -8, 96},
    { 1544, 232, -96},
    { 1088, 360, -344},
    { 1056, 344, -312},
    { 1360, 456, -320},
    { 1320, 424, -144},
    { 960, 344, -72},
    { 800, 328, -32},
    { 752, 376, -64},
    { 760, 352, -24},
    { 832, 352, -32},
    { 896, 392, -32},
    { 1048, 448, -72},
    // 36 seconds
    { 1280, 480, -104},
    { 1312, 440, 0},
    { 1704, 520, -72},
    { 1392, 544, -128},
    { 1016, 424, -64},
    { 1232, 368, -64},
    { 1392, 328, -40},
    { 1208, 248, 40},
    { 992, 256, 48},
    { 920, 256, 40},
    { 928, 224, 80},
    { 912, 160, 112},
    { 848, 152, 104},
    { 760, 120, 96},
    { 784, 88, 88},
    { 848, 56, 104},
    { 952, 32, 56},
    { 1472, 72, 72},
    { 1512, 328, -232},
    { 1352, 352, -288},
    { 1552, 544, -312},
    { 1448, 544, -112},
    { 1152, 344, -56},
    { 928, 280, -104},
    { 736, 304, -64},
    // 37 seconds
    { 704, 352, -136},
    { 768, 384, -104},
    { 920, 432, -112},
    { 1032, 472, -104},
    { 1232, 520, -168},
    { 1368, 496, -104},
    { 1760, 416, -64},
    { 1544, 416, -32},
    { 1224, 376, -64},
    { 1360, 328, -8},
    { 1368, 272, 56},
    { 1224, 200, 104},
    { 984, 160, 96},
    { 848, 184, 80},
    { 792, 208, 64},
    { 776, 176, 88},
    { 760, 128, 96},
    { 736, 144, 72},
    { 816, 112, 56},
    { 984, 80, 64},
    { 1064, 72, 0},
    { 1360, -48, 40},
    { 1768, 232, -160},
    { 1416, 376, -424},
    { 1344, 392, -352},
    // 38 seconds
    { 1440, 584, -288},
    { 1208, 352, -72},
    { 952, 296, -72},
    { 784, 288, -16},
    { 680, 336, -16},
    { 696, 384, -32},
    { 824, 376, 0},
    { 968, 384, -32},
    { 1080, 376, -32},
    { 1312, 408, -120},
    { 1360, 344, -40},
    { 1664, 352, -56},
    { 1488, 440, -112},
    { 1120, 416, -96},
    { 1272, 352, -96},
    { 1360, 256, -32},
    { 1224, 176, 32},
    { 1008, 176, 64},
    { 896, 240, 48},
    { 856, 224, 72},
    { 824, 152, 120},
    { 792, 128, 128},
    { 736, 120, 104},
    { 696, 112, 88},
    { 792, 88, 48},
    // 39 seconds
    { 920, 176, -40},
    { 1384, 112, -16},
    { 1680, 304, -256},
    { 1320, 352, -384},
    { 1456, 344, -320},
    { 1464, 464, -248},
    { 1176, 336, -104},
    { 896, 288, -64},
    { 744, 304, -80},
    { 656, 288, -72},
    { 680, 304, -72},
    { 832, 344, -112},
    { 960, 416, -80},
    { 1104, 464, -96},
    { 1272, 512, -184},
    { 1304, 472, -104},
    { 1864, 480, -136},
    { 1528, 464, -120},
    { 1096, 352, -96},
    { 1304, 312, -80},
    { 1336, 248, -24},
    { 1160, 200, 40},
    { 928, 192, 72},
    { 840, 224, 64},
    { 816, 200, 80},
    // 40 seconds
    { 800, 160, 104},
    { 792, 160, 104},
    { 744, 144, 88},
    { 816, 104, 80},
    { 984, 120, 56},
    { 1072, 48, 48},
    { 1560, 176, 40},
    { 1416, 336, -328},
    { 1256, 248, -272},
    { 1536, 496, -328},
    { 1448, 464, -168},
    { 1096, 360, -112},
    { 848, 352, -88},
    { 744, 336, -80},
    { 704, 368, -24},
    { 776, 416, -32},
    { 856, 400, -16},
    { 936, 392, 8},
    { 1192, 448, -64},
    { 1344, 472, -80},
    { 1752, 416, -32},
    { 1512, 392, -56},
    { 1256, 376, -104},
    { 1256, 288, -48},
    { 1272, 208, 0},
    // 41 seconds
    { 1232, 200, 8},
    { 992, 216, 40},
    { 832, 200, 72},
    { 808, 176, 88},
    { 808, 144, 88},
    { 768, 128, 96},
    { 728, 112, 88},
    { 736, 96, 64},
    { 920, 104, 64},
    { 1088, 104, 32},
    { 1576, 64, 112},
    { 1856, 376, -96},
    { 1352, 528, -288},
    { 1248, 672, -392},
    { 1224, 600, -160},
    { 1192, 456, -104},
    { 936, 400, -96},
    { 704, 304, -24},
    { 632, 344, -16},
    { 736, 376, -48},
    { 872, 352, -32},
    { 968, 408, -16},
    { 1064, 432, -64},
    { 1232, 448, -88},
    { 1400, 336, 48},
    // 42 seconds
    { 1560, 544, -72},
    { 1416, 496, -48},
    { 1096, 336, -32},
    { 1168, 336, -64},
    { 1280, 328, -72},
    { 1176, 288, 8},
    { 1016, 240, 80},
    { 984, 264, 64},
    { 968, 224, 96},
    { 928, 192, 112},
    { 872, 184, 144},
    { 808, 144, 120},
    { 856, 136, 96},
    { 928, 80, 72},
    { 1136, 40, 160},
    { 1352, 176, 32},
    { 1312, 152, -280},
    { 1344, 200, -472},
    { 1472, 312, -392},
    { 1440, 440, -256},
    { 1232, 368, -120},
    { 984, 272, -32},
    { 824, 352, -8},
    { 744, 320, -32},
    { 720, 328, -24},
    // 43 seconds
    { 800, 344, -8},
    { 848, 352, -40},
    { 976, 376, -40},
    { 1232, 488, -144},
    { 1344, 472, -96},
    { 1728, 456, -56},
    { 1528, 448, -88},
    { 1080, 432, -136},
    { 1248, 352, -72},
    { 1368, 296, -48},
    { 1320, 240, 16},
    { 1088, 224, 64},
    { 976, 240, 56},
    { 928, 192, 88},
    { 920, 144, 120},
    { 872, 136, 128},
    { 808, 160, 56},
    { 784, 104, 80},
    { 896, 104, 80},
    { 1000, 56, 40},
    { 1320, 128, 32},
    { 1432, 240, -240},
    { 1312, 312, -368},
    { 1312, 400, -280},
    { 1384, 488, -248},
    // 44 seconds
    { 1312, 432, -144},
    { 1024, 336, -96},
    { 856, 344, -56},
    { 792, 352, -72},
    { 776, 360, -64},
    { 832, 400, -88},
    { 920, 432, -104},
    { 1048, 472, -144},
    { 1240, 464, -160},
    { 1352, 408, -80},
    { 1800, 448, -80},
    { 1432, 464, -80},
    { 1088, 360, -56},
    { 1296, 312, -64},
    { 1400, 264, -24},
    { 1248, 184, 32},
    { 1048, 168, 64},
    { 952, 200, 56},
    { 896, 176, 64},
    { 856, 152, 88},
    { 800, 120, 88},
    { 720, 80, 56},
    { 728, 64, 64},
    { 832, 56, 56},
    { 976, 24, 8},
    // 45 seconds
    { 1528, 96, 16},
    { 1712, 304, -280},
    { 1512, 368, -392},
    { 1512, 592, -440},
    { 1344, 520, -136},
    { 1184, 296, -72},
    { 944, 264, -112},
    { 696, 240, -56},
    { 616, 320, -48},
    { 696, 360, -24},
    { 840, 336, -96},
    { 952, 352, -96},
    { 1208, 440, -112},
    { 1440, 568, -168},
    { 1768, 384, -48},
    { 1656, 456, -72},
    { 1224, 448, -160},
    { 1176, 360, -64},
    { 1176, 248, -8},
    { 1216, 200, 8},
    { 1016, 184, 48},
    { 880, 176, 88},
    { 848, 224, 80},
    { 888, 192, 112},
    { 856, 160, 136},
    // 46 seconds
    { 824, 152, 120},
    { 880, 152, 80},
    { 1040, 120, 72},
    { 1176, 40, 88},
    { 1456, 112, 40},
    { 1224, 224, -304},
    { 1080, 168, -400},
    { 1344, 288, -408},
    { 1424, 312, -240},
    { 1144, 272, -160},
    { 904, 264, -128},
    { 800, 264, -64},
    { 784, 280, -104},
    { 832, 312, -88},
    { 912, 344, -104},
    { 984, 344, -112},
    { 1208, 400, -184},
    { 1352, 424, -200},
    { 1664, 336, -96},
    { 1528, 408, -152},
    { 1144, 408, -128},
    { 1200, 336, -96},
    { 1296, 264, -88},
    { 1280, 208, -24},
    { 1040, 184, 40},
    // 47 seconds
    { 912, 224, 56},
    { 904, 232, 80},
    { 872, 152, 112},
    { 832, 128, 120},
    { 760, 144, 112},
    { 800, 128, 104},
    { 944, 104, 72},
    { 1016, 32, 40},
    { 1464, 56, 24},
    { 1496, 232, -304},
    { 1248, 208, -368},
    { 1384, 304, -368},
    { 1392, 360, -240},
    { 1216, 328, -152},
    { 936, 288, -112},
    { 752, 312, -80},
    { 704, 368, -80},
    { 744, 344, -72},
    { 864, 344, -80},
    { 984, 376, -64},
    { 1112, 448, -112},
    { 1232, 456, -112},
    { 1296, 352, 24},
    { 1752, 520, -56},
    { 1240, 560, -136},
    // 48 seconds
    { 1112, 368, -16},
    { 1368, 336, -72},
    { 1392, 296, -8},
    { 1144, 200, 72},
    { 984, 208, 32},
    { 952, 256, 24},
    { 928, 176, 80},
    { 880, 96, 96},
    { 800, 120, 48},
    { 752, 144, 24},
    { 768, 72, 32},
    { 848, 72, -8},
    { 992, -40, 56},
    { 1424, 80, -32},
    { 1416, 264, -368},
    { 1480, 296, -312},
    { 1640, 520, -288},
    { 1448, 512, -152},
    { 1064, 360, -104},
    { 880, 344, -112},
    { 720, 328, -48},
    { 640, 360, -48},
    { 720, 392, -96},
    { 816, 392, -96},
    { 984, 456, -120},
    // 49 seconds
    { 1264, 560, -152},
    { 1264, 528, -104},
    { 1384, 400, -16},
    { 1448, 432, -80},
    { 1312, 456, -136},
    { 1240, 304, 48},
    { 1480, 304, 8},
    { 1432, 264, 48},
    { 1152, 200, 112},
    { 1024, 224, 96},
    { 976, 232, 104},
    { 904, 160, 120},
    { 824, 128, 104},
    { 744, 120, 72},
    { 712, 112, 64},
    { 712, 136, 48},
    { 728, 88, 40},
    { 784, 96, -56},
    { 1168, 16, -72},
    { 1968, 104, -112},
    { 1688, 368, -328},
    { 1368, 400, -344},
    { 1464, 584, -336},
    { 1320, 360, -128},
    { 1096, 272, -104},
    // 50 seconds
    { 880, 312, -64},
    { 760, 368, -32},
    { 752, 400, -48},
    { 840, 408, -96},
    { 936, 384, -112},
    { 1016, 384, -152},
    { 1096, 392, -160},
    { 1176, 368, -176},
    { 1048, 312, -120},
    { 976, 328, -80},
    { 1256, 312, -32},
    { 1608, 416, -40},
    { 1368, 496, -24},
    { 1032, 368, 8},
    { 1136, 288, 8},
    { 1336, 240, 112},
    { 1256, 184, 152},
    { 1064, 176, 168},
    { 936, 208, 160},
    { 928, 200, 160},
    { 944, 184, 168},
    { 944, 168, 168},
    { 928, 192, 144},
    { 952, 208, 120},
    { 1000, 240, 96},
    // 51 seconds
    { 1008, 264, 96},
    { 1072, 288, 56},
    { 1144, 328, 0},
    { 1184, 352, -16},
    { 1184, 376, -32},
    { 1192, 416, -48},
    { 1152, 456, -88},
    { 1080, 464, -64},
    { 1040, 432, -56},
    { 1008, 416, -56},
    { 1000, 368, -8},
    { 1256, 408, 64},
    { 1248, 472, 40},
    { 960, 368, 32},
    { 1024, 352, -16},
    { 1136, 328, -40},
    { 1168, 240, 8},
    { 1104, 216, 0},
    { 1080, 200, 0},
    { 1064, 192, 0},
    { 1080, 168, -16},
    { 1064, 160, -56},
    { 1024, 136, -72},
    { 1032, 104, -64},
    { 1032, 96, -64},
    // 52 seconds
    { 1032, 152, -80},
    { 1032, 152, -72},
    { 1024, 176, -72},
    { 912, 448, 232},
    { 1136, -480, -744},
    { 976, 704, -296},
    { 872, 1632, 640},
    { 1168, -144, 144},
    { 1328, -896, -824},
    { 1048, 1024, -160},
    { 912, 1200, 504},
    { 1008, 496, -152},
    { 1000, 352, -24},
    { 1136, 408, 0},
    { 1040, 448, 8},
    { 984, 448, 56},
    { 1016, 440, 80},
    { 1056, 416, 72},
    { 1120, 376, 96},
    { 1208, 328, 96},
    { 1280, 336, 72},
    { 1480, 272, 128},
    { 1680, 312, 96},
    { 1160, 264, -112},
    { 1104, 168, -232},
    // 53 seconds
    { 968, 40, -120},
    { 1000, -80, 40},
    { 1160, -16, 40},
    { 1064, 56, -88},
    { 840, 40, -96},
    { 704, 24, -112},
    { 664, -88, -192},
    { 672, -32, -216},
    { 744, 56, -240},
    { 800, 136, -232},
    { 968, 184, -240},
    { 1296, 272, -256},
    { 1552, 320, -176},
    { 1920, 512, -168},
    { 1648, 848, -208},
    { 1112, 656, -208},
    { 1112, 520, -264},
    { 1192, 456, -184},
    { 1248, 304, -56},
    { 1152, 288, 8},
    { 1056, 256, 24},
    { 1056, 240, 64},
    { 1080, 184, 104},
    { 1056, 144, 136},
    { 1048, 128, 128},
    // 54 seconds
    { 1048, 96, 160},
    { 1176, 64, 152},
    { 1120, 56, 104},
    { 1304, 24, 128},
    { 1168, 128, -32},
    { 984, 152, -312},
    { 1104, 160, -376},
    { 1304, 224, -288},
    { 1256, 240, -136},
    { 1016, 296, -152},
    { 880, 304, -80},
    { 832, 264, -64},
    { 816, 288, -32},
    { 864, 368, -64},
    { 912, 384, -56},
    { 1024, 416, -56},
    { 1264, 480, -96},
    { 1352, 488, -88},
    { 1624, 472, -40},
    { 1376, 568, -160},
    { 1128, 456, -128},
    { 1312, 392, -128},
    { 1384, 312, -40},
    { 1320, 232, 40},
    { 1064, 224, 40},
    // 55 seconds
    { 920, 192, 48},
    { 888, 192, 48},
    { 904, 152, 80},
    { 864, 152, 80},
    { 792, 104, 64},
    { 784, 56, 64},
    { 880, 48, 72},
    { 1048, 72, 16},
    { 1376, 0, 24},
    { 1528, 136, -248},
    { 1416, 208, -416},
    { 1512, 264, -400},
    { 1464, 464, -264},
    { 1240, 320, -16},
    { 1024, 312, -96},
    { 832, 320, -64},
    { 648, 328, -16},
    { 632, 304, -64},
    { 720, 296, -40},
    { 904, 320, -88},
    { 1112, 352, -128},
    { 1368, 472, -184},
    { 1592, 440, -96},
    { 1792, 632, -152},
    { 1400, 544, -176},
    // 56 seconds
    { 1232, 336, -120},
    { 1360, 296, -64},
    { 1376, 216, 24},
    { 1112, 160, 32},
    { 912, 160, 32},
    { 792, 152, 48},
    { 760, 128, 32},
    { 720, 80, 48},
    { 680, 80, 32},
    { 640, 40, 40},
    { 784, 40, 16},
    { 992, 8, -16},
    { 1560, -40, 56},
    { 1936, 184, -288},
    { 1680, 296, -520},
    { 1584, 624, -608},
    { 1280, 664, -280},
    { 1208, 280, -56},
    { 1024, 272, -104},
    { 752, 320, -72},
    { 568, 328, -16},
    { 600, 352, -56},
    { 784, 368, -56},
    { 928, 368, -40},
    { 1120, 376, -24},
    // 57 seconds
    { 1352, 408, -88},
    { 1720, 368, -72},
    { 1608, 408, -88},
    { 1520, 400, -128},
    { 1152, 344, -152},
    { 1112, 264, -48},
    { 1160, 208, -8},
    { 1040, 200, 48},
    { 840, 240, 88},
    { 768, 240, 88},
    { 776, 208, 104},
    { 816, 176, 144},
    { 848, 160, 136},
    { 856, 168, 112},
    { 1032, 128, 104},
    { 1104, 72, 80},
    { 1440, 8, 192},
    { 1488, 248, 8},
    { 1200, 408, -400},
    { 1336, 432, -456},
    { 1392, 536, -328},
    { 1288, 352, -128},
    { 928, 264, -48},
    { 800, 208, -40},
    { 728, 304, -88},
    // 58 seconds
    { 712, 344, -80},
    { 800, 368, -104},
    { 888, 352, -88},
    { 1104, 408, -120},
    { 1352, 456, -160},
    { 1536, 336, -24},
    { 1776, 440, -64},
    { 1400, 448, -72},
    { 1248, 320, -16},
    { 1328, 280, 8},
    { 1280, 248, 40},
    { 1008, 216, 80},
    { 832, 184, 64},
    { 768, 200, 64},
    { 760, 152, 88},
    { 736, 120, 80},
    { 712, 144, 80},
    { 712, 104, 80},
    { 880, 112, 64},
    { 1072, -8, 128},
    { 1648, 152, 144},
    { 1576, 400, -328},
    { 1456, 368, -392},
    { 1544, 640, -464},
    { 1320, 392, -168},
    // 59 seconds
    { 1032, 272, -96},
    { 840, 304, -96},
    { 688, 304, -88},
    { 616, 312, -88},
    { 688, 296, -88},
    { 840, 296, -88},
    { 1024, 376, -104},
    { 1304, 480, -168},
    { 1552, 480, -32},
    { 1864, 520, -72},
    { 1456, 432, -144},
    { 1264, 352, -88},
    { 1368, 320, -48},
    { 1320, 216, 8},
    { 1032, 168, 32},
    { 832, 216, 48},
    { 808, 224, 80},
    { 824, 160, 104},
    { 800, 112, 112},
    { 784, 144, 120},
    { 752, 120, 104},
    { 840, 64, 96},
    { 960, 88, 24},
    { 1400, 40, 112},
    { 1464, 280, -216},
    // 60 seconds
    // elapsed: 1 minutes
    { 1328, 232, -312},
    { 1656, 384, -392},
    { 1592, 584, -312},
    { 1168, 416, -160},
    { 888, 352, -128},
    { 752, 336, -112},
    { 688, 352, -56},
    { 760, 440, -64},
    { 824, 456, -40},
    { 952, 456, -16},
    { 1184, 512, -64},
    { 1304, 512, -32},
    { 1576, 392, 72},
    { 1584, 440, -64},
    { 1184, 448, -88},
    { 1440, 336, 32},
    { 1576, 264, 24},
    { 1272, 200, 72},
    { 960, 192, 40},
    { 856, 256, 24},
    { 832, 208, 88},
    { 792, 112, 112},
    { 744, 104, 88},
    { 696, 120, 80},
    { 720, 72, 48},
    // 61 seconds
    { 840, 80, 8},
    { 928, -16, 48},
    { 1536, 64, 72},
    { 1544, 344, -360},
    { 1624, 280, -376},
    { 1776, 504, -384},
    { 1408, 416, -160},
    { 928, 280, -48},
    { 816, 320, -104},
    { 664, 328, -48},
    { 664, 392, -64},
    { 760, 416, -32},
    { 880, 432, -48},
    { 1008, 440, -88},
    { 1072, 384, -96},
    { 1136, 384, -80},
    { 1064, 344, -16},
    { 1720, 504, -72},
    { 1672, 656, -152},
    { 1184, 440, -72},
    { 1624, 496, -128},
    { 1608, 376, 8},
    { 1264, 272, 24},
    { 1040, 264, 40},
    { 992, 232, 80},
    // 62 seconds
    { 896, 336, 168},
    { 832, 280, 232},
    { 680, 528, 248},
    { 480, 576, 256},
    { 328, 888, 368},
    { 160, 1056, 384},
    { 272, 1008, 624},
    { 56, 1296, 648},
    { 128, 1272, 552},
    { 224, 896, 440},
    { 408, 568, 320},
    { 544, 520, 272},
    { 536, 728, 328},
    { 496, 1072, 392},
    { 456, 1080, 472},
    { 488, 1064, 184},
    { 432, 912, -64},
    { 392, 208, -336},
    { 432, -248, -536},
    { 480, -256, -728},
    { 600, -144, -808},
    { 704, -8, -808},
    { 656, 32, -800},
    { 688, -200, -592},
    { 560, -96, -808},
    // 63 seconds
    { 792, 296, -872},
    { 592, -40, -928},
    { 552, -168, -904},
    { 568, -144, -880},
    { 520, 24, -872},
    { 456, -96, -848},
    { 464, -112, -880},
    { 416, -48, -896},
    { 496, -112, -960},
    { 464, -88, -896},
    { 440, -104, -904},
    { 384, -48, -896},
    { 432, -40, -968},
    { 440, -80, -944},
    { 376, -80, -952},
    { 360, -80, -976},
    { 272, -96, -960},
    { 272, -112, -960},
    { 272, -88, -968},
    { 224, -120, -976},
    { 184, -88, -960},
    { 184, -112, -960},
    { 160, -96, -936},
    { 128, -88, -960},
    { 224, 16, -992},
    // 64 seconds
    { 176, -64, -1024},
    { 240, -120, -992},
    { 136, -144, -984},
    { 192, -112, -984},
    { 184, -184, -976},
    { 136, -112, -960},
    { 200, -56, -992},
    { 208, -72, -968},
    { 224, -80, -1000},
    { 216, -96, -1000},
    { 216, -72, -992},
    { 208, -96, -984},
    { 184, -120, -976},
    { 176, -56, -976},
    { 160, -88, -976},
    { 152, -96, -984},
    { 160, -56, -984},
    { 152, -80, -992},
    { 160, -72, -984},
    { 144, -80, -976},
    { 200, -64, -952},
    { 208, -104, -968},
    { 288, -56, -1032},
    { 216, -64, -1000},
    { 216, -16, -920},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:50:42 local
AccelRawData *activity_sample_walk_100_pbl_25666_6(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25666_6
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 224, -16, -1000},
    { 216, -8, -960},
    { 192, -8, -976},
    { 216, 40, -984},
    { 216, 32, -968},
    { 208, 40, -984},
    { 208, 24, -968},
    { 232, 40, -992},
    { 208, 32, -992},
    { 224, 32, -968},
    { 232, 32, -976},
    { 216, 24, -992},
    { 232, 24, -984},
    { 224, 24, -992},
    { 208, 16, -976},
    { 224, 16, -976},
    { 216, 24, -976},
    { 224, 0, -976},
    { 184, -8, -968},
    { 224, 0, -1000},
    { 200, 0, -992},
    { 208, 8, -1000},
    { 192, -8, -1000},
    { 200, -24, -968},
    { 208, 0, -976},
    // 1 seconds
    { 216, 0, -968},
    { 240, 24, -976},
    { 248, 40, -968},
    { 328, 40, -984},
    { 240, -8, -1016},
    { 320, -32, -984},
    { 248, -48, -928},
    { 136, -48, -904},
    { 144, -128, -856},
    { 648, 80, -1160},
    { 192, 32, -912},
    { 160, -40, -872},
    { 232, 24, -920},
    { 280, 24, -920},
    { 272, -32, -848},
    { 272, -40, -776},
    { 264, -112, -672},
    { 320, -40, -552},
    { 392, -72, -512},
    { 544, -104, -408},
    { 744, 48, -288},
    { 992, 96, -192},
    { 1496, 264, -104},
    { 1880, 144, 144},
    { 2184, 192, 168},
    // 2 seconds
    { 2280, 576, 128},
    { 1936, 816, -88},
    { 1312, 880, 88},
    { 1056, 272, 264},
    { 896, 240, 144},
    { 712, 256, 88},
    { 576, 304, 144},
    { 544, 376, 152},
    { 704, 400, 80},
    { 864, 408, 96},
    { 968, 424, 40},
    { 1384, 488, -72},
    { 1952, 744, -176},
    { 2008, 672, -208},
    { 1592, 472, -272},
    { 1584, 208, -144},
    { 1616, 136, -56},
    { 1440, 88, -24},
    { 1136, 64, 24},
    { 888, 64, 48},
    { 760, 64, 64},
    { 624, 16, 72},
    { 536, 24, 88},
    { 512, -8, 64},
    { 648, 8, 80},
    // 3 seconds
    { 872, 104, 80},
    { 1144, 88, 64},
    { 1648, 144, 168},
    { 1704, 400, -24},
    { 1784, 432, -288},
    { 1840, 864, -360},
    { 1296, 736, 64},
    { 920, 184, 32},
    { 816, 232, -96},
    { 664, 248, -40},
    { 600, 384, 0},
    { 704, 472, 0},
    { 920, 472, 8},
    { 1080, 520, -8},
    { 1384, 568, -160},
    { 1448, 456, -40},
    { 1872, 400, -32},
    { 1376, 440, -96},
    { 1464, 328, 24},
    { 1624, 240, 48},
    { 1480, 216, 64},
    { 1120, 176, 56},
    { 880, 152, 48},
    { 840, 168, 32},
    { 808, 176, 72},
    // 4 seconds
    { 688, 64, 88},
    { 576, 96, 40},
    { 528, 88, 56},
    { 664, 48, 32},
    { 848, 72, 24},
    { 1352, 80, 48},
    { 1688, 272, -240},
    { 1768, 296, -416},
    { 1808, 440, -400},
    { 1400, 592, -40},
    { 1072, 232, 88},
    { 920, 264, 8},
    { 744, 328, -24},
    { 592, 328, -8},
    { 624, 368, -16},
    { 808, 416, -8},
    { 1008, 400, 16},
    { 1352, 512, -48},
    { 1496, 544, -48},
    { 2056, 520, 16},
    { 1464, 464, -88},
    { 1264, 320, 16},
    { 1328, 232, 104},
    { 1320, 208, 136},
    { 1032, 232, 120},
    // 5 seconds
    { 848, 232, 120},
    { 808, 224, 128},
    { 784, 184, 160},
    { 776, 128, 192},
    { 744, 160, 144},
    { 720, 120, 136},
    { 880, 112, 144},
    { 1024, 120, 96},
    { 1248, -8, 88},
    { 1688, 144, 16},
    { 1384, 360, -224},
    { 1384, 352, -224},
    { 1528, 624, -216},
    { 1264, 424, -8},
    { 912, 264, -40},
    { 776, 232, -96},
    { 696, 248, -64},
    { 752, 344, -64},
    { 880, 432, -56},
    { 960, 456, -24},
    { 1136, 464, -40},
    { 1344, 408, -32},
    { 1576, 248, 152},
    { 1672, 432, 88},
    { 1160, 512, 40},
    // 6 seconds
    { 1320, 432, 72},
    { 1432, 304, 112},
    { 1208, 144, 104},
    { 960, 176, 72},
    { 832, 176, 96},
    { 824, 176, 96},
    { 896, 280, 136},
    { 824, 200, 136},
    { 776, 184, 64},
    { 776, 104, 56},
    { 864, 16, 40},
    { 1120, -48, 144},
    { 1392, 40, -96},
    { 1360, 112, -352},
    { 1592, 152, -288},
    { 1576, 352, -152},
    { 1256, 528, 56},
    { 968, 392, 96},
    { 824, 320, 40},
    { 752, 288, -8},
    { 704, 280, 24},
    { 768, 352, 16},
    { 864, 416, 64},
    { 1008, 544, 24},
    { 1328, 624, -128},
    // 7 seconds
    { 1576, 480, 48},
    { 1808, 464, -40},
    { 1288, 440, -96},
    { 1256, 432, 48},
    { 1432, 424, 112},
    { 1328, 280, 184},
    { 1040, 256, 152},
    { 888, 240, 112},
    { 856, 216, 112},
    { 864, 232, 176},
    { 800, 128, 160},
    { 736, 64, 152},
    { 744, 120, 128},
    { 880, 72, 104},
    { 960, 8, 64},
    { 1320, -96, 160},
    { 1512, 176, -88},
    { 1296, 192, -352},
    { 1552, 312, -360},
    { 1536, 424, -216},
    { 1280, 352, -112},
    { 960, 248, -112},
    { 808, 200, -40},
    { 704, 296, -80},
    { 688, 288, -24},
    // 8 seconds
    { 760, 336, -88},
    { 888, 320, -48},
    { 1168, 408, -8},
    { 1488, 576, -128},
    { 1752, 472, 96},
    { 1696, 480, 24},
    { 1256, 400, -48},
    { 1232, 296, 24},
    { 1264, 240, 104},
    { 1256, 216, 128},
    { 976, 272, 128},
    { 824, 256, 120},
    { 784, 192, 160},
    { 856, 152, 160},
    { 880, 160, 144},
    { 840, 112, 160},
    { 872, 56, 144},
    { 1008, 96, 120},
    { 1080, 80, 136},
    { 1464, 32, 152},
    { 1344, 288, -184},
    { 1200, 272, -256},
    { 1480, 344, -240},
    { 1480, 424, -128},
    { 1104, 280, 24},
    // 9 seconds
    { 864, 264, 8},
    { 776, 280, -56},
    { 728, 320, -8},
    { 760, 432, -56},
    { 856, 400, -24},
    { 984, 424, 32},
    { 1296, 496, -64},
    { 1488, 496, -16},
    { 1928, 368, 80},
    { 1512, 392, -16},
    { 1120, 320, 32},
    { 1384, 280, 136},
    { 1384, 248, 200},
    { 1128, 264, 200},
    { 880, 264, 128},
    { 760, 184, 160},
    { 720, 160, 168},
    { 712, 200, 160},
    { 704, 152, 144},
    { 712, 112, 120},
    { 840, 104, 136},
    { 992, 128, 96},
    { 1312, -8, 272},
    { 1744, 224, 128},
    { 1384, 440, -264},
    // 10 seconds
    { 1456, 368, -232},
    { 1496, 528, -184},
    { 1288, 184, 40},
    { 1024, 208, -48},
    { 784, 256, -48},
    { 680, 296, -40},
    { 688, 304, -112},
    { 784, 376, -88},
    { 912, 384, 24},
    { 1072, 360, 8},
    { 1312, 400, -64},
    { 1536, 376, 80},
    { 1736, 504, 80},
    { 1360, 504, -8},
    { 1168, 288, 184},
    { 1344, 312, 184},
    { 1248, 272, 176},
    { 952, 312, 80},
    { 848, 296, 40},
    { 824, 280, 48},
    { 832, 280, 88},
    { 840, 336, 96},
    { 744, 88, 160},
    { 752, 80, 112},
    { 944, 160, 128},
    // 11 seconds
    { 1104, 8, 192},
    { 1528, 104, 200},
    { 1392, 312, -176},
    { 1320, 296, -392},
    { 1416, 376, -344},
    { 1400, 304, -136},
    { 1144, 240, -120},
    { 904, 256, -120},
    { 696, 272, -128},
    { 632, 336, -120},
    { 728, 280, -136},
    { 904, 304, -128},
    { 1096, 352, -80},
    { 1296, 432, -104},
    { 1408, 440, -56},
    { 1744, 408, -8},
    { 1424, 464, -80},
    { 1160, 408, -72},
    { 1312, 336, -40},
    { 1432, 304, 8},
    { 1272, 208, 96},
    { 1016, 208, 88},
    { 912, 240, 80},
    { 864, 200, 88},
    { 832, 136, 120},
    // 12 seconds
    { 752, 120, 104},
    { 672, 104, 80},
    { 640, 88, 64},
    { 752, 88, 24},
    { 856, 24, 24},
    { 1352, -56, 136},
    { 1776, 288, -192},
    { 1616, 376, -328},
    { 1784, 584, -328},
    { 1440, 648, -48},
    { 1144, 240, -8},
    { 976, 400, -120},
    { 720, 320, -104},
    { 576, 232, -80},
    { 664, 296, -104},
    { 848, 336, -120},
    { 992, 368, -80},
    { 1240, 416, -96},
    { 1384, 440, -72},
    { 1424, 280, 72},
    { 1672, 400, 32},
    { 1248, 536, -120},
    { 976, 336, 80},
    { 1256, 368, 24},
    { 1352, 328, 40},
    // 13 seconds
    { 1088, 288, 104},
    { 920, 272, 112},
    { 872, 232, 136},
    { 920, 248, 160},
    { 968, 176, 184},
    { 944, 136, 136},
    { 944, 128, 112},
    { 992, 80, 104},
    { 1000, 24, 56},
    { 1240, -48, 160},
    { 1184, 104, -88},
    { 1008, 112, -264},
    { 1320, 136, -280},
    { 1568, 216, -216},
    { 1472, 320, -88},
    { 1024, 272, 0},
    { 848, 240, 24},
    { 808, 304, 24},
    { 808, 368, -48},
    { 880, 376, -16},
    { 920, 368, -64},
    { 1072, 336, -32},
    { 1384, 392, -88},
    { 1544, 392, -24},
    { 1728, 368, -64},
    // 14 seconds
    { 1488, 304, -56},
    { 1088, 344, -24},
    { 1168, 264, 8},
    { 1240, 192, 24},
    { 1192, 176, 88},
    { 984, 200, 128},
    { 864, 208, 136},
    { 872, 248, 144},
    { 856, 200, 176},
    { 840, 160, 192},
    { 816, 136, 184},
    { 912, 40, 104},
    { 1096, 88, 128},
    { 1184, 24, 208},
    { 1408, 176, 136},
    { 1112, 312, -200},
    { 1128, 200, -360},
    { 1472, 200, -256},
    { 1528, 160, -120},
    { 1184, 176, -80},
    { 912, 320, -112},
    { 816, 352, -96},
    { 776, 264, -88},
    { 784, 208, -80},
    { 888, 240, -120},
    // 15 seconds
    { 992, 288, -120},
    { 1216, 312, -128},
    { 1440, 344, -104},
    { 1808, 344, -32},
    { 1528, 432, -32},
    { 1176, 392, -56},
    { 1232, 296, 40},
    { 1240, 224, 24},
    { 1216, 240, 72},
    { 1016, 216, 88},
    { 864, 240, 80},
    { 848, 200, 80},
    { 848, 184, 96},
    { 816, 120, 112},
    { 776, 88, 96},
    { 824, 56, 88},
    { 1008, 104, 128},
    { 1064, 56, 64},
    { 1384, 0, 136},
    { 1456, 208, -144},
    { 1232, 232, -280},
    { 1496, 256, -256},
    { 1528, 288, -104},
    { 1248, 312, -64},
    { 904, 264, 0},
    // 16 seconds
    { 776, 328, -32},
    { 720, 400, -40},
    { 720, 336, -16},
    { 776, 296, -64},
    { 888, 288, -56},
    { 1112, 400, -64},
    { 1424, 448, -80},
    { 1840, 440, 48},
    { 1704, 496, 0},
    { 1264, 408, -32},
    { 1312, 240, 72},
    { 1288, 232, 80},
    { 1144, 256, 72},
    { 904, 216, 104},
    { 784, 192, 112},
    { 760, 184, 112},
    { 736, 136, 136},
    { 776, 144, 152},
    { 768, 192, 136},
    { 840, 144, 128},
    { 1048, 128, 64},
    { 1200, -8, 128},
    { 1632, 80, 88},
    { 1408, 344, -320},
    { 1248, 232, -264},
    // 17 seconds
    { 1456, 344, -176},
    { 1352, 360, -8},
    { 1024, 256, 24},
    { 832, 224, -24},
    { 736, 336, -64},
    { 704, 224, -56},
    { 728, 248, -56},
    { 848, 264, -112},
    { 1008, 336, -96},
    { 1264, 416, -128},
    { 1488, 472, -88},
    { 1872, 464, -24},
    { 1472, 488, 40},
    { 1160, 416, 8},
    { 1328, 360, 72},
    { 1312, 296, 144},
    { 1160, 256, 160},
    { 944, 232, 160},
    { 872, 248, 176},
    { 848, 184, 192},
    { 824, 152, 184},
    { 784, 144, 120},
    { 744, 96, 48},
    { 768, 112, 64},
    { 944, 88, 96},
    // 18 seconds
    { 1008, 104, 72},
    { 1528, 0, 224},
    { 1672, 368, -144},
    { 1328, 632, -200},
    { 1400, 752, -240},
    { 1312, 632, -8},
    { 1224, 320, -64},
    { 944, 272, -88},
    { 744, 224, -88},
    { 624, 200, -80},
    { 656, 168, -128},
    { 816, 392, -192},
    { 880, 360, -16},
    { 1192, 280, -176},
    { 1400, 264, -224},
    { 1512, 272, -88},
    { 1760, 480, -232},
    { 1328, 472, -128},
    { 1272, 176, 168},
    { 1376, 232, 24},
    { 1320, 312, 40},
    { 1072, 336, 112},
    { 880, 216, 136},
    { 808, 136, 152},
    { 784, 152, 104},
    // 19 seconds
    { 808, 128, 152},
    { 776, 152, 96},
    { 784, 160, 112},
    { 904, 24, 136},
    { 1064, 72, 32},
    { 1344, -8, 112},
    { 1496, 136, -56},
    { 1368, 288, -280},
    { 1360, 240, -248},
    { 1552, 424, -184},
    { 1440, 368, -16},
    { 1040, 328, -32},
    { 856, 296, -96},
    { 744, 296, -96},
    { 704, 272, -72},
    { 760, 288, -48},
    { 856, 368, -48},
    { 976, 344, -24},
    { 1216, 360, -32},
    { 1416, 400, 0},
    { 1728, 344, 64},
    { 1648, 504, 8},
    { 1112, 408, 112},
    { 1312, 288, 72},
    { 1328, 216, 48},
    // 20 seconds
    { 1200, 200, 40},
    { 976, 168, 96},
    { 864, 192, 104},
    { 856, 200, 128},
    { 832, 168, 160},
    { 800, 152, 144},
    { 752, 160, 136},
    { 768, 96, 168},
    { 928, 72, 120},
    { 1112, 40, -40},
    { 1456, -8, 128},
    { 1552, 256, -104},
    { 1376, 400, -336},
    { 1488, 464, -248},
    { 1448, 560, -24},
    { 1112, 368, 24},
    { 864, 320, -8},
    { 728, 296, 32},
    { 688, 328, 24},
    { 744, 360, 0},
    { 848, 408, -8},
    { 896, 408, 0},
    { 1128, 424, -16},
    { 1328, 400, -16},
    { 1480, 232, 160},
    // 21 seconds
    { 1712, 448, -24},
    { 1240, 496, -24},
    { 1232, 264, 72},
    { 1360, 256, 80},
    { 1288, 272, 104},
    { 992, 248, 120},
    { 848, 248, 128},
    { 840, 232, 160},
    { 848, 168, 176},
    { 824, 80, 32},
    { 768, -24, 88},
    { 776, 128, 128},
    { 952, 240, 168},
    { 1040, 200, 136},
    { 1432, 160, 176},
    { 1584, 456, -256},
    { 1312, 448, -312},
    { 1296, 632, -184},
    { 1272, 616, 136},
    { 1144, 288, 272},
    { 1024, 144, 40},
    { 776, 136, 32},
    { 704, 304, 0},
    { 752, 400, -24},
    { 896, 424, -8},
    // 22 seconds
    { 936, 432, 16},
    { 1064, 440, 8},
    { 1296, 480, -16},
    { 1424, 368, 200},
    { 1768, 432, 160},
    { 1416, 536, 88},
    { 1048, 376, 120},
    { 1224, 272, 168},
    { 1240, 272, 192},
    { 1040, 280, 200},
    { 856, 288, 192},
    { 816, 296, 168},
    { 888, 224, 216},
    { 848, 184, 192},
    { 816, 144, 184},
    { 816, 104, 168},
    { 944, 88, 136},
    { 1040, 88, 56},
    { 1216, -56, 176},
    { 1584, 104, 104},
    { 1264, 216, -400},
    { 1216, 80, -240},
    { 1456, 256, -216},
    { 1416, 480, -16},
    { 992, 480, 48},
    // 23 seconds
    { 832, 416, 16},
    { 768, 336, 8},
    { 776, 368, 16},
    { 872, 400, 16},
    { 896, 376, 48},
    { 1024, 392, 48},
    { 1248, 432, 32},
    { 1456, 344, 176},
    { 1752, 424, 72},
    { 1408, 440, 24},
    { 1232, 304, 96},
    { 1352, 192, 128},
    { 1360, 112, 128},
    { 1152, 176, 96},
    { 928, 176, 104},
    { 792, 144, 120},
    { 744, 120, 112},
    { 712, 112, 112},
    { 672, 96, 112},
    { 688, 96, 104},
    { 808, 80, 128},
    { 1056, 112, 104},
    { 1184, 40, 56},
    { 1792, -32, 168},
    { 1776, 456, -304},
    // 24 seconds
    { 1264, 512, -256},
    { 1424, 496, -312},
    { 1352, 336, -8},
    { 1080, 344, 48},
    { 832, 368, 48},
    { 656, 352, 0},
    { 640, 304, 40},
    { 688, 280, 72},
    { 784, 312, 56},
    { 888, 320, 64},
    { 1048, 352, 24},
    { 1288, 392, -8},
    { 1528, 296, 128},
    { 1544, 496, 40},
    { 1248, 544, -40},
    { 1344, 368, 24},
    { 1344, 344, 40},
    { 1232, 312, 72},
    { 968, 232, 112},
    { 856, 224, 80},
    { 832, 248, 96},
    { 824, 184, 136},
    { 840, 160, 144},
    { 832, 144, 128},
    { 880, 144, 176},
    // 25 seconds
    { 1048, 80, 192},
    { 1192, 32, 240},
    { 1504, 120, 200},
    { 1336, 264, -72},
    { 1184, 360, -240},
    { 1208, 360, -200},
    { 1352, 376, -24},
    { 1248, 280, 56},
    { 984, 264, -32},
    { 832, 288, -40},
    { 768, 280, -40},
    { 792, 304, -56},
    { 864, 296, -48},
    { 928, 296, -16},
    { 1016, 288, -8},
    { 1240, 320, -16},
    { 1352, 288, 112},
    { 1872, 304, 120},
    { 1392, 576, -32},
    { 1160, 344, 96},
    { 1336, 280, 88},
    { 1368, 208, 96},
    { 1168, 240, 88},
    { 944, 192, 96},
    { 840, 128, 112},
    // 26 seconds
    { 856, 144, 136},
    { 848, 128, 160},
    { 800, 112, 120},
    { 760, 128, 80},
    { 800, 112, 104},
    { 832, 72, 96},
    { 1040, -8, 160},
    { 1488, 96, 40},
    { 1520, 312, -320},
    { 1600, 336, -312},
    { 1608, 496, -176},
    { 1320, 272, 96},
    { 992, 256, 56},
    { 808, 264, 8},
    { 680, 344, -32},
    { 664, 376, -56},
    { 768, 376, 16},
    { 912, 400, 16},
    { 1088, 440, 64},
    { 1376, 504, -64},
    { 1392, 424, -8},
    { 1736, 320, 64},
    { 1464, 456, 16},
    { 1200, 416, 64},
    { 1376, 320, 144},
    // 27 seconds
    { 1392, 288, 216},
    { 1208, 248, 192},
    { 1000, 336, 176},
    { 840, 192, 192},
    { 760, 152, 152},
    { 752, 136, 168},
    { 712, 120, 144},
    { 696, 136, 112},
    { 728, 128, 112},
    { 920, 104, 152},
    { 1104, 128, 96},
    { 1472, 104, 192},
    { 1768, 400, 24},
    { 1288, 536, -256},
    { 1264, 552, -224},
    { 1368, 544, -40},
    { 1264, 200, 72},
    { 960, 200, 16},
    { 800, 272, -64},
    { 760, 344, -96},
    { 784, 304, -72},
    { 864, 272, -72},
    { 984, 248, -72},
    { 1072, 240, -72},
    { 1248, 304, -72},
    // 28 seconds
    { 1328, 336, 112},
    { 1872, 384, 176},
    { 1296, 600, 80},
    { 1136, 344, 152},
    { 1304, 272, 160},
    { 1384, 280, 136},
    { 1152, 240, 160},
    { 904, 200, 152},
    { 808, 216, 136},
    { 832, 176, 144},
    { 792, 144, 160},
    { 752, 136, 136},
    { 744, 128, 112},
    { 808, 88, 112},
    { 1040, 120, 120},
    { 1184, 80, 112},
    { 1672, 144, 152},
    { 1488, 456, -168},
    { 1264, 456, -248},
    { 1432, 552, -200},
    { 1312, 384, 32},
    { 1072, 192, 56},
    { 888, 208, -8},
    { 776, 336, -64},
    { 720, 360, -56},
    // 29 seconds
    { 784, 352, -56},
    { 888, 336, -56},
    { 984, 304, 24},
    { 1256, 344, 8},
    { 1384, 392, 16},
    { 1760, 320, 120},
    { 1488, 440, 40},
    { 1184, 400, 64},
    { 1304, 256, 152},
    { 1280, 216, 168},
    { 1176, 208, 136},
    { 952, 232, 96},
    { 800, 216, 120},
    { 744, 168, 152},
    { 760, 136, 144},
    { 720, 128, 144},
    { 720, 136, 136},
    { 784, 112, 152},
    { 1056, 120, 176},
    { 1208, 120, 184},
    { 1736, 136, 240},
    { 1648, 480, -160},
    { 1288, 520, -296},
    { 1320, 600, -256},
    { 1256, 248, 72},
    // 30 seconds
    { 1152, 176, 8},
    { 896, 200, -16},
    { 720, 328, -40},
    { 624, 320, 8},
    { 656, 296, 0},
    { 816, 304, -24},
    { 880, 320, -16},
    { 1056, 352, -32},
    { 1304, 400, -48},
    { 1224, 400, 8},
    { 1560, 336, 64},
    { 1496, 504, 88},
    { 1048, 544, 80},
    { 1176, 408, 88},
    { 1384, 408, 96},
    { 1336, 344, 184},
    { 1080, 304, 208},
    { 1008, 288, 184},
    { 936, 120, 136},
    { 864, 200, 104},
    { 760, 152, 136},
    { 680, 112, 80},
    { 640, 64, 80},
    { 760, 40, 88},
    { 872, 56, 56},
    // 31 seconds
    { 1368, -16, 176},
    { 1688, 304, -328},
    { 1512, 168, -288},
    { 1536, 160, -72},
    { 1488, 384, -24},
    { 1080, 328, 120},
    { 912, 320, 96},
    { 784, 304, -32},
    { 728, 352, -16},
    { 768, 448, -48},
    { 832, 440, 24},
    { 976, 488, 32},
    { 1248, 488, -8},
    { 1360, 480, -16},
    { 1736, 440, -24},
    { 1536, 424, -96},
    { 1176, 336, 0},
    { 1392, 352, 32},
    { 1496, 328, 64},
    { 1176, 232, 120},
    { 952, 224, 128},
    { 864, 216, 128},
    { 808, 192, 152},
    { 784, 152, 200},
    { 752, 136, 200},
    // 32 seconds
    { 688, 152, 192},
    { 736, 112, 200},
    { 880, 120, 184},
    { 1080, 16, 248},
    { 1536, 240, 168},
    { 1544, 480, -136},
    { 1680, 640, -192},
    { 1448, 808, -176},
    { 1328, 160, 16},
    { 1168, -384, -312},
    { 784, 328, -280},
    { 760, 624, -192},
    { 584, 280, 112},
    { 592, 120, 152},
    { 808, 240, 16},
    { 992, 312, 32},
    { 1272, 432, -16},
    { 1368, 440, 80},
    { 1888, 456, 40},
    { 1560, 560, -32},
    { 1096, 344, 32},
    { 1296, 288, 24},
    { 1320, 304, 8},
    { 1072, 280, 72},
    { 888, 264, 88},
    // 33 seconds
    { 832, 168, 104},
    { 832, 144, 120},
    { 808, 120, 128},
    { 776, 136, 152},
    { 728, 144, 152},
    { 816, 136, 168},
    { 1024, 128, 192},
    { 1224, 104, 192},
    { 1696, 344, -48},
    { 1448, 472, -304},
    { 1240, 448, -296},
    { 1336, 512, -328},
    { 1320, 336, -88},
    { 1032, 240, -32},
    { 800, 232, -8},
    { 712, 272, -8},
    { 736, 304, -64},
    { 856, 336, -64},
    { 944, 312, 8},
    { 1032, 288, 0},
    { 1224, 248, 32},
    { 1264, 336, 8},
    { 1496, 240, 144},
    { 1576, 408, 96},
    { 1240, 448, 64},
    // 34 seconds
    { 1152, 272, 104},
    { 1232, 304, 96},
    { 1264, 272, 144},
    { 1024, 200, 168},
    { 880, 232, 136},
    { 816, 184, 144},
    { 808, 144, 144},
    { 776, 120, 160},
    { 752, 192, 136},
    { 752, 160, 160},
    { 912, 152, 144},
    { 1072, 128, 120},
    { 1464, 48, 248},
    { 1536, 320, 48},
    { 1360, 432, -328},
    { 1320, 344, -264},
    { 1352, 296, -112},
    { 1232, 128, 40},
    { 984, 176, 40},
    { 816, 280, 0},
    { 728, 320, -24},
    { 728, 312, -48},
    { 800, 240, -96},
    { 872, 216, -48},
    { 1040, 288, -48},
    // 35 seconds
    { 1264, 320, -80},
    { 1424, 312, 40},
    { 1776, 496, -24},
    { 1496, 504, -8},
    { 1120, 424, 40},
    { 1280, 360, 48},
    { 1256, 232, 80},
    { 1136, 240, 80},
    { 944, 224, 104},
    { 848, 216, 104},
    { 832, 224, 120},
    { 816, 160, 136},
    { 768, 168, 120},
    { 720, 144, 112},
    { 808, 112, 96},
    { 936, 72, 104},
    { 1096, -48, 192},
    { 1632, 56, 168},
    { 1568, 568, -384},
    { 1304, 392, -320},
    { 1360, 384, -288},
    { 1344, 488, -192},
    { 1080, 416, -96},
    { 840, 296, -32},
    { 688, 360, -32},
    // 36 seconds
    { 648, 360, -8},
    { 744, 344, 8},
    { 848, 376, 0},
    { 952, 408, 8},
    { 1136, 472, -16},
    { 1320, 512, -16},
    { 1624, 456, 0},
    { 1448, 368, 56},
    { 1272, 472, -120},
    { 1128, 328, -8},
    { 1176, 296, 0},
    { 1232, 296, 0},
    { 1032, 224, 64},
    { 928, 208, 88},
    { 888, 208, 112},
    { 912, 224, 144},
    { 880, 176, 160},
    { 816, 160, 152},
    { 776, 128, 136},
    { 872, 88, 136},
    { 1016, 80, 96},
    { 1160, 0, 128},
    { 1592, 96, 88},
    { 1608, 400, -304},
    { 1232, 392, -312},
    // 37 seconds
    { 1280, 440, -280},
    { 1296, 424, -96},
    { 1192, 400, -48},
    { 912, 416, -24},
    { 728, 360, -16},
    { 680, 328, -16},
    { 736, 352, 24},
    { 888, 400, 48},
    { 976, 424, 64},
    { 1064, 424, 16},
    { 1248, 448, -16},
    { 1424, 376, 88},
    { 1528, 536, -8},
    { 1280, 504, -56},
    { 1144, 320, 40},
    { 1256, 352, 16},
    { 1320, 360, 56},
    { 1112, 288, 104},
    { 960, 280, 96},
    { 896, 248, 136},
    { 872, 152, 184},
    { 856, 104, 176},
    { 800, 192, 152},
    { 760, 192, 152},
    { 856, 112, 160},
    // 38 seconds
    { 1040, 96, 112},
    { 1400, 24, 256},
    { 1408, 256, -56},
    { 1392, 312, -408},
    { 1344, 336, -328},
    { 1328, 352, -152},
    { 1280, 280, -32},
    { 1032, 320, -32},
    { 832, 344, -16},
    { 744, 360, 16},
    { 736, 352, 40},
    { 784, 376, 56},
    { 872, 368, 8},
    { 912, 304, 8},
    { 1072, 320, -8},
    { 1160, 368, 8},
    { 1360, 296, 144},
    { 1648, 536, -48},
    { 1216, 504, -32},
    { 1312, 336, 16},
    { 1416, 304, -16},
    { 1320, 312, -16},
    { 1032, 208, 40},
    { 904, 200, 8},
    { 864, 208, 48},
    // 39 seconds
    { 840, 160, 96},
    { 800, 112, 128},
    { 784, 136, 120},
    { 816, 120, 120},
    { 976, 128, 152},
    { 1128, 144, 144},
    { 1496, 64, 208},
    { 1544, 328, -120},
    { 1224, 400, -376},
    { 1224, 384, -304},
    { 1352, 320, -184},
    { 1232, 176, -88},
    { 960, 248, -64},
    { 776, 320, -88},
    { 704, 288, -56},
    { 696, 216, -32},
    { 792, 240, -64},
    { 880, 272, -56},
    { 984, 288, -64},
    { 1216, 320, -80},
    { 1280, 344, -8},
    { 1616, 360, 0},
    { 1440, 504, 24},
    { 1136, 440, -88},
    { 1104, 312, -32},
    // 40 seconds
    { 1136, 312, -80},
    { 1216, 296, -56},
    { 1144, 288, 8},
    { 1032, 288, 88},
    { 968, 264, 96},
    { 952, 248, 104},
    { 928, 200, 144},
    { 904, 168, 144},
    { 888, 160, 152},
    { 952, 128, 168},
    { 1072, 128, 128},
    { 1352, 56, 160},
    { 1176, 304, 24},
    { 1136, 120, -368},
    { 1296, 96, -336},
    { 1432, 184, -216},
    { 1312, 168, -80},
    { 1040, 200, -88},
    { 888, 280, -96},
    { 768, 232, -64},
    { 712, 176, -16},
    { 768, 264, -48},
    { 808, 256, -80},
    { 936, 248, -104},
    { 1240, 312, -120},
    // 41 seconds
    { 1416, 376, -112},
    { 1792, 416, -208},
    { 1720, 456, -168},
    { 1248, 400, -144},
    { 1192, 328, -40},
    { 1208, 248, 32},
    { 1168, 272, -24},
    { 1000, 216, 48},
    { 920, 160, 112},
    { 912, 184, 120},
    { 912, 160, 160},
    { 896, 152, 152},
    { 880, 160, 112},
    { 928, 112, 120},
    { 1040, 0, 8},
    { 1080, -216, -16},
    { 1352, 0, 248},
    { 1256, 312, -312},
    { 1048, 280, -424},
    { 1400, 184, -320},
    { 1576, 376, -136},
    { 1160, 408, -88},
    { 864, 376, -72},
    { 808, 360, -32},
    { 752, 376, 16},
    // 42 seconds
    { 768, 368, 48},
    { 816, 464, 0},
    { 880, 520, 24},
    { 1120, 608, 0},
    { 1304, 656, -24},
    { 1512, 520, 88},
    { 1480, 488, 24},
    { 1240, 520, -136},
    { 1184, 416, 24},
    { 1328, 352, -24},
    { 1352, 288, 0},
    { 1096, 224, 48},
    { 960, 224, 32},
    { 904, 200, 56},
    { 888, 144, 80},
    { 856, 128, 104},
    { 816, 144, 88},
    { 792, 88, 104},
    { 856, 80, 128},
    { 992, 72, 120},
    { 1248, -24, 200},
    { 1592, 192, 88},
    { 1408, 408, -304},
    { 1264, 408, -208},
    { 1448, 512, -264},
    // 43 seconds
    { 1312, 344, -24},
    { 1032, 224, 32},
    { 864, 328, -48},
    { 728, 344, -32},
    { 712, 360, -8},
    { 824, 448, -24},
    { 888, 464, -16},
    { 1008, 448, -8},
    { 1248, 464, -24},
    { 1288, 440, -8},
    { 1600, 320, 144},
    { 1632, 480, 0},
    { 1160, 424, -48},
    { 1272, 280, 64},
    { 1432, 232, 64},
    { 1312, 208, 120},
    { 1040, 208, 112},
    { 880, 208, 80},
    { 832, 192, 96},
    { 792, 136, 120},
    { 696, 136, 112},
    { 648, 120, 88},
    { 672, 88, 96},
    { 872, 64, 112},
    { 1080, 104, 112},
    // 44 seconds
    { 1632, 112, 184},
    { 1728, 416, -144},
    { 1424, 544, -280},
    { 1448, 712, -296},
    { 1352, 416, 88},
    { 1216, 88, 48},
    { 920, 120, 8},
    { 728, 280, -32},
    { 656, 392, -32},
    { 728, 400, 0},
    { 888, 432, -16},
    { 944, 408, -8},
    { 1136, 360, 0},
    { 1368, 352, -48},
    { 1472, 240, 136},
    { 1616, 312, 88},
    { 1408, 464, 24},
    { 1064, 352, 88},
    { 1216, 288, 152},
    { 1264, 256, 136},
    { 1104, 288, 152},
    { 928, 232, 168},
    { 848, 184, 168},
    { 872, 200, 144},
    { 832, 160, 152},
    // 45 seconds
    { 752, 128, 152},
    { 720, 112, 136},
    { 848, 104, 136},
    { 1056, 112, 128},
    { 1304, 32, 248},
    { 1576, 224, 136},
    { 1480, 440, -328},
    { 1256, 440, -312},
    { 1312, 488, -200},
    { 1328, 256, 40},
    { 1152, 224, -24},
    { 888, 248, -16},
    { 752, 296, -16},
    { 680, 304, 0},
    { 752, 312, 24},
    { 848, 360, -8},
    { 912, 336, 16},
    { 1112, 320, 24},
    { 1312, 368, 0},
    { 1600, 296, 144},
    { 1552, 432, 72},
    { 1360, 472, -16},
    { 1120, 392, 48},
    { 1248, 336, 80},
    { 1272, 240, 136},
    // 46 seconds
    { 1096, 232, 120},
    { 944, 208, 112},
    { 888, 216, 120},
    { 864, 192, 152},
    { 840, 160, 144},
    { 776, 120, 144},
    { 736, 128, 112},
    { 800, 112, 120},
    { 968, 128, 112},
    { 1008, 192, 48},
    { 1440, 88, 200},
    { 1648, 384, -112},
    { 1312, 472, -240},
    { 1432, 560, -216},
    { 1368, 368, 72},
    { 1120, 192, 80},
    { 888, 256, 24},
    { 752, 304, -40},
    { 696, 336, -40},
    { 760, 336, 24},
    { 888, 384, 16},
    { 968, 392, 8},
    { 1104, 424, -48},
    { 1256, 408, -32},
    { 1504, 288, 176},
    // 47 seconds
    { 1728, 472, 32},
    { 1184, 512, 32},
    { 1192, 312, 72},
    { 1328, 304, 64},
    { 1352, 280, 120},
    { 1040, 208, 184},
    { 896, 208, 144},
    { 864, 208, 152},
    { 864, 184, 168},
    { 784, 136, 168},
    { 736, 136, 120},
    { 736, 120, 104},
    { 856, 96, 104},
    { 984, 112, 64},
    { 1504, 88, 136},
    { 1584, 352, -264},
    { 1424, 304, -328},
    { 1528, 352, -280},
    { 1376, 352, -96},
    { 1096, 272, -32},
    { 896, 264, 8},
    { 736, 288, -8},
    { 656, 304, -24},
    { 688, 320, 0},
    { 808, 328, -8},
    // 48 seconds
    { 960, 376, 0},
    { 1136, 464, 8},
    { 1296, 544, -16},
    { 1392, 392, 176},
    { 1568, 488, 24},
    { 1448, 504, -64},
    { 1136, 408, 32},
    { 1272, 360, 24},
    { 1344, 312, 24},
    { 1112, 200, 80},
    { 952, 176, 96},
    { 912, 248, 96},
    { 912, 176, 144},
    { 864, 136, 144},
    { 792, 128, 160},
    { 728, 152, 136},
    { 776, 112, 128},
    { 928, 112, 120},
    { 1016, 64, 112},
    { 1656, 128, 184},
    { 1568, 472, -264},
    { 1240, 400, -216},
    { 1464, 592, -344},
    { 1352, 392, -72},
    { 1088, 280, -40},
    // 49 seconds
    { 872, 344, -32},
    { 720, 320, -32},
    { 672, 328, 0},
    { 744, 344, 8},
    { 832, 376, 24},
    { 952, 440, 48},
    { 1128, 488, 32},
    { 1296, 480, 40},
    { 1376, 392, 168},
    { 1616, 520, 32},
    { 1368, 488, 8},
    { 1072, 416, -24},
    { 1168, 336, -40},
    { 1224, 264, 0},
    { 1248, 192, 16},
    { 1096, 200, 88},
    { 976, 200, 96},
    { 936, 208, 104},
    { 888, 184, 112},
    { 832, 152, 120},
    { 808, 120, 120},
    { 840, 72, 120},
    { 1008, 64, 144},
    { 1112, 88, 96},
    { 1464, 40, 232},
    // 50 seconds
    { 1440, 320, -40},
    { 1264, 416, -184},
    { 1512, 480, -256},
    { 1448, 504, -40},
    { 1120, 152, 120},
    { 904, 192, 56},
    { 752, 248, 24},
    { 696, 328, 24},
    { 704, 368, 0},
    { 808, 368, 0},
    { 960, 368, 16},
    { 1096, 416, -16},
    { 1336, 432, -32},
    { 1520, 344, 80},
    { 1784, 320, 72},
    { 1432, 408, 16},
    { 1080, 384, 24},
    { 1232, 304, 32},
    { 1264, 216, 96},
    { 1160, 128, 128},
    { 984, 176, 136},
    { 864, 176, 160},
    { 840, 200, 160},
    { 800, 192, 184},
    { 800, 176, 192},
    // 51 seconds
    { 784, 144, 160},
    { 808, 112, 176},
    { 1016, 120, 200},
    { 1304, 224, 104},
    { 1680, 248, 200},
    { 1432, 416, -48},
    { 1104, 472, -280},
    { 1088, 328, -208},
    { 1176, 160, -72},
    { 1232, 200, -40},
    { 1008, 304, -40},
    { 776, 432, -80},
    { 688, 376, -72},
    { 680, 296, -56},
    { 712, 272, -56},
    { 792, 304, -32},
    { 904, 392, -56},
    { 1128, 480, -56},
    { 1312, 568, -64},
    { 1616, 376, 152},
    { 1936, 448, 40},
    { 1000, 480, 32},
    { 1160, 288, 96},
    { 1280, 320, 0},
    { 1104, 296, 0},
    // 52 seconds
    { 912, 224, 96},
    { 848, 232, 104},
    { 872, 256, 128},
    { 864, 216, 152},
    { 816, 192, 128},
    { 736, 208, 104},
    { 760, 168, 112},
    { 888, 200, 88},
    { 920, 184, -8},
    { 1416, 88, 208},
    { 1600, 472, -328},
    { 1384, 64, -176},
    { 1632, 16, -104},
    { 1544, 40, -304},
    { 952, 176, -144},
    { 696, 248, -48},
    { 696, 336, -96},
    { 680, 272, -96},
    { 824, 312, -80},
    { 968, 384, -120},
    { 1064, 408, -104},
    { 1376, 464, -128},
    { 1448, 352, 64},
    { 1936, 384, 56},
    { 1320, 488, -40},
    // 53 seconds
    { 1184, 256, 96},
    { 1328, 248, 120},
    { 1360, 328, 72},
    { 1056, 256, 72},
    { 872, 208, 96},
    { 816, 208, 128},
    { 848, 144, 168},
    { 824, 72, 152},
    { 752, 88, 112},
    { 720, 128, 96},
    { 808, 96, 96},
    { 896, 112, 56},
    { 1224, -32, 168},
    { 1736, 304, -24},
    { 1384, 408, -280},
    { 1504, 488, -288},
    { 1544, 744, -256},
    { 1248, 432, -48},
    { 968, 304, -40},
    { 808, 312, -40},
    { 704, 392, -40},
    { 720, 416, -24},
    { 784, 408, -32},
    { 904, 392, -8},
    { 1072, 440, -24},
    // 54 seconds
    { 1280, 464, 0},
    { 1272, 440, 64},
    { 1696, 424, 40},
    { 1352, 472, 48},
    { 1016, 368, 40},
    { 1280, 328, -8},
    { 1480, 352, 0},
    { 1272, 280, 104},
    { 984, 192, 96},
    { 896, 216, 64},
    { 872, 224, 80},
    { 824, 144, 120},
    { 768, 112, 96},
    { 696, 112, 72},
    { 704, 104, 80},
    { 864, 88, 104},
    { 1040, 120, 8},
    { 1576, 72, 40},
    { 1720, 320, -232},
    { 1416, 440, -232},
    { 1456, 656, -304},
    { 1336, 616, -32},
    { 1232, 360, -8},
    { 984, 320, -8},
    { 752, 344, 16},
    // 55 seconds
    { 624, 312, 24},
    { 608, 272, 24},
    { 720, 320, -8},
    { 840, 336, 32},
    { 1056, 336, 40},
    { 1336, 464, 56},
    { 1376, 464, 152},
    { 1792, 392, -16},
    { 1440, 360, -72},
    { 1120, 360, -104},
    { 1256, 256, -48},
    { 1240, 128, 8},
    { 1200, 248, 0},
    { 992, 264, 56},
    { 896, 232, 96},
    { 904, 200, 136},
    { 896, 176, 160},
    { 864, 168, 152},
    { 800, 136, 160},
    { 864, 120, 176},
    { 1008, 160, 160},
    { 1080, 80, 184},
    { 1424, 144, 144},
    { 1320, 304, -152},
    { 1120, 320, -192},
    // 56 seconds
    { 1368, 352, -192},
    { 1480, 408, -104},
    { 1200, 248, 8},
    { 928, 256, -24},
    { 816, 280, -16},
    { 768, 328, -24},
    { 808, 384, -40},
    { 856, 400, -32},
    { 912, 400, -48},
    { 1160, 400, -48},
    { 1376, 448, -16},
    { 1568, 368, 144},
    { 1568, 464, 56},
    { 1496, 488, 16},
    { 1152, 376, 64},
    { 1168, 312, 64},
    { 1184, 264, 80},
    { 1080, 224, 104},
    { 952, 224, 136},
    { 872, 216, 152},
    { 856, 184, 176},
    { 840, 160, 168},
    { 816, 160, 168},
    { 800, 152, 144},
    { 880, 136, 152},
    // 57 seconds
    { 1016, 128, 128},
    { 1184, 24, 192},
    { 1416, 176, 120},
    { 1240, 384, -192},
    { 1224, 368, -264},
    { 1456, 472, -240},
    { 1408, 368, -40},
    { 1072, 200, 24},
    { 912, 216, 8},
    { 840, 288, -16},
    { 840, 384, -40},
    { 888, 456, -80},
    { 928, 424, -64},
    { 992, 344, -32},
    { 1160, 280, -48},
    { 1208, 240, 56},
    { 1184, 248, 120},
    { 1536, 256, 144},
    { 1288, 440, 128},
    { 960, 488, 104},
    { 1240, 440, 168},
    { 1512, 496, 184},
    { 1208, 440, 248},
    { 896, 200, 296},
    { 800, 144, 208},
    // 58 seconds
    { 872, 232, 208},
    { 984, 344, 240},
    { 1016, 288, 272},
    { 960, 208, 256},
    { 1000, 144, 224},
    { 1080, 72, 184},
    { 1208, 56, 176},
    { 1296, 264, 0},
    { 912, 296, -304},
    { 896, 176, -392},
    { 1344, 184, -456},
    { 1472, 216, -240},
    { 1128, 304, -120},
    { 912, 360, -80},
    { 952, 336, -56},
    { 976, 320, -16},
    { 968, 416, -48},
    { 880, 368, -24},
    { 928, 304, 32},
    { 1088, 320, 96},
    { 1104, 368, 104},
    { 1064, 352, 152},
    { 1272, 280, 264},
    { 1576, 536, 40},
    { 968, 632, 40},
    // 59 seconds
    { 1272, 384, 160},
    { 1528, 432, 168},
    { 1224, 296, 184},
    { 992, 176, 152},
    { 952, 224, 88},
    { 992, 240, 144},
    { 976, 104, 184},
    { 864, 48, 160},
    { 792, 120, 80},
    { 760, 80, 64},
    { 832, 40, 56},
    { 1112, -88, 136},
    { 1488, 120, -72},
    { 1392, 208, -432},
    { 1480, 232, -328},
    { 1528, 408, -264},
    { 1320, 248, -64},
    { 1056, 192, -24},
    { 912, 288, -8},
    { 792, 264, -16},
    { 736, 248, -16},
    { 776, 344, -32},
    { 896, 456, -40},
    { 1000, 560, -48},
    { 1200, 600, -56},
    // 60 seconds
    // elapsed: 1 minutes
    { 1216, 624, -80},
    { 1464, 520, 56},
    { 1552, 624, 88},
    { 1408, 832, 0},
    { 1216, 752, 176},
    { 1336, 728, 184},
    { 1328, 496, 88},
    { 1248, 488, -32},
    { 1160, 392, -96},
    { 1072, 320, -160},
    { 1000, 248, -296},
    { 952, 232, -424},
    { 768, 56, -384},
    { 696, 136, -448},
    { 616, 80, -536},
    { 560, 0, -640},
    { 520, 48, -768},
    { 416, 32, -760},
    { 472, 80, -696},
    { 368, 32, -752},
    { 368, 128, -856},
    { 312, -24, -1088},
    { 328, 88, -832},
    { 376, 104, -952},
    { 408, 48, -1008},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

