/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:19:44 local
AccelRawData *activity_sample_walk_200_pbl_25665_13(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25665_13
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 170
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -192, -528, -808},
    { -88, -552, -880},
    { -48, -376, -976},
    { -32, -368, -1000},
    { -96, -416, -1024},
    { -128, -344, -1008},
    { -136, -392, -1000},
    { -184, -368, -1008},
    { -160, -416, -976},
    { -144, -320, -992},
    { -152, -400, -1000},
    { -160, -392, -992},
    { -144, -440, -920},
    { -176, -392, -920},
    { -184, -376, -952},
    { -112, -344, -1048},
    { -104, -304, -1000},
    { -104, -280, -1024},
    { -56, -232, -1040},
    { -48, -256, -1056},
    { -128, -160, -1056},
    { 392, 0, -1032},
    { -736, -152, -1056},
    { -272, -320, -976},
    { -256, -312, -936},
    // 1 seconds
    { -320, -400, -1016},
    { -408, -488, -1240},
    { 1536, -304, -1488},
    { -136, -360, -1104},
    { -56, -304, -984},
    { -72, -376, -968},
    { -192, -272, -968},
    { -208, -216, -1000},
    { -232, -216, -968},
    { -248, -88, -976},
    { -320, -16, -968},
    { -352, 56, -1008},
    { -352, 128, -992},
    { -320, 96, -976},
    { -448, 240, -1048},
    { -376, 184, -944},
    { -384, 120, -824},
    { -432, 328, -864},
    { -464, 176, -792},
    { -432, 320, -840},
    { -424, 408, -848},
    { -336, 280, -784},
    { -304, 424, -944},
    { -432, 584, -856},
    { -432, 432, -816},
    // 2 seconds
    { -440, 512, -824},
    { -456, 480, -800},
    { -440, 448, -720},
    { -480, 584, -464},
    { -504, 768, -448},
    { -536, 816, -296},
    { -568, 960, -216},
    { -528, 816, -88},
    { -480, 880, 184},
    { -528, 888, 288},
    { -496, 752, 224},
    { -480, 784, 240},
    { -488, 792, 280},
    { -488, 744, 272},
    { -520, 736, 320},
    { -520, 752, 296},
    { -528, 696, 304},
    { -496, 696, 280},
    { -400, 632, 200},
    { -312, 536, -8},
    { -208, 448, -96},
    { 8, 440, -144},
    { 256, 520, -264},
    { 560, 440, -144},
    { 888, 736, -128},
    // 3 seconds
    { 1120, 832, -264},
    { 1408, 592, -80},
    { 1656, 712, -240},
    { 1416, 600, -88},
    { 1120, 576, -88},
    { 1120, 520, -288},
    { 1032, 624, -256},
    { 888, 840, -200},
    { 960, 992, -144},
    { 984, 1096, -96},
    { 808, 688, -176},
    { 776, 720, -96},
    { 1056, 624, 16},
    { 1432, 520, 96},
    { 1440, 504, 40},
    { 1320, 456, -8},
    { 1168, 472, -8},
    { 1136, 376, -16},
    { 1064, 320, -48},
    { 1080, 296, -144},
    { 1192, 312, -176},
    { 896, 88, -240},
    { 656, -112, -320},
    { 656, -144, -120},
    { 640, 112, -408},
    // 4 seconds
    { 1032, 280, -448},
    { 1336, 344, -352},
    { 1160, 296, -272},
    { 1016, 368, -256},
    { 1216, 424, -208},
    { 1264, 608, -184},
    { 1216, 704, -160},
    { 1008, 800, -288},
    { 952, 1016, -256},
    { 912, 1040, -216},
    { 1096, 1088, -192},
    { 1016, 832, -176},
    { 1240, 792, -192},
    { 1392, 656, -168},
    { 1088, 416, -144},
    { 984, 200, -160},
    { 1112, 272, -128},
    { 1352, 400, -184},
    { 1488, 184, -96},
    { 1256, 176, -136},
    { 1224, 224, -192},
    { 624, -328, -32},
    { 880, -48, -176},
    { 904, -184, -192},
    { 1088, 112, -304},
    // 5 seconds
    { 1216, 272, -304},
    { 1064, 232, -296},
    { 920, 304, -280},
    { 992, 344, -208},
    { 1272, 496, -192},
    { 1376, 624, -144},
    { 1392, 840, -192},
    { 1080, 880, -320},
    { 904, 1024, -208},
    { 888, 1048, -176},
    { 912, 968, -72},
    { 1048, 784, -120},
    { 1248, 696, -80},
    { 1352, 528, -88},
    { 1192, 336, -80},
    { 1168, 312, -120},
    { 1216, 328, -104},
    { 1272, 400, -72},
    { 1392, 208, -112},
    { 1352, 176, -208},
    { 1024, -208, -48},
    { 720, -256, -184},
    { 952, -320, 16},
    { 1176, 24, -384},
    { 1328, 72, -192},
    // 6 seconds
    { 1280, 272, -280},
    { 1048, 264, -224},
    { 960, 360, -192},
    { 1216, 472, -160},
    { 1336, 640, -120},
    { 1440, 896, -88},
    { 1264, 952, -192},
    { 888, 1248, -96},
    { 752, 1160, -32},
    { 968, 968, 56},
    { 1208, 872, -16},
    { 1440, 728, 0},
    { 1464, 504, -48},
    { 1200, 376, -96},
    { 1160, 288, -48},
    { 1288, 296, -104},
    { 1392, 336, -32},
    { 1368, 232, -80},
    { 1264, 152, -96},
    { 952, -360, -40},
    { 624, -88, -152},
    { 864, -400, -24},
    { 1216, 64, -336},
    { 1576, 128, -200},
    { 1384, 264, -200},
    // 7 seconds
    { 1008, 224, -240},
    { 936, 312, -208},
    { 1144, 416, -184},
    { 1280, 528, -168},
    { 1296, 688, -224},
    { 1240, 984, -320},
    { 920, 928, -536},
    { 864, 904, -512},
    { 1032, 1200, -240},
    { 1192, 856, -176},
    { 1296, 712, -144},
    { 1432, 600, -152},
    { 1168, 408, -120},
    { 1104, 328, -104},
    { 1208, 304, -104},
    { 1376, 336, -64},
    { 1544, 240, -32},
    { 1360, 144, -32},
    { 1120, -192, -48},
    { 608, -224, -176},
    { 1112, -368, -32},
    { 1160, -96, -352},
    { 1312, -104, -224},
    { 1352, 272, -184},
    { 1128, 216, -168},
    // 8 seconds
    { 1040, 352, -168},
    { 1240, 424, -144},
    { 1400, 608, -136},
    { 1512, 832, -96},
    { 1392, 1056, -136},
    { 1152, 1096, -328},
    { 776, 1368, -144},
    { 984, 1016, -24},
    { 1120, 880, -144},
    { 1264, 752, -64},
    { 1408, 648, -72},
    { 1312, 440, -72},
    { 1264, 232, -80},
    { 1320, 216, -104},
    { 1368, 336, 0},
    { 1424, 240, 0},
    { 1368, 224, 8},
    { 1376, 160, 0},
    { 824, -408, -64},
    { 760, -168, 32},
    { 840, -200, -224},
    { 1224, -8, -216},
    { 1304, 216, -176},
    { 1144, 240, -216},
    { 1048, 320, -288},
    // 9 seconds
    { 1184, 392, -184},
    { 1472, 560, -216},
    { 1632, 840, -192},
    { 1336, 1000, -208},
    { 1104, 1000, -456},
    { 776, 1168, -248},
    { 992, 1088, -128},
    { 1040, 888, -88},
    { 1200, 760, -64},
    { 1368, 624, -104},
    { 1216, 464, -80},
    { 1184, 304, -112},
    { 1232, 200, -152},
    { 1256, 320, -56},
    { 1360, 264, -24},
    { 1288, 256, -104},
    { 1304, 208, -144},
    { 872, -352, -120},
    { 952, -32, 8},
    { 712, -160, -376},
    { 1080, -88, -256},
    { 1336, 328, -232},
    { 1088, 152, -208},
    { 936, 344, -320},
    { 1008, 328, -208},
    // 10 seconds
    { 1184, 480, -208},
    { 1328, 608, -168},
    { 1360, 936, -176},
    { 1072, 848, -392},
    { 928, 1016, -368},
    { 1064, 1200, -176},
    { 1064, 856, -120},
    { 1120, 776, -144},
    { 1304, 696, -80},
    { 1432, 544, -64},
    { 1200, 304, -64},
    { 1104, 216, -136},
    { 1080, 264, -80},
    { 1232, 328, -64},
    { 1400, 200, -8},
    { 1256, 176, -56},
    { 1064, -328, -128},
    { 1216, -8, -48},
    { 520, -296, -256},
    { 1040, 0, -440},
    { 1336, 176, -128},
    { 1112, 232, -168},
    { 1080, 304, -264},
    { 1120, 400, -184},
    { 1232, 480, -120},
    // 11 seconds
    { 1368, 664, -104},
    { 1328, 856, -144},
    { 1120, 976, -240},
    { 840, 1312, -176},
    { 1024, 1288, -40},
    { 1136, 848, -56},
    { 1176, 864, -64},
    { 1312, 712, 0},
    { 1440, 584, -8},
    { 1288, 352, -40},
    { 1224, 264, -40},
    { 1264, 304, -40},
    { 1288, 272, -24},
    { 1304, 216, -8},
    { 1272, 184, 0},
    { 1064, 72, -56},
    { 640, -128, -216},
    { 984, -56, -208},
    { 768, -88, -296},
    { 1056, 176, -424},
    { 1152, 400, -408},
    { 1232, 320, -320},
    { 1208, 360, -248},
    { 1200, 472, -216},
    { 1248, 568, -192},
    // 12 seconds
    { 1208, 792, -80},
    { 968, 832, -120},
    { 864, 784, -184},
    { 672, 1008, -16},
    { 704, 840, 24},
    { 992, 832, -24},
    { 1024, 648, -88},
    { 1168, 632, -192},
    { 1528, 520, -152},
    { 1520, 408, -160},
    { 1416, 280, -256},
    { 1176, 280, -200},
    { 1080, 160, -72},
    { 960, 160, -56},
    { 776, 184, -24},
    { 656, 296, 0},
    { 528, 456, 64},
    { 368, 584, 24},
    { 216, 672, 16},
    { 104, 760, -8},
    { 88, 896, -24},
    { 104, 952, -32},
    { 176, 1000, -64},
    { 240, 1016, -56},
    { 224, 936, -56},
    // 13 seconds
    { 280, 840, -96},
    { 368, 752, -120},
    { 488, 688, -128},
    { 608, 600, -168},
    { 720, 520, -216},
    { 832, 480, -216},
    { 912, 448, -216},
    { 960, 416, -216},
    { 1024, 432, -216},
    { 1016, 416, -192},
    { 944, 416, -112},
    { 984, 440, -80},
    { 1072, 480, -64},
    { 1104, 576, -72},
    { 1024, 656, -64},
    { 880, 656, -96},
    { 768, 856, -72},
    { 952, 840, 16},
    { 896, 880, -16},
    { 704, 728, -64},
    { 1032, 680, 8},
    { 1504, 560, -24},
    { 1608, 360, -96},
    { 1384, 368, -80},
    { 1224, 256, -72},
    // 14 seconds
    { 1016, 368, -64},
    { 1136, 312, -120},
    { 1272, 288, -128},
    { 1168, 216, -144},
    { 816, 144, -240},
    { 584, -72, -136},
    { 624, 40, -224},
    { 888, 168, -368},
    { 1248, 264, -312},
    { 1264, 312, -248},
    { 1112, 312, -248},
    { 1080, 368, -200},
    { 1160, 472, -168},
    { 1256, 568, -136},
    { 1264, 664, -120},
    { 1144, 808, -168},
    { 1024, 1032, -144},
    { 888, 1040, -56},
    { 1056, 1040, -88},
    { 888, 744, -80},
    { 1008, 696, -104},
    { 1240, 640, -72},
    { 1160, 408, -40},
    { 1160, 280, -96},
    { 1264, 216, -104},
    // 15 seconds
    { 1344, 296, -40},
    { 1384, 216, -72},
    { 1208, 208, -120},
    { 1288, 160, -160},
    { 752, -416, -112},
    { 952, -168, 96},
    { 840, -56, -328},
    { 1112, 0, -376},
    { 1288, 272, -200},
    { 1064, 200, -216},
    { 984, 360, -320},
    { 1112, 400, -208},
    { 1280, 552, -240},
    { 1392, 752, -144},
    { 1072, 840, -208},
    { 1000, 880, -344},
    { 912, 1048, -104},
    { 1168, 1080, -32},
    { 992, 776, -32},
    { 1104, 728, -32},
    { 1304, 704, -24},
    { 1216, 400, -64},
    { 1000, 288, -120},
    { 1032, 312, -120},
    { 1104, 312, -56},
    // 16 seconds
    { 1168, 304, -48},
    { 1232, 216, -80},
    { 1312, 152, -32},
    { 976, -80, -192},
    { 984, 8, -200},
    { 776, -24, -208},
    { 984, 200, -384},
    { 1016, 288, -272},
    { 912, 272, -232},
    { 800, 280, -200},
    { 856, 352, -176},
    { 1040, 432, -120},
    { 1224, 608, -232},
    { 1264, 1000, -144},
    { 976, 1104, -384},
    { 912, 1360, -232},
    { 1040, 1288, -8},
    { 1392, 920, -8},
    { 1176, 904, -32},
    { 1152, 632, -56},
    { 1296, 496, -72},
    { 1152, 352, -40},
    { 1024, 280, -48},
    { 1032, 272, -48},
    { 1072, 232, -40},
    // 17 seconds
    { 1208, 176, -32},
    { 1160, 88, -40},
    { 1080, -112, -128},
    { 664, -168, -224},
    { 1080, -200, -296},
    { 904, -64, -192},
    { 1256, 232, -344},
    { 1296, 296, -256},
    { 1248, 320, -168},
    { 1096, 400, -208},
    { 1080, 456, -144},
    { 1192, 616, -160},
    { 1200, 864, -88},
    { 1024, 1144, -72},
    { 632, 1568, -128},
    { 800, 1160, -32},
    { 1088, 1248, 40},
    { 1416, 984, 128},
    { 1584, 784, 72},
    { 1576, 664, 56},
    { 1648, 456, 24},
    { 1312, 328, 24},
    { 1280, 304, -8},
    { 1280, 296, 24},
    { 1176, 240, 40},
    // 18 seconds
    { 1120, 184, 56},
    { 1000, 128, 64},
    { 928, 160, 32},
    { 576, -128, -72},
    { 344, -224, -272},
    { 808, -168, -200},
    { 944, 128, -248},
    { 1648, 416, -432},
    { 1576, 472, -344},
    { 1600, 448, -248},
    { 1400, 504, -248},
    { 1272, 472, -320},
    { 1184, 552, -296},
    { 952, 728, -320},
    { 704, 848, -424},
    { 648, 1024, -624},
    { 808, 1096, -464},
    { 968, 1000, -320},
    { 1536, 1168, -112},
    { 1648, 560, 80},
    { 1488, 680, -8},
    { 1720, 632, 144},
    { 1320, 368, 448},
    { 1248, 328, 432},
    { 1288, 344, 328},
    // 19 seconds
    { 1440, 256, 192},
    { 1400, 224, 80},
    { 1360, 240, -16},
    { 1408, 312, -32},
    { 1136, 112, -232},
    { 496, -560, -168},
    { 472, -568, -272},
    { 760, 8, -512},
    { 952, 16, -296},
    { 1392, 344, -368},
    { 1400, 240, -248},
    { 1408, 376, -232},
    { 1504, 472, -248},
    { 1592, 632, -216},
    { 1544, 728, -136},
    { 1304, 752, -328},
    { 848, 1168, -344},
    { 752, 1240, -224},
    { 1192, 1040, -160},
    { 1360, 872, -176},
    { 1328, 784, -80},
    { 1432, 752, -56},
    { 1344, 528, 8},
    { 1288, 160, -24},
    { 1280, 248, -120},
    // 20 seconds
    { 1328, 384, 8},
    { 1424, 376, 24},
    { 1584, 136, 24},
    { 1264, 64, 56},
    { 1152, 264, -96},
    { 808, -344, -56},
    { 312, 16, -104},
    { 696, 24, -336},
    { 912, -8, -152},
    { 1136, 200, -216},
    { 1064, 136, -304},
    { 1064, 232, -320},
    { 1352, 304, -240},
    { 1832, 496, -352},
    { 1792, 832, -384},
    { 1352, 816, -496},
    { 1040, 1040, -624},
    { 952, 1080, -384},
    { 1152, 992, -240},
    { 1072, 760, -312},
    { 1112, 792, -216},
    { 1336, 832, -96},
    { 1376, 480, -80},
    { 1312, 304, -104},
    { 1328, 248, -128},
    // 21 seconds
    { 1376, 312, -24},
    { 1464, 272, 40},
    { 1504, 152, 16},
    { 1320, 136, -8},
    { 1232, 272, -120},
    { 1032, 168, -192},
    { 504, -304, 144},
    { 368, -32, -264},
    { 832, 48, -336},
    { 1080, 232, -216},
    { 1264, 408, -320},
    { 1264, 328, -232},
    { 1448, 496, -208},
    { 1672, 616, -256},
    { 1448, 1000, -96},
    { 1448, 680, -360},
    { 1096, 1128, -328},
    { 840, 1168, -104},
    { 992, 1160, -80},
    { 1032, 816, -24},
    { 1176, 744, -56},
    { 1336, 752, 16},
    { 1376, 552, 16},
    { 1184, 352, -56},
    { 1232, 216, -144},
    // 22 seconds
    { 1304, 344, -72},
    { 1456, 272, 32},
    { 1592, 216, 24},
    { 1344, 224, -48},
    { 1168, 240, -176},
    { 672, -304, -184},
    { 528, -240, -64},
    { 712, -16, -328},
    { 1144, -8, -168},
    { 1256, 320, -200},
    { 1032, 256, -216},
    { 1032, 360, -240},
    { 1216, 432, -224},
    { 1600, 600, -248},
    { 1640, 872, -160},
    { 1488, 728, -392},
    { 1144, 928, -504},
    { 904, 1064, -192},
    { 1024, 1224, -96},
    { 832, 792, -120},
    { 968, 736, -136},
    { 1272, 760, -56},
    { 1368, 472, -32},
    { 1216, 296, -96},
    { 1272, 184, -168},
    // 23 seconds
    { 1224, 376, -64},
    { 1344, 256, -40},
    { 1304, 192, -112},
    { 1264, 160, -168},
    { 960, -248, -88},
    { 792, -64, -200},
    { 848, -264, -136},
    { 1016, 88, -448},
    { 1312, 88, -256},
    { 1304, 256, -272},
    { 1072, 216, -256},
    { 1008, 368, -280},
    { 1168, 368, -160},
    { 1368, 560, -184},
    { 1488, 848, -160},
    { 1160, 1064, -200},
    { 912, 1000, -392},
    { 864, 1072, -128},
    { 1128, 968, 0},
    { 1112, 768, -32},
    { 1184, 712, -16},
    { 1312, 632, -72},
    { 1152, 328, -80},
    { 1096, 208, -112},
    { 1144, 320, -88},
    // 24 seconds
    { 1264, 232, -72},
    { 1344, 288, -88},
    { 1280, 200, -80},
    { 1264, 168, -232},
    { 728, -280, -168},
    { 976, -128, -240},
    { 688, -128, -184},
    { 1088, 184, -392},
    { 1320, 200, -240},
    { 1192, 280, -248},
    { 1016, 352, -272},
    { 1000, 384, -192},
    { 1208, 464, -136},
    { 1384, 632, -88},
    { 1392, 928, 0},
    { 1144, 912, -208},
    { 936, 1264, -104},
    { 920, 1064, -40},
    { 1008, 1088, -40},
    { 1072, 800, -56},
    { 1176, 704, -40},
    { 1424, 648, -48},
    { 1360, 392, -40},
    { 1320, 288, -56},
    { 1344, 376, -48},
    // 25 seconds
    { 1392, 256, -64},
    { 1336, 192, -24},
    { 1224, 192, -64},
    { 1184, 232, -112},
    { 824, -48, -56},
    { 664, -160, -24},
    { 504, 200, -184},
    { 640, 96, -456},
    { 880, -64, -336},
    { 1064, 352, -344},
    { 1096, 64, -248},
    { 1216, 304, -256},
    { 1264, 440, -168},
    { 1536, 720, -192},
    { 1440, 1312, 24},
    { 1184, 872, -264},
    { 944, 1240, -104},
    { 968, 1208, 64},
    { 1064, 960, 144},
    { 968, 768, 160},
    { 1112, 664, 96},
    { 1360, 592, 32},
    { 1144, 384, 8},
    { 1040, 312, -48},
    { 1064, 288, -88},
    // 26 seconds
    { 1040, 288, -8},
    { 1040, 264, -40},
    { 1080, 224, -64},
    { 1152, 232, -72},
    { 944, 240, -184},
    { 720, -24, -208},
    { 680, 16, -232},
    { 832, 176, -376},
    { 1056, 232, -384},
    { 1272, 352, -304},
    { 1176, 400, -272},
    { 1056, 440, -184},
    { 1216, 536, -80},
    { 1320, 840, 16},
    { 1160, 816, 16},
    { 960, 888, -128},
    { 904, 1096, 0},
    { 936, 968, 160},
    { 1216, 952, 24},
    { 936, 672, -24},
    { 1032, 688, -24},
    { 1320, 592, -32},
    { 1136, 328, -16},
    { 992, 288, -88},
    { 1096, 304, -120},
    // 27 seconds
    { 1216, 280, -72},
    { 1256, 248, -72},
    { 1256, 168, -32},
    { 1432, 224, -120},
    { 1024, -448, -112},
    { 856, -24, 8},
    { 712, -144, -296},
    { 1064, 56, -200},
    { 1368, 408, -224},
    { 1264, 304, -192},
    { 1224, 456, -240},
    { 1280, 528, -160},
    { 1320, 752, -72},
    { 1488, 672, -160},
    { 1208, 816, -216},
    { 832, 1248, -88},
    { 808, 976, -48},
    { 1088, 928, -56},
    { 920, 664, 8},
    { 1056, 672, 48},
    { 1416, 704, 24},
    { 1424, 456, 0},
    { 1152, 280, -120},
    { 1144, 272, -96},
    { 1208, 400, -56},
    // 28 seconds
    { 1200, 248, -56},
    { 1224, 192, -24},
    { 1168, 136, -16},
    { 944, 208, -160},
    { 856, 24, -256},
    { 592, -80, -96},
    { 688, 80, -456},
    { 1120, 32, -272},
    { 1408, 400, -368},
    { 1112, 264, -256},
    { 976, 384, -224},
    { 1144, 432, -80},
    { 1336, 600, -72},
    { 1528, 768, 24},
    { 1280, 856, -64},
    { 952, 904, 24},
    { 848, 1048, 104},
    { 1152, 1016, 208},
    { 1008, 776, 136},
    { 1040, 728, 96},
    { 1184, 680, 88},
    { 1232, 480, 32},
    { 1120, 320, -64},
    { 1152, 192, -104},
    { 1176, 344, -40},
    // 29 seconds
    { 1368, 304, 24},
    { 1304, 232, 8},
    { 1200, 184, -48},
    { 1032, -64, -160},
    { 600, -88, -184},
    { 752, -112, -128},
    { 792, 88, -304},
    { 1232, 184, -280},
    { 1352, 352, -248},
    { 1080, 296, -216},
    { 944, 360, -232},
    { 1056, 368, -104},
    { 1232, 480, -128},
    { 1360, 624, -120},
    { 1112, 856, -96},
    { 848, 920, -216},
    { 960, 840, -200},
    { 1232, 1040, -8},
    { 1016, 784, 8},
    { 1016, 672, -16},
    { 1128, 664, -32},
    { 1192, 376, -80},
    { 1048, 256, -104},
    { 1064, 328, -96},
    { 1144, 360, -64},
    // 30 seconds
    { 1360, 232, -48},
    { 1264, 216, -32},
    { 1264, 224, -112},
    { 1104, -64, -184},
    { 784, -64, -200},
    { 808, -256, -80},
    { 864, 152, -360},
    { 1304, 160, -256},
    { 1128, 328, -224},
    { 928, 272, -208},
    { 864, 376, -200},
    { 1000, 360, -80},
    { 1224, 544, -104},
    { 1376, 736, -56},
    { 1072, 720, -40},
    { 960, 808, -224},
    { 968, 976, -56},
    { 1288, 1008, -16},
    { 1040, 872, -72},
    { 1080, 792, -48},
    { 1232, 696, -24},
    { 1168, 480, -48},
    { 1040, 328, -72},
    { 1064, 248, -64},
    { 1128, 312, -24},
    // 31 seconds
    { 1208, 272, -24},
    { 1480, 152, 24},
    { 1224, 128, 56},
    { 1200, 40, -160},
    { 688, -64, -128},
    { 944, -64, -104},
    { 760, -32, -320},
    { 1016, 128, -208},
    { 1168, 352, -200},
    { 1064, 248, -168},
    { 984, 368, -176},
    { 1168, 416, -80},
    { 1384, 600, -80},
    { 1480, 832, 8},
    { 1176, 752, -168},
    { 920, 1112, 32},
    { 832, 1336, 144},
    { 1208, 1064, 208},
    { 1008, 760, 120},
    { 1096, 752, 112},
    { 1344, 656, 88},
    { 1344, 408, -8},
    { 1200, 320, -48},
    { 1240, 288, -104},
    { 1272, 304, -40},
    // 32 seconds
    { 1448, 256, -72},
    { 1352, 136, 0},
    { 1152, 248, -120},
    { 888, -112, -208},
    { 712, -8, -192},
    { 704, -248, -208},
    { 784, 208, -384},
    { 1128, 216, -264},
    { 1248, 352, -208},
    { 1168, 304, -160},
    { 1096, 424, -168},
    { 1256, 416, -64},
    { 1384, 616, -80},
    { 1400, 736, -80},
    { 1176, 888, -96},
    { 880, 1408, 24},
    { 912, 1096, 72},
    { 1192, 1008, 112},
    { 1064, 808, 72},
    { 1168, 776, 88},
    { 1336, 656, 32},
    { 1240, 408, -16},
    { 1160, 288, -64},
    { 1280, 328, -88},
    { 1424, 320, -32},
    // 33 seconds
    { 1432, 208, 56},
    { 1208, 216, 24},
    { 1192, 192, -8},
    { 1104, 24, -216},
    { 720, -272, -144},
    { 704, -352, -160},
    { 888, 72, -464},
    { 1088, 80, -312},
    { 1312, 320, -272},
    { 1192, 328, -240},
    { 1232, 432, -256},
    { 1528, 456, -152},
    { 1728, 744, -152},
    { 1608, 904, -48},
    { 1152, 1456, -208},
    { 720, 1528, 0},
    { 944, 1448, 64},
    { 1040, 1120, 56},
    { 1264, 832, 24},
    { 1576, 752, 16},
    { 1624, 552, -24},
    { 1400, 328, -72},
    { 1320, 280, -104},
    { 1360, 216, -96},
    { 1416, 296, -64},
    // 34 seconds
    { 1360, 280, -168},
    { 1216, 264, -232},
    { 944, 24, -344},
    { 256, -280, -248},
    { 416, -264, -304},
    { 696, 136, -416},
    { 856, 256, -408},
    { 1208, 368, -424},
    { 1344, 352, -256},
    { 1360, 488, -272},
    { 1368, 600, -112},
    { 1480, 664, -216},
    { 1392, 880, -224},
    { 1024, 1072, -88},
    { 848, 1280, -8},
    { 832, 888, -8},
    { 1144, 1128, 88},
    { 1120, 816, 176},
    { 1176, 768, 160},
    { 1296, 624, 112},
    { 1168, 360, -32},
    { 984, 288, -104},
    { 1072, 304, -80},
    { 1216, 368, -64},
    { 1288, 280, -120},
    // 35 seconds
    { 1208, 224, -80},
    { 1136, 288, -184},
    { 920, 208, -248},
    { 752, 8, -272},
    { 624, -80, -240},
    { 688, 120, -464},
    { 1168, 168, -408},
    { 1304, 280, -320},
    { 1056, 336, -336},
    { 984, 376, -184},
    { 1192, 408, -144},
    { 1464, 584, -112},
    { 1408, 688, 24},
    { 1048, 1024, 128},
    { 976, 1064, 144},
    { 1032, 1024, 200},
    { 1112, 1136, 128},
    { 888, 800, 32},
    { 1016, 784, 16},
    { 1320, 720, 16},
    { 1656, 544, -120},
    { 1288, 184, -56},
    { 1208, 168, -112},
    { 1208, 312, -112},
    { 1168, 264, -144},
    // 36 seconds
    { 1176, 200, -96},
    { 1080, 144, -64},
    { 960, 168, -80},
    { 736, 0, -128},
    { 568, -32, -16},
    { 528, 104, -360},
    { 824, 24, -352},
    { 1280, 128, -232},
    { 1312, 328, -320},
    { 1208, 208, -304},
    { 1280, 344, -240},
    { 1480, 416, -200},
    { 1624, 664, -224},
    { 1376, 744, -232},
    { 1104, 976, -224},
    { 952, 1016, -272},
    { 936, 1104, -208},
    { 896, 936, -120},
    { 1120, 800, -56},
    { 1264, 664, -80},
    { 1256, 504, -96},
    { 1184, 408, -64},
    { 1272, 240, -120},
    { 1264, 280, -80},
    { 1512, 256, -80},
    // 37 seconds
    { 1424, 200, -24},
    { 1264, 232, -48},
    { 1296, 224, -88},
    { 848, -544, -32},
    { 816, -64, -88},
    { 792, -48, -240},
    { 1104, -168, -256},
    { 1216, 224, -96},
    { 1056, 264, -160},
    { 1048, 288, -312},
    { 1200, 368, -216},
    { 1600, 520, -296},
    { 1648, 848, -312},
    { 1200, 1088, -520},
    { 912, 1008, -720},
    { 840, 1096, -352},
    { 1272, 1008, -120},
    { 1008, 688, -104},
    { 1128, 616, -160},
    { 1320, 704, -104},
    { 1344, 464, -136},
    { 1256, 200, -136},
    { 1160, 192, -160},
    { 1208, 288, -144},
    { 1240, 248, -144},
    // 38 seconds
    { 1056, 232, -128},
    { 1240, 216, -240},
    { 960, -224, -136},
    { 648, -400, 56},
    { 752, -104, -280},
    { 1008, 40, -488},
    { 1344, 16, -232},
    { 1352, 368, -248},
    { 1176, 288, -272},
    { 1280, 360, -192},
    { 1584, 544, -176},
    { 1656, 880, -104},
    { 1344, 808, -96},
    { 976, 1096, -120},
    { 776, 1280, 176},
    { 1104, 1144, 240},
    { 968, 808, 104},
    { 1032, 712, 56},
    { 1232, 656, 72},
    { 1432, 512, 40},
    { 1304, 400, -80},
    { 1352, 200, -120},
    { 1344, 368, -32},
    { 1376, 272, -120},
    { 1328, 248, -120},
    // 39 seconds
    { 1344, 192, -112},
    { 1216, 40, -232},
    { 664, -352, -136},
    { 816, -264, -152},
    { 928, 0, -392},
    { 1264, 16, -160},
    { 1352, 352, -240},
    { 1208, 240, -144},
    { 1224, 408, -168},
    { 1520, 480, -24},
    { 1776, 744, -8},
    { 1504, 856, 144},
    { 1296, 776, -8},
    { 984, 1168, 280},
    { 1000, 1208, 360},
    { 968, 1096, 288},
    { 840, 928, 144},
    { 944, 808, 96},
    { 1312, 704, 56},
    { 1336, 504, -24},
    { 1304, 384, -88},
    { 1408, 240, -104},
    { 1496, 336, -24},
    { 1480, 280, -80},
    { 1504, 160, -16},
    // 40 seconds
    { 1360, 240, -56},
    { 1496, 24, -240},
    { 616, -424, 64},
    { 608, -136, -584},
    { 944, -392, -296},
    { 1120, 8, -192},
    { 968, 248, -288},
    { 1000, 280, -312},
    { 1240, 360, -216},
    { 1544, 504, -224},
    { 1832, 800, -80},
    { 1368, 1208, 24},
    { 1296, 1016, -312},
    { 760, 1496, -48},
    { 1104, 1240, 152},
    { 992, 1008, 88},
    { 1000, 848, 0},
    { 1192, 680, -16},
    { 1232, 528, 0},
    { 1096, 368, -40},
    { 1112, 248, -80},
    { 1248, 248, -152},
    { 1408, 160, -40},
    { 1328, 192, -96},
    { 1416, 256, -224},
    // 41 seconds
    { 1112, -192, -312},
    { 632, -392, -160},
    { 776, -208, -512},
    { 752, -168, -520},
    { 1232, 48, -408},
    { 1200, 264, -328},
    { 1048, 168, -360},
    { 1072, 296, -336},
    { 1280, 432, -320},
    { 1544, 616, -304},
    { 1496, 1168, -208},
    { 840, 1064, -520},
    { 744, 1240, -376},
    { 816, 1184, -160},
    { 1096, 1112, -8},
    { 1192, 720, 16},
    { 1464, 640, -24},
    { 1760, 616, -24},
    { 1408, 336, -24},
    { 1200, 192, -80},
    { 1152, 304, -120},
    { 1336, 272, -144},
    { 1368, 216, -88},
    { 1144, 152, -144},
    { 1096, -16, -200},
    // 42 seconds
    { 448, -328, -136},
    { 680, -176, -400},
    { 912, -104, -192},
    { 1288, 240, -392},
    { 1488, 288, -472},
    { 1480, 328, -272},
    { 1232, 328, -200},
    { 1232, 456, -136},
    { 1552, 576, -96},
    { 1536, 816, 48},
    { 1120, 1256, 152},
    { 656, 1424, 96},
    { 704, 1040, 48},
    { 744, 1248, 56},
    { 1200, 1120, 280},
    { 1752, 936, 208},
    { 1776, 736, 128},
    { 1840, 536, -32},
    { 1632, 360, -72},
    { 1480, 320, -112},
    { 1448, 264, -128},
    { 1440, 240, -176},
    { 1288, 152, -112},
    { 1304, 168, -144},
    { 960, -240, -144},
    // 43 seconds
    { 336, -200, -248},
    { 840, -144, -96},
    { 632, 80, -256},
    { 928, 208, -328},
    { 1152, 288, -264},
    { 1496, 432, -240},
    { 1776, 488, -208},
    { 2040, 768, -192},
    { 1656, 952, 8},
    { 1800, 656, -328},
    { 1272, 928, -88},
    { 824, 1160, -32},
    { 1056, 1008, -72},
    { 896, 992, -128},
    { 984, 904, -128},
    { 1104, 800, 0},
    { 1440, 672, -80},
    { 1384, 488, -72},
    { 1152, 232, -8},
    { 1344, 104, -224},
    { 1272, 192, -120},
    { 1368, 304, -48},
    { 1488, 232, -48},
    { 1288, 128, -40},
    { 1120, -32, -168},
    // 44 seconds
    { 904, -248, 32},
    { 808, -40, -88},
    { 1168, -56, -328},
    { 1272, 24, -168},
    { 1112, 304, -216},
    { 944, 192, -256},
    { 1024, 280, -208},
    { 1304, 368, -104},
    { 1664, 648, -136},
    { 1648, 976, -24},
    { 1168, 968, -200},
    { 872, 1304, -344},
    { 984, 1368, -280},
    { 1064, 944, -80},
    { 1160, 928, -104},
    { 1392, 696, -96},
    { 1424, 480, -120},
    { 1280, 408, -128},
    { 1248, 240, -88},
    { 1280, 344, -80},
    { 1456, 240, -168},
    { 1504, 208, -24},
    { 1344, 248, -56},
    { 1152, -120, -152},
    { 760, -312, -120},
    // 45 seconds
    { 680, -184, -200},
    { 816, -96, -440},
    { 1248, -56, -184},
    { 1256, 232, -184},
    { 1160, 216, -280},
    { 1144, 312, -280},
    { 1384, 408, -176},
    { 1680, 632, -232},
    { 1696, 944, -160},
    { 1328, 912, -312},
    { 1016, 1312, -392},
    { 952, 1376, -240},
    { 1056, 1008, -168},
    { 840, 792, -200},
    { 1008, 688, -120},
    { 1368, 712, -88},
    { 1544, 472, -56},
    { 1416, 232, -88},
    { 1368, 208, -136},
    { 1368, 296, -152},
    { 1416, 240, -32},
    { 1304, 256, -16},
    { 1320, 152, -112},
    { 840, -432, 32},
    { 816, -136, -160},
    // 46 seconds
    { 576, -192, -264},
    { 872, -144, -328},
    { 1160, 24, -136},
    { 1312, 288, -224},
    { 1224, 264, -328},
    { 1272, 288, -256},
    { 1520, 424, -184},
    { 1664, 680, -240},
    { 1536, 880, -240},
    { 1080, 864, -336},
    { 816, 1144, -344},
    { 768, 1352, -96},
    { 1352, 1200, 72},
    { 1312, 840, -112},
    { 1200, 752, -160},
    { 1416, 752, -72},
    { 1656, 568, 64},
    { 1624, 280, -32},
    { 1512, 176, -32},
    { 1344, 248, -40},
    { 1256, 240, 8},
    { 1400, 280, -8},
    { 1416, 200, 8},
    { 976, -248, -96},
    { 176, -296, -184},
    // 47 seconds
    { 576, -240, -184},
    { 648, 0, -272},
    { 1088, 0, -384},
    { 1480, 240, -288},
    { 1464, 376, -272},
    { 1416, 240, -232},
    { 1544, 456, -248},
    { 1648, 576, -304},
    { 1736, 664, -232},
    { 1552, 936, -464},
    { 960, 1448, -672},
    { 776, 1352, -632},
    { 1008, 1088, -472},
    { 936, 768, -192},
    { 1216, 800, -112},
    { 1592, 776, -88},
    { 1584, 512, -128},
    { 1360, 288, -136},
    { 1272, 240, -112},
    { 1320, 312, -88},
    { 1408, 232, -136},
    { 1488, 216, -144},
    { 1168, 128, -152},
    { 1008, -176, -96},
    { 480, -400, -48},
    // 48 seconds
    { 816, -72, -264},
    { 920, 80, -608},
    { 1040, -64, -232},
    { 1344, 184, -200},
    { 1256, 256, -288},
    { 1224, 360, -272},
    { 1368, 376, -240},
    { 1608, 568, -376},
    { 1696, 848, -232},
    { 1472, 872, -408},
    { 1056, 1024, -512},
    { 832, 1024, -376},
    { 1096, 976, -264},
    { 928, 736, -200},
    { 1032, 688, -176},
    { 1328, 648, -136},
    { 1232, 416, -64},
    { 1048, 232, -88},
    { 1200, 88, -152},
    { 1336, 312, -144},
    { 1528, 208, -40},
    { 1392, 248, -120},
    { 1440, 112, -192},
    { 784, -288, -40},
    { 824, -104, -128},
    // 49 seconds
    { 672, -152, -128},
    { 960, 128, -376},
    { 1208, 80, -208},
    { 1344, 336, -184},
    { 1168, 288, -288},
    { 1096, 344, -272},
    { 1320, 432, -168},
    { 1536, 664, -232},
    { 1520, 824, -224},
    { 1184, 1168, -336},
    { 880, 1104, -392},
    { 896, 1240, -288},
    { 904, 896, -24},
    { 1264, 856, -24},
    { 1544, 632, -80},
    { 1432, 448, -136},
    { 1320, 344, -96},
    { 1304, 296, -80},
    { 1376, 312, -72},
    { 1504, 224, -48},
    { 1432, 224, -40},
    { 1344, 216, -136},
    { 936, -416, -64},
    { 744, -256, -16},
    { 800, -248, -136},
    // 50 seconds
    { 1304, -104, -440},
    { 1384, -24, -200},
    { 1320, 368, -216},
    { 1088, 248, -248},
    { 1192, 352, -296},
    { 1392, 400, -264},
    { 1632, 784, -328},
    { 1448, 856, -288},
    { 1224, 784, -504},
    { 832, 1272, -328},
    { 768, 1016, -168},
    { 952, 1024, -128},
    { 1184, 760, -80},
    { 1384, 752, -32},
    { 1736, 720, -64},
    { 1608, 464, -48},
    { 1328, 264, -24},
    { 1288, 216, -112},
    { 1200, 312, -32},
    { 1368, 240, -24},
    { 1320, 160, 96},
    { 1184, 104, 16},
    { 840, -312, 72},
    { 696, 0, -120},
    { 672, -224, -8},
    // 51 seconds
    { 1096, 160, -376},
    { 1184, 80, -200},
    { 1344, 368, -200},
    { 1128, 216, -184},
    { 1160, 344, -248},
    { 1368, 376, -216},
    { 1664, 632, -288},
    { 1608, 848, -208},
    { 1312, 832, -368},
    { 984, 928, -472},
    { 768, 944, -280},
    { 1024, 1096, -256},
    { 1008, 840, -88},
    { 1152, 744, -152},
    { 1296, 696, -136},
    { 1416, 480, -96},
    { 1344, 376, -80},
    { 1304, 272, -64},
    { 1304, 288, -40},
    { 1384, 256, -80},
    { 1408, 176, 24},
    { 1272, 176, -32},
    { 1208, 184, -144},
    { 904, -200, -120},
    { 624, -160, 48},
    // 52 seconds
    { 608, 112, -512},
    { 896, -88, -408},
    { 1160, 144, -240},
    { 1040, 192, -296},
    { 960, 216, -288},
    { 1096, 320, -192},
    { 1424, 432, -272},
    { 1704, 632, -320},
    { 1472, 1256, -184},
    { 1256, 568, -552},
    { 912, 1144, -472},
    { 1024, 1376, -248},
    { 984, 808, -112},
    { 1000, 760, -192},
    { 1224, 720, -112},
    { 1392, 520, -64},
    { 1216, 304, -96},
    { 1200, 224, -136},
    { 1184, 360, -48},
    { 1312, 272, -32},
    { 1256, 240, -48},
    { 1120, 176, -64},
    { 1104, 216, -144},
    { 760, -200, -136},
    { 832, 48, -192},
    // 53 seconds
    { 776, -160, -328},
    { 1040, 32, -400},
    { 1224, 184, -368},
    { 1192, 208, -360},
    { 976, 216, -360},
    { 912, 312, -336},
    { 1144, 360, -232},
    { 1496, 592, -216},
    { 1488, 928, -64},
    { 1120, 688, -176},
    { 952, 912, -112},
    { 856, 1032, 48},
    { 1192, 912, 152},
    { 976, 800, 32},
    { 1056, 712, -56},
    { 1144, 624, -48},
    { 1144, 456, -48},
    { 1072, 392, -88},
    { 1152, 224, -80},
    { 1144, 320, -56},
    { 1248, 248, -72},
    { 1320, 192, -64},
    { 1296, 200, -88},
    { 1248, 192, -224},
    { 848, -208, -216},
    // 54 seconds
    { 832, -128, -136},
    { 696, -152, -288},
    { 1048, 72, -344},
    { 1248, 192, -224},
    { 1152, 248, -224},
    { 992, 272, -256},
    { 1072, 344, -176},
    { 1376, 448, -184},
    { 1488, 656, -208},
    { 1136, 1048, -112},
    { 984, 688, -376},
    { 752, 968, -224},
    { 1016, 976, -40},
    { 1304, 824, -80},
    { 944, 640, -112},
    { 1032, 632, -128},
    { 1344, 632, -104},
    { 1264, 328, -48},
    { 1216, 200, -104},
    { 1176, 296, -72},
    { 1176, 240, -48},
    { 1120, 232, -56},
    { 1096, 176, -40},
    { 1056, 216, -56},
    { 1016, 120, -176},
    // 55 seconds
    { 864, -80, -144},
    { 944, -72, -152},
    { 784, 88, -344},
    { 1088, 128, -344},
    { 1248, 288, -288},
    { 1136, 240, -240},
    { 1000, 336, -304},
    { 1072, 352, -160},
    { 1336, 520, -160},
    { 1400, 664, -80},
    { 1120, 912, 32},
    { 952, 736, -200},
    { 840, 1064, -48},
    { 1080, 944, 48},
    { 1152, 816, 40},
    { 1000, 664, -48},
    { 1048, 600, -80},
    { 1192, 568, -64},
    { 1160, 384, -40},
    { 1168, 248, -104},
    { 1200, 248, -88},
    { 1224, 248, -72},
    { 1208, 224, -32},
    { 1112, 168, -72},
    { 1088, 208, -104},
    // 56 seconds
    { 1016, 64, -168},
    { 1056, 8, -64},
    { 656, 0, -256},
    { 744, 104, -504},
    { 1168, 144, -272},
    { 1112, 184, -232},
    { 944, 216, -264},
    { 912, 328, -248},
    { 1136, 352, -104},
    { 1392, 512, -104},
    { 1464, 640, -80},
    { 1192, 912, 8},
    { 1240, 752, -136},
    { 1048, 896, -32},
    { 1032, 984, -120},
    { 712, 768, -96},
    { 840, 744, -176},
    { 1088, 696, -160},
    { 1248, 432, -120},
    { 1152, 352, -136},
    { 1176, 280, -136},
    { 1200, 328, -88},
    { 1280, 280, -80},
    { 1304, 232, -88},
    { 1344, 200, -104},
    // 57 seconds
    { 1184, 208, -144},
    { 1024, 96, -272},
    { 712, -176, -88},
    { 480, -112, -288},
    { 808, 0, -416},
    { 1080, 96, -248},
    { 1080, 264, -248},
    { 928, 248, -264},
    { 1008, 320, -224},
    { 1360, 408, -152},
    { 1632, 600, -248},
    { 1432, 848, -104},
    { 1160, 704, -208},
    { 1152, 768, -368},
    { 952, 872, -208},
    { 1120, 928, -224},
    { 968, 744, -248},
    { 992, 704, -232},
    { 1032, 592, -160},
    { 992, 384, -136},
    { 1024, 248, -136},
    { 1200, 216, -144},
    { 1232, 336, -88},
    { 1304, 232, -88},
    { 1224, 216, -120},
    // 58 seconds
    { 1128, 192, -80},
    { 1136, 264, -120},
    { 968, -40, -184},
    { 912, -128, -96},
    { 592, -40, -352},
    { 968, -8, -424},
    { 1368, 136, -272},
    { 1200, 224, -240},
    { 1024, 256, -328},
    { 1016, 280, -192},
    { 1184, 432, -160},
    { 1392, 568, -112},
    { 1408, 792, -40},
    { 1136, 792, -96},
    { 1040, 808, -128},
    { 952, 976, -8},
    { 984, 856, 16},
    { 928, 736, -32},
    { 1128, 728, -56},
    { 1400, 584, -88},
    { 1272, 448, -80},
    { 1256, 312, -88},
    { 1360, 184, -112},
    { 1336, 360, -32},
    { 1360, 264, -24},
    // 59 seconds
    { 1368, 160, -16},
    { 1176, 176, 0},
    { 1088, 216, -112},
    { 800, -312, -104},
    { 712, -128, 48},
    { 728, 48, -328},
    { 1032, 48, -232},
    { 1336, 304, -184},
    { 1176, 256, -160},
    { 1112, 336, -216},
    { 1200, 384, -184},
    { 1360, 504, -168},
    { 1496, 744, -168},
    { 1256, 976, -176},
    { 1024, 624, -440},
    { 888, 1016, -288},
    { 936, 1104, -80},
    { 1208, 1064, -64},
    { 1248, 776, -136},
    { 1248, 696, -128},
    { 1336, 616, -88},
    { 1224, 408, 8},
    { 1288, 232, -48},
    { 1416, 216, -64},
    { 1360, 280, -16},
    // 60 seconds
    // elapsed: 1 minutes
    { 1288, 232, 24},
    { 1208, 176, 16},
    { 1072, 176, 8},
    { 944, 272, -128},
    { 984, -304, -144},
    { 488, -64, -96},
    { 744, 64, -488},
    { 976, -56, -184},
    { 1336, 336, -248},
    { 1176, 296, -280},
    { 1160, 336, -264},
    { 1304, 392, -272},
    { 1448, 560, -272},
    { 1456, 752, -224},
    { 1184, 728, -352},
    { 848, 1008, -320},
    { 888, 1032, -168},
    { 1136, 1024, -136},
    { 1208, 856, -72},
    { 1176, 800, -80},
    { 1160, 696, -48},
    { 1344, 624, -40},
    { 1392, 376, 32},
    { 1248, 288, 32},
    { 1240, 360, -8},
    // 61 seconds
    { 1200, 312, -8},
    { 1208, 288, -16},
    { 1288, 256, -32},
    { 1216, 224, -56},
    { 904, -144, -216},
    { 720, -80, -240},
    { 584, -304, -256},
    { 864, 144, -424},
    { 1264, 128, -240},
    { 1408, 312, -208},
    { 1304, 312, -224},
    { 1200, 432, -240},
    { 1328, 432, -88},
    { 1624, 608, -88},
    { 1656, 696, -48},
    { 1288, 872, -104},
    { 920, 1176, 32},
    { 880, 1240, 48},
    { 1040, 1208, 128},
    { 1136, 904, 8},
    { 1088, 792, -32},
    { 1200, 760, 24},
    { 1584, 656, 0},
    { 1640, 288, 16},
    { 1536, 200, -40},
    // 62 seconds
    { 1472, 296, -80},
    { 1320, 248, -32},
    { 1352, 240, 8},
    { 1224, 208, -32},
    { 1120, 176, -112},
    { 904, -208, -136},
    { 496, -192, -168},
    { 792, -408, -232},
    { 824, 48, -464},
    { 1176, 96, -208},
    { 1432, 456, -304},
    { 1408, 272, -136},
    { 1392, 424, -168},
    { 1496, 512, -104},
    { 1520, 624, -48},
    { 1376, 728, -64},
    { 1136, 816, -144},
    { 768, 1000, -256},
    { 840, 1048, -192},
    { 928, 1008, -168},
    { 1056, 920, -88},
    { 1000, 728, -104},
    { 1168, 696, -96},
    { 1488, 664, -80},
    { 1520, 448, -56},
    // 63 seconds
    { 1296, 184, -88},
    { 1256, 184, -120},
    { 1208, 368, -96},
    { 1168, 200, -32},
    { 1072, 208, -96},
    { 1000, 152, -64},
    { 952, 232, -128},
    { 752, -48, -144},
    { 696, 24, -216},
    { 504, -24, -360},
    { 976, 32, -232},
    { 1352, 312, -312},
    { 1304, 256, -240},
    { 1168, 368, -280},
    { 1216, 408, -224},
    { 1464, 536, -192},
    { 1592, 696, -112},
    { 1384, 632, -56},
    { 1120, 736, -160},
    { 920, 1040, 40},
    { 960, 936, 144},
    { 1064, 920, 104},
    { 928, 752, 16},
    { 952, 720, 24},
    { 1152, 704, 8},
    // 64 seconds
    { 1464, 568, -32},
    { 1376, 408, -64},
    { 1368, 176, -112},
    { 1264, 280, -64},
    { 1272, 288, -56},
    { 1120, 192, -48},
    { 1032, 152, -40},
    { 992, 184, -64},
    { 1016, 104, -144},
    { 1016, 16, 0},
    { 704, 80, -408},
    { 912, -40, -304},
    { 1256, 280, -232},
    { 1184, 184, -224},
    { 1120, 320, -288},
    { 1080, 360, -240},
    { 1208, 424, -160},
    { 1352, 592, -168},
    { 1296, 728, -104},
    { 1056, 680, -192},
    { 800, 736, -248},
    { 832, 792, -136},
    { 1080, 944, -8},
    { 1312, 832, -96},
    { 1104, 640, -184},
    // 65 seconds
    { 1024, 640, -144},
    { 1264, 600, -176},
    { 1176, 216, -64},
    { 1072, 312, -112},
    { 1152, 208, -160},
    { 1232, 304, -128},
    { 1224, 216, -48},
    { 1152, 216, -88},
    { 1072, 200, -128},
    { 1024, 248, -224},
    { 1176, -48, -48},
    { 520, -104, -320},
    { 736, 48, -496},
    { 1240, 48, -328},
    { 1208, 184, -320},
    { 992, 232, -400},
    { 952, 304, -352},
    { 1128, 336, -256},
    { 1312, 480, -264},
    { 1344, 640, -208},
    { 1040, 768, -144},
    { 968, 520, -256},
    { 816, 848, -96},
    { 1040, 912, 88},
    { 1320, 896, 40},
    // 66 seconds
    { 1096, 664, -64},
    { 992, 680, -120},
    { 1088, 680, -48},
    { 1344, 568, -40},
    { 1320, 392, -64},
    { 1264, 136, -48},
    { 1168, 264, -96},
    { 1168, 280, -56},
    { 1144, 232, -16},
    { 1144, 184, -32},
    { 1080, 136, -72},
    { 912, 24, -208},
    { 752, -8, -160},
    { 672, -88, -248},
    { 768, 64, -304},
    { 1120, 192, -320},
    { 1256, 304, -224},
    { 1216, 216, -168},
    { 1072, 344, -216},
    { 1176, 400, -128},
    { 1344, 536, -136},
    { 1320, 616, -72},
    { 1064, 728, -80},
    { 808, 864, -128},
    { 696, 1144, -80},
    // 67 seconds
    { 896, 936, -72},
    { 1232, 1064, -72},
    { 1520, 848, -32},
    { 1264, 680, -96},
    { 1136, 616, -8},
    { 1456, 632, 0},
    { 1488, 320, 160},
    { 1344, 224, 88},
    { 1312, 320, 48},
    { 1240, 264, 88},
    { 1136, 216, 64},
    { 952, 200, 32},
    { 952, 256, -32},
    { 912, 152, -152},
    { 512, -152, -176},
    { 720, -160, -208},
    { 624, -24, -296},
    { 864, 192, -336},
    { 1272, 376, -440},
    { 1576, 320, -328},
    { 1496, 352, -368},
    { 1288, 472, -280},
    { 1272, 480, -296},
    { 1216, 656, -344},
    { 944, 776, -360},
    // 68 seconds
    { 688, 856, -496},
    { 624, 856, -560},
    { 928, 712, -440},
    { 1216, 664, -320},
    { 1288, 592, -248},
    { 1208, 544, -144},
    { 1408, 568, -64},
    { 1544, 552, -64},
    { 1360, 296, -48},
    { 1240, 312, -64},
    { 1264, 328, -16},
    { 1264, 288, -8},
    { 1248, 200, 24},
    { 1280, 184, -32},
    { 1216, 232, -96},
    { 1056, -136, -232},
    { 680, -424, 0},
    { 448, -192, -480},
    { 984, -152, -560},
    { 1120, -80, -256},
    { 1192, 288, -352},
    { 1072, 200, -392},
    { 1176, 296, -304},
    { 1432, 408, -312},
    { 1648, 648, -448},
    // 69 seconds
    { 1440, 1104, -320},
    { 944, 1480, -392},
    { 1096, 2008, -496},
    { 576, -16, -432},
    { 1544, 1816, 112},
    { 1528, 1264, 0},
    { 1568, 1712, 48},
    { 1352, -264, -80},
    { 1232, -240, -128},
    { 1152, 56, -72},
    { 1488, 312, -160},
    { 1504, 248, -48},
    { 1560, 240, 24},
    { 1440, 216, -8},
    { 1328, 216, -96},
    { 1288, -72, -168},
    { 632, -568, 168},
    { 328, -256, -472},
    { 768, -288, -536},
    { 1064, -176, -136},
    { 1168, 80, -216},
    { 984, 616, -952},
    { 832, 512, -1208},
    { 640, 1568, -1600},
    { 368, 912, -1792},
    // 70 seconds
    { 128, 952, -1784},
    { 112, 712, -1360},
    { 216, 432, -1120},
    { 24, 336, -944},
    { 96, 440, -1112},
    { -8, 216, -912},
    { -40, 344, -912},
    { 8, 264, -1000},
    { 32, 160, -800},
    { -16, 80, -664},
    { -40, 16, -696},
    { -72, -32, -728},
    { -48, -120, -728},
    { 0, -112, -872},
    { 112, -224, -1048},
    { 120, -368, -984},
    { 48, -368, -1184},
    { 48, -232, -1216},
    { 56, -272, -1104},
    { 24, -208, -1096},
    { 24, -224, -1040},
    { -80, -280, -896},
    { -168, -328, -784},
    { -248, -360, -792},
    { -280, -400, -888},
    // 71 seconds
    { -240, -464, -928},
    { -232, -432, -1008},
    { -200, -376, -1200},
    { -192, -528, -1176},
    { -328, -464, -1192},
    { -184, -352, -1336},
    { -232, -328, -1032},
    { -280, -48, -1136},
    { -80, -184, -1104},
    { -96, -240, -832},
    { -136, -208, -792},
    { -104, -288, -792},
    { -64, -296, -744},
    { 0, -336, -696},
    { 48, -376, -656},
    { 120, -384, -592},
    { 232, -272, -568},
    { 512, -64, -552},
    { 720, 184, -616},
    { 1088, 88, -432},
    { 1520, 248, -392},
    { 1928, 368, -488},
    { 1832, 432, -416},
    { 1688, 512, -392},
    { 1696, 648, -560},
    // 72 seconds
    { 1592, 608, -472},
    { 1392, 480, -520},
    { 1000, 416, -720},
    { 864, 704, -688},
    { 736, 1296, -640},
    { 1008, 1112, -648},
    { 1024, 616, -552},
    { 1144, 696, -504},
    { 1536, 656, -456},
    { 1744, 352, -280},
    { 1648, 328, -240},
    { 1792, 448, -336},
    { 1800, 712, -336},
    { 1680, 888, -408},
    { 1464, 720, -480},
    { 1128, 576, -560},
    { 656, 144, -432},
    { 464, -280, -336},
    { 200, -520, -616},
    { 136, -544, -440},
    { 184, -488, -632},
    { 168, -624, -568},
    { 64, -568, -544},
    { -120, -624, -592},
    { -200, -584, -672},
    // 73 seconds
    { -256, -584, -696},
    { -280, -624, -776},
    { -312, -664, -864},
    { -304, -632, -952},
    { -344, -672, -1048},
    { -344, -728, -1120},
    { -400, -584, -1120},
    { -400, -600, -920},
    { -384, -320, -960},
    { -256, -344, -936},
    { -224, -360, -744},
    { -176, -360, -688},
    { -216, -408, -664},
    { -152, -400, -584},
    { -64, -408, -552},
    { 64, -376, -568},
    { 152, -400, -600},
    { 384, -304, -448},
    { 728, -48, -416},
    { 1040, 136, -344},
    { 1736, 200, -248},
    { 2248, 552, -328},
    { 2032, 456, -240},
    { 1800, 488, -424},
    { 1664, 680, -224},
    // 74 seconds
    { 1760, 680, -208},
    { 1544, 664, -248},
    { 1352, 696, -216},
    { 1136, 960, -272},
    { 832, 1112, -168},
    { 888, 1320, -336},
    { 864, 912, -232},
    { 960, 888, -312},
    { 1152, 840, -168},
    { 1624, 608, -208},
    { 1728, 408, -144},
    { 1728, 328, -152},
    { 1672, 232, -176},
    { 1488, 248, -72},
    { 1472, 232, -136},
    { 1408, 184, -96},
    { 1224, 216, -104},
    { 952, -104, -136},
    { 456, -328, -32},
    { 712, -248, -280},
    { 848, -48, -440},
    { 1024, 16, -256},
    { 1320, 256, -216},
    { 1200, 256, -280},
    { 1256, 280, -240},
    // 75 seconds
    { 1504, 384, -168},
    { 1704, 632, -216},
    { 1768, 744, -152},
    { 1440, 744, -264},
    { 1024, 992, -232},
    { 872, 1296, -208},
    { 1048, 1264, -192},
    { 944, 816, -200},
    { 920, 816, -232},
    { 1080, 752, -88},
    { 1440, 720, -72},
    { 1568, 432, -32},
    { 1456, 328, -88},
    { 1440, 232, -104},
    { 1328, 344, -64},
    { 1304, 264, -8},
    { 1216, 232, -64},
    { 1176, 104, -120},
    { 768, -352, -16},
    { 1072, -8, -168},
    { 624, -216, -240},
    { 920, 168, -432},
    { 1200, 160, -232},
    { 1200, 248, -216},
    { 1112, 272, -256},
    // 76 seconds
    { 1136, 344, -192},
    { 1408, 456, -144},
    { 1552, 680, -152},
    { 1432, 768, -152},
    { 1304, 632, -464},
    { 1032, 1048, -232},
    { 936, 1352, -144},
    { 1128, 1128, -264},
    { 936, 784, -216},
    { 976, 792, -160},
    { 1232, 784, -88},
    { 1480, 488, -40},
    { 1392, 344, -80},
    { 1368, 256, -152},
    { 1344, 400, -136},
    { 1432, 296, -56},
    { 1272, 232, -88},
    { 1192, 144, -96},
    { 856, -352, 48},
    { 744, 32, -96},
    { 800, -184, -120},
    { 864, 80, -328},
    { 1176, 96, -272},
    { 1320, 384, -240},
    { 1248, 176, -248},
    // 77 seconds
    { 1184, 336, -328},
    { 1320, 360, -224},
    { 1520, 544, -216},
    { 1544, 704, -200},
    { 1296, 816, -344},
    { 920, 1064, -392},
    { 720, 1040, -376},
    { 960, 1072, -352},
    { 1120, 904, -144},
    { 1360, 808, -176},
    { 1424, 680, -176},
    { 1456, 528, -152},
    { 1304, 384, -64},
    { 1304, 272, -80},
    { 1352, 304, -128},
    { 1352, 288, -88},
    { 1368, 272, -64},
    { 1144, 192, -64},
    { 1160, 168, -112},
    { 712, -448, -32},
    { 792, -96, 72},
    { 880, 0, -400},
    { 1184, 0, -264},
    { 1360, 280, -200},
    { 1112, 264, -240},
    // 78 seconds
    { 1064, 288, -336},
    { 1168, 304, -192},
    { 1488, 472, -256},
    { 1728, 688, -264},
    { 1448, 912, -232},
    { 1192, 776, -440},
    { 952, 1168, -272},
    { 952, 1336, -272},
    { 968, 976, -200},
    { 1072, 872, -216},
    { 1240, 768, -104},
    { 1632, 680, -96},
    { 1528, 392, -40},
    { 1392, 288, -72},
    { 1384, 272, -88},
    { 1352, 280, -40},
    { 1408, 248, -40},
    { 1248, 176, -8},
    { 1104, 176, -112},
    { 744, -344, -88},
    { 904, -40, -88},
    { 528, -160, -264},
    { 1016, 104, -352},
    { 1192, 208, -232},
    { 1240, 336, -224},
    // 79 seconds
    { 1144, 320, -216},
    { 1216, 408, -184},
    { 1432, 576, -80},
    { 1632, 832, -72},
    { 1584, 616, -56},
    { 1256, 832, -168},
    { 1088, 1144, -72},
    { 912, 1232, -32},
    { 1024, 1392, -152},
    { 1032, 856, -136},
    { 1112, 888, -168},
    { 1448, 808, -88},
    { 1592, 536, 8},
    { 1376, 376, -24},
    { 1416, 232, -88},
    { 1472, 296, -80},
    { 1496, 296, 8},
    { 1528, 272, -8},
    { 1312, 184, -56},
    { 952, -392, -88},
    { 448, -232, -48},
    { 608, -360, -48},
    { 1000, 112, -368},
    { 1272, 88, -168},
    { 1424, 448, -168},
    // 80 seconds
    { 1320, 240, -144},
    { 1264, 416, -232},
    { 1400, 384, -160},
    { 1696, 656, -176},
    { 1744, 872, -152},
    { 1304, 1112, -320},
    { 760, 1312, -448},
    { 768, 1096, -272},
    { 1040, 1320, -200},
    { 1304, 984, -64},
    { 1472, 816, -104},
    { 1592, 704, -96},
    { 1568, 560, -64},
    { 1456, 352, -16},
    { 1424, 216, -56},
    { 1408, 296, -24},
    { 1424, 296, 8},
    { 1384, 208, 16},
    { 1144, 160, 32},
    { 1040, 184, -80},
    { 696, -424, -96},
    { 592, -88, -120},
    { 552, -144, -336},
    { 912, -40, -224},
    { 1208, 296, -216},
    // 81 seconds
    { 1248, 296, -240},
    { 1296, 344, -240},
    { 1456, 448, -232},
    { 1664, 592, -208},
    { 1720, 920, -208},
    { 1456, 936, -368},
    { 856, 1264, -416},
    { 824, 1320, -256},
    { 856, 1232, -256},
    { 1136, 992, -112},
    { 1304, 808, -120},
    { 1504, 752, -80},
    { 1632, 664, -40},
    { 1392, 392, -8},
    { 1024, 80, -32},
    { 952, 152, -96},
    { 1104, 248, -112},
    { 1264, 320, -80},
    { 1264, 200, -48},
    { 1104, 120, -64},
    { 1040, 200, -256},
    { 976, -224, -208},
    { 416, -48, -144},
    { 936, 96, -664},
    { 1256, -104, -216},
    // 82 seconds
    { 1352, 224, -344},
    { 1080, 184, -320},
    { 1008, 312, -224},
    { 1168, 304, -144},
    { 1520, 448, -200},
    { 1696, 560, -80},
    { 1776, 864, -168},
    { 1512, 1008, -96},
    { 1248, 1008, -112},
    { 976, 1352, -144},
    { 704, 1104, -72},
    { 792, 920, -136},
    { 1008, 792, -88},
    { 1368, 584, -120},
    { 1416, 392, -104},
    { 1480, 392, -88},
    { 1632, 240, -120},
    { 1664, 288, -80},
    { 1472, 216, 32},
    { 1456, 272, -24},
    { 1200, 256, -64},
    { 1008, 72, -200},
    { 664, -416, 112},
    { 672, 8, -296},
    { 1096, -128, -232},
    // 83 seconds
    { 1216, 112, -152},
    { 1152, 256, -232},
    { 1048, 280, -248},
    { 1256, 344, -128},
    { 1664, 512, -136},
    { 2056, 824, -168},
    { 1488, 1312, 64},
    { 1288, 696, -440},
    { 768, 1416, -144},
    { 832, 1416, -16},
    { 1048, 1096, 8},
    { 1304, 872, -24},
    { 1424, 728, -72},
    { 1632, 600, -120},
    { 1456, 392, -64},
    { 1416, 320, -56},
    { 1520, 320, -48},
    { 1496, 288, -16},
    { 1472, 224, -72},
    { 1360, 192, -32},
    { 1032, -216, 8},
    { 440, -376, -56},
    { 1104, -352, -112},
    { 872, -120, -232},
    { 1360, 40, -320},
    // 84 seconds
    { 1432, 240, -144},
    { 1424, 288, -232},
    { 1320, 296, -216},
    { 1440, 400, -104},
    { 1712, 592, -152},
    { 1816, 752, -64},
    { 1672, 952, -136},
    { 1216, 1304, -152},
    { 768, 1672, -296},
    { 792, 1376, -184},
    { 952, 1112, -104},
    { 1088, 880, -112},
    { 1504, 792, -32},
    { 1952, 760, -24},
    { 1888, 480, -16},
    { 1672, 296, -8},
    { 1640, 208, -40},
    { 1472, 288, 0},
    { 1384, 192, 0},
    { 1272, 216, -24},
    { 1104, 144, -72},
    { 752, -632, 40},
    { 712, -176, -80},
    { 600, -216, -280},
    { 1144, 24, -448},
    // 85 seconds
    { 1384, 128, -112},
    { 1440, 368, -216},
    { 1352, 304, -224},
    { 1392, 416, -176},
    { 1680, 544, -160},
    { 1816, 800, -136},
    { 1744, 768, -168},
    { 1376, 880, -288},
    { 920, 1232, -336},
    { 816, 1208, -272},
    { 1024, 1176, -240},
    { 1112, 784, -240},
    { 1248, 760, -224},
    { 1552, 720, -168},
    { 1568, 552, -64},
    { 1368, 320, 24},
    { 1528, 48, -168},
    { 1400, 304, -24},
    { 1456, 272, -8},
    { 1400, 224, 16},
    { 1208, 152, -24},
    { 1136, 48, -112},
    { 640, -184, -248},
    { 888, -176, 0},
    { 704, 24, -352},
    // 86 seconds
    { 968, 48, -296},
    { 1136, 224, -272},
    { 1136, 256, -272},
    { 1080, 328, -272},
    { 1248, 352, -176},
    { 1640, 528, -160},
    { 1792, 840, -120},
    { 1552, 728, -112},
    { 1296, 848, -264},
    { 1008, 1176, -160},
    { 1096, 1256, -40},
    { 952, 952, -72},
    { 1048, 840, -152},
    { 1232, 728, -160},
    { 1280, 584, -136},
    { 1232, 488, -136},
    { 1376, 64, -96},
    { 1240, 240, -88},
    { 1432, 176, -136},
    { 1576, 192, -72},
    { 1336, 264, -80},
    { 1288, 56, -80},
    { 704, -368, -88},
    { 936, -136, -88},
    { 736, -80, -400},
    // 87 seconds
    { 1072, -88, -280},
    { 1248, 40, -104},
    { 1184, 296, -224},
    { 1080, 296, -352},
    { 1128, 304, -128},
    { 1376, 424, -224},
    { 1648, 688, -128},
    { 1544, 856, -40},
    { 1328, 680, -216},
    { 1216, 1016, -168},
    { 1080, 1184, -104},
    { 960, 1072, -136},
    { 896, 800, -288},
    { 1136, 712, -272},
    { 1536, 616, -208},
    { 1448, 432, -112},
    { 1288, 184, -8},
    { 1248, 184, -224},
    { 1376, 232, -128},
    { 1416, 176, 88},
    { 1312, 184, 48},
    { 1208, 200, -16},
    { 1120, 176, -88},
    { 872, -384, 104},
    { 616, 112, -56},
    // 88 seconds
    { 960, -32, -504},
    { 1168, -8, -248},
    { 1192, 128, -168},
    { 1064, 208, -296},
    { 1040, 328, -376},
    { 1184, 272, -216},
    { 1648, 416, -208},
    { 1912, 768, -232},
    { 1528, 872, -216},
    { 1208, 584, -448},
    { 976, 944, -272},
    { 864, 1576, -104},
    { 1040, 1200, -40},
    { 1200, 752, -160},
    { 1280, 744, -128},
    { 1488, 608, -80},
    { 1432, 464, -8},
    { 1504, 312, -32},
    { 1656, 352, -16},
    { 1640, 304, 0},
    { 1512, 144, 32},
    { 1360, 216, -40},
    { 1184, 152, -120},
    { 720, -544, -80},
    { 920, -240, -16},
    // 89 seconds
    { 696, 64, -320},
    { 1120, -40, -400},
    { 1184, 80, -88},
    { 1176, 320, -208},
    { 1184, 320, -272},
    { 1368, 376, -168},
    { 1800, 592, -200},
    { 1984, 1032, -96},
    { 1688, 704, -304},
    { 1128, 1128, -304},
    { 752, 1552, -176},
    { 1032, 1376, -104},
    { 1112, 888, -136},
    { 1336, 840, -144},
    { 1560, 768, -80},
    { 1720, 624, 8},
    { 1536, 392, 0},
    { 1568, 152, -120},
    { 1496, 288, -56},
    { 1560, 240, -48},
    { 1464, 184, 80},
    { 1336, 224, 40},
    { 1136, 184, -32},
    { 752, -728, 40},
    { 480, -184, 72},
    // 90 seconds
    { 832, 8, -536},
    { 1120, -304, -232},
    { 1536, 176, -184},
    { 1320, 344, -288},
    { 1256, 256, -192},
    { 1520, 344, -224},
    { 1840, 488, -272},
    { 1784, 752, -336},
    { 1400, 832, -464},
    { 976, 1240, -656},
    { 920, 1336, -576},
    { 1056, 1096, -560},
    { 1000, 816, -400},
    { 1184, 736, -296},
    { 1432, 680, -192},
    { 1568, 512, -136},
    { 1408, 280, -56},
    { 1408, 184, -120},
    { 1408, 256, -88},
    { 1360, 232, 8},
    { 1240, 232, 16},
    { 1168, 184, 16},
    { 1096, 144, -16},
    { 768, -320, -64},
    { 640, -176, 8},
    // 91 seconds
    { 832, -64, -304},
    { 1136, -88, -312},
    { 1280, 168, -136},
    { 1232, 328, -208},
    { 1224, 288, -296},
    { 1344, 368, -192},
    { 1712, 568, -264},
    { 1848, 936, -216},
    { 1320, 936, -336},
    { 992, 1112, -464},
    { 856, 1296, -184},
    { 840, 1248, -224},
    { 752, 984, -72},
    { 1264, 872, -56},
    { 1824, 768, -8},
    { 1576, 472, -56},
    { 1392, 264, -120},
    { 1384, 328, -80},
    { 1536, 400, -16},
    { 1608, 272, -120},
    { 1360, 120, -24},
    { 1176, 168, -104},
    { 936, 40, -144},
    { 344, -440, -112},
    { 704, -232, -72},
    // 92 seconds
    { 984, 32, -288},
    { 1272, 96, -408},
    { 1496, 304, -336},
    { 1320, 344, -176},
    { 1288, 320, -280},
    { 1392, 512, -176},
    { 1584, 592, -136},
    { 1592, 816, -104},
    { 1408, 792, -200},
    { 944, 928, -248},
    { 752, 1176, -144},
    { 960, 1024, -72},
    { 984, 944, -64},
    { 1136, 800, -48},
    { 1384, 752, -24},
    { 1672, 648, -40},
    { 1584, 392, -56},
    { 1408, 256, -96},
    { 1360, 264, -88},
    { 1360, 280, -24},
    { 1264, 256, 8},
    { 1216, 192, 32},
    { 1088, 128, 8},
    { 960, 72, -56},
    { 632, -320, -24},
    // 93 seconds
    { 688, -72, -56},
    { 960, 128, -440},
    { 1328, 24, -176},
    { 1488, 416, -208},
    { 1280, 296, -200},
    { 1216, 352, -256},
    { 1360, 440, -168},
    { 1632, 712, -232},
    { 1672, 832, -88},
    { 1328, 880, -176},
    { 920, 944, -328},
    { 816, 1200, -152},
    { 1016, 1112, -16},
    { 1016, 864, -88},
    { 1208, 736, -88},
    { 1432, 736, -40},
    { 1560, 576, -24},
    { 1400, 312, -40},
    { 1400, 264, -160},
    { 1488, 304, -80},
    { 1440, 288, -48},
    { 1368, 192, 0},
    { 1240, 160, -8},
    { 1080, 160, -8},
    { 728, -440, -24},
    // 94 seconds
    { 776, -168, 8},
    { 888, 56, -336},
    { 1160, 64, -136},
    { 1312, 392, -208},
    { 1192, 248, -160},
    { 1128, 312, -216},
    { 1272, 376, -104},
    { 1512, 592, -128},
    { 1608, 872, -128},
    { 1328, 968, -160},
    { 1016, 1008, -392},
    { 752, 1144, -168},
    { 920, 1136, -32},
    { 1120, 848, 24},
    { 1248, 792, -64},
    { 1304, 672, -64},
    { 1376, 512, -56},
    { 1280, 336, -64},
    { 1248, 264, -80},
    { 1360, 320, -80},
    { 1384, 264, -40},
    { 1336, 216, -40},
    { 1224, 200, -40},
    { 1168, 144, -176},
    { 624, -424, -152},
    // 95 seconds
    { 776, -256, -48},
    { 880, -88, -296},
    { 1176, -8, -320},
    { 1352, 216, -240},
    { 1240, 304, -232},
    { 1136, 304, -264},
    { 1272, 416, -144},
    { 1520, 616, -216},
    { 1552, 840, -40},
    { 1264, 736, -128},
    { 992, 904, -152},
    { 792, 1160, 0},
    { 968, 1120, 64},
    { 1136, 992, 16},
    { 1224, 736, -24},
    { 1256, 752, -64},
    { 1608, 696, -56},
    { 1560, 472, 16},
    { 1432, 248, -40},
    { 1336, 184, -104},
    { 1224, 264, -64},
    { 1152, 232, 0},
    { 1200, 208, -32},
    { 1160, 136, -8},
    { 776, -264, -40},
    // 96 seconds
    { 568, -32, -136},
    { 656, -216, -160},
    { 1088, 128, -312},
    { 1504, 144, -200},
    { 1576, 376, -200},
    { 1360, 280, -176},
    { 1264, 384, -200},
    { 1312, 496, -88},
    { 1456, 640, -112},
    { 1424, 688, -24},
    { 1360, 840, -96},
    { 1024, 1024, -120},
    { 832, 1208, -72},
    { 1032, 1200, 16},
    { 1160, 856, 16},
    { 1288, 824, -64},
    { 1480, 768, -32},
    { 1792, 696, -56},
    { 1632, 416, 32},
    { 1464, 232, -32},
    { 1424, 216, -104},
    { 1344, 224, 0},
    { 1272, 264, 24},
    { 1224, 152, 56},
    { 1112, 112, 24},
    // 97 seconds
    { 776, -248, 0},
    { 576, -88, -144},
    { 776, -104, -224},
    { 1096, 40, -376},
    { 1408, 104, -184},
    { 1456, 336, -224},
    { 1344, 296, -208},
    { 1344, 360, -144},
    { 1488, 520, -136},
    { 1656, 656, -88},
    { 1696, 768, 8},
    { 1464, 896, -80},
    { 928, 1232, 32},
    { 752, 1296, 8},
    { 936, 1336, 128},
    { 1032, 960, 56},
    { 1368, 888, 16},
    { 1864, 816, -24},
    { 1840, 552, 8},
    { 1696, 352, -24},
    { 1632, 288, -56},
    { 1616, 296, -8},
    { 1512, 256, 32},
    { 1480, 216, 24},
    { 1296, 104, 48},
    // 98 seconds
    { 1056, 160, -88},
    { 752, -608, -72},
    { 464, -328, 88},
    { 1064, 56, -584},
    { 1224, -184, -40},
    { 1472, 416, -144},
    { 1248, 312, -200},
    { 1224, 328, -160},
    { 1424, 416, -104},
    { 1656, 616, -72},
    { 1848, 872, 8},
    { 1680, 744, -104},
    { 1232, 968, -48},
    { 904, 1384, 128},
    { 1032, 1288, 216},
    { 1208, 976, 152},
    { 1288, 888, 128},
    { 1496, 824, 40},
    { 1552, 616, -24},
    { 1440, 416, -32},
    { 1480, 280, -40},
    { 1528, 312, -8},
    { 1448, 296, 8},
    { 1552, 280, -8},
    { 1440, 144, 88},
    // 99 seconds
    { 1016, 136, 0},
    { 856, -184, -104},
    { 608, -88, -56},
    { 600, -152, -224},
    { 1152, 16, -432},
    { 1264, 56, -152},
    { 1456, 384, -216},
    { 1360, 320, -232},
    { 1360, 392, -152},
    { 1544, 560, -128},
    { 1568, 752, -128},
    { 1584, 624, -232},
    { 1200, 1000, -288},
    { 816, 1272, -344},
    { 856, 1080, -224},
    { 976, 1272, -152},
    { 1088, 920, -72},
    { 1344, 880, -40},
    { 1808, 816, -24},
    { 1912, 584, 0},
    { 1632, 312, -16},
    { 1480, 272, -64},
    { 1376, 272, -8},
    { 1296, 256, -8},
    { 1384, 216, 56},
    // 100 seconds
    { 1312, 144, 16},
    { 1136, 112, -88},
    { 736, -592, 16},
    { 504, -192, -56},
    { 1000, 56, -560},
    { 1112, -184, -184},
    { 1400, 176, -120},
    { 1336, 368, -224},
    { 1392, 344, -232},
    { 1648, 424, -128},
    { 1904, 784, -184},
    { 1672, 832, -136},
    { 1488, 768, -368},
    { 976, 1304, -336},
    { 896, 1344, -240},
    { 968, 1264, -256},
    { 936, 776, -192},
    { 1144, 768, -208},
    { 1472, 784, -136},
    { 1728, 608, -88},
    { 1688, 216, 0},
    { 1496, 288, -80},
    { 1456, 248, -144},
    { 1328, 224, 8},
    { 1256, 280, 88},
    // 101 seconds
    { 1256, 184, 96},
    { 1160, 192, 80},
    { 1120, -272, -72},
    { 488, -352, 144},
    { 904, 112, -360},
    { 1104, -176, -360},
    { 1296, 40, -32},
    { 1240, 424, -200},
    { 1144, 240, -280},
    { 1352, 312, -208},
    { 1680, 488, -208},
    { 1832, 896, -304},
    { 1480, 880, -312},
    { 1152, 936, -488},
    { 936, 1160, -352},
    { 984, 960, -336},
    { 920, 976, -232},
    { 1112, 864, -184},
    { 1400, 784, -136},
    { 1560, 544, -184},
    { 1320, 352, -152},
    { 1240, 328, -72},
    { 1400, 344, -56},
    { 1440, 296, -88},
    { 1568, 192, 16},
    // 102 seconds
    { 1368, 136, 24},
    { 1248, 152, -120},
    { 696, -648, 0},
    { 912, -136, -160},
    { 872, -168, -272},
    { 1320, -128, -312},
    { 1312, 128, -104},
    { 1240, 352, -168},
    { 1144, 248, -240},
    { 1264, 328, -136},
    { 1536, 504, -136},
    { 1760, 760, -168},
    { 1568, 896, -8},
    { 1184, 952, -224},
    { 992, 1296, -104},
    { 1000, 1408, -24},
    { 928, 984, 0},
    { 1256, 880, -144},
    { 1496, 768, -120},
    { 1680, 680, -56},
    { 1576, 496, -16},
    { 1448, 256, -40},
    { 1464, 240, -80},
    { 1560, 312, -104},
    { 1656, 192, 80},
    // 103 seconds
    { 1456, 176, 32},
    { 1280, 64, 0},
    { 1040, -600, 96},
    { 552, -216, -88},
    { 856, -200, -624},
    { 1096, -288, 24},
    { 1216, 216, 8},
    { 1144, 264, -216},
    { 1184, 304, -272},
    { 1440, 400, -176},
    { 1688, 600, -200},
    { 1608, 824, -160},
    { 1496, 560, -264},
    { 1208, 904, -272},
    { 1096, 1288, -176},
    { 1072, 1296, -168},
    { 880, 1064, -192},
    { 728, 744, -208},
    { 912, 704, -152},
    { 1456, 760, -72},
    { 1816, 504, -24},
    { 1616, 248, -64},
    { 1520, 224, -112},
    { 1408, 264, -40},
    { 1272, 240, -8},
    // 104 seconds
    { 1312, 208, 0},
    { 1168, 192, -24},
    { 1152, -104, -176},
    { 576, -328, -120},
    { 728, -336, -96},
    { 680, -64, -216},
    { 1064, 112, -280},
    { 1272, 240, -184},
    { 1392, 328, -136},
    { 1376, 304, -152},
    { 1504, 480, -128},
    { 1672, 640, -128},
    { 1616, 704, -64},
    { 1504, 880, -160},
    { 1056, 1320, -88},
    { 904, 1448, -104},
    { 1000, 976, -8},
    { 936, 1016, -160},
    { 1248, 864, -80},
    { 1528, 768, -56},
    { 1440, 472, -48},
    { 1400, 232, 48},
    { 1400, 296, -104},
    { 1504, 232, 0},
    { 1576, 272, -16},
    // 105 seconds
    { 1408, 104, 112},
    { 1288, 216, 0},
    { 1176, -32, -128},
    { 600, -128, -72},
    { 776, -392, -176},
    { 920, -224, -288},
    { 1160, 8, -296},
    { 1240, 200, -184},
    { 1248, 264, -192},
    { 1328, 336, -192},
    { 1592, 448, -136},
    { 1888, 680, -112},
    { 1608, 1000, 32},
    { 1536, 760, -312},
    { 968, 1288, 16},
    { 632, 1360, -8},
    { 880, 1400, 48},
    { 1224, 968, -24},
    { 1456, 816, -112},
    { 1656, 720, -104},
    { 1704, 480, 32},
    { 1960, 256, 224},
    { 1936, 136, 256},
    { 1672, 184, 296},
    { 1360, 208, 384},
    // 106 seconds
    { 1072, 352, 376},
    { 880, 344, 384},
    { 648, 336, 440},
    { 448, 392, 504},
    { 256, 584, 512},
    { 48, 552, 448},
    { -112, 920, 880},
    { -56, 1096, 416},
    { -72, 1000, 296},
    { -176, 808, 608},
    { -224, 776, 456},
    { -320, 704, 600},
    { -360, 760, 456},
    { -344, 584, 632},
    { -400, 728, 696},
    { -424, 728, 776},
    { -392, 592, 752},
    { -280, 648, 648},
    { -232, 640, 528},
    { -200, 640, 440},
    { -208, 792, 536},
    { -184, 800, 288},
    { -384, 760, 368},
    { -416, 632, 424},
    { -424, 592, 656},
    // 107 seconds
    { -368, 624, 584},
    { -320, 624, 712},
    { -288, 664, 696},
    { -280, 576, 696},
    { -352, 680, 576},
    { -424, 712, 576},
    { -424, 712, 408},
    { -424, 752, 376},
    { -432, 848, 368},
    { -360, 776, 352},
    { -392, 840, 368},
    { -424, 824, 272},
    { -416, 728, 152},
    { -400, 736, 152},
    { -424, 800, 240},
    { -464, 792, 216},
    { -504, 792, 216},
    { -504, 856, 168},
    { -472, 824, 280},
    { -432, 832, 336},
    { -472, 800, 456},
    { -448, 712, 552},
    { -384, 752, 360},
    { -400, 720, 456},
    { -392, 672, 472},
    // 108 seconds
    { -352, 648, 544},
    { -320, 712, 648},
    { -264, 744, 576},
    { -320, 752, 552},
    { -344, 744, 520},
    { -392, 848, 504},
    { -400, 752, 536},
    { -488, 800, 560},
    { -560, 880, 464},
    { -696, 824, 352},
    { -904, 824, 272},
    { -752, 800, 88},
    { -752, 896, -168},
    { -840, 944, -384},
    { -672, 768, -448},
    { -128, 648, -688},
    { 272, 328, -664},
    { 576, 416, -904},
    { 360, 120, -832},
    { 304, 248, -920},
    { 72, 256, -744},
    { 88, 576, -856},
    { -8, -200, -824},
    { 0, 120, -976},
    { -8, 128, -960},
    // 109 seconds
    { -56, -48, -936},
    { -24, 48, -1000},
    { -232, 88, -952},
    { -232, 256, -880},
    { 80, 304, -920},
    { 72, 464, -1096},
    { -168, 736, -792},
    { -168, 808, -160},
    { -136, 696, 352},
    { -120, 864, 624},
    { -88, 832, 640},
    { -136, 968, 880},
    { -32, 1040, 832},
    { -128, 1008, 288},
    { -88, 1048, -208},
    { 104, 40, -488},
    { 216, -192, -1136},
    { 216, -104, -1160},
    { 80, -424, -1024},
    { 40, -616, -896},
    { 0, -896, -696},
    { -168, -904, -624},
    { -328, -928, -560},
    { -336, -952, -504},
    { -224, -944, -568},
    // 110 seconds
    { -104, -816, -648},
    { -152, -872, -336},
    { -72, -856, -560},
    { -240, -40, -592},
    { 112, -816, -568},
    { -104, -688, -632},
    { -216, -728, -672},
    { -160, -568, -736},
    { -144, -752, -752},
    { -24, -728, -712},
    { 40, -608, -776},
    { -16, -480, -768},
    { 656, -2008, -608},
    { 64, -864, -800},
    { 0, -744, -888},
    { 0, -728, -984},
    { 8, -720, -808},
    { 560, -280, -656},
    { -144, -592, -720},
    { -336, -832, -776},
    { -416, -704, -800},
    { -376, -696, -768},
    { -216, -1120, -520},
    { -464, -608, -616},
    { -448, -536, -688},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:22:01 local
AccelRawData *activity_sample_walk_200_pbl_25665_14(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25665_14
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -128, -32, -1128},
    { -136, -88, -1064},
    { -240, -120, -1008},
    { -128, -112, -1024},
    { -176, -240, -944},
    { -216, -192, -1000},
    { -48, -264, -992},
    { -200, -240, -1000},
    { -104, -200, -984},
    { -144, -168, -1016},
    { -96, -72, -1040},
    { -144, -264, -968},
    { -168, -200, -1016},
    { -16, -224, -1040},
    { -176, -240, -992},
    { 16, -184, -1096},
    { -88, -248, -1048},
    { -232, -328, -992},
    { -176, -456, -968},
    { -152, -368, -968},
    { -152, -344, -984},
    { -248, -408, -968},
    { -264, -328, -1032},
    { -160, -272, -1064},
    { 256, -440, -856},
    // 1 seconds
    { 432, -96, -1096},
    { 0, -352, -984},
    { -48, -328, -968},
    { -56, -344, -968},
    { -72, -344, -992},
    { -80, -336, -992},
    { -80, -368, -992},
    { -80, -360, -1008},
    { -56, -368, -1008},
    { -72, -360, -984},
    { -88, -360, -968},
    { -96, -376, -928},
    { -96, -368, -920},
    { 40, -384, -888},
    { 248, -368, -776},
    { 320, -192, -640},
    { 288, -152, -624},
    { 240, -80, -664},
    { 224, 32, -712},
    { 264, 304, -936},
    { 352, 528, -968},
    { 400, 736, -912},
    { 352, 768, -1000},
    { 352, 840, -1104},
    { 304, 872, -1072},
    // 2 seconds
    { 176, 864, -1048},
    { 0, 1008, -1088},
    { -40, 1192, -1208},
    { 224, 1040, -1192},
    { 288, 984, -1200},
    { 472, 1072, -1176},
    { 496, 896, -888},
    { 496, 872, -792},
    { 520, 800, -688},
    { 360, 680, -560},
    { 296, 440, -456},
    { 256, 384, -440},
    { 208, 304, -368},
    { 152, 96, -264},
    { 168, -8, -248},
    { 280, 40, -312},
    { 576, 32, -384},
    { 960, -16, -392},
    { 1608, 152, -496},
    { 2016, 312, -464},
    { 2216, 616, -616},
    { 1992, 568, -280},
    { 1552, 408, -312},
    { 1440, 608, -216},
    { 1312, 552, -16},
    // 3 seconds
    { 1200, 408, 64},
    { 1024, 576, 80},
    { 872, 712, 64},
    { 728, 808, 72},
    { 648, 792, 8},
    { 912, 936, -40},
    { 984, 816, -16},
    { 1112, 768, -64},
    { 1424, 720, -88},
    { 1816, 584, -88},
    { 1552, 416, -104},
    { 1608, 384, -104},
    { 1784, 400, -88},
    { 1656, 392, -128},
    { 1472, 272, -64},
    { 1424, 200, -88},
    { 1128, 168, -192},
    { 1264, -240, 48},
    { 304, -688, 328},
    { 824, -232, -408},
    { 1296, -96, -136},
    { 1344, 296, -328},
    { 1176, 208, -304},
    { 1176, 408, -288},
    { 1400, 392, -248},
    // 4 seconds
    { 1656, 568, -224},
    { 1760, 736, -232},
    { 1528, 872, -232},
    { 1128, 1088, -280},
    { 840, 1168, -208},
    { 976, 1344, -192},
    { 1104, 1056, -168},
    { 1104, 872, -184},
    { 1320, 696, -184},
    { 1368, 496, -120},
    { 1280, 312, -144},
    { 1416, 336, -128},
    { 1592, 432, -40},
    { 1648, 240, 0},
    { 1408, 184, -72},
    { 1272, 152, -88},
    { 688, -584, -16},
    { 776, -408, 24},
    { 856, -392, -72},
    { 1304, -48, -248},
    { 1416, 280, -320},
    { 1328, 112, -208},
    { 1184, 336, -328},
    { 1152, 384, -264},
    { 1344, 392, -288},
    // 5 seconds
    { 1400, 600, -336},
    { 1448, 792, -464},
    { 1080, 936, -608},
    { 968, 1120, -632},
    { 896, 936, -512},
    { 1000, 1032, -368},
    { 1152, 792, -256},
    { 1392, 712, -208},
    { 1528, 592, -176},
    { 1368, 352, -112},
    { 1144, 240, -96},
    { 1128, 272, -104},
    { 1232, 304, -80},
    { 1304, 248, -72},
    { 1304, 184, -24},
    { 1176, 168, -24},
    { 912, -240, -88},
    { 800, -368, 16},
    { 800, -256, -56},
    { 1320, -144, -256},
    { 1552, 352, -312},
    { 1344, 80, -192},
    { 1184, 264, -344},
    { 1208, 448, -296},
    { 1448, 448, -320},
    // 6 seconds
    { 1520, 544, -384},
    { 1480, 768, -520},
    { 1176, 864, -688},
    { 1008, 944, -720},
    { 808, 1072, -696},
    { 904, 920, -464},
    { 1280, 784, -440},
    { 1696, 656, -320},
    { 1528, 400, -216},
    { 1200, 264, -168},
    { 1168, 280, -128},
    { 1568, 344, -232},
    { 1904, 424, -208},
    { 1456, 208, -160},
    { 1448, 152, -192},
    { 1088, -240, 312},
    { 288, -856, 416},
    { 816, -160, -112},
    { 1080, -64, -208},
    { 1472, 128, -72},
    { 1360, 216, -304},
    { 1136, 344, -392},
    { 1152, 304, -272},
    { 1592, 440, -392},
    { 1872, 632, -456},
    // 7 seconds
    { 1584, 1144, -704},
    { 976, 1128, -968},
    { 784, 1080, -760},
    { 808, 1040, -624},
    { 1232, 848, -384},
    { 1840, 832, -280},
    { 1856, 640, -208},
    { 1560, 456, -208},
    { 1200, 240, -184},
    { 1096, 200, -88},
    { 1240, 328, -160},
    { 1504, 176, -208},
    { 1368, 112, -24},
    { 1104, 144, -64},
    { 896, 80, -72},
    { 400, -408, 104},
    { 664, -224, -120},
    { 1064, 40, -328},
    { 1464, 312, -344},
    { 1416, 208, -320},
    { 1320, 240, -272},
    { 1264, 472, -360},
    { 1352, 456, -264},
    { 1728, 752, -264},
    { 1880, 800, -264},
    // 8 seconds
    { 1504, 1120, -320},
    { 1016, 1472, -416},
    { 848, 1288, -192},
    { 728, 1032, -120},
    { 944, 880, -56},
    { 1368, 680, -104},
    { 1504, 512, -152},
    { 1488, 440, -128},
    { 1432, 240, -120},
    { 1376, 328, -64},
    { 1320, 264, -80},
    { 1288, 184, -64},
    { 1264, 192, -80},
    { 1152, 144, -56},
    { 888, -376, -40},
    { 720, -288, 88},
    { 952, -80, -344},
    { 1224, -16, -192},
    { 1240, 304, -288},
    { 1144, 120, -232},
    { 1032, 336, -288},
    { 1288, 416, -256},
    { 1640, 560, -344},
    { 1656, 816, -368},
    { 1328, 848, -456},
    // 9 seconds
    { 1008, 1088, -568},
    { 944, 1096, -408},
    { 1032, 816, -248},
    { 1024, 688, -216},
    { 1168, 656, -200},
    { 1320, 544, -208},
    { 1160, 344, -112},
    { 1144, 320, -24},
    { 1120, 408, 40},
    { 1152, 368, 24},
    { 1336, 288, 64},
    { 1352, 168, 40},
    { 1296, 208, -8},
    { 1248, 160, -184},
    { 872, -240, 16},
    { 712, -288, -224},
    { 1096, -296, -320},
    { 1176, 16, -344},
    { 1032, -8, -296},
    { 952, 152, -312},
    { 1008, 328, -352},
    { 1304, 384, -312},
    { 1712, 496, -296},
    { 1720, 816, -448},
    { 1264, 848, -392},
    // 10 seconds
    { 1248, 960, -552},
    { 1024, 1192, -448},
    { 776, 760, -352},
    { 936, 704, -424},
    { 1072, 664, -344},
    { 1320, 400, -304},
    { 1128, 88, -248},
    { 1128, 224, -88},
    { 1232, 424, -240},
    { 1552, 176, -168},
    { 1488, 112, -64},
    { 1392, 88, -120},
    { 1024, -200, -96},
    { 1080, -248, -16},
    { 616, -336, -224},
    { 1032, -256, -176},
    { 1352, 104, -136},
    { 1232, -72, -160},
    { 1056, 192, -256},
    { 1152, 360, -304},
    { 1232, 376, -264},
    { 1368, 432, -296},
    { 1584, 624, -328},
    { 1272, 904, -336},
    { 1152, 1112, -480},
    // 11 seconds
    { 920, 1216, -336},
    { 1000, 1048, -264},
    { 888, 720, -216},
    { 1024, 672, -224},
    { 1272, 592, -176},
    { 1392, 392, -136},
    { 1352, 240, -128},
    { 1312, 232, -88},
    { 1416, 248, -128},
    { 1392, 168, -88},
    { 1376, 216, -144},
    { 1360, 16, -120},
    { 784, -408, -72},
    { 1104, -464, -8},
    { 912, -296, -240},
    { 1216, -104, -256},
    { 1328, 184, -312},
    { 1224, 96, -264},
    { 1056, 216, -280},
    { 1224, 360, -264},
    { 1456, 472, -280},
    { 1704, 656, -352},
    { 1400, 968, -312},
    { 1088, 1088, -584},
    { 760, 1264, -408},
    // 12 seconds
    { 1048, 1064, -280},
    { 1128, 800, -224},
    { 1264, 696, -176},
    { 1336, 496, -168},
    { 1200, 400, -128},
    { 1256, 248, -168},
    { 1352, 224, -64},
    { 1432, 264, -144},
    { 1560, 136, -96},
    { 1184, 192, -120},
    { 1264, 208, -184},
    { 864, -328, 0},
    { 824, -360, 112},
    { 864, -184, -272},
    { 1160, -80, -304},
    { 1336, 344, -304},
    { 1184, 64, -240},
    { 1016, 256, -256},
    { 1152, 384, -264},
    { 1400, 496, -264},
    { 1616, 624, -288},
    { 1448, 872, -304},
    { 1128, 816, -432},
    { 864, 1104, -352},
    { 968, 1072, -216},
    // 13 seconds
    { 1064, 832, -224},
    { 1184, 736, -184},
    { 1328, 688, -168},
    { 1440, 504, -136},
    { 1320, 328, -128},
    { 1256, 216, -120},
    { 1272, 344, -72},
    { 1272, 192, -48},
    { 1264, 200, -72},
    { 1288, 168, -56},
    { 1208, 152, -40},
    { 1104, -432, -40},
    { 800, -416, 168},
    { 1072, -112, -408},
    { 1288, -160, -200},
    { 1280, 264, -280},
    { 1144, 72, -264},
    { 1096, 344, -280},
    { 1360, 432, -224},
    { 1680, 576, -248},
    { 1608, 864, -240},
    { 1376, 792, -328},
    { 1104, 1024, -288},
    { 872, 984, -168},
    { 984, 928, -224},
    // 14 seconds
    { 1208, 864, -160},
    { 1224, 640, -200},
    { 1256, 544, -200},
    { 1120, 368, -120},
    { 1160, 232, -112},
    { 1136, 160, -32},
    { 1208, 376, -8},
    { 1384, 216, -24},
    { 1520, 192, -8},
    { 1456, 184, -8},
    { 992, -128, -32},
    { 1024, -72, 40},
    { 664, -64, -200},
    { 832, 144, -368},
    { 952, 256, -264},
    { 968, 160, -248},
    { 832, 368, -264},
    { 880, 320, -72},
    { 1192, 480, -216},
    { 1480, 784, -200},
    { 1320, 800, 80},
    { 1280, 624, -280},
    { 1168, 808, -224},
    { 1064, 1120, -64},
    { 1000, 792, -128},
    // 15 seconds
    { 1088, 688, -168},
    { 1152, 704, -104},
    { 1152, 472, -96},
    { 984, 296, -88},
    { 888, 224, -104},
    { 968, 240, -64},
    { 1200, 360, -104},
    { 1416, 200, -104},
    { 1488, 136, -56},
    { 1264, 168, -208},
    { 976, -216, -56},
    { 640, -160, 8},
    { 864, 8, -344},
    { 1144, 64, -216},
    { 1080, 296, -192},
    { 880, 152, -232},
    { 792, 312, -224},
    { 984, 336, -192},
    { 1368, 432, -240},
    { 1608, 672, -352},
    { 1240, 976, -328},
    { 1160, 776, -624},
    { 968, 936, -376},
    { 976, 976, -248},
    { 1120, 824, -232},
    // 16 seconds
    { 1232, 624, -200},
    { 1272, 536, -160},
    { 1136, 368, -160},
    { 1128, 200, -168},
    { 1280, 384, -240},
    { 1232, 272, -176},
    { 1248, 456, -232},
    { 1328, 464, -136},
    { 1184, 360, -144},
    { 904, 288, -384},
    { 912, 336, -384},
    { 464, 232, -496},
    { 536, 264, -696},
    { 624, 336, -576},
    { 552, 440, -648},
    { 288, 648, -624},
    { 216, 672, -552},
    { 24, 784, -648},
    { -224, 880, -544},
    { -408, 1008, -624},
    { -680, 1104, -536},
    { -712, 1224, -720},
    { -608, 1272, -648},
    { -384, 1280, -808},
    { -160, 1520, -880},
    // 17 seconds
    { -16, 1352, -768},
    { 152, 1248, -752},
    { 184, 856, -520},
    { 104, 560, -488},
    { 40, 352, -336},
    { -8, 408, -200},
    { 8, 320, -352},
    { 128, 288, -384},
    { 384, 272, -392},
    { 464, 248, -488},
    { 696, 40, -352},
    { 984, 160, -424},
    { 1576, 152, -568},
    { 2248, 328, -552},
    { 2344, 472, -464},
    { 1656, 560, -464},
    { 1432, 648, -328},
    { 1768, 472, -192},
    { 1568, 664, -168},
    { 1272, 600, -200},
    { 832, 1000, -272},
    { 600, 1312, -264},
    { 904, 1232, -336},
    { 1016, 872, -304},
    { 1248, 736, -240},
    // 18 seconds
    { 1504, 752, -224},
    { 1904, 544, -240},
    { 1752, 336, -168},
    { 1720, 256, -160},
    { 1688, 208, -128},
    { 1496, 224, -120},
    { 1344, 264, -136},
    { 1088, 184, -72},
    { 968, 240, -72},
    { 896, 72, -88},
    { 512, -472, 128},
    { 712, 48, -480},
    { 872, -168, -240},
    { 976, 112, -208},
    { 1120, 168, -272},
    { 1088, 216, -296},
    { 1320, 320, -232},
    { 1720, 448, -288},
    { 2064, 776, -312},
    { 1704, 1032, -184},
    { 1480, 968, -304},
    { 1032, 1288, -224},
    { 928, 1632, 96},
    { 1008, 1080, 88},
    { 992, 904, -32},
    // 19 seconds
    { 1288, 792, -40},
    { 1432, 568, -48},
    { 1360, 392, -40},
    { 1408, 296, -80},
    { 1480, 304, -72},
    { 1544, 280, -72},
    { 1384, 120, 0},
    { 1168, 248, -72},
    { 1088, 72, -168},
    { 712, -448, -56},
    { 744, -224, -32},
    { 872, 24, -504},
    { 1160, -24, -336},
    { 1200, 208, -360},
    { 1232, 80, -344},
    { 1200, 304, -288},
    { 1328, 440, -328},
    { 1528, 576, -360},
    { 1488, 992, -184},
    { 1392, 600, -232},
    { 1032, 912, -280},
    { 944, 1008, -168},
    { 1008, 1040, -104},
    { 984, 848, -144},
    { 1176, 824, -88},
    // 20 seconds
    { 1280, 728, -64},
    { 1344, 520, -96},
    { 1200, 344, -96},
    { 1152, 280, -112},
    { 1256, 272, -40},
    { 1424, 336, -80},
    { 1424, 224, -48},
    { 1168, 208, -8},
    { 1056, 136, -88},
    { 848, 88, -152},
    { 944, 208, -48},
    { 584, 88, -320},
    { 768, 176, -424},
    { 976, 136, -392},
    { 928, 160, -360},
    { 744, 288, -344},
    { 840, 304, -272},
    { 1144, 400, -200},
    { 1608, 560, -176},
    { 1624, 872, -160},
    { 1240, 656, -112},
    { 1280, 784, -112},
    { 1080, 960, -56},
    { 960, 1008, -96},
    { 920, 888, -112},
    // 21 seconds
    { 896, 744, -144},
    { 1104, 656, -192},
    { 992, 496, -128},
    { 1056, 344, -120},
    { 1216, 264, -128},
    { 1496, 352, -128},
    { 1576, 144, -64},
    { 1296, 88, -56},
    { 1304, 160, -112},
    { 1112, 72, -64},
    { 992, 32, 72},
    { 408, -32, -320},
    { 800, 112, -376},
    { 1016, 176, -288},
    { 952, 32, -216},
    { 856, 200, -288},
    { 1024, 264, -304},
    { 1232, 384, -312},
    { 1440, 512, -392},
    { 1448, 688, -432},
    { 1144, 624, -408},
    { 1152, 616, -584},
    { 1112, 848, -472},
    { 1040, 840, -400},
    { 976, 816, -408},
    // 22 seconds
    { 1080, 640, -368},
    { 1224, 528, -304},
    { 1080, 312, -176},
    { 1080, 272, -168},
    { 1208, 256, -168},
    { 1440, 272, -184},
    { 1384, 144, -32},
    { 1264, 264, -184},
    { 1248, 192, -200},
    { 944, -224, 24},
    { 880, -96, 80},
    { 592, -64, -328},
    { 944, -72, -352},
    { 1080, 72, -232},
    { 1104, 104, -288},
    { 880, 208, -344},
    { 936, 248, -328},
    { 1200, 328, -296},
    { 1608, 424, -408},
    { 1696, 816, -472},
    { 1176, 968, -552},
    { 912, 1144, -744},
    { 856, 1232, -552},
    { 1080, 912, -392},
    { 1112, 704, -288},
    // 23 seconds
    { 1264, 608, -264},
    { 1464, 664, -232},
    { 1392, 416, -144},
    { 1312, 160, -168},
    { 1208, 288, -120},
    { 1304, 288, -96},
    { 1408, 200, -136},
    { 1288, 192, -56},
    { 1128, 120, -104},
    { 608, -240, -16},
    { 752, -96, -56},
    { 520, -48, -272},
    { 896, 88, -280},
    { 1152, 288, -352},
    { 1176, 192, -264},
    { 1072, 272, -240},
    { 1184, 328, -280},
    { 1352, 432, -296},
    { 1600, 632, -360},
    { 1400, 752, -432},
    { 1056, 792, -576},
    { 944, 1032, -656},
    { 944, 960, -584},
    { 936, 816, -408},
    { 1024, 704, -312},
    // 24 seconds
    { 1192, 616, -224},
    { 1400, 536, -200},
    { 1272, 320, -136},
    { 1160, 200, -112},
    { 1216, 304, -128},
    { 1240, 224, -104},
    { 1248, 200, -88},
    { 1184, 184, -72},
    { 1128, 168, -104},
    { 968, -104, -144},
    { 840, -160, 8},
    { 720, -48, -280},
    { 1072, 0, -416},
    { 1248, 256, -384},
    { 1080, 56, -296},
    { 904, 104, -312},
    { 1024, 232, -328},
    { 1328, 400, -368},
    { 1816, 696, -360},
    { 1656, 888, -488},
    { 1160, 904, -496},
    { 1128, 944, -472},
    { 1008, 1000, -416},
    { 944, 768, -304},
    { 1064, 760, -256},
    // 25 seconds
    { 1128, 672, -272},
    { 1304, 488, -184},
    { 1240, 368, -168},
    { 1232, 264, -168},
    { 1320, 304, -120},
    { 1576, 264, -112},
    { 1512, 168, -24},
    { 1384, 208, -120},
    { 1224, -56, -32},
    { 968, -256, 0},
    { 712, -320, 160},
    { 936, -56, -344},
    { 1136, 56, -256},
    { 1128, 160, -232},
    { 1016, 152, -272},
    { 1032, 272, -288},
    { 1304, 408, -272},
    { 1560, 480, -328},
    { 1608, 784, -448},
    { 1400, 856, -512},
    { 1088, 1040, -624},
    { 704, 1040, -512},
    { 880, 1096, -440},
    { 1136, 912, -224},
    { 1336, 760, -192},
    // 26 seconds
    { 1400, 664, -184},
    { 1208, 432, -112},
    { 1088, 312, -112},
    { 1224, 304, -128},
    { 1464, 328, -144},
    { 1592, 152, -64},
    { 1192, 104, -80},
    { 1256, 184, -192},
    { 864, -144, -120},
    { 616, -456, 48},
    { 728, -96, -184},
    { 1032, -32, -336},
    { 1376, 352, -408},
    { 1288, 256, -336},
    { 1104, 328, -320},
    { 1208, 384, -288},
    { 1520, 592, -312},
    { 1512, 872, -328},
    { 1264, 712, -472},
    { 856, 968, -576},
    { 848, 1008, -440},
    { 1048, 904, -352},
    { 1328, 872, -280},
    { 1320, 768, -224},
    { 1352, 800, -240},
    // 27 seconds
    { 1432, 544, -112},
    { 1224, 240, -64},
    { 1112, 240, -72},
    { 1160, 304, -72},
    { 1272, 256, -32},
    { 1264, 192, 16},
    { 1152, 168, 8},
    { 1120, 176, -8},
    { 1096, 88, -56},
    { 760, -256, -72},
    { 1040, -152, -240},
    { 936, -80, -360},
    { 1328, 80, -376},
    { 1216, 160, -256},
    { 1160, 200, -256},
    { 1152, 360, -360},
    { 1264, 400, -200},
    { 1456, 448, -184},
    { 1488, 752, -232},
    { 1088, 1096, -248},
    { 992, 760, -360},
    { 968, 920, -224},
    { 1048, 768, -232},
    { 1024, 992, -136},
    { 1104, 864, -128},
    // 28 seconds
    { 960, 680, -152},
    { 1072, 736, -48},
    { 1264, 568, 120},
    { 1200, 472, 184},
    { 1376, 336, 16},
    { 1560, 384, -32},
    { 1744, 376, -96},
    { 1568, 264, -152},
    { 1304, 216, -248},
    { 824, -168, -176},
    { 304, -560, -208},
    { 768, -432, -304},
    { 1392, -400, -288},
    { 1832, -8, -376},
    { 1672, 32, -472},
    { 1456, 360, -544},
    { 1416, 544, -496},
    { 1376, 768, -472},
    { 1504, 568, -264},
    { 1552, 672, -208},
    { 1080, 752, -160},
    { 848, 960, -160},
    { 1024, 968, -160},
    { 1112, 992, -104},
    { 800, 752, -200},
    // 29 seconds
    { 928, 792, -248},
    { 1280, 704, -272},
    { 1600, 544, -296},
    { 1672, 568, -256},
    { 1688, -248, -112},
    { 1152, 304, -64},
    { 1176, 320, -208},
    { 1216, 256, -208},
    { 1200, 184, -56},
    { 1152, 192, -112},
    { 856, -112, -168},
    { 776, -272, 0},
    { 736, -184, -336},
    { 1096, -192, -208},
    { 1280, 80, -176},
    { 1384, 16, -232},
    { 1336, 424, -352},
    { 1464, 480, -248},
    { 1624, 496, -272},
    { 1720, 600, -296},
    { 1480, 768, -280},
    { 968, 1096, -392},
    { 816, 1272, -424},
    { 912, 1368, -400},
    { 1072, 960, -200},
    // 30 seconds
    { 1200, 848, -216},
    { 1368, 640, -248},
    { 1504, 520, -208},
    { 1416, 408, -160},
    { 1384, 248, -168},
    { 1400, 256, -136},
    { 1480, 248, -104},
    { 1408, 152, -80},
    { 1248, 168, -64},
    { 1040, 16, -48},
    { 792, -312, -24},
    { 744, -128, -184},
    { 936, -96, -408},
    { 1216, 128, -224},
    { 1264, 104, -296},
    { 1192, 184, -376},
    { 1200, 336, -344},
    { 1360, 472, -376},
    { 1448, 568, -392},
    { 1504, 752, -368},
    { 1352, 728, -392},
    { 968, 920, -496},
    { 840, 984, -520},
    { 1184, 1248, -392},
    { 1144, 816, -320},
    // 31 seconds
    { 1056, 752, -360},
    { 1200, 568, -304},
    { 1352, 432, -272},
    { 1336, 448, -208},
    { 1344, -56, -120},
    { 1288, 320, -160},
    { 1288, 144, -224},
    { 1232, 184, -176},
    { 1064, 168, -224},
    { 1072, -56, -128},
    { 592, -472, -24},
    { 920, -264, -128},
    { 960, -128, -264},
    { 1208, 128, -280},
    { 1296, 184, -360},
    { 1192, 160, -296},
    { 1168, 336, -320},
    { 1368, 456, -232},
    { 1720, 568, -320},
    { 1600, 784, -328},
    { 1200, 1080, -440},
    { 704, 1360, -656},
    { 816, 1296, -640},
    { 1224, 1064, -408},
    { 1312, 864, -336},
    // 32 seconds
    { 1376, 664, -240},
    { 1688, 576, -184},
    { 1624, 392, -104},
    { 1440, 216, -64},
    { 1360, 304, -80},
    { 1328, 272, -64},
    { 1352, 240, -96},
    { 1304, 184, -152},
    { 1168, -48, -136},
    { 408, -544, -80},
    { 992, -416, -168},
    { 864, -240, -208},
    { 1280, 40, -240},
    { 1320, 224, -272},
    { 1376, 216, -184},
    { 1320, 408, -256},
    { 1416, 480, -184},
    { 1592, 512, -176},
    { 1760, 720, -104},
    { 1656, 1040, -184},
    { 1216, 1344, -256},
    { 792, 1488, -416},
    { 824, 1568, -376},
    { 1040, 936, -232},
    { 1224, 824, -216},
    // 33 seconds
    { 1496, 680, -176},
    { 1736, 480, -144},
    { 1536, 360, -112},
    { 1464, 304, -96},
    { 1504, 336, -88},
    { 1456, 296, -88},
    { 1464, 208, -40},
    { 1296, 184, -48},
    { 1232, 136, -160},
    { 632, -520, -120},
    { 656, -456, -32},
    { 728, -192, -360},
    { 1096, 32, -256},
    { 1360, 232, -352},
    { 1400, 224, -280},
    { 1376, 408, -352},
    { 1488, 472, -336},
    { 1560, 600, -328},
    { 1632, 672, -352},
    { 1440, 832, -576},
    { 920, 1096, -632},
    { 848, 992, -536},
    { 1032, 1000, -360},
    { 944, 752, -208},
    { 1112, 664, -136},
    // 34 seconds
    { 1296, 648, -128},
    { 1288, 480, -128},
    { 1176, 336, -120},
    { 1288, 288, -120},
    { 1496, 344, -112},
    { 1480, 296, -88},
    { 1376, 248, -112},
    { 1360, 272, -120},
    { 1152, 144, -304},
    { 952, -464, 88},
    { 536, -352, -104},
    { 1104, -152, -352},
    { 1264, 48, -264},
    { 1080, 112, -192},
    { 928, 104, -280},
    { 992, 280, -248},
    { 1376, 504, -344},
    { 1736, 624, -416},
    { 1528, 832, -552},
    { 1272, 720, -584},
    { 1048, 904, -640},
    { 912, 960, -560},
    { 880, 880, -480},
    { 880, 832, -392},
    { 1200, 664, -392},
    // 35 seconds
    { 1560, 520, -296},
    { 1280, 352, -224},
    { 1152, 216, -240},
    { 1168, 248, -192},
    { 1184, 216, -176},
    { 1384, 160, -176},
    { 1288, -16, 0},
    { 1032, -184, 56},
    { 880, -312, 16},
    { 1176, -328, 208},
    { 1168, -120, -336},
    { 1344, -296, -112},
    { 1328, 88, -136},
    { 1304, 96, -328},
    { 1080, 328, -312},
    { 1192, 344, -216},
    { 1408, 512, -336},
    { 1496, 640, -304},
    { 1312, 992, -392},
    { 968, 1144, -512},
    { 832, 1176, -448},
    { 912, 1040, -432},
    { 1008, 960, -256},
    { 1528, 808, -256},
    { 1816, 696, -200},
    // 36 seconds
    { 1504, 432, -176},
    { 1192, 264, -168},
    { 1120, 232, -152},
    { 1224, 288, -144},
    { 1424, 232, -200},
    { 1520, 144, -104},
    { 1184, 48, -144},
    { 976, -352, -144},
    { 712, -512, 72},
    { 760, -120, -112},
    { 1216, -304, -368},
    { 1424, 408, -272},
    { 1312, 128, -200},
    { 1240, 192, -192},
    { 1304, 464, -280},
    { 1560, 488, -200},
    { 1752, 704, -320},
    { 1624, 952, -264},
    { 1240, 912, -552},
    { 664, 1320, -520},
    { 800, 1160, -352},
    { 1208, 920, -312},
    { 1336, 776, -208},
    { 1448, 736, -232},
    { 1512, 584, -208},
    // 37 seconds
    { 1248, 344, -128},
    { 1200, 216, -184},
    { 1224, 232, -72},
    { 1336, 256, -120},
    { 1416, 152, -120},
    { 1344, 136, -16},
    { 1200, 104, -64},
    { 776, -360, -64},
    { 840, -192, 48},
    { 736, 0, -376},
    { 1240, -8, -208},
    { 1296, 304, -304},
    { 1192, 16, -288},
    { 1112, 240, -336},
    { 1160, 320, -280},
    { 1384, 456, -440},
    { 1400, 656, -472},
    { 1288, 840, -648},
    { 952, 928, -736},
    { 912, 864, -616},
    { 1184, 944, -504},
    { 1112, 536, -328},
    { 1208, 656, -296},
    { 1392, 608, -256},
    { 1208, 400, -208},
    // 38 seconds
    { 1040, 184, -160},
    { 920, 136, -112},
    { 1072, 216, -120},
    { 1224, 184, -160},
    { 1272, 168, -136},
    { 1328, 160, -144},
    { 1360, 192, -208},
    { 1240, -296, 168},
    { 432, -400, -136},
    { 960, -176, -464},
    { 1232, -16, -256},
    { 1208, 32, -352},
    { 1064, 224, -416},
    { 1184, 320, -304},
    { 1352, 480, -296},
    { 1632, 672, -280},
    { 1544, 704, -200},
    { 1048, 832, -328},
    { 800, 1016, -336},
    { 976, 1136, -128},
    { 1128, 808, -216},
    { 1112, 744, -192},
    { 1232, 648, -136},
    { 1384, 536, -128},
    { 1208, 312, -120},
    // 39 seconds
    { 1152, 56, -184},
    { 1104, 280, -48},
    { 1296, 320, -144},
    { 1360, 192, -152},
    { 1336, 168, -16},
    { 1232, 208, -128},
    { 1280, 32, -160},
    { 600, -480, 40},
    { 928, -184, -312},
    { 984, -208, -224},
    { 1088, 88, -248},
    { 912, -64, -320},
    { 888, 112, -264},
    { 1184, 288, -256},
    { 1584, 424, -328},
    { 1840, 776, -480},
    { 1192, 1168, -552},
    { 1136, 800, -656},
    { 824, 1032, -536},
    { 1016, 1000, -312},
    { 1192, 768, -288},
    { 1224, 624, -216},
    { 1384, 576, -216},
    { 1112, 328, -168},
    { 992, 168, -192},
    // 40 seconds
    { 1072, 200, -200},
    { 1344, 240, -168},
    { 1488, 184, -184},
    { 1352, 152, -144},
    { 1064, 160, -160},
    { 824, 104, -152},
    { 752, 72, -120},
    { 488, 8, -296},
    { 856, -144, -512},
    { 1096, -152, -288},
    { 1072, -24, -320},
    { 848, 152, -480},
    { 792, 192, -408},
    { 1088, 184, -360},
    { 1544, 328, -464},
    { 1600, 744, -680},
    { 1120, 608, -536},
    { 1200, 656, -632},
    { 984, 904, -584},
    { 1040, 1032, -680},
    { 1176, 688, -392},
    { 1144, 624, -432},
    { 1328, 528, -376},
    { 1104, 240, -256},
    { 912, 96, -248},
    // 41 seconds
    { 976, 128, -264},
    { 1200, 264, -224},
    { 1272, 200, -176},
    { 1304, 144, -112},
    { 1184, 152, -104},
    { 984, 240, -248},
    { 808, -224, 16},
    { 520, -160, -320},
    { 944, -80, -376},
    { 1200, 96, -240},
    { 1040, 56, -288},
    { 816, 184, -360},
    { 896, 296, -208},
    { 1248, 424, -280},
    { 1576, 504, -328},
    { 1560, 824, -392},
    { 1056, 872, -440},
    { 1096, 824, -440},
    { 856, 1184, -376},
    { 1168, 896, -208},
    { 1192, 752, -288},
    { 1216, 704, -272},
    { 1288, 632, -240},
    { 1032, 336, -176},
    { 1008, 144, -184},
    // 42 seconds
    { 1128, 264, -152},
    { 1352, 272, -104},
    { 1424, 184, -128},
    { 1280, 120, 8},
    { 1088, 168, -48},
    { 840, -8, -16},
    { 840, 48, 80},
    { 648, -40, -216},
    { 944, -8, -368},
    { 1024, 120, -336},
    { 1064, -16, -312},
    { 1032, 248, -416},
    { 1152, 360, -408},
    { 1416, 424, -432},
    { 1544, 672, -456},
    { 1256, 592, -408},
    { 1024, 704, -560},
    { 968, 848, -504},
    { 1200, 1008, -416},
    { 1072, 760, -368},
    { 1296, 744, -344},
    { 1376, 480, -328},
    { 1104, 280, -232},
    { 1040, 312, -216},
    { 1080, 224, -224},
    // 43 seconds
    { 1216, 352, -208},
    { 1520, 296, -184},
    { 1600, 264, -72},
    { 1560, 248, -168},
    { 1152, -56, -80},
    { 640, -152, 144},
    { 600, -80, -64},
    { 800, -32, -376},
    { 1088, 120, -344},
    { 1040, 72, -272},
    { 944, 104, -344},
    { 1040, 376, -480},
    { 1208, 528, -520},
    { 1408, 640, -416},
    { 1416, 720, -568},
    { 1088, 744, -656},
    { 872, 696, -688},
    { 832, 744, -664},
    { 1000, 944, -672},
    { 1176, 1040, -512},
    { 1240, 648, -424},
    { 1240, 544, -408},
    { 1072, 536, -216},
    { 1176, 408, -104},
    { 1456, 704, -168},
    // 44 seconds
    { 1576, 824, -88},
    { 1480, 752, -72},
    { 1416, 584, -96},
    { 1200, 280, 8},
    { 760, -208, 72},
    { 672, -256, 176},
    { 728, -200, -104},
    { 1000, 48, -320},
    { 1168, 264, -296},
    { 1128, 152, -264},
    { 1200, 232, -280},
    { 1496, 416, -408},
    { 1848, 512, -392},
    { 1912, 872, -432},
    { 1608, 608, -520},
    { 1056, 952, -624},
    { 944, 952, -576},
    { 1168, 864, -576},
    { 904, 648, -392},
    { 1008, 744, -440},
    { 1192, 680, -376},
    { 1264, 496, -248},
    { 1160, 328, -152},
    { 1152, 256, -160},
    { 1256, 248, -160},
    // 45 seconds
    { 1336, 240, -120},
    { 1408, 184, -136},
    { 1344, 104, -48},
    { 1336, 224, -64},
    { 1352, 88, -96},
    { 656, -416, 240},
    { 680, -176, -360},
    { 952, -312, -216},
    { 1296, 56, -208},
    { 1144, 8, -320},
    { 1056, 376, -344},
    { 1280, 504, -280},
    { 1584, 464, -320},
    { 1568, 712, -336},
    { 1288, 736, -352},
    { 1008, 952, -480},
    { 944, 1128, -416},
    { 1312, 1160, -408},
    { 1016, 624, -264},
    { 888, 592, -320},
    { 1008, 544, -304},
    { 1096, 368, -216},
    { 1200, 264, -272},
    { 1368, 136, -112},
    { 1352, 224, -112},
    // 46 seconds
    { 1360, 160, -176},
    { 1272, 184, -208},
    { 1160, -32, -184},
    { 952, -392, -88},
    { 1160, -440, 64},
    { 928, -232, -216},
    { 1200, -136, -352},
    { 1208, 80, -208},
    { 1224, -24, -248},
    { 1104, 192, -376},
    { 1080, 344, -224},
    { 1264, 416, -240},
    { 1400, 552, -256},
    { 1336, 816, -280},
    { 912, 1168, -376},
    { 768, 1320, -480},
    { 1088, 1264, -320},
    { 1352, 800, -256},
    { 1336, 728, -248},
    { 1408, 696, -176},
    { 1552, 440, -152},
    { 1352, 280, -80},
    { 1320, 256, -96},
    { 1424, 280, -72},
    { 1512, 216, -40},
    // 47 seconds
    { 1352, 200, -24},
    { 1320, 216, -96},
    { 1160, -168, 8},
    { 664, -496, 72},
    { 824, -432, 32},
    { 872, -88, -336},
    { 1176, 72, -264},
    { 1328, 168, -312},
    { 1304, 176, -360},
    { 1256, 336, -360},
    { 1416, 456, -336},
    { 1616, 600, -424},
    { 1528, 1016, -456},
    { 1200, 904, -592},
    { 704, 1184, -768},
    { 880, 1120, -488},
    { 1280, 1104, -400},
    { 1368, 848, -304},
    { 1328, 720, -272},
    { 1664, 696, -208},
    { 1632, 392, -16},
    { 1456, 208, -96},
    { 1512, 328, -136},
    { 1544, 312, 0},
    { 1480, 264, 0},
    // 48 seconds
    { 1352, 224, 32},
    { 1232, 256, 0},
    { 1104, 200, -112},
    { 752, -136, -136},
    { 392, -104, -168},
    { 112, -200, -344},
    { 752, 40, -592},
    { 1096, 152, -560},
    { 1152, 16, -528},
    { 832, -64, -512},
    { 800, -120, -296},
    { 824, 120, -216},
    { 1136, 328, -128},
    { 1136, 632, -152},
    { 848, 840, -872},
    { 1128, 952, -1552},
    { 1288, 1264, -832},
    { 1392, 728, -840},
    { 1016, 880, -552},
    { 976, 1064, -440},
    { 1456, 632, -360},
    { 1352, 256, -152},
    { 1176, 296, -168},
    { 1240, 256, -168},
    { 1456, 296, -192},
    // 49 seconds
    { 1624, 160, -64},
    { 1320, 128, -112},
    { 1320, 168, -224},
    { 1096, -208, 40},
    { 392, -552, 104},
    { 640, -472, -96},
    { 936, -88, -296},
    { 1280, 40, -152},
    { 1616, 352, -400},
    { 1440, 280, -432},
    { 1320, 368, -360},
    { 1520, 600, -432},
    { 1624, 648, -520},
    { 1256, 928, -800},
    { 376, 1216, -1064},
    { 664, 936, -800},
    { 1016, 896, -592},
    { 1648, 952, -400},
    { 1680, 792, -312},
    { 1584, 640, -216},
    { 1712, 528, -152},
    { 1336, 224, -96},
    { 1040, 184, -112},
    { 1080, 224, -160},
    { 1232, 216, -96},
    // 50 seconds
    { 1304, 208, -88},
    { 1120, 136, -64},
    { 1048, 152, -144},
    { 784, -288, 8},
    { 760, -232, 0},
    { 512, -104, -184},
    { 1160, 0, -328},
    { 1368, 264, -336},
    { 1448, 184, -320},
    { 1472, 216, -392},
    { 1552, 464, -424},
    { 1480, 672, -464},
    { 1536, 616, -496},
    { 1440, 816, -776},
    { 736, 912, -896},
    { 680, 768, -840},
    { 1072, 824, -672},
    { 1408, 856, -480},
    { 1360, 712, -360},
    { 1512, 632, -304},
    { 1776, 552, -200},
    { 1544, 312, -120},
    { 1304, 96, -128},
    { 1176, 272, -128},
    { 1232, 176, -64},
    // 51 seconds
    { 1296, 216, -56},
    { 1200, 128, 8},
    { 1056, 168, -96},
    { 944, -40, -128},
    { 664, -264, 88},
    { 528, -168, -184},
    { 1040, 24, -368},
    { 1216, 176, -280},
    { 1368, 248, -336},
    { 1328, 208, -360},
    { 1376, 368, -328},
    { 1568, 512, -336},
    { 1784, 680, -400},
    { 1616, 832, -424},
    { 1088, 1016, -688},
    { 704, 1312, -832},
    { 864, 1024, -744},
    { 1184, 1072, -496},
    { 1280, 760, -352},
    { 1616, 680, -288},
    { 1944, 624, -200},
    { 1672, 328, -96},
    { 1480, 152, -112},
    { 1368, 304, -96},
    { 1392, 224, -104},
    // 52 seconds
    { 1288, 192, -56},
    { 1136, 144, -24},
    { 1040, 184, -72},
    { 824, -224, 32},
    { 504, -360, 56},
    { 560, -296, -56},
    { 1056, -16, -256},
    { 1440, 216, -248},
    { 1520, 248, -304},
    { 1504, 184, -248},
    { 1592, 384, -320},
    { 1752, 584, -312},
    { 1864, 832, -312},
    { 1744, 840, -424},
    { 1224, 984, -568},
    { 632, 1216, -744},
    { 736, 912, -584},
    { 1088, 1088, -472},
    { 1272, 816, -312},
    { 1520, 744, -248},
    { 1736, 672, -232},
    { 1600, 448, -96},
    { 1488, 272, -96},
    { 1536, 200, -152},
    { 1504, 272, -48},
    // 53 seconds
    { 1504, 200, -88},
    { 1256, 136, 0},
    { 1144, 200, 0},
    { 1000, 104, 0},
    { 728, -568, 152},
    { 480, -176, -8},
    { 1096, -16, -272},
    { 1280, 128, -144},
    { 1408, 144, -240},
    { 1432, 216, -264},
    { 1544, 456, -320},
    { 1800, 584, -352},
    { 1904, 888, -392},
    { 1792, 792, -320},
    { 1328, 624, -472},
    { 1040, 784, -496},
    { 912, 968, -464},
    { 880, 1208, -480},
    { 880, 872, -448},
    { 1160, 800, -304},
    { 1528, 760, -184},
    { 1728, 472, -136},
    { 1496, 224, -168},
    { 1448, 144, -216},
    { 1608, 264, -160},
    // 54 seconds
    { 1664, 216, -64},
    { 1616, 152, -88},
    { 1272, 128, -56},
    { 1184, 240, -112},
    { 840, -368, -16},
    { 1048, -104, 256},
    { 608, -184, -272},
    { 848, -152, -248},
    { 1056, 136, -272},
    { 1048, 80, -232},
    { 1096, 272, -280},
    { 1384, 400, -320},
    { 1928, 544, -360},
    { 2048, 952, -520},
    { 1456, 544, -480},
    { 1168, 848, -608},
    { 928, 896, -640},
    { 1160, 1112, -672},
    { 1288, 1016, -336},
    { 1128, 864, -296},
    { 1056, 640, -312},
    { 1208, 496, -248},
    { 1288, 352, -160},
    { 1376, 192, -192},
    { 1432, 280, -160},
    // 55 seconds
    { 1368, 200, -120},
    { 1496, 200, -120},
    { 1320, 168, -56},
    { 1232, 232, -136},
    { 808, -440, 120},
    { 600, -664, 136},
    { 736, 152, -160},
    { 1072, -136, -176},
    { 1328, 232, -264},
    { 1240, 152, -240},
    { 1064, 304, -352},
    { 1184, 320, -240},
    { 1600, 480, -248},
    { 1808, 608, -288},
    { 1552, 984, -328},
    { 856, 1456, -544},
    { 664, 1512, -480},
    { 992, 1312, -328},
    { 1296, 904, -152},
    { 1312, 784, -120},
    { 1472, 672, -104},
    { 1616, 600, -104},
    { 1424, 352, -88},
    { 1320, 256, -112},
    { 1280, 184, -128},
    // 56 seconds
    { 1312, 240, -128},
    { 1328, 168, -144},
    { 1184, 152, -160},
    { 976, 16, -168},
    { 424, -536, -40},
    { 656, -280, -56},
    { 600, 8, -240},
    { 1192, 48, -272},
    { 1504, 432, -384},
    { 1448, 152, -184},
    { 1440, 248, -312},
    { 1536, 504, -224},
    { 1696, 584, -240},
    { 1696, 704, -192},
    { 1480, 872, -184},
    { 1080, 1032, -232},
    { 856, 1248, -176},
    { 912, 1312, -64},
    { 1056, 984, -96},
    { 1072, 784, -96},
    { 1160, 712, -80},
    { 1520, 616, -144},
    { 1488, 336, -88},
    { 1360, 288, -128},
    { 1472, 224, -144},
    // 57 seconds
    { 1536, 280, -112},
    { 1528, 264, -88},
    { 1328, 160, -96},
    { 1088, 160, -104},
    { 888, -200, -96},
    { 752, -240, -32},
    { 672, -264, -8},
    { 944, -136, -208},
    { 1096, 232, -248},
    { 1248, 264, -208},
    { 1280, 152, -256},
    { 1312, 400, -280},
    { 1536, 536, -216},
    { 1728, 664, -232},
    { 1512, 784, -256},
    { 1224, 944, -352},
    { 840, 1120, -336},
    { 840, 1024, -360},
    { 1136, 1176, -304},
    { 1232, 896, -232},
    { 1144, 704, -264},
    { 1360, 672, -248},
    { 1304, 408, -136},
    { 1184, 312, -136},
    { 1344, 256, -144},
    // 58 seconds
    { 1424, 296, -56},
    { 1608, 224, -96},
    { 1504, 120, 8},
    { 1248, 152, -56},
    { 888, -424, -120},
    { 1120, -320, 88},
    { 488, -168, -216},
    { 1192, -88, -256},
    { 1152, 232, -200},
    { 1152, 120, -200},
    { 1096, 248, -272},
    { 1256, 344, -184},
    { 1464, 472, -168},
    { 1760, 688, -208},
    { 1544, 792, -120},
    { 1352, 1016, -280},
    { 968, 1312, -256},
    { 936, 1480, -240},
    { 1048, 1064, -192},
    { 1032, 840, -256},
    { 1200, 824, -128},
    { 1616, 616, -88},
    { 1472, 376, -96},
    { 1472, 224, -152},
    { 1488, 352, -96},
    // 59 seconds
    { 1520, 264, -56},
    { 1512, 192, -104},
    { 1336, 168, 0},
    { 1184, 216, -88},
    { 736, -352, -56},
    { 632, -288, 112},
    { 648, -128, -208},
    { 1104, -128, -256},
    { 1312, 432, -312},
    { 1224, 128, -272},
    { 1152, 200, -304},
    { 1392, 384, -288},
    { 1840, 528, -288},
    { 1960, 832, -344},
    { 1504, 856, -344},
    { 1216, 896, -376},
    { 896, 1264, -336},
    { 912, 1200, -248},
    { 968, 1000, -200},
    { 1032, 832, -176},
    { 1240, 768, -112},
    { 1584, 728, -120},
    { 1432, 424, -104},
    { 1376, 312, -120},
    { 1416, 232, -120},
    // 60 seconds
    // elapsed: 1 minutes
    { 1392, 256, -104},
    { 1392, 176, -120},
    { 1280, 160, -40},
    { 1120, 152, -88},
    { 920, -168, 32},
    { 624, -264, 32},
    { 712, -208, -96},
    { 1016, -40, -240},
    { 1256, 168, -312},
    { 1344, 216, -288},
    { 1272, 160, -320},
    { 1296, 368, -360},
    { 1496, 488, -264},
    { 1656, 776, -336},
    { 1600, 792, -280},
    { 1208, 936, -376},
    { 632, 1200, -416},
    { 752, 944, -296},
    { 1024, 1016, -256},
    { 1056, 840, -120},
    { 1392, 728, -152},
    { 1544, 704, -152},
    { 1496, 504, -128},
    { 1384, 320, -152},
    { 1344, 152, -96},
    // 61 seconds
    { 1304, 288, -104},
    { 1304, 176, -128},
    { 1192, 176, -88},
    { 1080, 144, -64},
    { 968, 96, -112},
    { 640, -272, -80},
    { 960, -280, 40},
    { 968, -56, -328},
    { 1248, -88, -264},
    { 1352, 192, -312},
    { 1288, 104, -304},
    { 1192, 304, -328},
    { 1344, 408, -296},
    { 1632, 584, -320},
    { 1688, 856, -232},
    { 1376, 832, -264},
    { 1048, 928, -264},
    { 856, 1032, -88},
    { 912, 1048, -88},
    { 968, 968, -56},
    { 1232, 880, -48},
    { 1368, 728, -120},
    { 1552, 568, -152},
    { 1344, 392, -104},
    { 1368, 288, -192},
    // 62 seconds
    { 1432, 160, -152},
    { 1392, 304, -80},
    { 1288, 136, -144},
    { 1176, 144, -88},
    { 1088, 168, -88},
    { 928, -80, -96},
    { 792, -240, 128},
    { 832, -8, -352},
    { 1224, -96, -232},
    { 1280, 208, -296},
    { 1136, 32, -272},
    { 1016, 248, -328},
    { 1208, 336, -200},
    { 1584, 512, -256},
    { 1792, 728, -184},
    { 1544, 1000, -56},
    { 1272, 896, -176},
    { 904, 1088, 128},
    { 856, 1176, 144},
    { 1008, 968, 128},
    { 1176, 824, 64},
    { 1304, 744, 32},
    { 1528, 640, -40},
    { 1296, 408, -64},
    { 1280, 272, -168},
    // 63 seconds
    { 1408, 184, -88},
    { 1504, 336, -96},
    { 1472, 216, -128},
    { 1264, 152, -72},
    { 1200, 192, -128},
    { 968, 80, -160},
    { 552, -224, -56},
    { 616, -216, -144},
    { 784, 40, -296},
    { 1016, 208, -320},
    { 1224, 192, -336},
    { 1160, 192, -312},
    { 1152, 384, -288},
    { 1320, 368, -216},
    { 1560, 552, -320},
    { 1648, 792, -224},
    { 1296, 928, -296},
    { 968, 1120, -328},
    { 912, 1120, -208},
    { 1256, 1136, -144},
    { 1160, 800, -136},
    { 1216, 696, -176},
    { 1312, 728, -152},
    { 1240, 416, -104},
    { 1088, 280, -80},
    // 64 seconds
    { 1248, 120, -192},
    { 1232, 312, -24},
    { 1272, 208, -72},
    { 1384, 176, -128},
    { 1232, 152, -64},
    { 1056, 48, -144},
    { 640, -328, -32},
    { 728, -280, -88},
    { 968, 8, -248},
    { 1248, 128, -256},
    { 1312, 232, -240},
    { 1112, 128, -296},
    { 1000, 304, -312},
    { 1256, 360, -256},
    { 1640, 536, -344},
    { 1552, 808, -336},
    { 1112, 872, -424},
    { 1000, 1000, -488},
    { 856, 960, -304},
    { 1016, 1160, -344},
    { 1192, 832, -256},
    { 1384, 688, -232},
    { 1488, 624, -200},
    { 1296, 296, -136},
    { 1160, 296, -128},
    // 65 seconds
    { 1208, 208, -120},
    { 1264, 256, -88},
    { 1312, 224, -80},
    { 1344, 152, -56},
    { 1144, 136, -24},
    { 1056, 112, -120},
    { 656, -272, -24},
    { 704, -232, -128},
    { 1008, 0, -392},
    { 1304, 96, -296},
    { 1280, 112, -304},
    { 1120, 80, -296},
    { 1024, 272, -304},
    { 1192, 344, -248},
    { 1448, 472, -360},
    { 1600, 640, -376},
    { 1280, 904, -376},
    { 1152, 896, -488},
    { 888, 896, -344},
    { 1048, 1224, -256},
    { 1112, 800, -168},
    { 1256, 696, -152},
    { 1352, 640, -176},
    { 1360, 312, -120},
    { 1208, 360, -168},
    // 66 seconds
    { 1368, 288, -136},
    { 1416, 248, -112},
    { 1256, 192, -96},
    { 1224, 208, -120},
    { 1240, 192, -80},
    { 1032, 168, -96},
    { 824, -232, -56},
    { 752, -336, 120},
    { 1040, 16, -216},
    { 1344, -24, -184},
    { 1400, 240, -240},
    { 1328, 128, -248},
    { 1328, 376, -368},
    { 1424, 512, -280},
    { 1536, 824, -352},
    { 1504, 768, -248},
    { 1280, 776, -328},
    { 816, 968, -376},
    { 728, 1088, -296},
    { 960, 1184, -240},
    { 1128, 984, -208},
    { 1416, 912, -168},
    { 1776, 816, -96},
    { 1928, 552, -88},
    { 1560, 352, -96},
    // 67 seconds
    { 1448, 256, -80},
    { 1488, 344, -72},
    { 1496, 280, -56},
    { 1576, 200, 24},
    { 1368, 120, 16},
    { 1024, 120, -88},
    { 768, -408, -64},
    { 488, -704, 144},
    { 720, 16, -304},
    { 1208, -272, -208},
    { 1624, 288, -360},
    { 1432, 224, -288},
    { 1352, 304, -192},
    { 1608, 416, -184},
    { 1832, 600, -192},
    { 1792, 952, -192},
    { 1496, 1160, -248},
    { 784, 1408, -520},
    { 704, 1360, -352},
    { 952, 1312, -272},
    { 1384, 984, -192},
    { 1568, 776, -80},
    { 1592, 688, -80},
    { 1712, 480, -56},
    { 1448, 392, -16},
    // 68 seconds
    { 1464, 216, -32},
    { 1432, 344, 0},
    { 1456, 312, 56},
    { 1480, 216, 40},
    { 1360, 136, 88},
    { 1112, 128, 8},
    { 880, -72, -48},
    { 832, -96, -8},
    { 456, -128, -64},
    { 704, 16, -256},
    { 864, -16, -304},
    { 1176, 144, -288},
    { 1240, 104, -352},
    { 1360, 296, -400},
    { 1624, 424, -400},
    { 1904, 624, -616},
    { 1584, 808, -624},
    { 1152, 944, -856},
    { 592, 1232, -960},
    { 880, 1072, -696},
    { 1360, 936, -488},
    { 1448, 720, -320},
    { 1624, 656, -216},
    { 1808, 608, -152},
    { 1512, 368, -56},
    // 69 seconds
    { 1352, 248, -64},
    { 1432, 272, -72},
    { 1424, 232, -8},
    { 1360, 240, 32},
    { 1320, 208, -24},
    { 1248, 248, -56},
    { 1192, -16, -48},
    { 648, -456, 80},
    { 344, -528, -40},
    { 960, -112, -416},
    { 1384, -120, -192},
    { 1400, 112, -400},
    { 1400, 144, -384},
    { 1568, 320, -440},
    { 1736, 416, -448},
    { 1856, 584, -824},
    { 1504, 872, -952},
    { 1056, 696, -1040},
    { 720, 688, -976},
    { 936, 664, -712},
    { 1344, 920, -584},
    { 1480, 728, -352},
    { 1472, 608, -272},
    { 1560, 552, -240},
    { 1456, 304, -120},
    // 70 seconds
    { 1280, 184, -112},
    { 1280, 272, -152},
    { 1368, 256, -64},
    { 1352, 224, -24},
    { 1296, 192, 0},
    { 1088, 208, 0},
    { 1144, 168, -48},
    { 840, -392, 0},
    { 752, -536, 176},
    { 928, -88, -304},
    { 1224, -216, -216},
    { 1440, 208, -288},
    { 1392, 64, -304},
    { 1360, 264, -424},
    { 1440, 320, -344},
    { 1528, 456, -536},
    { 1544, 576, -720},
    { 1264, 576, -944},
    { 888, 496, -992},
    { 896, 440, -872},
    { 1112, 600, -736},
    { 1296, 800, -600},
    { 1432, 712, -400},
    { 1488, 520, -336},
    { 1656, 448, -248},
    // 71 seconds
    { 1480, 336, -112},
    { 1384, 192, -128},
    { 1424, 264, -112},
    { 1464, 240, -40},
    { 1448, 168, 0},
    { 1240, 152, 0},
    { 1144, 192, -16},
    { 824, -280, 32},
    { 680, -408, 64},
    { 552, 16, -168},
    { 1032, -40, -296},
    { 1248, 240, -272},
    { 1352, 64, -224},
    { 1400, 280, -352},
    { 1456, 336, -336},
    { 1544, 408, -368},
    { 1624, 664, -448},
    { 1576, 864, -432},
    { 1200, 880, -576},
    { 864, 1024, -496},
    { 1040, 1208, -312},
    { 1184, 848, -192},
    { 1216, 672, -240},
    { 1200, 648, -168},
    { 1344, 640, -168},
    // 72 seconds
    { 1392, 384, -104},
    { 1360, 160, -48},
    { 1312, 240, -96},
    { 1352, 264, -48},
    { 1432, 232, -16},
    { 1216, 128, 48},
    { 1176, 200, -48},
    { 1016, -232, 64},
    { 824, -272, 40},
    { 880, -280, 48},
    { 984, 64, -256},
    { 1232, 216, -168},
    { 1208, 168, -136},
    { 1216, 296, -240},
    { 1104, 440, -264},
    { 1296, 424, -216},
    { 1608, 560, -304},
    { 1504, 872, -328},
    { 1072, 896, -560},
    { 848, 1184, -576},
    { 1120, 1112, -368},
    { 1280, 808, -296},
    { 1248, 672, -248},
    { 1288, 624, -160},
    { 1328, 472, -136},
    // 73 seconds
    { 1208, 344, -96},
    { 1264, 120, -96},
    { 1232, 312, -64},
    { 1160, 232, -128},
    { 1472, 200, -72},
    { 1208, 120, 0},
    { 1088, 184, -88},
    { 632, -256, 56},
    { 696, 24, 0},
    { 656, 0, -136},
    { 976, 88, -280},
    { 1288, 200, -448},
    { 1192, 96, -320},
    { 992, 104, -360},
    { 944, 272, -320},
    { 1128, 320, -264},
    { 1384, 448, -296},
    { 1536, 592, -312},
    { 1400, 824, -384},
    { 1232, 896, -440},
    { 1080, 992, -496},
    { 1048, 1136, -352},
    { 1056, 952, -272},
    { 1104, 792, -160},
    { 1360, 720, -144},
    // 74 seconds
    { 1312, 584, 16},
    { 1304, 256, 88},
    { 1272, 264, 8},
    { 1440, 272, -8},
    { 1576, 200, -40},
    { 1488, 224, -112},
    { 1432, 256, -160},
    { 1152, 80, -120},
    { 1120, -152, 16},
    { 384, -424, -224},
    { 952, -184, -472},
    { 1072, -80, -256},
    { 1056, 96, -320},
    { 984, 248, -304},
    { 1080, 416, -304},
    { 1592, 352, 0},
    { 2024, 648, -16},
    { 1864, 1152, 192},
    { 1648, 736, -168},
    { 1328, 776, 0},
    { 856, 1456, 424},
    { 952, 1240, 328},
    { 920, 896, 112},
    { 960, 792, 0},
    { 1256, 848, -40},
    // 75 seconds
    { 1472, 528, -56},
    { 1432, 392, -24},
    { 1528, 256, -136},
    { 1488, 528, -24},
    { 1480, 328, 16},
    { 1304, 304, -32},
    { 1376, 168, -56},
    { 1080, -344, 56},
    { 968, -96, 232},
    { 728, -272, -224},
    { 1128, 144, -264},
    { 1280, 104, -184},
    { 1224, 176, -216},
    { 1120, 376, -360},
    { 1192, 392, -256},
    { 1432, 472, -248},
    { 1824, 664, -288},
    { 1480, 952, -224},
    { 1144, 824, -432},
    { 864, 1112, -328},
    { 904, 1136, -192},
    { 944, 976, -144},
    { 1136, 704, -208},
    { 1248, 672, -176},
    { 1576, 656, -120},
    // 76 seconds
    { 1440, 392, -96},
    { 1352, 232, -120},
    { 1368, 208, -120},
    { 1360, 384, -112},
    { 1368, 208, -40},
    { 1184, 184, -56},
    { 1208, 160, -120},
    { 816, -336, 40},
    { 968, -152, 24},
    { 600, -80, -184},
    { 1096, 32, -320},
    { 1240, 280, -320},
    { 1208, 136, -200},
    { 1120, 192, -264},
    { 1296, 400, -256},
    { 1576, 680, -264},
    { 1704, 728, -288},
    { 1416, 832, -256},
    { 1080, 1016, -464},
    { 744, 1296, -416},
    { 1016, 1416, -304},
    { 1224, 728, -176},
    { 1232, 728, -224},
    { 1336, 696, -136},
    { 1520, 560, -120},
    // 77 seconds
    { 1376, 360, -112},
    { 1352, 200, -104},
    { 1336, 288, -112},
    { 1376, 200, -168},
    { 1288, 184, -88},
    { 1168, 152, -128},
    { 1048, -64, -80},
    { 568, -248, -64},
    { 904, -144, -96},
    { 744, 96, -280},
    { 1072, 112, -336},
    { 1208, 224, -344},
    { 1208, 176, -240},
    { 1176, 272, -248},
    { 1416, 440, -192},
    { 1680, 632, -192},
    { 1664, 888, -112},
    { 1352, 752, -200},
    { 912, 896, -248},
    { 816, 1200, -160},
    { 944, 1240, -32},
    { 1216, 904, -40},
    { 1376, 816, -56},
    { 1288, 648, -72},
    { 1384, 736, -80},
    // 78 seconds
    { 1424, 464, -8},
    { 1408, 176, -80},
    { 1344, 280, -72},
    { 1400, 256, -56},
    { 1272, 208, -80},
    { 1256, 144, -24},
    { 1088, 176, -48},
    { 896, 192, -152},
    { 728, -264, -8},
    { 432, -200, -144},
    { 776, 88, -392},
    { 952, 24, -216},
    { 1312, 272, -344},
    { 1240, 184, -304},
    { 1216, 408, -272},
    { 1528, 432, -216},
    { 1696, 672, -240},
    { 1584, 888, -136},
    { 1232, 920, -248},
    { 784, 1240, -248},
    { 816, 1184, -32},
    { 1120, 1288, -96},
    { 1360, 856, -8},
    { 1360, 720, -16},
    { 1328, 728, -8},
    // 79 seconds
    { 1464, 592, -8},
    { 1416, 336, -48},
    { 1312, 232, -64},
    { 1352, 288, -96},
    { 1312, 256, -64},
    { 1392, 240, -104},
    { 1192, 152, -80},
    { 1056, 168, -128},
    { 632, -360, -8},
    { 656, -240, -32},
    { 664, -120, -128},
    { 1144, 40, -328},
    { 1344, 288, -376},
    { 1408, 240, -224},
    { 1352, 224, -312},
    { 1336, 448, -264},
    { 1512, 576, -288},
    { 1584, 808, -208},
    { 1504, 848, -216},
    { 984, 1120, -272},
    { 584, 1376, -208},
    { 848, 1104, -16},
    { 1120, 1096, 0},
    { 1240, 904, 48},
    { 1560, 728, 136},
    // 80 seconds
    { 1680, 640, 88},
    { 1712, 424, -16},
    { 1376, 320, -56},
    { 1304, 320, -88},
    { 1352, 296, -72},
    { 1312, 224, -88},
    { 1216, 192, -96},
    { 1240, 184, -120},
    { 912, -184, -88},
    { 488, -272, -128},
    { 856, -248, -272},
    { 712, 56, -296},
    { 1304, 152, -424},
    { 1424, 224, -360},
    { 1384, 200, -232},
    { 1336, 352, -264},
    { 1504, 464, -176},
    { 1648, 648, -128},
    { 1664, 752, -88},
    { 1480, 936, -88},
    { 1048, 1128, -184},
    { 736, 1320, -192},
    { 864, 1272, -104},
    { 1112, 960, -96},
    { 1064, 728, -88},
    // 81 seconds
    { 1256, 760, -8},
    { 1736, 744, -8},
    { 1824, 424, 8},
    { 1584, 256, -72},
    { 1480, 112, -88},
    { 1376, 152, -40},
    { 1272, 304, -40},
    { 1248, 272, -152},
    { 1240, 264, -224},
    { 800, -192, -192},
    { 696, -144, -216},
    { 640, -104, -192},
    { 712, 192, -280},
    { 1000, 208, -256},
    { 1256, 312, -240},
    { 1312, 312, -184},
    { 1312, 656, -200},
    { 1448, 584, -176},
    { 1616, 696, -200},
    { 1688, 608, -232},
    { 1448, 832, -352},
    { 1128, 1160, -464},
    { 880, 1624, -440},
    { 1104, 1064, -344},
    { 976, 944, -288},
    // 82 seconds
    { 1040, 816, -192},
    { 1480, 720, -184},
    { 1512, 408, -104},
    { 1488, 264, -120},
    { 1496, 272, -128},
    { 1560, 264, -104},
    { 1672, 256, -40},
    { 1456, 200, -32},
    { 1464, 184, -72},
    { 800, -408, -16},
    { 736, -376, -32},
    { 624, -200, -112},
    { 1112, 0, -280},
    { 1248, 192, -320},
    { 1272, 160, -304},
    { 1256, 216, -432},
    { 1296, 360, -360},
    { 1568, 456, -368},
    { 1672, 840, -360},
    { 1472, 856, -360},
    { 1096, 936, -480},
    { 944, 1096, -408},
    { 968, 1192, -472},
    { 960, 832, -312},
    { 1152, 720, -272},
    // 83 seconds
    { 1368, 656, -232},
    { 1456, 464, -232},
    { 1360, 320, -152},
    { 1296, 208, -192},
    { 1264, 256, -152},
    { 1352, 232, -176},
    { 1320, 176, -128},
    { 1192, 160, -112},
    { 952, -136, -8},
    { 504, -256, -96},
    { 888, -224, -32},
    { 1024, 32, -224},
    { 1168, 56, -328},
    { 1248, 216, -360},
    { 1096, 168, -288},
    { 1040, 256, -272},
    { 1312, 344, -216},
    { 1656, 560, -248},
    { 1528, 856, -248},
    { 1152, 840, -344},
    { 920, 1080, -448},
    { 832, 1072, -344},
    { 1192, 1096, -272},
    { 1232, 728, -208},
    { 1240, 632, -232},
    // 84 seconds
    { 1368, 616, -256},
    { 1320, 488, -144},
    { 1256, 264, -144},
    { 1224, 104, -144},
    { 1248, 264, -144},
    { 1352, 200, -120},
    { 1336, 168, -88},
    { 976, 128, -80},
    { 984, -72, -48},
    { 472, -296, 24},
    { 928, -216, 88},
    { 784, 136, -256},
    { 1256, 208, -280},
    { 1504, 256, -288},
    { 1392, 128, -272},
    { 1152, 288, -344},
    { 1160, 352, -272},
    { 1344, 496, -280},
    { 1440, 608, -296},
    { 1360, 792, -352},
    { 928, 1032, -512},
    { 824, 952, -440},
    { 1088, 1024, -296},
    { 1248, 712, -160},
    { 1256, 672, -160},
    // 85 seconds
    { 1264, 616, -168},
    { 1416, 560, -200},
    { 1280, 288, -120},
    { 1232, 288, -128},
    { 1240, 160, -112},
    { 1264, 168, -128},
    { 1256, 168, -112},
    { 1224, 144, -88},
    { 1080, 112, -128},
    { 776, -256, -24},
    { 896, -240, 0},
    { 720, -56, -216},
    { 1168, 72, -328},
    { 1352, 272, -376},
    { 1232, 104, -216},
    { 1104, 216, -288},
    { 1200, 352, -264},
    { 1472, 544, -192},
    { 1584, 712, -272},
    { 1344, 848, -256},
    { 1032, 816, -472},
    { 768, 944, -456},
    { 928, 944, -272},
    { 1256, 968, -264},
    { 1192, 616, -256},
    // 86 seconds
    { 1320, 648, -192},
    { 1512, 752, -176},
    { 1424, 424, -112},
    { 1208, 152, -72},
    { 1112, 144, -136},
    { 1168, 248, -112},
    { 1288, 224, -112},
    { 1352, 128, -32},
    { 1152, 128, -40},
    { 1096, 72, -136},
    { 792, -336, 72},
    { 680, -256, -112},
    { 1144, 160, -328},
    { 1368, 64, -288},
    { 1240, 72, -280},
    { 1008, 80, -288},
    { 1008, 328, -336},
    { 1408, -344, -928},
    { 1688, 1328, -456},
    { 1752, 808, -208},
    { 1120, 1168, -96},
    { 1120, 752, -304},
    { 816, 1008, 8},
    { 1144, 1088, -24},
    { 1024, 800, -96},
    // 87 seconds
    { 1176, 616, -128},
    { 1344, 680, -128},
    { 1232, 400, -136},
    { 1088, 312, -136},
    { 1104, 296, -128},
    { 1280, 280, -144},
    { 1432, 184, -144},
    { 1328, 96, -128},
    { 1304, 200, -208},
    { 936, -168, -136},
    { 856, -192, -120},
    { 768, -72, -232},
    { 744, 168, -448},
    { 1192, 32, -440},
    { 1128, 144, -320},
    { 944, 160, -312},
    { 888, 344, -384},
    { 1024, 304, -216},
    { 1440, 408, -240},
    { 1632, 616, -248},
    { 1248, 848, -280},
    { 1008, 928, -432},
    { 888, 896, -360},
    { 1232, 1056, -320},
    { 1104, 792, -224},
    // 88 seconds
    { 1104, 696, -224},
    { 1120, 736, -272},
    { 1200, 448, -224},
    { 1088, 328, -184},
    { 1104, 168, -152},
    { 1160, 224, -152},
    { 1328, 264, -208},
    { 1352, 136, -104},
    { 1192, 112, -88},
    { 1224, 168, -120},
    { 784, -208, -56},
    { 1208, -256, -40},
    { 640, -88, -176},
    { 1136, 72, -408},
    { 1240, 96, -384},
    { 1080, 64, -280},
    { 952, 192, -384},
    { 1056, 344, -344},
    { 1280, 392, -328},
    { 1584, 624, -448},
    { 1288, 1056, -432},
    { 1024, 808, -544},
    { 624, 816, -472},
    { 912, 936, -408},
    { 1064, 864, -368},
    // 89 seconds
    { 1096, 768, -232},
    { 1368, 800, -184},
    { 1680, 632, -152},
    { 1760, 464, -168},
    { 1256, 240, -104},
    { 1064, 128, -128},
    { 1152, 256, -176},
    { 1240, 216, -168},
    { 1256, 144, -128},
    { 1120, 144, -112},
    { 864, -96, -48},
    { 400, -224, -120},
    { 792, -104, -184},
    { 544, 40, -328},
    { 1048, 112, -456},
    { 1488, 176, -536},
    { 1448, 176, -408},
    { 1088, 240, -392},
    { 1136, 296, -328},
    { 1248, 432, -304},
    { 1400, 528, -296},
    { 1224, 640, -344},
    { 952, 928, -440},
    { 784, 1016, -488},
    { 800, 920, -368},
    // 90 seconds
    { 1224, 1120, -240},
    { 1328, 776, -176},
    { 1416, 832, -136},
    { 1600, 1080, -176},
    { 1720, 856, -72},
    { 1744, 1232, -168},
    { 1760, 1024, -176},
    { 1544, 944, -320},
    { 1184, 896, -216},
    { 880, 416, -240},
    { 648, 248, -248},
    { 440, -80, -248},
    { 368, -248, -312},
    { 392, -496, -144},
    { 248, -336, -136},
    { 448, -136, -304},
    { 632, 0, -488},
    { 792, 56, -808},
    { 816, 192, -888},
    { 808, 376, -1008},
    { 920, 576, -1168},
    { 904, 800, -1328},
    { 600, 880, -1448},
    { 0, 1184, -1472},
    { -312, 1168, -1608},
    // 91 seconds
    { -24, 944, -1400},
    { 96, 1376, -1608},
    { 608, 1024, -1296},
    { 536, 936, -1096},
    { 664, 1128, -1128},
    { 920, 952, -1008},
    { 856, 768, -792},
    { 680, 584, -640},
    { 568, 408, -504},
    { 432, 288, -424},
    { 424, 216, -400},
    { 488, 136, -408},
    { 552, -24, -336},
    { 488, -216, -256},
    { 688, -136, -336},
    { 680, -16, -352},
    { 1088, 200, -480},
    { 1576, 280, -616},
    { 1888, 496, -616},
    { 1720, 432, -536},
    { 1472, 520, -496},
    { 1504, 640, -344},
    { 1456, 512, -336},
    { 1304, 664, -280},
    { 1080, 848, -296},
    // 92 seconds
    { 776, 1144, -480},
    { 752, 1088, -392},
    { 1144, 1096, -408},
    { 1072, 672, -312},
    { 1208, 720, -264},
    { 1392, 592, -256},
    { 1560, 448, -288},
    { 1512, 304, -184},
    { 1504, 80, -232},
    { 1488, 280, -184},
    { 1416, 136, -144},
    { 1224, 176, -136},
    { 1136, 232, -160},
    { 1048, 56, -168},
    { 760, -312, -48},
    { 680, -184, -184},
    { 688, 184, -496},
    { 1064, 136, -432},
    { 1104, 32, -368},
    { 1024, 152, -368},
    { 984, 264, -336},
    { 1232, 240, -288},
    { 1584, 400, -256},
    { 1904, 608, -368},
    { 1496, 1000, -368},
    // 93 seconds
    { 1152, 984, -472},
    { 944, 848, -376},
    { 1064, 1248, -240},
    { 896, 920, -216},
    { 928, 712, -272},
    { 1016, 736, -232},
    { 1280, 560, -248},
    { 1192, 440, -208},
    { 1336, 304, -200},
    { 1440, 208, -160},
    { 1408, 208, -192},
    { 1400, 152, -184},
    { 1200, 152, -144},
    { 1232, 176, -144},
    { 896, -168, -48},
    { 784, -360, 64},
    { 744, -64, -216},
    { 1120, 80, -336},
    { 1248, 88, -240},
    { 1144, 200, -280},
    { 1048, 288, -400},
    { 1128, 336, -336},
    { 1392, 448, -344},
    { 1576, 760, -424},
    { 1288, 776, -368},
    // 94 seconds
    { 976, 880, -528},
    { 848, 832, -480},
    { 832, 912, -392},
    { 1016, 992, -440},
    { 1024, 800, -384},
    { 1200, 632, -280},
    { 1584, 616, -304},
    { 1408, 328, -216},
    { 1264, 240, -216},
    { 1304, 224, -216},
    { 1336, 216, -224},
    { 1304, 168, -224},
    { 1256, 136, -208},
    { 1064, 128, -248},
    { 584, -256, -120},
    { 776, -208, -160},
    { 680, 0, -232},
    { 824, 104, -440},
    { 1072, 152, -464},
    { 1176, 176, -344},
    { 1120, 184, -376},
    { 1168, 408, -344},
    { 1376, 448, -280},
    { 1496, 632, -296},
    { 1296, 944, -432},
    // 95 seconds
    { 1040, 608, -368},
    { 936, 952, -464},
    { 760, 960, -496},
    { 1048, 1176, -496},
    { 1256, 896, -376},
    { 1336, 720, -264},
    { 1528, 584, -320},
    { 1256, 360, -272},
    { 1104, 288, -240},
    { 1232, 240, -224},
    { 1352, 256, -240},
    { 1256, 184, -192},
    { 1192, 152, -160},
    { 1128, 176, -168},
    { 840, 64, -176},
    { 664, -176, -136},
    { 608, -176, -176},
    { 808, 112, -400},
    { 984, 96, -432},
    { 1176, 176, -400},
    { 1192, 200, -408},
    { 1080, 304, -336},
    { 1272, 352, -296},
    { 1400, 608, -400},
    { 1384, 768, -384},
    // 96 seconds
    { 1048, 728, -368},
    { 680, 1112, -504},
    { 928, 1112, -328},
    { 1192, 1136, -320},
    { 1520, 912, -224},
    { 1288, 760, -192},
    { 1288, 616, -192},
    { 1504, 496, -184},
    { 1280, 344, -144},
    { 1080, 184, -120},
    { 1120, 272, -168},
    { 1240, 184, -136},
    { 1432, 208, -176},
    { 1232, 136, -120},
    { 1112, 208, -208},
    { 768, -96, -120},
    { 584, -200, -168},
    { 416, -104, -296},
    { 600, -24, -312},
    { 984, 248, -488},
    { 1296, 104, -376},
    { 1320, 248, -376},
    { 1248, 400, -336},
    { 1424, 392, -288},
    { 1552, 584, -320},
    // 97 seconds
    { 1392, 768, -264},
    { 1096, 888, -288},
    { 880, 1184, -320},
    { 952, 1120, -240},
    { 1152, 1056, -128},
    { 1016, 872, -112},
    { 1152, 720, -96},
    { 1352, 632, -136},
    { 1256, 440, -120},
    { 1152, 328, -128},
    { 1200, 176, -144},
    { 1240, 240, -152},
    { 1336, 192, -152},
    { 1376, 192, -176},
    { 1360, 128, -152},
    { 896, -160, -96},
    { 800, -296, -232},
    { 664, -144, -112},
    { 696, 40, -336},
    { 808, 160, -392},
    { 1056, 160, -208},
    { 1160, 288, -304},
    { 1256, 400, -280},
    { 1568, 512, -304},
    { 1512, 736, -344},
    // 98 seconds
    { 1136, 680, -320},
    { 856, 904, -520},
    { 784, 1040, -480},
    { 936, 984, -432},
    { 1272, 904, -312},
    { 1280, 752, -224},
    { 1304, 624, -176},
    { 1368, 528, -232},
    { 1136, 352, -144},
    { 1080, 184, -80},
    { 1144, 232, -144},
    { 1208, 272, -120},
    { 1416, 168, -136},
    { 1184, 120, -104},
    { 1264, 224, -184},
    { 880, -128, -120},
    { 768, -328, -16},
    { 472, -152, -192},
    { 968, 120, -376},
    { 1216, 176, -312},
    { 1192, 136, -216},
    { 1072, 296, -352},
    { 1032, 344, -272},
    { 1336, 440, -288},
    { 1672, 552, -368},
    // 99 seconds
    { 1384, 832, -376},
    { 1096, 904, -536},
    { 984, 968, -552},
    { 1032, 944, -392},
    { 1072, 888, -272},
    { 976, 680, -264},
    { 1008, 616, -232},
    { 1192, 584, -232},
    { 1136, 344, -128},
    { 1200, 280, -136},
    { 1264, 224, -104},
    { 1280, 224, -120},
    { 1344, 144, -144},
    { 1280, 152, -144},
    { 1296, 240, -208},
    { 1072, -16, -208},
    { 704, -392, -32},
    { 696, -272, -104},
    { 920, 144, -392},
    { 1168, 112, -360},
    { 1168, 136, -272},
    { 1064, 168, -320},
    { 976, 320, -336},
    { 1160, 336, -296},
    { 1464, 552, -360},
    // 100 seconds
    { 1544, 832, -400},
    { 1216, 520, -424},
    { 960, 800, -560},
    { 1024, 904, -456},
    { 1200, 1064, -400},
    { 1072, 824, -392},
    { 1104, 656, -288},
    { 1328, 680, -296},
    { 1304, 400, -232},
    { 1240, 376, -208},
    { 1272, 280, -184},
    { 1280, 304, -168},
    { 1240, 256, -152},
    { 1232, 176, -152},
    { 1208, 160, -152},
    { 1000, 24, -128},
    { 640, -224, -96},
    { 888, -184, -120},
    { 544, 88, -216},
    { 1016, 104, -360},
    { 1168, 152, -296},
    { 1264, 96, -328},
    { 1336, 320, -400},
    { 1512, 392, -296},
    { 1648, 664, -352},
    // 101 seconds
    { 1240, 896, -272},
    { 896, 808, -360},
    { 432, 896, -280},
    { 728, 864, -272},
    { 1088, 1016, -240},
    { 1672, 1136, -240},
    { 2072, 640, -152},
    { 1856, 608, -224},
    { 1408, 520, -160},
    { 1392, 416, 120},
    { 1680, 424, 640},
    { 1912, 360, 1144},
    { 1576, 256, 1240},
    { 1448, 344, 1048},
    { 1312, 336, 728},
    { 1088, 328, 496},
    { 912, 448, 296},
    { 784, 536, 312},
    { 792, 576, 128},
    { 768, 608, 144},
    { 736, 728, -88},
    { 640, 568, -184},
    { 624, 704, -320},
    { 512, 752, -368},
    { 560, 840, -360},
    // 102 seconds
    { 488, 792, -240},
    { 560, 824, -104},
    { 768, 920, -24},
    { 960, 768, 184},
    { 984, 824, 120},
    { 880, 704, 104},
    { 768, 576, 184},
    { 720, 632, 224},
    { 840, 656, 176},
    { 904, 704, 216},
    { 848, 552, 352},
    { 816, 720, 384},
    { 752, 400, 496},
    { 624, 536, 360},
    { 632, 608, 432},
    { 488, 616, 448},
    { 472, 704, 432},
    { 368, 816, 344},
    { 256, 872, 440},
    { 144, 912, 304},
    { 200, 648, 360},
    { 272, 880, 280},
    { 376, 744, 272},
    { 320, 824, 176},
    { 216, 720, 104},
    // 103 seconds
    { 144, 808, 48},
    { 112, 1240, 0},
    { 64, 1328, -8},
    { 80, 976, -128},
    { 192, 808, -568},
    { 248, 760, -528},
    { 240, 368, -576},
    { 328, 472, -840},
    { 336, 368, -1000},
    { 264, 296, -920},
    { 168, 224, -864},
    { 152, 224, -872},
    { 128, 264, -920},
    { 160, 184, -960},
    { 88, 288, -928},
    { 72, 272, -952},
    { 72, 320, -984},
    { 136, 248, -968},
    { 168, 256, -1008},
    { 168, 192, -952},
    { 192, 280, -1024},
    { 104, 160, -976},
    { 176, 200, -944},
    { 328, 160, -880},
    { 456, 304, -632},
    // 104 seconds
    { 392, 728, -496},
    { 168, 1112, -416},
    { 96, 952, -368},
    { -40, 960, -424},
    { -168, 872, -360},
    { -80, 632, -480},
    { 8, 312, -1032},
    { -104, 880, -536},
    { 32, 520, -344},
    { 80, 1080, -640},
    { 144, 1016, -600},
    { 232, 760, -456},
    { 424, 576, -792},
    { 424, 520, -816},
    { 416, 312, -976},
    { 320, 416, -936},
    { 232, 408, -944},
    { 232, 448, -920},
    { 208, 456, -872},
    { 192, 464, -824},
    { 216, 424, -832},
    { 240, 504, -808},
    { 248, 424, -848},
    { 232, 456, -808},
    { 200, 472, -808},
    // 105 seconds
    { 208, 496, -824},
    { 200, 432, -848},
    { 184, 464, -864},
    { 192, 424, -896},
    { 208, 376, -920},
    { 184, 416, -864},
    { 168, 440, -832},
    { 160, 440, -808},
    { 160, 488, -864},
    { 160, 496, -856},
    { 144, 496, -840},
    { 144, 504, -840},
    { 144, 504, -856},
    { 136, 480, -840},
    { 144, 464, -840},
    { 144, 488, -848},
    { 144, 496, -856},
    { 136, 488, -848},
    { 120, 488, -856},
    { 112, 512, -912},
    { 88, 504, -960},
    { 64, 440, -952},
    { 24, 384, -944},
    { 72, 368, -1000},
    { 120, 424, -984},
    // 106 seconds
    { 144, 472, -920},
    { 144, 392, -968},
    { 216, 392, -976},
    { 208, 296, -880},
    { 208, 280, -872},
    { 232, 264, -808},
    { 224, 192, -776},
    { 112, 160, -792},
    { 352, 168, -864},
    { 80, 408, -968},
    { 96, 456, -984},
    { 184, 208, -960},
    { -120, 328, -1008},
    { 192, 248, -968},
    { 24, 512, -896},
    { -2040, 1256, -4000},
    { -304, 720, -184},
    { -360, 264, -1152},
    { 152, 280, -992},
    { 104, 232, -960},
    { 112, 360, -1008},
    { 120, 272, -960},
    { 136, 296, -968},
    { 136, 288, -936},
    { 112, 272, -920},
    // 107 seconds
    { 104, 264, -928},
    { 88, 280, -936},
    { 96, 296, -960},
    { 96, 312, -976},
    { 96, 296, -960},
    { 96, 288, -960},
    { 104, 272, -952},
    { 104, 288, -944},
    { 104, 288, -952},
    { 96, 288, -952},
    { 96, 304, -944},
    { 104, 304, -952},
    { 96, 312, -944},
    { 96, 320, -936},
    { 80, 312, -944},
    { 80, 320, -936},
    { 80, 328, -944},
    { 88, 328, -944},
    { 88, 336, -960},
    { 80, 336, -960},
    { 80, 336, -968},
    { 72, 336, -968},
    { 72, 336, -952},
    { 72, 328, -944},
    { 72, 328, -944},
    // 108 seconds
    { 64, 328, -928},
    { 72, 328, -928},
    { 80, 328, -928},
    { 72, 328, -912},
    { 72, 328, -920},
    { 80, 344, -944},
    { 72, 328, -944},
    { 72, 336, -952},
    { 64, 328, -952},
    { 64, 320, -936},
    { 64, 320, -936},
    { 64, 320, -936},
    { 72, 328, -936},
    { 88, 328, -952},
    { 80, 320, -936},
    { 96, 336, -936},
    { 56, 344, -936},
    { 32, 336, -920},
    { 40, 336, -944},
    { 56, 344, -960},
    { 64, 328, -952},
    { 64, 320, -960},
    { 72, 312, -968},
    { 80, 320, -976},
    { 72, 296, -968},
    // 109 seconds
    { 72, 296, -960},
    { 64, 288, -944},
    { 56, 296, -928},
    { 56, 304, -920},
    { 48, 328, -920},
    { 48, 336, -928},
    { 32, 344, -936},
    { 16, 344, -968},
    { 24, 336, -984},
    { 32, 344, -984},
    { 24, 328, -992},
    { 48, 320, -984},
    { 48, 320, -952},
    { 8, 312, -896},
    { -8, 336, -904},
    { -16, 352, -904},
    { -24, 368, -896},
    { -32, 392, -928},
    { -32, 384, -936},
    { -16, 392, -976},
    { -16, 376, -968},
    { -16, 336, -960},
    { -16, 336, -944},
    { 112, 144, -800},
    { -8, 344, -976},
    // 110 seconds
    { 16, 360, -960},
    { -16, 352, -968},
    { -80, 264, -920},
    { -32, 272, -976},
    { -16, 296, -968},
    { 0, 272, -944},
    { -64, 328, -928},
    { 16, 368, -976},
    { -16, 400, -968},
    { -16, 272, -960},
    { 200, 96, -920},
    { -64, 296, -984},
    { 24, 264, -1000},
    { 56, 152, -944},
    { -80, 344, -960},
    { 24, 312, -952},
    { 88, 296, -960},
    { 8, 352, -960},
    { 32, 304, -960},
    { -16, 288, -968},
    { 24, 280, -960},
    { 40, 304, -976},
    { 8, 320, -976},
    { 152, 352, -912},
    { -48, 312, -856},
    // 111 seconds
    { -48, 304, -872},
    { 32, 296, -920},
    { 72, 296, -968},
    { 72, 304, -976},
    { 72, 272, -992},
    { 56, 256, -968},
    { 40, 304, -968},
    { 24, 320, -968},
    { 40, 328, -944},
    { 72, 328, -920},
    { 96, 328, -912},
    { 88, 336, -920},
    { 104, 336, -912},
    { 104, 344, -904},
    { 88, 344, -928},
    { 48, 328, -904},
    { 32, 360, -888},
    { 64, 344, -880},
    { 64, 440, -1024},
    { 88, 384, -952},
    { 72, 336, -944},
    { 48, 376, -984},
    { 32, 376, -992},
    { 16, 376, -952},
    { 16, 384, -952},
    // 112 seconds
    { 8, 360, -936},
    { -24, 352, -888},
    { 24, 360, -920},
    { 64, 328, -992},
    { 72, 360, -984},
    { 48, 336, -904},
    { 48, 392, -896},
    { 32, 392, -928},
    { 8, 416, -976},
    { -8, 400, -952},
    { -24, 384, -920},
    { 8, 384, -928},
    { 8, 376, -944},
    { 8, 368, -928},
    { 24, 360, -936},
    { 24, 344, -920},
    { 16, 368, -928},
    { 8, 392, -936},
    { 0, 384, -928},
    { 16, 376, -960},
    { 24, 368, -944},
    { 40, 376, -944},
    { 24, 352, -904},
    { 24, 360, -912},
    { 16, 376, -936},
    // 113 seconds
    { 32, 360, -920},
    { 32, 352, -912},
    { 24, 360, -920},
    { 24, 368, -920},
    { 16, 368, -928},
    { 8, 360, -952},
    { 8, 360, -952},
    { 8, 360, -936},
    { 16, 352, -928},
    { 24, 360, -928},
    { 24, 368, -928},
    { 16, 368, -920},
    { 24, 368, -920},
    { 16, 376, -928},
    { 16, 368, -912},
    { 16, 384, -920},
    { 16, 368, -936},
    { 8, 368, -936},
    { 8, 368, -928},
    { 16, 384, -936},
    { 8, 376, -936},
    { 8, 392, -944},
    { 16, 376, -936},
    { 16, 368, -920},
    { 8, 376, -912},
    // 114 seconds
    { 8, 384, -920},
    { 16, 384, -912},
    { 16, 376, -920},
    { 16, 376, -920},
    { 8, 376, -920},
    { 8, 368, -928},
    { 8, 368, -936},
    { 8, 384, -920},
    { 16, 384, -928},
    { 8, 376, -920},
    { 16, 368, -928},
    { 8, 384, -928},
    { 8, 384, -920},
    { 0, 384, -928},
    { -8, 384, -928},
    { 0, 392, -928},
    { 0, 384, -944},
    { 0, 392, -936},
    { 0, 384, -928},
    { 0, 384, -920},
    { 0, 384, -928},
    { 8, 384, -912},
    { 0, 400, -920},
    { 8, 384, -928},
    { 0, 392, -920},
    // 115 seconds
    { 16, 408, -912},
    { 8, 416, -912},
    { 16, 456, -968},
    { 64, 472, -968},
    { 128, 512, -960},
    { 208, 496, -920},
    { 288, 408, -896},
    { 360, 720, -856},
    { 256, 712, -776},
    { 280, 872, -728},
    { 128, 1064, -480},
    { 112, 1064, -296},
    { 96, 1152, -120},
    { 128, 1328, 96},
    { 240, 1304, 72},
    { 184, 808, 208},
    { 24, 280, 488},
    { -176, 768, 328},
    { -168, 624, 624},
    { -208, 640, 384},
    { -64, 464, 296},
    { 0, 584, 456},
    { 72, 584, 632},
    { 136, 592, 552},
    { 120, 664, 552},
    // 116 seconds
    { 88, 848, 480},
    { 88, 848, 520},
    { 48, 960, 488},
    { 32, 880, 336},
    { -48, 960, 368},
    { -176, 608, 168},
    { -216, 1184, 224},
    { -112, 1048, 464},
    { -176, 872, 496},
    { -224, 688, 408},
    { -304, 784, 368},
    { -424, 1056, 80},
    { -104, 1168, 752},
    { 48, 832, 456},
    { -136, 704, -112},
    { -216, 648, 136},
    { -408, 896, 344},
    { -312, 640, 408},
    { 24, 752, 344},
    { 72, 1088, 160},
    { 72, 1000, 312},
    { 240, 1592, 288},
    { 168, 1264, -696},
    { -56, 1216, -584},
    { 224, 952, -272},
    // 117 seconds
    { 224, 1000, -16},
    { -200, 984, 24},
    { 64, 384, 720},
    { -64, 952, 120},
    { 64, 816, 264},
    { -120, 768, 352},
    { -16, 48, 304},
    { 72, -200, 312},
    { 288, 384, 488},
    { 336, 824, 592},
    { 1000, 864, 208},
    { 1392, 1560, 456},
    { 1048, 1152, 360},
    { 608, 944, 144},
    { 512, 920, 64},
    { 672, 832, 80},
    { 776, 704, 184},
    { 560, 464, 240},
    { 512, 760, 384},
    { 616, 1200, 184},
    { 496, 600, -24},
    { 488, 480, -16},
    { 512, 1024, -136},
    { 432, 576, -104},
    { 480, 520, -184},
    // 118 seconds
    { 408, 560, -120},
    { 432, 616, -160},
    { 408, 680, -48},
    { 360, 840, 152},
    { 352, 1192, 96},
    { 288, 864, 456},
    { 464, 928, 80},
    { 488, 688, 312},
    { 328, 528, -344},
    { 456, 504, -856},
    { 752, 1032, -80},
    { 848, 992, -96},
    { 888, 944, -48},
    { 816, 992, -168},
    { 264, 1144, 80},
    { 256, 560, -128},
    { 48, 360, 72},
    { 272, 1368, 32},
    { 336, 1136, -144},
    { 568, 1360, -128},
    { 944, 1560, -248},
    { 1104, 1640, -208},
    { 952, 1064, 136},
    { 472, 216, 576},
    { 72, -312, 232},
    // 119 seconds
    { 32, -96, -200},
    { -16, -440, 392},
    { 232, 688, 848},
    { 328, 1216, 328},
    { 320, 552, -184},
    { 816, 888, -24},
    { 520, 1104, -40},
    { 864, 1064, -776},
    { 336, -336, -224},
    { 1064, -960, -656},
    { 896, -928, -512},
    { 1072, -1144, -392},
    { 1064, -936, -544},
    { 1024, -456, -880},
    { 704, -152, -832},
    { 976, 48, -1216},
    { 288, 80, -216},
    { 272, -608, 352},
    { 656, -1472, 408},
    { 848, -776, -168},
    { 312, -912, -304},
    { 792, -584, -272},
    { 672, -520, -336},
    { 544, -576, -240},
    { 720, -376, -224},
    // 120 seconds
    // elapsed: 2 minutes
    { 552, -552, -336},
    { 568, -408, -352},
    { 632, -720, -320},
    { 656, -672, -384},
    { 784, -920, -176},
    { 768, -912, 288},
    { -304, -888, 464},
    { 1104, -256, 112},
    { 624, -752, 248},
    { 1024, -80, 448},
    { 784, -720, 736},
    { 992, -248, 568},
    { 560, -368, 736},
    { 648, 256, 704},
    { 456, 64, 576},
    { 464, -248, 760},
    { 808, 544, 600},
    { 568, -96, 664},
    { 672, 456, 416},
    { 440, -16, 672},
    { 600, 144, 432},
    { 792, 184, 416},
    { 920, -56, 320},
    { 1256, -120, 760},
    { 656, -80, 872},
    // 121 seconds
    { 592, -128, 576},
    { 680, -208, 416},
    { 920, -240, 376},
    { 952, -216, 312},
    { 824, -864, -176},
    { 472, -56, 416},
    { 848, -880, 208},
    { 672, -608, 72},
    { 1040, -720, -144},
    { 752, -840, -48},
    { 792, -800, 80},
    { 768, -736, -72},
    { 752, -648, 152},
    { 728, -496, 1096},
    { 952, -544, -8},
    { 504, -856, -952},
    { 728, -904, 256},
    { 800, -648, 520},
    { 624, -400, 648},
    { 504, -456, 784},
    { 720, -216, 776},
    { 448, -584, 512},
    { 640, -320, 680},
    { 1080, 576, 824},
    { 752, -520, 528},
    // 122 seconds
    { 536, -168, 1160},
    { 640, -184, 912},
    { 592, 184, 920},
    { 408, 248, 720},
    { 520, 176, 568},
    { 560, 448, 432},
    { 464, 568, 408},
    { 696, 448, 440},
    { 760, 152, 1080},
    { 856, 120, 1144},
    { 616, 424, 848},
    { 512, 904, 728},
    { 504, -256, 592},
    { 360, -16, 352},
    { 608, 48, 368},
    { 888, -496, 360},
    { 752, -120, 600},
    { 712, -456, 80},
    { 872, -152, 1248},
    { 760, -400, 1448},
    { 232, -440, 920},
    { 432, -648, 504},
    { 1120, -648, -416},
    { 848, -192, -152},
    { 856, -768, 312},
    // 123 seconds
    { 840, -568, 600},
    { 680, -504, 960},
    { 1168, -264, 712},
    { 1088, -608, 584},
    { 888, -552, -16},
    { 832, -512, -360},
    { 856, -776, -232},
    { 648, 576, -576},
    { 808, 1648, 448},
    { 960, 2168, 1432},
    { 1096, 1048, 1384},
    { 656, 1760, 1200},
    { 800, 1744, 1176},
    { 680, 1304, 1240},
    { 1240, 872, 216},
    { 1000, 968, -144},
    { 1352, 848, -672},
    { 840, 552, -456},
    { 856, 856, -1136},
    { 104, -72, -488},
    { -152, 1224, -424},
    { -272, 976, -328},
    { -272, 832, -264},
    { -200, 744, -632},
    { -16, 544, -248},
    // 124 seconds
    { -144, 592, -728},
    { -8, 1168, -200},
    { 408, 1048, -496},
    { 48, 888, -320},
    { 120, 608, 72},
    { 160, 1360, -816},
    { -256, 80, -608},
    { 664, 24, -480},
    { 488, 2736, -536},
    { 88, 2040, 200},
    { -344, 1544, 240},
    { 104, 1032, 24},
    { 136, -288, -256},
    { -120, 1016, -432},
    { 112, 1064, -568},
    { 240, 336, -576},
    { 272, 856, -1088},
    { 248, 600, -1192},
    { 8, 272, -864},
    { -144, 480, -752},
    { -104, 856, -512},
    { -200, 1280, -152},
    { -248, 1216, -32},
    { -296, 736, 88},
    { -248, 1008, -168},
    // 125 seconds
    { -224, 672, 32},
    { -336, 1000, -216},
    { -280, 848, -368},
    { -248, 832, -352},
    { -32, 904, -632},
    { 80, 720, -608},
    { 152, 192, -952},
    { -216, 568, -288},
    { -40, 616, -480},
    { -128, 568, -248},
    { -144, 1032, -224},
    { -256, 824, -208},
    { -264, 720, -232},
    { -200, 664, -192},
    { -240, 744, 0},
    { -24, 1328, 224},
    { 168, 1400, 528},
    { 376, 1528, 616},
    { 320, 1360, 648},
    { 128, 960, 696},
    { 0, 736, 696},
    { -128, 376, 560},
    { -264, 24, 680},
    { -104, 144, 496},
    { -184, 24, 704},
    // 126 seconds
    { -112, 264, 416},
    { -432, 160, 792},
    { -496, 272, 1144},
    { -288, 176, 712},
    { -496, 280, 920},
    { -336, 608, 1024},
    { -224, 544, 816},
    { 1432, 320, 400},
    { -384, 280, 712},
    { -280, 176, 552},
    { -568, 936, 448},
    { 656, 328, 824},
    { -32, 392, 912},
    { 8, 592, 856},
    { -280, 832, 680},
    { 64, 1328, 248},
    { -120, 1304, 464},
    { 352, 936, -688},
    { 360, 656, -872},
    { 240, 792, -720},
    { 368, 600, -848},
    { 296, 408, -848},
    { 344, 480, -832},
    { 312, 384, -824},
    { 280, 328, -888},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:24:42 local
AccelRawData *activity_sample_walk_200_pbl_25665_15(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25665_15
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 256, -584, -1064},
    { 192, -536, -888},
    { 120, -600, -736},
    { -32, -560, -656},
    { -256, -544, -584},
    { 48, -576, -688},
    { -184, -600, -672},
    { -32, -648, -744},
    { 16, -816, -808},
    { 8, -696, -744},
    { 56, -672, -760},
    { -72, -752, -696},
    { -48, -664, -696},
    { 0, -584, -784},
    { -240, -824, -712},
    { -88, -808, -768},
    { -96, -808, -744},
    { -184, -856, -688},
    { -184, -816, -784},
    { -200, -728, -728},
    { -208, -712, -720},
    { -256, -824, -688},
    { -264, -752, -712},
    { -272, -752, -704},
    { -312, -776, -664},
    // 1 seconds
    { -272, -768, -632},
    { -232, -728, -640},
    { -248, -704, -656},
    { -304, -720, -616},
    { -336, -616, -432},
    { -40, -1080, -480},
    { -208, -912, -368},
    { -176, -992, -208},
    { 32, -824, -200},
    { 264, -656, -232},
    { 608, -416, -144},
    { 1048, -176, -80},
    { 1408, 184, 56},
    { 1944, 400, 216},
    { 2840, 664, 312},
    { 3616, 1160, 336},
    { 3080, 1464, -256},
    { 1944, 568, -176},
    { 1936, 936, 48},
    { 1616, 592, 216},
    { 1320, 824, 8},
    { 1104, 872, 112},
    { 736, 1192, -88},
    { 504, 1120, -72},
    { 696, 936, -168},
    // 2 seconds
    { 1024, 904, -96},
    { 1424, 728, -56},
    { 2000, 792, 72},
    { 2752, 552, 128},
    { 2648, 264, 200},
    { 2472, 168, 216},
    { 2104, 136, 192},
    { 1776, 200, 72},
    { 1288, 160, 40},
    { 1040, 136, -8},
    { 936, 56, 64},
    { 736, -96, -8},
    { 456, -232, -56},
    { 624, -264, -112},
    { 688, -72, -280},
    { 1264, 24, -264},
    { 1752, 144, -392},
    { 2128, 232, -248},
    { 2144, 472, -312},
    { 1704, 856, -296},
    { 1632, 440, -104},
    { 1664, 728, -80},
    { 1528, 648, -72},
    { 1144, 872, -96},
    { 1008, 960, -40},
    // 3 seconds
    { 752, 1184, -104},
    { 824, 1088, -80},
    { 1224, 912, -120},
    { 1456, 712, -152},
    { 1776, 536, -176},
    { 1680, 392, -80},
    { 1712, 256, -136},
    { 1744, 240, -120},
    { 1848, 216, -80},
    { 1648, 128, -16},
    { 1408, 152, -40},
    { 1328, 152, 24},
    { 1080, -56, 32},
    { 408, -568, 232},
    { 448, -408, -312},
    { 1048, -104, -240},
    { 1224, -56, -160},
    { 1408, 192, -320},
    { 1496, 144, -160},
    { 1760, 464, -288},
    { 1864, 504, -288},
    { 1664, 680, -208},
    { 1800, 672, -400},
    { 1448, 816, -440},
    { 1032, 1040, -576},
    // 4 seconds
    { 976, 984, -536},
    { 1056, 1160, -320},
    { 1080, 856, -304},
    { 1256, 712, -208},
    { 1520, 528, -160},
    { 1504, 312, -88},
    { 1432, 248, -136},
    { 1544, 280, -128},
    { 1720, 192, -80},
    { 1600, 112, -64},
    { 1464, 168, -64},
    { 1344, 56, -64},
    { 656, -600, 64},
    { 712, -520, 72},
    { 632, -336, -232},
    { 1192, -24, -168},
    { 1360, 112, -264},
    { 1360, 88, -224},
    { 1384, 200, -192},
    { 1528, 440, -248},
    { 1728, 472, -272},
    { 1696, 680, -280},
    { 1728, 680, -384},
    { 1312, 896, -456},
    { 864, 1032, -488},
    // 5 seconds
    { 944, 1040, -392},
    { 912, 864, -224},
    { 1096, 792, -168},
    { 1336, 640, -80},
    { 1528, 488, -64},
    { 1448, 312, -80},
    { 1440, 256, -120},
    { 1432, 232, -96},
    { 1504, 192, -88},
    { 1464, 136, -104},
    { 1456, 136, -88},
    { 1120, -128, -32},
    { 856, -408, -56},
    { 760, -544, -64},
    { 896, -152, -392},
    { 1096, -192, -328},
    { 1208, 88, -304},
    { 1264, 56, -296},
    { 1328, 328, -256},
    { 1512, 440, -192},
    { 1752, 576, -168},
    { 1664, 880, -32},
    { 1288, 960, -96},
    { 800, 1192, 0},
    { 840, 1168, 56},
    // 6 seconds
    { 1240, 1016, 152},
    { 1248, 904, 112},
    { 1368, 680, 104},
    { 1464, 552, 40},
    { 1440, 320, -16},
    { 1320, 264, -144},
    { 1336, 272, -104},
    { 1456, 288, -80},
    { 1456, 192, -72},
    { 1336, 120, -56},
    { 1248, 96, -152},
    { 808, -424, -88},
    { 576, -352, 48},
    { 824, -96, -384},
    { 968, 72, -336},
    { 1264, 232, -448},
    { 1360, 160, -312},
    { 1264, 368, -224},
    { 1440, 480, -144},
    { 1656, 824, -232},
    { 1712, 616, -96},
    { 1576, 792, -152},
    { 1192, 824, -200},
    { 952, 952, -216},
    { 1016, 1312, -168},
    // 7 seconds
    { 1008, 808, -152},
    { 1176, 848, -96},
    { 1280, 632, -136},
    { 1400, 464, -176},
    { 1336, 360, -96},
    { 1400, 248, -152},
    { 1488, 176, -96},
    { 1672, 200, -128},
    { 1504, 112, -152},
    { 1504, 152, -240},
    { 1328, -168, 64},
    { 784, -712, 424},
    { 704, -472, -272},
    { 1136, -96, -224},
    { 1456, 144, -256},
    { 1160, 56, -248},
    { 1128, -8, -128},
    { 1328, 296, -224},
    { 1608, 464, -200},
    { 1816, 544, -256},
    { 1792, 800, -248},
    { 1568, 880, -416},
    { 976, 1112, -528},
    { 968, 1104, -368},
    { 1136, 896, -240},
    // 8 seconds
    { 1136, 800, -152},
    { 1272, 728, -168},
    { 1496, 536, -120},
    { 1408, 368, -96},
    { 1400, 248, -56},
    { 1504, 288, -72},
    { 1736, 208, -112},
    { 1584, 80, 56},
    { 1440, 104, -56},
    { 1288, -96, 88},
    { 832, -232, 32},
    { 880, -320, 96},
    { 392, -72, -128},
    { 928, 72, -168},
    { 976, 64, -136},
    { 952, 112, -144},
    { 1080, 48, -128},
    { 1408, 264, -128},
    { 1912, 472, -160},
    { 2088, 640, -240},
    { 1800, 816, -464},
    { 1264, 1272, -744},
    { 864, 1016, -696},
    { 1136, 1192, -448},
    { 864, 744, -240},
    // 9 seconds
    { 1016, 848, -200},
    { 1408, 712, -48},
    { 1760, 440, 8},
    { 1464, 248, 16},
    { 1464, 240, -48},
    { 1416, 232, -40},
    { 1440, 176, -72},
    { 1400, 168, -64},
    { 1304, 120, -80},
    { 1112, -368, 0},
    { 712, -512, 16},
    { 792, -632, -16},
    { 1184, -40, -360},
    { 1464, 24, -136},
    { 1392, 136, -200},
    { 1568, 128, -112},
    { 1568, 456, -232},
    { 1608, 544, -152},
    { 1656, 616, -168},
    { 1720, 688, -168},
    { 1408, 896, -192},
    { 856, 1288, -416},
    { 832, 1072, -328},
    { 1040, 1136, -176},
    { 1064, 800, -128},
    // 10 seconds
    { 1248, 720, -96},
    { 1616, 656, -72},
    { 1704, 336, -32},
    { 1488, 272, -72},
    { 1544, 240, -72},
    { 1496, 192, -16},
    { 1528, 152, -24},
    { 1408, 120, -32},
    { 1208, 32, -48},
    { 800, -512, -56},
    { 960, -544, -48},
    { 592, -576, -112},
    { 1256, -64, -200},
    { 1464, 80, -184},
    { 1376, 176, -168},
    { 1448, 152, -88},
    { 1656, 424, -120},
    { 1816, 592, -104},
    { 1704, 712, -56},
    { 1608, 928, -136},
    { 1032, 1400, -304},
    { 744, 1480, -416},
    { 896, 1272, -312},
    { 1184, 912, -136},
    { 1248, 784, -144},
    // 11 seconds
    { 1624, 672, -40},
    { 1976, 600, -40},
    { 1816, 328, 16},
    { 1720, 248, 8},
    { 1544, 208, 8},
    { 1480, 168, -32},
    { 1352, 136, 8},
    { 1152, 88, -16},
    { 1128, -56, -40},
    { 552, -640, 0},
    { 656, -504, -120},
    { 504, -432, -192},
    { 1224, -72, -208},
    { 1552, 56, -200},
    { 1512, 256, -176},
    { 1568, 280, -160},
    { 1656, 464, -200},
    { 1816, 576, -152},
    { 1704, 744, -216},
    { 1560, 976, -368},
    { 832, 1456, -728},
    { 736, 1168, -584},
    { 920, 1048, -424},
    { 1024, 1064, -360},
    { 1400, 904, -152},
    // 12 seconds
    { 1704, 688, -64},
    { 1880, 632, -8},
    { 2056, 448, 24},
    { 1720, 240, 40},
    { 1416, 224, -32},
    { 1408, 216, -8},
    { 1352, 192, 24},
    { 1240, 88, 24},
    { 1144, 96, -16},
    { 760, -248, -16},
    { 184, -400, -168},
    { 768, -376, -368},
    { 768, -144, -200},
    { 1200, 88, -408},
    { 1288, 128, -360},
    { 1512, 232, -264},
    { 1664, 184, -104},
    { 1808, 440, -72},
    { 1816, 744, -72},
    { 1728, 688, -32},
    { 1568, 832, -16},
    { 1136, 1168, -104},
    { 880, 1288, -232},
    { 832, 1288, -208},
    { 1064, 1344, -48},
    // 13 seconds
    { 1136, 936, -40},
    { 1320, 720, -16},
    { 1728, 680, 24},
    { 2024, 416, 24},
    { 1808, 248, -8},
    { 1664, 272, -32},
    { 1704, 224, -96},
    { 1480, 80, 8},
    { 1216, 128, -80},
    { 1048, -32, -128},
    { 616, -600, -72},
    { 856, -608, -208},
    { 1040, -648, 32},
    { 1288, 24, -416},
    { 1376, 96, -248},
    { 1496, 208, -304},
    { 1736, 184, -96},
    { 1912, 568, -264},
    { 1856, 968, -296},
    { 1720, 544, -248},
    { 1640, 824, -160},
    { 1272, 816, -288},
    { 928, 1368, -272},
    { 776, 1448, -288},
    { 992, 952, -168},
    // 14 seconds
    { 1216, 920, -104},
    { 1568, 728, -104},
    { 1936, 600, -176},
    { 1912, 424, -120},
    { 1592, 520, -248},
    { 1744, -40, 16},
    { 1584, 128, 56},
    { 1440, 160, -152},
    { 1400, 96, -16},
    { 1184, 128, 0},
    { 952, 104, 56},
    { 616, -328, 80},
    { 200, -320, 24},
    { 528, -192, -320},
    { 880, -64, -88},
    { 1208, 192, -240},
    { 1448, 136, -328},
    { 1632, 272, -248},
    { 1856, 432, -160},
    { 2016, 712, -152},
    { 2016, 792, -208},
    { 1456, 928, -232},
    { 840, 1384, -288},
    { 896, 1072, -176},
    { 960, 1304, -24},
    // 15 seconds
    { 1040, 928, -16},
    { 1336, 728, 72},
    { 1528, 600, 32},
    { 1440, 368, -16},
    { 1224, 296, -32},
    { 1336, 392, -64},
    { 1560, 280, -56},
    { 1536, 240, -120},
    { 1360, 72, -24},
    { 1232, 80, -120},
    { 1032, 40, -136},
    { 480, -432, -40},
    { 664, -368, -40},
    { 840, 56, -296},
    { 1168, 136, -232},
    { 1312, 232, -352},
    { 1344, 96, -160},
    { 1408, 320, -224},
    { 1640, 536, -136},
    { 1760, 720, -128},
    { 1584, 792, -80},
    { 1168, 1040, -80},
    { 728, 1416, -208},
    { 760, 1120, -40},
    { 1048, 1112, -8},
    // 16 seconds
    { 1256, 864, 64},
    { 1392, 680, 56},
    { 1560, 560, 32},
    { 1504, 424, -24},
    { 1440, 368, -88},
    { 1528, 328, -56},
    { 1456, 272, -40},
    { 1280, 192, -48},
    { 1144, 160, -24},
    { 1240, 184, -48},
    { 912, 48, -88},
    { 600, -200, 32},
    { 352, -328, -104},
    { 728, 72, -184},
    { 1096, 72, -360},
    { 1256, 256, -544},
    { 1160, 136, -536},
    { 1496, 336, -448},
    { 1816, 464, -384},
    { 1824, 944, -272},
    { 1560, 920, -304},
    { 1032, 1016, -272},
    { 864, 1168, -152},
    { 968, 1328, -40},
    { 1072, 1120, 8},
    // 17 seconds
    { 1176, 864, 32},
    { 1312, 720, -8},
    { 1592, 560, -72},
    { 1544, 424, -112},
    { 1512, 312, -152},
    { 1504, 280, -136},
    { 1456, 216, -104},
    { 1328, 160, -136},
    { 1152, 112, -96},
    { 1096, 112, -120},
    { 744, -24, -144},
    { 592, -80, -8},
    { 464, -248, -216},
    { 672, 80, -384},
    { 864, 8, -464},
    { 1136, 96, -376},
    { 1320, 200, -416},
    { 1520, 408, -432},
    { 1704, 536, -424},
    { 1752, 696, -240},
    { 1616, 712, -368},
    { 1032, 856, -344},
    { 848, 1240, -560},
    { 872, 1336, -392},
    { 1096, 1032, -256},
    // 18 seconds
    { 1184, 936, -136},
    { 1304, 696, -104},
    { 1552, 552, -120},
    { 1440, 368, -96},
    { 1416, 280, -136},
    { 1440, 256, -112},
    { 1384, 200, -80},
    { 1272, 152, -88},
    { 1288, 168, -112},
    { 1120, 120, -80},
    { 896, 128, -208},
    { 584, -600, -32},
    { 400, -456, -104},
    { 1008, 56, -216},
    { 1184, 16, -216},
    { 1360, 272, -304},
    { 1384, 160, -200},
    { 1544, 328, -224},
    { 1808, 440, -200},
    { 1912, 712, -232},
    { 1584, 704, -296},
    { 1128, 1000, -360},
    { 896, 1200, -392},
    { 944, 1072, -272},
    { 1048, 936, -176},
    // 19 seconds
    { 1120, 792, -144},
    { 1184, 680, -104},
    { 1448, 632, -112},
    { 1456, 392, -72},
    { 1408, 304, -128},
    { 1480, 256, -96},
    { 1520, 232, -64},
    { 1472, 128, -88},
    { 1392, 88, -32},
    { 1256, 128, -32},
    { 1024, -80, -80},
    { 688, -584, 96},
    { 608, -512, -120},
    { 1064, -56, -336},
    { 1288, -16, -280},
    { 1272, 288, -328},
    { 1256, 136, -248},
    { 1384, 368, -208},
    { 1608, 456, -168},
    { 1680, 712, -200},
    { 1480, 640, -104},
    { 1200, 880, -152},
    { 1032, 1064, -112},
    { 1016, 1000, -48},
    { 1040, 904, -72},
    // 20 seconds
    { 944, 752, -56},
    { 1144, 776, 0},
    { 1408, 616, -40},
    { 1336, 384, -80},
    { 1240, 280, -112},
    { 1288, 240, -88},
    { 1304, 232, -64},
    { 1328, 168, -88},
    { 1280, 136, -72},
    { 1264, 136, -48},
    { 960, -96, -96},
    { 912, -280, -56},
    { 688, -320, -56},
    { 928, -8, -280},
    { 1184, 64, -224},
    { 1136, 104, -240},
    { 1096, 96, -216},
    { 1160, 264, -264},
    { 1400, 360, -168},
    { 1688, 472, -224},
    { 1624, 784, -168},
    { 1248, 736, -288},
    { 968, 992, -352},
    { 808, 1024, -216},
    { 1016, 944, -192},
    // 21 seconds
    { 1024, 688, -152},
    { 1120, 704, -88},
    { 1376, 616, -72},
    { 1536, 480, -88},
    { 1328, 304, -72},
    { 1344, 224, -88},
    { 1328, 208, -56},
    { 1352, 168, -56},
    { 1304, 136, -120},
    { 1256, 136, -88},
    { 1136, 112, -192},
    { 680, -512, -80},
    { 736, -424, -56},
    { 768, -232, -224},
    { 1104, -96, -208},
    { 1464, 272, -328},
    { 1288, 128, -136},
    { 1240, 208, -256},
    { 1232, 328, -144},
    { 1432, 424, -152},
    { 1544, 520, -136},
    { 1512, 672, -80},
    { 1208, 848, -136},
    { 1016, 1040, -176},
    { 840, 1040, -160},
    // 22 seconds
    { 1072, 1096, -88},
    { 1104, 744, -128},
    { 1208, 696, -120},
    { 1424, 632, -80},
    { 1496, 440, -24},
    { 1456, 280, -56},
    { 1576, 240, -40},
    { 1520, 240, 8},
    { 1424, 136, -40},
    { 1296, 152, -32},
    { 1248, 184, -32},
    { 1120, 88, -56},
    { 808, -464, -8},
    { 624, -376, -16},
    { 768, 0, -360},
    { 952, -160, -120},
    { 1112, 248, -256},
    { 1120, 80, -128},
    { 1208, 200, -168},
    { 1536, 360, -192},
    { 1888, 472, -144},
    { 1784, 824, -312},
    { 1400, 640, -424},
    { 1104, 960, -504},
    { 1008, 960, -408},
    // 23 seconds
    { 1296, 928, -296},
    { 1168, 744, -256},
    { 1024, 680, -200},
    { 968, 624, -184},
    { 1104, 424, -136},
    { 1144, 280, -80},
    { 1312, 248, -64},
    { 1472, 224, -32},
    { 1504, 152, -72},
    { 1400, 72, 24},
    { 1264, 152, -16},
    { 1312, 56, 16},
    { 904, -464, 48},
    { 864, -392, 120},
    { 896, -136, -272},
    { 1232, -160, -56},
    { 1200, 224, -184},
    { 1104, 24, -120},
    { 1064, 184, -216},
    { 1256, 344, -232},
    { 1632, 432, -224},
    { 1680, 624, -264},
    { 1384, 640, -288},
    { 1088, 912, -448},
    { 840, 936, -368},
    // 24 seconds
    { 1104, 984, -320},
    { 1160, 704, -200},
    { 1136, 672, -192},
    { 1224, 584, -160},
    { 1360, 456, -128},
    { 1344, 280, -80},
    { 1376, 240, -72},
    { 1456, 208, -48},
    { 1432, 160, -32},
    { 1432, 120, -32},
    { 1384, 176, -40},
    { 1184, 104, -40},
    { 808, -376, -24},
    { 768, -304, 112},
    { 680, -232, -288},
    { 984, -40, -248},
    { 1160, 152, -336},
    { 1104, 64, -288},
    { 1192, 104, -232},
    { 1424, 352, -240},
    { 1760, 528, -272},
    { 1632, 880, -184},
    { 1360, 592, -360},
    { 928, 1024, -352},
    { 784, 1040, -344},
    // 25 seconds
    { 1192, 1072, -288},
    { 1424, 896, -160},
    { 1216, 760, -80},
    { 1136, 592, -88},
    { 1456, 552, -56},
    { 1552, 320, -56},
    { 1576, 208, 8},
    { 1616, 200, -16},
    { 1448, 264, -56},
    { 1200, 176, -32},
    { 1032, 184, -16},
    { 992, 168, -40},
    { 808, -24, -24},
    { 752, -216, 96},
    { 384, -184, -296},
    { 784, 64, -400},
    { 1056, 56, -232},
    { 1352, 136, -320},
    { 1504, 128, -288},
    { 1600, 432, -288},
    { 1648, 400, -240},
    { 1656, 536, -112},
    { 1728, 624, -136},
    { 1408, 704, -80},
    { 1160, 912, -104},
    // 26 seconds
    { 1072, 1176, -88},
    { 1064, 1224, -32},
    { 824, 840, -56},
    { 856, 736, -56},
    { 1000, 560, -88},
    { 1240, 400, -128},
    { 1520, 352, -104},
    { 1792, 360, -88},
    { 1784, 280, -48},
    { 1584, 224, -64},
    { 1392, 224, -112},
    { 1312, 192, -72},
    { 1240, 152, -112},
    { 1080, -480, 168},
    { 480, -488, -192},
    { 736, -200, -360},
    { 976, -376, -8},
    { 1048, 176, -208},
    { 1096, 72, -240},
    { 1352, 376, -232},
    { 1840, 440, -160},
    { 2024, 672, -232},
    { 1512, 640, -56},
    { 1448, 792, -208},
    { 1176, 1064, -80},
    // 27 seconds
    { 896, 1400, 0},
    { 1144, 1040, -120},
    { 1000, 968, -24},
    { 1040, 736, -56},
    { 1248, 616, -48},
    { 1392, 408, -24},
    { 1384, 288, -72},
    { 1560, 280, -104},
    { 1528, 240, -48},
    { 1408, 184, -40},
    { 1288, 168, -48},
    { 1208, 144, -8},
    { 1008, 64, -64},
    { 728, -408, 120},
    { 616, -328, -56},
    { 944, -16, -368},
    { 1224, -32, -160},
    { 1288, 224, -264},
    { 1264, 48, -192},
    { 1312, 344, -288},
    { 1536, 400, -160},
    { 1728, 512, -224},
    { 1688, 728, -176},
    { 1416, 808, -232},
    { 1064, 1088, -368},
    // 28 seconds
    { 840, 1152, -280},
    { 1120, 1032, -184},
    { 1176, 816, -120},
    { 1160, 648, -136},
    { 1240, 584, -136},
    { 1312, 392, -72},
    { 1296, 272, -64},
    { 1416, 248, -96},
    { 1520, 216, -48},
    { 1568, 168, -40},
    { 1328, 120, -16},
    { 1168, 160, -24},
    { 1072, -24, 40},
    { 864, -368, 208},
    { 680, -264, -40},
    { 944, 32, -352},
    { 1208, -64, -72},
    { 1192, 264, -216},
    { 1200, 24, -232},
    { 1240, 272, -240},
    { 1488, 456, -256},
    { 1864, 696, -296},
    { 1632, 912, -184},
    { 1336, 728, -320},
    { 968, 1024, -424},
    // 29 seconds
    { 688, 936, -368},
    { 992, 928, -304},
    { 1192, 768, -152},
    { 1264, 688, -96},
    { 1344, 616, -96},
    { 1416, 440, -24},
    { 1352, 256, -24},
    { 1392, 240, -56},
    { 1456, 240, -40},
    { 1528, 208, -80},
    { 1592, 144, -144},
    { 1360, 104, -200},
    { 1136, -112, -160},
    { 584, -320, -8},
    { 456, -224, -200},
    { 648, 32, -312},
    { 800, 8, -56},
    { 984, 152, 8},
    { 1168, 192, -88},
    { 1456, 224, -144},
    { 1864, 520, -120},
    { 1976, 768, -176},
    { 1696, 536, -184},
    { 1456, 744, -448},
    { 992, 1392, -592},
    // 30 seconds
    { 696, 1264, -648},
    { 1024, 976, -464},
    { 1064, 792, -320},
    { 1512, 704, -184},
    { 1704, 552, -136},
    { 1496, 320, -80},
    { 1384, 240, -64},
    { 1480, 248, -72},
    { 1480, 216, -8},
    { 1456, 160, -24},
    { 1272, 120, 8},
    { 1104, 136, 24},
    { 960, -128, 96},
    { 584, -368, 136},
    { 688, -352, -16},
    { 992, 0, -272},
    { 1192, -24, -56},
    { 1384, 272, -200},
    { 1392, 80, -192},
    { 1464, 248, -208},
    { 1688, 416, -232},
    { 1744, 560, -256},
    { 1664, 600, -320},
    { 1344, 728, -416},
    { 896, 856, -408},
    // 31 seconds
    { 880, 888, -360},
    { 1120, 952, -240},
    { 1256, 808, -136},
    { 1264, 664, -112},
    { 1120, 568, -120},
    { 1240, 456, -104},
    { 1360, 312, -64},
    { 1416, 224, -40},
    { 1456, 192, -56},
    { 1448, 136, -56},
    { 1408, 168, 8},
    { 1256, 112, 0},
    { 1048, 152, -8},
    { 872, -272, 0},
    { 688, -272, 112},
    { 880, -160, -304},
    { 1320, -64, -128},
    { 1304, 112, -168},
    { 1136, 136, -216},
    { 1080, 184, -296},
    { 1224, 304, -176},
    { 1520, 376, -216},
    { 1624, 592, -336},
    { 1328, 664, -280},
    { 1056, 648, -536},
    // 32 seconds
    { 864, 776, -368},
    { 1080, 704, -240},
    { 1264, 808, -288},
    { 1120, 656, -160},
    { 1184, 648, -176},
    { 1344, 552, -184},
    { 1360, 312, -72},
    { 1312, 280, 24},
    { 1496, 152, 16},
    { 1392, 176, 104},
    { 1280, 176, 0},
    { 1232, 176, 0},
    { 1208, 160, 8},
    { 872, -128, 64},
    { 672, -104, -56},
    { 720, -208, -104},
    { 960, 48, -336},
    { 1248, 136, -216},
    { 1232, 192, -280},
    { 1112, 80, -192},
    { 1080, 248, -192},
    { 1232, 328, -128},
    { 1528, 448, -152},
    { 1544, 552, -136},
    { 1320, 656, -216},
    // 33 seconds
    { 1200, 752, -328},
    { 1120, 720, -352},
    { 1080, 1000, -400},
    { 928, 920, -312},
    { 1032, 856, -264},
    { 1312, 744, -200},
    { 1400, 472, -104},
    { 1376, 304, -48},
    { 1520, 248, -16},
    { 1520, 224, 0},
    { 1456, 216, -8},
    { 1312, 192, 0},
    { 1216, 144, 0},
    { 1120, 168, -32},
    { 1136, -64, -16},
    { 480, -400, 136},
    { 968, -176, -424},
    { 1072, -360, -48},
    { 1248, 80, -128},
    { 1088, 80, -264},
    { 1048, 192, -256},
    { 1208, 264, -200},
    { 1520, 352, -232},
    { 1808, 488, -280},
    { 1792, 736, -320},
    // 34 seconds
    { 1416, 728, -376},
    { 1184, 872, -336},
    { 1136, 1144, -328},
    { 944, 920, -176},
    { 920, 944, -144},
    { 1064, 784, -120},
    { 1288, 568, -72},
    { 1368, 408, -64},
    { 1440, 312, -64},
    { 1552, 264, -56},
    { 1624, 216, -56},
    { 1592, 144, -32},
    { 1576, 152, -48},
    { 1336, -16, -24},
    { 1056, -392, 32},
    { 704, -608, 120},
    { 944, -200, -288},
    { 1184, -256, 24},
    { 1232, 200, -64},
    { 1160, 128, -184},
    { 1272, 256, -192},
    { 1544, 360, -80},
    { 1880, 552, -168},
    { 1896, 768, -144},
    { 1592, 768, -248},
    // 35 seconds
    { 1032, 1152, -408},
    { 688, 1280, -440},
    { 1008, 1072, -264},
    { 1000, 904, -256},
    { 1288, 760, -160},
    { 1552, 680, -120},
    { 1696, 456, -56},
    { 1632, 288, -32},
    { 1616, 216, -16},
    { 1528, 216, -24},
    { 1448, 224, -40},
    { 1504, 136, 24},
    { 1352, 160, 16},
    { 1208, 48, -72},
    { 624, -592, 0},
    { 608, -528, -40},
    { 696, -272, -264},
    { 1072, -224, 48},
    { 1424, 248, -208},
    { 1568, 216, -224},
    { 1720, 256, -200},
    { 1920, 440, -216},
    { 1872, 656, -256},
    { 1728, 568, -360},
    { 1472, 760, -512},
    // 36 seconds
    { 856, 912, -720},
    { 840, 880, -632},
    { 936, 1048, -504},
    { 1016, 848, -296},
    { 1248, 720, -232},
    { 1424, 616, -168},
    { 1704, 528, -112},
    { 1656, 320, -48},
    { 1568, 280, -80},
    { 1560, 224, -56},
    { 1464, 208, 0},
    { 1320, 200, -8},
    { 1224, 176, 0},
    { 1192, 168, -32},
    { 1056, -24, -88},
    { 696, -344, 40},
    { 544, -320, -400},
    { 808, -152, -376},
    { 1072, -112, -232},
    { 1232, 24, -296},
    { 1352, 144, -288},
    { 1520, 368, -264},
    { 1800, 432, -248},
    { 1864, 632, -288},
    { 1584, 536, -216},
    // 37 seconds
    { 1256, 656, -304},
    { 1064, 800, -240},
    { 1088, 760, -56},
    { 1144, 944, 16},
    { 904, 800, -24},
    { 944, 712, -32},
    { 992, 608, -16},
    { 1240, 584, -40},
    { 1272, 424, -48},
    { 1352, 520, -8},
    { 1664, 488, 40},
    { 1664, 656, -88},
    { 1432, 592, -32},
    { 1192, 432, -96},
    { 1024, 296, -128},
    { 712, 88, -160},
    { 672, 64, -152},
    { 336, -144, -176},
    { 656, 144, -400},
    { 984, -64, -272},
    { 1200, 24, -232},
    { 1592, 184, -288},
    { 1752, 280, -272},
    { 2088, 480, -216},
    { 2080, 800, -352},
    // 38 seconds
    { 1560, 472, -48},
    { 1376, 824, -288},
    { 1080, 568, -280},
    { 816, 760, -448},
    { 944, 784, -384},
    { 1048, 848, -456},
    { 1096, 752, -320},
    { 1240, 584, -256},
    { 1520, 608, -232},
    { 1928, 432, -104},
    { 1688, 304, 8},
    { 1560, 352, 24},
    { 1608, 312, 56},
    { 1432, 320, 96},
    { 1392, 240, 96},
    { 1272, 232, 56},
    { 1176, 200, 48},
    { 816, -296, 16},
    { 432, -440, -200},
    { 328, -680, -96},
    { 1120, -232, -272},
    { 1560, -168, 24},
    { 1848, 376, -168},
    { 2072, 272, -208},
    { 2192, 472, -104},
    // 39 seconds
    { 2016, 608, -152},
    { 1576, 424, -88},
    { 1952, 776, -248},
    { 1376, 832, -200},
    { 1032, 912, -456},
    { 1000, 808, -384},
    { 928, 1048, -480},
    { 856, 992, -344},
    { 1112, 816, -304},
    { 1584, 744, -216},
    { 2192, 624, -168},
    { 2040, 384, -16},
    { 1712, 176, 104},
    { 1664, 336, 80},
    { 1560, 144, 160},
    { 1552, 280, 56},
    { 1520, 192, 104},
    { 1264, 80, 96},
    { 1128, 128, -48},
    { 688, -816, 112},
    { 320, -480, 24},
    { 952, -56, -672},
    { 1224, -464, 216},
    { 1392, 648, -376},
    { 1312, -64, -72},
    // 40 seconds
    { 1672, 376, -64},
    { 1912, 352, 80},
    { 2192, 672, -56},
    { 2032, 856, 104},
    { 1816, 656, -72},
    { 1456, 1024, 16},
    { 1104, 1432, 88},
    { 776, 1544, -8},
    { 928, 944, -24},
    { 1024, 1008, 88},
    { 1288, 800, 80},
    { 1728, 576, 16},
    { 1632, 400, -16},
    { 1720, 296, -56},
    { 1848, 296, 8},
    { 1816, 288, 24},
    { 1648, 144, -24},
    { 1368, 120, 96},
    { 1208, 0, 32},
    { 728, -448, 96},
    { 704, -400, 104},
    { 728, -200, -288},
    { 1104, -144, -16},
    { 1424, 192, -112},
    { 1432, 120, -168},
    // 41 seconds
    { 1432, 200, -176},
    { 1648, 400, -240},
    { 1808, 496, -208},
    { 1872, 560, -264},
    { 1752, 672, -408},
    { 1296, 1024, -568},
    { 896, 1120, -632},
    { 968, 1056, -624},
    { 816, 872, -360},
    { 1064, 760, -248},
    { 1376, 680, -168},
    { 1528, 488, -96},
    { 1408, 360, -64},
    { 1488, 264, -56},
    { 1488, 240, -32},
    { 1584, 192, -48},
    { 1760, 120, -40},
    { 1400, 176, -32},
    { 1320, 40, -176},
    { 800, -440, 0},
    { 616, -480, 0},
    { 768, -112, -336},
    { 784, -64, -272},
    { 1056, 216, -168},
    { 1112, 96, -256},
    // 42 seconds
    { 1272, 184, -280},
    { 1640, 392, -184},
    { 1952, 560, -288},
    { 1608, 640, -192},
    { 1288, 1056, -560},
    { 736, 1280, -520},
    { 1152, 1168, -200},
    { 1360, 976, -32},
    { 1144, 928, -8},
    { 1232, 600, 72},
    { 1368, 536, 0},
    { 1312, 336, 24},
    { 1280, 264, -24},
    { 1400, 296, -48},
    { 1464, 232, -104},
    { 1384, 192, -128},
    { 1240, 192, -176},
    { 1312, 152, -200},
    { 768, -368, -64},
    { 576, -368, -112},
    { 720, -368, 0},
    { 936, 0, -168},
    { 1160, 136, -240},
    { 1320, 336, -256},
    { 1440, 184, -152},
    // 43 seconds
    { 1512, 352, -208},
    { 1696, 552, -120},
    { 1640, 632, -80},
    { 1488, 688, -96},
    { 1072, 944, -96},
    { 840, 1232, -72},
    { 920, 1016, -24},
    { 1056, 1208, -16},
    { 1160, 912, 80},
    { 1304, 736, 56},
    { 1520, 624, 40},
    { 1608, 464, -40},
    { 1472, 296, -8},
    { 1448, 256, -80},
    { 1432, 264, -96},
    { 1472, 216, -48},
    { 1304, 136, -80},
    { 1152, 136, -96},
    { 1056, 96, -104},
    { 856, -440, 48},
    { 704, -360, 152},
    { 784, 64, -400},
    { 808, -160, -200},
    { 1208, 352, -232},
    { 1136, 96, -240},
    // 44 seconds
    { 1296, 136, -264},
    { 1504, 504, -264},
    { 1760, 480, -272},
    { 1688, 720, -240},
    { 1544, 688, -272},
    { 1024, 928, -328},
    { 880, 968, -352},
    { 888, 984, -136},
    { 1360, 1160, -176},
    { 1504, 848, -40},
    { 1288, 656, -56},
    { 1224, 624, -96},
    { 1384, 416, -80},
    { 1368, 280, -56},
    { 1496, 240, -104},
    { 1584, 232, -56},
    { 1376, 176, 8},
    { 1344, 144, -40},
    { 1216, 144, 32},
    { 1088, 160, -48},
    { 736, -224, -24},
    { 576, -264, 56},
    { 632, -152, -272},
    { 1088, -136, -120},
    { 1392, 216, -216},
    // 45 seconds
    { 1384, 112, -224},
    { 1424, 152, -200},
    { 1504, 408, -216},
    { 1672, 448, -168},
    { 1760, 568, -136},
    { 1736, 608, -128},
    { 1336, 752, -80},
    { 1120, 968, -104},
    { 1016, 1208, -80},
    { 880, 1024, -128},
    { 896, 896, -96},
    { 1040, 784, -24},
    { 1376, 680, -80},
    { 1560, 408, -80},
    { 1456, 344, -72},
    { 1584, 224, -72},
    { 1600, 208, -24},
    { 1616, 120, -8},
    { 1496, 128, -40},
    { 1272, 128, -104},
    { 1008, -272, -104},
    { 1032, -456, 32},
    { 616, -408, -352},
    { 1112, -224, -256},
    { 1160, -16, -128},
    // 46 seconds
    { 1072, 152, -184},
    { 1024, 128, -248},
    { 1184, 272, -120},
    { 1520, 360, -64},
    { 1928, 552, -80},
    { 1872, 864, 120},
    { 1624, 824, -80},
    { 1352, 1248, 88},
    { 1032, 1688, 104},
    { 1048, 848, -40},
    { 912, 1000, -128},
    { 976, 792, -72},
    { 1208, 512, -80},
    { 1264, 360, -64},
    { 1376, 248, -88},
    { 1632, 248, -72},
    { 1824, 192, 24},
    { 1696, 112, 40},
    { 1496, 88, -72},
    { 936, -824, 0},
    { 928, -464, -16},
    { 1056, -656, 24},
    { 1168, -272, -304},
    { 1400, -328, 72},
    { 1304, 296, -112},
    // 47 seconds
    { 1304, 64, -152},
    { 1456, 368, -128},
    { 1688, 512, -32},
    { 1688, 696, -8},
    { 1720, 760, -72},
    { 1336, 1240, -120},
    { 896, 1488, -184},
    { 912, 1504, -200},
    { 1096, 992, -96},
    { 1248, 904, -72},
    { 1512, 768, -16},
    { 1800, 568, -8},
    { 1752, 336, 16},
    { 1776, 232, -64},
    { 1688, 216, -40},
    { 1688, 176, -8},
    { 1504, 160, 8},
    { 1272, 136, 32},
    { 1032, -32, 40},
    { 776, -424, 96},
    { 536, -440, 168},
    { 864, -64, -408},
    { 1008, -168, -16},
    { 1312, 136, -48},
    { 1336, 152, -224},
    // 48 seconds
    { 1488, 208, -248},
    { 1760, 392, -208},
    { 2192, 656, -224},
    { 1856, 592, -264},
    { 1616, 792, -512},
    { 1088, 1152, -536},
    { 960, 1528, -528},
    { 1232, 1320, -432},
    { 1176, 752, -304},
    { 1232, 728, -224},
    { 1512, 704, -160},
    { 1496, 352, -120},
    { 1424, 248, -160},
    { 1584, 256, -152},
    { 1680, 216, 8},
    { 1688, 152, -88},
    { 1416, 104, 8},
    { 1272, 144, -64},
    { 1024, 24, -24},
    { 392, -496, 328},
    { 512, -256, -432},
    { 664, -120, -296},
    { 1056, 24, -192},
    { 1072, 176, -424},
    { 1120, 48, -296},
    // 49 seconds
    { 1344, 320, -272},
    { 1720, 376, -232},
    { 2080, 672, -272},
    { 1792, 976, -112},
    { 1520, 1064, -360},
    { 920, 1400, -280},
    { 920, 1600, -288},
    { 1024, 848, -120},
    { 1056, 944, -80},
    { 1424, 736, 16},
    { 1688, 456, 40},
    { 1536, 312, -32},
    { 1456, 280, -16},
    { 1464, 200, -48},
    { 1384, 224, 8},
    { 1328, 152, -48},
    { 1336, 184, -56},
    { 1208, 120, -88},
    { 816, -504, -80},
    { 784, -408, 8},
    { 904, -224, -288},
    { 1368, -152, -112},
    { 1496, 208, -336},
    { 1448, 136, -208},
    { 1432, 208, -232},
    // 50 seconds
    { 1608, 408, -168},
    { 2016, 584, -160},
    { 1808, 912, -40},
    { 1304, 824, 0},
    { 856, 1072, -48},
    { 928, 1264, 24},
    { 960, 1080, 8},
    { 992, 944, -16},
    { 1320, 912, 8},
    { 1800, 784, 56},
    { 2128, 472, 0},
    { 1832, 360, -32},
    { 1808, 328, 0},
    { 1776, 248, -24},
    { 1704, 200, -24},
    { 1640, 216, 40},
    { 1576, 160, 32},
    { 1392, 184, 8},
    { 920, -624, 112},
    { -144, -848, 248},
    { 992, -144, -672},
    { 1336, -424, 104},
    { 1640, 240, -384},
    { 1336, 56, -152},
    { 1464, 248, -240},
    // 51 seconds
    { 1816, 480, -208},
    { 2304, 784, -448},
    { 1768, 1384, -72},
    { 1592, 872, -736},
    { 696, 1480, -616},
    { 712, 976, -528},
    { 968, 1296, -472},
    { 1336, 1016, -224},
    { 1696, 864, -184},
    { 2096, 824, -56},
    { 2184, 424, -40},
    { 1856, 304, -32},
    { 1648, 248, -16},
    { 1704, 248, -32},
    { 1640, 176, 24},
    { 1672, 160, 48},
    { 1312, 120, 32},
    { 1104, 176, -72},
    { 568, -568, 16},
    { 192, -640, -128},
    { 480, -200, -256},
    { 984, -160, -280},
    { 1344, -16, -72},
    { 1616, 264, -432},
    { 1880, 144, -144},
    // 52 seconds
    { 2160, 536, -160},
    { 2384, 816, -208},
    { 1984, 752, -152},
    { 1568, 960, -112},
    { 1008, 976, -104},
    { 848, 1096, -160},
    { 792, 1128, -48},
    { 1032, 1272, 96},
    { 1144, 856, 40},
    { 1232, 760, 88},
    { 1336, 696, 112},
    { 1824, 560, 24},
    { 1848, 360, -16},
    { 1840, 328, -80},
    { 1768, 304, -96},
    { 1528, 192, -96},
    { 1248, 144, -128},
    { 1128, 128, -144},
    { 992, -88, -176},
    { 224, -672, 0},
    { 1128, -320, -184},
    { 1152, -168, -112},
    { 1528, 152, -416},
    { 1416, 240, -360},
    { 1344, 80, -192},
    // 53 seconds
    { 1352, 256, -184},
    { 1656, 456, -80},
    { 2184, 672, -8},
    { 1848, 704, 136},
    { 1504, 792, 96},
    { 1136, 824, 248},
    { 1008, 840, 344},
    { 944, 936, 440},
    { 1000, 1248, 424},
    { 968, 808, 232},
    { 856, 888, 40},
    { 816, 832, 32},
    { 1320, 760, -8},
    { 2312, 688, -88},
    { 2456, 480, -200},
    { 2352, 184, -72},
    { 1776, 336, -136},
    { 1328, 104, -144},
    { 1024, 0, -96},
    { 848, -80, -64},
    { 360, -424, 112},
    { 592, -136, -16},
    { 1256, -224, 296},
    { 1120, 88, -40},
    { 1512, 240, -320},
    // 54 seconds
    { 1472, 176, -128},
    { 1760, 144, -40},
    { 1952, 520, -192},
    { 2120, 688, -112},
    { 1952, 424, 96},
    { 1944, 624, 352},
    { 1408, 752, 616},
    { 1080, 864, 552},
    { 1088, 808, 552},
    { 952, 1040, 480},
    { 808, 896, 400},
    { 840, 880, 304},
    { 1072, 696, 184},
    { 1472, 632, 56},
    { 1928, 480, 24},
    { 1984, 472, 16},
    { 1992, 408, -16},
    { 1968, 360, 8},
    { 1760, 208, 120},
    { 1504, 48, 48},
    { 1416, -16, 72},
    { 1240, -168, 168},
    { 728, -512, 584},
    { 816, -8, -504},
    { 800, 8, -248},
    // 55 seconds
    { 1088, -408, 120},
    { 1232, 304, -360},
    { 1136, 88, -160},
    { 1432, 440, -200},
    { 1864, 368, -80},
    { 2136, 640, -40},
    { 2032, 888, 144},
    { 1680, 776, 136},
    { 1312, 960, 296},
    { 1296, 1096, 376},
    { 936, 936, 232},
    { 544, 1184, 0},
    { 664, 792, -80},
    { 1136, 712, -136},
    { 1568, 552, -120},
    { 1552, 400, -160},
    { 1584, 352, -128},
    { 1704, 256, -80},
    { 1648, 200, -56},
    { 1520, 96, -72},
    { 1328, 128, -32},
    { 1216, 168, -88},
    { 1064, -48, -184},
    { 632, -144, 0},
    { 504, -152, -368},
    // 56 seconds
    { 672, -80, -152},
    { 1000, 96, -312},
    { 1288, 112, -248},
    { 1568, 224, -248},
    { 1792, 560, -168},
    { 1888, 768, -152},
    { 1648, 408, -64},
    { 1552, 640, -56},
    { 1168, 1072, 216},
    { 872, 784, 296},
    { 880, 760, 176},
    { 664, 944, 144},
    { 984, 776, 216},
    { 1216, 672, 144},
    { 1488, 528, -24},
    { 1344, 448, -64},
    { 1400, 464, -128},
    { 1616, 304, -216},
    { 1760, 288, -104},
    { 1552, 32, -160},
    { 1632, 96, -176},
    { 1320, 96, -184},
    { 648, -448, -80},
    { 688, -328, -48},
    { 1016, -144, -240},
    // 57 seconds
    { 1224, 8, -216},
    { 1264, 160, -264},
    { 1192, 248, -288},
    { 1280, 256, -192},
    { 1504, 400, -48},
    { 1816, 424, 16},
    { 1848, 736, 136},
    { 1704, 800, 144},
    { 1672, 608, 240},
    { 1192, 656, 352},
    { 1144, 856, 408},
    { 600, 752, 240},
    { 640, 544, 168},
    { 664, 728, 64},
    { 848, 840, -184},
    { 1032, 640, -256},
    { 1280, 696, -272},
    { 1672, 448, -256},
    { 1640, 144, -240},
    { 1328, 232, -224},
    { 1224, 112, -272},
    { 1096, 144, -248},
    { 1064, -56, -232},
    { 1056, -304, 120},
    { 1288, -152, -312},
    // 58 seconds
    { 992, 0, -632},
    { 1504, 136, -232},
    { 1240, 16, -168},
    { 1264, 104, -112},
    { 1392, 464, -88},
    { 1520, 496, 8},
    { 1504, 520, 40},
    { 1400, 688, -24},
    { 1320, 592, 160},
    { 1176, 432, 256},
    { 920, 472, 280},
    { 928, 576, 160},
    { 680, 848, 160},
    { 720, 952, -160},
    { 856, 624, -192},
    { 1096, 712, -352},
    { 1280, 648, -320},
    { 1408, 464, -224},
    { 1576, 96, -280},
    { 1408, 120, -200},
    { 1320, 112, -272},
    { 1320, 64, -248},
    { 1272, 104, -248},
    { 1000, -200, -112},
    { 896, -280, -112},
    // 59 seconds
    { 1144, -216, -320},
    { 992, -80, -224},
    { 1416, 88, -256},
    { 1256, 128, -200},
    { 1128, 208, -160},
    { 1208, 360, -144},
    { 1304, 344, -48},
    { 1384, 424, 0},
    { 1392, 512, -16},
    { 1240, 528, 56},
    { 1072, 592, 56},
    { 1184, 584, 56},
    { 1136, 1048, 272},
    { 648, 1136, -296},
    { 680, 896, -336},
    { 1096, 952, -288},
    { 1400, 672, -392},
    { 1352, 400, -400},
    { 1424, 352, -392},
    { 1480, 280, -320},
    { 1432, 256, -272},
    { 1344, 184, -296},
    { 1144, 144, -280},
    { 1120, 48, -256},
    { 664, -328, -88},
    // 60 seconds
    // elapsed: 1 minutes
    { 720, -232, -168},
    { 888, -96, -360},
    { 992, -40, -248},
    { 1424, 176, -432},
    { 1336, 104, -320},
    { 1312, 224, -248},
    { 1448, 352, -176},
    { 1632, 472, -120},
    { 1592, 552, -80},
    { 1552, 624, -48},
    { 1280, 768, 56},
    { 1112, 752, 152},
    { 968, 1072, 168},
    { 776, 832, 40},
    { 848, 768, 16},
    { 952, 680, -40},
    { 1080, 552, -104},
    { 1152, 464, -128},
    { 1384, 352, -176},
    { 1800, 136, -104},
    { 1712, 88, -56},
    { 1528, 64, -208},
    { 1280, 144, -216},
    { 1072, -96, 24},
    { 800, -264, -24},
    // 61 seconds
    { 1088, -128, 8},
    { 1088, 16, -200},
    { 1264, 112, -232},
    { 1128, 192, -336},
    { 944, 32, -232},
    { 992, 184, -176},
    { 1200, 312, -72},
    { 1560, 504, -88},
    { 1736, 800, 8},
    { 1376, 800, 48},
    { 1128, 728, -144},
    { 848, 992, 136},
    { 1032, 1024, 144},
    { 1128, 704, -32},
    { 1176, 712, -8},
    { 1400, 680, -24},
    { 1336, 480, -8},
    { 1224, 280, -64},
    { 1240, 320, 32},
    { 1472, 336, -72},
    { 1576, 152, 72},
    { 1376, 64, 64},
    { 1256, 8, -24},
    { 1144, 64, -72},
    { 912, -232, 72},
    // 62 seconds
    { 760, -224, -88},
    { 1072, 0, -240},
    { 1072, 112, -192},
    { 1016, 248, -312},
    { 904, 144, -248},
    { 1040, 280, -200},
    { 1392, 352, -112},
    { 1968, 720, -272},
    { 1576, 944, -64},
    { 1368, 672, -272},
    { 1000, 968, -184},
    { 824, 1240, -152},
    { 1312, 1072, 48},
    { 1264, 816, -96},
    { 1264, 752, -104},
    { 1408, 592, -48},
    { 1216, 352, -24},
    { 1240, 256, -72},
    { 1512, 312, -88},
    { 1808, 128, 32},
    { 1448, 48, 72},
    { 1392, 80, -72},
    { 1320, 240, -176},
    { 1328, 72, -56},
    { 672, -120, 168},
    // 63 seconds
    { 784, 40, -368},
    { 608, 136, -408},
    { 840, 72, -280},
    { 888, -72, -360},
    { 936, 0, -272},
    { 1296, 280, -328},
    { 1688, 504, -448},
    { 1856, 568, -344},
    { 1688, 800, -408},
    { 1392, 544, -368},
    { 1016, 696, -272},
    { 1040, 776, -208},
    { 1192, 1096, -120},
    { 1248, 968, -200},
    { 1440, 656, -256},
    { 1448, 712, -112},
    { 1336, 560, 16},
    { 1240, 400, 144},
    { 1280, 536, 176},
    { 1456, 560, 200},
    { 1728, 512, 120},
    { 1824, 296, 136},
    { 1416, 312, 64},
    { 1200, -56, -32},
    { 552, -592, 280},
    // 64 seconds
    { 784, -384, -432},
    { 1232, -296, -208},
    { 1232, -192, -40},
    { 1240, 200, -288},
    { 1272, 136, -224},
    { 1520, 424, -192},
    { 1944, 472, -288},
    { 2104, 912, -328},
    { 1840, 432, -280},
    { 1472, 736, -440},
    { 968, 1248, -280},
    { 984, 1080, -112},
    { 1144, 1112, -248},
    { 1176, 736, -168},
    { 1112, 832, -88},
    { 1464, 672, -56},
    { 1576, 344, -40},
    { 1480, 280, -24},
    { 1608, 272, -16},
    { 1616, 224, -8},
    { 1616, 200, -16},
    { 1384, 200, 0},
    { 1320, 200, -8},
    { 1304, 88, 8},
    { 912, -560, 184},
    // 65 seconds
    { 504, -400, -80},
    { 1176, -144, -264},
    { 1272, -96, -72},
    { 1248, 128, -296},
    { 1176, 16, -232},
    { 1336, 264, -296},
    { 1640, 320, -280},
    { 1920, 584, -408},
    { 1728, 720, -256},
    { 1536, 704, -528},
    { 1024, 888, -368},
    { 1016, 792, -272},
    { 1088, 920, -216},
    { 976, 784, -192},
    { 1144, 712, -160},
    { 1360, 512, -128},
    { 1296, 320, -88},
    { 1200, 272, -80},
    { 1288, 232, -56},
    { 1352, 272, -32},
    { 1488, 248, -80},
    { 1728, 216, 32},
    { 1408, 224, -88},
    { 1384, 200, -160},
    { 1000, -504, 72},
    // 66 seconds
    { 488, -360, 80},
    { 896, -160, -368},
    { 1080, -232, 8},
    { 1312, 192, -224},
    { 1280, 48, -208},
    { 1296, 208, -224},
    { 1472, 328, -192},
    { 1640, 456, -296},
    { 1656, 656, -344},
    { 1408, 688, -360},
    { 1104, 824, -528},
    { 920, 904, -424},
    { 1064, 1016, -336},
    { 1040, 752, -224},
    { 1168, 688, -256},
    { 1368, 624, -168},
    { 1560, 408, -136},
    { 1488, 224, -96},
    { 1488, 232, -56},
    { 1456, 224, -64},
    { 1432, 192, -16},
    { 1512, 200, -40},
    { 1424, 192, -48},
    { 1256, 160, -64},
    { 1024, -392, 104},
    // 67 seconds
    { 560, -576, 280},
    { 704, -408, -192},
    { 1304, -192, -64},
    { 1528, -8, -280},
    { 1456, -48, -192},
    { 1344, 128, -192},
    { 1432, 336, -280},
    { 1600, 392, -248},
    { 1720, 472, -392},
    { 1720, 624, -400},
    { 1488, 664, -544},
    { 1120, 744, -672},
    { 864, 784, -584},
    { 1008, 920, -448},
    { 1000, 704, -360},
    { 1224, 632, -248},
    { 1432, 544, -200},
    { 1512, 336, -144},
    { 1432, 248, -88},
    { 1448, 280, -96},
    { 1448, 256, -48},
    { 1480, 240, -40},
    { 1416, 168, -24},
    { 1264, 208, -16},
    { 1144, 136, -80},
    // 68 seconds
    { 1008, -312, 104},
    { 704, -368, 152},
    { 800, -80, -456},
    { 1096, -136, -192},
    { 1304, 168, -288},
    { 1168, -72, -256},
    { 1088, 136, -256},
    { 1256, 352, -280},
    { 1504, 368, -240},
    { 1744, 512, -304},
    { 1632, 720, -240},
    { 1416, 672, -352},
    { 1120, 816, -336},
    { 936, 880, -280},
    { 1040, 912, -216},
    { 1040, 752, -256},
    { 1096, 672, -208},
    { 1288, 536, -192},
    { 1240, 328, -160},
    { 1232, 272, -104},
    { 1328, 296, -104},
    { 1400, 248, -64},
    { 1392, 224, -32},
    { 1432, 168, -16},
    { 1232, 184, -56},
    // 69 seconds
    { 1312, 168, -144},
    { 944, -536, 40},
    { 816, -264, -72},
    { 848, -120, -328},
    { 1200, -144, -144},
    { 1168, 152, -280},
    { 1016, 32, -216},
    { 992, 184, -272},
    { 1208, 272, -200},
    { 1504, 416, -208},
    { 1664, 568, -280},
    { 1408, 672, -176},
    { 1208, 648, -376},
    { 1024, 824, -280},
    { 1136, 1008, -232},
    { 1248, 696, -208},
    { 1144, 736, -272},
    { 1096, 680, -248},
    { 1272, 568, -200},
    { 1232, 232, -96},
    { 1176, 216, -72},
    { 1288, 272, -72},
    { 1368, 296, -48},
    { 1416, 248, -16},
    { 1448, 160, 24},
    // 70 seconds
    { 1224, 224, -40},
    { 1200, 80, -80},
    { 880, -440, 24},
    { 736, -472, 16},
    { 960, -176, -256},
    { 1208, -40, -184},
    { 1200, 136, -264},
    { 1168, 80, -208},
    { 1208, 224, -288},
    { 1432, 312, -280},
    { 1680, 456, -304},
    { 1560, 744, -352},
    { 1392, 464, -352},
    { 1008, 760, -368},
    { 952, 752, -320},
    { 1056, 928, -272},
    { 1192, 808, -264},
    { 1200, 824, -264},
    { 1208, 840, -200},
    { 1656, 664, -88},
    { 1584, 352, 128},
    { 1424, 360, 160},
    { 1472, 416, 88},
    { 1568, 328, 112},
    { 1528, 240, 80},
    // 71 seconds
    { 1416, 208, 40},
    { 1368, 200, -64},
    { 728, -352, -56},
    { 648, -264, -296},
    { 720, -504, -328},
    { 880, -192, -384},
    { 1160, -104, -400},
    { 1200, 32, -280},
    { 1192, 88, -168},
    { 1256, 288, -216},
    { 1472, 472, -160},
    { 1848, 432, -248},
    { 1832, 512, -176},
    { 1776, 672, -184},
    { 1472, 720, -192},
    { 1208, 1008, -168},
    { 1056, 1360, -72},
    { 1192, 1048, -88},
    { 1016, 840, -240},
    { 856, 776, -200},
    { 1064, 696, -104},
    { 1352, 464, -96},
    { 1568, 256, -8},
    { 1760, 320, 0},
    { 1832, 304, -56},
    // 72 seconds
    { 1672, 344, -128},
    { 1624, 232, -96},
    { 1408, 200, -96},
    { 1088, -32, -40},
    { 640, -432, -8},
    { 728, -496, 48},
    { 864, -120, -336},
    { 1016, -96, -88},
    { 1320, 248, -264},
    { 1360, 144, -176},
    { 1480, 256, -240},
    { 1704, 384, -224},
    { 1864, 456, -328},
    { 1768, 576, -272},
    { 1760, 712, -408},
    { 1272, 832, -400},
    { 920, 944, -432},
    { 1008, 1128, -304},
    { 936, 784, -240},
    { 1032, 712, -240},
    { 1208, 616, -208},
    { 1376, 448, -160},
    { 1368, 312, -88},
    { 1416, 272, -96},
    { 1536, 312, -112},
    // 73 seconds
    { 1608, 240, -48},
    { 1624, 216, -56},
    { 1312, 200, -96},
    { 1304, 152, -136},
    { 944, -296, 72},
    { 688, -344, 152},
    { 648, -296, -256},
    { 944, -96, -240},
    { 1264, 128, -96},
    { 1216, 176, -280},
    { 1264, 88, -216},
    { 1400, 296, -216},
    { 1608, 392, -192},
    { 1744, 592, -288},
    { 1576, 576, -296},
    { 1240, 616, -440},
    { 992, 816, -416},
    { 928, 856, -360},
    { 1080, 968, -320},
    { 1080, 760, -288},
    { 1200, 696, -240},
    { 1328, 616, -216},
    { 1472, 400, -120},
    { 1440, 256, -96},
    { 1512, 208, -88},
    // 74 seconds
    { 1488, 208, -48},
    { 1360, 200, -56},
    { 1360, 184, -56},
    { 1288, 192, -40},
    { 1152, 160, -104},
    { 952, -168, 0},
    { 608, -264, 128},
    { 576, -184, -336},
    { 992, -40, -272},
    { 1176, 152, -264},
    { 1176, 24, -256},
    { 1248, 88, -248},
    { 1480, 352, -256},
    { 1720, 440, -248},
    { 1800, 672, -336},
    { 1480, 592, -216},
    { 1224, 648, -344},
    { 920, 840, -232},
    { 1040, 960, -176},
    { 1216, 1048, -152},
    { 1112, 680, -168},
    { 1096, 704, -160},
    { 1216, 640, -120},
    { 1440, 448, -128},
    { 1344, 272, -72},
    // 75 seconds
    { 1376, 216, -80},
    { 1464, 296, -56},
    { 1424, 232, -80},
    { 1240, 208, 0},
    { 1216, 176, -40},
    { 1088, 168, -24},
    { 1008, 80, -104},
    { 824, -272, 64},
    { 608, -192, -312},
    { 840, -88, -368},
    { 1104, 48, -216},
    { 1176, 8, -296},
    { 1208, 96, -240},
    { 1256, 256, -312},
    { 1360, 320, -272},
    { 1552, 360, -248},
    { 1576, 520, -280},
    { 1336, 568, -256},
    { 1056, 624, -336},
    { 968, 744, -280},
    { 1056, 848, -248},
    { 1128, 976, -184},
    { 1048, 664, -224},
    { 1008, 832, -208},
    { 1208, 712, -112},
    // 76 seconds
    { 1552, 504, -40},
    { 1512, 376, -40},
    { 1544, 368, -24},
    { 1528, 328, -16},
    { 1432, 208, -24},
    { 1336, 240, -32},
    { 1312, 160, -40},
    { 1096, -80, -88},
    { 640, -304, -64},
    { 824, -352, -216},
    { 576, -112, -256},
    { 1096, 8, -216},
    { 1152, 96, -248},
    { 1176, 96, -152},
    { 1200, 208, -192},
    { 1384, 328, -136},
    { 1720, 408, -128},
    { 1784, 592, -200},
    { 1616, 744, -152},
    { 1384, 800, -336},
    { 992, 1200, -344},
    { 1160, 1384, -344},
    { 1040, 880, -248},
    { 976, 824, -232},
    { 1008, 720, -112},
    // 77 seconds
    { 1392, 528, -120},
    { 1464, 360, -24},
    { 1536, 336, -16},
    { 1584, 320, -32},
    { 1464, 248, -32},
    { 1328, 224, -32},
    { 1312, 184, -40},
    { 1240, 144, -88},
    { 736, -152, -112},
    { 816, -168, -216},
    { 616, -336, -168},
    { 672, -48, -296},
    { 952, 8, -344},
    { 1096, 120, -224},
    { 1208, 112, -216},
    { 1256, 192, -216},
    { 1528, 344, -160},
    { 1784, 488, -224},
    { 1792, 696, -240},
    { 1488, 656, -320},
    { 1088, 984, -344},
    { 864, 1200, -376},
    { 1072, 1312, -192},
    { 1296, 912, -136},
    { 1136, 808, -136},
    // 78 seconds
    { 1184, 648, -8},
    { 1480, 648, 8},
    { 1800, 352, 80},
    { 1600, 296, 16},
    { 1480, 264, -64},
    { 1440, 248, -24},
    { 1328, 224, 0},
    { 1296, 160, -32},
    { 1144, 56, -80},
    { 640, -536, -32},
    { 792, -304, -272},
    { 1016, -368, -168},
    { 896, -48, -280},
    { 1272, 96, -288},
    { 1304, 96, -264},
    { 1368, 80, -168},
    { 1448, 296, -208},
    { 1632, 512, -144},
    { 1864, 584, -120},
    { 1744, 616, -48},
    { 1560, 776, -80},
    { 1096, 1152, -104},
    { 920, 1344, -136},
    { 1024, 1296, -112},
    { 992, 992, -152},
    // 79 seconds
    { 1160, 800, -64},
    { 1536, 704, -16},
    { 1752, 344, -48},
    { 1592, 312, -48},
    { 1576, 272, -32},
    { 1544, 280, -16},
    { 1632, 256, -96},
    { 1624, 216, -56},
    { 1384, 64, -88},
    { 920, -272, -56},
    { 720, -512, -160},
    { 656, -640, 80},
    { 1000, -88, -256},
    { 1168, -88, -144},
    { 1368, 368, -224},
    { 1304, 112, -104},
    { 1504, 232, -88},
    { 1672, 664, -96},
    { 1776, 760, -160},
    { 1584, 1144, -208},
    { 1168, 1216, -168},
    { 704, 1160, -448},
    { 504, 1280, -400},
    { 896, 1200, -256},
    { 1104, 952, -64},
    // 80 seconds
    { 1408, 648, -208},
    { 1512, 664, -64},
    { 1552, 512, -32},
    { 1472, 352, -88},
    { 1496, 376, -56},
    { 1440, 360, 0},
    { 1456, 376, -8},
    { 1280, 288, 8},
    { 1280, 136, 0},
    { 856, -32, -32},
    { 776, -160, 40},
    { 456, -160, -176},
    { 744, 64, -336},
    { 896, 32, -208},
    { 1128, 152, -288},
    { 1248, 112, -224},
    { 1584, 352, -328},
    { 1856, 352, -232},
    { 1936, 640, -336},
    { 1624, 512, -376},
    { 1272, 888, -704},
    { 968, 912, -560},
    { 1128, 1120, -568},
    { 1016, 696, -336},
    { 1024, 832, -256},
    // 81 seconds
    { 1256, 624, -160},
    { 1360, 400, -128},
    { 1272, 304, -104},
    { 1272, 336, -104},
    { 1360, 344, -56},
    { 1456, 336, -64},
    { 1416, 264, -96},
    { 1384, 176, -136},
    { 1120, -24, -32},
    { 768, -360, 16},
    { 800, -232, -40},
    { 920, -32, -400},
    { 1208, -40, -136},
    { 1224, 112, -288},
    { 1200, 56, -232},
    { 1128, 256, -264},
    { 1336, 336, -280},
    { 1560, 384, -280},
    { 1808, 600, -368},
    { 1472, 960, -344},
    { 1152, 824, -528},
    { 856, 1288, -368},
    { 1088, 928, -112},
    { 1080, 688, -192},
    { 1176, 584, -120},
    // 82 seconds
    { 1256, 600, -88},
    { 1296, 416, -72},
    { 1344, 392, -48},
    { 1472, 368, -40},
    { 1480, 392, 8},
    { 1464, 344, -72},
    { 1392, 272, -128},
    { 1080, 176, -88},
    { 856, -168, -48},
    { 768, -240, -32},
    { 792, -248, -232},
    { 1048, 32, -384},
    { 1296, 152, -408},
    { 1144, 16, -312},
    { 1128, 72, -256},
    { 1200, 304, -296},
    { 1384, 400, -240},
    { 1544, 456, -280},
    { 1560, 520, -240},
    { 1344, 568, -240},
    { 1064, 680, -280},
    { 952, 856, -160},
    { 1064, 1272, -88},
    { 1152, 832, -112},
    { 1088, 664, -192},
    // 83 seconds
    { 1088, 712, -32},
    { 1440, 608, 0},
    { 1408, 352, 8},
    { 1464, 368, 0},
    { 1640, 360, -32},
    { 1560, 328, 16},
    { 1424, 232, -48},
    { 1296, 192, -56},
    { 1224, 200, -176},
    { 816, -168, -136},
    { 888, -168, -168},
    { 600, -440, -264},
    { 960, 16, -456},
    { 1072, -32, -408},
    { 1168, 80, -320},
    { 1208, 72, -208},
    { 1352, 376, -224},
    { 1576, 488, -120},
    { 1840, 552, -104},
    { 1736, 712, 24},
    { 1504, 640, 0},
    { 1144, 896, 16},
    { 904, 1120, 112},
    { 848, 1312, 56},
    { 1032, 872, 0},
    // 84 seconds
    { 1016, 856, -16},
    { 1112, 672, 40},
    { 1448, 592, -16},
    { 1656, 400, 16},
    { 1608, 336, -24},
    { 1624, 304, -80},
    { 1552, 216, -24},
    { 1416, 272, -32},
    { 1392, 176, -80},
    { 1104, 120, -104},
    { 896, -216, -32},
    { 584, -224, -96},
    { 808, -272, -136},
    { 936, -24, -304},
    { 1136, 128, -240},
    { 1288, 184, -264},
    { 1432, 240, -168},
    { 1512, 328, -192},
    { 1584, 440, -120},
    { 1608, 600, -112},
    { 1568, 536, -32},
    { 1288, 752, -32},
    { 976, 856, -32},
    { 944, 1016, 64},
    { 1064, 952, 168},
    // 85 seconds
    { 1048, 728, 40},
    { 1056, 672, 72},
    { 1152, 568, 48},
    { 1288, 496, -32},
    { 1352, 328, -16},
    { 1368, 352, -24},
    { 1480, 296, -8},
    { 1480, 296, 24},
    { 1264, 192, 16},
    { 1200, 192, -16},
    { 1152, 192, -24},
    { 1032, 16, -24},
    { 1016, -408, 168},
    { 944, -376, -320},
    { 1120, -136, -208},
    { 1288, -8, -184},
    { 1344, 232, -200},
    { 1320, 304, -240},
    { 1552, 440, -224},
    { 1648, 496, -128},
    { 1488, 808, -64},
    { 1472, 408, -96},
    { 1184, 712, 0},
    { 984, 824, 24},
    { 1112, 816, 64},
    // 86 seconds
    { 1160, 976, -56},
    { 992, 552, -128},
    { 816, 720, -168},
    { 944, 688, -104},
    { 1320, 536, -96},
    { 1448, 352, -48},
    { 1584, 296, -72},
    { 1600, 272, 40},
    { 1496, 168, 0},
    { 1432, 32, 0},
    { 1200, 112, -24},
    { 1232, 168, -104},
    { 936, -328, 24},
    { 1056, -208, 200},
    { 792, -168, -312},
    { 992, -40, -176},
    { 1216, 240, -240},
    { 1160, 72, -184},
    { 1120, 80, -224},
    { 1280, 288, -200},
    { 1536, 392, -256},
    { 1720, 568, -200},
    { 1544, 768, -192},
    { 1272, 624, -208},
    { 952, 984, -168},
    // 87 seconds
    { 952, 1008, -72},
    { 1032, 912, -80},
    { 1008, 672, -112},
    { 1096, 672, -96},
    { 1368, 600, -56},
    { 1400, 360, -32},
    { 1384, 328, -32},
    { 1496, 352, -40},
    { 1488, 264, -32},
    { 1416, 208, -40},
    { 1368, 144, -40},
    { 1232, 120, -80},
    { 968, -168, -72},
    { 1008, -232, 40},
    { 736, -296, -184},
    { 848, 24, -384},
    { 1144, 120, -232},
    { 1104, 104, -224},
    { 1160, 72, -168},
    { 1232, 304, -208},
    { 1464, 392, -152},
    { 1592, 480, -176},
    { 1632, 608, -176},
    { 1400, 552, -176},
    { 1104, 864, -216},
    // 88 seconds
    { 920, 1168, -160},
    { 1128, 1192, -56},
    { 1152, 648, -120},
    { 952, 736, -128},
    { 992, 664, -40},
    { 1392, 520, -80},
    { 1520, 344, -40},
    { 1544, 328, -40},
    { 1520, 256, -40},
    { 1432, 208, -64},
    { 1360, 168, -96},
    { 1264, 168, -96},
    { 1248, 88, -176},
    { 744, -328, -80},
    { 856, -264, -96},
    { 840, -344, -224},
    { 904, 8, -368},
    { 1240, 16, -288},
    { 1448, 136, -312},
    { 1400, 128, -176},
    { 1368, 328, -160},
    { 1592, 528, -224},
    { 1744, 496, -168},
    { 1616, 592, -80},
    { 1472, 528, -88},
    // 89 seconds
    { 1216, 616, -96},
    { 1008, 728, -48},
    { 1040, 1160, -168},
    { 896, 784, -200},
    { 544, 584, -256},
    { 632, 704, -520},
    { 1144, 408, -616},
    { 1728, 224, -640},
    { 2136, 48, -480},
    { 1992, 0, -488},
    { 1528, -16, -440},
    { 1088, -24, -320},
    { 864, -96, -304},
    { 728, -256, -176},
    { 512, -280, -152},
    { 672, -128, -176},
    { 1144, 184, -80},
    { 1048, 32, -192},
    { 1448, 432, -240},
    { 1696, 280, -344},
    { 1888, 288, 208},
    { 1912, 528, 72},
    { 1736, 552, -32},
    { 1448, 440, 128},
    { 1288, 648, 72},
    // 90 seconds
    { 1016, 520, 144},
    { 600, 752, 96},
    { 432, 800, -72},
    { 672, 1096, 0},
    { 888, 896, -176},
    { 1096, 904, -336},
    { 1336, 848, -520},
    { 1456, 768, -720},
    { 1360, 504, -848},
    { 1120, 208, -784},
    { 952, 48, -648},
    { 848, 40, -432},
    { 776, -80, -312},
    { 728, -96, -200},
    { 760, 0, -216},
    { 1168, 104, -48},
    { 1152, 40, -80},
    { 1600, 264, -336},
    { 1744, 248, -280},
    { 1544, 224, -144},
    { 1504, 312, -168},
    { 1448, 472, -136},
    { 1352, 664, -40},
    { 1216, 656, -32},
    { 928, 872, 32},
    // 91 seconds
    { 552, 1192, 24},
    { 544, 960, -8},
    { 840, 960, -24},
    { 1216, 800, 24},
    { 1608, 688, 64},
    { 1736, 536, -32},
    { 1696, 400, -96},
    { 1616, 320, -104},
    { 1672, 272, -104},
    { 1728, 208, -176},
    { 1664, 160, -88},
    { 1448, 144, -192},
    { 1152, -328, 16},
    { 512, -448, -48},
    { 1048, -416, 8},
    { 1008, -96, -160},
    { 1216, 112, -288},
    { 1352, 280, -224},
    { 1392, 224, -232},
    { 1504, 296, -160},
    { 1712, 472, -128},
    { 1592, 656, -56},
    { 1456, 536, -200},
    { 1288, 744, -176},
    { 968, 1224, -120},
    // 92 seconds
    { 832, 1112, -152},
    { 872, 1120, -264},
    { 984, 992, -24},
    { 1240, 888, 24},
    { 1624, 696, 96},
    { 1944, 528, 24},
    { 1704, 344, -40},
    { 1584, 304, -64},
    { 1488, 248, -40},
    { 1472, 208, -32},
    { 1432, 128, -48},
    { 1288, 144, -64},
    { 992, -168, -32},
    { 408, -496, 40},
    { 1096, -312, -104},
    { 960, -128, -336},
    { 1224, 16, -224},
    { 1376, 264, -344},
    { 1256, 144, -112},
    { 1344, 224, -128},
    { 1576, 344, -136},
    { 1792, 584, -136},
    { 1856, 752, -184},
    { 1704, 728, -120},
    { 1280, 976, -272},
    // 93 seconds
    { 872, 1248, -320},
    { 848, 1368, -304},
    { 1024, 824, -160},
    { 1160, 816, -136},
    { 1328, 696, -72},
    { 1656, 528, -56},
    { 1576, 336, -48},
    { 1520, 256, -120},
    { 1512, 232, -120},
    { 1560, 216, -32},
    { 1480, 136, -80},
    { 1400, 152, -56},
    { 1136, -128, -80},
    { 592, -448, 8},
    { 848, -504, -8},
    { 904, -184, -304},
    { 1184, -64, -160},
    { 1400, 304, -264},
    { 1296, 168, -176},
    { 1360, 248, -200},
    { 1608, 400, -104},
    { 1784, 576, -176},
    { 1624, 592, -168},
    { 1504, 752, -296},
    { 1112, 1000, -432},
    // 94 seconds
    { 872, 1000, -432},
    { 1040, 1216, -376},
    { 1056, 768, -192},
    { 1144, 760, -200},
    { 1376, 656, -128},
    { 1632, 480, -80},
    { 1440, 280, -24},
    { 1416, 272, -40},
    { 1368, 240, -8},
    { 1392, 224, 24},
    { 1456, 192, -8},
    { 1448, 144, -32},
    { 1136, -112, -64},
    { 784, -304, -104},
    { 1056, -368, -32},
    { 752, -112, -320},
    { 1248, -112, -168},
    { 1208, 144, -168},
    { 1208, 96, -144},
    { 1240, 192, -160},
    { 1456, 416, -136},
    { 1736, 496, -192},
    { 1784, 776, -176},
    { 1648, 640, -176},
    { 1352, 904, -456},
    // 95 seconds
    { 904, 1264, -440},
    { 960, 1264, -384},
    { 984, 752, -272},
    { 1072, 688, -224},
    { 1272, 688, -120},
    { 1616, 536, -80},
    { 1560, 288, -72},
    { 1552, 240, -96},
    { 1584, 264, -88},
    { 1536, 168, -56},
    { 1400, 152, -48},
    { 1352, 144, -88},
    { 1072, -304, 120},
    { 688, -344, 16},
    { 880, -408, -8},
    { 1024, -8, -184},
    { 1240, -24, -128},
    { 1288, 240, -256},
    { 1144, 48, -208},
    { 1248, 216, -192},
    { 1552, 336, -176},
    { 1784, 528, -168},
    { 1792, 768, -160},
    { 1496, 848, -296},
    { 1112, 1104, -336},
    // 96 seconds
    { 928, 1352, -296},
    { 1088, 896, -88},
    { 1192, 848, -224},
    { 1184, 752, -96},
    { 1456, 784, -32},
    { 1520, 440, 96},
    { 1400, 312, 0},
    { 1480, 272, -24},
    { 1640, 288, -24},
    { 1728, 216, -8},
    { 1600, 184, -72},
    { 1424, 160, -104},
    { 832, -288, -8},
    { 776, -232, -80},
    { 432, -344, -40},
    { 840, 64, -352},
    { 856, -72, -104},
    { 1208, 288, -312},
    { 1440, 144, -144},
    { 1512, 480, -240},
    { 1640, 664, -304},
    { 1592, 800, -328},
    { 1552, 664, -104},
    { 1392, 768, -224},
    { 1024, 816, -232},
    // 97 seconds
    { 904, 808, -200},
    { 1104, 1016, -120},
    { 1080, 840, -112},
    { 1136, 688, -32},
    { 1216, 616, -64},
    { 1144, 392, -8},
    { 1152, 400, -72},
    { 1312, 296, -88},
    { 1376, 288, -72},
    { 1536, 192, -96},
    { 1592, 152, -16},
    { 1480, 120, -112},
    { 952, -376, 32},
    { 944, -192, 96},
    { 704, -232, -144},
    { 952, 24, -328},
    { 1120, 72, -168},
    { 1112, 200, -232},
    { 1080, 56, -216},
    { 1160, 312, -232},
    { 1456, 448, -248},
    { 1600, 720, -256},
    { 1488, 528, -224},
    { 1248, 688, -392},
    { 952, 792, -344},
    // 98 seconds
    { 928, 768, -336},
    { 1152, 816, -328},
    { 1112, 672, -272},
    { 1144, 576, -208},
    { 1280, 568, -176},
    { 1264, 352, -64},
    { 1256, 256, -72},
    { 1288, 232, -8},
    { 1320, 208, 16},
    { 1368, 200, -16},
    { 1488, 152, 40},
    { 1288, 136, 32},
    { 1016, -64, -64},
    { 968, -64, 72},
    { 560, -136, -240},
    { 904, 64, -312},
    { 984, 40, -184},
    { 1056, 168, -264},
    { 1072, 104, -272},
    { 1184, 336, -248},
    { 1440, 448, -200},
    { 1600, 544, -272},
    { 1592, 664, -296},
    { 1296, 856, -296},
    { 1096, 936, -392},
    // 99 seconds
    { 1088, 1096, -304},
    { 928, 832, -152},
    { 968, 664, -216},
    { 1200, 664, -112},
    { 1488, 560, -104},
    { 1360, 320, -72},
    { 1320, 280, -104},
    { 1384, 168, -48},
    { 1336, 208, -40},
    { 1312, 192, -56},
    { 1328, 112, 0},
    { 1200, 104, 48},
    { 984, 56, -56},
    { 1192, 48, -64},
    { 728, -40, -104},
    { 696, 152, -344},
    { 680, 200, -360},
    { 848, 328, -432},
    { 824, 456, -336},
    { 768, 704, -384},
    { 720, 896, -248},
    { 696, 1096, -184},
    { 632, 1184, -192},
    { 464, 1216, -80},
    { 280, 1288, -32},
    // 100 seconds
    { 280, 1328, 16},
    { 304, 1464, 120},
    { 704, 1576, 80},
    { 912, 1424, 72},
    { 840, 1312, 88},
    { 1024, 1232, 56},
    { 984, 1000, 48},
    { 816, 888, 56},
    { 792, 896, 104},
    { 760, 792, 160},
    { 680, 704, 112},
    { 624, 592, 72},
    { 472, 440, 104},
    { 328, 336, 136},
    { 184, 280, 216},
    { 64, 728, 488},
    { -240, 936, 760},
    { -280, 1160, 912},
    { -240, 1280, 720},
    { -376, 1120, 840},
    { -472, 1040, 728},
    { -384, 768, 672},
    { -416, 576, 520},
    { -368, 576, 472},
    { -376, 504, 600},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



