/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:58:23 local
AccelRawData *activity_sample_walk_100_pbl_25663_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25663_4
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 125
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -248, -440, -952},
    { -240, -408, -1024},
    { -288, -528, -968},
    { -224, -496, -944},
    { -264, -608, -856},
    { -128, -496, -984},
    { -456, -504, -856},
    { -312, -560, -824},
    { -304, -624, -816},
    { -288, -592, -888},
    { -352, -600, -872},
    { -328, -592, -896},
    { -144, -576, -912},
    { -128, -616, -880},
    { -224, -616, -864},
    { -152, -600, -840},
    { -144, -576, -864},
    { -360, -720, -552},
    { -208, -568, -808},
    { -144, -576, -856},
    { -224, -520, -880},
    { -192, -528, -896},
    { -152, -480, -944},
    { -160, -472, -960},
    { -160, -504, -960},
    // 1 seconds
    { -216, -496, -928},
    { -232, -464, -928},
    { -280, -544, -896},
    { -232, -520, -904},
    { -176, -496, -904},
    { -160, -512, -904},
    { -144, -480, -888},
    { -184, -464, -896},
    { -192, -544, -912},
    { -224, -456, -944},
    { -304, -456, -984},
    { -264, -496, -1000},
    { -256, -480, -944},
    { -232, -536, -896},
    { -144, -544, -856},
    { -104, -456, -768},
    { 40, -40, -776},
    { -280, 280, -800},
    { -384, 384, -848},
    { -360, 600, -840},
    { -376, 696, -800},
    { -448, 696, -736},
    { -448, 688, -608},
    { -392, 800, -400},
    { -400, 744, -392},
    // 2 seconds
    { -544, 752, -408},
    { -496, 776, -384},
    { -464, 808, -256},
    { -408, 728, -240},
    { -344, 664, -272},
    { -352, 696, -224},
    { -616, 952, -344},
    { -1056, 944, -472},
    { -1160, 1152, -488},
    { -944, 1032, -480},
    { -704, 1296, -472},
    { -384, 1376, -624},
    { -56, 472, -808},
    { -160, 120, -552},
    { -144, 0, -792},
    { 80, -176, -928},
    { -64, -416, -768},
    { -24, -464, -832},
    { 16, -336, -856},
    { -8, -384, -824},
    { -32, -336, -792},
    { -88, -592, -800},
    { -128, -728, -856},
    { -72, -592, -1032},
    { 88, -816, -1144},
    // 3 seconds
    { 120, -896, -1152},
    { 104, -280, -1208},
    { 128, -312, -1136},
    { 240, -288, -976},
    { 264, -168, -872},
    { 160, -328, -792},
    { 120, -392, -784},
    { 48, -456, -736},
    { -32, -424, -760},
    { -136, -464, -800},
    { -120, -440, -848},
    { -80, -560, -864},
    { -88, -528, -936},
    { -96, -360, -1072},
    { -72, -528, -1160},
    { -184, -576, -1200},
    { -176, -216, -1400},
    { -288, -32, -1320},
    { -352, 56, -1008},
    { -504, 216, -920},
    { -216, 64, -928},
    { -248, -184, -808},
    { -288, -184, -800},
    { -304, -80, -800},
    { -304, -288, -768},
    // 4 seconds
    { -336, -288, -792},
    { -400, -192, -880},
    { -448, -328, -936},
    { -456, -200, -1112},
    { -424, -304, -1296},
    { -304, -208, -1312},
    { -96, -120, -1296},
    { -200, -368, -1008},
    { -88, -96, -1008},
    { -96, -160, -944},
    { -104, -296, -896},
    { -168, -272, -816},
    { -240, -376, -752},
    { -248, -400, -728},
    { -232, -416, -768},
    { -240, -392, -824},
    { -216, -432, -848},
    { -176, -448, -888},
    { -152, -408, -904},
    { -272, -256, -936},
    { -528, 80, -1080},
    { -552, 328, -1064},
    { -760, 640, -880},
    { -864, 736, -760},
    { -776, 656, -768},
    // 5 seconds
    { -600, 432, -792},
    { -512, 392, -776},
    { -472, 352, -696},
    { -384, 216, -584},
    { -320, 96, -440},
    { -304, 104, -336},
    { -192, 248, -288},
    { 144, 376, -264},
    { 776, 528, -384},
    { 1160, 760, -328},
    { 1376, 512, -280},
    { 1856, 720, -416},
    { 1856, 664, -168},
    { 1440, 576, -152},
    { 1040, 560, -176},
    { 968, 520, -104},
    { 928, 576, -8},
    { 920, 536, 24},
    { 832, 608, 8},
    { 704, 728, -24},
    { 840, 824, -88},
    { 848, 648, -144},
    { 1184, 872, -200},
    { 1144, 712, -176},
    { 1160, 584, -328},
    // 6 seconds
    { 1136, 544, -264},
    { 1144, 536, -152},
    { 1096, 376, -96},
    { 952, 384, -64},
    { 952, 392, -72},
    { 992, 400, -56},
    { 984, 400, -64},
    { 936, 344, -112},
    { 864, 304, -112},
    { 696, 248, -192},
    { 560, 192, -312},
    { 832, 248, -200},
    { 800, 192, -440},
    { 960, 352, -592},
    { 1296, 352, -528},
    { 1168, 296, -344},
    { 976, 456, -288},
    { 968, 464, -200},
    { 1064, 584, -144},
    { 1080, 576, -64},
    { 984, 656, -80},
    { 816, 680, -136},
    { 824, 744, -88},
    { 888, 776, -88},
    { 1056, 856, -128},
    // 7 seconds
    { 1256, 744, -96},
    { 1192, 584, -160},
    { 1160, 528, -152},
    { 1176, 496, -128},
    { 1184, 272, -128},
    { 1000, 312, -152},
    { 1144, 216, -168},
    { 1072, 272, -112},
    { 1008, 240, -112},
    { 920, 224, -112},
    { 832, 168, -96},
    { 736, 208, -152},
    { 512, 168, -296},
    { 664, 208, -224},
    { 768, 256, -328},
    { 928, 296, -496},
    { 1432, 440, -560},
    { 1408, 328, -352},
    { 1096, 360, -176},
    { 800, 488, -208},
    { 960, 440, -296},
    { 896, 576, -216},
    { 808, 672, -248},
    { 720, 696, -256},
    { 768, 760, -256},
    // 8 seconds
    { 896, 648, -232},
    { 1448, 856, -160},
    { 1328, 592, -88},
    { 1304, 560, -208},
    { 1216, 520, -168},
    { 1096, 368, -168},
    { 840, 256, -168},
    { 880, 216, -184},
    { 984, 232, -152},
    { 928, 256, -128},
    { 896, 160, -144},
    { 888, 168, -136},
    { 840, 168, -152},
    { 576, 104, -272},
    { 784, 216, -192},
    { 848, 184, -272},
    { 1016, 336, -472},
    { 1624, 384, -536},
    { 1344, 288, -304},
    { 936, 400, -320},
    { 864, 456, -232},
    { 920, 488, -216},
    { 888, 608, -144},
    { 920, 632, -152},
    { 920, 840, -136},
    // 9 seconds
    { 872, 760, -144},
    { 936, 832, -192},
    { 1200, 864, -32},
    { 1504, 744, -96},
    { 1424, 648, -128},
    { 1344, 440, -200},
    { 1112, 320, -152},
    { 1088, 248, -168},
    { 1064, 248, -136},
    { 1016, 184, -168},
    { 1024, 192, -176},
    { 1168, 168, -152},
    { 1048, 104, -176},
    { 840, 40, -232},
    { 664, -24, -200},
    { 624, 112, -472},
    { 1200, 184, -528},
    { 1376, 272, -408},
    { 1144, 328, -248},
    { 944, 432, -208},
    { 1040, 496, -192},
    { 1272, 584, -176},
    { 1248, 696, -96},
    { 1168, 728, -120},
    { 1040, 864, -88},
    // 10 seconds
    { 1072, 848, -88},
    { 1000, 824, -88},
    { 968, 688, -120},
    { 1056, 656, -120},
    { 1152, 528, -120},
    { 992, 416, -144},
    { 944, 280, -136},
    { 968, 304, -80},
    { 1160, 240, -120},
    { 1136, 224, -104},
    { 1240, 224, -120},
    { 1240, 208, -120},
    { 1064, 104, -176},
    { 800, -80, -208},
    { 720, -144, -136},
    { 888, 104, -424},
    { 1096, 208, -376},
    { 1080, 248, -392},
    { 856, 232, -288},
    { 808, 336, -256},
    { 936, 384, -224},
    { 1024, 496, -248},
    { 1216, 672, -256},
    { 1216, 920, -224},
    { 1168, 856, -304},
    // 11 seconds
    { 992, 824, -232},
    { 1024, 840, -136},
    { 896, 656, -128},
    { 952, 568, -112},
    { 1104, 512, -88},
    { 1080, 376, -120},
    { 960, 280, -80},
    { 976, 312, -96},
    { 1120, 240, -104},
    { 1136, 232, -112},
    { 1144, 184, -136},
    { 1184, 200, -184},
    { 952, -80, -168},
    { 544, -208, -232},
    { 840, -168, -136},
    { 1008, 104, -296},
    { 1248, 280, -440},
    { 1224, 288, -312},
    { 1080, 280, -248},
    { 976, 336, -248},
    { 1008, 464, -248},
    { 976, 560, -272},
    { 984, 640, -288},
    { 912, 736, -304},
    { 912, 792, -328},
    // 12 seconds
    { 960, 696, -256},
    { 1264, 824, -216},
    { 1144, 624, -168},
    { 1216, 608, -152},
    { 1256, 568, -136},
    { 1152, 464, -136},
    { 1048, 408, -112},
    { 1096, 448, -136},
    { 1136, 560, -152},
    { 1064, 496, -176},
    { 1000, 456, -240},
    { 912, 200, -248},
    { 720, -80, -328},
    { 672, -144, -176},
    { 560, -272, -240},
    { 760, -160, -368},
    { 1032, -88, -328},
    { 1096, -8, -264},
    { 1024, 96, -328},
    { 968, 208, -328},
    { 1080, 256, -304},
    { 1312, 408, -424},
    { 1480, 392, -552},
    { 1440, 552, -488},
    { 1336, 504, -608},
    // 13 seconds
    { 1144, 520, -648},
    { 1240, 704, -680},
    { 808, 624, -536},
    { 984, 656, -568},
    { 1104, 488, -464},
    { 1088, 360, -376},
    { 944, 248, -248},
    { 952, 216, -232},
    { 1048, 296, -208},
    { 1200, 280, -176},
    { 1344, 312, -176},
    { 1472, 296, -152},
    { 1184, 216, -120},
    { 784, 48, -160},
    { 712, -104, -8},
    { 688, -96, -216},
    { 808, -48, -376},
    { 1136, 64, -312},
    { 1080, 152, -368},
    { 936, 112, -432},
    { 960, 216, -360},
    { 1184, 344, -416},
    { 1328, 496, -576},
    { 1144, 696, -624},
    { 1000, 632, -688},
    // 14 seconds
    { 944, 632, -592},
    { 1072, 584, -456},
    { 1320, 696, -408},
    { 1184, 600, -280},
    { 1288, 520, -264},
    { 1312, 360, -232},
    { 1032, 320, -176},
    { 888, 216, -224},
    { 920, 200, -232},
    { 1064, 240, -184},
    { 1152, 144, -184},
    { 1072, 152, -208},
    { 1040, 144, -208},
    { 792, 96, -264},
    { 912, 80, -224},
    { 720, 24, -240},
    { 736, 32, -464},
    { 960, 24, -504},
    { 1136, 128, -400},
    { 1000, 80, -400},
    { 1016, 216, -352},
    { 1168, 376, -328},
    { 1320, 560, -440},
    { 1184, 728, -384},
    { 1064, 664, -480},
    // 15 seconds
    { 904, 784, -464},
    { 1232, 928, -448},
    { 1280, 736, -256},
    { 1336, 616, -352},
    { 1152, 576, -312},
    { 1128, 464, -272},
    { 1008, 320, -176},
    { 976, 272, -184},
    { 1016, 224, -200},
    { 1136, 272, -128},
    { 1224, 224, -152},
    { 1344, 216, -152},
    { 1344, 200, -128},
    { 880, 48, -152},
    { 688, -24, -104},
    { 448, -24, -168},
    { 480, 56, -424},
    { 912, 256, -480},
    { 1200, 240, -376},
    { 1168, 88, -416},
    { 1080, 288, -256},
    { 1184, 368, -464},
    { 1296, 632, -472},
    { 1192, 608, -408},
    { 1064, 632, -496},
    // 16 seconds
    { 1000, 736, -456},
    { 1280, 808, -376},
    { 1200, 712, -296},
    { 1232, 632, -288},
    { 1096, 568, -224},
    { 928, 464, -224},
    { 784, 312, -208},
    { 888, 256, -248},
    { 1056, 192, -208},
    { 1200, 240, -200},
    { 1272, 120, -144},
    { 1240, 160, -120},
    { 1128, 152, -96},
    { 832, 96, -80},
    { 712, 16, -144},
    { 664, 16, -104},
    { 784, 56, -360},
    { 1040, 168, -328},
    { 1128, 232, -376},
    { 952, 152, -328},
    { 912, 288, -272},
    { 1088, 360, -240},
    { 1328, 472, -312},
    { 1288, 720, -320},
    { 1080, 728, -456},
    // 17 seconds
    { 1008, 888, -488},
    { 1016, 808, -368},
    { 1184, 816, -288},
    { 984, 608, -280},
    { 1104, 584, -216},
    { 1184, 512, -192},
    { 1112, 344, -168},
    { 1024, 280, -160},
    { 1024, 240, -160},
    { 1136, 208, -160},
    { 1232, 208, -120},
    { 1160, 128, -128},
    { 1208, 168, -168},
    { 984, 112, -176},
    { 880, -72, -56},
    { 496, -88, -256},
    { 616, 16, -464},
    { 1072, 32, -424},
    { 1136, 104, -392},
    { 960, 88, -336},
    { 992, 280, -344},
    { 1088, 360, -304},
    { 1248, 448, -360},
    { 1304, 552, -376},
    { 1040, 632, -504},
    // 18 seconds
    { 1000, 752, -584},
    { 1032, 688, -480},
    { 1128, 784, -456},
    { 912, 680, -392},
    { 1040, 600, -304},
    { 1240, 496, -256},
    { 1168, 344, -216},
    { 1024, 272, -192},
    { 1000, 248, -184},
    { 1136, 208, -176},
    { 1208, 216, -168},
    { 1104, 136, -144},
    { 1080, 152, -176},
    { 976, 96, -184},
    { 952, 56, -152},
    { 672, -24, -152},
    { 496, 0, -480},
    { 952, 40, -416},
    { 1120, 80, -408},
    { 952, 16, -352},
    { 920, 192, -328},
    { 1056, 336, -328},
    { 1256, 440, -344},
    { 1288, 568, -320},
    { 1048, 688, -368},
    // 19 seconds
    { 1064, 784, -408},
    { 1024, 768, -272},
    { 1224, 896, -240},
    { 984, 696, -208},
    { 976, 600, -216},
    { 944, 536, -176},
    { 880, 424, -168},
    { 792, 360, -184},
    { 912, 312, -176},
    { 1200, 256, -200},
    { 1376, 208, -120},
    { 1320, 184, -152},
    { 1216, 168, -176},
    { 1008, 168, -240},
    { 864, 72, -208},
    { 560, -32, -208},
    { 408, -56, -384},
    { 832, 8, -368},
    { 1104, 168, -400},
    { 880, 104, -368},
    { 792, 208, -304},
    { 936, 280, -264},
    { 1256, 376, -280},
    { 1264, 568, -288},
    { 1040, 624, -344},
    // 20 seconds
    { 1024, 664, -376},
    { 1048, 720, -400},
    { 1184, 928, -344},
    { 1088, 760, -248},
    { 1000, 656, -256},
    { 1040, 616, -216},
    { 1112, 536, -168},
    { 1000, 376, -152},
    { 976, 352, -136},
    { 1064, 392, -136},
    { 1200, 400, -184},
    { 1208, 264, -208},
    { 1144, 240, -192},
    { 952, 96, -168},
    { 784, 48, -200},
    { 768, 8, -120},
    { 376, -72, -368},
    { 800, 72, -352},
    { 1216, 88, -352},
    { 1104, 112, -416},
    { 992, 240, -480},
    { 968, 168, -376},
    { 1152, 264, -432},
    { 1320, 384, -488},
    { 1200, 456, -544},
    // 21 seconds
    { 960, 520, -672},
    { 1024, 600, -672},
    { 1192, 680, -616},
    { 1176, 680, -632},
    { 1032, 600, -496},
    { 1048, 480, -440},
    { 1136, 376, -432},
    { 1080, 248, -320},
    { 1008, 168, -248},
    { 1032, 192, -256},
    { 1200, 240, -248},
    { 1304, 136, -192},
    { 1312, 128, -152},
    { 1216, 120, -192},
    { 768, -128, -80},
    { 848, -144, 8},
    { 552, -160, -288},
    { 744, -24, -352},
    { 1152, -40, -352},
    { 1104, 8, -392},
    { 864, 80, -408},
    { 952, 192, -368},
    { 1184, 400, -416},
    { 1320, 496, -464},
    { 1320, 536, -560},
    // 22 seconds
    { 1080, 528, -560},
    { 1032, 552, -704},
    { 1040, 568, -648},
    { 1152, 784, -664},
    { 1000, 656, -528},
    { 1032, 544, -448},
    { 1168, 456, -376},
    { 1120, 232, -312},
    { 984, 136, -232},
    { 944, 104, -232},
    { 1080, 232, -248},
    { 1224, 96, -192},
    { 1224, 160, -208},
    { 1248, 112, -248},
    { 928, -72, -168},
    { 840, -176, -104},
    { 584, -144, -224},
    { 656, 48, -376},
    { 1176, 0, -360},
    { 1248, 104, -416},
    { 1008, 120, -416},
    { 952, 232, -352},
    { 1032, 344, -360},
    { 1152, 384, -408},
    { 1144, 528, -472},
    // 23 seconds
    { 1016, 640, -568},
    { 1072, 848, -664},
    { 1024, 752, -520},
    { 1152, 928, -504},
    { 1024, 616, -392},
    { 1136, 624, -344},
    { 1400, 576, -304},
    { 1448, 432, -264},
    { 1248, 272, -232},
    { 1104, 224, -192},
    { 1040, 144, -200},
    { 1008, 192, -240},
    { 1128, 120, -240},
    { 1216, 104, -200},
    { 1104, 64, -168},
    { 672, -88, -88},
    { 632, -88, -136},
    { 424, -104, -288},
    { 760, 40, -352},
    { 1224, 112, -480},
    { 1488, 144, -416},
    { 1288, 240, -424},
    { 1240, 344, -432},
    { 1392, 432, -424},
    { 1416, 544, -408},
    // 24 seconds
    { 1280, 536, -576},
    { 1160, 712, -720},
    { 1008, 816, -688},
    { 1000, 1016, -720},
    { 872, 840, -560},
    { 1160, 728, -416},
    { 1456, 600, -352},
    { 1376, 424, -272},
    { 1200, 344, -208},
    { 1192, 176, -208},
    { 1200, 312, -152},
    { 1296, 200, -184},
    { 1264, 144, -120},
    { 1160, 152, -128},
    { 1016, 120, -176},
    { 960, 88, -200},
    { 592, -144, 32},
    { 520, -128, -384},
    { 768, -40, -384},
    { 1144, -8, -368},
    { 1088, 48, -440},
    { 1032, 128, -368},
    { 1272, 288, -368},
    { 1504, 528, -456},
    { 1560, 824, -576},
    // 25 seconds
    { 1272, 688, -536},
    { 1080, 992, -760},
    { 872, 832, -600},
    { 1208, 1088, -480},
    { 1040, 832, -392},
    { 1136, 624, -264},
    { 1272, 600, -216},
    { 1264, 416, -192},
    { 1040, 288, -200},
    { 1040, 288, -168},
    { 1184, 160, -160},
    { 1264, 224, -200},
    { 1248, 136, -120},
    { 1120, 144, -160},
    { 1072, 152, -208},
    { 872, 16, -224},
    { 584, -184, -56},
    { 504, -136, -360},
    { 784, -32, -368},
    { 1248, 120, -480},
    { 1216, 120, -424},
    { 1104, 176, -384},
    { 1176, 416, -384},
    { 1424, 544, -408},
    { 1448, 568, -440},
    // 26 seconds
    { 1136, 600, -552},
    { 760, 696, -616},
    { 880, 872, -672},
    { 952, 832, -528},
    { 1144, 816, -464},
    { 1104, 664, -376},
    { 1304, 584, -296},
    { 1560, 512, -264},
    { 1208, 288, -176},
    { 1024, 232, -144},
    { 1136, 200, -184},
    { 1216, 240, -184},
    { 1280, 176, -168},
    { 1264, 120, -136},
    { 1104, 136, -192},
    { 808, 80, -336},
    { 544, -176, -160},
    { 464, -64, -184},
    { 608, -24, -376},
    { 864, 144, -424},
    { 1352, 176, -472},
    { 1312, 176, -384},
    { 1312, 336, -320},
    { 1488, 512, -248},
    { 1576, 808, -248},
    // 27 seconds
    { 1408, 696, -256},
    { 928, 872, -280},
    { 696, 976, -224},
    { 928, 936, -144},
    { 1120, 960, -160},
    { 1088, 752, -112},
    { 1192, 688, -112},
    { 1312, 608, -88},
    { 1400, 496, -96},
    { 1272, 368, -96},
    { 1256, 184, -152},
    { 1256, 280, -104},
    { 1280, 200, -88},
    { 1232, 112, -64},
    { 1120, 144, -96},
    { 1088, 168, -168},
    { 872, -32, -192},
    { 608, -112, -16},
    { 512, -144, -368},
    { 824, -8, -272},
    { 1392, 136, -448},
    { 1272, 64, -344},
    { 1144, 208, -352},
    { 1184, 360, -280},
    { 1392, 504, -296},
    // 28 seconds
    { 1352, 696, -256},
    { 1208, 712, -288},
    { 944, 752, -376},
    { 872, 880, -320},
    { 984, 848, -288},
    { 1008, 824, -240},
    { 1032, 752, -256},
    { 1184, 656, -224},
    { 1344, 456, -240},
    { 1056, 320, -208},
    { 952, 280, -224},
    { 1088, 256, -192},
    { 1248, 200, -256},
    { 1432, 168, -168},
    { 1248, 144, -168},
    { 1168, 144, -288},
    { 976, 144, -304},
    { 896, 152, -176},
    { 552, -80, -352},
    { 640, 40, -464},
    { 992, -96, -432},
    { 992, -24, -376},
    { 832, 104, -376},
    { 920, 304, -272},
    { 1320, 512, -384},
    // 29 seconds
    { 1680, 696, -304},
    { 1536, 984, -376},
    { 1312, 560, -352},
    { 1048, 872, -424},
    { 944, 992, -304},
    { 848, 960, -224},
    { 936, 784, -280},
    { 1016, 632, -208},
    { 1128, 552, -184},
    { 1128, 416, -144},
    { 1152, 328, -104},
    { 1200, 216, -104},
    { 1208, 240, -152},
    { 1328, 184, -88},
    { 1368, 168, -104},
    { 1320, 144, -128},
    { 1176, 136, -224},
    { 968, -176, 16},
    { 488, -152, -240},
    { 848, -128, -496},
    { 1024, -104, -232},
    { 1144, 8, -368},
    { 1024, -48, -416},
    { 1096, 232, -368},
    { 1320, 440, -400},
    // 30 seconds
    { 1552, 648, -456},
    { 1192, 880, -400},
    { 1104, 584, -512},
    { 656, 760, -440},
    { 656, 856, -288},
    { 1080, 1168, -152},
    { 1504, 976, -200},
    { 1064, 536, -216},
    { 1072, 592, -296},
    { 1352, 608, -152},
    { 1392, 360, -40},
    { 1312, 144, -152},
    { 1352, 224, -152},
    { 1320, 136, -48},
    { 1120, 120, -120},
    { 952, 120, -152},
    { 864, 64, -152},
    { 512, -168, -96},
    { 616, -112, -56},
    { 656, -72, -360},
    { 856, 8, -336},
    { 1576, 192, -408},
    { 1688, 192, -360},
    { 1472, 272, -296},
    { 1224, 536, -368},
    // 31 seconds
    { 1264, 472, -240},
    { 1192, 536, -304},
    { 1008, 600, -304},
    { 856, 736, -368},
    { 832, 928, -376},
    { 856, 872, -336},
    { 1216, 1024, -304},
    { 1272, 688, -216},
    { 1288, 632, -248},
    { 1408, 528, -256},
    { 1352, 400, -168},
    { 1224, 288, -136},
    { 1168, 232, -144},
    { 1192, 256, -88},
    { 1216, 192, -144},
    { 1288, 176, -96},
    { 1176, 120, -112},
    { 896, -32, -144},
    { 824, -144, -40},
    { 800, -248, -152},
    { 912, 40, -400},
    { 1096, 48, -440},
    { 1224, 80, -360},
    { 1216, 160, -296},
    { 1160, 344, -312},
    // 32 seconds
    { 1272, 440, -320},
    { 1440, 640, -352},
    { 1456, 744, -336},
    { 1256, 760, -432},
    { 1064, 888, -520},
    { 792, 960, -472},
    { 1104, 1120, -432},
    { 1120, 736, -320},
    { 1224, 712, -296},
    { 1472, 624, -240},
    { 1520, 416, -168},
    { 1240, 288, -136},
    { 1200, 240, -152},
    { 1264, 208, -136},
    { 1264, 192, -104},
    { 1232, 112, -80},
    { 1016, 120, -72},
    { 856, 32, -64},
    { 520, -120, -72},
    { 624, -72, -176},
    { 576, -64, -320},
    { 928, 48, -368},
    { 1408, 144, -528},
    { 1456, 96, -336},
    { 1224, 312, -392},
    // 33 seconds
    { 1072, 296, -344},
    { 1152, 416, -400},
    { 1240, 448, -424},
    { 1120, 480, -520},
    { 1048, 680, -640},
    { 1128, 776, -608},
    { 1192, 840, -584},
    { 1024, 656, -480},
    { 1072, 656, -400},
    { 1168, 536, -344},
    { 1280, 384, -296},
    { 1096, 328, -224},
    { 1048, 192, -232},
    { 1072, 240, -184},
    { 1152, 216, -184},
    { 1264, 200, -176},
    { 1192, 112, -128},
    { 1192, 144, -160},
    { 896, 48, -216},
    { 712, -184, -96},
    { 504, -192, -336},
    { 704, -104, -312},
    { 1088, 56, -352},
    { 1120, 80, -360},
    { 1000, 144, -320},
    // 34 seconds
    { 1000, 288, -320},
    { 1128, 312, -296},
    { 1304, 408, -376},
    { 1264, 520, -488},
    { 1192, 680, -624},
    { 1168, 808, -592},
    { 1032, 824, -552},
    { 920, 784, -504},
    { 864, 696, -400},
    { 1088, 624, -336},
    { 1304, 512, -296},
    { 1096, 320, -248},
    { 1008, 240, -208},
    { 1144, 232, -168},
    { 1176, 208, -208},
    { 1232, 152, -160},
    { 1216, 152, -168},
    { 1200, 152, -208},
    { 848, 40, -232},
    { 720, -192, -32},
    { 560, -136, -360},
    { 752, -64, -384},
    { 1080, 8, -392},
    { 1032, 48, -432},
    { 928, 96, -400},
    // 35 seconds
    { 976, 224, -360},
    { 1176, 328, -416},
    { 1368, 416, -496},
    { 1280, 584, -576},
    { 1192, 664, -624},
    { 1112, 672, -616},
    { 1056, 704, -520},
    { 920, 696, -448},
    { 992, 624, -360},
    { 1144, 520, -296},
    { 1152, 352, -272},
    { 984, 248, -240},
    { 928, 240, -200},
    { 1056, 152, -200},
    { 1168, 184, -208},
    { 1248, 104, -168},
    { 1184, 128, -176},
    { 1120, 96, -224},
    { 824, -8, -216},
    { 776, -168, -64},
    { 592, -152, -320},
    { 848, 24, -352},
    { 1224, 40, -368},
    { 1168, 96, -368},
    { 976, 112, -336},
    // 36 seconds
    { 976, 280, -320},
    { 1040, 352, -360},
    { 1144, 368, -376},
    { 1152, 464, -504},
    { 1072, 600, -608},
    { 1040, 696, -616},
    { 1096, 752, -544},
    { 1144, 752, -504},
    { 1056, 632, -376},
    { 1152, 528, -352},
    { 1288, 432, -312},
    { 1144, 240, -192},
    { 1064, 216, -160},
    { 872, 456, -368},
    { 904, 136, -112},
    { 1000, 192, -168},
    { 1080, 128, -144},
    { 1112, 128, -168},
    { 888, 96, -240},
    { 872, -56, -112},
    { 616, -104, -272},
    { 832, 8, -440},
    { 1112, -8, -424},
    { 1160, 16, -424},
    { 952, 40, -376},
    // 37 seconds
    { 928, 224, -360},
    { 1088, 320, -352},
    { 1232, 368, -408},
    { 1232, 464, -448},
    { 1112, 568, -624},
    { 1080, 680, -680},
    { 1040, 832, -672},
    { 1120, 936, -632},
    { 1040, 784, -528},
    { 1152, 600, -440},
    { 1384, 496, -328},
    { 1192, 296, -232},
    { 1064, 256, -200},
    { 1112, 208, -168},
    { 1160, 216, -136},
    { 1232, 168, -160},
    { 1312, 112, -136},
    { 1112, 112, -184},
    { 800, -112, -144},
    { 576, -264, -192},
    { 712, -264, -216},
    { 736, -48, -272},
    { 984, 120, -360},
    { 1320, 184, -432},
    { 1312, 152, -272},
    // 38 seconds
    { 1240, 392, -464},
    { 1368, 584, -408},
    { 1416, 592, -384},
    { 1248, 624, -520},
    { 984, 840, -624},
    { 896, 1128, -736},
    { 1040, 1056, -616},
    { 1280, 944, -472},
    { 1176, 680, -328},
    { 1296, 608, -272},
    { 1488, 568, -176},
    { 1480, 344, -192},
    { 1344, 208, -72},
    { 1280, 256, -64},
    { 1312, 264, -24},
    { 1248, 208, -48},
    { 1136, 152, -32},
    { 1008, 96, -80},
    { 752, -192, -24},
    { 552, -216, -160},
    { 744, -264, -304},
    { 688, -48, -264},
    { 992, 112, -416},
    { 1376, 168, -472},
    { 1448, 176, -272},
    // 39 seconds
    { 1424, 368, -312},
    { 1360, 568, -384},
    { 1408, 568, -376},
    { 1248, 600, -504},
    { 976, 720, -648},
    { 840, 912, -808},
    { 856, 776, -680},
    { 1120, 976, -680},
    { 1216, 752, -456},
    { 1288, 616, -376},
    { 1464, 536, -264},
    { 1552, 400, -216},
    { 1280, 272, -128},
    { 1224, 176, -152},
    { 1272, 240, -160},
    { 1304, 160, -144},
    { 1240, 152, -112},
    { 1120, 136, -120},
    { 928, 96, -168},
    { 448, -352, 24},
    { 752, -152, -176},
    { 640, -256, -320},
    { 992, 48, -360},
    { 1344, 136, -528},
    { 1360, 80, -296},
    // 40 seconds
    { 1352, 232, -296},
    { 1336, 488, -288},
    { 1368, 576, -304},
    { 1432, 696, -280},
    { 1288, 744, -352},
    { 1032, 848, -360},
    { 920, 968, -360},
    { 944, 1128, -360},
    { 968, 848, -264},
    { 1032, 824, -216},
    { 1240, 688, -160},
    { 1544, 560, -168},
    { 1360, 456, -144},
    { 1232, 288, -136},
    { 1224, 208, -144},
    { 1248, 224, -120},
    { 1328, 200, -160},
    { 1288, 72, -136},
    { 1208, 80, -160},
    { 728, -312, -16},
    { 840, -168, -152},
    { 552, -320, -184},
    { 1016, 32, -312},
    { 1224, 144, -360},
    { 1256, 128, -288},
    // 41 seconds
    { 1224, 224, -256},
    { 1240, 400, -368},
    { 1368, 520, -336},
    { 1376, 576, -392},
    { 1240, 616, -448},
    { 1040, 784, -560},
    { 936, 920, -632},
    { 928, 872, -584},
    { 1176, 1056, -544},
    { 1032, 704, -408},
    { 1184, 656, -344},
    { 1424, 608, -264},
    { 1488, 424, -56},
    { 1240, 216, -176},
    { 1136, 176, -152},
    { 1176, 272, -160},
    { 1288, 184, -144},
    { 1216, 120, -104},
    { 1144, 144, -136},
    { 928, -8, -80},
    { 512, -136, -144},
    { 824, -72, -144},
    { 584, -104, -296},
    { 928, 64, -408},
    { 1352, 120, -424},
    // 42 seconds
    { 1464, 160, -336},
    { 1304, 312, -360},
    { 1184, 408, -368},
    { 1224, 432, -344},
    { 1256, 552, -376},
    { 1192, 520, -392},
    { 1048, 608, -552},
    { 984, 752, -600},
    { 944, 720, -480},
    { 1096, 808, -448},
    { 1120, 664, -352},
    { 1248, 576, -280},
    { 1376, 464, -264},
    { 1168, 336, -408},
    { 1000, 264, -152},
    { 968, 448, 720},
    { 1144, 184, -8},
    { 1216, 296, -56},
    { 1152, 40, -88},
    { 1152, 280, -208},
    { 1032, 56, -152},
    { 824, -88, -136},
    { 664, -104, -184},
    { 696, -64, -464},
    { 936, -56, -376},
    // 43 seconds
    { 1160, 56, -432},
    { 968, -16, -416},
    { 944, 192, -400},
    { 1072, 264, -408},
    { 1256, 384, -536},
    { 1272, 560, -632},
    { 1168, 632, -632},
    { 1016, 872, -704},
    { 904, 816, -584},
    { 1216, 856, -488},
    { 976, 656, -368},
    { 1064, 544, -312},
    { 1240, 512, -280},
    { 1120, 360, -232},
    { 984, 304, -224},
    { 1008, 240, -192},
    { 1096, 248, -192},
    { 1160, 224, -248},
    { 1184, 200, -288},
    { 1064, 80, -328},
    { 616, -232, -344},
    { 608, -168, -272},
    { 448, -208, -528},
    { 616, -48, -448},
    { 1352, 88, -560},
    // 44 seconds
    { 1376, 64, -392},
    { 1272, 248, -384},
    { 1104, 464, -456},
    { 1112, 496, -432},
    { 1144, 544, -488},
    { 992, 680, -528},
    { 800, 920, -648},
    { 848, 768, -488},
    { 992, 872, -448},
    { 1128, 744, -288},
    { 1208, 624, -232},
    { 1400, 552, -152},
    { 1432, 392, -168},
    { 1112, 264, -208},
    { 1048, 184, -240},
    { 1120, 160, -256},
    { 1192, 104, -232},
    { 1176, 88, -216},
    { 1152, 80, -256},
    { 912, -16, -224},
    { 512, -152, -216},
    { 648, -64, -176},
    { 504, -56, -424},
    { 768, 48, -408},
    { 1408, 104, -520},
    // 45 seconds
    { 1456, 88, -400},
    { 1288, 144, -336},
    { 1176, 344, -376},
    { 1200, 488, -408},
    { 1120, 544, -456},
    { 1008, 528, -544},
    { 912, 744, -640},
    { 992, 752, -568},
    { 1128, 880, -496},
    { 1192, 712, -416},
    { 1168, 584, -352},
    { 1240, 528, -344},
    { 1376, 384, -328},
    { 1168, 248, -240},
    { 1072, 176, -208},
    { 1136, 368, -368},
    { 1288, 136, -208},
    { 1152, 104, -160},
    { 1096, 144, -152},
    { 1048, 104, -144},
    { 936, 112, -208},
    { 768, 0, -192},
    { 632, -104, -192},
    { 576, -80, -432},
    { 976, -40, -416},
    // 46 seconds
    { 1448, 40, -512},
    { 1280, 8, -424},
    { 1192, 192, -432},
    { 1232, 344, -400},
    { 1240, 544, -456},
    { 1184, 584, -464},
    { 1016, 656, -544},
    { 800, 768, -640},
    { 904, 872, -600},
    { 1120, 912, -512},
    { 1208, 744, -448},
    { 1080, 584, -344},
    { 1248, 528, -288},
    { 1512, 408, -240},
    { 1272, 240, -168},
    { 1104, 184, -144},
    { 1120, 192, -184},
    { 1248, 160, -128},
    { 1192, 128, -128},
    { 1200, 136, -208},
    { 1048, -136, -120},
    { 512, -456, -136},
    { 848, -304, -288},
    { 728, -176, -336},
    { 1160, 0, -320},
    // 47 seconds
    { 1552, 192, -432},
    { 1584, 128, -272},
    { 1432, 264, -224},
    { 1400, 480, -264},
    { 1416, 640, -256},
    { 1360, 656, -200},
    { 1160, 744, -392},
    { 832, 872, -496},
    { 656, 1088, -664},
    { 776, 1032, -576},
    { 1192, 880, -496},
    { 1296, 616, -432},
    { 1560, 584, -328},
    { 1728, 432, -264},
    { 1576, 304, -168},
    { 1480, -312, -416},
    { 1064, 176, -104},
    { 1288, 144, -152},
    { 1232, 216, -112},
    { 1296, 96, -136},
    { 1128, 64, -168},
    { 880, -72, -184},
    { 600, -288, -112},
    { 456, -280, -328},
    { 632, -72, -488},
    // 48 seconds
    { 944, -136, -352},
    { 1480, 96, -472},
    { 1384, 56, -320},
    { 1336, 320, -304},
    { 1328, 448, -352},
    { 1392, 512, -384},
    { 1384, 640, -464},
    { 1184, 632, -552},
    { 1000, 824, -624},
    { 960, 960, -568},
    { 1104, 1088, -512},
    { 1064, 704, -408},
    { 1064, 656, -352},
    { 1208, 560, -320},
    { 1392, 472, -288},
    { 1784, -784, 568},
    { 1072, 768, -200},
    { 1280, 96, 0},
    { 1240, -40, -88},
    { 944, 128, -96},
    { 1088, 80, -136},
    { 992, 192, -216},
    { 784, 0, -192},
    { 680, -96, -192},
    { 480, -176, -360},
    // 49 seconds
    { 736, -104, -464},
    { 1168, -48, -512},
    { 1432, 0, -536},
    { 1184, 32, -472},
    { 1104, 232, -456},
    { 1160, 328, -400},
    { 1304, 528, -456},
    { 1304, 640, -520},
    { 952, 800, -656},
    { 784, 952, -648},
    { 760, 904, -472},
    { 1128, 912, -408},
    { 1160, 760, -312},
    { 1408, 680, -312},
    { 1424, 552, -376},
    { 1160, 416, -352},
    { 1104, 312, -272},
    { 1168, 144, -288},
    { 1192, 136, -160},
    { 1160, 96, -232},
    { 1104, 128, -248},
    { 1024, 96, -264},
    { 792, 32, -336},
    { 528, -248, -144},
    { 408, -208, -312},
    // 50 seconds
    { 744, -80, -520},
    { 1080, -56, -480},
    { 1544, 32, -576},
    { 1312, 8, -424},
    { 1256, 232, -368},
    { 1328, 368, -392},
    { 1360, 544, -424},
    { 1232, 592, -496},
    { 1048, 584, -600},
    { 872, 960, -672},
    { 864, 888, -544},
    { 1176, 1120, -440},
    { 1200, 752, -320},
    { 1272, 664, -272},
    { 1256, 664, -288},
    { 1456, 480, -256},
    { 1296, 328, -192},
    { 1280, 248, -152},
    { 1272, 168, -144},
    { 1264, 160, -168},
    { 1280, 120, -232},
    { 1224, 64, -264},
    { 1088, 0, -296},
    { 504, -416, -136},
    { 416, -296, -392},
    // 51 seconds
    { 496, -280, -376},
    { 704, -80, -376},
    { 1128, 48, -448},
    { 1656, 152, -496},
    { 1680, 168, -304},
    { 1464, 504, -328},
    { 1240, 560, -288},
    { 1512, 640, -344},
    { 1296, 688, -328},
    { 1056, 960, -464},
    { 736, 1552, -520},
    { 808, 1160, -488},
    { 968, 1208, -488},
    { 1248, 904, -248},
    { 1448, 704, -240},
    { 1592, 624, -200},
    { 1776, 528, -128},
    { 1592, 328, -80},
    { 1272, 96, -160},
    { 1248, 224, -96},
    { 1232, 200, -152},
    { 1136, 152, -168},
    { 1040, 56, -168},
    { 824, 32, -240},
    { 616, -192, -200},
    // 52 seconds
    { 256, -400, -568},
    { 592, -288, -448},
    { 640, -304, -440},
    { 1080, -176, -472},
    { 1480, 40, -512},
    { 1832, 272, -392},
    { 1784, 464, -288},
    { 1464, 744, -368},
    { 1408, 464, -176},
    { 1336, 632, -240},
    { 1176, 776, -136},
    { 920, 992, -328},
    { 864, 1000, -296},
    { 816, 880, -384},
    { 1088, 984, -328},
    { 1112, 808, -296},
    { 1240, 640, -448},
    { 1312, 608, -352},
    { 1456, 464, -288},
    { 1440, -88, -352},
    { 1320, 256, -184},
    { 1400, 216, -120},
    { 1432, 248, -160},
    { 1344, 208, -40},
    { 1216, 168, -80},
    // 53 seconds
    { 1032, 176, -136},
    { 824, 184, -256},
    { 728, 128, -280},
    { 536, -160, -200},
    { 376, -208, -384},
    { 792, -136, -528},
    { 1192, -56, -464},
    { 1440, 8, -472},
    { 1408, 152, -344},
    { 1472, 376, -360},
    { 1544, 512, -304},
    { 1520, 640, -288},
    { 1392, 648, -288},
    { 1120, 672, -288},
    { 912, 712, -320},
    { 800, 720, -320},
    { 752, 704, -288},
    { 904, 784, -288},
    { 1288, 824, -328},
    { 1160, 488, -408},
    { 1376, 376, -528},
    { 1592, 392, -392},
    { 1824, 136, -328},
    { 1688, 64, -224},
    { 1560, 32, -112},
    // 54 seconds
    { 1392, 128, -120},
    { 1152, 120, -128},
    { 976, 152, -176},
    { 776, 288, -264},
    { 480, 288, -272},
    { 152, 384, -392},
    { -56, 496, -456},
    { -176, 672, -368},
    { -128, 864, -464},
    { -136, 952, -448},
    { -72, 928, -488},
    { -8, 944, -448},
    { 16, 864, -384},
    { 48, 832, -384},
    { 72, 816, -344},
    { 72, 816, -304},
    { 72, 880, -248},
    { 88, 1016, -192},
    { 144, 1120, -176},
    { 128, 976, -320},
    { 128, 976, -232},
    { 136, 952, -160},
    { 136, 904, -200},
    { 136, 872, -248},
    { 112, 864, -264},
    // 55 seconds
    { 72, 848, -248},
    { 8, 840, -224},
    { -32, 792, -208},
    { -80, 840, -208},
    { -104, 864, -200},
    { -120, 888, -192},
    { -120, 904, -200},
    { -120, 904, -208},
    { -112, 912, -192},
    { -112, 904, -184},
    { -128, 904, -160},
    { -144, 928, -136},
    { -152, 904, -120},
    { -200, 912, -72},
    { -232, 944, -24},
    { -232, 952, 8},
    { -240, 944, 32},
    { -256, 944, 16},
    { -232, 968, 8},
    { -192, 992, 32},
    { -128, 1016, 32},
    { -96, 992, 8},
    { -88, 936, 0},
    { -112, 880, -8},
    { -136, 856, -24},
    // 56 seconds
    { -128, 872, -40},
    { -136, 896, -40},
    { -176, 888, -24},
    { -216, 976, -72},
    { -160, 1032, -112},
    { -136, 1000, -192},
    { -136, 984, -176},
    { -80, 984, -176},
    { -32, 944, -168},
    { -16, 896, -208},
    { 8, 912, -248},
    { 40, 928, -232},
    { 40, 968, -192},
    { 40, 952, -176},
    { 48, 968, -128},
    { 24, 992, -80},
    { -40, 976, -8},
    { -136, 928, 56},
    { -248, 808, 128},
    { -328, 792, 224},
    { -392, 800, 248},
    { -336, 840, 240},
    { -280, 888, 216},
    { -248, 904, 200},
    { -240, 912, 192},
    // 57 seconds
    { -248, 792, 200},
    { -312, 800, 280},
    { -368, 744, 384},
    { -400, 784, 600},
    { -432, 784, 728},
    { -408, 784, 760},
    { -392, 672, 768},
    { -344, 664, 792},
    { -296, 672, 752},
    { -248, 664, 744},
    { -160, 696, 856},
    { -56, 688, 728},
    { -32, 656, 608},
    { -64, 624, 584},
    { -144, 656, 600},
    { -192, 592, 576},
    { -232, 584, 552},
    { -264, 584, 552},
    { -296, 640, 608},
    { -360, 624, 664},
    { -456, 600, 688},
    { -520, 584, 784},
    { -480, 480, 776},
    { -432, 448, 712},
    { -432, 360, 704},
    // 58 seconds
    { -424, 408, 752},
    { -384, 448, 744},
    { -320, 480, 720},
    { -312, 520, 744},
    { -320, 552, 624},
    { -408, 456, 800},
    { -408, 488, 816},
    { -392, 416, 840},
    { -352, 400, 808},
    { -328, 440, 792},
    { -296, 688, 712},
    { -320, 608, 736},
    { -320, 520, 792},
    { -312, 592, 688},
    { -304, 576, 680},
    { -312, 512, 712},
    { -336, 576, 720},
    { -328, 616, 664},
    { -288, 608, 704},
    { -288, 648, 696},
    { -296, 624, 720},
    { -304, 680, 600},
    { -304, 600, 632},
    { -344, 560, 720},
    { -352, 600, 616},
    // 59 seconds
    { -312, 696, 632},
    { -288, 712, 672},
    { -256, 720, 616},
    { -176, 760, 680},
    { -232, 728, 584},
    { -216, 704, 560},
    { -184, 712, 528},
    { -208, 736, 560},
    { -240, 736, 536},
    { -264, 736, 576},
    { -304, 736, 608},
    { -336, 688, 600},
    { -368, 624, 568},
    { -424, 616, 584},
    { -336, 576, 528},
    { -440, 688, 552},
    { -512, 616, 560},
    { -488, 608, 488},
    { -480, 632, 472},
    { -464, 648, 472},
    { -456, 672, 480},
    { -512, 744, 488},
    { -496, 808, 424},
    { -456, 848, 376},
    { -496, 952, 320},
    // 60 seconds
    // elapsed: 1 minutes
    { -536, 1000, 328},
    { -568, 1024, 328},
    { -520, 960, 296},
    { -464, 792, 264},
    { -408, 792, 208},
    { -368, 832, 112},
    { -376, 728, 56},
    { -360, 672, -40},
    { -360, 704, -104},
    { -384, 744, -128},
    { -392, 752, -144},
    { -416, 752, -136},
    { -432, 784, -128},
    { -416, 760, -112},
    { -424, 816, -152},
    { -416, 848, -104},
    { -416, 864, -128},
    { -400, 912, -128},
    { -424, 928, -64},
    { -408, 848, -72},
    { -400, 824, -40},
    { -368, 856, 24},
    { -368, 776, 136},
    { -400, 800, 160},
    { -408, 824, 144},
    // 61 seconds
    { -432, 840, 176},
    { -368, 824, 40},
    { -336, 1000, 64},
    { -384, 992, 120},
    { -400, 864, 0},
    { -360, 1024, 0},
    { -416, 904, 48},
    { -408, 840, -8},
    { -368, 856, 24},
    { -424, 936, 144},
    { -408, 712, 184},
    { -448, 744, 216},
    { -440, 776, 248},
    { -384, 792, 304},
    { -352, 696, 360},
    { -368, 792, 480},
    { -424, 664, 752},
    { -392, 584, 560},
    { -304, 856, 144},
    { -368, 848, 440},
    { -456, 1040, 272},
    { -488, 864, 64},
    { -424, 864, 64},
    { -464, 1032, 0},
    { -392, 632, -128},
    // 62 seconds
    { -408, 688, -176},
    { -416, 896, -104},
    { -416, 856, -136},
    { -400, 856, -80},
    { -424, 832, -104},
    { -440, 768, -160},
    { -488, 872, -208},
    { -512, 720, -144},
    { -528, 960, -120},
    { -520, 784, -224},
    { -552, 744, -328},
    { -672, 872, -464},
    { -696, 752, -448},
    { -672, 672, -632},
    { -480, 576, -568},
    { -272, 544, -584},
    { -368, 432, -688},
    { -416, 392, -592},
    { -320, 528, -688},
    { -288, 616, -568},
    { -296, 888, -616},
    { -296, 752, -544},
    { -352, 864, -608},
    { -384, 808, -608},
    { -368, 688, -576},
    // 63 seconds
    { -312, 648, -632},
    { -240, 544, -520},
    { -200, 712, -512},
    { -184, 784, -424},
    { -192, 880, -352},
    { -256, 864, -328},
    { -360, 816, -152},
    { -504, 928, -72},
    { -488, 808, -200},
    { -504, 880, -144},
    { -480, 968, -176},
    { -480, 832, -176},
    { -456, 832, -200},
    { -440, 872, -280},
    { -432, 896, -272},
    { -448, 792, -272},
    { -408, 760, -296},
    { -400, 720, -248},
    { -352, 848, -320},
    { -296, 656, -264},
    { -312, 728, -272},
    { -344, 800, -168},
    { -256, 856, -224},
    { -336, 752, -168},
    { -272, 880, -232},
    // 64 seconds
    { -328, 832, -160},
    { -288, 1064, -128},
    { -264, 1000, -32},
    { -240, 944, -16},
    { -264, 896, 96},
    { -312, 824, 136},
    { -264, 776, 192},
    { -80, 944, 272},
    { 112, 936, 328},
    { 72, 960, 240},
    { 64, 1040, 344},
    { 0, 1064, 344},
    { 8, 976, 320},
    { -32, 1064, 248},
    { 16, 920, 168},
    { 40, 848, 168},
    { 96, 968, -8},
    { 80, 824, -40},
    { 40, 896, 56},
    { -32, 952, 216},
    { -112, 992, 216},
    { -136, 872, 360},
    { -168, 960, 288},
    { -152, 984, 256},
    { -120, 880, 232},
    // 65 seconds
    { -104, 976, 192},
    { -112, 840, 112},
    { -144, 896, 16},
    { -208, 832, -32},
    { -184, 872, -32},
    { -192, 1016, -32},
    { -208, 856, 8},
    { -216, 1024, 0},
    { -280, 1008, -32},
    { -384, 920, -80},
    { -536, 984, -184},
    { -632, 1104, -424},
    { -528, 1064, -552},
    { -200, 696, -616},
    { -56, 256, -816},
    { 104, -8, -768},
    { 152, -248, -944},
    { 96, -128, -1040},
    { 72, -296, -944},
    { -120, -424, -704},
    { -136, -296, -912},
    { -96, -256, -928},
    { -192, -312, -904},
    { -152, -248, -984},
    { -176, -400, -952},
    // 66 seconds
    { -64, -336, -992},
    { -144, -368, -1000},
    { -152, -304, -1008},
    { -216, -168, -1000},
    { -216, -368, -1032},
    { -184, -296, -928},
    { -144, -248, -1000},
    { -200, -216, -1016},
    { -176, -192, -984},
    { -200, -112, -1112},
    { -256, -112, -1048},
    { -120, -160, -928},
    { -200, 104, -792},
    { -40, 488, -680},
    { -448, 760, -536},
    { -448, 896, -488},
    { -504, 936, -416},
    { -416, 816, -320},
    { -408, 904, -232},
    { -360, 1040, -128},
    { -424, 1024, -136},
    { -448, 768, -312},
    { -432, 864, -216},
    { -464, 856, -240},
    { -528, 912, -184},
    // 67 seconds
    { -512, 776, -160},
    { -488, 824, -208},
    { -512, 824, -168},
    { -504, 784, -208},
    { -488, 720, -224},
    { -504, 792, -216},
    { -496, 768, -216},
    { -536, 800, -184},
    { -552, 784, -144},
    { -512, 768, -184},
    { -536, 768, -176},
    { -544, 768, -152},
    { -560, 832, -168},
    { -536, 768, -192},
    { -544, 848, -192},
    { -544, 776, -176},
    { -576, 800, -168},
    { -496, 808, -184},
    { -520, 768, -144},
    { -560, 776, -200},
    { -552, 784, -192},
    { -560, 832, -240},
    { -536, 720, -168},
    { -560, 856, -168},
    { -544, 760, -208},
    // 68 seconds
    { -520, 656, -248},
    { -616, 784, -176},
    { -560, 744, -184},
    { -528, 768, -208},
    { -568, 736, -224},
    { -592, 856, -240},
    { -560, 768, -208},
    { -560, 792, -160},
    { -480, 728, -208},
    { -512, 776, -248},
    { -552, 808, -216},
    { -576, 784, -208},
    { -560, 840, -184},
    { -552, 752, -200},
    { -512, 624, -328},
    { -616, 760, -168},
    { -568, 728, -216},
    { -552, 760, -200},
    { -608, 744, -248},
    { -624, 792, -232},
    { -584, 728, -200},
    { -544, 720, -168},
    { -568, 816, -184},
    { -608, 792, -216},
    { -608, 840, -192},
    // 69 seconds
    { -584, 752, -216},
    { -600, 792, -128},
    { -480, 792, -200},
    { -592, 760, -272},
    { -664, 720, -456},
    { -816, 856, -408},
    { -848, 896, -488},
    { -584, 112, -560},
    { -392, 712, -944},
    { -144, 80, -952},
    { -128, -168, -1016},
    { -72, -232, -984},
    { -168, -456, -936},
    { -128, -408, -872},
    { -136, -320, -880},
    { -176, -456, -920},
    { -200, -256, -872},
    { -240, -480, -920},
    { -144, -440, -896},
    { -160, -480, -912},
    { -176, -504, -952},
    { -112, -448, -936},
    { -160, -424, -960},
    { -192, -448, -952},
    { -184, -416, -944},
    // 70 seconds
    { -192, -424, -968},
    { -176, -432, -944},
    { -136, -448, -960},
    { -152, -448, -968},
    { -152, -464, -936},
    { -168, -456, -944},
    { -184, -448, -944},
    { -136, -416, -960},
    { -152, -456, -968},
    { -160, -424, -960},
    { -168, -440, -984},
    { -152, -424, -968},
    { -176, -384, -952},
    { -168, -320, -952},
    { -248, -272, -976},
    { -272, -200, -952},
    { -240, -192, -976},
    { -272, -160, -1008},
    { -256, -176, -1048},
    { -272, -96, -1048},
    { -240, -144, -1032},
    { -208, -168, -992},
    { -120, -64, -864},
    { -80, 184, -776},
    { -160, 384, -608},
    // 71 seconds
    { -336, 784, -368},
    { -496, 1120, -192},
    { -568, 1280, -160},
    { -568, 1048, -160},
    { -528, 896, -208},
    { -552, 880, -136},
    { -560, 896, -176},
    { -560, 840, -192},
    { -560, 840, -152},
    { -528, 640, -192},
    { -592, 776, -136},
    { -568, 688, -88},
    { -576, 760, -128},
    { -600, 760, -128},
    { -544, 840, -120},
    { -560, 824, -104},
    { -608, 816, -56},
    { -560, 752, 8},
    { -432, 840, 0},
    { -416, 840, 40},
    { -408, 784, -16},
    { -368, 832, -32},
    { -432, 920, 8},
    { -424, 864, -24},
    { -440, 920, -24},
    // 72 seconds
    { -488, 864, 8},
    { -456, 824, -72},
    { -440, 832, -120},
    { -464, 872, -72},
    { -440, 840, -88},
    { -400, 912, -176},
    { -488, 960, 0},
    { -496, 864, -56},
    { -504, 864, -80},
    { -480, 840, -144},
    { -456, 744, -176},
    { -472, 776, -160},
    { -496, 856, -96},
    { -464, 824, -288},
    { -504, 712, -264},
    { -480, 736, -272},
    { -488, 784, -360},
    { -536, 744, -184},
    { -568, 824, -216},
    { -544, 728, -176},
    { -560, 720, -264},
    { -584, 792, -224},
    { -608, 728, -192},
    { -584, 760, -184},
    { -584, 784, -192},
    // 73 seconds
    { -552, 816, -184},
    { -560, 704, -152},
    { -576, 816, -136},
    { -616, 760, -112},
    { -656, 800, -112},
    { -624, 808, -208},
    { -584, 736, -192},
    { -608, 760, -144},
    { -640, 728, -136},
    { -632, 688, -152},
    { -632, 712, -160},
    { -632, 736, -176},
    { -616, 776, -176},
    { -632, 736, -128},
    { -640, 720, -152},
    { -648, 688, -160},
    { -648, 688, -136},
    { -632, 736, -168},
    { -648, 744, -152},
    { -656, 728, -136},
    { -648, 728, -168},
    { -672, 736, -136},
    { -624, 712, -136},
    { -632, 736, -128},
    { -656, 720, -168},
    // 74 seconds
    { -680, 736, -184},
    { -672, 744, -152},
    { -656, 680, -112},
    { -640, 776, -176},
    { -624, 672, -136},
    { -664, 720, -112},
    { -640, 736, -160},
    { -664, 688, -200},
    { -696, 744, -168},
    { -688, 704, -168},
    { -680, 688, -128},
    { -592, 696, -184},
    { -648, 712, -232},
    { -752, 768, -232},
    { -872, 768, -336},
    { -904, 480, -272},
    { -816, 632, -424},
    { -640, 528, -640},
    { -552, 88, -592},
    { -288, 88, -960},
    { -296, -64, -1056},
    { -280, -288, -1040},
    { -240, -312, -952},
    { -280, -528, -896},
    { -256, -272, -896},
    // 75 seconds
    { -248, -312, -952},
    { -208, -376, -904},
    { -296, -320, -904},
    { -280, -352, -1008},
    { -256, -344, -944},
    { -256, -352, -984},
    { -248, -384, -1008},
    { -256, -344, -976},
    { -248, -368, -992},
    { -224, -368, -944},
    { -224, -328, -984},
    { -216, -312, -1008},
    { -192, -392, -944},
    { -248, -368, -968},
    { -208, -336, -960},
    { -216, -376, -976},
    { -288, -320, -992},
    { -224, -352, -1000},
    { -256, -360, -944},
    { -304, -296, -960},
    { -248, -344, -984},
    { -248, -312, -960},
    { -256, -328, -976},
    { -256, -304, -976},
    { -256, -320, -984},
    // 76 seconds
    { -264, -320, -984},
    { -256, -312, -984},
    { -264, -320, -992},
    { -264, -320, -984},
    { -264, -320, -976},
    { -256, -312, -984},
    { -248, -304, -976},
    { -248, -304, -976},
    { -256, -312, -984},
    { -248, -304, -984},
    { -256, -312, -984},
    { -256, -296, -984},
    { -256, -312, -992},
    { -240, -320, -976},
    { -160, -440, -992},
    { -32, -504, -800},
    { 112, 96, -752},
    { -56, 392, -624},
    { -240, 656, -320},
    { -552, 1200, -32},
    { -720, 1320, -112},
    { -664, 928, -184},
    { -664, 848, -184},
    { -624, 928, -192},
    { -616, 872, -160},
    // 77 seconds
    { -600, 856, -120},
    { -584, 720, -208},
    { -560, 760, -128},
    { -552, 688, -160},
    { -576, 680, -80},
    { -608, 728, -208},
    { -600, 712, -224},
    { -624, 720, -232},
    { -592, 720, -192},
    { -608, 752, -176},
    { -632, 728, -152},
    { -616, 752, -152},
    { -624, 728, -160},
    { -616, 752, -168},
    { -616, 736, -168},
    { -640, 704, -120},
    { -608, 728, -152},
    { -624, 760, -152},
    { -592, 792, -208},
    { -600, 736, -160},
    { -704, 768, -120},
    { -616, 664, -160},
    { -608, 792, -184},
    { -648, 656, -168},
    { -632, 744, -152},
    // 78 seconds
    { -640, 656, -208},
    { -648, 752, -56},
    { -584, 792, -208},
    { -648, 728, -192},
    { -672, 760, -144},
    { -688, 712, -144},
    { -640, 704, -160},
    { -568, 720, -280},
    { -728, 760, -288},
    { -912, 720, -288},
    { -784, 584, -232},
    { -752, 856, -480},
    { -568, 112, -488},
    { -376, 136, -800},
    { -192, 88, -1032},
    { -104, 104, -1128},
    { -120, -208, -1112},
    { -96, -256, -984},
    { -152, -304, -968},
    { -160, -416, -952},
    { -144, -312, -912},
    { -120, -392, -968},
    { -136, -400, -976},
    { -128, -376, -936},
    { -136, -376, -984},
    // 79 seconds
    { -168, -344, -960},
    { -200, -344, -952},
    { -208, -384, -976},
    { -200, -376, -968},
    { -184, -376, -1000},
    { -168, -344, -992},
    { -176, -344, -1000},
    { -136, -440, -992},
    { -80, -472, -984},
    { 80, -552, -880},
    { 200, 8, -720},
    { 8, 512, -624},
    { -392, 832, -304},
    { -472, 1232, -224},
    { -616, 1024, -264},
    { -632, 936, -240},
    { -656, 848, -192},
    { -656, 888, -216},
    { -664, 824, -136},
    { -592, 776, -176},
    { -600, 800, -168},
    { -600, 776, -136},
    { -592, 656, -184},
    { -608, 752, -152},
    { -608, 712, -120},
    // 80 seconds
    { -632, 696, -208},
    { -624, 712, -192},
    { -656, 680, -168},
    { -640, 752, -176},
    { -648, 736, -168},
    { -656, 712, -208},
    { -632, 704, -192},
    { -640, 712, -152},
    { -656, 720, -160},
    { -640, 680, -208},
    { -656, 680, -176},
    { -648, 752, -208},
    { -648, 736, -168},
    { -656, 704, -160},
    { -688, 736, -232},
    { -656, 688, -152},
    { -608, 728, -192},
    { -664, 736, -216},
    { -664, 712, -168},
    { -704, 688, -120},
    { -648, 640, -208},
    { -608, 776, -248},
    { -752, 728, -232},
    { -824, 680, -232},
    { -864, 568, -352},
    // 81 seconds
    { -800, 544, -488},
    { -696, 104, -448},
    { -528, 120, -856},
    { -248, -128, -1136},
    { -192, -120, -1032},
    { -88, -168, -1152},
    { -152, -168, -1096},
    { -96, -344, -912},
    { -136, -328, -936},
    { -120, -280, -952},
    { -152, -384, -904},
    { -152, -280, -960},
    { -232, -384, -928},
    { -256, -352, -1000},
    { -152, -192, -1064},
    { -184, -368, -1048},
    { -176, -336, -1016},
    { -176, -304, -1024},
    { 64, -424, -1168},
    { 168, -304, -1008},
    { -136, -376, -984},
    { 8, -392, -1024},
    { -16, -272, -1024},
    { -112, -232, -1016},
    { -144, -224, -992},
    // 82 seconds
    { -120, -336, -1016},
    { -192, -272, -992},
    { -184, -272, -1000},
    { -168, -240, -992},
    { -296, -208, -976},
    { -192, -304, -1016},
    { -208, -232, -1024},
    { -128, -296, -1008},
    { -168, -304, -992},
    { -208, -312, -1008},
    { -184, -344, -1016},
    { -160, -280, -1008},
    { -160, -328, -976},
    { -208, -360, -968},
    { -176, -352, -960},
    { -176, -400, -976},
    { -184, -376, -968},
    { -208, -384, -968},
    { -216, -376, -968},
    { -232, -352, -960},
    { -224, -352, -968},
    { -232, -328, -960},
    { -232, -336, -968},
    { -216, -328, -984},
    { -208, -312, -992},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:00:09 local
AccelRawData *activity_sample_walk_100_pbl_25663_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25663_5
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -256, -368, -968},
    { -248, -376, -968},
    { -272, -384, -952},
    { -232, -384, -960},
    { -224, -384, -952},
    { -232, -384, -960},
    { -232, -416, -944},
    { -240, -408, -952},
    { -248, -408, -952},
    { -248, -408, -944},
    { -248, -400, -952},
    { -240, -408, -936},
    { -256, -416, -944},
    { -256, -408, -936},
    { -264, -408, -944},
    { -264, -400, -944},
    { -256, -408, -960},
    { -248, -400, -944},
    { -256, -400, -952},
    { -248, -400, -952},
    { -240, -392, -960},
    { -248, -400, -968},
    { -240, -392, -952},
    { -216, -376, -952},
    { -248, -368, -944},
    // 1 seconds
    { -288, -504, -912},
    { -248, -368, -912},
    { -248, -424, -928},
    { -272, -448, -848},
    { -184, -688, -912},
    { -240, -576, -792},
    { 416, -328, -1064},
    { -384, -480, -944},
    { -128, -424, -960},
    { -200, -304, -944},
    { -224, -376, -1008},
    { -176, -264, -1000},
    { -128, -352, -968},
    { -32, -568, -752},
    { -32, 288, -560},
    { -320, 760, -776},
    { -424, 536, -440},
    { -488, 1112, -600},
    { -520, 896, -568},
    { -464, 880, -632},
    { -408, 904, -584},
    { -392, 832, -784},
    { -368, 528, -584},
    { -280, 704, -720},
    { -344, 608, -600},
    // 2 seconds
    { -296, 616, -736},
    { -376, 656, -728},
    { -400, 680, -632},
    { -360, 752, -664},
    { -368, 720, -728},
    { -392, 672, -816},
    { -480, 456, -712},
    { -456, 400, -712},
    { -400, 184, -888},
    { -352, -64, -848},
    { -184, -32, -1000},
    { -160, -104, -1168},
    { -160, -64, -1088},
    { -144, -144, -1032},
    { -192, -152, -1008},
    { -224, -256, -936},
    { -216, 0, -1016},
    { -8, -184, -984},
    { -120, -320, -976},
    { -224, -304, -976},
    { -184, -240, -1048},
    { -200, -256, -1104},
    { -120, -320, -968},
    { -88, -288, -984},
    { -112, -304, -1024},
    // 3 seconds
    { -176, -208, -1024},
    { -80, -216, -1008},
    { -168, -240, -1056},
    { -160, -168, -1016},
    { -168, -264, -1032},
    { -136, -216, -992},
    { -96, -296, -936},
    { -72, -312, -1032},
    { -192, -104, -976},
    { -152, -240, -952},
    { -144, -248, -1008},
    { -104, -192, -1048},
    { -192, -216, -1008},
    { -168, -184, -1040},
    { -224, -184, -1024},
    { -160, -216, -1008},
    { -216, -160, -1056},
    { -176, -264, -1008},
    { -96, -224, -1016},
    { -176, -264, -1000},
    { -176, -216, -1016},
    { -192, -144, -1016},
    { -240, -200, -1008},
    { -256, -88, -1008},
    { -280, -152, -1008},
    // 4 seconds
    { -248, -104, -1024},
    { -256, -168, -1024},
    { -248, -136, -1016},
    { -224, -200, -1016},
    { -216, -176, -1032},
    { -192, -176, -1024},
    { -176, -200, -1024},
    { -184, -208, -1016},
    { -184, -192, -1000},
    { -192, -216, -1000},
    { -200, -208, -1000},
    { -184, -192, -1008},
    { -184, -200, -1024},
    { -192, -192, -1016},
    { -192, -224, -1016},
    { -192, -192, -1008},
    { -184, -224, -1008},
    { -184, -192, -1008},
    { -176, -240, -1008},
    { -192, -232, -1000},
    { -200, -240, -1000},
    { -200, -232, -1008},
    { -200, -192, -1032},
    { -176, -216, -1032},
    { -192, -216, -1016},
    // 5 seconds
    { -208, -240, -1008},
    { -184, -232, -1016},
    { -184, -232, -1016},
    { -168, -248, -1024},
    { -152, -240, -1016},
    { -168, -256, -1000},
    { -192, -240, -992},
    { -168, -256, -1008},
    { -168, -264, -1016},
    { -168, -248, -1024},
    { -168, -216, -1024},
    { -184, -248, -1024},
    { -192, -248, -1024},
    { -192, -192, -1008},
    { -216, -232, -1000},
    { -224, -192, -1008},
    { -224, -208, -1024},
    { -224, -208, -1024},
    { -224, -200, -1032},
    { -248, -160, -1016},
    { -272, -168, -1008},
    { -280, -176, -976},
    { -264, -176, -976},
    { -216, -192, -1000},
    { -192, -192, -1016},
    // 6 seconds
    { -176, -288, -1008},
    { -128, -296, -984},
    { -120, -264, -1016},
    { 40, -304, -960},
    { -224, -288, -968},
    { -168, -288, -976},
    { -168, -280, -936},
    { -592, -216, -1040},
    { 96, -368, -1016},
    { -144, -256, -1032},
    { -184, -384, -968},
    { -80, -336, -960},
    { -112, -376, -1032},
    { -64, -328, -1016},
    { -88, -400, -1048},
    { -96, -264, -1048},
    { -64, -288, -984},
    { -112, -280, -984},
    { -216, -184, -976},
    { -200, -200, -1000},
    { -208, -184, -1008},
    { -184, -160, -1032},
    { -176, -168, -1040},
    { -192, -160, -1032},
    { -200, -200, -1016},
    // 7 seconds
    { -176, -184, -1016},
    { -136, -184, -1024},
    { -120, -168, -1024},
    { -128, -176, -1016},
    { -160, -192, -1000},
    { -184, -168, -1000},
    { -216, -176, -1000},
    { -248, -176, -1000},
    { -224, -144, -1032},
    { -208, -144, -1024},
    { -240, -104, -1008},
    { -240, -128, -1016},
    { -256, -112, -1016},
    { -256, -160, -1024},
    { -264, -136, -1016},
    { -272, -160, -1016},
    { -288, -144, -992},
    { -304, -168, -968},
    { -312, -152, -968},
    { -312, -160, -984},
    { -288, -160, -1024},
    { -264, -136, -1048},
    { -248, -120, -1080},
    { -240, -112, -1104},
    { -184, -80, -1152},
    // 8 seconds
    { -128, -40, -1144},
    { -120, -64, -1048},
    { -80, -56, -952},
    { -8, -48, -968},
    { 0, -48, -936},
    { -48, -120, -904},
    { -160, -160, -872},
    { -256, -128, -888},
    { -248, -104, -936},
    { -200, -72, -992},
    { -152, -80, -1016},
    { -112, -104, -976},
    { -96, -80, -968},
    { -64, -48, -1000},
    { -40, -8, -1072},
    { -80, 48, -1128},
    { -216, 312, -1304},
    { -200, 472, -1480},
    { -88, 464, -1320},
    { -336, 408, -1056},
    { -312, 480, -1064},
    { -152, 384, -968},
    { -152, 312, -768},
    { -168, 336, -664},
    { -144, 272, -592},
    // 9 seconds
    { -112, 256, -560},
    { -104, 272, -584},
    { -96, 408, -680},
    { -96, 600, -776},
    { -48, 672, -944},
    { -48, 688, -1128},
    { -48, 880, -1216},
    { 24, 624, -1008},
    { -96, 472, -944},
    { 40, 536, -896},
    { -48, 600, -784},
    { -48, 400, -656},
    { -56, 392, -544},
    { -168, 416, -504},
    { -248, 496, -568},
    { -352, 560, -608},
    { -464, 688, -696},
    { -552, 880, -840},
    { -440, 1040, -1008},
    { -368, 1304, -1104},
    { -168, 920, -888},
    { -272, 568, -768},
    { -328, 784, -688},
    { -120, 752, -624},
    { -96, 576, -632},
    // 10 seconds
    { -120, 504, -592},
    { -136, 512, -592},
    { -96, 520, -616},
    { -24, 536, -712},
    { 80, 584, -816},
    { 160, 384, -808},
    { -16, 320, -848},
    { -144, 496, -880},
    { -264, 704, -920},
    { -240, 800, -1040},
    { -160, 608, -1008},
    { -152, 336, -816},
    { -224, 448, -616},
    { -272, 456, -464},
    { -344, 432, -456},
    { -400, 448, -552},
    { -480, 504, -672},
    { -584, 696, -752},
    { -584, 1016, -968},
    { -664, 1128, -1128},
    { -336, 1128, -1112},
    { -328, 832, -928},
    { -376, 760, -760},
    { -272, 784, -744},
    { -184, 608, -648},
    // 11 seconds
    { -168, 472, -624},
    { -160, 448, -600},
    { -104, 472, -592},
    { -56, 440, -616},
    { -32, 376, -672},
    { -16, 288, -744},
    { -64, 240, -816},
    { -240, 336, -896},
    { -224, 552, -992},
    { -304, 960, -1224},
    { -264, 640, -1120},
    { -176, 376, -912},
    { -256, 280, -592},
    { -328, 448, -416},
    { -464, 536, -368},
    { -552, 568, -456},
    { -608, 632, -576},
    { -648, 944, -720},
    { -560, 1184, -928},
    { -424, 800, -920},
    { -536, 1096, -992},
    { -280, 904, -808},
    { -344, 600, -688},
    { -400, 856, -752},
    { -176, 864, -720},
    // 12 seconds
    { -128, 392, -608},
    { -208, 336, -568},
    { -208, 456, -520},
    { -192, 520, -544},
    { -168, 512, -672},
    { -104, 448, -752},
    { -136, 352, -824},
    { -192, 376, -936},
    { -296, 528, -920},
    { -288, 688, -952},
    { -360, 760, -1016},
    { -280, 576, -976},
    { -192, 392, -856},
    { -232, 304, -664},
    { -240, 368, -552},
    { -328, 416, -536},
    { -400, 424, -624},
    { -456, 488, -704},
    { -584, 624, -760},
    { -632, 816, -872},
    { -496, 776, -968},
    { -672, 1104, -1032},
    { -360, 1040, -1016},
    { -360, 696, -824},
    { -408, 920, -808},
    // 13 seconds
    { -216, 680, -672},
    { -168, 424, -568},
    { -200, 392, -568},
    { -168, 488, -544},
    { -112, 488, -560},
    { -120, 400, -648},
    { -96, 336, -696},
    { -144, 248, -680},
    { -256, 352, -856},
    { -312, 552, -952},
    { -232, 848, -1056},
    { -312, 768, -1080},
    { -256, 616, -1088},
    { -208, 584, -960},
    { -216, 416, -680},
    { -264, 392, -512},
    { -344, 400, -448},
    { -424, 408, -480},
    { -488, 504, -608},
    { -544, 600, -720},
    { -552, 824, -904},
    { -424, 896, -1048},
    { -592, 872, -1024},
    { -344, 1080, -1016},
    { -384, 680, -784},
    // 14 seconds
    { -472, 904, -736},
    { -360, 832, -728},
    { -192, 528, -656},
    { -208, 368, -608},
    { -192, 368, -576},
    { -128, 336, -504},
    { -144, 360, -520},
    { -152, 384, -616},
    { -112, 432, -744},
    { -168, 312, -872},
    { -328, 600, -1040},
    { -216, 784, -1072},
    { -368, 808, -1152},
    { -280, 608, -1088},
    { -200, 424, -912},
    { -208, 296, -632},
    { -248, 336, -480},
    { -304, 360, -392},
    { -384, 360, -432},
    { -480, 440, -584},
    { -584, 632, -752},
    { -632, 904, -904},
    { -568, 976, -1024},
    { -640, 1144, -1088},
    { -328, 944, -976},
    // 15 seconds
    { -424, 704, -816},
    { -448, 952, -792},
    { -248, 768, -728},
    { -144, 400, -608},
    { -224, 296, -496},
    { -192, 456, -504},
    { -128, 384, -504},
    { -120, 336, -512},
    { -128, 336, -600},
    { -104, 280, -640},
    { -208, 312, -752},
    { -280, 424, -856},
    { -320, 632, -1024},
    { -456, 1128, -1288},
    { -304, 816, -1248},
    { -184, 464, -1128},
    { -240, 352, -808},
    { -264, 392, -600},
    { -320, 424, -472},
    { -368, 384, -528},
    { -376, 336, -576},
    { -440, 424, -624},
    { -552, 632, -704},
    { -448, 784, -856},
    { -712, 1096, -1024},
    // 16 seconds
    { -304, 1192, -1136},
    { -424, 944, -1104},
    { -432, 944, -920},
    { -376, 680, -768},
    { -312, 544, -680},
    { -184, 440, -600},
    { -112, 456, -560},
    { 16, 424, -600},
    { 88, 256, -648},
    { 88, 256, -696},
    { 40, 304, -736},
    { -80, 336, -896},
    { -136, 344, -1032},
    { -152, 600, -1240},
    { -304, 904, -1312},
    { -288, 512, -1144},
    { -240, 312, -920},
    { -288, 232, -672},
    { -352, 360, -552},
    { -440, 456, -544},
    { -520, 352, -608},
    { -664, 400, -768},
    { -728, 656, -872},
    { -608, 992, -1080},
    { -688, 1152, -1192},
    // 17 seconds
    { -240, 728, -1176},
    { -448, 688, -1072},
    { -416, 1112, -1152},
    { -136, 544, -944},
    { -40, 192, -760},
    { -120, 232, -640},
    { -72, 336, -656},
    { 0, 288, -568},
    { -40, 304, -624},
    { -40, 496, -832},
    { 64, 320, -808},
    { 96, 0, -544},
    { 208, 24, -448},
    { 480, 208, -592},
    { 1000, 224, -576},
    { 1216, 304, -640},
    { 1344, 544, -592},
    { 1280, 536, -264},
    { 1408, 560, -104},
    { 1464, 712, -136},
    { 1368, 672, 0},
    { 1424, 624, -104},
    { 1216, 880, -64},
    { 920, 904, 48},
    { 832, 1024, -24},
    // 18 seconds
    { 712, 720, -136},
    { 856, 776, -96},
    { 1248, 688, -72},
    { 1256, 520, -104},
    { 1296, 472, -104},
    { 1392, 528, -48},
    { 1336, 616, -72},
    { 1224, 608, -56},
    { 1120, 544, -8},
    { 1008, 176, 0},
    { 872, 96, -72},
    { 728, -16, -168},
    { 568, -208, -120},
    { 792, -104, -360},
    { 1232, 168, -376},
    { 1368, 272, -336},
    { 1216, 408, -376},
    { 1040, 416, -256},
    { 1072, 432, -176},
    { 1160, 536, -160},
    { 1456, 496, -144},
    { 1352, 696, -176},
    { 1176, 920, -240},
    { 1088, 1032, -216},
    { 1088, 848, -304},
    // 19 seconds
    { 848, 792, -312},
    { 896, 688, -224},
    { 1080, 536, -184},
    { 968, 360, -168},
    { 944, 264, -128},
    { 1048, 296, -112},
    { 1272, 280, -96},
    { 1368, 288, -48},
    { 1264, 192, -96},
    { 1288, 216, -152},
    { 1048, 104, -208},
    { 568, -176, -232},
    { 616, -152, -184},
    { 744, 120, -424},
    { 912, 224, -408},
    { 1024, 288, -416},
    { 944, 256, -344},
    { 912, 352, -256},
    { 1040, 408, -216},
    { 1160, 544, -272},
    { 1192, 632, -280},
    { 1056, 720, -400},
    { 920, 832, -424},
    { 872, 648, -344},
    { 1152, 808, -304},
    // 20 seconds
    { 1024, 728, -176},
    { 1144, 528, -216},
    { 1216, 544, -192},
    { 1096, 360, -168},
    { 944, 256, -128},
    { 928, 280, -144},
    { 1072, 272, -136},
    { 1208, 320, -120},
    { 1264, 208, -136},
    { 1272, 200, -184},
    { 1040, 120, -232},
    { 656, -144, -184},
    { 640, -96, -152},
    { 680, 96, -504},
    { 952, 120, -432},
    { 1144, 216, -456},
    { 952, 128, -392},
    { 856, 248, -320},
    { 944, 288, -280},
    { 1072, 440, -320},
    { 1160, 544, -304},
    { 1104, 672, -360},
    { 1016, 744, -440},
    { 976, 712, -392},
    { 1208, 888, -360},
    // 21 seconds
    { 1088, 696, -264},
    { 1160, 624, -264},
    { 1200, 560, -264},
    { 1184, 456, -240},
    { 912, 296, -136},
    { 880, 96, -184},
    { 920, 304, -168},
    { 1024, 288, -144},
    { 1200, 216, -160},
    { 1312, 192, -176},
    { 1224, 200, -256},
    { 840, 32, -272},
    { 736, -64, -120},
    { 408, -80, -368},
    { 688, 80, -336},
    { 1200, 256, -496},
    { 1032, 184, -336},
    { 912, 248, -368},
    { 896, 312, -304},
    { 944, 352, -328},
    { 1000, 440, -352},
    { 1008, 536, -392},
    { 904, 720, -488},
    { 920, 792, -504},
    { 968, 648, -384},
    // 22 seconds
    { 1312, 888, -360},
    { 1112, 696, -216},
    { 1144, 592, -216},
    { 1248, 488, -200},
    { 1056, 320, -168},
    { 896, 272, -168},
    { 920, 288, -192},
    { 1120, 232, -192},
    { 1160, 176, -144},
    { 1040, 128, -144},
    { 1032, 176, -208},
    { 896, 88, -184},
    { 544, -96, -168},
    { 864, -80, -104},
    { 872, 16, -352},
    { 1368, 200, -464},
    { 1440, 256, -416},
    { 1152, 264, -272},
    { 1032, 384, -256},
    { 1096, 392, -168},
    { 1136, 504, -136},
    { 1192, 624, -136},
    { 1080, 696, -144},
    { 896, 832, -200},
    { 824, 800, -216},
    // 23 seconds
    { 1008, 1016, -264},
    { 1176, 872, -200},
    { 1360, 808, -168},
    { 1312, 680, -192},
    { 1352, 480, -160},
    { 1176, 376, -136},
    { 1152, 312, -120},
    { 1232, 288, -152},
    { 1256, 208, -48},
    { 1168, 176, -80},
    { 1168, 168, -112},
    { 888, -96, -72},
    { 816, -168, -152},
    { 1040, -320, -40},
    { 1048, 248, -512},
    { 1440, 144, -424},
    { 1424, 248, -320},
    { 1128, 288, -280},
    { 936, 408, -288},
    { 1016, 456, -160},
    { 1096, 536, -120},
    { 1192, 672, -120},
    { 1208, 776, -104},
    { 960, 904, -72},
    { 824, 1008, -176},
    // 24 seconds
    { 840, 1104, -120},
    { 1344, 1008, -88},
    { 1752, 832, -128},
    { 1552, 712, -216},
    { 1632, 552, -184},
    { 1400, 320, -168},
    { 1224, 288, -152},
    { 1264, 344, -128},
    { 1232, 328, -112},
    { 1224, 208, -96},
    { 1184, 136, -136},
    { 1040, 104, -104},
    { 776, -48, -120},
    { 264, -464, -216},
    { 384, -208, -144},
    { 1496, 200, -552},
    { 1992, 424, -472},
    { 1984, 488, -568},
    { 1328, 400, -320},
    { 840, 400, -344},
    { 880, 280, -296},
    { 1000, 464, -184},
    { 1000, 448, -176},
    { 1216, 504, -272},
    { 1368, 744, -304},
    // 25 seconds
    { 1192, 560, -296},
    { 1088, 520, -528},
    { 872, 576, -456},
    { 856, 480, -272},
    { 1224, 8, -488},
    { 872, -336, -432},
    { 664, 160, -536},
    { 664, 32, -464},
    { 968, 184, -496},
    { 1240, 80, -224},
    { 1344, 240, -296},
    { 1248, 168, -248},
    { 1176, 192, -192},
    { 880, 40, -192},
    { 1112, -48, -72},
    { 1344, -176, -120},
    { 1248, -24, -288},
    { 1128, 8, -232},
    { 848, 48, -208},
    { 704, 128, -160},
    { 824, 296, -176},
    { 1016, 264, -192},
    { 1184, 448, -264},
    { 1312, 576, -264},
    { 1240, 712, -360},
    // 26 seconds
    { 1144, 672, -384},
    { 880, 632, -352},
    { 776, 712, -296},
    { 936, 656, -312},
    { 1192, 536, -352},
    { 1192, 456, -360},
    { 1080, 296, -320},
    { 1040, 208, -272},
    { 1176, 224, -248},
    { 1216, 200, -248},
    { 1136, 264, -240},
    { 1184, 288, -216},
    { 1200, 200, -208},
    { 864, 40, -160},
    { 680, -104, -176},
    { 584, -128, -280},
    { 832, 24, -488},
    { 1192, 120, -392},
    { 1248, 184, -456},
    { 1048, 224, -384},
    { 960, 336, -264},
    { 1056, 392, -200},
    { 1208, 520, -200},
    { 1384, 544, -56},
    { 1320, 680, -88},
    // 27 seconds
    { 1168, 832, -96},
    { 1032, 776, -80},
    { 952, 944, -120},
    { 760, 864, -144},
    { 952, 728, -120},
    { 1152, 624, -144},
    { 1200, 456, -184},
    { 1048, 408, -176},
    { 1056, 264, -176},
    { 1256, 248, -160},
    { 1304, 328, -112},
    { 1312, 272, -192},
    { 1256, 272, -152},
    { 1064, 184, -184},
    { 680, -112, -256},
    { 568, -40, -128},
    { 664, 8, -464},
    { 904, 168, -408},
    { 1352, 240, -504},
    { 1160, 224, -344},
    { 968, 344, -272},
    { 928, 352, -208},
    { 1024, 520, -168},
    { 1200, 536, -144},
    { 1168, 704, -160},
    // 28 seconds
    { 1024, 808, -256},
    { 984, 944, -240},
    { 1120, 912, -232},
    { 1248, 840, -280},
    { 952, 696, -280},
    { 960, 632, -272},
    { 1192, 504, -192},
    { 1112, 328, -128},
    { 1008, 272, -128},
    { 1032, 224, -80},
    { 1064, 248, -72},
    { 1184, 272, -88},
    { 1200, 232, -176},
    { 976, 128, -208},
    { 848, -88, -248},
    { 808, -144, -272},
    { 728, -192, -464},
    { 736, -48, -472},
    { 1264, 72, -496},
    { 1368, 112, -424},
    { 1192, 176, -344},
    { 1056, 440, -360},
    { 1000, 456, -344},
    { 1104, 528, -248},
    { 1224, 560, -224},
    // 29 seconds
    { 1184, 576, -312},
    { 1024, 776, -352},
    { 1080, 816, -368},
    { 1296, 968, -416},
    { 928, 600, -328},
    { 952, 624, -352},
    { 1136, 552, -280},
    { 1280, 360, -232},
    { 1128, 224, -136},
    { 1104, 208, -144},
    { 1144, 248, -152},
    { 1200, 256, -144},
    { 1344, 232, -160},
    { 1328, 200, -184},
    { 1208, 16, -208},
    { 816, -256, -144},
    { 808, -200, -232},
    { 616, -56, -416},
    { 1072, 64, -328},
    { 1160, 168, -328},
    { 1064, 136, -272},
    { 984, 288, -336},
    { 1000, 320, -176},
    { 1184, 408, -264},
    { 1328, 552, -320},
    // 30 seconds
    { 1296, 728, -416},
    { 1144, 800, -576},
    { 1008, 936, -616},
    { 1120, 880, -584},
    { 848, 616, -440},
    { 1024, 600, -392},
    { 1296, 512, -312},
    { 1272, 248, -168},
    { 1080, 248, -184},
    { 1056, 184, -184},
    { 1136, 224, -136},
    { 1360, 232, -120},
    { 1416, 168, -112},
    { 1248, 152, -208},
    { 1144, 48, -232},
    { 704, -176, -192},
    { 784, -176, -112},
    { 648, -120, -384},
    { 800, 128, -464},
    { 1104, 144, -432},
    { 1088, 128, -352},
    { 952, 280, -344},
    { 1072, 312, -304},
    { 1264, 456, -328},
    { 1336, 648, -432},
    // 31 seconds
    { 1168, 832, -520},
    { 912, 896, -592},
    { 896, 768, -488},
    { 1264, 936, -424},
    { 1152, 672, -272},
    { 1232, 584, -272},
    { 1328, 576, -296},
    { 1216, 224, -216},
    { 1008, 168, -168},
    { 944, 232, -160},
    { 1040, 200, -160},
    { 1104, 240, -144},
    { 1312, 264, -216},
    { 1240, 200, -232},
    { 952, 104, -240},
    { 504, -160, -240},
    { 664, -56, -216},
    { 680, -24, -424},
    { 976, 112, -432},
    { 1328, 208, -512},
    { 1152, 128, -296},
    { 1064, 312, -280},
    { 1072, 384, -256},
    { 1208, 464, -288},
    { 1256, 608, -280},
    // 32 seconds
    { 1112, 744, -384},
    { 912, 832, -496},
    { 920, 856, -488},
    { 1184, 960, -424},
    { 1096, 696, -296},
    { 1240, 600, -344},
    { 1288, 504, -296},
    { 1344, 360, -248},
    { 1104, 184, -136},
    { 1008, 360, -224},
    { 1112, 352, -168},
    { 1216, 392, -176},
    { 1272, 336, -192},
    { 1256, 264, -208},
    { 1064, 112, -200},
    { 568, -200, -128},
    { 632, -112, -144},
    { 488, -144, -408},
    { 776, -16, -368},
    { 1248, 120, -408},
    { 1256, 56, -400},
    { 1120, 176, -360},
    { 1168, 368, -368},
    { 1264, 416, -304},
    { 1440, 584, -344},
    // 33 seconds
    { 1360, 720, -320},
    { 1056, 784, -464},
    { 816, 888, -472},
    { 976, 864, -424},
    { 1192, 928, -376},
    { 1048, 712, -304},
    { 1160, 584, -248},
    { 1328, 552, -224},
    { 1320, 352, -144},
    { 1160, 256, -184},
    { 1144, 200, -128},
    { 1144, 200, -128},
    { 1160, 240, -128},
    { 1200, 208, -168},
    { 1160, 216, -168},
    { 920, 136, -264},
    { 656, -8, -296},
    { 496, -176, -160},
    { 488, -136, -496},
    { 832, -64, -408},
    { 1304, 80, -488},
    { 1288, 160, -464},
    { 1080, 256, -360},
    { 1008, 456, -384},
    { 1168, 488, -296},
    // 34 seconds
    { 1328, 544, -256},
    { 1200, 616, -264},
    { 968, 712, -352},
    { 952, 944, -432},
    { 1056, 1024, -384},
    { 1224, 912, -336},
    { 936, 648, -296},
    { 984, 576, -232},
    { 1296, 488, -208},
    { 1392, 312, -104},
    { 1096, 176, -136},
    { 1016, 232, -136},
    { 1080, 176, -152},
    { 1088, 176, -128},
    { 1192, 184, -160},
    { 1144, 144, -184},
    { 896, 24, -288},
    { 656, -128, -232},
    { 648, -136, -296},
    { 744, 56, -368},
    { 1056, 144, -352},
    { 1296, 272, -352},
    { 1216, 208, -232},
    { 1064, 408, -256},
    { 1072, 392, -200},
    // 35 seconds
    { 1184, 520, -152},
    { 1208, 504, -176},
    { 1088, 616, -216},
    { 976, 864, -328},
    { 1008, 888, -320},
    { 1200, 1040, -368},
    { 976, 656, -280},
    { 904, 576, -296},
    { 1064, 568, -216},
    { 1184, 368, -136},
    { 984, 256, -112},
    { 1040, 256, -136},
    { 1232, 528, -8},
    { 1480, 192, 0},
    { 1440, 224, -64},
    { 1280, 168, -88},
    { 1008, 120, -88},
    { 832, -88, -256},
    { 720, -56, -336},
    { 464, -48, -528},
    { 648, -120, -568},
    { 824, -64, -488},
    { 800, 24, -432},
    { 640, 96, -392},
    { 576, 40, -344},
    // 36 seconds
    { 744, 104, -320},
    { 1120, 120, -424},
    { 1352, 288, -576},
    { 1512, 368, -864},
    { 1392, 384, -784},
    { 1416, 544, -856},
    { 688, 480, -808},
    { 824, 440, -600},
    { 1072, 536, -512},
    { 1048, 360, -328},
    { 920, 208, -256},
    { 896, 232, -248},
    { 944, 240, -176},
    { 1056, 288, -184},
    { 1184, 176, -152},
    { 1384, 168, -168},
    { 1240, 152, -240},
    { 1192, 16, -312},
    { 824, -312, -120},
    { 560, -264, -296},
    { 880, -184, -496},
    { 1064, -160, -344},
    { 936, -8, -328},
    { 864, 200, -400},
    { 904, 232, -320},
    // 37 seconds
    { 1120, 408, -360},
    { 1352, 456, -312},
    { 1288, 768, -472},
    { 1032, 680, -408},
    { 1008, 1024, -560},
    { 1144, 992, -440},
    { 944, 728, -360},
    { 1000, 640, -232},
    { 1272, 480, -232},
    { 1328, 184, -200},
    { 1064, 88, -168},
    { 1160, 408, -184},
    { 1240, -224, -48},
    { 1120, 352, -256},
    { 1232, 120, -328},
    { 1048, 200, -184},
    { 880, 240, -200},
    { 704, -88, -320},
    { 656, 72, -208},
    { 592, 24, -376},
    { 776, 104, -464},
    { 1192, 136, -488},
    { 1248, 88, -408},
    { 1056, 248, -360},
    { 1080, 392, -368},
    // 38 seconds
    { 1112, 496, -336},
    { 1128, 672, -408},
    { 904, 864, -488},
    { 760, 1128, -552},
    { 1040, 864, -424},
    { 1320, 928, -432},
    { 1064, 576, -240},
    { 1144, 520, -256},
    { 1288, 416, -152},
    { 1376, 328, -144},
    { 1088, 176, -136},
    { 896, 184, -144},
    { 928, 216, -152},
    { 960, 200, -144},
    { 928, 232, -208},
    { 928, 176, -248},
    { 888, 88, -304},
    { 744, -72, -256},
    { 680, -32, -336},
    { 520, -8, -496},
    { 1192, 96, -568},
    { 1512, 160, -560},
    { 1224, 72, -392},
    { 1040, 400, -392},
    { 856, 520, -376},
    // 39 seconds
    { 952, 536, -336},
    { 1048, 760, -416},
    { 880, 848, -480},
    { 840, 784, -536},
    { 1112, 632, -392},
    { 1352, 728, -424},
    { 1144, 496, -312},
    { 1040, 416, -320},
    { 1136, 176, -232},
    { 1384, 96, -104},
    { 952, 64, -456},
    { 952, 304, -168},
    { 560, 8, 120},
    { 752, 152, -48},
    { 992, 96, -72},
    { 976, 248, -224},
    { 928, 160, -280},
    { 648, 144, -368},
    { 808, 112, -288},
    { 616, 0, -384},
    { 1008, 136, -560},
    { 1408, 232, -440},
    { 1088, 168, -296},
    { 848, 240, -336},
    { 824, 280, -240},
    // 40 seconds
    { 952, 376, -216},
    { 1000, 432, -280},
    { 1024, 560, -352},
    { 872, 1040, -544},
    { 968, 976, -360},
    { 1264, 696, -376},
    { 1176, 672, -328},
    { 1128, 480, -152},
    { 1240, 520, -136},
    { 1472, 392, -136},
    { 1168, 216, -88},
    { 936, 152, -144},
    { 936, 248, -176},
    { 1016, 184, -168},
    { 1056, 192, -144},
    { 1088, 176, -224},
    { 992, -8, -232},
    { 616, -320, -144},
    { 888, -56, -248},
    { 648, 32, -376},
    { 1120, 88, -424},
    { 1472, 264, -440},
    { 1288, 96, -272},
    { 1128, 288, -312},
    { 1056, 416, -240},
    // 41 seconds
    { 1088, 560, -248},
    { 1096, 536, -256},
    { 1040, 696, -264},
    { 1024, 824, -320},
    { 992, 1032, -352},
    { 984, 904, -384},
    { 1032, 832, -320},
    { 1024, 608, -240},
    { 1184, 568, -176},
    { 1568, 472, -152},
    { 1368, 296, -80},
    { 1264, 224, -120},
    { 1248, 168, -128},
    { 1240, 280, -80},
    { 1160, 216, -96},
    { 1168, 160, -128},
    { 1080, 136, -112},
    { 824, 16, -160},
    { 816, -48, -40},
    { 432, -40, -336},
    { 744, 104, -488},
    { 1168, 96, -488},
    { 1264, 64, -368},
    { 1176, 128, -344},
    { 1112, 304, -296},
    // 42 seconds
    { 1120, 560, -408},
    { 1240, 568, -336},
    { 1288, 592, -376},
    { 1056, 600, -352},
    { 912, 760, -424},
    { 944, 776, -408},
    { 1200, 864, -424},
    { 936, 624, -312},
    { 1040, 560, -264},
    { 1224, 512, -240},
    { 1280, 368, -216},
    { 1128, 248, -160},
    { 1048, 152, -168},
    { 1296, 216, -200},
    { 1480, 128, -176},
    { 1240, 144, -128},
    { 1136, 168, -152},
    { 1024, 136, -240},
    { 848, 24, -224},
    { 760, 48, -136},
    { 592, 24, -448},
    { 800, 104, -480},
    { 1176, 184, -432},
    { 1136, 80, -288},
    { 1000, 256, -304},
    // 43 seconds
    { 960, 336, -232},
    { 1016, 528, -288},
    { 1096, 536, -312},
    { 1096, 552, -384},
    { 952, 744, -504},
    { 1000, 768, -528},
    { 1072, 768, -464},
    { 1272, 816, -456},
    { 1040, 504, -304},
    { 1056, 432, -304},
    { 1256, 416, -296},
    { 1192, 232, -232},
    { 976, 200, -176},
    { 1040, 160, -176},
    { 1032, 152, -176},
    { 1024, 160, -192},
    { 1064, 184, -224},
    { 1072, 176, -256},
    { 912, 88, -296},
    { 616, -168, -264},
    { 744, -80, -256},
    { 776, -24, -344},
    { 1080, 120, -400},
    { 1536, 248, -472},
    { 1512, 176, -224},
    // 44 seconds
    { 1376, 344, -256},
    { 1328, 568, -192},
    { 1264, 664, -224},
    { 1144, 592, -232},
    { 872, 784, -216},
    { 672, 944, -280},
    { 768, 848, -272},
    { 1072, 864, -248},
    { 1096, 648, -232},
    { 1248, 488, -240},
    { 1376, 448, -216},
    { 1416, 88, -192},
    { 1264, 608, -168},
    { 1320, 104, -272},
    { 1312, 136, -184},
    { 1232, 152, -240},
    { 1240, 136, -248},
    { 1136, 96, -296},
    { 848, -24, -240},
    { 688, -152, -168},
    { 632, -56, -312},
    { 536, 16, -456},
    { 1016, 40, -440},
    { 1464, 104, -544},
    { 1248, 48, -352},
    // 45 seconds
    { 1240, 320, -368},
    { 1208, 440, -336},
    { 1224, 624, -344},
    { 1144, 688, -304},
    { 936, 888, -408},
    { 832, 1040, -432},
    { 936, 864, -328},
    { 1296, 864, -256},
    { 1160, 656, -216},
    { 1152, 568, -184},
    { 1296, 544, -136},
    { 1192, 312, -136},
    { 1056, 272, -104},
    { 1280, 184, 80},
    { 1240, 328, -112},
    { 1240, 40, -80},
    { 1120, 240, -272},
    { 1112, 176, -312},
    { 824, 16, -344},
    { 560, -224, -176},
    { 696, -120, -248},
    { 560, 0, -552},
    { 760, 112, -592},
    { 1384, 184, -536},
    { 1240, 16, -392},
    // 46 seconds
    { 1200, 168, -336},
    { 1248, 440, -384},
    { 1224, 720, -432},
    { 1112, 656, -416},
    { 904, 968, -536},
    { 776, 1080, -432},
    { 936, 800, -296},
    { 1400, 840, -216},
    { 1152, 560, -192},
    { 1184, 512, -168},
    { 1312, 496, -104},
    { 1240, 392, -192},
    { 1128, 184, -128},
    { 1112, 296, -200},
    { 944, 184, -64},
    { 936, 176, -160},
    { 984, 176, -192},
    { 1088, 136, -232},
    { 1040, 144, -240},
    { 728, 48, -368},
    { 608, -72, -240},
    { 464, -104, -336},
    { 648, 24, -496},
    { 1184, 160, -560},
    { 1552, 120, -408},
    // 47 seconds
    { 1352, 192, -344},
    { 1152, 472, -328},
    { 1112, 504, -232},
    { 1168, 632, -232},
    { 1032, 608, -240},
    { 736, 880, -392},
    { 672, 1120, -280},
    { 920, 760, -248},
    { 1416, 928, -280},
    { 1224, 616, -184},
    { 1240, 568, -192},
    { 1280, 536, -176},
    { 1112, 224, -944},
    { 1120, 328, -240},
    { 1192, 64, -128},
    { 1176, 184, -200},
    { 1176, 160, -144},
    { 1096, 168, -152},
    { 1024, 176, -216},
    { 920, 168, -272},
    { 736, 72, -224},
    { 520, -152, -120},
    { 408, -16, -504},
    { 728, 32, -440},
    { 1456, 72, -536},
    // 48 seconds
    { 1352, 104, -392},
    { 1224, 288, -408},
    { 1184, 488, -408},
    { 1248, 488, -424},
    { 1168, 608, -368},
    { 968, 608, -408},
    { 752, 832, -528},
    { 880, 1016, -440},
    { 992, 768, -360},
    { 1464, 888, -360},
    { 1072, 472, -208},
    { 1112, 496, -264},
    { 1336, 392, -192},
    { 1248, 344, -248},
    { 1048, 40, -56},
    { 1016, 104, -120},
    { 1040, 216, -112},
    { 1024, 176, -144},
    { 976, 200, -192},
    { 936, 104, -160},
    { 800, 96, -216},
    { 560, -8, -328},
    { 624, 24, -216},
    { 568, 64, -384},
    { 856, 160, -496},
    // 49 seconds
    { 1560, 256, -656},
    { 1376, 168, -400},
    { 1056, 320, -416},
    { 912, 472, -376},
    { 1080, 392, -384},
    { 1008, 472, -376},
    { 832, 576, -352},
    { 784, 744, -488},
    { 1032, 776, -424},
    { 1200, 728, -424},
    { 1200, 728, -424},
    { 1112, 520, -280},
    { 1168, 456, -352},
    { 1248, 432, -328},
    { 1096, 168, -256},
    { 896, 144, -144},
    { 960, 152, -208},
    { 1064, 200, -168},
    { 1176, 200, -144},
    { 1184, 160, -120},
    { 1088, 168, -136},
    { 816, 160, -296},
    { 880, 104, -160},
    { 376, -120, -368},
    { 576, 40, -488},
    // 50 seconds
    { 1072, 16, -520},
    { 1256, 40, -456},
    { 1024, 128, -376},
    { 976, 296, -336},
    { 1080, 392, -280},
    { 1216, 528, -296},
    { 1168, 592, -264},
    { 1048, 656, -328},
    { 984, 872, -312},
    { 976, 824, -296},
    { 1072, 1024, -376},
    { 896, 720, -208},
    { 1008, 640, -208},
    { 1288, 608, -192},
    { 1272, 424, -192},
    { 1096, 320, -160},
    { 1032, -120, -320},
    { 896, 136, -112},
    { 1144, 240, -216},
    { 1272, 240, -176},
    { 1144, 48, -224},
    { 1024, 8, -256},
    { 816, -208, -136},
    { 720, -176, -336},
    { 648, -8, -496},
    // 51 seconds
    { 1136, -8, -416},
    { 1304, 120, -384},
    { 1144, 96, -336},
    { 904, 336, -320},
    { 984, 328, -232},
    { 1120, 520, -248},
    { 1344, 552, -192},
    { 1280, 680, -256},
    { 1000, 768, -312},
    { 944, 984, -376},
    { 976, 1056, -392},
    { 920, 848, -328},
    { 848, 696, -288},
    { 1152, 656, -216},
    { 1584, 488, -184},
    { 1216, 296, -168},
    { 1040, 216, -176},
    { 1152, 176, -152},
    { 1248, 280, -168},
    { 1376, 240, -248},
    { 1256, 208, -256},
    { 1048, 48, -336},
    { 544, -224, -240},
    { 784, -56, -264},
    { 536, -152, -384},
    // 52 seconds
    { 840, 64, -432},
    { 1184, 128, -464},
    { 1176, 112, -328},
    { 1096, 216, -312},
    { 1104, 440, -232},
    { 1272, 496, -280},
    { 1320, 600, -312},
    { 1168, 672, -400},
    { 904, 824, -480},
    { 904, 920, -496},
    { 1112, 1008, -376},
    { 1224, 840, -288},
    { 1016, 600, -320},
    { 1120, 592, -280},
    { 1352, 560, -232},
    { 1248, 328, -160},
    { 1152, 200, -136},
    { 1104, 200, -152},
    { 1112, 184, -120},
    { 1152, 176, -136},
    { 1184, 120, -208},
    { 1160, 144, -240},
    { 976, 32, -336},
    { 688, -256, -224},
    { 624, -176, -280},
    // 53 seconds
    { 608, -112, -424},
    { 936, 48, -480},
    { 1328, 136, -472},
    { 1264, 64, -336},
    { 1144, 304, -312},
    { 1072, 480, -264},
    { 1168, 520, -280},
    { 1208, 496, -184},
    { 1136, 664, -296},
    { 1008, 824, -328},
    { 1032, 1240, -400},
    { 1136, 880, -368},
    { 1176, 888, -424},
    { 800, 568, -352},
    { 888, 600, -264},
    { 1224, 576, -216},
    { 1576, 272, -184},
    { 1272, 128, -56},
    { 1160, 288, -168},
    { 1152, 168, -152},
    { 1168, 224, -160},
    { 1080, 168, -144},
    { 1064, 184, -216},
    { 1056, 160, -272},
    { 768, -40, -296},
    // 54 seconds
    { 808, -32, -240},
    { 544, -40, -328},
    { 704, 32, -480},
    { 1040, 112, -480},
    { 1112, 64, -408},
    { 1048, 144, -440},
    { 1024, 336, -416},
    { 1192, 288, -384},
    { 1376, 480, -384},
    { 1264, 416, -440},
    { 992, 480, -616},
    { 936, 560, -744},
    { 992, 512, -688},
    { 1072, 568, -704},
    { 832, 464, -584},
    { 1224, 560, -560},
    { 1448, 512, -480},
    { 1256, 240, -328},
    { 1144, 360, -288},
    { 1136, 264, -192},
    { 1160, 232, -184},
    { 1200, 272, -152},
    { 1272, 200, -176},
    { 1184, 144, -216},
    { 936, 72, -272},
    // 55 seconds
    { 736, -152, -152},
    { 456, -168, -216},
    { 528, -56, -560},
    { 736, -8, -520},
    { 1160, 0, -496},
    { 1128, 64, -480},
    { 1080, 272, -408},
    { 1184, 320, -408},
    { 1256, 408, -616},
    { 1296, 544, -472},
    { 1248, 544, -624},
    { 1032, 736, -760},
    { 992, 752, -664},
    { 1280, 896, -640},
    { 888, 568, -488},
    { 1064, 560, -440},
    { 1392, 472, -424},
    { 1280, 264, -320},
    { 1032, 248, -280},
    { 1064, 184, -272},
    { 1176, 152, -232},
    { 1240, 152, -280},
    { 1240, 88, -272},
    { 1088, 40, -256},
    { 872, -96, -160},
    // 56 seconds
    { 600, -264, -272},
    { 648, -104, -224},
    { 664, -88, -464},
    { 800, -24, -408},
    { 1192, 32, -512},
    { 1184, 88, -400},
    { 1096, 232, -384},
    { 1048, 432, -456},
    { 1120, 432, -496},
    { 1248, 448, -512},
    { 1048, 424, -632},
    { 936, 584, -736},
    { 936, 632, -672},
    { 1152, 800, -624},
    { 1064, 640, -568},
    { 1328, 560, -488},
    { 1432, 448, -488},
    { 1232, 232, -448},
    { 1008, 160, -344},
    { 1080, -320, -64},
    { 728, 16, -280},
    { 880, 136, -240},
    { 1000, 136, -248},
    { 1040, 48, -264},
    { 1024, 56, -256},
    // 57 seconds
    { 776, 40, -336},
    { 784, -104, -272},
    { 504, -200, -344},
    { 712, -8, -512},
    { 944, -56, -456},
    { 1208, 56, -432},
    { 1056, 104, -464},
    { 960, 176, -336},
    { 1120, 304, -344},
    { 1264, 480, -448},
    { 1240, 584, -512},
    { 1080, 616, -608},
    { 888, 776, -672},
    { 1048, 680, -608},
    { 1248, 872, -536},
    { 1056, 656, -472},
    { 1032, 576, -416},
    { 1168, 544, -336},
    { 1360, 368, -328},
    { 1160, 680, -312},
    { 1064, 168, -288},
    { 928, 112, -160},
    { 936, 216, -160},
    { 1088, 152, -168},
    { 1176, 160, -216},
    // 58 seconds
    { 1144, 96, -272},
    { 872, -120, -328},
    { 880, -16, -328},
    { 536, 0, -456},
    { 696, 80, -536},
    { 1120, 120, -616},
    { 1168, 96, -464},
    { 960, 184, -400},
    { 896, 256, -272},
    { 1048, 392, -264},
    { 1272, 584, -344},
    { 1112, 704, -320},
    { 752, 832, -344},
    { 576, 976, -352},
    { 880, 920, -288},
    { 1400, 640, -392},
    { 1736, 472, -480},
    { 1456, 496, -472},
    { 1224, 400, -384},
    { 1296, 152, -88},
    { 1752, 192, 216},
    { 1544, 128, 232},
    { 1256, 200, 120},
    { 1056, 256, 56},
    { 952, 216, -16},
    // 59 seconds
    { 696, 456, 0},
    { 400, 680, 136},
    { 176, 736, 192},
    { 16, 840, 200},
    { -48, 680, 336},
    { -160, 848, 280},
    { -144, 840, 216},
    { -168, 816, 400},
    { -112, 928, 432},
    { -72, 1288, 224},
    { -104, 824, 600},
    { -112, 880, 376},
    { -168, 736, 416},
    { -240, 768, 360},
    { -328, 816, 64},
    { -344, 1008, 192},
    { -288, 872, 200},
    { -368, 904, 352},
    { -352, 824, 272},
    { -344, 1048, 96},
    { -304, 864, 288},
    { -336, 776, 296},
    { -360, 624, 184},
    { -424, 768, 16},
    { -440, 744, 152},
    // 60 seconds
    // elapsed: 1 minutes
    { -424, 760, 96},
    { -424, 800, 88},
    { -400, 808, -72},
    { -392, 896, -72},
    { -448, 872, 40},
    { -448, 880, 64},
    { -456, 856, 48},
    { -432, 840, 8},
    { -456, 840, 0},
    { -464, 896, -8},
    { -448, 904, 0},
    { -424, 920, -16},
    { -344, 848, -40},
    { -384, 896, -128},
    { -408, 960, 56},
    { -440, 896, 88},
    { -504, 872, 24},
    { -440, 912, -96},
    { -368, 920, -200},
    { -368, 920, -88},
    { -280, 880, 48},
    { -240, 816, 88},
    { -232, 704, 88},
    { -288, 688, 152},
    { -344, 832, 264},
    // 61 seconds
    { -352, 944, 328},
    { -344, 824, 272},
    { -360, 872, 256},
    { -344, 816, 304},
    { -368, 848, 328},
    { -352, 784, 312},
    { -368, 816, 344},
    { -368, 840, 344},
    { -368, 816, 376},
    { -392, 784, 416},
    { -416, 776, 432},
    { -424, 768, 424},
    { -440, 752, 424},
    { -408, 792, 400},
    { -360, 784, 384},
    { -368, 808, 312},
    { -360, 824, 312},
    { -376, 816, 360},
    { -384, 816, 328},
    { -360, 816, 288},
    { -368, 800, 312},
    { -336, 808, 296},
    { -304, 848, 224},
    { -328, 776, 200},
    { -376, 1056, 208},
    // 62 seconds
    { -408, 832, 328},
    { -440, 824, 352},
    { -392, 824, 296},
    { -360, 864, 632},
    { -328, 960, 608},
    { -344, 792, 496},
    { -296, 608, 216},
    { -216, 832, -40},
    { -288, 800, 152},
    { -296, 896, 200},
    { -384, 896, 328},
    { -376, 824, 256},
    { -360, 848, 128},
    { -352, 816, 144},
    { -408, 920, 176},
    { -424, 1008, 136},
    { -544, 944, 24},
    { -648, 928, -160},
    { -624, 840, -312},
    { -528, 960, -512},
    { -360, 504, -736},
    { -152, 352, -872},
    { -88, -152, -920},
    { -32, -136, -944},
    { -24, -80, -984},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:01:45 local
AccelRawData *activity_sample_walk_100_pbl_25663_6(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25663_6
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 70
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 280, -48, -968},
    { 136, -112, -912},
    { 72, -112, -960},
    { 56, -256, -800},
    { 32, -232, -816},
    { 0, -168, -904},
    { -48, -376, -848},
    { -32, -224, -920},
    { -8, -400, -888},
    { 32, -264, -1056},
    { 24, -352, -1048},
    { -128, -360, -960},
    { -96, -368, -944},
    { -384, -456, -952},
    { -136, -448, -952},
    { -232, -352, -944},
    { -272, -360, -992},
    { -224, -528, -912},
    { -224, -488, -920},
    { -232, -496, -928},
    { -256, -336, -912},
    { -280, -264, -1008},
    { -104, -392, -1024},
    { -40, -384, -1000},
    { -48, -368, -1000},
    // 1 seconds
    { -112, -304, -1008},
    { -64, -424, -896},
    { 304, -360, -1008},
    { -40, -360, -936},
    { -40, -384, -952},
    { -24, -368, -976},
    { -40, -360, -1000},
    { -32, -376, -1016},
    { -40, -392, -1000},
    { -40, -392, -984},
    { -56, -424, -976},
    { -48, -424, -968},
    { -24, -432, -968},
    { 0, -408, -960},
    { 0, -392, -936},
    { -16, -376, -920},
    { -32, -344, -928},
    { -64, -344, -944},
    { -88, -328, -976},
    { -104, -328, -1008},
    { -120, -304, -1016},
    { -152, -304, -1040},
    { -184, -272, -1048},
    { -208, -280, -1056},
    { -232, -304, -1056},
    // 2 seconds
    { -192, -320, -1056},
    { -152, -328, -1040},
    { -128, -336, -1000},
    { -128, -336, -968},
    { -136, -360, -936},
    { -168, -368, -904},
    { -200, -408, -888},
    { -256, -408, -880},
    { -264, -448, -896},
    { -296, -456, -912},
    { -296, -512, -952},
    { -288, -480, -992},
    { -232, -456, -1096},
    { -80, -440, -1256},
    { 8, -312, -1248},
    { 120, -232, -1248},
    { 224, -232, -1040},
    { 248, -136, -880},
    { 312, -128, -560},
    { 328, -32, -320},
    { 264, -32, -216},
    { 280, -40, -224},
    { 384, 0, -448},
    { 568, 224, -752},
    { 888, 152, -704},
    // 3 seconds
    { 1016, 504, -616},
    { 1312, 720, -976},
    { 1616, 408, -864},
    { 2136, 1000, -864},
    { 1456, 1136, -1136},
    { 912, 248, -704},
    { 720, 792, -928},
    { 888, 776, -744},
    { 1088, 496, -464},
    { 1192, 480, -496},
    { 1264, 624, -520},
    { 1360, 560, -496},
    { 1336, 480, -432},
    { 1184, 288, -432},
    { 992, 152, -448},
    { 728, -32, -520},
    { 432, -168, -608},
    { 280, -368, -704},
    { 48, -376, -808},
    { 16, -400, -704},
    { 120, -312, -1000},
    { 208, -248, -1040},
    { 32, -352, -960},
    { -128, -352, -920},
    { -208, -328, -944},
    // 4 seconds
    { -200, -328, -1000},
    { -192, -296, -968},
    { -144, -304, -1024},
    { -136, -336, -1040},
    { -152, -384, -1104},
    { -120, -400, -1168},
    { -224, -400, -920},
    { -200, -336, -912},
    { -304, 152, -1224},
    { 40, -232, -920},
    { 24, -368, -904},
    { -144, -368, -960},
    { -256, -344, -912},
    { -216, -280, -920},
    { -216, -288, -944},
    { -232, -336, -968},
    { -208, -304, -1024},
    { -248, -416, -984},
    { -296, -416, -1000},
    { -344, -432, -992},
    { -288, -432, -992},
    { -248, -448, -1008},
    { -224, -416, -944},
    { -232, -408, -888},
    { -232, -416, -864},
    // 5 seconds
    { -248, -440, -848},
    { -224, -424, -912},
    { -200, -424, -952},
    { -184, -456, -952},
    { -168, -480, -952},
    { -192, -480, -912},
    { -192, -464, -904},
    { -176, -472, -912},
    { -176, -488, -904},
    { -176, -504, -912},
    { -176, -512, -896},
    { -184, -520, -896},
    { -184, -520, -904},
    { -192, -504, -912},
    { -224, -480, -912},
    { -224, -496, -888},
    { -264, -528, -872},
    { -248, -520, -896},
    { -352, -808, -296},
    { 200, -560, -856},
    { -152, -560, -864},
    { -144, -544, -864},
    { -136, -544, -864},
    { -176, -544, -864},
    { -184, -536, -880},
    // 6 seconds
    { -208, -552, -904},
    { -224, -584, -944},
    { -240, -552, -968},
    { -264, -568, -1000},
    { -176, -408, -1136},
    { -120, -432, -1192},
    { -208, -464, -1024},
    { -272, -344, -1008},
    { -192, -248, -1040},
    { -136, -264, -952},
    { -240, -328, -880},
    { -272, -368, -808},
    { -224, -320, -784},
    { -240, -312, -760},
    { -200, -296, -760},
    { -144, -288, -696},
    { -88, -360, -600},
    { 40, -360, -552},
    { 288, -240, -440},
    { 720, -48, -392},
    { 1256, 104, -400},
    { 1488, 368, -400},
    { 1752, 488, -504},
    { 1856, 520, -448},
    { 1536, 472, -320},
    // 7 seconds
    { 1392, 480, -296},
    { 1192, 424, -192},
    { 1056, 408, -104},
    { 968, 512, -128},
    { 936, 496, -160},
    { 792, 584, -248},
    { 696, 704, -376},
    { 856, 824, -424},
    { 1152, 816, -392},
    { 1328, 696, -376},
    { 1248, 552, -344},
    { 1288, 480, -280},
    { 1384, 440, -264},
    { 1416, 336, -160},
    { 1368, 336, -176},
    { 1368, 344, -136},
    { 1224, 368, -112},
    { 1032, 352, -112},
    { 944, 272, -120},
    { 872, 224, -128},
    { 824, 136, -200},
    { 640, 8, -240},
    { 472, -8, -336},
    { 440, -16, -416},
    { 736, 80, -464},
    // 8 seconds
    { 1176, 128, -504},
    { 1232, 104, -368},
    { 1248, 304, -392},
    { 1296, 392, -336},
    { 1320, 592, -352},
    { 1352, 432, -344},
    { 1272, 584, -344},
    { 1048, 792, -408},
    { 1096, 864, -472},
    { 1104, 992, -480},
    { 864, 784, -416},
    { 944, 704, -312},
    { 1184, 576, -256},
    { 1272, 368, -216},
    { 1144, 280, -168},
    { 1120, 200, -152},
    { 1216, 272, -160},
    { 1408, 248, -160},
    { 1264, 168, -120},
    { 1168, 176, -208},
    { 1144, 136, -240},
    { 696, -152, -192},
    { 688, -64, -120},
    { 576, -88, -368},
    { 752, 8, -400},
    // 9 seconds
    { 1128, 104, -400},
    { 1128, 144, -304},
    { 1072, 288, -336},
    { 1096, 304, -216},
    { 1232, 536, -256},
    { 1264, 568, -264},
    { 1176, 608, -296},
    { 848, 632, -440},
    { 712, 776, -456},
    { 992, 848, -368},
    { 1320, 896, -352},
    { 1392, 632, -312},
    { 1248, 560, -256},
    { 1336, 432, -240},
    { 1160, 160, -152},
    { 1008, 240, -184},
    { 1096, 224, -248},
    { 1216, 280, -232},
    { 1208, 208, -160},
    { 1112, 136, -192},
    { 1000, 112, -128},
    { 616, -128, -88},
    { 648, -96, -112},
    { 648, -72, -256},
    { 880, 16, -376},
    // 10 seconds
    { 1400, 152, -464},
    { 1456, 216, -424},
    { 1240, 208, -360},
    { 1080, 392, -416},
    { 1072, 344, -368},
    { 1152, 504, -424},
    { 1136, 496, -496},
    { 920, 632, -616},
    { 872, 784, -648},
    { 1040, 680, -512},
    { 1336, 832, -440},
    { 1344, 584, -352},
    { 1264, 512, -344},
    { 1352, 424, -312},
    { 1264, 312, -184},
    { 1000, -208, -104},
    { 1008, 288, -224},
    { 1256, 168, -40},
    { 1040, 120, -24},
    { 1120, 192, -96},
    { 1064, 104, -32},
    { 760, 16, -208},
    { 744, -24, -120},
    { 584, 0, -296},
    { 704, -24, -432},
    // 11 seconds
    { 1168, 112, -472},
    { 1240, 160, -440},
    { 1000, 104, -360},
    { 1016, 272, -352},
    { 1112, 416, -408},
    { 1224, 576, -528},
    { 1112, 648, -640},
    { 952, 744, -728},
    { 992, 904, -680},
    { 1352, 920, -512},
    { 1160, 584, -416},
    { 1144, 560, -344},
    { 1256, 488, -232},
    { 1264, 328, -200},
    { 1096, 280, -176},
    { 1040, 216, -176},
    { 1152, 216, -216},
    { 1280, 240, -176},
    { 1160, 176, -280},
    { 1024, 96, -328},
    { 728, -160, -120},
    { 568, -112, -200},
    { 640, -8, -288},
    { 440, -16, -416},
    { 936, 104, -512},
    // 12 seconds
    { 1320, 120, -440},
    { 1336, 152, -400},
    { 1304, 408, -448},
    { 1192, 408, -368},
    { 1192, 496, -416},
    { 1288, 448, -352},
    { 1120, 640, -528},
    { 920, 776, -672},
    { 1016, 936, -696},
    { 1312, 880, -576},
    { 1048, 576, -440},
    { 1064, 496, -328},
    { 1280, 392, -192},
    { 1192, 192, -168},
    { 984, 224, -136},
    { 1024, 232, -128},
    { 1288, 232, -192},
    { 1280, 200, -88},
    { 1168, 152, -112},
    { 1112, 64, -152},
    { 816, -200, -104},
    { 1120, 40, -128},
    { 456, -120, -440},
    { 912, 136, -504},
    { 1104, 48, -384},
    // 13 seconds
    { 1056, 128, -304},
    { 968, 240, -336},
    { 1040, 296, -288},
    { 1168, 424, -256},
    { 1256, 472, -368},
    { 1184, 552, -312},
    { 1128, 544, -496},
    { 984, 792, -552},
    { 1000, 880, -536},
    { 1240, 912, -520},
    { 1136, 512, -456},
    { 1120, 544, -440},
    { 1384, 488, -352},
    { 1240, 200, -272},
    { 1056, 0, -80},
    { 1096, 240, -176},
    { 1088, 168, -160},
    { 1200, 208, -112},
    { 1088, 192, -88},
    { 1024, 112, -152},
    { 984, 128, -200},
    { 704, -184, -136},
    { 664, -144, -96},
    { 856, 64, -416},
    { 1200, 136, -528},
    // 14 seconds
    { 1472, 216, -448},
    { 1144, 200, -384},
    { 952, 304, -376},
    { 1000, 336, -296},
    { 1152, 504, -296},
    { 1216, 608, -352},
    { 1056, 768, -464},
    { 928, 840, -488},
    { 944, 768, -448},
    { 1208, 1024, -392},
    { 1048, 664, -192},
    { 1168, 568, -272},
    { 1472, 744, -440},
    { 1456, 224, -312},
    { 1224, 320, -496},
    { 1144, 168, -296},
    { 1344, 40, -280},
    { 1200, 56, -264},
    { 1112, 48, -296},
    { 904, -176, -200},
    { 320, -296, -48},
    { 96, -208, -136},
    { 280, 0, -504},
    { 440, -104, -440},
    { 1104, -8, -440},
    // 15 seconds
    { 1512, 288, -632},
    { 1320, 208, -416},
    { 1192, 760, -784},
    { 960, 56, -352},
    { 1392, 216, -496},
    { 1280, 288, -600},
    { 1152, 648, -656},
    { 992, 992, -856},
    { 848, 688, -648},
    { 984, 1016, -568},
    { 1048, 864, -480},
    { 1248, 568, -336},
    { 1416, 416, -320},
    { 1312, 64, -176},
    { 1168, 208, -240},
    { 1304, 224, -264},
    { 1568, 280, -208},
    { 1448, 152, -160},
    { 1328, 72, -120},
    { 1248, 160, -160},
    { 1016, 120, -264},
    { 904, -72, -48},
    { 224, -312, -136},
    { 552, -16, -496},
    { 640, -104, -520},
    // 16 seconds
    { 800, -200, -312},
    { 824, 32, -384},
    { 944, 160, -440},
    { 1296, 216, -360},
    { 1776, 464, -488},
    { 1592, 968, -720},
    { 1328, 568, -672},
    { 1256, 792, -736},
    { 896, 1264, -680},
    { 1088, 1064, -528},
    { 920, 656, -400},
    { 1216, 1296, 264},
    { 1280, 408, -168},
    { 1080, 288, -160},
    { 1016, 96, -136},
    { 1032, 232, -192},
    { 1152, 168, -152},
    { 1416, -80, -112},
    { 1176, 160, -96},
    { 1184, 176, -256},
    { 848, -16, -304},
    { 608, -208, -56},
    { 488, -80, -320},
    { 608, -64, -576},
    { 1184, 40, -520},
    // 17 seconds
    { 1336, 192, -464},
    { 1144, 96, -384},
    { 1032, 352, -392},
    { 1080, 552, -496},
    { 1024, 616, -504},
    { 880, 832, -552},
    { 832, 952, -640},
    { 1064, 776, -424},
    { 1056, 720, -384},
    { 1248, 736, -248},
    { 1104, 504, -192},
    { 1328, 424, -192},
    { 1456, 296, -136},
    { 1096, 176, -88},
    { 816, 168, -160},
    { 776, 112, -168},
    { 856, 152, -192},
    { 920, 144, -248},
    { 904, 104, -248},
    { 984, 96, -288},
    { 744, -64, -344},
    { 824, -16, -200},
    { 664, 24, -320},
    { 992, 144, -472},
    { 1424, 224, -528},
    // 18 seconds
    { 1160, 80, -328},
    { 832, 120, -376},
    { 808, 216, -368},
    { 920, 360, -376},
    { 1008, 408, -352},
    { 1104, 448, -432},
    { 984, 608, -496},
    { 1056, 672, -512},
    { 1280, 656, -544},
    { 1376, 712, -472},
    { 1008, 608, -408},
    { 1000, 440, -360},
    { 1320, 264, -336},
    { 1128, -192, 40},
    { 992, 240, -160},
    { 920, 136, 216},
    { 896, 184, -80},
    { 1096, 96, -112},
    { 1280, 112, -104},
    { 1152, 64, -40},
    { 1072, 136, -192},
    { 936, -112, -8},
    { 536, 24, -104},
    { 696, 0, -392},
    { 1248, 16, -440},
    // 19 seconds
    { 1360, 240, -392},
    { 1088, 128, -440},
    { 1056, 256, -504},
    { 952, 416, -312},
    { 1112, 432, -432},
    { 1296, 440, -432},
    { 1104, 616, -520},
    { 904, 792, -696},
    { 1168, 744, -608},
    { 1264, 760, -560},
    { 1064, 568, -384},
    { 1184, 472, -360},
    { 1440, 336, -216},
    { 1360, 328, -304},
    { 1048, 208, -80},
    { 1024, 88, -16},
    { 1000, 184, -40},
    { 1120, 216, -128},
    { 1184, 152, -80},
    { 1160, 200, -176},
    { 880, -32, -352},
    { 768, -296, -104},
    { 632, -160, -456},
    { 920, 0, -488},
    { 1248, 0, -520},
    // 20 seconds
    { 1176, 136, -392},
    { 984, 136, -392},
    { 1024, 280, -312},
    { 1208, 520, -520},
    { 1328, 472, -384},
    { 1296, 632, -504},
    { 952, 576, -592},
    { 952, 664, -592},
    { 1112, 664, -584},
    { 1096, 616, -432},
    { 1072, 560, -368},
    { 1304, 432, -360},
    { 1464, 424, -256},
    { 1248, -32, -160},
    { 1112, 136, -152},
    { 1160, 272, -200},
    { 1200, -48, -64},
    { 1200, 240, -136},
    { 1080, 64, -24},
    { 968, -24, -16},
    { 776, -88, -128},
    { 944, 8, -40},
    { 712, 40, -248},
    { 1120, 136, -392},
    { 1272, 184, -368},
    // 21 seconds
    { 1120, 120, -288},
    { 968, 192, -320},
    { 984, 288, -272},
    { 1192, 408, -296},
    { 1392, 464, -344},
    { 1256, 600, -400},
    { 976, 672, -592},
    { 968, 728, -656},
    { 1216, 888, -704},
    { 1040, 544, -480},
    { 1192, 536, -480},
    { 1504, 536, -264},
    { 1280, 128, -240},
    { 1112, 176, -160},
    { 784, 240, -96},
    { 1104, 16, 16},
    { 1368, -128, -152},
    { 1216, 456, 176},
    { 1112, 160, -24},
    { 944, -32, -264},
    { 704, -96, -176},
    { 720, -80, -424},
    { 680, -168, -488},
    { 1208, 8, -568},
    { 1368, 8, -568},
    // 22 seconds
    { 1088, 24, -400},
    { 944, 256, -424},
    { 920, 264, -360},
    { 1136, 384, -360},
    { 1208, 448, -368},
    { 1064, 568, -456},
    { 776, 768, -600},
    { 1000, 848, -568},
    { 1328, 904, -496},
    { 1288, 632, -448},
    { 1128, 544, -400},
    { 1224, 464, -288},
    { 1504, 288, -280},
    { 1248, 80, -88},
    { 1088, 240, -176},
    { 1160, 208, -160},
    { 1208, 240, -176},
    { 1120, 152, -136},
    { 984, 200, -200},
    { 920, 112, -296},
    { 760, -32, -296},
    { 496, -128, -320},
    { 528, -144, -368},
    { 648, -184, -424},
    { 1272, 88, -496},
    // 23 seconds
    { 1784, 168, -520},
    { 1832, 184, -424},
    { 1328, 568, -496},
    { 896, 376, -216},
    { 1160, 416, -384},
    { 1088, 536, -344},
    { 928, 664, -464},
    { 824, 720, -632},
    { 912, 800, -600},
    { 1032, 624, -472},
    { 1288, 688, -408},
    { 1344, 552, -312},
    { 1536, 456, -280},
    { 1808, 320, -248},
    { 1592, 200, -144},
    { 1256, 176, -208},
    { 1128, 152, -216},
    { 1088, 168, -192},
    { 1072, 152, -168},
    { 1152, 168, -200},
    { 1232, 104, -232},
    { 920, -88, -176},
    { 736, -208, -88},
    { 408, -216, -368},
    { 912, -48, -496},
    // 24 seconds
    { 1112, -32, -416},
    { 1384, 8, -440},
    { 1320, 96, -368},
    { 1248, 256, -288},
    { 1336, 376, -248},
    { 1448, 560, -344},
    { 1488, 592, -416},
    { 1296, 736, -640},
    { 920, 920, -768},
    { 944, 672, -656},
    { 968, 808, -568},
    { 1032, 736, -432},
    { 1344, 584, -304},
    { 1512, 120, -160},
    { 1200, 184, -184},
    { 1096, 368, -96},
    { 1128, -152, -72},
    { 1280, 200, -56},
    { 1512, 128, -8},
    { 1400, -144, 208},
    { 1328, 104, -112},
    { 832, -104, -120},
    { 600, -232, -24},
    { 672, -128, -256},
    { 936, -32, -472},
    // 25 seconds
    { 1168, 40, -448},
    { 1048, 128, -496},
    { 888, 24, -392},
    { 984, 216, -400},
    { 1216, 408, -800},
    { 1088, 1128, -944},
    { 1024, 608, -816},
    { 968, 688, -824},
    { 968, 344, -464},
    { 1296, 592, -376},
    { 1144, 576, -336},
    { 1328, 368, -280},
    { 1296, 264, -184},
    { 1024, 184, -200},
    { 752, 192, -200},
    { 784, 152, -224},
    { 888, 136, -272},
    { 1088, 152, -288},
    { 1144, 96, -320},
    { 1080, -8, -328},
    { 696, -336, -216},
    { 712, -232, -240},
    { 736, -120, -392},
    { 1104, -64, -368},
    { 1448, 144, -472},
    // 26 seconds
    { 1280, 128, -392},
    { 1040, 128, -280},
    { 1040, 376, -264},
    { 1120, 496, -336},
    { 1104, 592, -376},
    { 1048, 536, -448},
    { 920, 648, -584},
    { 1000, 584, -632},
    { 1112, 512, -544},
    { 1240, 504, -552},
    { 1136, 520, -488},
    { 1344, 320, -456},
    { 1320, 304, -384},
    { 1160, 24, -152},
    { 1024, 112, -208},
    { 944, 200, -120},
    { 1096, 136, -40},
    { 1096, 80, -24},
    { 1168, 224, 0},
    { 1168, -16, 0},
    { 824, 48, -64},
    { 808, 40, -48},
    { 648, 56, -304},
    { 920, 40, -448},
    { 1512, 112, -600},
    // 27 seconds
    { 1272, -32, -504},
    { 928, -48, -448},
    { 824, 216, -440},
    { 952, 280, -440},
    { 1072, 480, -496},
    { 1040, 488, -504},
    { 960, 616, -576},
    { 1008, 624, -480},
    { 1040, 600, -400},
    { 1120, 608, -416},
    { 1200, 496, -296},
    { 1320, 408, -296},
    { 1328, 392, -256},
    { 1112, -96, -152},
    { 888, 808, -312},
    { 984, -136, 32},
    { 1008, 96, -64},
    { 976, 136, -120},
    { 1048, 40, -136},
    { 992, 32, -168},
    { 808, -80, -264},
    { 760, -120, -264},
    { 904, -80, -360},
    { 1136, -16, -432},
    { 1352, 72, -464},
    // 28 seconds
    { 1224, 56, -424},
    { 920, 160, -392},
    { 768, 248, -368},
    { 928, 272, -336},
    { 1128, 320, -424},
    { 1120, 336, -576},
    { 856, 304, -800},
    { 920, 256, -872},
    { 1088, 424, -744},
    { 1256, 952, -752},
    { 1368, 408, -640},
    { 1416, 456, -408},
    { 1552, 376, -288},
    { 1352, 144, -216},
    { 1160, 152, -200},
    { 1120, 256, -240},
    { 1088, 240, -248},
    { 1024, 248, -224},
    { 968, 96, -240},
    { 832, 40, -240},
    { 592, -120, -208},
    { 512, -136, -344},
    { 568, -64, -392},
    { 696, -96, -488},
    { 1168, 64, -472},
    // 29 seconds
    { 1632, 80, -448},
    { 1648, 112, -376},
    { 1376, 448, -480},
    { 1112, 448, -440},
    { 1304, 312, -312},
    { 1280, 432, -376},
    { 1024, 400, -408},
    { 816, 496, -536},
    { 896, 632, -656},
    { 1176, 664, -624},
    { 1112, 552, -536},
    { 1296, 648, -568},
    { 1560, 392, -408},
    { 1400, 696, -520},
    { 1424, 272, -256},
    { 1064, 320, -208},
    { 872, 256, -112},
    { 800, 304, -168},
    { 856, 232, -176},
    { 904, 208, -88},
    { 952, 112, -96},
    { 848, 96, -248},
    { 1048, 176, -304},
    { 752, -24, -360},
    { 912, 72, -560},
    // 30 seconds
    { 1152, 64, -576},
    { 1192, -88, -368},
    { 1080, 72, -352},
    { 1080, 440, -432},
    { 1184, 416, -432},
    { 1272, 536, -256},
    { 1288, 672, -264},
    { 984, 680, -392},
    { 816, 688, -376},
    { 1128, 752, -336},
    { 1176, 784, -368},
    { 1168, 568, -336},
    { 1096, 584, -368},
    { 1256, 424, -328},
    { 1144, 312, -248},
    { 1216, 520, -240},
    { 1272, 176, -112},
    { 1208, 472, -200},
    { 1192, 168, -72},
    { 952, 208, -168},
    { 808, 136, -232},
    { 608, 88, -248},
    { 584, 0, -304},
    { 568, -56, -336},
    { 696, -56, -488},
    // 31 seconds
    { 1304, 144, -552},
    { 1400, 40, -512},
    { 1280, 136, -480},
    { 1048, 296, -368},
    { 1192, 248, -304},
    { 1344, 488, -376},
    { 1416, 536, -472},
    { 1056, 680, -704},
    { 632, 1088, -912},
    { 864, 944, -752},
    { 1328, 1120, -600},
    { 1216, 864, -416},
    { 1656, 840, -320},
    { 1808, 832, -232},
    { 1600, 816, -216},
    { 1512, 720, -296},
    { 1320, 584, -208},
    { 1128, 488, -168},
    { 1152, 344, -176},
    { 944, 48, -168},
    { 744, -56, -192},
    { 624, -328, -176},
    { 536, -224, -488},
    { 480, -32, -1264},
    { -104, 424, -1792},
    // 32 seconds
    { 136, 48, -1704},
    { 112, 160, -1296},
    { 72, -168, -744},
    { 64, -216, -568},
    { 88, -392, -512},
    { 24, -392, -528},
    { -24, -424, -784},
    { -144, -472, -968},
    { -344, -440, -1272},
    { -304, -392, -1400},
    { -296, -168, -1656},
    { -112, -104, -1432},
    { -232, -24, -1272},
    { -176, 96, -1280},
    { -48, 32, -1048},
    { -32, -64, -792},
    { -64, -56, -712},
    { -104, -72, -696},
    { -72, -112, -704},
    { -48, -144, -784},
    { -16, -120, -952},
    { 96, -112, -1072},
    { 24, -152, -1064},
    { 112, -104, -1384},
    { 56, 16, -1224},
    // 33 seconds
    { 88, -32, -1224},
    { 64, 56, -1048},
    { -16, -16, -880},
    { -104, -16, -728},
    { -128, -24, -648},
    { -128, 24, -696},
    { -184, 40, -824},
    { -248, 136, -1000},
    { -376, 216, -1192},
    { -344, 328, -1352},
    { -448, 200, -1864},
    { -88, 688, -1552},
    { -192, 304, -1176},
    { -232, 336, -1096},
    { -152, 320, -1016},
    { -88, 152, -768},
    { -136, 160, -736},
    { -232, 152, -776},
    { -224, 80, -744},
    { -184, 16, -656},
    { -88, -32, -648},
    { 40, -216, -472},
    { 232, -136, -408},
    { 576, 16, -576},
    { 872, -152, -360},
    // 34 seconds
    { 1400, -8, -480},
    { 2104, 328, -584},
    { 1912, 328, -512},
    { 1728, 392, -400},
    { 1296, 640, -440},
    { 1216, 512, -304},
    { 1320, 504, -240},
    { 1032, 672, -320},
    { 696, 672, -440},
    { 728, 832, -560},
    { 1120, 760, -544},
    { 1200, 864, -568},
    { 1000, 536, -520},
    { 1144, 672, -432},
    { 1424, 432, -368},
    { 1616, 288, -232},
    { 1416, 184, -152},
    { 1336, 256, -160},
    { 1288, 200, -168},
    { 1336, 208, -96},
    { 1176, 208, -160},
    { 952, 112, -232},
    { 960, 168, -328},
    { 560, -248, -184},
    { 408, -200, -184},
    // 35 seconds
    { 520, -152, -520},
    { 752, 8, -480},
    { 1224, 56, -528},
    { 1344, 104, -424},
    { 1392, 304, -376},
    { 1344, 592, -320},
    { 1320, 640, -424},
    { 1480, 336, -296},
    { 1240, 512, -472},
    { 864, 584, -472},
    { 968, 712, -720},
    { 1240, 936, -592},
    { 1080, 632, -536},
    { 1024, 600, -512},
    { 1176, 608, -344},
    { 1424, 304, -248},
    { 1240, 208, -192},
    { 1072, 96, -160},
    { 1176, 176, -240},
    { 1256, 232, -248},
    { 1448, 280, -168},
    { 1240, 240, -200},
    { 1008, 136, -256},
    { 856, 160, -352},
    { 776, -104, -144},
    // 36 seconds
    { 296, -304, -344},
    { 568, -184, -496},
    { 1008, -32, -464},
    { 1168, 0, -408},
    { 1152, 96, -392},
    { 1216, 376, -368},
    { 1440, 352, -296},
    { 1560, 632, -400},
    { 1416, 552, -296},
    { 1128, 672, -592},
    { 904, 936, -664},
    { 1104, 1128, -624},
    { 1128, 840, -504},
    { 1152, 640, -456},
    { 1256, 560, -408},
    { 1480, 528, -320},
    { 1272, -152, -288},
    { 1208, -104, -112},
    { 1320, 224, -224},
    { 1328, 200, -112},
    { 1344, 224, -200},
    { 1256, 136, -192},
    { 1064, 168, -224},
    { 1000, 112, -312},
    { 808, -128, 24},
    // 37 seconds
    { 248, -264, -384},
    { 768, -136, -456},
    { 1072, -136, -296},
    { 1264, 48, -336},
    { 1144, 160, -440},
    { 1320, 208, -416},
    { 1568, 520, -352},
    { 1752, 712, -488},
    { 1464, 568, -304},
    { 1160, 664, -432},
    { 872, 856, -504},
    { 1112, 792, -488},
    { 1264, 1040, -496},
    { 952, 664, -472},
    { 1048, 608, -424},
    { 1336, 440, -272},
    { 1384, 400, -272},
    { 1240, 32, -160},
    { 1240, 264, -168},
    { 1392, 184, -176},
    { 1696, 248, -168},
    { 1536, 152, -40},
    { 1184, 192, -192},
    { 1008, 72, -456},
    { 608, -232, -136},
    // 38 seconds
    { 296, -240, -296},
    { 448, -288, -432},
    { 800, 40, -400},
    { 1104, 40, -400},
    { 1168, 176, -440},
    { 1400, 328, -408},
    { 1712, 432, -304},
    { 1592, 992, -584},
    { 1560, 288, -344},
    { 1176, 576, -496},
    { 952, 840, -544},
    { 1144, 664, -584},
    { 1024, 712, -472},
    { 992, 592, -504},
    { 976, 528, -504},
    { 1152, 456, -400},
    { 1240, 280, -240},
    { 1168, 200, -208},
    { 1200, 136, -48},
    { 1416, 272, -264},
    { 1384, 112, -144},
    { 1288, 232, -176},
    { 1160, 144, -144},
    { 960, 160, -272},
    { 1072, 112, -104},
    // 39 seconds
    { 272, -312, -272},
    { 640, 0, -552},
    { 912, -160, -480},
    { 944, -104, -328},
    { 832, -16, -400},
    { 984, 160, -408},
    { 1280, 288, -320},
    { 1664, 392, -416},
    { 1640, 680, -568},
    { 1200, 544, -384},
    { 1208, 864, -504},
    { 1136, 1272, -512},
    { 1256, 1184, -544},
    { 1008, 656, -544},
    { 1024, 672, -472},
    { 1376, 568, -256},
    { 1528, 376, -176},
    { 1328, -88, -104},
    { 1256, 248, -136},
    { 1264, 184, -96},
    { 1320, 264, -88},
    { 1184, 168, -64},
    { 1080, 168, -64},
    { 904, 208, -176},
    { 752, 136, -360},
    // 40 seconds
    { 488, -152, -112},
    { 264, -152, -256},
    { 656, -88, -400},
    { 968, 80, -328},
    { 1432, 208, -456},
    { 1416, 248, -416},
    { 1528, 352, -368},
    { 1560, 728, -408},
    { 1648, 384, -344},
    { 1256, 768, -432},
    { 720, 1072, -576},
    { 912, 1024, -576},
    { 1088, 960, -536},
    { 1112, 800, -400},
    { 1104, 568, -280},
    { 1248, 504, -256},
    { 1608, 592, -152},
    { 1536, 344, -112},
    { 1376, -88, 48},
    { 1296, 128, -240},
    { 1176, 56, -24},
    { 1072, 272, -104},
    { 1008, 136, -112},
    { 912, 152, -120},
    { 856, 120, -112},
    // 41 seconds
    { 680, -272, 0},
    { 624, 24, -192},
    { 864, -72, -528},
    { 1176, 80, -336},
    { 1336, 200, -384},
    { 1240, 96, -288},
    { 1312, 360, -256},
    { 1520, 552, -352},
    { 1576, 536, -192},
    { 1400, 744, -240},
    { 1056, 768, -304},
    { 816, 960, -392},
    { 840, 984, -392},
    { 1056, 1120, -384},
    { 1160, 752, -288},
    { 1256, 672, -256},
    { 1576, 592, -152},
    { 1456, 248, -88},
    { 1184, 240, -160},
    { 1208, 208, -136},
    { 1312, 192, -128},
    { 1496, 224, -152},
    { 1512, 112, -104},
    { 1088, 104, -176},
    { 976, -56, -312},
    // 42 seconds
    { 768, -224, -80},
    { 368, -280, -344},
    { 864, -48, -336},
    { 1160, 24, -280},
    { 1240, 176, -352},
    { 1248, 232, -408},
    { 1400, 384, -272},
    { 1520, 576, -272},
    { 1608, 560, -240},
    { 1520, 656, -272},
    { 1152, 904, -336},
    { 816, 1064, -448},
    { 968, 1040, -472},
    { 1200, 888, -440},
    { 960, 656, -336},
    { 1040, 552, -296},
    { 1248, 544, -240},
    { 1432, 328, -160},
    { 1344, 312, -128},
    { 1368, -136, -40},
    { 1272, 240, -112},
    { 1240, 176, -8},
    { 1264, 176, -96},
    { 1168, 160, -104},
    { 1064, 176, -192},
    // 43 seconds
    { 1000, 96, -296},
    { 600, -208, -56},
    { 360, -64, -360},
    { 624, -168, -456},
    { 1040, 16, -352},
    { 1096, 128, -424},
    { 1064, 184, -488},
    { 1280, 320, -376},
    { 1624, 432, -448},
    { 1560, 680, -536},
    { 1248, 584, -472},
    { 1080, 792, -664},
    { 952, 952, -632},
    { 1208, 1304, -608},
    { 1048, 528, -368},
    { 1048, 536, -376},
    { 1336, 536, -304},
    { 1536, 280, -192},
    { 1240, 152, -136},
    { 1192, 128, -168},
    { 1264, 184, -184},
    { 1304, 128, -136},
    { 1264, 152, -136},
    { 1232, 120, -160},
    { 1016, 128, -264},
    // 44 seconds
    { 768, -248, -48},
    { 456, -80, -144},
    { 544, -32, -464},
    { 808, 24, -376},
    { 1288, 144, -344},
    { 1176, 80, -392},
    { 1088, 216, -400},
    { 1264, 320, -296},
    { 1504, 512, -384},
    { 1480, 664, -368},
    { 1104, 832, -488},
    { 816, 1096, -656},
    { 880, 1024, -520},
    { 1264, 1000, -496},
    { 1072, 552, -272},
    { 1120, 552, -272},
    { 1392, 544, -176},
    { 1528, 360, -40},
    { 1296, 240, 40},
    { 1280, -32, -288},
    { 928, 24, -16},
    { 1192, 256, -184},
    { 1176, 128, -144},
    { 1056, 112, -168},
    { 952, 96, -264},
    // 45 seconds
    { 560, -144, -264},
    { 640, -72, -144},
    { 688, -72, -424},
    { 904, 24, -504},
    { 1384, 200, -528},
    { 1168, 72, -392},
    { 1064, 136, -352},
    { 1176, 312, -392},
    { 1264, 520, -472},
    { 1112, 624, -520},
    { 952, 656, -680},
    { 920, 736, -656},
    { 1048, 656, -488},
    { 1384, 808, -488},
    { 1120, 456, -336},
    { 1000, 584, -368},
    { 1488, -8, -128},
    { 1272, -208, -16},
    { 968, 192, -120},
    { 880, 152, -184},
    { 1016, 96, -176},
    { 1104, 160, -144},
    { 1208, 160, -168},
    { 1128, 96, -168},
    { 1160, 168, -216},
    // 46 seconds
    { 832, -232, -56},
    { 712, -56, -144},
    { 704, -8, -448},
    { 1104, -32, -304},
    { 1288, 184, -376},
    { 1080, 40, -344},
    { 960, 240, -376},
    { 1104, 336, -312},
    { 1288, 416, -368},
    { 1344, 504, -416},
    { 1032, 640, -512},
    { 840, 792, -616},
    { 992, 776, -616},
    { 1344, 856, -560},
    { 1144, 544, -384},
    { 1144, 456, -304},
    { 1192, 416, -272},
    { 1416, 336, -256},
    { 1064, 88, -72},
    { 1024, 96, -168},
    { 1120, 144, -152},
    { 1168, 136, -168},
    { 1184, 120, -136},
    { 1048, 136, -176},
    { 1000, 128, -240},
    // 47 seconds
    { 744, -120, -152},
    { 648, -88, -120},
    { 744, 0, -488},
    { 888, -16, -456},
    { 1344, 136, -480},
    { 1112, 96, -384},
    { 1040, 216, -344},
    { 1176, 264, -248},
    { 1336, 504, -320},
    { 1304, 688, -368},
    { 1064, 656, -408},
    { 864, 744, -496},
    { 1016, 696, -416},
    { 1336, 864, -392},
    { 936, 544, -304},
    { 1112, 536, -352},
    { 1336, 472, -280},
    { 1280, 208, -184},
    { 1040, 264, 56},
    { 936, 272, -224},
    { 1064, -24, -48},
    { 1240, 232, -128},
    { 1184, 104, -96},
    { 1096, 144, -144},
    { 1072, 112, -216},
    // 48 seconds
    { 832, -48, -144},
    { 840, -24, -40},
    { 672, 16, -376},
    { 952, 32, -432},
    { 1320, 168, -368},
    { 1048, 96, -304},
    { 840, 112, -352},
    { 800, 256, -296},
    { 984, 328, -336},
    { 1184, 392, -376},
    { 1184, 584, -440},
    { 968, 656, -528},
    { 1032, 776, -560},
    { 1144, 776, -504},
    { 1448, 848, -488},
    { 1024, 560, -352},
    { 1072, 584, -440},
    { 1248, 504, -264},
    { 1352, 296, -104},
    { 1200, 264, -72},
    { 1128, 192, -112},
    { 1056, 208, -112},
    { 984, 200, -56},
    { 1032, 176, -120},
    { 1032, 160, -160},
    // 49 seconds
    { 896, 88, -144},
    { 544, -208, -192},
    { 824, -112, -248},
    { 856, -32, -352},
    { 1032, -24, -416},
    { 1392, 184, -488},
    { 1464, 120, -336},
    { 1312, 264, -376},
    { 1096, 392, -384},
    { 1080, 384, -304},
    { 1128, 488, -344},
    { 1152, 568, -472},
    { 976, 752, -600},
    { 872, 824, -760},
    { 1000, 648, -624},
    { 1288, 784, -600},
    { 1120, 472, -472},
    { 1264, 456, -360},
    { 1584, 584, -256},
    { 1600, 200, 72},
    { 1336, 152, 192},
    { 1248, 128, -120},
    { 1120, 280, -192},
    { 1008, 456, -192},
    { 1000, 96, -336},
    // 50 seconds
    { 912, 16, -304},
    { 680, -96, -224},
    { 400, -88, -312},
    { 544, 24, -320},
    { 624, -32, -392},
    { 944, 112, -424},
    { 1464, 224, -360},
    { 1392, 248, -288},
    { 992, 400, -248},
    { 856, 424, -224},
    { 976, 400, -192},
    { 1376, 432, -224},
    { 1360, 488, -272},
    { 1232, 536, -408},
    { 1216, 760, -520},
    { 1304, 944, -576},
    { 1064, 744, -480},
    { 1040, 696, -400},
    { 1144, 584, -384},
    { 1136, 360, -216},
    { 1008, 224, -216},
    { 1032, 320, -96},
    { 1168, -80, -120},
    { 1192, 296, -168},
    { 1192, 352, -168},
    // 51 seconds
    { 1288, 200, -152},
    { 1104, 216, -144},
    { 920, 184, -304},
    { 920, 136, -168},
    { 408, -136, -288},
    { 576, 0, -448},
    { 928, 0, -400},
    { 928, 16, -352},
    { 896, 104, -408},
    { 968, 200, -312},
    { 1200, 336, -352},
    { 1408, 496, -448},
    { 1352, 688, -512},
    { 976, 744, -608},
    { 872, 976, -608},
    { 1184, 1120, -480},
    { 1360, 696, -328},
    { 1288, 648, -296},
    { 1352, 528, -208},
    { 1408, 392, -224},
    { 1208, 112, -120},
    { 1160, 272, -216},
    { 1176, 256, -152},
    { 1216, 360, -160},
    { 1184, 272, -168},
    // 52 seconds
    { 992, 232, -128},
    { 872, 184, -152},
    { 584, 24, -232},
    { 488, -128, -160},
    { 408, -72, -328},
    { 712, -48, -496},
    { 1224, 72, -416},
    { 1576, 152, -456},
    { 1464, 192, -424},
    { 1512, 416, -408},
    { 1616, 664, -384},
    { 1648, 568, -336},
    { 1248, 752, -432},
    { 552, 1136, -704},
    { 616, 976, -680},
    { 920, 832, -600},
    { 1296, 840, -536},
    { 1200, 424, -264},
    { 1344, 480, -360},
    { 1544, 392, -192},
    { 1736, 192, -64},
    { 1344, 144, -40},
    { 1144, 200, -152},
    { 1184, 96, -120},
    { 1160, 200, -144},
    // 53 seconds
    { 1152, 80, -176},
    { 1096, 128, -216},
    { 976, 16, -256},
    { 456, -336, -96},
    { 592, -184, -264},
    { 696, -48, -552},
    { 1024, 24, -400},
    { 1400, 112, -384},
    { 1440, 128, -312},
    { 1368, 432, -432},
    { 1424, 424, -368},
    { 1568, 560, -352},
    { 1536, 608, -344},
    { 1136, 672, -432},
    { 672, 872, -584},
    { 720, 1000, -624},
    { 1072, 1008, -544},
    { 1184, 632, -408},
    { 1016, 648, -416},
    { 1224, 504, -288},
    { 1552, 456, -256},
    { 904, 720, -864},
    { 1264, 64, -120},
    { 1152, 224, -56},
    { 1160, 136, -136},
    // 54 seconds
    { 1128, 256, -160},
    { 1096, 176, -136},
    { 1104, 328, -200},
    { 928, 472, -288},
    { 944, 744, -408},
    { 336, 592, -560},
    { 120, 968, -472},
    { 272, 1016, -272},
    { 296, 1008, -264},
    { 112, 816, -432},
    { -128, 656, -216},
    { -200, 680, -16},
    { -272, 656, 32},
    { -320, 792, 200},
    { -264, 888, 360},
    { -224, 920, 384},
    { -224, 832, 352},
    { -216, 720, 416},
    { -216, 680, 336},
    { -232, 840, 384},
    { -272, 944, 376},
    { -272, 1048, 264},
    { -216, 1008, 456},
    { 48, 1176, 528},
    { 80, 952, 536},
    // 55 seconds
    { 96, 728, 432},
    { -72, 1064, 208},
    { -136, 752, 256},
    { -168, 816, 312},
    { -88, 832, 184},
    { -64, 984, 216},
    { -72, 976, 136},
    { -112, 1016, 56},
    { -192, 960, 24},
    { -232, 976, -32},
    { -240, 1016, -48},
    { -264, 1224, -168},
    { -272, 840, -232},
    { -264, 968, -304},
    { -256, 816, -328},
    { -232, 688, -536},
    { -232, 528, -544},
    { -200, 464, -664},
    { -248, 344, -800},
    { -240, 352, -816},
    { -312, 632, -904},
    { -264, 280, -792},
    { -288, 360, -848},
    { -264, 400, -936},
    { -264, 240, -944},
    // 56 seconds
    { -272, 344, -928},
    { -352, 376, -872},
    { -336, 400, -800},
    { -328, 384, -824},
    { -312, 320, -872},
    { -320, 336, -920},
    { -240, 288, -928},
    { -312, 392, -992},
    { -304, 280, -920},
    { -296, 320, -944},
    { -312, 360, -888},
    { -288, 256, -864},
    { -264, 352, -904},
    { -272, 496, -848},
    { -280, 232, -784},
    { -240, 280, -896},
    { -184, 264, -808},
    { -96, 200, -648},
    { -40, 528, -512},
    { -160, 776, -288},
    { -288, 1096, -200},
    { -392, 1248, -144},
    { -400, 1016, -16},
    { -424, 904, 56},
    { -432, 936, 32},
    // 57 seconds
    { -440, 1024, 96},
    { -424, 976, 96},
    { -400, 928, 64},
    { -368, 936, 64},
    { -360, 960, 80},
    { -328, 888, 48},
    { -304, 848, 8},
    { -312, 832, 8},
    { -304, 872, 0},
    { -296, 896, 8},
    { -296, 872, -8},
    { -288, 840, -8},
    { -288, 864, -16},
    { -280, 856, -8},
    { -288, 888, 16},
    { -304, 920, 56},
    { -288, 904, 56},
    { -288, 960, 112},
    { -280, 968, 128},
    { -256, 920, 112},
    { -256, 920, 144},
    { -256, 888, 144},
    { -256, 824, 120},
    { -248, 848, 160},
    { -264, 872, 192},
    // 58 seconds
    { -280, 768, 216},
    { -320, 688, 240},
    { -296, 792, 288},
    { -224, 912, 360},
    { -88, 976, 264},
    { -96, 1056, 264},
    { -40, 1136, 216},
    { -32, 1096, 112},
    { -56, 1032, 48},
    { -72, 1024, 24},
    { -96, 960, 0},
    { -120, 872, 24},
    { -192, 856, 96},
    { -232, 832, 104},
    { -248, 864, 136},
    { -288, 864, 176},
    { -296, 848, 192},
    { -296, 880, 184},
    { -272, 904, 160},
    { -240, 904, 104},
    { -224, 904, 64},
    { -232, 872, 72},
    { -240, 864, 72},
    { -256, 776, 96},
    { -256, 848, 160},
    // 59 seconds
    { -264, 912, 184},
    { -248, 936, 144},
    { -216, 904, 160},
    { -272, 1136, 136},
    { -280, 896, 224},
    { -304, 936, 104},
    { -336, 936, 104},
    { -408, 928, 184},
    { -416, 944, 192},
    { -392, 824, 96},
    { -320, 976, -104},
    { -232, 808, 32},
    { -304, 808, 24},
    { -416, 680, 240},
    { -424, 792, 200},
    { -456, 800, 216},
    { -472, 808, 184},
    { -480, 816, 248},
    { -504, 792, 248},
    { -560, 768, 272},
    { -584, 768, 296},
    { -576, 800, 240},
    { -552, 808, 232},
    { -536, 736, 232},
    { -544, 744, 224},
    // 60 seconds
    // elapsed: 1 minutes
    { -520, 704, 136},
    { -504, 760, 136},
    { -496, 768, 136},
    { -544, 744, 176},
    { -584, 736, 168},
    { -616, 776, 160},
    { -608, 792, 136},
    { -584, 768, -40},
    { -664, 784, 360},
    { -744, 752, 240},
    { -688, 664, 152},
    { -656, 744, 144},
    { -648, 776, 232},
    { -648, 720, 208},
    { -608, 640, 224},
    { -640, 672, 248},
    { -640, 656, 248},
    { -640, 616, 192},
    { -672, 656, 224},
    { -680, 680, 232},
    { -672, 664, 224},
    { -656, 672, 176},
    { -696, 704, 208},
    { -672, 688, 200},
    { -704, 672, 184},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:03:07 local
AccelRawData *activity_sample_walk_100_pbl_25663_7(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25663_7
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -904, -1760, -984},
    { -32, -504, -1016},
    { -120, -288, -976},
    { -192, -304, -976},
    { -144, -344, -944},
    { -72, -336, -968},
    { -200, -360, -952},
    { -120, -304, -960},
    { -136, -288, -984},
    { -136, -312, -1016},
    { -136, -280, -976},
    { -248, -376, -968},
    { -304, -496, -872},
    { -264, -472, -880},
    { -232, -408, -952},
    { -304, -560, -920},
    { -336, -536, -928},
    { -400, -256, -1008},
    { -200, -760, -832},
    { -64, -288, -984},
    { -264, -392, -944},
    { -184, -360, -952},
    { -232, -368, -936},
    { -272, -536, -888},
    { -312, -408, -928},
    // 1 seconds
    { -328, -416, -984},
    { -184, -304, -976},
    { -160, -376, -1144},
    { -264, -328, -1072},
    { -232, -408, -1000},
    { -240, -440, -1000},
    { -112, -416, -1128},
    { 128, -360, -1104},
    { 120, -344, -944},
    { 200, -344, -848},
    { 136, -376, -928},
    { 64, -400, -952},
    { -56, -360, -864},
    { -56, -384, -848},
    { -192, -256, -928},
    { -48, -288, -984},
    { -80, -320, -992},
    { -48, -360, -1024},
    { -56, -352, -1056},
    { -72, -376, -1040},
    { -48, -352, -1120},
    { 48, -232, -1224},
    { -104, -288, -992},
    { -168, -240, -976},
    { -152, -56, -1072},
    // 2 seconds
    { -80, -120, -1048},
    { -96, -96, -976},
    { -104, -144, -944},
    { -40, -168, -920},
    { -8, -152, -800},
    { 24, -136, -736},
    { 56, -48, -696},
    { 120, 24, -688},
    { 312, 232, -832},
    { 440, 280, -880},
    { 256, 784, -1000},
    { 256, 1272, -928},
    { 128, 1328, -624},
    { 0, 1312, -336},
    { 64, 1120, -304},
    { 208, 896, -248},
    { 192, 704, -272},
    { 56, 664, -256},
    { -16, 616, -288},
    { -72, 648, -336},
    { -160, 712, -384},
    { -192, 888, -456},
    { -248, 1048, -496},
    { -216, 1192, -560},
    { -120, 1616, -664},
    // 3 seconds
    { 304, 1632, -664},
    { 136, 960, -688},
    { 0, 520, -520},
    { 152, 784, -656},
    { 24, 608, -464},
    { -48, 552, -424},
    { -80, 624, -416},
    { -120, 616, -344},
    { -48, 656, -296},
    { 32, 688, -336},
    { 160, 776, -416},
    { 152, 656, -448},
    { 72, 872, -488},
    { 64, 840, -592},
    { -24, 944, -752},
    { 96, 848, -816},
    { -104, 488, -600},
    { -184, 544, -552},
    { -320, 720, -376},
    { -368, 840, -456},
    { -416, 952, -512},
    { -416, 1032, -512},
    { -424, 1160, -528},
    { -424, 2072, -816},
    { 488, 1712, -888},
    // 4 seconds
    { 72, 1408, -632},
    { -112, 1040, -408},
    { 72, 904, -464},
    { 96, 552, -344},
    { -8, 288, -248},
    { -112, 312, -328},
    { -96, 272, -368},
    { -88, 184, -320},
    { 128, 232, -400},
    { 488, 208, -448},
    { 888, 224, -424},
    { 1336, 272, -280},
    { 2048, 296, -112},
    { 3184, 656, -144},
    { 2400, 688, -184},
    { 1560, 592, -296},
    { 1024, 528, -248},
    { 928, 464, -96},
    { 888, 496, -48},
    { 976, 488, 24},
    { 1296, 680, 0},
    { 1048, 888, 72},
    { 808, 1128, -80},
    { 912, 992, -128},
    { 992, 800, -264},
    // 5 seconds
    { 768, 816, -264},
    { 1176, 736, -152},
    { 1864, 520, -168},
    { 2000, 384, -96},
    { 1704, 312, -88},
    { 1544, 248, -120},
    { 1368, 224, -112},
    { 1320, 256, -80},
    { 1376, 184, -168},
    { 1232, 168, -176},
    { 1128, 48, -248},
    { 312, -1016, 8},
    { 688, -224, -176},
    { 912, -40, -464},
    { 1392, -40, -64},
    { 1672, 480, -416},
    { 1432, 304, -304},
    { 1448, 416, -288},
    { 1432, 488, -176},
    { 1664, 616, -160},
    { 1560, 800, -168},
    { 1176, 1056, -160},
    { 800, 1408, -232},
    { 872, 1000, -240},
    { 1016, 1064, -160},
    // 6 seconds
    { 880, 912, -40},
    { 1200, 696, -48},
    { 1656, 608, -72},
    { 1520, 376, -72},
    { 1320, 344, -88},
    { 1392, 304, -64},
    { 1472, 272, -96},
    { 1432, 208, -160},
    { 1344, 168, -152},
    { 1184, 104, -232},
    { 864, -272, 32},
    { 272, -416, 80},
    { 872, -128, -240},
    { 928, -48, -312},
    { 1272, 8, -208},
    { 1376, 376, -440},
    { 1272, 80, -280},
    { 1272, 432, -264},
    { 1456, 528, -216},
    { 1528, 792, -256},
    { 1560, 704, -216},
    { 1176, 856, -288},
    { 888, 1048, -304},
    { 808, 976, -256},
    { 880, 1080, -288},
    // 7 seconds
    { 1024, 784, -224},
    { 1216, 712, -168},
    { 1504, 616, -168},
    { 1288, 336, -144},
    { 1184, 296, -136},
    { 1328, 320, -136},
    { 1368, 160, -208},
    { 1424, 360, -144},
    { 1408, 152, -152},
    { 1312, 200, -184},
    { 1032, -136, -112},
    { 576, -376, 264},
    { 976, -144, -448},
    { 1008, -264, -264},
    { 1352, 80, -232},
    { 1024, 136, -376},
    { 944, 144, -360},
    { 1144, 320, -264},
    { 1496, 608, -400},
    { 1712, 792, -536},
    { 1296, 760, -504},
    { 1040, 1224, -608},
    { 856, 1008, -592},
    { 1072, 984, -480},
    { 1040, 848, -360},
    // 8 seconds
    { 1368, 736, -232},
    { 1768, 528, -208},
    { 1448, 344, -144},
    { 1224, 256, -128},
    { 1248, 256, -176},
    { 1416, 248, -240},
    { 1568, 176, -136},
    { 1344, 128, -184},
    { 1200, 24, -192},
    { 544, -760, -176},
    { 600, -416, 152},
    { 944, 0, -520},
    { 992, -24, -208},
    { 1608, 64, -144},
    { 1480, 432, -440},
    { 1336, 296, -280},
    { 1456, 472, -352},
    { 1352, 528, -240},
    { 1504, 688, -400},
    { 1224, 920, -576},
    { 880, 1016, -776},
    { 832, 800, -696},
    { 968, 960, -632},
    { 1152, 744, -376},
    { 1800, 688, -384},
    // 9 seconds
    { 1864, 464, -264},
    { 1736, 288, -168},
    { 1616, 208, -56},
    { 1768, 152, 40},
    { 1608, 160, 16},
    { 1184, 144, -8},
    { 944, 24, -56},
    { 760, -64, -72},
    { 352, -160, -152},
    { 208, -152, -168},
    { 376, 56, -392},
    { 624, 8, -544},
    { 1376, 128, -400},
    { 2152, 328, -504},
    { 1744, 416, -352},
    { 1264, 552, -296},
    { 1128, 504, -232},
    { 1408, 432, -432},
    { 992, 776, -288},
    { 760, 680, -424},
    { 848, 816, -504},
    { 1048, 696, -488},
    { 1056, 720, -456},
    { 1560, 712, -440},
    { 2080, 440, -360},
    // 10 seconds
    { 1640, 296, -392},
    { 1320, 184, -256},
    { 1112, 136, -216},
    { 808, 128, -136},
    { 592, 104, -168},
    { 512, 64, -136},
    { 560, 192, -152},
    { 592, 136, -144},
    { 488, 104, -184},
    { 592, 72, -288},
    { 704, 184, -168},
    { 1440, 304, -528},
    { 2352, 288, -600},
    { 2088, 232, -432},
    { 1184, 408, -448},
    { 760, 288, -344},
    { 872, 448, -440},
    { 904, 480, -240},
    { 1072, 680, -368},
    { 1208, 752, -616},
    { 1104, 720, -616},
    { 1240, 968, -568},
    { 1512, 728, -296},
    { 1832, 600, -232},
    { 1704, 480, -176},
    // 11 seconds
    { 1296, 288, -96},
    { 1080, 160, -80},
    { 1112, 328, -96},
    { 1312, 248, -80},
    { 1360, 304, -88},
    { 1248, 88, -8},
    { 1072, 216, -64},
    { 1056, 176, -104},
    { 664, -200, 0},
    { 232, -200, 264},
    { 1016, 128, -464},
    { 1128, 104, -416},
    { 1464, 400, -424},
    { 1440, 344, -400},
    { 1472, 528, -256},
    { 1400, 640, -296},
    { 1464, 680, -160},
    { 1328, 824, -208},
    { 1080, 848, -240},
    { 992, 768, -336},
    { 952, 960, -448},
    { 936, 1040, -336},
    { 1320, 848, -312},
    { 1416, 696, -264},
    { 1288, 496, -184},
    // 12 seconds
    { 1200, 384, -80},
    { 1160, 232, -48},
    { 1224, 232, -48},
    { 1400, 312, -24},
    { 1640, 224, -8},
    { 1432, 176, -56},
    { 1272, 112, -136},
    { 816, -432, -96},
    { 384, -352, 32},
    { 680, -240, -368},
    { 1128, -192, -392},
    { 1232, 72, -168},
    { 1232, 272, -360},
    { 1224, 216, -400},
    { 1280, 352, -336},
    { 1424, 432, -336},
    { 1488, 648, -456},
    { 1360, 848, -568},
    { 944, 1064, -928},
    { 768, 1208, -888},
    { 1104, 1056, -696},
    { 1400, 832, -392},
    { 1456, 632, -312},
    { 1584, 640, -240},
    { 1632, 464, -120},
    // 13 seconds
    { 1280, 200, -88},
    { 1016, 144, -120},
    { 1152, 280, -72},
    { 1280, 224, -40},
    { 1296, 232, -48},
    { 1096, 136, -88},
    { 872, 128, -160},
    { 712, -104, -104},
    { 544, -224, 8},
    { 584, -8, -392},
    { 984, -8, -432},
    { 1328, 144, -256},
    { 1432, 192, -400},
    { 1376, 216, -368},
    { 1504, 416, -352},
    { 1680, 600, -392},
    { 1592, 712, -328},
    { 1344, 640, -544},
    { 864, 816, -640},
    { 912, 1008, -560},
    { 1168, 1096, -472},
    { 1096, 688, -368},
    { 1136, 688, -344},
    { 1344, 616, -200},
    { 1512, 568, -200},
    // 14 seconds
    { 1320, 360, -160},
    { 1336, 208, 0},
    { 1352, 360, -280},
    { 1320, 88, -32},
    { 1240, 264, 16},
    { 1160, 88, -72},
    { 1048, 64, -168},
    { 968, -56, -96},
    { 552, -224, 96},
    { 736, 208, -496},
    { 864, -200, -384},
    { 1224, 80, -288},
    { 1080, -16, -280},
    { 1080, 256, -368},
    { 1216, 488, -296},
    { 1496, 432, -408},
    { 1688, 648, -576},
    { 1368, 800, -584},
    { 1168, 888, -616},
    { 952, 1072, -672},
    { 1096, 992, -520},
    { 920, 640, -416},
    { 944, 648, -432},
    { 1120, 560, -352},
    { 1200, 352, -280},
    // 15 seconds
    { 1192, 216, -240},
    { 1336, 280, -160},
    { 1432, 168, -168},
    { 1432, 112, -304},
    { 1304, 112, -296},
    { 1136, -104, -56},
    { 672, -336, -56},
    { 840, -160, -296},
    { 720, -160, -280},
    { 944, -136, -288},
    { 1296, 192, -440},
    { 1328, 88, -360},
    { 1272, 216, -352},
    { 1248, 424, -352},
    { 1280, 392, -384},
    { 1408, 552, -424},
    { 1288, 648, -504},
    { 928, 784, -640},
    { 968, 880, -584},
    { 1184, 1080, -384},
    { 1024, 784, -360},
    { 1064, 768, -336},
    { 1312, 576, -232},
    { 1488, 488, -208},
    { 1392, 248, -144},
    // 16 seconds
    { 1448, 240, -128},
    { 1376, 144, -128},
    { 1360, 256, -112},
    { 1312, 136, -128},
    { 1240, 144, -184},
    { 1016, -48, -56},
    { 688, -400, -40},
    { 736, -272, -48},
    { 760, -16, -456},
    { 1016, -56, -256},
    { 1520, 200, -296},
    { 1440, 152, -360},
    { 1424, 232, -344},
    { 1608, 448, -328},
    { 1584, 696, -440},
    { 1424, 736, -520},
    { 1104, 856, -592},
    { 848, 1000, -496},
    { 904, 928, -448},
    { 1128, 1024, -384},
    { 1136, 728, -224},
    { 1384, 720, -200},
    { 1616, 560, -144},
    { 1400, 416, -168},
    { 1312, 264, -160},
    // 17 seconds
    { 1288, 208, -96},
    { 1352, 232, -112},
    { 1416, 160, -160},
    { 1352, 136, -112},
    { 1008, 56, -104},
    { 920, 64, -168},
    { 664, -304, -48},
    { 584, -72, -312},
    { 864, 16, -512},
    { 976, -24, -200},
    { 1208, 120, -248},
    { 1152, 176, -368},
    { 1256, 264, -184},
    { 1544, 408, -216},
    { 1752, 752, -296},
    { 1608, 752, -176},
    { 1320, 720, -448},
    { 936, 1024, -424},
    { 952, 912, -368},
    { 1040, 1024, -352},
    { 856, 664, -288},
    { 1096, 736, -200},
    { 1416, 632, -160},
    { 1400, 368, -152},
    { 1256, 144, -24},
    // 18 seconds
    { 1312, 280, -96},
    { 1400, 200, -104},
    { 1288, 272, -56},
    { 1328, 160, -32},
    { 1288, 176, 0},
    { 1056, 160, -112},
    { 1224, 24, -112},
    { 512, -440, 0},
    { 816, 16, -376},
    { 872, 224, -408},
    { 1136, 120, -328},
    { 1024, 232, -344},
    { 1048, 352, -352},
    { 1232, 416, -176},
    { 1512, 744, -184},
    { 1488, 920, -8},
    { 1264, 616, -256},
    { 912, 1008, -80},
    { 976, 1136, -8},
    { 1112, 1008, -48},
    { 1008, 784, -72},
    { 920, 720, -16},
    { 1096, 664, 24},
    { 1496, 576, -8},
    { 1336, 440, 168},
    // 19 seconds
    { 1000, 400, 744},
    { 1360, 480, -288},
    { 1400, 104, -64},
    { 1264, 216, -104},
    { 1144, 88, -48},
    { 984, 120, -176},
    { 712, -120, -104},
    { 704, 8, -96},
    { 448, -104, -432},
    { 784, 96, -328},
    { 1232, 152, -384},
    { 1336, 128, -352},
    { 1264, 240, -384},
    { 1296, 416, -344},
    { 1352, 504, -288},
    { 1392, 640, -248},
    { 1240, 704, -256},
    { 824, 1048, -248},
    { 856, 1232, -160},
    { 1064, 904, -160},
    { 1104, 944, -144},
    { 912, 672, -80},
    { 1072, 592, -80},
    { 1440, 544, -96},
    { 1392, 344, -40},
    // 20 seconds
    { 1200, 296, -96},
    { 1216, 200, -136},
    { 1200, 288, -128},
    { 1176, 128, -136},
    { 992, 208, -184},
    { 1032, 136, -248},
    { 912, 88, -280},
    { 760, -208, -56},
    { 344, -200, -264},
    { 672, 48, -464},
    { 1056, 96, -336},
    { 1352, 224, -392},
    { 1184, 224, -384},
    { 1184, 432, -376},
    { 1280, 352, -232},
    { 1472, 592, -232},
    { 1256, 728, -232},
    { 1064, 816, -288},
    { 1008, 928, -192},
    { 1264, 1024, -200},
    { 1080, 512, -184},
    { 864, 584, -192},
    { 848, 624, -120},
    { 1136, 584, -120},
    { 1128, 400, -120},
    // 21 seconds
    { 1144, 280, -128},
    { 1224, 344, -288},
    { 1248, 544, -136},
    { 1104, 488, -72},
    { 1120, 392, -144},
    { 984, 192, -56},
    { 760, -72, -72},
    { 824, 16, -40},
    { 520, 40, -368},
    { 872, 72, -400},
    { 1144, 184, -296},
    { 1056, 48, -288},
    { 960, 160, -320},
    { 1088, 336, -240},
    { 1344, 432, -248},
    { 1504, 640, -288},
    { 1280, 640, -256},
    { 1088, 720, -392},
    { 992, 984, -360},
    { 1280, 1056, -296},
    { 1000, 584, -256},
    { 904, 688, -288},
    { 1096, 648, -184},
    { 1128, 424, -128},
    { 1024, 296, -128},
    // 22 seconds
    { 1088, 288, -128},
    { 1256, 248, -144},
    { 1368, 336, -64},
    { 1312, 200, -112},
    { 1184, 248, -192},
    { 1032, 184, -208},
    { 624, -176, -120},
    { 544, -88, -48},
    { 584, -16, -352},
    { 744, -32, -320},
    { 1232, 240, -352},
    { 1112, 176, -384},
    { 1088, 208, -320},
    { 1320, 416, -248},
    { 1496, 648, -336},
    { 1352, 696, -232},
    { 1128, 656, -400},
    { 840, 920, -392},
    { 920, 920, -272},
    { 1352, 1024, -264},
    { 1168, 576, -216},
    { 1024, 616, -272},
    { 1104, 624, -168},
    { 1200, 504, -88},
    { 1040, 200, -64},
    // 23 seconds
    { 1032, 208, -144},
    { 1120, 208, -112},
    { 1248, 280, -112},
    { 1304, 120, -24},
    { 1208, 184, -88},
    { 1096, 144, -176},
    { 896, -40, -120},
    { 640, -88, 40},
    { 552, 32, -360},
    { 944, 64, -408},
    { 1296, 176, -360},
    { 1064, 56, -408},
    { 1016, 192, -384},
    { 1168, 288, -264},
    { 1528, 456, -336},
    { 1536, 672, -328},
    { 1200, 784, -336},
    { 928, 912, -424},
    { 936, 928, -336},
    { 1224, 920, -352},
    { 920, 600, -256},
    { 984, 616, -288},
    { 1208, 640, -240},
    { 1336, 400, -120},
    { 1168, 328, -48},
    // 24 seconds
    { 1160, 112, -192},
    { 1208, 296, -152},
    { 1288, 216, -40},
    { 1232, 120, -64},
    { 1096, 176, -80},
    { 1040, 192, -120},
    { 832, 24, -80},
    { 584, -128, 48},
    { 520, 40, -264},
    { 800, 24, -368},
    { 1128, 160, -240},
    { 1152, 192, -264},
    { 1136, 168, -264},
    { 1224, 328, -232},
    { 1464, 448, -304},
    { 1528, 664, -320},
    { 1176, 616, -400},
    { 880, 784, -544},
    { 888, 880, -432},
    { 1128, 816, -296},
    { 1176, 880, -272},
    { 1184, 688, -168},
    { 1136, 600, -160},
    { 1264, 544, -176},
    { 1144, 352, -104},
    // 25 seconds
    { 1032, 232, -96},
    { 1104, 200, -136},
    { 1200, 200, -72},
    { 1144, 224, -72},
    { 1176, 72, -64},
    { 1240, 136, -24},
    { 912, 176, -128},
    { 1104, 192, -176},
    { 504, 128, -296},
    { 408, 128, -440},
    { 824, 80, -448},
    { 1024, -40, -424},
    { 1008, 32, -384},
    { 1088, 304, -272},
    { 1304, 432, -336},
    { 1520, 800, -328},
    { 1200, 920, -152},
    { 1064, 472, -264},
    { 912, 960, -64},
    { 1056, 768, 128},
    { 1272, 848, 80},
    { 912, 544, 0},
    { 928, 528, -48},
    { 1048, 624, -32},
    { 1208, 528, -88},
    // 26 seconds
    { 1120, 304, 16},
    { 1064, 48, -88},
    { 1088, 176, -104},
    { 1080, 224, -112},
    { 952, 176, -56},
    { 1064, 152, -128},
    { 1144, 152, -176},
    { 920, 224, -256},
    { 1008, 72, -176},
    { 472, -40, -272},
    { 616, 128, -416},
    { 1048, 136, -424},
    { 1040, 144, -376},
    { 888, 200, -328},
    { 968, 264, -264},
    { 1240, 360, -256},
    { 1400, 504, -216},
    { 1192, 664, -200},
    { 1016, 656, -216},
    { 1200, 840, -208},
    { 1216, 896, -144},
    { 1072, 864, -200},
    { 768, 640, -192},
    { 824, 672, -184},
    { 1272, 592, -176},
    // 27 seconds
    { 1256, 560, -312},
    { 1112, 152, -200},
    { 1120, 176, -112},
    { 1144, 216, -104},
    { 1224, 256, -128},
    { 1272, 208, -112},
    { 1280, 136, -120},
    { 1008, 168, -272},
    { 984, -112, -24},
    { 440, -152, -184},
    { 680, 0, -448},
    { 976, -16, -296},
    { 1152, 208, -344},
    { 904, 144, -384},
    { 960, 248, -296},
    { 1232, 304, -192},
    { 1520, 512, -296},
    { 1376, 784, -240},
    { 1112, 760, -328},
    { 1120, 824, -328},
    { 1184, 1144, -192},
    { 1040, 776, -128},
    { 960, 704, -152},
    { 1128, 712, -152},
    { 1296, 544, -136},
    // 28 seconds
    { 1016, 328, -128},
    { 912, 208, -136},
    { 1024, -96, 56},
    { 1168, 424, -120},
    { 1304, 136, -104},
    { 1280, 160, -80},
    { 1168, 120, -152},
    { 952, 128, -264},
    { 864, -192, 80},
    { 576, 8, -248},
    { 760, 88, -520},
    { 1144, 96, -272},
    { 1152, 192, -304},
    { 984, 136, -328},
    { 1008, 312, -248},
    { 1232, 376, -192},
    { 1432, 600, -264},
    { 1288, 792, -176},
    { 1016, 672, -320},
    { 984, 744, -304},
    { 968, 872, -168},
    { 1160, 912, -128},
    { 1112, 648, -128},
    { 1168, 640, -144},
    { 1304, 576, -144},
    // 29 seconds
    { 1040, 240, -96},
    { 792, 488, -96},
    { 960, 368, -160},
    { 1184, 240, -56},
    { 1184, 256, -144},
    { 1264, 128, -32},
    { 1176, 120, -40},
    { 1016, 160, -232},
    { 1048, 0, -88},
    { 536, -120, -120},
    { 680, -8, -440},
    { 952, -24, -360},
    { 1192, 144, -328},
    { 904, 56, -408},
    { 888, 208, -336},
    { 1120, 248, -216},
    { 1480, 488, -320},
    { 1440, 736, -296},
    { 1056, 920, -328},
    { 1160, 720, -464},
    { 984, 936, -320},
    { 1192, 1008, -216},
    { 1040, 744, -176},
    { 1120, 688, -184},
    { 1312, 544, -168},
    // 30 seconds
    { 1048, 312, -136},
    { 936, 176, -152},
    { 992, 280, -120},
    { 1312, 248, -128},
    { 1392, 216, -72},
    { 1232, 136, -32},
    { 1128, 96, -120},
    { 1016, 136, -248},
    { 848, -208, -24},
    { 600, -32, -120},
    { 656, 8, -496},
    { 984, -48, -248},
    { 1256, 240, -304},
    { 1072, 80, -368},
    { 1080, 232, -328},
    { 1240, 376, -232},
    { 1504, 608, -320},
    { 1280, 752, -264},
    { 1048, 664, -384},
    { 944, 912, -368},
    { 976, 840, -240},
    { 1184, 952, -232},
    { 1048, 616, -184},
    { 1112, 640, -200},
    { 1312, 616, -152},
    // 31 seconds
    { 1224, 408, -120},
    { 1152, 176, 0},
    { 1000, -32, -56},
    { 1160, 304, -144},
    { 1144, 176, -32},
    { 1272, 248, -104},
    { 1200, 80, -24},
    { 1096, 160, -136},
    { 1048, 96, -216},
    { 808, 72, -48},
    { 568, 40, -376},
    { 616, 32, -416},
    { 848, 104, -392},
    { 912, 32, -376},
    { 920, 136, -376},
    { 1128, 264, -248},
    { 1576, 440, -304},
    { 1664, 936, -376},
    { 1000, 752, -232},
    { 1088, 496, -480},
    { 984, 880, -240},
    { 1256, 896, -48},
    { 1008, 600, -160},
    { 976, 584, -240},
    { 1072, 664, -200},
    // 32 seconds
    { 1160, 400, -88},
    { 1008, 312, -144},
    { 1048, 40, -120},
    { 1144, 344, -192},
    { 1192, 176, -32},
    { 1160, 296, -120},
    { 1200, 176, -88},
    { 1168, 176, -112},
    { 1072, 152, -160},
    { 880, -112, 32},
    { 448, 24, -480},
    { 736, -16, -376},
    { 1096, 104, -304},
    { 1080, 56, -360},
    { 984, 160, -384},
    { 1112, 312, -256},
    { 1400, 456, -288},
    { 1400, 720, -288},
    { 1080, 664, -208},
    { 1072, 624, -440},
    { 1160, 1128, -304},
    { 1128, 1112, -248},
    { 968, 888, -368},
    { 872, 704, -344},
    { 1056, 680, -248},
    // 33 seconds
    { 1376, 496, -160},
    { 1208, 496, 40},
    { 1192, 80, -112},
    { 1200, 184, -112},
    { 1056, 224, -104},
    { 1112, 176, -112},
    { 1120, 144, -88},
    { 1128, 144, -144},
    { 1152, 16, -104},
    { 664, -224, -88},
    { 696, 8, -528},
    { 960, -64, -400},
    { 1136, 40, -328},
    { 936, 56, -368},
    { 1000, 240, -336},
    { 1224, 360, -248},
    { 1544, 544, -272},
    { 1480, 832, -240},
    { 1144, 656, -240},
    { 1080, 720, -264},
    { 1032, 840, -152},
    { 1224, 984, -120},
    { 968, 776, -160},
    { 888, 808, -296},
    { 1144, 696, -264},
    // 34 seconds
    { 1288, 504, -152},
    { 1184, 448, -72},
    { 1280, 208, -88},
    { 1312, 296, -120},
    { 1256, 184, -16},
    { 1264, 216, 0},
    { 1184, 96, -40},
    { 1024, 152, -96},
    { 880, 56, -160},
    { 736, -200, 48},
    { 528, 24, -360},
    { 808, -32, -472},
    { 1200, 152, -320},
    { 1216, 96, -328},
    { 1120, 168, -344},
    { 1192, 376, -296},
    { 1352, 416, -272},
    { 1480, 696, -248},
    { 1304, 576, -184},
    { 1112, 656, -296},
    { 1016, 1024, -336},
    { 904, 1544, -288},
    { 1200, 912, -296},
    { 888, 888, -304},
    { 1120, 776, -136},
    // 35 seconds
    { 1560, 624, -48},
    { 1648, 384, 0},
    { 1424, 296, 0},
    { 1320, 256, -56},
    { 1304, 264, -32},
    { 1240, 168, -32},
    { 1104, 144, -64},
    { 1056, 160, -144},
    { 864, -136, -112},
    { 728, -16, -112},
    { 704, -72, -296},
    { 512, 80, -360},
    { 824, 152, -336},
    { 1200, 232, -344},
    { 1248, 168, -240},
    { 1256, 384, -208},
    { 1424, 592, -224},
    { 1528, 736, -176},
    { 1480, 536, -136},
    { 1216, 696, -136},
    { 1232, 952, -152},
    { 1104, 1248, 64},
    { 1176, 1256, -232},
    { 776, 944, -216},
    { 888, 848, -160},
    // 36 seconds
    { 1280, 736, -24},
    { 1440, 456, -24},
    { 1200, 272, -104},
    { 1280, 280, -104},
    { 1488, 208, -88},
    { 1584, 272, -48},
    { 1216, 104, -24},
    { 1152, 192, -184},
    { 784, -400, 0},
    { 1096, -24, 136},
    { 544, -64, -528},
    { 712, -88, -344},
    { 1128, 184, -280},
    { 1048, 80, -320},
    { 992, 232, -440},
    { 1232, 352, -432},
    { 1520, 400, -376},
    { 1496, 640, -344},
    { 1208, 552, -304},
    { 1120, 640, -408},
    { 1080, 872, -328},
    { 1264, 1064, -280},
    { 1096, 768, -240},
    { 1088, 624, -280},
    { 1120, 648, -288},
    // 37 seconds
    { 1032, 520, -232},
    { 904, 360, -32},
    { 920, 216, -216},
    { 1112, 88, -120},
    { 1392, 296, -136},
    { 1376, 152, -8},
    { 1216, 120, -64},
    { 1312, 176, -192},
    { 1088, -392, 0},
    { 928, -96, 96},
    { 624, -56, -520},
    { 1088, -152, -296},
    { 1272, 160, -216},
    { 944, 80, -368},
    { 976, 256, -432},
    { 1224, 344, -248},
    { 1520, 472, -448},
    { 1376, 616, -560},
    { 1208, 544, -656},
    { 1056, 664, -696},
    { 976, 776, -544},
    { 1240, 904, -512},
    { 1032, 528, -384},
    { 1096, 576, -440},
    { 1184, 384, -128},
    // 38 seconds
    { 1104, 248, -152},
    { 1056, 88, -80},
    { 1160, 184, -184},
    { 1256, 240, -96},
    { 1512, 344, -136},
    { 1496, 312, -96},
    { 1488, 256, -248},
    { 1024, 32, -328},
    { 592, -128, -104},
    { 320, -56, -464},
    { 472, -48, -576},
    { 776, -24, -352},
    { 912, -16, -360},
    { 984, 80, -424},
    { 1200, 184, -304},
    { 1496, 432, -264},
    { 1744, 856, -312},
    { 1512, 744, -160},
    { 1320, 744, -384},
    { 960, 744, -328},
    { 952, 968, -272},
    { 856, 752, -136},
    { 1088, 752, -200},
    { 1376, 544, -152},
    { 1112, 544, -264},
    // 39 seconds
    { 872, 248, -216},
    { 912, 104, -80},
    { 1088, 248, -112},
    { 1400, 184, -120},
    { 1368, 192, -56},
    { 1320, 160, -144},
    { 1104, 104, -168},
    { 752, -112, -112},
    { 648, 8, -144},
    { 768, 96, -528},
    { 1064, 0, -352},
    { 1048, 208, -384},
    { 856, 104, -336},
    { 896, 288, -272},
    { 1168, 448, -288},
    { 1416, 560, -320},
    { 1416, 776, -440},
    { 1240, 568, -496},
    { 1040, 736, -600},
    { 976, 920, -424},
    { 992, 832, -296},
    { 1080, 656, -360},
    { 1248, 568, -304},
    { 1312, 424, -224},
    { 1000, 200, -152},
    // 40 seconds
    { 936, 200, -160},
    { 1016, 112, -96},
    { 1288, 312, -200},
    { 1368, 112, -80},
    { 1264, 152, -136},
    { 1152, 72, -168},
    { 832, -168, -8},
    { 640, -8, -160},
    { 768, -8, -456},
    { 1136, 96, -304},
    { 1064, 56, -344},
    { 832, 32, -296},
    { 832, 192, -232},
    { 1096, 344, -272},
    { 1464, 464, -304},
    { 1528, 696, -408},
    { 1088, 736, -432},
    { 1096, 696, -672},
    { 856, 808, -528},
    { 1088, 968, -448},
    { 1136, 648, -344},
    { 1192, 592, -328},
    { 1288, 512, -256},
    { 1128, 416, -240},
    { 1008, 208, -104},
    // 41 seconds
    { 1128, 200, -120},
    { 1208, 240, -80},
    { 1280, 216, -64},
    { 1248, 128, -40},
    { 1160, 184, -88},
    { 904, 184, -240},
    { 640, -352, 112},
    { 504, -24, -96},
    { 864, 64, -448},
    { 1176, 224, -280},
    { 1248, 280, -336},
    { 1088, 240, -328},
    { 1056, 456, -296},
    { 1384, 544, -336},
    { 1584, 656, -344},
    { 1232, 752, -328},
    { 968, 744, -584},
    { 920, 944, -512},
    { 1128, 896, -424},
    { 1088, 720, -336},
    { 1104, 640, -320},
    { 1376, 504, -240},
    { 1544, 568, -192},
    { 1288, 24, 32},
    { 1080, 200, -144},
    // 42 seconds
    { 1112, 240, -120},
    { 1192, 168, -40},
    { 1264, 200, 0},
    { 1192, 144, -32},
    { 1096, 168, -96},
    { 968, 32, -176},
    { 624, -128, 96},
    { 600, -72, -360},
    { 944, 24, -288},
    { 1416, 344, -408},
    { 1248, 208, -328},
    { 1072, 336, -320},
    { 1112, 360, -248},
    { 1408, 464, -208},
    { 1520, 664, -232},
    { 1304, 768, -328},
    { 1008, 848, -536},
    { 944, 984, -440},
    { 1184, 1088, -368},
    { 1064, 728, -280},
    { 984, 712, -272},
    { 1160, 720, -184},
    { 1608, 600, 40},
    { 1472, 120, 32},
    { 1160, 280, 32},
    // 43 seconds
    { 1096, 312, 56},
    { 1192, 192, 8},
    { 1344, 264, -112},
    { 1336, 192, -208},
    { 1184, -56, -344},
    { 408, -440, -248},
    { 824, -208, -344},
    { 744, -208, -224},
    { 1232, 120, -416},
    { 1320, 240, -352},
    { 1256, 216, -232},
    { 1160, 280, -248},
    { 1160, 360, -136},
    { 1432, 472, -120},
    { 1600, 576, -160},
    { 1480, 864, -176},
    { 1184, 1032, -368},
    { 920, 1392, -432},
    { 1040, 1320, -352},
    { 768, 792, -200},
    { 1024, 776, -88},
    { 1480, 648, -64},
    { 1504, 368, -88},
    { 1288, -8, -8},
    { 1192, 272, -88},
    // 44 seconds
    { 1208, 200, -80},
    { 1280, 240, -88},
    { 1312, 144, -24},
    { 1216, 128, -64},
    { 1016, -112, -80},
    { 744, -104, -136},
    { 720, -224, -256},
    { 768, -16, -384},
    { 1104, 32, -320},
    { 1160, 160, -352},
    { 1104, 160, -288},
    { 1008, 336, -312},
    { 1224, 368, -240},
    { 1424, 552, -272},
    { 1632, 728, -176},
    { 1336, 824, -248},
    { 1128, 1200, -400},
    { 928, 1408, -288},
    { 1168, 880, -232},
    { 864, 760, -200},
    { 1080, 664, -128},
    { 1384, 592, 120},
    { 1240, 176, -112},
    { 1128, 0, 0},
    { 952, 312, -176},
    // 45 seconds
    { 1040, 248, -56},
    { 1168, 232, -120},
    { 1288, 192, -136},
    { 1168, 160, -80},
    { 1040, 56, -176},
    { 776, -168, -16},
    { 656, -80, -272},
    { 896, 0, -424},
    { 1184, 112, -272},
    { 1200, 168, -328},
    { 1032, 200, -312},
    { 1048, 384, -232},
    { 1368, 328, -168},
    { 1544, 592, -192},
    { 1448, 824, -152},
    { 1216, 888, -256},
    { 1032, 1088, -360},
    { 992, 1224, -328},
    { 1104, 848, -256},
    { 928, 776, -296},
    { 1080, 608, -232},
    { 1296, 712, 88},
    { 1224, 432, -128},
    { 1128, 584, 256},
    { 1208, 24, -16},
    // 46 seconds
    { 1224, 192, -64},
    { 1280, 168, -56},
    { 1160, 136, -64},
    { 1264, 200, -168},
    { 992, 72, -208},
    { 672, -104, -80},
    { 464, -48, -352},
    { 544, 24, -440},
    { 1016, 152, -384},
    { 1320, 144, -424},
    { 1080, 152, -304},
    { 1040, 320, -264},
    { 1264, 424, -248},
    { 1488, 632, -272},
    { 1336, 736, -264},
    { 984, 784, -456},
    { 848, 976, -552},
    { 1000, 960, -448},
    { 1168, 944, -376},
    { 992, 624, -264},
    { 1064, 568, -216},
    { 1392, 536, -152},
    { 1312, 336, -48},
    { 1112, 160, -128},
    { 1040, 192, -136},
    // 47 seconds
    { 1088, 256, -104},
    { 1192, 216, -136},
    { 1192, 184, -112},
    { 1120, 160, -168},
    { 856, -80, -96},
    { 728, -72, 24},
    { 504, -8, -504},
    { 712, -40, -312},
    { 1416, 256, -440},
    { 1392, 104, -400},
    { 1160, 160, -328},
    { 1096, 320, -264},
    { 1232, 392, -304},
    { 1328, 592, -256},
    { 1248, 648, -200},
    { 1048, 784, -328},
    { 936, 912, -344},
    { 936, 824, -216},
    { 1176, 784, -248},
    { 1160, 728, -160},
    { 1240, 672, -144},
    { 1480, 504, -192},
    { 1208, 272, -96},
    { 1016, 240, -160},
    { 1048, 264, -112},
    // 48 seconds
    { 1168, 80, -104},
    { 1288, 200, -104},
    { 1280, 112, 0},
    { 1336, 136, -8},
    { 1200, 128, -184},
    { 944, -80, -24},
    { 552, -32, -224},
    { 544, -80, -424},
    { 808, 40, -368},
    { 1032, 128, -376},
    { 1016, 136, -360},
    { 1152, 304, -288},
    { 1408, 504, -256},
    { 1608, 768, -360},
    { 1248, 648, -256},
    { 992, 744, -376},
    { 856, 1016, -280},
    { 1312, 968, -280},
    { 1272, 624, -208},
    { 1104, 576, -272},
    { 1008, 512, -216},
    { 1112, 384, -184},
    { 1024, 240, -120},
    { 1048, 224, -120},
    { 1184, 112, -40},
    // 49 seconds
    { 1328, 24, -80},
    { 1256, 112, -32},
    { 1200, 144, -8},
    { 1184, 112, -32},
    { 1120, 168, -160},
    { 1064, -200, 152},
    { 592, 64, -280},
    { 848, -56, -440},
    { 1136, 104, -296},
    { 1000, 128, -376},
    { 848, 136, -384},
    { 920, 272, -280},
    { 1176, 440, -328},
    { 1464, 616, -320},
    { 1072, 704, -280},
    { 864, 528, -440},
    { 880, 848, -376},
    { 1256, 936, -248},
    { 1520, 904, -232},
    { 1208, 464, -264},
    { 968, 496, -256},
    { 1056, 512, -176},
    { 1112, 336, -112},
    { 1064, -112, -24},
    { 976, 128, -224},
    // 50 seconds
    { 1080, 96, -112},
    { 1128, 304, -56},
    { 1040, 96, -16},
    { 1016, 120, -64},
    { 1008, 192, -104},
    { 1272, 24, 0},
    { 736, -32, -128},
    { 720, 40, -520},
    { 1256, 24, -288},
    { 1128, 104, -328},
    { 856, 72, -384},
    { 864, 248, -320},
    { 1008, 312, -216},
    { 1256, 440, -248},
    { 1408, 616, -248},
    { 976, 832, -256},
    { 1120, 792, -400},
    { 1144, 1080, -216},
    { 1376, 1048, -200},
    { 944, 616, -200},
    { 848, 592, -200},
    { 1152, 608, -152},
    { 1296, 288, -128},
    { 1152, 0, -8},
    { 1272, 384, -360},
    // 51 seconds
    { 1344, 56, -56},
    { 1336, -184, -40},
    { 936, 176, -48},
    { 1216, 32, -88},
    { 992, -256, -24},
    { 1088, -32, -56},
    { 768, -80, -224},
    { 752, 56, -352},
    { 1128, 184, -296},
    { 1128, 160, -256},
    { 1016, 112, -248},
    { 1072, 272, -224},
    { 1224, 488, -144},
    { 1296, 640, -200},
    { 1168, 608, -192},
    { 1016, 712, -272},
    { 920, 1200, -248},
    { 984, 1040, -232},
    { 1256, 1024, -320},
    { 1048, 704, -224},
    { 1128, 776, -144},
    { 1584, 656, -88},
    { 1432, 360, -128},
    { 1504, 416, 16},
    { 1480, 360, 24},
    // 52 seconds
    { 1384, 504, 168},
    { 1192, 312, 184},
    { 944, 312, 272},
    { 808, 272, 368},
    { 640, 424, 376},
    { 752, 600, 512},
    { 352, 752, 304},
    { 80, 1112, 448},
    { 168, 1232, 288},
    { 40, 1248, 264},
    { -184, 984, 208},
    { -344, 984, 96},
    { -392, 776, 40},
    { -336, 760, 8},
    { -296, 1224, -144},
    { -168, 920, 64},
    { -136, 1024, 192},
    { -192, 912, 120},
    { -280, 816, 176},
    { -304, 768, 40},
    { -304, 840, 24},
    { -296, 680, -8},
    { -264, 952, -48},
    { -304, 896, -56},
    { -280, 872, -160},
    // 53 seconds
    { -320, 784, 16},
    { -352, 832, -24},
    { -424, 800, 24},
    { -440, 768, 88},
    { -472, 856, 32},
    { -480, 792, 128},
    { -472, 944, 96},
    { -448, 824, 104},
    { -448, 904, 96},
    { -440, 864, 40},
    { -456, 856, 152},
    { -464, 920, 56},
    { -400, 896, -16},
    { -456, 960, 88},
    { -504, 1064, -64},
    { -576, 936, -112},
    { -664, 984, -168},
    { -592, 1008, -280},
    { -560, 648, -352},
    { -560, 528, -472},
    { -440, 496, -608},
    { -392, 352, -808},
    { -320, 120, -744},
    { -280, 72, -832},
    { -264, -136, -928},
    // 54 seconds
    { -240, -96, -928},
    { -240, -128, -1000},
    { -248, -72, -1032},
    { -248, -144, -1016},
    { -232, -144, -1000},
    { -232, -144, -1024},
    { -232, -184, -1024},
    { -224, -248, -1008},
    { -192, -248, -1000},
    { -248, -104, -976},
    { -224, -248, -984},
    { -248, -144, -1056},
    { -256, -272, -1032},
    { -264, -184, -984},
    { -312, -168, -984},
    { -248, -312, -976},
    { -232, -272, -976},
    { -232, -280, -1000},
    { -232, -224, -968},
    { -248, -216, -992},
    { -264, -280, -1000},
    { -272, -208, -976},
    { -296, -328, -944},
    { -264, -224, -960},
    { -232, -376, -1000},
    // 55 seconds
    { -232, -344, -1008},
    { -256, -288, -1008},
    { -280, -312, -976},
    { -272, -288, -952},
    { -224, -360, -976},
    { -104, -416, -872},
    { -40, -320, -824},
    { -16, -336, -960},
    { -32, -320, -904},
    { -176, -16, -896},
    { -32, 176, -648},
    { -168, 560, -512},
    { -264, 864, -208},
    { -440, 1336, 72},
    { -528, 1360, 232},
    { -536, 1320, 352},
    { -424, 848, 272},
    { -408, 976, 496},
    { -280, 928, 280},
    { -264, 776, 640},
    { -248, 800, 592},
    { -248, 704, 592},
    { -264, 800, 472},
    { -280, 736, 392},
    { -320, 832, 360},
    // 56 seconds
    { -352, 792, 352},
    { -392, 808, 360},
    { -432, 816, 360},
    { -464, 776, 312},
    { -496, 728, 336},
    { -528, 760, 352},
    { -560, 728, 328},
    { -576, 720, 320},
    { -592, 736, 304},
    { -584, 720, 264},
    { -592, 720, 208},
    { -584, 632, 280},
    { -616, 624, 304},
    { -616, 624, 328},
    { -640, 632, 304},
    { -672, 656, 272},
    { -688, 648, 304},
    { -688, 632, 304},
    { -664, 592, 296},
    { -672, 600, 320},
    { -688, 648, 304},
    { -680, 624, 320},
    { -664, 624, 288},
    { -672, 632, 296},
    { -672, 640, 304},
    // 57 seconds
    { -680, 616, 296},
    { -680, 632, 288},
    { -656, 608, 248},
    { -680, 672, 320},
    { -680, 648, 296},
    { -664, 664, 272},
    { -696, 656, 280},
    { -688, 616, 256},
    { -680, 656, 288},
    { -648, 664, 272},
    { -672, 656, 256},
    { -728, 680, 200},
    { -696, 640, 48},
    { -632, 552, -216},
    { -680, 840, -352},
    { -640, 1048, -328},
    { -768, 1056, -200},
    { -720, 1216, -536},
    { -688, 792, -488},
    { -424, 80, -704},
    { -288, 168, -960},
    { -288, -192, -840},
    { -272, -256, -912},
    { -232, -512, -792},
    { -208, -512, -784},
    // 58 seconds
    { -216, -256, -896},
    { -248, -296, -920},
    { -304, -288, -856},
    { -336, -352, -856},
    { -352, -264, -976},
    { -216, -432, -856},
    { -384, -368, -992},
    { -432, -256, -984},
    { -320, -352, -976},
    { -304, -312, -928},
    { -392, -328, -944},
    { -456, -232, -1008},
    { -416, -296, -920},
    { -456, -312, -968},
    { -360, -312, -952},
    { -384, -320, -920},
    { -368, -304, -1000},
    { -320, -240, -936},
    { -448, -288, -888},
    { -488, -208, -952},
    { -416, -288, -920},
    { -432, -288, -944},
    { -416, -256, -952},
    { -408, -288, -944},
    { -416, -272, -944},
    // 59 seconds
    { -440, -264, -952},
    { -416, -280, -944},
    { -432, -280, -944},
    { -416, -280, -952},
    { -416, -272, -944},
    { -392, -288, -936},
    { -400, -256, -952},
    { -416, -272, -952},
    { -408, -280, -936},
    { -408, -264, -944},
    { -408, -280, -944},
    { -424, -272, -944},
    { -416, -288, -928},
    { -384, -288, -912},
    { -336, -328, -880},
    { -168, -512, -640},
    { -208, 96, -208},
    { -288, 664, -520},
    { -384, 1088, 56},
    { -736, 1424, 448},
    { -720, 1000, 48},
    { -640, 1232, 8},
    { -584, 800, 216},
    { -576, 904, 144},
    { -568, 832, 144},
    // 60 seconds
    // elapsed: 1 minutes
    { -584, 768, 144},
    { -552, 720, 104},
    { -608, 752, 184},
    { -632, 632, 128},
    { -600, 568, 96},
    { -656, 664, 128},
    { -680, 744, 168},
    { -664, 712, 96},
    { -656, 688, 128},
    { -664, 712, 152},
    { -680, 744, 136},
    { -656, 640, 144},
    { -672, 672, 152},
    { -680, 696, 152},
    { -672, 656, 128},
    { -680, 696, 144},
    { -696, 712, 152},
    { -680, 688, 112},
    { -696, 680, 128},
    { -680, 648, 144},
    { -672, 672, 112},
    { -704, 712, 120},
    { -712, 736, 136},
    { -696, 672, 184},
    { -688, 704, 144},
    // 61 seconds
    { -680, 688, 104},
    { -680, 672, 96},
    { -680, 656, 136},
    { -688, 696, 152},
    { -696, 736, 144},
    { -696, 696, 136},
    { -664, 704, 96},
    { -656, 696, 120},
    { -688, 688, 128},
    { -704, 680, 128},
    { -672, 656, 128},
    { -648, 704, 96},
    { -664, 712, 96},
    { -712, 728, 88},
    { -680, 704, 136},
    { -672, 704, 136},
    { -680, 664, 160},
    { -664, 664, 112},
    { -664, 672, 88},
    { -664, 720, 136},
    { -680, 744, 104},
    { -680, 704, 88},
    { -696, 696, 88},
    { -672, 704, 72},
    { -664, 696, 104},
    // 62 seconds
    { -664, 656, 120},
    { -664, 720, 88},
    { -696, 712, 88},
    { -688, 696, 104},
    { -672, 688, 128},
    { -688, 704, 112},
    { -664, 704, 72},
    { -664, 712, 96},
    { -688, 720, 128},
    { -696, 704, 88},
    { -712, 696, 80},
    { -688, 680, 32},
    { -656, 640, 104},
    { -664, 712, 112},
    { -704, 736, 144},
    { -712, 696, 112},
    { -696, 696, 56},
    { -680, 712, 72},
    { -656, 672, 112},
    { -648, 664, 80},
    { -688, 688, 96},
    { -720, 736, 88},
    { -704, 736, 112},
    { -648, 704, 104},
    { -680, 696, 184},
    // 63 seconds
    { -680, 728, 128},
    { -680, 680, 160},
    { -688, 672, 184},
    { -696, 664, 176},
    { -712, 616, 216},
    { -728, 640, 248},
    { -720, 624, 224},
    { -704, 632, 240},
    { -672, 664, 264},
    { -648, 632, 264},
    { -632, 584, 304},
    { -624, 640, 264},
    { -640, 640, 272},
    { -672, 800, 416},
    { -632, 688, 216},
    { -632, 696, 224},
    { -640, 712, 224},
    { -712, 648, 368},
    { -696, 616, 264},
    { -688, 688, 264},
    { -704, 688, 280},
    { -680, 688, 272},
    { -664, 704, 272},
    { -608, 696, 232},
    { -608, 728, 296},
    // 64 seconds
    { -632, 688, 264},
    { -640, 608, 288},
    { -616, 584, 224},
    { -624, 584, 344},
    { -648, 664, 328},
    { -712, 736, 272},
    { -672, 672, 232},
    { -656, 744, 264},
    { -592, 600, 288},
    { -592, 584, 312},
    { -640, 688, 272},
    { -672, 736, 312},
    { -648, 656, 288},
    { -616, 672, 248},
    { -640, 736, 216},
    { -640, 720, 296},
    { -608, 656, 336},
    { -616, 624, 328},
    { -688, 568, 336},
    { -688, 592, 352},
    { -664, 664, 320},
    { -624, 720, 304},
    { -600, 736, 272},
    { -568, 736, 208},
    { -568, 736, 216},
    // 65 seconds
    { -560, 696, 280},
    { -560, 880, 112},
    { -648, 744, 272},
    { -600, 608, 264},
    { -576, 720, 208},
    { -624, 720, 280},
    { -616, 696, 280},
    { -632, 760, 304},
    { -624, 704, 328},
    { -624, 680, 352},
    { -624, 688, 344},
    { -584, 712, 184},
    { -624, 664, 216},
    { -584, 792, 120},
    { -600, 760, 224},
    { -616, 720, 232},
    { -520, 792, -64},
    { -624, 832, 248},
    { -656, 704, 328},
    { -632, 752, 336},
    { -592, 640, 272},
    { -584, 704, 280},
    { -600, 696, 216},
    { -600, 704, 176},
    { -616, 720, 160},
    // 66 seconds
    { -624, 728, 168},
    { -632, 736, 176},
    { -632, 728, 184},
    { -624, 736, 192},
    { -608, 736, 184},
    { -616, 720, 192},
    { -608, 720, 184},
    { -616, 720, 184},
    { -608, 720, 192},
    { -616, 720, 176},
    { -616, 736, 176},
    { -624, 728, 184},
    { -608, 736, 184},
    { -608, 728, 160},
    { -600, 760, 120},
    { -648, 800, -88},
    { -632, 776, -328},
    { -888, 728, -112},
    { -800, 744, -88},
    { -544, 1032, -448},
    { -456, 872, -280},
    { -248, 592, -616},
    { -128, 568, -912},
    { -56, 280, -856},
    { 8, 80, -936},
    // 67 seconds
    { 16, -8, -1008},
    { -8, -168, -1056},
    { -24, -320, -968},
    { -32, -288, -928},
    { -40, -280, -1008},
    { -88, -304, -1016},
    { -112, -360, -992},
    { -104, -328, -968},
    { -112, -464, -968},
    { -104, -448, -936},
    { -136, -496, -952},
    { -176, -440, -928},
    { -168, -360, -960},
    { -176, -360, -960},
    { -208, -312, -1000},
    { -160, -344, -952},
    { -168, -288, -1008},
    { -224, -296, -1032},
    { -184, -368, -1000},
    { -208, -368, -968},
    { -208, -288, -984},
    { -200, -304, -976},
    { -176, -296, -992},
    { -176, -304, -984},
    { -176, -320, -976},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:04:19 local
AccelRawData *activity_sample_walk_100_pbl_25663_8(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25663_8
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -448, 824, 96},
    { -432, 816, 80},
    { -464, 824, 64},
    { -464, 824, 80},
    { -440, 848, 0},
    { -496, 936, -112},
    { -544, 1032, -400},
    { -560, 944, -640},
    { -504, 1000, -600},
    { -136, 744, -760},
    { -128, 336, -800},
    { -56, 64, -936},
    { -104, 112, -888},
    { -160, -160, -1016},
    { -8, -224, -800},
    { -40, -352, -816},
    { -168, -424, -872},
    { 0, -416, -896},
    { -72, -416, -968},
    { -112, -152, -1048},
    { 40, -376, -928},
    { -16, -456, -888},
    { -24, -432, -936},
    { -8, -392, -960},
    { -56, -312, -976},
    // 1 seconds
    { -32, -344, -1008},
    { -40, -424, -1008},
    { -184, -480, -968},
    { -232, -496, -920},
    { -184, -552, -912},
    { -184, -520, -968},
    { -184, -408, -1040},
    { -176, -208, -1248},
    { -728, -160, -1816},
    { -152, -288, -1008},
    { 88, -168, -1016},
    { -8, -56, -976},
    { -112, 96, -1016},
    { -120, 192, -1056},
    { -104, 176, -1064},
    { -168, 224, -1008},
    { -216, 40, -952},
    { -160, -16, -952},
    { -112, 0, -880},
    { -80, -16, -840},
    { -104, -104, -800},
    { -104, -72, -728},
    { 24, -64, -664},
    { 232, -40, -624},
    { 600, 8, -696},
    // 2 seconds
    { 1064, 88, -688},
    { 1408, 240, -520},
    { 1344, 352, -456},
    { 1504, 400, -424},
    { 1536, 416, -352},
    { 1456, 344, -288},
    { 1184, 472, -304},
    { 944, 376, -248},
    { 824, 408, -288},
    { 704, 432, -360},
    { 752, 456, -464},
    { 888, 616, -560},
    { 904, 744, -560},
    { 896, 656, -520},
    { 1168, 792, -512},
    { 1248, 632, -376},
    { 1632, 536, -288},
    { 1920, 472, -256},
    { 1704, 264, -216},
    { 1392, 248, -184},
    { 1304, 224, -184},
    { 1192, 176, -192},
    { 1064, 168, -104},
    { 1024, 120, -136},
    { 1080, 168, -152},
    // 3 seconds
    { 968, 96, -136},
    { 680, -208, -72},
    { 608, -128, -40},
    { 608, 32, -424},
    { 1000, -32, -360},
    { 1536, 152, -472},
    { 1496, 208, -360},
    { 1352, 312, -344},
    { 1256, 536, -384},
    { 1296, 400, -288},
    { 1432, 536, -320},
    { 1344, 648, -408},
    { 1080, 840, -488},
    { 1072, 880, -488},
    { 1104, 1192, -496},
    { 944, 672, -392},
    { 1096, 784, -352},
    { 1296, 592, -320},
    { 1328, 400, -264},
    { 1320, 336, -200},
    { 1320, 160, -136},
    { 1344, 232, -168},
    { 1488, 384, -184},
    { 1368, 256, -176},
    { 1320, 240, -160},
    // 4 seconds
    { 1072, 40, -88},
    { 680, -272, 40},
    { 464, -216, -168},
    { 800, -64, -360},
    { 1168, 224, -384},
    { 1120, 168, -352},
    { 1024, 128, -312},
    { 1152, 352, -328},
    { 1328, 408, -296},
    { 1440, 664, -424},
    { 1480, 512, -360},
    { 1200, 808, -648},
    { 896, 832, -496},
    { 1216, 1080, -520},
    { 1024, 720, -400},
    { 1064, 688, -392},
    { 1272, 600, -304},
    { 1160, 416, -232},
    { 1032, 344, -192},
    { 1120, 160, -168},
    { 1168, 424, -176},
    { 1352, 352, -208},
    { 1352, 272, -104},
    { 1288, 376, -136},
    { 872, 520, -200},
    // 5 seconds
    { 816, 824, -72},
    { 192, 656, -96},
    { -32, 920, -200},
    { 112, 792, -112},
    { 40, 672, -56},
    { -144, 608, -32},
    { -232, 600, 8},
    { -336, 680, 96},
    { -488, 872, 112},
    { -576, 1016, 96},
    { -568, 1112, 152},
    { -576, 1176, 328},
    { -568, 1344, 432},
    { -360, 1136, 296},
    { -352, 904, 200},
    { -408, 888, 104},
    { -352, 696, -80},
    { -400, 560, -48},
    { -488, 432, 120},
    { -392, 312, -16},
    { -144, 360, -88},
    { 416, 360, -184},
    { 1000, 328, -64},
    { 1296, 400, -208},
    { 1568, 536, 48},
    // 6 seconds
    { 1872, 528, -296},
    { 2336, 616, -296},
    { 2024, 608, -112},
    { 1360, 560, -184},
    { 1296, 440, -176},
    { 1352, 672, 24},
    { 1112, 864, -24},
    { 856, 912, -288},
    { 432, 1296, -360},
    { 768, 1088, -192},
    { 1160, 1144, -112},
    { 1432, 704, -128},
    { 1640, 640, -136},
    { 1880, 672, -96},
    { 1824, 344, -80},
    { 1488, 256, -104},
    { 1304, 248, -96},
    { 1416, 328, -112},
    { 1360, 200, -104},
    { 1168, 160, -96},
    { 1104, 112, -136},
    { 944, -192, 8},
    { 488, -432, 224},
    { 608, -64, -264},
    { 752, -40, -432},
    // 7 seconds
    { 1200, 208, -304},
    { 1424, 360, -480},
    { 1384, 280, -336},
    { 1384, 440, -360},
    { 1400, 552, -248},
    { 1648, 592, -272},
    { 1408, 888, -336},
    { 1032, 984, -400},
    { 856, 1192, -392},
    { 1104, 1336, -352},
    { 1144, 904, -192},
    { 1144, 800, -144},
    { 1248, 616, -112},
    { 1352, 440, -120},
    { 1096, 336, -96},
    { 1080, 264, -112},
    { 1256, 288, -136},
    { 1480, 264, -112},
    { 1272, 176, -48},
    { 1168, 152, -136},
    { 1112, 176, -208},
    { 760, -328, -96},
    { 808, -152, -56},
    { 728, -104, -344},
    { 1032, -72, -264},
    // 8 seconds
    { 1320, 248, -360},
    { 1240, 160, -320},
    { 1136, 304, -344},
    { 1176, 376, -320},
    { 1416, 504, -360},
    { 1528, 768, -368},
    { 1080, 976, -424},
    { 888, 1000, -552},
    { 832, 1040, -328},
    { 1056, 1112, -256},
    { 1144, 840, -176},
    { 1120, 648, -136},
    { 1224, 584, -96},
    { 1448, 472, -120},
    { 1208, 320, -104},
    { 1176, 328, -168},
    { 1272, 160, -184},
    { 1384, 312, -152},
    { 1104, 104, -184},
    { 976, 128, -248},
    { 856, -48, -152},
    { 432, -360, -96},
    { 808, -64, -272},
    { 864, -24, -280},
    { 1264, 16, -360},
    // 9 seconds
    { 1600, 360, -496},
    { 1488, 200, -360},
    { 1296, 264, -368},
    { 1200, 400, -296},
    { 1288, 488, -264},
    { 1192, 720, -288},
    { 952, 872, -432},
    { 760, 1096, -536},
    { 792, 816, -440},
    { 984, 1040, -424},
    { 1144, 640, -200},
    { 1232, 656, -256},
    { 1600, 576, -280},
    { 1816, 392, -296},
    { 1512, 176, -288},
    { 1520, 152, -272},
    { 1432, 16, -296},
    { 1128, 128, -296},
    { 888, -56, -184},
    { 632, -144, -80},
    { 448, -160, -56},
    { 304, -48, -160},
    { 544, 0, -152},
    { 920, 208, -72},
    { 1256, 224, -232},
    // 10 seconds
    { 2016, 432, -384},
    { 2384, 576, -424},
    { 1416, 640, -256},
    { 1136, 368, -200},
    { 1440, 456, -248},
    { 1056, 744, 0},
    { 864, 680, -88},
    { 976, 848, -216},
    { 1048, 1072, -256},
    { 872, 968, -344},
    { 896, 1008, -344},
    { 880, 648, -288},
    { 1176, 528, -336},
    { 1784, 520, -296},
    { 1808, 376, -272},
    { 1648, -80, -136},
    { 1360, 256, -248},
    { 1240, 216, -248},
    { 1096, 184, -232},
    { 936, 128, -216},
    { 944, 80, -160},
    { 840, -152, -16},
    { 920, -288, 120},
    { 1032, 16, 192},
    { 1272, 96, -240},
    // 11 seconds
    { 1368, 256, -184},
    { 1584, 400, -400},
    { 1600, 504, -248},
    { 1712, 672, -176},
    { 1792, 936, -288},
    { 1704, 704, -128},
    { 1320, 1008, -136},
    { 824, 672, -256},
    { 856, 744, -288},
    { 880, 1072, -208},
    { 976, 808, -288},
    { 1192, 800, -368},
    { 1288, 704, -376},
    { 1328, 520, -360},
    { 1352, 432, -256},
    { 1408, 64, -336},
    { 1424, 160, -192},
    { 1448, 240, -136},
    { 1536, 224, -144},
    { 1288, 48, -80},
    { 1272, 112, -136},
    { 984, -504, 144},
    { 808, -48, -104},
    { 1016, 56, -720},
    { 1152, -160, -184},
    // 12 seconds
    { 1136, 200, -432},
    { 968, 144, -256},
    { 976, 432, -112},
    { 1232, 392, 0},
    { 1576, 656, -16},
    { 1808, 784, 144},
    { 1360, 888, 152},
    { 1328, 664, 168},
    { 1056, 1168, 400},
    { 968, 928, 264},
    { 968, 824, 144},
    { 968, 744, 40},
    { 912, 568, -72},
    { 832, 520, -96},
    { 992, 448, -48},
    { 1424, 328, -128},
    { 1992, 416, -200},
    { 1720, 464, -64},
    { 1736, 72, -216},
    { 896, -488, 160},
    { 288, -432, -8},
    { 600, -88, -352},
    { 752, -48, -568},
    { 1024, -432, -96},
    { 1368, 344, -568},
    // 13 seconds
    { 1184, 240, -544},
    { 1088, 168, -128},
    { 1360, 528, -384},
    { 1472, 656, -384},
    { 1336, 656, -448},
    { 928, 712, -584},
    { 848, 976, -600},
    { 1144, 976, -584},
    { 1104, 752, -432},
    { 1160, 696, -368},
    { 1320, 536, -288},
    { 1352, 384, -240},
    { 1168, 216, -248},
    { 1072, 240, -176},
    { 1160, 168, -184},
    { 1280, 272, -192},
    { 1312, 152, -136},
    { 1152, 144, -88},
    { 1032, -8, -40},
    { 568, -296, 8},
    { 768, 40, -80},
    { 768, 16, -544},
    { 1184, -112, -136},
    { 1456, 392, -384},
    { 1216, 104, -312},
    // 14 seconds
    { 1184, 320, -256},
    { 1280, 568, -248},
    { 1432, 584, -328},
    { 1368, 616, -296},
    { 1144, 720, -456},
    { 912, 984, -464},
    { 808, 1216, -448},
    { 1072, 1024, -360},
    { 1224, 856, -304},
    { 1488, 736, -176},
    { 1656, 560, -152},
    { 1360, 304, -152},
    { 1128, 232, -104},
    { 1184, 288, -112},
    { 1232, 208, -120},
    { 1224, 232, -128},
    { 1160, 144, -72},
    { 976, 80, -112},
    { 848, 112, -208},
    { 624, -184, 24},
    { 408, -40, -320},
    { 920, -40, -416},
    { 1296, 16, -304},
    { 1344, 184, -416},
    { 1088, 200, -408},
    // 15 seconds
    { 1112, 328, -320},
    { 1360, 336, -304},
    { 1528, 616, -376},
    { 1336, 816, -512},
    { 1016, 888, -672},
    { 968, 1032, -656},
    { 1144, 1056, -560},
    { 1080, 752, -360},
    { 1200, 712, -312},
    { 1360, 608, -240},
    { 1328, 424, -192},
    { 1112, 256, -152},
    { 1032, 216, -136},
    { 1168, 232, -136},
    { 1224, 184, -128},
    { 1288, 192, -80},
    { 1192, 152, -80},
    { 1032, 152, -160},
    { 920, -40, -72},
    { 368, -216, 16},
    { 728, 80, -488},
    { 976, -56, -296},
    { 1320, 168, -256},
    { 1096, 200, -376},
    { 1080, 256, -296},
    // 16 seconds
    { 1264, 376, -216},
    { 1672, 544, -328},
    { 1448, 760, -384},
    { 1096, 744, -544},
    { 928, 1008, -656},
    { 968, 992, -528},
    { 1192, 992, -392},
    { 1024, 704, -272},
    { 1160, 648, -240},
    { 1448, 576, -192},
    { 1320, 376, -136},
    { 1200, 184, -152},
    { 1232, 248, -72},
    { 1216, 104, -144},
    { 1168, 232, -128},
    { 1080, 200, -176},
    { 1088, 208, -192},
    { 880, 144, -320},
    { 712, -112, -88},
    { 384, -56, -216},
    { 576, -64, -456},
    { 848, 16, -408},
    { 1328, 120, -384},
    { 1264, 216, -472},
    { 1288, 328, -304},
    // 17 seconds
    { 1432, 512, -304},
    { 1552, 752, -328},
    { 1312, 784, -320},
    { 856, 1136, -408},
    { 880, 1152, -296},
    { 1232, 1104, -184},
    { 1216, 848, -112},
    { 1208, 744, -72},
    { 1288, 640, -40},
    { 1248, 440, -80},
    { 1096, 296, -96},
    { 1104, 320, -112},
    { 1224, 216, -88},
    { 1272, 224, -96},
    { 1288, 176, -120},
    { 1176, 168, -80},
    { 992, 120, -144},
    { 816, -104, -88},
    { 432, -48, -80},
    { 712, 72, -552},
    { 928, -80, -384},
    { 1216, 104, -416},
    { 1160, 184, -520},
    { 1200, 264, -336},
    { 1320, 424, -272},
    // 18 seconds
    { 1384, 872, -312},
    { 1416, 656, -256},
    { 1096, 968, -232},
    { 920, 1064, -128},
    { 1104, 960, -104},
    { 1064, 992, -48},
    { 1104, 704, -80},
    { 1152, 632, -64},
    { 1296, 584, -104},
    { 1144, 328, -128},
    { 1064, 288, -208},
    { 1168, 176, -112},
    { 1272, 192, -152},
    { 1160, 192, -176},
    { 1280, 168, -192},
    { 1088, 120, -144},
    { 864, 0, -184},
    { 720, -264, 104},
    { 744, -8, -520},
    { 1040, -88, -464},
    { 1200, -336, -48},
    { 1128, 128, -352},
    { 944, 184, -432},
    { 1016, 232, -256},
    { 1376, 416, -336},
    // 19 seconds
    { 1496, 704, -360},
    { 1280, 1000, -312},
    { 1176, 688, -312},
    { 1000, 888, -168},
    { 1072, 1128, -120},
    { 1032, 952, -64},
    { 1128, 728, -144},
    { 1248, 736, -120},
    { 1376, 568, -96},
    { 1200, 344, -128},
    { 1184, 152, -176},
    { 1176, 264, -120},
    { 1200, 104, -120},
    { 1256, 200, -144},
    { 1176, 128, -32},
    { 1104, 160, -48},
    { 672, -456, 152},
    { 712, 104, 40},
    { 712, 128, -536},
    { 984, -112, -288},
    { 1336, 368, -360},
    { 1120, 8, -408},
    { 1000, 104, -368},
    { 1024, 216, -240},
    { 1248, 408, -368},
    // 20 seconds
    { 1336, 696, -368},
    { 1184, 784, -352},
    { 1024, 896, -328},
    { 1112, 688, -272},
    { 1208, 952, -232},
    { 1000, 680, -176},
    { 1112, 688, -168},
    { 1264, 608, -176},
    { 1096, 408, -144},
    { 960, 496, -144},
    { 1040, 232, -96},
    { 1112, 192, -120},
    { 1328, 256, -120},
    { 1264, 176, -16},
    { 1304, 144, -104},
    { 1024, -200, 88},
    { 1056, -112, 8},
    { 760, -24, -80},
    { 776, 64, -456},
    { 1224, 104, -160},
    { 1152, 256, -312},
    { 1024, 168, -256},
    { 976, 352, -224},
    { 1080, 432, -208},
    { 1336, 584, -280},
    // 21 seconds
    { 1320, 744, -208},
    { 1128, 672, -352},
    { 1008, 832, -392},
    { 1120, 984, -264},
    { 1120, 848, -192},
    { 1136, 664, -240},
    { 1232, 648, -176},
    { 1232, 520, -128},
    { 1024, 312, -112},
    { 992, 112, -128},
    { 1048, 208, -96},
    { 1272, 288, -112},
    { 1408, 144, -56},
    { 1232, 120, -64},
    { 1208, 112, -72},
    { 648, -264, -16},
    { 1000, 48, 24},
    { 728, 72, -368},
    { 1072, -72, -168},
    { 1216, 376, -232},
    { 1000, 160, -272},
    { 904, 248, -264},
    { 1056, 328, -232},
    { 1296, 440, -320},
    { 1432, 680, -392},
    // 22 seconds
    { 1216, 728, -568},
    { 1008, 832, -632},
    { 872, 816, -520},
    { 1160, 872, -456},
    { 1248, 664, -312},
    { 1408, 600, -256},
    { 1432, 488, -224},
    { 1176, 304, -144},
    { 960, 224, -120},
    { 1008, 216, -104},
    { 1160, 224, -160},
    { 1256, 192, -72},
    { 1256, 128, -40},
    { 1168, 112, -24},
    { 952, 16, -64},
    { 792, -312, 176},
    { 816, 24, -232},
    { 1080, -88, -352},
    { 1280, 72, -168},
    { 1104, 256, -328},
    { 936, 136, -360},
    { 944, 280, -240},
    { 1264, 416, -328},
    { 1640, 656, -400},
    { 1456, 952, -416},
    // 23 seconds
    { 1160, 896, -496},
    { 920, 1008, -400},
    { 1152, 1040, -320},
    { 1152, 768, -200},
    { 1336, 712, -192},
    { 1544, 600, -168},
    { 1296, 408, -112},
    { 1128, 192, -152},
    { 1080, 224, -120},
    { 1152, 152, -112},
    { 1336, 288, -80},
    { 1400, 120, 8},
    { 1160, 176, -48},
    { 984, 64, -96},
    { 536, -376, 24},
    { 656, 112, -40},
    { 888, 144, -480},
    { 1128, -56, -304},
    { 1368, 312, -456},
    { 1144, -48, -360},
    { 1032, 320, -312},
    { 1136, 376, -512},
    { 1168, 880, -448},
    { 1336, 520, -360},
    { 1096, 736, -392},
    // 24 seconds
    { 1040, 1024, -344},
    { 1168, 1016, -256},
    { 1176, 776, -240},
    { 1184, 720, -200},
    { 1200, 672, -176},
    { 1264, 464, -184},
    { 1072, 176, -96},
    { 920, 296, -208},
    { 984, 160, -96},
    { 1160, 264, -160},
    { 1360, 184, -160},
    { 1184, 112, -64},
    { 1136, 128, -128},
    { 896, -32, -144},
    { 760, -128, -8},
    { 664, 32, -232},
    { 920, -16, -296},
    { 1312, 192, -296},
    { 1168, 240, -344},
    { 960, 176, -304},
    { 968, 288, -224},
    { 1208, 432, -264},
    { 1432, 648, -304},
    { 1192, 888, -432},
    { 976, 920, -504},
    // 25 seconds
    { 976, 912, -496},
    { 1112, 1064, -456},
    { 1088, 728, -288},
    { 1176, 672, -280},
    { 1360, 584, -240},
    { 1488, 448, -200},
    { 1160, 240, -152},
    { 1016, 72, -152},
    { 1112, 200, -160},
    { 1144, 208, -96},
    { 1160, 152, -96},
    { 1048, 160, -96},
    { 992, 104, -64},
    { 648, -200, -32},
    { 656, -8, -48},
    { 656, 72, -432},
    { 1064, 0, -280},
    { 1520, 344, -472},
    { 1264, 104, -392},
    { 1080, 192, -320},
    { 1128, 392, -288},
    { 1304, 504, -280},
    { 1368, 632, -304},
    { 1144, 816, -384},
    { 912, 1080, -432},
    // 26 seconds
    { 952, 872, -408},
    { 1160, 976, -360},
    { 1104, 752, -216},
    { 1232, 688, -192},
    { 1472, 552, -192},
    { 1240, 392, -216},
    { 1080, 160, -176},
    { 1072, 208, -120},
    { 1200, 240, -152},
    { 1440, 224, -152},
    { 1336, 136, -56},
    { 1248, 128, -96},
    { 960, 64, -200},
    { 656, -344, 8},
    { 656, -56, -328},
    { 832, -16, -432},
    { 1136, 8, -232},
    { 1224, 280, -432},
    { 1000, 136, -320},
    { 1016, 288, -184},
    { 1384, 392, -312},
    { 1608, 752, -368},
    { 1288, 848, -320},
    { 1032, 672, -464},
    { 1048, 1064, -440},
    // 27 seconds
    { 1088, 1096, -288},
    { 1152, 848, -304},
    { 1000, 720, -248},
    { 1264, 688, -200},
    { 1512, 576, -168},
    { 1120, 336, -104},
    { 856, 88, -32},
    { 960, 312, -184},
    { 1280, 184, -144},
    { 1528, 288, -144},
    { 1248, 88, -64},
    { 984, 104, -128},
    { 824, 144, -232},
    { 656, -176, 24},
    { 424, 8, -368},
    { 736, -24, -488},
    { 1152, 24, -312},
    { 1192, 128, -432},
    { 944, 64, -368},
    { 904, 216, -264},
    { 1136, 344, -224},
    { 1520, 560, -312},
    { 1584, 720, -272},
    { 1264, 856, -264},
    { 1280, 808, -352},
    // 28 seconds
    { 1056, 1080, -208},
    { 1016, 968, -152},
    { 944, 800, -168},
    { 1016, 744, -128},
    { 1152, 560, -128},
    { 992, 392, -152},
    { 872, 272, -184},
    { 936, 256, -168},
    { 1200, 200, -152},
    { 1384, 160, -200},
    { 1392, 128, -136},
    { 1216, 128, -256},
    { 856, -104, -248},
    { 464, -200, -72},
    { 632, 0, -568},
    { 920, -72, -528},
    { 1360, 104, -512},
    { 960, 56, -440},
    { 848, 152, -328},
    { 1000, 320, -216},
    { 1424, 616, -240},
    { 1448, 864, -120},
    { 1104, 792, -160},
    { 920, 872, -184},
    { 984, 1008, -16},
    // 29 seconds
    { 1184, 1200, 64},
    { 1112, 800, -24},
    { 976, 760, -48},
    { 1080, 616, -32},
    { 1344, 560, -64},
    { 1056, 432, -128},
    { 992, 184, -160},
    { 920, 272, -144},
    { 1104, 320, -160},
    { 1368, 536, -136},
    { 1296, 1096, -336},
    { 1224, 1072, -944},
    { 776, 976, -1096},
    { 440, 768, -632},
    { 344, 96, -344},
    { 424, -312, -280},
    { 256, -424, -504},
    { 192, -464, -352},
    { 104, -456, -272},
    { -40, -584, -336},
    { -160, -696, -440},
    { -368, -816, -496},
    { -416, -952, -632},
    { -304, -1000, -712},
    { -264, -1000, -856},
    // 30 seconds
    { -424, -976, -792},
    { -264, -872, -976},
    { -384, -792, -776},
    { -392, -616, -776},
    { -200, -488, -880},
    { -168, -576, -672},
    { -144, -536, -592},
    { -144, -512, -600},
    { -88, -536, -584},
    { -32, -584, -496},
    { 56, -600, -384},
    { 120, -520, -312},
    { 232, -328, -320},
    { 464, -40, -456},
    { 760, 80, -480},
    { 1456, 304, -752},
    { 1816, 440, -512},
    { 2096, 656, -440},
    { 1800, 736, -560},
    { 1704, 704, -504},
    { 1744, 848, -248},
    { 1592, 672, -200},
    { 1152, 728, -288},
    { 888, 960, -320},
    { 832, 1296, -352},
    // 31 seconds
    { 1048, 1264, -400},
    { 952, 928, -360},
    { 992, 784, -272},
    { 1136, 760, -168},
    { 1640, 600, -200},
    { 1608, 296, -112},
    { 1528, 328, -144},
    { 1480, 176, -120},
    { 1464, 184, -152},
    { 1296, 216, -128},
    { 1080, 136, -160},
    { 1056, 8, -200},
    { 400, -504, -72},
    { 944, -144, -224},
    { 608, -136, -328},
    { 1168, 104, -328},
    { 1368, 224, -376},
    { 1240, 184, -280},
    { 1264, 320, -200},
    { 1360, 496, -192},
    { 1544, 552, -152},
    { 1632, 744, -160},
    { 1424, 880, -232},
    { 1120, 984, -312},
    { 912, 1160, -400},
    // 32 seconds
    { 1016, 1216, -336},
    { 920, 832, -224},
    { 992, 736, -248},
    { 1256, 712, -176},
    { 1656, 560, -152},
    { 1480, 272, -136},
    { 1480, 248, -40},
    { 1480, 176, -144},
    { 1416, 240, -112},
    { 1448, 240, -120},
    { 1288, 168, -104},
    { 1152, 120, -144},
    { 720, -480, 32},
    { 752, -168, 32},
    { 792, -32, -568},
    { 912, -64, -128},
    { 1312, 264, -296},
    { 1104, 88, -344},
    { 1112, 272, -280},
    { 1392, 376, -336},
    { 1736, 544, -520},
    { 1424, 840, -584},
    { 1056, 840, -680},
    { 744, 1392, -616},
    { 976, 1408, -408},
    // 33 seconds
    { 1480, 1104, -328},
    { 1568, 984, -168},
    { 1688, 760, -80},
    { 1432, 512, 56},
    { 1144, 408, 96},
    { 1176, 376, 24},
    { 1672, 328, -88},
    { 1872, 304, 184},
    { 1472, 232, 32},
    { 1328, 176, -48},
    { 1232, 256, -80},
    { 920, -16, -32},
    { 552, -168, -240},
    { 392, -424, 0},
    { 296, -176, -368},
    { 792, -96, -624},
    { 1200, 96, -528},
    { 1272, 120, -616},
    { 1136, -8, -648},
    { 1040, 40, -608},
    { 1112, 272, -968},
    { 888, 280, -1208},
    { 712, 120, -1256},
    { 696, -88, -984},
    { 832, -24, -800},
    // 34 seconds
    { 1080, 256, -680},
    { 1752, 672, -744},
    { 1296, 496, -240},
    { 1488, 488, -344},
    { 1752, 392, -200},
    { 1336, 240, -80},
    { 1064, 120, -160},
    { 976, 224, -168},
    { 984, 216, -176},
    { 960, 168, -224},
    { 1080, 112, -264},
    { 1032, -64, -152},
    { 888, -712, 288},
    { 336, -568, 104},
    { 376, -352, -392},
    { 1136, 32, -208},
    { 2296, 632, 168},
    { 2560, 1616, -792},
    { 1984, 1280, -552},
    { 1720, 1168, -344},
    { 1488, 856, -256},
    { 1016, 1080, -120},
    { 448, 1072, -56},
    { 184, 920, -216},
    { 248, 832, -168},
    // 35 seconds
    { 840, 1328, -144},
    { 2128, 1016, 80},
    { 2072, 608, -328},
    { 1768, 704, -136},
    { 1536, 600, 56},
    { 1816, -16, 184},
    { 1648, 344, -304},
    { 1504, 200, 8},
    { 1440, 184, -64},
    { 1240, 80, -72},
    { 1224, 104, -80},
    { 896, -400, 328},
    { 592, -176, -80},
    { 1656, -24, -664},
    { 1432, -376, -24},
    { 1792, 344, -480},
    { 1424, 232, -504},
    { 1240, 328, -320},
    { 1336, 504, -312},
    { 1448, 512, -144},
    { 1704, 568, -128},
    { 1464, 712, -200},
    { 1168, 1008, -192},
    { 856, 1400, -176},
    { 872, 888, -328},
    // 36 seconds
    { 800, 976, -240},
    { 1040, 944, -160},
    { 1600, 824, -112},
    { 2112, 456, -152},
    { 1944, 296, -88},
    { 1736, 288, -56},
    { 1472, 160, -96},
    { 1360, 240, -88},
    { 1264, 176, -40},
    { 1064, 120, -32},
    { 1008, 96, -112},
    { 984, -104, -48},
    { 248, -560, -24},
    { 432, -144, -312},
    { 928, -96, -192},
    { 1968, 96, -280},
    { 2112, 400, -440},
    { 1808, 432, -256},
    { 1224, 400, -416},
    { 1248, 208, -328},
    { 1320, 464, -136},
    { 1328, 520, -88},
    { 1360, 544, -168},
    { 1440, 744, -184},
    { 992, 1264, -264},
    // 37 seconds
    { 896, 1016, -344},
    { 792, 1264, -336},
    { 1104, 896, -248},
    { 1440, 744, -352},
    { 1640, 576, -336},
    { 1584, 384, -248},
    { 1472, 296, -144},
    { 1376, 192, -184},
    { 1552, 240, -184},
    { 1664, 184, -168},
    { 1520, 48, -56},
    { 1240, 24, -40},
    { 800, -392, 112},
    { 504, -352, 152},
    { 624, -136, -272},
    { 1160, -48, -448},
    { 1344, -88, -16},
    { 1480, 344, -296},
    { 1168, 24, -304},
    { 1104, 264, -248},
    { 1264, 272, -176},
    { 1520, 512, -296},
    { 1608, 576, -464},
    { 1328, 800, -1000},
    { 800, 968, -1224},
    // 38 seconds
    { 936, 600, -896},
    { 1352, 888, -664},
    { 1304, 792, -400},
    { 1360, 736, -408},
    { 1392, 688, -248},
    { 1352, 512, -176},
    { 1144, 272, -136},
    { 1048, 160, -152},
    { 1120, 160, -112},
    { 1336, 200, -144},
    { 1376, 112, -104},
    { 1112, 96, -112},
    { 984, 40, -192},
    { 392, -416, -120},
    { 768, -192, -216},
    { 720, -136, -296},
    { 1152, -32, -376},
    { 1456, 192, -448},
    { 1496, 152, -400},
    { 1384, 240, -392},
    { 1312, 440, -528},
    { 1304, 688, -440},
    { 1264, 768, -488},
    { 1128, 880, -648},
    { 760, 1000, -632},
    // 39 seconds
    { 920, 992, -472},
    { 984, 944, -384},
    { 1472, 936, -208},
    { 1456, 704, -136},
    { 1456, 672, -176},
    { 1536, 656, -168},
    { 1288, 368, -136},
    { 1120, 104, -16},
    { 1080, 64, -240},
    { 1072, 192, -176},
    { 1232, 88, -216},
    { 1040, 48, -168},
    { 1032, 64, -240},
    { 752, -160, -40},
    { 224, -256, -168},
    { 608, -120, -152},
    { 960, 136, -304},
    { 1120, 32, -304},
    { 1848, 368, -504},
    { 1872, 456, -320},
    { 1568, 624, -352},
    { 1328, 304, -248},
    { 1688, 528, -360},
    { 1184, 920, -200},
    { 792, 864, -312},
    // 40 seconds
    { 752, 1104, -512},
    { 816, 888, -376},
    { 1000, 1088, -280},
    { 1240, 808, -112},
    { 1616, 768, -96},
    { 1768, 680, -72},
    { 1792, 424, -160},
    { 1512, 336, -64},
    { 1536, -928, -592},
    { 960, 24, -136},
    { 1120, 160, -128},
    { 1032, 144, -136},
    { 952, 64, -160},
    { 816, 16, -144},
    { 376, -192, -48},
    { 496, -48, -104},
    { 488, 48, -360},
    { 808, 152, -488},
    { 1480, 184, -512},
    { 2024, 200, -440},
    { 1496, 224, -336},
    { 1024, 480, -232},
    { 1368, 440, -416},
    { 1448, 544, -152},
    { 1184, 824, -56},
    // 41 seconds
    { 1232, 1064, -128},
    { 928, 984, -128},
    { 952, 936, -88},
    { 1056, 1064, 64},
    { 1352, 968, 128},
    { 1232, 816, -120},
    { 1320, 592, -248},
    { 1216, 416, -240},
    { 1144, 280, -248},
    { 1208, 128, -256},
    { 1408, 160, -216},
    { 1440, 40, -152},
    { 1248, 80, -152},
    { 1104, 72, -136},
    { 584, -280, 64},
    { 560, -200, 72},
    { 632, 168, -496},
    { 896, 8, -576},
    { 1584, -160, -152},
    { 1608, 320, -448},
    { 1280, 200, -416},
    { 1256, 296, -320},
    { 1504, 392, -272},
    { 1512, 768, -272},
    { 1304, 824, -376},
    // 42 seconds
    { 984, 992, -448},
    { 880, 1144, -400},
    { 944, 1096, -328},
    { 1200, 1016, -184},
    { 1184, 688, -136},
    { 1280, 672, -128},
    { 1568, 632, -128},
    { 1472, 344, -80},
    { 1264, 160, -96},
    { 1104, 656, 16},
    { 1256, 296, -120},
    { 1344, 56, -88},
    { 1264, 216, -72},
    { 1472, 96, -120},
    { 880, -744, 176},
    { 1272, 152, -472},
    { 800, -288, -456},
    { 1176, -280, -72},
    { 1216, 288, -344},
    { 1080, 144, -320},
    { 1128, 272, -216},
    { 1464, 464, -184},
    { 1560, 616, -176},
    { 1440, 784, -160},
    { 1320, 752, -240},
    // 43 seconds
    { 1080, 1032, -136},
    { 968, 1152, -96},
    { 744, 1160, -56},
    { 800, 872, -144},
    { 1064, 848, -72},
    { 1528, 680, -104},
    { 1432, 328, -136},
    { 1304, 344, -128},
    { 1312, 216, -64},
    { 1344, 320, -152},
    { 1576, 216, -64},
    { 1432, 104, -48},
    { 1432, 104, -192},
    { 736, -552, -56},
    { 1072, -288, -104},
    { 776, -232, -336},
    { 1312, -176, -264},
    { 1376, 208, -240},
    { 1248, 88, -264},
    { 1104, 264, -256},
    { 1224, 312, -96},
    { 1336, 584, -112},
    { 1192, 680, -24},
    { 1408, 576, -192},
    { 1320, 808, -144},
    // 44 seconds
    { 1200, 1016, -160},
    { 1016, 1064, -168},
    { 896, 1080, -248},
    { 856, 680, -280},
    { 1168, 752, -200},
    { 1552, 624, -160},
    { 1464, 344, -144},
    { 1352, 240, -72},
    { 1176, 112, 120},
    { 888, 96, 16},
    { 1248, 224, -64},
    { 1424, 72, -40},
    { 1280, 88, -64},
    { 1008, -480, 152},
    { 800, -176, -128},
    { 960, -232, -192},
    { 1216, -32, -224},
    { 1536, 136, -256},
    { 1464, 232, -320},
    { 1264, 112, -272},
    { 1272, 368, -208},
    { 1304, 504, -128},
    { 1248, 648, -120},
    { 1192, 664, -320},
    { 1008, 984, -312},
    // 45 seconds
    { 648, 1592, -152},
    { 888, 1088, -192},
    { 1200, 1256, -16},
    { 1336, 688, -8},
    { 1480, 776, -8},
    { 1840, 688, -40},
    { 1832, 56, 24},
    { 1408, 400, -184},
    { 1400, 120, -80},
    { 1400, 264, -120},
    { 1256, 120, -120},
    { 1080, 96, -136},
    { 976, 88, -192},
    { 824, -24, -248},
    { 408, -312, -176},
    { 752, -128, -288},
    { 528, -16, -360},
    { 1064, 72, -360},
    { 1632, 208, -528},
    { 1712, 208, -304},
    { 1424, 336, -304},
    { 1176, 608, -288},
    { 1384, 336, -168},
    { 1472, 552, -112},
    { 1392, 696, 40},
    // 46 seconds
    { 1184, 856, -8},
    { 1176, 1160, 8},
    { 1088, 856, -128},
    { 904, 1192, -56},
    { 832, 856, -8},
    { 976, 888, -8},
    { 1496, 648, -72},
    { 1456, 368, -120},
    { 1368, -32, -8},
    { 1440, 528, -88},
    { 1688, 216, -40},
    { 1456, 216, -88},
    { 1208, 152, -48},
    { 1216, 176, -120},
    { 960, -128, -200},
    { 808, -256, 104},
    { 560, -256, -424},
    { 1048, -40, -296},
    { 1384, 224, -280},
    { 1280, 200, -336},
    { 1144, 224, -280},
    { 1184, 336, -248},
    { 1416, 432, -184},
    { 1600, 664, -264},
    { 1528, 816, -296},
    // 47 seconds
    { 1104, 896, -528},
    { 928, 1088, -544},
    { 1064, 1136, -488},
    { 1024, 920, -344},
    { 960, 728, -248},
    { 1192, 680, -160},
    { 1584, 584, -112},
    { 1488, 312, -64},
    { 1280, 208, -152},
    { 1272, 304, -88},
    { 1432, 256, -112},
    { 1424, 160, -104},
    { 1160, 136, -72},
    { 1168, 144, -184},
    { 656, -376, -72},
    { 600, -280, 24},
    { 752, -144, -400},
    { 1032, -104, -280},
    { 1512, 312, -496},
    { 1168, 104, -368},
    { 1040, 168, -256},
    { 1152, 288, -288},
    { 1464, 448, -280},
    { 1664, 792, -400},
    { 1288, 1096, -488},
    // 48 seconds
    { 896, 1088, -776},
    { 832, 1064, -672},
    { 1128, 1120, -536},
    { 1408, 664, -336},
    { 1528, 768, -400},
    { 1632, 600, -312},
    { 1512, 480, -184},
    { 1200, -8, -32},
    { 1056, 104, -152},
    { 1040, 200, -192},
    { 1192, 224, -176},
    { 1160, 192, -112},
    { 1064, 144, -80},
    { 896, 152, -128},
    { 656, -104, -120},
    { 632, -72, -80},
    { 800, 16, -504},
    { 1064, -24, -264},
    { 1496, 160, -464},
    { 1304, 120, -312},
    { 1152, 288, -288},
    { 1152, 520, -328},
    { 1432, 504, -296},
    { 1472, 656, -280},
    { 1344, 688, -408},
    // 49 seconds
    { 1080, 944, -472},
    { 1008, 1208, -384},
    { 1272, 1232, -328},
    { 1024, 680, -304},
    { 1168, 728, -232},
    { 1464, 688, -136},
    { 1480, 408, -128},
    { 1184, 200, -80},
    { 1072, 64, 16},
    { 1240, 176, -144},
    { 1376, 168, -48},
    { 1344, 200, -88},
    { 1136, 104, -200},
    { 864, -224, -120},
    { 576, -192, -152},
    { 896, -272, -144},
    { 1040, 0, -304},
    { 1376, 72, -304},
    { 1520, 240, -416},
    { 1312, 168, -288},
    { 1248, 320, -272},
    { 1304, 472, -192},
    { 1456, 648, -248},
    { 1448, 792, -208},
    { 1128, 968, -344},
    // 50 seconds
    { 728, 1288, -432},
    { 856, 1176, -312},
    { 1264, 1160, -256},
    { 1072, 640, -192},
    { 1368, 760, -144},
    { 1848, 800, -48},
    { 1768, 320, -40},
    { 1408, 216, -112},
    { 1344, 296, -64},
    { 1280, 200, -40},
    { 1336, 224, -96},
    { 1424, 136, -40},
    { 1208, 56, -64},
    { 744, -408, -16},
    { 808, -312, 16},
    { 520, -160, -280},
    { 1160, -16, -440},
    { 1416, 128, -352},
    { 1272, 128, -328},
    { 1136, 144, -272},
    { 1224, 376, -232},
    { 1552, 496, -168},
    { 1912, 840, -168},
    { 1624, 824, -72},
    { 1248, 760, -304},
    // 51 seconds
    { 848, 1152, -304},
    { 832, 1248, -304},
    { 1128, 1056, -304},
    { 1120, 648, -320},
    { 1304, 688, -320},
    { 1544, 648, -288},
    { 1568, 272, -56},
    { 1864, 168, 96},
    { 1840, -64, 256},
    { 1584, 112, 400},
    { 1176, 168, 320},
    { 752, 192, 328},
    { 552, 256, 264},
    { 424, 456, 272},
    { 144, 680, 200},
    { -56, 800, 448},
    { -160, 1088, 496},
    { 0, 1120, 120},
    { -40, 928, 200},
    { 80, 856, 168},
    { 96, 728, 136},
    { -96, 928, 0},
    { -320, 688, 280},
    { -384, 752, 496},
    { -472, 600, 816},
    // 52 seconds
    { -424, 632, 792},
    { -288, 712, 592},
    { -240, 888, 640},
    { -272, 792, 696},
    { -192, 704, 536},
    { -224, 752, 384},
    { -224, 904, 248},
    { -240, 832, 248},
    { -248, 824, 280},
    { -344, 880, 376},
    { -376, 856, 456},
    { -424, 800, 400},
    { -408, 760, 400},
    { -400, 840, 352},
    { -368, 864, 264},
    { -304, 856, 120},
    { -464, 776, 152},
    { -504, 840, 152},
    { -376, 720, 160},
    { -440, 880, 192},
    { -544, 912, 120},
    { -464, 664, 24},
    { -432, 752, 176},
    { -392, 872, 168},
    { -488, 736, 176},
    // 53 seconds
    { -560, 808, 248},
    { -568, 808, 288},
    { -536, 776, 200},
    { -544, 808, 208},
    { -560, 744, 168},
    { -600, 760, 128},
    { -640, 768, 96},
    { -664, 792, 48},
    { -648, 800, -24},
    { -616, 768, 16},
    { -576, 712, 16},
    { -584, 696, 40},
    { -608, 680, 64},
    { -672, 728, 80},
    { -720, 728, -64},
    { -656, 808, -176},
    { -664, 912, -304},
    { -632, 992, -216},
    { -640, 944, -304},
    { -728, 936, -304},
    { -672, 728, -336},
    { -520, -56, -336},
    { -352, -200, -808},
    { -320, -152, -952},
    { -248, -208, -1032},
    // 54 seconds
    { -264, -296, -936},
    { -272, -376, -952},
    { -240, -472, -888},
    { -192, -440, -936},
    { -144, -456, -920},
    { -128, -440, -928},
    { -96, -400, -880},
    { -136, -400, -1040},
    { -104, -488, -896},
    { -112, -456, -992},
    { -120, -512, -928},
    { -104, -480, -904},
    { -88, -392, -936},
    { -96, -312, -928},
    { -144, -40, -912},
    { -200, 96, -872},
    { -248, 376, -800},
    { -288, 400, -736},
    { -304, 360, -192},
    { -416, 832, -216},
    { -376, 1048, 104},
    { -400, 1296, 136},
    { -464, 1224, 312},
    { -408, 1176, 504},
    { -424, 1080, 528},
    // 55 seconds
    { -296, 864, 344},
    { -312, 912, 344},
    { -208, 768, 168},
    { -216, 768, 208},
    { -280, 848, 224},
    { -264, 904, 8},
    { -344, 864, 32},
    { -328, 1024, -80},
    { -392, 1072, -104},
    { -336, 928, -40},
    { -392, 992, -128},
    { -368, 880, -136},
    { -352, 1008, -360},
    { -472, 888, -392},
    { -432, 904, -512},
    { -432, 736, -560},
    { -264, 712, -624},
    { -280, 104, -632},
    { -216, -136, -960},
    { -168, -368, -920},
    { -40, -504, -824},
    { -24, -448, -896},
    { -16, -400, -1000},
    { 8, -296, -760},
    { -152, -504, -864},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:05:53 local
AccelRawData *activity_sample_walk_100_pbl_25663_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25663_9
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 60
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 80, -296, -1024},
    { 88, -312, -992},
    { 184, -256, -1056},
    { 32, -280, -1008},
    { -192, -376, -984},
    { -128, -280, -960},
    { -328, -208, -1056},
    { -192, -272, -912},
    { 40, -336, -1024},
    { 8, -304, -1072},
    { -64, -232, -1000},
    { -224, -256, -1008},
    { -168, -296, -1008},
    { -128, -320, -968},
    { -144, -256, -1000},
    { -184, -344, -960},
    { -208, -400, -936},
    { -256, -496, -944},
    { -224, -520, -872},
    { -288, -544, -856},
    { -376, -440, -1000},
    { -336, -248, -944},
    { -536, -800, -96},
    { 400, -232, -952},
    { -232, -424, -944},
    // 1 seconds
    { -272, -8, -976},
    { -328, -48, -992},
    { -352, -168, -976},
    { -256, -376, -960},
    { -184, -416, -960},
    { -160, -440, -976},
    { -176, -384, -704},
    { -168, 528, -536},
    { -280, 640, -536},
    { -336, 984, 56},
    { -360, 960, 96},
    { -280, 1176, 304},
    { -280, 1224, 696},
    { -280, 1008, 672},
    { -232, 848, 576},
    { -256, 696, 584},
    { -232, 680, 720},
    { -176, 664, 664},
    { -168, 600, 600},
    { -224, 616, 520},
    { -240, 536, 480},
    { -240, 560, 464},
    { -288, 600, 496},
    { -304, 680, 480},
    { -344, 864, 648},
    // 2 seconds
    { -304, 968, 792},
    { -304, 1064, 672},
    { -280, 1168, 800},
    { -216, 912, 576},
    { -248, 840, 368},
    { -88, 752, 368},
    { -32, 744, 200},
    { -120, 640, 264},
    { -112, 512, 176},
    { -216, 544, 232},
    { -296, 552, 224},
    { -456, 784, 216},
    { -488, 824, 288},
    { -408, 800, 392},
    { -432, 952, 600},
    { -456, 1112, 720},
    { -464, 1216, 672},
    { -288, 1152, 688},
    { -304, 752, 416},
    { -424, 832, 336},
    { -280, 856, 216},
    { -320, 680, 72},
    { -336, 632, -16},
    { -168, 480, -152},
    { -104, 400, -88},
    // 3 seconds
    { 88, 344, -40},
    { 328, 304, -88},
    { 648, 352, 32},
    { 1128, 368, 96},
    { 1840, 496, 176},
    { 2328, 680, 176},
    { 2512, 704, 96},
    { 1744, 616, 328},
    { 1496, 344, -64},
    { 1224, 472, 72},
    { 1008, 504, 240},
    { 848, 400, 200},
    { 712, 416, 128},
    { 664, 528, 192},
    { 688, 824, 328},
    { 736, 888, 368},
    { 1072, 712, 96},
    { 952, 984, 208},
    { 1248, 896, 160},
    { 1712, 904, 80},
    { 2112, 760, -48},
    { 1872, 576, -128},
    { 1864, 464, -256},
    { 1912, 344, -264},
    { 1744, 344, -320},
    // 4 seconds
    { 1400, 200, -440},
    { 960, -208, -272},
    { 576, -296, -208},
    { 352, -368, -216},
    { 200, -160, -200},
    { 256, 8, -112},
    { 432, 280, 24},
    { 888, 1144, 184},
    { 1184, 1080, -200},
    { 1448, 944, -96},
    { 1544, 928, 160},
    { 1528, 944, 136},
    { 1624, 816, 168},
    { 1360, 1008, 120},
    { 1192, 760, 128},
    { 1016, 1152, 408},
    { 608, 1400, 616},
    { 800, 1008, 480},
    { 920, 1144, 432},
    { 1248, 840, 400},
    { 1624, 744, 368},
    { 2272, 728, 368},
    { 2112, 432, 328},
    { 1808, 312, 168},
    { 1672, 336, 160},
    // 5 seconds
    { 1760, 360, 216},
    { 1776, 232, 216},
    { 1656, 200, 152},
    { 1216, 216, 80},
    { 1016, 328, -192},
    { 576, -48, -432},
    { 352, -72, -320},
    { 240, -288, -480},
    { 648, 200, -424},
    { 904, 416, -360},
    { 1120, 432, -272},
    { 1624, 552, -64},
    { 2000, 752, 72},
    { 2128, 1088, 384},
    { 1936, 352, -176},
    { 1704, 864, 56},
    { 1272, 1152, 496},
    { 1136, 1008, 440},
    { 1168, 1056, 520},
    { 1120, 880, 480},
    { 856, 792, 384},
    { 920, 672, 320},
    { 1288, 600, 208},
    { 1352, 384, 136},
    { 1328, 280, 48},
    // 6 seconds
    { 1536, 160, 40},
    { 1632, 512, -112},
    { 1192, -96, 264},
    { 1248, 392, 16},
    { 1280, 112, 72},
    { 1088, 240, -168},
    { 888, -384, -272},
    { 464, -136, -160},
    { 664, -144, -464},
    { 928, 184, -320},
    { 1304, 376, -400},
    { 1120, 240, -192},
    { 1096, 424, -184},
    { 1192, 512, -64},
    { 1424, 600, -16},
    { 1280, 720, -24},
    { 1040, 824, -88},
    { 840, 1192, 72},
    { 928, 952, 64},
    { 1208, 1048, 96},
    { 992, 720, 56},
    { 1056, 704, 48},
    { 1264, 648, 96},
    { 1360, 424, 8},
    { 1176, 368, -104},
    // 7 seconds
    { 1144, 336, -56},
    { 1232, 224, 8},
    { 1120, 200, -48},
    { 1080, 200, 0},
    { 920, 152, 8},
    { 808, 176, -88},
    { 656, 208, -160},
    { 960, 272, -240},
    { 992, 328, -368},
    { 800, 448, -544},
    { 992, 744, -624},
    { 1160, 480, -352},
    { 960, 496, -320},
    { 744, 488, -304},
    { 728, 520, -200},
    { 848, 488, -112},
    { 968, 456, -72},
    { 1032, 456, -16},
    { 952, 456, -8},
    { 912, 464, 0},
    { 864, 440, 0},
    { 800, 488, -64},
    { 680, 592, -104},
    { 712, 656, -112},
    { 896, 744, -48},
    // 8 seconds
    { 1016, 760, 0},
    { 1144, 728, 16},
    { 1184, 728, 24},
    { 1024, 576, 0},
    { 1064, 560, 0},
    { 1376, 544, 24},
    { 1376, 328, -8},
    { 1104, 272, -8},
    { 1016, 168, -16},
    { 936, 216, -64},
    { 816, 200, -64},
    { 792, 224, -80},
    { 768, 160, -72},
    { 848, 160, -88},
    { 1000, 216, -152},
    { 976, 200, -336},
    { 920, 168, -304},
    { 904, 72, -568},
    { 1104, 80, -608},
    { 1272, 160, -496},
    { 1008, 128, -360},
    { 784, 312, -296},
    { 816, 328, -256},
    { 912, 336, -344},
    { 904, 432, -400},
    // 9 seconds
    { 960, 688, -448},
    { 976, 976, -440},
    { 976, 776, -432},
    { 1144, 1000, -552},
    { 1048, 720, -416},
    { 1184, 720, -288},
    { 1496, 488, -264},
    { 1168, 304, -256},
    { 1080, 248, -208},
    { 1296, 240, -128},
    { 1192, 168, -256},
    { 968, 8, -168},
    { 1072, 136, -176},
    { 1112, 72, -232},
    { 816, -160, -136},
    { 1104, -48, -216},
    { 656, -168, -448},
    { 1216, 136, -512},
    { 1392, 104, -392},
    { 1040, 96, -256},
    { 912, 176, -272},
    { 976, 400, -152},
    { 1088, 488, -240},
    { 1320, 600, -272},
    { 1288, 728, -352},
    // 10 seconds
    { 968, 856, -384},
    { 968, 1136, -520},
    { 872, 792, -432},
    { 928, 944, -456},
    { 1064, 888, -328},
    { 1464, 736, -208},
    { 1680, 608, -192},
    { 1352, 320, -176},
    { 1256, 272, -160},
    { 1320, 248, -120},
    { 1248, 288, -128},
    { 1320, 208, -144},
    { 1160, 152, -80},
    { 896, -248, -40},
    { 448, -352, -296},
    { 1400, -456, 0},
    { 1384, -160, -264},
    { 1368, 72, -392},
    { 1448, 248, -416},
    { 1192, 232, -272},
    { 1064, 288, -264},
    { 1232, 424, -256},
    { 1432, 576, -312},
    { 1552, 672, -448},
    { 1512, 1128, -584},
    // 11 seconds
    { 1120, 1344, -624},
    { 720, 1384, -744},
    { 1056, 1112, -360},
    { 1184, 912, -264},
    { 1304, 648, -208},
    { 1632, 632, -264},
    { 1440, 384, -192},
    { 1288, 304, -160},
    { 1328, 296, -136},
    { 1408, 240, -144},
    { 1408, 272, -120},
    { 1296, 200, -64},
    { 1168, 168, -80},
    { 768, -264, 80},
    { 544, -200, 152},
    { 800, -32, -480},
    { 1112, -40, -192},
    { 1656, 328, -496},
    { 1368, 160, -440},
    { 1280, 264, -424},
    { 1152, 456, -392},
    { 1288, 568, -336},
    { 1552, 632, -296},
    { 1392, 720, -304},
    { 1224, 872, -280},
    // 12 seconds
    { 1008, 1008, -184},
    { 1144, 1240, -224},
    { 1168, 960, -200},
    { 1320, 800, -232},
    { 1440, 712, -248},
    { 1360, 552, -128},
    { 1248, 216, 120},
    { 640, 840, -352},
    { 424, -1072, 480},
    { 1720, 1032, -128},
    { 1192, -192, 256},
    { 1080, 232, 24},
    { 944, 24, -192},
    { 952, -112, 240},
    { 912, 80, -384},
    { 984, -48, -632},
    { 1080, -72, -304},
    { 1048, 136, -400},
    { 976, 192, -384},
    { 1064, 280, -248},
    { 1240, 536, -248},
    { 1552, 880, -312},
    { 1488, 1008, -216},
    { 1160, 1184, -400},
    { 600, 1416, -288},
    // 13 seconds
    { 1128, 1192, -104},
    { 1144, 848, -80},
    { 1480, 776, -8},
    { 1752, 648, 24},
    { 1320, 432, -32},
    { 1072, 240, -80},
    { 1064, 232, -96},
    { 1216, 224, -32},
    { 1328, 160, -104},
    { 1112, 88, -168},
    { 1040, 96, -232},
    { 544, -352, -80},
    { 712, -264, -24},
    { 888, 0, -552},
    { 1088, 32, -296},
    { 1672, 352, -464},
    { 1296, 216, -296},
    { 1168, 376, -248},
    { 1304, 472, -232},
    { 1560, 632, -192},
    { 1600, 904, -184},
    { 1048, 1096, -264},
    { 736, 1264, -296},
    { 1128, 1208, -88},
    { 1208, 888, -40},
    // 14 seconds
    { 1224, 744, -40},
    { 1400, 672, -40},
    { 1184, 408, -80},
    { 960, 280, -128},
    { 904, 80, 80},
    { 976, 216, -64},
    { 1144, 296, -128},
    { 1656, 264, -192},
    { 1680, 160, -232},
    { 1000, -424, -152},
    { 664, -368, -192},
    { 768, -240, -328},
    { 912, -80, -400},
    { 1176, 88, -184},
    { 1168, 256, -344},
    { 1024, 216, -312},
    { 1072, 360, -216},
    { 1320, 488, -264},
    { 1376, 784, -264},
    { 1192, 1000, -328},
    { 912, 1248, -472},
    { 824, 1040, -272},
    { 1216, 1104, -184},
    { 1216, 712, -96},
    { 1256, 672, -80},
    // 15 seconds
    { 1376, 600, -40},
    { 1264, 384, -64},
    { 1128, 224, -72},
    { 1088, 248, -72},
    { 1272, 176, -96},
    { 1272, 136, -72},
    { 1168, 232, -104},
    { 1240, 128, -176},
    { 624, -496, 16},
    { 760, -256, -144},
    { 920, -176, -288},
    { 1192, 96, -328},
    { 1504, 200, -392},
    { 1312, 192, -320},
    { 1168, 200, -304},
    { 1152, 384, -224},
    { 1312, 464, -280},
    { 1264, 720, -240},
    { 1168, 808, -352},
    { 976, 1040, -416},
    { 944, 976, -304},
    { 1104, 1120, -280},
    { 1080, 784, -128},
    { 1296, 792, -184},
    { 1496, 656, -176},
    // 16 seconds
    { 1376, 408, -184},
    { 1208, 296, -336},
    { 1080, 136, -112},
    { 1248, 176, -152},
    { 1152, 216, -104},
    { 1248, 192, -120},
    { 1112, 120, -112},
    { 944, 112, -144},
    { 688, -240, 0},
    { 648, -128, -120},
    { 952, 0, -456},
    { 1128, 0, -160},
    { 1424, 328, -424},
    { 1120, 120, -312},
    { 1096, 288, -264},
    { 1320, 416, -240},
    { 1584, 592, -312},
    { 1392, 808, -264},
    { 1096, 848, -456},
    { 912, 1096, -416},
    { 944, 1024, -256},
    { 1184, 992, -216},
    { 1152, 800, -168},
    { 1288, 712, -160},
    { 1440, 608, -152},
    // 17 seconds
    { 1304, 304, -144},
    { 1152, 240, -144},
    { 1144, 568, -56},
    { 1272, 328, -112},
    { 1248, 168, -96},
    { 1264, 176, -64},
    { 1160, 120, -80},
    { 984, -160, 8},
    { 704, -184, 152},
    { 944, -184, -472},
    { 1184, -24, -256},
    { 1408, 176, -280},
    { 1136, 200, -328},
    { 1032, 264, -296},
    { 1184, 424, -248},
    { 1376, 568, -184},
    { 1504, 936, -160},
    { 1400, 872, -296},
    { 1000, 1072, -408},
    { 792, 1248, -312},
    { 1184, 1248, -216},
    { 1136, 760, -184},
    { 1328, 816, -152},
    { 1656, 712, -64},
    { 1632, 448, -56},
    // 18 seconds
    { 1240, 208, -136},
    { 1136, 304, -80},
    { 1192, 168, -88},
    { 1224, 240, -120},
    { 1296, 152, -72},
    { 1264, 104, -80},
    { 800, -480, 136},
    { 736, -176, -144},
    { 776, -384, -208},
    { 1072, 72, -296},
    { 1512, 144, -280},
    { 1496, 320, -264},
    { 1432, 256, -200},
    { 1352, 496, -224},
    { 1344, 608, -152},
    { 1576, 704, -184},
    { 1424, 864, -200},
    { 1056, 1288, -232},
    { 808, 1504, -336},
    { 992, 1480, -264},
    { 1152, 888, -144},
    { 1168, 880, -128},
    { 1624, 696, -64},
    { 1976, 552, -88},
    { 1560, 496, -408},
    // 19 seconds
    { 1352, -32, 96},
    { 1296, 264, -200},
    { 1200, 272, -152},
    { 1328, 208, -168},
    { 1112, 176, -224},
    { 1032, 48, -320},
    { 616, -480, -264},
    { 760, -448, -272},
    { 744, -104, -512},
    { 1016, -8, -272},
    { 1504, 352, -464},
    { 1400, 248, -168},
    { 1560, 520, -160},
    { 1640, 712, -88},
    { 1664, 808, 32},
    { 1584, 776, -48},
    { 1096, 1416, 88},
    { 752, 1592, -120},
    { 872, 1784, -88},
    { 1280, 1088, 48},
    { 1216, 872, -8},
    { 1472, 744, 16},
    { 1800, 552, -16},
    { 1512, 392, -48},
    { 1400, 232, -112},
    // 20 seconds
    { 1392, 280, -16},
    { 1400, 352, -24},
    { 1368, 376, -216},
    { 1264, 360, -112},
    { 1096, 392, -112},
    { 640, 384, -288},
    { 536, 456, -304},
    { 136, 264, -344},
    { 312, 248, -424},
    { 448, 320, -464},
    { 400, 256, -352},
    { 400, 304, -256},
    { 536, 496, -80},
    { 944, 1016, -40},
    { 1312, 1416, -24},
    { 1240, 1712, 80},
    { 896, 1688, 168},
    { 496, 1776, 128},
    { 560, 1824, 176},
    { 640, 1384, 216},
    { 600, 1296, 152},
    { 792, 1208, 96},
    { 864, 952, 16},
    { 704, 784, -40},
    { 624, 728, -8},
    // 21 seconds
    { 648, 632, -88},
    { 720, 520, -56},
    { 864, 568, -120},
    { 1032, 216, -88},
    { 776, -72, -32},
    { 760, -24, -272},
    { 784, -48, -136},
    { 1056, 328, -448},
    { 1552, 352, -280},
    { 2008, 384, -328},
    { 1896, 464, -296},
    { 1496, 880, -184},
    { 1424, 408, -192},
    { 1456, 784, -120},
    { 1088, 1016, 24},
    { 600, 1424, -24},
    { 776, 1000, -48},
    { 1064, 1200, 136},
    { 1248, 880, 264},
    { 1584, 896, 224},
    { 1856, 680, 128},
    { 1776, 472, 16},
    { 1752, -40, 72},
    { 1440, 288, -72},
    { 1416, 240, -80},
    // 22 seconds
    { 1296, 224, -136},
    { 1248, 128, -96},
    { 1208, 192, -152},
    { 952, -120, -56},
    { 456, -648, 40},
    { 704, -216, -240},
    { 1016, 8, -472},
    { 1208, 120, -120},
    { 1640, 432, -488},
    { 1472, 184, -208},
    { 1424, 544, -248},
    { 1320, 664, -192},
    { 1656, 472, -104},
    { 1680, 968, -8},
    { 1280, 1376, -96},
    { 840, 1224, -200},
    { 840, 1264, -224},
    { 928, 1240, -16},
    { 1328, 920, -80},
    { 1608, 744, -56},
    { 1768, 664, -104},
    { 1520, 392, 8},
    { 1344, 240, -24},
    { 1344, 192, -56},
    { 1312, 152, -72},
    // 23 seconds
    { 1304, 176, 0},
    { 1256, 136, 16},
    { 1144, 112, 0},
    { 880, 80, -144},
    { 584, -392, 112},
    { 424, 24, -320},
    { 1080, -40, -408},
    { 1344, 256, -352},
    { 1408, 232, -384},
    { 1408, 264, -176},
    { 1376, 528, -160},
    { 1536, 600, -200},
    { 1504, 920, -232},
    { 1328, 832, -360},
    { 1008, 944, -496},
    { 776, 1232, -584},
    { 1048, 1200, -464},
    { 1136, 928, -296},
    { 1344, 800, -248},
    { 1608, 728, -168},
    { 1720, 536, -136},
    { 1440, 328, -104},
    { 1344, 328, -64},
    { 1272, 144, -112},
    { 1320, 264, -40},
    // 24 seconds
    { 1160, 160, -32},
    { 1000, 112, -32},
    { 880, 144, -72},
    { 640, -184, -56},
    { 584, -128, 16},
    { 744, -8, -424},
    { 928, 8, -224},
    { 1472, 328, -496},
    { 1240, 128, -400},
    { 1200, 200, -184},
    { 1328, 424, -256},
    { 1608, 632, -272},
    { 1696, 888, -296},
    { 1328, 944, -344},
    { 928, 1160, -512},
    { 768, 1168, -424},
    { 976, 1320, -376},
    { 1136, 752, -208},
    { 1376, 800, -184},
    { 1680, 608, -128},
    { 1480, 424, -96},
    { 1328, 8, 16},
    { 1144, 288, -136},
    { 1176, 24, -72},
    { 1152, 304, -152},
    // 25 seconds
    { 1248, 160, -96},
    { 1120, 176, -144},
    { 888, 48, -288},
    { 656, -312, 8},
    { 504, -160, -216},
    { 856, -16, -440},
    { 1008, 64, -336},
    { 1400, 320, -488},
    { 1200, 144, -240},
    { 1280, 376, -280},
    { 1448, 544, -240},
    { 1608, 792, -184},
    { 1360, 952, -240},
    { 680, 1416, -344},
    { 800, 1256, -216},
    { 1200, 1144, -40},
    { 1272, 816, 24},
    { 1208, 712, 24},
    { 1384, 640, 32},
    { 1456, 408, 8},
    { 1200, 160, -24},
    { 1008, 184, -104},
    { 1008, 280, -80},
    { 1064, 144, -64},
    { 1040, 216, -112},
    // 26 seconds
    { 1056, 128, -136},
    { 1072, 112, -208},
    { 792, -72, -192},
    { 688, -40, -152},
    { 608, 72, -392},
    { 1016, 192, -296},
    { 1400, 376, -432},
    { 1296, 256, -296},
    { 1096, 400, -240},
    { 1080, 392, -96},
    { 1312, 544, -160},
    { 1384, 632, -56},
    { 1088, 840, -96},
    { 904, 1104, -96},
    { 960, 880, 0},
    { 1224, 888, 8},
    { 1072, 776, 32},
    { 1144, 696, 72},
    { 1176, 536, 40},
    { 1120, 368, -64},
    { 1024, 312, -80},
    { 1128, 232, 40},
    { 1072, 280, -152},
    { 1176, 104, -72},
    { 1112, 280, -88},
    // 27 seconds
    { 1136, 144, -88},
    { 1104, 144, -104},
    { 1144, 208, -152},
    { 912, -8, -56},
    { 472, 88, -376},
    { 976, 72, -328},
    { 1240, 248, -384},
    { 912, 168, -328},
    { 744, 312, -288},
    { 904, 312, -152},
    { 1184, 432, -184},
    { 1528, 656, -168},
    { 1256, 936, -96},
    { 1096, 624, -384},
    { 1200, 1008, -72},
    { 1208, 1048, 48},
    { 928, 760, -32},
    { 992, 696, 8},
    { 1264, 632, 56},
    { 1240, 344, -16},
    { 1072, 216, -48},
    { 1008, 192, -40},
    { 1104, 280, -80},
    { 1272, 192, -72},
    { 1408, 168, -32},
    // 28 seconds
    { 1352, 88, -160},
    { 992, -312, -240},
    { 976, -96, -208},
    { 816, -136, -208},
    { 968, 256, -424},
    { 1280, 424, -312},
    { 1184, 304, -184},
    { 1056, 360, -104},
    { 1080, 432, -24},
    { 1288, 528, -8},
    { 1368, 808, 72},
    { 1288, 1072, 144},
    { 1016, 1096, -40},
    { 784, 1200, 0},
    { 1024, 1352, 96},
    { 1144, 760, 72},
    { 1344, 752, 16},
    { 1736, 704, 56},
    { 1736, 408, 88},
    { 1368, 248, 8},
    { 1264, 232, 16},
    { 1208, 184, 0},
    { 1344, 256, -56},
    { 1464, 120, 128},
    { 1304, 120, 40},
    // 29 seconds
    { 1072, 72, -216},
    { 608, -152, -88},
    { 600, -272, -176},
    { 504, 24, -344},
    { 864, 144, -296},
    { 1176, 352, -448},
    { 1376, 232, -264},
    { 1312, 440, -176},
    { 1320, 568, -104},
    { 1456, 824, -136},
    { 1408, 728, -64},
    { 1184, 864, 24},
    { 968, 1184, 8},
    { 1128, 968, 72},
    { 1264, 1096, 136},
    { 960, 808, 152},
    { 1008, 720, 120},
    { 1312, 656, 88},
    { 1432, 384, 56},
    { 1264, 240, 88},
    { 1096, 304, -40},
    { 1104, 200, -32},
    { 1144, 256, -64},
    { 1368, 184, -48},
    { 1392, 120, -56},
    // 30 seconds
    { 1032, -72, -224},
    { 928, -128, -96},
    { 512, -264, -408},
    { 1016, 96, -448},
    { 1488, 168, -296},
    { 1216, 192, -296},
    { 920, 232, -232},
    { 888, 352, -184},
    { 1048, 320, -64},
    { 1384, 472, -56},
    { 1744, 704, -48},
    { 1408, 1264, 64},
    { 1472, 792, -200},
    { 920, 1344, 88},
    { 912, 1184, 128},
    { 752, 896, 8},
    { 960, 784, 72},
    { 1440, 672, 72},
    { 1360, 352, 0},
    { 1184, 216, -56},
    { 1192, 264, -64},
    { 1352, 304, -16},
    { 1488, 184, -40},
    { 1320, 96, 0},
    { 1328, 224, -72},
    // 31 seconds
    { 928, -312, -88},
    { 1056, -184, -16},
    { 640, -192, -344},
    { 1136, 64, -384},
    { 1360, 208, -296},
    { 1128, 152, -216},
    { 1016, 272, -248},
    { 1040, 384, -192},
    { 1232, 432, -112},
    { 1360, 584, -120},
    { 1384, 912, -56},
    { 1192, 712, -272},
    { 944, 1008, -104},
    { 912, 1168, -24},
    { 1184, 856, -64},
    { 1184, 744, -80},
    { 1280, 680, -48},
    { 1256, 496, -88},
    { 1152, 280, -112},
    { 1144, 144, -112},
    { 1144, 96, -96},
    { 1280, 192, -88},
    { 1232, 128, -120},
    { 1256, 192, -136},
    { 1224, 200, -176},
    // 32 seconds
    { 984, -128, -176},
    { 560, -184, 56},
    { 792, -64, -440},
    { 984, 48, -312},
    { 1360, 248, -480},
    { 1024, 88, -304},
    { 976, 256, -272},
    { 1024, 368, -232},
    { 1216, 584, -264},
    { 1272, 728, -224},
    { 1072, 760, -288},
    { 864, 1008, -304},
    { 952, 960, -200},
    { 1336, 1024, -144},
    { 1360, 744, -64},
    { 1288, 672, -120},
    { 1232, 552, -88},
    { 920, 320, -104},
    { 776, 232, -144},
    { 864, 160, -88},
    { 1032, 264, -112},
    { 1336, 184, -104},
    { 1352, 128, -64},
    { 1192, 160, -104},
    { 1064, -32, -184},
    // 33 seconds
    { 792, -200, 16},
    { 736, -112, -280},
    { 984, 0, -256},
    { 1568, 352, -456},
    { 1112, 176, -304},
    { 960, 256, -336},
    { 896, 344, -248},
    { 1040, 440, -240},
    { 1208, 568, -200},
    { 1320, 944, -208},
    { 928, 984, -200},
    { 888, 864, -216},
    { 928, 1128, -56},
    { 1080, 776, 32},
    { 1264, 696, -32},
    { 1480, 632, 0},
    { 1488, 424, -144},
    { 1128, 0, -64},
    { 1040, -40, 8},
    { 1096, 120, -80},
    { 1200, 208, -128},
    { 1256, 200, -176},
    { 1152, 120, -152},
    { 1056, 24, -168},
    { 848, -256, 24},
    // 34 seconds
    { 664, -88, -168},
    { 912, 88, -392},
    { 1416, 192, -312},
    { 1296, 304, -408},
    { 992, 160, -296},
    { 968, 344, -272},
    { 1064, 424, -216},
    { 1208, 672, -256},
    { 1248, 928, -272},
    { 832, 1136, -312},
    { 872, 960, -320},
    { 992, 888, -176},
    { 1232, 912, -144},
    { 1112, 712, -80},
    { 1320, 584, -88},
    { 1632, 376, -24},
    { 1368, 312, -264},
    { 1032, 96, -200},
    { 952, 240, -168},
    { 1088, 136, -152},
    { 1208, 144, -192},
    { 1096, 56, -120},
    { 888, -88, -16},
    { 584, -224, -64},
    { 984, -16, -64},
    // 35 seconds
    { 768, -8, -184},
    { 1216, 120, -288},
    { 1608, 344, -480},
    { 1304, 192, -280},
    { 1128, 208, -296},
    { 1128, 416, -280},
    { 1264, 600, -288},
    { 1248, 792, -376},
    { 1088, 928, -472},
    { 752, 1120, -584},
    { 912, 872, -440},
    { 1296, 1056, -336},
    { 1256, 704, -216},
    { 1536, 496, -136},
    { 1424, 728, 680},
    { 1552, -16, -56},
    { 1104, 272, -176},
    { 1032, 104, -112},
    { 1152, 168, -104},
    { 1256, 200, -104},
    { 1320, 152, -88},
    { 1272, 32, -64},
    { 632, -472, -32},
    { 960, -112, -32},
    { 976, -32, -344},
    // 36 seconds
    { 1304, -24, -128},
    { 1544, 376, -488},
    { 1136, 128, -280},
    { 1008, 208, -280},
    { 1056, 336, -232},
    { 1304, 592, -384},
    { 1456, 888, -400},
    { 1320, 1152, -472},
    { 1104, 1064, -480},
    { 1016, 928, -344},
    { 1088, 856, -240},
    { 1056, 624, -184},
    { 1192, 504, -104},
    { 1312, 272, -88},
    { 1272, -64, -40},
    { 1056, 168, -128},
    { 1032, 264, -40},
    { 1176, 248, -128},
    { 1176, 112, -72},
    { 1024, 96, -80},
    { 864, 112, -120},
    { 720, -160, -120},
    { 256, -320, -256},
    { 984, -160, -376},
    { 1088, -112, -304},
    // 37 seconds
    { 1336, 56, -360},
    { 1848, 368, -552},
    { 1496, 208, -224},
    { 1288, 336, -248},
    { 1216, 456, -248},
    { 1232, 544, -200},
    { 1112, 696, -288},
    { 1056, 880, -232},
    { 688, 1528, -312},
    { 864, 984, -376},
    { 1200, 1320, -328},
    { 1280, 808, -112},
    { 1680, 816, -88},
    { 1832, 560, -96},
    { 1656, 200, -56},
    { 1416, 272, -152},
    { 1360, 224, -104},
    { 1488, 264, -168},
    { 1616, 160, -144},
    { 1416, 40, -88},
    { 1376, 32, -176},
    { 536, -816, -128},
    { 920, -376, -128},
    { 864, -312, -208},
    { 1232, -40, -192},
    // 38 seconds
    { 1376, 56, -128},
    { 1296, 248, -232},
    { 1464, 336, -184},
    { 1704, 496, -136},
    { 1856, 800, -160},
    { 1776, 760, -32},
    { 1504, 1168, -160},
    { 912, 1328, -176},
    { 824, 1096, -224},
    { 1080, 1304, -176},
    { 1152, 752, -160},
    { 1264, 840, -168},
    { 1528, 696, -80},
    { 1632, 320, -32},
    { 1384, 8, -400},
    { 1344, 456, 64},
    { 1520, -328, -88},
    { 1088, 296, 344},
    { 1304, -248, 584},
    { 1248, 384, -80},
    { 1072, -16, 16},
    { 592, -360, -64},
    { 856, -40, -88},
    { 736, 48, -288},
    { 1160, 0, -216},
    // 39 seconds
    { 1472, 296, -432},
    { 1112, 208, -328},
    { 1112, 184, -272},
    { 1232, 392, -248},
    { 1488, 608, -352},
    { 1440, 976, -520},
    { 848, 1424, -800},
    { 800, 1264, -800},
    { 1088, 1144, -576},
    { 1504, 824, -288},
    { 1272, 576, -208},
    { 1512, 608, -120},
    { 1696, 456, 8},
    { 1456, 256, 16},
    { 1248, 88, -72},
    { 1096, 232, -48},
    { 1224, 200, -56},
    { 1248, 152, -104},
    { 1208, 136, -216},
    { 1008, -368, -128},
    { 728, -400, -88},
    { 864, -504, -480},
    { 1120, 0, -616},
    { 1432, -96, -288},
    { 1520, 240, -472},
    // 40 seconds
    { 1352, 152, -224},
    { 1368, 424, -192},
    { 1592, 528, -112},
    { 1600, 1000, -72},
    { 1608, 656, -136},
    { 1168, 1120, -144},
    { 736, 1576, -192},
    { 1040, 1112, -200},
    { 1008, 1000, -168},
    { 984, 760, -168},
    { 1232, 712, -72},
    { 1640, 576, -24},
    { 1520, 264, -40},
    { 1304, 176, -80},
    { 1304, 248, -80},
    { 1376, 144, -40},
    { 1424, 240, -80},
    { 1408, 144, -192},
    { 1240, 176, -384},
    { 624, -416, -288},
    { 744, -480, -160},
    { 664, -288, -376},
    { 1144, -48, -336},
    { 1568, 304, -416},
    { 1384, 184, -224},
    // 41 seconds
    { 1344, 424, -248},
    { 1224, 520, -104},
    { 1360, 512, -88},
    { 1552, 752, -96},
    { 1472, 960, -48},
    { 920, 1536, -56},
    { 848, 1256, -248},
    { 1152, 1424, -176},
    { 1304, 1064, -112},
    { 1696, 848, -200},
    { 1720, 600, -144},
    { 1384, 360, -88},
    { 1192, 56, 16},
    { 1112, 240, -40},
    { 1216, 176, -64},
    { 1416, 264, -48},
    { 1576, 104, -8},
    { 1128, 32, -88},
    { 808, -240, -272},
    { 424, -304, -280},
    { 640, -432, -232},
    { 1120, 88, -584},
    { 1320, -8, -320},
    { 1608, 264, -312},
    { 1408, 152, -200},
    // 42 seconds
    { 1456, 416, -216},
    { 1664, 560, -192},
    { 1736, 864, -184},
    { 1568, 1008, -328},
    { 1184, 1328, -496},
    { 808, 1544, -560},
    { 1008, 1456, -352},
    { 1088, 888, -208},
    { 1360, 776, -240},
    { 1648, 704, -104},
    { 1736, 496, -72},
    { 1456, 240, -48},
    { 1232, -160, 184},
    { 904, 224, -72},
    { 1408, 176, -32},
    { 1688, 152, -8},
    { 1248, 80, -32},
    { 1144, -24, -120},
    { 368, -536, -8},
    { 776, -248, -336},
    { 712, -152, -440},
    { 1192, -168, -104},
    { 1576, 288, -408},
    { 1248, 56, -240},
    { 1256, 288, -208},
    // 43 seconds
    { 1360, 400, -184},
    { 1464, 560, -168},
    { 1536, 728, -208},
    { 1464, 1024, -408},
    { 896, 1568, -520},
    { 960, 1096, -560},
    { 1136, 1456, -376},
    { 1168, 800, -144},
    { 1344, 720, -200},
    { 1464, 640, -72},
    { 1648, 496, -32},
    { 1424, 240, -40},
    { 1264, 208, -56},
    { 1216, 248, -56},
    { 1184, 192, -32},
    { 1264, 192, -72},
    { 1280, 120, -56},
    { 1080, 64, -160},
    { 536, -552, -32},
    { 784, -120, -240},
    { 608, -96, -336},
    { 1128, 128, -360},
    { 1608, 160, -312},
    { 1536, 296, -280},
    { 1320, 192, -176},
    // 44 seconds
    { 1248, 472, -216},
    { 1384, 472, -112},
    { 1616, 680, -48},
    { 1496, 864, 40},
    { 1144, 1160, -32},
    { 992, 1048, -48},
    { 1104, 1144, 16},
    { 816, 856, 8},
    { 1088, 784, -40},
    { 1384, 776, -16},
    { 1472, 480, -64},
    { 1248, 312, -96},
    { 1248, 304, -80},
    { 1368, 336, -32},
    { 1472, 272, -40},
    { 1648, 224, -56},
    { 1384, 56, 56},
    { 1312, 160, -72},
    { 904, -568, -104},
    { 400, -224, 8},
    { 704, -288, -472},
    { 856, -120, -248},
    { 1304, 320, -432},
    { 968, 24, -264},
    { 1016, 192, -208},
    // 45 seconds
    { 1112, 296, -176},
    { 1352, 376, -144},
    { 1600, 568, -184},
    { 1536, 960, -240},
    { 1136, 1416, -240},
    { 1008, 1264, -272},
    { 1208, 1208, -192},
    { 904, 984, -184},
    { 1032, 824, -168},
    { 1272, 704, -144},
    { 1088, 424, -120},
    { 1040, 304, -104},
    { 1200, 280, -120},
    { 1544, 192, -48},
    { 1744, 224, 72},
    { 1656, 176, -72},
    { 1536, -224, -80},
    { 752, -432, -136},
    { 560, -320, -240},
    { 744, -440, -96},
    { 856, 208, -576},
    { 1208, 280, -632},
    { 1576, 288, -392},
    { 1504, 280, -400},
    { 1288, 784, -248},
    // 46 seconds
    { 1024, 640, -176},
    { 1224, 592, -248},
    { 896, 1192, 0},
    { 648, 1256, 128},
    { 920, 928, 0},
    { 968, 1008, 96},
    { 1368, 888, 240},
    { 1408, 616, 168},
    { 1504, 576, 144},
    { 1728, 488, 104},
    { 1528, 280, 88},
    { 1312, 208, 16},
    { 1384, 176, 8},
    { 1384, 144, -8},
    { 1336, 232, -72},
    { 1248, 208, -184},
    { 904, -160, -160},
    { 368, -320, -224},
    { 448, -168, -264},
    { 672, 80, -288},
    { 776, 216, -352},
    { 1656, 456, -480},
    { 2160, 448, -320},
    { 1608, 816, -312},
    { 968, 384, -136},
    // 47 seconds
    { 1432, 456, -256},
    { 1032, 920, -40},
    { 720, 888, 16},
    { 560, 1120, 16},
    { 736, 880, 40},
    { 1024, 1000, 160},
    { 1184, 816, 232},
    { 1632, 848, 224},
    { 1520, 560, 160},
    { 1480, 560, 168},
    { 1896, 496, 184},
    { 1488, 216, 128},
    { 1232, 184, 24},
    { 1280, 224, -8},
    { 1288, 208, 80},
    { 1248, 192, 80},
    { 1192, 168, -8},
    { 1104, 200, -96},
    { 800, -24, -248},
    { 400, -160, -272},
    { 448, -216, -312},
    { 592, 56, -464},
    { 1000, 128, -432},
    { 1784, 336, -664},
    { 1768, 216, -520},
    // 48 seconds
    { 1376, 408, -504},
    { 1176, 456, -312},
    { 1496, 624, -392},
    { 1224, 928, -304},
    { 720, 1336, -392},
    { 592, 1112, -440},
    { 976, 1080, -320},
    { 1232, 944, -176},
    { 1584, 832, -56},
    { 1432, 608, -80},
    { 1568, 592, -56},
    { 1928, 440, 16},
    { 1488, 264, 80},
    { 1216, 104, -24},
    { 1104, 192, 8},
    { 1176, 216, -8},
    { 1144, 152, 24},
    { 1096, 144, -64},
    { 1000, 160, -160},
    { 584, -424, -168},
    { 376, -160, -312},
    { 648, -336, -184},
    { 888, 192, -368},
    { 1168, 192, -400},
    { 1560, 416, -400},
    // 49 seconds
    { 1600, 280, -200},
    { 1440, 600, -216},
    { 1352, 552, -152},
    { 1520, 688, -304},
    { 1240, 1440, -56},
    { 648, 1720, -256},
    { 992, 928, -264},
    { 1056, 1312, -216},
    { 1272, 904, 64},
    { 1528, 752, 8},
    { 1792, 648, 48},
    { 1560, 424, -280},
    { 1200, 80, 136},
    { 1248, 88, 88},
    { 1328, 208, -56},
    { 1392, 208, -40},
    { 1192, 152, -32},
    { 1152, 104, -144},
    { 888, -8, -264},
    { 520, -416, -24},
    { 648, -248, -240},
    { 824, 80, -472},
    { 1064, 16, -160},
    { 1520, 400, -384},
    { 1192, 136, -152},
    // 50 seconds
    { 1272, 344, -232},
    { 1264, 480, -320},
    { 1360, 792, -312},
    { 1328, 1056, -368},
    { 856, 1456, -544},
    { 744, 1240, -472},
    { 928, 1144, -312},
    { 1480, 1032, -96},
    { 1320, 624, -72},
    { 1456, 584, -80},
    { 1584, 480, -40},
    { 1392, 320, 0},
    { 1136, 136, -40},
    { 952, 160, -88},
    { 960, 168, -112},
    { 1128, 232, -136},
    { 1264, 192, -112},
    { 1208, 48, -208},
    { 864, -312, -216},
    { 624, -160, -160},
    { 632, -208, -400},
    { 976, 80, -360},
    { 1296, 160, -304},
    { 1384, 312, -272},
    { 1248, 160, -136},
    // 51 seconds
    { 1240, 472, -208},
    { 1240, 528, -168},
    { 1416, 576, -144},
    { 1336, 648, -136},
    { 1168, 800, -216},
    { 960, 1040, -328},
    { 1104, 1096, -272},
    { 1160, 816, -256},
    { 1080, 736, -344},
    { 1160, 688, -296},
    { 1392, 568, -240},
    { 1432, 296, -136},
    { 1520, 240, 56},
    { 1648, 232, 280},
    { 1592, 280, 240},
    { 1320, 264, 472},
    { 1120, 280, 592},
    { 808, 184, 576},
    { 544, 328, 544},
    { 368, 408, 432},
    { 104, 568, 272},
    { -96, 856, 352},
    { -72, 1192, 432},
    { 48, 1296, 328},
    { 128, 1200, 472},
    // 52 seconds
    { 72, 968, 440},
    { -48, 888, 224},
    { -136, 432, 576},
    { -272, 680, 456},
    { -328, 528, 448},
    { -448, 664, 512},
    { -424, 840, 560},
    { -376, 792, 408},
    { -288, 816, 376},
    { -328, 952, 400},
    { -288, 792, 200},
    { -336, 808, 112},
    { -432, 848, 40},
    { -472, 680, 64},
    { -560, 872, 48},
    { -552, 864, -8},
    { -440, 792, 0},
    { -520, 1008, -8},
    { -400, 864, -160},
    { -432, 808, -240},
    { -536, 792, -536},
    { -808, 744, -776},
    { -872, 880, -576},
    { -584, 136, -264},
    { -320, 272, -840},
    // 53 seconds
    { -176, 184, -1064},
    { -136, -424, -728},
    { 32, -464, -832},
    { -120, -432, -1032},
    { -64, -336, -1064},
    { -72, -368, -976},
    { -32, -448, -920},
    { -56, -512, -896},
    { -56, -424, -944},
    { -56, -456, -960},
    { -104, -408, -936},
    { -152, -496, -912},
    { -184, -472, -904},
    { -200, -488, -904},
    { -152, -504, -912},
    { -104, -464, -944},
    { -120, -456, -968},
    { -160, -416, -968},
    { -168, -440, -944},
    { -176, -424, -944},
    { -88, -616, -880},
    { 96, -720, -688},
    { 152, 24, -240},
    { -216, 992, -520},
    { -336, 904, -96},
    // 54 seconds
    { -544, 1608, 192},
    { -504, 1080, -304},
    { -528, 928, -280},
    { -504, 1048, -144},
    { -448, 832, -216},
    { -440, 760, -128},
    { -432, 856, -248},
    { -440, 816, -232},
    { -416, 760, -280},
    { -400, 872, -384},
    { -400, 832, -208},
    { -424, 888, -232},
    { -440, 848, -272},
    { -472, 808, -224},
    { -472, 792, -288},
    { -504, 840, -248},
    { -464, 800, -280},
    { -456, 904, -328},
    { -480, 832, -224},
    { -456, 816, -240},
    { -440, 808, -296},
    { -456, 728, -296},
    { -432, 744, -384},
    { -464, 792, -320},
    { -448, 776, -368},
    // 55 seconds
    { -496, 784, -312},
    { -480, 848, -320},
    { -528, 824, -288},
    { -504, 808, -440},
    { -592, 872, -240},
    { -520, 736, -272},
    { -496, 720, -384},
    { -496, 792, -312},
    { -528, 768, -424},
    { -560, 696, -288},
    { -560, 680, -392},
    { -592, 560, -384},
    { -576, 432, -280},
    { -640, 496, -168},
    { -632, 1024, -328},
    { -680, 1560, -104},
    { -552, 872, 64},
    { -440, 824, -40},
    { -216, 968, -16},
    { -96, 872, 32},
    { -40, 768, -96},
    { -24, 776, -304},
    { -16, 728, -352},
    { -48, 864, -304},
    { -32, 728, -312},
    // 56 seconds
    { -16, 856, -432},
    { 8, 1048, -280},
    { 40, 976, -288},
    { 16, 920, -336},
    { 0, 952, -296},
    { -48, 952, -296},
    { -40, 968, -312},
    { -24, 960, -288},
    { 24, 912, -296},
    { 40, 888, -256},
    { 16, 880, -272},
    { -16, 904, -240},
    { -32, 920, -224},
    { -72, 848, -224},
    { -88, 760, -224},
    { -96, 880, -256},
    { -88, 904, -280},
    { -104, 872, -272},
    { -104, 920, -240},
    { -96, 944, -248},
    { -96, 904, -240},
    { -88, 904, -232},
    { -136, 872, -192},
    { -120, 920, -208},
    { -112, 920, -272},
    // 57 seconds
    { -96, 912, -264},
    { -120, 888, -248},
    { -112, 904, -192},
    { -112, 920, -224},
    { -112, 912, -248},
    { -128, 936, -232},
    { -120, 856, -208},
    { -104, 880, -184},
    { -104, 888, -216},
    { -80, 944, -256},
    { -112, 960, -200},
    { -112, 904, -200},
    { -104, 944, -200},
    { -96, 904, -200},
    { -96, 880, -216},
    { -112, 920, -224},
    { -120, 928, -200},
    { -104, 944, -216},
    { -104, 928, -168},
    { -112, 872, -168},
    { -96, 880, -224},
    { -136, 944, -216},
    { -152, 1168, -280},
    { -200, 1088, -328},
    { -320, 984, -248},
    // 58 seconds
    { -416, 1096, -216},
    { -424, 496, -280},
    { -160, 88, -704},
    { -16, -336, -1136},
    { -24, -16, -1280},
    { -80, 64, -1152},
    { -104, -152, -1032},
    { -96, -448, -960},
    { -200, -176, -816},
    { -32, -392, -992},
    { -80, -464, -936},
    { -160, -368, -960},
    { -192, -384, -984},
    { -200, -408, -976},
    { -160, -384, -968},
    { -208, -536, -944},
    { -160, -472, -904},
    { -168, -416, -992},
    { -128, -408, -960},
    { -80, -480, -968},
    { -248, -328, -1016},
    { -152, -360, -944},
    { -208, -432, -952},
    { -232, -336, -960},
    { -200, -392, -968},
    // 59 seconds
    { -208, -352, -952},
    { -200, -376, -968},
    { -216, -384, -960},
    { -200, -368, -976},
    { -208, -384, -992},
    { -200, -360, -976},
    { -200, -376, -976},
    { -200, -368, -976},
    { -208, -368, -976},
    { -200, -368, -976},
    { -200, -368, -976},
    { -200, -368, -976},
    { -200, -376, -968},
    { -192, -376, -968},
    { -184, -392, -984},
    { -40, -784, -1032},
    { -128, -816, -1016},
    { 64, -408, -904},
    { -80, 144, -688},
    { -200, 680, -512},
    { -336, 1040, -432},
    { -312, 1024, -416},
    { -360, 1000, -408},
    { -376, 864, -384},
    { -408, 800, -424},
    // 60 seconds
    // elapsed: 1 minutes
    { -400, 768, -424},
    { -384, 752, -424},
    { -400, 760, -448},
    { -384, 848, -424},
    { -344, 600, -416},
    { -384, 840, -408},
    { -392, 792, -424},
    { -392, 824, -440},
    { -408, 808, -392},
    { -408, 776, -336},
    { -416, 792, -440},
    { -392, 816, -280},
    { -416, 808, -368},
    { -400, 856, -408},
    { -392, 760, -408},
    { -368, 800, -384},
    { -384, 808, -384},
    { -392, 816, -408},
    { -384, 848, -392},
    { -360, 800, -368},
    { -352, 840, -352},
    { -344, 848, -336},
    { -344, 808, -344},
    { -368, 808, -360},
    { -360, 824, -336},
    // 61 seconds
    { -384, 840, -328},
    { -376, 888, -360},
    { -360, 816, -352},
    { -344, 808, -368},
    { -344, 856, -368},
    { -352, 824, -360},
    { -360, 792, -384},
    { -384, 784, -384},
    { -384, 816, -376},
    { -400, 824, -352},
    { -424, 800, -360},
    { -416, 832, -352},
    { -400, 816, -352},
    { -384, 816, -368},
    { -400, 784, -368},
    { -392, 768, -360},
    { -408, 776, -376},
    { -400, 800, -368},
    { -392, 800, -360},
    { -408, 808, -376},
    { -384, 808, -368},
    { -384, 832, -360},
    { -400, 832, -360},
    { -392, 808, -336},
    { -400, 824, -344},
    // 62 seconds
    { -400, 824, -352},
    { -392, 808, -336},
    { -384, 824, -336},
    { -392, 808, -328},
    { -384, 816, -312},
    { -408, 840, -352},
    { -384, 808, -336},
    { -384, 832, -288},
    { -392, 816, -320},
    { -384, 792, -352},
    { -392, 864, -328},
    { -384, 824, -304},
    { -384, 856, -312},
    { -392, 856, -312},
    { -408, 848, -312},
    { -392, 848, -384},
    { -376, 792, -280},
    { -376, 848, -280},
    { -400, 848, -336},
    { -392, 816, -328},
    { -376, 808, -320},
    { -376, 824, -304},
    { -400, 848, -328},
    { -384, 824, -320},
    { -392, 808, -312},
    // 63 seconds
    { -392, 848, -312},
    { -352, 792, -288},
    { -376, 824, -272},
    { -384, 800, -296},
    { -392, 832, -328},
    { -400, 872, -320},
    { -392, 832, -344},
    { -376, 832, -304},
    { -384, 832, -304},
    { -384, 824, -312},
    { -392, 848, -304},
    { -376, 848, -360},
    { -360, 800, -272},
    { -360, 848, -280},
    { -392, 792, -320},
    { -392, 848, -344},
    { -384, 872, -320},
    { -384, 840, -344},
    { -384, 776, -432},
    { -384, 736, -424},
    { -384, 584, -472},
    { -336, 792, -392},
    { -352, 896, -368},
    { -360, 848, -392},
    { -304, 824, -384},
    // 64 seconds
    { -248, 864, -408},
    { -224, 904, -432},
    { -200, 880, -448},
    { -168, 840, -456},
    { -160, 840, -480},
    { -136, 840, -480},
    { -160, 832, -472},
    { -192, 824, -456},
    { -200, 808, -464},
    { -200, 784, -472},
    { -216, 776, -472},
    { -224, 792, -448},
    { -224, 824, -456},
    { -224, 816, -456},
    { -208, 824, -456},
    { -176, 832, -464},
    { -168, 808, -472},
    { -168, 808, -472},
    { -152, 832, -472},
    { -200, 840, -464},
    { -256, 800, -416},
    { -360, 800, -336},
    { -376, 864, -296},
    { -352, 864, -320},
    { -280, 848, -360},
    // 65 seconds
    { -240, 816, -408},
    { -128, 808, -408},
    { 8, 440, -352},
    { -40, 512, -192},
    { -88, 624, 80},
    { -152, 936, 208},
    { -216, 960, 128},
    { -216, 1216, 360},
    { -328, 1448, 216},
    { -440, 1192, 80},
    { -416, 1328, -224},
    { -376, 880, -368},
    { -288, 792, -408},
    { -184, 792, -592},
    { -112, 712, -464},
    { -192, 1000, -264},
    { -264, 824, -208},
    { -304, 960, -88},
    { -320, 888, -96},
    { -264, 920, -168},
    { -368, 1128, -288},
    { -280, 1040, -256},
    { -272, 896, -424},
    { -312, 648, -248},
    { -272, 352, -272},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

