/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */



// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:58:10 local
AccelRawData *activity_sample_walk_200_pbl_25657_8(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25657_8
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 224, 800, -720},
    { 296, 504, -856},
    { 192, 656, -984},
    { 144, -80, -504},
    { 32, 192, -864},
    { 40, -24, -880},
    { 96, -136, -1016},
    { 88, -48, -1000},
    { -8, -136, -920},
    { -32, -168, -1072},
    { -56, -264, -872},
    { 40, -224, -904},
    { 112, -256, -880},
    { 88, -184, -856},
    { -144, -296, -960},
    { -224, -232, -856},
    { -40, -320, -960},
    { 32, -288, -944},
    { -32, -312, -856},
    { -16, -256, -968},
    { 0, -320, -880},
    { -80, -336, -952},
    { 40, -232, -936},
    { -104, -312, -840},
    { 232, -840, -784},
    // 1 seconds
    { 48, -288, -872},
    { 80, -320, -944},
    { 32, -360, -888},
    { -144, -328, -904},
    { 8, -320, -928},
    { -16, -312, -832},
    { 0, -352, -936},
    { 8, -328, -880},
    { -24, -224, -952},
    { -48, -584, -888},
    { -376, -352, -920},
    { -48, -256, -776},
    { -40, -160, -832},
    { -40, 248, -912},
    { 216, 272, -976},
    { 200, 64, -824},
    { 208, 584, -816},
    { 416, 480, -816},
    { 376, 440, -840},
    { 320, 480, -984},
    { 272, 344, -712},
    { 328, 624, -896},
    { 368, 488, -864},
    { 248, 360, -744},
    { 256, 280, -800},
    // 2 seconds
    { 200, 360, -872},
    { 208, 176, -824},
    { -24, 288, -528},
    { -8, 192, -712},
    { 72, 208, -528},
    { 88, 200, -392},
    { -16, 152, -480},
    { -112, 368, -328},
    { -176, 264, -144},
    { -632, 720, -224},
    { -888, 936, -440},
    { -1672, 1168, -384},
    { -2040, 1488, -352},
    { -1272, 1304, -104},
    { -888, 912, -176},
    { -848, 752, -120},
    { -752, 640, 0},
    { -624, 528, 104},
    { -488, 216, 96},
    { -416, 184, 24},
    { -408, 296, -72},
    { -560, 440, -96},
    { -616, 392, -56},
    { -680, 336, -72},
    { -936, 384, -64},
    // 3 seconds
    { -1152, 344, 64},
    { -1128, 392, -96},
    { -1184, 512, -104},
    { -1160, 592, -224},
    { -896, 432, -208},
    { -800, 296, -208},
    { -672, 104, -272},
    { -592, 96, -176},
    { -400, 24, -120},
    { -424, 168, -192},
    { -536, 248, -160},
    { -712, 320, -112},
    { -776, 288, -112},
    { -648, 288, -120},
    { -712, 392, -232},
    { -872, 344, -328},
    { -1096, 448, -304},
    { -1544, 488, -344},
    { -1416, 632, -360},
    { -1272, 560, -200},
    { -1024, 608, -152},
    { -616, 496, -136},
    { -280, 488, -128},
    { -336, 440, -80},
    { -392, 280, -8},
    // 4 seconds
    { -520, 312, 24},
    { -632, 336, 32},
    { -648, 296, 24},
    { -872, 312, -88},
    { -1136, 376, 24},
    { -1096, 296, -104},
    { -1320, 304, -160},
    { -1256, 416, -240},
    { -1024, 320, -304},
    { -832, 384, -376},
    { -568, 232, -248},
    { -320, 152, -200},
    { -296, 200, -176},
    { -376, 296, -184},
    { -528, 344, -152},
    { -688, 440, -144},
    { -760, 408, -144},
    { -808, 424, -144},
    { -912, 512, -216},
    { -1080, 440, -240},
    { -1456, 376, -192},
    { -1488, 440, -320},
    { -1184, 320, -200},
    { -1040, 448, -296},
    { -872, 352, -296},
    // 5 seconds
    { -680, 232, -48},
    { -464, 336, -16},
    { -400, 280, -16},
    { -424, 280, 72},
    { -512, 328, 104},
    { -632, 336, 48},
    { -720, 360, 48},
    { -752, 384, 32},
    { -960, 408, -24},
    { -1024, 344, -8},
    { -1272, 416, -64},
    { -1272, 416, -168},
    { -1064, 424, -296},
    { -768, 352, -352},
    { -648, 256, -344},
    { -488, 152, -224},
    { -368, 136, -168},
    { -360, 224, -160},
    { -488, 344, -184},
    { -680, 352, -152},
    { -816, 328, -112},
    { -712, 304, -56},
    { -776, 416, -176},
    { -992, 512, -304},
    { -1160, 376, -192},
    // 6 seconds
    { -1488, 432, -264},
    { -1224, 496, -248},
    { -1152, 584, -296},
    { -1064, 584, -224},
    { -824, 368, -24},
    { -536, 320, -48},
    { -432, 352, -48},
    { -424, 392, 0},
    { -448, 232, 24},
    { -488, 232, 48},
    { -592, 280, 88},
    { -656, 288, 80},
    { -912, 360, 24},
    { -1008, 400, 16},
    { -1304, 424, -16},
    { -1312, 496, -152},
    { -1128, 552, -216},
    { -928, 536, -368},
    { -816, 440, -368},
    { -544, 144, -216},
    { -320, 56, -208},
    { -280, 176, -232},
    { -400, 272, -168},
    { -616, 328, -144},
    { -744, 400, -112},
    // 7 seconds
    { -768, 344, -56},
    { -848, 424, -152},
    { -1016, 528, -264},
    { -1040, 424, -160},
    { -1272, 456, -288},
    { -1152, 568, -376},
    { -1208, 544, -280},
    { -1248, 544, -160},
    { -1048, 392, 48},
    { -616, 408, -32},
    { -472, 456, -112},
    { -424, 384, -72},
    { -416, 264, -24},
    { -432, 184, 64},
    { -480, 208, 88},
    { -616, 280, 32},
    { -888, 336, 72},
    { -1072, 376, 48},
    { -1080, 488, -144},
    { -1128, 496, -192},
    { -1200, 528, -280},
    { -1096, 400, -336},
    { -864, 344, -232},
    { -600, 424, -344},
    { -352, 360, -280},
    // 8 seconds
    { -256, 296, -248},
    { -232, 224, -248},
    { -384, 256, -208},
    { -656, 352, -208},
    { -800, 368, -184},
    { -880, 384, -112},
    { -1072, 504, -240},
    { -1008, 472, -200},
    { -1376, 504, -296},
    { -1264, 560, -336},
    { -1232, 488, -264},
    { -1152, 568, -208},
    { -936, 432, -72},
    { -608, 368, -72},
    { -424, 360, -88},
    { -424, 360, -72},
    { -448, 280, 8},
    { -448, 232, 56},
    { -496, 296, 48},
    { -512, 320, 40},
    { -784, 384, 8},
    { -928, 472, -48},
    { -1128, 432, -104},
    { -1304, 520, -264},
    { -1352, 856, -512},
    // 9 seconds
    { -1080, 616, -432},
    { -768, 616, -536},
    { -488, 632, -712},
    { -400, 624, -536},
    { -400, 736, -480},
    { -472, 480, -528},
    { -576, 768, -584},
    { -736, 576, -640},
    { -512, 312, -496},
    { -352, 136, -704},
    { -216, 80, -768},
    { 0, -56, -832},
    { -24, 112, -968},
    { -80, 184, -1096},
    { 0, 160, -920},
    { -80, 136, -848},
    { -40, -8, -632},
    { 16, 64, -552},
    { 32, 88, -624},
    { 96, 0, -600},
    { 120, 24, -672},
    { 112, 24, -816},
    { 112, 32, -896},
    { 64, 80, -1048},
    { -40, 120, -1272},
    // 10 seconds
    { -80, 48, -1160},
    { -312, 16, -1120},
    { -232, 280, -1224},
    { -392, 184, -1168},
    { -416, 152, -912},
    { -312, 80, -808},
    { -216, 48, -560},
    { -48, -48, -368},
    { -16, -136, -320},
    { -72, -368, -160},
    { -200, -552, 16},
    { -560, -24, -184},
    { -744, 240, -216},
    { -1128, 808, -32},
    { -1248, 944, 120},
    { -1608, 1416, 72},
    { -1976, 1832, -520},
    { -1640, 1552, -208},
    { -1016, 1088, 544},
    { -872, 328, 208},
    { -744, 568, 56},
    { -440, 480, 120},
    { -344, 480, 56},
    { -352, 320, 40},
    { -480, 488, 56},
    // 11 seconds
    { -584, 424, -24},
    { -688, 440, -136},
    { -760, 368, -56},
    { -976, 368, 0},
    { -1064, 328, -48},
    { -1064, 48, -48},
    { -1216, 144, -48},
    { -1464, 608, -216},
    { -1112, 432, -280},
    { -840, 176, -128},
    { -672, 104, -64},
    { -416, 168, -128},
    { -240, 216, -144},
    { -344, 344, -192},
    { -464, 352, -152},
    { -760, 400, -152},
    { -944, 288, 0},
    { -856, 272, -24},
    { -1120, 464, -224},
    { -1096, 504, -152},
    { -1416, 464, -224},
    { -1288, 488, -360},
    { -1152, 400, -192},
    { -1048, 488, -112},
    { -960, 368, 56},
    // 12 seconds
    { -544, 344, 24},
    { -376, 344, -64},
    { -408, 296, 24},
    { -448, 288, 80},
    { -536, 232, 72},
    { -616, 272, 56},
    { -704, 256, 72},
    { -1016, 320, 8},
    { -1144, 296, 96},
    { -1232, 288, 40},
    { -1216, 368, -152},
    { -1376, 496, -120},
    { -1176, 416, -216},
    { -792, 464, -360},
    { -360, 392, -376},
    { -280, 280, -224},
    { -248, 272, -240},
    { -352, 320, -256},
    { -520, 400, -208},
    { -800, 432, -232},
    { -872, 344, -88},
    { -1056, 424, -184},
    { -1096, 504, -200},
    { -1760, 496, -184},
    { -1496, 480, -120},
    // 13 seconds
    { -1336, 416, -16},
    { -1088, 472, -64},
    { -832, 416, -72},
    { -496, 336, -24},
    { -368, 264, -8},
    { -400, 248, -8},
    { -456, 240, 32},
    { -504, 200, 56},
    { -480, 200, 40},
    { -560, 216, 40},
    { -800, 264, 24},
    { -920, 344, -40},
    { -1136, 368, -56},
    { -1424, 440, -216},
    { -1592, 496, -128},
    { -1256, 432, -216},
    { -832, 552, -432},
    { -440, 424, -352},
    { -344, 320, -256},
    { -296, 296, -184},
    { -320, 320, -144},
    { -456, 344, -160},
    { -704, 408, -152},
    { -808, 392, -88},
    { -976, 416, -88},
    // 14 seconds
    { -1152, 536, -176},
    { -1568, 576, -160},
    { -1448, 600, -304},
    { -1072, 424, -144},
    { -1080, 456, -208},
    { -904, 360, -72},
    { -616, 288, -16},
    { -384, 312, -40},
    { -360, 320, -16},
    { -408, 280, 40},
    { -472, 248, 80},
    { -528, 256, 88},
    { -544, 296, 80},
    { -808, 376, -24},
    { -1016, 376, 40},
    { -1032, 360, -96},
    { -1320, 344, -72},
    { -1336, 512, -248},
    { -1024, 416, -312},
    { -1016, 328, -216},
    { -808, 328, -240},
    { -496, 320, -192},
    { -328, 272, -208},
    { -320, 288, -208},
    { -416, 288, -184},
    // 15 seconds
    { -552, 232, -120},
    { -736, 264, -96},
    { -736, 304, -72},
    { -824, 392, -136},
    { -1000, 528, -256},
    { -1168, 440, -200},
    { -1424, 456, -224},
    { -1336, 600, -304},
    { -1184, 576, -176},
    { -1168, 496, -128},
    { -864, 368, -56},
    { -544, 400, -152},
    { -480, 408, -160},
    { -472, 328, -32},
    { -480, 272, 24},
    { -512, 312, 48},
    { -536, 360, 48},
    { -544, 376, 104},
    { -712, 384, 104},
    { -840, 448, 16},
    { -824, 480, -128},
    { -1128, 392, -24},
    { -1136, 464, -176},
    { -1208, 472, -408},
    { -1112, 440, -288},
    // 16 seconds
    { -832, 296, -280},
    { -608, 312, -304},
    { -368, 272, -272},
    { -304, 272, -256},
    { -416, 304, -216},
    { -520, 288, -144},
    { -728, 352, -136},
    { -752, 336, -112},
    { -736, 392, -112},
    { -936, 504, -224},
    { -1032, 432, -136},
    { -1256, 424, -120},
    { -1328, 576, -272},
    { -1232, 520, -144},
    { -1144, 592, -224},
    { -976, 432, -88},
    { -704, 328, 8},
    { -432, 384, -96},
    { -392, 408, -48},
    { -448, 376, 32},
    { -560, 368, 56},
    { -640, 344, 104},
    { -632, 368, 96},
    { -712, 392, 80},
    { -928, 408, 16},
    // 17 seconds
    { -872, 360, -64},
    { -1040, 352, -128},
    { -1072, 328, -160},
    { -1296, 344, -192},
    { -1072, 488, -408},
    { -864, 440, -400},
    { -552, 336, -352},
    { -384, 248, -240},
    { -352, 272, -184},
    { -432, 352, -160},
    { -536, 392, -160},
    { -640, 384, -128},
    { -744, 432, -128},
    { -728, 472, -192},
    { -776, 504, -240},
    { -944, 456, -160},
    { -1448, 528, -224},
    { -1384, 544, -240},
    { -1008, 456, -152},
    { -1056, 584, -248},
    { -912, 448, -104},
    { -600, 304, 0},
    { -480, 344, -64},
    { -448, 360, -56},
    { -512, 304, 56},
    // 18 seconds
    { -560, 304, 40},
    { -520, 336, 48},
    { -520, 360, 56},
    { -704, 416, -24},
    { -920, 440, -48},
    { -1056, 472, -152},
    { -1248, 368, -80},
    { -1296, 536, -256},
    { -920, 520, -360},
    { -904, 432, -256},
    { -808, 416, -264},
    { -624, 336, -184},
    { -416, 352, -160},
    { -344, 352, -184},
    { -384, 336, -136},
    { -464, 288, -96},
    { -600, 336, -88},
    { -704, 408, -96},
    { -728, 464, -88},
    { -872, 520, -152},
    { -1152, 528, -200},
    { -1440, 528, -208},
    { -1272, 520, -176},
    { -1048, 512, -144},
    { -1096, 568, -200},
    // 19 seconds
    { -808, 368, 0},
    { -576, 336, -16},
    { -416, 352, -32},
    { -440, 352, 16},
    { -464, 336, 56},
    { -608, 320, 88},
    { -608, 336, 112},
    { -664, 360, 72},
    { -832, 368, 24},
    { -1072, 464, -104},
    { -1000, 392, -112},
    { -1312, 288, -48},
    { -1128, 328, -96},
    { -904, 416, -328},
    { -1000, 328, -360},
    { -824, 32, -104},
    { -528, 56, -120},
    { -416, 232, -200},
    { -368, 288, -184},
    { -448, 256, -88},
    { -560, 280, -112},
    { -648, 328, -112},
    { -664, 344, -88},
    { -840, 424, -200},
    { -1064, 416, -168},
    // 20 seconds
    { -1168, 336, -24},
    { -1328, 464, -144},
    { -1320, 608, -272},
    { -1136, 576, -208},
    { -1160, 488, -128},
    { -904, 368, -8},
    { -592, 392, -64},
    { -440, 424, -136},
    { -424, 336, -24},
    { -416, 264, 32},
    { -504, 328, 64},
    { -608, 360, 120},
    { -752, 392, 104},
    { -896, 408, 96},
    { -1072, 432, 40},
    { -1200, 464, -8},
    { -1136, 448, -104},
    { -960, 512, -344},
    { -1144, 400, -288},
    { -976, 144, -160},
    { -600, 128, -232},
    { -328, 200, -240},
    { -280, 232, -272},
    { -352, 240, -232},
    { -480, 248, -152},
    // 21 seconds
    { -680, 328, -144},
    { -728, 344, -104},
    { -760, 408, -120},
    { -952, 496, -200},
    { -1040, 464, -112},
    { -1464, 488, -152},
    { -1472, 624, -184},
    { -1288, 592, -128},
    { -1192, 584, -128},
    { -840, 424, -40},
    { -528, 424, -112},
    { -344, 416, -120},
    { -368, 336, -48},
    { -448, 312, 16},
    { -600, 344, 0},
    { -688, 368, 48},
    { -648, 368, 64},
    { -768, 384, 48},
    { -992, 416, -16},
    { -992, 384, -56},
    { -1088, 344, -48},
    { -1008, 504, -272},
    { -976, 480, -344},
    { -1104, 392, -296},
    { -880, 272, -240},
    // 22 seconds
    { -560, 296, -256},
    { -392, 344, -240},
    { -344, 344, -256},
    { -416, 296, -216},
    { -520, 296, -168},
    { -648, 328, -112},
    { -584, 432, -128},
    { -552, 520, -192},
    { -744, 608, -272},
    { -920, 520, -168},
    { -1368, 504, -112},
    { -1472, 616, -144},
    { -1176, 680, -224},
    { -1072, 704, -240},
    { -896, 496, -80},
    { -624, 328, -56},
    { -408, 360, 112},
    { -360, 520, -104},
    { -504, 440, -8},
    { -560, 264, 72},
    { -608, 176, 56},
    { -560, 208, 96},
    { -696, 136, 112},
    { -1008, 520, -40},
    { -1104, 536, -24},
    // 23 seconds
    { -1352, 344, 104},
    { -1264, 384, -8},
    { -1024, 584, -192},
    { -1048, 528, -128},
    { -808, 424, -104},
    { -528, 384, -112},
    { -344, 448, -104},
    { -304, 360, -144},
    { -328, 264, -40},
    { -472, 344, -64},
    { -696, 360, -56},
    { -776, 392, -24},
    { -800, 416, -72},
    { -968, 432, -112},
    { -1184, 448, -80},
    { -1464, 536, -168},
    { -1272, 616, -168},
    { -1272, 512, -64},
    { -1144, 488, -32},
    { -736, 376, -16},
    { -456, 384, -80},
    { -408, 368, -56},
    { -400, 280, 0},
    { -408, 248, 56},
    { -480, 256, 64},
    // 24 seconds
    { -568, 320, 72},
    { -656, 368, 72},
    { -912, 424, 48},
    { -952, 472, -40},
    { -1224, 424, 8},
    { -1176, 568, -160},
    { -1136, 576, -280},
    { -1088, 472, -136},
    { -888, 280, -120},
    { -624, 304, -192},
    { -376, 280, -176},
    { -328, 288, -216},
    { -352, 280, -200},
    { -512, 264, -160},
    { -688, 280, -128},
    { -712, 280, -72},
    { -728, 368, -120},
    { -1016, 448, -168},
    { -1056, 360, -104},
    { -1440, 456, -200},
    { -1352, 528, -256},
    { -1232, 576, -304},
    { -1208, 480, -184},
    { -976, 392, -144},
    { -736, 392, -152},
    // 25 seconds
    { -568, 392, -176},
    { -488, 360, -136},
    { -424, 248, -32},
    { -336, 208, 16},
    { -312, 224, 40},
    { -504, 368, -8},
    { -640, 432, 8},
    { -992, 432, 48},
    { -1040, 408, 40},
    { -1192, 440, 8},
    { -1160, 576, -208},
    { -1128, 600, -464},
    { -1032, 528, -552},
    { -936, 184, -312},
    { -648, -104, -176},
    { -368, 80, -136},
    { -256, 320, -272},
    { -384, 360, -240},
    { -480, 272, -112},
    { -696, 304, -72},
    { -736, 320, -72},
    { -696, 368, -120},
    { -872, 456, -192},
    { -984, 424, -144},
    { -1016, 408, -120},
    // 26 seconds
    { -1240, 568, -208},
    { -1240, 704, -304},
    { -1264, 656, -288},
    { -1288, 504, -32},
    { -1000, 368, -16},
    { -672, 424, -120},
    { -576, 456, -144},
    { -496, 336, -56},
    { -480, 264, -48},
    { -488, 208, 24},
    { -512, 192, 32},
    { -544, 208, 48},
    { -704, 232, 56},
    { -864, 272, 56},
    { -1064, 368, -16},
    { -1272, 352, 8},
    { -1440, 536, -208},
    { -1208, 600, -320},
    { -1000, 480, -248},
    { -816, 344, -296},
    { -632, 336, -264},
    { -440, 320, -200},
    { -416, 352, -240},
    { -400, 320, -160},
    { -440, 288, -128},
    // 27 seconds
    { -560, 344, -208},
    { -592, 400, -192},
    { -648, 376, -160},
    { -920, 448, -264},
    { -1112, 408, -112},
    { -1480, 416, -120},
    { -1400, 592, -240},
    { -1056, 544, -160},
    { -1192, 528, -104},
    { -1136, 392, 16},
    { -880, 352, 8},
    { -648, 424, -112},
    { -528, 408, -80},
    { -408, 296, -48},
    { -392, 232, -16},
    { -416, 200, 56},
    { -520, 256, 64},
    { -632, 280, 96},
    { -784, 296, 112},
    { -856, 376, 64},
    { -1048, 456, -72},
    { -1160, 432, -88},
    { -1224, 512, -256},
    { -968, 576, -440},
    { -984, 432, -304},
    // 28 seconds
    { -936, 296, -352},
    { -752, 208, -272},
    { -504, 192, -160},
    { -400, 256, -272},
    { -440, 144, -416},
    { -400, -56, -48},
    { -560, 192, -96},
    { -704, 464, -168},
    { -760, 328, -128},
    { -1040, 464, -160},
    { -1192, 440, -112},
    { -1520, 528, -128},
    { -1504, 712, -224},
    { -1120, 616, -112},
    { -1040, 560, -152},
    { -784, 360, -24},
    { -448, 384, -64},
    { -312, 416, -80},
    { -384, 384, 0},
    { -504, 352, 32},
    { -688, 296, 80},
    { -840, 320, 104},
    { -808, 280, 152},
    { -1096, 320, 128},
    { -848, 360, 16},
    // 29 seconds
    { -1208, 376, -56},
    { -1056, 416, -176},
    { -976, 368, -240},
    { -1048, 224, -120},
    { -856, 280, -288},
    { -512, 224, -176},
    { -384, 296, -152},
    { -408, 368, -168},
    { -472, 384, -88},
    { -576, 376, -80},
    { -664, 400, -72},
    { -624, 400, -56},
    { -808, 480, -160},
    { -1032, 520, -184},
    { -1168, 432, -104},
    { -1448, 528, -144},
    { -1464, 624, -256},
    { -1216, 496, -144},
    { -1160, 424, -144},
    { -864, 336, -48},
    { -552, 320, -72},
    { -488, 336, -72},
    { -544, 272, 16},
    { -576, 232, 112},
    { -608, 192, 104},
    // 30 seconds
    { -608, 168, 144},
    { -680, 192, 112},
    { -824, 248, 80},
    { -816, 240, 72},
    { -1152, 352, -56},
    { -1072, 256, -120},
    { -1152, 400, -208},
    { -1368, 536, -528},
    { -1056, 536, -400},
    { -616, 488, -304},
    { -496, 528, -312},
    { -472, 416, -152},
    { -520, 408, -64},
    { -560, 408, -72},
    { -632, 416, -88},
    { -656, 432, -88},
    { -672, 400, -248},
    { -800, 512, -312},
    { -840, 304, -272},
    { -848, 424, -264},
    { -1208, 552, -392},
    { -1184, 544, -408},
    { -1320, 408, -224},
    { -1560, 328, -120},
    { -1144, 312, -8},
    // 31 seconds
    { -792, 312, -96},
    { -664, 400, -192},
    { -552, 320, -136},
    { -392, 120, 24},
    { -336, 128, 16},
    { -320, 176, 32},
    { -328, 208, 72},
    { -392, 320, 72},
    { -576, 384, 56},
    { -848, 488, 24},
    { -1312, 672, -240},
    { -1832, 648, 0},
    { -1832, 568, -120},
    { -1056, 472, -456},
    { -856, 320, -248},
    { -944, 208, -56},
    { -640, 320, -72},
    { -360, 360, -120},
    { -296, 392, -152},
    { -376, 376, -128},
    { -440, 224, -80},
    { -592, 280, -144},
    { -648, 216, -64},
    { -816, 320, -104},
    { -936, 360, -104},
    // 32 seconds
    { -1008, 360, -80},
    { -1400, 504, -208},
    { -1552, 664, -368},
    { -1456, 536, -152},
    { -1152, 504, -48},
    { -824, 560, -72},
    { -472, 536, -112},
    { -384, 480, -136},
    { -376, 432, -16},
    { -488, 360, 56},
    { -640, 296, 72},
    { -840, 280, 56},
    { -928, 248, 80},
    { -1024, 208, 120},
    { -1136, 176, 136},
    { -1240, 200, 136},
    { -1152, 224, 80},
    { -728, 424, -192},
    { -944, 456, -288},
    { -904, 280, -120},
    { -760, 160, -32},
    { -584, 264, -272},
    { -504, 368, -224},
    { -448, 416, -248},
    { -568, 400, -272},
    // 33 seconds
    { -640, 352, -200},
    { -760, 368, -208},
    { -880, 400, -192},
    { -1000, 392, -136},
    { -1032, 360, -8},
    { -1664, 536, -208},
    { -1568, 520, -232},
    { -1240, 304, -48},
    { -1200, 360, -48},
    { -944, 384, -48},
    { -664, 344, -24},
    { -496, 336, -48},
    { -488, 304, -8},
    { -472, 208, 88},
    { -456, 112, 88},
    { -504, 112, 104},
    { -528, 128, 144},
    { -856, 224, 112},
    { -1016, 248, 72},
    { -1248, 360, 8},
    { -1488, 400, -32},
    { -1496, 616, -320},
    { -1200, 296, -128},
    { -944, 24, -64},
    { -616, 248, -96},
    // 34 seconds
    { -360, 368, -168},
    { -328, 512, -192},
    { -416, 528, -120},
    { -656, 512, -128},
    { -824, 552, -40},
    { -792, 504, -48},
    { -912, 608, -216},
    { -1040, 584, -136},
    { -1552, 552, -152},
    { -1624, 592, -272},
    { -1768, 408, 48},
    { -1512, 384, 112},
    { -1048, 328, 112},
    { -592, 408, -64},
    { -488, 360, -24},
    { -632, 272, 248},
    { -632, 64, 368},
    { -512, 88, 248},
    { -424, 184, 120},
    { -384, 224, 72},
    { -632, 216, 120},
    { -776, 240, 88},
    { -1224, 448, 184},
    { -1512, 672, -48},
    { -1520, 680, 16},
    // 35 seconds
    { -1416, 720, -296},
    { -880, 592, -440},
    { -400, 360, -368},
    { -248, 424, -304},
    { -320, 424, -264},
    { -440, 392, -112},
    { -640, 536, -64},
    { -784, 584, -16},
    { -784, 504, -40},
    { -1040, 568, -112},
    { -1040, 512, 0},
    { -1304, 560, -128},
    { -1328, 648, -248},
    { -1360, 568, -136},
    { -1376, 488, -40},
    { -1024, 416, 8},
    { -608, 448, -112},
    { -456, 480, -152},
    { -416, 296, -16},
    { -448, 224, 72},
    { -464, 184, 80},
    { -504, 208, 48},
    { -528, 224, 88},
    { -704, 248, 112},
    { -1008, 320, 64},
    // 36 seconds
    { -1096, 416, -56},
    { -1304, 384, -32},
    { -1352, 416, -88},
    { -1288, 584, -320},
    { -1048, 464, -200},
    { -704, 512, -328},
    { -408, 400, -240},
    { -248, 264, -184},
    { -232, 328, -192},
    { -328, 320, -160},
    { -552, 376, -176},
    { -856, 432, -152},
    { -920, 408, -16},
    { -1072, 544, -128},
    { -1064, 632, -128},
    { -1400, 496, -192},
    { -1328, 696, -320},
    { -1256, 752, -200},
    { -1160, 536, -32},
    { -936, 448, -40},
    { -664, 408, -56},
    { -496, 368, 8},
    { -440, 304, 8},
    { -456, 256, 56},
    { -488, 208, 64},
    // 37 seconds
    { -520, 192, 64},
    { -656, 240, 40},
    { -864, 248, 32},
    { -984, 264, 104},
    { -1152, 288, -104},
    { -1272, 384, -232},
    { -1224, 504, -288},
    { -1176, 384, -144},
    { -888, 504, -256},
    { -504, 472, -320},
    { -344, 408, -304},
    { -224, 384, -368},
    { -288, 336, -312},
    { -400, 312, -296},
    { -696, 464, -264},
    { -848, 568, -176},
    { -1008, 608, -272},
    { -1088, 592, -144},
    { -1504, 592, -256},
    { -1432, 696, -272},
    { -1184, 456, -160},
    { -1176, 480, -136},
    { -1056, 488, -24},
    { -664, 304, -88},
    { -440, 304, -48},
    // 38 seconds
    { -432, 328, -48},
    { -456, 248, -8},
    { -424, 208, -16},
    { -456, 248, 8},
    { -464, 168, -24},
    { -696, 256, -144},
    { -888, 304, -32},
    { -1256, 248, -120},
    { -1480, 448, -112},
    { -1320, 760, -320},
    { -1056, 392, -168},
    { -944, 576, -184},
    { -608, 320, -216},
    { -408, 416, -376},
    { -256, 232, -272},
    { -400, 376, -208},
    { -504, 432, -168},
    { -720, 472, -64},
    { -784, 552, -72},
    { -928, 568, -200},
    { -1096, 576, -192},
    { -1432, 512, -224},
    { -1320, 440, -232},
    { -1168, 1120, 72},
    { -1064, 1248, 312},
    // 39 seconds
    { -1144, 1248, 600},
    { -912, 896, 344},
    { -568, 392, 496},
    { -568, 232, 480},
    { -392, 288, 184},
    { -304, 184, 264},
    { -160, 256, 368},
    { 56, 488, 368},
    { 24, 640, 624},
    { 96, 736, 560},
    { 112, 944, 968},
    { 152, 800, 800},
    { 208, 1224, 744},
    { 72, 1200, 616},
    { 120, 808, 568},
    { 136, 776, 400},
    { 224, 736, 296},
    { 240, 312, 208},
    { 192, 512, 312},
    { 288, 344, 344},
    { 296, 672, 456},
    { 240, 584, 616},
    { 368, 880, 688},
    { 336, 936, 784},
    { 256, 968, 976},
    // 40 seconds
    { 128, 808, 1248},
    { 32, 1240, 672},
    { 8, 1048, 1008},
    { -120, 912, 1032},
    { 24, 824, 776},
    { 16, 592, 712},
    { 136, 568, 488},
    { 136, 344, 496},
    { 136, 456, 472},
    { 120, 392, 592},
    { 80, 408, 728},
    { 0, 640, 720},
    { -112, 728, 792},
    { -192, 936, 504},
    { -264, 912, 288},
    { -432, 904, 472},
    { -664, 968, 248},
    { -896, 720, 152},
    { -880, 424, -32},
    { -728, 184, -168},
    { -632, 376, -80},
    { -576, 416, -232},
    { -568, 504, -88},
    { -664, 624, -120},
    { -680, 512, -136},
    // 41 seconds
    { -808, 616, -224},
    { -1064, 696, -176},
    { -1320, 528, -160},
    { -1408, 688, -368},
    { -1192, 600, -200},
    { -1096, 368, -248},
    { -1016, 448, -248},
    { -640, 368, -136},
    { -408, 352, -80},
    { -400, 312, -40},
    { -480, 264, 56},
    { -536, 256, 72},
    { -608, 304, 72},
    { -696, 336, 40},
    { -928, 360, 56},
    { -944, 288, 64},
    { -1328, 496, -64},
    { -1184, 432, -136},
    { -1064, 448, -272},
    { -1016, 472, -336},
    { -728, 392, -352},
    { -368, 168, -304},
    { -304, 168, -256},
    { -320, 80, -192},
    { -512, 568, -288},
    // 42 seconds
    { -640, 552, -208},
    { -688, 504, -264},
    { -728, 664, -200},
    { -848, 560, -264},
    { -968, 608, -200},
    { -1256, 672, -248},
    { -1208, 712, -376},
    { -1016, 808, -280},
    { -1040, 704, -200},
    { -872, 416, -56},
    { -576, 448, -88},
    { -328, 544, -336},
    { -344, 560, -160},
    { -440, 400, 24},
    { -472, 320, 144},
    { -552, 280, -40},
    { -608, 288, -40},
    { -752, 280, -16},
    { -928, 312, -144},
    { -1136, 392, -136},
    { -1168, 432, -240},
    { -1072, 552, -496},
    { -1104, 376, -200},
    { -952, 424, -232},
    { -592, 496, -360},
    // 43 seconds
    { -352, 344, -352},
    { -280, 400, -424},
    { -320, 312, -368},
    { -496, 128, -216},
    { -792, 272, -160},
    { -776, 392, -152},
    { -832, 440, -160},
    { -1008, 440, -200},
    { -1128, 440, 24},
    { -1648, 568, -144},
    { -1288, 632, -208},
    { -1072, 560, -160},
    { -1016, 520, -128},
    { -856, 392, -64},
    { -632, 376, -80},
    { -520, 432, -120},
    { -488, 416, -128},
    { -512, 144, 64},
    { -536, 152, 72},
    { -552, 200, 40},
    { -600, 216, 56},
    { -872, 232, 88},
    { -1008, 368, 56},
    { -1328, 408, 32},
    { -1312, 448, -184},
    // 44 seconds
    { -1272, 360, -208},
    { -1112, 120, -56},
    { -832, 136, -184},
    { -480, 80, -184},
    { -392, 136, -272},
    { -432, 336, -296},
    { -592, 288, -168},
    { -808, 416, -184},
    { -840, 400, -192},
    { -832, 304, -272},
    { -1072, 408, -352},
    { -1088, 96, -336},
    { -1416, 368, -400},
    { -1312, 352, -368},
    { -1400, 344, -360},
    { -1312, 432, -208},
    { -1288, 352, -128},
    { -936, 240, 8},
    { -576, 296, -80},
    { -408, 192, -72},
    { -352, 176, 32},
    { -336, 48, 56},
    { -440, 48, 80},
    { -568, 192, 104},
    { -816, 216, 96},
    // 45 seconds
    { -1072, 240, 56},
    { -928, 216, -32},
    { -1448, 224, 40},
    { -1464, 408, -192},
    { -1200, 552, -384},
    { -1128, 360, -144},
    { -928, 368, -336},
    { -576, 248, -320},
    { -336, 256, -264},
    { -384, 376, -328},
    { -488, 464, -336},
    { -672, 376, -160},
    { -880, 352, -136},
    { -792, 416, -128},
    { -1016, 520, -248},
    { -1232, 496, -104},
    { -1672, 488, -208},
    { -1600, 472, -264},
    { -1152, 280, -56},
    { -1128, 352, -128},
    { -872, 320, -24},
    { -664, 320, 0},
    { -544, 256, 64},
    { -488, 224, 56},
    { -456, 288, 152},
    // 46 seconds
    { -488, 304, 112},
    { -632, 280, 96},
    { -512, 256, 208},
    { -656, 336, 32},
    { -688, 400, -152},
    { -984, 464, -128},
    { -1296, 472, -120},
    { -1264, 720, -400},
    { -1336, 432, -216},
    { -968, 304, -40},
    { -592, 240, -160},
    { -448, 320, -128},
    { -400, 408, -200},
    { -472, 336, -128},
    { -584, 416, -72},
    { -760, 456, -160},
    { -872, 520, -128},
    { -960, 608, -312},
    { -1016, 520, -304},
    { -1504, 464, -240},
    { -1504, 496, -320},
    { -1352, 400, -144},
    { -1288, 368, -80},
    { -1048, 328, 0},
    { -680, 312, 16},
    // 47 seconds
    { -464, 344, -32},
    { -480, 304, 16},
    { -480, 160, 88},
    { -432, 96, 136},
    { -480, 208, 64},
    { -528, 304, -96},
    { -728, 280, -16},
    { -904, 232, 32},
    { -1240, 352, 32},
    { -1416, 312, 24},
    { -1288, 640, -408},
    { -1192, 336, 40},
    { -1032, 352, -152},
    { -728, 368, -296},
    { -432, 472, -384},
    { -376, 304, -264},
    { -456, 288, -248},
    { -576, 360, -152},
    { -696, 456, -176},
    { -776, 448, -176},
    { -736, 392, -144},
    { -976, 456, -240},
    { -1216, 488, -120},
    { -1512, 552, -232},
    { -1392, 584, -248},
    // 48 seconds
    { -1128, 400, -24},
    { -1128, 400, -80},
    { -960, 336, 24},
    { -704, 320, 56},
    { -560, 344, 0},
    { -560, 256, 0},
    { -520, 232, 40},
    { -456, 184, 56},
    { -456, 144, 40},
    { -432, 176, 48},
    { -528, 336, 16},
    { -880, 368, -64},
    { -1256, 328, -80},
    { -1864, 336, -48},
    { -1384, 392, -416},
    { -1064, 104, -160},
    { -904, 104, -184},
    { -464, 16, -312},
    { -280, 152, -272},
    { -360, 272, -208},
    { -504, 400, -232},
    { -744, 432, -128},
    { -936, 424, -56},
    { -800, 432, -112},
    { -864, 448, -216},
    // 49 seconds
    { -1048, 504, -184},
    { -1448, 528, -168},
    { -1568, 536, -272},
    { -1208, 424, -168},
    { -1352, 360, -24},
    { -1272, 288, 0},
    { -912, 320, -16},
    { -544, 320, -40},
    { -392, 312, -40},
    { -424, 312, 16},
    { -384, 176, 88},
    { -408, 96, 112},
    { -496, 152, 64},
    { -640, 224, 104},
    { -872, 256, 56},
    { -1216, 408, 8},
    { -1656, 368, 0},
    { -1328, 568, -296},
    { -992, 360, -176},
    { -960, 112, -176},
    { -752, 288, -224},
    { -496, 384, -208},
    { -352, 328, -272},
    { -408, 448, -152},
    { -464, 400, -160},
    // 50 seconds
    { -552, 352, -144},
    { -624, 368, -160},
    { -736, 408, -184},
    { -968, 416, -160},
    { -1400, 560, -136},
    { -1632, 648, -112},
    { -1376, 696, -168},
    { -1032, 488, -112},
    { -1088, 464, -120},
    { -872, 360, 48},
    { -608, 384, 0},
    { -480, 440, -40},
    { -520, 360, 48},
    { -584, 424, 48},
    { -704, 368, 48},
    { -672, 312, 80},
    { -696, 344, 48},
    { -800, 352, 24},
    { -816, 288, -24},
    { -976, 280, -40},
    { -1072, 280, -88},
    { -1008, 296, -208},
    { -1064, 216, -144},
    { -1024, 296, -184},
    { -792, 240, -216},
    // 51 seconds
    { -600, 264, -232},
    { -576, 312, -248},
    { -584, 312, -232},
    { -624, 456, -304},
    { -776, 488, -320},
    { -816, 512, -296},
    { -928, 464, -320},
    { -1080, 536, -240},
    { -1160, 608, -280},
    { -1328, 624, -200},
    { -1312, 592, -296},
    { -1152, 496, -192},
    { -1296, 408, -128},
    { -1232, 360, -32},
    { -928, 288, 24},
    { -688, 296, 8},
    { -608, 272, 24},
    { -536, 168, 64},
    { -480, 152, 56},
    { -504, 128, 40},
    { -472, 192, -80},
    { -552, 136, 128},
    { -832, 168, 104},
    { -912, 160, -56},
    { -1360, 112, 32},
    // 52 seconds
    { -1528, 344, -152},
    { -1152, 384, -448},
    { -1192, 104, -120},
    { -992, 272, -376},
    { -688, 424, -288},
    { -536, 336, -280},
    { -520, 448, -256},
    { -584, 536, -272},
    { -616, 232, -64},
    { -760, 376, -160},
    { -744, 448, -144},
    { -896, 496, -272},
    { -1136, 512, -240},
    { -1368, 488, -224},
    { -1400, 592, -328},
    { -1408, 480, -232},
    { -1288, 392, -120},
    { -1336, 304, -8},
    { -1144, 248, 96},
    { -824, 208, 56},
    { -600, 192, 16},
    { -512, 192, 48},
    { -496, 144, 96},
    { -504, 72, 128},
    { -528, 128, 88},
    // 53 seconds
    { -544, 144, 0},
    { -696, 176, -8},
    { -912, 208, -48},
    { -1160, 248, -64},
    { -1360, 248, 0},
    { -1344, 424, -248},
    { -1064, 416, -208},
    { -1032, 344, -136},
    { -840, 312, -264},
    { -576, 288, -256},
    { -456, 240, -256},
    { -456, 216, -224},
    { -552, 240, -208},
    { -680, 328, -208},
    { -752, 392, -208},
    { -792, 376, -200},
    { -920, 440, -208},
    { -1144, 472, -136},
    { -1704, 600, -232},
    { -1744, 656, -232},
    { -1056, 384, -72},
    { -1048, 424, -272},
    { -1040, 408, -96},
    { -824, 272, 32},
    { -624, 256, 40},
    // 54 seconds
    { -552, 256, 80},
    { -584, 264, 112},
    { -616, 256, 176},
    { -656, 192, 208},
    { -632, 200, 168},
    { -656, 160, 160},
    { -752, 128, 144},
    { -856, 80, 40},
    { -1104, 96, 40},
    { -1648, 248, -32},
    { -1464, 352, -120},
    { -1328, 296, -320},
    { -1136, 624, -536},
    { -592, 312, -368},
    { -472, 352, -456},
    { -440, 448, -272},
    { -648, 392, -16},
    { -688, 272, -88},
    { -688, 232, 32},
    { -576, 304, -104},
    { -752, 392, -328},
    { -1016, 416, -416},
    { -1352, 360, -248},
    { -1904, 768, -568},
    { -1752, 440, 104},
    // 55 seconds
    { -1352, 384, -168},
    { -1288, 512, -72},
    { -872, 360, 88},
    { -632, 264, 0},
    { -648, 240, 24},
    { -584, 192, 32},
    { -640, 72, 56},
    { -592, 120, 8},
    { -568, 8, 136},
    { -832, 64, 64},
    { -992, 200, -32},
    { -1304, 200, 8},
    { -1336, 224, 24},
    { -1448, 320, -168},
    { -1376, 336, -168},
    { -1152, 344, -136},
    { -752, 408, -488},
    { -512, 440, -352},
    { -376, 312, -224},
    { -344, 352, -352},
    { -536, 368, -200},
    { -752, 608, -272},
    { -760, 144, -264},
    { -1120, 400, -304},
    { -1376, 432, -208},
    // 56 seconds
    { -1392, 504, -112},
    { -1360, 632, -232},
    { -1176, 576, -208},
    { -1128, 520, -136},
    { -1232, 320, 96},
    { -976, 224, 120},
    { -736, 248, 40},
    { -560, 320, 40},
    { -520, 280, 88},
    { -488, 192, 80},
    { -512, 200, 48},
    { -584, 224, 40},
    { -640, 232, 16},
    { -952, 192, 0},
    { -1152, 200, 8},
    { -1328, 224, 80},
    { -1296, 272, 24},
    { -1232, 472, -232},
    { -1168, 400, -216},
    { -896, 264, -192},
    { -608, 328, -280},
    { -368, 368, -248},
    { -296, 376, -216},
    { -384, 360, -208},
    { -480, 288, -160},
    // 57 seconds
    { -656, 336, -160},
    { -800, 416, -184},
    { -896, 440, -160},
    { -1256, 584, -264},
    { -1496, 584, -200},
    { -1392, 664, -264},
    { -1264, 600, -184},
    { -1192, 600, -112},
    { -1088, 400, -32},
    { -832, 304, 24},
    { -568, 296, 16},
    { -536, 296, 0},
    { -528, 232, 88},
    { -504, 136, 88},
    { -576, 136, 64},
    { -736, 208, 32},
    { -944, 192, 88},
    { -1072, 112, 168},
    { -1184, 208, 40},
    { -1240, 256, 24},
    { -1296, 384, -88},
    { -1200, 432, -256},
    { -1112, 256, -104},
    { -752, 328, -312},
    { -488, 256, -296},
    // 58 seconds
    { -360, 288, -248},
    { -328, 336, -248},
    { -384, 408, -256},
    { -472, 344, -280},
    { -848, 576, -192},
    { -1104, 456, -168},
    { -1160, 408, 0},
    { -1456, 576, -112},
    { -1472, 672, -280},
    { -1344, 464, -120},
    { -1336, 400, -64},
    { -1272, 280, 72},
    { -816, 224, 88},
    { -512, 336, 56},
    { -456, 328, 16},
    { -456, 240, 112},
    { -488, 136, 80},
    { -520, 168, 64},
    { -672, 240, 96},
    { -872, 264, 104},
    { -912, 248, 96},
    { -1160, 272, 40},
    { -1400, 328, 32},
    { -1128, 504, -296},
    { -1168, 392, -200},
    // 59 seconds
    { -984, 304, -152},
    { -648, 176, -200},
    { -520, 336, -216},
    { -472, 360, -272},
    { -504, 520, -232},
    { -560, 400, -240},
    { -568, 328, -144},
    { -664, 488, -184},
    { -968, 656, -216},
    { -1056, 536, -24},
    { -1560, 720, -152},
    { -1496, 736, -128},
    { -1232, 456, 8},
    { -1320, 432, 72},
    { -1072, 384, 80},
    { -656, 296, 32},
    { -400, 360, -8},
    { -392, 368, 48},
    { -376, 232, 80},
    { -432, 128, 144},
    { -472, 160, 136},
    { -584, 232, 120},
    { -816, 232, 200},
    { -960, 312, 224},
    { -1184, 368, 104},
    // 60 seconds
    // elapsed: 1 minutes
    { -1408, 456, 40},
    { -1368, 696, -344},
    { -1176, 544, -288},
    { -960, 344, -344},
    { -672, 312, -336},
    { -464, 304, -272},
    { -360, 288, -352},
    { -328, 240, -192},
    { -352, 224, -96},
    { -488, 312, -88},
    { -584, 440, -8},
    { -728, 528, -40},
    { -984, 656, -152},
    { -1288, 672, -144},
    { -1568, 648, -128},
    { -1592, 576, -64},
    { -1224, 408, 112},
    { -1104, 400, -48},
    { -720, 464, -104},
    { -376, 384, -80},
    { -288, 344, -88},
    { -384, 272, -32},
    { -464, 192, 32},
    { -512, 200, 48},
    { -520, 232, 32},
    // 61 seconds
    { -712, 232, 88},
    { -936, 248, 128},
    { -904, 304, 88},
    { -1408, 312, 104},
    { -1416, 520, -152},
    { -1432, 520, -160},
    { -1184, 480, -256},
    { -680, 464, -328},
    { -336, 256, -152},
    { -280, 176, -64},
    { -360, 352, -304},
    { -464, 192, -152},
    { -616, 240, -72},
    { -704, 328, -112},
    { -824, 384, -144},
    { -1000, 400, -128},
    { -1160, 408, -104},
    { -1672, 584, -264},
    { -1584, 656, -256},
    { -1152, 344, 72},
    { -1112, 456, -96},
    { -752, 424, -64},
    { -416, 368, -48},
    { -368, 384, -56},
    { -456, 320, -24},
    // 62 seconds
    { -496, 200, 48},
    { -552, 144, 120},
    { -648, 184, 80},
    { -840, 184, 80},
    { -992, 240, 160},
    { -1432, 240, 280},
    { -1216, 440, 40},
    { -1312, 800, -472},
    { -1376, 536, -160},
    { -960, 184, -80},
    { -616, 224, -256},
    { -368, 400, -264},
    { -320, 344, -288},
    { -328, 256, -200},
    { -368, 232, -184},
    { -528, 288, -192},
    { -792, 328, -160},
    { -1120, 416, -232},
    { -1160, 464, 8},
    { -1568, 480, -320},
    { -1440, 504, -232},
    { -1144, 352, -176},
    { -976, 288, -160},
    { -904, 328, -72},
    { -640, 168, -16},
    // 63 seconds
    { -480, 448, -56},
    { -376, 288, -152},
    { -336, 264, -80},
    { -392, 280, -48},
    { -488, 360, -24},
    { -608, 344, 0},
    { -936, 368, 16},
    { -1240, 376, 48},
    { -1424, 384, 80},
    { -1248, 480, -72},
    { -976, 576, -376},
    { -1016, 512, -416},
    { -968, 392, -216},
    { -664, 240, -296},
    { -416, 224, -264},
    { -288, 208, -408},
    { -296, 144, -448},
    { -392, 248, -144},
    { -400, 368, -168},
    { -496, 592, -408},
    { -728, 584, -384},
    { -936, 512, -312},
    { -1144, 408, -200},
    { -1224, 480, -456},
    { -1296, 448, -560},
    // 64 seconds
    { -1136, 512, -440},
    { -1040, 432, -280},
    { -864, 224, -144},
    { -560, 400, -296},
    { -416, 344, -208},
    { -216, 160, -136},
    { -248, 224, -192},
    { -408, 240, -192},
    { -560, 264, -168},
    { -664, 360, -8},
    { -840, 432, -208},
    { -968, 304, -104},
    { -1464, -112, 16},
    { -1536, -16, -352},
    { -1424, 56, -408},
    { -1160, 64, -336},
    { -816, -48, -328},
    { -432, -48, -224},
    { -296, 176, -320},
    { -288, 208, -304},
    { -408, 248, -208},
    { -560, 112, -112},
    { -728, 200, -216},
    { -832, 352, -96},
    { -872, 288, -104},
    // 65 seconds
    { -1064, 344, -232},
    { -1376, 424, -192},
    { -1352, 456, -480},
    { -1344, 400, -336},
    { -1200, 448, -240},
    { -1048, 320, -208},
    { -768, 304, -144},
    { -480, 360, -192},
    { -376, 344, -240},
    { -360, 200, -144},
    { -384, 184, -72},
    { -512, 224, -80},
    { -680, 256, -80},
    { -1064, 256, -64},
    { -1200, 224, 168},
    { -1144, 328, -32},
    { -1208, 392, -168},
    { -976, 384, -64},
    { -960, 392, -280},
    { -1008, 472, -432},
    { -832, 336, -272},
    { -544, 216, -168},
    { -384, 248, -296},
    { -328, 280, -280},
    { -392, 272, -224},
    // 66 seconds
    { -496, 264, -200},
    { -680, 280, -168},
    { -712, 320, -136},
    { -824, 392, -184},
    { -1152, 480, -280},
    { -1408, 464, -184},
    { -1432, 568, -408},
    { -1208, 600, -360},
    { -1088, 472, -208},
    { -1048, 344, -96},
    { -728, 288, -48},
    { -440, 352, -88},
    { -392, 408, -144},
    { -464, 320, -32},
    { -496, 208, 48},
    { -632, 320, 136},
    { -624, 288, -152},
    { -832, 152, -120},
    { -1072, 312, -72},
    { -1048, 304, -184},
    { -1120, 288, -184},
    { -1096, 432, -224},
    { -1048, 440, -504},
    { -1016, 432, -432},
    { -696, 240, -256},
    // 67 seconds
    { -432, 240, -256},
    { -328, 248, -256},
    { -360, 240, -224},
    { -424, 200, -152},
    { -544, 176, -96},
    { -672, 280, -104},
    { -736, 336, -112},
    { -936, 432, -216},
    { -1136, 392, -136},
    { -1704, 400, -200},
    { -1448, 496, -232},
    { -1160, 432, -144},
    { -1112, 480, -232},
    { -872, 320, -120},
    { -584, 312, -136},
    { -408, 328, -184},
    { -368, 288, -128},
    { -408, 224, -16},
    { -528, 208, -24},
    { -720, 232, 32},
    { -904, 192, 120},
    { -1136, 256, 168},
    { -1032, 344, 32},
    { -1184, 416, -64},
    { -1104, 496, -184},
    // 68 seconds
    { -1048, 440, -304},
    { -1048, 336, -320},
    { -736, 176, -240},
    { -408, 128, -224},
    { -344, 184, -280},
    { -368, 248, -216},
    { -496, 272, -176},
    { -664, 272, -120},
    { -800, 304, -72},
    { -840, 384, -152},
    { -1024, 464, -240},
    { -1056, 352, -96},
    { -1488, 448, -248},
    { -1312, 512, -216},
    { -1160, 392, -48},
    { -1224, 440, -112},
    { -952, 336, -48},
    { -664, 344, -64},
    { -504, 360, -96},
    { -488, 304, -88},
    { -464, 208, 0},
    { -456, 160, 40},
    { -504, 200, 24},
    { -672, 208, 32},
    { -960, 176, 144},
    // 69 seconds
    { -968, 256, 128},
    { -1240, 416, -56},
    { -1440, 552, -168},
    { -1000, 544, -288},
    { -968, 392, -240},
    { -896, 392, -240},
    { -664, 352, -216},
    { -472, 352, -216},
    { -376, 376, -216},
    { -432, 352, -232},
    { -520, 288, -152},
    { -704, 272, -128},
    { -832, 336, -88},
    { -1040, 440, -200},
    { -952, 376, -40},
    { -1440, 416, -176},
    { -1400, 568, -264},
    { -1192, 384, -16},
    { -1144, 416, -96},
    { -896, 368, -96},
    { -616, 312, -32},
    { -432, 328, -80},
    { -416, 328, -80},
    { -424, 240, 8},
    { -448, 192, 56},
    // 70 seconds
    { -512, 208, 80},
    { -712, 288, 16},
    { -1024, 296, 64},
    { -1056, 304, 64},
    { -1312, 352, -40},
    { -1360, 496, -208},
    { -1056, 424, -264},
    { -984, 256, -232},
    { -784, 256, -312},
    { -504, 192, -232},
    { -320, 224, -216},
    { -352, 312, -232},
    { -480, 328, -184},
    { -656, 320, -128},
    { -784, 328, -72},
    { -776, 392, -88},
    { -888, 488, -224},
    { -984, 464, -136},
    { -1416, 472, -200},
    { -1416, 488, -208},
    { -1176, 400, -64},
    { -1152, 496, -160},
    { -984, 480, -120},
    { -680, 328, -8},
    { -480, 320, -24},
    // 71 seconds
    { -456, 288, 88},
    { -528, 288, 96},
    { -576, 288, 56},
    { -544, 208, 128},
    { -520, 216, 112},
    { -704, 280, 48},
    { -1008, 360, -8},
    { -1048, 336, -80},
    { -1352, 112, 56},
    { -1544, 336, -56},
    { -1024, 432, -248},
    { -1104, 128, -168},
    { -888, 168, -152},
    { -600, 288, -208},
    { -416, 376, -240},
    { -432, 352, -176},
    { -528, 352, -128},
    { -664, 360, -24},
    { -792, 400, -32},
    { -816, 424, -80},
    { -976, 504, -240},
    { -1072, 440, -168},
    { -1408, 336, -224},
    { -1376, 416, -304},
    { -1280, 368, -160},
    // 72 seconds
    { -1176, 352, -96},
    { -1032, 352, -72},
    { -760, 344, -16},
    { -496, 304, 16},
    { -432, 272, -16},
    { -464, 216, 16},
    { -456, 128, 72},
    { -528, 144, 16},
    { -616, 136, 56},
    { -816, 144, 48},
    { -1008, 40, 24},
    { -1320, 200, -88},
    { -1680, 224, 112},
    { -1352, 304, -152},
    { -1032, 56, -128},
    { -1136, -88, -72},
    { -864, -144, -40},
    { -544, 104, -112},
    { -440, 240, -264},
    { -496, 336, -240},
    { -672, 336, -224},
    { -776, 240, -96},
    { -872, 328, -120},
    { -960, 528, -248},
    { -1208, 552, -272},
    // 73 seconds
    { -1280, 464, -240},
    { -1624, 480, -312},
    { -1224, 336, -144},
    { -1176, 368, -104},
    { -1344, 392, -56},
    { -1128, 328, -48},
    { -824, 248, 24},
    { -592, 216, 24},
    { -512, 208, 24},
    { -416, 56, 80},
    { -384, -56, 104},
    { -448, -40, 72},
    { -680, -80, 48},
    { -1128, -24, 184},
    { -1496, 328, 80},
    { -1672, 224, 96},
    { -1392, 544, -360},
    { -1032, 272, -80},
    { -1104, -64, -24},
    { -936, -8, -136},
    { -648, 168, -160},
    { -488, 272, -304},
    { -536, 216, -208},
    { -648, 312, -264},
    { -768, 264, -184},
    // 74 seconds
    { -904, 352, -224},
    { -928, 408, -272},
    { -1096, 504, -320},
    { -1232, 368, -200},
    { -1664, 416, -272},
    { -1368, 344, -136},
    { -1168, 328, -96},
    { -1256, 400, -112},
    { -1088, 304, 80},
    { -744, 264, 88},
    { -552, 264, 88},
    { -496, 224, 120},
    { -432, 176, 144},
    { -416, 160, 152},
    { -488, 184, 120},
    { -720, 248, 56},
    { -968, 248, 40},
    { -1048, 176, 112},
    { -1240, 144, 88},
    { -1264, 360, -168},
    { -1160, 352, -224},
    { -1216, 280, -208},
    { -976, 160, -224},
    { -624, 168, -248},
    { -464, 240, -256},
    // 75 seconds
    { -488, 256, -224},
    { -600, 232, -128},
    { -760, 360, -136},
    { -856, 440, -104},
    { -824, 496, -160},
    { -968, 608, -272},
    { -1112, 512, -152},
    { -1424, 520, -256},
    { -1312, 496, -168},
    { -1136, 448, -72},
    { -1120, 496, -88},
    { -1216, 432, 128},
    { -936, 296, 256},
    { -672, 232, 208},
    { -616, 256, 112},
    { -584, 304, 80},
    { -616, 240, 184},
    { -568, 168, 136},
    { -576, 144, 112},
    { -680, 128, 72},
    { -896, 176, 32},
    { -1016, 168, 64},
    { -1384, 184, 64},
    { -1144, 392, -72},
    { -1224, 448, -232},
    // 76 seconds
    { -1288, 448, -208},
    { -896, 136, -128},
    { -608, 200, -200},
    { -504, 384, -232},
    { -480, 416, -176},
    { -576, 320, -96},
    { -712, 280, -24},
    { -768, 376, -120},
    { -856, 488, -232},
    { -1176, 520, -248},
    { -1464, 440, -168},
    { -1488, 480, -200},
    { -1144, 400, -88},
    { -984, 416, -120},
    { -1120, 440, -144},
    { -1040, 328, -8},
    { -824, 240, 0},
    { -712, 240, -8},
    { -624, 176, 40},
    { -528, 184, 32},
    { -536, 176, 56},
    { -552, 144, 88},
    { -680, 144, 96},
    { -864, 144, 120},
    { -880, 176, 88},
    // 77 seconds
    { -1232, 264, 8},
    { -1344, 376, -40},
    { -1296, 424, -168},
    { -1280, 320, -144},
    { -1032, 352, -136},
    { -696, 288, -160},
    { -576, 352, -160},
    { -544, 392, -192},
    { -560, 376, -176},
    { -648, 368, -176},
    { -744, 392, -160},
    { -832, 416, -128},
    { -1056, 592, -272},
    { -1144, 504, -112},
    { -1448, 536, -240},
    { -1368, 528, -240},
    { -1344, 336, -96},
    { -1424, 376, -88},
    { -1608, 336, 112},
    { -1144, 168, 152},
    { -800, -16, 152},
    { -576, 240, 24},
    { -408, 248, 72},
    { -256, 72, 160},
    { -240, -8, 224},
    // 78 seconds
    { -296, 120, 128},
    { -568, 240, 32},
    { -984, 272, 0},
    { -1008, 352, -112},
    { -1480, 232, 24},
    { -1504, 352, -72},
    { -1448, 368, -152},
    { -1296, 328, -56},
    { -960, 360, -144},
    { -712, 344, -152},
    { -584, 336, -152},
    { -544, 384, -192},
    { -528, 368, -208},
    { -608, 344, -224},
    { -704, 344, -176},
    { -856, 448, -224},
    { -1232, 512, -256},
    { -1296, 376, -80},
    { -1560, 456, -256},
    { -1336, 408, -120},
    { -1264, 312, 72},
    { -1344, 304, 104},
    { -1112, 368, 16},
    { -824, 320, 32},
    { -608, 304, 72},
    // 79 seconds
    { -576, 272, 88},
    { -536, 216, 96},
    { -504, 144, 112},
    { -520, 104, 136},
    { -664, 128, 120},
    { -824, 104, 144},
    { -856, 120, 160},
    { -1080, 176, 192},
    { -1184, 360, 24},
    { -1328, 640, -312},
    { -1376, 512, -248},
    { -1136, 288, -112},
    { -744, 136, -224},
    { -576, 264, -256},
    { -464, 352, -208},
    { -480, 368, -192},
    { -528, 296, -168},
    { -656, 296, -160},
    { -752, 344, -136},
    { -920, 416, -168},
    { -1208, 536, -240},
    { -1352, 520, -184},
    { -1496, 528, -336},
    { -1368, 448, -176},
    { -1312, 376, -88},
    // 80 seconds
    { -1376, 336, -64},
    { -1056, 224, 16},
    { -704, 224, -16},
    { -568, 264, -48},
    { -528, 232, 8},
    { -496, 112, 72},
    { -480, 24, 128},
    { -512, 96, 88},
    { -592, 88, 64},
    { -728, -96, 88},
    { -1144, 328, -96},
    { -1520, 488, -56},
    { -1464, 336, -112},
    { -1144, 240, -176},
    { -1032, 200, -120},
    { -936, 184, -304},
    { -280, 288, -912},
    { -408, 384, -1456},
    { -504, 624, -1560},
    { -912, 1040, -1504},
    { -1072, 1120, -1120},
    { -952, 864, -808},
    { -1088, 840, -360},
    { -1008, 408, -64},
    { -664, 392, -104},
    // 81 seconds
    { -1016, 184, -16},
    { -824, 184, 104},
    { -744, 256, 120},
    { -608, 96, 320},
    { -496, 104, 112},
    { -472, 8, 80},
    { -528, 128, 120},
    { -592, 248, 24},
    { -488, 280, -192},
    { -776, 104, 88},
    { -1168, -104, -152},
    { -1136, -240, -320},
    { -1496, -144, -480},
    { -1848, 16, -1392},
    { -1800, 8, -448},
    { -1888, 1512, 136},
    { -840, -608, -32},
    { -832, -592, 184},
    { -808, 184, 336},
    { -424, 432, -16},
    { -320, 280, -24},
    { -288, 312, -88},
    { -384, 216, 64},
    { -424, 448, -656},
    { -832, 888, -616},
    // 82 seconds
    { -968, 880, -536},
    { -1368, 512, -400},
    { -1512, 528, -360},
    { -1960, 520, -80},
    { -1512, 568, -72},
    { -1312, 408, -80},
    { -1144, 256, 8},
    { -760, -88, 152},
    { -496, 72, 8},
    { -368, 40, -32},
    { -280, 80, 16},
    { -304, -72, 40},
    { -328, -24, 96},
    { -456, 88, 96},
    { -592, 160, 192},
    { -880, 8, 192},
    { -1552, 584, -16},
    { -1608, 832, -160},
    { -1952, 1232, 8},
    { -1584, 552, 112},
    { -1352, -320, -192},
    { -1160, 40, -72},
    { -912, 568, -144},
    { -648, 480, -160},
    { -432, 416, -200},
    // 83 seconds
    { -320, 320, -200},
    { -440, 392, -216},
    { -576, 320, -96},
    { -696, 168, 0},
    { -912, 384, -280},
    { -1136, 432, -232},
    { -1296, 312, 0},
    { -1512, 416, -32},
    { -1456, 568, -16},
    { -1376, 464, 88},
    { -1312, 320, 144},
    { -1184, 304, 216},
    { -856, 208, 232},
    { -520, 64, 152},
    { -328, 120, 56},
    { -360, 184, 24},
    { -432, 160, 112},
    { -504, 56, 184},
    { -600, 88, 152},
    { -752, 168, 112},
    { -1048, 224, 64},
    { -1168, 352, 0},
    { -1432, 328, 24},
    { -1408, 568, -200},
    { -1616, 688, -496},
    // 84 seconds
    { -1568, 448, -112},
    { -1112, 104, -32},
    { -696, 264, -160},
    { -368, 472, -128},
    { -248, 512, -160},
    { -240, 432, -104},
    { -408, 360, -80},
    { -632, 424, -152},
    { -888, 504, -72},
    { -1224, 640, -144},
    { -1328, 552, -64},
    { -1408, 504, -216},
    { -1328, 464, -112},
    { -1424, 368, 56},
    { -1400, 336, 120},
    { -1216, 216, 128},
    { -704, -8, 280},
    { -288, 0, 64},
    { -392, 216, -24},
    { -424, 64, 112},
    { -496, 0, 208},
    { -664, 120, 104},
    { -752, 184, 112},
    { -1088, 200, 192},
    { -1192, 248, 160},
    // 85 seconds
    { -1392, 336, 80},
    { -1368, 488, -64},
    { -1232, 696, -256},
    { -1184, 544, -248},
    { -1136, 288, -88},
    { -712, 104, -64},
    { -488, 272, -200},
    { -344, 408, -224},
    { -432, 432, -216},
    { -472, 240, -88},
    { -592, 296, -64},
    { -744, 488, -56},
    { -904, 584, -152},
    { -1208, 496, -56},
    { -1512, 480, -8},
    { -1520, 440, 8},
    { -1192, 408, 104},
    { -1184, 456, -32},
    { -1040, 424, 8},
    { -768, 216, 192},
    { -432, 168, 112},
    { -256, 168, -8},
    { -248, 168, -16},
    { -384, 248, 48},
    { -552, 192, 64},
    // 86 seconds
    { -656, 184, 112},
    { -920, 248, 88},
    { -1248, 296, 128},
    { -1184, 312, 32},
    { -1544, 200, 168},
    { -1432, 520, -184},
    { -1024, 320, -80},
    { -1016, 184, -72},
    { -840, 192, -64},
    { -536, 192, -56},
    { -376, 280, -152},
    { -416, 416, -168},
    { -472, 328, -96},
    { -584, 288, -56},
    { -728, 368, -152},
    { -840, 344, -88},
    { -1152, 448, -152},
    { -1152, 376, 0},
    { -1488, 432, -144},
    { -1544, 488, -144},
    { -1472, 256, 88},
    { -1440, 256, 112},
    { -1072, 272, 152},
    { -640, 320, 32},
    { -408, 264, 40},
    // 87 seconds
    { -312, 248, 24},
    { -328, 160, 64},
    { -320, 104, 112},
    { -400, 120, 96},
    { -552, 176, 120},
    { -840, 192, 160},
    { -944, 272, 104},
    { -1496, 376, 120},
    { -1968, 1064, -464},
    { -1472, 584, 248},
    { -968, -88, -120},
    { -968, -8, -176},
    { -504, 176, -208},
    { -328, 160, -240},
    { -360, 224, -128},
    { -472, 296, -40},
    { -616, 360, -48},
    { -696, 448, -56},
    { -736, 488, -56},
    { -1008, 520, -112},
    { -1248, 456, 64},
    { -1664, 552, -32},
    { -1360, 592, -120},
    { -1200, 488, -16},
    { -1248, 464, -80},
    // 88 seconds
    { -1144, 344, 32},
    { -808, 280, 48},
    { -656, 312, 0},
    { -472, 232, -8},
    { -352, 112, 40},
    { -368, 80, 24},
    { -472, 120, 88},
    { -576, 168, 128},
    { -880, 192, 176},
    { -1016, 280, 120},
    { -1192, 352, -32},
    { -1472, 208, 32},
    { -1232, 208, 40},
    { -1184, 280, -144},
    { -1072, 320, -272},
    { -784, 248, -200},
    { -568, 256, -192},
    { -512, 336, -232},
    { -528, 376, -176},
    { -600, 360, -168},
    { -704, 360, -144},
    { -760, 384, -104},
    { -856, 472, -184},
    { -1104, 488, -176},
    { -1360, 432, -160},
    // 89 seconds
    { -1536, 536, -232},
    { -1520, 408, 16},
    { -1384, 352, 0},
    { -1432, 296, 56},
    { -1064, 288, 40},
    { -768, 232, 32},
    { -544, 120, 24},
    { -440, 96, 32},
    { -344, 48, 32},
    { -424, 24, 96},
    { -464, 24, 136},
    { -728, 160, 144},
    { -1064, 240, 200},
    { -1200, 272, 168},
    { -1376, 304, 40},
    { -1400, 400, 32},
    { -1296, 464, -144},
    { -1248, 336, -96},
    { -1008, 288, -168},
    { -664, 304, -168},
    { -528, 416, -304},
    { -440, 368, -240},
    { -456, 352, -192},
    { -560, 392, -176},
    { -680, 432, -136},
    // 90 seconds
    { -856, 480, -88},
    { -1104, 600, -176},
    { -1360, 560, -48},
    { -1592, 512, -128},
    { -1464, 328, 40},
    { -1416, 352, 64},
    { -1456, 352, 120},
    { -1120, 320, 104},
    { -808, 272, 64},
    { -568, 168, 112},
    { -472, 152, 88},
    { -456, 96, 128},
    { -400, 40, 152},
    { -464, 96, 144},
    { -648, 192, 96},
    { -960, 336, 128},
    { -880, 48, 184},
    { -1352, 280, -8},
    { -1336, 456, -64},
    { -1328, 600, -216},
    { -1296, 480, -216},
    { -1104, 264, -88},
    { -784, 136, -8},
    { -544, 280, -96},
    { -440, 408, -160},
    // 91 seconds
    { -424, 456, -184},
    { -440, 384, -152},
    { -584, 368, -88},
    { -880, 464, -104},
    { -1168, 584, -80},
    { -1264, 616, -40},
    { -1344, 584, -96},
    { -1424, 640, -160},
    { -1384, 432, -8},
    { -1288, 392, -8},
    { -1240, 408, 24},
    { -968, 336, 96},
    { -752, 304, 40},
    { -680, 296, 56},
    { -640, 208, 120},
    { -600, 152, 152},
    { -480, 112, 160},
    { -288, -48, 200},
    { -368, 144, 88},
    { -760, 88, 8},
    { -976, 40, 56},
    { -1624, 64, 144},
    { -2008, 272, 104},
    { -1568, 648, -248},
    { -1208, 240, -104},
    // 92 seconds
    { -1024, 216, -208},
    { -696, 168, -168},
    { -552, 328, -264},
    { -560, 368, -200},
    { -608, 384, -136},
    { -680, 424, -144},
    { -768, 496, -192},
    { -824, 552, -136},
    { -1016, 672, -216},
    { -1304, 592, -72},
    { -1632, 632, -168},
    { -1480, 536, -152},
    { -1264, 400, -40},
    { -1400, 336, -104},
    { -1344, 256, 32},
    { -1080, 224, 120},
    { -856, 264, 80},
    { -696, 200, 128},
    { -568, 136, 112},
    { -480, 72, 112},
    { -456, 16, 128},
    { -520, 24, 112},
    { -832, 64, 136},
    { -992, -16, 264},
    { -1200, 224, 88},
    // 93 seconds
    { -1392, 280, 96},
    { -1384, 432, -80},
    { -1184, 528, -216},
    { -1296, 328, -16},
    { -1096, 392, -112},
    { -752, 368, -160},
    { -632, 464, -224},
    { -584, 480, -200},
    { -552, 464, -192},
    { -600, 440, -232},
    { -744, 528, -304},
    { -904, 536, -240},
    { -1088, 584, -208},
    { -1248, 552, -112},
    { -1664, 632, -200},
    { -1648, 496, -40},
    { -1568, 224, 216},
    { -1496, 160, 232},
    { -1128, 256, 232},
    { -696, 312, 176},
    { -424, 264, 88},
    { -368, 272, 104},
    { -280, 96, 192},
    { -272, 0, 216},
    { -520, 128, 168},
    // 94 seconds
    { -816, 224, 40},
    { -1208, 288, 128},
    { -1040, 152, 200},
    { -1528, 112, 72},
    { -1584, 456, -112},
    { -1144, 288, -176},
    { -1088, 112, -128},
    { -872, 256, -168},
    { -592, 208, -152},
    { -512, 288, -184},
    { -456, 376, -144},
    { -600, 456, -160},
    { -776, 552, -312},
    { -1008, 520, -216},
    { -1016, 480, -176},
    { -1088, 464, -120},
    { -1360, 576, -224},
    { -1544, 584, -128},
    { -1480, 400, 64},
    { -1368, 280, 104},
    { -1424, 352, 80},
    { -1088, 280, 192},
    { -640, 296, -16},
    { -648, 320, 24},
    { -648, 240, 96},
    // 95 seconds
    { -552, 160, 112},
    { -520, 112, 128},
    { -576, 264, 64},
    { -704, 264, 144},
    { -792, 208, 224},
    { -848, 440, 48},
    { -1016, 368, 416},
    { -1176, 984, -328},
    { -904, 1232, -248},
    { -816, -8, 176},
    { -880, 752, -224},
    { -344, 520, -80},
    { -352, 344, -144},
    { -480, 576, -144},
    { -568, 384, 0},
    { -856, 440, 16},
    { -912, 576, 0},
    { -832, 584, -168},
    { -1056, 464, -72},
    { -1088, 384, 64},
    { -1400, 536, -184},
    { -1088, 472, -80},
    { -1064, 464, -32},
    { -1184, 432, -24},
    { -928, 472, 88},
    // 96 seconds
    { -648, 384, 40},
    { -464, 400, -48},
    { -408, 392, 56},
    { -464, 272, 88},
    { -528, 312, 64},
    { -656, 368, 56},
    { -792, 280, 120},
    { -984, 144, 152},
    { -1032, 344, 176},
    { -1184, 240, -328},
    { -1160, 408, -88},
    { -1184, 608, -312},
    { -992, 416, -352},
    { -896, 312, -88},
    { -656, 208, -168},
    { -432, 192, -144},
    { -328, 160, -144},
    { -376, 168, -128},
    { -528, 208, -88},
    { -696, 296, -160},
    { -736, 312, -184},
    { -784, 408, -240},
    { -1024, 424, -328},
    { -1088, 376, -200},
    { -1472, 408, -248},
    // 97 seconds
    { -1416, 496, -224},
    { -1232, 536, -184},
    { -1256, 528, -208},
    { -984, 296, -72},
    { -696, 240, -72},
    { -512, 232, -80},
    { -440, 320, -16},
    { -416, 232, -56},
    { -368, 176, 0},
    { -368, 144, -72},
    { -544, 264, -88},
    { -872, 336, 8},
    { -1056, 208, 72},
    { -1400, 304, 216},
    { -1496, 392, 32},
    { -1152, 464, -320},
    { -1008, 224, -200},
    { -912, 64, -160},
    { -704, 120, -144},
    { -536, 240, -192},
    { -536, 320, -248},
    { -592, 320, -176},
    { -728, 408, -128},
    { -824, 512, -176},
    { -816, 440, -160},
    // 98 seconds
    { -944, 456, -264},
    { -1104, 496, -152},
    { -1280, 504, -328},
    { -1440, 528, -136},
    { -1288, 464, -96},
    { -1264, 432, -112},
    { -1408, 376, -32},
    { -1096, 192, 96},
    { -696, 72, 88},
    { -528, 176, -48},
    { -472, 120, 8},
    { -440, -24, 72},
    { -528, 0, 104},
    { -864, 112, 168},
    { -976, 32, 280},
    { -992, 104, 232},
    { -1152, 184, 24},
    { -1264, 336, 192},
    { -1264, 512, -120},
    { -1312, 672, -256},
    { -1256, 736, -256},
    { -728, 640, -320},
    { -552, 360, -432},
    { -544, 360, -136},
    { -552, 360, -200},
    // 99 seconds
    { -584, 408, -176},
    { -608, 408, -192},
    { -784, 376, -72},
    { -968, 448, -80},
    { -1096, 416, 48},
    { -1296, 440, -32},
    { -1280, 584, -64},
    { -1360, 488, 32},
    { -1304, 520, 56},
    { -1256, 512, 128},
    { -872, 360, 80},
    { -624, 336, 16},
    { -528, 280, 24},
    { -408, 128, 40},
    { -376, 48, 48},
    { -504, 192, 24},
    { -656, 176, 104},
    { -728, 176, 24},
    { -936, 104, 112},
    { -880, 192, -56},
    { -1536, 136, 80},
    { -1448, 128, 184},
    { -1392, 544, -56},
    { -1104, 416, 32},
    { -856, 232, 0},
    // 100 seconds
    { -616, 208, -32},
    { -512, 320, -88},
    { -472, 336, -56},
    { -592, 432, -136},
    { -768, 496, -176},
    { -936, 512, -160},
    { -936, 504, -120},
    { -1024, 568, -256},
    { -1088, 480, -120},
    { -1408, 416, -152},
    { -1464, 480, -120},
    { -1424, 408, 40},
    { -1320, 352, 112},
    { -1184, 320, 40},
    { -960, 248, 88},
    { -640, 216, 136},
    { -536, 232, 112},
    { -480, 200, 128},
    { -416, 96, 144},
    { -456, 152, 96},
    { -640, 232, 168},
    { -952, 248, 256},
    { -952, 144, 72},
    { -1040, 144, -16},
    { -1464, 256, -64},
    // 101 seconds
    { -1448, 344, -56},
    { -1336, 392, -296},
    { -1064, 408, -272},
    { -688, 248, -200},
    { -440, 232, -168},
    { -376, 224, -208},
    { -384, 16, -72},
    { -648, 536, -288},
    { -832, 592, -168},
    { -856, 312, -8},
    { -928, 640, -248},
    { -1160, 672, -224},
    { -1376, 632, -344},
    { -1328, 648, -360},
    { -1360, 608, -352},
    { -1192, 480, -416},
    { -1080, 464, -232},
    { -864, 304, 16},
    { -608, 320, 24},
    { -528, 328, 48},
    { -520, 240, 128},
    { -512, 264, 112},
    { -592, 304, 88},
    { -584, 272, 64},
    { -672, 280, 80},
    // 102 seconds
    { -776, 296, -112},
    { -784, 368, -288},
    { -1064, 344, -200},
    { -1360, 168, 72},
    { -1304, 264, -72},
    { -1064, 320, -208},
    { -840, 280, -192},
    { -600, 232, -200},
    { -440, 144, -144},
    { -432, 184, -168},
    { -512, 232, -144},
    { -648, 360, -136},
    { -832, 392, -152},
    { -872, 480, -264},
    { -1048, 528, -264},
    { -1152, 632, -312},
    { -1304, 608, -344},
    { -1272, 632, -344},
    { -1256, 568, -264},
    { -1400, 536, -168},
    { -1392, 416, 8},
    { -1056, 288, 104},
    { -728, 320, 32},
    { -600, 288, 56},
    { -464, 200, 32},
    // 103 seconds
    { -480, 152, 80},
    { -472, 32, 88},
    { -480, 56, 152},
    { -712, 104, 112},
    { -960, 128, 128},
    { -880, 176, -56},
    { -1536, 256, 80},
    { -1448, 320, 8},
    { -1256, 384, -272},
    { -1224, 248, -96},
    { -928, 344, -328},
    { -536, 256, -304},
    { -440, 280, -256},
    { -448, 352, -240},
    { -528, 328, -168},
    { -648, 360, -192},
    { -680, 512, -256},
    { -768, 512, -192},
    { -1000, 592, -248},
    { -1248, 584, -88},
    { -1584, 712, -216},
    { -1304, 712, -160},
    { -1352, 464, -32},
    { -1328, 456, -40},
    { -1240, 336, 72},
    // 104 seconds
    { -936, 288, 56},
    { -640, 128, 80},
    { -512, 184, 8},
    { -448, 112, 32},
    { -448, 24, 72},
    { -464, -48, 136},
    { -608, 64, 80},
    { -864, 24, 152},
    { -888, 72, 80},
    { -952, 264, -168},
    { -1520, 208, 80},
    { -1648, 336, 40},
    { -1336, 392, -176},
    { -1144, 352, -32},
    { -864, 448, -136},
    { -616, 480, -200},
    { -496, 432, -160},
    { -464, 400, -184},
    { -504, 472, -192},
    { -640, 424, -184},
    { -800, 440, -208},
    { -920, 424, -184},
    { -1128, 592, -296},
    { -1240, 536, -160},
    { -1704, 616, -272},
    // 105 seconds
    { -1544, 456, -160},
    { -1448, 304, 16},
    { -1448, 336, 16},
    { -1048, 368, 24},
    { -704, 296, 32},
    { -584, 200, 104},
    { -568, 152, 88},
    { -528, 96, 144},
    { -480, 48, 160},
    { -544, 80, 128},
    { -584, 88, 120},
    { -792, 0, 144},
    { -848, 104, 40},
    { -1496, 144, 120},
    { -1512, 280, 24},
    { -1392, 440, -152},
    { -1344, 376, -152},
    { -1096, 448, -264},
    { -720, 392, -264},
    { -576, 392, -304},
    { -520, 384, -248},
    { -520, 384, -240},
    { -536, 416, -288},
    { -640, 480, -320},
    { -896, 528, -296},
    // 106 seconds
    { -1160, 576, -248},
    { -1360, 520, -128},
    { -1664, 608, -240},
    { -1448, 576, -224},
    { -1200, 448, -120},
    { -1304, 352, -144},
    { -1216, 320, 0},
    { -944, 240, 80},
    { -680, 224, 104},
    { -592, 224, 120},
    { -544, 176, 144},
    { -504, 112, 136},
    { -480, 112, 80},
    { -488, 80, 128},
    { -664, 72, 144},
    { -784, 144, 72},
    { -888, 288, -112},
    { -1440, 200, -16},
    { -1504, 336, -96},
    { -1304, 240, -200},
    { -1376, 232, -184},
    { -1016, 184, -376},
    { -704, 32, -272},
    { -568, 120, -320},
    { -560, 208, -312},
    // 107 seconds
    { -624, 208, -288},
    { -672, 240, -256},
    { -768, 304, -328},
    { -888, 280, -328},
    { -1072, 256, -288},
    { -1104, 200, -152},
    { -1616, 288, -256},
    { -1592, 256, -168},
    { -1240, 184, -88},
    { -1208, 200, -96},
    { -1288, 256, -8},
    { -936, 184, 88},
    { -624, 168, 8},
    { -504, 216, -16},
    { -432, 64, 40},
    { -448, 64, 40},
    { -456, 104, 64},
    { -584, 128, -8},
    { -672, 128, 8},
    { -1096, 128, 0},
    { -1120, 72, -48},
    { -1704, 96, 40},
    { -1536, 216, -80},
    { -1016, 224, -184},
    { -1032, 160, -128},
    // 108 seconds
    { -872, 264, -168},
    { -624, 288, -192},
    { -464, 344, -280},
    { -512, 344, -264},
    { -592, 344, -288},
    { -704, 376, -272},
    { -848, 440, -248},
    { -832, 480, -216},
    { -1008, 568, -336},
    { -1224, 496, -200},
    { -1416, 424, -240},
    { -1520, 504, -264},
    { -1200, 368, -96},
    { -1216, 280, 24},
    { -1304, 336, 40},
    { -1048, 304, 104},
    { -712, 264, 80},
    { -576, 272, 80},
    { -520, 264, 72},
    { -376, 128, 112},
    { -336, 72, 16},
    { -408, 120, -72},
    { -624, 168, -88},
    { -960, 200, -24},
    { -1272, 296, -120},
    // 109 seconds
    { -1440, 240, -48},
    { -1400, 384, -248},
    { -968, 248, -200},
    { -960, 256, -216},
    { -768, 256, -208},
    { -672, 120, -136},
    { -712, 264, -136},
    { -712, 336, -144},
    { -736, 368, -144},
    { -752, 416, -184},
    { -688, 456, -208},
    { -736, 512, -264},
    { -1080, 592, -320},
    { -1216, 432, -136},
    { -1696, 600, -304},
    { -1376, 504, -184},
    { -976, 376, -232},
    { -1208, 432, -264},
    { -1288, 368, -160},
    { -1088, 184, -24},
    { -856, 192, -56},
    { -736, 232, -80},
    { -632, 144, -56},
    { -504, 32, -40},
    { -472, 8, -40},
    // 110 seconds
    { -456, -96, 64},
    { -616, -48, 24},
    { -1008, -16, 96},
    { -960, 144, 40},
    { -1664, 232, 104},
    { -1840, 296, 112},
    { -1416, 424, -192},
    { -1224, -24, 112},
    { -1008, 240, -112},
    { -664, 400, -80},
    { -480, 472, -112},
    { -440, 392, -72},
    { -528, 360, 8},
    { -736, 432, -16},
    { -920, 504, 40},
    { -744, 552, -72},
    { -1072, 640, -256},
    { -1128, 560, -160},
    { -1336, 496, -288},
    { -1216, 456, -304},
    { -1088, 440, -352},
    { -1400, 336, -280},
    { -1552, 256, -104},
    { -1432, 168, -24},
    { -1112, 256, -56},
    // 111 seconds
    { -880, 296, -96},
    { -632, 264, -88},
    { -672, 352, -56},
    { -504, 240, 80},
    { -384, 176, 80},
    { -336, 104, 56},
    { -360, 168, 8},
    { -560, 352, -32},
    { -664, 448, -232},
    { -1024, 376, -48},
    { -1216, 432, -136},
    { -1288, 512, -272},
    { -1360, 536, -192},
    { -1008, 552, -128},
    { -688, 424, -160},
    { -648, 368, -64},
    { -632, 416, -80},
    { -680, 456, -88},
    { -704, 456, -88},
    { -752, 488, -136},
    { -744, 520, -144},
    { -824, 584, -224},
    { -1160, 608, -192},
    { -1520, 616, -224},
    { -1512, 576, -192},
    // 112 seconds
    { -1200, 392, -72},
    { -1160, 392, -112},
    { -1232, 416, -48},
    { -1088, 360, 64},
    { -872, 272, 64},
    { -720, 128, 144},
    { -608, 120, 128},
    { -536, 48, 128},
    { -488, -40, 136},
    { -496, 8, 120},
    { -856, 88, 72},
    { -1096, -16, 160},
    { -1216, 144, -8},
    { -1568, 160, 64},
    { -1304, 320, -72},
    { -1200, 296, -64},
    { -1136, 184, -56},
    { -904, 240, -120},
    { -696, 320, -200},
    { -616, 376, -216},
    { -616, 400, -200},
    { -656, 416, -248},
    { -696, 392, -208},
    { -712, 456, -240},
    { -840, 536, -304},
    // 113 seconds
    { -1200, 592, -288},
    { -1504, 520, -296},
    { -1792, 560, -280},
    { -1256, 296, 16},
    { -1232, 344, -80},
    { -1424, 416, -56},
    { -1200, 272, 136},
    { -888, 192, 136},
    { -656, 128, 144},
    { -584, 192, 128},
    { -504, 72, 88},
    { -448, 24, -88},
    { -584, 16, 216},
    { -752, 64, 248},
    { -904, -48, 216},
    { -1112, 48, 144},
    { -1520, 176, 8},
    { -1400, 368, -184},
    { -1200, 392, -376},
    { -1192, 168, -88},
    { -1096, 296, -192},
    { -816, 376, -256},
    { -616, 432, -264},
    { -544, 424, -232},
    { -528, 336, -216},
    // 114 seconds
    { -592, 320, -216},
    { -648, 360, -200},
    { -688, 368, -128},
    { -1024, 480, -240},
    { -1224, 456, -40},
    { -1568, 512, -136},
    { -1536, 560, -128},
    { -1112, 416, 16},
    { -1144, 432, -112},
    { -1176, 384, 8},
    { -976, 248, 104},
    { -744, 248, 64},
    { -664, 248, 88},
    { -632, 216, 112},
    { -568, 152, 144},
    { -528, 112, 136},
    { -536, 136, 128},
    { -816, 168, 80},
    { -880, 96, 72},
    { -872, 112, -40},
    { -1456, 136, -8},
    { -1568, 320, -40},
    { -1088, 272, -160},
    { -1080, 176, -128},
    { -968, 240, -216},
    // 115 seconds
    { -768, 288, -160},
    { -632, 440, -248},
    { -568, 344, -192},
    { -592, 400, -192},
    { -688, 400, -168},
    { -784, 376, -120},
    { -704, 408, -136},
    { -776, 448, -192},
    { -1008, 528, -176},
    { -1320, 456, -160},
    { -1704, 568, -168},
    { -1328, 408, -56},
    { -1400, 320, -80},
    { -1504, 376, 32},
    { -1264, 360, 88},
    { -904, 264, 56},
    { -760, 224, 104},
    { -640, 176, 128},
    { -600, 120, 144},
    { -520, 48, 112},
    { -496, -8, 136},
    { -552, 32, 128},
    { -648, -8, 96},
    { -816, 88, 24},
    { -1232, 208, -8},
    // 116 seconds
    { -1592, 288, 16},
    { -1720, 528, -176},
    { -1640, 456, -112},
    { -1160, 432, -88},
    { -776, 336, -200},
    { -680, 384, -168},
    { -544, 464, -208},
    { -536, 488, -272},
    { -576, 392, -152},
    { -664, 456, -168},
    { -728, 504, -112},
    { -1000, 648, -208},
    { -1280, 584, -104},
    { -1664, 464, -216},
    { -1536, 400, -64},
    { -1536, 352, 24},
    { -1416, 344, 80},
    { -1320, 336, 24},
    { -1104, 264, 136},
    { -776, 104, 184},
    { -584, 152, 104},
    { -536, 136, 144},
    { -472, 144, 120},
    { -472, 104, 128},
    { -504, 152, 120},
    // 117 seconds
    { -608, 176, 96},
    { -760, 192, 96},
    { -1008, 192, 16},
    { -1504, 184, 160},
    { -1560, 368, -112},
    { -1680, 528, -432},
    { -1352, 360, -248},
    { -832, 160, -248},
    { -712, 384, -360},
    { -656, 424, -360},
    { -632, 296, -216},
    { -592, 280, -168},
    { -944, 368, -184},
    { -888, 352, -80},
    { -744, 304, -48},
    { -712, 384, -120},
    { -728, 352, -80},
    { -736, 272, -64},
    { -704, 272, -72},
    { -656, 296, -72},
    { -680, 320, -96},
    { -696, 328, -128},
    { -1544, 312, -168},
    { -2136, 680, -248},
    { -976, 160, 224},
    // 118 seconds
    { -728, 184, -144},
    { -864, 576, -208},
    { -832, 400, 16},
    { -784, 192, 136},
    { -792, 200, 192},
    { -768, 336, 216},
    { -784, 344, 200},
    { -824, 344, 200},
    { -784, 376, 192},
    { -680, 376, 112},
    { -744, 488, 8},
    { -896, 600, -152},
    { -920, 664, -232},
    { -768, 968, -296},
    { -704, 952, -336},
    { -624, 976, -560},
    { -464, 736, -536},
    { -328, 664, -616},
    { -288, 552, -624},
    { -176, 432, -552},
    { -112, 176, -552},
    { -96, 288, -704},
    { -144, 224, -824},
    { -288, 120, -704},
    { -280, 0, -824},
    // 119 seconds
    { -232, 24, -720},
    { -216, -136, -736},
    { -200, -96, -800},
    { -144, -184, -768},
    { -112, -160, -856},
    { -72, -232, -848},
    { -24, -264, -856},
    { -32, -272, -872},
    { -40, -320, -864},
    { -64, -328, -880},
    { -88, -272, -936},
    { -88, -320, -896},
    { -128, -280, -944},
    { -176, -280, -944},
    { -152, -280, -920},
    { -128, -280, -880},
    { -112, -328, -856},
    { -112, -320, -880},
    { -128, -304, -864},
    { -136, -320, -880},
    { -128, -304, -872},
    { -112, -312, -856},
    { -120, -256, -880},
    { -128, -272, -872},
    { -128, -264, -904},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:01:43 local
AccelRawData *activity_sample_walk_200_pbl_25657_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25657_9
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -320, -264, -840},
    { 24, -352, -888},
    { -328, -224, -856},
    { -200, -240, -864},
    { -232, -344, -864},
    { -232, -288, -856},
    { -184, -288, -880},
    { -184, -336, -888},
    { -192, -224, -864},
    { -248, -272, -896},
    { -216, -288, -904},
    { -152, -200, -904},
    { -208, -256, -888},
    { -208, -248, -888},
    { -240, -240, -848},
    { -232, -256, -872},
    { -224, -240, -864},
    { -240, -240, -864},
    { -232, -248, -864},
    { -232, -232, -864},
    { -240, -224, -880},
    { -232, -256, -864},
    { -256, -272, -880},
    { -200, -264, -872},
    { -224, -216, -872},
    // 1 seconds
    { -256, -296, -864},
    { -168, -216, -840},
    { -224, -272, -880},
    { -168, -352, -864},
    { -248, -400, -880},
    { -104, -264, -920},
    { -216, -328, -912},
    { 8, -280, -880},
    { -344, -288, -696},
    { -208, -272, -736},
    { -64, -272, -752},
    { -48, -304, -848},
    { -24, -256, -928},
    { -56, -232, -992},
    { -96, -248, -920},
    { -120, -240, -840},
    { -104, -256, -832},
    { -104, -240, -792},
    { -112, -184, -888},
    { -32, -312, -752},
    { -280, -128, -992},
    { -288, -144, -1024},
    { -320, 192, -1288},
    { -360, 16, -968},
    { -312, 296, -816},
    // 2 seconds
    { -256, 424, -1056},
    { -424, 368, -832},
    { -384, 376, -736},
    { -288, 520, -688},
    { -216, 384, -560},
    { -176, 344, -520},
    { -136, 288, -488},
    { -184, 248, -488},
    { -264, 256, -440},
    { -352, 136, -320},
    { -608, 232, -376},
    { -1144, 600, -400},
    { -1744, 736, -336},
    { -1600, 544, -320},
    { -1000, 760, -256},
    { -400, 656, -536},
    { -952, 1048, -264},
    { -568, 176, -48},
    { -376, 272, -56},
    { -328, 264, -136},
    { -400, 208, -120},
    { -512, 472, -96},
    { -624, 528, 56},
    { -704, 520, -80},
    { -696, 696, -120},
    // 3 seconds
    { -984, 896, -104},
    { -1096, 776, -64},
    { -1296, 984, -72},
    { -984, 856, 96},
    { -976, 776, 48},
    { -808, 728, 184},
    { -512, 528, 120},
    { -240, 440, 80},
    { -216, 464, 96},
    { -336, 392, 176},
    { -384, 304, 232},
    { -472, 464, 184},
    { -616, 456, 168},
    { -800, 504, 176},
    { -1040, 528, 216},
    { -1064, 544, 136},
    { -1184, 608, 192},
    { -992, 680, 56},
    { -984, 768, -224},
    { -816, 672, -56},
    { -544, 480, 16},
    { -296, 480, 8},
    { -176, 472, -24},
    { -240, 416, 8},
    { -336, 496, 80},
    // 4 seconds
    { -560, 528, 128},
    { -696, 672, 144},
    { -904, 696, 136},
    { -1000, 776, 112},
    { -1216, 832, 0},
    { -1456, 896, 112},
    { -1152, 744, 80},
    { -992, 744, 72},
    { -928, 552, 288},
    { -456, 368, 360},
    { -224, 304, 200},
    { -360, 368, 96},
    { -368, 344, 120},
    { -528, 256, 200},
    { -544, 192, 120},
    { -640, 304, 56},
    { -832, 376, 32},
    { -912, 360, 0},
    { -1248, 504, 0},
    { -1512, 640, -48},
    { -1392, 736, 72},
    { -976, 616, -24},
    { -768, 608, -48},
    { -416, 512, -8},
    { -216, 440, 8},
    // 5 seconds
    { -192, 456, -16},
    { -264, 376, 96},
    { -408, 440, 120},
    { -584, 544, 152},
    { -600, 528, 216},
    { -728, 648, 48},
    { -912, 728, 40},
    { -1048, 624, 80},
    { -1448, 1048, -184},
    { -1272, 760, 16},
    { -1288, 512, -80},
    { -1096, 832, -176},
    { -712, 488, -40},
    { -360, 408, 0},
    { -288, 288, 56},
    { -288, 256, 136},
    { -352, 248, 200},
    { -480, 408, 144},
    { -600, 440, 104},
    { -752, 456, 128},
    { -1000, 480, 112},
    { -936, 512, 24},
    { -1144, 584, -112},
    { -1112, 608, -48},
    { -976, 640, -272},
    // 6 seconds
    { -896, 584, -176},
    { -608, 568, -184},
    { -360, 440, -96},
    { -216, 456, -112},
    { -224, 424, -64},
    { -360, 448, -56},
    { -560, 512, 40},
    { -696, 544, 40},
    { -728, 544, 80},
    { -880, 648, -24},
    { -1024, 624, 8},
    { -1280, 648, 16},
    { -1280, 928, -72},
    { -1088, 768, -64},
    { -992, 728, 32},
    { -776, 536, 184},
    { -416, 424, 72},
    { -296, 456, 16},
    { -320, 408, 88},
    { -384, 336, 192},
    { -448, 400, 160},
    { -560, 472, 152},
    { -712, 504, 128},
    { -960, 568, 144},
    { -928, 544, 96},
    // 7 seconds
    { -1304, 632, 80},
    { -1128, 696, 56},
    { -960, 704, -160},
    { -896, 680, -136},
    { -560, 520, -48},
    { -296, 240, 16},
    { -256, 344, -24},
    { -232, 368, -80},
    { -336, 408, 120},
    { -480, 544, 144},
    { -648, 728, 24},
    { -688, 712, 168},
    { -888, 816, 128},
    { -872, 784, 128},
    { -1224, 944, 64},
    { -1080, 800, 240},
    { -824, 736, 88},
    { -808, 752, 72},
    { -720, 504, 256},
    { -392, 448, 200},
    { -296, 432, 72},
    { -312, 456, 128},
    { -376, 328, 128},
    { -496, 584, 88},
    { -624, 448, 56},
    // 8 seconds
    { -736, 592, -24},
    { -1072, 616, -40},
    { -1088, 624, -40},
    { -1264, 304, -16},
    { -1048, 504, -200},
    { -1040, 384, -224},
    { -960, 184, -168},
    { -584, 224, -152},
    { -320, 232, -208},
    { -280, 280, -208},
    { -336, 304, -176},
    { -520, 328, -112},
    { -728, 496, -96},
    { -792, 392, -48},
    { -872, 432, -128},
    { -1024, 464, -160},
    { -1032, 448, -192},
    { -1440, 504, -176},
    { -1144, 664, -256},
    { -1224, 608, -176},
    { -1088, 576, -104},
    { -672, 424, -56},
    { -344, 392, -80},
    { -288, 360, -104},
    { -344, 296, -32},
    // 9 seconds
    { -464, 320, 40},
    { -584, 392, 112},
    { -624, 392, 104},
    { -720, 448, 64},
    { -1008, 488, 96},
    { -1024, 488, 56},
    { -1224, 464, 40},
    { -1176, 608, -80},
    { -1032, 544, -152},
    { -920, 544, -256},
    { -632, 392, -264},
    { -328, 224, -208},
    { -176, 160, -264},
    { -312, 264, -232},
    { -520, 368, -168},
    { -768, 464, -128},
    { -816, 480, -48},
    { -768, 496, -64},
    { -968, 592, -152},
    { -1000, 536, -56},
    { -1440, 648, -104},
    { -1224, 752, -192},
    { -1136, 568, -104},
    { -968, 624, -112},
    { -760, 472, -48},
    // 10 seconds
    { -488, 384, 8},
    { -392, 352, 32},
    { -376, 336, 40},
    { -456, 328, 96},
    { -520, 248, 72},
    { -568, 288, 24},
    { -728, 336, 8},
    { -1056, 304, 120},
    { -1080, 408, -8},
    { -1352, 464, 32},
    { -1184, 576, -152},
    { -1008, 528, -216},
    { -960, 528, -176},
    { -704, 352, -192},
    { -408, 272, -216},
    { -240, 264, -192},
    { -256, 296, -176},
    { -408, 344, -144},
    { -592, 352, -88},
    { -864, 464, -80},
    { -872, 448, -64},
    { -1024, 560, -168},
    { -1080, 544, -136},
    { -1488, 608, -168},
    { -1216, 664, -248},
    // 11 seconds
    { -952, 512, -104},
    { -944, 552, -136},
    { -736, 376, 32},
    { -368, 296, 40},
    { -344, 352, -56},
    { -400, 296, 56},
    { -504, 264, 104},
    { -632, 328, 80},
    { -696, 368, 48},
    { -800, 392, 24},
    { -1064, 400, 48},
    { -976, 400, -40},
    { -1440, 456, 24},
    { -1184, 528, -160},
    { -1120, 496, -288},
    { -1032, 344, -224},
    { -632, 224, -184},
    { -288, 192, -192},
    { -232, 232, -208},
    { -328, 272, -160},
    { -464, 312, -96},
    { -720, 400, -64},
    { -848, 488, -16},
    { -800, 504, -40},
    { -952, 672, -192},
    // 12 seconds
    { -1192, 672, -144},
    { -1320, 672, -128},
    { -1120, 712, -256},
    { -928, 616, -136},
    { -880, 504, -104},
    { -632, 360, 8},
    { -376, 336, 0},
    { -360, 344, -56},
    { -488, 304, 0},
    { -592, 320, 88},
    { -672, 296, 88},
    { -680, 344, 72},
    { -888, 432, 32},
    { -1176, 456, -8},
    { -1016, 448, -80},
    { -1096, 472, -168},
    { -1104, 456, -88},
    { -960, 496, -192},
    { -720, 472, -288},
    { -416, 352, -216},
    { -280, 288, -192},
    { -360, 440, -192},
    { -448, 368, -56},
    { -584, 504, -120},
    { -632, 536, -80},
    // 13 seconds
    { -640, 544, -32},
    { -824, 680, -176},
    { -952, 576, -24},
    { -1328, 728, -152},
    { -1184, 744, -200},
    { -1232, 616, -72},
    { -1088, 528, 32},
    { -664, 424, 16},
    { -336, 424, -72},
    { -304, 360, -72},
    { -392, 312, 8},
    { -512, 328, 64},
    { -648, 376, 40},
    { -632, 400, 40},
    { -800, 456, 16},
    { -1032, 480, 8},
    { -1000, 528, -88},
    { -1120, 512, -80},
    { -1072, 568, -112},
    { -1032, 600, -264},
    { -888, 568, -280},
    { -576, 392, -152},
    { -328, 360, -144},
    { -272, 368, -160},
    { -304, 376, -120},
    // 14 seconds
    { -448, 408, -104},
    { -600, 472, -64},
    { -648, 464, -8},
    { -712, 568, -88},
    { -936, 624, -144},
    { -1128, 616, -112},
    { -1392, 640, -96},
    { -1088, 672, -120},
    { -1056, 640, -120},
    { -1008, 568, -32},
    { -704, 416, 0},
    { -432, 416, -40},
    { -328, 392, -88},
    { -392, 368, 0},
    { -456, 344, 56},
    { -504, 408, 56},
    { -600, 464, 40},
    { -760, 520, 8},
    { -1136, 520, 48},
    { -984, 496, 24},
    { -1224, 528, -80},
    { -1104, 568, -56},
    { -864, 544, -184},
    { -920, 512, -240},
    { -672, 376, -176},
    // 15 seconds
    { -400, 296, -112},
    { -296, 344, -152},
    { -304, 368, -136},
    { -384, 400, -72},
    { -528, 488, -56},
    { -584, 552, -24},
    { -648, 616, -56},
    { -840, 728, -120},
    { -888, 656, -24},
    { -1288, 776, -120},
    { -1240, 760, -72},
    { -1000, 616, 0},
    { -1032, 664, -96},
    { -864, 536, 40},
    { -576, 360, 64},
    { -432, 392, -8},
    { -384, 312, 64},
    { -432, 320, 56},
    { -464, 376, 48},
    { -560, 416, 64},
    { -648, 440, 96},
    { -896, 512, 56},
    { -1040, 512, 64},
    { -1192, 520, 64},
    { -1240, 552, 16},
    // 16 seconds
    { -896, 544, -112},
    { -880, 648, -272},
    { -776, 496, -152},
    { -504, 312, -56},
    { -344, 400, -136},
    { -304, 360, -104},
    { -432, 376, -56},
    { -584, 424, -24},
    { -672, 440, 32},
    { -680, 488, 0},
    { -808, 568, -120},
    { -1048, 560, -88},
    { -1256, 544, -64},
    { -1328, 672, -176},
    { -1040, 656, -120},
    { -1016, 648, -112},
    { -1008, 536, -8},
    { -584, 392, 80},
    { -416, 432, -48},
    { -416, 392, -8},
    { -472, 320, 64},
    { -488, 304, 96},
    { -576, 376, 88},
    { -648, 440, 56},
    { -800, 488, 40},
    // 17 seconds
    { -1064, 488, 72},
    { -1072, 520, -24},
    { -1112, 512, -72},
    { -912, 520, -80},
    { -776, 560, -200},
    { -920, 632, -312},
    { -712, 504, -192},
    { -432, 392, -128},
    { -304, 424, -176},
    { -320, 416, -176},
    { -400, 368, -88},
    { -560, 432, -96},
    { -656, 488, -72},
    { -712, 584, -64},
    { -984, 624, -176},
    { -1128, 480, -48},
    { -1464, 640, -120},
    { -1160, 640, -120},
    { -976, 560, -64},
    { -976, 584, -128},
    { -832, 400, 48},
    { -520, 328, 64},
    { -352, 360, -48},
    { -320, 360, -56},
    { -368, 304, 8},
    // 18 seconds
    { -504, 352, 40},
    { -608, 384, 48},
    { -720, 464, 16},
    { -1064, 528, 16},
    { -1072, 480, 16},
    { -1152, 568, -72},
    { -1048, 592, -88},
    { -904, 616, -256},
    { -1072, 592, -232},
    { -776, 456, -96},
    { -424, 384, -144},
    { -296, 416, -176},
    { -296, 336, -96},
    { -400, 328, -80},
    { -600, 384, -56},
    { -608, 384, 16},
    { -648, 496, -56},
    { -800, 608, -160},
    { -888, 552, -72},
    { -1096, 600, -120},
    { -1232, 656, -136},
    { -1224, 792, -160},
    { -1152, 728, -40},
    { -848, 592, -56},
    { -592, 576, -128},
    // 19 seconds
    { -400, 464, -96},
    { -328, 392, -96},
    { -360, 352, -24},
    { -448, 336, 40},
    { -600, 392, 8},
    { -728, 408, 32},
    { -1008, 488, 0},
    { -1096, 432, 96},
    { -1048, 528, -80},
    { -1048, 512, -120},
    { -856, 480, -88},
    { -856, 600, -288},
    { -744, 536, -280},
    { -472, 408, -128},
    { -352, 392, -160},
    { -360, 416, -176},
    { -424, 400, -120},
    { -552, 456, -112},
    { -648, 488, -104},
    { -720, 528, -104},
    { -984, 592, -184},
    { -1080, 568, -104},
    { -1400, 616, -152},
    { -1264, 672, -216},
    { -928, 528, -88},
    // 20 seconds
    { -992, 488, -128},
    { -832, 424, -16},
    { -520, 320, 40},
    { -328, 360, -48},
    { -344, 360, -64},
    { -368, 280, 48},
    { -520, 440, 56},
    { -600, 424, 88},
    { -816, 480, 48},
    { -1024, 480, 104},
    { -1160, 544, 56},
    { -1368, 648, -64},
    { -816, 576, -64},
    { -760, 688, -424},
    { -872, 632, -352},
    { -648, 264, 16},
    { -456, 328, -64},
    { -360, 368, -184},
    { -336, 352, -152},
    { -456, 360, -112},
    { -576, 376, -48},
    { -704, 408, -16},
    { -816, 512, -80},
    { -976, 576, -128},
    { -1304, 624, -96},
    // 21 seconds
    { -1392, 672, -152},
    { -1080, 608, -32},
    { -1000, 632, -104},
    { -832, 512, -16},
    { -528, 400, 16},
    { -344, 464, -104},
    { -336, 456, -128},
    { -376, 360, -8},
    { -584, 368, 32},
    { -696, 352, 104},
    { -776, 408, 104},
    { -1000, 464, 96},
    { -1080, 480, 96},
    { -1208, 600, -96},
    { -1120, 536, -8},
    { -792, 536, -200},
    { -928, 608, -328},
    { -728, 424, -168},
    { -408, 240, -112},
    { -296, 328, -224},
    { -336, 312, -184},
    { -376, 296, -104},
    { -536, 376, -128},
    { -664, 456, -72},
    { -744, 520, -88},
    // 22 seconds
    { -928, 600, -144},
    { -920, 568, -64},
    { -1336, 720, -184},
    { -1096, 712, -152},
    { -984, 624, -128},
    { -1080, 672, -168},
    { -824, 472, 16},
    { -480, 448, -64},
    { -360, 440, -152},
    { -360, 384, -40},
    { -392, 336, 8},
    { -480, 256, 16},
    { -600, 376, 48},
    { -840, 464, 40},
    { -1128, 496, 88},
    { -1048, 544, 16},
    { -1216, 576, -72},
    { -1064, 584, -64},
    { -784, 632, -272},
    { -864, 528, -312},
    { -704, 368, -120},
    { -480, 272, -120},
    { -328, 344, -184},
    { -304, 352, -176},
    { -400, 384, -144},
    // 23 seconds
    { -504, 440, -120},
    { -552, 472, -80},
    { -720, 560, -144},
    { -984, 616, -112},
    { -976, 568, -8},
    { -1296, 696, -136},
    { -1040, 680, -56},
    { -1072, 656, -88},
    { -1168, 672, -104},
    { -808, 456, 32},
    { -440, 472, -96},
    { -336, 456, -192},
    { -320, 384, -80},
    { -440, 328, 0},
    { -520, 328, 56},
    { -632, 392, 64},
    { -840, 448, 96},
    { -1040, 488, 136},
    { -960, 552, 16},
    { -1032, 616, -104},
    { -1024, 560, -72},
    { -888, 616, -240},
    { -952, 592, -344},
    { -656, 416, -216},
    { -344, 288, -184},
    // 24 seconds
    { -288, 336, -240},
    { -336, 312, -192},
    { -456, 320, -144},
    { -632, 376, -104},
    { -688, 424, -72},
    { -792, 520, -152},
    { -896, 576, -176},
    { -1088, 552, -144},
    { -1456, 624, -120},
    { -1168, 624, -56},
    { -944, 672, -184},
    { -960, 704, -240},
    { -720, 416, 0},
    { -480, 464, -96},
    { -384, 448, -136},
    { -424, 376, -56},
    { -504, 320, 16},
    { -648, 328, 48},
    { -736, 320, 80},
    { -928, 360, 72},
    { -1184, 384, 104},
    { -1048, 456, -24},
    { -1040, 480, -72},
    { -984, 512, -112},
    { -840, 600, -312},
    // 25 seconds
    { -880, 504, -280},
    { -664, 376, -152},
    { -416, 368, -208},
    { -312, 400, -240},
    { -320, 344, -200},
    { -384, 336, -176},
    { -520, 376, -160},
    { -712, 432, -128},
    { -880, 504, -152},
    { -1016, 544, -168},
    { -1272, 592, -168},
    { -1528, 664, -208},
    { -864, 560, -72},
    { -1032, 608, -176},
    { -992, 520, -80},
    { -736, 344, 48},
    { -456, 400, -56},
    { -408, 392, -104},
    { -408, 328, -24},
    { -440, 264, 32},
    { -552, 280, 48},
    { -664, 328, 40},
    { -888, 384, 64},
    { -1136, 424, 104},
    { -1296, 536, 0},
    // 26 seconds
    { -1176, 584, -40},
    { -704, 680, -320},
    { -896, 640, -360},
    { -816, 416, -80},
    { -584, 328, -72},
    { -376, 416, -192},
    { -336, 424, -208},
    { -352, 352, -128},
    { -496, 376, -128},
    { -624, 392, -64},
    { -760, 448, -88},
    { -992, 560, -176},
    { -1136, 528, -80},
    { -1616, 632, -168},
    { -1144, 600, -112},
    { -920, 592, -208},
    { -1032, 600, -232},
    { -768, 368, -16},
    { -496, 392, -96},
    { -384, 408, -168},
    { -360, 360, -96},
    { -416, 296, -24},
    { -528, 304, 8},
    { -656, 336, 40},
    { -760, 352, 96},
    // 27 seconds
    { -1088, 424, 120},
    { -1112, 472, 80},
    { -1240, 536, -32},
    { -1160, 560, 0},
    { -680, 592, -240},
    { -824, 624, -392},
    { -680, 448, -200},
    { -488, 272, -104},
    { -376, 344, -224},
    { -344, 336, -208},
    { -400, 352, -184},
    { -488, 384, -176},
    { -624, 464, -152},
    { -832, 568, -192},
    { -1096, 584, -136},
    { -1296, 656, -104},
    { -1320, 704, -112},
    { -992, 696, -144},
    { -952, 728, -184},
    { -896, 560, -40},
    { -656, 408, 48},
    { -400, 424, -56},
    { -360, 432, -96},
    { -432, 360, 24},
    { -528, 336, 112},
    // 28 seconds
    { -608, 376, 104},
    { -680, 424, 112},
    { -872, 472, 112},
    { -1104, 496, 104},
    { -1120, 552, 24},
    { -1160, 632, -168},
    { -928, 544, -216},
    { -920, 552, -336},
    { -856, 448, -304},
    { -488, 280, -144},
    { -296, 280, -216},
    { -280, 312, -256},
    { -336, 312, -184},
    { -480, 352, -144},
    { -616, 416, -80},
    { -600, 496, -56},
    { -704, 600, -144},
    { -832, 688, -184},
    { -1192, 720, -160},
    { -1504, 728, -128},
    { -1056, 672, -8},
    { -1056, 736, -168},
    { -968, 656, -152},
    { -632, 424, -24},
    { -432, 472, -128},
    // 29 seconds
    { -400, 400, -64},
    { -480, 328, 8},
    { -536, 296, 56},
    { -616, 272, 96},
    { -632, 280, 104},
    { -856, 336, 120},
    { -1040, 336, 160},
    { -872, 440, 0},
    { -1144, 496, -48},
    { -1216, 584, -80},
    { -968, 584, -240},
    { -896, 672, -360},
    { -664, 456, -256},
    { -376, 328, -184},
    { -328, 368, -240},
    { -336, 336, -208},
    { -416, 360, -160},
    { -568, 416, -128},
    { -672, 464, -88},
    { -680, 512, -120},
    { -880, 608, -184},
    { -952, 544, -96},
    { -1424, 632, -136},
    { -1200, 632, -80},
    { -984, 600, -104},
    // 30 seconds
    { -1056, 712, -248},
    { -864, 456, -8},
    { -576, 408, -56},
    { -416, 432, -136},
    { -352, 384, -104},
    { -360, 328, -24},
    { -496, 352, 40},
    { -616, 344, 64},
    { -776, 432, -8},
    { -1072, 376, 136},
    { -904, 392, 72},
    { -1088, 520, -80},
    { -1000, 544, -120},
    { -952, 512, -168},
    { -1008, 544, -144},
    { -688, 552, -208},
    { -296, 472, -200},
    { -296, 464, -216},
    { -360, 400, -200},
    { -448, 368, -176},
    { -632, 368, -160},
    { -760, 392, -136},
    { -848, 496, -208},
    { -1000, 544, -232},
    { -1080, 528, -184},
    // 31 seconds
    { -1400, 600, -216},
    { -1056, 576, -136},
    { -976, 584, -184},
    { -1080, 632, -152},
    { -800, 408, 32},
    { -528, 440, -64},
    { -376, 408, -96},
    { -352, 352, 16},
    { -336, 288, 80},
    { -400, 344, 88},
    { -560, 400, 48},
    { -792, 432, 80},
    { -1128, 432, 136},
    { -1080, 496, -72},
    { -1352, 592, -232},
    { -1192, 648, -320},
    { -896, 512, -384},
    { -848, 512, -344},
    { -696, 392, -248},
    { -448, 336, -168},
    { -320, 312, -160},
    { -296, 288, -120},
    { -320, 304, -112},
    { -480, 344, -72},
    { -568, 392, -64},
    // 32 seconds
    { -544, 488, -48},
    { -680, 592, -208},
    { -840, 696, -288},
    { -1384, 672, -232},
    { -1520, 640, -152},
    { -936, 712, -152},
    { -1112, 800, -280},
    { -960, 600, -104},
    { -672, 488, -80},
    { -464, 448, -136},
    { -384, 360, -72},
    { -312, 280, -8},
    { -320, 264, 16},
    { -352, 240, 72},
    { -528, 312, 72},
    { -824, 368, 104},
    { -1072, 456, 40},
    { -1328, 624, -96},
    { -1480, 664, -104},
    { -1056, 640, -272},
    { -832, 568, -168},
    { -824, 624, -320},
    { -536, 448, -264},
    { -360, 360, -152},
    { -352, 344, -184},
    // 33 seconds
    { -416, 336, -144},
    { -504, 376, -144},
    { -544, 376, -96},
    { -624, 488, -128},
    { -912, 584, -136},
    { -960, 528, 24},
    { -1280, 672, -80},
    { -1256, 816, -248},
    { -1056, 688, -128},
    { -1032, 672, -120},
    { -816, 520, 8},
    { -504, 456, -32},
    { -344, 456, -112},
    { -352, 448, -104},
    { -440, 384, -32},
    { -552, 376, -16},
    { -688, 352, 56},
    { -880, 400, 64},
    { -1080, 392, 184},
    { -936, 408, 96},
    { -1304, 448, 16},
    { -1016, 264, 8},
    { -1016, 312, -264},
    { -1032, 312, -312},
    { -744, 112, -192},
    // 34 seconds
    { -456, 104, -184},
    { -368, 216, -240},
    { -408, 296, -200},
    { -568, 328, -136},
    { -728, 424, -136},
    { -848, 464, -144},
    { -768, 440, -192},
    { -888, 536, -280},
    { -1032, 504, -224},
    { -1312, 592, -264},
    { -1456, 672, -264},
    { -1000, 520, -152},
    { -1080, 616, -256},
    { -1152, 560, -88},
    { -856, 416, 112},
    { -568, 360, 32},
    { -432, 32, -16},
    { -304, 144, -144},
    { -456, 120, 40},
    { -520, -248, 176},
    { -816, -200, 88},
    { -1416, 376, -16},
    { -1296, -128, 576},
    { -1424, 408, -360},
    { -1568, 160, -256},
    // 35 seconds
    { -1016, 0, -136},
    { -1072, 24, -192},
    { -864, 72, -120},
    { -600, 16, -152},
    { -480, 224, -240},
    { -472, 248, -264},
    { -536, 304, -208},
    { -616, 336, -144},
    { -720, 392, -184},
    { -720, 408, -280},
    { -1056, 576, -344},
    { -1192, 400, -192},
    { -1600, 656, -480},
    { -1352, 472, -344},
    { -1128, 424, -264},
    { -1224, 496, -272},
    { -1208, 360, -64},
    { -912, 288, 56},
    { -616, 264, -24},
    { -480, 248, -64},
    { -440, 120, 32},
    { -440, 72, 80},
    { -464, 112, 96},
    { -656, 144, 104},
    { -920, 200, 72},
    // 36 seconds
    { -1088, 96, 64},
    { -1096, 320, -160},
    { -1504, 200, 16},
    { -1240, 408, -120},
    { -1168, 432, -152},
    { -1136, 448, -80},
    { -808, 408, -264},
    { -512, 392, -224},
    { -432, 440, -240},
    { -408, 528, -240},
    { -504, 512, -184},
    { -688, 624, -200},
    { -744, 600, -152},
    { -752, 632, -168},
    { -1040, 776, -216},
    { -1072, 560, -120},
    { -1672, 832, -328},
    { -1480, 560, -80},
    { -1432, 528, -80},
    { -1472, 528, -40},
    { -1056, 424, 24},
    { -784, 328, 56},
    { -536, 192, 104},
    { -464, 176, 72},
    { -392, 104, 128},
    // 37 seconds
    { -384, 56, 152},
    { -504, 96, 96},
    { -720, 232, -16},
    { -864, 120, 64},
    { -968, 264, -112},
    { -1520, 304, -72},
    { -1464, 456, -184},
    { -1048, 496, -248},
    { -1104, 376, -56},
    { -888, 456, -160},
    { -616, 416, -152},
    { -456, 392, -128},
    { -464, 416, -160},
    { -464, 400, -136},
    { -576, 424, -192},
    { -696, 488, -184},
    { -792, 504, -168},
    { -1000, 664, -288},
    { -1096, 616, -176},
    { -1576, 744, -304},
    { -1360, 752, -280},
    { -1088, 504, -136},
    { -1144, 568, -168},
    { -1056, 464, -8},
    { -888, 360, 120},
    // 38 seconds
    { -672, 416, -32},
    { -600, 368, 64},
    { -576, 232, 136},
    { -496, 200, 104},
    { -552, 144, 128},
    { -656, 168, 88},
    { -968, 184, 136},
    { -1040, 40, 200},
    { -1216, 224, 0},
    { -1240, 424, -272},
    { -1048, 360, -248},
    { -1192, 160, -152},
    { -1008, 312, -208},
    { -704, 248, -200},
    { -560, 352, -208},
    { -536, 392, -224},
    { -512, 400, -208},
    { -576, 416, -160},
    { -696, 456, -200},
    { -736, 504, -200},
    { -928, 640, -304},
    { -984, 696, -272},
    { -1496, 976, -544},
    { -1464, 856, -376},
    { -1192, 456, -96},
    // 39 seconds
    { -1392, 544, -208},
    { -1296, 448, -32},
    { -1088, 400, 8},
    { -864, 376, 0},
    { -720, 304, 40},
    { -568, 224, 96},
    { -480, 184, 112},
    { -224, 192, 96},
    { -344, 288, -24},
    { -528, 320, -56},
    { -656, 224, 32},
    { -1112, 256, -48},
    { -1288, 448, -192},
    { -1168, 480, -344},
    { -1056, 376, -160},
    { -1008, 280, -136},
    { -856, 288, -56},
    { -640, 360, -96},
    { -608, 440, -136},
    { -632, 488, -192},
    { -768, 472, -152},
    { -856, 520, -160},
    { -960, 704, -256},
    { -1016, 840, -384},
    { -1064, 640, -280},
    // 40 seconds
    { -1272, 776, -496},
    { -1344, 640, -368},
    { -1224, 496, -248},
    { -1104, 456, -168},
    { -1248, 432, -104},
    { -984, 360, -8},
    { -872, 328, 56},
    { -728, 312, 80},
    { -672, 272, 96},
    { -640, 176, 144},
    { -664, 184, 72},
    { -768, 136, 128},
    { -808, 104, 160},
    { -832, 136, 72},
    { -912, 312, -136},
    { -1208, 416, -136},
    { -1056, 536, -192},
    { -1112, 544, -152},
    { -1000, 648, -216},
    { -648, 600, -344},
    { -376, 480, -200},
    { -328, 456, -136},
    { -392, 488, -128},
    { -496, 520, -40},
    { -704, 560, -136},
    // 41 seconds
    { -840, 568, -88},
    { -896, 560, -112},
    { -1176, 680, -184},
    { -1424, 528, -152},
    { -1424, 624, -288},
    { -1048, 472, -176},
    { -1136, 512, -208},
    { -1120, 448, -128},
    { -760, 320, 24},
    { -560, 328, -8},
    { -512, 304, -56},
    { -520, 224, 32},
    { -528, 200, 72},
    { -552, 192, 72},
    { -536, 240, 32},
    { -784, 264, 56},
    { -1008, 288, 64},
    { -1104, 416, -120},
    { -1192, 528, -272},
    { -1192, 520, -368},
    { -1256, 184, -104},
    { -1016, 152, -112},
    { -552, 208, -224},
    { -312, 256, -200},
    { -328, 280, -176},
    // 42 seconds
    { -464, 288, -88},
    { -648, 336, -72},
    { -808, 424, -152},
    { -872, 688, -256},
    { -1056, 568, -296},
    { -1144, 448, -192},
    { -1560, 312, -184},
    { -1240, 408, -384},
    { -1248, 320, -200},
    { -1200, 368, -216},
    { -1000, 296, -96},
    { -616, 336, -64},
    { -472, 384, -72},
    { -440, 344, -16},
    { -464, 240, 72},
    { -456, 192, 72},
    { -496, 256, 0},
    { -696, 296, 40},
    { -984, 256, 208},
    { -1136, 152, 128},
    { -1200, 112, 96},
    { -1600, 368, -120},
    { -1152, 304, -240},
    { -1120, 200, -176},
    { -984, 336, -256},
    // 43 seconds
    { -536, 256, -200},
    { -360, 368, -240},
    { -344, 384, -184},
    { -472, 448, -128},
    { -584, 240, -72},
    { -944, 616, -24},
    { -960, 824, -64},
    { -1152, 832, -144},
    { -1128, 664, -48},
    { -1504, 832, -120},
    { -1144, 608, 40},
    { -1120, 592, -32},
    { -1200, 544, 72},
    { -992, 416, 144},
    { -696, 344, 120},
    { -640, 336, 64},
    { -664, 240, 136},
    { -568, 128, 152},
    { -552, 200, -8},
    { -608, 208, 16},
    { -712, 264, 80},
    { -992, 280, 0},
    { -888, 392, -168},
    { -1112, 320, -80},
    { -1056, 448, -64},
    // 44 seconds
    { -1136, 480, -112},
    { -1168, 544, -88},
    { -800, 552, -120},
    { -480, 512, -152},
    { -384, 496, -144},
    { -408, 480, -104},
    { -520, 488, -64},
    { -752, 504, -104},
    { -896, 816, -56},
    { -968, 712, -168},
    { -1096, 800, -32},
    { -1464, 880, -192},
    { -1296, 728, -152},
    { -1112, 672, -128},
    { -1264, 632, -120},
    { -1208, 432, 128},
    { -704, 368, 88},
    { -720, 336, 64},
    { -560, 272, 96},
    { -496, 112, 24},
    { -480, 232, 120},
    { -624, 224, 96},
    { -856, 152, 168},
    { -1112, 256, 120},
    { -1136, 328, -32},
    // 45 seconds
    { -1288, 320, 96},
    { -1064, 528, -80},
    { -1176, 584, -168},
    { -1064, 552, -32},
    { -680, 592, -168},
    { -424, 520, -160},
    { -368, 488, -120},
    { -392, 496, -88},
    { -424, 504, -80},
    { -568, 560, -224},
    { -768, 656, -136},
    { -1088, 760, -240},
    { -1256, 680, -48},
    { -1536, 752, -120},
    { -1120, 736, -224},
    { -936, 552, -160},
    { -1072, 544, -136},
    { -992, 440, 40},
    { -704, 376, 56},
    { -480, 360, 8},
    { -448, 336, 8},
    { -456, 336, 88},
    { -544, 240, 160},
    { -688, 216, 152},
    { -792, 240, 152},
    // 46 seconds
    { -1024, 248, 136},
    { -1208, 272, -16},
    { -1376, 160, 152},
    { -1344, 432, -136},
    { -960, 384, -72},
    { -952, 472, -152},
    { -736, 504, -200},
    { -480, 352, -72},
    { -384, 416, -96},
    { -400, 440, -80},
    { -472, 416, -32},
    { -616, 472, -56},
    { -744, 544, 8},
    { -848, 608, -72},
    { -1128, 680, -48},
    { -1352, 688, -16},
    { -1392, 776, -32},
    { -1120, 744, -64},
    { -824, 672, -128},
    { -1080, 608, -72},
    { -1032, 472, 24},
    { -824, 360, 96},
    { -624, 336, 80},
    { -544, 320, 32},
    { -496, 280, 56},
    // 47 seconds
    { -560, 256, 112},
    { -624, 248, 72},
    { -704, 232, 80},
    { -864, 216, 144},
    { -896, 328, 264},
    { -1120, 824, 192},
    { -1144, 1144, 480},
    { -512, 1448, 144},
    { -704, 1496, -16},
    { -416, 1208, 56},
    { -320, 808, -144},
    { -224, 704, -264},
    { -176, 296, -256},
    { -48, 368, -320},
    { -64, 488, -504},
    { 0, 568, -528},
    { 8, 472, -824},
    { 72, 920, -672},
    { -24, 840, -440},
    { 112, 1320, -448},
    { 176, 1416, -464},
    { 120, 1328, -616},
    { 272, 1056, -336},
    { 288, 920, -344},
    { 256, 616, -336},
    // 48 seconds
    { 264, 320, -216},
    { 296, 400, -168},
    { 304, 168, -96},
    { 296, 480, -464},
    { 416, 736, -464},
    { 400, 888, -536},
    { 400, 768, -576},
    { 336, 1176, -680},
    { 328, 1048, -792},
    { 240, 928, -808},
    { 152, 1176, -784},
    { 176, 936, -600},
    { 216, 664, -376},
    { 192, 576, -424},
    { 160, 448, -272},
    { 208, 384, -168},
    { 224, 472, -160},
    { 208, 256, -400},
    { 264, 560, -664},
    { 288, 736, -592},
    { 352, 832, -528},
    { 328, 888, -608},
    { 352, 1008, -536},
    { 120, 1624, -800},
    { 120, 1544, -440},
    // 49 seconds
    { 152, 1312, -352},
    { 104, 928, -320},
    { 120, 664, -224},
    { 136, 664, -184},
    { 176, 632, -152},
    { 128, 248, -336},
    { 176, 608, -376},
    { 176, 608, -256},
    { 40, 608, -368},
    { -88, 856, -672},
    { -352, 880, -632},
    { -544, 976, -512},
    { -592, 1024, -368},
    { -520, 632, -168},
    { -616, 752, -320},
    { -656, 696, -280},
    { -712, 584, -64},
    { -688, 416, 256},
    { -608, 272, 328},
    { -664, 728, 40},
    { -616, 624, 88},
    { -680, 480, 224},
    { -680, 616, 120},
    { -920, 720, -56},
    { -1104, 608, -56},
    // 50 seconds
    { -1192, 640, 8},
    { -1528, 616, -256},
    { -1192, 824, -416},
    { -1080, 600, -280},
    { -1208, 584, -208},
    { -872, 432, -48},
    { -456, 384, -16},
    { -336, 352, 16},
    { -416, 352, 0},
    { -520, 296, 56},
    { -656, 256, 112},
    { -752, 248, 160},
    { -1008, 232, 168},
    { -1040, 240, 144},
    { -1032, 288, 16},
    { -1144, 280, 40},
    { -1136, 408, -112},
    { -1200, 376, -96},
    { -1160, 680, -400},
    { -656, 592, -304},
    { -368, 520, -192},
    { -320, 528, -184},
    { -360, 520, -136},
    { -424, 488, -88},
    { -520, 512, -88},
    // 51 seconds
    { -696, 576, -96},
    { -1024, 640, -80},
    { -1128, 600, -8},
    { -1856, 848, -216},
    { -1616, 624, -8},
    { -1504, 472, 8},
    { -1464, 448, 40},
    { -960, 352, 48},
    { -584, 312, 32},
    { -456, 272, 16},
    { -360, 192, 56},
    { -288, 104, 104},
    { -344, 128, 56},
    { -336, 128, 64},
    { -544, 280, 48},
    { -752, 432, 24},
    { -936, 392, 8},
    { -1368, 656, 24},
    { -1392, 760, -112},
    { -1328, 832, -336},
    { -1144, 824, -248},
    { -616, 536, -160},
    { -280, 440, -160},
    { -264, 480, -184},
    { -288, 416, -136},
    // 52 seconds
    { -376, 384, -80},
    { -576, 400, -72},
    { -776, 480, -32},
    { -968, 576, -64},
    { -1112, 608, -40},
    { -1648, 704, -112},
    { -1176, 632, -88},
    { -952, 496, -88},
    { -1040, 608, -144},
    { -864, 408, 8},
    { -576, 304, 24},
    { -400, 368, -24},
    { -360, 336, -40},
    { -360, 288, -8},
    { -472, 264, 24},
    { -568, 272, 48},
    { -824, 344, -8},
    { -1168, 376, 72},
    { -1152, 368, 88},
    { -1280, 432, -56},
    { -1216, 536, -80},
    { -856, 536, -200},
    { -968, 416, -152},
    { -784, 416, -136},
    { -456, 328, -112},
    // 53 seconds
    { -272, 392, -152},
    { -240, 376, -152},
    { -344, 344, -160},
    { -496, 328, -120},
    { -752, 360, -80},
    { -1016, 424, -72},
    { -1128, 496, -56},
    { -1192, 536, -64},
    { -1440, 760, -288},
    { -1192, 624, -104},
    { -1016, 504, -40},
    { -960, 536, -24},
    { -680, 448, 32},
    { -440, 456, 0},
    { -376, 520, -80},
    { -464, 424, -8},
    { -512, 328, 56},
    { -600, 256, 104},
    { -648, 208, 120},
    { -840, 224, 48},
    { -1216, 176, 120},
    { -1272, 192, 88},
    { -1632, 320, 112},
    { -1088, 664, -152},
    { -1120, 360, 24},
    // 54 seconds
    { -920, 200, -264},
    { -416, 312, -312},
    { -288, 312, -264},
    { -328, 360, -192},
    { -400, 320, -120},
    { -512, 424, -136},
    { -656, 448, -104},
    { -864, 472, -96},
    { -1032, 576, -184},
    { -1240, 488, -200},
    { -1656, 744, -208},
    { -1344, 808, -72},
    { -1024, 472, -136},
    { -1072, 512, -144},
    { -824, 384, 40},
    { -552, 328, 32},
    { -432, 344, 16},
    { -440, 296, 72},
    { -440, 240, 96},
    { -544, 192, 128},
    { -624, 216, 136},
    { -728, 256, 96},
    { -1008, 296, 32},
    { -1288, 224, 112},
    { -1680, 288, 96},
    // 55 seconds
    { -1288, 520, -232},
    { -1056, 256, -120},
    { -928, 280, -224},
    { -528, 248, -240},
    { -296, 360, -248},
    { -288, 320, -168},
    { -424, 392, -144},
    { -592, 376, -88},
    { -840, 456, -112},
    { -872, 480, -64},
    { -1032, 600, -200},
    { -1128, 600, -80},
    { -1568, 720, -240},
    { -1200, 608, -168},
    { -1296, 600, -88},
    { -1128, 560, -88},
    { -928, 344, 128},
    { -568, 336, 104},
    { -440, 304, 96},
    { -408, 264, 112},
    { -448, 232, 128},
    { -536, 232, 88},
    { -616, 248, 112},
    { -800, 312, 80},
    { -1248, 304, 64},
    // 56 seconds
    { -1136, 240, 48},
    { -1408, 256, 16},
    { -1296, 384, -184},
    { -1152, 200, -112},
    { -1000, 440, -112},
    { -616, 376, -248},
    { -360, 312, -144},
    { -200, 360, -216},
    { -216, 360, -152},
    { -360, 360, -104},
    { -696, 480, -128},
    { -936, 536, -88},
    { -1160, 680, -176},
    { -1280, 688, -152},
    { -1536, 824, -240},
    { -1168, 728, -80},
    { -1104, 600, -48},
    { -1072, 512, 16},
    { -800, 432, 88},
    { -552, 352, 40},
    { -424, 256, 40},
    { -416, 168, 16},
    { -456, 112, 40},
    { -504, 136, 208},
    { -696, 200, 152},
    // 57 seconds
    { -904, 312, -24},
    { -1248, 232, 112},
    { -1176, 152, -72},
    { -1608, 96, -40},
    { -1472, 104, -8},
    { -864, 312, -120},
    { -848, 288, -136},
    { -640, 344, -168},
    { -416, 296, -88},
    { -336, 336, -56},
    { -416, 360, -24},
    { -424, 488, -48},
    { -520, 656, -136},
    { -624, 704, -160},
    { -840, 608, -128},
    { -1280, 600, 8},
    { -1352, 672, -64},
    { -1416, 744, -152},
    { -1096, 624, -104},
    { -1176, 528, -56},
    { -1232, 408, 96},
    { -816, 296, 152},
    { -496, 336, 48},
    { -408, 328, 0},
    { -400, 256, 64},
    // 58 seconds
    { -384, 192, 120},
    { -408, 192, 88},
    { -552, 192, 56},
    { -840, 472, -88},
    { -1136, 432, 32},
    { -1280, 456, -56},
    { -1648, 496, -24},
    { -992, 616, -208},
    { -944, 312, -96},
    { -712, 416, -256},
    { -360, 224, -192},
    { -256, 304, -144},
    { -320, 368, -176},
    { -528, 408, -144},
    { -744, 504, -128},
    { -832, 592, -176},
    { -1008, 704, -280},
    { -1040, 640, -104},
    { -1584, 784, -360},
    { -1544, 760, -256},
    { -1224, 480, 0},
    { -1208, 488, -64},
    { -904, 424, -16},
    { -568, 312, 64},
    { -448, 248, 32},
    // 59 seconds
    { -424, 240, 48},
    { -424, 152, 112},
    { -496, 168, 112},
    { -640, 248, 32},
    { -856, 304, 48},
    { -1136, 224, 104},
    { -1288, 280, 88},
    { -1656, 424, -16},
    { -1048, 520, -72},
    { -1032, 480, -88},
    { -720, 504, -120},
    { -424, 336, -144},
    { -376, 512, -368},
    { -384, 464, -248},
    { -536, 456, -144},
    { -728, 528, -80},
    { -848, 552, -40},
    { -928, 624, -104},
    { -1208, 640, -48},
    { -1536, 664, -64},
    { -1400, 752, -168},
    { -1072, 520, 16},
    { -1080, 536, -8},
    { -1048, 464, 40},
    { -768, 376, 64},
    // 60 seconds
    // elapsed: 1 minutes
    { -568, 352, 56},
    { -560, 312, 88},
    { -544, 248, 120},
    { -504, 184, 144},
    { -496, 168, 144},
    { -584, 240, 40},
    { -912, 288, 8},
    { -1056, 200, 64},
    { -1528, 192, 112},
    { -1392, 528, -208},
    { -1112, 472, -144},
    { -1032, 496, -128},
    { -712, 416, -240},
    { -408, 432, -248},
    { -320, 456, -224},
    { -400, 392, -112},
    { -480, 408, -152},
    { -656, 392, -160},
    { -816, 448, -112},
    { -1216, 600, -200},
    { -1256, 512, -40},
    { -1536, 632, -200},
    { -1248, 608, -240},
    { -1072, 480, -144},
    { -1120, 448, -136},
    // 61 seconds
    { -976, 384, 0},
    { -760, 328, -8},
    { -560, 288, 32},
    { -480, 232, 48},
    { -440, 192, 64},
    { -496, 184, 88},
    { -648, 224, 24},
    { -784, 120, 144},
    { -928, 248, 128},
    { -1096, 400, -40},
    { -1400, 368, 112},
    { -1376, 424, 0},
    { -1088, 520, -80},
    { -1040, 416, -80},
    { -744, 448, -88},
    { -448, 352, -120},
    { -360, 368, -120},
    { -368, 360, -120},
    { -416, 376, -88},
    { -584, 448, -88},
    { -736, 472, -72},
    { -792, 568, -136},
    { -1064, 624, -128},
    { -1224, 600, -72},
    { -1464, 736, -176},
    // 62 seconds
    { -1248, 688, -64},
    { -1224, 520, 8},
    { -1312, 496, 72},
    { -912, 392, 120},
    { -616, 264, 96},
    { -456, 192, -128},
    { -384, 336, -32},
    { -392, 64, 136},
    { -600, 136, 72},
    { -704, 120, 144},
    { -880, 176, 104},
    { -1152, 200, 120},
    { -1176, 248, 24},
    { -1544, 328, -48},
    { -1392, 344, -8},
    { -1048, 504, -184},
    { -864, 152, -216},
    { -592, 408, -208},
    { -424, 296, -184},
    { -352, 416, -208},
    { -408, 432, -168},
    { -512, 432, -112},
    { -720, 432, -72},
    { -808, 472, -40},
    { -1056, 624, -160},
    // 63 seconds
    { -1272, 584, -56},
    { -1664, 728, -160},
    { -1264, 632, -56},
    { -992, 464, 8},
    { -1120, 480, -16},
    { -944, 376, 80},
    { -632, 312, 104},
    { -504, 328, 24},
    { -568, 304, 72},
    { -560, 232, 136},
    { -648, 200, 128},
    { -664, 176, 136},
    { -760, 224, 112},
    { -1024, 328, 64},
    { -1136, 344, 144},
    { -1432, 400, 112},
    { -912, 504, -40},
    { -992, 536, -112},
    { -920, 608, -208},
    { -632, 360, -112},
    { -416, 384, -112},
    { -336, 480, -176},
    { -392, 432, -112},
    { -504, 424, -64},
    { -672, 480, -56},
    // 64 seconds
    { -736, 520, -24},
    { -1016, 648, -152},
    { -1224, 584, -40},
    { -1584, 648, -80},
    { -1376, 680, -104},
    { -1000, 512, -40},
    { -1008, 536, -64},
    { -840, 360, 104},
    { -552, 288, 104},
    { -408, 328, 56},
    { -512, 312, 64},
    { -536, 248, 144},
    { -632, 232, 112},
    { -688, 248, 128},
    { -928, 272, 104},
    { -1152, 256, 128},
    { -1040, 288, 56},
    { -1432, 344, -40},
    { -1120, 496, -24},
    { -1024, 496, -184},
    { -896, 552, -296},
    { -512, 408, -144},
    { -352, 352, -152},
    { -344, 376, -176},
    { -400, 376, -104},
    // 65 seconds
    { -488, 368, -88},
    { -656, 456, -80},
    { -736, 464, -32},
    { -1000, 592, -136},
    { -1168, 512, -24},
    { -1712, 640, -112},
    { -1352, 632, -72},
    { -968, 392, 8},
    { -1104, 512, -120},
    { -776, 360, 56},
    { -440, 280, 24},
    { -376, 336, -32},
    { -408, 312, 16},
    { -440, 224, 96},
    { -536, 256, 48},
    { -664, 280, 80},
    { -960, 328, 64},
    { -1200, 296, 168},
    { -1248, 392, 40},
    { -1320, 504, -32},
    { -944, 544, -128},
    { -960, 432, -144},
    { -888, 488, -152},
    { -544, 344, -120},
    { -312, 344, -136},
    // 66 seconds
    { -264, 392, -176},
    { -336, 368, -112},
    { -504, 376, -80},
    { -688, 472, -72},
    { -760, 544, -16},
    { -1040, 656, -136},
    { -1384, 712, -80},
    { -1824, 728, -144},
    { -960, 496, 8},
    { -864, 520, -160},
    { -864, 488, -64},
    { -632, 272, 64},
    { -352, 280, 32},
    { -304, 328, -8},
    { -368, 312, 32},
    { -480, 264, 72},
    { -640, 288, 80},
    { -824, 328, 80},
    { -1184, 320, 128},
    { -1192, 376, 80},
    { -1480, 400, 16},
    { -1192, 544, -120},
    { -696, 432, -176},
    { -944, 432, -208},
    { -664, 400, -128},
    // 67 seconds
    { -352, 312, -136},
    { -280, 376, -192},
    { -352, 360, -160},
    { -424, 304, -64},
    { -568, 392, -40},
    { -688, 496, -40},
    { -920, 608, -96},
    { -1112, 552, 0},
    { -1568, 664, -80},
    { -1320, 664, -40},
    { -1104, 536, -48},
    { -1144, 536, -32},
    { -840, 328, 96},
    { -504, 328, 24},
    { -368, 352, -48},
    { -352, 320, -32},
    { -400, 280, 64},
    { -496, 144, 88},
    { -664, 224, 56},
    { -856, 280, 96},
    { -968, 368, 88},
    { -1072, 384, -32},
    { -1584, 456, 0},
    { -1184, 632, -168},
    { -1048, 432, -280},
    // 68 seconds
    { -808, 584, -224},
    { -376, 352, -152},
    { -328, 400, -176},
    { -328, 416, -136},
    { -368, 360, -32},
    { -408, 392, -16},
    { -600, 592, -64},
    { -904, 632, -72},
    { -1104, 592, -48},
    { -1336, 640, -88},
    { -1600, 736, -168},
    { -1288, 416, 80},
    { -1112, 400, 48},
    { -984, 432, -24},
    { -608, 344, 24},
    { -352, 296, 24},
    { -288, 272, -8},
    { -304, 248, 24},
    { -424, 248, 56},
    { -600, 256, 48},
    { -736, 256, 104},
    { -1048, 312, 136},
    { -1216, 392, 72},
    { -1304, 440, 64},
    { -1440, 512, 16},
    // 69 seconds
    { -952, 520, -104},
    { -968, 400, -128},
    { -712, 456, -144},
    { -424, 344, -144},
    { -328, 360, -144},
    { -408, 352, -136},
    { -504, 296, -96},
    { -688, 320, -72},
    { -736, 360, -24},
    { -832, 416, -64},
    { -1088, 448, -48},
    { -1472, 480, -24},
    { -1704, 632, -144},
    { -936, 464, 8},
    { -944, 464, -96},
    { -920, 456, -24},
    { -656, 312, 32},
    { -416, 376, -40},
    { -440, 360, -32},
    { -424, 256, 80},
    { -480, 216, 104},
    { -608, 296, 80},
    { -632, 336, 88},
    { -904, 360, 88},
    { -1192, 360, 80},
    // 70 seconds
    { -1288, 384, 64},
    { -1408, 368, 88},
    { -1048, 568, -256},
    { -840, 384, -224},
    { -832, 368, -168},
    { -616, 296, -160},
    { -360, 304, -136},
    { -304, 344, -160},
    { -416, 368, -160},
    { -512, 288, -72},
    { -600, 264, -16},
    { -688, 368, -40},
    { -840, 456, -104},
    { -1056, 464, -48},
    { -1472, 520, -64},
    { -1624, 680, -144},
    { -1064, 408, 8},
    { -1120, 488, -80},
    { -992, 400, -40},
    { -608, 328, -16},
    { -368, 376, -96},
    { -376, 384, -96},
    { -376, 312, 16},
    { -456, 272, 48},
    { -592, 296, -8},
    // 71 seconds
    { -784, 328, 32},
    { -1104, 344, 120},
    { -1016, 384, 120},
    { -1240, 400, 40},
    { -1312, 504, -48},
    { -888, 480, -200},
    { -1024, 400, -176},
    { -808, 408, -240},
    { -488, 312, -224},
    { -360, 328, -200},
    { -360, 288, -168},
    { -400, 264, -120},
    { -504, 312, -136},
    { -624, 376, -80},
    { -872, 432, -96},
    { -1008, 488, -88},
    { -1392, 528, -96},
    { -1584, 696, -208},
    { -1016, 504, -32},
    { -1048, 400, -120},
    { -840, 432, -48},
    { -592, 360, -16},
    { -352, 368, -56},
    { -312, 368, -80},
    { -392, 288, 8},
    // 72 seconds
    { -520, 248, 72},
    { -712, 320, 64},
    { -872, 368, 88},
    { -1096, 392, 120},
    { -1280, 464, 40},
    { -1352, 488, 72},
    { -1096, 504, -48},
    { -768, 320, -248},
    { -960, 144, -136},
    { -704, 48, -104},
    { -384, 88, -184},
    { -400, 280, -200},
    { -512, 272, -120},
    { -608, 248, -32},
    { -760, 320, -48},
    { -728, 368, -48},
    { -848, 432, -104},
    { -1064, 464, -144},
    { -1400, 472, -104},
    { -1544, 648, -224},
    { -1104, 456, -40},
    { -1032, 488, -80},
    { -1016, 568, -32},
    { -640, 392, 56},
    { -392, 400, 0},
    // 73 seconds
    { -408, 392, 0},
    { -416, 264, 56},
    { -416, 176, 80},
    { -496, 144, 48},
    { -696, 248, 32},
    { -1000, 272, 128},
    { -1256, 304, 56},
    { -1584, 232, 128},
    { -1368, 440, -152},
    { -896, 232, -176},
    { -1072, 104, -160},
    { -752, 176, -176},
    { -448, 176, -192},
    { -384, 240, -160},
    { -432, 272, -136},
    { -544, 312, -88},
    { -680, 384, -104},
    { -896, 440, -88},
    { -1040, 552, -192},
    { -1144, 576, -160},
    { -1656, 648, -200},
    { -1480, 640, -240},
    { -944, 416, -112},
    { -968, 528, -168},
    { -1000, 464, -56},
    // 74 seconds
    { -768, 336, 40},
    { -480, 328, 16},
    { -472, 336, 32},
    { -496, 264, 104},
    { -560, 232, 144},
    { -632, 200, 144},
    { -712, 248, 72},
    { -968, 248, 56},
    { -1152, 192, 56},
    { -1400, 200, 88},
    { -1432, 344, 0},
    { -968, 424, -184},
    { -992, 264, -32},
    { -824, 360, -144},
    { -528, 264, -176},
    { -376, 328, -200},
    { -408, 408, -216},
    { -496, 392, -160},
    { -688, 416, -136},
    { -896, 480, -104},
    { -984, 600, -184},
    { -1088, 632, -192},
    { -1432, 664, -168},
    { -1512, 728, -248},
    { -1200, 480, -64},
    // 75 seconds
    { -1088, 504, -80},
    { -1200, 448, 24},
    { -856, 344, 80},
    { -560, 320, 56},
    { -480, 336, 32},
    { -504, 256, 96},
    { -512, 216, 144},
    { -536, 200, 120},
    { -560, 232, 104},
    { -768, 232, 128},
    { -896, 216, 96},
    { -1088, 272, 80},
    { -1384, 264, 48},
    { -1360, 488, -152},
    { -1128, 384, -128},
    { -1088, 512, -248},
    { -776, 424, -264},
    { -472, 280, -152},
    { -416, 432, -224},
    { -456, 432, -208},
    { -504, 384, -120},
    { -616, 464, -152},
    { -608, 488, -128},
    { -696, 488, -136},
    { -912, 568, -112},
    // 76 seconds
    { -1184, 608, -136},
    { -1800, 696, -88},
    { -1656, 568, 80},
    { -1256, 504, -72},
    { -1376, 488, 0},
    { -896, 376, 80},
    { -528, 328, 16},
    { -424, 328, 24},
    { -392, 280, 72},
    { -440, 216, 96},
    { -544, 240, 72},
    { -600, 280, 96},
    { -560, 232, 120},
    { -768, 264, 96},
    { -696, 288, -16},
    { -1152, 240, 32},
    { -1432, 240, 16},
    { -1312, 488, -224},
    { -1432, 376, -96},
    { -1216, 712, -392},
    { -624, 504, -320},
    { -552, 464, -248},
    { -480, 440, -208},
    { -496, 448, -152},
    { -592, 464, -192},
    // 77 seconds
    { -656, 440, -136},
    { -672, 448, -104},
    { -664, 432, -80},
    { -784, 464, -40},
    { -856, 408, 24},
    { -912, 416, 64},
    { -1520, 496, 40},
    { -1808, 504, 88},
    { -528, 208, 88},
    { -1496, 400, 0},
    { -1152, 96, 184},
    { -512, -16, 16},
    { -688, 168, -176},
    { -688, -16, 208},
    { -616, -16, 176},
    { -752, 184, 48},
    { -904, 272, 104},
    { -776, 240, 136},
    { -944, 240, 64},
    { -1464, 400, 88},
    { -648, 336, 88},
    { -608, 384, -184},
    { -720, 584, -280},
    { -816, 344, -48},
    { -832, 264, 24},
    // 78 seconds
    { -856, 440, -96},
    { -824, 472, -88},
    { -808, 440, -72},
    { -800, 384, -64},
    { -752, 336, -64},
    { -776, 336, -80},
    { -808, 320, -40},
    { -816, 336, -48},
    { -808, 360, -72},
    { -792, 360, -88},
    { -824, 360, -128},
    { -840, 344, -120},
    { -808, 352, -152},
    { -800, 352, -144},
    { -848, 336, -136},
    { -816, 344, -144},
    { -760, 336, -144},
    { -728, 336, -120},
    { -680, 344, -136},
    { -680, 384, -184},
    { -672, 368, -152},
    { -728, 360, -112},
    { -760, 408, -112},
    { -712, 416, -80},
    { -800, 448, -112},
    // 79 seconds
    { -720, 472, -160},
    { -648, 432, -168},
    { -664, 440, -168},
    { -768, 472, -184},
    { -968, 528, -200},
    { -952, 528, -160},
    { -1456, 624, -216},
    { -1480, 504, -56},
    { -1240, 432, -120},
    { -1280, 416, 0},
    { -1048, 312, 104},
    { -752, 264, 96},
    { -432, 272, 104},
    { -256, 248, 144},
    { -168, 352, 56},
    { -360, 400, -64},
    { -648, 352, 80},
    { -928, 256, 104},
    { -1184, 248, 104},
    { -1232, 216, 80},
    { -1360, 272, -48},
    { -1360, 288, -32},
    { -1112, 336, -120},
    { -928, 360, -248},
    { -1000, 368, -152},
    // 80 seconds
    { -680, 376, -48},
    { -496, 576, -152},
    { -184, 632, -136},
    { -216, 536, -88},
    { -448, 512, -64},
    { -688, 448, -48},
    { -912, 424, -56},
    { -808, 440, -96},
    { -1096, 488, -184},
    { -1200, 400, -64},
    { -1744, 416, -144},
    { -1320, 528, -216},
    { -1168, 408, -152},
    { -1064, 360, -56},
    { -752, 336, 0},
    { -424, 360, -32},
    { -336, 368, -40},
    { -424, 304, 40},
    { -504, 224, 104},
    { -632, 208, 136},
    { -760, 280, 104},
    { -1024, 256, 136},
    { -1296, 176, 168},
    { -1344, 160, 296},
    { -1520, 64, 248},
    // 81 seconds
    { -1152, 400, -8},
    { -1128, 488, -88},
    { -832, 448, -336},
    { -424, 536, -376},
    { -288, 480, -304},
    { -272, 336, -160},
    { -432, 360, -104},
    { -568, 440, -104},
    { -824, 480, -112},
    { -960, 480, -40},
    { -1344, 560, -136},
    { -1296, 384, 8},
    { -1504, 576, -192},
    { -1272, 552, -96},
    { -1272, 304, 104},
    { -1088, 328, 128},
    { -632, 312, 72},
    { -352, 328, -16},
    { -352, 312, 0},
    { -344, 208, 8},
    { -328, -8, 136},
    { -416, -8, 120},
    { -840, 240, -40},
    { -1472, 240, 104},
    { -1480, 304, 48},
    // 82 seconds
    { -1664, 200, 64},
    { -1416, 432, -208},
    { -992, 208, -112},
    { -896, 112, -56},
    { -608, 104, -112},
    { -296, 296, -208},
    { -192, 224, -168},
    { -296, 256, -104},
    { -520, 352, -120},
    { -752, 424, -120},
    { -808, 400, -64},
    { -1040, 440, -152},
    { -1176, 264, -88},
    { -1512, 440, -168},
    { -1656, 592, -472},
    { -1280, 312, -160},
    { -1256, 440, -128},
    { -1120, 312, 64},
    { -736, 304, 40},
    { -536, 440, 0},
    { -648, 384, 80},
    { -384, 192, 232},
    { -312, 192, 184},
    { -264, 248, -8},
    { -328, 208, 40},
    // 83 seconds
    { -512, 208, 32},
    { -920, 328, -208},
    { -1312, 432, -224},
    { -1816, 256, -96},
    { -1384, 264, -160},
    { -1128, 392, -304},
    { -928, 408, -240},
    { -488, 240, -128},
    { -288, 296, -176},
    { -280, 352, -184},
    { -304, 336, -168},
    { -416, 416, -192},
    { -792, 584, -320},
    { -904, 256, -152},
    { -1144, 368, -192},
    { -1072, 504, -192},
    { -1744, 656, -344},
    { -1472, 560, -352},
    { -1488, 368, -192},
    { -1448, 232, -80},
    { -856, 272, -8},
    { -384, 216, 40},
    { -432, 320, 48},
    { -512, 432, 88},
    { -440, 448, 176},
    // 84 seconds
    { -288, 192, 128},
    { -304, 280, 48},
    { -328, 208, 16},
    { -608, 232, -24},
    { -848, 224, -168},
    { -1608, 256, 0},
    { -1952, 560, -56},
    { -1496, 664, -304},
    { -1064, 360, -184},
    { -640, 288, -104},
    { -432, 248, -160},
    { -352, 336, -96},
    { -272, 392, -152},
    { -264, 120, -232},
    { -328, 272, -104},
    { -608, 288, -136},
    { -1056, 416, -232},
    { -1336, 552, -24},
    { -1552, 456, 40},
    { -1368, 912, -272},
    { -1768, 784, 40},
    { -1312, 560, 96},
    { -1064, 352, 80},
    { -480, 344, 96},
    { -320, 200, 160},
    // 85 seconds
    { -344, 184, 88},
    { -352, 280, 104},
    { -392, 264, 184},
    { -488, 208, 192},
    { -608, 144, 184},
    { -1176, 176, -40},
    { -1400, 208, 48},
    { -1888, 136, 104},
    { -1584, 344, -56},
    { -1288, 224, -40},
    { -1080, 136, 0},
    { -488, 248, -48},
    { -272, 312, -32},
    { -240, 568, -160},
    { -392, 368, -48},
    { -600, 472, -8},
    { -896, 616, -48},
    { -896, 280, -32},
    { -1208, 368, -208},
    { -1080, 336, -184},
    { -1912, 488, -216},
    { -1496, 728, -32},
    { -1464, 464, 120},
    { -1096, 344, 72},
    { -664, 288, 192},
    // 86 seconds
    { -336, 352, 256},
    { -384, 312, 96},
    { -512, 344, 96},
    { -520, 232, 200},
    { -712, 104, 200},
    { -792, 176, 128},
    { -1104, 200, 208},
    { -1112, 176, -8},
    { -1464, -96, 240},
    { -1416, 480, 248},
    { -1448, 584, 128},
    { -1096, 616, 160},
    { -584, 816, -136},
    { 0, 504, 192},
    { -48, 968, -56},
    { -176, 784, -32},
    { -472, 464, 112},
    { -816, 384, 224},
    { -1144, 480, 128},
    { -1280, 584, 128},
    { -1424, 568, 48},
    { -1504, 608, 0},
    { -1160, 824, -56},
    { -1088, 528, 96},
    { -1000, 432, 152},
    // 87 seconds
    { -744, 344, 152},
    { -416, 344, 72},
    { -392, 288, 112},
    { -328, 248, 136},
    { -256, 200, 144},
    { -248, 176, 152},
    { -512, 264, 40},
    { -952, 368, -8},
    { -1512, 208, 208},
    { -1552, 232, 176},
    { -1680, 304, 16},
    { -1392, 392, -152},
    { -1120, 144, 176},
    { -800, 288, -80},
    { -528, 304, -72},
    { -280, 336, -40},
    { -256, 328, -40},
    { -264, 312, 8},
    { -416, 328, 48},
    { -720, 416, 16},
    { -992, 376, 168},
    { -1088, 624, -88},
    { -1136, 624, -56},
    { -1576, 600, -64},
    { -1440, 768, -128},
    // 88 seconds
    { -1048, 544, -32},
    { -1024, 528, 16},
    { -968, 400, 168},
    { -592, 336, 160},
    { -400, 360, 72},
    { -440, 312, 128},
    { -528, 232, 184},
    { -584, 136, 208},
    { -752, 272, 80},
    { -872, 256, 104},
    { -1264, 200, 88},
    { -1368, 48, 272},
    { -1576, 232, 56},
    { -1312, 280, -40},
    { -1200, 136, 112},
    { -920, 240, -88},
    { -552, 296, -248},
    { -312, 232, -176},
    { -256, 272, -104},
    { -376, 328, -104},
    { -608, 440, -120},
    { -864, 416, -32},
    { -960, 392, 104},
    { -1184, 584, -8},
    { -1168, 552, 48},
    // 89 seconds
    { -1512, 744, -184},
    { -1208, 712, -112},
    { -1360, 400, 96},
    { -1304, 360, 176},
    { -856, 368, 88},
    { -504, 440, -80},
    { -424, 184, 56},
    { -520, 272, 104},
    { -544, 192, 160},
    { -592, 192, 144},
    { -632, 248, 144},
    { -952, 232, 176},
    { -1096, 296, 32},
    { -1296, 320, 64},
    { -1192, 224, 0},
    { -1360, 184, -16},
    { -1064, 160, -88},
    { -872, 152, -96},
    { -488, 240, -240},
    { -416, 176, -120},
    { -328, 256, -48},
    { -416, 256, -40},
    { -568, 320, -16},
    { -904, 456, -72},
    { -1000, 520, -136},
    // 90 seconds
    { -1040, 560, -160},
    { -1120, 472, -64},
    { -1616, 608, -224},
    { -1320, 688, -248},
    { -1376, 504, -104},
    { -1320, 456, -8},
    { -1104, 344, 64},
    { -720, 488, -128},
    { -544, 240, 64},
    { -512, 232, 64},
    { -464, 176, 104},
    { -496, 184, 168},
    { -640, 160, 192},
    { -752, 144, 208},
    { -928, 152, 184},
    { -1088, 216, 184},
    { -1328, 344, 80},
    { -1256, 560, -192},
    { -1288, 416, -216},
    { -1072, 288, -104},
    { -752, 288, -184},
    { -504, 336, -240},
    { -384, 424, -248},
    { -416, 336, -248},
    { -544, 312, -104},
    // 91 seconds
    { -600, 416, -152},
    { -824, 456, -224},
    { -1016, 464, -128},
    { -1136, 392, 24},
    { -1496, 552, -136},
    { -1280, 608, -72},
    { -1152, 544, -112},
    { -1128, 584, -128},
    { -1064, 416, -24},
    { -776, 312, 24},
    { -616, 528, 0},
    { -472, 160, 56},
    { -488, 384, 16},
    { -552, 360, 48},
    { -568, 232, 128},
    { -672, 256, 112},
    { -864, 328, 96},
    { -1064, 288, 88},
    { -1352, 232, 88},
    { -1440, 352, 40},
    { -1160, 520, -128},
    { -1048, 232, -56},
    { -768, 160, -120},
    { -520, 208, -192},
    { -328, 232, -128},
    // 92 seconds
    { -360, 280, -112},
    { -496, 376, -88},
    { -632, 376, -32},
    { -848, 392, 16},
    { -800, 440, 8},
    { -1016, 640, -160},
    { -1056, 576, -16},
    { -1872, 768, -280},
    { -1288, 640, -128},
    { -1152, 376, 64},
    { -1280, 520, -48},
    { -976, 408, -48},
    { -584, 456, 48},
    { -440, 344, -8},
    { -496, 336, 16},
    { -528, 256, 120},
    { -592, 152, 168},
    { -624, 176, 128},
    { -792, 224, 128},
    { -936, 216, 104},
    { -1056, 296, 24},
    { -1552, 248, 112},
    { -1416, 384, -24},
    { -1352, 320, -136},
    { -952, 248, -200},
    // 93 seconds
    { -552, 232, -208},
    { -416, 256, -168},
    { -376, 296, -120},
    { -432, 352, -88},
    { -528, 400, -88},
    { -688, 392, -24},
    { -1064, 552, -160},
    { -1216, 576, -96},
    { -1296, 568, -88},
    { -1600, 816, -240},
    { -1112, 576, -96},
    { -1120, 504, -16},
    { -1176, 448, 88},
    { -872, 344, 128},
    { -624, 352, 64},
    { -560, 352, 64},
    { -608, 304, 112},
    { -672, 208, 240},
    { -624, 192, 192},
    { -640, 200, 128},
    { -888, 248, 72},
    { -1088, 224, 88},
    { -1096, 192, 88},
    { -1320, 248, 0},
    { -1104, 400, -96},
    // 94 seconds
    { -1192, 424, -160},
    { -1032, 480, -200},
    { -592, 352, -136},
    { -376, 280, -88},
    { -384, 360, -144},
    { -424, 320, -96},
    { -504, 288, 16},
    { -704, 416, -64},
    { -888, 480, -48},
    { -1176, 592, -152},
    { -1184, 504, -72},
    { -1640, 736, -248},
    { -1400, 600, -208},
    { -1072, 392, -112},
    { -1160, 464, -112},
    { -912, 384, 80},
    { -568, 424, -40},
    { -496, 408, 48},
    { -528, 320, 112},
    { -560, 232, 120},
    { -480, 88, 96},
    { -736, 248, -8},
    { -720, 128, 80},
    { -1048, 152, 8},
    { -1072, 136, -8},
    // 95 seconds
    { -1384, 168, -8},
    { -1408, 288, -64},
    { -1136, 352, -152},
    { -1120, 288, -136},
    { -864, 264, -136},
    { -536, 208, -128},
    { -400, 256, -176},
    { -408, 304, -136},
    { -480, 352, -80},
    { -632, 408, -80},
    { -792, 456, -88},
    { -736, 472, -80},
    { -864, 584, -192},
    { -984, 584, -128},
    { -1464, 712, -224},
    { -1544, 768, -168},
    { -1248, 592, 8},
    { -1288, 624, -128},
    { -1248, 400, -48},
    { -1000, 376, 0},
    { -776, 328, 16},
    { -664, 256, 48},
    { -520, 128, 88},
    { -496, 232, 64},
    { -440, -16, 72},
    // 96 seconds
    { -552, 72, 80},
    { -792, 80, 40},
    { -976, 64, 72},
    { -1144, 120, 40},
    { -1632, 312, 0},
    { -1320, 472, -208},
    { -1312, 368, -48},
    { -1144, 352, -48},
    { -808, 400, -72},
    { -560, 432, -168},
    { -480, 416, -128},
    { -512, 424, -88},
    { -576, 432, -96},
    { -696, 472, -144},
    { -768, 576, -112},
    { -1048, 576, -264},
    { -1200, 472, -128},
    { -1480, 648, -304},
    { -1328, 656, -240},
    { -1208, 576, -184},
    { -1328, 432, -120},
    { -1344, 304, -56},
    { -904, 240, 40},
    { -744, 272, 104},
    { -568, 256, 80},
    // 97 seconds
    { -504, 232, 112},
    { -408, 208, 112},
    { -424, 208, 96},
    { -760, 288, 8},
    { -880, 216, 96},
    { -896, 184, -40},
    { -1352, 136, 32},
    { -1480, 256, -40},
    { -1272, 360, -264},
    { -1216, 176, -16},
    { -864, 176, -72},
    { -568, 280, -328},
    { -480, 176, -192},
    { -480, 216, -144},
    { -608, 328, -128},
    { -640, 392, -104},
    { -840, 504, -208},
    { -968, 520, -160},
    { -1208, 640, -272},
    { -1176, 576, -168},
    { -1648, 624, -256},
    { -1128, 584, -288},
    { -1232, 456, -112},
    { -1224, 360, 24},
    { -1120, 296, -24},
    // 98 seconds
    { -752, 264, 112},
    { -616, 336, 80},
    { -472, 392, 64},
    { -456, 200, 304},
    { -456, 40, 280},
    { -432, 120, 136},
    { -584, 168, 96},
    { -928, 264, 24},
    { -1080, 176, 16},
    { -1400, 128, 0},
    { -1544, 272, -96},
    { -1456, 456, -216},
    { -1240, 272, -88},
    { -952, 304, -160},
    { -544, 248, -120},
    { -392, 280, -112},
    { -416, 328, -104},
    { -504, 312, -80},
    { -584, 304, -16},
    { -800, 424, -80},
    { -920, 496, -80},
    { -984, 560, -152},
    { -1128, 600, -184},
    { -1568, 648, -224},
    { -1328, 560, -216},
    // 99 seconds
    { -1296, 424, -24},
    { -1200, 432, 64},
    { -912, 360, 128},
    { -600, 328, 96},
    { -304, -360, 136},
    { -280, 184, -72},
    { -656, -56, 392},
    { -864, 64, 56},
    { -896, -64, 296},
    { -1016, -264, 192},
    { -1320, -288, 192},
    { -1360, 24, 40},
    { -1760, 280, 56},
    { -1128, 392, -160},
    { -888, 232, -200},
    { -888, 160, -104},
    { -608, 144, -16},
    { -408, 256, -48},
    { -376, 288, -152},
    { -416, 424, -112},
    { -600, 392, -112},
    { -776, 488, -128},
    { -888, 504, -112},
    { -1176, 464, -136},
    { -1312, 312, -88},
    // 100 seconds
    { -1728, 560, -192},
    { -1272, 352, -88},
    { -1104, 312, -64},
    { -1040, 408, -40},
    { -832, 176, 32},
    { -528, 152, 16},
    { -400, 120, 8},
    { -448, 176, 56},
    { -456, 72, 80},
    { -640, 144, 40},
    { -832, 200, 0},
    { -992, 128, 48},
    { -1120, 64, 40},
    { -1560, 144, 56},
    { -1528, 344, -64},
    { -1120, 336, -200},
    { -1120, 16, 136},
    { -936, 144, -64},
    { -440, 56, 40},
    { -304, 280, -136},
    { -408, 352, -72},
    { -480, 384, -64},
    { -656, 440, -136},
    { -872, 448, -104},
    { -984, 456, -32},
    // 101 seconds
    { -1208, 576, -168},
    { -1280, 536, -64},
    { -1488, 728, -272},
    { -1208, 656, -224},
    { -992, 408, -80},
    { -1136, 432, -48},
    { -1120, 376, 40},
    { -864, 448, 24},
    { -664, 328, 56},
    { -640, 288, 80},
    { -560, 168, 136},
    { -512, 112, 120},
    { -552, 16, 152},
    { -888, 272, 80},
    { -1120, 168, 80},
    { -1112, 200, -16},
    { -1520, 64, 144},
    { -1264, 312, -96},
    { -1176, 176, 8},
    { -1072, 184, 16},
    { -720, 208, -96},
    { -520, 264, -80},
    { -512, 392, -152},
    { -552, 392, -104},
    { -696, 432, -128},
    // 102 seconds
    { -960, 520, -208},
    { -976, 576, -232},
    { -1144, 720, -400},
    { -1240, 544, -192},
    { -1544, 496, -352},
    { -1352, 568, -304},
    { -1360, 352, -56},
    { -1224, 296, 144},
    { -1088, 336, 136},
    { -648, 408, 168},
    { -616, 368, 200},
    { -600, 352, 200},
    { -712, 208, 232},
    { -696, 96, 216},
    { -680, 32, 96},
    { -768, 40, 40},
    { -864, -88, 120},
    { -904, 0, -56},
    { -1416, 72, 72},
    { -1576, 256, 40},
    { -1360, 392, -104},
    { -1232, 224, -32},
    { -936, 336, -112},
    { -592, 336, -152},
    { -496, 368, -208},
    // 103 seconds
    { -496, 424, -192},
    { -528, 400, -96},
    { -704, 432, -104},
    { -840, 520, -136},
    { -976, 584, -112},
    { -1160, 696, -184},
    { -1240, 624, -184},
    { -1616, 792, -256},
    { -1400, 536, -64},
    { -1424, 416, -16},
    { -1376, 264, 304},
    { -1032, 176, 272},
    { -600, 24, 200},
    { -424, 240, 112},
    { -376, 192, 104},
    { -400, 128, 144},
    { -496, 160, 160},
    { -624, 184, 128},
    { -880, 272, -8},
    { -1192, 264, 0},
    { -1120, 192, 8},
    { -1576, 176, 88},
    { -1416, 464, -200},
    { -1136, 280, -112},
    { -952, 192, -112},
    // 104 seconds
    { -624, 232, -168},
    { -424, 256, -168},
    { -424, 328, -176},
    { -584, 392, -128},
    { -664, 360, -24},
    { -848, 416, 0},
    { -824, 528, -16},
    { -1032, 552, -40},
    { -1128, 584, 16},
    { -1560, 608, -88},
    { -1328, 648, -208},
    { -1208, 512, -96},
    { -1224, 552, -176},
    { -1104, 392, -32},
    { -824, 336, 0},
    { -536, 304, 56},
    { -504, 304, 104},
    { -520, 208, 144},
    { -512, 160, 176},
    { -520, 176, 184},
    { -624, 240, 120},
    { -928, 312, 48},
    { -1136, 240, 0},
    { -1176, 80, 40},
    { -1560, 120, 32},
    // 105 seconds
    { -1360, 312, -128},
    { -1048, 144, -64},
    { -936, 168, -80},
    { -688, 208, -96},
    { -472, 320, -184},
    { -448, 368, -136},
    { -536, 424, -136},
    { -608, 408, -88},
    { -800, 464, -96},
    { -824, 512, -88},
    { -1016, 600, -192},
    { -1184, 568, -168},
    { -1392, 544, -184},
    { -1384, 616, -296},
    { -1248, 504, -144},
    { -1248, 408, -24},
    { -1208, 328, 80},
    { -872, 344, 64},
    { -632, 360, 56},
    { -520, 304, 88},
    { -528, 200, 128},
    { -480, 112, 160},
    { -448, 168, 152},
    { -552, 80, 200},
    { -928, 216, 152},
    // 106 seconds
    { -1080, 264, 80},
    { -1176, 264, -24},
    { -1496, 264, 24},
    { -1312, 416, -232},
    { -1176, 344, -160},
    { -1040, 288, -112},
    { -736, 288, -160},
    { -464, 320, -184},
    { -384, 320, -152},
    { -416, 384, -128},
    { -512, 400, -128},
    { -680, 376, -56},
    { -872, 448, -56},
    { -1160, 584, -128},
    { -1216, 576, -32},
    { -1424, 680, -224},
    { -1144, 672, -248},
    { -1128, 480, -144},
    { -1248, 512, -80},
    { -1272, 360, 64},
    { -992, 408, -128},
    { -640, 136, 120},
    { -608, 368, 88},
    { -568, 176, 152},
    { -520, 144, 120},
    // 107 seconds
    { -488, 16, 160},
    { -544, 112, 88},
    { -880, 280, 56},
    { -1096, 136, 112},
    { -1080, 168, 8},
    { -1480, 288, -8},
    { -1312, 424, -104},
    { -1224, 328, -64},
    { -1088, 344, -32},
    { -688, 432, -136},
    { -480, 384, -136},
    { -432, 408, -120},
    { -448, 384, -120},
    { -528, 384, -88},
    { -704, 520, -136},
    { -944, 536, -48},
    { -1160, 512, 32},
    { -1080, 512, 32},
    { -1576, 744, -160},
    { -1368, 696, -104},
    { -1248, 512, -40},
    { -1232, 504, -40},
    { -960, 384, 80},
    { -640, 352, 88},
    { -488, 328, 104},
    // 108 seconds
    { -544, 248, 160},
    { -552, 208, 176},
    { -648, 184, 184},
    { -664, 136, 176},
    { -832, 192, 120},
    { -1200, 304, 48},
    { -1128, 448, -48},
    { -1368, 40, 104},
    { -1336, 368, -248},
    { -1112, 232, -168},
    { -992, 168, -152},
    { -712, 272, -216},
    { -432, 280, -200},
    { -328, 288, -152},
    { -472, 312, -40},
    { -600, 392, -8},
    { -680, 528, -96},
    { -752, 552, -112},
    { -840, 472, -72},
    { -1208, 544, -112},
    { -1168, 504, 32},
    { -1496, 792, -264},
    { -1176, 664, -144},
    { -1096, 592, -152},
    { -1200, 576, -120},
    // 109 seconds
    { -1040, 456, 24},
    { -728, 416, 40},
    { -576, 376, 64},
    { -584, 296, 120},
    { -568, 224, 136},
    { -544, 192, 160},
    { -648, 208, 136},
    { -696, 248, 120},
    { -888, 232, 128},
    { -992, 216, 104},
    { -1120, 264, -24},
    { -1248, 152, 72},
    { -1424, 336, -88},
    { -1056, 288, -128},
    { -1040, 328, -176},
    { -840, 456, -192},
    { -536, 368, -160},
    { -488, 488, -200},
    { -512, 488, -144},
    { -568, 432, -72},
    { -688, 488, -64},
    { -720, 512, 0},
    { -816, 544, -48},
    { -1088, 632, -104},
    { -1144, 464, 32},
    // 110 seconds
    { -1576, 560, -104},
    { -1384, 512, -64},
    { -1024, 480, -96},
    { -1064, 512, -176},
    { -1024, 392, 0},
    { -832, 296, 96},
    { -576, 288, 88},
    { -536, 264, 120},
    { -560, 248, 128},
    { -632, 224, 128},
    { -664, 192, 136},
    { -656, 184, 128},
    { -848, 208, 112},
    { -1096, 264, 72},
    { -1128, 248, 72},
    { -1384, 248, 64},
    { -1184, 472, -136},
    { -1008, 464, -248},
    { -1064, 368, -168},
    { -864, 456, -192},
    { -536, 384, -144},
    { -496, 456, -160},
    { -536, 448, -120},
    { -568, 400, -72},
    { -616, 416, -40},
    // 111 seconds
    { -640, 472, -64},
    { -616, 456, -32},
    { -872, 568, -112},
    { -1112, 552, -8},
    { -1512, 600, -72},
    { -1256, 600, -48},
    { -1232, 568, -56},
    { -1144, 592, -80},
    { -1136, 480, -8},
    { -888, 360, 72},
    { -664, 336, 64},
    { -600, 296, 88},
    { -584, 264, 96},
    { -584, 208, 136},
    { -592, 168, 136},
    { -568, 168, 144},
    { -712, 200, 120},
    { -896, 248, 88},
    { -968, 288, -24},
    { -1384, 224, 88},
    { -1440, 360, -24},
    { -1216, 432, -168},
    { -1200, 392, -152},
    { -968, 472, -168},
    { -640, 384, -144},
    // 112 seconds
    { -528, 496, -168},
    { -496, 496, -136},
    { -496, 456, -104},
    { -576, 440, -80},
    { -648, 456, 0},
    { -760, 520, -40},
    { -1016, 624, -88},
    { -1256, 624, -40},
    { -1536, 728, -184},
    { -1376, 464, -24},
    { -1264, 472, -24},
    { -1376, 392, 16},
    { -1080, 376, 80},
    { -736, 320, 64},
    { -576, 336, 56},
    { -568, 264, 104},
    { -552, 208, 144},
    { -528, 152, 152},
    { -576, 120, 144},
    { -736, 184, 104},
    { -976, 192, 136},
    { -1056, 232, 96},
    { -1472, 264, 96},
    { -1144, 368, -32},
    { -1192, 424, -224},
    // 113 seconds
    { -1216, 440, -200},
    { -1000, 440, -152},
    { -656, 456, -152},
    { -528, 560, -200},
    { -496, 456, -80},
    { -480, 408, -48},
    { -576, 464, -64},
    { -664, 496, -40},
    { -736, 496, -24},
    { -944, 568, -40},
    { -968, 536, 8},
    { -2024, 784, -136},
    { -1448, 376, 96},
    { -1184, 280, -40},
    { -1624, 400, -120},
    { -1048, 88, 72},
    { -576, 104, 80},
    { -480, 168, 112},
    { -536, 264, 176},
    { -704, 336, 192},
    { -664, 368, 176},
    { -496, 376, 160},
    { -448, 368, 136},
    { -496, 424, 80},
    { -552, 424, 24},
    // 114 seconds
    { -568, 400, -32},
    { -664, 352, -80},
    { -856, 320, -64},
    { -1216, 296, -8},
    { -1864, 368, -24},
    { -1496, 616, -296},
    { -888, 488, -344},
    { -992, 488, -168},
    { -568, 416, -136},
    { -392, 392, -128},
    { -384, 408, -96},
    { -488, 424, -32},
    { -664, 400, 8},
    { -752, 424, 48},
    { -616, 456, 8},
    { -648, 512, -96},
    { -808, 480, -104},
    { -856, 312, 64},
    { -1544, 400, -56},
    { -2040, 520, 48},
    { -928, 160, 216},
    { -1560, 576, -296},
    { -1144, 304, -80},
    { -608, 112, 176},
    { -424, 160, -144},
    // 115 seconds
    { -728, 320, 64},
    { -696, 184, 304},
    { -768, 88, 240},
    { -864, 208, 112},
    { -856, 296, 104},
    { -808, 360, 56},
    { -808, 360, 32},
    { -936, 520, -128},
    { -896, 728, 32},
    { -688, 760, -128},
    { -496, 768, -240},
    { -640, 712, -112},
    { -752, 896, -136},
    { -608, -200, -176},
    { -720, 176, -184},
    { -1128, 624, -392},
    { -912, 928, -648},
    { -600, 1048, -1144},
    { -320, 888, -968},
    { -208, 456, -752},
    { -192, 120, -640},
    { -256, 304, -608},
    { -208, -32, -600},
    { -272, 32, -680},
    { -336, -112, -656},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:04:24 local
AccelRawData *activity_sample_walk_200_pbl_25657_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25657_10
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 40, -120, -944},
    { -80, -120, -912},
    { 104, -496, -976},
    { -96, -32, -896},
    { 144, -168, -984},
    { 120, -216, -920},
    { 16, -200, -920},
    { -48, -176, -960},
    { -16, -240, -872},
    { 40, -264, -984},
    { -24, -240, -904},
    { -16, -208, -920},
    { 80, -264, -1008},
    { 144, -176, -912},
    { 112, -40, -896},
    { 112, -336, -936},
    { 120, -312, -888},
    { 96, -224, -904},
    { 176, -256, -880},
    { 88, -104, -896},
    { 88, -328, -848},
    { -8, -352, -928},
    { -24, -416, -976},
    { 64, -176, -976},
    { 72, -224, -1064},
    // 1 seconds
    { 400, -128, -1152},
    { -72, -112, -1024},
    { -8, 8, -912},
    { 88, 24, -816},
    { 40, 456, -888},
    { 152, -120, -664},
    { 88, 576, -632},
    { 96, 816, -760},
    { 344, 416, -656},
    { 248, 376, -496},
    { 224, 144, -512},
    { 88, 232, -168},
    { -88, 368, -160},
    { -184, 376, -152},
    { -344, 600, -128},
    { -608, 584, 8},
    { -1000, 504, 64},
    { -1944, 1112, 40},
    { -2416, 1672, -24},
    { -1536, 1832, 144},
    { -1432, 240, 280},
    { -1056, -216, -64},
    { -680, 0, -432},
    { -656, 88, -160},
    { -664, 136, -216},
    // 2 seconds
    { -520, -72, 120},
    { -456, 224, -16},
    { -592, 416, -224},
    { -584, 344, -56},
    { -632, 264, -200},
    { -672, 480, -176},
    { -520, 336, -144},
    { -720, 312, -184},
    { -1152, 400, -96},
    { -1824, 344, -176},
    { -1288, 504, -160},
    { -1024, 600, -208},
    { -1104, 616, -248},
    { -776, 376, 24},
    { -432, 320, -72},
    { -392, 368, -80},
    { -360, 360, -16},
    { -440, 328, 32},
    { -544, 312, -16},
    { -616, 312, 48},
    { -712, 408, 40},
    { -1112, 352, 0},
    { -1168, 80, 152},
    { -1344, 216, 96},
    { -1264, 296, -248},
    // 3 seconds
    { -1232, 104, 104},
    { -1216, -64, -96},
    { -904, -40, -96},
    { -568, 16, -216},
    { -328, 96, -176},
    { -328, 336, -216},
    { -400, 224, -120},
    { -584, 256, -176},
    { -840, 248, -136},
    { -904, 184, -56},
    { -1224, 312, -240},
    { -1392, 392, -136},
    { -1712, 336, -224},
    { -1360, -120, -200},
    { -1232, -80, -176},
    { -1224, 136, -208},
    { -840, 80, -88},
    { -480, 104, -104},
    { -392, 400, 8},
    { -432, 168, -80},
    { -488, 304, 48},
    { -544, 120, 0},
    { -640, 240, 48},
    { -864, 152, -40},
    { -1144, 192, -40},
    // 4 seconds
    { -1312, 240, 40},
    { -1360, 368, -520},
    { -1216, 152, -120},
    { -1224, 104, -232},
    { -960, 56, -288},
    { -544, 88, -216},
    { -288, 112, -320},
    { -272, 272, -264},
    { -392, 344, -248},
    { -608, 344, -184},
    { -792, 296, -200},
    { -984, 184, -136},
    { -1216, 384, -432},
    { -1192, 240, 40},
    { -1472, 464, -432},
    { -1064, 336, -320},
    { -1280, 528, -376},
    { -1184, 352, -216},
    { -936, 368, 0},
    { -632, 296, -48},
    { -400, 256, -8},
    { -400, 160, 48},
    { -400, 136, -40},
    { -560, 256, 8},
    { -664, 160, 48},
    // 5 seconds
    { -888, 184, 40},
    { -1272, 288, -24},
    { -1128, 144, 8},
    { -1288, 384, -200},
    { -1144, 216, -224},
    { -1216, 72, -112},
    { -1048, 240, -288},
    { -600, 264, -248},
    { -288, 256, -280},
    { -224, 280, -176},
    { -280, 360, -184},
    { -384, 200, -136},
    { -864, 384, -120},
    { -1056, 344, -256},
    { -1176, 280, -96},
    { -1416, 384, -328},
    { -1728, 744, -296},
    { -1208, 600, -416},
    { -1072, 272, -256},
    { -992, 328, -104},
    { -712, 376, -64},
    { -376, 280, 32},
    { -344, 384, -8},
    { -400, 200, 80},
    { -440, 168, 144},
    // 6 seconds
    { -640, 312, 104},
    { -816, 32, -24},
    { -1152, 184, 152},
    { -1320, 208, -56},
    { -1480, -88, 48},
    { -1304, 544, -256},
    { -1208, 144, -264},
    { -992, 72, -152},
    { -528, 280, -192},
    { -272, 328, -248},
    { -200, 360, -216},
    { -224, 320, -176},
    { -424, 368, -112},
    { -736, 360, -208},
    { -936, 472, -128},
    { -1104, 544, -120},
    { -1176, 536, -184},
    { -1632, 608, -136},
    { -1400, 424, -224},
    { -1360, 128, 32},
    { -1168, 336, -112},
    { -744, 248, -48},
    { -368, 200, -48},
    { -360, 280, -56},
    { -392, 160, 8},
    // 7 seconds
    { -448, 240, 80},
    { -560, 280, -24},
    { -648, 312, -48},
    { -880, 256, 64},
    { -1144, 256, 144},
    { -1304, 336, -96},
    { -1448, 232, -24},
    { -1376, 312, -176},
    { -1304, 208, -248},
    { -872, 0, -216},
    { -288, 64, -56},
    { -272, 272, -240},
    { -248, 376, -184},
    { -400, 288, -112},
    { -648, 248, -64},
    { -856, 312, -176},
    { -1024, 408, -104},
    { -1232, 448, -208},
    { -1136, 448, -88},
    { -1536, 720, -400},
    { -1384, 408, -208},
    { -1048, 48, 32},
    { -1128, 416, 0},
    { -712, -40, -56},
    { -304, 120, -64},
    // 8 seconds
    { -384, 232, -24},
    { -544, 96, 104},
    { -624, 120, 144},
    { -832, 232, -96},
    { -864, 96, 96},
    { -1144, 208, 56},
    { -1224, 16, 120},
    { -1368, 168, -16},
    { -1368, 8, -280},
    { -1096, 152, -352},
    { -1128, -48, -216},
    { -816, -8, -272},
    { -392, 240, -280},
    { -368, 232, -168},
    { -360, 192, -152},
    { -456, 152, -8},
    { -720, 312, 48},
    { -832, 256, -88},
    { -872, 312, 24},
    { -1056, 480, -96},
    { -1064, 296, -40},
    { -1608, 392, -280},
    { -1192, 304, -480},
    { -1408, 280, -160},
    { -1248, 136, -344},
    // 9 seconds
    { -1000, 184, -8},
    { -592, 280, -160},
    { -400, 152, -48},
    { -400, 48, 40},
    { -352, 112, 8},
    { -544, 160, 64},
    { -704, 208, 168},
    { -1000, 328, 104},
    { -1368, 32, 216},
    { -1440, -184, 184},
    { -1704, 72, 192},
    { -1280, 288, -200},
    { -1136, -24, -184},
    { -920, 48, -136},
    { -616, 232, -160},
    { -360, 320, -168},
    { -296, 424, -152},
    { -400, 368, -112},
    { -528, 376, -168},
    { -728, 248, -64},
    { -952, 304, -96},
    { -1168, 472, -248},
    { -1264, 24, 72},
    { -1880, 192, -176},
    { -1432, 112, 32},
    // 10 seconds
    { -1248, 192, -8},
    { -1096, 296, -136},
    { -736, 304, -56},
    { -400, 232, 24},
    { -288, 40, 8},
    { -384, 184, 32},
    { -488, 112, 80},
    { -664, 144, 176},
    { -856, 216, 112},
    { -1024, 32, 200},
    { -1376, -8, 40},
    { -1760, -128, 248},
    { -1488, 408, -104},
    { -888, 152, -224},
    { -976, 8, -136},
    { -680, 96, -104},
    { -424, 240, -144},
    { -360, 408, -224},
    { -376, 328, -96},
    { -528, 296, -104},
    { -728, 408, -200},
    { -880, 392, -72},
    { -1104, 504, -176},
    { -1280, 304, -16},
    { -1880, 456, -360},
    // 11 seconds
    { -1464, 352, -208},
    { -1088, 232, -48},
    { -1080, 376, 168},
    { -960, 328, 56},
    { -544, 32, 112},
    { -328, -40, 184},
    { -464, 288, 64},
    { -352, 48, 192},
    { -504, 136, 160},
    { -640, 304, -8},
    { -1072, 136, 208},
    { -1264, 184, 120},
    { -1616, 216, 64},
    { -1648, 328, -32},
    { -1296, -120, -128},
    { -968, -136, -120},
    { -768, 240, -272},
    { -304, 256, -208},
    { -208, 288, -144},
    { -240, 224, -168},
    { -472, 200, -120},
    { -784, 256, -32},
    { -1080, 384, -64},
    { -1224, 352, -136},
    { -1272, 416, -128},
    // 12 seconds
    { -1592, 96, -248},
    { -1568, 248, -304},
    { -1168, 104, -72},
    { -976, 248, -80},
    { -864, 224, -80},
    { -560, 200, -16},
    { -392, 184, -8},
    { -424, 216, 40},
    { -504, 216, 80},
    { -536, 184, 56},
    { -640, 280, 24},
    { -768, 328, -56},
    { -1072, 208, 56},
    { -1432, 216, -40},
    { -1424, 72, -32},
    { -1488, 216, -104},
    { -936, 56, -128},
    { -880, 72, -128},
    { -584, 0, -152},
    { -288, 88, -40},
    { -304, 192, -152},
    { -448, 336, -208},
    { -536, 256, -128},
    { -936, 400, -160},
    { -952, 440, -128},
    // 13 seconds
    { -984, 280, -48},
    { -1192, 504, -248},
    { -1328, 176, -208},
    { -1392, 440, -440},
    { -1328, 336, -160},
    { -1184, 248, 24},
    { -1008, 240, -128},
    { -512, 192, -32},
    { -424, 336, -8},
    { -456, 256, 0},
    { -464, 200, 24},
    { -488, 320, 32},
    { -648, 416, 0},
    { -736, 304, 8},
    { -1000, 256, 112},
    { -1104, 280, -24},
    { -1192, -16, 104},
    { -1360, 312, -304},
    { -1376, 144, -80},
    { -1112, 0, -32},
    { -912, 176, -176},
    { -528, 0, -128},
    { -312, 288, -352},
    { -352, 256, -144},
    { -424, 312, 0},
    // 14 seconds
    { -664, 384, -168},
    { -784, 272, -128},
    { -832, 424, -176},
    { -936, 488, -136},
    { -1184, 440, -280},
    { -1384, 312, -48},
    { -1288, 584, -352},
    { -1432, 512, -208},
    { -1216, 368, -128},
    { -896, 336, -72},
    { -584, 416, -80},
    { -392, 272, -16},
    { -376, 176, 24},
    { -448, 152, 96},
    { -600, 248, 8},
    { -680, 232, 88},
    { -848, 256, 24},
    { -1144, 200, 8},
    { -1120, 72, 104},
    { -1320, 384, -248},
    { -1104, 336, -128},
    { -1144, 336, -216},
    { -1200, 296, -296},
    { -712, 128, -208},
    { -336, 96, -224},
    // 15 seconds
    { -264, 128, -184},
    { -248, 136, -176},
    { -416, 200, -64},
    { -624, 328, -208},
    { -816, 312, -88},
    { -960, 472, -192},
    { -1144, 424, -328},
    { -1312, 448, -112},
    { -1520, 520, -304},
    { -1432, 632, -320},
    { -1192, 488, -232},
    { -1056, 376, -48},
    { -568, 248, -64},
    { -352, 288, -80},
    { -368, 312, -64},
    { -392, 208, 120},
    { -512, 288, -120},
    { -568, 304, 96},
    { -584, 336, 112},
    { -968, 312, -48},
    { -1088, 272, -40},
    { -1416, 208, -144},
    { -1552, 424, -240},
    { -1112, 384, -312},
    { -1104, 152, -216},
    // 16 seconds
    { -888, 104, -304},
    { -568, 200, -240},
    { -288, 104, -32},
    { -328, 280, -160},
    { -344, 224, -96},
    { -392, 248, -40},
    { -528, 344, -56},
    { -704, 520, -184},
    { -1000, 600, -120},
    { -1272, 512, -368},
    { -1576, 448, -136},
    { -1368, 816, -352},
    { -1040, 560, -168},
    { -1072, 664, -208},
    { -864, 360, -64},
    { -536, 304, -24},
    { -408, 368, -24},
    { -424, 352, -40},
    { -384, 192, 0},
    { -448, 168, 16},
    { -536, 216, 24},
    { -720, 408, -40},
    { -1088, 272, -120},
    { -1240, 136, -72},
    { -1536, 488, -192},
    // 17 seconds
    { -1352, 384, -232},
    { -1040, 488, -456},
    { -1016, 144, -136},
    { -816, 112, -184},
    { -496, 80, -136},
    { -272, 88, -200},
    { -272, 104, -120},
    { -392, 184, -104},
    { -576, 296, -96},
    { -704, 368, -88},
    { -800, 464, -184},
    { -976, 480, -120},
    { -1184, 400, -320},
    { -1448, 376, -256},
    { -1288, 664, -304},
    { -1000, 496, -248},
    { -1008, 536, -184},
    { -960, 240, 64},
    { -616, 216, -64},
    { -416, 320, -112},
    { -368, 232, 0},
    { -504, 304, -8},
    { -544, 168, 104},
    { -608, 240, -24},
    { -776, 280, 72},
    // 18 seconds
    { -1168, 280, -128},
    { -1096, 136, -96},
    { -1528, 512, -144},
    { -1256, 432, -368},
    { -944, 344, -296},
    { -1032, 304, -304},
    { -792, 120, -240},
    { -408, -48, -208},
    { -352, 200, -184},
    { -368, 72, -120},
    { -520, 112, -16},
    { -656, 168, -136},
    { -696, 232, -144},
    { -840, 360, -248},
    { -1088, 320, -248},
    { -1264, 344, -232},
    { -1648, 488, -616},
    { -1280, 152, -208},
    { -1304, 504, -320},
    { -1048, 216, -160},
    { -712, 200, -152},
    { -408, 168, -80},
    { -328, 216, -16},
    { -384, 240, -24},
    { -488, 264, 0},
    // 19 seconds
    { -648, 320, 24},
    { -792, 280, -80},
    { -968, 232, 8},
    { -1120, 344, -128},
    { -1272, 232, -152},
    { -1168, 224, -144},
    { -1296, 328, -128},
    { -952, 288, -256},
    { -856, 192, -312},
    { -656, 32, -144},
    { -400, 104, -208},
    { -312, 152, -192},
    { -304, 176, -144},
    { -456, 176, -152},
    { -624, 232, -152},
    { -856, 312, -152},
    { -1208, 336, -216},
    { -1288, 328, -96},
    { -1528, 408, -248},
    { -1240, 520, -312},
    { -920, 400, -208},
    { -904, 360, -104},
    { -904, 232, -24},
    { -592, 192, -24},
    { -392, 272, -104},
    // 20 seconds
    { -432, 280, -64},
    { -480, 176, 8},
    { -560, 168, -8},
    { -688, 240, -8},
    { -888, 280, -40},
    { -1184, 216, -24},
    { -1112, 128, 96},
    { -1344, 584, -288},
    { -1184, 184, -16},
    { -1208, 224, -216},
    { -1048, 168, -328},
    { -624, -16, -216},
    { -312, 128, -248},
    { -256, 136, -128},
    { -304, 136, -224},
    { -464, 192, -152},
    { -720, 280, -120},
    { -888, 320, -144},
    { -960, 352, -136},
    { -1080, 384, -200},
    { -1288, 512, -64},
    { -1384, 424, -328},
    { -1192, 320, -184},
    { -1112, 544, -240},
    { -1032, 288, -224},
    // 21 seconds
    { -616, 264, -56},
    { -360, 448, -136},
    { -352, 344, -200},
    { -392, 224, -96},
    { -480, 200, 32},
    { -688, 248, 0},
    { -880, 184, 128},
    { -1176, 272, 80},
    { -1032, 184, 272},
    { -1424, 480, -352},
    { -1224, 8, -16},
    { -1200, 408, -144},
    { -1016, 152, -264},
    { -688, 56, -264},
    { -344, 136, -216},
    { -288, 184, -264},
    { -344, 176, -176},
    { -504, 248, -256},
    { -680, 272, -176},
    { -824, 272, -160},
    { -992, 312, -208},
    { -1136, 384, -192},
    { -1304, 392, -208},
    { -1488, 480, -328},
    { -1152, 432, -128},
    // 22 seconds
    { -1120, 448, -144},
    { -1024, 296, -216},
    { -664, 160, 72},
    { -432, 176, -96},
    { -352, 256, -104},
    { -392, 272, -8},
    { -472, 256, -24},
    { -608, 232, -32},
    { -768, 272, -40},
    { -1104, 264, -80},
    { -1328, 368, -160},
    { -1296, 16, 8},
    { -1296, 376, -104},
    { -1024, 128, -224},
    { -1008, 8, -104},
    { -824, 112, -200},
    { -504, 96, -200},
    { -304, 232, -232},
    { -336, 256, -168},
    { -472, 192, -160},
    { -608, 208, -112},
    { -800, 312, -184},
    { -960, 536, -56},
    { -1168, 416, -328},
    { -1392, 240, -160},
    // 23 seconds
    { -1528, 448, -296},
    { -1160, 352, -328},
    { -944, 336, -152},
    { -928, 336, -144},
    { -776, 224, -24},
    { -568, 264, -40},
    { -448, 248, -24},
    { -440, 264, -40},
    { -456, 200, 16},
    { -576, 256, -24},
    { -672, 224, 16},
    { -816, 200, -56},
    { -1216, 400, -104},
    { -1288, -8, -8},
    { -1424, 104, -48},
    { -1192, 272, -168},
    { -1040, 176, -224},
    { -936, 96, -176},
    { -632, 64, -152},
    { -376, 104, -176},
    { -344, 128, -168},
    { -384, 192, -112},
    { -576, 240, -136},
    { -768, 280, -112},
    { -968, 344, -136},
    // 24 seconds
    { -1016, 376, -168},
    { -1160, 328, -208},
    { -1392, 352, -224},
    { -1248, 512, -336},
    { -1176, 408, -232},
    { -1096, 352, -256},
    { -920, 312, -80},
    { -576, 280, -16},
    { -400, 312, -72},
    { -368, 248, -48},
    { -480, 192, 8},
    { -584, 232, 8},
    { -752, 272, 8},
    { -904, 240, -32},
    { -1168, 216, 64},
    { -1104, 240, -128},
    { -1368, 152, -112},
    { -1272, 208, -120},
    { -1072, 272, -232},
    { -984, 112, -232},
    { -616, 72, -192},
    { -328, 40, -240},
    { -312, 112, -192},
    { -360, 160, -136},
    { -560, 256, -168},
    // 25 seconds
    { -728, 280, -112},
    { -928, 400, -128},
    { -984, 392, -144},
    { -1160, 432, -296},
    { -1424, 368, -296},
    { -1288, 360, -304},
    { -1192, 464, -296},
    { -1088, 408, -272},
    { -1000, 296, -192},
    { -728, 304, -136},
    { -496, 304, -64},
    { -440, 288, -40},
    { -472, 216, 8},
    { -504, 176, 32},
    { -616, 192, 16},
    { -736, 256, 48},
    { -992, 216, -64},
    { -1144, 256, -128},
    { -1168, 128, -168},
    { -1416, 400, -256},
    { -1144, 160, -264},
    { -1088, 160, -240},
    { -864, 144, -256},
    { -576, 136, -192},
    { -448, 184, -96},
    // 26 seconds
    { -416, 240, -88},
    { -416, 280, -128},
    { -488, 296, -120},
    { -648, 376, -208},
    { -800, 368, -136},
    { -1016, 472, -320},
    { -1088, 400, -224},
    { -1576, 552, -264},
    { -1440, 592, -440},
    { -1048, 344, -184},
    { -1192, 464, -296},
    { -1048, 344, -192},
    { -768, 304, -104},
    { -560, 320, -104},
    { -568, 288, -56},
    { -520, 208, 0},
    { -520, 176, 8},
    { -520, 264, -72},
    { -600, 248, 64},
    { -808, 288, -168},
    { -1048, 184, 0},
    { -1000, 208, -256},
    { -1216, 224, -104},
    { -1384, 296, -216},
    { -880, 216, -192},
    // 27 seconds
    { -912, 256, -192},
    { -768, 232, -208},
    { -648, 216, -168},
    { -512, 256, -168},
    { -512, 312, -208},
    { -552, 320, -184},
    { -664, 408, -232},
    { -712, 368, -176},
    { -872, 504, -328},
    { -936, 392, -272},
    { -1320, 528, -264},
    { -1624, 576, -360},
    { -1368, 496, -304},
    { -1112, 448, -216},
    { -1200, 400, -200},
    { -1048, 256, 16},
    { -800, 176, 96},
    { -616, 216, 80},
    { -496, 88, 120},
    { -432, 104, 104},
    { -504, 152, 112},
    { -592, 136, 64},
    { -640, 184, -88},
    { -848, 96, 8},
    { -1088, 136, -8},
    // 28 seconds
    { -1400, 112, -80},
    { -1592, 248, -160},
    { -1256, 360, -304},
    { -960, 248, -272},
    { -904, 296, -320},
    { -624, 224, -336},
    { -408, 280, -272},
    { -352, 200, -240},
    { -456, 264, -184},
    { -584, 272, -144},
    { -704, 448, -184},
    { -728, 488, -192},
    { -792, 400, -144},
    { -1056, 528, -280},
    { -1160, 360, -176},
    { -1520, 528, -456},
    { -1088, 408, -168},
    { -1280, 448, -296},
    { -1440, 392, -56},
    { -1040, 304, 24},
    { -696, 368, -8},
    { -480, 336, 24},
    { -536, 312, 88},
    { -504, 280, 80},
    { -392, 248, 24},
    // 29 seconds
    { -448, 272, -40},
    { -448, 128, 192},
    { -736, 280, -192},
    { -936, 264, -104},
    { -1288, 288, -168},
    { -1384, 280, -192},
    { -1464, 384, -352},
    { -1464, 384, -288},
    { -1112, 200, -240},
    { -616, 200, -264},
    { -304, 216, -256},
    { -160, 256, -144},
    { -192, 248, -112},
    { -320, 288, -104},
    { -680, 280, -136},
    { -936, 440, -128},
    { -952, 384, -128},
    { -968, 408, -104},
    { -1248, 648, -240},
    { -1856, 632, -232},
    { -1480, 488, -200},
    { -1400, 472, -144},
    { -1096, 224, 16},
    { -584, 312, -96},
    { -280, 344, 16},
    // 30 seconds
    { -440, 192, 112},
    { -328, 184, 192},
    { -472, 304, 128},
    { -600, 256, -40},
    { -848, 128, 160},
    { -1496, 272, -208},
    { -1504, -64, 160},
    { -1416, 184, -48},
    { -1264, 288, -248},
    { -1304, 64, -144},
    { -984, 40, -224},
    { -696, 152, -208},
    { -456, 272, -240},
    { -352, 280, -160},
    { -328, 288, -136},
    { -336, 200, -128},
    { -528, 360, -296},
    { -872, 208, -160},
    { -1392, 376, -408},
    { -1232, 344, -168},
    { -1536, 568, -464},
    { -1280, 472, -520},
    { -1008, 392, -352},
    { -1144, 528, -176},
    { -968, 384, -16},
    // 31 seconds
    { -680, 304, 24},
    { -512, 392, 64},
    { -344, 240, 72},
    { -400, 336, 80},
    { -360, 336, 16},
    { -320, 352, 40},
    { -440, 816, -32},
    { -920, 152, -136},
    { -1272, 16, 0},
    { -1496, 144, -56},
    { -1672, 40, 32},
    { -1432, 136, 0},
    { -1200, 192, -40},
    { -976, 256, -136},
    { -576, 240, -256},
    { -344, 312, -224},
    { -320, 208, -184},
    { -520, 400, -152},
    { -616, 408, -208},
    { -856, 552, -160},
    { -1080, 384, -328},
    { -1056, 368, -264},
    { -1536, 512, -360},
    { -1568, 448, -376},
    { -1368, 376, -256},
    // 32 seconds
    { -1184, 304, -56},
    { -1096, 288, 8},
    { -848, 240, 48},
    { -504, 216, 120},
    { -400, 256, 0},
    { -432, 264, 96},
    { -424, 256, 184},
    { -424, 128, 184},
    { -752, 440, 40},
    { -768, 216, 24},
    { -1200, 128, -8},
    { -1264, 8, -40},
    { -1640, 80, 48},
    { -1456, 224, -192},
    { -1048, 240, -200},
    { -992, 176, -160},
    { -760, 160, -160},
    { -504, 184, -144},
    { -424, 208, -160},
    { -448, 272, -144},
    { -800, 440, -144},
    { -720, 440, -96},
    { -864, 320, -208},
    { -864, 296, -184},
    { -1136, 424, -240},
    // 33 seconds
    { -1424, 488, -368},
    { -1400, 376, -376},
    { -1216, 360, -240},
    { -1240, 400, -136},
    { -1360, 352, 8},
    { -1024, 160, 176},
    { -648, 136, 104},
    { -512, 264, 8},
    { -472, 200, 128},
    { -472, 120, 64},
    { -512, 128, 144},
    { -648, 88, 72},
    { -784, 168, 56},
    { -976, 176, 88},
    { -1160, 368, -56},
    { -1408, 264, -128},
    { -1272, 424, -256},
    { -1056, 336, -248},
    { -1000, 168, -120},
    { -752, 240, -152},
    { -488, 240, -152},
    { -440, 344, -176},
    { -480, 336, -144},
    { -488, 312, -64},
    { -592, 368, -168},
    // 34 seconds
    { -976, 464, -136},
    { -1136, 272, -176},
    { -1296, 248, -128},
    { -1312, 400, -280},
    { -1472, 344, -336},
    { -1232, 128, -176},
    { -1128, 168, -24},
    { -1088, 216, 32},
    { -776, 248, 24},
    { -552, 224, 40},
    { -472, 256, 40},
    { -552, 288, 104},
    { -560, 184, 128},
    { -616, 112, 128},
    { -768, 360, 192},
    { -1104, 104, -120},
    { -1144, -224, 168},
    { -1584, 208, 120},
    { -1256, 120, -152},
    { -1224, 48, -104},
    { -1096, 48, -168},
    { -728, 104, -128},
    { -384, 136, -120},
    { -384, 240, -152},
    { -528, 304, -72},
    // 35 seconds
    { -712, 384, -72},
    { -856, 408, 64},
    { -912, 384, -104},
    { -968, 608, 120},
    { -856, 384, -120},
    { -1368, 640, -208},
    { -1456, 736, -288},
    { -1328, 360, 40},
    { -1376, 472, -48},
    { -1192, 272, 96},
    { -792, 160, 152},
    { -560, 280, 80},
    { -656, 200, 272},
    { -528, 120, 240},
    { -416, 112, 184},
    { -464, 208, 112},
    { -584, 280, 32},
    { -840, 152, 96},
    { -992, 272, -136},
    { -1256, 264, -72},
    { -1480, 280, -200},
    { -1264, 304, -344},
    { -1192, 232, -232},
    { -800, 232, -144},
    { -496, 176, -144},
    // 36 seconds
    { -400, 208, -104},
    { -424, 256, -64},
    { -488, 296, -56},
    { -640, 288, -64},
    { -792, 368, -16},
    { -888, 520, -72},
    { -1080, 504, -96},
    { -1104, 656, -72},
    { -1656, 456, -320},
    { -1472, 400, -128},
    { -1264, 448, -112},
    { -1144, 304, -56},
    { -808, 288, -8},
    { -536, 256, -40},
    { -344, 256, 112},
    { -392, 288, 136},
    { -440, 328, 160},
    { -632, 336, 152},
    { -792, 464, 176},
    { -952, 456, 232},
    { -1280, 448, 320},
    { -992, 96, 0},
    { -1216, 32, 120},
    { -1328, 104, 48},
    { -1328, 168, -80},
    // 37 seconds
    { -1152, 104, -208},
    { -640, 168, -232},
    { -344, 176, -128},
    { -272, 328, -56},
    { -392, 376, 32},
    { -456, 360, 88},
    { -672, 400, 24},
    { -864, 392, 8},
    { -1104, 680, 16},
    { -1192, 320, -56},
    { -1808, 768, -96},
    { -1280, 688, -96},
    { -1256, 592, -24},
    { -1256, 432, -48},
    { -944, 288, 72},
    { -568, 248, 64},
    { -448, 304, 24},
    { -480, 304, 88},
    { -504, 240, 144},
    { -608, 192, 168},
    { -688, 288, 128},
    { -800, 200, 72},
    { -1296, 368, 120},
    { -1416, 16, -136},
    { -1352, 72, 96},
    // 38 seconds
    { -1240, 304, -176},
    { -1080, 296, -160},
    { -1032, 144, -24},
    { -840, 168, -152},
    { -520, 160, -112},
    { -376, 240, -144},
    { -400, 272, -136},
    { -456, 232, -16},
    { -640, 360, -128},
    { -776, 376, -56},
    { -1088, 512, -360},
    { -1264, 376, -104},
    { -1480, 520, -160},
    { -1344, 712, -248},
    { -1104, 456, -328},
    { -904, 464, -208},
    { -1072, 360, -184},
    { -960, 256, -24},
    { -656, 248, 8},
    { -480, 312, 24},
    { -520, 376, 88},
    { -504, 208, 120},
    { -584, 160, 64},
    { -688, 256, 40},
    { -776, 392, 56},
    // 39 seconds
    { -976, 16, 144},
    { -1144, 80, -72},
    { -1408, 112, 112},
    { -1520, 288, 24},
    { -1160, 216, -192},
    { -1160, 72, -128},
    { -872, 248, -256},
    { -480, 272, -312},
    { -408, 312, -232},
    { -432, 112, -160},
    { -496, 192, -128},
    { -656, 392, -144},
    { -816, 312, -104},
    { -880, 392, -120},
    { -1160, 352, -280},
    { -1232, 320, -272},
    { -1440, 456, -336},
    { -1248, 488, -360},
    { -1168, 344, -248},
    { -1264, 360, -272},
    { -1000, 248, -56},
    { -648, 240, 0},
    { -520, 440, 88},
    { -528, 224, 56},
    { -496, 160, 104},
    // 40 seconds
    { -528, 144, 120},
    { -664, 288, 56},
    { -760, 184, 96},
    { -1008, 128, 96},
    { -1152, 296, -216},
    { -1344, 8, -8},
    { -1384, 328, -344},
    { -1216, 168, -120},
    { -1096, 248, -272},
    { -832, 208, -144},
    { -488, 224, -224},
    { -376, 168, -200},
    { -344, 120, -104},
    { -488, 336, -104},
    { -640, 376, -56},
    { -800, 352, -16},
    { -1032, 576, 8},
    { -1184, 584, -72},
    { -1152, 752, 104},
    { -1328, 504, -152},
    { -1144, 736, -88},
    { -992, 640, -24},
    { -1200, 640, 24},
    { -1056, 424, 208},
    { -696, 384, 120},
    // 41 seconds
    { -504, 160, 256},
    { -520, 312, 176},
    { -560, 128, 200},
    { -584, 208, 240},
    { -648, 224, 200},
    { -704, 216, 272},
    { -1024, 536, 240},
    { -984, 64, 40},
    { -1304, 304, -96},
    { -1456, -40, 32},
    { -1312, 280, -120},
    { -1112, 264, -104},
    { -864, 144, -136},
    { -592, 224, -152},
    { -456, 288, -72},
    { -408, 280, -64},
    { -440, 240, -56},
    { -608, 424, -80},
    { -768, 384, -88},
    { -976, 568, -96},
    { -1152, 584, -328},
    { -1016, 424, -320},
    { -1400, 688, -368},
    { -1264, 848, -400},
    { -1096, 1216, 48},
    // 42 seconds
    { -1344, 888, 0},
    { -1088, 736, 256},
    { -952, 680, 384},
    { -728, 360, 280},
    { -544, 400, 224},
    { -424, 184, 232},
    { -456, 200, 224},
    { -496, 72, 96},
    { -448, 248, 200},
    { -600, 320, -88},
    { -856, 736, 216},
    { -1008, 768, 128},
    { -1136, 816, 344},
    { -824, 968, 232},
    { -736, 952, 16},
    { -712, 528, 128},
    { -640, 416, 128},
    { -568, 408, 144},
    { -496, 448, 216},
    { -520, 536, 240},
    { -616, 560, 232},
    { -840, 568, 280},
    { -888, 576, 368},
    { -1048, 816, 272},
    { -992, 776, 224},
    // 43 seconds
    { -1488, 1112, 72},
    { -1248, 904, 72},
    { -1040, 816, -16},
    { -976, 840, -8},
    { -1040, 600, 208},
    { -920, 512, 248},
    { -816, 432, 336},
    { -752, 384, 312},
    { -616, 296, 232},
    { -528, 280, 240},
    { -408, 248, 144},
    { -408, 248, 128},
    { -616, 376, 72},
    { -840, 368, -56},
    { -1256, 376, -64},
    { -1352, 640, -152},
    { -1368, 488, -120},
    { -1112, 376, 80},
    { -960, 584, -112},
    { -656, 456, 8},
    { -512, 408, -56},
    { -480, 496, 0},
    { -488, 400, 80},
    { -640, 392, 96},
    { -776, 560, 136},
    // 44 seconds
    { -872, 600, 96},
    { -976, 768, -32},
    { -984, 752, 96},
    { -1368, 928, -88},
    { -1112, 768, -104},
    { -976, 792, -88},
    { -1080, 680, -160},
    { -1032, 528, 16},
    { -872, 392, 152},
    { -656, 264, 80},
    { -616, 336, 104},
    { -600, 208, 128},
    { -616, 168, 152},
    { -616, 168, 112},
    { -608, 192, 176},
    { -768, 184, 168},
    { -960, 360, 0},
    { -1248, 456, 176},
    { -1352, 112, -160},
    { -1400, 560, -72},
    { -1168, 368, -152},
    { -920, 432, -184},
    { -560, 224, -72},
    { -448, 304, -112},
    { -424, 336, -56},
    // 45 seconds
    { -496, 336, 16},
    { -624, 536, 48},
    { -736, 456, 40},
    { -808, 512, 24},
    { -928, 592, -16},
    { -1048, 704, 96},
    { -1560, 608, -144},
    { -1160, 544, -72},
    { -1296, 616, 16},
    { -1200, 464, 120},
    { -1040, 360, 136},
    { -608, 256, 160},
    { -416, 288, 168},
    { -496, 160, 184},
    { -536, 136, 136},
    { -592, 184, 120},
    { -704, 200, 144},
    { -936, 264, 120},
    { -1192, 192, 168},
    { -1016, 328, 168},
    { -1336, 128, 64},
    { -1376, 280, -40},
    { -1344, 448, -56},
    { -1056, 280, -112},
    { -656, 360, -104},
    // 46 seconds
    { -368, 296, -96},
    { -280, 272, -112},
    { -352, 384, -16},
    { -528, 400, 64},
    { -720, 424, 56},
    { -888, 440, 80},
    { -1072, 720, 88},
    { -1256, 480, 96},
    { -1672, 800, -80},
    { -1136, 616, 64},
    { -904, 568, -16},
    { -936, 488, -40},
    { -992, 424, 72},
    { -704, 208, 176},
    { -536, 400, 136},
    { -472, 168, 112},
    { -480, 216, 168},
    { -552, 232, 144},
    { -640, 224, 128},
    { -832, 328, 128},
    { -1200, 248, 232},
    { -1248, 200, -16},
    { -1512, 464, 208},
    { -1136, 272, 8},
    { -816, 392, -96},
    // 47 seconds
    { -1024, 496, -184},
    { -808, 352, -24},
    { -560, 336, -112},
    { -392, 392, -80},
    { -352, 360, -24},
    { -392, 328, -16},
    { -480, 368, 48},
    { -608, 456, 16},
    { -760, 488, 80},
    { -1080, 504, -24},
    { -1328, 488, 8},
    { -1536, 696, 32},
    { -1168, 488, 16},
    { -1024, 600, -8},
    { -1128, 512, -48},
    { -864, 288, 144},
    { -544, 368, 104},
    { -440, 320, 72},
    { -384, 224, 112},
    { -360, 248, 96},
    { -456, 248, 112},
    { -584, 272, 120},
    { -856, 336, 128},
    { -1112, 344, 120},
    { -1152, 408, 80},
    // 48 seconds
    { -1328, 336, 72},
    { -1272, 400, 32},
    { -1008, 504, -8},
    { -1016, 432, -80},
    { -736, 368, -32},
    { -480, 328, -56},
    { -336, 368, -128},
    { -328, 320, -48},
    { -424, 344, 40},
    { -616, 456, 8},
    { -736, 360, 144},
    { -832, 568, 48},
    { -1104, 672, 24},
    { -1400, 648, 104},
    { -1432, 760, -32},
    { -1168, 552, 152},
    { -1168, 600, -56},
    { -1224, 416, 16},
    { -856, 328, 176},
    { -464, 192, 136},
    { -400, 72, 64},
    { -408, -8, 144},
    { -464, -8, 152},
    { -672, 320, 120},
    { -784, 112, 192},
    // 49 seconds
    { -1064, 256, 168},
    { -1240, 184, 128},
    { -1400, 336, 24},
    { -1376, 328, 72},
    { -1120, 360, -48},
    { -1152, 272, -8},
    { -968, 368, -48},
    { -600, 328, -88},
    { -384, 352, -128},
    { -280, 432, -104},
    { -360, 400, -64},
    { -576, 536, -56},
    { -712, 384, 0},
    { -896, 424, -40},
    { -1088, 512, -24},
    { -1216, 480, 64},
    { -1536, 704, -64},
    { -1296, 504, -40},
    { -1056, 440, 40},
    { -1192, 384, 32},
    { -984, 232, 136},
    { -760, 192, 56},
    { -528, 40, 152},
    { -400, 152, 160},
    { -384, 120, 120},
    // 50 seconds
    { -328, 136, 176},
    { -424, 232, 128},
    { -672, 456, 88},
    { -1016, 320, 80},
    { -1312, 552, -80},
    { -1520, 432, 64},
    { -1456, 584, 16},
    { -1040, 416, -56},
    { -976, 296, 24},
    { -640, 240, 16},
    { -440, 200, -40},
    { -328, 216, 8},
    { -400, 288, 56},
    { -504, 288, 72},
    { -712, 392, 96},
    { -864, 480, 160},
    { -904, 344, 40},
    { -1088, 608, -16},
    { -1192, 536, 48},
    { -1320, 648, -88},
    { -1088, 568, -96},
    { -1080, 576, -80},
    { -1144, 512, 0},
    { -984, 312, 168},
    { -608, 256, 200},
    // 51 seconds
    { -456, 144, 168},
    { -496, 176, 168},
    { -632, 112, 232},
    { -704, 184, 232},
    { -736, 96, 168},
    { -904, 144, 136},
    { -1104, 248, 160},
    { -1288, 184, 208},
    { -1368, 280, 40},
    { -1216, 272, 16},
    { -1216, 392, -96},
    { -984, 336, -88},
    { -552, 216, -8},
    { -408, 312, -144},
    { -336, 344, -72},
    { -464, 360, -64},
    { -608, 440, 16},
    { -784, 568, -32},
    { -856, 408, 64},
    { -1032, 616, -24},
    { -1080, 568, 40},
    { -1416, 608, -112},
    { -1328, 576, -48},
    { -1264, 488, -56},
    { -1320, 400, -16},
    // 52 seconds
    { -1032, 320, 144},
    { -696, 272, 168},
    { -464, 128, 48},
    { -400, 240, 72},
    { -472, 104, 184},
    { -520, 184, 176},
    { -576, 232, 160},
    { -648, 248, 224},
    { -976, 328, 128},
    { -1056, 312, 32},
    { -1304, 376, -32},
    { -1336, 280, -144},
    { -1304, 408, -112},
    { -1232, 208, -168},
    { -872, 160, -240},
    { -528, 56, -192},
    { -384, 208, -168},
    { -392, 256, -160},
    { -472, 272, -112},
    { -560, 272, -80},
    { -736, 376, -48},
    { -912, 384, 8},
    { -1192, 528, -32},
    { -1224, 336, -96},
    { -1456, 608, -384},
    // 53 seconds
    { -1296, 496, -224},
    { -928, 504, -232},
    { -1048, 440, -264},
    { -1032, 352, -144},
    { -792, 280, 152},
    { -568, 288, 192},
    { -672, 208, 208},
    { -464, 48, 256},
    { -464, 136, 160},
    { -488, 192, 176},
    { -576, 184, -16},
    { -928, 88, 280},
    { -1360, 208, -96},
    { -1480, 152, -24},
    { -1504, 376, -216},
    { -1120, 232, -248},
    { -1104, 56, -136},
    { -864, 160, -160},
    { -520, 88, -120},
    { -384, 120, -88},
    { -400, 312, -120},
    { -408, 128, 0},
    { -536, 224, -48},
    { -800, 352, -16},
    { -888, 344, -88},
    // 54 seconds
    { -1192, 552, -232},
    { -1216, 368, -176},
    { -1552, 608, -408},
    { -1224, 392, -200},
    { -1096, 416, -144},
    { -1056, 512, -128},
    { -760, 320, 96},
    { -504, 224, 128},
    { -488, 240, 104},
    { -520, 352, 128},
    { -520, 120, 128},
    { -640, 184, 96},
    { -744, 296, 64},
    { -944, 184, 16},
    { -1152, 168, -144},
    { -1336, 96, -16},
    { -1440, 288, -144},
    { -1184, 168, -120},
    { -1128, 112, -80},
    { -864, 176, -200},
    { -504, 104, -144},
    { -384, 152, -184},
    { -448, 200, -128},
    { -560, 280, -128},
    { -680, 376, -128},
    // 55 seconds
    { -808, 360, -56},
    { -968, 528, -192},
    { -1152, 480, -192},
    { -1312, 488, -160},
    { -1472, 648, -352},
    { -1128, 464, -232},
    { -1096, 504, -264},
    { -1040, 464, -208},
    { -816, 304, -24},
    { -560, 256, 16},
    { -504, 248, 24},
    { -528, 216, 40},
    { -568, 96, 88},
    { -648, 296, 80},
    { -688, 16, 152},
    { -1064, 256, -80},
    { -1168, 168, 24},
    { -1392, 288, -168},
    { -1392, 96, -32},
    { -1024, 200, -152},
    { -1072, 208, -160},
    { -864, 296, -176},
    { -544, 184, -168},
    { -392, 216, -152},
    { -384, 256, -136},
    // 56 seconds
    { -496, 344, -136},
    { -648, 432, -104},
    { -904, 544, -240},
    { -912, 560, -160},
    { -1176, 672, -368},
    { -1400, 496, -472},
    { -1480, 640, -304},
    { -1232, 472, -296},
    { -960, 424, -136},
    { -1088, 376, -136},
    { -984, 288, 112},
    { -640, 280, 112},
    { -512, 296, 48},
    { -488, 256, 88},
    { -504, 152, 96},
    { -536, 144, 80},
    { -600, 144, 96},
    { -792, 312, 40},
    { -1016, 168, 104},
    { -1200, 192, -192},
    { -1392, 200, -80},
    { -1408, 344, -232},
    { -944, 232, -224},
    { -904, 224, -192},
    { -744, 280, -208},
    // 57 seconds
    { -560, 168, -160},
    { -488, 168, -120},
    { -480, 200, -112},
    { -680, 360, -88},
    { -760, 248, -72},
    { -840, 488, -96},
    { -896, 352, -112},
    { -1216, 448, -264},
    { -1360, 432, -248},
    { -1336, 536, -400},
    { -1120, 320, -232},
    { -1096, 360, -200},
    { -1120, 200, -56},
    { -744, 96, -8},
    { -528, 160, 40},
    { -512, 120, 112},
    { -560, 64, 152},
    { -544, 24, 120},
    { -728, 240, 72},
    { -976, 256, 56},
    { -1176, -32, 216},
    { -1176, 16, 0},
    { -1488, 72, -24},
    { -1192, 56, -176},
    { -1016, 128, -128},
    // 58 seconds
    { -1016, 64, -192},
    { -664, -32, -56},
    { -440, 168, -192},
    { -416, 184, -168},
    { -504, 56, -96},
    { -616, 248, -144},
    { -816, 368, -144},
    { -936, 392, -176},
    { -1048, 496, -192},
    { -1056, 360, -168},
    { -1640, 576, -328},
    { -1328, 408, -248},
    { -1304, 376, -152},
    { -1264, 360, -104},
    { -976, 120, 112},
    { -616, 144, 64},
    { -488, 120, 32},
    { -544, 8, 144},
    { -432, 24, 24},
    { -632, -128, 64},
    { -984, 224, 176},
    { -1080, -80, 24},
    { -1224, -40, 24},
    { -1424, -8, -72},
    { -1528, 32, -72},
    // 59 seconds
    { -1200, 256, -168},
    { -1112, 72, -104},
    { -912, 184, -160},
    { -528, 192, -160},
    { -376, 208, -192},
    { -440, 320, -216},
    { -480, 296, -120},
    { -696, 312, -16},
    { -904, 528, -128},
    { -1048, 552, -8},
    { -1208, 344, -128},
    { -1304, 464, -216},
    { -1336, 472, -288},
    { -1176, 256, -192},
    { -1096, 344, -104},
    { -1112, 312, -56},
    { -800, 216, 32},
    { -544, 176, -16},
    { -544, 208, 40},
    { -504, 120, 64},
    { -576, 64, 104},
    { -712, 40, 120},
    { -1056, 376, 72},
    { -1032, -288, 80},
    { -1144, 48, -136},
    // 60 seconds
    // elapsed: 1 minutes
    { -1584, -56, 8},
    { -1424, 192, -160},
    { -1104, -8, -80},
    { -1160, 152, -88},
    { -824, 120, -48},
    { -568, 248, -96},
    { -464, 312, -112},
    { -520, 280, -40},
    { -560, 376, -32},
    { -576, 368, 0},
    { -800, 544, -96},
    { -960, 304, -288},
    { -1224, 328, -88},
    { -1344, 408, -184},
    { -1392, 392, -192},
    { -1168, 272, -96},
    { -1048, 336, -112},
    { -1120, 240, -16},
    { -832, 136, 88},
    { -560, 168, 64},
    { -632, 136, 104},
    { -568, 144, 128},
    { -560, 224, 128},
    { -576, 208, 64},
    { -800, 232, 16},
    // 61 seconds
    { -1136, 208, 24},
    { -1248, 120, 56},
    { -1432, 184, -16},
    { -1320, 200, -80},
    { -1000, 184, -128},
    { -1056, 144, -32},
    { -904, 256, -88},
    { -576, 248, -80},
    { -400, 272, -104},
    { -424, 328, -104},
    { -536, 376, -40},
    { -616, 304, -80},
    { -776, 440, -40},
    { -928, 528, 0},
    { -1144, 504, -152},
    { -1176, 416, -40},
    { -1576, 776, -200},
    { -1112, 280, 32},
    { -1184, 488, -24},
    { -1144, 376, 64},
    { -744, 256, 96},
    { -504, 296, 40},
    { -408, 160, 40},
    { -408, 104, 72},
    { -456, 144, 88},
    // 62 seconds
    { -568, 304, 48},
    { -904, 304, 136},
    { -1208, 56, 80},
    { -1064, 72, 40},
    { -1536, 88, -48},
    { -1376, 232, -24},
    { -1216, -16, -72},
    { -1192, 184, -80},
    { -792, 144, -56},
    { -488, 184, -136},
    { -416, 264, -104},
    { -416, 312, -96},
    { -512, 352, -112},
    { -768, 368, -32},
    { -880, 352, -128},
    { -1048, 416, -144},
    { -1128, 336, -88},
    { -1464, 552, -320},
    { -1216, 344, -104},
    { -1184, 496, -176},
    { -1176, 296, -72},
    { -1104, 296, -24},
    { -728, 280, -8},
    { -504, 272, 56},
    { -488, 264, 72},
    // 63 seconds
    { -424, 152, 216},
    { -584, 368, 208},
    { -688, 232, 136},
    { -864, 144, 104},
    { -1248, 136, -64},
    { -1224, 32, -152},
    { -1352, 136, -200},
    { -1400, 72, -168},
    { -1208, 168, -216},
    { -1008, 120, -184},
    { -760, 224, -216},
    { -408, 120, -120},
    { -280, 152, -72},
    { -304, 232, 40},
    { -408, 240, 56},
    { -624, 488, 144},
    { -792, 816, -136},
    { -976, 504, -32},
    { -1192, 472, -48},
    { -1792, 696, -352},
    { -1200, 568, -56},
    { -1112, 728, -112},
    { -1128, 576, 8},
    { -960, 352, 120},
    { -576, 232, 8},
    // 64 seconds
    { -480, 288, 16},
    { -344, 128, 128},
    { -352, 192, 144},
    { -584, 424, 232},
    { -728, 280, 144},
    { -808, 184, 112},
    { -1360, 440, 48},
    { -1392, 344, -120},
    { -1424, 248, -224},
    { -1224, 304, -168},
    { -1136, 312, -136},
    { -856, 224, -168},
    { -584, 104, -80},
    { -336, 136, -8},
    { -344, 200, 40},
    { -464, 288, 24},
    { -488, 168, 152},
    { -720, 424, -48},
    { -856, 408, -64},
    { -896, 416, 8},
    { -1080, 568, -208},
    { -1200, 496, -64},
    { -1424, 696, -192},
    { -1240, 640, -96},
    { -1112, 608, -80},
    // 65 seconds
    { -1272, 472, -128},
    { -952, 344, 80},
    { -544, 264, 24},
    { -512, 360, -32},
    { -544, 216, 72},
    { -536, 176, 80},
    { -608, 136, 56},
    { -824, 152, 248},
    { -1144, 272, -40},
    { -1168, -272, 224},
    { -1728, 40, 8},
    { -1536, 176, -72},
    { -1160, 120, -168},
    { -960, 248, -192},
    { -640, 208, -88},
    { -432, 272, -80},
    { -400, 272, -40},
    { -544, 368, -16},
    { -688, 440, 0},
    { -856, 512, -24},
    { -888, 504, 0},
    { -1088, 752, -48},
    { -1168, 624, -32},
    { -1512, 816, -280},
    { -1192, 608, -184},
    // 66 seconds
    { -1288, 568, -104},
    { -1424, 352, 64},
    { -1200, 248, 160},
    { -832, 440, 128},
    { -640, 184, 192},
    { -496, 312, 136},
    { -464, 56, 336},
    { -392, 96, 96},
    { -560, 64, 256},
    { -920, 288, 104},
    { -944, -208, 104},
    { -1328, -16, 104},
    { -1512, 176, -104},
    { -1584, 400, -32},
    { -1256, 152, 104},
    { -1224, 528, -80},
    { -856, 400, 0},
    { -544, 416, -48},
    { -408, 368, -24},
    { -424, 408, 72},
    { -576, 456, 64},
    { -672, 480, 88},
    { -848, 568, 248},
    { -1040, 712, 56},
    { -1224, 664, 80},
    // 67 seconds
    { -1344, 776, 64},
    { -1232, 760, 56},
    { -1072, 576, 104},
    { -1224, 568, 152},
    { -1088, 368, 216},
    { -800, 328, 152},
    { -760, 328, 128},
    { -776, 280, 152},
    { -672, 120, 224},
    { -520, 96, 152},
    { -464, 104, 168},
    { -552, 192, 240},
    { -872, 112, 232},
    { -1264, 224, 88},
    { -1824, 376, 264},
    { -1256, 336, 24},
    { -1192, 392, -16},
    { -1056, 416, -16},
    { -688, 336, 24},
    { -512, 336, 24},
    { -496, 440, 16},
    { -560, 424, 96},
    { -640, 512, 96},
    { -792, 712, 168},
    { -728, 624, 56},
    // 68 seconds
    { -1088, 816, -104},
    { -1224, 800, 56},
    { -1496, 952, -32},
    { -1168, 952, 56},
    { -1360, 712, 224},
    { -1568, 720, 336},
    { -1216, 256, 616},
    { -880, 424, 440},
    { -688, 224, 360},
    { -568, 392, 304},
    { -392, 64, 248},
    { -272, -128, 80},
    { -264, 40, 40},
    { -392, 80, 168},
    { -672, -24, 128},
    { -1256, 392, 32},
    { -2040, 512, 72},
    { -1896, 1144, 96},
    { -1048, 976, 488},
    { -1240, 1160, 400},
    { -984, 752, 512},
    { -536, 632, 416},
    { -200, 472, 216},
    { 48, 248, 248},
    { 216, 280, 120},
    // 69 seconds
    { 240, 160, 32},
    { 96, 240, 168},
    { -144, 456, 528},
    { -864, 976, 576},
    { -1424, 1552, 976},
    { -1472, 1400, 1288},
    { -1336, 1272, 936},
    { -1112, 824, 912},
    { -1096, 472, 864},
    { -800, 328, 680},
    { -488, 120, 560},
    { -328, -32, 272},
    { -176, 168, 200},
    { -112, 64, 104},
    { -40, 152, 48},
    { 0, 128, 32},
    { -336, 360, 744},
    { -952, 1768, 1360},
    { -1424, 1224, 1728},
    { -648, 1160, 992},
    { -456, 616, 704},
    { -376, 520, 368},
    { -272, 456, 280},
    { -80, 200, 200},
    { -72, 200, 56},
    // 70 seconds
    { -72, 104, 56},
    { -144, 160, -40},
    { -288, 48, 168},
    { -680, 408, 320},
    { -1400, 704, 600},
    { -1912, 1304, 240},
    { -2224, 1304, 744},
    { -1448, 912, 544},
    { -768, 1000, 288},
    { -1024, 824, 184},
    { -840, 408, 232},
    { -600, 360, 256},
    { -512, 392, 264},
    { -432, 224, 248},
    { -424, 152, 224},
    { -472, 136, 192},
    { -480, 48, 200},
    { -784, 160, 112},
    { -1336, 448, 272},
    { -1432, 200, 232},
    { -1552, 320, -56},
    { -1696, 528, 88},
    { -992, 120, 16},
    { -976, 456, -32},
    { -704, 296, 0},
    // 71 seconds
    { -416, 304, 64},
    { -352, 344, 104},
    { -448, 400, 104},
    { -480, 424, 152},
    { -576, 488, 184},
    { -744, 520, 240},
    { -896, 696, 280},
    { -1080, 800, 272},
    { -1192, 848, 248},
    { -1160, 832, 272},
    { -1304, 592, 192},
    { -1296, 544, 320},
    { -1280, 344, 352},
    { -752, 208, 296},
    { -480, 136, 240},
    { -416, 360, 96},
    { -336, 128, 104},
    { -424, 200, 168},
    { -576, 264, 144},
    { -696, 200, 232},
    { -1232, 584, 240},
    { -1288, 248, 424},
    { -1424, 32, 104},
    { -1328, 352, 152},
    { -1328, 520, 40},
    // 72 seconds
    { -1200, 376, 64},
    { -744, 464, -104},
    { -408, 440, -8},
    { -272, 312, -40},
    { -312, 400, 24},
    { -496, 320, 32},
    { -792, 504, 152},
    { -688, 560, 232},
    { -896, 704, 248},
    { -968, 608, 280},
    { -1200, 912, 240},
    { -1472, 648, 120},
    { -1096, 576, 272},
    { -1000, 600, 168},
    { -1040, 480, 72},
    { -864, 376, 248},
    { -640, 240, 192},
    { -464, 216, 112},
    { -520, 240, 248},
    { -472, 112, 176},
    { -632, 136, 152},
    { -896, 384, 160},
    { -1248, 120, 336},
    { -1128, 96, 80},
    { -1328, 216, 128},
    // 73 seconds
    { -1336, 272, 128},
    { -1288, 360, -8},
    { -1096, 320, -8},
    { -784, 464, -16},
    { -432, 296, 32},
    { -344, 376, -32},
    { -368, 344, 80},
    { -536, 424, 128},
    { -664, 488, 128},
    { -832, 600, 152},
    { -1008, 808, 32},
    { -1048, 472, 104},
    { -1528, 776, 80},
    { -1360, 728, 112},
    { -1024, 512, 200},
    { -1048, 560, 120},
    { -1008, 360, 200},
    { -728, 272, 160},
    { -480, 184, 48},
    { -448, 128, -64},
    { -600, 40, 64},
    { -632, -64, 136},
    { -840, 152, 160},
    { -888, 200, 88},
    { -1168, 216, 176},
    // 74 seconds
    { -1088, 136, -32},
    { -1448, 88, 48},
    { -1544, 280, 48},
    { -1152, 256, 16},
    { -992, 312, -48},
    { -736, 320, -48},
    { -432, 240, -8},
    { -352, 368, 8},
    { -384, 304, 8},
    { -488, 448, 96},
    { -696, 472, 120},
    { -848, 488, 104},
    { -960, 704, 112},
    { -1088, 592, 280},
    { -1528, 672, 8},
    { -1432, 640, -80},
    { -1096, 544, 104},
    { -1032, 584, 8},
    { -920, 328, 88},
    { -656, 224, 144},
    { -464, 184, 160},
    { -536, 120, 216},
    { -504, 112, 216},
    { -536, 208, 168},
    { -616, 216, 112},
    // 75 seconds
    { -952, 352, 200},
    { -1280, 248, 136},
    { -1064, 184, 24},
    { -1464, 384, 40},
    { -1376, 264, 16},
    { -1048, 304, -24},
    { -1000, 376, -128},
    { -664, 272, -56},
    { -384, 304, -88},
    { -328, 264, -32},
    { -352, 272, 56},
    { -504, 368, 72},
    { -720, 440, 16},
    { -824, 440, 64},
    { -976, 704, 80},
    { -1184, 632, 80},
    { -1384, 616, 8},
    { -1352, 656, -56},
    { -1168, 336, 24},
    { -1112, 344, -88},
    { -960, 288, 0},
    { -600, 280, 64},
    { -376, 320, 16},
    { -384, 304, 72},
    { -416, 256, 152},
    // 76 seconds
    { -552, 216, 160},
    { -728, 280, 144},
    { -960, 288, 160},
    { -1248, 448, 136},
    { -1120, 168, 16},
    { -1232, 136, 80},
    { -1320, 200, 32},
    { -1152, 144, 24},
    { -1088, 232, -72},
    { -728, 224, -168},
    { -400, 216, -168},
    { -312, 224, -184},
    { -384, 192, -96},
    { -544, 272, -136},
    { -808, 392, -24},
    { -904, 432, -8},
    { -1064, 488, 40},
    { -1112, 584, 136},
    { -1296, 480, 48},
    { -1088, 688, 80},
    { -1224, 704, 32},
    { -1088, 408, 136},
    { -912, 384, 152},
    { -592, 384, 80},
    { -384, 280, 104},
    // 77 seconds
    { -408, 296, 128},
    { -528, 256, 144},
    { -648, 264, 136},
    { -720, 224, 96},
    { -1152, 600, 376},
    { -1200, -104, 248},
    { -1080, 192, 0},
    { -1248, 184, -8},
    { -1280, 176, -88},
    { -1208, 304, -104},
    { -1024, 280, -136},
    { -656, 264, -168},
    { -392, 224, -80},
    { -288, 336, -128},
    { -344, 232, 8},
    { -512, 376, 72},
    { -680, 520, 16},
    { -816, 680, 16},
    { -1024, 832, 72},
    { -1032, 608, 16},
    { -1544, 872, 8},
    { -1232, 648, 40},
    { -1224, 440, -16},
    { -1192, 344, 48},
    { -1040, 200, 144},
    // 78 seconds
    { -696, 160, 64},
    { -472, 224, 96},
    { -464, 200, 104},
    { -416, 64, 64},
    { -472, 56, 96},
    { -576, 144, 96},
    { -992, 248, 72},
    { -1344, 224, 224},
    { -1160, 24, 24},
    { -1512, 112, -24},
    { -1408, 312, -24},
    { -1176, 200, -16},
    { -1104, 352, 8},
    { -736, 320, 0},
    { -408, 368, 0},
    { -296, 336, 8},
    { -224, 344, 40},
    { -368, 520, 16},
    { -576, 488, 24},
    { -944, 464, 72},
    { -1160, 456, 200},
    { -1264, 512, 240},
    { -1344, 744, -48},
    { -1184, 720, 24},
    { -1184, 560, 40},
    // 79 seconds
    { -1080, 416, 128},
    { -928, 320, 176},
    { -600, 320, 160},
    { -392, 288, 80},
    { -384, 224, 136},
    { -472, 272, 208},
    { -568, 184, 256},
    { -688, 232, 200},
    { -976, 328, 160},
    { -1280, 280, 144},
    { -1296, 256, 56},
    { -1440, 304, -104},
    { -1312, 192, -184},
    { -1128, 208, -24},
    { -912, 232, -120},
    { -544, 152, -112},
    { -384, 208, -24},
    { -360, 216, 64},
    { -432, 232, 88},
    { -504, 264, 168},
    { -672, 384, 160},
    { -760, 440, 152},
    { -1008, 584, 56},
    { -1176, 624, 136},
    { -1576, 744, -56},
    // 80 seconds
    { -1280, 792, -64},
    { -1072, 648, 40},
    { -1072, 552, 0},
    { -1000, 448, 24},
    { -608, 376, 128},
    { -432, 352, 152},
    { -448, 272, 168},
    { -504, 224, 160},
    { -536, 240, 216},
    { -680, 248, 208},
    { -744, 240, 200},
    { -1000, 288, 160},
    { -1168, 368, 48},
    { -1288, 168, 72},
    { -1440, 352, 0},
    { -1104, 296, -56},
    { -1016, 200, -56},
    { -784, 168, -112},
    { -536, 168, -104},
    { -384, 208, -56},
    { -384, 280, -8},
    { -512, 304, 48},
    { -664, 352, 88},
    { -856, 392, 32},
    { -896, 472, 120},
    // 81 seconds
    { -1096, 656, -8},
    { -1216, 424, 144},
    { -1528, 760, -64},
    { -1136, 472, 40},
    { -992, 648, 8},
    { -1040, 512, 88},
    { -888, 344, 264},
    { -592, 336, 136},
    { -408, 280, 136},
    { -448, 240, 152},
    { -512, 216, 184},
    { -664, 248, 152},
    { -800, 248, 168},
    { -1128, 416, 112},
    { -1352, 24, 24},
    { -1392, 112, 0},
    { -1328, 128, -24},
    { -1144, 136, -56},
    { -1016, 176, -80},
    { -896, 248, -120},
    { -608, 176, -64},
    { -368, 192, -80},
    { -352, 312, -40},
    { -488, 272, 56},
    { -560, 328, 128},
    // 82 seconds
    { -680, 392, 136},
    { -896, 584, 24},
    { -1048, 520, 136},
    { -1136, 504, 56},
    { -1584, 696, -24},
    { -1256, 680, 112},
    { -920, 608, 0},
    { -920, 592, 0},
    { -920, 384, 144},
    { -600, 360, 192},
    { -408, 296, 152},
    { -384, 216, 192},
    { -432, 328, 208},
    { -568, 256, 232},
    { -696, 248, 264},
    { -800, 408, 144},
    { -1408, 80, 232},
    { -1208, 240, 32},
    { -1496, 272, 56},
    { -1296, 224, -96},
    { -960, 176, -168},
    { -904, 272, -136},
    { -608, 200, -72},
    { -400, 264, -80},
    { -328, 288, 24},
    // 83 seconds
    { -424, 360, 72},
    { -584, 424, 120},
    { -736, 488, 216},
    { -792, 528, 208},
    { -976, 760, 112},
    { -1048, 488, 8},
    { -1424, 800, 96},
    { -1216, 736, 96},
    { -1032, 528, 216},
    { -1040, 520, 128},
    { -936, 472, 192},
    { -608, 368, 192},
    { -424, 216, 144},
    { -408, 264, 144},
    { -496, 264, 248},
    { -536, 192, 168},
    { -672, 264, 184},
    { -936, 392, 168},
    { -1200, 248, 256},
    { -1160, 400, 48},
    { -1264, 264, 112},
    { -1240, 520, 48},
    { -1048, 144, -112},
    { -1016, 336, -88},
    { -720, 328, -128},
    // 84 seconds
    { -408, 56, -144},
    { -336, 184, -56},
    { -400, 280, 104},
    { -528, 296, 96},
    { -656, 360, 152},
    { -808, 568, 160},
    { -888, 464, 104},
    { -1088, 600, 56},
    { -1112, 568, 96},
    { -1352, 744, -16},
    { -1200, 616, -16},
    { -1104, 616, -40},
    { -1192, 544, 40},
    { -888, 392, 152},
    { -568, 480, 128},
    { -360, 264, 152},
    { -328, 264, 192},
    { -368, 248, 184},
    { -576, 200, 200},
    { -712, 304, 248},
    { -808, 296, 248},
    { -1128, 376, 152},
    { -1152, 240, 72},
    { -1288, 272, 72},
    { -1368, 248, -80},
    // 85 seconds
    { -1056, 336, -144},
    { -1016, 248, -88},
    { -816, 344, -128},
    { -496, 128, -48},
    { -392, 232, -72},
    { -368, 272, 8},
    { -504, 320, 48},
    { -648, 360, 112},
    { -808, 424, 88},
    { -800, 384, 136},
    { -928, 568, 48},
    { -1080, 624, 8},
    { -1200, 656, 0},
    { -1272, 640, -72},
    { -1240, 664, -8},
    { -1240, 616, 96},
    { -1128, 360, 40},
    { -784, 296, 104},
    { -464, 256, 64},
    { -400, 280, 48},
    { -392, 208, 88},
    { -408, 120, 128},
    { -560, 296, 152},
    { -680, 360, 144},
    { -968, 280, 80},
    // 86 seconds
    { -1144, 296, 0},
    { -1176, 296, 192},
    { -1312, 272, -136},
    { -1328, 240, -168},
    { -1112, 360, -136},
    { -904, 344, -280},
    { -520, 144, -112},
    { -368, 248, -120},
    { -352, 328, -72},
    { -400, 344, 40},
    { -488, 296, 32},
    { -728, 368, 64},
    { -784, 456, 120},
    { -976, 600, -16},
    { -1088, 576, 64},
    { -1312, 696, 24},
    { -1272, 768, -152},
    { -1256, 656, 24},
    { -1272, 456, 8},
    { -1088, 488, 128},
    { -624, 352, 64},
    { -400, 376, 96},
    { -376, 280, 192},
    { -424, 336, 176},
    { -456, 288, 272},
    // 87 seconds
    { -592, 200, 296},
    { -768, 496, 280},
    { -1000, 528, 464},
    { -936, 448, 344},
    { -976, 568, 400},
    { -1024, 552, 272},
    { -1032, 728, 248},
    { -1008, 912, 408},
    { -720, 448, 256},
    { -464, 592, 200},
    { -344, 328, 248},
    { -256, 256, 0},
    { -296, 376, 128},
    { -360, 216, 200},
    { -480, 328, 200},
    { -560, 400, 224},
    { -832, 544, 288},
    { -1112, 656, 312},
    { -1256, 616, 272},
    { -1680, 624, 280},
    { -1160, 776, 304},
    { -1064, 744, 56},
    { -968, 840, 192},
    { -792, 552, 208},
    { -472, 576, 104},
    // 88 seconds
    { -416, 416, 96},
    { -408, 368, 136},
    { -440, 328, 200},
    { -552, 272, 192},
    { -640, 256, 192},
    { -800, 384, 248},
    { -1256, 488, 120},
    { -1152, 248, 152},
    { -1408, -160, -72},
    { -1264, 272, -120},
    { -1304, 16, -24},
    { -1064, 408, -120},
    { -760, 104, -136},
    { -392, 160, -120},
    { -320, 208, -96},
    { -320, 184, 8},
    { -496, 320, 112},
    { -648, 368, 120},
    { -768, 456, 104},
    { -984, 640, 184},
    { -1104, 568, -72},
    { -1056, 336, 72},
    { -1368, 984, -176},
    { -888, 576, -144},
    { -1256, 584, -32},
    // 89 seconds
    { -1128, 512, 136},
    { -912, 360, 136},
    { -592, 304, 104},
    { -488, 320, 64},
    { -512, 200, 112},
    { -608, 288, 168},
    { -616, 152, 120},
    { -736, 240, 88},
    { -1008, 416, 112},
    { -1088, -128, 80},
    { -1360, 248, -16},
    { -1360, 120, 0},
    { -1232, 456, -40},
    { -1008, 264, -56},
    { -936, 208, -48},
    { -688, 296, -96},
    { -472, 272, -96},
    { -416, 312, -32},
    { -472, 384, -8},
    { -552, 392, 0},
    { -720, 448, 16},
    { -824, 520, 24},
    { -920, 576, -96},
    { -1144, 624, -64},
    { -1104, 280, -80},
    // 90 seconds
    { -1304, 624, -176},
    { -1040, 496, -64},
    { -1032, 496, -64},
    { -1200, 336, 16},
    { -944, 240, 56},
    { -632, 256, 96},
    { -504, 272, 64},
    { -536, 160, 144},
    { -544, 232, 96},
    { -640, 240, 120},
    { -712, 200, 112},
    { -840, 256, 16},
    { -1184, 400, -112},
    { -1296, 144, 144},
    { -1320, 368, -200},
    { -888, 232, -176},
    { -1104, 256, -208},
    { -928, 224, -224},
    { -720, 160, -120},
    { -520, 200, -104},
    { -520, 160, -48},
    { -592, 336, 16},
    { -712, 344, -16},
    { -784, 384, -32},
    { -768, 504, -40},
    // 91 seconds
    { -760, 600, -40},
    { -1040, 384, -80},
    { -1032, 280, -64},
    { -1608, 688, -72},
    { -1040, 216, -104},
    { -912, 504, -48},
    { -1104, 424, -88},
    { -816, 320, 8},
    { -680, 352, -16},
    { -584, 416, 88},
    { -584, 304, 88},
    { -560, 272, 88},
    { -520, 344, 144},
    { -608, 272, 88},
    { -784, 296, -56},
    { -1080, 504, 144},
    { -1232, -40, 40},
    { -1368, 72, 24},
    { -1616, 264, 104},
    { -1048, 240, -96},
    { -1120, 200, -40},
    { -936, 176, -16},
    { -592, 184, -128},
    { -376, 320, -128},
    { -392, 328, -88},
    // 92 seconds
    { -488, 400, -80},
    { -640, 440, 32},
    { -736, 472, -64},
    { -768, 400, -48},
    { -1008, 352, -224},
    { -1232, 376, -200},
    { -1384, 208, -136},
    { -1336, 440, -272},
    { -1256, 200, 48},
    { -1264, 288, 96},
    { -1112, 288, 88},
    { -664, 256, 104},
    { -456, 240, 88},
    { -488, 256, 120},
    { -528, 240, 144},
    { -608, 152, 176},
    { -776, 352, 256},
    { -832, 168, 16},
    { -1064, 40, 136},
    { -1168, 208, 104},
    { -1328, 256, 16},
    { -1160, 264, -96},
    { -1096, 368, -152},
    { -976, 392, -136},
    { -856, 304, -120},
    // 93 seconds
    { -552, 232, -176},
    { -352, 288, -192},
    { -384, 384, -168},
    { -552, 304, -128},
    { -664, 344, -72},
    { -896, 400, -128},
    { -912, 328, -80},
    { -1128, 448, -136},
    { -1240, 512, -72},
    { -1424, 472, -80},
    { -1240, 584, -216},
    { -1024, 344, 168},
    { -1000, 624, -64},
    { -1024, 320, 80},
    { -656, 184, 240},
    { -640, 488, 0},
    { -560, 160, 128},
    { -496, 88, 176},
    { -536, 152, 88},
    { -608, 128, 144},
    { -792, 200, 128},
    { -1064, 304, 72},
    { -1208, 216, -160},
    { -1472, -80, 152},
    { -1496, 152, -72},
    // 94 seconds
    { -1264, 336, -232},
    { -1088, 56, -216},
    { -792, 48, -144},
    { -488, 144, -152},
    { -352, 192, -128},
    { -400, 280, -144},
    { -528, 224, 16},
    { -768, 328, 16},
    { -880, 424, 24},
    { -888, 504, -16},
    { -1112, 496, -80},
    { -1256, 440, -8},
    { -1560, 624, -168},
    { -1216, 544, -192},
    { -984, 384, -104},
    { -1112, 408, -136},
    { -1144, 312, -48},
    { -840, 280, 32},
    { -592, 224, 48},
    { -512, 248, 64},
    { -512, 232, 120},
    { -528, 120, 128},
    { -600, 128, 144},
    { -696, 176, 128},
    { -1080, 352, 0},
    // 95 seconds
    { -1240, 40, 120},
    { -1384, 56, 80},
    { -1424, 240, -48},
    { -1176, 368, -160},
    { -1160, 104, -64},
    { -840, 224, -152},
    { -480, 176, -136},
    { -408, 264, -16},
    { -456, 464, -32},
    { -536, 464, -88},
    { -736, 248, 40},
    { -896, 376, 8},
    { -944, 616, -272},
    { -1120, 448, 16},
    { -1376, 496, -344},
    { -1336, 528, -320},
    { -1272, 432, -208},
    { -1256, 424, -144},
    { -1288, 392, -40},
    { -1056, 280, 96},
    { -680, 264, 184},
    { -656, 224, 216},
    { -704, 224, 216},
    { -608, 152, 256},
    { -520, 112, 240},
    // 96 seconds
    { -592, 16, 200},
    { -728, 344, 296},
    { -1048, 792, 448},
    { -808, 1016, 32},
    { -1088, 608, 480},
    { -696, 952, 336},
    { -656, 784, 440},
    { -584, 592, 320},
    { -464, 512, 240},
    { -312, 384, 240},
    { -264, 432, 208},
    { -272, 288, 168},
    { -336, 352, 200},
    { -496, 432, 264},
    { -712, 464, 160},
    { -1024, 648, 40},
    { -1592, 656, 120},
    { -1448, 456, 312},
    { -1360, 1200, 104},
    { -1032, 800, 104},
    { -992, 664, 120},
    { -1000, 488, 48},
    { -768, 472, 120},
    { -512, 408, 152},
    { -528, 376, 200},
    // 97 seconds
    { -536, 248, 272},
    { -584, 224, 240},
    { -592, 248, 216},
    { -744, 312, 296},
    { -944, 272, 88},
    { -1256, 104, 168},
    { -1464, 264, -56},
    { -1336, 240, -16},
    { -1048, 264, -120},
    { -1088, 104, -136},
    { -904, 200, -80},
    { -552, 120, -24},
    { -432, 248, 0},
    { -496, 312, 24},
    { -536, 216, 160},
    { -680, 376, 104},
    { -832, 576, 80},
    { -888, 592, 112},
    { -1080, 680, 104},
    { -1048, 472, -8},
    { -1480, 704, -64},
    { -1184, 728, -120},
    { -1032, 440, -48},
    { -1072, 584, -8},
    { -1112, 416, 112},
    // 98 seconds
    { -912, 360, 104},
    { -664, 296, 96},
    { -584, 256, 120},
    { -568, 256, 200},
    { -568, 176, 248},
    { -608, 256, 160},
    { -848, 424, 176},
    { -976, 232, 200},
    { -952, 432, 96},
    { -1112, 248, 40},
    { -1248, 296, -16},
    { -1128, 248, -48},
    { -1128, 264, -48},
    { -912, 376, -120},
    { -632, 312, -112},
    { -416, 248, -8},
    { -464, 320, 40},
    { -624, 400, -56},
    { -664, 376, -32},
    { -840, 432, -48},
    { -944, 672, -120},
    { -936, 512, -56},
    { -1248, 584, -32},
    { -1400, 648, -32},
    { -1176, 640, -104},
    // 99 seconds
    { -1088, 512, -112},
    { -1064, 488, -24},
    { -1056, 400, 24},
    { -808, 280, 40},
    { -608, 256, 56},
    { -536, 240, 80},
    { -560, 328, 112},
    { -664, 272, 112},
    { -648, 80, 176},
    { -760, 224, 112},
    { -1128, 256, 112},
    { -1352, 264, -184},
    { -1288, -8, 24},
    { -1440, 160, -208},
    { -1008, 88, -176},
    { -1112, 96, -288},
    { -800, 104, -112},
    { -536, 128, -144},
    { -440, 272, -112},
    { -456, 208, -8},
    { -592, 384, 16},
    { -768, 440, 8},
    { -824, 496, -24},
    { -920, 504, 64},
    { -1168, 744, -216},
    // 100 seconds
    { -1344, 552, -184},
    { -1488, 800, -240},
    { -1120, 344, -128},
    { -1032, 432, -320},
    { -1224, 600, -56},
    { -984, 312, 112},
    { -696, 288, 64},
    { -592, 240, 136},
    { -584, 120, 192},
    { -568, 192, 104},
    { -624, 192, 168},
    { -648, 216, 208},
    { -816, 336, 208},
    { -1168, 456, -136},
    { -1224, 8, 96},
    { -1608, 24, 24},
    { -1200, 288, -232},
    { -1040, 144, -176},
    { -1008, 184, -152},
    { -736, 176, -128},
    { -544, 240, -152},
    { -528, 232, -128},
    { -608, 400, 16},
    { -664, 536, 32},
    { -688, 384, -32},
    // 101 seconds
    { -1048, 456, 40},
    { -912, 456, -432},
    { -1120, 360, -312},
    { -1336, 408, -72},
    { -1312, 448, -216},
    { -912, 416, -240},
    { -936, 504, -408},
    { -1080, 280, -24},
    { -1032, 392, 16},
    { -744, 272, -352},
    { -656, 168, 104},
    { -648, 600, 32},
    { -608, 512, 192},
    { -616, 432, 240},
    { -600, 344, 216},
    { -736, 272, 152},
    { -1048, 600, 192},
    { -1088, 336, -48},
    { -1048, 112, 64},
    { -1432, 376, -320},
    { -1472, -48, -120},
    { -1064, 152, -152},
    { -960, 168, -240},
    { -784, 40, -152},
    { -544, 8, -120},
    // 102 seconds
    { -512, 152, -112},
    { -640, 368, -88},
    { -712, 400, -32},
    { -736, 312, -24},
    { -816, 416, -8},
    { -736, 464, -80},
    { -752, 432, -80},
    { -1016, 568, 0},
    { -1216, 544, -56},
    { -1528, 288, -280},
    { -960, 488, -40},
    { -1184, 664, -480},
    { -1104, 368, -240},
    { -704, 280, -184},
    { -528, 416, -344},
    { -648, 336, -152},
    { -640, 288, -80},
    { -624, 328, -152},
    { -616, 392, -112},
    { -632, 288, -80},
    { -552, 328, -80},
    { -568, 376, -120},
    { -552, 328, -56},
    { -544, 296, -136},
    { -568, 408, 16},
    // 103 seconds
    { -1160, 208, -96},
    { -688, 512, -216},
    { -1024, 424, -144},
    { -912, 880, -56},
    { -1072, 504, 192},
    { -864, 536, 8},
    { -744, 616, -88},
    { -640, 440, -24},
    { -640, 592, -8},
    { -592, 576, -16},
    { -560, 520, 0},
    { -552, 592, 24},
    { -536, 520, 24},
    { -448, 520, 40},
    { -440, 496, 16},
    { -544, 560, -16},
    { -672, 528, 48},
    { -1104, 520, 72},
    { -1800, 432, 96},
    { -1400, -88, 440},
    { -1144, -64, 224},
    { -1328, 24, 136},
    { -848, 312, 136},
    { -736, 208, 280},
    { -760, 544, 144},
    // 104 seconds
    { -632, 520, 256},
    { -568, 512, -24},
    { -688, 616, 24},
    { -640, 528, 96},
    { -680, 656, -48},
    { -560, 656, -40},
    { -664, 680, -64},
    { -1008, 712, 32},
    { -1024, 520, -32},
    { -1576, 544, -64},
    { -1712, 328, 96},
    { -1448, 152, -24},
    { -1192, -560, 32},
    { -1184, -352, -208},
    { -736, -688, 160},
    { -488, -192, -104},
    { -568, -184, -40},
    { -648, -80, 56},
    { -736, 144, 112},
    { -840, 320, 24},
    { -856, 464, -64},
    { -760, 480, -16},
    { -968, 616, -48},
    { -1080, 608, -144},
    { -1336, 528, -64},
    // 105 seconds
    { -1464, 1016, -208},
    { -960, 496, 0},
    { -1024, 576, -160},
    { -1104, 480, 32},
    { -800, 368, 64},
    { -584, 264, 96},
    { -576, 328, 80},
    { -624, 344, 80},
    { -704, 208, 128},
    { -712, 216, 168},
    { -944, 296, 64},
    { -1048, 152, 224},
    { -1096, 152, 184},
    { -1280, 184, -40},
    { -1328, 168, 0},
    { -1064, 312, -160},
    { -1048, 136, 0},
    { -904, 280, -80},
    { -576, 176, -160},
    { -448, 264, -232},
    { -432, 288, -104},
    { -568, 384, -56},
    { -776, 480, -40},
    { -856, 528, 32},
    { -760, 536, -40},
    // 106 seconds
    { -840, 568, -152},
    { -1128, 640, -152},
    { -1512, 528, -88},
    { -1304, 592, -272},
    { -1048, 480, -56},
    { -1128, 472, -96},
    { -1056, 464, 16},
    { -800, 320, 64},
    { -536, 288, 64},
    { -536, 368, 64},
    { -584, 216, 72},
    { -568, 80, 152},
    { -656, 248, 96},
    { -728, 264, 48},
    { -984, 192, 32},
    { -1128, 168, 16},
    { -1304, 144, 48},
    { -1248, 216, -128},
    { -976, 392, -208},
    { -1032, 384, -168},
    { -928, 360, -168},
    { -696, 368, -80},
    { -448, 352, -144},
    { -424, 344, -144},
    { -440, 328, -32},
    // 107 seconds
    { -544, 400, -96},
    { -728, 400, -64},
    { -760, 448, -152},
    { -808, 448, -152},
    { -1248, 1288, -104},
    { -1152, 976, 56},
    { -1168, 1096, 264},
    { -1264, 1152, 400},
    { -1288, 664, 616},
    { -1192, 640, 432},
    { -832, 312, 536},
    { -520, 296, 296},
    { -312, 344, 104},
    { -160, 136, 232},
    { -96, 336, 112},
    { -96, 424, 176},
    { -64, 576, 128},
    { -184, 632, 144},
    { -352, 824, 192},
    { -488, 952, 56},
    { -672, 640, 184},
    { -792, 776, 144},
    { -904, 728, 128},
    { -1080, 592, 176},
    { -1168, 680, 160},
    // 108 seconds
    { -856, 560, 128},
    { -584, 568, 176},
    { -608, 560, 72},
    { -632, 376, 176},
    { -688, 384, 200},
    { -704, 456, 72},
    { -744, 448, 80},
    { -944, 584, 80},
    { -1104, 256, 72},
    { -1424, 624, -32},
    { -1344, 648, -64},
    { -1032, 288, -16},
    { -904, 488, -168},
    { -1048, 456, 0},
    { -960, 304, 104},
    { -704, 208, 184},
    { -600, 296, 160},
    { -600, 304, 152},
    { -592, 304, 160},
    { -616, 264, 96},
    { -656, 240, 160},
    { -960, 448, 240},
    { -1168, 240, 16},
    { -1240, 56, 168},
    { -1264, 16, 112},
    // 109 seconds
    { -1368, 376, -136},
    { -936, 264, -104},
    { -1040, 248, -168},
    { -744, 232, -112},
    { -536, 248, -64},
    { -440, 312, -128},
    { -520, 272, -48},
    { -552, 368, 8},
    { -696, 456, -56},
    { -752, 464, -24},
    { -784, 536, -8},
    { -952, 568, -184},
    { -1072, 360, 24},
    { -1520, 400, -80},
    { -1320, 600, -224},
    { -976, 464, -128},
    { -1104, 520, -184},
    { -1096, 376, 8},
    { -808, 360, 80},
    { -544, 312, 72},
    { -520, 376, 56},
    { -520, 288, 112},
    { -496, 224, 128},
    { -568, 360, 208},
    { -616, 368, 112},
    // 110 seconds
    { -960, 312, 104},
    { -1096, 104, 88},
    { -1424, 328, 40},
    { -1448, 176, -112},
    { -1160, 144, -136},
    { -984, 152, -144},
    { -952, 96, -56},
    { -752, 192, -40},
    { -560, 264, -24},
    { -496, 352, -40},
    { -568, 344, -40},
    { -608, 376, 48},
    { -736, 488, -32},
    { -704, 432, -40},
    { -832, 520, 56},
    { -1152, 632, -104},
    { -1256, 288, 80},
    { -1408, 680, -168},
    { -1112, 536, -112},
    { -1072, 528, -56},
    { -1152, 456, 64},
    { -1000, 400, 192},
    { -688, 352, 216},
    { -600, 216, 216},
    { -608, 88, 312},
    // 111 seconds
    { -528, 232, 200},
    { -504, 312, 104},
    { -488, 264, 112},
    { -816, 656, 216},
    { -1016, -8, 64},
    { -1232, -16, 88},
    { -1472, 312, -96},
    { -1352, 408, -160},
    { -920, 272, -200},
    { -1024, 168, -152},
    { -824, 152, -72},
    { -560, 96, -24},
    { -472, 240, -48},
    { -520, 296, -8},
    { -560, 312, 32},
    { -640, 344, 48},
    { -712, 376, -16},
    { -784, 480, 16},
    { -1000, 720, -312},
    { -1160, 384, -104},
    { -1472, 496, -208},
    { -1312, 656, -192},
    { -808, 600, -224},
    { -1032, 640, -160},
    { -1304, 544, -56},
    // 112 seconds
    { -1120, 360, 208},
    { -920, 560, -8},
    { -904, 600, 184},
    { -848, 464, 248},
    { -752, 312, 80},
    { -640, 328, 56},
    { -464, 208, -24},
    { -344, 136, -200},
    { -456, 368, -344},
    { -304, 536, -400},
    { -536, 1536, -1248},
    { -656, 376, -560},
    { -672, 960, -1248},
    { -488, 64, -896},
    { -376, 216, -752},
    { -304, 8, -576},
    { -184, -48, -584},
    { -96, -40, -536},
    { -112, -72, -536},
    { -96, -536, -128},
    { -128, 96, 64},
    { -32, 968, -120},
    { 336, 1648, -312},
    { 224, 1320, -88},
    { 272, 872, 184},
    // 113 seconds
    { 160, 1392, 280},
    { 104, 1504, 384},
    { 80, 984, 544},
    { 200, 1312, 432},
    { 144, 672, 376},
    { -48, 976, 264},
    { -80, 920, 72},
    { 0, 728, 152},
    { 192, 896, 208},
    { 184, 944, 64},
    { 336, 1424, -248},
    { 456, 1288, -344},
    { 312, 816, -128},
    { -32, 0, -600},
    { -408, 520, -1080},
    { -224, -80, -816},
    { -328, 176, -1176},
    { -616, 384, -1368},
    { -496, -24, -848},
    { -272, 80, -872},
    { -288, 0, -648},
    { -200, -96, -688},
    { -128, -32, -728},
    { -200, -136, -632},
    { -208, -32, -816},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

