/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:03:43 local
AccelRawData *activity_sample_walk_200_pbl_25656_8(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25656_8
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 250
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -184, -504, -912},
    { -160, -504, -880},
    { -208, -536, -872},
    { -176, -528, -832},
    { -184, -552, -840},
    { -192, -552, -848},
    { -176, -560, -840},
    { -184, -568, -848},
    { -184, -584, -864},
    { -168, -568, -840},
    { -184, -584, -856},
    { -192, -576, -864},
    { -184, -568, -856},
    { -184, -552, -880},
    { -184, -560, -864},
    { -176, -552, -856},
    { -176, -560, -864},
    { -176, -536, -872},
    { -176, -544, -848},
    { -176, -552, -848},
    { -160, -536, -840},
    { -200, -520, -816},
    { -72, -472, -848},
    { -128, -624, -840},
    { -160, -560, -856},
    // 1 seconds
    { -168, -480, -880},
    { -192, -496, -920},
    { -152, -544, -936},
    { -120, -520, -856},
    { -160, -544, -856},
    { -104, -552, -872},
    { -144, -544, -864},
    { -96, -560, -864},
    { -168, -536, -840},
    { -152, -480, -816},
    { -168, -544, -744},
    { -96, -384, -792},
    { -72, -408, -776},
    { -64, -296, -880},
    { -136, -304, -904},
    { -112, -224, -1088},
    { -128, -240, -1128},
    { -144, -328, -1056},
    { -96, -256, -1120},
    { -88, -304, -1024},
    { -80, -328, -904},
    { -64, -352, -808},
    { -64, -376, -704},
    { -16, -392, -680},
    { 48, -256, -752},
    // 2 seconds
    { 128, -320, -720},
    { 216, -128, -728},
    { 328, -160, -728},
    { 512, -256, -576},
    { 792, 112, -632},
    { 1160, 88, -464},
    { 1448, 248, -456},
    { 1576, 440, -152},
    { 1448, 496, -264},
    { 1128, 568, -296},
    { 944, 464, -304},
    { 1200, 312, -248},
    { 1280, 192, -200},
    { 1080, 192, -240},
    { 816, 192, -216},
    { 592, 208, -168},
    { 520, 216, -160},
    { 552, 240, -120},
    { 680, 248, -128},
    { 936, 256, -192},
    { 1120, 336, -248},
    { 1128, 344, -304},
    { 1216, 320, -288},
    { 1272, 328, -296},
    { 1024, 344, -272},
    // 3 seconds
    { 944, 296, -264},
    { 968, 264, -208},
    { 1192, 328, -120},
    { 1136, 264, -72},
    { 1008, 200, -40},
    { 816, 128, -72},
    { 736, 80, -56},
    { 744, 128, -24},
    { 808, 152, -8},
    { 952, 112, 16},
    { 1040, 160, -32},
    { 1104, 184, -80},
    { 1072, 104, -80},
    { 1176, 168, -152},
    { 1128, 144, -112},
    { 1048, 152, -88},
    { 1104, 136, -176},
    { 1192, 168, -184},
    { 1040, 192, -184},
    { 760, 168, -144},
    { 552, 152, -160},
    { 464, 192, -152},
    { 496, 168, -104},
    { 648, 240, -96},
    { 896, 232, -152},
    // 4 seconds
    { 1192, 240, -208},
    { 1152, 288, -288},
    { 1112, 288, -280},
    { 1200, 344, -264},
    { 1016, 336, -248},
    { 1024, 320, -200},
    { 1072, 320, -136},
    { 1272, 296, -56},
    { 1120, 232, 24},
    { 840, 192, -16},
    { 648, 168, -96},
    { 616, 176, -80},
    { 696, 208, -48},
    { 840, 184, 16},
    { 1072, 136, -8},
    { 1216, 104, 32},
    { 1160, 80, -32},
    { 1096, 48, -56},
    { 1192, 120, -40},
    { 1056, 144, -8},
    { 1104, 144, -64},
    { 1280, 168, -80},
    { 1152, 232, -104},
    { 832, 216, -120},
    { 568, 192, -136},
    // 5 seconds
    { 456, 208, -136},
    { 464, 200, -120},
    { 536, 192, -120},
    { 744, 248, -176},
    { 1040, 304, -248},
    { 1128, 344, -304},
    { 1152, 368, -272},
    { 1312, 368, -240},
    { 1152, 352, -248},
    { 1120, 344, -208},
    { 1224, 264, -104},
    { 1192, 240, -96},
    { 1008, 216, -8},
    { 744, 192, -32},
    { 592, 176, -64},
    { 560, 144, -24},
    { 632, 152, -32},
    { 800, 144, -32},
    { 1072, 128, -96},
    { 1144, 216, -144},
    { 1224, 104, -112},
    { 1104, 120, -120},
    { 1160, 80, -112},
    { 1056, 96, -8},
    { 1104, 128, -48},
    // 6 seconds
    { 1248, 184, -72},
    { 1136, 248, -120},
    { 808, 240, -160},
    { 512, 168, -192},
    { 408, 128, -232},
    { 456, 144, -176},
    { 608, 168, -184},
    { 752, 216, -216},
    { 1104, 264, -240},
    { 1168, 296, -296},
    { 1192, 304, -240},
    { 1248, 328, -200},
    { 1064, 328, -192},
    { 1000, 328, -176},
    { 1144, 312, -96},
    { 1256, 288, -64},
    { 1136, 264, -16},
    { 928, 232, -32},
    { 728, 208, -80},
    { 672, 152, -104},
    { 736, 152, -40},
    { 792, 128, -16},
    { 864, 96, -56},
    { 992, 144, -112},
    { 1040, 152, -160},
    // 7 seconds
    { 1048, 96, -192},
    { 1232, 144, -128},
    { 1168, 176, -96},
    { 1072, 184, -120},
    { 1216, 232, -112},
    { 1248, 248, -104},
    { 1032, 224, -104},
    { 736, 232, -120},
    { 528, 216, -112},
    { 448, 200, -104},
    { 496, 176, -64},
    { 640, 216, -88},
    { 888, 240, -128},
    { 1120, 296, -208},
    { 1160, 304, -240},
    { 1232, 312, -248},
    { 1224, 368, -288},
    { 1112, 400, -264},
    { 984, 352, -240},
    { 1104, 320, -216},
    { 1136, 264, -168},
    { 1008, 192, -88},
    { 800, 168, -104},
    { 672, 136, -96},
    { 640, 160, -64},
    // 8 seconds
    { 712, 176, -32},
    { 840, 176, -24},
    { 1056, 144, -56},
    { 1200, 136, -56},
    { 1160, 144, -112},
    { 1200, 152, -160},
    { 1112, 104, -160},
    { 1024, 88, -56},
    { 1168, 208, -64},
    { 1200, 256, -168},
    { 1016, 232, -224},
    { 744, 208, -128},
    { 504, 176, -160},
    { 416, 208, -104},
    { 472, 216, -144},
    { 616, 256, -88},
    { 872, 280, -136},
    { 1216, 328, -176},
    { 1192, 368, -248},
    { 1264, 376, -224},
    { 1296, 400, -232},
    { 1032, 392, -192},
    { 984, 360, -184},
    { 1104, 320, -144},
    { 1128, 280, -104},
    // 9 seconds
    { 984, 248, -72},
    { 792, 200, -72},
    { 720, 160, -64},
    { 712, 160, -56},
    { 784, 168, -32},
    { 880, 136, -24},
    { 1024, 120, -64},
    { 1120, 144, -104},
    { 1112, 80, -120},
    { 1200, 136, -160},
    { 1168, 128, -112},
    { 1064, 128, -160},
    { 1176, 184, -128},
    { 1208, 184, -104},
    { 1016, 192, -112},
    { 720, 208, -152},
    { 512, 200, -160},
    { 440, 160, -160},
    { 496, 184, -128},
    { 640, 224, -104},
    { 944, 264, -192},
    { 1296, 408, -336},
    { 1176, 376, -288},
    { 1240, 368, -216},
    { 1232, 408, -216},
    // 10 seconds
    { 968, 352, -224},
    { 1000, 368, -184},
    { 1104, 328, -144},
    { 1152, 256, -88},
    { 1056, 200, -32},
    { 808, 168, -32},
    { 656, 160, -64},
    { 640, 128, -64},
    { 704, 176, -32},
    { 864, 160, 8},
    { 1112, 112, -48},
    { 1128, 152, -40},
    { 1136, 88, -88},
    { 1216, 128, -192},
    { 1184, 136, -88},
    { 1048, 104, -128},
    { 1184, 152, -120},
    { 1224, 184, -88},
    { 1064, 200, -120},
    { 768, 200, -112},
    { 536, 208, -144},
    { 440, 192, -128},
    { 488, 176, -112},
    { 656, 200, -144},
    { 928, 272, -152},
    // 11 seconds
    { 1208, 296, -272},
    { 1160, 320, -256},
    { 1216, 296, -264},
    { 1264, 368, -240},
    { 1064, 376, -240},
    { 1040, 304, -168},
    { 1096, 320, -136},
    { 1096, 280, -80},
    { 992, 192, -56},
    { 776, 184, 8},
    { 648, 120, -48},
    { 688, 128, -72},
    { 768, 120, -56},
    { 952, 64, -64},
    { 1152, 64, -16},
    { 1152, 40, 0},
    { 1096, 88, -24},
    { 1288, 144, -80},
    { 1192, 176, -40},
    { 1104, 144, -56},
    { 1192, 104, -24},
    { 1224, 184, -128},
    { 1016, 232, -176},
    { 712, 216, -184},
    { 488, 152, -184},
    // 12 seconds
    { 416, 128, -160},
    { 464, 128, -104},
    { 632, 144, -144},
    { 920, 160, -176},
    { 1240, 360, -264},
    { 1152, 400, -288},
    { 1232, 376, -288},
    { 1168, 432, -248},
    { 1016, 376, -232},
    { 1128, 336, -160},
    { 1208, 312, -88},
    { 1176, 264, -40},
    { 1008, 192, -32},
    { 752, 128, -40},
    { 616, 120, -104},
    { 632, 112, -64},
    { 672, 136, 0},
    { 832, 128, -32},
    { 1048, 32, -16},
    { 1104, 88, -8},
    { 1112, 104, -96},
    { 1160, 144, -128},
    { 1128, 136, -104},
    { 1096, 144, -144},
    { 1184, 176, -152},
    // 13 seconds
    { 1296, 192, -136},
    { 1144, 216, -128},
    { 800, 232, -184},
    { 512, 168, -184},
    { 392, 144, -184},
    { 424, 216, -144},
    { 576, 232, -184},
    { 800, 256, -264},
    { 1192, 296, -232},
    { 1120, 384, -288},
    { 1080, 360, -232},
    { 1240, 336, -200},
    { 1208, 344, -200},
    { 1008, 344, -128},
    { 1008, 312, -112},
    { 1096, 296, -112},
    { 968, 256, -16},
    { 768, 184, 8},
    { 680, 144, -56},
    { 664, 136, -80},
    { 728, 104, -56},
    { 880, 120, -64},
    { 968, 88, -32},
    { 1112, 96, -56},
    { 1104, 136, -96},
    // 14 seconds
    { 1152, 120, -104},
    { 1224, 120, -112},
    { 1104, 136, -72},
    { 1120, 144, -80},
    { 1232, 200, -72},
    { 1096, 232, -112},
    { 840, 272, -112},
    { 584, 224, -144},
    { 432, 152, -88},
    { 424, 136, -88},
    { 544, 200, -88},
    { 784, 256, -192},
    { 1112, 280, -144},
    { 1240, 256, -280},
    { 1128, 312, -224},
    { 1280, 312, -200},
    { 1168, 344, -216},
    { 992, 360, -152},
    { 1024, 336, -160},
    { 1072, 336, -104},
    { 1024, 304, -48},
    { 864, 240, -32},
    { 696, 144, -56},
    { 648, 120, -40},
    { 696, 64, -32},
    // 15 seconds
    { 832, 112, -8},
    { 1040, 104, 24},
    { 1176, 144, 24},
    { 1152, 112, -32},
    { 1168, 104, -48},
    { 1200, 120, -40},
    { 1064, 80, -72},
    { 1024, 48, -80},
    { 1224, 136, -48},
    { 1192, 176, -136},
    { 936, 232, -136},
    { 648, 208, -168},
    { 480, 160, -224},
    { 456, 152, -120},
    { 520, 256, -184},
    { 728, 248, -240},
    { 1048, 304, -312},
    { 1208, 288, -384},
    { 1056, 288, -328},
    { 1224, 248, -232},
    { 1232, 296, -192},
    { 1032, 280, -136},
    { 1096, 288, -112},
    { 1168, 264, 8},
    { 1104, 288, 0},
    // 16 seconds
    { 872, 192, 32},
    { 680, 160, -24},
    { 608, 128, -112},
    { 648, 72, -56},
    { 760, 104, 0},
    { 872, 128, -64},
    { 1112, 64, -56},
    { 1184, 176, -72},
    { 1160, 144, -104},
    { 1208, 152, -120},
    { 1136, 120, -48},
    { 1080, 128, -32},
    { 1224, 184, -56},
    { 1160, 224, -112},
    { 912, 232, -120},
    { 616, 216, -112},
    { 448, 168, -104},
    { 416, 160, -112},
    { 544, 176, -120},
    { 768, 192, -160},
    { 1016, 240, -160},
    { 1088, 296, -224},
    { 1160, 320, -248},
    { 1272, 312, -216},
    { 1160, 328, -224},
    // 17 seconds
    { 1008, 336, -216},
    { 1144, 304, -192},
    { 1176, 296, -120},
    { 1112, 272, -72},
    { 912, 216, -40},
    { 736, 200, -8},
    { 672, 152, -48},
    { 576, 136, -8},
    { 800, 88, 0},
    { 920, 104, -24},
    { 1080, 136, -56},
    { 1096, 88, -8},
    { 1152, 112, -32},
    { 1152, 144, -56},
    { 1040, 136, -24},
    { 1112, 192, -64},
    { 1280, 224, -104},
    { 1168, 192, -136},
    { 840, 224, -112},
    { 568, 224, -168},
    { 464, 216, -144},
    { 440, 232, -112},
    { 600, 184, -144},
    { 872, 192, -160},
    { 1328, 288, -320},
    // 18 seconds
    { 1152, 328, -328},
    { 1168, 336, -280},
    { 1328, 392, -248},
    { 1064, 344, -184},
    { 1008, 336, -176},
    { 1136, 296, -128},
    { 1216, 272, -32},
    { 1088, 264, 48},
    { 832, 192, 0},
    { 776, 192, -32},
    { 736, 136, 0},
    { 776, 120, 16},
    { 832, 128, 16},
    { 912, 120, 0},
    { 1048, 112, -40},
    { 1104, 112, -40},
    { 1096, 112, -88},
    { 1192, 184, -112},
    { 1088, 168, -72},
    { 1080, 160, -72},
    { 1280, 232, -72},
    { 1240, 248, -136},
    { 944, 264, -128},
    { 624, 240, -168},
    { 464, 240, -128},
    // 19 seconds
    { 448, 184, -104},
    { 552, 208, -104},
    { 752, 240, -144},
    { 1128, 272, -200},
    { 1184, 336, -280},
    { 1136, 296, -248},
    { 1312, 352, -208},
    { 1232, 392, -208},
    { 1088, 312, -160},
    { 1048, 304, -104},
    { 1152, 296, -24},
    { 1048, 272, 80},
    { 824, 192, 80},
    { 656, 192, 24},
    { 656, 136, 32},
    { 728, 120, 104},
    { 848, 120, 120},
    { 1000, 80, 88},
    { 1176, 152, 80},
    { 1056, 128, 40},
    { 1144, 144, 0},
    { 1104, 160, -8},
    { 1096, 136, -56},
    { 1264, 136, -48},
    { 1312, 200, -104},
    // 20 seconds
    { 1048, 232, -208},
    { 704, 200, -176},
    { 496, 144, -184},
    { 448, 88, -216},
    { 528, 80, -88},
    { 664, 248, -176},
    { 936, 328, -232},
    { 1160, 400, -272},
    { 1136, 384, -288},
    { 1160, 272, -208},
    { 1192, 344, -168},
    { 1128, 352, -152},
    { 1208, 368, -16},
    { 1288, 312, 72},
    { 1216, 256, 120},
    { 920, 232, 24},
    { 680, 208, -8},
    { 608, 160, 0},
    { 608, 152, 48},
    { 688, 80, 64},
    { 824, 96, 56},
    { 968, 208, 48},
    { 1112, 200, 0},
    { 1152, 168, 56},
    { 1288, 168, 56},
    // 21 seconds
    { 1184, 128, 24},
    { 1056, 152, 0},
    { 1232, 192, -88},
    { 1296, 216, -144},
    { 1040, 256, -176},
    { 672, 208, -200},
    { 480, 192, -176},
    { 440, 200, -176},
    { 480, 192, -176},
    { 672, 224, -208},
    { 952, 240, -208},
    { 1152, 256, -248},
    { 1152, 288, -216},
    { 1112, 264, -152},
    { 1128, 288, -144},
    { 1208, 336, -120},
    { 1256, 344, -56},
    { 1264, 280, 40},
    { 1112, 224, 88},
    { 824, 216, 0},
    { 728, 192, -48},
    { 680, 104, 16},
    { 744, 112, 24},
    { 792, 120, 32},
    { 720, 136, 40},
    // 22 seconds
    { 664, 112, 0},
    { 768, 112, -16},
    { 776, 120, -16},
    { 680, 120, -64},
    { 1096, 88, 16},
    { 1896, 152, 208},
    { 1840, 296, -272},
    { 2080, 336, -256},
    { 1376, 272, -256},
    { 752, 184, -240},
    { 440, 120, -272},
    { 304, 176, -200},
    { 336, 248, -168},
    { 512, 248, -176},
    { 936, 280, -192},
    { 1432, 336, -232},
    { 1336, 360, -152},
    { 1208, 328, -112},
    { 1128, 352, -128},
    { 856, 336, -168},
    { 960, 352, -168},
    { 1192, 288, -88},
    { 1280, 248, 16},
    { 1144, 216, 48},
    { 904, 200, -40},
    // 23 seconds
    { 832, 168, -40},
    { 768, 160, -8},
    { 840, 136, 72},
    { 960, 88, 24},
    { 1056, 104, 24},
    { 1168, 128, -40},
    { 1088, 136, -96},
    { 1144, 136, -120},
    { 1096, 128, -40},
    { 1176, 128, -40},
    { 1352, 192, -88},
    { 1328, 256, -144},
    { 1048, 264, -144},
    { 696, 256, -176},
    { 480, 184, -128},
    { 400, 184, -80},
    { 496, 216, -104},
    { 728, 224, -128},
    { 1064, 256, -128},
    { 1288, 328, -120},
    { 1224, 320, -168},
    { 1176, 328, -192},
    { 1000, 344, -208},
    { 1072, 344, -184},
    { 1224, 304, -144},
    // 24 seconds
    { 1200, 264, -120},
    { 1064, 208, -32},
    { 824, 176, -48},
    { 704, 136, -64},
    { 680, 144, -40},
    { 672, 104, 8},
    { 872, 144, -8},
    { 1056, 120, -8},
    { 1216, 152, -8},
    { 1160, 104, 24},
    { 1240, 128, -24},
    { 1176, 176, -8},
    { 1048, 176, -16},
    { 1200, 136, -24},
    { 1288, 224, -88},
    { 1064, 240, -176},
    { 736, 264, -136},
    { 488, 184, -136},
    { 408, 128, -136},
    { 464, 104, -120},
    { 616, 168, -136},
    { 864, 184, -200},
    { 1240, 240, -224},
    { 1216, 288, -296},
    { 1144, 296, -248},
    // 25 seconds
    { 1168, 352, -256},
    { 1016, 344, -232},
    { 1112, 320, -184},
    { 1312, 336, -104},
    { 1240, 272, -48},
    { 1064, 216, -32},
    { 808, 168, -32},
    { 688, 120, -72},
    { 648, 176, -24},
    { 712, 168, 0},
    { 816, 120, -24},
    { 1024, 8, -16},
    { 1112, -8, -8},
    { 1160, 48, -64},
    { 1296, 160, -64},
    { 1184, 152, -48},
    { 1104, 152, -40},
    { 1280, 224, -64},
    { 1264, 216, -120},
    { 1048, 104, -208},
    { 720, 176, -208},
    { 488, 128, -128},
    { 400, 176, -136},
    { 424, 144, -136},
    { 592, 176, -112},
    // 26 seconds
    { 952, 192, -128},
    { 1272, 312, -216},
    { 1192, 304, -216},
    { 1232, 304, -232},
    { 1248, 376, -200},
    { 1056, 384, -224},
    { 1048, 384, -200},
    { 1144, 352, -136},
    { 1168, 280, -104},
    { 1040, 216, -40},
    { 872, 168, 16},
    { 768, 136, -24},
    { 744, 136, -24},
    { 808, 128, 72},
    { 896, 136, 72},
    { 1064, 96, 24},
    { 1160, 80, 8},
    { 1040, 48, -80},
    { 1200, 80, -24},
    { 1184, 112, -56},
    { 1152, 208, -128},
    { 1280, 160, -128},
    { 1264, 136, -136},
    { 1008, 168, -336},
    { 672, 72, -112},
    // 27 seconds
    { 504, 136, -176},
    { 448, 224, -192},
    { 504, 216, -168},
    { 704, 192, -128},
    { 1048, 256, -144},
    { 1232, 280, -256},
    { 1136, 280, -224},
    { 1120, 296, -200},
    { 1144, 336, -224},
    { 1032, 328, -224},
    { 1032, 296, -168},
    { 1144, 272, -136},
    { 1216, 256, -64},
    { 1104, 224, -24},
    { 896, 224, -8},
    { 760, 176, -32},
    { 728, 160, -64},
    { 736, 144, 8},
    { 808, 160, -16},
    { 904, 112, -24},
    { 1064, 112, -24},
    { 1016, 96, -64},
    { 1104, 104, -120},
    { 1184, 160, -88},
    { 1104, 176, -32},
    // 28 seconds
    { 1192, 192, -128},
    { 1352, 264, -144},
    { 1192, 232, -160},
    { 840, 208, -144},
    { 576, 200, -168},
    { 488, 176, -152},
    { 520, 152, -144},
    { 632, 216, -128},
    { 808, 200, -184},
    { 1056, 256, -224},
    { 1152, 304, -288},
    { 1144, 296, -264},
    { 1152, 328, -216},
    { 1000, 328, -232},
    { 1032, 360, -208},
    { 1160, 328, -136},
    { 1264, 272, -96},
    { 1216, 248, -32},
    { 944, 216, -32},
    { 744, 160, -32},
    { 672, 160, -56},
    { 688, 192, -8},
    { 808, 152, -32},
    { 872, 112, 0},
    { 1032, 112, -64},
    // 29 seconds
    { 1072, 112, -64},
    { 1032, 112, -112},
    { 1168, 160, -152},
    { 1168, 160, -56},
    { 1056, 208, -104},
    { 1232, 216, -152},
    { 1256, 272, -160},
    { 1000, 288, -184},
    { 688, 136, -192},
    { 544, 232, -96},
    { 488, 232, -136},
    { 504, 208, -160},
    { 640, 224, -136},
    { 888, 272, -184},
    { 1176, 328, -216},
    { 1080, 344, -232},
    { 1040, 336, -224},
    { 1144, 376, -200},
    { 1168, 384, -208},
    { 1256, 376, -136},
    { 1304, 328, -88},
    { 1184, 200, 56},
    { 1040, 256, 0},
    { 808, 112, -56},
    { 680, 96, -48},
    // 30 seconds
    { 672, 168, 8},
    { 784, 104, 0},
    { 808, 64, 24},
    { 904, 72, 32},
    { 1056, 112, -8},
    { 976, 112, -48},
    { 1200, 144, -80},
    { 1136, 152, -72},
    { 1208, 176, -72},
    { 1440, 280, -152},
    { 1328, 320, -224},
    { 952, 264, -208},
    { 600, 192, -176},
    { 464, 176, -192},
    { 432, 136, -104},
    { 536, 168, -136},
    { 656, 184, -200},
    { 872, 224, -224},
    { 1080, 272, -288},
    { 1112, 432, -304},
    { 1240, 512, -200},
    { 1264, 560, -200},
    { 1264, 408, -88},
    { 1344, 344, -48},
    { 1336, 328, -24},
    // 31 seconds
    { 1200, 280, 0},
    { 896, 192, 8},
    { 672, 152, -40},
    { 608, 176, 8},
    { 600, 104, 56},
    { 656, 48, 56},
    { 728, 48, 40},
    { 896, 88, 32},
    { 1024, 152, -16},
    { 1056, 136, -80},
    { 1240, 152, -32},
    { 1200, 176, 56},
    { 1360, 176, -80},
    { 1568, 296, -144},
    { 1352, 360, -216},
    { 848, 272, -208},
    { 536, 240, -272},
    { 400, 152, -192},
    { 424, 216, -56},
    { 544, 288, -96},
    { 776, 320, -104},
    { 1088, 432, -160},
    { 1128, 456, -144},
    { 1080, 400, -80},
    { 1000, 344, -112},
    // 32 seconds
    { 1192, 448, -200},
    { 1648, 448, -104},
    { 1680, 352, 48},
    { 1336, 264, 16},
    { 928, 200, -64},
    { 696, 144, -56},
    { 616, 192, -112},
    { 688, 88, -56},
    { 856, -40, 0},
    { 960, 0, 64},
    { 1136, -40, -24},
    { 1072, 40, 8},
    { 1240, 80, -24},
    { 1368, 136, 88},
    { 1448, 216, 8},
    { 1592, 280, -120},
    { 1272, 264, -120},
    { 808, 224, -192},
    { 480, 208, -240},
    { 400, 176, -192},
    { 464, 208, -120},
    { 712, 208, -152},
    { 1320, 336, -224},
    { 1320, 368, -192},
    { 1280, 360, -152},
    // 33 seconds
    { 1192, 312, -192},
    { 1024, 320, -96},
    { 1272, 416, -232},
    { 928, 392, -128},
    { 1160, 280, -48},
    { 1144, 232, -88},
    { 1120, 224, -176},
    { 944, 64, -208},
    { 760, 96, -168},
    { 648, 160, -8},
    { 624, 96, 0},
    { 720, 48, -56},
    { 968, 128, -104},
    { 976, 64, -104},
    { 1056, 48, -112},
    { 1152, 88, -184},
    { 1456, 144, -80},
    { 1480, 216, -88},
    { 1336, 240, -152},
    { 1336, 272, -152},
    { 1112, 256, -160},
    { 768, 184, -160},
    { 528, 160, -120},
    { 416, 184, -120},
    { 424, 128, -64},
    // 34 seconds
    { 592, 192, -8},
    { 984, 256, -80},
    { 1248, 328, -160},
    { 1184, 392, -176},
    { 1368, 424, -200},
    { 1280, 432, -224},
    { 1104, 344, -152},
    { 1016, 360, -176},
    { 1104, 320, -128},
    { 1032, 232, -88},
    { 816, 168, -48},
    { 648, 152, -56},
    { 680, 128, -72},
    { 776, 136, -8},
    { 984, 176, 0},
    { 1080, 104, -48},
    { 1144, 120, -16},
    { 1168, 112, -16},
    { 1128, 56, -72},
    { 1208, 88, -16},
    { 1112, 72, 16},
    { 1320, 128, -80},
    { 1360, 120, -72},
    { 1096, 176, -104},
    { 704, 168, -176},
    // 35 seconds
    { 464, 104, -136},
    { 400, 96, -120},
    { 472, 160, -80},
    { 632, 200, -96},
    { 840, 248, -112},
    { 1120, 312, -224},
    { 1096, 424, -280},
    { 1104, 400, -224},
    { 1280, 424, -200},
    { 1064, 384, -216},
    { 1184, 392, -160},
    { 1272, 344, -72},
    { 1192, 288, -32},
    { 1016, 272, -24},
    { 784, 216, -56},
    { 664, 192, -40},
    { 664, 160, -32},
    { 704, 136, -8},
    { 808, 104, -32},
    { 912, 104, 0},
    { 1016, 88, -64},
    { 1064, 96, -64},
    { 1192, 88, -128},
    { 1416, 144, -24},
    { 1240, 152, -72},
    // 36 seconds
    { 1344, 224, -160},
    { 1328, 248, -96},
    { 1008, 208, -120},
    { 600, 216, -192},
    { 448, 176, -112},
    { 408, 152, -128},
    { 504, 136, -104},
    { 664, 216, -120},
    { 864, 288, -160},
    { 1088, 432, -184},
    { 1152, 472, -224},
    { 1224, 416, -192},
    { 1264, 464, -184},
    { 1152, 440, -136},
    { 1304, 376, -48},
    { 1248, 312, -40},
    { 1080, 272, -32},
    { 816, 208, -56},
    { 664, 160, -24},
    { 648, 176, -24},
    { 704, 184, -8},
    { 784, 152, -16},
    { 904, 144, -8},
    { 1064, 88, -56},
    { 1088, 56, -32},
    // 37 seconds
    { 1112, 96, -136},
    { 1248, 136, -64},
    { 1136, 208, -48},
    { 1160, 232, -136},
    { 1288, 256, -128},
    { 1136, 240, -112},
    { 832, 288, -272},
    { 576, 200, -120},
    { 496, 160, -128},
    { 520, 216, -120},
    { 664, 240, -160},
    { 800, 216, -160},
    { 1016, 288, -240},
    { 1104, 336, -296},
    { 1152, 296, -240},
    { 1104, 336, -208},
    { 1072, 352, -208},
    { 1208, 400, -184},
    { 1344, 360, -128},
    { 1280, 272, -56},
    { 1072, 232, -32},
    { 816, 192, -64},
    { 680, 160, -64},
    { 656, 176, -72},
    { 720, 184, -40},
    // 38 seconds
    { 784, 136, -24},
    { 960, 96, -48},
    { 1064, 112, -64},
    { 1112, 72, -96},
    { 1104, 80, -160},
    { 1224, 104, -88},
    { 1128, 144, -88},
    { 1256, 216, -120},
    { 1344, 200, -160},
    { 1128, 232, -168},
    { 760, 208, -160},
    { 544, 224, -160},
    { 464, 216, -136},
    { 512, 240, -72},
    { 672, 304, -80},
    { 848, 336, -120},
    { 1128, 416, -184},
    { 1104, 368, -176},
    { 1104, 336, -168},
    { 1152, 392, -184},
    { 1000, 424, -184},
    { 1160, 384, -136},
    { 1344, 320, -48},
    { 1320, 256, 0},
    { 1056, 240, 0},
    // 39 seconds
    { 776, 208, -32},
    { 680, 144, -80},
    { 680, 160, -56},
    { 768, 144, -16},
    { 848, 80, -8},
    { 944, 40, -144},
    { 1040, 128, -56},
    { 1048, 192, -48},
    { 1096, 136, -176},
    { 1224, 224, -104},
    { 1104, 208, -128},
    { 1240, 216, -112},
    { 1336, 264, -104},
    { 1120, 248, -144},
    { 776, 192, -152},
    { 544, 168, -152},
    { 464, 192, -136},
    { 504, 168, -104},
    { 640, 200, -96},
    { 872, 248, -160},
    { 1088, 296, -184},
    { 1072, 352, -240},
    { 1112, 336, -216},
    { 1176, 360, -168},
    { 1144, 408, -192},
    // 40 seconds
    { 1200, 384, -184},
    { 1272, 344, -120},
    { 1224, 280, -72},
    { 1056, 224, -40},
    { 816, 192, -64},
    { 712, 136, -56},
    { 672, 120, -64},
    { 752, 120, -32},
    { 864, 112, -24},
    { 952, 80, 24},
    { 1096, 72, 40},
    { 1120, 48, -8},
    { 1136, 128, -80},
    { 1208, 112, -96},
    { 1144, 112, -56},
    { 1232, 152, -96},
    { 1312, 216, -136},
    { 1128, 248, -192},
    { 784, 232, -168},
    { 544, 184, -160},
    { 464, 160, -136},
    { 536, 200, -152},
    { 664, 216, -200},
    { 800, 224, -224},
    { 1056, 272, -264},
    // 41 seconds
    { 1104, 312, -288},
    { 1248, 328, -224},
    { 1344, 368, -200},
    { 1056, 328, -144},
    { 1096, 296, -40},
    { 1168, 320, -64},
    { 1104, 264, -64},
    { 896, 200, -24},
    { 696, 176, -56},
    { 648, 136, -88},
    { 672, 120, -56},
    { 808, 152, -64},
    { 904, 88, -88},
    { 1032, 56, -24},
    { 1112, 72, -80},
    { 1128, 64, -136},
    { 1360, 144, -96},
    { 1216, 128, -88},
    { 1048, 128, -128},
    { 1232, 192, -96},
    { 1200, 224, -112},
    { 928, 256, -112},
    { 608, 216, -176},
    { 480, 168, -168},
    { 496, 152, -112},
    // 42 seconds
    { 608, 192, -120},
    { 808, 304, -184},
    { 952, 352, -192},
    { 992, 408, -264},
    { 1040, 440, -216},
    { 1216, 472, -168},
    { 1160, 504, -224},
    { 1024, 408, -168},
    { 1232, 336, -88},
    { 1232, 288, -96},
    { 1096, 280, -88},
    { 840, 224, -48},
    { 720, 168, -96},
    { 656, 120, -72},
    { 648, 128, -32},
    { 744, 128, -80},
    { 752, 88, -48},
    { 968, 96, -72},
    { 1056, 104, -64},
    { 1048, 120, -104},
    { 1256, 144, -160},
    { 1128, 208, -56},
    { 1048, 200, -72},
    { 1248, 216, -120},
    { 1320, 272, -160},
    // 43 seconds
    { 1104, 280, -168},
    { 784, 248, -168},
    { 560, 224, -160},
    { 496, 216, -136},
    { 544, 200, -104},
    { 616, 240, -112},
    { 832, 280, -168},
    { 1088, 304, -216},
    { 1136, 336, -200},
    { 1216, 320, -192},
    { 1264, 352, -216},
    { 1128, 320, -144},
    { 1168, 296, -128},
    { 1224, 280, -120},
    { 1160, 288, -112},
    { 968, 208, -72},
    { 776, 160, -24},
    { 736, 136, -64},
    { 744, 152, -24},
    { 816, 168, 8},
    { 896, 120, -32},
    { 944, 120, -32},
    { 1032, 112, -32},
    { 1008, 120, -72},
    { 1176, 176, -104},
    // 44 seconds
    { 1184, 192, -80},
    { 1184, 176, -112},
    { 1328, 192, -96},
    { 1256, 240, -104},
    { 976, 280, -152},
    { 656, 256, -184},
    { 488, 200, -144},
    { 472, 176, -112},
    { 592, 216, -104},
    { 720, 232, -136},
    { 960, 280, -152},
    { 1112, 304, -240},
    { 1112, 328, -240},
    { 1248, 328, -200},
    { 1328, 384, -216},
    { 1080, 360, -160},
    { 1200, 336, -152},
    { 1208, 296, -136},
    { 1104, 248, -96},
    { 888, 200, -64},
    { 752, 168, -64},
    { 672, 168, -72},
    { 696, 136, -32},
    { 760, 152, -16},
    { 832, 128, 8},
    // 45 seconds
    { 1008, 144, -40},
    { 1056, 152, 0},
    { 1000, 152, -24},
    { 1208, 192, -104},
    { 1144, 184, -40},
    { 1144, 152, -56},
    { 1328, 208, -64},
    { 1240, 264, -104},
    { 928, 280, -120},
    { 648, 264, -168},
    { 512, 208, -136},
    { 544, 200, -112},
    { 664, 216, -112},
    { 800, 256, -144},
    { 984, 288, -184},
    { 1056, 336, -240},
    { 1096, 344, -232},
    { 1200, 352, -192},
    { 1160, 392, -216},
    { 1128, 368, -168},
    { 1216, 360, -128},
    { 1224, 328, -88},
    { 1080, 272, 16},
    { 832, 232, -8},
    { 672, 184, -8},
    // 46 seconds
    { 656, 168, -48},
    { 736, 176, -8},
    { 888, 184, -16},
    { 936, 128, 16},
    { 1104, 144, -64},
    { 1056, 112, -16},
    { 1240, 120, -64},
    { 1296, 168, -48},
    { 1040, 144, -72},
    { 1072, 168, -144},
    { 1152, 184, -152},
    { 1000, 192, -152},
    { 744, 200, -152},
    { 560, 216, -160},
    { 536, 216, -152},
    { 608, 232, -104},
    { 776, 248, -144},
    { 920, 312, -184},
    { 1056, 352, -248},
    { 1080, 360, -288},
    { 1088, 320, -248},
    { 1312, 352, -208},
    { 1144, 376, -224},
    { 1072, 360, -184},
    { 1136, 344, -136},
    // 47 seconds
    { 1184, 304, -80},
    { 1088, 256, -16},
    { 888, 216, -8},
    { 816, 176, -16},
    { 776, 176, -24},
    { 832, 184, -24},
    { 824, 136, 8},
    { 848, 104, -8},
    { 976, 112, -56},
    { 1056, 112, -72},
    { 1056, 112, -136},
    { 1200, 136, -160},
    { 1096, 128, -136},
    { 1232, 168, -200},
    { 1304, 216, -184},
    { 1104, 232, -152},
    { 808, 216, -144},
    { 576, 200, -136},
    { 504, 208, -96},
    { 544, 216, -48},
    { 656, 264, -72},
    { 816, 384, -128},
    { 1184, 496, -208},
    { 1152, 488, -224},
    { 1072, 400, -200},
    // 48 seconds
    { 1256, 408, -192},
    { 1192, 424, -184},
    { 1136, 424, -168},
    { 1120, 368, -128},
    { 1168, 312, -80},
    { 1088, 240, -24},
    { 848, 184, 8},
    { 712, 176, -56},
    { 712, 168, -56},
    { 776, 152, -16},
    { 904, 152, -16},
    { 952, 120, 32},
    { 1088, 152, 0},
    { 1112, 144, -16},
    { 1072, 88, -48},
    { 1152, 120, -40},
    { 1056, 128, -80},
    { 1208, 160, -128},
    { 1336, 216, -144},
    { 1200, 216, -184},
    { 872, 256, -176},
    { 600, 240, -208},
    { 480, 240, -168},
    { 496, 192, -160},
    { 648, 216, -112},
    // 49 seconds
    { 832, 288, -208},
    { 1048, 320, -216},
    { 1096, 360, -248},
    { 1104, 336, -192},
    { 1296, 392, -200},
    { 1248, 432, -216},
    { 1224, 384, -120},
    { 1216, 344, -88},
    { 1176, 280, -40},
    { 504, 304, -8},
    { 1208, 608, 152},
    { 640, -816, -216},
    { 1256, 64, 48},
    { 1328, 680, 208},
    { 1192, 1072, 184},
    { 1280, -600, -176},
    { 704, 112, 32},
    { 1048, 352, 56},
    { 1176, 120, 16},
    { 1200, 224, 0},
    { 1144, 216, -104},
    { 1288, 216, -88},
    { 1224, 224, -72},
    { 928, 256, -120},
    { 632, 232, -152},
    // 50 seconds
    { 480, 208, -144},
    { 480, 176, -160},
    { 584, 192, -152},
    { 776, 232, -224},
    { 984, 240, -240},
    { 1048, 288, -288},
    { 1104, 304, -248},
    { 1288, 328, -208},
    { 1288, 384, -240},
    { 1160, 368, -160},
    { 1096, 320, -120},
    { 1128, 296, -96},
    { 1056, 280, -120},
    { 872, 232, -32},
    { 736, 224, -24},
    { 744, 224, 32},
    { 864, 496, 72},
    { 864, 616, -32},
    { 896, 824, -72},
    { 1072, 904, -224},
    { 1096, 1000, -232},
    { 1320, 944, -392},
    { 1216, 792, -512},
    { 1008, 472, -496},
    { 912, 176, -560},
    // 51 seconds
    { 816, 8, -624},
    { 584, -72, -600},
    { 376, -136, -528},
    { 216, -248, -552},
    { 136, -256, -640},
    { 120, -280, -680},
    { 104, -360, -736},
    { 248, -480, -720},
    { 48, -408, -912},
    { 456, -136, -976},
    { -176, -352, -896},
    { -312, -584, -848},
    { -128, -232, -952},
    { -152, -384, -848},
    { -288, -432, -920},
    { -232, -424, -936},
    { -280, -384, -992},
    { -360, -272, -1064},
    { -152, -336, -1080},
    { -184, -296, -1072},
    { -80, -272, -1008},
    { -200, -360, -952},
    { -160, -328, -992},
    { -192, -376, -880},
    { -264, -296, -872},
    // 52 seconds
    { -216, -312, -912},
    { -184, -336, -896},
    { -208, -312, -896},
    { -176, -352, -952},
    { -256, -336, -944},
    { -240, -408, -944},
    { -232, -456, -912},
    { -200, -464, -920},
    { -224, -416, -936},
    { -184, -504, -896},
    { -168, -448, -872},
    { -224, -464, -832},
    { -224, -488, -824},
    { -208, -496, -856},
    { -184, -464, -864},
    { -56, -536, -840},
    { 16, -480, -728},
    { 256, -496, -584},
    { -288, -584, -512},
    { 128, 80, -416},
    { -72, 984, -392},
    { -216, 1160, -128},
    { -424, 1344, 440},
    { -336, 1104, 336},
    { -432, 1088, 352},
    // 53 seconds
    { -344, 1016, 336},
    { -312, 776, 464},
    { -344, 632, 400},
    { -352, 712, 536},
    { -304, 896, 672},
    { -312, 824, 688},
    { -296, 816, 720},
    { -384, 696, 592},
    { -272, 496, 480},
    { -96, 688, 56},
    { -48, 712, 432},
    { -24, 880, 448},
    { 24, 808, 424},
    { 24, 1008, 608},
    { 80, 816, 352},
    { 120, 632, 416},
    { 128, 584, 456},
    { 136, 520, 216},
    { 296, 624, 576},
    { 392, 496, 560},
    { 536, 848, 520},
    { 688, 992, 376},
    { 744, 912, 504},
    { 656, 816, 368},
    { 608, 776, 384},
    // 54 seconds
    { 600, 776, 360},
    { 592, 840, 336},
    { 584, 832, 336},
    { 536, 800, 280},
    { 560, 760, 280},
    { 600, 688, 256},
    { 608, 672, 208},
    { 552, 592, 200},
    { 592, 600, 144},
    { 624, 512, 80},
    { 712, 480, 88},
    { 784, 656, 16},
    { 800, 592, 48},
    { 792, 568, 64},
    { 808, 616, 72},
    { 792, 544, 96},
    { 768, 528, 80},
    { 760, 472, 80},
    { 800, 480, 88},
    { 848, 472, 88},
    { 792, 456, 104},
    { 816, 440, 88},
    { 816, 440, 56},
    { 816, 408, 64},
    { 800, 368, 72},
    // 55 seconds
    { 800, 384, 24},
    { 800, 384, 24},
    { 840, 368, 24},
    { 888, 384, 24},
    { 896, 376, -8},
    { 864, 352, 8},
    { 856, 352, 0},
    { 848, 336, 8},
    { 848, 376, 16},
    { 856, 408, 16},
    { 904, 360, 32},
    { 824, 312, 56},
    { 856, 328, -8},
    { 880, 328, 24},
    { 912, 320, 16},
    { 896, 304, 16},
    { 912, 328, 24},
    { 936, 312, 48},
    { 912, 304, 40},
    { 904, 304, 8},
    { 864, 312, 0},
    { 880, 312, -8},
    { 888, 328, -8},
    { 872, 328, -8},
    { 872, 320, 0},
    // 56 seconds
    { 872, 336, -16},
    { 880, 336, -16},
    { 920, 328, -24},
    { 912, 312, -8},
    { 928, 320, -32},
    { 904, 320, -56},
    { 896, 320, -72},
    { 888, 304, -80},
    { 864, 272, -56},
    { 864, 256, -64},
    { 856, 264, -72},
    { 856, 256, -88},
    { 848, 256, -88},
    { 840, 248, -88},
    { 872, 256, -88},
    { 880, 272, -96},
    { 904, 280, -80},
    { 896, 288, -96},
    { 864, 280, -88},
    { 872, 288, -104},
    { 864, 280, -96},
    { 888, 296, -104},
    { 888, 288, -96},
    { 872, 296, -96},
    { 864, 296, -104},
    // 57 seconds
    { 864, 280, -104},
    { 880, 280, -88},
    { 896, 288, -104},
    { 912, 280, -112},
    { 904, 288, -128},
    { 904, 280, -136},
    { 880, 288, -144},
    { 848, 280, -128},
    { 848, 288, -128},
    { 848, 296, -136},
    { 880, 296, -144},
    { 896, 304, -120},
    { 888, 296, -136},
    { 896, 304, -120},
    { 888, 288, -120},
    { 880, 280, -112},
    { 872, 288, -120},
    { 872, 280, -112},
    { 872, 280, -120},
    { 880, 280, -112},
    { 880, 280, -112},
    { 880, 272, -112},
    { 888, 264, -120},
    { 888, 272, -128},
    { 896, 272, -128},
    // 58 seconds
    { 880, 272, -136},
    { 880, 272, -144},
    { 888, 272, -136},
    { 888, 264, -144},
    { 880, 272, -136},
    { 888, 272, -136},
    { 896, 272, -136},
    { 904, 272, -160},
    { 888, 264, -160},
    { 872, 288, -168},
    { 872, 296, -160},
    { 880, 288, -152},
    { 888, 280, -152},
    { 872, 272, -144},
    { 856, 272, -152},
    { 872, 264, -160},
    { 864, 264, -160},
    { 872, 272, -160},
    { 872, 272, -160},
    { 872, 280, -168},
    { 872, 272, -176},
    { 872, 272, -160},
    { 888, 280, -168},
    { 880, 280, -168},
    { 880, 288, -160},
    // 59 seconds
    { 872, 280, -168},
    { 856, 280, -152},
    { 888, 272, -152},
    { 896, 280, -160},
    { 888, 280, -160},
    { 880, 272, -168},
    { 872, 264, -160},
    { 864, 256, -152},
    { 864, 256, -152},
    { 880, 264, -144},
    { 888, 264, -144},
    { 896, 264, -144},
    { 896, 248, -128},
    { 888, 256, -128},
    { 888, 248, -136},
    { 880, 240, -136},
    { 888, 248, -128},
    { 904, 256, -136},
    { 896, 264, -136},
    { 896, 256, -152},
    { 888, 264, -144},
    { 880, 256, -136},
    { 896, 256, -144},
    { 896, 256, -144},
    { 896, 272, -160},
    // 60 seconds
    // elapsed: 1 minutes
    { 880, 264, -152},
    { 880, 264, -144},
    { 880, 256, -136},
    { 888, 264, -144},
    { 888, 264, -136},
    { 888, 264, -136},
    { 888, 256, -136},
    { 888, 256, -136},
    { 888, 264, -128},
    { 880, 256, -128},
    { 896, 256, -128},
    { 896, 256, -136},
    { 888, 264, -144},
    { 880, 256, -136},
    { 888, 256, -136},
    { 896, 256, -136},
    { 888, 264, -136},
    { 896, 264, -136},
    { 888, 272, -144},
    { 888, 256, -136},
    { 888, 256, -144},
    { 888, 256, -136},
    { 880, 264, -136},
    { 888, 264, -144},
    { 896, 264, -136},
    // 61 seconds
    { 904, 264, -136},
    { 880, 256, -136},
    { 888, 256, -136},
    { 888, 256, -128},
    { 880, 272, -144},
    { 872, 256, -120},
    { 880, 264, -120},
    { 888, 280, -128},
    { 880, 280, -136},
    { 880, 272, -136},
    { 864, 264, -144},
    { 888, 264, -144},
    { 904, 240, -136},
    { 920, 248, -120},
    { 896, 248, -120},
    { 904, 256, -136},
    { 928, 264, -136},
    { 928, 248, -152},
    { 912, 248, -168},
    { 880, 232, -168},
    { 848, 224, -152},
    { 824, 192, -152},
    { 848, 200, -144},
    { 896, 208, -136},
    { 896, 224, -144},
    // 62 seconds
    { 904, 264, -152},
    { 896, 280, -168},
    { 904, 296, -152},
    { 864, 304, -160},
    { 880, 296, -160},
    { 864, 280, -144},
    { 896, 272, -152},
    { 896, 288, -152},
    { 896, 288, -152},
    { 872, 288, -136},
    { 864, 272, -128},
    { 880, 272, -128},
    { 888, 272, -128},
    { 888, 272, -120},
    { 880, 288, -136},
    { 880, 288, -144},
    { 896, 280, -136},
    { 888, 272, -136},
    { 888, 264, -136},
    { 896, 248, -136},
    { 896, 248, -144},
    { 888, 248, -152},
    { 888, 248, -144},
    { 896, 240, -144},
    { 888, 240, -144},
    // 63 seconds
    { 896, 248, -144},
    { 888, 256, -144},
    { 896, 256, -136},
    { 896, 264, -152},
    { 888, 264, -144},
    { 888, 264, -144},
    { 888, 256, -144},
    { 888, 264, -144},
    { 880, 264, -144},
    { 880, 272, -136},
    { 880, 264, -136},
    { 880, 256, -136},
    { 880, 256, -152},
    { 888, 256, -144},
    { 880, 256, -160},
    { 880, 248, -160},
    { 888, 256, -152},
    { 888, 256, -144},
    { 888, 264, -152},
    { 904, 248, -144},
    { 888, 256, -144},
    { 888, 256, -152},
    { 888, 248, -152},
    { 888, 256, -152},
    { 880, 256, -160},
    // 64 seconds
    { 888, 264, -152},
    { 888, 256, -160},
    { 888, 264, -160},
    { 888, 256, -152},
    { 880, 256, -144},
    { 880, 256, -152},
    { 888, 264, -152},
    { 904, 264, -144},
    { 880, 256, -160},
    { 872, 248, -152},
    { 880, 240, -160},
    { 888, 256, -144},
    { 888, 264, -152},
    { 896, 256, -144},
    { 880, 248, -144},
    { 888, 256, -144},
    { 896, 248, -152},
    { 888, 248, -144},
    { 888, 248, -152},
    { 896, 248, -152},
    { 888, 256, -152},
    { 896, 256, -152},
    { 888, 264, -152},
    { 888, 264, -152},
    { 888, 248, -152},
    // 65 seconds
    { 888, 256, -152},
    { 888, 264, -152},
    { 888, 264, -152},
    { 880, 264, -144},
    { 880, 264, -152},
    { 888, 256, -152},
    { 896, 264, -144},
    { 896, 264, -160},
    { 880, 248, -152},
    { 888, 240, -160},
    { 888, 248, -152},
    { 888, 256, -144},
    { 880, 264, -152},
    { 888, 264, -144},
    { 880, 264, -144},
    { 888, 264, -152},
    { 880, 264, -144},
    { 888, 272, -152},
    { 880, 264, -152},
    { 880, 264, -144},
    { 880, 264, -144},
    { 888, 272, -152},
    { 880, 264, -144},
    { 888, 256, -144},
    { 880, 248, -144},
    // 66 seconds
    { 888, 248, -144},
    { 888, 248, -144},
    { 888, 256, -144},
    { 888, 248, -144},
    { 888, 256, -136},
    { 896, 264, -152},
    { 888, 264, -152},
    { 888, 264, -160},
    { 888, 264, -152},
    { 888, 272, -152},
    { 888, 280, -160},
    { 896, 264, -160},
    { 888, 264, -152},
    { 880, 256, -152},
    { 888, 256, -152},
    { 888, 256, -144},
    { 880, 264, -144},
    { 880, 264, -144},
    { 888, 264, -152},
    { 872, 256, -144},
    { 872, 264, -152},
    { 880, 264, -152},
    { 888, 272, -144},
    { 888, 264, -136},
    { 888, 256, -144},
    // 67 seconds
    { 888, 264, -144},
    { 880, 256, -144},
    { 896, 264, -144},
    { 888, 264, -144},
    { 888, 248, -144},
    { 880, 248, -144},
    { 888, 256, -144},
    { 888, 272, -152},
    { 888, 264, -144},
    { 888, 264, -144},
    { 880, 264, -144},
    { 880, 264, -136},
    { 888, 272, -144},
    { 896, 280, -144},
    { 880, 264, -144},
    { 888, 264, -144},
    { 888, 264, -144},
    { 896, 264, -144},
    { 888, 264, -144},
    { 896, 264, -144},
    { 888, 256, -144},
    { 888, 248, -144},
    { 888, 248, -144},
    { 880, 256, -144},
    { 880, 256, -144},
    // 68 seconds
    { 888, 256, -144},
    { 896, 264, -144},
    { 880, 264, -144},
    { 888, 256, -144},
    { 888, 264, -144},
    { 896, 264, -144},
    { 888, 280, -144},
    { 880, 264, -152},
    { 880, 264, -144},
    { 880, 264, -152},
    { 888, 272, -136},
    { 880, 272, -144},
    { 888, 256, -136},
    { 888, 248, -136},
    { 888, 248, -144},
    { 888, 256, -144},
    { 888, 248, -144},
    { 888, 264, -144},
    { 888, 256, -144},
    { 888, 264, -144},
    { 888, 256, -144},
    { 896, 272, -136},
    { 880, 264, -152},
    { 880, 256, -152},
    { 888, 256, -144},
    // 69 seconds
    { 888, 264, -144},
    { 888, 264, -136},
    { 896, 248, -128},
    { 880, 256, -136},
    { 896, 256, -136},
    { 880, 248, -144},
    { 896, 256, -136},
    { 888, 256, -144},
    { 888, 256, -136},
    { 888, 264, -136},
    { 896, 272, -144},
    { 888, 272, -144},
    { 888, 272, -144},
    { 888, 272, -144},
    { 888, 264, -136},
    { 888, 272, -144},
    { 888, 264, -144},
    { 896, 264, -144},
    { 896, 256, -144},
    { 888, 248, -152},
    { 896, 248, -144},
    { 896, 240, -152},
    { 920, 264, -152},
    { 904, 248, -144},
    { 888, 248, -152},
    // 70 seconds
    { 872, 232, -152},
    { 872, 248, -160},
    { 896, 248, -176},
    { 896, 256, -152},
    { 888, 240, -168},
    { 880, 240, -160},
    { 872, 248, -152},
    { 896, 264, -160},
    { 904, 256, -160},
    { 904, 256, -168},
    { 912, 232, -168},
    { 928, 240, -184},
    { 904, 224, -192},
    { 920, 216, -192},
    { 904, 232, -208},
    { 904, 240, -200},
    { 872, 248, -184},
    { 864, 256, -192},
    { 880, 256, -192},
    { 880, 240, -176},
    { 888, 224, -176},
    { 872, 224, -176},
    { 856, 224, -184},
    { 856, 232, -184},
    { 848, 232, -176},
    // 71 seconds
    { 840, 248, -200},
    { 816, 256, -192},
    { 808, 256, -200},
    { 840, 264, -192},
    { 880, 280, -176},
    { 904, 312, -168},
    { 912, 320, -176},
    { 888, 304, -192},
    { 832, 288, -232},
    { 800, 280, -240},
    { 848, 280, -208},
    { 856, 288, -192},
    { 848, 264, -168},
    { 872, 272, -152},
    { 896, 272, -160},
    { 896, 288, -176},
    { 896, 296, -160},
    { 888, 296, -152},
    { 896, 296, -168},
    { 896, 296, -176},
    { 880, 312, -176},
    { 888, 312, -184},
    { 880, 304, -176},
    { 880, 296, -168},
    { 872, 296, -144},
    // 72 seconds
    { 848, 280, -128},
    { 856, 280, -120},
    { 848, 264, -112},
    { 888, 280, -104},
    { 904, 272, -112},
    { 912, 296, -112},
    { 880, 344, -144},
    { 840, 360, -144},
    { 832, 416, -176},
    { 912, 440, -160},
    { 864, 392, -136},
    { 864, 408, -128},
    { 872, 416, -112},
    { 904, 552, -64},
    { 896, 640, -64},
    { 864, 632, 16},
    { 800, 736, 40},
    { 720, 760, 232},
    { 680, 680, 256},
    { 608, 720, 208},
    { 568, 720, 216},
    { 504, 640, 208},
    { 384, 664, 200},
    { 352, 808, 208},
    { 296, 616, 96},
    // 73 seconds
    { 184, 704, 264},
    { 200, 736, 344},
    { 144, 856, 296},
    { 104, 888, 376},
    { 152, 680, 264},
    { 72, 720, 176},
    { 56, 632, 248},
    { 0, 848, 448},
    { 48, 944, 472},
    { -32, 1008, 480},
    { -48, 888, 576},
    { -72, 936, 584},
    { -104, 552, 440},
    { -72, 696, 296},
    { -80, 1040, 560},
    { -152, 1016, 520},
    { -168, 1088, 264},
    { -200, 680, 88},
    { -168, 904, -264},
    { -200, 848, -336},
    { -232, 664, -504},
    { -256, 168, -736},
    { -288, 304, -776},
    { -264, 128, -856},
    { -248, 72, -928},
    // 74 seconds
    { -280, 40, -904},
    { -272, 32, -976},
    { -256, 8, -928},
    { -264, 16, -944},
    { -288, 80, -944},
    { -248, 24, -944},
    { -216, 40, -1040},
    { -144, -48, -968},
    { -32, -64, -1056},
    { 0, -112, -1064},
    { 200, -120, -1080},
    { -16, -120, -1040},
    { -48, -104, -1048},
    { -128, -112, -984},
    { -168, -120, -984},
    { -48, -184, -920},
    { -184, -232, -992},
    { -112, -184, -976},
    { -136, -176, -976},
    { -104, -176, -1024},
    { -80, -120, -1048},
    { -80, -168, -976},
    { -144, -152, -952},
    { -144, -128, -952},
    { -120, -112, -952},
    // 75 seconds
    { -120, -112, -1008},
    { -112, -104, -960},
    { -136, -144, -952},
    { -104, -256, -896},
    { -16, -128, -824},
    { 40, 192, -816},
    { -64, 568, -640},
    { -96, 752, -496},
    { -120, 960, -320},
    { -144, 976, 40},
    { -184, 1056, 176},
    { -136, 1024, 264},
    { -112, 856, 328},
    { -96, 776, 328},
    { -48, 752, 352},
    { -32, 792, 344},
    { 8, 808, 392},
    { 16, 816, 392},
    { 8, 824, 408},
    { 40, 808, 416},
    { 72, 864, 424},
    { 104, 840, 400},
    { 160, 832, 408},
    { 168, 848, 392},
    { 232, 864, 328},
    // 76 seconds
    { 272, 880, 272},
    { 344, 808, 264},
    { 360, 800, 168},
    { 440, 672, 104},
    { 504, 744, 16},
    { 568, 672, 16},
    { 624, 752, 8},
    { 680, 632, -48},
    { 720, 712, -64},
    { 728, 712, -32},
    { 728, 664, -120},
    { 720, 712, -128},
    { 720, 616, -136},
    { 736, 552, -160},
    { 744, 536, -184},
    { 800, 480, -168},
    { 1008, 456, -192},
    { 920, 392, -152},
    { 872, 360, -176},
    { 856, 344, -136},
    { 800, 336, -112},
    { 784, 280, -72},
    { 808, 240, 0},
    { 904, 240, 56},
    { 888, 272, 24},
    // 77 seconds
    { 952, 232, -72},
    { 1040, 288, -40},
    { 1088, 248, -56},
    { 1240, 312, 8},
    { 1152, 288, -64},
    { 912, 216, -88},
    { 784, 168, -128},
    { 736, 184, -208},
    { 960, 184, -264},
    { 1144, 216, -272},
    { 976, 208, -224},
    { 768, 200, -200},
    { 624, 192, -152},
    { 544, 208, -112},
    { 536, 216, -104},
    { 648, 272, -112},
    { 840, 336, -128},
    { 1072, 400, -64},
    { 1112, 440, -112},
    { 1160, 440, -112},
    { 1320, 472, -96},
    { 1088, 376, -136},
    { 976, 360, -120},
    { 1048, 368, -192},
    { 1080, 448, -56},
    // 78 seconds
    { 968, 472, -96},
    { 776, 448, -112},
    { 384, 384, -192},
    { 352, 352, -224},
    { 384, 352, -168},
    { 480, 280, -144},
    { 696, 272, -120},
    { 968, 312, -160},
    { 1176, 328, -144},
    { 1104, 304, -168},
    { 1208, 328, -136},
    { 1056, 256, -24},
    { 1024, 240, 8},
    { 1248, 288, -56},
    { 1224, 320, -40},
    { 928, 312, -88},
    { 616, 184, -40},
    { 488, 216, -112},
    { 424, 256, -80},
    { 472, 264, -64},
    { 648, 320, -88},
    { 896, 400, -120},
    { 1104, 448, -120},
    { 1096, 472, -176},
    { 1040, 440, -152},
    // 79 seconds
    { 1120, 440, -176},
    { 1112, 464, -152},
    { 1224, 432, -136},
    { 1256, 392, -104},
    { 1080, 344, -32},
    { 896, 272, -56},
    { 736, 192, -48},
    { 720, 208, -40},
    { 760, 200, -32},
    { 832, 160, -8},
    { 872, 176, 8},
    { 928, 168, -8},
    { 1040, 224, -88},
    { 992, 120, -256},
    { 1152, 128, -232},
    { 1128, 96, -104},
    { 1288, 192, -160},
    { 1368, 272, -104},
    { 1168, 256, -72},
    { 840, 200, -64},
    { 568, 208, -120},
    { 368, 152, -88},
    { 392, 288, -144},
    { 496, 352, -208},
    { 800, 408, -136},
    // 80 seconds
    { 1128, 528, -152},
    { 1192, 576, -136},
    { 1168, 584, -136},
    { 1200, 504, -8},
    { 984, 504, -96},
    { 1128, 440, -80},
    { 1312, 448, 0},
    { 1304, 336, -8},
    { 1056, 288, 16},
    { 784, 232, -40},
    { 656, 128, -64},
    { 560, 72, -8},
    { 704, 16, -24},
    { 816, 40, -64},
    { 1040, 48, -48},
    { 1208, 40, -88},
    { 1176, 0, -128},
    { 1232, 104, -168},
    { 1208, 136, -88},
    { 1136, 176, -104},
    { 1272, 216, -128},
    { 1264, 264, -112},
    { 976, 256, -152},
    { 608, 232, -200},
    { 384, 128, -144},
    // 81 seconds
    { 344, 168, -104},
    { 456, 208, -96},
    { 696, 248, -144},
    { 1000, 368, -192},
    { 1128, 480, -240},
    { 1160, 504, -248},
    { 1264, 480, -176},
    { 1176, 472, -136},
    { 1128, 416, -104},
    { 1216, 424, -88},
    { 1208, 392, -72},
    { 1016, 288, -64},
    { 752, 256, -80},
    { 608, 160, -64},
    { 592, 200, -104},
    { 680, 192, -96},
    { 792, 160, -40},
    { 912, 136, -16},
    { 1104, 120, -80},
    { 1128, 152, -24},
    { 1072, 144, -96},
    { 1160, 200, -152},
    { 1096, 168, -88},
    { 1272, 208, -128},
    { 1336, 256, -152},
    // 82 seconds
    { 1120, 256, -104},
    { 768, 224, -176},
    { 504, 208, -176},
    { 408, 200, -184},
    { 424, 192, -120},
    { 560, 224, -160},
    { 832, 256, -192},
    { 1144, 384, -264},
    { 1112, 384, -296},
    { 1136, 360, -224},
    { 1224, 392, -224},
    { 1112, 416, -208},
    { 1200, 440, -152},
    { 1216, 384, -96},
    { 1152, 304, -40},
    { 968, 288, -40},
    { 752, 232, -16},
    { 608, 224, -32},
    { 656, 176, -112},
    { 696, 112, -16},
    { 760, 168, -24},
    { 912, 208, -72},
    { 1048, 184, -24},
    { 1112, 216, -48},
    { 984, 168, -144},
    // 83 seconds
    { 1120, 224, -88},
    { 1144, 184, -40},
    { 1240, 248, -120},
    { 1256, 304, -184},
    { 1072, 264, -152},
    { 752, 256, -176},
    { 496, 184, -280},
    { 464, 144, -112},
    { 456, 208, -152},
    { 576, 264, -120},
    { 792, 368, -152},
    { 1072, 480, -168},
    { 1056, 520, -152},
    { 1120, 480, -152},
    { 1216, 504, -144},
    { 1104, 456, -128},
    { 1160, 400, -32},
    { 1256, 376, -16},
    { 1136, 320, -32},
    { 880, 248, -32},
    { 704, 224, -48},
    { 624, 192, -96},
    { 696, 144, -56},
    { 792, 128, 0},
    { 888, 160, -16},
    // 84 seconds
    { 928, 168, 16},
    { 1040, 192, -32},
    { 1024, 232, -80},
    { 992, 208, -200},
    { 1056, 144, -96},
    { 1088, 128, 48},
    { 1256, 168, 8},
    { 1328, 264, -152},
    { 1112, 336, -200},
    { 728, 272, -208},
    { 496, 184, -200},
    { 424, 184, -232},
    { 504, 240, -64},
    { 680, 192, -96},
    { 888, 312, -176},
    { 1072, 312, -224},
    { 1088, 296, -312},
    { 1144, 280, -264},
    { 1232, 304, -224},
    { 1408, 120, -440},
    { 800, -432, -336},
    { 1024, -696, -344},
    { 1648, 480, 32},
    { 1224, 1200, 152},
    { 560, 1072, 48},
    // 85 seconds
    { 976, 968, 104},
    { 984, 24, -184},
    { 816, 352, -80},
    { 872, 176, -136},
    { 952, 168, -32},
    { 1088, 192, -56},
    { 1064, 88, -88},
    { 1160, 160, -184},
    { 1128, 168, -72},
    { 1120, 144, -48},
    { 1272, 232, -120},
    { 1304, 256, -136},
    { 1040, 280, -152},
    { 712, 224, -136},
    { 512, 200, -136},
    { 456, 216, -120},
    { 528, 200, -160},
    { 600, 192, -88},
    { 832, 264, -160},
    { 992, 296, -192},
    { 1160, 360, -256},
    { 1344, 360, -216},
    { 1296, 416, -224},
    { 1048, 368, -192},
    { 1104, 368, -176},
    // 86 seconds
    { 1176, 336, -152},
    { 1136, 304, -104},
    { 936, 320, -88},
    { 808, 208, -120},
    { 736, 208, -48},
    { 792, 240, -72},
    { 872, 176, -40},
    { 832, 120, 8},
    { 880, 112, 16},
    { 896, 64, -8},
    { 944, 152, -88},
    { 992, 168, -160},
    { 1120, 216, -168},
    { 1096, 192, -80},
    { 1232, 288, -64},
    { 1376, 336, -120},
    { 1168, 344, -184},
    { 856, 280, -160},
    { 624, 232, -184},
    { 520, 248, -176},
    { 512, 152, -120},
    { 632, 200, -88},
    { 752, 264, -160},
    { 992, 296, -144},
    { 1048, 328, -208},
    // 87 seconds
    { 1048, 328, -224},
    { 1272, 360, -192},
    { 1216, 376, -208},
    { 1080, 360, -168},
    { 1136, 352, -136},
    { 1216, 360, -104},
    { 1112, 280, -40},
    { 896, 256, -56},
    { 744, 200, -48},
    { 712, 208, -64},
    { 752, 152, -48},
    { 800, 144, -16},
    { 824, 144, -24},
    { 888, 144, -16},
    { 1048, 168, -16},
    { 1000, 160, -8},
    { 1136, 216, -64},
    { 1168, 264, -72},
    { 1112, 216, -136},
    { 1224, 320, -216},
    { 1168, 264, -256},
    { 920, 288, -368},
    { 680, 472, -480},
    { 576, 280, -528},
    { 560, 384, -496},
    // 88 seconds
    { 632, 352, -440},
    { 704, 184, -544},
    { 736, 224, -448},
    { 792, 120, -576},
    { 704, 64, -496},
    { 1768, 1536, -464},
    { 192, 192, -672},
    { 1376, 648, -544},
    { 944, 480, -856},
    { 1056, 416, -712},
    { 776, 360, -584},
    { 464, 472, -488},
    { 464, -16, -368},
    { 584, -8, -256},
    { 1072, -56, -472},
    { 1104, 392, -424},
    { -304, 96, -400},
    { 576, 160, -416},
    { 512, 192, -424},
    { 480, 432, -600},
    { 440, 472, -616},
    { 480, 208, -688},
    { 488, 304, -688},
    { 600, 328, -680},
    { 704, 312, -632},
    // 89 seconds
    { 768, 72, -576},
    { 824, 200, -480},
    { 848, 168, -480},
    { 1008, 256, -304},
    { 992, 40, -200},
    { 1088, 88, -160},
    { 1152, 168, -224},
    { 1232, 168, -160},
    { 1208, 176, -144},
    { 1000, 224, -184},
    { 752, 200, -168},
    { 616, 104, -192},
    { 576, 104, -112},
    { 640, 184, -104},
    { 784, 264, -72},
    { 952, 320, -136},
    { 1056, 304, -232},
    { 1024, 288, -296},
    { 1048, 296, -304},
    { 1320, 328, -248},
    { 1456, 360, -296},
    { 1104, 328, -216},
    { 872, 288, -120},
    { 904, 288, -112},
    { 912, 272, -152},
    // 90 seconds
    { 920, 208, -80},
    { 912, 208, -80},
    { 920, 200, -64},
    { 904, 184, -64},
    { 880, 136, -56},
    { 832, 80, -32},
    { 864, 16, -40},
    { 968, 24, -96},
    { 1008, 32, -168},
    { 1152, -32, -152},
    { 1280, 40, -128},
    { 1256, 128, -80},
    { 1248, 144, -144},
    { 1256, 176, -168},
    { 1064, 184, -184},
    { 760, 184, -176},
    { 552, 200, -192},
    { 480, 168, -136},
    { 544, 192, -56},
    { 712, 320, -80},
    { 960, 344, -176},
    { 1104, 352, -248},
    { 1056, 384, -344},
    { 1048, 344, -272},
    { 1344, 376, -216},
    // 91 seconds
    { 1144, 368, -192},
    { 1080, 328, -168},
    { 1112, 328, -120},
    { 1224, 312, -96},
    { 1152, 240, -32},
    { 864, 208, -16},
    { 680, 184, -56},
    { 696, 176, -56},
    { 792, 152, -24},
    { 840, 104, -16},
    { 872, 48, -32},
    { 1040, 48, -72},
    { 1088, 40, -56},
    { 1216, 96, -120},
    { 1248, 112, -48},
    { 1176, 176, -80},
    { 1216, 200, -160},
    { 1280, 200, -120},
    { 1104, 248, -144},
    { 768, 256, -144},
    { 512, 200, -136},
    { 448, 168, -112},
    { 504, 168, -128},
    { 648, 152, -120},
    { 840, 240, -192},
    // 92 seconds
    { 1072, 304, -280},
    { 1136, 352, -320},
    { 1184, 312, -256},
    { 1272, 408, -256},
    { 1144, 416, -256},
    { 1136, 376, -168},
    { 1144, 344, -136},
    { 1208, 312, -80},
    { 1080, 264, -40},
    { 816, 216, -8},
    { 672, 208, -16},
    { 632, 192, 0},
    { 696, 144, 24},
    { 816, 112, 8},
    { 936, 120, 8},
    { 1008, 128, -16},
    { 1072, 104, -16},
    { 1128, 128, -88},
    { 1232, 112, -104},
    { 1128, 160, -72},
    { 1216, 208, -136},
    { 1304, 256, -144},
    { 1136, 264, -168},
    { 800, 240, -168},
    { 544, 192, -160},
    // 93 seconds
    { 448, 184, -136},
    { 472, 184, -152},
    { 584, 168, -104},
    { 760, 208, -200},
    { 992, 240, -248},
    { 1112, 272, -296},
    { 1192, 304, -288},
    { 1376, 384, -248},
    { 1192, 392, -240},
    { 1112, 384, -160},
    { 1152, 360, -152},
    { 1152, 312, -88},
    { 1024, 288, -48},
    { 824, 224, -40},
    { 704, 184, -24},
    { 656, 208, -24},
    { 744, 208, 16},
    { 864, 168, 72},
    { 960, 64, 88},
    { 968, 56, 32},
    { 1064, 72, -72},
    { 1144, 56, -96},
    { 1264, 232, -88},
    { 1144, 48, -136},
    { 1240, 88, -136},
    // 94 seconds
    { 1280, 56, -200},
    { 1048, 200, -312},
    { 736, 128, -248},
    { 544, 64, -240},
    { 512, 144, -288},
    { 536, 200, -216},
    { 584, 160, -272},
    { 784, 176, -208},
    { 976, 256, -280},
    { 1136, 344, -312},
    { 1168, 352, -304},
    { 1288, 296, -200},
    { 1128, 368, -232},
    { 1128, 336, -152},
    { 1208, 344, -120},
    { 1192, 304, -104},
    { 1032, 256, -88},
    { 784, 224, -72},
    { 688, 184, -56},
    { 728, 176, -104},
    { 768, 144, -40},
    { 824, 56, 0},
    { 920, -24, -16},
    { 968, 72, -104},
    { 1016, 72, -160},
    // 95 seconds
    { 1184, 104, -136},
    { 1240, 184, -104},
    { 1136, 176, -80},
    { 1264, 232, -80},
    { 1288, 232, -136},
    { 1080, 280, -168},
    { 744, 232, -184},
    { 520, 184, -176},
    { 448, 160, -144},
    { 520, 160, -128},
    { 680, 256, -168},
    { 856, 240, -232},
    { 1016, 336, -360},
    { 984, 360, -352},
    { 1112, 352, -248},
    { 1392, 416, -216},
    { 1120, 368, -160},
    { 1128, 344, -80},
    { 1160, 344, -96},
    { 1168, 304, -72},
    { 1000, 272, -56},
    { 808, 192, -32},
    { 672, 168, -40},
    { 704, 160, -56},
    { 744, 144, -32},
    // 96 seconds
    { 816, 112, -32},
    { 968, 128, -40},
    { 1088, 144, -40},
    { 1048, 120, -48},
    { 1192, 144, -72},
    { 1224, 176, -64},
    { 1088, 184, -104},
    { 1208, 208, -136},
    { 1224, 192, -128},
    { 1032, 232, -168},
    { 744, 216, -152},
    { 576, 232, -160},
    { 496, 184, -176},
    { 568, 184, -136},
    { 704, 240, -184},
    { 848, 240, -168},
    { 1056, 312, -256},
    { 1056, 320, -288},
    { 1136, 320, -232},
    { 1344, 376, -232},
    { 1144, 376, -208},
    { 1096, 352, -152},
    { 1128, 336, -112},
    { 1144, 304, -72},
    { 1048, 280, -40},
    // 97 seconds
    { 832, 216, -24},
    { 728, 176, -40},
    { 744, 192, -32},
    { 752, 152, 0},
    { 832, 128, -8},
    { 888, 144, 0},
    { 1024, 144, -16},
    { 1032, 112, -8},
    { 1216, 144, -56},
    { 1264, 160, -24},
    { 1184, 152, -128},
    { 1224, 104, -120},
    { 1248, 128, -56},
    { 1032, 216, -96},
    { 752, 232, -96},
    { 568, 208, -144},
    { 544, 208, -112},
    { 608, 184, -120},
    { 752, 216, -144},
    { 872, 256, -224},
    { 1016, 304, -288},
    { 1032, 336, -336},
    { 1120, 352, -296},
    { 1336, 400, -248},
    { 1120, 424, -240},
    // 98 seconds
    { 1128, 392, -184},
    { 1224, 352, -152},
    { 1224, 304, -104},
    { 1072, 248, -64},
    { 840, 216, -56},
    { 752, 184, -40},
    { 744, 144, -40},
    { 800, 160, 0},
    { 872, 136, -8},
    { 912, 80, -8},
    { 1032, 104, -48},
    { 1000, 80, -56},
    { 1072, 80, -128},
    { 1056, 144, -136},
    { 1040, 144, -64},
    { 1200, 224, -104},
    { 1328, 256, -144},
    { 1160, 264, -136},
    { 848, 248, -136},
    { 624, 208, -120},
    { 552, 184, -112},
    { 536, 216, -88},
    { 640, 280, -96},
    { 856, 320, -192},
    { 1104, 408, -216},
    // 99 seconds
    { 1128, 400, -280},
    { 1144, 400, -208},
    { 1288, 488, -184},
    { 1072, 496, -152},
    { 1120, 416, -120},
    { 1192, 376, -80},
    { 1200, 336, -24},
    { 984, 272, 16},
    { 792, 224, -8},
    { 704, 176, 16},
    { 712, 176, 16},
    { 800, 168, 48},
    { 880, 184, 24},
    { 968, 144, 24},
    { 1040, 152, 24},
    { 1048, 120, -16},
    { 1120, 128, -88},
    { 1200, 112, -88},
    { 1176, 80, -80},
    { 1200, 128, -136},
    { 1264, 160, -136},
    { 1096, 232, -136},
    { 800, 240, -184},
    { 568, 200, -184},
    { 512, 192, -152},
    // 100 seconds
    { 560, 184, -136},
    { 696, 216, -160},
    { 832, 264, -216},
    { 992, 296, -288},
    { 1128, 320, -344},
    { 1024, 312, -312},
    { 1296, 360, -240},
    { 1232, 400, -264},
    { 1064, 360, -208},
    { 1192, 360, -112},
    { 1232, 352, -72},
    { 1184, 296, 0},
    { 928, 224, 16},
    { 736, 200, -32},
    { 680, 176, -40},
    { 720, 160, -8},
    { 824, 168, -24},
    { 912, 160, -32},
    { 1088, 144, -88},
    { 1072, 136, -80},
    { 1040, 56, -96},
    { 1160, 96, -80},
    { 1160, 112, -64},
    { 1056, 152, -120},
    { 1184, 192, -160},
    // 101 seconds
    { 1280, 240, -104},
    { 1104, 240, -120},
    { 792, 240, -112},
    { 600, 216, -96},
    { 544, 176, -168},
    { 616, 160, -72},
    { 800, 248, -112},
    { 1040, 280, -176},
    { 1208, 360, -288},
    { 1120, 376, -320},
    { 1224, 384, -272},
    { 1224, 448, -288},
    { 992, 400, -240},
    { 1120, 360, -160},
    { 1144, 344, -128},
    { 1120, 280, -88},
    { 1048, 264, -40},
    { 952, 232, -8},
    { 896, 184, -32},
    { 832, 160, -8},
    { 872, 176, -32},
    { 864, 184, 0},
    { 920, 112, 0},
    { 976, 88, -8},
    { 952, 32, -8},
    // 102 seconds
    { 944, 64, -48},
    { 1080, 136, -88},
    { 1184, 144, -8},
    { 1240, 200, -72},
    { 1392, 248, -56},
    { 1288, 280, -112},
    { 976, 288, -160},
    { 656, 224, -152},
    { 568, 152, -248},
    { 584, 136, -152},
    { 680, 192, -64},
    { 816, 352, -112},
    { 1024, 352, -168},
    { 1088, 392, -248},
    { 1120, 376, -200},
    { 1216, 400, -176},
    { 1096, 432, -200},
    { 1128, 392, -104},
    { 1280, 360, 8},
    { 1280, 312, -16},
    { 1120, 288, -16},
    { 840, 256, -64},
    { 736, 216, -56},
    { 720, 192, -8},
    { 816, 184, 56},
    // 103 seconds
    { 928, 160, 80},
    { 1072, 160, 112},
    { 1072, 128, 32},
    { 944, 64, -24},
    { 1160, 88, -96},
    { 1232, 112, -32},
    { 1112, 160, -144},
    { 1184, 136, -232},
    { 1288, 240, -184},
    { 1176, 216, -200},
    { 880, 192, -160},
    { 632, 184, -264},
    { 504, 160, -112},
    { 520, 152, -96},
    { 648, 232, -88},
    { 896, 288, -96},
    { 1072, 376, -152},
    { 1080, 376, -248},
    { 1000, 360, -304},
    { 1296, 376, -240},
    { 1232, 408, -264},
    { 1080, 376, -216},
    { 1096, 368, -216},
    { 1192, 312, -136},
    { 1104, 264, -80},
    // 104 seconds
    { 912, 200, -64},
    { 776, 152, -96},
    { 728, 192, -56},
    { 792, 184, -48},
    { 808, 160, -16},
    { 904, 96, -8},
    { 1024, 80, 8},
    { 1072, 80, 24},
    { 1120, 120, -32},
    { 1136, 144, 0},
    { 1104, 144, -8},
    { 1312, 176, -72},
    { 1392, 240, -120},
    { 1096, 208, -224},
    { 752, 232, -232},
    { 560, 216, -232},
    { 520, 200, -272},
    { 592, 168, -168},
    { 720, 224, -200},
    { 904, 288, -208},
    { 1104, 352, -280},
    { 1032, 360, -288},
    { 1064, 312, -200},
    { 1280, 384, -216},
    { 1120, 368, -176},
    // 105 seconds
    { 1136, 344, -112},
    { 1216, 352, -104},
    { 1216, 320, -56},
    { 1040, 256, -56},
    { 824, 192, -48},
    { 704, 184, -48},
    { 712, 176, -48},
    { 808, 184, -32},
    { 888, 136, 0},
    { 960, 56, 24},
    { 1040, 32, -8},
    { 1024, 48, -32},
    { 1128, 88, -48},
    { 1216, 144, -48},
    { 1176, 152, 8},
    { 1224, 208, -80},
    { 1352, 256, -96},
    { 1200, 256, -168},
    { 824, 248, -200},
    { 528, 192, -184},
    { 456, 192, -200},
    { 488, 152, -88},
    { 648, 176, -88},
    { 848, 248, -144},
    { 1048, 296, -192},
    // 106 seconds
    { 1080, 328, -264},
    { 1096, 336, -216},
    { 1232, 360, -208},
    { 1080, 392, -216},
    { 1008, 328, -168},
    { 1160, 352, -160},
    { 1240, 328, -144},
    { 1200, 304, -72},
    { 992, 240, -64},
    { 824, 184, -40},
    { 720, 160, -32},
    { 760, 120, -80},
    { 840, 104, -88},
    { 872, 104, 16},
    { 944, 48, -56},
    { 960, 72, -56},
    { 984, 96, -80},
    { 1160, 152, -40},
    { 1224, 208, 8},
    { 1144, 200, -64},
    { 1376, 224, -88},
    { 1320, 248, -80},
    { 1016, 264, -128},
    { 680, 232, -136},
    { 536, 192, -168},
    // 107 seconds
    { 520, 144, -144},
    { 600, 176, -48},
    { 728, 216, -104},
    { 840, 344, -176},
    { 992, 424, -232},
    { 1088, 464, -224},
    { 1408, 472, -208},
    { 1352, 472, -184},
    { 1208, 360, -112},
    { 1256, 272, -120},
    { 1184, 272, -56},
    { 1008, 280, -80},
    { 808, 240, -32},
    { 616, 184, -40},
    { 560, 152, -8},
    { 616, 152, -8},
    { 720, 152, -8},
    { 896, 144, -24},
    { 1048, 128, -32},
    { 1128, 144, 8},
    { 1328, 168, 16},
    { 1392, 208, 56},
    { 1160, 216, -88},
    { 1376, 192, -96},
    { 1312, 216, -64},
    // 108 seconds
    { 1008, 216, -152},
    { 632, 192, -152},
    { 464, 192, -176},
    { 408, 168, -160},
    { 472, 136, -120},
    { 624, 224, -152},
    { 848, 272, -232},
    { 968, 360, -376},
    { 1072, 400, -328},
    { 1200, 440, -296},
    { 1832, 632, -232},
    { 1328, 464, -24},
    { 1256, 296, -8},
    { 1312, 280, -96},
    { 1096, 288, -72},
    { 808, 192, 8},
    { 672, 152, 24},
    { 656, 136, 48},
    { 752, 112, 56},
    { 880, 112, 8},
    { 960, 112, 8},
    { 1160, 112, -24},
    { 1184, 104, 16},
    { 1256, 120, -64},
    { 1224, 144, 24},
    // 109 seconds
    { 1176, 184, 16},
    { 1320, 240, -104},
    { 1288, 240, -104},
    { 1032, 208, -152},
    { 688, 184, -168},
    { 480, 152, -184},
    { 416, 128, -176},
    { 464, 56, -96},
    { 688, 136, -112},
    { 1024, 256, -144},
    { 1416, 336, -184},
    { 1240, 384, -248},
    { 1296, 336, -216},
    { 1192, 384, -224},
    { 1008, 360, -168},
    { 1040, 320, -120},
    { 1136, 304, -104},
    { 1072, 272, -48},
    { 896, 232, -40},
    { 784, 192, -40},
    { 728, 128, -24},
    { 736, 160, -16},
    { 856, 152, 16},
    { 944, 120, 24},
    { 1128, 136, -24},
    // 110 seconds
    { 1112, 152, -40},
    { 1128, 96, -48},
    { 1248, 136, -96},
    { 1192, 96, -16},
    { 1216, 88, -56},
    { 1272, 136, -56},
    { 1144, 160, -88},
    { 856, 192, -136},
    { 616, 144, -160},
    { 520, 128, -128},
    { 480, 144, -144},
    { 568, 160, -80},
    { 752, 208, -120},
    { 1056, 296, -160},
    { 1200, 304, -248},
    { 1136, 320, -224},
    { 1392, 384, -192},
    { 1224, 456, -192},
    { 1024, 368, -128},
    { 1032, 360, -144},
    { 1120, 360, -128},
    { 1088, 280, -80},
    { 904, 192, -64},
    { 720, 184, -56},
    { 656, 152, -72},
    // 111 seconds
    { 720, 152, -48},
    { 824, 168, -16},
    { 944, 120, 0},
    { 1072, 72, -16},
    { 1064, -24, -16},
    { 1048, 24, 8},
    { 1280, 104, -16},
    { 1216, 56, 80},
    { 1120, 56, 48},
    { 1336, 144, 16},
    { 1240, 200, -48},
    { 936, 208, -88},
    { 640, 168, -144},
    { 520, 136, -120},
    { 496, 128, -120},
    { 592, 160, -120},
    { 776, 224, -184},
    { 1024, 264, -184},
    { 1160, 296, -272},
    { 1152, 320, -248},
    { 1304, 352, -216},
    { 1152, 384, -232},
    { 1040, 352, -192},
    { 1184, 328, -144},
    { 1208, 288, -80},
    // 112 seconds
    { 1128, 264, -40},
    { 960, 192, -24},
    { 792, 128, 0},
    { 752, 144, -24},
    { 776, 192, -24},
    { 832, 176, 0},
    { 848, 144, 16},
    { 984, 112, -16},
    { 1072, 104, -40},
    { 1024, 72, -48},
    { 1184, 128, -80},
    { 1096, 104, -8},
    { 1208, 112, -72},
    { 1360, 168, -96},
    { 1256, 184, -104},
    { 960, 184, -104},
    { 696, 208, -120},
    { 584, 184, -176},
    { 584, 160, -88},
    { 704, 192, -96},
    { 808, 248, -152},
    { 1024, 360, -144},
    { 1136, 448, -224},
    { 1176, 496, -256},
    { 1304, 512, -192},
    // 113 seconds
    { 1152, 496, -176},
    { 1048, 360, -128},
    { 1168, 344, -88},
    { 1272, 312, -40},
    { 1176, 248, 24},
    { 944, 160, 40},
    { 792, 128, -8},
    { 784, 152, -8},
    { 832, 136, 40},
    { 840, 112, 56},
    { 776, 120, 16},
    { 888, 192, -48},
    { 992, 88, 16},
    { 944, 40, -24},
    { 1272, 56, -88},
    { 1200, 40, 32},
    { 1304, 136, -56},
    { 1384, 232, -112},
    { 1200, 248, -80},
    { 928, 216, -80},
    { 672, 184, -112},
    { 600, 160, -112},
    { 592, 168, -112},
    { 688, 152, -40},
    { 784, 304, -208},
    // 114 seconds
    { 960, 368, -208},
    { 1128, 488, -264},
    { 1168, 552, -200},
    { 1000, 352, -192},
    { 1128, 456, -216},
    { 1232, 552, -144},
    { 1400, 472, -40},
    { 1400, 288, 80},
    { 1256, 232, 80},
    { 976, 224, 24},
    { 792, 160, 40},
    { 736, 144, 8},
    { 856, 136, 32},
    { 936, 80, 40},
    { 1000, 40, 40},
    { 1160, 24, -32},
    { 1112, -8, 24},
    { 992, -56, -48},
    { 1224, 64, -48},
    { 1296, 24, 136},
    { 1448, 256, -24},
    { 1536, 256, -136},
    { 1208, 280, -168},
    { 760, 192, -128},
    { 544, 184, -200},
    // 115 seconds
    { 456, 152, -88},
    { 528, 200, -120},
    { 784, 184, -72},
    { 1168, 256, -120},
    { 1440, 472, -104},
    { 1368, 520, -96},
    { 1248, 568, -88},
    { 1136, 456, -80},
    { 1040, 400, -32},
    { 1000, 352, -40},
    { 1136, 296, 0},
    { 1048, 264, 56},
    { 848, 176, 32},
    { 672, 120, -16},
    { 696, 88, 88},
    { 800, 168, 136},
    { 960, 152, 144},
    { 1152, 136, 152},
    { 1240, 144, 112},
    { 1184, 120, -8},
    { 1320, 104, -8},
    { 1280, 120, 16},
    { 1144, 136, -80},
    { 1136, 120, -40},
    { 1160, 128, -88},
    // 116 seconds
    { 1048, 168, -144},
    { 808, 168, -192},
    { 560, 64, -232},
    { 440, 24, -40},
    { 408, 200, -168},
    { 512, 192, -80},
    { 808, 240, -112},
    { 1128, 224, -136},
    { 1224, 288, -120},
    { 1176, 408, -104},
    { 1336, 448, -104},
    { 1144, 472, -120},
    { 1032, 400, -48},
    { 1048, 344, -24},
    { 1128, 336, 16},
    { 1040, 264, 32},
    { 904, 216, 32},
    { 752, 64, -56},
    { 696, 208, 16},
    { 744, 144, 32},
    { 808, 104, 40},
    { 896, 120, 16},
    { 1056, 128, -32},
    { 1096, 136, -8},
    { 1040, 96, -88},
    // 117 seconds
    { 1232, 88, -16},
    { 1184, 112, -8},
    { 1144, 168, -24},
    { 1288, 264, -96},
    { 1248, 272, -144},
    { 912, 264, -120},
    { 576, 208, -224},
    { 440, 168, -64},
    { 424, 192, -152},
    { 536, 160, -56},
    { 752, 192, -136},
    { 984, 224, -112},
    { 1128, 288, -192},
    { 1056, 312, -248},
    { 1184, 304, -160},
    { 1336, 376, -184},
    { 1072, 392, -152},
    { 1064, 384, -112},
    { 1136, 344, -64},
    { 1136, 256, -56},
    { 952, 272, -24},
    { 760, 192, -72},
    { 688, 168, -56},
    { 688, 160, -40},
    { 760, 176, -16},
    // 118 seconds
    { 888, 160, -32},
    { 976, 16, 40},
    { 1096, 96, 0},
    { 1088, 112, -80},
    { 1144, 56, -56},
    { 1176, 136, -80},
    { 1128, 152, -56},
    { 1184, 152, -80},
    { 1248, 208, -120},
    { 1112, 232, -152},
    { 816, 208, -200},
    { 552, 192, -152},
    { 488, 160, -112},
    { 512, 184, -128},
    { 648, 208, -152},
    { 848, 224, -152},
    { 1104, 288, -192},
    { 1080, 352, -288},
    { 1040, 320, -240},
    { 1304, 376, -208},
    { 1216, 368, -208},
    { 1008, 312, -120},
    { 1056, 336, -136},
    { 1144, 312, -112},
    { 1072, 272, -56},
    // 119 seconds
    { 888, 200, -48},
    { 776, 64, -72},
    { 728, 232, -16},
    { 792, 176, -48},
    { 904, 136, -48},
    { 936, 112, -8},
    { 1032, 64, -32},
    { 1056, 96, 0},
    { 1048, 88, -64},
    { 1160, 200, -64},
    { 1128, 176, -40},
    { 1176, 152, -56},
    { 1320, 232, -88},
    { 1224, 256, -144},
    { 912, 248, -160},
    { 584, 224, -208},
    { 456, 184, -152},
    { 480, 184, -136},
    { 624, 192, -144},
    { 824, 224, -176},
    { 1064, 272, -232},
    { 1048, 296, -280},
    { 952, 272, -232},
    { 1224, 344, -168},
    { 1352, 448, -208},
    // 120 seconds
    // elapsed: 2 minutes
    { 1144, 352, -72},
    { 1096, 328, -80},
    { 1136, 320, -72},
    { 1096, 288, -32},
    { 864, 208, -16},
    { 712, 136, -16},
    { 680, 168, -32},
    { 768, 176, -24},
    { 896, 152, -16},
    { 976, 64, 40},
    { 1120, 96, 0},
    { 1048, 88, -8},
    { 1168, 120, -16},
    { 1208, 104, 0},
    { 1160, 128, -8},
    { 1104, 120, -64},
    { 1208, 184, -72},
    { 1152, 200, -136},
    { 912, 208, -144},
    { 672, 144, -248},
    { 504, 144, -72},
    { 496, 144, -184},
    { 592, 168, -120},
    { 768, 216, -160},
    { 976, 256, -160},
    // 121 seconds
    { 1104, 288, -232},
    { 1024, 304, -312},
    { 1080, 280, -232},
    { 1312, 360, -232},
    { 1080, 336, -200},
    { 1040, 320, -136},
    { 1128, 312, -104},
    { 1136, 312, -80},
    { 1064, 256, -64},
    { 888, 184, -88},
    { 824, 80, -88},
    { 712, 240, 0},
    { 768, 104, -56},
    { 816, 128, -24},
    { 880, 64, -48},
    { 1048, 88, -56},
    { 976, 88, -64},
    { 1128, 152, -112},
    { 1208, 160, -104},
    { 1152, 144, -88},
    { 1152, 152, -104},
    { 1232, 200, -136},
    { 1152, 232, -192},
    { 888, 216, -136},
    { 656, 200, -120},
    // 122 seconds
    { 544, 200, -152},
    { 536, 168, -144},
    { 648, 152, -128},
    { 760, 208, -160},
    { 920, 344, -184},
    { 1024, 400, -248},
    { 1032, 360, -248},
    { 1200, 352, -176},
    { 1240, 408, -192},
    { 992, 360, -128},
    { 1064, 352, -112},
    { 1128, 336, -96},
    { 1144, 304, -80},
    { 1032, 240, -32},
    { 880, 200, -40},
    { 768, 184, -48},
    { 784, 176, -24},
    { 856, 216, -24},
    { 856, 160, -32},
    { 984, 136, -48},
    { 1008, 96, -16},
    { 992, 72, -48},
    { 1152, 152, -120},
    { 1160, 152, -80},
    { 1008, 144, -104},
    // 123 seconds
    { 1168, 184, -112},
    { 1200, 216, -136},
    { 1040, 216, -128},
    { 784, 216, -96},
    { 616, 192, -136},
    { 568, 208, -176},
    { 648, 208, -104},
    { 824, 184, -88},
    { 952, 280, -128},
    { 1128, 368, -248},
    { 1144, 448, -272},
    { 1224, 464, -232},
    { 1200, 480, -224},
    { 1016, 424, -224},
    { 1064, 384, -168},
    { 1160, 360, -128},
    { 1176, 304, -88},
    { 1080, 248, -48},
    { 896, 216, -32},
    { 776, 176, -32},
    { 776, 144, -16},
    { 848, 208, -32},
    { 960, 144, -88},
    { 992, 64, 64},
    { 992, 40, 16},
    // 124 seconds
    { 1064, 56, -32},
    { 1232, 72, -16},
    { 1240, 120, -16},
    { 1080, 104, -48},
    { 1232, 168, -96},
    { 1240, 200, -128},
    { 1024, 208, -96},
    { 736, 240, -136},
    { 536, 184, -200},
    { 568, 136, -112},
    { 648, 184, -112},
    { 784, 264, -120},
    { 984, 368, -184},
    { 1136, 488, -232},
    { 1192, 536, -216},
    { 1272, 520, -168},
    { 1216, 520, -208},
    { 1040, 440, -152},
    { 1072, 400, -96},
    { 1184, 344, -56},
    { 1184, 280, 0},
    { 1016, 200, -8},
    { 864, 176, 16},
    { 824, 176, -32},
    { 840, 208, 0},
    // 125 seconds
    { 896, 144, 8},
    { 880, 96, 32},
    { 944, 88, -32},
    { 1008, 72, -72},
    { 976, 8, -104},
    { 1176, 80, -104},
    { 1096, 64, -128},
    { 1064, 152, -120},
    { 1232, 224, -176},
    { 1264, 248, -168},
    { 1080, 264, -160},
    { 840, 264, -176},
    { 640, 208, -176},
    { 576, 240, -72},
    { 608, 280, -64},
    { 728, 304, -56},
    { 904, 312, -72},
    { 1080, 360, -168},
    { 1072, 392, -208},
    { 1136, 416, -200},
    { 1280, 480, -168},
    { 1048, 432, -160},
    { 1056, 360, -112},
    { 1184, 352, -80},
    { 1240, 304, -8},
    // 126 seconds
    { 1088, 248, 16},
    { 864, 168, 8},
    { 744, 176, -16},
    { 784, 192, 0},
    { 792, 168, 8},
    { 888, 96, 56},
    { 1016, 48, 40},
    { 1104, 64, 8},
    { 1040, 8, -16},
    { 1224, 96, -104},
    { 1280, 56, -16},
    { 1160, 144, -88},
    { 1280, 224, -144},
    { 1336, 240, -168},
    { 1096, 256, -192},
    { 728, 216, -232},
    { 512, 208, -200},
    { 456, 144, -136},
    { 536, 168, -96},
    { 728, 264, -184},
    { 920, 304, -208},
    { 1104, 344, -272},
    { 1024, 368, -304},
    { 1104, 336, -224},
    { 1208, 376, -208},
    // 127 seconds
    { 1064, 352, -200},
    { 1208, 320, -112},
    { 1272, 320, -80},
    { 1200, 296, -32},
    { 1024, 248, -48},
    { 808, 192, -48},
    { 704, 168, -64},
    { 712, 160, -56},
    { 776, 144, -48},
    { 832, 120, -56},
    { 896, 64, -64},
    { 1024, 64, -80},
    { 984, 64, -144},
    { 1184, 120, -176},
    { 1232, 144, -144},
    { 1160, 168, -80},
    { 1232, 248, -104},
    { 1296, 256, -80},
    { 1136, 296, -144},
    { 792, 264, -144},
    { 552, 208, -136},
    { 472, 160, -128},
    { 496, 184, -88},
    { 616, 192, -48},
    { 720, 288, -104},
    // 128 seconds
    { 1080, 376, -200},
    { 1088, 400, -304},
    { 1072, 312, -176},
    { 1408, 408, -216},
    { 1224, 424, -224},
    { 1080, 352, -168},
    { 1104, 320, -160},
    { 1152, 264, -144},
    { 1088, 224, -40},
    { 872, 192, -24},
    { 712, 160, -48},
    { 656, 208, -24},
    { 696, 160, -16},
    { 784, 160, 8},
    { 864, 112, 0},
    { 1024, 120, -24},
    { 1104, 112, -72},
    { 1128, 104, -104},
    { 1232, 168, -112},
    { 1168, 120, -72},
    { 1136, 176, -128},
    { 1240, 248, -136},
    { 1168, 264, -168},
    { 904, 256, -208},
    { 632, 192, -168},
    // 129 seconds
    { 528, 176, -120},
    { 496, 200, -152},
    { 576, 216, -80},
    { 728, 296, -168},
    { 928, 360, -168},
    { 1088, 384, -240},
    { 992, 384, -248},
    { 1056, 368, -200},
    { 1240, 400, -192},
    { 1008, 336, -176},
    { 1080, 352, -160},
    { 1168, 320, -104},
    { 1144, 272, -56},
    { 992, 248, -56},
    { 816, 216, -72},
    { 696, 160, -56},
    { 720, 184, -40},
    { 792, 200, -24},
    { 824, 136, -32},
    { 968, 72, -8},
    { 1040, 80, -16},
    { 1056, 72, -64},
    { 1128, 120, -80},
    { 1184, 144, -80},
    { 1104, 144, -40},
    // 130 seconds
    { 1200, 200, -64},
    { 1288, 224, -88},
    { 1144, 248, -120},
    { 848, 248, -104},
    { 592, 208, -136},
    { 480, 152, -144},
    { 480, 168, -96},
    { 624, 208, -96},
    { 816, 256, -128},
    { 968, 280, -152},
    { 1056, 304, -232},
    { 1080, 312, -224},
    { 1232, 328, -200},
    { 1136, 328, -216},
    { 1144, 376, -192},
    { 1208, 368, -168},
    { 1200, 352, -136},
    { 1064, 272, -64},
    { 840, 232, -72},
    { 712, 208, -80},
    { 736, 176, -48},
    { 816, 216, -32},
    { 904, 168, -24},
    { 960, 120, -24},
    { 1024, 120, -16},
    // 131 seconds
    { 1064, 112, -24},
    { 1024, 128, -24},
    { 1208, 160, -8},
    { 1032, 136, 24},
    { 1104, 152, -24},
    { 1256, 200, -40},
    { 1088, 208, -56},
    { 840, 232, -56},
    { 616, 208, -88},
    { 520, 176, -112},
    { 576, 192, -112},
    { 720, 216, -128},
    { 880, 264, -208},
    { 1080, 272, -280},
    { 1160, 320, -352},
    { 1160, 328, -320},
    { 1272, 368, -240},
    { 1064, 392, -264},
    { 1048, 336, -224},
    { 1104, 304, -152},
    { 1184, 312, -72},
    { 1176, 328, -16},
    { 984, 272, -16},
    { 808, 248, -24},
    { 776, 216, -16},
    // 132 seconds
    { 832, 184, -24},
    { 928, 184, -8},
    { 968, 152, -16},
    { 992, 88, -40},
    { 984, 96, -8},
    { 968, 104, -128},
    { 1128, 104, -136},
    { 1112, 152, -112},
    { 984, 184, -144},
    { 1104, 232, -192},
    { 1232, 152, -160},
    { 1112, 216, -144},
    { 880, 264, -144},
    { 688, 248, -160},
    { 624, 192, -176},
    { 648, 192, -88},
    { 752, 264, -104},
    { 888, 320, -144},
    { 1080, 344, -176},
    { 1144, 376, -240},
    { 1112, 368, -232},
    { 1312, 424, -288},
    { 1056, 416, -288},
    { 1064, 368, -256},
    { 1256, 360, -152},
    // 133 seconds
    { 1232, 320, -32},
    { 1144, 264, -16},
    { 864, 224, -48},
    { 768, 184, -8},
    { 736, 192, -8},
    { 808, 176, 8},
    { 880, 168, 0},
    { 968, 160, -8},
    { 1064, 152, -16},
    { 1072, 128, 24},
    { 936, 112, -64},
    { 1112, 184, -104},
    { 1032, 184, -80},
    { 1056, 168, -80},
    { 1224, 240, -120},
    { 1256, 256, -112},
    { 1040, 296, -104},
    { 776, 296, -152},
    { 632, 176, -160},
    { 640, 256, -96},
    { 736, 320, -160},
    { 840, 288, -176},
    { 1000, 328, -224},
    { 1048, 376, -288},
    { 1056, 384, -296},
    // 134 seconds
    { 1208, 400, -216},
    { 1256, 408, -216},
    { 1024, 360, -176},
    { 1152, 352, -152},
    { 1264, 336, -88},
    { 1232, 312, 0},
    { 1064, 240, 40},
    { 864, 192, -8},
    { 784, 216, -8},
    { 816, 224, 24},
    { 856, 184, 32},
    { 888, 136, 32},
    { 992, 112, 8},
    { 1040, 128, -8},
    { 984, 112, -32},
    { 1176, 120, -48},
    { 1120, 160, -32},
    { 1000, 120, -88},
    { 1128, 224, -80},
    { 1232, 280, -120},
    { 1072, 272, -136},
    { 824, 200, -96},
    { 688, 272, -240},
    { 680, 152, -80},
    { 768, 288, -128},
    // 135 seconds
    { 872, 304, -112},
    { 1056, 376, -160},
    { 1168, 408, -224},
    { 1136, 432, -248},
    { 1144, 400, -192},
    { 1080, 464, -240},
    { 1000, 400, -232},
    { 1128, 352, -160},
    { 1256, 312, -72},
    { 1240, 280, -16},
    { 1096, 232, -16},
    { 952, 192, 16},
    { 912, 224, -24},
    { 920, 192, -16},
    { 920, 144, 16},
    { 864, 96, 24},
    { 960, 104, 0},
    { 984, 104, -32},
    { 976, 80, -88},
    { 1128, 136, -88},
    { 1104, 120, -104},
    { 1072, 160, -160},
    { 1216, 200, -136},
    { 1240, 216, -152},
    { 1024, 232, -128},
    // 136 seconds
    { 744, 240, -120},
    { 608, 248, -136},
    { 640, 264, -160},
    { 744, 192, -88},
    { 912, 208, -144},
    { 1096, 312, -208},
    { 1152, 384, -336},
    { 1176, 400, -304},
    { 1144, 392, -272},
    { 1056, 440, -296},
    { 960, 400, -240},
    { 1120, 376, -160},
    { 1264, 320, -88},
    { 1248, 272, -24},
    { 1112, 264, -24},
    { 944, 192, -16},
    { 824, 152, 8},
    { 784, 168, -8},
    { 848, 160, -8},
    { 872, 128, 8},
    { 920, 120, -32},
    { 1008, 104, -112},
    { 952, 88, -88},
    { 1024, 64, -160},
    { 1080, 128, -128},
    // 137 seconds
    { 1080, 160, -128},
    { 1176, 200, -144},
    { 1304, 240, -136},
    { 1200, 240, -152},
    { 920, 232, -104},
    { 688, 232, -128},
    { 584, 232, -176},
    { 608, 224, -72},
    { 760, 240, -80},
    { 888, 240, -96},
    { 1064, 296, -184},
    { 1104, 352, -264},
    { 1088, 328, -296},
    { 1248, 368, -264},
    { 1168, 416, -296},
    { 960, 344, -264},
    { 1120, 360, -208},
    { 1232, 328, -160},
    { 1232, 264, -88},
    { 1072, 200, -56},
    { 920, 168, -32},
    { 848, 152, -24},
    { 800, 152, 8},
    { 840, 160, 8},
    { 888, 144, 8},
    // 138 seconds
    { 952, 112, 8},
    { 1016, 104, -32},
    { 1024, 88, -72},
    { 1152, 72, -96},
    { 1224, 104, -64},
    { 1064, 144, -104},
    { 1128, 144, -184},
    { 1248, 208, -144},
    { 1112, 232, -152},
    { 864, 248, -128},
    { 680, 232, -152},
    { 624, 264, -128},
    { 656, 280, -96},
    { 744, 280, -48},
    { 888, 320, -128},
    { 1048, 368, -160},
    { 1048, 408, -224},
    { 1040, 416, -192},
    { 1304, 448, -176},
    { 1104, 424, -176},
    { 1032, 368, -144},
    { 1080, 344, -128},
    { 1168, 328, -96},
    { 1176, 280, 0},
    { 1040, 248, -16},
    // 139 seconds
    { 896, 184, 0},
    { 832, 208, -64},
    { 840, 192, -8},
    { 864, 128, 24},
    { 824, 72, 32},
    { 904, 72, -8},
    { 1048, 112, -88},
    { 1048, 72, -120},
    { 1232, 128, -80},
    { 1120, 160, -64},
    { 1072, 184, -96},
    { 1248, 200, -144},
    { 1248, 248, -160},
    { 1016, 264, -120},
    { 752, 232, -128},
    { 616, 216, -120},
    { 584, 232, -88},
    { 656, 248, -40},
    { 760, 272, -80},
    { 912, 320, -144},
    { 1080, 384, -232},
    { 1056, 416, -264},
    { 1064, 368, -200},
    { 1296, 360, -184},
    { 1144, 368, -208},
    // 140 seconds
    { 984, 320, -168},
    { 1048, 304, -112},
    { 1192, 312, -48},
    { 1200, 272, 32},
    { 1040, 200, 32},
    { 824, 168, -16},
    { 744, 176, -32},
    { 784, 184, -16},
    { 840, 136, 8},
    { 912, 104, -8},
    { 1008, 120, 0},
    { 984, 48, 16},
    { 960, 32, -88},
    { 1176, 112, -152},
    { 1176, 120, -104},
    { 1160, 216, -200},
    { 1152, 208, -208},
    { 1240, 176, -208},
    { 1128, 200, -184},
    { 872, 160, -192},
    { 664, 144, -192},
    { 552, 152, -136},
    { 552, 192, -80},
    { 688, 280, -80},
    { 880, 336, -160},
    // 141 seconds
    { 1136, 392, -208},
    { 1120, 424, -216},
    { 1128, 400, -200},
    { 1312, 352, -208},
    { 1064, 368, -240},
    { 936, 296, -160},
    { 1120, 288, -104},
    { 1256, 256, -32},
    { 1152, 248, 56},
    { 920, 216, -32},
    { 824, 192, -40},
    { 768, 152, 0},
    { 784, 152, -16},
    { 832, 128, 24},
    { 888, 88, 8},
    { 1000, 80, -40},
    { 984, 80, -104},
    { 1016, 48, -112},
    { 1176, 80, -104},
    { 1176, 152, -56},
    { 1112, 168, -64},
    { 1240, 208, -144},
    { 1288, 232, -168},
    { 1064, 240, -120},
    { 736, 240, -128},
    // 142 seconds
    { 544, 224, -152},
    { 496, 232, -112},
    { 584, 232, -64},
    { 736, 264, -120},
    { 952, 280, -184},
    { 1064, 304, -240},
    { 1072, 352, -264},
    { 1248, 368, -224},
    { 1184, 376, -216},
    { 1000, 352, -176},
    { 1200, 344, -120},
    { 1336, 304, -96},
    { 1248, 248, -24},
    { 992, 192, -24},
    { 800, 168, -24},
    { 744, 128, -40},
    { 776, 120, -16},
    { 808, 72, 8},
    { 832, 40, -8},
    { 928, 40, -32},
    { 1088, 48, -56},
    { 1080, 16, -40},
    { 1344, 88, -16},
    { 1128, 144, 32},
    { 1064, 160, -80},
    // 143 seconds
    { 1264, 208, -72},
    { 1224, 248, -96},
    { 968, 272, -112},
    { 728, 232, -104},
    { 624, 248, -128},
    { 640, 248, -104},
    { 712, 272, -96},
    { 808, 280, -208},
    { 936, 296, -208},
    { 1040, 336, -304},
    { 1032, 344, -304},
    { 1296, 360, -296},
    { 1184, 336, -256},
    { 1152, 304, -136},
    { 1208, 304, -120},
    { 1312, 304, -24},
    { 1208, 256, 88},
    { 992, 184, 64},
    { 832, 152, 16},
    { 832, 88, 64},
    { 792, 184, 72},
    { 824, 120, 32},
    { 824, 120, 32},
    { 880, 112, 16},
    { 960, 152, -40},
    // 144 seconds
    { 1000, 128, -72},
    { 1184, 176, -104},
    { 1144, 184, -48},
    { 1136, 176, -80},
    { 1256, 248, -128},
    { 1208, 264, -120},
    { 1008, 256, -120},
    { 760, 232, -112},
    { 656, 248, -112},
    { 688, 256, -120},
    { 752, 256, -104},
    { 832, 280, -160},
    { 912, 288, -200},
    { 944, 320, -256},
    { 888, 320, -248},
    { 920, 312, -240},
    { 1200, 336, -232},
    { 1432, 360, -96},
    { 1072, 216, -16},
    { 1016, 112, 56},
    { 1072, 160, -64},
    { 1048, 184, -16},
    { 1048, 232, 96},
    { 1080, 400, 48},
    { 1136, 584, -96},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:06:25 local
AccelRawData *activity_sample_walk_200_pbl_25656_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25656_9
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -488, 544, 600},
    { -456, 880, 512},
    { -424, 544, 600},
    { -472, 304, 616},
    { -464, 600, 696},
    { -504, 528, 728},
    { -416, 648, 656},
    { -432, 632, 608},
    { -416, 768, 616},
    { -488, 968, 544},
    { -528, 768, 488},
    { -616, 880, 400},
    { -632, 760, 152},
    { -656, 760, 112},
    { -560, 584, -96},
    { -560, 568, -384},
    { -424, 248, -648},
    { -328, 56, -792},
    { -264, 112, -1024},
    { -88, -200, -1000},
    { -152, 16, -1064},
    { -128, -48, -1104},
    { -136, -64, -1160},
    { -120, -200, -1056},
    { -72, -240, -1008},
    // 1 seconds
    { -248, -344, -968},
    { -160, -368, -1064},
    { -256, -184, -984},
    { -112, -256, -920},
    { -160, -320, -960},
    { -264, -256, -976},
    { -208, -248, -952},
    { -176, -360, -952},
    { -184, -336, -888},
    { -224, -328, -920},
    { -216, -296, -1056},
    { -192, -360, -944},
    { 64, -456, -912},
    { -80, -192, -920},
    { -120, -304, -896},
    { -144, -304, -944},
    { -136, -208, -920},
    { -152, -360, -952},
    { -192, -272, -952},
    { -176, -240, -944},
    { -112, -296, -904},
    { -80, -272, -856},
    { -32, -208, -896},
    { -48, -216, -904},
    { -8, -168, -856},
    // 2 seconds
    { 8, -72, -904},
    { 80, -88, -864},
    { 112, -56, -904},
    { 192, 32, -864},
    { 120, 104, -928},
    { 192, 0, -904},
    { 224, 184, -976},
    { 312, 88, -944},
    { 304, 208, -992},
    { 368, 176, -960},
    { 408, 248, -960},
    { 440, 216, -920},
    { 504, 240, -904},
    { 528, 224, -832},
    { 544, 208, -800},
    { 576, 208, -744},
    { 608, 248, -720},
    { 632, 224, -688},
    { 656, 224, -640},
    { 680, 216, -608},
    { 688, 224, -568},
    { 712, 152, -528},
    { 744, 184, -512},
    { 808, 168, -472},
    { 880, 168, -416},
    // 3 seconds
    { 944, 176, -368},
    { 1000, 192, -336},
    { 1016, 264, -304},
    { 984, 352, -280},
    { 944, 360, -232},
    { 928, 344, -232},
    { 920, 280, -208},
    { 896, 232, -224},
    { 920, 208, -240},
    { 928, 216, -272},
    { 904, 216, -280},
    { 904, 200, -296},
    { 896, 184, -296},
    { 896, 136, -264},
    { 840, 136, -240},
    { 816, 120, -232},
    { 816, 136, -192},
    { 808, 144, -208},
    { 856, 160, -184},
    { 944, 208, -208},
    { 1000, 216, -232},
    { 1104, 216, -200},
    { 1136, 248, -232},
    { 1056, 240, -224},
    { 936, 224, -184},
    // 4 seconds
    { 832, 240, -136},
    { 792, 240, -128},
    { 944, 264, -152},
    { 1048, 272, -144},
    { 1072, 256, -104},
    { 968, 224, -56},
    { 912, 192, -88},
    { 888, 192, -104},
    { 840, 192, -104},
    { 792, 144, -120},
    { 752, 128, -128},
    { 816, 88, -184},
    { 992, 120, -200},
    { 1032, 104, -224},
    { 1160, 96, -248},
    { 1208, 104, -280},
    { 1152, 32, -200},
    { 1040, 40, -176},
    { 1016, 48, -176},
    { 1104, 120, -136},
    { 1032, 184, -152},
    { 848, 184, -176},
    { 648, 160, -144},
    { 544, 200, -184},
    { 536, 168, -160},
    // 5 seconds
    { 632, 136, -152},
    { 784, 232, -264},
    { 984, 256, -320},
    { 1160, 224, -360},
    { 1008, 192, -376},
    { 1248, 216, -280},
    { 1320, 288, -328},
    { 1104, 320, -248},
    { 976, 296, -168},
    { 984, 336, -184},
    { 1016, 304, -136},
    { 904, 232, -112},
    { 784, 192, -88},
    { 744, 176, -96},
    { 784, 192, -88},
    { 856, 184, -64},
    { 920, 152, -56},
    { 1032, 200, -72},
    { 1144, 112, -64},
    { 1152, 40, -40},
    { 1192, 40, -56},
    { 1192, 96, 0},
    { 1064, 104, -64},
    { 1112, 112, -96},
    { 1216, 88, -88},
    // 6 seconds
    { 1064, 184, -144},
    { 776, 192, -168},
    { 592, 184, -184},
    { 528, 168, -224},
    { 592, 104, -168},
    { 784, 168, -192},
    { 864, 200, -280},
    { 1040, 232, -312},
    { 1072, 256, -336},
    { 1000, 280, -328},
    { 1184, 264, -224},
    { 1224, 328, -264},
    { 1024, 312, -208},
    { 1040, 304, -152},
    { 1120, 328, -160},
    { 1176, 296, -112},
    { 960, 256, -56},
    { 760, 224, -56},
    { 712, 192, -88},
    { 784, 216, -80},
    { 880, 232, -40},
    { 912, 136, -24},
    { 992, 88, 0},
    { 1024, 120, -40},
    { 984, 80, -64},
    // 7 seconds
    { 1080, 144, -24},
    { 1112, 152, -16},
    { 1072, 152, -16},
    { 1192, 168, -80},
    { 1304, 184, -88},
    { 1200, 224, -112},
    { 920, 248, -136},
    { 656, 216, -144},
    { 560, 184, -176},
    { 552, 200, -168},
    { 664, 200, -184},
    { 784, 224, -224},
    { 1000, 264, -248},
    { 1088, 304, -368},
    { 1048, 352, -320},
    { 1128, 328, -280},
    { 1168, 344, -264},
    { 992, 376, -232},
    { 1104, 352, -192},
    { 1232, 336, -168},
    { 1280, 272, -48},
    { 1064, 256, -32},
    { 840, 256, -24},
    { 736, 264, -64},
    { 776, 200, -56},
    // 8 seconds
    { 816, 160, -8},
    { 840, 128, -24},
    { 968, 88, 24},
    { 1032, 160, 48},
    { 960, 200, -32},
    { 1088, 136, -80},
    { 1144, 152, -80},
    { 1136, 128, -104},
    { 1208, 168, -144},
    { 1288, 216, -168},
    { 1176, 256, -136},
    { 888, 280, -184},
    { 632, 256, -272},
    { 520, 192, -176},
    { 528, 192, -192},
    { 664, 208, -216},
    { 808, 216, -208},
    { 1064, 288, -248},
    { 1088, 312, -336},
    { 1024, 320, -336},
    { 1144, 328, -288},
    { 1168, 352, -288},
    { 1040, 336, -208},
    { 1120, 320, -192},
    { 1200, 304, -184},
    // 9 seconds
    { 1192, 304, -104},
    { 1080, 280, -64},
    { 864, 208, -32},
    { 728, 184, -72},
    { 712, 160, -32},
    { 736, 112, -24},
    { 704, 128, -8},
    { 776, 136, -96},
    { 968, 144, -144},
    { 920, 120, -200},
    { 1064, 112, -232},
    { 1184, 216, -168},
    { 1080, 208, -208},
    { 1088, 240, -184},
    { 1240, 248, -304},
    { 1224, 256, -280},
    { 960, 240, -232},
    { 704, 224, -232},
    { 568, 184, -232},
    { 568, 192, -160},
    { 672, 192, -184},
    { 768, 168, -240},
    { 936, 248, -152},
    { 1008, 336, -280},
    { 1032, 376, -296},
    // 10 seconds
    { 1336, 424, -280},
    { 1288, 392, -280},
    { 1056, 344, -200},
    { 1088, 328, -192},
    { 1208, 320, -176},
    { 1160, 288, -88},
    { 960, 248, -24},
    { 816, 200, -48},
    { 776, 160, -56},
    { 816, 224, -24},
    { 824, 168, -24},
    { 856, 128, 0},
    { 976, 144, -8},
    { 1000, 168, -56},
    { 992, 136, -80},
    { 1104, 136, -104},
    { 1136, 184, -112},
    { 1080, 168, -120},
    { 1200, 192, -120},
    { 1272, 232, -200},
    { 1080, 280, -216},
    { 792, 272, -184},
    { 600, 240, -200},
    { 544, 216, -160},
    { 592, 216, -144},
    // 11 seconds
    { 744, 192, -144},
    { 904, 256, -200},
    { 1144, 288, -224},
    { 1096, 352, -320},
    { 1064, 336, -296},
    { 1272, 344, -264},
    { 1112, 368, -296},
    { 960, 360, -280},
    { 1080, 288, -208},
    { 1200, 304, -152},
    { 1128, 240, -96},
    { 936, 248, -72},
    { 752, 224, -72},
    { 712, 224, -24},
    { 752, 232, -8},
    { 824, 176, 0},
    { 944, 152, -8},
    { 1120, 152, 8},
    { 1040, 56, -8},
    { 952, 16, -16},
    { 1136, 112, -136},
    { 1192, 104, -112},
    { 1160, 152, -104},
    { 1256, 192, -96},
    { 1248, 224, -176},
    // 12 seconds
    { 984, 224, -136},
    { 704, 216, -240},
    { 528, 208, -200},
    { 480, 256, -192},
    { 576, 240, -152},
    { 784, 248, -192},
    { 952, 272, -232},
    { 1088, 304, -272},
    { 1008, 328, -296},
    { 1120, 336, -272},
    { 1264, 352, -272},
    { 1072, 328, -248},
    { 1040, 320, -200},
    { 1136, 336, -216},
    { 1200, 272, -160},
    { 1096, 224, -16},
    { 936, 208, -64},
    { 768, 184, -16},
    { 664, 192, -8},
    { 664, 208, -40},
    { 792, 192, -48},
    { 880, 128, -32},
    { 1120, 112, -24},
    { 1032, 48, -88},
    { 1128, 56, -120},
    // 13 seconds
    { 1232, 136, -144},
    { 1224, 128, -120},
    { 1168, 176, -168},
    { 1208, 200, -176},
    { 1128, 248, -184},
    { 872, 224, -208},
    { 632, 184, -168},
    { 504, 144, -176},
    { 496, 208, -152},
    { 616, 232, -136},
    { 792, 280, -184},
    { 968, 272, -224},
    { 1056, 328, -304},
    { 1032, 328, -304},
    { 1176, 368, -256},
    { 1264, 408, -272},
    { 1096, 352, -224},
    { 1112, 368, -192},
    { 1152, 352, -184},
    { 1136, 272, -112},
    { 936, 200, -48},
    { 816, 192, -96},
    { 704, 144, -64},
    { 712, 184, -64},
    { 792, 128, -40},
    // 14 seconds
    { 824, 120, -24},
    { 920, 120, -40},
    { 1080, 104, -56},
    { 1080, 88, -120},
    { 1208, 128, -216},
    { 1280, 136, -88},
    { 1136, 168, -128},
    { 1200, 256, -152},
    { 1200, 192, -200},
    { 960, 208, -248},
    { 656, 208, -208},
    { 480, 200, -224},
    { 456, 160, -248},
    { 552, 152, -144},
    { 688, 216, -248},
    { 936, 248, -224},
    { 1064, 312, -312},
    { 1056, 288, -320},
    { 1080, 312, -296},
    { 1128, 360, -256},
    { 1040, 400, -272},
    { 1120, 440, -232},
    { 1256, 344, -144},
    { 1264, 320, -88},
    { 1096, 296, -56},
    // 15 seconds
    { 856, 248, -72},
    { 720, 184, -88},
    { 712, 184, -80},
    { 800, 168, -72},
    { 848, 136, -40},
    { 936, 104, -24},
    { 1000, 80, -32},
    { 1016, 64, -56},
    { 1048, 80, -168},
    { 1168, 128, -96},
    { 1208, 144, -104},
    { 1288, 224, -136},
    { 1336, 240, -168},
    { 1152, 240, -216},
    { 800, 216, -200},
    { 552, 208, -184},
    { 472, 184, -192},
    { 520, 208, -136},
    { 712, 216, -176},
    { 872, 256, -208},
    { 1072, 312, -256},
    { 1088, 352, -328},
    { 1072, 336, -288},
    { 1264, 400, -264},
    { 1152, 384, -272},
    // 16 seconds
    { 1032, 344, -200},
    { 1160, 344, -192},
    { 1224, 288, -144},
    { 1112, 264, -88},
    { 896, 240, -80},
    { 760, 216, -72},
    { 760, 192, -72},
    { 776, 192, -56},
    { 856, 120, -32},
    { 880, 80, -8},
    { 992, 88, -56},
    { 1088, 88, -80},
    { 1128, 88, -112},
    { 1232, 136, -136},
    { 1184, 152, -80},
    { 1088, 160, -136},
    { 1184, 216, -112},
    { 1136, 232, -144},
    { 928, 240, -160},
    { 672, 232, -192},
    { 536, 216, -184},
    { 552, 224, -176},
    { 664, 208, -184},
    { 800, 256, -208},
    { 960, 272, -264},
    // 17 seconds
    { 1064, 304, -312},
    { 1064, 304, -328},
    { 1176, 312, -280},
    { 1208, 360, -304},
    { 1008, 328, -224},
    { 1072, 336, -176},
    { 1168, 336, -176},
    { 1184, 296, -96},
    { 1056, 248, -72},
    { 840, 200, -56},
    { 720, 184, -72},
    { 712, 184, -64},
    { 736, 160, -64},
    { 768, 160, -40},
    { 920, 128, -64},
    { 1000, 128, -80},
    { 1016, 88, -104},
    { 1088, 104, -200},
    { 1192, 128, -160},
    { 1128, 184, -184},
    { 1152, 176, -184},
    { 1288, 232, -200},
    { 1144, 240, -224},
    { 824, 240, -200},
    { 560, 208, -192},
    // 18 seconds
    { 464, 216, -136},
    { 504, 176, -160},
    { 640, 192, -128},
    { 784, 224, -200},
    { 952, 264, -200},
    { 1048, 296, -320},
    { 1016, 264, -320},
    { 1120, 288, -296},
    { 1232, 352, -296},
    { 1048, 352, -288},
    { 1024, 376, -232},
    { 1104, 376, -200},
    { 1192, 296, -152},
    { 1064, 248, -104},
    { 832, 232, -104},
    { 736, 208, -104},
    { 720, 208, -80},
    { 832, 152, -72},
    { 896, 160, -48},
    { 992, 176, 8},
    { 1024, 160, -24},
    { 992, 160, -112},
    { 1064, 112, -168},
    { 1080, 136, -176},
    { 1096, 144, -152},
    // 19 seconds
    { 1136, 152, -176},
    { 1240, 224, -192},
    { 1128, 248, -168},
    { 848, 232, -144},
    { 608, 264, -128},
    { 496, 240, -168},
    { 488, 216, -120},
    { 616, 256, -120},
    { 760, 240, -112},
    { 992, 296, -192},
    { 1136, 344, -280},
    { 1088, 376, -280},
    { 1184, 368, -272},
    { 1160, 408, -280},
    { 1048, 384, -240},
    { 1120, 368, -192},
    { 1200, 344, -200},
    { 1096, 312, -112},
    { 920, 248, -104},
    { 752, 216, -96},
    { 672, 184, -72},
    { 728, 232, -72},
    { 784, 176, 0},
    { 856, 152, -40},
    { 936, 128, -16},
    // 20 seconds
    { 1056, 112, -72},
    { 1024, 72, -104},
    { 1184, 128, -144},
    { 1272, 168, -96},
    { 1064, 160, -80},
    { 1208, 256, -144},
    { 1280, 240, -136},
    { 1016, 296, -216},
    { 704, 208, -136},
    { 528, 232, -200},
    { 480, 240, -160},
    { 528, 192, -176},
    { 672, 200, -144},
    { 832, 264, -200},
    { 1032, 256, -256},
    { 1048, 312, -328},
    { 1128, 312, -344},
    { 1312, 376, -304},
    { 1072, 368, -256},
    { 1024, 416, -264},
    { 1144, 416, -216},
    { 1216, 336, -152},
    { 1128, 272, -88},
    { 920, 264, -88},
    { 792, 216, -48},
    // 21 seconds
    { 744, 208, -64},
    { 776, 168, -56},
    { 808, 144, -16},
    { 880, 96, -56},
    { 984, 72, -144},
    { 952, 56, -152},
    { 1080, -96, -160},
    { 1256, 136, -152},
    { 992, 136, -184},
    { 1104, 152, -176},
    { 1328, 200, -216},
    { 1200, 176, -200},
    { 936, 200, -192},
    { 680, 264, -232},
    { 560, 208, -200},
    { 544, 160, -144},
    { 656, 184, -152},
    { 824, 280, -208},
    { 1040, 336, -240},
    { 1056, 384, -312},
    { 1000, 368, -296},
    { 1216, 408, -296},
    { 1208, 520, -312},
    { 1136, 368, -248},
    { 1280, 312, -200},
    // 22 seconds
    { 1224, 312, -144},
    { 1104, 264, -32},
    { 896, 216, -56},
    { 744, 176, -72},
    { 672, 160, -72},
    { 688, 200, -16},
    { 872, 216, -40},
    { 952, 168, 32},
    { 1104, 112, 8},
    { 1104, -24, -64},
    { 1080, -40, -128},
    { 1256, 16, -152},
    { 1168, 72, -128},
    { 1128, 112, -232},
    { 1288, 144, -240},
    { 1200, 152, -264},
    { 880, 208, -288},
    { 616, 160, -256},
    { 488, 176, -200},
    { 480, 240, -184},
    { 616, 264, -168},
    { 816, 280, -216},
    { 1104, 296, -288},
    { 1120, 384, -272},
    { 1096, 376, -256},
    // 23 seconds
    { 1208, 408, -240},
    { 1128, 408, -232},
    { 1072, 360, -208},
    { 1208, 320, -160},
    { 1296, 320, -120},
    { 1240, 288, 0},
    { 944, 256, -48},
    { 728, 168, -56},
    { 592, 120, -24},
    { 560, 128, -64},
    { 648, 120, -40},
    { 816, 112, -16},
    { 1000, 128, -80},
    { 1040, 80, -72},
    { 1048, 120, -112},
    { 1224, 136, -192},
    { 1184, 152, -104},
    { 1120, 168, -72},
    { 1312, 256, -112},
    { 1400, 248, -176},
    { 1120, 288, -264},
    { 736, 208, -112},
    { 496, 264, -232},
    { 408, 264, -136},
    { 440, 256, -88},
    // 24 seconds
    { 608, 264, -96},
    { 840, 328, -160},
    { 1032, 368, -224},
    { 1064, 424, -248},
    { 1072, 408, -232},
    { 1160, 424, -176},
    { 1256, 496, -224},
    { 1352, 424, -144},
    { 1464, 384, -104},
    { 1296, 320, -72},
    { 1080, 280, -48},
    { 872, 200, -104},
    { 744, 128, -40},
    { 688, 128, -8},
    { 712, 56, -16},
    { 768, 72, -16},
    { 808, 24, -56},
    { 912, 88, -120},
    { 1008, 48, -136},
    { 1160, 104, -224},
    { 1352, 152, -168},
    { 1328, 184, -48},
    { 1288, 280, -200},
    { 1360, 360, -264},
    { 1160, 320, -200},
    // 25 seconds
    { 832, 280, -184},
    { 600, 248, -176},
    { 488, 168, -96},
    { 456, 184, -144},
    { 472, 240, -80},
    { 632, 280, -152},
    { 792, 440, -200},
    { 832, 520, -232},
    { 856, 520, -200},
    { 784, 496, -192},
    { 1200, 512, -144},
    { 2016, 728, -168},
    { 1896, 512, 32},
    { 1512, 376, -96},
    { 1136, 248, -48},
    { 912, 200, -80},
    { 808, 96, -48},
    { 680, 16, -16},
    { 832, 0, -40},
    { 1064, -88, 8},
    { 1232, -16, 16},
    { 1256, -8, -80},
    { 1456, 96, -48},
    { 1504, 112, 56},
    { 1408, 200, -72},
    // 26 seconds
    { 1296, 216, -72},
    { 1064, 208, -168},
    { 760, 192, -120},
    { 496, 256, -200},
    { 320, 144, -168},
    { 304, 200, -176},
    { 464, 232, -136},
    { 960, 224, -224},
    { 1304, 344, -248},
    { 1344, 440, -248},
    { 1352, 504, -264},
    { 1208, 512, -232},
    { 1032, 552, -232},
    { 1096, 448, -184},
    { 1200, 400, -160},
    { 1160, 304, -104},
    { 960, 248, -88},
    { 744, 192, -128},
    { 616, 160, -136},
    { 584, 168, -64},
    { 672, 192, -56},
    { 944, 216, -80},
    { 1168, 144, -96},
    { 1184, 56, 16},
    { 1256, 24, -160},
    // 27 seconds
    { 1304, 112, -64},
    { 1216, 184, -96},
    { 1176, 136, -136},
    { 1280, 200, -136},
    { 1168, 232, -160},
    { 880, 208, -136},
    { 584, 200, -152},
    { 424, 216, -192},
    { 328, 216, -152},
    { 360, 224, -136},
    { 608, 232, -152},
    { 1144, 336, -216},
    { 1232, 440, -208},
    { 1216, 456, -232},
    { 1344, 488, -248},
    { 1168, 504, -200},
    { 968, 400, -144},
    { 1024, 376, -168},
    { 1104, 376, -104},
    { 984, 328, -40},
    { 776, 240, -32},
    { 608, 192, -72},
    { 600, 224, -64},
    { 688, 216, -32},
    { 896, 184, -72},
    // 28 seconds
    { 1136, 168, -88},
    { 1224, 88, -64},
    { 1136, -24, -120},
    { 1280, 56, -152},
    { 1184, 176, -80},
    { 1144, 232, -56},
    { 1280, 288, -80},
    { 1240, 232, -96},
    { 960, 248, -96},
    { 648, 272, -120},
    { 456, 200, -168},
    { 368, 144, -104},
    { 416, 152, -120},
    { 600, 176, -152},
    { 928, 248, -152},
    { 1144, 312, -272},
    { 1128, 352, -264},
    { 1184, 392, -304},
    { 1256, 400, -272},
    { 1024, 456, -280},
    { 1016, 392, -232},
    { 1128, 408, -168},
    { 1208, 336, -120},
    { 1056, 272, -48},
    { 816, 216, -72},
    // 29 seconds
    { 688, 192, -56},
    { 664, 176, -48},
    { 752, 200, -72},
    { 928, 168, -56},
    { 1016, 88, -8},
    { 1088, 48, -40},
    { 1104, 88, -96},
    { 1176, 40, -184},
    { 1264, 104, -32},
    { 1104, 152, -80},
    { 1232, 216, -144},
    { 1296, 280, -160},
    { 1072, 296, -224},
    { 728, 240, -192},
    { 512, 248, -160},
    { 416, 176, -200},
    { 472, 160, -104},
    { 616, 288, -152},
    { 864, 280, -184},
    { 1112, 336, -256},
    { 1072, 392, -312},
    { 1112, 352, -272},
    { 1256, 416, -240},
    { 1096, 400, -224},
    { 1104, 392, -168},
    // 30 seconds
    { 1232, 344, -144},
    { 1200, 312, -80},
    { 1056, 264, -56},
    { 840, 208, -56},
    { 704, 184, -80},
    { 656, 192, -64},
    { 744, 168, -40},
    { 808, 120, -24},
    { 912, 48, -24},
    { 1032, 80, -72},
    { 1080, 80, -96},
    { 1120, 136, -168},
    { 1248, 168, -128},
    { 1144, 168, -64},
    { 1264, 272, -136},
    { 1344, 296, -168},
    { 1128, 304, -168},
    { 752, 288, -184},
    { 536, 232, -192},
    { 440, 208, -128},
    { 448, 256, -152},
    { 576, 200, -152},
    { 792, 280, -176},
    { 1128, 320, -232},
    { 1168, 408, -304},
    // 31 seconds
    { 1160, 400, -280},
    { 1160, 424, -256},
    { 1024, 400, -272},
    { 1168, 352, -176},
    { 1320, 352, -120},
    { 1264, 296, -40},
    { 1048, 264, 0},
    { 808, 216, -72},
    { 672, 176, -64},
    { 632, 176, -56},
    { 688, 152, -32},
    { 768, 152, -48},
    { 848, 48, -32},
    { 1016, 56, -88},
    { 1024, 0, -120},
    { 1120, 80, -160},
    { 1280, 144, -120},
    { 1176, 184, -96},
    { 1320, 272, -200},
    { 1368, 264, -168},
    { 1128, 264, -240},
    { 776, 248, -200},
    { 544, 248, -192},
    { 448, 200, -184},
    { 472, 240, -120},
    // 32 seconds
    { 592, 232, -152},
    { 752, 296, -168},
    { 944, 344, -240},
    { 1064, 400, -232},
    { 1128, 416, -232},
    { 1312, 440, -208},
    { 1248, 480, -216},
    { 1272, 392, -152},
    { 1312, 352, -152},
    { 1136, 296, -104},
    { 912, 192, -48},
    { 752, 184, -48},
    { 688, 56, -24},
    { 680, -88, 16},
    { 744, -104, -8},
    { 784, -16, -40},
    { 912, 32, -72},
    { 1104, 88, -56},
    { 984, 104, -152},
    { 1232, 216, -152},
    { 1320, 72, -112},
    { 1336, 208, -120},
    { 1488, 240, -112},
    { 1280, 272, -152},
    { 920, 280, -144},
    // 33 seconds
    { 608, 232, -200},
    { 472, 200, -144},
    { 432, 240, -112},
    { 512, 216, -120},
    { 584, 232, -128},
    { 816, 264, -176},
    { 976, 296, -248},
    { 1072, 336, -256},
    { 1056, 288, -216},
    { 1296, 400, -304},
    { 1496, 408, -224},
    { 1544, 360, -192},
    { 1368, 352, -152},
    { 1056, 280, -96},
    { 800, 184, -64},
    { 672, 120, -112},
    { 624, 144, -80},
    { 648, 88, -32},
    { 736, 56, -56},
    { 784, 24, -24},
    { 880, 16, 8},
    { 944, 160, -8},
    { 1216, 160, -80},
    { 1496, 200, 24},
    { 1560, 240, -120},
    // 34 seconds
    { 1672, 304, -208},
    { 1384, 264, -144},
    { 832, 248, -240},
    { 360, 264, -384},
    { 376, 192, -336},
    { 496, 184, -256},
    { 704, 216, -256},
    { 960, 296, -224},
    { 1136, 368, -256},
    { 1192, 432, -208},
    { 1128, 392, -192},
    { 1160, 400, -224},
    { 1152, 408, -216},
    { 1344, 376, -160},
    { 1416, 336, -160},
    { 1296, 272, -144},
    { 976, 216, -72},
    { 736, 152, -96},
    { 640, 80, -48},
    { 608, 112, -16},
    { 712, 144, -32},
    { 792, 112, -16},
    { 880, 96, 0},
    { 1048, 112, -72},
    { 1032, 104, -88},
    // 35 seconds
    { 1312, 224, -120},
    { 1208, 152, -96},
    { 1448, 200, -64},
    { 1640, 288, -192},
    { 1336, 296, -200},
    { 848, 264, -232},
    { 488, 232, -264},
    { 352, 200, -248},
    { 376, 192, -168},
    { 600, 208, -184},
    { 968, 248, -176},
    { 1296, 304, -240},
    { 1240, 336, -232},
    { 1224, 328, -216},
    { 1192, 408, -224},
    { 1056, 424, -208},
    { 1000, 400, -208},
    { 1064, 352, -168},
    { 1088, 328, -112},
    { 952, 288, -64},
    { 840, 248, -64},
    { 808, 176, -24},
    { 784, 160, -32},
    { 824, 176, 16},
    { 848, 136, 48},
    // 36 seconds
    { 1032, 104, -64},
    { 1024, 128, -40},
    { 1088, 64, -136},
    { 1240, 120, -152},
    { 1344, 168, -160},
    { 1264, 184, -176},
    { 1264, 256, -144},
    { 1216, 224, -144},
    { 1040, 248, -176},
    { 744, 208, -112},
    { 520, 120, -72},
    { 400, 136, -104},
    { 376, 136, -104},
    { 488, 120, -64},
    { 760, 184, -136},
    { 1128, 280, -144},
    { 1144, 280, -208},
    { 1096, 320, -288},
    { 1280, 368, -248},
    { 1240, 392, -304},
    { 1104, 392, -264},
    { 1032, 352, -248},
    { 1072, 344, -232},
    { 1048, 312, -176},
    { 960, 256, -112},
    // 37 seconds
    { 840, 208, -96},
    { 784, 192, -64},
    { 768, 184, -64},
    { 792, 184, -32},
    { 808, 144, -24},
    { 888, 120, -32},
    { 1008, 120, -40},
    { 1024, 112, -40},
    { 1040, 152, -128},
    { 1208, 208, -176},
    { 1176, 200, -144},
    { 1136, 168, -136},
    { 1256, 256, -184},
    { 1184, 280, -176},
    { 872, 248, -104},
    { 584, 240, -120},
    { 456, 216, -104},
    { 440, 192, -80},
    { 584, 184, -120},
    { 776, 184, -144},
    { 1008, 224, -240},
    { 1024, 256, -296},
    { 1064, 328, -352},
    { 1216, 344, -312},
    { 1176, 384, -320},
    // 38 seconds
    { 1104, 392, -288},
    { 1160, 416, -248},
    { 1216, 400, -168},
    { 1184, 320, -72},
    { 952, 248, -40},
    { 784, 208, -48},
    { 752, 208, -56},
    { 792, 192, -56},
    { 856, 168, -16},
    { 848, 136, -16},
    { 944, 88, -56},
    { 1016, 80, -40},
    { 1096, 48, -128},
    { 1224, 80, -144},
    { 1168, 144, -96},
    { 1008, 160, -128},
    { 1248, 240, -96},
    { 1240, 240, -120},
    { 1008, 264, -104},
    { 728, 256, -104},
    { 592, 232, -168},
    { 536, 208, -120},
    { 616, 240, -104},
    { 784, 264, -144},
    { 960, 352, -192},
    // 39 seconds
    { 1160, 392, -288},
    { 1096, 400, -304},
    { 1064, 384, -320},
    { 1216, 424, -296},
    { 1112, 408, -280},
    { 1160, 344, -232},
    { 1192, 360, -192},
    { 1232, 288, -128},
    { 1088, 232, 0},
    { 872, 200, -24},
    { 784, 200, -24},
    { 744, 192, 16},
    { 768, 144, 0},
    { 792, 144, 24},
    { 904, 96, 32},
    { 1016, 144, 16},
    { 1064, 136, -16},
    { 1176, 136, -80},
    { 1240, 136, -128},
    { 1144, 144, -120},
    { 1200, 144, -184},
    { 1288, 192, -152},
    { 1184, 240, -192},
    { 896, 232, -192},
    { 608, 200, -192},
    // 40 seconds
    { 488, 192, -176},
    { 480, 208, -112},
    { 632, 208, -144},
    { 816, 256, -168},
    { 1024, 352, -232},
    { 1120, 392, -312},
    { 1136, 392, -296},
    { 1280, 432, -272},
    { 1112, 448, -272},
    { 968, 376, -216},
    { 1168, 368, -176},
    { 1312, 328, -120},
    { 1192, 264, -56},
    { 960, 200, -72},
    { 792, 184, -88},
    { 712, 152, -72},
    { 712, 152, -48},
    { 816, 136, -32},
    { 856, 88, -16},
    { 960, 72, -32},
    { 1056, 88, -8},
    { 1040, 128, -40},
    { 1192, 144, -144},
    { 1280, 144, -80},
    { 1152, 104, -144},
    // 41 seconds
    { 1280, 224, -120},
    { 1264, 224, -160},
    { 1008, 272, -200},
    { 688, 200, -208},
    { 536, 232, -176},
    { 480, 232, -144},
    { 568, 208, -136},
    { 768, 264, -160},
    { 912, 320, -208},
    { 1088, 328, -264},
    { 1016, 344, -288},
    { 1080, 352, -272},
    { 1328, 408, -272},
    { 1064, 352, -216},
    { 1024, 328, -200},
    { 1152, 328, -168},
    { 1216, 312, -80},
    { 1096, 264, -64},
    { 888, 208, -64},
    { 760, 176, -72},
    { 680, 160, -48},
    { 704, 168, -32},
    { 840, 160, -16},
    { 888, 128, 24},
    { 1000, 112, -24},
    // 42 seconds
    { 1008, 96, -112},
    { 1144, 96, -160},
    { 1248, 136, -160},
    { 1176, 152, -168},
    { 1072, 184, -224},
    { 1216, 184, -224},
    { 1176, 224, -192},
    { 920, 256, -168},
    { 632, 232, -192},
    { 512, 224, -168},
    { 504, 208, -128},
    { 592, 248, -136},
    { 728, 296, -160},
    { 928, 352, -184},
    { 1088, 392, -264},
    { 1000, 424, -280},
    { 1208, 408, -256},
    { 1216, 440, -248},
    { 1032, 400, -208},
    { 1088, 384, -208},
    { 1128, 344, -168},
    { 1112, 272, -104},
    { 960, 248, -96},
    { 784, 200, -88},
    { 688, 160, -72},
    // 43 seconds
    { 688, 184, -72},
    { 800, 176, -64},
    { 856, 136, -40},
    { 992, 144, -64},
    { 1112, 88, -136},
    { 1056, 56, -168},
    { 1272, 88, -224},
    { 1232, 64, -192},
    { 1072, 160, -152},
    { 1208, 224, -216},
    { 1184, 256, -208},
    { 952, 256, -152},
    { 672, 200, -120},
    { 536, 200, -168},
    { 480, 224, -200},
    { 552, 208, -72},
    { 712, 176, -136},
    { 880, 232, -208},
    { 1080, 312, -256},
    { 1032, 344, -296},
    { 1160, 344, -328},
    { 1376, 408, -304},
    { 1104, 376, -296},
    { 1048, 360, -224},
    { 1128, 352, -256},
    // 44 seconds
    { 1112, 320, -160},
    { 1024, 232, -104},
    { 832, 176, -112},
    { 744, 128, -72},
    { 720, 232, -48},
    { 768, 168, -8},
    { 800, 160, 8},
    { 896, 160, 8},
    { 1048, 176, -16},
    { 1112, 152, -24},
    { 1184, 128, -112},
    { 1176, 128, -128},
    { 1104, 120, -56},
    { 1056, 168, -136},
    { 1208, 232, -144},
    { 1176, 200, -184},
    { 936, 216, -184},
    { 680, 208, -184},
    { 552, 192, -208},
    { 504, 208, -128},
    { 608, 256, -128},
    { 784, 280, -200},
    { 1032, 312, -216},
    { 1152, 320, -296},
    { 1048, 320, -296},
    // 45 seconds
    { 1136, 328, -256},
    { 1216, 336, -272},
    { 984, 296, -168},
    { 1064, 344, -160},
    { 1160, 312, -128},
    { 1192, 272, -88},
    { 1008, 248, -40},
    { 856, 224, -96},
    { 752, 176, -88},
    { 760, 128, -24},
    { 776, 168, -16},
    { 824, 152, -32},
    { 920, 200, -72},
    { 1016, 192, -72},
    { 1048, 88, -88},
    { 1080, -32, -128},
    { 1152, 48, -128},
    { 1160, 72, -112},
    { 1104, 96, -120},
    { 1248, 160, -160},
    { 1256, 232, -176},
    { 1048, 264, -200},
    { 744, 240, -192},
    { 552, 272, -152},
    { 488, 232, -160},
    // 46 seconds
    { 568, 224, -104},
    { 752, 232, -160},
    { 936, 320, -216},
    { 1112, 304, -296},
    { 1008, 320, -304},
    { 1152, 328, -280},
    { 1224, 376, -288},
    { 1072, 344, -208},
    { 1160, 352, -152},
    { 1216, 296, -128},
    { 1192, 312, -64},
    { 1000, 232, -8},
    { 824, 160, -64},
    { 752, 160, -64},
    { 728, 128, -32},
    { 808, 136, -24},
    { 840, 136, -16},
    { 872, 120, -24},
    { 1016, 72, -16},
    { 1048, 88, -32},
    { 1216, 120, -120},
    { 1176, 136, -56},
    { 1064, 176, -96},
    { 1184, 216, -112},
    { 1280, 216, -128},
    // 47 seconds
    { 1160, 248, -168},
    { 880, 280, -168},
    { 640, 224, -216},
    { 512, 176, -176},
    { 528, 200, -144},
    { 672, 232, -168},
    { 800, 256, -176},
    { 984, 288, -256},
    { 1056, 304, -288},
    { 1024, 312, -288},
    { 1192, 336, -256},
    { 1200, 368, -256},
    { 1048, 320, -160},
    { 1128, 336, -144},
    { 1224, 304, -144},
    { 1200, 280, -72},
    { 984, 256, -80},
    { 808, 200, -48},
    { 728, 152, -64},
    { 736, 176, -56},
    { 792, 184, -8},
    { 848, 152, -16},
    { 904, 152, 16},
    { 1008, 152, -32},
    { 968, 144, -8},
    // 48 seconds
    { 1152, 216, -56},
    { 1176, 200, -88},
    { 1056, 208, -56},
    { 1120, 216, -112},
    { 1264, 232, -128},
    { 1200, 240, -232},
    { 920, 240, -120},
    { 656, 232, -200},
    { 536, 200, -216},
    { 512, 216, -168},
    { 616, 264, -144},
    { 808, 288, -168},
    { 984, 328, -248},
    { 992, 328, -256},
    { 1032, 328, -288},
    { 1248, 376, -256},
    { 1296, 424, -208},
    { 1000, 344, -144},
    { 1024, 296, -152},
    { 1152, 336, -136},
    { 1168, 288, -88},
    { 1000, 216, -32},
    { 832, 192, -40},
    { 696, 192, -32},
    { 680, 168, -40},
    // 49 seconds
    { 696, 176, -16},
    { 768, 176, -8},
    { 872, 152, -8},
    { 1048, 176, -40},
    { 1032, 136, -48},
    { 1168, 200, -96},
    { 1296, 192, -112},
    { 1112, 176, -128},
    { 1048, 192, -192},
    { 1192, 200, -152},
    { 1136, 240, -160},
    { 888, 248, -144},
    { 672, 248, -152},
    { 560, 216, -160},
    { 536, 184, -136},
    { 624, 208, -120},
    { 744, 248, -152},
    { 872, 328, -168},
    { 1000, 368, -232},
    { 976, 368, -224},
    { 1080, 384, -224},
    { 1208, 400, -232},
    { 1032, 368, -200},
    { 1016, 336, -176},
    { 1128, 336, -160},
    // 50 seconds
    { 1168, 304, -144},
    { 1040, 272, -88},
    { 856, 240, -96},
    { 744, 200, -80},
    { 728, 168, -64},
    { 752, 184, -80},
    { 816, 152, -40},
    { 968, 128, -56},
    { 1040, 112, -24},
    { 1016, 88, 24},
    { 1096, 168, -8},
    { 1200, 192, -32},
    { 1032, 144, -88},
    { 1096, 184, -104},
    { 1216, 176, -192},
    { 1128, 216, -184},
    { 944, 280, -120},
    { 736, 216, -184},
    { 592, 216, -176},
    { 560, 232, -152},
    { 656, 224, -160},
    { 768, 248, -184},
    { 944, 280, -232},
    { 1040, 288, -272},
    { 1064, 320, -320},
    // 51 seconds
    { 1312, 328, -304},
    { 1256, 376, -304},
    { 1008, 312, -224},
    { 1064, 312, -216},
    { 1112, 304, -152},
    { 1064, 232, -96},
    { 944, 248, -48},
    { 832, 216, -56},
    { 776, 192, -40},
    { 776, 184, -40},
    { 824, 216, -24},
    { 880, 144, -16},
    { 984, 136, -8},
    { 1072, 120, -48},
    { 1048, 48, -80},
    { 1232, 80, -144},
    { 1144, 88, -136},
    { 1080, 80, -144},
    { 1232, 128, -152},
    { 1224, 168, -128},
    { 1032, 216, -88},
    { 792, 232, -88},
    { 624, 256, -96},
    { 576, 248, -80},
    { 640, 264, -80},
    // 52 seconds
    { 776, 256, -112},
    { 880, 320, -160},
    { 1080, 352, -256},
    { 1056, 392, -288},
    { 1072, 392, -280},
    { 1312, 464, -288},
    { 1096, 440, -264},
    { 1032, 384, -208},
    { 1072, 360, -224},
    { 1192, 336, -184},
    { 1200, 280, -96},
    { 1032, 224, -80},
    { 896, 224, -56},
    { 872, 176, -72},
    { 864, 224, -40},
    { 896, 144, -16},
    { 872, 128, 0},
    { 992, 112, 0},
    { 992, 120, 0},
    { 1008, 64, 40},
    { 1184, 104, -56},
    { 1160, 160, -48},
    { 1008, 136, -120},
    { 1192, 200, -136},
    { 1192, 216, -120},
    // 53 seconds
    { 1048, 240, -112},
    { 872, 248, -144},
    { 744, 280, -176},
    { 720, 288, -152},
    { 792, 304, -152},
    { 888, 312, -176},
    { 944, 360, -240},
    { 1048, 392, -352},
    { 1024, 376, -360},
    { 1040, 384, -328},
    { 1248, 416, -304},
    { 1088, 392, -280},
    { 1048, 352, -216},
    { 1192, 344, -120},
    { 1288, 296, -56},
    { 1216, 272, 48},
    { 1040, 232, -24},
    { 936, 184, -16},
    { 880, 184, 16},
    { 864, 152, 16},
    { 872, 176, 8},
    { 904, 120, 24},
    { 1000, 64, 8},
    { 920, 16, -32},
    { 984, -16, -72},
    // 54 seconds
    { 1208, 56, -144},
    { 1232, 96, -144},
    { 1064, 128, -184},
    { 1208, 176, -160},
    { 1288, 248, -152},
    { 1128, 272, -144},
    { 904, 288, -144},
    { 728, 312, -168},
    { 680, 248, -120},
    { 704, 240, -112},
    { 816, 304, -144},
    { 888, 376, -216},
    { 1024, 432, -232},
    { 1008, 432, -256},
    { 1080, 432, -240},
    { 1248, 480, -232},
    { 1048, 392, -208},
    { 1008, 352, -192},
    { 1152, 368, -160},
    { 1320, 312, -112},
    { 1200, 248, -64},
    { 1008, 280, 8},
    { 880, 256, -16},
    { 832, 120, 48},
    { 784, 56, 40},
    // 55 seconds
    { 840, 64, 24},
    { 952, 112, -40},
    { 1056, 104, -64},
    { 1008, 64, -56},
    { 1224, 128, -120},
    { 1272, 144, -120},
    { 1088, 136, -192},
    { 1112, 160, -224},
    { 1160, 200, -184},
    { 1024, 224, -192},
    { 808, 216, -136},
    { 672, 232, -176},
    { 640, 256, -152},
    { 680, 240, -128},
    { 808, 280, -144},
    { 920, 304, -224},
    { 1008, 368, -288},
    { 992, 384, -360},
    { 1008, 384, -328},
    { 1248, 400, -296},
    { 1224, 424, -272},
    { 952, 328, -216},
    { 1024, 288, -176},
    { 1184, 280, -176},
    { 1160, 248, -96},
    // 56 seconds
    { 1024, 224, -48},
    { 824, 200, -48},
    { 760, 192, -64},
    { 736, 168, -24},
    { 760, 144, -32},
    { 808, 144, -56},
    { 912, 160, -56},
    { 1032, 168, -152},
    { 1000, 120, -144},
    { 1168, 152, -224},
    { 1144, 192, -168},
    { 936, 192, -168},
    { 984, 200, -184},
    { 1200, 200, -144},
    { 1200, 216, -80},
    { 1016, 248, -88},
    { 744, 248, -128},
    { 584, 264, -136},
    { 560, 264, -120},
    { 632, 248, -128},
    { 776, 256, -168},
    { 904, 296, -232},
    { 1072, 304, -280},
    { 1136, 336, -328},
    { 1368, 392, -312},
    // 57 seconds
    { 1192, 440, -328},
    { 1000, 344, -232},
    { 1048, 344, -208},
    { 1144, 344, -152},
    { 1112, 296, -72},
    { 984, 224, -56},
    { 896, 192, -24},
    { 800, 184, -56},
    { 848, 192, -48},
    { 840, 144, 8},
    { 840, 112, -16},
    { 888, 112, -40},
    { 1024, 80, -72},
    { 1008, 64, -152},
    { 1240, 96, -152},
    { 1176, 168, -136},
    { 1000, 152, -192},
    { 1184, 256, -168},
    { 1256, 256, -176},
    { 1080, 288, -152},
    { 824, 288, -152},
    { 624, 264, -144},
    { 552, 240, -104},
    { 592, 232, -120},
    { 752, 264, -160},
    // 58 seconds
    { 848, 248, -256},
    { 1080, 280, -328},
    { 1024, 320, -368},
    { 1080, 320, -328},
    { 1240, 408, -336},
    { 1048, 368, -288},
    { 1152, 320, -184},
    { 1264, 320, -144},
    { 1264, 328, -64},
    { 1080, 320, 0},
    { 864, 232, -32},
    { 800, 208, -32},
    { 840, 176, -40},
    { 784, 136, 0},
    { 744, 120, 16},
    { 800, 120, 0},
    { 864, 144, -88},
    { 896, 112, -56},
    { 1032, 120, -208},
    { 1208, 128, -144},
    { 1120, 200, -176},
    { 1088, 296, -264},
    { 1240, 368, -272},
    { 1152, 336, -168},
    { 920, 296, -160},
    // 59 seconds
    { 704, 264, -144},
    { 584, 232, -120},
    { 568, 208, -104},
    { 656, 216, -88},
    { 720, 296, -184},
    { 864, 344, -256},
    { 992, 376, -304},
    { 1024, 400, -328},
    { 1216, 400, -288},
    { 1096, 408, -272},
    { 1000, 400, -248},
    { 1144, 376, -184},
    { 1248, 352, -104},
    { 1176, 296, -32},
    { 1032, 248, -40},
    { 864, 216, -24},
    { 792, 184, -56},
    { 768, 184, -48},
    { 768, 160, -48},
    { 776, 136, -32},
    { 840, 136, -104},
    { 912, 128, -144},
    { 960, 88, -160},
    { 1072, 112, -192},
    { 1088, 112, -152},
    // 60 seconds
    // elapsed: 1 minutes
    { 1056, 184, -160},
    { 1072, 256, -152},
    { 1272, 232, -200},
    { 1264, 408, -144},
    { 1008, 304, -160},
    { 736, 280, -136},
    { 592, 312, -120},
    { 576, 256, -88},
    { 640, 176, -24},
    { 776, 272, -136},
    { 920, 256, -200},
    { 1032, 328, -264},
    { 1016, 312, -296},
    { 1280, 360, -304},
    { 1224, 352, -304},
    { 1008, 320, -232},
    { 1016, 328, -208},
    { 1112, 320, -152},
    { 1152, 280, -64},
    { 1024, 264, 8},
    { 872, 192, -8},
    { 792, 184, 0},
    { 768, 248, 0},
    { 792, 144, -32},
    { 808, 152, 0},
    // 61 seconds
    { 936, 152, -32},
    { 1056, 144, -72},
    { 1096, 144, -72},
    { 1080, 152, -176},
    { 1120, 104, -128},
    { 1096, 120, -144},
    { 984, 144, -128},
    { 1096, 200, -176},
    { 1120, 240, -184},
    { 968, 248, -120},
    { 768, 256, -128},
    { 640, 272, -120},
    { 632, 256, -104},
    { 712, 280, -104},
    { 832, 264, -144},
    { 904, 312, -200},
    { 1008, 312, -272},
    { 912, 344, -296},
    { 984, 336, -264},
    { 1352, 448, -320},
    { 1192, 368, -256},
    { 1080, 376, -208},
    { 1096, 360, -152},
    { 1104, 320, -96},
    { 1000, 264, -56},
    // 62 seconds
    { 912, 272, -40},
    { 896, 312, -80},
    { 920, 304, -48},
    { 992, 408, -16},
    { 952, 528, -112},
    { 1008, 704, -272},
    { 1048, 784, -408},
    { 1096, 848, -656},
    { 1152, 656, -856},
    { 1088, 560, -904},
    { 728, 176, -824},
    { 496, -40, -624},
    { 424, -176, -464},
    { 312, -168, -592},
    { 232, -216, -576},
    { 160, -280, -680},
    { 40, -240, -736},
    { 0, -256, -680},
    { -16, -336, -744},
    { -32, -360, -720},
    { -40, -360, -712},
    { -48, -360, -704},
    { -96, -384, -656},
    { -24, -440, -528},
    { 88, -408, -392},
    // 63 seconds
    { 192, -168, -432},
    { 288, -176, -400},
    { 520, 24, -472},
    { 712, 256, -616},
    { 776, 528, -744},
    { 928, 448, -744},
    { 1008, 672, -856},
    { 1016, 720, -928},
    { 944, 1040, -728},
    { 960, 488, -680},
    { 1064, 624, -592},
    { 1200, 768, -456},
    { 1216, 896, -424},
    { 1200, 696, -424},
    { 1032, 544, -336},
    { 696, 648, -112},
    { 752, 520, -136},
    { 936, 408, -136},
    { 1072, 280, -80},
    { 1056, 272, -48},
    { 976, 224, -112},
    { 904, 176, -88},
    { 856, 184, -40},
    { 848, 208, -40},
    { 880, 184, -88},
    // 64 seconds
    { 960, 176, -104},
    { 1032, 136, -128},
    { 1056, 56, -136},
    { 1104, 48, -256},
    { 1216, 56, -208},
    { 1128, 104, -120},
    { 1000, 160, -152},
    { 1152, 200, -120},
    { 1160, 240, -96},
    { 968, 264, -128},
    { 720, 232, -104},
    { 568, 272, -112},
    { 528, 280, -104},
    { 576, 280, -72},
    { 704, 296, -120},
    { 872, 320, -200},
    { 1008, 392, -264},
    { 1032, 384, -320},
    { 1088, 376, -296},
    { 1240, 384, -280},
    { 1128, 392, -272},
    { 1048, 376, -224},
    { 1152, 336, -184},
    { 1272, 288, -136},
    { 1152, 280, -8},
    // 65 seconds
    { 936, 264, -56},
    { 768, 208, -64},
    { 656, 128, -16},
    { 696, 136, -88},
    { 720, 152, -32},
    { 792, 8, 40},
    { 952, 32, 0},
    { 1120, 160, -88},
    { 1112, 152, -104},
    { 1328, 160, -168},
    { 1280, 144, -128},
    { 1128, 184, -200},
    { 1216, 184, -208},
    { 1200, 200, -184},
    { 984, 232, -184},
    { 680, 232, -168},
    { 488, 200, -176},
    { 440, 192, -120},
    { 480, 176, -120},
    { 656, 240, -120},
    { 824, 256, -224},
    { 1080, 280, -264},
    { 1088, 296, -344},
    { 1056, 288, -296},
    { 1288, 400, -280},
    // 66 seconds
    { 1168, 344, -272},
    { 1008, 344, -216},
    { 1184, 368, -192},
    { 1240, 320, -136},
    { 1168, 296, -32},
    { 944, 208, -16},
    { 728, 184, -24},
    { 624, 136, -64},
    { 648, 136, -16},
    { 736, 160, 8},
    { 904, 128, 0},
    { 1072, 160, -16},
    { 1088, 144, 0},
    { 1104, 120, -24},
    { 1208, 128, -152},
    { 1160, 96, -56},
    { 1016, 72, -72},
    { 1320, 200, -72},
    { 1360, 224, -128},
    { 1088, 264, -144},
    { 744, 232, -168},
    { 504, 192, -168},
    { 416, 160, -128},
    { 464, 160, -160},
    { 640, 176, -136},
    // 67 seconds
    { 848, 248, -184},
    { 1176, 296, -256},
    { 1104, 328, -296},
    { 1168, 352, -280},
    { 1272, 384, -272},
    { 1072, 384, -240},
    { 1184, 352, -160},
    { 1216, 336, -120},
    { 1160, 296, -40},
    { 992, 232, -24},
    { 744, 216, -32},
    { 688, 176, -40},
    { 672, 112, 0},
    { 744, 136, 40},
    { 888, 136, 80},
    { 1040, 168, 88},
    { 1104, 208, 64},
    { 1088, 176, 0},
    { 1296, 192, -8},
    { 1240, 128, -8},
    { 1064, 72, -48},
    { 1136, 120, -64},
    { 1240, 120, -104},
    { 1080, 192, -160},
    { 760, 176, -176},
    // 68 seconds
    { 520, 160, -152},
    { 424, 160, -168},
    { 448, 152, -144},
    { 608, 184, -152},
    { 936, 240, -192},
    { 1224, 256, -240},
    { 1136, 272, -264},
    { 1104, 288, -232},
    { 1248, 344, -232},
    { 1112, 304, -248},
    { 992, 288, -208},
    { 1088, 296, -160},
    { 1168, 304, -88},
    { 1088, 264, -64},
    { 848, 232, -16},
    { 696, 176, -72},
    { 640, 152, -64},
    { 688, 136, -48},
    { 808, 128, -24},
    { 912, 48, -24},
    { 1048, 48, -64},
    { 1104, 80, -40},
    { 1160, 72, -56},
    { 1312, 152, -120},
    { 1248, 128, -48},
    // 69 seconds
    { 1168, 152, -96},
    { 1256, 184, -104},
    { 1168, 216, -160},
    { 872, 216, -168},
    { 552, 176, -192},
    { 392, 160, -168},
    { 368, 176, -136},
    { 472, 192, -104},
    { 752, 200, -184},
    { 984, 288, -192},
    { 1104, 336, -240},
    { 1152, 336, -264},
    { 1296, 376, -240},
    { 1200, 392, -288},
    { 1064, 320, -200},
    { 1160, 328, -176},
    { 1232, 344, -160},
    { 1144, 296, -88},
    { 904, 208, -64},
    { 712, 160, -88},
    { 616, 136, -72},
    { 616, 104, -40},
    { 728, 120, -40},
    { 824, 120, -56},
    { 984, 120, -48},
    // 70 seconds
    { 1112, 136, -104},
    { 1080, 112, -88},
    { 1312, 144, -112},
    { 1272, 152, -56},
    { 1120, 176, -56},
    { 1264, 168, -112},
    { 1216, 200, -112},
    { 960, 224, -136},
    { 632, 224, -144},
    { 464, 200, -160},
    { 424, 176, -144},
    { 488, 160, -88},
    { 672, 200, -128},
    { 888, 232, -208},
    { 1064, 320, -256},
    { 1112, 328, -296},
    { 1224, 352, -272},
    { 1376, 368, -264},
    { 1080, 360, -248},
    { 1104, 320, -184},
    { 1200, 288, -152},
    { 1080, 272, -112},
    { 896, 232, -40},
    { 696, 184, -64},
    { 616, 152, -96},
    // 71 seconds
    { 624, 152, -40},
    { 744, 136, -40},
    { 896, 128, -48},
    { 1000, 72, -16},
    { 1200, 72, -56},
    { 1096, 72, -32},
    { 1344, 128, -64},
    { 1200, 160, 8},
    { 1152, 144, -48},
    { 1352, 200, -80},
    { 1192, 240, -144},
    { 856, 256, -144},
    { 568, 184, -232},
    { 416, 88, -144},
    { 408, 136, -96},
    { 536, 168, -176},
    { 776, 176, -192},
    { 984, 240, -232},
    { 1104, 296, -264},
    { 1144, 312, -296},
    { 1296, 352, -272},
    { 1200, 344, -280},
    { 1040, 360, -224},
    { 1152, 352, -168},
    { 1232, 304, -144},
    // 72 seconds
    { 1128, 240, -72},
    { 912, 232, -56},
    { 704, 192, -64},
    { 688, 144, -80},
    { 688, 128, -24},
    { 816, 96, -32},
    { 944, 72, -48},
    { 1032, 24, 8},
    { 1080, 56, -32},
    { 1088, 72, -40},
    { 1248, 112, -32},
    { 1160, 96, -72},
    { 1248, 136, -128},
    { 1376, 184, -136},
    { 1248, 256, -144},
    { 904, 248, -216},
    { 616, 232, -208},
    { 472, 184, -176},
    { 472, 136, -80},
    { 576, 232, -120},
    { 776, 232, -192},
    { 1008, 280, -208},
    { 1104, 296, -288},
    { 1080, 304, -296},
    { 1296, 328, -256},
    // 73 seconds
    { 1256, 368, -272},
    { 1032, 344, -184},
    { 1096, 304, -176},
    { 1152, 312, -144},
    { 1160, 272, -104},
    { 960, 216, -24},
    { 752, 184, -64},
    { 688, 168, -64},
    { 704, 152, -32},
    { 816, 144, -16},
    { 864, 144, 0},
    { 1040, 104, -48},
    { 1136, 120, -24},
    { 1080, 64, -96},
    { 1200, 136, -72},
    { 1168, 120, -72},
    { 1152, 128, -104},
    { 1328, 176, -104},
    { 1240, 224, -144},
    { 960, 224, -216},
    { 632, 208, -208},
    { 480, 200, -192},
    { 440, 160, -160},
    { 552, 176, -88},
    { 760, 224, -200},
    // 74 seconds
    { 968, 328, -248},
    { 1096, 312, -264},
    { 1064, 312, -280},
    { 1160, 352, -256},
    { 1272, 400, -272},
    { 1128, 376, -224},
    { 1168, 376, -176},
    { 1120, 328, -152},
    { 1112, 288, -88},
    { 952, 256, -72},
    { 776, 200, -56},
    { 704, 176, -64},
    { 720, 184, -56},
    { 816, 152, -40},
    { 912, 136, -24},
    { 1024, 104, -16},
    { 1120, 112, -48},
    { 1064, 72, -56},
    { 1152, 96, -152},
    { 1128, 96, -48},
    { 1064, 128, -56},
    { 1256, 192, -96},
    { 1328, 216, -112},
    { 1096, 256, -144},
    { 728, 232, -152},
    // 75 seconds
    { 528, 240, -160},
    { 440, 144, -136},
    { 496, 120, -72},
    { 712, 192, -192},
    { 888, 224, -208},
    { 1104, 272, -280},
    { 1056, 304, -328},
    { 1160, 312, -272},
    { 1328, 384, -296},
    { 1160, 360, -264},
    { 1088, 352, -216},
    { 1128, 304, -176},
    { 1152, 288, -136},
    { 1024, 256, -88},
    { 840, 216, -48},
    { 728, 176, -48},
    { 688, 160, -48},
    { 752, 184, -16},
    { 856, 144, -32},
    { 976, 104, -48},
    { 1112, 72, -40},
    { 1120, 80, -16},
    { 1112, 96, -96},
    { 1136, 136, -64},
    { 1048, 136, -72},
    // 76 seconds
    { 1152, 144, -96},
    { 1320, 216, -128},
    { 1232, 264, -160},
    { 920, 256, -184},
    { 632, 224, -176},
    { 496, 224, -176},
    { 496, 208, -152},
    { 616, 248, -120},
    { 792, 240, -200},
    { 1000, 264, -208},
    { 1088, 328, -312},
    { 1048, 328, -288},
    { 1224, 344, -256},
    { 1168, 392, -256},
    { 1104, 288, -200},
    { 1192, 312, -152},
    { 1224, 312, -152},
    { 1120, 288, -56},
    { 912, 192, -56},
    { 760, 232, -48},
    { 704, 192, -80},
    { 752, 136, -32},
    { 816, 120, -32},
    { 880, 96, 0},
    { 1032, 72, -8},
    // 77 seconds
    { 1056, 96, -16},
    { 1136, 88, -16},
    { 1248, 120, -40},
    { 1160, 120, -32},
    { 1120, 136, -96},
    { 1304, 232, -96},
    { 1200, 256, -168},
    { 936, 264, -184},
    { 656, 240, -160},
    { 512, 200, -184},
    { 496, 176, -160},
    { 608, 216, -160},
    { 792, 240, -224},
    { 1000, 264, -240},
    { 1080, 296, -296},
    { 1128, 328, -304},
    { 1264, 352, -272},
    { 1224, 376, -272},
    { 992, 344, -216},
    { 1120, 352, -152},
    { 1232, 320, -112},
    { 1152, 288, -48},
    { 984, 224, -32},
    { 808, 176, -48},
    { 704, 160, -56},
    // 78 seconds
    { 688, 184, -56},
    { 760, 144, -32},
    { 832, 88, -8},
    { 968, 88, -32},
    { 1104, 88, -32},
    { 1048, 96, -48},
    { 1216, 152, -104},
    { 1256, 144, -32},
    { 1104, 152, -120},
    { 1264, 232, -136},
    { 1272, 256, -184},
    { 1048, 272, -200},
    { 728, 248, -184},
    { 544, 208, -184},
    { 472, 224, -144},
    { 520, 208, -120},
    { 688, 264, -160},
    { 904, 304, -224},
    { 1120, 336, -264},
    { 1056, 328, -280},
    { 1112, 336, -248},
    { 1280, 408, -248},
    { 1072, 376, -192},
    { 1096, 352, -120},
    { 1160, 344, -96},
    // 79 seconds
    { 1192, 320, -40},
    { 1048, 264, -16},
    { 808, 216, -48},
    { 696, 168, -64},
    { 688, 144, -56},
    { 800, 128, -48},
    { 840, 120, 16},
    { 1000, 104, -16},
    { 1096, 104, -16},
    { 1080, 112, -24},
    { 1224, 160, -88},
    { 1168, 152, -32},
    { 1088, 136, -24},
    { 1176, 192, -56},
    { 1216, 216, -128},
    { 1072, 240, -208},
    { 800, 232, -200},
    { 592, 224, -152},
    { 520, 192, -192},
    { 552, 208, -128},
    { 656, 248, -144},
    { 808, 312, -192},
    { 1000, 376, -216},
    { 1072, 392, -272},
    { 1056, 352, -280},
    // 80 seconds
    { 1280, 360, -232},
    { 1248, 416, -256},
    { 984, 328, -184},
    { 1056, 328, -136},
    { 1160, 344, -136},
    { 1120, 304, -48},
    { 944, 248, -40},
    { 800, 200, -64},
    { 712, 184, -48},
    { 736, 160, -56},
    { 800, 144, -16},
    { 840, 96, 8},
    { 1032, 120, -32},
    { 1064, 88, -8},
    { 1032, 120, -64},
    { 1216, 152, -104},
    { 1144, 152, -56},
    { 1072, 136, -80},
    { 1256, 192, -72},
    { 1256, 232, -104},
    { 1072, 272, -152},
    { 768, 264, -176},
    { 576, 216, -168},
    { 504, 200, -168},
    { 552, 216, -128},
    // 81 seconds
    { 712, 248, -176},
    { 864, 272, -208},
    { 1040, 296, -264},
    { 1072, 304, -296},
    { 976, 312, -264},
    { 1320, 344, -216},
    { 1264, 384, -232},
    { 1120, 352, -152},
    { 1000, 344, -184},
    { 1104, 288, -176},
    { 1088, 248, -104},
    { 952, 232, -64},
    { 824, 216, -32},
    { 784, 192, -56},
    { 800, 216, -24},
    { 832, 160, -16},
    { 856, 128, -8},
    { 1000, 80, -32},
    { 1040, 72, -48},
    { 1048, 72, -56},
    { 1184, 136, -120},
    { 1160, 128, -56},
    { 1112, 136, -64},
    { 1272, 232, -88},
    { 1232, 256, -96},
    // 82 seconds
    { 968, 272, -136},
    { 696, 232, -160},
    { 560, 224, -136},
    { 536, 240, -88},
    { 656, 264, -72},
    { 816, 296, -136},
    { 976, 344, -200},
    { 1136, 392, -272},
    { 1064, 400, -304},
    { 1064, 360, -264},
    { 1224, 392, -248},
    { 1056, 352, -208},
    { 1128, 328, -168},
    { 1208, 336, -112},
    { 1192, 296, -64},
    { 1056, 256, -8},
    { 896, 208, 16},
    { 776, 184, 0},
    { 752, 160, 0},
    { 776, 144, 8},
    { 800, 136, 16},
    { 856, 128, 16},
    { 1072, 160, -24},
    { 1032, 96, 0},
    { 1160, 144, -80},
    // 83 seconds
    { 1216, 120, -120},
    { 1152, 128, 8},
    { 1248, 192, -136},
    { 1304, 256, -136},
    { 1152, 264, -160},
    { 824, 256, -168},
    { 560, 216, -184},
    { 464, 184, -128},
    { 504, 168, -96},
    { 672, 264, -128},
    { 848, 248, -208},
    { 1056, 288, -208},
    { 1064, 328, -280},
    { 1080, 352, -272},
    { 1304, 408, -280},
    { 1144, 384, -280},
    { 1032, 312, -168},
    { 1160, 360, -176},
    { 1224, 336, -120},
    { 1104, 272, -56},
    { 896, 192, -40},
    { 728, 176, -56},
    { 688, 184, -64},
    { 720, 168, -24},
    { 800, 160, -24},
    // 84 seconds
    { 912, 120, 8},
    { 1144, 112, -24},
    { 1024, 96, 32},
    { 1120, 152, -48},
    { 1176, 176, -40},
    { 1120, 128, -88},
    { 1160, 160, -48},
    { 1248, 224, -96},
    { 1144, 272, -136},
    { 896, 272, -176},
    { 648, 240, -176},
    { 520, 208, -136},
    { 496, 248, -144},
    { 608, 240, -136},
    { 784, 248, -160},
    { 1032, 280, -208},
    { 1096, 328, -248},
    { 1072, 336, -264},
    { 1248, 368, -232},
    { 1224, 376, -232},
    { 1064, 328, -184},
    { 1128, 328, -144},
    { 1208, 320, -136},
    { 1144, 280, -48},
    { 904, 240, -8},
    // 85 seconds
    { 704, 192, -48},
    { 640, 160, -32},
    { 648, 136, 16},
    { 776, 136, -8},
    { 864, 128, 24},
    { 1088, 136, -16},
    { 1136, 128, 0},
    { 1080, 96, 0},
    { 1304, 144, -64},
    { 1128, 120, 24},
    { 1168, 176, -56},
    { 1352, 200, -32},
    { 1248, 256, -112},
    { 904, 264, -176},
    { 576, 216, -176},
    { 432, 216, -160},
    { 416, 176, -144},
    { 552, 208, -128},
    { 784, 248, -200},
    { 1032, 312, -240},
    { 1104, 320, -288},
    { 1112, 352, -256},
    { 1224, 384, -224},
    { 1200, 400, -232},
    { 1160, 376, -160},
    // 86 seconds
    { 1184, 360, -120},
    { 1240, 344, -80},
    { 1112, 296, 32},
    { 856, 232, -16},
    { 696, 192, -16},
    { 648, 152, -16},
    { 680, 120, 24},
    { 808, 152, -16},
    { 888, 160, -32},
    { 1024, 184, -56},
    { 1096, 184, -40},
    { 1080, 176, -48},
    { 1224, 160, -48},
    { 1136, 160, 32},
    { 1104, 200, -72},
    { 1248, 256, -136},
    { 1168, 256, -144},
    { 904, 256, -168},
    { 624, 232, -160},
    { 488, 184, -184},
    { 480, 144, -152},
    { 584, 232, -152},
    { 776, 240, -192},
    { 1040, 280, -208},
    { 1112, 320, -272},
    // 87 seconds
    { 1080, 328, -232},
    { 1192, 344, -232},
    { 1232, 408, -240},
    { 1008, 328, -192},
    { 1104, 352, -160},
    { 1200, 336, -144},
    { 1176, 304, -80},
    { 1000, 272, -16},
    { 800, 216, 0},
    { 688, 184, -40},
    { 688, 184, 0},
    { 776, 168, 24},
    { 864, 128, 32},
    { 984, 112, 16},
    { 1056, 136, -8},
    { 1056, 120, 16},
    { 1264, 200, -32},
    { 1176, 200, 0},
    { 1064, 192, -56},
    { 1216, 280, -80},
    { 1272, 216, -128},
    { 1064, 280, -152},
    { 720, 264, -168},
    { 504, 256, -144},
    { 440, 192, -152},
    // 88 seconds
    { 520, 208, -104},
    { 720, 248, -168},
    { 936, 280, -192},
    { 1112, 312, -288},
    { 1056, 288, -296},
    { 1176, 304, -272},
    { 1344, 344, -296},
    { 1064, 312, -240},
    { 1072, 304, -160},
    { 1208, 328, -152},
    { 1176, 312, -96},
    { 984, 248, -16},
    { 752, 200, -48},
    { 656, 184, -40},
    { 656, 152, -32},
    { 728, 152, -32},
    { 816, 112, -24},
    { 968, 88, -24},
    { 1136, 120, -56},
    { 1160, 96, -16},
    { 1232, 128, -72},
    { 1192, 152, 16},
    { 1080, 144, -24},
    { 1256, 184, -88},
    { 1240, 240, -88},
    // 89 seconds
    { 1000, 272, -136},
    { 696, 240, -152},
    { 512, 208, -168},
    { 472, 184, -128},
    { 536, 216, -88},
    { 736, 256, -128},
    { 920, 280, -168},
    { 1104, 336, -232},
    { 1048, 360, -288},
    { 1128, 352, -256},
    { 1368, 400, -256},
    { 1096, 376, -240},
    { 1048, 360, -184},
    { 1176, 352, -184},
    { 1176, 304, -112},
    { 1016, 256, -56},
    { 808, 192, -80},
    { 704, 152, -64},
    { 704, 160, -16},
    { 752, 136, 40},
    { 824, 96, -8},
    { 920, 88, 0},
    { 1168, 120, -32},
    { 1120, 96, -40},
    { 1192, 128, -120},
    // 90 seconds
    { 1216, 128, -96},
    { 1136, 128, -72},
    { 1248, 208, -120},
    { 1232, 208, -160},
    { 1024, 248, -200},
    { 736, 224, -184},
    { 536, 200, -160},
    { 472, 184, -160},
    { 552, 208, -120},
    { 704, 240, -144},
    { 840, 280, -176},
    { 1056, 328, -248},
    { 1040, 352, -264},
    { 1056, 336, -256},
    { 1304, 384, -232},
    { 1200, 384, -240},
    { 992, 336, -168},
    { 1032, 336, -168},
    { 1152, 312, -144},
    { 1112, 264, -80},
    { 904, 200, -56},
    { 728, 168, -64},
    { 640, 168, -72},
    { 664, 160, -32},
    { 752, 152, -8},
    // 91 seconds
    { 864, 104, 0},
    { 1064, 112, -40},
    { 1104, 112, -40},
    { 1168, 120, -96},
    { 1264, 160, -80},
    { 1136, 160, -80},
    { 1136, 168, -136},
    { 1280, 208, -144},
    { 1136, 224, -168},
    { 808, 224, -168},
    { 544, 192, -200},
    { 432, 168, -160},
    { 456, 200, -120},
    { 600, 256, -104},
    { 792, 304, -192},
    { 984, 352, -208},
    { 1048, 344, -256},
    { 1040, 368, -224},
    { 1240, 392, -224},
    { 1224, 400, -216},
    { 1016, 360, -160},
    { 1088, 360, -152},
    { 1192, 344, -104},
    { 1144, 280, -32},
    { 880, 208, -16},
    // 92 seconds
    { 688, 176, -56},
    { 608, 216, -64},
    { 640, 168, -40},
    { 752, 144, -32},
    { 800, 152, -8},
    { 1024, 152, -40},
    { 1096, 160, -32},
    { 1016, 160, -56},
    { 1232, 160, -96},
    { 1152, 144, -24},
    { 1056, 120, -56},
    { 1256, 192, -120},
    { 1272, 232, -160},
    { 1040, 248, -168},
    { 704, 232, -144},
    { 536, 192, -192},
    { 504, 152, -144},
    { 560, 192, -104},
    { 712, 240, -176},
    { 840, 264, -184},
    { 1056, 312, -288},
    { 1040, 360, -304},
    { 1128, 352, -240},
    { 1336, 416, -248},
    { 1080, 384, -200},
    // 93 seconds
    { 1160, 408, -136},
    { 1224, 392, -96},
    { 1208, 304, -32},
    { 1024, 232, 16},
    { 792, 208, -40},
    { 696, 176, -24},
    { 696, 176, -24},
    { 744, 176, -16},
    { 832, 136, -16},
    { 928, 152, -32},
    { 1016, 144, 0},
    { 992, 136, -32},
    { 1128, 160, -104},
    { 1104, 168, -72},
    { 1064, 192, -88},
    { 1152, 224, -128},
    { 1272, 240, -152},
    { 1224, 272, -136},
    { 936, 264, -144},
    { 648, 232, -144},
    { 528, 248, -160},
    { 528, 224, -104},
    { 648, 248, -88},
    { 832, 280, -136},
    { 1048, 312, -184},
    // 94 seconds
    { 1112, 360, -256},
    { 1032, 368, -264},
    { 1176, 392, -256},
    { 1256, 400, -240},
    { 1064, 352, -184},
    { 1056, 320, -168},
    { 1128, 320, -120},
    { 1104, 296, -8},
    { 960, 224, 32},
    { 848, 216, -16},
    { 760, 176, 16},
    { 768, 144, 8},
    { 800, 144, 24},
    { 800, 112, 16},
    { 1000, 88, -40},
    { 1096, 80, -24},
    { 1088, 16, -32},
    { 1224, 104, -96},
    { 1208, 136, -56},
    { 1136, 184, -120},
    { 1264, 200, -104},
    { 1256, 240, -136},
    { 1016, 264, -152},
    { 680, 256, -168},
    { 480, 256, -160},
    // 95 seconds
    { 456, 192, -112},
    { 568, 200, -96},
    { 784, 256, -120},
    { 952, 304, -152},
    { 1104, 352, -240},
    { 1056, 352, -304},
    { 1184, 384, -256},
    { 1248, 368, -264},
    { 1120, 368, -216},
    { 1128, 368, -184},
    { 1152, 376, -184},
    { 1064, 296, -128},
    { 920, 264, -120},
    { 728, 184, -104},
    { 632, 184, -120},
    { 696, 208, -80},
    { 784, 160, 0},
    { 888, 160, 24},
    { 1072, 136, 48},
    { 1064, 88, 0},
    { 1048, 64, -72},
    { 1216, 136, -112},
    { 1240, 128, -80},
    { 1112, 144, -120},
    { 1176, 208, -152},
    // 96 seconds
    { 1288, 240, -144},
    { 1080, 248, -152},
    { 736, 224, -144},
    { 496, 192, -144},
    { 400, 200, -112},
    { 424, 200, -64},
    { 600, 216, -80},
    { 792, 288, -200},
    { 1008, 352, -224},
    { 1072, 384, -280},
    { 1112, 368, -232},
    { 1224, 408, -216},
    { 1120, 448, -232},
    { 1120, 392, -168},
    { 1216, 360, -112},
    { 1200, 352, -80},
    { 984, 288, 0},
    { 704, 216, -56},
    { 600, 192, -80},
    { 592, 152, -64},
    { 712, 144, -40},
    { 848, 136, -64},
    { 1000, 120, -24},
    { 1088, 120, -48},
    { 1080, 104, -104},
    // 97 seconds
    { 1136, 152, -176},
    { 1296, 152, -88},
    { 1088, 168, -88},
    { 1184, 208, -184},
    { 1232, 240, -184},
    { 1032, 232, -224},
    { 680, 216, -176},
    { 440, 200, -168},
    { 392, 224, -128},
    { 472, 232, -120},
    { 656, 360, -152},
    { 808, 424, -216},
    { 1008, 408, -232},
    { 1008, 408, -240},
    { 1080, 416, -256},
    { 1264, 416, -224},
    { 1104, 440, -208},
    { 1192, 424, -160},
    { 1264, 392, -80},
    { 1200, 320, -32},
    { 920, 264, -8},
    { 688, 208, -72},
    { 616, 200, -88},
    { 640, 176, -56},
    { 704, 112, -48},
    // 98 seconds
    { 776, 88, -56},
    { 880, 112, -80},
    { 968, 136, -152},
    { 1064, 136, -160},
    { 1208, 168, -200},
    { 1184, 192, -144},
    { 1040, 200, -136},
    { 1224, 264, -168},
    { 1304, 288, -160},
    { 1088, 296, -128},
    { 760, 264, -152},
    { 528, 240, -144},
    { 448, 208, -136},
    { 472, 200, -88},
    { 608, 232, -128},
    { 736, 288, -208},
    { 944, 304, -232},
    { 1064, 344, -280},
    { 1120, 344, -248},
    { 1352, 344, -232},
    { 1104, 328, -216},
    { 1096, 328, -192},
    { 1192, 336, -136},
    { 1176, 320, -72},
    { 944, 280, -40},
    // 99 seconds
    { 704, 200, -80},
    { 600, 176, -72},
    { 608, 192, -88},
    { 744, 200, -56},
    { 872, 184, -16},
    { 920, 144, -16},
    { 1080, 160, -32},
    { 1096, 144, -32},
    { 1120, 168, -96},
    { 1248, 136, -88},
    { 1112, 152, -72},
    { 1200, 168, -152},
    { 1312, 232, -136},
    { 1096, 264, -192},
    { 728, 232, -192},
    { 504, 184, -200},
    { 424, 192, -152},
    { 472, 192, -128},
    { 616, 240, -160},
    { 792, 304, -200},
    { 976, 336, -192},
    { 1040, 392, -280},
    { 1024, 360, -264},
    { 1192, 368, -232},
    { 1104, 384, -256},
    // 100 seconds
    { 1144, 384, -208},
    { 1264, 368, -128},
    { 1256, 336, -72},
    { 1112, 312, -8},
    { 824, 248, -48},
    { 640, 208, -56},
    { 584, 168, -56},
    { 640, 160, -16},
    { 752, 160, -16},
    { 816, 152, 8},
    { 936, 168, -16},
    { 1056, 192, -32},
    { 1056, 192, -104},
    { 1296, 216, -144},
    { 1160, 192, -88},
    { 1032, 176, -184},
    { 1200, 240, -160},
    { 1224, 248, -216},
    { 984, 248, -176},
    { 664, 224, -192},
    { 488, 200, -192},
    { 440, 176, -160},
    { 536, 208, -136},
    { 704, 224, -152},
    { 896, 280, -192},
    // 101 seconds
    { 1048, 304, -232},
    { 1000, 304, -296},
    { 1008, 312, -248},
    { 1248, 360, -224},
    { 1120, 384, -184},
    { 976, 344, -168},
    { 1088, 360, -160},
    { 1248, 344, -160},
    { 1176, 272, -64},
    { 960, 224, -72},
    { 768, 224, -88},
    { 688, 200, -104},
    { 704, 152, -64},
    { 776, 128, -32},
    { 792, 48, -16},
    { 880, 56, -40},
    { 1016, 80, -96},
    { 1032, 64, -104},
    { 1184, 56, -136},
    { 1136, 120, -72},
    { 1176, 232, -48},
    { 1096, 200, -72},
    { 1176, 240, -96},
    { 1216, 288, -112},
    { 1008, 304, -128},
    // 102 seconds
    { 704, 232, -120},
    { 520, 224, -136},
    { 488, 248, -136},
    { 584, 240, -144},
    { 744, 272, -192},
    { 896, 264, -192},
    { 1072, 296, -264},
    { 1008, 312, -304},
    { 1064, 296, -296},
    { 1208, 312, -256},
    { 1072, 312, -224},
    { 1120, 320, -184},
    { 1224, 320, -152},
    { 1264, 304, -88},
    { 1104, 280, -56},
    { 912, 208, 0},
    { 736, 184, -8},
    { 688, 224, -32},
    { 720, 160, -8},
    { 768, 120, 16},
    { 856, 120, 32},
    { 1024, 136, -16},
    { 1008, 152, -16},
    { 1088, 168, -120},
    { 1304, 208, -128},
    // 103 seconds
    { 1144, 184, -96},
    { 1224, 192, -112},
    { 1304, 248, -128},
    { 1144, 256, -144},
    { 832, 240, -152},
    { 584, 216, -160},
    { 480, 160, -144},
    { 496, 176, -112},
    { 656, 224, -112},
    { 864, 248, -160},
    { 1104, 304, -168},
    { 1088, 352, -264},
    { 1104, 336, -232},
    { 1232, 360, -232},
    { 1224, 384, -240},
    { 1128, 360, -184},
    { 1048, 328, -128},
    { 1032, 312, -144},
    { 1032, 304, -80},
    { 888, 272, -64},
    { 816, 216, 0},
    { 800, 136, -48},
    { 816, 104, 24},
    { 816, 112, 48},
    { 840, 128, -24},
    // 104 seconds
    { 984, 96, -56},
    { 1048, 120, -32},
    { 1072, 88, -96},
    { 1288, 104, -112},
    { 1288, 56, -8},
    { 1184, 136, -184},
    { 1272, 208, -152},
    { 1216, 232, -160},
    { 968, 240, -184},
    { 680, 208, -184},
    { 512, 184, -152},
    { 464, 184, -128},
    { 544, 200, -80},
    { 696, 248, -128},
    { 872, 272, -152},
    { 1008, 296, -216},
    { 1088, 336, -264},
    { 1120, 336, -240},
    { 1224, 368, -224},
    { 1096, 400, -232},
    { 1016, 376, -208},
    { 1184, 368, -176},
    { 1272, 312, -120},
    { 1104, 240, -48},
    { 856, 208, -72},
    // 105 seconds
    { 736, 184, -104},
    { 680, 200, -48},
    { 728, 136, -40},
    { 752, 128, 8},
    { 904, 104, -40},
    { 1000, 152, -24},
    { 1032, 120, -64},
    { 1096, 128, -136},
    { 1248, 184, -72},
    { 1096, 128, -80},
    { 1160, 192, -104},
    { 1304, 208, -168},
    { 1200, 264, -184},
    { 904, 248, -152},
    { 632, 224, -192},
    { 496, 224, -136},
    { 496, 208, -128},
    { 592, 200, -96},
    { 720, 264, -136},
    { 896, 328, -160},
    { 1056, 400, -232},
    { 944, 392, -248},
    { 1176, 384, -200},
    { 1416, 472, -240},
    { 1112, 408, -136},
    // 106 seconds
    { 1104, 336, -136},
    { 1144, 368, -144},
    { 1104, 312, -96},
    { 960, 224, -56},
    { 752, 168, -56},
    { 656, 160, -64},
    { 664, 160, -48},
    { 728, 152, -16},
    { 744, 104, 0},
    { 872, 112, -40},
    { 1024, 136, -56},
    { 1080, 168, -80},
    { 1320, 200, -136},
    { 1272, 208, 16},
    { 1088, 184, -40},
    { 1232, 184, -144},
    { 1272, 248, -144},
    { 1072, 256, -128},
    { 744, 232, -168},
    { 536, 232, -160},
    { 472, 200, -144},
    { 512, 160, -112},
    { 640, 216, -112},
    { 784, 216, -232},
    { 944, 256, -248},
    // 107 seconds
    { 1032, 296, -312},
    { 1056, 280, -272},
    { 1304, 344, -272},
    { 1304, 376, -256},
    { 1120, 328, -168},
    { 1136, 296, -120},
    { 1176, 296, -80},
    { 1072, 304, -56},
    { 840, 256, -8},
    { 688, 224, -32},
    { 624, 200, 0},
    { 696, 160, 8},
    { 768, 160, 8},
    { 872, 152, 8},
    { 1032, 160, 8},
    { 1080, 176, -8},
    { 1048, 144, -72},
    { 1208, 176, -144},
    { 1160, 152, -176},
    { 1064, 96, -96},
    { 1224, 224, -128},
    { 1232, 256, -200},
    { 984, 328, -144},
    { 712, 248, -192},
    { 544, 176, -200},
    // 108 seconds
    { 464, 160, -152},
    { 536, 200, -136},
    { 720, 272, -168},
    { 856, 256, -168},
    { 1048, 296, -224},
    { 1016, 320, -256},
    { 1048, 320, -248},
    { 1360, 344, -208},
    { 1144, 344, -200},
    { 1032, 336, -160},
    { 1080, 296, -120},
    { 1160, 280, -104},
    { 1088, 320, -48},
    { 904, 224, -24},
    { 784, 176, -120},
    { 688, 112, -56},
    { 720, 104, -48},
    { 768, 176, -64},
    { 832, 128, -24},
    { 1008, 120, -64},
    { 1120, 96, -48},
    { 1072, 96, -80},
    { 1264, 144, -136},
    { 1216, 136, -96},
    { 1056, 152, -128},
    // 109 seconds
    { 1192, 208, -176},
    { 1216, 216, -176},
    { 984, 232, -152},
    { 680, 200, -176},
    { 536, 184, -168},
    { 488, 176, -144},
    { 560, 176, -120},
    { 720, 208, -144},
    { 856, 240, -160},
    { 1000, 248, -216},
    { 1048, 296, -272},
    { 1056, 288, -296},
    { 1320, 336, -240},
    { 1128, 368, -272},
    { 1040, 352, -232},
    { 1128, 376, -208},
    { 1184, 320, -168},
    { 1096, 256, -72},
    { 928, 232, -56},
    { 784, 200, -72},
    { 736, 192, -32},
    { 752, 208, -40},
    { 848, 152, -16},
    { 872, 128, -8},
    { 976, 144, -40},
    // 110 seconds
    { 1024, 128, -56},
    { 984, 80, -40},
    { 1208, 120, -128},
    { 1144, 104, -72},
    { 1056, 136, -88},
    { 1208, 184, -168},
    { 1224, 216, -176},
    { 1056, 304, -256},
    { 760, 200, -128},
    { 608, 248, -168},
    { 576, 248, -144},
    { 648, 256, -112},
    { 776, 336, -144},
    { 896, 384, -200},
    { 984, 376, -200},
    { 1032, 368, -256},
    { 1088, 352, -248},
    { 1288, 384, -264},
    { 1136, 376, -248},
    { 1016, 360, -200},
    { 1168, 320, -192},
    { 1248, 288, -136},
    { 1120, 224, -72},
    { 856, 168, -24},
    { 704, 152, 8},
    // 111 seconds
    { 640, 160, -24},
    { 680, 176, -40},
    { 720, 168, 0},
    { 856, 160, -8},
    { 1120, 208, -56},
    { 1096, 168, -48},
    { 1144, 144, -80},
    { 1288, 152, -96},
    { 1192, 136, -128},
    { 1008, 128, -200},
    { 1120, 144, -224},
    { 1160, 168, -240},
    { 992, 216, -208},
    { 744, 200, -176},
    { 584, 176, -168},
    { 496, 216, -128},
    { 560, 208, -144},
    { 656, 296, -144},
    { 784, 344, -176},
    { 928, 432, -208},
    { 1008, 464, -288},
    { 944, 440, -272},
    { 1120, 408, -240},
    { 1208, 424, -248},
    { 1048, 384, -200},
    // 112 seconds
    { 1008, 368, -160},
    { 1096, 352, -168},
    { 1128, 304, -104},
    { 984, 240, -64},
    { 840, 216, -88},
    { 736, 200, -88},
    { 704, 176, -80},
    { 712, 144, -72},
    { 744, 136, -56},
    { 840, 152, -96},
    { 960, 128, -136},
    { 1040, 128, -192},
    { 1032, 80, -280},
    { 1176, 88, -256},
    { 1184, 136, -224},
    { 1056, 168, -152},
    { 1192, 232, -200},
    { 1240, 296, -160},
    { 1024, 248, -104},
    { 736, 224, -104},
    { 544, 200, -120},
    { 488, 224, -96},
    { 552, 256, -128},
    { 656, 296, -136},
    { 808, 384, -192},
    // 113 seconds
    { 904, 440, -232},
    { 936, 472, -296},
    { 1000, 440, -328},
    { 1224, 480, -272},
    { 1184, 480, -264},
    { 1064, 448, -248},
    { 1088, 360, -176},
    { 1216, 360, -144},
    { 1136, 280, -80},
    { 944, 232, -88},
    { 832, 216, -80},
    { 776, 192, -80},
    { 792, 184, -48},
    { 776, 120, -40},
    { 800, 72, -16},
    { 888, 80, -88},
    { 944, 88, -80},
    { 976, 80, -120},
    { 1144, 120, -184},
    { 1184, 128, -176},
    { 1168, 160, -104},
    { 1288, 224, -160},
    { 1336, 224, -160},
    { 1136, 248, -152},
    { 824, 272, -152},
    // 114 seconds
    { 616, 240, -160},
    { 552, 224, -160},
    { 600, 272, -128},
    { 704, 272, -136},
    { 824, 320, -168},
    { 984, 376, -240},
    { 1016, 424, -264},
    { 1024, 424, -272},
    { 1160, 440, -224},
    { 1120, 416, -248},
    { 1112, 424, -216},
    { 1304, 384, -120},
    { 1296, 336, -80},
    { 1192, 224, -24},
    { 984, 160, -104},
    { 800, 152, -32},
    { 808, 160, 40},
    { 776, 152, 24},
    { 856, 160, 32},
    { 728, 144, 32},
    { 760, 80, 56},
    { 944, 56, -40},
    { 984, 40, -176},
    { 1232, 80, -192},
    { 1256, 128, -200},
    // 115 seconds
    { 1216, 168, -168},
    { 1312, 248, -272},
    { 1328, 296, -248},
    { 1104, 296, -200},
    { 800, 264, -200},
    { 576, 240, -192},
    { 520, 192, -120},
    { 552, 184, -96},
    { 672, 264, -120},
    { 840, 264, -192},
    { 960, 296, -168},
    { 1032, 328, -256},
    { 1064, 360, -240},
    { 1240, 384, -200},
    { 1088, 400, -256},
    { 1120, 400, -232},
    { 1216, 352, -176},
    { 1216, 304, -112},
    { 1096, 248, -72},
    { 976, 224, -48},
    { 832, 184, -48},
    { 784, 192, -64},
    { 856, 192, -40},
    { 808, 128, 0},
    { 816, 104, -32},
    // 116 seconds
    { 912, 88, -64},
    { 984, 72, -64},
    { 1008, 88, -168},
    { 1144, 184, -176},
    { 1088, 152, -128},
    { 1160, 192, -144},
    { 1328, 264, -192},
    { 1240, 264, -184},
    { 968, 272, -144},
    { 720, 264, -152},
    { 584, 232, -168},
    { 592, 232, -104},
    { 680, 256, -136},
    { 776, 240, -144},
    { 896, 320, -224},
    { 1008, 352, -264},
    { 1032, 384, -320},
    { 1128, 392, -240},
    { 1264, 448, -264},
    { 1024, 384, -200},
    { 1056, 408, -176},
    { 1256, 376, -144},
    { 1200, 288, -64},
    { 1048, 264, -32},
    { 920, 224, -8},
    // 117 seconds
    { 872, 200, -24},
    { 832, 160, -16},
    { 808, 176, -8},
    { 816, 128, 0},
    { 848, 112, 24},
    { 904, 144, -24},
    { 992, 144, -64},
    { 1120, 152, -184},
    { 1200, 160, -96},
    { 1104, 176, -96},
    { 1136, 248, -168},
    { 1272, 288, -176},
    { 1168, 272, -152},
    { 904, 256, -144},
    { 680, 232, -144},
    { 600, 224, -160},
    { 624, 248, -120},
    { 720, 248, -144},
    { 816, 272, -184},
    { 944, 352, -256},
    { 1048, 376, -312},
    { 1088, 400, -296},
    { 1136, 384, -256},
    { 1032, 400, -256},
    { 992, 392, -280},
    // 118 seconds
    { 1112, 368, -160},
    { 1296, 320, -96},
    { 1296, 328, 32},
    { 1128, 272, 0},
    { 904, 216, -24},
    { 784, 184, -24},
    { 808, 184, -40},
    { 808, 168, 0},
    { 808, 152, 8},
    { 888, 152, -8},
    { 952, 184, -40},
    { 888, 152, -120},
    { 1096, 224, -192},
    { 1056, 8, -168},
    { 1080, 128, -160},
    { 1280, 216, -216},
    { 1336, 312, -216},
    { 1144, 312, -168},
    { 856, 320, -152},
    { 648, 232, -208},
    { 552, 176, -144},
    { 536, 216, -120},
    { 672, 264, -160},
    { 832, 216, -184},
    { 1000, 280, -256},
    // 119 seconds
    { 1056, 312, -264},
    { 1064, 368, -272},
    { 1352, 400, -232},
    { 1152, 416, -224},
    { 976, 368, -208},
    { 1200, 368, -192},
    { 1248, 272, -144},
    { 1184, 224, -104},
    { 984, 176, -40},
    { 784, 184, -80},
    { 704, 152, -80},
    { 736, 144, 0},
    { 736, 128, -16},
    { 800, 120, 16},
    { 880, 112, 48},
    { 1008, 128, -32},
    { 1024, 128, -96},
    { 1272, 184, -144},
    { 1208, 208, -136},
    { 984, 192, -184},
    { 1120, 280, -240},
    { 1232, 288, -184},
    { 1072, 296, -120},
    { 800, 256, -144},
    { 624, 216, -160},
    // 120 seconds
    // elapsed: 2 minutes
    { 544, 192, -128},
    { 544, 192, -80},
    { 600, 200, -104},
    { 808, 240, -112},
    { 1024, 304, -208},
    { 1056, 328, -232},
    { 1168, 352, -256},
    { 1384, 408, -288},
    { 1080, 352, -248},
    { 1040, 344, -208},
    { 1168, 384, -192},
    { 1120, 320, -136},
    { 984, 248, -80},
    { 800, 200, -64},
    { 728, 192, -56},
    { 720, 168, -48},
    { 784, 184, -32},
    { 816, 152, -8},
    { 872, 152, 8},
    { 1008, 184, -16},
    { 1016, 208, -32},
    { 1000, 176, -72},
    { 1128, 208, -104},
    { 1096, 144, -88},
    { 1104, 168, -128},
    // 121 seconds
    { 1232, 248, -176},
    { 1176, 240, -152},
    { 968, 248, -136},
    { 728, 240, -144},
    { 576, 224, -136},
    { 544, 232, -136},
    { 616, 248, -120},
    { 720, 240, -184},
    { 848, 280, -216},
    { 992, 320, -264},
    { 1080, 360, -272},
    { 1240, 376, -216},
    { 1312, 440, -200},
    { 1120, 392, -104},
    { 1016, 328, -72},
    { 1104, 312, -104},
    { 1072, 256, 16},
    { 880, 224, 16},
    { 808, 176, 24},
    { 800, 216, 56},
    { 808, 288, 80},
    { 872, 256, 88},
    { 864, 392, -8},
    { 928, 496, -112},
    { 1000, 536, -128},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:08:41 local
AccelRawData *activity_sample_walk_200_pbl_25656_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25656_10
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -368, 608, 472},
    { -392, 624, 464},
    { -384, 680, 400},
    { -384, 904, 320},
    { -392, 784, 344},
    { -408, 848, 312},
    { -344, 768, 360},
    { -376, 896, 392},
    { -312, 800, 256},
    { -352, 688, 368},
    { -528, 864, 248},
    { -504, 960, 192},
    { -528, 1112, 128},
    { -568, 992, 256},
    { -488, 864, -136},
    { -480, 752, -288},
    { -424, 272, -544},
    { -416, 328, -632},
    { -376, 104, -776},
    { -368, -88, -816},
    { -280, 72, -872},
    { -160, -232, -904},
    { -160, -208, -1080},
    { -152, -232, -1128},
    { -152, -312, -1064},
    // 1 seconds
    { -160, -320, -912},
    { -240, -264, -1008},
    { -264, -144, -976},
    { -224, -128, -952},
    { -56, -288, -904},
    { -184, -144, -968},
    { -224, -136, -1064},
    { -224, -104, -944},
    { -256, -200, -968},
    { -288, -200, -936},
    { -256, -184, -920},
    { -320, -104, -1008},
    { -296, -288, -976},
    { -120, -208, -960},
    { 8, -184, -920},
    { -432, -360, -816},
    { -72, -400, -656},
    { 0, 104, -648},
    { 8, 584, -664},
    { -64, 968, -520},
    { -144, 1184, -224},
    { -232, 1288, 40},
    { -320, 1200, -32},
    { -312, 992, 184},
    { -320, 984, 240},
    // 2 seconds
    { -360, 960, 256},
    { -336, 960, 368},
    { -344, 848, 464},
    { -328, 920, 336},
    { -320, 816, 352},
    { -328, 760, 304},
    { -336, 808, 336},
    { -328, 808, 296},
    { -336, 760, 272},
    { -328, 816, 248},
    { -328, 760, 272},
    { -336, 816, 200},
    { -328, 816, 192},
    { -336, 808, 216},
    { -344, 832, 176},
    { -344, 832, 200},
    { -336, 888, 192},
    { -328, 864, 168},
    { -328, 856, 128},
    { -296, 784, 112},
    { -296, 720, 88},
    { -296, 744, 128},
    { -344, 760, 120},
    { -376, 760, 80},
    { -400, 760, 48},
    // 3 seconds
    { -336, 824, 0},
    { -304, 816, 0},
    { -168, 888, 0},
    { -88, 832, -64},
    { 48, 744, -184},
    { 192, 704, -144},
    { 256, 776, -248},
    { 360, 720, -256},
    { 480, 712, -288},
    { 616, 872, -392},
    { 728, 656, -368},
    { 848, 592, -472},
    { 968, 520, -328},
    { 1272, 504, -112},
    { 1424, 488, -88},
    { 1400, 504, -56},
    { 968, 400, -16},
    { 776, 256, -16},
    { 848, 192, 16},
    { 928, 264, 0},
    { 960, 296, -48},
    { 864, 264, -56},
    { 800, 232, -72},
    { 776, 256, -152},
    { 704, 256, -224},
    // 4 seconds
    { 688, 264, -304},
    { 776, 224, -328},
    { 976, 240, -376},
    { 1024, 272, -432},
    { 936, 232, -336},
    { 1256, 304, -368},
    { 1168, 368, -368},
    { 1088, 344, -200},
    { 1032, 304, -200},
    { 1224, 360, -184},
    { 1248, 304, -104},
    { 1064, 232, -8},
    { 888, 216, -16},
    { 800, 216, -48},
    { 800, 184, -40},
    { 792, 152, -16},
    { 856, 112, 0},
    { 920, 80, -48},
    { 968, 56, -80},
    { 1016, 40, -128},
    { 1080, 0, -112},
    { 1184, 56, -88},
    { 1216, 112, -112},
    { 1320, 168, -112},
    { 1344, 208, -88},
    // 5 seconds
    { 1096, 248, -120},
    { 784, 264, -200},
    { 536, 248, -192},
    { 456, 256, -184},
    { 544, 272, -192},
    { 696, 288, -288},
    { 872, 312, -344},
    { 1088, 320, -328},
    { 1216, 384, -328},
    { 1088, 376, -248},
    { 1136, 360, -232},
    { 1248, 392, -256},
    { 1416, 352, -160},
    { 1488, 304, -32},
    { 1360, 232, 104},
    { 968, 208, 16},
    { 792, 104, -48},
    { 656, -72, 8},
    { 592, -40, 56},
    { 712, -40, 8},
    { 880, -40, -16},
    { 1192, 16, -32},
    { 1232, 0, -80},
    { 1136, -32, -192},
    { 1408, 64, -112},
    // 6 seconds
    { 1280, 16, -32},
    { 1368, 104, -144},
    { 1456, 208, -208},
    { 1184, 224, -216},
    { 752, 176, -224},
    { 456, 152, -136},
    { 360, 168, -216},
    { 416, 192, -152},
    { 592, 224, -192},
    { 848, 280, -200},
    { 1200, 336, -288},
    { 1184, 416, -312},
    { 1136, 352, -232},
    { 1144, 360, -224},
    { 1128, 392, -208},
    { 1424, 360, -104},
    { 1512, 304, -8},
    { 1256, 256, 8},
    { 864, 192, -40},
    { 664, 120, -96},
    { 632, 40, -32},
    { 672, -32, -64},
    { 864, -120, -64},
    { 1208, -24, -56},
    { 1392, -24, -40},
    // 7 seconds
    { 1280, 0, -24},
    { 1304, -8, -104},
    { 1360, 88, 64},
    { 1320, 32, -104},
    { 1456, 152, -80},
    { 1240, 136, -128},
    { 840, 128, -144},
    { 472, 112, -216},
    { 296, 120, -272},
    { 280, 112, -232},
    { 456, 112, -232},
    { 808, 168, -248},
    { 1360, 312, -312},
    { 1192, 384, -344},
    { 1184, 328, -248},
    { 1056, 312, -192},
    { 984, 400, -232},
    { 928, 312, -208},
    { 1232, 320, -88},
    { 1392, 312, -24},
    { 1240, 256, 64},
    { 880, 224, -48},
    { 696, 192, -56},
    { 640, 152, -56},
    { 688, 128, -40},
    // 8 seconds
    { 816, 32, -32},
    { 1024, 0, 16},
    { 1224, 16, -64},
    { 1208, 48, -48},
    { 1152, -32, -136},
    { 1344, 40, -96},
    { 1064, 24, -120},
    { 1224, 48, -176},
    { 1328, 104, -144},
    { 1104, 168, -192},
    { 744, 128, -248},
    { 488, 32, -232},
    { 392, 80, -192},
    { 440, 192, -152},
    { 640, 248, -192},
    { 936, 264, -224},
    { 1192, 272, -320},
    { 1112, 264, -352},
    { 1168, 288, -296},
    { 1288, 288, -224},
    { 1136, 328, -256},
    { 1192, 272, -168},
    { 1232, 232, -64},
    { 1200, 272, -80},
    { 984, 232, -40},
    // 9 seconds
    { 712, 176, -40},
    { 632, 152, -80},
    { 672, 136, -48},
    { 792, 104, 0},
    { 912, 96, -48},
    { 1064, 72, -32},
    { 1192, 88, -72},
    { 1224, 64, -128},
    { 1360, 72, -32},
    { 1184, 152, -64},
    { 1064, 72, -168},
    { 1336, 136, -80},
    { 1176, 104, -80},
    { 840, 160, -144},
    { 528, 144, -208},
    { 416, 112, -264},
    { 400, 160, -120},
    { 488, 184, -184},
    { 776, 168, -256},
    { 1120, 216, -272},
    { 1240, 264, -376},
    { 1176, 288, -312},
    { 1392, 320, -240},
    { 1224, 376, -240},
    { 1136, 304, -192},
    // 10 seconds
    { 1176, 272, -136},
    { 1152, 240, -152},
    { 984, 232, -112},
    { 784, 184, -96},
    { 680, 168, -56},
    { 704, 176, -48},
    { 768, 128, -32},
    { 880, 112, -24},
    { 1008, 64, -32},
    { 1160, 40, -96},
    { 1144, 48, -96},
    { 1272, 56, -104},
    { 1240, 96, -16},
    { 1096, 56, -64},
    { 1304, 104, -80},
    { 1304, 112, -56},
    { 1016, 144, -136},
    { 688, 192, -184},
    { 472, 200, -200},
    { 392, 192, -152},
    { 464, 200, -112},
    { 664, 208, -152},
    { 1032, 248, -160},
    { 1328, 304, -256},
    { 1112, 328, -256},
    // 11 seconds
    { 1232, 328, -256},
    { 1352, 368, -272},
    { 1144, 344, -224},
    { 1128, 280, -160},
    { 1136, 296, -200},
    { 1056, 216, -136},
    { 872, 168, -128},
    { 696, 168, -120},
    { 640, 184, -104},
    { 704, 168, -40},
    { 808, 168, -32},
    { 888, 104, 8},
    { 1096, 80, -24},
    { 1128, 80, -32},
    { 1144, 80, -48},
    { 1264, 136, -64},
    { 1160, 144, -80},
    { 1104, 88, -96},
    { 1304, 160, -56},
    { 1216, 208, -104},
    { 928, 216, -160},
    { 608, 200, -168},
    { 448, 160, -240},
    { 416, 128, -144},
    { 528, 152, -96},
    // 12 seconds
    { 736, 248, -144},
    { 960, 288, -200},
    { 1104, 352, -296},
    { 1016, 376, -328},
    { 1056, 336, -296},
    { 1288, 344, -264},
    { 1152, 344, -224},
    { 1248, 368, -160},
    { 1272, 344, -88},
    { 1168, 288, -40},
    { 960, 256, -40},
    { 744, 200, -88},
    { 640, 160, -64},
    { 616, 136, -48},
    { 704, 136, -32},
    { 816, 120, -56},
    { 808, 80, -8},
    { 984, 80, -80},
    { 1120, 112, -96},
    { 1104, 96, -160},
    { 1264, 96, -104},
    { 1224, 96, 0},
    { 1360, 184, -120},
    { 1392, 208, -184},
    { 1120, 232, -184},
    // 13 seconds
    { 736, 192, -168},
    { 504, 200, -184},
    { 408, 192, -192},
    { 456, 168, -112},
    { 600, 248, -160},
    { 752, 336, -184},
    { 984, 384, -208},
    { 1120, 432, -208},
    { 1192, 456, -184},
    { 1320, 488, -184},
    { 1192, 432, -136},
    { 1264, 344, -48},
    { 1256, 328, -72},
    { 1080, 264, -64},
    { 808, 216, -32},
    { 608, 160, -88},
    { 544, 120, -48},
    { 608, 96, 0},
    { 760, 96, -32},
    { 848, 72, -16},
    { 1040, 104, -80},
    { 1160, 128, -88},
    { 1152, 104, -144},
    { 1344, 176, -104},
    { 1160, 144, -64},
    // 14 seconds
    { 1216, 152, -144},
    { 1360, 208, -152},
    { 1136, 200, -152},
    { 760, 216, -208},
    { 440, 200, -248},
    { 352, 184, -216},
    { 384, 144, -176},
    { 576, 184, -128},
    { 792, 264, -232},
    { 1040, 344, -224},
    { 1048, 376, -248},
    { 1096, 344, -232},
    { 1176, 360, -184},
    { 1120, 376, -192},
    { 1120, 384, -176},
    { 1240, 336, -104},
    { 1208, 296, -56},
    { 1096, 256, -32},
    { 816, 200, -88},
    { 648, 184, -88},
    { 600, 152, -80},
    { 648, 160, -96},
    { 736, 144, -72},
    { 840, 128, -80},
    { 1040, 160, -128},
    // 15 seconds
    { 1144, 144, -152},
    { 1104, 88, -208},
    { 1216, 128, -184},
    { 1160, 136, -160},
    { 1072, 136, -144},
    { 1296, 224, -160},
    { 1200, 184, -184},
    { 912, 216, -152},
    { 592, 208, -136},
    { 440, 184, -160},
    { 416, 176, -112},
    { 536, 184, -80},
    { 736, 232, -144},
    { 1000, 280, -200},
    { 1136, 304, -208},
    { 1064, 296, -248},
    { 1160, 288, -208},
    { 1288, 336, -208},
    { 1064, 376, -208},
    { 1056, 352, -192},
    { 1144, 368, -184},
    { 1128, 288, -160},
    { 992, 184, -88},
    { 760, 168, -104},
    { 672, 184, -96},
    // 16 seconds
    { 680, 160, -104},
    { 760, 144, -48},
    { 856, 112, -24},
    { 976, 112, -64},
    { 1056, 136, -112},
    { 1072, 152, -120},
    { 1072, 88, -128},
    { 1120, 104, -96},
    { 1112, 128, -48},
    { 1216, 168, -40},
    { 1280, 208, -80},
    { 1112, 240, -128},
    { 832, 232, -168},
    { 584, 208, -176},
    { 512, 176, -136},
    { 528, 152, -128},
    { 640, 200, -144},
    { 736, 232, -224},
    { 928, 272, -232},
    { 1088, 296, -320},
    { 1176, 312, -328},
    { 1360, 312, -264},
    { 1264, 336, -256},
    { 1136, 312, -152},
    { 1176, 328, -128},
    // 17 seconds
    { 1160, 304, -120},
    { 1032, 256, -64},
    { 816, 192, -32},
    { 696, 160, -32},
    { 680, 144, -64},
    { 728, 136, -16},
    { 808, 136, 0},
    { 840, 88, -24},
    { 984, 120, -40},
    { 1096, 128, -56},
    { 1072, 96, -136},
    { 1192, 160, -136},
    { 1136, 160, -104},
    { 1240, 200, -80},
    { 1312, 168, -168},
    { 1144, 176, -168},
    { 856, 168, -232},
    { 624, 160, -192},
    { 496, 168, -160},
    { 488, 192, -128},
    { 560, 216, -144},
    { 696, 216, -208},
    { 912, 264, -232},
    { 1032, 280, -296},
    { 1152, 312, -264},
    // 18 seconds
    { 1312, 312, -224},
    { 1280, 360, -232},
    { 1120, 368, -176},
    { 1144, 360, -128},
    { 1208, 328, -136},
    { 1136, 288, -80},
    { 880, 216, -64},
    { 712, 192, -72},
    { 696, 136, -48},
    { 736, 136, -48},
    { 832, 112, 16},
    { 896, 48, 16},
    { 1032, 64, -32},
    { 1040, 40, 8},
    { 1096, 72, -72},
    { 1224, 160, -104},
    { 1216, 184, -176},
    { 1192, 192, -128},
    { 1280, 248, -168},
    { 1160, 288, -240},
    { 848, 280, -208},
    { 552, 248, -200},
    { 448, 192, -200},
    { 448, 176, -88},
    { 576, 208, -112},
    // 19 seconds
    { 712, 224, -176},
    { 984, 264, -216},
    { 1152, 320, -296},
    { 1144, 328, -256},
    { 1360, 368, -224},
    { 1184, 392, -224},
    { 1072, 344, -144},
    { 1160, 328, -112},
    { 1144, 304, -104},
    { 1024, 256, -48},
    { 840, 208, -40},
    { 728, 184, -32},
    { 696, 160, -48},
    { 744, 152, -40},
    { 816, 112, -16},
    { 856, 64, 0},
    { 1008, 40, -72},
    { 1104, 80, -48},
    { 1152, 88, -128},
    { 1272, 152, -112},
    { 1160, 160, -80},
    { 1264, 184, -136},
    { 1328, 240, -104},
    { 1120, 256, -112},
    { 784, 240, -112},
    // 20 seconds
    { 536, 224, -168},
    { 432, 184, -128},
    { 456, 168, -104},
    { 552, 200, -96},
    { 736, 248, -168},
    { 1072, 288, -208},
    { 1176, 352, -296},
    { 1088, 344, -280},
    { 1280, 344, -232},
    { 1208, 368, -216},
    { 1040, 328, -184},
    { 1184, 352, -160},
    { 1200, 304, -128},
    { 1168, 280, -32},
    { 928, 200, 0},
    { 736, 152, -8},
    { 656, 144, -8},
    { 704, 136, 0},
    { 744, 128, 16},
    { 808, 112, 0},
    { 976, 136, -8},
    { 1016, 144, -8},
    { 1072, 160, -64},
    { 1184, 192, -72},
    { 1136, 208, -40},
    // 21 seconds
    { 1152, 184, -64},
    { 1328, 168, -24},
    { 1336, 208, -72},
    { 1056, 240, -152},
    { 704, 192, -136},
    { 528, 192, -152},
    { 472, 200, -152},
    { 544, 184, -160},
    { 688, 208, -176},
    { 920, 232, -240},
    { 1080, 272, -296},
    { 1136, 304, -296},
    { 1160, 304, -240},
    { 1328, 336, -216},
    { 1080, 344, -216},
    { 1096, 320, -144},
    { 1176, 312, -120},
    { 1176, 272, -80},
    { 1024, 208, -32},
    { 824, 168, -32},
    { 728, 176, -40},
    { 728, 160, -24},
    { 768, 136, 0},
    { 816, 128, 0},
    { 896, 120, -32},
    // 22 seconds
    { 1024, 136, -88},
    { 1000, 144, -104},
    { 1032, 88, -184},
    { 1216, 112, -128},
    { 1112, 96, -72},
    { 1168, 176, -88},
    { 1336, 288, -136},
    { 1192, 256, -152},
    { 904, 280, -128},
    { 616, 240, -192},
    { 488, 208, -120},
    { 480, 176, -96},
    { 608, 216, -88},
    { 768, 248, -136},
    { 968, 304, -192},
    { 1088, 376, -256},
    { 1056, 352, -232},
    { 1216, 344, -168},
    { 1240, 392, -184},
    { 1056, 360, -152},
    { 1232, 360, -144},
    { 1288, 304, -104},
    { 1136, 232, -96},
    { 936, 168, -104},
    { 776, 144, -88},
    // 23 seconds
    { 640, 96, -64},
    { 632, 136, -56},
    { 728, 112, -40},
    { 752, 88, -24},
    { 952, 120, -48},
    { 1088, 168, -64},
    { 1048, 144, -96},
    { 1296, 112, -120},
    { 1224, 168, -40},
    { 1104, 144, -88},
    { 1304, 192, -80},
    { 1280, 224, -88},
    { 992, 256, -128},
    { 680, 200, -128},
    { 480, 176, -128},
    { 400, 200, -104},
    { 488, 176, -136},
    { 664, 208, -168},
    { 968, 256, -240},
    { 1176, 312, -312},
    { 1088, 288, -304},
    { 1208, 272, -224},
    { 1352, 320, -264},
    { 1096, 296, -144},
    { 1088, 280, -96},
    // 24 seconds
    { 1152, 256, -152},
    { 1144, 232, -96},
    { 992, 208, -48},
    { 776, 192, -48},
    { 664, 192, -64},
    { 656, 184, -64},
    { 752, 136, -32},
    { 840, 136, 16},
    { 1008, 104, -24},
    { 1112, 120, -24},
    { 968, 96, -160},
    { 1192, 128, -144},
    { 1160, 128, -160},
    { 1072, 128, -144},
    { 1216, 136, -112},
    { 1224, 200, -120},
    { 1048, 216, -208},
    { 752, 224, -192},
    { 544, 192, -168},
    { 480, 160, -120},
    { 576, 200, -144},
    { 696, 264, -136},
    { 848, 328, -160},
    { 1000, 376, -192},
    { 1024, 400, -248},
    // 25 seconds
    { 1056, 392, -208},
    { 1432, 432, -160},
    { 1208, 424, -176},
    { 1032, 376, -168},
    { 1128, 336, -120},
    { 1184, 280, -88},
    { 1096, 224, -56},
    { 896, 176, -40},
    { 720, 176, -64},
    { 696, 144, -40},
    { 720, 112, -8},
    { 776, 88, -8},
    { 880, 80, -32},
    { 1032, 112, -32},
    { 1080, 104, -80},
    { 1120, 120, -112},
    { 1264, 128, -104},
    { 1152, 168, -24},
    { 1120, 160, -96},
    { 1216, 232, -152},
    { 1112, 264, -224},
    { 840, 208, -176},
    { 608, 216, -152},
    { 512, 208, -168},
    { 536, 224, -136},
    // 26 seconds
    { 624, 208, -128},
    { 768, 240, -160},
    { 928, 280, -216},
    { 1008, 320, -256},
    { 984, 320, -232},
    { 1152, 336, -160},
    { 1368, 392, -216},
    { 1136, 376, -200},
    { 1224, 328, -128},
    { 1296, 296, -88},
    { 1144, 264, -48},
    { 880, 208, -56},
    { 712, 160, -56},
    { 632, 144, -56},
    { 664, 104, -24},
    { 752, 104, -32},
    { 808, 120, -48},
    { 920, 104, -96},
    { 1104, 120, -88},
    { 1136, 72, -104},
    { 1440, 168, -104},
    { 1312, 192, -48},
    { 1216, 184, -144},
    { 1352, 240, -144},
    { 1184, 240, -128},
    // 27 seconds
    { 816, 232, -152},
    { 496, 224, -208},
    { 376, 168, -192},
    { 424, 160, -144},
    { 608, 200, -136},
    { 880, 272, -184},
    { 1088, 368, -264},
    { 1120, 408, -272},
    { 1168, 384, -232},
    { 1376, 416, -216},
    { 1080, 392, -208},
    { 976, 312, -144},
    { 1088, 336, -152},
    { 1184, 312, -120},
    { 1048, 240, -56},
    { 816, 176, -48},
    { 656, 176, -64},
    { 648, 136, -64},
    { 600, 64, -16},
    { 712, 56, -32},
    { 776, 72, -24},
    { 912, 104, -56},
    { 976, 88, -56},
    { 1000, 104, -120},
    { 1472, 168, -72},
    // 28 seconds
    { 1584, 200, 24},
    { 1336, 200, -280},
    { 1448, 248, -184},
    { 1192, 200, -112},
    { 736, 184, -168},
    { 408, 184, -216},
    { 344, 168, -200},
    { 408, 160, -112},
    { 584, 200, -96},
    { 848, 240, -176},
    { 1224, 352, -264},
    { 1256, 400, -280},
    { 1336, 376, -200},
    { 1328, 368, -216},
    { 1120, 392, -168},
    { 1048, 312, -96},
    { 1120, 328, -128},
    { 1128, 312, -112},
    { 936, 240, -48},
    { 752, 192, -32},
    { 704, 192, -56},
    { 720, 168, -56},
    { 776, 120, 0},
    { 920, 88, -16},
    { 1080, 128, 8},
    // 29 seconds
    { 1128, 72, -40},
    { 1128, 80, -32},
    { 1288, 104, -8},
    { 1280, 104, -24},
    { 1192, 112, -32},
    { 1232, 136, -48},
    { 1128, 176, -64},
    { 912, 208, -136},
    { 648, 208, -176},
    { 472, 192, -144},
    { 464, 168, -176},
    { 568, 152, -152},
    { 744, 168, -176},
    { 1024, 200, -224},
    { 1232, 264, -272},
    { 1208, 264, -280},
    { 1344, 304, -240},
    { 1280, 352, -232},
    { 1000, 328, -200},
    { 984, 288, -152},
    { 1120, 328, -160},
    { 1112, 296, -120},
    { 912, 232, -64},
    { 720, 192, -64},
    { 632, 192, -72},
    // 30 seconds
    { 688, 168, -72},
    { 832, 144, -48},
    { 952, 104, -24},
    { 1112, 96, -48},
    { 1072, 128, -64},
    { 1128, 152, -88},
    { 1216, 144, -80},
    { 1176, 96, -24},
    { 1112, 112, 8},
    { 1216, 96, -72},
    { 1160, 184, -104},
    { 920, 200, -152},
    { 632, 160, -168},
    { 464, 112, -152},
    { 448, 104, -152},
    { 544, 176, -96},
    { 720, 216, -192},
    { 1000, 272, -176},
    { 1160, 296, -296},
    { 1184, 352, -320},
    { 1216, 320, -256},
    { 1200, 304, -216},
    { 1032, 328, -232},
    { 1120, 360, -208},
    { 1216, 320, -144},
    // 31 seconds
    { 1208, 264, -80},
    { 1016, 208, -72},
    { 832, 208, -72},
    { 704, 192, -56},
    { 680, 136, -56},
    { 744, 120, 0},
    { 832, 96, -24},
    { 968, 40, 8},
    { 1056, 72, -16},
    { 1016, 88, -88},
    { 1168, 96, -128},
    { 1192, 128, -88},
    { 1096, 120, -80},
    { 1264, 168, -80},
    { 1392, 208, -128},
    { 1104, 248, -216},
    { 736, 240, -216},
    { 520, 216, -216},
    { 472, 176, -160},
    { 536, 168, -120},
    { 680, 200, -144},
    { 848, 272, -176},
    { 1048, 288, -232},
    { 1088, 296, -256},
    { 1192, 288, -208},
    // 32 seconds
    { 1352, 320, -200},
    { 1096, 344, -192},
    { 1112, 312, -136},
    { 1168, 312, -128},
    { 1104, 240, -104},
    { 936, 192, -64},
    { 736, 168, -64},
    { 664, 152, -64},
    { 664, 120, -48},
    { 776, 112, -32},
    { 872, 80, -8},
    { 992, 48, -16},
    { 1080, 96, -88},
    { 1016, 128, -104},
    { 1232, 112, -128},
    { 1240, 144, 16},
    { 1144, 104, -8},
    { 1320, 192, -80},
    { 1272, 224, -128},
    { 984, 240, -144},
    { 632, 200, -136},
    { 480, 168, -120},
    { 464, 152, -136},
    { 568, 192, -112},
    { 712, 216, -168},
    // 33 seconds
    { 872, 264, -208},
    { 1048, 288, -312},
    { 1096, 312, -304},
    { 1208, 296, -208},
    { 1296, 320, -224},
    { 1120, 296, -184},
    { 1168, 288, -128},
    { 1344, 240, -96},
    { 1208, 232, -56},
    { 912, 184, -56},
    { 680, 120, -64},
    { 616, 88, -56},
    { 664, 64, -16},
    { 728, 80, -8},
    { 736, 32, -24},
    { 896, 64, -56},
    { 1064, 80, -72},
    { 1032, 64, -80},
    { 1280, 112, -104},
    { 1264, 112, 24},
    { 1216, 104, -32},
    { 1408, 152, -120},
    { 1280, 232, -160},
    { 960, 192, -128},
    { 616, 168, -128},
    // 34 seconds
    { 512, 176, -184},
    { 480, 192, -104},
    { 584, 216, -136},
    { 728, 248, -192},
    { 888, 336, -224},
    { 1016, 376, -296},
    { 1104, 344, -272},
    { 1272, 304, -184},
    { 1288, 336, -192},
    { 1248, 320, -136},
    { 1224, 288, -72},
    { 1208, 264, -40},
    { 1104, 240, -88},
    { 864, 160, -64},
    { 688, 112, -32},
    { 608, 80, -32},
    { 664, 112, -40},
    { 800, 104, -32},
    { 800, 88, 0},
    { 976, 96, -48},
    { 1128, 112, -24},
    { 1016, 112, -112},
    { 1328, 136, -72},
    { 1232, 88, 32},
    { 1352, 152, -104},
    // 35 seconds
    { 1448, 200, -208},
    { 1056, 232, -232},
    { 664, 200, -264},
    { 512, 160, -280},
    { 544, 120, -296},
    { 656, 112, -168},
    { 728, 176, -192},
    { 1048, 280, -216},
    { 1240, 336, -208},
    { 1240, 360, -184},
    { 1368, 360, -192},
    { 1256, 392, -192},
    { 1048, 304, -136},
    { 1152, 264, -128},
    { 1208, 224, -96},
    { 1112, 160, -40},
    { 920, 128, -24},
    { 728, 136, -96},
    { 648, 112, -56},
    { 616, 80, -8},
    { 688, 72, -16},
    { 792, 88, -72},
    { 920, 104, -96},
    { 1072, 96, -96},
    { 1176, 120, -160},
    // 36 seconds
    { 1280, 128, -152},
    { 1224, 152, -144},
    { 1104, 184, -88},
    { 1264, 192, -128},
    { 1336, 208, -120},
    { 1088, 248, -128},
    { 736, 224, -120},
    { 544, 216, -120},
    { 496, 168, -104},
    { 592, 192, -88},
    { 720, 240, -80},
    { 856, 264, -160},
    { 1024, 320, -240},
    { 1000, 328, -256},
    { 1016, 312, -208},
    { 1264, 320, -160},
    { 1264, 368, -248},
    { 1072, 304, -208},
    { 1072, 256, -192},
    { 1192, 240, -176},
    { 1144, 184, -128},
    { 960, 136, -96},
    { 800, 96, -56},
    { 704, 88, -48},
    { 704, 104, -48},
    // 37 seconds
    { 776, 80, 0},
    { 896, 64, -16},
    { 1072, 72, -24},
    { 1160, 136, -72},
    { 1136, 120, -152},
    { 1256, 176, -128},
    { 1144, 168, -176},
    { 952, 128, -160},
    { 1136, 128, -136},
    { 1224, 160, -112},
    { 1056, 184, -120},
    { 768, 192, -112},
    { 544, 216, -152},
    { 464, 168, -160},
    { 496, 128, -64},
    { 640, 128, -48},
    { 840, 160, -80},
    { 1088, 272, -136},
    { 1112, 328, -168},
    { 1216, 320, -184},
    { 1408, 368, -240},
    { 1096, 392, -256},
    { 1088, 304, -200},
    { 1160, 344, -200},
    { 1096, 312, -160},
    // 38 seconds
    { 992, 256, -112},
    { 808, 176, -80},
    { 680, 136, -64},
    { 696, 72, -64},
    { 760, 56, -40},
    { 888, 80, -40},
    { 976, 104, 16},
    { 1088, 104, -8},
    { 1088, 80, 8},
    { 1008, 64, -8},
    { 1256, 112, -72},
    { 1096, 48, 40},
    { 1096, 16, 24},
    { 1280, 120, -8},
    { 1232, 184, -80},
    { 968, 216, -112},
    { 664, 200, -184},
    { 544, 168, -176},
    { 544, 168, -104},
    { 624, 224, -168},
    { 792, 280, -264},
    { 968, 320, -280},
    { 1120, 320, -304},
    { 1104, 288, -296},
    { 1264, 296, -216},
    // 39 seconds
    { 1256, 280, -256},
    { 1128, 312, -168},
    { 1216, 296, -88},
    { 1336, 240, 0},
    { 1184, 232, 40},
    { 952, 152, -56},
    { 792, 88, -40},
    { 736, 96, -32},
    { 808, 56, 8},
    { 856, 40, 16},
    { 848, 40, 8},
    { 976, 88, -24},
    { 1056, 56, -64},
    { 1264, 72, -16},
    { 1376, 96, -64},
    { 1192, 104, -88},
    { 1040, 112, -168},
    { 1160, 112, -88},
    { 1208, 128, -112},
    { 1024, 176, -144},
    { 728, 216, -224},
    { 552, 192, -216},
    { 512, 176, -216},
    { 592, 136, -176},
    { 728, 176, -200},
    // 40 seconds
    { 944, 240, -232},
    { 1104, 288, -288},
    { 1016, 280, -288},
    { 1176, 296, -176},
    { 1360, 328, -224},
    { 1088, 312, -200},
    { 1080, 312, -176},
    { 1160, 288, -112},
    { 1184, 224, -80},
    { 1064, 192, -64},
    { 824, 152, -64},
    { 704, 112, -56},
    { 752, 96, -56},
    { 824, 104, -32},
    { 904, 48, 0},
    { 1032, -8, -16},
    { 1056, -8, -24},
    { 1056, 16, -56},
    { 1160, 80, -80},
    { 1208, 72, -40},
    { 1120, 88, -48},
    { 1280, 120, -64},
    { 1352, 160, -96},
    { 1144, 200, -168},
    { 816, 208, -152},
    // 41 seconds
    { 576, 224, -128},
    { 504, 224, -144},
    { 528, 168, -152},
    { 688, 168, -152},
    { 912, 240, -232},
    { 1144, 280, -296},
    { 1048, 280, -336},
    { 1056, 248, -240},
    { 1320, 304, -232},
    { 1192, 344, -224},
    { 1016, 304, -160},
    { 1128, 312, -168},
    { 1224, 296, -128},
    { 1120, 208, -48},
    { 904, 160, 0},
    { 808, 128, 16},
    { 760, 96, 88},
    { 808, 112, 88},
    { 824, 120, 80},
    { 960, 120, 32},
    { 1112, 128, -32},
    { 1088, 48, -32},
    { 1176, 72, -112},
    { 1208, 80, -144},
    { 1064, 88, -192},
    // 42 seconds
    { 1168, 112, -208},
    { 1288, 128, -160},
    { 1152, 176, -160},
    { 864, 200, -144},
    { 616, 208, -144},
    { 528, 184, -160},
    { 576, 176, -88},
    { 720, 192, -120},
    { 856, 224, -152},
    { 1008, 288, -264},
    { 1096, 312, -304},
    { 1104, 368, -296},
    { 1320, 400, -272},
    { 1192, 424, -272},
    { 984, 376, -248},
    { 1064, 352, -200},
    { 1200, 280, -136},
    { 1136, 256, -96},
    { 1024, 168, -72},
    { 856, 104, -32},
    { 704, 72, -40},
    { 680, 80, -24},
    { 720, 48, 0},
    { 816, 16, -24},
    { 1040, 48, -56},
    // 43 seconds
    { 1136, 80, -72},
    { 1136, 64, -168},
    { 1288, 104, -144},
    { 1240, 96, -88},
    { 1072, 112, -104},
    { 1192, 160, -64},
    { 1232, 184, -72},
    { 1032, 224, -112},
    { 744, 240, -128},
    { 544, 200, -144},
    { 472, 184, -104},
    { 552, 192, -104},
    { 680, 224, -144},
    { 872, 256, -216},
    { 1144, 328, -280},
    { 1032, 320, -296},
    { 1112, 304, -232},
    { 1344, 336, -240},
    { 1112, 360, -216},
    { 1064, 280, -120},
    { 1144, 304, -128},
    { 1168, 272, -120},
    { 1056, 256, -72},
    { 864, 144, -24},
    { 736, 128, -72},
    // 44 seconds
    { 728, 96, -56},
    { 776, 88, -48},
    { 832, 80, -16},
    { 928, 56, 8},
    { 1152, 48, -80},
    { 1096, 48, -104},
    { 1152, 48, -96},
    { 1272, 72, -32},
    { 1144, 96, 0},
    { 1184, 128, -40},
    { 1312, 176, -48},
    { 1176, 208, -128},
    { 856, 216, -152},
    { 576, 192, -136},
    { 504, 192, -144},
    { 544, 176, -120},
    { 680, 216, -160},
    { 824, 240, -216},
    { 1032, 232, -216},
    { 1128, 304, -320},
    { 1024, 288, -312},
    { 1272, 304, -232},
    { 1248, 328, -264},
    { 936, 296, -200},
    { 1152, 288, -168},
    // 45 seconds
    { 1280, 280, -112},
    { 1160, 264, -56},
    { 960, 184, -8},
    { 840, 144, -56},
    { 744, 128, -40},
    { 736, 112, -8},
    { 832, 80, -32},
    { 888, 56, 0},
    { 1016, 40, -32},
    { 1048, 64, -56},
    { 984, 48, -144},
    { 1200, 112, -136},
    { 1200, 120, -64},
    { 1088, 112, -88},
    { 1320, 200, -80},
    { 1384, 224, -136},
    { 1112, 240, -168},
    { 728, 208, -160},
    { 544, 192, -144},
    { 480, 176, -144},
    { 544, 184, -120},
    { 672, 232, -176},
    { 880, 256, -184},
    { 1104, 312, -280},
    { 1112, 376, -304},
    // 46 seconds
    { 1136, 280, -224},
    { 1288, 320, -208},
    { 1056, 376, -216},
    { 1064, 344, -160},
    { 1200, 312, -120},
    { 1216, 288, -88},
    { 1112, 240, -64},
    { 880, 184, -48},
    { 752, 144, -56},
    { 768, 104, -24},
    { 824, 80, 8},
    { 856, 72, 0},
    { 968, 64, -8},
    { 1120, 128, -8},
    { 1032, 128, 0},
    { 1072, 136, -104},
    { 1104, 176, -168},
    { 1072, 120, -128},
    { 1160, 80, -104},
    { 1288, 160, -112},
    { 1168, 232, -120},
    { 920, 240, -216},
    { 680, 224, -176},
    { 568, 192, -136},
    { 576, 200, -120},
    // 47 seconds
    { 672, 224, -128},
    { 808, 232, -200},
    { 1016, 264, -200},
    { 1128, 296, -296},
    { 976, 312, -304},
    { 1104, 280, -248},
    { 1256, 288, -224},
    { 1024, 296, -240},
    { 1024, 320, -208},
    { 1184, 280, -144},
    { 1288, 256, -72},
    { 1120, 248, 48},
    { 920, 192, 48},
    { 800, 176, -24},
    { 760, 160, 24},
    { 760, 128, 24},
    { 800, 104, -16},
    { 944, 80, -48},
    { 1040, 16, -56},
    { 1048, -16, -64},
    { 1152, 80, -72},
    { 1200, 176, -40},
    { 1136, 160, -56},
    { 1184, 176, -72},
    { 1336, 112, -48},
    // 48 seconds
    { 1248, 256, -128},
    { 920, 224, -152},
    { 624, 200, -160},
    { 528, 208, -152},
    { 544, 192, -152},
    { 680, 208, -128},
    { 784, 224, -144},
    { 1008, 280, -232},
    { 1080, 304, -296},
    { 1000, 280, -296},
    { 1192, 280, -200},
    { 1184, 280, -256},
    { 1056, 336, -208},
    { 1072, 320, -136},
    { 1152, 328, -152},
    { 1192, 272, -112},
    { 1080, 224, -64},
    { 912, 192, -56},
    { 816, 136, -48},
    { 792, 152, -48},
    { 792, 144, -40},
    { 792, 72, -24},
    { 864, 72, -8},
    { 1008, 80, -64},
    { 1000, 72, -88},
    // 49 seconds
    { 1088, 72, -88},
    { 1248, 128, -128},
    { 1176, 136, -72},
    { 1088, 104, -64},
    { 1208, 176, -88},
    { 1216, 200, -136},
    { 1016, 232, -168},
    { 760, 216, -152},
    { 616, 208, -120},
    { 584, 224, -112},
    { 656, 216, -80},
    { 776, 248, -88},
    { 880, 272, -136},
    { 1032, 296, -208},
    { 1056, 344, -296},
    { 1120, 312, -288},
    { 1328, 280, -264},
    { 1144, 296, -280},
    { 1008, 280, -208},
    { 1112, 280, -128},
    { 1216, 264, -88},
    { 1096, 240, -32},
    { 880, 208, -40},
    { 752, 240, -56},
    { 736, 144, -56},
    // 50 seconds
    { 752, 128, 0},
    { 872, 128, -24},
    { 920, 112, 8},
    { 1064, 120, -72},
    { 1024, 152, -40},
    { 1088, 80, -40},
    { 1216, 112, -56},
    { 1232, 96, -48},
    { 1120, 112, -88},
    { 1256, 104, -104},
    { 1192, 128, -112},
    { 968, 152, -160},
    { 704, 168, -152},
    { 560, 184, -192},
    { 536, 192, -200},
    { 616, 184, -136},
    { 768, 216, -192},
    { 960, 272, -272},
    { 1072, 288, -296},
    { 1072, 304, -312},
    { 1128, 320, -248},
    { 1280, 360, -248},
    { 1104, 384, -216},
    { 1128, 328, -152},
    { 1152, 304, -112},
    // 51 seconds
    { 1184, 248, -104},
    { 1032, 240, -64},
    { 832, 192, -40},
    { 768, 192, -64},
    { 744, 168, -40},
    { 800, 120, -40},
    { 864, 112, -40},
    { 936, 56, -16},
    { 1016, 32, -40},
    { 1088, 32, -80},
    { 1200, 48, -96},
    { 1256, 80, -24},
    { 1032, 96, -64},
    { 1232, 152, -112},
    { 1296, 184, -104},
    { 1072, 208, -120},
    { 800, 224, -128},
    { 632, 224, -152},
    { 600, 216, -152},
    { 648, 216, -120},
    { 768, 240, -160},
    { 872, 288, -208},
    { 1088, 328, -232},
    { 1104, 352, -272},
    { 1064, 336, -256},
    // 52 seconds
    { 1208, 328, -232},
    { 1088, 376, -256},
    { 1136, 360, -192},
    { 1288, 312, -104},
    { 1288, 288, -40},
    { 1152, 272, -32},
    { 952, 232, -32},
    { 840, 192, -16},
    { 808, 136, -16},
    { 872, 144, 16},
    { 896, 120, 40},
    { 944, 120, 32},
    { 1032, 144, 8},
    { 952, 120, 16},
    { 1000, 88, -48},
    { 1096, 120, -104},
    { 1064, 136, -72},
    { 1088, 144, -80},
    { 1296, 232, -112},
    { 1248, 232, -136},
    { 992, 256, -152},
    { 696, 248, -192},
    { 624, 216, -208},
    { 656, 216, -160},
    { 776, 200, -160},
    // 53 seconds
    { 864, 272, -176},
    { 1016, 312, -248},
    { 1072, 344, -296},
    { 1080, 368, -280},
    { 1264, 344, -224},
    { 1184, 344, -224},
    { 1024, 312, -152},
    { 1112, 328, -128},
    { 1248, 296, -72},
    { 1232, 296, 16},
    { 1128, 240, 16},
    { 896, 192, 8},
    { 784, 184, -8},
    { 768, 144, 16},
    { 808, 112, 8},
    { 832, 128, 16},
    { 904, 136, -8},
    { 1024, 120, -40},
    { 992, 112, -72},
    { 1088, 120, -112},
    { 1064, 168, -128},
    { 976, 120, -144},
    { 1160, 136, -104},
    { 1360, 216, -136},
    { 1256, 248, -184},
    // 54 seconds
    { 984, 280, -160},
    { 728, 240, -176},
    { 632, 240, -176},
    { 632, 240, -120},
    { 704, 248, -128},
    { 808, 264, -192},
    { 912, 304, -232},
    { 968, 296, -256},
    { 992, 296, -256},
    { 1000, 264, -192},
    { 1328, 328, -160},
    { 1112, 344, -168},
    { 1080, 320, -128},
    { 1200, 312, -104},
    { 1224, 280, -64},
    { 1080, 248, -56},
    { 896, 200, -56},
    { 784, 192, -48},
    { 760, 160, -24},
    { 784, 136, -16},
    { 824, 136, 0},
    { 832, 144, -8},
    { 984, 176, -24},
    { 984, 136, -64},
    { 936, 80, -80},
    // 55 seconds
    { 1200, 144, -152},
    { 1184, 152, -104},
    { 1024, 136, -144},
    { 1136, 168, -88},
    { 1240, 176, -80},
    { 1120, 232, -112},
    { 872, 248, -136},
    { 680, 224, -136},
    { 608, 208, -120},
    { 640, 224, -104},
    { 728, 248, -88},
    { 848, 280, -144},
    { 1000, 336, -184},
    { 1128, 368, -256},
    { 1080, 360, -264},
    { 1256, 328, -192},
    { 1128, 304, -200},
    { 976, 368, -232},
    { 1112, 360, -192},
    { 1272, 288, -160},
    { 1288, 248, -80},
    { 1112, 216, -40},
    { 968, 192, -32},
    { 888, 160, -40},
    { 832, 168, -8},
    // 56 seconds
    { 824, 120, 8},
    { 800, 80, 8},
    { 904, 80, -24},
    { 1008, 112, -104},
    { 936, 48, -128},
    { 1144, 88, -120},
    { 1176, 128, -112},
    { 1072, 96, -168},
    { 1296, 208, -120},
    { 1384, 192, -104},
    { 1192, 240, -120},
    { 904, 216, -136},
    { 728, 232, -136},
    { 656, 280, -96},
    { 712, 320, -72},
    { 824, 288, -104},
    { 928, 320, -168},
    { 1064, 344, -240},
    { 1040, 368, -272},
    { 1064, 328, -240},
    { 1280, 368, -200},
    { 1032, 400, -184},
    { 1056, 376, -168},
    { 1232, 264, -88},
    { 1200, 160, -24},
    // 57 seconds
    { 1160, 120, 8},
    { 968, 152, -24},
    { 800, 144, 8},
    { 768, 144, 8},
    { 824, 168, -24},
    { 912, 152, 0},
    { 904, 96, 40},
    { 1064, 88, -32},
    { 1088, 72, -40},
    { 1088, 0, -40},
    { 1184, 0, -32},
    { 1160, 72, -8},
    { 1048, 96, -96},
    { 1264, 120, -120},
    { 1296, 152, -96},
    { 1096, 208, -136},
    { 776, 200, -176},
    { 584, 184, -200},
    { 536, 184, -144},
    { 632, 176, -112},
    { 768, 224, -160},
    { 912, 288, -248},
    { 1096, 304, -320},
    { 1096, 312, -336},
    { 1112, 304, -272},
    // 58 seconds
    { 1328, 336, -248},
    { 1056, 320, -200},
    { 1008, 272, -152},
    { 1112, 264, -120},
    { 1288, 272, -80},
    { 1216, 224, -8},
    { 992, 192, -8},
    { 832, 200, -40},
    { 784, 168, -8},
    { 792, 160, 0},
    { 784, 120, 24},
    { 768, 80, 32},
    { 928, 120, -24},
    { 976, 128, -48},
    { 976, 40, -56},
    { 1272, 112, -64},
    { 1184, 136, -32},
    { 1032, 184, -96},
    { 1168, 208, -120},
    { 1280, 216, -104},
    { 1144, 224, -128},
    { 864, 240, -144},
    { 672, 240, -168},
    { 632, 216, -168},
    { 664, 216, -120},
    // 59 seconds
    { 760, 240, -152},
    { 848, 272, -216},
    { 1008, 320, -256},
    { 1032, 328, -296},
    { 1072, 304, -272},
    { 1312, 312, -264},
    { 1144, 296, -240},
    { 1064, 272, -184},
    { 1152, 256, -144},
    { 1240, 240, -88},
    { 1168, 160, -80},
    { 976, 200, -48},
    { 864, 224, -40},
    { 888, 336, -16},
    { 880, 504, -96},
    { 1024, 672, -216},
    { 992, 856, -512},
    { 1176, 952, -552},
    { 1176, 1024, -688},
    { 1040, 624, -728},
    { 992, 328, -776},
    { 720, 40, -664},
    { 576, -96, -720},
    { 360, -288, -568},
    { 232, -376, -608},
    // 60 seconds
    // elapsed: 1 minutes
    { 112, -352, -616},
    { -24, -384, -528},
    { -88, -448, -432},
    { -136, -448, -408},
    { -152, -432, -392},
    { -208, -408, -464},
    { -208, -504, -528},
    { -320, -464, -712},
    { -376, -496, -896},
    { -392, -560, -920},
    { -336, -560, -928},
    { -360, -624, -800},
    { -192, -368, -904},
    { -152, -288, -904},
    { -88, -280, -1000},
    { -256, -112, -1312},
    { -144, -184, -1344},
    { -104, -192, -1184},
    { -200, -216, -1056},
    { -216, -216, -968},
    { -200, -296, -808},
    { -136, -336, -744},
    { -32, -368, -624},
    { 8, -448, -400},
    { 8, -296, -80},
    // 61 seconds
    { 120, -128, -48},
    { 360, 0, -344},
    { 696, 72, -216},
    { 1264, 104, -304},
    { 2088, 288, -184},
    { 2848, 400, -248},
    { 2504, 648, -544},
    { 1584, 704, -552},
    { 1216, 408, -336},
    { 1176, 304, -304},
    { 1024, 448, -200},
    { 736, 384, -320},
    { 672, 328, -312},
    { 672, 328, -304},
    { 664, 328, -240},
    { 768, 272, -176},
    { 872, 280, -176},
    { 848, 232, -184},
    { 888, 248, -160},
    { 872, 384, -232},
    { 928, 384, -368},
    { 1040, 568, -272},
    { 1096, 576, -456},
    { 1336, 640, -488},
    { 1296, 696, -544},
    // 62 seconds
    { 1264, 736, -528},
    { 1232, 888, -664},
    { 1072, 512, -536},
    { 896, 352, -600},
    { 744, 256, -584},
    { 536, 168, -480},
    { 424, 56, -512},
    { 248, -136, -504},
    { 120, -144, -584},
    { 72, -176, -696},
    { -16, -208, -688},
    { -72, -280, -704},
    { -112, -272, -696},
    { -104, -248, -704},
    { -88, -248, -728},
    { -96, -304, -680},
    { -64, -304, -624},
    { -32, -296, -552},
    { 64, -168, -400},
    { 256, -144, -304},
    { 520, 104, -440},
    { 696, 112, -392},
    { 896, 168, -376},
    { 1432, 152, -392},
    { 1960, 280, -440},
    // 63 seconds
    { 2448, 400, -432},
    { 2008, 320, -296},
    { 1576, 264, -432},
    { 1440, 352, -136},
    { 1192, 360, -304},
    { 808, 280, -224},
    { 576, 328, -280},
    { 488, 360, -256},
    { 536, 376, -192},
    { 688, 376, -256},
    { 824, 344, -208},
    { 944, 312, -248},
    { 1016, 296, -320},
    { 1016, 280, -256},
    { 1352, 280, -224},
    { 1480, 280, -240},
    { 1328, 232, -248},
    { 1160, 224, -184},
    { 1240, 208, -136},
    { 1288, 216, -80},
    { 1176, 216, -72},
    { 1032, 192, -56},
    { 928, 112, -56},
    { 800, 112, -32},
    { 696, 104, -64},
    // 64 seconds
    { 576, 96, -48},
    { 568, 48, -64},
    { 720, 56, -160},
    { 824, 64, -184},
    { 928, 24, -160},
    { 1384, 112, -168},
    { 1336, 120, -152},
    { 1416, 232, -160},
    { 1504, 256, -128},
    { 1448, 248, -72},
    { 1192, 288, -112},
    { 848, 296, -160},
    { 640, 264, -176},
    { 568, 240, -96},
    { 608, 224, -56},
    { 744, 232, -128},
    { 928, 312, -192},
    { 1152, 352, -272},
    { 1056, 352, -288},
    { 1104, 352, -256},
    { 1264, 360, -256},
    { 1032, 344, -224},
    { 1096, 280, -176},
    { 1264, 272, -168},
    { 1352, 248, -112},
    // 65 seconds
    { 1240, 192, -72},
    { 1040, 160, -40},
    { 912, 128, -48},
    { 840, 128, -8},
    { 848, 80, 8},
    { 880, 64, 16},
    { 944, -8, -24},
    { 992, 32, -32},
    { 1064, 24, -104},
    { 1024, 40, -128},
    { 1232, 72, -80},
    { 1200, 112, -32},
    { 1320, 160, -96},
    { 1488, 216, -112},
    { 1312, 248, -120},
    { 936, 240, -176},
    { 632, 240, -168},
    { 520, 224, -184},
    { 536, 216, -120},
    { 664, 240, -112},
    { 872, 256, -176},
    { 1120, 304, -216},
    { 1152, 376, -288},
    { 1088, 400, -264},
    { 1240, 400, -200},
    // 66 seconds
    { 1144, 416, -200},
    { 1056, 320, -168},
    { 1216, 272, -128},
    { 1320, 248, -88},
    { 1240, 216, -32},
    { 1032, 160, -56},
    { 832, 144, -80},
    { 744, 104, -48},
    { 752, 120, -16},
    { 848, 72, 8},
    { 904, 16, 0},
    { 992, 16, -24},
    { 1056, 56, -48},
    { 984, 56, -80},
    { 1200, 112, -112},
    { 1208, 104, -128},
    { 1256, 88, -112},
    { 1472, 152, -144},
    { 1376, 192, -200},
    { 1064, 232, -248},
    { 672, 232, -256},
    { 496, 200, -280},
    { 448, 144, -176},
    { 536, 136, -160},
    { 712, 200, -208},
    // 67 seconds
    { 968, 288, -288},
    { 1048, 400, -328},
    { 1024, 392, -296},
    { 1120, 352, -216},
    { 1304, 392, -200},
    { 1064, 392, -200},
    { 1224, 304, -136},
    { 1304, 280, -120},
    { 1264, 248, -104},
    { 1032, 200, -72},
    { 808, 144, -64},
    { 696, 144, -56},
    { 680, 112, -80},
    { 760, 112, -48},
    { 824, 96, -56},
    { 952, 72, -88},
    { 1080, 88, -128},
    { 1104, 24, -120},
    { 1144, 72, -176},
    { 1264, 80, -112},
    { 1104, 88, -56},
    { 1192, 144, -120},
    { 1312, 184, -128},
    { 1192, 192, -168},
    { 896, 208, -168},
    // 68 seconds
    { 624, 168, -144},
    { 520, 184, -152},
    { 544, 208, -120},
    { 688, 240, -168},
    { 856, 264, -232},
    { 1112, 320, -256},
    { 1120, 336, -328},
    { 1040, 320, -264},
    { 1248, 344, -192},
    { 1184, 344, -200},
    { 1120, 336, -144},
    { 1240, 352, -112},
    { 1272, 304, -104},
    { 1152, 232, -48},
    { 928, 184, -56},
    { 744, 136, -72},
    { 712, 152, -72},
    { 824, 152, -72},
    { 872, 96, -24},
    { 896, 64, -16},
    { 968, 88, -8},
    { 1040, 80, -56},
    { 976, 72, -88},
    { 1136, 104, -176},
    { 1112, 112, -80},
    // 69 seconds
    { 1136, 104, -64},
    { 1328, 160, -72},
    { 1400, 192, -96},
    { 1216, 240, -168},
    { 848, 248, -176},
    { 576, 216, -208},
    { 496, 184, -176},
    { 552, 176, -120},
    { 720, 232, -128},
    { 912, 280, -232},
    { 1088, 304, -256},
    { 1072, 312, -288},
    { 1120, 328, -248},
    { 1168, 328, -200},
    { 1096, 352, -200},
    { 1072, 328, -208},
    { 1240, 320, -136},
    { 1328, 240, -80},
    { 1216, 216, -32},
    { 968, 152, -32},
    { 816, 128, -72},
    { 744, 112, -56},
    { 736, 104, -32},
    { 760, 88, 0},
    { 816, 72, -24},
    // 70 seconds
    { 888, 96, -64},
    { 1072, 96, -64},
    { 1040, 80, -88},
    { 1232, 136, -120},
    { 1336, 152, -40},
    { 1144, 136, -56},
    { 1304, 160, -112},
    { 1312, 200, -104},
    { 1040, 232, -128},
    { 704, 216, -160},
    { 536, 208, -200},
    { 504, 176, -152},
    { 584, 208, -120},
    { 712, 224, -208},
    { 976, 312, -288},
    { 1144, 360, -328},
    { 1112, 344, -296},
    { 1104, 296, -232},
    { 1232, 312, -216},
    { 1040, 304, -224},
    { 1160, 264, -168},
    { 1360, 272, -96},
    { 1360, 256, -40},
    { 1120, 240, 8},
    { 872, 200, -8},
    // 71 seconds
    { 776, 192, -96},
    { 744, 120, -16},
    { 752, 48, 24},
    { 800, 64, 48},
    { 832, 64, 24},
    { 920, 80, -24},
    { 968, 128, -56},
    { 1040, 112, -96},
    { 1248, 168, -72},
    { 1232, 144, -40},
    { 1208, 256, -80},
    { 1320, 128, -144},
    { 1296, 248, -144},
    { 1032, 264, -224},
    { 680, 200, -232},
    { 536, 136, -144},
    { 536, 144, -112},
    { 640, 208, -136},
    { 720, 216, -208},
    { 1032, 256, -208},
    { 1168, 264, -336},
    { 1072, 288, -336},
    { 1136, 272, -256},
    { 1248, 344, -280},
    { 1024, 328, -240},
    // 72 seconds
    { 1160, 288, -160},
    { 1280, 288, -120},
    { 1328, 248, -72},
    { 1136, 216, -24},
    { 888, 192, -56},
    { 760, 168, -48},
    { 744, 104, -16},
    { 808, 128, -48},
    { 832, 88, -16},
    { 896, 32, -8},
    { 952, 80, -72},
    { 1040, 120, -72},
    { 1024, 104, -64},
    { 1144, 144, -56},
    { 1088, 176, -64},
    { 1208, 136, -80},
    { 1392, 224, -80},
    { 1320, 216, -128},
    { 1040, 256, -176},
    { 736, 264, -160},
    { 600, 208, -152},
    { 584, 224, -136},
    { 712, 232, -128},
    { 864, 256, -224},
    { 1016, 280, -264},
    // 73 seconds
    { 1064, 288, -336},
    { 968, 280, -320},
    { 1152, 272, -216},
    { 1328, 304, -232},
    { 1120, 280, -216},
    { 1152, 280, -176},
    { 1208, 280, -104},
    { 1248, 272, -56},
    { 1080, 200, -48},
    { 856, 176, -48},
    { 752, 144, -40},
    { 744, 136, -40},
    { 824, 136, -16},
    { 848, 104, -24},
    { 920, 88, 8},
    { 1032, 104, -32},
    { 1040, 120, -80},
    { 1104, 104, -136},
    { 1192, 120, -136},
    { 1128, 104, -112},
    { 1296, 136, -104},
    { 1344, 184, -120},
    { 1128, 208, -160},
    { 808, 224, -160},
    { 584, 224, -160},
    // 74 seconds
    { 520, 216, -128},
    { 600, 200, -136},
    { 736, 232, -104},
    { 912, 240, -168},
    { 1096, 304, -208},
    { 1104, 320, -296},
    { 984, 312, -280},
    { 1112, 256, -208},
    { 1296, 320, -256},
    { 1056, 328, -264},
    { 1024, 312, -224},
    { 1096, 296, -208},
    { 1136, 272, -128},
    { 1064, 216, -72},
    { 904, 184, -64},
    { 824, 160, -32},
    { 808, 144, 0},
    { 848, 176, -8},
    { 952, 184, -32},
    { 1088, 112, 24},
    { 1152, 96, 16},
    { 992, 112, 16},
    { 1000, 72, -48},
    { 1064, 96, -48},
    { 1056, 104, -64},
    // 75 seconds
    { 1088, 96, -96},
    { 1256, 152, -96},
    { 1264, 160, -120},
    { 1064, 200, -208},
    { 776, 200, -200},
    { 600, 216, -192},
    { 576, 200, -168},
    { 672, 192, -136},
    { 824, 232, -192},
    { 960, 240, -232},
    { 1112, 280, -304},
    { 1056, 312, -336},
    { 1144, 280, -288},
    { 1336, 328, -280},
    { 1152, 296, -248},
    { 1080, 240, -160},
    { 1096, 280, -168},
    { 1216, 288, -112},
    { 1112, 216, -56},
    { 888, 168, -24},
    { 792, 184, -56},
    { 760, 176, -48},
    { 792, 144, 0},
    { 816, 112, 8},
    { 888, 80, 24},
    // 76 seconds
    { 1080, 112, 0},
    { 1064, 96, -56},
    { 1048, 80, -96},
    { 1168, 120, -96},
    { 1208, 96, -40},
    { 1064, 136, -144},
    { 1256, 168, -128},
    { 1264, 184, -112},
    { 1048, 200, -120},
    { 752, 224, -168},
    { 584, 208, -144},
    { 544, 184, -136},
    { 608, 184, -136},
    { 744, 216, -160},
    { 912, 224, -208},
    { 1128, 264, -304},
    { 1112, 288, -320},
    { 1104, 264, -280},
    { 1280, 328, -280},
    { 1168, 368, -288},
    { 1008, 320, -208},
    { 1064, 304, -160},
    { 1256, 264, -104},
    { 1184, 224, -32},
    { 976, 200, 16},
    // 77 seconds
    { 832, 160, -48},
    { 784, 168, -40},
    { 832, 160, -32},
    { 832, 80, -24},
    { 840, 48, 0},
    { 944, 88, -24},
    { 1024, 112, -48},
    { 1064, 128, -112},
    { 1168, 160, -136},
    { 1128, 120, -80},
    { 1184, 112, -80},
    { 1408, 184, -96},
    { 1328, 184, -184},
    { 1040, 216, -208},
    { 672, 200, -208},
    { 496, 192, -192},
    { 464, 176, -232},
    { 600, 184, -136},
    { 808, 248, -192},
    { 992, 304, -224},
    { 1112, 352, -264},
    { 1056, 384, -296},
    { 1072, 352, -216},
    { 1296, 352, -176},
    { 1072, 368, -200},
    // 78 seconds
    { 1176, 360, -128},
    { 1176, 320, -128},
    { 1192, 296, -80},
    { 1104, 200, -40},
    { 888, 176, -24},
    { 720, 160, -72},
    { 704, 160, -72},
    { 760, 152, -16},
    { 808, 112, -8},
    { 880, 96, -8},
    { 984, 104, -40},
    { 968, 136, -80},
    { 984, 136, -96},
    { 1192, 184, -192},
    { 1120, 176, -160},
    { 1080, 144, -184},
    { 1280, 152, -72},
    { 1344, 208, -80},
    { 1136, 248, -176},
    { 760, 232, -136},
    { 536, 208, -168},
    { 472, 168, -136},
    { 536, 144, -104},
    { 672, 176, -136},
    { 768, 200, -144},
    // 79 seconds
    { 1016, 288, -208},
    { 1088, 360, -296},
    { 1128, 352, -272},
    { 1416, 400, -184},
    { 1216, 384, -200},
    { 1032, 368, -168},
    { 1176, 360, -136},
    { 1264, 328, -112},
    { 1120, 256, -80},
    { 888, 200, -64},
    { 768, 192, -48},
    { 736, 168, -56},
    { 760, 160, -40},
    { 816, 168, -8},
    { 840, 112, 0},
    { 928, 136, -32},
    { 1024, 168, -96},
    { 1040, 96, -96},
    { 1248, 152, -112},
    { 1216, 120, -104},
    { 1032, 112, -152},
    { 1224, 144, -128},
    { 1208, 160, -120},
    { 984, 208, -112},
    { 744, 240, -144},
    // 80 seconds
    { 624, 248, -176},
    { 592, 216, -144},
    { 656, 240, -96},
    { 808, 296, -136},
    { 896, 312, -248},
    { 1064, 336, -248},
    { 1088, 344, -280},
    { 1088, 312, -224},
    { 1256, 336, -224},
    { 1104, 344, -192},
    { 1136, 344, -160},
    { 1208, 296, -104},
    { 1288, 272, -48},
    { 1136, 240, 24},
    { 896, 200, -16},
    { 776, 176, -32},
    { 744, 160, -16},
    { 792, 160, 0},
    { 832, 104, 24},
    { 920, 80, 32},
    { 1016, 112, 0},
    { 1080, 144, -16},
    { 1072, 128, -48},
    { 1152, 136, -120},
    { 1112, 112, -184},
    // 81 seconds
    { 1104, 64, -64},
    { 1296, 128, -88},
    { 1264, 216, -152},
    { 1016, 264, -208},
    { 688, 264, -192},
    { 544, 232, -192},
    { 512, 208, -152},
    { 632, 184, -120},
    { 784, 240, -120},
    { 936, 272, -128},
    { 1128, 376, -208},
    { 1024, 400, -224},
    { 1008, 368, -184},
    { 1160, 376, -160},
    { 1064, 400, -200},
    { 1120, 376, -168},
    { 1128, 336, -128},
    { 1216, 272, -120},
    { 1176, 232, -40},
    { 912, 176, -40},
    { 760, 168, -88},
    { 736, 176, -80},
    { 728, 136, -40},
    { 832, 88, -40},
    { 872, 48, -32},
    // 82 seconds
    { 992, 56, -64},
    { 1128, 88, -88},
    { 1176, 80, -88},
    { 1304, 128, -56},
    { 1096, 144, -40},
    { 1096, 120, -96},
    { 1272, 184, -104},
    { 1136, 176, -120},
    { 872, 184, -136},
    { 608, 160, -168},
    { 504, 144, -160},
    { 528, 144, -136},
    { 632, 176, -88},
    { 792, 256, -176},
    { 1048, 320, -216},
    { 1216, 352, -312},
    { 1112, 360, -344},
    { 1152, 344, -248},
    { 1328, 352, -272},
    { 1040, 312, -224},
    { 1016, 320, -144},
    { 1176, 304, -64},
    { 1240, 272, -40},
    { 1152, 224, 8},
    { 896, 168, -24},
    // 83 seconds
    { 816, 176, -40},
    { 792, 160, -8},
    { 816, 144, 16},
    { 832, 144, 24},
    { 888, 112, 8},
    { 992, 120, -48},
    { 976, 96, -72},
    { 984, 72, -136},
    { 1184, 88, -144},
    { 1152, 120, -128},
    { 1080, 112, -136},
    { 1256, 184, -136},
    { 1248, 224, -160},
    { 1040, 256, -144},
    { 768, 264, -120},
    { 640, 264, -120},
    { 632, 256, -72},
    { 712, 264, -56},
    { 824, 280, -64},
    { 904, 336, -144},
    { 1096, 400, -192},
    { 1040, 392, -216},
    { 1016, 352, -200},
    { 1240, 360, -200},
    { 1040, 360, -200},
    // 84 seconds
    { 1072, 312, -144},
    { 1216, 304, -96},
    { 1304, 280, -64},
    { 1184, 232, 8},
    { 976, 192, 8},
    { 824, 176, -32},
    { 768, 112, -16},
    { 816, 152, -8},
    { 816, 104, 16},
    { 848, 80, 32},
    { 1008, 128, -8},
    { 992, 168, 0},
    { 1056, 160, -48},
    { 1192, 176, -72},
    { 1192, 144, -32},
    { 1104, 160, -80},
    { 1216, 144, -96},
    { 1264, 152, -112},
    { 1112, 200, -152},
    { 792, 200, -192},
    { 568, 208, -184},
    { 512, 216, -160},
    { 592, 216, -128},
    { 760, 248, -136},
    { 936, 272, -208},
    // 85 seconds
    { 1088, 336, -280},
    { 1032, 336, -328},
    { 1040, 320, -280},
    { 1256, 312, -216},
    { 1184, 320, -200},
    { 1048, 296, -152},
    { 1136, 288, -120},
    { 1304, 248, -80},
    { 1224, 248, 0},
    { 1016, 168, -32},
    { 768, 120, -24},
    { 680, 88, -32},
    { 696, 80, -32},
    { 736, 64, 8},
    { 784, 64, 16},
    { 920, 88, -24},
    { 1016, 128, -56},
    { 1104, 120, -112},
    { 1288, 160, -96},
    { 1264, 152, -56},
    { 1112, 168, -104},
    { 1272, 152, -88},
    { 1264, 168, -88},
    { 1072, 184, -136},
    { 744, 208, -136},
    // 86 seconds
    { 544, 200, -168},
    { 496, 144, -128},
    { 560, 192, -88},
    { 696, 208, -128},
    { 856, 224, -176},
    { 1080, 264, -240},
    { 1056, 288, -288},
    { 1064, 264, -248},
    { 1280, 272, -224},
    { 1128, 312, -216},
    { 1080, 296, -192},
    { 1088, 296, -112},
    { 1160, 256, -80},
    { 1144, 216, -16},
    { 912, 168, 16},
    { 728, 136, -24},
    { 672, 136, -56},
    { 696, 104, -24},
    { 816, 120, -32},
    { 880, 72, 8},
    { 1040, 96, -24},
    { 1104, 112, -48},
    { 1160, 136, -72},
    { 1208, 160, -16},
    { 1216, 136, -24},
    // 87 seconds
    { 1200, 128, -16},
    { 1304, 192, -32},
    { 1192, 128, -104},
    { 920, 168, -144},
    { 640, 168, -128},
    { 472, 192, -112},
    { 464, 176, -128},
    { 568, 168, -144},
    { 768, 192, -136},
    { 896, 176, -160},
    { 1072, 176, -144},
    { 1104, 240, -232},
    { 1120, 280, -240},
    { 1368, 304, -240},
    { 1176, 336, -248},
    { 928, 272, -184},
    { 1112, 264, -192},
    { 1200, 256, -144},
    { 1192, 264, -96},
    { 1016, 184, -48},
    { 832, 144, 0},
    { 744, 136, -48},
    { 776, 120, -32},
    { 832, 112, -8},
    { 888, 104, 32},
    // 88 seconds
    { 928, 40, 64},
    { 1040, 120, 24},
    { 968, 168, 8},
    { 1016, 144, -32},
    { 1112, 184, -40},
    { 1072, 176, -40},
    { 1136, 112, -8},
    { 1312, 120, 0},
    { 1288, 176, -136},
    { 1008, 208, -168},
    { 680, 208, -168},
    { 552, 208, -184},
    { 560, 168, -168},
    { 680, 152, -152},
    { 784, 208, -208},
    { 928, 216, -216},
    { 1128, 288, -288},
    { 1048, 264, -280},
    { 1192, 272, -232},
    { 1344, 296, -232},
    { 1088, 280, -200},
    { 1056, 256, -128},
    { 1176, 240, -120},
    { 1216, 232, -64},
    { 1032, 192, 0},
    // 89 seconds
    { 840, 160, -16},
    { 696, 136, -48},
    { 688, 112, -16},
    { 752, 120, 8},
    { 824, 56, 16},
    { 1032, 104, -16},
    { 1112, 112, -24},
    { 1120, 96, -40},
    { 1248, 120, -72},
    { 1240, 168, -96},
    { 1088, 128, -64},
    { 1192, 72, -48},
    { 1256, 80, -56},
    { 1104, 160, -176},
    { 784, 136, -160},
    { 552, 112, -224},
    { 488, 176, -128},
    { 528, 200, -112},
    { 688, 208, -112},
    { 848, 232, -200},
    { 1016, 280, -208},
    { 1152, 328, -256},
    { 1104, 304, -240},
    { 1256, 288, -192},
    { 1176, 336, -216},
    // 90 seconds
    { 1008, 304, -160},
    { 1120, 264, -112},
    { 1168, 264, -112},
    { 1128, 256, -72},
    { 960, 192, -16},
    { 776, 144, -40},
    { 712, 128, -48},
    { 728, 120, -72},
    { 832, 120, -56},
    { 920, 96, -16},
    { 1016, 56, 8},
    { 1112, 96, -48},
    { 1048, 144, -56},
    { 1184, 176, -64},
    { 1176, 192, -56},
    { 1056, 176, -104},
    { 1200, 280, -64},
    { 1232, 128, -96},
    { 1104, 104, -96},
    { 840, 128, -152},
    { 608, 120, -176},
    { 496, 80, -144},
    { 520, 128, -120},
    { 672, 160, -120},
    { 856, 216, -216},
    // 91 seconds
    { 1056, 248, -336},
    { 1120, 216, -352},
    { 1112, 216, -360},
    { 1208, 216, -240},
    { 1304, 216, -256},
    { 1048, 232, -256},
    { 1064, 208, -168},
    { 1160, 184, -120},
    { 1104, 184, -80},
    { 960, 208, -24},
    { 744, 136, -40},
    { 696, 120, -88},
    { 696, 120, -64},
    { 736, 96, -24},
    { 784, 72, -24},
    { 920, 96, -56},
    { 1144, 144, -80},
    { 1168, 136, -104},
    { 1176, 96, -80},
    { 1264, 128, -112},
    { 1104, 80, 0},
    { 984, 64, -48},
    { 1120, 80, -80},
    { 1152, 128, -80},
    { 992, 144, -120},
    // 92 seconds
    { 768, 152, -152},
    { 592, 168, -128},
    { 512, 184, -128},
    { 576, 168, -128},
    { 720, 184, -184},
    { 880, 208, -232},
    { 1112, 248, -264},
    { 1080, 240, -296},
    { 1080, 216, -248},
    { 1392, 256, -168},
    { 1160, 344, -160},
    { 1064, 328, -120},
    { 1104, 320, -88},
    { 1200, 264, -96},
    { 1080, 216, -64},
    { 864, 176, -64},
    { 712, 168, -56},
    { 720, 104, -56},
    { 768, 112, -32},
    { 864, 112, -16},
    { 968, 88, -32},
    { 1144, 112, 0},
    { 1064, 176, 0},
    { 1096, 200, -96},
    { 1192, 224, -96},
    // 93 seconds
    { 976, 160, -88},
    { 984, 136, -120},
    { 1160, 160, -48},
    { 1192, 192, -128},
    { 1008, 192, -104},
    { 752, 192, -136},
    { 592, 208, -152},
    { 544, 160, -168},
    { 584, 168, -120},
    { 704, 208, -168},
    { 896, 248, -232},
    { 1168, 224, -280},
    { 1128, 296, -280},
    { 1120, 288, -208},
    { 1328, 344, -224},
    { 1184, 352, -208},
    { 1056, 264, -136},
    { 1040, 256, -96},
    { 1136, 240, -88},
    { 1032, 216, -56},
    { 872, 176, -40},
    { 744, 144, -48},
    { 704, 128, -24},
    { 744, 112, -8},
    { 824, 136, -8},
    // 94 seconds
    { 968, 152, -72},
    { 1104, 56, 8},
    { 1064, 24, 32},
    { 1136, 64, -48},
    { 1240, 120, -40},
    { 1176, 104, -72},
    { 1064, 96, -56},
    { 1128, 80, -32},
    { 1144, 120, -96},
    { 1032, 184, -168},
    { 832, 192, -208},
    { 656, 168, -224},
    { 552, 136, -144},
    { 592, 160, -112},
    { 728, 224, -160},
    { 896, 264, -192},
    { 1096, 288, -296},
    { 1040, 288, -296},
    { 1080, 232, -232},
    { 1280, 248, -208},
    { 1200, 296, -216},
    { 1064, 296, -152},
    { 1024, 248, -136},
    { 1136, 232, -72},
    { 1136, 216, -40},
    // 95 seconds
    { 984, 176, -16},
    { 776, 136, -40},
    { 680, 120, -40},
    { 688, 104, -32},
    { 760, 104, -8},
    { 888, 96, -8},
    { 1008, 88, 40},
    { 1080, 136, -16},
    { 1048, 160, -88},
    { 1208, 144, -120},
    { 1216, 112, -48},
    { 1104, 136, -48},
    { 1016, 104, -128},
    { 1128, 128, -128},
    { 1112, 192, -152},
    { 872, 240, -192},
    { 624, 184, -168},
    { 552, 176, -112},
    { 592, 208, -112},
    { 696, 216, -120},
    { 784, 224, -200},
    { 928, 248, -224},
    { 1096, 264, -312},
    { 1040, 248, -272},
    { 1224, 256, -240},
    // 96 seconds
    { 1208, 256, -264},
    { 960, 272, -232},
    { 1096, 240, -152},
    { 1216, 232, -120},
    { 1240, 200, -80},
    { 1032, 184, -40},
    { 856, 168, -40},
    { 736, 176, -72},
    { 704, 120, -64},
    { 736, 104, -32},
    { 800, 184, -32},
    { 944, 192, -96},
    { 1032, 216, -80},
    { 944, 112, -168},
    { 1168, 56, -240},
    { 1192, 80, -104},
    { 1056, -48, -184},
    { 1168, -40, -72},
    { 1312, 0, -168},
    { 1152, -16, -232},
    { 872, 56, -216},
    { 680, 152, -224},
    { 560, 160, -224},
    { 544, 128, -168},
    { 640, 144, -136},
    // 97 seconds
    { 832, 160, -168},
    { 960, 240, -168},
    { 1088, 320, -288},
    { 1032, 344, -296},
    { 1200, 320, -256},
    { 1328, 328, -240},
    { 1024, 304, -240},
    { 1016, 280, -176},
    { 1168, 256, -144},
    { 1216, 240, -128},
    { 1128, 208, -104},
    { 928, 152, -72},
    { 800, 160, -56},
    { 760, 112, -32},
    { 792, 112, -16},
    { 792, 112, 8},
    { 824, 96, 32},
    { 1000, 160, -8},
    { 1152, 152, -104},
    { 1160, 120, -136},
    { 1280, 72, -104},
    { 1112, 40, 72},
    { 1160, -8, -56},
    { 1312, 96, -120},
    { 1152, 136, -136},
    // 98 seconds
    { 864, 152, -136},
    { 672, 120, -192},
    { 560, 144, -152},
    { 544, 184, -120},
    { 632, 184, -112},
    { 752, 200, -192},
    { 992, 240, -240},
    { 1128, 328, -392},
    { 1120, 312, -376},
    { 1248, 320, -296},
    { 1280, 320, -272},
    { 1024, 312, -272},
    { 1104, 328, -192},
    { 1192, 312, -144},
    { 1152, 240, -128},
    { 1024, 200, -80},
    { 840, 168, -48},
    { 728, 144, -64},
    { 736, 128, -56},
    { 784, 112, -40},
    { 856, 96, -32},
    { 968, 104, -32},
    { 1080, 120, -80},
    { 1000, 80, -48},
    { 1136, 128, -96},
    // 99 seconds
    { 1160, 136, -72},
    { 1112, 144, -88},
    { 1120, 136, -104},
    { 1272, 176, -96},
    { 1200, 192, -144},
    { 944, 208, -152},
    { 688, 192, -192},
    { 536, 192, -168},
    { 528, 184, -128},
    { 632, 184, -104},
    { 776, 192, -160},
    { 960, 208, -184},
    { 1160, 288, -312},
    { 1048, 288, -336},
    { 1096, 256, -256},
    { 1304, 288, -248},
    { 1064, 280, -232},
    { 1032, 248, -136},
    { 1168, 264, -128},
    { 1176, 240, -112},
    { 1024, 240, -72},
    { 856, 176, -56},
    { 776, 144, -48},
    { 728, 120, -16},
    { 760, 120, -24},
    // 100 seconds
    { 776, 120, 0},
    { 888, 112, -16},
    { 1048, 128, -32},
    { 1096, 112, -56},
    { 1104, 88, -72},
    { 1248, 104, -64},
    { 1216, 144, -48},
    { 1128, 72, -96},
    { 1304, 160, -56},
    { 1168, 88, -56},
    { 896, 152, -80},
    { 672, 160, -168},
    { 528, 184, -160},
    { 520, 176, -96},
    { 656, 184, -72},
    { 832, 232, -144},
    { 936, 240, -184},
    { 1120, 272, -272},
    { 1056, 272, -312},
    { 1104, 272, -256},
    { 1328, 312, -240},
    { 1064, 296, -232},
    { 1104, 272, -160},
    { 1200, 272, -136},
    { 1224, 264, -128},
    // 101 seconds
    { 1032, 224, -72},
    { 848, 192, -40},
    { 760, 184, -40},
    { 768, 112, -32},
    { 800, 128, 0},
    { 864, 96, 0},
    { 968, 80, -32},
    { 1032, 112, -56},
    { 1104, 56, -16},
    { 1040, -16, 56},
    { 1232, 32, 16},
    { 1160, 64, 72},
    { 1128, 96, -8},
    { 1280, 112, 0},
    { 1208, 200, -56},
    { 992, 264, -96},
    { 696, 208, -144},
    { 584, 192, -104},
    { 560, 224, -112},
    { 656, 256, -152},
    { 832, 288, -240},
    { 1064, 312, -312},
    { 1232, 344, -408},
    { 1096, 312, -336},
    { 1344, 288, -256},
    // 102 seconds
    { 1136, 328, -264},
    { 1120, 344, -192},
    { 1232, 272, -48},
    { 1248, 272, 64},
    { 1200, 216, 88},
    { 960, 232, 0},
    { 840, 208, -32},
    { 752, 160, 8},
    { 752, 120, 32},
    { 808, 112, 24},
    { 816, 104, 8},
    { 984, 128, -16},
    { 1024, 128, -24},
    { 1048, 120, -40},
    { 1176, 136, -88},
    { 1152, 136, -72},
    { 1048, 120, -112},
    { 1136, 104, -104},
    { 1256, 176, -112},
    { 1144, 216, -104},
    { 896, 256, -88},
    { 688, 240, -128},
    { 608, 256, -176},
    { 648, 208, -104},
    { 752, 208, -144},
    // 103 seconds
    { 888, 240, -200},
    { 1064, 272, -288},
    { 1088, 304, -336},
    { 1040, 288, -344},
    { 1200, 280, -240},
    { 1112, 280, -240},
    { 1048, 264, -216},
    { 1184, 288, -152},
    { 1304, 272, -88},
    { 1224, 264, -16},
    { 1032, 240, -48},
    { 856, 200, -40},
    { 768, 176, -8},
    { 720, 112, 0},
    { 720, 128, 32},
    { 768, 120, 16},
    { 920, 112, 0},
    { 1024, 168, -56},
    { 1016, 120, -80},
    { 1224, 120, -104},
    { 1240, 96, -72},
    { 1120, 112, -80},
    { 1208, 152, -120},
    { 1312, 184, -144},
    { 1144, 192, -128},
    // 104 seconds
    { 824, 208, -104},
    { 624, 232, -144},
    { 544, 192, -168},
    { 568, 208, -96},
    { 672, 200, -112},
    { 800, 216, -152},
    { 1000, 280, -208},
    { 1128, 344, -264},
    { 1120, 360, -224},
    { 1304, 328, -176},
    { 1272, 384, -208},
    { 1064, 304, -232},
    { 1056, 312, -232},
    { 1152, 288, -200},
    { 1152, 224, -120},
    { 968, 176, -40},
    { 808, 152, -64},
    { 696, 128, -16},
    { 688, 160, 0},
    { 744, 136, 24},
    { 872, 136, 8},
    { 1112, 144, 16},
    { 1208, 192, -8},
    { 1184, 152, -8},
    { 1256, 80, -24},
    // 105 seconds
    { 1208, 56, -16},
    { 1000, 32, -72},
    { 1192, 128, -56},
    { 1232, 104, -48},
    { 1072, 192, -96},
    { 808, 216, -136},
    { 600, 208, -168},
    { 504, 184, -128},
    { 528, 160, -80},
    { 680, 208, -136},
    { 872, 232, -192},
    { 1184, 296, -256},
    { 1168, 320, -312},
    { 1136, 312, -288},
    { 1328, 288, -264},
    { 1104, 336, -256},
    { 984, 280, -152},
    { 1112, 256, -96},
    { 1216, 272, -72},
    { 1128, 296, -64},
    { 912, 240, -24},
    { 736, 176, -32},
    { 736, 176, -8},
    { 760, 152, 16},
    { 848, 136, 56},
    // 106 seconds
    { 960, 120, 88},
    { 1128, 120, 128},
    { 1048, 40, 104},
    { 1040, 32, -72},
    { 1256, 64, -88},
    { 1296, 64, -8},
    { 1152, 64, -24},
    { 1184, 96, -88},
    { 1232, 176, -152},
    { 1088, 224, -200},
    { 784, 208, -208},
    { 568, 176, -168},
    { 488, 168, -136},
    { 544, 192, -152},
    { 696, 208, -136},
    { 872, 232, -176},
    { 1072, 248, -232},
    { 1064, 312, -304},
    { 1056, 264, -272},
    { 1328, 264, -224},
    { 1272, 304, -256},
    { 1080, 288, -144},
    { 1080, 240, -136},
    { 1136, 248, -120},
    { 1088, 256, -80},
    // 107 seconds
    { 880, 208, -32},
    { 744, 152, -40},
    { 728, 128, -40},
    { 752, 152, -16},
    { 824, 112, 0},
    { 872, 88, 16},
    { 1056, 96, -24},
    { 1064, 104, -24},
    { 1072, 88, -96},
    { 1224, 88, -168},
    { 1192, 16, -16},
    { 1064, 56, 48},
    { 1256, 200, -112},
    { 1304, 264, -176},
    { 1080, 288, -176},
    { 752, 224, -208},
    { 552, 152, -128},
    { 496, 144, -96},
    { 560, 184, -120},
    { 728, 232, -160},
    { 856, 232, -232},
    { 1032, 264, -288},
    { 984, 288, -352},
    { 1072, 272, -296},
    { 1280, 256, -184},
    // 108 seconds
    { 1208, 296, -224},
    { 1080, 288, -168},
    { 1192, 296, -128},
    { 1288, 296, -104},
    { 1176, 280, -48},
    { 904, 208, -24},
    { 768, 152, -24},
    { 696, 136, -24},
    { 760, 128, -24},
    { 800, 104, 16},
    { 880, 48, -8},
    { 1016, 56, 8},
    { 1072, 64, 8},
    { 1120, 96, -16},
    { 1200, 128, -16},
    { 1200, 160, 16},
    { 1272, 160, -32},
    { 1368, 184, -64},
    { 1232, 200, -152},
    { 912, 224, -176},
    { 632, 200, -216},
    { 512, 160, -216},
    { 504, 120, -104},
    { 616, 184, -80},
    { 824, 240, -160},
    // 109 seconds
    { 1056, 312, -232},
    { 1040, 320, -288},
    { 1088, 304, -272},
    { 1248, 304, -216},
    { 1240, 312, -216},
    { 1080, 296, -176},
    { 1200, 304, -128},
    { 1248, 280, -96},
    { 1136, 256, -64},
    { 904, 208, -56},
    { 736, 168, -56},
    { 720, 136, -80},
    { 744, 120, -32},
    { 832, 120, 0},
    { 880, 128, -24},
    { 992, 112, -32},
    { 1128, 104, -24},
    { 1136, 64, -24},
    { 1328, 88, -48},
    { 1160, 112, -32},
    { 1024, 112, -96},
    { 1264, 168, -96},
    { 1224, 208, -120},
    { 968, 224, -200},
    { 688, 192, -192},
    // 110 seconds
    { 544, 136, -176},
    { 528, 152, -112},
    { 648, 176, -72},
    { 800, 224, -112},
    { 984, 304, -216},
    { 1040, 336, -280},
    { 1024, 328, -272},
    { 1096, 304, -216},
    { 1336, 312, -200},
    { 1080, 320, -208},
    { 1176, 320, -128},
    { 1240, 296, -96},
    { 1248, 264, -72},
    { 1056, 232, -32},
    { 816, 184, -48},
    { 696, 168, -48},
    { 720, 160, -48},
    { 776, 120, 0},
    { 840, 112, 48},
    { 968, 136, 0},
    { 1072, 168, -8},
    { 1080, 168, -32},
    { 1168, 160, -64},
    { 1112, 160, -8},
    { 1040, 136, -88},
    // 111 seconds
    { 1208, 120, -56},
    { 1344, 168, -56},
    { 1224, 200, -144},
    { 904, 224, -192},
    { 632, 184, -232},
    { 520, 112, -192},
    { 520, 104, -120},
    { 648, 176, -128},
    { 848, 272, -192},
    { 1048, 336, -256},
    { 1176, 336, -328},
    { 1080, 312, -272},
    { 1224, 272, -176},
    { 1248, 344, -184},
    { 1000, 312, -168},
    { 1120, 304, -104},
    { 1200, 304, -80},
    { 1136, 312, -56},
    { 992, 256, -24},
    { 824, 208, -40},
    { 768, 160, -16},
    { 768, 152, -8},
    { 816, 144, -8},
    { 880, 72, 0},
    { 960, 80, 0},
    // 112 seconds
    { 1048, 128, -16},
    { 1040, 128, -16},
    { 1192, 168, -48},
    { 1176, 152, -16},
    { 1064, 168, -16},
    { 1240, 112, -32},
    { 1352, 168, -16},
    { 1184, 224, -104},
    { 856, 224, -152},
    { 608, 184, -176},
    { 504, 152, -160},
    { 528, 160, -112},
    { 656, 168, -136},
    { 848, 216, -192},
    { 1088, 280, -280},
    { 1088, 312, -288},
    { 1128, 296, -272},
    { 1368, 328, -264},
    { 1184, 352, -240},
    { 1032, 296, -136},
    { 1128, 280, -112},
    { 1216, 288, -96},
    { 1144, 272, -48},
    { 960, 224, -24},
    { 832, 176, -24},
    // 113 seconds
    { 744, 176, -16},
    { 760, 168, -8},
    { 784, 128, 16},
    { 888, 88, 24},
    { 1000, 88, 0},
    { 1088, 104, -32},
    { 1040, 152, -56},
    { 1192, 72, -40},
    { 1064, -8, 8},
    { 1232, 104, -16},
    { 1368, 216, -88},
    { 1272, 248, -112},
    { 1016, 256, -136},
    { 752, 216, -160},
    { 576, 192, -192},
    { 520, 184, -160},
    { 576, 200, -152},
    { 752, 248, -200},
    { 1080, 320, -328},
    { 1128, 336, -320},
    { 1184, 336, -240},
    { 1360, 400, -248},
    { 1152, 400, -216},
    { 1160, 344, -112},
    { 1216, 312, -72},
    // 114 seconds
    { 1280, 288, -40},
    { 1152, 248, 16},
    { 904, 168, -24},
    { 752, 152, -16},
    { 728, 168, 0},
    { 776, 152, 48},
    { 832, 152, 24},
    { 888, 80, 40},
    { 1056, 112, 32},
    { 984, 88, 8},
    { 1088, 48, -80},
    { 1248, 120, -64},
    { 1192, 104, 0},
    { 1200, 128, -32},
    { 1312, 208, -56},
    { 1248, 248, -128},
    { 1000, 272, -216},
    { 712, 208, -184},
    { 568, 184, -144},
    { 560, 184, -136},
    { 664, 216, -128},
    { 832, 272, -240},
    { 1072, 360, -304},
    { 1088, 360, -312},
    { 1040, 352, -280},
    // 115 seconds
    { 1288, 336, -224},
    { 1320, 336, -208},
    { 1096, 328, -136},
    { 1200, 320, -104},
    { 1264, 328, -104},
    { 1176, 224, -56},
    { 992, 168, -48},
    { 808, 152, -40},
    { 712, 96, -56},
    { 720, 80, -32},
    { 752, 96, -8},
    { 816, 96, -8},
    { 984, 184, -64},
    { 1056, 192, -152},
    { 1080, 160, -184},
    { 1144, 128, -120},
    { 1152, 200, 0},
    { 1208, 80, -96},
    { 1328, 128, -48},
    { 1224, 160, -136},
    { 984, 216, -280},
    { 696, 200, -208},
    { 560, 128, -184},
    { 536, 160, -152},
    { 584, 192, -112},
    // 116 seconds
    { 744, 208, -160},
    { 1032, 256, -200},
    { 1176, 336, -296},
    { 1168, 352, -312},
    { 1208, 328, -264},
    { 1224, 304, -240},
    { 1048, 328, -168},
    { 1184, 280, -120},
    { 1248, 272, -56},
    { 1144, 264, -32},
    { 960, 232, -48},
    { 800, 216, -88},
    { 728, 200, -48},
    { 768, 160, -16},
    { 824, 112, 16},
    { 872, 112, -16},
    { 968, 104, -32},
    { 1040, 96, -16},
    { 1104, 80, -32},
    { 1264, 136, -40},
    { 1232, 176, -32},
    { 1088, 152, -72},
    { 1200, 176, -72},
    { 1232, 176, -56},
    { 1080, 240, -112},
    // 117 seconds
    { 800, 240, -160},
    { 600, 216, -168},
    { 520, 184, -168},
    { 568, 160, -96},
    { 696, 208, -120},
    { 848, 272, -216},
    { 1064, 280, -296},
    { 1064, 296, -296},
    { 1192, 328, -272},
    { 1424, 384, -208},
    { 1120, 352, -176},
    { 1096, 296, -104},
    { 1160, 280, -104},
    { 1168, 264, -80},
    { 1056, 216, -16},
    { 864, 168, -40},
    { 712, 168, -40},
    { 680, 120, -24},
    { 696, 120, -24},
    { 712, 64, 0},
    { 792, 8, -8},
    { 992, 56, -24},
    { 1048, 96, -16},
    { 1192, 112, -64},
    { 1304, 160, -24},
    // 118 seconds
    { 1224, 176, -8},
    { 1312, 184, -80},
    { 1368, 232, -88},
    { 1160, 264, -136},
    { 800, 248, -176},
    { 544, 208, -200},
    { 448, 176, -184},
    { 496, 152, -128},
    { 640, 192, -176},
    { 800, 240, -240},
    { 984, 280, -264},
    { 1128, 296, -272},
    { 1128, 288, -216},
    { 1216, 288, -192},
    { 1168, 296, -176},
    { 1264, 320, -128},
    { 1344, 280, -56},
    { 1256, 256, -32},
    { 984, 248, -32},
    { 736, 200, -48},
    { 664, 160, -48},
    { 656, 136, -8},
    { 736, 112, -16},
    { 800, 96, -8},
    { 912, 88, -32},
    // 119 seconds
    { 1016, 88, -32},
    { 1056, 96, -56},
    { 1272, 144, -88},
    { 1296, 176, 8},
    { 1184, 128, -40},
    { 1376, 200, -112},
    { 1296, 240, -112},
    { 976, 232, -120},
    { 680, 200, -128},
    { 520, 192, -168},
    { 480, 184, -96},
    { 576, 200, -48},
    { 776, 232, -128},
    { 912, 216, -192},
    { 1056, 272, -216},
    { 1112, 304, -288},
    { 1256, 304, -272},
    { 1240, 352, -288},
    { 1096, 320, -208},
    { 1288, 352, -136},
    { 1352, 240, -104},
    { 1168, 216, -40},
    { 920, 88, -24},
    { 720, 144, -80},
    { 696, 136, -8},
    // 120 seconds
    // elapsed: 2 minutes
    { 688, 120, 40},
    { 784, 160, 40},
    { 824, 128, 24},
    { 1000, 88, 16},
    { 1064, 72, 40},
    { 1072, 56, 56},
    { 1304, 128, 48},
    { 1192, 104, 88},
    { 1128, 104, 0},
    { 1312, 192, -64},
    { 1240, 128, -56},
    { 1016, 200, -88},
    { 736, 208, -152},
    { 592, 240, -160},
    { 544, 208, -136},
    { 632, 216, -112},
    { 728, 216, -208},
    { 920, 224, -192},
    { 1072, 256, -248},
    { 1160, 320, -280},
    { 1336, 320, -256},
    { 1248, 344, -256},
    { 1000, 264, -152},
    { 1104, 248, -136},
    { 1216, 216, -104},
    // 121 seconds
    { 1192, 224, -16},
    { 1032, 200, 16},
    { 832, 192, -16},
    { 752, 200, 16},
    { 728, 144, 24},
    { 792, 160, 40},
    { 792, 96, 40},
    { 888, 96, 32},
    { 1032, 144, -16},
    { 1072, 136, -32},
    { 1296, 96, 48},
    { 1216, 128, 32},
    { 976, 152, -48},
    { 1056, 168, -120},
    { 1296, 136, -104},
    { 1256, 200, -128},
    { 1008, 216, -152},
    { 744, 240, -176},
    { 600, 280, -192},
    { 560, 232, -144},
    { 592, 200, -104},
    { 688, 264, -184},
    { 832, 248, -248},
    { 992, 288, -304},
    { 1056, 280, -280},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

