/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:41:10 local
AccelRawData *activity_sample_walk_100_pbl_25655_1(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25655_1
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -8, -424, -832},
    { -8, -568, -760},
    { -48, -568, -752},
    { -56, -568, -800},
    { -96, -640, -728},
    { -8, -552, -792},
    { -144, -552, -744},
    { -104, -632, -768},
    { 0, -624, -816},
    { -40, -656, -768},
    { 64, -720, -944},
    { -64, -648, -664},
    { -16, -624, -736},
    { -64, -592, -768},
    { -64, -584, -744},
    { -64, -616, -736},
    { -40, -600, -744},
    { 112, -872, -640},
    { -168, -656, -704},
    { -184, -616, -712},
    { -160, -592, -752},
    { -128, -640, -736},
    { -48, -664, -712},
    { -56, -416, -784},
    { -136, -656, -744},
    // 1 seconds
    { -56, -616, -720},
    { -80, -656, -760},
    { -232, -496, -720},
    { -240, -624, -712},
    { -416, -640, -584},
    { -408, -480, -824},
    { -160, -304, -872},
    { 256, -64, -928},
    { 216, 824, -488},
    { 1168, 312, -1096},
    { 528, 168, -568},
    { 720, 512, -848},
    { 416, 600, -576},
    { 568, 192, -808},
    { 512, 408, -688},
    { 544, 304, -656},
    { 480, 400, -792},
    { 456, 208, -576},
    { 528, 184, -736},
    { 576, 344, -720},
    { 560, 376, -720},
    { 496, 576, -848},
    { 520, 568, -760},
    { 512, 464, -776},
    { 488, 544, -784},
    // 2 seconds
    { 456, 456, -728},
    { 408, 424, -680},
    { 416, 464, -704},
    { 496, 480, -824},
    { 464, 544, -784},
    { 440, 464, -728},
    { 472, 376, -680},
    { 496, 384, -656},
    { 488, 376, -664},
    { 472, 488, -640},
    { 432, 408, -720},
    { 440, 456, -672},
    { 456, 448, -688},
    { 480, 408, -720},
    { 368, 600, -704},
    { 552, 712, -936},
    { 504, 960, -784},
    { 256, 960, -736},
    { 336, 1088, -856},
    { 448, 720, -464},
    { 384, 720, -432},
    { 320, 656, -352},
    { 360, 640, -496},
    { 328, 616, -512},
    { 304, 488, -344},
    // 3 seconds
    { 400, 528, -432},
    { 448, 544, -456},
    { 400, 624, -456},
    { 416, 600, -496},
    { 480, 656, -584},
    { 432, 848, -400},
    { 232, 1000, -800},
    { 480, 1312, -872},
    { 104, 992, -480},
    { 192, 1040, -680},
    { 288, 600, -520},
    { 272, 488, -336},
    { 280, 552, -384},
    { 320, 576, -376},
    { 328, 608, -440},
    { 312, 648, -408},
    { 280, 616, -400},
    { 272, 664, -472},
    { 368, 544, -472},
    { 424, 664, -480},
    { 560, 744, -392},
    { 312, 912, -600},
    { 640, 1592, -728},
    { 264, 1296, -456},
    { 304, 1032, -312},
    // 4 seconds
    { 368, 816, -272},
    { 288, 664, -144},
    { 264, 656, -168},
    { 320, 720, -248},
    { 312, 648, -264},
    { 360, 552, -168},
    { 408, 664, -272},
    { 432, 680, -320},
    { 416, 752, -296},
    { 416, 680, -408},
    { 496, 736, -336},
    { 352, 1000, -688},
    { 440, 1296, -544},
    { 472, 1344, -728},
    { 144, 1264, -600},
    { 128, 992, -384},
    { 160, 760, -392},
    { 224, 640, -384},
    { 304, 400, -224},
    { 328, 520, -328},
    { 368, 560, -312},
    { 400, 624, -344},
    { 376, 744, -416},
    { 408, 752, -424},
    { 400, 712, -336},
    // 5 seconds
    { 496, 856, -440},
    { 488, 688, -456},
    { 472, 1136, -368},
    { 616, 1392, -800},
    { 320, 1408, -336},
    { 320, 912, -264},
    { 408, 1096, -376},
    { 280, 608, -120},
    { 192, 512, -112},
    { 232, 584, -280},
    { 280, 496, -304},
    { 280, 520, -184},
    { 376, 696, -416},
    { 416, 768, -264},
    { 440, 832, -328},
    { 584, 1056, -736},
    { 360, 984, -304},
    { 296, 992, -272},
    { 336, 1568, -664},
    { 32, 1224, -432},
    { 136, 824, -416},
    { 168, 752, -408},
    { 184, 528, -256},
    { 256, 520, -184},
    { 296, 536, -288},
    // 6 seconds
    { 272, 536, -256},
    { 368, 664, -352},
    { 384, 840, -400},
    { 352, 832, -384},
    { 424, 792, -440},
    { 416, 864, -488},
    { 424, 904, -296},
    { 520, 1344, -552},
    { 360, 1344, -56},
    { 248, 968, -248},
    { 432, 2056, -216},
    { 272, 648, 456},
    { 112, 1000, 128},
    { 120, 576, 216},
    { 216, 800, 112},
    { 208, 608, 208},
    { 288, 448, 296},
    { 352, 936, 128},
    { 328, 896, 224},
    { 408, 784, 232},
    { 480, 984, 184},
    { 456, 1128, 296},
    { 352, 896, 208},
    { 472, 1648, 144},
    { 96, 1096, 232},
    // 7 seconds
    { 272, 992, 144},
    { 264, 856, -8},
    { 216, 792, 128},
    { 312, 776, 32},
    { 304, 632, 96},
    { 304, 720, 72},
    { 336, 712, 64},
    { 368, 688, 160},
    { 376, 1000, 40},
    { 416, 880, 80},
    { 528, 896, 168},
    { 392, 1144, 424},
    { 416, 1120, 152},
    { 392, 1672, 424},
    { 56, 1072, 576},
    { 400, 1056, 160},
    { 336, 824, 328},
    { 240, 792, 400},
    { 328, 712, 208},
    { 320, 760, 224},
    { 320, 616, 208},
    { 336, 768, 304},
    { 368, 768, 216},
    { 320, 848, 328},
    { 392, 840, 184},
    // 8 seconds
    { 400, 928, 248},
    { 392, 1008, 232},
    { 352, 1016, 168},
    { 304, 1096, 360},
    { 224, 1544, 168},
    { 72, 1248, 440},
    { 128, 1040, 88},
    { 288, 832, 32},
    { 208, 680, 160},
    { 304, 544, 112},
    { 320, 640, 128},
    { 360, 824, 144},
    { 360, 784, 152},
    { 344, 864, 192},
    { 328, 960, 136},
    { 336, 704, 64},
    { 416, 776, 88},
    { 408, 960, 80},
    { 360, 1232, 264},
    { 424, 1432, 416},
    { 88, 1840, 608},
    { 224, 1200, 416},
    { 288, 912, 400},
    { 168, 960, 408},
    { 160, 696, 208},
    // 9 seconds
    { 192, 648, 184},
    { 240, 504, 224},
    { 256, 416, 112},
    { 288, 576, 64},
    { 264, 648, 96},
    { 192, 440, 88},
    { 112, 312, 64},
    { -104, 400, -296},
    { -320, 408, -144},
    { -904, 376, -48},
    { -2928, 2072, 112},
    { -1568, 1736, 232},
    { -1016, 1168, 96},
    { -688, 832, -240},
    { -608, 568, -240},
    { -336, 312, -64},
    { -104, 128, -64},
    { -152, 336, 0},
    { -248, 360, -40},
    { -472, 336, -112},
    { -600, 472, -24},
    { -648, 456, -32},
    { -800, 456, -64},
    { -1040, 968, 368},
    { -1504, 1608, -712},
    // 10 seconds
    { -1216, 184, 672},
    { -648, 1472, -128},
    { -792, 688, -40},
    { -680, 888, 80},
    { -696, 488, 336},
    { -408, 560, 136},
    { -480, 456, 208},
    { -504, 344, 224},
    { -544, 320, 64},
    { -664, 464, 64},
    { -560, 288, 32},
    { -504, 440, 8},
    { -640, 520, -56},
    { -776, 488, -144},
    { -872, 688, -88},
    { -1024, 544, -336},
    { -1528, -168, 152},
    { -1104, 616, -360},
    { -920, 280, -176},
    { -752, 328, -96},
    { -664, 200, -32},
    { -592, 264, -40},
    { -600, 232, -168},
    { -616, 432, -56},
    { -736, 384, -16},
    // 11 seconds
    { -744, 288, -80},
    { -752, 304, -152},
    { -976, 352, -216},
    { -1136, 384, -240},
    { -1104, 288, -312},
    { -1456, 408, -304},
    { -1192, 296, -432},
    { -1000, 176, -96},
    { -1152, 664, -144},
    { -1112, 328, 128},
    { -832, 272, 56},
    { -624, 272, 56},
    { -624, 328, 64},
    { -592, 264, 104},
    { -592, 248, 88},
    { -528, 232, 56},
    { -464, 232, 72},
    { -536, 272, 40},
    { -880, 288, -24},
    { -920, 416, -120},
    { -1320, 352, -16},
    { -1488, 408, -24},
    { -1192, 560, -600},
    { -976, 24, -24},
    { -1008, 240, -248},
    // 12 seconds
    { -600, 192, -280},
    { -496, 304, -256},
    { -520, 296, -200},
    { -616, 352, -128},
    { -728, 400, -152},
    { -768, 272, -152},
    { -800, 304, -152},
    { -1040, 376, -200},
    { -1016, 168, -144},
    { -1232, 344, -328},
    { -1280, 424, -120},
    { -1264, 280, -344},
    { -1040, 496, -72},
    { -1264, 440, 0},
    { -1184, 384, 96},
    { -984, 400, -104},
    { -792, 384, -128},
    { -592, 64, 0},
    { -552, 88, 48},
    { -568, 160, 0},
    { -568, 104, -8},
    { -520, 240, 144},
    { -624, 192, 64},
    { -848, 240, -24},
    { -936, 472, 16},
    // 13 seconds
    { -1184, 208, -136},
    { -1384, 440, -184},
    { -1320, 480, -280},
    { -1160, 528, -336},
    { -872, 440, -248},
    { -648, 320, -304},
    { -472, 192, -88},
    { -512, 296, -136},
    { -552, 368, -232},
    { -712, 432, -176},
    { -816, 424, -168},
    { -872, 432, -200},
    { -1168, 504, -192},
    { -1320, 416, -248},
    { -1376, 488, -232},
    { -1136, 360, -200},
    { -904, 384, -224},
    { -1440, 792, -216},
    { -536, -704, 536},
    { -784, 168, 88},
    { -600, 472, -200},
    { -568, -256, 88},
    { -616, -192, 56},
    { -776, 360, 56},
    { -648, 112, 64},
    // 14 seconds
    { -704, 224, -64},
    { -832, 400, -32},
    { -936, 168, -80},
    { -1056, 264, -176},
    { -1064, 184, -72},
    { -1320, 160, -232},
    { -1272, 328, 56},
    { -1152, 280, -480},
    { -1016, 608, -344},
    { -752, -40, -128},
    { -544, 64, -184},
    { -456, 104, -224},
    { -432, 176, -152},
    { -664, 192, -136},
    { -792, 160, -200},
    { -856, 224, -200},
    { -912, 200, -160},
    { -920, 272, -208},
    { -1000, 424, -232},
    { -920, 240, -168},
    { -1472, 576, -248},
    { -1376, 368, -256},
    { -1472, 328, -168},
    { -1384, 24, 32},
    { -1256, 160, 64},
    // 15 seconds
    { -984, 320, 8},
    { -720, 152, 40},
    { -440, 176, 96},
    { -336, 128, 72},
    { -352, 176, 96},
    { -520, 368, 24},
    { -576, 408, 64},
    { -432, 328, -8},
    { -584, 488, -56},
    { -776, 392, -128},
    { -920, 384, -96},
    { -1184, 384, -40},
    { -1344, 176, -80},
    { -1440, 576, -160},
    { -1096, 512, -288},
    { -1040, 328, -184},
    { -904, 320, -280},
    { -560, 192, -200},
    { -424, 280, -248},
    { -504, 288, -136},
    { -648, 392, -240},
    { -768, 384, -336},
    { -840, 528, -296},
    { -808, 392, -296},
    { -944, 432, -496},
    // 16 seconds
    { -1048, 400, -360},
    { -1176, 336, -248},
    { -1216, 224, -256},
    { -1128, 288, -120},
    { -1000, 304, 56},
    { -1320, 272, -152},
    { -992, 200, 208},
    { -848, 80, 160},
    { -632, 144, -16},
    { -632, -24, 32},
    { -576, 120, 48},
    { -632, 232, -56},
    { -672, 168, -16},
    { -784, 352, -24},
    { -704, 296, -120},
    { -936, 296, -144},
    { -1056, 496, -72},
    { -1032, 216, -176},
    { -1344, 296, -176},
    { -1488, 504, -152},
    { -1168, 552, -224},
    { -832, 504, -296},
    { -744, 264, -8},
    { -656, 0, -48},
    { -528, -16, -88},
    // 17 seconds
    { -536, 264, -184},
    { -640, 432, -216},
    { -792, 520, -176},
    { -760, 208, -232},
    { -760, 192, -200},
    { -744, 240, -176},
    { -920, 392, -248},
    { -1008, 344, -64},
    { -1376, 528, -360},
    { -1544, 528, -192},
    { -1232, 472, -16},
    { -1304, 264, 64},
    { -1432, 312, -304},
    { -912, -96, 192},
    { -624, -32, 104},
    { -536, 328, -200},
    { -496, 72, 24},
    { -480, 176, 32},
    { -520, 248, -48},
    { -560, 264, -48},
    { -512, 304, -48},
    { -664, 384, -48},
    { -1024, 560, -144},
    { -1088, 56, 96},
    { -1400, 952, -496},
    // 18 seconds
    { -1304, -24, 120},
    { -1368, 552, -312},
    { -928, 272, -232},
    { -944, 288, -40},
    { -680, 144, -168},
    { -536, 168, -200},
    { -528, 344, -216},
    { -584, 408, -176},
    { -672, 184, -112},
    { -840, 240, -96},
    { -752, 224, -72},
    { -712, 432, -152},
    { -904, 352, -200},
    { -1072, 608, -144},
    { -1160, 504, -192},
    { -1344, 776, -168},
    { -1168, 448, -72},
    { -1032, 496, -72},
    { -1328, 680, -152},
    { -1048, 392, 128},
    { -784, 256, 152},
    { -584, 224, -16},
    { -520, 264, 8},
    { -368, 88, 64},
    { -344, 272, 80},
    // 19 seconds
    { -376, 352, 0},
    { -304, 192, 16},
    { -480, 528, -64},
    { -704, 488, -112},
    { -1008, 472, -72},
    { -1208, 536, 48},
    { -1496, 376, -248},
    { -1720, 488, 104},
    { -1048, 768, -288},
    { -992, 448, -64},
    { -792, 520, 16},
    { -408, 208, -48},
    { -376, 384, -112},
    { -416, 432, -120},
    { -648, 504, -96},
    { -728, 360, 0},
    { -784, 488, -160},
    { -752, 536, -208},
    { -952, 784, -344},
    { -1008, 792, -336},
    { -1288, 936, -216},
    { -1360, 800, -104},
    { -1464, 576, 88},
    { -1088, 480, 296},
    { -1264, 336, 128},
    // 20 seconds
    { -936, 216, 144},
    { -584, -64, 168},
    { -464, 56, -8},
    { -408, 56, 80},
    { -464, 168, 64},
    { -488, 104, 8},
    { -512, 280, 24},
    { -624, 392, -80},
    { -800, 440, -128},
    { -976, 424, -88},
    { -1080, 552, -40},
    { -1224, 376, 16},
    { -1656, 592, -8},
    { -1112, 768, -344},
    { -984, 672, -264},
    { -800, 464, -304},
    { -584, 328, -248},
    { -432, 264, -176},
    { -448, 472, -144},
    { -608, 312, -136},
    { -712, 432, -144},
    { -800, 448, -176},
    { -736, 448, -320},
    { -992, 504, -176},
    { -984, 536, -144},
    // 21 seconds
    { -1128, 488, -112},
    { -1296, 760, -328},
    { -1520, 216, 64},
    { -640, 200, -136},
    { -1200, 208, -256},
    { -920, -8, 88},
    { -672, -144, 96},
    { -576, 280, -176},
    { -520, 120, -24},
    { -568, 240, -32},
    { -664, 296, -88},
    { -688, 304, 0},
    { -696, 336, -16},
    { -840, 448, -112},
    { -1080, 304, -40},
    { -1096, 448, -120},
    { -1368, 32, -160},
    { -1296, 488, -184},
    { -1312, 432, -176},
    { -648, 504, -184},
    { -800, 280, -120},
    { -632, 88, -184},
    { -632, 184, -176},
    { -632, 360, -152},
    { -592, 368, -120},
    // 22 seconds
    { -688, 376, -136},
    { -696, 360, -136},
    { -808, 496, -64},
    { -744, 528, 24},
    { -792, 424, 0},
    { -912, 624, -56},
    { -1016, 432, 104},
    { -1344, 256, -152},
    { -984, 456, -80},
    { -792, 272, -24},
    { -1136, 256, 16},
    { -952, 96, 200},
    { -704, 96, 48},
    { -600, 288, -120},
    { -584, 296, -24},
    { -600, 256, -8},
    { -688, 232, -24},
    { -816, 328, 16},
    { -896, 328, 80},
    { -1136, 392, 16},
    { -1208, 240, 88},
    { -1160, 464, -64},
    { -1024, 120, 112},
    { -1168, 352, -48},
    { -600, 296, -168},
    // 23 seconds
    { -848, 184, -88},
    { -776, 104, -80},
    { -672, 120, -104},
    { -552, 264, -144},
    { -552, 368, -168},
    { -632, 328, -96},
    { -752, 400, -200},
    { -744, 256, -168},
    { -808, 512, -248},
    { -1000, 712, -296},
    { -1144, 752, 72},
    { -1416, 664, -152},
    { -1144, 616, 32},
    { -928, 416, 72},
    { -1128, 416, -40},
    { -920, -40, 152},
    { -680, 72, 168},
    { -512, 112, 16},
    { -552, 248, -16},
    { -592, 200, 40},
    { -632, 280, 16},
    { -664, 264, 16},
    { -688, 264, 24},
    { -960, 344, -48},
    { -1176, 488, -40},
    // 24 seconds
    { -1136, 424, -128},
    { -1112, 320, 16},
    { -1000, 632, -216},
    { -952, 504, -296},
    { -976, 408, -120},
    { -712, 240, -128},
    { -480, 312, -184},
    { -472, 432, -192},
    { -568, 360, -152},
    { -656, 304, -128},
    { -752, 320, -184},
    { -760, 560, -136},
    { -896, 456, -216},
    { -1064, 648, -216},
    { -1240, 640, -224},
    { -1272, 608, -240},
    { -1184, 712, -32},
    { -936, -56, -184},
    { -888, 192, -72},
    { -768, 48, 64},
    { -632, 48, 24},
    { -576, 192, 144},
    { -560, 40, 88},
    { -624, 216, -8},
    { -672, 128, -40},
    // 25 seconds
    { -744, 528, 0},
    { -864, 328, 0},
    { -1112, 312, -56},
    { -1160, 392, -56},
    { -1200, 336, -136},
    { -1240, 424, -104},
    { -856, 304, -288},
    { -920, 192, -112},
    { -784, 280, -176},
    { -600, 280, -152},
    { -488, 288, -152},
    { -488, 344, -136},
    { -680, 448, -136},
    { -712, 408, -128},
    { -744, 472, -160},
    { -672, 440, -256},
    { -736, 528, -200},
    { -920, 384, -264},
    { -976, 504, -104},
    { -1352, 536, -216},
    { -1472, 568, -128},
    { -1008, 360, 80},
    { -952, 48, -224},
    { -1040, 176, 16},
    { -832, 8, 96},
    // 26 seconds
    { -584, 56, 16},
    { -512, 192, -8},
    { -568, 296, 16},
    { -616, 240, -8},
    { -624, 184, 0},
    { -648, 384, -88},
    { -592, 368, -80},
    { -904, 536, -144},
    { -984, 208, -120},
    { -1104, 456, -288},
    { -1272, -16, 152},
    { -1568, 136, -136},
    { -848, 400, -288},
    { -864, 368, -224},
    { -632, 96, -144},
    { -584, 160, -144},
    { -568, 232, -96},
    { -592, 352, -144},
    { -616, 432, -152},
    { -704, 360, -168},
    { -720, 496, -248},
    { -656, 488, -232},
    { -696, 528, -248},
    { -1040, 744, -152},
    { -1096, 336, -240},
    // 27 seconds
    { -1432, 648, 0},
    { -1176, 544, -32},
    { -1064, 504, -24},
    { -1016, 512, -64},
    { -864, 176, -16},
    { -696, 16, 136},
    { -456, 104, 24},
    { -520, 144, -96},
    { -544, 224, 16},
    { -640, 224, 64},
    { -696, 288, 8},
    { -664, 288, -8},
    { -776, 376, -80},
    { -1080, 384, -16},
    { -1000, 288, 8},
    { -1368, 416, -200},
    { -1488, 320, -136},
    { -920, 240, 40},
    { -960, 560, -280},
    { -824, 456, -248},
    { -656, 208, -104},
    { -624, 328, -96},
    { -480, 352, -136},
    { -536, 400, -224},
    { -608, 376, -176},
    // 28 seconds
    { -760, 680, -224},
    { -648, 560, -232},
    { -816, 528, -272},
    { -1120, 584, -144},
    { -1176, 536, 0},
    { -1224, 304, 48},
    { -1640, 520, -72},
    { -816, 8, 64},
    { -1152, 408, -128},
    { -800, 208, -88},
    { -680, 120, 24},
    { -536, 272, -40},
    { -544, 216, -64},
    { -496, 192, -16},
    { -520, 256, -56},
    { -632, 360, -88},
    { -704, 304, -40},
    { -856, 304, -8},
    { -1128, 368, -24},
    { -1144, 456, 8},
    { -1248, 304, -112},
    { -1312, 488, -144},
    { -776, 552, -224},
    { -760, 304, -288},
    { -712, 352, -216},
    // 29 seconds
    { -696, 448, -240},
    { -536, 424, -216},
    { -568, 640, -144},
    { -560, 648, -152},
    { -544, 744, -88},
    { -592, 728, -24},
    { -624, 624, -56},
    { -808, 720, -96},
    { -976, 568, -32},
    { -1064, 240, 64},
    { -1312, 200, -320},
    { -1208, 368, -104},
    { -1000, 168, -88},
    { -1128, 328, -168},
    { -912, 72, 128},
    { -624, 344, 72},
    { -416, 600, -88},
    { -520, 384, 64},
    { -448, 448, -16},
    { -544, 376, 24},
    { -584, 472, -16},
    { -608, 448, -16},
    { -704, 400, -72},
    { -1064, 432, 32},
    { -912, 192, -96},
    // 30 seconds
    { -1464, 432, -144},
    { -1424, 160, -56},
    { -1032, 416, -16},
    { -760, 464, -192},
    { -824, 264, -120},
    { -776, 160, -168},
    { -608, 232, -192},
    { -528, 344, -160},
    { -520, 304, -120},
    { -592, 376, -208},
    { -616, 744, -256},
    { -656, 880, -176},
    { -696, 704, -232},
    { -1008, 608, -72},
    { -1136, 704, 32},
    { -1448, 448, 32},
    { -1800, 840, -56},
    { -768, 984, 80},
    { -1224, 840, 352},
    { -1056, 1472, 232},
    { -664, 600, 392},
    { -272, 456, 80},
    { -80, 536, -24},
    { -24, 224, 128},
    { 136, 256, 56},
    // 31 seconds
    { 192, 376, -72},
    { 224, 368, -48},
    { 296, 608, -8},
    { 208, 648, -64},
    { 184, 600, 48},
    { -64, 1000, 272},
    { -288, 1008, -304},
    { -224, 728, 392},
    { -384, 1848, 0},
    { -328, 1960, 224},
    { -224, 1480, 272},
    { -40, 904, 80},
    { 80, 568, 72},
    { 48, 616, 16},
    { 32, 584, 72},
    { -8, 776, -16},
    { 40, 784, -24},
    { 104, 680, -24},
    { 32, 640, -72},
    { -80, 688, -64},
    { -352, 632, -32},
    { -728, 608, 48},
    { -1400, 1200, 96},
    { -1048, 2432, 280},
    { -920, 1128, 512},
    // 32 seconds
    { -568, 1152, -128},
    { -288, 664, 40},
    { -240, 576, 0},
    { -200, 648, -32},
    { -176, 376, 168},
    { -176, 608, -24},
    { -184, 704, 40},
    { -192, 728, 72},
    { -256, 872, 64},
    { -336, 976, -48},
    { -368, 1112, 48},
    { -432, 1192, 16},
    { -320, 832, 376},
    { -384, 1104, -280},
    { -512, 1088, 8},
    { -472, 872, 56},
    { -232, 616, -48},
    { -48, 440, -24},
    { -56, 448, -80},
    { -104, 416, 40},
    { -216, 504, 48},
    { -344, 888, -8},
    { -312, 912, 128},
    { -312, 1080, 112},
    { -328, 1184, 72},
    // 33 seconds
    { -440, 1256, 112},
    { -576, 1296, 208},
    { -488, 1272, 240},
    { -400, 1000, 504},
    { -488, 888, -104},
    { -744, 440, 400},
    { -440, 776, 32},
    { -312, 408, -8},
    { -280, 352, 144},
    { -400, 424, 72},
    { -496, 216, -80},
    { -648, 384, -80},
    { -848, 512, 40},
    { -976, 424, 24},
    { -1144, 376, 56},
    { -1056, 528, -168},
    { -1080, 376, -200},
    { -1352, 448, -96},
    { -1272, 544, -152},
    { -848, 456, -184},
    { -680, 152, -144},
    { -520, -56, -48},
    { -392, 80, -40},
    { -464, 152, -32},
    { -680, 376, -128},
    // 34 seconds
    { -776, 432, -112},
    { -744, 328, -88},
    { -584, 528, -256},
    { -672, 568, -224},
    { -904, 776, -192},
    { -864, 640, -88},
    { -984, 992, -152},
    { -1160, 144, -88},
    { -1200, 368, -72},
    { -1008, 392, -152},
    { -1360, 232, 32},
    { -816, 72, 152},
    { -512, 256, -64},
    { -448, 320, 16},
    { -448, 208, 56},
    { -496, 256, 8},
    { -608, 360, 112},
    { -632, 472, 96},
    { -696, 544, 8},
    { -816, 592, 24},
    { -952, 536, 8},
    { -1144, 640, -56},
    { -1056, 224, 56},
    { -1264, 296, -184},
    { -1184, 504, -208},
    // 35 seconds
    { -896, 440, -320},
    { -808, 224, -160},
    { -640, 176, -128},
    { -480, 248, -104},
    { -456, 304, -80},
    { -536, 304, -96},
    { -680, 464, -56},
    { -672, 392, -96},
    { -672, 416, 8},
    { -592, 424, -80},
    { -648, 328, -56},
    { -856, 488, -56},
    { -848, 608, 0},
    { -1192, 344, -152},
    { -1312, 600, 8},
    { -920, 672, -88},
    { -1024, 504, -32},
    { -1008, 400, -48},
    { -768, 360, 88},
    { -560, 432, -72},
    { -480, 448, -24},
    { -440, 264, 24},
    { -480, 448, 8},
    { -568, 448, 16},
    { -608, 424, 64},
    // 36 seconds
    { -656, 512, 24},
    { -880, 600, -64},
    { -952, 552, 96},
    { -1040, 504, -32},
    { -984, 696, -32},
    { -960, 624, -88},
    { -856, 600, -120},
    { -808, 536, -144},
    { -696, 432, -160},
    { -448, 368, -56},
    { -368, 384, -96},
    { -376, 488, -112},
    { -456, 408, -16},
    { -536, 448, -56},
    { -544, 472, -16},
    { -552, 528, -24},
    { -624, 624, -184},
    { -888, 664, -80},
    { -880, 616, 0},
    { -1328, 776, -104},
    { -1008, 800, -112},
    { -848, 696, -48},
    { -1120, 616, -8},
    { -928, 368, 144},
    { -632, 224, 136},
    // 37 seconds
    { -544, 392, -64},
    { -496, 232, 96},
    { -536, 312, 48},
    { -584, 400, 8},
    { -632, 368, 56},
    { -656, 496, 32},
    { -768, 552, 32},
    { -1000, 672, -24},
    { -944, 648, 104},
    { -992, 616, -8},
    { -928, 568, 40},
    { -768, 712, -120},
    { -856, 688, -160},
    { -624, 416, 16},
    { -512, 288, -40},
    { -408, 392, -88},
    { -384, 344, -40},
    { -456, 432, -24},
    { -528, 528, -56},
    { -512, 504, -8},
    { -616, 536, -48},
    { -824, 712, -136},
    { -960, 528, 96},
    { -1360, 768, -80},
    { -1152, 712, 80},
    // 38 seconds
    { -800, 560, 8},
    { -848, 784, -176},
    { -888, 464, 128},
    { -648, 304, 176},
    { -528, 312, 24},
    { -504, 424, 8},
    { -520, 328, 160},
    { -576, 488, 64},
    { -592, 464, 88},
    { -600, 592, 56},
    { -664, 648, 40},
    { -888, 656, 0},
    { -816, 640, 24},
    { -1040, 680, -224},
    { -792, 312, 120},
    { -840, 736, -208},
    { -896, 640, -96},
    { -744, 536, -96},
    { -584, 424, -128},
    { -448, 384, -152},
    { -432, 344, -56},
    { -448, 456, -32},
    { -520, 544, -16},
    { -552, 536, -8},
    { -512, 616, -56},
    // 39 seconds
    { -600, 744, -88},
    { -736, 728, -24},
    { -1008, 864, -72},
    { -1080, 728, 120},
    { -896, 768, -32},
    { -800, 664, -24},
    { -864, 656, -48},
    { -784, 432, 144},
    { -528, 344, 56},
    { -496, 528, 40},
    { -472, 368, 120},
    { -496, 472, 72},
    { -528, 496, 48},
    { -536, 592, 72},
    { -584, 648, 72},
    { -800, 832, -8},
    { -792, 704, 88},
    { -1008, 792, -104},
    { -944, 624, -72},
    { -776, 640, -40},
    { -808, 808, -192},
    { -808, 600, -88},
    { -704, 456, -64},
    { -552, 376, -104},
    { -416, 384, -72},
    // 40 seconds
    { -416, 456, -40},
    { -472, 512, -32},
    { -504, 576, -24},
    { -480, 632, -32},
    { -448, 640, -56},
    { -576, 760, -64},
    { -712, 800, -48},
    { -672, 736, 304},
    { -896, 1008, -136},
    { -824, 768, 16},
    { -752, 792, -24},
    { -784, 672, 64},
    { -720, 600, 72},
    { -528, 528, 88},
    { -432, 480, -16},
    { -472, 464, 80},
    { -488, 584, 96},
    { -472, 576, 96},
    { -496, 632, 56},
    { -528, 640, 56},
    { -648, 768, 32},
    { -736, 824, 16},
    { -688, 704, -24},
    { -872, 864, -192},
    { -936, 640, -32},
    // 41 seconds
    { -800, 768, -88},
    { -776, 784, -152},
    { -640, 632, -64},
    { -472, 464, -88},
    { -352, 424, -64},
    { -336, 544, -64},
    { -352, 592, -40},
    { -392, 576, -64},
    { -440, 584, -64},
    { -432, 632, -56},
    { -520, 800, -112},
    { -608, 784, -56},
    { -576, 744, 32},
    { -1008, 944, -136},
    { -880, 872, 56},
    { -776, 880, -96},
    { -776, 768, -48},
    { -816, 608, 72},
    { -600, 496, 56},
    { -432, 560, -40},
    { -384, 432, 144},
    { -424, 608, 24},
    { -432, 528, 72},
    { -496, 616, 72},
    { -544, 760, 16},
    // 42 seconds
    { -656, 728, 64},
    { -728, 792, 48},
    { -824, 784, 8},
    { -880, 872, 0},
    { -768, 648, -8},
    { -584, 744, -96},
    { -656, 712, -96},
    { -688, 744, -112},
    { -528, 528, 24},
    { -384, 456, -96},
    { -312, 520, -24},
    { -360, 520, -16},
    { -424, 736, -88},
    { -424, 656, 0},
    { -424, 656, -40},
    { -496, 832, -112},
    { -584, 848, -40},
    { -832, 976, -16},
    { -888, 1032, -40},
    { -896, 888, -40},
    { -672, 864, -8},
    { -648, 752, 32},
    { -608, 624, 64},
    { -456, 584, -8},
    { -344, 472, 16},
    // 43 seconds
    { -360, 528, 40},
    { -392, 544, 56},
    { -440, 680, 8},
    { -424, 656, 96},
    { -440, 712, 16},
    { -576, 784, -24},
    { -704, 872, -8},
    { -760, 856, 16},
    { -864, 904, -72},
    { -776, 584, -16},
    { -648, 928, -256},
    { -776, 704, -136},
    { -712, 624, -32},
    { -504, 480, -120},
    { -360, 448, -104},
    { -328, 472, -48},
    { -352, 552, -56},
    { -432, 592, -48},
    { -424, 600, -112},
    { -448, 656, -24},
    { -592, 864, -152},
    { -704, 816, -24},
    { -880, 904, -8},
    { -1040, 1024, -56},
    { -904, 880, -16},
    // 44 seconds
    { -736, 744, 0},
    { -664, 632, 24},
    { -544, 320, 248},
    { -400, 536, -48},
    { -344, 432, -8},
    { -440, 584, -24},
    { -552, 560, 40},
    { -600, 688, 40},
    { -504, 712, 40},
    { -448, 672, 72},
    { -592, 768, -24},
    { -672, 760, -72},
    { -776, 776, -40},
    { -944, 936, -88},
    { -872, 1008, -88},
    { -744, 808, -64},
    { -664, 760, -192},
    { -544, 520, -88},
    { -240, 232, 56},
    { -248, 336, -80},
    { -312, 504, -8},
    { -384, 680, -128},
    { -432, 504, 64},
    { -432, 728, -120},
    { -392, 632, -24},
    // 45 seconds
    { -568, 904, -136},
    { -624, 872, -40},
    { -832, 944, -48},
    { -888, 1000, 8},
    { -832, 1040, -72},
    { -704, 832, 152},
    { -760, 736, 8},
    { -544, 528, 144},
    { -344, 496, -8},
    { -240, 424, 48},
    { -288, 456, 40},
    { -400, 592, 32},
    { -488, 728, 32},
    { -464, 696, 96},
    { -528, 824, 8},
    { -664, 904, 0},
    { -744, 920, -24},
    { -752, 744, 0},
    { -704, 816, -16},
    { -680, 904, -64},
    { -760, 936, -136},
    { -664, 728, -104},
    { -464, 536, -32},
    { -328, 408, -48},
    { -256, 528, -32},
    // 46 seconds
    { -280, 600, -72},
    { -352, 648, 8},
    { -336, 760, -56},
    { -368, 792, -24},
    { -512, 904, -64},
    { -552, 856, 0},
    { -688, 928, 48},
    { -824, 1064, -168},
    { -776, 920, 96},
    { -648, 848, 72},
    { -592, 912, 64},
    { -488, 712, 96},
    { -264, 608, 64},
    { -264, 560, 80},
    { -272, 600, 64},
    { -320, 744, 32},
    { -344, 696, 104},
    { -384, 872, 64},
    { -448, 904, 112},
    { -488, 888, 80},
    { -512, 896, 72},
    { -624, 1184, 24},
    { -568, 904, 80},
    { -592, 928, -16},
    { -616, 1080, -72},
    // 47 seconds
    { -512, 704, 24},
    { -288, 704, -56},
    { -176, 584, -56},
    { -176, 576, 16},
    { -216, 696, -32},
    { -240, 680, -40},
    { -232, 728, 0},
    { -272, 848, -32},
    { -344, 936, -8},
    { -448, 936, 0},
    { -720, 1184, -56},
    { -696, 1088, 56},
    { -672, 1096, 144},
    { -576, 1024, 112},
    { -512, 952, 64},
    { -360, 616, 256},
    { -216, 616, 64},
    { -208, 600, 80},
    { -272, 656, 120},
    { -288, 632, 152},
    { -328, 736, 128},
    { -368, 856, 112},
    { -504, 920, 144},
    { -424, 880, 136},
    { -624, 1104, 16},
    // 48 seconds
    { -576, 1072, 88},
    { -496, 1008, 0},
    { -544, 936, -72},
    { -520, 760, 32},
    { -344, 600, -16},
    { -192, 560, -56},
    { -176, 552, 16},
    { -232, 608, -16},
    { -272, 744, 0},
    { -256, 704, 56},
    { -256, 872, -8},
    { -352, 1000, -8},
    { -416, 976, 144},
    { -656, 1208, 24},
    { -592, 1192, 112},
    { -568, 1024, 208},
    { -536, 992, 128},
    { -448, 800, 224},
    { -344, 640, 184},
    { -224, 696, 48},
    { -200, 608, 88},
    { -232, 640, 144},
    { -264, 728, 96},
    { -280, 800, 96},
    { -288, 792, 152},
    // 49 seconds
    { -384, 968, 120},
    { -448, 1064, 88},
    { -440, 968, 112},
    { -584, 1072, -24},
    { -568, 1056, 64},
    { -496, 960, 48},
    { -504, 968, -40},
    { -360, 800, 56},
    { -232, 624, 16},
    { -152, 568, -40},
    { -120, 624, 8},
    { -160, 696, 8},
    { -168, 752, -32},
    { -200, 840, -8},
    { -184, 816, 40},
    { -232, 1016, -32},
    { -280, 1032, 128},
    { -504, 1152, 0},
    { -520, 1296, 64},
    { -504, 1104, 160},
    { -520, 1104, 112},
    { -488, 920, 160},
    { -376, 768, 176},
    { -208, 648, 88},
    { -160, 616, 80},
    // 50 seconds
    { -120, 600, 88},
    { -160, 712, 96},
    { -216, 816, 104},
    { -248, 832, 128},
    { -296, 952, 80},
    { -424, 1032, 112},
    { -392, 1024, 88},
    { -496, 1072, 64},
    { -528, 960, 40},
    { -416, 1040, 80},
    { -400, 1008, 16},
    { -360, 912, -16},
    { -248, 664, 56},
    { -184, 672, -48},
    { -136, 560, 24},
    { -152, 704, 24},
    { -192, 744, -40},
    { -232, 680, 24},
    { -184, 808, 24},
    { -152, 960, 16},
    { -296, 968, 56},
    { -536, 1224, 88},
    { -688, 1400, 168},
    { -480, 1208, 216},
    { -304, 976, 152},
    // 51 seconds
    { -328, 920, 56},
    { -328, 664, 240},
    { -280, 728, 120},
    { -200, 680, 80},
    { -176, 600, 152},
    { -160, 744, 96},
    { -176, 752, 128},
    { -176, 792, 136},
    { -184, 896, 88},
    { -272, 976, 160},
    { -392, 1160, 184},
    { -464, 1160, 208},
    { -480, 1144, 104},
    { -392, 1048, 128},
    { -320, 992, 80},
    { -352, 864, 16},
    { -376, 800, 40},
    { -232, 656, 40},
    { -144, 632, 0},
    { -136, 656, 88},
    { -152, 728, 72},
    { -168, 776, 32},
    { -144, 784, 80},
    { -88, 840, 40},
    { -160, 1032, -8},
    // 52 seconds
    { -240, 1056, 128},
    { -288, 1064, 144},
    { -416, 1424, 80},
    { -416, 1136, 296},
    { -384, 1088, 256},
    { -376, 1096, 152},
    { -360, 872, 272},
    { -224, 712, 176},
    { -120, 656, 120},
    { -128, 656, 88},
    { -128, 648, 160},
    { -128, 792, 96},
    { -168, 864, 144},
    { -176, 856, 136},
    { -248, 1008, 128},
    { -312, 1080, 144},
    { -232, 1000, 136},
    { -464, 1168, 48},
    { -520, 1096, 104},
    { -424, 1088, 184},
    { -408, 1120, 88},
    { -344, 896, 80},
    { -216, 680, 56},
    { -120, 600, 40},
    { -48, 600, 64},
    // 53 seconds
    { -72, 672, 56},
    { -112, 736, 40},
    { -128, 816, 88},
    { -120, 880, 40},
    { -88, 888, 64},
    { -152, 1048, 56},
    { -224, 960, 112},
    { -208, 1072, 176},
    { -456, 1360, 184},
    { -472, 1288, 272},
    { -424, 1192, 224},
    { -408, 1064, 232},
    { -304, 752, 272},
    { -168, 712, 144},
    { -104, 648, 72},
    { -80, 608, 160},
    { -128, 760, 112},
    { -136, 784, 176},
    { -136, 864, 160},
    { -120, 904, 112},
    { -136, 880, 160},
    { -192, 1008, 112},
    { -168, 952, 120},
    { -272, 1056, 32},
    { -424, 1160, 176},
    // 54 seconds
    { -472, 1232, 120},
    { -424, 1144, 112},
    { -424, 1000, 64},
    { -296, 816, 24},
    { -168, 600, 16},
    { -96, 664, 0},
    { -24, 656, 0},
    { -72, 712, 32},
    { -112, 832, 0},
    { -128, 800, 16},
    { -112, 856, 16},
    { -56, 896, 8},
    { -64, 976, 24},
    { -120, 1040, 72},
    { -104, 1056, 160},
    { -392, 1224, 160},
    { -320, 1176, 272},
    { -376, 1152, 272},
    { -400, 1136, 328},
    { -328, 1008, 280},
    { -160, 736, 200},
    { -88, 656, 120},
    { -88, 648, 144},
    { -112, 760, 176},
    { -104, 792, 128},
    // 55 seconds
    { -88, 800, 160},
    { -88, 864, 112},
    { -40, 864, 112},
    { -80, 992, 120},
    { -144, 1016, 136},
    { -160, 1024, 96},
    { -328, 1120, 88},
    { -448, 1120, 248},
    { -448, 1200, 152},
    { -392, 1192, 72},
    { -296, 872, 128},
    { -232, 792, 0},
    { -112, 704, 16},
    { -32, 600, 72},
    { -40, 704, 64},
    { -64, 824, 8},
    { -104, 776, 64},
    { -72, 784, 80},
    { -32, 872, 48},
    { -64, 976, 48},
    { -128, 1112, 104},
    { -120, 1144, 176},
    { -176, 1248, 232},
    { -304, 1416, 232},
    { -352, 1200, 336},
    // 56 seconds
    { -296, 1160, 336},
    { -208, 936, 256},
    { -80, 808, 192},
    { -24, 656, 152},
    { 48, 648, 152},
    { -8, 728, 112},
    { -40, 768, 168},
    { -64, 832, 128},
    { -56, 800, 144},
    { -64, 904, 128},
    { -120, 992, 96},
    { -152, 992, 136},
    { -224, 1120, 96},
    { -296, 1120, 176},
    { -304, 1264, 216},
    { -384, 1192, 168},
    { -280, 944, 88},
    { -296, 1032, 48},
    { -104, 704, 96},
    { 40, 704, 16},
    { 64, 648, 56},
    { 32, 752, 96},
    { 0, 904, 48},
    { 8, 968, 120},
    { 16, 1008, 24},
    // 57 seconds
    { 48, 872, 72},
    { 16, 968, 56},
    { 40, 840, 48},
    { 24, 904, 80},
    { -120, 1144, 120},
    { -184, 1344, 208},
    { -208, 1176, 376},
    { -224, 1184, 312},
    { -232, 1264, 408},
    { -136, 896, 336},
    { -8, 904, 160},
    { 24, 672, 176},
    { 80, 672, 152},
    { 64, 792, 24},
    { 56, 728, 176},
    { 48, 904, 168},
    { 64, 920, 160},
    { 56, 896, 152},
    { 72, 960, 80},
    { 40, 984, 104},
    { 8, 992, 80},
    { -48, 976, 56},
    { -184, 1112, 160},
    { -272, 1352, 160},
    { -248, 1256, 112},
    // 58 seconds
    { -240, 1200, 40},
    { -224, 928, 32},
    { -128, 752, 0},
    { -8, 704, -8},
    { 48, 672, 32},
    { 32, 712, 40},
    { 0, 792, 96},
    { -16, 848, 72},
    { -8, 824, 128},
    { 48, 912, 80},
    { 80, 888, 8},
    { -48, 1088, 32},
    { -80, 912, 200},
    { -88, 1328, 176},
    { -184, 1336, 264},
    { -280, 1360, 320},
    { -168, 1144, 320},
    { -192, 1144, 176},
    { -168, 872, 304},
    { -128, 752, 240},
    { -56, 768, 144},
    { 0, 648, 200},
    { -24, 736, 176},
    { -8, 816, 136},
    { -40, 824, 208},
    // 59 seconds
    { -40, 856, 176},
    { -64, 896, 192},
    { -104, 912, 184},
    { -152, 960, 144},
    { -176, 960, 112},
    { -240, 992, 88},
    { -232, 912, 128},
    { -448, 808, 240},
    { -568, 1536, 64},
    { -488, 1192, 96},
    { -376, 784, 104},
    { -224, 696, -32},
    { -144, 568, -32},
    { -168, 616, 56},
    { -208, 744, 0},
    { -240, 752, 16},
    { -248, 912, -16},
    { -232, 816, 24},
    { -224, 864, 8},
    { -256, 872, 40},
    { -352, 952, 88},
    { -360, 1016, 144},
    { -648, 1208, 104},
    { -784, 1336, 128},
    { -512, 992, 344},
    // 60 seconds
    // elapsed: 1 minutes
    { -472, 992, 160},
    { -432, 936, 136},
    { -344, 616, 272},
    { -288, 728, 96},
    { -216, 728, 128},
    { -208, 616, 232},
    { -208, 840, 88},
    { -192, 744, 152},
    { -176, 720, 168},
    { -144, 776, 128},
    { -120, 816, 112},
    { -216, 872, 112},
    { -272, 984, 80},
    { -304, 976, 104},
    { -448, 1104, 24},
    { -704, 1256, 184},
    { -592, 1288, 48},
    { -504, 1144, -56},
    { -360, 800, -24},
    { -240, 680, 8},
    { -152, 632, -8},
    { -104, 616, 40},
    { -104, 672, 40},
    { -144, 728, 0},
    { -152, 768, 48},
    // 61 seconds
    { -104, 800, 40},
    { -72, 856, 8},
    { -112, 920, 16},
    { -176, 896, 56},
    { -176, 904, 96},
    { -320, 1216, 120},
    { -512, 1440, 304},
    { -472, 1352, 352},
    { -432, 1176, 272},
    { -408, 1080, 240},
    { -304, 752, 328},
    { -200, 752, 216},
    { -136, 736, 136},
    { -96, 592, 200},
    { -80, 664, 136},
    { -112, 680, 136},
    { -136, 752, 216},
    { -136, 872, 176},
    { -120, 808, 168},
    { -128, 776, 152},
    { -168, 856, 112},
    { -216, 968, 64},
    { -352, 968, 72},
    { -392, 1144, 240},
    { -672, 1160, 184},
    // 62 seconds
    { -696, 1224, 136},
    { -592, 1168, 32},
    { -456, 816, 88},
    { -256, 688, 24},
    { -136, 616, -40},
    { -104, 576, 56},
    { -144, 680, 48},
    { -216, 816, -16},
    { -240, 744, 160},
    { -192, 888, 72},
    { -152, 896, 8},
    { -216, 848, 80},
    { -272, 968, 88},
    { -384, 968, 48},
    { -480, 1120, 232},
    { -608, 1360, 208},
    { -416, 1176, 224},
    { -392, 992, 264},
    { -416, 928, 256},
    { -336, 800, 264},
    { -264, 808, 128},
    { -208, 616, 176},
    { -176, 664, 168},
    { -160, 704, 128},
    { -176, 720, 184},
    // 63 seconds
    { -136, 768, 160},
    { -88, 784, 136},
    { -112, 792, 120},
    { -208, 888, 88},
    { -296, 1024, 136},
    { -536, 1152, 248},
    { -728, 1400, 256},
    { -464, 1224, 224},
    { -360, 968, 72},
    { -352, 944, 56},
    { -392, 744, 96},
    { -232, 584, 152},
    { -144, 712, 72},
    { -120, 664, 144},
    { -136, 688, 152},
    { -152, 808, 104},
    { -144, 760, 120},
    { -128, 776, 88},
    { -96, 792, 96},
    { -128, 792, 88},
    { -208, 944, 96},
    { -248, 944, 248},
    { -640, 1336, 256},
    { -976, 1552, 384},
    { -528, 1152, 448},
    // 64 seconds
    { -424, 832, 328},
    { -336, 648, 328},
    { -328, 616, 240},
    { -368, 704, 240},
    { -544, 752, 312},
    { -552, 728, 408},
    { -440, 872, 384},
    { -352, 952, 152},
    { -296, 736, 224},
    { -312, 728, 232},
    { -312, 816, 144},
    { -352, 840, 208},
    { -376, 824, 240},
    { -448, 808, 208},
    { -456, 920, 200},
    { -336, 808, 208},
    { -224, 848, 112},
    { -256, 904, 16},
    { -320, 856, 80},
    { -384, 920, 120},
    { -400, 960, 104},
    { -328, 904, 136},
    { -296, 872, 64},
    { -312, 832, 64},
    { -336, 824, 88},
    // 65 seconds
    { -336, 872, 80},
    { -328, 872, 112},
    { -288, 880, 112},
    { -264, 872, 104},
    { -248, 896, 112},
    { -272, 920, 72},
    { -264, 888, 104},
    { -272, 1000, 88},
    { -272, 1040, 72},
    { -280, 1080, 128},
    { -280, 1184, 112},
    { -280, 1128, 72},
    { -216, 960, 88},
    { -176, 952, 72},
    { -120, 864, 48},
    { -88, 888, 80},
    { -24, 896, 104},
    { 16, 824, 72},
    { 80, 872, 104},
    { 96, 976, 72},
    { 160, 896, 64},
    { 168, 1024, 40},
    { 208, 872, 64},
    { 248, 896, 48},
    { 256, 960, -16},
    // 66 seconds
    { 280, 864, 24},
    { 272, 896, -16},
    { 280, 1104, -136},
    { 336, 1400, -368},
    { 288, 1064, -256},
    { 200, 40, -320},
    { 376, 320, -656},
    { 280, 0, -888},
    { 184, 112, -952},
    { 184, -72, -880},
    { 216, -80, -848},
    { 216, -64, -872},
    { 216, -72, -880},
    { 232, -96, -936},
    { 192, -64, -984},
    { 176, -120, -912},
    { 184, -120, -936},
    { 200, -152, -944},
    { 184, -160, -896},
    { 184, -136, -936},
    { 176, -152, -944},
    { 176, -144, -936},
    { 192, -128, -960},
    { 184, -136, -928},
    { 192, -152, -928},
    // 67 seconds
    { 192, -136, -928},
    { 192, -128, -936},
    { 176, -152, -952},
    { 184, -152, -944},
    { 168, -136, -968},
    { 176, -144, -936},
    { 184, -144, -952},
    { 176, -152, -920},
    { 176, -152, -936},
    { 176, -136, -952},
    { 184, -136, -944},
    { 176, -136, -928},
    { 176, -136, -936},
    { 176, -136, -936},
    { 184, -152, -936},
    { 176, -152, -952},
    { 160, -136, -968},
    { 176, -152, -944},
    { 176, -136, -944},
    { 168, -152, -936},
    { 168, -152, -928},
    { 168, -160, -928},
    { 184, -152, -928},
    { 184, -160, -928},
    { 192, -160, -944},
    // 68 seconds
    { 208, -192, -952},
    { 248, -200, -944},
    { 240, -184, -920},
    { 216, -120, -928},
    { 208, -168, -936},
    { 224, -152, -1016},
    { 232, -208, -1016},
    { 232, -144, -1032},
    { 240, -144, -928},
    { 288, -152, -840},
    { 280, -232, -760},
    { 120, -248, -760},
    { 152, -328, -920},
    { 144, -304, -936},
    { 128, -232, -952},
    { 72, -264, -984},
    { 8, -208, -1000},
    { 72, -248, -952},
    { 48, -288, -896},
    { 64, -368, -848},
    { 136, -312, -896},
    { 112, -288, -912},
    { 168, -328, -864},
    { 48, -192, -1008},
    { 32, -264, -968},
    // 69 seconds
    { 24, -296, -888},
    { -16, -344, -960},
    { 32, -392, -928},
    { 16, -360, -952},
    { 24, -336, -888},
    { -8, -448, -808},
    { -32, -312, -944},
    { 24, -272, -928},
    { 96, -368, -848},
    { 32, -352, -896},
    { -40, -424, -864},
    { -64, -336, -928},
    { -24, -400, -856},
    { 8, -344, -904},
    { -16, -568, -904},
    { 16, -400, -824},
    { -24, -408, -944},
    { 24, -416, -880},
    { -32, -400, -872},
    { -24, -384, -880},
    { 0, -248, -880},
    { 40, -360, -888},
    { -16, -424, -872},
    { 16, -384, -840},
    { -40, -368, -912},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:44:24 local
AccelRawData *activity_sample_walk_100_pbl_25655_3(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25655_3
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 88, -200, -936},
    { 112, -184, -968},
    { 144, -160, -936},
    { 112, -224, -936},
    { 40, -304, -960},
    { -56, -216, -904},
    { 72, -344, -880},
    { 64, -216, -960},
    { 16, -328, -864},
    { -56, -328, -888},
    { 40, -408, -840},
    { -8, -440, -896},
    { -40, -344, -888},
    { -48, -376, -880},
    { -32, -520, -888},
    { 32, -200, -984},
    { -48, -336, -928},
    { -32, -472, -872},
    { 112, -240, -896},
    { 8, -384, -896},
    { 32, -352, -888},
    { -8, -416, -904},
    { 40, -352, -896},
    { 8, -312, -896},
    { 16, -272, -888},
    // 1 seconds
    { 8, -328, -904},
    { 8, -216, -928},
    { 16, -368, -936},
    { -24, -288, -952},
    { -8, -88, -952},
    { 16, -216, -896},
    { 120, -112, -912},
    { 168, 168, -984},
    { 200, 72, -976},
    { 256, 88, -1000},
    { 240, 160, -944},
    { 288, 96, -888},
    { 256, 176, -928},
    { 256, 152, -896},
    { 216, 88, -888},
    { 192, 120, -904},
    { 208, 112, -912},
    { 200, 144, -920},
    { 200, 144, -904},
    { 208, 136, -960},
    { 216, 88, -952},
    { 232, 176, -936},
    { 248, 176, -920},
    { 240, 152, -920},
    { 232, 176, -936},
    // 2 seconds
    { 240, 128, -920},
    { 232, 128, -896},
    { 232, 160, -920},
    { 232, 152, -920},
    { 216, 176, -928},
    { 232, 120, -920},
    { 216, 152, -912},
    { 224, 120, -928},
    { 216, 120, -936},
    { 208, 112, -912},
    { 200, 168, -928},
    { 208, 56, -832},
    { 152, 144, -864},
    { 176, 128, -832},
    { 176, 200, -768},
    { 152, 344, -760},
    { 192, 656, -736},
    { 208, 672, -736},
    { 208, 816, -688},
    { 192, 944, -576},
    { 184, 840, -416},
    { 192, 856, -368},
    { 256, 808, -384},
    { 248, 752, -320},
    { 240, 936, -352},
    // 3 seconds
    { 160, 776, -384},
    { 168, 832, -312},
    { 72, 1032, -368},
    { 136, 1056, -376},
    { 168, 808, -392},
    { 160, 744, -400},
    { 144, 760, -392},
    { 104, 800, -464},
    { 56, 832, -528},
    { 72, 632, -504},
    { 32, 640, -544},
    { -8, 728, -632},
    { -80, 856, -656},
    { -48, 800, -624},
    { -32, 784, -648},
    { -8, 736, -616},
    { 0, 696, -616},
    { -24, 696, -600},
    { -32, 696, -592},
    { -48, 720, -616},
    { -56, 728, -624},
    { -80, 784, -664},
    { -48, 824, -632},
    { -64, 1040, -640},
    { 72, 1168, -568},
    // 4 seconds
    { 216, 960, -504},
    { 336, 672, -288},
    { 264, 640, -272},
    { 200, 512, -416},
    { 224, 232, -224},
    { 80, 840, -616},
    { 40, 776, -368},
    { 240, 1088, -672},
    { 176, 784, -416},
    { 208, 792, -488},
    { 232, 792, -456},
    { 192, 1016, -224},
    { 216, 888, -424},
    { 240, 888, -376},
    { 280, 808, -328},
    { 192, 864, -312},
    { 240, 800, -344},
    { 144, 1008, -456},
    { 208, 736, -304},
    { 184, 800, -360},
    { 160, 864, -368},
    { 192, 960, -408},
    { 192, 704, -248},
    { 208, 1024, -200},
    { 112, 1048, -328},
    // 5 seconds
    { 200, 944, -296},
    { 200, 856, -304},
    { 144, 960, -232},
    { 184, 976, -216},
    { 168, 840, -280},
    { 208, 952, -200},
    { 160, 800, -224},
    { 232, 1016, -56},
    { 176, 1056, -176},
    { 136, 960, -248},
    { 80, 800, -128},
    { 64, 1024, -120},
    { 112, 1088, -144},
    { 96, 864, -144},
    { 128, 872, -248},
    { 176, 832, -248},
    { 184, 984, -256},
    { 256, 928, -272},
    { 248, 976, -368},
    { 184, 840, -344},
    { 176, 840, -296},
    { 112, 848, -328},
    { 120, 952, -360},
    { 176, 776, -296},
    { 144, 928, -200},
    // 6 seconds
    { 176, 992, -176},
    { 136, 920, -200},
    { 136, 872, -144},
    { 184, 1024, -152},
    { 152, 952, -160},
    { 144, 912, -152},
    { 160, 968, -152},
    { 176, 920, -144},
    { 152, 912, -160},
    { 168, 1032, -248},
    { 192, 856, -304},
    { 160, 792, -376},
    { 176, 816, -408},
    { 176, 912, -424},
    { 176, 680, -480},
    { 152, 824, -488},
    { 152, 784, -536},
    { 192, 840, -504},
    { 184, 840, -464},
    { 240, 680, -432},
    { 216, 864, -168},
    { 112, 1152, 112},
    { 192, 1040, 64},
    { 48, 656, -32},
    { 72, 976, 136},
    // 7 seconds
    { 112, 1144, 144},
    { 104, 1064, 32},
    { 128, 840, -16},
    { 144, 712, -216},
    { 160, 1136, -200},
    { 232, 952, -360},
    { 280, 928, -280},
    { 288, 776, -272},
    { 120, 816, -408},
    { 88, 760, -432},
    { 152, 1016, -496},
    { 168, 808, -360},
    { 136, 840, -312},
    { 128, 928, -344},
    { 176, 832, -304},
    { 176, 912, -288},
    { 168, 920, -288},
    { 168, 928, -296},
    { 200, 928, -240},
    { 184, 888, -232},
    { 168, 944, -256},
    { 152, 800, -240},
    { 160, 1000, -288},
    { 176, 952, -288},
    { 168, 880, -240},
    // 8 seconds
    { 176, 920, -216},
    { 176, 872, -272},
    { 192, 912, -248},
    { 160, 912, -240},
    { 160, 928, -264},
    { 152, 928, -256},
    { 168, 912, -224},
    { 192, 888, -232},
    { 152, 944, -256},
    { 136, 912, -272},
    { 168, 912, -232},
    { 176, 976, -224},
    { 168, 864, -272},
    { 168, 896, -280},
    { 200, 1008, -216},
    { 168, 848, -296},
    { 128, 912, -224},
    { 168, 944, -200},
    { 168, 864, -264},
    { 168, 912, -200},
    { 192, 960, -200},
    { 176, 920, -264},
    { 184, 936, -176},
    { 184, 960, -200},
    { 168, 856, -160},
    // 9 seconds
    { 128, 896, -104},
    { 144, 1048, -72},
    { 160, 1008, -88},
    { 144, 920, -80},
    { 160, 1016, -72},
    { 160, 944, -136},
    { 176, 896, -112},
    { 144, 944, -144},
    { 160, 912, -144},
    { 120, 1016, -72},
    { 128, 976, -56},
    { 112, 1032, -120},
    { 144, 984, -144},
    { 152, 936, -160},
    { 120, 992, -160},
    { 88, 920, -304},
    { 64, 920, -352},
    { 24, 792, -640},
    { 64, 1088, -704},
    { 136, 368, -432},
    { 128, 96, -704},
    { 32, -64, -928},
    { -72, 520, -960},
    { -16, -40, -1096},
    { 24, -16, -944},
    // 10 seconds
    { -16, -80, -832},
    { -16, -80, -920},
    { 0, -88, -856},
    { -64, -24, -864},
    { -64, -88, -792},
    { -48, -40, -672},
    { -72, -56, -584},
    { -104, 56, -656},
    { -176, 48, -640},
    { -368, 240, -952},
    { -320, 160, -768},
    { -440, 216, -864},
    { -560, 384, -1072},
    { -680, 40, -1256},
    { -592, 232, -1200},
    { -416, 112, -856},
    { -432, 216, -664},
    { -472, 224, -768},
    { -432, 200, -752},
    { -472, 192, -760},
    { -480, 208, -752},
    { -424, 216, -752},
    { -408, 248, -736},
    { -376, 224, -720},
    { -408, 208, -752},
    // 11 seconds
    { -416, 176, -744},
    { -440, 168, -784},
    { -480, 208, -792},
    { -464, 184, -768},
    { -432, 152, -768},
    { -416, 152, -728},
    { -424, 144, -744},
    { -488, 176, -768},
    { -512, 208, -792},
    { -624, 200, -776},
    { -984, 224, -864},
    { -920, 296, -744},
    { -800, 216, -672},
    { -640, 128, -624},
    { -584, 40, -456},
    { -480, 128, -496},
    { -432, 128, -472},
    { -448, 72, -504},
    { -496, 80, -480},
    { -488, 40, -456},
    { -512, 24, -568},
    { -480, 96, -600},
    { -360, -208, -784},
    { -336, 80, -712},
    { -568, 64, -880},
    // 12 seconds
    { -592, 88, -1088},
    { -1656, 192, -1208},
    { -736, 656, -584},
    { -632, 192, -536},
    { -400, 352, -736},
    { -448, 256, -608},
    { -456, 240, -544},
    { -376, 224, -536},
    { -296, 144, -616},
    { -304, 184, -632},
    { -256, 128, -600},
    { -240, 144, -624},
    { -248, 72, -648},
    { -264, 64, -592},
    { -392, 112, -680},
    { -512, 128, -680},
    { -616, 104, -632},
    { -1080, 440, -1248},
    { -1272, 96, -1056},
    { -1120, 456, -992},
    { -664, 152, -880},
    { -472, 40, -632},
    { -304, 72, -488},
    { -160, 32, -456},
    { -136, -48, -432},
    // 13 seconds
    { -264, 72, -600},
    { -352, -32, -664},
    { -400, 120, -696},
    { -304, 32, -768},
    { -352, 80, -896},
    { -432, 152, -864},
    { -648, 312, -1248},
    { -864, 224, -920},
    { -488, 264, -680},
    { -464, 280, -808},
    { -400, 160, -616},
    { -384, 144, -512},
    { -352, 232, -528},
    { -336, 184, -624},
    { -416, 176, -600},
    { -424, 184, -584},
    { -344, 176, -624},
    { -344, 152, -592},
    { -488, 112, -584},
    { -744, 72, -520},
    { -960, 32, -568},
    { -1096, 176, -584},
    { -1600, 16, -696},
    { -1264, 112, -664},
    { -928, 16, -448},
    // 14 seconds
    { -680, 80, -256},
    { -280, -200, -16},
    { -208, 104, -264},
    { -336, 168, -160},
    { -528, 16, -64},
    { -848, 192, -128},
    { -912, 440, -168},
    { -760, 408, -248},
    { -800, 432, -504},
    { -936, 328, -592},
    { -1664, 488, -568},
    { -1600, 352, -408},
    { -824, 288, -352},
    { -1072, 544, -528},
    { -864, 648, -360},
    { -456, -8, 72},
    { -560, 464, -296},
    { -472, 216, -96},
    { -416, 224, -72},
    { -576, 288, -48},
    { -544, 480, 8},
    { -472, 400, 64},
    { -600, 440, -88},
    { -848, 560, -240},
    { -1032, 496, -240},
    // 15 seconds
    { -1144, 464, -144},
    { -1320, 488, -264},
    { -1216, 416, -664},
    { -1056, 304, -240},
    { -696, 16, -184},
    { -416, 120, -288},
    { -224, 272, -256},
    { -224, 288, -248},
    { -368, 312, -224},
    { -552, 424, -232},
    { -736, 456, -216},
    { -808, 424, -176},
    { -808, 496, -296},
    { -824, 520, -336},
    { -984, 488, -304},
    { -1152, 504, -320},
    { -1432, 624, -472},
    { -1224, 520, -224},
    { -1040, 472, -240},
    { -848, 392, -152},
    { -520, 304, -128},
    { -352, 344, -224},
    { -384, 272, -120},
    { -448, 208, -8},
    { -496, 240, -24},
    // 16 seconds
    { -560, 344, -56},
    { -696, 400, -80},
    { -920, 384, -48},
    { -1144, 384, 24},
    { -1000, 480, -136},
    { -1264, 464, -288},
    { -1480, 432, 56},
    { -832, 520, -520},
    { -512, 88, -208},
    { -616, -8, -272},
    { -496, 40, -272},
    { -400, 176, -192},
    { -512, 416, -336},
    { -680, 384, -200},
    { -832, 320, -208},
    { -816, 320, -272},
    { -640, 328, -232},
    { -816, 400, -368},
    { -1024, 456, -272},
    { -1288, 368, -216},
    { -1608, 512, -424},
    { -1112, 448, -184},
    { -1216, 552, -256},
    { -1016, 560, -160},
    { -776, 0, 232},
    // 17 seconds
    { -480, 256, 0},
    { -384, 312, -80},
    { -432, 192, 80},
    { -472, 136, 96},
    { -520, 224, 80},
    { -624, 280, 24},
    { -648, 272, 24},
    { -960, 384, -48},
    { -1000, 424, -32},
    { -1280, 488, -104},
    { -1456, 688, -352},
    { -1176, 712, -504},
    { -864, 472, -360},
    { -696, 224, -216},
    { -608, 120, -232},
    { -400, 216, -224},
    { -344, 440, -248},
    { -456, 360, -200},
    { -616, 408, -192},
    { -744, 368, -88},
    { -752, 440, -176},
    { -776, 552, -296},
    { -952, 624, -304},
    { -1144, 528, -224},
    { -1504, 664, -344},
    // 18 seconds
    { -1184, 616, -240},
    { -1000, 552, -128},
    { -832, 576, -288},
    { -744, 392, -32},
    { -560, 320, -16},
    { -536, 296, -16},
    { -480, 288, 16},
    { -456, 264, 24},
    { -456, 280, 56},
    { -408, 312, 24},
    { -520, 336, 0},
    { -840, 456, -88},
    { -880, 424, -16},
    { -1120, 488, -80},
    { -1360, 744, -448},
    { -1312, 672, -352},
    { -984, 608, -400},
    { -688, 488, -376},
    { -576, 440, -320},
    { -440, 280, -272},
    { -360, 376, -296},
    { -376, 312, -192},
    { -504, 392, -224},
    { -640, 408, -176},
    { -656, 392, -144},
    // 19 seconds
    { -792, 512, -272},
    { -1008, 584, -392},
    { -1192, 616, -296},
    { -1448, 608, -328},
    { -1040, 608, -296},
    { -1056, 592, -288},
    { -984, 528, -208},
    { -776, 376, -32},
    { -592, 336, -48},
    { -448, 336, -128},
    { -408, 320, -64},
    { -448, 240, 24},
    { -448, 288, -8},
    { -472, 304, 0},
    { -528, 376, -56},
    { -784, 480, -136},
    { -936, 448, -104},
    { -1048, 536, -160},
    { -1248, 592, -264},
    { -1280, 688, -456},
    { -1040, 592, -296},
    { -712, 464, -336},
    { -552, 392, -336},
    { -400, 224, -224},
    { -320, 320, -304},
    // 20 seconds
    { -400, 296, -192},
    { -512, 368, -160},
    { -664, 384, -152},
    { -696, 424, -160},
    { -792, 536, -256},
    { -1048, 552, -312},
    { -1120, 552, -272},
    { -1384, 664, -344},
    { -1112, 696, -312},
    { -984, 584, -192},
    { -904, 576, -232},
    { -840, 432, -48},
    { -616, 336, -8},
    { -504, 320, -48},
    { -448, 304, -40},
    { -432, 328, -16},
    { -480, 352, -32},
    { -416, 376, 0},
    { -464, 408, -64},
    { -680, 472, -136},
    { -888, 504, -96},
    { -1000, 496, -72},
    { -1176, 600, -256},
    { -1120, 592, -280},
    { -984, 576, -312},
    // 21 seconds
    { -832, 496, -320},
    { -592, 360, -288},
    { -440, 320, -384},
    { -336, 368, -280},
    { -440, 512, -296},
    { -512, 328, -280},
    { -592, 488, -288},
    { -640, 480, -240},
    { -848, 552, -256},
    { -1000, 552, -112},
    { -1160, 616, -256},
    { -1248, 712, -352},
    { -1096, 592, -232},
    { -1064, 568, -248},
    { -1032, 552, -200},
    { -872, 416, -32},
    { -568, 352, -88},
    { -440, 216, -120},
    { -384, 200, -24},
    { -400, 312, 8},
    { -480, 344, -8},
    { -512, 432, 0},
    { -568, 496, -72},
    { -832, 552, -72},
    { -840, 464, -72},
    // 22 seconds
    { -1120, 432, -72},
    { -1184, 424, -120},
    { -1160, 520, -232},
    { -1080, 464, -296},
    { -816, 272, -240},
    { -528, 272, -304},
    { -424, 304, -304},
    { -432, 376, -288},
    { -528, 368, -176},
    { -616, 424, -216},
    { -712, 464, -200},
    { -768, 456, -200},
    { -952, 504, -272},
    { -1032, 512, -192},
    { -1320, 576, -360},
    { -1240, 584, -408},
    { -1200, 504, -304},
    { -1088, 512, -304},
    { -1016, 488, -192},
    { -784, 368, -40},
    { -512, 304, -32},
    { -504, 296, -8},
    { -472, 304, 48},
    { -464, 240, 96},
    { -456, 312, 48},
    // 23 seconds
    { -504, 352, 24},
    { -616, 384, -24},
    { -840, 432, -32},
    { -808, 416, -80},
    { -1056, 504, -160},
    { -1080, 584, -304},
    { -1136, 560, -408},
    { -1136, 640, -392},
    { -752, 552, -544},
    { -432, 472, -496},
    { -376, 424, -360},
    { -368, 392, -312},
    { -400, 416, -288},
    { -496, 424, -232},
    { -552, 472, -232},
    { -672, 544, -312},
    { -944, 600, -328},
    { -904, 552, -216},
    { -1400, 656, -336},
    { -1232, 648, -296},
    { -1104, 608, -248},
    { -1208, 624, -280},
    { -1072, 360, 0},
    { -744, 232, 16},
    { -456, 312, -112},
    // 24 seconds
    { -328, 200, -96},
    { -416, 232, -32},
    { -440, 160, 56},
    { -520, 208, 24},
    { -544, 264, 24},
    { -664, 336, -8},
    { -976, 416, -48},
    { -1024, 480, -104},
    { -1264, 552, -136},
    { -1352, 728, -312},
    { -1160, 712, -504},
    { -1000, 536, -176},
    { -776, 480, -296},
    { -528, 432, -304},
    { -400, 408, -232},
    { -304, 344, -264},
    { -296, 320, -216},
    { -432, 408, -192},
    { -632, 584, -224},
    { -752, 640, -248},
    { -976, 408, -88},
    { -896, 848, -384},
    { -1200, 848, -328},
    { -1216, 776, -296},
    { -960, 584, -96},
    // 25 seconds
    { -976, 624, -184},
    { -912, 504, -32},
    { -720, 352, 56},
    { -528, 296, 16},
    { -344, 296, -24},
    { -296, 264, 16},
    { -352, 256, 80},
    { -472, 384, 24},
    { -600, 424, 16},
    { -952, 544, -88},
    { -1016, 536, -48},
    { -1184, 520, -80},
    { -1240, 592, -264},
    { -984, 568, -256},
    { -888, 544, -288},
    { -784, 424, -392},
    { -496, 280, -304},
    { -408, 264, -208},
    { -440, 248, -200},
    { -504, 296, -160},
    { -640, 384, -184},
    { -720, 376, -112},
    { -688, 400, -144},
    { -936, 504, -256},
    { -1032, 424, -88},
    // 26 seconds
    { -1552, 568, -240},
    { -1320, 520, -320},
    { -952, 360, -192},
    { -1040, 384, -360},
    { -960, 280, -48},
    { -696, 344, -40},
    { -480, 456, -168},
    { -488, 312, -48},
    { -472, 272, -16},
    { -544, 248, 32},
    { -584, 288, 8},
    { -600, 360, -16},
    { -768, 416, -32},
    { -976, 472, -48},
    { -848, 496, -168},
    { -1200, 512, -200},
    { -1024, 536, -232},
    { -872, 464, -256},
    { -920, 528, -232},
    { -760, 488, -248},
    { -592, 456, -248},
    { -432, 408, -200},
    { -400, 376, -184},
    { -416, 368, -176},
    { -504, 416, -184},
    // 27 seconds
    { -616, 464, -168},
    { -696, 504, -192},
    { -648, 520, -192},
    { -752, 568, -280},
    { -784, 528, -232},
    { -840, 496, -200},
    { -1208, 576, -288},
    { -1184, 568, -192},
    { -1296, 576, -176},
    { -1144, 616, -160},
    { -904, 480, -112},
    { -584, 376, -56},
    { -400, 352, -72},
    { -416, 336, -40},
    { -440, 360, 0},
    { -536, 400, 32},
    { -576, 440, 48},
    { -584, 456, 40},
    { -696, 496, -16},
    { -800, 528, -80},
    { -816, 496, -136},
    { -840, 496, -232},
    { -1040, 480, -256},
    { -1088, 480, -256},
    { -1008, 512, -424},
    // 28 seconds
    { -912, 552, -512},
    { -712, 352, -296},
    { -480, 312, -224},
    { -368, 336, -184},
    { -344, 344, -184},
    { -448, 376, -144},
    { -520, 352, -72},
    { -632, 424, -104},
    { -632, 432, -88},
    { -728, 480, -136},
    { -856, 544, -184},
    { -904, 480, -120},
    { -1272, 624, -304},
    { -1128, 608, -304},
    { -1288, 568, -272},
    { -1200, 592, -248},
    { -992, 480, -168},
    { -656, 368, -136},
    { -488, 392, -200},
    { -480, 368, -160},
    { -480, 312, -40},
    { -528, 336, 32},
    { -528, 352, 64},
    { -552, 408, 32},
    { -640, 464, 0},
    // 29 seconds
    { -832, 488, 0},
    { -872, 480, -40},
    { -936, 504, -144},
    { -1016, 496, -248},
    { -1128, 472, -112},
    { -968, 504, -344},
    { -784, 544, -512},
    { -648, 400, -296},
    { -496, 312, -224},
    { -392, 344, -216},
    { -400, 368, -216},
    { -456, 408, -168},
    { -544, 416, -144},
    { -616, 456, -160},
    { -648, 464, -144},
    { -872, 544, -224},
    { -952, 512, -160},
    { -976, 472, -128},
    { -1312, 672, -280},
    { -1360, 584, -224},
    { -1064, 488, -144},
    { -1040, 568, -288},
    { -824, 432, -120},
    { -560, 344, -48},
    { -448, 320, -80},
    // 30 seconds
    { -488, 328, -32},
    { -504, 320, 64},
    { -520, 392, 88},
    { -472, 440, 80},
    { -488, 472, 40},
    { -640, 536, 0},
    { -816, 584, -112},
    { -784, 504, -144},
    { -1056, 560, -224},
    { -1200, 520, -288},
    { -1064, 424, -272},
    { -880, 552, -368},
    { -760, 488, -368},
    { -592, 344, -240},
    { -440, 336, -152},
    { -376, 368, -152},
    { -392, 400, -176},
    { -560, 424, -136},
    { -664, 448, -96},
    { -656, 472, -120},
    { -656, 496, -160},
    { -832, 552, -240},
    { -928, 520, -160},
    { -1112, 496, -184},
    { -1280, 624, -264},
    // 31 seconds
    { -1392, 696, -280},
    { -1168, 480, -80},
    { -992, 480, -200},
    { -616, 408, -136},
    { -416, 360, -144},
    { -432, 328, -112},
    { -496, 288, 8},
    { -536, 320, 48},
    { -536, 368, 40},
    { -472, 400, 56},
    { -536, 464, 0},
    { -712, 496, -8},
    { -792, 472, -56},
    { -856, 528, -192},
    { -1096, 536, -184},
    { -1240, 536, -232},
    { -1080, 536, -288},
    { -848, 552, -448},
    { -704, 456, -472},
    { -536, 192, -248},
    { -448, 192, -192},
    { -440, 192, -192},
    { -528, 296, -200},
    { -608, 328, -160},
    { -696, 336, -152},
    // 32 seconds
    { -648, 352, -128},
    { -768, 408, -184},
    { -864, 440, -232},
    { -912, 432, -144},
    { -1432, 568, -296},
    { -1144, 544, -176},
    { -1200, 560, -152},
    { -1104, 552, -120},
    { -896, 392, -16},
    { -648, 304, -56},
    { -528, 304, -80},
    { -496, 280, -32},
    { -464, 248, 32},
    { -520, 304, 16},
    { -576, 376, -16},
    { -640, 392, 8},
    { -800, 464, -48},
    { -976, 528, -120},
    { -960, 496, -104},
    { -1176, 456, -64},
    { -1184, 424, -88},
    { -832, 480, -240},
    { -840, 536, -456},
    { -880, 280, -208},
    { -680, 40, -24},
    // 33 seconds
    { -488, 256, -120},
    { -440, 336, -200},
    { -520, 336, -104},
    { -600, 328, -32},
    { -688, 392, -168},
    { -640, 328, -24},
    { -704, 400, -128},
    { -848, 480, -248},
    { -992, 440, -104},
    { -1040, 464, -136},
    { -1176, 584, -264},
    { -1120, 624, -288},
    { -1024, 568, -248},
    { -992, 472, -160},
    { -856, 392, -136},
    { -656, 312, -96},
    { -520, 280, -48},
    { -504, 304, -48},
    { -512, 320, -16},
    { -560, 296, 48},
    { -656, 344, 32},
    { -688, 392, 8},
    { -832, 416, -8},
    { -1040, 440, -16},
    { -872, 416, -64},
    // 34 seconds
    { -1104, 448, -128},
    { -976, 416, -192},
    { -856, 376, -264},
    { -936, 496, -480},
    { -896, 280, -304},
    { -680, 128, -184},
    { -464, 200, -208},
    { -392, 264, -256},
    { -464, 304, -192},
    { -616, 312, -104},
    { -696, 368, -112},
    { -696, 384, -104},
    { -696, 400, -152},
    { -824, 456, -224},
    { -944, 400, -120},
    { -1064, 424, -136},
    { -1224, 560, -232},
    { -1240, 584, -216},
    { -1096, 544, -168},
    { -1072, 544, -224},
    { -880, 368, -64},
    { -616, 256, -64},
    { -472, 184, -104},
    { -416, 224, -64},
    { -480, 192, 0},
    // 35 seconds
    { -616, 264, 56},
    { -664, 376, 40},
    { -808, 448, -24},
    { -920, 464, 16},
    { -1040, 432, -8},
    { -1000, 392, -64},
    { -1120, 432, -160},
    { -1152, 368, -152},
    { -776, 424, -384},
    { -784, 376, -432},
    { -776, 200, -264},
    { -616, 40, -136},
    { -512, 216, -176},
    { -472, 296, -208},
    { -536, 320, -144},
    { -664, 360, -112},
    { -736, 368, -88},
    { -720, 376, -96},
    { -800, 424, -152},
    { -968, 424, -144},
    { -1032, 440, -120},
    { -1320, 504, -192},
    { -1256, 552, -200},
    { -928, 456, -144},
    { -936, 464, -248},
    // 36 seconds
    { -848, 368, -80},
    { -648, 256, -32},
    { -560, 336, -112},
    { -568, 320, -32},
    { -552, 272, 24},
    { -608, 312, 24},
    { -664, 336, 40},
    { -656, 360, 32},
    { -784, 352, 16},
    { -1072, 416, -32},
    { -1016, 376, 0},
    { -1160, 384, -40},
    { -1128, 464, -112},
    { -808, 544, -376},
    { -880, 448, -400},
    { -824, 160, -168},
    { -664, 64, -144},
    { -504, 184, -208},
    { -472, 280, -240},
    { -568, 280, -136},
    { -688, 344, -104},
    { -744, 384, -112},
    { -648, 360, -96},
    { -704, 408, -152},
    { -888, 456, -216},
    // 37 seconds
    { -960, 384, -88},
    { -1304, 488, -200},
    { -1280, 480, -168},
    { -880, 440, -136},
    { -944, 544, -280},
    { -1024, 472, -160},
    { -840, 256, 40},
    { -648, 320, -80},
    { -560, 352, -104},
    { -544, 304, -32},
    { -544, 280, 24},
    { -560, 320, 64},
    { -584, 392, 48},
    { -616, 448, 0},
    { -832, 488, -16},
    { -976, 488, -24},
    { -1040, 512, -88},
    { -1008, 504, -136},
    { -936, 520, -160},
    { -856, 584, -344},
    { -904, 568, -392},
    { -768, 384, -232},
    { -568, 312, -208},
    { -448, 312, -208},
    { -416, 288, -192},
    // 38 seconds
    { -512, 304, -152},
    { -664, 312, -128},
    { -712, 336, -104},
    { -656, 376, -120},
    { -688, 424, -216},
    { -984, 448, -232},
    { -1000, 384, -16},
    { -1288, 464, -144},
    { -1200, 560, -200},
    { -888, 536, -176},
    { -928, 624, -216},
    { -968, 536, -136},
    { -856, 424, -40},
    { -688, 448, -128},
    { -568, 392, -112},
    { -536, 336, -80},
    { -504, 296, -40},
    { -560, 272, 8},
    { -576, 320, 40},
    { -608, 344, 8},
    { -768, 400, 8},
    { -1000, 416, 40},
    { -920, 456, -56},
    { -1160, 496, -88},
    { -1272, 544, -96},
    // 39 seconds
    { -848, 448, -144},
    { -736, 656, -416},
    { -744, 544, -360},
    { -640, 288, -176},
    { -512, 264, -144},
    { -416, 328, -240},
    { -464, 360, -248},
    { -584, 320, -144},
    { -680, 352, -136},
    { -688, 400, -136},
    { -656, 416, -144},
    { -872, 480, -216},
    { -968, 416, -112},
    { -1272, 472, -104},
    { -1232, 544, -136},
    { -1072, 584, -160},
    { -1000, 608, -184},
    { -960, 520, -144},
    { -792, 408, -64},
    { -592, 376, -96},
    { -544, 344, -72},
    { -536, 304, 0},
    { -496, 328, 40},
    { -528, 368, 32},
    { -576, 392, 56},
    // 40 seconds
    { -640, 424, 40},
    { -832, 464, 0},
    { -976, 472, -32},
    { -1008, 528, -192},
    { -1064, 488, -216},
    { -1168, 488, -128},
    { -768, 480, -264},
    { -664, 576, -472},
    { -712, 480, -352},
    { -648, 280, -184},
    { -520, 328, -184},
    { -480, 360, -232},
    { -512, 376, -216},
    { -584, 360, -152},
    { -672, 392, -144},
    { -624, 416, -144},
    { -568, 424, -136},
    { -744, 488, -232},
    { -832, 448, -176},
    { -1136, 480, -160},
    { -1376, 576, -176},
    { -1144, 576, -88},
    { -992, 648, -216},
    { -1000, 656, -240},
    { -760, 440, -80},
    // 41 seconds
    { -576, 408, -136},
    { -520, 368, -88},
    { -536, 304, -16},
    { -504, 304, 16},
    { -528, 352, 32},
    { -592, 408, 0},
    { -664, 400, 56},
    { -792, 424, 24},
    { -912, 464, -16},
    { -928, 480, -96},
    { -1104, 528, -192},
    { -1224, 528, -232},
    { -1000, 344, -72},
    { -608, 536, -352},
    { -616, 544, -496},
    { -648, 272, -224},
    { -616, 160, -80},
    { -584, 248, -128},
    { -552, 336, -152},
    { -592, 368, -152},
    { -624, 376, -120},
    { -640, 384, -120},
    { -616, 400, -136},
    { -648, 432, -176},
    { -792, 480, -248},
    // 42 seconds
    { -912, 424, -120},
    { -1400, 528, -184},
    { -1544, 568, -152},
    { -840, 472, 16},
    { -888, 624, -296},
    { -984, 592, -144},
    { -824, 296, 72},
    { -608, 328, -40},
    { -544, 360, -72},
    { -496, 280, 32},
    { -496, 312, 48},
    { -568, 368, 56},
    { -592, 408, 56},
    { -624, 448, 16},
    { -736, 464, -16},
    { -928, 496, -56},
    { -824, 456, -48},
    { -1152, 544, -216},
    { -1304, 544, -184},
    { -976, 432, -216},
    { -816, 632, -496},
    { -760, 464, -328},
    { -616, 264, -144},
    { -488, 288, -128},
    { -424, 304, -136},
    // 43 seconds
    { -440, 328, -144},
    { -504, 360, -136},
    { -592, 376, -88},
    { -624, 448, -152},
    { -600, 448, -144},
    { -688, 512, -192},
    { -776, 520, -200},
    { -784, 488, -136},
    { -1248, 608, -216},
    { -1448, 680, -232},
    { -1072, 576, -80},
    { -1088, 640, -192},
    { -1000, 568, -136},
    { -880, 456, -80},
    { -664, 424, -128},
    { -584, 344, -64},
    { -512, 296, -40},
    { -504, 304, -8},
    { -512, 336, 24},
    { -528, 376, 16},
    { -536, 384, 32},
    { -640, 440, 24},
    { -736, 464, 24},
    { -800, 496, -32},
    { -848, 560, -192},
    // 44 seconds
    { -1008, 536, -144},
    { -1312, 568, -152},
    { -1048, 552, -296},
    { -712, 640, -480},
    { -656, 504, -392},
    { -568, 304, -232},
    { -424, 280, -160},
    { -384, 296, -192},
    { -432, 344, -184},
    { -608, 360, -104},
    { -672, 384, -112},
    { -640, 408, -96},
    { -712, 472, -184},
    { -912, 520, -232},
    { -1056, 472, -184},
    { -1248, 464, -176},
    { -1296, 600, -280},
    { -1040, 528, -160},
    { -984, 528, -192},
    { -1064, 552, -192},
    { -896, 344, 24},
    { -608, 360, -32},
    { -496, 360, -48},
    { -496, 360, -40},
    { -520, 296, 56},
    // 45 seconds
    { -520, 336, 64},
    { -552, 400, 40},
    { -544, 408, 32},
    { -744, 448, -8},
    { -928, 512, -56},
    { -912, 464, -80},
    { -1040, 504, -168},
    { -1000, 504, -224},
    { -1072, 496, -208},
    { -864, 528, -312},
    { -672, 576, -432},
    { -584, 384, -280},
    { -488, 280, -200},
    { -488, 296, -200},
    { -520, 328, -216},
    { -608, 320, -160},
    { -720, 376, -168},
    { -776, 392, -168},
    { -704, 368, -144},
    { -744, 424, -216},
    { -880, 424, -208},
    { -1008, 376, -48},
    { -1536, 528, -176},
    { -1304, 520, -112},
    { -736, 432, -72},
    // 46 seconds
    { -952, 512, -208},
    { -1024, 320, 56},
    { -816, 240, 120},
    { -616, 344, -16},
    { -568, 352, -16},
    { -520, 264, 40},
    { -528, 280, 24},
    { -568, 336, 0},
    { -592, 368, 0},
    { -680, 400, -24},
    { -816, 456, -72},
    { -1016, 480, -104},
    { -1000, 464, -72},
    { -1272, 488, -80},
    { -1152, 544, -144},
    { -752, 536, -216},
    { -752, 640, -368},
    { -728, 496, -264},
    { -624, 320, -96},
    { -512, 344, -136},
    { -464, 368, -160},
    { -472, 368, -152},
    { -560, 344, -112},
    { -656, 360, -120},
    { -688, 360, -88},
    // 47 seconds
    { -640, 376, -112},
    { -784, 408, -200},
    { -944, 408, -168},
    { -1096, 368, -112},
    { -1400, 472, -160},
    { -1056, 488, -96},
    { -888, 544, -232},
    { -1080, 688, -304},
    { -936, 336, 40},
    { -704, 336, 0},
    { -536, 400, -136},
    { -504, 384, -80},
    { -480, 272, 24},
    { -560, 320, 16},
    { -600, 336, 48},
    { -664, 368, 40},
    { -712, 432, -8},
    { -1000, 488, -64},
    { -1032, 472, -80},
    { -1296, 472, -88},
    { -1240, 480, -120},
    { -680, 480, -312},
    { -704, 584, -584},
    { -800, 240, -224},
    { -696, 56, -72},
    // 48 seconds
    { -560, 224, -136},
    { -520, 328, -232},
    { -560, 328, -184},
    { -632, 288, -72},
    { -672, 312, -88},
    { -656, 328, -72},
    { -560, 376, -104},
    { -592, 440, -176},
    { -736, 488, -256},
    { -880, 480, -192},
    { -960, 432, -64},
    { -1328, 640, -224},
    { -1216, 696, -232},
    { -760, 616, -232},
    { -1000, 760, -336},
    { -992, 488, -48},
    { -840, 384, -8},
    { -680, 432, -72},
    { -560, 384, -40},
    { -512, 320, 24},
    { -464, 312, 64},
    { -520, 360, 88},
    { -576, 384, 104},
    { -616, 408, 96},
    { -752, 496, 16},
    // 49 seconds
    { -952, 520, -72},
    { -1104, 528, -104},
    { -1136, 424, -128},
    { -1376, 464, -144},
    { -816, 376, -264},
    { -688, 440, -520},
    { -632, 256, -376},
    { -536, 128, -192},
    { -480, 304, -192},
    { -496, 368, -168},
    { -568, 432, -120},
    { -680, 440, -80},
    { -704, 432, -104},
    { -632, 368, -16},
    { -648, 440, -152},
    { -880, 504, -216},
    { -1016, 456, -96},
    { -1392, 480, -176},
    { -1344, 568, -232},
    { -872, 456, -160},
    { -912, 504, -232},
    { -872, 400, -80},
    { -704, 288, 48},
    { -584, 336, -88},
    { -568, 320, -16},
    // 50 seconds
    { -576, 296, 32},
    { -632, 320, 24},
    { -680, 352, -24},
    { -688, 352, -8},
    { -776, 360, -24},
    { -976, 440, -96},
    { -1032, 424, -88},
    { -1096, 432, -88},
    { -1136, 488, -176},
    { -920, 448, -136},
    { -688, 528, -368},
    { -664, 440, -328},
    { -624, 240, -152},
    { -480, 184, -104},
    { -448, 296, -144},
    { -520, 352, -160},
    { -632, 392, -136},
    { -704, 368, -88},
    { -640, 384, -136},
    { -648, 424, -176},
    { -912, 480, -256},
    { -976, 456, -208},
    { -1248, 488, -200},
    { -1144, 608, -280},
    { -1088, 608, -272},
    // 51 seconds
    { -1040, 576, -152},
    { -1000, 552, -144},
    { -744, 424, -48},
    { -520, 392, -40},
    { -480, 360, -48},
    { -464, 312, 16},
    { -480, 280, 56},
    { -520, 336, 48},
    { -528, 384, 24},
    { -616, 440, -32},
    { -832, 504, -88},
    { -984, 488, -120},
    { -1096, 496, -160},
    { -1160, 504, -168},
    { -1136, 520, -248},
    { -832, 552, -368},
    { -800, 528, -424},
    { -784, 360, -304},
    { -640, 256, -168},
    { -496, 280, -176},
    { -472, 312, -208},
    { -472, 320, -152},
    { -528, 352, -128},
    { -592, 400, -136},
    { -616, 424, -120},
    // 52 seconds
    { -608, 456, -144},
    { -720, 504, -192},
    { -848, 504, -184},
    { -840, 472, -144},
    { -888, 536, -192},
    { -1224, 592, -248},
    { -1112, 608, -184},
    { -1160, 656, -288},
    { -1040, 552, -152},
    { -832, 472, -144},
    { -712, 424, -160},
    { -568, 328, -56},
    { -480, 312, -40},
    { -536, 376, -64},
    { -560, 376, -8},
    { -584, 416, 24},
    { -576, 448, -8},
    { -608, 472, 0},
    { -704, 472, -24},
    { -832, 488, -40},
    { -784, 488, -104},
    { -1040, 536, -208},
    { -1024, 464, -88},
    { -936, 568, -400},
    { -912, 592, -544},
    // 53 seconds
    { -888, 344, -280},
    { -680, 200, -168},
    { -456, 280, -184},
    { -352, 320, -240},
    { -400, 344, -232},
    { -544, 336, -96},
    { -664, 400, -96},
    { -720, 440, -96},
    { -680, 456, -96},
    { -824, 520, -216},
    { -992, 512, -160},
    { -1168, 512, -144},
    { -1296, 608, -272},
    { -1160, 632, -232},
    { -928, 568, -200},
    { -1048, 576, -256},
    { -888, 408, -16},
    { -680, 392, -32},
    { -560, 392, -128},
    { -536, 296, 8},
    { -504, 256, 48},
    { -488, 280, 64},
    { -536, 312, 64},
    { -520, 336, 48},
    { -656, 368, 24},
    // 54 seconds
    { -904, 408, -8},
    { -984, 424, 24},
    { -1152, 536, -136},
    { -1232, 632, -240},
    { -1016, 520, -144},
    { -744, 560, -456},
    { -720, 512, -456},
    { -600, 208, -184},
    { -488, 216, -192},
    { -472, 344, -224},
    { -552, 328, -152},
    { -712, 352, -104},
    { -760, 400, -104},
    { -696, 392, -120},
    { -664, 376, -120},
    { -808, 416, -216},
    { -984, 384, -176},
    { -1128, 384, -72},
    { -1384, 536, -224},
    { -1104, 552, -120},
    { -984, 528, -152},
    { -1040, 608, -240},
    { -840, 336, 56},
    { -592, 368, -32},
    { -456, 376, -112},
    // 55 seconds
    { -440, 312, -8},
    { -488, 296, 24},
    { -568, 336, 32},
    { -624, 384, 32},
    { -672, 432, -8},
    { -864, 488, -32},
    { -1080, 488, -32},
    { -1040, 488, -88},
    { -1096, 512, -248},
    { -1104, 480, -120},
    { -768, 456, -288},
    { -760, 472, -416},
    { -704, 288, -208},
    { -544, 200, -152},
    { -448, 272, -176},
    { -448, 312, -160},
    { -528, 344, -144},
    { -640, 368, -112},
    { -672, 408, -120},
    { -608, 424, -128},
    { -664, 472, -192},
    { -864, 496, -208},
    { -976, 464, -144},
    { -1224, 496, -136},
    { -1248, 592, -208},
    // 56 seconds
    { -1056, 592, -168},
    { -992, 584, -152},
    { -1016, 552, -168},
    { -808, 424, -32},
    { -608, 392, -48},
    { -488, 368, -72},
    { -488, 328, 0},
    { -488, 272, 72},
    { -552, 320, 72},
    { -592, 352, 48},
    { -576, 360, 56},
    { -776, 424, 8},
    { -1040, 448, 16},
    { -1016, 448, -32},
    { -1168, 520, -120},
    { -1136, 568, -160},
    { -864, 536, -256},
    { -784, 616, -440},
    { -760, 456, -256},
    { -568, 232, -136},
    { -448, 240, -200},
    { -376, 272, -216},
    { -512, 336, -208},
    { -616, 344, -112},
    { -712, 392, -112},
    // 57 seconds
    { -664, 400, -88},
    { -696, 440, -144},
    { -888, 496, -208},
    { -968, 440, -32},
    { -1304, 536, -96},
    { -1224, 624, -152},
    { -1016, 560, -72},
    { -1016, 560, -152},
    { -936, 424, -32},
    { -752, 304, 24},
    { -560, 336, -64},
    { -504, 232, -16},
    { -480, 288, -8},
    { -544, 280, 8},
    { -616, 320, 16},
    { -664, 344, 8},
    { -712, 392, -32},
    { -1056, 472, -56},
    { -1112, 456, 40},
    { -1168, 512, -56},
    { -1240, 600, -48},
    { -760, 512, -168},
    { -784, 592, -456},
    { -840, 240, -144},
    { -632, 24, -40},
    // 58 seconds
    { -488, 208, -120},
    { -480, 248, -144},
    { -544, 280, -136},
    { -632, 328, -88},
    { -696, 352, -64},
    { -600, 360, -80},
    { -680, 440, -176},
    { -952, 472, -192},
    { -1000, 392, -32},
    { -1376, 480, -112},
    { -1344, 520, -176},
    { -848, 424, -112},
    { -992, 448, -216},
    { -1168, 312, -24},
    { -840, 184, 72},
    { -576, 320, -136},
    { -536, 352, -88},
    { -528, 280, 32},
    { -504, 312, 48},
    { -576, 416, 16},
    { -632, 392, 48},
    { -744, 408, 48},
    { -960, 464, 24},
    { -1000, 448, 40},
    { -936, 488, -128},
    // 59 seconds
    { -1120, 448, -128},
    { -1064, 424, -112},
    { -856, 552, -440},
    { -984, 368, -344},
    { -888, 24, -64},
    { -568, 32, -112},
    { -424, 216, -224},
    { -440, 280, -208},
    { -552, 304, -96},
    { -656, 336, -88},
    { -704, 360, -64},
    { -672, 384, -80},
    { -688, 448, -136},
    { -872, 496, -152},
    { -920, 472, -64},
    { -1176, 576, -240},
    { -1160, 624, -208},
    { -1176, 672, -200},
    { -1088, 600, -120},
    { -848, 480, -88},
    { -728, 464, -128},
    { -568, 384, -96},
    { -504, 336, 24},
    { -448, 296, 72},
    { -560, 296, 88},
    // 60 seconds
    // elapsed: 1 minutes
    { -592, 296, 128},
    { -584, 352, 48},
    { -648, 424, -24},
    { -792, 456, -64},
    { -928, 488, -136},
    { -1096, 512, -168},
    { -1256, 560, -184},
    { -1136, 584, -288},
    { -888, 632, -456},
    { -856, 448, -392},
    { -688, 248, -208},
    { -504, 216, -152},
    { -400, 208, -168},
    { -384, 248, -152},
    { -504, 312, -112},
    { -624, 336, -48},
    { -728, 376, -32},
    { -640, 448, -120},
    { -712, 496, -192},
    { -808, 512, -200},
    { -1064, 544, -264},
    { -1360, 648, -296},
    { -1112, 512, -136},
    { -848, 568, -280},
    { -1024, 648, -480},
    // 61 seconds
    { -920, 368, -88},
    { -688, 328, 8},
    { -512, 328, -104},
    { -464, 336, -48},
    { -512, 320, 24},
    { -576, 352, 56},
    { -640, 368, 48},
    { -664, 384, 64},
    { -728, 440, 8},
    { -952, 520, -104},
    { -944, 464, 0},
    { -1176, 536, -144},
    { -1104, 504, -136},
    { -920, 496, -280},
    { -784, 472, -344},
    { -784, 352, -312},
    { -704, 240, -232},
    { -568, 200, -200},
    { -480, 216, -168},
    { -536, 280, -168},
    { -640, 344, -152},
    { -728, 344, -96},
    { -728, 384, -128},
    { -624, 392, -160},
    { -584, 408, -184},
    // 62 seconds
    { -720, 432, -240},
    { -864, 456, -224},
    { -1136, 520, -200},
    { -1400, 664, -296},
    { -1000, 592, -104},
    { -696, 616, -272},
    { -960, 688, -352},
    { -888, 400, 0},
    { -704, 360, 8},
    { -552, 392, -64},
    { -496, 352, -24},
    { -488, 320, 8},
    { -600, 328, 56},
    { -656, 344, 80},
    { -664, 392, 48},
    { -720, 424, 8},
    { -920, 456, 0},
    { -896, 480, -88},
    { -1064, 552, -208},
    { -1032, 520, -160},
    { -1088, 456, -128},
    { -768, 544, -296},
    { -728, 448, -392},
    { -728, 304, -272},
    { -568, 168, -128},
    // 63 seconds
    { -456, 264, -168},
    { -480, 328, -200},
    { -568, 384, -152},
    { -688, 384, -80},
    { -656, 416, -112},
    { -640, 424, -104},
    { -816, 488, -192},
    { -1008, 464, -144},
    { -1032, 448, -56},
    { -1264, 576, -224},
    { -1144, 560, -240},
    { -912, 536, -256},
    { -1040, 480, -216},
    { -928, 296, -8},
    { -696, 328, -72},
    { -560, 344, -120},
    { -576, 336, -24},
    { -528, 288, 40},
    { -632, 320, 56},
    { -624, 344, 80},
    { -616, 376, 48},
    { -688, 432, 8},
    { -776, 456, -8},
    { -848, 496, -64},
    { -832, 504, -136},
    // 64 seconds
    { -960, 560, -264},
    { -1040, 488, -184},
    { -1240, 464, -232},
    { -824, 432, -256},
    { -832, 480, -488},
    { -776, 288, -272},
    { -584, 144, -120},
    { -496, 216, -152},
    { -472, 264, -176},
    { -544, 304, -112},
    { -624, 352, -72},
    { -672, 416, -104},
    { -648, 408, -80},
    { -592, 440, -128},
    { -688, 488, -200},
    { -832, 512, -208},
    { -880, 448, -96},
    { -1120, 600, -296},
    { -1176, 624, -256},
    { -1048, 640, -248},
    { -952, 616, -296},
    { -1064, 592, -216},
    { -976, 408, 16},
    { -776, 392, 0},
    { -592, 400, -64},
    // 65 seconds
    { -552, 352, 8},
    { -536, 296, 72},
    { -592, 312, 80},
    { -608, 344, 80},
    { -584, 344, 80},
    { -592, 392, 24},
    { -720, 456, -72},
    { -864, 440, -80},
    { -944, 456, -120},
    { -1096, 496, -192},
    { -1176, 496, -248},
    { -1128, 520, -280},
    { -840, 656, -568},
    { -720, 560, -560},
    { -696, 320, -288},
    { -552, 264, -168},
    { -440, 312, -144},
    { -392, 376, -192},
    { -464, 328, -128},
    { -552, 328, -56},
    { -632, 400, -104},
    { -680, 408, -104},
    { -648, 424, -128},
    { -696, 456, -176},
    { -784, 464, -208},
    // 66 seconds
    { -800, 464, -208},
    { -920, 496, -192},
    { -1240, 552, -248},
    { -1376, 624, -248},
    { -1208, 632, -240},
    { -1064, 480, -80},
    { -848, 464, -144},
    { -616, 432, -168},
    { -552, 368, -80},
    { -536, 280, 8},
    { -528, 280, 48},
    { -544, 336, 48},
    { -520, 408, 40},
    { -544, 432, 16},
    { -640, 504, -8},
    { -688, 496, -24},
    { -800, 496, -48},
    { -872, 496, -128},
    { -992, 496, -192},
    { -1136, 488, -88},
    { -1144, 472, -248},
    { -1080, 568, -432},
    { -928, 496, -408},
    { -728, 216, -160},
    { -432, 248, -136},
    // 67 seconds
    { -328, 328, -200},
    { -352, 336, -184},
    { -464, 320, -32},
    { -632, 384, -56},
    { -680, 432, -24},
    { -632, 448, -24},
    { -760, 528, -168},
    { -952, 560, -192},
    { -1056, 544, -168},
    { -1184, 544, -240},
    { -1128, 608, -360},
    { -960, 520, -280},
    { -944, 544, -232},
    { -920, 496, -112},
    { -720, 400, 16},
    { -544, 376, 16},
    { -496, 392, 0},
    { -552, 352, 72},
    { -624, 344, 104},
    { -648, 368, 64},
    { -632, 392, 32},
    { -640, 376, 8},
    { -792, 440, -72},
    { -904, 416, -104},
    { -880, 408, -112},
    // 68 seconds
    { -1320, 472, -144},
    { -1408, 496, -104},
    { -816, 488, -280},
    { -736, 568, -488},
    { -704, 336, -328},
    { -528, 144, -80},
    { -440, 248, -128},
    { -408, 352, -184},
    { -480, 376, -152},
    { -592, 408, -120},
    { -680, 424, -104},
    { -648, 440, -96},
    { -648, 480, -152},
    { -792, 552, -240},
    { -928, 472, -160},
    { -1224, 544, -200},
    { -1360, 536, -184},
    { -1088, 496, -128},
    { -1160, 576, -248},
    { -1032, 392, 0},
    { -760, 296, 24},
    { -496, 432, -152},
    { -528, 320, 0},
    { -504, 296, 16},
    { -528, 320, -40},
    // 69 seconds
    { -576, 344, -40},
    { -648, 360, -40},
    { -720, 376, -24},
    { -840, 408, -64},
    { -944, 424, -64},
    { -912, 400, -136},
    { -1144, 424, -184},
    { -1232, 448, -184},
    { -992, 368, -144},
    { -824, 480, -360},
    { -752, 432, -384},
    { -640, 192, -184},
    { -472, 208, -160},
    { -440, 264, -200},
    { -504, 296, -184},
    { -608, 336, -120},
    { -712, 376, -120},
    { -712, 392, -136},
    { -624, 392, -144},
    { -648, 424, -200},
    { -776, 432, -248},
    { -856, 400, -192},
    { -1032, 432, -208},
    { -1248, 536, -224},
    { -1320, 560, -224},
    // 70 seconds
    { -784, 464, -120},
    { -952, 616, -424},
    { -992, 496, -120},
    { -792, 272, 96},
    { -600, 448, -96},
    { -560, 432, -80},
    { -496, 328, 24},
    { -544, 328, 16},
    { -608, 384, -64},
    { -592, 344, 0},
    { -600, 360, -24},
    { -776, 416, -112},
    { -896, 440, -128},
    { -872, 400, -120},
    { -1104, 464, -240},
    { -1176, 488, -216},
    { -1184, 448, -192},
    { -840, 552, -280},
    { -720, 504, -352},
    { -656, 376, -312},
    { -528, 232, -160},
    { -440, 272, -160},
    { -480, 312, -184},
    { -568, 368, -152},
    { -648, 376, -104},
    // 71 seconds
    { -680, 408, -120},
    { -584, 408, -136},
    { -616, 456, -232},
    { -784, 480, -256},
    { -912, 440, -176},
    { -968, 440, -128},
    { -1224, 592, -256},
    { -1392, 640, -240},
    { -904, 528, -112},
    { -880, 560, -248},
    { -704, 496, -144},
    { -648, 360, -24},
    { -560, 368, -40},
    { -576, 360, -40},
    { -600, 312, 24},
    { -608, 320, 32},
    { -656, 384, -24},
    { -624, 384, -16},
    { -656, 416, -48},
    { -888, 480, -128},
    { -968, 456, -112},
    { -888, 432, -152},
    { -1112, 472, -208},
    { -1280, 560, -256},
    { -848, 416, -168},
    // 72 seconds
    { -680, 520, -328},
    { -640, 544, -432},
    { -600, 264, -216},
    { -528, 216, -96},
    { -488, 280, -184},
    { -552, 336, -176},
    { -584, 360, -160},
    { -664, 384, -136},
    { -680, 408, -176},
    { -632, 376, -128},
    { -664, 408, -200},
    { -688, 392, -208},
    { -760, 400, -144},
    { -1520, 608, -312},
    { -1904, 600, -272},
    { -648, 368, 96},
    { -1032, 680, -408},
    { -912, 608, -192},
    { -704, 296, 200},
    { -640, 536, -112},
    { -784, 904, -112},
    { -784, 816, 80},
    { -824, 1120, -192},
    { -920, 952, -352},
    { -960, 1024, -360},
    // 73 seconds
    { -920, 568, -432},
    { -680, 208, -232},
    { -480, 56, -368},
    { -296, -56, -376},
    { -328, -64, -600},
    { -256, -104, -584},
    { -200, -88, -672},
    { -104, -136, -784},
    { -56, -240, -760},
    { -96, -296, -816},
    { -208, -248, -896},
    { -120, -264, -816},
    { -96, -208, -920},
    { -48, -256, -872},
    { -88, -240, -928},
    { -72, -256, -928},
    { -64, -288, -904},
    { -72, -280, -888},
    { -56, -280, -888},
    { -56, -280, -896},
    { -40, -288, -888},
    { -16, -296, -896},
    { -24, -288, -904},
    { -24, -304, -888},
    { -24, -288, -912},
    // 74 seconds
    { -8, -296, -920},
    { 0, -304, -920},
    { -8, -304, -912},
    { -16, -296, -920},
    { -16, -312, -904},
    { 0, -320, -904},
    { -8, -312, -904},
    { -8, -320, -888},
    { -8, -336, -880},
    { 0, -312, -912},
    { -8, -336, -896},
    { -8, -320, -904},
    { 0, -328, -888},
    { -16, -336, -888},
    { -24, -328, -904},
    { -24, -336, -904},
    { -16, -344, -904},
    { 0, -336, -896},
    { 0, -344, -896},
    { -8, -352, -880},
    { 8, -352, -864},
    { 32, -368, -848},
    { 72, -320, -912},
    { 16, -368, -880},
    { -16, -352, -896},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:47:21 local
AccelRawData *activity_sample_walk_100_pbl_25655_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25655_4
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -136, -472, -824},
    { -32, -504, -848},
    { -144, -552, -784},
    { 0, -432, -816},
    { -96, -568, -784},
    { -128, -384, -784},
    { -32, -480, -824},
    { -32, -528, -840},
    { 8, -464, -816},
    { -160, -512, -760},
    { -88, -544, -832},
    { -56, -544, -832},
    { -152, -504, -800},
    { -80, -496, -824},
    { -104, -528, -816},
    { 88, -392, -800},
    { -120, -624, -896},
    { -104, -544, -696},
    { -120, -488, -880},
    { -72, -648, -808},
    { -88, -432, -880},
    { -32, -480, -808},
    { 0, -456, -784},
    { -16, -440, -824},
    { -8, -424, -832},
    // 1 seconds
    { -40, -456, -832},
    { -48, -456, -832},
    { -40, -448, -816},
    { -40, -480, -784},
    { -8, -432, -840},
    { -24, -440, -840},
    { -32, -416, -840},
    { 16, -376, -888},
    { -16, -384, -872},
    { -16, -344, -872},
    { 16, -328, -912},
    { -8, -336, -928},
    { 8, -320, -904},
    { 48, -304, -936},
    { 56, -256, -944},
    { 16, -296, -928},
    { 16, -208, -936},
    { 32, -192, -952},
    { 24, -256, -920},
    { 64, -176, -968},
    { 48, -232, -960},
    { 24, -176, -968},
    { 32, -192, -952},
    { 16, -160, -952},
    { 0, -184, -928},
    // 2 seconds
    { -16, -152, -952},
    { -48, -184, -992},
    { -224, -248, -1024},
    { -168, -96, -1080},
    { -8, 280, -1096},
    { 336, 336, -1016},
    { 312, 400, -848},
    { 440, 456, -632},
    { 400, 528, -712},
    { 440, 432, -616},
    { 392, 280, -696},
    { 352, 408, -760},
    { 360, 176, -720},
    { 288, 288, -848},
    { 192, 240, -968},
    { 264, 240, -824},
    { 320, 256, -832},
    { 312, 408, -936},
    { 392, 48, -728},
    { 344, 312, -824},
    { 296, 112, -816},
    { 320, 496, -792},
    { 328, 592, -840},
    { 336, 216, -696},
    { 336, 880, -600},
    // 3 seconds
    { 304, 536, -616},
    { 328, 784, -440},
    { 264, 1024, -368},
    { 344, 984, -272},
    { 328, 920, -104},
    { 352, 872, 0},
    { 304, 1024, -32},
    { 320, 776, 176},
    { 360, 976, 344},
    { 264, 800, 376},
    { 288, 760, 592},
    { 240, 728, 704},
    { 240, 880, 808},
    { 248, 888, 736},
    { 232, 1016, 648},
    { 200, 744, 456},
    { 200, 896, 256},
    { 264, 1320, 384},
    { 352, 600, -8},
    { 288, 768, -152},
    { 248, 1016, -224},
    { 256, 904, -176},
    { 272, 792, -104},
    { 232, 992, -128},
    { 280, 856, -32},
    // 4 seconds
    { 264, 1088, 16},
    { 288, 1072, 168},
    { 264, 912, 144},
    { 296, 832, 224},
    { 216, 984, 176},
    { 288, 952, 248},
    { 272, 896, 296},
    { 256, 952, 344},
    { 264, 864, 384},
    { 272, 880, 408},
    { 280, 968, 400},
    { 280, 952, 448},
    { 240, 856, 400},
    { 264, 872, 400},
    { 288, 928, 440},
    { 264, 880, 440},
    { 248, 984, 264},
    { 264, 1136, 304},
    { 232, 752, 120},
    { 216, 816, 40},
    { 304, 1168, 72},
    { 312, 944, -56},
    { 328, 848, -112},
    { 240, 1048, -88},
    { 280, 872, -120},
    // 5 seconds
    { 248, 912, -136},
    { 248, 960, -112},
    { 280, 928, -64},
    { 280, 920, -112},
    { 280, 880, -72},
    { 304, 984, -120},
    { 256, 944, -104},
    { 280, 952, -80},
    { 288, 920, -48},
    { 264, 920, -80},
    { 312, 776, 120},
    { 272, 1184, 32},
    { 312, 928, 216},
    { 296, 1000, 144},
    { 248, 928, 224},
    { 240, 1008, 176},
    { 232, 1064, 168},
    { 240, 920, 112},
    { 280, 792, -48},
    { 280, 952, -64},
    { 336, 1048, -72},
    { 328, 872, -216},
    { 352, 936, -208},
    { 288, 864, -216},
    { 272, 808, -200},
    // 6 seconds
    { 272, 952, -256},
    { 248, 784, -248},
    { 304, 1040, -208},
    { 272, 920, -176},
    { 288, 888, -152},
    { 304, 936, -120},
    { 312, 864, -8},
    { 288, 1048, -104},
    { 304, 968, -48},
    { 288, 904, -24},
    { 280, 888, 24},
    { 312, 1000, 32},
    { 280, 944, 8},
    { 264, 912, -8},
    { 272, 936, 8},
    { 312, 928, 16},
    { 304, 912, 0},
    { 264, 1048, -72},
    { 280, 944, 8},
    { 288, 936, 0},
    { 288, 944, 8},
    { 296, 968, -32},
    { 280, 960, -16},
    { 288, 960, -24},
    { 312, 816, 64},
    // 7 seconds
    { 296, 1016, -32},
    { 272, 944, 80},
    { 232, 968, 96},
    { 248, 1008, 48},
    { 256, 1024, 16},
    { 208, 864, -88},
    { 256, 904, -96},
    { 336, 904, -72},
    { 360, 1000, -200},
    { 296, 920, -200},
    { 368, 832, -168},
    { 256, 904, -200},
    { 288, 928, -208},
    { 272, 896, -216},
    { 280, 904, -232},
    { 280, 904, -256},
    { 256, 904, -280},
    { 256, 840, -240},
    { 280, 888, -232},
    { 336, 920, -200},
    { 288, 928, -216},
    { 288, 920, -224},
    { 248, 920, -216},
    { 288, 912, -248},
    { 280, 928, -256},
    // 8 seconds
    { 264, 864, -264},
    { 240, 880, -272},
    { 176, 776, -336},
    { 176, 768, -416},
    { 264, 680, -424},
    { 288, 592, -272},
    { 400, 176, -416},
    { 488, 472, -624},
    { 232, 424, -1208},
    { -72, 104, -1040},
    { -448, -24, -1048},
    { -528, -152, -1264},
    { -368, -128, -1152},
    { -208, -384, -904},
    { -200, -120, -792},
    { -224, -224, -816},
    { -152, -200, -864},
    { -192, -192, -872},
    { -160, -112, -920},
    { -136, -120, -936},
    { -128, -112, -904},
    { -112, -104, -920},
    { -112, -104, -912},
    { -80, -96, -920},
    { -96, -72, -912},
    // 9 seconds
    { -88, -24, -904},
    { -88, -80, -904},
    { -96, -48, -848},
    { -96, -24, -832},
    { -80, 56, -864},
    { -32, 32, -992},
    { -144, 32, -1056},
    { -88, 56, -1024},
    { -104, 32, -1048},
    { -64, -16, -936},
    { -48, -8, -896},
    { -80, 32, -896},
    { -128, 8, -864},
    { -120, 8, -824},
    { -120, 56, -872},
    { -104, 24, -872},
    { -64, 16, -888},
    { -40, -8, -904},
    { -32, 0, -912},
    { -64, 24, -984},
    { -24, 56, -992},
    { -112, 280, -1392},
    { -272, 112, -1160},
    { -88, 240, -896},
    { 40, 272, -992},
    // 10 seconds
    { -80, 216, -968},
    { -120, 256, -792},
    { -136, 272, -848},
    { -32, 136, -688},
    { 40, 0, -568},
    { 64, -48, -496},
    { 16, -48, -568},
    { -176, 88, -704},
    { -288, 96, -696},
    { -424, 96, -984},
    { -504, 128, -992},
    { -656, 224, -1048},
    { -552, 320, -1096},
    { -480, 264, -968},
    { -704, 352, -1192},
    { -848, 280, -1024},
    { -616, 216, -784},
    { -408, 248, -696},
    { -328, 200, -592},
    { -392, 136, -480},
    { -344, 112, -472},
    { -336, 176, -472},
    { -392, 184, -568},
    { -432, 176, -560},
    { -448, 224, -704},
    // 11 seconds
    { -400, 152, -672},
    { -256, 200, -728},
    { -336, 288, -896},
    { -488, 288, -888},
    { -488, 352, -1032},
    { -1160, 200, -1808},
    { -408, 768, -832},
    { -808, 312, -648},
    { -320, 432, -704},
    { -432, 336, -528},
    { -320, 216, -488},
    { -256, 160, -464},
    { -264, 144, -464},
    { -320, 144, -472},
    { -328, 88, -472},
    { -288, -88, -288},
    { -352, -144, -296},
    { -600, 32, -200},
    { -1008, 216, -304},
    { -1440, 408, -24},
    { -1456, 568, 96},
    { -1392, 1088, -728},
    { -1552, 736, -88},
    { -456, 664, -272},
    { -704, 432, -72},
    // 12 seconds
    { -408, 360, -40},
    { -336, 336, -32},
    { -328, 296, 56},
    { -504, 320, -16},
    { -616, 464, -88},
    { -728, 472, -16},
    { -720, 432, -48},
    { -848, 512, -40},
    { -968, 672, -200},
    { -1104, 640, -240},
    { -1528, 752, -296},
    { -1104, 680, -80},
    { -1008, 696, -128},
    { -1000, 640, 16},
    { -680, 456, 112},
    { -464, 344, 40},
    { -416, 336, 24},
    { -432, 312, 80},
    { -448, 296, 40},
    { -560, 312, 32},
    { -632, 336, 48},
    { -696, 344, 16},
    { -936, 424, -8},
    { -920, 424, -64},
    { -1096, 448, -152},
    // 13 seconds
    { -1512, 504, -56},
    { -1208, 496, -88},
    { -632, 560, -408},
    { -544, 656, -344},
    { -432, 392, -296},
    { -424, 296, -96},
    { -456, 376, -136},
    { -480, 408, -208},
    { -592, 424, -208},
    { -672, 384, -104},
    { -656, 400, -104},
    { -704, 408, -104},
    { -768, 464, -184},
    { -824, 440, -96},
    { -1328, 544, -152},
    { -1632, 552, -104},
    { -1096, 400, 104},
    { -1120, 512, -152},
    { -896, 440, 8},
    { -536, 296, 24},
    { -432, 320, -96},
    { -456, 336, -56},
    { -448, 312, 40},
    { -560, 344, 88},
    { -672, 424, 96},
    // 14 seconds
    { -776, 512, 56},
    { -840, 552, 0},
    { -888, 592, -136},
    { -776, 488, -96},
    { -960, 448, -96},
    { -1136, 464, -200},
    { -984, 432, -136},
    { -840, 464, -272},
    { -792, 408, -216},
    { -544, 168, -168},
    { -376, 192, -128},
    { -392, 328, -176},
    { -496, 424, -192},
    { -648, 360, -120},
    { -760, 312, -56},
    { -632, 432, -96},
    { -688, 512, -192},
    { -880, 528, -232},
    { -1024, 440, -48},
    { -1320, 504, -64},
    { -1544, 664, -160},
    { -960, 520, -8},
    { -928, 552, -192},
    { -808, 408, -32},
    { -536, 208, 32},
    // 15 seconds
    { -488, 272, -32},
    { -512, 264, 32},
    { -568, 280, 48},
    { -680, 272, 56},
    { -736, 336, 48},
    { -744, 336, 48},
    { -928, 408, -24},
    { -992, 432, -32},
    { -1104, 432, -80},
    { -1192, 432, -120},
    { -1136, 496, -112},
    { -744, 568, -384},
    { -808, 536, -416},
    { -712, 200, -168},
    { -528, 32, -32},
    { -408, 192, -96},
    { -456, 376, -152},
    { -512, 360, -104},
    { -568, 320, -24},
    { -640, 376, -48},
    { -648, 376, -48},
    { -784, 408, -120},
    { -984, 448, -128},
    { -1264, 448, -128},
    { -1616, 544, -208},
    // 16 seconds
    { -1080, 496, -40},
    { -1016, 536, -168},
    { -1040, 632, -296},
    { -760, 336, 24},
    { -464, 272, -24},
    { -416, 368, -64},
    { -424, 344, -16},
    { -448, 296, 40},
    { -600, 328, 16},
    { -640, 352, 32},
    { -752, 312, 80},
    { -1040, 392, 56},
    { -1120, 448, 24},
    { -1248, 512, -24},
    { -1248, 616, -80},
    { -792, 624, -328},
    { -848, 456, -344},
    { -768, 200, -112},
    { -560, 48, -72},
    { -416, 224, -144},
    { -408, 352, -168},
    { -512, 344, -136},
    { -648, 280, -72},
    { -720, 320, -24},
    { -608, 384, -64},
    // 17 seconds
    { -784, 472, -176},
    { -1032, 472, -160},
    { -1184, 384, -24},
    { -1400, 488, -136},
    { -1232, 560, -144},
    { -984, 504, -80},
    { -1088, 608, -240},
    { -880, 400, 24},
    { -560, 240, 64},
    { -448, 344, -72},
    { -424, 328, -16},
    { -416, 272, 48},
    { -528, 272, 64},
    { -600, 336, 56},
    { -696, 376, 56},
    { -936, 424, 48},
    { -1000, 448, 32},
    { -1040, 496, -104},
    { -1104, 504, -168},
    { -1072, 448, -32},
    { -896, 488, -216},
    { -872, 568, -320},
    { -672, 400, -192},
    { -448, 208, -144},
    { -392, 280, -176},
    // 18 seconds
    { -448, 328, -144},
    { -584, 312, -72},
    { -680, 344, -80},
    { -688, 360, -56},
    { -784, 392, -120},
    { -1032, 440, -152},
    { -1080, 344, -8},
    { -1512, 512, -200},
    { -1248, 576, -160},
    { -984, 456, -104},
    { -976, 640, -256},
    { -856, 424, -64},
    { -536, 288, 24},
    { -408, 352, -64},
    { -408, 336, -16},
    { -448, 280, 56},
    { -560, 296, 88},
    { -600, 352, 80},
    { -744, 408, 64},
    { -1016, 480, 40},
    { -1080, 480, 16},
    { -1296, 512, -104},
    { -1224, 504, -24},
    { -808, 528, -272},
    { -888, 440, -288},
    // 19 seconds
    { -720, 304, -168},
    { -480, 144, -144},
    { -360, 224, -128},
    { -376, 288, -168},
    { -512, 304, -168},
    { -632, 336, -64},
    { -680, 352, -56},
    { -656, 416, -96},
    { -824, 488, -136},
    { -968, 504, -104},
    { -1392, 512, -136},
    { -1504, 632, -176},
    { -1232, 552, 16},
    { -1096, 632, -136},
    { -960, 544, -64},
    { -512, 376, -16},
    { -376, 408, -144},
    { -392, 328, -8},
    { -408, 248, 88},
    { -528, 288, 96},
    { -576, 376, 64},
    { -736, 416, 88},
    { -1048, 440, 80},
    { -1008, 440, 64},
    { -1144, 504, -96},
    // 20 seconds
    { -1192, 560, -152},
    { -864, 456, -168},
    { -816, 496, -320},
    { -752, 432, -192},
    { -552, 320, -112},
    { -384, 344, -168},
    { -360, 352, -128},
    { -400, 344, -144},
    { -520, 344, -128},
    { -600, 384, -96},
    { -688, 416, -80},
    { -872, 496, -152},
    { -944, 512, -136},
    { -1360, 568, -208},
    { -1488, 680, -232},
    { -1344, 552, 0},
    { -1120, 504, 24},
    { -840, 528, -160},
    { -416, 472, -96},
    { -328, 400, -120},
    { -408, 352, -64},
    { -480, 256, 80},
    { -512, 280, 88},
    { -632, 368, 56},
    { -864, 392, 128},
    // 21 seconds
    { -1128, 416, 152},
    { -1048, 496, 24},
    { -1152, 480, -80},
    { -1088, 560, -128},
    { -880, 528, -304},
    { -840, 544, -368},
    { -576, 328, -176},
    { -360, 216, -136},
    { -344, 312, -224},
    { -384, 368, -216},
    { -536, 320, -136},
    { -664, 360, -80},
    { -640, 408, -48},
    { -856, 504, -144},
    { -960, 512, -144},
    { -1352, 512, -120},
    { -1472, 640, -184},
    { -1280, 584, -72},
    { -1080, 560, -80},
    { -856, 528, -112},
    { -528, 400, -24},
    { -328, 368, -72},
    { -376, 360, -16},
    { -408, 288, 64},
    { -552, 304, 136},
    // 22 seconds
    { -672, 360, 152},
    { -768, 416, 104},
    { -1040, 480, 104},
    { -1032, 480, 32},
    { -1208, 512, -72},
    { -1208, 512, -56},
    { -832, 528, -280},
    { -896, 480, -280},
    { -744, 328, -136},
    { -512, 136, -112},
    { -336, 224, -136},
    { -344, 312, -168},
    { -472, 360, -144},
    { -640, 376, -88},
    { -728, 368, -24},
    { -736, 432, -56},
    { -936, 512, -184},
    { -1008, 472, -64},
    { -1496, 544, -152},
    { -1368, 688, -208},
    { -1024, 456, -16},
    { -1048, 576, -184},
    { -736, 456, -80},
    { -456, 360, -56},
    { -384, 384, -112},
    // 23 seconds
    { -464, 344, -16},
    { -472, 248, 72},
    { -544, 288, 104},
    { -632, 352, 96},
    { -864, 424, 72},
    { -1072, 416, 128},
    { -1104, 472, 8},
    { -1184, 512, -72},
    { -1088, 528, -64},
    { -768, 544, -296},
    { -824, 536, -344},
    { -688, 384, -152},
    { -456, 200, -120},
    { -376, 288, -216},
    { -424, 384, -256},
    { -528, 320, -136},
    { -656, 320, -128},
    { -648, 392, -88},
    { -688, 432, -128},
    { -904, 584, -248},
    { -1360, 608, -176},
    { -1792, 584, -128},
    { -1016, 456, 112},
    { -1000, 624, -240},
    { -904, 640, -136},
    // 24 seconds
    { -696, 328, 64},
    { -392, 312, -8},
    { -360, 368, -48},
    { -328, 320, 0},
    { -456, 320, 40},
    { -560, 320, 96},
    { -592, 408, 80},
    { -864, 472, 24},
    { -1056, 504, 48},
    { -1168, 552, -88},
    { -1224, 536, -136},
    { -1112, 536, -104},
    { -704, 488, -272},
    { -808, 424, -224},
    { -632, 256, -120},
    { -384, 184, -72},
    { -344, 296, -128},
    { -480, 384, -144},
    { -552, 312, -40},
    { -688, 296, 0},
    { -664, 384, -72},
    { -784, 440, -136},
    { -984, 448, -160},
    { -1400, 480, -152},
    { -1832, 696, -288},
    // 25 seconds
    { -1104, 488, 104},
    { -920, 592, -248},
    { -968, 592, -80},
    { -664, 312, 184},
    { -184, 376, 112},
    { -200, 488, 24},
    { -360, 464, 24},
    { -584, 360, 72},
    { -736, 336, 48},
    { -784, 320, 56},
    { -1096, 352, -32},
    { -1112, 400, -88},
    { -1200, 368, -96},
    { -1224, 424, -184},
    { -944, 504, -320},
    { -976, 448, -240},
    { -784, 408, -168},
    { -432, 312, -136},
    { -328, 336, -104},
    { -288, 376, -128},
    { -368, 352, -104},
    { -480, 336, -16},
    { -624, 400, -40},
    { -680, 464, -8},
    { -888, 552, -80},
    // 26 seconds
    { -968, 584, -72},
    { -1536, 656, -144},
    { -1488, 752, -184},
    { -1168, 488, 64},
    { -1056, 640, -152},
    { -800, 480, -96},
    { -376, 336, 8},
    { -256, 344, -72},
    { -344, 320, -16},
    { -448, 304, 96},
    { -608, 304, 72},
    { -688, 352, 56},
    { -832, 360, 64},
    { -1088, 384, 72},
    { -1056, 448, -40},
    { -1192, 472, -104},
    { -1248, 552, -64},
    { -920, 504, -184},
    { -864, 520, -264},
    { -624, 416, -144},
    { -408, 264, -80},
    { -288, 312, -120},
    { -336, 360, -200},
    { -424, 336, -120},
    { -624, 328, -72},
    // 27 seconds
    { -688, 384, -24},
    { -744, 464, -48},
    { -904, 560, -136},
    { -1256, 592, -152},
    { -1560, 712, -208},
    { -1272, 616, -64},
    { -1192, 568, -104},
    { -960, 528, -72},
    { -680, 400, -24},
    { -424, 392, -56},
    { -344, 368, -72},
    { -360, 296, 32},
    { -384, 232, 80},
    { -456, 344, 56},
    { -568, 384, 72},
    { -896, 456, 64},
    { -1120, 464, 112},
    { -1440, 480, 40},
    { -1504, 576, 24},
    { -688, 736, -344},
    { -864, 576, -392},
    { -760, 240, -152},
    { -528, 16, -88},
    { -360, 232, -232},
    { -408, 352, -224},
    // 28 seconds
    { -520, 264, -176},
    { -648, 272, -80},
    { -648, 368, -104},
    { -712, 376, -104},
    { -904, 448, -176},
    { -1016, 416, -40},
    { -1440, 488, -104},
    { -1376, 600, -152},
    { -1024, 520, -8},
    { -1080, 672, -168},
    { -1016, 488, 16},
    { -656, 344, 72},
    { -424, 416, -40},
    { -440, 384, -24},
    { -416, 272, 88},
    { -464, 264, 104},
    { -552, 272, 104},
    { -648, 344, 80},
    { -1016, 400, 56},
    { -1064, 416, 40},
    { -1304, 472, -80},
    { -1296, 520, -72},
    { -944, 568, -312},
    { -960, 568, -328},
    { -744, 360, -160},
    // 29 seconds
    { -456, 176, -72},
    { -336, 280, -136},
    { -360, 392, -192},
    { -408, 328, -88},
    { -552, 360, -88},
    { -624, 456, -120},
    { -664, 432, -64},
    { -824, 528, -192},
    { -912, 464, -40},
    { -1392, 576, -160},
    { -1408, 600, -128},
    { -1224, 520, -24},
    { -1032, 608, -80},
    { -904, 560, -72},
    { -608, 408, 0},
    { -400, 376, -40},
    { -360, 368, -56},
    { -392, 304, 0},
    { -496, 272, 32},
    { -592, 280, 48},
    { -816, 296, 48},
    { -1048, 288, 96},
    { -1040, 376, 16},
    { -1216, 400, -16},
    { -1408, 536, -48},
    // 30 seconds
    { -1016, 584, -248},
    { -920, 520, -304},
    { -736, 496, -224},
    { -440, 160, -168},
    { -352, 280, -200},
    { -424, 360, -192},
    { -488, 280, -80},
    { -624, 280, -32},
    { -664, 360, -40},
    { -680, 376, 0},
    { -928, 480, -128},
    { -992, 488, -72},
    { -1288, 504, -88},
    { -1352, 752, -384},
    { -1096, 584, -88},
    { -1160, 520, -112},
    { -1016, 496, -64},
    { -632, 400, 16},
    { -424, 512, -64},
    { -440, 536, -96},
    { -448, 376, 8},
    { -480, 240, 128},
    { -520, 208, 144},
    { -600, 248, 120},
    { -848, 280, 136},
    // 31 seconds
    { -976, 344, 128},
    { -1304, 440, 16},
    { -1408, 520, -32},
    { -1024, 720, -400},
    { -904, 528, -288},
    { -776, 408, -216},
    { -608, 312, -184},
    { -432, 360, -160},
    { -432, 400, -200},
    { -456, 352, -160},
    { -504, 296, -96},
    { -552, 320, -80},
    { -584, 400, -112},
    { -808, 456, -152},
    { -1064, 464, -112},
    { -1408, 488, -80},
    { -1560, 640, -240},
    { -1088, 560, -40},
    { -904, 536, -120},
    { -912, 592, -176},
    { -688, 368, 8},
    { -448, 352, -24},
    { -416, 384, -80},
    { -456, 320, 32},
    { -488, 264, 96},
    // 32 seconds
    { -576, 304, 72},
    { -608, 368, 72},
    { -776, 392, 56},
    { -1072, 432, 24},
    { -1088, 448, -32},
    { -1424, 496, -104},
    { -1104, 528, -128},
    { -840, 552, -336},
    { -912, 528, -304},
    { -744, 328, -168},
    { -472, 200, -96},
    { -376, 272, -160},
    { -360, 328, -184},
    { -400, 272, -120},
    { -576, 296, -104},
    { -640, 344, -48},
    { -680, 392, -32},
    { -904, 544, -184},
    { -1200, 560, -136},
    { -1640, 592, -144},
    { -1144, 592, -32},
    { -872, 560, -136},
    { -1048, 792, -184},
    { -848, 432, 24},
    { -496, 368, -16},
    // 33 seconds
    { -424, 416, -32},
    { -416, 352, 24},
    { -416, 296, 48},
    { -552, 304, 56},
    { -624, 328, 32},
    { -880, 360, 64},
    { -1304, 400, 80},
    { -1296, 480, 32},
    { -1312, 496, -48},
    { -896, 520, -136},
    { -672, 536, -288},
    { -856, 392, -144},
    { -704, 288, -48},
    { -456, 280, -88},
    { -432, 352, -136},
    { -424, 344, -120},
    { -504, 304, -96},
    { -608, 328, -80},
    { -600, 368, -88},
    { -680, 392, -96},
    { -912, 512, -208},
    { -1384, 496, -152},
    { -1800, 608, -184},
    { -1032, 432, 136},
    { -944, 536, -232},
    // 34 seconds
    { -976, 616, -96},
    { -712, 336, 8},
    { -456, 352, -64},
    { -424, 368, -56},
    { -416, 304, 24},
    { -488, 240, 104},
    { -568, 280, 88},
    { -744, 328, 72},
    { -872, 288, 104},
    { -1144, 384, 112},
    { -1272, 512, -48},
    { -1344, 584, -144},
    { -784, 640, -344},
    { -840, 472, -264},
    { -896, 352, -32},
    { -664, 272, -160},
    { -400, 280, -152},
    { -392, 376, -168},
    { -432, 400, -200},
    { -512, 336, -112},
    { -632, 312, -96},
    { -704, 328, -48},
    { -768, 464, -152},
    { -976, 368, -224},
    { -1136, 424, -128},
    // 35 seconds
    { -1408, 536, -200},
    { -1224, 624, -144},
    { -1000, 544, -96},
    { -1088, 608, -160},
    { -776, 408, -24},
    { -536, 416, -64},
    { -440, 440, -112},
    { -480, 360, -8},
    { -496, 272, 72},
    { -536, 216, 96},
    { -560, 256, 64},
    { -736, 288, 64},
    { -976, 280, 128},
    { -1112, 312, 88},
    { -1264, 368, 56},
    { -1392, 552, -88},
    { -800, 576, -256},
    { -864, 560, -376},
    { -808, 456, -224},
    { -600, 176, -64},
    { -416, 232, -128},
    { -408, 328, -192},
    { -416, 336, -168},
    { -512, 304, -128},
    { -592, 320, -88},
    // 36 seconds
    { -680, 384, -88},
    { -944, 456, -120},
    { -1096, 448, -56},
    { -1504, 448, -176},
    { -1312, 632, -168},
    { -1088, 560, -104},
    { -1048, 696, -184},
    { -904, 480, -48},
    { -648, 440, -80},
    { -448, 416, -104},
    { -368, 344, -88},
    { -400, 288, -8},
    { -504, 288, 16},
    { -592, 296, 0},
    { -680, 264, 112},
    { -1008, 344, 112},
    { -1104, 432, 96},
    { -1256, 464, 24},
    { -1312, 528, -48},
    { -904, 576, -248},
    { -864, 448, -208},
    { -808, 408, -208},
    { -592, 240, -136},
    { -416, 288, -192},
    { -368, 288, -176},
    // 37 seconds
    { -400, 304, -200},
    { -528, 304, -144},
    { -648, 312, -104},
    { -680, 352, -64},
    { -824, 424, -160},
    { -1008, 464, -136},
    { -1296, 464, -136},
    { -1512, 600, -176},
    { -1104, 552, -16},
    { -1024, 608, -192},
    { -1048, 624, -104},
    { -816, 320, 104},
    { -520, 384, 24},
    { -432, 416, -16},
    { -392, 328, 64},
    { -424, 272, 120},
    { -528, 272, 104},
    { -576, 288, 96},
    { -808, 328, 80},
    { -1104, 392, 56},
    { -976, 400, -48},
    { -1240, 424, -88},
    { -1424, 496, -32},
    { -816, 520, -280},
    { -816, 536, -288},
    // 38 seconds
    { -744, 456, -224},
    { -584, 264, -112},
    { -416, 320, -120},
    { -392, 352, -184},
    { -464, 344, -160},
    { -584, 320, -96},
    { -608, 344, -80},
    { -632, 400, -72},
    { -856, 496, -152},
    { -928, 456, -40},
    { -1296, 504, -88},
    { -1384, 632, -168},
    { -1360, 584, -32},
    { -1136, 544, -48},
    { -864, 440, -16},
    { -592, 368, 40},
    { -344, 392, -40},
    { -328, 352, 0},
    { -320, 264, 104},
    { -432, 288, 104},
    { -664, 400, 64},
    { -736, 440, 64},
    { -1048, 440, 56},
    { -1152, 464, -40},
    { -1120, 456, -72},
    // 39 seconds
    { -1160, 504, -160},
    { -1024, 504, -272},
    { -976, 416, -88},
    { -800, 112, -112},
    { -528, 224, -152},
    { -312, 352, -224},
    { -328, 328, -184},
    { -448, 392, -120},
    { -544, 480, -80},
    { -624, 472, -56},
    { -592, 456, -88},
    { -728, 552, -224},
    { -888, 520, -216},
    { -1248, 568, -208},
    { -1440, 760, -368},
    { -1120, 632, -120},
    { -984, 632, -192},
    { -1008, 632, -320},
    { -760, 440, -40},
    { -512, 416, -64},
    { -472, 392, -120},
    { -464, 352, -72},
    { -432, 272, 40},
    { -440, 248, 48},
    { -472, 288, 0},
    // 40 seconds
    { -632, 344, -16},
    { -904, 400, -8},
    { -1032, 440, 8},
    { -1184, 528, -64},
    { -1384, 712, -200},
    { -976, 744, -312},
    { -816, 704, -384},
    { -712, 560, -216},
    { -584, 400, -192},
    { -480, 416, -184},
    { -408, 352, -160},
    { -392, 320, -144},
    { -464, 344, -144},
    { -544, 360, -128},
    { -592, 384, -88},
    { -656, 424, -128},
    { -904, 608, -264},
    { -1088, 608, -152},
    { -1328, 624, -176},
    { -1304, 752, -248},
    { -1008, 648, -72},
    { -928, 696, -168},
    { -736, 544, -64},
    { -496, 488, -32},
    { -392, 464, -72},
    // 41 seconds
    { -432, 424, -32},
    { -488, 344, 64},
    { -568, 328, 112},
    { -608, 352, 72},
    { -704, 400, 56},
    { -1032, 456, 40},
    { -1000, 408, 104},
    { -1168, 520, -72},
    { -1256, 592, -136},
    { -784, 544, -248},
    { -856, 608, -440},
    { -792, 488, -312},
    { -648, 240, -96},
    { -448, 208, -176},
    { -352, 224, -216},
    { -392, 280, -208},
    { -488, 304, -144},
    { -600, 336, -96},
    { -608, 368, -56},
    { -696, 424, -96},
    { -920, 552, -264},
    { -1024, 488, -72},
    { -1384, 648, -224},
    { -1336, 760, -184},
    { -1072, 672, -128},
    // 42 seconds
    { -1016, 792, -280},
    { -800, 544, -112},
    { -568, 480, -80},
    { -408, 440, -112},
    { -368, 400, -96},
    { -424, 336, -40},
    { -472, 280, 32},
    { -560, 320, 8},
    { -744, 352, 40},
    { -1112, 416, 120},
    { -1160, 456, 8},
    { -1128, 560, -152},
    { -1184, 648, -208},
    { -696, 592, -384},
    { -768, 552, -360},
    { -776, 480, -128},
    { -528, 368, -232},
    { -512, 272, -248},
    { -472, 224, -160},
    { -488, 152, -136},
    { -544, 224, -144},
    { -560, 288, -128},
    { -528, 328, -96},
    { -584, 400, -184},
    { -896, 528, -312},
    // 43 seconds
    { -1064, 488, -224},
    { -1640, 592, -216},
    { -1320, 640, -104},
    { -1104, 592, -144},
    { -968, 776, -224},
    { -752, 552, -80},
    { -464, 496, -56},
    { -320, 424, -40},
    { -320, 360, 8},
    { -400, 296, 24},
    { -488, 320, 24},
    { -552, 320, 8},
    { -800, 376, 8},
    { -1096, 392, 40},
    { -1168, 400, 8},
    { -1392, 416, 48},
    { -1568, 528, -80},
    { -816, 368, -232},
    { -832, 64, -144},
    { -712, 56, -144},
    { -424, -144, -216},
    { -544, -32, -264},
    { -280, 128, -56},
    { -680, 656, -232},
    { -728, 272, -40},
    // 44 seconds
    { -880, 440, -40},
    { -856, 280, -72},
    { -904, 560, -104},
    { -1096, 480, 16},
    { -1728, 632, -224},
    { -1304, 608, -72},
    { -1008, 552, -200},
    { -1056, 600, -160},
    { -936, 432, -40},
    { -648, 304, 48},
    { -504, 264, 88},
    { -448, 216, 0},
    { -552, 296, 32},
    { -536, 104, 176},
    { -544, 64, 168},
    { -656, 216, 80},
    { -888, 288, 96},
    { -1112, 384, -8},
    { -1456, 448, -40},
    { -1608, 400, -32},
    { -1040, 360, 16},
    { -968, 248, -208},
    { -552, 288, -272},
    { -384, 312, -280},
    { -400, 368, -192},
    // 45 seconds
    { -488, 344, -104},
    { -616, 408, -16},
    { -736, 384, 24},
    { -704, 400, -40},
    { -752, 488, -88},
    { -1000, 600, -184},
    { -1032, 448, -8},
    { -1624, 616, -200},
    { -1368, 608, -144},
    { -1232, 448, -72},
    { -1240, 496, -40},
    { -832, 408, 8},
    { -496, 336, 80},
    { -448, 304, 56},
    { -496, 264, 96},
    { -536, 240, 168},
    { -544, 152, 208},
    { -560, 152, 184},
    { -768, 224, 120},
    { -928, 272, 96},
    { -1056, 328, 8},
    { -1264, 320, -32},
    { -1552, 640, -152},
    { -1240, 496, -152},
    { -1008, 552, -272},
    // 46 seconds
    { -608, 432, -248},
    { -416, 352, -248},
    { -376, 392, -232},
    { -392, 328, -160},
    { -480, 304, -96},
    { -672, 400, -112},
    { -696, 368, -8},
    { -776, 440, -56},
    { -1032, 560, -160},
    { -1128, 496, -56},
    { -1416, 616, -200},
    { -1216, 648, -160},
    { -1048, 504, -80},
    { -1096, 592, -176},
    { -928, 416, 8},
    { -648, 392, 8},
    { -464, 384, -24},
    { -472, 344, -8},
    { -496, 272, 48},
    { -560, 240, 80},
    { -624, 256, 96},
    { -680, 256, 112},
    { -912, 288, 96},
    { -1016, 344, 24},
    { -1184, 336, 32},
    // 47 seconds
    { -1384, 368, 16},
    { -1096, 464, -240},
    { -1000, 456, -184},
    { -888, 392, -144},
    { -632, 320, -224},
    { -400, 312, -144},
    { -360, 384, -208},
    { -424, 408, -208},
    { -592, 376, -136},
    { -800, 400, -104},
    { -696, 408, -72},
    { -720, 456, -136},
    { -912, 560, -216},
    { -984, 464, -48},
    { -1400, 520, -152},
    { -1296, 656, -216},
    { -1280, 528, -88},
    { -1280, 576, -96},
    { -1048, 424, 32},
    { -696, 392, 56},
    { -544, 376, -8},
    { -432, 288, 88},
    { -408, 248, 112},
    { -536, 240, 112},
    { -632, 240, 96},
    // 48 seconds
    { -624, 224, 136},
    { -728, 248, 96},
    { -960, 304, 64},
    { -888, 400, -96},
    { -1048, 344, -16},
    { -1144, 400, -72},
    { -1224, 472, -264},
    { -1240, 496, -264},
    { -944, 384, -312},
    { -624, 328, -256},
    { -440, 296, -184},
    { -360, 248, -192},
    { -400, 312, -240},
    { -472, 320, -168},
    { -584, 336, -104},
    { -648, 376, -104},
    { -656, 400, -80},
    { -880, 464, -168},
    { -1016, 416, -32},
    { -1064, 384, 0},
    { -1384, 560, -128},
    { -1256, 584, -56},
    { -1256, 504, -8},
    { -1232, 528, -56},
    { -832, 376, 32},
    // 49 seconds
    { -520, 384, -48},
    { -472, 376, -88},
    { -464, 272, -8},
    { -480, 216, 64},
    { -528, 208, 64},
    { -576, 256, 88},
    { -624, 288, 112},
    { -928, 352, 96},
    { -1064, 384, 96},
    { -1112, 392, 40},
    { -1280, 448, 24},
    { -1248, 488, -96},
    { -1008, 608, -336},
    { -880, 448, -288},
    { -816, 288, -144},
    { -584, 72, -96},
    { -384, 168, -136},
    { -344, 312, -216},
    { -440, 352, -184},
    { -536, 288, -40},
    { -696, 288, 8},
    { -656, 320, 8},
    { -784, 392, -56},
    { -992, 424, -64},
    { -1056, 344, 72},
    // 50 seconds
    { -1544, 488, -88},
    { -1408, 536, -64},
    { -976, 552, -96},
    { -1192, 712, -272},
    { -912, 328, 120},
    { -648, 312, 32},
    { -560, 368, 72},
    { -384, 328, 136},
    { -368, 312, 160},
    { -472, 256, 184},
    { -632, 272, 144},
    { -696, 320, 96},
    { -1000, 352, 40},
    { -1144, 328, 96},
    { -1144, 352, -56},
    { -1368, 376, -72},
    { -1080, 456, -96},
    { -888, 440, -376},
    { -904, 336, -216},
    { -624, 56, -80},
    { -424, 208, -160},
    { -440, 296, -168},
    { -488, 304, -48},
    { -608, 304, -48},
    { -656, 320, 8},
    // 51 seconds
    { -608, 336, 8},
    { -704, 384, -104},
    { -880, 432, -144},
    { -976, 352, 0},
    { -1320, 448, -144},
    { -1432, 592, -256},
    { -1032, 480, -56},
    { -1032, 584, -144},
    { -1056, 448, -72},
    { -728, 304, 56},
    { -512, 376, 0},
    { -520, 376, -24},
    { -528, 272, 104},
    { -576, 208, 160},
    { -616, 248, 152},
    { -600, 280, 136},
    { -736, 336, 80},
    { -1104, 416, -8},
    { -1088, 344, 48},
    { -1248, 336, -24},
    { -1288, 448, -88},
    { -840, 624, -400},
    { -896, 496, -352},
    { -840, 264, -128},
    { -584, 144, -112},
    // 52 seconds
    { -400, 272, -128},
    { -416, 368, -184},
    { -432, 344, -128},
    { -552, 272, -56},
    { -704, 312, -40},
    { -672, 344, -40},
    { -736, 400, -128},
    { -968, 432, -160},
    { -1056, 352, -16},
    { -1560, 408, -104},
    { -1328, 512, -88},
    { -968, 440, -48},
    { -1128, 640, -224},
    { -920, 392, 8},
    { -664, 280, 48},
    { -520, 344, -48},
    { -488, 336, -24},
    { -488, 264, 40},
    { -544, 232, 88},
    { -600, 232, 112},
    { -688, 264, 104},
    { -880, 304, 96},
    { -992, 320, 96},
    { -1056, 368, 16},
    { -1280, 400, -16},
    // 53 seconds
    { -1296, 440, 8},
    { -888, 568, -312},
    { -856, 576, -344},
    { -848, 352, -152},
    { -656, 160, -96},
    { -456, 248, -96},
    { -424, 352, -184},
    { -456, 328, -152},
    { -560, 256, -32},
    { -712, 264, -16},
    { -680, 328, -16},
    { -672, 352, -80},
    { -872, 416, -152},
    { -1040, 392, -32},
    { -1384, 384, -56},
    { -1624, 576, -192},
    { -936, 440, 48},
    { -1000, 640, -240},
    { -1000, 592, -152},
    { -728, 296, 40},
    { -544, 344, -32},
    { -560, 344, -24},
    { -520, 256, 80},
    { -568, 240, 128},
    { -608, 248, 152},
    // 54 seconds
    { -600, 280, 136},
    { -736, 344, 88},
    { -912, 368, 72},
    { -968, 360, 16},
    { -1120, 408, -48},
    { -1336, 432, -80},
    { -1304, 440, -136},
    { -768, 608, -376},
    { -800, 512, -360},
    { -760, 320, -184},
    { -632, 176, -104},
    { -496, 272, -120},
    { -448, 320, -144},
    { -472, 312, -120},
    { -512, 256, -32},
    { -608, 296, -24},
    { -616, 352, -48},
    { -664, 392, -80},
    { -960, 440, -144},
    { -1200, 400, -32},
    { -1640, 464, -72},
    { -1320, 584, -72},
    { -904, 560, -120},
    { -1032, 736, -240},
    { -904, 352, 48},
    // 55 seconds
    { -712, 336, 16},
    { -544, 384, -24},
    { -520, 360, -24},
    { -496, 272, 56},
    { -520, 216, 128},
    { -560, 280, 104},
    { -672, 328, 104},
    { -888, 352, 104},
    { -1208, 392, 104},
    { -1168, 424, 24},
    { -1184, 416, -24},
    { -1160, 464, -72},
    { -824, 528, -288},
    { -824, 400, -200},
    { -744, 216, -128},
    { -560, 176, -128},
    { -448, 272, -136},
    { -432, 344, -152},
    { -512, 344, -104},
    { -624, 312, -40},
    { -656, 312, -24},
    { -592, 376, -64},
    { -760, 448, -144},
    { -1000, 448, -120},
    { -1112, 352, 0},
    // 56 seconds
    { -1576, 568, -168},
    { -1200, 536, -8},
    { -888, 496, -128},
    { -1240, 632, -160},
    { -1024, 280, 144},
    { -728, 272, 104},
    { -544, 360, -16},
    { -472, 320, 8},
    { -456, 240, 72},
    { -504, 168, 128},
    { -576, 224, 112},
    { -616, 272, 112},
    { -880, 328, 96},
    { -1080, 368, 72},
    { -1216, 480, -24},
    { -1320, 456, -16},
    { -1152, 520, -104},
    { -840, 544, -280},
    { -824, 472, -224},
    { -688, 352, -128},
    { -552, 328, -120},
    { -432, 368, -120},
    { -472, 376, -128},
    { -552, 344, -88},
    { -688, 296, -24},
    // 57 seconds
    { -680, 288, 8},
    { -656, 352, -40},
    { -840, 416, -112},
    { -1040, 360, -24},
    { -1400, 368, 8},
    { -1568, 480, -88},
    { -936, 456, 16},
    { -1072, 496, -136},
    { -1104, 448, 0},
    { -776, 248, 88},
    { -520, 344, -40},
    { -488, 352, -32},
    { -440, 248, 48},
    { -480, 192, 112},
    { -568, 240, 112},
    { -584, 280, 128},
    { -736, 320, 104},
    { -1008, 416, 72},
    { -1064, 424, 64},
    { -1232, 432, 32},
    { -1496, 488, 32},
    { -936, 536, -168},
    { -728, 520, -256},
    { -840, 472, -200},
    { -784, 256, -80},
    // 58 seconds
    { -552, 264, -48},
    { -488, 328, -96},
    { -464, 360, -136},
    { -528, 296, -80},
    { -616, 272, -48},
    { -592, 296, -32},
    { -592, 344, -56},
    { -848, 424, -120},
    { -976, 392, -32},
    { -1176, 400, -24},
    { -1480, 568, -112},
    { -1216, 608, 24},
    { -1160, 552, -16},
    { -1192, 512, 0},
    { -816, 312, 88},
    { -616, 384, -32},
    { -568, 392, -40},
    { -480, 256, 72},
    { -440, 208, 96},
    { -528, 232, 112},
    { -528, 264, 136},
    { -632, 320, 120},
    { -888, 408, 80},
    { -1032, 440, 40},
    { -1088, 456, -40},
    // 59 seconds
    { -1336, 456, 0},
    { -1152, 480, -40},
    { -696, 600, -312},
    { -848, 624, -368},
    { -784, 400, -104},
    { -624, 216, -64},
    { -504, 344, -112},
    { -504, 408, -136},
    { -520, 352, -96},
    { -592, 288, -32},
    { -608, 320, -8},
    { -608, 344, -48},
    { -792, 400, -96},
    { -936, 384, -64},
    { -1112, 384, -40},
    { -1488, 512, -128},
    { -1224, 568, -40},
    { -1032, 480, -88},
    { -1232, 544, -96},
    { -896, 296, 64},
    { -616, 376, -64},
    { -504, 408, -112},
    { -448, 312, -8},
    { -456, 224, 64},
    { -544, 280, 96},
    // 60 seconds
    // elapsed: 1 minutes
    { -624, 360, 144},
    { -648, 392, 136},
    { -784, 432, 72},
    { -912, 464, 72},
    { -864, 456, 8},
    { -1144, 480, -104},
    { -1280, 504, -40},
    { -1000, 456, -144},
    { -736, 552, -320},
    { -744, 504, -288},
    { -712, 352, -168},
    { -584, 264, -104},
    { -496, 304, -88},
    { -536, 368, -120},
    { -600, 344, -80},
    { -648, 312, -16},
    { -672, 376, -56},
    { -600, 376, -56},
    { -720, 408, -104},
    { -952, 432, -152},
    { -1032, 352, 8},
    { -1528, 480, -104},
    { -1208, 568, -56},
    { -872, 504, -120},
    { -1248, 688, -216},
    // 61 seconds
    { -1032, 328, 72},
    { -760, 328, 8},
    { -608, 392, -72},
    { -576, 376, -48},
    { -520, 256, 32},
    { -536, 192, 80},
    { -592, 192, 120},
    { -624, 200, 136},
    { -720, 256, 120},
    { -912, 296, 128},
    { -968, 344, 88},
    { -1240, 400, 40},
    { -1392, 512, -8},
    { -936, 608, -232},
    { -936, 592, -328},
    { -792, 416, -136},
    { -568, 280, -152},
    { -512, 384, -224},
    { -504, 408, -192},
    { -568, 320, -112},
    { -648, 328, -80},
    { -664, 360, -40},
    { -584, 368, -40},
    { -736, 448, -136},
    { -1032, 464, -104},
    // 62 seconds
    { -1224, 352, 56},
    { -1464, 496, -72},
    { -1168, 584, -40},
    { -912, 504, -112},
    { -1168, 552, -88},
    { -880, 296, 104},
    { -640, 328, 16},
    { -544, 376, -32},
    { -512, 304, 48},
    { -480, 216, 104},
    { -504, 240, 112},
    { -616, 304, 96},
    { -688, 320, 136},
    { -952, 368, 120},
    { -1168, 408, 120},
    { -1152, 424, 72},
    { -1184, 488, -56},
    { -1056, 464, -72},
    { -712, 400, -112},
    { -800, 472, -256},
    { -752, 408, -192},
    { -552, 304, -152},
    { -456, 328, -144},
    { -456, 368, -200},
    { -528, 376, -160},
    // 63 seconds
    { -640, 320, -80},
    { -720, 336, -40},
    { -720, 360, -32},
    { -880, 400, -56},
    { -1016, 360, 48},
    { -1416, 416, 32},
    { -1336, 496, -32},
    { -1096, 576, -88},
    { -1072, 496, -16},
    { -1128, 344, 80},
    { -808, 264, 80},
    { -520, 184, -16},
    { -496, 256, -32},
    { -552, 216, 64},
    { -600, 176, 136},
    { -680, 208, 152},
    { -736, 280, 168},
    { -792, 328, 120},
    { -1008, 368, 104},
    { -1048, 352, 104},
    { -1080, 384, 40},
    { -1088, 432, -56},
    { -992, 432, -48},
    { -848, 512, -232},
    { -904, 480, -248},
    // 64 seconds
    { -736, 328, -168},
    { -496, 200, -128},
    { -456, 272, -176},
    { -520, 328, -168},
    { -624, 304, -72},
    { -720, 296, -24},
    { -672, 344, -24},
    { -600, 360, -56},
    { -752, 400, -112},
    { -896, 368, -48},
    { -1192, 368, -24},
    { -1360, 448, -48},
    { -1272, 600, -120},
    { -1072, 496, -24},
    { -1120, 488, -80},
    { -832, 368, 40},
    { -640, 312, -72},
    { -536, 352, -48},
    { -512, 248, 64},
    { -568, 208, 72},
    { -616, 224, 112},
    { -640, 280, 112},
    { -680, 312, 96},
    { -968, 360, 96},
    { -1072, 368, 80},
    // 65 seconds
    { -1128, 416, 24},
    { -1224, 504, -72},
    { -968, 560, -200},
    { -720, 600, -392},
    { -840, 472, -272},
    { -760, 272, -88},
    { -600, 280, -120},
    { -544, 328, -144},
    { -528, 336, -96},
    { -544, 288, -48},
    { -632, 312, -56},
    { -648, 320, -40},
    { -608, 384, -80},
    { -720, 432, -152},
    { -944, 464, -192},
    { -1216, 392, -64},
    { -1376, 448, -80},
    { -1128, 568, -120},
    { -856, 520, -112},
    { -1112, 600, -120},
    { -848, 336, 112},
    { -632, 360, 24},
    { -520, 416, -32},
    { -520, 336, 40},
    { -520, 264, 88},
    // 66 seconds
    { -640, 280, 96},
    { -688, 280, 104},
    { -736, 312, 88},
    { -888, 352, 48},
    { -936, 352, 32},
    { -1120, 416, -72},
    { -1288, 424, -40},
    { -1288, 424, -48},
    { -672, 464, -200},
    { -760, 488, -288},
    { -768, 392, -176},
    { -608, 136, -48},
    { -480, 248, -88},
    { -496, 336, -112},
    { -576, 344, -120},
    { -680, 304, -40},
    { -744, 336, -56},
    { -624, 344, -72},
    { -632, 384, -128},
    { -864, 448, -216},
    { -1032, 376, -40},
    { -1392, 376, 0},
    { -1648, 600, -48},
    { -664, 472, 24},
    { -864, 632, -304},
    // 67 seconds
    { -992, 608, -152},
    { -904, 208, 144},
    { -720, 232, 56},
    { -632, 320, -16},
    { -576, 312, 32},
    { -568, 248, 72},
    { -608, 224, 120},
    { -592, 256, 136},
    { -608, 296, 128},
    { -600, 320, 96},
    { -904, 400, 32},
    { -1136, 416, 32},
    { -1696, 376, 24},
    { -1552, 440, 0},
    { -360, 648, -528},
    { -976, 760, -704},
    { -656, 192, -96},
    { -624, 184, -64},
    { -648, 520, -312},
    { -648, 456, -176},
    { -736, 472, -136},
    { -752, 688, -296},
    { -704, 720, -280},
    { -688, 744, -416},
    { -688, 768, -336},
    // 68 seconds
    { -648, 712, -456},
    { -552, 680, -528},
    { -472, 608, -456},
    { -464, 528, -608},
    { -376, 400, -632},
    { -464, 352, -744},
    { -376, 176, -696},
    { -264, 16, -656},
    { -224, -8, -736},
    { -160, -112, -664},
    { -160, -144, -696},
    { -200, -184, -840},
    { -192, -296, -792},
    { -144, -336, -792},
    { -128, -272, -840},
    { -136, -280, -880},
    { -128, -344, -896},
    { -104, -280, -904},
    { -64, -344, -840},
    { -72, -328, -848},
    { -56, -328, -872},
    { -96, -320, -920},
    { -72, -320, -872},
    { -72, -344, -880},
    { -88, -320, -888},
    // 69 seconds
    { -72, -304, -880},
    { -64, -304, -888},
    { -40, -336, -864},
    { -32, -336, -848},
    { -40, -352, -856},
    { -40, -336, -880},
    { 32, -344, -888},
    { 0, -336, -880},
    { -40, -392, -856},
    { -96, -344, -904},
    { -120, -360, -920},
    { -136, -392, -872},
    { -128, -416, -808},
    { -224, -360, -888},
    { -88, -352, -864},
    { -120, -408, -848},
    { -152, -440, -856},
    { -120, -400, -832},
    { -112, -360, -864},
    { -8, -784, -800},
    { -120, -496, -792},
    { -64, -464, -872},
    { -128, -424, -832},
    { -184, -456, -872},
    { -80, -424, -848},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:49:08 local
AccelRawData *activity_sample_walk_100_pbl_25655_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25655_5
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -256, -256, -856},
    { -272, -304, -776},
    { -240, -392, -808},
    { -336, -256, -800},
    { -288, -384, -816},
    { -304, -416, -776},
    { -368, -400, -760},
    { -352, -464, -816},
    { -392, -408, -768},
    { -408, -384, -768},
    { -272, -416, -816},
    { -376, -392, -752},
    { -312, -320, -808},
    { -264, -416, -832},
    { -200, -384, -816},
    { -256, -344, -816},
    { -224, -336, -808},
    { -320, -416, -720},
    { -240, -408, -752},
    { -296, -424, -864},
    { -280, -384, -848},
    { -328, -392, -848},
    { -320, -440, -824},
    { -192, -288, -848},
    { -112, -328, -816},
    // 1 seconds
    { -256, -320, -816},
    { -208, -288, -816},
    { -168, -320, -800},
    { -200, -232, -872},
    { -208, -336, -864},
    { -264, -280, -904},
    { -272, -288, -896},
    { -264, -280, -864},
    { -200, -272, -864},
    { -192, -248, -848},
    { -192, -248, -864},
    { -216, -232, -880},
    { -224, -240, -888},
    { -256, -240, -880},
    { -248, -280, -848},
    { -240, -256, -856},
    { -248, -200, -880},
    { -256, -248, -856},
    { -232, -216, -888},
    { -240, -224, -880},
    { -232, -248, -864},
    { -232, -216, -888},
    { -216, -232, -888},
    { -248, -208, -896},
    { -256, -200, -880},
    // 2 seconds
    { -232, -216, -856},
    { -224, -192, -848},
    { -200, -192, -864},
    { -208, -176, -888},
    { -208, -192, -888},
    { -200, -184, -896},
    { -200, -176, -904},
    { -208, -192, -896},
    { -208, -176, -904},
    { -208, -184, -896},
    { -216, -144, -912},
    { -208, -160, -904},
    { -208, -152, -904},
    { -224, -128, -928},
    { -232, -160, -904},
    { -240, -144, -912},
    { -224, -152, -888},
    { -248, -88, -904},
    { -216, -112, -888},
    { -216, -120, -872},
    { -216, -128, -888},
    { -232, -104, -904},
    { -208, -136, -896},
    { -200, -104, -896},
    { -176, -88, -920},
    // 3 seconds
    { -176, -96, -912},
    { -192, -96, -928},
    { -200, -96, -928},
    { -192, -128, -928},
    { -160, -120, -912},
    { -144, -120, -920},
    { -152, -96, -912},
    { -168, -104, -920},
    { -184, -120, -904},
    { -200, -104, -912},
    { -192, -120, -888},
    { -184, -112, -888},
    { -168, -112, -880},
    { -168, -112, -888},
    { -192, -112, -904},
    { -200, -112, -904},
    { -184, -104, -896},
    { -184, -120, -896},
    { -192, -96, -920},
    { -200, -96, -936},
    { -184, -96, -936},
    { -184, -88, -936},
    { -192, -96, -928},
    { -200, -96, -912},
    { -192, -104, -888},
    // 4 seconds
    { -184, -88, -896},
    { -192, -88, -904},
    { -208, -96, -904},
    { -216, -104, -912},
    { -216, -128, -904},
    { -200, -112, -880},
    { -184, -104, -888},
    { -184, -96, -896},
    { -200, -96, -912},
    { -224, -104, -928},
    { -392, -240, -976},
    { -448, -176, -880},
    { -504, 136, -1072},
    { 24, 320, -952},
    { 304, 600, -808},
    { 496, 704, -632},
    { 456, 536, -704},
    { 352, 656, -584},
    { 256, 400, -608},
    { 184, 424, -568},
    { 128, 576, -584},
    { 8, 576, -960},
    { 184, 696, -736},
    { 192, 496, -648},
    { 128, 736, -528},
    // 5 seconds
    { 288, 736, -640},
    { 248, 752, -528},
    { 192, 648, -648},
    { 184, 624, -720},
    { 208, 736, -640},
    { 192, 480, -640},
    { 176, 552, -712},
    { 200, 664, -720},
    { 192, 672, -648},
    { 208, 616, -664},
    { 192, 624, -688},
    { 192, 688, -664},
    { 160, 648, -680},
    { 136, 656, -712},
    { 152, 616, -664},
    { 152, 616, -680},
    { 160, 624, -680},
    { 136, 576, -688},
    { 176, 624, -712},
    { 144, 592, -712},
    { 184, 584, -696},
    { 104, 616, -816},
    { 168, 624, -688},
    { 168, 576, -720},
    { 160, 576, -736},
    // 6 seconds
    { 160, 592, -736},
    { 152, 584, -712},
    { 136, 576, -736},
    { 136, 536, -856},
    { 136, 528, -800},
    { 160, 560, -784},
    { 200, 528, -552},
    { 216, 560, -752},
    { 176, 488, -864},
    { 152, 504, -808},
    { 176, 480, -744},
    { 152, 528, -784},
    { 136, 512, -792},
    { 144, 448, -824},
    { 168, 512, -776},
    { 176, 496, -776},
    { 144, 440, -784},
    { 168, 480, -736},
    { 160, 488, -768},
    { 112, 456, -824},
    { 184, 568, -840},
    { 160, 600, -784},
    { 96, 504, -728},
    { 152, 648, -696},
    { 152, 496, -608},
    // 7 seconds
    { 128, 768, -680},
    { 160, 824, -576},
    { 152, 768, -448},
    { 128, 800, -440},
    { 96, 928, -432},
    { 160, 840, -352},
    { 64, 864, -416},
    { 128, 1008, -312},
    { 152, 904, -216},
    { 24, 984, -288},
    { 128, 880, -216},
    { 80, 1008, -344},
    { 72, 1016, -296},
    { 120, 960, -192},
    { 104, 928, -224},
    { 136, 856, -224},
    { 96, 928, -344},
    { 104, 1024, -280},
    { 128, 880, -208},
    { 96, 896, -208},
    { 104, 896, -184},
    { 96, 920, -288},
    { 96, 952, -208},
    { 72, 912, -136},
    { 96, 952, -168},
    // 8 seconds
    { 64, 1048, -152},
    { 88, 936, -144},
    { 88, 912, -168},
    { 88, 928, -208},
    { 64, 904, -280},
    { 32, 896, -312},
    { 40, 856, -384},
    { 24, 840, -448},
    { 160, 968, -744},
    { 184, 1048, -696},
    { 152, 288, -544},
    { 80, -24, -792},
    { -64, 520, -992},
    { -24, -184, -1096},
    { -88, -72, -1000},
    { -104, -168, -856},
    { -144, -184, -880},
    { -128, -232, -848},
    { -176, -88, -880},
    { -160, -200, -920},
    { -144, -128, -936},
    { -112, -160, -920},
    { -104, -168, -896},
    { -72, -168, -936},
    { -112, -136, -960},
    // 9 seconds
    { -144, -152, -888},
    { -168, -144, -920},
    { -192, -176, -904},
    { -216, -224, -856},
    { -256, -224, -872},
    { -256, -208, -936},
    { -264, -176, -912},
    { -232, -224, -896},
    { -240, -248, -832},
    { -288, -192, -848},
    { -216, -272, -912},
    { -208, -288, -872},
    { -168, -304, -912},
    { -216, -216, -896},
    { -176, -280, -856},
    { -168, -240, -864},
    { -176, -280, -856},
    { -176, -280, -864},
    { -208, -200, -888},
    { -168, -184, -864},
    { -144, -192, -744},
    { -136, -184, -872},
    { -120, -264, -928},
    { -176, -216, -968},
    { -216, -240, -952},
    // 10 seconds
    { -168, -176, -920},
    { -136, -240, -872},
    { -112, -240, -824},
    { -104, -200, -832},
    { -120, -208, -808},
    { -144, -176, -848},
    { -168, -176, -856},
    { -160, -168, -832},
    { -144, -128, -880},
    { -200, -96, -984},
    { -216, -48, -1120},
    { -512, 232, -1560},
    { -280, 208, -1296},
    { -120, 200, -1008},
    { -88, 144, -920},
    { -32, 104, -744},
    { -64, 120, -712},
    { -80, 120, -824},
    { -88, 48, -752},
    { -64, 96, -752},
    { -8, 72, -736},
    { 0, 48, -744},
    { -80, 72, -776},
    { -16, 88, -800},
    { -48, 136, -944},
    // 11 seconds
    { -192, 128, -1104},
    { -240, 208, -1152},
    { -304, 248, -1552},
    { -408, 256, -1272},
    { -416, 256, -1008},
    { -288, 192, -888},
    { -88, 120, -592},
    { 24, 8, -504},
    { 64, 56, -536},
    { 48, 64, -528},
    { -8, 104, -672},
    { -48, 184, -728},
    { -48, 144, -768},
    { -128, 232, -928},
    { -152, 232, -952},
    { -368, 792, -1376},
    { -560, 680, -1296},
    { -216, 784, -1120},
    { -256, 568, -1144},
    { -208, 288, -808},
    { -120, 272, -632},
    { 56, 248, -528},
    { 104, 304, -528},
    { 24, 320, -480},
    { -8, 360, -520},
    // 12 seconds
    { -40, 392, -624},
    { -56, 488, -720},
    { -184, 456, -880},
    { -352, 720, -1224},
    { -464, 656, -1176},
    { -648, 688, -1184},
    { -424, 408, -944},
    { -320, 264, -736},
    { -216, 200, -616},
    { -96, 120, -512},
    { -40, 128, -504},
    { -48, 184, -512},
    { -128, 288, -656},
    { -160, 296, -696},
    { -128, 336, -760},
    { -112, 440, -880},
    { -168, 464, -928},
    { -360, 920, -1512},
    { -720, 832, -1216},
    { -424, 848, -1016},
    { -272, 616, -880},
    { -256, 320, -504},
    { -136, 352, -424},
    { -48, 280, -480},
    { -72, 240, -480},
    // 13 seconds
    { -40, 352, -488},
    { -48, 352, -608},
    { -96, 408, -672},
    { -128, 416, -688},
    { -248, 488, -920},
    { -400, 424, -864},
    { -480, 656, -1048},
    { -608, 672, -1128},
    { -528, 552, -952},
    { -408, 552, -912},
    { -224, 264, -712},
    { -136, 184, -544},
    { -96, 248, -536},
    { -64, 248, -584},
    { -80, 296, -568},
    { -112, 376, -664},
    { -144, 280, -648},
    { -80, 304, -648},
    { -104, 456, -880},
    { -248, 440, -832},
    { -448, 760, -1176},
    { -648, 904, -1296},
    { -496, 752, -1008},
    { -424, 784, -992},
    { -336, 424, -688},
    // 14 seconds
    { -200, 360, -544},
    { -40, 392, -456},
    { 0, 296, -400},
    { -32, 352, -440},
    { -32, 312, -440},
    { -40, 360, -512},
    { -56, 448, -656},
    { -144, 512, -776},
    { -352, 656, -1048},
    { -400, 576, -1048},
    { -368, 728, -1240},
    { -544, 552, -1088},
    { -344, 472, -864},
    { -184, 304, -800},
    { -176, 224, -656},
    { -96, 176, -504},
    { -40, 280, -536},
    { -56, 264, -520},
    { -112, 344, -584},
    { -176, 312, -656},
    { -144, 312, -648},
    { -120, 536, -840},
    { -240, 528, -952},
    { -280, 576, -1000},
    { -560, 1104, -1408},
    // 15 seconds
    { -256, 608, -920},
    { -248, 736, -912},
    { -192, 464, -752},
    { -216, 424, -600},
    { -80, 368, -480},
    { -8, 304, -464},
    { -8, 296, -424},
    { 0, 360, -464},
    { -32, 424, -568},
    { -80, 480, -688},
    { -256, 568, -824},
    { -368, 672, -1016},
    { -408, 784, -1224},
    { -640, 720, -1088},
    { -344, 600, -904},
    { -208, 408, -808},
    { -296, 328, -720},
    { -192, 176, -504},
    { -104, 288, -512},
    { -80, 384, -544},
    { -80, 240, -488},
    { -152, 400, -632},
    { -80, 432, -648},
    { 0, 480, -792},
    { -104, 600, -936},
    // 16 seconds
    { -256, 832, -1200},
    { -360, 920, -1232},
    { -232, 704, -920},
    { -192, 816, -952},
    { -168, 528, -680},
    { -176, 456, -528},
    { -88, 504, -496},
    { 64, 328, -408},
    { 72, 360, -392},
    { 80, 328, -392},
    { 96, 328, -448},
    { 0, 192, -384},
    { -32, -88, -104},
    { -336, 216, -240},
    { -912, 544, -464},
    { -1416, 792, -376},
    { -1872, 976, -240},
    { -1640, 1240, -304},
    { -1248, 792, -64},
    { -536, 184, -8},
    { -408, 472, -200},
    { -320, 544, -136},
    { -440, 376, -8},
    { -568, 312, 128},
    { -672, 536, -8},
    // 17 seconds
    { -728, 520, -56},
    { -952, 680, -216},
    { -1104, 640, -184},
    { -1520, 544, -144},
    { -1528, 632, -256},
    { -1032, 384, -88},
    { -936, 616, -272},
    { -816, 504, -152},
    { -632, 376, 64},
    { -456, 304, 72},
    { -448, 328, 8},
    { -456, 272, 64},
    { -456, 216, 96},
    { -528, 208, 80},
    { -624, 320, -8},
    { -872, 336, -40},
    { -1112, 304, 64},
    { -1368, 336, 0},
    { -1472, 496, -48},
    { -1096, 736, -464},
    { -880, 616, -280},
    { -808, 408, -104},
    { -616, 424, -192},
    { -376, 400, -120},
    { -264, 400, -184},
    // 18 seconds
    { -280, 344, -144},
    { -360, 352, -96},
    { -568, 424, -168},
    { -744, 424, -152},
    { -1048, 472, -144},
    { -1216, 560, -160},
    { -1456, 616, -184},
    { -1432, 736, -328},
    { -960, 568, -144},
    { -1008, 624, -216},
    { -992, 496, -8},
    { -680, 368, 112},
    { -408, 392, -16},
    { -416, 376, 0},
    { -440, 320, 72},
    { -568, 328, 104},
    { -560, 336, 104},
    { -592, 376, 72},
    { -768, 392, 16},
    { -976, 424, -8},
    { -888, 400, -56},
    { -1120, 440, -176},
    { -1136, 488, -136},
    { -960, 520, -256},
    { -856, 608, -304},
    // 19 seconds
    { -608, 456, -224},
    { -440, 408, -192},
    { -384, 424, -184},
    { -416, 376, -136},
    { -512, 376, -112},
    { -616, 416, -96},
    { -680, 456, -96},
    { -672, 480, -112},
    { -880, 544, -200},
    { -960, 544, -168},
    { -1256, 552, -136},
    { -1448, 712, -280},
    { -1016, 664, -200},
    { -904, 576, -136},
    { -840, 640, -136},
    { -712, 432, -24},
    { -528, 416, -32},
    { -456, 448, -120},
    { -488, 432, -24},
    { -488, 360, 16},
    { -528, 352, 48},
    { -536, 368, 8},
    { -680, 408, -24},
    { -960, 392, -16},
    { -1008, 432, -152},
    // 20 seconds
    { -1240, 392, -80},
    { -1208, 552, -288},
    { -1000, 544, -384},
    { -936, 416, -184},
    { -664, 384, -248},
    { -392, 352, -232},
    { -304, 328, -216},
    { -344, 352, -200},
    { -408, 296, -120},
    { -520, 328, -112},
    { -672, 456, -152},
    { -704, 416, -64},
    { -984, 568, -176},
    { -1112, 624, -200},
    { -1456, 608, -176},
    { -1336, 736, -336},
    { -1032, 536, -128},
    { -1064, 560, -200},
    { -896, 424, -64},
    { -640, 336, 0},
    { -456, 376, -64},
    { -416, 352, -48},
    { -376, 296, 32},
    { -464, 248, 88},
    { -568, 288, 64},
    // 21 seconds
    { -696, 344, 48},
    { -912, 320, 64},
    { -1056, 328, 80},
    { -1096, 432, -96},
    { -1128, 472, -216},
    { -1184, 552, -248},
    { -952, 464, -328},
    { -840, 440, -280},
    { -632, 408, -280},
    { -424, 336, -208},
    { -344, 352, -184},
    { -360, 344, -136},
    { -424, 328, -120},
    { -536, 376, -136},
    { -656, 400, -112},
    { -688, 424, -120},
    { -960, 536, -256},
    { -984, 520, -168},
    { -1416, 520, -216},
    { -1200, 688, -384},
    { -1096, 568, -240},
    { -1240, 608, -200},
    { -1072, 384, 80},
    { -648, 368, 32},
    { -424, 472, -96},
    // 22 seconds
    { -376, 424, -56},
    { -376, 312, 16},
    { -448, 248, 80},
    { -576, 336, 56},
    { -712, 368, 48},
    { -968, 360, 88},
    { -992, 376, 64},
    { -1184, 448, -24},
    { -1128, 544, -176},
    { -928, 664, -480},
    { -1048, 552, -328},
    { -920, 328, -152},
    { -616, 312, -192},
    { -424, 400, -216},
    { -368, 400, -200},
    { -424, 368, -200},
    { -440, 304, -136},
    { -528, 304, -128},
    { -616, 400, -120},
    { -768, 408, -128},
    { -1008, 504, -160},
    { -1104, 472, -72},
    { -1400, 576, -200},
    { -1392, 680, -224},
    { -1136, 536, -40},
    // 23 seconds
    { -1056, 560, -160},
    { -736, 448, -112},
    { -512, 328, -64},
    { -336, 368, -120},
    { -344, 360, -72},
    { -448, 352, 8},
    { -592, 392, 16},
    { -640, 408, 40},
    { -648, 424, 48},
    { -840, 432, 32},
    { -1000, 424, 8},
    { -1080, 480, -72},
    { -1112, 432, -136},
    { -1264, 488, -224},
    { -880, 504, -376},
    { -824, 272, -152},
    { -696, 336, -232},
    { -472, 320, -192},
    { -328, 344, -176},
    { -368, 368, -168},
    { -472, 344, -120},
    { -584, 376, -88},
    { -696, 400, -120},
    { -656, 376, -88},
    { -824, 424, -120},
    // 24 seconds
    { -1088, 520, -168},
    { -1232, 488, -88},
    { -1296, 576, -200},
    { -1048, 712, -336},
    { -1008, 568, -192},
    { -1080, 584, -216},
    { -880, 376, -16},
    { -640, 368, -24},
    { -432, 392, -64},
    { -424, 384, -56},
    { -480, 368, 0},
    { -544, 304, 80},
    { -584, 328, 80},
    { -624, 384, 48},
    { -872, 416, 56},
    { -1040, 424, 40},
    { -1072, 480, -56},
    { -1080, 448, -184},
    { -1232, 440, -160},
    { -760, 480, -296},
    { -816, 408, -264},
    { -712, 376, -288},
    { -496, 232, -168},
    { -368, 304, -144},
    { -384, 392, -232},
    // 25 seconds
    { -448, 368, -216},
    { -608, 408, -144},
    { -704, 424, -192},
    { -664, 408, -136},
    { -928, 520, -264},
    { -1096, 520, -256},
    { -1344, 480, -176},
    { -1456, 656, -360},
    { -1032, 560, -160},
    { -880, 600, -256},
    { -816, 552, -160},
    { -640, 416, -40},
    { -456, 400, -64},
    { -416, 416, -32},
    { -440, 360, 24},
    { -536, 352, 48},
    { -608, 376, 80},
    { -648, 368, 96},
    { -720, 416, 16},
    { -968, 440, -8},
    { -984, 392, -8},
    { -1160, 392, -80},
    { -1048, 488, -208},
    { -968, 536, -464},
    { -976, 416, -272},
    // 26 seconds
    { -840, 360, -224},
    { -584, 408, -256},
    { -384, 392, -208},
    { -344, 360, -248},
    { -392, 320, -168},
    { -464, 288, -104},
    { -584, 360, -136},
    { -640, 416, -112},
    { -688, 448, -112},
    { -872, 536, -192},
    { -1000, 488, -104},
    { -1384, 576, -168},
    { -1408, 752, -344},
    { -1216, 648, -224},
    { -1144, 600, -168},
    { -968, 448, -24},
    { -632, 408, -24},
    { -368, 464, -128},
    { -336, 384, -56},
    { -408, 352, 16},
    { -512, 384, 56},
    { -584, 392, 96},
    { -600, 416, 56},
    { -640, 456, -16},
    { -832, 464, -24},
    // 27 seconds
    { -840, 400, -48},
    { -1080, 456, -144},
    { -1088, 464, -152},
    { -1128, 528, -328},
    { -944, 568, -360},
    { -712, 488, -288},
    { -544, 440, -296},
    { -360, 360, -224},
    { -376, 344, -168},
    { -456, 320, -176},
    { -536, 376, -144},
    { -680, 392, -96},
    { -720, 456, -112},
    { -688, 456, -112},
    { -936, 536, -240},
    { -976, 512, -184},
    { -1432, 488, -264},
    { -1368, 688, -448},
    { -1112, 464, -152},
    { -1040, 528, -152},
    { -736, 520, -152},
    { -528, 432, -96},
    { -384, 392, -64},
    { -384, 352, -8},
    { -392, 312, 16},
    // 28 seconds
    { -504, 320, 0},
    { -664, 336, 40},
    { -736, 304, 40},
    { -928, 320, 40},
    { -976, 352, 0},
    { -1312, 440, -40},
    { -1320, 456, -120},
    { -976, 600, -464},
    { -936, 456, -280},
    { -848, 344, -264},
    { -560, 296, -264},
    { -360, 304, -208},
    { -288, 328, -256},
    { -344, 280, -176},
    { -456, 312, -120},
    { -600, 456, -224},
    { -616, 496, -184},
    { -752, 528, -176},
    { -968, 624, -240},
    { -1152, 576, -160},
    { -1272, 720, -392},
    { -1224, 664, -296},
    { -1096, 560, -160},
    { -936, 568, -192},
    { -656, 456, -80},
    // 29 seconds
    { -368, 392, -48},
    { -392, 384, -48},
    { -376, 368, 24},
    { -432, 328, 56},
    { -600, 368, 32},
    { -640, 384, 40},
    { -792, 408, -16},
    { -1024, 416, -40},
    { -952, 408, -136},
    { -1240, 368, -96},
    { -1232, 472, -200},
    { -1000, 560, -432},
    { -880, 480, -264},
    { -632, 464, -264},
    { -432, 376, -176},
    { -336, 368, -160},
    { -344, 360, -144},
    { -448, 296, -88},
    { -592, 360, -192},
    { -688, 376, -160},
    { -712, 376, -128},
    { -840, 440, -272},
    { -896, 456, -232},
    { -1248, 504, -232},
    { -1232, 624, -312},
    // 30 seconds
    { -1336, 688, -256},
    { -1128, 720, -192},
    { -960, 568, -96},
    { -640, 440, -40},
    { -408, 432, -128},
    { -352, 424, -128},
    { -400, 320, 0},
    { -456, 320, 0},
    { -536, 320, 0},
    { -592, 376, -16},
    { -704, 368, 16},
    { -1032, 464, -72},
    { -968, 528, -168},
    { -1120, 448, -104},
    { -1288, 568, -192},
    { -1088, 512, -216},
    { -856, 488, -152},
    { -600, 496, -336},
    { -400, 336, -232},
    { -312, 312, -184},
    { -368, 280, -200},
    { -448, 312, -208},
    { -600, 352, -176},
    { -592, 376, -136},
    { -640, 392, -136},
    // 31 seconds
    { -896, 512, -264},
    { -1144, 544, -176},
    { -1536, 560, -168},
    { -1432, 720, -248},
    { -1024, 560, -96},
    { -888, 672, -280},
    { -816, 496, -104},
    { -608, 376, -72},
    { -488, 312, -32},
    { -384, 328, -32},
    { -408, 352, 0},
    { -512, 352, 40},
    { -544, 384, 24},
    { -576, 392, 40},
    { -776, 440, -8},
    { -952, 488, -40},
    { -1152, 528, -112},
    { -1176, 560, -168},
    { -952, 592, -376},
    { -872, 536, -328},
    { -848, 416, -288},
    { -680, 368, -208},
    { -440, 344, -232},
    { -384, 368, -224},
    { -440, 352, -200},
    // 32 seconds
    { -480, 328, -128},
    { -520, 352, -120},
    { -568, 448, -144},
    { -624, 520, -168},
    { -816, 576, -216},
    { -1120, 600, -152},
    { -1384, 648, -232},
    { -1224, 720, -272},
    { -800, 584, -120},
    { -840, 592, -304},
    { -712, 440, -96},
    { -632, 368, -56},
    { -552, 400, -136},
    { -528, 392, -88},
    { -544, 320, 0},
    { -576, 376, -32},
    { -584, 360, 16},
    { -584, 376, 0},
    { -712, 448, -72},
    { -872, 456, -64},
    { -872, 440, -96},
    { -1216, 440, -80},
    { -1272, 544, -200},
    { -880, 432, -144},
    { -904, 568, -328},
    // 33 seconds
    { -768, 512, -360},
    { -568, 288, -168},
    { -472, 272, -160},
    { -432, 336, -224},
    { -512, 376, -192},
    { -648, 488, -208},
    { -704, 416, -72},
    { -608, 464, -136},
    { -568, 488, -208},
    { -664, 504, -224},
    { -752, 464, -208},
    { -912, 440, -128},
    { -1168, 552, -216},
    { -1080, 576, -168},
    { -992, 648, -224},
    { -1056, 720, -288},
    { -912, 496, -24},
    { -752, 384, -40},
    { -576, 424, -96},
    { -488, 448, -120},
    { -480, 336, -40},
    { -520, 280, 24},
    { -552, 288, 24},
    { -576, 296, 16},
    { -632, 336, 8},
    // 34 seconds
    { -856, 392, -8},
    { -1000, 472, -88},
    { -1152, 520, -128},
    { -1200, 512, -120},
    { -1280, 552, -192},
    { -776, 504, -144},
    { -704, 568, -248},
    { -648, 496, -280},
    { -608, 328, -160},
    { -528, 320, -120},
    { -552, 304, -136},
    { -616, 320, -160},
    { -656, 336, -88},
    { -720, 336, -88},
    { -680, 384, -120},
    { -696, 416, -136},
    { -888, 464, -160},
    { -928, 416, -72},
    { -1152, 424, -56},
    { -1168, 624, -224},
    { -888, 568, -184},
    { -784, 496, -128},
    { -880, 608, -280},
    { -784, 384, -40},
    { -680, 328, -24},
    // 35 seconds
    { -576, 408, -56},
    { -560, 424, -40},
    { -576, 400, -16},
    { -608, 400, 8},
    { -632, 408, 8},
    { -680, 416, -16},
    { -872, 472, -24},
    { -960, 480, -56},
    { -912, 488, -72},
    { -1072, 496, -120},
    { -984, 504, -160},
    { -616, 368, -128},
    { -672, 456, -272},
    { -720, 304, -248},
    { -720, 296, -184},
    { -584, 328, -192},
    { -624, 360, -208},
    { -704, 376, -168},
    { -696, 336, -96},
    { -672, 384, -128},
    { -592, 400, -144},
    { -616, 432, -168},
    { -856, 480, -216},
    { -944, 472, -184},
    { -1136, 472, -160},
    // 36 seconds
    { -1144, 584, -216},
    { -1032, 544, -144},
    { -760, 544, -168},
    { -840, 576, -264},
    { -792, 408, -32},
    { -704, 320, 8},
    { -584, 384, -48},
    { -584, 376, -32},
    { -608, 360, -8},
    { -680, 328, 16},
    { -672, 336, 24},
    { -608, 320, 16},
    { -728, 408, -72},
    { -968, 424, -72},
    { -952, 408, -56},
    { -1112, 408, -88},
    { -1128, 488, -104},
    { -904, 544, -184},
    { -744, 552, -224},
    { -696, 536, -224},
    { -696, 432, -192},
    { -560, 368, -144},
    { -496, 368, -120},
    { -528, 352, -152},
    { -584, 376, -176},
    // 37 seconds
    { -672, 360, -152},
    { -680, 376, -144},
    { -664, 384, -136},
    { -872, 456, -208},
    { -920, 424, -168},
    { -1240, 464, -160},
    { -1248, 592, -264},
    { -960, 472, -40},
    { -896, 544, -144},
    { -888, 520, -120},
    { -728, 368, 0},
    { -608, 392, -48},
    { -552, 392, -72},
    { -544, 352, -48},
    { -576, 304, -16},
    { -608, 304, -8},
    { -648, 336, -32},
    { -832, 376, -16},
    { -1072, 408, -40},
    { -1120, 392, 32},
    { -1024, 440, -168},
    { -896, 464, -160},
    { -800, 432, -192},
    { -944, 424, -240},
    { -768, 304, -176},
    // 38 seconds
    { -496, 248, -192},
    { -456, 320, -256},
    { -512, 304, -200},
    { -616, 296, -120},
    { -648, 336, -96},
    { -592, 392, -128},
    { -704, 488, -248},
    { -1032, 528, -184},
    { -1184, 496, -56},
    { -1272, 600, -160},
    { -1128, 672, -216},
    { -936, 696, -256},
    { -992, 528, -200},
    { -848, 416, -88},
    { -696, 376, -80},
    { -504, 392, -120},
    { -528, 360, -64},
    { -520, 296, -32},
    { -560, 280, 8},
    { -632, 280, 40},
    { -672, 312, 24},
    { -888, 336, 32},
    { -1040, 336, 48},
    { -1072, 384, -16},
    { -1152, 376, -40},
    // 39 seconds
    { -1056, 432, -96},
    { -904, 496, -296},
    { -880, 432, -200},
    { -752, 376, -232},
    { -616, 376, -264},
    { -472, 352, -208},
    { -416, 312, -200},
    { -464, 312, -200},
    { -552, 280, -160},
    { -680, 352, -168},
    { -712, 392, -144},
    { -728, 424, -152},
    { -904, 512, -232},
    { -1104, 496, -176},
    { -1392, 520, -176},
    { -1136, 544, -152},
    { -880, 520, -168},
    { -1080, 640, -232},
    { -1032, 416, 0},
    { -864, 352, 72},
    { -624, 384, 32},
    { -488, 384, 24},
    { -448, 392, 24},
    { -456, 360, 56},
    { -520, 320, 80},
    // 40 seconds
    { -560, 368, 40},
    { -688, 392, 16},
    { -928, 464, -40},
    { -976, 456, -88},
    { -1136, 480, -136},
    { -992, 440, -176},
    { -976, 384, -176},
    { -960, 384, -224},
    { -848, 360, -200},
    { -664, 344, -208},
    { -464, 336, -224},
    { -400, 312, -200},
    { -448, 272, -152},
    { -576, 304, -120},
    { -680, 336, -104},
    { -688, 432, -152},
    { -712, 432, -136},
    { -1000, 512, -200},
    { -1096, 488, -88},
    { -1336, 512, -120},
    { -1152, 672, -216},
    { -1072, 632, -208},
    { -992, 600, -160},
    { -784, 480, -80},
    { -632, 408, -64},
    // 41 seconds
    { -488, 400, -80},
    { -528, 368, -48},
    { -600, 344, 16},
    { -696, 328, 56},
    { -736, 336, 72},
    { -728, 336, 72},
    { -888, 352, 88},
    { -992, 336, 72},
    { -832, 360, 8},
    { -1032, 336, -72},
    { -1064, 416, -112},
    { -920, 336, -168},
    { -904, 448, -240},
    { -784, 496, -296},
    { -552, 344, -248},
    { -480, 304, -200},
    { -488, 320, -200},
    { -568, 296, -152},
    { -664, 360, -152},
    { -696, 432, -200},
    { -680, 392, -136},
    { -784, 472, -216},
    { -992, 504, -248},
    { -1088, 432, -112},
    { -1368, 592, -320},
    // 42 seconds
    { -1016, 536, -152},
    { -1040, 472, -120},
    { -1144, 528, -176},
    { -936, 416, -32},
    { -640, 376, -64},
    { -504, 368, -96},
    { -496, 272, 0},
    { -520, 256, 24},
    { -592, 272, 32},
    { -584, 280, 56},
    { -624, 312, 40},
    { -792, 344, 64},
    { -968, 344, 24},
    { -1144, 416, -48},
    { -1184, 352, -48},
    { -1160, 520, -344},
    { -920, 456, -312},
    { -856, 360, -392},
    { -784, 336, -368},
    { -608, 336, -280},
    { -480, 336, -256},
    { -464, 336, -232},
    { -488, 320, -160},
    { -520, 336, -136},
    { -568, 392, -128},
    // 43 seconds
    { -616, 464, -112},
    { -688, 552, -176},
    { -936, 592, -240},
    { -952, 512, -120},
    { -1344, 560, -216},
    { -1160, 632, -248},
    { -1032, 560, -200},
    { -1040, 560, -240},
    { -864, 408, -120},
    { -680, 368, -112},
    { -568, 400, -136},
    { -512, 352, -72},
    { -472, 336, -24},
    { -456, 336, -16},
    { -528, 344, 24},
    { -512, 336, 16},
    { -568, 352, 0},
    { -896, 408, -8},
    { -952, 416, -72},
    { -1184, 456, -144},
    { -1304, 480, -144},
    { -1208, 552, -392},
    { -976, 496, -336},
    { -872, 352, -248},
    { -736, 272, -208},
    // 44 seconds
    { -544, 272, -160},
    { -424, 272, -168},
    { -424, 224, -120},
    { -496, 264, -72},
    { -592, 272, -24},
    { -656, 336, -40},
    { -648, 360, -64},
    { -736, 448, -144},
    { -1024, 480, -168},
    { -1032, 512, -128},
    { -1488, 592, -192},
    { -1272, 736, -272},
    { -1032, 624, -208},
    { -1096, 616, -200},
    { -960, 464, -96},
    { -784, 376, -48},
    { -632, 360, -56},
    { -544, 320, -24},
    { -520, 272, 16},
    { -512, 224, 56},
    { -560, 192, 96},
    { -600, 192, 128},
    { -672, 264, 88},
    { -880, 296, 48},
    { -928, 400, -64},
    // 45 seconds
    { -1200, 408, -80},
    { -1288, 432, -120},
    { -1256, 464, -240},
    { -1112, 456, -216},
    { -776, 480, -296},
    { -560, 400, -288},
    { -416, 360, -224},
    { -352, 312, -152},
    { -392, 328, -136},
    { -488, 384, -152},
    { -632, 480, -168},
    { -704, 488, -96},
    { -848, 520, -144},
    { -1080, 656, -224},
    { -1288, 592, -152},
    { -1432, 592, -192},
    { -1288, 560, -160},
    { -896, 440, -48},
    { -896, 528, -144},
    { -760, 432, -16},
    { -560, 328, 48},
    { -512, 352, 16},
    { -544, 344, 32},
    { -608, 288, 80},
    { -640, 272, 72},
    // 46 seconds
    { -600, 280, 72},
    { -600, 312, 48},
    { -840, 336, 56},
    { -968, 296, 72},
    { -1048, 392, -48},
    { -1088, 344, -64},
    { -1296, 504, -192},
    { -944, 488, -240},
    { -888, 384, -176},
    { -768, 520, -272},
    { -616, 320, -224},
    { -464, 336, -216},
    { -488, 384, -224},
    { -528, 344, -192},
    { -624, 352, -152},
    { -712, 400, -152},
    { -632, 416, -120},
    { -784, 472, -176},
    { -992, 520, -240},
    { -1024, 408, -40},
    { -1320, 488, -144},
    { -1312, 608, -176},
    { -936, 536, -104},
    { -1056, 584, -136},
    { -960, 448, -16},
    // 47 seconds
    { -736, 336, 16},
    { -568, 376, -16},
    { -464, 392, -56},
    { -496, 328, 40},
    { -544, 336, 16},
    { -560, 328, 56},
    { -608, 328, 64},
    { -656, 360, 32},
    { -856, 360, 56},
    { -872, 392, -48},
    { -1048, 408, -128},
    { -1120, 408, -192},
    { -1384, 424, -232},
    { -976, 456, -376},
    { -824, 384, -224},
    { -680, 408, -280},
    { -544, 312, -232},
    { -424, 304, -128},
    { -432, 336, -136},
    { -512, 368, -144},
    { -632, 376, -80},
    { -688, 424, -88},
    { -648, 432, -112},
    { -720, 496, -168},
    { -960, 552, -264},
    // 48 seconds
    { -968, 440, -40},
    { -1272, 496, -160},
    { -1224, 656, -248},
    { -1136, 576, -176},
    { -1152, 608, -184},
    { -1040, 456, -64},
    { -784, 360, -8},
    { -544, 400, -88},
    { -480, 360, -32},
    { -496, 320, 40},
    { -560, 344, 80},
    { -608, 304, 136},
    { -568, 352, 120},
    { -592, 360, 104},
    { -744, 384, 64},
    { -832, 424, -48},
    { -912, 440, -216},
    { -1136, 368, -72},
    { -1280, 376, -216},
    { -1144, 520, -416},
    { -1032, 536, -328},
    { -744, 408, -312},
    { -584, 360, -264},
    { -448, 336, -192},
    { -424, 344, -176},
    // 49 seconds
    { -488, 328, -136},
    { -528, 288, -72},
    { -640, 344, -80},
    { -680, 408, -96},
    { -632, 424, -104},
    { -792, 472, -152},
    { -1032, 496, -168},
    { -1104, 424, -80},
    { -1232, 560, -240},
    { -1288, 672, -256},
    { -1160, 568, -96},
    { -1128, 504, -32},
    { -848, 408, -32},
    { -576, 432, -80},
    { -480, 400, -48},
    { -440, 320, 8},
    { -456, 296, 40},
    { -560, 360, 16},
    { -624, 400, 72},
    { -592, 408, 72},
    { -664, 440, 8},
    { -920, 472, -16},
    { -1000, 448, -48},
    { -1144, 400, -32},
    { -1072, 472, -176},
    // 50 seconds
    { -992, 456, -216},
    { -912, 472, -272},
    { -872, 408, -256},
    { -744, 296, -184},
    { -544, 280, -176},
    { -432, 320, -152},
    { -392, 320, -136},
    { -440, 320, -120},
    { -504, 320, -64},
    { -608, 368, -64},
    { -744, 432, -128},
    { -824, 400, -112},
    { -1136, 432, -200},
    { -1104, 480, -208},
    { -1392, 536, -240},
    { -1152, 536, -240},
    { -1072, 544, -216},
    { -1120, 608, -240},
    { -952, 392, -24},
    { -688, 360, -32},
    { -488, 424, -112},
    { -440, 352, -32},
    { -472, 296, 40},
    { -528, 344, 56},
    { -568, 344, 112},
    // 51 seconds
    { -584, 360, 104},
    { -624, 416, 64},
    { -912, 424, 48},
    { -1008, 448, -72},
    { -1256, 416, -72},
    { -1168, 456, -176},
    { -1056, 448, -360},
    { -1024, 472, -392},
    { -888, 344, -312},
    { -696, 288, -272},
    { -464, 296, -224},
    { -392, 320, -232},
    { -416, 296, -160},
    { -440, 264, -72},
    { -528, 328, -56},
    { -592, 400, -80},
    { -632, 424, -72},
    { -808, 464, -120},
    { -968, 504, -160},
    { -1024, 416, -56},
    { -1320, 528, -144},
    { -1296, 680, -264},
    { -1120, 608, -200},
    { -1096, 552, -160},
    { -944, 464, -80},
    // 52 seconds
    { -696, 360, -56},
    { -520, 376, -88},
    { -440, 344, -40},
    { -456, 312, 24},
    { -496, 304, 72},
    { -640, 360, 88},
    { -648, 384, 104},
    { -728, 392, 80},
    { -992, 408, 64},
    { -936, 384, 40},
    { -1088, 432, -80},
    { -992, 424, -168},
    { -1208, 384, -128},
    { -936, 472, -280},
    { -824, 448, -296},
    { -632, 464, -288},
    { -472, 328, -224},
    { -416, 328, -168},
    { -456, 344, -192},
    { -536, 336, -144},
    { -656, 336, -112},
    { -744, 392, -112},
    { -696, 408, -80},
    { -896, 512, -208},
    { -992, 528, -192},
    // 53 seconds
    { -1352, 488, -136},
    { -1288, 592, -272},
    { -1080, 568, -224},
    { -1064, 552, -168},
    { -960, 392, -56},
    { -728, 328, 8},
    { -504, 376, -48},
    { -432, 376, -48},
    { -432, 312, 8},
    { -512, 256, 40},
    { -592, 272, 56},
    { -664, 272, 72},
    { -848, 296, 64},
    { -1072, 320, 72},
    { -984, 360, 8},
    { -1288, 368, -64},
    { -1368, 432, -104},
    { -952, 488, -328},
    { -792, 296, -104},
    { -712, 344, -208},
    { -488, 392, -304},
    { -368, 424, -232},
    { -296, 208, -200},
    { -496, 344, -232},
    { -704, 392, -208},
    // 54 seconds
    { -792, 424, -184},
    { -752, 456, -184},
    { -936, 512, -272},
    { -1096, 432, -200},
    { -1040, 328, -32},
    { -1176, 480, -192},
    { -1240, 600, -248},
    { -864, 472, -96},
    { -944, 536, -200},
    { -912, 448, -64},
    { -704, 304, 8},
    { -592, 360, -40},
    { -528, 352, -24},
    { -560, 296, 24},
    { -560, 256, 56},
    { -616, 240, 128},
    { -536, 288, 48},
    { -608, 320, 72},
    { -832, 320, 40},
    { -952, 400, -104},
    { -1216, 376, -96},
    { -1200, 400, -96},
    { -1416, 528, -360},
    { -992, 528, -280},
    { -704, 344, -136},
    // 55 seconds
    { -712, 456, -248},
    { -600, 384, -176},
    { -480, 352, -128},
    { -464, 336, -96},
    { -480, 328, -96},
    { -576, 336, -96},
    { -616, 360, -80},
    { -616, 408, -112},
    { -768, 440, -160},
    { -1016, 496, -248},
    { -1048, 328, 24},
    { -1328, 408, -80},
    { -1800, 680, -256},
    { -1088, 512, 8},
    { -864, 448, -120},
    { -832, 512, -160},
    { -528, 304, -16},
    { -384, 304, -56},
    { -432, 352, -48},
    { -536, 336, 56},
    { -600, 368, 96},
    { -648, 384, 112},
    { -640, 368, 128},
    { -728, 416, 72},
    { -992, 432, 56},
    // 56 seconds
    { -880, 360, 24},
    { -1152, 368, -32},
    { -1384, 464, -128},
    { -952, 424, -256},
    { -728, 472, -368},
    { -728, 488, -408},
    { -720, 224, -240},
    { -568, 192, -144},
    { -496, 280, -200},
    { -504, 336, -184},
    { -560, 312, -128},
    { -624, 304, -96},
    { -624, 336, -96},
    { -592, 376, -96},
    { -792, 448, -176},
    { -1040, 480, -192},
    { -1432, 440, -64},
    { -1760, 672, -296},
    { -776, 456, 88},
    { -888, 568, -256},
    { -880, 656, -176},
    { -744, 280, 64},
    { -544, 400, -48},
    { -496, 440, -72},
    { -528, 368, 8},
    // 57 seconds
    { -680, 320, 56},
    { -688, 368, 104},
    { -760, 352, 80},
    { -592, 424, 32},
    { -680, 392, -8},
    { -864, 376, -56},
    { -824, 360, -144},
    { -1264, 256, 64},
    { -1408, 280, -16},
    { -960, 544, -400},
    { -768, 472, -232},
    { -768, 328, -104},
    { -688, 224, -88},
    { -576, 344, -48},
    { -520, 408, -88},
    { -552, 384, -80},
    { -568, 360, -32},
    { -632, 392, -88},
    { -704, 376, -80},
    { -688, 408, -136},
    { -696, 392, -128},
    { -896, 528, -304},
    { -984, 456, -144},
    { -1216, 376, -80},
    { -1496, 608, -240},
    // 58 seconds
    { -1024, 456, 0},
    { -832, 520, -200},
    { -1168, 600, -128},
    { -904, 312, 40},
    { -816, 320, 16},
    { -648, 352, 8},
    { -552, 312, 24},
    { -536, 264, 32},
    { -504, 248, 80},
    { -568, 224, 120},
    { -544, 304, -32},
    { -672, 344, -40},
    { -920, 344, -56},
    { -808, 328, -96},
    { -1176, 304, -88},
    { -1200, 360, -80},
    { -1336, 480, -328},
    { -1000, 520, -304},
    { -816, 440, -224},
    { -720, 464, -256},
    { -640, 376, -144},
    { -488, 400, -112},
    { -448, 416, -128},
    { -472, 384, -112},
    { -520, 344, -64},
    // 59 seconds
    { -616, 376, -120},
    { -656, 376, -144},
    { -760, 368, -160},
    { -1040, 496, -296},
    { -1128, 416, -176},
    { -1416, 336, -104},
    { -1416, 544, -256},
    { -1016, 480, -136},
    { -1056, 504, -152},
    { -952, 416, -72},
    { -664, 304, 16},
    { -496, 360, -72},
    { -448, 384, -80},
    { -464, 240, 40},
    { -544, 280, 32},
    { -624, 328, 56},
    { -648, 336, 96},
    { -640, 368, 40},
    { -920, 376, 32},
    { -1008, 344, 0},
    { -1176, 368, -56},
    { -1064, 368, -144},
    { -1232, 456, -232},
    { -944, 576, -424},
    { -816, 368, -272},
    // 60 seconds
    // elapsed: 1 minutes
    { -760, 296, -224},
    { -632, 280, -232},
    { -480, 296, -160},
    { -424, 296, -152},
    { -432, 320, -168},
    { -472, 328, -88},
    { -592, 416, -96},
    { -648, 464, -136},
    { -816, 528, -152},
    { -1016, 568, -168},
    { -1208, 536, -64},
    { -1256, 632, -176},
    { -1056, 704, -312},
    { -728, 472, -32},
    { -856, 480, -152},
    { -808, 416, -40},
    { -664, 352, 0},
    { -552, 424, -32},
    { -568, 392, -16},
    { -616, 352, 32},
    { -640, 336, 64},
    { -672, 320, 56},
    { -936, 368, 48},
    { -1064, 336, 96},
    { -1000, 352, 56},
    // 61 seconds
    { -1176, 480, -96},
    { -1072, 480, -152},
    { -888, 360, -136},
    { -616, 384, -208},
    { -680, 384, -304},
    { -688, 176, -192},
    { -576, 120, -152},
    { -536, 224, -168},
    { -576, 296, -144},
    { -624, 320, -136},
    { -624, 328, -96},
    { -600, 344, -80},
    { -648, 392, -144},
    { -800, 432, -224},
    { -944, 440, -80},
    { -1456, 472, -128},
    { -1400, 672, -216},
    { -1016, 584, -144},
    { -1048, 688, -256},
    { -896, 536, -120},
    { -656, 368, -48},
    { -520, 432, -120},
    { -528, 392, -80},
    { -552, 336, -16},
    { -616, 320, -16},
    // 62 seconds
    { -640, 320, 0},
    { -656, 296, 56},
    { -752, 368, 8},
    { -920, 376, 8},
    { -912, 392, -88},
    { -1120, 504, -256},
    { -1152, 400, -168},
    { -1168, 288, -184},
    { -720, 328, -216},
    { -704, 336, -200},
    { -712, 360, -288},
    { -568, 288, -224},
    { -424, 272, -176},
    { -456, 312, -176},
    { -560, 360, -176},
    { -608, 368, -160},
    { -728, 440, -200},
    { -656, 480, -240},
    { -728, 536, -336},
    { -992, 528, -280},
    { -880, 408, -120},
    { -1200, 544, -208},
    { -1528, 616, -160},
    { -616, 496, -88},
    { -832, 584, -264},
    // 63 seconds
    { -984, 608, -144},
    { -936, 352, 0},
    { -824, 352, -48},
    { -696, 352, -40},
    { -648, 296, 32},
    { -544, 272, -8},
    { -544, 264, 40},
    { -560, 256, 32},
    { -552, 296, 0},
    { -664, 320, -16},
    { -944, 384, -72},
    { -888, 384, -120},
    { -1176, 360, -112},
    { -1312, 328, -40},
    { -1304, 416, -144},
    { -880, 528, -240},
    { -784, 488, -208},
    { -656, 488, -272},
    { -632, 296, -104},
    { -504, 352, -120},
    { -480, 416, -152},
    { -528, 424, -176},
    { -576, 392, -136},
    { -728, 424, -160},
    { -664, 360, -72},
    // 64 seconds
    { -632, 408, -104},
    { -824, 512, -200},
    { -1040, 464, -120},
    { -1264, 384, -48},
    { -1568, 624, -240},
    { -1128, 504, -48},
    { -984, 336, 16},
    { -976, 480, -112},
    { -784, 392, 48},
    { -600, 288, 48},
    { -552, 360, 8},
    { -568, 320, 48},
    { -600, 288, 64},
    { -664, 288, 64},
    { -712, 280, 80},
    { -608, 264, 80},
    { -672, 328, 16},
    { -888, 352, -32},
    { -880, 328, -56},
    { -1224, 344, -88},
    { -1264, 352, -32},
    { -1128, 416, -232},
    { -992, 408, -200},
    { -824, 304, -232},
    { -672, 208, -160},
    // 65 seconds
    { -520, 256, -112},
    { -456, 368, -104},
    { -512, 440, -96},
    { -608, 456, -64},
    { -712, 520, -72},
    { -712, 512, -80},
    { -712, 504, -88},
    { -864, 592, -184},
    { -928, 528, -112},
    { -1112, 504, -160},
    { -1544, 584, -144},
    { -1504, 544, -144},
    { -1248, 392, -8},
    { -1288, 464, -104},
    { -936, 400, -48},
    { -688, 248, 32},
    { -600, 232, 32},
    { -592, 240, 40},
    { -528, 168, 104},
    { -424, 176, 88},
    { -448, 232, 48},
    { -424, 264, -24},
    { -536, 320, -120},
    { -784, 328, -88},
    { -848, 336, -144},
    // 66 seconds
    { -1288, 376, -120},
    { -1504, 480, -8},
    { -1376, 544, -144},
    { -904, 656, -208},
    { -728, 568, -256},
    { -624, 312, -128},
    { -584, 200, -96},
    { -488, 280, -144},
    { -512, 336, -152},
    { -624, 432, -200},
    { -760, 424, -144},
    { -792, 392, -144},
    { -752, 480, -216},
    { -736, 480, -240},
    { -944, 536, -320},
    { -960, 416, -136},
    { -1320, 568, -272},
    { -1336, 616, -176},
    { -1192, 552, -128},
    { -1232, 528, -40},
    { -1104, 456, -8},
    { -888, 368, 40},
    { -696, 360, 8},
    { -616, 344, -8},
    { -592, 264, 64},
    // 67 seconds
    { -544, 208, 88},
    { -520, 248, 64},
    { -496, 232, 72},
    { -504, 272, 32},
    { -784, 424, 56},
    { -816, 456, 24},
    { -984, 488, -48},
    { -960, 496, -96},
    { -1088, 504, -112},
    { -872, 568, -240},
    { -872, 552, -272},
    { -840, 584, -312},
    { -744, 528, -288},
    { -536, 480, -224},
    { -472, 504, -256},
    { -528, 456, -200},
    { -568, 384, -120},
    { -648, 424, -88},
    { -664, 464, -80},
    { -608, 456, -24},
    { -928, 560, -128},
    { -1080, 560, -80},
    { -1176, 456, 0},
    { -1424, 728, -272},
    { -1152, 640, -128},
    // 68 seconds
    { -968, 416, -64},
    { -1080, 528, -120},
    { -864, 352, 8},
    { -744, 368, -40},
    { -664, 360, -48},
    { -584, 256, 48},
    { -536, 208, 72},
    { -496, 240, 64},
    { -544, 232, 104},
    { -552, 272, 64},
    { -560, 320, 64},
    { -904, 368, 16},
    { -1016, 472, -72},
    { -1168, 416, 24},
    { -1408, 360, 56},
    { -1312, 488, -176},
    { -952, 488, -184},
    { -760, 560, -304},
    { -576, 424, -304},
    { -480, 264, -192},
    { -432, 288, -168},
    { -512, 360, -200},
    { -608, 400, -192},
    { -640, 360, -104},
    { -688, 352, -80},
    // 69 seconds
    { -664, 440, -120},
    { -680, 424, -104},
    { -824, 480, -144},
    { -904, 464, -88},
    { -1016, 464, -72},
    { -1416, 600, -168},
    { -1432, 512, -48},
    { -1200, 456, -48},
    { -1184, 472, -48},
    { -912, 352, 40},
    { -728, 296, 24},
    { -600, 320, 8},
    { -576, 280, 32},
    { -552, 248, 72},
    { -592, 240, 72},
    { -624, 256, 88},
    { -600, 280, 88},
    { -640, 304, 96},
    { -688, 328, 80},
    { -752, 368, 8},
    { -864, 400, -56},
    { -832, 344, -88},
    { -1120, 320, -96},
    { -1608, 384, -152},
    { -1248, 344, -120},
    // 70 seconds
    { -840, 472, -296},
    { -832, 768, -648},
    { -600, 352, -400},
    { -472, 152, -128},
    { -480, 440, -248},
    { -552, 576, -224},
    { -664, 568, -160},
    { -664, 576, -136},
    { -728, 592, -152},
    { -728, 656, -88},
    { -728, 592, -16},
    { -680, 704, -72},
    { -632, 1048, -64},
    { -696, 976, 56},
    { -960, 1368, -80},
    { -1432, 1768, -416},
    { -976, 1344, 32},
    { -744, 1256, -48},
    { -632, 456, -144},
    { -552, 432, -192},
    { -440, 304, -504},
    { -328, 168, -480},
    { -288, 16, -520},
    { -232, -16, -640},
    { -176, -176, -624},
    // 71 seconds
    { -128, -184, -696},
    { -104, -336, -800},
    { -120, -296, -888},
    { -88, -336, -864},
    { -80, -232, -896},
    { -48, -328, -840},
    { -56, -408, -848},
    { -64, -368, -840},
    { -64, -400, -880},
    { -56, -408, -856},
    { -16, -400, -848},
    { -8, -408, -832},
    { -32, -392, -864},
    { -24, -400, -864},
    { -48, -448, -864},
    { -16, -424, -888},
    { -32, -440, -864},
    { -48, -416, -880},
    { -48, -424, -856},
    { -32, -440, -856},
    { -24, -464, -832},
    { -32, -432, -848},
    { -48, -432, -872},
    { -56, -440, -856},
    { -32, -448, -856},
    // 72 seconds
    { -40, -432, -840},
    { -32, -416, -840},
    { -24, -424, -848},
    { -16, -432, -856},
    { -24, -432, -848},
    { -16, -424, -856},
    { -32, -448, -856},
    { -24, -448, -864},
    { -16, -432, -856},
    { -24, -432, -872},
    { -24, -448, -848},
    { -16, -432, -864},
    { -48, -424, -880},
    { -48, -416, -896},
    { -24, -440, -824},
    { 32, -440, -824},
    { 16, -440, -848},
    { -8, -440, -856},
    { -24, -392, -888},
    { 0, -416, -840},
    { 48, -392, -840},
    { 88, -392, -864},
    { 72, -408, -872},
    { -48, -376, -936},
    { -64, -376, -904},
    // 73 seconds
    { -56, -376, -904},
    { 0, -400, -856},
    { 32, -368, -872},
    { -8, -352, -936},
    { -56, -392, -904},
    { -96, -376, -928},
    { -80, -408, -864},
    { -88, -392, -880},
    { -80, -384, -840},
    { 16, -376, -808},
    { 64, -296, -856},
    { 120, -304, -864},
    { 112, -248, -976},
    { 80, -280, -968},
    { 48, -264, -984},
    { 88, -272, -960},
    { 32, -304, -976},
    { 8, -304, -936},
    { 0, -312, -920},
    { 0, -288, -904},
    { -16, -256, -912},
    { -40, -256, -936},
    { -128, -240, -984},
    { -96, -288, -896},
    { -32, -304, -896},
    // 74 seconds
    { -16, -328, -872},
    { -32, -336, -864},
    { 8, -328, -848},
    { 40, -280, -904},
    { 8, -320, -888},
    { -8, -288, -912},
    { 8, -280, -928},
    { 8, -272, -944},
    { 32, -288, -920},
    { 88, -288, -904},
    { 56, -288, -904},
    { -24, -320, -880},
    { -24, -304, -848},
    { 0, -296, -816},
    { 24, -296, -816},
    { 32, -256, -880},
    { -64, -384, -920},
    { -160, -344, -1016},
    { -232, -336, -1032},
    { -200, -344, -976},
    { -136, -360, -896},
    { -96, -408, -832},
    { -120, -408, -800},
    { -112, -472, -784},
    { -160, -368, -928},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:50:49 local
AccelRawData *activity_sample_walk_100_pbl_25655_6(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25655_6
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -72, -520, -880},
    { -128, -448, -824},
    { -104, -488, -800},
    { -80, -512, -768},
    { -136, -608, -768},
    { -104, -576, -736},
    { -160, -592, -848},
    { -192, -600, -752},
    { -144, -536, -704},
    { -128, -544, -664},
    { -192, -608, -696},
    { -144, -600, -776},
    { -104, -600, -776},
    { -104, -640, -760},
    { 64, -536, -712},
    { -8, -608, -640},
    { -48, -592, -624},
    { 72, -600, -752},
    { 24, -600, -808},
    { -8, -664, -800},
    { 48, -648, -888},
    { -200, -560, -808},
    { -40, -592, -760},
    { 88, -568, -656},
    { 160, -568, -776},
    // 1 seconds
    { 152, -624, -784},
    { 32, -536, -720},
    { 192, -480, -888},
    { 224, -488, -816},
    { 160, -640, -720},
    { 64, -520, -744},
    { 152, -624, -856},
    { 128, -472, -864},
    { 120, -456, -872},
    { 40, -472, -776},
    { 184, -336, -872},
    { 176, -392, -800},
    { 264, -240, -776},
    { 184, -32, -1048},
    { 208, 16, -1008},
    { 320, -16, -952},
    { 280, 128, -1000},
    { 232, -8, -960},
    { 136, 80, -960},
    { 32, 208, -872},
    { 72, 312, -800},
    { 208, 408, -872},
    { 432, 328, -656},
    { 632, 544, -656},
    { 744, 760, -728},
    // 2 seconds
    { 880, 752, -848},
    { 656, 544, -592},
    { 424, 536, -248},
    { 344, 1008, -720},
    { 336, 856, -536},
    { 416, 320, -496},
    { 344, 616, -432},
    { 496, 624, -624},
    { 408, 616, -464},
    { 400, 808, -632},
    { 432, 600, -496},
    { 424, 656, -712},
    { 440, 496, -688},
    { 512, 640, -616},
    { 504, 624, -520},
    { 432, 584, -448},
    { 368, 640, -504},
    { 408, 1016, -320},
    { 440, 784, -408},
    { 416, 688, -200},
    { 448, 1048, -384},
    { 440, 784, -360},
    { 408, 800, -168},
    { 400, 808, -136},
    { 384, 952, -200},
    // 3 seconds
    { 400, 1024, -200},
    { 400, 872, -136},
    { 368, 904, -232},
    { 312, 936, -328},
    { 328, 872, -536},
    { 392, 848, -440},
    { 416, 848, -400},
    { 352, 704, -360},
    { 376, 856, -288},
    { 344, 720, -264},
    { 376, 648, -440},
    { 384, 936, -576},
    { 408, 816, -504},
    { 392, 720, -440},
    { 384, 784, -312},
    { 384, 864, -400},
    { 392, 792, -440},
    { 400, 832, -336},
    { 400, 880, -376},
    { 400, 848, -392},
    { 408, 784, -352},
    { 392, 840, -328},
    { 416, 832, -328},
    { 408, 792, -352},
    { 384, 816, -320},
    // 4 seconds
    { 368, 856, -344},
    { 400, 832, -440},
    { 416, 728, -408},
    { 448, 984, -392},
    { 520, 704, -440},
    { 448, 704, -376},
    { 384, 736, -256},
    { 256, 920, -392},
    { 152, 968, 184},
    { 184, 1080, 624},
    { 248, 976, 704},
    { 208, 1256, 520},
    { 152, 720, 360},
    { 296, 896, -120},
    { 456, 1112, -240},
    { 344, 1008, -112},
    { 472, 456, -264},
    { 408, 640, -288},
    { 304, 896, -608},
    { 352, 816, -328},
    { 320, 712, -336},
    { 344, 800, -464},
    { 408, 816, -384},
    { 344, 896, -240},
    { 304, 1008, -256},
    // 5 seconds
    { 328, 920, -304},
    { 320, 736, -248},
    { 280, 880, -200},
    { 304, 1040, -256},
    { 432, 824, -384},
    { 512, 704, -272},
    { 424, 984, -328},
    { 448, 720, -432},
    { 456, 800, -488},
    { 424, 584, -360},
    { 344, 760, -504},
    { 400, 792, -568},
    { 408, 720, -480},
    { 384, 712, -392},
    { 440, 832, -376},
    { 432, 752, -440},
    { 408, 720, -408},
    { 432, 792, -384},
    { 464, 856, -416},
    { 432, 768, -392},
    { 408, 784, -352},
    { 416, 864, -368},
    { 440, 792, -312},
    { 392, 808, -336},
    { 416, 936, -360},
    // 6 seconds
    { 408, 856, -312},
    { 384, 768, -320},
    { 384, 864, -264},
    { 376, 888, -360},
    { 368, 872, -360},
    { 360, 792, -264},
    { 400, 816, -376},
    { 424, 800, -256},
    { 384, 904, -152},
    { 440, 872, -176},
    { 376, 912, -320},
    { 352, 792, -520},
    { 288, 816, -520},
    { 312, 784, -544},
    { 344, 832, -744},
    { 760, 744, -896},
    { 784, 848, -1128},
    { 632, 592, -664},
    { 424, 784, -416},
    { 320, 776, -288},
    { 120, 584, -240},
    { 80, 584, -256},
    { 152, 536, -280},
    { 288, 552, -608},
    { 336, 592, -784},
    // 7 seconds
    { 488, 600, -632},
    { 408, 160, -696},
    { 352, 176, -1032},
    { 376, 320, -1056},
    { 360, 224, -968},
    { 336, 208, -976},
    { 296, 264, -944},
    { 288, 232, -912},
    { 288, 216, -896},
    { 320, 224, -912},
    { 288, 248, -848},
    { 296, 224, -912},
    { 304, 192, -888},
    { 280, 248, -888},
    { 272, 280, -904},
    { 280, 192, -888},
    { 264, 224, -872},
    { 272, 232, -880},
    { 280, 200, -896},
    { 288, 232, -888},
    { 288, 184, -864},
    { 288, 280, -928},
    { 288, 232, -920},
    { 280, 200, -896},
    { 304, 248, -904},
    // 8 seconds
    { 368, 264, -960},
    { 464, 320, -992},
    { 440, 512, -1024},
    { 440, 552, -992},
    { 288, 384, -784},
    { 256, 288, -656},
    { 208, 352, -672},
    { 208, 288, -632},
    { 312, 256, -608},
    { 376, 304, -680},
    { 352, 408, -896},
    { 368, 320, -936},
    { 352, 176, -992},
    { 320, 184, -1016},
    { 320, 152, -928},
    { 296, -24, -936},
    { 296, -80, -912},
    { 264, -112, -912},
    { 216, -120, -1016},
    { 160, -200, -944},
    { 120, -192, -960},
    { 120, -248, -928},
    { 80, -272, -896},
    { 72, -264, -912},
    { 48, -336, -872},
    // 9 seconds
    { 24, -312, -880},
    { 24, -352, -848},
    { 24, -336, -872},
    { 40, -320, -896},
    { 48, -328, -920},
    { 72, -336, -880},
    { 72, -304, -896},
    { 80, -272, -880},
    { 88, -256, -896},
    { 24, -232, -960},
    { -24, -288, -928},
    { -32, -272, -952},
    { 16, -320, -904},
    { 24, -312, -976},
    { -24, -304, -992},
    { -56, -320, -936},
    { -40, -352, -864},
    { -8, -328, -792},
    { 64, -296, -776},
    { 72, -264, -816},
    { 40, -240, -864},
    { 80, -248, -896},
    { 88, -240, -904},
    { 80, -240, -904},
    { 72, -224, -912},
    // 10 seconds
    { 56, -200, -920},
    { 40, -200, -920},
    { 40, -168, -912},
    { 112, 48, -1352},
    { -96, 184, -1392},
    { -216, 304, -1312},
    { -72, 216, -1336},
    { -72, 120, -1024},
    { 8, 48, -808},
    { 112, 48, -848},
    { 112, 48, -744},
    { 112, 8, -712},
    { 152, 0, -712},
    { 184, -8, -680},
    { 136, -8, -800},
    { 152, -24, -824},
    { 96, -16, -896},
    { 72, -40, -912},
    { 72, -8, -984},
    { 56, -24, -1144},
    { -8, 40, -1248},
    { -320, 168, -1336},
    { -336, 224, -1184},
    { -224, 120, -904},
    { -80, -56, -664},
    // 11 seconds
    { -80, 72, -696},
    { -32, 56, -640},
    { -24, -24, -528},
    { -88, 96, -544},
    { -160, 8, -680},
    { -168, 184, -776},
    { -168, 328, -1040},
    { 32, 208, -1016},
    { 24, 376, -1240},
    { -24, 200, -1088},
    { 24, 368, -1216},
    { -216, 520, -1424},
    { -360, 512, -1208},
    { -240, 608, -1112},
    { -176, 400, -872},
    { -144, 336, -648},
    { -128, 280, -544},
    { -40, 184, -496},
    { -24, 224, -536},
    { -72, 192, -528},
    { -96, 160, -584},
    { -88, 136, -568},
    { -144, 256, -728},
    { -320, 256, -840},
    { -568, 488, -1096},
    // 12 seconds
    { -680, 488, -1248},
    { -752, 552, -1256},
    { -512, 440, -1008},
    { -376, 304, -832},
    { -304, 184, -664},
    { -184, 40, -488},
    { -96, 112, -464},
    { -112, 64, -416},
    { -200, 208, -560},
    { -304, 304, -656},
    { -304, 264, -664},
    { -264, 528, -728},
    { -184, 544, -880},
    { -280, 520, -864},
    { -416, 760, -1152},
    { -736, 864, -1128},
    { -720, 760, -896},
    { -496, 896, -864},
    { -504, 496, -608},
    { -440, 376, -464},
    { -336, 328, -376},
    { -208, 192, -240},
    { -144, 16, -128},
    { -216, 48, -96},
    { -320, 168, -128},
    // 13 seconds
    { -440, 248, -120},
    { -680, 248, -112},
    { -1256, 320, 144},
    { -1704, 536, 400},
    { -1768, 720, 352},
    { -1720, 960, -240},
    { -1216, 1024, -208},
    { -880, 616, -16},
    { -672, 416, -24},
    { -472, 408, -48},
    { -344, 336, -48},
    { -344, 336, -64},
    { -504, 248, -24},
    { -640, 288, 24},
    { -728, 312, 32},
    { -736, 368, 16},
    { -792, 456, -128},
    { -904, 384, -48},
    { -904, 448, -88},
    { -1280, 528, -168},
    { -1512, 680, -184},
    { -1184, 528, -8},
    { -1192, 608, -120},
    { -960, 496, 48},
    { -584, 304, 32},
    // 14 seconds
    { -472, 368, -8},
    { -480, 336, 24},
    { -456, 288, 56},
    { -488, 344, 16},
    { -496, 328, 80},
    { -480, 320, 112},
    { -664, 448, -8},
    { -776, 528, -64},
    { -872, 512, -120},
    { -1128, 440, 0},
    { -1288, 576, -208},
    { -1064, 584, -248},
    { -888, 608, -160},
    { -656, 640, -320},
    { -536, 456, -216},
    { -480, 408, -152},
    { -560, 384, -168},
    { -624, 368, -168},
    { -648, 296, -104},
    { -568, 336, -104},
    { -544, 384, -112},
    { -712, 464, -160},
    { -880, 488, -152},
    { -1112, 464, -24},
    { -1544, 592, -176},
    // 15 seconds
    { -1416, 712, -256},
    { -960, 520, 32},
    { -1024, 552, -96},
    { -800, 392, 16},
    { -528, 360, -16},
    { -472, 480, -128},
    { -560, 480, 0},
    { -592, 392, 56},
    { -584, 376, 48},
    { -512, 376, 80},
    { -464, 416, 24},
    { -560, 392, 24},
    { -680, 432, -8},
    { -736, 400, -56},
    { -1104, 440, -72},
    { -1264, 416, 56},
    { -1312, 552, -168},
    { -968, 520, -192},
    { -776, 520, -312},
    { -600, 352, -264},
    { -424, 272, -160},
    { -408, 344, -160},
    { -528, 376, -128},
    { -672, 392, -48},
    { -816, 424, -24},
    // 16 seconds
    { -744, 472, -32},
    { -608, 440, -64},
    { -824, 512, -176},
    { -936, 504, -104},
    { -1256, 504, -48},
    { -1456, 648, -144},
    { -1160, 624, -80},
    { -1000, 584, -152},
    { -992, 512, -80},
    { -760, 392, 24},
    { -584, 360, -8},
    { -496, 392, -40},
    { -496, 296, 56},
    { -552, 240, 96},
    { -568, 264, 104},
    { -568, 280, 88},
    { -552, 312, 72},
    { -752, 336, 48},
    { -1048, 368, 40},
    { -1048, 360, -16},
    { -1416, 328, 48},
    { -1456, 504, -48},
    { -864, 576, -272},
    { -752, 576, -240},
    { -624, 480, -176},
    // 17 seconds
    { -440, 360, -144},
    { -352, 400, -88},
    { -416, 440, -104},
    { -584, 480, -120},
    { -688, 432, -32},
    { -776, 400, -8},
    { -672, 440, -24},
    { -864, 504, -104},
    { -1064, 584, -120},
    { -1344, 464, -32},
    { -1648, 616, -168},
    { -896, 504, 16},
    { -752, 440, -48},
    { -912, 456, -16},
    { -704, 368, 80},
    { -472, 328, 64},
    { -568, 352, 64},
    { -632, 328, 104},
    { -664, 288, 136},
    { -640, 288, 104},
    { -648, 320, 40},
    { -800, 312, 64},
    { -1120, 280, 120},
    { -1088, 384, -32},
    { -1232, 352, -32},
    // 18 seconds
    { -1248, 456, -8},
    { -640, 584, -360},
    { -784, 448, -288},
    { -712, 376, -184},
    { -464, 192, -160},
    { -376, 328, -152},
    { -448, 376, -128},
    { -552, 360, -40},
    { -696, 368, 0},
    { -696, 408, 8},
    { -624, 416, 8},
    { -824, 552, -120},
    { -984, 544, -56},
    { -1688, 624, -128},
    { -1224, 640, -104},
    { -1128, 560, -112},
    { -1216, 672, -136},
    { -1072, 424, 24},
    { -784, 360, 24},
    { -520, 360, 0},
    { -520, 352, -16},
    { -520, 304, 40},
    { -584, 296, 88},
    { -600, 264, 120},
    { -536, 288, 120},
    // 19 seconds
    { -584, 304, 96},
    { -760, 344, 80},
    { -928, 376, 24},
    { -1128, 384, 40},
    { -1408, 512, -56},
    { -1152, 672, -248},
    { -888, 560, -224},
    { -696, 560, -160},
    { -584, 424, -160},
    { -488, 456, -136},
    { -464, 408, -120},
    { -480, 400, -128},
    { -544, 368, -72},
    { -624, 400, -48},
    { -648, 416, 0},
    { -824, 480, -64},
    { -1128, 600, -104},
    { -1472, 512, -8},
    { -1632, 624, -168},
    { -944, 424, 80},
    { -936, 624, -200},
    { -1056, 528, -24},
    { -784, 280, 152},
    { -512, 344, 40},
    { -496, 352, 16},
    // 20 seconds
    { -480, 272, 112},
    { -488, 200, 152},
    { -512, 216, 120},
    { -568, 280, 80},
    { -696, 280, 80},
    { -1064, 352, 64},
    { -976, 392, -16},
    { -1440, 416, 16},
    { -1384, 544, -88},
    { -928, 504, -216},
    { -976, 496, -224},
    { -736, 448, -184},
    { -528, 272, -88},
    { -368, 368, -136},
    { -376, 432, -216},
    { -424, 320, -104},
    { -608, 312, -80},
    { -688, 352, -48},
    { -680, 384, -24},
    { -880, 456, -80},
    { -1048, 496, -48},
    { -1376, 432, 8},
    { -1312, 616, -176},
    { -1184, 568, -64},
    { -1144, 536, -40},
    // 21 seconds
    { -1072, 528, -8},
    { -712, 352, 56},
    { -488, 392, -56},
    { -496, 368, -32},
    { -472, 288, 40},
    { -496, 208, 88},
    { -528, 208, 88},
    { -544, 240, 72},
    { -648, 240, 88},
    { -952, 304, 72},
    { -1000, 368, 48},
    { -1352, 384, 40},
    { -1632, 568, -112},
    { -1096, 528, -120},
    { -928, 472, -232},
    { -752, 584, -320},
    { -464, 256, -200},
    { -280, 264, -184},
    { -304, 320, -232},
    { -416, 368, -192},
    { -600, 336, -128},
    { -752, 336, -88},
    { -792, 368, -56},
    { -1056, 488, -160},
    { -1120, 528, -112},
    // 22 seconds
    { -1360, 456, -64},
    { -1360, 640, -232},
    { -904, 488, -32},
    { -912, 568, -216},
    { -920, 432, -40},
    { -680, 264, 64},
    { -464, 336, -8},
    { -464, 376, -16},
    { -512, 344, 32},
    { -552, 312, 56},
    { -536, 312, 40},
    { -608, 336, 24},
    { -944, 384, 8},
    { -1080, 368, 32},
    { -1248, 368, 32},
    { -1232, 456, -120},
    { -936, 528, -248},
    { -896, 552, -376},
    { -832, 408, -224},
    { -616, 288, -192},
    { -432, 296, -160},
    { -400, 392, -208},
    { -504, 360, -200},
    { -568, 248, -120},
    { -704, 296, -152},
    // 23 seconds
    { -672, 328, -104},
    { -632, 368, -120},
    { -840, 456, -224},
    { -1024, 432, -120},
    { -1440, 432, -104},
    { -1344, 600, -240},
    { -1056, 544, -96},
    { -968, 656, -224},
    { -784, 520, -96},
    { -600, 400, -40},
    { -488, 424, -104},
    { -504, 384, -48},
    { -504, 320, 0},
    { -560, 288, 40},
    { -616, 272, 32},
    { -680, 296, 40},
    { -960, 320, 32},
    { -1312, 384, 0},
    { -1248, 360, -8},
    { -1224, 424, -192},
    { -1056, 504, -368},
    { -600, 264, -136},
    { -816, 256, -184},
    { -752, 352, -328},
    { -408, 320, -272},
    // 24 seconds
    { -296, 320, -272},
    { -432, 392, -272},
    { -520, 416, -136},
    { -480, 504, -96},
    { -520, 632, -208},
    { -448, 728, -264},
    { -784, 680, -264},
    { -784, 688, -200},
    { -792, 744, -312},
    { -1424, 816, -304},
    { -1216, 880, -376},
    { -880, 624, -296},
    { -888, 464, -248},
    { -560, 376, -200},
    { -480, 376, -240},
    { -512, 336, -168},
    { -632, 344, -112},
    { -720, 256, 24},
    { -744, 248, 128},
    { -552, 312, 120},
    { -640, 336, -8},
    { -744, 408, -96},
    { -848, 384, -72},
    { -1024, 288, 8},
    { -1256, 384, -48},
    // 25 seconds
    { -1112, 496, -232},
    { -992, 640, -472},
    { -832, 568, -352},
    { -672, 408, -312},
    { -544, 400, -280},
    { -440, 456, -352},
    { -456, 424, -280},
    { -536, 384, -208},
    { -632, 424, -216},
    { -688, 456, -176},
    { -848, 488, -184},
    { -1048, 560, -176},
    { -1032, 520, -120},
    { -1376, 656, -304},
    { -1344, 688, -320},
    { -1096, 416, -104},
    { -1008, 464, -104},
    { -816, 416, -56},
    { -512, 336, -32},
    { -448, 312, -16},
    { -480, 352, -24},
    { -520, 288, 80},
    { -528, 248, 128},
    { -488, 296, 64},
    { -504, 328, 40},
    // 26 seconds
    { -768, 344, 32},
    { -984, 400, 16},
    { -1216, 368, 40},
    { -1416, 456, -24},
    { -1136, 592, -280},
    { -1208, 504, -328},
    { -880, 416, -200},
    { -480, 344, -224},
    { -360, 432, -264},
    { -456, 416, -232},
    { -552, 328, -128},
    { -688, 368, -72},
    { -720, 464, -64},
    { -712, 480, -120},
    { -792, 480, -96},
    { -992, 480, -64},
    { -1104, 472, -48},
    { -1496, 536, -152},
    { -1696, 520, -64},
    { -928, 424, -152},
    { -1200, 456, -120},
    { -824, 400, -8},
    { -480, 288, 16},
    { -416, 320, 16},
    { -384, 352, 48},
    // 27 seconds
    { -352, 352, 80},
    { -392, 368, 64},
    { -456, 384, 72},
    { -504, 392, 80},
    { -616, 408, 40},
    { -960, 440, 0},
    { -976, 424, -24},
    { -1096, 440, -48},
    { -1208, 496, -176},
    { -1192, 528, -160},
    { -984, 536, -232},
    { -792, 536, -232},
    { -600, 392, -184},
    { -440, 264, -128},
    { -376, 304, -144},
    { -408, 368, -136},
    { -512, 392, -144},
    { -632, 440, -160},
    { -624, 408, -112},
    { -760, 440, -136},
    { -1032, 512, -168},
    { -1152, 464, -64},
    { -1584, 616, -200},
    { -1264, 672, -160},
    { -1144, 480, -32},
    // 28 seconds
    { -1144, 624, -96},
    { -920, 448, 56},
    { -576, 392, -8},
    { -496, 408, -64},
    { -488, 304, 16},
    { -488, 232, 64},
    { -488, 208, 80},
    { -528, 240, 48},
    { -472, 256, 64},
    { -704, 280, 72},
    { -944, 344, 16},
    { -1208, 424, -32},
    { -1272, 360, -16},
    { -1384, 744, -432},
    { -1008, 632, -376},
    { -968, 328, -88},
    { -680, 360, -256},
    { -400, 328, -144},
    { -312, 344, -152},
    { -312, 312, -64},
    { -392, 376, -32},
    { -520, 432, -48},
    { -712, 504, -48},
    { -696, 592, -96},
    { -824, 664, -240},
    // 29 seconds
    { -912, 616, -224},
    { -1296, 680, -248},
    { -1392, 856, -240},
    { -1088, 848, -168},
    { -760, 864, -304},
    { -600, 728, -176},
    { -464, 712, -304},
    { -520, 856, -328},
    { -560, 656, -208},
    { -528, 568, -120},
    { -464, 488, -64},
    { -472, 456, -32},
    { -400, 456, -40},
    { -520, 408, 0},
    { -696, 456, -48},
    { -776, 176, -72},
    { -1128, 248, -192},
    { -1224, 504, -296},
    { -1120, 872, -720},
    { -1000, 592, -336},
    { -624, 544, -384},
    { -384, 456, -448},
    { -368, 360, -272},
    { -408, 480, -344},
    { -496, 592, -320},
    // 30 seconds
    { -632, 672, -344},
    { -592, 696, -336},
    { -616, 640, -280},
    { -752, 752, -496},
    { -944, 760, -408},
    { -1280, 848, -496},
    { -1176, 848, -368},
    { -1024, 672, -168},
    { -1000, 632, -216},
    { -856, 536, -88},
    { -600, 400, 40},
    { -472, 376, -16},
    { -440, 336, 0},
    { -448, 312, 80},
    { -472, 336, 80},
    { -432, 344, 96},
    { -400, 392, 48},
    { -664, 408, -112},
    { -848, 464, -48},
    { -1136, 456, 0},
    { -1448, 752, -232},
    { -1088, 824, -456},
    { -880, 688, -360},
    { -784, 464, -304},
    { -544, 288, -280},
    // 31 seconds
    { -352, 288, -248},
    { -336, 344, -304},
    { -408, 408, -264},
    { -560, 448, -160},
    { -680, 536, -184},
    { -648, 584, -192},
    { -672, 632, -200},
    { -880, 728, -344},
    { -1120, 728, -192},
    { -1392, 832, -320},
    { -1144, 848, -288},
    { -984, 608, -64},
    { -1016, 712, -272},
    { -920, 560, -144},
    { -664, 432, -32},
    { -536, 400, -48},
    { -544, 336, 0},
    { -512, 280, 64},
    { -488, 248, 88},
    { -472, 272, 88},
    { -520, 288, 112},
    { -736, 368, 16},
    { -888, 408, 32},
    { -1112, 408, -64},
    { -1272, 536, -144},
    // 32 seconds
    { -1224, 568, -264},
    { -1048, 688, -408},
    { -960, 432, -88},
    { -672, 512, -224},
    { -424, 424, -256},
    { -352, 456, -208},
    { -416, 536, -168},
    { -456, 632, -136},
    { -512, 656, -120},
    { -488, 680, -96},
    { -520, 648, -80},
    { -840, 720, -176},
    { -992, 696, -88},
    { -1312, 672, -72},
    { -1344, 824, -168},
    { -1144, 736, 192},
    { -992, 656, 40},
    { -800, 752, 72},
    { -456, 536, 72},
    { -344, 600, -72},
    { -368, 448, 16},
    { -456, 368, 48},
    { -536, 288, 64},
    { -576, 248, 80},
    { -632, 224, 112},
    // 33 seconds
    { -864, 280, 56},
    { -960, 328, 32},
    { -1136, 360, -56},
    { -1336, 408, -128},
    { -1320, 536, -232},
    { -1016, 440, -376},
    { -824, 480, -336},
    { -496, 392, -232},
    { -416, 336, -128},
    { -440, 376, -136},
    { -504, 360, -72},
    { -560, 312, -16},
    { -632, 352, -64},
    { -568, 368, -24},
    { -760, 448, -128},
    { -984, 488, -136},
    { -1080, 408, 0},
    { -1392, 512, -176},
    { -1344, 608, -240},
    { -1192, 544, -192},
    { -1088, 488, -168},
    { -832, 416, -136},
    { -536, 440, -168},
    { -432, 376, -88},
    { -464, 352, -8},
    // 34 seconds
    { -496, 272, 72},
    { -520, 240, 112},
    { -568, 264, 104},
    { -672, 312, 64},
    { -976, 328, 112},
    { -1048, 352, 128},
    { -1328, 368, 64},
    { -1168, 488, 0},
    { -1184, 600, -392},
    { -976, 384, -112},
    { -704, 360, -160},
    { -552, 400, -232},
    { -352, 368, -192},
    { -344, 344, -216},
    { -432, 296, -112},
    { -576, 288, -88},
    { -632, 336, -64},
    { -632, 360, -32},
    { -856, 456, -104},
    { -1112, 568, -72},
    { -1656, 552, -32},
    { -1712, 784, -192},
    { -968, 400, 136},
    { -1032, 504, -128},
    { -944, 504, 8},
    // 35 seconds
    { -616, 384, 96},
    { -320, 400, 16},
    { -344, 408, 24},
    { -488, 344, 88},
    { -608, 320, 88},
    { -664, 272, 128},
    { -632, 296, 104},
    { -744, 360, 48},
    { -1024, 384, 8},
    { -1176, 352, 8},
    { -1304, 288, 24},
    { -1128, 448, -264},
    { -784, 456, -320},
    { -840, 288, -120},
    { -688, 328, -208},
    { -504, 368, -152},
    { -376, 472, -232},
    { -448, 464, -200},
    { -544, 344, -88},
    { -704, 344, -64},
    { -784, 376, -16},
    { -720, 392, 0},
    { -960, 456, -96},
    { -1112, 472, -24},
    { -1464, 416, -24},
    // 36 seconds
    { -1344, 544, -152},
    { -944, 440, -72},
    { -936, 496, -152},
    { -888, 360, -16},
    { -600, 328, 48},
    { -480, 352, 16},
    { -488, 336, 40},
    { -552, 296, 120},
    { -592, 280, 112},
    { -696, 296, 40},
    { -736, 312, 40},
    { -1056, 344, 32},
    { -1112, 368, 8},
    { -1320, 392, -16},
    { -1112, 328, 0},
    { -992, 424, -104},
    { -992, 472, -216},
    { -728, 400, -152},
    { -448, 272, -120},
    { -408, 272, -120},
    { -456, 296, -104},
    { -560, 256, -32},
    { -640, 272, -24},
    { -648, 320, -24},
    { -616, 344, -16},
    // 37 seconds
    { -768, 400, -88},
    { -992, 400, -72},
    { -1272, 408, -16},
    { -1464, 536, -160},
    { -1328, 608, -184},
    { -984, 480, -32},
    { -888, 488, -136},
    { -704, 392, -64},
    { -504, 256, -64},
    { -464, 304, -24},
    { -488, 320, -24},
    { -560, 296, 24},
    { -648, 256, 64},
    { -696, 280, 80},
    { -944, 328, 96},
    { -1136, 352, 160},
    { -936, 424, 0},
    { -1264, 360, 24},
    { -1152, 536, -112},
    { -920, 472, -272},
    { -888, 352, -160},
    { -664, 256, -136},
    { -448, 248, -112},
    { -392, 280, -88},
    { -424, 352, -112},
    // 38 seconds
    { -496, 368, -104},
    { -560, 320, -16},
    { -632, 336, -40},
    { -672, 320, 8},
    { -928, 408, -64},
    { -1088, 424, -64},
    { -1320, 448, -72},
    { -1424, 672, -288},
    { -1320, 552, -144},
    { -1128, 568, -160},
    { -1056, 456, -64},
    { -648, 456, -24},
    { -448, 504, -40},
    { -408, 440, -24},
    { -512, 344, 40},
    { -624, 304, 64},
    { -680, 280, 88},
    { -680, 280, 88},
    { -808, 280, 64},
    { -1008, 264, 80},
    { -824, 312, -40},
    { -1224, 264, 16},
    { -1192, 288, 32},
    { -1168, 376, -136},
    { -1096, 416, -152},
    // 39 seconds
    { -744, 416, -176},
    { -440, 296, -120},
    { -376, 352, -160},
    { -424, 432, -208},
    { -504, 384, -136},
    { -768, 376, -80},
    { -776, 440, -128},
    { -824, 440, -56},
    { -1080, 624, -224},
    { -1000, 472, 24},
    { -1400, 560, -184},
    { -1384, 672, -200},
    { -1464, 416, 0},
    { -1272, 400, 40},
    { -944, 408, 56},
    { -584, 440, -32},
    { -528, 384, 16},
    { -552, 272, 88},
    { -560, 176, 184},
    { -496, 152, 168},
    { -504, 184, 136},
    { -544, 256, 88},
    { -832, 256, 112},
    { -968, 304, 32},
    { -1264, 272, 112},
    // 40 seconds
    { -1472, 360, 0},
    { -1352, 608, -328},
    { -1184, 464, -104},
    { -880, 248, -144},
    { -624, 288, -224},
    { -440, 416, -224},
    { -424, 448, -240},
    { -416, 416, -160},
    { -480, 384, -136},
    { -664, 440, -224},
    { -728, 384, -32},
    { -952, 432, -112},
    { -1072, 528, -136},
    { -1424, 560, -192},
    { -1432, 632, -288},
    { -1400, 392, 16},
    { -1240, 376, 64},
    { -1144, 448, -8},
    { -888, 384, 64},
    { -608, 304, 88},
    { -552, 304, 40},
    { -536, 280, 64},
    { -512, 192, 112},
    { -488, 152, 104},
    { -472, 152, 88},
    // 41 seconds
    { -616, 192, 80},
    { -760, 248, 32},
    { -984, 320, -8},
    { -1320, 352, -8},
    { -1536, 592, -296},
    { -1336, 624, -384},
    { -1016, 464, -224},
    { -680, 320, -360},
    { -496, 368, -320},
    { -376, 448, -264},
    { -448, 480, -240},
    { -544, 448, -192},
    { -656, 392, -104},
    { -656, 368, -40},
    { -768, 456, -136},
    { -1048, 528, -184},
    { -1328, 496, -128},
    { -1768, 600, -288},
    { -1128, 408, -112},
    { -928, 304, -40},
    { -1016, 520, -240},
    { -1016, 1064, -296},
    { -616, -8, 272},
    { -528, 376, -104},
    { -576, 480, 8},
    // 42 seconds
    { -488, 216, 112},
    { -472, 232, 104},
    { -496, 232, 96},
    { -544, 280, 80},
    { -888, 320, 72},
    { -1048, 376, 0},
    { -1328, 320, 48},
    { -1512, 376, -128},
    { -1032, 552, -368},
    { -968, 440, -224},
    { -856, 480, -280},
    { -584, 376, -312},
    { -464, 456, -176},
    { -416, 608, -224},
    { -440, 544, -144},
    { -496, 664, -160},
    { -584, 776, -72},
    { -576, 816, 0},
    { -632, 1064, -48},
    { -704, 1224, -88},
    { -808, 1376, 72},
    { -776, 1744, 32},
    { -840, 1824, 32},
    { -680, 1664, 184},
    { -496, 1432, 88},
    // 43 seconds
    { -192, 1104, 0},
    { -96, 544, 72},
    { 120, 216, 232},
    { 176, 280, 64},
    { 352, 80, 48},
    { 448, 80, 96},
    { 616, -88, 40},
    { 800, 80, -152},
    { 848, -144, -168},
    { 1048, -136, -160},
    { 1272, -24, -440},
    { 1184, 208, -544},
    { 1008, 368, -608},
    { 976, 464, -408},
    { 832, 192, -448},
    { 784, -272, -224},
    { 736, -112, -216},
    { 720, -32, -232},
    { 720, -32, -320},
    { 808, -176, -248},
    { 848, -288, -272},
    { 1056, -256, -360},
    { 1192, -248, -432},
    { 1504, -464, -256},
    { 1664, -400, -192},
    // 44 seconds
    { 1600, -8, -160},
    { 1432, 32, -56},
    { 1128, 72, -128},
    { 880, -144, -40},
    { 696, -224, -8},
    { 608, -200, 24},
    { 592, -240, 24},
    { 656, -160, -200},
    { 744, -240, -216},
    { 888, -352, -80},
    { 1008, -400, -184},
    { 1072, -528, -232},
    { 1264, -456, -392},
    { 1288, -464, -296},
    { 1400, -192, -384},
    { 1400, -56, -712},
    { 1112, -144, -640},
    { 880, -176, -160},
    { 760, -88, -240},
    { 576, -152, -152},
    { 456, -240, -64},
    { 624, -256, -216},
    { 744, -416, -184},
    { 848, -520, -136},
    { 912, -552, -248},
    // 45 seconds
    { 1080, -560, -240},
    { 1096, -584, -232},
    { 1392, -576, -312},
    { 1408, -616, -136},
    { 1432, -368, 0},
    { 1440, -16, 128},
    { 1240, -64, -32},
    { 1136, -232, -64},
    { 888, -384, -160},
    { 688, -328, -104},
    { 568, -192, -16},
    { 576, -184, 32},
    { 552, -288, -80},
    { 624, -456, 168},
    { 552, -480, -80},
    { 800, -368, -352},
    { 584, -624, 8},
    { 784, -360, -48},
    { 760, 80, 64},
    { 0, 272, -144},
    { -384, 664, -432},
    { -520, 1296, -920},
    { -456, 792, -520},
    { -752, 984, -472},
    { -736, 664, -360},
    // 46 seconds
    { -1400, 632, -360},
    { -1720, 856, -376},
    { -1736, 512, 304},
    { -824, 664, -176},
    { -976, 808, -384},
    { -1056, 744, -440},
    { -1008, 456, -424},
    { -1528, 272, -360},
    { -1320, 296, -336},
    { -1320, 328, -112},
    { -1200, 480, -144},
    { -920, 352, -104},
    { -592, 336, -24},
    { -536, 304, -40},
    { -584, 360, -56},
    { -512, 256, 96},
    { -480, 160, 168},
    { -520, 128, 72},
    { -688, 168, 8},
    { -920, 184, -16},
    { -848, 160, 96},
    { -1056, 176, 144},
    { -1192, 432, -144},
    { -1184, 648, -432},
    { -1136, 512, -280},
    // 47 seconds
    { -936, 376, -144},
    { -752, 272, -216},
    { -544, 392, -192},
    { -424, 464, -248},
    { -456, 464, -304},
    { -456, 376, -216},
    { -576, 368, -280},
    { -640, 360, -224},
    { -768, 384, -216},
    { -1064, 488, -288},
    { -1168, 424, -200},
    { -1552, 432, -232},
    { -1288, 560, -320},
    { -1064, 424, -136},
    { -1144, 512, -192},
    { -992, 400, -64},
    { -760, 328, 16},
    { -488, 360, -24},
    { -432, 352, -32},
    { -400, 304, 32},
    { -472, 248, 64},
    { -544, 248, 104},
    { -552, 224, 128},
    { -792, 256, 72},
    { -1040, 368, 104},
    // 48 seconds
    { -1248, 456, -56},
    { -1296, 344, -16},
    { -1208, 464, -232},
    { -968, 480, -336},
    { -1016, 312, -216},
    { -712, 152, -232},
    { -456, 192, -216},
    { -392, 344, -304},
    { -424, 360, -280},
    { -512, 272, -136},
    { -680, 288, -88},
    { -680, 344, -40},
    { -672, 368, -72},
    { -968, 448, -168},
    { -1112, 392, -72},
    { -1552, 400, -80},
    { -1488, 560, -232},
    { -1104, 544, -232},
    { -976, 536, -256},
    { -872, 392, -160},
    { -688, 312, -96},
    { -472, 344, -88},
    { -368, 288, -80},
    { -432, 392, -104},
    { -544, 400, -56},
    // 49 seconds
    { -664, 328, 32},
    { -736, 408, 16},
    { -832, 352, 80},
    { -1048, 368, 80},
    { -920, 384, 8},
    { -1224, 392, -40},
    { -1216, 432, -16},
    { -848, 456, -312},
    { -896, 520, -432},
    { -768, 312, -376},
    { -592, 72, -192},
    { -416, 152, -208},
    { -408, 224, -264},
    { -496, 264, -208},
    { -608, 224, -72},
    { -752, 296, -88},
    { -728, 336, -48},
    { -744, 376, -96},
    { -960, 528, -256},
    { -1008, 424, -104},
    { -1424, 456, -160},
    { -1216, 632, -320},
    { -1184, 480, -272},
    { -1168, 616, -288},
    { -1024, 432, -112},
    // 50 seconds
    { -672, 384, -56},
    { -432, 400, -88},
    { -432, 344, -24},
    { -496, 288, 48},
    { -512, 272, 96},
    { -624, 240, 104},
    { -664, 272, 88},
    { -880, 280, 104},
    { -1104, 296, 104},
    { -1152, 360, 8},
    { -1232, 400, -72},
    { -1104, 512, -216},
    { -928, 624, -592},
    { -1016, 448, -288},
    { -760, 96, -128},
    { -472, 176, -176},
    { -360, 280, -248},
    { -368, 328, -240},
    { -456, 320, -160},
    { -552, 288, -48},
    { -624, 320, -8},
    { -664, 384, -48},
    { -768, 440, -104},
    { -992, 480, -144},
    { -1176, 448, -80},
    // 51 seconds
    { -1552, 600, -272},
    { -1328, 552, -168},
    { -1144, 584, -280},
    { -1168, 608, -328},
    { -832, 376, -104},
    { -568, 400, -104},
    { -448, 344, -24},
    { -440, 368, -48},
    { -496, 336, 32},
    { -512, 208, 136},
    { -592, 176, 144},
    { -680, 192, 136},
    { -912, 208, 184},
    { -1048, 328, 136},
    { -1176, 456, -80},
    { -1344, 472, -72},
    { -1320, 552, -144},
    { -800, 536, -368},
    { -720, 432, -216},
    { -608, 104, -184},
    { -416, 72, -224},
    { -360, 128, -176},
    { -464, 240, -144},
    { -664, 336, -120},
    { -832, 392, -88},
    // 52 seconds
    { -824, 416, -88},
    { -720, 368, -48},
    { -888, 504, -312},
    { -928, 424, -144},
    { -1464, 440, -248},
    { -1488, 624, -328},
    { -1280, 496, -72},
    { -1128, 488, -88},
    { -992, 400, -56},
    { -592, 360, -32},
    { -448, 352, -48},
    { -448, 320, -8},
    { -424, 240, 88},
    { -416, 208, 120},
    { -520, 208, 112},
    { -568, 280, 96},
    { -832, 312, 104},
    { -1088, 320, 136},
    { -1200, 432, -72},
    { -1480, 352, 0},
    { -1240, 560, -200},
    { -1104, 648, -520},
    { -976, 536, -328},
    { -728, 264, -288},
    { -488, 192, -192},
    // 53 seconds
    { -344, 232, -208},
    { -384, 312, -232},
    { -408, 296, -192},
    { -512, 280, -120},
    { -632, 336, -152},
    { -736, 336, -80},
    { -816, 384, -88},
    { -888, 432, -72},
    { -1352, 528, -144},
    { -1408, 672, -240},
    { -1240, 632, -208},
    { -1016, 568, -96},
    { -1024, 536, -136},
    { -808, 424, -40},
    { -592, 408, -96},
    { -496, 400, -104},
    { -464, 352, -72},
    { -464, 296, -24},
    { -504, 264, 24},
    { -568, 272, 40},
    { -768, 304, 48},
    { -1080, 304, 96},
    { -1160, 312, 168},
    { -1208, 320, 88},
    { -1136, 344, 32},
    // 54 seconds
    { -1056, 496, -160},
    { -824, 464, -224},
    { -848, 448, -280},
    { -680, 256, -192},
    { -512, 120, -208},
    { -448, 200, -240},
    { -504, 304, -216},
    { -616, 304, -136},
    { -728, 304, -104},
    { -760, 304, -64},
    { -728, 344, -72},
    { -912, 424, -128},
    { -1096, 384, -16},
    { -1488, 448, -80},
    { -1400, 528, -144},
    { -968, 440, -56},
    { -1024, 512, -224},
    { -960, 304, -56},
    { -688, 208, 200},
    { -336, 496, 16},
    { -384, 616, -104},
    { -560, 528, 8},
    { -704, 360, 104},
    { -816, 288, 136},
    { -824, 248, 184},
    // 55 seconds
    { -960, 232, 168},
    { -1080, 208, 112},
    { -1136, 224, 48},
    { -1272, 216, 32},
    { -952, 344, -168},
    { -976, 424, -304},
    { -960, 184, -184},
    { -784, 200, -176},
    { -528, 336, -272},
    { -440, 408, -264},
    { -480, 400, -168},
    { -552, 360, -128},
    { -624, 352, -56},
    { -640, 384, -48},
    { -736, 432, -56},
    { -1024, 496, -136},
    { -1152, 440, -56},
    { -1480, 448, -88},
    { -1608, 552, -256},
    { -992, 472, -72},
    { -920, 304, -168},
    { -992, 400, -192},
    { -792, 352, -56},
    { -592, 328, -72},
    { -504, 320, -48},
    // 56 seconds
    { -504, 296, 32},
    { -504, 256, 96},
    { -568, 264, 72},
    { -592, 256, 88},
    { -640, 256, 104},
    { -856, 280, 104},
    { -944, 288, 96},
    { -1088, 352, -16},
    { -1112, 312, 8},
    { -1328, 416, -120},
    { -1184, 472, -224},
    { -1032, 576, -432},
    { -728, 440, -368},
    { -496, 288, -200},
    { -392, 280, -168},
    { -376, 304, -144},
    { -416, 312, -112},
    { -560, 352, -112},
    { -648, 352, -80},
    { -688, 320, -8},
    { -872, 408, -104},
    { -1112, 472, -104},
    { -1400, 400, -16},
    { -1472, 568, -184},
    { -1224, 504, -40},
    // 57 seconds
    { -1040, 528, -88},
    { -1040, 536, -136},
    { -792, 384, -16},
    { -544, 368, -24},
    { -472, 384, -40},
    { -472, 304, 40},
    { -496, 240, 88},
    { -560, 240, 88},
    { -576, 248, 80},
    { -744, 272, 88},
    { -1048, 272, 120},
    { -1144, 288, 120},
    { -1240, 272, 32},
    { -1376, 416, -32},
    { -960, 560, -240},
    { -816, 512, -296},
    { -768, 440, -224},
    { -648, 280, -112},
    { -520, 312, -184},
    { -504, 216, -136},
    { -456, 184, -120},
    { -512, 248, -112},
    { -672, 336, -176},
    { -720, 352, -96},
    { -760, 296, -88},
    // 58 seconds
    { -1016, 376, -208},
    { -1144, 384, -104},
    { -1560, 448, -216},
    { -1320, 568, -280},
    { -952, 400, -48},
    { -1120, 528, -184},
    { -920, 440, -104},
    { -616, 360, -40},
    { -472, 376, -104},
    { -496, 320, -32},
    { -504, 264, 72},
    { -560, 248, 88},
    { -648, 256, 96},
    { -696, 280, 104},
    { -848, 264, 120},
    { -1032, 320, 48},
    { -1128, 352, -8},
    { -1224, 304, 24},
    { -1128, 416, -112},
    { -896, 536, -368},
    { -936, 488, -320},
    { -744, 328, -232},
    { -512, 216, -208},
    { -424, 272, -200},
    { -448, 312, -200},
    // 59 seconds
    { -496, 280, -136},
    { -608, 296, -136},
    { -648, 344, -136},
    { -696, 344, -120},
    { -968, 408, -184},
    { -1120, 400, -56},
    { -1512, 440, -72},
    { -1384, 656, -216},
    { -1016, 536, -40},
    { -1096, 568, -152},
    { -912, 416, 0},
    { -640, 384, -32},
    { -456, 424, -136},
    { -456, 368, -72},
    { -504, 248, 32},
    { -560, 216, 80},
    { -616, 264, 96},
    { -632, 304, 104},
    { -888, 352, 80},
    { -1048, 304, 152},
    { -1184, 400, 0},
    { -1232, 352, 8},
    { -1136, 432, -144},
    { -808, 496, -280},
    { -944, 384, -184},
    // 60 seconds
    // elapsed: 1 minutes
    { -800, 368, -264},
    { -528, 328, -216},
    { -424, 328, -208},
    { -456, 336, -224},
    { -488, 280, -136},
    { -616, 304, -152},
    { -640, 328, -104},
    { -648, 344, -72},
    { -912, 456, -168},
    { -1016, 464, -24},
    { -1528, 536, -112},
    { -1472, 648, -120},
    { -896, 512, -72},
    { -1000, 616, -224},
    { -952, 480, -88},
    { -816, 304, 0},
    { -552, 360, -40},
    { -504, 368, -56},
    { -472, 312, 0},
    { -488, 272, 40},
    { -600, 264, 64},
    { -656, 288, 80},
    { -752, 272, 120},
    { -992, 320, 80},
    { -1016, 360, -8},
    // 61 seconds
    { -1280, 304, 56},
    { -1376, 400, -40},
    { -880, 496, -288},
    { -848, 432, -232},
    { -784, 456, -336},
    { -560, 296, -216},
    { -472, 320, -240},
    { -480, 328, -176},
    { -544, 328, -160},
    { -616, 352, -168},
    { -632, 328, -112},
    { -624, 344, -88},
    { -760, 408, -136},
    { -952, 448, -144},
    { -1120, 392, 0},
    { -1480, 480, -64},
    { -1248, 592, -112},
    { -888, 528, -128},
    { -1136, 600, -192},
    { -952, 328, 32},
    { -712, 296, 0},
    { -536, 384, -96},
    { -552, 368, -80},
    { -512, 256, 16},
    { -536, 208, 64},
    // 62 seconds
    { -592, 248, 64},
    { -616, 288, 56},
    { -816, 320, 64},
    { -1024, 304, 88},
    { -1040, 416, -128},
    { -1136, 320, -16},
    { -1376, 448, -112},
    { -944, 552, -384},
    { -904, 416, -256},
    { -792, 360, -272},
    { -624, 264, -224},
    { -448, 272, -152},
    { -448, 320, -176},
    { -520, 344, -152},
    { -576, 304, -88},
    { -632, 312, -80},
    { -600, 320, -64},
    { -712, 328, -64},
    { -976, 400, -128},
    { -1248, 376, -8},
    { -1504, 424, -72},
    { -1368, 536, -152},
    { -1048, 504, -56},
    { -1136, 544, -152},
    { -880, 416, -56},
    // 63 seconds
    { -648, 400, -96},
    { -456, 400, -152},
    { -440, 344, -72},
    { -464, 256, 8},
    { -536, 240, 40},
    { -624, 280, 40},
    { -672, 280, 80},
    { -928, 272, 112},
    { -1200, 280, 144},
    { -1248, 360, 72},
    { -1320, 368, 16},
    { -992, 512, -208},
    { -752, 472, -296},
    { -912, 336, -208},
    { -760, 272, -168},
    { -504, 248, -160},
    { -424, 296, -152},
    { -520, 304, -144},
    { -560, 272, -80},
    { -648, 256, -64},
    { -648, 312, -88},
    { -632, 320, -56},
    { -736, 344, -104},
    { -960, 384, -144},
    { -1136, 360, 0},
    // 64 seconds
    { -1672, 472, -160},
    { -1312, 616, -200},
    { -984, 480, -88},
    { -1136, 584, -160},
    { -840, 392, -56},
    { -600, 376, -80},
    { -488, 440, -136},
    { -528, 352, -32},
    { -568, 248, 80},
    { -632, 272, 120},
    { -696, 312, 128},
    { -800, 360, 136},
    { -1064, 336, 176},
    { -1096, 304, 200},
    { -1248, 304, 120},
    { -1192, 320, 88},
    { -912, 312, -208},
    { -824, 208, -192},
    { -888, 104, -176},
    { -712, 16, -240},
    { -536, 192, -296},
    { -536, 312, -312},
    { -576, 336, -208},
    { -656, 296, -160},
    { -776, 336, -144},
    // 65 seconds
    { -752, 320, -24},
    { -656, 352, -104},
    { -872, 416, -184},
    { -1016, 392, -112},
    { -1360, 360, -48},
    { -1336, 472, -128},
    { -1072, 480, -64},
    { -1048, 528, -128},
    { -1056, 448, -56},
    { -752, 320, 32},
    { -520, 376, -56},
    { -480, 400, -80},
    { -496, 280, 16},
    { -568, 264, 40},
    { -600, 272, 80},
    { -640, 296, 96},
    { -760, 320, 88},
    { -1008, 336, 88},
    { -976, 352, 32},
    { -1304, 360, -40},
    { -1352, 392, -16},
    { -1008, 440, -288},
    { -704, 360, -184},
    { -784, 328, -256},
    { -720, 264, -216},
    // 66 seconds
    { -512, 200, -168},
    { -480, 256, -192},
    { -520, 304, -176},
    { -632, 320, -160},
    { -744, 304, -88},
    { -792, 328, -80},
    { -664, 352, -96},
    { -744, 408, -184},
    { -920, 416, -224},
    { -1216, 352, -48},
    { -1416, 472, -144},
    { -1184, 576, -160},
    { -848, 528, -152},
    { -1040, 528, -184},
    { -976, 312, 16},
    { -856, 272, 48},
    { -672, 336, 16},
    { -592, 344, 8},
    { -544, 312, 40},
    { -544, 256, 64},
    { -552, 240, 104},
    { -584, 272, 80},
    { -640, 264, 80},
    { -880, 288, 56},
    { -1000, 336, 16},
    // 67 seconds
    { -1024, 320, -40},
    { -1160, 344, -120},
    { -1488, 392, -88},
    { -1032, 424, -216},
    { -792, 408, -272},
    { -784, 440, -248},
    { -648, 264, -176},
    { -472, 216, -136},
    { -512, 288, -152},
    { -584, 360, -120},
    { -640, 344, -96},
    { -648, 344, -40},
    { -672, 440, -56},
    { -640, 664, -200},
    { -848, 720, -264},
    { -928, 584, -48},
    { -904, 560, -24},
    { -1288, 720, -104},
    { -1336, 736, -80},
    { -1192, 616, 0},
    { -1160, 528, 8},
    { -920, 408, 56},
    { -624, 328, 64},
    { -472, 328, 24},
    { -440, 288, 40},
    // 68 seconds
    { -400, 248, 72},
    { -432, 256, 40},
    { -488, 248, 40},
    { -504, 256, 40},
    { -632, 280, 40},
    { -944, 328, 24},
    { -928, 416, -104},
    { -1248, 272, 72},
    { -2000, 408, -8},
    { -1272, 544, -160},
    { -1136, 376, -208},
    { -760, 720, -560},
    { -552, 392, -376},
    { -584, 544, -368},
    { -560, 640, -304},
    { -680, 728, -248},
    { -784, 744, -128},
    { -808, 736, -96},
    { -824, 712, -184},
    { -824, 848, -336},
    { -712, 664, -360},
    { -608, 712, -408},
    { -528, 504, -352},
    { -448, 320, -528},
    { -400, 336, -528},
    // 69 seconds
    { -312, 168, -512},
    { -264, 168, -704},
    { -320, 56, -728},
    { -232, 256, -696},
    { -232, 88, -800},
    { -152, 24, -904},
    { -152, 16, -912},
    { -152, -48, -872},
    { -80, -128, -872},
    { -96, -152, -904},
    { -72, -208, -832},
    { -40, -176, -856},
    { -56, -240, -848},
    { -80, -280, -832},
    { -128, -200, -960},
    { -112, -336, -896},
    { -48, -280, -920},
    { -40, -352, -864},
    { -48, -376, -816},
    { -112, -288, -920},
    { -160, -296, -912},
    { -136, -360, -864},
    { -48, -376, -560},
    { -168, -368, -848},
    { -168, -384, -880},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:52:37 local
AccelRawData *activity_sample_walk_100_pbl_25655_7(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25655_7
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -120, -480, -792},
    { -176, -280, -872},
    { -232, -384, -800},
    { -152, -400, -904},
    { -160, -456, -832},
    { -224, -136, -840},
    { -432, -328, -808},
    { -296, -416, -864},
    { -328, -384, -864},
    { -248, -232, -960},
    { 56, -512, -944},
    { -192, -400, -856},
    { -176, -256, -832},
    { -184, -256, -856},
    { -128, -352, -816},
    { -72, -264, -832},
    { -72, -232, -840},
    { -80, -256, -832},
    { -120, -160, -888},
    { -144, -192, -880},
    { -120, -152, -936},
    { -120, -184, -936},
    { -112, -136, -960},
    { -144, -144, -952},
    { -160, -128, -928},
    // 1 seconds
    { -176, -120, -936},
    { -200, -112, -912},
    { -208, -128, -912},
    { -176, -120, -920},
    { -176, -104, -904},
    { -176, -88, -944},
    { -168, -96, -936},
    { -144, -96, -936},
    { -144, -104, -928},
    { -144, -80, -928},
    { -144, -96, -936},
    { -152, -56, -944},
    { -120, -104, -912},
    { -112, -88, -904},
    { -104, -104, -896},
    { -136, -112, -928},
    { -152, -136, -920},
    { -160, -128, -912},
    { -176, -104, -904},
    { -168, -120, -888},
    { -208, -96, -912},
    { -224, -184, -912},
    { -264, -312, -864},
    { -320, -88, -952},
    { -360, 96, -936},
    // 2 seconds
    { -128, 392, -952},
    { 72, 720, -1008},
    { 160, 592, -824},
    { 280, 696, -736},
    { 328, 800, -680},
    { 368, 656, -648},
    { 328, 528, -576},
    { 336, 304, -576},
    { 328, 352, -528},
    { 304, 568, -624},
    { 288, 856, -656},
    { 328, 96, -616},
    { 400, 800, -728},
    { 368, 680, -592},
    { 480, 720, -584},
    { 496, 688, -840},
    { 464, 488, -360},
    { 456, 720, -568},
    { 464, 720, -472},
    { 488, 720, -488},
    { 400, 944, -504},
    { 512, 768, -736},
    { 544, 680, -576},
    { 504, 744, -392},
    { 488, 800, -400},
    // 3 seconds
    { 512, 616, -352},
    { 544, 728, -488},
    { 560, 712, -448},
    { 560, 440, -480},
    { 504, 616, -616},
    { 544, 632, -360},
    { 536, 728, -488},
    { 512, 544, -680},
    { 568, 632, -424},
    { 568, 632, -480},
    { 552, 616, -600},
    { 552, 648, -520},
    { 536, 568, -624},
    { 520, 480, -664},
    { 536, 472, -960},
    { 520, 296, -752},
    { 568, 480, -528},
    { 632, 616, -480},
    { 576, 784, -184},
    { 656, 704, -232},
    { 456, 776, -792},
    { 552, 632, -616},
    { 648, 896, -704},
    { 600, 536, -392},
    { 432, 480, 240},
    // 4 seconds
    { 208, 1104, -480},
    { 48, 280, -656},
    { 424, 688, -624},
    { 376, 776, -456},
    { 448, 672, -384},
    { 544, 864, -368},
    { 376, 1024, -720},
    { 424, 808, -464},
    { 416, 536, -352},
    { 520, 776, -632},
    { 432, 824, -776},
    { 408, 568, -544},
    { 376, 608, -664},
    { 368, 824, -600},
    { 400, 392, -624},
    { 344, 600, -528},
    { 416, 744, -576},
    { 392, 672, -504},
    { 320, 752, -552},
    { 376, 720, -512},
    { 344, 736, -512},
    { 368, 768, -472},
    { 328, 776, -520},
    { 296, 880, -464},
    { 352, 776, -296},
    // 5 seconds
    { 288, 912, -440},
    { 232, 1024, -464},
    { 416, 584, 56},
    { 296, 936, -344},
    { 240, 664, -424},
    { 320, 640, -208},
    { 240, 976, -512},
    { 152, 896, -472},
    { 280, 936, -448},
    { 312, 856, -448},
    { 296, 832, -384},
    { 312, 832, -368},
    { 312, 872, -416},
    { 288, 896, -368},
    { 296, 856, -384},
    { 296, 800, -336},
    { 336, 912, -400},
    { 312, 832, -344},
    { 304, 840, -392},
    { 280, 840, -312},
    { 272, 832, -408},
    { 288, 888, -352},
    { 344, 848, -296},
    { 320, 880, -312},
    { 288, 928, -344},
    // 6 seconds
    { 296, 840, -312},
    { 240, 816, -472},
    { 152, 912, -560},
    { 200, 704, -344},
    { 320, 1016, -432},
    { 432, 1008, -216},
    { 536, 648, -256},
    { 464, 720, -456},
    { 352, 848, -336},
    { 200, 824, -448},
    { 320, 744, -272},
    { 352, 832, -552},
    { 344, 864, -640},
    { 352, 664, -456},
    { 352, 584, -296},
    { 352, 944, -584},
    { 352, 832, -480},
    { 368, 664, -344},
    { 352, 864, -456},
    { 376, 816, -440},
    { 336, 760, -304},
    { 344, 904, -392},
    { 336, 1064, -360},
    { 328, 808, -368},
    { 288, 856, -328},
    // 7 seconds
    { 272, 832, -264},
    { 200, 904, -416},
    { 256, 952, -312},
    { 408, 848, -240},
    { 424, 904, -360},
    { 368, 744, -512},
    { 280, 720, -480},
    { 520, 920, -360},
    { 408, 808, -328},
    { 304, 568, -576},
    { 360, 464, -472},
    { 352, 928, -632},
    { 392, 704, -496},
    { 344, 728, -472},
    { 384, 744, -496},
    { 360, 704, -512},
    { 344, 776, -504},
    { 352, 800, -520},
    { 360, 768, -472},
    { 376, 744, -456},
    { 360, 776, -496},
    { 368, 800, -464},
    { 360, 784, -496},
    { 344, 736, -448},
    { 352, 832, -416},
    // 8 seconds
    { 336, 784, -416},
    { 376, 752, -464},
    { 360, 776, -464},
    { 368, 752, -416},
    { 352, 768, -456},
    { 392, 728, -504},
    { 400, 728, -472},
    { 376, 824, -512},
    { 448, 744, -280},
    { 328, 856, -288},
    { 352, 888, -328},
    { 360, 736, -352},
    { 344, 712, -408},
    { 368, 864, -536},
    { 368, 824, -432},
    { 304, 744, -656},
    { 296, 608, -856},
    { 200, 576, -392},
    { 272, 624, -720},
    { 192, 400, -944},
    { 208, 400, -984},
    { 136, 384, -848},
    { 32, -56, -944},
    { 24, -104, -936},
    { 0, -112, -888},
    // 9 seconds
    { 8, -112, -864},
    { 16, -144, -872},
    { 16, -136, -864},
    { -16, -112, -888},
    { -8, -128, -888},
    { 0, -184, -872},
    { -8, -192, -816},
    { 8, -272, -680},
    { 8, -232, -480},
    { -72, -160, -400},
    { -176, -136, -528},
    { -400, 160, -720},
    { -408, 232, -808},
    { -600, 752, -1152},
    { -392, 480, -1048},
    { -280, 352, -752},
    { -224, 280, -736},
    { -240, 336, -616},
    { -320, 360, -440},
    { -440, 360, -312},
    { -992, 656, -256},
    { -1208, 680, -272},
    { -2168, 992, -552},
    { -1336, 1088, -96},
    { -696, 336, -128},
    // 10 seconds
    { -1008, 784, -360},
    { -816, 512, -152},
    { -800, 304, -40},
    { -616, 304, -40},
    { -504, 304, 16},
    { -480, 336, 0},
    { -520, 352, -24},
    { -592, 328, -8},
    { -656, 336, -24},
    { -696, 288, 0},
    { -1088, 344, -120},
    { -1328, 240, 24},
    { -1096, 216, -56},
    { -1120, 240, -128},
    { -1296, 328, -168},
    { -776, 200, -240},
    { -640, 304, -360},
    { -672, 408, -280},
    { -576, 360, -216},
    { -496, 352, -152},
    { -440, 368, -136},
    { -520, 440, -152},
    { -584, 392, -152},
    { -600, 320, -88},
    { -696, 352, -176},
    // 11 seconds
    { -824, 424, -224},
    { -1120, 424, -336},
    { -1712, 256, -208},
    { -1968, 360, -232},
    { -1144, 32, 56},
    { -1128, 640, -568},
    { -936, 392, -240},
    { -704, 200, 48},
    { -504, 176, 48},
    { -392, 312, 40},
    { -416, 288, 72},
    { -472, 272, 64},
    { -560, 232, 96},
    { -608, 208, 80},
    { -736, 208, 80},
    { -976, 216, 80},
    { -1176, 272, 32},
    { -1544, 368, -40},
    { -1528, 560, -304},
    { -912, 304, -184},
    { -840, 432, -304},
    { -656, 312, -264},
    { -472, 216, -224},
    { -368, 272, -224},
    { -392, 456, -216},
    // 12 seconds
    { -544, 104, -128},
    { -744, 472, -80},
    { -760, 560, -24},
    { -808, 528, -32},
    { -1064, 552, -184},
    { -1080, 376, 0},
    { -1592, 544, -128},
    { -1320, 536, -104},
    { -1104, 416, -96},
    { -1208, 600, -136},
    { -960, 360, 48},
    { -600, 352, -16},
    { -480, 352, -32},
    { -472, 264, 48},
    { -488, 184, 120},
    { -496, 144, 128},
    { -528, 192, 80},
    { -624, 208, 72},
    { -928, 264, 72},
    { -1104, 360, -16},
    { -1432, 352, -48},
    { -1680, 592, -280},
    { -1064, 368, -176},
    { -864, 240, -136},
    { -656, 248, -216},
    // 13 seconds
    { -464, 160, -152},
    { -312, 384, -208},
    { -440, 432, -224},
    { -592, 360, -112},
    { -792, 312, -40},
    { -664, 304, -16},
    { -736, 384, -112},
    { -1152, 528, -216},
    { -1288, 360, -24},
    { -1520, 344, -72},
    { -1376, 632, -352},
    { -1200, 416, -136},
    { -1160, 552, -200},
    { -1048, 336, 24},
    { -616, 304, 40},
    { -376, 344, -32},
    { -440, 320, -16},
    { -456, 232, 80},
    { -488, 168, 136},
    { -496, 184, 104},
    { -576, 200, 112},
    { -952, 272, 72},
    { -1040, 320, 88},
    { -1384, 392, -64},
    { -1600, 472, -136},
    // 14 seconds
    { -1160, 552, -304},
    { -992, 272, -160},
    { -672, 376, -216},
    { -488, 312, -224},
    { -352, 320, -160},
    { -352, 344, -192},
    { -416, 352, -152},
    { -528, 312, -64},
    { -640, 368, -88},
    { -784, 480, -168},
    { -1112, 544, -240},
    { -1392, 544, -192},
    { -1760, 520, -192},
    { -1456, 608, -176},
    { -1168, 400, -48},
    { -1032, 424, -80},
    { -800, 376, -8},
    { -528, 336, 0},
    { -520, 328, -16},
    { -536, 280, 48},
    { -528, 184, 112},
    { -528, 120, 120},
    { -456, 176, 88},
    { -536, 216, 72},
    { -832, 224, 80},
    // 15 seconds
    { -1000, 312, 32},
    { -1384, 320, 64},
    { -1760, 464, -96},
    { -1376, 560, -288},
    { -848, 296, -72},
    { -624, 480, -336},
    { -504, 416, -304},
    { -360, 320, -144},
    { -344, 288, -160},
    { -408, 384, -216},
    { -632, 408, -160},
    { -792, 384, -128},
    { -720, 328, -48},
    { -1056, 464, -176},
    { -1352, 496, -40},
    { -1656, 520, -128},
    { -1488, 600, -360},
    { -1056, 328, -40},
    { -1096, 464, -144},
    { -856, 416, -88},
    { -496, 320, 8},
    { -456, 296, 16},
    { -504, 240, 32},
    { -520, 224, 88},
    { -520, 184, 120},
    // 16 seconds
    { -528, 168, 112},
    { -624, 216, 72},
    { -952, 248, 64},
    { -1104, 296, 56},
    { -1504, 280, 88},
    { -1408, 512, -152},
    { -1056, 768, -512},
    { -928, 352, -112},
    { -792, 88, -72},
    { -488, -40, -104},
    { -360, 256, -264},
    { -424, 368, -152},
    { -504, 304, -136},
    { -616, 280, -56},
    { -680, 360, -104},
    { -800, 448, -152},
    { -1112, 520, -200},
    { -1392, 416, -72},
    { -1544, 432, -128},
    { -1424, 584, -320},
    { -976, 376, -64},
    { -1040, 504, -264},
    { -904, 408, -112},
    { -632, 336, -16},
    { -480, 336, -32},
    // 17 seconds
    { -488, 336, 0},
    { -488, 312, 80},
    { -552, 288, 136},
    { -616, 320, 128},
    { -592, 328, 120},
    { -824, 232, 88},
    { -960, 296, 32},
    { -1216, 360, 48},
    { -1376, 384, -8},
    { -1112, 552, -288},
    { -1088, 432, -224},
    { -848, 288, -176},
    { -608, 224, -256},
    { -408, 240, -240},
    { -360, 304, -248},
    { -432, 344, -208},
    { -592, 304, -136},
    { -808, 368, -120},
    { -792, 368, -56},
    { -968, 456, -112},
    { -1056, 512, -152},
    { -1464, 520, -152},
    { -1528, 600, -312},
    { -1224, 432, -80},
    { -1040, 520, -240},
    // 18 seconds
    { -912, 456, -136},
    { -640, 376, -32},
    { -424, 352, -24},
    { -448, 304, 24},
    { -512, 296, 96},
    { -560, 216, 120},
    { -640, 224, 144},
    { -712, 256, 128},
    { -944, 272, 112},
    { -1112, 304, 88},
    { -1208, 240, 80},
    { -1352, 384, -72},
    { -1016, 360, -256},
    { -992, 264, -248},
    { -912, 272, -280},
    { -648, 200, -272},
    { -400, 208, -264},
    { -368, 280, -264},
    { -440, 272, -208},
    { -568, 272, -144},
    { -720, 344, -120},
    { -792, 384, -112},
    { -816, 408, -104},
    { -1008, 520, -256},
    { -1120, 424, -160},
    // 19 seconds
    { -1528, 472, -256},
    { -1512, 520, -304},
    { -1136, 416, -144},
    { -1056, 520, -224},
    { -856, 392, -104},
    { -592, 328, -48},
    { -464, 336, -48},
    { -480, 320, -16},
    { -520, 320, 48},
    { -544, 264, 88},
    { -576, 256, 104},
    { -624, 304, 72},
    { -800, 304, 80},
    { -936, 304, 80},
    { -984, 384, -120},
    { -1240, 328, -72},
    { -1424, 392, -104},
    { -1000, 440, -320},
    { -904, 400, -304},
    { -728, 408, -304},
    { -528, 280, -264},
    { -384, 296, -200},
    { -392, 328, -232},
    { -472, 312, -184},
    { -592, 280, -112},
    // 20 seconds
    { -680, 344, -144},
    { -656, 328, -56},
    { -800, 392, -128},
    { -1048, 496, -208},
    { -1248, 432, -120},
    { -1480, 512, -200},
    { -1352, 600, -264},
    { -1096, 536, -152},
    { -1136, 528, -224},
    { -888, 352, -32},
    { -616, 416, -72},
    { -496, 496, -144},
    { -464, 360, -24},
    { -448, 320, 48},
    { -496, 304, 96},
    { -512, 344, 88},
    { -592, 376, 72},
    { -800, 376, 56},
    { -960, 328, 48},
    { -1096, 384, -8},
    { -1120, 408, -128},
    { -1072, 536, -352},
    { -1088, 552, -480},
    { -1056, 384, -200},
    { -784, 168, -168},
    // 21 seconds
    { -528, 304, -224},
    { -400, 424, -224},
    { -416, 416, -200},
    { -464, 344, -152},
    { -520, 248, -72},
    { -608, 320, -96},
    { -640, 360, -80},
    { -888, 440, -160},
    { -1128, 496, -192},
    { -1480, 448, -104},
    { -1664, 616, -320},
    { -1288, 392, -32},
    { -1096, 480, -216},
    { -872, 472, -160},
    { -584, 416, -128},
    { -448, 376, -96},
    { -408, 304, 0},
    { -424, 240, 48},
    { -544, 256, 72},
    { -616, 280, 96},
    { -648, 320, 48},
    { -784, 304, 80},
    { -1064, 336, 48},
    { -928, 288, 32},
    { -1304, 328, -136},
    // 22 seconds
    { -1392, 512, -192},
    { -920, 328, -264},
    { -848, 416, -360},
    { -744, 456, -352},
    { -448, 208, -232},
    { -320, 216, -176},
    { -360, 280, -184},
    { -472, 336, -168},
    { -592, 296, -48},
    { -768, 360, -112},
    { -584, 392, -80},
    { -784, 432, -176},
    { -1048, 552, -296},
    { -1472, 400, -72},
    { -1728, 584, -368},
    { -1240, 416, -128},
    { -1096, 504, -176},
    { -1072, 488, -160},
    { -640, 344, 0},
    { -400, 360, 0},
    { -424, 344, -40},
    { -448, 248, 64},
    { -496, 224, 104},
    { -648, 232, 48},
    { -744, 264, 24},
    // 23 seconds
    { -904, 272, 24},
    { -1112, 272, 64},
    { -1088, 328, -72},
    { -1232, 376, -96},
    { -1208, 480, -208},
    { -896, 440, -336},
    { -880, 424, -344},
    { -592, 272, -160},
    { -400, 256, -152},
    { -368, 320, -168},
    { -400, 368, -160},
    { -480, 312, -128},
    { -616, 296, -112},
    { -696, 320, -64},
    { -968, 416, -160},
    { -1096, 408, -128},
    { -1528, 464, -192},
    { -1512, 560, -328},
    { -1200, 448, -128},
    { -1064, 384, -328},
    { -1056, 344, -248},
    { -736, 232, -8},
    { -472, 320, -88},
    { -400, 384, -80},
    { -424, 328, 0},
    // 24 seconds
    { -488, 232, 64},
    { -592, 200, 96},
    { -664, 216, 88},
    { -888, 256, 72},
    { -1056, 272, 112},
    { -1024, 336, 40},
    { -1320, 392, -8},
    { -1224, 592, -264},
    { -1032, 496, -224},
    { -960, 488, -216},
    { -632, 424, -272},
    { -448, 392, -224},
    { -392, 408, -248},
    { -416, 336, -208},
    { -448, 264, -160},
    { -592, 288, -184},
    { -744, 384, -200},
    { -816, 352, -112},
    { -1008, 440, -208},
    { -1096, 448, -136},
    { -1528, 520, -248},
    { -1408, 592, -240},
    { -1144, 408, -8},
    { -1032, 576, -128},
    { -744, 440, -64},
    // 25 seconds
    { -424, 344, -32},
    { -344, 352, -64},
    { -368, 344, -24},
    { -464, 304, 40},
    { -576, 272, 32},
    { -616, 264, 48},
    { -768, 280, 56},
    { -1032, 296, 72},
    { -1200, 408, -80},
    { -1384, 312, 24},
    { -1280, 568, -344},
    { -928, 432, -384},
    { -872, 232, -168},
    { -720, 272, -224},
    { -464, 296, -216},
    { -320, 352, -232},
    { -376, 384, -256},
    { -480, 304, -176},
    { -664, 272, -120},
    { -800, 304, -112},
    { -688, 360, -104},
    { -816, 440, -184},
    { -952, 480, -160},
    { -1344, 488, -128},
    { -1488, 672, -384},
    // 26 seconds
    { -1144, 560, -152},
    { -1088, 464, -104},
    { -1048, 456, -88},
    { -712, 360, 0},
    { -480, 392, -72},
    { -496, 416, -80},
    { -520, 272, 16},
    { -584, 240, 48},
    { -568, 256, 56},
    { -536, 272, 64},
    { -616, 304, 16},
    { -912, 336, -8},
    { -920, 400, -72},
    { -1176, 376, -88},
    { -1184, 488, -256},
    { -1072, 456, -320},
    { -936, 352, -216},
    { -808, 352, -256},
    { -608, 328, -200},
    { -440, 328, -160},
    { -384, 352, -144},
    { -408, 360, -152},
    { -512, 352, -152},
    { -688, 336, -152},
    { -736, 336, -88},
    // 27 seconds
    { -816, 368, -160},
    { -1016, 480, -216},
    { -1112, 424, -184},
    { -1480, 456, -240},
    { -1152, 536, -232},
    { -1096, 504, -224},
    { -1080, 520, -208},
    { -824, 304, -16},
    { -536, 320, -32},
    { -416, 376, -56},
    { -416, 384, -8},
    { -472, 344, 48},
    { -544, 304, 80},
    { -648, 384, 80},
    { -656, 440, 32},
    { -904, 456, 24},
    { -888, 536, -96},
    { -1160, 536, -88},
    { -1152, 704, -192},
    { -1016, 752, -304},
    { -1008, 640, -144},
    { -840, 640, -280},
    { -648, 584, -288},
    { -464, 496, -136},
    { -376, 520, -128},
    // 28 seconds
    { -248, 608, -96},
    { -264, 696, -40},
    { -256, 680, -152},
    { -336, 664, -8},
    { -272, 640, -16},
    { -208, 720, -160},
    { -200, 816, 16},
    { -288, 1152, 200},
    { -400, 1384, 456},
    { -408, 1552, 592},
    { -264, 1312, 520},
    { -168, 952, 680},
    { -152, 792, 344},
    { -16, 576, 104},
    { 88, 368, 232},
    { 88, 424, 224},
    { -88, 664, 168},
    { -16, 648, 416},
    { 48, 704, 280},
    { 8, 1024, 440},
    { 56, 1096, 464},
    { -184, 840, 72},
    { -376, 1688, -112},
    { -288, 1416, 296},
    { -440, 1120, 416},
    // 29 seconds
    { -368, 1240, 432},
    { -280, 832, 344},
    { -248, 784, 272},
    { -144, 568, 296},
    { -8, 520, 96},
    { 80, 544, 216},
    { 40, 472, 240},
    { 56, 736, 56},
    { -24, 912, 176},
    { 72, 840, 336},
    { 136, 912, 424},
    { 104, 1176, 416},
    { -16, 1040, 672},
    { -264, 1264, 824},
    { -456, 1064, 816},
    { -576, 1248, 808},
    { -448, 864, 656},
    { -384, 872, 544},
    { -152, 608, 384},
    { -104, 624, 352},
    { -88, 584, 272},
    { -112, 616, 176},
    { -104, 536, 216},
    { -120, 528, 160},
    { -176, 448, 88},
    // 30 seconds
    { -336, 512, 168},
    { -592, 696, 176},
    { -672, 544, 64},
    { -1192, 608, 240},
    { -1192, 440, 16},
    { -1560, 856, -56},
    { -1424, 872, -96},
    { -888, 680, -16},
    { -552, 576, -48},
    { -368, 344, 8},
    { -296, 536, -104},
    { -368, 472, -40},
    { -424, 768, -8},
    { -568, 864, -48},
    { -600, 944, 224},
    { -568, 1064, 48},
    { -584, 808, -24},
    { -896, 1032, 336},
    { -1120, 472, 32},
    { -1232, 584, 184},
    { -1136, 584, 72},
    { -1160, 464, 56},
    { -904, 424, 120},
    { -632, 360, -16},
    { -472, 360, 8},
    // 31 seconds
    { -392, 256, 96},
    { -320, 264, -88},
    { -400, 480, -120},
    { -456, 408, -144},
    { -536, 280, -32},
    { -976, 712, -96},
    { -1072, 144, 16},
    { -1424, 184, 232},
    { -1616, 568, 32},
    { -1024, 592, -184},
    { -864, 480, -272},
    { -768, 136, -128},
    { -632, 80, -88},
    { -448, 120, -80},
    { -360, 304, 8},
    { -432, 312, 8},
    { -560, 344, -16},
    { -768, 528, -48},
    { -816, 400, -160},
    { -824, 520, -128},
    { -1008, 624, -200},
    { -1032, 520, 16},
    { -1368, 752, -192},
    { -1464, 248, 144},
    { -1336, 520, 104},
    // 32 seconds
    { -1224, 464, 24},
    { -944, 464, -8},
    { -632, 352, 136},
    { -304, 312, 56},
    { -304, 216, 24},
    { -304, 136, 56},
    { -448, 400, -32},
    { -616, 280, -8},
    { -768, 200, 120},
    { -936, 504, 56},
    { -1088, 384, 56},
    { -1200, 496, -176},
    { -1144, 144, -24},
    { -1200, 704, -112},
    { -1152, 584, -296},
    { -816, 232, -16},
    { -448, 240, -136},
    { -352, 176, -120},
    { -368, 224, -136},
    { -464, 160, 64},
    { -568, 552, -88},
    { -632, 584, -48},
    { -696, 568, -8},
    { -808, 640, -72},
    { -864, 704, 40},
    // 33 seconds
    { -920, 776, 40},
    { -1272, 744, -184},
    { -1256, 600, -128},
    { -1240, 512, 16},
    { -1392, 648, -24},
    { -1096, 432, 24},
    { -752, 304, -96},
    { -512, 200, -104},
    { -440, 160, -16},
    { -392, -16, 72},
    { -472, 144, 40},
    { -736, 120, 152},
    { -736, 200, 96},
    { -1072, 336, 96},
    { -1088, 56, 160},
    { -1160, 352, -152},
    { -1184, 360, -40},
    { -1192, 456, -136},
    { -1040, 384, -152},
    { -824, 296, -160},
    { -696, 184, -128},
    { -432, 152, -152},
    { -400, 232, -136},
    { -448, 328, -112},
    { -584, 520, 0},
    // 34 seconds
    { -648, 336, -32},
    { -792, 488, -80},
    { -1032, 656, -192},
    { -1088, 432, -88},
    { -1440, 872, -280},
    { -1376, 240, -32},
    { -1256, 592, -168},
    { -1168, 496, -152},
    { -1136, 392, -104},
    { -904, 248, -56},
    { -568, 104, -24},
    { -432, 320, 24},
    { -440, 184, 72},
    { -440, 144, 48},
    { -624, 336, 176},
    { -632, 160, 120},
    { -704, 368, 48},
    { -888, 320, 64},
    { -952, 248, 32},
    { -1200, 408, -88},
    { -1176, 352, -56},
    { -1040, 432, -312},
    { -960, 448, -272},
    { -856, 496, -280},
    { -632, 352, -288},
    // 35 seconds
    { -472, 584, -240},
    { -328, 392, -32},
    { -360, 408, 16},
    { -440, 760, 16},
    { -376, 576, 56},
    { -432, 552, 24},
    { -552, 728, -8},
    { -648, 712, 40},
    { -808, 664, 80},
    { -1056, 904, -56},
    { -1136, 640, 224},
    { -1104, 680, 40},
    { -1168, 800, 136},
    { -1064, 672, 160},
    { -744, 376, 64},
    { -512, 400, 72},
    { -296, 312, 40},
    { -296, 336, 24},
    { -392, 296, 104},
    { -536, 344, 88},
    { -680, 408, 96},
    { -824, 416, 112},
    { -1032, 512, 72},
    { -1032, 448, 16},
    { -1160, 472, -32},
    // 36 seconds
    { -1120, 472, -176},
    { -896, 488, -144},
    { -800, 568, -240},
    { -720, 416, -224},
    { -552, 296, -208},
    { -448, 256, -88},
    { -400, 288, -144},
    { -464, 320, -80},
    { -568, 352, -48},
    { -640, 384, -88},
    { -640, 448, -40},
    { -656, 480, -80},
    { -880, 520, -224},
    { -1096, 440, -24},
    { -1296, 592, -376},
    { -1264, 512, -136},
    { -1144, 624, -232},
    { -1176, 520, -200},
    { -1008, 392, -176},
    { -712, 296, -104},
    { -544, 264, -96},
    { -456, 248, 0},
    { -432, 232, -32},
    { -472, 240, 8},
    { -568, 320, 0},
    // 37 seconds
    { -632, 328, 32},
    { -752, 344, 16},
    { -992, 464, -40},
    { -1048, 480, 64},
    { -1112, 560, -224},
    { -1016, 496, -120},
    { -872, 504, -224},
    { -968, 464, -288},
    { -856, 464, -336},
    { -592, 424, -248},
    { -400, 184, -120},
    { -368, 312, -136},
    { -384, 200, -128},
    { -488, 280, -88},
    { -664, 496, -8},
    { -672, 536, -40},
    { -760, 560, -64},
    { -928, 648, -40},
    { -1024, 680, -256},
    { -1184, 592, -88},
    { -1136, 656, -232},
    { -976, 552, -144},
    { -1064, 656, -184},
    { -1024, 456, -144},
    { -784, 336, -24},
    // 38 seconds
    { -560, 456, -64},
    { -440, 312, 0},
    { -432, 288, -32},
    { -464, 240, 48},
    { -560, 296, 56},
    { -648, 384, 24},
    { -808, 304, 192},
    { -1088, 400, 16},
    { -1016, 504, -72},
    { -1120, 504, -96},
    { -1152, 632, -112},
    { -832, 688, -368},
    { -832, 640, -248},
    { -768, 384, -176},
    { -544, 320, -184},
    { -344, 168, -120},
    { -312, 200, -208},
    { -424, 192, 32},
    { -600, 392, -88},
    { -688, 440, -96},
    { -784, 456, 32},
    { -784, 584, -112},
    { -928, 520, -8},
    { -1272, 736, -96},
    { -1408, 712, -192},
    // 39 seconds
    { -1056, 616, -88},
    { -912, 600, -128},
    { -936, 488, -112},
    { -784, 288, 0},
    { -584, 344, 24},
    { -456, 288, -32},
    { -408, 256, 48},
    { -456, 232, 24},
    { -576, 304, 32},
    { -704, 344, 40},
    { -848, 336, 16},
    { -1096, 496, -32},
    { -1096, 416, -40},
    { -1320, 688, 80},
    { -976, 336, 8},
    { -688, 400, -128},
    { -760, 400, -320},
    { -800, 296, -224},
    { -592, 240, -168},
    { -400, 296, -224},
    { -376, 216, -104},
    { -416, 296, -104},
    { -568, 384, -144},
    { -696, 376, -144},
    { -736, 464, -88},
    // 40 seconds
    { -840, 504, -88},
    { -1040, 360, -280},
    { -1216, 576, -104},
    { -1368, 536, -472},
    { -1184, 448, -336},
    { -1064, 384, -280},
    { -952, 416, -328},
    { -680, 288, -136},
    { -440, 272, -72},
    { -392, 400, -128},
    { -464, 360, -24},
    { -568, 248, 96},
    { -640, 312, -40},
    { -664, 240, -64},
    { -904, 448, 24},
    { -1088, 296, -96},
    { -1112, 312, -128},
    { -1136, 384, -176},
    { -1040, 488, -232},
    { -904, 440, -176},
    { -960, 384, -152},
    { -712, 240, -248},
    { -464, 56, -152},
    { -360, 104, -192},
    { -352, 168, -144},
    // 41 seconds
    { -504, 368, -168},
    { -624, 336, -96},
    { -688, 432, -136},
    { -736, 488, -208},
    { -840, 512, -216},
    { -888, 416, -88},
    { -1328, 616, -288},
    { -1312, 648, -256},
    { -1400, 488, -128},
    { -1352, 424, -40},
    { -1152, 408, -24},
    { -792, 312, -8},
    { -472, 264, -144},
    { -368, 312, -64},
    { -344, 168, 48},
    { -384, 200, -16},
    { -536, 296, 0},
    { -616, 384, 16},
    { -720, 336, 104},
    { -944, 384, 56},
    { -1088, 616, -40},
    { -1120, 416, 96},
    { -1248, 1176, 48},
    { -728, 136, 16},
    { -1064, 616, -344},
    // 42 seconds
    { -728, 32, -208},
    { -536, 240, -224},
    { -432, 256, -112},
    { -392, 296, -200},
    { -456, 240, -104},
    { -576, 352, -88},
    { -624, 472, -120},
    { -552, 432, -128},
    { -640, 568, -184},
    { -856, 536, -176},
    { -960, 528, -176},
    { -1208, 664, -344},
    { -1160, 496, -40},
    { -1000, 544, -352},
    { -1104, 368, -168},
    { -1160, 464, -136},
    { -880, 408, -72},
    { -568, 312, -128},
    { -408, 304, -112},
    { -384, 272, -48},
    { -400, 304, -48},
    { -536, 344, -16},
    { -632, 288, 0},
    { -760, 392, -48},
    { -976, 376, -56},
    // 43 seconds
    { -1088, 440, -152},
    { -1080, 288, -104},
    { -1040, 424, -192},
    { -1072, 256, -232},
    { -1080, 336, -296},
    { -912, 304, -288},
    { -600, 256, -304},
    { -376, 280, -192},
    { -272, 232, -160},
    { -368, 304, -152},
    { -496, 320, -144},
    { -648, 336, -64},
    { -728, 456, -88},
    { -664, 424, -88},
    { -800, 456, -168},
    { -1096, 784, -128},
    { -1424, 400, -288},
    { -1424, 488, -224},
    { -1264, 512, -200},
    { -1032, 624, -216},
    { -848, 488, -168},
    { -696, 424, -56},
    { -432, 248, 48},
    { -432, 344, 16},
    { -472, 264, 24},
    // 44 seconds
    { -512, 312, 0},
    { -560, 296, 40},
    { -608, 352, 72},
    { -656, 456, -24},
    { -864, 416, -72},
    { -1176, 704, 32},
    { -1176, 760, -424},
    { -1184, 224, -80},
    { -1064, 528, -360},
    { -944, 456, -416},
    { -760, 408, -304},
    { -568, 288, -208},
    { -376, 296, -200},
    { -368, 328, -24},
    { -336, 384, -88},
    { -400, 432, -88},
    { -496, 400, 0},
    { -576, 504, -200},
    { -680, 440, 0},
    { -792, 664, -304},
    { -952, 400, -56},
    { -1512, 880, -288},
    { -1432, 712, -136},
    { -1064, 592, -184},
    { -992, 576, -232},
    // 45 seconds
    { -960, 616, 72},
    { -672, 592, -40},
    { -520, 592, 136},
    { -384, 344, 232},
    { -376, 456, 200},
    { -312, 304, 128},
    { -320, 488, 120},
    { -360, 544, 152},
    { -416, 608, 0},
    { -624, 760, 160},
    { -640, 912, -32},
    { -816, 808, 176},
    { -816, 1120, -128},
    { -976, 992, 48},
    { -904, 952, 32},
    { -688, 928, 24},
    { -440, 704, 24},
    { -240, 480, 56},
    { -176, 576, 104},
    { -104, 520, 48},
    { -136, 568, 32},
    { -216, 600, 96},
    { -296, 960, -8},
    { -312, 896, 168},
    { -384, 1104, 232},
    // 46 seconds
    { -392, 1080, 336},
    { -408, 1240, 352},
    { -480, 952, 624},
    { -544, 1048, 568},
    { -664, 960, 616},
    { -568, 952, 520},
    { -432, 792, 312},
    { -256, 592, 408},
    { -120, 592, 176},
    { -48, 456, 80},
    { -56, 512, 40},
    { -56, 584, 200},
    { -104, 656, 288},
    { -168, 840, 248},
    { -224, 976, 280},
    { -336, 912, 512},
    { -272, 1000, 120},
    { -512, 1096, 336},
    { -632, 1352, 264},
    { -704, 1296, 200},
    { -608, 960, 48},
    { -448, 728, 264},
    { -288, 584, 336},
    { -80, 488, 264},
    { -8, 552, 144},
    // 47 seconds
    { -40, 472, 208},
    { -40, 688, 128},
    { -128, 784, 80},
    { -160, 864, 136},
    { -208, 1080, 176},
    { -288, 1120, 216},
    { -248, 1264, 16},
    { -384, 1392, 280},
    { -512, 1616, 160},
    { -472, 1376, 336},
    { -448, 1200, 328},
    { -376, 976, 480},
    { -248, 576, 352},
    { -120, 688, 264},
    { 16, 456, 408},
    { 88, 424, 224},
    { 120, 448, 248},
    { 288, 544, 224},
    { 304, 768, 256},
    { 208, 800, 232},
    { 160, 952, 248},
    { 64, 1104, 136},
    { -72, 1296, 248},
    { -88, 1352, 344},
    { -280, 1336, 152},
    // 48 seconds
    { -104, 1312, 224},
    { -32, 912, 208},
    { -40, 792, 88},
    { 152, 640, 88},
    { 168, 632, 144},
    { 144, 568, 160},
    { 144, 728, 16},
    { 128, 760, 40},
    { 128, 848, 120},
    { 232, 1016, 56},
    { 304, 1112, 72},
    { 264, 1240, 248},
    { 136, 1872, 16},
    { 64, 1304, 368},
    { -48, 1512, 312},
    { 72, 1160, 288},
    { 88, 800, 272},
    { 104, 816, 224},
    { 72, 616, 168},
    { 120, 384, 152},
    { 208, 568, 112},
    { 208, 712, 32},
    { 184, 784, 40},
    { 208, 912, 48},
    { 168, 1096, 32},
    // 49 seconds
    { 120, 1112, 48},
    { 152, 1192, 128},
    { -24, 1376, 136},
    { -136, 1368, 64},
    { -80, 1136, 144},
    { -72, 920, 32},
    { -32, 848, 112},
    { 80, 768, 48},
    { 80, 576, 72},
    { 136, 592, 16},
    { 152, 736, -32},
    { 160, 808, 0},
    { 168, 848, 40},
    { 184, 944, 72},
    { 216, 1032, 40},
    { 160, 1168, 32},
    { 232, 1496, 152},
    { 16, 1328, 264},
    { -112, 1392, 352},
    { 56, 1264, 352},
    { 32, 888, 312},
    { 56, 792, 248},
    { 136, 720, 208},
    { 104, 616, 128},
    { 120, 536, 128},
    // 50 seconds
    { 176, 608, 128},
    { 208, 760, 112},
    { 216, 880, 112},
    { 208, 1000, 88},
    { 152, 1160, 88},
    { 48, 1264, 144},
    { -16, 1448, -8},
    { -104, 1208, 192},
    { -144, 1336, 104},
    { -136, 1120, 112},
    { -72, 920, 168},
    { 24, 768, 88},
    { 88, 624, -8},
    { 112, 576, 8},
    { 152, 592, 48},
    { 136, 736, 16},
    { 136, 872, 0},
    { 136, 960, 32},
    { 168, 912, 64},
    { 200, 992, 16},
    { 208, 1176, 72},
    { 224, 1344, 32},
    { -88, 1456, 328},
    { -80, 1544, 408},
    { -88, 1144, 296},
    // 51 seconds
    { -80, 984, 200},
    { 56, 784, 232},
    { 104, 648, 184},
    { 104, 640, 96},
    { 120, 608, 40},
    { 136, 600, 88},
    { 152, 808, 136},
    { 192, 912, 72},
    { 184, 984, 16},
    { 152, 1128, 40},
    { 32, 1240, 56},
    { -56, 1504, 176},
    { -168, 1256, 168},
    { -264, 1392, 24},
    { -224, 1088, 112},
    { -176, 864, 104},
    { 56, 816, 48},
    { 48, 608, -32},
    { 128, 472, 40},
    { 104, 656, 8},
    { 112, 744, 0},
    { 104, 912, -32},
    { 104, 968, 24},
    { 160, 1064, 64},
    { 160, 1248, 80},
    // 52 seconds
    { 224, 1368, 144},
    { -24, 1312, 248},
    { -112, 1696, 400},
    { -120, 1240, 472},
    { -72, 864, 272},
    { 40, 848, 200},
    { 64, 632, 192},
    { 96, 504, 160},
    { 144, 624, 40},
    { 152, 672, 56},
    { 128, 776, 144},
    { 120, 928, 88},
    { 160, 880, 96},
    { 160, 1088, 32},
    { 24, 1216, 144},
    { -48, 1424, 96},
    { -200, 1656, 152},
    { -200, 1136, 240},
    { -136, 968, 88},
    { -96, 872, 256},
    { 48, 800, 80},
    { 64, 544, -8},
    { 152, 568, 8},
    { 168, 608, 0},
    { 136, 712, 0},
    // 53 seconds
    { 128, 1016, 64},
    { 152, 936, 8},
    { 168, 928, -32},
    { 128, 1136, 112},
    { 152, 1408, 128},
    { -72, 1184, 88},
    { -64, 1672, 328},
    { -136, 1064, 416},
    { 0, 824, 344},
    { 32, 1064, 312},
    { 32, 840, 256},
    { 96, 592, 136},
    { 104, 536, 120},
    { 152, 648, 112},
    { 192, 648, 48},
    { 152, 936, 88},
    { 160, 960, 48},
    { 128, 952, 72},
    { 72, 1112, 64},
    { -56, 1296, 128},
    { -144, 1120, 136},
    { -184, 1624, 176},
    { -216, 1288, 160},
    { -136, 928, 136},
    { 32, 752, 144},
    // 54 seconds
    { 64, 712, 24},
    { 104, 624, 16},
    { 152, 544, 56},
    { 152, 664, 32},
    { 152, 888, -16},
    { 144, 952, 0},
    { 168, 952, 16},
    { 184, 1112, 24},
    { 168, 1192, 64},
    { 216, 1280, 168},
    { -24, 1512, 312},
    { 88, 1360, 264},
    { 80, 1160, 256},
    { 80, 912, 352},
    { 112, 712, 304},
    { 128, 536, 136},
    { 208, 520, 104},
    { 200, 624, 80},
    { 216, 768, 24},
    { 240, 856, 152},
    { 216, 992, 128},
    { 152, 1040, 96},
    { 152, 1240, 152},
    { 80, 1320, -16},
    { -24, 1160, 128},
    // 55 seconds
    { 24, 1440, 224},
    { -32, 984, 184},
    { 8, 1064, -8},
    { 8, 784, 32},
    { 104, 648, 24},
    { 144, 544, 96},
    { 216, 552, -16},
    { 224, 672, -56},
    { 240, 888, 0},
    { 192, 1032, 8},
    { 240, 1080, 24},
    { 280, 1368, 48},
    { 176, 1176, 144},
    { 120, 1488, 328},
    { -48, 1424, 456},
    { -24, 1200, 448},
    { 72, 1032, 256},
    { 112, 864, 256},
    { 152, 544, 296},
    { 176, 576, 96},
    { 184, 552, 128},
    { 216, 664, 136},
    { 248, 800, -40},
    { 312, 920, 80},
    { 352, 960, 56},
    // 56 seconds
    { 248, 1080, 88},
    { 160, 1272, 168},
    { 64, 1208, 24},
    { 72, 1328, 192},
    { -48, 1280, 136},
    { 48, 856, 136},
    { 96, 872, 104},
    { 112, 768, 64},
    { 160, 648, -8},
    { 192, 712, 8},
    { 208, 632, 48},
    { 208, 760, 0},
    { 184, 872, 16},
    { 208, 856, 88},
    { 280, 1048, 72},
    { 280, 1384, -56},
    { 216, 1240, 96},
    { 128, 1792, 464},
    { 48, 1336, 296},
    { 64, 1000, 200},
    { 96, 832, 192},
    { 64, 688, 232},
    { 120, 584, 136},
    { 160, 648, 56},
    { 200, 632, 112},
    // 57 seconds
    { 208, 696, 64},
    { 224, 776, 24},
    { 296, 952, 72},
    { 248, 1200, 104},
    { 168, 1456, 56},
    { 104, 1392, -16},
    { 24, 1264, 344},
    { -80, 1208, 112},
    { -16, 1216, -8},
    { 8, 848, 136},
    { 64, 672, 144},
    { 144, 600, -16},
    { 168, 584, -72},
    { 232, 560, -64},
    { 232, 704, -32},
    { 216, 912, -24},
    { 240, 1032, 24},
    { 256, 1000, 0},
    { 304, 1288, 40},
    { 280, 1760, 256},
    { 112, 1400, 288},
    { 152, 1088, 216},
    { 152, 984, 200},
    { 152, 896, 272},
    { 168, 760, 312},
    // 58 seconds
    { 184, 568, 80},
    { 208, 552, 72},
    { 232, 608, 96},
    { 248, 664, 72},
    { 336, 840, 72},
    { 328, 1032, 72},
    { 280, 1144, 168},
    { 192, 1304, 136},
    { 48, 1264, -16},
    { 112, 1520, 240},
    { -40, 1240, 240},
    { -32, 992, 40},
    { 24, 856, 40},
    { 120, 664, 96},
    { 192, 600, 64},
    { 200, 568, -8},
    { 216, 664, 40},
    { 240, 872, 24},
    { 232, 888, 24},
    { 280, 872, 72},
    { 304, 1136, -40},
    { 248, 1184, 64},
    { 344, 1520, 136},
    { 136, 1432, 192},
    { 144, 1296, 304},
    // 59 seconds
    { 128, 1104, 448},
    { 120, 888, 288},
    { 184, 760, 208},
    { 200, 624, 112},
    { 216, 568, 144},
    { 240, 624, 104},
    { 272, 712, 24},
    { 288, 824, 112},
    { 288, 968, 160},
    { 288, 1064, 72},
    { 320, 1256, 40},
    { 144, 1104, 48},
    { 104, 1384, 224},
    { 0, 1376, 168},
    { -32, 1120, 40},
    { 40, 832, 32},
    { 80, 736, 72},
    { 160, 728, 96},
    { 192, 576, 64},
    { 208, 608, 0},
    { 216, 664, 0},
    { 248, 864, 0},
    { 256, 960, -16},
    { 312, 1016, -32},
    { 304, 1184, 16},
    // 60 seconds
    // elapsed: 1 minutes
    { 272, 1368, 88},
    { 184, 1608, 144},
    { 104, 1456, 400},
    { 136, 1040, 296},
    { 144, 984, 160},
    { 136, 944, 232},
    { 128, 672, 304},
    { 160, 584, 112},
    { 216, 608, 80},
    { 248, 616, 104},
    { 272, 680, 56},
    { 320, 864, 64},
    { 320, 1016, 72},
    { 320, 1248, 104},
    { 128, 1200, -32},
    { 136, 1440, -64},
    { 120, 1312, 200},
    { -64, 1192, 264},
    { 40, 1048, 48},
    { 56, 840, -16},
    { 144, 784, 48},
    { 160, 616, 64},
    { 168, 600, 32},
    { 216, 544, 8},
    { 232, 752, 8},
    // 61 seconds
    { 248, 912, -8},
    { 296, 912, 8},
    { 320, 984, -88},
    { 304, 1360, 8},
    { 336, 1432, 72},
    { 56, 1392, 296},
    { 72, 1336, 248},
    { 152, 1136, 248},
    { 136, 1120, 216},
    { 128, 848, 264},
    { 136, 608, 160},
    { 152, 608, 72},
    { 256, 560, 56},
    { 264, 560, 64},
    { 312, 720, 64},
    { 320, 808, 40},
    { 376, 1048, 16},
    { 264, 1280, -40},
    { 224, 1208, 40},
    { 88, 1376, 96},
    { 64, 1336, 160},
    { 40, 1152, 112},
    { 64, 968, 32},
    { 112, 936, 48},
    { 152, 728, 72},
    // 62 seconds
    { 176, 504, 32},
    { 200, 568, -24},
    { 176, 720, 16},
    { 208, 800, 8},
    { 248, 832, -32},
    { 304, 880, -40},
    { 312, 1072, -16},
    { 304, 1304, 48},
    { 248, 1480, 48},
    { 232, 1608, 152},
    { 136, 1336, 280},
    { 112, 1016, 248},
    { 96, 944, 208},
    { 152, 728, 240},
    { 208, 736, 120},
    { 208, 608, 88},
    { 208, 512, 64},
    { 280, 664, 104},
    { 304, 792, 80},
    { 312, 928, 64},
    { 344, 1040, 32},
    { 224, 1152, 24},
    { 184, 1184, 144},
    { 16, 1200, 16},
    { 32, 1592, 48},
    // 63 seconds
    { 0, 1280, 128},
    { 0, 960, 48},
    { 16, 856, -32},
    { 80, 760, 72},
    { 152, 584, 72},
    { 160, 608, -8},
    { 192, 664, 0},
    { 232, 736, 16},
    { 240, 888, -64},
    { 272, 944, 40},
    { 328, 984, 16},
    { 280, 1088, -48},
    { 264, 1184, -32},
    { 224, 1544, 200},
    { 104, 1408, 336},
    { 120, 1136, 232},
    { 152, 1048, 120},
    { 152, 904, 232},
    { 176, 696, 208},
    { 200, 584, 104},
    { 232, 616, 64},
    { 248, 616, 80},
    { 256, 712, 56},
    { 296, 816, 16},
    { 360, 968, -16},
    // 64 seconds
    { 264, 1064, 8},
    { 240, 1224, 88},
    { 152, 1312, 40},
    { 96, 1424, 200},
    { 56, 1360, 56},
    { 80, 992, 56},
    { 80, 896, 40},
    { 120, 824, 80},
    { 176, 632, 72},
    { 184, 560, 16},
    { 224, 608, -32},
    { 240, 744, -8},
    { 232, 888, -48},
    { 256, 904, -32},
    { 336, 912, 40},
    { 320, 1160, -80},
    { 272, 1072, 0},
    { 256, 1400, 80},
    { 168, 1480, 200},
    { 152, 1280, 224},
    { 136, 1008, 224},
    { 120, 912, 152},
    { 176, 800, 184},
    { 192, 656, 128},
    { 160, 608, 88},
    // 65 seconds
    { 192, 632, 112},
    { 240, 712, 64},
    { 272, 856, 24},
    { 312, 920, 72},
    { 320, 1080, 40},
    { 264, 1120, 32},
    { 248, 1232, 64},
    { 96, 1232, 128},
    { 24, 1408, 96},
    { 32, 1136, 112},
    { 72, 800, 8},
    { 112, 864, 8},
    { 144, 816, 72},
    { 168, 680, 40},
    { 184, 624, -16},
    { 224, 664, -40},
    { 240, 864, -32},
    { 248, 960, -56},
    { 272, 960, 8},
    { 320, 1032, 8},
    { 192, 1208, -32},
    { 280, 1264, 16},
    { 240, 1600, 280},
    { 136, 1416, 264},
    { 112, 896, 176},
    // 66 seconds
    { 120, 888, 136},
    { 160, 920, 240},
    { 192, 768, 232},
    { 160, 656, 64},
    { 152, 648, 64},
    { 176, 728, 96},
    { 248, 704, 8},
    { 336, 824, 24},
    { 368, 912, 40},
    { 312, 1080, 24},
    { 272, 1032, 64},
    { 232, 1384, -8},
    { 144, 1352, 152},
    { 72, 1328, 176},
    { 8, 1048, 128},
    { 48, 880, 48},
    { 80, 864, 48},
    { 104, 688, 64},
    { 160, 624, 72},
    { 176, 720, 40},
    { 200, 744, 32},
    { 208, 784, 24},
    { 224, 920, 8},
    { 288, 904, -32},
    { 320, 1128, -48},
    // 67 seconds
    { 272, 1208, 88},
    { 264, 1344, 64},
    { 160, 1560, 280},
    { 152, 1240, 256},
    { 152, 1024, 176},
    { 128, 976, 232},
    { 152, 840, 256},
    { 176, 664, 96},
    { 184, 632, 88},
    { 200, 568, 176},
    { 208, 720, 104},
    { 232, 872, 88},
    { 280, 896, 64},
    { 296, 904, 32},
    { 288, 968, 56},
    { 232, 1144, 40},
    { 192, 1320, -136},
    { 120, 1496, 224},
    { -168, 1432, 168},
    { -104, 1376, -152},
    { -120, 1080, 88},
    { 0, 992, 144},
    { 168, 960, -328},
    { 232, 792, -336},
    { 248, 824, -240},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

