/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured: 2015-10-03 08:58:53 local
AccelRawData *activity_sample_walk_200_pbl_25530_7(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25530_7
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 24, 16, -1032},
    { 32, 16, -1024},
    { 32, 24, -1024},
    { 24, 16, -1032},
    { 24, 0, -1024},
    { 48, 0, -1040},
    { 56, 0, -1056},
    { 72, 0, -1040},
    { 48, -16, -1032},
    { 48, -16, -1016},
    { 8, -8, -1048},
    { 8, 0, -1072},
    { 56, -32, -1040},
    { 24, -32, -1048},
    { 32, 8, -1032},
    { -40, -24, -1016},
    { 176, 0, -1096},
    { 80, -128, -952},
    { -216, 776, -952},
    { 120, 232, -1016},
    { 128, 64, -984},
    { 128, 120, -1000},
    { 24, 128, -928},
    { -32, 248, -984},
    { -112, 152, -976},
    // 1 seconds
    { -96, 280, -1032},
    { -88, 104, -912},
    { -80, 112, -1040},
    { -136, 392, -968},
    { -144, 184, -800},
    { -48, 176, -824},
    { -56, 256, -928},
    { -8, 304, -1040},
    { 8, 192, -1120},
    { 120, 88, -976},
    { 344, 120, -856},
    { 312, 304, -752},
    { 232, 352, -656},
    { 224, 384, -824},
    { 432, 728, -912},
    { 296, 496, -864},
    { 392, 784, -912},
    { 400, 824, -696},
    { 216, 528, -504},
    { 440, 936, -568},
    { 280, 728, -376},
    { 320, 720, -432},
    { 424, 912, -472},
    { 344, 736, -480},
    { 368, 760, -504},
    // 2 seconds
    { 304, 624, -480},
    { 272, 576, -520},
    { 408, 784, -584},
    { 320, 592, -456},
    { 376, 600, -464},
    { 456, 696, -512},
    { 472, 576, -408},
    { 584, 672, -416},
    { 936, 920, -424},
    { 832, 696, -216},
    { 840, 520, -168},
    { 824, 928, -440},
    { 752, 784, -208},
    { 744, 688, -192},
    { 712, 744, -136},
    { 672, 816, -176},
    { 696, 744, -160},
    { 664, 608, -160},
    { 640, 536, -72},
    { 648, 624, -64},
    { 600, 624, -112},
    { 544, 552, -104},
    { 512, 504, -136},
    { 520, 480, -128},
    { 704, 488, -80},
    // 3 seconds
    { 920, 232, 48},
    { 1384, 176, 288},
    { 1504, 368, 112},
    { 1040, 512, -80},
    { 872, 328, -112},
    { 1152, 360, 64},
    { 952, 384, 152},
    { 816, 328, 120},
    { 760, 432, -32},
    { 640, 320, 96},
    { 800, 336, 56},
    { 784, 288, 80},
    { 880, 376, -8},
    { 984, 392, -104},
    { 1168, 384, -144},
    { 1376, 312, 16},
    { 1608, 456, 48},
    { 1408, 568, 16},
    { 680, 456, -72},
    { 832, 288, 80},
    { 1072, 168, 168},
    { 1072, 144, 272},
    { 880, 88, 256},
    { 784, 80, 168},
    { 712, 136, 88},
    // 4 seconds
    { 704, 80, 152},
    { 712, 88, 64},
    { 712, 24, 32},
    { 896, 80, -48},
    { 1192, 104, -80},
    { 1720, -40, 72},
    { 1744, 176, -64},
    { 1032, 584, -472},
    { 640, 368, -208},
    { 936, 32, -40},
    { 904, 208, 216},
    { 800, 96, 216},
    { 784, 200, 176},
    { 728, 320, 40},
    { 704, 336, 8},
    { 776, 368, -72},
    { 920, 248, 16},
    { 1040, 296, -40},
    { 1344, 336, -64},
    { 1584, 152, 112},
    { 1704, 592, 104},
    { 936, 736, 72},
    { 896, 400, -80},
    { 1032, 128, 272},
    { 936, 0, 208},
    // 5 seconds
    { 968, 184, 296},
    { 920, 184, 176},
    { 784, 160, 160},
    { 736, 64, 224},
    { 656, 64, 128},
    { 640, 0, 96},
    { 776, -8, 48},
    { 1088, 80, -32},
    { 1624, -64, 112},
    { 1656, -24, 272},
    { 1048, 320, -192},
    { 840, 328, -352},
    { 1024, -56, 232},
    { 1112, 168, 296},
    { 936, 376, 200},
    { 936, 336, 168},
    { 848, 312, 168},
    { 800, 408, 80},
    { 816, 384, 80},
    { 912, 600, -48},
    { 1192, 568, -64},
    { 1368, 584, -24},
    { 1864, 560, 104},
    { 1736, 480, 24},
    { 992, 352, -32},
    // 6 seconds
    { 1360, 104, -288},
    { 1304, 128, 128},
    { 1360, 112, 232},
    { 1184, 88, 312},
    { 1040, 64, 240},
    { 832, 72, 112},
    { 736, 56, 112},
    { 640, 16, 96},
    { 560, -32, 64},
    { 616, -48, 8},
    { 880, 152, -336},
    { 1072, 16, -160},
    { 1592, -216, 336},
    { 1640, 240, 184},
    { 1344, 456, 0},
    { 1240, 520, 48},
    { 1168, 448, 168},
    { 1120, 368, 232},
    { 1080, 400, 216},
    { 936, 472, 160},
    { 768, 536, 24},
    { 768, 472, -64},
    { 856, 464, -128},
    { 1064, 440, -88},
    { 1392, 400, -112},
    // 7 seconds
    { 1912, 392, -24},
    { 1904, 304, 24},
    { 1160, 160, 80},
    { 952, 136, -8},
    { 1200, 160, 112},
    { 1192, -24, 312},
    { 1080, 192, 184},
    { 976, 56, 200},
    { 888, 80, 240},
    { 792, 72, 176},
    { 720, 32, 144},
    { 624, 8, 56},
    { 672, -8, -16},
    { 872, 72, -184},
    { 1352, -48, -72},
    { 1520, -208, 200},
    { 1400, 96, -48},
    { 1144, 272, -232},
    { 1328, 280, 24},
    { 1440, 312, 312},
    { 1200, 464, 256},
    { 1048, 400, 296},
    { 952, 384, 192},
    { 864, 312, 144},
    { 888, 440, 40},
    // 8 seconds
    { 888, 504, -16},
    { 960, 528, -56},
    { 1248, 536, -24},
    { 1744, 664, 96},
    { 1672, 600, 168},
    { 1096, 344, 96},
    { 1216, 256, 120},
    { 1440, 168, 272},
    { 1416, 120, 336},
    { 1216, 88, 304},
    { 1096, 16, 296},
    { 1000, 24, 256},
    { 888, 32, 216},
    { 776, 40, 144},
    { 688, 0, 88},
    { 680, -64, 8},
    { 840, 32, -144},
    { 1280, -184, 112},
    { 1392, -80, 128},
    { 1144, 312, -192},
    { 1144, 448, -352},
    { 1408, 184, 152},
    { 1424, 320, 248},
    { 1232, 400, 296},
    { 1032, 408, 248},
    // 9 seconds
    { 968, 376, 224},
    { 912, 384, 136},
    { 904, 376, 144},
    { 872, 488, 80},
    { 1096, 560, 48},
    { 1232, 680, 128},
    { 1624, 704, 144},
    { 1560, 560, 120},
    { 912, 416, 56},
    { 1128, 328, 80},
    { 1656, 144, 0},
    { 1416, 144, 424},
    { 1168, 128, 224},
    { 1024, 40, 256},
    { 912, 56, 168},
    { 824, 16, 256},
    { 696, 0, 176},
    { 640, -32, 120},
    { 776, 24, -48},
    { 944, 168, -288},
    { 1456, -152, 80},
    { 1608, -120, 328},
    { 1216, 144, 112},
    { 984, 256, -48},
    { 1240, 224, 136},
    // 10 seconds
    { 1192, 304, 304},
    { 1160, 400, 288},
    { 1080, 448, 232},
    { 936, 360, 224},
    { 848, 368, 16},
    { 856, 304, 8},
    { 952, 440, -48},
    { 1200, 536, -8},
    { 1272, 528, 56},
    { 1736, 632, 152},
    { 1440, 480, 136},
    { 864, 320, 88},
    { 1240, 264, 264},
    { 1624, 160, 312},
    { 1408, 16, 384},
    { 1128, 8, 304},
    { 1008, 72, 120},
    { 880, 72, 96},
    { 752, 40, 120},
    { 648, 0, 112},
    { 568, -56, 40},
    { 656, -64, -48},
    { 944, 16, -80},
    { 1656, -88, 176},
    { 2000, 128, 288},
    // 11 seconds
    { 1304, 280, -144},
    { 1128, 312, -184},
    { 1352, 192, 192},
    { 1200, 384, 240},
    { 968, 248, 288},
    { 864, 224, 216},
    { 840, 208, 184},
    { 800, 288, 128},
    { 800, 360, 56},
    { 904, 504, -16},
    { 1016, 440, 40},
    { 1264, 576, 56},
    { 1680, 552, 168},
    { 1640, 552, 160},
    { 1160, 504, 88},
    { 1208, 368, 160},
    { 1472, 264, 232},
    { 1368, 120, 304},
    { 1224, 88, 304},
    { 1032, -16, 328},
    { 912, 24, 184},
    { 784, 32, 120},
    { 656, 16, 96},
    { 520, -8, 48},
    { 528, -80, 24},
    // 12 seconds
    { 776, 16, -112},
    { 1216, -24, 16},
    { 1744, -80, 352},
    { 1560, 240, 312},
    { 1360, 584, -248},
    { 1304, 472, -24},
    { 1248, 440, 336},
    { 992, 272, 328},
    { 936, 216, 272},
    { 896, 272, 200},
    { 864, 368, 136},
    { 840, 424, 104},
    { 896, 496, 56},
    { 968, 496, 24},
    { 1152, 512, 24},
    { 1336, 464, 136},
    { 1672, 592, 208},
    { 1408, 472, 192},
    { 1088, 296, 176},
    { 1344, 240, 280},
    { 1400, 248, 240},
    { 1248, 96, 328},
    { 1072, 24, 352},
    { 928, -32, 272},
    { 808, -8, 192},
    // 13 seconds
    { 720, 0, 160},
    { 648, 0, 120},
    { 640, -24, 32},
    { 792, 24, -56},
    { 952, 96, -208},
    { 1536, -104, 136},
    { 1664, -56, 304},
    { 1464, 312, -40},
    { 1296, 528, -272},
    { 1256, 360, 88},
    { 1056, 320, 256},
    { 1024, 240, 264},
    { 1016, 168, 216},
    { 936, 280, 104},
    { 888, 384, -32},
    { 832, 504, -88},
    { 896, 552, -112},
    { 1088, 544, -64},
    { 1288, 480, 24},
    { 1792, 440, 112},
    { 1664, 456, 96},
    { 1184, 296, 288},
    { 1272, 208, 152},
    { 1560, 160, 200},
    { 1408, 104, 320},
    // 14 seconds
    { 1224, 64, 280},
    { 1080, 32, 240},
    { 928, 48, 152},
    { 808, 0, 168},
    { 720, -8, 168},
    { 616, 0, 56},
    { 624, -48, -16},
    { 768, 0, -96},
    { 1152, -32, -32},
    { 1464, -80, 176},
    { 1464, 328, 120},
    { 1096, 552, -176},
    { 1264, 408, -112},
    { 1488, 352, 248},
    { 1288, 432, 280},
    { 1128, 392, 232},
    { 944, 432, 152},
    { 824, 440, -8},
    { 816, 352, 48},
    { 896, 472, -80},
    { 952, 384, -16},
    { 1200, 504, -88},
    { 1480, 408, 120},
    { 1800, 496, 200},
    { 1176, 472, 120},
    // 15 seconds
    { 664, 168, 72},
    { 1432, 224, 184},
    { 1704, 96, 296},
    { 1344, 56, 264},
    { 1064, 56, 176},
    { 872, 48, 96},
    { 712, 8, 80},
    { 608, -16, 64},
    { 512, -56, 56},
    { 496, -64, 0},
    { 744, 24, -104},
    { 1120, 80, 8},
    { 1760, 32, 272},
    { 1800, 312, 296},
    { 1304, 592, -144},
    { 1152, 520, -128},
    { 1248, 400, 208},
    { 968, 352, 200},
    { 952, 176, 232},
    { 912, 328, 168},
    { 824, 352, 64},
    { 736, 392, -32},
    { 776, 400, -32},
    { 872, 472, -64},
    { 1064, 384, -24},
    // 16 seconds
    { 1264, 328, 112},
    { 1856, 344, 200},
    { 1616, 464, 208},
    { 928, 440, 48},
    { 1120, 304, 80},
    { 1400, 200, 224},
    { 1360, 256, 216},
    { 1144, 80, 288},
    { 904, 8, 192},
    { 784, 32, 144},
    { 680, 8, 144},
    { 592, 0, 88},
    { 536, -16, 32},
    { 664, -40, -8},
    { 968, 88, -24},
    { 1576, 40, 200},
    { 1776, 72, 440},
    { 1352, 528, -40},
    { 984, 528, -400},
    { 1176, 112, 128},
    { 1120, 200, 280},
    { 1048, 440, 88},
    { 912, 576, -24},
    { 856, 464, 72},
    { 800, 408, 32},
    // 17 seconds
    { 808, 312, 112},
    { 752, 376, 48},
    { 1024, 560, 24},
    { 1200, 704, 160},
    { 1672, 536, 328},
    { 1672, 456, 352},
    { 1120, 504, 80},
    { 1064, 416, 104},
    { 1376, 192, 232},
    { 1416, 160, 168},
    { 1248, 56, 320},
    { 960, 16, 184},
    { 752, 32, 40},
    { 632, 16, 32},
    { 552, 8, -32},
    { 528, -40, -40},
    { 616, -16, 8},
    { 928, 128, -8},
    { 1352, 96, 144},
    { 1848, 56, 368},
    { 1736, 448, 288},
    { 1176, 776, -152},
    { 1096, 520, -64},
    { 1104, 240, 352},
    { 904, 256, 344},
    // 18 seconds
    { 888, 264, 248},
    { 824, 368, 104},
    { 784, 384, 88},
    { 752, 440, -64},
    { 824, 400, -64},
    { 936, 400, -40},
    { 1232, 408, -32},
    { 1392, 296, 104},
    { 1752, 352, 152},
    { 1472, 472, 96},
    { 864, 392, 56},
    { 1088, 224, 136},
    { 1304, 112, 232},
    { 1160, 80, 328},
    { 984, 56, 248},
    { 808, 72, 128},
    { 688, 88, 64},
    { 624, 72, 64},
    { 600, 32, 40},
    { 584, -16, 16},
    { 768, -48, -16},
    { 1128, 16, 16},
    { 1792, -56, 288},
    { 1856, 168, 328},
    { 1168, 640, -264},
    // 19 seconds
    { 912, 408, -184},
    { 1112, 168, 192},
    { 1016, 288, 200},
    { 936, 88, 248},
    { 888, 272, 144},
    { 800, 320, 88},
    { 832, 352, -8},
    { 888, 304, 56},
    { 936, 432, -88},
    { 1104, 360, -56},
    { 1272, 280, -24},
    { 1728, 216, 144},
    { 1576, 376, 80},
    { 872, 392, 16},
    { 968, 240, 96},
    { 1264, -16, 96},
    { 1152, 0, 448},
    { 1024, 104, 256},
    { 896, 88, 184},
    { 888, 112, 152},
    { 856, 56, 184},
    { 776, 24, 136},
    { 720, -8, 80},
    { 776, 0, -24},
    { 912, 64, -192},
    // 20 seconds
    { 1384, -96, -40},
    { 1680, -216, 344},
    { 1288, 288, 0},
    { 1048, 488, -336},
    { 1088, 200, 48},
    { 1088, 224, 264},
    { 968, 200, 264},
    { 944, 264, 240},
    { 864, 416, 136},
    { 792, 456, 32},
    { 800, 416, 8},
    { 936, 400, -16},
    { 1064, 352, -16},
    { 1216, 456, -48},
    { 1720, 480, 88},
    { 1600, 536, 104},
    { 1016, 336, 80},
    { 1176, 232, 152},
    { 1520, -240, 136},
    { 1232, 40, 344},
    { 1128, 160, 176},
    { 984, 56, 248},
    { 856, 64, 152},
    { 816, 32, 152},
    { 704, 24, 64},
    // 21 seconds
    { 632, -80, 88},
    { 648, -112, 16},
    { 872, -8, -96},
    { 1368, -64, 32},
    { 1704, -112, 344},
    { 1504, 232, -48},
    { 1328, 448, -352},
    { 1360, 240, 40},
    { 1304, 176, 496},
    { 952, 168, 328},
    { 1056, 136, 272},
    { 880, 312, 80},
    { 824, 312, 40},
    { 848, 424, -112},
    { 864, 456, -64},
    { 1040, 448, -80},
    { 1264, 248, -72},
    { 1544, 200, -24},
    { 1848, 320, 16},
    { 1512, 376, 8},
    { 1016, 248, -8},
    { 1168, 400, 56},
    { 1688, 184, 344},
    { 1424, 104, 184},
    { 1096, 24, 120},
    // 22 seconds
    { 944, 0, 64},
    { 792, -48, 96},
    { 672, -16, 72},
    { 576, -24, 72},
    { 496, -72, 8},
    { 600, -40, -120},
    { 864, 0, -128},
    { 1544, -128, 96},
    { 1928, 8, 376},
    { 1456, 432, -96},
    { 1304, 488, -352},
    { 1408, 352, -64},
    { 1192, 352, 48},
    { 1104, 352, 112},
    { 952, 392, 48},
    { 824, 328, 128},
    { 760, 424, 32},
    { 776, 424, -8},
    { 936, 456, -64},
    { 1088, 400, 0},
    { 1296, 360, -16},
    { 1472, 208, 24},
    { 1520, 328, -24},
    { 1280, 304, 32},
    { 1048, 320, 80},
    // 23 seconds
    { 1256, 152, 192},
    { 1224, 168, 272},
    { 1112, 136, 312},
    { 1056, 120, 304},
    { 912, -8, 304},
    { 792, 24, 120},
    { 720, -32, 112},
    { 680, -24, 16},
    { 656, -160, 16},
    { 896, -24, -88},
    { 1528, -120, 128},
    { 1792, 72, 384},
    { 1392, 384, 64},
    { 1264, 448, -312},
    { 1240, 464, 24},
    { 1104, 416, 272},
    { 944, 328, 256},
    { 848, 240, 200},
    { 800, 272, 168},
    { 792, 320, 96},
    { 832, 384, -48},
    { 848, 320, 48},
    { 1080, 512, 112},
    { 1360, 728, 128},
    { 1752, 656, 304},
    // 24 seconds
    { 1736, 560, 288},
    { 936, 352, 200},
    { 1096, 272, 184},
    { 1392, 128, 280},
    { 1320, -16, 440},
    { 1176, 64, 304},
    { 1016, 64, 168},
    { 840, -8, 216},
    { 680, 24, 120},
    { 608, -32, 112},
    { 584, -32, 16},
    { 688, -24, -96},
    { 888, 16, -88},
    { 1408, -120, 120},
    { 2016, -96, 416},
    { 1656, 416, 48},
    { 1272, 600, -240},
    { 1224, 496, 40},
    { 1000, 232, 272},
    { 976, 96, 280},
    { 984, 96, 240},
    { 912, 264, 144},
    { 840, 352, 48},
    { 824, 384, -8},
    { 904, 448, -80},
    // 25 seconds
    { 1000, 376, 0},
    { 1248, 520, -104},
    { 1504, 392, 24},
    { 1608, 400, 80},
    { 1280, 424, 48},
    { 1136, 248, 176},
    { 1296, 216, 312},
    { 1224, 0, 488},
    { 1152, 96, 376},
    { 1016, 144, 216},
    { 952, 16, 272},
    { 920, 32, 200},
    { 864, 8, 144},
    { 736, 0, 112},
    { 656, 8, -32},
    { 792, 24, -168},
    { 976, -56, -120},
    { 1520, -192, 176},
    { 1360, 56, 112},
    { 1248, 216, -56},
    { 1272, 48, 32},
    { 1352, 216, 280},
    { 1216, 360, 312},
    { 1120, 472, 256},
    { 904, 464, 176},
    // 26 seconds
    { 848, 416, 152},
    { 800, 360, 96},
    { 904, 432, -80},
    { 952, 456, -24},
    { 1104, 680, -136},
    { 1400, 584, 32},
    { 1776, 592, 112},
    { 1504, 536, 32},
    { 1152, 400, 88},
    { 1408, 232, 280},
    { 1432, 80, 272},
    { 1152, 96, 248},
    { 920, 72, 224},
    { 848, 64, 128},
    { 792, 80, 104},
    { 712, 24, 120},
    { 648, -24, 88},
    { 608, -88, 48},
    { 768, -72, -8},
    { 992, -8, -72},
    { 1520, -32, 168},
    { 1592, 232, 168},
    { 1272, 544, -24},
    { 1264, 504, 72},
    { 1224, 520, 208},
    // 27 seconds
    { 1032, 488, 112},
    { 960, 448, 88},
    { 888, 376, 136},
    { 808, 440, 48},
    { 840, 312, 24},
    { 872, 448, -56},
    { 960, 528, -120},
    { 1232, 520, -88},
    { 1264, 448, 48},
    { 1640, 432, 96},
    { 1600, 416, 168},
    { 1040, 288, 168},
    { 1152, 160, 216},
    { 1480, 168, 272},
    { 1344, 16, 376},
    { 1128, 48, 296},
    { 952, 96, 144},
    { 856, 96, 96},
    { 784, 8, 152},
    { 656, 0, 64},
    { 592, -72, 32},
    { 640, -104, -32},
    { 872, 32, -112},
    { 1360, -48, 160},
    { 1592, 184, 360},
    // 28 seconds
    { 1344, 416, 40},
    { 1392, 664, -264},
    { 1344, 704, 232},
    { 968, 544, 240},
    { 960, 176, 232},
    { 880, 128, 232},
    { 872, 192, 160},
    { 784, 256, 72},
    { 872, 440, -56},
    { 912, 416, 16},
    { 1160, 592, -40},
    { 1304, 512, 32},
    { 1696, 552, 152},
    { 1736, 512, 272},
    { 1000, 400, 192},
    { 1160, 176, 216},
    { 1272, 208, 392},
    { 1224, 80, 360},
    { 1104, 16, 408},
    { 936, 0, 296},
    { 840, 56, 160},
    { 776, 0, 152},
    { 712, 0, 96},
    { 656, -72, 72},
    { 704, -88, 16},
    // 29 seconds
    { 888, -24, -64},
    { 1272, -32, -8},
    { 1672, -104, 352},
    { 1520, 336, 152},
    { 1384, 576, -216},
    { 1336, 384, 48},
    { 1144, 392, 280},
    { 968, 208, 256},
    { 960, 208, 184},
    { 880, 288, 152},
    { 800, 352, 48},
    { 792, 384, -40},
    { 888, 400, -32},
    { 1008, 472, -80},
    { 1288, 536, -104},
    { 1360, 344, 128},
    { 1728, 384, 136},
    { 1288, 320, 176},
    { 1136, 184, 208},
    { 1456, 200, 312},
    { 1488, 152, 424},
    { 1256, 112, 280},
    { 1040, 48, 208},
    { 896, 80, 152},
    { 800, 8, 152},
    // 30 seconds
    { 672, -8, 96},
    { 576, -72, 56},
    { 568, -168, 72},
    { 808, -40, -48},
    { 1184, -56, 16},
    { 1648, -48, 280},
    { 1640, 296, 96},
    { 1656, 544, -152},
    { 1472, 320, 192},
    { 1096, 376, 360},
    { 976, 272, 288},
    { 936, 136, 264},
    { 928, 216, 240},
    { 880, 360, 144},
    { 832, 456, -40},
    { 880, 576, -64},
    { 1080, 632, -24},
    { 1216, 544, -16},
    { 1240, 264, 112},
    { 1608, 232, 168},
    { 1544, 328, 104},
    { 1088, 304, 88},
    { 1360, 160, 96},
    { 1616, -112, 408},
    { 1320, -8, 328},
    // 31 seconds
    { 1080, 8, 232},
    { 944, 8, 160},
    { 816, -8, 168},
    { 656, -24, 88},
    { 576, -48, 32},
    { 544, -48, -32},
    { 752, 0, -112},
    { 1040, 64, -160},
    { 1672, -232, 256},
    { 1888, 16, 368},
    { 1672, 424, -32},
    { 1520, 496, -56},
    { 1232, 576, 232},
    { 840, 240, 296},
    { 896, 40, 288},
    { 896, 128, 240},
    { 824, 288, 160},
    { 824, 368, 8},
    { 888, 448, -80},
    { 928, 472, -120},
    { 1168, 432, -80},
    { 1352, 272, 96},
    { 1896, 224, 168},
    { 1464, 384, 112},
    { 928, 320, 96},
    // 32 seconds
    { 1216, 152, 192},
    { 1520, -152, 584},
    { 1096, -152, 528},
    { 1104, 88, 216},
    { 960, -24, 216},
    { 920, 64, 152},
    { 864, 32, 184},
    { 744, 24, 104},
    { 688, -56, 56},
    { 768, -48, -8},
    { 1000, 136, -104},
    { 1200, -200, 8},
    { 1376, -144, 24},
    { 1272, -64, -120},
    { 1368, -40, -104},
    { 1432, 168, 128},
    { 1328, 288, 232},
    { 1200, 480, 136},
    { 992, 472, 128},
    { 904, 352, 64},
    { 864, 272, 40},
    { 896, 392, -56},
    { 1032, 392, -64},
    { 1200, 464, -80},
    { 1264, 400, 16},
    // 33 seconds
    { 1688, 376, 48},
    { 1584, 360, 88},
    { 1104, 248, 104},
    { 1280, 168, 200},
    { 1440, 64, 256},
    { 1352, 144, 272},
    { 1160, 32, 296},
    { 1024, 16, 224},
    { 912, 32, 160},
    { 840, 16, 128},
    { 720, -8, 88},
    { 648, -64, 40},
    { 656, -96, -64},
    { 800, 40, -208},
    { 1312, -200, 120},
    { 1648, -112, 352},
    { 1600, 368, -88},
    { 1464, 432, -272},
    { 1424, 376, 48},
    { 1200, 320, 288},
    { 1080, 288, 256},
    { 1000, 272, 272},
    { 888, 352, 128},
    { 816, 336, 24},
    { 864, 312, -40},
    // 34 seconds
    { 984, 304, -56},
    { 1088, 328, 0},
    { 1304, 496, -72},
    { 1840, 520, 24},
    { 1672, 584, 96},
    { 1032, 320, 40},
    { 1168, 224, 16},
    { 1608, 200, 88},
    { 1424, 64, 400},
    { 1264, 96, 224},
    { 1104, -64, 328},
    { 904, -56, 264},
    { 816, -72, 232},
    { 720, -40, 120},
    { 664, -56, 40},
    { 712, -24, -80},
    { 888, 120, -96},
    { 1136, -88, -136},
    { 1512, -416, 248},
    { 1480, 48, -8},
    { 1472, 304, -296},
    { 1584, 400, 40},
    { 1320, 432, 328},
    { 1080, 248, 352},
    { 904, 152, 256},
    // 35 seconds
    { 904, 248, 200},
    { 840, 384, 88},
    { 864, 424, 8},
    { 920, 512, -32},
    { 1072, 456, 24},
    { 1240, 464, 32},
    { 1528, 448, 64},
    { 1576, 488, 88},
    { 1144, 384, 128},
    { 1264, 224, 208},
    { 1448, 104, 280},
    { 1392, 32, 376},
    { 1224, 104, 256},
    { 1104, 56, 208},
    { 1008, 56, 224},
    { 944, 32, 160},
    { 904, 0, 120},
    { 816, -24, 72},
    { 792, -112, 8},
    { 800, -64, -112},
    { 952, -24, -160},
    { 1344, -200, 216},
    { 1336, 216, 96},
    { 1296, 384, -144},
    { 1376, 240, 48},
    // 36 seconds
    { 1376, 320, 304},
    { 1256, 384, 288},
    { 1168, 448, 320},
    { 984, 568, 192},
    { 856, 384, 128},
    { 816, 344, 40},
    { 920, 344, 16},
    { 1120, 464, -48},
    { 1256, 568, -120},
    { 1616, 528, -32},
    { 1784, 528, 72},
    { 1200, 344, 120},
    { 1280, 192, 160},
    { 1896, 16, -304},
    { 1552, 144, 784},
    { 1136, 112, 248},
    { 1056, 88, 224},
    { 968, 40, 184},
    { 968, 64, 160},
    { 832, 48, 96},
    { 720, -24, 96},
    { 616, -96, 16},
    { 648, -56, -128},
    { 1000, -64, -168},
    { 1472, -192, 136},
    // 37 seconds
    { 1496, 120, 184},
    { 1376, 336, -152},
    { 1440, 264, -72},
    { 1440, 304, 296},
    { 1248, 400, 336},
    { 1152, 480, 272},
    { 984, 456, 216},
    { 832, 368, 152},
    { 816, 344, 48},
    { 888, 400, -16},
    { 992, 376, 8},
    { 1152, 456, -48},
    { 1328, 400, 64},
    { 1896, 440, 112},
    { 1624, 392, 112},
    { 1032, 312, 40},
    { 1224, 200, 136},
    { 1432, 96, 232},
    { 1320, 96, 232},
    { 1120, 16, 304},
    { 944, 0, 248},
    { 832, 32, 168},
    { 776, 16, 144},
    { 688, 32, 96},
    { 664, -8, 80},
    // 38 seconds
    { 744, -64, 0},
    { 920, -16, -104},
    { 1264, -96, 0},
    { 1592, -232, 328},
    { 1448, 192, 96},
    { 1320, 392, -200},
    { 1288, 304, -48},
    { 1176, 240, 264},
    { 1072, 328, 216},
    { 1016, 288, 264},
    { 904, 360, 120},
    { 856, 304, 80},
    { 824, 360, -16},
    { 904, 392, -64},
    { 1088, 384, -56},
    { 1240, 344, -56},
    { 1592, 304, 48},
    { 1736, 472, 96},
    { 1088, 424, 120},
    { 1072, 192, 136},
    { 1368, 144, 200},
    { 1368, 24, 312},
    { 1184, 96, 176},
    { 1088, 72, 176},
    { 976, 40, 160},
    // 39 seconds
    { 856, 32, 112},
    { 744, -8, 112},
    { 664, -56, 80},
    { 680, -96, 8},
    { 864, 0, -88},
    { 1128, -56, -56},
    { 1528, -208, 360},
    { 1432, 208, 248},
    { 1320, 560, -24},
    { 1184, 488, 0},
    { 1080, 328, 304},
    { 960, 184, 320},
    { 976, 208, 344},
    { 952, 384, 224},
    { 888, 392, 168},
    { 872, 456, 40},
    { 912, 456, -16},
    { 1120, 400, 0},
    { 1216, 400, 40},
    { 1616, 448, 160},
    { 1584, 552, 160},
    { 1048, 440, 88},
    { 1160, 248, 160},
    { 1360, 144, 272},
    { 1288, 168, 280},
    // 40 seconds
    { 1128, 40, 264},
    { 984, 56, 216},
    { 936, 32, 160},
    { 880, 24, 144},
    { 776, 16, 112},
    { 664, -40, 112},
    { 680, -64, 16},
    { 832, 40, -160},
    { 1088, -32, -120},
    { 1544, -248, 176},
    { 1400, 32, 136},
    { 1520, 280, -8},
    { 1488, 360, 112},
    { 1112, 464, 336},
    { 976, 408, 248},
    { 968, 224, 336},
    { 880, 304, 248},
    { 824, 328, 144},
    { 872, 440, 24},
    { 904, 528, -16},
    { 1080, 496, 32},
    { 1272, 416, 80},
    { 1584, 400, 144},
    { 1624, 456, 112},
    { 1032, 368, 112},
    // 41 seconds
    { 1184, 240, 208},
    { 1392, 112, 280},
    { 1288, 136, 224},
    { 1104, 88, 240},
    { 1000, 88, 144},
    { 912, 8, 176},
    { 848, -8, 144},
    { 792, 0, 64},
    { 696, -56, 64},
    { 736, -88, -8},
    { 856, 16, -160},
    { 1264, -112, -32},
    { 1536, -192, 272},
    { 1432, 184, 88},
    { 1368, 280, -160},
    { 1344, 248, 96},
    { 1112, 392, 256},
    { 1040, 328, 256},
    { 968, 352, 168},
    { 904, 384, 104},
    { 840, 416, -8},
    { 848, 376, 24},
    { 872, 504, -80},
    { 1104, 472, -64},
    { 1232, 496, -48},
    // 42 seconds
    { 1648, 464, 48},
    { 1656, 512, 80},
    { 1072, 376, 64},
    { 1176, 304, 72},
    { 1600, 232, 24},
    { 1368, 64, 352},
    { 1232, 136, 176},
    { 1016, 56, 216},
    { 904, 56, 144},
    { 888, 0, 144},
    { 752, -16, 104},
    { 632, -72, 72},
    { 568, -88, -32},
    { 744, -8, -112},
    { 1024, 48, -144},
    { 1584, -168, 256},
    { 1712, 88, 328},
    { 1400, 416, -56},
    { 1368, 408, -80},
    { 1280, 448, 232},
    { 952, 272, 312},
    { 968, 152, 264},
    { 952, 256, 128},
    { 872, 336, 48},
    { 864, 400, -40},
    // 43 seconds
    { 912, 456, -80},
    { 1048, 384, 24},
    { 1256, 408, -56},
    { 1376, 296, 104},
    { 1736, 352, 120},
    { 1344, 384, 88},
    { 1096, 224, 160},
    { 1440, 80, 136},
    { 1368, -16, 400},
    { 1192, 88, 248},
    { 1040, 80, 216},
    { 952, 48, 200},
    { 864, 32, 152},
    { 784, 8, 120},
    { 672, -32, 104},
    { 640, -96, 64},
    { 776, -40, -32},
    { 992, -48, -48},
    { 1536, -160, 192},
    { 1544, 64, 200},
    { 1328, 344, -104},
    { 1272, 312, -152},
    { 1248, 232, 232},
    { 1144, 280, 240},
    { 1080, 328, 264},
    // 44 seconds
    { 960, 384, 152},
    { 888, 328, 80},
    { 864, 352, -16},
    { 896, 400, -48},
    { 1024, 416, 8},
    { 1208, 432, -32},
    { 1480, 376, 104},
    { 1784, 472, 176},
    { 1184, 320, 136},
    { 1000, 272, 24},
    { 1456, 112, -16},
    { 1352, 16, 296},
    { 1216, 120, 136},
    { 1072, 48, 232},
    { 952, 8, 208},
    { 848, 24, 144},
    { 752, 16, 104},
    { 656, -24, 104},
    { 624, -72, 48},
    { 784, -40, -8},
    { 1016, 32, -128},
    { 1520, -160, 192},
    { 1504, -24, 312},
    { 1376, 272, 48},
    { 1344, 392, -128},
    // 45 seconds
    { 1216, 392, 144},
    { 1016, 296, 232},
    { 1008, 232, 288},
    { 952, 280, 192},
    { 912, 296, 136},
    { 840, 360, 8},
    { 904, 384, 0},
    { 1008, 440, 16},
    { 1176, 432, -24},
    { 1304, 416, 64},
    { 1808, 480, 128},
    { 1360, 440, 112},
    { 1056, 216, 112},
    { 1288, 128, 232},
    { 1224, -88, 440},
    { 1224, 160, 208},
    { 1096, 88, 200},
    { 976, 96, 160},
    { 872, 48, 152},
    { 784, 0, 152},
    { 656, -48, 112},
    { 584, -72, 56},
    { 680, -72, 8},
    { 888, 40, -88},
    { 1496, -104, 120},
    // 46 seconds
    { 1648, -24, 360},
    { 1440, 336, 56},
    { 1320, 400, -136},
    { 1280, 376, 152},
    { 1032, 304, 264},
    { 1024, 256, 224},
    { 968, 224, 232},
    { 912, 376, 64},
    { 864, 320, 40},
    { 864, 400, -48},
    { 936, 344, 16},
    { 1200, 440, -32},
    { 1312, 440, 40},
    { 1808, 520, 144},
    { 1592, 440, 56},
    { 1024, 312, 24},
    { 1168, 304, 56},
    { 1432, 152, 232},
    { 1336, 96, 320},
    { 1136, 40, 352},
    { 952, -16, 288},
    { 856, 88, 144},
    { 808, 72, 152},
    { 728, 24, 136},
    { 640, -64, 120},
    // 47 seconds
    { 648, -136, 48},
    { 856, -32, -56},
    { 1280, -80, 8},
    { 1608, -104, 272},
    { 1408, 272, 96},
    { 1448, 480, -264},
    { 1560, 328, 40},
    { 1320, 480, 320},
    { 1000, 360, 304},
    { 904, 112, 288},
    { 880, 240, 104},
    { 848, 368, 72},
    { 896, 480, -24},
    { 912, 504, -48},
    { 1128, 480, 16},
    { 1312, 456, 32},
    { 1512, 368, 64},
    { 1616, 328, 176},
    { 1136, 328, 168},
    { 1208, 208, 176},
    { 1456, 104, 272},
    { 1360, 72, 352},
    { 1120, 56, 288},
    { 1000, 80, 168},
    { 920, 40, 176},
    // 48 seconds
    { 816, 0, 192},
    { 728, -32, 160},
    { 616, -88, 136},
    { 696, -112, 112},
    { 912, 64, -120},
    { 1424, -64, 0},
    { 1616, -152, 320},
    { 1264, 176, -8},
    { 1368, 392, -304},
    { 1448, 432, 40},
    { 1296, 448, 264},
    { 1072, 472, 264},
    { 912, 304, 256},
    { 832, 296, 152},
    { 816, 288, 120},
    { 840, 376, 32},
    { 872, 384, 24},
    { 1064, 432, 0},
    { 1248, 416, 48},
    { 1632, 432, 144},
    { 1600, 464, 152},
    { 1032, 392, 80},
    { 1128, 272, 128},
    { 1360, 152, 248},
    { 1408, 104, 288},
    // 49 seconds
    { 1224, 56, 264},
    { 1048, 40, 208},
    { 936, 64, 120},
    { 864, 24, 120},
    { 768, 0, 112},
    { 688, -32, 64},
    { 688, -104, 0},
    { 872, -32, -88},
    { 1264, -160, 56},
    { 1640, -184, 344},
    { 1432, 264, 96},
    { 1280, 392, -152},
    { 1272, 176, 80},
    { 1224, 240, 352},
    { 1144, 336, 280},
    { 1048, 360, 280},
    { 872, 392, 64},
    { 816, 320, 16},
    { 848, 392, -104},
    { 928, 424, -120},
    { 1072, 384, 8},
    { 1240, 368, -40},
    { 1568, 344, 96},
    { 1872, 424, 168},
    { 1152, 320, 96},
    // 50 seconds
    { 984, 184, 40},
    { 1408, 72, 184},
    { 1512, -16, 320},
    { 1216, 56, 240},
    { 1032, 64, 120},
    { 880, 40, 104},
    { 720, 16, 120},
    { 624, 8, 56},
    { 568, -24, 0},
    { 600, -32, -8},
    { 880, 24, -80},
    { 1064, 24, -88},
    { 1744, -208, 256},
    { 1688, 48, 272},
    { 1472, 376, -48},
    { 1224, 400, -112},
    { 1072, 328, 176},
    { 1008, 192, 272},
    { 1016, 192, 296},
    { 952, 304, 216},
    { 872, 360, 120},
    { 832, 400, 24},
    { 888, 400, -8},
    { 976, 408, -80},
    { 1192, 400, -72},
    // 51 seconds
    { 1240, 304, 40},
    { 1824, 384, 104},
    { 1496, 528, 56},
    { 1088, 304, 112},
    { 1280, 184, 216},
    { 1480, -16, 280},
    { 1264, 56, 288},
    { 1040, 48, 232},
    { 944, 64, 176},
    { 888, 32, 184},
    { 800, 0, 192},
    { 704, -16, 120},
    { 688, -72, 104},
    { 856, 72, -176},
    { 984, 96, -248},
    { 1464, -304, 264},
    { 1456, -40, 216},
    { 1224, 296, -144},
    { 1184, 128, 16},
    { 1176, 160, 256},
    { 1128, 224, 312},
    { 1152, 360, 280},
    { 1056, 432, 200},
    { 984, 344, 104},
    { 920, 328, -8},
    // 52 seconds
    { 960, 344, -64},
    { 984, 448, -96},
    { 1248, 496, -80},
    { 1536, 512, 24},
    { 1872, 600, 136},
    { 1256, 344, 88},
    { 1048, 32, 176},
    { 1248, 288, 208},
    { 1568, 112, 336},
    { 1264, 104, 248},
    { 1088, 96, 152},
    { 952, 16, 192},
    { 848, 16, 136},
    { 760, -40, 152},
    { 616, -48, 80},
    { 528, -104, 16},
    { 656, -64, -136},
    { 840, 80, -184},
    { 1296, -136, 112},
    { 1624, -152, 440},
    { 1928, 336, 368},
    { 1576, 776, 48},
    { 1096, 584, 64},
    { 1160, 312, 344},
    { 1064, 280, 352},
    // 53 seconds
    { 1056, 208, 384},
    { 960, 448, 184},
    { 808, 536, 32},
    { 784, 672, -216},
    { 912, 632, -176},
    { 1312, 616, 8},
    { 1200, 336, 160},
    { 1848, 304, 176},
    { 1496, 480, 216},
    { 1568, 328, 312},
    { 1736, 208, 304},
    { 1440, 40, 384},
    { 1064, 80, 248},
    { 888, 16, 232},
    { 800, 0, 184},
    { 744, -16, 144},
    { 648, -16, 112},
    { 536, -40, 40},
    { 600, -96, 48},
    { 848, 40, -88},
    { 968, 168, -152},
    { 1808, -104, 352},
    { 1832, 280, 336},
    { 1440, 496, -72},
    { 1144, 440, -152},
    // 54 seconds
    { 1152, 256, 72},
    { 888, 224, 256},
    { 984, 312, 240},
    { 952, 432, 216},
    { 920, 472, 192},
    { 936, 528, 40},
    { 984, 448, 48},
    { 1168, 504, -16},
    { 1312, 488, -32},
    { 1720, 528, 40},
    { 1760, 536, 120},
    { 1288, 272, 176},
    { 1296, 136, 240},
    { 1536, 224, 80},
    { 1312, 40, 504},
    { 1184, 128, 224},
    { 1048, 24, 312},
    { 928, 40, 264},
    { 840, 8, 256},
    { 744, -16, 160},
    { 696, -48, 96},
    { 712, -104, 40},
    { 792, -56, 24},
    { 1496, -104, 64},
    { 1592, -8, -56},
    // 55 seconds
    { 1424, -40, -88},
    { 1384, 40, -96},
    { 1456, 248, -8},
    { 1432, 320, 176},
    { 1320, 608, 192},
    { 1064, 688, 272},
    { 856, 296, 120},
    { 880, 240, 80},
    { 928, 312, -24},
    { 944, 344, -96},
    { 1080, 472, -168},
    { 1264, 480, -24},
    { 1896, 512, 72},
    { 1608, 504, 216},
    { 1264, 248, 160},
    { 1288, 248, 104},
    { 1416, 216, 232},
    { 1376, 96, 320},
    { 1248, 56, 304},
    { 1144, -8, 288},
    { 1000, -48, 240},
    { 920, -40, 192},
    { 880, -40, 128},
    { 856, -104, 40},
    { 888, -40, -72},
    // 56 seconds
    { 960, -32, -120},
    { 1384, -248, 128},
    { 1312, -128, 272},
    { 1352, 128, 40},
    { 1464, 240, -24},
    { 1504, 312, 200},
    { 1392, 320, 304},
    { 1280, 400, 416},
    { 1136, 448, 392},
    { 952, 336, 152},
    { 952, 336, 72},
    { 1040, 440, 0},
    { 1088, 472, -88},
    { 1256, 544, -136},
    { 1496, 528, -48},
    { 1744, 576, -48},
    { 1280, 472, -96},
    { 1360, 288, 16},
    { 1672, -32, 248},
    { 1528, 24, 320},
    { 1368, 64, 352},
    { 1072, -32, 304},
    { 880, -32, 280},
    { 680, 16, 200},
    { 568, -16, 96},
    // 57 seconds
    { 568, -24, 24},
    { 736, 64, -80},
    { 976, 48, -128},
    { 1280, -200, 120},
    { 1720, -280, 376},
    { 1704, 168, 176},
    { 1400, 504, -256},
    { 1144, 320, -152},
    { 1088, 272, 136},
    { 1016, 192, 152},
    { 968, 248, 176},
    { 928, 296, 120},
    { 872, 320, 56},
    { 864, 336, 0},
    { 928, 368, -96},
    { 992, 344, -48},
    { 1304, 392, -112},
    { 1384, 320, 8},
    { 1784, 328, 32},
    { 1536, 384, 0},
    { 1024, 336, 0},
    { 1192, 168, 152},
    { 1224, -72, 312},
    { 1208, 88, 320},
    { 1056, 96, 232},
    // 58 seconds
    { 928, 64, 192},
    { 832, 72, 184},
    { 736, 32, 160},
    { 656, -8, 128},
    { 640, -8, 80},
    { 744, -16, 0},
    { 992, 8, -88},
    { 1520, -176, 176},
    { 1688, -112, 360},
    { 1296, 328, -24},
    { 1064, 496, -304},
    { 1120, 208, 72},
    { 1168, 184, 256},
    { 1056, 216, 184},
    { 1032, 256, 192},
    { 920, 376, 32},
    { 832, 344, -16},
    { 832, 320, -88},
    { 896, 320, -72},
    { 1152, 272, 16},
    { 1296, 336, -80},
    { 1880, 368, 32},
    { 1904, 344, 200},
    { 1152, 328, 32},
    { 776, 176, 72},
    // 59 seconds
    { 1248, 96, 160},
    { 1400, 48, 248},
    { 1136, 96, 232},
    { 952, 16, 192},
    { 808, -8, 168},
    { 664, 32, 144},
    { 560, 16, 104},
    { 512, -8, 56},
    { 520, 8, 0},
    { 744, 72, -80},
    { 976, 96, -136},
    { 1584, -168, 168},
    { 1976, -168, 416},
    { 1712, 320, 88},
    { 1168, 576, -216},
    { 1016, 432, -16},
    { 872, 216, 208},
    { 960, 64, 240},
    { 944, 184, 168},
    { 912, 384, 8},
    { 792, 392, -48},
    { 848, 448, -184},
    { 960, 360, -128},
    { 1080, 296, -96},
    { 1280, 216, -32},
    // 60 seconds
    // elapsed: 1 minutes
    { 1680, 240, 96},
    { 1752, 360, 144},
    { 1216, 304, 216},
    { 1232, 176, 168},
    { 1328, 96, 216},
    { 1208, 128, 288},
    { 1080, 96, 248},
    { 968, 104, 136},
    { 968, 8, 208},
    { 848, 32, 96},
    { 672, 40, 40},
    { 568, 8, 24},
    { 560, -40, -24},
    { 712, 24, -160},
    { 1040, -72, -64},
    { 1680, -296, 408},
    { 1744, 160, 288},
    { 1544, 472, -128},
    { 1184, 392, -96},
    { 1024, 248, 232},
    { 1080, 104, 328},
    { 1072, 184, 304},
    { 1040, 312, 184},
    { 976, 400, 80},
    { 808, 432, -136},
    // 61 seconds
    { 872, 360, -216},
    { 1016, 248, -48},
    { 1256, 408, 16},
    { 1200, 400, 144},
    { 1800, 328, 216},
    { 1680, 352, 216},
    { 1256, 184, 192},
    { 1224, 136, 136},
    { 1384, 160, 216},
    { 1296, 128, 296},
    { 1048, -16, 272},
    { 888, -32, 192},
    { 800, -40, 192},
    { 712, 8, 128},
    { 608, -16, 112},
    { 584, -24, 56},
    { 680, -16, -24},
    { 920, 128, -208},
    { 1336, -96, 16},
    { 1904, -264, 416},
    { 1600, 272, 56},
    { 1352, 480, -272},
    { 1392, 256, 16},
    { 1072, 216, 328},
    { 1024, 184, 296},
    // 62 seconds
    { 960, 232, 224},
    { 904, 328, 168},
    { 832, 464, 8},
    { 808, 392, 16},
    { 840, 520, -96},
    { 1112, 400, -32},
    { 1256, 448, -8},
    { 1928, 376, 160},
    { 1664, 352, 152},
    { 1240, 160, 200},
    { 1120, 200, 232},
    { 1592, 144, 72},
    { 1352, 32, 384},
    { 1128, 8, 176},
    { 968, 32, 160},
    { 856, 32, 184},
    { 768, 8, 144},
    { 656, -56, 128},
    { 592, -72, 96},
    { 664, -40, 0},
    { 784, 16, -120},
    { 1416, -152, 48},
    { 1792, -184, 352},
    { 1728, 272, 152},
    { 1416, 472, -216},
    // 63 seconds
    { 1344, 200, 104},
    { 1264, 320, 336},
    { 1136, 352, 336},
    { 984, 368, 248},
    { 824, 376, 48},
    { 792, 384, -16},
    { 912, 448, -96},
    { 984, 432, -104},
    { 1232, 400, -88},
    { 1304, 240, 96},
    { 2120, 312, 112},
    { 1368, 336, 200},
    { 1296, 216, 80},
    { 1432, 112, 232},
    { 1488, 120, 272},
    { 1296, 72, 248},
    { 1056, -16, 224},
    { 880, -40, 208},
    { 768, 0, 192},
    { 680, -16, 144},
    { 600, -32, 104},
    { 624, -16, 40},
    { 816, -8, 24},
    { 976, 40, -104},
    { 1440, -120, 40},
    // 64 seconds
    { 1728, -176, 352},
    { 1568, 248, 128},
    { 1392, 456, -192},
    { 1272, 304, -24},
    { 1008, 288, 208},
    { 960, 200, 224},
    { 968, 232, 152},
    { 912, 288, 96},
    { 848, 352, 8},
    { 912, 408, -48},
    { 960, 408, -48},
    { 1184, 400, -64},
    { 1296, 360, -8},
    { 1768, 352, 112},
    { 1656, 384, 136},
    { 1056, 264, 152},
    { 1200, 168, 200},
    { 1440, 336, 72},
    { 1232, 16, 416},
    { 1088, -8, 168},
    { 992, -16, 256},
    { 928, 56, 168},
    { 872, 24, 192},
    { 752, -8, 128},
    { 664, -56, 88},
    // 65 seconds
    { 752, -88, 16},
    { 888, 32, -144},
    { 1424, -168, 72},
    { 1544, -128, 352},
    { 1472, 208, 144},
    { 1368, 376, -160},
    { 1232, 248, 64},
    { 1112, 208, 328},
    { 1136, 320, 280},
    { 1032, 336, 280},
    { 928, 344, 120},
    { 864, 352, 0},
    { 944, 408, -64},
    { 1112, 456, -104},
    { 1288, 392, -24},
    { 1352, 200, 56},
    { 1744, 176, 88},
    { 1464, 376, 32},
    { 1072, 272, 96},
    { 1152, 184, 152},
    { 1264, 40, 344},
    { 1376, 0, 344},
    { 1144, -16, 320},
    { 992, -24, 240},
    { 880, 0, 192},
    // 66 seconds
    { 784, 40, 104},
    { 696, 16, 104},
    { 688, -24, 72},
    { 824, -104, 72},
    { 1048, 32, -120},
    { 1344, -32, 16},
    { 1592, -152, 312},
    { 1376, 120, 168},
    { 1352, 368, -64},
    { 1304, 360, 96},
    { 1096, 392, 216},
    { 1024, 352, 200},
    { 984, 360, 216},
    { 880, 376, 200},
    { 848, 304, 176},
    { 928, 384, 40},
    { 1032, 424, -40},
    { 1240, 456, -128},
    { 1352, 376, -128},
    { 1536, 312, -32},
    { 1528, 320, 0},
    { 1184, 336, 64},
    { 1152, 216, 184},
    { 1392, 32, 264},
    { 1224, -56, 432},
    // 67 seconds
    { 1128, 16, 320},
    { 1000, 24, 264},
    { 896, 64, 176},
    { 792, 32, 168},
    { 696, 8, 144},
    { 656, -48, 104},
    { 800, -64, 40},
    { 1016, 104, -168},
    { 1192, 0, -24},
    { 1664, -280, 352},
    { 1416, 88, 224},
    { 1352, 384, -120},
    { 1352, 328, 64},
    { 1016, 416, 224},
    { 880, 224, 224},
    { 952, 160, 288},
    { 912, 240, 208},
    { 840, 296, 120},
    { 888, 344, 32},
    { 904, 408, -32},
    { 1016, 504, -136},
    { 1248, 472, -80},
    { 1312, 344, 80},
    { 1744, 304, 128},
    { 1392, 400, 88},
    // 68 seconds
    { 1104, 248, 152},
    { 1320, 200, 184},
    { 1384, 80, 352},
    { 1168, 40, 328},
    { 1040, 48, 248},
    { 936, 48, 192},
    { 856, 56, 128},
    { 800, 16, 152},
    { 744, 16, 72},
    { 760, -16, 16},
    { 864, -32, -40},
    { 968, -72, -88},
    { 1464, -264, 192},
    { 1496, 40, 200},
    { 1392, 384, -112},
    { 1192, 264, -128},
    { 1112, 152, 160},
    { 1120, 144, 280},
    { 1104, 288, 304},
    { 968, 392, 200},
    { 864, 384, 48},
    { 896, 360, -32},
    { 1008, 392, -64},
    { 936, 392, -80},
    { 1200, 392, -32},
    // 69 seconds
    { 1344, 360, 88},
    { 1832, 464, 80},
    { 1216, 376, 120},
    { 1128, 168, 128},
    { 1504, 88, 288},
    { 1384, 96, 328},
    { 1208, 136, 192},
    { 1112, 88, 168},
    { 1016, 8, 208},
    { 896, 40, 128},
    { 800, 16, 104},
    { 664, -32, 72},
    { 632, -96, 8},
    { 728, -32, -104},
    { 944, -96, 0},
    { 1464, -136, 280},
    { 1568, 104, 248},
    { 1504, 304, 48},
    { 1336, 328, -24},
    { 1192, 328, 104},
    { 1200, 432, 168},
    { 1216, 448, 216},
    { 1120, 560, 248},
    { 904, 728, 240},
    { 808, 528, 0},
    // 70 seconds
    { 832, 512, -64},
    { 976, 512, -64},
    { 1144, 480, -32},
    { 1336, 464, 104},
    { 1712, 512, 120},
    { 1504, 528, -24},
    { 1272, 352, 48},
    { 1376, 224, 144},
    { 1408, 80, 216},
    { 1216, 40, 280},
    { 1040, 40, 256},
    { 904, 8, 216},
    { 776, 40, 152},
    { 736, 24, 152},
    { 696, 8, 96},
    { 680, -40, 64},
    { 800, -24, -56},
    { 952, 8, -168},
    { 1448, -184, 72},
    { 1512, 8, 144},
    { 1696, 328, -16},
    { 1504, 456, -120},
    { 1096, 328, 224},
    { 960, 200, 264},
    { 1072, 232, 280},
    // 71 seconds
    { 1000, 320, 200},
    { 904, 368, 112},
    { 856, 456, -56},
    { 872, 480, -64},
    { 960, 544, -56},
    { 1232, 424, -8},
    { 1312, 336, 80},
    { 1712, 312, 112},
    { 1528, 360, 56},
    { 1080, 232, 160},
    { 1400, 120, 184},
    { 1424, -8, 288},
    { 1104, 48, 256},
    { 936, 88, 144},
    { 816, 32, 152},
    { 728, 8, 136},
    { 688, 0, 136},
    { 704, 16, 96},
    { 688, 8, 64},
    { 872, -8, 16},
    { 1024, 56, -64},
    { 1360, -24, -8},
    { 1552, -64, 256},
    { 1400, 192, 200},
    { 1192, 352, -72},
    // 72 seconds
    { 1080, 352, -40},
    { 1024, 312, 152},
    { 944, 296, 128},
    { 968, 352, 144},
    { 960, 424, 104},
    { 856, 440, 40},
    { 864, 456, -32},
    { 936, 416, -32},
    { 1152, 360, -8},
    { 1256, 344, 40},
    { 1832, 336, 184},
    { 1536, 416, 96},
    { 864, 280, 72},
    { 1160, 216, 112},
    { 1296, 40, 112},
    { 1056, 40, 296},
    { 944, 128, 216},
    { 856, 88, 200},
    { 816, 72, 208},
    { 744, 40, 200},
    { 736, 40, 208},
    { 672, 64, 144},
    { 808, 112, 144},
    { 992, 288, 64},
    { 1200, 408, 152},
    // 73 seconds
    { 1464, 456, 336},
    { 1088, 944, 80},
    { 752, 960, -168},
    { 664, 800, -128},
    { 552, 616, -40},
    { 544, 552, 48},
    { 576, 640, 32},
    { 592, 640, 64},
    { 552, 584, 40},
    { 528, 584, 16},
    { 544, 664, -8},
    { 560, 648, 48},
    { 624, 688, 152},
    { 768, 936, 88},
    { 1184, 1056, 120},
    { 1224, 1208, 136},
    { 824, 776, 144},
    { 656, 592, 120},
    { 600, 568, 128},
    { 528, 472, 136},
    { 488, 440, 64},
    { 416, 384, 32},
    { 408, 376, 8},
    { 400, 408, -24},
    { 488, 384, 24},
    // 74 seconds
    { 640, 432, 40},
    { 904, 504, -8},
    { 1112, 384, 112},
    { 1616, 64, 288},
    { 1496, 336, 128},
    { 1200, 328, -40},
    { 1000, 240, 32},
    { 960, 176, 216},
    { 976, 144, 304},
    { 1024, 216, 288},
    { 1016, 224, 280},
    { 920, 352, 184},
    { 928, 312, 168},
    { 960, 336, 136},
    { 1088, 304, 232},
    { 1216, 440, 16},
    { 1176, 424, 192},
    { 1656, 888, 64},
    { 1208, 752, 48},
    { 936, 296, 72},
    { 1200, 280, 176},
    { 1360, 256, 248},
    { 1352, 168, 232},
    { 1272, 72, 264},
    { 1192, 8, 256},
    // 75 seconds
    { 1096, -56, 272},
    { 952, -48, 208},
    { 832, -24, 144},
    { 824, -64, 112},
    { 880, -64, 40},
    { 1016, -48, -64},
    { 1416, -176, 152},
    { 1192, 40, 96},
    { 1112, 208, -128},
    { 1136, 80, -96},
    { 1160, 168, 168},
    { 1200, 96, 352},
    { 1280, 360, 280},
    { 1128, 528, 152},
    { 976, 472, 176},
    { 896, 368, 88},
    { 936, 296, 56},
    { 1088, 296, 80},
    { 1232, 488, -32},
    { 1408, 592, 48},
    { 1696, 832, 64},
    { 1096, 368, 72},
    { 1200, 216, 160},
    { 1384, 144, 280},
    { 1384, 176, 224},
    // 76 seconds
    { 1128, 80, 344},
    { 1064, 112, 208},
    { 1016, 24, 256},
    { 976, 16, 224},
    { 880, 8, 192},
    { 808, -24, 176},
    { 808, -72, 144},
    { 880, -16, 16},
    { 1160, 0, -88},
    { 1488, -104, 240},
    { 1192, -8, -72},
    { 1064, 72, -312},
    { 1136, 0, -128},
    { 1192, 80, 88},
    { 1224, 104, 208},
    { 1200, 264, 304},
    { 1088, 448, 256},
    { 936, 456, 168},
    { 944, 392, 80},
    { 1016, 440, 128},
    { 1056, 280, 48},
    { 1192, 560, -40},
    { 1536, 784, 96},
    { 1784, 736, 168},
    { 1200, 440, 104},
    // 77 seconds
    { 1312, 392, 96},
    { 1880, 152, 144},
    { 1448, -136, 544},
    { 1248, -40, 296},
    { 1056, 128, 176},
    { 976, 24, 224},
    { 888, 0, 224},
    { 776, -64, 184},
    { 680, -72, 136},
    { 648, -104, 56},
    { 808, 0, -96},
    { 1072, 8, -200},
    { 1544, -248, 272},
    { 1472, 40, 176},
    { 1456, 320, -120},
    { 1464, 344, -96},
    { 1352, 352, 264},
    { 1200, 368, 256},
    { 1120, 352, 288},
    { 952, 360, 144},
    { 872, 280, 120},
    { 856, 392, -24},
    { 944, 440, -24},
    { 1056, 576, -136},
    { 1224, 472, -56},
    // 78 seconds
    { 1368, 352, 184},
    { 1768, 424, 264},
    { 1440, 472, 176},
    { 1032, 248, 168},
    { 1352, 120, 312},
    { 1504, 0, 432},
    { 1336, 88, 336},
    { 1128, 40, 264},
    { 984, 24, 192},
    { 904, 32, 152},
    { 808, 16, 104},
    { 688, -32, 88},
    { 616, -96, 16},
    { 736, -96, -80},
    { 856, -72, -56},
    { 1400, -296, 304},
    { 1696, 40, 392},
    { 1656, 344, 192},
    { 1576, 560, -144},
    { 1312, 544, 72},
    { 1168, 280, 208},
    { 1064, 296, 216},
    { 968, 272, 184},
    { 928, 304, 144},
    { 816, 344, 72},
    // 79 seconds
    { 816, 416, -24},
    { 848, 440, 24},
    { 1144, 504, 0},
    { 1216, 400, 112},
    { 1936, 576, 200},
    { 2000, 680, 608},
    { 1600, 72, 432},
    { 3712, 32, -3536},
    { 240, -992, 416},
    { 328, -288, 152},
    { 1456, -32, 480},
    { 344, 304, -288},
    { 544, 40, -272},
    { 488, 8, -16},
    { 856, -32, 168},
    { 784, 8, 128},
    { 1152, 16, 136},
    { 1352, 136, 160},
    { 2024, -56, 368},
    { 1736, 184, 368},
    { 1176, 560, -112},
    { 976, 272, -64},
    { 856, 168, 208},
    { 856, 88, 216},
    { 840, 136, 168},
    // 80 seconds
    { 800, 256, 144},
    { 832, 328, 56},
    { 816, 320, 24},
    { 872, 344, -16},
    { 984, 392, -56},
    { 1232, 344, -64},
    { 1312, 240, 104},
    { 1976, 304, 208},
    { 1496, 504, 120},
    { 816, 344, 80},
    { 1136, 272, 104},
    { 1384, 192, 224},
    { 1184, 120, 216},
    { 1056, 80, 240},
    { 976, 48, 168},
    { 872, 24, 168},
    { 768, 56, 120},
    { 712, -8, 120},
    { 704, -56, 88},
    { 800, -104, -104},
    { 864, -120, -288},
    { 1536, -232, 24},
    { 1736, -232, 160},
    { 1560, 200, -32},
    { 1496, 384, -184},
    // 81 seconds
    { 1440, 352, 176},
    { 1040, 288, 296},
    { 992, 184, 288},
    { 992, 200, 208},
    { 920, 328, 136},
    { 872, 344, 32},
    { 920, 472, -136},
    { 984, 480, -96},
    { 1240, 584, -160},
    { 1272, 288, 88},
    { 1776, 280, 64},
    { 1592, 328, 72},
    { 1360, 208, 128},
    { 1496, -24, 272},
    { 1552, -32, 328},
    { 1336, 80, 264},
    { 1120, 8, 304},
    { 928, 8, 224},
    { 848, 56, 152},
    { 784, 40, 136},
    { 712, -32, 128},
    { 760, -112, 72},
    { 800, -80, -24},
    { 920, -144, -80},
    { 1360, -224, 72},
    // 82 seconds
    { 1424, -8, 216},
    { 1568, 232, 144},
    { 1728, 368, -32},
    { 1528, 392, 240},
    { 1296, 368, 352},
    { 1104, 480, 288},
    { 904, 256, 200},
    { 872, 216, 112},
    { 880, 312, 40},
    { 904, 456, 0},
    { 1096, 592, 8},
    { 1144, 632, -8},
    { 1376, 384, 128},
    { 1880, 376, 208},
    { 1296, 384, 104},
    { 1200, 256, 136},
    { 1576, 248, 136},
    { 1640, 8, 416},
    { 1336, 40, 248},
    { 1160, 24, 216},
    { 1008, 32, 160},
    { 840, -8, 144},
    { 728, -32, 128},
    { 616, -88, 56},
    { 608, -120, -8},
    // 83 seconds
    { 728, -120, -152},
    { 1160, -224, 80},
    { 1752, -112, 400},
    { 1720, 360, 224},
    { 1696, 632, -112},
    { 1608, 344, 216},
    { 1272, 328, 480},
    { 1000, 136, 344},
    { 1056, 96, 280},
    { 952, 384, 152},
    { 896, 432, 88},
    { 824, 520, -48},
    { 848, 496, -32},
    { 1112, 488, 8},
    { 1320, 448, 0},
    { 1712, 344, 96},
    { 1936, 456, 136},
    { 1288, 376, 96},
    { 1352, 336, 112},
    { 1840, -32, 200},
    { 1512, 88, 400},
    { 1232, 120, 168},
    { 1032, 0, 256},
    { 864, 8, 160},
    { 712, -32, 208},
    // 84 seconds
    { 600, -64, 112},
    { 520, -88, 48},
    { 600, -88, 16},
    { 840, 32, -160},
    { 1312, -168, 120},
    { 1944, -128, 512},
    { 1776, 312, 288},
    { 1688, 720, -208},
    { 1544, 632, -8},
    { 1432, 432, 280},
    { 912, -120, 336},
    { 1104, -56, 264},
    { 968, 152, 40},
    { 864, 424, -104},
    { 904, 416, -184},
    { 960, 424, -144},
    { 1080, 360, -64},
    { 1304, 360, -72},
    { 1616, 152, 112},
    { 1808, 192, 120},
    { 1312, 192, 208},
    { 1344, 128, 128},
    { 1640, 152, 256},
    { 1488, 80, 360},
    { 1248, 48, 328},
    // 85 seconds
    { 992, -32, 264},
    { 816, -32, 200},
    { 744, -72, 160},
    { 632, -96, 152},
    { 592, -104, 80},
    { 672, -104, 40},
    { 904, 16, -48},
    { 1272, -88, 80},
    { 1848, -96, 544},
    { 1648, 424, 304},
    { 1392, 688, -272},
    { 1360, 392, -8},
    { 1160, 264, 200},
    { 1128, 288, 208},
    { 992, 272, 224},
    { 904, 344, 120},
    { 808, 392, 0},
    { 872, 384, -56},
    { 936, 416, -24},
    { 1176, 400, -64},
    { 1288, 304, -24},
    { 1536, 224, 64},
    { 1744, 240, 56},
    { 1376, 288, 56},
    { 1248, 96, 144},
    // 86 seconds
    { 1344, 32, 80},
    { 1216, 56, 368},
    { 1000, 120, 192},
    { 816, 24, 232},
    { 744, 40, 232},
    { 728, 64, 152},
    { 688, 8, 160},
    { 688, 16, 128},
    { 800, 16, 64},
    { 976, 88, -112},
    { 1160, -56, 64},
    { 1624, -192, 376},
    { 1480, 160, 200},
    { 1224, 456, -152},
    { 1104, 336, -136},
    { 1000, 232, 136},
    { 928, 88, 232},
    { 1008, 184, 144},
    { 944, 296, 120},
    { 896, 416, -24},
    { 912, 432, -144},
    { 952, 400, -120},
    { 1112, 328, -48},
    { 1280, 296, 8},
    { 1384, 232, 168},
    // 87 seconds
    { 1848, 296, 168},
    { 1328, 368, 96},
    { 1064, 144, 112},
    { 1392, 16, 200},
    { 1344, -56, 336},
    { 1224, 168, 264},
    { 1048, 232, 312},
    { 928, 312, 232},
    { 888, 368, 312},
    { 744, 416, 256},
    { 536, 304, 80},
    { 392, 208, -120},
    { 368, 120, -240},
    { 544, 320, -160},
    { 808, 344, 0},
    { 1064, 896, 120},
    { 1024, 1328, 72},
    { 640, 1456, -24},
    { 400, 1496, 56},
    { 248, 1616, 352},
    { 152, 1696, 280},
    { 144, 1416, 256},
    { 200, 1088, 264},
    { 136, 872, 240},
    { 64, 744, 48},
    // 88 seconds
    { -64, 432, 56},
    { -336, 568, -176},
    { -352, 640, -472},
    { -600, 416, -368},
    { -560, 608, -384},
    { -264, 448, -488},
    { -408, 440, -168},
    { -704, 568, 64},
    { -816, 408, -56},
    { -544, 536, -152},
    { -616, 560, -200},
    { -560, 568, -240},
    { -584, 688, -144},
    { -784, 544, -296},
    { -792, 456, -424},
    { -800, 600, -256},
    { -656, 1032, -240},
    { -616, 896, -336},
    { -128, 448, -312},
    { -80, 88, -320},
    { -8, -64, -40},
    { 408, 160, 24},
    { 576, 352, 104},
    { 520, 736, 424},
    { 800, 896, 424},
    // 89 seconds
    { 696, 824, 576},
    { 1256, 1120, 736},
    { 1408, 1072, 568},
    { 1384, 1016, 296},
    { 1560, 848, 248},
    { 1832, 808, 512},
    { 2064, 1000, 816},
    { 1160, 808, 424},
    { 344, 40, 192},
    { 872, 584, 136},
    { 1000, 552, 232},
    { 1184, 544, 64},
    { 464, -96, 608},
    { 760, -112, 176},
    { 872, -176, 320},
    { 904, 288, 240},
    { 912, 224, 112},
    { 896, 176, 32},
    { 1064, 120, 72},
    { 1232, -8, 176},
    { 1656, -176, 296},
    { 1240, 160, 160},
    { 712, 584, -312},
    { 768, 72, -56},
    { 704, 16, 216},
    // 90 seconds
    { 784, 72, 240},
    { 832, 320, 72},
    { 816, 288, 104},
    { 848, 408, 120},
    { 784, 384, 72},
    { 840, 336, 56},
    { 928, 296, 80},
    { 1208, 296, 96},
    { 1352, 296, 176},
    { 1808, 480, 216},
    { 1328, 744, 272},
    { 648, 376, 64},
    { 1032, 208, 72},
    { 1360, 224, 256},
    { 1208, 200, 288},
    { 1008, 80, 216},
    { 896, 64, 176},
    { 824, 8, 184},
    { 760, 16, 168},
    { 768, 16, 120},
    { 784, 16, 24},
    { 904, 8, -32},
    { 1040, 16, -40},
    { 1480, -168, 232},
    { 1496, 32, 280},
    // 91 seconds
    { 1136, 416, -48},
    { 1128, 312, -80},
    { 1256, 144, 264},
    { 1104, 232, 336},
    { 1000, 304, 256},
    { 944, 344, 168},
    { 848, 392, 144},
    { 840, 424, 40},
    { 816, 424, 16},
    { 952, 432, 24},
    { 1152, 424, 40},
    { 1288, 352, 168},
    { 1928, 448, 304},
    { 1664, 488, 256},
    { 960, 312, 88},
    { 1216, 240, 152},
    { 1504, 96, 328},
    { 1392, 120, 304},
    { 1192, 56, 248},
    { 1024, -8, 232},
    { 872, 16, 184},
    { 768, 16, 152},
    { 672, 24, 72},
    { 592, -40, 32},
    { 656, -96, -8},
    // 92 seconds
    { 832, -16, -64},
    { 1360, -184, 136},
    { 1768, -80, 464},
    { 1560, 384, 208},
    { 1576, 520, -160},
    { 1440, 368, 80},
    { 1328, 304, 320},
    { 1112, 424, 256},
    { 1040, 408, 208},
    { 880, 352, 200},
    { 736, 456, 40},
    { 688, 320, 16},
    { 936, 456, -40},
    { 1152, 424, 104},
    { 1256, 496, 104},
    { 1624, 368, 192},
    { 1752, 448, 240},
    { 1248, 408, 240},
    { 1280, 320, 136},
    { 1584, 216, 248},
    { 1592, 120, 368},
    { 1320, 64, 320},
    { 1168, 80, 216},
    { 992, 24, 216},
    { 808, 24, 160},
    // 93 seconds
    { 680, -32, 128},
    { 568, -128, 56},
    { 544, -112, -40},
    { 664, 16, -168},
    { 1048, -96, -64},
    { 1672, -120, 416},
    { 1736, 368, 248},
    { 1776, 592, -88},
    { 1528, 520, 48},
    { 1264, 320, 336},
    { 1120, 272, 384},
    { 1040, 264, 408},
    { 1000, 272, 344},
    { 864, 400, 128},
    { 848, 384, 88},
    { 840, 552, -24},
    { 984, 488, 80},
    { 1192, 672, 24},
    { 1416, 528, 128},
    { 1656, 472, 144},
    { 1288, 416, 128},
    { 1200, 288, 120},
    { 1512, 224, 184},
    { 1520, 72, 344},
    { 1264, 128, 288},
    // 94 seconds
    { 1128, 96, 200},
    { 1000, 40, 232},
    { 904, 24, 208},
    { 848, 16, 152},
    { 752, -48, 152},
    { 744, -144, 88},
    { 800, -40, -56},
    { 992, -40, -128},
    { 1432, -144, 168},
    { 1448, 152, 96},
    { 1536, 448, -176},
    { 1480, 264, 48},
    { 1392, 240, 376},
    { 1304, 360, 344},
    { 1144, 504, 344},
    { 960, 312, 304},
    { 912, 288, 240},
    { 872, 344, 112},
    { 824, 432, -8},
    { 968, 376, 64},
    { 1248, 560, 16},
    { 1440, 472, 112},
    { 1736, 600, 88},
    { 1472, 448, 104},
    { 1208, 200, 128},
    // 95 seconds
    { 1416, 64, 256},
    { 1256, -88, 312},
    { 1216, -72, 392},
    { 1088, 144, 168},
    { 952, 104, 128},
    { 864, 40, 168},
    { 760, -32, 192},
    { 648, -48, 152},
    { 656, -64, 88},
    { 792, 8, -72},
    { 936, 48, -192},
    { 1416, -240, 168},
    { 1624, 40, 440},
    { 1408, 440, 80},
    { 1384, 432, -80},
    { 1520, 296, 128},
    { 1152, 464, 256},
    { 1104, 424, 336},
    { 920, 312, 256},
    { 848, 280, 128},
    { 840, 264, 80},
    { 864, 400, -24},
    { 968, 432, -24},
    { 1128, 432, -56},
    { 1280, 304, 48},
    // 96 seconds
    { 1928, 216, 168},
    { 1776, 312, 216},
    { 976, 240, 216},
    { 992, 120, 112},
    { 1416, 40, 136},
    { 1264, -152, 472},
    { 1120, 88, 232},
    { 960, -8, 240},
    { 808, 16, 208},
    { 752, 56, 168},
    { 688, 40, 112},
    { 632, -16, 128},
    { 696, -40, 48},
    { 904, 32, -96},
    { 1288, -72, -40},
    { 1712, -248, 344},
    { 1528, 160, 176},
    { 1376, 512, -232},
    { 1312, 384, -120},
    { 1168, 304, 264},
    { 1024, 288, 224},
    { 968, 240, 272},
    { 912, 328, 120},
    { 816, 320, 64},
    { 840, 424, -56},
    // 97 seconds
    { 872, 432, -80},
    { 1000, 336, 8},
    { 1296, 344, 32},
    { 1688, 264, 160},
    { 1936, 368, 144},
    { 1160, 304, 200},
    { 1104, 168, 160},
    { 1416, 88, 304},
    { 1336, 112, 312},
    { 1184, 72, 248},
    { 1064, 72, 168},
    { 976, 8, 160},
    { 848, -8, 144},
    { 704, -24, 88},
    { 544, -72, 40},
    { 496, -168, 16},
    { 784, 0, -64},
    { 1248, -112, 104},
    { 1824, -80, 344},
    { 1752, 416, 40},
    { 1656, 504, -168},
    { 1224, 304, 56},
    { 1152, 208, 264},
    { 1088, 320, 264},
    { 1000, 208, 224},
    // 98 seconds
    { 960, 296, 200},
    { 888, 368, 136},
    { 832, 360, 112},
    { 888, 440, 48},
    { 1008, 480, 24},
    { 1232, 456, 16},
    { 1464, 408, 24},
    { 1744, 472, 32},
    { 1224, 464, 56},
    { 1176, 288, 120},
    { 1552, 224, 184},
    { 1488, 168, 328},
    { 1312, 160, 232},
    { 1232, 96, 216},
    { 1160, 8, 264},
    { 1008, -8, 304},
    { 904, -8, 216},
    { 704, -120, 120},
    { 544, -160, -16},
    { 648, -88, -160},
    { 752, -24, -232},
    { 1368, -288, 272},
    { 1648, 240, 296},
    { 1704, 584, 16},
    { 1712, 496, 64},
    // 99 seconds
    { 1424, 536, 288},
    { 1120, 464, 336},
    { 984, 288, 400},
    { 904, 272, 296},
    { 864, 256, 248},
    { 864, 344, 136},
    { 856, 400, 64},
    { 912, 400, 128},
    { 1224, 480, 72},
    { 1280, 480, 112},
    { 1760, 544, 144},
    { 1472, 584, 200},
    { 1048, 216, 176},
    { 1376, 272, 152},
    { 1224, -144, 528},
    { 1152, -24, 368},
    { 1160, 128, 184},
    { 1040, -136, 280},
    { 896, -72, 216},
    { 816, 16, 152},
    { 760, -24, 144},
    { 712, 0, 72},
    { 744, -32, -32},
    { 800, 24, -184},
    { 1320, -112, -104},
    // 100 seconds
    { 1488, -208, 200},
    { 1552, 96, 64},
    { 1392, 280, -64},
    { 1440, 360, 24},
    { 1368, 328, 216},
    { 1264, 416, 304},
    { 1120, 472, 280},
    { 936, 368, 160},
    { 784, 368, -32},
    { 880, 376, 24},
    { 936, 424, -56},
    { 1256, 472, -32},
    { 1288, 312, 120},
    { 2008, 216, 200},
    { 1600, 200, 296},
    { 1144, 144, 176},
    { 1408, 312, -64},
    { 1320, 208, 104},
    { 1168, 128, 208},
    { 992, 72, 328},
    { 776, 56, 184},
    { 656, 128, 96},
    { 632, 144, 80},
    { 624, 80, 112},
    { 688, 8, 88},
    // 101 seconds
    { 872, 40, -8},
    { 1056, 144, -192},
    { 1520, -88, 32},
    { 1736, -72, 296},
    { 1240, 312, -40},
    { 1216, 544, -216},
    { 1128, 456, -104},
    { 984, 296, 48},
    { 968, 176, 184},
    { 1016, 248, 176},
    { 968, 328, 136},
    { 912, 448, 0},
    { 912, 416, -24},
    { 944, 496, -112},
    { 1184, 408, -40},
    { 1280, 376, 0},
    { 1776, 400, 56},
    { 1576, 424, 48},
    { 936, 256, 56},
    { 1232, 184, 96},
    { 1392, 88, 160},
    { 1216, 8, 272},
    { 1096, 112, 120},
    { 936, -16, 200},
    { 816, 48, 80},
    // 102 seconds
    { 784, 32, 88},
    { 680, 16, 88},
    { 632, -16, 56},
    { 800, -24, -32},
    { 1040, 40, -112},
    { 1568, -72, 8},
    { 1712, -128, 320},
    { 1224, 320, -8},
    { 1128, 392, -240},
    { 1224, 232, 96},
    { 1104, 224, 272},
    { 1040, 264, 232},
    { 976, 288, 200},
    { 888, 360, 72},
    { 848, 320, 48},
    { 896, 408, -56},
    { 936, 384, -32},
    { 1168, 432, -128},
    { 1320, 320, -64},
    { 1696, 344, 0},
    { 1688, 416, 96},
    { 944, 360, 32},
    { 992, 272, 56},
    { 1312, 136, 208},
    { 1352, 64, 296},
    // 103 seconds
    { 1176, 40, 272},
    { 1024, 24, 224},
    { 920, 16, 176},
    { 824, 8, 152},
    { 712, 8, 128},
    { 648, -8, 72},
    { 712, -16, -24},
    { 936, 56, -152},
    { 1352, -48, -72},
    { 1680, -272, 280},
    { 1376, 144, 128},
    { 1208, 344, -160},
    { 1320, 288, -48},
    { 1224, 328, 256},
    { 1032, 344, 224},
    { 952, 248, 264},
    { 896, 320, 144},
    { 872, 296, 120},
    { 864, 344, 32},
    { 896, 360, 8},
    { 1104, 432, -24},
    { 1248, 448, -40},
    { 1776, 504, 56},
    { 1696, 528, 120},
    { 960, 288, 64},
    // 104 seconds
    { 1072, 200, 88},
    { 1336, 24, 168},
    { 1240, 0, 336},
    { 1144, 120, 168},
    { 1032, 32, 208},
    { 928, 16, 216},
    { 840, 32, 168},
    { 776, -8, 136},
    { 704, -24, 96},
    { 816, -16, 0},
    { 928, 56, -192},
    { 1328, -128, -32},
    { 1512, -216, 168},
    { 1336, 160, -48},
    { 1280, 296, -224},
    { 1312, 224, 16},
    { 1216, 192, 264},
    { 1168, 336, 224},
    { 1064, 384, 256},
    { 904, 400, 168},
    { 832, 296, 80},
    { 832, 336, -16},
    { 920, 424, -112},
    { 1024, 440, -136},
    { 1280, 408, -40},
    // 105 seconds
    { 1704, 368, 96},
    { 1816, 456, 96},
    { 1072, 312, 136},
    { 1080, 184, 104},
    { 1336, 144, 176},
    { 1368, 88, 280},
    { 1184, 88, 264},
    { 1056, 8, 248},
    { 952, -16, 232},
    { 848, -24, 216},
    { 760, 8, 128},
    { 728, -40, 104},
    { 816, -48, 32},
    { 960, 64, -104},
    { 1312, -8, -128},
    { 1440, -208, 160},
    { 1360, 8, 72},
    { 1176, 248, -176},
    { 1184, 232, -88},
    { 1184, 152, 240},
    { 1176, 208, 336},
    { 1136, 328, 336},
    { 1008, 488, 256},
    { 872, 392, 176},
    { 856, 368, 96},
    // 106 seconds
    { 896, 376, 48},
    { 1096, 336, 8},
    { 1192, 328, 32},
    { 1608, 432, 64},
    { 1800, 584, 56},
    { 952, 424, -24},
    { 1064, 328, 16},
    { 1368, 192, 168},
    { 1352, 152, 240},
    { 1128, 104, 160},
    { 1024, 8, 192},
    { 928, -8, 216},
    { 824, 24, 176},
    { 752, 8, 160},
    { 696, -40, 128},
    { 768, -64, 56},
    { 984, 80, -144},
    { 1200, 32, -88},
    { 1536, -184, 264},
    { 1464, 64, 168},
    { 1304, 344, -184},
    { 1152, 248, -64},
    { 920, 120, 216},
    { 984, 96, 224},
    { 1040, 232, 264},
    // 107 seconds
    { 1016, 368, 192},
    { 952, 360, 192},
    { 896, 504, 40},
    { 936, 464, -8},
    { 1056, 392, -32},
    { 1248, 368, 8},
    { 1672, 296, 216},
    { 1752, 392, 208},
    { 1120, 296, 160},
    { 1112, 112, 128},
    { 1392, 136, 240},
    { 1336, 64, 272},
    { 1200, 160, 160},
    { 1000, -40, 224},
    { 848, 16, 136},
    { 760, -8, 136},
    { 688, -24, 136},
    { 632, -64, 112},
    { 704, -96, 56},
    { 904, 8, -48},
    { 1256, -56, -16},
    { 1760, -160, 352},
    { 1504, 224, 232},
    { 1232, 560, -224},
    { 1168, 280, -48},
    // 108 seconds
    { 1152, 240, 248},
    { 992, 192, 232},
    { 984, 144, 288},
    { 920, 328, 128},
    { 880, 320, 72},
    { 840, 304, 88},
    { 936, 408, 72},
    { 1056, 544, 24},
    { 1280, 568, 32},
    { 1624, 480, 216},
    { 1648, 408, 208},
    { 1144, 352, 72},
    { 992, 288, 104},
    { 1248, 216, 200},
    { 1344, 88, 304},
    { 1104, 56, 304},
    { 960, 48, 232},
    { 920, 24, 240},
    { 872, 0, 208},
    { 816, -8, 168},
    { 720, 8, 80},
    { 736, -48, 40},
    { 880, 32, -96},
    { 1168, -64, -72},
    { 1536, -248, 256},
    // 109 seconds
    { 1440, 96, 136},
    { 1312, 368, -144},
    { 1312, 272, -48},
    { 1192, 256, 272},
    { 1048, 320, 224},
    { 992, 256, 248},
    { 920, 240, 208},
    { 856, 232, 136},
    { 880, 432, 40},
    { 944, 480, -48},
    { 1008, 528, 8},
    { 1288, 416, 80},
    { 1488, 312, 152},
    { 1672, 312, 176},
    { 1320, 384, 72},
    { 1032, 288, 112},
    { 1272, 216, 176},
    { 1456, -40, 320},
    { 1232, 56, 264},
    { 1024, 80, 224},
    { 928, 40, 152},
    { 832, 72, 72},
    { 792, 24, 104},
    { 728, 8, 48},
    { 744, -32, -24},
    // 110 seconds
    { 816, 24, -192},
    { 920, -64, -184},
    { 1416, -232, 104},
    { 1512, -24, 144},
    { 1408, 248, 8},
    { 1312, 264, -8},
    { 1264, 256, 224},
    { 1192, 344, 240},
    { 1152, 336, 304},
    { 1040, 376, 224},
    { 896, 336, 96},
    { 840, 432, -16},
    { 872, 504, -32},
    { 952, 528, -72},
    { 1176, 528, -48},
    { 1304, 416, 120},
    { 1680, 384, 144},
    { 1776, 408, 192},
    { 1088, 296, 144},
    { 1208, 288, 56},
    { 1456, 88, 176},
    { 1464, 24, 256},
    { 1232, 64, 216},
    { 1096, 32, 184},
    { 976, 8, 176},
    // 111 seconds
    { 832, 8, 136},
    { 696, 8, 48},
    { 576, -80, 8},
    { 528, -96, -64},
    { 744, 40, -160},
    { 1096, -88, -72},
    { 1664, -128, 288},
    { 1640, 248, 232},
    { 1608, 472, 56},
    { 1456, 544, 120},
    { 1160, 408, 320},
    { 1024, 248, 360},
    { 992, 184, 312},
    { 984, 288, 248},
    { 928, 336, 160},
    { 912, 376, 144},
    { 928, 440, 80},
    { 968, 520, 32},
    { 1232, 592, -16},
    { 1528, 544, 16},
    { 1768, 560, 56},
    { 1256, 384, 104},
    { 1176, 312, 80},
    { 1392, 144, 200},
    { 1464, 40, 376},
    // 112 seconds
    { 1256, 24, 328},
    { 1136, 0, 280},
    { 1008, 8, 248},
    { 888, 0, 232},
    { 776, 8, 152},
    { 728, -24, 112},
    { 712, -24, 24},
    { 808, 24, -112},
    { 960, -16, -216},
    { 1416, -240, 56},
    { 1392, 8, 136},
    { 1368, 320, -56},
    { 1408, 472, -128},
    { 1280, 432, 144},
    { 1200, 344, 232},
    { 1136, 344, 304},
    { 1016, 416, 240},
    { 904, 368, 200},
    { 840, 464, 56},
    { 856, 472, 40},
    { 904, 520, 24},
    { 1056, 504, 40},
    { 1200, 528, 144},
    { 1664, 488, 200},
    { 1680, 416, 312},
    // 113 seconds
    { 1184, 280, 208},
    { 1224, 136, 152},
    { 1432, 80, 232},
    { 1392, 40, 296},
    { 1184, 64, 192},
    { 992, 0, 200},
    { 816, 16, 128},
    { 672, 16, 96},
    { 592, 0, 88},
    { 552, 16, 0},
    { 576, 8, -32},
    { 840, 72, -80},
    { 1144, 72, -48},
    { 1736, -96, 200},
    { 1896, 8, 360},
    { 1440, 464, 8},
    { 1272, 504, -88},
    { 1144, 440, 168},
    { 928, 224, 256},
    { 920, 136, 216},
    { 896, 208, 192},
    { 848, 344, 72},
    { 824, 376, 48},
    { 872, 424, 8},
    { 912, 472, -80},
    // 114 seconds
    { 1096, 424, -48},
    { 1280, 384, 0},
    { 1616, 280, 112},
    { 1776, 352, 128},
    { 1088, 352, 56},
    { 1080, 224, 72},
    { 1344, 120, 192},
    { 1384, 32, 264},
    { 1248, 8, 256},
    { 1008, -16, 208},
    { 800, 16, 120},
    { 696, 32, 160},
    { 608, 64, 184},
    { 552, 200, 104},
    { 520, 360, 72},
    { 608, 552, 88},
    { 736, 792, 80},
    { 1152, 904, 160},
    { 1256, 1080, 272},
    { 1120, 1272, 224},
    { 704, 1192, 40},
    { 488, 1064, -48},
    { 224, 768, -24},
    { 240, 936, -16},
    { 240, 840, -104},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-03 09:01:03 local
AccelRawData *activity_sample_walk_200_pbl_25530_8(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25530_8
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 96, -224, -1000},
    { 72, -216, -1016},
    { 80, -208, -1056},
    { 104, -208, -1064},
    { 96, -216, -1056},
    { 96, -216, -1032},
    { 96, -224, -1000},
    { 72, -232, -992},
    { 96, -240, -976},
    { 96, -248, -984},
    { 96, -248, -984},
    { 128, -216, -984},
    { 56, -336, -872},
    { 32, -264, -952},
    { 72, -304, -928},
    { -16, -120, -1016},
    { 280, -1488, -1232},
    { 208, -48, -1032},
    { 192, -72, -992},
    { 88, 56, -864},
    { -32, 240, -872},
    { 0, 416, -896},
    { -32, 544, -832},
    { -88, 424, -888},
    { -96, 440, -864},
    // 1 seconds
    { -96, 488, -824},
    { -120, 568, -888},
    { -80, 432, -984},
    { 16, 320, -768},
    { 104, 560, -552},
    { 120, 640, -560},
    { 32, 608, -576},
    { 32, 824, -456},
    { -192, 1032, -616},
    { 192, 1272, -632},
    { -24, 1056, -416},
    { 112, 1200, -416},
    { 80, 960, -312},
    { 80, 824, -248},
    { 160, 808, -240},
    { 96, 664, -264},
    { 80, 648, -232},
    { 136, 616, -272},
    { 280, 736, -224},
    { 376, 624, -256},
    { 400, 400, -184},
    { 672, 272, -80},
    { 1312, 112, 56},
    { 1688, 96, 440},
    { 1888, 304, 296},
    // 2 seconds
    { 1688, 520, 160},
    { 1208, 616, 48},
    { 1112, 368, 192},
    { 1032, 304, 264},
    { 856, 232, 280},
    { 840, 176, 256},
    { 768, 200, 200},
    { 752, 272, 104},
    { 744, 296, 40},
    { 824, 336, -32},
    { 896, 288, 8},
    { 1088, 416, -112},
    { 1240, 360, -64},
    { 1392, 272, 72},
    { 1560, 192, 192},
    { 1360, 352, 136},
    { 704, 456, -8},
    { 928, 304, 88},
    { 1080, 152, 216},
    { 1008, 128, 288},
    { 880, 160, 160},
    { 800, 80, 176},
    { 720, 136, 56},
    { 736, 64, 104},
    { 728, 88, 40},
    // 3 seconds
    { 776, 72, 8},
    { 872, 48, -40},
    { 1200, 80, -48},
    { 1632, -128, 184},
    { 1864, -88, 328},
    { 1112, 400, -24},
    { 768, 464, -240},
    { 856, 144, 40},
    { 936, 128, 248},
    { 904, 112, 264},
    { 880, 224, 208},
    { 808, 352, 96},
    { 776, 472, -72},
    { 768, 368, -64},
    { 872, 408, -136},
    { 1080, 224, 64},
    { 1368, 280, 112},
    { 2040, 264, 248},
    { 1744, 440, 136},
    { 912, 336, 88},
    { 1024, 136, 176},
    { 1312, 8, 320},
    { 1264, 0, 320},
    { 1096, 88, 224},
    { 928, 40, 160},
    // 4 seconds
    { 832, 56, 64},
    { 768, 32, 40},
    { 688, -16, 56},
    { 560, -80, 48},
    { 624, -104, -8},
    { 1056, 0, -8},
    { 1544, -64, 96},
    { 1848, -96, 392},
    { 1504, 328, 56},
    { 1360, 520, -232},
    { 1248, 280, 136},
    { 1056, 208, 320},
    { 1000, 192, 296},
    { 952, 208, 336},
    { 872, 280, 344},
    { 776, 424, 176},
    { 736, 384, 136},
    { 904, 504, 16},
    { 1216, 400, 152},
    { 1312, 584, 168},
    { 1752, 520, 208},
    { 1576, 576, 64},
    { 1112, 440, 48},
    { 1376, 384, 104},
    { 1344, -264, 256},
    // 5 seconds
    { 1360, 88, 248},
    { 1152, 104, 240},
    { 1008, -32, 312},
    { 872, -72, 288},
    { 768, -48, 208},
    { 688, -8, 120},
    { 736, -56, 144},
    { 768, -56, 64},
    { 1032, 48, -200},
    { 1456, -80, 24},
    { 1456, -88, 200},
    { 1208, 136, -8},
    { 1304, 200, -80},
    { 1424, 344, 144},
    { 1240, 352, 256},
    { 1120, 400, 280},
    { 992, 352, 272},
    { 880, 256, 168},
    { 880, 232, 104},
    { 944, 416, -40},
    { 1000, 440, -64},
    { 1288, 544, -168},
    { 1744, 488, -80},
    { 1800, 424, 40},
    { 1136, 248, 112},
    // 6 seconds
    { 1128, 128, 128},
    { 1392, 32, 264},
    { 1432, 40, 272},
    { 1200, 72, 248},
    { 1024, 24, 216},
    { 936, 16, 192},
    { 856, 16, 168},
    { 744, 8, 112},
    { 656, -40, 72},
    { 656, -104, 40},
    { 824, -32, -32},
    { 1216, 8, -120},
    { 1496, -144, 160},
    { 1424, 56, 152},
    { 1280, 240, -32},
    { 1360, 152, 16},
    { 1280, 216, 264},
    { 1152, 248, 232},
    { 1096, 400, 240},
    { 928, 304, 232},
    { 888, 304, 104},
    { 904, 328, 24},
    { 936, 392, -48},
    { 1112, 400, -32},
    { 1232, 472, -40},
    // 7 seconds
    { 1552, 320, 56},
    { 1736, 272, 120},
    { 1224, 272, 128},
    { 1152, 112, 168},
    { 1512, 48, 280},
    { 1456, -104, 528},
    { 1088, 40, 384},
    { 992, 144, 104},
    { 944, 48, 200},
    { 856, 0, 216},
    { 784, -56, 224},
    { 752, -160, 176},
    { 768, -168, 64},
    { 896, -168, 32},
    { 1408, -144, 56},
    { 1576, -56, 184},
    { 1488, 272, 96},
    { 1304, 288, -88},
    { 1232, 56, -104},
    { 1064, 344, 128},
    { 1056, 288, 184},
    { 960, 440, 184},
    { 960, 424, 232},
    { 896, 512, 96},
    { 824, 360, 56},
    // 8 seconds
    { 880, 344, -48},
    { 1112, 256, 32},
    { 1344, 328, 80},
    { 1592, 312, 152},
    { 1648, 304, 136},
    { 1176, 344, 120},
    { 1280, 136, 168},
    { 1552, 40, 136},
    { 1392, -136, 480},
    { 1200, 80, 184},
    { 992, 24, 176},
    { 856, 48, 144},
    { 752, 0, 128},
    { 640, -56, 160},
    { 552, -128, 120},
    { 504, -80, 32},
    { 728, 8, 0},
    { 968, 112, -88},
    { 1512, -80, 120},
    { 1824, -160, 464},
    { 1544, 320, 136},
    { 1272, 560, -232},
    { 1272, 296, -104},
    { 1112, 152, 240},
    { 1144, 240, 272},
    // 9 seconds
    { 992, 296, 224},
    { 856, 336, 88},
    { 760, 304, -16},
    { 752, 368, -112},
    { 888, 400, -32},
    { 1080, 568, -8},
    { 1344, 504, 112},
    { 1472, 376, 256},
    { 1680, 256, 256},
    { 1312, 360, 176},
    { 1488, 272, 240},
    { 1624, 104, 384},
    { 1328, 40, 392},
    { 1080, 72, 264},
    { 960, 64, 192},
    { 888, 16, 192},
    { 800, -16, 160},
    { 680, -40, 96},
    { 592, -72, 40},
    { 584, -120, 0},
    { 784, 32, -104},
    { 1176, -40, 8},
    { 1568, -120, 408},
    { 1648, 368, 168},
    { 1504, 480, -80},
    // 10 seconds
    { 1384, 408, 72},
    { 1192, 376, 216},
    { 1064, 344, 256},
    { 976, 288, 296},
    { 936, 344, 224},
    { 832, 408, 56},
    { 856, 384, 40},
    { 944, 520, -64},
    { 1096, 416, 8},
    { 1296, 408, 136},
    { 1896, 424, 328},
    { 1584, 416, 240},
    { 1048, 280, 48},
    { 1176, 184, 176},
    { 1448, 192, 280},
    { 1376, 104, 320},
    { 1160, 16, 304},
    { 1072, 8, 240},
    { 952, -16, 248},
    { 832, -8, 192},
    { 728, -16, 128},
    { 632, -56, 80},
    { 696, -56, -8},
    { 912, 40, -168},
    { 1416, -152, 72},
    // 11 seconds
    { 1560, -128, 272},
    { 1384, 312, -40},
    { 1336, 368, -192},
    { 1392, 232, 192},
    { 1288, 320, 344},
    { 1144, 440, 288},
    { 976, 328, 256},
    { 912, 264, 224},
    { 856, 256, 200},
    { 896, 384, 104},
    { 896, 432, 48},
    { 1248, 616, -72},
    { 1576, 584, 88},
    { 1808, 480, 104},
    { 1336, 328, 88},
    { 1176, 312, 56},
    { 1824, 64, 56},
    { 1408, -40, 360},
    { 1296, 128, 152},
    { 1048, 48, 192},
    { 952, -32, 296},
    { 888, 0, 208},
    { 784, 0, 160},
    { 728, 16, 88},
    { 768, -64, 88},
    // 12 seconds
    { 1016, 0, -40},
    { 1312, -40, -128},
    { 1784, -360, 320},
    { 1160, 200, 24},
    { 1016, 440, -304},
    { 1224, 200, -32},
    { 1288, 192, 384},
    { 1152, 328, 216},
    { 1104, 304, 352},
    { 976, 480, 144},
    { 864, 344, 104},
    { 968, 432, 32},
    { 1096, 408, 40},
    { 1408, 496, 64},
    { 1216, 504, 8},
    { 1464, 528, 32},
    { 1264, 520, 48},
    { 1104, 344, 120},
    { 1288, 168, 256},
    { 1536, 48, 336},
    { 1352, 16, 320},
    { 1192, 0, 272},
    { 1016, 40, 184},
    { 848, 56, 128},
    { 720, 8, 104},
    // 13 seconds
    { 600, -48, 88},
    { 544, -112, 40},
    { 640, -120, 8},
    { 1112, 48, -32},
    { 1560, 104, 16},
    { 1880, -24, 312},
    { 1568, 184, 192},
    { 1240, 320, -56},
    { 1160, 376, 64},
    { 960, 272, 216},
    { 968, 200, 232},
    { 936, 224, 240},
    { 888, 280, 232},
    { 832, 360, 104},
    { 792, 288, 112},
    { 960, 408, 16},
    { 1056, 344, 16},
    { 1256, 352, 8},
    { 1536, 296, 80},
    { 1424, 496, -32},
    { 1064, 392, 80},
    { 1184, 264, 144},
    { 1208, 120, 248},
    { 1192, 192, 152},
    { 1128, -8, 288},
    // 14 seconds
    { 984, -8, 296},
    { 904, 24, 200},
    { 872, 24, 176},
    { 816, 24, 128},
    { 872, -8, 136},
    { 1016, -56, 128},
    { 1120, -16, 8},
    { 1456, -96, 56},
    { 1432, -128, 240},
    { 1056, 192, -32},
    { 976, 320, -216},
    { 1040, 96, 24},
    { 976, 88, 208},
    { 1000, 152, 192},
    { 976, 320, 176},
    { 928, 400, 88},
    { 856, 320, 128},
    { 864, 344, 40},
    { 976, 320, -16},
    { 1064, 328, -16},
    { 1312, 328, -16},
    { 1696, 320, 104},
    { 1560, 464, 80},
    { 952, 392, 24},
    { 856, 304, 64},
    // 15 seconds
    { 1184, 208, 152},
    { 1176, 208, 112},
    { 1056, 120, 200},
    { 952, 96, 168},
    { 880, 48, 176},
    { 832, 24, 160},
    { 808, 8, 152},
    { 832, 16, 96},
    { 888, 0, 32},
    { 1024, 72, -56},
    { 1176, 0, -48},
    { 1552, -216, 216},
    { 1224, 80, 136},
    { 976, 320, -136},
    { 976, 264, -144},
    { 960, 192, 144},
    { 928, 128, 200},
    { 984, 216, 168},
    { 968, 280, 184},
    { 896, 440, 8},
    { 824, 360, 32},
    { 936, 440, -112},
    { 1072, 344, -80},
    { 1240, 424, -144},
    { 1608, 376, 16},
    // 16 seconds
    { 1648, 488, 48},
    { 1096, 408, -8},
    { 1032, 256, 48},
    { 1256, 152, 136},
    { 1320, 80, 272},
    { 1104, 104, 224},
    { 992, 80, 168},
    { 904, 80, 120},
    { 872, 32, 136},
    { 792, 48, 64},
    { 712, -16, 64},
    { 664, -48, 0},
    { 848, 48, -144},
    { 1048, 0, -112},
    { 1480, -200, 136},
    { 1432, 16, 128},
    { 1256, 288, -64},
    { 1176, 312, -72},
    { 1120, 256, 176},
    { 1016, 232, 200},
    { 976, 240, 248},
    { 968, 304, 208},
    { 920, 328, 112},
    { 848, 384, 16},
    { 824, 456, -96},
    // 17 seconds
    { 976, 472, -88},
    { 1232, 496, -64},
    { 1536, 520, 0},
    { 1744, 536, 120},
    { 1192, 408, 56},
    { 1128, 264, 104},
    { 1392, 160, 200},
    { 1400, 128, 240},
    { 1176, 128, 208},
    { 1048, 56, 200},
    { 928, 40, 144},
    { 832, 24, 104},
    { 792, 16, 40},
    { 672, 0, 24},
    { 584, -64, -16},
    { 696, -24, -96},
    { 952, -80, -80},
    { 1520, -160, 104},
    { 1680, 64, 184},
    { 1400, 360, -104},
    { 1424, 296, -8},
    { 1416, 288, 304},
    { 1176, 376, 312},
    { 1024, 224, 280},
    { 912, 248, 120},
    // 18 seconds
    { 880, 232, 80},
    { 816, 336, -40},
    { 832, 376, -72},
    { 904, 464, -72},
    { 1112, 472, -88},
    { 1248, 448, -24},
    { 1808, 456, 64},
    { 1752, 440, 184},
    { 1128, 248, 120},
    { 1344, 144, 168},
    { 1536, 72, 240},
    { 1344, 48, 272},
    { 1152, 16, 256},
    { 1056, 0, 232},
    { 936, 56, 136},
    { 872, 8, 112},
    { 800, 24, 24},
    { 640, -8, 32},
    { 504, -80, -56},
    { 600, -64, -184},
    { 856, -136, -152},
    { 1424, -232, 144},
    { 1648, 160, 160},
    { 1760, 320, 40},
    { 1576, 368, 0},
    // 19 seconds
    { 1296, 280, 256},
    { 1176, 304, 328},
    { 1080, 320, 304},
    { 1016, 256, 256},
    { 880, 344, 120},
    { 800, 376, 0},
    { 840, 416, -48},
    { 976, 448, -24},
    { 1184, 528, -56},
    { 1136, 400, 128},
    { 1768, 384, 144},
    { 1456, 280, 216},
    { 1256, 128, 184},
    { 1496, 128, 184},
    { 1512, 96, 312},
    { 1256, 64, 288},
    { 1120, 40, 248},
    { 984, 0, 240},
    { 872, -32, 232},
    { 784, -16, 168},
    { 704, -16, 128},
    { 720, -32, 96},
    { 792, 40, -32},
    { 808, 8, -216},
    { 1320, -208, -48},
    // 20 seconds
    { 1544, -248, 80},
    { 1632, 136, -24},
    { 1472, 368, -312},
    { 1304, 296, -56},
    { 1248, 184, 256},
    { 1192, 272, 272},
    { 1112, 336, 272},
    { 968, 400, 176},
    { 840, 400, 40},
    { 888, 456, -64},
    { 976, 424, -32},
    { 1240, 568, -72},
    { 1248, 552, 56},
    { 1832, 568, 104},
    { 1464, 408, 136},
    { 1288, 208, 120},
    { 1416, 128, 160},
    { 1576, 80, 168},
    { 1368, 48, 328},
    { 1192, 56, 208},
    { 1048, -16, 232},
    { 936, -16, 216},
    { 832, -8, 144},
    { 720, 0, 80},
    { 680, -72, 64},
    // 21 seconds
    { 736, -72, 8},
    { 832, -8, -64},
    { 1448, -224, 72},
    { 1520, -72, 152},
    { 1352, 208, -24},
    { 1400, 248, -128},
    { 1440, 320, 120},
    { 1400, 312, 280},
    { 1264, 464, 328},
    { 1072, 328, 344},
    { 952, 272, 200},
    { 920, 304, 104},
    { 968, 312, 48},
    { 936, 368, -24},
    { 1104, 424, -56},
    { 1256, 488, 8},
    { 1784, 608, 48},
    { 1424, 448, 104},
    { 1064, 232, 80},
    { 1328, 200, 120},
    { 1480, 72, 248},
    { 1424, 64, 256},
    { 1232, -8, 296},
    { 1088, -8, 232},
    { 984, 0, 216},
    // 22 seconds
    { 856, 8, 176},
    { 808, -32, 144},
    { 808, -88, 120},
    { 848, -48, -8},
    { 936, 0, -144},
    { 1440, -232, 80},
    { 1448, -56, 104},
    { 1296, 216, -96},
    { 1320, 288, -216},
    { 1264, 232, 64},
    { 1272, 208, 248},
    { 1232, 392, 224},
    { 1072, 456, 232},
    { 944, 408, 120},
    { 904, 312, 104},
    { 936, 448, 0},
    { 1048, 376, 24},
    { 1232, 504, 0},
    { 1608, 496, 104},
    { 1600, 568, 104},
    { 1008, 344, 96},
    { 1128, 296, 72},
    { 1360, 112, 208},
    { 1392, 40, 264},
    { 1168, 8, 360},
    // 23 seconds
    { 1176, 104, 184},
    { 1024, 24, 248},
    { 856, 64, 152},
    { 784, 16, 136},
    { 800, -16, 104},
    { 952, -48, 56},
    { 1032, 8, -56},
    { 1376, -104, -16},
    { 1464, -176, 184},
    { 1192, 128, 56},
    { 1192, 288, -184},
    { 1224, 248, -16},
    { 1128, 216, 224},
    { 1096, 240, 232},
    { 1080, 328, 256},
    { 968, 432, 96},
    { 848, 304, 104},
    { 832, 312, 16},
    { 920, 344, -48},
    { 1008, 408, -96},
    { 1240, 424, -96},
    { 1408, 424, 8},
    { 1488, 464, 8},
    { 1104, 520, -16},
    { 1072, 312, 128},
    // 24 seconds
    { 1264, 200, 216},
    { 1408, 80, 296},
    { 1304, 56, 280},
    { 1168, 88, 192},
    { 1032, 48, 224},
    { 920, 48, 136},
    { 840, 8, 112},
    { 744, 16, 40},
    { 656, 8, -32},
    { 640, -64, -40},
    { 880, 32, -168},
    { 1160, -48, -24},
    { 1568, -144, 184},
    { 1536, 152, 160},
    { 1288, 376, -8},
    { 1376, 288, 80},
    { 1224, 312, 248},
    { 1040, 280, 272},
    { 1008, 224, 240},
    { 936, 248, 160},
    { 824, 280, 88},
    { 816, 312, 32},
    { 880, 544, -24},
    { 1048, 696, -8},
    { 1216, 632, 32},
    // 25 seconds
    { 1368, 512, 184},
    { 1752, 544, 304},
    { 1200, 496, 176},
    { 1248, 288, 248},
    { 1488, 144, 264},
    { 1424, 80, 280},
    { 1224, 48, 288},
    { 1088, 64, 176},
    { 992, 24, 168},
    { 848, 72, 48},
    { 776, 32, 40},
    { 672, -32, 8},
    { 624, -96, -56},
    { 728, -8, -120},
    { 1064, 24, -96},
    { 1584, 8, 120},
    { 1512, 304, 120},
    { 1304, 384, -160},
    { 1208, 312, -72},
    { 1216, 176, 288},
    { 1168, 232, 320},
    { 1144, 344, 280},
    { 1016, 424, 240},
    { 888, 432, 168},
    { 776, 352, 72},
    // 26 seconds
    { 840, 384, 0},
    { 1032, 448, -64},
    { 1208, 504, -48},
    { 1616, 512, 56},
    { 1704, 568, 128},
    { 1056, 344, 88},
    { 1096, 288, 72},
    { 1328, 160, 56},
    { 1376, 80, 160},
    { 1200, 96, 72},
    { 1096, 0, 136},
    { 968, -8, 176},
    { 864, 16, 104},
    { 808, 24, 120},
    { 768, 24, 80},
    { 792, -32, -8},
    { 864, 56, -152},
    { 1240, -112, -104},
    { 1640, -304, 208},
    { 1360, 160, -24},
    { 1144, 432, -344},
    { 1152, 200, -56},
    { 1184, 128, 224},
    { 1136, 216, 176},
    { 1088, 280, 240},
    // 27 seconds
    { 960, 424, 120},
    { 832, 336, 104},
    { 808, 336, 8},
    { 872, 312, 8},
    { 992, 384, -64},
    { 1232, 424, -104},
    { 1408, 408, -8},
    { 1704, 480, 24},
    { 1384, 520, 40},
    { 904, 312, 32},
    { 1160, 216, 72},
    { 1360, 136, 200},
    { 1232, 48, 320},
    { 1056, 64, 232},
    { 960, 48, 168},
    { 896, -16, 248},
    { 800, -8, 208},
    { 752, 16, 96},
    { 704, 0, 16},
    { 816, 56, -112},
    { 1016, 64, -184},
    { 1512, -328, 112},
    { 1576, -120, 168},
    { 1248, 312, -200},
    { 1272, 376, -216},
    // 28 seconds
    { 1224, 360, 120},
    { 1096, 224, 248},
    { 1040, 296, 232},
    { 984, 328, 192},
    { 880, 352, 128},
    { 808, 360, 40},
    { 848, 304, 24},
    { 904, 432, -80},
    { 1160, 400, -88},
    { 1208, 464, -64},
    { 1856, 432, 104},
    { 1616, 512, 72},
    { 904, 352, 8},
    { 1088, 248, 64},
    { 1376, 152, 160},
    { 1336, 40, 288},
    { 1120, 72, 248},
    { 1016, 88, 152},
    { 952, 24, 144},
    { 872, 32, 88},
    { 776, -8, 96},
    { 672, -32, 24},
    { 728, -64, -40},
    { 928, 48, -208},
    { 1376, -144, -8},
    // 29 seconds
    { 1616, -160, 248},
    { 1344, 240, 32},
    { 1272, 352, -184},
    { 1280, 264, 32},
    { 1104, 216, 256},
    { 1056, 200, 272},
    { 1008, 240, 280},
    { 944, 304, 168},
    { 904, 360, 40},
    { 920, 408, -40},
    { 952, 504, -176},
    { 1088, 384, -104},
    { 1304, 424, -72},
    { 1872, 432, 56},
    { 1664, 392, 112},
    { 1032, 264, 80},
    { 1136, 120, 184},
    { 1392, 72, 240},
    { 1408, 88, 256},
    { 1136, -16, 320},
    { 952, -40, 256},
    { 848, -24, 168},
    { 760, 0, 144},
    { 712, 16, 80},
    { 712, -32, 64},
    // 30 seconds
    { 784, -40, 8},
    { 936, 88, -192},
    { 1336, -152, -56},
    { 1680, -296, 264},
    { 1552, 96, 160},
    { 1296, 432, -208},
    { 1264, 232, -40},
    { 1280, 152, 312},
    { 1208, 304, 328},
    { 1080, 376, 328},
    { 856, 384, 184},
    { 760, 304, 88},
    { 792, 400, -96},
    { 992, 440, -128},
    { 1144, 328, -56},
    { 1240, 272, -56},
    { 1544, 232, 56},
    { 1728, 288, 104},
    { 1160, 320, 64},
    { 1088, 128, 80},
    { 1360, 0, 272},
    { 1400, -16, 344},
    { 1232, 48, 288},
    { 1024, 8, 224},
    { 936, 0, 160},
    // 31 seconds
    { 864, 40, 104},
    { 792, 24, 88},
    { 736, -48, 88},
    { 736, -168, 16},
    { 896, 0, -168},
    { 1216, -80, -128},
    { 1648, -160, 224},
    { 1464, 48, 40},
    { 1368, 176, -272},
    { 1416, 240, -32},
    { 1216, 248, 208},
    { 1088, 280, 176},
    { 1064, 328, 232},
    { 936, 296, 176},
    { 832, 368, -8},
    { 832, 336, -32},
    { 888, 496, -112},
    { 1096, 416, -72},
    { 1240, 464, -56},
    { 1672, 432, -24},
    { 1664, 432, 24},
    { 1072, 296, 8},
    { 1200, 216, 0},
    { 1576, 280, -40},
    { 1408, 168, 256},
    // 32 seconds
    { 1216, 40, 184},
    { 1064, -136, 344},
    { 912, -64, 208},
    { 808, 16, 112},
    { 760, 88, 8},
    { 712, 48, 8},
    { 688, -32, 0},
    { 856, 32, -152},
    { 1224, -168, -72},
    { 1512, -232, 136},
    { 1512, 80, 128},
    { 1448, 304, -40},
    { 1456, 392, -24},
    { 1264, 288, 248},
    { 1120, 272, 232},
    { 1040, 240, 240},
    { 960, 288, 176},
    { 872, 280, 168},
    { 848, 368, 40},
    { 864, 400, -40},
    { 1048, 560, -104},
    { 1248, 512, -104},
    { 1632, 448, -24},
    { 1856, 368, 80},
    { 1176, 272, 72},
    // 33 seconds
    { 1120, 168, 56},
    { 1352, 72, 168},
    { 1424, 64, 272},
    { 1240, 96, 224},
    { 1104, 16, 224},
    { 976, 0, 208},
    { 880, 0, 152},
    { 760, 40, 64},
    { 696, -8, 40},
    { 680, -72, 0},
    { 840, 24, -104},
    { 1096, -104, -120},
    { 1528, -224, 128},
    { 1456, 80, 32},
    { 1464, 304, -216},
    { 1488, 304, -72},
    { 1272, 272, 256},
    { 1072, 288, 232},
    { 1016, 248, 264},
    { 976, 216, 256},
    { 896, 336, 152},
    { 912, 344, 56},
    { 880, 400, 24},
    { 1064, 432, 8},
    { 1232, 472, -40},
    // 34 seconds
    { 1448, 432, 0},
    { 1616, 600, -48},
    { 1144, 424, -32},
    { 1080, 144, 80},
    { 1416, 48, 200},
    { 1464, 80, 152},
    { 1160, -32, 304},
    { 1080, 104, 160},
    { 984, 16, 200},
    { 872, -16, 200},
    { 800, 0, 128},
    { 784, -48, 96},
    { 800, -48, 16},
    { 912, 40, -96},
    { 1088, 96, -136},
    { 1544, -128, 40},
    { 1272, -216, -24},
    { 1224, 96, -296},
    { 1472, 0, -88},
    { 1440, 152, 144},
    { 1168, 264, 144},
    { 1096, 344, 192},
    { 968, 344, 168},
    { 864, 272, 104},
    { 864, 272, 8},
    // 35 seconds
    { 872, 336, -40},
    { 952, 384, -112},
    { 1160, 344, -104},
    { 1328, 312, -48},
    { 1760, 288, -56},
    { 1544, 336, -48},
    { 1048, 208, -24},
    { 1208, 128, 0},
    { 1368, 0, 128},
    { 1304, 16, 272},
    { 1136, 56, 248},
    { 1032, 32, 168},
    { 912, -8, 184},
    { 824, -48, 176},
    { 736, -8, 112},
    { 728, -56, 80},
    { 824, 8, -104},
    { 1000, 32, -104},
    { 1536, -232, 136},
    { 1440, -48, 120},
    { 1216, 280, -192},
    { 1264, 232, -264},
    { 1296, 208, 152},
    { 1240, 232, 256},
    { 1128, 416, 248},
    // 36 seconds
    { 984, 424, 240},
    { 848, 304, 144},
    { 824, 280, 56},
    { 904, 320, 0},
    { 944, 360, 32},
    { 1248, 528, -64},
    { 1384, 480, 72},
    { 1904, 528, 144},
    { 1224, 336, 48},
    { 976, 232, 24},
    { 1256, 208, 120},
    { 1504, 96, 208},
    { 1312, 96, 240},
    { 1120, 40, 256},
    { 992, -16, 248},
    { 888, -24, 208},
    { 776, -8, 144},
    { 696, -16, 72},
    { 672, -80, 24},
    { 800, -8, -88},
    { 1016, 56, -184},
    { 1432, -224, 88},
    { 1472, -16, 88},
    { 1408, 248, -136},
    { 1448, 296, -160},
    // 37 seconds
    { 1296, 288, 168},
    { 1120, 272, 240},
    { 1096, 352, 256},
    { 1008, 320, 264},
    { 888, 368, 120},
    { 840, 344, 48},
    { 896, 416, 0},
    { 960, 456, -40},
    { 1176, 488, -40},
    { 1296, 488, 48},
    { 1672, 496, 64},
    { 1424, 432, 32},
    { 984, 280, 40},
    { 1224, 208, 56},
    { 1504, 72, 176},
    { 1352, 24, 312},
    { 1160, 88, 184},
    { 1040, 72, 120},
    { 928, 16, 144},
    { 832, 8, 120},
    { 712, 0, 40},
    { 600, -56, 16},
    { 696, -56, -56},
    { 920, 24, -112},
    { 1496, -152, 64},
    // 38 seconds
    { 1592, -56, 216},
    { 1392, 272, 0},
    { 1368, 304, -128},
    { 1344, 296, 104},
    { 1152, 248, 240},
    { 1096, 288, 256},
    { 1016, 296, 256},
    { 912, 288, 128},
    { 848, 296, 48},
    { 904, 376, -32},
    { 904, 416, -32},
    { 1144, 448, -80},
    { 1264, 424, -8},
    { 1808, 456, 32},
    { 1648, 440, 72},
    { 976, 216, 64},
    { 1192, 152, 88},
    { 1504, 216, -32},
    { 1320, -96, 424},
    { 1208, 96, 168},
    { 1072, 40, 200},
    { 952, 48, 184},
    { 848, 32, 104},
    { 760, -24, 120},
    { 632, -72, 88},
    // 39 seconds
    { 656, -96, -24},
    { 856, 16, -120},
    { 1232, -104, 0},
    { 1448, -112, 128},
    { 1416, 152, 0},
    { 1504, 272, -152},
    { 1448, 296, -16},
    { 1240, 312, 168},
    { 1096, 432, 176},
    { 992, 288, 224},
    { 936, 280, 144},
    { 888, 248, 88},
    { 816, 352, -48},
    { 872, 384, -40},
    { 1096, 472, -40},
    { 1256, 456, -40},
    { 1552, 368, 56},
    { 1632, 344, 80},
    { 1168, 304, 72},
    { 1096, 208, 88},
    { 1336, 136, 152},
    { 1440, 8, 320},
    { 1216, 16, 296},
    { 1080, 32, 200},
    { 976, 32, 168},
    // 40 seconds
    { 872, 8, 136},
    { 752, 16, 64},
    { 648, -24, 40},
    { 648, -56, -24},
    { 848, -16, -104},
    { 1032, 64, -96},
    { 1544, -192, 248},
    { 1584, 56, 336},
    { 1264, 704, -16},
    { 1104, 536, -96},
    { 1112, 264, 192},
    { 1064, 120, 328},
    { 1040, 224, 288},
    { 976, 320, 264},
    { 888, 424, 168},
    { 840, 432, 72},
    { 864, 400, 32},
    { 968, 416, 40},
    { 1176, 472, 0},
    { 1192, 464, 56},
    { 1776, 464, 160},
    { 1480, 504, 224},
    { 1096, 344, 160},
    { 1352, 224, 136},
    { 1480, 104, 304},
    // 41 seconds
    { 1288, 24, 296},
    { 1080, 0, 256},
    { 928, 16, 160},
    { 832, 8, 136},
    { 744, 0, 88},
    { 648, -64, 80},
    { 608, -88, 24},
    { 784, -56, -56},
    { 1072, -48, -32},
    { 1680, -144, 224},
    { 1640, 160, 192},
    { 1368, 416, -152},
    { 1336, 240, -48},
    { 1272, 232, 256},
    { 1120, 280, 256},
    { 1008, 272, 264},
    { 896, 272, 152},
    { 880, 248, 144},
    { 896, 336, 0},
    { 896, 296, 8},
    { 936, 408, -56},
    { 1208, 384, -24},
    { 1296, 464, -8},
    { 1640, 360, 40},
    { 1536, 424, 80},
    // 42 seconds
    { 1064, 256, 136},
    { 1264, 192, 112},
    { 1440, 0, 320},
    { 1296, 32, 304},
    { 1176, 88, 192},
    { 1040, 56, 168},
    { 912, 24, 136},
    { 816, -8, 120},
    { 736, -32, 112},
    { 704, -72, 56},
    { 840, -48, -16},
    { 976, 0, -80},
    { 1472, -128, 32},
    { 1448, -32, 176},
    { 1160, 232, -56},
    { 1248, 208, -120},
    { 1336, 168, 152},
    { 1280, 216, 272},
    { 1176, 328, 248},
    { 1032, 400, 224},
    { 880, 352, 88},
    { 840, 256, 64},
    { 872, 360, -24},
    { 952, 336, -48},
    { 1160, 424, -96},
    // 43 seconds
    { 1280, 432, -32},
    { 1720, 400, 48},
    { 1632, 416, 104},
    { 968, 304, 40},
    { 1160, 200, 96},
    { 1424, 96, 240},
    { 1408, 72, 376},
    { 1184, 80, 200},
    { 1056, 0, 240},
    { 944, -8, 200},
    { 848, -24, 128},
    { 720, -40, 104},
    { 608, -48, 32},
    { 640, -88, 24},
    { 888, 64, -136},
    { 1400, -56, -136},
    { 1696, -176, 240},
    { 1472, 176, 56},
    { 1384, 552, -400},
    { 1256, 464, -112},
    { 1072, 264, 248},
    { 1024, 240, 216},
    { 952, 224, 208},
    { 976, 408, 120},
    { 848, 416, 72},
    // 44 seconds
    { 824, 384, 16},
    { 880, 456, -96},
    { 1088, 480, -104},
    { 1200, 544, -184},
    { 1600, 472, -120},
    { 1640, 480, -24},
    { 1080, 376, 24},
    { 1112, 272, 48},
    { 1360, 160, 144},
    { 1320, 64, 272},
    { 1112, 88, 272},
    { 1000, 80, 232},
    { 944, 56, 208},
    { 912, 40, 144},
    { 824, 32, 120},
    { 704, -24, 96},
    { 784, -24, -8},
    { 920, 56, -184},
    { 1272, -48, -104},
    { 1456, -88, 88},
    { 1288, 168, -8},
    { 1304, 368, -216},
    { 1320, 312, -128},
    { 1160, 224, 152},
    { 1096, 288, 168},
    // 45 seconds
    { 1040, 288, 232},
    { 920, 320, 152},
    { 904, 160, 296},
    { 808, 416, 96},
    { 880, 552, 0},
    { 1112, 576, 0},
    { 1192, 432, 88},
    { 1392, 272, 160},
    { 1720, 456, 136},
    { 1176, 456, 32},
    { 1048, 272, 88},
    { 1400, 64, 216},
    { 1376, -32, 248},
    { 1200, 112, 112},
    { 1088, 32, 152},
    { 984, 72, 32},
    { 912, -16, 72},
    { 800, 40, 0},
    { 744, -16, -24},
    { 648, -56, -64},
    { 776, -48, -56},
    { 1064, -16, -72},
    { 1536, -112, 136},
    { 1568, 64, 264},
    { 1456, 528, -160},
    // 46 seconds
    { 1368, 344, -16},
    { 1112, 208, 256},
    { 1024, 80, 296},
    { 1056, 144, 240},
    { 1016, 264, 192},
    { 984, 408, 8},
    { 920, 440, -32},
    { 896, 480, -112},
    { 904, 384, -56},
    { 1176, 384, -56},
    { 1328, 344, 96},
    { 1928, 312, 136},
    { 1456, 328, 96},
    { 1120, 192, 48},
    { 1464, 56, 176},
    { 1544, 16, 232},
    { 1320, 8, 216},
    { 1104, 24, 224},
    { 904, 0, 200},
    { 768, -16, 152},
    { 688, -32, 136},
    { 648, -24, 104},
    { 616, -56, 64},
    { 784, -48, 0},
    { 1016, 168, -184},
    // 47 seconds
    { 1232, -32, -136},
    { 1576, -448, 344},
    { 1592, 256, -8},
    { 1424, 600, -400},
    { 1328, 400, -96},
    { 1096, 240, 224},
    { 1032, 144, 360},
    { 984, 144, 264},
    { 960, 136, 376},
    { 880, 384, 216},
    { 840, 608, -104},
    { 944, 576, -112},
    { 1128, 480, -24},
    { 1256, 264, 80},
    { 1664, 264, 112},
    { 1640, 368, 192},
    { 1088, 328, 96},
    { 1176, 96, 224},
    { 1432, 64, 192},
    { 1320, 48, 424},
    { 1152, 40, 192},
    { 1000, -24, 216},
    { 816, -24, 168},
    { 696, -40, 96},
    { 648, -24, 8},
    // 48 seconds
    { 616, -56, 0},
    { 784, -8, -64},
    { 1024, 128, -248},
    { 1472, -104, 64},
    { 1824, -128, 304},
    { 1512, 352, 0},
    { 1344, 552, -224},
    { 1200, 360, 88},
    { 1016, 224, 264},
    { 912, 96, 296},
    { 904, 232, 192},
    { 856, 296, 152},
    { 800, 400, 0},
    { 824, 384, 16},
    { 888, 448, -72},
    { 1112, 320, 0},
    { 1320, 272, 32},
    { 1656, 176, 144},
    { 1704, 224, 144},
    { 1016, 360, 56},
    { 1008, 176, 128},
    { 1248, 32, 128},
    { 1216, -160, 360},
    { 1120, 72, 208},
    { 960, 48, 216},
    // 49 seconds
    { 808, 80, 104},
    { 736, 24, 88},
    { 648, 24, 48},
    { 632, 0, 40},
    { 752, -88, 72},
    { 1008, -64, 32},
    { 1288, -24, 88},
    { 1896, 216, -32},
    { 1592, 352, -120},
    { 1112, 440, -208},
    { 1104, 48, -16},
    { 928, 128, 144},
    { 912, 128, 216},
    { 872, 216, 264},
    { 864, 312, 248},
    { 792, 392, 144},
    { 776, 336, 72},
    { 864, 336, -16},
    { 1008, 248, -8},
    { 1184, 264, -64},
    { 1336, 256, -24},
    { 1896, 384, -24},
    { 1408, 432, 32},
    { 936, 216, 32},
    { 1128, 104, 144},
    // 50 seconds
    { 1312, 0, 264},
    { 1144, -24, 264},
    { 1016, 56, 184},
    { 920, 8, 192},
    { 848, -24, 176},
    { 704, 16, 56},
    { 648, 0, 64},
    { 696, 8, -16},
    { 888, 40, -96},
    { 1072, 0, -48},
    { 1648, -280, 96},
    { 1712, -64, 160},
    { 1336, 480, -272},
    { 1152, 472, -240},
    { 944, 224, 48},
    { 864, 32, 128},
    { 864, 40, 192},
    { 888, 176, 184},
    { 880, 296, 80},
    { 856, 280, 80},
    { 864, 304, 32},
    { 928, 288, 8},
    { 1216, 368, -72},
    { 1272, 328, -8},
    { 1800, 400, 8},
    // 51 seconds
    { 1504, 368, 88},
    { 848, 392, 16},
    { 1088, 368, -24},
    { 1312, 112, 64},
    { 1184, 144, 168},
    { 1016, 0, 280},
    { 896, -8, 192},
    { 832, -48, 224},
    { 736, -16, 208},
    { 720, -16, 152},
    { 760, 16, 8},
    { 864, -8, -8},
    { 1072, 112, -56},
    { 1528, -72, 184},
    { 1664, 24, 256},
    { 1272, 432, 8},
    { 1056, 536, -184},
    { 872, 128, -96},
    { 784, 368, 376},
    { 1040, 712, 296},
    { 896, 432, 160},
    { 760, 240, 240},
    { 664, 200, 184},
    { 768, 312, 152},
    { 856, 408, 120},
    // 52 seconds
    { 976, 360, 120},
    { 1272, 368, 200},
    { 1520, 432, 328},
    { 1840, 408, 328},
    { 1304, 400, 376},
    { 1112, 312, 232},
    { 1288, 312, 376},
    { 1176, 144, 288},
    { 968, 8, 304},
    { 896, 16, 176},
    { 808, -8, 104},
    { 616, 40, -16},
    { 608, -32, 40},
    { 632, -48, 0},
    { 752, -16, -24},
    { 1064, 24, 40},
    { 1400, -144, 248},
    { 2152, -112, 592},
    { 1680, 536, 208},
    { 1072, 768, -176},
    { 768, 192, 144},
    { 920, 8, 408},
    { 920, 72, 392},
    { 912, 304, 344},
    { 832, 536, 72},
    // 53 seconds
    { 784, 360, 104},
    { 792, 456, 24},
    { 880, 320, 128},
    { 1080, 472, 40},
    { 1272, 328, 152},
    { 1656, 376, 248},
    { 1912, 304, 376},
    { 1296, 416, 200},
    { 1048, 344, 40},
    { 1240, 232, 40},
    { 1232, 64, 312},
    { 1104, 8, 360},
    { 968, 40, 200},
    { 808, -16, 176},
    { 696, -24, 152},
    { 648, 0, 88},
    { 616, -16, 64},
    { 728, -48, 16},
    { 928, 24, -64},
    { 1128, 16, 88},
    { 1792, -184, 464},
    { 1784, 208, 376},
    { 1368, 616, -152},
    { 1160, 464, -144},
    { 1080, 104, 176},
    // 54 seconds
    { 1000, 176, 256},
    { 936, 312, 184},
    { 928, 272, 152},
    { 856, 416, 56},
    { 784, 384, 8},
    { 904, 480, -32},
    { 1080, 384, 8},
    { 1264, 360, -8},
    { 1568, 88, 200},
    { 1840, 272, 296},
    { 1120, 272, 224},
    { 1104, 248, 168},
    { 1304, -64, 72},
    { 816, -544, -48},
    { 944, 136, 120},
    { 992, 32, 272},
    { 840, 48, 192},
    { 792, 0, 112},
    { 688, 0, 88},
    { 624, -64, 112},
    { 688, -96, 56},
    { 936, -8, 8},
    { 1296, 24, -56},
    { 1848, -80, 280},
    { 1608, 264, 88},
    // 55 seconds
    { 1248, 464, -200},
    { 1136, 160, 24},
    { 1024, 72, 296},
    { 1000, 80, 280},
    { 984, 208, 264},
    { 872, 424, 120},
    { 800, 384, 32},
    { 848, 320, 0},
    { 928, 304, 0},
    { 1096, 368, -64},
    { 1280, 368, -8},
    { 1904, 424, 168},
    { 1800, 480, 240},
    { 992, 344, 16},
    { 1160, 272, 56},
    { 1544, 152, 240},
    { 1320, 40, 320},
    { 1040, 0, 272},
    { 904, -16, 176},
    { 792, -24, 160},
    { 688, -8, 144},
    { 624, -72, 160},
    { 560, -32, 40},
    { 720, -24, -80},
    { 1032, 72, -128},
    // 56 seconds
    { 1600, -96, 120},
    { 1952, -96, 344},
    { 1440, 448, -120},
    { 1312, 464, -224},
    { 1272, 384, 72},
    { 976, 304, 224},
    { 952, 224, 176},
    { 880, 240, 192},
    { 832, 408, 40},
    { 768, 280, 96},
    { 848, 440, -40},
    { 992, 360, 16},
    { 1200, 576, -80},
    { 1312, 400, 16},
    { 1736, 488, 8},
    { 1568, 448, 104},
    { 984, 400, 64},
    { 1152, 352, 64},
    { 1208, -120, 416},
    { 1256, 88, 288},
    { 1080, 112, 224},
    { 936, 64, 184},
    { 816, 48, 168},
    { 728, 0, 152},
    { 664, -8, 64},
    // 57 seconds
    { 624, -96, 144},
    { 776, -64, 24},
    { 1000, 136, -200},
    { 1400, -24, -48},
    { 1872, -112, 296},
    { 1448, 440, -256},
    { 1400, 376, -176},
    { 1280, 232, 208},
    { 984, 304, 240},
    { 952, 256, 200},
    { 864, 160, 232},
    { 856, 280, 144},
    { 792, 248, 128},
    { 808, 376, 136},
    { 936, 576, 48},
    { 1080, 600, 56},
    { 1264, 464, 128},
    { 1720, 296, 272},
    { 1648, 360, 232},
    { 1064, 368, 88},
    { 1152, 264, 144},
    { 1352, 48, 120},
    { 1456, -64, 392},
    { 1096, -16, 304},
    { 976, 24, 120},
    // 58 seconds
    { 792, 8, 80},
    { 672, 0, 88},
    { 592, -48, 72},
    { 552, -40, -24},
    { 680, -16, -80},
    { 1008, 8, -56},
    { 1808, -224, 352},
    { 2104, 96, 456},
    { 1344, 680, -288},
    { 1112, 432, -168},
    { 1024, 264, 192},
    { 928, 56, 216},
    { 920, 152, 136},
    { 888, 200, 160},
    { 888, 320, 88},
    { 816, 296, 64},
    { 824, 312, 24},
    { 904, 384, -32},
    { 1128, 416, -32},
    { 1288, 496, -24},
    { 1632, 400, 32},
    { 1696, 400, 88},
    { 1088, 336, 72},
    { 1104, 232, 64},
    { 1240, 128, 152},
    // 59 seconds
    { 1240, 64, 256},
    { 1120, 80, 192},
    { 1008, -24, 272},
    { 872, 0, 232},
    { 800, 24, 152},
    { 744, 0, 152},
    { 680, 0, 96},
    { 800, -56, 56},
    { 976, 64, -80},
    { 1224, -16, -152},
    { 1680, -256, 232},
    { 1400, 120, 24},
    { 1288, 392, -344},
    { 1248, 248, -80},
    { 1048, 248, 232},
    { 976, 288, 152},
    { 968, 248, 208},
    { 912, 352, 152},
    { 840, 360, 72},
    { 800, 328, 8},
    { 840, 368, -32},
    { 1048, 408, -104},
    { 1256, 408, -88},
    { 1552, 376, 0},
    { 1816, 456, 96},
    // 60 seconds
    // elapsed: 1 minutes
    { 1248, 384, 64},
    { 1048, 232, 72},
    { 1272, 168, 128},
    { 1264, 48, 248},
    { 1128, 72, 168},
    { 992, 24, 208},
    { 944, -32, 240},
    { 840, 8, 136},
    { 760, 8, 104},
    { 680, 56, 40},
    { 648, -16, 16},
    { 760, -48, -56},
    { 1048, -40, -120},
    { 1552, -200, 200},
    { 1760, 8, 352},
    { 1560, 472, 40},
    { 1184, 496, -248},
    { 976, 224, 112},
    { 1032, 120, 264},
    { 1008, 192, 312},
    { 936, 280, 264},
    { 864, 384, 168},
    { 824, 272, 168},
    { 888, 368, 16},
    { 1024, 416, 32},
    // 61 seconds
    { 1256, 552, -72},
    { 1344, 512, 32},
    { 1800, 608, 48},
    { 1504, 472, 56},
    { 1112, 312, 80},
    { 1288, 184, 176},
    { 1464, 48, 296},
    { 1272, 24, 264},
    { 1088, 0, 248},
    { 912, -16, 208},
    { 776, -8, 152},
    { 704, -8, 128},
    { 656, 16, 88},
    { 616, -64, 88},
    { 824, -24, -56},
    { 1040, 72, -144},
    { 1560, -152, 168},
    { 1744, -48, 320},
    { 1432, 384, -128},
    { 1320, 400, -240},
    { 1200, 336, 48},
    { 1080, 168, 248},
    { 1048, 248, 232},
    { 968, 328, 152},
    { 912, 320, 128},
    // 62 seconds
    { 848, 400, -16},
    { 872, 368, 0},
    { 960, 464, -56},
    { 1232, 400, -24},
    { 1368, 464, 40},
    { 1928, 528, 136},
    { 1408, 464, 104},
    { 1024, 248, 88},
    { 1416, 152, 160},
    { 1520, 24, 400},
    { 1304, 48, 256},
    { 1096, 16, 208},
    { 936, 0, 192},
    { 792, -16, 144},
    { 680, -8, 112},
    { 592, -40, 72},
    { 584, -96, 16},
    { 832, 0, -112},
    { 1120, -32, -96},
    { 1640, -256, 368},
    { 1752, 128, 520},
    { 1408, 1040, 16},
    { 1120, 936, -16},
    { 1032, 320, 304},
    { 928, 184, 320},
    // 63 seconds
    { 872, 168, 368},
    { 864, 400, 200},
    { 832, 424, 168},
    { 792, 504, 48},
    { 864, 368, 120},
    { 1024, 352, 160},
    { 1320, 472, 96},
    { 1432, 488, 160},
    { 1760, 568, 216},
    { 1248, 560, 152},
    { 976, 328, 104},
    { 1192, 152, 240},
    { 1248, 40, 328},
    { 1136, 72, 256},
    { 984, 0, 248},
    { 832, 48, 168},
    { 776, 24, 136},
    { 744, 16, 120},
    { 672, 32, 56},
    { 712, -64, 80},
    { 928, 8, -80},
    { 1032, 96, -144},
    { 1608, -176, 128},
    { 1560, 8, 208},
    { 1216, 400, -136},
    // 64 seconds
    { 1216, 296, -128},
    { 1200, 304, 136},
    { 1080, 280, 128},
    { 1008, 224, 272},
    { 936, 336, 168},
    { 904, 304, 128},
    { 896, 368, 8},
    { 904, 440, -88},
    { 984, 456, -88},
    { 1240, 432, -96},
    { 1352, 296, 80},
    { 1904, 224, 160},
    { 1480, 304, 168},
    { 928, 144, 192},
    { 1216, 56, 208},
    { 1304, -48, 296},
    { 1232, 144, 280},
    { 1064, 120, 192},
    { 960, 40, 192},
    { 840, 8, 160},
    { 752, -48, 168},
    { 680, -40, 96},
    { 664, -80, 48},
    { 864, 0, -104},
    { 1000, 128, -256},
    // 65 seconds
    { 1488, -136, 40},
    { 1592, -136, 272},
    { 1392, 232, 80},
    { 1384, 312, -56},
    { 1336, 480, -8},
    { 1016, 296, 248},
    { 976, 184, 256},
    { 992, 208, 264},
    { 928, 352, 80},
    { 808, 416, -32},
    { 848, 536, -112},
    { 944, 456, -80},
    { 1152, 176, -16},
    { 1168, 256, -32},
    { 1760, 312, 144},
    { 1792, 464, 160},
    { 1288, 472, -24},
    { 1384, 312, 0},
    { 1424, -72, 224},
    { 1192, -240, 272},
    { 1048, 88, 72},
    { 952, 16, 0},
    { 928, 32, 72},
    { 768, -16, 104},
    { 624, -48, 48},
    // 66 seconds
    { 568, -112, 0},
    { 688, -80, -40},
    { 944, 48, -160},
    { 1328, -160, 32},
    { 1608, -120, 184},
    { 1536, 136, 96},
    { 1512, 360, -160},
    { 1456, 400, 8},
    { 1136, 280, 216},
    { 1008, 224, 240},
    { 976, 200, 216},
    { 912, 248, 184},
    { 840, 376, 32},
    { 816, 384, 8},
    { 920, 496, -56},
    { 1064, 440, -16},
    { 1224, 440, -56},
    { 1584, 336, 40},
    { 1848, 440, 80},
    { 1320, 320, 96},
    { 1296, 152, 160},
    { 1488, 24, 320},
    { 1368, 104, 240},
    { 1184, 64, 304},
    { 1056, 0, 312},
    // 67 seconds
    { 944, -32, 288},
    { 880, -16, 176},
    { 816, -24, 152},
    { 736, -32, 32},
    { 672, -104, -32},
    { 752, -24, -176},
    { 952, 24, -280},
    { 1440, -256, 128},
    { 1496, 24, 208},
    { 1384, 320, -48},
    { 1560, 264, 16},
    { 1560, 384, 288},
    { 1272, 480, 344},
    { 1096, 480, 464},
    { 840, 304, 184},
    { 856, 296, 112},
    { 864, 368, 96},
    { 896, 448, 72},
    { 976, 496, 16},
    { 1128, 504, 8},
    { 1432, 440, 104},
    { 1968, 424, 152},
    { 1624, 296, 144},
    { 1192, 320, 0},
    { 1328, 192, 120},
    // 68 seconds
    { 1416, 128, 128},
    { 1184, 40, 200},
    { 928, -32, 256},
    { 776, -72, 232},
    { 656, -48, 184},
    { 592, -16, 144},
    { 584, -8, 88},
    { 640, 16, 64},
    { 808, 120, -88},
    { 984, 144, -160},
    { 1296, -80, 0},
    { 1936, -232, 200},
    { 1616, 248, -8},
    { 1216, 528, -320},
    { 1112, 328, -104},
    { 992, 192, 216},
    { 952, 184, 168},
    { 896, 248, 144},
    { 848, 312, 88},
    { 776, 312, 88},
    { 800, 376, -64},
    { 904, 336, -72},
    { 1128, 384, -64},
    { 1336, 304, -32},
    { 1320, 280, 0},
    // 69 seconds
    { 1736, 360, -56},
    { 1208, 376, 56},
    { 1192, 224, 64},
    { 1368, 72, 296},
    { 1272, 64, 304},
    { 1136, 72, 176},
    { 1104, 16, 168},
    { 888, -16, 192},
    { 712, 24, 192},
    { 624, 64, 176},
    { 472, 152, 136},
    { 336, 464, -32},
    { 344, 616, -112},
    { 400, 656, -136},
    { 464, 432, -16},
    { 640, 512, -160},
    { 1112, 184, 88},
    { 2104, -216, 768},
    { 1472, 984, 144},
    { 1328, 448, -16},
    { 1408, 560, 352},
    { 928, 664, 360},
    { 744, 576, 304},
    { 736, 656, 192},
    { 712, 544, 248},
    // 70 seconds
    { 960, 496, 216},
    { 1104, 512, 216},
    { 1416, 568, 272},
    { 1520, 584, 296},
    { 1424, 720, 88},
    { 1080, 512, 136},
    { 1128, 352, 136},
    { 1192, 200, 192},
    { 1088, 64, 296},
    { 968, 72, 192},
    { 1008, -24, 240},
    { 920, -24, 224},
    { 792, 16, 160},
    { 736, 24, 104},
    { 800, 32, 72},
    { 1000, 8, 40},
    { 1296, 32, -48},
    { 1688, -48, 32},
    { 1632, -168, 240},
    { 912, 16, -104},
    { 1064, 304, -352},
    { 1104, 272, -176},
    { 888, 120, 16},
    { 936, 104, 64},
    { 1008, 176, 144},
    // 71 seconds
    { 968, 272, 176},
    { 872, 280, 112},
    { 808, 360, -32},
    { 936, 368, -48},
    { 1208, 368, -104},
    { 1400, 312, -80},
    { 1608, 400, -128},
    { 1552, 424, -120},
    { 1112, 424, -72},
    { 936, 272, -24},
    { 1200, 128, 64},
    { 1328, 32, 168},
    { 1224, 24, 240},
    { 1136, 8, 224},
    { 968, 24, 168},
    { 800, 32, 128},
    { 712, 32, 72},
    { 680, 8, 56},
    { 704, -40, 8},
    { 912, -24, -56},
    { 1160, 0, -80},
    { 1640, -240, 168},
    { 1800, 0, 256},
    { 1320, 496, -264},
    { 1336, 456, -208},
    // 72 seconds
    { 1096, 248, 184},
    { 1000, 176, 224},
    { 944, 184, 264},
    { 872, 184, 208},
    { 816, 304, 88},
    { 768, 272, 48},
    { 832, 304, 24},
    { 1008, 440, -40},
    { 1240, 352, -56},
    { 1440, 248, -16},
    { 1816, 248, -16},
    { 1568, 352, -64},
    { 848, 288, -64},
    { 992, 240, -32},
    { 1224, 64, 112},
    { 1224, 104, 168},
    { 1088, 120, 224},
    { 992, 8, 264},
    { 856, 0, 208},
    { 712, 32, 144},
    { 664, -8, 112},
    { 640, 0, 48},
    { 816, 64, -24},
    { 1152, 144, -144},
    { 1504, -240, -120},
    // 73 seconds
    { 1656, -240, 112},
    { 1368, 96, -72},
    { 1216, 344, -352},
    { 1144, 240, -152},
    { 968, 128, 56},
    { 944, 144, 72},
    { 992, 200, 160},
    { 912, 288, 144},
    { 784, 328, 16},
    { 784, 336, -16},
    { 832, 304, -32},
    { 984, 328, -80},
    { 1232, 192, 64},
    { 1400, 320, 56},
    { 1736, 480, 8},
    { 1512, 600, 24},
    { 944, 288, 104},
    { 1176, 192, 168},
    { 1304, -8, 304},
    { 1176, 64, 280},
    { 1032, 40, 224},
    { 968, -8, 192},
    { 872, -32, 184},
    { 744, -8, 152},
    { 688, 0, 48},
    // 74 seconds
    { 800, -8, 8},
    { 920, 128, -176},
    { 1024, 64, -112},
    { 1656, -384, 344},
    { 1560, 0, 248},
    { 1424, 512, -208},
    { 1232, 368, -192},
    { 944, 224, 176},
    { 920, 80, 224},
    { 976, 208, 304},
    { 976, 288, 256},
    { 904, 352, 160},
    { 832, 384, 80},
    { 832, 384, 24},
    { 904, 368, 16},
    { 1224, 488, -32},
    { 1496, 424, 96},
    { 1880, 528, 104},
    { 1248, 360, 176},
    { 968, 336, 64},
    { 1240, 360, 8},
    { 1352, 368, 32},
    { 1216, 184, 248},
    { 1040, 72, 272},
    { 952, 40, 184},
    // 75 seconds
    { 848, -88, 304},
    { 752, 16, 176},
    { 736, -16, 120},
    { 768, 32, -24},
    { 896, 48, -80},
    { 1128, -24, -184},
    { 1568, -248, 136},
    { 1528, 24, 80},
    { 1160, 360, -368},
    { 1256, 256, -232},
    { 1264, 160, 128},
    { 1152, 224, 160},
    { 1096, 320, 184},
    { 1008, 336, 176},
    { 848, 368, 88},
    { 760, 336, 48},
    { 784, 392, 16},
    { 816, 440, -8},
    { 984, 504, -48},
    { 1416, 608, -24},
    { 1792, 544, 40},
    { 1688, 480, 8},
    { 1176, 328, 40},
    { 1392, 240, 32},
    { 1448, 120, 128},
    // 76 seconds
    { 1256, 120, 240},
    { 1128, 136, 184},
    { 1016, 72, 200},
    { 824, 48, 152},
    { 728, 56, 72},
    { 640, 16, 80},
    { 568, -24, 80},
    { 680, -16, 0},
    { 944, 168, -264},
    { 1576, -176, 80},
    { 1792, -176, 248},
    { 1456, 352, -208},
    { 1280, 432, -384},
    { 1192, 248, 80},
    { 1208, 128, 304},
    { 1128, 240, 296},
    { 1064, 272, 336},
    { 952, 376, 240},
    { 824, 432, 56},
    { 872, 496, -56},
    { 896, 608, -96},
    { 960, 576, -80},
    { 1200, 544, 40},
    { 1776, 616, 176},
    { 1920, 448, 272},
    // 77 seconds
    { 1184, 336, 64},
    { 1200, 352, 48},
    { 1480, 160, 168},
    { 1432, 40, 216},
    { 1184, 16, 248},
    { 992, 8, 200},
    { 896, 8, 152},
    { 768, 48, 128},
    { 648, 32, 96},
    { 664, -24, 88},
    { 712, -64, 40},
    { 912, 48, -128},
    { 1320, -72, -112},
    { 1776, -352, 376},
    { 1624, 208, 280},
    { 944, 840, -320},
    { 944, 832, -64},
    { 1184, 192, 384},
    { 1032, 120, 336},
    { 1024, 272, 208},
    { 976, 344, 240},
    { 832, 504, 56},
    { 752, 392, 48},
    { 832, 408, 32},
    { 984, 320, 56},
    // 78 seconds
    { 1248, 392, 0},
    { 1168, 456, -16},
    { 1696, 472, 64},
    { 1536, 520, 192},
    { 1144, 280, 200},
    { 1176, 208, 120},
    { 1200, 136, 224},
    { 1160, 72, 280},
    { 1040, 48, 216},
    { 944, 32, 160},
    { 864, -16, 192},
    { 752, -8, 136},
    { 680, 40, 72},
    { 656, 0, 32},
    { 808, 16, -72},
    { 976, 152, -272},
    { 1520, -360, 104},
    { 2032, 40, 232},
    { 1528, 408, -88},
    { 1200, 752, -448},
    { 1040, 632, -48},
    { 952, 336, 192},
    { 928, 192, 296},
    { 968, 216, 320},
    { 872, 368, 200},
    // 79 seconds
    { 688, 408, 32},
    { 728, 392, 24},
    { 872, 488, -32},
    { 1128, 512, -40},
    { 1232, 536, 0},
    { 1696, 624, -16},
    { 1808, 608, 88},
    { 1208, 496, -32},
    { 1344, 360, -40},
    { 1480, 184, 64},
    { 1296, 104, 160},
    { 1024, 152, 88},
    { 848, 40, 168},
    { 696, -24, 160},
    { 560, -32, 80},
    { 488, -72, 64},
    { 456, -56, 40},
    { 600, -8, -16},
    { 1040, 192, -144},
    { 1544, -40, 56},
    { 2320, -112, 440},
    { 1928, 520, -8},
    { 1248, 728, -440},
    { 952, 408, 16},
    { 936, 48, 232},
    // 80 seconds
    { 928, 136, 200},
    { 880, 144, 216},
    { 912, 304, 160},
    { 816, 352, 80},
    { 752, 424, 8},
    { 792, 416, -24},
    { 920, 416, -8},
    { 1160, 424, -32},
    { 1432, 352, 104},
    { 1872, 496, 64},
    { 1472, 480, 80},
    { 1048, 312, 48},
    { 1328, 176, 128},
    { 1344, 144, 288},
    { 1128, 112, 184},
    { 968, 56, 192},
    { 856, -8, 200},
    { 760, -32, 184},
    { 680, -32, 128},
    { 560, -8, 88},
    { 640, 80, -64},
    { 776, 136, -216},
    { 960, 80, -128},
    { 1920, -416, 456},
    { 2144, -136, 560},
    // 81 seconds
    { 1344, 608, -128},
    { 1032, 528, -336},
    { 968, 336, -40},
    { 1040, 48, 232},
    { 1048, 160, 272},
    { 1024, 224, 288},
    { 888, 440, 72},
    { 792, 440, 32},
    { 792, 504, -88},
    { 896, 432, -160},
    { 1056, 368, -88},
    { 1344, 256, 80},
    { 2080, 328, 232},
    { 1800, 560, 176},
    { 1016, 320, 56},
    { 1072, 160, 96},
    { 1376, 104, 248},
    { 1208, 80, 224},
    { 1008, 64, 232},
    { 920, -32, 264},
    { 848, -32, 224},
    { 784, -8, 168},
    { 744, -8, 152},
    { 776, 0, 80},
    { 968, 32, -40},
    // 82 seconds
    { 1080, 64, -176},
    { 1504, -160, 48},
    { 1680, -240, 288},
    { 1288, 304, -80},
    { 1120, 424, -376},
    { 1096, 200, -88},
    { 1080, 128, 248},
    { 1072, 264, 192},
    { 1048, 408, 168},
    { 912, 416, 144},
    { 792, 344, 16},
    { 840, 344, -16},
    { 976, 400, -24},
    { 1256, 344, -32},
    { 1336, 352, -56},
    { 1272, 280, 8},
    { 1384, 408, -64},
    { 1304, 336, 96},
    { 1160, 288, 96},
    { 1272, 152, 240},
    { 1216, 88, 336},
    { 1088, 56, 256},
    { 1008, 40, 256},
    { 936, -16, 264},
    { 872, -56, 248},
    // 83 seconds
    { 832, -56, 176},
    { 888, 8, 40},
    { 1016, 16, -48},
    { 1136, 32, -112},
    { 1512, -280, 224},
    { 1400, -24, 160},
    { 1080, 424, -176},
    { 1176, 384, -192},
    { 1128, 416, 8},
    { 1000, 320, 152},
    { 1024, 344, 224},
    { 968, 440, 248},
    { 824, 400, 176},
    { 768, 392, 104},
    { 896, 432, 32},
    { 1184, 376, 72},
    { 1280, 336, 80},
    { 1208, 336, 8},
    { 1552, 416, -88},
    { 1176, 464, 56},
    { 1032, 272, 88},
    { 1184, 64, 240},
    { 944, 176, 344},
    { 992, 144, 112},
    { 976, 24, 192},
    // 84 seconds
    { 872, 40, 160},
    { 816, 40, 136},
    { 744, 40, 88},
    { 808, 32, 64},
    { 1072, -40, 88},
    { 1240, -16, 40},
    { 1528, -136, 152},
    { 1592, -48, 256},
    { 952, 384, -104},
    { 920, 376, -168},
    { 936, 80, 80},
    { 928, 104, 216},
    { 904, 144, 184},
    { 960, 272, 184},
    { 888, 392, 112},
    { 768, 384, 48},
    { 776, 296, 24},
    { 840, 304, 0},
    { 1032, 288, -8},
    { 1312, 336, -48},
    { 1384, 264, 40},
    { 1864, 256, 80},
    { 1432, 360, 40},
    { 872, 216, 24},
    { 1024, 192, 72},
    // 85 seconds
    { 1200, -16, 248},
    { 1040, 72, 272},
    { 864, 88, 200},
    { 808, 40, 176},
    { 800, 16, 208},
    { 744, 16, 176},
    { 760, 8, 120},
    { 808, -8, 56},
    { 976, 88, -72},
    { 1144, -120, 40},
    { 1904, -224, 384},
    { 1456, 224, 152},
    { 912, 720, -432},
    { 824, 104, -224},
    { 928, -32, 24},
    { 936, 88, 32},
    { 992, 168, 72},
    { 936, 288, 48},
    { 904, 368, 24},
    { 864, 360, 0},
    { 936, 320, 16},
    { 1120, 248, -96},
    { 1352, 200, -168},
    { 1632, 128, -80},
    { 1856, 272, -40},
    // 86 seconds
    { 1112, 376, -8},
    { 912, 192, -8},
    { 1320, 40, 112},
    { 1272, -280, 536},
    { 1064, 240, 160},
    { 984, 48, 184},
    { 880, 80, 176},
    { 832, 72, 128},
    { 760, 16, 128},
    { 712, -16, 112},
    { 728, -64, 56},
    { 904, 40, -128},
    { 1128, -48, -48},
    { 1632, -208, 144},
    { 1584, 40, 176},
    { 1072, 440, -296},
    { 1160, 272, -192},
    { 1128, 112, 256},
    { 1072, 264, 256},
    { 1040, 256, 272},
    { 904, 240, 200},
    { 776, 272, 112},
    { 824, 352, -8},
    { 856, 424, -40},
    { 984, 416, -32},
    // 87 seconds
    { 1280, 344, -16},
    { 1320, 136, 200},
    { 1888, 392, 120},
    { 1424, 504, -48},
    { 960, 232, -8},
    { 1240, 112, 88},
    { 1312, 16, 280},
    { 1208, 104, 232},
    { 1024, 56, 200},
    { 912, 24, 168},
    { 840, 16, 160},
    { 768, 8, 144},
    { 720, 8, 104},
    { 720, 0, 24},
    { 832, 56, -128},
    { 928, -8, -40},
    { 1504, -200, 120},
    { 1536, 8, 184},
    { 1480, 352, 8},
    { 1448, 528, -248},
    { 1184, 336, 168},
    { 1008, 264, 184},
    { 1008, 232, 288},
    { 992, 320, 240},
    { 952, 368, 200},
    // 88 seconds
    { 888, 456, 80},
    { 880, 472, 48},
    { 952, 440, -8},
    { 1096, 320, -24},
    { 1208, 328, -32},
    { 1704, 248, 80},
    { 1864, 376, 168},
    { 1184, 288, 184},
    { 1248, 176, 216},
    { 984, -1384, 648},
    { 1280, 192, 208},
    { 992, 16, 224},
    { 872, 200, 112},
    { 720, 88, 104},
    { 640, 56, 80},
    { 568, 24, 48},
    { 560, -24, 56},
    { 680, -48, 0},
    { 984, 48, -104},
    { 1336, -104, 72},
    { 1808, -152, 240},
    { 1608, 664, -272},
    { 1216, 664, -360},
    { 1104, 568, -96},
    { 936, 256, 160},
    // 89 seconds
    { 920, 88, 128},
    { 920, 176, 80},
    { 912, 320, 24},
    { 848, 384, 32},
    { 808, 520, -72},
    { 896, 496, -48},
    { 992, 448, -40},
    { 1184, 400, 24},
    { 1592, 376, 200},
    { 1848, 448, 256},
    { 1192, 472, 80},
    { 1016, 400, 8},
    { 1272, 312, 64},
    { 1320, 168, 200},
    { 1152, 192, 152},
    { 1056, 88, 168},
    { 912, 48, 160},
    { 752, 24, 136},
    { 680, 16, 96},
    { 608, -32, 56},
    { 664, -80, 16},
    { 824, -16, -80},
    { 1088, -56, -16},
    { 1736, -224, 344},
    { 1904, 184, 392},
    // 90 seconds
    { 1376, 728, -288},
    { 1208, 240, -136},
    { 1192, 88, 336},
    { 1216, 384, 264},
    { 1184, 344, 216},
    { 1016, 544, 136},
    { 800, 576, 48},
    { 704, 336, 56},
    { 856, 392, -8},
    { 992, 376, 8},
    { 1288, 360, -40},
    { 1416, 216, 152},
    { 1928, 240, 120},
    { 1528, 304, 184},
    { 1104, 512, 88},
    { 1488, 400, 176},
    { 1528, -104, 136},
    { 1224, -56, 328},
    { 1064, 40, 256},
    { 832, 8, 208},
    { 712, 24, 120},
    { 664, 0, 104},
    { 632, -32, 96},
    { 648, -112, 96},
    { 832, -16, -48},
    // 91 seconds
    { 1040, 80, -200},
    { 1592, -128, 144},
    { 1696, -24, 328},
    { 1568, 408, -24},
    { 1576, 552, -160},
    { 1240, 584, 112},
    { 920, 280, 256},
    { 896, 144, 256},
    { 904, 208, 168},
    { 856, 256, 160},
    { 832, 424, -24},
    { 856, 424, -24},
    { 952, 512, -80},
    { 1168, 368, 0},
    { 1296, 328, 64},
    { 1792, 264, 176},
    { 1640, 344, 192},
    { 1072, 320, 88},
    { 1240, 256, 88},
    { 1464, 128, 208},
    { 1328, 64, 256},
    { 1072, 40, 208},
    { 880, 16, 152},
    { 744, 16, 104},
    { 640, -16, 112},
    // 92 seconds
    { 576, -32, 88},
    { 568, -40, 56},
    { 784, -56, 32},
    { 1024, 64, -80},
    { 1520, -48, 64},
    { 1984, -128, 432},
    { 1632, 384, 80},
    { 1232, 616, -256},
    { 1072, 320, 8},
    { 984, -40, 216},
    { 952, 80, 232},
    { 944, 216, 152},
    { 864, 272, 136},
    { 800, 384, -24},
    { 784, 336, -8},
    { 904, 416, -16},
    { 1128, 360, 16},
    { 1288, 320, 16},
    { 1616, 240, 80},
    { 1824, 328, 88},
    { 1232, 360, 0},
    { 928, 176, 40},
    { 1224, 128, 96},
    { 1264, 64, 176},
    { 1024, 96, 200},
    // 93 seconds
    { 920, 16, 224},
    { 872, 0, 224},
    { 784, 8, 168},
    { 728, -8, 136},
    { 712, 48, 0},
    { 792, -64, 32},
    { 912, 8, -24},
    { 1392, -80, 48},
    { 1696, -24, 272},
    { 1328, 400, -136},
    { 1072, 296, -176},
    { 1120, 120, 0},
    { 1040, 96, 240},
    { 968, 288, 224},
    { 960, 360, 200},
    { 896, 360, 176},
    { 824, 344, 128},
    { 824, 336, 64},
    { 864, 400, 32},
    { 1008, 400, 48},
    { 1216, 360, 96},
    { 1632, 336, 208},
    { 1816, 456, 176},
    { 1112, 376, 16},
    { 888, 240, 56},
    // 94 seconds
    { 1224, 152, 192},
    { 1256, 104, 312},
    { 1120, 104, 136},
    { 944, 104, 120},
    { 848, 56, 136},
    { 784, 32, 120},
    { 744, 0, 120},
    { 680, -24, 112},
    { 664, -64, 64},
    { 888, 32, -88},
    { 1136, 24, -32},
    { 1720, -192, 272},
    { 1672, 120, 240},
    { 1048, 672, -336},
    { 1040, 320, -184},
    { 1048, 64, 248},
    { 1016, 192, 232},
    { 1016, 184, 256},
    { 920, 344, 128},
    { 856, 352, 88},
    { 848, 400, -24},
    { 896, 336, 0},
    { 976, 376, -48},
    { 1200, 336, -48},
    { 1304, 272, -16},
    // 95 seconds
    { 1728, 200, 80},
    { 1496, 296, 72},
    { 992, 224, 80},
    { 1176, 168, 40},
    { 1360, 48, 256},
    { 1200, 88, 264},
    { 1016, 120, 128},
    { 928, 104, 88},
    { 872, 16, 168},
    { 784, -8, 112},
    { 696, -40, 80},
    { 632, -88, 64},
    { 752, -40, -32},
    { 888, 104, -120},
    { 1472, -152, 144},
    { 1680, -64, 352},
    { 1456, 376, 40},
    { 1392, 472, -176},
    { 1160, 504, 40},
    { 904, 232, 232},
    { 944, 112, 240},
    { 952, 200, 216},
    { 952, 360, 96},
    { 904, 368, 72},
    { 880, 408, -8},
    // 96 seconds
    { 864, 424, -16},
    { 1184, 400, -8},
    { 1336, 328, 152},
    { 1720, 296, 272},
    { 1504, 392, 320},
    { 880, 536, 288},
    { 1392, 440, 56},
    { 1392, 208, 280},
    { 1224, 184, 208},
    { 1040, 80, 304},
    { 896, 64, 224},
    { 808, 64, 184},
    { 696, -40, 216},
    { 640, -48, 144},
    { 608, -96, 88},
    { 768, -40, 16},
    { 1024, 104, -80},
    { 1432, 32, 16},
    { 1880, -120, 352},
    { 1592, 296, 120},
    { 1200, 592, -304},
    { 1144, 360, 24},
    { 1032, 96, 320},
    { 1040, 112, 272},
    { 1008, 224, 224},
    // 97 seconds
    { 904, 392, 88},
    { 776, 368, 32},
    { 768, 408, -40},
    { 800, 352, -8},
    { 928, 400, -32},
    { 1200, 336, -32},
    { 1272, 288, 104},
    { 1736, 296, 136},
    { 1584, 440, 120},
    { 1216, 248, 168},
    { 1376, 176, 160},
    { 1520, 104, 248},
    { 1344, 88, 264},
    { 1144, 104, 192},
    { 1008, 72, 144},
    { 896, 24, 152},
    { 808, 0, 104},
    { 696, -32, 64},
    { 560, -48, -16},
    { 560, -72, -64},
    { 792, 16, -128},
    { 1192, -96, 0},
    { 1648, -96, 176},
    { 1512, 160, 136},
    { 1496, 264, -64},
    // 98 seconds
    { 1688, 360, 32},
    { 1440, 496, 216},
    { 1120, 320, 256},
    { 1088, 240, 184},
    { 1008, 264, 136},
    { 880, 368, 40},
    { 808, 392, -32},
    { 824, 448, -32},
    { 1016, 456, -40},
    { 1272, 424, -8},
    { 1328, 320, 112},
    { 1624, 272, 64},
    { 1576, 336, 40},
    { 1088, 192, 72},
    { 1240, 216, 0},
    { 1472, 96, 48},
    { 1296, 48, 240},
    { 1104, 96, 152},
    { 1048, 8, 192},
    { 920, -16, 224},
    { 808, -8, 144},
    { 696, -40, 144},
    { 608, -80, 128},
    { 752, -56, 32},
    { 992, 120, -176},
    // 99 seconds
    { 1336, -8, -48},
    { 1496, -80, 160},
    { 1416, 352, -64},
    { 1488, 768, -240},
    { 1160, 536, 24},
    { 1024, 280, 184},
    { 944, 232, 312},
    { 920, 304, 296},
    { 872, 344, 208},
    { 832, 424, 88},
    { 832, 384, 56},
    { 776, 512, -72},
    { 1112, 384, 128},
    { 1288, 608, 136},
    { 1704, 520, 168},
    { 1792, 464, 144},
    { 1024, 288, 120},
    { 1016, 112, 136},
    { 1320, 48, 224},
    { 1304, 48, 256},
    { 1128, 72, 248},
    { 968, 64, 152},
    { 856, 32, 120},
    { 768, 48, 40},
    { 688, 24, 0},
    // 100 seconds
    { 624, -48, 8},
    { 640, -136, 16},
    { 880, 0, -128},
    { 1344, -128, 88},
    { 1856, -32, 352},
    { 1640, 384, 152},
    { 1448, 608, -128},
    { 1296, 408, 96},
    { 1056, 336, 304},
    { 1008, 32, 368},
    { 992, 176, 224},
    { 912, 304, 120},
    { 856, 384, 8},
    { 824, 448, -40},
    { 856, 432, -8},
    { 1000, 512, -120},
    { 1240, 552, -24},
    { 1496, 552, 176},
    { 1984, 264, 280},
    { 1544, 392, 256},
    { 1104, 184, 192},
    { 1256, 392, -144},
    { 872, -688, 216},
    { 1112, 96, 360},
    { 1040, 192, 216},
    // 101 seconds
    { 816, 192, 64},
    { 704, 144, 48},
    { 672, 72, 96},
    { 632, 24, 72},
    { 648, -32, 56},
    { 976, -72, 64},
    { 1168, 80, -40},
    { 1648, -96, 256},
    { 1648, -16, 336},
    { 1304, 360, 8},
    { 1128, 304, 144},
    { 1040, 192, 104},
    { 920, 112, 248},
    { 952, 112, 232},
    { 936, 200, 200},
    { 896, 352, 64},
    { 832, 328, 48},
    { 840, 408, -16},
    { 920, 416, -40},
    { 1248, 416, -64},
    { 1400, 144, 120},
    { 1792, 88, 152},
    { 1560, 312, 72},
    { 880, 320, 80},
    { 1128, 176, 168},
    // 102 seconds
    { 1456, 24, 288},
    { 1256, 32, 304},
    { 984, 40, 248},
    { 880, 0, 232},
    { 832, 64, 128},
    { 776, 24, 144},
    { 728, -8, 136},
    { 688, -72, 112},
    { 768, -72, 40},
    { 1008, 88, -160},
    { 1400, -72, 16},
    { 1600, -56, 264},
    { 1184, 336, -32},
    { 1272, 344, -128},
    { 1400, 272, 88},
    { 1136, 352, 184},
    { 976, 384, 144},
    { 912, 240, 120},
    { 848, 168, 152},
    { 792, 320, 24},
    { 864, 336, -16},
    { 960, 456, -32},
    { 1088, 432, -24},
    { 1280, 376, -24},
    { 1664, 176, 128},
    // 103 seconds
    { 1816, 280, 128},
    { 1080, 280, 88},
    { 944, 168, 88},
    { 1208, 64, 224},
    { 1208, 40, 280},
    { 1040, 104, 216},
    { 896, 80, 160},
    { 864, 0, 104},
    { 864, -40, 128},
    { 776, -16, 120},
    { 736, 8, 120},
    { 808, 88, -16},
    { 1032, 152, -232},
    { 1120, -72, -224},
    { 1568, -392, 48},
    { 1288, -80, -80},
    { 1104, 72, -128},
    { 1168, 48, 16},
    { 1144, 208, 168},
    { 1048, 232, 200},
    { 1048, 360, 200},
    { 968, 408, 152},
    { 904, 392, 64},
    { 896, 360, -8},
    { 936, 400, -64},
    // 104 seconds
    { 1016, 376, -80},
    { 1216, 400, -96},
    { 1288, 312, 24},
    { 1768, 272, 96},
    { 1704, 344, 96},
    { 984, 216, 96},
    { 1128, 104, 152},
    { 1424, -88, 88},
    { 1264, -88, 504},
    { 1096, 112, 232},
    { 984, 32, 184},
    { 880, 64, 152},
    { 832, 48, 96},
    { 720, 8, 104},
    { 632, -40, 48},
    { 672, -88, -40},
    { 928, 88, -240},
    { 1352, -192, 24},
    { 1632, -120, 176},
    { 1392, 296, -64},
    { 1432, 296, -128},
    { 1464, 288, 168},
    { 1168, 360, 256},
    { 1048, 320, 272},
    { 952, 272, 200},
    // 105 seconds
    { 912, 216, 216},
    { 896, 328, 64},
    { 856, 376, 24},
    { 888, 472, -64},
    { 1056, 480, 24},
    { 1384, 720, 24},
    { 1688, 744, 128},
    { 1816, 416, 152},
    { 1176, 296, 88},
    { 1096, 192, 168},
    { 1608, 336, -56},
    { 1448, 8, 496},
    { 1248, 120, 224},
    { 1104, 24, 256},
    { 976, 16, 232},
    { 808, -8, 176},
    { 704, -24, 144},
    { 632, -24, 64},
    { 584, -80, -24},
    { 744, -56, -104},
    { 928, -32, -184},
    { 1472, -176, 192},
    { 1856, 96, 416},
    { 1616, 568, 80},
    { 1440, 680, -32},
    // 106 seconds
    { 1304, 552, 336},
    { 1040, 456, 376},
    { 1008, 240, 320},
    { 976, 304, 288},
    { 848, 288, 224},
    { 816, 432, 72},
    { 864, 504, 8},
    { 984, 608, -40},
    { 1256, 600, -24},
    { 1616, 552, 120},
    { 1904, 632, 240},
    { 1336, 488, 160},
    { 1120, 280, 80},
    { 1432, 160, 192},
    { 1560, 144, 304},
    { 1360, 56, 312},
    { 1088, -16, 272},
    { 952, 8, 208},
    { 832, 16, 192},
    { 712, 24, 112},
    { 600, -48, 80},
    { 536, -136, 16},
    { 712, -72, -104},
    { 1000, -16, -120},
    { 1360, -192, 104},
    // 107 seconds
    { 1744, -32, 288},
    { 1712, 424, -48},
    { 1824, 560, -88},
    { 1504, 656, 120},
    { 1040, 480, 240},
    { 936, 184, 224},
    { 952, 144, 224},
    { 976, 216, 208},
    { 888, 400, 48},
    { 904, 432, -40},
    { 1056, 632, -152},
    { 1248, 560, -32},
    { 1368, 608, 16},
    { 1704, 488, 48},
    { 1456, 488, 32},
    { 1344, 208, 216},
    { 1656, 192, 224},
    { 1544, 104, 272},
    { 1328, -16, 320},
    { 1128, 24, 192},
    { 1016, 0, 216},
    { 896, -8, 192},
    { 800, 40, 96},
    { 712, -24, 72},
    { 624, -160, 40},
    // 108 seconds
    { 784, -56, -128},
    { 944, -136, -296},
    { 1344, -240, -24},
    { 1504, -152, 128},
    { 1592, 200, -248},
    { 1920, 304, -104},
    { 1776, 392, 256},
    { 1312, 600, 248},
    { 1032, 352, 184},
    { 944, 200, 224},
    { 944, 280, 176},
    { 800, 328, 88},
    { 792, 496, -64},
    { 952, 520, 40},
    { 1192, 696, 0},
    { 1560, 576, 176},
    { 1912, 408, 216},
    { 1392, 304, 80},
    { 1216, 208, 72},
    { 1552, 88, 208},
    { 1704, 16, 344},
    { 1536, 64, 312},
    { 1248, 64, 176},
    { 1104, 0, 216},
    { 920, 64, 112},
    // 109 seconds
    { 808, 0, 128},
    { 656, -104, 24},
    { 504, -160, -16},
    { 576, -160, -56},
    { 824, 0, -256},
    { 1384, -216, 16},
    { 1768, -56, 368},
    { 1808, 392, 104},
    { 1936, 528, -128},
    { 1776, 496, 272},
    { 1256, 440, 416},
    { 1088, 232, 376},
    { 1056, 152, 280},
    { 968, 256, 216},
    { 904, 352, 136},
    { 880, 560, -56},
    { 904, 552, -32},
    { 1192, 664, -96},
    { 1360, 464, 72},
    { 1984, 400, 72},
    { 1680, 200, 88},
    { 1320, 168, 144},
    { 1584, 248, 160},
    { 1752, 144, 208},
    { 1592, 112, 240},
    // 110 seconds
    { 1336, 24, 296},
    { 1144, 16, 264},
    { 952, 16, 200},
    { 808, 16, 168},
    { 696, 8, 80},
    { 568, -112, 80},
    { 568, -88, 24},
    { 728, -48, -136},
    { 1088, 24, -328},
    { 1464, -264, 128},
    { 1640, 184, -72},
    { 1560, 464, -264},
    { 1680, 664, 128},
    { 1552, 472, 528},
    { 1264, 192, 624},
    { 960, 432, 176},
    { 960, 440, 152},
    { 928, 304, 392},
    { 904, 408, 352},
    { 848, 480, 160},
    { 1048, 568, 88},
    { 1280, 704, 72},
    { 1672, 760, 64},
    { 1720, 552, 176},
    { 1312, 320, 208},
    // 111 seconds
    { 1424, 296, 264},
    { 1608, 320, 168},
    { 1704, 192, 184},
    { 1480, 56, 352},
    { 1184, 32, 296},
    { 1080, 32, 208},
    { 928, -72, 272},
    { 776, 0, 136},
    { 696, -80, 104},
    { 608, -48, -96},
    { 696, 32, -224},
    { 968, -216, -64},
    { 1296, -272, 160},
    { 1576, 24, 112},
    { 1672, 296, 0},
    { 1816, 312, 24},
    { 1776, 344, 256},
    { 1552, 512, 280},
    { 1256, 528, 360},
    { 992, 296, 208},
    { 920, 248, 128},
    { 856, 368, 8},
    { 856, 440, -64},
    { 1040, 504, -56},
    { 1216, 544, 0},
    // 112 seconds
    { 1544, 552, 112},
    { 1656, 544, 216},
    { 1312, 360, 208},
    { 1264, 216, 136},
    { 1584, 160, 248},
    { 1872, 88, 384},
    { 1552, -24, 360},
    { 1360, -8, 248},
    { 1192, 32, 184},
    { 1008, 0, 168},
    { 824, 8, 88},
    { 712, -88, 96},
    { 624, -152, 8},
    { 752, -32, -160},
    { 816, -56, -200},
    { 1336, -240, 32},
    { 1544, -48, 192},
    { 1480, 272, -8},
    { 1688, 320, 0},
    { 1800, 344, 328},
    { 1600, 472, 400},
    { 1376, 624, 392},
    { 1072, 440, 288},
    { 896, 360, 96},
    { 888, 208, 72},
    // 113 seconds
    { 968, 368, 8},
    { 952, 560, -64},
    { 1136, 776, -32},
    { 1368, 736, 200},
    { 1776, 504, 200},
    { 1360, 168, 208},
    { 1472, 88, 176},
    { 1720, 112, 288},
    { 1824, 80, 376},
    { 1568, 88, 280},
    { 1352, 56, 216},
    { 1136, 16, 208},
    { 968, -24, 224},
    { 832, -32, 160},
    { 736, -128, 88},
    { 704, -152, -32},
    { 832, -56, -144},
    { 976, -64, -280},
    { 1328, -256, 80},
    { 1480, 24, 400},
    { 1504, 1104, 256},
    { 1320, 1024, -16},
    { 1224, 344, 360},
    { 1208, 56, 536},
    { 1272, 232, 432},
    // 114 seconds
    { 1264, 408, 336},
    { 1056, 624, 256},
    { 880, 600, 224},
    { 848, 528, 112},
    { 984, 488, 72},
    { 1128, 592, 56},
    { 1528, 536, 72},
    { 1672, 552, 136},
    { 1280, 408, 104},
    { 1208, 192, 144},
    { 1656, 16, 304},
    { 1736, -56, 352},
    { 1624, 0, 264},
    { 1312, -16, 184},
    { 992, -16, 152},
    { 744, 48, 168},
    { 632, 64, 160},
    { 480, 184, 88},
    { 480, 360, 80},
    { 496, 536, 48},
    { 584, 696, -16},
    { 728, 760, 176},
    { 920, 1104, 272},
    { 816, 1512, 120},
    { 384, 1168, -96},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-03 09:03:09 local
AccelRawData *activity_sample_walk_200_pbl_25530_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25530_9
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 24, 656, -760},
    { 32, 600, -856},
    { 104, 472, -904},
    { 40, 384, -928},
    { 40, 424, -936},
    { -24, 424, -864},
    { 0, 368, -880},
    { 40, 384, -912},
    { 80, 368, -952},
    { 152, 368, -1000},
    { 72, 344, -976},
    { 96, 312, -976},
    { 64, 272, -968},
    { 104, 256, -984},
    { 160, 312, -992},
    { 120, 264, -1024},
    { 128, 216, -1000},
    { 56, 200, -992},
    { 120, 208, -1016},
    { 144, 192, -992},
    { 64, 144, -984},
    { -40, 152, -1008},
    { 40, 144, -1024},
    { 24, 184, -1032},
    { -24, 96, -960},
    // 1 seconds
    { 32, 48, -992},
    { -8, 64, -1008},
    { 0, 152, -1096},
    { -224, 240, -1152},
    { -1472, 328, -696},
    { 104, 504, -1016},
    { 120, 256, -976},
    { 56, 296, -864},
    { 0, 448, -808},
    { -24, 416, -688},
    { -96, 632, -608},
    { -48, 664, -728},
    { -80, 568, -632},
    { -112, 688, -584},
    { -120, 960, -560},
    { -200, 848, -496},
    { -208, 808, -568},
    { 8, 912, -528},
    { 16, 736, -488},
    { 24, 816, -400},
    { 96, 928, -328},
    { 64, 840, -264},
    { 80, 824, -264},
    { 80, 920, -240},
    { 120, 912, -208},
    // 2 seconds
    { 96, 912, -144},
    { 176, 968, -192},
    { 176, 960, -152},
    { 248, 1064, -184},
    { 224, 1160, -144},
    { 336, 1152, -176},
    { 288, 1048, -152},
    { 248, 1032, -160},
    { 256, 1000, -184},
    { 296, 912, -200},
    { 272, 864, -192},
    { 288, 928, -200},
    { 288, 920, -200},
    { 264, 864, -240},
    { 264, 848, -280},
    { 256, 792, -296},
    { 304, 760, -280},
    { 328, 712, -256},
    { 416, 760, -272},
    { 568, 672, -184},
    { 872, 704, -80},
    { 1144, 632, -64},
    { 832, 544, -120},
    { 824, 336, -72},
    { 816, 184, 48},
    // 3 seconds
    { 880, 112, 240},
    { 760, 152, 296},
    { 888, 312, 272},
    { 968, 312, 320},
    { 1016, 352, 280},
    { 1024, 472, 184},
    { 936, 560, 184},
    { 920, 512, 336},
    { 1024, 664, 400},
    { 1216, 584, 360},
    { 1336, 448, 384},
    { 1696, 592, 344},
    { 1304, 672, 288},
    { 520, 472, 136},
    { 848, 384, 160},
    { 1144, 224, 288},
    { 1104, 48, 464},
    { 984, 112, 296},
    { 952, 120, 176},
    { 792, 136, 152},
    { 672, 104, 136},
    { 664, 48, 88},
    { 656, 8, 48},
    { 888, 72, -32},
    { 1208, 160, -112},
    // 4 seconds
    { 1616, -128, 104},
    { 1768, -184, 328},
    { 1216, 408, -104},
    { 1000, 480, -224},
    { 968, 288, 56},
    { 864, 112, 208},
    { 880, 152, 264},
    { 896, 112, 304},
    { 840, 312, 176},
    { 768, 296, 120},
    { 816, 368, 32},
    { 952, 368, 16},
    { 1280, 408, 24},
    { 1344, 336, 56},
    { 1752, 192, 112},
    { 1328, 344, 64},
    { 888, 264, 32},
    { 1128, 168, 88},
    { 1200, -72, 240},
    { 1024, -136, 320},
    { 968, 112, 112},
    { 880, 8, 160},
    { 840, 48, 112},
    { 824, -16, 120},
    { 768, 0, 56},
    // 5 seconds
    { 776, -48, 24},
    { 920, 72, -112},
    { 1352, 80, -112},
    { 1728, -232, 272},
    { 1416, 280, 136},
    { 1016, 464, -80},
    { 912, 280, 16},
    { 920, 128, 248},
    { 912, 80, 304},
    { 968, 160, 288},
    { 944, 288, 256},
    { 832, 432, 136},
    { 776, 400, 56},
    { 960, 544, -32},
    { 1184, 352, 0},
    { 1304, 392, -24},
    { 1728, 248, 144},
    { 1672, 424, 112},
    { 856, 328, 104},
    { 1024, 232, 72},
    { 1328, 72, 208},
    { 1240, 24, 280},
    { 1048, 80, 160},
    { 944, 64, 104},
    { 848, 8, 112},
    // 6 seconds
    { 808, 24, 96},
    { 744, -32, 72},
    { 728, -88, 64},
    { 888, -8, -64},
    { 1080, 48, -120},
    { 1464, -184, 144},
    { 1552, -32, 248},
    { 1376, 376, -24},
    { 1256, 496, -136},
    { 1024, 304, 144},
    { 976, 120, 280},
    { 992, 176, 280},
    { 936, 264, 256},
    { 856, 408, 96},
    { 752, 360, 56},
    { 880, 496, -16},
    { 1192, 440, -8},
    { 1288, 448, -16},
    { 1896, 344, 112},
    { 1680, 408, 128},
    { 1000, 296, 72},
    { 1272, 168, 168},
    { 1440, 8, 288},
    { 1296, 96, 208},
    { 1040, 48, 192},
    // 7 seconds
    { 856, 8, 128},
    { 696, -48, 128},
    { 608, -16, 64},
    { 600, -64, 96},
    { 736, -96, 112},
    { 1032, 72, -64},
    { 1296, -88, -16},
    { 1832, -328, 264},
    { 1608, 384, 128},
    { 1152, 776, -256},
    { 960, 720, -120},
    { 928, 352, 240},
    { 1016, 208, 224},
    { 976, 240, 312},
    { 864, 424, 264},
    { 688, 496, 128},
    { 712, 368, 16},
    { 864, 296, 64},
    { 1152, 328, 48},
    { 1272, 328, 56},
    { 1688, 552, 160},
    { 1704, 592, 112},
    { 1040, 392, 56},
    { 1120, 344, 40},
    { 968, 376, 400},
    // 8 seconds
    { 1216, 176, 208},
    { 1000, 56, 224},
    { 864, 72, 104},
    { 752, -8, 144},
    { 624, -24, 128},
    { 608, 0, 80},
    { 656, -48, 104},
    { 872, 32, 24},
    { 1120, 120, -24},
    { 1760, -24, 128},
    { 1808, 32, 336},
    { 1232, 384, 40},
    { 1080, 464, -256},
    { 968, 296, 32},
    { 968, 112, 104},
    { 888, 168, 200},
    { 856, 224, 232},
    { 872, 328, 176},
    { 768, 400, 120},
    { 792, 440, 16},
    { 896, 360, 48},
    { 1280, 344, 104},
    { 1256, 256, 168},
    { 1800, 312, 152},
    { 1408, 496, 112},
    // 9 seconds
    { 872, 344, 80},
    { 1184, 272, -24},
    { 1296, 32, 288},
    { 1168, 88, 248},
    { 1008, 32, 216},
    { 920, 40, 152},
    { 824, 24, 120},
    { 752, -24, 160},
    { 744, -8, 112},
    { 760, -56, 56},
    { 968, 32, -16},
    { 1208, -40, 8},
    { 1824, 16, 144},
    { 1392, 128, -248},
    { 1088, 128, -272},
    { 1216, -72, -96},
    { 1264, 192, 544},
    { 888, 528, -24},
    { 960, 240, 168},
    { 936, 376, 184},
    { 840, 344, 280},
    { 776, 352, 176},
    { 856, 344, 56},
    { 1096, 280, 80},
    { 1328, 376, 32},
    // 10 seconds
    { 1616, 328, 64},
    { 1720, 360, 120},
    { 1064, 368, 104},
    { 976, 264, 80},
    { 1248, 144, 128},
    { 1320, 32, 216},
    { 1168, 72, 192},
    { 984, 32, 160},
    { 824, -48, 168},
    { 728, -32, 136},
    { 704, -16, 88},
    { 736, -72, 120},
    { 928, -40, 48},
    { 1080, 152, -168},
    { 1528, -112, 40},
    { 1704, -128, 232},
    { 1224, 336, -152},
    { 1192, 336, -168},
    { 1040, 152, 136},
    { 888, 112, 264},
    { 960, 144, 272},
    { 936, 224, 296},
    { 864, 344, 224},
    { 784, 360, 136},
    { 848, 360, 80},
    // 11 seconds
    { 944, 304, 112},
    { 1232, 368, 40},
    { 1392, 344, 104},
    { 1864, 512, 144},
    { 1320, 488, 16},
    { 840, 320, -8},
    { 1112, 264, 40},
    { 1312, 128, 136},
    { 1144, 40, 216},
    { 968, 40, 168},
    { 864, 16, 136},
    { 776, -24, 168},
    { 688, -8, 120},
    { 672, -24, 120},
    { 784, -64, 72},
    { 1024, 32, -48},
    { 1360, -16, 8},
    { 1800, -264, 312},
    { 1560, 192, 104},
    { 1112, 616, -280},
    { 928, 304, -96},
    { 912, 0, 264},
    { 1016, 112, 312},
    { 1008, 288, 184},
    { 872, 352, 152},
    // 12 seconds
    { 768, 424, 64},
    { 728, 272, 104},
    { 840, 312, 56},
    { 1016, 288, 112},
    { 1272, 392, 72},
    { 1816, 344, 216},
    { 1832, 448, 256},
    { 1008, 264, 72},
    { 984, 264, 48},
    { 1208, 168, 208},
    { 1264, 112, 280},
    { 1072, 168, 88},
    { 920, -48, 224},
    { 760, -80, 216},
    { 672, -24, 104},
    { 648, -32, 112},
    { 664, -24, 112},
    { 840, -40, 72},
    { 1040, 40, -8},
    { 1632, -96, 128},
    { 1968, -48, 264},
    { 1264, 536, -184},
    { 912, 576, -392},
    { 816, 280, 32},
    { 920, 64, 256},
    // 13 seconds
    { 968, 216, 176},
    { 928, 208, 208},
    { 848, 376, 128},
    { 768, 312, 104},
    { 808, 312, 80},
    { 952, 320, 48},
    { 1120, 328, 24},
    { 1248, 288, 72},
    { 1704, 352, 136},
    { 1704, 568, 112},
    { 880, 416, 40},
    { 944, 304, 72},
    { 1200, 128, 144},
    { 1216, 88, 224},
    { 1048, 8, 272},
    { 912, -8, 224},
    { 824, -32, 192},
    { 736, -16, 168},
    { 688, 40, 88},
    { 752, 0, 88},
    { 968, 24, 8},
    { 1096, 56, -72},
    { 1576, -240, 152},
    { 1672, -192, 296},
    { 1040, 432, -104},
    // 14 seconds
    { 1008, 544, -320},
    { 944, 232, 32},
    { 1080, 136, 256},
    { 1000, 288, 192},
    { 920, 288, 184},
    { 832, 328, 152},
    { 768, 368, 64},
    { 808, 312, 72},
    { 1032, 360, 32},
    { 1240, 368, -32},
    { 1392, 144, 56},
    { 1768, 288, 72},
    { 1352, 448, 80},
    { 928, 384, 0},
    { 1104, 264, 96},
    { 1264, 104, 224},
    { 1096, 0, 272},
    { 968, 152, 216},
    { 880, 48, 240},
    { 800, 40, 176},
    { 712, -24, 144},
    { 680, -40, 112},
    { 760, -72, 112},
    { 1032, 16, 16},
    { 1368, -16, 0},
    // 15 seconds
    { 1808, -248, 376},
    { 1328, 88, 216},
    { 1248, 712, -264},
    { 1088, 400, 56},
    { 1104, 416, 248},
    { 984, 200, 288},
    { 920, 288, 208},
    { 800, 328, 208},
    { 744, 288, 216},
    { 728, 336, 112},
    { 880, 352, 128},
    { 1144, 392, 144},
    { 1240, 368, 176},
    { 1680, 432, 184},
    { 1592, 448, 232},
    { 872, 352, 104},
    { 968, 304, 88},
    { 1248, 160, 168},
    { 1224, 120, 176},
    { 968, -8, 264},
    { 808, 32, 176},
    { 744, 16, 152},
    { 696, -24, 176},
    { 744, -16, 136},
    { 864, -56, 128},
    // 16 seconds
    { 1040, 16, 40},
    { 1208, 16, 24},
    { 1688, -280, 344},
    { 1624, 56, 280},
    { 1048, 640, -256},
    { 904, 432, -200},
    { 936, 72, 200},
    { 1024, 120, 224},
    { 992, 200, 240},
    { 880, 384, 160},
    { 768, 408, 112},
    { 736, 344, 88},
    { 864, 280, 112},
    { 960, 320, 80},
    { 1208, 376, 8},
    { 1376, 392, 80},
    { 1904, 472, 144},
    { 1200, 392, 128},
    { 920, 264, 80},
    { 1208, 160, 120},
    { 1328, 72, 216},
    { 1144, 96, 176},
    { 936, 40, 176},
    { 824, 0, 144},
    { 736, -32, 120},
    // 17 seconds
    { 680, -8, 96},
    { 680, -40, 104},
    { 744, -80, 80},
    { 976, 24, -56},
    { 1376, -56, 8},
    { 1848, -176, 296},
    { 1488, 408, -88},
    { 1320, 704, -352},
    { 1040, 360, 24},
    { 824, 64, 248},
    { 848, -24, 240},
    { 920, 40, 232},
    { 880, 280, 128},
    { 768, 336, 56},
    { 824, 336, -8},
    { 904, 296, 48},
    { 1176, 344, 0},
    { 1272, 280, 48},
    { 1680, 376, 64},
    { 1544, 384, 136},
    { 920, 384, 32},
    { 1008, 296, 32},
    { 1272, 168, 152},
    { 1208, 112, 200},
    { 1032, 80, 160},
    // 18 seconds
    { 912, 0, 176},
    { 800, -8, 160},
    { 736, -24, 128},
    { 720, -16, 96},
    { 784, -24, 80},
    { 968, -16, 16},
    { 1080, 32, -32},
    { 1600, -224, 152},
    { 1704, -8, 264},
    { 1144, 544, -136},
    { 1048, 352, -208},
    { 1032, 272, 80},
    { 944, 120, 152},
    { 904, 128, 208},
    { 856, 288, 128},
    { 920, 416, 192},
    { 760, 208, 48},
    { 840, 296, 40},
    { 1024, 328, 40},
    { 1224, 328, 40},
    { 1400, 272, 24},
    { 1768, 328, 56},
    { 1264, 384, 56},
    { 920, 320, 0},
    { 1120, 208, -16},
    // 19 seconds
    { 1224, 104, 48},
    { 1096, 72, 176},
    { 952, 24, 192},
    { 856, 24, 144},
    { 768, -32, 168},
    { 688, 0, 128},
    { 704, -8, 120},
    { 776, -48, 72},
    { 1024, 40, -32},
    { 1200, 0, -8},
    { 1528, -136, 208},
    { 1392, 176, 104},
    { 1264, 544, -40},
    { 1120, 496, -40},
    { 840, 336, 120},
    { 832, 184, 160},
    { 848, 232, 160},
    { 824, 272, 168},
    { 776, 320, 136},
    { 776, 352, 96},
    { 880, 360, 72},
    { 1112, 280, 152},
    { 1312, 328, 160},
    { 1600, 352, 224},
    { 1672, 504, 216},
    // 20 seconds
    { 912, 496, 80},
    { 872, 408, 0},
    { 1568, 256, -792},
    { 1280, 232, 240},
    { 1000, 48, 264},
    { 936, 16, 208},
    { 840, -16, 144},
    { 736, 0, 72},
    { 680, -24, 112},
    { 720, -40, 112},
    { 920, -8, 24},
    { 1120, 128, -32},
    { 1488, -128, 160},
    { 1696, -24, 184},
    { 1168, 528, -208},
    { 1088, 448, -208},
    { 1080, 200, 40},
    { 912, 168, 168},
    { 896, 200, 152},
    { 824, 296, 136},
    { 800, 312, 120},
    { 720, 328, 64},
    { 808, 296, 56},
    { 968, 344, -24},
    { 1184, 288, -16},
    // 21 seconds
    { 1344, 296, 40},
    { 1768, 352, 136},
    { 1312, 504, 88},
    { 792, 312, 48},
    { 1056, 256, 72},
    { 1296, 104, 208},
    { 1096, 104, 200},
    { 960, 112, 80},
    { 872, 48, 88},
    { 768, 32, 80},
    { 728, 8, 72},
    { 696, -32, 96},
    { 752, -64, 80},
    { 1016, 40, -24},
    { 1192, 56, 16},
    { 1688, -160, 224},
    { 1504, 160, 168},
    { 1120, 544, -192},
    { 1040, 328, -88},
    { 888, 152, 208},
    { 928, 120, 176},
    { 936, 184, 176},
    { 896, 360, 112},
    { 792, 360, 40},
    { 776, 336, 24},
    // 22 seconds
    { 888, 360, 24},
    { 1008, 336, 8},
    { 1184, 368, 24},
    { 1304, 320, 120},
    { 1648, 392, 160},
    { 1256, 488, 136},
    { 928, 296, 96},
    { 1184, 232, 120},
    { 1304, 88, 280},
    { 1096, 80, 240},
    { 984, 88, 120},
    { 920, 32, 120},
    { 816, -8, 136},
    { 728, -8, 104},
    { 696, -56, 96},
    { 728, -96, 56},
    { 936, 40, -40},
    { 1192, -72, 64},
    { 1704, -176, 336},
    { 1456, 264, 168},
    { 1352, 592, -208},
    { 1232, 440, -40},
    { 912, 240, 192},
    { 920, 88, 176},
    { 952, 144, 184},
    // 23 seconds
    { 896, 344, 112},
    { 808, 360, 80},
    { 816, 400, 0},
    { 928, 416, -8},
    { 1144, 360, 16},
    { 1344, 232, 128},
    { 1856, 224, 200},
    { 1680, 392, 200},
    { 848, 304, 40},
    { 944, 192, 32},
    { 1304, 16, 80},
    { 1240, -80, 280},
    { 984, 80, 160},
    { 824, -8, 144},
    { 696, -40, 168},
    { 648, -16, 144},
    { 672, -32, 120},
    { 760, -8, 80},
    { 888, 32, 16},
    { 1176, 120, -88},
    { 1432, -128, 112},
    { 1576, -184, 240},
    { 1288, 224, -16},
    { 1192, 392, -208},
    { 1072, 336, -112},
    // 24 seconds
    { 840, 176, 104},
    { 848, 160, 128},
    { 896, 176, 200},
    { 880, 312, 136},
    { 800, 344, 56},
    { 848, 344, -16},
    { 960, 328, -16},
    { 1256, 328, 24},
    { 1248, 344, 16},
    { 1680, 320, 120},
    { 1576, 392, 184},
    { 960, 288, 104},
    { 1088, 240, 64},
    { 1296, 104, 168},
    { 1264, 120, 168},
    { 1048, 48, 192},
    { 872, 8, 152},
    { 760, -8, 104},
    { 680, -32, 104},
    { 648, -48, 112},
    { 696, -56, 80},
    { 944, -24, 48},
    { 1064, 48, -16},
    { 1632, -240, 192},
    { 1696, 24, 232},
    // 25 seconds
    { 1352, 560, -152},
    { 1208, 416, -200},
    { 968, 200, 112},
    { 912, 136, 192},
    { 928, 136, 184},
    { 872, 272, 184},
    { 800, 336, 96},
    { 752, 304, 56},
    { 864, 336, 16},
    { 1000, 336, 32},
    { 1208, 320, 16},
    { 1408, 192, 152},
    { 1896, 272, 216},
    { 1344, 376, 112},
    { 840, 288, 40},
    { 1176, 304, -208},
    { 1216, 40, 304},
    { 1088, 104, 96},
    { 920, 24, 168},
    { 808, -56, 184},
    { 704, -40, 136},
    { 632, -32, 112},
    { 632, -40, 112},
    { 768, -32, 72},
    { 1048, 72, -40},
    // 26 seconds
    { 1336, 24, 16},
    { 1856, -360, 384},
    { 1576, 256, 96},
    { 1160, 624, -304},
    { 1040, 336, -128},
    { 912, 32, 160},
    { 872, 312, 128},
    { 912, 120, 216},
    { 848, 248, 184},
    { 784, 280, 128},
    { 768, 272, 72},
    { 864, 304, 56},
    { 1048, 280, 24},
    { 1296, 288, 0},
    { 1432, 136, 48},
    { 1784, 200, 64},
    { 1272, 360, 16},
    { 720, 280, 8},
    { 1008, 176, -40},
    { 1120, 32, 248},
    { 1056, 104, 216},
    { 904, 72, 168},
    { 824, 8, 152},
    { 760, -32, 168},
    { 720, -40, 152},
    // 27 seconds
    { 736, -8, 104},
    { 944, 8, 24},
    { 1208, 64, -40},
    { 1184, -16, 64},
    { 1592, -264, 264},
    { 1264, 104, 128},
    { 1040, 432, -128},
    { 1088, 296, -104},
    { 904, 208, 128},
    { 848, 112, 160},
    { 864, 168, 160},
    { 896, 304, 104},
    { 840, 336, 72},
    { 800, 288, 48},
    { 912, 336, 8},
    { 1064, 272, 32},
    { 1184, 256, 8},
    { 1432, 104, 152},
    { 1632, 360, 40},
    { 1104, 368, 160},
    { 1080, 264, 104},
    { 1344, 136, 216},
    { 1240, 104, 240},
    { 1064, 40, 152},
    { 928, 48, 120},
    // 28 seconds
    { 792, 24, 104},
    { 704, -56, 128},
    { 656, -56, 104},
    { 696, -104, 112},
    { 872, -96, 96},
    { 1136, 8, 112},
    { 1440, -80, 72},
    { 1736, -200, 384},
    { 1352, 408, 184},
    { 1336, 872, -296},
    { 1272, 520, 64},
    { 864, 328, 312},
    { 784, 96, 304},
    { 856, 104, 208},
    { 872, 176, 168},
    { 776, 376, 72},
    { 792, 304, 64},
    { 928, 336, 48},
    { 1192, 128, 152},
    { 1256, 208, 184},
    { 1592, 200, 272},
    { 1664, 448, 400},
    { 920, 488, 288},
    { 1048, 424, 56},
    { 1424, 80, 304},
    // 29 seconds
    { 1208, 248, 536},
    { 888, -64, 464},
    { 792, -64, 288},
    { 680, 24, 144},
    { 688, 24, 144},
    { 696, 40, 120},
    { 736, -16, 120},
    { 904, 64, 72},
    { 1120, 64, 0},
    { 1488, -112, 144},
    { 1688, -168, 376},
    { 1360, 376, 24},
    { 1208, 704, -264},
    { 968, 376, 48},
    { 824, 152, 160},
    { 856, -8, 240},
    { 928, 160, 208},
    { 800, 312, 48},
    { 736, 344, -8},
    { 824, 256, 40},
    { 880, 248, 24},
    { 1168, 192, 48},
    { 1288, 272, 32},
    { 1664, 128, 216},
    { 1672, 304, 208},
    // 30 seconds
    { 968, 320, 128},
    { 976, 176, 40},
    { 1040, -56, 152},
    { 984, 72, 224},
    { 904, 128, 112},
    { 808, 64, 144},
    { 744, 8, 136},
    { 704, -80, 192},
    { 712, -56, 168},
    { 832, -24, 128},
    { 1032, 16, 72},
    { 1160, 72, 8},
    { 1640, -152, 232},
    { 1448, 40, 208},
    { 1024, 440, -120},
    { 1016, 328, -184},
    { 912, 128, 56},
    { 824, -8, 120},
    { 840, 232, 80},
    { 856, 272, 104},
    { 800, 224, 152},
    { 816, 312, 80},
    { 896, 336, 32},
    { 1056, 312, 48},
    { 1232, 312, 24},
    // 31 seconds
    { 1432, 192, 152},
    { 1760, 400, 136},
    { 1112, 400, 160},
    { 800, 216, 112},
    { 1240, 224, -80},
    { 1304, 80, 344},
    { 1064, 104, 144},
    { 920, 96, 144},
    { 848, 72, 88},
    { 792, -24, 144},
    { 736, -16, 128},
    { 704, -56, 112},
    { 800, -80, 80},
    { 1000, 8, 32},
    { 1416, -48, 40},
    { 1704, -136, 328},
    { 1328, 328, 24},
    { 1120, 520, -216},
    { 960, 184, 40},
    { 904, -24, 224},
    { 976, 56, 256},
    { 968, 232, 224},
    { 872, 416, 152},
    { 800, 424, 48},
    { 832, 416, -8},
    // 32 seconds
    { 976, 400, -64},
    { 1240, 280, -48},
    { 1320, 256, 48},
    { 1712, 136, 288},
    { 1664, 344, 296},
    { 928, 296, 104},
    { 1096, 104, 176},
    { 1408, 64, 264},
    { 1384, 40, 296},
    { 1096, -40, 248},
    { 848, -8, 128},
    { 712, -32, 104},
    { 600, -48, 72},
    { 576, -32, 16},
    { 600, -88, -8},
    { 848, -16, -48},
    { 1016, 48, -72},
    { 1544, -256, 264},
    { 1896, 0, 368},
    { 1720, 712, -88},
    { 1336, 680, -232},
    { 992, 456, 168},
    { 896, -48, 368},
    { 952, 88, 232},
    { 896, 232, 168},
    // 33 seconds
    { 832, 376, 112},
    { 792, 392, 0},
    { 832, 352, 16},
    { 1072, 304, 80},
    { 1216, 480, 0},
    { 1456, 304, 168},
    { 1824, 408, 224},
    { 1216, 288, 320},
    { 1128, 392, 96},
    { 1416, 240, 168},
    { 1488, 152, 208},
    { 1280, 32, 264},
    { 1056, -8, 240},
    { 880, -24, 168},
    { 736, -80, 152},
    { 648, -56, 48},
    { 560, -144, 56},
    { 704, -40, -32},
    { 904, 16, 16},
    { 1248, 8, -48},
    { 1736, -144, 336},
    { 1768, 336, 200},
    { 1736, 632, -96},
    { 1440, 456, 88},
    { 1024, 328, 304},
    // 34 seconds
    { 920, 136, 288},
    { 920, 64, 248},
    { 912, 136, 288},
    { 792, 392, 80},
    { 800, 400, -32},
    { 920, 408, 0},
    { 1096, 416, 56},
    { 1224, 312, 112},
    { 1632, 248, 224},
    { 1608, 280, 224},
    { 1184, 344, 136},
    { 1240, 272, 144},
    { 1464, 104, 312},
    { 1344, -32, 360},
    { 1168, 40, 248},
    { 984, 48, 152},
    { 832, -32, 144},
    { 688, -120, 184},
    { 600, -128, 128},
    { 672, -64, -16},
    { 840, 64, -176},
    { 928, -40, 40},
    { 1448, -256, 264},
    { 1696, 72, 296},
    { 1808, 696, -64},
    // 35 seconds
    { 1496, 640, -56},
    { 1032, 264, 328},
    { 920, -48, 368},
    { 1056, 64, 288},
    { 984, 248, 216},
    { 840, 424, 64},
    { 736, 344, 80},
    { 816, 456, 40},
    { 992, 464, 40},
    { 1312, 528, 8},
    { 1472, 232, 288},
    { 1968, 304, 320},
    { 1416, 232, 216},
    { 1168, 232, 144},
    { 1488, 216, 208},
    { 1568, 64, 328},
    { 1344, 40, 184},
    { 1024, -32, 176},
    { 744, -72, 160},
    { 568, -88, 104},
    { 504, -96, 80},
    { 584, -80, 40},
    { 784, -64, 8},
    { 1032, 32, -24},
    { 1272, 16, 56},
    // 36 seconds
    { 1752, -160, 360},
    { 1696, 232, 256},
    { 1560, 648, -168},
    { 1336, 504, -8},
    { 968, 112, 296},
    { 928, 112, 272},
    { 936, 176, 208},
    { 888, 184, 240},
    { 840, 392, 112},
    { 824, 368, 56},
    { 904, 416, 16},
    { 1152, 344, 32},
    { 1304, 360, 64},
    { 1784, 200, 208},
    { 1560, 360, 160},
    { 1008, 256, 120},
    { 1144, 152, 136},
    { 1392, -24, 232},
    { 1280, 0, 264},
    { 1096, 40, 160},
    { 920, -8, 168},
    { 792, -16, 128},
    { 688, -56, 112},
    { 656, -72, 104},
    { 752, -80, 72},
    // 37 seconds
    { 992, -16, 8},
    { 1088, 56, -8},
    { 1600, -88, 80},
    { 1600, -104, 384},
    { 1312, 360, 64},
    { 1352, 480, -168},
    { 1080, 248, 128},
    { 992, 96, 200},
    { 936, 232, 240},
    { 912, 232, 256},
    { 840, 320, 112},
    { 768, 248, 128},
    { 824, 304, 56},
    { 824, 288, 16},
    { 1024, 272, 24},
    { 1208, 240, 64},
    { 1392, 176, 96},
    { 1888, 216, 152},
    { 1328, 432, 224},
    { 960, 264, 80},
    { 1136, 192, 40},
    { 1192, 120, 296},
    { 1128, 128, 104},
    { 944, 16, 200},
    { 784, -8, 160},
    // 38 seconds
    { 680, -40, 160},
    { 640, -48, 144},
    { 664, -32, 112},
    { 792, -24, 80},
    { 1008, 24, 16},
    { 1240, 64, 64},
    { 1728, -88, 184},
    { 1640, 96, 136},
    { 1376, 552, -288},
    { 1064, 376, -176},
    { 776, 112, 120},
    { 856, 128, 128},
    { 880, 96, 176},
    { 896, 192, 240},
    { 840, 360, 112},
    { 776, 312, 64},
    { 848, 360, 8},
    { 968, 272, 72},
    { 1256, 328, 48},
    { 1272, 136, 128},
    { 1712, 168, 72},
    { 1440, 352, 16},
    { 920, 232, 48},
    { 1056, 136, 64},
    { 1176, -56, 136},
    // 39 seconds
    { 1136, 40, 176},
    { 1032, 152, 120},
    { 944, 208, 48},
    { 704, -32, -8},
    { 528, -104, 56},
    { 504, -120, 56},
    { 640, -64, 32},
    { 864, -8, 32},
    { 1136, 104, -24},
    { 1504, -128, 56},
    { 2016, -312, 352},
    { 1512, 336, 56},
    { 1016, 648, -264},
    { 968, 304, -72},
    { 840, 0, 200},
    { 872, 56, 184},
    { 944, 144, 168},
    { 880, 296, 128},
    { 768, 320, 32},
    { 720, 304, -8},
    { 824, 288, -8},
    { 960, 224, 40},
    { 1296, 272, 64},
    { 1456, 152, 160},
    { 1840, 152, 304},
    // 40 seconds
    { 1240, 424, 168},
    { 840, 264, 80},
    { 1208, 224, 8},
    { 1224, -120, 400},
    { 1072, 152, 112},
    { 856, 40, 160},
    { 784, 40, 96},
    { 704, -8, 112},
    { 664, -16, 88},
    { 672, -40, 96},
    { 728, -56, 56},
    { 968, 24, 0},
    { 1272, -88, 88},
    { 1752, -144, 400},
    { 1608, 360, 136},
    { 1296, 744, -200},
    { 1032, 400, -16},
    { 816, -112, 152},
    { 792, 144, 168},
    { 816, 32, 200},
    { 832, 168, 192},
    { 800, 376, 80},
    { 752, 328, 48},
    { 776, 328, 48},
    { 864, 280, 88},
    // 41 seconds
    { 1096, 256, 88},
    { 1256, 328, 128},
    { 1848, 360, 312},
    { 1632, 552, 232},
    { 1016, 336, 72},
    { 1120, 240, 112},
    { 1280, 88, 168},
    { 1024, 120, 208},
    { 808, 48, 192},
    { 728, 8, 144},
    { 704, -56, 160},
    { 704, -32, 120},
    { 744, -32, 120},
    { 776, -72, 104},
    { 944, 0, 40},
    { 1168, -16, 56},
    { 1680, -160, 272},
    { 1584, 200, 160},
    { 1256, 512, -168},
    { 1136, 368, -192},
    { 888, 120, 200},
    { 832, 456, 96},
    { 848, 160, 136},
    { 840, 176, 184},
    { 816, 304, 88},
    // 42 seconds
    { 800, 272, 88},
    { 880, 376, 0},
    { 1072, 304, 56},
    { 1232, 392, 0},
    { 1472, 248, 104},
    { 1712, 320, 160},
    { 1128, 336, 120},
    { 1016, 232, 64},
    { 1216, 136, 120},
    { 1192, 184, 304},
    { 1080, 184, 184},
    { 920, 152, 128},
    { 800, 136, 64},
    { 688, 40, 136},
    { 624, 24, 136},
    { 624, -16, 64},
    { 664, -104, 64},
    { 912, -112, 136},
    { 1168, -40, 128},
    { 1768, -96, 288},
    { 1920, 176, 328},
    { 1448, 816, -208},
    { 992, 408, -80},
    { 888, -144, 216},
    { 896, 352, 136},
    // 43 seconds
    { 928, 72, 264},
    { 896, 208, 224},
    { 808, 368, 56},
    { 680, 312, 72},
    { 792, 360, 32},
    { 888, 288, 96},
    { 1256, 264, 104},
    { 1328, 152, 168},
    { 1680, 248, 168},
    { 1296, 360, 32},
    { 1048, 272, 24},
    { 1160, 160, 80},
    { 1040, 264, 168},
    { 1104, 312, -16},
    { 928, 40, 192},
    { 792, 104, 72},
    { 744, 48, 64},
    { 704, -16, 112},
    { 728, 24, 48},
    { 792, -16, 32},
    { 992, 8, 0},
    { 1144, -32, 56},
    { 1712, -192, 304},
    { 1584, 184, 280},
    { 1136, 648, -120},
    // 44 seconds
    { 936, 296, -16},
    { 952, 104, 224},
    { 928, 40, 296},
    { 928, 192, 264},
    { 856, 312, 184},
    { 808, 352, 104},
    { 760, 336, 64},
    { 784, 296, 56},
    { 992, 288, 16},
    { 1208, 312, 8},
    { 1280, 328, 16},
    { 1624, 352, 64},
    { 1384, 416, 104},
    { 992, 304, 48},
    { 1192, 224, 72},
    { 1328, 128, 144},
    { 1176, 48, 152},
    { 976, 24, 120},
    { 792, -48, 120},
    { 648, -24, 96},
    { 568, -40, 88},
    { 560, -32, 96},
    { 648, -32, 104},
    { 904, 16, 72},
    { 1248, 80, 32},
    // 45 seconds
    { 1800, -392, 616},
    { 1768, 336, 144},
    { 1352, 952, -632},
    { 896, 88, -224},
    { 608, -272, 152},
    { 840, 232, 96},
    { 944, 144, 280},
    { 936, 352, 240},
    { 816, 248, 200},
    { 792, 288, 144},
    { 816, 288, 80},
    { 872, 224, 88},
    { 1248, 264, 8},
    { 1200, 184, 192},
    { 1600, 552, 80},
    { 1288, 632, 120},
    { 976, 336, 104},
    { 1152, 160, 160},
    { 1304, 48, 248},
    { 1208, 32, 152},
    { 1024, 64, 72},
    { 840, 72, 40},
    { 744, 32, 40},
    { 648, 8, 24},
    { 632, 8, 32},
    // 46 seconds
    { 736, -40, 56},
    { 968, -8, 32},
    { 1088, 48, 24},
    { 1568, -160, 224},
    { 1760, -16, 304},
    { 1224, 544, -32},
    { 1024, 408, -72},
    { 896, 56, 192},
    { 824, -16, 312},
    { 952, 136, 232},
    { 936, 304, 168},
    { 848, 328, 112},
    { 824, 312, 48},
    { 816, 296, 48},
    { 944, 304, 48},
    { 1120, 256, 56},
    { 1248, 392, 56},
    { 1704, 296, 136},
    { 1640, 360, 80},
    { 1008, 368, -40},
    { 1032, 232, -64},
    { 1296, 120, 72},
    { 1160, 56, 168},
    { 984, 88, 104},
    { 896, 16, 112},
    // 47 seconds
    { 776, -64, 176},
    { 656, -48, 136},
    { 584, -48, 96},
    { 584, -24, 48},
    { 712, -8, 32},
    { 1000, 48, 0},
    { 1392, -136, 104},
    { 2160, -296, 480},
    { 1656, 536, 56},
    { 1104, 880, -344},
    { 976, 184, 16},
    { 848, -32, 304},
    { 880, -64, 336},
    { 896, 112, 232},
    { 808, 336, 112},
    { 792, 312, 88},
    { 856, 408, -56},
    { 896, 264, 16},
    { 1072, 336, -24},
    { 1296, 264, 16},
    { 1744, 136, 128},
    { 1840, 160, 184},
    { 1000, 280, 64},
    { 992, 168, 32},
    { 1240, -80, 88},
    // 48 seconds
    { 1248, -32, 256},
    { 1008, 80, 144},
    { 800, 32, 104},
    { 656, 16, 56},
    { 568, -24, 88},
    { 544, -64, 120},
    { 608, -64, 104},
    { 776, -32, 72},
    { 1136, 24, 72},
    { 1632, -16, 128},
    { 1952, -160, 392},
    { 1440, 304, 24},
    { 1032, 504, -216},
    { 936, 272, 32},
    { 936, 216, 104},
    { 872, 16, 304},
    { 872, 168, 264},
    { 864, 304, 184},
    { 808, 368, 64},
    { 816, 272, 72},
    { 904, 344, -24},
    { 1112, 256, 32},
    { 1288, 312, -8},
    { 1520, 176, 64},
    { 1800, 224, 112},
    // 49 seconds
    { 1168, 368, 56},
    { 824, 272, 0},
    { 1032, 144, 88},
    { 1144, 8, 264},
    { 1024, 40, 224},
    { 920, 32, 160},
    { 824, -32, 192},
    { 760, -24, 152},
    { 736, -24, 120},
    { 760, -24, 112},
    { 872, -8, 40},
    { 1032, 104, -72},
    { 1496, -168, 120},
    { 1688, -104, 288},
    { 1152, 384, -144},
    { 1064, 408, -264},
    { 944, 40, 88},
    { 936, 32, 232},
    { 936, 360, 96},
    { 888, 200, 232},
    { 832, 344, 144},
    { 768, 224, 184},
    { 840, 296, 80},
    { 896, 264, 64},
    { 1136, 360, 16},
    // 50 seconds
    { 1216, 328, 48},
    { 1640, 304, 128},
    { 1744, 400, 168},
    { 928, 416, 112},
    { 1024, 288, 128},
    { 1312, 184, 88},
    { 1184, 64, 368},
    { 1048, 96, 176},
    { 944, 24, 184},
    { 848, -8, 152},
    { 760, -40, 176},
    { 736, -16, 144},
    { 744, -16, 80},
    { 840, -104, 96},
    { 984, -32, 32},
    { 1496, -80, 72},
    { 1648, -80, 336},
    { 1096, 384, -48},
    { 1136, 384, -176},
    { 1200, 240, 144},
    { 1040, 64, 304},
    { 984, 344, 248},
    { 904, 456, 200},
    { 800, 312, 224},
    { 720, 280, 160},
    // 51 seconds
    { 800, 232, 104},
    { 848, 336, 72},
    { 1104, 344, 136},
    { 1304, 312, 208},
    { 1784, 376, 336},
    { 1592, 488, 320},
    { 816, 272, 152},
    { 1048, 264, 152},
    { 1440, 184, 200},
    { 1256, 112, 232},
    { 1040, 96, 168},
    { 904, -8, 144},
    { 752, -64, 152},
    { 656, -24, 104},
    { 608, -32, 64},
    { 640, -72, 64},
    { 840, -16, -8},
    { 1096, 64, -8},
    { 1656, -80, 168},
    { 1984, -56, 448},
    { 1328, 704, -48},
    { 1080, 600, -120},
    { 1000, 232, 160},
    { 976, 32, 296},
    { 944, 24, 256},
    // 52 seconds
    { 896, 232, 136},
    { 816, 360, 72},
    { 784, 344, 32},
    { 808, 312, 40},
    { 912, 360, 16},
    { 1128, 272, 64},
    { 1272, 280, 56},
    { 1592, 184, 168},
    { 1808, 248, 240},
    { 1064, 344, 128},
    { 1024, 176, 80},
    { 1312, -80, 224},
    { 1200, 80, 272},
    { 1016, 80, 184},
    { 840, 40, 136},
    { 728, 8, 112},
    { 664, -8, 112},
    { 648, -56, 120},
    { 696, -80, 112},
    { 928, -56, 80},
    { 1096, 112, 0},
    { 1456, -40, 160},
    { 1680, -80, 344},
    { 1272, 440, 16},
    { 1144, 520, -96},
    // 53 seconds
    { 1032, 176, -56},
    { 872, 72, 232},
    { 912, 152, 176},
    { 872, 240, 176},
    { 856, 376, 128},
    { 800, 312, 112},
    { 856, 280, 88},
    { 976, 304, 88},
    { 1120, 296, 40},
    { 1216, 336, 16},
    { 1680, 320, 112},
    { 1592, 408, 120},
    { 1120, 280, 104},
    { 1152, 152, 104},
    { 1568, 40, -416},
    { 912, -336, 280},
    { 960, 128, 72},
    { 816, 24, 200},
    { 760, 48, 96},
    { 712, -16, 112},
    { 696, 8, 96},
    { 744, -64, 112},
    { 912, -80, 96},
    { 1048, 24, -16},
    { 1496, -152, 136},
    // 54 seconds
    { 1552, 16, 232},
    { 1168, 472, -112},
    { 1168, 424, -192},
    { 984, 88, 176},
    { 960, 48, 120},
    { 976, 136, 216},
    { 952, 376, 192},
    { 856, 360, 136},
    { 808, 296, 88},
    { 888, 304, 48},
    { 1008, 312, 40},
    { 1232, 360, 0},
    { 1280, 232, 128},
    { 1768, 328, 192},
    { 1360, 432, 152},
    { 920, 256, 72},
    { 1128, 168, 128},
    { 1064, 208, 312},
    { 1104, 184, 160},
    { 984, 8, 192},
    { 856, 32, 160},
    { 768, -24, 152},
    { 736, -32, 120},
    { 736, -48, 136},
    { 784, -96, 112},
    // 55 seconds
    { 936, 32, -32},
    { 1224, -80, 32},
    { 1496, -256, 328},
    { 1520, 152, 224},
    { 1296, 672, -304},
    { 1088, 416, -112},
    { 920, 136, 216},
    { 912, 168, 224},
    { 888, 120, 240},
    { 864, 328, 136},
    { 808, 328, 56},
    { 816, 352, -8},
    { 984, 368, -72},
    { 1136, 312, -56},
    { 1288, 248, -40},
    { 1496, 176, 120},
    { 1696, 328, 200},
    { 1136, 448, 184},
    { 920, 136, 144},
    { 1304, 48, 232},
    { 1392, 40, 312},
    { 1144, -16, 272},
    { 984, -8, 160},
    { 840, -64, 152},
    { 744, -48, 96},
    // 56 seconds
    { 616, -40, 88},
    { 592, -72, 64},
    { 728, -48, 0},
    { 920, 16, -48},
    { 1376, -160, 40},
    { 1960, -192, 472},
    { 1560, 360, 200},
    { 1360, 576, -200},
    { 1328, 392, -64},
    { 984, 200, 224},
    { 864, 192, 208},
    { 856, 144, 224},
    { 816, 256, 152},
    { 784, 312, 88},
    { 824, 360, 40},
    { 920, 328, 48},
    { 1152, 352, 24},
    { 1216, 328, 88},
    { 1680, 288, 152},
    { 1600, 376, 152},
    { 1016, 240, 128},
    { 1088, 144, 144},
    { 1104, 192, 520},
    { 1192, 96, 248},
    { 1032, 32, 200},
    // 57 seconds
    { 880, 48, 144},
    { 784, 8, 120},
    { 688, -56, 152},
    { 664, -56, 128},
    { 720, -96, 72},
    { 904, -48, 0},
    { 1040, 56, -80},
    { 1576, -192, 176},
    { 1744, 8, 304},
    { 1416, 528, -104},
    { 1248, 464, -160},
    { 1000, 224, 192},
    { 912, 80, 296},
    { 936, 120, 288},
    { 888, 240, 168},
    { 824, 320, 112},
    { 792, 336, 32},
    { 840, 320, 48},
    { 1040, 312, 64},
    { 1208, 376, -8},
    { 1432, 232, 120},
    { 1832, 360, 144},
    { 1208, 288, 168},
    { 1072, 232, 32},
    { 1256, 64, 112},
    // 58 seconds
    { 1408, 24, 240},
    { 1176, 72, 136},
    { 992, 16, 152},
    { 848, -16, 112},
    { 728, -40, 80},
    { 632, -104, 112},
    { 552, -88, 72},
    { 640, -72, 8},
    { 928, 24, -56},
    { 1272, -56, 80},
    { 1976, -8, 496},
    { 1592, 168, 384},
    { 1368, 688, -160},
    { 1208, 368, 144},
    { 968, 208, 296},
    { 968, 48, 272},
    { 912, 192, 168},
    { 824, 320, 152},
    { 784, 480, 40},
    { 760, 376, 72},
    { 928, 384, 48},
    { 1120, 304, 96},
    { 1232, 288, 104},
    { 1568, 176, 240},
    { 1776, 224, 240},
    // 59 seconds
    { 960, 288, 160},
    { 1280, 200, 40},
    { 1232, 248, 824},
    { 1352, 64, 272},
    { 1016, 72, 224},
    { 856, 104, 104},
    { 744, 8, 104},
    { 648, -32, 104},
    { 584, -64, 72},
    { 568, -88, 88},
    { 744, -56, 32},
    { 1064, 80, -40},
    { 1640, -48, 144},
    { 2088, -120, 440},
    { 1416, 616, -88},
    { 1000, 600, -224},
    { 936, 288, 168},
    { 984, 64, 304},
    { 896, 88, 216},
    { 912, 272, 136},
    { 848, 376, 48},
    { 752, 392, 32},
    { 784, 328, 40},
    { 904, 344, 0},
    { 1128, 280, 8},
    // 60 seconds
    // elapsed: 1 minutes
    { 1280, 320, 32},
    { 1624, 216, 80},
    { 1736, 256, 96},
    { 1040, 360, -24},
    { 1064, 592, -272},
    { 1072, 168, -8},
    { 1192, 72, 256},
    { 1032, 176, 288},
    { 920, 160, 104},
    { 824, 56, 112},
    { 720, 24, 112},
    { 672, 0, 104},
    { 672, -8, 72},
    { 720, 0, -8},
    { 1096, 136, -112},
    { 1400, -80, 160},
    { 1792, -96, 344},
    { 1312, 264, 120},
    { 960, 432, -80},
    { 1008, 184, 96},
    { 1056, 144, 224},
    { 944, 88, 224},
    { 904, 208, 160},
    { 864, 312, 128},
    { 824, 416, 16},
    // 61 seconds
    { 784, 312, 32},
    { 888, 424, -88},
    { 1080, 416, 48},
    { 1384, 456, 120},
    { 1440, 344, 208},
    { 1688, 376, 192},
    { 1288, 416, 96},
    { 1200, 264, 160},
    { 1360, 104, 208},
    { 1288, -8, 272},
    { 1040, 8, 216},
    { 840, 24, 144},
    { 680, 8, 112},
    { 592, 8, 72},
    { 576, -40, 88},
    { 648, -80, 88},
    { 832, -72, 64},
    { 1048, 24, 24},
    { 1512, -104, 136},
    { 1928, -88, 424},
    { 1552, 648, -56},
    { 1264, 632, -208},
    { 1040, 336, 136},
    { 872, -48, 248},
    { 912, 88, 184},
    // 62 seconds
    { 880, 216, 144},
    { 920, 424, 40},
    { 832, 344, 72},
    { 856, 344, 32},
    { 928, 240, 104},
    { 1112, 344, -40},
    { 1192, 232, 48},
    { 1688, 264, 120},
    { 1760, 328, 168},
    { 1064, 288, 16},
    { 1112, 256, -8},
    { 1336, 160, 120},
    { 1288, 128, 176},
    { 1072, 72, 176},
    { 920, 40, 128},
    { 848, -48, 160},
    { 736, -72, 152},
    { 688, -48, 88},
    { 648, -104, 80},
    { 848, 24, -88},
    { 944, 24, -40},
    { 1496, -200, 232},
    { 1776, 96, 288},
    { 1504, 584, -64},
    { 1448, 536, -96},
    // 63 seconds
    { 1200, 376, 152},
    { 968, 128, 280},
    { 984, 80, 184},
    { 920, 192, 96},
    { 888, 408, -48},
    { 832, 400, -48},
    { 928, 400, -72},
    { 976, 280, 64},
    { 1280, 328, 48},
    { 1400, 240, 208},
    { 1832, 320, 272},
    { 1680, 496, 296},
    { 1504, 864, 112},
    { 992, -320, 896},
    { 1128, 232, 152},
    { 1104, -64, 136},
    { 808, 136, 152},
    { 592, 32, 24},
    { 544, 16, 40},
    { 568, -16, 64},
    { 624, -56, 80},
    { 720, -48, 72},
    { 984, -16, 48},
    { 1312, -32, 104},
    { 2048, -184, 440},
    // 64 seconds
    { 1952, 184, 384},
    { 1504, 768, -248},
    { 1136, 456, -120},
    { 960, 152, 288},
    { 984, -16, 256},
    { 944, 112, 160},
    { 880, 312, 96},
    { 792, 392, 64},
    { 768, 392, 0},
    { 808, 288, 32},
    { 976, 240, 64},
    { 1248, 376, -24},
    { 1448, 136, 192},
    { 2040, 392, 280},
    { 1440, 408, 216},
    { 912, 336, 48},
    { 1232, 336, 144},
    { 1592, 168, 256},
    { 1360, 40, 272},
    { 1080, -8, 208},
    { 896, -16, 120},
    { 696, -40, 136},
    { 584, -72, 144},
    { 544, -80, 64},
    { 560, -80, 24},
    // 65 seconds
    { 824, 24, -80},
    { 1096, -48, 16},
    { 1792, -240, 392},
    { 1968, 200, 400},
    { 1648, 848, -248},
    { 1360, 648, -120},
    { 1024, 184, 328},
    { 856, 280, 240},
    { 912, -48, 272},
    { 896, 104, 232},
    { 856, 352, 120},
    { 808, 392, 24},
    { 856, 408, -16},
    { 976, 416, 0},
    { 1232, 400, 0},
    { 1488, 208, 152},
    { 1848, 264, 168},
    { 1360, 312, 192},
    { 952, 240, 272},
    { 1496, 96, 128},
    { 1240, 144, 480},
    { 1248, 160, 304},
    { 1016, 88, 264},
    { 832, 112, 152},
    { 736, 96, 80},
    // 66 seconds
    { 664, 40, 48},
    { 640, -48, 56},
    { 648, -72, 0},
    { 840, 32, -128},
    { 1064, -40, -40},
    { 1704, -208, 272},
    { 1840, 144, 392},
    { 1288, 616, 16},
    { 1152, 344, -48},
    { 1136, 152, 248},
    { 1064, 272, 328},
    { 976, 184, 296},
    { 888, 264, 200},
    { 816, 344, 120},
    { 784, 360, 56},
    { 872, 368, 24},
    { 1016, 384, 40},
    { 1280, 400, 16},
    { 1416, 232, 152},
    { 1776, 288, 184},
    { 1416, 368, 176},
    { 960, 208, 144},
    { 1320, 40, 80},
    { 1512, -64, 496},
    { 1272, 144, 224},
    // 67 seconds
    { 1064, 8, 200},
    { 968, 24, 168},
    { 904, -32, 160},
    { 800, 0, 104},
    { 712, -24, 72},
    { 680, -104, 56},
    { 872, 40, -160},
    { 1176, -96, -72},
    { 1544, -312, 352},
    { 1464, 96, 296},
    { 1352, 464, -128},
    { 1336, 272, -8},
    { 1240, 168, 344},
    { 1168, 264, 344},
    { 1040, 240, 392},
    { 928, 272, 224},
    { 904, 264, 192},
    { 904, 336, 104},
    { 896, 392, 64},
    { 1072, 536, 8},
    { 1192, 664, 64},
    { 1472, 520, 56},
    { 1696, 472, 312},
    { 1184, 400, 392},
    { 1056, 120, 280},
    // 68 seconds
    { 1312, 336, -32},
    { 816, -1176, -24},
    { 1136, 432, 248},
    { 1032, 168, 224},
    { 1024, 232, 56},
    { 912, 8, 160},
    { 808, 32, 152},
    { 760, -24, 104},
    { 840, -96, 72},
    { 992, -8, -32},
    { 1392, -24, -112},
    { 1456, 8, 96},
    { 1144, 184, 80},
    { 1120, 328, -96},
    { 1264, 280, 64},
    { 1216, 256, 312},
    { 1120, 368, 296},
    { 1048, 392, 272},
    { 888, 432, 240},
    { 752, 296, 216},
    { 792, 296, 112},
    { 880, 320, 56},
    { 1064, 432, 0},
    { 1240, 528, 0},
    { 1440, 320, 112},
    // 69 seconds
    { 1888, 288, 192},
    { 1224, 320, 136},
    { 1088, 176, 128},
    { 1336, 104, 136},
    { 1424, 128, 168},
    { 1128, 72, 200},
    { 968, 40, 112},
    { 872, -24, 128},
    { 760, -32, 128},
    { 680, 8, 80},
    { 616, -32, 72},
    { 656, -56, 24},
    { 904, 72, -96},
    { 1136, 0, -64},
    { 1680, -192, 184},
    { 1712, 32, 240},
    { 1256, 504, -120},
    { 1120, 376, -120},
    { 1032, 88, 200},
    { 992, 96, 304},
    { 1016, 176, 264},
    { 912, 304, 200},
    { 840, 376, 120},
    { 840, 368, 40},
    { 856, 240, 64},
    // 70 seconds
    { 1032, 272, 40},
    { 1296, 320, 64},
    { 1464, 320, 144},
    { 1800, 392, 192},
    { 1328, 384, 160},
    { 864, 160, 112},
    { 1216, 32, 216},
    { 1152, 48, 568},
    { 1008, 72, 328},
    { 1024, 32, 200},
    { 928, 0, 232},
    { 848, -8, 176},
    { 792, -64, 168},
    { 776, -88, 128},
    { 768, -160, 104},
    { 896, -40, -24},
    { 1080, 48, -120},
    { 1552, -88, 88},
    { 1456, -56, 200},
    { 1080, 240, -152},
    { 1152, 168, -112},
    { 1160, 56, 184},
    { 1144, 32, 208},
    { 1120, 168, 232},
    { 1032, 320, 224},
    // 71 seconds
    { 912, 304, 160},
    { 808, 240, 104},
    { 840, 312, 8},
    { 984, 400, -56},
    { 1240, 448, -72},
    { 1456, 256, 96},
    { 1920, 280, 200},
    { 1368, 352, 144},
    { 1000, 184, 128},
    { 1264, 56, 200},
    { 1440, -104, 288},
    { 1248, 0, 328},
    { 1056, 48, 208},
    { 976, 8, 184},
    { 912, -40, 208},
    { 832, -16, 136},
    { 752, 16, 8},
    { 760, -64, -8},
    { 848, -96, -32},
    { 1120, -136, -112},
    { 1504, -192, 120},
    { 1408, 144, 104},
    { 1312, 456, -152},
    { 1304, 120, 48},
    { 1224, 16, 368},
    // 72 seconds
    { 1176, 232, 360},
    { 1144, 352, 376},
    { 960, 296, 248},
    { 880, 224, 152},
    { 864, 312, 40},
    { 928, 424, -16},
    { 1064, 520, -8},
    { 1240, 512, 32},
    { 1648, 416, 160},
    { 1856, 304, 216},
    { 1112, 224, 96},
    { 960, 136, 96},
    { 1352, 64, 296},
    { 1472, 96, 376},
    { 1272, 72, 272},
    { 1072, 16, 192},
    { 976, 48, 160},
    { 880, 24, 184},
    { 864, 96, 0},
    { 832, 24, -24},
    { 736, -200, 40},
    { 744, -168, -72},
    { 1160, -160, -128},
    { 1560, -64, 184},
    { 1360, 304, 152},
    // 73 seconds
    { 1408, 416, -72},
    { 1416, 112, 128},
    { 1296, 48, 472},
    { 1240, 248, 472},
    { 1104, 480, 320},
    { 944, 328, 232},
    { 912, 376, 192},
    { 872, 400, 128},
    { 912, 512, -40},
    { 1008, 432, 32},
    { 1352, 512, 104},
    { 1528, 344, 240},
    { 1808, 344, 304},
    { 1176, 264, 264},
    { 1144, 56, 224},
    { 1456, 32, 304},
    { 1512, 0, 360},
    { 1432, 152, 216},
    { 1208, 24, 136},
    { 960, -112, 160},
    { 784, -168, 152},
    { 648, -160, 112},
    { 568, -120, 96},
    { 600, -64, -16},
    { 792, 40, -104},
    // 74 seconds
    { 1168, -56, -56},
    { 1664, -200, 312},
    { 1592, 192, 216},
    { 1560, 424, -64},
    { 1496, 312, 64},
    { 1208, 264, 344},
    { 1080, 232, 296},
    { 1024, 232, 280},
    { 952, 304, 192},
    { 880, 312, 88},
    { 848, 368, 24},
    { 896, 472, -40},
    { 936, 360, 8},
    { 1240, 344, 56},
    { 1600, 232, 160},
    { 1952, 200, 248},
    { 1304, 272, 208},
    { 912, 144, 112},
    { 1216, 56, 200},
    { 1328, -48, 304},
    { 1224, 24, 248},
    { 1072, 8, 224},
    { 952, -40, 232},
    { 848, -32, 208},
    { 760, -24, 160},
    // 75 seconds
    { 680, -24, 96},
    { 608, -48, 64},
    { 744, 0, -64},
    { 1008, 168, -264},
    { 1432, -160, 32},
    { 1736, -160, 224},
    { 1408, 392, -144},
    { 1360, 424, -208},
    { 1120, 96, 224},
    { 1032, 264, 264},
    { 1024, 280, 296},
    { 944, 200, 312},
    { 872, 296, 208},
    { 800, 248, 184},
    { 792, 344, 72},
    { 824, 392, 64},
    { 1008, 472, 24},
    { 1224, 464, 56},
    { 1832, 352, 152},
    { 2008, 352, 176},
    { 1080, 248, 136},
    { 1144, 168, 96},
    { 2776, 160, -472},
    { 1320, -128, 200},
    { 1144, -48, 320},
    // 76 seconds
    { 952, 56, 256},
    { 768, 72, 200},
    { 624, 56, 184},
    { 520, 24, 152},
    { 496, 64, 80},
    { 568, 112, 56},
    { 824, 328, -48},
    { 1184, 328, 8},
    { 1600, 472, 280},
    { 1480, 920, 168},
    { 896, 840, -144},
    { 704, 536, -40},
    { 744, 512, 144},
    { 704, 672, 208},
    { 600, 696, 168},
    { 536, 616, 240},
    { 536, 752, 168},
    { 432, 672, 120},
    { 416, 712, 120},
    { 496, 808, 96},
    { 536, 872, 176},
    { 616, 1056, 256},
    { 648, 1168, 384},
    { 848, 1384, 464},
    { 840, 1344, 448},
    // 77 seconds
    { 456, 832, 296},
    { 464, 816, 296},
    { 528, 880, 376},
    { 656, 792, 384},
    { 656, 648, 304},
    { 544, 592, 160},
    { 376, 592, 112},
    { 272, 720, 32},
    { 256, 888, -48},
    { -40, 680, -152},
    { -80, 736, -264},
    { -96, 936, -368},
    { 8, 1096, -256},
    { 72, 1256, -280},
    { 48, 1376, -456},
    { -152, 848, -392},
    { -152, 152, -312},
    { -64, 400, -304},
    { 32, 504, -512},
    { 376, 672, -448},
    { -80, 528, -352},
    { -328, 704, -464},
    { -520, 848, -360},
    { -352, 1016, -240},
    { -304, 1064, -104},
    // 78 seconds
    { -208, 1064, 24},
    { 16, 1056, 72},
    { 280, 1168, 200},
    { 208, 1088, 248},
    { -176, 776, 152},
    { -168, 912, 160},
    { -112, 1016, 176},
    { -16, 1016, 24},
    { 120, 864, -120},
    { 160, 784, -208},
    { 184, 696, -312},
    { 200, 520, -296},
    { 320, 512, -192},
    { 360, 440, -80},
    { 688, 480, 16},
    { 928, 320, 80},
    { 1528, -32, 216},
    { 1928, 256, 416},
    { 1664, 512, 296},
    { 1616, 576, 192},
    { 1440, 480, 384},
    { 1104, 416, 392},
    { 928, 280, 328},
    { 864, 216, 272},
    { 800, 240, 240},
    // 79 seconds
    { 800, 280, 136},
    { 848, 448, -48},
    { 944, 584, -56},
    { 1168, 592, -128},
    { 1384, 504, -48},
    { 1872, 528, 136},
    { 1528, 408, 328},
    { 808, 296, 184},
    { 1176, 136, 232},
    { 1352, 112, 272},
    { 1248, 136, 216},
    { 1088, 56, 208},
    { 976, 16, 176},
    { 848, 16, 144},
    { 736, 0, 136},
    { 696, 8, 72},
    { 728, -112, 64},
    { 864, -96, -16},
    { 1128, -48, -72},
    { 1632, -104, 48},
    { 1616, 80, 264},
    { 1128, 440, -104},
    { 1312, 384, -104},
    { 1320, 304, 256},
    { 1096, 344, 312},
    // 80 seconds
    { 1008, 312, 272},
    { 856, 272, 256},
    { 816, 280, 200},
    { 784, 288, 136},
    { 768, 352, 56},
    { 816, 328, 128},
    { 1368, 560, 144},
    { 1552, 592, 232},
    { 1760, 448, 112},
    { 1280, 496, 32},
    { 1008, 264, 40},
    { 1304, 56, 240},
    { 1432, 128, 312},
    { 1248, 48, 256},
    { 1056, 64, 184},
    { 984, -8, 216},
    { 920, -16, 176},
    { 816, -48, 136},
    { 736, -96, 72},
    { 760, -96, 8},
    { 832, 160, -224},
    { 1016, -80, -224},
    { 1488, -256, 8},
    { 1496, 160, -8},
    { 1384, 384, -80},
    // 81 seconds
    { 1384, 304, 40},
    { 1240, 240, 280},
    { 1112, 208, 368},
    { 1048, 256, 312},
    { 952, 240, 264},
    { 912, 312, 168},
    { 872, 320, 128},
    { 880, 440, 56},
    { 992, 408, 64},
    { 1232, 576, 8},
    { 1288, 424, 104},
    { 1648, 368, 176},
    { 1384, 408, 144},
    { 1048, 256, 144},
    { 1272, 136, 168},
    { 1400, 0, 328},
    { 1264, 32, 296},
    { 1128, 0, 240},
    { 1072, 48, 208},
    { 984, 8, 160},
    { 848, -32, 104},
    { 736, -48, 64},
    { 656, -144, 48},
    { 808, -32, -88},
    { 976, -32, -184},
    // 82 seconds
    { 1368, -104, -72},
    { 1440, 72, -40},
    { 1360, 296, -168},
    { 1408, 288, -48},
    { 1280, 312, 112},
    { 1136, 176, 272},
    { 1024, 296, 248},
    { 960, 304, 280},
    { 928, 304, 232},
    { 840, 296, 144},
    { 848, 400, -16},
    { 888, 336, 16},
    { 1152, 368, -8},
    { 1440, 296, 128},
    { 2104, 456, 144},
    { 1272, 488, 56},
    { 1024, 144, 96},
    { 1336, 16, 88},
    { 1368, -16, 72},
    { 1184, -32, 128},
    { 968, -56, 192},
    { 864, 0, 168},
    { 808, 64, 128},
    { 808, 96, 88},
    { 792, 8, 112},
    // 83 seconds
    { 744, -80, 104},
    { 808, -16, -24},
    { 928, 104, -168},
    { 1448, -128, -16},
    { 1536, -24, 32},
    { 1448, 360, -280},
    { 1344, 400, -248},
    { 1080, 96, 136},
    { 984, 96, 280},
    { 984, 280, 256},
    { 936, 360, 200},
    { 824, 264, 248},
    { 824, 400, 128},
    { 912, 360, 160},
    { 1040, 488, 56},
    { 1232, 424, 24},
    { 1320, 352, 56},
    { 1680, 384, 88},
    { 1544, 368, 152},
    { 984, 168, 184},
    { 1152, 104, 152},
    { 1288, 120, 144},
    { 1168, -200, 464},
    { 1120, 80, 160},
    { 984, -32, 200},
    // 84 seconds
    { 936, -8, 168},
    { 856, -40, 136},
    { 736, -48, 96},
    { 600, -96, 96},
    { 736, -72, 16},
    { 952, 32, -168},
    { 1480, -152, 48},
    { 1576, -64, 232},
    { 1400, 240, 0},
    { 1352, 136, 24},
    { 1360, 176, 280},
    { 1208, 352, 320},
    { 1040, 384, 336},
    { 888, 256, 248},
    { 856, 224, 224},
    { 848, 224, 168},
    { 872, 272, 160},
    { 960, 392, 128},
    { 1144, 376, 80},
    { 1400, 400, 112},
    { 1816, 488, 192},
    { 1312, 408, 184},
    { 944, 280, 176},
    { 1224, 208, 272},
    { 1352, 112, 432},
    // 85 seconds
    { 1264, 16, 336},
    { 1080, -80, 392},
    { 960, -112, 352},
    { 864, -80, 248},
    { 784, -40, 176},
    { 728, -16, 144},
    { 736, -40, 112},
    { 776, -48, 64},
    { 968, 0, 16},
    { 1520, 200, -328},
    { 1536, -184, 104},
    { 1256, -8, -16},
    { 1280, 288, -184},
    { 1064, 176, 144},
    { 1112, 392, 120},
    { 1016, 320, 184},
    { 968, 296, 320},
    { 864, 248, 304},
    { 800, 224, 224},
    { 832, 312, 96},
    { 872, 320, 104},
    { 1216, 456, 24},
    { 1256, 344, 104},
    { 1832, 312, 152},
    { 1344, 368, 72},
    // 86 seconds
    { 1000, 192, 112},
    { 1152, 144, 144},
    { 1200, 136, 152},
    { 1064, 120, 160},
    { 976, 48, 192},
    { 920, 0, 200},
    { 912, -40, 200},
    { 864, -16, 136},
    { 824, -16, 120},
    { 856, -56, 56},
    { 976, 40, -80},
    { 1248, -88, -56},
    { 1520, -128, 88},
    { 1208, 96, 88},
    { 912, 304, -96},
    { 1032, 216, -120},
    { 1088, 104, 208},
    { 1040, 120, 312},
    { 1040, 184, 320},
    { 1008, 296, 280},
    { 872, 320, 208},
    { 848, 296, 120},
    { 912, 272, 96},
    { 1016, 208, 264},
    { 1272, 624, 368},
    // 87 seconds
    { 1664, 872, 480},
    { 1584, 592, 248},
    { 1088, 480, 208},
    { 976, 304, 248},
    { 1200, 192, 232},
    { 1400, 72, 288},
    { 1240, -72, 432},
    { 1088, -8, 256},
    { 1024, -16, 224},
    { 944, 48, 168},
    { 848, 8, 152},
    { 776, 0, 112},
    { 792, -16, -8},
    { 880, 88, -136},
    { 1008, 24, -112},
    { 1368, -216, 96},
    { 1352, 8, 56},
    { 1168, 216, -64},
    { 1272, 264, -96},
    { 1296, 264, 160},
    { 1176, 304, 240},
    { 1120, 320, 344},
    { 1032, 400, 272},
    { 880, 272, 208},
    { 848, 376, 72},
    // 88 seconds
    { 864, 360, 64},
    { 1048, 448, 16},
    { 1160, 464, 16},
    { 1304, 400, 120},
    { 1664, 416, 128},
    { 1528, 448, 160},
    { 976, 240, 160},
    { 1192, 144, 184},
    { 1424, -16, 296},
    { 1288, -32, 296},
    { 1128, 56, 192},
    { 992, 16, 184},
    { 872, 0, 184},
    { 800, -8, 136},
    { 720, -24, 112},
    { 704, -120, 104},
    { 768, -88, -40},
    { 960, 120, -208},
    { 1528, 64, -216},
    { 1584, -328, 160},
    { 1336, 120, -224},
    { 1376, 384, -344},
    { 1392, 256, 104},
    { 1160, 288, 232},
    { 1016, 192, 336},
    // 89 seconds
    { 944, 232, 328},
    { 840, 264, 200},
    { 864, 304, 136},
    { 960, 424, 24},
    { 864, 320, -112},
    { 1088, 368, -160},
    { 1184, 344, -120},
    { 1688, 336, -80},
    { 1520, 408, 88},
    { 1008, 288, 40},
    { 1120, 208, 64},
    { 1384, 216, 216},
    { 1384, 176, 280},
    { 1184, 72, 200},
    { 1080, -16, 184},
    { 1024, -56, 216},
    { 944, -8, 136},
    { 800, -40, 128},
    { 680, -88, 96},
    { 688, -88, -40},
    { 824, 72, -176},
    { 1464, 96, -80},
    { 1712, -192, 360},
    { 1264, 216, -48},
    { 1360, 256, -168},
    // 90 seconds
    { 1376, 352, -56},
    { 1272, 240, 168},
    { 1256, 440, 184},
    { 1144, 504, 264},
    { 944, 528, 304},
    { 808, 392, 216},
    { 800, 408, 160},
    { 880, 432, 120},
    { 1072, 472, 120},
    { 1304, 480, 144},
    { 1952, 504, 224},
    { 1536, 392, 168},
    { 1168, 272, 128},
    { 1416, 160, 200},
    { 1592, 104, 224},
    { 1472, -8, 288},
    { 1144, -96, 312},
    { 904, -72, 184},
    { 760, -64, 136},
    { 648, -40, 104},
    { 592, -40, 72},
    { 640, -72, 64},
    { 832, 0, -56},
    { 1072, 176, -176},
    { 1608, -248, 144},
    // 91 seconds
    { 1904, -136, 344},
    { 1512, 448, -192},
    { 1464, 400, -160},
    { 1192, 152, 296},
    { 1112, 208, 392},
    { 1096, 312, 352},
    { 960, 312, 248},
    { 808, 312, 184},
    { 784, 328, 88},
    { 792, 368, 72},
    { 896, 488, 32},
    { 1072, 408, 72},
    { 1264, 288, 160},
    { 1752, 192, 208},
    { 1680, 384, 208},
    { 1000, 272, 120},
    { 1168, 184, 200},
    { 1848, 56, -160},
    { 1384, 168, 288},
    { 1168, 24, 248},
    { 1032, 48, 176},
    { 936, -40, 184},
    { 856, -80, 152},
    { 760, -56, 88},
    { 688, -80, 8},
    // 92 seconds
    { 704, -72, -72},
    { 864, 240, -240},
    { 1320, -112, -104},
    { 1640, -216, 112},
    { 1488, 152, -48},
    { 1448, 72, 48},
    { 1296, 56, 280},
    { 1112, 80, 440},
    { 1080, 200, 392},
    { 1072, 336, 320},
    { 920, 432, 192},
    { 832, 392, 144},
    { 848, 416, 88},
    { 944, 448, 40},
    { 1112, 440, 88},
    { 1264, 600, 72},
    { 1720, 592, 128},
    { 1816, 384, 152},
    { 1168, 240, 112},
    { 1328, 136, 160},
    { 1576, 64, 264},
    { 1512, 48, 296},
    { 1240, 8, 264},
    { 1016, -56, 256},
    { 888, -24, 176},
    // 93 seconds
    { 824, 8, 112},
    { 752, 40, 48},
    { 704, -48, 56},
    { 704, -88, -56},
    { 824, 0, -224},
    { 1224, -184, 40},
    { 1536, -120, 256},
    { 1488, 280, 136},
    { 1400, 416, 32},
    { 1320, 360, 48},
    { 1224, 144, 232},
    { 1224, 240, 256},
    { 1160, 328, 248},
    { 1056, 440, 240},
    { 944, 496, 200},
    { 912, 464, 160},
    { 888, 368, 136},
    { 1112, 368, 64},
    { 1216, 448, 8},
    { 1656, 528, -24},
    { 1648, 440, 56},
    { 1168, 200, 96},
    { 1200, 24, 128},
    { 1488, 72, 224},
    { 1392, 16, 376},
    // 94 seconds
    { 1104, 0, 272},
    { 1024, 96, 152},
    { 1032, 64, 160},
    { 1000, 24, 200},
    { 976, -88, 240},
    { 776, -304, 208},
    { 792, -176, -24},
    { 880, 56, -224},
    { 1336, 0, -144},
    { 1512, -104, 152},
    { 1440, 208, 72},
    { 1520, 256, -96},
    { 1480, 120, 112},
    { 1392, 208, 264},
    { 1304, 256, 296},
    { 1184, 416, 336},
    { 992, 544, 248},
    { 792, 384, 112},
    { 816, 272, 104},
    { 904, 360, 56},
    { 1048, 464, 40},
    { 1248, 496, 144},
    { 1776, 376, 288},
    { 1760, 304, 464},
    { 1176, 168, 248},
    // 95 seconds
    { 1456, 144, 192},
    { 1816, 56, 368},
    { 1696, -8, 392},
    { 1432, 0, 256},
    { 1176, -80, 256},
    { 968, -80, 216},
    { 808, -56, 128},
    { 656, -64, 56},
    { 536, -120, 0},
    { 560, -136, -56},
    { 696, -48, -168},
    { 1176, -216, 0},
    { 1632, -176, 336},
    { 1728, 232, 344},
    { 1912, 504, 8},
    { 1952, 512, 104},
    { 1400, 576, 448},
    { 1032, 352, 376},
    { 936, 64, 264},
    { 1000, 88, 240},
    { 912, 360, 80},
    { 872, 416, -32},
    { 904, 432, -8},
    { 1088, 536, 0},
    { 1328, 480, 120},
    // 96 seconds
    { 1856, 512, 176},
    { 1960, 264, 280},
    { 1328, 240, 168},
    { 1432, 248, 96},
    { 1656, 88, 72},
    { 1560, -8, 96},
    { 1288, -32, 176},
    { 1104, 0, 152},
    { 920, -32, 192},
    { 768, 0, 128},
    { 688, -24, 88},
    { 600, -104, 64},
    { 664, -8, -24},
    { 800, 40, -288},
    { 1112, -256, -104},
    { 1504, -360, 112},
    { 1720, 48, 64},
    { 1896, 296, -48},
    { 2016, 328, 152},
    { 1672, 592, 352},
    { 1240, 632, 472},
    { 904, 200, 160},
    { 840, 32, 96},
    { 856, 248, 96},
    { 936, 424, 56},
    // 97 seconds
    { 864, 536, 8},
    { 968, 416, 128},
    { 1344, 448, 88},
    { 1648, 256, 192},
    { 1904, 368, 256},
    { 1328, 328, 184},
    { 1304, 152, 168},
    { 1488, -96, 280},
    { 1544, 24, 296},
    { 1304, 0, 312},
    { 1040, -56, 240},
    { 912, -48, 192},
    { 816, -56, 152},
    { 704, -80, 136},
    { 576, -136, 104},
    { 536, -16, -96},
    { 776, 144, -232},
    { 1168, -88, -16},
    { 1664, -184, 256},
    { 1776, 264, 40},
    { 1480, 480, -80},
    { 1256, 392, 72},
    { 1248, 272, 192},
    { 1152, 288, 240},
    { 1048, 328, 272},
    // 98 seconds
    { 984, 416, 256},
    { 904, 432, 208},
    { 784, 416, 144},
    { 864, 448, 8},
    { 912, 376, 0},
    { 1160, 408, 24},
    { 1376, 288, 208},
    { 2000, 360, 288},
    { 1488, 448, 328},
    { 1160, 48, 264},
    { 1384, -80, 272},
    { 1480, -16, 312},
    { 1392, 80, 264},
    { 1168, 8, 200},
    { 1008, 16, 104},
    { 872, -24, 128},
    { 768, -48, 104},
    { 632, -128, 88},
    { 544, -144, 40},
    { 680, -80, -88},
    { 920, 32, -160},
    { 1440, -192, 152},
    { 1936, -240, 672},
    { 1704, 472, 240},
    { 1704, 664, -168},
    // 99 seconds
    { 1744, 1112, 136},
    { 1152, 112, 280},
    { 1032, 192, 288},
    { 992, 240, 272},
    { 904, 328, 248},
    { 808, 376, 192},
    { 776, 456, 128},
    { 848, 512, 64},
    { 992, 424, 32},
    { 1288, 424, -16},
    { 1480, 224, 96},
    { 1752, 232, 128},
    { 1480, 304, 144},
    { 1296, 224, 112},
    { 1408, 144, 104},
    { 1528, 136, 192},
    { 1320, 0, 280},
    { 1120, -16, 208},
    { 952, -40, 192},
    { 800, -40, 184},
    { 704, -40, 136},
    { 608, -56, 72},
    { 576, -72, -16},
    { 752, 16, -104},
    { 976, 56, -112},
    // 100 seconds
    { 1528, -272, 208},
    { 1800, -32, 408},
    { 1472, 560, -16},
    { 1472, 568, -168},
    { 1320, 160, 152},
    { 1112, 32, 384},
    { 1040, 168, 392},
    { 976, 296, 256},
    { 880, 304, 216},
    { 848, 272, 224},
    { 784, 376, 112},
    { 784, 368, 104},
    { 1016, 440, 40},
    { 1232, 456, 104},
    { 1680, 504, 200},
    { 1688, 424, 200},
    { 1136, 280, 144},
    { 1264, 208, 152},
    { 1472, 48, 160},
    { 1384, -296, 328},
    { 1280, 24, 232},
    { 1096, 8, 192},
    { 968, 16, 136},
    { 912, -24, 152},
    { 864, 32, 56},
    // 101 seconds
    { 792, -64, 24},
    { 704, -112, -64},
    { 776, -40, -184},
    { 1200, -256, 32},
    { 1496, -112, 296},
    { 1320, 272, 144},
    { 1360, 208, 88},
    { 1528, 168, 184},
    { 1416, 232, 408},
    { 1208, 352, 328},
    { 1056, 296, 288},
    { 920, 216, 192},
    { 896, 248, 72},
    { 904, 280, 56},
    { 1008, 456, -24},
    { 1096, 400, 64},
    { 1320, 568, 16},
    { 1736, 472, 152},
    { 1808, 448, 232},
    { 1080, 192, 192},
    { 1248, 48, 192},
    { 1616, 192, -32},
    { 1576, -272, 528},
    { 1336, 16, 168},
    { 1112, -24, 208},
    // 102 seconds
    { 984, 8, 192},
    { 888, -40, 200},
    { 776, -56, 152},
    { 664, -136, 104},
    { 728, -32, 0},
    { 800, 120, -256},
    { 1264, -72, -232},
    { 1568, -96, 72},
    { 1328, 384, -208},
    { 1200, 176, -112},
    { 1216, 128, 128},
    { 1184, 160, 264},
    { 1208, 248, 168},
    { 1232, 288, 264},
    { 1144, 512, 248},
    { 952, 544, 184},
    { 888, 528, 88},
    { 896, 376, 120},
    { 1136, 360, 64},
    { 1248, 416, 144},
    { 1720, 488, 216},
    { 1624, 464, 280},
    { 1064, 256, 152},
    { 1280, 168, 168},
    { 1664, 56, 328},
    // 103 seconds
    { 1512, -16, 368},
    { 1304, 16, 224},
    { 1152, 16, 168},
    { 1000, -40, 208},
    { 864, -48, 160},
    { 736, -48, 96},
    { 616, -128, 56},
    { 632, -104, -24},
    { 784, 8, -144},
    { 1240, -96, -96},
    { 1528, -248, 448},
    { 1632, 112, 576},
    { 1424, 808, 96},
    { 1448, 608, 80},
    { 1304, 328, 376},
    { 1168, 192, 456},
    { 1064, 288, 432},
    { 960, 408, 304},
    { 840, 408, 240},
    { 848, 400, 192},
    { 848, 424, 192},
    { 1000, 432, 136},
    { 1136, 416, 200},
    { 1712, 440, 280},
    { 1648, 432, 296},
    // 104 seconds
    { 1128, 240, 216},
    { 1272, 104, 216},
    { 1480, -24, 296},
    { 1328, 32, 328},
    { 1200, 40, 224},
    { 1040, -8, 224},
    { 936, 8, 176},
    { 864, 0, 144},
    { 800, 0, 88},
    { 744, -80, 96},
    { 792, -104, 8},
    { 896, 32, -176},
    { 1296, -88, -80},
    { 1496, -168, 176},
    { 1288, 120, 96},
    { 1360, 352, -104},
    { 1408, 184, 104},
    { 1336, 176, 344},
    { 1296, 304, 368},
    { 1096, 392, 392},
    { 896, 288, 200},
    { 840, 256, 128},
    { 880, 312, 104},
    { 904, 408, 96},
    { 1032, 424, 96},
    // 105 seconds
    { 1248, 520, 48},
    { 1680, 440, 224},
    { 1704, 432, 160},
    { 1152, 232, 88},
    { 1336, 216, 112},
    { 1520, 64, 216},
    { 1496, 104, 160},
    { 1280, 0, 224},
    { 1064, -40, 176},
    { 880, -56, 152},
    { 744, 0, 80},
    { 648, -24, 32},
    { 688, -64, 16},
    { 736, -144, 24},
    { 920, -8, -64},
    { 1256, -184, 104},
    { 1656, -96, 304},
    { 1480, 232, 264},
    { 1640, 384, 96},
    { 1576, 384, 264},
    { 1104, 432, 368},
    { 904, 104, 288},
    { 960, 104, 240},
    { 928, 208, 184},
    { 944, 312, 96},
    // 106 seconds
    { 896, 392, 16},
    { 992, 416, 48},
    { 1176, 504, 24},
    { 1264, 392, 80},
    { 1600, 288, 112},
    { 1712, 336, 128},
    { 1160, 272, 136},
    { 1168, 128, 160},
    { 1472, -56, 296},
    { 1448, -72, 376},
    { 1304, 0, 280},
    { 1104, -64, 272},
    { 968, -48, 216},
    { 872, -8, 184},
    { 792, 0, 136},
    { 816, -48, 96},
    { 864, -88, 8},
    { 904, 8, -192},
    { 1232, -208, -32},
    { 1368, -232, 168},
    { 1192, 136, 56},
    { 1320, 296, -88},
    { 1536, 248, 56},
    { 1464, 264, 312},
    { 1320, 344, 312},
    // 107 seconds
    { 1136, 464, 280},
    { 920, 280, 160},
    { 856, 224, 104},
    { 848, 344, 40},
    { 880, 416, 24},
    { 1008, 488, 0},
    { 1216, 440, 48},
    { 1568, 376, 96},
    { 1944, 296, 272},
    { 1280, 240, 128},
    { 1168, 216, 40},
    { 1480, 120, 176},
    { 1600, 24, 240},
    { 1472, -32, 216},
    { 1184, -88, 160},
    { 856, -80, 72},
    { 648, 0, -104},
    { 528, -56, -80},
    { 424, -128, -16},
    { 496, -88, -32},
    { 864, 8, -16},
    { 1296, 136, 88},
    { 1944, 40, 272},
    { 2184, 64, 488},
    { 1480, 616, 64},
    // 108 seconds
    { 1232, 520, -8},
    { 1016, 184, 296},
    { 912, -8, 368},
    { 928, 48, 288},
    { 912, 216, 208},
    { 856, 384, 168},
    { 808, 424, 56},
    { 808, 376, 80},
    { 928, 424, 56},
    { 1120, 408, 16},
    { 1312, 288, 56},
    { 1752, 208, 144},
    { 1824, 312, 144},
    { 1112, 256, 80},
    { 1280, 144, 88},
    { 1448, -24, 240},
    { 1352, 56, 184},
    { 1112, -16, 224},
    { 912, 8, 128},
    { 784, 0, 64},
    { 648, -32, 64},
    { 568, -24, 16},
    { 544, -64, 8},
    { 688, -88, 0},
    { 1048, 8, -32},
    // 109 seconds
    { 1528, -48, 40},
    { 1912, -176, 368},
    { 1640, 336, 104},
    { 1408, 504, -144},
    { 1248, 224, 72},
    { 1008, 80, 296},
    { 1000, 112, 288},
    { 952, 184, 272},
    { 856, 328, 168},
    { 768, 296, 112},
    { 808, 320, 24},
    { 784, 328, 32},
    { 1024, 408, -8},
    { 1216, 400, -8},
    { 1536, 336, 72},
    { 1736, 320, 120},
    { 1272, 280, 184},
    { 1240, 152, 160},
    { 1472, 40, 200},
    { 1328, 32, 280},
    { 1200, 80, 184},
    { 1024, 24, 192},
    { 928, 16, 128},
    { 864, -48, 160},
    { 776, -24, 88},
    // 110 seconds
    { 656, -48, 32},
    { 608, -104, -16},
    { 728, 24, -136},
    { 904, 48, -224},
    { 1488, -456, 96},
    { 1952, -56, 280},
    { 1768, 424, 16},
    { 1576, 304, -64},
    { 1408, 200, 352},
    { 1256, 272, 496},
    { 1128, 312, 552},
    { 960, 240, 376},
    { 792, 304, 232},
    { 704, 344, 176},
    { 784, 488, 48},
    { 944, 584, 88},
    { 1120, 616, 88},
    { 1288, 472, 72},
    { 1752, 480, 144},
    { 1464, 344, 176},
    { 1376, 232, 120},
    { 1544, 160, 136},
    { 1584, 112, 240},
    { 1400, 120, 192},
    { 1264, 0, 232},
    // 111 seconds
    { 1096, -96, 240},
    { 968, -48, 128},
    { 864, -48, 72},
    { 752, -64, 0},
    { 656, -136, -40},
    { 760, -56, -144},
    { 880, -64, -160},
    { 1512, -336, 64},
    { 1872, 8, 320},
    { 1648, 504, -16},
    { 1576, 272, 32},
    { 1480, 104, 424},
    { 1384, 200, 544},
    { 1248, 336, 512},
    { 1064, 344, 456},
    { 864, 344, 264},
    { 816, 344, 168},
    { 824, 472, 88},
    { 968, 496, 128},
    { 1184, 648, 80},
    { 1384, 592, 88},
    { 1592, 544, 112},
    { 1264, 376, 136},
    { 1296, 208, 176},
    { 1600, 104, 224},
    // 112 seconds
    { 1656, 88, 280},
    { 1504, 8, 312},
    { 1344, 0, 256},
    { 1184, -16, 208},
    { 1088, -72, 184},
    { 992, -24, 88},
    { 920, -136, 24},
    { 744, -192, -152},
    { 832, -96, -296},
    { 1096, -240, -128},
    { 1568, -336, 192},
    { 1584, 144, 376},
    { 1456, 440, 144},
    { 1656, 216, 208},
    { 1736, 192, 528},
    { 1576, 248, 560},
    { 1344, 368, 528},
    { 1072, 456, 456},
    { 816, 312, 272},
    { 816, 344, 168},
    { 816, 424, 112},
    { 864, 512, 16},
    { 1096, 456, 24},
    { 1344, 456, 64},
    { 1712, 392, 24},
    // 113 seconds
    { 1728, 328, 80},
    { 1264, 368, 8},
    { 1432, 120, 152},
    { 1824, 32, 128},
    { 1696, -56, 200},
    { 1416, -72, 232},
    { 1080, -64, 176},
    { 776, -24, 72},
    { 608, -48, 64},
    { 512, -72, 48},
    { 472, -8, -32},
    { 560, 96, -56},
    { 808, 208, -64},
    { 1144, 296, -16},
    { 1536, 112, 152},
    { 1784, 48, 352},
    { 1432, 408, 272},
    { 1272, 448, 80},
    { 1304, 336, 176},
    { 1104, 312, 360},
    { 992, 248, 336},
    { 936, 240, 280},
    { 872, 304, 192},
    { 800, 256, 144},
    { 760, 344, 48},
    // 114 seconds
    { 832, 352, 0},
    { 864, 376, -48},
    { 1008, 336, -64},
    { 1184, 384, -32},
    { 1440, 312, 32},
    { 1624, 376, 72},
    { 1584, 304, 296},
    { 1496, 312, 336},
    { 1456, 192, 280},
    { 1352, 56, 368},
    { 1184, 104, 384},
    { 1032, 88, 248},
    { 968, 200, 152},
    { 768, 288, 224},
    { 560, 376, 232},
    { 520, 800, 128},
    { 368, 752, 160},
    { 264, 744, -24},
    { 200, 784, -152},
    { 224, 744, -176},
    { 264, 480, -304},
    { 320, 912, -232},
    { 32, 912, -264},
    { -56, 1112, -104},
    { -32, 1048, -104},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

