/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:54:39 local
AccelRawData *activity_sample_walk_200_pbl_25480_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25480_10
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 150
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -136, -448, -944},
    { -160, -384, -904},
    { -176, -392, -1032},
    { -112, -288, -976},
    { -64, -376, -920},
    { 16, -424, -928},
    { -40, -432, -928},
    { -56, -432, -920},
    { -48, -424, -912},
    { -48, -416, -912},
    { -40, -432, -920},
    { -48, -424, -920},
    { -64, -424, -944},
    { -64, -432, -936},
    { -56, -400, -944},
    { -48, -456, -936},
    { -32, -416, -944},
    { -32, -424, -944},
    { 8, -416, -960},
    { 16, -392, -960},
    { 32, -400, -976},
    { 40, -464, -944},
    { 64, -424, -920},
    { 56, -400, -960},
    { 104, -416, -880},
    // 1 seconds
    { 80, -408, -888},
    { 120, -360, -960},
    { 128, -416, -832},
    { 112, -376, -944},
    { 128, -336, -936},
    { 96, -248, -944},
    { 88, -360, -928},
    { 96, -312, -912},
    { 56, -288, -976},
    { 56, -256, -984},
    { 64, -176, -880},
    { 24, -160, -976},
    { 8, -208, -944},
    { -40, -296, -1064},
    { 0, -288, -1096},
    { -32, -336, -944},
    { -40, -344, -688},
    { -72, -120, -576},
    { -96, -88, -672},
    { -168, -72, -680},
    { -216, 104, -704},
    { -224, 136, -704},
    { -248, 208, -544},
    { -224, 360, -488},
    { -88, 1128, -544},
    // 2 seconds
    { -88, 2080, -504},
    { -72, 2056, -152},
    { -288, 1808, 128},
    { -440, 1624, -192},
    { -472, 904, 56},
    { -312, 1024, 64},
    { -408, 1248, 232},
    { -384, 928, 248},
    { -296, 752, 408},
    { -160, 672, 408},
    { -120, 648, 432},
    { -152, 560, 464},
    { -240, 768, 400},
    { -232, 720, 272},
    { -400, 800, 264},
    { -264, 904, 176},
    { -312, 1272, 224},
    { -328, 1192, 40},
    { -296, 1256, 32},
    { -288, 1056, 168},
    { -112, 856, 80},
    { 0, 728, 56},
    { 16, 512, 8},
    { 48, 616, 104},
    { 16, 664, 120},
    // 3 seconds
    { 8, 664, 216},
    { 16, 632, 280},
    { -32, 816, 392},
    { -40, 968, 600},
    { -144, 968, 624},
    { -152, 1288, 872},
    { -184, 1064, 848},
    { -160, 976, 816},
    { -232, 784, 848},
    { -200, 784, 672},
    { -144, 440, 464},
    { -80, 504, 384},
    { -48, 408, 368},
    { -64, 496, 376},
    { -96, 448, 472},
    { -136, 616, 664},
    { -264, 768, 808},
    { -392, 912, 904},
    { -344, 1136, 1008},
    { -224, 1048, 808},
    { -264, 880, 616},
    { -264, 792, 584},
    { -248, 688, 456},
    { -240, 624, 496},
    { -144, 704, 400},
    // 4 seconds
    { -56, 424, 344},
    { 48, 472, 264},
    { 128, 432, 208},
    { 224, 544, 232},
    { 64, 768, 96},
    { -176, 1040, -48},
    { -104, 1392, -8},
    { -216, 1736, 24},
    { -144, 1216, 112},
    { 48, 1056, 72},
    { -56, 1168, 72},
    { -176, 864, 40},
    { -88, 648, -48},
    { -72, 576, -8},
    { -112, 616, -120},
    { -120, 208, -96},
    { -184, 40, -272},
    { -272, 328, -520},
    { -712, 520, -568},
    { -1024, 568, -696},
    { -1312, 424, -776},
    { -1392, 328, -624},
    { -1696, 592, -224},
    { -1152, 464, -152},
    { -920, 600, -240},
    // 5 seconds
    { -704, 320, -72},
    { -664, 312, -32},
    { -656, 416, -8},
    { -688, 424, -72},
    { -808, 752, -104},
    { -1136, 552, -72},
    { -1512, 496, -88},
    { -1680, 680, -248},
    { -1160, 552, -344},
    { -1368, 568, -336},
    { -1400, 432, -192},
    { -1400, 368, -152},
    { -1032, 200, -16},
    { -840, 360, 112},
    { -816, 176, -80},
    { -784, 248, 80},
    { -896, 168, 80},
    { -1144, 272, 272},
    { -1208, 88, 208},
    { -1136, 256, 80},
    { -1336, 344, 32},
    { -1112, 800, 0},
    { -952, 728, -152},
    { -1104, 768, 48},
    { -1056, 824, 72},
    // 6 seconds
    { -688, 544, 168},
    { -552, 512, 112},
    { -448, 408, 80},
    { -480, 144, 192},
    { -504, 392, 144},
    { -752, 384, 216},
    { -1440, 712, 336},
    { -1600, 1496, 392},
    { -1352, 1128, 80},
    { -1080, 1800, -760},
    { -1560, 1024, -160},
    { -1840, 912, -216},
    { -2160, 1000, -208},
    { -1768, 664, -32},
    { -1360, 384, -72},
    { -1008, 320, 0},
    { -832, 200, 48},
    { -640, 64, 24},
    { -512, -8, -32},
    { -384, -192, -32},
    { -464, -688, -192},
    { -464, -512, -440},
    { -1144, 104, -632},
    { -2104, 432, -696},
    { -2744, 592, -880},
    // 7 seconds
    { -2488, 144, 64},
    { -1816, 752, -248},
    { -1896, 664, -160},
    { -1808, 496, -120},
    { -1496, 512, 40},
    { -1456, 400, 32},
    { -1392, 472, 48},
    { -1384, 496, 224},
    { -1184, 800, 592},
    { -920, 624, 296},
    { -904, 776, 328},
    { -800, 736, 56},
    { -792, 760, -216},
    { -1584, 1024, -64},
    { -1712, 600, 120},
    { -1872, 448, 208},
    { -1832, 336, 160},
    { -1864, 256, 184},
    { -1712, 112, 144},
    { -1608, 304, 304},
    { -1400, 272, 352},
    { -1464, 184, 280},
    { -1376, -80, -16},
    { -1192, -832, -616},
    { -1504, -368, -288},
    // 8 seconds
    { -1728, -80, -232},
    { -1624, 32, -88},
    { -1608, 8, 80},
    { -1584, 248, 120},
    { -1528, 424, 256},
    { -1568, 688, 352},
    { -1552, 704, 408},
    { -1472, 768, 176},
    { -1280, 880, 144},
    { -1080, 1192, 256},
    { -944, 632, 336},
    { -1208, 1024, 328},
    { -856, 856, 48},
    { -1184, 800, 72},
    { -1688, 576, -8},
    { -1768, 312, -120},
    { -1784, 416, -128},
    { -1664, 368, -112},
    { -1568, 304, -40},
    { -1496, 256, 88},
    { -1512, 272, 152},
    { -1560, 240, 56},
    { -1304, -192, 232},
    { -968, -488, 136},
    { -944, -320, -232},
    // 9 seconds
    { -1744, -168, -200},
    { -1712, 120, -352},
    { -1424, -184, -168},
    { -1416, -48, -104},
    { -1256, 264, -176},
    { -1280, 256, 64},
    { -1376, 368, 152},
    { -1512, 456, 88},
    { -1672, 584, 48},
    { -1728, 1216, 352},
    { -1312, 656, 168},
    { -1080, 544, -208},
    { -1216, 1024, -128},
    { -1072, 616, -112},
    { -1216, 632, -272},
    { -1504, 520, -200},
    { -1808, 376, -64},
    { -1680, 248, -32},
    { -1384, 200, 40},
    { -1376, 200, 48},
    { -1368, 288, 160},
    { -1336, 208, 176},
    { -1328, 152, 200},
    { -1272, -88, 304},
    { -1032, -544, 288},
    // 10 seconds
    { -1120, -112, 16},
    { -1304, 168, -128},
    { -1472, 208, -376},
    { -1432, 200, -184},
    { -1192, -72, -280},
    { -1312, 40, -232},
    { -1256, 288, -216},
    { -1024, 512, 24},
    { -1008, 504, -312},
    { -1096, 352, -80},
    { -1480, 528, -160},
    { -1640, 600, 176},
    { -1032, 752, 208},
    { -1272, 1112, -176},
    { -1064, 776, 48},
    { -1120, 752, -128},
    { -1456, 616, -112},
    { -1680, 488, 56},
    { -1552, 360, 120},
    { -1200, 256, 152},
    { -1152, 264, 56},
    { -1120, 296, 136},
    { -1072, 184, 120},
    { -1104, 240, 216},
    { -1280, 176, 232},
    // 11 seconds
    { -1144, -304, 456},
    { -1040, -200, 112},
    { -1248, 16, -160},
    { -1536, 144, -336},
    { -1696, 64, -208},
    { -1560, 8, -224},
    { -1584, 192, -312},
    { -1416, 304, -200},
    { -1296, 344, 40},
    { -1200, 560, -72},
    { -1248, 568, -64},
    { -1216, 624, -72},
    { -1264, 752, 112},
    { -992, 776, 256},
    { -904, 816, 40},
    { -976, 824, 96},
    { -1160, 808, 72},
    { -1688, 816, -24},
    { -1832, 600, -248},
    { -1888, 624, -216},
    { -1712, 592, -200},
    { -1648, 448, -96},
    { -1632, 384, 0},
    { -1456, 376, -40},
    { -1224, 320, -56},
    // 12 seconds
    { -1112, 232, -16},
    { -1112, -376, 208},
    { -152, -880, -632},
    { -1048, -432, -160},
    { -1712, 328, -448},
    { -2160, 256, -208},
    { -2064, 528, -200},
    { -2040, 680, 192},
    { -1808, 760, 240},
    { -1552, 704, 328},
    { -1568, 688, 376},
    { -1624, 632, 360},
    { -1392, 576, 448},
    { -1248, 552, 520},
    { -1056, 680, 776},
    { -792, 672, 800},
    { -672, 488, 544},
    { -920, 632, 584},
    { -1096, 864, 216},
    { -1216, 664, 0},
    { -1632, 664, 160},
    { -1776, 496, 336},
    { -1672, 488, 296},
    { -1480, 384, 264},
    { -1352, 312, 360},
    // 13 seconds
    { -1312, 272, 360},
    { -1424, 216, 392},
    { -1424, 64, 456},
    { -1320, -224, 416},
    { -1344, -256, 16},
    { -1440, 0, -32},
    { -1440, 240, -312},
    { -1576, 264, -128},
    { -1392, 208, -104},
    { -1312, 96, 104},
    { -1232, 224, 168},
    { -1264, 440, 240},
    { -1360, 528, 328},
    { -1440, 608, 216},
    { -1480, 632, 272},
    { -1536, 816, 400},
    { -1216, 480, 336},
    { -1096, 760, 88},
    { -1096, 952, 224},
    { -616, 1136, 0},
    { -1264, 896, 160},
    { -1568, 656, 248},
    { -1728, 552, 296},
    { -1568, 416, 344},
    { -1464, 264, 416},
    // 14 seconds
    { -1392, 232, 424},
    { -1376, 136, 336},
    { -1280, 56, 272},
    { -1368, 144, 264},
    { -1328, -328, 384},
    { -1288, -384, 160},
    { -1352, 200, -456},
    { -1432, -64, -304},
    { -1480, -248, -16},
    { -1504, -200, -424},
    { -1680, -8, -176},
    { -1624, 264, 240},
    { -1472, 672, 232},
    { -1216, 864, 120},
    { -1032, 488, -208},
    { -1120, 296, 16},
    { -1448, 368, 392},
    { -1296, 744, 424},
    { -1216, 752, 216},
    { -1016, 608, 144},
    { -1056, 584, 112},
    { -1272, 616, 144},
    { -1568, 544, 176},
    { -1664, 384, 208},
    { -1520, 224, 288},
    // 15 seconds
    { -1448, 152, 336},
    { -1336, 128, 312},
    { -1168, 112, 232},
    { -1120, 200, 184},
    { -1192, 208, 144},
    { -1096, -160, 272},
    { -1000, -160, 96},
    { -1344, 72, 40},
    { -1472, 200, -160},
    { -1504, -144, 32},
    { -1504, -224, 120},
    { -1544, 144, 144},
    { -1408, 424, 288},
    { -1144, 528, 400},
    { -1016, 696, 120},
    { -1088, 520, -112},
    { -1272, 448, 112},
    { -1512, 640, 304},
    { -1104, 632, 408},
    { -1176, 432, 176},
    { -1032, 544, 88},
    { -936, 792, -24},
    { -1088, 816, -40},
    { -1616, 792, 152},
    { -1576, 848, 208},
    // 16 seconds
    { -1592, 920, 168},
    { -1544, 784, 248},
    { -1344, 856, 376},
    { -1168, 1080, 904},
    { -824, 1160, 1016},
    { -416, 1040, 1160},
    { 48, 816, 808},
    { 120, 480, 376},
    { 272, 208, 80},
    { 368, 248, -176},
    { 240, 440, -360},
    { 184, 296, -360},
    { 256, 296, -344},
    { 344, -80, -224},
    { 536, -104, -376},
    { 808, 40, -336},
    { 496, -16, -344},
    { 672, -64, -432},
    { 816, -96, -528},
    { 608, -32, -752},
    { 1568, -400, -544},
    { 1088, -104, -528},
    { 1152, -128, -456},
    { 1040, 176, -384},
    { 1016, 144, -232},
    // 17 seconds
    { 976, 200, -208},
    { 704, 224, -168},
    { 608, 216, -104},
    { 592, 248, -160},
    { 592, 192, -136},
    { 544, 192, -152},
    { 656, 96, -232},
    { 544, -64, -632},
    { 480, 256, -568},
    { 328, 528, 8},
    { 256, 440, 512},
    { -200, 464, 768},
    { -592, 1552, 496},
    { -720, 1160, 424},
    { -872, 680, 456},
    { -1120, 424, 232},
    { -1416, 512, -56},
    { -2152, 480, -56},
    { -1904, 808, 456},
    { -712, 688, -296},
    { -1504, 344, -96},
    { -1488, 616, 24},
    { -1248, 760, -128},
    { -1368, 768, -208},
    { -872, 616, -72},
    // 18 seconds
    { -1144, 584, -160},
    { -1232, 552, -160},
    { -1328, 760, -344},
    { -1280, 432, -456},
    { -688, -208, 208},
    { -984, 112, -32},
    { -952, 248, -80},
    { -840, 136, 64},
    { -968, 112, 88},
    { -1240, 80, 192},
    { -1312, 152, 128},
    { -1536, 96, 80},
    { -1384, 56, -8},
    { -1128, 384, -456},
    { -1024, -160, -192},
    { -1184, 104, -296},
    { -984, 152, -360},
    { -872, 400, -288},
    { -872, 264, -152},
    { -912, 304, -88},
    { -872, 320, -40},
    { -840, 328, 56},
    { -1240, 520, 32},
    { -1560, 552, 176},
    { -1240, 1128, 280},
    // 19 seconds
    { -1080, 552, -96},
    { -976, 720, 40},
    { -1144, 448, 24},
    { -1368, 344, 80},
    { -1360, 240, 96},
    { -1048, 184, 80},
    { -896, 208, 64},
    { -904, 232, 80},
    { -904, 200, 120},
    { -1032, 192, 80},
    { -1240, 32, -32},
    { -1096, -184, -8},
    { -1008, -40, -240},
    { -1464, 216, -312},
    { -1336, 272, -272},
    { -1360, 392, -352},
    { -1192, 232, -264},
    { -1168, 88, -152},
    { -992, 224, -144},
    { -840, 352, -80},
    { -792, 432, -80},
    { -872, 520, -72},
    { -960, 504, 24},
    { -1144, 592, 88},
    { -1088, 1000, 328},
    // 20 seconds
    { -928, 488, -144},
    { -1312, 800, -8},
    { -1056, 608, -16},
    { -1232, 536, -56},
    { -1352, 416, -24},
    { -1544, 376, 0},
    { -1256, 264, 8},
    { -1096, 256, 40},
    { -992, 216, 48},
    { -984, 216, 56},
    { -944, 200, 88},
    { -1144, 176, 24},
    { -1264, -128, 64},
    { -1024, -328, -48},
    { -1456, 88, -152},
    { -1632, 328, -160},
    { -1408, 480, -312},
    { -1312, 144, -112},
    { -1192, 40, -152},
    { -1096, 232, -112},
    { -976, 336, -24},
    { -992, 280, 48},
    { -1040, 352, 56},
    { -1064, 400, 88},
    { -1128, 464, 80},
    // 21 seconds
    { -1312, 664, 152},
    { -1024, 528, 64},
    { -1352, 600, -88},
    { -920, 600, -136},
    { -1200, 672, -144},
    { -1560, 616, -136},
    { -1616, 472, -120},
    { -1576, 416, -56},
    { -1352, 256, 104},
    { -1240, 80, 64},
    { -1056, 144, 40},
    { -1008, 56, 96},
    { -1032, 128, 56},
    { -984, 32, 152},
    { -896, 104, 48},
    { -1184, -48, 232},
    { -1360, 368, -128},
    { -1040, 464, -392},
    { -1264, 416, -416},
    { -1312, 424, -560},
    { -1296, 176, -312},
    { -1232, 432, -152},
    { -1160, 416, -40},
    { -1056, 384, 136},
    { -1048, 376, 32},
    // 22 seconds
    { -1112, 344, 120},
    { -1232, 352, 160},
    { -1424, 440, 456},
    { -800, 1072, 664},
    { -1416, 648, 464},
    { -784, 880, 296},
    { -1184, 880, 136},
    { -1464, 648, 296},
    { -1824, 616, 272},
    { -1704, 248, 320},
    { -1440, 272, 256},
    { -1352, 176, 296},
    { -1152, 96, 288},
    { -992, 80, 264},
    { -880, 0, 240},
    { -1360, 48, -40},
    { -744, -296, -432},
    { -1280, -160, -80},
    { -1472, 8, 40},
    { -1840, 536, -176},
    { -1680, 320, 176},
    { -1496, 400, 104},
    { -1400, 384, 64},
    { -1296, 352, 120},
    { -1176, 264, 224},
    // 23 seconds
    { -1192, 304, 240},
    { -1232, 424, 184},
    { -1224, 336, 376},
    { -1248, 608, 512},
    { -1112, 560, 736},
    { -936, 672, 384},
    { -1136, 912, 352},
    { -928, 776, 408},
    { -1192, 616, 264},
    { -1528, 528, 344},
    { -1752, 384, 312},
    { -1616, 272, 280},
    { -1464, 248, 240},
    { -1360, 216, 240},
    { -1296, 176, 264},
    { -1184, 128, 280},
    { -1176, 96, 272},
    { -1120, 32, 216},
    { -856, -64, 96},
    { -1208, 80, 16},
    { -1112, 248, -184},
    { -1280, 376, -272},
    { -1128, 96, -248},
    { -1432, -96, 8},
    { -1384, 224, 96},
    // 24 seconds
    { -1480, 440, 256},
    { -1296, 472, 344},
    { -1288, 416, 304},
    { -1312, 400, 216},
    { -1352, 304, 336},
    { -1672, 360, 624},
    { -1200, 672, 504},
    { -1008, 952, 344},
    { -880, 640, 320},
    { -648, 768, 200},
    { -1032, 736, 272},
    { -1360, 576, 336},
    { -1704, 320, 392},
    { -1432, 224, 232},
    { -1336, 184, 240},
    { -1344, 152, 280},
    { -1344, 152, 280},
    { -1248, 104, 296},
    { -1392, 48, 352},
    { -1400, 48, 320},
    { -1112, 40, 160},
    { -1336, 224, -16},
    { -1064, 184, -288},
    { -784, 176, -384},
    { -1008, 120, -400},
    // 25 seconds
    { -1232, 88, -224},
    { -1264, 136, 0},
    { -1176, 288, 72},
    { -1264, 384, 144},
    { -1264, 376, 320},
    { -1200, 584, 240},
    { -1088, 600, 240},
    { -1280, 512, 176},
    { -1376, 488, 336},
    { -1056, 592, 136},
    { -1400, 776, -48},
    { -912, 664, 56},
    { -848, 608, 64},
    { -1376, 480, 264},
    { -1696, 328, 344},
    { -1384, 216, 208},
    { -1208, 168, 240},
    { -1208, 136, 248},
    { -1224, 152, 248},
    { -1120, 144, 240},
    { -1152, 72, 280},
    { -1432, 0, 312},
    { -1352, -272, 336},
    { -1296, -304, 200},
    { -1600, 368, -184},
    // 26 seconds
    { -1312, 280, -200},
    { -1352, 16, 40},
    { -1280, -16, -24},
    { -1216, 264, 8},
    { -1168, 304, 200},
    { -1064, 368, 304},
    { -1024, 336, 280},
    { -1096, 408, 208},
    { -1256, 296, 336},
    { -1304, 368, 360},
    { -1192, 432, 408},
    { -1104, 728, 336},
    { -1024, 496, 352},
    { -824, 464, 200},
    { -872, 544, 192},
    { -1456, 400, 416},
    { -1496, 312, 368},
    { -1240, 248, 328},
    { -1112, 136, 304},
    { -1152, 184, 320},
    { -1208, 168, 296},
    { -1200, 136, 328},
    { -1216, 104, 320},
    { -1216, -112, 312},
    { -1144, -88, 104},
    // 27 seconds
    { -1272, 24, 80},
    { -1432, 624, -192},
    { -1280, 728, -120},
    { -1048, -192, 352},
    { -1264, -512, 328},
    { -1136, 312, 216},
    { -1016, 480, 168},
    { -1008, 264, 296},
    { -1000, 328, 576},
    { -904, 384, 616},
    { -976, 552, 400},
    { -1272, 352, 616},
    { -1216, 128, 776},
    { -1216, 544, 856},
    { -1104, 56, 608},
    { -816, 496, 696},
    { -688, 584, 520},
    { -1408, 640, 640},
    { -1416, 648, 472},
    { -1240, 432, 400},
    { -1224, 264, 448},
    { -1160, 224, 392},
    { -928, 120, 384},
    { -792, 88, 368},
    { -992, -16, 376},
    // 28 seconds
    { -1160, -144, 464},
    { -1312, -448, -64},
    { -1584, 288, 112},
    { -1416, 312, 264},
    { -1520, 736, 208},
    { -1416, 624, 312},
    { -1208, 472, 336},
    { -992, 424, 296},
    { -912, 320, 344},
    { -904, 312, 344},
    { -984, 400, 344},
    { -992, 368, 376},
    { -896, 416, 504},
    { -1152, 576, 568},
    { -976, 624, 440},
    { -1128, 648, 464},
    { -1144, 664, 544},
    { -1040, 560, 464},
    { -1264, 600, 368},
    { -1488, 496, 408},
    { -1480, 376, 424},
    { -1280, 264, 488},
    { -1224, 144, 392},
    { -1168, 128, 416},
    { -1096, 88, 352},
    // 29 seconds
    { -1008, 72, 336},
    { -1216, 48, 304},
    { -1360, -544, 344},
    { -1224, -304, 96},
    { -1248, -72, -104},
    { -1440, 648, -296},
    { -1552, 64, 384},
    { -1576, 352, 168},
    { -1472, 584, 208},
    { -1240, 600, 224},
    { -1040, 496, 256},
    { -904, 520, 328},
    { -920, 496, 248},
    { -992, 544, 280},
    { -1096, 552, 312},
    { -1064, 792, 384},
    { -1144, 776, 568},
    { -1216, 848, 360},
    { -1280, 736, 360},
    { -1512, 520, 400},
    { -1640, 320, 424},
    { -1536, 248, 400},
    { -1296, 232, 336},
    { -1168, 192, 344},
    { -1112, 136, 376},
    // 30 seconds
    { -1048, -8, 392},
    { -992, 88, 288},
    { -1056, 32, 240},
    { -1000, -184, 8},
    { -928, -24, -80},
    { -1112, -136, 120},
    { -1304, 408, 72},
    { -1408, 568, 40},
    { -1576, 456, 312},
    { -1680, 272, 496},
    { -1368, 304, 376},
    { -1048, 512, 136},
    { -912, 440, 72},
    { -1000, 520, 176},
    { -1120, 400, 72},
    { -1128, 608, 160},
    { -1400, 472, 448},
    { -1112, 960, 696},
    { -1056, 336, 152},
    { -1128, 680, 320},
    { -1160, 528, 312},
    { -1368, 448, 336},
    { -1544, 344, 312},
    { -1544, 264, 328},
    { -1384, 208, 296},
    // 31 seconds
    { -1264, 152, 288},
    { -1208, 120, 280},
    { -1128, 128, 248},
    { -968, 56, 200},
    { -928, 64, 248},
    { -1088, -184, 192},
    { -1016, -88, 96},
    { -1320, 112, 136},
    { -1304, 232, 72},
    { -1336, 568, -240},
    { -1432, 96, 152},
    { -1608, -216, 384},
    { -1520, 280, 304},
    { -1240, 568, 224},
    { -1048, 624, 232},
    { -968, 472, 168},
    { -1056, 320, 224},
    { -1136, 336, 304},
    { -1280, 344, 392},
    { -984, 512, 576},
    { -1272, 488, 472},
    { -1048, 392, 336},
    { -1128, 536, 216},
    { -1344, 592, 272},
    { -1464, 352, 64},
    // 32 seconds
    { -1288, 360, 64},
    { -1160, 280, 96},
    { -1168, 208, 144},
    { -1208, 184, 152},
    { -1144, 152, 208},
    { -1312, 88, 320},
    { -1496, -384, 296},
    { -1144, -400, 168},
    { -1200, -256, 64},
    { -1296, 176, -104},
    { -1456, 488, -280},
    { -1504, 496, -112},
    { -1504, 200, 112},
    { -1128, 488, 8},
    { -888, 488, 40},
    { -832, 368, 64},
    { -1000, 288, 112},
    { -1024, 208, 192},
    { -880, 144, 208},
    { -944, 128, 232},
    { -1208, 272, 368},
    { -1416, 624, 576},
    { -1072, 576, 392},
    { -1360, 936, 136},
    { -1320, 352, 96},
    // 33 seconds
    { -1600, 600, 56},
    { -1544, 440, 120},
    { -1312, 584, 456},
    { -1272, 408, 336},
    { -1224, 328, 344},
    { -1072, 80, 360},
    { -776, -40, 328},
    { -840, 16, 248},
    { -936, -392, 240},
    { -1032, -552, 8},
    { -1256, -256, -48},
    { -1632, 216, 56},
    { -2048, 768, 0},
    { -2080, 536, 64},
    { -1768, 232, 304},
    { -1192, 728, 160},
    { -944, 560, 168},
    { -976, 336, 176},
    { -968, 320, 288},
    { -960, 288, 304},
    { -888, 248, 280},
    { -1040, 184, 400},
    { -1200, 320, 624},
    { -1032, 608, 680},
    { -1128, 168, 320},
    // 34 seconds
    { -816, 576, 200},
    { -1168, 648, 96},
    { -1528, 712, 248},
    { -1632, 560, 216},
    { -1520, 384, 160},
    { -1368, 280, 352},
    { -1320, 160, 344},
    { -1216, 224, 216},
    { -1144, 216, 152},
    { -1168, 144, 176},
    { -1184, -64, 224},
    { -1112, -304, 168},
    { -1192, -64, -96},
    { -1296, 280, -152},
    { -1600, 352, -8},
    { -1504, 152, 184},
    { -1472, 168, 288},
    { -1352, 384, 272},
    { -1160, 408, 360},
    { -1032, 448, 304},
    { -1072, 360, 176},
    { -1280, 360, 216},
    { -1384, 344, 352},
    { -1512, 336, 584},
    { -960, 600, 632},
    // 35 seconds
    { -888, 424, 392},
    { -808, 584, 376},
    { -1016, 480, 296},
    { -1304, 456, 384},
    { -1464, 448, 280},
    { -1352, 424, 344},
    { -1168, 312, 272},
    { -1160, 280, 512},
    { -1296, 224, 408},
    { -1256, 304, 400},
    { -1216, 192, 584},
    { -1256, 224, 808},
    { -984, 360, 656},
    { -848, 392, 704},
    { -568, 616, 568},
    { -232, 760, 456},
    { -280, 896, 328},
    { -296, 808, 280},
    { -232, 672, 176},
    { -152, 424, 176},
    { -104, 288, 128},
    { -48, 200, 264},
    { 0, 440, 200},
    { 8, 408, 376},
    { -144, 608, 728},
    // 36 seconds
    { -344, 1208, 928},
    { -360, 968, 1264},
    { -576, 1512, 1136},
    { -376, 1144, 1080},
    { -416, 1080, 848},
    { -392, 960, 744},
    { -384, 824, 536},
    { -264, 640, 320},
    { -200, 448, 184},
    { -176, 304, 112},
    { -176, 224, 72},
    { -208, 120, 96},
    { -440, 120, 208},
    { -944, 64, 400},
    { -1768, 104, 632},
    { -2224, 384, 320},
    { -2424, 1216, 96},
    { -1608, 224, 544},
    { -1016, 408, -24},
    { -952, 320, -80},
    { -856, 336, 168},
    { -688, 304, 144},
    { -592, 184, 128},
    { -568, 120, 72},
    { -544, 128, 208},
    // 37 seconds
    { -856, 280, 136},
    { -1344, 608, 256},
    { -1280, 536, 536},
    { -1096, 1248, 432},
    { -992, -160, 72},
    { -1432, 760, 224},
    { -1432, 408, -64},
    { -1568, 416, -944},
    { -1104, 120, 80},
    { -1048, 40, 232},
    { -920, 152, 24},
    { -840, 144, 112},
    { -880, 128, 184},
    { -960, 96, 248},
    { -1120, 88, 256},
    { -1184, 48, 288},
    { -1224, -48, 336},
    { -1136, 304, 48},
    { -1160, 632, -312},
    { -1560, 496, -56},
    { -1424, -64, 48},
    { -1280, 280, 8},
    { -968, 416, 184},
    { -768, 464, 264},
    { -800, 440, 144},
    // 38 seconds
    { -920, 352, 144},
    { -976, 240, 240},
    { -1240, 248, 320},
    { -1280, 224, 424},
    { -1048, 296, 480},
    { -1160, 728, 456},
    { -1064, 616, 328},
    { -1072, 592, 256},
    { -1152, 600, 256},
    { -1352, 568, 176},
    { -1256, 456, 240},
    { -1080, 144, 304},
    { -1064, 288, 272},
    { -1120, 248, 304},
    { -1064, 152, 312},
    { -960, 120, 312},
    { -1072, 152, 272},
    { -1240, -264, 248},
    { -1192, -224, 288},
    { -1360, 216, 56},
    { -1344, 656, 72},
    { -1376, 464, 224},
    { -1368, 576, 216},
    { -1272, 552, 312},
    { -1080, 512, 400},
    // 39 seconds
    { -904, 304, 408},
    { -888, 360, 376},
    { -920, 344, 376},
    { -864, 344, 440},
    { -1064, 352, 440},
    { -1072, 360, 568},
    { -928, 360, 544},
    { -1192, 488, 576},
    { -1000, 504, 464},
    { -1032, 616, 360},
    { -1328, 480, 376},
    { -1512, 480, 352},
    { -1344, 392, 168},
    { -1224, 320, 336},
    { -1120, 232, 336},
    { -1072, 176, 328},
    { -1000, 160, 280},
    { -1048, 144, 280},
    { -1360, -24, 304},
    { -1192, -304, 264},
    { -1240, -56, 128},
    { -1376, 376, -56},
    { -1360, 640, -112},
    { -1400, 192, 112},
    { -1400, 232, 192},
    // 40 seconds
    { -1216, 352, 232},
    { -1040, 384, 280},
    { -944, 328, 280},
    { -1032, 400, 208},
    { -1152, 400, 272},
    { -1176, 320, 376},
    { -1160, 544, 360},
    { -816, 520, 384},
    { -1120, 496, 400},
    { -1080, 480, 360},
    { -1144, 504, 256},
    { -1248, 472, 224},
    { -1432, 416, 264},
    { -1408, 408, 160},
    { -1144, 352, 224},
    { -1128, 192, 216},
    { -1144, 248, 232},
    { -1096, 160, 216},
    { -1120, 128, 232},
    { -1384, 40, 136},
    { -1328, -248, 112},
    { -1352, -352, 120},
    { -1368, 8, 0},
    { -1264, 488, -224},
    { -1352, 376, 40},
    // 41 seconds
    { -1416, 200, 192},
    { -1336, 368, 192},
    { -1120, 392, 232},
    { -928, 416, 200},
    { -896, 408, 136},
    { -1024, 368, 176},
    { -1008, 336, 272},
    { -1048, 432, 328},
    { -1016, 576, 568},
    { -1248, 408, 392},
    { -1096, 480, 280},
    { -1008, 496, 176},
    { -1224, 552, 152},
    { -1520, 384, 120},
    { -1528, 560, -136},
    { -1240, 256, 32},
    { -1176, 480, 136},
    { -1128, 368, 80},
    { -976, 192, 80},
    { -896, 176, 120},
    { -960, 160, 168},
    { -1136, 48, 152},
    { -1280, 184, -8},
    { -1288, 152, 128},
    { -1248, 328, -64},
    // 42 seconds
    { -1368, 304, -32},
    { -1312, 240, 104},
    { -1272, 416, 64},
    { -1072, 440, 16},
    { -992, 400, 144},
    { -992, 352, 208},
    { -1032, 344, 208},
    { -1032, 336, 264},
    { -1128, 400, 392},
    { -1312, 368, 456},
    { -1152, 400, 416},
    { -1144, 520, 416},
    { -872, 568, 368},
    { -1064, 616, 224},
    { -1336, 496, 296},
    { -1408, 392, 328},
    { -1192, 152, 288},
    { -1096, 112, 472},
    { -1016, 184, 216},
    { -984, 264, 160},
    { -912, 184, 160},
    { -1048, 80, 232},
    { -1528, -24, 304},
    { -1256, -264, 136},
    { -1400, -152, 128},
    // 43 seconds
    { -1432, 264, 16},
    { -1184, 400, -88},
    { -1240, 304, 32},
    { -1352, 88, 120},
    { -1288, 288, 304},
    { -1048, 288, 264},
    { -872, 272, 352},
    { -872, 432, 272},
    { -920, 360, 264},
    { -904, 360, 264},
    { -1160, 384, 360},
    { -1176, 416, 520},
    { -1248, 424, 696},
    { -1184, 720, 320},
    { -800, 640, 264},
    { -1120, 560, 432},
    { -1568, 416, 440},
    { -1664, 448, 200},
    { -1320, 336, 480},
    { -1216, 32, 424},
    { -1144, 184, 352},
    { -1064, 128, 352},
    { -968, 64, 320},
    { -976, 120, 320},
    { -1112, -216, 264},
    // 44 seconds
    { -936, -296, 168},
    { -1272, 48, -96},
    { -1352, 184, -56},
    { -1624, 584, 72},
    { -1688, 608, 240},
    { -1432, 544, 224},
    { -1208, 488, 192},
    { -1016, 512, 136},
    { -976, 480, 216},
    { -1000, 424, 304},
    { -1024, 400, 352},
    { -920, 424, 360},
    { -968, 408, 464},
    { -1056, 400, 584},
    { -848, 392, 512},
    { -1224, 520, 496},
    { -1040, 440, 376},
    { -1080, 584, 320},
    { -1312, 560, 344},
    { -1576, 496, 328},
    { -1664, 440, 240},
    { -1416, 208, 624},
    { -1336, 176, 360},
    { -1208, 144, 312},
    { -1048, 120, 264},
    // 45 seconds
    { -960, 96, 248},
    { -1104, 32, 216},
    { -1104, -368, 232},
    { -1136, -88, 80},
    { -1352, 168, -16},
    { -1448, 656, -264},
    { -1504, 560, -136},
    { -1432, 56, 304},
    { -1296, -16, 272},
    { -1104, 344, 256},
    { -952, 424, 224},
    { -1040, 416, 248},
    { -1248, 488, 112},
    { -1176, 392, 272},
    { -1208, 392, 400},
    { -1200, 640, 760},
    { -912, 120, 320},
    { -1312, 656, 208},
    { -1000, 552, 200},
    { -968, 616, 96},
    { -1120, 560, 64},
    { -1312, 520, 112},
    { -1288, 408, 112},
    { -1272, -56, 376},
    { -1160, 360, 352},
    // 46 seconds
    { -1184, 88, 192},
    { -1184, 208, 168},
    { -1184, 152, 184},
    { -1536, -16, 304},
    { -1216, -304, 416},
    { -1360, -336, 232},
    { -1392, 136, -120},
    { -1392, 672, -288},
    { -1232, 128, 72},
    { -1216, 0, 168},
    { -1128, 336, -32},
    { -960, 440, -16},
    { -888, 320, 72},
    { -936, 368, 168},
    { -1112, 464, 168},
    { -1136, 440, 248},
    { -1168, 696, 456},
    { -1104, 336, 232},
    { -1240, 536, 208},
    { -1248, 584, 248},
    { -1064, 440, 192},
    { -1224, 432, 88},
    { -1424, 464, 64},
    { -1448, 400, -32},
    { -1224, 448, -64},
    // 47 seconds
    { -1096, 80, 208},
    { -1032, 256, 64},
    { -984, 248, 72},
    { -920, 128, 128},
    { -912, -16, 160},
    { -992, -136, 200},
    { -888, -96, 256},
    { -1360, 56, 208},
    { -1584, 432, 48},
    { -1328, 528, -64},
    { -1376, 328, 208},
    { -1248, -56, 304},
    { -1120, 232, 176},
    { -984, 400, 8},
    { -792, 320, 168},
    { -864, 232, 192},
    { -928, 248, 192},
    { -952, 256, 296},
    { -1216, 328, 344},
    { -1256, 376, 544},
    { -1264, 552, 392},
    { -1312, 320, 152},
    { -1032, 552, 208},
    { -1176, 616, 56},
    { -1232, 488, 16},
    // 48 seconds
    { -1200, 360, 72},
    { -1088, 136, 48},
    { -920, 216, 176},
    { -960, 64, 112},
    { -1032, 232, 112},
    { -1080, 144, 184},
    { -1336, 128, 272},
    { -1304, -304, 280},
    { -1232, -72, 56},
    { -1336, 32, -64},
    { -1376, 320, -144},
    { -1336, 336, -160},
    { -1328, 128, 72},
    { -1232, 64, 104},
    { -936, 336, 56},
    { -744, 304, 24},
    { -824, 296, 80},
    { -976, 288, 176},
    { -1000, 272, 200},
    { -1064, 304, 256},
    { -1240, 384, 352},
    { -960, 664, 480},
    { -1288, 520, 184},
    { -1120, 656, 224},
    { -1048, 648, 144},
    // 49 seconds
    { -1256, 600, 120},
    { -1440, 568, 168},
    { -1432, 608, 336},
    { -1440, 640, 592},
    { -1616, 544, 712},
    { -1456, 680, 632},
    { -1120, 296, 648},
    { -880, 144, 488},
    { -736, 144, 432},
    { -544, 56, 408},
    { -784, 48, 416},
    { 72, 496, -128},
    { -424, 856, 312},
    { -184, 1088, 920},
    { -64, 1624, 728},
    { 88, 1080, 696},
    { 216, 824, 520},
    { 296, 656, 432},
    { 328, 304, 376},
    { 272, 440, 112},
    { 200, 568, 560},
    { 272, 600, 344},
    { 272, 616, 584},
    { 240, 696, 520},
    { 248, 736, 576},
    // 50 seconds
    { 320, 656, 624},
    { 368, 848, 728},
    { 408, 704, 864},
    { 368, 712, 768},
    { 368, 624, 720},
    { 312, 560, 696},
    { 144, 568, 560},
    { 48, 552, 256},
    { 56, 328, 64},
    { -8, 232, 104},
    { -40, 56, 112},
    { -488, 256, 160},
    { -744, 240, 24},
    { -1376, 312, 72},
    { -3152, 680, 344},
    { -2544, 88, 600},
    { -1752, 1224, 368},
    { -688, 336, -144},
    { -1240, 384, 160},
    { -1120, 200, 160},
    { -896, 344, 256},
    { -896, 416, 64},
    { -1000, 168, 304},
    { -792, 224, 192},
    { -856, 264, 272},
    // 51 seconds
    { -712, 304, 312},
    { -736, 248, 232},
    { -984, 232, 272},
    { -1152, 232, 288},
    { -1424, 256, 264},
    { -1232, 344, 216},
    { -1424, 312, 264},
    { -1680, 72, 376},
    { -1608, -24, 384},
    { -1280, 0, 264},
    { -1112, 56, 240},
    { -1000, 40, 232},
    { -920, 16, 248},
    { -888, -56, 264},
    { -816, -56, 224},
    { -880, -144, 304},
    { -904, -160, 440},
    { -952, 8, 296},
    { -1256, 88, 264},
    { -1288, 240, 184},
    { -1168, 632, 8},
    { -904, 464, 64},
    { -1048, 344, 24},
    { -1296, 240, -80},
    { -1160, 296, -160},
    // 52 seconds
    { -968, 496, -168},
    { -976, 640, -24},
    { -920, 856, -40},
    { -872, 648, -168},
    { -864, 280, 216},
    { -760, 144, 216},
    { -968, 168, 168},
    { -1064, 184, 328},
    { -1544, 216, 296},
    { -1472, 112, 216},
    { -1080, 112, 248},
    { -1336, 88, 264},
    { -1600, 40, 312},
    { -1208, 48, 312},
    { -840, 8, 240},
    { -856, 40, 232},
    { -944, -32, 256},
    { -1000, -96, 240},
    { -920, -40, 216},
    { -872, -40, 208},
    { -1000, -40, 200},
    { -984, 0, 160},
    { -1240, 48, 120},
    { -1392, 240, 72},
    { -1152, 288, -72},
    // 53 seconds
    { -1112, 264, -128},
    { -1216, 440, -200},
    { -1320, 312, -160},
    { -1112, 312, -96},
    { -912, 280, -24},
    { -856, 272, 24},
    { -896, 264, 72},
    { -896, 272, 128},
    { -816, 296, 160},
    { -848, 280, 216},
    { -1144, 384, 400},
    { -1424, 216, 288},
    { -1624, 160, 320},
    { -1136, 240, 184},
    { -1120, 312, 200},
    { -1320, 224, 200},
    { -1392, 144, 176},
    { -1104, -16, 344},
    { -952, 24, 264},
    { -952, 8, 264},
    { -976, -24, 248},
    { -904, 0, 192},
    { -936, -24, 192},
    { -1208, -328, 144},
    { -1112, -144, 56},
    // 54 seconds
    { -1248, -104, 40},
    { -1496, 192, 16},
    { -1504, 544, -32},
    { -1216, 320, 32},
    { -1240, 8, 120},
    { -1256, 208, 144},
    { -1048, 256, 136},
    { -880, 312, 128},
    { -856, 272, 160},
    { -904, 216, 192},
    { -864, 224, 224},
    { -808, 312, 256},
    { -1040, 600, 424},
    { -968, 488, 280},
    { -1600, 480, 496},
    { -1376, 400, 432},
    { -1312, 512, 368},
    { -1552, 600, 416},
    { -1752, 432, 528},
    { -1680, 424, 840},
    { -1472, 232, 760},
    { -1288, 352, 584},
    { -1032, 136, 464},
    { -792, 32, 336},
    { -632, 8, 232},
    // 55 seconds
    { -592, -56, 232},
    { -592, -128, 256},
    { -592, -288, 264},
    { -680, -256, -464},
    { -1632, 376, -8},
    { -2336, 776, 304},
    { -2528, 720, 312},
    { -1880, 384, 648},
    { -1472, 744, 360},
    { -1512, 456, 280},
    { -1352, 232, 392},
    { -1240, 352, 384},
    { -1184, 248, 360},
    { -1064, 88, 392},
    { -920, 408, 528},
    { -760, 552, 616},
    { -840, 416, 504},
    { -944, 576, 504},
    { -1112, 560, 448},
    { -1184, 656, 376},
    { -1544, 464, 320},
    { -2008, 424, 440},
    { -2352, 344, 480},
    { -2216, 104, 432},
    { -1904, 8, 472},
    // 56 seconds
    { -1640, 176, 496},
    { -1456, 120, 472},
    { -1328, 296, 480},
    { -1096, 320, 432},
    { -864, 216, 400},
    { -472, 432, 304},
    { -176, 528, 352},
    { 176, 648, 408},
    { 280, 1056, 352},
    { 408, 1040, 376},
    { 280, 856, 176},
    { 296, 528, 80},
    { 352, 392, -40},
    { 384, 264, -112},
    { 288, 144, -64},
    { 184, 32, -8},
    { 152, 24, -136},
    { 24, 104, -24},
    { -224, 32, 8},
    { -776, 368, 64},
    { -2760, 1000, 632},
    { -2360, 440, 688},
    { -2928, 640, 592},
    { -2872, 400, 656},
    { -2408, 728, 656},
    // 57 seconds
    { -1864, -96, 200},
    { -1616, 360, 280},
    { -1064, 480, 288},
    { -800, 472, 120},
    { -640, 416, 112},
    { -568, 304, 96},
    { -784, 424, 232},
    { -1152, 600, 240},
    { -1096, 488, 288},
    { -1736, 464, 232},
    { -1624, 392, 160},
    { -1840, 520, 64},
    { -2512, 352, 40},
    { -2752, 232, 248},
    { -2568, 168, 376},
    { -1952, 72, 400},
    { -1416, -8, 352},
    { -1064, 8, 224},
    { -880, 40, 64},
    { -576, -144, -104},
    { -576, 40, -192},
    { -552, -16, -264},
    { -520, 8, -280},
    { -752, -8, -136},
    { -896, -8, 64},
    // 58 seconds
    { -1144, 160, 208},
    { -1872, 400, 456},
    { -2600, 928, 472},
    { -2472, 1304, 440},
    { -1696, 384, 832},
    { -1424, 168, 184},
    { -1552, 256, 224},
    { -1424, 576, 208},
    { -1104, 408, 208},
    { -1056, 504, 96},
    { -1456, 408, 176},
    { -1416, 296, 360},
    { -1104, 528, 544},
    { -728, 624, 32},
    { -984, 832, 144},
    { -1456, 840, 336},
    { -2032, 496, 200},
    { -2200, 72, 152},
    { -1872, -96, 392},
    { -1504, 64, 224},
    { -1264, 200, 120},
    { -1056, 280, 72},
    { -888, 144, 56},
    { -944, 160, -96},
    { -824, -64, -72},
    // 59 seconds
    { -1016, -104, -40},
    { -1112, 80, -8},
    { -928, 160, 80},
    { -1080, 184, 48},
    { -1616, 240, 232},
    { -2080, 392, 384},
    { -1976, 488, 304},
    { -1576, 392, 520},
    { -1176, 408, 296},
    { -1312, 216, 104},
    { -1280, 352, 256},
    { -1192, 344, 280},
    { -1368, 328, 200},
    { -1304, 376, 384},
    { -1384, 712, 664},
    { -904, 80, 128},
    { -816, 520, 216},
    { -1200, 440, 160},
    { -1688, 584, 16},
    { -1936, 408, 0},
    { -1896, 376, 104},
    { -1640, 192, 200},
    { -1560, 208, 144},
    { -1304, 280, 56},
    { -984, 208, 48},
    // 60 seconds
    // elapsed: 1 minutes
    { -800, -40, 16},
    { -760, 264, -80},
    { -792, 104, -72},
    { -1024, 128, -104},
    { -1000, 224, -88},
    { -1064, 88, 16},
    { -1528, 280, 16},
    { -1992, 400, 80},
    { -2032, 320, 200},
    { -1664, 272, 336},
    { -1304, 624, 312},
    { -1440, 216, 408},
    { -1384, 168, 184},
    { -1304, 312, 232},
    { -1368, 136, 344},
    { -1608, 608, 376},
    { -1384, 472, 688},
    { -920, 576, 736},
    { -720, 768, 368},
    { -656, 664, 288},
    { -1216, 704, 176},
    { -1928, 560, 144},
    { -2184, 192, 160},
    { -1912, 176, 160},
    { -1680, 192, 112},
    // 61 seconds
    { -1480, 200, 120},
    { -1280, 136, 160},
    { -1072, 56, 152},
    { -1104, 24, 112},
    { -960, -80, -88},
    { -752, -56, -192},
    { -1072, -96, -144},
    { -1056, 112, -96},
    { -1184, 32, -16},
    { -1808, 320, 64},
    { -2184, 344, 136},
    { -1968, 272, 216},
    { -1440, 616, 400},
    { -968, 80, -72},
    { -1192, 312, 112},
    { -1240, 160, 336},
    { -1216, 272, 248},
    { -1416, 312, 344},
    { -1288, 328, 656},
    { -1224, 488, 560},
    { -760, 248, 296},
    { -816, 688, 216},
    { -1264, 688, 184},
    { -1808, 464, 16},
    { -2024, 336, 64},
    // 62 seconds
    { -1824, 112, 144},
    { -1632, 88, 168},
    { -1400, 168, 96},
    { -1224, 168, 96},
    { -1000, 272, -56},
    { -864, -272, -112},
    { -920, -280, -216},
    { -816, 160, -384},
    { -1160, -112, -64},
    { -1256, 112, -8},
    { -1504, 232, 176},
    { -1936, 192, 216},
    { -2288, 504, 224},
    { -1904, 288, 272},
    { -1216, 552, 384},
    { -1112, -160, 224},
    { -1152, 200, 224},
    { -1104, 192, 264},
    { -1096, 240, 264},
    { -1240, 232, 304},
    { -1440, 248, 408},
    { -1264, 600, 944},
    { -912, 312, 224},
    { -656, 592, 216},
    { -1072, 832, 368},
    // 63 seconds
    { -1720, 504, 96},
    { -2248, 368, 104},
    { -2064, 200, 208},
    { -1728, 128, 248},
    { -1448, 152, 200},
    { -1264, 184, 184},
    { -1056, 232, 112},
    { -920, 64, 80},
    { -856, -32, -8},
    { -856, 120, -32},
    { -1104, 96, 32},
    { -1080, 88, 88},
    { -968, 256, 16},
    { -1208, 72, 160},
    { -1688, 152, 336},
    { -1920, 256, 392},
    { -1816, 536, 296},
    { -1456, 432, 616},
    { -1032, 256, 48},
    { -1360, 352, 128},
    { -1472, 216, 392},
    { -1456, 320, 376},
    { -1360, 232, 400},
    { -1480, 368, 544},
    { -936, 376, 512},
    // 64 seconds
    { -544, 464, 280},
    { -728, 632, 224},
    { -1168, 560, 288},
    { -1904, 384, 368},
    { -1856, 248, 264},
    { -1632, 128, 304},
    { -1448, 128, 248},
    { -1328, 168, 184},
    { -1184, 240, 104},
    { -1088, 232, 24},
    { -1008, 96, -16},
    { -848, 88, -104},
    { -1064, 96, -56},
    { -1096, 120, 32},
    { -1000, 88, 112},
    { -1176, 48, 200},
    { -1560, 96, 336},
    { -1856, 328, 368},
    { -1664, 416, 320},
    { -1176, 400, 488},
    { -808, 248, 104},
    { -1032, 256, 72},
    { -1304, 176, 344},
    { -1504, 272, 344},
    { -1520, 352, 336},
    // 65 seconds
    { -1480, 624, 560},
    { -1120, 424, 232},
    { -784, 544, 224},
    { -944, 656, 152},
    { -1400, 520, 112},
    { -1832, 352, 64},
    { -1720, 264, 152},
    { -1488, 224, 152},
    { -1320, 208, 160},
    { -1192, 216, 128},
    { -992, 160, 104},
    { -856, 128, 72},
    { -880, 64, 16},
    { -880, 144, -120},
    { -1112, 104, -16},
    { -1112, 136, 80},
    { -1072, 104, 104},
    { -1344, 160, 152},
    { -1792, 208, 304},
    { -1944, 456, 320},
    { -1752, 456, 296},
    { -1336, 288, 448},
    { -1104, 240, 192},
    { -1312, 328, 304},
    { -1280, 408, 192},
    // 66 seconds
    { -1296, 272, 384},
    { -1192, 600, 416},
    { -1120, 440, 528},
    { -1096, 784, 488},
    { -696, 784, 392},
    { -976, 600, 232},
    { -1496, 544, 176},
    { -2072, 512, 248},
    { -2216, 504, 264},
    { -1880, 320, 320},
    { -1576, 232, 320},
    { -1440, 256, 216},
    { -1240, 248, 144},
    { -984, 224, 88},
    { -896, 264, 40},
    { -792, 256, 144},
    { -688, 760, 128},
    { -328, 792, 256},
    { 48, 1040, 304},
    { 112, 904, 392},
    { 24, 872, 384},
    { 40, 872, 232},
    { 64, 736, 64},
    { -8, 544, -8},
    { -88, 384, -24},
    // 67 seconds
    { -144, 224, -48},
    { -272, 176, -48},
    { -488, 160, 0},
    { -688, 136, 64},
    { -1216, 232, 144},
    { -1952, 208, 304},
    { -2400, 840, 96},
    { -2064, 488, 288},
    { -1512, 688, 344},
    { -1600, 168, 200},
    { -1568, 288, 288},
    { -1328, 264, 312},
    { -1144, 272, 264},
    { -1032, 352, 232},
    { -960, 336, 288},
    { -880, 456, 520},
    { -744, 1176, 808},
    { -856, 88, 432},
    { -1224, 784, 544},
    { -1288, 432, 416},
    { -1440, 424, 336},
    { -1712, 344, 344},
    { -2056, 224, 384},
    { -2024, 280, 320},
    { -1752, 192, 344},
    // 68 seconds
    { -1624, 48, 440},
    { -1472, -24, 296},
    { -1288, 40, 288},
    { -1112, 0, 160},
    { -848, -352, 40},
    { -840, -224, 32},
    { -944, -80, -56},
    { -1256, 232, -64},
    { -1264, 376, -104},
    { -1336, 248, 56},
    { -1400, 24, 184},
    { -1472, 56, 304},
    { -1536, 256, 312},
    { -1600, 360, 416},
    { -1672, 560, 520},
    { -1600, 480, 432},
    { -1400, 584, 504},
    { -1224, 568, 376},
    { -1120, 424, 456},
    { -1080, 400, 616},
    { -960, 440, 496},
    { -896, 464, 296},
    { -1056, 560, 152},
    { -1296, 632, 240},
    { -1536, 584, 104},
    // 69 seconds
    { -1480, 184, 216},
    { -1376, 376, 24},
    { -1168, 360, 128},
    { -1224, 192, 136},
    { -1192, 216, 96},
    { -1312, 144, 328},
    { -1536, -160, 360},
    { -1168, -528, 216},
    { -1264, -200, -40},
    { -1288, 104, -216},
    { -1288, 248, -240},
    { -1320, 248, -56},
    { -1320, 80, 16},
    { -1168, 56, -8},
    { -1112, 256, 40},
    { -1072, 256, 120},
    { -1184, 248, 200},
    { -1320, 320, 232},
    { -1408, 392, 328},
    { -1400, 944, 768},
    { -1160, 248, 560},
    { -1368, 640, 472},
    { -1056, 608, 440},
    { -896, 520, 304},
    { -1144, 488, 272},
    // 70 seconds
    { -1384, 360, 320},
    { -1528, 328, 344},
    { -1440, 112, 272},
    { -1248, 160, 424},
    { -1224, 16, 320},
    { -1176, 104, 296},
    { -1128, 32, 264},
    { -1296, 16, 320},
    { -1216, -232, 248},
    { -992, -192, -16},
    { -1264, -136, -72},
    { -1224, 176, -216},
    { -1176, 256, -24},
    { -1448, 144, 184},
    { -1680, 264, 232},
    { -1568, 304, 352},
    { -1360, 272, 464},
    { -1168, 352, 488},
    { -1024, 416, 456},
    { -1112, 360, 360},
    { -1096, 272, 384},
    { -1152, 328, 392},
    { -1080, 520, 648},
    { -1072, 688, 616},
    { -1048, 416, 392},
    // 71 seconds
    { -1184, 560, 424},
    { -1408, 576, 176},
    { -1648, 456, 248},
    { -1904, 384, 216},
    { -1808, 200, 248},
    { -1600, 80, 448},
    { -1464, 144, 296},
    { -1360, 112, 328},
    { -1168, 16, 360},
    { -1024, -48, 344},
    { -920, -128, 368},
    { -872, -592, 448},
    { -928, -280, -328},
    { -1224, -200, -32},
    { -1376, 624, 96},
    { -1608, 568, 328},
    { -1800, 488, 408},
    { -1736, 472, 664},
    { -1480, 248, 560},
    { -1336, 440, 672},
    { -1176, 368, 608},
    { -1312, 432, 448},
    { -1152, 312, 504},
    { -1080, 368, 592},
    { -1040, 424, 824},
    // 72 seconds
    { -856, 352, 464},
    { -1072, 536, 616},
    { -952, 584, 376},
    { -1208, 536, 312},
    { -1624, 464, 368},
    { -1872, 472, 368},
    { -1656, 216, 256},
    { -1568, 304, 464},
    { -1520, -88, 440},
    { -1400, 104, 376},
    { -1240, 56, 320},
    { -1144, 32, 296},
    { -1048, -120, 272},
    { -880, -272, 120},
    { -1048, -272, 88},
    { -1224, 304, -112},
    { -1280, 816, -264},
    { -1264, 512, -264},
    { -1432, -160, 128},
    { -1552, 304, 184},
    { -1304, 600, 296},
    { -1152, 344, 344},
    { -1240, 416, 232},
    { -1392, 208, 264},
    { -1360, 216, 376},
    // 73 seconds
    { -1336, 296, 432},
    { -1160, 872, 568},
    { -1016, 488, 616},
    { -1288, 520, 624},
    { -1056, 560, 400},
    { -1056, 752, 216},
    { -1320, 560, 280},
    { -1712, 352, 376},
    { -1544, 304, 224},
    { -1464, 320, 184},
    { -1464, 152, 288},
    { -1432, 144, 280},
    { -1296, 104, 288},
    { -1168, 24, 280},
    { -1152, 16, 256},
    { -1056, -240, 96},
    { -1144, -200, 112},
    { -1112, 160, 8},
    { -1056, 424, -312},
    { -1384, 400, 24},
    { -1464, -16, 328},
    { -1512, 160, 400},
    { -1368, 432, 360},
    { -1208, 384, 448},
    { -1144, 640, 352},
    // 74 seconds
    { -1168, 328, 208},
    { -1240, 216, 288},
    { -1328, 120, 432},
    { -1272, 184, 576},
    { -1168, 424, 672},
    { -1344, 496, 592},
    { -1056, 392, 504},
    { -1008, 704, 400},
    { -1144, 480, 416},
    { -1472, 376, 456},
    { -1480, 264, 400},
    { -1416, 320, 664},
    { -1528, 144, 776},
    { -1688, 480, 704},
    { -1584, 528, 632},
    { -1352, 384, 632},
    { -1040, 312, 600},
    { -552, 368, 520},
    { -360, 536, 352},
    { -32, 552, 464},
    { 136, 952, 312},
    { 216, 944, 328},
    { 152, 800, 160},
    { 160, 640, -80},
    { 216, 288, -112},
    // 75 seconds
    { 160, 96, -48},
    { 8, 104, 40},
    { -80, -96, 112},
    { -232, -240, 192},
    { -560, 104, 432},
    { -1272, 232, 520},
    { -2080, 1200, 392},
    { -3464, 1400, 648},
    { -2488, 672, 1472},
    { -1424, 576, 320},
    { -1824, 888, 40},
    { -1496, 480, 440},
    { -768, 400, 416},
    { -392, 224, 128},
    { -448, 120, 264},
    { -424, 296, 56},
    { -520, 328, 96},
    { -672, 280, 176},
    { -1264, 312, 248},
    { -1448, 352, 240},
    { -1768, 336, 256},
    { -1728, 448, -8},
    { -1744, 288, -80},
    { -2064, 280, 168},
    { -2288, 240, 200},
    // 76 seconds
    { -1824, 272, 112},
    { -1352, 152, 176},
    { -1000, 96, 96},
    { -648, -200, 0},
    { -400, -104, -56},
    { -376, -32, -64},
    { -336, -40, -32},
    { -536, 32, 64},
    { -728, 136, 48},
    { -1272, 272, 144},
    { -1552, 296, 200},
    { -2232, 504, 344},
    { -2632, 544, 328},
    { -2288, 352, 696},
    { -1368, 192, 88},
    { -1496, 504, 336},
    { -1280, 496, 288},
    { -984, 296, 256},
    { -904, 400, 248},
    { -920, 344, 320},
    { -1056, 392, 496},
    { -952, 272, 752},
    { -1072, 696, 448},
    { -1040, 624, 568},
    { -976, 456, 512},
    // 77 seconds
    { -1472, 768, 176},
    { -2128, 904, 240},
    { -2560, 832, 296},
    { -2200, 328, 624},
    { -1840, 144, 488},
    { -1496, 184, 408},
    { -1104, 104, 200},
    { -832, 72, 280},
    { -704, 56, 184},
    { -760, 120, 96},
    { -576, 32, -32},
    { -744, 96, -72},
    { -656, 304, -176},
    { -704, 240, -64},
    { -976, 72, 88},
    { -1552, 160, 288},
    { -2144, 320, 480},
    { -2368, 872, 456},
    { -1864, 520, 880},
    { -1256, 584, 144},
    { -1432, 72, 80},
    { -1568, 400, 384},
    { -1520, 216, 488},
    { -1584, 256, 392},
    { -1384, 192, 608},
    // 78 seconds
    { -1144, 720, 1112},
    { -304, 176, 216},
    { -536, 704, 168},
    { -936, 648, 264},
    { -1848, 496, 512},
    { -1672, 264, 104},
    { -1544, 176, 280},
    { -1496, 272, 96},
    { -1408, 72, 296},
    { -1184, 160, 192},
    { -1040, 216, 96},
    { -1008, 240, 56},
    { -880, 168, 96},
    { -1160, 272, 64},
    { -1000, 280, 8},
    { -1112, 80, 128},
    { -1416, 200, 160},
    { -1392, 336, 96},
    { -1168, 360, 112},
    { -968, 408, 72},
    { -920, 352, 104},
    { -960, 328, 176},
    { -984, 224, 256},
    { -1088, 296, 312},
    { -1416, 296, 368},
    // 79 seconds
    { -1856, 168, 480},
    { -1616, 216, 208},
    { -1048, 320, 96},
    { -680, 440, 8},
    { -904, 352, -48},
    { -1296, 352, -56},
    { -1080, 136, -48},
    { -768, 184, -56},
    { -608, 224, -104},
    { -528, 256, -96},
    { -504, 272, -24},
    { -472, 368, 24},
    { -624, 552, 160},
    { -856, 672, 312},
    { -1152, 808, 576},
    { -1200, 1056, 648},
    { -1040, 1088, 616},
    { -1192, 856, 648},
    { -1152, 712, 608},
    { -904, 632, 512},
    { -696, 552, 392},
    { -616, 448, 328},
    { -584, 336, 280},
    { -512, 224, 208},
    { -448, 144, 168},
    // 80 seconds
    { -488, 56, 176},
    { -664, 72, 200},
    { -736, 152, 120},
    { -1120, 336, -40},
    { -1440, 368, 112},
    { -1824, 536, 24},
    { -2248, 496, 176},
    { -1920, 56, 632},
    { -1376, 280, 344},
    { -1192, 496, 176},
    { -1184, 288, 272},
    { -1136, 144, 328},
    { -1016, 168, 296},
    { -984, 192, 336},
    { -1096, 184, 504},
    { -1120, 472, 992},
    { -912, 312, 360},
    { -1040, 552, 304},
    { -904, 592, 336},
    { -1080, 664, 368},
    { -1536, 528, 448},
    { -1968, 320, 472},
    { -2080, 184, 464},
    { -1984, 168, 440},
    { -1816, 80, 392},
    // 81 seconds
    { -1600, 80, 440},
    { -1416, 160, 416},
    { -1288, 328, 480},
    { -1320, 416, 504},
    { -1040, 464, 384},
    { -760, 536, 320},
    { -304, 488, 256},
    { 64, 544, 456},
    { 360, 936, 304},
    { 480, 1096, 120},
    { 328, 600, 248},
    { 456, 552, 160},
    { 536, 440, 120},
    { 552, 272, 192},
    { 568, 200, 192},
    { 560, 128, 184},
    { 592, 272, 144},
    { 672, 256, 176},
    { 744, 384, 304},
    { 832, 560, 296},
    { 1024, 864, 360},
    { 1096, 856, 408},
    { 1040, 872, 272},
    { 856, 512, 312},
    { 760, 672, 376},
    // 82 seconds
    { 696, 544, 304},
    { 592, 384, 248},
    { 544, 288, 8},
    { 456, 136, -40},
    { 440, -24, -64},
    { 168, 216, 96},
    { 304, 328, 32},
    { 208, 512, 296},
    { 280, 1152, 296},
    { 232, 1488, 736},
    { 504, 1744, 576},
    { 520, 1952, 176},
    { 416, 1240, 224},
    { 264, 920, 176},
    { 192, 688, 264},
    { 176, 520, 264},
    { 168, 416, 240},
    { 176, 328, 240},
    { 200, 280, 272},
    { 240, 216, 272},
    { 256, 392, 328},
    { 248, 840, 672},
    { 272, 1184, 1000},
    { 296, 1536, 1096},
    { 280, 1432, 784},
    // 83 seconds
    { 312, 1128, 672},
    { 280, 952, 616},
    { 168, 952, 640},
    { 96, 784, 576},
    { 72, 544, 400},
    { 72, 416, 248},
    { 80, 320, 328},
    { 136, 384, 488},
    { 160, 560, 640},
    { 232, 632, 696},
    { 256, 504, 568},
    { 392, 752, 440},
    { 680, 1096, 408},
    { 760, 1304, 120},
    { 352, 1520, 120},
    { 464, 896, 504},
    { 264, 664, 568},
    { 232, 576, 272},
    { 208, 328, 144},
    { 288, 224, 88},
    { 424, 128, 112},
    { 528, 256, 144},
    { 592, 384, 304},
    { 680, 600, 576},
    { 760, 768, 664},
    // 84 seconds
    { 856, 1184, 672},
    { 664, 1160, 856},
    { 552, 1048, 520},
    { 496, 744, 416},
    { 480, 688, 440},
    { 344, 584, 392},
    { 288, 504, 264},
    { 304, 376, 240},
    { 328, 248, 264},
    { 296, 248, 312},
    { 304, 320, 368},
    { 392, 480, 480},
    { 416, 720, 648},
    { 432, 880, 936},
    { 392, 1248, 1192},
    { 288, 1328, 968},
    { 48, 1416, 568},
    { 48, 984, 512},
    { 136, 680, 568},
    { 152, 408, 448},
    { 144, 304, 312},
    { 168, 320, 232},
    { 216, 352, 264},
    { 264, 344, 376},
    { 320, 512, 496},
    // 85 seconds
    { 416, 800, 696},
    { 472, 888, 856},
    { 504, 1264, 1080},
    { 392, 1232, 1096},
    { 272, 1016, 888},
    { 248, 720, 736},
    { 232, 680, 664},
    { 176, 696, 568},
    { 112, 576, 464},
    { 88, 464, 304},
    { 88, 344, 208},
    { 88, 264, 200},
    { 112, 224, 192},
    { 168, 320, 312},
    { 200, 656, 600},
    { 248, 832, 792},
    { 416, 1448, 1016},
    { 416, 1560, 936},
    { 224, 1768, 608},
    { 128, 1256, 424},
    { 64, 792, 544},
    { 56, 560, 432},
    { 24, 456, 296},
    { 72, 320, 152},
    { 168, 336, 88},
    // 86 seconds
    { 296, 368, 120},
    { 368, 464, 264},
    { 416, 536, 424},
    { 496, 792, 592},
    { 496, 688, 632},
    { 664, 1096, 808},
    { 536, 1000, 808},
    { 440, 872, 624},
    { 448, 720, 624},
    { 424, 696, 696},
    { 304, 688, 512},
    { 272, 552, 320},
    { 264, 400, 240},
    { 288, 312, 280},
    { 288, 312, 304},
    { 320, 344, 408},
    { 392, 440, 584},
    { 400, 584, 768},
    { 456, 736, 800},
    { 592, 1288, 1024},
    { 576, 1472, 848},
    { 312, 1600, 784},
    { 256, 976, 776},
    { 208, 480, 808},
    { 160, 280, 664},
    // 87 seconds
    { 168, 168, 432},
    { 160, 24, 304},
    { 168, -88, 264},
    { 216, -136, 168},
    { 232, -168, 192},
    { 296, -32, 104},
    { 176, 120, 168},
    { -128, 256, 240},
    { -744, 760, 296},
    { -2744, 1368, 632},
    { -2944, 560, 680},
    { -2400, 328, 504},
    { -1672, 400, 488},
    { -1176, 576, 128},
    { -1112, 672, 984},
    { -848, 216, 320},
    { -648, -120, 504},
    { -648, 112, 376},
    { -680, -72, 432},
    { -928, 232, 1096},
    { -1192, -136, 816},
    { -1312, 224, 888},
    { -1416, 256, 960},
    { -1216, 616, 592},
    { -1304, 512, 488},
    // 88 seconds
    { -1760, 456, 568},
    { -2152, 280, 632},
    { -1936, 120, 512},
    { -1464, 112, 416},
    { -1104, 120, 312},
    { -960, 88, 232},
    { -784, 80, 152},
    { -624, 72, 56},
    { -584, 0, -16},
    { -616, 64, 0},
    { -664, 168, 16},
    { -912, 96, 112},
    { -968, 96, 192},
    { -1424, 200, 256},
    { -2192, 304, 504},
    { -2656, 352, 736},
    { -2040, 328, 1264},
    { -1064, -176, 120},
    { -1208, 440, 176},
    { -1264, 464, 552},
    { -1104, 184, 456},
    { -1088, 56, 400},
    { -1272, -32, 456},
    { -1208, 8, 864},
    { -1176, -8, 800},
    // 89 seconds
    { -904, 232, 512},
    { -840, 432, 464},
    { -896, 504, 344},
    { -1664, 576, 544},
    { -2176, 320, 424},
    { -2096, 208, 480},
    { -1808, 96, 392},
    { -1576, 104, 224},
    { -1328, 232, 304},
    { -1256, 552, 384},
    { -1200, 656, 584},
    { -1144, 968, 584},
    { -608, 808, 560},
    { -272, 792, 672},
    { 192, 848, 248},
    { 464, 656, 272},
    { 512, 280, 112},
    { 936, 352, 8},
    { 592, 360, -136},
    { 520, 272, -200},
    { 416, 112, -240},
    { 368, -16, -232},
    { 544, -208, -112},
    { 784, -160, -224},
    { 904, -80, -304},
    // 90 seconds
    { 984, 80, -584},
    { 1080, 128, -536},
    { 1168, 344, -592},
    { 1000, 512, -536},
    { 640, 536, -456},
    { 512, 560, -376},
    { 592, 304, -288},
    { 712, 184, -344},
    { 688, 56, -384},
    { 640, -40, -424},
    { 584, 40, -416},
    { 568, 40, -456},
    { 600, 32, -552},
    { 736, 96, -568},
    { 808, 328, -576},
    { 944, 376, -608},
    { 1128, 232, -512},
    { 1152, 312, -488},
    { 1088, 256, -488},
    { 920, 184, -336},
    { 704, 304, -424},
    { 600, 216, -432},
    { 568, 48, -368},
    { 584, -16, -264},
    { 616, -144, -152},
    // 91 seconds
    { 776, -192, -64},
    { 960, -80, -224},
    { 1120, 112, -472},
    { 848, 152, -728},
    { 808, 208, -648},
    { 856, 224, -520},
    { 688, 360, -552},
    { 648, 240, -488},
    { 544, 80, -312},
    { 592, 88, -192},
    { 640, 400, -408},
    { 608, 56, -256},
    { 552, -144, 48},
    { 536, 288, 128},
    { 464, 408, 320},
    { 584, 752, 848},
    { 648, 984, 952},
    { 824, 600, 1064},
    { 896, 760, 1048},
    { 776, 672, 1016},
    { 648, 688, 888},
    { 608, 424, 816},
    { 544, 472, 752},
    { 464, 384, 576},
    { 400, 352, 456},
    // 92 seconds
    { 400, 256, 400},
    { 368, 256, 352},
    { 400, 288, 456},
    { 448, 336, 488},
    { 544, 392, 608},
    { 656, 528, 624},
    { 784, 600, 728},
    { 816, 696, 840},
    { 696, 952, 816},
    { 496, 1040, 800},
    { 320, 872, 656},
    { 312, 608, 560},
    { 312, 424, 312},
    { 376, 312, 192},
    { 400, 240, 160},
    { 480, 160, 152},
    { 512, 296, 168},
    { 576, 368, 312},
    { 648, 528, 592},
    { 616, 600, 656},
    { 936, 864, 864},
    { 760, 768, 928},
    { 592, 624, 976},
    { 552, 624, 872},
    { 568, 472, 888},
    // 93 seconds
    { 424, 480, 664},
    { 384, 408, 448},
    { 360, 312, 360},
    { 360, 200, 296},
    { 360, 152, 272},
    { 432, 80, 296},
    { 392, -80, 416},
    { 432, 344, 592},
    { 432, 720, 1176},
    { 344, 992, 1680},
    { 400, 1144, 1520},
    { 240, 1096, 1136},
    { 168, 712, 904},
    { 96, 456, 688},
    { 56, 416, 464},
    { 160, 296, 336},
    { 272, 152, 344},
    { 384, 264, 264},
    { 440, 312, 288},
    { 448, 304, 392},
    { 480, 416, 624},
    { 432, 624, 904},
    { 544, 824, 1160},
    { 440, 656, 1232},
    { 368, 512, 1000},
    // 94 seconds
    { 288, 376, 832},
    { 224, 360, 800},
    { 40, 320, 568},
    { -56, 176, 296},
    { -96, 272, 160},
    { -96, 232, 72},
    { -200, 232, 128},
    { -392, 288, 296},
    { -1056, 480, 632},
    { -1384, 392, 544},
    { -2024, 64, 472},
    { -2760, -496, 712},
    { -1696, -320, 1328},
    { -856, 1552, 464},
    { -1008, 256, 376},
    { -912, 128, 216},
    { -704, -48, 288},
    { -496, -88, 272},
    { -480, -136, 288},
    { -536, -112, 288},
    { -648, 88, 264},
    { -888, 56, 264},
    { -1224, 216, 280},
    { -1640, 8, 912},
    { -1280, -88, 888},
    // 95 seconds
    { -1696, 960, 408},
    { -1680, 960, -328},
    { -976, 1600, -96},
    { -1168, -272, 864},
    { -976, -248, 800},
    { -880, -64, 272},
    { -664, 160, -88},
    { -360, -72, 80},
    { -640, 256, 344},
    { -632, -64, 320},
    { -1072, -168, 496},
    { -1200, -304, 600},
    { -1528, -32, 632},
    { -1440, 584, 312},
    { -1504, 1048, -64},
    { -1328, 1088, 8},
    { -1216, -8, 616},
    { -880, -248, 400},
    { -768, 144, 416},
    { -704, 296, 376},
    { -736, 264, 136},
    { -832, 168, 152},
    { -864, 16, 304},
    { -1096, 96, 376},
    { -1136, -16, 616},
    // 96 seconds
    { -1296, 32, 912},
    { -1424, 248, 544},
    { -1240, 568, 312},
    { -1408, 432, 352},
    { -1544, 336, 336},
    { -1408, 824, 544},
    { -1080, -136, 568},
    { -968, -88, 472},
    { -944, -48, 240},
    { -832, 56, 160},
    { -824, 32, 160},
    { -960, -40, 240},
    { -1016, -192, 336},
    { -1168, -272, 368},
    { -1424, -64, 312},
    { -1184, 440, 104},
    { -1368, 544, 64},
    { -1336, 416, 120},
    { -1280, 56, 272},
    { -1144, 112, 264},
    { -944, 168, 360},
    { -808, 232, 168},
    { -928, 312, 288},
    { -944, 208, 312},
    { -992, 144, 448},
    // 97 seconds
    { -1184, 240, 528},
    { -976, 24, 528},
    { -1432, 160, 520},
    { -1392, 256, 416},
    { -1376, 296, 304},
    { -1384, 336, 208},
    { -1448, 336, 80},
    { -1152, 232, 264},
    { -1088, 16, 176},
    { -904, -168, 256},
    { -856, 80, 208},
    { -800, -16, 176},
    { -832, -40, 240},
    { -984, -144, 256},
    { -1168, -248, 320},
    { -1152, -208, 304},
    { -1368, 8, 240},
    { -1392, 512, 72},
    { -1480, 584, 104},
    { -1392, -16, 304},
    { -1312, 104, 216},
    { -1064, 256, 240},
    { -800, 296, 304},
    { -800, 408, 96},
    { -912, -8, 440},
    // 98 seconds
    { -928, 80, 472},
    { -824, 128, 728},
    { -912, 104, 760},
    { -1024, 232, 648},
    { -1408, 80, 680},
    { -1456, 224, 816},
    { -1360, 296, 1104},
    { -1928, 440, 1264},
    { -2192, 256, 1240},
    { -1744, 136, 1048},
    { -1352, 64, 840},
    { -960, -8, 520},
    { -688, -40, 320},
    { -520, -40, 200},
    { -408, -48, 144},
    { -352, -96, 128},
    { -360, -104, 144},
    { -320, -168, 320},
    { -800, 648, 440},
    { -632, 592, 1592},
    { -280, 920, 2608},
    { 72, 656, 2232},
    { 400, 784, 1480},
    { 480, 456, 1392},
    { 248, 240, 896},
    // 99 seconds
    { 64, 312, 616},
    { 32, 104, 560},
    { 88, 96, 416},
    { 216, 184, 536},
    { 360, 0, 568},
    { 432, 344, 552},
    { 512, 288, 904},
    { 544, 648, 936},
    { 824, 640, 1088},
    { 624, 496, 840},
    { 624, 352, 648},
    { 504, 232, 768},
    { 296, 352, 608},
    { 232, 184, 504},
    { 200, 192, 408},
    { 224, 152, 296},
    { 224, 160, 368},
    { 184, 272, 488},
    { 144, 384, 736},
    { 144, 312, 800},
    { -288, 712, 1376},
    { -272, 576, 1632},
    { -336, 1848, 1944},
    { -264, 208, 1208},
    { -280, 808, 704},
    // 100 seconds
    { -616, 744, 568},
    { -360, 176, 896},
    { -376, -72, 512},
    { -296, -136, 168},
    { -392, 48, 208},
    { -776, 528, 528},
    { -600, 144, 656},
    { -968, 312, 528},
    { -1456, 424, 720},
    { -2080, 360, 736},
    { -1568, 352, 800},
    { -1040, 192, 720},
    { -1288, 712, 360},
    { -1384, 296, 464},
    { -912, 288, 232},
    { -672, 304, 136},
    { -608, 176, 248},
    { -664, 144, 176},
    { -680, 0, 200},
    { -800, -24, 168},
    { -1112, -96, 256},
    { -1168, -184, 264},
    { -1552, -72, 280},
    { -1528, 176, 240},
    { -1288, 400, 168},
    // 101 seconds
    { -1304, 272, 152},
    { -1184, 80, 224},
    { -952, 104, 216},
    { -600, 64, 248},
    { -520, 128, 200},
    { -640, 136, 216},
    { -720, 120, 248},
    { -848, 64, 296},
    { -1176, 128, 384},
    { -1336, 8, 496},
    { -1512, 336, 816},
    { -1424, 208, 344},
    { -1216, 376, 416},
    { -1344, 360, 248},
    { -1472, 272, 16},
    { -1320, -120, 584},
    { -848, 184, 264},
    { -776, 48, 248},
    { -800, 32, 208},
    { -880, -24, 216},
    { -888, -64, 200},
    { -1000, -120, 200},
    { -1136, -288, 184},
    { -1256, -184, 216},
    { -1376, 88, 136},
    // 102 seconds
    { -1400, 536, 120},
    { -1560, 416, 224},
    { -1416, -56, 320},
    { -1224, 168, 240},
    { -864, 216, 264},
    { -656, 168, 168},
    { -728, 120, 240},
    { -824, 32, 184},
    { -880, -16, 280},
    { -1016, 16, 304},
    { -1464, 88, 528},
    { -1296, -40, 712},
    { -1232, 312, 600},
    { -1088, 168, 600},
    { -1128, 248, 368},
    { -1392, 120, 376},
    { -1536, 136, 272},
    { -1328, 264, -72},
    { -1176, -80, -80},
    { -984, -224, 288},
    { -1024, -48, 288},
    { -1040, -24, 208},
    { -944, -88, 224},
    { -1016, -168, 232},
    { -1128, -280, 176},
    // 103 seconds
    { -1224, -280, 96},
    { -1272, -208, 232},
    { -1224, 288, 160},
    { -1464, 440, 224},
    { -1528, 160, 232},
    { -1432, 64, 360},
    { -1056, 320, 232},
    { -768, 176, 304},
    { -848, 320, 272},
    { -1040, 128, 320},
    { -1088, 64, 328},
    { -1216, 160, 488},
    { -1208, 280, 856},
    { -704, 0, 792},
    { -1392, 288, 808},
    { -1408, 176, 592},
    { -1544, 136, 632},
    { -1752, 144, 368},
    { -2008, 72, 616},
    { -1888, 48, 528},
    { -1680, 72, 576},
    { -1456, 96, 592},
    { -1072, -8, 424},
    { -712, -64, 336},
    { -488, -72, 88},
    // 104 seconds
    { -328, 40, -512},
    { 0, -144, -712},
    { -264, -96, 24},
    { -944, 480, 1200},
    { -864, 680, 1616},
    { -872, 408, 1464},
    { -544, 640, 1288},
    { -408, 744, 888},
    { -336, 336, 840},
    { -168, 384, 640},
    { -120, 352, 568},
    { -96, 168, 640},
    { -96, 192, 760},
    { -72, 128, 944},
    { 24, 168, 1032},
    { 8, 248, 1168},
    { -128, 168, 1424},
    { -344, 176, 1856},
    { -528, 296, 1928},
    { -336, 216, 1480},
    { -304, 288, 1152},
    { -264, 160, 1128},
    { -248, 192, 1064},
    { -160, 224, 800},
    { -88, 264, 528},
    // 105 seconds
    { -64, 248, 464},
    { -32, 216, 576},
    { 48, 256, 592},
    { 16, 368, 744},
    { 104, 344, 832},
    { 248, 448, 832},
    { 472, 632, 952},
    { 592, 640, 1048},
    { 656, 800, 904},
    { 456, 808, 688},
    { 360, 400, 752},
    { 272, 448, 480},
    { 288, 280, 352},
    { 328, 224, 320},
    { 392, 232, 280},
    { 464, 256, 304},
    { 544, 312, 360},
    { 616, 456, 480},
    { 648, 632, 520},
    { 672, 720, 792},
    { 968, 696, 1208},
    { 472, 672, 872},
    { 544, 536, 680},
    { 592, 336, 784},
    { 464, 384, 472},
    // 106 seconds
    { 272, 392, 280},
    { 184, 304, 104},
    { 128, 144, 160},
    { 48, 96, 136},
    { -112, 56, 232},
    { -448, 184, 584},
    { -1400, 296, 512},
    { -1688, -88, 832},
    { -2336, -192, 728},
    { -2472, 608, 632},
    { -1880, -136, 928},
    { -1024, 1048, 312},
    { -1152, 576, 168},
    { -1112, 216, 504},
    { -656, 0, 464},
    { -584, 160, 288},
    { -608, 64, 320},
    { -744, 24, 344},
    { -936, 120, 368},
    { -1152, 88, 424},
    { -1032, -40, 592},
    { -1720, -64, 520},
    { -1424, 8, 496},
    { -1440, 360, 392},
    { -1672, 536, -48},
    // 107 seconds
    { -1704, 264, 240},
    { -1208, -56, 408},
    { -992, -80, 328},
    { -856, 16, 216},
    { -760, 8, 192},
    { -640, -104, 176},
    { -648, -128, 184},
    { -848, -112, 208},
    { -968, -120, 224},
    { -1256, 48, 168},
    { -1400, 296, 168},
    { -1512, 616, 120},
    { -1720, 56, 328},
    { -1448, 256, 320},
    { -1072, 304, 384},
    { -872, 272, 280},
    { -928, 232, 224},
    { -976, 88, 256},
    { -1008, 8, 312},
    { -936, -64, 392},
    { -1088, -24, 456},
    { -1168, -120, 680},
    { -1432, -48, 648},
    { -1216, -168, 720},
    { -1032, 536, 368},
    // 108 seconds
    { -1272, 368, 456},
    { -1504, 216, 400},
    { -1360, 272, 256},
    { -1120, 168, 288},
    { -1104, -72, 384},
    { -1152, -16, 272},
    { -1088, -64, 256},
    { -976, -80, 152},
    { -984, -80, 232},
    { -1000, -280, 72},
    { -1080, -208, 248},
    { -1200, -40, 56},
    { -1232, 408, 104},
    { -1576, 664, 168},
    { -1576, 96, 328},
    { -1408, -200, 352},
    { -1192, 160, 472},
    { -856, 184, 432},
    { -800, 320, 96},
    { -1064, 168, 232},
    { -1104, -80, 552},
    { -984, -96, 512},
    { -1064, -88, 712},
    { -880, -96, 880},
    { -1360, 24, 768},
    // 109 seconds
    { -1304, -24, 616},
    { -1240, 200, 512},
    { -1352, 296, 416},
    { -1544, 304, 584},
    { -1592, 256, 712},
    { -1632, 72, 832},
    { -1632, 168, 760},
    { -1344, 56, 728},
    { -992, -72, 600},
    { -728, -64, 392},
    { -520, -56, 248},
    { -384, -224, 256},
    { -408, -192, 320},
    { -192, 392, 128},
    { -168, -48, 888},
    { -216, 128, 1680},
    { -168, 336, 2024},
    { -96, 200, 1776},
    { 80, 432, 1128},
    { 136, 248, 872},
    { 160, 216, 784},
    { 176, 64, 800},
    { 232, -64, 832},
    { 160, 104, 840},
    { 184, -40, 880},
    // 110 seconds
    { 144, 88, 856},
    { 184, -56, 872},
    { 152, 304, 704},
    { 184, -64, 920},
    { 184, 48, 1088},
    { 184, 64, 1088},
    { 176, 72, 1072},
    { 272, 64, 920},
    { 216, 80, 1024},
    { 192, 192, 928},
    { 192, -48, 1048},
    { 160, 24, 1088},
    { 192, -64, 1072},
    { 184, -80, 1080},
    { 200, -136, 1024},
    { 176, -48, 1000},
    { 168, 24, 960},
    { 152, -128, 1008},
    { 120, -24, 976},
    { 80, 72, 992},
    { 104, 8, 1024},
    { 112, 64, 960},
    { 120, 16, 1032},
    { 96, 16, 1080},
    { 120, 72, 944},
    // 111 seconds
    { 136, 32, 968},
    { 168, 256, 1064},
    { 192, 256, 1024},
    { 160, 368, 1008},
    { 160, 480, 936},
    { 152, 560, 808},
    { 160, 832, 576},
    { 72, 680, 472},
    { -40, 912, 288},
    { -136, 888, 224},
    { -120, 904, 104},
    { -144, 760, -16},
    { -184, 744, -104},
    { -280, 744, -160},
    { -352, 720, -208},
    { -408, 760, -320},
    { -312, 752, -424},
    { -672, 1408, -304},
    { -528, 1048, -472},
    { -480, 760, -584},
    { -472, 600, -576},
    { -464, 720, -616},
    { -328, 1168, -664},
    { -288, 584, -512},
    { -320, 648, -704},
    // 112 seconds
    { -128, 536, -712},
    { -256, 496, -864},
    { -184, 456, -856},
    { -240, 448, -880},
    { -120, 240, -968},
    { -320, 192, -968},
    { -248, 72, -928},
    { -72, 40, -1024},
    { -208, -8, -912},
    { -80, -96, -1064},
    { -64, -240, -992},
    { -184, -320, -936},
    { -160, -288, -928},
    { -120, -336, -976},
    { -96, -344, -912},
    { -192, -504, -856},
    { -136, -336, -976},
    { -120, -384, -920},
    { -208, -296, -920},
    { -40, -448, -944},
    { -96, -328, -920},
    { -216, -368, -872},
    { -112, -288, -936},
    { -256, -344, -944},
    { -120, -240, -904},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:56:56 local
AccelRawData *activity_sample_walk_200_pbl_25480_11(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25480_11
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 120
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -264, 776, -312},
    { -392, 784, -472},
    { -176, 1000, -520},
    { -136, 784, -464},
    { -56, 776, -696},
    { 48, 648, -616},
    { -128, -240, -848},
    { -256, 392, -1128},
    { -320, -216, -752},
    { -680, -248, -848},
    { -176, -296, -1088},
    { -432, -216, -992},
    { -216, -352, -960},
    { -136, -216, -1072},
    { -816, -376, -816},
    { -272, -456, -920},
    { -280, -376, -824},
    { -624, -664, -816},
    { -488, -592, -672},
    { -384, -616, -816},
    { -232, -496, -912},
    { -312, -640, -800},
    { -240, -552, -872},
    { -264, -512, -920},
    { -208, -568, -928},
    // 1 seconds
    { -272, -368, -904},
    { -200, -536, -880},
    { -176, -360, -960},
    { -168, -352, -920},
    { -184, -248, -952},
    { -144, -240, -920},
    { -152, -264, -952},
    { -104, -264, -912},
    { -80, -256, -992},
    { -64, -240, -976},
    { -56, -216, -1032},
    { -56, -168, -960},
    { -80, -152, -1024},
    { -8, -208, -952},
    { 0, -88, -976},
    { -16, -64, -1072},
    { 8, 8, -928},
    { 8, -40, -1048},
    { 8, -48, -952},
    { 16, -144, -904},
    { 24, -64, -912},
    { 32, -176, -952},
    { 48, -184, -928},
    { 24, -240, -840},
    { 24, -304, -928},
    // 2 seconds
    { 0, -360, -896},
    { 8, -392, -976},
    { -24, -520, -1008},
    { 16, -528, -1096},
    { -64, -408, -1200},
    { -256, -408, -1168},
    { -424, -264, -1104},
    { -480, -200, -1024},
    { -416, -168, -872},
    { -360, -208, -840},
    { -192, -376, -744},
    { -48, -376, -784},
    { -40, -456, -760},
    { -72, -368, -816},
    { -104, -440, -840},
    { -104, -432, -832},
    { -120, -488, -816},
    { -112, -368, -1056},
    { -40, -432, -992},
    { -152, -304, -1328},
    { -192, -288, -1224},
    { -136, -256, -1296},
    { -224, -192, -1224},
    { -304, -184, -1064},
    { -232, -264, -872},
    // 3 seconds
    { -168, -288, -712},
    { -88, -304, -648},
    { -56, -296, -608},
    { -40, -152, -696},
    { -72, -272, -744},
    { -88, -120, -944},
    { -120, -88, -1048},
    { -112, -120, -1376},
    { -336, -112, -1464},
    { -592, -112, -1512},
    { -552, -144, -1320},
    { -448, -160, -1024},
    { -304, -80, -840},
    { -192, -80, -848},
    { -128, -160, -760},
    { -8, -136, -736},
    { -24, -272, -712},
    { -40, -208, -776},
    { -64, -288, -816},
    { -152, -320, -896},
    { -160, -360, -1000},
    { -80, -392, -1112},
    { -184, -352, -1360},
    { -216, -320, -1272},
    { -88, -280, -1192},
    // 4 seconds
    { -64, -256, -1112},
    { -88, -192, -1000},
    { -176, -240, -928},
    { -184, -296, -800},
    { -152, -328, -664},
    { -120, -360, -648},
    { -80, -360, -648},
    { -48, -448, -744},
    { -40, -424, -880},
    { -104, -424, -984},
    { -40, -384, -1104},
    { -216, -304, -1344},
    { -400, -216, -1256},
    { -272, -144, -1280},
    { -320, -248, -1040},
    { -232, -320, -896},
    { -136, -224, -888},
    { -8, -264, -816},
    { 0, -320, -736},
    { 56, -312, -744},
    { 56, -384, -712},
    { -8, -432, -768},
    { -16, -424, -936},
    { -152, -400, -1048},
    { -32, -344, -1280},
    // 5 seconds
    { -248, -272, -1336},
    { -88, -296, -1160},
    { 8, -232, -1128},
    { 16, -208, -1080},
    { -104, -248, -944},
    { -80, -216, -832},
    { -112, -288, -696},
    { -104, -304, -576},
    { -104, -296, -536},
    { -88, -296, -520},
    { -72, -320, -504},
    { -296, -280, -528},
    { -472, -368, -528},
    { -1840, -656, -184},
    { -2648, 576, -88},
    { -1824, -16, -440},
    { -2112, 360, -192},
    { -1872, 408, -504},
    { -1512, 352, -224},
    { -1248, 344, -264},
    { -1104, 416, -272},
    { -1024, 352, -272},
    { -984, 304, -224},
    { -1000, 232, -440},
    { -1128, 296, -360},
    // 6 seconds
    { -1024, 584, -568},
    { -1568, 416, -288},
    { -1304, 304, -464},
    { -1312, 256, -528},
    { -1528, 296, -488},
    { -1880, 224, -376},
    { -1808, 40, -272},
    { -1616, 8, -176},
    { -1424, 48, -120},
    { -1272, 64, -64},
    { -1104, 24, -56},
    { -968, 80, -112},
    { -920, 80, 16},
    { -784, 0, -32},
    { -768, -128, 0},
    { -832, -48, -128},
    { -976, 184, -680},
    { -1128, -24, -552},
    { -1520, -528, -344},
    { -2024, -16, -352},
    { -1824, 112, -384},
    { -1616, 424, -24},
    { -1312, 504, -328},
    { -1232, 264, -160},
    { -1056, 184, -288},
    // 7 seconds
    { -952, 272, -168},
    { -1088, 528, -32},
    { -976, 744, -112},
    { -1016, 1048, -256},
    { -1048, 384, -432},
    { -1264, 840, -376},
    { -1336, 392, -384},
    { -1680, 448, -424},
    { -1824, 416, -328},
    { -1712, 80, 48},
    { -1536, 240, -72},
    { -1440, 160, -64},
    { -1336, 160, -40},
    { -1184, 192, -112},
    { -1072, 208, -16},
    { -1120, 112, 48},
    { -672, -696, 304},
    { -888, -248, -208},
    { -1112, -360, -368},
    { -1376, -464, -352},
    { -1680, -160, -312},
    { -1872, 64, -216},
    { -1752, 416, -160},
    { -1624, 392, 0},
    { -1472, 528, -96},
    // 8 seconds
    { -1408, 608, -56},
    { -1440, 408, -48},
    { -1168, 264, -88},
    { -1208, 608, -192},
    { -1000, 904, -200},
    { -1240, 696, -280},
    { -1056, 608, -360},
    { -1128, 616, -384},
    { -1472, 528, -336},
    { -1792, 368, -296},
    { -1712, 256, -248},
    { -1648, 216, -136},
    { -1576, 160, -72},
    { -1504, 144, -40},
    { -1368, 152, -16},
    { -1384, 176, 0},
    { -1440, 88, 120},
    { -1240, -224, 160},
    { -1160, -616, 376},
    { -1072, -120, -312},
    { -1264, -216, -240},
    { -1496, -72, -248},
    { -1456, -64, -448},
    { -1608, 16, -232},
    { -1696, 304, -232},
    // 9 seconds
    { -1576, 520, -48},
    { -1216, 672, -264},
    { -1208, 304, -248},
    { -1264, 456, -96},
    { -1440, 336, 248},
    { -1240, 560, 168},
    { -1200, 784, -72},
    { -808, 576, -120},
    { -1128, 680, -136},
    { -1416, 664, -56},
    { -1760, 504, 24},
    { -1576, 296, -96},
    { -1512, 208, -8},
    { -1448, 128, 24},
    { -1424, 136, 16},
    { -1344, 128, 48},
    { -1352, 136, 0},
    { -1456, -160, 24},
    { -1152, -672, -120},
    { -1088, -496, 320},
    { -1200, -80, -504},
    { -1600, 168, -528},
    { -1576, 152, -216},
    { -1544, -72, 8},
    { -1480, -176, 24},
    // 10 seconds
    { -1424, 248, 176},
    { -1320, 456, -8},
    { -1408, 432, 72},
    { -1312, 392, -32},
    { -1320, 440, -80},
    { -1352, 752, -152},
    { -1048, 992, -216},
    { -1280, 344, -416},
    { -1024, 432, -416},
    { -1088, 488, -336},
    { -1592, 480, -224},
    { -1904, 344, -128},
    { -1800, 240, -72},
    { -1664, 72, 64},
    { -1552, 224, -8},
    { -1440, 136, 24},
    { -1352, 128, 96},
    { -1200, 152, -32},
    { -1216, 96, 24},
    { -1152, -440, 360},
    { -784, -360, 56},
    { -904, -264, -208},
    { -1432, -136, -128},
    { -1848, 176, -248},
    { -1712, 24, -208},
    // 11 seconds
    { -1696, -56, -88},
    { -1672, 160, -128},
    { -1544, 256, -32},
    { -1376, 384, -80},
    { -1360, 352, -128},
    { -1408, 528, -88},
    { -1240, 416, 40},
    { -1104, 864, -176},
    { -816, 696, -112},
    { -1160, 744, -112},
    { -1144, 624, -32},
    { -1432, 536, -56},
    { -1768, 408, -16},
    { -2152, 424, 0},
    { -1984, 264, -128},
    { -1832, 144, 56},
    { -1768, 120, 16},
    { -1480, -40, -32},
    { -1320, 96, 16},
    { -1144, 8, 16},
    { -1000, -192, 144},
    { -760, -376, 24},
    { -808, -464, 56},
    { -1232, -360, -56},
    { -1528, -104, -184},
    // 12 seconds
    { -1672, -40, -328},
    { -1808, 152, -296},
    { -1856, 72, -232},
    { -1872, 272, -120},
    { -1784, 360, -80},
    { -1680, 472, -128},
    { -1664, 464, -96},
    { -1528, 352, -64},
    { -1184, 784, -328},
    { -976, 536, 0},
    { -960, 680, -8},
    { -1032, 872, 0},
    { -888, 688, -176},
    { -1360, 728, -232},
    { -1728, 352, -104},
    { -1704, 376, -240},
    { -1904, 408, -72},
    { -1944, 184, 96},
    { -1936, 192, 72},
    { -1848, 176, 104},
    { -1576, 112, 128},
    { -1376, 96, 80},
    { -1112, -96, 168},
    { -728, -600, -16},
    { -904, -560, -40},
    // 13 seconds
    { -1200, -96, -248},
    { -1640, 168, -368},
    { -1440, -16, -192},
    { -1440, -168, -184},
    { -1376, 264, -320},
    { -1256, 120, -200},
    { -1312, 176, -232},
    { -1400, 328, -120},
    { -1416, 208, -176},
    { -1616, 216, -320},
    { -1688, 408, -600},
    { -1336, 336, -496},
    { -1552, 136, -472},
    { -1192, 360, -408},
    { -1336, 368, -336},
    { -1544, 304, -200},
    { -1688, 224, -64},
    { -1392, 96, -152},
    { -1408, 0, 168},
    { -1400, 160, 24},
    { -1392, 272, 16},
    { -1384, 256, 32},
    { -1400, 200, 88},
    { -1304, -32, 72},
    { -920, -608, -96},
    // 14 seconds
    { -1048, -240, -160},
    { -1128, -200, -152},
    { -1208, 56, -144},
    { -1368, 160, -232},
    { -1536, 144, -144},
    { -1464, 88, 24},
    { -1216, 56, -136},
    { -1152, 152, -160},
    { -1080, 200, -336},
    { -1216, 352, -312},
    { -1336, 408, -152},
    { -1400, 944, -368},
    { -1288, 592, -240},
    { -1720, 712, -72},
    { -984, 416, -88},
    { -1280, 440, -40},
    { -1488, 440, 80},
    { -1616, 328, 120},
    { -1384, 248, 40},
    { -1200, 160, 104},
    { -1072, 144, 96},
    { -1040, 120, 64},
    { -1136, 120, 88},
    { -1304, 120, 40},
    { -1464, -32, 160},
    // 15 seconds
    { -920, -576, -176},
    { -1128, -304, -104},
    { -1176, -56, -472},
    { -1544, 8, -304},
    { -1592, -40, -168},
    { -1480, -104, -136},
    { -1288, 72, -192},
    { -1176, 400, -80},
    { -1016, 224, -32},
    { -1072, 208, -24},
    { -1168, 240, -40},
    { -1416, 408, -128},
    { -1488, 744, -120},
    { -984, 1040, -240},
    { -1384, 272, -376},
    { -1032, 408, -256},
    { -1312, 456, -24},
    { -1600, 408, 8},
    { -1704, 248, -16},
    { -1400, 136, -88},
    { -1288, 136, 8},
    { -1344, 200, 64},
    { -1408, 168, 96},
    { -1336, 128, 88},
    { -1312, 144, 104},
    // 16 seconds
    { -1360, -264, 464},
    { -448, -1424, 144},
    { -1056, -16, 16},
    { -1528, 0, -40},
    { -1904, 32, 8},
    { -1712, -128, 216},
    { -1688, -264, 88},
    { -1496, -120, 88},
    { -1432, 248, 360},
    { -1272, 368, 392},
    { -1248, 320, 376},
    { -1240, 408, 40},
    { -1304, 400, 152},
    { -1296, 1072, -104},
    { -888, 856, -40},
    { -1176, 648, -32},
    { -1168, 560, -64},
    { -1424, 472, -80},
    { -1648, 448, -80},
    { -1888, 328, -48},
    { -1768, 224, -16},
    { -1656, 184, 120},
    { -1760, 64, 120},
    { -1520, 184, 64},
    { -1360, 40, 128},
    // 17 seconds
    { -1280, 128, 56},
    { -1144, 56, -56},
    { -824, 56, -336},
    { -1096, 176, -472},
    { -856, 24, -576},
    { -504, -40, -480},
    { -552, -8, -304},
    { -840, 144, -160},
    { -992, 152, -40},
    { -1256, 280, 88},
    { -1592, 648, -184},
    { -1704, 600, 144},
    { -1560, 656, 128},
    { -1536, 552, 200},
    { -1536, 744, -296},
    { -1184, 760, -80},
    { -1592, 1160, -744},
    { -1104, 1296, -576},
    { -1200, 896, -536},
    { -1472, 648, -360},
    { -1560, 544, -320},
    { -1320, 560, -200},
    { -1288, 432, -136},
    { -1384, 280, 72},
    { -1424, 248, 64},
    // 18 seconds
    { -1352, 160, 72},
    { -1168, 80, 96},
    { -1144, 144, 144},
    { -1056, -160, 184},
    { -1016, -456, 272},
    { -1232, -24, -408},
    { -1400, -152, -280},
    { -1488, -112, -184},
    { -1480, -152, -184},
    { -1488, 48, -256},
    { -1488, 240, -112},
    { -1464, 96, -96},
    { -1664, 448, -128},
    { -1592, 1072, 32},
    { -1232, 672, -168},
    { -1168, 680, -144},
    { -936, 592, -96},
    { -1336, 760, -72},
    { -928, 520, -16},
    { -1264, 440, 64},
    { -1728, 480, 176},
    { -1856, 448, 24},
    { -1648, 160, -32},
    { -1528, 120, -56},
    { -1504, 88, -8},
    // 19 seconds
    { -1472, 80, 40},
    { -1392, 104, 88},
    { -1312, 8, 80},
    { -1152, -184, 240},
    { -1072, -424, 112},
    { -1024, -1176, 168},
    { -1568, 336, -88},
    { -1408, 176, -552},
    { -1408, 272, -440},
    { -1680, 88, -272},
    { -2008, 96, -240},
    { -2104, 264, 280},
    { -1392, 1448, 320},
    { -1088, -112, -568},
    { -1536, 424, -40},
    { -1240, 472, 256},
    { -912, 400, 32},
    { -904, 344, 96},
    { -1152, 848, 144},
    { -1168, 464, -88},
    { -976, 504, -336},
    { -1200, 648, -88},
    { -1928, 608, 48},
    { -1800, 176, -136},
    { -1704, 16, 32},
    // 20 seconds
    { -1648, -40, 40},
    { -1616, 8, 0},
    { -1568, 96, 56},
    { -1520, 240, 160},
    { -1400, 80, 72},
    { -1376, -112, 400},
    { -1112, -488, 232},
    { -976, -344, -32},
    { -832, -112, -656},
    { -1192, -112, -400},
    { -1528, -208, -336},
    { -1720, -232, -280},
    { -1864, 120, -112},
    { -1752, 480, 40},
    { -1336, 944, -144},
    { -1272, -8, -176},
    { -1360, 320, -32},
    { -1432, 368, 64},
    { -1136, 584, -16},
    { -1208, 1024, 144},
    { -1088, 320, -8},
    { -1040, 544, -80},
    { -1240, 536, -88},
    { -1736, 536, 144},
    { -1704, 256, 96},
    // 21 seconds
    { -1552, 144, 48},
    { -1600, 216, 104},
    { -1584, 96, 104},
    { -1464, 72, 104},
    { -1392, 104, 136},
    { -1608, 8, 200},
    { -1328, -280, 168},
    { -1008, -472, 168},
    { -1032, -536, -8},
    { -1232, -176, -160},
    { -1472, 24, -224},
    { -1536, 72, -224},
    { -1584, 16, -152},
    { -1544, 96, -168},
    { -1504, 104, -8},
    { -1480, 296, -40},
    { -1448, 344, -104},
    { -1440, 592, -176},
    { -1208, 536, -128},
    { -976, 744, -160},
    { -1248, 792, -272},
    { -1136, 640, -168},
    { -1168, 544, -200},
    { -1624, 432, -216},
    { -2088, 344, -96},
    // 22 seconds
    { -1904, 208, -160},
    { -1712, 176, -120},
    { -1632, 16, 72},
    { -1504, 200, 32},
    { -1232, 104, 88},
    { -1240, 184, 48},
    { -1240, 144, 40},
    { -992, 24, 56},
    { -1168, -256, 120},
    { -1016, -208, -120},
    { -1080, 48, -432},
    { -1344, 72, -216},
    { -1464, 56, -144},
    { -1568, 40, -16},
    { -1664, 312, -64},
    { -1776, 440, 120},
    { -1720, 608, 104},
    { -1496, 520, 104},
    { -1432, 544, 32},
    { -1320, 664, 48},
    { -1168, 464, 216},
    { -1128, 728, 120},
    { -800, 760, 24},
    { -936, 904, -144},
    { -1016, 688, -152},
    // 23 seconds
    { -1384, 696, 16},
    { -1528, 512, 152},
    { -1520, 288, 88},
    { -1552, 224, 64},
    { -1560, 280, 72},
    { -1584, 264, 104},
    { -1384, 120, 128},
    { -1448, 160, 152},
    { -1504, 32, 200},
    { -1200, -528, 48},
    { -1304, -360, 72},
    { -1296, -104, -184},
    { -1408, 216, -312},
    { -1328, 96, -136},
    { -1344, -120, -64},
    { -1256, 0, -152},
    { -1256, 208, -64},
    { -1264, 320, -72},
    { -1368, 416, -72},
    { -1408, 600, -80},
    { -1088, 960, -288},
    { -1104, 528, -232},
    { -1376, 432, 32},
    { -1232, 104, -208},
    { -1376, 584, -216},
    // 24 seconds
    { -1240, 352, -176},
    { -1496, 248, -96},
    { -1728, 280, -160},
    { -1656, 240, -208},
    { -1456, 224, -128},
    { -1400, 128, -16},
    { -1272, 120, -32},
    { -1136, 96, 16},
    { -1128, 208, 40},
    { -1232, 560, 120},
    { -1168, 784, 64},
    { -848, 696, -64},
    { -608, 888, -8},
    { -16, 912, -216},
    { 0, 1008, -288},
    { -56, 968, -224},
    { 16, 784, -280},
    { 200, 664, -272},
    { 384, 424, -152},
    { 408, 360, -168},
    { 432, 384, -136},
    { 480, 344, -136},
    { 544, 448, -208},
    { 616, 600, -216},
    { 632, 696, -256},
    // 25 seconds
    { 728, 904, -200},
    { 560, 984, -152},
    { 504, 1136, -272},
    { 488, 944, -176},
    { 464, 688, -224},
    { 432, 416, -296},
    { 328, 256, -256},
    { 200, 48, -176},
    { 96, -112, -88},
    { -120, -72, -88},
    { -328, 24, -120},
    { -672, 8, -104},
    { -1632, -200, 136},
    { -2536, 928, -128},
    { -2936, 752, -256},
    { -1976, 464, -328},
    { -1584, 104, -312},
    { -1568, 408, -56},
    { -1376, 288, 8},
    { -1112, 64, 24},
    { -800, 104, 160},
    { -640, 312, 200},
    { -616, 376, 152},
    { -576, 392, 8},
    { -696, 520, -88},
    // 26 seconds
    { -992, 712, 24},
    { -1056, 1096, 200},
    { -1696, -48, 24},
    { -1520, 312, -72},
    { -1648, 488, -16},
    { -1768, 376, 32},
    { -1952, 240, 16},
    { -1728, 232, 72},
    { -1384, 96, 192},
    { -1152, 64, 56},
    { -1056, 104, 64},
    { -992, 72, 64},
    { -992, 112, 0},
    { -944, -312, 264},
    { -520, -592, -56},
    { -888, -176, -48},
    { -1328, -16, -56},
    { -1568, 208, -392},
    { -1784, 168, -256},
    { -1864, -96, -40},
    { -1680, 48, -64},
    { -1400, 288, -8},
    { -1288, 352, -8},
    { -1360, 392, -24},
    { -1312, 400, 0},
    // 27 seconds
    { -1152, 344, 72},
    { -1080, 392, 120},
    { -1072, 848, 248},
    { -1176, 472, 104},
    { -1080, 544, -8},
    { -1072, 536, -8},
    { -1360, 560, -24},
    { -1568, 456, -96},
    { -1640, 272, -144},
    { -1560, 240, -184},
    { -1464, 184, -104},
    { -1432, 120, -56},
    { -1400, 200, 16},
    { -1272, 120, 16},
    { -1296, 120, 64},
    { -1224, 56, 72},
    { -976, -32, 32},
    { -1280, -280, 16},
    { -1064, -360, -192},
    { -1408, -176, -280},
    { -1792, 208, -504},
    { -1752, 88, -216},
    { -1632, -8, 64},
    { -1552, 160, 96},
    { -1544, 416, 120},
    // 28 seconds
    { -1536, 496, 96},
    { -1408, 592, 72},
    { -1312, 536, -16},
    { -1392, 632, 184},
    { -944, 1000, 0},
    { -976, 808, -8},
    { -896, 680, -120},
    { -1112, 576, -168},
    { -1392, 584, -128},
    { -1688, 584, -144},
    { -1912, 672, -56},
    { -1760, 248, 64},
    { -1768, 280, 104},
    { -1664, 120, 96},
    { -1576, 120, 80},
    { -1560, 144, 56},
    { -1560, -200, 136},
    { -1080, -432, -8},
    { -1272, -680, 80},
    { -1360, -368, -168},
    { -1560, -24, -296},
    { -1616, 48, -248},
    { -1648, 16, -120},
    { -1680, 16, -24},
    { -1680, 280, 32},
    // 29 seconds
    { -1696, 416, 176},
    { -1560, 592, -88},
    { -1600, 704, -96},
    { -1576, 624, 16},
    { -1336, 608, 120},
    { -872, 512, 88},
    { -904, 648, 32},
    { -784, 952, 200},
    { -1280, 616, 8},
    { -1960, 552, -40},
    { -2208, 440, 128},
    { -2048, 192, 176},
    { -1784, 48, 152},
    { -1560, 104, 144},
    { -1368, 144, 96},
    { -1248, 96, 128},
    { -1368, -40, 136},
    { -1368, -288, 208},
    { -1192, -568, 232},
    { -1232, -352, 112},
    { -1264, 40, -320},
    { -1608, 144, -160},
    { -1624, 112, -184},
    { -1656, -8, -24},
    { -1744, 232, 0},
    // 30 seconds
    { -1768, 464, -8},
    { -1576, 896, -392},
    { -1424, 832, -504},
    { -1496, 896, -528},
    { -1616, 648, -320},
    { -1080, 824, -464},
    { -1480, 824, -424},
    { -1504, 640, -56},
    { -1880, 280, 128},
    { -2008, 192, 104},
    { -1792, 168, 80},
    { -1640, 192, 88},
    { -1496, 192, 112},
    { -1416, 184, 104},
    { -1384, 160, 152},
    { -1456, 176, 112},
    { -1256, -584, 400},
    { -496, -1024, -64},
    { -1296, -256, -112},
    { -1960, -200, 128},
    { -1928, -264, 56},
    { -1848, -248, -96},
    { -1584, -80, -128},
    { -1408, 72, -112},
    { -1352, 160, -16},
    // 31 seconds
    { -1448, 128, 16},
    { -1688, 248, 232},
    { -1936, 520, 168},
    { -1872, 952, 176},
    { -1304, 728, 216},
    { -1336, 880, 16},
    { -912, 928, 32},
    { -824, 808, -128},
    { -1280, 576, -152},
    { -1712, 384, 16},
    { -1800, 280, 0},
    { -1856, 80, 112},
    { -1552, -232, 240},
    { -1664, -80, -80},
    { -1784, 32, 48},
    { -1800, 24, 64},
    { -1616, -480, 440},
    { -1352, -800, 32},
    { -1344, -1024, 120},
    { -1880, -552, 40},
    { -1640, -344, 48},
    { -1456, -144, -80},
    { -1400, -88, -176},
    { -1272, -96, -160},
    { -1272, 0, -96},
    // 32 seconds
    { -1408, 336, -192},
    { -1424, 384, -408},
    { -1800, 416, -400},
    { -1840, 1192, -648},
    { -1272, 264, -448},
    { -1368, 768, -168},
    { -1160, 720, -200},
    { -1864, 400, 56},
    { -2016, 200, 112},
    { -1704, 176, 64},
    { -1480, 120, 144},
    { -1400, 112, 168},
    { -1312, 40, 184},
    { -1376, 104, 168},
    { -1416, -56, 256},
    { -1424, -104, 232},
    { -784, -496, 8},
    { -1216, -408, -392},
    { -1472, -576, -360},
    { -1800, -384, -200},
    { -1584, -96, -184},
    { -1392, 16, -160},
    { -1232, 40, -32},
    { -1168, 176, 48},
    { -1208, 152, 80},
    // 33 seconds
    { -1432, 248, 104},
    { -1696, 344, 48},
    { -2016, 280, 304},
    { -1808, 1504, 240},
    { -1392, 760, -240},
    { -976, 664, -200},
    { -984, 800, -248},
    { -1328, 744, -328},
    { -1744, 376, -232},
    { -1704, 376, -232},
    { -1480, 296, -112},
    { -1504, 168, -16},
    { -1472, 216, -40},
    { -1528, 184, 56},
    { -1728, 152, 128},
    { -1640, -288, 368},
    { -1080, -752, 192},
    { -1152, -936, 112},
    { -1536, -408, -104},
    { -2000, -128, -80},
    { -1872, -80, -136},
    { -1696, -128, -48},
    { -1432, 96, -120},
    { -1368, 200, -40},
    { -1472, 240, 120},
    // 34 seconds
    { -1544, 344, 0},
    { -1640, 552, 40},
    { -1568, 1112, 64},
    { -944, 600, 88},
    { -1096, 416, -224},
    { -984, 784, -40},
    { -1456, 528, -176},
    { -1864, 288, -296},
    { -1888, 328, -400},
    { -1632, 304, -368},
    { -1624, 136, -136},
    { -1552, 88, 32},
    { -1544, 80, 48},
    { -1656, 56, -24},
    { -2000, -256, 464},
    { -1336, -608, 304},
    { -1248, -816, 392},
    { -1328, -544, 16},
    { -1568, -280, -24},
    { -1624, 24, -272},
    { -1736, 80, -336},
    { -1768, 128, -312},
    { -1728, 240, -272},
    { -1632, 424, -288},
    { -1408, 560, -72},
    // 35 seconds
    { -1208, 352, -280},
    { -1128, 288, -200},
    { -1296, 512, -120},
    { -1096, 648, -256},
    { -1232, 800, -312},
    { -1504, 408, 8},
    { -2016, 360, -24},
    { -1872, 304, -264},
    { -1968, 416, -312},
    { -1776, 64, 88},
    { -1376, 112, -24},
    { -1240, -72, 64},
    { -1128, 136, -8},
    { -1040, 152, 24},
    { -1056, -24, 200},
    { -1224, -528, 624},
    { -1400, -376, 424},
    { -1480, -480, 680},
    { -1512, 72, -496},
    { -1624, 88, -680},
    { -1880, -280, -632},
    { -2608, -352, -496},
    { -2392, 640, -216},
    { -1376, 920, -656},
    { -1328, 368, -544},
    // 36 seconds
    { -1528, 424, 24},
    { -1392, 216, 72},
    { -1544, 312, 144},
    { -1288, 752, 408},
    { -1160, 1088, 16},
    { -656, 464, -8},
    { -1256, 616, 72},
    { -1992, 536, 184},
    { -2080, 160, 0},
    { -1888, 224, -64},
    { -1880, 200, -32},
    { -1960, 200, -8},
    { -1976, 192, -8},
    { -1864, 104, 96},
    { -1864, 88, 56},
    { -1512, -392, 392},
    { -952, -792, 120},
    { -1512, -384, -384},
    { -1752, -368, -120},
    { -1696, -208, -80},
    { -1488, 8, -176},
    { -1368, 104, -256},
    { -1328, 56, -32},
    { -1344, 232, 208},
    { -1192, 328, 128},
    // 37 seconds
    { -1304, 192, 160},
    { -1936, 472, 176},
    { -1840, 624, 96},
    { -1296, 1208, 24},
    { -1080, 704, -160},
    { -920, 680, -104},
    { -1248, 416, -144},
    { -1344, 400, -176},
    { -1544, 320, -128},
    { -1552, 200, -112},
    { -1376, 200, -24},
    { -1376, 208, 120},
    { -1464, 160, 136},
    { -1528, 48, 168},
    { -1672, 0, 184},
    { -1432, -256, 400},
    { -1280, -640, 296},
    { -1304, -528, -24},
    { -1552, -248, -392},
    { -1712, -16, -200},
    { -1504, -96, -56},
    { -1408, 8, -64},
    { -1304, 256, -80},
    { -1160, 272, -8},
    { -1192, 360, 88},
    // 38 seconds
    { -1256, 424, -96},
    { -1520, 392, -80},
    { -1608, 624, 168},
    { -1088, 1160, 112},
    { -1224, 1104, -88},
    { -904, 936, 48},
    { -912, 696, -64},
    { -1112, 440, -32},
    { -1408, 560, -56},
    { -1592, 688, -40},
    { -1472, 384, 32},
    { -1424, 336, 56},
    { -1432, 256, 56},
    { -1440, 264, 112},
    { -1408, 248, 120},
    { -1448, 216, 104},
    { -1120, 312, -168},
    { -1168, 512, -224},
    { -984, 616, -576},
    { -760, 560, -1016},
    { -704, 104, -744},
    { -432, 64, -920},
    { -160, -24, -784},
    { 56, -136, -712},
    { 48, -80, -664},
    // 39 seconds
    { 64, -96, -648},
    { 24, -184, -672},
    { 64, -280, -800},
    { -96, -168, -1088},
    { -136, -272, -1208},
    { -256, -80, -1576},
    { -296, -120, -1360},
    { -232, -48, -1280},
    { -96, -64, -1128},
    { -152, -104, -1024},
    { -208, -144, -856},
    { -200, -200, -680},
    { -160, -248, -576},
    { -168, -232, -632},
    { -160, -304, -728},
    { -232, -336, -952},
    { -368, -384, -1008},
    { -256, -424, -1216},
    { -368, -400, -1336},
    { -488, -368, -1272},
    { -464, -336, -1224},
    { -384, -360, -920},
    { -232, -320, -776},
    { -128, -368, -664},
    { -96, -392, -560},
    // 40 seconds
    { -64, -440, -536},
    { -64, -440, -600},
    { -64, -496, -656},
    { -40, -544, -792},
    { -144, -600, -864},
    { -72, -792, -1064},
    { -248, -464, -1392},
    { -304, -552, -1360},
    { -168, -520, -1272},
    { -80, -472, -1072},
    { -128, -456, -888},
    { -160, -416, -696},
    { -152, -376, -576},
    { -152, -384, -504},
    { -200, -416, -536},
    { -272, -488, -656},
    { -360, -576, -848},
    { -440, -576, -1000},
    { -320, -608, -1192},
    { -400, -544, -1336},
    { -488, -440, -1360},
    { -592, -416, -1176},
    { -472, -408, -888},
    { -296, -456, -680},
    { -216, -456, -544},
    // 41 seconds
    { -160, -440, -496},
    { -64, -456, -440},
    { -40, -472, -496},
    { -72, -560, -488},
    { -144, -520, -688},
    { -176, -424, -1144},
    { -200, -392, -1504},
    { -344, -504, -1536},
    { -240, -360, -1464},
    { -152, -336, -1336},
    { -152, -256, -1216},
    { -184, -304, -976},
    { -160, -352, -688},
    { -128, -368, -496},
    { -104, -288, -536},
    { -88, -264, -640},
    { -152, -264, -832},
    { -216, -192, -936},
    { -192, -208, -1104},
    { -120, -200, -1248},
    { -216, -240, -1352},
    { -200, -40, -1424},
    { -240, 8, -1352},
    { -248, 24, -936},
    { -128, -48, -848},
    // 42 seconds
    { -32, -32, -544},
    { 32, 80, -440},
    { 96, 192, -368},
    { 192, 304, -408},
    { 216, 456, -264},
    { 312, 896, -368},
    { 224, 1056, -192},
    { 464, 1368, -256},
    { 448, 1456, 112},
    { 424, 1520, -32},
    { 392, 1168, 104},
    { 344, 1056, 56},
    { 240, 920, -8},
    { 192, 584, 32},
    { 104, 464, 8},
    { 112, 352, -40},
    { 48, 264, -56},
    { 72, 104, -48},
    { -40, 64, 56},
    { -632, 128, 160},
    { -1224, 304, -256},
    { -1832, 568, -568},
    { -2728, 848, -288},
    { -2504, 832, -1432},
    { -1960, 464, 176},
    // 43 seconds
    { -1240, 408, -184},
    { -1080, 440, -8},
    { -920, 344, 16},
    { -768, 248, 104},
    { -720, 216, 88},
    { -736, 216, 200},
    { -816, 312, 208},
    { -1144, 568, 184},
    { -824, 168, 24},
    { -1424, 600, 392},
    { -960, 768, -88},
    { -960, 472, 32},
    { -1736, 1280, 360},
    { -1720, 768, 24},
    { -1600, 496, 176},
    { -1512, 264, 376},
    { -1424, 176, 176},
    { -1256, 256, 96},
    { -1104, 240, 96},
    { -1064, 56, 176},
    { -1112, -232, 296},
    { -960, -568, 184},
    { -1408, -496, 104},
    { -1664, 200, -560},
    { -2184, 416, -688},
    // 44 seconds
    { -1936, 360, -120},
    { -1520, 80, -24},
    { -1264, 176, -104},
    { -1168, 232, -120},
    { -1192, 336, -136},
    { -1240, 320, -72},
    { -1176, 376, -192},
    { -1264, 448, -144},
    { -1232, 1160, -168},
    { -864, 120, -336},
    { -1336, 768, -184},
    { -968, 416, -88},
    { -1376, 440, -88},
    { -1792, 328, 8},
    { -1872, 280, -8},
    { -1648, 200, 0},
    { -1512, 184, 32},
    { -1408, 120, 56},
    { -1344, 96, 88},
    { -1296, 56, 80},
    { -1360, 56, 96},
    { -1312, -256, 232},
    { -1008, -504, -64},
    { -1152, -512, 48},
    { -1312, -16, -456},
    // 45 seconds
    { -1720, -16, -312},
    { -1704, 80, -280},
    { -1616, -192, -192},
    { -1472, 176, -312},
    { -1352, 248, -192},
    { -1224, 64, -48},
    { -1368, 192, -80},
    { -1416, 336, -112},
    { -1400, 384, -80},
    { -1360, 536, 56},
    { -1160, 632, -80},
    { -1184, 392, -216},
    { -960, 408, -104},
    { -1456, 472, -120},
    { -1504, 200, -240},
    { -1504, 240, -280},
    { -1384, 152, -208},
    { -1344, 104, -152},
    { -1424, 112, -128},
    { -1536, 56, -32},
    { -1560, 64, -16},
    { -1568, 72, 24},
    { -1312, -304, 136},
    { -1104, -696, 144},
    { -1152, -280, -88},
    // 46 seconds
    { -1216, -96, -504},
    { -1696, -48, -344},
    { -1568, -48, -264},
    { -1512, -224, -192},
    { -1336, 336, -304},
    { -1160, -136, -40},
    { -1024, 176, -312},
    { -1240, 272, -240},
    { -1368, 432, -304},
    { -1464, 560, -280},
    { -1104, 472, -272},
    { -1440, 624, -376},
    { -1344, 424, -168},
    { -1352, 280, -208},
    { -1480, 208, -224},
    { -1544, 256, -208},
    { -1312, 184, -200},
    { -1176, 120, -112},
    { -1160, 88, -48},
    { -1136, 88, -16},
    { -1216, 96, 0},
    { -1320, 88, 16},
    { -1184, -104, 40},
    { -1016, -464, -96},
    { -1296, -224, -168},
    // 47 seconds
    { -1184, -104, -472},
    { -1544, -32, -376},
    { -1432, -256, -144},
    { -1384, -160, -88},
    { -1328, 192, -88},
    { -1248, 384, -104},
    { -1168, 408, -192},
    { -1200, 416, -184},
    { -1256, 544, -128},
    { -1136, 744, -168},
    { -1072, 152, -224},
    { -1520, 512, -280},
    { -1304, 464, -160},
    { -1048, 344, -304},
    { -1376, 328, -232},
    { -1608, 288, -232},
    { -1416, 184, -264},
    { -1296, 136, -208},
    { -1272, 88, -120},
    { -1200, 48, -80},
    { -1088, 56, -80},
    { -1040, 64, -88},
    { -1192, 24, -80},
    { -1112, -8, -64},
    { -1240, -64, -96},
    // 48 seconds
    { -1120, 16, -240},
    { -944, 64, -384},
    { -1104, 40, -344},
    { -1272, 40, -184},
    { -1312, 88, -112},
    { -1296, 200, -64},
    { -1312, 264, 16},
    { -1336, 352, 40},
    { -1272, 440, -8},
    { -1144, 368, -128},
    { -1136, 704, -40},
    { -1088, 432, -32},
    { -1248, 688, -168},
    { -1152, 768, -280},
    { -1096, 744, -256},
    { -1384, 520, -240},
    { -1856, 624, -96},
    { -1928, 312, -16},
    { -1744, 328, 48},
    { -1496, 112, 128},
    { -1360, 168, 48},
    { -1224, 160, 40},
    { -1064, 144, 64},
    { -1000, 96, 80},
    { -816, -280, 96},
    // 49 seconds
    { -680, -336, -32},
    { -960, -208, -88},
    { -1136, 104, -264},
    { -1552, 240, -464},
    { -1680, 112, -160},
    { -1704, -288, 128},
    { -1704, 32, -128},
    { -1592, 360, -80},
    { -1464, 624, 360},
    { -1288, 360, -56},
    { -1320, 344, -80},
    { -1408, 424, -56},
    { -1424, 680, 40},
    { -1144, 536, 96},
    { -1344, 416, -56},
    { -984, 624, -40},
    { -888, 424, -168},
    { -1400, 472, 0},
    { -1816, 416, 88},
    { -1816, 192, 56},
    { -1688, 136, 72},
    { -1640, 120, 96},
    { -1568, 96, 96},
    { -1472, 72, 104},
    { -1360, 48, 104},
    // 50 seconds
    { -1352, 24, 120},
    { -1224, -400, 96},
    { -1024, -744, 128},
    { -1216, -328, -168},
    { -1384, -48, -368},
    { -1720, 72, -216},
    { -1616, 72, -136},
    { -1640, -96, -40},
    { -1696, 280, 0},
    { -1512, 248, 32},
    { -1352, 384, -80},
    { -1336, 352, -128},
    { -1384, 472, -72},
    { -1352, 464, -48},
    { -1200, 432, 16},
    { -1320, 592, -104},
    { -1064, 656, -128},
    { -1000, 472, -184},
    { -1408, 392, -96},
    { -1808, 320, 40},
    { -1848, 184, 56},
    { -1680, 120, 64},
    { -1584, 112, 80},
    { -1528, 88, 88},
    { -1472, 72, 104},
    // 51 seconds
    { -1400, 40, 120},
    { -1432, 8, 176},
    { -1224, -448, 176},
    { -936, -728, 40},
    { -1248, -112, -208},
    { -1304, -64, -312},
    { -1688, -32, -48},
    { -1536, -56, -32},
    { -1520, -128, -88},
    { -1536, 160, -40},
    { -1456, 48, -48},
    { -1368, 400, -40},
    { -1368, 456, -136},
    { -1600, 360, -72},
    { -1560, 432, 8},
    { -1312, 472, 88},
    { -1152, 376, -40},
    { -1056, 600, -72},
    { -744, 504, -152},
    { -1240, 440, 32},
    { -1592, 328, 144},
    { -1760, 200, 128},
    { -1632, 136, 120},
    { -1560, 112, 160},
    { -1536, 88, 168},
    // 52 seconds
    { -1480, 72, 176},
    { -1424, 64, 152},
    { -1360, 24, 208},
    { -1304, -392, 120},
    { -952, -520, -304},
    { -1216, -416, -288},
    { -1472, -120, -376},
    { -1520, -128, -72},
    { -1392, -376, 136},
    { -1472, -176, 104},
    { -1432, 88, 136},
    { -1368, 240, 264},
    { -1328, 320, 264},
    { -1320, 312, 232},
    { -1352, 360, 80},
    { -1488, 328, 168},
    { -1512, 616, 280},
    { -1024, 568, -56},
    { -1368, 688, -32},
    { -952, 608, -160},
    { -1088, 568, -216},
    { -1344, 440, -136},
    { -1712, 384, -32},
    { -1688, 176, 56},
    { -1640, 104, 144},
    // 53 seconds
    { -1560, 184, 120},
    { -1544, 112, 112},
    { -1432, 152, 96},
    { -1360, 136, 160},
    { -1296, 80, 160},
    { -1152, -120, 176},
    { -1208, -400, 128},
    { -976, -368, -256},
    { -1264, -224, -256},
    { -1640, -48, -208},
    { -1616, -8, -88},
    { -1592, -24, -40},
    { -1592, 16, 112},
    { -1568, 408, 208},
    { -1432, 416, 136},
    { -1416, 328, -16},
    { -1592, 992, -392},
    { -1288, 344, 24},
    { -1200, 640, -40},
    { -1152, 984, -104},
    { -1152, 1120, 48},
    { -944, 424, -80},
    { -1360, 544, -176},
    { -1776, 472, 16},
    { -1952, 520, 88},
    // 54 seconds
    { -1928, 576, 120},
    { -1912, 608, 208},
    { -1992, 824, 56},
    { -1840, 856, 88},
    { -1512, 736, 16},
    { -1200, 600, -8},
    { -792, 480, -176},
    { -480, 488, -296},
    { -112, 408, -376},
    { 368, 384, -520},
    { 312, 696, -640},
    { 328, 520, -448},
    { 384, 376, -416},
    { 504, 288, -384},
    { 512, 184, -224},
    { 496, 176, -168},
    { 504, 280, -112},
    { 608, 536, -208},
    { 840, 600, -176},
    { 832, 568, -400},
    { 888, 336, -320},
    { 1080, 280, -200},
    { 992, 336, -144},
    { 792, 448, -304},
    { 544, 264, -216},
    // 55 seconds
    { 96, 352, -272},
    { -16, 392, -520},
    { -320, 400, -448},
    { -424, 368, -456},
    { -376, 104, -248},
    { -664, 144, -248},
    { -784, 56, -288},
    { -1456, -304, 1056},
    { -2128, -168, 304},
    { -2800, -224, 336},
    { -2280, 368, 112},
    { -1656, 800, -160},
    { -1240, 600, -480},
    { -1112, 680, 512},
    { -280, 680, -576},
    { -1000, 248, 120},
    { -512, 256, -40},
    { -504, 72, 64},
    { -504, 192, 72},
    { -744, 280, 40},
    { -1424, 392, 72},
    { -1768, 472, 232},
    { -1584, 1320, 232},
    { -784, -504, -280},
    { -1632, 1176, -176},
    // 56 seconds
    { -1720, 336, 48},
    { -1496, 168, -72},
    { -1184, 256, -40},
    { -984, 120, 48},
    { -880, 128, 40},
    { -824, 80, 40},
    { -912, 56, 80},
    { -1128, 72, 104},
    { -1104, -208, 264},
    { -1224, -192, 80},
    { -1472, 32, -96},
    { -1368, 88, -368},
    { -1616, 56, -216},
    { -1456, -128, -128},
    { -1400, -32, -112},
    { -1248, 120, -64},
    { -1104, 264, 144},
    { -1104, 272, 80},
    { -1128, 304, 80},
    { -1104, 376, -24},
    { -1304, 512, -8},
    { -1232, 1144, 336},
    { -1272, 120, -112},
    { -1144, 632, -112},
    { -1248, 544, -136},
    // 57 seconds
    { -1552, 448, -120},
    { -1680, 296, -128},
    { -1552, 224, -120},
    { -1416, 240, -48},
    { -1368, 128, 32},
    { -1328, 88, 48},
    { -1264, 48, 80},
    { -1200, 72, 80},
    { -1248, 32, 96},
    { -1152, -304, 96},
    { -992, -408, -104},
    { -1272, -360, -112},
    { -1248, -136, -304},
    { -1648, -24, -256},
    { -1664, -24, -168},
    { -1752, 40, -40},
    { -1736, 264, -32},
    { -1616, 432, 160},
    { -1312, 664, 24},
    { -1136, 208, -104},
    { -1240, 312, 48},
    { -1216, 424, 256},
    { -1128, 488, 288},
    { -1096, 472, 160},
    { -1128, 536, 64},
    // 58 seconds
    { -944, 472, -88},
    { -1280, 632, -128},
    { -1664, 608, -72},
    { -1704, 272, -104},
    { -1632, 72, -16},
    { -1568, 56, 32},
    { -1480, 48, 8},
    { -1376, 48, 40},
    { -1344, 72, 72},
    { -1352, 128, 32},
    { -1224, -144, 96},
    { -1160, -504, 96},
    { -1144, -392, -176},
    { -1280, -96, -176},
    { -1480, 32, -160},
    { -1448, 56, -144},
    { -1504, -48, 24},
    { -1624, 120, 72},
    { -1656, 288, 192},
    { -1600, 440, 224},
    { -1400, 704, 40},
    { -1272, 472, -8},
    { -1400, 784, 0},
    { -1168, 624, 176},
    { -1152, 824, 200},
    // 59 seconds
    { -1080, 840, 304},
    { -904, 856, 144},
    { -1288, 976, 144},
    { -1656, 664, 240},
    { -1704, 704, 256},
    { -1560, 520, 312},
    { -1528, 328, 400},
    { -1488, 392, 256},
    { -1248, 376, 192},
    { -1072, 304, 264},
    { -1088, 472, 168},
    { -952, 616, 56},
    { -808, 640, 64},
    { -496, 872, -120},
    { -200, 1088, -320},
    { -152, 1080, -296},
    { -152, 920, -280},
    { -64, 696, -240},
    { 120, 480, -216},
    { 176, 440, -192},
    { 168, 280, -24},
    { 200, 232, -48},
    { 344, 200, 240},
    { 400, 912, 208},
    { 520, 1296, 424},
    // 60 seconds
    // elapsed: 1 minutes
    { 504, 1456, 240},
    { 368, 1568, 192},
    { 288, 1544, 64},
    { 216, 1360, -40},
    { 192, 1024, -192},
    { 104, 672, -248},
    { 64, 416, -264},
    { -8, 264, -216},
    { -64, 88, -120},
    { -200, 64, -96},
    { -328, 40, -56},
    { -624, -72, 80},
    { -1336, -48, 176},
    { -2048, 0, 232},
    { -2728, 352, 248},
    { -2072, 400, -384},
    { -1568, 184, -224},
    { -1632, 152, -64},
    { -1432, 120, -56},
    { -1080, 144, -40},
    { -840, 192, 64},
    { -792, 216, 16},
    { -792, 256, 0},
    { -776, 240, 72},
    { -1056, 272, 160},
    // 61 seconds
    { -1448, 480, 344},
    { -1224, 856, 8},
    { -1128, 8, -184},
    { -1104, 448, -72},
    { -1456, 568, 24},
    { -1648, 368, 80},
    { -1688, 176, 64},
    { -1504, 48, 136},
    { -1360, 0, 160},
    { -1272, 0, 136},
    { -1200, 8, 112},
    { -1128, 40, 104},
    { -1088, 64, 64},
    { -1144, -32, 104},
    { -864, -520, 80},
    { -1120, -288, -136},
    { -1272, 144, -184},
    { -1512, 272, -312},
    { -1592, 80, -56},
    { -1536, -192, 96},
    { -1424, 8, 40},
    { -1304, 208, 232},
    { -1216, 472, 200},
    { -1200, 424, 208},
    { -1216, 352, 88},
    // 62 seconds
    { -1264, 368, 136},
    { -1304, 392, 224},
    { -1064, 840, 208},
    { -1416, 768, 112},
    { -968, 688, 40},
    { -992, 584, -64},
    { -1536, 496, 176},
    { -1696, 384, 192},
    { -1520, 296, 160},
    { -1440, 264, 208},
    { -1408, 200, 232},
    { -1400, 176, 248},
    { -1376, 168, 248},
    { -1304, 160, 208},
    { -1336, 104, 216},
    { -1240, -264, 56},
    { -1168, -552, 176},
    { -1128, -80, -288},
    { -1416, 96, -224},
    { -1496, 112, -80},
    { -1448, -104, 128},
    { -1360, 8, 168},
    { -1256, 248, 256},
    { -1216, 360, 296},
    { -1304, 504, 176},
    // 63 seconds
    { -1280, 472, 96},
    { -1440, 520, 224},
    { -1528, 632, 328},
    { -1280, 912, 104},
    { -1328, 720, 56},
    { -768, 552, -208},
    { -1184, 576, -160},
    { -1376, 496, 16},
    { -1568, 440, 144},
    { -1464, 328, 200},
    { -1336, 288, 208},
    { -1344, 296, 272},
    { -1408, 424, 240},
    { -1424, 512, 320},
    { -1464, 736, 312},
    { -1288, 736, 304},
    { -1024, 736, 320},
    { -568, 792, 80},
    { -168, 896, 8},
    { -112, 816, 16},
    { -64, 808, 16},
    { 40, 608, -8},
    { 240, 440, -48},
    { 336, 232, 24},
    { 344, 280, -16},
    // 64 seconds
    { 320, 224, 88},
    { 352, 440, 120},
    { 344, 512, 448},
    { 88, 1296, 424},
    { 536, 992, 480},
    { 352, 1480, 616},
    { 344, 1408, 600},
    { 456, 1104, 488},
    { 256, 936, 552},
    { 176, 928, 320},
    { 232, 696, 144},
    { 256, 496, 88},
    { 312, 360, 40},
    { 256, 472, 112},
    { 208, 520, 176},
    { 184, 640, 224},
    { 168, 816, 280},
    { 160, 1096, 408},
    { 208, 1472, 376},
    { 280, 1688, 240},
    { 112, 1376, 128},
    { 32, 1016, 72},
    { 24, 696, 88},
    { 64, 544, 64},
    { 96, 400, 64},
    // 65 seconds
    { 128, 288, 144},
    { 160, 320, 160},
    { 240, 424, 208},
    { 352, 776, 280},
    { 384, 1128, 424},
    { 504, 1464, 552},
    { 344, 1616, 568},
    { 304, 1264, 336},
    { 232, 1008, 248},
    { 200, 880, 296},
    { 112, 808, 208},
    { 112, 680, 88},
    { 136, 512, 56},
    { 136, 496, 56},
    { 120, 528, 72},
    { 120, 632, 48},
    { 112, 768, 192},
    { 176, 920, 184},
    { 272, 1304, 112},
    { 272, 1472, 248},
    { 224, 1648, 8},
    { 136, 1320, -104},
    { 56, 872, 24},
    { 48, 616, -16},
    { 32, 504, -24},
    // 66 seconds
    { 72, 344, -48},
    { 136, 200, -40},
    { 176, 232, 8},
    { 264, 392, 80},
    { 240, 944, 288},
    { 288, 1216, 432},
    { 336, 1584, 496},
    { 336, 1632, 472},
    { 392, 1312, 336},
    { 320, 1144, 312},
    { 248, 1120, 296},
    { 152, 1016, 248},
    { 120, 760, 56},
    { 120, 464, -16},
    { 112, 360, -40},
    { 120, 320, -16},
    { 80, 464, 104},
    { 32, 712, 128},
    { -72, 720, 224},
    { -24, 1072, 152},
    { -40, 1392, 344},
    { 0, 1624, 240},
    { 24, 1576, -96},
    { -32, 1160, 56},
    { 8, 736, 104},
    // 67 seconds
    { 32, 584, 64},
    { 40, 504, 48},
    { 120, 328, 88},
    { 176, 368, 152},
    { 312, 504, 224},
    { 272, 1024, 488},
    { 240, 1272, 664},
    { 216, 1768, 832},
    { 96, 1672, 776},
    { 64, 1392, 456},
    { 16, 1088, 416},
    { -16, 984, 296},
    { -32, 784, 168},
    { -16, 544, 32},
    { -16, 456, -48},
    { 8, 368, -8},
    { 16, 376, 48},
    { -16, 608, 56},
    { 56, 776, 112},
    { 264, 704, 240},
    { 592, 1288, 248},
    { 536, 1936, 96},
    { 152, 1616, 152},
    { 96, 1040, 192},
    { 40, 720, 72},
    // 68 seconds
    { 72, 528, 0},
    { 104, 352, 72},
    { 176, 264, 40},
    { 240, 320, 80},
    { 344, 400, 144},
    { 384, 608, 368},
    { 480, 1112, 568},
    { 352, 1720, 352},
    { 344, 1536, 672},
    { 304, 1248, 368},
    { 296, 992, 344},
    { 264, 848, 424},
    { 160, 888, 320},
    { 136, 608, 216},
    { 160, 504, 120},
    { 248, 416, 80},
    { 248, 432, 144},
    { 216, 536, 160},
    { 232, 696, 320},
    { 208, 840, 312},
    { 320, 960, 312},
    { 312, 1160, 312},
    { 336, 1296, 328},
    { 248, 1368, 320},
    { 104, 1240, 232},
    // 69 seconds
    { 96, 920, 144},
    { 128, 632, 80},
    { 176, 416, 56},
    { 232, 304, 104},
    { 288, 288, 104},
    { 320, 328, 128},
    { 336, 400, 128},
    { 352, 528, 24},
    { 40, 1320, 488},
    { -64, 1648, 872},
    { -184, 1936, 856},
    { 48, 1360, 688},
    { 88, 1216, 456},
    { 64, 1184, 472},
    { 80, 768, 320},
    { 96, 576, 80},
    { 144, 352, 72},
    { 136, 320, 104},
    { 104, 400, 184},
    { 80, 616, 320},
    { 48, 936, 432},
    { 24, 1128, 448},
    { 168, 1240, 352},
    { 272, 1360, 256},
    { 296, 1336, 16},
    // 70 seconds
    { 88, 1264, -16},
    { 120, 896, 56},
    { 40, 656, 0},
    { 16, 496, -16},
    { 56, 328, 32},
    { 80, 344, -40},
    { 216, 288, -56},
    { 304, 424, 0},
    { 200, 840, 280},
    { 88, 1392, 656},
    { 176, 1800, 712},
    { 216, 1472, 624},
    { 296, 1280, 400},
    { 216, 1224, 456},
    { 112, 1224, 416},
    { 56, 1000, 200},
    { 104, 632, 48},
    { 88, 424, -32},
    { 104, 344, -32},
    { 96, 320, 16},
    { 80, 424, 96},
    { 24, 672, 200},
    { -24, 792, 248},
    { -144, 1184, 392},
    { -40, 1472, 472},
    // 71 seconds
    { -16, 1720, 240},
    { -48, 1416, 136},
    { 0, 968, 144},
    { -8, 696, 152},
    { -16, 568, 168},
    { -16, 456, 184},
    { 24, 328, 248},
    { 72, 360, 264},
    { 104, 552, 368},
    { 64, 968, 648},
    { 32, 1224, 776},
    { 104, 1488, 840},
    { 88, 1416, 808},
    { 96, 1280, 560},
    { 24, 1096, 600},
    { -112, 1184, 520},
    { -184, 992, 392},
    { -144, 704, 208},
    { -112, 496, 72},
    { -96, 400, 72},
    { -96, 392, 88},
    { -152, 528, 128},
    { -296, 784, 232},
    { -344, 904, 264},
    { -192, 1168, 184},
    // 72 seconds
    { -104, 1280, 240},
    { -32, 1504, 104},
    { 8, 1480, 0},
    { -32, 1112, 80},
    { 8, 776, 128},
    { 24, 576, 136},
    { 8, 440, 168},
    { 40, 368, 232},
    { 112, 384, 272},
    { 168, 496, 360},
    { 160, 912, 584},
    { 192, 1096, 760},
    { 240, 1456, 880},
    { 248, 1440, 920},
    { 168, 1344, 696},
    { 56, 1176, 688},
    { -104, 1136, 568},
    { -152, 920, 400},
    { -120, 648, 248},
    { -80, 504, 152},
    { -24, 400, 152},
    { 8, 352, 176},
    { 48, 400, 128},
    { 104, 632, 136},
    { 176, 720, 136},
    // 73 seconds
    { 344, 1144, 104},
    { 368, 1408, 184},
    { 224, 1848, 112},
    { 112, 1440, 144},
    { 96, 848, 144},
    { 56, 616, 48},
    { 88, 392, 96},
    { 112, 320, 80},
    { 160, 288, 88},
    { 168, 320, 64},
    { 216, 368, 48},
    { 88, 792, 184},
    { 144, 1000, 560},
    { 144, 1896, 512},
    { 64, 1920, 536},
    { 192, 1416, 240},
    { 192, 1144, 152},
    { 120, 1048, 256},
    { -32, 1104, 176},
    { 8, 760, 160},
    { 48, 528, 40},
    { 80, 336, 0},
    { 56, 328, 72},
    { 64, 360, 120},
    { 24, 696, 288},
    // 74 seconds
    { -72, 1120, 424},
    { -80, 1344, 600},
    { 16, 1456, 464},
    { 176, 1496, 216},
    { 96, 1312, 64},
    { 8, 1072, 88},
    { -8, 792, 192},
    { -24, 592, 152},
    { 8, 440, 144},
    { 56, 328, 72},
    { 96, 288, 216},
    { 152, 376, 136},
    { 232, 136, 216},
    { 112, 1024, 496},
    { 104, 1400, 576},
    { 136, 1752, 800},
    { 128, 1568, 632},
    { 256, 1200, 408},
    { 168, 1128, 360},
    { 112, 984, 360},
    { 16, 840, 280},
    { 24, 656, 136},
    { 56, 376, 80},
    { 48, 368, 104},
    { 40, 488, 136},
    // 75 seconds
    { 24, 664, 272},
    { -16, 968, 408},
    { 0, 1048, 448},
    { 56, 1472, 416},
    { 328, 1304, 248},
    { 344, 1456, -32},
    { 144, 1128, -80},
    { 128, 784, 48},
    { 88, 552, 24},
    { 72, 416, 8},
    { 72, 304, 56},
    { 104, 240, 112},
    { 192, 264, 256},
    { 216, 536, 320},
    { 256, 1016, 536},
    { 192, 1368, 696},
    { 352, 1760, 728},
    { 312, 1536, 560},
    { 352, 1200, 440},
    { 248, 1048, 384},
    { 144, 1056, 408},
    { 8, 952, 344},
    { -16, 704, 144},
    { 8, 448, 64},
    { 16, 352, -8},
    // 76 seconds
    { 16, 344, 56},
    { 0, 464, 96},
    { -8, 744, 208},
    { 40, 896, 264},
    { 176, 1128, 304},
    { 248, 1504, 320},
    { 336, 1672, 280},
    { 184, 1432, 104},
    { 144, 1024, 88},
    { 88, 704, 80},
    { 112, 488, 80},
    { 176, 336, 104},
    { 256, 280, 168},
    { 320, 336, 200},
    { 400, 448, 272},
    { 416, 800, 400},
    { 376, 1056, 536},
    { 424, 1368, 632},
    { 248, 1384, 624},
    { 256, 1256, 440},
    { 184, 1016, 416},
    { 104, 1016, 360},
    { 72, 792, 208},
    { 112, 568, 80},
    { 136, 456, 64},
    // 77 seconds
    { 160, 392, 128},
    { 152, 464, 208},
    { 144, 600, 336},
    { 136, 848, 448},
    { 192, 872, 400},
    { 288, 1160, 384},
    { 304, 1440, 432},
    { 232, 1504, 312},
    { 136, 1248, 104},
    { 96, 856, 152},
    { 96, 536, 144},
    { 128, 440, 144},
    { 176, 336, 160},
    { 232, 328, 184},
    { 264, 432, 208},
    { 280, 664, 200},
    { 304, 920, 328},
    { 296, 1128, 424},
    { 432, 1296, 544},
    { 304, 1392, 672},
    { 272, 1168, 552},
    { 248, 984, 448},
    { 216, 912, 408},
    { 120, 816, 344},
    { 128, 632, 192},
    // 78 seconds
    { 160, 480, 112},
    { 184, 416, 128},
    { 192, 512, 128},
    { 176, 640, 216},
    { 160, 864, 376},
    { 184, 928, 384},
    { 288, 1168, 376},
    { 344, 1168, 464},
    { 280, 1424, 280},
    { 32, 1304, 264},
    { 64, 872, 264},
    { 24, 664, 216},
    { 32, 544, 112},
    { 128, 376, 128},
    { 168, 400, 104},
    { 256, 424, 152},
    { 312, 560, 184},
    { 400, 704, 304},
    { 376, 1088, 480},
    { 472, 1248, 656},
    { 296, 1440, 672},
    { 272, 1208, 488},
    { 256, 1056, 432},
    { 184, 1048, 456},
    { 72, 960, 408},
    // 79 seconds
    { 104, 672, 200},
    { 160, 456, 56},
    { 240, 344, 24},
    { 304, 392, 40},
    { 312, 536, 160},
    { 296, 840, 336},
    { 280, 944, 432},
    { 376, 1120, 472},
    { 336, 1208, 424},
    { 272, 1240, 432},
    { 168, 1120, 512},
    { 120, 944, 312},
    { 184, 608, 176},
    { 248, 376, 80},
    { 312, 344, 72},
    { 344, 232, 72},
    { 392, 232, 120},
    { 384, 360, 224},
    { 344, 1048, 800},
    { 384, 944, 728},
    { 520, 1328, 616},
    { 440, 1512, 576},
    { 376, 1320, 440},
    { 376, 848, 472},
    { 328, 696, 464},
    // 80 seconds
    { 240, 592, 432},
    { 144, 536, 352},
    { 144, 480, 248},
    { 232, 328, 176},
    { 192, 456, 192},
    { 192, 576, 184},
    { 216, 704, 312},
    { 144, 976, 392},
    { 176, 1136, 352},
    { 136, 1256, 376},
    { -72, 1448, 352},
    { -224, 1352, 264},
    { -240, 968, 112},
    { -200, 688, 32},
    { -184, 520, 0},
    { -120, 472, 8},
    { -48, 360, 136},
    { 8, 464, 216},
    { -40, 808, 368},
    { 8, 1000, 480},
    { -8, 1256, 560},
    { -16, 1336, 600},
    { 112, 1600, 640},
    { -56, 1528, 616},
    { -88, 1360, 496},
    // 81 seconds
    { -136, 1184, 416},
    { -248, 1112, 320},
    { -272, 856, 168},
    { -224, 544, -16},
    { -176, 352, 0},
    { -168, 336, 0},
    { -192, 304, -72},
    { -288, 352, -40},
    { -456, 544, 64},
    { -640, 688, 48},
    { -816, 1176, 56},
    { -824, 1712, -112},
    { -680, 1504, -208},
    { -512, 1192, -216},
    { -456, 928, -128},
    { -336, 808, -24},
    { -280, 648, 56},
    { -240, 568, 112},
    { -200, 544, 144},
    { -192, 592, 192},
    { -192, 824, 248},
    { -296, 1208, 360},
    { -352, 1304, 416},
    { -400, 1592, 448},
    { -488, 1552, 472},
    // 82 seconds
    { -520, 1336, 400},
    { -568, 1288, 384},
    { -680, 1200, 272},
    { -608, 872, 176},
    { -488, 584, 88},
    { -424, 448, 16},
    { -376, 376, -8},
    { -360, 280, 32},
    { -352, 168, 32},
    { -392, 88, -16},
    { -520, 168, -160},
    { -840, 152, -288},
    { -1320, 16, -320},
    { -2096, -128, -248},
    { -2760, 72, -48},
    { -2528, 104, -24},
    { -1624, 328, -48},
    { -1128, 392, -64},
    { -1168, 160, 80},
    { -1136, 88, 48},
    { -1040, 120, 72},
    { -976, 168, 120},
    { -1016, 240, 200},
    { -1328, 224, 432},
    { -1080, 616, 552},
    // 83 seconds
    { -1152, 448, 248},
    { -944, 696, 8},
    { -1176, 552, 168},
    { -1704, 352, 328},
    { -2032, 296, 120},
    { -1872, 112, 272},
    { -1712, -160, 152},
    { -1616, 40, 112},
    { -1488, 32, 136},
    { -1288, 40, 104},
    { -1064, 24, 88},
    { -1000, -56, 48},
    { -712, -632, 192},
    { -1120, -920, 400},
    { -1000, -368, -360},
    { -1800, 496, -24},
    { -1880, 432, 24},
    { -1840, 88, 296},
    { -1856, 184, 168},
    { -1632, 224, 248},
    { -1384, 328, 208},
    { -1264, 312, 168},
    { -1288, 280, 216},
    { -1216, 336, 376},
    { -1024, 280, 368},
    // 84 seconds
    { -1056, 408, 400},
    { -976, 472, 448},
    { -1064, 624, 376},
    { -1032, 760, 328},
    { -1000, 688, -8},
    { -1184, 400, -32},
    { -1808, 536, 48},
    { -2192, 272, 88},
    { -2160, 304, 64},
    { -1648, -40, 160},
    { -1736, 40, 168},
    { -1568, 112, 112},
    { -1312, 96, 240},
    { -1000, 40, 128},
    { -912, 88, 168},
    { -784, -120, 104},
    { -688, -592, -16},
    { -368, -584, -384},
    { -1112, 88, -360},
    { -1624, 360, -552},
    { -2008, -176, -416},
    { -2136, 80, -248},
    { -1880, 400, -40},
    { -1456, 296, -240},
    { -1592, 376, -288},
    // 85 seconds
    { -1624, 296, 144},
    { -1424, 320, 248},
    { -1200, 224, 256},
    { -1232, 336, 376},
    { -1032, 472, 600},
    { -976, 480, 552},
    { -912, 296, 560},
    { -856, 408, 304},
    { -1128, 464, 352},
    { -1616, 440, 464},
    { -1904, 336, 408},
    { -1952, 336, 472},
    { -1904, 440, 408},
    { -1920, 384, 560},
    { -1776, 104, 440},
    { -1464, 80, 184},
    { -1256, 16, 184},
    { -1072, 96, 48},
    { -816, 424, -192},
    { -992, 992, -264},
    { -408, 760, -168},
    { -80, 1152, -544},
    { 32, 784, -328},
    { 40, 736, -320},
    { 88, 624, -224},
    // 86 seconds
    { 224, 520, -144},
    { 344, 400, -48},
    { 360, 424, -16},
    { 424, 336, 88},
    { 496, 376, 184},
    { 560, 448, 384},
    { 488, 928, 192},
    { 520, 768, 528},
    { 760, 1592, 320},
    { 528, 1336, 440},
    { 432, 1376, 184},
    { 392, 1008, 160},
    { 280, 824, 64},
    { 208, 576, -56},
    { 176, 336, -64},
    { 152, 224, -80},
    { 144, 184, -88},
    { 80, 168, -88},
    { -24, 144, -48},
    { -216, 152, 0},
    { -784, 336, -24},
    { -1960, 976, -16},
    { -2072, 632, 72},
    { -2568, 704, -200},
    { -2288, 576, 64},
    // 87 seconds
    { -1304, 488, -208},
    { -1104, -64, -80},
    { -1200, 224, 128},
    { -920, 184, 16},
    { -776, 192, 0},
    { -792, 192, 40},
    { -744, 240, 16},
    { -928, 272, 48},
    { -1416, 384, 120},
    { -1208, 656, 8},
    { -1360, 192, -224},
    { -1112, 400, -176},
    { -1416, 528, -136},
    { -1688, 280, -72},
    { -1872, 144, 8},
    { -1624, 40, 72},
    { -1376, -48, 64},
    { -1304, 112, -40},
    { -1384, 232, 48},
    { -1200, 264, -168},
    { -1288, 352, -120},
    { -1024, 384, -200},
    { -624, 296, -544},
    { -552, 272, -688},
    { -368, 224, -968},
    // 88 seconds
    { -320, 72, -1016},
    { -392, -56, -912},
    { -248, -200, -760},
    { -56, -312, -664},
    { 48, -256, -648},
    { 160, -304, -608},
    { 136, -264, -632},
    { 176, -240, -664},
    { 184, -256, -752},
    { 200, -248, -864},
    { 152, -256, -1016},
    { 136, -272, -1096},
    { 208, -232, -1296},
    { 200, -112, -1352},
    { 176, -200, -1200},
    { 104, -72, -1184},
    { 24, -48, -1072},
    { -32, -96, -992},
    { -56, -200, -840},
    { 16, -272, -688},
    { 72, -296, -600},
    { 64, -296, -504},
    { 64, -320, -424},
    { 32, -304, -352},
    { -32, -264, -336},
    // 89 seconds
    { -320, -240, -320},
    { -816, -200, -288},
    { -1912, -128, -152},
    { -2784, -16, 64},
    { -2632, 992, 224},
    { -2008, 912, -232},
    { -1576, 664, -72},
    { -1240, 560, 80},
    { -1128, 384, 0},
    { -1160, 400, 104},
    { -1176, 376, 160},
    { -904, 392, 224},
    { -896, 576, 136},
    { -904, 608, 208},
    { -1208, 696, 208},
    { -1368, 648, 56},
    { -1016, 568, -64},
    { -1440, 584, -224},
    { -1680, 512, -72},
    { -1912, 424, 104},
    { -1728, 224, 192},
    { -1576, 328, 208},
    { -1504, 368, 144},
    { -1400, 360, 280},
    { -1264, 480, 240},
    // 90 seconds
    { -1056, 360, 160},
    { -920, 104, 224},
    { -720, 0, -224},
    { -368, -472, -416},
    { -696, -88, -264},
    { -1200, 560, -440},
    { -1408, 560, -368},
    { -1664, 384, -192},
    { -1808, 88, -32},
    { -2000, 472, 56},
    { -1632, 312, 360},
    { -1552, 920, 152},
    { -1376, 432, 136},
    { -1240, 440, 176},
    { -1056, 416, 176},
    { -1096, 752, 176},
    { -888, 760, 256},
    { -1272, 720, 328},
    { -872, 672, 184},
    { -1232, 752, -24},
    { -1680, 728, 72},
    { -2024, 800, 104},
    { -1848, 824, 112},
    { -1552, 592, 208},
    { -1144, 416, 312},
    // 91 seconds
    { -880, 392, 208},
    { -680, 376, 136},
    { -520, 344, 144},
    { -392, 392, 120},
    { -272, 608, 24},
    { -112, 640, 88},
    { 8, 864, -40},
    { 96, 1136, -112},
    { 16, 1064, -16},
    { -40, 1016, -8},
    { -88, 984, -24},
    { -8, 736, 16},
    { 80, 592, -8},
    { 112, 496, -64},
    { 88, 408, 16},
    { 80, 392, 80},
    { 32, 576, 232},
    { -48, 1096, 264},
    { 16, 1280, 432},
    { 64, 1384, 608},
    { -56, 1992, 648},
    { -184, 1768, 520},
    { -160, 1408, 296},
    { -152, 1168, 168},
    { -280, 936, 192},
    // 92 seconds
    { -304, 760, 104},
    { -280, 584, 8},
    { -224, 312, -16},
    { -192, 192, -56},
    { -200, 152, -56},
    { -248, 96, -48},
    { -416, 96, -64},
    { -768, 200, -80},
    { -1504, 472, -80},
    { -1944, 400, 88},
    { -2688, 616, -240},
    { -2280, 416, 40},
    { -1416, 488, -112},
    { -840, 120, -344},
    { -1456, 400, 240},
    { -1064, 16, 192},
    { -936, 168, 56},
    { -792, 48, 56},
    { -744, 232, 0},
    { -872, 216, -16},
    { -1368, 288, -72},
    { -1392, 384, 24},
    { -1232, 736, -120},
    { -1032, 376, -200},
    { -1096, 424, -56},
    // 93 seconds
    { -1696, 368, 112},
    { -1816, 136, 168},
    { -1664, 72, 136},
    { -1480, -16, 168},
    { -1352, -80, 168},
    { -1240, -64, 120},
    { -1128, -24, 88},
    { -1056, 24, 72},
    { -1104, -160, 48},
    { -816, -616, -8},
    { -1120, -216, -192},
    { -1248, -40, -200},
    { -1464, 136, -336},
    { -1592, 144, -240},
    { -1568, -200, -40},
    { -1416, -128, -152},
    { -1304, 80, -56},
    { -1256, 224, 32},
    { -1248, 264, 56},
    { -1248, 288, 40},
    { -1200, 304, 48},
    { -1216, 288, 160},
    { -1296, 648, 320},
    { -1008, 296, -24},
    { -1256, 344, 64},
    // 94 seconds
    { -1000, 448, 72},
    { -1240, 408, 80},
    { -1504, 320, 200},
    { -1800, 208, 184},
    { -1656, 88, 144},
    { -1544, 64, 168},
    { -1472, 24, 184},
    { -1424, 16, 160},
    { -1312, 24, 144},
    { -1152, 152, -40},
    { -1352, -176, 56},
    { -912, -1056, -104},
    { -1088, -352, -280},
    { -1360, -128, -168},
    { -1592, 40, -96},
    { -1648, -24, 96},
    { -1504, -216, 208},
    { -1424, -120, 200},
    { -1360, 80, 168},
    { -1296, 200, 296},
    { -1304, 264, 256},
    { -1312, 312, 112},
    { -1216, 288, 112},
    { -1416, 368, 224},
    { -1312, 904, 384},
    // 95 seconds
    { -1264, 232, 208},
    { -1144, 824, 280},
    { -1040, 936, 48},
    { -1384, 856, 32},
    { -1688, 536, 128},
    { -2048, 408, 272},
    { -2112, 232, 296},
    { -2096, 184, 376},
    { -1880, 160, 344},
    { -1536, 160, 240},
    { -1144, 104, 224},
    { -888, 80, 240},
    { -656, -128, 176},
    { -440, -512, -176},
    { -408, -256, -176},
    { -872, 160, -280},
    { -1160, 640, -504},
    { -1272, 656, -688},
    { -1632, 528, -288},
    { -1616, 40, 48},
    { -1368, 168, 0},
    { -1232, 160, 8},
    { -1328, 272, 136},
    { -1488, 88, 184},
    { -1616, 192, 480},
    // 96 seconds
    { -1400, 392, 88},
    { -1488, 624, 72},
    { -1400, 712, 288},
    { -912, 1008, 152},
    { -1232, 1048, -32},
    { -960, 976, -192},
    { -968, 416, -328},
    { -1464, 232, -360},
    { -1864, 288, -400},
    { -1880, 216, -440},
    { -1744, 304, -176},
    { -1592, 264, 0},
    { -1408, 288, 48},
    { -1408, 560, 104},
    { -1400, 304, 336},
    { -1232, 496, 224},
    { -832, 464, 48},
    { -464, 80, -24},
    { -128, 64, -112},
    { -216, 536, -288},
    { -168, 736, -304},
    { -440, 1056, -160},
    { -408, 1120, -232},
    { -288, 736, -112},
    { -200, 640, -88},
    // 97 seconds
    { -120, 680, -128},
    { -128, 584, -96},
    { -184, 592, -128},
    { -152, 328, 8},
    { -432, 680, -72},
    { -536, 792, -112},
    { -776, 384, 40},
    { -3064, 176, 160},
    { -2504, 1232, -16},
    { -1040, 1616, -96},
    { -1032, 24, -704},
    { -1288, 864, -248},
    { -888, 216, -168},
    { -712, 128, -168},
    { -688, 152, -152},
    { -776, 144, -72},
    { -856, 104, -16},
    { -1112, 0, -80},
    { -1528, -40, -104},
    { -1520, 0, -32},
    { -1328, 72, -168},
    { -1064, 248, -352},
    { -800, 288, -336},
    { -800, 216, -208},
    { -1016, 56, 24},
    // 98 seconds
    { -1080, 40, -32},
    { -1016, 136, 24},
    { -912, 120, 120},
    { -888, 168, 72},
    { -896, 200, -16},
    { -888, 232, -120},
    { -880, 280, -216},
    { -1336, 384, -104},
    { -1336, 664, -80},
    { -1728, 368, -184},
    { -1176, 168, -224},
    { -1064, 296, -224},
    { -1368, 360, 0},
    { -1504, 176, 120},
    { -1328, 24, 104},
    { -1080, -96, 80},
    { -984, -72, 72},
    { -960, -8, 80},
    { -904, 24, 64},
    { -864, 64, 40},
    { -1064, 0, 104},
    { -1072, -288, 48},
    { -1152, -264, 16},
    { -1304, 24, -160},
    { -1272, 264, -424},
    // 99 seconds
    { -1328, 272, -416},
    { -1440, -24, -168},
    { -1392, -256, -288},
    { -1264, -8, -240},
    { -1064, 104, -112},
    { -1008, 200, -104},
    { -1000, 208, -80},
    { -920, 176, -72},
    { -824, 328, -136},
    { -880, 328, -152},
    { -1288, 448, -56},
    { -1240, 440, -144},
    { -1560, 160, -56},
    { -1208, 136, -96},
    { -1208, 224, -88},
    { -1584, 208, 104},
    { -1664, 160, 72},
    { -1472, -32, 152},
    { -1240, -24, 128},
    { -1112, -48, 128},
    { -1048, -32, 112},
    { -976, 16, 104},
    { -912, 32, 80},
    { -1016, 8, 112},
    { -984, -224, 136},
    // 100 seconds
    { -800, -336, -56},
    { -1256, 120, -152},
    { -1256, 192, -312},
    { -1368, 144, -280},
    { -1432, -48, -288},
    { -1576, -272, -168},
    { -1496, -56, -48},
    { -1344, 176, 40},
    { -1240, 288, 48},
    { -1200, 232, 104},
    { -1096, 200, 120},
    { -856, 232, 48},
    { -752, 344, -64},
    { -976, 408, 40},
    { -1048, 432, 24},
    { -1584, 504, 24},
    { -1136, 232, -112},
    { -1432, 392, -64},
    { -1720, 240, -88},
    { -1864, 192, -32},
    { -1736, 144, 56},
    { -1544, -16, 88},
    { -1504, 48, 48},
    { -1312, 80, 64},
    { -1064, 24, 72},
    // 101 seconds
    { -896, 40, 112},
    { -848, -8, 144},
    { -768, -40, 128},
    { -464, -304, 96},
    { -1072, -112, -72},
    { -1072, 432, -240},
    { -1240, 48, -104},
    { -1704, 56, -344},
    { -1968, 216, -392},
    { -1864, 72, -8},
    { -1696, 672, -24},
    { -1288, 456, -32},
    { -1336, 392, 40},
    { -1304, 296, 104},
    { -1088, 296, 120},
    { -1000, 320, 160},
    { -976, 448, 216},
    { -888, 496, 240},
    { -776, 352, 112},
    { -808, 376, -16},
    { -1032, 536, 288},
    { -1280, 656, 192},
    { -1368, 480, 104},
    { -1680, 256, 112},
    { -2080, 248, 80},
    // 102 seconds
    { -2104, 160, -872},
    { -1816, 528, 0},
    { -1480, 24, 88},
    { -1288, 48, 64},
    { -1136, 32, 64},
    { -992, 64, 72},
    { -808, 8, 56},
    { -608, -200, 24},
    { -416, -344, -8},
    { -624, -104, -56},
    { -864, 56, -176},
    { -1232, 296, -328},
    { -1440, 288, -368},
    { -2280, 128, -56},
    { -2256, 56, 736},
    { -1072, 1168, -368},
    { -1496, 712, -184},
    { -1056, 320, 16},
    { -928, 152, 224},
    { -904, 216, 160},
    { -920, 216, 184},
    { -944, 288, 232},
    { -1120, 312, 216},
    { -1112, 208, 152},
    { -1584, 368, 96},
    // 103 seconds
    { -1192, 376, 8},
    { -1144, 416, -184},
    { -1440, 400, -112},
    { -1672, 288, -48},
    { -1608, 248, -88},
    { -1344, -96, 16},
    { -1320, -80, 48},
    { -1200, -16, 16},
    { -1000, 24, 0},
    { -856, 48, 0},
    { -888, -8, 32},
    { -808, -264, 40},
    { -712, -128, -72},
    { -1232, 80, -104},
    { -1360, 144, -216},
    { -1392, 240, -352},
    { -1664, -8, -168},
    { -1592, -128, 32},
    { -1408, -32, -72},
    { -1296, 152, 64},
    { -1208, 216, 136},
    { -1200, 200, 152},
    { -1200, 184, 192},
    { -1056, 208, 144},
    { -816, 336, 64},
    // 104 seconds
    { -1056, 416, 24},
    { -1016, 568, 176},
    { -1456, 432, -32},
    { -1024, 104, -216},
    { -968, 352, -248},
    { -1408, 496, -184},
    { -1728, 368, -88},
    { -1768, 152, 8},
    { -1648, -24, 128},
    { -1440, -144, 104},
    { -1312, -64, 40},
    { -1216, 16, 32},
    { -1144, 48, 24},
    { -1240, 32, 40},
    { -1112, -296, 72},
    { -864, -448, 16},
    { -960, -224, -104},
    { -1104, 88, -224},
    { -1160, 176, -336},
    { -1392, 120, -200},
    { -1496, -224, -64},
    { -1560, -72, 32},
    { -1456, 200, 88},
    { -1360, 400, 32},
    { -1320, 448, -80},
    // 105 seconds
    { -1272, 280, -8},
    { -1152, 248, -40},
    { -1168, 272, -16},
    { -1272, 256, 32},
    { -1152, 432, 32},
    { -1176, 432, -8},
    { -1232, 576, -48},
    { -1120, 536, -160},
    { -1192, 344, -64},
    { -1520, 208, 48},
    { -1712, 80, 96},
    { -1608, 16, 72},
    { -1360, 16, 64},
    { -1264, 8, 72},
    { -1136, -16, 40},
    { -1016, 24, 64},
    { -976, 64, 128},
    { -1040, 80, 48},
    { -936, -64, 8},
    { -1040, -192, -24},
    { -1312, 0, -280},
    { -1400, 232, -312},
    { -1448, 152, -216},
    { -1424, -208, -40},
    { -1472, -192, 56},
    // 106 seconds
    { -1360, 160, 64},
    { -1216, 312, 104},
    { -1176, 368, 32},
    { -1168, 232, -64},
    { -1112, 208, -32},
    { -1088, 248, 32},
    { -1144, 696, -136},
    { -952, 512, 40},
    { -1104, 408, -192},
    { -1352, 616, -40},
    { -1176, 424, -160},
    { -1584, 392, -208},
    { -2032, 440, -72},
    { -2232, 520, 96},
    { -2264, 848, -56},
    { -1864, 640, 224},
    { -1208, 288, 256},
    { -792, 184, 144},
    { -544, 232, 24},
    { -360, 152, 48},
    { -152, 192, 88},
    { 16, 344, 56},
    { 176, 648, 40},
    { 224, 720, 88},
    { 384, 976, -24},
    // 107 seconds
    { 232, 1080, 80},
    { 264, 720, 24},
    { 8, 1128, 16},
    { 48, 968, 136},
    { 96, 912, 152},
    { 216, 744, 128},
    { 280, 680, 112},
    { 280, 744, 144},
    { 248, 792, 144},
    { 208, 824, 152},
    { 144, 832, 120},
    { 160, 792, 88},
    { 200, 752, 0},
    { 216, 760, 24},
    { 136, 888, 200},
    { -152, 1272, 432},
    { -72, 1232, 424},
    { -48, 912, 336},
    { -40, 920, 328},
    { -72, 936, 256},
    { -72, 896, 208},
    { -56, 840, 168},
    { -64, 824, 160},
    { -72, 816, 192},
    { -104, 840, 272},
    // 108 seconds
    { -200, 928, 352},
    { -240, 960, 352},
    { -256, 936, 384},
    { -192, 816, 376},
    { -160, 816, 336},
    { -128, 744, 344},
    { -56, 696, 272},
    { -48, 784, 200},
    { -48, 816, 312},
    { -136, 904, 360},
    { -160, 1016, 416},
    { -176, 960, 456},
    { -184, 912, 456},
    { -168, 904, 352},
    { -144, 808, 344},
    { -168, 816, 336},
    { -208, 888, 344},
    { -256, 928, 336},
    { -240, 888, 296},
    { -232, 888, 216},
    { -192, 856, 184},
    { -160, 824, 184},
    { -120, 864, 200},
    { -104, 888, 224},
    { -104, 912, 232},
    // 109 seconds
    { -112, 912, 200},
    { -144, 920, 176},
    { -168, 896, 128},
    { -184, 920, 96},
    { -216, 936, 72},
    { -224, 864, 64},
    { -216, 816, 104},
    { -128, 728, -16},
    { -128, 752, 184},
    { -56, 1032, 296},
    { -56, 968, 608},
    { 56, 968, 624},
    { 104, 1000, 752},
    { 96, 816, 872},
    { 104, 712, 784},
    { 152, 672, 600},
    { 136, 648, 560},
    { 152, 592, 528},
    { 144, 584, 488},
    { 144, 640, 464},
    { 144, 648, 512},
    { 120, 696, 552},
    { 56, 792, 608},
    { 56, 816, 616},
    { 64, 800, 528},
    // 110 seconds
    { 72, 792, 480},
    { 120, 768, 472},
    { -8, 1016, 448},
    { 152, 832, 288},
    { 120, 800, 304},
    { 80, 848, 384},
    { -16, 864, 472},
    { -16, 856, 400},
    { -32, 768, 368},
    { -56, 728, 312},
    { -40, 760, 296},
    { 0, 840, 360},
    { 48, 888, 408},
    { 40, 944, 464},
    { 72, 800, 464},
    { 120, 808, 376},
    { 104, 848, 432},
    { 112, 840, 392},
    { 88, 840, 400},
    { 80, 808, 384},
    { 80, 824, 344},
    { 88, 808, 336},
    { 112, 952, 320},
    { 176, 1024, 264},
    { 184, 984, 232},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:59:18 local
AccelRawData *activity_sample_walk_200_pbl_25480_12(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25480_12
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -184, -120, -960},
    { -112, -152, -1008},
    { -152, -176, -952},
    { -152, -200, -944},
    { -192, -120, -992},
    { -216, -184, -984},
    { -216, -200, -1016},
    { -224, -192, -1008},
    { -192, -208, -984},
    { -200, -216, -968},
    { -200, -200, -984},
    { -176, -128, -952},
    { -224, -192, -1032},
    { -264, -232, -944},
    { -216, -200, -1080},
    { -240, -344, -1000},
    { -232, -200, -952},
    { -336, -232, -864},
    { -120, -144, -976},
    { -112, -200, -984},
    { -104, -240, -968},
    { -112, -200, -992},
    { -112, -144, -976},
    { -120, -208, -960},
    { -56, -32, -984},
    // 1 seconds
    { -40, -40, -984},
    { 8, -40, -1016},
    { 0, -72, -1016},
    { 56, 40, -992},
    { 72, 128, -968},
    { 112, 264, -928},
    { 112, 368, -840},
    { 184, 528, -872},
    { 160, 512, -784},
    { 200, 520, -848},
    { 176, 432, -840},
    { 128, 392, -816},
    { 144, 360, -824},
    { 120, 264, -816},
    { 120, 360, -864},
    { 136, 312, -880},
    { 80, 280, -864},
    { 192, 376, -824},
    { 200, 264, -776},
    { 200, 168, -880},
    { 144, -48, -1000},
    { 64, -224, -928},
    { -8, -160, -968},
    { -32, -16, -1016},
    { -96, -144, -944},
    // 2 seconds
    { -144, 24, -1016},
    { -112, 96, -992},
    { -80, 112, -880},
    { -96, 152, -1008},
    { -72, 160, -1080},
    { -88, 96, -1064},
    { -104, -56, -1104},
    { -168, -8, -1072},
    { -176, 8, -1040},
    { -200, -32, -1016},
    { -240, -72, -984},
    { -264, -72, -920},
    { -200, 232, -936},
    { -208, -24, -856},
    { -176, 320, -800},
    { -152, 360, -680},
    { -24, 768, -664},
    { 64, 840, -688},
    { 120, 736, -496},
    { 272, 864, -392},
    { 280, 784, -176},
    { 344, 1000, -64},
    { 336, 1120, -120},
    { 416, 880, -232},
    { 464, 880, -360},
    // 3 seconds
    { 432, 688, -424},
    { 400, 424, -528},
    { 320, 400, -664},
    { 264, 440, -784},
    { 232, 360, -800},
    { 208, 96, -816},
    { 256, 200, -912},
    { 160, -128, -744},
    { 184, -72, -776},
    { 104, -152, -760},
    { 40, -64, -784},
    { 16, -64, -720},
    { -168, 8, -672},
    { -856, 248, -784},
    { -1200, 320, -456},
    { -1200, -8, -448},
    { -1584, -16, -48},
    { -1696, 424, 240},
    { -1544, 832, -80},
    { -1168, 752, -160},
    { -1048, 568, -160},
    { -1008, 432, -88},
    { -1008, 376, -104},
    { -984, 360, -112},
    { -1000, 456, -240},
    // 4 seconds
    { -1232, 384, -184},
    { -1264, 384, -312},
    { -1488, 472, -472},
    { -1080, 504, -608},
    { -696, 504, -736},
    { -920, 352, -576},
    { -1200, 248, -440},
    { -1280, 160, -312},
    { -1224, 192, -280},
    { -1168, 176, -240},
    { -1056, 200, -224},
    { -920, 176, -208},
    { -824, 192, -216},
    { -856, 176, -192},
    { -1008, 216, -232},
    { -928, -64, -192},
    { -1120, -104, -264},
    { -1208, 144, -512},
    { -1112, 56, -528},
    { -1216, 72, -456},
    { -1400, 88, -280},
    { -1360, 136, -160},
    { -1112, 200, -176},
    { -952, 256, -136},
    { -888, 280, -64},
    // 5 seconds
    { -848, 232, -144},
    { -776, 248, -264},
    { -720, 216, -400},
    { -1080, 288, -512},
    { -1272, 312, -400},
    { -1504, 784, -680},
    { -1112, 280, -616},
    { -1000, 288, -504},
    { -1440, 432, -376},
    { -1696, 304, -152},
    { -1576, 232, -64},
    { -1280, 184, -24},
    { -1112, 96, -8},
    { -1040, 128, -16},
    { -912, 104, -32},
    { -880, 136, -80},
    { -1144, 312, -72},
    { -1072, -416, 168},
    { -872, -288, -112},
    { -1168, 48, -256},
    { -1240, 32, -456},
    { -1400, -64, -560},
    { -1416, -80, -408},
    { -1480, 168, -280},
    { -1344, 272, -272},
    // 6 seconds
    { -1192, 288, -104},
    { -1064, 368, -144},
    { -1104, 368, -80},
    { -1032, 368, -168},
    { -1008, 320, -176},
    { -1144, 392, -176},
    { -1056, 640, -240},
    { -1328, 712, -248},
    { -1040, 272, -304},
    { -1080, 320, -368},
    { -1360, 504, -312},
    { -1688, 544, -216},
    { -1712, 312, -96},
    { -1432, 56, -64},
    { -1288, -8, -56},
    { -1248, 136, -64},
    { -1144, 136, -72},
    { -1064, 208, -64},
    { -1144, 200, -32},
    { -1112, -80, 120},
    { -928, -256, -40},
    { -968, -16, -232},
    { -1104, 80, -344},
    { -1304, 32, -456},
    { -1480, -112, -352},
    // 7 seconds
    { -1576, 56, -296},
    { -1400, 224, -232},
    { -1288, 352, -248},
    { -1160, 368, -128},
    { -1152, 424, -184},
    { -1088, 376, -96},
    { -976, 384, -144},
    { -1056, 488, -192},
    { -1056, 768, -80},
    { -1224, 736, -288},
    { -1296, 344, -160},
    { -920, 472, -328},
    { -1152, 480, -296},
    { -1536, 512, -200},
    { -1856, 352, -104},
    { -1608, 200, -72},
    { -1496, 152, 0},
    { -1344, 136, -40},
    { -1280, 208, -48},
    { -1096, 200, 0},
    { -912, 152, 16},
    { -1016, 160, 32},
    { -888, -56, 40},
    { -976, -168, -264},
    { -736, -280, -264},
    // 8 seconds
    { -1560, 400, -504},
    { -1584, 248, -656},
    { -1512, 248, -464},
    { -1456, 400, -352},
    { -1224, 360, -320},
    { -1152, 376, -216},
    { -1152, 360, -184},
    { -1224, 368, -152},
    { -1160, 432, -112},
    { -1064, 512, -152},
    { -1232, 648, -16},
    { -952, 640, -8},
    { -1264, 704, -32},
    { -864, 624, -192},
    { -936, 616, -264},
    { -1360, 560, -112},
    { -1664, 464, -64},
    { -1592, 328, -32},
    { -1424, 312, -32},
    { -1416, 232, -16},
    { -1408, 208, 0},
    { -1328, 168, 8},
    { -1136, 168, -40},
    { -1080, -24, -16},
    { -760, -616, 96},
    // 9 seconds
    { -696, 16, -240},
    { -1232, 200, -184},
    { -1544, 360, -640},
    { -1256, 224, -392},
    { -1328, -392, -120},
    { -1248, -56, -240},
    { -1128, 296, -320},
    { -976, 376, -312},
    { -1008, 248, -240},
    { -1000, 304, -184},
    { -1072, 304, -176},
    { -1080, 424, -152},
    { -1328, 824, -88},
    { -824, 872, -352},
    { -1424, 288, -288},
    { -1080, 480, -352},
    { -944, 480, -336},
    { -1088, 440, -328},
    { -1264, 264, -264},
    { -1424, 232, -200},
    { -1248, 208, -208},
    { -1112, 240, -192},
    { -1072, 184, -152},
    { -1032, 120, -128},
    { -968, 104, -104},
    // 10 seconds
    { -1064, 152, -136},
    { -1112, 64, -128},
    { -944, -96, -152},
    { -1088, 96, -336},
    { -1512, 272, -456},
    { -1208, 192, -592},
    { -1032, -24, -400},
    { -1144, -144, -288},
    { -1192, 120, -232},
    { -1040, 240, -200},
    { -936, 264, -128},
    { -936, 256, -96},
    { -968, 352, -144},
    { -928, 392, -224},
    { -952, 424, -224},
    { -1104, 976, -328},
    { -1064, 400, -352},
    { -1488, 200, -256},
    { -1144, 408, -344},
    { -1024, 464, -408},
    { -1104, 480, -376},
    { -1208, 376, -264},
    { -1384, 272, -144},
    { -1248, 112, -96},
    { -1112, 24, -72},
    // 11 seconds
    { -1024, 80, -88},
    { -888, 104, -88},
    { -824, 152, -128},
    { -936, 184, -144},
    { -1080, 136, -112},
    { -1096, 32, -184},
    { -1280, 96, -280},
    { -1152, 200, -528},
    { -1000, 144, -552},
    { -1192, -80, -328},
    { -1304, -80, -200},
    { -1280, 192, -168},
    { -1088, 344, -152},
    { -984, 352, -120},
    { -912, 360, -144},
    { -928, 336, -168},
    { -952, 368, -176},
    { -1024, 544, -224},
    { -960, 656, -248},
    { -1328, 408, -272},
    { -1256, 400, -256},
    { -1040, 440, -344},
    { -1176, 400, -248},
    { -1344, 376, -184},
    { -1400, 280, -120},
    // 12 seconds
    { -1056, 192, -144},
    { -968, 160, -112},
    { -976, 128, -96},
    { -984, 112, -120},
    { -992, 112, -144},
    { -1256, 216, -128},
    { -1152, 40, -160},
    { -1088, 96, -96},
    { -1168, 136, -352},
    { -1080, 256, -512},
    { -920, 176, -480},
    { -1064, -40, -344},
    { -1216, -64, -224},
    { -1168, 96, -176},
    { -1016, 272, -96},
    { -888, 384, -136},
    { -896, 416, -136},
    { -928, 464, -184},
    { -904, 576, -320},
    { -992, 1056, -424},
    { -952, 816, -264},
    { -1464, 32, -304},
    { -1344, 496, -496},
    { -1000, 552, -624},
    { -1256, 472, -416},
    // 13 seconds
    { -1560, 352, -216},
    { -1696, 144, -128},
    { -1368, 136, -120},
    { -1112, 168, -88},
    { -968, 192, -112},
    { -912, 168, -88},
    { -784, 128, -136},
    { -720, 48, -80},
    { -584, -256, -32},
    { -560, -376, -424},
    { -1112, 200, -520},
    { -1784, 128, -456},
    { -1768, 248, -472},
    { -1728, 264, -344},
    { -1456, 344, -216},
    { -1272, 496, -312},
    { -1272, 328, -64},
    { -1096, 296, -56},
    { -904, 288, -8},
    { -808, 336, -32},
    { -800, 360, -64},
    { -792, 360, -32},
    { -1016, 416, 80},
    { -1008, 768, 48},
    { -1024, 640, -248},
    // 14 seconds
    { -1224, 536, -200},
    { -1048, 624, -352},
    { -1248, 432, -312},
    { -1544, 440, -240},
    { -1696, 248, -176},
    { -1384, 152, -224},
    { -1288, 192, -120},
    { -1184, 168, -104},
    { -1112, 176, -56},
    { -1008, 136, -64},
    { -1072, 152, -72},
    { -1000, -256, 48},
    { -840, -280, -184},
    { -1208, 24, -224},
    { -1312, 136, -400},
    { -1376, 240, -520},
    { -1448, 32, -240},
    { -1496, -32, -136},
    { -1416, 160, -136},
    { -1272, 240, 0},
    { -1176, 344, 40},
    { -1048, 448, -128},
    { -1112, 392, -72},
    { -1016, 408, -48},
    { -1088, 496, -64},
    // 15 seconds
    { -1080, 640, -48},
    { -1104, 488, -240},
    { -1184, 608, -136},
    { -952, 520, -256},
    { -1152, 400, -232},
    { -1496, 408, -168},
    { -1760, 272, -80},
    { -1552, 152, -80},
    { -1416, 96, -64},
    { -1304, 96, -72},
    { -1184, 96, -64},
    { -1040, 136, -104},
    { -1008, 104, -104},
    { -976, -88, 0},
    { -792, -136, -120},
    { -1072, 32, -216},
    { -1288, 72, -272},
    { -1224, 104, -432},
    { -1296, 64, -416},
    { -1320, 16, -264},
    { -1288, 112, -240},
    { -1120, 224, -184},
    { -1096, 224, -192},
    { -1160, 232, -224},
    { -1232, 256, -216},
    // 16 seconds
    { -1120, 192, -240},
    { -1008, 272, -448},
    { -1096, 376, -472},
    { -1176, 376, -432},
    { -1440, 168, -280},
    { -1056, 376, -248},
    { -1032, 496, -376},
    { -1192, 544, -376},
    { -1560, 408, -304},
    { -1592, 624, -592},
    { -1440, -1096, -584},
    { -1128, 280, -88},
    { -1208, 112, -24},
    { -1072, 144, -16},
    { -984, 152, -24},
    { -1008, 128, -24},
    { -904, -112, 80},
    { -784, -168, -72},
    { -1216, 104, -112},
    { -1216, 64, -264},
    { -1160, 240, -560},
    { -1280, 24, -336},
    { -1344, 200, -216},
    { -1264, 304, -240},
    { -1136, 352, -200},
    // 17 seconds
    { -1072, 344, -104},
    { -1064, 392, -96},
    { -1016, 304, -48},
    { -968, 344, -88},
    { -1040, 400, -136},
    { -1152, 496, -48},
    { -1136, 392, -200},
    { -1400, 360, -200},
    { -888, 432, -360},
    { -1048, 392, -320},
    { -1168, 352, -376},
    { -1520, 248, -344},
    { -1264, 120, -312},
    { -1152, 120, -216},
    { -1024, 104, -160},
    { -960, 136, -120},
    { -872, 152, -40},
    { -856, 184, -40},
    { -1024, 368, -56},
    { -984, 352, 32},
    { -1144, 352, -72},
    { -1160, 272, -88},
    { -976, 216, -360},
    { -1024, 104, -312},
    { -1144, 40, -280},
    // 18 seconds
    { -1200, 24, -232},
    { -1256, 200, -192},
    { -1072, 248, -208},
    { -1024, 288, -112},
    { -1080, 296, -80},
    { -1120, 400, -64},
    { -992, 440, -168},
    { -992, 640, -184},
    { -1072, 600, -136},
    { -1184, 608, -272},
    { -1424, 640, -232},
    { -1056, 496, -256},
    { -1168, 576, -296},
    { -1408, 504, -272},
    { -1664, 336, -152},
    { -1664, 288, -64},
    { -1480, 224, -8},
    { -1288, 184, 24},
    { -1128, 208, 16},
    { -968, 200, 0},
    { -824, 176, 0},
    { -832, 128, -72},
    { -760, -152, 80},
    { -856, 144, 80},
    { -1024, 672, -152},
    // 19 seconds
    { -920, 760, -32},
    { -824, 1208, -304},
    { -832, 984, -280},
    { -792, 904, -280},
    { -656, 704, -240},
    { -488, 616, -184},
    { -440, 552, -96},
    { -448, 600, 8},
    { -480, 720, 88},
    { -464, 720, 176},
    { -544, 904, 192},
    { -728, 1024, 320},
    { -776, 1096, 344},
    { -952, 1272, 344},
    { -696, 1152, 296},
    { -656, 984, 200},
    { -680, 864, 208},
    { -824, 872, 240},
    { -872, 856, 208},
    { -768, 720, 128},
    { -624, 504, 72},
    { -528, 400, 48},
    { -464, 352, 0},
    { -480, 320, -24},
    { -640, 328, -32},
    // 20 seconds
    { -824, 264, -104},
    { -1048, 256, -200},
    { -1376, 136, -216},
    { -1672, 232, -288},
    { -1728, 360, -352},
    { -1600, 312, -200},
    { -1128, 336, -168},
    { -1008, 296, -200},
    { -1056, 224, -40},
    { -1000, 200, -16},
    { -928, 256, -56},
    { -880, 320, -88},
    { -784, 384, -152},
    { -904, 408, -208},
    { -1248, 504, -136},
    { -1096, 584, -128},
    { -1456, 312, -320},
    { -1192, 432, -328},
    { -1032, 472, -392},
    { -1392, 328, -312},
    { -1568, 336, -424},
    { -2112, 296, -568},
    { -1416, 376, -136},
    { -1272, 112, 8},
    { -1104, 128, -32},
    // 21 seconds
    { -1016, 112, 8},
    { -880, 128, 8},
    { -848, 104, 32},
    { -936, 16, 64},
    { -800, -40, -96},
    { -1024, 72, -64},
    { -1144, 176, -200},
    { -1152, 312, -408},
    { -1296, 176, -440},
    { -1592, 128, -312},
    { -1560, 136, -192},
    { -1224, 304, -176},
    { -1040, 384, -312},
    { -1136, 312, -192},
    { -1208, 288, -104},
    { -1048, 280, -176},
    { -856, 296, -240},
    { -1040, 656, -176},
    { -976, 472, -144},
    { -1240, 512, -160},
    { -1392, 536, -136},
    { -1016, 456, -264},
    { -1328, 440, -168},
    { -1632, 400, -64},
    { -1824, 280, -8},
    // 22 seconds
    { -1632, 168, 32},
    { -1432, 80, 48},
    { -1272, 72, 8},
    { -1120, 80, 24},
    { -936, 96, 8},
    { -816, 104, -24},
    { -880, -136, 64},
    { -712, -184, -72},
    { -1056, 152, -128},
    { -1240, 232, -376},
    { -1208, 312, -440},
    { -1304, 136, -384},
    { -1512, -224, -80},
    { -1648, 0, -88},
    { -1448, 328, -136},
    { -1216, 520, -136},
    { -1128, 400, -136},
    { -1184, 304, -112},
    { -1096, 280, -216},
    { -888, 264, -256},
    { -1096, 384, -160},
    { -1072, 584, -184},
    { -1288, 384, -280},
    { -1240, 400, -256},
    { -960, 456, -312},
    // 23 seconds
    { -1136, 464, -296},
    { -1536, 384, -152},
    { -1816, 296, -56},
    { -1640, 144, -16},
    { -1440, 72, 8},
    { -1296, 80, 0},
    { -1160, 88, 0},
    { -1048, 104, 8},
    { -1008, 160, 24},
    { -1112, 56, 64},
    { -848, -208, 80},
    { -1000, -56, 56},
    { -1136, 144, -240},
    { -1080, 296, -456},
    { -1264, 112, -272},
    { -1448, -48, -304},
    { -1560, 40, -272},
    { -1368, 240, -376},
    { -1232, 360, -264},
    { -1136, 272, -288},
    { -1184, 376, -192},
    { -1072, 320, -304},
    { -928, 520, -368},
    { -1032, 648, -344},
    { -1080, 664, -248},
    // 24 seconds
    { -1424, 688, -200},
    { -1152, 400, -176},
    { -1240, 296, -264},
    { -1456, 384, -120},
    { -1840, 312, -40},
    { -1736, 304, -72},
    { -1504, 144, 32},
    { -1336, 160, 0},
    { -1232, 136, 32},
    { -1120, 136, 24},
    { -896, 152, -16},
    { -864, 136, -8},
    { -840, -24, 32},
    { -592, -144, -216},
    { -648, -400, -248},
    { -1240, 120, -272},
    { -1488, 304, -632},
    { -1616, 200, -632},
    { -1552, 192, -360},
    { -1488, 480, -456},
    { -1256, 312, -312},
    { -1184, 344, -272},
    { -1176, 352, -224},
    { -1168, 376, -200},
    { -1064, 416, -192},
    // 25 seconds
    { -912, 504, -104},
    { -856, 616, -152},
    { -968, 552, -64},
    { -1160, 592, -104},
    { -1200, 504, -200},
    { -1184, 408, -240},
    { -1392, 456, -192},
    { -1664, 344, -112},
    { -1816, 320, -48},
    { -1648, 144, -16},
    { -1408, 136, 0},
    { -1264, 88, 0},
    { -1152, 112, 8},
    { -976, 120, -48},
    { -824, 152, -72},
    { -848, 0, 8},
    { -632, -208, 16},
    { -784, 40, -152},
    { -1144, 216, -224},
    { -1248, 272, -456},
    { -1368, 208, -480},
    { -1568, -168, -272},
    { -1608, -8, -232},
    { -1344, 304, -368},
    { -1152, 400, -376},
    // 26 seconds
    { -1160, 328, -248},
    { -1136, 272, -136},
    { -1128, 232, -32},
    { -1048, 296, 16},
    { -1080, 320, 136},
    { -1248, 448, 256},
    { -928, 504, 72},
    { -1448, 576, 192},
    { -744, 552, -80},
    { -888, 680, -160},
    { -1248, 504, -48},
    { -1536, 480, -88},
    { -1608, 288, -80},
    { -1432, 216, -104},
    { -1408, 168, -64},
    { -1368, 120, -104},
    { -1232, 96, -72},
    { -1072, 128, -136},
    { -1160, 112, -96},
    { -1080, -136, -80},
    { -928, -320, -248},
    { -1192, 128, -464},
    { -1120, 8, -536},
    { -1304, 0, -488},
    { -1416, -272, -224},
    // 27 seconds
    { -1472, 96, -88},
    { -1376, 320, -16},
    { -1304, 448, 48},
    { -1296, 352, 48},
    { -1344, 376, 104},
    { -1312, 400, 96},
    { -1152, 456, 128},
    { -1152, 600, 72},
    { -1000, 424, 120},
    { -1128, 616, 88},
    { -1152, 680, 88},
    { -848, 704, -144},
    { -952, 656, -128},
    { -1328, 632, 0},
    { -1816, 496, 80},
    { -1808, 176, 88},
    { -1632, 120, 64},
    { -1552, 88, 8},
    { -1400, 104, 24},
    { -1160, 160, -8},
    { -1008, 160, -56},
    { -1056, 56, -40},
    { -864, -392, -48},
    { -936, -120, -176},
    { -1152, 88, -248},
    // 28 seconds
    { -1176, 168, -424},
    { -1360, 240, -376},
    { -1416, -120, -200},
    { -1552, -48, -192},
    { -1384, 208, -192},
    { -1240, 424, -160},
    { -1248, 384, -136},
    { -1288, 304, -64},
    { -1232, 288, -8},
    { -1080, 344, -16},
    { -1104, 456, 0},
    { -1160, 728, 128},
    { -1192, 432, -120},
    { -1320, 432, 32},
    { -656, 568, -304},
    { -984, 720, -200},
    { -1432, 632, -64},
    { -1912, 208, 24},
    { -1632, 88, -152},
    { -1480, 136, -80},
    { -1312, 216, -104},
    { -1336, 168, -48},
    { -1248, 160, 16},
    { -1152, 224, -136},
    { -1104, 240, -96},
    // 29 seconds
    { -1024, 40, -104},
    { -696, -344, -184},
    { -960, -64, -312},
    { -920, 168, -480},
    { -1224, 72, -312},
    { -1224, -144, -232},
    { -1312, -80, -80},
    { -1312, 184, -104},
    { -1352, 352, -24},
    { -1432, 392, 32},
    { -1552, 432, 32},
    { -1456, 424, 16},
    { -1256, 576, -96},
    { -1312, 552, -184},
    { -1088, 512, -160},
    { -1280, 568, -336},
    { -1088, 584, -352},
    { -792, 536, -432},
    { -1096, 528, -352},
    { -1352, 352, -208},
    { -1768, 288, -40},
    { -1544, 376, -64},
    { -1520, 384, -64},
    { -1496, 496, 32},
    { -1464, 504, 40},
    // 30 seconds
    { -1232, 496, 16},
    { -1088, 456, 56},
    { -960, 312, 64},
    { -680, 200, 16},
    { -520, 440, 40},
    { -440, 552, 224},
    { -120, 808, 272},
    { -136, 1248, 200},
    { -184, 920, 688},
    { -144, 1032, 304},
    { -16, 1024, 168},
    { 216, 632, 336},
    { 304, 728, 152},
    { 296, 568, 280},
    { 328, 608, 272},
    { 336, 720, 216},
    { 304, 752, 376},
    { 272, 1192, 440},
    { 368, 1136, 544},
    { 432, 1176, 448},
    { 456, 1008, 216},
    { 424, 728, 136},
    { 360, 680, 144},
    { 344, 592, 32},
    { 144, 568, -16},
    // 31 seconds
    { 24, 384, -24},
    { -32, 440, 40},
    { -88, 304, 64},
    { -152, 472, 160},
    { -168, 608, 40},
    { -320, 736, 32},
    { -560, 528, 456},
    { -1160, 1000, 88},
    { -1480, 1128, 624},
    { -1488, 1064, 384},
    { -1200, 560, 232},
    { -1272, 504, 200},
    { -1256, 488, 104},
    { -1168, 288, 144},
    { -944, 352, 112},
    { -800, 216, 72},
    { -760, 240, 104},
    { -784, 352, 8},
    { -664, 328, 40},
    { -696, 392, -8},
    { -1040, 520, 32},
    { -1176, 488, 144},
    { -1616, 768, 56},
    { -1088, 424, -104},
    { -1128, 448, -40},
    // 32 seconds
    { -1392, 448, -24},
    { -1504, 336, 88},
    { -1448, 320, 64},
    { -1208, 64, 128},
    { -1000, 216, 80},
    { -992, 72, 120},
    { -880, 104, 152},
    { -792, 104, 96},
    { -880, 128, 136},
    { -896, 56, 192},
    { -824, -16, 168},
    { -1152, 128, 104},
    { -1312, 336, -200},
    { -976, 328, -320},
    { -1376, 280, -264},
    { -1344, 176, -280},
    { -1408, 280, -240},
    { -1144, 376, -304},
    { -1080, 280, -192},
    { -1088, 320, -208},
    { -904, 352, -96},
    { -848, 400, -88},
    { -848, 432, -8},
    { -984, 560, 56},
    { -976, 608, 48},
    // 33 seconds
    { -1072, 312, -64},
    { -1488, 400, 48},
    { -1128, 392, -48},
    { -1152, 384, -24},
    { -1336, 384, 48},
    { -1456, 328, 104},
    { -1296, 224, 136},
    { -1256, 208, 128},
    { -1232, 168, 128},
    { -1192, 120, 144},
    { -1080, 112, 136},
    { -976, 96, 112},
    { -968, 104, 120},
    { -1072, 120, 144},
    { -968, 80, 176},
    { -1024, 112, 144},
    { -1056, 144, 40},
    { -808, 312, -224},
    { -744, 448, -400},
    { -1104, 232, -336},
    { -1336, 144, -408},
    { -1216, 72, -456},
    { -984, 144, -456},
    { -976, 224, -400},
    { -1024, 200, -448},
    // 34 seconds
    { -984, 800, -576},
    { -736, 408, -376},
    { -1008, 320, -288},
    { -1040, 352, -184},
    { -1104, 336, -168},
    { -1456, 352, -144},
    { -1280, 320, -120},
    { -992, 216, -48},
    { -1208, 400, 88},
    { -1480, 400, 320},
    { -1232, 304, 296},
    { -1024, 288, 176},
    { -1120, 216, 240},
    { -1160, 208, 240},
    { -1104, 160, 296},
    { -960, 136, 224},
    { -808, 160, 176},
    { -784, 176, 160},
    { -880, 160, 184},
    { -936, 216, 80},
    { -1272, 416, -80},
    { -1400, 328, -160},
    { -1168, 144, -432},
    { -984, -192, -616},
    { -1360, -384, -448},
    // 35 seconds
    { -1376, 152, -472},
    { -1128, 344, -504},
    { -1024, 400, -432},
    { -992, 256, -224},
    { -992, 264, -144},
    { -880, 312, -120},
    { -800, 312, -80},
    { -736, 344, -32},
    { -968, 384, 40},
    { -1168, 456, 96},
    { -1088, 224, -160},
    { -1352, 288, -152},
    { -1240, 344, -40},
    { -1240, 280, -64},
    { -1416, 256, -40},
    { -1632, 248, 64},
    { -1616, 184, 136},
    { -1368, 112, 136},
    { -1160, 32, 88},
    { -976, 56, 64},
    { -856, 88, 64},
    { -784, 120, 80},
    { -704, 64, 48},
    { -840, 128, 128},
    { -952, 96, -40},
    // 36 seconds
    { -1024, -80, -24},
    { -1256, 208, -256},
    { -1216, 296, -648},
    { -1472, -8, -440},
    { -1592, 104, -320},
    { -1464, 200, -264},
    { -1152, 296, -352},
    { -1032, 280, -240},
    { -1040, 256, -112},
    { -992, 272, -64},
    { -944, 304, -96},
    { -872, 408, -112},
    { -840, 448, -56},
    { -984, 656, -16},
    { -1072, 360, -72},
    { -1600, 552, -16},
    { -1176, 408, -96},
    { -1104, 448, -144},
    { -1344, 416, -72},
    { -1712, 344, 64},
    { -1736, 208, 96},
    { -1512, 112, 112},
    { -1344, 80, 80},
    { -1224, 104, 72},
    { -1064, 104, 48},
    // 37 seconds
    { -856, 112, -48},
    { -752, 72, -24},
    { -712, -248, 40},
    { -560, -112, -88},
    { -936, 176, -136},
    { -1064, 336, -352},
    { -1264, 336, -384},
    { -1736, 152, -256},
    { -2184, 168, 72},
    { -1568, 728, 48},
    { -896, 48, -512},
    { -1248, 144, -64},
    { -1192, 304, 176},
    { -1072, 312, 120},
    { -872, 264, -48},
    { -680, 272, -136},
    { -968, 344, -168},
    { -1248, 496, 104},
    { -1216, 704, -240},
    { -1464, 184, -256},
    { -984, 336, -328},
    { -1328, 592, -176},
    { -1608, 304, -96},
    { -2000, 160, 80},
    { -1568, 104, -8},
    // 38 seconds
    { -1448, 96, 48},
    { -1336, 96, 64},
    { -1216, 112, 40},
    { -1056, 104, 56},
    { -968, 104, 72},
    { -1048, 48, 64},
    { -880, -280, 16},
    { -888, -176, -32},
    { -1136, 112, -112},
    { -1072, 96, -176},
    { -1408, 264, -256},
    { -1544, 184, -208},
    { -1648, 72, -144},
    { -1448, 136, -120},
    { -1320, 312, -88},
    { -1208, 376, -136},
    { -1208, 328, -128},
    { -1136, 328, -96},
    { -928, 384, -160},
    { -1088, 520, -136},
    { -1040, 536, -40},
    { -1272, 496, -176},
    { -1328, 488, -96},
    { -992, 408, -176},
    { -1400, 408, -88},
    // 39 seconds
    { -1672, 360, 0},
    { -1808, 248, 56},
    { -1592, 120, 56},
    { -1384, 112, 32},
    { -1312, 104, 56},
    { -1192, 88, 72},
    { -1032, 96, 56},
    { -944, 80, 56},
    { -912, -96, 88},
    { -664, -240, -64},
    { -1040, 80, 48},
    { -1064, 176, -160},
    { -1192, 296, -432},
    { -1392, 232, -320},
    { -1504, -168, -112},
    { -1480, -56, -96},
    { -1288, 256, -152},
    { -1208, 352, -96},
    { -1208, 400, -104},
    { -1208, 352, -80},
    { -1168, 312, -32},
    { -1128, 360, -40},
    { -1256, 616, 40},
    { -1056, 768, -96},
    { -1496, 376, -24},
    // 40 seconds
    { -880, 408, -152},
    { -952, 440, -200},
    { -1320, 512, -16},
    { -1672, 368, 64},
    { -1672, 192, 8},
    { -1480, 112, -16},
    { -1384, 128, -8},
    { -1328, 136, -8},
    { -1192, 136, -32},
    { -1056, 128, -40},
    { -1096, 120, -24},
    { -896, -136, 24},
    { -592, -248, -56},
    { -976, 16, -208},
    { -1032, 408, -520},
    { -1128, -72, -400},
    { -1624, -32, -272},
    { -1816, 248, 96},
    { -1448, 456, -24},
    { -1144, 416, -112},
    { -1080, 336, -104},
    { -1152, 320, 40},
    { -1168, 328, 64},
    { -1088, 296, 32},
    { -968, 424, -88},
    // 41 seconds
    { -992, 536, -112},
    { -1000, 360, -96},
    { -1480, 336, -192},
    { -936, 240, -416},
    { -952, 456, -432},
    { -1400, 272, -352},
    { -1528, 216, -352},
    { -1552, 200, -176},
    { -1416, 232, -104},
    { -1248, 272, -56},
    { -912, 152, 0},
    { -632, 96, 0},
    { -480, 136, 80},
    { -512, 136, 0},
    { -640, 232, 160},
    { -688, 136, 192},
    { -752, 80, 312},
    { -1296, 344, 256},
    { -1504, 504, 0},
    { -1480, 688, -368},
    { -1544, 568, -248},
    { -1368, 344, 0},
    { -1208, 496, -80},
    { -920, 648, -56},
    { -872, 824, 120},
    // 42 seconds
    { -680, 928, 376},
    { -384, 920, 352},
    { -256, 848, 208},
    { 72, 640, 144},
    { -208, 352, 80},
    { -656, 1008, 16},
    { -1128, 456, 200},
    { -1736, 1312, -792},
    { -976, 744, 240},
    { -528, 160, 464},
    { -944, 408, 304},
    { -1072, 0, -64},
    { -1032, 152, -328},
    { -664, 176, -184},
    { -816, 592, 72},
    { -440, 584, 8},
    { -504, 584, -240},
    { -360, 304, -504},
    { -696, 480, -520},
    { -1192, 544, -416},
    { -1176, 320, -440},
    { -1320, 208, -432},
    { -1352, -88, -496},
    { -1304, -248, -704},
    { -1104, 384, -168},
    // 43 seconds
    { -1176, -32, 64},
    { -976, -96, -336},
    { -720, -8, -512},
    { -624, 592, -472},
    { -664, 608, -280},
    { -640, 536, -224},
    { -776, 624, -48},
    { -960, 400, -224},
    { -920, 280, -168},
    { -1072, 104, -264},
    { -848, -64, -400},
    { -1064, 408, -536},
    { -1064, 640, -576},
    { -904, 528, -504},
    { -768, 536, -480},
    { -904, 312, -448},
    { -1144, 24, -368},
    { -1240, -160, -352},
    { -1032, -216, -392},
    { -808, -80, -440},
    { -728, 24, -344},
    { -720, 160, -248},
    { -912, 360, -216},
    { -984, 264, -56},
    { -1192, 784, -128},
    // 44 seconds
    { -1496, 968, 120},
    { -1464, 920, 112},
    { -1080, 376, -64},
    { -928, 832, -504},
    { -920, 712, -328},
    { -904, 600, -40},
    { -704, 512, 296},
    { -512, 592, 144},
    { -272, 680, 176},
    { -176, 608, 136},
    { 16, 864, -56},
    { 8, 984, -40},
    { 112, 760, -184},
    { 184, 576, -24},
    { 368, 688, 32},
    { 232, 528, 336},
    { 696, 1376, 152},
    { 1104, 1376, 472},
    { 528, 808, 456},
    { 800, 632, 688},
    { 752, 504, 480},
    { 800, 760, 504},
    { 504, 528, 224},
    { 504, 608, 192},
    { 384, 520, 40},
    // 45 seconds
    { 392, 592, 24},
    { 456, 544, -112},
    { 496, 512, -232},
    { 512, 640, -544},
    { 504, 544, -648},
    { 488, 376, -632},
    { 416, 264, -488},
    { 264, 336, -264},
    { 16, 632, -320},
    { -80, 800, -312},
    { -224, 648, 136},
    { -304, 1040, -576},
    { -40, 712, -344},
    { 104, 904, -352},
    { 128, 784, -232},
    { 136, 752, -176},
    { 200, 784, -160},
    { 200, 768, -296},
    { 400, 712, -88},
    { 288, 752, -320},
    { 416, 736, 8},
    { 416, 912, 112},
    { 520, 872, 288},
    { 720, 1120, 136},
    { 696, 864, 416},
    // 46 seconds
    { 640, 880, 520},
    { 448, 904, 552},
    { 248, 880, 608},
    { 120, 936, 464},
    { 160, 792, 424},
    { 288, 696, 208},
    { 344, 656, 264},
    { 344, 488, 216},
    { 360, 472, 352},
    { 424, 616, 432},
    { 352, 848, 552},
    { 336, 960, 616},
    { 248, 1192, 632},
    { 200, 1120, 728},
    { -24, 1056, 632},
    { 8, 792, 592},
    { -8, 744, 536},
    { -56, 696, 544},
    { -8, 616, 472},
    { 64, 536, 376},
    { 144, 504, 320},
    { 200, 592, 376},
    { 160, 640, 512},
    { 200, 656, 328},
    { 144, 792, 608},
    // 47 seconds
    { 104, 776, 616},
    { 104, 960, 768},
    { 56, 992, 928},
    { -48, 840, 928},
    { -16, 744, 864},
    { 72, 536, 912},
    { -56, 920, 872},
    { -72, 656, 840},
    { 8, 544, 568},
    { 64, 336, 384},
    { 144, 80, 384},
    { 16, 104, 144},
    { 24, 232, 760},
    { -168, 896, 928},
    { -208, 928, 1016},
    { -104, 1056, 1000},
    { -32, 1232, 736},
    { -168, 968, 760},
    { -240, 800, 648},
    { -200, 760, 568},
    { -232, 672, 568},
    { -272, 584, 576},
    { -184, 472, 400},
    { -88, 360, 336},
    { -16, 344, 296},
    // 48 seconds
    { 32, 384, 360},
    { 0, 528, 456},
    { -64, 768, 640},
    { -112, 904, 1008},
    { -128, 1040, 944},
    { -88, 1064, 1112},
    { -184, 1056, 1000},
    { -144, 896, 856},
    { -120, 744, 736},
    { -160, 776, 744},
    { -248, 736, 752},
    { -256, 632, 568},
    { -208, 472, 432},
    { -152, 304, 304},
    { -120, 232, 232},
    { -96, 264, 216},
    { -88, 360, 376},
    { -192, 608, 760},
    { -88, 824, 760},
    { -64, 1048, 1016},
    { -72, 1224, 1024},
    { -88, 1224, 840},
    { -128, 1064, 696},
    { -224, 848, 688},
    { -208, 696, 504},
    // 49 seconds
    { -176, 504, 408},
    { -112, 416, 344},
    { -48, 384, 328},
    { -8, 432, 336},
    { 24, 472, 312},
    { 32, 552, 352},
    { 24, 576, 440},
    { -320, 1024, 944},
    { -528, 1400, 1288},
    { -464, 1408, 1040},
    { -88, 1096, 528},
    { -184, 920, 240},
    { -184, 992, 40},
    { -280, 816, -56},
    { -296, 680, -176},
    { -248, 456, -200},
    { -280, 632, -288},
    { -168, 520, -448},
    { -184, 472, -576},
    { -184, 512, -792},
    { -200, 376, -880},
    { -304, 208, -1048},
    { -408, 272, -1288},
    { -552, 240, -1472},
    { -616, 112, -1312},
    // 50 seconds
    { -504, -80, -1120},
    { -536, -72, -872},
    { -360, -168, -816},
    { -248, -176, -768},
    { -168, -296, -672},
    { -160, -352, -648},
    { -144, -320, -640},
    { -152, -336, -680},
    { -184, -360, -704},
    { -224, -424, -824},
    { -304, -448, -928},
    { -296, -520, -1024},
    { -232, -512, -1136},
    { -136, -488, -1128},
    { -40, -384, -1088},
    { 48, -272, -1040},
    { -48, -240, -1040},
    { -192, -264, -952},
    { -232, -352, -824},
    { -232, -376, -752},
    { -168, -384, -688},
    { -144, -320, -648},
    { -152, -360, -680},
    { -128, -376, -696},
    { -120, -352, -816},
    // 51 seconds
    { -184, -296, -824},
    { -280, -176, -848},
    { -328, 216, -1120},
    { -384, 376, -1144},
    { -456, 592, -696},
    { -416, 1032, -352},
    { -384, 1072, 144},
    { -112, 1344, 224},
    { -168, 968, 320},
    { -40, 824, 528},
    { 32, 576, 640},
    { 80, 640, 584},
    { 64, 552, 624},
    { -72, 680, 720},
    { -192, 528, 944},
    { -296, 904, 1008},
    { -408, 976, 1128},
    { -424, 880, 1088},
    { -288, 816, 720},
    { -232, 616, 688},
    { -176, 592, 632},
    { -200, 624, 712},
    { -240, 496, 704},
    { -192, 544, 504},
    { -160, 400, 440},
    // 52 seconds
    { -80, 432, 368},
    { -96, 464, 376},
    { -120, 576, 440},
    { -216, 840, 608},
    { -264, 920, 616},
    { -344, 1192, 664},
    { -208, 1296, 520},
    { -216, 1120, 584},
    { -216, 936, 432},
    { -208, 736, 456},
    { -256, 672, 504},
    { -232, 608, 496},
    { -168, 376, 456},
    { -136, 432, 280},
    { -128, 416, 320},
    { -128, 448, 512},
    { -96, 528, 520},
    { -160, 728, 720},
    { -248, 848, 856},
    { -288, 944, 960},
    { -384, 920, 1040},
    { -336, 872, 904},
    { -232, 656, 824},
    { -192, 608, 736},
    { -264, 632, 736},
    // 53 seconds
    { -328, 552, 672},
    { -280, 544, 536},
    { -224, 392, 552},
    { -120, 184, 512},
    { -144, 520, 792},
    { -96, 376, 744},
    { -232, 608, 744},
    { -312, 800, 776},
    { -368, 800, 1152},
    { -376, 840, 1096},
    { -304, 1008, 816},
    { -280, 808, 688},
    { -256, 728, 560},
    { -304, 616, 536},
    { -336, 616, 504},
    { -280, 528, 456},
    { -192, 440, 384},
    { -152, 400, 368},
    { -136, 408, 376},
    { -136, 448, 392},
    { -160, 576, 560},
    { -272, 784, 752},
    { -296, 904, 816},
    { -280, 1008, 1040},
    { -368, 1096, 1080},
    // 54 seconds
    { -248, 864, 824},
    { -168, 720, 832},
    { -144, 760, 744},
    { -216, 800, 840},
    { -352, 720, 688},
    { -248, 536, 464},
    { -232, 360, 400},
    { -240, 264, 296},
    { -240, 256, 264},
    { -272, 248, 240},
    { -376, 280, 232},
    { -616, 296, 224},
    { -984, 280, 184},
    { -1576, 200, 328},
    { -2600, 536, 408},
    { -1992, 1168, 272},
    { -1064, 352, 480},
    { -1096, 216, 192},
    { -1040, 376, 16},
    { -1056, 272, 272},
    { -872, 256, 312},
    { -768, 240, 232},
    { -672, 216, 232},
    { -624, 264, 192},
    { -656, 240, 128},
    // 55 seconds
    { -1064, 232, 448},
    { -1032, 416, 632},
    { -1296, 696, 512},
    { -1240, 624, 392},
    { -1000, 648, 280},
    { -1376, 472, 464},
    { -1600, 528, 448},
    { -1424, 376, 504},
    { -1216, 56, 432},
    { -1064, -88, 224},
    { -1048, 200, 216},
    { -920, 128, 240},
    { -760, 152, 200},
    { -736, 104, 112},
    { -680, -192, 360},
    { -760, -264, 32},
    { -1064, 216, -264},
    { -1616, 200, -144},
    { -1640, 416, -760},
    { -1576, 64, -320},
    { -1304, 528, -408},
    { -1088, 40, -264},
    { -1120, 256, 8},
    { -1248, 344, 176},
    { -928, 232, 128},
    // 56 seconds
    { -848, 184, 128},
    { -736, 216, 48},
    { -632, 320, -96},
    { -1000, 288, -16},
    { -1360, 384, 128},
    { -1504, 688, 216},
    { -1160, 480, -232},
    { -1016, 664, -144},
    { -1176, 360, -48},
    { -1320, 280, -48},
    { -1584, 352, 56},
    { -1472, 184, 112},
    { -1272, 96, 104},
    { -1152, 64, 112},
    { -1064, 104, 112},
    { -968, 144, 96},
    { -968, 120, 160},
    { -984, 176, 136},
    { -808, 80, 16},
    { -728, 8, -160},
    { -968, 216, -200},
    { -1008, 224, -440},
    { -1216, 80, -560},
    { -1528, -80, -632},
    { -1576, 176, -608},
    // 57 seconds
    { -1400, 32, 32},
    { -1144, 232, 184},
    { -880, 328, -96},
    { -1080, 168, 80},
    { -1032, 272, 80},
    { -872, 272, 24},
    { -992, 384, -64},
    { -1128, 376, 48},
    { -1432, 600, -48},
    { -1072, 872, -80},
    { -904, 568, -312},
    { -1320, 440, -88},
    { -1536, 232, -72},
    { -1592, 200, -64},
    { -1424, 168, -80},
    { -1336, 176, -152},
    { -1320, 168, -120},
    { -1192, 80, -24},
    { -960, 120, -48},
    { -800, 104, -32},
    { -728, 56, -8},
    { -680, -24, -40},
    { -848, 152, -72},
    { -1232, 280, -208},
    { -1192, 272, -264},
    // 58 seconds
    { -1408, 144, -280},
    { -1784, -176, -72},
    { -1712, 96, -40},
    { -1328, 400, 136},
    { -1048, 376, -72},
    { -1104, 256, 64},
    { -1064, 240, 112},
    { -936, 224, 24},
    { -792, 224, 64},
    { -856, 352, 16},
    { -1168, 480, 176},
    { -1296, 808, 8},
    { -1368, 320, -32},
    { -936, 384, -40},
    { -1120, 520, -208},
    { -1488, 304, -64},
    { -1768, 512, 8},
    { -1496, 232, 64},
    { -1392, 144, 80},
    { -1304, 176, -8},
    { -1272, 232, 56},
    { -1136, 192, 120},
    { -896, 264, 104},
    { -1120, 136, 56},
    { -488, -352, -96},
    // 59 seconds
    { -648, -32, -240},
    { -1024, 96, -168},
    { -1208, 272, -248},
    { -1416, 208, -240},
    { -1608, 344, -176},
    { -1560, 264, 48},
    { -1344, 592, -240},
    { -1144, 352, -72},
    { -1104, 272, 8},
    { -1128, 280, 48},
    { -1120, 352, 40},
    { -992, 360, 24},
    { -904, 328, 64},
    { -1112, 520, 144},
    { -1040, 680, 104},
    { -1312, 552, 24},
    { -1032, 664, -112},
    { -880, 624, -240},
    { -1096, 528, -16},
    { -1504, 432, 168},
    { -1576, 288, 208},
    { -1408, 192, 224},
    { -1320, 128, 200},
    { -1312, 128, 184},
    { -1288, 136, 152},
    // 60 seconds
    // elapsed: 1 minutes
    { -1128, 112, 136},
    { -1056, 120, 112},
    { -944, 72, -8},
    { -736, -168, -112},
    { -968, -40, -120},
    { -1168, 296, -488},
    { -1272, 288, -416},
    { -1208, 24, -328},
    { -1384, -264, -88},
    { -1464, -16, -8},
    { -1392, 224, 32},
    { -1184, 368, -72},
    { -1112, 352, -16},
    { -1144, 328, 16},
    { -1120, 256, 32},
    { -1024, 296, -24},
    { -1024, 296, 0},
    { -1112, 632, 16},
    { -880, 760, -152},
    { -1248, 536, -216},
    { -1336, 184, -176},
    { -1280, 208, -224},
    { -1352, 312, -232},
    { -1448, 296, -128},
    { -1424, 176, 8},
    // 61 seconds
    { -1344, 168, 48},
    { -1320, 136, 88},
    { -1320, 104, 112},
    { -1272, 72, 160},
    { -1048, 72, 128},
    { -952, 64, 112},
    { -912, 24, 184},
    { -784, 32, 128},
    { -840, 0, 144},
    { -1096, 144, 32},
    { -928, 336, -240},
    { -840, 352, -344},
    { -1208, 144, -296},
    { -1592, -24, -176},
    { -1472, 120, -360},
    { -1192, 288, -304},
    { -1120, 288, -272},
    { -1184, 272, -208},
    { -1208, 296, -192},
    { -1080, 368, -184},
    { -960, 440, -176},
    { -1024, 776, -184},
    { -1056, 632, -112},
    { -1520, 384, -56},
    { -1200, 280, -160},
    // 62 seconds
    { -1160, 256, -80},
    { -1344, 224, 48},
    { -1536, 224, 152},
    { -1608, 72, 216},
    { -1488, 56, 248},
    { -1432, 56, 264},
    { -1328, 88, 296},
    { -1208, 104, 312},
    { -1032, 112, 288},
    { -888, 88, 248},
    { -776, 96, 200},
    { -832, 112, 200},
    { -832, 144, 104},
    { -1064, 216, -40},
    { -1256, 384, -248},
    { -760, 144, -368},
    { -392, -208, -528},
    { -1248, -240, -464},
    { -1864, -32, -392},
    { -1696, 184, -408},
    { -1560, 344, -416},
    { -1256, 432, -336},
    { -1040, 160, -312},
    { -1256, 272, -320},
    { -1040, 432, -240},
    // 63 seconds
    { -872, 608, -240},
    { -952, 616, -160},
    { -1192, 520, -64},
    { -1272, 400, -64},
    { -1104, 288, -40},
    { -1400, 384, 112},
    { -2288, 248, 312},
    { -1576, 176, 232},
    { -1288, 80, 216},
    { -1224, 96, 168},
    { -1296, 80, 224},
    { -1256, 88, 256},
    { -1200, 80, 320},
    { -896, 16, 216},
    { -760, 88, 160},
    { -912, 184, 104},
    { -1048, 288, -72},
    { -1160, 248, -16},
    { -1000, 136, 40},
    { -552, 248, -304},
    { -568, 456, -336},
    { -1184, 504, -32},
    { -1232, 544, -112},
    { -1296, 520, -192},
    { -1272, 520, -152},
    // 64 seconds
    { -1144, 464, -120},
    { -896, 496, -232},
    { -856, 368, -256},
    { -832, 424, -336},
    { -928, 560, -336},
    { -1008, 728, -256},
    { -1392, 544, -144},
    { -1392, 448, -72},
    { -1384, 512, 56},
    { -1664, 600, 152},
    { -1656, 664, 280},
    { -1408, 432, 280},
    { -1184, 400, 224},
    { -968, 336, 328},
    { -848, 288, 224},
    { -776, 256, 216},
    { -664, 152, 224},
    { -640, 104, 216},
    { -664, 104, 376},
    { -760, 472, -472},
    { -1144, 248, 368},
    { -1232, 800, -176},
    { -1128, 320, -200},
    { -1040, -256, -80},
    { -1632, 0, -320},
    // 65 seconds
    { -1824, 216, -16},
    { -1424, 848, -160},
    { -896, 1000, -328},
    { -1144, 376, 0},
    { -1016, 216, 8},
    { -936, 296, -56},
    { -888, 400, -120},
    { -744, 464, -72},
    { -928, 688, 0},
    { -1008, 552, 24},
    { -1520, 488, 104},
    { -1304, 272, 32},
    { -1104, 344, -8},
    { -1336, 320, 96},
    { -1704, 224, 104},
    { -1632, 360, 168},
    { -1376, 120, 216},
    { -1216, -8, 224},
    { -1152, 48, 176},
    { -1024, 56, 152},
    { -864, 96, 128},
    { -944, 88, 176},
    { -1000, 16, 224},
    { -896, -376, 320},
    { -1184, -432, 488},
    // 66 seconds
    { -1344, 520, -8},
    { -1496, 1032, -168},
    { -1408, 88, 288},
    { -1608, 0, 56},
    { -1328, 824, -280},
    { -1160, 632, -32},
    { -944, 448, -16},
    { -1008, 232, 152},
    { -1008, 368, 128},
    { -864, 288, 192},
    { -832, 256, 280},
    { -1064, 560, 424},
    { -1048, 544, 200},
    { -1344, 160, 24},
    { -1104, 336, 120},
    { -1112, 344, 56},
    { -1376, 400, 88},
    { -1544, 360, 32},
    { -1496, 328, 72},
    { -1416, 360, 128},
    { -1392, 360, 120},
    { -1408, 504, 104},
    { -1376, 648, -80},
    { -1240, 416, 24},
    { -984, 104, 80},
    // 67 seconds
    { -696, 352, -352},
    { -528, 288, -568},
    { -424, 288, -864},
    { -336, 344, -1152},
    { -472, 80, -936},
    { -440, -104, -888},
    { -400, -200, -720},
    { -280, -192, -744},
    { -104, -256, -720},
    { -112, -192, -776},
    { -72, -240, -768},
    { -16, -216, -752},
    { 104, -216, -816},
    { 232, -96, -1088},
    { -72, -160, -1128},
    { -184, -120, -1072},
    { -160, -80, -1360},
    { -168, -104, -1240},
    { -96, -88, -1224},
    { -112, -64, -1112},
    { -208, -56, -1080},
    { -240, -128, -928},
    { -184, -208, -776},
    { -112, -216, -704},
    { -32, -264, -704},
    // 68 seconds
    { -40, -184, -768},
    { -24, -264, -760},
    { -40, -168, -904},
    { -112, -224, -920},
    { 32, -200, -1176},
    { -160, -112, -1328},
    { -296, -96, -1376},
    { -424, -40, -1320},
    { -456, -144, -1080},
    { -376, -128, -848},
    { -232, -184, -744},
    { -144, -232, -608},
    { -64, -152, -616},
    { -80, -112, -560},
    { -280, -64, -360},
    { -184, 368, -272},
    { -136, 768, -296},
    { -392, 1648, -232},
    { -256, 1056, 208},
    { -224, 1360, -40},
    { -232, 1584, -16},
    { -40, 1024, 88},
    { 104, 1120, 8},
    { 104, 1200, 72},
    { -32, 1032, 168},
    // 69 seconds
    { -64, 840, 48},
    { -56, 688, 8},
    { -48, 480, 16},
    { -64, 568, -80},
    { -120, 296, 32},
    { -224, 144, -16},
    { -640, 248, -104},
    { -1736, 8, 232},
    { -2264, 112, 128},
    { -2568, 552, -152},
    { -1928, 352, -280},
    { -1176, 840, -184},
    { -832, -64, -264},
    { -1352, 280, 168},
    { -1000, 40, 24},
    { -776, 160, -24},
    { -680, 208, -56},
    { -672, 240, -144},
    { -720, 344, -160},
    { -736, 248, -208},
    { -1128, 352, -264},
    { -1136, 344, -64},
    { -1576, 592, -312},
    { -1504, 400, -312},
    { -1272, 400, -256},
    // 70 seconds
    { -1376, 344, -168},
    { -1640, 528, -32},
    { -1592, 512, 152},
    { -1296, 528, 232},
    { -1048, 456, 296},
    { -784, 344, 224},
    { -608, 240, 176},
    { -392, 152, 128},
    { -304, 16, 144},
    { -352, 400, 72},
    { -288, 256, -128},
    { -600, 1080, 136},
    { -544, 1384, 376},
    { -480, 1736, 320},
    { -288, 1424, 192},
    { -224, 1088, 104},
    { -248, 952, 136},
    { -176, 752, 96},
    { -72, 712, 56},
    { 24, 520, 80},
    { 56, 488, 56},
    { 80, 464, 40},
    { 80, 448, 40},
    { 104, 408, 0},
    { 0, 504, -32},
    // 71 seconds
    { -328, 984, 216},
    { -552, 1360, 264},
    { -880, 1760, 296},
    { -584, 1528, 280},
    { -304, 1040, 64},
    { -136, 832, -8},
    { -208, 872, 0},
    { -256, 872, -32},
    { -400, 880, -48},
    { -400, 664, -24},
    { -376, 424, -48},
    { -344, 280, -64},
    { -352, 184, -32},
    { -448, 208, -24},
    { -648, 192, 8},
    { -1080, 192, 136},
    { -2032, 216, 384},
    { -2512, 1264, -1328},
    { -1712, 712, 512},
    { -696, -368, 224},
    { -856, -296, 40},
    { -1112, 304, 96},
    { -1248, 376, 128},
    { -968, 304, 96},
    { -680, 176, 136},
    // 72 seconds
    { -544, 152, 128},
    { -600, 160, 112},
    { -592, 232, 40},
    { -672, 192, 32},
    { -968, 360, -48},
    { -1288, 240, 32},
    { -1368, 288, -16},
    { -928, -136, -2872},
    { -1568, 136, -40},
    { -648, 40, -184},
    { -856, -48, -104},
    { -1136, 352, -136},
    { -1304, 384, -56},
    { -1024, 152, 88},
    { -864, 64, 80},
    { -856, 40, 64},
    { -888, 72, 96},
    { -752, 104, 80},
    { -784, 96, 72},
    { -944, 64, 32},
    { -1064, 112, -104},
    { -864, 176, -344},
    { -1360, 776, -1488},
    { -1672, 176, -112},
    { -1480, -288, -32},
    // 73 seconds
    { -976, 56, 104},
    { -840, 176, -256},
    { -1160, 96, 112},
    { -1120, 200, 232},
    { -912, 208, 184},
    { -688, 136, 120},
    { -608, 128, 128},
    { -592, 152, 64},
    { -592, 112, 72},
    { -752, 264, 144},
    { -1056, 344, -8},
    { -1504, 224, -288},
    { -1984, 2336, -488},
    { -1704, 296, 648},
    { -448, 152, -440},
    { -1032, -72, 56},
    { -1320, 184, 32},
    { -1128, 168, 64},
    { -872, 120, 56},
    { -688, 72, -8},
    { -784, 112, -16},
    { -824, 56, -72},
    { -720, 40, -8},
    { -840, 184, 56},
    { -880, 80, -40},
    // 74 seconds
    { -1056, 240, -136},
    { -1112, 680, -1144},
    { -1672, 400, -512},
    { -1872, -208, -32},
    { -1160, 112, 232},
    { -640, 456, -384},
    { -712, 88, -152},
    { -1424, 240, 80},
    { -1064, 88, 0},
    { -680, 56, -40},
    { -488, 96, -104},
    { -520, 160, -64},
    { -488, 144, -208},
    { -544, 136, -168},
    { -912, 296, -320},
    { -1504, 208, -88},
    { -2168, 384, -184},
    { -1520, 784, -688},
    { -616, -8, -496},
    { -1000, 400, -184},
    { -1232, 264, -208},
    { -1320, 248, -40},
    { -992, 208, -8},
    { -672, 8, -32},
    { -648, 40, 8},
    // 75 seconds
    { -704, 112, -32},
    { -784, 96, -24},
    { -904, 112, 32},
    { -976, 136, 8},
    { -1016, 136, -8},
    { -1184, 128, -24},
    { -1664, 208, -80},
    { -1632, 432, -624},
    { -1128, 376, -448},
    { -864, -328, -120},
    { -1080, -104, -40},
    { -1040, 176, -80},
    { -888, 256, 32},
    { -672, 288, 48},
    { -600, 160, 48},
    { -624, 184, 56},
    { -648, 264, 32},
    { -688, 304, 48},
    { -968, 360, 16},
    { -1304, 200, 192},
    { -1864, 1080, 96},
    { -1224, 560, -48},
    { -1080, 848, -88},
    { -1232, 632, 136},
    { -1456, 408, 272},
    // 76 seconds
    { -1336, 296, 264},
    { -1072, 336, 344},
    { -920, 272, 400},
    { -848, 448, 96},
    { -768, 336, 96},
    { -632, 128, 136},
    { -560, 120, 200},
    { -672, 176, -8},
    { -472, -216, -136},
    { -944, 312, 0},
    { -1584, 400, 312},
    { -1936, 504, 96},
    { -2320, 760, 560},
    { -1144, 1648, 880},
    { -928, 712, -256},
    { -1384, 168, -40},
    { -1080, 168, 88},
    { -800, 80, 248},
    { -760, 280, 152},
    { -832, 296, 200},
    { -792, 312, 232},
    { -832, 408, 152},
    { -1080, 456, 312},
    { -1064, 312, 248},
    { -1312, 232, 32},
    // 77 seconds
    { -1456, 512, 96},
    { -1168, 584, -88},
    { -1320, 496, -112},
    { -1784, 432, 88},
    { -1656, 312, 144},
    { -1352, 176, 176},
    { -1256, 88, 200},
    { -1216, 40, 208},
    { -1112, 40, 72},
    { -936, 48, 32},
    { -744, -128, -16},
    { -392, -488, 8},
    { -696, 176, 48},
    { -888, 168, 64},
    { -1432, 272, -8},
    { -1504, 376, -64},
    { -1712, 496, -72},
    { -1504, 216, 96},
    { -1072, 184, -336},
    { -1016, 40, -472},
    { -1272, 296, -200},
    { -1024, 344, -72},
    { -1104, 184, 104},
    { -1368, 600, 208},
    { -944, 1000, 16},
    // 78 seconds
    { -984, 192, -56},
    { -1112, 352, 56},
    { -1536, 456, 48},
    { -1304, 408, 184},
    { -1048, 336, 72},
    { -1296, 288, 80},
    { -1632, 200, 144},
    { -1624, 184, 104},
    { -1312, 112, 112},
    { -1088, 56, 96},
    { -1040, 104, 112},
    { -1016, 64, 112},
    { -904, 104, 16},
    { -944, 120, 96},
    { -968, -32, 112},
    { -752, -224, -72},
    { -1200, 112, -96},
    { -1568, 408, -272},
    { -1424, 440, -392},
    { -1488, -128, -192},
    { -1544, -200, 32},
    { -1312, 32, 152},
    { -1064, 304, 0},
    { -1000, 256, 128},
    { -1040, 232, 216},
    // 79 seconds
    { -1048, 200, 168},
    { -872, 264, 96},
    { -808, 240, 64},
    { -1200, 352, 184},
    { -1544, 608, 344},
    { -1416, 920, -40},
    { -880, 32, -336},
    { -1104, 368, -136},
    { -1336, 512, 0},
    { -1592, 440, 56},
    { -1456, 208, 24},
    { -1360, 56, 104},
    { -1296, -8, 176},
    { -1264, -88, 128},
    { -1120, 8, 72},
    { -992, 64, 48},
    { -1040, 56, 24},
    { -960, -256, 96},
    { -920, -48, -128},
    { -1296, 64, -40},
    { -1048, 184, -272},
    { -1368, 120, -240},
    { -1520, -144, -16},
    { -1552, -32, 40},
    { -1160, 64, -16},
    // 80 seconds
    { -1048, 352, 24},
    { -1008, 488, 64},
    { -1056, 256, 168},
    { -984, 200, 96},
    { -936, 192, 176},
    { -1056, 304, 168},
    { -1240, 592, 232},
    { -1080, 728, -80},
    { -1360, 272, -40},
    { -1024, 344, 56},
    { -960, 520, -88},
    { -1376, 312, 64},
    { -1840, 176, 80},
    { -1520, 48, -40},
    { -1408, 184, -48},
    { -1368, 160, -8},
    { -1280, 184, -88},
    { -1072, 88, -120},
    { -992, 112, -144},
    { -1072, 208, -240},
    { -848, -160, 144},
    { -880, -184, -96},
    { -912, -104, -264},
    { -1120, -184, -504},
    { -1472, 8, -432},
    // 81 seconds
    { -1656, -152, -168},
    { -1576, 56, -120},
    { -1336, 328, -136},
    { -1160, 600, -272},
    { -944, 272, -192},
    { -1040, 216, -56},
    { -1128, 112, 48},
    { -896, 88, 16},
    { -1000, 112, 0},
    { -1144, 480, -24},
    { -1056, 288, -160},
    { -1672, 184, -104},
    { -1272, 352, -176},
    { -848, 472, -352},
    { -1152, 520, -288},
    { -1792, 424, -160},
    { -1632, 392, -392},
    { -1576, 376, -200},
    { -1360, 184, -8},
    { -1384, 472, 48},
    { -1256, 120, 168},
    { -1056, 168, 96},
    { -904, 104, 104},
    { -776, 16, 192},
    { -720, 176, -296},
    // 82 seconds
    { -208, -688, -328},
    { -896, 120, -264},
    { -1232, 288, -56},
    { -1600, 304, -128},
    { -2240, 568, 112},
    { -1888, 112, 568},
    { -1208, 1320, -32},
    { -1520, 624, 120},
    { -1392, 336, 168},
    { -1184, 144, 264},
    { -992, 136, 376},
    { -816, 168, 344},
    { -776, 168, 304},
    { -752, 152, 384},
    { -760, 176, 384},
    { -784, 256, 256},
    { -808, 424, 64},
    { -832, 336, 48},
    { -1416, 288, 136},
    { -1872, 296, 144},
    { -1264, 224, -296},
    { -840, 240, -1376},
    { -1152, 464, -680},
    { -992, -256, -368},
    { -1216, -32, -320},
    // 83 seconds
    { -1160, 432, -64},
    { -904, 232, -144},
    { -808, 168, 32},
    { -744, 96, 80},
    { -744, 64, 72},
    { -752, 120, 72},
    { -784, 88, 72},
    { -864, 88, 48},
    { -992, 200, 24},
    { -1320, 248, 0},
    { -1616, 208, 8},
    { -1768, 616, -1048},
    { -1488, 64, -200},
    { -592, -80, -24},
    { -728, 72, -72},
    { -896, 232, -104},
    { -1104, 280, -40},
    { -904, 272, -24},
    { -728, 128, 48},
    { -728, 128, 80},
    { -776, 128, 56},
    { -736, 128, 40},
    { -792, 136, 48},
    { -1056, 192, -32},
    { -1312, 440, -768},
    // 84 seconds
    { -2024, 736, 48},
    { -1184, 520, -8},
    { -672, 1096, -416},
    { -1344, 864, -128},
    { -1600, 1168, 56},
    { -1440, 968, -104},
    { -1320, 976, -184},
    { -1216, 656, -128},
    { -912, 360, -192},
    { -672, 160, -256},
    { -448, 120, -408},
    { -232, -80, -448},
    { -208, -104, -552},
    { -112, -112, -728},
    { -112, -280, -808},
    { 8, -256, -976},
    { -32, -376, -1048},
    { -168, -328, -1024},
    { -224, -448, -872},
    { -96, -456, -760},
    { 24, -464, -704},
    { 96, -560, -648},
    { 96, -448, -688},
    { 128, -536, -624},
    { 112, -440, -744},
    // 85 seconds
    { 152, -432, -848},
    { 144, -440, -936},
    { 64, -464, -1016},
    { 88, -608, -912},
    { 136, -536, -1048},
    { 184, -592, -960},
    { 320, -424, -1000},
    { 344, -88, -816},
    { 392, 408, -616},
    { 248, 872, -560},
    { 152, 792, -368},
    { 120, 872, -400},
    { 144, 752, -336},
    { 128, 688, -232},
    { 128, 808, -168},
    { 184, 752, -200},
    { 232, 816, -144},
    { 256, 992, -296},
    { 280, 1032, -176},
    { 208, 1032, -96},
    { 64, 1032, 48},
    { 40, 976, -96},
    { -48, 776, -144},
    { 8, 312, 144},
    { 88, 152, 80},
    // 86 seconds
    { 48, 296, -96},
    { 24, 304, -192},
    { -40, 184, -112},
    { -240, 200, -160},
    { -608, 416, -216},
    { -1152, 736, -128},
    { -1864, 1320, -264},
    { -1984, 888, -288},
    { -2696, 424, 136},
    { -1576, 1136, -176},
    { -592, 600, -968},
    { -1080, 648, -520},
    { -1136, 416, -360},
    { -1224, 352, -200},
    { -1072, 328, -168},
    { -1000, 280, -40},
    { -960, 224, -16},
    { -960, 160, 32},
    { -912, 104, 72},
    { -944, 80, 80},
    { -1192, 40, 136},
    { -1128, -136, 120},
    { -1240, -88, 96},
    { -1128, 192, -200},
    { -1056, 264, -304},
    // 87 seconds
    { -1168, 136, -192},
    { -1288, -16, -176},
    { -1280, -136, -200},
    { -1200, 0, -184},
    { -1112, 280, -56},
    { -1032, 320, -64},
    { -1008, 352, -40},
    { -968, 352, -64},
    { -880, 400, -48},
    { -1040, 472, -112},
    { -1096, 480, -72},
    { -1480, 296, -144},
    { -1224, 104, -72},
    { -984, 264, -160},
    { -1944, 264, 152},
    { -1664, 272, -168},
    { -1688, 152, -112},
    { -1328, 160, -16},
    { -1208, -8, 72},
    { -1128, 208, 120},
    { -1040, 128, 144},
    { -928, 64, 184},
    { -992, 456, 16},
    { -816, -152, -176},
    { -568, -216, 96},
    // 88 seconds
    { -880, -16, -168},
    { -1416, 472, -184},
    { -1352, 104, -280},
    { -1520, 136, -240},
    { -1560, 232, -8},
    { -1368, 528, -272},
    { -1120, 488, -232},
    { -1000, 352, -136},
    { -1112, 256, -40},
    { -1152, 304, -56},
    { -1064, 320, -72},
    { -952, 544, -40},
    { -1040, 560, 136},
    { -1224, 104, 128},
    { -1328, 536, 256},
    { -1160, 544, 104},
    { -1032, 536, -56},
    { -1224, 488, 80},
    { -1512, 440, 200},
    { -1792, 280, 328},
    { -1616, 192, 328},
    { -1528, 40, 208},
    { -1400, -208, 168},
    { -1104, -272, 80},
    { -864, -104, 48},
    // 89 seconds
    { -928, 88, -72},
    { -944, -136, -40},
    { -720, -56, -264},
    { -1096, 336, -336},
    { -1128, 216, -384},
    { -1416, 272, -288},
    { -1456, -176, -80},
    { -1624, -168, -32},
    { -1408, 176, 8},
    { -1200, 424, -120},
    { -1216, 264, -48},
    { -1296, 240, 24},
    { -1224, 208, 64},
    { -936, 256, 40},
    { -1048, 272, 112},
    { -1344, 568, 224},
    { -1480, 776, 32},
    { -1192, 216, 48},
    { -656, 112, -192},
    { -992, 416, -32},
    { -1432, 456, 16},
    { -1640, 248, 56},
    { -1384, 120, 56},
    { -1240, 32, 104},
    { -1248, 48, 88},
    // 90 seconds
    { -1208, 80, 56},
    { -1144, 88, 48},
    { -1240, 128, 64},
    { -1240, -64, 112},
    { -976, -208, 64},
    { -1080, 0, -96},
    { -1072, 160, -304},
    { -1160, 288, -376},
    { -1272, 64, -240},
    { -1376, -216, -96},
    { -1376, 0, -72},
    { -1184, 256, -88},
    { -1032, 336, -144},
    { -1072, 288, -104},
    { -1056, 264, -40},
    { -1024, 280, -24},
    { -888, 184, -128},
    { -1080, 384, -56},
    { -1112, 656, -8},
    { -1680, 360, 48},
    { -1136, 264, -8},
    { -960, 352, -144},
    { -1208, 288, -32},
    { -1496, 264, 40},
    { -1456, 248, 0},
    // 91 seconds
    { -1320, 176, 8},
    { -1288, 120, 48},
    { -1248, 48, 64},
    { -1168, 40, 56},
    { -1056, 88, -88},
    { -968, 112, -112},
    { -920, 168, -200},
    { -728, 528, -552},
    { -824, 528, -560},
    { -600, 784, -912},
    { -672, 792, -952},
    { -744, 528, -800},
    { -768, 456, -848},
    { -592, 240, -808},
    { -336, 232, -848},
    { -240, 104, -784},
    { -232, -24, -760},
    { -168, -40, -760},
    { -128, -96, -792},
    { -128, -128, -768},
    { -224, -160, -816},
    { -224, -256, -928},
    { -40, -320, -992},
    { -104, -136, -1216},
    { -32, -320, -1136},
    // 92 seconds
    { 32, -280, -1040},
    { 16, -296, -992},
    { -72, -200, -1000},
    { -160, -312, -904},
    { -176, -320, -992},
    { -200, -352, -872},
    { -160, -416, -792},
    { -96, -424, -752},
    { -48, -480, -720},
    { -48, -448, -768},
    { -88, -424, -832},
    { -136, -464, -888},
    { -208, -400, -960},
    { -304, -336, -1072},
    { -416, -376, -1232},
    { -504, -504, -1064},
    { -376, -440, -920},
    { -232, -360, -760},
    { -168, -264, -776},
    { -208, -232, -840},
    { -280, -200, -840},
    { -256, -160, -864},
    { -216, -216, -768},
    { -192, -152, -800},
    { -168, -216, -808},
    // 93 seconds
    { -192, -176, -840},
    { -192, -176, -904},
    { -208, -184, -984},
    { -240, -136, -1080},
    { -328, -48, -1272},
    { -424, -48, -1408},
    { -512, -120, -1424},
    { -432, -304, -1264},
    { -296, -224, -1136},
    { -304, -144, -944},
    { -304, -56, -896},
    { -272, -8, -792},
    { -232, -208, -600},
    { -256, -240, -520},
    { -296, -168, -464},
    { -352, -104, -440},
    { -512, 16, -488},
    { -656, 40, -464},
    { -776, -56, 64},
    { -1672, 504, -560},
    { -1984, 168, 32},
    { -1960, 168, -32},
    { -1560, 616, -208},
    { -928, 704, -440},
    { -1064, 32, -184},
    // 94 seconds
    { -1352, 192, -136},
    { -936, 168, -280},
    { -856, 136, -176},
    { -872, 248, -160},
    { -928, 176, 8},
    { -880, 696, 104},
    { -720, 728, -88},
    { -944, 704, 48},
    { -1160, 560, 56},
    { -2080, 584, 304},
    { -1136, 496, 88},
    { -712, 688, -104},
    { -1408, 568, 288},
    { -1472, 496, 304},
    { -1176, 528, 216},
    { -944, 552, 168},
    { -776, 296, 192},
    { -624, 232, 160},
    { -504, 184, 96},
    { -424, 224, 112},
    { -464, 184, 144},
    { -616, 208, 208},
    { -800, 192, 296},
    { -976, 224, 344},
    { -1680, 248, 472},
    // 95 seconds
    { -1896, 712, 472},
    { -1456, 432, 824},
    { -728, 792, -240},
    { -1056, 448, 64},
    { -1200, 360, 336},
    { -928, 264, 320},
    { -808, 352, 304},
    { -672, 336, 312},
    { -728, 320, 392},
    { -664, 392, 400},
    { -544, 408, 408},
    { -736, 496, 496},
    { -912, 424, 568},
    { -1600, 640, 568},
    { -1424, 488, 512},
    { -968, 520, 336},
    { -1248, 456, 464},
    { -1216, 376, 400},
    { -1040, 384, 344},
    { -840, 320, 280},
    { -760, 160, 272},
    { -672, 144, 232},
    { -560, 80, 200},
    { -568, 128, 176},
    { -632, 104, 240},
    // 96 seconds
    { -800, 72, 288},
    { -952, 208, 328},
    { -1328, 256, 368},
    { -1960, 552, 616},
    { -1336, 632, 272},
    { -1112, 696, -40},
    { -1040, 240, 216},
    { -1136, 176, 232},
    { -1056, 128, 72},
    { -952, 152, 240},
    { -800, 208, 256},
    { -720, 160, 232},
    { -696, 128, 192},
    { -616, 192, 184},
    { -872, 400, 200},
    { -1224, 416, 256},
    { -1504, 584, 256},
    { -1504, 704, -96},
    { -1096, 224, -136},
    { -1048, 320, -160},
    { -1384, 288, 16},
    { -1688, 264, 40},
    { -1416, 152, 112},
    { -1264, -32, 208},
    { -1120, -112, 200},
    // 97 seconds
    { -984, -72, 176},
    { -840, 0, 168},
    { -784, 40, 176},
    { -1024, 88, 264},
    { -960, 24, 160},
    { -1200, 56, 88},
    { -1192, 272, -128},
    { -1024, 288, -304},
    { -1144, 184, -288},
    { -1256, -136, -248},
    { -1392, -224, -176},
    { -1264, 8, -112},
    { -1120, 216, -48},
    { -1024, 296, -32},
    { -1136, 304, 8},
    { -1048, 328, -56},
    { -1016, 288, -80},
    { -1208, 408, 64},
    { -1296, 512, 160},
    { -1624, 304, 128},
    { -1112, 200, -112},
    { -968, 560, -304},
    { -1200, 568, -128},
    { -1504, 328, 88},
    { -1680, 136, 240},
    // 98 seconds
    { -1376, 16, 208},
    { -1280, 16, 184},
    { -1240, 72, 208},
    { -1008, 24, 208},
    { -960, 112, 232},
    { -888, 120, 208},
    { -992, 48, 296},
    { -928, -312, 328},
    { -1056, -384, 248},
    { -1264, 272, -8},
    { -1424, 312, 16},
    { -1456, 232, 72},
    { -1464, 64, 240},
    { -1424, 200, 264},
    { -1296, 416, 408},
    { -1080, 472, 432},
    { -1056, 304, 384},
    { -1112, 312, 328},
    { -960, 384, 328},
    { -816, 416, 280},
    { -976, 496, 504},
    { -1016, 544, 608},
    { -1376, 704, 520},
    { -1024, 232, 344},
    { -1040, 640, 224},
    // 99 seconds
    { -1336, 512, 272},
    { -1640, 336, 352},
    { -1592, 368, 344},
    { -1480, 304, 440},
    { -1344, 168, 480},
    { -1248, 136, 464},
    { -1096, 56, 416},
    { -920, 72, 312},
    { -896, 0, 272},
    { -848, -96, 376},
    { -632, -480, 648},
    { -1096, 520, -504},
    { -1208, 256, 384},
    { -1232, 664, 208},
    { -1488, 728, 176},
    { -1592, 448, 632},
    { -1416, 400, 584},
    { -1192, 384, 480},
    { -1072, 344, 416},
    { -1160, 352, 400},
    { -1208, 240, 440},
    { -1016, 240, 456},
    { -888, 256, 520},
    { -968, 328, 696},
    { -864, 512, 808},
    // 100 seconds
    { -1448, 584, 616},
    { -848, 392, 56},
    { -840, 560, 200},
    { -1088, 440, 360},
    { -1472, 440, 400},
    { -1488, 416, 304},
    { -1480, 256, 344},
    { -1528, 96, 336},
    { -1496, 8, 296},
    { -1352, 16, 224},
    { -1136, 16, 168},
    { -1024, 80, 152},
    { -1024, -176, 192},
    { -888, -616, 104},
    { -1264, 272, 40},
    { -1120, 288, -352},
    { -1456, 608, -240},
    { -1488, -16, 432},
    { -1536, -408, 360},
    { -1504, 184, 32},
    { -1344, 352, 120},
    { -1200, 336, 56},
    { -1216, 296, 48},
    { -1200, 264, 104},
    { -1096, 104, 336},
    // 101 seconds
    { -976, 328, 360},
    { -1032, 704, 232},
    { -1152, 736, 160},
    { -1304, 568, 72},
    { -888, 288, -48},
    { -1136, 512, 32},
    { -1384, 520, 144},
    { -1632, 368, 56},
    { -1560, 224, 64},
    { -1496, 80, 184},
    { -1456, 32, 176},
    { -1368, 40, 120},
    { -1216, 48, 112},
    { -1104, 88, 120},
    { -1096, 56, 128},
    { -752, -392, 96},
    { -840, -200, 40},
    { -1160, 216, -64},
    { -1328, 104, -120},
    { -1440, 256, -152},
    { -1480, -8, 160},
    { -1456, 8, 112},
    { -1304, 208, 112},
    { -1240, 336, 160},
    { -1240, 328, 152},
    // 102 seconds
    { -1304, 280, 184},
    { -1184, 264, 184},
    { -992, 240, 184},
    { -952, 296, 176},
    { -1048, 368, 288},
    { -1312, 440, 296},
    { -1280, 360, 136},
    { -704, 256, -72},
    { -1040, 368, 56},
    { -1480, 504, -80},
    { -1480, 352, -352},
    { -1256, 136, -224},
    { -1248, 48, -152},
    { -1264, 136, -96},
    { -1192, 160, -64},
    { -1072, 136, -16},
    { -984, 56, 56},
    { -960, 16, 96},
    { -864, 0, 104},
    { -992, 32, 144},
    { -1272, 112, 96},
    { -1408, 320, -184},
    { -1320, 400, -432},
    { -1064, -72, -128},
    { -1248, -416, -24},
    // 103 seconds
    { -1232, -8, -40},
    { -1048, 176, 56},
    { -936, 248, 96},
    { -936, 232, 152},
    { -1024, 240, 168},
    { -984, 192, 240},
    { -904, 176, 264},
    { -864, 208, 176},
    { -1000, 288, 128},
    { -1568, 352, 248},
    { -1576, 432, 264},
    { -816, 24, 0},
    { -800, 208, -8},
    { -1024, 344, -40},
    { -1112, 280, -120},
    { -976, 320, -416},
    { -1040, 320, -552},
    { -1112, 136, -152},
    { -1056, -40, -64},
    { -984, -24, -80},
    { -888, 40, -32},
    { -816, 88, -104},
    { -864, 216, -96},
    { -856, 224, -88},
    { -864, 376, -40},
    // 104 seconds
    { -1320, 520, 280},
    { -1576, 1032, 280},
    { -960, 1000, 296},
    { -656, 1000, 144},
    { -880, 904, 344},
    { -904, 840, 408},
    { -736, 728, 520},
    { -456, 648, 456},
    { -248, 560, 320},
    { -248, 440, 440},
    { -24, 368, 280},
    { 48, 304, 360},
    { 192, 528, 392},
    { 168, 520, 544},
    { 216, 800, 504},
    { 352, 800, 632},
    { 208, 880, 824},
    { 264, 904, 792},
    { 344, 800, 552},
    { 280, 536, 688},
    { 280, 576, 672},
    { 232, 576, 640},
    { 248, 536, 464},
    { 304, 440, 376},
    { 336, 392, 264},
    // 105 seconds
    { 360, 360, 216},
    { 384, 312, 152},
    { 384, 112, 344},
    { 96, 520, 72},
    { 24, 816, 536},
    { -144, 1400, 1272},
    { 32, 1384, 1256},
    { 224, 1296, 928},
    { 256, 1160, 552},
    { 56, 896, 360},
    { -48, 664, 368},
    { -96, 592, 288},
    { -88, 496, 216},
    { -64, 376, 200},
    { -72, 320, 192},
    { -96, 240, 128},
    { -128, 232, 240},
    { -192, 456, 320},
    { -408, 1008, 816},
    { -592, 1680, 1272},
    { -448, 2016, 1280},
    { -56, 2160, 720},
    { 240, 1432, 576},
    { 200, 1096, 368},
    { 16, 784, 592},
    // 106 seconds
    { -40, 656, 624},
    { -144, 648, 640},
    { -176, 472, 632},
    { -176, 488, 472},
    { -136, 352, 408},
    { -128, 296, 336},
    { -144, 288, 344},
    { -344, 536, 544},
    { -440, 712, 648},
    { -256, 1008, 464},
    { -104, 1016, 568},
    { 88, 1368, 848},
    { 216, 1600, 568},
    { 48, 1664, 192},
    { 88, 1296, 128},
    { 40, 856, 400},
    { 0, 672, 360},
    { -48, 616, 312},
    { -48, 496, 312},
    { 56, 336, 328},
    { 232, 352, 304},
    { 280, 488, 400},
    { 232, 848, 632},
    { 176, 1008, 760},
    { 144, 1136, 880},
    // 107 seconds
    { 112, 1240, 904},
    { 104, 984, 608},
    { 160, 760, 560},
    { 112, 720, 576},
    { 120, 688, 616},
    { 64, 640, 544},
    { 56, 560, 320},
    { 96, 416, 368},
    { 40, 456, 136},
    { 48, 536, 216},
    { 40, 552, 408},
    { 48, 776, 536},
    { 64, 848, 736},
    { 104, 1144, 944},
    { 152, 1376, 912},
    { 128, 1160, 728},
    { 80, 984, 376},
    { 32, 760, 376},
    { -32, 664, 384},
    { -64, 584, 312},
    { -32, 496, 304},
    { 32, 456, 248},
    { 88, 392, 280},
    { 152, 448, 320},
    { 144, 600, 448},
    // 108 seconds
    { 72, 848, 680},
    { 32, 1008, 928},
    { -8, 1312, 1192},
    { -80, 1168, 872},
    { 80, 760, 608},
    { 144, 784, 696},
    { 64, 872, 752},
    { -96, 792, 696},
    { -40, 640, 448},
    { -32, 440, 304},
    { -8, 288, 312},
    { -40, 392, 232},
    { -48, 344, 344},
    { -96, 632, 592},
    { -224, 1072, 744},
    { -192, 1184, 992},
    { -112, 1248, 936},
    { 24, 1064, 696},
    { 32, 936, 504},
    { -40, 800, 416},
    { -88, 736, 528},
    { -144, 672, 488},
    { -128, 504, 456},
    { -40, 432, 296},
    { 32, 368, 272},
    // 109 seconds
    { 96, 408, 312},
    { 112, 576, 480},
    { 72, 776, 736},
    { -24, 1008, 1072},
    { -64, 1176, 1184},
    { -64, 1040, 976},
    { 16, 768, 696},
    { 32, 632, 664},
    { 24, 640, 736},
    { -88, 696, 816},
    { -80, 576, 592},
    { -40, 456, 440},
    { 8, 360, 312},
    { -16, 336, 328},
    { -8, 432, 360},
    { -64, 584, 544},
    { -64, 512, 520},
    { -248, 784, 880},
    { -328, 1128, 1208},
    { -280, 1280, 1048},
    { -184, 1120, 832},
    { -136, 888, 528},
    { -160, 720, 488},
    { -160, 632, 448},
    { -136, 456, 408},
    // 110 seconds
    { -88, 416, 384},
    { -56, 320, 368},
    { -16, 280, 432},
    { -48, 304, 520},
    { -72, 600, 696},
    { -96, 824, 968},
    { -136, 1072, 1216},
    { -200, 1320, 1296},
    { -136, 1160, 960},
    { -64, 856, 824},
    { -24, 792, 824},
    { 0, 768, 904},
    { 40, 640, 728},
    { 56, 448, 536},
    { 32, 296, 376},
    { 48, 216, 208},
    { 64, -24, 352},
    { 104, -120, 176},
    { -376, 648, -64},
    { -176, 56, 224},
    { -784, 856, 1272},
    { -1032, 1184, 2080},
    { -552, 1200, 1744},
    { -128, 1312, 952},
    { -40, 1224, 608},
    // 111 seconds
    { -96, 800, 656},
    { -144, 616, 512},
    { -120, 576, 376},
    { -72, 376, 336},
    { -24, 240, 400},
    { 0, 264, 336},
    { 40, 232, 328},
    { 56, 200, 488},
    { 0, 408, 488},
    { -184, 744, 968},
    { -408, 960, 1304},
    { -448, 1352, 1392},
    { -240, 1112, 1016},
    { -48, 1008, 640},
    { -16, 872, 616},
    { -32, 856, 664},
    { -136, 760, 632},
    { -168, 640, 488},
    { -160, 488, 368},
    { -160, 344, 280},
    { -120, 248, 208},
    { -176, 176, 136},
    { -280, 208, 152},
    { -456, 176, 160},
    { -888, 272, 136},
    // 112 seconds
    { -1776, 320, 336},
    { -2728, 72, -16},
    { -2464, 256, -504},
    { -1672, 616, -112},
    { -792, -328, -472},
    { -1576, 288, 72},
    { -1136, 280, 48},
    { -728, 352, -24},
    { -592, 280, -56},
    { -688, 248, 8},
    { -664, 312, 16},
    { -880, 432, -176},
    { -1088, 416, 216},
    { -1208, 296, -256},
    { -1816, 328, -48},
    { -1368, 408, -120},
    { -1056, 480, -256},
    { -1376, 344, -32},
    { -1656, 280, 96},
    { -1728, 216, 152},
    { -1400, 88, 200},
    { -1160, 24, 176},
    { -1048, 48, 144},
    { -968, 96, 88},
    { -944, 296, -296},
    // 113 seconds
    { -928, 136, -120},
    { -848, -176, -40},
    { -520, -168, -240},
    { -760, -24, -328},
    { -936, 96, -304},
    { -1240, 80, -232},
    { -1936, 112, -200},
    { -2056, 240, -8},
    { -1248, 240, -128},
    { -928, 176, -168},
    { -1224, 216, -16},
    { -1184, 200, -88},
    { -1080, 280, -144},
    { -904, 392, -312},
    { -1064, 264, -128},
    { -1232, 864, 88},
    { -1056, 344, -184},
    { -1800, 360, 272},
    { -968, 424, -72},
    { -832, 472, -120},
    { -1232, 456, 72},
    { -1616, 376, 192},
    { -1560, 208, 176},
    { -1440, 56, 168},
    { -1280, 24, 160},
    // 114 seconds
    { -1208, 128, 216},
    { -1064, 160, 192},
    { -880, 224, 96},
    { -920, 208, 88},
    { -960, 144, 72},
    { -848, 80, 24},
    { -1016, 120, 16},
    { -1072, 312, -288},
    { -1168, 352, -248},
    { -1544, 216, -192},
    { -1712, 272, 72},
    { -1432, 400, -88},
    { -1096, 392, -64},
    { -1056, 376, 0},
    { -1080, 248, 72},
    { -1040, 208, 136},
    { -984, 232, 168},
    { -832, 232, 240},
    { -800, 216, 272},
    { -1040, 384, 328},
    { -1048, 456, 360},
    { -1408, 304, 352},
    { -1136, -8, 408},
    { -936, 640, 240},
    { -984, 736, -8},
    // 115 seconds
    { -1336, 656, 56},
    { -1488, 768, 0},
    { -1264, 1152, -56},
    { -1904, -464, 1224},
    { -1376, 112, 216},
    { -1096, 344, 96},
    { -768, 144, 96},
    { -680, 24, 128},
    { -712, 48, 184},
    { -760, 136, 256},
    { -1064, 400, 376},
    { -1144, 976, 640},
    { -872, 1616, 72},
    { -424, 1656, -40},
    { -504, 824, 520},
    { -448, 816, 440},
    { -504, 520, 576},
    { -328, 544, 520},
    { -296, 448, 608},
    { -176, 392, 544},
    { -40, 544, 528},
    { 24, 448, 544},
    { 80, 584, 520},
    { 128, 664, 536},
    { 160, 704, 504},
    // 116 seconds
    { 152, 696, 472},
    { 104, 808, 528},
    { 120, 928, 592},
    { 48, 1152, 848},
    { 24, 1184, 728},
    { 120, 1008, 576},
    { 112, 808, 608},
    { 128, 616, 608},
    { 200, 672, 632},
    { 152, 592, 576},
    { 152, 552, 512},
    { 152, 576, 464},
    { 168, 432, 360},
    { 128, 392, 384},
    { 144, 496, 360},
    { 152, 432, 360},
    { 192, 472, 248},
    { 8, 832, 672},
    { 160, 1120, 472},
    { 112, 1312, 1000},
    { 280, 1160, 496},
    { 208, 1208, 336},
    { 160, 1096, 136},
    { 64, 1008, 16},
    { -40, 920, -112},
    // 117 seconds
    { -40, 944, -320},
    { -8, 728, -408},
    { 80, 640, -536},
    { 152, 664, -696},
    { 232, 352, -592},
    { 216, 328, -744},
    { 128, 168, -744},
    { 216, 192, -936},
    { 104, 72, -952},
    { 96, 152, -1016},
    { 104, -88, -896},
    { 152, 56, -976},
    { 112, -208, -840},
    { 200, 8, -976},
    { 168, -40, -920},
    { 192, 8, -984},
    { 152, 0, -944},
    { 200, 16, -968},
    { 176, 8, -952},
    { 192, 32, -936},
    { 208, -80, -928},
    { 240, 32, -960},
    { 216, -16, -960},
    { 208, 8, -976},
    { 192, -40, -960},
    // 118 seconds
    { 200, -32, -968},
    { 176, -56, -944},
    { 176, -32, -968},
    { 176, -48, -968},
    { 184, -32, -976},
    { 176, -32, -968},
    { 176, -56, -952},
    { 168, -64, -968},
    { 168, -32, -968},
    { 168, -96, -960},
    { 168, -56, -976},
    { 160, -80, -968},
    { 160, -80, -960},
    { 176, -88, -960},
    { 168, -88, -968},
    { 160, -64, -968},
    { 168, -80, -968},
    { 168, -80, -960},
    { 160, -88, -976},
    { 160, -80, -960},
    { 160, -96, -968},
    { 168, -96, -960},
    { 168, -96, -960},
    { 168, -72, -960},
    { 152, -72, -952},
    // 119 seconds
    { 160, -64, -952},
    { 152, -112, -912},
    { 152, 56, -960},
    { 136, 24, -840},
    { 152, 296, -888},
    { 136, 432, -840},
    { 120, 336, -792},
    { 80, 576, -880},
    { 40, 504, -784},
    { 0, 456, -712},
    { -32, 760, -824},
    { 88, 272, -800},
    { 64, 528, -936},
    { 80, 216, -944},
    { 48, 296, -1024},
    { -16, 80, -984},
    { -48, 8, -976},
    { -80, -72, -1000},
    { -80, -152, -976},
    { -112, -232, -944},
    { -32, -112, -992},
    { -112, -216, -968},
    { -88, -128, -968},
    { -96, -184, -1024},
    { -112, -152, -984},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

