/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */



// ----------------------------------------------------------------
// Sample captured: 2015-10-01 09:29:53 local
AccelRawData *activity_sample_walk_100_pbl_25471_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25471_5
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -176, -104, -1008},
    { -192, -96, -992},
    { -192, -144, -1008},
    { -144, -176, -1016},
    { -136, -144, -1040},
    { -96, -104, -1040},
    { -168, -160, -992},
    { -176, -184, -968},
    { -208, -200, -960},
    { -192, -176, -1008},
    { -184, -208, -1024},
    { -216, -248, -1032},
    { -168, -160, -1056},
    { -232, -216, -1024},
    { -232, -176, -984},
    { -264, -208, -960},
    { -272, -152, -976},
    { -296, -144, -992},
    { -296, -144, -1040},
    { -208, -152, -1048},
    { -192, -88, -1056},
    { -104, 256, -696},
    { -128, -168, -1008},
    { -136, -176, -992},
    { -136, -144, -984},
    // 1 seconds
    { -144, -144, -984},
    { -136, -128, -1000},
    { -128, -112, -1008},
    { -120, -104, -1008},
    { -128, -80, -1024},
    { -136, -72, -1032},
    { -88, -72, -1016},
    { -56, 16, -944},
    { -32, 112, -960},
    { -184, 352, -864},
    { -216, 376, -808},
    { -216, 496, -904},
    { -104, 200, -1288},
    { 0, 368, -1240},
    { 32, 392, -1032},
    { 64, 576, -928},
    { 120, 424, -1032},
    { -112, 688, -1056},
    { -208, 384, -880},
    { -192, 624, -928},
    { -328, 744, -800},
    { -328, 488, -424},
    { -216, 800, -608},
    { -352, 936, -584},
    { -368, 952, -520},
    // 2 seconds
    { -376, 712, -376},
    { -368, 424, -264},
    { -296, 816, -336},
    { -304, 984, -392},
    { -248, 920, -320},
    { -304, 824, -272},
    { -376, 968, -208},
    { -352, 864, -368},
    { -488, 1352, -496},
    { -576, 912, -424},
    { -456, 400, -600},
    { -416, 40, -472},
    { -272, 0, -696},
    { -176, 104, -800},
    { -120, 272, -912},
    { -32, 352, -1104},
    { 0, 352, -1096},
    { -80, 344, -1040},
    { -160, 272, -920},
    { -200, 160, -784},
    { -184, 560, -840},
    { -120, 592, -888},
    { 8, 664, -848},
    { 24, 592, -720},
    { -112, 536, -560},
    // 3 seconds
    { -64, 992, -800},
    { -152, 1048, 296},
    { -200, 568, -432},
    { -288, 1312, 216},
    { 112, 696, -520},
    { 320, 1064, -824},
    { 200, 624, -736},
    { 384, 592, -496},
    { 464, 704, -352},
    { 456, 800, -416},
    { 480, 880, -328},
    { 512, 904, -408},
    { 576, 696, -336},
    { 696, 552, -352},
    { 896, 640, -592},
    { 928, 544, -448},
    { 888, 416, -352},
    { 920, 392, -224},
    { 808, 440, 16},
    { 1032, 456, 104},
    { 896, 408, -16},
    { 928, 496, -24},
    { 808, 336, -40},
    { 776, 272, -40},
    { 776, 312, -112},
    // 4 seconds
    { 760, 152, -192},
    { 872, 472, -168},
    { 744, 304, -64},
    { 944, 224, -88},
    { 1048, 88, 112},
    { 976, 208, 16},
    { 944, 648, -248},
    { 1080, 704, -624},
    { 1296, 296, -696},
    { 1344, 32, -280},
    { 1232, 432, -536},
    { 896, 504, -392},
    { 936, 720, -128},
    { 872, 752, -72},
    { 568, 520, -24},
    { 440, 616, 88},
    { 288, 744, 168},
    { 176, 824, 200},
    { 144, 1048, 48},
    { 72, 968, -16},
    { 8, 888, -192},
    { 8, 800, -416},
    { -16, 496, -704},
    { 136, 352, -976},
    { 304, 248, -752},
    // 5 seconds
    { 432, 360, -832},
    { 536, 680, -1032},
    { 776, 824, -1144},
    { 896, 560, -1104},
    { 824, 368, -1056},
    { 656, 232, -888},
    { 504, 264, -816},
    { 352, 240, -864},
    { 224, 232, -880},
    { 112, 216, -856},
    { 48, 248, -896},
    { 56, 336, -968},
    { 144, 432, -1064},
    { 136, 384, -920},
    { -32, 512, -800},
    { -128, 608, -728},
    { -16, 1000, -968},
    { 568, 1608, -1392},
    { 792, 1496, -1208},
    { 784, 1208, -960},
    { 632, 848, -744},
    { 528, 640, -792},
    { 408, 440, -664},
    { 416, 320, -640},
    { 360, 168, -568},
    // 6 seconds
    { 424, 264, -656},
    { 416, 168, -632},
    { 248, 144, -616},
    { 200, 376, -600},
    { 160, 456, -640},
    { 216, 760, -768},
    { 352, 1224, -912},
    { 288, 1080, -968},
    { 128, 920, -800},
    { -32, 840, -648},
    { -136, 816, -640},
    { -192, 888, -560},
    { -304, 888, -512},
    { -392, 848, -456},
    { -448, 1072, -432},
    { -120, 1200, -528},
    { -184, 1416, -480},
    { 360, 1776, -608},
    { 512, 1488, -536},
    { 520, 1352, -424},
    { 472, 1056, -344},
    { 344, 664, -424},
    { 192, 456, -416},
    { 120, 392, -384},
    { 48, 312, -368},
    // 7 seconds
    { 104, 72, -344},
    { 256, -80, -360},
    { 592, -224, -432},
    { 744, -144, -416},
    { 792, -32, -408},
    { 1296, 208, -472},
    { 1712, 216, -384},
    { 2408, 376, -440},
    { 2176, 456, -328},
    { 1664, 472, -416},
    { 1312, 280, -312},
    { 1240, 336, -280},
    { 1224, 232, -152},
    { 1056, 408, -184},
    { 1056, 608, -216},
    { 1104, 1032, -168},
    { 744, 752, -432},
    { 928, 976, -200},
    { 1008, 640, -280},
    { 1200, 616, -296},
    { 1680, 608, -192},
    { 2144, 368, -120},
    { 1976, 192, -64},
    { 1688, 120, -72},
    { 1632, 152, -104},
    // 8 seconds
    { 1400, 128, -144},
    { 1256, 144, -240},
    { 1064, 40, -240},
    { 904, -160, -176},
    { 552, -288, -152},
    { 360, -240, -176},
    { 680, -48, -184},
    { 776, -8, -256},
    { 1312, 112, -272},
    { 1768, 128, -456},
    { 1920, 240, -392},
    { 1592, 288, -336},
    { 1312, 472, -328},
    { 1312, 368, -368},
    { 1296, 520, -208},
    { 1232, 664, -88},
    { 1000, 1160, 0},
    { 848, 776, -88},
    { 976, 1064, 88},
    { 1000, 728, -48},
    { 1464, 712, -168},
    { 1616, 576, -160},
    { 1648, 432, -184},
    { 1568, 240, -136},
    { 1480, 208, -176},
    // 9 seconds
    { 1552, 200, -264},
    { 1376, -8, -416},
    { 1032, -200, -192},
    { 896, -344, -144},
    { 760, -368, -192},
    { 408, -272, -200},
    { 824, 32, -136},
    { 960, 80, -328},
    { 1264, 168, -296},
    { 1840, 256, -680},
    { 1984, 552, -776},
    { 1504, 376, -568},
    { 1104, 320, -496},
    { 880, 456, -480},
    { 768, 472, -352},
    { 760, 744, -136},
    { 896, 912, -104},
    { 888, 704, -104},
    { 784, 856, 0},
    { 1168, 736, 0},
    { 1264, 536, -168},
    { 1768, 616, -104},
    { 2040, 320, -136},
    { 1616, 272, -128},
    { 1424, 232, -168},
    // 10 seconds
    { 1176, 280, -256},
    { 1104, 176, -264},
    { 984, 24, -296},
    { 904, -120, -256},
    { 888, -272, -256},
    { 688, -368, -200},
    { 512, -304, -288},
    { 864, 0, -288},
    { 864, -24, -352},
    { 1336, 152, -400},
    { 1976, 240, -560},
    { 2192, 464, -624},
    { 1528, 432, -368},
    { 944, 352, -520},
    { 960, 320, -408},
    { 808, 640, -248},
    { 752, 712, -160},
    { 848, 864, -168},
    { 864, 792, -40},
    { 576, 728, 0},
    { 1152, 792, 120},
    { 1352, 456, -200},
    { 1960, 608, -256},
    { 1824, 400, -360},
    { 1544, 368, -328},
    // 11 seconds
    { 1200, 272, -280},
    { 1096, 248, -288},
    { 1032, 184, -280},
    { 912, 120, -280},
    { 944, -40, -264},
    { 1000, -232, -88},
    { 816, -296, -144},
    { 496, -264, -256},
    { 672, -24, -232},
    { 920, 16, -328},
    { 1264, 112, -264},
    { 1952, 248, -576},
    { 2240, 392, -656},
    { 1616, 448, -520},
    { 1064, 392, -496},
    { 1000, 304, -392},
    { 832, 544, -320},
    { 640, 704, -120},
    { 768, 912, -72},
    { 816, 664, -88},
    { 760, 888, 120},
    { 1328, 760, 24},
    { 1456, 560, -192},
    { 1840, 656, -104},
    { 2024, 432, -104},
    // 12 seconds
    { 1720, 320, -128},
    { 1568, 328, -144},
    { 1328, 152, -96},
    { 1224, 144, -192},
    { 1016, 40, -200},
    { 952, -88, -192},
    { 904, -216, -184},
    { 696, -312, -208},
    { 400, -280, -264},
    { 920, -96, -224},
    { 952, -56, -360},
    { 1400, 80, -360},
    { 1848, 176, -448},
    { 1952, 336, -440},
    { 1616, 336, -328},
    { 1264, 352, -360},
    { 1312, 248, -216},
    { 1328, 472, -176},
    { 1248, 752, -128},
    { 968, 1120, -80},
    { 728, 816, -152},
    { 1088, 944, -72},
    { 1040, 584, -216},
    { 1424, 672, -208},
    { 1648, 480, -184},
    // 13 seconds
    { 1752, 384, -192},
    { 1640, 328, -112},
    { 1752, 216, -72},
    { 1664, 104, -88},
    { 1400, 64, -112},
    { 1248, -112, -208},
    { 1016, -272, -48},
    { 736, -352, -56},
    { 400, -336, -104},
    { 544, -160, -80},
    { 928, -72, -216},
    { 1120, 64, -264},
    { 1552, 104, -440},
    { 1888, 256, -632},
    { 1904, 544, -560},
    { 1464, 488, -472},
    { 1088, 808, -480},
    { 832, 1104, -424},
    { 576, 1048, -320},
    { 520, 1160, -264},
    { 488, 944, -320},
    { 1424, 1008, -312},
    { 2152, 560, -288},
    { 2040, 288, -280},
    { 1880, 56, -328},
    // 14 seconds
    { 1384, -248, -192},
    { 1064, -472, 8},
    { 824, -496, -16},
    { 776, -336, -88},
    { 512, -296, -112},
    { 440, -160, -168},
    { 528, -40, -152},
    { 728, 32, -192},
    { 800, 72, -280},
    { 728, 40, -336},
    { 1744, 224, -304},
    { 1648, 88, -480},
    { 1560, 184, -1000},
    { 1144, 152, -736},
    { 824, -64, -640},
    { 656, -88, -528},
    { 488, 104, -448},
    { 360, 216, -376},
    { 360, 248, -352},
    { 600, 408, -296},
    { 776, 440, -248},
    { 752, 440, -192},
    { 1736, 640, -288},
    { 1608, 384, -232},
    { 1552, 240, -160},
    // 15 seconds
    { 1416, 248, -224},
    { 1056, 176, -240},
    { 760, 144, -192},
    { 688, 96, -216},
    { 720, 136, -248},
    { 792, 80, -256},
    { 968, 72, -280},
    { 1088, -40, -232},
    { 776, -216, -200},
    { 1064, -56, -144},
    { 1080, -88, -280},
    { 1328, 32, -344},
    { 1696, 96, -528},
    { 1552, 56, -480},
    { 1136, 136, -360},
    { 824, 56, -360},
    { 896, 144, -312},
    { 800, 264, -232},
    { 776, 416, -176},
    { 864, 584, -208},
    { 944, 664, -80},
    { 880, 576, -104},
    { 1304, 992, 16},
    { 1152, 504, -240},
    { 1328, 592, -192},
    // 16 seconds
    { 1720, 488, -160},
    { 1584, 344, -64},
    { 1336, 160, -96},
    { 1320, 128, -72},
    { 1160, 192, -48},
    { 1056, 120, -24},
    { 1000, 0, -120},
    { 1056, -88, -176},
    { 904, -136, -120},
    { 672, -208, -168},
    { 768, -136, -208},
    { 864, -64, -176},
    { 1104, 24, -264},
    { 1568, 144, -448},
    { 1816, 200, -504},
    { 1648, 232, -400},
    { 1280, 272, -344},
    { 1168, 280, -304},
    { 968, 296, -288},
    { 912, 440, -240},
    { 1040, 584, -176},
    { 912, 896, -64},
    { 808, 624, -184},
    { 1352, 952, -112},
    { 1240, 480, -264},
    // 17 seconds
    { 1440, 560, -240},
    { 1648, 464, -248},
    { 1568, 176, -160},
    { 1416, 96, -176},
    { 1312, -56, -120},
    { 1184, 64, -176},
    { 1056, 24, -224},
    { 1000, -48, -272},
    { 928, -144, -256},
    { 920, -104, -360},
    { 640, -144, -336},
    { 920, 0, -304},
    { 808, 8, -304},
    { 1016, 112, -280},
    { 1456, 200, -416},
    { 1520, 296, -448},
    { 1296, 272, -352},
    { 1096, 296, -320},
    { 1080, 384, -392},
    { 1000, 624, -280},
    { 992, 752, -272},
    { 1064, 784, -224},
    { 992, 776, -168},
    { 800, 616, -168},
    { 1424, 848, -256},
    // 18 seconds
    { 1192, 472, -320},
    { 1672, 536, -432},
    { 1400, 376, -368},
    { 1224, 160, -224},
    { 1128, 80, -264},
    { 1024, 32, -168},
    { 960, 56, -160},
    { 800, 24, -96},
    { 736, -40, -144},
    { 912, 8, -176},
    { 880, -32, -216},
    { 1128, 24, -160},
    { 1024, -16, -328},
    { 1112, 16, -352},
    { 1480, 48, -672},
    { 1512, 8, -720},
    { 1136, 8, -616},
    { 920, -48, -528},
    { 888, 48, -528},
    { 856, 272, -432},
    { 872, 416, -464},
    { 1096, 640, -320},
    { 1024, 688, -344},
    { 800, 520, -248},
    { 1152, 824, -208},
    // 19 seconds
    { 1344, 528, -272},
    { 1512, 424, -392},
    { 1624, 416, -400},
    { 1608, 312, -272},
    { 1440, 144, -176},
    { 1240, 224, -144},
    { 1216, 208, -88},
    { 1224, 384, -176},
    { 1272, 504, -144},
    { 1304, 536, -88},
    { 1096, 520, -168},
    { 616, 480, -136},
    { 448, 464, -264},
    { -48, 552, -424},
    { -224, 776, -768},
    { -144, 1064, -848},
    { -48, 736, -880},
    { -136, 584, -800},
    { -176, 456, -808},
    { -376, 344, -952},
    { -384, 576, -456},
    { -800, 280, -360},
    { -536, 168, -336},
    { -592, 424, -480},
    { -512, 824, -760},
    // 20 seconds
    { -832, 1544, -864},
    { -784, 1520, -824},
    { -328, 784, -1112},
    { -264, 528, -1264},
    { -248, 160, -968},
    { -344, -16, -640},
    { -432, -224, -440},
    { -360, 48, -320},
    { -192, 128, -224},
    { -8, -8, -192},
    { 464, -64, -216},
    { 968, 96, -344},
    { 1280, 168, -240},
    { 2064, 304, -224},
    { 2712, 600, -360},
    { 2744, 616, -464},
    { 2344, 624, -448},
    { 1616, 504, -80},
    { 1544, 104, 16},
    { 1488, 376, -160},
    { 1248, 456, -168},
    { 1080, 592, 48},
    { 1136, 672, 296},
    { 928, 968, 720},
    { 464, 1160, 144},
    // 21 seconds
    { 888, 880, 536},
    { 1248, 856, 240},
    { 1816, 880, 48},
    { 2400, 968, 88},
    { 2816, 632, 152},
    { 2752, 328, 280},
    { 2528, 128, 280},
    { 1744, -128, 88},
    { 1432, 56, -232},
    { 1520, 8, -224},
    { 1168, -408, 280},
    { 664, -336, 152},
    { 400, -352, -128},
    { 616, -280, 152},
    { 728, 8, -8},
    { 1256, 136, -96},
    { 2032, 136, -248},
    { 2992, 152, -352},
    { 2944, 288, -464},
    { 1888, 688, -464},
    { 1568, 440, -592},
    { 1424, 528, -328},
    { 1224, 920, -80},
    { 680, 1800, 328},
    { 664, 840, -8},
    // 22 seconds
    { 784, 1248, 304},
    { 1272, 872, 248},
    { 1952, 952, -56},
    { 2328, 640, -104},
    { 2664, 440, -160},
    { 2440, 304, -56},
    { 2256, 112, 48},
    { 1816, -56, -64},
    { 1448, -136, -160},
    { 1088, -384, -64},
    { 1112, -440, 16},
    { 640, -568, 8},
    { 408, -480, 96},
    { 664, -288, 64},
    { 704, -96, -48},
    { 1416, 128, -176},
    { 2472, 200, -376},
    { 3232, 336, -344},
    { 2784, 496, -552},
    { 1904, 608, -296},
    { 1512, 488, -400},
    { 1288, 504, -384},
    { 968, 688, -144},
    { 736, 1248, 32},
    { 552, 1264, 32},
    // 23 seconds
    { 632, 848, 96},
    { 1184, 1112, 136},
    { 1664, 760, -152},
    { 2232, 768, -80},
    { 3168, 680, 0},
    { 2832, 296, 200},
    { 2272, 64, 96},
    { 1808, 24, -80},
    { 1480, 56, -176},
    { 1240, -40, -200},
    { 1056, -344, -72},
    { 952, -592, 0},
    { 688, -536, -56},
    { 576, -376, 72},
    { 720, -240, -72},
    { 1080, 152, -248},
    { 1952, 320, -392},
    { 2928, 176, -360},
    { 3248, 416, -496},
    { 2384, 712, -656},
    { 1600, 704, -504},
    { 1360, 512, -216},
    { 1264, 672, 16},
    { 872, 880, 416},
    { 624, 1128, 752},
    // 24 seconds
    { 504, 936, 408},
    { 1056, 944, 560},
    { 1392, 776, 96},
    { 1792, 824, 160},
    { 2720, 952, 8},
    { 2728, 424, -216},
    { 2512, 136, -56},
    { 2080, -240, -192},
    { 1472, -640, 48},
    { 1120, -376, -120},
    { 936, -480, 80},
    { 728, -400, 96},
    { 472, -352, 16},
    { 368, -168, -128},
    { 816, 120, -184},
    { 1304, 512, -640},
    { 1888, 600, -752},
    { 2056, 728, -1144},
    { 1704, 656, -712},
    { 1192, 616, -472},
    { 848, 864, -528},
    { 432, 880, -336},
    { 272, 832, -344},
    { 480, 760, -248},
    { 464, 720, -248},
    // 25 seconds
    { 1592, 936, -240},
    { 1936, 592, -192},
    { 1904, 384, 152},
    { 1792, 400, -160},
    { 1352, 472, -120},
    { 1000, 416, -192},
    { 928, 272, -160},
    { 832, 152, -56},
    { 768, 112, -56},
    { 952, 32, -96},
    { 1064, -96, -128},
    { 824, -184, -80},
    { 1336, -112, 112},
    { 1040, 96, -384},
    { 1224, 120, -520},
    { 1552, 16, -472},
    { 1768, 24, -544},
    { 1408, 88, -368},
    { 1104, 120, -296},
    { 1080, 176, -408},
    { 1032, 232, -168},
    { 1048, 456, -8},
    { 1264, 680, 96},
    { 1088, 1008, 168},
    { 664, 880, 48},
    // 26 seconds
    { 1096, 976, 376},
    { 1120, 776, 8},
    { 1400, 768, -48},
    { 1928, 784, 0},
    { 2152, 488, 16},
    { 2000, 128, 248},
    { 1848, 24, 144},
    { 1584, -80, -136},
    { 1216, -80, -160},
    { 960, 0, -168},
    { 896, -56, -256},
    { 864, -232, -184},
    { 552, -400, -104},
    { 400, -256, -216},
    { 904, -88, -168},
    { 1040, 56, -312},
    { 1728, 80, -320},
    { 2624, 120, -432},
    { 2384, 280, -392},
    { 1472, 400, -368},
    { 1224, 264, -248},
    { 1328, 248, -232},
    { 1296, 360, -192},
    { 1144, 568, 16},
    { 1064, 1032, 112},
    // 27 seconds
    { 624, 1424, -96},
    { 664, 824, 8},
    { 1040, 976, -56},
    { 1288, 696, -336},
    { 2136, 792, -72},
    { 2632, 448, 32},
    { 2176, 272, 0},
    { 1592, 72, -112},
    { 1352, -40, -80},
    { 1136, 104, -176},
    { 1048, 72, -208},
    { 960, 80, -224},
    { 856, -16, -216},
    { 696, -160, -168},
    { 480, -192, -152},
    { 296, -144, -288},
    { 1000, -40, -88},
    { 1288, 120, -336},
    { 2000, 200, -488},
    { 2536, 200, -440},
    { 2096, 424, -344},
    { 1384, 352, -200},
    { 1336, 384, -384},
    { 1280, 248, -200},
    { 1152, 440, -120},
    // 28 seconds
    { 1064, 552, 88},
    { 1048, 808, 312},
    { 928, 1112, 368},
    { 640, 624, 24},
    { 880, 816, 408},
    { 1032, 704, 56},
    { 1472, 760, 8},
    { 2240, 800, 56},
    { 2384, 576, 80},
    { 2144, -32, 280},
    { 1896, 128, 40},
    { 1560, -24, -88},
    { 1336, -88, -232},
    { 1136, -128, -272},
    { 976, -280, -136},
    { 704, -448, -24},
    { 384, -352, -216},
    { 768, -176, -136},
    { 848, 32, -304},
    { 1384, 272, -416},
    { 2016, 440, -480},
    { 1744, 1048, -392},
    { 888, 1008, -432},
    { 496, 888, -432},
    { 416, 1144, -336},
    // 29 seconds
    { 408, 1040, -256},
    { 424, 936, -240},
    { 680, 968, -192},
    { 784, 856, -176},
    { 1232, 848, -224},
    { 1968, 760, -192},
    { 1584, 608, -352},
    { 1464, 232, -128},
    { 1136, 312, -240},
    { 720, 192, -296},
    { 656, 192, -352},
    { 624, 144, -376},
    { 672, 64, -384},
    { 720, -24, -368},
    { 728, -80, -296},
    { 848, -88, -248},
    { 720, -8, -160},
    { 816, -16, -112},
    { 1304, 120, -128},
    { 1472, 296, -128},
    { 1864, 408, -104},
    { 1744, 528, -64},
    { 1152, 456, -80},
    { 952, 336, -152},
    { 952, 328, -64},
    // 30 seconds
    { 968, 352, 24},
    { 984, 416, -8},
    { 1000, 328, -24},
    { 1056, 520, 80},
    { 1072, 1056, 120},
    { 1264, 1688, 56},
    { 1088, 560, 40},
    { 1192, 800, -144},
    { 1664, 1032, -32},
    { 1784, 520, -56},
    { 1744, 208, 128},
    { 1776, 72, -24},
    { 1448, -152, -8},
    { 1288, -112, -256},
    { 1136, -24, -272},
    { 1232, -32, -320},
    { 888, -392, -40},
    { 432, -448, -16},
    { 640, -328, -128},
    { 1248, -16, -176},
    { 1536, 72, -240},
    { 1880, 120, -224},
    { 1960, 200, -280},
    { 1824, 216, -176},
    { 1600, 312, -72},
    // 31 seconds
    { 1480, 400, 32},
    { 1384, 528, -72},
    { 1264, 472, -16},
    { 1024, 608, 80},
    { 832, 952, 104},
    { 688, 704, 96},
    { 1080, 992, 352},
    { 1056, 816, 120},
    { 1360, 688, 0},
    { 1904, 768, 88},
    { 2064, 728, 120},
    { 2128, 528, 192},
    { 2224, 176, 96},
    { 1952, -24, 8},
    { 1592, 8, -152},
    { 1336, -32, -224},
    { 1240, -312, -120},
    { 752, -480, 24},
    { 464, -424, -80},
    { 824, -168, 24},
    { 1160, 144, -344},
    { 1616, 200, -352},
    { 2144, 200, -168},
    { 2368, 232, -160},
    { 1888, 496, -192},
    // 32 seconds
    { 1360, 656, -40},
    { 1520, 392, -136},
    { 1592, 400, -136},
    { 1560, 504, 32},
    { 1376, 968, 368},
    { 864, 1368, 344},
    { 1056, 832, 424},
    { 792, 840, 168},
    { 1104, 608, 0},
    { 1824, 856, 112},
    { 2232, 856, 112},
    { 2304, 472, 184},
    { 2264, 184, 176},
    { 1936, 72, 96},
    { 1552, -32, -96},
    { 1320, 24, -184},
    { 1280, -8, -256},
    { 824, -280, -16},
    { 648, -216, -88},
    { 832, -168, -72},
    { 1104, 88, -448},
    { 1168, 16, -344},
    { 1432, -16, -192},
    { 1480, 40, -80},
    { 1496, 256, -96},
    // 33 seconds
    { 1496, 440, -128},
    { 1512, 496, -152},
    { 1608, 512, -88},
    { 1624, 456, -16},
    { 1368, 712, -56},
    { 1408, 1328, -344},
    { 992, 848, -136},
    { 928, 1024, -48},
    { 784, 928, -200},
    { 1184, 544, -272},
    { 1552, 528, -128},
    { 1760, 488, -56},
    { 1776, 368, -96},
    { 1784, 288, -40},
    { 1720, 224, -16},
    { 1576, 208, -120},
    { 1400, 120, -112},
    { 1200, -40, -192},
    { 1000, -168, -288},
    { 696, -384, -160},
    { 480, -384, -328},
    { 840, -224, -312},
    { 1096, -8, -368},
    { 1360, 8, -328},
    { 1792, -40, -376},
    // 34 seconds
    { 1816, 8, -184},
    { 1656, 280, -184},
    { 1328, 328, -208},
    { 1224, 464, -208},
    { 1368, 464, -208},
    { 1352, 512, -184},
    { 1208, 624, -16},
    { 1176, 808, 0},
    { 944, 912, 56},
    { 920, 832, 192},
    { 800, 808, 40},
    { 1048, 624, -104},
    { 1512, 680, 40},
    { 1912, 480, 136},
    { 1992, 320, 56},
    { 1832, 104, 96},
    { 1672, 40, 8},
    { 1448, 16, -88},
    { 1168, 64, -96},
    { 1008, 152, -128},
    { 928, -40, -200},
    { 704, -168, -136},
    { 504, -192, -312},
    { 704, -160, -360},
    { 872, -88, -344},
    // 35 seconds
    { 1184, -96, -376},
    { 1568, -24, -352},
    { 1872, 72, -368},
    { 1592, 240, -280},
    { 1288, 320, -304},
    { 1104, 424, -192},
    { 1160, 384, -136},
    { 1080, 400, -152},
    { 928, 504, -136},
    { 976, 592, -72},
    { 1344, 664, -152},
    { 1248, 680, -136},
    { 1008, 752, -96},
    { 936, 728, -184},
    { 976, 584, -288},
    { 1192, 464, -184},
    { 1576, 448, 8},
    { 1704, 344, 0},
    { 1656, 152, 32},
    { 1600, 72, -24},
    { 1376, 96, -64},
    { 1208, 144, -96},
    { 1008, 184, -96},
    { 928, 136, -192},
    { 720, 72, -264},
    // 36 seconds
    { 656, 32, -264},
    { 512, -56, -312},
    { 696, -128, -408},
    { 768, -128, -336},
    { 1032, -88, -344},
    { 1376, 24, -360},
    { 1576, 104, -392},
    { 1416, 224, -384},
    { 1120, 360, -360},
    { 1104, 392, -312},
    { 1152, 408, -248},
    { 1080, 504, -208},
    { 1024, 536, -240},
    { 1008, 560, -272},
    { 1280, 744, -272},
    { 1272, 864, -200},
    { 1080, 848, -96},
    { 912, 816, -120},
    { 984, 560, -248},
    { 1248, 472, -184},
    { 1648, 464, 0},
    { 1904, 320, 32},
    { 1800, 104, -32},
    { 1512, 72, -104},
    { 1296, 88, -168},
    // 37 seconds
    { 1112, 32, -240},
    { 920, 8, -240},
    { 728, -88, -344},
    { 712, -168, -352},
    { 608, -200, -464},
    { 504, -280, -544},
    { 784, -240, -440},
    { 1176, -232, -368},
    { 1704, -64, -512},
    { 1944, -96, -448},
    { 1808, 72, -288},
    { 1248, 288, -288},
    { 1104, 280, -224},
    { 1160, 304, -256},
    { 1200, 280, -240},
    { 1136, 408, -176},
    { 1136, 456, -88},
    { 1088, 720, -48},
    { 552, 1248, -8},
    { 472, 448, -152},
    { 696, 936, 160},
    { 1048, 936, -104},
    { 1432, 600, -304},
    { 2040, 536, -104},
    { 2248, 336, -128},
    // 38 seconds
    { 1968, 56, -88},
    { 1696, -24, -272},
    { 1424, 8, -304},
    { 1136, -64, -280},
    { 1096, -184, -368},
    { 1008, -440, 0},
    { 824, -424, -232},
    { 496, -536, -216},
    { 520, -64, -488},
    { 840, -88, -192},
    { 1120, -96, -240},
    { 1664, -56, -240},
    { 1944, 480, -1064},
    { 1688, 600, -568},
    { 1040, 504, -456},
    { 960, 456, -280},
    { 1120, 520, -248},
    { 1088, 560, -24},
    { 1096, 632, -16},
    { 944, 496, 72},
    { 608, 776, -96},
    { 648, 592, -224},
    { 904, 728, -176},
    { 968, 920, -368},
    { 1128, 1096, -416},
    // 39 seconds
    { 1400, 1024, -336},
    { 1392, 656, -320},
    { 1088, 520, -280},
    { 856, 320, -248},
    { 696, 208, -256},
    { 640, 136, -240},
    { 768, 160, -296},
    { 968, 136, -448},
    { 1096, -168, -448},
    { 904, -512, -400},
    { 968, -360, -456},
    { 1120, -104, -424},
    { 1016, -64, -536},
    { 1128, -112, -608},
    { 1136, -208, -632},
    { 1216, -104, -584},
    { 1072, 32, -400},
    { 1024, 80, -448},
    { 992, 160, -472},
    { 960, 400, -520},
    { 1032, 328, -600},
    { 1144, 488, -792},
    { 1112, 504, -728},
    { 792, 576, -576},
    { 544, 408, -400},
    // 40 seconds
    { 680, 472, -216},
    { 880, 736, -176},
    { 1504, 488, -232},
    { 2168, 400, 48},
    { 2216, 360, -88},
    { 1928, 160, 96},
    { 1672, 208, -136},
    { 1464, 296, -136},
    { 1288, 200, -144},
    { 1128, 64, -208},
    { 960, -48, -264},
    { 808, -264, -160},
    { 784, -320, -208},
    { 664, -232, -392},
    { 512, -216, -448},
    { 920, -120, -328},
    { 1352, -24, -392},
    { 1928, 8, -440},
    { 2304, 8, -456},
    { 1912, 336, -208},
    { 1344, 488, -168},
    { 1192, 328, -160},
    { 1232, 480, -112},
    { 1224, 424, -128},
    { 1056, 400, -80},
    // 41 seconds
    { 1016, 448, 40},
    { 760, 784, 96},
    { 368, 992, -112},
    { 760, 456, 200},
    { 1024, 856, 0},
    { 1416, 760, -120},
    { 1912, 688, 0},
    { 2368, 552, 56},
    { 2112, 288, 208},
    { 1776, 48, 168},
    { 1480, 24, -8},
    { 1192, 160, -56},
    { 1000, 88, -80},
    { 880, -32, -112},
    { 800, -88, -144},
    { 824, -56, -208},
    { 600, -128, -216},
    { 656, -96, -200},
    { 896, 40, -200},
    { 1312, 152, -272},
    { 1832, 144, -376},
    { 2096, 96, -432},
    { 1704, 176, -336},
    { 1200, 352, -168},
    { 1000, 288, -240},
    // 42 seconds
    { 1120, 376, -184},
    { 1168, 480, -288},
    { 1128, 424, -248},
    { 1040, 640, -120},
    { 624, 1016, -448},
    { 568, 480, -128},
    { 968, 872, -16},
    { 1392, 664, -264},
    { 1480, 520, -192},
    { 1928, 424, -96},
    { 2024, 288, -64},
    { 1784, 184, -32},
    { 1536, 208, 24},
    { 1336, 144, -56},
    { 1096, 160, -104},
    { 928, 8, -104},
    { 816, -24, -128},
    { 824, -32, -112},
    { 728, -8, -224},
    { 584, -24, -256},
    { 608, -48, -264},
    { 976, 8, -224},
    { 1336, 24, -392},
    { 1808, 16, -432},
    { 2184, 24, -512},
    // 43 seconds
    { 1744, 200, -456},
    { 1096, 448, -360},
    { 984, 312, -296},
    { 1144, 304, -208},
    { 1064, 424, -256},
    { 928, 480, -208},
    { 880, 552, -240},
    { 688, 528, -288},
    { 504, 304, -304},
    { 536, 248, -56},
    { 1040, 384, -128},
    { 1328, 432, -224},
    { 1352, 392, -216},
    { 1896, 320, -224},
    { 1648, -32, -120},
    { 1360, 304, -128},
    { 1240, 192, -40},
    { 944, 256, -40},
    { 832, 96, 184},
    { 784, 16, 104},
    { 760, -48, 232},
    { 784, -96, 328},
    { 848, 24, 480},
    { 984, 312, 256},
    { 1312, 288, 208},
    // 44 seconds
    { 1904, 104, 88},
    { 2272, 1056, -288},
    { 2296, 432, -744},
    { 1160, 1152, -856},
    { 1136, 368, -56},
    { 1128, 208, 360},
    { 536, 608, 384},
    { 272, 480, 32},
    { 48, 96, 280},
    { 0, -216, 488},
    { 80, -144, -216},
    { 464, 432, -368},
    { 464, 904, -256},
    { 680, 672, -488},
    { 760, 744, -848},
    { 928, 528, 160},
    { 1624, 424, -32},
    { 1472, 552, -200},
    { 1064, 800, 120},
    { 880, 720, 464},
    { 720, 376, 136},
    { 376, 160, 56},
    { 328, 64, 120},
    { 504, 264, 464},
    { 440, 368, 488},
    // 45 seconds
    { 400, 224, 560},
    { 392, 264, 440},
    { 616, 448, 648},
    { 656, 720, 712},
    { 568, 688, 760},
    { 712, 544, 592},
    { 1128, 688, 440},
    { 1640, 264, 488},
    { 1704, 240, 424},
    { 1240, 536, 608},
    { 664, 56, 472},
    { 280, 248, 552},
    { 128, 184, 328},
    { 168, 144, 112},
    { 312, 192, 88},
    { 416, 632, -48},
    { 528, 736, -152},
    { 544, 624, 256},
    { 488, 376, -64},
    { 536, 1240, -352},
    { 432, 1088, -128},
    { 512, 1272, 256},
    { 736, 1016, -24},
    { 1016, -64, -720},
    { 1048, -288, -856},
    // 46 seconds
    { 864, 248, -576},
    { 800, 1016, -560},
    { 920, 1152, -784},
    { 760, 584, -592},
    { 824, 272, -664},
    { 856, 264, -648},
    { 968, 304, -696},
    { 872, 216, -560},
    { 672, 0, -408},
    { 728, -56, -256},
    { 912, -88, 24},
    { 1272, 200, -96},
    { 1432, 512, -664},
    { 1352, 288, -392},
    { 1224, 112, -168},
    { 1288, 88, -272},
    { 1240, 240, -272},
    { 1144, 488, -232},
    { 1224, 408, -112},
    { 1240, 560, -304},
    { 1112, 384, -288},
    { 832, 432, -256},
    { 544, 376, -184},
    { 624, 544, -72},
    { 944, 856, 8},
    // 47 seconds
    { 976, 864, -288},
    { 1200, 336, -96},
    { 1544, 616, -8},
    { 1872, 496, -128},
    { 1728, 184, 8},
    { 1512, 64, 0},
    { 1360, 120, -136},
    { 1208, 128, -176},
    { 1216, 88, -232},
    { 1224, 64, -72},
    { 928, 40, -240},
    { 744, 16, -288},
    { 840, -32, -72},
    { 952, 0, -8},
    { 1248, 160, -448},
    { 1296, 168, -440},
    { 1304, 72, -408},
    { 1128, -16, -416},
    { 992, 96, -432},
    { 912, 152, -376},
    { 976, 320, -352},
    { 1088, 384, -352},
    { 1136, 512, -352},
    { 1104, 496, -272},
    { 744, 464, -136},
    // 48 seconds
    { 680, 528, -128},
    { 1224, 760, -24},
    { 1064, 600, -200},
    { 1112, 400, -128},
    { 1496, 616, -48},
    { 1656, 520, -72},
    { 1592, 248, -72},
    { 1416, 32, -72},
    { 1144, 0, -224},
    { 960, -24, -296},
    { 840, -88, -296},
    { 856, -136, -296},
    { 968, -96, -344},
    { 952, -64, -424},
    { 752, 24, -360},
    { 1040, -56, -208},
    { 1392, 192, -280},
    { 1560, 112, -376},
    { 1512, 32, -312},
    { 1280, 128, -280},
    { 1048, 232, -296},
    { 864, 240, -232},
    { 864, 248, -184},
    { 1040, 312, -184},
    { 1120, 408, -248},
    // 49 seconds
    { 1184, 408, -408},
    { 1088, 328, -432},
    { 904, 336, -408},
    { 736, 384, -320},
    { 720, 824, -152},
    { 1032, 552, -424},
    { 856, 336, -296},
    { 1024, 528, -144},
    { 1680, 336, -216},
    { 1552, 88, -152},
    { 1320, 152, -104},
    { 1200, 160, -104},
    { 1016, 152, -144},
    { 1000, 112, -176},
    { 960, 32, -200},
    { 824, 24, -144},
    { 880, -104, -176},
    { 936, -72, -424},
    { 872, -40, -512},
    { 1080, -144, -232},
    { 1504, 40, -408},
    { 1416, 16, -488},
    { 1488, 40, -424},
    { 1224, 192, -352},
    { 944, 272, -248},
    // 50 seconds
    { 800, 248, -152},
    { 832, 240, -232},
    { 984, 208, -216},
    { 992, 376, -312},
    { 904, 376, -408},
    { 856, 296, -344},
    { 784, 360, -296},
    { 680, 472, -256},
    { 824, 1008, -200},
    { 1072, 216, -200},
    { 1080, 400, -128},
    { 1536, 688, -104},
    { 1816, 440, -72},
    { 1680, 208, -56},
    { 1480, 184, -64},
    { 1320, 96, -144},
    { 1144, 96, -176},
    { 1072, 64, -128},
    { 1112, 0, -192},
    { 1104, 8, -184},
    { 904, -40, -304},
    { 728, -144, -168},
    { 928, -40, -32},
    { 1304, 112, -328},
    { 1416, 72, -248},
    // 51 seconds
    { 1648, 96, -208},
    { 1560, 184, -280},
    { 1288, 392, -360},
    { 1064, 256, -368},
    { 992, 216, -224},
    { 1048, 296, -160},
    { 1080, 416, -184},
    { 1160, 472, -248},
    { 1016, 472, -288},
    { 720, 480, -328},
    { 616, 528, -200},
    { 1008, 840, -144},
    { 1120, 464, -352},
    { 1168, 368, -176},
    { 1856, 368, -104},
    { 1912, 224, -136},
    { 1656, 272, 32},
    { 1456, 240, -40},
    { 1288, 216, -88},
    { 1152, 72, -32},
    { 976, 40, -96},
    { 1032, 24, -96},
    { 984, 8, -72},
    { 928, 48, -256},
    { 968, 24, -344},
    // 52 seconds
    { 1160, -40, -64},
    { 1512, 136, -264},
    { 1488, 160, -312},
    { 1488, 104, -376},
    { 1328, 144, -352},
    { 1088, 232, -344},
    { 1080, 136, -240},
    { 1128, 296, -216},
    { 1232, 352, -168},
    { 1192, 440, -232},
    { 1104, 448, -336},
    { 1008, 440, -272},
    { 696, 496, -120},
    { 464, 528, -312},
    { 640, 472, -32},
    { 832, 648, -184},
    { 1072, 528, -96},
    { 1616, 512, -56},
    { 1928, 400, -32},
    { 1832, 168, -24},
    { 1592, 192, -96},
    { 1408, 136, -176},
    { 1216, 64, -192},
    { 1048, 16, -264},
    { 1000, -40, -320},
    // 53 seconds
    { 1160, -104, -280},
    { 1032, -208, -400},
    { 744, -152, -408},
    { 896, -104, -288},
    { 1120, 24, -368},
    { 1344, 56, -384},
    { 1440, 80, -360},
    { 1368, 88, -344},
    { 1144, 152, -216},
    { 936, 272, -240},
    { 952, 248, -192},
    { 1048, 336, -272},
    { 1176, 368, -352},
    { 1232, 384, -288},
    { 1128, 392, -224},
    { 848, 440, -208},
    { 848, 808, -152},
    { 992, 816, -256},
    { 896, 456, -128},
    { 1168, 720, -120},
    { 1648, 552, -120},
    { 1792, 272, -24},
    { 1656, 144, -24},
    { 1464, 120, -64},
    { 1304, 136, -104},
    // 54 seconds
    { 1152, 96, -128},
    { 1072, 80, -136},
    { 1152, 64, -152},
    { 1192, 48, -176},
    { 928, 0, -312},
    { 648, -24, -272},
    { 896, 0, -216},
    { 1080, 72, -448},
    { 1192, -72, -432},
    { 1376, -136, -440},
    { 1280, -24, -440},
    { 1112, 80, -344},
    { 992, 256, -336},
    { 976, 256, -344},
    { 992, 328, -344},
    { 1144, 272, -344},
    { 1288, 344, -496},
    { 1256, 400, -400},
    { 880, 536, -216},
    { 560, 792, -368},
    { 840, 624, -64},
    { 824, 640, -136},
    { 1088, 624, -56},
    { 1592, 504, -40},
    { 1800, 432, -40},
    // 55 seconds
    { 1720, 256, -8},
    { 1664, 184, -32},
    { 1528, 144, -72},
    { 1376, 96, -176},
    { 1176, 48, -184},
    { 1056, 8, -232},
    { 1000, -56, -224},
    { 864, -128, -288},
    { 600, -120, -408},
    { 648, -104, -296},
    { 1072, 8, -424},
    { 1256, -8, -512},
    { 1464, -64, -416},
    { 1400, 0, -376},
    { 1184, 168, -352},
    { 1016, 272, -256},
    { 1088, 232, -216},
    { 1240, 272, -336},
    { 1272, 216, -400},
    { 1336, 240, -336},
    { 1312, 272, -320},
    { 1192, 304, -224},
    { 832, 408, -112},
    { 616, 608, 48},
    { 512, 1096, -312},
    // 56 seconds
    { 680, 224, -32},
    { 736, 680, 8},
    { 1208, 672, 32},
    { 1608, 512, -96},
    { 1728, 432, -24},
    { 1632, 360, 72},
    { 1672, 72, 64},
    { 1560, 32, -88},
    { 1400, 104, -184},
    { 1280, 64, -184},
    { 1192, 32, -216},
    { 1120, -40, -272},
    { 848, -32, -352},
    { 864, -72, -304},
    { 1040, -40, 0},
    { 1216, 96, -392},
    { 1184, 16, -392},
    { 1248, -8, -312},
    { 1176, 96, -296},
    { 1016, 152, -256},
    { 904, 192, -216},
    { 944, 232, -280},
    { 1048, 256, -256},
    { 1064, 264, -296},
    { 1072, 336, -344},
    // 57 seconds
    { 1048, 328, -376},
    { 904, 368, -352},
    { 792, 520, -280},
    { 912, 728, -416},
    { 960, 384, -232},
    { 920, 432, -232},
    { 1144, 464, -184},
    { 1496, 376, -176},
    { 1552, 256, -136},
    { 1520, 224, -64},
    { 1336, 352, 8},
    { 1280, 504, -16},
    { 1272, 640, 48},
    { 1200, 752, 152},
    { 1080, 896, 88},
    { 784, 816, 0},
    { 376, 880, -144},
    { 144, 960, -416},
    { -256, 896, -416},
    { -520, 976, -536},
    { -760, 808, -192},
    { -800, 896, 8},
    { -584, 1432, -72},
    { -248, 1424, 96},
    { -72, 1512, -104},
    // 58 seconds
    { -8, 1328, -56},
    { 344, 1536, -344},
    { -264, 1112, -208},
    { -448, 912, -168},
    { -312, 560, -272},
    { -152, 392, -384},
    { -408, 168, 48},
    { -744, -232, 856},
    { -664, -80, 488},
    { -560, -32, 544},
    { -384, 152, 472},
    { -112, 48, 312},
    { 24, 104, 216},
    { 32, -120, 368},
    { -40, -288, 360},
    { -512, -768, -64},
    { -752, -1288, -360},
    { -784, -1800, -408},
    { -688, -1896, -608},
    { -512, -1560, -752},
    { -296, -1040, -984},
    { -248, -944, -920},
    { -176, -1016, -864},
    { -144, -736, -976},
    { -88, -888, -776},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-01 09:31:54 local
AccelRawData *activity_sample_walk_100_pbl_25471_6(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25471_6
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -400, -512, -912},
    { -440, -408, -968},
    { -512, -352, -992},
    { -568, -336, -952},
    { -520, -224, -992},
    { -456, -312, -952},
    { -408, -288, -944},
    { -368, -328, -920},
    { 304, -816, -456},
    { -296, -296, -888},
    { -448, -376, -856},
    { -384, -424, -832},
    { -456, -304, -880},
    { -448, -280, -872},
    { -432, -392, -912},
    { -432, -400, -920},
    { -416, -336, -912},
    { -432, -296, -968},
    { -424, -288, -976},
    { -480, -280, -984},
    { -408, -312, -1000},
    { -160, -296, -992},
    { -336, -344, -936},
    { -360, -328, -920},
    { -392, -328, -920},
    // 1 seconds
    { -416, -280, -936},
    { -448, -240, -896},
    { -480, -240, -904},
    { -488, -208, -896},
    { -544, -128, -872},
    { -632, -8, -776},
    { -704, 112, -848},
    { -696, 48, -840},
    { -656, -128, -960},
    { -648, -16, -992},
    { -640, -64, -768},
    { -576, -64, -776},
    { -568, -40, -720},
    { -520, 0, -768},
    { -440, -232, -896},
    { -480, -240, -896},
    { -504, -200, -1048},
    { -568, -160, -1224},
    { -624, -256, -1128},
    { -704, -312, -976},
    { -632, -384, -784},
    { -592, 8, -640},
    { -80, -40, -432},
    { 664, 24, -248},
    { 1480, 216, 64},
    // 2 seconds
    { 2384, 432, -16},
    { 2632, 544, -168},
    { 2200, 528, 96},
    { 1928, 368, 40},
    { 1728, 376, 8},
    { 1416, 480, -176},
    { 1424, 408, -120},
    { 1512, 352, -48},
    { 1456, 448, -56},
    { 1400, 456, -112},
    { 1376, 496, -224},
    { 984, 600, -88},
    { 584, 808, -80},
    { 560, 1128, -32},
    { 808, 640, -64},
    { 832, 584, -112},
    { 1264, 712, -56},
    { 1584, 632, -160},
    { 1736, 512, -64},
    { 1896, 392, 8},
    { 1840, 280, 16},
    { 1688, 144, -16},
    { 1464, 96, -32},
    { 1360, 80, -128},
    { 1256, 80, -152},
    // 3 seconds
    { 1096, 56, -264},
    { 920, -8, -312},
    { 816, -96, -328},
    { 792, -120, -96},
    { 784, -16, -216},
    { 848, 72, -288},
    { 872, 96, -368},
    { 960, 104, -368},
    { 1160, 104, -384},
    { 1392, 192, -288},
    { 1624, 360, -456},
    { 1592, 440, -568},
    { 1440, 536, -648},
    { 1192, 584, -568},
    { 856, 520, -448},
    { 568, 456, -408},
    { 888, 520, -312},
    { 1056, 592, -280},
    { 1296, 488, -264},
    { 1544, 456, -264},
    { 1584, 360, -216},
    { 1528, 96, -104},
    { 1248, 96, -88},
    { 1056, 104, -144},
    { 968, 120, -112},
    // 4 seconds
    { 1024, 128, -120},
    { 1168, 128, -176},
    { 1312, 64, -120},
    { 1024, -120, 8},
    { 888, -136, -32},
    { 984, -40, 72},
    { 1184, 208, -96},
    { 1368, 296, -240},
    { 1504, 480, -480},
    { 1376, 680, -416},
    { 1352, 624, -296},
    { 720, 984, -1128},
    { 728, 680, -640},
    { 1024, 768, -112},
    { 872, 856, -72},
    { 608, 960, 392},
    { 376, 912, 80},
    { 432, 736, -536},
    { 752, 128, 144},
    { 1320, 16, -184},
    { 1240, -80, 88},
    { 992, -240, 1008},
    { 992, 864, -528},
    { 1112, 176, 192},
    { 600, 472, 472},
    // 5 seconds
    { 160, 752, 272},
    { -72, 40, -304},
    { -328, 120, 240},
    { -16, 136, 248},
    { 432, 592, 664},
    { 888, 712, 680},
    { 1008, 832, 960},
    { 1560, 840, 824},
    { 2288, 808, 424},
    { 1672, 144, 744},
    { 992, 160, 536},
    { 400, 152, 352},
    { 144, 272, 240},
    { 24, 568, -32},
    { 160, 280, -248},
    { 312, 56, -144},
    { 408, -40, -40},
    { 520, 400, 32},
    { 496, 648, -128},
    { 600, 1088, -504},
    { 1176, 960, -1128},
    { 1936, -200, -736},
    { 1784, 312, -600},
    { 1600, 632, -488},
    { 1496, 712, -360},
    // 6 seconds
    { 1336, 464, -344},
    { 1200, 376, -376},
    { 1104, 176, -264},
    { 960, 96, -200},
    { 896, 104, -192},
    { 1064, 88, -240},
    { 1128, 120, -248},
    { 992, 112, -232},
    { 1096, 48, 40},
    { 1368, 160, -192},
    { 1440, 352, -360},
    { 1376, 208, -248},
    { 1264, 176, -160},
    { 1168, 240, -256},
    { 1096, 272, -320},
    { 1128, 224, -216},
    { 1192, 376, -16},
    { 1272, 472, -72},
    { 1232, 576, -160},
    { 1016, 568, -128},
    { 680, 592, -16},
    { 808, 728, -112},
    { 936, 816, -120},
    { 840, 320, -224},
    { 1160, 496, -72},
    // 7 seconds
    { 1664, 680, -152},
    { 1728, 528, -176},
    { 1616, 240, -80},
    { 1408, 72, -112},
    { 1248, -24, -160},
    { 1048, 0, -240},
    { 1096, 24, -232},
    { 1176, 72, -288},
    { 1136, -32, -416},
    { 952, -192, -304},
    { 1080, -208, -48},
    { 1320, 32, -344},
    { 1208, 136, -344},
    { 1384, 152, -264},
    { 1408, 120, -240},
    { 1336, 192, -192},
    { 1256, 336, -176},
    { 1120, 360, -144},
    { 1136, 360, -112},
    { 1168, 408, -152},
    { 1112, 448, -232},
    { 1008, 496, -280},
    { 736, 480, -160},
    { 512, 480, -88},
    { 784, 656, -112},
    // 8 seconds
    { 872, 760, -8},
    { 968, 464, -240},
    { 1328, 544, -112},
    { 1712, 704, -184},
    { 1816, 552, -216},
    { 2040, 184, -88},
    { 1624, -112, -8},
    { 1208, -208, -168},
    { 992, 0, -256},
    { 920, 64, -232},
    { 1048, 96, -184},
    { 960, 144, -248},
    { 760, 72, -312},
    { 1168, 32, -200},
    { 1520, 40, -312},
    { 1520, 48, -280},
    { 1408, 40, -272},
    { 1264, 96, -336},
    { 1128, 168, -328},
    { 1008, 264, -200},
    { 984, 272, -96},
    { 1112, 368, -56},
    { 1128, 448, -88},
    { 1104, 488, -200},
    { 1016, 504, -216},
    // 9 seconds
    { 720, 472, -128},
    { 576, 544, -152},
    { 800, 848, -72},
    { 992, 608, -208},
    { 1048, 504, -200},
    { 1496, 704, -136},
    { 2000, 696, -104},
    { 2016, 296, -24},
    { 1664, 112, -80},
    { 1400, 8, -240},
    { 1152, -80, -304},
    { 928, -48, -272},
    { 904, 0, -264},
    { 960, -40, -272},
    { 728, -24, -392},
    { 728, -80, -352},
    { 1072, 0, -184},
    { 1448, 96, -312},
    { 1560, 176, -336},
    { 1656, 216, -272},
    { 1456, 264, -248},
    { 1248, 320, -216},
    { 1096, 384, -176},
    { 976, 416, -128},
    { 1040, 368, -232},
    // 10 seconds
    { 1064, 392, -296},
    { 1112, 472, -376},
    { 872, 520, -168},
    { 552, 600, -104},
    { 872, 728, -280},
    { 896, 568, -152},
    { 1160, 464, -208},
    { 1584, 640, -168},
    { 1928, 648, -136},
    { 1968, 336, -40},
    { 1776, 104, 0},
    { 1488, 104, -112},
    { 1240, 128, -144},
    { 1000, 120, -72},
    { 904, 64, -112},
    { 1040, 80, -136},
    { 944, 128, -176},
    { 760, 48, -400},
    { 880, -48, -168},
    { 1352, 24, -328},
    { 1328, 16, -400},
    { 1392, 32, -328},
    { 1384, 104, -280},
    { 1320, 216, -344},
    { 1160, 312, -312},
    // 11 seconds
    { 1096, 312, -272},
    { 1112, 304, -160},
    { 1152, 360, -160},
    { 1104, 424, -272},
    { 1088, 504, -344},
    { 944, 520, -256},
    { 680, 552, -208},
    { 528, 456, -272},
    { 912, 712, -80},
    { 984, 744, -304},
    { 1096, 464, -240},
    { 1560, 560, -184},
    { 1784, 512, -144},
    { 1880, 256, -64},
    { 1680, 96, -80},
    { 1456, 160, -128},
    { 1280, 160, -176},
    { 1160, 88, -200},
    { 1024, 40, -240},
    { 1016, 16, -176},
    { 976, -24, -280},
    { 696, -80, -368},
    { 848, -128, -320},
    { 1048, -56, -344},
    { 1096, 0, -464},
    // 12 seconds
    { 1256, 0, -352},
    { 1536, 88, -384},
    { 1536, 168, -440},
    { 1264, 336, -344},
    { 1088, 328, -272},
    { 1040, 280, -320},
    { 1040, 312, -376},
    { 1024, 416, -424},
    { 960, 432, -336},
    { 784, 536, -160},
    { 536, 720, -176},
    { 672, 688, -128},
    { 928, 760, 24},
    { 1128, 600, -224},
    { 1288, 536, -120},
    { 1648, 624, -48},
    { 1784, 432, 8},
    { 1680, 152, 0},
    { 1528, 120, -64},
    { 1344, 184, -160},
    { 1216, 120, -192},
    { 1104, 80, -232},
    { 1008, -16, -200},
    { 968, 24, -296},
    { 856, -32, -376},
    // 13 seconds
    { 736, -56, -416},
    { 856, -72, -296},
    { 1144, 32, -392},
    { 1192, 8, -504},
    { 1248, -24, -416},
    { 1320, 72, -392},
    { 1240, 168, -448},
    { 1056, 272, -328},
    { 1048, 288, -248},
    { 1048, 360, -256},
    { 1040, 360, -280},
    { 1016, 456, -296},
    { 952, 480, -376},
    { 840, 424, -352},
    { 704, 512, -296},
    { 488, 576, -248},
    { 520, 472, -184},
    { 824, 680, 16},
    { 1136, 648, -232},
    { 1200, 408, -168},
    { 1416, 432, -64},
    { 1656, 400, -48},
    { 1688, 208, -24},
    { 1512, 208, -72},
    { 1352, 168, -88},
    // 14 seconds
    { 1160, 152, -184},
    { 1008, 112, -216},
    { 872, 8, -208},
    { 808, -24, -208},
    { 904, -8, -264},
    { 880, 8, -464},
    { 1000, -72, -504},
    { 1352, -48, -264},
    { 1416, 56, -496},
    { 1128, 16, -408},
    { 1176, 80, -408},
    { 1144, 136, -416},
    { 1040, 184, -328},
    { 952, 200, -224},
    { 952, 232, -192},
    { 1024, 336, -232},
    { 992, 376, -272},
    { 880, 360, -320},
    { 840, 368, -304},
    { 776, 424, -216},
    { 608, 552, -72},
    { 840, 688, -200},
    { 1032, 624, -112},
    { 1048, 528, -160},
    { 1160, 576, -152},
    // 15 seconds
    { 1456, 488, -104},
    { 1600, 272, -24},
    { 1504, 152, -24},
    { 1488, 128, -128},
    { 1424, 128, -176},
    { 1280, 120, -224},
    { 1104, 56, -200},
    { 952, 8, -184},
    { 872, 40, -232},
    { 792, 24, -296},
    { 720, 32, -296},
    { 824, 8, -216},
    { 1104, 88, -288},
    { 1072, 104, -424},
    { 1088, 32, -392},
    { 1256, 80, -440},
    { 1176, 88, -384},
    { 1080, 160, -304},
    { 1000, 288, -360},
    { 1040, 272, -304},
    { 1064, 328, -280},
    { 1016, 352, -288},
    { 968, 368, -328},
    { 944, 368, -296},
    { 792, 384, -304},
    // 16 seconds
    { 656, 384, -280},
    { 760, 496, -256},
    { 904, 720, -160},
    { 936, 616, -288},
    { 984, 408, -120},
    { 1264, 384, -80},
    { 1408, 288, -120},
    { 1376, 168, -120},
    { 1344, 136, -128},
    { 1248, 184, -128},
    { 1232, 200, -128},
    { 1264, 208, -160},
    { 1248, 136, -144},
    { 1168, 72, -216},
    { 1120, 16, -384},
    { 992, -112, -440},
    { 968, -216, -232},
    { 1064, -192, -304},
    { 872, -112, -496},
    { 816, -144, -400},
    { 880, -104, -448},
    { 904, -8, -480},
    { 920, 40, -432},
    { 968, 72, -352},
    { 1072, 136, -376},
    // 17 seconds
    { 1112, 192, -312},
    { 1200, 272, -400},
    { 1152, 344, -376},
    { 1000, 352, -368},
    { 864, 352, -344},
    { 816, 416, -312},
    { 784, 552, -184},
    { 896, 848, -264},
    { 920, 480, -240},
    { 936, 400, -160},
    { 1208, 576, -200},
    { 1416, 320, -240},
    { 1392, 176, -128},
    { 1376, 104, -136},
    { 1328, 88, -152},
    { 1360, 120, -192},
    { 1232, 120, -160},
    { 1160, 128, -152},
    { 1088, 112, -160},
    { 992, 144, -264},
    { 912, 72, -344},
    { 928, -16, -288},
    { 952, -48, -216},
    { 880, -32, -456},
    { 776, -120, -496},
    // 18 seconds
    { 728, -136, -464},
    { 864, -56, -488},
    { 928, -24, -488},
    { 960, 56, -456},
    { 1000, 80, -432},
    { 1120, 152, -488},
    { 1176, 224, -416},
    { 1144, 320, -400},
    { 1080, 376, -376},
    { 1000, 400, -392},
    { 880, 368, -384},
    { 768, 384, -360},
    { 696, 424, -280},
    { 776, 528, -200},
    { 928, 584, -160},
    { 1008, 480, -280},
    { 1024, 392, -184},
    { 1128, 456, -200},
    { 1384, 344, -144},
    { 1632, 136, -88},
    { 1528, 144, -152},
    { 1416, 168, -160},
    { 1280, 152, -152},
    { 1128, 120, -168},
    { 992, 80, -176},
    // 19 seconds
    { 952, 40, -248},
    { 872, -16, -312},
    { 760, -144, -408},
    { 928, -232, -264},
    { 1184, -176, -280},
    { 1312, -72, -432},
    { 1272, -72, -360},
    { 1320, 0, -320},
    { 1304, 64, -368},
    { 1296, 112, -280},
    { 1312, 256, -312},
    { 1256, 312, -304},
    { 1136, 344, -208},
    { 1040, 384, -168},
    { 896, 376, -248},
    { 872, 400, -312},
    { 896, 416, -272},
    { 744, 416, -200},
    { 560, 472, -184},
    { 784, 656, -216},
    { 1048, 784, -152},
    { 1024, 520, -240},
    { 1072, 464, -176},
    { 1480, 528, -160},
    { 1816, 352, -88},
    // 20 seconds
    { 1672, 104, -40},
    { 1424, 104, -120},
    { 1224, 112, -152},
    { 1056, 136, -144},
    { 960, 160, -152},
    { 1040, 104, -136},
    { 1112, 128, -192},
    { 952, 104, -320},
    { 824, 8, -464},
    { 872, -176, -312},
    { 1128, -128, -184},
    { 1112, 48, -368},
    { 1104, 48, -344},
    { 1192, 120, -376},
    { 1224, 144, -392},
    { 1160, 152, -392},
    { 1072, 208, -256},
    { 1088, 232, -264},
    { 1168, 352, -304},
    { 1152, 384, -328},
    { 1104, 424, -312},
    { 912, 472, -288},
    { 616, 560, -88},
    { 720, 704, -232},
    { 936, 632, -144},
    // 21 seconds
    { 832, 496, -200},
    { 1096, 552, -136},
    { 1520, 616, -208},
    { 1736, 512, -144},
    { 1800, 272, 16},
    { 1728, 88, -40},
    { 1496, 64, -112},
    { 1264, 96, -160},
    { 1064, 96, -144},
    { 928, 64, -160},
    { 848, 72, -120},
    { 800, 72, -192},
    { 792, 72, -280},
    { 784, 40, -376},
    { 1000, -8, -328},
    { 1520, 56, -392},
    { 1480, 64, -256},
    { 1680, 248, -328},
    { 1520, 280, -344},
    { 1368, 288, -280},
    { 1216, 344, -256},
    { 1048, 352, -104},
    { 1040, 320, -64},
    { 1032, 336, -104},
    { 912, 384, -88},
    // 22 seconds
    { 864, 432, -168},
    { 696, 464, -288},
    { 640, 480, -248},
    { 664, 552, -264},
    { 728, 648, -320},
    { 864, 544, -72},
    { 1008, 576, -232},
    { 1208, 528, -232},
    { 1624, 440, -152},
    { 1968, 240, -112},
    { 1888, 312, -184},
    { 1720, 232, -136},
    { 1496, 232, -104},
    { 1304, 128, -112},
    { 1120, 64, -152},
    { 1024, 56, -248},
    { 976, 0, -216},
    { 816, -16, -336},
    { 768, -128, -312},
    { 1080, -96, -280},
    { 1128, -24, -448},
    { 1280, -40, -416},
    { 1480, -24, -400},
    { 1552, 88, -416},
    { 1544, 176, -400},
    // 23 seconds
    { 1248, 296, -336},
    { 1112, 328, -328},
    { 1064, 384, -288},
    { 1072, 376, -280},
    { 1120, 440, -304},
    { 1104, 520, -288},
    { 904, 552, -184},
    { 624, 592, -272},
    { 696, 552, -168},
    { 784, 840, -48},
    { 944, 544, -272},
    { 1288, 448, -88},
    { 1968, 360, -64},
    { 1984, 304, -96},
    { 1816, 264, -72},
    { 1616, 184, -104},
    { 1464, 152, -104},
    { 1264, 128, -168},
    { 1080, 72, -200},
    { 984, 112, -160},
    { 936, 40, -208},
    { 872, 8, -240},
    { 696, -64, -264},
    { 536, -96, -320},
    { 728, -64, -352},
    // 24 seconds
    { 1120, 24, -328},
    { 1424, 128, -408},
    { 1728, 208, -392},
    { 1768, 256, -384},
    { 1456, 280, -296},
    { 1232, 312, -192},
    { 1144, 376, -256},
    { 1216, 280, -224},
    { 1120, 400, -192},
    { 1072, 472, -240},
    { 976, 512, -264},
    { 832, 608, -160},
    { 568, 656, -328},
    { 768, 552, -96},
    { 1048, 848, -200},
    { 1096, 512, -280},
    { 1496, 472, -176},
    { 2008, 640, -96},
    { 2152, 264, -8},
    { 1792, 56, 8},
    { 1448, 72, -112},
    { 1224, 80, -208},
    { 1056, 104, -368},
    { 1008, 32, -280},
    { 1000, -72, -208},
    // 25 seconds
    { 952, -48, -272},
    { 720, -72, -448},
    { 568, -120, -304},
    { 728, -24, -296},
    { 1032, -8, -456},
    { 1288, -16, -496},
    { 1640, 0, -424},
    { 1872, 96, -424},
    { 1552, 264, -424},
    { 1264, 368, -360},
    { 1008, 376, -304},
    { 1064, 272, -368},
    { 1216, 424, -368},
    { 1136, 616, -432},
    { 952, 984, -288},
    { 616, 824, -408},
    { 472, 464, -256},
    { 696, 648, -168},
    { 1184, 744, -248},
    { 1784, 448, -248},
    { 1928, 352, -8},
    { 2184, 296, -112},
    { 2064, 208, -168},
    { 1640, 152, -160},
    { 1304, 136, -152},
    // 26 seconds
    { 1056, 120, -200},
    { 912, 24, -224},
    { 824, -40, -232},
    { 792, -176, -200},
    { 792, -104, -312},
    { 688, -160, -376},
    { 744, -152, -384},
    { 1096, -56, -296},
    { 1568, 48, -312},
    { 1792, 192, -336},
    { 2040, 200, -304},
    { 1856, 360, -288},
    { 1488, 408, -344},
    { 1216, 440, -184},
    { 1216, 296, -232},
    { 1192, 336, -192},
    { 1024, 400, -296},
    { 1104, 520, -232},
    { 792, 648, 32},
    { 456, 784, -176},
    { 696, 672, -96},
    { 856, 696, -40},
    { 1008, 648, -104},
    { 1384, 640, -96},
    { 1936, 672, -8},
    // 27 seconds
    { 2184, 384, 16},
    { 1928, 40, -24},
    { 1592, 152, -136},
    { 1360, 168, -160},
    { 1168, 128, -160},
    { 1056, 72, -256},
    { 1128, 0, -304},
    { 1008, -88, -344},
    { 800, -192, -440},
    { 760, -272, -352},
    { 976, -112, -336},
    { 1304, 8, -344},
    { 1488, 88, -464},
    { 1616, 72, -392},
    { 1600, 128, -224},
    { 1280, 232, -256},
    { 1112, 304, -192},
    { 1008, 352, -184},
    { 1152, 384, -216},
    { 1216, 472, -272},
    { 1192, 440, -296},
    { 1096, 584, -240},
    { 728, 928, -216},
    { 704, 512, -232},
    { 680, 704, -48},
    // 28 seconds
    { 880, 776, -152},
    { 1064, 608, -136},
    { 1496, 608, -120},
    { 1992, 552, -56},
    { 2088, 288, 16},
    { 1808, 80, -40},
    { 1552, 128, -112},
    { 1296, 176, -88},
    { 1112, 112, -176},
    { 1032, 80, -208},
    { 1104, 56, -248},
    { 1032, -32, -384},
    { 752, -152, -400},
    { 752, -200, -384},
    { 840, -152, -288},
    { 1088, -24, -368},
    { 1288, 48, -448},
    { 1560, 104, -360},
    { 1640, 192, -336},
    { 1416, 328, -344},
    { 1248, 384, -232},
    { 1128, 400, -264},
    { 1160, 376, -312},
    { 1232, 472, -312},
    { 1248, 536, -272},
    // 29 seconds
    { 992, 712, -168},
    { 576, 768, -312},
    { 600, 608, -160},
    { 832, 792, -72},
    { 1048, 672, -224},
    { 1400, 600, -168},
    { 1896, 600, -104},
    { 2104, 432, -16},
    { 1960, 112, 40},
    { 1640, 112, -72},
    { 1392, 160, -88},
    { 1168, 152, -120},
    { 1088, 88, -184},
    { 1112, 48, -216},
    { 1160, -8, -344},
    { 1104, -128, -432},
    { 976, -248, -320},
    { 1016, -240, -336},
    { 1000, -136, -488},
    { 1152, -24, -432},
    { 1336, 24, -376},
    { 1520, 128, -384},
    { 1544, 144, -336},
    { 1248, 256, -200},
    { 1152, 280, -184},
    // 30 seconds
    { 1152, 368, -240},
    { 1288, 400, -304},
    { 1288, 408, -368},
    { 1232, 472, -432},
    { 976, 512, -424},
    { 712, 640, -320},
    { 600, 568, -304},
    { 600, 736, -120},
    { 920, 664, -280},
    { 1304, 472, -160},
    { 1912, 408, -112},
    { 2008, 400, -88},
    { 2080, 248, -128},
    { 1816, 176, -104},
    { 1544, 184, -136},
    { 1280, 128, -144},
    { 1096, 80, -216},
    { 1064, 16, -296},
    { 1168, -104, -248},
    { 880, -168, -384},
    { 752, -208, -400},
    { 824, -168, -296},
    { 1144, -48, -360},
    { 1344, -8, -416},
    { 1536, 48, -368},
    // 31 seconds
    { 1688, 112, -296},
    { 1784, 176, -312},
    { 1496, 360, -280},
    { 1256, 512, -120},
    { 1144, 456, -384},
    { 1336, 288, -208},
    { 1360, 488, -256},
    { 1272, 624, -200},
    { 880, 648, -32},
    { 648, 656, -224},
    { 648, 808, -24},
    { 864, 832, -120},
    { 1088, 640, -112},
    { 1712, 752, -40},
    { 2288, 536, 48},
    { 2392, 144, 0},
    { 2016, 104, -96},
    { 1752, 176, -96},
    { 1464, 224, -32},
    { 1256, 208, -120},
    { 1248, 144, -152},
    { 1304, 104, -144},
    { 1152, -24, -184},
    { 792, -200, -192},
    { 624, -152, -264},
    // 32 seconds
    { 776, -88, -272},
    { 920, -112, -352},
    { 1040, -24, -360},
    { 1224, -80, -296},
    { 1376, -24, -328},
    { 1440, 72, -248},
    { 1440, 232, -264},
    { 1408, 384, -432},
    { 1368, 432, -512},
    { 1368, 520, -488},
    { 1456, 400, -456},
    { 1288, 592, -384},
    { 784, 760, -328},
    { 608, 776, -296},
    { 664, 984, -176},
    { 1056, 560, -256},
    { 1304, 528, -112},
    { 1840, 552, -56},
    { 2056, 320, -96},
    { 1944, 160, -136},
    { 1656, 216, -112},
    { 1416, 240, -136},
    { 1216, 216, -120},
    { 1040, 96, -192},
    { 968, 48, -240},
    // 33 seconds
    { 904, -112, -240},
    { 840, -136, -296},
    { 656, -240, -440},
    { 768, -216, -368},
    { 1200, -112, -400},
    { 1416, -56, -392},
    { 1792, 56, -336},
    { 1968, 144, -336},
    { 1752, 272, -304},
    { 1368, 408, -328},
    { 1096, 432, -304},
    { 944, 392, -272},
    { 1000, 312, -232},
    { 1096, 368, -288},
    { 1136, 448, -320},
    { 984, 560, -248},
    { 696, 688, -176},
    { 632, 848, -304},
    { 616, 760, -48},
    { 992, 584, -256},
    { 1208, 536, -104},
    { 1912, 528, -48},
    { 2288, 280, -128},
    { 2168, 208, -160},
    { 1920, 208, -128},
    // 34 seconds
    { 1600, 256, -160},
    { 1344, 192, -184},
    { 1112, 96, -216},
    { 928, -96, -224},
    { 680, -320, -120},
    { 624, -288, -288},
    { 592, -264, -344},
    { 712, -136, -336},
    { 1080, -16, -272},
    { 1808, 72, -384},
    { 2184, 160, -680},
    { 2192, 80, -520},
    { 1776, 216, -352},
    { 1376, 216, -272},
    { 1176, 336, -248},
    { 1152, 328, -288},
    { 1032, 352, -264},
    { 1016, 360, -248},
    { 1160, 592, -120},
    { 888, 816, 0},
    { 608, 704, -152},
    { 592, 480, -152},
    { 736, 776, 64},
    { 1152, 648, -320},
    { 1328, 488, -72},
    // 35 seconds
    { 2016, 504, 88},
    { 2096, 224, 0},
    { 1856, 160, -112},
    { 1696, 128, -80},
    { 1472, 216, -112},
    { 1280, 160, -112},
    { 1096, 152, -128},
    { 1016, 96, -136},
    { 1024, 80, -120},
    { 920, 72, -240},
    { 664, 8, -328},
    { 832, -48, -256},
    { 1240, 32, -528},
    { 1328, -128, -480},
    { 1624, -112, -360},
    { 1744, 40, -336},
    { 1480, 280, -376},
    { 1304, 392, -320},
    { 1096, 416, -304},
    { 1064, 464, -144},
    { 1168, 360, -208},
    { 1168, 416, -256},
    { 1128, 512, -248},
    { 840, 472, -144},
    { 592, 456, -168},
    // 36 seconds
    { 624, 472, -96},
    { 856, 792, 80},
    { 1176, 648, -224},
    { 1368, 424, -72},
    { 1680, 496, -56},
    { 1888, 424, -56},
    { 1800, 256, 8},
    { 1656, 160, -24},
    { 1440, 136, -56},
    { 1240, 104, -88},
    { 1088, 80, -184},
    { 1016, 96, -160},
    { 1096, 88, -176},
    { 904, 56, -280},
    { 872, -32, -352},
    { 1288, -64, -176},
    { 1536, 72, -304},
    { 1488, 120, -416},
    { 1376, 104, -320},
    { 1256, 192, -360},
    { 1176, 272, -400},
    { 992, 256, -280},
    { 912, 312, -200},
    { 944, 320, -88},
    { 1120, 336, -264},
    // 37 seconds
    { 1264, 296, -312},
    { 1160, 448, -272},
    { 864, 568, -152},
    { 592, 712, -184},
    { 520, 688, -256},
    { 832, 568, -128},
    { 1096, 600, -16},
    { 1560, 600, -48},
    { 1976, 520, -96},
    { 2056, 304, -104},
    { 1792, 216, -80},
    { 1528, 176, -152},
    { 1320, 200, -128},
    { 1128, 200, -64},
    { 1000, 96, -48},
    { 928, -24, -152},
    { 984, -24, -168},
    { 872, 72, -360},
    { 864, -40, -352},
    { 1000, -96, -216},
    { 1400, 40, -280},
    { 1648, 120, -376},
    { 1672, 184, -464},
    { 1504, 144, -512},
    { 1240, 232, -480},
    // 38 seconds
    { 944, 296, -328},
    { 832, 352, -192},
    { 960, 200, -232},
    { 1112, 352, -248},
    { 1320, 456, -184},
    { 1136, 560, -120},
    { 688, 512, 184},
    { 696, 648, -80},
    { 968, 856, 288},
    { 1128, 488, -136},
    { 1072, 456, 40},
    { 1480, 760, 72},
    { 1760, 680, 88},
    { 1888, 192, 88},
    { 1648, 16, 8},
    { 1392, 88, -144},
    { 1144, 144, -144},
    { 1000, 160, -200},
    { 928, 72, -160},
    { 968, 24, -152},
    { 840, 80, -264},
    { 752, 40, -400},
    { 1032, -24, -304},
    { 1568, -64, -432},
    { 1704, 0, -400},
    // 39 seconds
    { 1704, 64, -336},
    { 1616, 168, -360},
    { 1376, 384, -392},
    { 1104, 440, -256},
    { 976, 408, -144},
    { 1000, 320, -152},
    { 1144, 320, -208},
    { 1216, 424, -152},
    { 1120, 600, -112},
    { 736, 592, 8},
    { 512, 728, -48},
    { 688, 816, 72},
    { 1072, 648, -40},
    { 1272, 592, -112},
    { 1840, 816, -64},
    { 2264, 776, 40},
    { 2232, 304, 184},
    { 1912, 120, 104},
    { 1600, 32, 0},
    { 1256, 40, -32},
    { 1048, 88, -120},
    { 952, 48, -160},
    { 1040, 80, -184},
    { 1008, 80, -432},
    { 808, -144, -688},
    // 40 seconds
    { 768, -408, -224},
    { 1224, -368, -456},
    { 1400, -152, -464},
    { 1632, 56, -360},
    { 1736, 192, -304},
    { 1616, 408, -304},
    { 1312, 408, -248},
    { 1088, 392, -8},
    { 976, 384, -176},
    { 1200, 328, -168},
    { 1232, 368, -192},
    { 1312, 544, -688},
    { 1256, 920, -656},
    { 432, 1496, -880},
    { 488, 712, -392},
    { 488, 672, -216},
    { 896, 392, -240},
    { 1240, 400, -96},
    { 1744, 528, -144},
    { 1928, 664, -216},
    { 2000, 560, -112},
    { 1864, 456, 16},
    { 1768, 360, 0},
    { 1640, 176, -168},
    { 1464, 88, -192},
    // 41 seconds
    { 1296, -56, -280},
    { 1184, -304, -232},
    { 904, -456, -160},
    { 552, -312, -432},
    { 616, -152, -456},
    { 1032, -24, -288},
    { 1512, 80, -368},
    { 1856, 144, -344},
    { 2112, 216, -280},
    { 1920, 360, -224},
    { 1432, 408, -240},
    { 1144, 464, -200},
    { 1176, 248, -200},
    { 1192, 360, -120},
    { 1088, 424, -248},
    { 1208, 472, -288},
    { 1104, 536, -128},
    { 680, 624, 56},
    { 648, 808, -208},
    { 712, 704, 40},
    { 1000, 632, -40},
    { 1344, 656, -8},
    { 2016, 656, -16},
    { 2288, 456, 0},
    { 2120, 248, -16},
    // 42 seconds
    { 1712, 184, -56},
    { 1440, 192, -64},
    { 1200, 152, -128},
    { 1088, 192, -136},
    { 1024, 64, -184},
    { 1072, 80, -152},
    { 936, -8, -200},
    { 688, -80, -328},
    { 752, -88, -272},
    { 1184, 40, -344},
    { 1456, 56, -336},
    { 1744, 168, -328},
    { 1864, 216, -400},
    { 1648, 328, -312},
    { 1352, 384, -256},
    { 1128, 408, -232},
    { 1144, 368, -280},
    { 1288, 376, -264},
    { 1264, 488, -256},
    { 1192, 576, -128},
    { 768, 680, -128},
    { 544, 640, -272},
    { 704, 696, -104},
    { 1024, 664, -336},
    { 1056, 512, -224},
    // 43 seconds
    { 1680, 624, 0},
    { 2056, 456, -56},
    { 1992, 216, -48},
    { 1736, 80, -56},
    { 1496, 152, -96},
    { 1248, 184, -128},
    { 1040, 144, -184},
    { 928, 144, -208},
    { 880, 40, -136},
    { 832, 0, -168},
    { 640, -16, -376},
    { 776, -56, -520},
    { 1184, -120, -264},
    { 1360, -32, -384},
    { 1600, 88, -328},
    { 1664, 184, -320},
    { 1648, 280, -304},
    { 1432, 312, -336},
    { 1320, 336, -256},
    { 1224, 320, -152},
    { 1224, 368, -168},
    { 1224, 424, -280},
    { 1216, 464, -288},
    { 968, 536, -152},
    { 576, 736, -128},
    // 44 seconds
    { 608, 672, -184},
    { 720, 776, 16},
    { 1000, 560, -288},
    { 1400, 504, -80},
    { 2088, 520, -40},
    { 2112, 424, -80},
    { 1976, 272, -88},
    { 1712, 160, -72},
    { 1488, 136, -136},
    { 1248, 104, -208},
    { 1088, 104, -176},
    { 1024, 96, -120},
    { 1056, 32, -136},
    { 816, 72, -216},
    { 664, 40, -312},
    { 872, -64, -224},
    { 1216, -32, -272},
    { 1376, 72, -392},
    { 1464, 112, -328},
    { 1528, 152, -264},
    { 1432, 264, -360},
    { 1216, 336, -336},
    { 1112, 360, -192},
    { 1248, 440, -176},
    { 1304, 344, -360},
    // 45 seconds
    { 1280, 344, -368},
    { 1192, 408, -288},
    { 824, 568, -168},
    { 528, 800, -304},
    { 776, 680, -48},
    { 1072, 648, -296},
    { 1088, 448, -160},
    { 1600, 528, -80},
    { 1760, 552, -104},
    { 1760, 304, -96},
    { 1592, 128, -64},
    { 1352, 136, -80},
    { 1168, 192, -96},
    { 1064, 152, -104},
    { 984, 120, -144},
    { 1048, 120, -120},
    { 1056, 136, -128},
    { 808, 144, -208},
    { 696, 40, -376},
    { 880, 64, -176},
    { 1400, 104, -280},
    { 1528, 176, -480},
    { 1504, 136, -480},
    { 1240, 112, -296},
    { 992, 88, -256},
    // 46 seconds
    { 904, 208, -360},
    { 856, 256, -312},
    { 928, 256, -352},
    { 1008, 344, -264},
    { 1104, 384, -336},
    { 1104, 464, -368},
    { 832, 528, -384},
    { 728, 912, -248},
    { 864, 536, -368},
    { 1104, 384, -168},
    { 1688, 440, -56},
    { 1976, 408, -80},
    { 1936, 288, -192},
    { 1696, 208, -192},
    { 1384, 264, -96},
    { 1256, 280, -88},
    { 1160, 224, -48},
    { 1008, 168, -56},
    { 968, 104, -104},
    { 984, 16, -56},
    { 920, 72, -120},
    { 720, 16, -248},
    { 696, -24, -288},
    { 960, -16, -304},
    { 1176, 64, -408},
    // 47 seconds
    { 1560, 136, -384},
    { 1816, 216, -416},
    { 1816, 352, -448},
    { 1264, 344, -360},
    { 992, 400, -320},
    { 1104, 304, -304},
    { 1120, 280, -296},
    { 1176, 336, -320},
    { 1136, 416, -312},
    { 872, 496, -360},
    { 536, 664, -384},
    { 584, 496, -472},
    { 992, 656, -344},
    { 1568, 376, -320},
    { 1552, 304, -120},
    { 1800, 248, -152},
    { 1840, 248, -280},
    { 1560, 192, -232},
    { 1288, 184, -64},
    { 1120, 184, -96},
    { 968, 160, -160},
    { 856, 88, -200},
    { 792, 16, -168},
    { 816, 24, -168},
    { 728, 40, -296},
    // 48 seconds
    { 576, 16, -296},
    { 912, 48, -152},
    { 1312, 160, -400},
    { 1488, 240, -384},
    { 1680, 312, -432},
    { 1464, 208, -408},
    { 1312, 400, -304},
    { 1136, 232, -224},
    { 984, 280, -208},
    { 1072, 320, -280},
    { 1168, 456, -248},
    { 1136, 560, -256},
    { 888, 656, -264},
    { 504, 648, -352},
    { 520, 432, -208},
    { 1216, 744, -128},
    { 1336, 560, -352},
    { 1288, 360, -152},
    { 1816, 328, -56},
    { 1776, 128, -152},
    { 1472, 168, -160},
    { 1256, 248, -160},
    { 1112, 248, -160},
    { 984, 208, -112},
    { 944, 144, -120},
    // 49 seconds
    { 992, 80, -192},
    { 1008, 88, -256},
    { 720, 24, -336},
    { 664, -96, -352},
    { 1064, -64, -8},
    { 1216, 64, -184},
    { 1256, 232, -472},
    { 1344, 288, -416},
    { 1384, 240, -392},
    { 1280, 280, -384},
    { 1120, 328, -320},
    { 1152, 304, -360},
    { 1136, 328, -392},
    { 1064, 376, -496},
    { 960, 456, -472},
    { 752, 464, -376},
    { 560, 336, -328},
    { 648, 328, -176},
    { 1160, 616, -32},
    { 1256, 712, -384},
    { 1360, 296, -192},
    { 1648, 336, -184},
    { 1664, 360, -200},
    { 1528, 192, -72},
    { 1280, 104, -48},
    // 50 seconds
    { 1072, 40, -168},
    { 936, 72, -224},
    { 952, 104, -232},
    { 1048, 64, -296},
    { 968, -32, -352},
    { 840, -144, -272},
    { 1104, -176, -48},
    { 1176, 24, -120},
    { 1200, 312, -512},
    { 1256, 264, -464},
    { 1296, 152, -368},
    { 1184, 168, -312},
    { 1088, 232, -312},
    { 1048, 208, -224},
    { 1120, 312, -208},
    { 1128, 368, -200},
    { 1056, 432, -256},
    { 912, 488, -184},
    { 584, 680, -184},
    { 912, 784, -336},
    { 1176, 512, -136},
    { 1064, 408, -272},
    { 1104, 472, -160},
    { 1512, 584, -216},
    { 1528, 392, -192},
    // 51 seconds
    { 1528, 200, -80},
    { 1448, 32, -48},
    { 1248, -64, -104},
    { 976, 72, -112},
    { 784, 88, -112},
    { 664, 152, -80},
    { 696, 152, -120},
    { 760, 160, -224},
    { 776, 152, -224},
    { 1072, 32, -176},
    { 1568, 0, 192},
    { 1720, 360, 24},
    { 1816, 632, -328},
    { 1496, 384, -376},
    { 1328, 528, -656},
    { 1032, 440, -360},
    { 960, 256, -56},
    { 880, 280, -192},
    { 848, 360, -296},
    { 752, 400, -368},
    { 680, 512, -256},
    { 624, 544, -216},
    { 680, 448, -160},
    { 1200, 576, -64},
    { 1416, 584, -304},
    // 52 seconds
    { 1432, 360, -144},
    { 1824, 352, -80},
    { 1776, 352, -104},
    { 1544, 256, -128},
    { 1320, 160, -48},
    { 1152, 144, -96},
    { 1016, 160, -88},
    { 984, 200, -184},
    { 976, 152, -168},
    { 936, 80, -192},
    { 784, 72, -240},
    { 800, -64, -200},
    { 1096, -16, -296},
    { 1200, 320, -408},
    { 1232, 688, -536},
    { 1328, 728, -536},
    { 1224, 848, -648},
    { 1008, 840, -608},
    { 888, 848, -1104},
    { 208, 1288, -800},
    { 288, 672, -32},
    { 56, 672, 304},
    { 16, 912, -104},
    { 176, 712, -344},
    { 296, 520, -464},
    // 53 seconds
    { 656, 504, -736},
    { 880, 448, -16},
    { 1136, 1088, -48},
    { 896, 584, -216},
    { 688, 528, -48},
    { 568, 608, 72},
    { 584, 608, 80},
    { 544, 424, 128},
    { 480, 296, 176},
    { 456, 400, 208},
    { 456, 432, 328},
    { 560, 480, 528},
    { 680, 808, 448},
    { 832, 712, 320},
    { 640, 632, 488},
    { 552, 488, 376},
    { 1016, 760, 16},
    { 1032, 608, 440},
    { 888, 680, 136},
    { 832, 576, -64},
    { 640, 384, 40},
    { 488, 312, -200},
    { 368, 400, -528},
    { 336, 520, -712},
    { 304, 496, -632},
    // 54 seconds
    { 96, 488, -520},
    { 16, 520, -464},
    { 64, 800, -512},
    { 136, 1056, -680},
    { 648, 1056, -824},
    { 1008, 592, -752},
    { 960, 536, -600},
    { 984, 480, -536},
    { 1072, 648, -488},
    { 1008, 760, -392},
    { 792, 664, -336},
    { 736, 416, -456},
    { 848, 256, -416},
    { 824, 288, -288},
    { 800, 120, -352},
    { 848, -16, -208},
    { 1208, -48, 40},
    { 1688, 256, -312},
    { 1552, 336, -384},
    { 1560, 288, -112},
    { 1440, 280, -144},
    { 1248, 408, -224},
    { 1096, 264, -160},
    { 1032, 368, -88},
    { 1104, 416, 24},
    // 55 seconds
    { 1024, 456, -24},
    { 904, 456, -72},
    { 712, 360, -128},
    { 872, 392, -24},
    { 912, 472, 40},
    { 1096, 576, 16},
    { 1032, 736, 48},
    { 992, 744, -224},
    { 1144, 440, -168},
    { 1400, 536, -16},
    { 1576, 408, -40},
    { 1568, 176, -104},
    { 1424, 104, -88},
    { 1280, 80, -136},
    { 1192, 152, -184},
    { 1184, 160, -192},
    { 1272, 112, -144},
    { 992, 144, -224},
    { 768, 72, -320},
    { 1032, -88, -112},
    { 1240, -48, -16},
    { 1288, 184, -432},
    { 1280, 176, -352},
    { 1248, 128, -312},
    { 1176, 240, -408},
    // 56 seconds
    { 1112, 256, -440},
    { 992, 296, -368},
    { 1048, 240, -304},
    { 1128, 296, -344},
    { 1144, 408, -368},
    { 1072, 464, -280},
    { 680, 576, -184},
    { 592, 440, -240},
    { 976, 656, -104},
    { 1088, 776, -400},
    { 1152, 432, -152},
    { 1592, 456, -32},
    { 1824, 352, -120},
    { 1728, 184, -176},
    { 1448, 80, -136},
    { 1256, 136, -112},
    { 1080, 160, -144},
    { 976, 128, -192},
    { 968, 96, -168},
    { 984, 64, -200},
    { 760, 40, -288},
    { 832, -40, -360},
    { 1112, -16, -80},
    { 1520, 112, -440},
    { 1536, 160, -416},
    // 57 seconds
    { 1504, 224, -376},
    { 1312, 192, -368},
    { 1184, 248, -368},
    { 1024, 272, -248},
    { 984, 336, -224},
    { 1048, 320, -160},
    { 1104, 384, -192},
    { 1072, 416, -176},
    { 856, 464, -8},
    { 608, 568, -160},
    { 896, 680, -64},
    { 1032, 824, -304},
    { 1064, 424, -152},
    { 1400, 512, -56},
    { 1736, 456, -88},
    { 1688, 248, -168},
    { 1488, 120, -88},
    { 1232, 72, -104},
    { 1064, 136, -144},
    { 960, 128, -200},
    { 880, 120, -128},
    { 968, 112, -192},
    { 920, 112, -168},
    { 728, 96, -240},
    { 1024, 56, -160},
    // 58 seconds
    { 1272, 168, -256},
    { 1296, 144, -544},
    { 1296, 168, -416},
    { 1264, 96, -400},
    { 1000, 144, -304},
    { 920, 120, -272},
    { 856, 256, -304},
    { 888, 200, -272},
    { 912, 232, -256},
    { 968, 216, -248},
    { 976, 360, -288},
    { 920, 320, -248},
    { 784, 384, -288},
    { 656, 448, -312},
    { 832, 560, -280},
    { 1072, 664, -328},
    { 1000, 656, -240},
    { 1064, 728, -264},
    { 1192, 928, -160},
    { 1296, 1264, -328},
    { 1328, 1584, -128},
    { 1616, 1712, -8},
    { 1728, 1816, -24},
    { 1952, 1624, 32},
    { 1752, 1376, 136},
    // 59 seconds
    { 1544, 1232, 320},
    { 1144, 960, 304},
    { 240, 272, 336},
    { 536, 736, 600},
    { 248, 304, 56},
    { 64, 104, -112},
    { -296, -464, 328},
    { -408, -208, 792},
    { 144, -48, 424},
    { -120, 88, 304},
    { 40, -72, 288},
    { 48, -368, 608},
    { 248, -512, 720},
    { 96, -768, 360},
    { 136, -1320, 128},
    { 40, -1616, -240},
    { -152, -1680, -312},
    { -280, -1632, -376},
    { -296, -1392, -360},
    { -224, -1144, -464},
    { -192, -992, -648},
    { -160, -1168, -712},
    { -136, -1096, -752},
    { -200, -992, -720},
    { -232, -904, -600},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-01 09:33:36 local
AccelRawData *activity_sample_walk_100_pbl_25471_7(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25471_7
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -32, -280, -1040},
    { -24, -288, -1000},
    { -32, -288, -1000},
    { -16, -312, -992},
    { -40, -304, -976},
    { -40, -296, -992},
    { -40, -304, -1008},
    { -24, -272, -1000},
    { -56, -280, -1008},
    { -88, -264, -1016},
    { -120, -320, -984},
    { -104, -320, -976},
    { -96, -320, -1000},
    { -176, -288, -1040},
    { 176, -320, -1088},
    { 104, -216, -1112},
    { -72, -328, -1008},
    { -80, -296, -1040},
    { -72, -296, -1032},
    { -128, -232, -1048},
    { -128, -200, -1056},
    { -176, -144, -1008},
    { -296, 8, -984},
    { -432, 192, -832},
    { -544, 312, -776},
    // 1 seconds
    { -600, 320, -672},
    { -560, 408, -632},
    { -536, 360, -680},
    { -496, 464, -768},
    { -464, 424, -816},
    { -464, 392, -848},
    { -456, 536, -1008},
    { -264, 176, -960},
    { -232, 208, -952},
    { -16, -16, -880},
    { 184, -264, -776},
    { 400, -248, -632},
    { 632, -272, -488},
    { 880, -72, -304},
    { 1384, 160, -96},
    { 1944, 320, 48},
    { 2480, 520, -48},
    { 2256, 768, -224},
    { 1920, 688, -256},
    { 1664, 600, -128},
    { 1416, 560, -64},
    { 1176, 472, -88},
    { 888, 408, -152},
    { 760, 400, -168},
    { 784, 544, -128},
    // 2 seconds
    { 712, 736, -48},
    { 728, 776, -216},
    { 744, 528, -216},
    { 1104, 592, -96},
    { 1520, 632, -88},
    { 1848, 424, -88},
    { 1952, 280, -24},
    { 1816, 184, -128},
    { 1592, 224, -112},
    { 1496, 184, -96},
    { 1216, 232, -88},
    { 1240, 200, -96},
    { 1096, 112, -536},
    { 984, 16, -592},
    { 816, -216, -224},
    { 792, -248, 16},
    { 832, -160, -48},
    { 936, 120, -296},
    { 1096, 288, -328},
    { 1280, 248, -280},
    { 1352, 264, -160},
    { 1368, 248, -200},
    { 1328, 200, -304},
    { 1472, 216, -184},
    { 1456, 424, -160},
    // 3 seconds
    { 1360, 872, -168},
    { 1072, 1144, -416},
    { 712, 704, -200},
    { 536, 664, -232},
    { 848, 936, -96},
    { 1096, 712, -232},
    { 1096, 592, -208},
    { 1592, 624, -48},
    { 1960, 560, -24},
    { 1912, 288, -48},
    { 1808, 128, -96},
    { 1736, 48, -256},
    { 1520, 88, -288},
    { 1384, 16, -392},
    { 1176, -56, -416},
    { 1000, -208, -416},
    { 840, -392, -360},
    { 888, -336, -144},
    { 832, -216, -320},
    { 848, -48, -392},
    { 1032, 80, -264},
    { 1472, 136, -256},
    { 1904, 296, -272},
    { 1928, 496, -232},
    { 1616, 560, -120},
    // 4 seconds
    { 1376, 568, -176},
    { 1232, 416, -168},
    { 1136, 624, -136},
    { 656, 1184, -88},
    { 344, 1088, -80},
    { 528, 912, 88},
    { 984, 920, 216},
    { 1520, 648, -112},
    { 1664, 792, -96},
    { 2072, 808, 8},
    { 2168, 704, 96},
    { 2152, 368, 48},
    { 1936, 40, -64},
    { 1552, 24, -128},
    { 1312, -56, -224},
    { 1128, -160, -376},
    { 936, -184, -456},
    { 672, -280, -288},
    { 736, -240, -40},
    { 696, -144, -144},
    { 976, -16, -528},
    { 1208, 56, -536},
    { 1552, 80, -344},
    { 1936, 160, -288},
    { 1904, 280, -288},
    // 5 seconds
    { 1648, 424, -304},
    { 1512, 512, -280},
    { 1512, 424, -264},
    { 1280, 680, -144},
    { 880, 824, -192},
    { 480, 1056, 144},
    { 680, 984, 56},
    { 904, 712, -48},
    { 1040, 600, -152},
    { 1472, 712, -16},
    { 1912, 816, 8},
    { 1928, 640, 120},
    { 1968, 320, 80},
    { 1728, 104, -24},
    { 1400, 96, -80},
    { 1184, 72, -152},
    { 1080, -16, -248},
    { 1048, 16, -240},
    { 960, -88, -368},
    { 840, -264, -360},
    { 656, -296, -120},
    { 776, -120, -152},
    { 1000, 80, -296},
    { 1312, 168, -368},
    { 1904, 280, -280},
    // 6 seconds
    { 2216, 392, -376},
    { 1768, 472, -344},
    { 1288, 456, -184},
    { 1200, 392, -592},
    { 1184, 480, -592},
    { 1064, 664, -416},
    { 784, 728, -296},
    { 600, 664, -240},
    { 720, 720, -120},
    { 1056, 856, 8},
    { 1176, 552, -216},
    { 1320, 560, -40},
    { 1912, 784, 8},
    { 2000, 472, 0},
    { 1752, 280, -32},
    { 1480, 256, -96},
    { 1248, 216, -144},
    { 1112, 160, -240},
    { 1032, 48, -280},
    { 1064, -64, -240},
    { 880, -248, -352},
    { 784, -384, -376},
    { 840, -248, -112},
    { 1160, -16, -112},
    { 1544, 128, -312},
    // 7 seconds
    { 1880, 272, -480},
    { 1984, 272, -304},
    { 1808, 312, -280},
    { 1432, 296, -280},
    { 1200, 384, -200},
    { 1176, 328, -168},
    { 1224, 328, -160},
    { 1208, 528, -8},
    { 856, 712, 80},
    { 632, 776, -80},
    { 648, 928, 72},
    { 896, 728, -72},
    { 960, 600, -72},
    { 1424, 728, -48},
    { 1944, 824, 32},
    { 2128, 592, 112},
    { 2008, 184, 32},
    { 1728, 168, -104},
    { 1464, 128, -72},
    { 1304, 144, -160},
    { 1216, 40, -280},
    { 1168, 24, -280},
    { 888, -112, -240},
    { 752, -200, -136},
    { 936, -120, -56},
    // 8 seconds
    { 1056, -32, -320},
    { 1136, 16, -424},
    { 1248, 48, -312},
    { 1464, 96, -264},
    { 1560, 192, -368},
    { 1408, 272, -344},
    { 1248, 312, -344},
    { 1288, 296, -304},
    { 1456, 416, -232},
    { 1256, 880, -352},
    { 872, 688, -360},
    { 656, 600, -296},
    { 840, 952, -256},
    { 1104, 664, -312},
    { 1232, 584, -256},
    { 1728, 664, -144},
    { 1896, 576, -24},
    { 1856, 280, 16},
    { 1624, 208, 0},
    { 1408, 144, -112},
    { 1208, 96, -184},
    { 1064, 64, -216},
    { 1008, -96, -200},
    { 896, -184, -96},
    { 704, -328, 56},
    // 9 seconds
    { 688, -200, -216},
    { 1128, 64, -136},
    { 1360, 168, -264},
    { 1696, 160, -288},
    { 2024, 304, -256},
    { 1840, 328, -184},
    { 1496, 304, -160},
    { 1208, 368, -40},
    { 1128, 416, -160},
    { 1072, 344, -120},
    { 1008, 336, -104},
    { 1072, 400, -72},
    { 1000, 584, 216},
    { 832, 736, -136},
    { 760, 784, -88},
    { 968, 768, -40},
    { 888, 600, -136},
    { 1080, 728, -40},
    { 1544, 824, -8},
    { 1800, 456, 96},
    { 1760, 248, 64},
    { 1648, 160, -56},
    { 1720, 208, -88},
    { 1424, 152, 0},
    { 1240, 120, -56},
    // 10 seconds
    { 1144, 64, -160},
    { 976, 56, -360},
    { 816, 0, -400},
    { 664, -160, -272},
    { 696, -240, -72},
    { 832, -176, -288},
    { 928, -24, -392},
    { 1208, 80, -392},
    { 1736, 104, -488},
    { 1744, 232, -440},
    { 1472, 248, -344},
    { 1232, 424, -328},
    { 1048, 616, -312},
    { 968, 488, -288},
    { 1032, 456, -176},
    { 848, 632, -280},
    { 664, 776, -392},
    { 976, 944, -288},
    { 1240, 648, -304},
    { 1344, 456, -248},
    { 1720, 576, -104},
    { 1776, 360, -40},
    { 1720, 128, 0},
    { 1416, 96, -72},
    { 1240, 128, -112},
    // 11 seconds
    { 1128, 192, -128},
    { 1144, 200, -152},
    { 1176, 120, -200},
    { 1136, 24, -320},
    { 992, -96, -360},
    { 1024, -168, -200},
    { 984, -160, -168},
    { 952, -8, -264},
    { 1024, 0, -368},
    { 1184, 96, -328},
    { 1472, 128, -376},
    { 1600, 168, -344},
    { 1456, 248, -272},
    { 1304, 328, -384},
    { 1144, 432, -376},
    { 1192, 464, -400},
    { 1080, 520, -336},
    { 864, 600, -296},
    { 632, 592, -272},
    { 560, 488, -216},
    { 872, 720, -72},
    { 1176, 592, -424},
    { 1280, 384, -128},
    { 1832, 448, 32},
    { 2032, 424, -32},
    // 12 seconds
    { 1912, 240, -216},
    { 1704, 224, -168},
    { 1456, 184, -152},
    { 1240, 72, -200},
    { 1088, -24, -256},
    { 1104, -80, -352},
    { 1032, -192, -440},
    { 880, -328, -400},
    { 808, -328, -216},
    { 1200, -160, -120},
    { 1400, 88, -296},
    { 1616, 200, -272},
    { 1784, 256, -208},
    { 1912, 280, -200},
    { 1776, 472, -248},
    { 1456, 568, -144},
    { 1112, 632, -256},
    { 1192, 240, -120},
    { 1200, 344, -64},
    { 1080, 528, -64},
    { 752, 680, 40},
    { 552, 832, -216},
    { 776, 1016, -208},
    { 992, 768, -296},
    { 928, 384, -504},
    // 13 seconds
    { 1328, 736, -160},
    { 2480, 672, -56},
    { 2416, 104, 256},
    { 1816, -16, 8},
    { 1488, 16, -192},
    { 1264, 176, -224},
    { 968, 152, 0},
    { 960, 152, -40},
    { 992, 88, -160},
    { 864, 88, -264},
    { 696, -40, -248},
    { 848, -104, -88},
    { 1128, -88, -80},
    { 1456, 64, -216},
    { 1736, 168, -208},
    { 1808, 272, -184},
    { 1568, 304, -256},
    { 1248, 280, -272},
    { 1088, 248, -192},
    { 1128, 256, -104},
    { 1144, 320, -64},
    { 1160, 408, -64},
    { 1064, 472, -72},
    { 744, 488, -104},
    { 592, 504, -216},
    // 14 seconds
    { 808, 560, -232},
    { 936, 856, -216},
    { 1056, 568, -352},
    { 1336, 600, -240},
    { 1928, 488, -112},
    { 1888, 200, 24},
    { 1648, 112, 104},
    { 1376, 40, -72},
    { 1104, 40, -120},
    { 896, 64, -72},
    { 896, -8, -120},
    { 912, 0, -136},
    { 968, -16, -200},
    { 880, 24, -240},
    { 1008, 32, -200},
    { 1352, 88, -88},
    { 1560, 208, -136},
    { 1528, 264, -160},
    { 1400, 248, -144},
    { 1264, 280, -216},
    { 1152, 264, -280},
    { 1000, 208, -184},
    { 920, 208, -136},
    { 912, 264, -120},
    { 976, 312, -72},
    // 15 seconds
    { 976, 400, -168},
    { 1008, 392, -168},
    { 824, 416, -296},
    { 720, 424, -344},
    { 840, 512, -408},
    { 1000, 488, -504},
    { 1016, 376, -528},
    { 1328, 416, -368},
    { 1664, 376, -280},
    { 1504, 320, -184},
    { 1248, 368, -168},
    { 1216, 464, -272},
    { 1176, 488, -272},
    { 1176, 544, -304},
    { 1032, 488, -320},
    { 832, 472, -328},
    { 656, 344, -416},
    { 472, 264, -384},
    { 296, 280, -304},
    { 296, 424, -360},
    { 248, 840, -520},
    { 256, 1464, -288},
    { 80, 1096, -328},
    { 80, 1008, -400},
    { 32, 840, -408},
    // 16 seconds
    { -56, 760, -208},
    { -200, 856, -104},
    { -216, 696, -104},
    { -232, 584, -136},
    { -304, 688, -152},
    { -360, 912, -184},
    { -384, 1168, -224},
    { -456, 1248, -200},
    { -464, 968, -72},
    { -384, 1112, 248},
    { -192, 1120, 368},
    { -40, 896, 224},
    { -96, 848, 64},
    { -136, 1016, -16},
    { -208, 856, -24},
    { -256, 768, -208},
    { -280, 680, -144},
    { -336, 656, 32},
    { -376, 584, 96},
    { -352, 576, 312},
    { -208, 848, 800},
    { -48, 952, 864},
    { 256, 968, 640},
    { 264, 904, 368},
    { 216, 976, 408},
    // 17 seconds
    { 168, 1168, 688},
    { 208, 1040, 512},
    { 248, 904, 336},
    { 48, 976, 328},
    { -120, 840, 272},
    { -248, 728, 296},
    { -280, 720, 272},
    { -280, 752, 280},
    { -248, 832, 304},
    { -216, 944, 288},
    { -208, 952, 240},
    { -152, 952, 152},
    { -112, 952, 192},
    { -112, 1032, 424},
    { 32, 1248, 672},
    { 184, 1184, 632},
    { 176, 1024, 496},
    { 224, 1000, 400},
    { 184, 904, 344},
    { 112, 728, 272},
    { 72, 608, 200},
    { -8, 608, 160},
    { -72, 664, 144},
    { -128, 744, 208},
    { -168, 816, 208},
    // 18 seconds
    { -216, 952, 208},
    { -136, 1080, 208},
    { -32, 1120, 160},
    { 64, 1080, 200},
    { 64, 1232, 280},
    { 152, 1128, 152},
    { 128, 1040, 96},
    { 48, 944, 128},
    { -32, 824, 136},
    { -104, 696, 112},
    { -128, 656, 56},
    { -168, 640, 40},
    { -208, 744, 40},
    { -264, 848, 144},
    { -328, 1048, 136},
    { -216, 1152, -8},
    { -248, 1072, -96},
    { -344, 1056, 40},
    { -272, 1240, 264},
    { -24, 1232, 376},
    { 8, 1160, 248},
    { -16, 1104, 224},
    { -80, 984, 248},
    { -96, 776, 200},
    { -128, 608, 136},
    // 19 seconds
    { -136, 504, 120},
    { -184, 536, 104},
    { -232, 600, 128},
    { -288, 744, 136},
    { -280, 1048, 200},
    { -112, 1296, 208},
    { -8, 1112, -8},
    { 80, 1248, 8},
    { -24, 1400, 136},
    { 104, 1400, 128},
    { 160, 1040, -152},
    { 48, 832, -136},
    { -8, 664, -56},
    { -88, 568, -48},
    { -104, 496, -16},
    { -152, 536, 0},
    { -224, 696, 32},
    { -304, 968, 48},
    { -424, 1096, 16},
    { -416, 1064, -80},
    { -496, 1208, -16},
    { -192, 1472, 216},
    { 16, 1480, 192},
    { 152, 1416, 200},
    { 104, 1200, 120},
    // 20 seconds
    { 16, 952, 56},
    { -40, 656, 0},
    { -72, 496, -32},
    { -136, 408, -40},
    { -224, 464, 0},
    { -312, 560, 40},
    { -416, 680, 80},
    { -504, 1048, 88},
    { -344, 1392, 248},
    { -224, 1192, 168},
    { -216, 1272, 192},
    { -192, 1312, 232},
    { -40, 1232, 136},
    { 0, 1080, 0},
    { -72, 872, 0},
    { -88, 640, 8},
    { -152, 512, 16},
    { -200, 520, 24},
    { -224, 480, 32},
    { -240, 512, -40},
    { -336, 760, -16},
    { -488, 1064, 32},
    { -512, 1128, -56},
    { -560, 1104, -200},
    { -672, 1208, -80},
    // 21 seconds
    { -432, 1424, 96},
    { -280, 1176, 32},
    { -248, 1144, 104},
    { -208, 1072, 144},
    { -192, 888, 96},
    { -192, 688, 64},
    { -176, 520, 48},
    { -176, 432, 40},
    { -224, 432, 32},
    { -272, 512, 0},
    { -392, 744, -24},
    { -472, 1200, -8},
    { -240, 1304, -72},
    { -40, 920, -320},
    { 144, 1152, -216},
    { 168, 1528, -136},
    { 296, 1240, -264},
    { 248, 1032, -392},
    { 152, 800, -456},
    { 16, 720, -416},
    { -88, 680, -208},
    { -192, 680, -288},
    { -248, 664, -128},
    { -320, 760, -16},
    { -368, 776, -8},
    // 22 seconds
    { -376, 864, 32},
    { -352, 976, 8},
    { -288, 1000, 40},
    { -376, 1016, 88},
    { -432, 1416, 88},
    { -224, 1424, 16},
    { -272, 1040, 88},
    { -384, 992, -56},
    { -256, 920, -272},
    { -224, 600, -288},
    { -280, 336, -392},
    { -280, 200, -264},
    { -280, 360, -280},
    { -80, 112, -280},
    { 104, 40, -256},
    { 720, 384, -448},
    { 1240, 456, -456},
    { 1728, 264, -160},
    { 2152, 440, 152},
    { 2232, 800, 16},
    { 1824, 704, -320},
    { 1744, 688, -312},
    { 1528, 608, 0},
    { 1264, 480, 0},
    { 1032, 376, -40},
    // 23 seconds
    { 904, 384, -152},
    { 848, 480, -176},
    { 752, 576, -64},
    { 616, 656, 88},
    { 496, 736, -64},
    { 856, 704, 40},
    { 1040, 608, -88},
    { 1272, 480, -192},
    { 1792, 656, 8},
    { 2056, 600, -8},
    { 1928, 336, 24},
    { 1712, 280, -32},
    { 1544, 192, -48},
    { 1272, 56, -48},
    { 1000, 136, -64},
    { 936, 56, -136},
    { 1056, 72, -104},
    { 968, 160, -232},
    { 816, 56, -176},
    { 968, -16, -24},
    { 1104, 80, -152},
    { 1232, 208, -320},
    { 1480, 272, -296},
    { 1712, 344, -312},
    { 1544, 296, -336},
    // 24 seconds
    { 1296, 256, -272},
    { 1144, 536, -336},
    { 1152, 312, -184},
    { 1120, 392, -168},
    { 1288, 440, -200},
    { 1136, 504, -224},
    { 728, 512, -216},
    { 640, 632, -256},
    { 920, 952, -328},
    { 936, 472, -184},
    { 1312, 472, 16},
    { 1800, 408, -48},
    { 1816, 336, -120},
    { 1704, 344, -64},
    { 1528, 288, -56},
    { 1352, 256, -32},
    { 1200, 208, -72},
    { 1040, 128, -88},
    { 976, 56, -88},
    { 992, 48, -72},
    { 784, 56, -200},
    { 664, 24, -176},
    { 832, 48, -120},
    { 1016, 112, -224},
    { 1440, 232, -480},
    // 25 seconds
    { 1664, 216, -584},
    { 1480, 80, -216},
    { 1152, 112, -16},
    { 968, 32, -80},
    { 952, 120, -176},
    { 1096, 352, -328},
    { 1112, 360, -232},
    { 1056, 424, -280},
    { 1072, 480, -392},
    { 824, 448, -448},
    { 616, 584, -544},
    { 888, 448, -328},
    { 1160, 512, -376},
    { 1384, 456, -200},
    { 1616, 328, -88},
    { 1688, 296, -224},
    { 1472, 200, -16},
    { 1288, 80, -48},
    { 1144, 96, -56},
    { 984, 128, -168},
    { 1064, 128, -144},
    { 1160, 88, -64},
    { 1080, -16, 120},
    { 1008, 56, 8},
    { 824, 56, 104},
    // 26 seconds
    { 1088, -16, 136},
    { 1392, 296, -224},
    { 1752, 456, -336},
    { 1816, 512, -448},
    { 1496, 904, -552},
    { 992, 856, -376},
    { 744, 1032, -816},
    { 664, 688, -8},
    { 632, 680, 280},
    { 608, 752, 344},
    { 288, 504, -112},
    { 272, 136, -176},
    { 504, 304, -400},
    { 792, 440, -184},
    { 936, -80, -480},
    { 1248, 752, 264},
    { 1616, 40, -280},
    { 1264, 320, 64},
    { 856, 0, 168},
    { 792, 328, 280},
    { 672, 32, 72},
    { 800, 168, 536},
    { 728, 400, 424},
    { 744, 184, 224},
    { 600, 232, 32},
    // 27 seconds
    { 432, 352, 424},
    { 504, 536, 408},
    { 736, 264, 448},
    { 864, 248, 688},
    { 800, 408, 608},
    { 1024, 464, 392},
    { 1600, 672, 152},
    { 1680, 312, 312},
    { 1152, 208, 616},
    { 656, 248, 608},
    { 176, 80, 288},
    { -32, 136, 16},
    { 64, 384, -160},
    { 112, 432, -128},
    { 240, 328, -160},
    { 400, 560, 80},
    { 576, 792, 240},
    { 744, 1352, -128},
    { 816, 1152, -552},
    { 1056, -360, -1192},
    { 560, 1128, -984},
    { 800, 832, -848},
    { 856, 96, -984},
    { 640, 104, -944},
    { 576, 352, -888},
    // 28 seconds
    { 456, 488, -856},
    { 424, 496, -760},
    { 224, 304, -712},
    { 168, 288, -712},
    { 64, 232, -760},
    { 168, 16, -664},
    { 256, -48, -544},
    { 480, -40, -552},
    { 776, 64, -472},
    { 1312, 160, -296},
    { 1728, 224, -184},
    { 2144, 272, -416},
    { 1888, 240, -264},
    { 1376, 248, -72},
    { 1000, 264, -80},
    { 1048, 288, -320},
    { 976, 328, -272},
    { 1008, 320, -112},
    { 992, 336, -96},
    { 952, 360, -168},
    { 944, 376, -328},
    { 1072, 368, -400},
    { 1144, 456, -360},
    { 1056, 416, -296},
    { 920, 776, -48},
    // 29 seconds
    { 760, 912, -656},
    { 864, 344, -112},
    { 1240, 496, 0},
    { 1576, 296, -16},
    { 1568, 176, -56},
    { 1496, 104, 24},
    { 1360, 160, -72},
    { 1200, 232, -88},
    { 1064, 240, -80},
    { 1112, 112, -88},
    { 1136, 128, -104},
    { 1048, 80, -264},
    { 856, -96, -464},
    { 920, -232, -232},
    { 792, -248, -272},
    { 952, -128, -440},
    { 1128, -104, -432},
    { 1304, -32, -456},
    { 1240, 40, -408},
    { 1128, 208, -336},
    { 1120, 456, -376},
    { 1120, 376, -200},
    { 992, 416, -208},
    { 960, 440, -240},
    { 1104, 592, -352},
    // 30 seconds
    { 1344, 824, -416},
    { 1296, 632, -336},
    { 1224, 872, -336},
    { 1128, 896, -440},
    { 1048, 688, -344},
    { 1104, 520, -224},
    { 1400, 392, -24},
    { 1744, 280, 8},
    { 1816, 184, 64},
    { 1648, 176, 160},
    { 1480, 256, 8},
    { 1256, 280, 64},
    { 1120, 272, 72},
    { 1048, 264, 40},
    { 1008, 144, -96},
    { 816, 96, -176},
    { 800, -40, -520},
    { 784, -488, -656},
    { 744, -736, -280},
    { 864, -544, -496},
    { 992, -368, -656},
    { 1152, -248, -392},
    { 1352, -32, -344},
    { 1496, 120, -304},
    { 1512, 288, -208},
    // 31 seconds
    { 1568, 336, -152},
    { 1528, 416, -152},
    { 1400, 416, -64},
    { 1360, 472, -40},
    { 1240, 488, -72},
    { 1248, 760, -32},
    { 1136, 1216, -224},
    { 856, 768, -40},
    { 824, 1160, 96},
    { 616, 944, -48},
    { 752, 608, -272},
    { 1208, 624, -56},
    { 2040, 576, 16},
    { 2160, 352, 8},
    { 2120, 152, 48},
    { 1896, 72, 16},
    { 1592, 128, -88},
    { 1248, 168, -144},
    { 1008, 200, -168},
    { 912, 32, -184},
    { 848, -112, -200},
    { 640, -232, -280},
    { 1040, -176, -312},
    { 1088, -88, -280},
    { 1368, -112, -328},
    // 32 seconds
    { 1616, 0, -488},
    { 1600, 104, -344},
    { 1480, 208, -192},
    { 1408, 368, -144},
    { 1384, 368, -56},
    { 1432, 440, -48},
    { 1344, 488, -24},
    { 1288, 448, 0},
    { 936, 408, -128},
    { 1192, 624, -40},
    { 1024, 992, -16},
    { 1032, 584, -88},
    { 792, 784, 24},
    { 728, 736, -176},
    { 968, 576, -64},
    { 1416, 520, 0},
    { 1672, 336, 24},
    { 1800, 160, 0},
    { 1656, 144, 8},
    { 1440, 184, -8},
    { 1192, 248, -16},
    { 1048, 256, -32},
    { 1000, 184, -48},
    { 904, 160, -88},
    { 872, 168, -160},
    // 33 seconds
    { 816, 88, -304},
    { 784, -32, -392},
    { 1000, -144, -344},
    { 1088, -136, -320},
    { 1152, -64, -480},
    { 1248, -40, -448},
    { 1328, 128, -208},
    { 1024, 280, -200},
    { 1064, 280, -240},
    { 1080, 264, -256},
    { 1024, 360, -248},
    { 904, 368, -192},
    { 872, 384, -176},
    { 976, 424, -216},
    { 1128, 472, -168},
    { 1112, 512, -184},
    { 952, 536, -160},
    { 1024, 680, -96},
    { 984, 800, -256},
    { 936, 488, -264},
    { 1160, 424, -88},
    { 1472, 424, 0},
    { 1560, 152, -24},
    { 1384, 104, 16},
    { 1320, 120, 56},
    // 34 seconds
    { 1272, 216, -72},
    { 1160, 216, -56},
    { 1016, 208, 8},
    { 1048, 160, -48},
    { 1016, 104, -104},
    { 920, 112, -224},
    { 824, 40, -440},
    { 1000, -120, -400},
    { 944, -256, -408},
    { 936, -320, -592},
    { 1024, -432, -480},
    { 1208, -136, -464},
    { 1240, 24, -416},
    { 1080, 200, -352},
    { 1064, 264, -392},
    { 1064, 264, -296},
    { 960, 328, -248},
    { 856, 376, -240},
    { 904, 368, -320},
    { 976, 392, -352},
    { 1168, 504, -480},
    { 1208, 512, -504},
    { 984, 544, -408},
    { 704, 744, -408},
    { 712, 592, -568},
    // 35 seconds
    { 824, 264, -400},
    { 1152, 352, -144},
    { 1744, 304, -56},
    { 1672, 224, -24},
    { 1560, 200, 48},
    { 1464, 192, 0},
    { 1320, 160, -88},
    { 1144, 192, -176},
    { 944, 120, -216},
    { 856, -16, -328},
    { 928, -16, -424},
    { 896, -320, -384},
    { 736, -440, -488},
    { 912, -464, -424},
    { 1296, -248, -416},
    { 1424, -120, -408},
    { 1448, -8, -272},
    { 1576, 136, -240},
    { 1352, 256, -200},
    { 1136, 320, -120},
    { 1016, 264, -120},
    { 976, 264, -104},
    { 1016, 320, -48},
    { 896, 208, -240},
    { 976, 120, -448},
    // 36 seconds
    { 1096, 360, -200},
    { 1264, 648, -216},
    { 1112, 824, -128},
    { 784, 744, -16},
    { 720, 800, 288},
    { 672, 712, 72},
    { 880, 568, -112},
    { 1216, 592, -64},
    { 1632, 624, 16},
    { 1792, 416, 72},
    { 1800, 240, 72},
    { 1672, 200, -48},
    { 1448, 120, -104},
    { 1256, 96, -184},
    { 1160, 24, -232},
    { 1016, -24, -344},
    { 992, -240, -352},
    { 840, -400, -296},
    { 896, -344, -280},
    { 944, -224, -464},
    { 1000, -136, -496},
    { 1176, -136, -320},
    { 1480, 16, -304},
    { 1536, 168, -256},
    { 1424, 336, -192},
    // 37 seconds
    { 1280, 376, -224},
    { 1136, 424, -160},
    { 1024, 496, -216},
    { 928, 480, -240},
    { 896, 608, -296},
    { 832, 864, -432},
    { 992, 776, -448},
    { 920, 688, -416},
    { 992, 720, -360},
    { 1040, 792, -312},
    { 1168, 464, -336},
    { 1624, 504, -96},
    { 2048, 376, 48},
    { 1984, 240, -24},
    { 1800, 192, 0},
    { 1552, 232, -16},
    { 1336, 232, -56},
    { 1120, 184, -80},
    { 904, 80, -88},
    { 808, 64, -248},
    { 712, -16, -376},
    { 664, -272, -360},
    { 392, -504, -424},
    { 752, -424, -496},
    { 1104, -344, -512},
    // 38 seconds
    { 1416, -296, -432},
    { 1648, -136, -360},
    { 1680, 40, -312},
    { 1400, 192, -240},
    { 1224, 312, -296},
    { 1144, 232, -232},
    { 1104, 320, -200},
    { 1104, 360, -120},
    { 1040, 488, -136},
    { 960, 488, -232},
    { 1112, 392, -320},
    { 1136, 912, -336},
    { 1104, 632, -312},
    { 968, 824, -80},
    { 768, 1000, -104},
    { 880, 768, -352},
    { 1080, 512, -192},
    { 1600, 480, 40},
    { 1912, 344, 80},
    { 1984, 88, 0},
    { 1848, 24, -40},
    { 1600, 88, -64},
    { 1376, 112, -56},
    { 1120, 144, -112},
    { 896, 8, -136},
    // 39 seconds
    { 776, 16, -176},
    { 664, -24, -296},
    { 624, -152, -320},
    { 512, -280, -352},
    { 792, -312, -480},
    { 1192, -256, -456},
    { 1600, -216, -528},
    { 1904, -176, -432},
    { 1848, -16, -272},
    { 1488, 256, -200},
    { 1264, 320, -152},
    { 1192, 456, -152},
    { 1144, 392, -48},
    { 1064, 408, -88},
    { 888, 312, -152},
    { 952, 376, -208},
    { 1120, 544, -248},
    { 1128, 760, -232},
    { 864, 704, -408},
    { 984, 792, -88},
    { 832, 888, -232},
    { 992, 560, -288},
    { 1344, 496, -96},
    { 1784, 456, 16},
    { 2088, 176, 0},
    // 40 seconds
    { 1904, 152, -104},
    { 1752, 152, -88},
    { 1528, 160, -104},
    { 1232, 184, -128},
    { 1032, 88, -144},
    { 896, 8, -184},
    { 792, -120, -264},
    { 632, -216, -304},
    { 496, -368, -336},
    { 776, -336, -320},
    { 1160, -200, -480},
    { 1296, -200, -344},
    { 1712, -80, -336},
    { 1704, 80, -296},
    { 1432, 240, -208},
    { 1264, 392, -248},
    { 1160, 392, -264},
    { 1112, 368, -264},
    { 1040, 408, -280},
    { 888, 432, -280},
    { 960, 568, -248},
    { 1184, 632, -296},
    { 1160, 544, -192},
    { 1104, 672, -88},
    { 912, 728, -136},
    // 41 seconds
    { 776, 552, -272},
    { 992, 480, -112},
    { 1400, 520, -8},
    { 1568, 336, 16},
    { 1736, 208, 8},
    { 1616, 200, 16},
    { 1464, 120, -48},
    { 1296, 96, -64},
    { 1144, 80, -168},
    { 1128, 16, -200},
    { 1008, -24, -352},
    { 784, -120, -432},
    { 808, -232, -400},
    { 856, -256, -280},
    { 824, -216, -376},
    { 928, -136, -504},
    { 1136, -112, -336},
    { 1368, 24, -328},
    { 1456, 136, -280},
    { 1408, 288, -216},
    { 1344, 392, -224},
    { 1272, 400, -200},
    { 1152, 424, -256},
    { 1040, 512, -360},
    { 896, 752, -432},
    // 42 seconds
    { 712, 576, -432},
    { 824, 680, -376},
    { 880, 608, -264},
    { 1040, 584, -160},
    { 1032, 552, -264},
    { 880, 392, -240},
    { 1176, 384, -64},
    { 1784, 336, -16},
    { 1768, 208, -40},
    { 1688, 168, -56},
    { 1480, 112, -112},
    { 1248, 80, -144},
    { 1056, 48, -216},
    { 880, -40, -280},
    { 784, -136, -368},
    { 864, -184, -424},
    { 760, -344, -480},
    { 744, -448, -456},
    { 1344, -296, -224},
    { 1368, -32, -416},
    { 1304, -8, -400},
    { 1504, 40, -240},
    { 1456, 160, -184},
    { 1376, 344, -176},
    { 1256, 296, -160},
    // 43 seconds
    { 1144, 376, -144},
    { 1048, 376, -160},
    { 944, 408, -184},
    { 888, 424, -200},
    { 1120, 552, -168},
    { 1104, 656, -216},
    { 968, 640, -120},
    { 984, 888, 40},
    { 704, 704, -320},
    { 832, 552, -216},
    { 1368, 600, -72},
    { 1672, 416, 0},
    { 1728, 208, 8},
    { 1696, 96, -16},
    { 1520, 64, -80},
    { 1344, 56, -176},
    { 1240, 8, -216},
    { 1072, -40, -320},
    { 1096, -144, -496},
    { 976, -400, -416},
    { 960, -544, -136},
    { 952, -248, -392},
    { 1000, -160, -512},
    { 1040, -128, -280},
    { 1360, -48, -288},
    // 44 seconds
    { 1392, 56, -296},
    { 1320, 176, -192},
    { 1272, 320, -160},
    { 1272, 384, -168},
    { 1224, 424, -144},
    { 1072, 464, -200},
    { 992, 560, -224},
    { 1032, 680, -304},
    { 1048, 688, -288},
    { 888, 712, -256},
    { 992, 944, -168},
    { 776, 792, -392},
    { 792, 560, -400},
    { 1256, 600, -104},
    { 1864, 488, -8},
    { 1920, 168, 16},
    { 1800, 48, -8},
    { 1664, 80, -112},
    { 1488, 80, -152},
    { 1304, 96, -208},
    { 1160, 0, -296},
    { 1152, -176, -496},
    { 904, -480, -320},
    { 800, -560, -240},
    { 904, -368, -296},
    // 45 seconds
    { 888, -168, -504},
    { 1032, -112, -304},
    { 1336, -56, -376},
    { 1400, 0, -312},
    { 1360, 144, -168},
    { 1296, 400, -240},
    { 1264, 352, -200},
    { 1256, 424, -184},
    { 1104, 400, -208},
    { 1096, 432, -352},
    { 1040, 560, -344},
    { 1160, 672, -344},
    { 1056, 688, -280},
    { 920, 752, -248},
    { 784, 680, -232},
    { 768, 512, -376},
    { 840, 472, -288},
    { 1200, 488, -88},
    { 1704, 304, 8},
    { 1640, 224, -24},
    { 1672, 160, 8},
    { 1544, 144, -72},
    { 1408, 144, -80},
    { 1192, 80, -128},
    { 1024, 8, -168},
    // 46 seconds
    { 1016, -8, -288},
    { 992, -32, -424},
    { 752, -264, -592},
    { 752, -392, -496},
    { 1104, -392, -224},
    { 1080, -232, -536},
    { 1160, -208, -560},
    { 1400, -88, -360},
    { 1464, 64, -368},
    { 1392, 184, -272},
    { 1192, 272, -256},
    { 1128, 272, -288},
    { 1120, 280, -312},
    { 1136, 248, -384},
    { 1032, 248, -464},
    { 984, 344, -344},
    { 912, 408, -264},
    { 624, 544, -200},
    { 568, 632, -248},
    { 872, 712, -48},
    { 856, 496, -320},
    { 1072, 456, -136},
    { 1736, 440, -56},
    { 1632, 352, -104},
    { 1576, 280, -88},
    // 47 seconds
    { 1536, 176, -104},
    { 1456, 40, -104},
    { 1272, 16, -128},
    { 1152, 8, -192},
    { 1176, -32, -240},
    { 1104, -96, -328},
    { 952, -168, -352},
    { 872, -296, -248},
    { 1120, -224, -104},
    { 1224, -64, -496},
    { 1120, -96, -344},
    { 1336, -40, -296},
    { 1400, 64, -368},
    { 1296, 136, -320},
    { 1152, 320, -256},
    { 1128, 288, -272},
    { 1104, 336, -272},
    { 1064, 440, -296},
    { 1008, 608, -232},
    { 720, 760, -312},
    { 512, 592, -208},
    { 640, 632, -144},
    { 1016, 712, -40},
    { 1352, 648, -256},
    { 1424, 528, -128},
    // 48 seconds
    { 1664, 536, -32},
    { 1864, 360, 8},
    { 1808, 168, -8},
    { 1616, 96, -96},
    { 1344, 0, -192},
    { 1144, 0, -208},
    { 1064, -88, -232},
    { 1000, -168, -296},
    { 840, -272, -400},
    { 672, -360, -344},
    { 712, -392, -448},
    { 1120, -248, -240},
    { 1328, -72, -400},
    { 1424, 0, -344},
    { 1672, 72, -248},
    { 1800, 256, -312},
    { 1536, 392, -256},
    { 1144, 472, 0},
    { 1272, 304, -288},
    { 1280, 424, -216},
    { 1200, 488, -288},
    { 1024, 632, -128},
    { 552, 1000, -480},
    { 512, 352, -152},
    { 816, 912, 24},
    // 49 seconds
    { 1016, 616, -360},
    { 1072, 440, -224},
    { 1760, 472, -24},
    { 1936, 256, -72},
    { 1704, 216, -24},
    { 1528, 144, -48},
    { 1352, 96, -136},
    { 1192, 112, -144},
    { 1056, 48, -128},
    { 992, 16, -152},
    { 976, 48, -176},
    { 960, 0, -264},
    { 824, -8, -296},
    { 720, -64, -368},
    { 1040, -56, -208},
    { 1288, -32, -416},
    { 1208, -88, -376},
    { 1392, 8, -320},
    { 1432, 64, -312},
    { 1296, 232, -288},
    { 1192, 288, -232},
    { 1160, 320, -216},
    { 1184, 360, -208},
    { 1152, 432, -216},
    { 1032, 440, -208},
    // 50 seconds
    { 952, 464, -168},
    { 616, 504, -16},
    { 480, 488, -168},
    { 976, 680, 48},
    { 992, 696, -80},
    { 1088, 528, -144},
    { 1496, 528, -72},
    { 1736, 440, 8},
    { 1640, 312, -56},
    { 1648, 192, -16},
    { 1480, 88, -104},
    { 1272, 32, -144},
    { 1096, -56, -152},
    { 984, -72, -208},
    { 968, -80, -232},
    { 888, -56, -288},
    { 792, -48, -296},
    { 872, -24, -184},
    { 1368, 64, -432},
    { 1264, -8, -352},
    { 1400, -8, -304},
    { 1408, 64, -328},
    { 1248, 184, -320},
    { 1056, 240, -304},
    { 936, 200, -232},
    // 51 seconds
    { 968, 272, -144},
    { 1008, 384, -200},
    { 1048, 408, -272},
    { 976, 360, -336},
    { 952, 312, -296},
    { 768, 344, -288},
    { 608, 392, -232},
    { 816, 584, -248},
    { 1176, 584, -328},
    { 1056, 488, -192},
    { 1200, 440, -120},
    { 1376, 360, -88},
    { 1408, 288, -88},
    { 1344, 160, -48},
    { 1320, 176, -104},
    { 1304, 144, -72},
    { 1248, 112, -120},
    { 1232, 72, -136},
    { 1096, 48, -160},
    { 1032, 16, -216},
    { 864, -24, -312},
    { 792, -32, -344},
    { 920, -64, -240},
    { 1096, -8, -384},
    { 1064, -56, -376},
    // 52 seconds
    { 1152, -8, -376},
    { 1248, -8, -424},
    { 1192, 32, -408},
    { 1040, 200, -344},
    { 1008, 120, -352},
    { 1016, 248, -344},
    { 1072, 336, -376},
    { 1080, 368, -360},
    { 1064, 448, -344},
    { 896, 512, -248},
    { 672, 456, -352},
    { 600, 392, -224},
    { 800, 584, -32},
    { 1160, 544, -304},
    { 1008, 336, -120},
    { 1432, 432, -48},
    { 1616, 304, -48},
    { 1544, 280, -40},
    { 1440, 152, -64},
    { 1288, 128, -176},
    { 1120, 24, -144},
    { 1000, -16, -168},
    { 1048, 8, -224},
    { 1120, 32, -264},
    { 1040, -56, -376},
    // 53 seconds
    { 976, -80, -376},
    { 1168, -112, -200},
    { 1312, -56, -352},
    { 1192, -16, -304},
    { 1256, 48, -312},
    { 1248, 64, -368},
    { 1192, 184, -368},
    { 1096, 216, -328},
    { 1064, 184, -264},
    { 1072, 288, -248},
    { 1104, 400, -304},
    { 1096, 456, -312},
    { 896, 472, -288},
    { 640, 464, -296},
    { 712, 480, -264},
    { 952, 648, -128},
    { 1128, 616, -336},
    { 1280, 552, -152},
    { 1696, 520, -72},
    { 1776, 264, -16},
    { 1592, 200, -16},
    { 1376, 176, -64},
    { 1192, 128, -96},
    { 1048, 112, -120},
    { 1040, 80, -176},
    // 54 seconds
    { 1064, 24, -144},
    { 1016, -24, -248},
    { 880, -80, -336},
    { 880, -152, -304},
    { 1112, -88, -328},
    { 1240, -120, -384},
    { 1424, -40, -320},
    { 1528, 40, -336},
    { 1424, 96, -384},
    { 1248, 176, -376},
    { 1032, 280, -304},
    { 928, 160, -344},
    { 960, 176, -248},
    { 1072, 224, -264},
    { 1168, 272, -352},
    { 1080, 320, -368},
    { 824, 368, -392},
    { 792, 424, -456},
    { 872, 576, -392},
    { 1128, 520, -512},
    { 1232, 376, -264},
    { 1576, 312, -152},
    { 1616, 224, -112},
    { 1432, 200, -56},
    { 1192, 160, -88},
    // 55 seconds
    { 1032, 128, -120},
    { 920, 120, -128},
    { 896, 32, -136},
    { 1024, 64, -168},
    { 1176, 8, -184},
    { 1072, -48, -264},
    { 1096, -32, -344},
    { 1200, 48, -96},
    { 1376, 184, -48},
    { 1320, 144, -320},
    { 1184, 0, -368},
    { 1192, -8, -408},
    { 1088, -8, -352},
    { 968, 80, -240},
    { 1008, 168, -240},
    { 1040, 208, -192},
    { 1128, 368, -248},
    { 1240, 456, -248},
    { 1032, 496, -216},
    { 728, 520, -96},
    { 760, 624, -264},
    { 848, 712, -152},
    { 1032, 568, -144},
    { 1152, 512, -72},
    { 1632, 496, -48},
    // 56 seconds
    { 1792, 280, -32},
    { 1688, 144, 8},
    { 1424, 152, -72},
    { 1216, 144, -104},
    { 1088, 96, -120},
    { 1016, 56, -152},
    { 1056, 24, -152},
    { 1088, -16, -192},
    { 872, -72, -240},
    { 984, -16, -224},
    { 1256, 48, -224},
    { 1224, 32, -232},
    { 1432, 72, -240},
    { 1544, 88, -280},
    { 1600, 168, -376},
    { 1376, 240, -344},
    { 1136, 320, -328},
    { 1008, 216, -160},
    { 1008, 280, -192},
    { 1048, 352, -208},
    { 976, 464, -216},
    { 800, 440, -200},
    { 688, 424, -200},
    { 832, 504, -232},
    { 984, 648, -296},
    // 57 seconds
    { 1008, 424, -232},
    { 1240, 352, -80},
    { 1608, 400, -88},
    { 1760, 272, -128},
    { 1600, 224, -72},
    { 1376, 176, -40},
    { 1152, 152, -64},
    { 984, 136, -88},
    { 888, 72, -112},
    { 856, 40, -152},
    { 904, 16, -176},
    { 976, 24, -232},
    { 904, 0, -272},
    { 1008, -8, -360},
    { 1248, 16, -248},
    { 1440, 88, -264},
    { 1504, 136, -368},
    { 1448, 152, -368},
    { 1192, 224, -312},
    { 1016, 200, -328},
    { 912, 152, -224},
    { 920, 272, -192},
    { 968, 312, -176},
    { 1016, 384, -192},
    { 992, 376, -160},
    // 58 seconds
    { 872, 408, -136},
    { 624, 464, -64},
    { 728, 560, -248},
    { 920, 800, -112},
    { 1192, 464, -168},
    { 1312, 400, -160},
    { 1800, 368, -128},
    { 1968, 184, -104},
    { 1704, 72, -160},
    { 1376, 112, -104},
    { 1056, 208, -208},
    { 912, 416, -144},
    { 712, 664, -160},
    { 368, 816, -376},
    { -24, 1112, -696},
    { -72, 1232, -784},
    { -288, 1568, -848},
    { -384, 1520, -744},
    { -488, 1216, -392},
    { -312, 1488, -392},
    { 232, 2048, -248},
    { 80, 1576, -464},
    { 640, 1344, -192},
    { 312, 576, -64},
    { 328, 648, 16},
    // 59 seconds
    { 168, 152, 112},
    { -256, -264, 160},
    { -544, -392, 528},
    { -664, -288, 600},
    { -728, 8, 640},
    { -304, -24, 368},
    { -96, 64, 112},
    { -112, -120, 360},
    { -424, -592, 720},
    { -80, -648, 360},
    { 8, -984, 72},
    { 152, -1496, -240},
    { 160, -1640, -616},
    { 24, -1568, -568},
    { 224, -1264, -608},
    { 312, -1160, -656},
    { 280, -1232, -600},
    { 184, -1144, -568},
    { 160, -1072, -544},
    { 144, -792, -552},
    { 248, -744, -696},
    { 320, -928, -640},
    { 280, -968, -712},
    { 256, -888, -744},
    { 192, -840, -728},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-01 09:35:29 local
AccelRawData *activity_sample_walk_100_pbl_25471_8(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25471_8
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 48, -360, -1456},
    { 88, -624, -1160},
    { 136, -576, -1040},
    { 160, -504, -984},
    { 200, -456, -1032},
    { 144, -520, -968},
    { 152, -624, -944},
    { 96, -544, -960},
    { -24, -400, -880},
    { 72, -504, -792},
    { 120, -512, -864},
    { 8, -496, -920},
    { 24, -544, -904},
    { 72, -456, -920},
    { 24, -520, -992},
    { 40, -528, -976},
    { -104, -584, -936},
    { -16, -488, -920},
    { -40, -472, -864},
    { -24, -464, -856},
    { 88, -520, -824},
    { 392, -456, -920},
    { 152, -536, -848},
    { 216, -456, -824},
    { 264, -552, -760},
    // 1 seconds
    { 368, -592, -688},
    { 392, -368, -592},
    { 312, -160, -640},
    { 312, -56, -640},
    { 352, 136, -568},
    { 472, 584, -840},
    { 392, 1024, -1248},
    { 208, 240, -1280},
    { 232, -16, -1504},
    { 152, -64, -1408},
    { 64, 432, -1208},
    { -96, 680, -1216},
    { -232, 752, -1352},
    { -120, 448, -1408},
    { -120, 272, -1232},
    { -208, 416, -1184},
    { -56, 536, -1200},
    { 128, 568, -1168},
    { 280, 496, -1200},
    { 432, 208, -1152},
    { 296, 112, -888},
    { 88, 168, -784},
    { 40, 280, -640},
    { 128, 144, -424},
    { 272, 0, -288},
    // 2 seconds
    { 536, 56, -152},
    { 672, 224, -120},
    { 712, 232, -152},
    { 1056, 144, -184},
    { 1368, 240, -496},
    { 2056, 320, -680},
    { 2712, 312, -800},
    { 2448, 288, -568},
    { 1784, 328, -592},
    { 1288, 448, -536},
    { 848, 504, -488},
    { 616, 288, -376},
    { 448, 368, -312},
    { 536, 648, -328},
    { 504, 592, -248},
    { 824, 704, -104},
    { 1400, 856, -304},
    { 2232, 504, -232},
    { 2352, 168, -152},
    { 2152, 200, -200},
    { 2032, 368, -240},
    { 1888, 416, -280},
    { 1472, 176, -144},
    { 1264, 8, -200},
    { 1032, -272, -80},
    // 3 seconds
    { 736, -424, 72},
    { 544, -224, -72},
    { 360, -176, -160},
    { 560, 160, -216},
    { 656, 912, -960},
    { 624, 1320, -1480},
    { 880, -552, -1144},
    { 1120, -576, -1432},
    { 616, 136, -1408},
    { 176, 328, -1176},
    { -80, 520, -920},
    { -416, 552, -776},
    { -528, 536, -736},
    { -184, 352, -760},
    { -16, 408, -936},
    { 680, 592, -1696},
    { 1744, 64, -1936},
    { 1592, 440, -1656},
    { 1032, 736, -1184},
    { 792, 488, -760},
    { 664, 112, -664},
    { 480, -72, -520},
    { 368, -16, -432},
    { 448, -24, -352},
    { 504, -208, -200},
    // 4 seconds
    { 544, -240, -128},
    { 512, -128, -168},
    { 792, -80, -136},
    { 1160, 392, -584},
    { 1664, 504, -904},
    { 2312, 224, -776},
    { 2760, 128, -720},
    { 2288, 528, -760},
    { 1336, 520, -536},
    { 912, 376, -456},
    { 760, 200, -224},
    { 584, 464, -48},
    { 424, 896, 8},
    { 376, 968, 112},
    { 1080, 1056, 264},
    { 1456, 896, -56},
    { 2056, 536, -208},
    { 2256, 416, -176},
    { 2232, 720, -40},
    { 2208, 600, -72},
    { 1952, 280, -264},
    { 1672, 56, -336},
    { 1272, -264, -232},
    { 1032, -368, -200},
    { 896, -464, -112},
    // 5 seconds
    { 656, -360, -16},
    { 360, -240, -160},
    { 600, -40, -168},
    { 752, 256, -456},
    { 1344, 624, -912},
    { 1776, 184, -608},
    { 2424, 24, -392},
    { 2440, 304, -664},
    { 1800, 448, -664},
    { 1184, 624, -208},
    { 848, 472, -296},
    { 672, 448, -128},
    { 688, 672, 8},
    { 544, 776, 104},
    { 1040, 1016, 400},
    { 1456, 1064, -88},
    { 1592, 512, -192},
    { 1808, 488, -168},
    { 2120, 832, -224},
    { 2464, 624, -48},
    { 2120, -64, -64},
    { 1720, -144, -296},
    { 1152, -312, -200},
    { 912, -328, -144},
    { 880, -296, -120},
    // 6 seconds
    { 760, -232, -160},
    { 536, -264, -232},
    { 832, -128, -48},
    { 1000, 48, -208},
    { 1712, 288, -664},
    { 2384, 184, -704},
    { 2536, 360, -296},
    { 1960, 456, -440},
    { 1400, 528, -352},
    { 1088, 432, -336},
    { 1032, 384, -200},
    { 992, 808, 128},
    { 552, 1264, 440},
    { 568, 1032, 240},
    { 1024, 952, 272},
    { 1560, 696, -184},
    { 1928, 664, -128},
    { 2360, 784, -56},
    { 2488, 640, -16},
    { 2232, 344, 0},
    { 1880, 32, -240},
    { 1464, 0, -264},
    { 1144, -16, -232},
    { 1032, -184, -312},
    { 920, -280, -192},
    // 7 seconds
    { 656, -248, -208},
    { 416, -224, -248},
    { 680, -48, -160},
    { 824, 24, -400},
    { 1520, 216, -552},
    { 2416, 280, -608},
    { 2552, 344, -544},
    { 1920, 376, -528},
    { 1400, 328, -424},
    { 1224, 456, -304},
    { 1136, 416, -192},
    { 1016, 728, -80},
    { 904, 1224, 288},
    { 600, 1192, 176},
    { 664, 816, 136},
    { 1048, 912, 104},
    { 1480, 696, -80},
    { 2176, 856, -64},
    { 2680, 728, -8},
    { 2464, 408, 72},
    { 1992, 48, -24},
    { 1528, 40, -224},
    { 1224, 80, -192},
    { 1128, 40, -248},
    { 984, 40, -272},
    // 8 seconds
    { 888, 40, -256},
    { 696, -96, -248},
    { 384, -104, -304},
    { 320, -144, -320},
    { 736, -32, -80},
    { 1152, 288, -616},
    { 1712, 312, -912},
    { 2000, 144, -616},
    { 2000, 264, -680},
    { 1624, 304, -536},
    { 1296, 376, -440},
    { 1184, 440, -368},
    { 1088, 608, -304},
    { 1096, 944, -176},
    { 992, 1272, -40},
    { 1064, 840, -256},
    { 776, 712, -144},
    { 864, 824, -48},
    { 1032, 696, -184},
    { 1584, 760, -120},
    { 2504, 704, -72},
    { 2528, 424, 8},
    { 2072, 216, -88},
    { 1720, 216, -208},
    { 1432, 208, -216},
    // 9 seconds
    { 1248, 144, -152},
    { 1040, 144, -248},
    { 872, 64, -256},
    { 776, -136, -208},
    { 512, -408, -184},
    { 384, -512, -424},
    { 768, -352, -192},
    { 968, -136, -272},
    { 1432, 72, -376},
    { 1968, 152, -448},
    { 2232, 320, -384},
    { 2224, 440, -224},
    { 1880, 536, -160},
    { 1728, 552, -184},
    { 1712, 480, -80},
    { 1512, 560, -24},
    { 1280, 640, 152},
    { 1176, 848, 272},
    { 728, 1288, 24},
    { 856, 856, 336},
    { 808, 856, 320},
    { 976, 696, -16},
    { 1368, 696, -120},
    { 1792, 608, -168},
    { 2104, 656, -248},
    // 10 seconds
    { 2224, 336, 32},
    { 2184, 168, -24},
    { 1968, 88, -248},
    { 1472, 104, -240},
    { 1208, 8, -248},
    { 936, -184, -184},
    { 616, -328, -104},
    { 408, -384, -248},
    { 720, -224, -160},
    { 976, -64, -352},
    { 1216, 64, -400},
    { 1688, 136, -432},
    { 1856, 200, -504},
    { 1672, 256, -328},
    { 1672, 312, -224},
    { 1536, 472, -248},
    { 1384, 544, -312},
    { 1280, 560, -320},
    { 1016, 664, -152},
    { 1000, 1016, -24},
    { 784, 912, -96},
    { 888, 880, -8},
    { 1016, 784, -80},
    { 1080, 608, -200},
    { 1488, 720, -168},
    // 11 seconds
    { 2128, 632, -144},
    { 2040, 472, -72},
    { 1904, 176, 16},
    { 1712, 80, -144},
    { 1528, 200, -232},
    { 1272, 152, -152},
    { 1032, 128, -224},
    { 760, 16, -224},
    { 664, -248, -248},
    { 456, -376, -248},
    { 600, -312, -152},
    { 1024, -16, -344},
    { 1280, 120, -504},
    { 1872, 192, -424},
    { 2040, 208, -648},
    { 1544, 280, -416},
    { 1312, 224, -224},
    { 1416, 296, -240},
    { 1296, 488, -272},
    { 1256, 600, -248},
    { 936, 816, -64},
    { 816, 944, -120},
    { 1048, 832, -48},
    { 840, 720, 8},
    { 1008, 808, 128},
    // 12 seconds
    { 1104, 728, -16},
    { 1032, 536, -136},
    { 1456, 648, -56},
    { 1888, 592, 0},
    { 1864, 496, 48},
    { 1928, 176, -128},
    { 1760, 176, -144},
    { 1584, 184, -184},
    { 1280, 112, -208},
    { 976, 64, -248},
    { 744, -24, -296},
    { 544, -248, -192},
    { 448, -336, -248},
    { 640, -304, -344},
    { 832, -128, -392},
    { 992, -40, -424},
    { 1440, 32, -352},
    { 1896, 168, -456},
    { 1912, 336, -392},
    { 1784, 296, -208},
    { 1400, 688, -296},
    { 1288, 568, -264},
    { 1232, 528, -128},
    { 1096, 568, -48},
    { 896, 648, 16},
    // 13 seconds
    { 1064, 664, 48},
    { 984, 632, 24},
    { 904, 672, 144},
    { 896, 856, 24},
    { 824, 712, -192},
    { 1152, 640, -144},
    { 1560, 720, -96},
    { 1800, 632, -48},
    { 1928, 200, 112},
    { 1928, 192, -144},
    { 1632, 40, -184},
    { 1336, 8, -280},
    { 1128, 64, -296},
    { 944, 40, -256},
    { 760, 0, -352},
    { 608, -120, -440},
    { 704, -296, -336},
    { 664, -328, -256},
    { 896, -128, -424},
    { 1072, 8, -328},
    { 1472, 96, -368},
    { 1632, 216, -352},
    { 1600, 304, -280},
    { 1520, 424, -200},
    { 1336, 552, -80},
    // 14 seconds
    { 1440, 512, -232},
    { 1352, 472, -168},
    { 1072, 456, -200},
    { 1184, 584, -120},
    { 1176, 800, -120},
    { 976, 872, -144},
    { 680, 880, -136},
    { 720, 712, -208},
    { 896, 672, -232},
    { 1248, 584, -168},
    { 1656, 496, -80},
    { 1856, 344, -80},
    { 1848, 240, -144},
    { 1672, 200, -200},
    { 1432, 248, -152},
    { 1232, 192, -112},
    { 1032, 176, -88},
    { 856, 216, -192},
    { 824, 128, -168},
    { 784, 64, -256},
    { 624, -128, -360},
    { 560, -296, -328},
    { 752, -288, -416},
    { 808, -136, -504},
    { 1192, -32, -432},
    // 15 seconds
    { 1680, 88, -592},
    { 1680, 256, -576},
    { 1400, 304, -320},
    { 1264, 304, -312},
    { 1280, 344, -328},
    { 1280, 416, -328},
    { 1080, 552, -216},
    { 816, 712, -120},
    { 1008, 824, -32},
    { 960, 864, 24},
    { 728, 720, 40},
    { 1144, 864, 144},
    { 1144, 632, -136},
    { 1128, 600, -184},
    { 1504, 760, -32},
    { 2040, 632, 64},
    { 2048, 376, 64},
    { 1960, 160, -104},
    { 1632, 88, -88},
    { 1424, 168, -168},
    { 1160, 96, -176},
    { 976, 136, -232},
    { 856, 80, -344},
    { 616, -208, -296},
    { 336, -456, -272},
    // 16 seconds
    { 488, -368, -240},
    { 632, -200, -352},
    { 1000, -16, -408},
    { 1472, 104, -384},
    { 1848, 152, -496},
    { 1808, 312, -448},
    { 1584, 352, -280},
    { 1584, 336, -248},
    { 1592, 528, -304},
    { 1560, 608, -272},
    { 1272, 776, -96},
    { 1160, 1072, -56},
    { 928, 1072, 0},
    { 736, 1048, 64},
    { 880, 960, 144},
    { 976, 728, -72},
    { 1296, 672, -160},
    { 1728, 688, -64},
    { 1992, 592, -48},
    { 1976, 304, -16},
    { 2032, 184, -216},
    { 1800, 144, -168},
    { 1440, 120, -232},
    { 1128, 24, -264},
    { 880, 32, -272},
    // 17 seconds
    { 752, -104, -328},
    { 512, -288, -272},
    { 400, -304, -360},
    { 736, -208, -376},
    { 744, -136, -480},
    { 1056, -48, -344},
    { 1656, 48, -384},
    { 2040, 312, -552},
    { 1848, 416, -400},
    { 1512, 568, -184},
    { 1248, 520, -360},
    { 1360, 480, -272},
    { 1232, 800, -200},
    { 896, 992, -80},
    { 960, 1032, 8},
    { 840, 888, 72},
    { 760, 704, 48},
    { 1272, 880, 160},
    { 1280, 720, -128},
    { 1360, 552, -160},
    { 1752, 640, -48},
    { 2088, 680, -16},
    { 2112, 288, -64},
    { 1968, 240, -200},
    { 1640, 136, -208},
    // 18 seconds
    { 1344, 152, -288},
    { 1080, 8, -280},
    { 720, -288, -264},
    { 592, -464, -136},
    { 448, -480, -264},
    { 424, -424, -328},
    { 744, -176, -128},
    { 912, 72, -224},
    { 1352, 192, -280},
    { 1840, 296, -432},
    { 1904, 408, -312},
    { 1520, 480, -272},
    { 1352, 384, -224},
    { 1584, 336, -400},
    { 1640, 464, -264},
    { 1296, 760, -96},
    { 1056, 952, 40},
    { 1024, 976, -64},
    { 816, 704, -32},
    { 984, 952, 168},
    { 1096, 928, 96},
    { 992, 728, -40},
    { 1328, 712, -24},
    { 1816, 720, -80},
    { 1952, 464, -24},
    // 19 seconds
    { 2064, 312, 64},
    { 2144, 216, -160},
    { 1728, 176, -144},
    { 1352, 112, -192},
    { 1024, 8, -192},
    { 840, -192, -192},
    { 616, -336, -304},
    { 656, -360, -232},
    { 776, -224, -288},
    { 832, -112, -440},
    { 1048, 0, -384},
    { 1480, 0, -416},
    { 1800, 176, -528},
    { 1904, 272, -496},
    { 1808, 568, -328},
    { 1488, 664, -144},
    { 1256, 600, -384},
    { 1320, 472, -176},
    { 1120, 880, -8},
    { 832, 1408, -48},
    { 792, 1040, 40},
    { 920, 1112, 64},
    { 1240, 872, -40},
    { 1248, 600, -280},
    { 1544, 616, -248},
    // 20 seconds
    { 1992, 688, -112},
    { 2296, 584, -72},
    { 2064, 216, -104},
    { 1792, 208, -168},
    { 1456, 96, -232},
    { 1232, 48, -280},
    { 912, -64, -184},
    { 632, -264, -128},
    { 560, -232, -296},
    { 520, -336, -408},
    { 464, -296, -368},
    { 840, -152, -272},
    { 1184, -96, -352},
    { 1616, 64, -352},
    { 2224, 272, -440},
    { 2328, 448, -512},
    { 1880, 496, -288},
    { 1480, 480, -232},
    { 1440, 440, -136},
    { 1504, 448, -200},
    { 1312, 496, -152},
    { 1024, 592, 48},
    { 968, 1280, -72},
    { 552, 1160, -160},
    { 496, 872, -48},
    // 21 seconds
    { 880, 968, 32},
    { 1496, 768, -216},
    { 1800, 536, -232},
    { 2624, 408, -240},
    { 2488, 328, -88},
    { 2320, 200, -136},
    { 1888, 256, -232},
    { 1584, 248, -160},
    { 1328, 72, -208},
    { 1000, -192, -128},
    { 728, -336, -192},
    { 552, -440, -192},
    { 528, -280, -152},
    { 504, -184, -200},
    { 888, 8, -72},
    { 1288, 120, -232},
    { 1840, 288, -328},
    { 2560, 424, -408},
    { 2296, 560, -592},
    { 1464, 552, -440},
    { 1432, 336, -328},
    { 1464, 248, -376},
    { 1296, 616, -432},
    { 1008, 856, -264},
    { 768, 832, -112},
    // 22 seconds
    { 872, 896, -96},
    { 840, 776, -64},
    { 1040, 880, 56},
    { 1336, 824, -120},
    { 1328, 600, -200},
    { 1816, 608, -192},
    { 2128, 576, -40},
    { 2024, 336, 40},
    { 1808, 144, -64},
    { 1472, 72, -184},
    { 1368, 184, -208},
    { 1080, 96, -168},
    { 984, 64, -248},
    { 800, 32, -320},
    { 704, -144, -224},
    { 592, -280, -272},
    { 872, -200, -264},
    { 896, -56, -456},
    { 1120, 24, -384},
    { 1616, 96, -384},
    { 1824, 216, -544},
    { 1688, 280, -416},
    { 1576, 424, -328},
    { 1448, 472, -240},
    { 1256, 560, -200},
    // 23 seconds
    { 1256, 496, -208},
    { 1008, 528, -104},
    { 848, 648, 32},
    { 896, 832, 120},
    { 640, 920, 88},
    { 928, 840, 208},
    { 1248, 864, 0},
    { 1216, 560, -184},
    { 1600, 656, -184},
    { 2208, 760, -168},
    { 2248, 552, 40},
    { 2112, 128, 24},
    { 1832, 40, -152},
    { 1464, 32, -200},
    { 1112, 0, -224},
    { 920, -40, -168},
    { 656, -176, -240},
    { 520, -224, -240},
    { 448, -248, -264},
    { 888, -88, -144},
    { 1096, 40, -304},
    { 1480, 120, -416},
    { 2016, 216, -352},
    { 2032, 320, -432},
    { 1616, 248, -384},
    // 24 seconds
    { 1352, 312, -264},
    { 1336, 504, -248},
    { 1288, 472, -160},
    { 1144, 592, -56},
    { 960, 720, 24},
    { 1008, 888, 112},
    { 912, 928, 128},
    { 736, 664, 120},
    { 1152, 864, 200},
    { 1272, 672, -72},
    { 1320, 584, -168},
    { 1720, 728, -80},
    { 2184, 696, -72},
    { 2200, 96, 128},
    { 2072, 48, -152},
    { 1624, 64, -184},
    { 1352, 0, -272},
    { 1048, 48, -288},
    { 800, -8, -224},
    { 664, -120, -200},
    { 520, -208, -328},
    { 528, -160, -328},
    { 824, -64, -200},
    { 920, -32, -312},
    { 1248, 120, -344},
    // 25 seconds
    { 1624, 200, -384},
    { 1816, 336, -432},
    { 1696, 360, -304},
    { 1504, 408, -104},
    { 1424, 672, -272},
    { 1384, 552, -224},
    { 1264, 712, -112},
    { 1088, 792, -48},
    { 1088, 888, -8},
    { 880, 848, -32},
    { 616, 728, -8},
    { 1008, 984, 160},
    { 1208, 768, -168},
    { 1280, 544, -240},
    { 1744, 688, -144},
    { 2104, 528, -104},
    { 2008, 264, 96},
    { 1920, 136, -152},
    { 1440, 104, -192},
    { 1280, 144, -240},
    { 1000, 40, -320},
    { 800, -32, -296},
    { 600, -64, -280},
    { 576, -224, -264},
    { 416, -272, -416},
    // 26 seconds
    { 752, -160, -216},
    { 1112, 0, -168},
    { 1408, 144, -448},
    { 1832, 256, -408},
    { 1968, 304, -448},
    { 1624, 328, -368},
    { 1392, 304, -280},
    { 1328, 504, -264},
    { 1264, 424, -176},
    { 1240, 480, -120},
    { 1112, 648, -16},
    { 1008, 768, 136},
    { 1016, 992, 128},
    { 704, 760, 168},
    { 808, 840, 264},
    { 1208, 864, 200},
    { 1240, 672, -72},
    { 1608, 672, -112},
    { 2160, 736, -40},
    { 2472, 648, -16},
    { 2216, 168, 32},
    { 1944, 48, -72},
    { 1504, 136, -192},
    { 1248, 80, -200},
    { 968, 24, -152},
    // 27 seconds
    { 816, -8, -168},
    { 624, -64, -208},
    { 440, -112, -264},
    { 608, -72, -168},
    { 584, -40, -200},
    { 880, 16, -448},
    { 1336, 88, -336},
    { 2024, 240, -320},
    { 2136, 408, -504},
    { 1712, 480, -424},
    { 1304, 848, -184},
    { 1272, 360, -288},
    { 1336, 336, -112},
    { 1192, 608, -112},
    { 1176, 720, 104},
    { 1048, 800, 232},
    { 856, 1056, 232},
    { 1232, 976, 256},
    { 896, 520, 0},
    { 992, 640, -56},
    { 1488, 888, -104},
    { 2072, 704, -56},
    { 2152, 520, 160},
    { 2080, 88, 80},
    { 1648, 40, -80},
    // 28 seconds
    { 1328, 16, -24},
    { 1072, 128, -104},
    { 960, 176, -128},
    { 816, 96, -160},
    { 576, -56, -160},
    { 352, -152, -168},
    { 504, -104, -192},
    { 560, -64, -168},
    { 944, 48, -232},
    { 1528, 216, -456},
    { 2040, 280, -584},
    { 2136, 384, -664},
    { 1704, 504, -576},
    { 1384, 408, -424},
    { 1328, 392, -400},
    { 1232, 536, -256},
    { 1008, 816, -104},
    { 912, 1152, -32},
    { 720, 928, -72},
    { 552, 648, -48},
    { 1040, 824, 40},
    { 1416, 800, -120},
    { 1576, 600, -168},
    { 1928, 712, -72},
    { 2136, 576, -56},
    // 29 seconds
    { 1960, 216, 8},
    { 1776, 112, -184},
    { 1424, -40, -192},
    { 1144, -16, -256},
    { 944, -32, -312},
    { 832, -168, -240},
    { 472, -392, -64},
    { 392, -464, -320},
    { 408, -336, -352},
    { 1048, -72, -176},
    { 1392, 72, -248},
    { 1792, 192, -424},
    { 2128, 320, -520},
    { 1952, 440, -376},
    { 1488, 368, -200},
    { 1360, 312, -216},
    { 1304, 424, -248},
    { 1192, 504, -144},
    { 984, 600, -96},
    { 720, 584, -32},
    { 720, 752, 16},
    { 776, 864, 32},
    { 768, 648, 8},
    { 1248, 1000, -8},
    { 1264, 720, -312},
    // 30 seconds
    { 1592, 592, -176},
    { 2256, 680, -176},
    { 2320, 360, -16},
    { 1936, -88, 56},
    { 1520, 104, -208},
    { 1336, 48, -192},
    { 1048, 128, -128},
    { 864, 72, -128},
    { 736, 64, -176},
    { 696, 8, -184},
    { 528, -104, -192},
    { 664, -96, -128},
    { 768, -8, -176},
    { 936, 72, -400},
    { 1448, 168, -352},
    { 2272, 272, -528},
    { 2304, 424, -576},
    { 1696, 536, -440},
    { 1352, 456, -328},
    { 1096, 464, -376},
    { 1032, 368, -264},
    { 960, 608, -40},
    { 856, 864, 144},
    { 720, 936, 248},
    { 568, 752, 184},
    // 31 seconds
    { 1096, 880, 320},
    { 1560, 808, 16},
    { 1712, 568, -144},
    { 1936, 752, -64},
    { 2088, 840, -64},
    { 2360, 392, 216},
    { 2016, 64, -96},
    { 1600, -112, -104},
    { 1200, -48, -256},
    { 968, -104, -216},
    { 712, -248, -96},
    { 536, -200, -80},
    { 336, -160, -208},
    { 680, -32, -112},
    { 936, 40, -184},
    { 1344, 184, -336},
    { 2040, 224, -560},
    { 2408, 320, -576},
    { 2016, 352, -320},
    { 1552, 392, -384},
    { 1200, 512, -496},
    { 1216, 352, -312},
    { 1072, 504, -40},
    { 904, 960, 152},
    { 696, 1056, 248},
    // 32 seconds
    { 648, 880, 168},
    { 1152, 968, 224},
    { 1344, 704, -8},
    { 1568, 624, -104},
    { 1904, 824, 48},
    { 2136, 720, 40},
    { 2016, 240, 72},
    { 1928, 120, -80},
    { 1520, 176, -48},
    { 1328, 208, -96},
    { 1064, 176, -120},
    { 1000, 128, -176},
    { 816, -64, -128},
    { 560, -184, -96},
    { 568, -120, -216},
    { 640, -72, -184},
    { 696, 24, -296},
    { 1104, 72, -296},
    { 1760, 136, -456},
    { 2096, 216, -592},
    { 1816, 320, -512},
    { 1432, 456, -480},
    { 1248, 408, -416},
    { 1160, 432, -416},
    { 1056, 568, -240},
    // 33 seconds
    { 904, 800, -144},
    { 888, 992, -64},
    { 792, 712, -48},
    { 968, 736, 88},
    { 1264, 880, -88},
    { 1376, 656, -136},
    { 1680, 632, -120},
    { 2040, 632, -48},
    { 1944, 416, -8},
    { 1768, 160, -104},
    { 1512, 176, -152},
    { 1264, 136, -168},
    { 1136, 104, -240},
    { 976, -24, -400},
    { 776, -16, -232},
    { 560, -16, -200},
    { 392, -72, -336},
    { 336, -80, -216},
    { 552, 56, -232},
    { 744, 48, -512},
    { 1192, 216, -544},
    { 1944, 176, -664},
    { 2056, 200, -712},
    { 1568, 64, -448},
    { 1280, 384, -208},
    // 34 seconds
    { 1264, 360, -664},
    { 1144, 776, -536},
    { 920, 1088, -176},
    { 848, 984, -80},
    { 880, 744, 56},
    { 648, 608, 104},
    { 1072, 744, 352},
    { 1184, 728, 176},
    { 1624, 640, 8},
    { 2016, 632, 24},
    { 2216, 552, -56},
    { 1896, 328, -160},
    { 1536, 120, -176},
    { 1232, 112, -264},
    { 1032, 56, -296},
    { 904, 0, -296},
    { 824, -16, -304},
    { 768, -160, -368},
    { 536, -256, -352},
    { 480, -192, -288},
    { 728, -56, -248},
    { 1008, 16, -352},
    { 1512, 168, -448},
    { 2032, 312, -608},
    { 1992, 376, -632},
    // 35 seconds
    { 1472, 320, -392},
    { 1344, 344, -304},
    { 1344, 264, -272},
    { 1352, 408, -248},
    { 1152, 608, -104},
    { 928, 800, 64},
    { 816, 1016, 128},
    { 648, 720, 120},
    { 880, 776, 312},
    { 1176, 832, 176},
    { 1456, 680, -32},
    { 1744, 720, -112},
    { 2104, 696, -88},
    { 2096, 528, -168},
    { 1984, 120, -152},
    { 1688, 72, -192},
    { 1392, -104, -288},
    { 1088, -200, -232},
    { 728, -320, -120},
    { 560, -288, -256},
    { 472, -288, -216},
    { 416, -240, -248},
    { 744, -24, -160},
    { 1176, 120, -184},
    { 1760, 216, -344},
    // 36 seconds
    { 2496, 400, -552},
    { 2312, 640, -592},
    { 1480, 352, -360},
    { 1240, 280, -256},
    { 1336, 288, -304},
    { 1240, 424, -192},
    { 1024, 688, 8},
    { 856, 976, 160},
    { 744, 1168, 152},
    { 648, 664, 192},
    { 864, 776, 224},
    { 1168, 800, 112},
    { 1568, 616, -96},
    { 2016, 656, -96},
    { 2168, 680, -48},
    { 2064, 480, -56},
    { 1888, 192, -176},
    { 1520, 24, -128},
    { 1288, -32, -280},
    { 1048, -88, -256},
    { 744, -192, -208},
    { 632, -240, -192},
    { 520, -240, -216},
    { 376, -216, -272},
    { 760, -24, -136},
    // 37 seconds
    { 1048, 88, -192},
    { 1664, 312, -376},
    { 2072, 432, -512},
    { 2072, 440, -432},
    { 1696, 384, -288},
    { 1424, 336, -376},
    { 1384, 376, -224},
    { 1296, 448, -184},
    { 1200, 464, -64},
    { 1096, 600, 152},
    { 896, 688, 320},
    { 656, 872, 280},
    { 1016, 992, 488},
    { 1056, 696, 160},
    { 1136, 576, -64},
    { 1416, 712, -112},
    { 1680, 736, -280},
    { 1936, 792, -72},
    { 2464, 184, 272},
    { 2096, 80, -80},
    { 1408, -192, -112},
    { 1064, -112, -192},
    { 880, -168, -160},
    { 720, -88, -152},
    { 528, -80, -120},
    // 38 seconds
    { 744, -40, -80},
    { 696, 32, -160},
    { 1032, 112, -368},
    { 1608, 184, -416},
    { 2056, 304, -464},
    { 1952, 184, -408},
    { 1536, 144, -416},
    { 1368, 320, -376},
    { 1160, 416, -160},
    { 1024, 528, -256},
    { 896, 568, -112},
    { 816, 768, -48},
    { 696, 824, 88},
    { 784, 808, 136},
    { 1256, 928, 152},
    { 1448, 736, -72},
    { 1600, 616, -144},
    { 1952, 712, -104},
    { 2032, 600, -8},
    { 2000, 280, -16},
    { 1880, 136, -176},
    { 1520, 152, -184},
    { 1240, 96, -248},
    { 992, -72, -160},
    { 704, -272, -96},
    // 39 seconds
    { 560, -256, -168},
    { 440, -176, -248},
    { 624, -80, -80},
    { 952, 24, -232},
    { 1224, 152, -464},
    { 1816, 248, -544},
    { 2352, 336, -720},
    { 2288, 384, -592},
    { 1800, 648, -512},
    { 1400, 672, -344},
    { 1168, 624, -464},
    { 896, 800, -224},
    { 856, 1032, 32},
    { 688, 1032, 192},
    { 592, 808, 232},
    { 1064, 984, 264},
    { 1480, 872, 32},
    { 1968, 688, -128},
    { 2400, 704, -48},
    { 2480, 648, 56},
    { 2200, 312, -32},
    { 1792, 136, -144},
    { 1384, 144, -88},
    { 1136, 128, -144},
    { 920, 128, -152},
    // 40 seconds
    { 728, 72, -152},
    { 696, 40, -200},
    { 624, -56, -240},
    { 368, -200, -200},
    { 704, -72, -160},
    { 728, -8, -384},
    { 1408, 312, -664},
    { 1824, 280, -568},
    { 2248, 256, -576},
    { 2024, 408, -584},
    { 1712, 416, -472},
    { 1528, 632, -296},
    { 1256, 680, -152},
    { 1112, 616, -56},
    { 1080, 800, 56},
    { 952, 968, 152},
    { 688, 880, 120},
    { 952, 792, 288},
    { 1096, 824, 136},
    { 1304, 696, -16},
    { 1544, 760, -48},
    { 2104, 784, -112},
    { 2176, 496, 88},
    { 2120, 176, 48},
    { 1784, 160, -120},
    // 41 seconds
    { 1440, 112, -184},
    { 1184, 80, -144},
    { 976, 48, -176},
    { 880, 24, -240},
    { 720, -24, -216},
    { 488, -192, -192},
    { 680, -112, -144},
    { 672, -24, -344},
    { 912, 64, -448},
    { 1456, 120, -400},
    { 2016, 184, -536},
    { 1920, 336, -496},
    { 1648, 376, -360},
    { 1416, 576, -336},
    { 1328, 432, -288},
    { 1264, 536, -224},
    { 1040, 584, -40},
    { 1032, 680, 64},
    { 872, 776, 112},
    { 624, 736, 56},
    { 1088, 1016, 312},
    { 1304, 792, -24},
    { 1256, 528, -160},
    { 1488, 720, -112},
    { 1936, 808, -96},
    // 42 seconds
    { 2032, 424, 136},
    { 1792, 128, 48},
    { 1520, -16, -136},
    { 1256, 32, -200},
    { 1048, 56, -152},
    { 952, 8, -192},
    { 792, -16, -208},
    { 576, -184, -240},
    { 440, -232, -224},
    { 768, -64, -208},
    { 864, 24, -272},
    { 1328, 168, -376},
    { 1960, 240, -584},
    { 2000, 248, -432},
    { 1552, 288, -272},
    { 1376, 232, -280},
    { 1256, 392, -224},
    { 1168, 536, -184},
    { 992, 560, -56},
    { 904, 704, 56},
    { 856, 856, 56},
    { 712, 776, 80},
    { 584, 712, 56},
    { 1104, 1104, 224},
    { 1408, 752, -104},
    // 43 seconds
    { 1784, 552, -120},
    { 2296, 760, -112},
    { 2232, 480, 0},
    { 1984, 96, 32},
    { 1568, 232, -80},
    { 1376, 136, -192},
    { 1056, 104, -136},
    { 968, 16, -232},
    { 848, -64, -288},
    { 720, -288, -248},
    { 448, -776, -352},
    { 496, -464, -64},
    { 880, -160, -184},
    { 1312, 88, -520},
    { 1912, 280, -536},
    { 2448, 496, -600},
    { 2336, 632, -384},
    { 1960, 432, -216},
    { 1624, 600, -256},
    { 1408, 448, -136},
    { 1216, 904, -32},
    { 856, 1328, 376},
    { 528, 1376, 512},
    { 528, 1120, 768},
    { 1000, 1040, 584},
    // 44 seconds
    { 1568, 776, -24},
    { 2240, 792, -120},
    { 2856, 888, -240},
    { 2672, 520, -152},
    { 2256, 96, -224},
    { 1856, -16, -360},
    { 1352, -80, -344},
    { 1072, -168, -344},
    { 776, -248, -256},
    { 744, -160, -248},
    { 568, -224, -240},
    { 416, -216, -192},
    { 792, -32, -48},
    { 640, -64, -368},
    { 1152, 184, -544},
    { 1808, 280, -792},
    { 2416, 416, -672},
    { 2400, 520, -672},
    { 1800, 600, -680},
    { 1320, 664, -488},
    { 1176, 792, -600},
    { 800, 968, -352},
    { 688, 1080, -56},
    { 712, 936, 144},
    { 552, 760, 184},
    // 45 seconds
    { 1152, 992, 392},
    { 1376, 872, 40},
    { 1760, 648, -120},
    { 2312, 688, -48},
    { 2488, 608, -72},
    { 2120, 368, -200},
    { 1824, 120, -320},
    { 1352, -128, -280},
    { 1000, -224, -232},
    { 656, -256, -224},
    { 576, -184, -304},
    { 584, -128, -328},
    { 576, -224, -280},
    { 504, -184, -304},
    { 560, -88, -288},
    { 1248, 72, -176},
    { 1744, 184, -448},
    { 2560, 416, -648},
    { 2720, 552, -760},
    { 1784, 584, -392},
    { 1304, 432, -304},
    { 1312, 272, -208},
    { 1008, 528, -168},
    { 720, 720, 40},
    { 632, 872, 288},
    // 46 seconds
    { 568, 976, 320},
    { 552, 624, 280},
    { 728, 584, 152},
    { 1352, 904, 232},
    { 2008, 768, -120},
    { 2424, 712, -104},
    { 2616, 760, -16},
    { 2456, 488, 88},
    { 2008, -104, -216},
    { 1344, -152, -112},
    { 1008, -80, -144},
    { 792, -80, -200},
    { 744, -48, -232},
    { 824, -80, -184},
    { 664, -288, -72},
    { 552, -272, -80},
    { 976, -8, -104},
    { 1232, 112, -472},
    { 1848, 376, -632},
    { 2520, 304, -624},
    { 2560, 512, -520},
    { 1920, 384, -480},
    { 1480, 984, -440},
    { 1256, 528, -408},
    { 824, 568, -208},
    // 47 seconds
    { 616, 832, -16},
    { 544, 992, 144},
    { 640, 792, 112},
    { 760, 720, 176},
    { 1240, 896, 16},
    { 1536, 640, -176},
    { 2048, 600, -80},
    { 2368, 592, 24},
    { 2224, 568, -88},
    { 1872, 328, -152},
    { 1560, 168, -232},
    { 1240, 128, -184},
    { 984, 72, -160},
    { 704, -48, -248},
    { 680, -88, -352},
    { 696, -208, -280},
    { 536, -328, -104},
    { 392, -248, -184},
    { 848, 0, -40},
    { 1096, 120, -400},
    { 1904, 312, -544},
    { 2840, 352, -808},
    { 2536, 296, -640},
    { 1880, 336, -560},
    { 1544, 640, -592},
    // 48 seconds
    { 1376, 288, -416},
    { 1096, 608, -272},
    { 672, 864, -88},
    { 488, 920, 8},
    { 392, 840, 96},
    { 432, 640, 72},
    { 968, 744, 144},
    { 1536, 800, 0},
    { 2080, 712, -104},
    { 2256, 568, -64},
    { 2472, 552, -272},
    { 2056, 352, -112},
    { 1904, 112, -272},
    { 1424, -56, -272},
    { 1088, -144, -256},
    { 824, -136, -288},
    { 672, -136, -240},
    { 648, -128, -304},
    { 528, -216, -264},
    { 392, -200, -280},
    { 664, -48, -128},
    { 752, 24, -320},
    { 1256, 288, -616},
    { 1928, 384, -616},
    { 2480, 368, -528},
    // 49 seconds
    { 2352, 456, -488},
    { 1872, 528, -576},
    { 1504, 648, -440},
    { 1120, 592, -240},
    { 776, 592, -120},
    { 520, 720, -8},
    { 432, 784, 120},
    { 488, 752, 176},
    { 992, 904, 272},
    { 1440, 808, -40},
    { 1640, 584, -104},
    { 1968, 632, -64},
    { 2232, 720, -232},
    { 2160, 472, -56},
    { 1792, 16, -208},
    { 1440, -152, -280},
    { 1016, -216, -240},
    { 920, -120, -272},
    { 776, -64, -312},
    { 744, -64, -264},
    { 632, -168, -232},
    { 432, -200, -288},
    { 336, -128, -288},
    { 912, 24, -208},
    { 1336, 88, -328},
    // 50 seconds
    { 2168, 256, -600},
    { 2640, 400, -712},
    { 2160, 328, -448},
    { 1520, 672, -352},
    { 1160, 328, -280},
    { 1096, 360, -216},
    { 824, 496, -128},
    { 632, 672, 72},
    { 624, 840, 224},
    { 632, 888, 104},
    { 696, 528, 24},
    { 1184, 744, 64},
    { 1592, 784, -168},
    { 1688, 680, -136},
    { 2120, 632, -128},
    { 2288, 496, -64},
    { 2080, 176, -72},
    { 1672, 80, -176},
    { 1208, 32, -232},
    { 1056, 48, -208},
    { 776, -32, -160},
    { 688, -40, -184},
    { 696, -128, -200},
    { 592, -184, -232},
    { 600, -128, -184},
    // 51 seconds
    { 936, 8, -200},
    { 1144, 88, -376},
    { 1720, 192, -440},
    { 2240, 264, -544},
    { 2224, 296, -560},
    { 1840, 360, -408},
    { 1536, 504, -312},
    { 1344, 576, -328},
    { 1208, 480, -192},
    { 976, 672, 48},
    { 864, 936, 248},
    { 712, 968, 296},
    { 536, 752, 168},
    { 1056, 992, 360},
    { 1192, 648, -64},
    { 1584, 616, -112},
    { 2152, 784, -8},
    { 2384, 704, -40},
    { 2136, 264, 88},
    { 2032, 248, -144},
    { 1680, 136, -256},
    { 1272, 88, -264},
    { 1104, -8, -272},
    { 824, -192, -256},
    { 680, -312, -176},
    // 52 seconds
    { 488, -272, -248},
    { 568, -112, -136},
    { 832, 16, -72},
    { 1080, 168, -448},
    { 1640, 272, -592},
    { 2280, 312, -288},
    { 2368, 264, -376},
    { 2040, 272, -472},
    { 1648, 976, -568},
    { 1392, 440, -200},
    { 1264, 488, -152},
    { 1096, 744, 112},
    { 904, 976, 304},
    { 688, 904, 344},
    { 848, 808, 360},
    { 984, 744, 176},
    { 1288, 632, -32},
    { 1712, 736, 0},
    { 2176, 896, 80},
    { 2360, 624, 0},
    { 2176, 88, 168},
    { 2000, 160, -272},
    { 1608, 24, -208},
    { 1432, -24, -296},
    { 1032, -320, -152},
    // 53 seconds
    { 648, -488, -32},
    { 528, -368, -208},
    { 448, -296, -304},
    { 872, -56, -40},
    { 1184, 88, -192},
    { 1800, 240, -256},
    { 2304, 384, -408},
    { 2128, 392, -448},
    { 1720, 368, -240},
    { 1456, 424, -144},
    { 1392, 480, -256},
    { 1336, 448, -216},
    { 1144, 592, 8},
    { 1024, 752, 184},
    { 872, 1040, 224},
    { 624, 848, 152},
    { 952, 920, 232},
    { 1232, 864, 16},
    { 1408, 600, -264},
    { 1608, 744, -304},
    { 2080, 888, -72},
    { 2448, 624, 32},
    { 2136, -8, 88},
    { 1720, -128, -104},
    { 1272, 72, -216},
    // 54 seconds
    { 1000, 40, -216},
    { 832, 8, -192},
    { 656, -72, -152},
    { 488, -184, -144},
    { 440, -200, -232},
    { 864, 0, -216},
    { 960, 32, -312},
    { 1496, 128, -360},
    { 2184, 256, -472},
    { 2128, 376, -480},
    { 1584, 384, -312},
    { 1344, 264, -280},
    { 1232, 416, -296},
    { 1160, 464, -304},
    { 984, 456, -136},
    { 872, 632, -48},
    { 928, 808, 8},
    { 832, 784, -144},
    { 592, 552, -80},
    { 832, 688, 64},
    { 1408, 928, -192},
    { 1480, 544, -232},
    { 1944, 504, -136},
    { 2056, 504, -136},
    { 2064, 344, -104},
    // 55 seconds
    { 1832, 160, -56},
    { 1376, 288, -136},
    { 1192, 392, -200},
    { 1072, 552, -232},
    { 872, 688, -208},
    { 736, 680, -352},
    { 552, 456, -488},
    { 336, 208, -648},
    { 80, 56, -768},
    { -16, 40, -912},
    { -304, -128, -976},
    { -168, -88, -1072},
    { -104, -232, -1016},
    { -216, -264, -936},
    { -256, -256, -896},
    { -328, -272, -840},
    { -328, -320, -792},
    { -320, -344, -728},
    { -304, -400, -800},
    { -240, -432, -968},
    { -184, -400, -1096},
    { -112, -376, -1216},
    { 40, -584, -1080},
    { -520, -344, -888},
    { -184, -296, -1272},
    // 56 seconds
    { -688, -256, -1040},
    { -512, -440, -840},
    { -448, -384, -896},
    { -504, -272, -904},
    { -512, -160, -896},
    { -496, -192, -824},
    { -408, -208, -848},
    { -360, -176, -944},
    { -424, -240, -936},
    { -512, -256, -872},
    { -496, -296, -872},
    { -432, -464, -856},
    { -480, -344, -896},
    { -488, -320, -880},
    { -448, -336, -920},
    { -448, -336, -936},
    { -392, -344, -936},
    { -368, -328, -960},
    { -352, -352, -952},
    { -344, -408, -928},
    { -192, -344, -736},
    { -464, -432, -896},
    { -352, -544, -920},
    { -272, -376, -984},
    { -304, -400, -960},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-01 09:37:05 local
AccelRawData *activity_sample_walk_100_pbl_25471_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25471_9
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -424, 88, -992},
    { -424, 8, -896},
    { -416, -32, -888},
    { -336, 32, -1008},
    { -296, 80, -1096},
    { -328, 392, -1136},
    { -384, 592, -1024},
    { -544, 864, -704},
    { -664, 872, -480},
    { -680, 752, -488},
    { -584, 488, -552},
    { -512, 320, -544},
    { -352, 152, -824},
    { -328, 520, -816},
    { -312, 568, -856},
    { -256, 632, -776},
    { -88, 624, -672},
    { -336, 600, -744},
    { -224, 576, -696},
    { -352, 712, -672},
    { -392, 448, -752},
    { -256, 472, -800},
    { -296, 552, -752},
    { -344, 416, -888},
    { -384, 360, -984},
    // 1 seconds
    { -312, 320, -944},
    { -304, 288, -920},
    { -336, 248, -952},
    { -400, 304, -920},
    { -456, 320, -880},
    { -376, 288, -928},
    { -400, 248, -896},
    { -392, 256, -872},
    { -368, 208, -928},
    { -408, 160, -944},
    { -192, -24, -672},
    { -168, 352, -1056},
    { -288, 280, -976},
    { -304, 200, -928},
    { -312, 176, -912},
    { -328, 80, -912},
    { -368, 40, -848},
    { -384, 40, -840},
    { -448, 160, -872},
    { -520, 200, -872},
    { -552, 288, -864},
    { -464, 288, -912},
    { -504, 320, -840},
    { -472, 296, -872},
    { -320, 48, -944},
    // 2 seconds
    { -352, 192, -840},
    { -376, 184, -840},
    { -360, 232, -824},
    { -312, 256, -928},
    { -120, 280, -1096},
    { 144, -88, -1064},
    { 304, -344, -720},
    { 432, -312, -592},
    { 600, 0, -488},
    { 816, 168, -232},
    { 1280, 216, -32},
    { 1848, 288, 24},
    { 2600, 704, -304},
    { 2168, 984, -384},
    { 1472, 776, -104},
    { 936, 592, -232},
    { 1208, 632, -360},
    { 872, 752, -464},
    { 824, 576, -368},
    { 856, 552, -256},
    { 1168, 512, -216},
    { 1376, 280, -176},
    { 1280, 152, -144},
    { 1448, 104, -168},
    { 1712, 192, -176},
    // 3 seconds
    { 1640, 208, -176},
    { 1384, 232, -216},
    { 1240, 16, -256},
    { 1000, -368, -208},
    { 688, -432, -152},
    { 608, -416, -248},
    { 976, -144, -200},
    { 984, 0, -392},
    { 1208, 40, -328},
    { 1536, 176, -320},
    { 1400, 72, -440},
    { 1280, 184, -272},
    { 1248, 160, -320},
    { 1208, 288, -320},
    { 1184, 528, -384},
    { 1072, 968, -376},
    { 824, 1344, -576},
    { 904, 1008, -424},
    { 920, 616, -424},
    { 1536, 720, -432},
    { 1792, 544, -344},
    { 2064, 360, -112},
    { 2296, 296, 32},
    { 2264, 184, 128},
    { 1680, 264, 8},
    // 4 seconds
    { 1592, 192, -80},
    { 1312, 184, 16},
    { 1112, 24, -128},
    { 816, -240, -40},
    { 696, -400, -104},
    { 736, -448, -152},
    { 792, -336, -216},
    { 864, -184, -240},
    { 944, -120, -440},
    { 1296, -96, -320},
    { 1744, -184, -496},
    { 2000, -152, -360},
    { 2136, 112, -288},
    { 2112, 392, -432},
    { 1824, 648, -304},
    { 1152, 776, -288},
    { 1256, 312, -16},
    { 1256, 680, 216},
    { 1088, 816, 352},
    { 880, 744, 360},
    { 1032, 888, 336},
    { 864, 512, 0},
    { 1240, 568, 0},
    { 1488, 680, 8},
    { 1824, 664, -24},
    // 5 seconds
    { 2024, 512, -168},
    { 1960, 248, 320},
    { 1984, -120, -8},
    { 1440, -296, -152},
    { 1216, -280, -248},
    { 968, -432, -48},
    { 792, -368, -136},
    { 664, -376, -232},
    { 504, -304, -272},
    { 824, -128, -200},
    { 1200, -16, -264},
    { 1680, 64, -304},
    { 2304, 96, -376},
    { 2232, 224, -368},
    { 1584, 344, -200},
    { 1216, 400, -384},
    { 1152, 352, -184},
    { 1008, 456, -48},
    { 888, 584, 176},
    { 816, 800, 424},
    { 680, 1048, 168},
    { 880, 832, 288},
    { 1168, 808, 48},
    { 1368, 704, -144},
    { 2040, 824, 16},
    // 6 seconds
    { 2632, 544, 48},
    { 2544, 264, -24},
    { 2056, -80, -16},
    { 1624, -312, -128},
    { 1136, -440, -48},
    { 880, -304, -168},
    { 808, -216, -184},
    { 728, -240, -120},
    { 544, -208, -120},
    { 728, -80, -104},
    { 824, 0, -192},
    { 1224, 56, -312},
    { 1976, -8, -408},
    { 2656, 8, -544},
    { 2392, 112, -616},
    { 1624, 312, -568},
    { 1192, 472, -400},
    { 1088, 272, -392},
    { 968, 512, -160},
    { 992, 736, -72},
    { 968, 832, 40},
    { 744, 712, 16},
    { 608, 688, 136},
    { 1096, 832, 152},
    { 1616, 680, -168},
    // 7 seconds
    { 2104, 560, -72},
    { 2680, 544, -32},
    { 2696, 304, -144},
    { 2168, -48, -96},
    { 1704, -384, -168},
    { 1080, -512, -112},
    { 640, -456, -200},
    { 544, -360, -224},
    { 536, -376, -160},
    { 552, -256, -176},
    { 704, -144, -152},
    { 1000, -8, -160},
    { 1384, 152, -352},
    { 2048, 208, -536},
    { 2648, 208, -592},
    { 2232, 232, -536},
    { 1640, 304, -544},
    { 1376, 296, -376},
    { 1128, 480, -424},
    { 840, 488, -360},
    { 696, 712, -256},
    { 504, 816, -176},
    { 600, 840, -32},
    { 1056, 840, -248},
    { 1456, 520, -296},
    // 8 seconds
    { 2024, 376, -280},
    { 2472, 312, -296},
    { 2280, 160, -224},
    { 1864, -48, -288},
    { 1456, -152, -320},
    { 1096, -296, -304},
    { 712, -488, -168},
    { 504, -352, -160},
    { 568, -200, -216},
    { 488, -104, -176},
    { 416, -8, -184},
    { 560, 8, -152},
    { 1272, 120, -152},
    { 1752, 192, -408},
    { 2528, 184, -720},
    { 2344, 208, -720},
    { 1544, 272, -560},
    { 1240, 136, -376},
    { 1040, 344, -336},
    { 784, 568, -488},
    { 536, 584, -384},
    { 544, 656, -240},
    { 672, 736, -160},
    { 776, 608, -160},
    { 728, 424, -168},
    // 9 seconds
    { 1304, 584, -144},
    { 2136, 528, -392},
    { 2184, 232, -128},
    { 2232, 304, -136},
    { 2008, 160, -232},
    { 1424, -24, -280},
    { 1192, -144, -256},
    { 824, -200, -232},
    { 624, -224, -200},
    { 592, -224, -192},
    { 696, -192, -208},
    { 608, -128, -208},
    { 440, -136, -224},
    { 840, -8, -64},
    { 944, 104, -368},
    { 1416, 136, -768},
    { 2320, -88, -800},
    { 2440, 88, -520},
    { 1920, 160, -536},
    { 1376, 368, -584},
    { 1096, 504, -448},
    { 800, 544, -472},
    { 584, 600, -264},
    { 640, 760, -176},
    { 720, 776, -80},
    // 10 seconds
    { 776, 632, -88},
    { 688, 504, -144},
    { 1136, 600, -40},
    { 1992, 616, -376},
    { 2264, 304, -40},
    { 2432, 256, -16},
    { 2144, 216, -184},
    { 1576, 64, -264},
    { 1368, 16, -272},
    { 960, -64, -288},
    { 664, -136, -264},
    { 592, -184, -256},
    { 576, -224, -312},
    { 552, -248, -320},
    { 456, -216, -280},
    { 384, -144, -200},
    { 888, 32, -120},
    { 1536, 152, -480},
    { 2112, 112, -576},
    { 2784, 40, -624},
    { 2224, 240, -696},
    { 1536, 520, -368},
    { 1272, 328, -392},
    { 1184, 368, -216},
    { 800, 608, -136},
    // 11 seconds
    { 536, 760, -56},
    { 520, 1008, -16},
    { 592, 728, 32},
    { 1000, 808, 152},
    { 1336, 672, -120},
    { 1800, 472, -104},
    { 2368, 392, -32},
    { 2584, 240, -176},
    { 2168, 56, -232},
    { 1768, -224, -336},
    { 1384, -296, -336},
    { 912, -400, -248},
    { 680, -336, -280},
    { 544, -280, -288},
    { 520, -216, -240},
    { 456, -128, -184},
    { 376, -56, -176},
    { 584, 40, -80},
    { 1376, 152, -120},
    { 1624, 272, -504},
    { 2352, 288, -640},
    { 2576, 232, -888},
    { 1808, 144, -664},
    { 1112, 224, -552},
    { 888, 416, -576},
    // 12 seconds
    { 680, 688, -672},
    { 624, 712, -464},
    { 736, 808, -360},
    { 784, 776, -248},
    { 776, 544, -152},
    { 1280, 656, -80},
    { 1984, 664, -472},
    { 2144, 344, -232},
    { 2608, 336, -48},
    { 2312, 208, -184},
    { 1784, -40, -224},
    { 1312, -56, -288},
    { 920, -280, -144},
    { 576, -344, -160},
    { 440, -280, -216},
    { 424, -240, -200},
    { 488, -192, -184},
    { 464, -144, -216},
    { 448, -88, -248},
    { 976, 0, -192},
    { 1576, 88, -448},
    { 2184, 64, -608},
    { 2704, 8, -816},
    { 2192, 32, -520},
    { 1576, 224, -424},
    // 13 seconds
    { 1304, 504, -208},
    { 1048, 416, -344},
    { 768, 584, -184},
    { 648, 880, -56},
    { 600, 1000, 56},
    { 560, 760, 56},
    { 960, 824, 192},
    { 1464, 760, -152},
    { 1856, 560, -152},
    { 2648, 472, -32},
    { 2616, 360, -104},
    { 2296, 48, -120},
    { 1696, -64, -208},
    { 1304, -152, -256},
    { 1056, -264, -216},
    { 656, -248, -176},
    { 560, -256, -200},
    { 544, -208, -184},
    { 488, -128, -152},
    { 304, -80, -120},
    { 776, 112, -112},
    { 1032, 352, -592},
    { 1592, 264, -544},
    { 2320, 64, -376},
    { 2488, 256, -800},
    // 14 seconds
    { 1992, 288, -856},
    { 1384, 432, -568},
    { 1064, 440, -272},
    { 920, 384, -384},
    { 808, 608, -120},
    { 624, 1016, 40},
    { 464, 984, -40},
    { 1072, 1080, -128},
    { 1512, 736, -256},
    { 2048, 640, -32},
    { 2736, 368, -80},
    { 2384, 192, -104},
    { 1968, 104, -96},
    { 1552, 40, -152},
    { 1208, 0, -168},
    { 1056, -8, -144},
    { 920, 32, -232},
    { 856, 56, -240},
    { 672, 96, -216},
    { 416, 72, -328},
    { 200, 240, -560},
    { 184, 896, -1080},
    { 88, 880, -1440},
    { 152, 496, -1584},
    { -56, 184, -1264},
    // 15 seconds
    { -248, 280, -1136},
    { -336, 232, -976},
    { -496, 152, -768},
    { -472, 104, -552},
    { -536, 168, -472},
    { -608, 296, -600},
    { -520, 384, -760},
    { -728, 464, -1304},
    { -208, 840, -1992},
    { 152, 568, -1688},
    { -128, 584, -1424},
    { -120, 472, -1000},
    { -160, 224, -672},
    { -176, 128, -480},
    { -176, 56, -384},
    { -88, 224, -520},
    { 32, 248, -592},
    { 112, 104, -616},
    { 216, -144, -624},
    { 160, -88, -600},
    { 16, 168, -864},
    { 176, 888, -1816},
    { 488, 0, -1984},
    { 488, 408, -1984},
    { -8, 384, -1624},
    // 16 seconds
    { -248, 168, -1160},
    { -336, 232, -1000},
    { -376, 184, -784},
    { -376, 112, -576},
    { -432, 120, -440},
    { -504, 176, -440},
    { -480, 272, -552},
    { -856, 576, -1552},
    { 368, 760, -2328},
    { 696, 632, -2192},
    { 120, 680, -1384},
    { 136, 272, -1136},
    { 32, -8, -648},
    { 32, -8, -504},
    { 0, -88, -488},
    { 144, 32, -552},
    { 152, -96, -440},
    { 240, -288, -184},
    { 512, -16, -456},
    { 736, -32, -544},
    { 1272, 304, -696},
    { 1720, 448, -720},
    { 2208, 560, -832},
    { 2272, 600, -760},
    { 2136, 616, -320},
    // 17 seconds
    { 1640, 528, -80},
    { 1056, 616, -8},
    { 856, 480, -112},
    { 712, 408, -16},
    { 616, 520, 200},
    { 632, 688, 208},
    { 448, 736, 320},
    { 784, 728, 296},
    { 1576, 888, 64},
    { 1856, 656, 24},
    { 2472, 776, 56},
    { 2512, 536, 56},
    { 2360, 280, -8},
    { 2032, 56, -80},
    { 1568, -296, 32},
    { 992, -600, -120},
    { 832, -528, 48},
    { 936, -312, 40},
    { 752, -320, -8},
    { 640, -224, 0},
    { 1000, 88, -128},
    { 1144, 368, -824},
    { 1440, 136, -384},
    { 2288, 56, -464},
    { 2520, 232, -544},
    // 18 seconds
    { 2176, 360, -448},
    { 1560, 688, -264},
    { 936, 728, -192},
    { 752, 992, -16},
    { 424, 1528, 272},
    { 312, 1176, 288},
    { 640, 1248, 352},
    { 2008, 1144, -48},
    { 2408, 776, 32},
    { 3128, 424, 48},
    { 2792, 280, -72},
    { 2240, 168, -128},
    { 1928, 120, -216},
    { 1416, -128, -120},
    { 984, -312, -96},
    { 704, -312, -152},
    { 744, -408, -80},
    { 792, -360, -32},
    { 600, -328, -24},
    { 416, -240, -80},
    { 936, 16, -192},
    { 1168, 368, -896},
    { 1752, 400, -680},
    { 2512, 488, -1008},
    { 2688, 512, -792},
    // 19 seconds
    { 2232, 696, -640},
    { 1448, 728, -248},
    { 968, 816, 0},
    { 616, 1096, 56},
    { 488, 1208, 160},
    { 392, 1064, 128},
    { 688, 984, 184},
    { 1696, 968, -264},
    { 2608, 512, -72},
    { 3144, 304, -80},
    { 2752, 224, -384},
    { 2168, -88, -248},
    { 1840, -112, -328},
    { 1440, -640, -240},
    { 952, -632, -144},
    { 664, -432, -112},
    { 640, -328, -96},
    { 496, -232, -16},
    { 344, -112, -64},
    { 424, 8, -248},
    { 968, 232, -104},
    { 1216, 168, -304},
    { 2176, 0, -376},
    { 3080, -112, -712},
    { 2760, 248, -664},
    // 20 seconds
    { 1784, 488, -576},
    { 1008, 472, -1064},
    { 736, 480, -496},
    { 424, 1152, -488},
    { 280, 1272, -352},
    { 448, 792, -256},
    { 1400, 1320, -416},
    { 2832, 344, -336},
    { 3120, 104, 24},
    { 3072, 24, -176},
    { 2432, -48, -424},
    { 1880, -112, -272},
    { 1424, -296, -224},
    { 960, -448, -200},
    { 768, -416, -208},
    { 704, -320, -152},
    { 616, -296, -96},
    { 480, -232, -64},
    { 272, -112, -112},
    { 520, 0, -176},
    { 856, 472, -560},
    { 1280, 240, -344},
    { 2128, 296, -960},
    { 2592, 168, -936},
    { 2568, 240, -896},
    // 21 seconds
    { 1728, 576, -752},
    { 1000, 752, -504},
    { 712, 760, -384},
    { 504, 1184, -152},
    { 272, 1176, -112},
    { 552, 976, 48},
    { 1720, 1008, -384},
    { 2168, 648, -184},
    { 3080, 360, -24},
    { 2800, 192, -232},
    { 2128, -72, -296},
    { 1616, -128, -320},
    { 1240, -328, -224},
    { 872, -384, -136},
    { 632, -280, -232},
    { 560, -280, -184},
    { 520, -224, -136},
    { 432, -144, -104},
    { 328, -72, -96},
    { 464, 80, -200},
    { 1008, 440, -488},
    { 1280, 384, -1016},
    { 1824, 312, -992},
    { 2192, 424, -760},
    { 1920, 624, -616},
    // 22 seconds
    { 1392, 600, -728},
    { 1128, 656, -680},
    { 776, 704, -512},
    { 448, 696, -272},
    { 376, 880, -136},
    { 248, 896, -24},
    { 600, 784, 104},
    { 1832, 976, -168},
    { 2808, 432, -336},
    { 2304, 272, -8},
    { 2416, 272, -272},
    { 1888, -40, -216},
    { 1472, -56, -208},
    { 984, -216, -240},
    { 736, -216, -200},
    { 584, -176, -256},
    { 560, -160, -200},
    { 632, -104, -152},
    { 528, -88, -184},
    { 376, -80, -144},
    { 864, 144, -208},
    { 840, 328, -592},
    { 1232, 296, -712},
    { 1856, 16, -744},
    { 2184, -16, -648},
    // 23 seconds
    { 2120, 88, -656},
    { 1704, 304, -600},
    { 1176, 512, -504},
    { 816, 688, -448},
    { 632, 896, -360},
    { 480, 1208, -232},
    { 536, 912, -192},
    { 616, 680, -120},
    { 1544, 840, -424},
    { 2936, 416, -240},
    { 2960, 80, -56},
    { 2408, 120, -208},
    { 1792, 56, -272},
    { 1304, -24, -224},
    { 1064, -96, -248},
    { 720, -128, -152},
    { 592, -192, -224},
    { 656, -184, -304},
    { 680, -248, -192},
    { 624, -216, -160},
    { 392, -120, -184},
    { 328, 0, -216},
    { 976, 304, -272},
    { 1176, 408, -800},
    { 2384, 40, -664},
    // 24 seconds
    { 2856, 256, -864},
    { 2064, 456, -608},
    { 1352, 384, -560},
    { 1024, 448, -296},
    { 776, 584, -216},
    { 536, 912, 48},
    { 424, 1120, 176},
    { 304, 1000, -152},
    { 456, 840, 136},
    { 1536, 1088, -264},
    { 2832, 568, -32},
    { 3072, 288, -24},
    { 2848, 232, -272},
    { 2224, 72, -296},
    { 1744, -152, -152},
    { 1120, -256, -184},
    { 928, -200, -288},
    { 776, -232, -192},
    { 840, -216, -168},
    { 816, -224, -64},
    { 544, -232, -8},
    { 624, -120, -64},
    { 776, 8, -216},
    { 1104, 384, -728},
    { 1760, 312, -656},
    // 25 seconds
    { 2336, 192, -648},
    { 2440, 272, -768},
    { 2104, 296, -712},
    { 1520, 496, -440},
    { 1016, 648, -240},
    { 816, 792, -232},
    { 600, 1088, -40},
    { 480, 1128, 80},
    { 384, 896, -16},
    { 888, 1120, -72},
    { 2288, 840, -248},
    { 3312, 496, -112},
    { 3480, 280, -136},
    { 3000, 160, -304},
    { 2216, -120, -168},
    { 1624, -424, -48},
    { 936, -344, -176},
    { 744, -152, -256},
    { 696, -184, -72},
    { 728, -240, -40},
    { 656, -280, -8},
    { 480, -216, 0},
    { 384, -168, -88},
    { 976, 8, -184},
    { 1232, 344, -840},
    // 26 seconds
    { 1992, 184, -768},
    { 2720, 160, -1064},
    { 2784, 240, -792},
    { 2344, 408, -672},
    { 1616, 544, -376},
    { 1248, 704, -80},
    { 840, 896, 56},
    { 512, 1024, 120},
    { 384, 1168, 320},
    { 88, 1200, 232},
    { 392, 976, 344},
    { 1440, 1120, 216},
    { 2960, 784, -88},
    { 3608, 352, 96},
    { 3944, 400, -88},
    { 3352, 56, -224},
    { 2456, -168, -200},
    { 1800, -320, -136},
    { 1280, -352, -216},
    { 1120, -360, -168},
    { 784, -400, -32},
    { 664, -352, -32},
    { 392, -304, 32},
    { 232, -208, -32},
    { 544, -88, -56},
    // 27 seconds
    { 640, 304, -512},
    { 1344, 368, -816},
    { 2048, 392, -824},
    { 2504, 296, -904},
    { 2456, 296, -864},
    { 1976, 568, -856},
    { 1376, 528, -400},
    { 1064, 640, -184},
    { 720, 1072, -8},
    { 256, 1368, -136},
    { 360, 904, 104},
    { 1040, 1152, 280},
    { 1912, 944, -184},
    { 2536, 608, -192},
    { 2896, 432, -56},
    { 2688, 360, -96},
    { 2280, 48, -184},
    { 1688, -192, -144},
    { 1176, -464, -112},
    { 808, -328, -208},
    { 752, -208, -240},
    { 656, -192, -192},
    { 744, -192, -152},
    { 528, -160, -144},
    { 360, -96, -80},
    // 28 seconds
    { 800, 128, -192},
    { 944, 384, -784},
    { 1472, 304, -552},
    { 2480, 184, -792},
    { 2768, 408, -760},
    { 2096, 480, -912},
    { 1216, 472, -552},
    { 928, 440, -400},
    { 600, 584, -312},
    { 440, 872, -240},
    { 480, 976, -40},
    { 608, 672, -88},
    { 720, 696, 32},
    { 1792, 960, -248},
    { 2336, 440, -440},
    { 2720, 544, -48},
    { 2768, 392, -80},
    { 2256, 0, -56},
    { 1688, -192, -192},
    { 1224, -352, -112},
    { 808, -280, -176},
    { 576, -248, -144},
    { 688, -248, -112},
    { 736, -304, -40},
    { 576, -296, 8},
    // 29 seconds
    { 568, -224, -8},
    { 1152, -8, -192},
    { 1408, 184, -720},
    { 2360, 432, -824},
    { 2656, 304, -1080},
    { 2352, 368, -664},
    { 1936, 384, -584},
    { 1312, 696, -448},
    { 856, 712, -248},
    { 520, 768, -80},
    { 392, 888, 56},
    { 296, 968, 224},
    { 328, 784, 248},
    { 1032, 864, 176},
    { 2400, 840, -56},
    { 2672, 616, 48},
    { 3096, 440, 32},
    { 2728, 192, -120},
    { 2136, -72, -192},
    { 1576, -328, -96},
    { 1104, -304, -200},
    { 768, -256, -200},
    { 568, -200, -200},
    { 584, -224, -216},
    { 616, -264, -168},
    // 30 seconds
    { 464, -184, -120},
    { 368, -64, -144},
    { 688, 80, -96},
    { 1304, 384, -504},
    { 1768, 464, -776},
    { 2496, 272, -648},
    { 2632, 344, -936},
    { 1952, 240, -736},
    { 1280, 392, -640},
    { 928, 448, -440},
    { 608, 584, -280},
    { 416, 888, -136},
    { 392, 1112, -120},
    { 384, 832, -48},
    { 736, 792, 24},
    { 1912, 960, -376},
    { 2512, 480, -48},
    { 2728, 344, 88},
    { 2480, 344, -152},
    { 2112, 80, -160},
    { 1744, 88, -216},
    { 1320, -240, -184},
    { 888, -352, -176},
    { 744, -264, -160},
    { 624, -264, -152},
    // 31 seconds
    { 648, -160, -200},
    { 472, -152, -120},
    { 328, -96, -120},
    { 792, 72, -80},
    { 1032, 408, -496},
    { 1600, 256, -584},
    { 2464, -16, -600},
    { 2760, 184, -824},
    { 2232, 336, -728},
    { 1464, 408, -632},
    { 1056, 496, -416},
    { 784, 536, -344},
    { 680, 696, -208},
    { 616, 856, -32},
    { 600, 712, 56},
    { 632, 800, 184},
    { 1288, 968, 0},
    { 2184, 616, -184},
    { 2568, 472, 24},
    { 2584, 352, -56},
    { 2536, 168, -120},
    { 2008, 144, -240},
    { 1600, -240, -136},
    { 1160, -200, -184},
    { 840, -288, -208},
    // 32 seconds
    { 544, -344, -112},
    { 504, -344, -128},
    { 488, -304, -72},
    { 392, -192, -104},
    { 920, -56, -40},
    { 1344, 320, -352},
    { 2184, 256, -608},
    { 3016, 136, -608},
    { 2552, 232, -672},
    { 1792, -104, -528},
    { 1448, 296, -224},
    { 1248, 488, -256},
    { 856, 640, -104},
    { 656, 792, 104},
    { 528, 992, 504},
    { 456, 800, 184},
    { 976, 856, 344},
    { 1728, 720, -24},
    { 1904, 784, -8},
    { 2808, 744, 0},
    { 2976, 416, 128},
    { 2592, 16, 160},
    { 1976, -184, -40},
    { 1384, -344, -144},
    { 1008, -272, -208},
    // 33 seconds
    { 808, -264, -80},
    { 656, -280, -56},
    { 696, -256, -184},
    { 552, -224, -136},
    { 608, -128, -136},
    { 960, -104, -48},
    { 1304, 200, -416},
    { 2144, 192, -424},
    { 2912, 304, -416},
    { 2416, 424, -528},
    { 1744, 368, -440},
    { 1352, 224, -424},
    { 1080, 248, -424},
    { 768, 376, -264},
    { 584, 616, -136},
    { 680, 832, -120},
    { 656, 872, 48},
    { 656, 672, -104},
    { 1168, 848, 8},
    { 1656, 688, -200},
    { 1968, 608, -184},
    { 2576, 448, -24},
    { 2496, 264, -112},
    { 2064, 72, 16},
    { 1744, -24, -72},
    // 34 seconds
    { 1304, -176, -88},
    { 904, -144, -176},
    { 648, -240, -144},
    { 648, -232, -184},
    { 560, -320, -112},
    { 440, -264, -160},
    { 432, -168, -208},
    { 1080, -48, -112},
    { 1472, 120, -408},
    { 2320, 88, -512},
    { 2848, 176, -352},
    { 2192, 296, -408},
    { 1864, 280, -320},
    { 1448, 320, -264},
    { 1248, 424, -224},
    { 936, 576, 0},
    { 752, 736, 144},
    { 664, 896, 296},
    { 656, 840, 224},
    { 968, 864, 320},
    { 1488, 760, 48},
    { 1624, 712, -64},
    { 2304, 800, -32},
    { 2696, 528, 96},
    { 2720, 248, 264},
    // 35 seconds
    { 2080, -144, 224},
    { 1464, -320, -8},
    { 992, -128, -120},
    { 816, -48, -136},
    { 736, -32, -112},
    { 760, -96, -136},
    { 616, -144, -144},
    { 392, -136, -168},
    { 760, -48, -80},
    { 888, 40, -200},
    { 1576, 88, -424},
    { 2560, 8, -488},
    { 2880, 96, -536},
    { 2000, 312, -624},
    { 1400, 312, -392},
    { 1272, 208, -448},
    { 1104, 376, -296},
    { 792, 696, -184},
    { 632, 1104, -96},
    { 576, 1024, 8},
    { 536, 720, 16},
    { 1472, 1024, 104},
    { 2080, 752, -200},
    { 2528, 656, -8},
    { 2784, 528, 96},
    // 36 seconds
    { 2568, 272, 32},
    { 2008, 104, 56},
    { 1776, -72, 16},
    { 1104, -144, -64},
    { 880, -56, -144},
    { 592, -80, -96},
    { 728, -112, -128},
    { 552, -192, -40},
    { 424, -176, -136},
    { 728, -80, -48},
    { 808, 64, -488},
    { 1400, 120, -672},
    { 2344, -104, -384},
    { 2832, 48, -640},
    { 2608, 216, -624},
    { 2048, 384, -328},
    { 1528, 736, -296},
    { 1232, 616, -232},
    { 1032, 576, -56},
    { 936, 688, 176},
    { 720, 824, 536},
    { 472, 832, 136},
    { 528, 664, 208},
    { 1184, 752, 136},
    { 1664, 688, 40},
    // 37 seconds
    { 2144, 672, -112},
    { 2816, 624, 40},
    { 2720, 256, 128},
    { 2216, 40, 136},
    { 1624, -128, -64},
    { 1344, -80, -184},
    { 1072, -88, -216},
    { 920, -56, -240},
    { 824, -120, -200},
    { 896, -176, -264},
    { 536, -280, -120},
    { 264, -208, -104},
    { 832, -24, -40},
    { 760, 184, -488},
    { 1216, 344, -680},
    { 2104, 120, -480},
    { 2848, 304, -536},
    { 2384, 416, -752},
    { 1656, 704, -528},
    { 1144, 496, -408},
    { 864, 680, -392},
    { 664, 1008, -240},
    { 552, 1072, -64},
    { 608, 776, -88},
    { 712, 776, 16},
    // 38 seconds
    { 1552, 888, -72},
    { 1864, 616, -168},
    { 2352, 544, -104},
    { 2584, 456, 40},
    { 2448, 312, 72},
    { 1776, 200, -16},
    { 1680, 104, -120},
    { 1216, 48, -80},
    { 960, 32, -152},
    { 856, -24, -184},
    { 744, -152, -168},
    { 592, -224, -160},
    { 488, -216, -176},
    { 680, -88, -120},
    { 656, -8, -440},
    { 1080, 56, -472},
    { 1960, -72, -432},
    { 2608, 64, -544},
    { 2240, 280, -584},
    { 1640, 320, -552},
    { 1368, 352, -344},
    { 1296, 368, -152},
    { 1056, 512, -80},
    { 960, 880, 24},
    { 616, 1232, 104},
    // 39 seconds
    { 720, 1024, -120},
    { 720, 896, -24},
    { 1608, 832, -184},
    { 2016, 616, -160},
    { 2368, 528, -96},
    { 2536, 360, -152},
    { 2208, 64, 200},
    { 1592, -136, 120},
    { 1672, -32, -264},
    { 1368, 48, -224},
    { 1064, -48, -80},
    { 808, -64, 16},
    { 624, -144, -32},
    { 488, -216, -64},
    { 368, -184, -208},
    { 688, -56, -136},
    { 720, -64, -288},
    { 1040, -48, -440},
    { 1992, -152, -440},
    { 2688, -32, -688},
    { 2576, 224, -584},
    { 1912, 360, -456},
    { 1440, 600, -520},
    { 1264, 560, -352},
    { 752, 760, -232},
    // 40 seconds
    { 696, 888, -24},
    { 696, 880, 16},
    { 784, 776, 72},
    { 712, 776, 56},
    { 1392, 856, 168},
    { 1736, 696, -216},
    { 2072, 656, -48},
    { 2832, 568, 8},
    { 2760, 264, 72},
    { 2048, 16, 104},
    { 1792, 64, -120},
    { 1376, 48, -168},
    { 1168, 40, -152},
    { 952, -80, -96},
    { 800, -152, -104},
    { 592, -240, -120},
    { 352, -184, -216},
    { 584, -112, -88},
    { 616, -72, -240},
    { 944, 24, -488},
    { 1528, -56, -552},
    { 2176, -16, -520},
    { 2536, 40, -712},
    { 2224, 288, -720},
    { 1648, 344, -592},
    // 41 seconds
    { 1296, 520, -600},
    { 1096, 592, -352},
    { 952, 904, -112},
    { 800, 1000, 0},
    { 632, 824, 32},
    { 736, 800, 192},
    { 1128, 808, 192},
    { 1792, 760, -24},
    { 2016, 720, 8},
    { 2688, 688, 72},
    { 2760, 336, 88},
    { 2408, 112, 40},
    { 1976, 0, -112},
    { 1488, -72, -248},
    { 1232, -112, -304},
    { 944, -376, -144},
    { 728, -456, -168},
    { 504, -464, -224},
    { 344, -384, -288},
    { 704, -232, -208},
    { 728, -56, -208},
    { 1192, 16, -360},
    { 1832, 0, -344},
    { 2736, 48, -344},
    { 2912, 320, -624},
    // 42 seconds
    { 2088, 384, -248},
    { 1656, 392, -552},
    { 1560, 368, -312},
    { 1120, 704, -240},
    { 728, 976, -152},
    { 696, 1040, -64},
    { 816, 824, 104},
    { 728, 792, 88},
    { 1288, 872, 168},
    { 1392, 624, -40},
    { 1968, 720, -88},
    { 2704, 632, 0},
    { 2816, 360, 184},
    { 2472, 48, 240},
    { 1864, -88, -16},
    { 1592, -24, -192},
    { 1224, -40, -112},
    { 920, -64, -136},
    { 640, -128, -128},
    { 600, -160, -168},
    { 528, -176, -240},
    { 616, -120, -120},
    { 720, -80, -216},
    { 944, -16, -352},
    { 1440, -72, -360},
    // 43 seconds
    { 2072, -40, -504},
    { 2368, 72, -496},
    { 2208, 296, -416},
    { 1784, 520, -264},
    { 1432, 504, -512},
    { 1416, 488, -16},
    { 1064, 840, 232},
    { 920, 1144, 400},
    { 720, 968, 384},
    { 1216, 976, 664},
    { 1288, 640, 64},
    { 1368, 640, 56},
    { 1944, 952, 192},
    { 2512, 624, 104},
    { 2352, 312, 256},
    { 2232, -64, 216},
    { 1776, -184, -8},
    { 1304, -152, -128},
    { 1056, -88, -144},
    { 848, -120, -136},
    { 688, -176, -120},
    { 480, -232, -152},
    { 520, -152, -88},
    { 656, -40, -120},
    { 904, 48, -328},
    // 44 seconds
    { 1392, 40, -384},
    { 2104, -48, -416},
    { 2376, 88, -504},
    { 2144, 416, -576},
    { 1744, 432, -472},
    { 1344, 664, -504},
    { 1088, 712, -432},
    { 880, 1008, -320},
    { 656, 1296, -336},
    { 648, 936, -240},
    { 1464, 1064, -152},
    { 1400, 584, -200},
    { 2040, 624, -112},
    { 2752, 304, -32},
    { 2304, 216, -8},
    { 1952, 112, -96},
    { 1640, 96, -168},
    { 1376, 40, -200},
    { 1128, -88, -200},
    { 848, -280, -192},
    { 712, -432, -224},
    { 528, -440, -224},
    { 560, -280, -144},
    { 736, -96, -208},
    { 864, -16, -448},
    // 45 seconds
    { 1296, -40, -400},
    { 1944, -32, -360},
    { 2416, 64, -536},
    { 2192, 256, -616},
    { 1800, 328, -416},
    { 1408, 488, -344},
    { 1272, 416, -312},
    { 1064, 552, -48},
    { 896, 800, 96},
    { 808, 904, 176},
    { 648, 792, 128},
    { 1008, 824, 288},
    { 1104, 640, 64},
    { 1472, 672, -32},
    { 1920, 664, 16},
    { 2328, 456, 24},
    { 2296, 272, 72},
    { 2120, 8, 64},
    { 1592, -152, -16},
    { 1264, -64, -184},
    { 976, -72, -208},
    { 696, -144, -144},
    { 648, -152, -192},
    { 520, -216, -240},
    { 416, -216, -176},
    // 46 seconds
    { 776, -80, -152},
    { 896, 16, -240},
    { 1224, 8, -376},
    { 1936, -104, -296},
    { 2560, 64, -416},
    { 2320, 272, -320},
    { 1656, 600, -112},
    { 1336, 504, -336},
    { 1160, 664, -192},
    { 904, 512, 64},
    { 864, 672, 248},
    { 688, 856, 240},
    { 648, 560, 264},
    { 1200, 936, 392},
    { 1256, 528, -16},
    { 1400, 656, 32},
    { 1936, 584, -16},
    { 2248, 408, -120},
    { 2024, 152, 8},
    { 1776, 72, -64},
    { 1560, -80, -208},
    { 1312, -184, -272},
    { 928, -384, -104},
    { 720, -392, -152},
    { 664, -472, -144},
    // 47 seconds
    { 512, -368, -80},
    { 1040, -104, -96},
    { 1120, 32, -216},
    { 1512, 104, -216},
    { 2176, 216, -440},
    { 2376, 280, -408},
    { 2088, 416, -496},
    { 1592, 448, -312},
    { 1312, 480, -448},
    { 880, 504, -184},
    { 680, 680, -48},
    { 584, 976, 144},
    { 504, 872, 168},
    { 1096, 1064, 344},
    { 1472, 840, 56},
    { 1872, 768, 88},
    { 2680, 728, 40},
    { 2648, 384, 24},
    { 2360, 192, 88},
    { 1936, 72, -88},
    { 1560, -136, -112},
    { 1144, -248, -104},
    { 864, -352, -88},
    { 824, -416, -64},
    { 592, -448, -40},
    // 48 seconds
    { 440, -328, -144},
    { 1064, -104, 8},
    { 1008, 56, -152},
    { 1648, 96, -224},
    { 2352, 112, -400},
    { 2648, 248, -400},
    { 2224, 408, -448},
    { 1696, 384, -328},
    { 1360, 392, -328},
    { 1144, 408, -200},
    { 992, 672, 80},
    { 744, 1184, 600},
    { 536, 1136, 72},
    { 648, 904, 488},
    { 1264, 984, 232},
    { 1904, 816, -88},
    { 2816, 912, 160},
    { 3232, 536, 152},
    { 3040, 208, 256},
    { 2336, -40, 272},
    { 1600, -416, 120},
    { 960, -224, -96},
    { 792, -64, -144},
    { 784, -48, -104},
    { 808, -216, -56},
    // 49 seconds
    { 576, -224, -8},
    { 464, -136, -24},
    { 664, 24, -64},
    { 856, 256, -368},
    { 1456, 176, -352},
    { 2344, 80, -520},
    { 2664, 40, -480},
    { 2456, 320, -512},
    { 1864, 344, -368},
    { 1480, 512, -360},
    { 1064, 528, -208},
    { 840, 528, -128},
    { 896, 704, 16},
    { 600, 880, 256},
    { 624, 736, 240},
    { 1136, 1128, 272},
    { 1552, 760, 16},
    { 1800, 704, 96},
    { 2544, 640, -32},
    { 2528, 384, -40},
    { 2184, 320, 24},
    { 1800, -128, 40},
    { 1592, -264, -32},
    { 1088, -272, -128},
    { 816, -144, -136},
    // 50 seconds
    { 752, -192, -152},
    { 544, -280, -64},
    { 408, -256, -40},
    { 968, -56, -104},
    { 1016, 72, -192},
    { 1712, 80, -192},
    { 2648, 48, -296},
    { 2536, 272, -360},
    { 1920, 480, -344},
    { 1480, 400, -232},
    { 1216, 352, -264},
    { 1032, 320, -176},
    { 960, 472, 32},
    { 944, 824, 368},
    { 408, 1016, 88},
    { 1040, 912, 440},
    { 1168, 936, 192},
    { 1712, 688, 32},
    { 2272, 856, 56},
    { 2864, 440, 64},
    { 2528, 176, 264},
    { 2320, -120, 112},
    { 1856, -296, 56},
    { 1224, -184, -144},
    { 960, -176, -144},
    // 51 seconds
    { 768, -160, -72},
    { 640, -288, -64},
    { 408, -280, -48},
    { 600, -160, -48},
    { 744, -32, -56},
    { 1136, 272, -392},
    { 1752, 184, -296},
    { 2360, 208, -600},
    { 2296, 216, -520},
    { 2128, 568, -624},
    { 1648, 592, -392},
    { 1288, 584, -144},
    { 1024, 568, -152},
    { 936, 632, -56},
    { 944, 704, 152},
    { 656, 768, 240},
    { 536, 656, 264},
    { 1320, 1104, 504},
    { 1792, 712, 64},
    { 1936, 776, 120},
    { 2648, 640, 64},
    { 2616, 304, -72},
    { 2336, 600, 56},
    { 2016, -320, 240},
    { 1384, -256, -88},
    // 52 seconds
    { 1008, -200, -176},
    { 744, -192, -128},
    { 720, -192, -96},
    { 728, -328, -40},
    { 392, -272, -80},
    { 544, -128, -64},
    { 912, -48, -136},
    { 1536, 80, -248},
    { 2808, 0, -288},
    { 3376, 176, -456},
    { 2256, 592, -384},
    { 1624, 488, -280},
    { 1568, 336, -224},
    { 1256, 296, -280},
    { 968, 416, 8},
    { 920, 712, 568},
    { 640, 1224, 128},
    { 528, 640, 424},
    { 1240, 1152, 552},
    { 1352, 584, -56},
    { 1816, 816, -8},
    { 2944, 632, 64},
    { 2904, 368, 160},
    { 2752, 48, 232},
    { 2144, -208, -24},
    // 53 seconds
    { 1600, -248, -56},
    { 1152, -152, -200},
    { 856, -240, -192},
    { 744, -376, -128},
    { 672, -464, -96},
    { 456, -352, -144},
    { 536, -232, -96},
    { 1032, -40, -96},
    { 1408, 224, -448},
    { 2216, 152, -256},
    { 2800, 208, -344},
    { 2560, 408, -520},
    { 1952, 376, -288},
    { 1648, 296, -368},
    { 1368, 384, -456},
    { 1048, 416, -288},
    { 896, 696, -160},
    { 688, 1184, -88},
    { 576, 792, -128},
    { 904, 1032, 72},
    { 1216, 744, -168},
    { 1640, 600, -200},
    { 2416, 632, -216},
    { 2528, 368, -576},
    { 2200, 288, -1056},
    // 54 seconds
    { 2152, 712, -976},
    { 2176, 1512, -744},
    { 2240, 1368, -488},
    { 2104, 1208, -288},
    { 1880, 816, -168},
    { 1112, 304, -296},
    { 952, 728, -424},
    { 144, -128, -48},
    { -512, -216, -96},
    { -528, 216, -72},
    { -584, -176, -384},
    { -704, -208, -232},
    { -840, -472, 152},
    { -504, -328, 352},
    { -536, -152, 408},
    { -456, 72, 384},
    { -136, 104, 416},
    { 96, 160, 288},
    { -144, -128, 632},
    { -40, -280, 432},
    { -440, -632, 264},
    { -224, -1320, -296},
    { -544, -1528, -544},
    { -608, -1392, -528},
    { -600, -1176, -768},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

