/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:06:02 local
AccelRawData *activity_sample_walk_100_pbl_25298_1(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25298_1
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -128, -104, -1008},
    { -128, -120, -1008},
    { -136, -120, -1008},
    { -136, -104, -1008},
    { -120, -112, -1008},
    { -120, -104, -1016},
    { -120, -104, -1008},
    { -120, -112, -1008},
    { -128, -104, -1016},
    { -128, -104, -1024},
    { -128, -104, -1016},
    { -128, -96, -1016},
    { -128, -104, -1008},
    { -136, -104, -1000},
    { -128, -96, -1008},
    { -128, -88, -1008},
    { -136, -112, -1008},
    { -136, -104, -1008},
    { -136, -104, -1016},
    { -128, -104, -1016},
    { -120, -112, -1008},
    { -112, -120, -1016},
    { -128, -104, -1008},
    { -120, -112, -1008},
    { -120, -120, -1008},
    // 1 seconds
    { -120, -104, -1008},
    { -128, -96, -1016},
    { -128, -96, -1016},
    { -128, -144, -1016},
    { -112, -112, -1008},
    { -152, -176, -976},
    { -144, -120, -1024},
    { -168, -72, -1032},
    { -192, -80, -1000},
    { -192, -104, -984},
    { -168, -112, -992},
    { -128, -120, -992},
    { -120, -104, -1016},
    { -128, -56, -1000},
    { -80, -128, -984},
    { -80, -128, -1008},
    { -120, -152, -1040},
    { 8, -64, -984},
    { 72, -88, -920},
    { 64, 40, -896},
    { 64, 136, -856},
    { 96, 128, -832},
    { 160, 304, -848},
    { 168, 424, -944},
    { 136, 552, -1024},
    // 2 seconds
    { 128, 688, -1040},
    { 72, 792, -1088},
    { 72, 728, -1120},
    { 16, 744, -1056},
    { -40, 664, -944},
    { -80, 664, -952},
    { -40, 624, -944},
    { -24, 488, -840},
    { -48, 400, -824},
    { -72, 440, -856},
    { -104, 448, -864},
    { -112, 432, -880},
    { -104, 376, -896},
    { -104, 456, -936},
    { -80, 488, -976},
    { -40, 512, -1032},
    { 0, 552, -1080},
    { 96, 640, -1152},
    { 104, 600, -1096},
    { 136, 664, -1048},
    { 136, 600, -896},
    { 152, 632, -816},
    { 72, 704, -784},
    { 72, 744, -792},
    { 88, 688, -712},
    // 3 seconds
    { -8, 576, -576},
    { -16, 632, -672},
    { -40, 752, -696},
    { -40, 592, -704},
    { -8, 520, -728},
    { 40, 568, -744},
    { 216, 528, -848},
    { 448, 432, -800},
    { 624, 216, -736},
    { 816, 176, -552},
    { 1104, 176, -456},
    { 1360, 360, -488},
    { 1400, 224, -344},
    { 1552, 280, -192},
    { 1392, 384, -208},
    { 1168, 344, -312},
    { 1064, 328, -336},
    { 1008, 272, -200},
    { 1040, 248, -208},
    { 1048, 272, -248},
    { 1016, 344, -288},
    { 1080, 336, -280},
    { 1280, 392, -312},
    { 1040, 440, -264},
    { 1144, 504, -256},
    // 4 seconds
    { 960, 648, -304},
    { 960, 648, -320},
    { 1144, 424, -176},
    { 1392, 272, -72},
    { 1440, 216, -72},
    { 1296, 256, -64},
    { 1352, 128, -192},
    { 1264, 184, -96},
    { 1200, 200, -152},
    { 1056, 112, -32},
    { 1160, 184, -176},
    { 1160, 32, -248},
    { 1048, 152, -352},
    { 1152, 40, -304},
    { 984, -40, -224},
    { 1032, 96, -248},
    { 1088, 112, -328},
    { 1232, 192, -320},
    { 1064, 192, -208},
    { 936, 176, -168},
    { 928, 248, -160},
    { 992, 296, -136},
    { 1088, 336, -96},
    { 1168, 360, -80},
    { 1408, 400, -136},
    // 5 seconds
    { 1800, 496, -112},
    { 1272, 688, -168},
    { 1352, 792, -352},
    { 808, 688, -384},
    { 768, 560, -376},
    { 912, 576, -328},
    { 1160, 504, -256},
    { 1416, 352, -160},
    { 1392, 248, -8},
    { 1384, 232, -88},
    { 1456, 224, -112},
    { 1408, 224, -104},
    { 1184, 184, -136},
    { 1056, 144, -168},
    { 1096, 112, -232},
    { 944, 80, -296},
    { 1184, 8, -264},
    { 984, -32, -184},
    { 1088, 40, -248},
    { 1192, 80, -264},
    { 1192, 160, -248},
    { 1032, 184, -248},
    { 936, 216, -256},
    { 968, 248, -168},
    { 1064, 272, -104},
    // 6 seconds
    { 1168, 328, -64},
    { 1184, 424, -80},
    { 1408, 480, -120},
    { 1648, 624, -40},
    { 1280, 600, -200},
    { 1376, 728, -136},
    { 936, 608, -248},
    { 824, 560, -264},
    { 872, 536, -240},
    { 1120, 504, -216},
    { 1320, 384, -136},
    { 1248, 264, -16},
    { 1264, 208, -88},
    { 1344, 232, -96},
    { 1320, 240, -56},
    { 1216, 200, -72},
    { 1168, 176, -88},
    { 1312, 176, -168},
    { 1088, 96, -240},
    { 1384, 56, -264},
    { 880, -80, -168},
    { 872, 0, -224},
    { 968, 48, -280},
    { 1160, 136, -296},
    { 1080, 184, -296},
    // 7 seconds
    { 976, 208, -264},
    { 944, 240, -200},
    { 976, 288, -176},
    { 1032, 328, -176},
    { 1088, 400, -136},
    { 1328, 448, -144},
    { 1688, 584, -96},
    { 1232, 672, -176},
    { 1480, 728, -152},
    { 976, 544, -200},
    { 888, 512, -248},
    { 912, 512, -224},
    { 1168, 496, -160},
    { 1264, 344, -64},
    { 1152, 224, -8},
    { 1192, 200, -72},
    { 1304, 240, -64},
    { 1320, 232, -64},
    { 1160, 184, -112},
    { 1120, 168, -128},
    { 1112, 152, -208},
    { 952, 120, -264},
    { 1208, 96, -280},
    { 960, 72, -240},
    { 920, 40, -224},
    // 8 seconds
    { 1072, 120, -280},
    { 1176, 208, -280},
    { 1096, 208, -240},
    { 960, 248, -272},
    { 880, 264, -176},
    { 952, 256, -176},
    { 1040, 288, -136},
    { 1120, 328, -96},
    { 1560, 408, -144},
    { 1688, 552, -144},
    { 1296, 696, -176},
    { 1312, 712, -312},
    { 864, 520, -344},
    { 752, 480, -336},
    { 848, 536, -248},
    { 1160, 416, -176},
    { 1312, 280, -32},
    { 1200, 240, 0},
    { 1312, 208, -88},
    { 1336, 256, -64},
    { 1288, 256, -80},
    { 1104, 152, -80},
    { 1128, 200, -152},
    { 1128, 112, -240},
    { 1152, 72, -232},
    // 9 seconds
    { 1144, 48, -224},
    { 968, 24, -232},
    { 864, 40, -256},
    { 1048, 96, -256},
    { 1128, 176, -264},
    { 1048, 216, -288},
    { 968, 264, -272},
    { 952, 248, -168},
    { 1024, 320, -128},
    { 1144, 352, -112},
    { 1128, 408, -120},
    { 1520, 472, -112},
    { 1496, 568, -16},
    { 1128, 592, -160},
    { 1128, 680, -160},
    { 920, 608, -208},
    { 936, 560, -224},
    { 1064, 560, -184},
    { 1200, 456, -160},
    { 1104, 312, -32},
    { 1112, 248, -40},
    { 1240, 248, -64},
    { 1336, 224, -24},
    { 1256, 184, -32},
    { 1208, 160, -80},
    // 10 seconds
    { 1312, 208, -168},
    { 1128, 136, -216},
    { 1304, 112, -192},
    { 928, 40, -176},
    { 864, 56, -248},
    { 920, 72, -312},
    { 1080, 88, -304},
    { 1024, 120, -304},
    { 880, 152, -336},
    { 872, 216, -296},
    { 952, 208, -232},
    { 1088, 232, -192},
    { 1176, 312, -152},
    { 1360, 408, -208},
    { 1616, 584, -104},
    { 1336, 600, -296},
    { 1512, 696, -208},
    { 968, 568, -248},
    { 800, 480, -304},
    { 840, 480, -232},
    { 1168, 416, -176},
    { 1224, 344, -112},
    { 1096, 240, -40},
    { 1112, 232, -104},
    { 1208, 240, -88},
    // 11 seconds
    { 1224, 248, -40},
    { 1208, 192, -56},
    { 1384, 200, -112},
    { 1272, 128, -152},
    { 1168, 40, -192},
    { 1192, -32, -120},
    { 960, -56, -144},
    { 896, 24, -264},
    { 1080, 72, -368},
    { 992, 96, -368},
    { 800, 152, -312},
    { 792, 168, -280},
    { 848, 192, -192},
    { 1032, 240, -144},
    { 1144, 328, -128},
    { 1400, 416, -184},
    { 1688, 560, -80},
    { 1272, 656, -232},
    { 1520, 760, -192},
    { 984, 664, -256},
    { 928, 528, -296},
    { 1024, 544, -224},
    { 1208, 472, -208},
    { 1176, 328, -104},
    { 1040, 208, -24},
    // 12 seconds
    { 1120, 216, -104},
    { 1288, 264, -64},
    { 1288, 240, -48},
    { 1208, 168, -88},
    { 1376, 160, -200},
    { 1144, 96, -216},
    { 1056, -48, -240},
    { 1176, -32, -152},
    { 832, -48, -152},
    { 920, 88, -264},
    { 1240, 184, -416},
    { 1112, 224, -320},
    { 888, 168, -248},
    { 816, 208, -160},
    { 928, 272, -136},
    { 1032, 320, -136},
    { 1088, 368, -120},
    { 1400, 448, -144},
    { 1640, 600, -96},
    { 1184, 696, -240},
    { 1424, 744, -176},
    { 920, 608, -248},
    { 1040, 552, -296},
    { 1144, 536, -232},
    { 1336, 504, -232},
    // 13 seconds
    { 1320, 320, -64},
    { 1264, 176, -56},
    { 1256, 200, -16},
    { 1352, 200, -56},
    { 1224, 168, -96},
    { 1048, 120, -120},
    { 1048, 176, -192},
    { 1008, 120, -280},
    { 840, 64, -272},
    { 1120, 104, -240},
    { 960, 40, -216},
    { 1016, 112, -296},
    { 1472, 176, -368},
    { 1312, 216, -160},
    { 1048, 216, -264},
    { 912, 256, -296},
    { 936, 368, -232},
    { 992, 328, -168},
    { 1024, 336, -120},
    { 1192, 376, -120},
    { 1536, 464, -48},
    { 1320, 672, -88},
    { 1000, 560, -304},
    { 1384, 736, -168},
    { 888, 608, -216},
    // 14 seconds
    { 936, 496, -264},
    { 1200, 520, -184},
    { 1384, 456, -184},
    { 1224, 232, -32},
    { 1280, 208, -48},
    { 1392, 256, -40},
    { 1296, 200, -40},
    { 1096, 160, -80},
    { 1008, 128, -112},
    { 1056, 160, -232},
    { 984, 40, -256},
    { 1056, -48, -256},
    { 1072, -48, -120},
    { 1112, 8, -248},
    { 1384, 112, -344},
    { 1400, 160, -296},
    { 1160, 272, -128},
    { 984, 400, -152},
    { 960, 376, -32},
    { 1088, 408, -56},
    { 1120, 416, -40},
    { 1144, 416, -16},
    { 1344, 512, 48},
    { 1224, 600, -24},
    { 1136, 616, -32},
    // 15 seconds
    { 1160, 704, 8},
    { 1072, 632, -96},
    { 1000, 560, -136},
    { 1080, 512, -88},
    { 1120, 432, -104},
    { 1056, 352, -72},
    { 1184, 264, -128},
    { 1320, 296, -80},
    { 1352, 272, -32},
    { 1200, 104, 0},
    { 1288, 32, -48},
    { 1224, 144, -200},
    { 1016, 72, -296},
    { 1248, 64, -272},
    { 896, 32, -232},
    { 928, 56, -288},
    { 1264, 120, -328},
    { 1192, 176, -208},
    { 968, 208, -200},
    { 824, 328, -208},
    { 864, 312, -168},
    { 1000, 352, -128},
    { 1040, 408, -128},
    { 1120, 424, -96},
    { 1456, 600, -16},
    // 16 seconds
    { 1264, 656, -104},
    { 1208, 616, -168},
    { 1104, 632, -120},
    { 1040, 568, -168},
    { 976, 496, -192},
    { 1112, 488, -128},
    { 1176, 416, -104},
    { 1064, 240, -56},
    { 1064, 256, -56},
    { 1192, 288, -80},
    { 1184, 256, -40},
    { 1112, 168, -72},
    { 1176, 176, -120},
    { 1224, 184, -200},
    { 1136, 144, -272},
    { 1304, 120, -232},
    { 920, 64, -120},
    { 816, 96, -160},
    { 1040, 144, -328},
    { 1216, 232, -376},
    { 1056, 192, -264},
    { 920, 192, -240},
    { 888, 264, -240},
    { 944, 320, -240},
    { 1000, 368, -240},
    // 17 seconds
    { 1032, 416, -264},
    { 1376, 472, -248},
    { 1400, 536, -200},
    { 1264, 536, -224},
    { 1240, 600, -296},
    { 1080, 512, -272},
    { 968, 408, -264},
    { 1112, 384, -144},
    { 1200, 288, -72},
    { 1104, 232, -32},
    { 1096, 248, -64},
    { 1160, 240, -72},
    { 1200, 240, -56},
    { 1104, 200, -56},
    { 1104, 200, -104},
    { 1208, 216, -184},
    { 1008, 152, -192},
    { 1168, 80, -216},
    { 936, 96, -192},
    { 920, 104, -216},
    { 1128, 152, -352},
    { 1336, 224, -408},
    { 1128, 208, -200},
    { 912, 184, -216},
    { 848, 264, -224},
    // 18 seconds
    { 904, 296, -216},
    { 1008, 296, -160},
    { 1048, 328, -136},
    { 1344, 400, -200},
    { 1624, 528, -160},
    { 1120, 536, -144},
    { 1432, 600, -256},
    { 904, 480, -280},
    { 856, 504, -272},
    { 1024, 528, -208},
    { 1216, 440, -184},
    { 1184, 320, -64},
    { 1112, 256, -24},
    { 1216, 240, -72},
    { 1240, 264, -32},
    { 1136, 232, -64},
    { 1072, 192, -80},
    { 1304, 192, -152},
    { 1144, 152, -216},
    { 1216, 112, -200},
    { 1048, 72, -232},
    { 896, 96, -280},
    { 944, 104, -360},
    { 1200, 136, -328},
    { 1080, 128, -264},
    // 19 seconds
    { 832, 168, -264},
    { 776, 200, -208},
    { 872, 232, -152},
    { 1016, 272, -120},
    { 1040, 320, -144},
    { 1264, 392, -216},
    { 1752, 448, -168},
    { 1360, 576, -32},
    { 1552, 712, -192},
    { 952, 584, -256},
    { 800, 552, -312},
    { 832, 576, -232},
    { 1048, 536, -160},
    { 1184, 440, -112},
    { 1144, 296, 8},
    { 1208, 256, -40},
    { 1328, 240, -80},
    { 1264, 296, -40},
    { 1088, 176, -80},
    { 1104, 176, -120},
    { 1152, 160, -168},
    { 1096, 128, -232},
    { 1408, 88, -160},
    { 1064, 24, -80},
    { 944, 96, -200},
    // 20 seconds
    { 1096, 160, -296},
    { 1168, 160, -280},
    { 1000, 184, -320},
    { 848, 184, -312},
    { 880, 200, -216},
    { 976, 208, -136},
    { 1056, 296, -104},
    { 1112, 360, -160},
    { 1472, 448, -168},
    { 1496, 600, -40},
    { 1096, 528, -216},
    { 1384, 568, -192},
    { 1064, 640, -232},
    { 896, 512, -208},
    { 1008, 512, -184},
    { 1112, 480, -200},
    { 1128, 408, -168},
    { 1096, 264, -48},
    { 1232, 240, -48},
    { 1360, 272, -32},
    { 1240, 240, -40},
    { 1168, 184, -80},
    { 1232, 184, -128},
    { 1120, 96, -160},
    { 1112, -32, -208},
    // 21 seconds
    { 1216, -64, -88},
    { 1168, -104, -104},
    { 1192, -48, -256},
    { 1152, 64, -288},
    { 984, 128, -304},
    { 872, 192, -208},
    { 952, 408, -272},
    { 1040, 264, 24},
    { 1296, 464, -16},
    { 1256, 560, 48},
    { 1288, 584, -64},
    { 1456, 576, 0},
    { 1152, 648, 24},
    { 1280, 672, 104},
    { 1000, 712, -64},
    { 1048, 672, -168},
    { 1064, 624, -160},
    { 1200, 520, -144},
    { 1200, 424, -104},
    { 1112, 328, -48},
    { 1168, 272, -72},
    { 1304, 312, -48},
    { 1352, 264, -40},
    { 1272, 168, -48},
    { 1312, 136, -120},
    // 22 seconds
    { 1128, 72, -152},
    { 1072, 32, -208},
    { 1080, -16, -136},
    { 952, 8, -200},
    { 976, 64, -232},
    { 1192, 120, -272},
    { 1128, 192, -240},
    { 1000, 224, -224},
    { 968, 272, -216},
    { 1000, 288, -144},
    { 1104, 312, -104},
    { 1152, 392, -144},
    { 1304, 472, -176},
    { 1568, 560, -48},
    { 1296, 608, -200},
    { 1416, 760, -200},
    { 976, 576, -264},
    { 944, 544, -344},
    { 1064, 520, -296},
    { 1304, 472, -312},
    { 1304, 336, -96},
    { 1184, 184, -24},
    { 1128, 232, 0},
    { 1224, 256, -48},
    { 1160, 232, -48},
    // 23 seconds
    { 1104, 152, -16},
    { 1256, 216, -80},
    { 1152, 168, -176},
    { 1096, 136, -232},
    { 1280, 96, -184},
    { 920, 64, -152},
    { 832, 80, -232},
    { 1032, 128, -368},
    { 1128, 176, -360},
    { 968, 184, -288},
    { 864, 216, -248},
    { 928, 312, -256},
    { 1032, 312, -192},
    { 1200, 344, -184},
    { 1120, 416, -192},
    { 1424, 448, -224},
    { 1352, 528, -152},
    { 1392, 544, -176},
    { 1136, 608, -256},
    { 1000, 520, -232},
    { 936, 472, -256},
    { 1104, 456, -184},
    { 1272, 376, -120},
    { 1160, 280, -24},
    { 1096, 280, -72},
    // 24 seconds
    { 1128, 256, -104},
    { 1120, 240, -96},
    { 1016, 200, -96},
    { 1064, 176, -80},
    { 1248, 200, -120},
    { 1008, 120, -184},
    { 1336, 104, -224},
    { 960, 80, -240},
    { 952, 104, -264},
    { 1096, 112, -320},
    { 1248, 184, -328},
    { 1088, 200, -296},
    { 920, 240, -272},
    { 856, 272, -232},
    { 840, 304, -208},
    { 912, 320, -168},
    { 960, 360, -200},
    { 1448, 424, -192},
    { 1520, 528, -104},
    { 1176, 472, -160},
    { 1384, 696, -200},
    { 1016, 544, -280},
    { 960, 464, -288},
    { 1040, 488, -216},
    { 1192, 416, -176},
    // 25 seconds
    { 1088, 240, -32},
    { 1024, 264, -48},
    { 1144, 232, -104},
    { 1208, 264, -88},
    { 1136, 224, -112},
    { 1144, 176, -96},
    { 1248, 192, -136},
    { 1040, 104, -192},
    { 1280, 72, -192},
    { 1040, 48, -248},
    { 1016, 64, -264},
    { 1040, 48, -296},
    { 1160, 152, -376},
    { 976, 112, -312},
    { 832, 152, -224},
    { 824, 200, -208},
    { 912, 192, -152},
    { 1096, 256, -120},
    { 1176, 320, -160},
    { 1192, 392, -208},
    { 1512, 488, -184},
    { 1328, 512, -224},
    { 1152, 424, -216},
    { 1200, 568, -240},
    { 920, 504, -256},
    // 26 seconds
    { 904, 440, -248},
    { 1048, 456, -152},
    { 1344, 400, -136},
    { 1280, 248, 0},
    { 1176, 216, -8},
    { 1200, 272, -88},
    { 1176, 232, -64},
    { 1064, 208, -40},
    { 1000, 200, -56},
    { 1280, 208, -120},
    { 1080, 152, -176},
    { 1184, 104, -216},
    { 1112, 48, -136},
    { 1104, 16, -160},
    { 1032, 64, -272},
    { 1184, 88, -344},
    { 1048, 112, -304},
    { 832, 120, -280},
    { 840, 184, -248},
    { 912, 256, -176},
    { 1048, 288, -104},
    { 1152, 344, -80},
    { 1168, 432, -152},
    { 1448, 512, -88},
    { 1240, 560, -96},
    // 27 seconds
    { 1168, 552, -200},
    { 1120, 608, -176},
    { 992, 600, -192},
    { 1000, 496, -192},
    { 1104, 480, -176},
    { 1200, 416, -144},
    { 1176, 304, -56},
    { 1168, 256, -56},
    { 1248, 264, -72},
    { 1256, 248, -32},
    { 1144, 192, -80},
    { 1080, 160, -72},
    { 1240, 176, -128},
    { 1008, 144, -184},
    { 1320, 104, -216},
    { 992, 64, -232},
    { 856, 48, -192},
    { 872, 40, -256},
    { 1144, 136, -280},
    { 1112, 160, -264},
    { 1016, 208, -296},
    { 936, 240, -208},
    { 992, 264, -168},
    { 1120, 296, -144},
    { 1112, 384, -152},
    // 28 seconds
    { 1152, 408, -200},
    { 1488, 520, -152},
    { 1288, 608, -144},
    { 1336, 608, -128},
    { 1056, 552, -184},
    { 984, 528, -240},
    { 928, 456, -216},
    { 1112, 456, -160},
    { 1296, 400, -80},
    { 1200, 288, 16},
    { 1176, 224, 0},
    { 1248, 240, -24},
    { 1208, 224, -8},
    { 1072, 216, -16},
    { 1008, 192, -24},
    { 1136, 192, -80},
    { 1064, 176, -144},
    { 1344, 144, -200},
    { 1048, 48, -200},
    { 960, 40, -208},
    { 968, 56, -288},
    { 1088, 104, -280},
    { 1056, 176, -304},
    { 912, 248, -344},
    { 896, 216, -224},
    // 29 seconds
    { 1008, 296, -176},
    { 1144, 352, -128},
    { 1088, 400, -104},
    { 1248, 440, -136},
    { 1504, 584, -24},
    { 1144, 592, -88},
    { 1312, 560, -56},
    { 1064, 608, -136},
    { 968, 520, -152},
    { 952, 464, -104},
    { 1120, 392, -104},
    { 1144, 296, -48},
    { 1128, 256, -40},
    { 1208, 296, -40},
    { 1256, 272, -40},
    { 1176, 232, -32},
    { 1104, 176, -40},
    { 1248, 144, -96},
    { 1192, 128, -224},
    { 1296, 80, -208},
    { 1152, 48, -240},
    { 1016, 32, -208},
    { 928, 40, -256},
    { 1032, 112, -296},
    { 1056, 176, -320},
    // 30 seconds
    { 960, 200, -320},
    { 880, 232, -232},
    { 928, 272, -160},
    { 1016, 336, -136},
    { 1072, 400, -96},
    { 1112, 472, -144},
    { 1560, 512, -80},
    { 1320, 560, -72},
    { 1432, 608, 16},
    { 1016, 584, -80},
    { 936, 584, -208},
    { 928, 528, -192},
    { 1104, 472, -184},
    { 1128, 312, -88},
    { 1056, 232, -56},
    { 1088, 312, 0},
    { 1208, 176, -88},
    { 1176, 256, -32},
    { 1160, 72, -160},
    { 1360, 232, -128},
    { 1312, 96, -256},
    { 1296, 136, -264},
    { 1240, 56, -264},
    { 936, 32, -160},
    { 840, 16, -224},
    // 31 seconds
    { 984, 112, -288},
    { 1032, 160, -320},
    { 912, 176, -296},
    { 816, 168, -240},
    { 856, 176, -200},
    { 968, 264, -168},
    { 1096, 328, -120},
    { 1216, 384, -152},
    { 1664, 488, -96},
    { 1424, 632, -104},
    { 1368, 664, -176},
    { 1056, 712, -136},
    { 856, 584, -192},
    { 896, 576, -240},
    { 1088, 544, -224},
    { 1168, 416, -192},
    { 1112, 312, -88},
    { 1152, 296, 40},
    { 1368, 304, 16},
    { 1288, 192, -32},
    { 1160, 152, -24},
    { 1104, 192, -120},
    { 1192, 168, -216},
    { 1040, 96, -360},
    { 1288, 72, -312},
    // 32 seconds
    { 1032, -72, -192},
    { 1040, -64, -280},
    { 1240, 0, -296},
    { 1192, 96, -272},
    { 928, 192, -296},
    { 872, 248, -256},
    { 968, 304, -104},
    { 1128, 336, -48},
    { 1224, 400, 24},
    { 1184, 432, 40},
    { 1328, 496, 32},
    { 1432, 496, 56},
    { 1168, 536, -48},
    { 1312, 576, 56},
    { 968, 696, -32},
    { 856, 552, -144},
    { 808, 592, -176},
    { 976, 520, -88},
    { 1120, 416, -104},
    { 1032, 320, -72},
    { 1088, 256, -16},
    { 1240, 224, -64},
    { 1248, 248, -8},
    { 1160, 192, -8},
    { 1208, 224, -104},
    // 33 seconds
    { 1344, 216, -184},
    { 1112, 200, -200},
    { 1264, 112, -288},
    { 1160, 88, -200},
    { 944, 72, -240},
    { 912, 120, -360},
    { 1128, 216, -336},
    { 992, 208, -216},
    { 888, 216, -168},
    { 840, 272, -112},
    { 896, 288, -96},
    { 1016, 264, -8},
    { 1128, 352, 0},
    { 1152, 368, -56},
    { 1512, 416, -80},
    { 1304, 520, -32},
    { 1144, 600, -176},
    { 1152, 600, -176},
    { 1000, 560, -192},
    { 904, 536, -184},
    { 968, 528, -144},
    { 1064, 472, -152},
    { 1040, 368, -104},
    { 1008, 224, -56},
    { 1136, 240, -88},
    // 34 seconds
    { 1208, 264, 0},
    { 1192, 264, -16},
    { 1200, 224, -56},
    { 1384, 200, -80},
    { 1112, 240, -136},
    { 1272, 136, -208},
    { 1104, 72, -280},
    { 944, -40, -208},
    { 888, -64, -336},
    { 1024, 0, -352},
    { 1024, 48, -344},
    { 896, 144, -328},
    { 872, 176, -256},
    { 936, 248, -176},
    { 1032, 240, -136},
    { 1160, 304, -48},
    { 1144, 344, -72},
    { 1320, 400, -136},
    { 1528, 536, -88},
    { 1192, 576, -144},
    { 1440, 664, -56},
    { 1008, 632, -152},
    { 840, 608, -184},
    { 840, 560, -56},
    { 1048, 544, -80},
    // 35 seconds
    { 1080, 440, -120},
    { 1016, 344, -16},
    { 1080, 288, 8},
    { 1248, 256, 16},
    { 1320, 280, 72},
    { 1240, 264, 16},
    { 1184, 192, -48},
    { 1184, 200, -144},
    { 1208, 224, -272},
    { 1136, 120, -376},
    { 1216, 32, -304},
    { 1008, 0, -256},
    { 880, 40, -312},
    { 1024, 96, -344},
    { 1096, 160, -328},
    { 992, 168, -240},
    { 904, 216, -160},
    { 936, 256, -104},
    { 1032, 336, -120},
    { 1096, 360, -64},
    { 1048, 400, -64},
    { 1192, 384, -128},
    { 1432, 488, -120},
    { 1248, 512, -56},
    { 1376, 648, 0},
    // 36 seconds
    { 1080, 656, -88},
    { 944, 488, -168},
    { 880, 576, -200},
    { 1008, 512, -112},
    { 1168, 472, -80},
    { 1128, 320, -24},
    { 1088, 264, -24},
    { 1184, 224, -88},
    { 1216, 288, -16},
    { 1184, 264, -32},
    { 1120, 176, -48},
    { 1208, 176, -112},
    { 1184, 176, -192},
    { 1080, 144, -328},
    { 1176, 104, -352},
    { 968, 112, -328},
    { 808, 104, -296},
    { 840, 168, -384},
    { 1136, 256, -352},
    { 1088, 240, -248},
    { 1008, 256, -192},
    { 984, 288, -136},
    { 1024, 288, -80},
    { 1088, 320, -72},
    { 1048, 344, -48},
    // 37 seconds
    { 1064, 352, -80},
    { 1256, 408, -112},
    { 1352, 520, -40},
    { 1096, 544, -112},
    { 1360, 664, -72},
    { 1032, 624, -80},
    { 856, 512, -184},
    { 936, 552, -168},
    { 1120, 528, -144},
    { 1112, 424, -104},
    { 1048, 288, 0},
    { 1120, 240, -48},
    { 1224, 304, -32},
    { 1240, 288, 32},
    { 1168, 224, 32},
    { 1160, 200, 8},
    { 1288, 216, -72},
    { 1152, 192, -176},
    { 1352, 168, -192},
    { 1048, 64, -176},
    { 992, 80, -264},
    { 888, 32, -320},
    { 960, 24, -296},
    { 952, 72, -392},
    { 864, 128, -408},
    // 38 seconds
    { 888, 152, -328},
    { 968, 184, -288},
    { 1008, 264, -224},
    { 1016, 328, -176},
    { 1064, 360, -184},
    { 1496, 448, -208},
    { 1496, 464, -144},
    { 1240, 440, -128},
    { 1232, 520, -112},
    { 896, 504, -128},
    { 832, 480, -152},
    { 840, 480, -144},
    { 1032, 464, -96},
    { 1168, 376, -72},
    { 1128, 248, -24},
    { 1120, 232, -24},
    { 1200, 264, -48},
    { 1248, 296, -40},
    { 1136, 192, -56},
    { 1104, 184, -112},
    { 1112, 184, -184},
    { 1176, 200, -296},
    { 1048, 88, -312},
    { 1280, 88, -328},
    { 1048, 40, -248},
    // 39 seconds
    { 896, 88, -304},
    { 1008, 184, -344},
    { 1112, 208, -288},
    { 1008, 168, -240},
    { 936, 272, -168},
    { 952, 304, -72},
    { 1032, 328, -24},
    { 1128, 352, 16},
    { 1096, 352, 40},
    { 1112, 360, -24},
    { 1328, 440, 8},
    { 1264, 520, -16},
    { 1240, 696, 40},
    { 1144, 728, -64},
    { 976, 632, -160},
    { 872, 624, -160},
    { 1024, 576, -104},
    { 1128, 472, -88},
    { 1104, 344, -24},
    { 1176, 264, -40},
    { 1272, 256, -40},
    { 1288, 264, 0},
    { 1232, 216, -16},
    { 1112, 200, -8},
    { 1176, 200, -72},
    // 40 seconds
    { 1160, 200, -128},
    { 1096, 160, -184},
    { 1288, 104, -208},
    { 1064, 24, -216},
    { 984, 32, -224},
    { 888, 48, -264},
    { 1008, 104, -320},
    { 1008, 160, -360},
    { 968, 200, -320},
    { 944, 200, -240},
    { 976, 232, -192},
    { 1040, 312, -160},
    { 1112, 360, -104},
    { 1120, 400, -112},
    { 1416, 440, -152},
    { 1496, 536, -80},
    { 1280, 568, -56},
    { 1192, 664, -8},
    { 912, 488, -104},
    { 848, 520, -168},
    { 888, 480, -144},
    { 1096, 472, -128},
    { 1224, 424, -80},
    { 1192, 256, -24},
    { 1208, 224, -16},
    // 41 seconds
    { 1272, 248, -56},
    { 1216, 256, -32},
    { 1072, 176, -32},
    { 1008, 176, -40},
    { 1128, 176, -136},
    { 1136, 208, -200},
    { 1280, 160, -200},
    { 1152, 88, -176},
    { 1040, 112, -168},
    { 960, 96, -224},
    { 1048, 136, -256},
    { 1064, 176, -280},
    { 952, 200, -280},
    { 936, 232, -256},
    { 952, 272, -192},
    { 976, 312, -128},
    { 1040, 376, -80},
    { 1024, 376, -104},
    { 1232, 456, -136},
    { 1568, 480, -96},
    { 1208, 496, -64},
    { 1416, 568, -8},
    { 984, 584, -88},
    { 984, 480, -160},
    { 904, 496, -152},
    // 42 seconds
    { 1112, 472, -96},
    { 1216, 408, -56},
    { 1112, 296, 0},
    { 1104, 288, -16},
    { 1160, 280, -24},
    { 1160, 264, -24},
    { 1120, 192, -48},
    { 1064, 168, -64},
    { 1216, 176, -64},
    { 1144, 128, -144},
    { 1176, 168, -248},
    { 1136, 144, -304},
    { 976, 152, -272},
    { 920, 120, -296},
    { 1056, 128, -312},
    { 1104, 168, -328},
    { 960, 184, -304},
    { 848, 216, -240},
    { 848, 264, -176},
    { 920, 296, -144},
    { 1072, 352, -88},
    { 1064, 384, -56},
    { 1256, 432, -80},
    { 1528, 536, 8},
    { 1192, 592, 48},
    // 43 seconds
    { 1488, 656, 40},
    { 1000, 568, -64},
    { 920, 576, -136},
    { 912, 536, -104},
    { 1120, 504, -88},
    { 1176, 432, -96},
    { 1064, 320, -40},
    { 1104, 248, -32},
    { 1184, 264, -40},
    { 1192, 248, -16},
    { 1088, 152, -32},
    { 1104, 160, -48},
    { 1288, 192, -128},
    { 1096, 144, -224},
    { 1280, 152, -240},
    { 1080, 112, -280},
    { 1016, 96, -248},
    { 904, 72, -272},
    { 1064, 104, -352},
    { 984, 152, -304},
    { 880, 184, -288},
    { 848, 208, -240},
    { 912, 248, -152},
    { 1032, 288, -128},
    { 1152, 352, -72},
    // 44 seconds
    { 1088, 384, -72},
    { 1360, 440, -152},
    { 1480, 536, -80},
    { 1160, 552, -88},
    { 1448, 640, -8},
    { 944, 592, -136},
    { 768, 520, -192},
    { 840, 552, -176},
    { 1120, 488, -152},
    { 1224, 456, -160},
    { 1160, 264, -16},
    { 1192, 192, -40},
    { 1248, 256, -56},
    { 1232, 232, -24},
    { 1104, 184, -48},
    { 1064, 176, -88},
    { 1224, 208, -192},
    { 1152, 168, -304},
    { 1112, 64, -360},
    { 1320, 40, -200},
    { 856, -120, -80},
    { 864, 40, -224},
    { 1128, 144, -400},
    { 1144, 208, -304},
    { 1008, 184, -208},
    // 45 seconds
    { 1016, 240, -152},
    { 1112, 336, -88},
    { 1200, 376, -56},
    { 1184, 424, -48},
    { 1024, 416, -104},
    { 1192, 496, -48},
    { 1256, 568, 48},
    { 992, 576, -88},
    { 1328, 648, -16},
    { 1128, 592, -112},
    { 1016, 544, -192},
    { 1152, 512, -120},
    { 1232, 424, -136},
    { 1104, 328, -40},
    { 1168, 232, -72},
    { 1248, 240, -16},
    { 1296, 280, -8},
    { 1200, 224, 0},
    { 1120, 160, -40},
    { 1216, 176, -40},
    { 1104, 168, -104},
    { 1088, 184, -176},
    { 1200, 160, -264},
    { 928, 136, -224},
    { 872, 72, -248},
    // 46 seconds
    { 1064, 64, -400},
    { 1144, 192, -360},
    { 1016, 144, -336},
    { 864, 176, -288},
    { 888, 208, -184},
    { 992, 264, -168},
    { 1104, 328, -96},
    { 1096, 392, -72},
    { 1312, 440, -88},
    { 1512, 560, -8},
    { 1208, 584, -56},
    { 1408, 712, 16},
    { 936, 544, -120},
    { 904, 528, -192},
    { 1016, 504, -136},
    { 1168, 464, -112},
    { 1136, 392, -80},
    { 1104, 240, -48},
    { 1128, 200, -8},
    { 1280, 264, -72},
    { 1240, 272, -16},
    { 1096, 128, -24},
    { 1168, 152, -88},
    { 1136, 216, -128},
    { 1024, 120, -240},
    // 47 seconds
    { 1264, 136, -232},
    { 1080, 88, -96},
    { 1048, 104, -88},
    { 1104, 104, -224},
    { 1176, 208, -376},
    { 992, 232, -256},
    { 808, 304, -216},
    { 864, 232, -272},
    { 960, 424, -152},
    { 1040, 456, -160},
    { 968, 368, -72},
    { 1144, 424, -136},
    { 1552, 496, -104},
    { 1280, 488, -40},
    { 1128, 448, -48},
    { 1080, 544, -40},
    { 912, 528, -128},
    { 1008, 392, -152},
    { 1104, 512, -88},
    { 1248, 408, -104},
    { 1136, 312, -72},
    { 1072, 232, -56},
    { 1136, 240, -88},
    { 1200, 232, -144},
    { 1112, 208, -120},
    // 48 seconds
    { 1000, 168, -120},
    { 1096, 96, -184},
    { 1160, 88, -248},
    { 944, 64, -336},
    { 1312, 88, -344},
    { 984, 104, -288},
    { 936, 168, -256},
    { 1080, 248, -296},
    { 1168, 272, -216},
    { 1000, 256, -216},
    { 872, 320, -112},
    { 904, 320, -144},
    { 992, 280, -104},
    { 1008, 304, -88},
    { 992, 336, -64},
    { 1264, 416, -48},
    { 1528, 528, 24},
    { 1224, 744, 8},
    { 1296, 592, -104},
    { 880, 600, -240},
    { 904, 568, -216},
    { 1040, 560, -120},
    { 1136, 464, -104},
    { 1016, 400, -72},
    { 976, 256, -48},
    // 49 seconds
    { 1072, 248, -64},
    { 1160, 288, -24},
    { 1144, 272, -32},
    { 1104, 176, -32},
    { 1392, 200, -72},
    { 1264, 216, -112},
    { 1200, 168, -224},
    { 1200, 144, -288},
    { 928, 112, -256},
    { 768, 48, -288},
    { 872, 80, -344},
    { 1040, 144, -392},
    { 936, 160, -320},
    { 816, 176, -256},
    { 832, 208, -224},
    { 952, 232, -208},
    { 1088, 272, -160},
    { 1144, 336, -144},
    { 1304, 424, -208},
    { 1408, 568, -168},
    { 1120, 512, -216},
    { 1480, 616, -168},
    { 1096, 640, -176},
    { 952, 480, -240},
    { 928, 496, -216},
    // 50 seconds
    { 1112, 456, -192},
    { 1168, 352, -96},
    { 1072, 256, -8},
    { 1136, 256, -56},
    { 1248, 264, -80},
    { 1208, 248, -80},
    { 1064, 168, -72},
    { 1056, 184, -152},
    { 1104, 200, -248},
    { 1048, 168, -360},
    { 1152, 96, -360},
    { 1048, 64, -280},
    { 920, 64, -136},
    { 888, 80, -224},
    { 1096, 200, -296},
    { 1152, 240, -232},
    { 1008, 256, -208},
    { 912, 280, -176},
    { 952, 312, -168},
    { 1112, 328, -112},
    { 1184, 344, -80},
    { 1064, 400, -144},
    { 1288, 448, -120},
    { 1312, 608, 8},
    { 1352, 672, -160},
    // 51 seconds
    { 1200, 664, -176},
    { 1064, 592, -216},
    { 872, 520, -240},
    { 1000, 496, -152},
    { 1144, 416, -112},
    { 1088, 304, -56},
    { 1136, 272, -80},
    { 1200, 288, -40},
    { 1192, 288, -16},
    { 1104, 200, -48},
    { 1064, 168, -40},
    { 1120, 168, -104},
    { 1048, 152, -216},
    { 1048, 136, -328},
    { 1264, 96, -384},
    { 1000, 24, -232},
    { 936, 8, -248},
    { 1096, 88, -328},
    { 1224, 184, -368},
    { 1072, 200, -328},
    { 952, 208, -272},
    { 968, 232, -144},
    { 1064, 264, -136},
    { 1152, 320, -136},
    { 1144, 400, -160},
    // 52 seconds
    { 1264, 496, -192},
    { 1320, 688, -32},
    { 1096, 576, -136},
    { 1320, 672, -152},
    { 896, 592, -184},
    { 928, 536, -208},
    { 1056, 528, -120},
    { 1280, 472, -104},
    { 1384, 352, -40},
    { 1344, 256, 24},
    { 1376, 256, -16},
    { 1360, 272, -40},
    { 1200, 224, -24},
    { 1104, 144, -64},
    { 1176, 184, -120},
    { 1112, 176, -280},
    { 1016, 160, -384},
    { 1176, 96, -344},
    { 920, 56, -304},
    { 768, 48, -176},
    { 848, 80, -240},
    { 1072, 184, -248},
    { 1152, 216, -208},
    { 1088, 240, -160},
    { 1096, 280, -136},
    // 53 seconds
    { 1200, 312, -136},
    { 1312, 376, -128},
    { 1232, 416, -120},
    { 1168, 488, -128},
    { 1480, 608, -200},
    { 1200, 584, -128},
    { 1344, 704, -104},
    { 1048, 768, -160},
    { 872, 416, -200},
    { 888, 544, -240},
    { 1080, 480, -152},
    { 1320, 384, -160},
    { 1256, 240, -40},
    { 1248, 272, -16},
    { 1344, 248, -64},
    { 1304, 216, -32},
    { 1168, 208, -64},
    { 1032, 208, -88},
    { 1136, 192, -184},
    { 1072, 160, -232},
    { 1208, 120, -200},
    { 1064, 72, -248},
    { 936, 112, -280},
    { 792, 56, -256},
    { 1032, 104, -280},
    // 54 seconds
    { 1144, 152, -256},
    { 1056, 184, -240},
    { 992, 208, -224},
    { 1064, 240, -192},
    { 1168, 264, -168},
    { 1256, 312, -136},
    { 1120, 392, -184},
    { 1312, 472, -192},
    { 1488, 552, -192},
    { 1104, 504, -208},
    { 1368, 616, -136},
    { 1000, 608, -184},
    { 896, 496, -200},
    { 936, 456, -176},
    { 1136, 424, -176},
    { 1216, 344, -112},
    { 1176, 224, -48},
    { 1232, 232, -32},
    { 1304, 248, -40},
    { 1232, 248, -8},
    { 1096, 192, -32},
    { 1176, 176, -96},
    { 1224, 176, -152},
    { 1112, 88, -232},
    { 1344, 80, -208},
    // 55 seconds
    { 992, 8, -248},
    { 880, 16, -320},
    { 984, 16, -304},
    { 1112, 88, -256},
    { 1048, 168, -296},
    { 936, 232, -232},
    { 952, 312, -208},
    { 1024, 336, -128},
    { 1120, 376, -88},
    { 1104, 400, -72},
    { 1240, 448, -64},
    { 1472, 520, -16},
    { 1168, 512, -16},
    { 1384, 568, 24},
    { 960, 600, -40},
    { 960, 552, -128},
    { 928, 528, -168},
    { 1072, 512, -104},
    { 1144, 408, -104},
    { 1056, 312, -48},
    { 1120, 256, -64},
    { 1248, 288, -48},
    { 1344, 256, -72},
    { 1224, 224, -48},
    { 1256, 160, -80},
    // 56 seconds
    { 1296, 168, -168},
    { 1032, 128, -248},
    { 1400, 104, -264},
    { 952, 0, -264},
    { 856, 16, -264},
    { 968, 24, -320},
    { 1144, 96, -360},
    { 1024, 120, -312},
    { 872, 136, -296},
    { 880, 184, -224},
    { 960, 216, -192},
    { 1040, 272, -144},
    { 1096, 304, -144},
    { 1128, 368, -168},
    { 1456, 472, -200},
    { 1400, 600, -136},
    { 1440, 616, -184},
    { 1080, 656, -168},
    { 880, 568, -216},
    { 824, 520, -192},
    { 888, 504, -136},
    { 1208, 424, -80},
    { 1280, 320, -32},
    { 1240, 240, -32},
    { 1264, 200, -80},
    // 57 seconds
    { 1272, 248, -80},
    { 1232, 216, -72},
    { 1080, 240, -136},
    { 984, 152, -184},
    { 1072, 160, -264},
    { 968, 112, -352},
    { 1264, 40, -312},
    { 1072, -8, -208},
    { 1064, 40, -232},
    { 1096, 144, -408},
    { 1280, 232, -384},
    { 1128, 240, -256},
    { 1000, 216, -216},
    { 960, 320, -176},
    { 968, 312, -120},
    { 1000, 320, -56},
    { 992, 344, -24},
    { 1016, 368, -40},
    { 1200, 448, -80},
    { 1280, 512, -48},
    { 992, 544, -128},
    { 1424, 760, -24},
    { 1000, 632, -168},
    { 976, 512, -288},
    { 1032, 576, -256},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:10:10 local
AccelRawData *activity_sample_walk_100_pbl_25298_2(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25298_2
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -32, -72, -984},
    { -24, -168, -1040},
    { -80, -192, -1064},
    { 24, -112, -1016},
    { 72, -72, -1032},
    { 248, -72, -1144},
    { 88, 184, -1024},
    { 232, -24, -1000},
    { 232, -40, -944},
    { 216, -104, -984},
    { 192, -48, -1048},
    { 48, 32, -1072},
    { 144, -112, -1016},
    { 64, -152, -1000},
    { 144, -176, -1024},
    { 184, -232, -1008},
    { 208, -168, -1056},
    { 24, -88, -1072},
    { 136, 24, -1064},
    { 16, 80, -1104},
    { 72, -8, -1032},
    { 64, -40, -1040},
    { 104, -48, -1056},
    { -32, -56, -1032},
    { 72, -80, -1000},
    // 1 seconds
    { 0, -104, -992},
    { -112, -88, -1040},
    { -24, -256, -1000},
    { 8, -272, -968},
    { -32, -256, -984},
    { -96, -232, -1056},
    { 8, -176, -1000},
    { -88, -208, -1016},
    { -64, -184, -1024},
    { -80, -168, -992},
    { -48, -200, -984},
    { -64, -192, -968},
    { -64, -192, -960},
    { -48, -176, -984},
    { -40, -176, -968},
    { -40, -168, -992},
    { -32, -192, -1000},
    { -8, -208, -1008},
    { -8, -208, -1008},
    { 8, -200, -992},
    { -40, -176, -1008},
    { -24, -184, -1000},
    { -32, -208, -1016},
    { 0, -184, -1048},
    { 32, -200, -1032},
    // 2 seconds
    { 32, -208, -1016},
    { 24, -176, -1008},
    { 32, -160, -1016},
    { 48, -184, -1008},
    { 32, -176, -1024},
    { 32, -176, -1016},
    { 32, -184, -1016},
    { 24, -168, -1016},
    { 32, -168, -1016},
    { 32, -176, -1008},
    { 40, -184, -1008},
    { 48, -176, -1016},
    { 48, -184, -1008},
    { 40, -176, -1008},
    { 48, -192, -1016},
    { 40, -192, -1008},
    { 48, -192, -1008},
    { 40, -200, -992},
    { 56, -200, -984},
    { 56, -200, -984},
    { 48, -200, -976},
    { 32, -176, -984},
    { 56, -176, -1016},
    { -24, -176, -1016},
    { -16, -256, -1000},
    // 3 seconds
    { -136, -112, -968},
    { -192, -168, -968},
    { -144, -112, -1008},
    { -144, -128, -1008},
    { -144, -120, -1008},
    { -152, -136, -992},
    { -152, -144, -976},
    { -128, -120, -984},
    { -112, -128, -1016},
    { -112, -120, -1024},
    { -128, -168, -1016},
    { -152, -192, -1000},
    { -168, -272, -944},
    { -120, -272, -920},
    { 80, -232, -912},
    { 376, -112, -816},
    { 640, -8, -664},
    { 824, 8, -592},
    { 968, -72, -424},
    { 1192, 128, -272},
    { 1288, 160, -248},
    { 1304, 200, -208},
    { 1368, 200, -184},
    { 1488, 200, -128},
    { 1640, 224, -72},
    // 4 seconds
    { 1672, 304, -64},
    { 1696, 344, -48},
    { 1736, 456, -232},
    { 1736, 456, -304},
    { 1592, 408, -224},
    { 1424, 600, -264},
    { 976, 1000, -392},
    { 736, 712, -432},
    { 648, 632, -344},
    { 904, 584, -224},
    { 1248, 488, -176},
    { 1456, 352, -48},
    { 1512, 208, -24},
    { 1576, 216, -112},
    { 1616, 200, -88},
    { 1576, 208, -64},
    { 1416, 152, -112},
    { 1488, 152, -192},
    { 1272, 40, -224},
    { 1064, -80, -216},
    { 1136, -232, -96},
    { 800, -120, -128},
    { 936, -64, -176},
    { 1128, -48, -200},
    { 1088, 0, -184},
    // 5 seconds
    { 1040, 32, -216},
    { 1040, 104, -240},
    { 1128, 168, -240},
    { 1216, 192, -224},
    { 1280, 272, -272},
    { 1448, 352, -312},
    { 1776, 480, -376},
    { 1528, 560, -408},
    { 1320, 584, -376},
    { 1072, 736, -544},
    { 1016, 544, -448},
    { 1016, 416, -328},
    { 1352, 296, -224},
    { 1432, 256, -128},
    { 1280, 184, -104},
    { 1248, 176, -104},
    { 1336, 208, -104},
    { 1320, 160, -48},
    { 1320, 152, -104},
    { 1424, 120, -136},
    { 1096, -16, -128},
    { 1008, -88, -192},
    { 920, -112, -112},
    { 872, 0, -200},
    { 1064, -8, -264},
    // 6 seconds
    { 1256, 24, -312},
    { 1128, 8, -232},
    { 984, 72, -264},
    { 968, 160, -296},
    { 1080, 184, -328},
    { 1216, 216, -416},
    { 1440, 264, -400},
    { 1768, 544, -376},
    { 1384, 536, -512},
    { 1360, 536, -304},
    { 1072, 576, -432},
    { 1144, 432, -336},
    { 1088, 368, -216},
    { 1272, 280, -152},
    { 1200, 224, -96},
    { 1048, 216, -128},
    { 1088, 176, -120},
    { 1184, 184, -72},
    { 1224, 176, -120},
    { 1304, 120, -112},
    { 1408, 0, -128},
    { 1112, -16, -184},
    { 1152, -104, -184},
    { 880, -16, -168},
    { 848, 64, -208},
    // 7 seconds
    { 1208, 80, -336},
    { 1288, 64, -344},
    { 1056, 56, -296},
    { 880, 96, -280},
    { 920, 256, -288},
    { 1040, 272, -304},
    { 1248, 328, -280},
    { 1488, 432, -280},
    { 1472, 600, -320},
    { 1184, 608, -328},
    { 1376, 712, -352},
    { 1216, 592, -296},
    { 1152, 456, -288},
    { 1288, 384, -192},
    { 1336, 272, -112},
    { 1112, 200, -48},
    { 1072, 144, -120},
    { 1192, 232, -152},
    { 1288, 168, -104},
    { 1304, 152, -80},
    { 1480, 144, -112},
    { 1072, 16, -112},
    { 1040, -32, -208},
    { 920, -64, -128},
    { 840, 0, -144},
    // 8 seconds
    { 1184, 72, -272},
    { 1384, 40, -336},
    { 1200, 96, -296},
    { 976, 152, -312},
    { 944, 304, -280},
    { 1000, 344, -264},
    { 1096, 424, -296},
    { 1272, 424, -272},
    { 1672, 432, -192},
    { 1320, 472, -216},
    { 1424, 560, -240},
    { 1000, 600, -376},
    { 1032, 432, -312},
    { 1144, 456, -288},
    { 1296, 328, -192},
    { 1192, 176, -64},
    { 1048, 152, -120},
    { 1088, 176, -168},
    { 1200, 176, -160},
    { 1264, 200, -128},
    { 1376, 112, -96},
    { 1416, 80, -120},
    { 1080, -32, -184},
    { 1288, -48, -64},
    { 904, -16, -136},
    // 9 seconds
    { 1016, 0, -216},
    { 1240, 16, -288},
    { 1080, 24, -264},
    { 840, 24, -272},
    { 736, 96, -344},
    { 760, 112, -288},
    { 976, 136, -312},
    { 1184, 144, -320},
    { 1768, 192, -328},
    { 1656, 360, -320},
    { 1208, 376, -448},
    { 1392, 576, -448},
    { 984, 424, -440},
    { 1072, 368, -344},
    { 1184, 376, -280},
    { 1168, 232, -168},
    { 944, 176, -136},
    { 872, 160, -192},
    { 984, 152, -176},
    { 1184, 152, -152},
    { 1344, 104, -152},
    { 1600, 64, -152},
    { 1328, -40, -96},
    { 1096, -96, -160},
    { 1080, -72, -72},
    // 10 seconds
    { 1016, -32, -192},
    { 1216, -40, -248},
    { 1192, 8, -256},
    { 888, 16, -248},
    { 680, 48, -304},
    { 672, 88, -248},
    { 784, 128, -232},
    { 1016, 184, -296},
    { 1288, 176, -304},
    { 1768, 200, -312},
    { 1416, 392, -368},
    { 1544, 488, -488},
    { 1016, 616, -528},
    { 1176, 376, -408},
    { 1176, 328, -264},
    { 1288, 264, -184},
    { 1128, 160, -96},
    { 928, 208, -152},
    { 968, 168, -192},
    { 1080, 176, -168},
    { 1136, 152, -136},
    { 1264, 152, -160},
    { 1392, 96, -152},
    { 1072, -24, -200},
    { 1208, -72, -144},
    // 11 seconds
    { 1000, -48, -96},
    { 1112, 80, -184},
    { 1320, 24, -224},
    { 1256, 48, -232},
    { 1008, 120, -232},
    { 840, 224, -296},
    { 816, 304, -200},
    { 952, 344, -216},
    { 1120, 440, -192},
    { 1328, 488, -120},
    { 1576, 568, -72},
    { 1240, 616, -104},
    { 1352, 664, -48},
    { 984, 672, -152},
    { 1184, 528, -192},
    { 1240, 520, -128},
    { 1336, 472, -96},
    { 1176, 232, 0},
    { 1016, 152, 40},
    { 1104, 192, -128},
    { 1224, 240, -128},
    { 1176, 128, -112},
    { 1240, 96, -104},
    { 1296, 112, -184},
    { 976, 80, -216},
    // 12 seconds
    { 1152, -24, -216},
    { 960, 8, -104},
    { 1040, 104, -192},
    { 1272, 120, -232},
    { 1376, 160, -296},
    { 1120, 184, -240},
    { 904, 152, -240},
    { 872, 216, -208},
    { 984, 264, -288},
    { 1208, 280, -360},
    { 1304, 288, -384},
    { 1576, 328, -432},
    { 1264, 360, -440},
    { 1344, 456, -392},
    { 928, 432, -464},
    { 1216, 352, -360},
    { 1232, 328, -216},
    { 1392, 224, -112},
    { 1392, 120, -56},
    { 1176, 160, -104},
    { 1120, 128, -184},
    { 1112, 136, -160},
    { 1128, 104, -192},
    { 1184, 80, -192},
    { 1312, 32, -248},
    // 13 seconds
    { 976, -72, -248},
    { 1168, -168, -136},
    { 872, -24, -176},
    { 920, -16, -256},
    { 1336, 0, -288},
    { 1440, 32, -256},
    { 1200, 72, -232},
    { 928, 128, -344},
    { 888, 152, -264},
    { 976, 184, -248},
    { 1104, 264, -280},
    { 1216, 280, -272},
    { 1672, 392, -232},
    { 1432, 584, -376},
    { 1232, 552, -416},
    { 1072, 536, -440},
    { 1248, 400, -400},
    { 1232, 368, -296},
    { 1448, 312, -216},
    { 1416, 120, -40},
    { 1144, 72, -8},
    { 1192, 184, -152},
    { 1296, 136, -88},
    { 1224, 136, -72},
    { 1224, 112, -56},
    // 14 seconds
    { 1336, 56, -88},
    { 904, 8, -120},
    { 1176, -32, -144},
    { 824, -64, -128},
    { 1048, 40, -216},
    { 1264, -8, -256},
    { 1304, -8, -264},
    { 1128, 40, -232},
    { 936, 88, -304},
    { 984, 160, -280},
    { 1088, 136, -256},
    { 1192, 184, -288},
    { 1392, 232, -288},
    { 1816, 424, -240},
    { 1360, 520, -432},
    { 1272, 536, -360},
    { 960, 576, -512},
    { 1104, 424, -400},
    { 1248, 400, -304},
    { 1432, 296, -192},
    { 1344, 144, -40},
    { 1208, 112, -72},
    { 1256, 136, -120},
    { 1320, 96, -104},
    { 1200, 128, -80},
    // 15 seconds
    { 1224, 112, -112},
    { 1264, 80, -120},
    { 960, 24, -144},
    { 1008, -48, -144},
    { 968, -56, -80},
    { 1048, -8, -192},
    { 1296, -24, -232},
    { 1440, 0, -224},
    { 1176, 48, -216},
    { 920, 120, -280},
    { 936, 160, -208},
    { 1080, 216, -120},
    { 1240, 336, -152},
    { 1272, 520, -216},
    { 1632, 520, -16},
    { 1400, 616, -248},
    { 1056, 496, -200},
    { 1272, 656, -288},
    { 976, 616, -296},
    { 1184, 448, -208},
    { 1344, 472, -200},
    { 1320, 328, -160},
    { 1168, 128, -32},
    { 1144, 120, -80},
    { 1288, 184, -144},
    // 16 seconds
    { 1328, 200, -96},
    { 1248, 120, -64},
    { 1344, 64, -88},
    { 1080, 32, -112},
    { 1232, -128, 24},
    { 976, -104, 48},
    { 1224, -24, -112},
    { 1416, 0, -192},
    { 1248, 24, -224},
    { 1032, 56, -256},
    { 856, 96, -320},
    { 896, 104, -216},
    { 1024, 176, -216},
    { 1200, 272, -216},
    { 1488, 320, -176},
    { 1808, 552, -176},
    { 1320, 568, -352},
    { 1032, 480, -296},
    { 1112, 616, -424},
    { 1160, 488, -384},
    { 1224, 424, -256},
    { 1384, 368, -280},
    { 1304, 208, -32},
    { 1184, 64, -16},
    { 1256, 40, -88},
    // 17 seconds
    { 1472, 88, -80},
    { 1240, 136, -40},
    { 1344, 96, -96},
    { 1192, 104, -88},
    { 856, -88, -96},
    { 1224, -176, -56},
    { 1048, -104, -192},
    { 1144, -144, -72},
    { 1544, -40, -176},
    { 1312, 16, -256},
    { 1056, -16, -248},
    { 1024, 32, -200},
    { 1224, 72, -144},
    { 1336, 224, -96},
    { 1256, 576, -176},
    { 1400, 608, -344},
    { 1448, 536, -168},
    { 1072, 512, -200},
    { 1352, 632, -264},
    { 1112, 584, -304},
    { 1328, 344, -272},
    { 1384, 408, -160},
    { 1536, 368, -200},
    { 1360, 152, -24},
    { 1288, -8, 24},
    // 18 seconds
    { 1336, 24, -80},
    { 1320, 160, -80},
    { 1200, 136, -88},
    { 1328, -24, -104},
    { 1072, -32, -128},
    { 912, 8, -168},
    { 1120, 40, -168},
    { 848, 8, -160},
    { 992, 32, -176},
    { 1344, 32, -256},
    { 1232, 8, -232},
    { 1088, 24, -232},
    { 992, 112, -280},
    { 1040, 96, -232},
    { 1224, 168, -280},
    { 1248, 248, -304},
    { 1480, 328, -296},
    { 1808, 512, -408},
    { 1240, 448, -360},
    { 1520, 616, -408},
    { 992, 464, -416},
    { 1176, 328, -336},
    { 1256, 352, -248},
    { 1464, 264, -144},
    { 1368, 40, -24},
    // 19 seconds
    { 1184, 16, 0},
    { 1224, 200, -144},
    { 1232, 208, -104},
    { 1136, 136, 32},
    { 1072, 24, 112},
    { 1248, 24, 0},
    { 984, -16, -16},
    { 1288, -72, -64},
    { 896, -8, -128},
    { 1072, 0, -200},
    { 1232, -24, -280},
    { 1256, -24, -304},
    { 1064, -8, -256},
    { 872, 16, -336},
    { 864, 8, -296},
    { 960, 88, -272},
    { 1120, 152, -296},
    { 1312, 176, -280},
    { 1768, 208, -288},
    { 1352, 488, -352},
    { 1408, 496, -400},
    { 1040, 464, -448},
    { 1112, 352, -384},
    { 1136, 320, -312},
    { 1328, 272, -224},
    // 20 seconds
    { 1232, 104, -88},
    { 1072, 128, -88},
    { 1112, 128, -136},
    { 1192, 104, -104},
    { 1176, 88, -72},
    { 1160, 40, -96},
    { 1368, 56, -104},
    { 1104, 16, -152},
    { 1200, -48, -112},
    { 1008, -64, -40},
    { 960, 24, -128},
    { 1128, 16, -208},
    { 1248, 16, -240},
    { 1040, 48, -184},
    { 832, 88, -240},
    { 888, 128, -232},
    { 1112, 200, -200},
    { 1312, 240, -216},
    { 1392, 280, -240},
    { 1696, 336, -232},
    { 1320, 544, -432},
    { 1312, 528, -360},
    { 968, 472, -440},
    { 1192, 376, -376},
    { 1256, 344, -280},
    // 21 seconds
    { 1432, 320, -208},
    { 1320, 104, -32},
    { 1144, 32, 16},
    { 1064, 184, -152},
    { 1128, 160, -104},
    { 1120, 128, -48},
    { 1200, 136, -32},
    { 1416, 88, -56},
    { 1080, 40, -96},
    { 1200, -40, -48},
    { 944, -48, -16},
    { 1176, -16, -208},
    { 1344, 0, -232},
    { 1216, -16, -224},
    { 952, 0, -240},
    { 808, 64, -288},
    { 872, 120, -176},
    { 1048, 168, -200},
    { 1264, 264, -200},
    { 1472, 256, -184},
    { 1712, 496, -168},
    { 1304, 512, -488},
    { 1632, 576, -328},
    { 952, 488, -408},
    { 1184, 352, -360},
    // 22 seconds
    { 1224, 400, -312},
    { 1328, 272, -192},
    { 1208, 152, -64},
    { 1096, 88, -88},
    { 1184, 104, -152},
    { 1304, 96, -144},
    { 1256, 64, -72},
    { 1392, 40, -128},
    { 1328, 32, -120},
    { 984, -72, -96},
    { 1224, -72, -72},
    { 872, -32, -112},
    { 976, 16, -192},
    { 1288, 0, -224},
    { 1248, 0, -176},
    { 1056, 64, -248},
    { 944, 160, -296},
    { 968, 112, -256},
    { 1040, 136, -272},
    { 1136, 224, -280},
    { 1384, 280, -288},
    { 1688, 456, -360},
    { 1304, 392, -400},
    { 1432, 512, -360},
    { 928, 464, -496},
    // 23 seconds
    { 1192, 304, -400},
    { 1304, 312, -320},
    { 1520, 272, -176},
    { 1392, 32, -8},
    { 1176, 72, -64},
    { 1216, 112, -128},
    { 1184, 120, -112},
    { 1104, 104, -96},
    { 1096, 72, -88},
    { 1200, 56, -104},
    { 992, -16, -120},
    { 1112, -80, -96},
    { 976, -48, -72},
    { 1208, 40, -192},
    { 1312, 0, -224},
    { 1384, 16, -256},
    { 1168, 8, -208},
    { 1016, 88, -256},
    { 1008, 112, -240},
    { 1144, 184, -248},
    { 1224, 224, -272},
    { 1272, 232, -272},
    { 1688, 416, -272},
    { 1328, 432, -376},
    { 1448, 512, -312},
    // 24 seconds
    { 920, 528, -448},
    { 1216, 392, -384},
    { 1256, 392, -264},
    { 1424, 256, -160},
    { 1336, 80, -16},
    { 1224, 120, -88},
    { 1232, 168, -152},
    { 1256, 88, -120},
    { 1264, 120, -88},
    { 1360, 48, -88},
    { 1448, 40, -144},
    { 1104, -8, -120},
    { 1256, -8, -112},
    { 800, 32, -112},
    { 888, -8, -224},
    { 1088, 24, -232},
    { 1160, 40, -264},
    { 1016, 64, -288},
    { 912, 88, -328},
    { 984, 104, -264},
    { 1136, 152, -232},
    { 1184, 200, -288},
    { 1584, 216, -240},
    { 1720, 440, -296},
    { 1232, 464, -528},
    // 25 seconds
    { 1520, 488, -480},
    { 968, 432, -472},
    { 1168, 320, -392},
    { 1312, 352, -312},
    { 1360, 240, -168},
    { 1176, 104, -40},
    { 1104, 160, -104},
    { 1144, 128, -88},
    { 1216, 120, -72},
    { 1200, 168, -48},
    { 1352, 112, -32},
    { 1352, 120, -40},
    { 1040, 120, -96},
    { 1208, 0, -88},
    { 808, -32, -88},
    { 920, 24, -216},
    { 1128, -16, -280},
    { 1200, 24, -296},
    { 1056, 80, -312},
    { 920, 64, -352},
    { 960, 40, -288},
    { 1080, 64, -296},
    { 1192, 64, -368},
    { 1592, 232, -320},
    { 1712, 472, -320},
    // 26 seconds
    { 1256, 472, -480},
    { 1512, 584, -480},
    { 864, 456, -424},
    { 1128, 312, -320},
    { 1272, 352, -224},
    { 1424, 208, -112},
    { 1224, 128, -32},
    { 1112, 136, -80},
    { 1168, 112, -128},
    { 1184, 128, -72},
    { 1160, 144, -104},
    { 1256, 104, -56},
    { 1248, 112, -160},
    { 1048, 16, -168},
    { 1232, -112, -128},
    { 848, -48, -176},
    { 1048, 0, -232},
    { 1240, -16, -272},
    { 1144, 32, -272},
    { 912, 16, -256},
    { 816, 56, -216},
    { 944, 88, -192},
    { 1128, 160, -224},
    { 1248, 168, -256},
    { 1752, 184, -312},
    // 27 seconds
    { 1736, 480, -328},
    { 1256, 336, -544},
    { 1360, 464, -504},
    { 1032, 376, -448},
    { 1048, 272, -400},
    { 1176, 320, -312},
    { 1256, 208, -176},
    { 1112, 96, -56},
    { 1072, 112, -104},
    { 1192, 112, -88},
    { 1304, 128, -96},
    { 1288, 128, -64},
    { 1432, 104, -88},
    { 1248, 64, -120},
    { 1128, -16, -80},
    { 1288, -128, 8},
    { 984, -136, -72},
    { 1112, -56, -168},
    { 1216, -24, -248},
    { 1056, -32, -208},
    { 912, 0, -224},
    { 928, 192, -232},
    { 1024, 288, -200},
    { 1200, 320, -176},
    { 1360, 344, -184},
    // 28 seconds
    { 1480, 424, -168},
    { 1616, 488, -200},
    { 1120, 464, -200},
    { 1368, 616, -208},
    { 824, 624, -344},
    { 1184, 432, -288},
    { 1272, 424, -192},
    { 1328, 304, -144},
    { 1136, 160, -32},
    { 1080, 120, -64},
    { 1160, 128, -104},
    { 1208, 192, -72},
    { 1176, 192, -40},
    { 1328, 136, -24},
    { 1296, 112, -32},
    { 1048, 64, -104},
    { 1248, -8, -8},
    { 1008, 0, -176},
    { 1104, 24, -216},
    { 1280, -16, -256},
    { 1080, 48, -280},
    { 848, 88, -296},
    { 816, 104, -296},
    { 936, 72, -232},
    { 1048, 120, -200},
    // 29 seconds
    { 1160, 176, -240},
    { 1616, 216, -256},
    { 1504, 384, -248},
    { 1232, 320, -440},
    { 1384, 440, -432},
    { 1008, 416, -416},
    { 1040, 312, -312},
    { 1264, 312, -264},
    { 1224, 152, -112},
    { 1064, 120, -88},
    { 976, 120, -136},
    { 1096, 144, -112},
    { 1160, 152, -104},
    { 1096, 120, -72},
    { 1336, 80, -120},
    { 1296, 32, -96},
    { 1176, -40, -136},
    { 1304, -104, 16},
    { 928, -24, -104},
    { 1064, 24, -216},
    { 1184, 24, -288},
    { 992, 32, -232},
    { 848, 32, -232},
    { 864, 96, -192},
    { 1032, 128, -128},
    // 30 seconds
    { 1232, 144, -192},
    { 1112, 176, -256},
    { 1352, 256, -272},
    { 1608, 272, -304},
    { 1040, 280, -304},
    { 1528, 352, -400},
    { 1056, 408, -448},
    { 1128, 304, -360},
    { 1184, 344, -256},
    { 1312, 280, -160},
    { 1216, 184, -24},
    { 1120, 88, 32},
    { 1136, 152, 0},
    { 1208, 144, 32},
    { 1256, 216, -16},
    { 1392, 256, 32},
    { 1304, 248, 32},
    { 1064, 120, 96},
    { 1256, -24, 96},
    { 880, -88, -88},
    { 1000, -72, -104},
    { 1136, -104, -120},
    { 1072, 24, -184},
    { 880, 48, -216},
    { 768, 48, -248},
    // 31 seconds
    { 896, 8, -232},
    { 1032, 48, -224},
    { 1168, 104, -288},
    { 1512, 176, -304},
    { 2000, 312, -368},
    { 1376, 488, -520},
    { 1344, 408, -392},
    { 952, 392, -448},
    { 1032, 352, -360},
    { 1104, 344, -288},
    { 1288, 280, -192},
    { 1184, 168, -64},
    { 1064, 128, -72},
    { 1056, 48, -104},
    { 1096, -16, -120},
    { 1136, 0, -104},
    { 1168, 176, -112},
    { 1384, 200, -168},
    { 1152, 120, -264},
    { 1408, 16, -168},
    { 1064, -72, -152},
    { 1088, -104, -176},
    { 968, -8, -192},
    { 1040, 272, -288},
    { 928, 192, -344},
    // 32 seconds
    { 816, 200, -288},
    { 888, 104, -272},
    { 1000, 88, -200},
    { 1128, 104, -264},
    { 1216, 192, -280},
    { 1648, 376, -384},
    { 1376, 648, -456},
    { 1160, 400, -344},
    { 1152, 512, -400},
    { 1200, 520, -336},
    { 1152, 408, -232},
    { 1368, 344, -104},
    { 1336, 160, 16},
    { 1112, 136, -8},
    { 1072, 192, -104},
    { 1120, 152, -80},
    { 1160, 144, -40},
    { 1176, 192, -24},
    { 1408, 160, -96},
    { 1088, 88, -80},
    { 1040, -8, -184},
    { 1104, -72, -32},
    { 896, -48, -144},
    { 1064, 48, -232},
    { 1320, -32, -352},
    // 33 seconds
    { 1192, 48, -320},
    { 968, 24, -272},
    { 944, 40, -264},
    { 1104, 72, -224},
    { 1272, 144, -280},
    { 1288, 224, -328},
    { 1648, 368, -304},
    { 1424, 528, -384},
    { 1056, 360, -328},
    { 1384, 560, -472},
    { 1056, 568, -392},
    { 1280, 368, -232},
    { 1424, 288, -136},
    { 1368, 144, 40},
    { 1152, 88, 56},
    { 1192, 184, -136},
    { 1288, 240, -192},
    { 1280, 240, -72},
    { 1248, 224, -88},
    { 1312, 184, -48},
    { 1040, 152, -32},
    { 968, 112, -96},
    { 936, 80, -96},
    { 960, 32, -208},
    { 1040, -8, -288},
    // 34 seconds
    { 1176, 24, -288},
    { 1144, 64, -248},
    { 1016, 32, -256},
    { 992, 136, -288},
    { 1080, 200, -336},
    { 1160, 232, -312},
    { 1248, 256, -360},
    { 1416, 352, -256},
    { 1496, 512, -176},
    { 1208, 448, -448},
    { 1376, 624, -472},
    { 1120, 552, -392},
    { 1008, 368, -312},
    { 1152, 360, -224},
    { 1224, 248, -128},
    { 1128, 208, -72},
    { 1112, 216, -120},
    { 1168, 152, -112},
    { 1176, 184, -88},
    { 1104, 176, -72},
    { 1336, 160, -32},
    { 1216, 176, -72},
    { 1120, 96, -192},
    { 1120, 80, -64},
    { 1136, 32, -200},
    // 35 seconds
    { 1216, -8, -200},
    { 1216, 32, -216},
    { 984, 32, -232},
    { 808, 32, -328},
    { 752, 112, -296},
    { 872, 144, -288},
    { 1048, 144, -304},
    { 1184, 208, -376},
    { 1496, 280, -360},
    { 1504, 504, -368},
    { 1208, 320, -440},
    { 1576, 456, -432},
    { 1104, 400, -440},
    { 1104, 320, -360},
    { 1208, 352, -240},
    { 1280, 200, -96},
    { 1096, 200, -48},
    { 1080, 184, -72},
    { 1112, 168, -88},
    { 1216, 184, -48},
    { 1224, 168, -56},
    { 1376, 160, -48},
    { 1384, 112, -72},
    { 1056, 32, -88},
    { 1088, -24, -136},
    // 36 seconds
    { 856, -56, -208},
    { 944, -48, -280},
    { 1192, -32, -304},
    { 1280, 8, -328},
    { 1048, 96, -328},
    { 816, 88, -312},
    { 872, 112, -304},
    { 1016, 192, -312},
    { 1136, 200, -328},
    { 1224, 280, -368},
    { 1560, 432, -248},
    { 1424, 504, -352},
    { 1432, 544, -368},
    { 1048, 504, -368},
    { 1080, 432, -352},
    { 1048, 376, -280},
    { 1256, 344, -160},
    { 1296, 192, -24},
    { 1120, 184, -8},
    { 1152, 192, -112},
    { 1168, 208, -88},
    { 1232, 184, -64},
    { 1208, 176, -40},
    { 1376, 144, -72},
    { 1240, 96, -56},
    // 37 seconds
    { 1112, 40, -120},
    { 1072, 24, -104},
    { 1000, -24, -88},
    { 1008, 8, -208},
    { 1184, 0, -280},
    { 1192, 16, -400},
    { 968, 56, -456},
    { 880, 56, -424},
    { 968, 48, -376},
    { 1168, 136, -344},
    { 1240, 328, -344},
    { 1464, 480, -432},
    { 1536, 456, -328},
    { 1064, 480, -288},
    { 1408, 680, -296},
    { 1024, 632, -384},
    { 1336, 424, -272},
    { 1432, 472, -192},
    { 1560, 296, -80},
    { 1280, 152, 32},
    { 1128, 176, -48},
    { 1200, 176, -104},
    { 1312, 168, -48},
    { 1304, 184, -40},
    { 1408, 120, -8},
    // 38 seconds
    { 1128, 80, -8},
    { 896, 8, -120},
    { 1112, -56, -64},
    { 856, -80, -88},
    { 1128, -8, -208},
    { 1368, 0, -248},
    { 1320, 56, -280},
    { 1064, 64, -296},
    { 880, 96, -304},
    { 968, 88, -304},
    { 1168, 64, -312},
    { 1224, 56, -368},
    { 1480, 200, -328},
    { 1672, 488, -416},
    { 1208, 432, -472},
    { 1496, 592, -488},
    { 1008, 496, -496},
    { 1296, 360, -344},
    { 1400, 352, -240},
    { 1648, 224, -88},
    { 1392, 72, 48},
    { 1200, 120, -40},
    { 1280, 192, -80},
    { 1296, 184, -72},
    { 1176, 136, -24},
    // 39 seconds
    { 1104, 120, -24},
    { 1144, 136, -56},
    { 864, 56, -96},
    { 888, 16, -120},
    { 904, -16, -128},
    { 1088, 32, -216},
    { 1320, 0, -232},
    { 1632, -24, -328},
    { 1336, 56, -224},
    { 1008, 104, -264},
    { 992, 208, -312},
    { 1096, 248, -296},
    { 1152, 248, -264},
    { 1144, 304, -240},
    { 1336, 352, -232},
    { 1560, 488, -224},
    { 1200, 480, -296},
    { 1200, 544, -256},
    { 928, 536, -360},
    { 1248, 440, -320},
    { 1336, 424, -224},
    { 1560, 368, -160},
    { 1448, 224, -24},
    { 1256, 144, 16},
    { 1256, 160, -72},
    // 40 seconds
    { 1240, 168, -56},
    { 1176, 144, -64},
    { 1024, 120, -24},
    { 1136, 128, -32},
    { 1088, 112, -88},
    { 888, 112, -112},
    { 1232, 88, -160},
    { 968, 8, -160},
    { 1144, 24, -208},
    { 1448, -16, -304},
    { 1312, 64, -272},
    { 1056, 96, -272},
    { 896, 160, -336},
    { 944, 120, -304},
    { 1008, 80, -264},
    { 1128, 192, -272},
    { 1264, 248, -280},
    { 1696, 328, -280},
    { 1296, 456, -288},
    { 1080, 384, -352},
    { 1200, 512, -456},
    { 1192, 424, -352},
    { 1232, 320, -256},
    { 1400, 312, -192},
    { 1432, 168, -80},
    // 41 seconds
    { 1224, 120, 0},
    { 1056, 144, -64},
    { 1088, 168, -64},
    { 1112, 184, -80},
    { 1072, 152, -16},
    { 1312, 128, -24},
    { 1056, 120, -80},
    { 1024, 48, -112},
    { 1256, -16, -56},
    { 1032, -40, -176},
    { 1144, -64, -232},
    { 1352, -56, -224},
    { 1160, 16, -152},
    { 888, 176, -224},
    { 784, 312, -304},
    { 864, 248, -200},
    { 1040, 224, -112},
    { 1144, 280, -104},
    { 1400, 336, -152},
    { 1664, 496, -152},
    { 1144, 664, -224},
    { 1552, 584, -384},
    { 1024, 544, -352},
    { 1192, 488, -288},
    { 1184, 408, -208},
    // 42 seconds
    { 1344, 352, -168},
    { 1248, 224, -48},
    { 1080, 128, 24},
    { 1112, 192, -120},
    { 1176, 240, -112},
    { 1112, 160, 0},
    { 1144, 176, -16},
    { 1280, 144, -24},
    { 976, 168, -88},
    { 1080, 88, -144},
    { 840, 128, -88},
    { 1056, 72, -168},
    { 1256, 120, -240},
    { 1336, 104, -280},
    { 1032, 120, -224},
    { 792, 72, -240},
    { 832, 136, -216},
    { 992, 152, -184},
    { 1168, 192, -208},
    { 1240, 248, -240},
    { 1728, 216, -272},
    { 1480, 504, -320},
    { 1184, 688, -704},
    { 1088, 456, -488},
    { 1216, 384, -408},
    // 43 seconds
    { 1280, 328, -288},
    { 1464, 288, -168},
    { 1448, 128, -40},
    { 1248, 112, -8},
    { 1248, 184, -104},
    { 1264, 168, -88},
    { 1200, 152, -72},
    { 1096, 136, -40},
    { 1264, 112, -88},
    { 952, 72, -136},
    { 784, -8, -168},
    { 1072, -24, -96},
    { 864, 8, -128},
    { 1152, 72, -200},
    { 1504, 16, -312},
    { 1272, 72, -240},
    { 1008, 8, -208},
    { 984, 104, -264},
    { 1152, 152, -232},
    { 1352, 128, -272},
    { 1272, 168, -288},
    { 1528, 248, -304},
    { 1456, 504, -352},
    { 1080, 336, -536},
    { 1280, 464, -504},
    // 44 seconds
    { 1160, 472, -456},
    { 1296, 296, -328},
    { 1464, 312, -232},
    { 1536, 136, -80},
    { 1304, 56, 16},
    { 1048, 120, -40},
    { 1192, 168, -120},
    { 1200, 160, -88},
    { 1056, 96, 8},
    { 1200, 136, -48},
    { 1080, 136, -112},
    { 800, 64, -128},
    { 1168, 16, -88},
    { 856, 8, -128},
    { 1144, -16, -208},
    { 1504, -32, -232},
    { 1376, -8, -168},
    { 1120, 32, -120},
    { 984, 368, -296},
    { 952, 384, -320},
    { 1112, 240, -216},
    { 1184, 376, -224},
    { 1384, 352, -168},
    { 1592, 512, -128},
    { 1120, 528, -304},
    // 45 seconds
    { 1456, 600, -296},
    { 944, 512, -336},
    { 1152, 424, -328},
    { 1280, 464, -256},
    { 1480, 336, -184},
    { 1360, 200, -32},
    { 1048, 16, 144},
    { 1240, 248, -160},
    { 1304, 224, -128},
    { 1216, 160, -32},
    { 1216, 104, -48},
    { 1192, 104, -80},
    { 896, 0, -128},
    { 1056, -48, -56},
    { 856, -72, -32},
    { 1152, -16, -200},
    { 1384, 88, -248},
    { 1392, 112, -192},
    { 1120, 168, -184},
    { 904, 216, -248},
    { 968, 216, -224},
    { 1160, 216, -168},
    { 1224, 264, -200},
    { 1192, 240, -240},
    { 1560, 336, -320},
    // 46 seconds
    { 1296, 648, -384},
    { 1208, 448, -496},
    { 1016, 488, -480},
    { 1200, 376, -368},
    { 1184, 304, -312},
    { 1432, 296, -224},
    { 1472, 192, -112},
    { 1264, 160, -80},
    { 1208, 144, -152},
    { 1200, 136, -160},
    { 1128, 112, -128},
    { 1008, 88, -112},
    { 1160, 88, -136},
    { 1128, 64, -152},
    { 928, 40, -176},
    { 1216, 48, -200},
    { 928, 32, -176},
    { 1104, 72, -272},
    { 1424, 104, -288},
    { 1384, 192, -272},
    { 1080, 168, -256},
    { 888, 232, -280},
    { 904, 216, -200},
    { 1088, 208, -168},
    { 1128, 232, -192},
    // 47 seconds
    { 1288, 224, -216},
    { 1704, 336, -216},
    { 1256, 584, -256},
    { 1384, 544, -488},
    { 912, 512, -456},
    { 1056, 376, -384},
    { 1144, 376, -320},
    { 1392, 320, -256},
    { 1336, 200, -80},
    { 1224, 128, -72},
    { 1184, 184, -136},
    { 1256, 168, -120},
    { 1232, 152, -72},
    { 1320, 192, -144},
    { 1344, 80, -72},
    { 1152, 24, -104},
    { 1272, -80, 8},
    { 888, -96, 0},
    { 976, -56, -112},
    { 1152, -56, -232},
    { 1288, 0, -248},
    { 1120, 8, -232},
    { 904, 16, -296},
    { 896, 16, -272},
    { 976, 8, -256},
    // 48 seconds
    { 1080, 72, -296},
    { 1192, 80, -360},
    { 1744, 96, -392},
    { 1608, 424, -504},
    { 1128, 264, -592},
    { 1384, 376, -576},
    { 1000, 264, -520},
    { 1136, 224, -424},
    { 1368, 256, -304},
    { 1568, 104, -128},
    { 1392, 112, -48},
    { 1280, 120, -112},
    { 1264, 112, -112},
    { 1208, 96, -104},
    { 1040, 104, -88},
    { 1120, 96, -80},
    { 1120, 32, -64},
    { 848, -16, -112},
    { 1088, -40, -136},
    { 992, -72, -176},
    { 1168, -72, -264},
    { 1408, -96, -256},
    { 1368, 0, -264},
    { 1096, 96, -296},
    { 936, 48, -304},
    // 49 seconds
    { 968, 40, -248},
    { 1016, 152, -256},
    { 1072, 168, -288},
    { 1224, 216, -256},
    { 1720, 328, -272},
    { 1456, 464, -344},
    { 1512, 520, -392},
    { 984, 488, -432},
    { 1088, 384, -416},
    { 1088, 336, -360},
    { 1352, 336, -264},
    { 1472, 168, -96},
    { 1224, 72, 40},
    { 1240, 144, -112},
    { 1264, 152, -144},
    { 1224, 128, -136},
    { 1080, 104, -80},
    { 1144, 64, -88},
    { 1016, 40, -136},
    { 928, -64, -176},
    { 1168, -88, -104},
    { 1048, -56, -176},
    { 1160, -16, -216},
    { 1472, -32, -176},
    { 1392, 56, -160},
    // 50 seconds
    { 1104, 264, -216},
    { 944, 328, -296},
    { 952, 336, -208},
    { 1104, 320, -144},
    { 1168, 368, -128},
    { 1272, 392, -128},
    { 1552, 504, -40},
    { 1200, 584, -152},
    { 1312, 624, -128},
    { 880, 624, -264},
    { 1176, 512, -232},
    { 1224, 480, -176},
    { 1400, 408, -152},
    { 1224, 280, -8},
    { 1152, 136, 24},
    { 1192, 176, -80},
    { 1304, 272, -88},
    { 1248, 216, -24},
    { 1256, 136, -16},
    { 1304, 136, -64},
    { 1048, 64, -88},
    { 1072, 0, -176},
    { 944, -16, -128},
    { 984, 56, -208},
    { 1184, 24, -240},
    // 51 seconds
    { 1320, 40, -336},
    { 1096, 104, -256},
    { 864, 88, -248},
    { 864, 144, -288},
    { 968, 104, -232},
    { 1120, 152, -280},
    { 1104, 168, -296},
    { 1488, 176, -296},
    { 1392, 336, -344},
    { 1264, 376, -456},
    { 1144, 504, -592},
    { 1240, 368, -416},
    { 1232, 280, -320},
    { 1336, 264, -240},
    { 1288, 160, -144},
    { 1088, 120, -104},
    { 992, 144, -176},
    { 1080, 112, -176},
    { 1152, 96, -152},
    { 1112, 96, -120},
    { 1368, 88, -144},
    { 1032, 56, -160},
    { 1056, -40, -104},
    { 1048, -48, -128},
    { 1080, -24, -184},
    // 52 seconds
    { 1232, -16, -248},
    { 1376, 40, -248},
    { 1072, 80, -216},
    { 816, 144, -312},
    { 784, 256, -288},
    { 864, 136, -176},
    { 1080, 216, -176},
    { 1192, 248, -216},
    { 1696, 288, -200},
    { 1488, 656, -176},
    { 1152, 520, -568},
    { 1264, 536, -416},
    { 1120, 416, -368},
    { 1168, 360, -328},
    { 1392, 384, -296},
    { 1320, 264, -128},
    { 1168, 128, -72},
    { 1056, 104, -40},
    { 1208, 168, -136},
    { 1224, 136, -104},
    { 1120, 120, -88},
    { 1288, 112, -96},
    { 1072, 96, -112},
    { 888, 40, -168},
    { 1144, -24, -152},
    // 53 seconds
    { 872, -24, -176},
    { 1096, 16, -216},
    { 1432, 32, -256},
    { 1328, 88, -256},
    { 1000, 104, -248},
    { 832, 144, -304},
    { 864, 160, -216},
    { 1024, 152, -224},
    { 1088, 216, -272},
    { 1344, 232, -272},
    { 1808, 336, -264},
    { 1384, 544, -384},
    { 1424, 528, -424},
    { 936, 400, -448},
    { 1176, 312, -384},
    { 1176, 344, -304},
    { 1336, 304, -216},
    { 1240, 136, -48},
    { 1072, 72, 16},
    { 1160, 200, -160},
    { 1184, 160, -120},
    { 1144, 112, -56},
    { 1160, 120, -56},
    { 1360, 144, -96},
    { 1120, 104, -176},
    // 54 seconds
    { 1032, -40, -112},
    { 960, -96, -64},
    { 1016, -16, -176},
    { 1184, 16, -232},
    { 1368, 32, -296},
    { 1120, 120, -336},
    { 824, 96, -312},
    { 832, 168, -312},
    { 992, 176, -216},
    { 1232, 208, -200},
    { 1344, 296, -208},
    { 1664, 392, -248},
    { 1360, 520, -264},
    { 1000, 416, -376},
    { 1280, 608, -416},
    { 952, 448, -360},
    { 1216, 376, -312},
    { 1432, 400, -264},
    { 1536, 280, -128},
    { 1296, 128, -16},
    { 1208, 112, -48},
    { 1256, 176, -104},
    { 1272, 216, -104},
    { 1184, 184, -80},
    { 1192, 272, -128},
    // 55 seconds
    { 1216, 392, -176},
    { 968, 448, -208},
    { 936, 520, -288},
    { 688, 680, -240},
    { 336, 864, -192},
    { 352, 1048, -312},
    { 624, 1112, -376},
    { 480, 1008, -208},
    { 312, 816, -272},
    { 200, 760, -280},
    { 112, 808, -176},
    { 56, 840, -160},
    { 16, 928, -168},
    { -56, 992, -112},
    { -112, 1224, -72},
    { -136, 1496, -24},
    { -176, 1392, -32},
    { 8, 1384, 112},
    { 184, 1384, 40},
    { 232, 1376, -8},
    { 256, 1088, -112},
    { 240, 904, -184},
    { 208, 832, -144},
    { 168, 840, -160},
    { 112, 776, -176},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:11:23 local
AccelRawData *activity_sample_walk_100_pbl_25298_3(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25298_3
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 70
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -8, 48, -1056},
    { 16, 56, -992},
    { 32, 128, -976},
    { 32, 80, -1040},
    { 56, 72, -1056},
    { 56, 88, -1064},
    { 56, 80, -1040},
    { 96, 56, -1032},
    { 120, 72, -1024},
    { 120, 40, -1024},
    { 88, 104, -1048},
    { 72, 72, -1048},
    { 72, 64, -1040},
    { 80, 40, -1040},
    { 104, 32, -1024},
    { 224, -96, -1048},
    { 192, 32, -1048},
    { 80, 152, -1016},
    { 104, 64, -1032},
    { -8, 184, -920},
    { 248, -80, -960},
    { 112, 48, -1040},
    { 88, 48, -1032},
    { 80, 96, -880},
    { 56, 72, -1048},
    // 1 seconds
    { 104, 32, -1008},
    { 232, 128, -1056},
    { 80, 56, -1024},
    { 80, 64, -1016},
    { 136, 56, -1016},
    { 104, 80, -1032},
    { 72, 64, -1040},
    { 104, 88, -1056},
    { 88, 80, -1064},
    { 64, 80, -1048},
    { 88, 80, -1040},
    { 112, 64, -1024},
    { 48, 112, -1000},
    { 72, 72, -936},
    { 56, -96, -840},
    { 88, 32, -792},
    { 136, 80, -680},
    { 168, 80, -632},
    { 304, 128, -584},
    { 480, 160, -600},
    { 688, 160, -592},
    { 944, 272, -544},
    { 1224, 328, -616},
    { 1376, 448, -408},
    { 1552, 416, -304},
    // 2 seconds
    { 1776, 472, -256},
    { 1688, 552, -256},
    { 1392, 464, -280},
    { 1176, 400, -240},
    { 1064, 368, -288},
    { 976, 352, -312},
    { 928, 368, -352},
    { 968, 344, -344},
    { 1056, 376, -296},
    { 1080, 344, -216},
    { 1088, 320, -176},
    { 1072, 336, -136},
    { 904, 384, -176},
    { 888, 416, -216},
    { 880, 392, -168},
    { 1008, 408, -88},
    { 1288, 408, -32},
    { 1480, 336, 16},
    { 1440, 256, 8},
    { 1400, 224, -24},
    { 1368, 232, -48},
    { 1304, 240, -32},
    { 1280, 272, -64},
    { 1296, 192, -152},
    { 1296, 168, -232},
    // 3 seconds
    { 1136, 96, -320},
    { 1128, -96, -264},
    { 888, -72, -200},
    { 872, 16, -368},
    { 824, -16, -368},
    { 1088, -48, -384},
    { 1040, -8, -400},
    { 920, -16, -352},
    { 896, 48, -384},
    { 928, 104, -376},
    { 1024, 64, -376},
    { 1144, 96, -280},
    { 1360, 288, -208},
    { 1592, 432, -320},
    { 1456, 456, -264},
    { 1128, 384, -296},
    { 1360, 624, -336},
    { 1024, 536, -336},
    { 896, 488, -336},
    { 920, 448, -312},
    { 1200, 424, -256},
    { 1408, 328, -176},
    { 1320, 192, -80},
    { 1344, 168, -144},
    { 1400, 184, -176},
    // 4 seconds
    { 1288, 184, -160},
    { 1136, 136, -184},
    { 1088, 64, -224},
    { 1128, 48, -264},
    { 928, -88, -272},
    { 968, -240, -200},
    { 1088, -104, -168},
    { 1000, -16, -264},
    { 1120, 88, -248},
    { 1400, 128, -264},
    { 1256, 168, -144},
    { 1216, 224, -168},
    { 1160, 368, -184},
    { 1168, 312, -64},
    { 1208, 344, -88},
    { 1136, 416, -120},
    { 1224, 392, -128},
    { 1432, 544, -112},
    { 1072, 680, -248},
    { 1168, 608, -176},
    { 992, 616, -232},
    { 1168, 592, -264},
    { 1112, 512, -256},
    { 1304, 480, -192},
    { 1448, 368, -136},
    // 5 seconds
    { 1344, 200, -88},
    { 1336, 208, -56},
    { 1400, 200, -88},
    { 1360, 240, -72},
    { 1240, 192, -64},
    { 1224, 112, -64},
    { 1112, 192, -104},
    { 896, 72, -120},
    { 992, -80, -80},
    { 848, -64, -72},
    { 1144, 24, -192},
    { 1408, 40, -256},
    { 1520, 64, -312},
    { 1272, 120, -272},
    { 1048, 240, -344},
    { 992, 296, -240},
    { 1064, 320, -176},
    { 1248, 400, -136},
    { 1312, 472, -96},
    { 1592, 600, -104},
    { 1224, 776, 56},
    { 896, 648, -184},
    { 1136, 792, -104},
    { 1304, 696, -64},
    { 1264, 552, -144},
    // 6 seconds
    { 1416, 544, -112},
    { 1528, 408, -56},
    { 1424, 248, -104},
    { 1312, 240, 16},
    { 1392, 200, -72},
    { 1448, 240, -160},
    { 1304, 152, -144},
    { 1328, 184, -136},
    { 1144, 128, -208},
    { 720, -48, -56},
    { 552, -80, -104},
    { 912, -24, 96},
    { 928, 40, -80},
    { 1536, 176, -328},
    { 2272, -16, -616},
    { 1840, 128, -496},
    { 1056, 72, -256},
    { 1024, 216, -440},
    { 1112, 400, -480},
    { 1040, 440, -336},
    { 1016, 464, -192},
    { 1408, 592, -136},
    { 1272, 704, -152},
    { 1440, 784, -200},
    { 1144, 712, -248},
    // 7 seconds
    { 1384, 512, -232},
    { 1632, 408, -16},
    { 1696, 240, -32},
    { 1464, 184, 16},
    { 1296, 232, -48},
    { 1208, 248, -128},
    { 1168, 272, -88},
    { 1168, 216, -40},
    { 1256, 232, -80},
    { 1176, 168, -72},
    { 936, 88, -80},
    { 1008, 88, -168},
    { 936, 96, -152},
    { 1168, 112, -192},
    { 1528, 136, -264},
    { 1520, 200, -240},
    { 1304, 288, -216},
    { 1064, 304, -280},
    { 1072, 384, -272},
    { 1152, 368, -232},
    { 1272, 408, -192},
    { 1408, 456, -200},
    { 1640, 648, -72},
    { 1384, 704, -104},
    { 1208, 792, -48},
    // 8 seconds
    { 784, 680, -128},
    { 944, 568, -152},
    { 1168, 544, -168},
    { 1480, 456, -32},
    { 1472, 280, 16},
    { 1368, 224, -40},
    { 1304, 256, -64},
    { 1280, 240, -80},
    { 1240, 192, -96},
    { 1240, 160, -96},
    { 1408, 176, -160},
    { 1224, 120, -128},
    { 1592, 32, -112},
    { 1384, -152, -160},
    { 1016, -208, -168},
    { 1208, -32, -296},
    { 1104, 40, -392},
    { 1064, 120, -312},
    { 1160, 160, -344},
    { 1176, 280, 0},
    { 1248, 496, -48},
    { 1304, 616, 16},
    { 1392, 576, -8},
    { 1464, 576, -8},
    { 1224, 576, 80},
    // 9 seconds
    { 1280, 696, 248},
    { 864, 920, 144},
    { 1080, 592, -136},
    { 1160, 640, -120},
    { 1408, 560, -56},
    { 1336, 384, 32},
    { 1312, 240, -32},
    { 1288, 304, -56},
    { 1336, 312, -48},
    { 1368, 160, -48},
    { 1624, 192, -120},
    { 1416, 192, -128},
    { 1136, 0, -96},
    { 1168, -8, 40},
    { 840, -144, -80},
    { 1184, 80, -168},
    { 1464, 56, -224},
    { 1384, 128, -224},
    { 1104, 240, -256},
    { 920, 264, -256},
    { 928, 328, -184},
    { 1080, 368, -192},
    { 1224, 416, -160},
    { 1496, 512, -144},
    { 1520, 672, 0},
    // 10 seconds
    { 1056, 712, -256},
    { 1152, 912, -184},
    { 1120, 672, -200},
    { 1168, 560, -264},
    { 1360, 576, -144},
    { 1520, 472, -48},
    { 1360, 248, 24},
    { 1192, 176, 0},
    { 1240, 248, -88},
    { 1272, 280, -128},
    { 1152, 168, -88},
    { 1136, 144, -80},
    { 1136, 104, -160},
    { 856, 96, -264},
    { 1120, 80, -272},
    { 896, 56, -240},
    { 1080, 72, -264},
    { 1440, 128, -280},
    { 1536, 152, -296},
    { 1280, 264, -208},
    { 1000, 400, -208},
    { 920, 384, -168},
    { 1008, 424, -160},
    { 1176, 440, -152},
    { 1248, 480, -112},
    // 11 seconds
    { 1576, 568, 32},
    { 1208, 712, 128},
    { 1344, 792, 48},
    { 888, 736, -88},
    { 1080, 672, -64},
    { 1224, 584, -120},
    { 1472, 560, -136},
    { 1424, 464, -128},
    { 1312, 344, -48},
    { 1256, 240, -16},
    { 1288, 328, -56},
    { 1208, 176, -104},
    { 1064, 112, -112},
    { 1096, 152, -200},
    { 1016, 136, -232},
    { 792, -8, -248},
    { 1048, -40, -176},
    { 968, -64, -144},
    { 1232, 136, -216},
    { 1680, 144, -256},
    { 1744, 288, -272},
    { 1352, 328, -168},
    { 1048, 360, -192},
    { 952, 440, -120},
    { 1088, 384, -80},
    // 12 seconds
    { 1184, 432, -80},
    { 1192, 448, 0},
    { 1512, 544, 128},
    { 1232, 880, 392},
    { 920, 816, -184},
    { 1104, 704, -32},
    { 1208, 696, -112},
    { 1280, 632, -168},
    { 1488, 648, -112},
    { 1600, 448, -56},
    { 1600, 208, -64},
    { 1376, 176, 144},
    { 1336, 256, -96},
    { 1296, 184, -192},
    { 1168, 128, -120},
    { 1216, 168, -160},
    { 1112, 160, -240},
    { 792, 8, -208},
    { 1112, -8, -136},
    { 856, -32, -88},
    { 1152, 192, -192},
    { 1640, 200, -248},
    { 1760, 280, -432},
    { 1272, 272, -320},
    { 968, 216, -232},
    // 13 seconds
    { 1064, 328, -256},
    { 1288, 320, -336},
    { 1304, 360, -392},
    { 1656, 552, -248},
    { 1536, 728, -272},
    { 1320, 664, -344},
    { 1000, 792, -352},
    { 1144, 520, -320},
    { 1288, 488, -280},
    { 1600, 432, -72},
    { 1480, 176, -80},
    { 1208, 208, 24},
    { 1184, 240, -136},
    { 1168, 240, -120},
    { 1176, 232, -80},
    { 1168, 192, -80},
    { 1240, 192, -120},
    { 1160, 144, -144},
    { 896, 72, -128},
    { 1056, 80, -200},
    { 960, -8, -200},
    { 1200, 88, -256},
    { 1608, 120, -312},
    { 1504, 208, -336},
    { 1136, 264, -272},
    // 14 seconds
    { 896, 272, -312},
    { 888, 304, -248},
    { 1048, 352, -240},
    { 1112, 392, -192},
    { 1208, 416, -184},
    { 1720, 504, -104},
    { 1416, 608, -64},
    { 1384, 680, -144},
    { 928, 664, -216},
    { 976, 576, -232},
    { 1040, 488, -216},
    { 1304, 480, -144},
    { 1416, 296, -184},
    { 1264, 240, -8},
    { 1144, 168, -24},
    { 1128, 224, -168},
    { 1064, 184, -120},
    { 1016, 176, -56},
    { 1216, 216, -112},
    { 1200, 208, -168},
    { 1192, 136, -168},
    { 1288, 120, -72},
    { 1248, 80, -128},
    { 1176, 168, -248},
    { 1280, 192, -288},
    // 15 seconds
    { 1056, 208, -288},
    { 840, 256, -312},
    { 800, 288, -240},
    { 888, 320, -120},
    { 1088, 392, -104},
    { 1240, 472, -88},
    { 1400, 520, -96},
    { 1448, 664, -80},
    { 1008, 656, -104},
    { 1320, 720, -32},
    { 904, 720, -112},
    { 1280, 592, -152},
    { 1312, 560, -144},
    { 1368, 480, -88},
    { 1224, 320, -48},
    { 1088, 216, -32},
    { 1168, 240, -80},
    { 1320, 256, -120},
    { 1296, 208, -104},
    { 1352, 184, -184},
    { 1288, 176, -216},
    { 904, -24, -128},
    { 1064, -112, -120},
    { 840, 0, -128},
    { 1104, 136, -256},
    // 16 seconds
    { 1512, 216, -296},
    { 1520, 280, -312},
    { 1168, 280, -200},
    { 960, 304, -200},
    { 944, 368, -136},
    { 1112, 400, -136},
    { 1184, 464, -168},
    { 1440, 496, -104},
    { 1504, 624, -16},
    { 1024, 712, -104},
    { 1248, 696, -240},
    { 920, 768, -232},
    { 1184, 600, -216},
    { 1320, 544, -184},
    { 1512, 464, -104},
    { 1392, 248, -88},
    { 1224, 224, 16},
    { 1272, 272, -72},
    { 1320, 272, -120},
    { 1256, 216, -48},
    { 1408, 192, -80},
    { 1120, 120, -112},
    { 888, -16, -192},
    { 1120, 8, -24},
    { 920, -24, -112},
    // 17 seconds
    { 1248, 160, -184},
    { 1472, 120, -216},
    { 1312, 200, -272},
    { 1024, 208, -264},
    { 904, 232, -256},
    { 1040, 288, -208},
    { 1248, 320, -232},
    { 1224, 432, -280},
    { 1512, 560, -192},
    { 1520, 760, -208},
    { 1112, 544, -288},
    { 1272, 776, -264},
    { 1064, 616, -232},
    { 1232, 512, -248},
    { 1384, 472, -136},
    { 1488, 328, -88},
    { 1272, 240, 32},
    { 1128, 184, -24},
    { 1160, 256, -144},
    { 1144, 200, -112},
    { 1048, 176, -56},
    { 1104, 168, -32},
    { 1208, 192, -96},
    { 936, 120, -128},
    { 1304, 88, -152},
    // 18 seconds
    { 1016, 56, -96},
    { 1184, 136, -176},
    { 1400, 48, -168},
    { 1440, 360, -360},
    { 1120, 376, -280},
    { 888, 344, -264},
    { 864, 344, -208},
    { 936, 344, -184},
    { 1080, 344, -176},
    { 1168, 392, -144},
    { 1648, 528, -120},
    { 1288, 720, -8},
    { 1288, 640, -168},
    { 896, 632, -192},
    { 1096, 560, -216},
    { 1200, 472, -168},
    { 1408, 464, -64},
    { 1424, 312, -40},
    { 1192, 200, 8},
    { 1128, 224, -56},
    { 1176, 240, -112},
    { 1152, 224, -80},
    { 1080, 144, -104},
    { 1248, 160, -128},
    { 1104, 112, -168},
    // 19 seconds
    { 920, 48, -224},
    { 1088, 48, -152},
    { 848, 128, -48},
    { 1120, 192, -160},
    { 1584, 200, -304},
    { 1408, 248, -232},
    { 1024, 200, -184},
    { 880, 256, -240},
    { 920, 296, -176},
    { 1096, 312, -176},
    { 1112, 376, -184},
    { 1288, 456, -192},
    { 1584, 616, -104},
    { 1080, 704, -96},
    { 1312, 704, -208},
    { 888, 632, -280},
    { 1248, 536, -224},
    { 1496, 512, -112},
    { 1608, 480, -88},
    { 1424, 208, -8},
    { 1184, 64, 200},
    { 1144, 168, -32},
    { 1144, 248, -160},
    { 1048, 232, -88},
    { 1032, 104, 0},
    // 20 seconds
    { 1096, 128, -96},
    { 832, 72, -176},
    { 1104, 16, -128},
    { 928, -40, -104},
    { 1256, -8, -224},
    { 1576, 24, -280},
    { 1584, -8, -200},
    { 1224, 192, -176},
    { 928, 360, -288},
    { 928, 400, -192},
    { 1088, 432, -184},
    { 1152, 448, -128},
    { 1288, 448, -72},
    { 1568, 544, 96},
    { 1176, 656, 112},
    { 1312, 608, -96},
    { 944, 656, -136},
    { 1048, 592, -160},
    { 1160, 536, -160},
    { 1408, 512, -96},
    { 1280, 400, -176},
    { 1160, 288, -88},
    { 1104, 176, 48},
    { 1216, 248, -120},
    { 1304, 296, -112},
    // 21 seconds
    { 1144, 72, 72},
    { 1368, 184, -112},
    { 1120, 88, -208},
    { 1144, -24, -216},
    { 1024, -8, -152},
    { 1032, 0, -280},
    { 1240, 16, -304},
    { 1384, 80, -288},
    { 1064, 152, -224},
    { 776, 208, -224},
    { 784, 312, -192},
    { 936, 336, -152},
    { 1128, 352, -120},
    { 1136, 408, -152},
    { 1528, 456, -152},
    { 1320, 624, -80},
    { 1216, 624, -296},
    { 1024, 640, -320},
    { 1072, 552, -320},
    { 1136, 472, -240},
    { 1392, 456, -136},
    { 1376, 328, -88},
    { 1136, 216, -64},
    { 1048, 240, -120},
    { 1080, 248, -152},
    // 22 seconds
    { 1112, 200, -112},
    { 1064, 168, -136},
    { 1224, 176, -120},
    { 1192, 160, -160},
    { 1024, 152, -200},
    { 1232, 128, -264},
    { 976, 80, -184},
    { 1064, 120, -232},
    { 1272, 168, -328},
    { 1280, 248, -272},
    { 1032, 256, -288},
    { 848, 232, -240},
    { 864, 240, -160},
    { 984, 296, -160},
    { 1072, 344, -184},
    { 1104, 400, -248},
    { 1368, 472, -224},
    { 1464, 640, -128},
    { 1072, 504, -336},
    { 1312, 664, -256},
    { 904, 520, -264},
    { 1120, 472, -240},
    { 1320, 472, -160},
    { 1464, 352, -80},
    { 1280, 232, -8},
    // 23 seconds
    { 1168, 224, -32},
    { 1224, 264, -96},
    { 1224, 216, -72},
    { 1096, 184, -64},
    { 984, 120, -56},
    { 1088, 152, -128},
    { 944, 120, -168},
    { 1032, 40, -240},
    { 1272, 80, -128},
    { 1296, 40, -200},
    { 1360, 88, -240},
    { 1456, 120, -312},
    { 1208, 152, -232},
    { 1000, 176, -280},
    { 936, 216, -216},
    { 1040, 232, -168},
    { 1136, 328, -152},
    { 1104, 392, -152},
    { 1208, 384, -168},
    { 1512, 496, -144},
    { 1152, 552, -168},
    { 1184, 552, -208},
    { 960, 720, -256},
    { 1176, 560, -256},
    { 1352, 496, -248},
    // 24 seconds
    { 1432, 408, -128},
    { 1304, 264, -120},
    { 1176, 216, -16},
    { 1240, 240, -72},
    { 1360, 256, -136},
    { 1240, 152, -32},
    { 1160, 160, -72},
    { 1208, 152, -128},
    { 1032, 96, -120},
    { 936, 8, -200},
    { 1128, -24, -80},
    { 1048, -32, -144},
    { 1160, 104, -208},
    { 1488, 56, -264},
    { 1424, 136, -216},
    { 1128, 160, -232},
    { 936, 216, -232},
    { 984, 248, -232},
    { 1088, 328, -208},
    { 1112, 312, -200},
    { 1152, 360, -240},
    { 1584, 544, -224},
    { 1328, 664, -176},
    { 1224, 560, -312},
    { 1072, 616, -280},
    // 25 seconds
    { 1112, 520, -296},
    { 1112, 424, -264},
    { 1336, 424, -216},
    { 1384, 328, -104},
    { 1224, 168, -24},
    { 1200, 200, -88},
    { 1272, 232, -136},
    { 1232, 192, -56},
    { 1184, 200, -80},
    { 1264, 128, -72},
    { 1144, 136, -88},
    { 992, 48, -200},
    { 1280, 24, -88},
    { 976, -32, -160},
    { 1040, 80, -240},
    { 1336, 48, -272},
    { 1352, 144, -304},
    { 1120, 176, -256},
    { 960, 224, -280},
    { 960, 256, -224},
    { 1056, 296, -232},
    { 1112, 360, -240},
    { 1128, 392, -240},
    { 1512, 448, -216},
    { 1368, 544, -184},
    // 26 seconds
    { 1096, 480, -256},
    { 1120, 728, -288},
    { 1072, 576, -288},
    { 1144, 472, -256},
    { 1328, 448, -144},
    { 1312, 272, -40},
    { 1168, 216, -16},
    { 1176, 216, -104},
    { 1240, 240, -104},
    { 1264, 224, -64},
    { 1176, 168, -40},
    { 1256, 160, -72},
    { 1104, 128, -136},
    { 984, 48, -216},
    { 1296, 16, -208},
    { 1008, -120, -112},
    { 1160, 80, -288},
    { 1288, 72, -280},
    { 1232, 104, -280},
    { 1040, 136, -224},
    { 936, 208, -232},
    { 976, 272, -160},
    { 1136, 304, -184},
    { 1208, 368, -168},
    { 1296, 424, -200},
    // 27 seconds
    { 1600, 496, -176},
    { 1256, 544, -168},
    { 1152, 520, -288},
    { 1032, 752, -280},
    { 1176, 600, -344},
    { 1240, 504, -304},
    { 1360, 464, -184},
    { 1352, 264, -72},
    { 1208, 200, -24},
    { 1240, 184, -80},
    { 1312, 224, -104},
    { 1280, 176, -40},
    { 1208, 144, -32},
    { 1360, 168, -120},
    { 968, 88, -160},
    { 928, 64, -272},
    { 1184, -8, -96},
    { 992, -48, -192},
    { 1168, 56, -256},
    { 1400, 48, -304},
    { 1224, 112, -224},
    { 976, 168, -216},
    { 936, 224, -216},
    { 1064, 248, -208},
    { 1200, 336, -216},
    // 28 seconds
    { 1144, 320, -192},
    { 1408, 408, -216},
    { 1568, 600, -136},
    { 1152, 576, -248},
    { 1472, 728, -168},
    { 1024, 624, -280},
    { 1040, 520, -264},
    { 1176, 496, -192},
    { 1280, 392, -160},
    { 1152, 304, -88},
    { 1112, 192, -40},
    { 1184, 216, -88},
    { 1232, 232, -88},
    { 1216, 184, -88},
    { 1216, 176, -56},
    { 1408, 208, -136},
    { 1040, 104, -104},
    { 1200, 88, -192},
    { 984, 40, -104},
    { 1024, 64, -152},
    { 1176, 56, -192},
    { 1360, 80, -264},
    { 1120, 192, -224},
    { 864, 192, -240},
    { 832, 264, -304},
    // 29 seconds
    { 920, 272, -264},
    { 1024, 312, -320},
    { 1040, 408, -352},
    { 1296, 424, -224},
    { 1648, 528, -144},
    { 1152, 456, -144},
    { 1568, 448, -280},
    { 880, 472, -296},
    { 1296, 440, -256},
    { 1376, 384, -208},
    { 1456, 264, -112},
    { 1200, 88, 96},
    { 944, 32, -56},
    { 976, 224, -184},
    { 1056, 224, -136},
    { 984, 136, -48},
    { 1064, 136, -56},
    { 1328, 168, -120},
    { 992, 104, -152},
    { 1120, 80, -136},
    { 1080, 16, -136},
    { 1056, 56, -160},
    { 1304, 72, -240},
    { 1392, 160, -288},
    { 1104, 136, -144},
    // 30 seconds
    { 848, 176, -224},
    { 832, 232, -224},
    { 920, 256, -216},
    { 1008, 312, -232},
    { 1032, 368, -248},
    { 1528, 424, -216},
    { 1488, 512, -248},
    { 1120, 512, -224},
    { 1304, 696, -352},
    { 1160, 544, -288},
    { 1184, 400, -224},
    { 1408, 408, -136},
    { 1416, 232, -24},
    { 1160, 184, -40},
    { 1072, 176, -104},
    { 1112, 176, -96},
    { 1128, 168, -104},
    { 1056, 176, -40},
    { 1184, 184, -96},
    { 1112, 272, -168},
    { 840, 144, -160},
    { 1152, 64, -144},
    { 864, 56, -192},
    { 1216, 56, -224},
    { 1512, 80, -312},
    // 31 seconds
    { 1264, 192, -136},
    { 968, 176, -168},
    { 832, 216, -232},
    { 928, 280, -192},
    { 1056, 264, -176},
    { 1200, 304, -200},
    { 1584, 392, -208},
    { 1624, 592, -168},
    { 1088, 536, -312},
    { 1512, 608, -376},
    { 1024, 616, -328},
    { 1136, 440, -224},
    { 1328, 400, -144},
    { 1272, 288, -72},
    { 1040, 192, -64},
    { 968, 200, -112},
    { 1056, 192, -120},
    { 1176, 176, -40},
    { 1192, 200, -40},
    { 1432, 216, -88},
    { 1224, 200, -128},
    { 936, 272, -216},
    { 1280, 280, -208},
    { 800, 256, -176},
    { 1024, 304, -288},
    // 32 seconds
    { 1264, 280, -336},
    { 1016, 224, -256},
    { 704, 136, -176},
    { 648, 144, -144},
    { 800, 216, -128},
    { 1008, 264, -112},
    { 1120, 352, -184},
    { 1456, 360, -240},
    { 1792, 464, -264},
    { 1168, 560, -288},
    { 1800, 528, -512},
    { 984, 536, -352},
    { 1040, 480, -288},
    { 1176, 488, -240},
    { 1256, 376, -136},
    { 1040, 264, -8},
    { 928, 192, -72},
    { 1016, 208, -120},
    { 1136, 240, -72},
    { 1192, 232, -64},
    { 1280, 184, -48},
    { 1408, 176, -88},
    { 1056, 176, -176},
    { 1272, 128, -232},
    { 992, 176, -192},
    // 33 seconds
    { 904, 128, -184},
    { 1088, 104, -272},
    { 1208, 224, -320},
    { 992, 216, -176},
    { 816, 160, -160},
    { 808, 224, -128},
    { 920, 296, -192},
    { 1016, 344, -272},
    { 1136, 384, -288},
    { 1616, 408, -264},
    { 1472, 544, -184},
    { 1376, 440, -336},
    { 1112, 584, -432},
    { 1120, 464, -320},
    { 1128, 360, -208},
    { 1352, 336, -160},
    { 1232, 232, -88},
    { 984, 208, -24},
    { 976, 240, -96},
    { 1104, 240, -112},
    { 1160, 200, -72},
    { 1144, 200, -80},
    { 1360, 208, -112},
    { 1016, 176, -184},
    { 1072, 120, -256},
    // 34 seconds
    { 976, 160, -120},
    { 1008, 112, -72},
    { 1264, 160, -160},
    { 1416, 280, -264},
    { 1088, 328, -224},
    { 816, 256, -232},
    { 784, 224, -160},
    { 912, 224, -72},
    { 1192, 272, -64},
    { 1304, 360, -136},
    { 1568, 472, -224},
    { 1296, 616, -200},
    { 1216, 624, -304},
    { 1000, 544, -400},
    { 1264, 496, -336},
    { 1264, 488, -232},
    { 1416, 424, -168},
    { 1232, 248, -32},
    { 1088, 144, 40},
    { 1128, 192, -72},
    { 1192, 208, -8},
    { 1184, 208, 8},
    { 1176, 184, 8},
    { 1352, 168, -8},
    { 968, 184, -72},
    // 35 seconds
    { 1040, 208, -208},
    { 1032, 168, -216},
    { 976, 168, -200},
    { 1144, 152, -240},
    { 1416, 232, -336},
    { 1072, 264, -208},
    { 696, 216, -112},
    { 712, 272, -192},
    { 912, 352, -104},
    { 1232, 336, -136},
    { 1248, 432, -64},
    { 1736, 456, -72},
    { 1488, 680, -32},
    { 1080, 640, -208},
    { 1056, 632, -200},
    { 960, 696, -208},
    { 1048, 616, -240},
    { 1240, 576, -176},
    { 1296, 504, -104},
    { 1144, 376, 8},
    { 1096, 240, 8},
    { 1168, 232, -16},
    { 1272, 272, 0},
    { 1184, 240, 8},
    { 1272, 160, -40},
    // 36 seconds
    { 1248, 176, -88},
    { 1080, 160, -160},
    { 1200, 168, -128},
    { 888, 120, -160},
    { 904, 184, -224},
    { 1128, 208, -296},
    { 1184, 232, -280},
    { 952, 232, -232},
    { 816, 232, -224},
    { 872, 280, -192},
    { 1008, 304, -152},
    { 1128, 328, -176},
    { 1248, 376, -216},
    { 1712, 520, -184},
    { 1368, 624, -192},
    { 1016, 456, -264},
    { 1288, 768, -192},
    { 960, 752, -240},
    { 1072, 504, -248},
    { 1232, 552, -176},
    { 1400, 512, -80},
    { 1200, 264, 80},
    { 1152, 160, 0},
    { 1224, 200, -16},
    { 1312, 280, -24},
    // 37 seconds
    { 1176, 200, -40},
    { 1240, 192, -32},
    { 1160, 208, -112},
    { 984, 192, -240},
    { 1216, 96, -136},
    { 1040, 32, -96},
    { 1080, 120, -216},
    { 1336, 144, -400},
    { 1136, 176, -272},
    { 776, 144, -200},
    { 696, 144, -200},
    { 904, 296, -176},
    { 1128, 288, -208},
    { 1240, 232, -208},
    { 1512, 424, -192},
    { 1648, 752, -32},
    { 1168, 680, -256},
    { 1432, 840, -152},
    { 960, 776, -192},
    { 1040, 576, -160},
    { 1104, 544, -176},
    { 1320, 504, -200},
    { 1296, 360, -64},
    { 1176, 248, 16},
    { 1224, 256, -48},
    // 38 seconds
    { 1296, 256, -32},
    { 1272, 264, -32},
    { 1256, 152, -48},
    { 1280, 176, -64},
    { 992, 144, -160},
    { 1008, 72, -232},
    { 904, 32, -120},
    { 936, 40, -208},
    { 1152, 80, -280},
    { 1392, 168, -352},
    { 1184, 208, -296},
    { 896, 256, -168},
    { 872, 288, -224},
    { 1000, 320, -144},
    { 1288, 368, -160},
    { 1200, 432, -152},
    { 1528, 496, -136},
    { 1376, 712, 104},
    { 1088, 680, -232},
    { 1088, 728, -184},
    { 1152, 648, -168},
    { 1136, 568, -184},
    { 1192, 544, -128},
    { 1280, 480, -144},
    { 1144, 344, -32},
    // 39 seconds
    { 1088, 216, 56},
    { 1168, 216, -32},
    { 1248, 256, -48},
    { 1192, 176, -64},
    { 1328, 160, -80},
    { 1272, 208, -64},
    { 968, 192, -144},
    { 1208, 200, -232},
    { 904, 144, -232},
    { 896, 136, -320},
    { 1080, 144, -336},
    { 1224, 160, -336},
    { 1024, 208, -296},
    { 864, 216, -280},
    { 928, 256, -248},
    { 1032, 288, -232},
    { 1120, 320, -232},
    { 1104, 344, -232},
    { 1448, 416, -176},
    { 1424, 512, -176},
    { 1176, 504, -224},
    { 1288, 808, -288},
    { 952, 648, -288},
    { 968, 432, -256},
    { 1152, 480, -192},
    // 40 seconds
    { 1408, 440, -112},
    { 1232, 224, 8},
    { 1120, 136, -8},
    { 1160, 208, -96},
    { 1184, 256, -96},
    { 1136, 160, -88},
    { 1136, 144, -64},
    { 1304, 208, -152},
    { 1072, 160, -280},
    { 1216, 88, -224},
    { 944, 0, -208},
    { 960, 32, -200},
    { 1176, 96, -336},
    { 1408, 160, -352},
    { 1168, 216, -272},
    { 904, 232, -288},
    { 880, 256, -240},
    { 960, 312, -240},
    { 1016, 312, -192},
    { 1040, 344, -160},
    { 1280, 416, -128},
    { 1552, 536, -64},
    { 1120, 560, -80},
    { 1392, 728, -128},
    { 888, 720, -168},
    // 41 seconds
    { 1024, 520, -224},
    { 1096, 520, -216},
    { 1288, 576, -224},
    { 1368, 464, -208},
    { 1240, 232, 160},
    { 1184, 0, 72},
    { 1280, 200, -64},
    { 1264, 200, -144},
    { 1160, 160, -112},
    { 1192, 176, -176},
    { 1224, 136, -280},
    { 1016, -56, -264},
    { 1160, -168, -32},
    { 1128, -112, -120},
    { 1192, 16, -248},
    { 1536, 96, -272},
    { 1464, 176, -296},
    { 1128, 312, -224},
    { 960, 344, -184},
    { 976, 368, -104},
    { 1008, 416, -88},
    { 1136, 440, -80},
    { 1272, 472, -48},
    { 1560, 520, 0},
    { 1208, 656, 0},
    // 42 seconds
    { 1216, 760, 48},
    { 752, 632, -64},
    { 960, 560, -112},
    { 1144, 552, -160},
    { 1440, 536, -112},
    { 1536, 472, -120},
    { 1448, 360, -96},
    { 1416, 136, 88},
    { 1376, 288, -32},
    { 1312, 184, -136},
    { 1152, 72, -136},
    { 1080, 136, -160},
    { 1032, 128, -208},
    { 880, 88, -224},
    { 1072, 64, -200},
    { 992, 48, -112},
    { 1200, 112, -168},
    { 1432, 152, -192},
    { 1632, 288, -128},
    { 1320, 360, -184},
    { 1072, 416, -264},
    { 992, 424, -144},
    { 1096, 376, -104},
    { 1152, 416, -72},
    { 1160, 392, -40},
    // 43 seconds
    { 1408, 440, 0},
    { 1448, 608, 72},
    { 1128, 680, 48},
    { 1072, 792, 48},
    { 856, 600, 0},
    { 944, 576, -96},
    { 1168, 584, -16},
    { 1384, 480, 8},
    { 1304, 272, 0},
    { 1264, 200, 0},
    { 1352, 208, 8},
    { 1352, 240, -32},
    { 1232, 224, -48},
    { 1168, 152, -48},
    { 1168, 136, -104},
    { 976, 128, -184},
    { 1208, 112, -184},
    { 960, 88, -176},
    { 1040, 144, -176},
    { 1208, 168, -264},
    { 1328, 248, -248},
    { 1136, 272, -200},
    { 816, 424, -272},
    { 960, 328, -112},
    { 1056, 328, -72},
    // 44 seconds
    { 1136, 408, -88},
    { 1152, 400, -56},
    { 1512, 496, 24},
    { 1264, 648, 96},
    { 1096, 576, -48},
    { 1016, 640, -48},
    { 1048, 536, -56},
    { 984, 432, -136},
    { 1112, 456, -64},
    { 1168, 344, -96},
    { 1032, 208, -56},
    { 968, 144, -8},
    { 1104, 152, -88},
    { 1216, 152, -48},
    { 1208, 152, -72},
    { 1512, 144, -96},
    { 1344, 184, -120},
    { 1080, 120, -200},
    { 1392, 136, -224},
    { 912, 0, -104},
    { 1072, 128, -224},
    { 1280, 160, -280},
    { 1112, 192, -280},
    { 864, 192, -232},
    { 760, 200, -160},
    // 45 seconds
    { 840, 264, -104},
    { 992, 296, -120},
    { 1104, 336, -112},
    { 1336, 480, -80},
    { 1464, 616, -24},
    { 1112, 528, -160},
    { 1440, 664, -88},
    { 944, 656, -72},
    { 1104, 464, -128},
    { 1168, 416, -48},
    { 1288, 336, -24},
    { 1080, 104, 0},
    { 1000, 184, -96},
    { 1032, 192, -96},
    { 1080, 168, -40},
    { 1112, 216, -40},
    { 1312, 184, -64},
    { 1520, 256, -112},
    { 1200, 176, -128},
    { 1392, 72, -216},
    { 944, 8, -72},
    { 1024, 112, -200},
    { 1192, 232, -296},
    { 1280, 272, -288},
    { 1072, 280, -240},
    // 46 seconds
    { 872, 240, -208},
    { 824, 304, -144},
    { 872, 360, -104},
    { 952, 360, -104},
    { 1128, 424, -96},
    { 1496, 480, -88},
    { 1176, 520, -80},
    { 1416, 632, -88},
    { 1104, 664, -136},
    { 1136, 408, -224},
    { 1120, 392, -168},
    { 1232, 440, -208},
    { 1040, 192, -120},
    { 896, 112, 0},
    { 952, 96, -96},
    { 1072, 176, -120},
    { 1176, 240, -64},
    { 1272, 136, -64},
    { 1392, 176, -112},
    { 1104, 184, -184},
    { 1264, 120, -152},
    { 1032, 24, -56},
    { 1248, 80, -168},
    { 1464, 128, -256},
    { 1304, 144, -264},
    // 47 seconds
    { 984, 216, -352},
    { 784, 256, -264},
    { 808, 296, -200},
    { 960, 352, -168},
    { 1064, 424, -120},
    { 1200, 528, 0},
    { 1504, 512, -96},
    { 1184, 432, -40},
    { 1280, 488, -16},
    { 1112, 496, -72},
    { 1024, 528, -160},
    { 992, 440, -224},
    { 1168, 384, -160},
    { 1216, 224, -152},
    { 1008, 192, -160},
    { 976, 216, -176},
    { 1016, 200, -88},
    { 1008, 184, -72},
    { 1000, 152, -104},
    { 1240, 184, -88},
    { 1272, 168, -168},
    { 1120, 136, -240},
    { 1456, 112, -88},
    { 1168, 72, -56},
    { 1264, 136, -232},
    // 48 seconds
    { 1408, 184, -344},
    { 1112, 168, -360},
    { 776, 144, -352},
    { 728, 208, -296},
    { 776, 288, -240},
    { 1000, 320, -288},
    { 1096, 296, -160},
    { 1360, 304, -64},
    { 1680, 488, -72},
    { 1144, 576, -40},
    { 1384, 712, -16},
    { 760, 664, -328},
    { 1048, 456, -216},
    { 1064, 560, -144},
    { 1384, 512, -80},
    { 1328, 376, -40},
    { 1184, 240, 0},
    { 1216, 200, -40},
    { 1304, 176, -32},
    { 1360, 200, -56},
    { 1272, 160, -72},
    { 1320, 160, -136},
    { 1096, 104, -160},
    { 1144, 24, -176},
    { 1088, 64, -200},
    // 49 seconds
    { 1056, 72, -272},
    { 1128, 88, -304},
    { 1232, 96, -288},
    { 1056, 168, -184},
    { 896, 152, -216},
    { 912, 280, -184},
    { 1032, 320, -88},
    { 1280, 344, -24},
    { 1376, 416, -72},
    { 1640, 544, -32},
    { 1448, 840, -24},
    { 1144, 600, -216},
    { 1112, 704, -112},
    { 1024, 720, -104},
    { 984, 584, -208},
    { 1120, 520, -136},
    { 1288, 496, -104},
    { 1168, 280, 32},
    { 1128, 216, -8},
    { 1224, 200, -48},
    { 1304, 240, -24},
    { 1304, 200, 0},
    { 1352, 192, -24},
    { 1384, 192, -152},
    { 1072, 112, -200},
    // 50 seconds
    { 1296, -24, -184},
    { 816, -144, 0},
    { 1032, -24, -176},
    { 1248, 80, -224},
    { 1408, 168, -288},
    { 1200, 232, -256},
    { 1064, 216, -336},
    { 1072, 320, -168},
    { 1216, 368, -168},
    { 1304, 512, -192},
    { 1272, 568, -192},
    { 1544, 664, -160},
    { 1112, 560, -112},
    { 1192, 680, -112},
    { 968, 696, -120},
    { 1080, 536, -176},
    { 1208, 504, -176},
    { 1488, 440, -128},
    { 1424, 352, 56},
    { 1288, 192, 48},
    { 1280, 216, -24},
    { 1280, 200, -16},
    { 1192, 192, -8},
    { 1104, 184, -24},
    { 1168, 184, -64},
    // 51 seconds
    { 1080, 160, -152},
    { 976, 144, -240},
    { 1136, 88, -296},
    { 968, 40, -200},
    { 1056, 40, -192},
    { 1360, 176, -304},
    { 1520, 344, -440},
    { 1224, 264, -176},
    { 1024, 224, -192},
    { 1024, 296, -216},
    { 1152, 320, -184},
    { 1256, 400, -168},
    { 1152, 400, -152},
    { 1408, 520, -64},
    { 1232, 648, -24},
    { 1064, 616, -144},
    { 976, 704, -136},
    { 984, 560, -128},
    { 1104, 424, -184},
    { 1272, 504, -144},
    { 1344, 360, -24},
    { 1224, 208, -24},
    { 1216, 72, -56},
    { 1240, 144, -40},
    { 1256, 208, -56},
    // 52 seconds
    { 1200, 160, -96},
    { 1232, 168, -112},
    { 1152, 128, -136},
    { 1064, 136, -200},
    { 1224, 48, -32},
    { 1080, 32, -144},
    { 1112, 56, -248},
    { 1384, 144, -272},
    { 1304, 240, -248},
    { 1000, 144, -248},
    { 888, 256, -216},
    { 928, 344, -216},
    { 1040, 320, -144},
    { 1120, 376, -120},
    { 1192, 392, -136},
    { 1432, 504, -152},
    { 1176, 592, -152},
    { 1064, 552, -200},
    { 1080, 688, -192},
    { 1128, 704, -232},
    { 1088, 584, -208},
    { 1224, 456, -8},
    { 1392, 256, 80},
    { 1344, 200, 64},
    { 1280, 224, 8},
    // 53 seconds
    { 1272, 176, 72},
    { 1272, 192, 88},
    { 1248, 256, 48},
    { 1312, 232, -64},
    { 1256, 160, -208},
    { 1104, 56, -376},
    { 1128, -144, -248},
    { 952, -264, -32},
    { 1184, 16, -296},
    { 1384, 72, -344},
    { 1480, 120, -248},
    { 1416, 208, -56},
    { 1312, 304, 0},
    { 1320, 488, -24},
    { 1328, 488, 16},
    { 1200, 512, 120},
    { 1096, 432, 8},
    { 1304, 280, 56},
    { 1288, 616, 120},
    { 992, 464, -40},
    { 1120, 608, 48},
    { 976, 648, -48},
    { 952, 520, -104},
    { 1008, 520, -104},
    { 1248, 424, -128},
    // 54 seconds
    { 1256, 368, -72},
    { 1240, 288, -72},
    { 1336, 160, -136},
    { 1384, 216, -56},
    { 1344, 272, -24},
    { 1224, 232, -80},
    { 1232, 200, -136},
    { 1152, 152, -112},
    { 928, 144, -200},
    { 1200, 104, -200},
    { 912, 40, -144},
    { 1072, 72, -200},
    { 1304, 96, -240},
    { 1376, 200, -256},
    { 1128, 272, -184},
    { 912, 232, -152},
    { 936, 304, -176},
    { 1072, 296, -96},
    { 1184, 352, -64},
    { 1136, 384, -72},
    { 1240, 472, -72},
    { 1160, 552, 56},
    { 944, 440, -176},
    { 1248, 584, -48},
    { 1104, 640, -144},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:12:33 local
AccelRawData *activity_sample_walk_100_pbl_25298_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25298_4
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -304, 992, 56},
    { -288, 976, 16},
    { -304, 992, 40},
    { -304, 968, 8},
    { -312, 992, 8},
    { -288, 1000, 16},
    { -264, 960, 24},
    { -304, 984, 24},
    { -264, 904, -16},
    { -280, 960, -88},
    { -264, 960, -256},
    { -232, 968, -216},
    { -192, 1168, -128},
    { -168, 1064, -184},
    { -168, 1144, -288},
    { -192, 1040, -360},
    { -200, 976, -504},
    { -256, 800, -552},
    { -192, 696, -672},
    { -152, 672, -736},
    { -144, 560, -848},
    { -144, 440, -920},
    { -120, 424, -944},
    { -104, 376, -928},
    { -96, 312, -1000},
    // 1 seconds
    { 0, 272, -1040},
    { 16, 232, -1032},
    { -40, 152, -984},
    { -56, 152, -992},
    { 0, 256, -1000},
    { 24, 128, -1040},
    { 64, 200, -1088},
    { 64, -40, -1056},
    { 48, -16, -1056},
    { 72, 16, -1080},
    { 16, 16, -1040},
    { 8, 24, -1032},
    { 16, 8, -1016},
    { 0, -32, -1016},
    { -16, -16, -1056},
    { -16, -32, -1080},
    { -24, -8, -1040},
    { -40, -48, -1080},
    { -88, 72, -1072},
    { -56, 80, -952},
    { -96, -64, -984},
    { -112, -120, -904},
    { -80, -168, -1008},
    { -120, -96, -1032},
    { -80, -56, -1048},
    // 2 seconds
    { -88, -40, -1040},
    { -96, -24, -1024},
    { -72, -16, -1008},
    { -64, -24, -984},
    { -48, -24, -992},
    { -88, -40, -1008},
    { -72, -40, -1096},
    { -104, -64, -1064},
    { -128, -88, -992},
    { -152, -96, -944},
    { -128, -72, -936},
    { -80, -88, -904},
    { -72, -48, -880},
    { -120, 152, -880},
    { -72, 304, -896},
    { -40, 360, -888},
    { -64, 432, -896},
    { -56, 496, -912},
    { -104, 440, -928},
    { -112, 384, -936},
    { -96, 336, -888},
    { -40, 464, -896},
    { 0, 424, -776},
    { 184, 304, -600},
    { 648, 584, -560},
    // 3 seconds
    { 1080, 440, -512},
    { 1384, 440, -424},
    { 1496, 464, -216},
    { 1488, 488, -40},
    { 1328, 472, -136},
    { 1096, 456, -272},
    { 1000, 328, -232},
    { 976, 224, -200},
    { 1008, 240, -168},
    { 1040, 272, -224},
    { 1072, 272, -296},
    { 1096, 264, -384},
    { 1216, 312, -312},
    { 1384, 432, -304},
    { 1136, 528, -280},
    { 1072, 656, -424},
    { 784, 720, -360},
    { 1016, 608, -208},
    { 1288, 376, 80},
    { 1600, 160, 96},
    { 1592, 88, -24},
    { 1424, 16, -72},
    { 1360, 88, -80},
    { 1384, 208, -80},
    { 1368, 256, -64},
    // 4 seconds
    { 1240, 232, -80},
    { 1184, 128, -200},
    { 1056, 112, -408},
    { 912, -104, -520},
    { 920, -240, -200},
    { 616, -96, -200},
    { 728, -8, -344},
    { 936, 0, -240},
    { 1264, 32, -176},
    { 1408, 176, -184},
    { 1232, 288, -144},
    { 1136, 344, -176},
    { 1176, 304, -120},
    { 1296, 296, -112},
    { 1304, 344, -136},
    { 1624, 440, -176},
    { 1560, 600, -232},
    { 1152, 752, -256},
    { 1240, 1032, -512},
    { 816, 304, -336},
    { 856, 344, -296},
    { 1048, 576, -272},
    { 1360, 584, -144},
    { 1544, 272, -24},
    { 1384, 104, 48},
    // 5 seconds
    { 1432, 80, -24},
    { 1472, 160, -32},
    { 1360, 200, -24},
    { 1160, 232, -32},
    { 1216, 232, -88},
    { 1128, 360, -240},
    { 928, 136, -216},
    { 920, -128, -72},
    { 648, -104, -120},
    { 864, 96, -360},
    { 1008, -16, -272},
    { 1152, 48, -192},
    { 1096, 72, -152},
    { 1096, 208, -216},
    { 1120, 272, -200},
    { 1224, 184, -104},
    { 1368, 248, -48},
    { 1520, 344, -16},
    { 2008, 448, -56},
    { 1480, 632, -248},
    { 1048, 792, -304},
    { 1096, 768, -504},
    { 1000, 480, -344},
    { 1000, 520, -328},
    { 1168, 656, -296},
    // 6 seconds
    { 1424, 712, -136},
    { 1592, 552, 8},
    { 1768, 432, 88},
    { 1808, 664, 104},
    { 1568, 888, 80},
    { 1336, 816, 112},
    { 1216, 856, 96},
    { 1008, 768, 40},
    { 848, 560, -96},
    { 728, 296, -328},
    { 480, 320, -664},
    { 496, 464, -768},
    { 544, 512, -768},
    { 440, 584, -728},
    { 248, 504, -688},
    { 56, 528, -488},
    { -104, 632, -264},
    { -240, 872, -376},
    { -352, 984, -264},
    { -424, 952, -264},
    { -640, 1216, -384},
    { -608, 1424, -488},
    { -600, 1400, -512},
    { -544, 1848, -712},
    { -256, 1472, -544},
    // 7 seconds
    { -48, 960, -264},
    { -24, 896, -504},
    { 264, 576, -656},
    { 192, 160, -696},
    { 64, -200, -592},
    { -32, -640, -544},
    { 32, -176, -320},
    { 464, 384, -200},
    { 976, 632, 128},
    { 1496, 904, 344},
    { 1480, 976, 0},
    { 1808, 584, -600},
    { 1624, 168, -288},
    { 1536, 312, -176},
    { 1456, 640, -216},
    { 1168, 376, 128},
    { 1272, 32, 88},
    { 1280, 48, -88},
    { 1312, 352, -240},
    { 1264, 680, -376},
    { 1128, 808, -424},
    { 984, 968, -344},
    { 1368, 832, -424},
    { 1272, 296, -120},
    { 1216, 328, -168},
    // 8 seconds
    { 1144, 624, -288},
    { 1200, 456, -144},
    { 1552, 296, 8},
    { 1912, 296, 56},
    { 1664, 336, 0},
    { 1424, 312, 80},
    { 1312, 296, 72},
    { 1272, 304, 104},
    { 1224, 288, 152},
    { 1112, 232, 120},
    { 1120, 216, 40},
    { 1056, 208, -48},
    { 880, 168, -240},
    { 952, 160, -384},
    { 752, 48, -184},
    { 968, 40, -296},
    { 1288, 32, -392},
    { 1584, 128, -336},
    { 1544, 184, -296},
    { 1464, 256, -312},
    { 1520, 352, -392},
    { 1352, 400, -304},
    { 1264, 512, -240},
    { 1384, 352, -24},
    { 1640, 600, 88},
    // 9 seconds
    { 1136, 744, 64},
    { 928, 784, 80},
    { 904, 1112, -56},
    { 1112, 760, -24},
    { 1280, 536, 152},
    { 1680, 672, 200},
    { 1944, 464, 224},
    { 1840, 160, 200},
    { 1672, 96, 144},
    { 1584, 184, 72},
    { 1560, 312, 48},
    { 1320, 288, 80},
    { 1320, 232, -48},
    { 952, 192, -104},
    { 760, -40, -96},
    { 792, -104, 72},
    { 640, -16, -72},
    { 1024, 232, -288},
    { 1168, 208, -200},
    { 1488, 208, -200},
    { 1728, 264, -280},
    { 1840, 360, -368},
    { 1688, 576, -384},
    { 1472, 728, -520},
    { 1240, 128, -272},
    // 10 seconds
    { 1200, 272, 24},
    { 1504, 568, -16},
    { 976, 688, -104},
    { 1264, 856, -192},
    { 1040, 1112, -320},
    { 1288, 656, -88},
    { 1408, 480, 160},
    { 1816, 344, 144},
    { 1560, 128, 112},
    { 1424, 128, 56},
    { 1440, 200, 56},
    { 1640, 312, 48},
    { 1608, 352, 136},
    { 1568, 288, 64},
    { 1176, 288, -72},
    { 1000, -272, 32},
    { 808, -296, 128},
    { 776, 80, -32},
    { 1064, 272, -224},
    { 1144, 216, -200},
    { 1272, 216, -264},
    { 1296, 240, -256},
    { 1280, 240, -208},
    { 1368, 272, -264},
    { 1544, 288, -472},
    // 11 seconds
    { 1408, 336, -512},
    { 1712, 712, -248},
    { 1656, 568, -224},
    { 1048, 600, -208},
    { 1136, 832, -336},
    { 912, 560, -264},
    { 1216, 504, -120},
    { 1520, 496, 32},
    { 1680, 368, 32},
    { 1368, 240, 0},
    { 1224, 192, 56},
    { 1264, 208, 40},
    { 1344, 256, 16},
    { 1256, 280, 80},
    { 1216, 216, 48},
    { 1160, 192, 0},
    { 832, 120, -104},
    { 1024, 8, -136},
    { 888, 64, -200},
    { 984, 168, -216},
    { 1176, 152, -192},
    { 1488, 232, -288},
    { 1280, 304, -256},
    { 1096, 288, -144},
    { 1200, 288, -136},
    // 12 seconds
    { 1320, 320, -56},
    { 1488, 400, -88},
    { 1488, 496, -120},
    { 1664, 704, -184},
    { 1176, 880, -280},
    { 1424, 928, -296},
    { 824, 696, -256},
    { 1264, 488, -160},
    { 1304, 480, -8},
    { 1736, 424, 0},
    { 1624, 200, -40},
    { 1448, 56, 48},
    { 1360, 192, -8},
    { 1384, 200, 8},
    { 1304, 304, 16},
    { 1144, 240, 8},
    { 1160, 144, -56},
    { 840, -96, 0},
    { 648, -168, -48},
    { 1048, 112, 16},
    { 1016, 272, -24},
    { 1400, 256, -88},
    { 1864, 312, -120},
    { 1696, 480, -200},
    { 1184, 384, -168},
    // 13 seconds
    { 1080, 264, -112},
    { 1248, 200, -8},
    { 1472, 304, -48},
    { 1416, 472, -32},
    { 1544, 720, -80},
    { 1072, 1000, 80},
    { 1008, 1016, -280},
    { 1008, 560, -216},
    { 1304, 536, -136},
    { 1456, 536, -40},
    { 1760, 552, 16},
    { 1760, 328, 0},
    { 1512, 152, 96},
    { 1392, 40, 184},
    { 1368, 248, -32},
    { 1184, 208, 48},
    { 1200, 296, 72},
    { 1296, 256, 80},
    { 896, 200, -8},
    { 1176, 80, 8},
    { 896, -72, 24},
    { 984, 176, -288},
    { 976, 176, -224},
    { 1280, 136, -144},
    { 1280, 224, -280},
    // 14 seconds
    { 1120, 248, -232},
    { 1160, 344, -200},
    { 1312, 376, -176},
    { 1408, 400, -80},
    { 1528, 456, -64},
    { 1608, 632, -88},
    { 1304, 896, -264},
    { 944, 752, -88},
    { 1016, 904, -120},
    { 1040, 568, -56},
    { 1320, 432, -24},
    { 1600, 544, 32},
    { 1632, 512, 48},
    { 1520, 336, 48},
    { 1408, 208, 96},
    { 1352, 208, -16},
    { 1256, 224, -120},
    { 1120, 184, -56},
    { 1160, 144, -112},
    { 992, 112, -232},
    { 728, -48, -176},
    { 1040, -16, -96},
    { 1048, 128, -72},
    { 1376, 256, -128},
    { 1656, 280, -96},
    // 15 seconds
    { 1592, 344, -112},
    { 1152, 304, -160},
    { 1008, 288, -120},
    { 1152, 312, 16},
    { 1304, 376, 16},
    { 1272, 456, -16},
    { 1392, 528, 80},
    { 1568, 944, 120},
    { 928, 1096, -136},
    { 1240, 648, 80},
    { 1032, 736, -96},
    { 1248, 568, -88},
    { 1360, 640, 16},
    { 1792, 664, 128},
    { 1776, 416, 152},
    { 1664, 200, 176},
    { 1536, 120, 152},
    { 1456, 160, 56},
    { 1336, 232, 32},
    { 1168, 224, 16},
    { 1128, 160, -16},
    { 712, -176, 40},
    { 640, -280, -8},
    { 1080, 104, -40},
    { 1352, 344, -160},
    // 16 seconds
    { 1488, 224, -88},
    { 1888, 256, -248},
    { 1536, 360, -120},
    { 1208, 280, -88},
    { 1304, 320, -88},
    { 1472, 376, -48},
    { 1456, 456, -120},
    { 1352, 552, 0},
    { 1560, 752, 136},
    { 1080, 960, 72},
    { 1064, 864, 88},
    { 936, 816, -8},
    { 1272, 600, -32},
    { 1256, 584, 40},
    { 1696, 688, 136},
    { 1824, 456, 168},
    { 1680, 208, 176},
    { 1584, 120, 112},
    { 1480, 144, 40},
    { 1328, 232, -24},
    { 1184, 232, -8},
    { 1192, 216, -96},
    { 832, -16, -32},
    { 720, -144, -56},
    { 848, 24, -24},
    // 17 seconds
    { 912, 248, -32},
    { 1240, 264, -120},
    { 1752, 304, -192},
    { 1760, 448, -176},
    { 1392, 368, -104},
    { 1152, 336, -192},
    { 1096, 320, -200},
    { 1368, 192, -200},
    { 1248, 408, -112},
    { 1592, 656, -24},
    { 1360, 984, -8},
    { 888, 888, -216},
    { 1320, 720, -264},
    { 1288, 592, -136},
    { 1328, 456, 0},
    { 1568, 448, 96},
    { 1720, 296, 32},
    { 1440, 160, 0},
    { 1232, 184, 88},
    { 1320, 200, 0},
    { 1264, 280, -24},
    { 1176, 272, 72},
    { 1240, 192, 48},
    { 992, 136, -48},
    { 824, 56, -56},
    // 18 seconds
    { 992, 88, -24},
    { 864, 168, -16},
    { 1184, 264, -120},
    { 1472, 296, -192},
    { 1424, 360, -232},
    { 1120, 288, -80},
    { 1104, 248, -136},
    { 1184, 312, -176},
    { 1328, 352, -272},
    { 1288, 448, -176},
    { 1608, 536, -72},
    { 1392, 824, -64},
    { 888, 712, -152},
    { 1256, 888, -216},
    { 1208, 688, -112},
    { 1408, 488, -24},
    { 1560, 520, 56},
    { 1568, 376, 56},
    { 1336, 208, 64},
    { 1216, 136, 88},
    { 1272, 176, -32},
    { 1328, 256, -56},
    { 1224, 240, 8},
    { 1264, 152, 32},
    { 976, 72, 16},
    // 19 seconds
    { 784, -16, 24},
    { 1048, 80, -32},
    { 1024, 232, -80},
    { 1200, 256, -192},
    { 1536, 240, -208},
    { 1608, 312, -296},
    { 1184, 264, -160},
    { 1048, 232, -240},
    { 1136, 368, -176},
    { 1232, 424, -168},
    { 1360, 408, -40},
    { 1696, 528, 112},
    { 1320, 792, 96},
    { 952, 856, 64},
    { 1056, 1064, -104},
    { 1168, 600, -32},
    { 1256, 512, 64},
    { 1616, 672, 120},
    { 1752, 448, 144},
    { 1568, 128, 144},
    { 1312, 80, 40},
    { 1248, 160, -56},
    { 1216, 272, -96},
    { 1208, 272, -16},
    { 1344, 208, -48},
    // 20 seconds
    { 944, 112, -136},
    { 896, -96, -40},
    { 856, -104, 32},
    { 1128, 216, -128},
    { 1304, 256, -168},
    { 1640, 248, -136},
    { 1480, 280, -136},
    { 1240, 264, -112},
    { 1240, 376, -144},
    { 1200, 464, 0},
    { 1288, 432, -136},
    { 1296, 408, 48},
    { 1728, 632, 256},
    { 1304, 912, 232},
    { 1136, 984, 208},
    { 896, 816, 16},
    { 1144, 576, 8},
    { 1016, 584, -8},
    { 1328, 688, 128},
    { 1608, 624, 168},
    { 1544, 312, 192},
    { 1496, 112, 152},
    { 1424, 96, 56},
    { 1320, 160, 0},
    { 1208, 232, 40},
    // 21 seconds
    { 1304, 256, -16},
    { 1136, 240, -112},
    { 848, 56, -72},
    { 1056, -40, 0},
    { 832, 8, 64},
    { 1160, 208, -112},
    { 1448, 272, -152},
    { 1608, 336, -216},
    { 1416, 320, -232},
    { 1208, 296, -184},
    { 1184, 400, -168},
    { 1240, 464, -168},
    { 1448, 384, -160},
    { 1568, 544, 16},
    { 1472, 904, 40},
    { 880, 832, 40},
    { 1272, 912, -16},
    { 1208, 656, 8},
    { 1320, 512, 0},
    { 1544, 600, 144},
    { 1680, 536, 144},
    { 1576, 280, 152},
    { 1448, 160, 128},
    { 1400, 184, 16},
    { 1408, 240, -8},
    // 22 seconds
    { 1288, 240, 48},
    { 1432, 184, 48},
    { 1120, 200, -88},
    { 992, 144, -168},
    { 952, 56, -64},
    { 872, 80, -48},
    { 1040, 192, -152},
    { 1272, 232, -224},
    { 1256, 280, -248},
    { 1144, 240, -184},
    { 1384, 256, -208},
    { 1344, 328, -272},
    { 1264, 392, -216},
    { 1184, 664, -184},
    { 1136, 736, -320},
    { 1728, 312, -88},
    { 1136, 504, -88},
    { 1424, 776, -264},
    { 872, 704, -144},
    { 1296, 528, -120},
    { 1408, 440, 8},
    { 1648, 320, -16},
    { 1456, 224, -8},
    { 1184, 152, 24},
    { 1208, 168, -48},
    // 23 seconds
    { 1224, 240, -72},
    { 1112, 248, -64},
    { 1184, 192, -32},
    { 1192, 200, -104},
    { 880, 176, -208},
    { 1136, 80, -96},
    { 864, 32, 64},
    { 1160, 208, -136},
    { 1296, 264, -128},
    { 1592, 320, -128},
    { 1368, 360, -64},
    { 1144, 328, -112},
    { 1184, 368, -64},
    { 1296, 376, -16},
    { 1352, 416, -104},
    { 1184, 448, -56},
    { 1512, 576, 40},
    { 1144, 880, 88},
    { 1112, 856, -88},
    { 784, 744, -256},
    { 1152, 576, -80},
    { 1272, 552, -32},
    { 1576, 648, 40},
    { 1736, 504, 56},
    { 1544, 280, 160},
    // 24 seconds
    { 1352, 0, 216},
    { 1320, 88, -8},
    { 1216, 176, -16},
    { 1144, 224, 40},
    { 1320, 232, 8},
    { 920, 200, -80},
    { 952, 120, -120},
    { 992, -16, 40},
    { 1128, 200, -88},
    { 1200, 248, -160},
    { 1480, 256, -208},
    { 1320, 280, -176},
    { 1024, 248, -120},
    { 1040, 256, -136},
    { 1200, 328, -48},
    { 1368, 392, -32},
    { 1320, 464, -48},
    { 1520, 544, 16},
    { 1328, 832, 32},
    { 928, 912, -88},
    { 1288, 712, -64},
    { 1176, 600, -56},
    { 1216, 488, -48},
    { 1336, 576, 0},
    { 1424, 512, -8},
    // 25 seconds
    { 1336, 336, 24},
    { 1360, 176, 80},
    { 1456, 184, 16},
    { 1416, 208, -16},
    { 1248, 224, 8},
    { 1288, 176, 8},
    { 1064, 216, -112},
    { 912, 64, -32},
    { 1024, -56, 120},
    { 952, 128, -8},
    { 1192, 296, -176},
    { 1424, 312, -136},
    { 1352, 304, -168},
    { 1152, 288, -184},
    { 1096, 256, -168},
    { 1208, 312, -96},
    { 1328, 384, -80},
    { 1352, 480, -128},
    { 1472, 520, -64},
    { 1456, 720, -72},
    { 920, 696, -64},
    { 1280, 776, -192},
    { 1040, 624, -128},
    { 1280, 504, -56},
    { 1440, 528, -8},
    // 26 seconds
    { 1680, 488, -64},
    { 1472, 216, 120},
    { 1312, -80, 184},
    { 1208, 144, -80},
    { 1080, 128, -16},
    { 1008, 296, -32},
    { 1120, 240, -8},
    { 1048, 240, -128},
    { 912, 112, -160},
    { 1144, -88, 112},
    { 1168, 72, 16},
    { 1344, 320, -200},
    { 1544, 264, -96},
    { 1440, 288, -96},
    { 1152, 272, -120},
    { 1088, 304, -96},
    { 1088, 376, 16},
    { 1152, 408, 0},
    { 1216, 432, -56},
    { 1400, 480, 80},
    { 1472, 640, 208},
    { 1032, 744, 64},
    { 1264, 768, 88},
    { 864, 760, -96},
    { 1120, 568, -40},
    // 27 seconds
    { 1216, 576, 48},
    { 1536, 632, 104},
    { 1568, 408, 96},
    { 1520, 216, 88},
    { 1416, -32, 80},
    { 1360, 104, -40},
    { 1184, 200, 16},
    { 1112, 280, -48},
    { 1160, 280, -96},
    { 888, 160, -136},
    { 904, -8, -56},
    { 904, 8, -16},
    { 1080, 160, -192},
    { 1400, 184, -80},
    { 1792, 272, -120},
    { 1448, 352, -248},
    { 1088, 344, -152},
    { 1024, 392, -64},
    { 984, 456, 104},
    { 1272, 384, -104},
    { 1072, 360, 24},
    { 1424, 504, 96},
    { 1328, 688, 208},
    { 1104, 768, 56},
    { 1248, 832, -24},
    // 28 seconds
    { 1296, 616, -112},
    { 1104, 464, -32},
    { 1384, 600, 72},
    { 1464, 512, -56},
    { 1344, 304, 56},
    { 1192, -24, 192},
    { 1240, 88, -48},
    { 1216, 160, -64},
    { 1152, 280, -8},
    { 1256, 232, -24},
    { 1016, 208, -64},
    { 976, 96, -64},
    { 1104, 80, 40},
    { 1168, 184, -80},
    { 1256, 240, -112},
    { 1552, 256, -104},
    { 1280, 320, -144},
    { 960, 272, -160},
    { 960, 320, -136},
    { 1056, 336, -48},
    { 1200, 400, -80},
    { 1200, 496, -96},
    { 1568, 608, -8},
    { 1336, 800, -64},
    { 760, 536, -80},
    // 29 seconds
    { 1216, 656, -16},
    { 968, 768, -72},
    { 1368, 576, -32},
    { 1376, 552, 8},
    { 1504, 480, 40},
    { 1432, 280, 80},
    { 1328, 120, 120},
    { 1336, 144, 24},
    { 1360, 208, -16},
    { 1208, 272, 16},
    { 1256, 224, 0},
    { 1072, 128, -24},
    { 912, 32, -56},
    { 1104, -16, 96},
    { 1080, 144, -96},
    { 1176, 232, -176},
    { 1424, 224, -104},
    { 1424, 240, -80},
    { 1224, 272, -120},
    { 1120, 320, -152},
    { 1144, 376, -80},
    { 1264, 408, -16},
    { 1312, 472, -72},
    { 1624, 528, 48},
    { 1568, 768, 120},
    // 30 seconds
    { 944, 872, 40},
    { 1328, 904, 8},
    { 976, 680, -144},
    { 1112, 520, -96},
    { 1288, 632, 48},
    { 1680, 632, 64},
    { 1704, 344, 112},
    { 1536, 0, 216},
    { 1344, 160, 16},
    { 1264, 112, 56},
    { 1128, 280, 32},
    { 1104, 240, 56},
    { 1136, 216, 0},
    { 808, 112, -80},
    { 1112, -144, 16},
    { 1056, -160, 80},
    { 1360, 328, 40},
    { 1472, 512, -104},
    { 1512, 544, -248},
    { 1240, 512, -312},
    { 1096, 344, -120},
    { 1160, 312, 104},
    { 1368, 400, 0},
    { 1384, 400, -80},
    { 1400, 480, 56},
    // 31 seconds
    { 1472, 776, 128},
    { 896, 784, 88},
    { 1216, 888, 64},
    { 936, 712, -32},
    { 1280, 560, 16},
    { 1496, 576, 128},
    { 1752, 568, 112},
    { 1640, 424, 96},
    { 1528, 96, 272},
    { 1336, 136, 72},
    { 1272, 120, 8},
    { 1144, 240, -16},
    { 1096, 200, 16},
    { 1040, 128, -8},
    { 792, 16, -24},
    { 952, -56, -24},
    { 992, 80, 80},
    { 1320, 272, -80},
    { 1544, 304, -96},
    { 1792, 352, -120},
    { 1392, 400, -64},
    { 1008, 288, -160},
    { 1040, 328, -16},
    { 1296, 328, 8},
    { 1464, 400, 32},
    // 32 seconds
    { 1296, 504, 24},
    { 1592, 600, 160},
    { 1168, 856, 184},
    { 1008, 1008, -8},
    { 992, 688, -32},
    { 1184, 576, -16},
    { 1144, 544, 16},
    { 1576, 664, 128},
    { 1768, 472, 144},
    { 1608, 232, 152},
    { 1456, 160, 128},
    { 1368, 184, 56},
    { 1280, 216, 16},
    { 1168, 208, 56},
    { 1256, 168, 88},
    { 944, -32, 64},
    { 648, -96, 32},
    { 1224, 96, 32},
    { 1120, 224, -56},
    { 1352, 240, -72},
    { 1656, 248, -96},
    { 1544, 312, -152},
    { 1224, 272, -128},
    { 1120, 320, -176},
    { 1168, 376, -32},
    // 33 seconds
    { 1304, 424, -40},
    { 1256, 464, -24},
    { 1400, 496, 56},
    { 1528, 704, 128},
    { 944, 792, 120},
    { 1296, 888, 56},
    { 1032, 640, -40},
    { 1224, 536, -32},
    { 1312, 624, 96},
    { 1744, 656, 128},
    { 1608, 392, 128},
    { 1432, 184, 192},
    { 1368, 128, 96},
    { 1320, 160, 32},
    { 1248, 232, -16},
    { 1136, 224, 24},
    { 1200, 184, 16},
    { 832, 80, -32},
    { 808, 24, -80},
    { 1024, 112, -56},
    { 904, 200, -40},
    { 1264, 240, -120},
    { 1648, 288, -160},
    { 1520, 392, -200},
    { 1112, 296, -128},
    // 34 seconds
    { 1048, 224, -144},
    { 1208, 280, -112},
    { 1304, 328, -192},
    { 1160, 440, -200},
    { 1280, 504, -112},
    { 1472, 784, -8},
    { 984, 800, -168},
    { 1448, 712, -136},
    { 1064, 640, -136},
    { 1304, 552, -80},
    { 1440, 592, 32},
    { 1720, 536, 80},
    { 1640, 280, 128},
    { 1448, 64, 192},
    { 1368, 120, 112},
    { 1272, 168, 80},
    { 1072, 264, 72},
    { 968, 224, 128},
    { 1064, 208, 128},
    { 872, 216, -8},
    { 912, 152, -152},
    { 944, 72, -136},
    { 960, 112, -56},
    { 1248, 184, -160},
    { 1608, 264, -208},
    // 35 seconds
    { 1480, 336, -176},
    { 1104, 296, -160},
    { 1072, 272, -120},
    { 1272, 312, -8},
    { 1456, 360, 48},
    { 1336, 544, 48},
    { 1536, 648, 0},
    { 1352, 728, 0},
    { 976, 760, -136},
    { 1232, 824, -264},
    { 1248, 528, -152},
    { 1096, 488, -64},
    { 1352, 520, -24},
    { 1528, 376, -104},
    { 1520, 224, -56},
    { 1392, -80, 88},
    { 1248, 264, -40},
    { 1320, 168, 0},
    { 1208, 312, 32},
    { 1272, 232, 120},
    { 1088, 240, 88},
    { 864, 232, -16},
    { 1112, 216, -64},
    { 792, 200, -24},
    { 848, 216, -112},
    // 36 seconds
    { 1032, 232, -176},
    { 1408, 232, -120},
    { 1296, 280, -136},
    { 1000, 256, -152},
    { 1032, 320, -144},
    { 1200, 328, -144},
    { 1336, 376, -152},
    { 1216, 456, -64},
    { 1536, 536, -48},
    { 1432, 704, -72},
    { 1296, 888, -176},
    { 1056, 544, -224},
    { 1104, 384, -128},
    { 1000, 472, -48},
    { 1328, 504, -40},
    { 1504, 384, -24},
    { 1328, 240, 32},
    { 1208, 152, 88},
    { 1256, 112, 80},
    { 1192, 184, 40},
    { 1024, 208, 64},
    { 1112, 216, 56},
    { 1048, 256, -72},
    { 968, 104, -72},
    { 1120, -16, 128},
    // 37 seconds
    { 1040, 160, -40},
    { 1264, 264, -104},
    { 1512, 280, -120},
    { 1368, 344, -168},
    { 1016, 296, -128},
    { 984, 248, -96},
    { 1112, 280, 24},
    { 1248, 352, -8},
    { 1176, 440, -88},
    { 1384, 488, -24},
    { 1360, 680, 80},
    { 936, 864, -128},
    { 1304, 664, -128},
    { 1128, 640, -160},
    { 1272, 552, -80},
    { 1256, 544, 8},
    { 1440, 520, -32},
    { 1600, 440, 32},
    { 1472, 104, 208},
    { 1280, -64, 192},
    { 1232, 168, 0},
    { 1056, 192, -32},
    { 1064, 400, -32},
    { 1128, 272, 24},
    { 904, 144, 8},
    // 38 seconds
    { 1056, -72, 40},
    { 944, 8, 64},
    { 1120, 144, -80},
    { 1312, 152, -80},
    { 1536, 248, -88},
    { 1312, 336, -96},
    { 1040, 336, -160},
    { 1080, 344, -88},
    { 1240, 360, -8},
    { 1312, 392, -8},
    { 1168, 424, -24},
    { 1528, 512, 8},
    { 1272, 792, 112},
    { 832, 776, -128},
    { 1384, 568, -40},
    { 1184, 672, -80},
    { 1120, 512, -16},
    { 1176, 544, 16},
    { 1384, 472, 8},
    { 1416, 360, -24},
    { 1416, 224, 104},
    { 1408, 96, 176},
    { 1416, 160, -16},
    { 1176, 192, -8},
    { 1088, 216, -16},
    // 39 seconds
    { 1064, 216, -48},
    { 888, 136, -120},
    { 968, -120, 56},
    { 856, 32, 24},
    { 1160, 288, -168},
    { 1408, 272, -128},
    { 1616, 312, -72},
    { 1360, 328, -72},
    { 1080, 272, -192},
    { 1000, 304, -40},
    { 1152, 312, 0},
    { 1176, 360, -48},
    { 1048, 416, 0},
    { 1464, 520, 48},
    { 1192, 680, 232},
    { 1008, 784, -24},
    { 1352, 648, -48},
    { 1192, 616, -48},
    { 1104, 552, -32},
    { 1112, 584, 16},
    { 1352, 560, 16},
    { 1488, 400, 32},
    { 1408, 208, 144},
    { 1376, -120, 224},
    { 1264, 216, -48},
    // 40 seconds
    { 1008, 152, 64},
    { 1048, 280, 56},
    { 1152, 360, -120},
    { 800, 288, -64},
    { 1232, 104, 160},
    { 960, -40, 216},
    { 1160, 216, -88},
    { 1384, 288, -40},
    { 1376, 312, -48},
    { 1144, 288, -136},
    { 904, 256, -192},
    { 984, 288, -72},
    { 1192, 296, -8},
    { 1256, 408, -56},
    { 1376, 504, 24},
    { 1768, 640, 72},
    { 1184, 816, 56},
    { 1440, 808, -80},
    { 928, 600, -88},
    { 1072, 488, -72},
    { 1096, 536, 16},
    { 1328, 568, 8},
    { 1448, 392, 40},
    { 1312, 192, 144},
    { 1240, 176, 88},
    // 41 seconds
    { 1248, 128, 80},
    { 1224, 200, 16},
    { 1176, 168, 72},
    { 1304, 176, 120},
    { 1040, 200, -32},
    { 976, -16, -32},
    { 976, -136, 96},
    { 1176, 216, -144},
    { 1248, 144, -168},
    { 1464, 128, -80},
    { 1256, 192, -24},
    { 1096, 208, -120},
    { 1120, 304, -40},
    { 1256, 368, 56},
    { 1384, 448, 24},
    { 1224, 528, -16},
    { 1432, 584, 80},
    { 1352, 904, 64},
    { 936, 696, -96},
    { 1184, 568, -56},
    { 1040, 584, -128},
    { 1080, 536, -40},
    { 1352, 608, 16},
    { 1608, 520, -40},
    { 1552, 336, 32},
    // 42 seconds
    { 1512, -88, 232},
    { 1232, 144, -8},
    { 1264, 104, 24},
    { 1104, 272, 40},
    { 1240, 256, 56},
    { 1144, 264, 16},
    { 928, 168, -56},
    { 1088, 128, 72},
    { 840, 80, 0},
    { 1056, 192, -88},
    { 1256, 224, -88},
    { 1304, 296, -136},
    { 1128, 312, -160},
    { 1080, 328, -200},
    { 1224, 368, -296},
    { 1288, 312, -288},
    { 1224, 360, -200},
    { 1408, 416, -104},
    { 1584, 592, -48},
    { 1064, 584, -40},
    { 1384, 696, 24},
    { 992, 768, -80},
    { 1112, 552, -64},
    { 1096, 480, 24},
    { 1312, 440, 72},
    // 43 seconds
    { 1408, 296, 48},
    { 1256, 216, 64},
    { 1280, 216, 40},
    { 1304, 248, -8},
    { 1184, 272, -24},
    { 1120, 216, -40},
    { 1232, 184, -88},
    { 1000, 80, -152},
    { 1016, -64, -80},
    { 1128, 32, -48},
    { 1112, 184, -184},
    { 1192, 208, -192},
    { 1472, 200, -136},
    { 1368, 288, -104},
    { 1144, 272, -72},
    { 1128, 320, -88},
    { 1232, 360, 24},
    { 1304, 416, 8},
    { 1104, 456, -32},
    { 1152, 488, 48},
    { 1344, 672, 112},
    { 928, 800, 32},
    { 1448, 800, 40},
    { 1136, 648, -80},
    { 1144, 488, -56},
    // 44 seconds
    { 1304, 568, 48},
    { 1624, 584, 40},
    { 1648, 368, 48},
    { 1584, 144, 208},
    { 1376, 144, 24},
    { 1336, 96, 16},
    { 1184, 216, 8},
    { 1136, 208, 80},
    { 1152, 224, 8},
    { 872, 176, -48},
    { 904, 112, -56},
    { 944, 120, 0},
    { 928, 176, 0},
    { 1160, 256, -120},
    { 1512, 328, -168},
    { 1704, 416, -256},
    { 1240, 344, -88},
    { 1072, 240, -160},
    { 1192, 232, -152},
    { 1304, 280, -176},
    { 1200, 384, -176},
    { 1136, 464, -184},
    { 1448, 640, -200},
    { 1144, 784, -96},
    { 1344, 752, -336},
    // 45 seconds
    { 968, 552, -224},
    { 1296, 488, -120},
    { 1464, 416, 0},
    { 1792, 408, -48},
    { 1648, 200, 32},
    { 1328, 40, 104},
    { 1080, 224, 40},
    { 1152, 168, 16},
    { 1104, 336, 24},
    { 1048, 248, 104},
    { 1032, 248, 72},
    { 1016, 176, 16},
    { 888, 40, -72},
    { 1064, -16, 32},
    { 1136, 168, 0},
    { 1288, 256, -128},
    { 1568, 248, -104},
    { 1704, 336, -224},
    { 1248, 328, -200},
    { 1048, 272, -232},
    { 1208, 256, -64},
    { 1256, 312, 8},
    { 1224, 408, 16},
    { 1312, 504, 48},
    { 1560, 664, 96},
    // 46 seconds
    { 1104, 816, 56},
    { 1360, 888, 48},
    { 864, 816, -32},
    { 1184, 544, -32},
    { 1296, 560, -8},
    { 1656, 616, 56},
    { 1784, 384, 80},
    { 1664, 184, 144},
    { 1464, 80, 104},
    { 1416, 128, 24},
    { 1328, 216, 16},
    { 1136, 296, 104},
    { 1224, 240, 48},
    { 992, 128, 40},
    { 784, 40, -64},
    { 1040, 0, 16},
    { 1016, 104, -16},
    { 1312, 168, -112},
    { 1592, 216, -88},
    { 1680, 328, -112},
    { 1392, 376, -144},
    { 1136, 408, -88},
    { 1080, 424, 24},
    { 1360, 336, -80},
    { 1336, 400, 16},
    // 47 seconds
    { 1552, 520, 104},
    { 1352, 704, 264},
    { 944, 800, 72},
    { 1216, 712, 40},
    { 936, 696, -16},
    { 1112, 592, 8},
    { 1296, 624, 96},
    { 1536, 608, 88},
    { 1520, 384, 40},
    { 1544, 216, 168},
    { 1480, 0, 96},
    { 1376, 40, -144},
    { 1160, 80, -136},
    { 1000, 152, 8},
    { 1104, 240, -88},
    { 864, 280, -296},
    { 880, 168, -200},
    { 1032, 128, -136},
    { 1104, 176, -200},
    { 1288, 144, -40},
    { 1744, 256, -64},
    { 1376, 400, -56},
    { 976, 376, -120},
    { 960, 408, -16},
    { 1192, 368, -24},
    // 48 seconds
    { 1328, 336, 48},
    { 1288, 376, 88},
    { 1640, 536, 560},
    { 1136, 984, 432},
    { 1336, 1264, 304},
    { 960, 520, 152},
    { 992, 592, 96},
    { 1056, 696, 216},
    { 1480, 688, 320},
    { 1528, 384, 240},
    { 1432, 224, 176},
    { 1336, 144, 96},
    { 1288, 168, -8},
    { 1168, 200, -48},
    { 1088, 184, -32},
    { 1216, 176, -48},
    { 1024, 200, -192},
    { 936, 88, -136},
    { 1024, 104, -128},
    { 1040, 112, -72},
    { 1288, 248, -112},
    { 1680, 296, -200},
    { 1528, 344, -152},
    { 1160, 296, -144},
    { 1040, 344, -144},
    // 49 seconds
    { 1048, 368, -64},
    { 1144, 392, -104},
    { 1104, 408, -64},
    { 1232, 528, 56},
    { 1496, 784, 160},
    { 1000, 768, 48},
    { 1288, 688, 120},
    { 1056, 720, -16},
    { 1168, 520, -24},
    { 1312, 576, 88},
    { 1576, 640, 128},
    { 1528, 456, 144},
    { 1416, 176, 224},
    { 1352, 120, 152},
    { 1288, 136, 72},
    { 1200, 216, 16},
    { 1088, 208, 72},
    { 1168, 224, -32},
    { 928, 144, -88},
    { 920, 0, -104},
    { 1040, -64, 0},
    { 1216, 216, -152},
    { 1288, 216, -168},
    { 1592, 232, -232},
    { 1408, 280, -184},
    // 50 seconds
    { 1128, 272, -80},
    { 1144, 320, -72},
    { 1264, 392, 16},
    { 1280, 464, -16},
    { 1168, 448, -16},
    { 1336, 512, 96},
    { 1384, 672, 248},
    { 960, 736, 160},
    { 1256, 688, 168},
    { 1096, 704, 64},
    { 1168, 568, 16},
    { 1184, 584, 80},
    { 1456, 632, 136},
    { 1504, 480, 104},
    { 1480, 272, 168},
    { 1448, 64, 160},
    { 1440, 128, 24},
    { 1248, 184, -8},
    { 1040, 216, 0},
    { 1080, 200, -8},
    { 984, 168, -24},
    { 768, 72, -72},
    { 1208, 96, -32},
    { 1000, 176, -8},
    { 1184, 264, -120},
    // 51 seconds
    { 1432, 256, -144},
    { 1512, 344, -152},
    { 1216, 328, -112},
    { 1064, 272, -144},
    { 1152, 280, -48},
    { 1328, 336, -104},
    { 1224, 448, -112},
    { 1112, 472, -64},
    { 1368, 616, -32},
    { 1080, 768, 56},
    { 1280, 808, -72},
    { 1032, 552, -80},
    { 1248, 488, -64},
    { 1256, 520, 16},
    { 1520, 552, 8},
    { 1664, 376, 0},
    { 1440, 56, 152},
    { 1136, -8, 168},
    { 1232, 184, -48},
    { 1104, 192, 0},
    { 952, 304, 32},
    { 1040, 216, 32},
    { 1016, 232, -24},
    { 976, 144, -40},
    { 1184, 144, 64},
    // 52 seconds
    { 1152, 184, 0},
    { 1240, 264, -56},
    { 1504, 304, -136},
    { 1336, 336, -152},
    { 1032, 264, -152},
    { 984, 288, -168},
    { 1032, 312, -112},
    { 1096, 424, -88},
    { 1080, 392, -88},
    { 1368, 456, -16},
    { 1520, 584, 16},
    { 1000, 632, 16},
    { 1208, 632, -8},
    { 896, 704, -128},
    { 1176, 536, -40},
    { 1176, 496, 24},
    { 1384, 512, 56},
    { 1496, 368, 32},
    { 1360, 208, 120},
    { 1248, 112, 104},
    { 1232, 136, 24},
    { 1144, 232, -24},
    { 976, 248, 0},
    { 1072, 192, -8},
    { 984, 152, -72},
    // 53 seconds
    { 888, 56, -136},
    { 1232, 8, 0},
    { 1096, 120, -32},
    { 1296, 208, -72},
    { 1584, 248, -128},
    { 1536, 360, -192},
    { 1136, 328, -72},
    { 1032, 272, -104},
    { 1144, 344, 0},
    { 1256, 416, 16},
    { 1128, 472, -32},
    { 1048, 472, -40},
    { 1344, 552, 80},
    { 1008, 712, 104},
    { 1096, 656, 24},
    { 928, 824, -120},
    { 1240, 584, -48},
    { 1280, 544, 56},
    { 1656, 584, 120},
    { 1776, 440, 16},
    { 1600, 312, 168},
    { 1416, 16, 232},
    { 1344, 112, 48},
    { 1168, 152, -8},
    { 976, 224, -16},
    // 54 seconds
    { 944, 192, 0},
    { 912, 184, 16},
    { 776, 168, -104},
    { 888, 112, -72},
    { 944, 192, 8},
    { 1184, 216, -32},
    { 1544, 296, -56},
    { 1952, 400, -184},
    { 1504, 432, -40},
    { 1040, 312, -168},
    { 1000, 288, -96},
    { 1152, 272, -64},
    { 1184, 344, -40},
    { 1032, 456, -48},
    { 1232, 568, 0},
    { 1400, 752, 192},
    { 1064, 816, 72},
    { 1384, 568, -8},
    { 1008, 600, -72},
    { 1232, 600, -24},
    { 1384, 608, 96},
    { 1728, 520, 136},
    { 1712, 336, 80},
    { 1568, 200, 144},
    { 1400, 176, 72},
    // 55 seconds
    { 1336, 160, 56},
    { 1096, 240, 8},
    { 952, 200, 16},
    { 904, 168, -16},
    { 824, 152, 0},
    { 680, 128, -24},
    { 896, 128, -16},
    { 880, 208, -8},
    { 1200, 296, -88},
    { 1544, 368, -232},
    { 1880, 440, -280},
    { 1360, 344, -64},
    { 1024, 480, 120},
    { 1040, 360, -176},
    { 1160, 464, -184},
    { 1168, 312, -64},
    { 1024, 360, -48},
    { 1056, 376, 16},
    { 1304, 496, -56},
    { 1200, 640, -80},
    { 1032, 624, -136},
    { 1248, 608, -264},
    { 1136, 472, -176},
    { 1176, 392, -128},
    { 1432, 336, -24},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:13:54 local
AccelRawData *activity_sample_walk_100_pbl_25298_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25298_5
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -264, 696, 696},
    { -256, 648, 728},
    { -232, 672, 712},
    { -216, 720, 832},
    { -224, 760, 840},
    { -240, 800, 808},
    { -280, 784, 776},
    { -320, 856, 696},
    { -344, 840, 560},
    { -336, 936, 408},
    { -280, 968, 360},
    { -296, 944, 336},
    { -272, 920, 232},
    { -296, 1056, 72},
    { -264, 904, -104},
    { -312, 1048, -104},
    { -248, 968, -232},
    { -280, 1032, -456},
    { -280, 848, -504},
    { -224, 152, -544},
    { -72, 368, -880},
    { 272, 208, -920},
    { -8, 112, -976},
    { 24, 32, -976},
    { 104, -88, -1008},
    // 1 seconds
    { 120, -120, -1032},
    { 128, -80, -1104},
    { 96, -104, -1072},
    { 48, -72, -1040},
    { 8, -104, -1048},
    { -32, -112, -1008},
    { -48, -112, -1016},
    { 40, -48, -1072},
    { -56, -72, -1024},
    { -48, -72, -1040},
    { -24, -96, -1056},
    { -120, -56, -1000},
    { -48, -56, -1024},
    { -56, -64, -984},
    { -64, -88, -968},
    { -64, -80, -984},
    { -80, -56, -1032},
    { -104, -72, -1040},
    { -80, -40, -1080},
    { -40, -64, -1056},
    { 0, -144, -1048},
    { -40, -64, -1016},
    { -40, -72, -1000},
    { -40, -56, -992},
    { -40, -72, -1008},
    // 2 seconds
    { -56, -56, -1016},
    { -32, -64, -1016},
    { -24, -56, -1040},
    { -32, -40, -1056},
    { -56, -40, -1048},
    { -48, -24, -1040},
    { -24, -48, -1048},
    { -40, -16, -1040},
    { -40, -16, -1016},
    { -16, -40, -1008},
    { -24, -40, -1000},
    { -8, -48, -992},
    { 56, -112, -992},
    { 48, 24, -1000},
    { 8, -40, -1000},
    { -32, 0, -1000},
    { -88, 56, -1024},
    { -128, 96, -1048},
    { -152, 104, -1080},
    { -160, 120, -1064},
    { -136, 88, -1080},
    { -40, -16, -1112},
    { 24, -104, -1064},
    { 16, -136, -1040},
    { -8, -176, -1016},
    // 3 seconds
    { -24, -168, -1000},
    { -72, -168, -1000},
    { -88, -120, -1016},
    { -80, -112, -1016},
    { -64, -96, -1016},
    { -64, -56, -984},
    { -40, 48, -984},
    { 56, 200, -992},
    { 200, 240, -1064},
    { 304, 224, -1112},
    { 336, 144, -992},
    { 328, 312, -920},
    { 400, 528, -928},
    { 464, 464, -864},
    { 352, 464, -800},
    { 144, 320, -656},
    { 216, 344, -760},
    { 288, 256, -824},
    { 432, 528, -968},
    { 496, 600, -992},
    { 472, 512, -872},
    { 496, 592, -880},
    { 584, 584, -824},
    { 528, 768, -920},
    { 336, 944, -1272},
    // 4 seconds
    { 360, 768, -1216},
    { 448, 568, -1120},
    { 288, 688, -904},
    { 304, 856, -864},
    { 440, 856, -896},
    { 576, 640, -1032},
    { 592, 328, -1040},
    { 536, 280, -1008},
    { 544, 352, -904},
    { 480, 312, -712},
    { 416, 216, -544},
    { 456, 128, -400},
    { 704, 152, -352},
    { 1000, 328, -464},
    { 1288, 392, -352},
    { 1136, 344, -240},
    { 1232, 288, -248},
    { 1576, 264, -104},
    { 1728, 384, 72},
    { 1616, 472, 64},
    { 1384, 472, -72},
    { 1264, 464, -112},
    { 1272, 392, -48},
    { 1288, 376, 8},
    { 1168, 432, -8},
    // 5 seconds
    { 1360, 568, 8},
    { 1232, 840, 64},
    { 1016, 1040, -176},
    { 1160, 768, -288},
    { 912, 544, -184},
    { 1016, 552, -56},
    { 1376, 648, -24},
    { 1744, 488, 56},
    { 1640, 256, 96},
    { 1552, 104, 120},
    { 1432, 120, 48},
    { 1384, 208, 16},
    { 1232, 296, 72},
    { 1288, 296, 32},
    { 1192, 312, -104},
    { 968, -16, -48},
    { 984, -456, 144},
    { 800, -88, 136},
    { 1224, 336, -120},
    { 1216, 296, -168},
    { 1368, 288, -264},
    { 1288, 312, -176},
    { 1304, 272, -80},
    { 1424, 336, 8},
    { 1416, 464, 48},
    // 6 seconds
    { 1384, 520, -128},
    { 1728, 528, 8},
    { 1472, 840, 96},
    { 944, 992, 48},
    { 1104, 960, -88},
    { 976, 664, -88},
    { 960, 560, -96},
    { 1176, 616, -56},
    { 1552, 544, 56},
    { 1624, 280, 88},
    { 1576, 112, 96},
    { 1488, 144, 48},
    { 1504, 240, 24},
    { 1240, 288, 64},
    { 1328, 304, -32},
    { 1096, 160, -88},
    { 856, -248, 64},
    { 960, -264, 160},
    { 1160, 160, -64},
    { 1200, 264, -88},
    { 1424, 232, -72},
    { 1400, 304, -136},
    { 1336, 344, -224},
    { 1264, 328, -152},
    { 1264, 344, -40},
    // 7 seconds
    { 1304, 416, -56},
    { 1248, 400, -120},
    { 1432, 488, 0},
    { 1448, 736, 32},
    { 944, 824, 56},
    { 1224, 1072, -72},
    { 1056, 656, -80},
    { 1216, 496, -56},
    { 1208, 584, 40},
    { 1512, 544, 24},
    { 1648, 352, 64},
    { 1536, 232, 96},
    { 1464, 80, 152},
    { 1448, 224, 0},
    { 1184, 208, 56},
    { 1032, 256, 64},
    { 1152, 208, 0},
    { 904, 40, 24},
    { 1072, -72, 112},
    { 1056, 248, -80},
    { 1120, 288, -128},
    { 1448, 272, -96},
    { 1368, 280, -56},
    { 1240, 264, -152},
    { 1088, 336, -224},
    // 8 seconds
    { 1096, 360, -160},
    { 1272, 288, -256},
    { 1248, 408, -136},
    { 1336, 488, -32},
    { 1488, 584, -56},
    { 1032, 576, -40},
    { 1200, 632, -120},
    { 928, 752, -184},
    { 1120, 560, -72},
    { 1152, 448, 56},
    { 1352, 392, 16},
    { 1392, 280, -64},
    { 1280, 152, -64},
    { 1232, 40, 64},
    { 1248, 296, -32},
    { 1096, 312, -72},
    { 1024, 344, -120},
    { 1224, 288, -144},
    { 944, 264, -240},
    { 1024, 96, -88},
    { 1040, 64, 56},
    { 1000, 120, -32},
    { 1240, 240, -120},
    { 1464, 336, -144},
    { 1168, 376, -112},
    // 9 seconds
    { 864, 288, -184},
    { 920, 280, -96},
    { 1136, 328, -8},
    { 1288, 416, -56},
    { 1176, 488, -16},
    { 1584, 552, 56},
    { 1320, 760, 80},
    { 1088, 896, -48},
    { 1112, 768, -88},
    { 1160, 544, -112},
    { 1040, 520, -56},
    { 1232, 616, 8},
    { 1456, 456, 56},
    { 1392, 224, 88},
    { 1336, 32, 144},
    { 1416, 176, -8},
    { 1344, 224, 48},
    { 1064, 280, 64},
    { 1064, 280, -24},
    { 1112, 176, -128},
    { 736, -280, -48},
    { 1120, -192, 192},
    { 1072, 216, 16},
    { 1392, 360, -136},
    { 1656, 296, -120},
    // 10 seconds
    { 1520, 352, -152},
    { 1096, 304, -216},
    { 976, 272, -136},
    { 1088, 280, 48},
    { 1320, 392, 8},
    { 1280, 488, 24},
    { 1576, 648, 32},
    { 1192, 752, 48},
    { 952, 744, -56},
    { 1184, 784, -160},
    { 1232, 616, -72},
    { 1176, 552, 16},
    { 1416, 584, 32},
    { 1568, 416, -8},
    { 1424, 264, 56},
    { 1336, 16, 168},
    { 1312, 208, -16},
    { 1216, 184, 16},
    { 1096, 280, 40},
    { 1280, 224, 16},
    { 928, 56, 0},
    { 968, -120, -40},
    { 984, 24, 80},
    { 1320, 288, -168},
    { 1416, 280, -128},
    // 11 seconds
    { 1576, 248, -64},
    { 1280, 280, -88},
    { 1032, 240, -144},
    { 1072, 360, -56},
    { 1144, 392, 56},
    { 1272, 456, -16},
    { 1208, 496, 8},
    { 1624, 552, 80},
    { 1240, 760, 144},
    { 920, 888, -96},
    { 1248, 832, 0},
    { 1320, 648, -56},
    { 1072, 480, -48},
    { 1352, 600, 24},
    { 1576, 536, 64},
    { 1480, 320, 112},
    { 1408, 168, 144},
    { 1432, 184, 64},
    { 1416, 224, 40},
    { 1264, 264, 80},
    { 1240, 208, 104},
    { 1088, 200, 8},
    { 752, 80, -16},
    { 1032, 16, -88},
    { 808, 80, -8},
    // 12 seconds
    { 1048, 232, -104},
    { 1248, 264, -176},
    { 1512, 312, -248},
    { 1264, 336, -176},
    { 1048, 248, -88},
    { 1176, 296, -120},
    { 1336, 360, -120},
    { 1400, 440, -160},
    { 1272, 504, -96},
    { 1544, 576, -40},
    { 1208, 744, 24},
    { 1072, 792, -72},
    { 1096, 816, -184},
    { 1264, 544, -88},
    { 1272, 520, -8},
    { 1536, 600, 32},
    { 1704, 408, 64},
    { 1464, 160, 144},
    { 1216, 128, 120},
    { 1272, 136, 48},
    { 1224, 240, 0},
    { 1080, 256, 96},
    { 1176, 208, 72},
    { 1008, 168, 32},
    { 768, 104, -120},
    // 13 seconds
    { 1168, 64, 16},
    { 960, 72, 88},
    { 1256, 248, -120},
    { 1448, 312, -184},
    { 1640, 408, -360},
    { 1184, 360, -104},
    { 1032, 128, -160},
    { 1120, 576, -120},
    { 1232, 248, -24},
    { 1264, 456, -96},
    { 1328, 480, -8},
    { 1448, 616, 8},
    { 920, 672, 88},
    { 1216, 816, -16},
    { 952, 848, -96},
    { 1328, 584, 0},
    { 1440, 520, 88},
    { 1624, 496, 88},
    { 1600, 368, 16},
    { 1472, 200, 104},
    { 1256, 120, 152},
    { 1240, 200, 8},
    { 1176, 248, -56},
    { 1104, 240, 56},
    { 1128, 208, 24},
    // 14 seconds
    { 808, 160, -32},
    { 952, 88, 8},
    { 864, 120, 48},
    { 1024, 288, -24},
    { 1312, 328, -112},
    { 1616, 432, -296},
    { 1272, 424, -160},
    { 904, 280, 40},
    { 960, 248, -136},
    { 1080, 304, -168},
    { 1344, 208, -168},
    { 1280, 400, -224},
    { 1600, 480, -128},
    { 1192, 696, -128},
    { 1272, 864, -128},
    { 1144, 760, -288},
    { 1224, 376, -120},
    { 1008, 416, -16},
    { 1280, 504, -16},
    { 1200, 400, -8},
    { 1064, 240, 48},
    { 1144, 176, 56},
    { 1304, 224, 8},
    { 1328, 288, 40},
    { 1240, 232, 152},
    // 15 seconds
    { 1416, 216, 112},
    { 1024, 232, 8},
    { 1280, 88, -24},
    { 816, -48, 0},
    { 1016, 176, -280},
    { 1112, 176, -248},
    { 1344, 120, -184},
    { 1168, 152, -192},
    { 928, 176, -208},
    { 928, 240, -264},
    { 1104, 368, -200},
    { 1144, 296, -88},
    { 1120, 368, -80},
    { 1440, 456, -56},
    { 1472, 664, -136},
    { 1000, 808, -80},
    { 1368, 672, -328},
    { 1024, 440, -160},
    { 1144, 464, -64},
    { 1240, 488, -32},
    { 1528, 496, -72},
    { 1368, 264, 0},
    { 1264, 8, 72},
    { 1128, 120, -40},
    { 1136, 136, 8},
    // 16 seconds
    { 1040, 264, 32},
    { 1096, 240, 48},
    { 1120, 240, -24},
    { 960, 200, -136},
    { 1312, 64, 64},
    { 1200, 88, 16},
    { 1208, 296, -264},
    { 1392, 232, -160},
    { 1384, 200, -8},
    { 1120, 216, -80},
    { 1000, 288, -168},
    { 976, 360, -48},
    { 984, 416, 24},
    { 1008, 456, -8},
    { 1104, 440, -24},
    { 1552, 488, 72},
    { 1232, 632, 80},
    { 1120, 680, -8},
    { 1048, 808, -120},
    { 1016, 656, -136},
    { 1232, 504, -8},
    { 1480, 584, 64},
    { 1592, 456, 48},
    { 1496, 280, 48},
    { 1344, 64, 112},
    // 17 seconds
    { 1312, 144, -24},
    { 1232, 192, -104},
    { 1104, 248, -96},
    { 1128, 192, 24},
    { 1056, 184, -24},
    { 784, 152, -104},
    { 1000, 120, -168},
    { 952, 184, 8},
    { 1104, 216, -88},
    { 1416, 256, -96},
    { 1608, 336, -88},
    { 1280, 416, -24},
    { 1096, 312, -72},
    { 1104, 376, 0},
    { 1240, 368, -8},
    { 1200, 400, -8},
    { 1152, 440, 24},
    { 1488, 528, 56},
    { 1008, 624, 264},
    { 1272, 848, 8},
    { 872, 912, -120},
    { 1240, 496, -24},
    { 1232, 552, 72},
    { 1512, 664, 64},
    { 1552, 448, 24},
    // 18 seconds
    { 1432, 272, 136},
    { 1304, 48, 192},
    { 1312, 176, 8},
    { 1184, 208, 8},
    { 1088, 248, 64},
    { 1208, 216, 80},
    { 976, 208, 40},
    { 864, 224, -48},
    { 1096, 216, -88},
    { 920, 184, -40},
    { 1120, 224, -152},
    { 1384, 264, -232},
    { 1312, 304, -144},
    { 992, 256, -56},
    { 936, 232, -168},
    { 1096, 296, -128},
    { 1224, 328, -88},
    { 1168, 392, -144},
    { 1120, 448, -120},
    { 1616, 560, -136},
    { 1256, 688, -48},
    { 1032, 632, -200},
    { 1264, 608, -248},
    { 1016, 496, -152},
    { 1056, 496, -72},
    // 19 seconds
    { 1392, 488, -24},
    { 1544, 408, -40},
    { 1336, 264, 16},
    { 1232, 192, 64},
    { 1280, 232, 32},
    { 1280, 240, 8},
    { 1120, 232, 32},
    { 1112, 184, 40},
    { 1192, 208, -8},
    { 896, 208, -128},
    { 1128, 88, -112},
    { 888, 128, -72},
    { 984, 176, -152},
    { 1160, 216, -224},
    { 1416, 248, -200},
    { 1232, 264, -88},
    { 1008, 248, -112},
    { 992, 312, -136},
    { 1088, 336, -56},
    { 1184, 384, -32},
    { 1168, 432, -48},
    { 1440, 488, 0},
    { 1632, 624, 0},
    { 1024, 712, 16},
    { 1384, 736, -152},
    // 20 seconds
    { 880, 704, -216},
    { 1088, 568, -112},
    { 1216, 584, -48},
    { 1424, 584, -48},
    { 1512, 416, 8},
    { 1392, 200, 120},
    { 1320, 40, 152},
    { 1392, 168, -8},
    { 1224, 208, 40},
    { 1104, 256, 48},
    { 1144, 232, 64},
    { 976, 224, -72},
    { 920, 160, -184},
    { 1112, 88, -80},
    { 968, 128, -64},
    { 1088, 192, -176},
    { 1336, 224, -256},
    { 1288, 280, -192},
    { 992, 240, -104},
    { 984, 240, -104},
    { 1160, 312, -40},
    { 1336, 384, -24},
    { 1312, 488, -56},
    { 1360, 520, 16},
    { 1584, 672, 80},
    // 21 seconds
    { 1048, 856, -40},
    { 1152, 616, -48},
    { 904, 664, -160},
    { 1128, 608, -88},
    { 1152, 592, -24},
    { 1352, 600, 8},
    { 1480, 464, 0},
    { 1432, 280, 96},
    { 1480, 96, 136},
    { 1464, 152, 16},
    { 1288, 208, -24},
    { 1096, 216, 8},
    { 1232, 224, -16},
    { 968, 192, -88},
    { 920, 104, -112},
    { 1032, 24, 24},
    { 1120, 184, -104},
    { 1232, 240, -128},
    { 1512, 256, -112},
    { 1296, 288, -104},
    { 928, 240, -112},
    { 896, 288, -128},
    { 1088, 312, -16},
    { 1288, 368, -8},
    { 1280, 472, -48},
    // 22 seconds
    { 1480, 552, 24},
    { 1528, 816, 72},
    { 976, 728, -128},
    { 1296, 496, 0},
    { 872, 808, -128},
    { 1208, 616, -64},
    { 1232, 592, 0},
    { 1456, 528, 32},
    { 1528, 384, 24},
    { 1416, 240, 72},
    { 1328, 112, 128},
    { 1360, 216, 0},
    { 1232, 232, -32},
    { 1008, 248, -8},
    { 1008, 184, -24},
    { 912, 192, -72},
    { 696, 176, -144},
    { 1096, 96, -112},
    { 920, 192, -32},
    { 1208, 232, -104},
    { 1544, 264, -184},
    { 1576, 336, -144},
    { 1168, 328, -40},
    { 912, 232, -120},
    { 1016, 320, -96},
    // 23 seconds
    { 1224, 328, -72},
    { 1240, 400, -120},
    { 1048, 432, -120},
    { 1376, 480, -80},
    { 1392, 632, 0},
    { 944, 656, -96},
    { 1408, 664, -128},
    { 928, 856, -224},
    { 1168, 552, -72},
    { 1320, 512, 40},
    { 1624, 488, 32},
    { 1584, 272, 72},
    { 1424, 80, 136},
    { 1304, 160, 32},
    { 1248, 184, 16},
    { 1152, 264, 8},
    { 1016, 216, 56},
    { 1080, 208, 16},
    { 944, 216, -112},
    { 896, 120, -136},
    { 1120, 64, -56},
    { 1152, 192, -96},
    { 1248, 256, -224},
    { 1520, 248, -224},
    { 1304, 248, -64},
    // 24 seconds
    { 1016, 224, -80},
    { 984, 296, -112},
    { 1128, 360, -40},
    { 1296, 400, -24},
    { 1224, 464, -40},
    { 1432, 480, 16},
    { 1568, 624, 88},
    { 1000, 776, 72},
    { 1304, 760, -16},
    { 936, 672, -88},
    { 1056, 560, -80},
    { 1072, 600, 0},
    { 1408, 632, 56},
    { 1464, 456, 56},
    { 1392, 264, 104},
    { 1368, 96, 144},
    { 1368, 176, 8},
    { 1240, 200, 24},
    { 1080, 232, 56},
    { 1080, 232, 16},
    { 1064, 208, -8},
    { 872, 152, -40},
    { 1280, 120, -8},
    { 1040, 104, -128},
    { 1096, 200, -192},
    // 25 seconds
    { 1288, 184, -144},
    { 1448, 296, -224},
    { 1112, 320, -144},
    { 856, 296, -184},
    { 920, 360, -136},
    { 1088, 360, -56},
    { 1240, 368, -32},
    { 1144, 416, -8},
    { 1448, 480, 32},
    { 1304, 664, 104},
    { 1016, 784, -48},
    { 1312, 720, -120},
    { 992, 560, -96},
    { 1032, 528, -88},
    { 1248, 608, 24},
    { 1480, 536, 32},
    { 1384, 320, 56},
    { 1272, 80, 152},
    { 1240, 136, 8},
    { 1232, 176, -32},
    { 1112, 248, 0},
    { 1016, 232, 24},
    { 1080, 208, 8},
    { 896, 200, -8},
    { 1176, 160, -80},
    // 26 seconds
    { 1000, 136, 112},
    { 1120, 216, -80},
    { 1296, 280, -152},
    { 1512, 344, -304},
    { 1280, 344, -336},
    { 1040, 184, -256},
    { 992, 648, -232},
    { 1016, 328, 24},
    { 1208, 384, 8},
    { 1136, 400, 64},
    { 1384, 480, 88},
    { 1232, 584, 80},
    { 1008, 648, 72},
    { 1256, 928, -80},
    { 1152, 576, -64},
    { 1192, 424, 56},
    { 1472, 544, 96},
    { 1592, 448, -8},
    { 1480, 296, 8},
    { 1328, 80, 168},
    { 1232, 200, 0},
    { 1136, 208, -8},
    { 1032, 256, -32},
    { 1120, 176, 40},
    { 1088, 192, 16},
    // 27 seconds
    { 816, 168, -72},
    { 1112, 112, -56},
    { 880, 120, 0},
    { 1176, 256, -80},
    { 1464, 288, -144},
    { 1688, 360, -184},
    { 1312, 352, -80},
    { 1008, 272, -176},
    { 1032, 296, -128},
    { 1160, 336, -80},
    { 1176, 400, -104},
    { 1088, 472, -80},
    { 1464, 576, 32},
    { 1272, 832, 184},
    { 1080, 872, -40},
    { 792, 712, -64},
    { 1168, 568, -88},
    { 1168, 528, 8},
    { 1480, 616, 112},
    { 1760, 448, 96},
    { 1576, 288, 112},
    { 1408, 144, 160},
    { 1320, 152, 64},
    { 1192, 200, 16},
    { 944, 248, 32},
    // 28 seconds
    { 904, 176, 32},
    { 1024, 184, -8},
    { 816, 160, -64},
    { 1040, 120, 8},
    { 1000, 192, -24},
    { 1232, 264, -88},
    { 1520, 304, -168},
    { 1608, 360, -208},
    { 1208, 312, -16},
    { 1016, 216, -136},
    { 1080, 296, -96},
    { 1224, 320, -64},
    { 1264, 392, -80},
    { 1184, 472, -32},
    { 1552, 592, -8},
    { 1280, 872, 112},
    { 760, 752, -144},
    { 1264, 584, -144},
    { 1032, 640, -112},
    { 1224, 560, -24},
    { 1432, 560, 56},
    { 1640, 416, 40},
    { 1512, 272, 48},
    { 1400, 152, 104},
    { 1344, 200, 40},
    // 29 seconds
    { 1272, 232, 8},
    { 1120, 248, 0},
    { 1024, 184, 24},
    { 1080, 168, -8},
    { 792, 136, -88},
    { 936, 80, -80},
    { 944, 168, -64},
    { 1168, 248, -88},
    { 1464, 320, -216},
    { 1608, 392, -280},
    { 1088, 328, -56},
    { 848, 152, -88},
    { 1016, 248, -96},
    { 1200, 312, -96},
    { 1288, 424, -144},
    { 1088, 464, -136},
    { 1376, 496, -80},
    { 1424, 720, 0},
    { 936, 656, -176},
    { 1552, 584, -128},
    { 968, 616, -200},
    { 1256, 528, -88},
    { 1344, 536, 0},
    { 1616, 464, 32},
    { 1448, 288, 16},
    // 30 seconds
    { 1240, 184, 64},
    { 1176, 168, 56},
    { 1184, 200, -16},
    { 1120, 232, -24},
    { 1000, 200, 8},
    { 1112, 176, 16},
    { 936, 192, -64},
    { 800, 136, -80},
    { 1096, 176, -96},
    { 984, 248, -80},
    { 1200, 280, -208},
    { 1584, 280, -272},
    { 1336, 280, -64},
    { 920, 192, -56},
    { 920, 200, -144},
    { 1096, 288, -112},
    { 1272, 368, -88},
    { 1192, 464, -112},
    { 1240, 488, -88},
    { 1568, 600, -88},
    { 1096, 792, 168},
    { 1384, 840, -224},
    { 1176, 456, -88},
    { 1064, 472, -152},
    { 1024, 560, -56},
    // 31 seconds
    { 1320, 568, -8},
    { 1344, 352, 32},
    { 1200, 208, 64},
    { 1208, 176, 64},
    { 1264, 216, 8},
    { 1256, 240, 48},
    { 1152, 224, 104},
    { 1248, 176, 88},
    { 1216, 216, 16},
    { 968, 216, -72},
    { 1192, 208, -168},
    { 912, 128, -152},
    { 936, 168, -176},
    { 1080, 176, -184},
    { 1296, 272, -328},
    { 1080, 248, -280},
    { 928, 224, -152},
    { 992, 248, -128},
    { 1112, 328, -128},
    { 1176, 424, -120},
    { 1232, 488, -80},
    { 1616, 592, -16},
    { 1256, 680, -8},
    { 1152, 584, 0},
    { 1040, 696, -120},
    // 32 seconds
    { 1136, 616, -80},
    { 1208, 528, -24},
    { 1368, 552, 24},
    { 1464, 448, 16},
    { 1312, 304, 48},
    { 1208, 80, 128},
    { 1216, 144, -16},
    { 1184, 192, -56},
    { 1048, 248, -16},
    { 1096, 200, 16},
    { 1112, 200, -32},
    { 856, 192, -136},
    { 1256, 120, -88},
    { 976, 136, -48},
    { 1120, 256, -144},
    { 1344, 256, -200},
    { 1376, 296, -200},
    { 1048, 264, -40},
    { 880, 208, -112},
    { 984, 296, -96},
    { 1152, 328, -24},
    { 1224, 424, -64},
    { 1096, 456, -64},
    { 1504, 520, -56},
    { 1376, 704, -24},
    // 33 seconds
    { 1024, 672, -120},
    { 1352, 680, -224},
    { 1024, 584, -184},
    { 1128, 504, -88},
    { 1408, 552, -8},
    { 1624, 424, 0},
    { 1424, 256, 24},
    { 1224, 80, 144},
    { 1248, 144, 8},
    { 1160, 216, -72},
    { 1000, 256, -40},
    { 1040, 192, -8},
    { 1056, 184, -40},
    { 800, 184, -144},
    { 1176, 128, -72},
    { 904, 168, -64},
    { 1184, 232, -136},
    { 1368, 224, -160},
    { 1520, 272, -128},
    { 1168, 272, -80},
    { 912, 256, -160},
    { 984, 320, -96},
    { 1136, 320, -24},
    { 1216, 384, -16},
    { 1136, 456, -32},
    // 34 seconds
    { 1496, 544, 8},
    { 1488, 752, 80},
    { 944, 696, -96},
    { 1480, 584, -48},
    { 960, 616, -144},
    { 1040, 544, -88},
    { 1216, 616, -16},
    { 1472, 568, 0},
    { 1400, 408, 64},
    { 1328, 232, 160},
    { 1328, 72, 128},
    { 1312, 112, 48},
    { 1176, 216, 16},
    { 1024, 224, 0},
    { 1056, 216, -8},
    { 968, 224, -80},
    { 872, 160, -96},
    { 1120, 152, -88},
    { 1080, 152, -88},
    { 1208, 232, -168},
    { 1464, 264, -216},
    { 1200, 272, -144},
    { 880, 216, -96},
    { 912, 256, -136},
    { 1072, 288, -32},
    // 35 seconds
    { 1256, 352, 24},
    { 1176, 464, -8},
    { 1248, 496, 8},
    { 1632, 592, -8},
    { 1128, 664, 24},
    { 1328, 624, -72},
    { 992, 712, -144},
    { 1184, 640, -128},
    { 1072, 544, -48},
    { 1248, 544, -48},
    { 1368, 400, -8},
    { 1280, 208, 80},
    { 1256, 88, 104},
    { 1360, 168, -8},
    { 1280, 224, 8},
    { 1144, 240, 40},
    { 1200, 224, -8},
    { 1048, 232, -88},
    { 792, 104, -112},
    { 1176, 32, 8},
    { 920, 96, 40},
    { 1272, 280, -136},
    { 1448, 288, -176},
    { 1416, 352, -216},
    { 960, 296, -56},
    // 36 seconds
    { 840, 192, -80},
    { 1000, 264, 24},
    { 1232, 328, -8},
    { 1304, 480, -96},
    { 1304, 528, -16},
    { 1528, 584, 16},
    { 1096, 696, 176},
    { 1128, 768, -80},
    { 1024, 624, -208},
    { 1104, 560, -56},
    { 1184, 568, 32},
    { 1624, 568, 32},
    { 1560, 408, -32},
    { 1168, 248, 40},
    { 1040, 168, 80},
    { 1104, 160, 8},
    { 1192, 216, 0},
    { 1288, 192, 64},
    { 1504, 152, 104},
    { 1176, 160, 56},
    { 1064, 160, -16},
    { 1040, 56, -40},
    { 888, 216, -160},
    { 1008, 280, -136},
    { 1232, 216, -192},
    // 37 seconds
    { 1384, 232, -160},
    { 1144, 232, -112},
    { 1072, 248, -120},
    { 1184, 328, -96},
    { 1312, 368, -120},
    { 1304, 448, -128},
    { 1272, 512, -32},
    { 1520, 800, 64},
    { 1112, 808, -24},
    { 1032, 640, -8},
    { 704, 832, -104},
    { 1208, 592, -24},
    { 1336, 600, 40},
    { 1632, 608, 128},
    { 1688, 424, 144},
    { 1552, 168, 192},
    { 1344, 96, 104},
    { 1256, 120, 32},
    { 1168, 208, -16},
    { 1008, 232, -16},
    { 1088, 184, 24},
    { 952, 160, -96},
    { 784, 80, -64},
    { 1072, 120, -72},
    { 1120, 216, -144},
    // 38 seconds
    { 1224, 264, -160},
    { 1696, 288, -232},
    { 1480, 328, -168},
    { 1096, 224, -112},
    { 1016, 224, -160},
    { 1128, 288, -112},
    { 1264, 336, -120},
    { 1216, 440, -112},
    { 1168, 504, -72},
    { 1480, 656, 0},
    { 1072, 800, -48},
    { 1144, 600, -40},
    { 1032, 760, -152},
    { 1320, 624, -88},
    { 1280, 520, 32},
    { 1592, 504, 80},
    { 1600, 352, 96},
    { 1400, 256, 96},
    { 1288, 184, 104},
    { 1256, 208, 8},
    { 1168, 232, 8},
    { 1024, 208, 40},
    { 1056, 144, 24},
    { 1024, 160, -8},
    { 800, 144, -80},
    // 39 seconds
    { 1120, 136, -104},
    { 960, 208, -128},
    { 1152, 272, -96},
    { 1472, 328, -280},
    { 1616, 400, -288},
    { 1136, 280, -72},
    { 968, 144, -104},
    { 992, 248, -104},
    { 1136, 304, -104},
    { 1176, 400, -104},
    { 1072, 448, -80},
    { 1248, 496, -48},
    { 1504, 648, -48},
    { 960, 752, 16},
    { 1424, 616, -112},
    { 952, 600, -160},
    { 1240, 592, -80},
    { 1272, 576, 0},
    { 1544, 520, 56},
    { 1520, 368, 80},
    { 1392, 232, 128},
    { 1352, 152, 112},
    { 1336, 184, 72},
    { 1256, 240, 56},
    { 1064, 224, 72},
    // 40 seconds
    { 1080, 184, 40},
    { 976, 184, 8},
    { 744, 176, -80},
    { 888, 144, -88},
    { 944, 208, -232},
    { 904, 192, -80},
    { 1232, 232, -96},
    { 1624, 392, -352},
    { 1408, 464, -344},
    { 1016, 240, -48},
    { 976, 144, -32},
    { 1152, 192, -48},
    { 1304, 272, -128},
    { 1176, 472, -192},
    { 1192, 528, -128},
    { 1368, 608, -64},
    { 1208, 768, 56},
    { 960, 528, -168},
    { 1264, 416, -64},
    { 1160, 608, -112},
    { 1256, 672, -64},
    { 1136, 624, -32},
    { 1312, 552, 24},
    { 1440, 432, 128},
    { 1336, 256, 192},
    // 41 seconds
    { 1352, 160, 168},
    { 1352, 184, 152},
    { 1400, 256, 160},
    { 1288, 272, 152},
    { 1192, 232, 192},
    { 1136, 224, 160},
    { 960, 208, 32},
    { 752, 240, -136},
    { 936, 264, -352},
    { 752, 232, -328},
    { 656, 40, 0},
    { 1024, 88, -312},
    { 1288, 224, -704},
    { 1384, 248, -520},
    { 1392, 120, -328},
    { 1408, 128, -296},
    { 1408, 200, -448},
    { 1352, 264, -560},
    { 1128, 448, -368},
    { 1256, 552, -176},
    { 1288, 448, -128},
    { 920, 328, -80},
    { 1328, 528, -32},
    { 1008, 808, -24},
    { 840, 888, -56},
    // 42 seconds
    { 1104, 432, 120},
    { 1376, 424, 232},
    { 1464, 352, 168},
    { 1416, 240, 128},
    { 1400, 184, 160},
    { 1376, 240, 128},
    { 1336, 280, 40},
    { 1232, 248, 64},
    { 1272, 192, 48},
    { 1224, 168, -80},
    { 992, 128, -136},
    { 1128, 168, -256},
    { 952, 72, -392},
    { 896, 144, -400},
    { 968, 40, -280},
    { 1256, 80, -328},
    { 1304, 168, -352},
    { 1272, 256, -312},
    { 1168, 312, -224},
    { 1120, 288, -264},
    { 1112, 336, -288},
    { 1064, 416, -304},
    { 1128, 480, -176},
    { 1384, 584, -104},
    { 1136, 528, -104},
    // 43 seconds
    { 1016, 512, -16},
    { 1128, 688, -88},
    { 984, 696, -104},
    { 1168, 488, 8},
    { 1344, 488, 144},
    { 1600, 400, 136},
    { 1528, 248, 104},
    { 1376, 152, 80},
    { 1272, 128, 24},
    { 1232, 208, -40},
    { 1088, 232, -48},
    { 936, 208, -56},
    { 1064, 192, -96},
    { 992, 216, -232},
    { 992, 184, -216},
    { 1048, 176, -232},
    { 1024, 128, -112},
    { 1112, 176, -216},
    { 1328, 224, -216},
    { 1344, 264, -144},
    { 1136, 280, -104},
    { 1096, 304, -136},
    { 1168, 336, -72},
    { 1248, 352, -72},
    { 1184, 384, -104},
    // 44 seconds
    { 1032, 400, -96},
    { 1352, 480, -16},
    { 1280, 616, 64},
    { 1032, 632, -40},
    { 1320, 680, -56},
    { 1112, 648, -144},
    { 936, 504, -88},
    { 1088, 576, 16},
    { 1376, 584, 8},
    { 1408, 456, 88},
    { 1408, 288, 232},
    { 1464, 16, 200},
    { 1400, 88, 56},
    { 1224, 152, 72},
    { 1008, 232, 96},
    { 1080, 248, 64},
    { 1064, 272, 8},
    { 880, 240, -32},
    { 1264, 264, -112},
    { 1008, 120, -144},
    { 1072, 176, -168},
    { 1256, 144, -248},
    { 1248, 184, -272},
    { 1000, 176, -176},
    { 840, 208, -208},
    // 45 seconds
    { 872, 232, -176},
    { 1000, 264, -128},
    { 1096, 328, -96},
    { 1088, 400, -88},
    { 1416, 472, -64},
    { 1608, 608, -112},
    { 1096, 568, -16},
    { 1464, 640, -104},
    { 912, 736, -192},
    { 1072, 504, -128},
    { 1136, 480, -32},
    { 1440, 512, -40},
    { 1480, 448, -40},
    { 1352, 320, 136},
    { 1216, 0, 200},
    { 1184, 104, -8},
    { 1056, 128, -24},
    { 976, 240, -24},
    { 944, 208, 8},
    { 1104, 216, 8},
    { 992, 232, -64},
    { 1160, 248, -136},
    { 1216, 288, -200},
    { 1040, 216, -88},
    { 1112, 208, -168},
    // 46 seconds
    { 1328, 224, -248},
    { 1200, 224, -72},
    { 1024, 216, -80},
    { 984, 280, -176},
    { 968, 320, -112},
    { 1008, 328, -88},
    { 1024, 328, -88},
    { 944, 352, -120},
    { 1288, 416, -136},
    { 1528, 488, -128},
    { 1104, 448, -24},
    { 1488, 520, -112},
    { 824, 640, -216},
    { 976, 560, -136},
    { 1064, 464, 0},
    { 1264, 464, 24},
    { 1328, 360, 8},
    { 1256, 272, 40},
    { 1280, 200, 40},
    { 1320, 192, 0},
    { 1272, 200, -24},
    { 1104, 200, -24},
    { 1088, 160, -32},
    { 1192, 184, -40},
    { 968, 216, -144},
    // 47 seconds
    { 1240, 192, -112},
    { 1000, 208, -96},
    { 1016, 232, -136},
    { 1080, 216, -240},
    { 1144, 240, -152},
    { 1016, 240, -64},
    { 912, 240, -144},
    { 896, 280, -112},
    { 1024, 312, -48},
    { 1248, 344, -64},
    { 1144, 384, -104},
    { 1120, 384, -72},
    { 1536, 448, -64},
    { 1200, 496, 0},
    { 1328, 552, 80},
    { 1040, 664, -176},
    { 968, 544, -136},
    { 848, 504, -56},
    { 1048, 576, -32},
    { 1200, 472, -16},
    { 1160, 312, 48},
    { 1192, 160, 64},
    { 1272, 144, 16},
    { 1288, 200, -24},
    { 1192, 224, -32},
    // 48 seconds
    { 1112, 224, -16},
    { 1256, 216, -32},
    { 1088, 232, -120},
    { 1296, 176, -120},
    { 1080, 152, -224},
    { 1024, 144, -192},
    { 920, 160, -216},
    { 1064, 168, -184},
    { 1032, 200, -144},
    { 936, 232, -120},
    { 912, 264, -96},
    { 960, 296, -56},
    { 1056, 328, -24},
    { 1056, 352, -64},
    { 992, 352, -96},
    { 1328, 424, -88},
    { 1488, 512, -96},
    { 1128, 504, -16},
    { 1448, 600, -152},
    { 920, 592, -248},
    { 888, 448, -160},
    { 944, 512, -56},
    { 1200, 536, -72},
    { 1280, 424, -24},
    { 1248, 256, 64},
    // 49 seconds
    { 1264, 104, 80},
    { 1240, 160, 8},
    { 1176, 200, -16},
    { 1056, 248, -8},
    { 1136, 248, 8},
    { 1256, 264, -16},
    { 1120, 224, -64},
    { 1424, 88, -48},
    { 1016, 0, 32},
    { 1064, 104, -120},
    { 1064, 160, -184},
    { 1136, 200, -224},
    { 1000, 200, -256},
    { 912, 200, -240},
    { 920, 224, -192},
    { 952, 288, -168},
    { 992, 344, -152},
    { 1056, 360, -152},
    { 1120, 344, -128},
    { 1568, 432, -144},
    { 1224, 480, -152},
    { 1216, 480, -96},
    { 1112, 624, -248},
    { 936, 512, -240},
    { 1144, 432, -128},
    // 50 seconds
    { 1304, 472, -56},
    { 1384, 424, -32},
    { 1328, 272, 32},
    { 1216, 136, 72},
    { 1208, 136, 16},
    { 1208, 176, -32},
    { 1096, 216, -32},
    { 920, 200, -32},
    { 952, 200, -48},
    { 992, 224, -120},
    { 848, 216, -176},
    { 1328, 200, -128},
    { 1024, 152, -8},
    { 1240, 216, -128},
    { 1440, 256, -184},
    { 1392, 296, -104},
    { 1072, 264, -112},
    { 880, 256, -168},
    { 912, 304, -72},
    { 1040, 328, -8},
    { 1144, 360, 0},
    { 1064, 408, -48},
    { 1024, 408, -80},
    { 1440, 472, -96},
    { 1240, 528, -88},
    // 51 seconds
    { 1136, 512, 16},
    { 1224, 720, -176},
    { 1032, 648, -264},
    { 1024, 432, -56},
    { 1240, 520, 24},
    { 1448, 448, 16},
    { 1376, 320, 32},
    { 1272, 168, 96},
    { 1264, 160, 72},
    { 1232, 192, 16},
    { 1144, 232, 24},
    { 984, 208, 56},
    { 1152, 192, 0},
    { 1080, 208, -48},
    { 1152, 152, -8},
    { 1096, 200, -80},
    { 1080, 200, -128},
    { 1000, 232, -216},
    { 1168, 232, -216},
    { 1168, 232, -136},
    { 1080, 224, -88},
    { 1048, 296, -128},
    { 1024, 304, -88},
    { 1040, 328, -88},
    { 1112, 352, -80},
    // 52 seconds
    { 1080, 368, -56},
    { 1544, 408, -8},
    { 1528, 544, -128},
    { 1296, 552, -32},
    { 1232, 800, -256},
    { 776, 640, -328},
    { 944, 296, -56},
    { 1040, 384, 8},
    { 1368, 352, -48},
    { 1336, 256, -56},
    { 1256, 224, -24},
    { 1264, 248, 16},
    { 1280, 264, 8},
    { 1248, 288, 24},
    { 1208, 240, 64},
    { 1280, 208, 32},
    { 1056, 200, 0},
    { 1072, 160, -8},
    { 1120, 176, -88},
    { 880, 208, -120},
    { 856, 216, -192},
    { 1080, 200, -200},
    { 1240, 240, -144},
    { 1096, 248, -80},
    { 968, 256, -112},
    // 53 seconds
    { 1016, 296, -120},
    { 1104, 320, -56},
    { 1224, 368, -24},
    { 1256, 408, 8},
    { 1592, 440, 0},
    { 1448, 608, -104},
    { 1104, 680, -72},
    { 1296, 872, -328},
    { 856, 536, -248},
    { 896, 448, -160},
    { 1072, 544, -128},
    { 1576, 520, -64},
    { 1600, 152, 136},
    { 1328, -72, 40},
    { 1120, 88, 32},
    { 1208, 128, 88},
    { 1248, 344, 56},
    { 1096, 336, 32},
    { 1176, 288, 0},
    { 1056, 288, -168},
    { 920, 216, -240},
    { 992, 144, -120},
    { 880, 72, -24},
    { 920, 184, -256},
    { 1200, 240, -304},
    // 54 seconds
    { 1456, 272, -184},
    { 1184, 288, -72},
    { 1000, 264, -176},
    { 1072, 280, -144},
    { 1184, 312, -80},
    { 1200, 360, -16},
    { 1048, 416, 24},
    { 1320, 448, 16},
    { 1416, 504, -80},
    { 1088, 552, 8},
    { 1416, 960, -176},
    { 1104, 624, -232},
    { 872, 416, -168},
    { 976, 552, -88},
    { 1344, 608, -80},
    { 1464, 392, 40},
    { 1376, 176, 104},
    { 1376, 56, 80},
    { 1360, 136, 32},
    { 1256, 224, 8},
    { 1024, 232, 16},
    { 960, 224, -16},
    { 1024, 208, -40},
    { 856, 208, -120},
    { 1160, 216, -144},
    // 55 seconds
    { 928, 208, -208},
    { 992, 224, -192},
    { 1320, 232, -240},
    { 1376, 248, -160},
    { 1112, 224, -136},
    { 928, 216, -152},
    { 1008, 272, -112},
    { 1144, 304, -72},
    { 1240, 368, -40},
    { 1128, 424, -8},
    { 1448, 480, -16},
    { 1528, 648, -112},
    { 1016, 688, -8},
    { 1352, 624, -216},
    { 896, 504, -160},
    { 968, 488, -136},
    { 1040, 544, -112},
    { 1248, 536, -80},
    { 1448, 408, -8},
    { 1392, 240, 48},
    { 1384, 104, 112},
    { 1408, 160, 32},
    { 1344, 184, 8},
    { 1120, 232, 24},
    { 912, 216, -24},
    // 56 seconds
    { 944, 216, -56},
    { 896, 232, -144},
    { 832, 176, -152},
    { 1160, 168, -192},
    { 952, 152, -56},
    { 1072, 216, -184},
    { 1376, 256, -280},
    { 1448, 280, -136},
    { 1224, 256, -24},
    { 1080, 272, -136},
    { 1040, 312, -96},
    { 1104, 328, -32},
    { 1192, 360, -16},
    { 1032, 384, -24},
    { 1136, 408, -48},
    { 1432, 488, 8},
    { 1136, 592, 176},
    { 1024, 752, -72},
    { 1264, 776, -72},
    { 1168, 528, -96},
    { 968, 472, -80},
    { 1120, 584, -48},
    { 1456, 616, -32},
    { 1480, 440, 112},
    { 1472, 264, 232},
    // 57 seconds
    { 1448, 48, 168},
    { 1464, 104, 56},
    { 1256, 144, 88},
    { 1104, 192, 88},
    { 1040, 200, 56},
    { 952, 224, 40},
    { 872, 232, -24},
    { 920, 240, -136},
    { 904, 192, -232},
    { 968, 216, -192},
    { 1008, 208, -136},
    { 1296, 216, -272},
    { 1512, 224, -192},
    { 1312, 272, -88},
    { 1096, 304, -184},
    { 1072, 320, -168},
    { 1168, 328, -104},
    { 1200, 384, -64},
    { 1104, 384, -88},
    { 1520, 480, -40},
    { 1464, 608, 24},
    { 1032, 696, 32},
    { 1208, 672, -192},
    { 864, 512, -152},
    { 864, 536, -80},
    // 58 seconds
    { 1064, 608, 16},
    { 1456, 536, 40},
    { 1448, 336, 96},
    { 1344, 168, 128},
    { 1312, 112, 112},
    { 1304, 176, 64},
    { 1208, 232, 40},
    { 1096, 256, 40},
    { 1224, 232, -8},
    { 1104, 232, -16},
    { 1048, 184, -56},
    { 1144, 96, -96},
    { 936, 16, 16},
    { 1144, 168, -216},
    { 1240, 240, -232},
    { 1152, 216, -176},
    { 936, 192, -152},
    { 896, 232, -104},
    { 1056, 336, -152},
    { 1120, 304, -24},
    { 1128, 392, -40},
    { 1088, 408, -56},
    { 1512, 488, -32},
    { 1256, 584, 24},
    { 1192, 600, -24},
    // 59 seconds
    { 1176, 664, -120},
    { 1000, 560, -120},
    { 904, 456, -64},
    { 1080, 520, -32},
    { 1232, 448, -56},
    { 1152, 304, 8},
    { 1224, 144, 56},
    { 1320, 136, 16},
    { 1320, 176, -8},
    { 1152, 224, -16},
    { 1072, 224, 16},
    { 1208, 256, -32},
    { 1040, 248, -104},
    { 1256, 136, -120},
    { 800, -56, 48},
    { 1032, 104, -88},
    { 1280, 208, -152},
    { 1288, 256, -96},
    { 976, 240, -176},
    { 856, 192, -192},
    { 904, 240, -88},
    { 1024, 272, -24},
    { 1144, 328, -32},
    { 1104, 368, -40},
    { 1616, 432, -16},
    // 60 seconds
    // elapsed: 1 minutes
    { 1520, 624, 16},
    { 1104, 872, -40},
    { 1248, 576, -208},
    { 992, 456, -112},
    { 1016, 536, -104},
    { 1072, 592, -56},
    { 1216, 552, -40},
    { 1168, 416, 48},
    { 1192, 288, 96},
    { 1352, 120, 112},
    { 1400, 104, 72},
    { 1296, 136, 8},
    { 1072, 200, 0},
    { 1128, 184, -8},
    { 1064, 232, -24},
    { 1112, 176, -56},
    { 800, 232, -208},
    { 736, 200, -224},
    { 968, 208, -280},
    { 1416, 224, -272},
    { 1296, 192, -72},
    { 1008, 200, -64},
    { 896, 248, -160},
    { 912, 272, -120},
    { 1064, 296, -96},
    // 61 seconds
    { 1072, 352, -128},
    { 984, 368, -144},
    { 1464, 408, -144},
    { 1616, 496, -144},
    { 1360, 528, -96},
    { 1248, 736, -256},
    { 784, 480, -312},
    { 896, 320, -120},
    { 936, 416, -48},
    { 1256, 408, -40},
    { 1312, 304, -56},
    { 1136, 224, -32},
    { 1128, 176, 32},
    { 1200, 224, 16},
    { 1184, 224, 0},
    { 1040, 216, -32},
    { 1048, 208, -24},
    { 1072, 240, -136},
    { 984, 232, -184},
    { 1280, 200, -160},
    { 1040, 144, -48},
    { 1072, 208, -224},
    { 1248, 224, -208},
    { 1192, 248, -112},
    { 1016, 224, -104},
    // 62 seconds
    { 904, 264, -176},
    { 872, 272, -112},
    { 984, 296, -72},
    { 1040, 328, -56},
    { 1016, 368, -80},
    { 1216, 384, -112},
    { 1576, 464, -136},
    { 1176, 440, -40},
    { 1616, 544, -184},
    { 920, 640, -248},
    { 896, 464, -216},
    { 880, 448, -64},
    { 1176, 472, -56},
    { 1312, 312, -32},
    { 1240, 176, 8},
    { 1184, 112, 32},
    { 1248, 224, -8},
    { 1232, 224, -16},
    { 1136, 248, 8},
    { 1056, 208, 0},
    { 1112, 208, -48},
    { 960, 232, -152},
    { 1072, 200, -96},
    { 992, 208, -176},
    { 952, 200, -104},
    // 63 seconds
    { 1000, 256, -224},
    { 1280, 336, -344},
    { 1176, 264, -96},
    { 976, 136, 0},
    { 920, 192, -88},
    { 928, 272, -104},
    { 1024, 344, -152},
    { 1008, 304, -96},
    { 968, 304, -72},
    { 1040, 320, -96},
    { 1176, 392, -160},
    { 1224, 448, -152},
    { 1080, 440, -112},
    { 1608, 552, -232},
    { 1040, 600, -232},
    { 1136, 504, -192},
    { 1128, 528, -136},
    { 1256, 544, -16},
    { 1664, 776, -176},
    { 1616, 704, 24},
    { 1512, 624, 40},
    { 1416, 672, -128},
    { 1200, 688, -88},
    { 928, 600, -176},
    { 728, 648, -232},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:15:22 local
AccelRawData *activity_sample_walk_100_pbl_25298_6(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25298_6
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 45
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 8, 88, -1064},
    { -40, 0, -960},
    { 0, 128, -992},
    { -16, 16, -1032},
    { 200, 8, -1088},
    { 0, 80, -1048},
    { -24, 72, -1016},
    { -32, 64, -1064},
    { -8, 56, -1064},
    { 240, -216, -1056},
    { -24, 88, -1088},
    { -8, 64, -1040},
    { 16, 96, -984},
    { 0, -24, -1072},
    { -144, 88, -1040},
    { 8, -72, -1040},
    { 40, -64, -976},
    { -24, 80, -1000},
    { 16, 184, -976},
    { 8, 176, -1048},
    { -16, 128, -1000},
    { -32, 152, -1088},
    { 0, 160, -1096},
    { 72, 128, -1080},
    { 72, 64, -1048},
    // 1 seconds
    { 48, 56, -1040},
    { 112, -8, -1040},
    { 72, 8, -1064},
    { 144, 16, -1080},
    { 0, 224, -1016},
    { 32, 48, -1032},
    { 8, 104, -1032},
    { 8, 168, -1040},
    { 96, 120, -1016},
    { 24, 40, -1016},
    { 48, 40, -1032},
    { 104, 0, -1016},
    { 120, -8, -1040},
    { 128, -16, -1048},
    { 128, -24, -1048},
    { 128, 0, -1056},
    { 120, -16, -1056},
    { 104, -24, -1016},
    { 128, -16, -1008},
    { 8, -16, -1016},
    { 64, -16, -1024},
    { 0, -40, -1024},
    { 56, -48, -1032},
    { 8, -48, -1048},
    { 96, -56, -1032},
    // 2 seconds
    { 72, -24, -1048},
    { 32, -16, -1024},
    { 32, -16, -1032},
    { 56, -16, -1024},
    { 40, -16, -1024},
    { 48, -8, -1016},
    { 56, -8, -1032},
    { 32, 8, -1056},
    { 16, 32, -1056},
    { 56, -8, -1048},
    { 64, 8, -1048},
    { 72, 0, -1056},
    { 64, 0, -1032},
    { 56, -8, -1040},
    { 136, -96, -1040},
    { 112, -48, -1040},
    { 40, 32, -1056},
    { 80, 16, -1072},
    { 8, -56, -1048},
    { 24, -32, -1048},
    { -40, -8, -1040},
    { 24, -56, -1016},
    { -16, 32, -1008},
    { -48, -32, -976},
    { -48, 40, -952},
    // 3 seconds
    { -8, 40, -1040},
    { 72, -40, -1088},
    { 80, -16, -1080},
    { 96, -88, -1056},
    { 200, 56, -936},
    { 120, 80, -960},
    { 48, -80, -1008},
    { -24, 56, -1064},
    { -24, -72, -992},
    { -8, -72, -1064},
    { -40, -8, -1144},
    { -32, -160, -968},
    { -24, -120, -920},
    { -32, -72, -1128},
    { -136, -56, -1080},
    { -128, -64, -1000},
    { -40, -72, -968},
    { -88, -176, -992},
    { -80, -120, -1080},
    { -56, -48, -1120},
    { -72, -8, -1136},
    { -80, 56, -1272},
    { -32, 200, -1360},
    { -8, 224, -1232},
    { -80, 184, -976},
    // 4 seconds
    { -128, 248, -928},
    { -136, 256, -864},
    { -64, 200, -880},
    { -56, 152, -888},
    { -88, 128, -896},
    { -104, 72, -912},
    { -120, 16, -904},
    { -128, 0, -976},
    { -128, -48, -952},
    { -120, -88, -992},
    { -128, -104, -1128},
    { -80, -176, -1176},
    { -16, -296, -1192},
    { -56, -232, -1200},
    { -48, -176, -1224},
    { 24, -128, -1264},
    { 176, -24, -1240},
    { 200, 0, -960},
    { 272, 32, -824},
    { 336, 24, -816},
    { 368, 112, -768},
    { 288, -8, -792},
    { 288, -168, -880},
    { 312, -224, -848},
    { 296, -96, -616},
    // 5 seconds
    { 376, 128, -424},
    { 360, 856, -224},
    { -248, 1456, 520},
    { -464, 2016, 304},
    { 1288, 328, -328},
    { 280, 24, 1752},
    { 480, 1272, 896},
    { 344, 1608, 704},
    { 208, 1984, 632},
    { 592, 1192, 864},
    { 2208, -1984, -808},
    { 2176, -784, 1200},
    { 1240, 2400, 1432},
    { 464, 1160, -704},
    { 936, 600, 864},
    { 800, 1832, 616},
    { 1680, 1104, 168},
    { 1416, 944, 840},
    { 1312, 624, 816},
    { 1440, 8, 248},
    { 1696, 272, -504},
    { 1592, 408, -640},
    { 1464, 240, -472},
    { 1048, 136, -552},
    { 736, 72, -664},
    // 6 seconds
    { 616, -88, -728},
    { 552, -56, -656},
    { 472, -56, -720},
    { 344, -104, -640},
    { 160, -152, -576},
    { 48, -96, -656},
    { -48, -72, -752},
    { -112, -16, -864},
    { -168, 8, -952},
    { -208, -32, -984},
    { -56, -56, -1184},
    { 40, -296, -1376},
    { 232, -704, -1856},
    { 88, 672, -248},
    { -520, 288, 1456},
    { -840, 568, 1320},
    { -472, 1144, 216},
    { 504, 440, -728},
    { 88, 688, 1072},
    { -648, 3280, 2720},
    { -1200, 4000, 4000},
    { 2744, -3888, 0},
    { 600, -880, -1688},
    { 144, -32, -952},
    { 464, 1384, -1376},
    // 7 seconds
    { 208, 296, -1464},
    { 224, -336, -1176},
    { 328, 120, -1208},
    { 416, 288, -1072},
    { 464, 200, -968},
    { 368, -56, -784},
    { 360, 40, -816},
    { 280, 152, -888},
    { 176, 64, -816},
    { 56, 0, -728},
    { -48, -24, -744},
    { -80, 56, -864},
    { -80, 56, -960},
    { -96, 16, -1000},
    { -128, 8, -1032},
    { -96, -40, -1136},
    { -184, 40, -1184},
    { -184, 224, -1240},
    { -96, 376, -1304},
    { -64, 296, -1144},
    { -104, 224, -920},
    { -16, 328, -928},
    { 120, 312, -1032},
    { 120, 112, -936},
    { 16, 48, -800},
    // 8 seconds
    { -24, 104, -824},
    { -24, 80, -904},
    { 24, 104, -1032},
    { 80, 48, -1104},
    { 104, 40, -1120},
    { 144, -8, -1152},
    { 48, -24, -1112},
    { 144, 56, -1152},
    { 256, 176, -1008},
    { 360, 136, -720},
    { 448, 56, -464},
    { 608, 80, -336},
    { 752, 96, -328},
    { 888, 120, -320},
    { 1032, 176, -160},
    { 1408, 304, 8},
    { 1736, 456, 216},
    { 1864, 640, 304},
    { 1704, 736, -8},
    { 1704, 664, -48},
    { 1840, 688, 24},
    { 1584, 568, 64},
    { 1160, 320, -56},
    { 1144, 520, -128},
    { 792, 1016, -192},
    // 9 seconds
    { 736, 1016, -168},
    { 832, 560, -8},
    { 1000, 560, -48},
    { 1296, 432, -40},
    { 1376, 264, 40},
    { 1536, 168, 56},
    { 1584, 160, -8},
    { 1472, 248, -24},
    { 1256, 272, 40},
    { 1144, 264, 48},
    { 1376, 288, 8},
    { 1104, 280, 32},
    { 1072, 120, 8},
    { 1080, -64, 96},
    { 968, 16, -24},
    { 1096, 216, -224},
    { 1160, 160, -160},
    { 1048, 152, -56},
    { 936, 128, -136},
    { 936, 208, -200},
    { 1048, 280, -120},
    { 1200, 424, -32},
    { 1264, 416, 0},
    { 1176, 512, 8},
    { 1536, 536, -16},
    // 10 seconds
    { 1312, 664, -32},
    { 1280, 688, -120},
    { 1152, 656, -160},
    { 1096, 504, -168},
    { 952, 464, -128},
    { 1128, 504, -96},
    { 1312, 464, -72},
    { 1184, 328, -32},
    { 1152, 200, 16},
    { 1216, 136, 16},
    { 1232, 176, -24},
    { 1120, 216, -32},
    { 1016, 216, -48},
    { 1048, 224, -80},
    { 928, 240, -112},
    { 992, 192, -88},
    { 1096, 120, -8},
    { 1272, 192, 8},
    { 1208, 312, -144},
    { 1272, 320, -112},
    { 1176, 240, -32},
    { 1032, 200, -128},
    { 928, 200, -144},
    { 936, 392, -88},
    { 1040, 280, -16},
    // 11 seconds
    { 1056, 368, -16},
    { 968, 400, -48},
    { 1432, 472, -8},
    { 1608, 744, 32},
    { 920, 960, -264},
    { 1272, 384, -64},
    { 968, 560, -144},
    { 1160, 600, -152},
    { 1112, 576, -32},
    { 1304, 544, -16},
    { 1344, 368, 24},
    { 1288, 232, 96},
    { 1344, 152, 104},
    { 1376, 144, 48},
    { 1224, 208, 16},
    { 1008, 224, -8},
    { 1024, 224, -24},
    { 960, 256, -56},
    { 768, 176, -64},
    { 1088, 120, 8},
    { 1024, 160, 32},
    { 1216, 272, -120},
    { 1392, 312, -200},
    { 1608, 344, -288},
    { 1256, 336, -312},
    // 12 seconds
    { 864, 176, -192},
    { 864, 280, -264},
    { 896, 400, -216},
    { 952, 248, -192},
    { 1088, 296, -240},
    { 1312, 304, -440},
    { 1632, 520, -344},
    { 1280, 560, -184},
    { 1296, 544, -216},
    { 1008, 488, -184},
    { 912, 440, -96},
    { 872, 456, 112},
    { 1136, 448, 128},
    { 1168, 328, 176},
    { 1152, 288, 56},
    { 1128, 200, 112},
    { 1088, 208, 16},
    { 1088, 232, -88},
    { 1024, 264, -88},
    { 1040, 288, -64},
    { 1256, 272, -168},
    { 1136, 200, -440},
    { 1360, 88, -320},
    { 1048, -72, -256},
    { 1176, 8, -344},
    // 13 seconds
    { 1168, 128, -472},
    { 1208, 128, -280},
    { 1184, 168, -184},
    { 1048, 240, -160},
    { 1016, 296, -176},
    { 976, 312, -96},
    { 984, 320, -56},
    { 1008, 336, -80},
    { 952, 384, -128},
    { 1040, 392, -96},
    { 1400, 448, -48},
    { 1112, 528, -96},
    { 1328, 600, 16},
    { 936, 744, -200},
    { 1016, 448, -120},
    { 992, 400, 8},
    { 1288, 488, 72},
    { 1488, 408, 40},
    { 1384, 312, 24},
    { 1296, 208, 104},
    { 1296, 160, 8},
    { 1208, 160, -96},
    { 1048, 152, -56},
    { 928, 160, -32},
    { 992, 176, -88},
    // 14 seconds
    { 992, 224, -144},
    { 944, 240, -168},
    { 1304, 240, -136},
    { 1120, 200, -136},
    { 1144, 208, -184},
    { 1320, 208, -160},
    { 1208, 256, 16},
    { 1072, 248, -72},
    { 928, 272, -120},
    { 976, 344, -56},
    { 1064, 352, -16},
    { 1080, 360, -16},
    { 1056, 368, -48},
    { 1192, 400, -40},
    { 1608, 504, -32},
    { 1144, 576, 56},
    { 1376, 672, -72},
    { 944, 704, -256},
    { 936, 480, -160},
    { 912, 488, -40},
    { 1168, 560, -16},
    { 1392, 424, -8},
    { 1272, 248, 32},
    { 1216, 152, 64},
    { 1288, 144, 0},
    // 15 seconds
    { 1288, 192, -32},
    { 1136, 224, -8},
    { 1104, 208, 0},
    { 1224, 216, -32},
    { 1000, 224, -104},
    { 1240, 160, -104},
    { 944, 96, -40},
    { 1024, 160, -232},
    { 1128, 176, -240},
    { 1304, 184, -192},
    { 1112, 192, -144},
    { 888, 208, -128},
    { 928, 288, -168},
    { 1024, 360, -96},
    { 1104, 400, -48},
    { 1048, 408, -32},
    { 1200, 392, 16},
    { 1616, 472, -80},
    { 1168, 512, -64},
    { 1392, 600, -112},
    { 1120, 832, -352},
    { 952, 480, -256},
    { 968, 424, -88},
    { 1224, 520, -88},
    { 1440, 408, -16},
    // 16 seconds
    { 1352, 184, 72},
    { 1176, -32, 96},
    { 1160, 152, -32},
    { 1104, 168, 0},
    { 1048, 264, 8},
    { 992, 240, 56},
    { 1192, 216, 56},
    { 1064, 216, -16},
    { 984, 224, -64},
    { 1144, 288, -152},
    { 1048, 216, -248},
    { 1032, 232, -352},
    { 1184, 184, -320},
    { 1088, 136, -192},
    { 904, 112, -200},
    { 824, 184, -152},
    { 888, 280, -120},
    { 992, 328, -80},
    { 1096, 360, -48},
    { 1096, 384, -32},
    { 1416, 392, -8},
    { 1552, 520, -64},
    { 1176, 576, 48},
    { 1480, 744, 0},
    { 608, 1008, -312},
    // 17 seconds
    { 944, 368, -96},
    { 896, 480, -32},
    { 1232, 608, -16},
    { 1344, 472, -32},
    { 1256, 232, 32},
    { 1184, 48, 64},
    { 1168, 80, 8},
    { 1280, 168, -24},
    { 1136, 280, 8},
    { 1136, 256, -16},
    { 1168, 248, -64},
    { 960, 232, -136},
    { 1264, 144, -24},
    { 1000, 152, -104},
    { 1016, 264, -240},
    { 1064, 344, -376},
    { 1104, 336, -336},
    { 864, 160, -56},
    { 744, 24, -40},
    { 768, 96, -56},
    { 872, 224, -64},
    { 1072, 376, -104},
    { 1080, 424, -152},
    { 1240, 360, -192},
    { 1680, 400, -224},
    // 18 seconds
    { 1304, 464, -120},
    { 1664, 864, -216},
    { 920, 672, -448},
    { 1048, 240, -104},
    { 808, 440, -24},
    { 1024, 496, -24},
    { 1056, 352, -56},
    { 968, 264, -48},
    { 960, 256, -24},
    { 1088, 296, -8},
    { 1216, 320, 0},
    { 1160, 264, -8},
    { 1176, 184, -56},
    { 1352, 168, -176},
    { 1176, 192, -392},
    { 1128, 144, -280},
    { 1224, 152, -432},
    { 792, 88, -288},
    { 800, 176, -320},
    { 1176, 256, -344},
    { 1088, 272, -304},
    { 872, 152, -104},
    { 744, 184, -64},
    { 832, 232, -40},
    { 1016, 304, -40},
    // 19 seconds
    { 1168, 384, -96},
    { 1016, 368, -72},
    { 1128, 384, -72},
    { 1360, 464, -128},
    { 1160, 464, -104},
    { 1480, 488, 8},
    { 1136, 680, -208},
    { 1056, 520, -200},
    { 920, 432, -40},
    { 1048, 480, -48},
    { 1024, 416, -96},
    { 1032, 240, -16},
    { 1072, 96, 72},
    { 1096, 128, -40},
    { 1096, 200, -48},
    { 1040, 248, -16},
    { 1024, 232, -16},
    { 1248, 240, -40},
    { 1048, 232, -88},
    { 1408, 168, -8},
    { 1168, 168, -48},
    { 1128, 192, -184},
    { 1144, 184, -216},
    { 1112, 160, -208},
    { 816, 128, -152},
    // 20 seconds
    { 664, 152, -176},
    { 688, 216, -152},
    { 768, 248, -136},
    { 896, 272, -112},
    { 952, 312, -112},
    { 1144, 328, -88},
    { 1640, 424, -144},
    { 1232, 464, -104},
    { 1488, 472, -8},
    { 1168, 712, -264},
    { 872, 576, -264},
    { 944, 360, -64},
    { 1072, 480, -32},
    { 1216, 424, -80},
    { 1120, 256, -48},
    { 1064, 152, 8},
    { 1104, 160, -16},
    { 1168, 216, -56},
    { 1088, 256, -32},
    { 1032, 240, -16},
    { 1152, 224, -48},
    { 1232, 240, -128},
    { 1104, 192, -128},
    { 1336, 160, -128},
    { 920, 128, -64},
    // 21 seconds
    { 928, 224, -240},
    { 1136, 232, -280},
    { 1072, 224, -160},
    { 896, 160, -136},
    { 776, 200, -160},
    { 824, 256, -112},
    { 928, 296, -96},
    { 1016, 312, -80},
    { 1040, 328, -96},
    { 1168, 336, -144},
    { 1568, 400, -160},
    { 1280, 376, -48},
    { 1528, 416, -24},
    { 1056, 600, -248},
    { 824, 680, -176},
    { 760, 552, -152},
    { 1008, 424, 32},
    { 1176, 400, -8},
    { 1144, 296, -24},
    { 1128, 224, -48},
    { 1240, 208, -32},
    { 1288, 240, -16},
    { 1232, 280, -24},
    { 1112, 240, -16},
    { 1216, 208, -56},
    // 22 seconds
    { 1192, 216, -168},
    { 1112, 136, -88},
    { 1224, 32, -80},
    { 960, 72, -96},
    { 1024, 160, -184},
    { 1112, 160, -136},
    { 1064, 192, -72},
    { 944, 216, -104},
    { 912, 264, -128},
    { 920, 280, -64},
    { 1016, 312, -40},
    { 1128, 344, -16},
    { 1072, 384, 24},
    { 1256, 392, -16},
    { 1504, 504, -112},
    { 1104, 520, -32},
    { 1480, 616, -112},
    { 928, 648, -224},
    { 1080, 376, -128},
    { 992, 440, -16},
    { 1184, 464, -56},
    { 1216, 400, -120},
    { 1128, 280, -24},
    { 1072, 88, 88},
    { 1104, 152, -24},
    // 23 seconds
    { 1056, 184, 0},
    { 1008, 248, -8},
    { 960, 264, -32},
    { 1176, 280, 8},
    { 1112, 248, 16},
    { 1352, 168, 48},
    { 1320, 128, 8},
    { 1088, 136, -80},
    { 1104, 144, -168},
    { 1104, 120, -96},
    { 1008, 144, -96},
    { 880, 200, -160},
    { 856, 256, -104},
    { 976, 296, -64},
    { 1080, 336, -16},
    { 1096, 392, 16},
    { 1176, 432, 0},
    { 1696, 512, 16},
    { 1296, 616, 72},
    { 1200, 592, -40},
    { 1152, 640, -104},
    { 832, 592, -184},
    { 888, 512, -80},
    { 1144, 592, -16},
    { 1376, 464, 0},
    // 24 seconds
    { 1256, 288, 72},
    { 1224, 152, 80},
    { 1312, 144, 64},
    { 1328, 232, 32},
    { 1256, 264, 40},
    { 1176, 240, 56},
    { 1208, 208, 8},
    { 1080, 208, -64},
    { 968, 128, -64},
    { 1096, 80, -120},
    { 880, 168, -136},
    { 912, 232, -200},
    { 1112, 272, -312},
    { 1176, 312, -224},
    { 968, 184, -136},
    { 872, 184, -120},
    { 960, 256, -112},
    { 1096, 296, -136},
    { 1120, 344, -88},
    { 1024, 360, -24},
    { 1304, 400, 8},
    { 1520, 488, -16},
    { 1160, 528, 144},
    { 1568, 624, -128},
    { 920, 624, -136},
    // 25 seconds
    { 968, 448, -72},
    { 968, 488, -8},
    { 1112, 504, -80},
    { 1128, 400, -96},
    { 1096, 248, -8},
    { 1152, 136, 32},
    { 1240, 192, -8},
    { 1184, 216, -16},
    { 1040, 240, 8},
    { 1128, 216, 24},
    { 1176, 232, -40},
    { 928, 216, -88},
    { 1344, 48, 16},
    { 1040, 24, 88},
    { 1184, 184, -112},
    { 1224, 176, -152},
    { 1144, 216, -168},
    { 856, 160, -104},
    { 736, 176, -136},
    { 848, 248, -128},
    { 1008, 288, -48},
    { 1168, 360, -32},
    { 1096, 440, -88},
    { 1392, 504, -136},
    { 1520, 632, -120},
    // 26 seconds
    { 1048, 560, -24},
    { 1472, 480, -128},
    { 920, 568, -200},
    { 1048, 504, -128},
    { 1064, 456, -32},
    { 1304, 432, -16},
    { 1264, 352, -40},
    { 1152, 240, 24},
    { 1144, 160, 64},
    { 1224, 192, 8},
    { 1192, 224, 40},
    { 1032, 240, 24},
    { 1040, 184, 24},
    { 1168, 216, -56},
    { 864, 232, -64},
    { 1224, 200, -72},
    { 936, 168, -104},
    { 944, 224, -160},
    { 1160, 248, -240},
    { 1240, 280, -192},
    { 1016, 240, -64},
    { 856, 208, -136},
    { 888, 264, -128},
    { 1040, 288, -96},
    { 1096, 344, -136},
    // 27 seconds
    { 1064, 376, -184},
    { 1392, 416, -144},
    { 1576, 536, -200},
    { 1136, 600, -72},
    { 1424, 624, -320},
    { 1008, 392, -176},
    { 1016, 408, -112},
    { 1104, 416, -64},
    { 1256, 400, -80},
    { 1144, 296, -64},
    { 1048, 232, -8},
    { 1096, 216, 8},
    { 1200, 240, 8},
    { 1216, 216, 0},
    { 1032, 200, 16},
    { 1168, 192, -16},
    { 1088, 224, -88},
    { 1088, 200, -72},
    { 1104, 192, -176},
    { 936, 200, -120},
    { 888, 264, -216},
    { 1128, 336, -352},
    { 1104, 264, -216},
    { 896, 168, -80},
    { 800, 152, -112},
    // 28 seconds
    { 864, 200, -112},
    { 1008, 272, -96},
    { 1072, 344, -160},
    { 1032, 344, -128},
    { 1432, 384, -128},
    { 1680, 504, -208},
    { 1264, 536, -136},
    { 1392, 704, -232},
    { 896, 472, -328},
    { 896, 312, -128},
    { 888, 424, -64},
    { 1192, 448, -80},
    { 1240, 336, -80},
    { 1184, 216, -24},
    { 1184, 144, 24},
    { 1232, 200, -8},
    { 1184, 232, -32},
    { 1032, 240, -48},
    { 1024, 224, -48},
    { 1080, 248, -144},
    { 976, 216, -184},
    { 1176, 168, -144},
    { 992, 152, -96},
    { 952, 176, -160},
    { 1136, 200, -264},
    // 29 seconds
    { 1224, 192, -120},
    { 1104, 216, -72},
    { 952, 240, -168},
    { 912, 312, -104},
    { 936, 360, -88},
    { 992, 368, -48},
    { 1024, 376, -48},
    { 1096, 384, -32},
    { 1592, 448, 0},
    { 1312, 544, -32},
    { 1312, 576, 0},
    { 1112, 688, -224},
    { 992, 496, -216},
    { 848, 408, -72},
    { 1040, 504, -40},
    { 1288, 448, -56},
    { 1224, 248, 16},
    { 1096, 120, 56},
    { 1112, 120, 0},
    { 1168, 184, -40},
    { 1072, 248, -24},
    { 1008, 248, 16},
    { 1208, 224, 8},
    { 1136, 248, -104},
    { 1128, 224, -96},
    // 30 seconds
    { 1288, 208, -192},
    { 896, 112, -24},
    { 960, 184, -184},
    { 1128, 224, -240},
    { 1104, 232, -160},
    { 936, 216, -152},
    { 864, 240, -152},
    { 944, 280, -112},
    { 1032, 328, -104},
    { 1096, 376, -88},
    { 1056, 384, -112},
    { 1472, 440, -136},
    { 1440, 512, -112},
    { 1104, 472, -8},
    { 1464, 656, -216},
    { 856, 640, -232},
    { 1016, 400, -96},
    { 1096, 464, 8},
    { 1376, 440, -16},
    { 1344, 312, 8},
    { 1232, 144, 80},
    { 1152, 152, 40},
    { 1160, 176, 16},
    { 1120, 216, -24},
    { 984, 208, 32},
    // 31 seconds
    { 1144, 192, 16},
    { 1128, 224, -88},
    { 896, 232, -160},
    { 1312, 224, -168},
    { 976, 168, -152},
    { 952, 216, -184},
    { 1104, 208, -288},
    { 1128, 216, -176},
    { 968, 184, -80},
    { 880, 232, -128},
    { 936, 288, -96},
    { 1024, 336, -64},
    { 1184, 368, -80},
    { 1104, 376, -88},
    { 1344, 400, -72},
    { 1544, 512, -136},
    { 1104, 544, -40},
    { 1416, 656, -160},
    { 976, 552, -176},
    { 1008, 408, -128},
    { 936, 448, -64},
    { 1072, 448, -32},
    { 1152, 408, -32},
    { 1064, 288, 0},
    { 1072, 208, 48},
    // 32 seconds
    { 1136, 200, 24},
    { 1168, 192, 8},
    { 1096, 200, 24},
    { 1040, 184, 8},
    { 1256, 232, -8},
    { 1048, 248, -88},
    { 1200, 192, -112},
    { 1136, 112, -168},
    { 944, 120, -120},
    { 1080, 192, -264},
    { 1224, 184, -240},
    { 1080, 168, -136},
    { 888, 192, -192},
    { 832, 248, -184},
    { 904, 280, -128},
    { 984, 312, -64},
    { 1040, 344, -72},
    { 1008, 376, -56},
    { 1464, 448, -56},
    { 1464, 592, -80},
    { 1096, 584, 40},
    { 1504, 712, -160},
    { 888, 544, -168},
    { 944, 424, -104},
    { 1032, 520, -24},
    // 33 seconds
    { 1304, 504, -8},
    { 1272, 312, 24},
    { 1160, 192, 64},
    { 1168, 160, 48},
    { 1248, 200, 0},
    { 1216, 224, 24},
    { 1112, 208, 32},
    { 1152, 192, 8},
    { 1120, 216, -64},
    { 960, 224, -176},
    { 1152, 176, -160},
    { 912, 160, -192},
    { 880, 168, -96},
    { 1088, 224, -304},
    { 1288, 288, -256},
    { 1152, 264, -96},
    { 968, 232, -168},
    { 912, 288, -120},
    { 992, 312, -88},
    { 1120, 320, -64},
    { 1072, 360, -96},
    { 1104, 400, -120},
    { 1400, 480, -88},
    { 1280, 584, -72},
    { 1032, 632, -32},
    // 34 seconds
    { 1384, 608, -272},
    { 1016, 416, -120},
    { 952, 472, -40},
    { 1128, 480, 0},
    { 1416, 424, 0},
    { 1312, 312, 32},
    { 1192, 208, 96},
    { 1200, 200, 72},
    { 1192, 224, 40},
    { 1112, 216, 40},
    { 1048, 176, 56},
    { 1168, 176, 32},
    { 1208, 200, 24},
    { 960, 216, -56},
    { 1208, 232, -120},
    { 872, 240, -272},
    { 856, 232, -160},
    { 872, 232, -256},
    { 1144, 296, -392},
    { 1176, 264, -256},
    { 1024, 184, -120},
    { 992, 192, -144},
    { 1056, 264, -112},
    { 1152, 328, -152},
    { 1048, 360, -176},
    // 35 seconds
    { 984, 400, -160},
    { 1224, 480, -152},
    { 1448, 592, -128},
    { 1080, 648, -64},
    { 1488, 632, -232},
    { 1072, 424, -112},
    { 984, 472, -112},
    { 1024, 488, -40},
    { 1296, 456, 24},
    { 1376, 336, 64},
    { 1200, 240, 80},
    { 1208, 200, 104},
    { 1240, 232, 72},
    { 1216, 224, 88},
    { 1144, 200, 112},
    { 1112, 184, 88},
    { 1144, 216, 64},
    { 1048, 208, -16},
    { 928, 240, -168},
    { 1088, 256, -440},
    { 848, 144, -248},
    { 768, 80, -96},
    { 944, 136, -296},
    { 1272, 272, -440},
    { 1384, 288, -336},
    // 36 seconds
    { 1224, 248, -288},
    { 1072, 232, -216},
    { 1096, 272, -240},
    { 1128, 344, -248},
    { 1056, 376, -200},
    { 1000, 432, -136},
    { 1240, 560, -48},
    { 1264, 648, -32},
    { 952, 520, 0},
    { 1560, 528, -64},
    { 1184, 520, -72},
    { 1096, 480, -8},
    { 1120, 464, 80},
    { 1344, 400, 104},
    { 1312, 304, 80},
    { 1152, 216, 104},
    { 1136, 176, 104},
    { 1120, 224, 40},
    { 1104, 216, 80},
    { 1080, 192, 96},
    { 1128, 200, 48},
    { 1152, 224, -16},
    { 944, 224, -56},
    { 1072, 216, -128},
    { 1176, 216, -352},
    // 37 seconds
    { 904, 144, -152},
    { 1040, 136, -224},
    { 1240, 240, -456},
    { 1192, 256, -352},
    { 1080, 168, -336},
    { 992, 168, -288},
    { 1064, 248, -264},
    { 1104, 336, -280},
    { 1064, 376, -200},
    { 944, 416, -128},
    { 1232, 464, -16},
    { 1320, 496, 16},
    { 1056, 440, 8},
    { 1384, 576, -40},
    { 1032, 688, -88},
    { 896, 544, -40},
    { 1072, 520, 144},
    { 1360, 480, 112},
    { 1288, 272, 120},
    { 1208, 144, 112},
    { 1288, 136, 56},
    { 1312, 216, 8},
    { 1288, 248, 0},
    { 1176, 216, 24},
    { 1272, 208, -80},
    // 38 seconds
    { 1024, 224, -184},
    { 1064, 144, -184},
    { 1056, 80, -240},
    { 824, 88, -88},
    { 816, 184, -152},
    { 1096, 232, -272},
    { 1248, 304, -248},
    { 1136, 240, -136},
    { 1032, 224, -72},
    { 1088, 288, -104},
    { 1096, 328, -104},
    { 1112, 384, -152},
    { 1016, 376, -80},
    { 1344, 416, -88},
    { 1608, 448, -184},
    { 1128, 440, -128},
    { 1480, 592, -280},
    { 928, 680, -240},
    { 920, 408, -208},
    { 992, 392, -56},
    { 1264, 408, -56},
    { 1312, 320, -64},
    { 1200, 208, -16},
    { 1200, 152, 16},
    { 1288, 200, -8},
    // 39 seconds
    { 1256, 216, -40},
    { 1056, 208, -16},
    { 1096, 216, -32},
    { 1056, 240, -160},
    { 960, 232, -256},
    { 1232, 128, -176},
    { 984, 80, -32},
    { 1016, 152, -176},
    { 1120, 192, -224},
    { 1208, 264, -192},
    { 1080, 240, -168},
    { 952, 224, -136},
    { 952, 280, -96},
    { 1040, 328, -80},
    { 1144, 376, -104},
    { 1112, 408, -112},
    { 1144, 424, -120},
    { 1448, 488, -104},
    { 1208, 544, -48},
    { 1368, 584, -72},
    { 1048, 616, -176},
    { 896, 472, -184},
    { 968, 456, -56},
    { 1216, 472, 24},
    { 1456, 400, 24},
    // 40 seconds
    { 1304, 272, 56},
    { 1264, 136, 96},
    { 1232, 112, 16},
    { 1184, 176, -56},
    { 1032, 208, -40},
    { 880, 184, -64},
    { 928, 176, -48},
    { 1080, 216, -104},
    { 1000, 240, -160},
    { 1328, 240, -120},
    { 1120, 216, -104},
    { 1112, 240, -168},
    { 1224, 224, -160},
    { 1168, 240, -56},
    { 1032, 232, -128},
    { 880, 256, -152},
    { 888, 280, -96},
    { 928, 296, -88},
    { 952, 312, -104},
    { 952, 320, -136},
    { 1120, 368, -176},
    { 1728, 464, -120},
    { 1360, 520, -88},
    { 1272, 528, -16},
    { 1008, 616, -184},
    // 41 seconds
    { 872, 480, -184},
    { 872, 416, -32},
    { 1032, 464, 16},
    { 1272, 400, 8},
    { 1280, 312, 0},
    { 1176, 224, 32},
    { 1216, 200, 16},
    { 1224, 208, -32},
    { 1160, 200, -48},
    { 1000, 176, -56},
    { 1136, 168, -88},
    { 1232, 208, -152},
    { 1024, 240, -208},
    { 1328, 224, -232},
    { 1040, 168, -152},
    { 1024, 192, -168},
    { 1072, 192, -208},
    { 1072, 184, -88},
    { 984, 224, -128},
    { 896, 256, -128},
    { 912, 288, -56},
    { 992, 320, -24},
    { 1112, 352, -16},
    { 1144, 376, -56},
    { 1176, 376, -104},
    // 42 seconds
    { 1688, 488, -160},
    { 1176, 512, -56},
    { 1424, 568, 24},
    { 944, 720, -200},
    { 1056, 496, -160},
    { 904, 480, -80},
    { 1112, 528, -48},
    { 1264, 448, 0},
    { 1192, 280, 16},
    { 1200, 176, 48},
    { 1264, 176, 0},
    { 1304, 208, -24},
    { 1216, 192, -48},
    { 1096, 160, 0},
    { 1256, 192, -96},
    { 1000, 232, -200},
    { 984, 192, -144},
    { 1144, 216, -328},
    { 872, 160, -80},
    { 928, 200, -112},
    { 1160, 248, -240},
    { 1216, 312, -184},
    { 1016, 256, -112},
    { 928, 224, -112},
    { 968, 264, -72},
    // 43 seconds
    { 1112, 320, -88},
    { 1216, 360, -152},
    { 1088, 384, -176},
    { 1352, 488, -208},
    { 1456, 648, -184},
    { 1032, 576, -80},
    { 1464, 600, -232},
    { 824, 432, -176},
    { 1016, 464, -120},
    { 1128, 512, -16},
    { 1416, 464, 24},
    { 1360, 280, 40},
    { 1248, 168, 72},
    { 1272, 128, 48},
    { 1272, 200, -8},
    { 1152, 248, -48},
    { 920, 232, -56},
    { 1040, 192, -72},
    { 1024, 208, -168},
    { 848, 216, -240},
    { 1248, 168, -256},
    { 928, 120, -56},
    { 1040, 176, -160},
    { 1264, 224, -288},
    { 1288, 272, -160},
    // 44 seconds
    { 1104, 248, -104},
    { 984, 240, -184},
    { 992, 288, -120},
    { 1088, 320, -96},
    { 1136, 352, -112},
    { 1008, 376, -136},
    { 1312, 400, -96},
    { 1432, 496, -88},
    { 1104, 552, 32},
    { 1456, 800, -128},
    { 968, 584, -208},
    { 912, 352, -48},
    { 1000, 456, 16},
    { 1296, 472, 8},
    { 1320, 352, 0},
    { 1208, 208, 64},
    { 1224, 152, 64},
    { 1272, 160, -16},
    { 1224, 192, -40},
    { 1064, 184, -48},
    { 1128, 192, -24},
    { 1216, 240, -136},
    { 960, 232, -176},
    { 1232, 176, -160},
    { 864, 144, -120},
    // 45 seconds
    { 944, 216, -208},
    { 984, 240, -328},
    { 1160, 208, -160},
    { 1056, 136, 8},
    { 960, 136, -152},
    { 912, 144, -208},
    { 976, 192, -136},
    { 1080, 296, -72},
    { 1104, 384, -120},
    { 1184, 440, -104},
    { 1520, 552, -88},
    { 1312, 656, -16},
    { 1336, 840, 32},
    { 1096, 496, -16},
    { 856, 368, -24},
    { 856, 456, -16},
    { 1128, 560, 0},
    { 1280, 424, -8},
    { 1208, 264, 48},
    { 1192, 192, 48},
    { 1296, 200, 8},
    { 1304, 216, -8},
    { 1160, 208, -16},
    { 1152, 192, -16},
    { 1312, 232, -176},
    // 46 seconds
    { 1008, 224, -256},
    { 1216, 120, -176},
    { 960, 104, -80},
    { 880, 136, -128},
    { 1016, 184, -232},
    { 1248, 256, -208},
    { 1120, 232, -104},
    { 1008, 232, -104},
    { 1000, 280, -104},
    { 1032, 320, -64},
    { 1096, 360, -40},
    { 1112, 376, -32},
    { 1240, 376, -24},
    { 1568, 448, -40},
    { 1176, 512, -8},
    { 1440, 616, 0},
    { 968, 912, -232},
    { 936, 432, -144},
    { 944, 400, -24},
    { 1216, 528, -32},
    { 1320, 408, -64},
    { 1248, 224, 8},
    { 1248, 56, 104},
    { 1280, 192, -8},
    { 1264, 200, -8},
    // 47 seconds
    { 1128, 240, 8},
    { 1176, 192, -8},
    { 1200, 208, -56},
    { 1016, 200, -120},
    { 1232, 168, -88},
    { 904, 160, -88},
    { 904, 184, -96},
    { 1048, 192, -104},
    { 1192, 232, -80},
    { 1112, 256, -88},
    { 1008, 280, -128},
    { 1024, 320, -96},
    { 1104, 336, -48},
    { 1224, 352, -32},
    { 1264, 400, -24},
    { 1168, 472, -40},
    { 1432, 512, -56},
    { 1360, 560, -8},
    { 1152, 592, -8},
    { 1120, 712, -120},
    { 888, 608, -144},
    { 920, 496, -72},
    { 1112, 536, 8},
    { 1416, 472, 8},
    { 1336, 352, 80},
    // 48 seconds
    { 1328, 232, 120},
    { 1376, 160, 104},
    { 1352, 136, 48},
    { 1240, 168, 16},
    { 1024, 176, 8},
    { 1072, 200, 8},
    { 1064, 232, -88},
    { 912, 224, -136},
    { 1192, 208, -200},
    { 928, 136, -136},
    { 1000, 160, -80},
    { 1152, 200, -224},
    { 1296, 264, -184},
    { 1160, 256, -152},
    { 960, 248, -192},
    { 992, 272, -128},
    { 1056, 296, -96},
    { 1080, 336, -88},
    { 1024, 360, -64},
    { 1072, 352, -80},
    { 1528, 424, -56},
    { 1432, 528, -112},
    { 1264, 520, -24},
    { 1264, 656, -200},
    { 776, 520, -248},
    // 49 seconds
    { 872, 376, -80},
    { 1096, 456, 0},
    { 1336, 424, -48},
    { 1216, 320, -8},
    { 1168, 216, 56},
    { 1160, 184, 32},
    { 1168, 184, 40},
    { 1088, 176, 32},
    { 1016, 168, 8},
    { 1096, 192, 16},
    { 1168, 208, -16},
    { 1120, 216, -32},
    { 1296, 232, -80},
    { 1136, 192, -136},
    { 1016, 224, -256},
    { 1120, 216, -248},
    { 1120, 192, -168},
    { 928, 168, -224},
    { 800, 208, -184},
    { 840, 240, -152},
    { 896, 280, -160},
    { 920, 312, -128},
    { 936, 336, -144},
    { 1216, 352, -104},
    { 1792, 472, -152},
    // 50 seconds
    { 1248, 504, -88},
    { 1488, 528, -112},
    { 912, 488, -176},
    { 960, 392, -152},
    { 896, 416, -48},
    { 1104, 416, 0},
    { 1176, 352, -16},
    { 1064, 264, -8},
    { 1032, 192, 8},
    { 1072, 184, -32},
    { 1120, 208, -56},
    { 1072, 216, -64},
    { 1000, 184, -40},
    { 1144, 208, -64},
    { 1256, 240, -128},
    { 1272, 232, -120},
    { 1296, 216, -200},
    { 1072, 152, -128},
    { 1032, 176, -200},
    { 1088, 144, -128},
    { 1048, 184, -120},
    { 872, 216, -192},
    { 768, 240, -144},
    { 800, 264, -112},
    { 872, 280, -96},
    // 51 seconds
    { 952, 304, -72},
    { 1056, 320, -48},
    { 1208, 352, -96},
    { 1632, 448, -200},
    { 1232, 480, -208},
    { 1240, 472, -96},
    { 1096, 656, -272},
    { 1016, 568, -240},
    { 1008, 376, -88},
    { 1088, 432, -32},
    { 1240, 392, -56},
    { 1168, 288, -40},
    { 1136, 184, 8},
    { 1176, 176, -24},
    { 1200, 224, -56},
    { 1120, 216, -16},
    { 1064, 168, -8},
    { 1200, 184, -24},
    { 1104, 248, -176},
    { 1064, 176, -200},
    { 1328, 0, -160},
    { 1080, 32, -32},
    { 1240, 184, -256},
    { 1328, 168, -168},
    { 1128, 168, -88},
    // 52 seconds
    { 952, 184, -176},
    { 864, 264, -152},
    { 904, 272, -80},
    { 1056, 320, -32},
    { 1192, 368, -56},
    { 1192, 416, -88},
    { 1264, 448, -112},
    { 1384, 544, -112},
    { 1080, 608, 32},
    { 1392, 624, -152},
    { 904, 584, -216},
    { 1088, 520, -152},
    { 1088, 504, -8},
    { 1352, 488, 8},
    { 1448, 320, -8},
    { 1288, 200, 64},
    { 1272, 128, 88},
    { 1336, 184, 8},
    { 1296, 216, 8},
    { 1104, 208, 24},
    { 1032, 160, 8},
    { 1056, 200, -48},
    { 912, 216, -136},
    { 936, 208, -136},
    { 1152, 184, -128},
    // 53 seconds
    { 1096, 152, -8},
    { 1240, 216, -120},
    { 1416, 264, -184},
    { 1192, 280, -96},
    { 968, 216, -104},
    { 968, 280, -120},
    { 1088, 304, -72},
    { 1120, 352, -104},
    { 1056, 368, -120},
    { 1064, 376, -96},
    { 1456, 432, -96},
    { 1408, 480, -88},
    { 1080, 432, -40},
    { 1288, 544, -88},
    { 912, 744, -192},
    { 920, 704, -168},
    { 1048, 432, 24},
    { 1304, 456, 48},
    { 1520, 320, 40},
    { 1384, 224, 48},
    { 1376, 160, 72},
    { 1360, 192, 16},
    { 1288, 152, -112},
    { 1120, 88, -216},
    { 944, 24, 80},
    // 54 seconds
    { 1024, 200, -16},
    { 912, 344, -360},
    { 1008, 320, -344},
    { 936, 224, -336},
    { 1064, 168, -176},
    { 1272, 88, -120},
    { 1464, 176, -120},
    { 1232, 312, -176},
    { 944, 360, -192},
    { 848, 416, -64},
    { 936, 416, -56},
    { 1000, 360, -64},
    { 976, 368, -64},
    { 1056, 384, -32},
    { 1560, 472, 0},
    { 1344, 592, -144},
    { 1024, 768, -48},
    { 1384, 776, -104},
    { 880, 488, -56},
    { 928, 536, -96},
    { 1016, 600, 24},
    { 1248, 528, 144},
    { 1352, 344, 112},
    { 1256, 264, 64},
    { 1240, 192, 96},
    // 55 seconds
    { 1272, 248, 40},
    { 1272, 280, -24},
    { 1104, 224, -72},
    { 976, 168, -80},
    { 1096, 176, -184},
    { 1040, 176, -360},
    { 1088, 80, -320},
    { 1128, -24, -80},
    { 1080, 48, 0},
    { 1200, 248, -280},
    { 1352, 232, -256},
    { 1240, 224, -152},
    { 1064, 200, -208},
    { 1000, 264, -200},
    { 1072, 320, -192},
    { 1056, 368, -104},
    { 1040, 408, -88},
    { 1000, 336, -96},
    { 1192, 336, -48},
    { 1552, 448, -56},
    { 1184, 504, -80},
    { 984, 464, -24},
    { 1328, 584, -16},
    { 872, 744, -112},
    { 984, 544, -112},
    // 56 seconds
    { 1056, 440, 40},
    { 1296, 496, 56},
    { 1448, 416, 48},
    { 1384, 296, 104},
    { 1392, 160, 120},
    { 1360, 136, 32},
    { 1248, 168, -16},
    { 1056, 168, -16},
    { 960, 160, -24},
    { 1064, 184, -80},
    { 952, 224, -208},
    { 872, 200, -200},
    { 1216, 168, -256},
    { 1064, 168, -120},
    { 1152, 184, -184},
    { 1376, 208, -208},
    { 1240, 256, -64},
    { 1032, 224, -72},
    { 976, 264, -112},
    { 1024, 320, -48},
    { 1096, 336, -16},
    { 1112, 368, 0},
    { 1128, 384, 16},
    { 1240, 384, -48},
    { 1608, 496, -128},
    // 57 seconds
    { 1208, 528, -88},
    { 1496, 632, -40},
    { 888, 776, -280},
    { 928, 456, -200},
    { 840, 480, -88},
    { 1136, 544, -48},
    { 1328, 440, -8},
    { 1320, 272, 48},
    { 1360, 168, 80},
    { 1432, 152, 40},
    { 1384, 192, -32},
    { 1184, 216, -40},
    { 1000, 200, -72},
    { 1088, 192, -88},
    { 1000, 224, -272},
    { 920, 136, -320},
    { 1200, 24, -184},
    { 936, 72, -72},
    { 1128, 208, -160},
    { 1344, 248, -288},
    { 1232, 288, -128},
    { 992, 208, -72},
    { 912, 240, -120},
    { 1000, 296, -40},
    { 1080, 344, -16},
    // 58 seconds
    { 1104, 368, -8},
    { 1072, 384, -48},
    { 1184, 392, -72},
    { 1448, 496, -120},
    { 1120, 512, -88},
    { 1560, 624, -104},
    { 1056, 816, -240},
    { 1064, 408, -152},
    { 976, 408, -32},
    { 1264, 456, -24},
    { 1336, 360, -32},
    { 1272, 216, 24},
    { 1248, 152, 64},
    { 1248, 200, -24},
    { 1184, 216, -24},
    { 1064, 200, 8},
    { 1016, 176, 0},
    { 1160, 184, -16},
    { 1024, 224, -120},
    { 952, 208, -128},
    { 1168, 224, -192},
    { 960, 200, -112},
    { 1096, 232, -192},
    { 1424, 280, -336},
    { 1168, 272, -144},
    // 59 seconds
    { 904, 144, -96},
    { 848, 224, -136},
    { 920, 296, -104},
    { 1016, 336, -136},
    { 992, 352, -128},
    { 976, 328, -128},
    { 1288, 360, -104},
    { 1584, 464, -104},
    { 1128, 464, -48},
    { 1136, 488, -32},
    { 1224, 792, -208},
    { 944, 624, -192},
    { 1144, 416, 48},
    { 1296, 488, 40},
    { 1248, 392, -16},
    { 1096, 264, 48},
    { 1096, 176, 112},
    { 1248, 216, 32},
    { 1240, 248, 16},
    { 1216, 224, 72},
    { 1152, 168, 56},
    { 1176, 168, 16},
    { 1016, 168, 24},
    { 840, 200, -72},
    { 1192, 240, -136},
    // 60 seconds
    // elapsed: 1 minutes
    { 880, 256, -192},
    { 976, 280, -168},
    { 1216, 288, -344},
    { 1304, 288, -320},
    { 1024, 160, -112},
    { 816, 88, -96},
    { 880, 32, -168},
    { 1024, 488, -216},
    { 1064, 280, -120},
    { 1040, 328, -152},
    { 1016, 264, -112},
    { 1112, 368, -160},
    { 1312, 512, -200},
    { 1040, 560, -152},
    { 1480, 632, -184},
    { 1160, 712, -216},
    { 1160, 584, -160},
    { 1048, 472, -80},
    { 1288, 568, -72},
    { 1768, 640, -48},
    { 1808, 696, -24},
    { 1760, 496, -8},
    { 1680, 432, -144},
    { 1360, 560, -280},
    { 1024, 408, -280},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

