/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:25:55 local
AccelRawData *activity_sample_walk_200_pbl_25297_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25297_10
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 16, -56, -1016},
    { 0, -56, -1040},
    { 24, -48, -1048},
    { 32, -40, -1040},
    { 24, -48, -1040},
    { 8, -56, -1024},
    { 24, -48, -1032},
    { 16, -48, -1040},
    { 40, -48, -1040},
    { 48, -56, -1008},
    { 72, -96, -1056},
    { 104, -32, -1024},
    { 0, -72, -1016},
    { 72, 72, -1008},
    { -112, -56, -1064},
    { 24, 552, -1008},
    { 80, 0, -976},
    { 112, -16, -960},
    { 80, 304, -992},
    { 16, 480, -928},
    { -72, 464, -888},
    { -48, 736, -872},
    { 0, 712, -856},
    { 0, 496, -856},
    { 16, 560, -824},
    // 1 seconds
    { 0, 608, -776},
    { 48, 504, -776},
    { 96, 568, -760},
    { 64, 664, -728},
    { 56, 664, -728},
    { 32, 736, -688},
    { -16, 704, -576},
    { -64, 808, -544},
    { -96, 832, -528},
    { -144, 840, -440},
    { -120, 872, -472},
    { -104, 880, -496},
    { -16, 840, -520},
    { -8, 728, -464},
    { 8, 776, -432},
    { -8, 872, -432},
    { -8, 880, -392},
    { 64, 616, -360},
    { -8, 784, -376},
    { 48, 520, -432},
    { 104, 632, -328},
    { 224, 1168, -336},
    { -104, 992, -32},
    { 144, 968, -88},
    { 256, 1144, -272},
    // 2 seconds
    { 264, 968, -160},
    { 184, 680, -120},
    { 272, 720, -96},
    { 400, 688, -128},
    { 432, 560, -40},
    { 664, 584, 48},
    { 808, 520, 24},
    { 944, 392, 72},
    { 1200, 296, 112},
    { 1784, 224, 272},
    { 1832, 464, 312},
    { 1392, 720, -104},
    { 808, 680, -120},
    { 712, 248, 216},
    { 704, 144, 336},
    { 992, 128, 240},
    { 680, 256, 104},
    { 728, 312, -16},
    { 736, 272, -88},
    { 840, 200, 48},
    { 824, 312, 40},
    { 960, 472, -88},
    { 1216, 448, -40},
    { 1488, 304, 224},
    { 1712, 336, 320},
    // 3 seconds
    { 1472, 552, 16},
    { 624, 448, 120},
    { 712, 240, 32},
    { 912, -136, 376},
    { 848, 128, 240},
    { 760, 216, 128},
    { 648, 184, 72},
    { 664, 208, 24},
    { 688, 136, 88},
    { 736, 120, 16},
    { 848, 8, 88},
    { 1280, 120, 88},
    { 1672, 8, 296},
    { 1808, -24, 216},
    { 1224, 464, -224},
    { 784, 512, -296},
    { 632, 32, 0},
    { 720, 144, 112},
    { 616, 176, 128},
    { 776, 200, 112},
    { 824, 400, -136},
    { 744, 280, -40},
    { 824, 352, -64},
    { 984, 304, -16},
    { 1432, 384, -64},
    // 4 seconds
    { 1568, 192, 200},
    { 1920, 264, 136},
    { 1160, 384, 8},
    { 704, 216, -48},
    { 824, -464, 288},
    { 1048, -72, 216},
    { 768, 72, 264},
    { 688, 176, 72},
    { 704, 208, -48},
    { 680, 104, 96},
    { 680, 72, 88},
    { 704, 0, 104},
    { 1016, 8, 48},
    { 1456, 208, -24},
    { 1960, 144, 160},
    { 1496, 288, -104},
    { 832, 312, -136},
    { 872, 128, 0},
    { 752, 120, 104},
    { 648, 104, 128},
    { 672, 144, 104},
    { 776, 312, -72},
    { 752, 248, -16},
    { 768, 256, -48},
    { 912, 296, -24},
    // 5 seconds
    { 1152, 456, -160},
    { 1440, 392, -56},
    { 1776, 264, 80},
    { 1512, 296, 80},
    { 880, 328, 56},
    { 936, 232, 96},
    { 1128, 128, 264},
    { 1024, 120, 248},
    { 784, 152, 96},
    { 728, 88, 80},
    { 744, 64, 104},
    { 704, 80, 40},
    { 704, 8, 104},
    { 888, -16, 8},
    { 1136, 88, 8},
    { 1432, -32, 64},
    { 1656, 24, 216},
    { 1264, 344, -56},
    { 1104, 384, -192},
    { 816, 352, 8},
    { 664, 248, -40},
    { 696, 64, 144},
    { 768, 192, 128},
    { 832, 360, 16},
    { 824, 472, -152},
    // 6 seconds
    { 912, 440, -224},
    { 1128, 360, -192},
    { 1312, 288, -40},
    { 1864, 224, 168},
    { 1520, 264, 144},
    { 1016, 280, 64},
    { 608, 144, 160},
    { 1104, 88, 136},
    { 1024, 112, 184},
    { 824, 96, 176},
    { 680, 80, 88},
    { 744, 32, 88},
    { 752, 24, 112},
    { 720, 48, 40},
    { 792, -72, 112},
    { 1096, 48, 0},
    { 1272, -72, 224},
    { 1784, 192, 56},
    { 1200, 344, -248},
    { 976, 168, -104},
    { 1080, 144, 24},
    { 864, 72, 80},
    { 632, 416, -16},
    { 784, 264, 56},
    { 824, 272, 24},
    // 7 seconds
    { 816, 296, -136},
    { 872, 288, -184},
    { 968, 344, -232},
    { 1336, 328, -152},
    { 1792, 296, 168},
    { 1912, 464, 152},
    { 984, 360, 32},
    { 936, 152, 56},
    { 768, 56, 320},
    { 1080, 104, 144},
    { 920, 104, 152},
    { 808, 64, 104},
    { 792, 72, 96},
    { 688, 24, 64},
    { 632, 32, 56},
    { 648, -48, 32},
    { 856, -72, 32},
    { 1104, 0, 0},
    { 1808, -88, 296},
    { 1664, 208, 232},
    { 1240, 560, -216},
    { 1160, 400, -128},
    { 944, 352, 144},
    { 776, 208, 152},
    { 784, 144, 144},
    // 8 seconds
    { 800, 184, 136},
    { 840, 368, -16},
    { 768, 336, -48},
    { 936, 384, -40},
    { 1128, 496, -160},
    { 1392, 360, 120},
    { 2160, 408, 192},
    { 1240, 360, 120},
    { 976, 256, 56},
    { 1088, 216, 184},
    { 1264, 112, 160},
    { 1008, 24, 216},
    { 760, 24, 192},
    { 728, 56, 72},
    { 664, 48, 112},
    { 624, 24, 104},
    { 688, 0, 88},
    { 896, 32, 16},
    { 1112, 40, 32},
    { 1552, -128, 176},
    { 1752, 56, 264},
    { 1384, 408, -48},
    { 1064, 464, -192},
    { 872, 360, 8},
    { 704, 128, 32},
    // 9 seconds
    { 728, 104, 120},
    { 800, 240, 72},
    { 824, 360, 0},
    { 784, 400, -96},
    { 840, 368, -168},
    { 1160, 368, -152},
    { 1328, 376, -104},
    { 1696, 232, 136},
    { 1736, 400, 104},
    { 968, 344, 104},
    { 952, 216, 80},
    { 1136, 64, 288},
    { 1080, 104, 216},
    { 912, 176, 88},
    { 824, 112, 64},
    { 728, 80, 32},
    { 728, 32, 40},
    { 736, -16, 48},
    { 824, -72, 64},
    { 1000, 16, -16},
    { 1296, -112, 112},
    { 1656, 160, 120},
    { 1264, 480, -208},
    { 1072, 360, -104},
    { 1088, 312, 56},
    // 10 seconds
    { 824, 208, 176},
    { 760, 176, 152},
    { 800, 256, 120},
    { 816, 320, 72},
    { 816, 368, 16},
    { 1000, 368, -72},
    { 960, 344, -104},
    { 1152, 392, -144},
    { 1432, 296, 72},
    { 1696, 432, 112},
    { 1112, 424, 80},
    { 1000, 360, 48},
    { 1128, 168, 200},
    { 1104, 152, 240},
    { 960, 88, 224},
    { 792, 56, 152},
    { 800, 72, 104},
    { 768, 24, 120},
    { 792, 0, 96},
    { 856, -56, 96},
    { 968, 0, -16},
    { 976, -16, 8},
    { 1608, -88, 208},
    { 1360, 376, 64},
    { 1272, 448, -104},
    // 11 seconds
    { 1064, 440, -112},
    { 752, 272, 64},
    { 736, 176, 40},
    { 672, 448, 8},
    { 848, 456, -24},
    { 840, 488, -64},
    { 880, 336, -72},
    { 1032, 304, -120},
    { 1216, 328, -136},
    { 1360, 272, 32},
    { 1880, 336, 64},
    { 1128, 376, 56},
    { 984, 216, 96},
    { 1120, 144, 200},
    { 1144, 104, 240},
    { 952, 72, 264},
    { 744, 80, 128},
    { 696, 48, 112},
    { 656, 56, 24},
    { 648, 0, 40},
    { 784, -32, 48},
    { 1048, 40, -48},
    { 1168, -32, 0},
    { 1872, -64, 168},
    { 1416, 296, -40},
    // 12 seconds
    { 1040, 488, -288},
    { 1056, 136, -8},
    { 800, 200, 136},
    { 760, 256, 48},
    { 752, 264, 72},
    { 784, 256, 80},
    { 752, 344, -32},
    { 816, 368, -104},
    { 960, 384, -184},
    { 1328, 384, -344},
    { 1264, 408, -256},
    { 1896, 144, -56},
    { 1296, 192, -80},
    { 864, 280, -152},
    { 936, 272, -64},
    { 1088, 88, 120},
    { 920, 104, 152},
    { 768, 176, 80},
    { 720, 104, 96},
    { 728, 64, 48},
    { 736, 72, 32},
    { 816, 0, 64},
    { 1104, -16, 24},
    { 1152, 16, -8},
    { 1624, -104, 32},
    // 13 seconds
    { 1264, 40, 16},
    { 904, 224, -200},
    { 1200, 256, -176},
    { 912, 280, -24},
    { 696, 256, -80},
    { 696, 296, -32},
    { 752, 168, 16},
    { 856, 168, 24},
    { 856, 256, -104},
    { 968, 312, -168},
    { 1200, 304, -208},
    { 1304, 272, -160},
    { 1448, 216, 32},
    { 1608, 320, 16},
    { 864, 280, 0},
    { 912, 224, 16},
    { 1112, 56, 176},
    { 1024, 48, 192},
    { 848, 72, 120},
    { 752, 64, 80},
    { 760, 56, 16},
    { 752, 16, 48},
    { 728, -8, 16},
    { 840, -80, 8},
    { 1080, 0, -80},
    // 14 seconds
    { 1200, -152, 0},
    { 1680, -64, 96},
    { 1184, 248, -112},
    { 1328, 272, -168},
    { 1080, 376, -48},
    { 688, 240, 24},
    { 664, 136, 56},
    { 760, 136, 88},
    { 832, 232, 24},
    { 808, 304, -48},
    { 680, 400, -184},
    { 920, 384, -232},
    { 1248, 360, -176},
    { 1360, 224, -16},
    { 1760, 280, 56},
    { 1440, 408, 0},
    { 760, 280, -32},
    { 1032, 120, 96},
    { 1136, 80, 160},
    { 960, 72, 208},
    { 792, 112, 88},
    { 720, 56, 72},
    { 672, 32, 40},
    { 680, 32, 32},
    { 752, 24, -24},
    // 15 seconds
    { 976, -32, -32},
    { 1128, 8, -56},
    { 1376, -152, 8},
    { 1512, 40, 80},
    { 1256, 248, -24},
    { 1296, 312, -136},
    { 888, 424, -8},
    { 656, 96, 88},
    { 808, 144, 80},
    { 760, 216, 32},
    { 816, 336, -40},
    { 856, 352, -40},
    { 960, 400, -136},
    { 1032, 296, -96},
    { 1216, 280, -112},
    { 1376, 136, 80},
    { 1656, 248, 136},
    { 1096, 408, 16},
    { 1072, 296, 32},
    { 992, 208, 168},
    { 1080, 88, 224},
    { 888, 160, 104},
    { 784, 128, 72},
    { 760, 56, 72},
    { 752, 16, 40},
    // 16 seconds
    { 728, 16, 0},
    { 768, -8, -16},
    { 992, -56, -48},
    { 1120, -16, 0},
    { 1672, -104, -8},
    { 1560, 96, 64},
    { 984, 360, -168},
    { 1048, 184, -72},
    { 1200, 464, -16},
    { 776, 248, 208},
    { 744, 344, 32},
    { 808, 264, 120},
    { 792, 368, -64},
    { 808, 272, -48},
    { 920, 392, -208},
    { 1176, 432, -288},
    { 1344, 384, -216},
    { 1792, 192, -40},
    { 1592, 304, 32},
    { 896, 328, -8},
    { 912, 248, 48},
    { 1168, 104, 200},
    { 976, 160, 184},
    { 792, 128, 88},
    { 720, 80, 64},
    // 17 seconds
    { 736, 32, 96},
    { 720, 32, 40},
    { 720, 24, 48},
    { 896, 0, 32},
    { 1056, 56, -120},
    { 1160, -88, 0},
    { 1744, -112, 200},
    { 1176, 280, -64},
    { 1184, 328, -256},
    { 1096, 384, -112},
    { 696, 216, 16},
    { 720, 232, -32},
    { 776, 224, 40},
    { 848, 320, 0},
    { 800, 304, -48},
    { 888, 432, -168},
    { 1040, 448, -256},
    { 1232, 384, -184},
    { 1520, 128, -8},
    { 1704, 352, 64},
    { 992, 392, -24},
    { 872, 344, 8},
    { 1120, 192, 128},
    { 1024, 72, 224},
    { 832, 112, 176},
    // 18 seconds
    { 752, 152, 40},
    { 736, 72, 56},
    { 728, 32, 8},
    { 784, -8, -8},
    { 888, -72, 8},
    { 1160, 0, 0},
    { 1112, 0, -80},
    { 1760, -128, 144},
    { 1248, 216, -8},
    { 1112, 368, -208},
    { 1056, 352, -64},
    { 696, 200, 0},
    { 648, 232, -16},
    { 800, 248, 40},
    { 864, 288, 72},
    { 840, 320, 8},
    { 856, 384, -96},
    { 920, 384, -176},
    { 1152, 352, -200},
    { 1312, 256, -16},
    { 1928, 416, 64},
    { 1288, 512, -40},
    { 920, 352, -24},
    { 1088, 240, 112},
    { 1176, 168, 176},
    // 19 seconds
    { 976, 96, 168},
    { 776, 96, 72},
    { 768, 80, 64},
    { 792, 0, 56},
    { 736, 8, 56},
    { 768, -8, 40},
    { 936, -88, 48},
    { 1048, 32, -72},
    { 1360, -72, -88},
    { 1672, 8, -120},
    { 1240, 264, -280},
    { 1216, 304, -320},
    { 1192, 376, 40},
    { 792, 456, 40},
    { 688, 336, 96},
    { 784, 272, 136},
    { 776, 248, 136},
    { 776, 328, -40},
    { 832, 320, -120},
    { 976, 512, -232},
    { 1272, 496, -152},
    { 1312, 296, 72},
    { 1608, 312, 168},
    { 1216, 456, 104},
    { 904, 352, 48},
    // 20 seconds
    { 1144, 160, 160},
    { 1224, 128, 136},
    { 968, 64, 160},
    { 808, 104, 32},
    { 800, 48, -24},
    { 752, -16, 0},
    { 696, 8, -56},
    { 712, -40, -40},
    { 800, -80, -64},
    { 1088, 24, -128},
    { 1288, -80, -16},
    { 1784, 56, 72},
    { 1488, 376, -136},
    { 1256, 352, -128},
    { 1008, 456, -32},
    { 656, 208, 16},
    { 752, 112, 88},
    { 776, 200, 48},
    { 792, 272, 48},
    { 736, 360, -40},
    { 800, 416, -112},
    { 1024, 464, -176},
    { 1304, 456, -216},
    { 1520, 208, -40},
    { 1848, 192, -24},
    // 21 seconds
    { 1136, 288, -40},
    { 952, 272, 8},
    { 1144, 216, 64},
    { 1024, 120, 160},
    { 832, 88, 128},
    { 744, 96, 56},
    { 784, 56, 56},
    { 728, 40, 8},
    { 696, 32, -8},
    { 808, -32, 24},
    { 1128, 72, -128},
    { 1136, 40, -104},
    { 1688, -48, -16},
    { 1336, 264, -136},
    { 1000, 344, -352},
    { 1064, 248, -112},
    { 752, 240, 32},
    { 672, 168, 32},
    { 768, 216, 64},
    { 864, 312, 32},
    { 816, 296, -32},
    { 816, 328, -80},
    { 840, 408, -200},
    { 1192, 384, -224},
    { 1352, 336, -96},
    // 22 seconds
    { 1880, 480, -48},
    { 1320, 584, -96},
    { 800, 400, -120},
    { 1024, 264, 40},
    { 1184, 96, 0},
    { 976, 16, 208},
    { 776, 128, 40},
    { 768, 152, 0},
    { 712, 40, 32},
    { 672, 32, -40},
    { 776, -16, -56},
    { 960, -32, 0},
    { 1080, -24, -64},
    { 1664, -160, 16},
    { 1544, 248, -48},
    { 992, 496, -432},
    { 1240, 400, -168},
    { 1000, 432, -128},
    { 752, 144, 56},
    { 672, 280, -48},
    { 728, 248, 16},
    { 768, 352, -88},
    { 768, 288, -88},
    { 912, 384, -200},
    { 1240, 400, -120},
    // 23 seconds
    { 1288, 376, -144},
    { 1960, 288, -24},
    { 1424, 448, -40},
    { 832, 288, -24},
    { 1088, 240, 24},
    { 1136, 72, 168},
    { 920, 80, 152},
    { 808, 88, 56},
    { 776, 8, 80},
    { 776, 16, 40},
    { 784, -48, 16},
    { 832, -64, 8},
    { 992, -72, -56},
    { 1048, -64, -96},
    { 1480, -216, 40},
    { 1416, -8, 48},
    { 1240, 256, -184},
    { 1200, 352, -224},
    { 912, 320, -40},
    { 704, 184, 8},
    { 768, 232, 0},
    { 856, 232, 16},
    { 848, 336, -40},
    { 840, 344, -88},
    { 984, 432, -120},
    // 24 seconds
    { 1136, 408, -128},
    { 1200, 280, -40},
    { 1800, 248, 32},
    { 1416, 360, 32},
    { 1072, 352, 56},
    { 1240, 168, 200},
    { 1176, 120, 200},
    { 912, 152, 120},
    { 784, 136, 72},
    { 776, 32, 64},
    { 816, -32, 64},
    { 768, -32, 40},
    { 776, -80, 88},
    { 936, -112, 56},
    { 1056, 24, -56},
    { 1224, -168, -56},
    { 1424, -104, 80},
    { 1360, 184, -40},
    { 1296, 352, -168},
    { 1000, 424, -104},
    { 760, 184, 32},
    { 776, 152, 88},
    { 848, 240, 40},
    { 896, 328, 24},
    { 848, 392, -40},
    // 25 seconds
    { 904, 344, -72},
    { 1184, 488, -144},
    { 1240, 440, -104},
    { 1592, 344, -8},
    { 1504, 344, 16},
    { 976, 328, -24},
    { 1112, 256, 8},
    { 1272, 112, 168},
    { 1072, 88, 200},
    { 904, 136, 104},
    { 768, 104, 72},
    { 808, 56, 88},
    { 872, 24, 72},
    { 792, -32, 16},
    { 760, -152, 16},
    { 992, -104, -64},
    { 1040, -80, -160},
    { 1576, -176, 40},
    { 1280, 136, -56},
    { 1376, 280, -192},
    { 1272, 392, -152},
    { 824, 312, -40},
    { 784, 72, 120},
    { 832, 128, 8},
    { 880, 176, 16},
    // 26 seconds
    { 816, 320, -56},
    { 856, 376, -144},
    { 976, 416, -176},
    { 1304, 408, -216},
    { 1288, 192, -120},
    { 1792, 152, -48},
    { 1264, 360, -128},
    { 904, 280, -72},
    { 1160, 152, 40},
    { 1192, 72, 224},
    { 976, 128, 168},
    { 872, 112, 112},
    { 864, 80, 96},
    { 784, 0, 32},
    { 744, -16, 48},
    { 808, -48, 24},
    { 904, -32, -160},
    { 896, -64, -200},
    { 1568, -224, 40},
    { 1552, 72, 32},
    { 1320, 344, -168},
    { 1296, 384, -176},
    { 920, 352, 64},
    { 712, 176, 48},
    { 800, 192, 96},
    // 27 seconds
    { 864, 296, 88},
    { 816, 344, 48},
    { 864, 368, -40},
    { 896, 432, -144},
    { 1192, 448, -216},
    { 1264, 344, -88},
    { 1760, 312, -56},
    { 1368, 416, -64},
    { 832, 344, -24},
    { 832, 304, 96},
    { 1248, 176, 176},
    { 1016, 128, 200},
    { 848, 136, 104},
    { 808, 120, 80},
    { 824, 24, 112},
    { 808, 32, 56},
    { 864, 16, 24},
    { 992, 96, -56},
    { 944, -24, -64},
    { 1216, -344, -16},
    { 1304, -104, 40},
    { 1312, 192, -72},
    { 1368, 432, -232},
    { 960, 488, -48},
    { 672, 248, 8},
    // 28 seconds
    { 792, 256, 96},
    { 856, 304, 80},
    { 864, 392, 64},
    { 888, 448, -104},
    { 904, 456, -224},
    { 1200, 496, -312},
    { 1288, 392, -144},
    { 1680, 376, -56},
    { 1448, 512, -152},
    { 856, 392, -80},
    { 1008, 272, 0},
    { 1144, 184, 104},
    { 1016, 144, 120},
    { 824, 112, 112},
    { 792, 128, 80},
    { 816, 72, 120},
    { 800, 48, 40},
    { 872, 32, 40},
    { 1032, -48, 88},
    { 944, -64, 40},
    { 1328, -80, 32},
    { 1424, 56, 80},
    { 1080, 280, -200},
    { 1256, 400, -368},
    { 1024, 352, -168},
    // 29 seconds
    { 744, 224, -104},
    { 776, 328, -56},
    { 904, 328, -32},
    { 824, 368, -40},
    { 848, 320, -96},
    { 904, 344, -168},
    { 1128, 416, -224},
    { 1184, 360, -176},
    { 1824, 360, -144},
    { 1496, 440, -40},
    { 896, 384, -56},
    { 1048, 280, 0},
    { 1272, 120, 160},
    { 1056, 120, 176},
    { 880, 144, 112},
    { 752, 144, 48},
    { 784, 64, 104},
    { 768, 32, 48},
    { 776, -32, 80},
    { 872, -88, 56},
    { 952, -16, 0},
    { 1032, -88, 40},
    { 1600, -96, 120},
    { 1392, 280, -104},
    { 1360, 464, -280},
    // 30 seconds
    { 992, 480, -88},
    { 648, 144, 64},
    { 824, 192, 48},
    { 816, 144, 120},
    { 776, 280, -8},
    { 744, 288, -16},
    { 840, 320, -120},
    { 1064, 272, -80},
    { 1240, 360, -144},
    { 1680, 280, 8},
    { 1568, 456, 0},
    { 1016, 432, 16},
    { 1192, 328, 40},
    { 1072, 256, 88},
    { 920, 200, 72},
    { 856, 136, 88},
    { 784, 80, 120},
    { 856, 56, 152},
    { 848, 32, 160},
    { 768, -8, 176},
    { 928, -16, 112},
    { 1072, 16, 56},
    { 1248, -120, 112},
    { 1560, -192, 240},
    { 1080, 216, -80},
    // 31 seconds
    { 984, 256, -320},
    { 1128, 256, -168},
    { 816, 184, 56},
    { 704, 720, -112},
    { 872, 408, -32},
    { 784, 352, 64},
    { 808, 336, -16},
    { 824, 272, -56},
    { 944, 320, -104},
    { 1240, 352, -176},
    { 1400, 280, 24},
    { 1800, 392, 16},
    { 1136, 560, -96},
    { 816, 408, -88},
    { 1032, 304, 64},
    { 1168, 248, 128},
    { 952, 176, 168},
    { 848, 144, 128},
    { 808, 120, 80},
    { 792, 56, 120},
    { 776, 48, 56},
    { 792, 16, 72},
    { 896, -48, 40},
    { 1024, 64, -96},
    { 1536, -176, 96},
    // 32 seconds
    { 1512, -56, 200},
    { 1168, 400, -184},
    { 1304, 352, -208},
    { 928, 248, 88},
    { 800, 112, 8},
    { 784, 216, 96},
    { 832, 320, 88},
    { 808, 360, 64},
    { 752, 328, 24},
    { 856, 376, -64},
    { 1008, 336, -88},
    { 1264, 384, -152},
    { 1448, 256, 8},
    { 1616, 360, -32},
    { 1128, 400, -56},
    { 1120, 288, -24},
    { 1176, 200, 96},
    { 1048, 168, 136},
    { 872, 136, 160},
    { 744, 120, 128},
    { 752, 104, 128},
    { 784, 32, 152},
    { 824, 16, 112},
    { 888, -48, 144},
    { 1024, -48, 112},
    // 33 seconds
    { 968, 56, 0},
    { 1648, -72, 152},
    { 1344, 120, 24},
    { 1296, 384, -288},
    { 1152, 440, -240},
    { 784, -16, 88},
    { 616, 872, -200},
    { 800, 352, -16},
    { 840, 232, 176},
    { 760, 384, 80},
    { 808, 448, 32},
    { 904, 864, 48},
    { 1048, 376, -16},
    { 1192, 488, 40},
    { 1800, 400, 88},
    { 1320, 336, -24},
    { 912, 312, -8},
    { 1120, 232, 56},
    { 1200, 192, 104},
    { 992, 120, 144},
    { 840, 72, 128},
    { 808, 72, 56},
    { 784, -16, 80},
    { 760, 0, 32},
    { 720, -48, -8},
    // 34 seconds
    { 872, -88, -16},
    { 944, -80, -64},
    { 1240, -120, -56},
    { 1576, -168, 64},
    { 1264, 216, -88},
    { 1288, 336, -232},
    { 1176, 352, -88},
    { 768, 224, 16},
    { 760, 248, 24},
    { 800, 224, 24},
    { 832, 272, -32},
    { 808, 320, -88},
    { 840, 352, -160},
    { 960, 384, -208},
    { 1256, 320, -208},
    { 1368, 200, -8},
    { 1816, 256, 8},
    { 1152, 392, -64},
    { 920, 336, -48},
    { 1152, 168, 88},
    { 1128, 72, 144},
    { 944, 80, 128},
    { 784, 56, 80},
    { 736, 80, 24},
    { 728, 16, 32},
    // 35 seconds
    { 720, -8, 24},
    { 752, -48, 24},
    { 960, -80, 40},
    { 1024, -16, -16},
    { 1480, -104, 16},
    { 1344, 16, 48},
    { 1456, 320, -136},
    { 1328, 368, -136},
    { 912, 352, -48},
    { 744, 136, 8},
    { 720, 240, 32},
    { 792, 208, -32},
    { 800, 248, -40},
    { 776, 256, -96},
    { 936, 416, -128},
    { 1192, 432, -192},
    { 1240, 352, -144},
    { 1632, 168, 8},
    { 1440, 304, 40},
    { 1000, 344, 40},
    { 1120, 280, 80},
    { 1184, 104, 184},
    { 1040, 104, 216},
    { 856, 104, 144},
    { 776, 112, 72},
    // 36 seconds
    { 776, 48, 64},
    { 704, -24, 32},
    { 792, 80, 112},
    { 896, -56, 72},
    { 1024, 24, 0},
    { 1080, 8, -16},
    { 1592, -104, 208},
    { 1160, 208, 72},
    { 1328, 408, -208},
    { 1184, 344, -40},
    { 856, 232, 24},
    { 736, 216, 96},
    { 784, 360, 88},
    { 824, 408, 56},
    { 776, 384, 72},
    { 832, 416, -48},
    { 1024, 424, -128},
    { 1264, 384, -144},
    { 1240, 320, 0},
    { 1680, 336, 8},
    { 1208, 448, 24},
    { 968, 392, 56},
    { 1208, 264, 152},
    { 1152, 168, 248},
    { 904, 160, 200},
    // 37 seconds
    { 784, 168, 80},
    { 792, 136, 96},
    { 728, 24, 88},
    { 760, 8, 32},
    { 840, -80, 80},
    { 968, -16, 0},
    { 984, 40, -64},
    { 1592, -8, 56},
    { 1320, 152, 40},
    { 1256, 376, -112},
    { 1280, 352, -96},
    { 880, 352, 56},
    { 680, 224, 0},
    { 720, 224, 32},
    { 848, 264, -32},
    { 832, 312, -8},
    { 840, 392, -88},
    { 904, 432, -136},
    { 1248, 472, -208},
    { 1216, 392, -88},
    { 1728, 344, -32},
    { 1408, 456, -96},
    { 1072, 320, 8},
    { 1152, 240, 96},
    { 1240, 152, 200},
    // 38 seconds
    { 1016, 64, 232},
    { 792, 120, 128},
    { 720, 104, 96},
    { 736, 40, 80},
    { 744, 32, 56},
    { 832, 16, 24},
    { 976, -80, -40},
    { 936, -64, -72},
    { 1448, -176, 64},
    { 1432, -48, 88},
    { 1264, 296, -152},
    { 1232, 384, -280},
    { 1024, 336, -16},
    { 712, 240, -24},
    { 840, 288, 24},
    { 888, 296, 8},
    { 832, 344, -64},
    { 840, 352, -112},
    { 968, 464, -200},
    { 1200, 328, -144},
    { 1192, 216, -104},
    { 1680, 240, -32},
    { 1288, 312, 48},
    { 1008, 168, 96},
    { 1184, 136, 160},
    // 39 seconds
    { 1184, 88, 240},
    { 928, 104, 208},
    { 784, 112, 112},
    { 792, 88, 64},
    { 816, 0, 88},
    { 856, -48, 64},
    { 864, -56, 40},
    { 992, -136, 8},
    { 1000, -80, -120},
    { 1272, -264, -16},
    { 1240, -144, -32},
    { 1040, 88, -120},
    { 1408, 56, -80},
    { 1192, 256, 8},
    { 800, 216, 24},
    { 824, 240, 56},
    { 864, 216, 64},
    { 880, 232, 24},
    { 920, 240, -32},
    { 984, 336, -160},
    { 1176, 304, -208},
    { 1200, 240, -168},
    { 1664, 208, -72},
    { 1528, 328, -24},
    { 1000, 304, -8},
    // 40 seconds
    { 1096, 216, 32},
    { 1264, 40, 152},
    { 1040, 16, 144},
    { 880, 24, 144},
    { 864, 96, 104},
    { 760, 40, 80},
    { 752, -24, 80},
    { 712, -64, 64},
    { 840, -128, 64},
    { 1008, -48, -56},
    { 1240, -200, 48},
    { 1520, -176, 144},
    { 1312, 176, -32},
    { 1184, 352, -256},
    { 1008, 216, -48},
    { 808, 64, 88},
    { 864, 192, 56},
    { 856, 224, 48},
    { 880, 296, 0},
    { 840, 280, -80},
    { 872, 344, -184},
    { 1056, 336, -200},
    { 1224, 320, -176},
    { 1240, 240, -24},
    { 1688, 328, -24},
    // 41 seconds
    { 1128, 352, -40},
    { 1088, 224, 48},
    { 1248, 136, 176},
    { 1152, 80, 248},
    { 928, 128, 168},
    { 792, 112, 104},
    { 768, 96, 56},
    { 808, -8, 64},
    { 832, -40, 40},
    { 920, -88, 32},
    { 1080, -96, -40},
    { 1064, -136, -48},
    { 1456, -168, 40},
    { 1176, 72, -40},
    { 1120, 152, -152},
    { 1216, 184, -112},
    { 912, 184, 72},
    { 752, 264, 0},
    { 832, 264, 80},
    { 880, 272, 88},
    { 880, 280, 48},
    { 880, 360, -80},
    { 1040, 368, -176},
    { 1136, 336, -152},
    { 1240, 280, -88},
    // 42 seconds
    { 1744, 320, -32},
    { 1360, 432, -80},
    { 888, 280, -16},
    { 1136, 200, 40},
    { 1184, 120, 136},
    { 952, 96, 144},
    { 840, 96, 88},
    { 840, 72, 88},
    { 872, 16, 104},
    { 912, -16, 96},
    { 912, -48, 56},
    { 1000, -104, -40},
    { 920, -24, -64},
    { 1376, -160, -64},
    { 1272, -136, 56},
    { 1216, 200, -120},
    { 1288, 248, -184},
    { 984, 304, 0},
    { 752, 224, 24},
    { 832, 248, 72},
    { 896, 272, 64},
    { 872, 360, -8},
    { 856, 368, -80},
    { 944, 432, -184},
    { 1184, 400, -208},
    // 43 seconds
    { 1128, 344, -168},
    { 1560, 320, -16},
    { 1472, 376, 32},
    { 1064, 328, 56},
    { 1016, 264, 96},
    { 1208, 136, 168},
    { 1104, 64, 192},
    { 920, 64, 144},
    { 864, 88, 48},
    { 864, 40, 24},
    { 816, 8, -8},
    { 776, -40, -16},
    { 872, -96, 24},
    { 920, -56, -88},
    { 1072, -152, -48},
    { 1528, -168, 136},
    { 1384, 136, -8},
    { 1360, 344, -224},
    { 1096, 320, -24},
    { 832, 208, 40},
    { 848, 192, 120},
    { 872, 304, 96},
    { 896, 360, 88},
    { 792, 376, -32},
    { 1008, 376, 16},
    // 44 seconds
    { 1024, 352, -168},
    { 1128, 320, -160},
    { 1648, 224, 24},
    { 1640, 344, 88},
    { 1048, 264, 56},
    { 1112, 192, 104},
    { 1272, 88, 200},
    { 1088, 24, 208},
    { 904, 48, 104},
    { 816, 40, 48},
    { 808, 8, 24},
    { 760, -40, 24},
    { 688, -72, 48},
    { 768, -128, 40},
    { 936, -48, -32},
    { 1008, -120, -40},
    { 1480, -152, 144},
    { 1320, 72, 80},
    { 1632, 200, -8},
    { 1288, 520, -32},
    { 704, 280, 40},
    { 768, 176, 40},
    { 816, 136, 48},
    { 848, 176, 24},
    { 840, 264, -24},
    // 45 seconds
    { 904, 328, -80},
    { 1088, 360, -104},
    { 1224, 344, -80},
    { 1224, 224, 40},
    { 1680, 280, 64},
    { 1224, 384, 40},
    { 1008, 256, 80},
    { 1208, 128, 176},
    { 1184, 40, 224},
    { 960, 64, 176},
    { 864, 72, 88},
    { 856, 56, 64},
    { 800, 24, 40},
    { 736, -40, 40},
    { 800, -96, 24},
    { 952, -80, -8},
    { 912, -24, -104},
    { 1360, -240, 24},
    { 1296, -48, 128},
    { 1336, 128, 72},
    { 1400, 304, -48},
    { 976, 416, 40},
    { 752, 160, 96},
    { 824, 216, 72},
    { 904, 248, 56},
    // 46 seconds
    { 848, 312, 24},
    { 856, 368, -80},
    { 976, 400, -136},
    { 1216, 376, -160},
    { 1208, 248, -48},
    { 1424, 280, 32},
    { 1376, 248, 56},
    { 1016, 224, 136},
    { 1136, 176, 192},
    { 1248, 56, 304},
    { 1072, 32, 288},
    { 864, 80, 176},
    { 792, 80, 80},
    { 776, 0, 72},
    { 760, -40, 24},
    { 760, -72, 40},
    { 880, -112, 40},
    { 968, -32, -32},
    { 944, -24, 32},
    { 1824, -104, 224},
    { 1416, 200, -32},
    { 1432, 240, -128},
    { 1096, 568, -224},
    { 728, 208, -16},
    { 784, 224, 24},
    // 47 seconds
    { 784, 216, 32},
    { 848, 280, 24},
    { 760, 232, -120},
    { 888, 352, -232},
    { 1016, 240, -176},
    { 1136, 240, -248},
    { 1328, 224, -144},
    { 1584, 288, -80},
    { 1256, 312, -40},
    { 1080, 256, 0},
    { 1200, 80, 104},
    { 1112, 96, 184},
    { 936, 88, 112},
    { 864, 72, 80},
    { 856, 56, 56},
    { 792, 16, 64},
    { 792, -8, 56},
    { 880, -80, 96},
    { 1024, -40, -24},
    { 944, 8, -168},
    { 1360, -168, -112},
    { 1136, -48, -48},
    { 1408, 88, -88},
    { 1456, 240, -72},
    { 1064, 336, 0},
    // 48 seconds
    { 728, 312, 32},
    { 744, 272, 104},
    { 848, 240, 112},
    { 848, 248, 96},
    { 872, 336, -16},
    { 976, 400, -128},
    { 1120, 432, -160},
    { 1280, 392, -112},
    { 1760, 408, -24},
    { 1328, 432, 8},
    { 1032, 304, 40},
    { 1160, 216, 72},
    { 1208, 72, 216},
    { 936, 48, 184},
    { 840, 104, 104},
    { 808, 48, 104},
    { 784, 8, 56},
    { 776, -8, 16},
    { 824, -72, 32},
    { 960, -120, -8},
    { 1008, -40, -56},
    { 1472, -184, 32},
    { 1440, 16, 96},
    { 1360, 240, -40},
    { 1320, 304, -120},
    // 49 seconds
    { 928, 336, 72},
    { 712, 208, 88},
    { 800, 176, 88},
    { 880, 208, 112},
    { 824, 312, 64},
    { 856, 336, 16},
    { 944, 352, -120},
    { 1152, 360, -152},
    { 1216, 232, -8},
    { 1808, 304, 72},
    { 1384, 416, 48},
    { 1040, 224, 64},
    { 1136, 152, 144},
    { 1240, 80, 232},
    { 1000, 32, 208},
    { 824, 40, 160},
    { 808, 64, 104},
    { 800, 24, 88},
    { 792, 0, 56},
    { 848, -32, 32},
    { 1016, -104, 40},
    { 1024, -72, 16},
    { 1160, -504, 168},
    { 1264, -120, 104},
    { 1296, 16, 96},
    // 50 seconds
    { 1512, 288, 0},
    { 904, 384, 80},
    { 640, 240, 112},
    { 728, 176, 160},
    { 776, 184, 168},
    { 824, 184, 168},
    { 928, 240, 88},
    { 1008, 352, -88},
    { 1152, 328, -88},
    { 1304, 304, -24},
    { 1776, 352, 96},
    { 1544, 440, 192},
    { 888, 288, 96},
    { 1048, 240, 112},
    { 1232, 128, 224},
    { 1144, 24, 248},
    { 888, 32, 200},
    { 784, 0, 144},
    { 768, 0, 88},
    { 744, 8, 48},
    { 824, -24, 24},
    { 960, -72, 8},
    { 1056, -80, 8},
    { 1136, -176, 56},
    { 1504, -136, 200},
    // 51 seconds
    { 1184, 96, 112},
    { 1128, 112, 24},
    { 1064, 176, 48},
    { 760, 168, 120},
    { 760, 176, 96},
    { 872, 200, 152},
    { 944, 296, 88},
    { 920, 416, -104},
    { 992, 392, -232},
    { 1032, 208, -104},
    { 1264, 176, -32},
    { 1344, 176, 160},
    { 1632, 256, 184},
    { 1136, 424, 104},
    { 960, 248, 120},
    { 1152, 120, 216},
    { 1176, 80, 232},
    { 984, 56, 192},
    { 848, 32, 152},
    { 840, 16, 112},
    { 744, -24, 104},
    { 712, -48, 96},
    { 840, -80, 72},
    { 1072, -40, -8},
    { 1008, 8, -80},
    // 52 seconds
    { 1560, -280, 88},
    { 1320, -32, 120},
    { 1088, 160, 16},
    { 1256, 152, -8},
    { 960, 304, 80},
    { 728, 184, 104},
    { 832, 216, 120},
    { 888, 256, 136},
    { 880, 336, 80},
    { 880, 360, -24},
    { 920, 384, -88},
    { 1192, 456, -184},
    { 1224, 328, -40},
    { 1808, 320, 40},
    { 1424, 376, 16},
    { 1032, 256, -8},
    { 1112, 160, 128},
    { 1224, 160, 168},
    { 960, 56, 232},
    { 800, 72, 96},
    { 792, 88, 96},
    { 792, 88, 64},
    { 792, 40, 32},
    { 840, -24, 72},
    { 984, -72, 56},
    // 53 seconds
    { 952, 24, -48},
    { 1240, -80, -24},
    { 1544, -32, 72},
    { 1176, 288, -120},
    { 1224, 288, -176},
    { 1136, 200, 48},
    { 792, 160, 56},
    { 824, 120, 80},
    { 872, 240, 24},
    { 864, 296, 24},
    { 880, 400, -88},
    { 920, 432, -152},
    { 1128, 376, -128},
    { 1256, 288, -96},
    { 1344, 192, 72},
    { 1624, 280, 136},
    { 1200, 344, 48},
    { 968, 224, 120},
    { 1232, 144, 168},
    { 1184, 120, 232},
    { 976, 88, 200},
    { 896, 40, 152},
    { 880, 8, 88},
    { 848, -48, 48},
    { 768, -56, 16},
    // 54 seconds
    { 792, -136, 8},
    { 904, -104, -72},
    { 936, -144, -80},
    { 1584, -336, 120},
    { 1320, 24, 272},
    { 1400, 144, 8},
    { 1352, 296, -80},
    { 984, 240, 176},
    { 888, 200, 152},
    { 912, 296, 208},
    { 912, 400, 168},
    { 912, 392, 72},
    { 944, 472, -32},
    { 1080, 504, -80},
    { 1024, 320, -88},
    { 1264, 432, 64},
    { 1552, 288, 104},
    { 1280, 360, 120},
    { 1296, 224, 176},
    { 1376, 72, 304},
    { 1160, 112, 360},
    { 1000, 136, 216},
    { 896, 104, 184},
    { 848, 48, 104},
    { 832, -24, 104},
    // 55 seconds
    { 808, -24, 64},
    { 864, -72, 80},
    { 944, -104, 0},
    { 904, -72, -72},
    { 1328, -160, 72},
    { 1136, 128, 8},
    { 1392, 104, -16},
    { 1480, 192, -40},
    { 984, 328, 144},
    { 872, 320, 32},
    { 896, 320, 160},
    { 952, 336, 96},
    { 920, 320, 40},
    { 912, 432, -112},
    { 952, 416, -136},
    { 1168, 416, -128},
    { 1312, 304, 88},
    { 1744, 376, 152},
    { 1280, 384, 136},
    { 1096, 264, 136},
    { 1216, 128, 224},
    { 1192, 88, 240},
    { 1016, 56, 200},
    { 848, 24, 168},
    { 800, 40, 120},
    // 56 seconds
    { 768, -8, 96},
    { 792, -32, 96},
    { 872, -64, 56},
    { 984, -80, 16},
    { 920, -56, -104},
    { 1408, -240, 56},
    { 1312, -8, 144},
    { 1568, 144, 88},
    { 1336, 320, -128},
    { 832, 288, 56},
    { 816, 176, 128},
    { 896, 216, 160},
    { 944, 248, 208},
    { 904, 328, 136},
    { 880, 440, -24},
    { 952, 384, -56},
    { 1160, 480, -120},
    { 1392, 368, 72},
    { 1808, 520, 80},
    { 1144, 392, 96},
    { 1240, 280, 120},
    { 1328, 224, 208},
    { 1160, 104, 232},
    { 952, 48, 240},
    { 864, 64, 184},
    // 57 seconds
    { 872, 16, 144},
    { 800, -48, 184},
    { 808, -40, 144},
    { 872, -72, 120},
    { 952, -48, 48},
    { 1000, -48, -24},
    { 1480, -152, 104},
    { 1360, 8, 48},
    { 1312, 168, -104},
    { 1232, 176, -152},
    { 888, 176, 56},
    { 856, 176, 64},
    { 904, 240, 168},
    { 976, 312, 176},
    { 920, 392, 128},
    { 864, 448, 16},
    { 936, 424, -40},
    { 1184, 432, -104},
    { 1144, 384, -64},
    { 1704, 488, -40},
    { 1376, 496, 24},
    { 1160, 328, 96},
    { 1200, 240, 176},
    { 1296, 168, 256},
    { 1072, 128, 208},
    // 58 seconds
    { 944, 80, 144},
    { 904, 88, 112},
    { 880, 24, 120},
    { 840, -24, 104},
    { 832, -40, 72},
    { 912, -96, 24},
    { 856, -32, -72},
    { 1272, -232, -40},
    { 1360, -104, 80},
    { 1296, 128, -64},
    { 1432, 160, -80},
    { 1208, 224, 120},
    { 920, 240, 168},
    { 936, 296, 200},
    { 904, 320, 224},
    { 864, 328, 192},
    { 856, 360, 96},
    { 880, 424, -8},
    { 1112, 464, -48},
    { 1144, 448, -56},
    { 1664, 488, 40},
    { 1616, 560, 136},
    { 992, 360, 88},
    { 1104, 272, 136},
    { 1352, 168, 240},
    // 59 seconds
    { 1128, 64, 288},
    { 944, 72, 208},
    { 872, 56, 184},
    { 816, 24, 152},
    { 768, 8, 96},
    { 776, -32, 104},
    { 856, -72, 72},
    { 920, -56, 24},
    { 992, -40, -64},
    { 1432, -32, 168},
    { 1328, 320, 144},
    { 1248, 560, -48},
    { 1032, 624, -48},
    { 712, 256, 192},
    { 744, 312, 144},
    { 768, 312, 232},
    { 816, 432, 248},
    { 792, 416, 192},
    { 856, 560, 40},
    { 1008, 576, 88},
    { 1088, 608, 56},
    { 1400, 280, 176},
    { 1664, 520, 160},
    { 1104, 496, 120},
    { 984, 312, 104},
    // 60 seconds
    // elapsed: 1 minutes
    { 1224, 272, 160},
    { 1088, 184, 168},
    { 880, 80, 120},
    { 808, 72, 48},
    { 808, 32, 80},
    { 760, 16, 48},
    { 768, 0, 48},
    { 864, -40, 56},
    { 1024, 0, 0},
    { 1096, -64, -8},
    { 1600, -136, 136},
    { 1360, 144, 32},
    { 1192, 312, -256},
    { 1000, 216, -160},
    { 808, 184, 96},
    { 832, 224, 88},
    { 824, 256, 120},
    { 880, 312, 128},
    { 824, 400, 56},
    { 816, 400, -80},
    { 928, 360, -168},
    { 1232, 400, -208},
    { 1256, 256, 8},
    { 1792, 376, 16},
    { 1200, 400, 8},
    // 61 seconds
    { 1080, 296, -32},
    { 1176, 168, 128},
    { 1192, 136, 112},
    { 1016, 104, 136},
    { 832, 72, 88},
    { 824, 64, 32},
    { 784, 24, 24},
    { 744, 8, 0},
    { 776, -24, 24},
    { 872, -80, 0},
    { 952, -8, -8},
    { 1416, -144, 208},
    { 1592, 72, 64},
    { 1184, 152, -8},
    { 1384, 184, -160},
    { 1208, 312, -56},
    { 816, 256, 32},
    { 800, 296, 88},
    { 808, 336, 120},
    { 808, 304, 160},
    { 736, 312, 88},
    { 800, 368, -8},
    { 1056, 432, -72},
    { 1168, 416, -96},
    { 1448, 256, 32},
    // 62 seconds
    { 1576, 336, 8},
    { 1168, 360, -40},
    { 1232, 272, -16},
    { 1280, 152, 80},
    { 1224, 80, 104},
    { 960, 64, 80},
    { 832, 48, 24},
    { 792, 24, -32},
    { 688, -8, -16},
    { 664, 0, -64},
    { 744, -88, 0},
    { 936, -64, -8},
    { 1032, 16, -8},
    { 1544, -104, 152},
    { 1776, 112, 368},
    { 1424, 808, 56},
    { 968, 752, 0},
    { 728, 384, 256},
    { 648, 216, 296},
    { 680, 144, 264},
    { 664, 168, 232},
    { 648, 272, 192},
    { 744, 400, 24},
    { 928, 280, 104},
    { 1264, 464, -80},
    // 63 seconds
    { 1272, 488, -40},
    { 1560, 272, 104},
    { 1328, 424, 48},
    { 1256, 560, 40},
    { 888, 304, 64},
    { 1016, 224, 120},
    { 952, 104, 152},
    { 848, 120, 32},
    { 856, 40, 96},
    { 872, 0, 104},
    { 992, 8, 88},
    { 1056, -32, 152},
    { 1256, -16, 88},
    { 1232, -40, 144},
    { 1384, 16, 256},
    { 1240, 144, 160},
    { 1024, 272, -40},
    { 832, 208, -24},
    { 592, 88, 160},
    { 728, 128, 112},
    { 832, 152, 224},
    { 872, 304, 136},
    { 872, 336, 88},
    { 1000, 360, -32},
    { 1328, 272, 80},
    // 64 seconds
    { 1368, 304, 56},
    { 1728, 320, -16},
    { 1280, 480, -96},
    { 1016, 336, -56},
    { 1008, 168, 136},
    { 1184, 72, 112},
    { 1064, 40, 160},
    { 848, 32, 248},
    { 848, 80, 160},
    { 816, 32, 112},
    { 704, -24, 152},
    { 648, -24, 96},
    { 696, -48, 80},
    { 904, -16, 16},
    { 1176, 8, -80},
    { 1552, -136, 88},
    { 1376, 80, 120},
    { 1288, 368, -112},
    { 1288, 320, -72},
    { 1024, 336, 96},
    { 768, 176, 112},
    { 768, 208, 88},
    { 816, 240, 72},
    { 808, 328, 16},
    { 832, 264, -8},
    // 65 seconds
    { 872, 400, -152},
    { 1072, 336, -144},
    { 1336, 336, -216},
    { 1592, 208, -24},
    { 1664, 144, -80},
    { 1072, 216, -144},
    { 1000, 216, -120},
    { 1080, 96, 40},
    { 984, 56, 128},
    { 800, 32, 128},
    { 664, 80, 80},
    { 664, 72, 56},
    { 696, 32, 48},
    { 816, -8, 72},
    { 1016, -24, 40},
    { 1232, -8, 56},
    { 1336, -136, 72},
    { 1656, -80, 152},
    { 1008, 288, -184},
    { 936, 200, -248},
    { 968, 176, -80},
    { 744, 144, -8},
    { 680, 176, 16},
    { 784, 208, 24},
    { 840, 296, 0},
    // 66 seconds
    { 832, 312, -40},
    { 936, 376, -160},
    { 1104, 328, -176},
    { 1240, 264, -176},
    { 1344, 136, 8},
    { 1712, 352, 8},
    { 1184, 456, -48},
    { 880, 296, 8},
    { 1120, 168, 144},
    { 1024, 136, 176},
    { 840, 88, 176},
    { 752, 112, 112},
    { 816, 72, 80},
    { 792, 16, 112},
    { 784, 16, 64},
    { 856, -24, 72},
    { 1000, -32, 8},
    { 976, 16, -72},
    { 1424, -192, 24},
    { 1464, 40, 32},
    { 1120, 304, -136},
    { 1288, 232, -80},
    { 1064, 328, 48},
    { 696, 200, 24},
    { 744, 200, 88},
    // 67 seconds
    { 792, 248, 88},
    { 832, 288, 80},
    { 840, 344, 8},
    { 888, 376, -80},
    { 1080, 392, -136},
    { 1216, 360, -152},
    { 1760, 288, -24},
    { 1584, 384, 48},
    { 976, 328, 56},
    { 1104, 280, 88},
    { 1232, 192, 152},
    { 1072, 88, 208},
    { 856, 80, 152},
    { 768, 64, 88},
    { 752, 8, 80},
    { 720, 0, 56},
    { 816, 0, 88},
    { 920, -48, 48},
    { 1032, -32, 48},
    { 1136, -120, 88},
    { 1472, -96, 168},
    { 1304, 184, 64},
    { 1096, 320, -176},
    { 1064, 328, -160},
    { 872, 184, 112},
    // 68 seconds
    { 800, 256, 48},
    { 856, 280, 80},
    { 904, 376, 48},
    { 840, 408, -56},
    { 912, 448, -168},
    { 1032, 384, -176},
    { 1200, 296, -144},
    { 1368, 168, 64},
    { 1664, 352, 56},
    { 1160, 408, 16},
    { 936, 288, 16},
    { 1168, 176, 144},
    { 1256, 104, 184},
    { 960, 104, 160},
    { 816, 88, 112},
    { 784, 72, 80},
    { 792, 16, 96},
    { 760, 16, 72},
    { 832, -24, 104},
    { 976, -40, 72},
    { 1040, -16, 24},
    { 1560, -112, -32},
    { 1392, -8, 24},
    { 1192, 160, -104},
    { 1240, 312, -272},
    // 69 seconds
    { 1072, 280, 88},
    { 744, 336, 88},
    { 792, 288, 152},
    { 840, 280, 192},
    { 808, 280, 112},
    { 792, 312, 16},
    { 856, 360, -128},
    { 1056, 344, -136},
    { 1248, 312, -72},
    { 1776, 328, 32},
    { 1656, 440, 48},
    { 880, 312, -16},
    { 976, 240, 56},
    { 1192, 160, 144},
    { 1048, 88, 216},
    { 832, 128, 72},
    { 776, 64, 96},
    { 784, 48, 72},
    { 760, 48, 64},
    { 752, 32, 56},
    { 824, -32, 48},
    { 1056, 40, -48},
    { 1040, 48, -160},
    { 1704, -184, 104},
    { 1336, 104, 16},
    // 70 seconds
    { 1080, 248, -144},
    { 1272, 296, -40},
    { 848, 336, 96},
    { 664, 152, 64},
    { 784, 120, 80},
    { 864, 168, 128},
    { 848, 256, 80},
    { 936, 384, -40},
    { 968, 448, -176},
    { 1184, 384, -160},
    { 1216, 408, -112},
    { 1648, 432, -136},
    { 1312, 584, -128},
    { 888, 416, -64},
    { 1096, 312, 64},
    { 1272, 232, 192},
    { 1056, 184, 192},
    { 872, 112, 168},
    { 808, 104, 104},
    { 856, 40, 128},
    { 848, 8, 88},
    { 800, -16, 88},
    { 872, -64, 56},
    { 1008, -16, -40},
    { 1112, -144, -8},
    // 71 seconds
    { 1640, -96, 80},
    { 1184, 240, -48},
    { 1264, 336, -312},
    { 1088, 368, -64},
    { 840, 168, 64},
    { 568, 552, -8},
    { 856, 264, 48},
    { 864, 224, 112},
    { 784, 312, 32},
    { 872, 400, -104},
    { 992, 440, -136},
    { 1216, 480, -200},
    { 1280, 320, -56},
    { 1736, 456, -48},
    { 1208, 488, -64},
    { 1000, 304, -8},
    { 1192, 200, 128},
    { 1168, 136, 216},
    { 896, 136, 176},
    { 800, 120, 104},
    { 784, 56, 120},
    { 800, 24, 104},
    { 864, 24, 48},
    { 896, -56, 72},
    { 1056, -56, 16},
    // 72 seconds
    { 1136, -176, 56},
    { 1448, -112, 112},
    { 1208, 160, -72},
    { 1144, 256, -224},
    { 1104, 304, -160},
    { 840, 168, 72},
    { 864, 256, -16},
    { 904, 264, 112},
    { 920, 400, 32},
    { 872, 376, 0},
    { 856, 448, -176},
    { 984, 456, -216},
    { 1200, 432, -240},
    { 1288, 328, -80},
    { 1728, 496, -8},
    { 1192, 472, 8},
    { 1016, 304, 40},
    { 1248, 216, 144},
    { 1192, 128, 248},
    { 960, 112, 176},
    { 848, 112, 112},
    { 808, 64, 96},
    { 768, 8, 72},
    { 776, 8, 32},
    { 848, -40, 24},
    // 73 seconds
    { 992, -64, -32},
    { 952, 0, -192},
    { 1456, -224, -40},
    { 1416, -48, 48},
    { 1376, 200, -72},
    { 1304, 400, -264},
    { 976, 344, 16},
    { 872, 240, 80},
    { 880, 240, 136},
    { 904, 336, 128},
    { 856, 440, 40},
    { 824, 448, -32},
    { 920, 520, -168},
    { 1136, 464, -200},
    { 1144, 400, -168},
    { 1856, 488, -40},
    { 1416, 512, 8},
    { 1208, 336, 32},
    { 1344, 256, 112},
    { 1232, 184, 568},
    { 1096, 136, 128},
    { 976, 128, 120},
    { 856, 40, 88},
    { 752, -24, 72},
    { 672, -40, 72},
    // 74 seconds
    { 688, -80, 0},
    { 800, -96, -16},
    { 912, -40, -80},
    { 1376, -256, 32},
    { 1584, -64, 144},
    { 1560, 248, -32},
    { 1528, 464, -208},
    { 1056, 536, -24},
    { 848, 272, 72},
    { 872, 224, 144},
    { 904, 232, 152},
    { 856, 336, 72},
    { 832, 408, -24},
    { 896, 504, -160},
    { 1192, 480, -176},
    { 1168, 440, -152},
    { 1680, 360, -136},
    { 1528, 424, -104},
    { 1048, 256, -24},
    { 1160, 200, 72},
    { 1312, 176, 176},
    { 1160, 104, 256},
    { 912, 56, 184},
    { 936, 56, 216},
    { 832, 40, 128},
    // 75 seconds
    { 896, 16, 104},
    { 856, -24, 80},
    { 920, -120, 56},
    { 920, -88, -32},
    { 1024, -208, -72},
    { 1384, 0, -32},
    { 1368, 272, -200},
    { 1256, 400, -320},
    { 1040, 376, -200},
    { 848, 248, 96},
    { 776, 280, 24},
    { 848, 328, 48},
    { 936, 432, 40},
    { 824, 472, -80},
    { 880, 432, -80},
    { 1008, 448, -256},
    { 1144, 312, -176},
    { 1424, 328, 8},
    { 1512, 504, -56},
    { 1176, 496, -72},
    { 1040, 296, 16},
    { 1272, 176, 80},
    { 1216, 104, 192},
    { 1024, 88, 152},
    { 896, 72, 128},
    // 76 seconds
    { 864, 96, 96},
    { 808, -8, 80},
    { 776, -64, 72},
    { 800, -136, 80},
    { 920, -128, 48},
    { 912, -48, -112},
    { 1400, -280, -40},
    { 1448, 40, 40},
    { 1256, 208, -64},
    { 1408, 336, -184},
    { 1032, 376, 40},
    { 720, 256, 96},
    { 808, 256, 136},
    { 832, 280, 192},
    { 824, 344, 128},
    { 832, 416, 32},
    { 952, 520, -136},
    { 1184, 472, -248},
    { 1256, 288, -160},
    { 1768, 320, -72},
    { 1400, 448, -32},
    { 960, 336, 48},
    { 1120, 232, 176},
    { 1216, 152, 248},
    { 1024, 120, 216},
    // 77 seconds
    { 840, 72, 184},
    { 816, 72, 112},
    { 872, -8, 120},
    { 976, 40, -8},
    { 1112, -16, -32},
    { 1096, -176, 96},
    { 968, -128, 8},
    { 1160, -336, 104},
    { 1064, -96, 88},
    { 1184, 104, 48},
    { 1400, 200, 24},
    { 1192, 408, 64},
    { 872, 296, 48},
    { 872, 360, 72},
    { 856, 352, 112},
    { 832, 384, 16},
    { 832, 320, -56},
    { 1000, 384, -200},
    { 1096, 360, -192},
    { 1256, 376, -176},
    { 1720, 416, -80},
    { 1488, 424, 40},
    { 1032, 312, 88},
    { 1256, 296, 104},
    { 1192, 120, 272},
    // 78 seconds
    { 1072, 72, 232},
    { 928, 72, 192},
    { 800, 88, 96},
    { 792, 32, 72},
    { 784, -8, 80},
    { 792, -16, 40},
    { 872, -104, 112},
    { 944, 0, -8},
    { 1104, -112, -56},
    { 1616, -136, 40},
    { 1408, 32, 0},
    { 1344, 240, -120},
    { 1200, 384, -136},
    { 904, 304, 72},
    { 848, 296, 96},
    { 872, 256, 168},
    { 912, 328, 128},
    { 864, 336, 96},
    { 856, 496, -120},
    { 928, 520, -176},
    { 1096, 488, -208},
    { 1240, 328, -56},
    { 1608, 512, -56},
    { 1216, 488, -56},
    { 1232, 360, 24},
    // 79 seconds
    { 1256, 216, 120},
    { 1200, 160, 168},
    { 984, 160, 136},
    { 912, 104, 80},
    { 888, 56, 112},
    { 856, 8, 88},
    { 880, 0, 24},
    { 888, -88, 48},
    { 928, -80, 24},
    { 896, -48, -104},
    { 1400, -272, 48},
    { 1392, -80, 112},
    { 1312, 272, -88},
    { 1376, 344, -256},
    { 1104, 312, 64},
    { 928, 264, 104},
    { 912, 360, 128},
    { 944, 400, 160},
    { 888, 424, 96},
    { 824, 392, 0},
    { 864, 440, -48},
    { 1128, 496, -160},
    { 1248, 432, -88},
    { 1904, 496, -32},
    { 1320, 392, -72},
    // 80 seconds
    { 1136, 288, -8},
    { 1264, 192, 112},
    { 1384, 72, 216},
    { 1072, 40, 240},
    { 864, 56, 184},
    { 800, 64, 120},
    { 800, -8, 152},
    { 792, -40, 104},
    { 832, -48, 120},
    { 896, -48, 24},
    { 912, -64, -48},
    { 1280, -256, 8},
    { 1608, -192, 240},
    { 1248, 272, -24},
    { 1264, 392, -256},
    { 1256, 408, -24},
    { 952, 256, 96},
    { 904, 320, 88},
    { 920, 424, 64},
    { 856, 480, 40},
    { 760, 456, -64},
    { 848, 488, -184},
    { 1152, 440, -168},
    { 1224, 560, -200},
    { 1608, 272, 80},
    // 81 seconds
    { 1536, 400, 40},
    { 1072, 408, -8},
    { 1128, 304, 72},
    { 1320, 192, 184},
    { 1160, 88, 216},
    { 992, 96, 144},
    { 920, 64, 144},
    { 824, 24, 80},
    { 768, 0, 72},
    { 728, -24, 48},
    { 808, -72, 48},
    { 920, -88, -16},
    { 960, -64, -56},
    { 1576, -232, 152},
    { 1592, 80, 144},
    { 1336, 368, -160},
    { 1408, 384, -128},
    { 1080, 328, 136},
    { 792, 248, 152},
    { 832, 296, 192},
    { 904, 384, 152},
    { 840, 400, 120},
    { 784, 520, -40},
    { 864, 456, -120},
    { 1136, 448, -160},
    // 82 seconds
    { 1296, 344, -120},
    { 1736, 344, -104},
    { 1576, 352, -104},
    { 1176, 152, 0},
    { 1320, 152, -32},
    { 1168, -184, -224},
    { 1264, 192, 184},
    { 896, 176, -24},
    { 720, 64, -16},
    { 688, -16, 24},
    { 640, -64, 16},
    { 616, -128, 40},
    { 720, -136, 56},
    { 936, 24, -16},
    { 1384, -128, 152},
    { 2024, -64, 464},
    { 1560, 512, 16},
    { 1288, 680, -184},
    { 1048, 472, 136},
    { 680, 72, 104},
    { 840, 128, 184},
    { 840, 296, 128},
    { 760, 408, 64},
    { 768, 384, 8},
    { 888, 432, -80},
    // 83 seconds
    { 1088, 408, -112},
    { 1224, 328, -104},
    { 1376, 288, 24},
    { 1752, 352, -24},
    { 1144, 368, -40},
    { 1168, 280, -8},
    { 1240, 144, 88},
    { 1160, 48, 168},
    { 984, 56, 192},
    { 864, 80, 112},
    { 800, 56, 88},
    { 664, 8, 104},
    { 672, -24, 48},
    { 768, -72, 56},
    { 904, -48, -24},
    { 976, 0, -8},
    { 1656, -16, 16},
    { 1712, 72, 96},
    { 1376, 32, -32},
    { 1408, 56, -104},
    { 928, 216, -16},
    { 760, 232, 56},
    { 728, 248, 120},
    { 784, 224, 168},
    { 800, 248, 208},
    // 84 seconds
    { 824, 352, 104},
    { 872, 384, 88},
    { 1104, 488, -32},
    { 1192, 448, -80},
    { 1536, 408, -80},
    { 1512, 472, -88},
    { 1016, 472, -88},
    { 1056, 352, -40},
    { 1256, 248, 88},
    { 1304, 144, 144},
    { 1040, 152, 128},
    { 968, 96, 88},
    { 880, 16, 128},
    { 752, -8, 96},
    { 672, -8, 32},
    { 752, -96, 56},
    { 920, -88, 32},
    { 1056, 8, -24},
    { 1568, -120, 104},
    { 1688, -16, 248},
    { 1320, 480, -224},
    { 1064, 368, -112},
    { 992, 168, 168},
    { 840, 216, 136},
    { 760, 200, 152},
    // 85 seconds
    { 808, 288, 168},
    { 776, 408, 8},
    { 776, 248, 88},
    { 872, 384, -80},
    { 1104, 368, -88},
    { 1216, 408, -168},
    { 1408, 288, -16},
    { 1488, 360, -56},
    { 1064, 456, -64},
    { 1056, 344, -16},
    { 1224, 200, 128},
    { 1112, 152, 176},
    { 936, 160, 128},
    { 864, 104, 128},
    { 824, 72, 112},
    { 792, 24, 96},
    { 768, 16, 40},
    { 872, -48, 32},
    { 1016, 56, 16},
    { 1000, 0, -96},
    { 1528, -200, 48},
    { 1360, -8, 144},
    { 1200, 384, -72},
    { 1192, 368, -96},
    { 960, 288, 120},
    // 86 seconds
    { 792, 216, 136},
    { 840, 344, 168},
    { 768, 296, 216},
    { 808, 424, 136},
    { 880, 872, 344},
    { 424, 720, -96},
    { 1160, 368, 144},
    { 1272, 456, 40},
    { 1704, 352, 216},
    { 1528, 520, 144},
    { 920, 424, 112},
    { 1000, 232, 144},
    { 2000, 56, -680},
    { 1088, -40, 160},
    { 832, 0, 152},
    { 768, -32, 168},
    { 776, 48, 96},
    { 776, -24, 112},
    { 784, -80, 96},
    { 880, -176, 144},
    { 1032, -152, 16},
    { 1216, -144, 96},
    { 1672, -56, 152},
    { 1184, 264, -48},
    { 1128, 344, -216},
    // 87 seconds
    { 1064, 168, 48},
    { 792, 144, 48},
    { 736, 96, 80},
    { 744, 184, 72},
    { 744, 256, 40},
    { 744, 368, 40},
    { 832, 368, -8},
    { 960, 432, -72},
    { 1440, 512, -152},
    { 1344, 336, 8},
    { 1872, 392, 16},
    { 1328, 448, -48},
    { 896, 320, 8},
    { 1064, 232, 136},
    { 1160, 128, 224},
    { 960, 56, 264},
    { 784, 96, 176},
    { 744, 96, 128},
    { 744, 48, 112},
    { 752, 32, 72},
    { 776, -8, 72},
    { 984, -16, 16},
    { 1032, -32, -32},
    { 1520, -136, 104},
    { 1536, -24, 184},
    // 88 seconds
    { 1088, 400, -120},
    { 1240, 360, -128},
    { 1056, 328, 104},
    { 744, 176, 136},
    { 792, 176, 136},
    { 792, 288, 96},
    { 824, 384, 48},
    { 824, 368, -24},
    { 880, 368, -48},
    { 992, 424, -128},
    { 1272, 352, -88},
    { 1528, 256, 96},
    { 1880, 352, 136},
    { 1136, 480, 8},
    { 848, 328, 32},
    { 1232, 136, 40},
    { 1072, 64, 328},
    { 912, 56, 272},
    { 776, 88, 176},
    { 728, 72, 136},
    { 696, 24, 136},
    { 728, -16, 128},
    { 776, 0, 88},
    { 1000, -40, 56},
    { 1120, 8, 16},
    // 89 seconds
    { 1592, -40, 56},
    { 1632, 24, 160},
    { 1112, 456, -168},
    { 1040, 432, -240},
    { 1104, 312, 80},
    { 792, 168, 88},
    { 768, 120, 120},
    { 840, 312, 40},
    { 848, 400, -16},
    { 840, 376, -32},
    { 960, 368, -80},
    { 1104, 376, -152},
    { 1208, 368, -160},
    { 1824, 256, 24},
    { 1584, 304, 80},
    { 952, 304, 32},
    { 1120, 224, 88},
    { 1192, 112, 216},
    { 1088, 160, 176},
    { 928, 128, 200},
    { 792, 112, 136},
    { 760, 72, 112},
    { 728, 48, 88},
    { 688, 0, 88},
    { 784, -48, 56},
    // 90 seconds
    { 952, 32, -72},
    { 1048, 16, -32},
    { 1672, -120, 224},
    { 1472, 184, 112},
    { 1272, 520, -192},
    { 1288, 456, -48},
    { 968, 376, 184},
    { 784, 16, 200},
    { 856, 248, 144},
    { 872, 440, 16},
    { 784, 456, -40},
    { 800, 456, -64},
    { 904, 456, -112},
    { 1184, 392, -136},
    { 1264, 248, 48},
    { 1936, 360, 72},
    { 1304, 432, -8},
    { 920, 320, 24},
    { 1232, 192, 168},
    { 1280, 80, 272},
    { 1048, 152, 216},
    { 880, 88, 224},
    { 800, 96, 168},
    { 784, 72, 144},
    { 784, 24, 128},
    // 91 seconds
    { 816, -8, 104},
    { 888, -32, 64},
    { 1000, -24, 24},
    { 1272, -88, 40},
    { 1472, -120, 280},
    { 1264, 280, 56},
    { 1096, 448, -240},
    { 1128, 360, -40},
    { 1008, 168, 224},
    { 912, 216, 224},
    { 952, 360, 128},
    { 904, 472, 64},
    { 776, 512, -32},
    { 920, 432, -32},
    { 1056, 264, -48},
    { 1184, 496, -200},
    { 1680, 296, 48},
    { 1664, 328, 112},
    { 1120, 288, 112},
    { 1104, 160, 128},
    { 1256, -32, 240},
    { 1144, -56, 256},
    { 1000, -40, 232},
    { 880, -56, 184},
    { 824, -56, 128},
    // 92 seconds
    { 760, -80, 144},
    { 776, -240, 48},
    { 864, -176, 24},
    { 1008, -16, -48},
    { 1112, -184, 32},
    { 1472, -256, 112},
    { 1248, 80, -32},
    { 1232, 104, -152},
    { 1312, 48, 16},
    { 1024, 200, 80},
    { 904, 88, 136},
    { 952, 224, 96},
    { 872, 256, 56},
    { 848, 328, -48},
    { 824, 304, -104},
    { 1000, 320, -120},
    { 1296, 296, -128},
    { 1408, 224, -8},
    { 1728, 256, 24},
    { 1320, 296, 24},
    { 984, 224, 48},
    { 1192, 48, 152},
    { 1256, 64, 136},
    { 1128, 16, 184},
    { 912, 24, 192},
    // 93 seconds
    { 856, 72, 112},
    { 824, 16, 32},
    { 736, -16, 56},
    { 688, -72, 64},
    { 872, -112, 40},
    { 912, -32, -24},
    { 1368, -240, 104},
    { 1496, -104, 272},
    { 1408, 200, 112},
    { 1288, 392, -112},
    { 1048, 456, 0},
    { 928, 112, 216},
    { 1032, 200, 112},
    { 1024, 296, 72},
    { 888, 424, -32},
    { 824, 392, -112},
    { 896, 384, -184},
    { 1088, 368, -152},
    { 1128, 472, -152},
    { 1680, 408, -8},
    { 1760, 368, 80},
    { 1096, 168, 88},
    { 1152, 160, 80},
    { 1312, 72, 280},
    { 1272, 88, 288},
    // 94 seconds
    { 1072, 80, 224},
    { 904, 24, 144},
    { 760, -24, 72},
    { 656, -40, 48},
    { 640, -88, 72},
    { 744, -80, 0},
    { 864, -48, -64},
    { 1024, -120, 8},
    { 1792, -160, 280},
    { 1680, 200, 104},
    { 1512, 512, -208},
    { 1240, 448, 0},
    { 896, 304, 144},
    { 824, 200, 64},
    { 856, 296, 56},
    { 832, 344, -24},
    { 816, 416, -104},
    { 840, 432, -120},
    { 920, 416, -152},
    { 1208, 360, -136},
    { 1264, 272, 40},
    { 1880, 312, 64},
    { 1360, 312, 64},
    { 1080, 264, 88},
    { 1192, 136, 168},
    // 95 seconds
    { 1168, 64, 240},
    { 984, 64, 200},
    { 784, 128, 120},
    { 696, 80, 56},
    { 680, 0, 80},
    { 696, -16, 80},
    { 720, -56, 40},
    { 856, -56, 24},
    { 1056, 8, 0},
    { 1376, -128, 160},
    { 1760, 32, 272},
    { 1504, 384, 16},
    { 1288, 432, -72},
    { 984, 440, 88},
    { 672, 80, 176},
    { 824, 136, 192},
    { 848, 248, 128},
    { 808, 344, 64},
    { 784, 336, 24},
    { 888, 432, -72},
    { 1056, 408, -72},
    { 1216, 432, -112},
    { 1512, 304, 72},
    { 1744, 320, 80},
    { 1120, 344, 24},
    // 96 seconds
    { 992, 208, 112},
    { 1248, 200, 168},
    { 1176, 24, 272},
    { 936, 64, 232},
    { 824, 72, 200},
    { 808, 48, 184},
    { 816, 8, 152},
    { 840, 0, 96},
    { 968, -56, 104},
    { 1080, 112, -40},
    { 976, -312, 80},
    { 1296, -264, 200},
    { 1240, 48, 0},
    { 1392, 136, -80},
    { 1328, 304, -72},
    { 944, 256, 88},
    { 912, 288, 128},
    { 936, 344, 168},
    { 936, 360, 160},
    { 840, 344, 96},
    { 872, 440, -48},
    { 1000, 376, -80},
    { 1136, 400, -16},
    { 1264, 568, 80},
    { 1640, 520, 168},
    // 97 seconds
    { 1224, 416, 136},
    { 1048, 192, 176},
    { 1272, 144, 232},
    { 1240, 32, 328},
    { 1048, 48, 248},
    { 944, 72, 152},
    { 976, 48, 144},
    { 856, -24, 136},
    { 824, -32, 56},
    { 744, -128, 88},
    { 824, -96, 0},
    { 800, -56, -48},
    { 1376, -264, 56},
    { 1304, 24, 160},
    { 1448, 104, 48},
    { 1584, 304, 0},
    { 1104, 336, 136},
    { 912, 248, 120},
    { 896, 288, 144},
    { 928, 296, 128},
    { 880, 352, 72},
    { 840, 416, -16},
    { 936, 456, -80},
    { 1136, 392, -32},
    { 1192, 304, 16},
    // 98 seconds
    { 1536, 328, 96},
    { 1688, 464, 80},
    { 1080, 312, 96},
    { 1200, 176, 160},
    { 1400, 48, 288},
    { 1144, 48, 280},
    { 1000, 64, 208},
    { 872, 64, 176},
    { 800, 0, 128},
    { 728, -40, 112},
    { 704, -64, 104},
    { 752, -80, 72},
    { 912, -48, 0},
    { 976, -32, -64},
    { 1504, -208, 168},
    { 1528, 24, 200},
    { 1456, 320, -112},
    { 1280, 392, -104},
    { 1008, 272, 192},
    { 936, 192, 128},
    { 960, 224, 160},
    { 992, 376, 96},
    { 840, 424, 0},
    { 832, 408, -80},
    { 928, 400, -136},
    // 99 seconds
    { 1112, 368, -112},
    { 1184, 304, -24},
    { 1728, 336, 8},
    { 1400, 400, 88},
    { 1080, 280, 96},
    { 1160, 168, 184},
    { 1384, 64, 272},
    { 1176, 40, 280},
    { 944, 56, 240},
    { 856, 48, 168},
    { 816, 16, 136},
    { 776, -24, 112},
    { 824, -56, 96},
    { 872, -96, 48},
    { 944, -88, -8},
    { 1128, -192, 64},
    { 1480, -152, 232},
    { 1264, 296, 24},
    { 1312, 280, -104},
    { 1304, 304, 80},
    { 984, 272, 176},
    { 824, 224, 128},
    { 880, 288, 120},
    { 896, 376, 64},
    { 840, 376, 24},
    // 100 seconds
    { 896, 408, -16},
    { 1024, 408, -40},
    { 1184, 392, -120},
    { 1456, 184, 56},
    { 1872, 336, 32},
    { 1112, 344, -24},
    { 1016, 248, 24},
    { 1336, 136, 144},
    { 1184, 48, 248},
    { 984, 88, 184},
    { 864, 128, 104},
    { 800, 48, 160},
    { 744, 8, 136},
    { 736, -24, 160},
    { 704, -72, 176},
    { 832, -64, 88},
    { 944, 8, -72},
    { 1424, -200, 88},
    { 1608, -72, 192},
    { 1376, 288, -40},
    { 1584, 536, -208},
    { 1160, 576, 40},
    { 776, 248, 56},
    { 824, 176, 120},
    { 776, 192, 120},
    // 101 seconds
    { 760, 296, 32},
    { 768, 352, -8},
    { 856, 424, -128},
    { 1104, 512, -136},
    { 1264, 392, -8},
    { 1688, 328, 120},
    { 1656, 392, 144},
    { 944, 344, 56},
    { 1136, 208, 144},
    { 1328, 104, 224},
    { 1176, 40, 232},
    { 952, 80, 136},
    { 848, 96, -16},
    { 848, 96, -80},
    { 808, -16, 40},
    { 688, -48, 8},
    { 752, -128, 64},
    { 952, -24, 128},
    { 968, 24, 136},
    { 1560, -56, 224},
    { 1280, 128, 224},
    { 1184, 248, 72},
    { 1296, 312, 32},
    { 1064, 408, 104},
    { 880, 136, 168},
    // 102 seconds
    { 1000, 200, 96},
    { 1016, 320, 0},
    { 968, 416, -88},
    { 912, 336, -272},
    { 864, 208, -48},
    { 1280, 472, -240},
    { 1328, 352, -24},
    { 1776, 296, 128},
    { 1496, 368, 136},
    { 1032, 200, 112},
    { 1112, 104, 184},
    { 1296, -16, 336},
    { 1088, 16, 320},
    { 904, 56, 232},
    { 880, 56, 192},
    { 824, -8, 160},
    { 768, -24, 120},
    { 744, -72, 112},
    { 864, -144, 72},
    { 952, -48, -24},
    { 1152, -248, 112},
    { 1408, -136, 264},
    { 1272, 192, 80},
    { 1432, 208, -64},
    { 1424, 336, -8},
    // 103 seconds
    { 976, 224, 200},
    { 888, 336, 72},
    { 936, 264, 128},
    { 920, 328, 72},
    { 832, 296, 40},
    { 896, 392, -40},
    { 1104, 368, -24},
    { 1232, 376, -16},
    { 1448, 208, 152},
    { 1624, 304, 144},
    { 1168, 352, 56},
    { 864, 344, 72},
    { 1312, 64, 152},
    { 1216, -128, 256},
    { 1008, -80, 184},
    { 832, -64, 120},
    { 800, 64, 8},
    { 792, 112, 64},
    { 792, 0, 64},
    { 784, -112, 88},
    { 904, -104, -8},
    { 936, -64, -8},
    { 1432, -168, 88},
    { 1368, -8, 152},
    { 1320, 160, -56},
    // 104 seconds
    { 1432, 248, -96},
    { 1096, 344, 0},
    { 840, 64, 176},
    { 976, 248, 64},
    { 952, 280, 104},
    { 864, 368, 32},
    { 824, 320, -8},
    { 952, 424, -144},
    { 1136, 392, -128},
    { 1280, 312, -32},
    { 1752, 280, 0},
    { 1592, 336, 104},
    { 1032, 264, 96},
    { 1104, 120, 160},
    { 1304, 24, 264},
    { 1184, 32, 288},
    { 944, 56, 216},
    { 848, 56, 144},
    { 792, 0, 144},
    { 752, -40, 88},
    { 784, -64, 80},
    { 832, -144, 80},
    { 936, -64, 16},
    { 1112, -216, 96},
    { 1512, -168, 256},
    // 105 seconds
    { 1336, 152, 144},
    { 1384, 208, -72},
    { 1280, 248, 0},
    { 944, 184, 152},
    { 944, 216, 144},
    { 976, 296, 128},
    { 912, 336, 128},
    { 840, 336, 24},
    { 856, 352, -72},
    { 1024, 360, -88},
    { 1184, 344, -80},
    { 1328, 224, 96},
    { 1856, 304, 136},
    { 1176, 384, 96},
    { 904, 240, 104},
    { 1232, 96, 232},
    { 1264, 24, 304},
    { 1040, 40, 264},
    { 920, 8, 240},
    { 856, 8, 184},
    { 816, -24, 160},
    { 792, -48, 128},
    { 864, -72, 88},
    { 960, -72, 16},
    { 984, -72, -56},
    // 106 seconds
    { 1472, -256, 128},
    { 1328, 24, 152},
    { 1184, 176, -64},
    { 1296, 176, -88},
    { 1112, 200, 160},
    { 960, 184, 192},
    { 992, 280, 176},
    { 992, 384, 152},
    { 872, 408, 136},
    { 816, 352, 32},
    { 872, 368, -48},
    { 1120, 392, -96},
    { 1176, 360, -48},
    { 1704, 328, 24},
    { 1512, 328, 136},
    { 1096, 280, 64},
    { 1040, 192, 176},
    { 1408, 80, 256},
    { 1224, 88, 264},
    { 984, 56, 216},
    { 912, 40, 176},
    { 824, 8, 160},
    { 768, -24, 136},
    { 752, -56, 128},
    { 736, -80, 136},
    // 107 seconds
    { 856, -48, 32},
    { 952, -56, -24},
    { 1496, -152, 72},
    { 1496, 8, 280},
    { 1496, 336, -8},
    { 1344, 456, -56},
    { 1016, 432, 184},
    { 880, 256, 176},
    { 880, 240, 280},
    { 880, 344, 232},
    { 808, 368, 240},
    { 800, 488, 88},
    { 824, 456, 16},
    { 792, 464, -88},
    { 920, 384, -72},
    { 1112, 328, -8},
    { 1120, 248, 112},
    { 1792, 304, 88},
    { 1544, 344, 296},
    { 1240, 296, 232},
    { 1288, 376, 280},
    { 1256, 392, 360},
    { 1224, 176, 504},
    { 1192, 184, 528},
    { 1144, 288, 456},
    // 108 seconds
    { 976, 304, 424},
    { 824, 272, 432},
    { 648, 280, 256},
    { 568, 512, 88},
    { 496, 584, 88},
    { 368, 808, 176},
    { 336, 840, 224},
    { 280, 808, 256},
    { 160, 904, 128},
    { 40, 1088, 176},
    { 112, 1064, 232},
    { 24, 1128, 240},
    { -8, 1160, 112},
    { -112, 1168, -48},
    { -120, 1008, -128},
    { -176, 912, -256},
    { -152, 768, -488},
    { -120, 776, -648},
    { -80, 504, -720},
    { -32, 192, -880},
    { 72, 112, -944},
    { 112, 160, -976},
    { 112, -64, -880},
    { 152, -96, -912},
    { 144, -136, -968},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:28:05 local
AccelRawData *activity_sample_walk_200_pbl_25297_11(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25297_11
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 88, -104, -1024},
    { 96, -88, -1032},
    { 120, -80, -1024},
    { 112, -88, -1024},
    { 152, -104, -1016},
    { 72, -104, -1000},
    { 112, -112, -1040},
    { 128, -96, -1056},
    { 96, -96, -1024},
    { 104, -80, -1024},
    { 144, -352, -896},
    { 48, -64, -1016},
    { 192, -24, -1016},
    { 144, -72, -1000},
    { 152, 16, -992},
    { 136, -16, -1000},
    { 112, -16, -968},
    { 128, 96, -912},
    { 104, 304, -864},
    { 80, 416, -752},
    { 40, 504, -728},
    { 72, 664, -800},
    { 80, 736, -768},
    { 80, 800, -688},
    { 120, 872, -688},
    // 1 seconds
    { 72, 840, -624},
    { 120, 824, -632},
    { 88, 736, -592},
    { 72, 744, -520},
    { 72, 784, -400},
    { 48, 704, -320},
    { 112, 736, -312},
    { 112, 1056, -408},
    { 152, 776, -272},
    { 112, 560, -408},
    { 168, 816, -424},
    { 72, 696, -400},
    { 120, 776, -376},
    { 192, 680, -344},
    { 216, 584, -288},
    { 560, 856, -264},
    { 392, 744, -200},
    { 448, 552, -168},
    { 664, 848, -56},
    { 840, 776, -56},
    { 920, 544, 24},
    { 1080, 432, 120},
    { 1216, 416, 136},
    { 1432, 248, 216},
    { 1672, 296, 176},
    // 2 seconds
    { 1392, 480, 72},
    { 1024, 672, -192},
    { 744, 512, -72},
    { 832, 304, 160},
    { 944, 96, 312},
    { 744, 96, 272},
    { 736, 136, 128},
    { 744, 224, 32},
    { 760, 208, 64},
    { 776, 264, 16},
    { 832, 424, -168},
    { 744, 360, 32},
    { 1208, 440, -80},
    { 1264, 136, 128},
    { 1736, 320, 160},
    { 1448, 416, -24},
    { 568, 520, 24},
    { 600, 176, -32},
    { 944, 136, 136},
    { 936, 152, 288},
    { 768, 240, 144},
    { 680, 216, 32},
    { 664, 152, 104},
    { 704, 144, 72},
    { 768, 88, 88},
    // 3 seconds
    { 896, 120, 16},
    { 1176, 136, 24},
    { 1456, 48, 152},
    { 1920, 0, 256},
    { 1256, 248, 96},
    { 760, 472, -256},
    { 784, 296, -16},
    { 760, 424, -72},
    { 704, 120, 152},
    { 696, 112, 184},
    { 776, 248, 24},
    { 720, 296, -40},
    { 744, 328, -56},
    { 880, 344, -120},
    { 1160, 256, -8},
    { 1384, 272, 32},
    { 1728, 224, 112},
    { 1528, 296, 80},
    { 912, 384, -24},
    { 880, 224, 40},
    { 1072, 80, 200},
    { 912, 112, 128},
    { 752, 184, 48},
    { 656, 112, 48},
    { 648, 72, 40},
    // 4 seconds
    { 752, 40, 88},
    { 800, 56, 80},
    { 944, 0, 80},
    { 1256, 72, 80},
    { 1552, -64, 136},
    { 1488, 64, 88},
    { 1032, 440, -344},
    { 952, 96, -168},
    { 856, 104, 80},
    { 704, 200, 24},
    { 736, 136, 40},
    { 824, 280, 16},
    { 800, 344, 40},
    { 768, 312, 24},
    { 912, 336, -96},
    { 1224, 296, -72},
    { 1280, 320, -88},
    { 1712, 216, 96},
    { 1648, 376, 48},
    { 960, 392, 40},
    { 896, 208, 40},
    { 1144, 80, 136},
    { 968, 24, 264},
    { 760, 88, 88},
    { 688, 120, 24},
    // 5 seconds
    { 720, 56, 112},
    { 776, 56, 64},
    { 784, 16, 88},
    { 888, -40, 72},
    { 1136, 40, 0},
    { 1280, 0, 40},
    { 1544, 48, 136},
    { 1200, 232, 48},
    { 1288, 336, -96},
    { 984, 336, -8},
    { 696, 192, -8},
    { 640, 288, 24},
    { 768, 96, 176},
    { 824, 240, 112},
    { 744, 352, 0},
    { 848, 384, -72},
    { 1032, 368, -48},
    { 1384, 392, -96},
    { 1224, 184, 104},
    { 1840, 184, 112},
    { 1160, 368, 32},
    { 928, 256, 64},
    { 1088, 144, 168},
    { 1024, 88, 240},
    { 832, 152, 168},
    // 6 seconds
    { 720, 112, 80},
    { 752, 104, 88},
    { 808, 40, 128},
    { 832, 48, 72},
    { 880, 40, 24},
    { 1064, -32, 32},
    { 1160, 48, -32},
    { 1664, -72, 168},
    { 1376, 224, 56},
    { 1056, 464, -280},
    { 920, 184, -80},
    { 784, 64, 200},
    { 784, 128, 120},
    { 856, 184, 168},
    { 816, 336, 88},
    { 760, 360, 32},
    { 768, 456, -128},
    { 832, 360, -80},
    { 1136, 288, 8},
    { 1408, 280, 24},
    { 1648, 224, 88},
    { 1480, 376, -16},
    { 1040, 336, 40},
    { 1040, 208, 88},
    { 1192, 104, 168},
    // 7 seconds
    { 1064, 168, 192},
    { 848, 168, 88},
    { 792, 96, 80},
    { 792, 64, 72},
    { 784, 40, 72},
    { 768, 24, 64},
    { 808, -72, 72},
    { 976, 16, 24},
    { 1128, -64, 40},
    { 1712, -40, 200},
    { 1320, 328, 48},
    { 1040, 448, -200},
    { 1144, 224, 56},
    { 888, 288, 168},
    { 760, 208, 136},
    { 808, 184, 144},
    { 816, 240, 104},
    { 800, 320, 8},
    { 840, 336, -40},
    { 984, 344, -48},
    { 1256, 392, -128},
    { 1248, 288, 48},
    { 1928, 256, 120},
    { 1456, 384, 32},
    { 832, 336, -48},
    // 8 seconds
    { 944, 160, 72},
    { 1160, 0, 272},
    { 992, 80, 208},
    { 784, 120, 152},
    { 784, 32, 160},
    { 736, 56, 152},
    { 720, 72, 120},
    { 744, 32, 96},
    { 832, -24, 48},
    { 1104, 48, 32},
    { 1192, -16, 128},
    { 1696, 0, 248},
    { 1272, 344, -72},
    { 1064, 416, -320},
    { 968, 136, -32},
    { 744, 72, 96},
    { 712, 192, 24},
    { 752, 248, 40},
    { 832, 240, 112},
    { 816, 280, 64},
    { 864, 320, -16},
    { 1016, 432, -112},
    { 1264, 392, -176},
    { 1400, 184, 72},
    { 1824, 224, 152},
    // 9 seconds
    { 1352, 408, 0},
    { 728, 280, -32},
    { 1008, 152, 112},
    { 1096, 56, 256},
    { 864, 120, 248},
    { 752, 96, 168},
    { 704, 80, 160},
    { 696, 80, 136},
    { 704, 64, 128},
    { 768, 24, 104},
    { 1064, 16, 96},
    { 1216, 152, -80},
    { 1584, -104, 128},
    { 1440, 40, 104},
    { 1056, 416, -168},
    { 1048, 256, -112},
    { 880, 248, 56},
    { 664, 208, 96},
    { 760, 224, 128},
    { 856, 240, 168},
    { 848, 360, 56},
    { 808, 344, 8},
    { 864, 328, -72},
    { 1104, 280, -72},
    { 1296, 208, -40},
    // 10 seconds
    { 1592, 200, 0},
    { 1624, 344, 24},
    { 984, 408, 16},
    { 832, 184, 104},
    { 1128, 168, 192},
    { 944, 152, 272},
    { 864, 88, 200},
    { 768, 88, 128},
    { 776, 88, 120},
    { 800, 48, 104},
    { 776, 24, 112},
    { 856, 0, 88},
    { 1056, 8, 0},
    { 1064, 72, -72},
    { 1672, -64, 216},
    { 1304, 240, 56},
    { 1192, 432, -144},
    { 1144, 384, -48},
    { 728, 328, 72},
    { 664, 32, 112},
    { 768, 40, 136},
    { 800, 120, 136},
    { 840, 312, 64},
    { 824, 368, -80},
    { 920, 368, -56},
    // 11 seconds
    { 1192, 376, -128},
    { 1328, 360, -88},
    { 1760, 240, 72},
    { 1496, 376, 8},
    { 832, 256, 64},
    { 968, 184, 104},
    { 1152, 72, 264},
    { 936, 120, 232},
    { 792, 136, 152},
    { 736, 96, 144},
    { 728, 72, 72},
    { 688, 56, 64},
    { 744, 32, 88},
    { 920, -72, 56},
    { 1208, 48, -48},
    { 1408, -64, 112},
    { 1728, 168, 128},
    { 1184, 576, -144},
    { 856, 456, -144},
    { 800, 200, 64},
    { 728, 8, 208},
    { 728, 80, 152},
    { 840, 232, 56},
    { 832, 336, 48},
    { 784, 368, -24},
    // 12 seconds
    { 872, 328, -112},
    { 1016, 360, -232},
    { 1208, 472, -176},
    { 1440, 48, 32},
    { 1800, 336, 32},
    { 1136, 528, -16},
    { 816, 440, -136},
    { 1000, 360, -48},
    { 1072, 216, 80},
    { 944, 144, 96},
    { 784, 64, 96},
    { 784, 80, 64},
    { 840, 56, 72},
    { 696, 72, 40},
    { 712, 8, 48},
    { 928, 16, 8},
    { 1104, 160, -144},
    { 1712, -64, 152},
    { 1576, 136, 184},
    { 1168, 464, -208},
    { 968, 448, -256},
    { 848, 264, 16},
    { 760, -72, 224},
    { 904, 176, 160},
    { 704, 520, 88},
    // 13 seconds
    { 832, 632, 40},
    { 792, 456, 32},
    { 904, 232, 40},
    { 1168, 152, 72},
    { 1304, 224, 24},
    { 1552, 248, 64},
    { 1584, 432, -56},
    { 952, 392, 64},
    { 920, 248, 128},
    { 1120, 184, 240},
    { 936, 104, 248},
    { 792, 112, 128},
    { 752, 64, 144},
    { 760, 128, 40},
    { 784, 32, 96},
    { 720, 40, 32},
    { 784, -32, 48},
    { 1032, 0, 16},
    { 1208, 40, -16},
    { 1728, -72, 240},
    { 1368, 296, 8},
    { 1032, 496, -144},
    { 968, 344, 32},
    { 816, 240, 120},
    { 704, 56, 176},
    // 14 seconds
    { 704, 136, 160},
    { 792, 248, 152},
    { 800, 376, 48},
    { 792, 304, 0},
    { 920, 320, -72},
    { 1256, 312, -112},
    { 1336, 320, -56},
    { 1712, 240, 72},
    { 1472, 344, 0},
    { 880, 312, 40},
    { 992, 176, 64},
    { 1176, 72, 248},
    { 920, 80, 232},
    { 720, 160, 64},
    { 680, 112, 104},
    { 704, 104, 104},
    { 728, 56, 104},
    { 784, 32, 104},
    { 880, -8, 64},
    { 1136, 88, 24},
    { 1248, -8, 32},
    { 1672, -64, 216},
    { 1264, 288, -40},
    { 1040, 368, -216},
    { 944, 184, 16},
    // 15 seconds
    { 768, -16, 112},
    { 696, 72, 96},
    { 768, 192, 88},
    { 888, 328, 16},
    { 816, 400, -40},
    { 872, 360, -40},
    { 968, 280, 16},
    { 1288, 272, -48},
    { 1240, 152, 88},
    { 1792, 264, 96},
    { 1360, 448, -40},
    { 784, 304, -16},
    { 968, 176, 80},
    { 1168, 48, 232},
    { 912, 40, 296},
    { 864, 104, 120},
    { 800, 48, 192},
    { 744, 96, 88},
    { 784, 64, 72},
    { 840, 48, 88},
    { 976, -32, 48},
    { 1104, 16, -64},
    { 1544, -80, 128},
    { 1688, 48, 256},
    { 1072, 472, -160},
    // 16 seconds
    { 960, 376, -80},
    { 952, 248, 104},
    { 728, 168, 120},
    { 744, 160, 120},
    { 800, 160, 176},
    { 824, 288, 40},
    { 784, 232, -8},
    { 832, 328, -144},
    { 1120, 384, -168},
    { 1344, 336, -120},
    { 1552, 224, 88},
    { 1712, 376, 64},
    { 1112, 480, -24},
    { 896, 272, 24},
    { 1016, 48, 152},
    { 1040, 72, 96},
    { 872, 40, 176},
    { 736, 56, 192},
    { 704, 152, 24},
    { 728, 88, 104},
    { 752, 88, 32},
    { 904, 56, -72},
    { 1208, -32, -16},
    { 1072, 8, -40},
    { 1768, -64, 112},
    // 17 seconds
    { 1352, 200, 32},
    { 1024, 360, -64},
    { 912, 272, -40},
    { 760, 208, 184},
    { 688, 160, 96},
    { 784, 216, 0},
    { 848, 296, 0},
    { 808, 344, -80},
    { 840, 400, -176},
    { 960, 456, -208},
    { 1208, 400, -216},
    { 1320, 288, -48},
    { 1824, 272, -8},
    { 1368, 368, -8},
    { 824, 400, -56},
    { 960, 280, 40},
    { 1128, 96, 192},
    { 992, 128, 136},
    { 832, 136, 24},
    { 792, 72, 40},
    { 744, 80, 16},
    { 728, 88, -8},
    { 728, 40, 24},
    { 848, -48, 80},
    { 1048, 104, -88},
    // 18 seconds
    { 1192, -88, 144},
    { 1584, 8, 288},
    { 1256, 328, 40},
    { 1280, 384, -48},
    { 968, 520, -104},
    { 704, 80, 128},
    { 760, 72, 88},
    { 792, 168, 104},
    { 896, 536, -80},
    { 816, 520, -112},
    { 888, 504, -104},
    { 1080, 352, -48},
    { 1224, 224, 24},
    { 1320, 152, 192},
    { 1712, 304, 136},
    { 1208, 336, 104},
    { 1040, 248, 112},
    { 1048, 160, 216},
    { 968, 104, 208},
    { 848, 104, 184},
    { 728, 80, 144},
    { 704, 80, 80},
    { 720, 16, 80},
    { 712, 24, 56},
    { 784, -40, 88},
    // 19 seconds
    { 992, -24, 48},
    { 1144, 88, -64},
    { 1672, -136, 128},
    { 1584, 144, 120},
    { 1288, 528, -224},
    { 1016, 376, -144},
    { 768, 256, 40},
    { 672, 64, 64},
    { 736, 160, 80},
    { 824, 240, 72},
    { 848, 344, 16},
    { 832, 360, -40},
    { 912, 384, -112},
    { 1216, 384, -160},
    { 1224, 288, -72},
    { 1704, 136, 120},
    { 1512, 336, 88},
    { 952, 368, 56},
    { 984, 176, 104},
    { 1200, 64, 240},
    { 944, 40, 208},
    { 768, 32, 160},
    { 768, 40, 96},
    { 720, 48, 64},
    { 736, 72, 32},
    // 20 seconds
    { 768, -40, 64},
    { 896, -80, 64},
    { 1096, 32, 0},
    { 1368, -88, 40},
    { 1736, -40, 200},
    { 1176, 504, -168},
    { 904, 368, -192},
    { 968, 176, 120},
    { 800, 144, 56},
    { 760, 144, 104},
    { 792, 232, 72},
    { 776, 336, -32},
    { 816, 296, -56},
    { 896, 304, -88},
    { 1072, 320, -120},
    { 1288, 280, -128},
    { 1320, 216, -16},
    { 1648, 312, -8},
    { 1392, 408, -48},
    { 864, 328, 0},
    { 904, 184, -8},
    { 1136, 112, 80},
    { 1120, 72, 104},
    { 872, 48, 40},
    { 728, 40, 16},
    // 21 seconds
    { 752, 0, 56},
    { 672, -40, 24},
    { 720, -48, 32},
    { 888, -96, 56},
    { 984, 0, -32},
    { 1376, -80, -8},
    { 1680, 96, 64},
    { 1328, 376, -144},
    { 1152, 368, -304},
    { 896, 200, -80},
    { 656, 72, -32},
    { 728, 176, -8},
    { 696, 224, -40},
    { 752, 288, -72},
    { 840, 360, -112},
    { 928, 448, -200},
    { 1120, 384, -168},
    { 1232, 248, -112},
    { 1584, 128, -16},
    { 1640, 304, -32},
    { 992, 336, -24},
    { 944, 264, -16},
    { 1160, 176, 112},
    { 1032, 144, 176},
    { 832, 128, 88},
    // 22 seconds
    { 752, 88, 32},
    { 760, 96, 16},
    { 736, 16, 16},
    { 736, -16, 24},
    { 664, -104, 80},
    { 1056, -24, -8},
    { 1200, 48, -112},
    { 1664, -40, 96},
    { 1216, 224, -80},
    { 1304, 288, -176},
    { 1184, 368, -56},
    { 704, 256, 80},
    { 576, 216, 80},
    { 680, 192, 144},
    { 808, 208, 200},
    { 824, 328, 128},
    { 776, 368, 32},
    { 912, 416, -56},
    { 1240, 424, -120},
    { 1272, 296, -8},
    { 2024, 376, 112},
    { 1440, 528, 0},
    { 688, 304, -40},
    { 960, 200, 72},
    { 448, -168, 216},
    // 23 seconds
    { 992, 144, 208},
    { 816, 144, 128},
    { 720, 56, 104},
    { 768, 32, 176},
    { 784, 32, 96},
    { 840, -24, 104},
    { 1032, -96, 80},
    { 1112, 8, -8},
    { 1456, -200, 96},
    { 1408, -16, 152},
    { 1016, 312, -88},
    { 1288, 328, -144},
    { 944, 296, 80},
    { 648, 224, 24},
    { 784, 160, 112},
    { 808, 208, 104},
    { 824, 328, 24},
    { 832, 312, 8},
    { 920, 376, -96},
    { 1048, 344, -112},
    { 1240, 296, -72},
    { 1648, 120, 112},
    { 1704, 424, 24},
    { 1000, 472, 0},
    { 960, 272, 72},
    // 24 seconds
    { 1152, 136, 216},
    { 1096, 112, 152},
    { 864, 104, 160},
    { 728, 104, 112},
    { 744, 64, 72},
    { 792, 16, 56},
    { 752, -40, 56},
    { 856, -80, 88},
    { 1056, -8, -8},
    { 1184, 16, -48},
    { 1584, -88, 40},
    { 1312, 176, 0},
    { 1248, 360, -240},
    { 1088, 336, -80},
    { 776, 272, 8},
    { 696, 136, 88},
    { 728, 144, 80},
    { 784, 224, 80},
    { 792, 264, 48},
    { 872, 288, 8},
    { 992, 360, -128},
    { 1248, 304, -120},
    { 1216, 224, -120},
    { 1760, 160, -24},
    { 1488, 352, -32},
    // 25 seconds
    { 936, 280, 40},
    { 1128, 152, 136},
    { 1104, 56, 192},
    { 888, 120, 72},
    { 760, 80, 112},
    { 712, 80, 16},
    { 816, 64, 24},
    { 768, 0, 8},
    { 896, -40, 16},
    { 1176, -152, 64},
    { 1080, -40, -16},
    { 1496, -192, 56},
    { 1400, 88, 128},
    { 1040, 312, -96},
    { 1144, 264, -104},
    { 992, 256, 112},
    { 760, 184, 160},
    { 792, 312, 56},
    { 880, 320, 144},
    { 808, 424, 40},
    { 832, 352, 16},
    { 888, 368, -56},
    { 1088, 304, -48},
    { 1208, 328, -88},
    { 1736, 280, 40},
    // 26 seconds
    { 1712, 440, 48},
    { 1000, 448, -16},
    { 1008, 328, 56},
    { 936, -384, 48},
    { 1048, 328, 224},
    { 832, 216, 80},
    { 776, 56, 112},
    { 768, 8, 144},
    { 728, 64, 48},
    { 824, 0, 80},
    { 896, -24, 16},
    { 1056, 24, 16},
    { 1080, 48, -64},
    { 1720, -72, 272},
    { 1320, 304, 72},
    { 1152, 464, -168},
    { 1008, 464, -32},
    { 696, 208, 128},
    { 752, 136, 136},
    { 808, 200, 80},
    { 864, 336, 24},
    { 856, 392, 8},
    { 848, 432, -80},
    { 976, 440, -120},
    { 1248, 408, -104},
    // 27 seconds
    { 1224, 288, -8},
    { 1680, 448, -48},
    { 1256, 496, -24},
    { 1208, 304, 96},
    { 1304, 120, 264},
    { 1160, 88, 232},
    { 968, 120, 144},
    { 824, 112, 104},
    { 768, 56, 104},
    { 744, -16, 104},
    { 680, -40, 64},
    { 760, -64, 56},
    { 992, -48, 40},
    { 968, -64, -64},
    { 1624, -96, 120},
    { 1656, 96, 208},
    { 1376, 576, -208},
    { 1144, 464, -128},
    { 888, 360, 96},
    { 768, 128, 112},
    { 816, 272, 56},
    { 872, 328, 48},
    { 808, 448, -32},
    { 832, 432, -96},
    { 920, 400, -112},
    // 28 seconds
    { 1176, 352, -64},
    { 1216, 256, 48},
    { 1952, 312, 168},
    { 1424, 464, 56},
    { 912, 288, 8},
    { 1088, 152, 128},
    { 1064, -112, 216},
    { 1024, 64, 208},
    { 800, 128, 120},
    { 768, 88, 120},
    { 736, 40, 104},
    { 736, -16, 104},
    { 832, -56, 88},
    { 984, -96, 72},
    { 1080, -24, 24},
    { 1592, -248, 240},
    { 1568, 80, 192},
    { 1024, 520, -264},
    { 1096, 368, -152},
    { 928, 208, 168},
    { 752, 184, 48},
    { 864, 208, 136},
    { 896, 376, 24},
    { 840, 376, 0},
    { 808, 368, -120},
    // 29 seconds
    { 928, 360, -152},
    { 1144, 336, -152},
    { 1208, 240, -16},
    { 1800, 256, 104},
    { 1496, 376, 96},
    { 912, 336, 32},
    { 1040, 240, 96},
    { 1168, 120, 208},
    { 1032, 80, 208},
    { 840, 136, 80},
    { 776, 72, 96},
    { 736, 40, 80},
    { 736, 8, 48},
    { 808, -16, 48},
    { 920, -80, 96},
    { 976, -8, 40},
    { 1304, -112, 112},
    { 1720, -40, 272},
    { 1216, 344, 8},
    { 1192, 416, -224},
    { 1008, 328, 24},
    { 688, 104, 120},
    { 768, 152, 96},
    { 832, 232, 144},
    { 848, 384, 56},
    // 30 seconds
    { 800, 368, 48},
    { 888, 456, -72},
    { 1024, 352, -8},
    { 1224, 344, -32},
    { 1352, 360, 104},
    { 1632, 536, 8},
    { 1120, 504, -56},
    { 1088, 280, 64},
    { 1320, 56, 128},
    { 1160, 16, 240},
    { 904, 96, 168},
    { 768, 136, 88},
    { 776, 72, 96},
    { 744, 0, 120},
    { 728, -32, 136},
    { 880, -64, 128},
    { 1064, -56, 64},
    { 968, 32, 0},
    { 1576, -56, 120},
    { 1328, 160, 104},
    { 1184, 432, -192},
    { 1216, 384, -48},
    { 864, 248, 136},
    { 784, 440, 176},
    { 888, 104, 152},
    // 31 seconds
    { 816, 264, 168},
    { 800, 424, 40},
    { 840, 376, 24},
    { 944, 392, -32},
    { 1168, 400, -120},
    { 1240, 264, 0},
    { 1816, 352, 48},
    { 1328, 472, 0},
    { 912, 336, 40},
    { 1104, 224, 112},
    { 1200, 104, 216},
    { 952, 112, 176},
    { 816, 136, 112},
    { 800, 56, 168},
    { 760, 72, 96},
    { 760, 24, 112},
    { 816, -24, 112},
    { 1000, -80, 120},
    { 1064, 0, 16},
    { 1400, -112, 112},
    { 1456, 24, 168},
    { 1112, 352, -72},
    { 1200, 320, -104},
    { 1000, 280, 72},
    { 712, 88, -24},
    // 32 seconds
    { 752, 96, 136},
    { 848, 256, 72},
    { 848, 328, 32},
    { 800, 344, -48},
    { 952, 408, -136},
    { 1224, 384, -160},
    { 1320, 312, -80},
    { 1696, 264, 32},
    { 1496, 408, 32},
    { 912, 384, 8},
    { 1024, 280, 80},
    { 1184, 184, 224},
    { 1064, 104, 200},
    { 888, 80, 200},
    { 776, 96, 144},
    { 720, 80, 80},
    { 736, 24, 80},
    { 832, -16, 120},
    { 976, -80, 104},
    { 1016, -24, 56},
    { 1360, -112, 128},
    { 1472, 24, 152},
    { 1080, 360, -16},
    { 1104, 368, -104},
    { 936, 312, 48},
    // 33 seconds
    { 680, 168, 144},
    { 800, 232, 152},
    { 824, 376, 120},
    { 816, 408, 48},
    { 872, 448, 16},
    { 960, 576, -168},
    { 1104, 600, 0},
    { 1144, 360, -16},
    { 1632, 472, 104},
    { 1512, 560, 56},
    { 864, 400, 0},
    { 912, 280, 0},
    { 1128, 128, 104},
    { 976, 72, 184},
    { 808, 96, 152},
    { 760, 120, 104},
    { 712, 64, 88},
    { 728, 16, 104},
    { 792, -8, 104},
    { 1000, -72, 112},
    { 1176, -32, 8},
    { 1288, -120, 64},
    { 1584, -136, 112},
    { 1048, 264, -152},
    { 960, 312, -264},
    // 34 seconds
    { 944, 184, -72},
    { 720, 88, 0},
    { 744, 104, 40},
    { 824, 224, -16},
    { 848, 264, -48},
    { 832, 304, -56},
    { 936, 288, -96},
    { 992, 288, -112},
    { 1160, 232, -88},
    { 1272, 160, 80},
    { 1720, 192, 80},
    { 1200, 360, -16},
    { 920, 288, -16},
    { 1056, 152, 64},
    { 1048, 80, 120},
    { 896, 48, 144},
    { 776, 72, 56},
    { 752, 64, 40},
    { 800, 16, 24},
    { 808, -24, 32},
    { 904, -56, 24},
    { 1048, -56, -16},
    { 1040, 16, -56},
    { 1544, -176, 184},
    { 1272, 48, 128},
    // 35 seconds
    { 1192, 296, -56},
    { 1112, 312, -56},
    { 744, 288, 32},
    { 664, 272, 16},
    { 744, 248, 16},
    { 840, 280, -8},
    { 856, 296, -40},
    { 848, 352, -136},
    { 936, 328, -152},
    { 1176, 288, -128},
    { 1184, 224, 16},
    { 1792, 272, 104},
    { 1328, 360, 88},
    { 960, 288, 96},
    { 1096, 168, 152},
    { 1088, 88, 176},
    { 920, 88, 112},
    { 776, 120, 8},
    { 728, 88, -8},
    { 712, 8, 0},
    { 712, -8, 0},
    { 768, -64, 32},
    { 1024, -24, 0},
    { 1040, 8, -56},
    { 1624, -120, 152},
    // 36 seconds
    { 1576, -48, 232},
    { 1104, 440, -40},
    { 1072, 424, -160},
    { 896, 216, 8},
    { 696, 64, 88},
    { 744, 216, 0},
    { 808, 296, -40},
    { 816, 312, -24},
    { 824, 336, -72},
    { 920, 352, -104},
    { 1064, 344, -104},
    { 1232, 240, -40},
    { 1784, 240, -32},
    { 1544, 272, 80},
    { 912, 312, 24},
    { 1024, 256, -8},
    { 1120, 80, 120},
    { 976, 48, 160},
    { 808, 120, 72},
    { 736, 96, 48},
    { 704, 56, 24},
    { 736, 40, 24},
    { 872, 24, 32},
    { 896, -48, 16},
    { 1136, 8, 0},
    // 37 seconds
    { 1168, -16, 48},
    { 1696, -88, 192},
    { 1152, 320, -48},
    { 1040, 408, -216},
    { 1024, 280, -56},
    { 728, 72, 104},
    { 752, 120, 120},
    { 784, 248, 16},
    { 792, 400, -72},
    { 800, 352, -80},
    { 904, 320, -88},
    { 1024, 360, -112},
    { 1168, 360, -128},
    { 1288, 256, 40},
    { 1616, 320, 80},
    { 1120, 400, 0},
    { 992, 264, 80},
    { 1136, 160, 152},
    { 1024, 144, 176},
    { 840, 120, 152},
    { 760, 88, 112},
    { 792, 72, 80},
    { 816, 0, 72},
    { 856, -16, 72},
    { 952, -96, 96},
    // 38 seconds
    { 1088, -16, 24},
    { 1120, -48, 48},
    { 1504, -56, 104},
    { 1096, 224, -24},
    { 1120, 296, -160},
    { 1056, 232, -8},
    { 760, 160, 56},
    { 696, 168, 64},
    { 792, 224, 40},
    { 832, 280, 24},
    { 856, 344, 24},
    { 912, 368, -80},
    { 960, 480, -136},
    { 1192, 344, -136},
    { 1288, 168, 24},
    { 1672, 232, 56},
    { 1208, 352, -16},
    { 888, 256, 24},
    { 992, 128, 120},
    { 1088, 56, 200},
    { 872, 64, 200},
    { 776, 80, 120},
    { 752, 88, 48},
    { 776, 40, 72},
    { 824, 16, 56},
    // 39 seconds
    { 904, -40, 48},
    { 1152, -96, 56},
    { 1112, -56, 24},
    { 1584, -176, 88},
    { 1272, 40, 64},
    { 936, 280, -160},
    { 976, 184, -144},
    { 824, 88, 24},
    { 712, 128, 56},
    { 784, 200, 16},
    { 864, 232, 8},
    { 840, 240, -24},
    { 864, 272, -88},
    { 952, 320, -144},
    { 1168, 280, -128},
    { 1264, 192, -48},
    { 1816, 208, 64},
    { 1488, 296, 40},
    { 896, 296, -40},
    { 928, 136, 24},
    { 1096, 96, 128},
    { 968, 96, 120},
    { 856, 136, 56},
    { 744, 72, 64},
    { 688, 32, 48},
    // 40 seconds
    { 696, -8, 64},
    { 712, -48, 96},
    { 912, -48, 96},
    { 1128, 16, 64},
    { 1304, -80, 128},
    { 1728, -128, 224},
    { 1136, 328, -104},
    { 1008, 352, -240},
    { 1024, 280, -32},
    { 720, 128, 56},
    { 768, 136, 96},
    { 832, 256, 16},
    { 840, 344, 0},
    { 824, 304, -40},
    { 912, 312, -80},
    { 1048, 312, -128},
    { 1168, 248, -80},
    { 1208, 152, 104},
    { 1800, 288, 128},
    { 1200, 432, 72},
    { 872, 296, 88},
    { 1032, 184, 168},
    { 1120, 120, 224},
    { 904, 96, 200},
    { 768, 96, 128},
    // 41 seconds
    { 744, 80, 64},
    { 744, 24, 32},
    { 744, 8, 64},
    { 808, 8, 24},
    { 976, 8, 40},
    { 1136, 40, 0},
    { 1592, -128, 120},
    { 1496, -24, 208},
    { 1064, 432, -104},
    { 1208, 288, -64},
    { 944, 280, 56},
    { 656, 88, 56},
    { 736, 152, 88},
    { 800, 232, 40},
    { 808, 280, 32},
    { 832, 288, -40},
    { 928, 352, -120},
    { 952, 328, -104},
    { 1240, 272, -80},
    { 1376, 144, 152},
    { 1608, 264, 104},
    { 1168, 408, 48},
    { 920, 288, 80},
    { 1104, 120, 208},
    { 1072, 80, 184},
    // 42 seconds
    { 912, 88, 144},
    { 816, 112, 64},
    { 784, 72, 16},
    { 744, 16, 16},
    { 728, 8, 16},
    { 824, -56, 40},
    { 1040, -72, 40},
    { 1080, 32, -16},
    { 1568, -72, 120},
    { 1440, 160, 88},
    { 1256, 296, 8},
    { 1072, 344, 56},
    { 744, 264, 88},
    { 752, 120, 136},
    { 768, 152, 104},
    { 800, 200, 88},
    { 776, 296, 0},
    { 824, 288, -16},
    { 1048, 376, -112},
    { 1168, 328, -96},
    { 1144, 160, 32},
    { 1864, 136, 136},
    { 1376, 360, 48},
    { 896, 320, 24},
    { 1040, 200, 104},
    // 43 seconds
    { 1088, 120, 192},
    { 920, 128, 176},
    { 760, 112, 136},
    { 784, 80, 104},
    { 824, 16, 120},
    { 848, 0, 104},
    { 952, 16, 40},
    { 1128, -72, 104},
    { 1064, -80, 80},
    { 1504, -120, 112},
    { 1376, 16, 112},
    { 968, 296, -112},
    { 1032, 192, -112},
    { 920, 104, 88},
    { 672, 104, 96},
    { 736, 176, 112},
    { 784, 272, 88},
    { 816, 272, 104},
    { 872, 280, 72},
    { 944, 328, 24},
    { 1184, 424, -192},
    { 1240, 184, -40},
    { 1672, 88, 0},
    { 1520, 264, 8},
    { 952, 272, -40},
    // 44 seconds
    { 880, 176, 24},
    { 1064, 96, 128},
    { 1032, 72, 224},
    { 856, 88, 128},
    { 784, 96, 64},
    { 792, 56, 64},
    { 792, 16, 72},
    { 800, 0, 56},
    { 920, -72, 56},
    { 1040, -48, 16},
    { 1216, -184, 184},
    { 1544, -112, 240},
    { 1168, 248, 48},
    { 1080, 320, -120},
    { 920, 176, -16},
    { 752, 24, 104},
    { 808, 144, 56},
    { 840, 248, 40},
    { 832, 296, 32},
    { 848, 328, 24},
    { 928, 360, -88},
    { 976, 264, -112},
    { 1240, 224, -136},
    { 1304, 120, 32},
    { 1752, 144, 48},
    // 45 seconds
    { 1288, 264, 8},
    { 1008, 168, 48},
    { 1072, 72, 128},
    { 992, 40, 176},
    { 832, 40, 168},
    { 712, 40, 112},
    { 680, 24, 112},
    { 736, 16, 72},
    { 840, 0, 40},
    { 944, -112, 128},
    { 1040, -136, 104},
    { 1016, -56, 64},
    { 1512, -152, 184},
    { 1280, 136, 160},
    { 1128, 272, 32},
    { 1264, 432, 0},
    { 864, 456, 160},
    { 784, 296, 104},
    { 728, 208, 176},
    { 792, 256, 136},
    { 792, 272, 120},
    { 832, 328, 48},
    { 904, 320, 8},
    { 1080, 248, -8},
    { 1144, 160, 64},
    // 46 seconds
    { 1592, 32, 240},
    { 1528, 208, 200},
    { 1000, 344, 136},
    { 960, 224, 104},
    { 1032, 152, 176},
    { 912, 104, 168},
    { 760, 72, 120},
    { 720, 72, 64},
    { 760, 56, 56},
    { 744, 8, 80},
    { 768, 8, 72},
    { 880, -48, 96},
    { 1144, 0, 48},
    { 1240, -48, 128},
    { 1776, -96, 272},
    { 1336, 312, 16},
    { 848, 424, -200},
    { 768, 104, 120},
    { 856, 88, 136},
    { 736, 56, 160},
    { 728, 192, 88},
    { 816, 288, 48},
    { 816, 304, 40},
    { 872, 296, -8},
    { 944, 272, -24},
    // 47 seconds
    { 1160, 280, -64},
    { 1192, 208, 32},
    { 1736, 224, 120},
    { 1472, 392, 48},
    { 904, 328, 40},
    { 1008, 200, 112},
    { 1224, 96, 168},
    { 992, 72, 200},
    { 840, 96, 128},
    { 800, 80, 96},
    { 776, 16, 96},
    { 728, -16, 80},
    { 760, -48, 96},
    { 912, -48, 80},
    { 968, 32, 0},
    { 1264, -168, 152},
    { 1568, -56, 272},
    { 1240, 400, -32},
    { 1152, 408, -112},
    { 1024, 272, 72},
    { 712, 104, 104},
    { 768, 136, 120},
    { 832, 304, 80},
    { 832, 328, 56},
    { 848, 336, 8},
    // 48 seconds
    { 920, 344, -16},
    { 1032, 392, -56},
    { 1208, 368, -48},
    { 1312, 288, 104},
    { 1848, 352, 104},
    { 1200, 432, 32},
    { 1000, 264, 80},
    { 1080, 112, 192},
    { 952, 128, 168},
    { 784, 80, 176},
    { 712, 64, 168},
    { 744, 32, 184},
    { 760, 8, 152},
    { 808, 24, 112},
    { 832, -24, 112},
    { 952, -16, 64},
    { 1064, 48, 16},
    { 1488, -88, 104},
    { 1392, 0, 184},
    { 1120, 304, -64},
    { 1056, 360, -176},
    { 968, 264, 40},
    { 752, 200, 88},
    { 768, 288, 32},
    { 840, 352, 40},
    // 49 seconds
    { 832, 328, 56},
    { 848, 344, -16},
    { 912, 392, -112},
    { 1064, 344, -144},
    { 1160, 200, -8},
    { 1744, 344, 72},
    { 1784, 248, 216},
    { 984, 304, 72},
    { 824, 208, 40},
    { 1008, 112, 160},
    { 992, 48, 200},
    { 864, 48, 152},
    { 768, 88, 88},
    { 736, 32, 80},
    { 744, 8, 80},
    { 776, -16, 80},
    { 880, -56, 88},
    { 1096, 8, -8},
    { 1208, -128, 88},
    { 1744, -208, 280},
    { 1256, 304, -16},
    { 1040, 360, -224},
    { 1016, 184, 32},
    { 744, 152, 128},
    { 752, 120, 88},
    // 50 seconds
    { 800, 208, 104},
    { 808, 272, 48},
    { 808, 272, 24},
    { 872, 296, -24},
    { 992, 304, -56},
    { 1224, 296, -72},
    { 1240, 224, 8},
    { 1696, 280, 32},
    { 1416, 384, 48},
    { 920, 304, 64},
    { 992, 192, 144},
    { 1152, 88, 224},
    { 928, 80, 224},
    { 824, 96, 152},
    { 776, 72, 112},
    { 792, 16, 120},
    { 776, 0, 104},
    { 840, -56, 136},
    { 992, -256, 136},
    { 1032, -48, -48},
    { 1584, -208, 120},
    { 1632, -40, 216},
    { 1152, 376, -128},
    { 1064, 216, -120},
    { 864, 224, 136},
    // 51 seconds
    { 696, 128, 96},
    { 784, 128, 120},
    { 840, 176, 136},
    { 832, 240, 96},
    { 840, 280, 48},
    { 904, 392, -64},
    { 1120, 416, -112},
    { 1264, 264, -16},
    { 1416, 120, 136},
    { 1664, 272, 152},
    { 1088, 416, 112},
    { 944, 200, 144},
    { 1136, 48, 248},
    { 1128, 40, 280},
    { 928, 72, 192},
    { 824, 56, 128},
    { 816, 24, 120},
    { 792, -16, 88},
    { 752, -48, 96},
    { 752, -112, 104},
    { 952, -64, 32},
    { 1064, -128, 120},
    { 1632, -280, 352},
    { 1544, 240, 56},
    { 1104, 448, -208},
    // 52 seconds
    { 1032, 272, -8},
    { 848, 200, 136},
    { 800, 96, 152},
    { 904, 192, 152},
    { 880, 304, 72},
    { 768, 328, 32},
    { 792, 304, 0},
    { 1008, 376, -120},
    { 1168, 296, -72},
    { 1272, 184, 48},
    { 1744, 240, 152},
    { 1528, 344, 112},
    { 896, 336, 64},
    { 936, 184, 168},
    { 1160, 104, 240},
    { 1024, 40, 264},
    { 856, 48, 184},
    { 768, 64, 128},
    { 736, 16, 136},
    { 712, -16, 104},
    { 760, -32, 96},
    { 888, -56, 80},
    { 1088, -32, 16},
    { 1152, -88, 88},
    { 1656, -40, 272},
    // 53 seconds
    { 1296, 72, 64},
    { 1176, 336, -248},
    { 960, 240, -40},
    { 736, 168, 80},
    { 776, 112, 80},
    { 824, 136, 80},
    { 856, 192, 72},
    { 800, 256, -16},
    { 880, 336, -80},
    { 1056, 336, -88},
    { 1232, 272, -48},
    { 1416, 144, 112},
    { 1912, 264, 168},
    { 1152, 336, 152},
    { 1008, 200, 104},
    { 1160, 120, 184},
    { 1096, 56, 240},
    { 944, 56, 168},
    { 816, 40, 120},
    { 776, 0, 120},
    { 752, -32, 96},
    { 744, -48, 88},
    { 776, -80, 80},
    { 984, -96, 40},
    { 1088, -104, 48},
    // 54 seconds
    { 1496, -176, 192},
    { 1496, 128, 112},
    { 1240, 376, -168},
    { 1104, 240, -24},
    { 840, 184, 144},
    { 752, 104, 128},
    { 856, 144, 160},
    { 856, 232, 144},
    { 808, 272, 96},
    { 872, 320, 8},
    { 1016, 336, 0},
    { 1152, 120, -56},
    { 1456, 368, 40},
    { 1816, 200, 120},
    { 1352, 368, 64},
    { 928, 248, 48},
    { 1008, 144, 128},
    { 1144, 96, 248},
    { 992, 88, 224},
    { 848, 40, 200},
    { 768, 56, 160},
    { 728, 24, 152},
    { 720, -8, 128},
    { 824, -56, 144},
    { 1000, -56, 136},
    // 55 seconds
    { 1048, 8, 24},
    { 1288, -168, 88},
    { 1528, -144, 280},
    { 1248, 208, 80},
    { 1160, 304, -72},
    { 952, 240, 80},
    { 720, 128, 136},
    { 728, 144, 160},
    { 792, 168, 216},
    { 864, 264, 160},
    { 856, 280, 128},
    { 984, 400, 16},
    { 1072, 392, -16},
    { 1208, 312, 24},
    { 1584, 224, 160},
    { 1648, 424, 144},
    { 1032, 384, 104},
    { 976, 216, 160},
    { 1200, 128, 264},
    { 1080, 80, 288},
    { 888, 48, 232},
    { 800, 56, 184},
    { 816, 8, 168},
    { 784, -24, 144},
    { 792, -48, 136},
    // 56 seconds
    { 872, -64, 112},
    { 1032, -48, 32},
    { 1016, -8, -40},
    { 1576, -192, 176},
    { 1360, 104, 136},
    { 1192, 248, -48},
    { 1232, 216, -24},
    { 880, 216, 152},
    { 736, 176, 128},
    { 816, 224, 152},
    { 848, 248, 176},
    { 816, 280, 144},
    { 832, 328, 16},
    { 960, 368, -64},
    { 1160, 376, -104},
    { 1296, 288, 0},
    { 1720, 296, 80},
    { 1416, 400, 96},
    { 960, 288, 112},
    { 1080, 184, 192},
    { 1256, 104, 288},
    { 1000, 80, 288},
    { 864, 56, 240},
    { 808, 64, 168},
    { 800, 0, 160},
    // 57 seconds
    { 776, -8, 120},
    { 808, -40, 112},
    { 936, -80, 80},
    { 976, -40, 48},
    { 1160, -152, 56},
    { 1632, -160, 256},
    { 1264, 304, 0},
    { 1128, 304, -96},
    { 1152, 176, 128},
    { 792, 208, 184},
    { 768, 208, 144},
    { 808, 240, 168},
    { 800, 272, 144},
    { 784, 288, 128},
    { 896, 376, 32},
    { 1024, 368, 24},
    { 1208, 384, -8},
    { 1448, 280, 152},
    { 1776, 408, 160},
    { 1112, 424, 80},
    { 960, 264, 104},
    { 1192, 136, 240},
    { 1120, 72, 288},
    { 888, 88, 224},
    { 800, 80, 184},
    // 58 seconds
    { 768, 32, 168},
    { 744, 0, 152},
    { 792, -16, 120},
    { 864, -40, 96},
    { 1024, -64, 80},
    { 1072, -96, 72},
    { 1528, -152, 224},
    { 1280, 160, 104},
    { 1136, 304, -104},
    { 1192, 224, -16},
    { 920, 224, 184},
    { 840, 208, 144},
    { 848, 296, 160},
    { 864, 304, 168},
    { 816, 320, 88},
    { 856, 368, -40},
    { 952, 424, -152},
    { 1160, 360, -112},
    { 1288, 232, 40},
    { 1912, 280, 176},
    { 1368, 360, 192},
    { 1008, 240, 160},
    { 1160, 128, 256},
    { 1176, 72, 328},
    { 984, 96, 264},
    // 59 seconds
    { 824, 64, 224},
    { 784, 40, 176},
    { 760, -16, 136},
    { 728, -32, 136},
    { 784, -56, 104},
    { 872, -72, 72},
    { 968, 24, -40},
    { 1208, -152, 24},
    { 1504, -64, 168},
    { 1416, 136, 144},
    { 1440, 296, -8},
    { 1096, 432, 48},
    { 728, 192, 200},
    { 824, 224, 168},
    { 864, 224, 248},
    { 840, 312, 192},
    { 808, 344, 88},
    { 840, 384, 8},
    { 992, 408, 16},
    { 1208, 480, -16},
    { 1424, 384, 144},
    { 1704, 328, 200},
    { 1072, 320, 88},
    { 1024, 216, 96},
    { 1168, 144, 200},
    // 60 seconds
    // elapsed: 1 minutes
    { 1032, 80, 224},
    { 872, 48, 184},
    { 816, 16, 184},
    { 888, 16, 160},
    { 840, -16, 128},
    { 784, 0, 112},
    { 824, -56, 96},
    { 984, -24, -40},
    { 1152, -120, 48},
    { 1768, -112, 200},
    { 1488, 320, -32},
    { 1096, 400, -184},
    { 776, 16, 24},
    { 856, 136, 112},
    { 840, 160, 160},
    { 792, 176, 152},
    { 840, 224, 144},
    { 832, 280, 120},
    { 824, 384, -40},
    { 984, 352, -16},
    { 1192, 432, -96},
    { 1272, 360, 40},
    { 1968, 440, 112},
    { 1256, 480, 8},
    { 848, 288, -32},
    // 61 seconds
    { 1072, 208, 88},
    { 1184, 64, 240},
    { 1064, 128, 144},
    { 912, 72, 136},
    { 808, 56, 72},
    { 720, -8, 48},
    { 664, -24, 56},
    { 680, -56, 64},
    { 784, -64, 40},
    { 1032, -16, 40},
    { 1408, -152, 184},
    { 1688, -80, 408},
    { 1528, 440, 24},
    { 1216, 544, -240},
    { 864, 240, 48},
    { 672, 192, 88},
    { 768, 288, 80},
    { 816, 176, 240},
    { 792, 280, 120},
    { 720, 256, 104},
    { 824, 368, -64},
    { 1056, 352, -88},
    { 1304, 432, -96},
    { 1720, 224, 112},
    { 1816, 312, 24},
    // 62 seconds
    { 1128, 272, 24},
    { 1016, 192, 64},
    { 1056, 104, 128},
    { 920, 96, 120},
    { 832, 40, 120},
    { 800, 32, 80},
    { 696, 40, 24},
    { 640, 8, 8},
    { 648, -16, 32},
    { 816, -32, 72},
    { 1120, 120, 88},
    { 1344, 200, 88},
    { 1768, 192, 240},
    { 1328, 488, 136},
    { 960, 616, -120},
    { 976, 256, 64},
    { 736, 176, 208},
    { 640, 96, 224},
    { 648, 184, 144},
    { 704, 192, 224},
    { 728, 272, 160},
    { 752, 248, 144},
    { 928, 352, 0},
    { 1144, 288, 32},
    { 1432, 328, 40},
    // 63 seconds
    { 1672, 232, 112},
    { 1800, 304, 208},
    { 1032, 480, 48},
    { 840, 264, -32},
    { 1104, 120, 232},
    { 1056, 48, 280},
    { 824, 24, 296},
    { 696, 40, 168},
    { 648, 16, 200},
    { 632, 32, 152},
    { 680, 8, 160},
    { 720, -8, 136},
    { 936, 16, 56},
    { 1160, 32, 40},
    { 1488, -144, 296},
    { 1800, 16, 360},
    { 1192, 568, -152},
    { 832, 528, -192},
    { 888, 128, 64},
    { 704, -56, 224},
    { 696, 32, 184},
    { 760, 184, 96},
    { 840, 336, 96},
    { 800, 392, 0},
    { 840, 328, -8},
    // 64 seconds
    { 1000, 368, -56},
    { 1256, 272, -32},
    { 1336, 144, 184},
    { 1760, 224, 152},
    { 1264, 344, 72},
    { 1040, 176, 88},
    { 1144, 136, 152},
    { 968, 120, 216},
    { 872, 112, 176},
    { 760, 152, 64},
    { 776, 64, 64},
    { 824, 56, 48},
    { 768, -8, 72},
    { 776, -80, 56},
    { 968, -104, 48},
    { 1032, 72, -48},
    { 1600, -56, 160},
    { 1592, 280, 48},
    { 1376, 512, -112},
    { 1144, 304, 48},
    { 752, 264, 144},
    { 672, 64, 200},
    { 736, 80, 248},
    { 800, 208, 192},
    { 784, 312, 184},
    // 65 seconds
    { 760, 376, 56},
    { 896, 376, 48},
    { 1104, 376, -104},
    { 1240, 384, -8},
    { 1688, 464, 24},
    { 1464, 480, 144},
    { 1064, 376, 96},
    { 1024, 328, 136},
    { 1200, 232, 176},
    { 1048, 152, 224},
    { 872, 72, 232},
    { 872, 40, 192},
    { 888, -16, 152},
    { 848, 8, 104},
    { 848, -8, 96},
    { 952, -112, 88},
    { 976, 0, -8},
    { 1360, -176, 88},
    { 1672, -112, 288},
    { 1144, 432, -104},
    { 1024, 256, -184},
    { 1104, 104, 160},
    { 920, 48, 224},
    { 816, 280, 224},
    { 920, 376, 224},
    // 66 seconds
    { 832, 440, 184},
    { 776, 360, 120},
    { 856, 288, 64},
    { 1080, 304, -32},
    { 1208, 320, -80},
    { 1312, 368, 56},
    { 1672, 624, -24},
    { 1288, 512, -8},
    { 1000, 280, 64},
    { 1176, 144, 192},
    { 1184, 72, 232},
    { 1000, 40, 256},
    { 744, 40, 240},
    { 816, 64, 112},
    { 808, 56, 56},
    { 808, -32, 112},
    { 896, -32, 40},
    { 1056, -80, 24},
    { 1000, -64, -32},
    { 1528, -128, 72},
    { 1544, 304, -216},
    { 1104, 344, -336},
    { 1096, -72, 40},
    { 800, 64, 160},
    { 808, 72, 216},
    // 67 seconds
    { 840, 200, 264},
    { 856, 264, 200},
    { 832, 208, 232},
    { 848, 296, 88},
    { 912, 272, 48},
    { 1176, 384, -72},
    { 1256, 392, -48},
    { 1944, 512, 16},
    { 1512, 584, 24},
    { 984, 296, -24},
    { 1072, 184, 128},
    { 1352, 48, -344},
    { 896, 32, 160},
    { 784, 64, 120},
    { 800, 88, 120},
    { 832, 40, 72},
    { 824, -8, 120},
    { 832, -48, 136},
    { 968, -112, 152},
    { 1056, 16, 8},
    { 1560, -192, 120},
    { 1632, -16, 192},
    { 1016, 384, -152},
    { 872, 288, -304},
    { 920, 168, -8},
    // 68 seconds
    { 768, 48, 144},
    { 840, 184, 64},
    { 936, 312, 72},
    { 912, 448, 0},
    { 856, 432, -24},
    { 928, 400, -168},
    { 1128, 272, -128},
    { 1232, 288, -88},
    { 1808, 264, 104},
    { 1744, 456, 80},
    { 856, 376, 24},
    { 992, 208, 56},
    { 1160, 88, 232},
    { 1000, 80, 216},
    { 872, 104, 112},
    { 824, 64, 136},
    { 792, 24, 88},
    { 768, -8, 96},
    { 760, -16, 80},
    { 864, -56, 32},
    { 984, 80, -128},
    { 1152, -312, 16},
    { 1824, -16, 176},
    { 1256, 344, 0},
    { 1280, 504, -184},
    // 69 seconds
    { 1080, 312, 120},
    { 664, 200, 176},
    { 704, 152, 80},
    { 728, 152, 152},
    { 816, 288, 64},
    { 816, 368, 16},
    { 912, 432, -72},
    { 960, 392, -48},
    { 1224, 384, -120},
    { 1424, 280, 144},
    { 2016, 408, 160},
    { 1256, 352, 88},
    { 920, 296, 16},
    { 1040, 240, 88},
    { 1152, 88, 168},
    { 912, 56, 176},
    { 792, 0, 152},
    { 728, 8, 160},
    { 696, 40, 104},
    { 696, 24, 88},
    { 792, -32, 128},
    { 1024, -48, 72},
    { 1096, 88, -40},
    { 1584, -120, 152},
    { 1736, -24, 224},
    // 70 seconds
    { 1208, 552, -144},
    { 992, 640, -192},
    { 880, 352, 152},
    { 696, 112, 208},
    { 752, 152, 200},
    { 864, 208, 256},
    { 784, 392, 104},
    { 696, 376, 40},
    { 816, 400, -16},
    { 1032, 320, 24},
    { 1240, 384, 40},
    { 1552, 368, 192},
    { 1648, 680, 144},
    { 1088, 592, 0},
    { 944, 376, 32},
    { 1152, 224, 120},
    { 1168, 104, 224},
    { 936, 192, 136},
    { 864, 112, 120},
    { 816, 24, 152},
    { 760, 0, 64},
    { 776, -16, 104},
    { 856, 0, 48},
    { 920, -88, 8},
    { 992, -56, -72},
    // 71 seconds
    { 1592, -200, 88},
    { 1496, 56, 64},
    { 1296, 360, -264},
    { 1176, 384, -136},
    { 896, 296, 56},
    { 752, 64, 72},
    { 816, 96, 128},
    { 896, 224, 104},
    { 816, 296, 32},
    { 792, 320, -64},
    { 896, 320, -72},
    { 1088, 304, -96},
    { 1384, 320, -144},
    { 1584, 192, -56},
    { 1704, 280, -32},
    { 1104, 280, -8},
    { 1080, 184, 48},
    { 1208, 40, 200},
    { 1104, 48, 208},
    { 944, 32, 192},
    { 792, 32, 192},
    { 752, 24, 120},
    { 784, -16, 128},
    { 760, 0, 112},
    { 816, -96, 144},
    // 72 seconds
    { 912, -48, 16},
    { 1040, 0, -72},
    { 1664, -304, 184},
    { 1600, 120, 192},
    { 1392, 528, -192},
    { 1072, 528, -144},
    { 784, 192, 104},
    { 752, 136, 136},
    { 896, 184, 152},
    { 872, 264, 168},
    { 744, 424, 32},
    { 704, 344, 16},
    { 848, 384, -48},
    { 1168, 352, 0},
    { 1304, 360, -96},
    { 1544, 272, 24},
    { 1840, 400, 32},
    { 1160, 432, -16},
    { 1008, 232, 56},
    { 1168, 184, 160},
    { 1120, 104, 104},
    { 864, 0, 200},
    { 760, 16, 152},
    { 744, 24, 120},
    { 728, 32, 112},
    // 73 seconds
    { 696, 8, 104},
    { 856, -56, 128},
    { 1032, 40, -16},
    { 1064, 8, -104},
    { 1872, 200, 144},
    { 1312, 464, -216},
    { 1168, 296, -160},
    { 976, 144, -16},
    { 704, 56, 88},
    { 672, 216, -24},
    { 696, 160, 184},
    { 848, 328, 136},
    { 848, 504, 40},
    { 840, 664, -72},
    { 848, 576, -8},
    { 1216, 368, -64},
    { 1368, 240, 56},
    { 1872, 464, 0},
    { 1368, 480, -24},
    { 936, 320, -48},
    { 1048, 240, 24},
    { 1144, 168, 120},
    { 1088, 136, 208},
    { 880, 144, 48},
    { 824, 96, 80},
    // 74 seconds
    { 760, 64, 64},
    { 704, 24, 56},
    { 768, -24, 32},
    { 872, -16, -72},
    { 936, 96, -184},
    { 1312, -48, -112},
    { 1536, 80, 96},
    { 1624, 280, 128},
    { 1360, 488, -136},
    { 920, 624, -32},
    { 744, 296, 128},
    { 768, 200, 160},
    { 832, 216, 160},
    { 912, 336, 152},
    { 816, 560, -56},
    { 840, 504, -80},
    { 1016, 520, -176},
    { 1184, 376, -88},
    { 1536, 344, 24},
    { 1664, 512, 56},
    { 1136, 416, 72},
    { 1128, 272, 136},
    { 1280, 184, 232},
    { 1176, 96, 264},
    { 992, 88, 200},
    // 75 seconds
    { 824, 56, 192},
    { 744, 40, 128},
    { 680, 32, 56},
    { 736, -8, 128},
    { 872, -56, 136},
    { 976, -8, 16},
    { 1040, 8, -40},
    { 1040, -144, 248},
    { 1456, 240, 16},
    { 1360, 448, -256},
    { 1192, 456, -136},
    { 824, 280, 152},
    { 752, 256, 152},
    { 824, 248, 192},
    { 848, 320, 192},
    { 768, 336, 128},
    { 728, 344, 16},
    { 848, 384, -88},
    { 1168, 472, -168},
    { 1304, 480, -112},
    { 1840, 464, -16},
    { 1544, 496, -64},
    { 1008, 360, -32},
    { 1120, 240, 40},
    { 1280, 112, 128},
    // 76 seconds
    { 1024, 32, 216},
    { 824, 80, 152},
    { 840, 104, 80},
    { 776, -16, 152},
    { 768, 8, 48},
    { 760, -48, 120},
    { 824, -120, 136},
    { 936, -24, 48},
    { 1104, -112, 40},
    { 1680, -152, 264},
    { 1400, 344, -48},
    { 1224, 536, -376},
    { 1096, 320, -96},
    { 888, -192, 0},
    { 696, 352, -128},
    { 928, 296, 80},
    { 856, 224, 72},
    { 776, 360, -72},
    { 832, 368, -120},
    { 952, 432, -216},
    { 1288, 336, -160},
    { 1272, 272, 8},
    { 1872, 336, 96},
    { 1336, 424, 48},
    { 856, 280, 16},
    // 77 seconds
    { 1032, 176, 96},
    { 1112, 88, 152},
    { 952, 80, 152},
    { 808, 96, 120},
    { 720, 112, 80},
    { 736, 80, 80},
    { 768, 56, 64},
    { 848, 8, 64},
    { 1072, -72, 72},
    { 1104, -8, -16},
    { 1488, -184, 120},
    { 1504, -64, 176},
    { 1168, 384, -96},
    { 1072, 424, -216},
    { 880, 240, 40},
    { 664, 128, 104},
    { 712, 176, 72},
    { 824, 192, 144},
    { 896, 320, 56},
    { 856, 376, -48},
    { 888, 480, -200},
    { 1160, 440, -224},
    { 1336, 304, -120},
    { 1672, 288, -16},
    { 1528, 416, -16},
    // 78 seconds
    { 1104, 400, 0},
    { 1128, 240, 144},
    { 1280, 120, 248},
    { 1080, 96, 216},
    { 872, 80, 160},
    { 768, 120, 72},
    { 736, 48, 64},
    { 736, 0, 40},
    { 680, -32, 40},
    { 808, -80, 104},
    { 1120, -48, 8},
    { 1064, 0, 0},
    { 1672, -64, 88},
    { 1464, 216, 0},
    { 1048, 536, -384},
    { 1272, 416, -96},
    { 1032, 328, 104},
    { 752, 224, 72},
    { 744, 200, 128},
    { 768, 288, 56},
    { 704, 272, 72},
    { 784, 336, -8},
    { 928, 400, -40},
    { 1168, 448, -112},
    { 1288, 336, -88},
    // 79 seconds
    { 1656, 264, -24},
    { 1472, 408, -64},
    { 864, 424, -96},
    { 1008, 288, 8},
    { 1240, 128, 144},
    { 1096, 96, 192},
    { 840, 136, 64},
    { 744, 112, 64},
    { 688, 72, 48},
    { 752, 48, 40},
    { 800, 0, 80},
    { 952, -64, 120},
    { 1104, -8, 56},
    { 1344, -88, 120},
    { 1688, -40, 232},
    { 1080, 392, -88},
    { 872, 320, -168},
    { 1088, 200, 32},
    { 832, 160, 128},
    { 784, 208, 96},
    { 832, 280, 80},
    { 752, 320, 32},
    { 712, 280, 24},
    { 864, 296, 40},
    { 904, 328, -40},
    // 80 seconds
    { 1224, 512, -184},
    { 1280, 456, -80},
    { 1808, 352, 40},
    { 1360, 408, -48},
    { 928, 288, 24},
    { 1112, 200, 128},
    { 1272, 120, 240},
    { 1040, 96, 256},
    { 832, 128, 168},
    { 736, 88, 208},
    { 704, 64, 184},
    { 696, 40, 64},
    { 768, -72, 56},
    { 856, -152, 48},
    { 1040, -8, -64},
    { 1376, -168, 72},
    { 1872, -48, 224},
    { 1296, 408, -16},
    { 1224, 408, -168},
    { 1072, 368, 120},
    { 688, 184, 176},
    { 768, 176, 128},
    { 808, 160, 224},
    { 816, 304, 120},
    { 792, 344, 80},
    // 81 seconds
    { 840, 336, -72},
    { 1024, 424, -160},
    { 1264, 304, -8},
    { 1504, 104, 208},
    { 1760, 496, 56},
    { 952, 464, 0},
    { 880, 280, 48},
    { 1064, 104, 200},
    { 1112, 56, 208},
    { 912, 64, 168},
    { 848, 64, 128},
    { 800, 136, 48},
    { 784, 48, 104},
    { 752, -24, 128},
    { 856, -80, 144},
    { 968, -72, 24},
    { 1048, 56, -32},
    { 1680, -112, 184},
    { 1376, 176, 32},
    { 1184, 416, -152},
    { 968, 288, -32},
    { 760, 32, 184},
    { 744, 32, 128},
    { 808, 200, 64},
    { 848, 264, 96},
    // 82 seconds
    { 840, 360, 16},
    { 896, 384, -56},
    { 952, 384, -152},
    { 1184, 288, -168},
    { 1208, 168, 8},
    { 1848, 256, 120},
    { 1312, 424, 32},
    { 1088, 312, 80},
    { 1120, 144, 240},
    { 1120, 120, 288},
    { 936, 72, 248},
    { 784, 88, 160},
    { 752, 48, 112},
    { 728, -16, 128},
    { 752, 0, 56},
    { 816, -72, 120},
    { 1008, -88, 104},
    { 1048, 8, 64},
    { 1640, -208, 232},
    { 1648, 8, 184},
    { 1192, 384, -184},
    { 1120, 256, -136},
    { 896, 88, 144},
    { 752, 16, 208},
    { 752, 272, 152},
    // 83 seconds
    { 872, 320, 216},
    { 784, 344, 128},
    { 784, 336, 48},
    { 928, 464, -64},
    { 1056, 296, -72},
    { 1200, 136, -96},
    { 1544, 144, -16},
    { 1576, 320, -8},
    { 1096, 440, -48},
    { 1080, 256, 48},
    { 1264, 144, 128},
    { 1120, 72, 136},
    { 936, 96, 72},
    { 872, 64, 40},
    { 800, -8, 80},
    { 736, -72, 96},
    { 680, -80, 112},
    { 720, -80, 88},
    { 960, -24, 24},
    { 1072, 8, -24},
    { 1176, -8, 264},
    { 1624, 368, 168},
    { 1200, 624, -240},
    { 1032, 376, -72},
    { 848, 168, 104},
    // 84 seconds
    { 672, 248, 144},
    { 648, 296, 136},
    { 736, 336, 144},
    { 776, 384, 96},
    { 768, 480, -72},
    { 824, 392, -80},
    { 1080, 216, -64},
    { 1240, 136, 40},
    { 1720, 248, 32},
    { 1424, 488, -32},
    { 952, 464, -48},
    { 1176, 304, 56},
    { 1232, 152, 152},
    { 1096, 136, 112},
    { 952, 112, 80},
    { 872, 88, 24},
    { 808, 16, 40},
    { 736, -24, 0},
    { 656, -56, 16},
    { 768, -112, 32},
    { 1056, -24, 0},
    { 1288, -96, 160},
    { 1872, -72, 360},
    { 1512, 336, 80},
    { 1048, 544, -152},
    // 85 seconds
    { 1048, 216, 152},
    { 872, 144, 200},
    { 760, 168, 192},
    { 872, 224, 192},
    { 776, 328, 136},
    { 664, 360, 32},
    { 736, 384, -32},
    { 912, 416, -104},
    { 1144, 336, -72},
    { 1256, 312, -80},
    { 1608, 344, 0},
    { 1512, 384, 8},
    { 1008, 360, 16},
    { 1048, 288, 56},
    { 1352, 208, 136},
    { 1128, 112, 144},
    { 920, 104, 96},
    { 832, 104, 32},
    { 760, 40, 56},
    { 712, 0, 56},
    { 696, -8, 24},
    { 792, -88, 64},
    { 968, -8, 0},
    { 1008, 40, -24},
    { 1088, -168, 280},
    // 86 seconds
    { 1448, 40, 216},
    { 1240, 368, -56},
    { 1144, 376, -48},
    { 928, 200, 192},
    { 776, 88, 176},
    { 752, 264, 160},
    { 808, 408, 112},
    { 816, 432, 56},
    { 904, 520, -96},
    { 936, 352, -24},
    { 992, 384, -216},
    { 1192, 648, -40},
    { 1808, 504, -32},
    { 1432, 416, -40},
    { 1080, 312, 48},
    { 1200, 216, 112},
    { 1248, 40, 144},
    { 968, 24, 144},
    { 800, 48, 96},
    { 736, 56, 40},
    { 728, 32, 24},
    { 768, -40, 32},
    { 832, -72, 48},
    { 952, -144, 72},
    { 1016, -72, 24},
    // 87 seconds
    { 1512, -200, 128},
    { 1520, -56, 120},
    { 1152, 304, -136},
    { 1152, 328, -264},
    { 1032, 128, 56},
    { 816, 184, 64},
    { 848, 280, 32},
    { 872, 304, 72},
    { 800, 328, 48},
    { 776, 384, -48},
    { 880, 368, -136},
    { 1048, 312, -136},
    { 1248, 264, -120},
    { 1464, 168, 16},
    { 1656, 272, 16},
    { 1112, 352, 32},
    { 1104, 288, 32},
    { 1168, 120, 128},
    { 1104, 72, 80},
    { 952, 72, 96},
    { 768, 72, 56},
    { 736, 40, 32},
    { 720, -16, 48},
    { 752, -56, 64},
    { 840, -96, 64},
    // 88 seconds
    { 1024, -72, 16},
    { 1032, -48, -24},
    { 1600, -184, 136},
    { 1536, 0, 136},
    { 1192, 328, -128},
    { 1024, 400, -224},
    { 912, 112, 120},
    { 824, 168, 16},
    { 808, 208, 96},
    { 896, 336, 24},
    { 840, 384, -16},
    { 824, 408, -112},
    { 960, 384, -128},
    { 1144, 368, -176},
    { 1192, 264, -16},
    { 1856, 320, 56},
    { 1368, 416, 24},
    { 1136, 312, 64},
    { 1232, 160, 144},
    { 1216, 40, 208},
    { 1056, 80, 136},
    { 880, 72, 88},
    { 768, 40, 56},
    { 728, -16, 40},
    { 696, -24, 24},
    // 89 seconds
    { 752, -96, 32},
    { 920, -120, 40},
    { 976, -48, 0},
    { 1488, -200, 88},
    { 1648, -96, 216},
    { 1392, 376, -120},
    { 1280, 424, -200},
    { 1048, 240, 112},
    { 776, 120, 152},
    { 840, 248, 120},
    { 880, 384, 56},
    { 848, 392, 40},
    { 824, 448, -80},
    { 880, 424, -136},
    { 1104, 400, -168},
    { 1200, 344, -136},
    { 1688, 288, -16},
    { 1512, 360, 24},
    { 1056, 312, 48},
    { 1200, 256, 64},
    { 1272, 80, 208},
    { 1104, 64, 224},
    { 952, 112, 144},
    { 864, 120, 72},
    { 792, 16, 96},
    // 90 seconds
    { 768, -32, 32},
    { 792, -48, 0},
    { 880, -120, 120},
    { 904, -40, 8},
    { 1016, -24, -24},
    { 1544, -120, 192},
    { 1512, 192, 72},
    { 1440, 304, -64},
    { 1208, 384, -16},
    { 920, 272, 112},
    { 848, 288, 112},
    { 840, 288, 120},
    { 840, 360, 88},
    { 760, 400, -16},
    { 792, 384, -104},
    { 944, 384, -96},
    { 1192, 392, -96},
    { 1296, 312, 112},
    { 1808, 368, 136},
    { 1296, 392, 96},
    { 1136, 248, 144},
    { 1264, 104, 272},
    { 1304, 72, 240},
    { 1016, 48, 224},
    { 784, 88, 160},
    // 91 seconds
    { 736, 96, 72},
    { 720, 16, 96},
    { 704, -8, 48},
    { 808, -104, 96},
    { 984, -112, 56},
    { 984, -40, 32},
    { 1592, -120, 152},
    { 1624, 8, 248},
    { 1408, 432, -128},
    { 1144, 464, -168},
    { 952, 272, 136},
    { 800, 208, 144},
    { 792, 288, 64},
    { 848, 280, 136},
    { 792, 416, 24},
    { 792, 416, -8},
    { 944, 480, -40},
    { 1120, 440, -80},
    { 1168, 328, -32},
    { 1600, 176, 48},
    { 1608, 320, 136},
    { 1152, 304, 88},
    { 1112, 152, 168},
    { 1296, 24, 240},
    { 1072, -48, 288},
    // 92 seconds
    { 856, -24, 184},
    { 800, 0, 144},
    { 776, -24, 120},
    { 736, -48, 56},
    { 752, -72, 56},
    { 808, -112, 40},
    { 944, -144, 8},
    { 1048, -168, 16},
    { 1600, -328, 152},
    { 1488, 0, 88},
    { 1360, 288, -184},
    { 1232, 200, -112},
    { 920, 112, 64},
    { 816, 104, 88},
    { 840, 176, 152},
    { 888, 256, 112},
    { 824, 320, 72},
    { 864, 400, -72},
    { 960, 360, -104},
    { 1216, 320, -144},
    { 1248, 184, 32},
    { 1992, 248, 48},
    { 1336, 328, 96},
    { 1160, 216, 88},
    { 1248, 64, 184},
    // 93 seconds
    { 1240, -8, 232},
    { 1040, 32, 184},
    { 872, 8, 104},
    { 784, -40, 104},
    { 736, -72, 56},
    { 752, -64, 0},
    { 856, -72, 80},
    { 952, -120, 8},
    { 944, -96, 16},
    { 1464, -240, 64},
    { 1528, -112, 168},
    { 1240, 216, -24},
    { 1264, 216, -120},
    { 1096, 192, 120},
    { 872, 136, 144},
    { 912, 200, 144},
    { 928, 288, 144},
    { 888, 376, 80},
    { 856, 376, -8},
    { 928, 400, -112},
    { 1104, 376, -144},
    { 1232, 344, -120},
    { 1544, 224, 48},
    { 1648, 272, 72},
    { 1168, 296, 32},
    // 94 seconds
    { 1096, 200, 88},
    { 1264, 72, 192},
    { 1152, 40, 232},
    { 944, 24, 208},
    { 880, 16, 176},
    { 880, 0, 160},
    { 840, -32, 136},
    { 872, -64, 120},
    { 928, -112, 80},
    { 960, -96, 8},
    { 984, -112, -80},
    { 1432, -272, 104},
    { 1304, 40, 8},
    { 1304, 216, -168},
    { 1288, 144, -80},
    { 1048, 120, 192},
    { 920, 184, 160},
    { 904, 296, 192},
    { 904, 376, 160},
    { 840, 376, 88},
    { 848, 392, -8},
    { 992, 424, -72},
    { 1176, 392, -136},
    { 1192, 344, -40},
    { 1872, 392, 16},
    // 95 seconds
    { 1432, 400, 32},
    { 1080, 264, 48},
    { 1272, 120, 160},
    { 1392, 0, 232},
    { 1152, -16, 232},
    { 928, 0, 160},
    { 832, 8, 80},
    { 712, -40, 64},
    { 656, -80, 56},
    { 680, -104, 24},
    { 768, -104, -16},
    { 920, -16, -104},
    { 1272, -216, 8},
    { 1784, -224, 232},
    { 1520, 208, 80},
    { 1488, 304, -48},
    { 1280, 320, 128},
    { 912, 320, 144},
    { 832, 304, 120},
    { 824, 256, 112},
    { 800, 296, 64},
    { 752, 352, 24},
    { 840, 432, -40},
    { 1016, 448, -80},
    { 1176, 440, -120},
    // 96 seconds
    { 1416, 296, 40},
    { 1816, 344, 72},
    { 1328, 344, 88},
    { 1216, 256, 80},
    { 1320, 104, 200},
    { 1296, 96, 184},
    { 1016, -16, 240},
    { 840, 40, 176},
    { 840, 32, 104},
    { 728, -64, 128},
    { 744, -32, 48},
    { 776, -104, 72},
    { 904, -80, 16},
    { 968, -72, -40},
    { 1560, -192, 72},
    { 1560, -64, 216},
    { 1432, 320, -120},
    { 1344, 456, -296},
    { 1096, 288, 168},
    { 904, 336, 144},
    { 832, 264, 184},
    { 832, 312, 152},
    { 816, 336, 104},
    { 784, 360, 8},
    { 976, 416, -16},
    // 97 seconds
    { 1168, 440, 0},
    { 1240, 328, -16},
    { 1824, 336, 40},
    { 1488, 352, 104},
    { 1072, 208, 80},
    { 1152, 88, 184},
    { 1264, 24, 280},
    { 1088, -16, 256},
    { 880, -40, 248},
    { 792, -8, 168},
    { 808, -40, 168},
    { 816, -48, 184},
    { 856, -80, 160},
    { 864, -144, 144},
    { 912, -96, 16},
    { 1232, -248, 56},
    { 1520, -240, 168},
    { 1216, 128, -48},
    { 1320, 200, -224},
    { 1152, 136, 32},
    { 928, 136, 80},
    { 880, 152, 112},
    { 896, 200, 136},
    { 896, 232, 168},
    { 896, 296, 104},
    // 98 seconds
    { 904, 296, 64},
    { 1056, 408, -48},
    { 1248, 424, -136},
    { 1512, 336, 24},
    { 1840, 312, 176},
    { 1176, 256, 104},
    { 1184, 176, 96},
    { 1304, 56, 208},
    { 1216, -24, 240},
    { 1000, -8, 224},
    { 904, 8, 176},
    { 816, -48, 144},
    { 728, -88, 112},
    { 688, -128, 104},
    { 704, -152, 96},
    { 752, -104, 72},
    { 912, -8, -48},
    { 1640, -64, 56},
    { 1720, 104, 56},
    { 1456, 200, -56},
    { 1128, 232, -40},
    { 848, 160, 80},
    { 840, 96, 152},
    { 872, 160, 144},
    { 832, 184, 152},
    // 99 seconds
    { 864, 240, 80},
    { 896, 320, -16},
    { 1056, 392, -120},
    { 1216, 368, -200},
    { 1256, 224, -72},
    { 1720, 216, 16},
    { 1368, 384, 16},
    { 936, 304, 32},
    { 1152, 184, 144},
    { 1296, 64, 216},
    { 1048, 32, 232},
    { 872, 8, 176},
    { 880, 16, 112},
    { 816, -24, 96},
    { 856, -64, 120},
    { 896, -72, 144},
    { 976, -88, 96},
    { 936, -56, 48},
    { 1328, -248, 96},
    { 1384, -112, 128},
    { 1120, 264, -152},
    { 1208, 176, -192},
    { 1104, 120, 32},
    { 888, 120, 160},
    { 920, 184, 112},
    // 100 seconds
    { 872, 272, 184},
    { 896, 336, 120},
    { 856, 352, 64},
    { 944, 392, -104},
    { 1096, 312, -96},
    { 1208, 272, -64},
    { 1576, 280, 40},
    { 1608, 384, 144},
    { 1008, 352, 88},
    { 1000, 224, 136},
    { 1272, 104, 224},
    { 1200, 0, 256},
    { 936, 40, 184},
    { 808, 40, 88},
    { 768, 24, 64},
    { 768, 8, 120},
    { 824, 8, 72},
    { 872, -40, 104},
    { 1008, -40, 24},
    { 1040, -8, -56},
    { 1696, -280, 280},
    { 1480, 64, 152},
    { 1064, 368, -208},
    { 1080, 104, -8},
    { 992, 88, 280},
    // 101 seconds
    { 968, 216, 112},
    { 936, 232, 216},
    { 952, 472, 80},
    { 856, 432, 48},
    { 840, 392, -40},
    { 968, 360, -96},
    { 1152, 344, -112},
    { 1152, 280, -32},
    { 1696, 280, 72},
    { 1544, 320, 160},
    { 1072, 272, 128},
    { 1160, 192, 192},
    { 1232, 88, 288},
    { 1072, 48, 248},
    { 904, 32, 200},
    { 832, 32, 144},
    { 808, 8, 120},
    { 832, -16, 88},
    { 840, -40, 80},
    { 904, -128, 88},
    { 960, -96, 24},
    { 1240, -232, 88},
    { 1536, -136, 272},
    { 1232, 328, -56},
    { 1216, 296, -200},
    // 102 seconds
    { 1160, 128, 128},
    { 880, 192, 272},
    { 960, 304, 88},
    { 912, 304, 192},
    { 864, 312, 112},
    { 816, 296, 16},
    { 928, 384, -96},
    { 1088, 304, -104},
    { 1160, 208, 32},
    { 1600, 272, 64},
    { 1720, 328, 120},
    { 1064, 232, 88},
    { 1064, 176, 104},
    { 1272, 96, 232},
    { 1120, 40, 264},
    { 928, 16, 184},
    { 856, 24, 144},
    { 824, -8, 104},
    { 784, -56, 112},
    { 776, -80, 104},
    { 872, -136, 104},
    { 992, -88, 56},
    { 1008, -112, -32},
    { 1568, -216, 128},
    { 1272, 40, 184},
    // 103 seconds
    { 1120, 120, -168},
    { 1360, 232, -32},
    { 1072, 264, 240},
    { 872, 216, 192},
    { 856, 184, 192},
    { 848, 176, 208},
    { 888, 264, 120},
    { 952, 264, 64},
    { 1040, 248, -104},
    { 1256, 320, -136},
    { 1304, 280, -64},
    { 1456, 352, -88},
    { 1376, 344, -8},
    { 1224, 200, 80},
    { 1304, 56, 176},
    { 1264, -88, 256},
    { 1088, -64, 272},
    { 936, -16, 184},
    { 912, -32, 160},
    { 880, -72, 160},
    { 856, -80, 136},
    { 960, -136, 144},
    { 1032, -176, 128},
    { 864, -176, 56},
    { 1248, -296, -56},
    // 104 seconds
    { 1216, -168, 0},
    { 1144, -16, -168},
    { 1336, -24, -232},
    { 1352, 24, 16},
    { 1152, 152, 120},
    { 1096, 312, 160},
    { 1032, 376, 232},
    { 920, 296, 176},
    { 840, 232, 72},
    { 968, 240, 48},
    { 1088, 312, -96},
    { 1136, 240, -88},
    { 1680, 224, -32},
    { 1392, 288, 48},
    { 1128, 208, 88},
    { 1304, 80, 224},
    { 1432, 48, 296},
    { 1216, 0, 288},
    { 1008, 0, 224},
    { 928, 0, 192},
    { 968, -80, 160},
    { 864, -144, 208},
    { 824, -144, 144},
    { 848, -184, 88},
    { 880, -112, 48},
    // 105 seconds
    { 1016, -168, -112},
    { 1272, -272, 136},
    { 1328, 48, 40},
    { 1360, 96, -88},
    { 1384, 40, -8},
    { 1112, 112, 224},
    { 1040, 208, 176},
    { 984, 304, 200},
    { 944, 352, 176},
    { 856, 328, 120},
    { 856, 296, 24},
    { 944, 344, -8},
    { 1136, 384, -64},
    { 1344, 280, 96},
    { 1952, 360, 168},
    { 1296, 312, 136},
    { 1112, 152, 104},
    { 1328, 48, 136},
    { 1400, 128, 168},
    { 1080, -72, 248},
    { 928, -32, 184},
    { 872, -48, 160},
    { 840, -56, 112},
    { 808, -56, 88},
    { 800, -80, 88},
    // 106 seconds
    { 872, -136, 40},
    { 912, -128, 8},
    { 1368, -240, 64},
    { 1456, -88, 168},
    { 1280, 216, -88},
    { 1368, 120, -56},
    { 1288, 112, 240},
    { 1064, 224, 248},
    { 1000, 352, 176},
    { 880, 280, 224},
    { 864, 288, 144},
    { 848, 256, 80},
    { 904, 392, -64},
    { 1120, 392, -56},
    { 1200, 424, -56},
    { 1672, 344, 56},
    { 1648, 352, 160},
    { 1160, 216, 144},
    { 1248, 144, 144},
    { 1392, 48, 248},
    { 1264, -16, 280},
    { 1032, -8, 248},
    { 904, -40, 192},
    { 776, -88, 168},
    { 704, -96, 144},
    // 107 seconds
    { 680, -120, 128},
    { 744, -128, 96},
    { 888, -80, 32},
    { 1008, 8, -120},
    { 1488, -216, 32},
    { 1568, -72, 192},
    { 1568, 240, -8},
    { 1304, 288, -128},
    { 1008, 216, 192},
    { 944, 248, 216},
    { 896, 224, 216},
    { 912, 224, 248},
    { 840, 320, 112},
    { 768, 352, 8},
    { 800, 376, -96},
    { 896, 336, -136},
    { 1096, 304, -136},
    { 944, 96, 32},
    { 1952, 312, 48},
    { 1560, 264, 184},
    { 1192, 264, 208},
    { 1288, 304, 392},
    { 1304, 368, 560},
    { 1360, 224, 696},
    { 1400, 120, 840},
    // 108 seconds
    { 1112, 24, 688},
    { 952, 24, 480},
    { 824, 40, 312},
    { 720, 320, 152},
    { 488, 160, 320},
    { 544, 704, 320},
    { 440, 712, 520},
    { 320, 664, 528},
    { 168, 760, 392},
    { 104, 744, 432},
    { 24, 752, 400},
    { 64, 840, 568},
    { 152, 832, 712},
    { 80, 968, 512},
    { 32, 1000, 456},
    { -112, 1032, 448},
    { -16, 1016, 320},
    { -40, 984, 200},
    { -72, 1136, -80},
    { -56, 864, -224},
    { -32, 976, -400},
    { 64, 1024, -552},
    { 88, 696, -552},
    { 56, 344, -664},
    { 48, 216, -840},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:30:07 local
AccelRawData *activity_sample_walk_200_pbl_25297_12(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25297_12
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -232, -280, -1000},
    { -168, -280, -984},
    { -120, -240, -1088},
    { -296, -352, -872},
    { -224, -272, -1048},
    { -112, -248, -1072},
    { -256, -256, -1008},
    { -448, -360, -992},
    { 424, -216, -1016},
    { 56, -320, -1040},
    { 48, -328, -952},
    { -8, -224, -936},
    { 32, -96, -904},
    { -32, 200, -880},
    { -72, 240, -896},
    { -168, 304, -880},
    { -216, 408, -864},
    { -96, 488, -824},
    { -184, 664, -928},
    { -72, 680, -936},
    { -176, 720, -760},
    { -136, 760, -672},
    { -80, 816, -648},
    { -56, 728, -640},
    { -104, 832, -488},
    // 1 seconds
    { -176, 816, -448},
    { -120, 824, -384},
    { -176, 968, -264},
    { -216, 856, -288},
    { -120, 1016, -248},
    { -192, 1016, -168},
    { -208, 840, -200},
    { -248, 936, -32},
    { -272, 928, 0},
    { -280, 856, 48},
    { -152, 1016, -8},
    { -152, 1048, -80},
    { -104, 936, -64},
    { -248, 808, 112},
    { -288, 664, 168},
    { 40, 1088, -56},
    { -192, 888, 8},
    { -152, 952, -152},
    { -32, 904, -184},
    { 16, 944, -80},
    { 0, 856, -8},
    { 32, 632, -56},
    { 96, 416, -120},
    { 272, 400, -16},
    { 592, 544, 192},
    // 2 seconds
    { 848, 408, 128},
    { 1376, 600, 176},
    { 1416, 392, 272},
    { 1456, 256, 264},
    { 1416, 216, 216},
    { 1344, 296, 272},
    { 1280, 400, 208},
    { 1040, 624, 96},
    { 928, 464, 112},
    { 808, 400, 0},
    { 776, 240, 112},
    { 824, 360, -56},
    { 872, 320, -8},
    { 1256, 448, -16},
    { 1384, 400, 56},
    { 1688, 288, 88},
    { 1488, 312, 96},
    { 1176, 312, 24},
    { 856, 208, 88},
    { 1248, 104, 176},
    { 1296, -24, 256},
    { 1008, 40, 224},
    { 912, 56, 152},
    { 784, 80, 64},
    { 648, 80, 56},
    // 3 seconds
    { 568, 48, 16},
    { 632, 0, 32},
    { 792, -8, -16},
    { 1120, 64, -40},
    { 1744, -216, 304},
    { 2096, 120, 368},
    { 1248, 808, -368},
    { 832, 408, -176},
    { 808, 144, 104},
    { 824, 48, 240},
    { 856, 48, 216},
    { 816, 200, 224},
    { 736, 392, 80},
    { 744, 392, -56},
    { 856, 368, -72},
    { 1032, 408, -88},
    { 1328, 360, -48},
    { 1440, 240, 104},
    { 1776, 272, 128},
    { 1224, 376, 96},
    { 984, 248, 96},
    { 1144, 88, 192},
    { 1136, 80, 248},
    { 984, 88, 192},
    { 848, 104, 152},
    // 4 seconds
    { 792, 64, 128},
    { 760, 40, 88},
    { 792, -8, 120},
    { 856, 48, 112},
    { 1112, 72, -104},
    { 880, -224, -104},
    { 1440, -280, -40},
    { 1480, 0, 72},
    { 1096, 280, -168},
    { 1368, 192, -120},
    { 1240, 288, 88},
    { 784, 376, 152},
    { 800, 280, 112},
    { 904, 304, 104},
    { 848, 304, 88},
    { 824, 384, -64},
    { 936, 408, -88},
    { 1160, 464, -104},
    { 1256, 392, -40},
    { 1744, 288, 72},
    { 1752, 296, 120},
    { 1080, 288, 64},
    { 1048, 112, 184},
    { 1280, 16, 272},
    { 1088, 120, 256},
    // 5 seconds
    { 848, 104, 192},
    { 728, 56, 120},
    { 776, 24, 120},
    { 760, 24, 48},
    { 744, 0, 16},
    { 864, -112, 96},
    { 1016, -72, 40},
    { 1104, 32, -144},
    { 1576, -96, 192},
    { 1448, 168, 104},
    { 1568, 392, -104},
    { 1136, 424, -112},
    { 816, 216, 232},
    { 856, 368, 96},
    { 864, 240, 264},
    { 920, 272, 208},
    { 800, 408, 56},
    { 840, 432, -16},
    { 920, 464, -40},
    { 1216, 504, -104},
    { 1312, 312, 184},
    { 1976, 360, 136},
    { 1288, 272, 136},
    { 1168, 176, 112},
    { 1304, 32, 296},
    // 6 seconds
    { 1304, -40, 312},
    { 1048, 136, 216},
    { 880, 136, 144},
    { 824, 48, 112},
    { 784, 0, 136},
    { 728, -16, 104},
    { 744, -80, 96},
    { 872, -112, 48},
    { 1016, 32, -16},
    { 1400, -64, 32},
    { 1632, -96, 264},
    { 1512, 320, -32},
    { 1320, 384, -224},
    { 1048, 224, 120},
    { 960, 272, 168},
    { 1008, 200, 312},
    { 976, 312, 312},
    { 880, 464, 344},
    { 800, 632, 88},
    { 784, 552, 16},
    { 968, 560, -48},
    { 1192, 712, 48},
    { 1576, 696, 72},
    { 1584, 384, 120},
    { 1296, 392, 88},
    // 7 seconds
    { 1272, 264, 120},
    { 1536, 136, 240},
    { 1368, 48, 344},
    { 1088, 88, 264},
    { 952, 88, 200},
    { 880, 64, 152},
    { 840, 8, 136},
    { 760, 0, 80},
    { 784, -96, 56},
    { 856, -80, -32},
    { 896, -136, -96},
    { 1464, -208, 152},
    { 1488, 144, 0},
    { 1512, 296, -176},
    { 1496, 184, -40},
    { 1344, 352, 256},
    { 1064, 472, 200},
    { 968, 424, 256},
    { 960, 264, 288},
    { 864, 320, 160},
    { 808, 368, 8},
    { 904, 440, -88},
    { 1160, 456, -72},
    { 1288, 552, -72},
    { 1880, 504, 16},
    // 8 seconds
    { 1576, 456, 64},
    { 1192, 208, 64},
    { 1320, 128, 168},
    { 1472, 96, 248},
    { 1256, 120, 256},
    { 1040, 80, 208},
    { 952, 8, 208},
    { 912, 40, 184},
    { 848, 0, 136},
    { 808, -8, 88},
    { 832, -136, 48},
    { 824, -152, -56},
    { 1000, -200, -16},
    { 1432, -168, 168},
    { 1392, 168, 24},
    { 1488, 264, -104},
    { 1616, 224, -16},
    { 1304, 392, 128},
    { 1072, 288, 280},
    { 1080, 456, 240},
    { 960, 368, 176},
    { 904, 400, 16},
    { 920, 368, -32},
    { 984, 472, -160},
    { 1264, 488, -208},
    // 9 seconds
    { 1376, 376, 32},
    { 1856, 352, 128},
    { 1272, 296, 160},
    { 1248, 152, 208},
    { 1480, 32, 328},
    { 1416, 24, 352},
    { 1232, 72, 328},
    { 944, 32, 224},
    { 800, 24, 152},
    { 768, 24, 88},
    { 696, -24, 96},
    { 768, -72, 72},
    { 888, -88, -24},
    { 944, -64, -56},
    { 1368, -200, 112},
    { 1592, 8, 248},
    { 1464, 376, -120},
    { 1336, 256, -88},
    { 1296, 288, 168},
    { 1072, 368, 216},
    { 992, 488, 184},
    { 944, 376, 176},
    { 856, 312, 120},
    { 808, 384, -24},
    { 848, 440, -128},
    // 10 seconds
    { 1112, 504, -120},
    { 1256, 472, 88},
    { 1976, 456, 160},
    { 1616, 408, 96},
    { 1024, 248, 16},
    { 1264, 40, 144},
    { 1112, -376, 808},
    { 1344, 312, 96},
    { 992, 144, 120},
    { 976, 56, 200},
    { 928, -16, 160},
    { 792, -24, 128},
    { 656, -56, 96},
    { 584, -144, 80},
    { 776, -48, -24},
    { 1016, -160, 88},
    { 1472, -192, 304},
    { 1488, 200, 144},
    { 1568, 208, 48},
    { 1800, 504, -128},
    { 1304, 600, 152},
    { 944, 816, 80},
    { 912, 256, 120},
    { 952, 168, 136},
    { 936, 264, 80},
    // 11 seconds
    { 848, 408, -64},
    { 888, 464, -104},
    { 1304, 560, -112},
    { 1552, 464, 96},
    { 1992, 408, 192},
    { 1224, 168, 112},
    { 1264, 152, 144},
    { 1552, 56, 336},
    { 1512, 80, 360},
    { 1152, 120, 272},
    { 936, 48, 208},
    { 816, 0, 168},
    { 736, 32, 104},
    { 672, -24, 96},
    { 616, -144, 64},
    { 760, -128, -24},
    { 920, -24, -112},
    { 1432, -264, 184},
    { 1816, 48, 328},
    { 1616, 416, 16},
    { 1536, 440, -152},
    { 1368, 408, 152},
    { 1040, 304, 224},
    { 1096, 232, 184},
    { 1032, 352, 80},
    // 12 seconds
    { 880, 392, 0},
    { 872, 528, -136},
    { 864, 432, -272},
    { 1136, 528, -328},
    { 1304, 232, -104},
    { 1864, 192, -56},
    { 1656, 464, 40},
    { 1224, 376, 16},
    { 1360, 232, 112},
    { 1544, 40, 304},
    { 1304, 0, 360},
    { 1104, 56, 240},
    { 1000, 8, 256},
    { 944, -40, 232},
    { 888, -8, 160},
    { 752, -104, 104},
    { 696, -208, 72},
    { 752, -72, -48},
    { 936, -192, -56},
    { 1576, -88, 224},
    { 1344, 392, 8},
    { 1432, 288, -320},
    { 1624, 312, -80},
    { 1376, 208, 176},
    { 1040, 952, -120},
    // 13 seconds
    { 1064, 616, 208},
    { 928, 352, 208},
    { 784, 312, 56},
    { 776, 328, -16},
    { 944, 400, -64},
    { 1264, 424, -64},
    { 1376, 472, 96},
    { 1856, 464, 120},
    { 1376, 384, 72},
    { 1256, 224, 136},
    { 1296, 144, 168},
    { 1304, 40, 216},
    { 1144, 80, 200},
    { 992, 24, 192},
    { 904, 8, 128},
    { 856, 8, 88},
    { 824, 32, 80},
    { 808, 0, 32},
    { 848, -112, 0},
    { 864, -104, -16},
    { 1360, -240, 128},
    { 1512, 112, 48},
    { 1320, 288, -152},
    { 1456, 176, -40},
    { 1344, 360, 144},
    // 14 seconds
    { 1104, 424, 152},
    { 976, 456, 216},
    { 912, 336, 240},
    { 864, 232, 304},
    { 872, 368, 160},
    { 848, 448, 8},
    { 1112, 520, -8},
    { 1216, 608, -120},
    { 1464, 520, -96},
    { 1688, 536, 8},
    { 1248, 400, 8},
    { 1168, 248, 88},
    { 1432, 88, 160},
    { 1328, 128, 280},
    { 1080, 56, 304},
    { 888, 72, 208},
    { 864, 64, 144},
    { 848, 0, 136},
    { 768, 0, 72},
    { 832, -88, 104},
    { 920, -64, -8},
    { 840, -24, -112},
    { 1456, -208, 40},
    { 1488, -8, 80},
    { 1352, 328, -208},
    // 15 seconds
    { 1488, 304, -208},
    { 1168, 432, 32},
    { 920, 288, 88},
    { 928, 288, 152},
    { 936, 280, 208},
    { 856, 344, 96},
    { 856, 336, 40},
    { 936, 432, -112},
    { 1176, 456, -144},
    { 1280, 496, -160},
    { 1864, 488, -16},
    { 1600, 448, 48},
    { 1096, 208, 32},
    { 1224, 216, 24},
    { 1416, 88, 176},
    { 1144, 96, 168},
    { 1000, 96, 120},
    { 848, 32, 96},
    { 744, -40, 88},
    { 840, -24, 32},
    { 808, -8, -16},
    { 816, -112, -16},
    { 936, -120, -16},
    { 1096, -256, 32},
    { 1384, -120, 144},
    // 16 seconds
    { 1440, 200, 64},
    { 1432, 352, -144},
    { 1288, 400, 8},
    { 1016, 336, 160},
    { 896, 264, 144},
    { 912, 248, 128},
    { 960, 312, 48},
    { 920, 376, -72},
    { 904, 360, -120},
    { 992, 376, -168},
    { 1176, 368, -144},
    { 1416, 176, 176},
    { 1808, 360, 168},
    { 1224, 352, 152},
    { 1096, 200, 128},
    { 1232, 80, 248},
    { 1160, 80, 176},
    { 960, 80, 208},
    { 824, 88, 128},
    { 840, 24, 144},
    { 808, 8, 128},
    { 776, -16, 128},
    { 808, -48, 40},
    { 944, 40, 16},
    { 1072, 8, -8},
    // 17 seconds
    { 1536, -200, 104},
    { 1320, 88, 8},
    { 1088, 216, -192},
    { 1104, 104, -72},
    { 984, 168, 120},
    { 928, 224, 112},
    { 992, 328, 176},
    { 984, 440, 160},
    { 912, 496, 96},
    { 848, 408, 32},
    { 952, 328, -24},
    { 1184, 416, -128},
    { 1144, 520, -48},
    { 1728, 568, 80},
    { 1312, 448, 80},
    { 1072, 320, 88},
    { 1152, 224, 144},
    { 1352, 160, 240},
    { 1168, 160, 240},
    { 1024, 72, 224},
    { 944, 32, 160},
    { 856, -56, 160},
    { 728, -16, 64},
    { 712, -80, 96},
    { 784, -96, 8},
    // 18 seconds
    { 960, -48, 56},
    { 1128, -64, 8},
    { 1528, -144, 224},
    { 1336, 216, 88},
    { 1448, 256, -152},
    { 1360, 256, 112},
    { 968, 296, 248},
    { 832, 432, 184},
    { 776, 352, 192},
    { 848, 256, 200},
    { 816, 304, 120},
    { 864, 376, 32},
    { 912, 488, -96},
    { 1192, 416, -112},
    { 1344, 368, 24},
    { 1704, 400, 120},
    { 1424, 456, 72},
    { 1056, 288, 72},
    { 1200, 144, 192},
    { 1416, 128, 248},
    { 1072, 88, 184},
    { 864, 80, 152},
    { 880, 32, 136},
    { 840, -24, 120},
    { 760, -16, 32},
    // 19 seconds
    { 768, -64, 32},
    { 848, -120, -32},
    { 984, -40, -88},
    { 1328, -216, -48},
    { 1576, -80, 152},
    { 1344, 320, -64},
    { 1296, 256, -176},
    { 1264, 256, 152},
    { 992, 328, 160},
    { 904, 352, 208},
    { 888, 328, 200},
    { 848, 320, 112},
    { 816, 320, -32},
    { 888, 368, -144},
    { 1112, 368, -128},
    { 1192, 400, -128},
    { 1544, 272, 40},
    { 1720, 400, 112},
    { 1096, 352, 64},
    { 1096, 232, 104},
    { 1288, 80, 232},
    { 1152, -16, 208},
    { 936, 96, 160},
    { 832, 120, 88},
    { 840, -8, 120},
    // 20 seconds
    { 824, -16, 72},
    { 832, 8, 0},
    { 888, -72, 0},
    { 960, -80, -80},
    { 968, -72, -128},
    { 1464, -168, 72},
    { 1424, 184, 48},
    { 1304, 264, -176},
    { 1360, 320, -128},
    { 1040, 312, 56},
    { 808, 272, 56},
    { 840, 224, 104},
    { 912, 296, 80},
    { 872, 312, 24},
    { 848, 312, -96},
    { 840, 416, -200},
    { 1248, 592, -264},
    { 1328, 536, -64},
    { 1848, 416, 48},
    { 1552, 312, 72},
    { 1264, 216, 88},
    { 1312, 128, 96},
    { 1352, -8, 168},
    { 1024, 8, 192},
    { 848, 32, 136},
    // 21 seconds
    { 744, 40, 48},
    { 696, 0, 16},
    { 648, -32, -8},
    { 696, -72, -24},
    { 848, -120, -48},
    { 984, 16, -144},
    { 1448, -296, -40},
    { 1792, 32, 104},
    { 1576, 344, -96},
    { 1376, 360, -264},
    { 1224, 384, 24},
    { 832, 208, 104},
    { 888, 136, 160},
    { 928, 160, 160},
    { 888, 264, 120},
    { 808, 432, -88},
    { 856, 368, -48},
    { 1056, 496, -168},
    { 1160, 448, -184},
    { 1600, 368, -64},
    { 1824, 432, 32},
    { 1232, 304, 56},
    { 1136, 184, 88},
    { 1336, 56, 184},
    { 1248, 48, 208},
    // 22 seconds
    { 1040, 48, 200},
    { 832, 40, 168},
    { 816, 24, 152},
    { 792, 16, 120},
    { 776, -8, 88},
    { 904, -72, 56},
    { 984, -80, -88},
    { 984, -144, -224},
    { 1360, -264, -168},
    { 1368, -80, 48},
    { 1416, 408, -344},
    { 1512, 456, -368},
    { 1160, 464, 248},
    { 736, 376, 152},
    { 840, 208, 224},
    { 896, 160, 256},
    { 832, 264, 96},
    { 768, 280, 24},
    { 776, 384, -48},
    { 1168, 408, -104},
    { 1264, 608, -152},
    { 1880, 432, 24},
    { 1592, 376, 24},
    { 1048, 240, 8},
    { 1152, 200, 16},
    // 23 seconds
    { 1296, 112, 120},
    { 1104, 48, 184},
    { 928, 88, 64},
    { 800, -32, 120},
    { 744, -24, 80},
    { 768, -32, 32},
    { 792, -72, 72},
    { 896, -136, 40},
    { 992, -72, -40},
    { 1208, -288, 16},
    { 1736, -128, 176},
    { 1256, 360, -96},
    { 1264, 280, -192},
    { 1248, 328, 72},
    { 824, 224, 48},
    { 848, 184, 104},
    { 840, 264, 8},
    { 888, 304, 48},
    { 864, 384, -72},
    { 912, 384, -104},
    { 1040, 432, -128},
    { 1248, 368, -104},
    { 1312, 240, 40},
    { 1656, 376, 64},
    { 1184, 376, 72},
    // 24 seconds
    { 1096, 192, 144},
    { 1296, 88, 240},
    { 1200, 48, 232},
    { 984, 96, 176},
    { 840, 56, 120},
    { 800, 40, 80},
    { 768, -16, 40},
    { 760, -56, 8},
    { 784, -144, 8},
    { 976, -120, -56},
    { 960, -32, -168},
    { 1456, -184, 8},
    { 1520, 80, 72},
    { 1472, 336, -128},
    { 1376, 416, -112},
    { 976, 344, 96},
    { 760, 240, 72},
    { 792, 192, 128},
    { 888, 264, 104},
    { 896, 320, 88},
    { 856, 360, -32},
    { 928, 392, -128},
    { 1152, 616, -376},
    { 1256, 392, -152},
    { 1480, 384, 16},
    // 25 seconds
    { 1440, 392, 88},
    { 1080, 296, 48},
    { 1208, 208, 96},
    { 1224, 56, 216},
    { 1000, 80, 184},
    { 832, 104, 128},
    { 792, 48, 112},
    { 760, 0, 64},
    { 744, -16, 40},
    { 760, -64, 40},
    { 888, -64, -32},
    { 968, 0, -96},
    { 1400, -232, -24},
    { 1640, -32, 88},
    { 1456, 304, -88},
    { 1248, 432, -200},
    { 1000, 336, 72},
    { 864, 200, 128},
    { 904, 184, 184},
    { 872, 304, 96},
    { 832, 368, 56},
    { 784, 384, -32},
    { 880, 392, -88},
    { 984, 424, -176},
    { 1144, 416, -144},
    // 26 seconds
    { 1568, 296, 24},
    { 1712, 384, 112},
    { 1000, 384, 48},
    { 1136, 248, 72},
    { 1272, 144, 200},
    { 1224, 104, 264},
    { 976, 144, 176},
    { 904, 112, 120},
    { 912, 80, 88},
    { 904, -16, 120},
    { 872, -16, 56},
    { 832, -96, 48},
    { 928, -96, -56},
    { 856, -72, -120},
    { 1464, -224, 72},
    { 1312, 160, 56},
    { 1336, 264, -128},
    { 1504, 304, 24},
    { 1032, 344, 104},
    { 808, 288, 88},
    { 864, 264, 120},
    { 888, 240, 144},
    { 880, 336, 64},
    { 872, 384, 8},
    { 928, 488, -88},
    // 27 seconds
    { 1152, 512, -120},
    { 1152, 504, -104},
    { 1696, 424, 40},
    { 1528, 448, 88},
    { 1072, 312, 64},
    { 1184, 232, 104},
    { 1336, 112, 200},
    { 1160, 104, 208},
    { 912, 112, 136},
    { 848, 80, 112},
    { 784, 32, 72},
    { 704, -8, -24},
    { 760, -64, -24},
    { 856, -176, 112},
    { 984, -16, 16},
    { 1072, -32, 56},
    { 1656, -16, 136},
    { 1440, 216, 80},
    { 1224, 392, -112},
    { 1120, 320, 48},
    { 896, 240, 176},
    { 872, 200, 176},
    { 904, 192, 176},
    { 904, 344, 112},
    { 880, 464, -16},
    // 28 seconds
    { 856, 424, -96},
    { 992, 408, -192},
    { 1112, 272, -80},
    { 1256, 304, 88},
    { 1896, 336, 104},
    { 1240, 392, 72},
    { 1112, 192, 136},
    { 1240, 72, 216},
    { 1272, 32, 280},
    { 1032, 128, 184},
    { 944, 104, 128},
    { 928, 64, 128},
    { 816, -32, 112},
    { 808, -32, 48},
    { 768, -96, 48},
    { 872, -184, 48},
    { 936, -64, -40},
    { 1272, -240, 88},
    { 1560, -88, 152},
    { 1472, 312, -144},
    { 1400, 368, -224},
    { 1184, 144, 128},
    { 920, 144, 184},
    { 896, 272, 144},
    { 864, 320, 152},
    // 29 seconds
    { 856, 312, 144},
    { 816, 328, 48},
    { 856, 360, -24},
    { 1000, 344, -32},
    { 1224, 408, -72},
    { 1448, 368, 32},
    { 1576, 432, 104},
    { 1048, 384, 104},
    { 1184, 264, 144},
    { 1152, 176, 248},
    { 1248, 144, 232},
    { 1024, 176, 144},
    { 936, 104, 160},
    { 896, -32, 184},
    { 808, -56, 72},
    { 840, 24, 64},
    { 848, -72, 80},
    { 880, -144, 64},
    { 968, -192, 32},
    { 1528, -264, 104},
    { 1544, 56, -16},
    { 1280, 320, -280},
    { 1192, 256, -112},
    { 1040, 120, 160},
    { 928, 208, 168},
    // 30 seconds
    { 952, 288, 192},
    { 880, 384, 168},
    { 816, 368, 104},
    { 848, 360, 8},
    { 920, 368, -40},
    { 1168, 400, -136},
    { 1360, 312, 64},
    { 1928, 416, 88},
    { 1216, 424, 40},
    { 952, 312, 24},
    { 1160, 192, 144},
    { 1264, 152, 104},
    { 1040, 96, 184},
    { 880, 64, 152},
    { 864, 48, 96},
    { 800, -16, 120},
    { 760, -8, 72},
    { 816, -48, 88},
    { 880, -88, 32},
    { 928, 8, -40},
    { 1200, -136, 40},
    { 1664, -176, 256},
    { 1416, 304, 24},
    { 1344, 464, -168},
    { 1128, 368, 40},
    // 31 seconds
    { 736, 56, 184},
    { 832, 112, 112},
    { 872, 128, 184},
    { 864, 328, 96},
    { 760, 464, -32},
    { 856, 512, -200},
    { 1056, 408, -224},
    { 1304, 280, -120},
    { 1288, 120, 152},
    { 1704, 296, 136},
    { 1240, 408, 96},
    { 1144, 256, 120},
    { 1248, 96, 232},
    { 1200, 64, 256},
    { 984, 112, 192},
    { 832, 96, 104},
    { 808, 24, 120},
    { 752, -8, 80},
    { 728, -32, 40},
    { 728, -96, 88},
    { 920, -40, -24},
    { 1008, 64, -96},
    { 1512, -168, 96},
    { 1624, -16, 240},
    { 1352, 384, 16},
    // 32 seconds
    { 1240, 368, -16},
    { 1064, 344, 120},
    { 752, 144, 160},
    { 832, 168, 136},
    { 880, 256, 72},
    { 864, 304, 56},
    { 856, 296, 8},
    { 928, 408, -144},
    { 1080, 408, -160},
    { 1224, 448, -160},
    { 1712, 296, -8},
    { 1584, 424, 0},
    { 936, 376, 56},
    { 1008, 288, 136},
    { 1248, 184, 216},
    { 1080, 72, 304},
    { 888, 72, 256},
    { 816, 96, 192},
    { 832, 136, 120},
    { 880, 168, 88},
    { 936, -32, 152},
    { 1056, -88, 96},
    { 1048, -32, 16},
    { 1384, -160, 88},
    { 1560, 72, -32},
    // 33 seconds
    { 976, 336, -288},
    { 976, 384, -352},
    { 1016, 160, 8},
    { 816, 136, 144},
    { 904, 312, 88},
    { 888, 600, 0},
    { 800, 248, 168},
    { 960, 520, 32},
    { 768, 720, -80},
    { 824, 496, -16},
    { 1032, 536, 32},
    { 1568, 408, 48},
    { 1672, 336, -40},
    { 1000, 408, -24},
    { 1032, 240, -16},
    { 1200, 136, 104},
    { 1056, 56, 128},
    { 944, 72, 88},
    { 848, 40, 80},
    { 808, 8, 64},
    { 816, -24, 32},
    { 840, -64, 32},
    { 992, -136, 0},
    { 1024, -160, -64},
    { 1064, -184, -32},
    // 34 seconds
    { 1440, -240, 80},
    { 1232, 96, 32},
    { 1304, 168, -112},
    { 1136, 256, -72},
    { 824, 120, 88},
    { 872, 176, 112},
    { 880, 216, 104},
    { 896, 264, 48},
    { 880, 280, 0},
    { 944, 320, -96},
    { 1008, 288, -112},
    { 1216, 248, -120},
    { 1512, 40, 112},
    { 1608, 184, 96},
    { 1168, 248, 56},
    { 1200, 128, 104},
    { 1296, 16, 184},
    { 1072, 0, 224},
    { 880, 80, 152},
    { 784, 16, 136},
    { 736, -8, 104},
    { 776, -80, 112},
    { 768, -72, 56},
    { 848, -152, 40},
    { 1008, -136, 56},
    // 35 seconds
    { 1000, -136, -8},
    { 1464, -424, 216},
    { 1512, 136, 256},
    { 1280, 568, -136},
    { 1240, 536, -120},
    { 920, 296, 152},
    { 728, 208, 112},
    { 776, 280, 152},
    { 824, 320, 176},
    { 792, 432, 24},
    { 864, 424, -8},
    { 888, 440, -104},
    { 1096, 424, -104},
    { 1176, 408, -32},
    { 1800, 376, 88},
    { 1360, 408, 40},
    { 1016, 472, 104},
    { 1128, 312, 168},
    { 1248, 160, 264},
    { 1048, 128, 192},
    { 848, 112, 144},
    { 792, 104, 112},
    { 760, 72, 104},
    { 784, 32, 88},
    { 728, -8, 80},
    // 36 seconds
    { 880, -64, 88},
    { 1032, -16, 32},
    { 1032, -24, 8},
    { 1512, -72, 168},
    { 1344, 200, 104},
    { 1456, 384, -40},
    { 1232, 520, 16},
    { 792, 424, 96},
    { 792, 288, 160},
    { 808, 216, 184},
    { 768, 280, 128},
    { 712, 368, 16},
    { 912, 384, -16},
    { 960, 416, -96},
    { 1176, 344, -56},
    { 1248, 312, 80},
    { 1776, 400, 104},
    { 1216, 456, 56},
    { 1192, 344, 88},
    { 1296, 184, 208},
    { 1168, 96, 256},
    { 992, 104, 200},
    { 888, 152, 128},
    { 896, 96, 128},
    { 784, 8, 104},
    // 37 seconds
    { 760, -72, 64},
    { 832, -72, 104},
    { 864, -168, 48},
    { 920, -40, 0},
    { 1320, -104, 16},
    { 1512, 16, 152},
    { 1536, 288, 136},
    { 1384, 496, -56},
    { 1000, 424, 56},
    { 832, 256, 80},
    { 744, 200, 152},
    { 864, 320, 120},
    { 840, 336, 136},
    { 800, 504, -8},
    { 904, 480, -48},
    { 1176, 520, -128},
    { 1208, 400, -32},
    { 1424, 352, 24},
    { 1560, 392, 64},
    { 1168, 376, 72},
    { 1216, 216, 96},
    { 1256, 48, 200},
    { 992, 24, 224},
    { 816, 128, 144},
    { 736, 120, 112},
    // 38 seconds
    { 728, 72, 112},
    { 704, 16, 144},
    { 768, -8, 104},
    { 920, -48, 88},
    { 1056, -8, 16},
    { 1168, -96, 40},
    { 1600, -136, 192},
    { 1456, 248, -32},
    { 1264, 464, -264},
    { 1032, 320, 32},
    { 792, 128, 120},
    { 864, 192, 160},
    { 848, 248, 168},
    { 888, 360, 136},
    { 808, 424, 80},
    { 872, 424, 24},
    { 1040, 488, -80},
    { 1336, 456, -168},
    { 1568, 248, 32},
    { 1648, 224, 168},
    { 1256, 208, 176},
    { 1152, 120, 216},
    { 1216, 16, 208},
    { 1104, -72, 304},
    { 880, -56, 264},
    // 39 seconds
    { 776, -24, 152},
    { 792, -24, 128},
    { 824, -56, 88},
    { 800, -72, 40},
    { 776, -160, 24},
    { 864, -176, -16},
    { 1008, -200, 16},
    { 1544, -336, 144},
    { 1512, 24, 136},
    { 1480, 176, -96},
    { 1272, 216, -16},
    { 960, 152, 136},
    { 864, 232, 144},
    { 816, 216, 136},
    { 832, 224, 152},
    { 864, 312, 64},
    { 896, 368, -32},
    { 960, 408, -88},
    { 1248, 336, -88},
    { 1176, 312, -40},
    { 1648, 248, 48},
    { 1616, 336, 96},
    { 1184, 240, 128},
    { 1136, 120, 216},
    { 1232, 80, 312},
    // 40 seconds
    { 1080, 72, 296},
    { 968, 56, 208},
    { 936, 24, 160},
    { 880, -24, 120},
    { 800, -48, 72},
    { 800, -88, 64},
    { 904, -128, 32},
    { 888, -32, -96},
    { 1160, -256, 0},
    { 1432, -224, 176},
    { 1424, 112, 80},
    { 1496, 248, -64},
    { 1232, 312, 56},
    { 904, 176, 192},
    { 952, 192, 248},
    { 944, 272, 232},
    { 904, 352, 200},
    { 872, 368, 64},
    { 872, 400, -64},
    { 992, 424, -152},
    { 1128, 416, -112},
    { 1368, 264, 104},
    { 1672, 360, 168},
    { 1184, 392, 120},
    { 1192, 248, 144},
    // 41 seconds
    { 1368, 112, 264},
    { 1192, 56, 296},
    { 1016, 80, 240},
    { 944, 72, 176},
    { 936, 0, 176},
    { 896, -32, 160},
    { 896, -24, 96},
    { 928, -112, 72},
    { 936, -152, 40},
    { 1088, -232, 40},
    { 1424, -248, 224},
    { 1328, 144, 56},
    { 1248, 280, -160},
    { 1232, 152, -8},
    { 1040, 144, 296},
    { 1064, 304, 176},
    { 976, 424, 224},
    { 960, 480, 136},
    { 888, 400, 72},
    { 904, 416, -32},
    { 1080, 424, -104},
    { 1104, 440, -168},
    { 1280, 312, 40},
    { 1632, 432, 96},
    { 1200, 472, 104},
    // 42 seconds
    { 1144, 320, 160},
    { 1328, 192, 248},
    { 1200, 48, 336},
    { 1008, 80, 304},
    { 888, 96, 32},
    { 952, 24, 192},
    { 920, -48, 128},
    { 960, -136, 88},
    { 624, -552, -8},
    { 928, -240, -72},
    { 1048, -144, 8},
    { 1552, -256, 208},
    { 1432, -72, 192},
    { 1464, 136, 16},
    { 1424, 232, -8},
    { 968, 272, 88},
    { 840, 144, 96},
    { 904, 152, 80},
    { 880, 208, 56},
    { 856, 304, -32},
    { 920, 328, -112},
    { 976, 344, -120},
    { 1224, 344, -160},
    { 1312, 200, 48},
    { 1960, 192, 152},
    // 43 seconds
    { 1328, 320, 136},
    { 1144, 176, 152},
    { 1256, 16, 216},
    { 1208, -16, 224},
    { 968, -16, 240},
    { 832, -16, 160},
    { 808, -64, 176},
    { 744, -80, 112},
    { 792, -48, 88},
    { 856, -112, 48},
    { 960, -176, 40},
    { 952, -128, -32},
    { 1432, -280, 72},
    { 1472, -160, 168},
    { 1352, 176, -16},
    { 1312, 312, -176},
    { 1080, 200, 160},
    { 752, 184, 216},
    { 944, 216, 168},
    { 928, 240, 176},
    { 848, 328, 64},
    { 880, 336, -8},
    { 1032, 288, 32},
    { 1032, 304, -136},
    { 1112, 344, -152},
    // 44 seconds
    { 1776, 328, 48},
    { 1400, 368, 152},
    { 1112, 232, 112},
    { 1168, 152, 192},
    { 1272, 32, 264},
    { 1000, -8, 280},
    { 832, 40, 144},
    { 824, 48, 128},
    { 816, 8, 64},
    { 832, -72, 64},
    { 984, -112, 104},
    { 1144, -136, 64},
    { 1032, -64, 16},
    { 1424, -208, -16},
    { 1400, -136, 104},
    { 1008, 136, -56},
    { 1136, 144, -96},
    { 984, 144, 72},
    { 792, 120, 104},
    { 840, 136, 152},
    { 912, 168, 192},
    { 936, 248, 168},
    { 952, 352, 40},
    { 968, 424, -48},
    { 1112, 408, -48},
    // 45 seconds
    { 1248, 352, -80},
    { 1424, 280, -8},
    { 1552, 352, 40},
    { 1176, 336, 88},
    { 1088, 208, 136},
    { 1216, 80, 216},
    { 1128, 40, 240},
    { 920, -64, 232},
    { 856, -32, 176},
    { 864, -16, 128},
    { 864, -40, 112},
    { 928, -40, 80},
    { 1016, -144, 72},
    { 976, -128, 16},
    { 1120, -272, -8},
    { 1288, -208, 120},
    { 1240, 56, 56},
    { 1224, 168, -120},
    { 1136, 104, -32},
    { 896, 64, 200},
    { 960, 192, 144},
    { 968, 280, 184},
    { 936, 296, 184},
    { 856, 296, 88},
    { 888, 312, -32},
    // 46 seconds
    { 1032, 336, -80},
    { 1216, 320, -48},
    { 1336, 208, 88},
    { 1696, 336, 120},
    { 1272, 352, 152},
    { 1088, 216, 120},
    { 1264, 80, 224},
    { 1288, 40, 288},
    { 1088, -24, 256},
    { 928, -24, 208},
    { 904, -16, 144},
    { 856, -72, 136},
    { 800, -96, 120},
    { 824, -144, 96},
    { 920, -136, 48},
    { 904, -80, -24},
    { 1384, -256, 40},
    { 1312, -32, 88},
    { 1288, 16, 96},
    { 1376, 104, 72},
    { 1224, 264, 216},
    { 1048, 344, 208},
    { 952, 384, 240},
    { 920, 280, 192},
    { 840, 232, 112},
    // 47 seconds
    { 880, 328, -48},
    { 968, 336, -88},
    { 1160, 384, -152},
    { 1200, 296, -40},
    { 1816, 312, -24},
    { 1368, 320, 160},
    { 1192, 256, 136},
    { 1240, 120, 248},
    { 1336, 8, 320},
    { 1136, 0, 304},
    { 968, 48, 208},
    { 952, 8, 176},
    { 872, -40, 144},
    { 864, -40, 80},
    { 864, -88, 80},
    { 912, -192, 48},
    { 944, -128, 32},
    { 1224, -280, 32},
    { 1224, -176, 24},
    { 1336, -56, -96},
    { 1496, 104, -104},
    { 1352, 240, -24},
    { 1096, 240, 160},
    { 1048, 416, 200},
    { 976, 368, 280},
    // 48 seconds
    { 840, 312, 216},
    { 864, 336, 112},
    { 920, 344, -32},
    { 1104, 416, -184},
    { 1208, 432, -240},
    { 1504, 272, -184},
    { 1400, 224, -72},
    { 1264, 192, 112},
    { 1384, 240, 80},
    { 1352, 88, 216},
    { 1256, 8, 320},
    { 1080, 72, 320},
    { 984, 40, 216},
    { 936, 8, 144},
    { 888, -40, 144},
    { 880, -176, 112},
    { 864, -312, 32},
    { 848, -248, 8},
    { 1232, -232, -32},
    { 1360, -152, 80},
    { 1400, 72, 24},
    { 1536, 176, -72},
    { 1392, 224, 40},
    { 1072, 256, 224},
    { 1032, 416, 192},
    // 49 seconds
    { 944, 360, 232},
    { 920, 280, 192},
    { 904, 320, 88},
    { 952, 464, -80},
    { 992, 400, -80},
    { 1312, 648, -136},
    { 1608, 440, 104},
    { 1536, 400, 200},
    { 1232, 232, 184},
    { 1304, 128, 296},
    { 1440, 64, 368},
    { 1200, 32, 336},
    { 1016, 24, 248},
    { 928, 0, 208},
    { 920, -16, 160},
    { 920, -56, 136},
    { 888, -192, 72},
    { 840, -328, -32},
    { 840, -248, -104},
    { 1168, -264, -48},
    { 1528, -256, 200},
    { 1400, 24, 192},
    { 1576, 152, -8},
    { 1504, 320, 96},
    { 1104, 224, 304},
    // 50 seconds
    { 1016, 296, 248},
    { 984, 288, 200},
    { 928, 312, 152},
    { 856, 400, 72},
    { 888, 456, -8},
    { 992, 456, 48},
    { 1160, 496, 88},
    { 1688, 440, 128},
    { 1664, 248, 208},
    { 1264, 160, 232},
    { 1336, 120, 264},
    { 1472, 48, 304},
    { 1224, -16, 312},
    { 1032, -48, 304},
    { 984, -120, 232},
    { 864, -64, 72},
    { 800, -224, 8},
    { 736, -296, 16},
    { 720, -336, 40},
    { 840, -208, 48},
    { 1144, -56, 56},
    { 1616, -72, 32},
    { 1504, -184, 120},
    { 1880, 32, 40},
    { 1512, 288, 32},
    // 51 seconds
    { 904, 272, 120},
    { 984, 232, 136},
    { 976, 216, 184},
    { 888, 96, 280},
    { 816, 248, 80},
    { 904, 304, 56},
    { 1040, 520, -24},
    { 1096, 496, -24},
    { 1176, 336, 40},
    { 1696, 360, 48},
    { 1400, 352, 88},
    { 1272, 184, 120},
    { 1352, 88, 200},
    { 1376, 40, 264},
    { 1064, 24, 200},
    { 944, 16, 184},
    { 936, -16, 176},
    { 880, -64, 184},
    { 888, -72, 128},
    { 912, -128, 96},
    { 984, -184, 112},
    { 912, -48, 56},
    { 1336, -192, 8},
    { 1360, -64, 168},
    { 1320, 176, -56},
    // 52 seconds
    { 1320, 152, -64},
    { 1216, 144, 112},
    { 1104, 152, 208},
    { 1088, 304, 232},
    { 1000, 376, 208},
    { 896, 328, 152},
    { 888, 360, 40},
    { 872, 368, 24},
    { 1040, 440, -32},
    { 1120, 448, 8},
    { 1672, 448, 128},
    { 1616, 400, 184},
    { 1224, 264, 136},
    { 1248, 144, 168},
    { 1368, 40, 248},
    { 1240, 8, 280},
    { 928, 32, 224},
    { 848, 0, 160},
    { 840, -40, 160},
    { 824, -64, 144},
    { 832, -64, 120},
    { 968, -112, 80},
    { 1080, -96, 40},
    { 1224, -248, 120},
    { 1336, -128, 176},
    // 53 seconds
    { 1120, 176, -8},
    { 1248, 288, -224},
    { 1248, 176, -24},
    { 1008, 168, 184},
    { 1024, 144, 152},
    { 960, 280, 216},
    { 888, 400, 128},
    { 792, 328, 112},
    { 904, 376, 32},
    { 1056, 336, 64},
    { 1248, 408, 16},
    { 1424, 320, 136},
    { 1584, 504, 88},
    { 1152, 368, 144},
    { 1240, 144, 192},
    { 1376, 96, 296},
    { 1120, 128, 272},
    { 968, 128, 160},
    { 904, 24, 176},
    { 832, -8, 152},
    { 856, -56, 96},
    { 856, -112, 136},
    { 944, -152, 112},
    { 992, -48, 32},
    { 1048, -120, -16},
    // 54 seconds
    { 1376, -136, 80},
    { 1376, 104, 32},
    { 1224, 216, -136},
    { 1200, 64, -32},
    { 1056, 136, 160},
    { 984, 232, 184},
    { 1016, 304, 264},
    { 936, 424, 280},
    { 824, 400, 152},
    { 888, 368, 48},
    { 1056, 384, 40},
    { 1096, 264, 8},
    { 1440, 384, 176},
    { 1536, 384, 192},
    { 1136, 336, 152},
    { 1072, 256, 168},
    { 1216, 176, 296},
    { 1168, 144, 336},
    { 952, 96, 320},
    { 864, 80, 240},
    { 864, 48, 152},
    { 912, -72, 216},
    { 944, -40, 120},
    { 944, -128, 112},
    { 960, -152, 56},
    // 55 seconds
    { 920, -80, -24},
    { 1448, -72, 80},
    { 1176, 152, 32},
    { 1312, -8, -64},
    { 1288, 128, -96},
    { 1016, 80, 128},
    { 920, 216, 88},
    { 912, 272, 168},
    { 928, 272, 208},
    { 880, 264, 112},
    { 896, 272, 32},
    { 976, 408, -88},
    { 1120, 392, -104},
    { 1136, 344, -40},
    { 1752, 352, 40},
    { 1480, 400, 128},
    { 1136, 264, 104},
    { 1144, 168, 184},
    { 1248, 112, 240},
    { 1104, 32, 224},
    { 888, 16, 192},
    { 824, 24, 144},
    { 816, -32, 144},
    { 824, -64, 144},
    { 928, -104, 152},
    // 56 seconds
    { 976, -96, 104},
    { 888, -80, 24},
    { 1320, -208, 32},
    { 1432, -120, 152},
    { 1368, 144, 0},
    { 1192, 192, -200},
    { 952, 88, 32},
    { 824, 80, 168},
    { 920, 232, 96},
    { 944, 240, 256},
    { 1000, 400, 160},
    { 920, 456, 104},
    { 968, 472, 32},
    { 1104, 408, 8},
    { 1136, 280, 144},
    { 1648, 376, 184},
    { 1328, 448, 152},
    { 1120, 280, 168},
    { 1200, 168, 232},
    { 1232, 128, 232},
    { 1016, 56, 224},
    { 872, 40, 168},
    { 856, 40, 144},
    { 840, -8, 136},
    { 856, -40, 136},
    // 57 seconds
    { 944, -88, 160},
    { 1032, -96, 104},
    { 960, -88, 40},
    { 1480, -192, 144},
    { 1424, -48, 160},
    { 1152, 272, -80},
    { 1064, 144, -104},
    { 904, 64, 168},
    { 824, 120, 184},
    { 912, 168, 232},
    { 976, 272, 256},
    { 976, 368, 224},
    { 912, 448, 112},
    { 960, 384, 16},
    { 1128, 320, -56},
    { 1192, 304, 56},
    { 1736, 400, 104},
    { 1344, 528, 40},
    { 1104, 328, 72},
    { 1112, 176, 184},
    { 1216, 136, 264},
    { 1032, 88, 232},
    { 952, 24, 232},
    { 968, 32, 216},
    { 912, -16, 184},
    // 58 seconds
    { 848, -32, 136},
    { 888, -80, 120},
    { 920, -136, 80},
    { 936, -48, -112},
    { 1336, -264, 64},
    { 1408, -40, 120},
    { 1384, 184, 8},
    { 1312, 216, -112},
    { 1040, 80, 184},
    { 944, 152, 192},
    { 1024, 216, 272},
    { 984, 312, 304},
    { 896, 368, 224},
    { 832, 376, 56},
    { 856, 384, -8},
    { 1104, 456, 8},
    { 1128, 400, 64},
    { 1664, 464, 152},
    { 1560, 488, 224},
    { 1128, 264, 184},
    { 1096, 192, 208},
    { 1352, 104, 288},
    { 1200, 72, 280},
    { 1000, 72, 128},
    { 928, 0, 208},
    // 59 seconds
    { 816, -88, 104},
    { 768, -16, 152},
    { 800, -64, 136},
    { 904, -128, 80},
    { 1024, -32, 72},
    { 1064, -120, 48},
    { 1256, -104, 168},
    { 1320, 88, 144},
    { 1376, 224, 96},
    { 1240, 360, 128},
    { 904, 200, 328},
    { 952, 320, 288},
    { 904, 320, 368},
    { 872, 336, 304},
    { 848, 408, 200},
    { 896, 448, 104},
    { 984, 472, 88},
    { 1080, 496, 88},
    { 1560, 336, 224},
    { 1704, 392, 296},
    { 1096, 256, 200},
    { 1160, 160, 176},
    { 1304, 56, 264},
    { 1120, 40, 248},
    { 928, 32, 200},
    // 60 seconds
    // elapsed: 1 minutes
    { 848, 8, 176},
    { 848, -32, 176},
    { 864, -24, 176},
    { 928, -40, 144},
    { 984, -160, 128},
    { 976, -128, 80},
    { 1400, -240, 104},
    { 1472, -112, 184},
    { 1240, 208, -72},
    { 1016, 192, -216},
    { 928, 88, -8},
    { 848, 80, 144},
    { 896, 200, 136},
    { 1000, 256, 200},
    { 976, 400, 112},
    { 920, 424, 48},
    { 912, 464, -72},
    { 1104, 360, -64},
    { 1136, 376, -80},
    { 1592, 400, 24},
    { 1696, 496, 88},
    { 1032, 360, 64},
    { 1040, 304, 32},
    { 1160, 176, 128},
    { 1112, 112, 184},
    // 61 seconds
    { 896, 88, 128},
    { 856, 64, 80},
    { 800, 40, 88},
    { 768, 0, 96},
    { 800, -8, 32},
    { 920, -48, 40},
    { 1024, 88, 48},
    { 1192, 32, -64},
    { 1496, 296, -32},
    { 1256, 520, -88},
    { 800, 544, -232},
    { 736, 384, -80},
    { 712, 256, 48},
    { 616, 272, 80},
    { 672, 256, 120},
    { 728, 312, 72},
    { 768, 376, -16},
    { 824, 384, -72},
    { 936, 360, -72},
    { 1128, 280, -24},
    { 1272, 288, 48},
    { 1944, 392, 144},
    { 1416, 520, 96},
    { 880, 360, 64},
    { 976, 304, 72},
    // 62 seconds
    { 968, 232, 160},
    { 776, 128, 168},
    { 688, 120, 80},
    { 728, 128, 80},
    { 776, 24, 128},
    { 864, 24, 128},
    { 1008, 8, 136},
    { 1208, 24, 64},
    { 1192, 32, 24},
    { 1616, -72, 80},
    { 1248, 80, 64},
    { 784, 264, -120},
    { 784, 208, -160},
    { 784, 200, -56},
    { 704, 80, 64},
    { 768, 200, 24},
    { 904, 280, 32},
    { 912, 360, 0},
    { 856, 376, -88},
    { 896, 328, -120},
    { 1104, 272, -64},
    { 1256, 232, 80},
    { 2016, 288, 184},
    { 1448, 424, 128},
    { 880, 304, 16},
    // 63 seconds
    { 888, 208, 56},
    { 944, 136, 144},
    { 808, 112, 168},
    { 720, 40, 160},
    { 728, 64, 136},
    { 768, 32, 152},
    { 888, 32, 128},
    { 984, 16, 136},
    { 1224, -32, 112},
    { 1296, -16, 88},
    { 1616, -56, 120},
    { 1120, 88, 104},
    { 776, 224, -112},
    { 880, 216, -152},
    { 824, 184, 16},
    { 792, 152, 24},
    { 840, 240, -48},
    { 944, 280, -24},
    { 880, 320, -64},
    { 832, 304, -112},
    { 856, 312, -136},
    { 1048, 232, -40},
    { 1296, 192, 56},
    { 1624, 224, 80},
    { 1336, 312, 32},
    // 64 seconds
    { 1000, 344, 8},
    { 880, 208, 64},
    { 1040, 152, 168},
    { 904, 128, 216},
    { 856, 80, 168},
    { 768, 96, 128},
    { 744, 56, 96},
    { 880, 0, 88},
    { 984, 8, 48},
    { 1192, -64, 48},
    { 1248, -32, 48},
    { 1552, -80, 112},
    { 1208, 144, 16},
    { 792, 248, -176},
    { 872, 192, -176},
    { 776, 224, -16},
    { 712, 144, 32},
    { 848, 216, 24},
    { 984, 272, 64},
    { 832, 352, 0},
    { 784, 416, -184},
    { 872, 432, -280},
    { 1256, 160, -104},
    { 1240, 208, -96},
    { 1520, 200, -24},
    // 65 seconds
    { 1520, 312, -80},
    { 1032, 336, -24},
    { 920, 248, 16},
    { 1048, 184, 88},
    { 952, 104, 168},
    { 832, 104, 96},
    { 768, 72, 80},
    { 768, 32, 72},
    { 800, 32, 40},
    { 904, -48, 80},
    { 1072, -56, -16},
    { 1088, -96, -40},
    { 1512, -200, 40},
    { 1440, 8, 16},
    { 992, 216, -272},
    { 992, 224, -288},
    { 856, 152, -24},
    { 656, 136, 8},
    { 808, 160, 72},
    { 872, 248, 72},
    { 840, 320, 16},
    { 800, 344, -104},
    { 888, 376, -208},
    { 1080, 352, -216},
    { 1200, 256, -144},
    // 66 seconds
    { 1744, 240, 8},
    { 1560, 344, 48},
    { 984, 304, -8},
    { 1008, 272, 0},
    { 1120, 160, 96},
    { 984, 72, 112},
    { 728, 88, 48},
    { 688, 96, 0},
    { 664, 56, 8},
    { 736, 8, 32},
    { 864, 8, 8},
    { 1024, -24, -16},
    { 1144, 0, -56},
    { 1160, -104, -80},
    { 1696, -128, 104},
    { 1288, 168, 0},
    { 1008, 248, -176},
    { 912, 240, -112},
    { 680, 144, 64},
    { 552, 152, 64},
    { 776, 200, 112},
    { 832, 336, 40},
    { 760, 384, -64},
    { 848, 392, -160},
    { 1152, 320, -136},
    // 67 seconds
    { 1296, 272, -112},
    { 1344, 112, 16},
    { 1496, 336, -56},
    { 1168, 320, -40},
    { 1184, 256, -16},
    { 1176, 160, 32},
    { 904, 104, 32},
    { 744, 104, -8},
    { 752, 56, -24},
    { 680, -8, 8},
    { 640, -24, 32},
    { 728, -24, 16},
    { 1008, -16, -16},
    { 1216, 72, -72},
    { 1136, -24, -128},
    { 1896, -144, 152},
    { 1584, 240, -32},
    { 1016, 296, -216},
    { 720, 184, -80},
    { 624, 88, 32},
    { 576, 72, 88},
    { 648, 128, 128},
    { 712, 280, 96},
    { 752, 312, 72},
    { 928, 376, -32},
    // 68 seconds
    { 1112, 328, -80},
    { 1192, 288, -104},
    { 1976, 232, 32},
    { 1488, 520, 56},
    { 1240, 368, -64},
    { 1008, 328, -56},
    { 1024, 192, 0},
    { 864, 120, -56},
    { 840, 56, -32},
    { 816, -16, -24},
    { 760, -24, -40},
    { 808, -24, -8},
    { 1032, -88, 16},
    { 1264, -40, 0},
    { 1032, 32, -112},
    { 1808, -376, 304},
    { 1696, 152, 288},
    { 984, 416, -120},
    { 736, 312, -232},
    { 624, 160, 80},
    { 736, 72, 88},
    { 920, 104, 256},
    { 960, 312, 152},
    { 952, 472, 8},
    { 1088, 512, -88},
    // 69 seconds
    { 1264, 464, -104},
    { 1456, 256, -40},
    { 1576, 456, -48},
    { 1136, 456, -88},
    { 984, 336, -112},
    { 1136, 168, 56},
    { 1096, 64, 64},
    { 1000, 16, 64},
    { 880, 8, 48},
    { 840, 48, -48},
    { 816, 56, -80},
    { 800, -72, -72},
    { 968, -112, -136},
    { 1216, -136, -104},
    { 1440, -208, 8},
    { 1480, -56, -16},
    { 1056, 208, -120},
    { 856, 224, -192},
    { 816, 200, -120},
    { 696, 136, 96},
    { 848, 176, 88},
    { 984, 216, 128},
    { 1016, 360, 232},
    { 912, 440, 0},
    { 1016, 552, -136},
    // 70 seconds
    { 1280, 504, -80},
    { 1088, 400, -112},
    { 1712, 656, -56},
    { 1176, 624, -72},
    { 976, 440, -32},
    { 1032, 352, 8},
    { 1056, 208, 104},
    { 872, 144, 88},
    { 864, 64, 128},
    { 904, 16, 144},
    { 920, 8, 128},
    { 1016, -24, 112},
    { 1176, -120, 120},
    { 1144, -312, 112},
    { 1160, -272, 64},
    { 1456, -168, 168},
    { 1160, 112, 40},
    { 952, 232, -144},
    { 936, 232, -112},
    { 744, 152, 16},
    { 792, 184, -40},
    { 856, 224, -16},
    { 912, 288, -64},
    { 880, 288, -120},
    { 936, 392, -280},
    // 71 seconds
    { 1136, 336, -232},
    { 1272, 264, -168},
    { 1232, 192, 0},
    { 1520, 296, 64},
    { 1232, 376, 40},
    { 1072, 280, 56},
    { 1120, 168, 128},
    { 1024, 72, 184},
    { 848, 80, 104},
    { 800, 48, 80},
    { 720, 16, 56},
    { 712, -8, 16},
    { 736, -24, 16},
    { 880, -72, -16},
    { 1104, -8, -120},
    { 1128, -48, -64},
    { 1736, -160, 56},
    { 1600, 88, 64},
    { 1144, 272, -120},
    { 824, 216, -104},
    { 736, 144, 64},
    { 704, 184, 96},
    { 760, 160, 112},
    { 864, 248, 88},
    { 848, 264, 88},
    // 72 seconds
    { 840, 328, 24},
    { 952, 376, -72},
    { 1144, 456, -184},
    { 1232, 360, -72},
    { 1832, 336, -8},
    { 1336, 432, -56},
    { 1016, 328, -16},
    { 1136, 240, 104},
    { 1120, 200, 184},
    { 832, 176, 168},
    { 784, 136, 104},
    { 816, 40, 160},
    { 792, -24, 160},
    { 768, -24, 120},
    { 872, 8, 80},
    { 1088, -40, 40},
    { 1048, 32, -104},
    { 1488, -176, -56},
    { 1344, -88, 96},
    { 1288, 232, -128},
    { 1248, 320, -216},
    { 1056, 272, 96},
    { 808, 216, 88},
    { 680, 224, 136},
    { 840, 144, 240},
    // 73 seconds
    { 904, 264, 168},
    { 832, 360, 88},
    { 864, 448, -88},
    { 1048, 400, -104},
    { 1232, 392, -128},
    { 1600, 264, -8},
    { 1624, 384, 40},
    { 1288, 296, 128},
    { 1224, 216, 168},
    { 1248, 144, 232},
    { 1008, 112, 280},
    { 928, 96, 176},
    { 856, 56, 152},
    { 872, 8, 104},
    { 800, -32, 104},
    { 784, -32, 40},
    { 832, -88, 8},
    { 864, -40, -56},
    { 928, -56, -120},
    { 1512, -216, 120},
    { 1440, 96, 56},
    { 1560, 328, -160},
    { 1336, 392, -80},
    { 1000, 288, 200},
    { 904, 320, 128},
    // 74 seconds
    { 864, 208, 256},
    { 904, 384, 112},
    { 800, 432, 0},
    { 800, 456, -80},
    { 888, 408, -112},
    { 1120, 504, -168},
    { 1208, 392, 0},
    { 1920, 448, 88},
    { 1448, 344, 152},
    { 1408, 208, 152},
    { 1440, 152, 200},
    { 1224, 192, 256},
    { 1024, 88, 152},
    { 872, 80, 136},
    { 776, 0, 104},
    { 744, -56, 64},
    { 680, -104, 88},
    { 704, -144, 32},
    { 792, -80, -8},
    { 936, -48, -16},
    { 1528, -168, 112},
    { 1976, 24, 216},
    { 1392, 480, -272},
    { 1216, 488, -320},
    { 1088, 280, 72},
    // 75 seconds
    { 888, 296, 80},
    { 904, 328, 112},
    { 904, 408, 128},
    { 744, 512, -16},
    { 712, 456, -200},
    { 776, 464, -192},
    { 1144, 480, -168},
    { 1120, 480, -72},
    { 1696, 368, -32},
    { 1720, 440, 88},
    { 1368, 200, 152},
    { 1224, 160, 64},
    { 1272, 160, 40},
    { 1072, 8, 136},
    { 840, -16, 72},
    { 808, -168, 48},
    { 752, -200, 24},
    { 760, -144, 40},
    { 872, -112, 40},
    { 1240, -128, -32},
    { 1376, 0, -112},
    { 1656, -248, 40},
    { 1416, -88, 96},
    { 1384, 232, -88},
    { 1080, 256, -56},
    // 76 seconds
    { 752, 88, 104},
    { 592, 104, 160},
    { 696, 112, 240},
    { 864, 216, 224},
    { 816, 288, 256},
    { 792, 432, 40},
    { 960, 464, -40},
    { 1168, 456, -72},
    { 1232, 392, -88},
    { 1968, 408, 8},
    { 1464, 528, -16},
    { 992, 352, 8},
    { 1088, 256, 80},
    { 1168, 120, 184},
    { 984, 64, 200},
    { 880, 56, 168},
    { 856, 16, 144},
    { 808, -32, 144},
    { 832, -24, 104},
    { 920, -32, 96},
    { 1088, -80, 8},
    { 1176, -56, 8},
    { 1520, -240, 136},
    { 1560, -144, 264},
    { 840, 384, -80},
    // 77 seconds
    { 856, 328, -232},
    { 928, 128, 96},
    { 816, 48, 152},
    { 952, 200, 112},
    { 1000, 280, 152},
    { 904, 368, 96},
    { 816, 344, -8},
    { 904, 304, -120},
    { 1104, 240, -168},
    { 1264, 120, -72},
    { 1504, 200, -48},
    { 1592, 384, -24},
    { 1128, 488, 32},
    { 1000, 304, 72},
    { 1160, 176, 176},
    { 1064, 72, 280},
    { 848, 96, 192},
    { 904, 128, 152},
    { 856, 48, 152},
    { 808, 8, 144},
    { 792, -56, 152},
    { 816, -112, 112},
    { 944, -112, 56},
    { 992, 0, 40},
    { 1584, -48, 72},
    // 78 seconds
    { 1328, 136, 64},
    { 1112, 264, -88},
    { 1056, 240, -96},
    { 808, 168, 40},
    { 696, 72, 104},
    { 776, 216, 136},
    { 864, 432, 176},
    { 808, 576, 88},
    { 832, 568, 56},
    { 1000, 480, 24},
    { 1152, 328, 24},
    { 1192, 216, 48},
    { 1560, 232, 72},
    { 1352, 384, 48},
    { 936, 440, 96},
    { 976, 304, 176},
    { 1144, 168, 272},
    { 936, 80, 288},
    { 848, 88, 184},
    { 808, 104, 152},
    { 800, 40, 120},
    { 880, 32, 88},
    { 1016, -16, 88},
    { 1152, -64, 48},
    { 1096, -48, 16},
    // 79 seconds
    { 1288, -152, 48},
    { 1240, -48, 64},
    { 1080, 248, -80},
    { 1032, 280, -160},
    { 936, 160, 56},
    { 744, 112, 88},
    { 808, 152, 136},
    { 872, 288, 112},
    { 872, 344, 112},
    { 832, 400, -8},
    { 888, 408, -120},
    { 1088, 400, -176},
    { 1208, 272, -64},
    { 1648, 224, 32},
    { 1656, 384, 88},
    { 1024, 352, 96},
    { 1032, 264, 96},
    { 1176, 136, 216},
    { 984, 88, 240},
    { 808, 136, 160},
    { 736, 96, 144},
    { 736, 8, 152},
    { 816, -8, 112},
    { 888, -16, 72},
    { 968, -80, 64},
    // 80 seconds
    { 1112, -64, 16},
    { 1032, 0, -112},
    { 1520, -104, 96},
    { 1240, 152, 16},
    { 1064, 320, -152},
    { 944, 384, -200},
    { 832, 184, 80},
    { 848, 160, 120},
    { 888, 264, 72},
    { 920, 400, 32},
    { 824, 488, -48},
    { 920, 416, -120},
    { 1136, 376, -192},
    { 1200, 192, -192},
    { 1312, 192, 24},
    { 1472, 264, -16},
    { 1144, 328, -32},
    { 1112, 232, 40},
    { 1192, 80, 152},
    { 1136, 32, 176},
    { 936, 16, 168},
    { 784, 80, 80},
    { 768, 80, 88},
    { 752, -16, 96},
    { 720, -48, 72},
    // 81 seconds
    { 800, -96, 64},
    { 1056, -104, 24},
    { 1104, -32, -16},
    { 1696, -208, 120},
    { 1536, -24, 120},
    { 1072, 368, -232},
    { 1024, 304, -160},
    { 944, 96, 104},
    { 808, 144, 120},
    { 856, 272, 104},
    { 864, 336, 104},
    { 776, 344, 40},
    { 752, 336, -32},
    { 904, 384, -128},
    { 1192, 280, -112},
    { 1312, 224, -88},
    { 1680, 240, -64},
    { 1648, 352, 8},
    { 968, 392, 24},
    { 1032, 232, 128},
    { 1232, 56, 296},
    { 1024, 96, 216},
    { 896, 32, 232},
    { 776, 56, 192},
    { 720, 104, 104},
    // 82 seconds
    { 736, -8, 104},
    { 848, -40, 96},
    { 928, -104, 64},
    { 944, -40, -24},
    { 1168, -216, 72},
    { 1496, -160, 192},
    { 1512, 216, 24},
    { 1288, 456, -224},
    { 824, 256, 0},
    { 672, -8, 136},
    { 768, 376, 96},
    { 856, 56, 200},
    { 872, 264, 128},
    { 832, 408, -8},
    { 880, 368, -72},
    { 976, 352, -136},
    { 1272, 288, -128},
    { 1368, 184, 40},
    { 1728, 328, 24},
    { 1256, 456, 24},
    { 1160, 344, 40},
    { 1112, 264, 128},
    { 1104, 224, 160},
    { 888, 136, 192},
    { 784, 96, 168},
    // 83 seconds
    { 808, 88, 112},
    { 824, -8, 144},
    { 840, -8, 104},
    { 936, -64, 120},
    { 1040, 0, -16},
    { 960, -8, -56},
    { 1512, -200, 160},
    { 1264, 40, 112},
    { 1272, 352, -144},
    { 1136, 344, -112},
    { 904, 280, 88},
    { 784, 200, 0},
    { 840, 152, 184},
    { 872, 320, 80},
    { 816, 408, 80},
    { 832, 520, -136},
    { 968, 400, -24},
    { 1136, 608, -176},
    { 1088, 576, -96},
    { 1768, 544, 40},
    { 1408, 528, 64},
    { 1224, 360, 168},
    { 1296, 240, 256},
    { 1240, 192, 256},
    { 984, 144, 232},
    // 84 seconds
    { 872, 120, 184},
    { 840, 72, 184},
    { 816, 32, 120},
    { 816, 0, 96},
    { 800, -72, 112},
    { 928, -120, 64},
    { 992, -48, 16},
    { 1336, -160, 112},
    { 1328, -16, 256},
    { 1520, 304, 16},
    { 1408, 528, -264},
    { 976, 376, 32},
    { 912, 128, 0},
    { 888, 96, 88},
    { 896, 376, 64},
    { 880, 400, 8},
    { 816, 344, -32},
    { 888, 408, -160},
    { 1096, 392, -136},
    { 1160, 344, -136},
    { 1480, 248, 40},
    { 1520, 360, 16},
    { 1152, 368, 8},
    { 1192, 240, 112},
    { 1344, 120, 232},
    // 85 seconds
    { 1088, 104, 240},
    { 896, 128, 200},
    { 832, 136, 96},
    { 800, 56, 120},
    { 720, -24, 96},
    { 752, -136, 80},
    { 856, -152, 24},
    { 1024, -16, -56},
    { 1232, -72, 64},
    { 1720, -152, 264},
    { 1392, 216, 96},
    { 1232, 392, -136},
    { 1192, 288, 8},
    { 912, 200, 200},
    { 864, 256, 120},
    { 880, 376, 96},
    { 888, 400, 24},
    { 872, 288, 16},
    { 808, 296, -200},
    { 944, 424, -40},
    { 1312, 376, 184},
    { 1216, 400, 96},
    { 1752, 200, 232},
    { 1256, 216, 192},
    { 1200, 184, 112},
    // 86 seconds
    { 1176, 72, 136},
    { 1160, -64, 216},
    { 944, -56, 184},
    { 840, -64, 112},
    { 776, -104, 136},
    { 816, 0, 56},
    { 760, -64, 56},
    { 840, -136, 64},
    { 1008, -200, 0},
    { 1024, -152, -96},
    { 1528, -352, 72},
    { 1480, -128, 120},
    { 1336, 240, -112},
    { 1328, 312, -248},
    { 1016, 176, 104},
    { 856, 176, 80},
    { 872, 200, 136},
    { 888, 280, 96},
    { 824, 344, 40},
    { 816, 392, -104},
    { 872, 376, -184},
    { 1088, 352, -192},
    { 1208, 296, -112},
    { 1712, 296, -32},
    { 1576, 328, 40},
    // 87 seconds
    { 1136, 248, 80},
    { 1120, 192, 80},
    { 1264, 112, 160},
    { 1064, 72, 176},
    { 952, 48, 144},
    { 840, 40, 96},
    { 824, -8, 56},
    { 824, -40, 24},
    { 832, -80, 32},
    { 984, -136, 40},
    { 992, -96, -40},
    { 1264, -176, -8},
    { 1352, -152, -16},
    { 1232, 72, -48},
    { 1312, 136, -72},
    { 1152, 264, -24},
    { 864, 176, 88},
    { 880, 240, 96},
    { 888, 200, 184},
    { 920, 296, 104},
    { 912, 360, 8},
    { 920, 456, -128},
    { 944, 392, -136},
    { 1160, 360, -160},
    { 1192, 280, -32},
    // 88 seconds
    { 1616, 400, -24},
    { 1328, 472, 32},
    { 1032, 312, 88},
    { 1200, 168, 168},
    { 1248, 96, 152},
    { 1048, 56, 224},
    { 1000, 40, 168},
    { 960, 64, 120},
    { 912, 48, 88},
    { 848, 0, 104},
    { 912, -24, 112},
    { 888, -96, -8},
    { 848, -40, -96},
    { 1360, -224, 32},
    { 1352, -112, 216},
    { 1432, 256, 8},
    { 1504, 320, -56},
    { 1216, 344, 168},
    { 920, 200, 272},
    { 896, 240, 264},
    { 824, 312, 168},
    { 856, 328, 160},
    { 808, 392, 56},
    { 856, 488, -56},
    { 1016, 408, -24},
    // 89 seconds
    { 1128, 456, -56},
    { 1344, 344, 96},
    { 1592, 416, 88},
    { 1144, 368, 80},
    { 1152, 256, 120},
    { 1248, 184, 168},
    { 1192, 120, 264},
    { 952, 152, 168},
    { 904, 112, 168},
    { 888, 32, 184},
    { 848, 0, 128},
    { 872, -8, 144},
    { 944, -48, 96},
    { 1024, -48, 72},
    { 1016, -72, 8},
    { 1464, -184, 152},
    { 1328, -80, 104},
    { 1192, 288, -184},
    { 1216, 256, -120},
    { 1096, 72, 232},
    { 936, 208, 144},
    { 984, 296, 176},
    { 976, 416, 168},
    { 848, 504, 96},
    { 792, 456, 40},
    // 90 seconds
    { 856, 432, -32},
    { 1112, 416, -80},
    { 1224, 368, -32},
    { 1768, 392, -8},
    { 1440, 464, -24},
    { 1176, 344, 48},
    { 1232, 200, 160},
    { 1280, 136, 216},
    { 1112, 80, 200},
    { 928, 88, 216},
    { 856, 136, 160},
    { 880, 64, 176},
    { 816, -16, 208},
    { 808, -80, 136},
    { 784, -152, 104},
    { 872, -56, -8},
    { 976, 64, -152},
    { 1472, -104, 120},
    { 1496, 0, 136},
    { 1664, 400, -112},
    { 1368, 520, -192},
    { 912, 320, 176},
    { 872, 200, 208},
    { 848, 240, 192},
    { 864, 344, 136},
    // 91 seconds
    { 840, 424, 40},
    { 824, 448, -24},
    { 984, 512, -80},
    { 1120, 448, -48},
    { 1104, 304, 0},
    { 1712, 280, 48},
    { 1472, 312, 168},
    { 1232, 224, 152},
    { 1312, 104, 144},
    { 1344, -24, 240},
    { 1176, 0, 224},
    { 1080, 56, 160},
    { 944, -24, 128},
    { 864, -128, 96},
    { 680, -168, 32},
    { 712, -192, -24},
    { 832, -144, -72},
    { 864, -144, -96},
    { 1320, -312, 56},
    { 1680, -64, 192},
    { 1624, 272, -104},
    { 1408, 328, -96},
    { 1112, 240, 104},
    { 936, 232, 80},
    { 880, 240, 128},
    // 92 seconds
    { 896, 240, 152},
    { 816, 312, 56},
    { 768, 352, -40},
    { 840, 480, -152},
    { 1040, 488, -136},
    { 1232, 392, -64},
    { 1416, 376, 48},
    { 1712, 400, 104},
    { 1240, 400, 24},
    { 1064, 256, 64},
    { 1208, 160, 80},
    { 1192, 96, 144},
    { 960, 16, 216},
    { 824, 24, 152},
    { 808, 56, 112},
    { 752, 0, 136},
    { 760, -8, 88},
    { 808, -88, 112},
    { 984, -80, 88},
    { 1016, -56, 40},
    { 1480, -120, 144},
    { 1488, 40, 192},
    { 1256, 336, -144},
    { 1232, 400, -168},
    { 1016, 200, 168},
    // 93 seconds
    { 864, 192, 96},
    { 880, 208, 136},
    { 920, 352, 56},
    { 864, 376, 32},
    { 848, 408, -80},
    { 888, 352, -64},
    { 1144, 384, -136},
    { 1168, 312, -48},
    { 1720, 312, 40},
    { 1536, 392, 80},
    { 1056, 320, 80},
    { 1128, 192, 160},
    { 1320, 88, 256},
    { 1040, 56, 272},
    { 872, 96, 184},
    { 832, 88, 152},
    { 816, 16, 144},
    { 776, -24, 128},
    { 800, -8, 88},
    { 872, -104, 48},
    { 888, -160, -16},
    { 1200, -192, 8},
    { 1648, -152, 248},
    { 1432, 184, 144},
    { 1280, 408, -168},
    // 94 seconds
    { 1192, 312, -8},
    { 912, 200, 144},
    { 840, 168, 136},
    { 840, 304, 128},
    { 888, 360, 160},
    { 784, 368, 64},
    { 816, 384, -48},
    { 936, 328, -56},
    { 1136, 328, -88},
    { 1208, 280, 40},
    { 1928, 360, 40},
    { 1232, 416, 96},
    { 1072, 248, 112},
    { 1184, 192, 184},
    { 1184, 56, 272},
    { 944, 72, 216},
    { 848, 88, 168},
    { 816, 72, 152},
    { 832, -16, 144},
    { 824, -16, 80},
    { 928, 0, -48},
    { 984, -80, -32},
    { 984, -112, 8},
    { 1544, -160, 144},
    { 1272, -16, 176},
    // 95 seconds
    { 1216, 240, 64},
    { 1256, 256, 24},
    { 920, 152, 216},
    { 792, 152, 136},
    { 872, 240, 128},
    { 912, 320, 112},
    { 888, 392, 32},
    { 888, 472, -104},
    { 984, 416, -88},
    { 1160, 352, -88},
    { 1176, 288, 16},
    { 1808, 376, 120},
    { 1520, 480, 104},
    { 952, 328, 32},
    { 1168, 200, 128},
    { 1328, 72, 240},
    { 1104, 56, 200},
    { 912, 72, 208},
    { 840, 48, 160},
    { 768, 24, 152},
    { 696, -8, 136},
    { 776, -40, 112},
    { 936, -40, 56},
    { 1064, -32, 40},
    { 1256, -120, 48},
    // 96 seconds
    { 1528, -160, 192},
    { 1264, 232, -72},
    { 1168, 328, -224},
    { 1104, 128, 72},
    { 904, 120, 280},
    { 920, 240, 160},
    { 912, 320, 200},
    { 872, 408, 96},
    { 808, 376, 80},
    { 912, 408, 32},
    { 896, 392, 32},
    { 1192, 448, -56},
    { 1392, 408, 120},
    { 1712, 432, 208},
    { 1272, 400, 144},
    { 992, 272, 160},
    { 1176, 160, 224},
    { 1264, 32, 304},
    { 1088, 0, 312},
    { 920, 32, 232},
    { 888, 32, 168},
    { 848, -24, 160},
    { 816, -32, 144},
    { 824, -48, 112},
    { 912, -160, 56},
    // 97 seconds
    { 976, -128, -64},
    { 1296, -224, 40},
    { 1504, -160, 248},
    { 1200, 216, 32},
    { 1264, 200, -80},
    { 1336, 176, 184},
    { 1032, 216, 256},
    { 904, 240, 216},
    { 992, 344, 192},
    { 912, 328, 72},
    { 848, 240, 8},
    { 872, 312, -96},
    { 1048, 344, -96},
    { 1280, 384, -144},
    { 1552, 232, 88},
    { 1880, 304, 152},
    { 1184, 264, 136},
    { 1104, 152, 144},
    { 1344, 40, 280},
    { 1176, -16, 288},
    { 952, -16, 272},
    { 800, 40, 208},
    { 736, -16, 200},
    { 712, -40, 152},
    { 752, -48, 120},
    // 98 seconds
    { 808, -80, 88},
    { 960, -88, 40},
    { 976, -40, -72},
    { 1480, -240, 128},
    { 1496, -24, 208},
    { 1440, 224, -24},
    { 1400, 320, -160},
    { 1072, 280, 112},
    { 896, 232, 144},
    { 872, 256, 192},
    { 944, 288, 216},
    { 880, 352, 136},
    { 816, 400, 8},
    { 880, 464, -112},
    { 1144, 456, -128},
    { 1168, 368, -48},
    { 1640, 312, 40},
    { 1600, 320, 176},
    { 1272, 216, 184},
    { 1216, 144, 184},
    { 1408, 16, 336},
    { 1224, 16, 328},
    { 1008, 8, 240},
    { 816, 0, 168},
    { 688, -8, 96},
    // 99 seconds
    { 632, -96, 104},
    { 688, -112, 48},
    { 784, -144, 72},
    { 984, -40, 0},
    { 1184, -120, 48},
    { 1768, -160, 328},
    { 1688, 304, 112},
    { 1464, 512, -240},
    { 1240, 368, 72},
    { 872, 184, 232},
    { 848, 152, 184},
    { 848, 208, 200},
    { 864, 344, 144},
    { 760, 368, 56},
    { 824, 392, -56},
    { 952, 368, -48},
    { 1208, 432, -104},
    { 1240, 288, 56},
    { 1824, 328, 88},
    { 1320, 376, 88},
    { 1104, 240, 112},
    { 1232, 104, 224},
    { 1288, -8, 288},
    { 1096, 80, 248},
    { 936, 32, 216},
    // 100 seconds
    { 832, 64, 128},
    { 824, 8, 104},
    { 752, -56, 104},
    { 824, -88, 64},
    { 936, -80, 0},
    { 1048, -48, -56},
    { 1440, -232, 200},
    { 1568, 56, 240},
    { 1368, 432, -128},
    { 1304, 336, -80},
    { 1000, 240, 240},
    { 832, 256, 200},
    { 888, 264, 216},
    { 896, 336, 168},
    { 792, 384, 64},
    { 792, 392, -24},
    { 968, 400, -16},
    { 1240, 408, -24},
    { 1256, 336, 80},
    { 1760, 360, 120},
    { 1336, 408, 88},
    { 1088, 248, 136},
    { 1280, 112, 248},
    { 1296, 32, 328},
    { 1056, 80, 224},
    // 101 seconds
    { 896, 88, 152},
    { 792, 48, 120},
    { 712, 8, 88},
    { 696, -56, 96},
    { 776, -88, 80},
    { 920, -104, 32},
    { 1008, -40, 0},
    { 1528, -192, 152},
    { 1592, 8, 232},
    { 1440, 368, 16},
    { 1312, 376, -80},
    { 1080, 360, 224},
    { 912, 312, 192},
    { 872, 328, 192},
    { 872, 400, 160},
    { 768, 384, 112},
    { 728, 424, 40},
    { 864, 472, -8},
    { 1112, 464, -8},
    { 1232, 432, 40},
    { 1600, 296, 104},
    { 1856, 648, 80},
    { 1144, 264, 232},
    { 1120, 208, 208},
    { 1416, 120, 280},
    // 102 seconds
    { 1248, 0, 368},
    { 944, 0, 304},
    { 872, 48, 200},
    { 736, 0, 184},
    { 664, -24, 136},
    { 672, -48, 112},
    { 704, -80, 96},
    { 968, -24, 24},
    { 1112, -80, 48},
    { 1632, -216, 312},
    { 1600, 152, 256},
    { 1352, 472, -168},
    { 1240, 368, 40},
    { 1032, 232, 280},
    { 936, 256, 232},
    { 936, 312, 240},
    { 848, 352, 160},
    { 768, 392, 48},
    { 768, 408, 0},
    { 904, 448, -56},
    { 1168, 424, -24},
    { 1224, 400, 40},
    { 1776, 392, 152},
    { 1648, 416, 200},
    { 1048, 280, 184},
    // 103 seconds
    { 1120, 160, 248},
    { 1392, 56, 352},
    { 1136, -8, 368},
    { 944, 32, 264},
    { 832, 40, 192},
    { 696, 8, 152},
    { 672, -8, 88},
    { 680, -64, 128},
    { 824, -56, 56},
    { 952, -16, 0},
    { 1096, -192, 152},
    { 1704, -112, 344},
    { 1512, 304, 104},
    { 1448, 512, -144},
    { 1200, 424, 112},
    { 864, 328, 232},
    { 864, 296, 184},
    { 904, 272, 256},
    { 832, 344, 152},
    { 728, 384, 56},
    { 776, 392, 0},
    { 1008, 448, 0},
    { 1200, 456, 8},
    { 1312, 344, 168},
    { 1816, 408, 208},
    // 104 seconds
    { 1256, 360, 224},
    { 1112, 200, 208},
    { 992, 88, 384},
    { 1256, 40, 328},
    { 1072, 8, 304},
    { 928, 32, 216},
    { 776, 16, 120},
    { 648, -40, 96},
    { 616, -88, 96},
    { 688, -104, 40},
    { 928, -40, -24},
    { 1048, -16, -64},
    { 1696, -216, 232},
    { 1800, 104, 248},
    { 1640, 536, -128},
    { 1296, 352, -40},
    { 968, 288, 264},
    { 864, 240, 232},
    { 848, 192, 296},
    { 832, 360, 216},
    { 760, 456, 136},
    { 744, 424, 80},
    { 832, 416, 48},
    { 1200, 560, -48},
    { 1232, 392, 96},
    // 105 seconds
    { 1960, 400, 128},
    { 1376, 432, 72},
    { 1160, 280, 120},
    { 1416, 80, 320},
    { 1328, 40, 320},
    { 1168, 24, 280},
    { 1024, 24, 264},
    { 856, 16, 136},
    { 720, -16, 112},
    { 632, -88, 96},
    { 688, -120, 72},
    { 792, -72, 8},
    { 984, -24, -40},
    { 1544, -168, 112},
    { 1776, -24, 312},
    { 1624, 400, -24},
    { 1344, 464, -96},
    { 1120, 392, 192},
    { 896, 264, 248},
    { 864, 256, 256},
    { 872, 328, 240},
    { 768, 424, 128},
    { 688, 400, 72},
    { 768, 512, -24},
    { 1000, 472, -16},
    // 106 seconds
    { 1208, 448, 40},
    { 1712, 376, 176},
    { 1872, 376, 264},
    { 1152, 304, 168},
    { 1168, 232, 152},
    { 1376, 56, 280},
    { 1240, 0, 320},
    { 968, -16, 248},
    { 880, 8, 160},
    { 696, -24, 136},
    { 592, -56, 104},
    { 592, -48, 80},
    { 696, -72, 56},
    { 936, -16, 8},
    { 1072, 40, -8},
    { 1784, -56, 272},
    { 1752, 232, 312},
    { 1448, 664, -16},
    { 1072, 528, -24},
    { 856, 296, 256},
    { 808, 296, 176},
    { 784, 224, 288},
    { 792, 392, 192},
    { 712, 376, 144},
    { 720, 432, 32},
    // 107 seconds
    { 768, 416, 24},
    { 792, 376, -8},
    { 1032, 376, -8},
    { 1232, 304, 144},
    { 2000, 296, 288},
    { 1520, 232, 312},
    { 1176, 152, 296},
    { 1240, 232, 328},
    { 1008, 88, 512},
    { 928, 32, 544},
    { 1000, 88, 512},
    { 896, 40, 600},
    { 912, 104, 464},
    { 824, 184, 392},
    { 776, 328, 312},
    { 632, 368, 440},
    { 608, 456, 416},
    { 568, 536, 496},
    { 416, 576, 496},
    { 352, 536, 624},
    { 264, 552, 696},
    { 320, 704, 704},
    { 352, 696, 760},
    { 312, 640, 528},
    { 280, 536, 488},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

