/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */



// ----------------------------------------------------------------
// Sample captured at: 2015-08-18 22:15:00 local, 2015-08-19 05:15:00 GMT
// According to Misfit:
//  Total sleep from 10:42 pm to 4:06am (325 minutes)
//  Deep sleep 182 min.
//  Breakdown (very approximate):
//   10:15 - 10:42 awake (27 min)
//   10:42 - 10:50 light (8 min)
//   10:50 - 11:20 deep (30 min)
//   11:20 - 11:30 light (10 min)
//   11:30 - 11:40 deep (10 min)
//   11:40 - 12:30 light (50 min)
//   12:30 - 2:45 deep (135 min)
//    2:45 - 3:15 light (30 min)
//    3:15 - 3:35 deep (20 min)
//    3:35 - 4:06 light (30 min)
//    4:06 - 5:00 awake
AlgDlsMinuteData *activity_sample_sleep_v1_1(int *len) { 
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_1_v1
  //> TEST_VERSION 1
  //> TEST_TOTAL 325
  //> TEST_TOTAL_MIN 300
  //> TEST_TOTAL_MAX 350
  //> TEST_DEEP 180
  //> TEST_DEEP_MIN 170
  //> TEST_DEEP_MAX 200
  //> TEST_START_AT 27
  //> TEST_START_AT_MIN 20
  //> TEST_START_AT_MAX 40
  //> TEST_END_AT 350
  //> TEST_END_AT_MIN 330
  //> TEST_END_AT_MAX 370
  //> TEST_CUR_STATE_ELAPSED 54
  //> TEST_CUR_STATE_ELAPSED_MIN 50
  //> TEST_CUR_STATE_ELAPSED_MAX 60
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc}
  static AlgDlsMinuteData samples[] = { 
    { 0, 0x8f, 6},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 4},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x65, 47},
    { 0, 0x44, 5},
    { 8, 0x63, 36},
    { 10, 0x52, 68},
    { 8, 0x53, 61},
    { 0, 0x63, 83},
    // 15: Local time: 10:30:00 PM
    { 0, 0x64, 107},
    { 0, 0x79, 35},
    { 0, 0x78, 0},
    { 0, 0x78, 37},
    { 0, 0x68, 4},
    { 0, 0x68, 0},
    { 0, 0x68, 0},
    { 0, 0x69, 17},
    { 0, 0x69, 0},
    { 0, 0x68, 10},
    { 0, 0x67, 0},
    { 0, 0x68, 12},
    { 0, 0x68, 0},    // start light
    { 0, 0x68, 0},
    { 0, 0x67, 41},
    // 30: Local time: 10:45:00 PM
    { 0, 0x64, 26},
    { 0, 0x54, 0},
    { 0, 0x54, 12},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},    // start deep (30 min)
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x54, 12},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    // 45: Local time: 11:00:00 PM
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    // 60: Local time: 11:15:00 PM
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},    // start light
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 19},
    { 0, 0x54, 0},
    { 0, 0x54, 6},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 75: Local time: 11:30:00 PM
    { 0, 0x64, 0},     // start deep
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},     // start light
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x54, 16},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 90: Local time: 11:45:00 PM
    { 0, 0x64, 0},
    { 0, 0x54, 2},
    { 0, 0x54, 0},
    { 0, 0x54, 7},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 14},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x64, 16},
    { 0, 0x64, 0},
    { 0, 0x54, 13},
    { 0, 0x44, 0},
    // 105: Local time: 12:00:00 AM
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x44, 8},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x44, 6},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    // 120: Local time: 12:15:00 AM
    { 0, 0x44, 2},
    { 0, 0x44, 8},
    { 0, 0x44, 0},
    { 0, 0x44, 12},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x64, 28},
    { 0, 0x65, 28},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    // 135: Local time: 12:30:00 AM
    { 0, 0x16, 0},   // start deep
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    // 150: Local time: 12:45:00 AM
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 18},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    // 165: Local time: 01:00:00 AM
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    // 180: Local time: 01:15:00 AM
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x16, 0},
    { 0, 0x36, 14},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    // 195: Local time: 01:30:00 AM
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    // 210: Local time: 01:45:00 AM
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    // 225: Local time: 02:00:00 AM
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    // 240: Local time: 02:15:00 AM
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    // 255: Local time: 02:30:00 AM
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x55, 18},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 5},
    // 270: Local time: 02:45:00 AM
    { 0, 0x26, 26},  // start light
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x35, 20},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    // 285: Local time: 03:00:00 AM
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x65, 9},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    // 300: Local time: 03:15:00 AM
    { 0, 0x65, 0},  // start deep
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    // 315: Local time: 03:30:00 AM
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},  // start light
    { 0, 0x65, 0},
    { 0, 0x66, 17},
    { 0, 0x2a, 0},
    { 0, 0x2a, 0},
    { 0, 0x2a, 0},
    { 0, 0x2a, 0},
    { 0, 0x2b, 0},
    { 0, 0x2a, 0},
    { 0, 0x2a, 0},
    { 0, 0x2a, 0},
    // 330: Local time: 03:45:00 AM
    { 0, 0x2a, 0},
    { 0, 0x57, 19},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x65, 0},
    { 0, 0x66, 20},
    { 0, 0x77, 8},
    { 0, 0x66, 6},
    { 0, 0x67, 18},
    { 0, 0x68, 0},
    { 0, 0x68, 11},
    { 0, 0x23, 44},
    { 0, 0x42, 62},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 345: Local time: 04:00:00 AM
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},   // wake up
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 7},
    { 0, 0x63, 29},
    { 0, 0x64, 0},
    { 0, 0x7f, 37},
    { 0, 0x82, 21},
    { 0, 0x75, 17},
    // 360: Local time: 04:15:00 AM
    { 12, 0x43, 63},
    { 31, 0x32, 55},
    { 0, 0x63, 40},
    { 0, 0x71, 42},
    { 0, 0x7f, 0},
    { 0, 0x7f, 0},
    { 0, 0x7f, 0},
    { 0, 0x7f, 0},
    { 0, 0x7f, 0},
    { 0, 0x7f, 0},
    { 0, 0x7f, 0},
    { 0, 0x70, 42},
    { 0, 0x65, 20},
    { 0, 0x77, 17},
    { 0, 0x77, 26},
    // 375: Local time: 04:30:00 AM
    { 0, 0x77, 18},
    { 0, 0x67, 22},
    { 0, 0x65, 30},
    { 0, 0x68, 36},
    { 0, 0x68, 14},
    { 0, 0x68, 18},
    { 0, 0x76, 30},
    { 0, 0x75, 30},
    { 0, 0x65, 31},
    { 0, 0x65, 38},
    { 9, 0x70, 48},
    { 0, 0x71, 0},
    { 0, 0x6f, 30},
    { 0, 0x6f, 4},
    { 0, 0x6f, 0},
    // 390: Local time: 04:45:00 AM
    { 0, 0x6f, 0},
    { 0, 0x6f, 0},
    { 0, 0x6f, 0},
    { 0, 0x6f, 0},
    { 0, 0x6f, 0},
    { 0, 0x6f, 0},
    { 0, 0x6f, 2},
    { 0, 0x6f, 0},
    { 0, 0x6f, 0},
    { 0, 0x6f, 0},
    { 0, 0x64, 48},
    { 0, 0x55, 0},
    { 0, 0x55, 36},
    { 0, 0x67, 32},
    { 0, 0x55, 0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



// ----------------------------------------------------------------
// Sample captured at: 2015-08-22 19:29:00 local, 2015-08-23 02:29:00 GMT
AlgDlsMinuteData *activity_sample_sleep_v1_watch_on_table(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME watch_on_table_v1
  //> TEST_VERSION 1
  //> TEST_TOTAL 0
  //> TEST_TOTAL_MIN 0
  //> TEST_TOTAL_MAX 0
  //> TEST_DEEP 0
  //> TEST_DEEP_MIN 0
  //> TEST_DEEP_MAX 0
  //> TEST_START_AT -1
  //> TEST_START_AT_MIN -1
  //> TEST_START_AT_MAX -1
  //> TEST_END_AT -1
  //> TEST_END_AT_MIN -1
  //> TEST_END_AT_MAX -1
  //> TEST_CUR_STATE_ELAPSED 705
  //> TEST_CUR_STATE_ELAPSED_MIN 705
  //> TEST_CUR_STATE_ELAPSED_MAX 705
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 100.0
  // list of: { steps, orientation, vmc}
  static AlgDlsMinuteData samples[] = { 
    { 0, 0x7c, 0},
    { 0, 0x7c, 0},
    { 0, 0x7c, 5},
    { 0, 0x7b, 9},
    { 0, 0x7b, 0},
    { 0, 0x7b, 0},
    { 0, 0x7b, 0},
    { 0, 0x7b, 0},
    { 0, 0x7b, 0},
    { 0, 0x7b, 0},
    { 0, 0x7b, 0},
    { 0, 0x7b, 0},
    { 0, 0x7b, 0},
    { 0, 0x7b, 0},
    { 0, 0x7b, 0},
    // 15: Local time: 07:43:36 PM
    { 0, 0x7a, 12},
    { 0, 0x6a, 19},
    { 0, 0x7b, 0},
    { 0, 0x7b, 0},
    { 0, 0x8b, 24},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 30: Local time: 07:58:00 PM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 45: Local time: 08:13:00 PM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 60: Local time: 08:28:00 PM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 75: Local time: 08:44:00 PM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 90: Local time: 08:59:00 PM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 105: Local time: 09:14:00 PM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 120: Local time: 09:29:00 PM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 135: Local time: 09:44:00 PM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 150: Local time: 09:59:00 PM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 165: Local time: 10:14:00 PM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 180: Local time: 10:29:00 PM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 195: Local time: 10:44:00 PM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 210: Local time: 10:59:00 PM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 225: Local time: 11:14:00 PM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 240: Local time: 11:29:00 PM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 255: Local time: 11:44:00 PM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 270: Local time: 11:59:00 PM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 285: Local time: 12:14:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 300: Local time: 12:29:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 315: Local time: 12:44:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 330: Local time: 12:59:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 345: Local time: 01:14:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 360: Local time: 01:29:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 375: Local time: 01:44:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 390: Local time: 01:59:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 405: Local time: 02:14:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 420: Local time: 02:29:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 435: Local time: 02:44:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 450: Local time: 02:59:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 465: Local time: 03:14:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 480: Local time: 03:29:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 495: Local time: 03:43:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 510: Local time: 03:58:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 525: Local time: 04:13:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 540: Local time: 04:28:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 555: Local time: 04:43:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 570: Local time: 04:58:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 585: Local time: 05:13:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 600: Local time: 05:28:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 615: Local time: 05:43:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 630: Local time: 05:58:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 645: Local time: 06:14:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 660: Local time: 06:29:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 675: Local time: 06:44:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    // 690: Local time: 06:59:00 AM
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
    { 0, 0x8b, 0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured at: 2015-08-19 17:36:00 local, 2015-08-20 00:36:00 GMT
// According to Misfit:
//  Total sleep from 9:14 pm to 3:19am (361 minutes)
//  Deep sleep 221 min.
//  Breakdown (very approximate):
//   5:36 awake (218 min)
//   9:14 light (10 min)
//   9:30 deep (10 min)
//   9:40 light (10 min)
//   9:50 [255] deep (45 min)      <- deep
//   10:35 light (15 min)
//   10:50 deep (5 min)
//   10:55 light (20 min)
//   11:15 [339] deep (25 min)
//   11:40 light (25 min)
//   12:05 [389] deep (40 min)     <- deep
//   12:45 light (15 min)
//   1:00 light (10 min)
//   1:10 [454] deep (20 min)
//   1:30 light (5 min)
//   1:35 wake (5 min)
//   1:40 light (5 min)
//   1:45 [489] deep (40 min)    <- deep
//   2:25 light (10 min)
//   2:35 deep (10 min)
//   2:45 light (35 min)
//   3:19 wake (77 min)
//   4:36 end
//
AlgDlsMinuteData *activity_sample_sleep_v1_2(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_2_v1
  //> TEST_VERSION 1
  //> TEST_TOTAL 361
  //> TEST_TOTAL_MIN 340
  //> TEST_TOTAL_MAX 380
  //> TEST_DEEP 221
  //> TEST_DEEP_MIN 200
  //> TEST_DEEP_MAX 250
  //> TEST_START_AT 218
  //> TEST_START_AT_MIN 200
  //> TEST_START_AT_MAX 240
  //> TEST_END_AT 583
  //> TEST_END_AT_MIN 560
  //> TEST_END_AT_MAX 600
  //> TEST_CUR_STATE_ELAPSED 77
  //> TEST_CUR_STATE_ELAPSED_MIN 60
  //> TEST_CUR_STATE_ELAPSED_MAX 100
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc}
  static AlgDlsMinuteData samples[] = { 
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8c, 26},
    { 0, 0x62, 57},
    { 0, 0x74, 11},
    { 0, 0x74, 4},
    { 0, 0x74, 6},
    { 15, 0x62, 56},
    { 7, 0x42, 74},
    { 6, 0x43, 50},
    { 12, 0x53, 58},
    // 15: Local time: 05:51:00 PM
    { 10, 0x42, 62},
    { 0, 0x33, 60},
    { 0, 0x43, 73},
    { 0, 0x42, 69},
    { 0, 0x43, 73},
    { 31, 0x41, 52},
    { 16, 0x42, 65},
    { 0, 0x44, 55},
    { 0, 0x52, 44},
    { 0, 0x74, 0},
    { 0, 0x64, 44},
    { 0, 0x65, 70},
    { 12, 0x75, 49},
    { 0, 0x74, 0},
    { 0, 0x74, 28},
    // 30: Local time: 06:06:00 PM
    { 16, 0x73, 49},
    { 12, 0x65, 34},
    { 0, 0x45, 44},
    { 0, 0x74, 22},
    { 0, 0x73, 37},
    { 0, 0x57, 33},
    { 0, 0x58, 17},
    { 0, 0x49, 7},
    { 20, 0x58, 42},
    { 8, 0x58, 32},
    { 40, 0x43, 50},
    { 0, 0x44, 33},
    { 12, 0x34, 39},
    { 0, 0x58, 24},
    { 0, 0x58, 27},
    // 45: Local time: 06:21:00 PM
    { 14, 0x67, 25},
    { 18, 0x56, 37},
    { 0, 0x45, 33},
    { 22, 0x47, 27},
    { 14, 0x43, 53},
    { 15, 0x52, 52},
    { 0, 0x42, 45},
    { 0, 0x42, 36},
    { 0, 0x43, 62},
    { 40, 0x42, 59},
    { 14, 0x42, 70},
    { 8, 0x42, 74},
    { 38, 0x41, 59},
    { 86, 0x40, 54},
    { 85, 0x41, 53},
    // 60: Local time: 06:36:00 PM
    { 96, 0x40, 52},
    { 28, 0x41, 62},
    { 12, 0x51, 63},
    { 0, 0x77, 63},
    { 0, 0x77, 51},
    { 0, 0x76, 48},
    { 0, 0x75, 46},
    { 0, 0x74, 41},
    { 0, 0x74, 45},
    { 0, 0x75, 48},
    { 18, 0x53, 65},
    { 96, 0x41, 61},
    { 36, 0x41, 36},
    { 16, 0x42, 30},
    { 23, 0x42, 72},
    // 75: Local time: 06:51:00 PM
    { 14, 0x54, 29},
    { 0, 0x65, 15},
    { 0, 0x64, 0},
    { 0, 0x64, 2},
    { 0, 0x64, 0},
    { 0, 0x64, 3},
    { 0, 0x66, 23},
    { 0, 0x67, 27},
    { 91, 0x41, 62},
    { 31, 0x62, 79},
    { 0, 0x78, 55},
    { 0, 0x74, 0},
    { 8, 0x74, 43},
    { 12, 0x75, 38},
    { 0, 0x74, 41},
    // 90: Local time: 07:06:00 PM
    { 0, 0x75, 48},
    { 0, 0x67, 58},
    { 0, 0x52, 60},
    { 0, 0x65, 27},
    { 0, 0x47, 0},
    { 0, 0x48, 16},
    { 0, 0x48, 5},
    { 0, 0x48, 25},
    { 0, 0x48, 25},
    { 0, 0x48, 16},
    { 0, 0x47, 33},
    { 7, 0x43, 36},
    { 7, 0x41, 54},
    { 12, 0x21, 41},
    { 8, 0x43, 89},
    // 105: Local time: 07:21:00 PM
    { 0, 0x32, 44},
    { 0, 0x24, 8},
    { 0, 0x33, 35},
    { 28, 0x42, 52},
    { 0, 0x42, 33},
    { 0, 0x32, 27},
    { 0, 0x52, 55},
    { 0, 0x75, 17},
    { 0, 0x75, 6},
    { 0, 0x76, 27},
    { 0, 0x74, 8},
    { 0, 0x64, 10},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x64, 0},
    // 120: Local time: 07:36:00 PM
    { 0, 0x64, 4},
    { 0, 0x45, 26},
    { 9, 0x46, 48},
    { 0, 0x64, 42},
    { 24, 0x43, 62},
    { 0, 0x43, 65},
    { 0, 0x62, 94},
    { 0, 0x62, 92},
    { 0, 0x63, 84},
    { 0, 0x53, 51},
    { 0, 0x53, 23},
    { 0, 0x53, 4},
    { 0, 0x52, 44},
    { 0, 0x74, 30},
    { 0, 0x72, 14},
    // 135: Local time: 07:51:00 PM
    { 0, 0x51, 23},
    { 0, 0x4a, 17},
    { 12, 0x4a, 34},
    { 22, 0x54, 77},
    { 7, 0x43, 62},
    { 6, 0x65, 70},
    { 17, 0x54, 74},
    { 0, 0x55, 68},
    { 16, 0x54, 55},
    { 16, 0x42, 65},
    { 0, 0x43, 67},
    { 12, 0x41, 82},
    { 18, 0x41, 49},
    { 0, 0x64, 53},
    { 0, 0x54, 59},
    // 150: Local time: 08:06:00 PM
    { 0, 0x64, 37},
    { 24, 0x52, 39},
    { 12, 0x53, 44},
    { 6, 0x66, 18},
    { 8, 0x64, 25},
    { 0, 0x64, 8},
    { 0, 0x64, 3},
    { 22, 0x54, 45},
    { 0, 0x55, 36},
    { 0, 0x74, 15},
    { 8, 0x64, 20},
    { 0, 0x64, 0},
    { 0, 0x65, 23},
    { 0, 0x74, 8},
    { 0, 0x65, 15},
    // 165: Local time: 08:21:00 PM
    { 0, 0x64, 5},
    { 0, 0x64, 0},
    { 0, 0x64, 2},
    { 0, 0x64, 0},
    { 0, 0x64, 3},
    { 0, 0x74, 5},
    { 0, 0x74, 3},
    { 0, 0x74, 6},
    { 0, 0x74, 8},
    { 0, 0x74, 5},
    { 0, 0x74, 6},
    { 0, 0x64, 7},
    { 8, 0x75, 14},
    { 0, 0x57, 26},
    { 8, 0x58, 17},
    // 180: Local time: 08:36:00 PM
    { 0, 0x48, 15},
    { 0, 0x57, 13},
    { 0, 0x65, 18},
    { 0, 0x66, 11},
    { 0, 0x57, 19},
    { 0, 0x58, 6},
    { 8, 0x57, 25},
    { 0, 0x64, 30},
    { 7, 0x63, 28},
    { 0, 0x64, 11},
    { 8, 0x63, 51},
    { 9, 0x32, 58},
    { 8, 0x51, 30},
    { 6, 0x41, 55},
    { 0, 0x42, 67},
    // 195: Local time: 08:51:00 PM
    { 7, 0x3f, 50},
    { 0, 0x21, 20},
    { 0, 0x2f, 18},
    { 9, 0x20, 55},
    { 0, 0x42, 34},
    { 0, 0x52, 24},
    { 0, 0x40, 10},
    { 0, 0x50, 2},
    { 0, 0x40, 11},
    { 0, 0x41, 34},
    { 20, 0x42, 60},
    { 0, 0x51, 31},
    { 24, 0x31, 56},
    { 15, 0x52, 63},
    { 15, 0x41, 47},
    // 210: Local time: 09:06:00 PM
    { 21, 0x30, 30},
    { 0, 0x42, 59},
    { 12, 0x42, 51},
    { 18, 0x53, 69},
    { 0, 0x30, 48},
    { 0, 0x66, 66},
    { 0, 0x58, 16},
    { 0, 0x58, 7},
    { 0, 0x68, 15},
    { 0, 0x68, 0},
    { 0, 0x67, 0},
    { 0, 0x57, 37},
    { 0, 0x55, 13},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    // 225: Local time: 09:21:00 PM
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    // 240: Local time: 09:36:00 PM
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x55, 11},
    { 0, 0x55, 4},
    { 0, 0x62, 42},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},                    // start deep
    // 255: Local time: 09:51:00 PM
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    // 270: Local time: 10:06:00 PM
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x62, 5},
    { 0, 0x72, 0},
    { 0, 0x72, 0},
    { 0, 0x72, 0},
    { 0, 0x72, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    // 285: Local time: 10:21:00 PM
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},                        // end deep
    { 0, 0x73, 0},
    // 300: Local time: 10:36:00 PM
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x63, 0},
    { 0, 0x73, 0},
    { 0, 0x62, 24},
    { 0, 0x60, 15},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    // 315: Local time: 10:51:00 PM
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 11, 0x60, 50},
    { 0, 0x12, 30},
    { 0, 0x21, 64},
    { 0, 0x1b, 0},
    // 330: Local time: 11:06:00 PM
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    // 345: Local time: 11:21:01 PM
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    { 0, 0x1b, 0},
    // 360: Local time: 11:36:00 PM
    { 0, 0x1b, 0},
    { 0, 0x77, 25},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 11},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    // 375: Local time: 11:51:00 PM
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 8},
    { 0, 0x76, 0},
    { 0, 0x76, 8},
    { 0, 0x76, 0},
    { 0, 0x76, 3},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 8},
    { 0, 0x76, 20},
    { 0, 0x25, 10},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    // 390: Local time: 12:06:00 AM
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    // 405: Local time: 12:21:00 AM
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    // 420: Local time: 12:36:00 AM
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    // 435: Local time: 12:51:00 AM
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 3},
    { 0, 0x25, 20},
    { 0, 0x35, 26},
    { 0, 0x55, 0},
    { 0, 0x45, 34},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    // 450: Local time: 01:06:01 AM
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    // 465: Local time: 01:21:01 AM
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 4},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x35, 17},
    // 480: Local time: 01:36:00 AM
    { 0, 0x3b, 0},
    { 0, 0x3b, 0},
    { 0, 0x3b, 0},
    { 0, 0x21, 42},
    { 0, 0x42, 73},
    { 0, 0x63, 23},
    { 0, 0x63, 4},
    { 0, 0x34, 13},
    { 0, 0x34, 0},
    { 0, 0x34, 0},                           // start deep
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    // 495: Local time: 01:51:00 AM
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    // 510: Local time: 02:06:00 AM
    { 0, 0x34, 0},
    { 0, 0x44, 10},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    // 525: Local time: 02:21:00 AM
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},                        // end deep
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    // 540: Local time: 02:36:00 AM
    { 0, 0x54, 33},
    { 0, 0x7f, 0},
    { 0, 0x7f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 9, 0x70, 22},
    { 0, 0x71, 0},
    { 0, 0x71, 2},
    { 0, 0x71, 0},
    { 0, 0x71, 0},
    { 0, 0x71, 0},
    { 0, 0x71, 0},
    { 0, 0x71, 6},
    { 0, 0x71, 2},
    { 0, 0x71, 0},
    // 555: Local time: 02:51:00 AM
    { 0, 0x71, 0},
    { 0, 0x71, 0},
    { 0, 0x71, 3},
    { 0, 0x71, 3},
    { 0, 0x72, 0},
    { 0, 0x72, 4},
    { 0, 0x72, 0},
    { 0, 0x72, 0},
    { 0, 0x72, 0},
    { 0, 0x72, 3},
    { 0, 0x72, 0},
    { 0, 0x72, 0},
    { 0, 0x6e, 27},
    { 0, 0x6d, 0},
    { 0, 0x6d, 3},
    // 570: Local time: 03:06:00 AM
    { 0, 0x6d, 0},
    { 0, 0x6d, 20},
    { 0, 0x75, 23},
    { 0, 0x45, 33},
    { 0, 0x45, 0},
    { 0, 0x45, 16},
    { 0, 0x45, 0},
    { 0, 0x64, 49},
    { 0, 0x73, 0},
    { 0, 0x73, 16},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    // 585: Local time: 03:21:00 AM
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x72, 36},
    { 0, 0x73, 56},
    { 0, 0x76, 7},
    { 0, 0x75, 19},
    { 0, 0x75, 26},
    { 0, 0x75, 14},
    { 0, 0x75, 24},
    { 0, 0x75, 31},
    { 21, 0x75, 48},
    { 0, 0x68, 57},
    { 0, 0x69, 14},
    { 0, 0x68, 30},
    { 0, 0x5a, 33},
    // 600: Local time: 03:36:00 AM
    { 0, 0x4b, 21},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x5a, 40},
    { 0, 0x78, 23},
    { 0, 0x78, 33},
    { 0, 0x78, 9},
    { 0, 0x69, 26},
    { 0, 0x68, 30},
    { 0, 0x68, 28},
    { 0, 0x66, 35},
    { 0, 0x66, 30},
    { 0, 0x65, 11},
    { 0, 0x69, 15},
    { 10, 0x79, 43},
    // 615: Local time: 03:51:00 AM
    { 10, 0x69, 51},
    { 0, 0x69, 31},
    { 0, 0x68, 11},
    { 0, 0x69, 27},
    { 0, 0x69, 54},
    { 0, 0x78, 27},
    { 0, 0x76, 26},
    { 18, 0x76, 32},
    { 0, 0x74, 63},
    { 0, 0x60, 0},
    { 0, 0x6f, 33},
    { 0, 0x6f, 0},
    { 0, 0x60, 18},
    { 0, 0x60, 0},
    { 0, 0x6f, 25},
    // 630: Local time: 04:06:00 AM
    { 0, 0x61, 0},
    { 0, 0x61, 0},
    { 0, 0x61, 31},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 21},
    { 0, 0x6f, 0},
    { 7, 0x6f, 48},
    { 0, 0x6f, 47},
    { 0, 0x60, 0},
    { 9, 0x60, 16},
    { 6, 0x7f, 26},
    { 0, 0x7f, 24},
    { 0, 0x70, 18},
    // 645: Local time: 04:21:00 AM
    { 0, 0x7f, 18},
    { 0, 0x7f, 28},
    { 0, 0x7f, 20},
    { 0, 0x60, 15},
    { 0, 0x60, 0},
    { 0, 0x60, 0},
    { 0, 0x60, 17},
    { 6, 0x60, 14},
    { 0, 0x6f, 38},
    { 0, 0x6f, 32},
    { 0, 0x6f, 23},
    { 0, 0x6f, 23},
    { 0, 0x6f, 29},
    { 0, 0x6f, 30},
    { 0, 0x6f, 21},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured at: 2015-08-21 21:14:00 local, 2015-08-22 04:14:00 GMT
// According to Misfit:
//  Total sleep from 9:53 pm to 6:00am (447 min))
//  Deep sleep 272 min
//  Light sleep 175 min)
//  Breakdown (very approximate):
//   9:14pm awake (40 min)
//   9:53pm light (8 min)
//   10:01pm                deep (8 min)
//   10:09pm light (5 min)
//   10:14pm                deep (30 min)
//   10:44pm light (30 min)
//   11:15pm                deep (55 min)
//   12:10pm light (45 min + 5 min awake)
//   1:00am                 deep (70 min)
//   2:10am light (45 min + 5 min awake)
//   3:00am                 deep (40 min)
//   3:40am light (35 min)
//   4:15am                 deep (70 min)
//   5:25am light (35 min)
//   6:00am end of samples
AlgDlsMinuteData *activity_sample_sleep_v1_3(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_3_v1
  //> TEST_VERSION 1
  //> TEST_TOTAL 447
  //> TEST_TOTAL_MIN 400
  //> TEST_TOTAL_MAX 500
  //> TEST_DEEP 272
  //> TEST_DEEP_MIN 120
  //> TEST_DEEP_MAX 300
  //> TEST_START_AT 40
  //> TEST_START_AT_MIN 30
  //> TEST_START_AT_MAX 50
  //> TEST_END_AT 524
  //> TEST_END_AT_MIN 515
  //> TEST_END_AT_MAX 535
  //> TEST_CUR_STATE_ELAPSED 35
  //> TEST_CUR_STATE_ELAPSED_MIN 30
  //> TEST_CUR_STATE_ELAPSED_MAX 120
  //> TEST_IN_SLEEP 1
  //> TEST_IN_SLEEP_MIN 1
  //> TEST_IN_SLEEP_MAX 1
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc}
  static AlgDlsMinuteData samples[] = { 
    { 0, 0x44, 18},
    { 7, 0x75, 34},
    { 8, 0x54, 16},
    { 12, 0x65, 39},
    { 11, 0x56, 22},
    { 0, 0x75, 17},
    { 8, 0x75, 43},
    { 0, 0x74, 20},
    { 0, 0x74, 26},
    { 0, 0x74, 20},
    { 0, 0x74, 19},
    { 0, 0x74, 22},
    { 7, 0x64, 17},
    { 0, 0x64, 13},
    { 0, 0x64, 8},
    // 15: Local time: 09:29:00 PM
    { 0, 0x64, 17},
    { 0, 0x74, 35},
    { 6, 0x43, 38},
    { 16, 0x53, 64},
    { 50, 0x51, 60},
    { 0, 0x52, 75},
    { 12, 0x54, 70},
    { 8, 0x64, 61},
    { 17, 0x51, 63},
    { 12, 0x42, 86},
    { 0, 0x42, 47},
    { 0, 0x42, 49},
    { 0, 0x41, 43},
    { 0, 0x62, 47},
    { 7, 0x54, 64},
    // 30: Local time: 09:44:00 PM
    { 0, 0x54, 56},
    { 0, 0x64, 35},
    { 11, 0x52, 53},
    { 0, 0x64, 39},
    { 14, 0x52, 41},
    { 0, 0x43, 63},
    { 7, 0x42, 56},
    { 8, 0x51, 80},
    { 8, 0x62, 47},
    { 0, 0x62, 22},   // start light
    { 0, 0x62, 0},
    { 0, 0x62, 0},
    { 0, 0x63, 17},
    { 0, 0x54, 32},
    { 0, 0x64, 24},
    // 45: Local time: 09:59:00 PM
    { 0, 0x64, 10},
    { 0, 0x74, 0},     // start deep
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},     // start light
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    // 60: Local time: 10:14:00 PM
    { 0, 0x74, 7},     // start DEEP
    { 0, 0x74, 6},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x64, 13},
    { 0, 0x64, 0},
    // 75: Local time: 10:29:00 PM
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 11},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 90: Local time: 10:44:00 PM
    { 0, 0x64, 0},       // start light
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 20},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 5},
    { 0, 0x75, 0},
    { 0, 0x75, 0},
    // 105: Local time: 10:59:00 PM
    { 0, 0x75, 3},
    { 0, 0x75, 0},
    { 0, 0x75, 0},
    { 0, 0x64, 13},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 120: Local time: 11:14:00 PM
    { 0, 0x73, 33},
    { 0, 0x8f, 0},   // start DEEP
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    // 135: Local time: 11:29:00 PM
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    // 150: Local time: 11:44:00 PM
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x64, 22},
    // 165: Local time: 11:59:00 PM
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},     // start light
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x75, 16},
    { 0, 0x76, 6},
    // 180: Local time: 12:14:00 AM
    { 0, 0x76, 0},
    { 0, 0x86, 19},
    { 0, 0x7d, 3},
    { 0, 0x7d, 3},
    { 0, 0x7d, 0},
    { 0, 0x7d, 0},
    { 0, 0x7d, 0},
    { 0, 0x7d, 0},
    { 0, 0x7d, 0},
    { 0, 0x7d, 0},
    { 0, 0x7d, 0},
    { 0, 0x7d, 3},
    { 0, 0x8e, 9},
    { 0, 0x83, 0},
    { 0, 0x83, 0},
    // 195: Local time: 12:29:00 AM
    { 0, 0x83, 4},
    { 0, 0x84, 0},
    { 0, 0x84, 0},
    { 0, 0x84, 0},
    { 0, 0x84, 0},
    { 0, 0x84, 0},
    { 0, 0x75, 14},
    { 0, 0x66, 0},
    { 0, 0x66, 5},
    { 0, 0x66, 4},
    { 0, 0x66, 0},
    { 0, 0x66, 6},
    { 0, 0x66, 13},    // start wake
    { 0, 0x74, 12},
    { 0, 0x85, 15},
    // 210: Local time: 12:44:00 AM
    { 0, 0x86, 0},
    { 0, 0x86, 0},
    { 0, 0x79, 39},
    { 0, 0x46, 28},    // start light
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    // 225: Local time: 12:59:00 AM
    { 0, 0x46, 0},
    { 0, 0x46, 0},         // start DEEP
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    // 240: Local time: 01:14:00 AM
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x56, 9},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    // 255: Local time: 01:29:00 AM
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x56, 0},
    { 0, 0x38, 21},
    // 270: Local time: 01:44:00 AM
    { 0, 0x3b, 0},
    { 0, 0x3b, 0},
    { 0, 0x3b, 0},
    { 0, 0x2b, 7},
    { 0, 0x2b, 0},
    { 0, 0x2b, 0},
    { 0, 0x2b, 0},
    { 0, 0x2b, 0},
    { 0, 0x2b, 0},
    { 0, 0x2b, 0},
    { 0, 0x2b, 0},
    { 0, 0x4b, 10},
    { 0, 0x5c, 0},
    { 0, 0x5c, 0},
    { 0, 0x5c, 0},
    // 285: Local time: 01:59:00 AM
    { 0, 0x5c, 0},
    { 0, 0x5c, 0},
    { 0, 0x3c, 10},
    { 0, 0x3c, 0},
    { 0, 0x3c, 0},
    { 0, 0x3c, 0},
    { 0, 0x3c, 0},
    { 0, 0x3c, 0},
    { 0, 0x3c, 0},     // start light
    { 0, 0x3c, 0},
    { 0, 0x3c, 0},
    { 0, 0x27, 20},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    // 300: Local time: 02:14:00 AM
    { 0, 0x26, 4},
    { 0, 0x27, 0},
    { 0, 0x27, 0},
    { 0, 0x27, 0},
    { 0, 0x27, 0},
    { 0, 0x27, 0},
    { 0, 0x27, 0},
    { 0, 0x27, 0},
    { 0, 0x36, 10},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    // 315: Local time: 02:29:00 AM
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 5},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 5},
    // 330: Local time: 02:44:00 AM
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    // 345: Local time: 03:00:00 AM
    { 0, 0x45, 0},      // start DEEP
    { 0, 0x46, 21},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    // 360: Local time: 03:15:00 AM
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x39, 20},
    { 0, 0x3a, 0},
    { 0, 0x3a, 7},
    { 0, 0x3b, 9},
    { 0, 0x3b, 0},
    { 0, 0x3b, 0},
    // 375: Local time: 03:30:00 AM
    { 0, 0x3b, 0},
    { 0, 0x3b, 0},
    { 0, 0x48, 21},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 0},
    { 0, 0x45, 4},
    { 0, 0x48, 21},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},     // start light
    { 0, 0x4b, 0},
    { 0, 0x3b, 9},
    { 0, 0x3b, 0},
    { 0, 0x3b, 0},
    { 0, 0x3b, 0},
    // 390: Local time: 03:45:00 AM
    { 0, 0x3d, 48},
    { 24, 0x13, 32},
    { 9, 0x62, 66},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x73, 30},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 405: Local time: 04:00:00 AM
    { 0, 0x64, 35},
    { 0, 0x66, 47},
    { 0, 0x68, 0},
    { 0, 0x67, 36},
    { 0, 0x66, 16},
    { 0, 0x65, 0},
    { 0, 0x67, 17},
    { 0, 0x68, 12},
    { 0, 0x59, 9},
    { 0, 0x73, 47},
    { 0, 0x60, 2},
    { 0, 0x72, 43},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    // 420: Local time: 04:15:00 AM
    { 0, 0x74, 0},         // start DEEP
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x74, 0},
    { 0, 0x72, 44},
    { 0, 0x6e, 33},
    { 0, 0x5f, 45},
    { 0, 0x63, 18},
    // 435: Local time: 04:30:00 AM
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x72, 24},
    { 0, 0x52, 53},
    // 450: Local time: 04:45:00 AM
    { 0, 0x1c, 5},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    // 465: Local time: 05:00:00 AM
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x1c, 0},
    { 0, 0x17, 26},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x46, 19},
    { 0, 0x46, 24},
    { 0, 0x24, 0},
    { 0, 0x24, 0},
    { 0, 0x24, 0},
    { 0, 0x24, 0},
    // 480: Local time: 05:15:00 AM
    { 0, 0x24, 0},
    { 0, 0x24, 0},
    { 0, 0x24, 6},
    { 0, 0x69, 20},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},      // start light
    { 0, 0x69, 0},
    { 0, 0x69, 5},
    { 0, 0x6a, 6},
    { 0, 0x6a, 0},
    { 0, 0x46, 25},
    { 0, 0x59, 11},
    // 495: Local time: 05:30:00 AM
    { 9, 0x68, 45},
    { 5, 0x63, 32},
    { 0, 0x53, 61},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    // 510: Local time: 05:45:00 AM
    { 0, 0x43, 3},
    { 0, 0x43, 0},
    { 0, 0x43, 3},
    { 0, 0x43, 0},
    { 0, 0x43, 0},
    { 0, 0x43, 0},
    { 0, 0x43, 7},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x53, 0},
    { 0, 0x73, 17},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



// ----------------------------------------------------------------
// Sample captured at: 2015-08-22 19:57:00 local, 2015-08-23 02:57:00 GMT
// Accroding to misfit:
//  total sleep: 374 min
//  deep: 200 min
//  light: 174 min
//  7:57pm awake (220 min)
//  11:36pm light (5 min)
//   ...
//  5;54am awake
AlgDlsMinuteData *activity_sample_sleep_v1_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_4_v1
  //> TEST_VERSION 1
  //> TEST_TOTAL 374
  //> TEST_TOTAL_MIN 350
  //> TEST_TOTAL_MAX 400
  //> TEST_DEEP 200
  //> TEST_DEEP_MIN 150
  //> TEST_DEEP_MAX 260
  //> TEST_START_AT 222
  //> TEST_START_AT_MIN 200
  //> TEST_START_AT_MAX 250
  //> TEST_END_AT 601
  //> TEST_END_AT_MIN 550
  //> TEST_END_AT_MAX 650
  //> TEST_CUR_STATE_ELAPSED 89
  //> TEST_CUR_STATE_ELAPSED_MIN 50
  //> TEST_CUR_STATE_ELAPSED_MAX 100
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc}
  static AlgDlsMinuteData samples[] = { 
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x8f, 0},
    { 0, 0x64, 54},
    { 0, 0x42, 48},
    { 8, 0x42, 66},
    { 8, 0x42, 74},
    { 0, 0x42, 77},
    { 0, 0x73, 45},
    { 0, 0x74, 17},
    { 0, 0x64, 77},
    { 0, 0x64, 75},
    // 15: Local time: 08:12:00 PM
    { 12, 0x54, 79},
    { 24, 0x53, 65},
    { 14, 0x52, 50},
    { 24, 0x41, 44},
    { 7, 0x52, 48},
    { 17, 0x56, 69},
    { 0, 0x44, 57},
    { 6, 0x54, 55},
    { 0, 0x54, 41},
    { 26, 0x52, 70},
    { 10, 0x53, 52},
    { 22, 0x41, 68},
    { 49, 0x42, 67},
    { 48, 0x41, 71},
    { 70, 0x41, 63},
    // 30: Local time: 08:27:00 PM
    { 56, 0x41, 58},
    { 25, 0x41, 52},
    { 35, 0x41, 69},
    { 0, 0x52, 65},
    { 6, 0x52, 32},
    { 0, 0x64, 13},
    { 0, 0x64, 11},
    { 0, 0x77, 35},
    { 0, 0x75, 35},
    { 0, 0x64, 25},
    { 12, 0x45, 37},
    { 0, 0x64, 18},
    { 0, 0x65, 16},
    { 0, 0x57, 31},
    { 0, 0x57, 19},
    // 45: Local time: 08:42:00 PM
    { 0, 0x66, 24},
    { 8, 0x65, 16},
    { 8, 0x57, 22},
    { 0, 0x64, 23},
    { 0, 0x64, 19},
    { 0, 0x62, 47},
    { 27, 0x41, 67},
    { 0, 0x87, 64},
    { 0, 0x76, 58},
    { 0, 0x76, 43},
    { 0, 0x76, 49},
    { 0, 0x74, 37},
    { 0, 0x75, 45},
    { 0, 0x75, 38},
    { 0, 0x76, 61},
    // 60: Local time: 08:57:00 PM
    { 0, 0x65, 54},
    { 6, 0x52, 69},
    { 0, 0x52, 56},
    { 0, 0x7e, 3},
    { 0, 0x18, 32},
    { 0, 0x18, 4},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    // 75: Local time: 09:11:00 PM
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    // 90: Local time: 09:26:00 PM
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    // 105: Local time: 09:41:00 PM
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    // 120: Local time: 09:56:00 PM
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 0},
    { 0, 0x18, 36},
    { 0, 0x7c, 32},
    { 0, 0x41, 67},
    { 0, 0x33, 57},
    // 135: Local time: 10:10:00 PM
    { 0, 0x42, 49},
    { 7, 0x42, 47},
    { 23, 0x52, 70},
    { 7, 0x78, 53},
    { 0, 0x78, 49},
    { 0, 0x78, 47},
    { 11, 0x67, 43},
    { 12, 0x78, 41},
    { 0, 0x76, 50},
    { 0, 0x65, 57},
    { 20, 0x42, 77},
    { 0, 0x42, 63},
    { 12, 0x43, 74},
    { 12, 0x56, 44},
    { 8, 0x57, 33},
    // 150: Local time: 10:25:00 PM
    { 0, 0x57, 35},
    { 16, 0x56, 25},
    { 25, 0x57, 26},
    { 0, 0x58, 14},
    { 8, 0x58, 29},
    { 8, 0x56, 14},
    { 0, 0x57, 33},
    { 6, 0x56, 25},
    { 20, 0x55, 26},
    { 24, 0x55, 23},
    { 18, 0x55, 24},
    { 0, 0x54, 0},
    { 0, 0x64, 7},
    { 0, 0x57, 20},
    { 0, 0x57, 17},
    // 165: Local time: 10:40:00 PM
    { 8, 0x55, 30},
    { 30, 0x55, 33},
    { 12, 0x65, 25},
    { 8, 0x66, 17},
    { 15, 0x65, 16},
    { 0, 0x65, 29},
    { 0, 0x54, 0},
    { 0, 0x64, 11},
    { 0, 0x64, 18},
    { 0, 0x64, 0},
    { 0, 0x64, 5},
    { 0, 0x64, 0},
    { 0, 0x64, 5},
    { 8, 0x56, 24},
    { 8, 0x65, 23},
    // 180: Local time: 10:55:00 PM
    { 0, 0x65, 19},
    { 21, 0x56, 24},
    { 0, 0x54, 0},
    { 0, 0x64, 7},
    { 0, 0x64, 6},
    { 0, 0x65, 17},
    { 0, 0x64, 11},
    { 0, 0x64, 15},
    { 8, 0x65, 20},
    { 20, 0x53, 46},
    { 0, 0x53, 31},
    { 0, 0x54, 14},
    { 0, 0x64, 16},
    { 0, 0x64, 13},
    { 12, 0x43, 49},
    // 195: Local time: 11:10:00 PM
    { 33, 0x30, 55},
    { 0, 0x31, 53},
    { 0, 0x7f, 15},
    { 0, 0x42, 69},
    { 16, 0x33, 44},
    { 14, 0x40, 27},
    { 0, 0x40, 9},
    { 0, 0x42, 50},
    { 8, 0x3f, 28},
    { 0, 0x31, 32},
    { 0, 0x52, 48},
    { 0, 0x52, 20},
    { 8, 0x41, 18},
    { 0, 0x32, 21},
    { 0, 0x23, 19},
    // 210: Local time: 11:24:00 PM
    { 8, 0x53, 39},
    { 19, 0x51, 46},
    { 3, 0x41, 61},
    { 0, 0x43, 66},
    { 16, 0x30, 49},
    { 0, 0x42, 73},
    { 0, 0x54, 41},
    { 0, 0x42, 52},
    { 20, 0x51, 67},
    { 12, 0x52, 60},
    { 49, 0x41, 64},
    { 18, 0x52, 83},
    { 12, 0x6e, 46},
    { 0, 0x62, 0},
    { 0, 0x63, 25},
    // 225: Local time: 11:39:00 PM
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 5},
    { 0, 0x64, 41},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 240: Local time: 11:54:00 PM
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 255: Local time: 12:09:00 AM
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 8},
    { 0, 0x54, 19},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x44, 0},
    { 0, 0x54, 9},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    // 270: Local time: 12:24:00 AM
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 4},
    { 0, 0x64, 11},
    { 0, 0x64, 3},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 285: Local time: 12:39:00 AM
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 11},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 4},
    { 0, 0x25, 45},
    // 300: Local time: 12:54:00 AM
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    // 315: Local time: 01:09:00 AM
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    // 330: Local time: 01:24:00 AM
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x1a, 0},
    { 0, 0x16, 16},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    // 345: Local time: 01:39:00 AM
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 7},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    // 360: Local time: 01:54:00 AM
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 5},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 0},
    { 0, 0x25, 3},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    // 375: Local time: 02:09:00 AM
    { 0, 0x35, 0},
    { 0, 0x35, 0},
    { 0, 0x2a, 31},
    { 0, 0x3a, 0},
    { 0, 0x3a, 0},
    { 0, 0x3a, 0},
    { 0, 0x3a, 0},
    { 0, 0x3a, 0},
    { 0, 0x3a, 0},
    { 0, 0x3a, 0},
    { 0, 0x3a, 0},
    { 0, 0x3a, 0},
    { 0, 0x3a, 0},
    { 0, 0x3a, 0},
    { 0, 0x3a, 0},
    // 390: Local time: 02:24:00 AM
    { 0, 0x3a, 14},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    // 405: Local time: 02:39:00 AM
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x4b, 0},
    { 0, 0x59, 26},
    // 420: Local time: 02:54:00 AM
    { 0, 0x66, 3},
    { 0, 0x56, 6},
    { 0, 0x56, 0},
    { 0, 0x46, 32},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    // 435: Local time: 03:09:00 AM
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x36, 5},
    { 0, 0x36, 0},
    { 0, 0x36, 0},
    { 0, 0x36, 0},
    { 0, 0x36, 11},
    { 0, 0x36, 0},
    { 0, 0x36, 0},
    { 0, 0x36, 0},
    { 0, 0x36, 0},
    { 0, 0x36, 0},
    { 0, 0x36, 0},
    { 0, 0x46, 11},
    { 0, 0x46, 0},
    // 450: Local time: 03:24:00 AM
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 2},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x27, 31},
    { 9, 0x57, 45},
    { 0, 0x43, 31},
    { 0, 0x61, 44},
    { 0, 0x52, 12},
    { 0, 0x43, 12},
    { 0, 0x63, 0},
    // 465: Local time: 03:39:00 AM
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 51},
    { 0, 0x63, 57},
    { 0, 0x63, 28},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    // 480: Local time: 03:54:00 AM
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    // 495: Local time: 04:08:00 AM
    { 0, 0x63, 0},
    { 0, 0x63, 0},
    { 0, 0x63, 5},
    { 0, 0x53, 42},
    { 0, 0x15, 0},
    { 0, 0x15, 4},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    // 510: Local time: 04:23:00 AM
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x33, 41},
    // 525: Local time: 04:38:00 AM
    { 0, 0x62, 62},
    { 0, 0x73, 27},
    { 0, 0x73, 3},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x32, 20},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    // 540: Local time: 04:53:00 AM
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    // 555: Local time: 05:08:00 AM
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x12, 0},
    { 0, 0x43, 21},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 570: Local time: 05:23:00 AM
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 585: Local time: 05:38:00 AM
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x63, 29},
    { 0, 0x70, 0},
    { 0, 0x70, 0},
    { 0, 0x70, 3},
    { 0, 0x70, 0},
    // 600: Local time: 05:53:00 AM
    { 0, 0x70, 0},
    { 0, 0x70, 0},
    { 0, 0x70, 3},
    { 0, 0x71, 20},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x71, 39},
    { 0, 0x7e, 0},
    { 0, 0x7e, 0},
    { 0, 0x7a, 39},
    { 0, 0x69, 0},
    { 0, 0x66, 30},
    { 0, 0x46, 25},
    { 8, 0x37, 26},
    // 615: Local time: 06:08:00 AM
    { 0, 0x17, 0},
    { 0, 0x17, 0},
    { 0, 0x17, 0},
    { 0, 0x27, 17},
    { 0, 0x28, 31},
    { 0, 0x27, 13},
    { 0, 0x27, 0},
    { 0, 0x27, 11},
    { 0, 0x56, 36},
    { 0, 0x68, 34},
    { 0, 0x67, 32},
    { 0, 0x56, 32},
    { 0, 0x55, 22},
    { 0, 0x66, 41},
    { 0, 0x68, 43},
    // 630: Local time: 06:23:00 AM
    { 0, 0x77, 7},
    { 0, 0x5a, 43},
    { 0, 0x76, 15},
    { 0, 0x79, 16},
    { 0, 0x65, 0},
    { 12, 0x76, 35},
    { 44, 0x51, 67},
    { 0, 0x43, 58},
    { 0, 0x34, 47},
    { 0, 0x45, 50},
    { 0, 0x55, 37},
    { 0, 0x7d, 23},
    { 0, 0x64, 21},
    { 18, 0x61, 38},
    { 15, 0x33, 25},
    // 645: Local time: 06:38:00 AM
    { 0, 0x22, 49},
    { 12, 0x42, 64},
    { 6, 0x78, 45},
    { 0, 0x78, 0},
    { 0, 0x78, 0},
    { 24, 0x76, 17},
    { 0, 0x78, 21},
    { 0, 0x78, 0},
    { 0, 0x78, 0},
    { 0, 0x77, 16},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    // 660: Local time: 06:53:00 AM
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 30},
    { 0, 0x76, 20},
    { 0, 0x76, 0},
    { 0, 0x76, 0},
    { 0, 0x76, 10},
    { 0, 0x77, 13},
    { 0, 0x66, 33},
    { 0, 0x77, 27},
    { 0, 0x77, 0},
    { 0, 0x77, 3},
    { 0, 0x77, 4},
    // 675: Local time: 07:08:00 AM
    { 0, 0x67, 19},
    { 0, 0x77, 0},
    { 0, 0x79, 24},
    { 0, 0x76, 2},
    { 12, 0x42, 66},
    { 0, 0x42, 66},
    { 0, 0x52, 81},
    { 8, 0x42, 69},
    { 8, 0x42, 63},
    { 0, 0x74, 19},
    { 0, 0x74, 12},
    { 0, 0x64, 13},
    { 0, 0x64, 11},
    { 0, 0x85, 40},
    { 0, 0x8f, 0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}





// ----------------------------------------------------------------
// Sample captured at: 2015-08-23 10:21:00 local, 2015-08-23 17:21:00 GMT
// According to Misfit:
//  total sleep: 285 min
//  deep sleep: 173 min
//  light sleep: 112 min
//  Breakdown (very approximate):
//   10:21pm awake (17 min)
//   10:38pm light (10 min) (offset 17)
//   10:48pm deep (50 min)
//   11:38pm light (22 min)
//   12:00am deep (72 min)
//   1:12am light (15 min)
//   1:32am  deep (35 min)
//   2:07am light (28 min)
//   2:35am deep (20 min)
//   2:55am light (27 min)
//   3:22am wake (offset 300)
//
AlgDlsMinuteData *activity_sample_sleep_v1_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_5_v1
  //> TEST_VERSION 1
  //> TEST_TOTAL 285
  //> TEST_TOTAL_MIN 250
  //> TEST_TOTAL_MAX 420
  //> TEST_DEEP 173
  //> TEST_DEEP_MIN 130
  //> TEST_DEEP_MAX 180
  //> TEST_START_AT 17
  //> TEST_START_AT_MIN 10
  //> TEST_START_AT_MAX 40
  //> TEST_END_AT 300
  //> TEST_END_AT_MIN 280
  //> TEST_END_AT_MAX 440
  //> TEST_CUR_STATE_ELAPSED 225
  //> TEST_CUR_STATE_ELAPSED_MIN 120
  //> TEST_CUR_STATE_ELAPSED_MAX 270
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc}
  static AlgDlsMinuteData samples[] = { 
    // Deleted first 900 samples from earlier in the day (non-sleeping)
    // 000: Local time: 10:21:00 PM
    { 0, 0x53, 77},
    { 22, 0x52, 41},
    { 28, 0x53, 48},
    { 0, 0x54, 68},
    { 16, 0x42, 70},
    { 20, 0x52, 60},
    { 4, 0x41, 44},
    { 0, 0x54, 43},
    { 0, 0x54, 62},
    { 0, 0x54, 0},
    { 0, 0x44, 48},
    { 27, 0x54, 74},
    { 0, 0x53, 40},
    { 0, 0x62, 66},
    { 0, 0x61, 17},
    // 15: Local time: 10:36:00 PM
    { 8, 0x70, 28},
    { 0, 0x7f, 0},
    { 0, 0x7f, 0},
    { 0, 0x7f, 30},
    { 0, 0x56, 59},
    { 0, 0x49, 32},
    { 0, 0x5a, 0},
    { 0, 0x5a, 4},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 11},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    // 30: Local time: 10:51:00 PM
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    // 45: Local time: 11:06:00 PM
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    // 60: Local time: 11:21:00 PM
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x5a, 0},
    { 0, 0x48, 19},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    // 75: Local time: 11:36:00 PM
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x46, 0},
    { 0, 0x2a, 18},
    { 0, 0x2a, 0},
    { 0, 0x2a, 2},
    // 90: Local time: 11:51:00 PM
    { 0, 0x2a, 0},
    { 0, 0x2a, 0},
    { 0, 0x2a, 2},
    { 0, 0x3a, 11},
    { 0, 0x4a, 0},
    { 0, 0x4a, 19},
    { 0, 0x36, 0},
    { 0, 0x36, 0},
    { 0, 0x36, 0},
    { 0, 0x36, 26},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    // 105: Local time: 12:06:00 AM
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    // 120: Local time: 12:21:00 AM
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    // 135: Local time: 12:36:00 AM
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x36, 22},
    // 150: Local time: 12:51:00 AM
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x69, 14},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    // 165: Local time: 01:07:00 AM
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 2},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x79, 24},
    // 180: Local time: 01:22:00 AM
    { 0, 0x79, 0},
    { 0, 0x79, 0},
    { 0, 0x79, 0},
    { 0, 0x79, 0},
    { 0, 0x79, 0},
    { 0, 0x79, 0},
    { 0, 0x79, 0},
    { 0, 0x79, 0},
    { 0, 0x79, 0},
    { 0, 0x69, 21},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 0},
    { 0, 0x69, 14},
    { 0, 0x6a, 0},
    // 195: Local time: 01:37:00 AM
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    // 210: Local time: 01:52:00 AM
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    // 225: Local time: 02:07:00 AM
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 0},
    { 0, 0x6a, 35},
    { 0, 0x77, 14},
    { 0, 0x65, 59},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    // 240: Local time: 02:22:00 AM
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 13},
    { 0, 0x34, 0},
    { 0, 0x34, 4},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 2},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    // 255: Local time: 02:37:00 AM
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 3},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    { 0, 0x34, 0},
    // 270: Local time: 02:52:00 AM
    { 0, 0x34, 0},
    { 0, 0x34, 9},
    { 0, 0x82, 32},
    { 0, 0x84, 0},
    { 0, 0x84, 0},
    { 0, 0x84, 0},
    { 0, 0x84, 0},
    { 0, 0x84, 0},
    { 0, 0x84, 3},
    { 9, 0x32, 56},
    { 0, 0x23, 46},
    { 0, 0x9, 7},
    { 0, 0x9, 0},
    { 0, 0x9, 0},
    { 0, 0x9, 0},
    // 285: Local time: 03:07:00 AM
    { 0, 0x9, 0},
    { 0, 0x9, 0},
    { 0, 0x9, 0},
    { 0, 0x9, 0},
    { 0, 0x9, 0},
    { 0, 0x9, 0},
    { 0, 0x9, 0},
    { 0, 0x9, 0},
    { 0, 0x9, 0},
    { 0, 0x7, 21},
    { 0, 0x26, 11},
    { 0, 0x35, 0},
    { 0, 0x35, 4},
    { 0, 0x25, 0},
    { 0, 0x26, 0},
    // 300: Local time: 03:22:00 AM
    { 0, 0x26, 0},
    { 0, 0x26, 0},
    { 0, 0x36, 16},
    { 12, 0x7e, 53},
    { 0, 0x8d, 64},
    { 0, 0x67, 0},
    { 0, 0x67, 0},
    { 0, 0x67, 0},
    { 0, 0x67, 11},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 20},
    { 0, 0x67, 40},
    { 0, 0x58, 14},
    // 315: Local time: 03:37:00 AM
    { 6, 0x58, 21},
    { 0, 0x76, 40},
    { 0, 0x65, 32},
    { 0, 0x65, 24},
    { 0, 0x65, 27},
    { 0, 0x65, 23},
    { 0, 0x66, 23},
    { 0, 0x65, 26},
    { 0, 0x65, 15},
    { 0, 0x66, 21},
    { 0, 0x67, 29},
    { 0, 0x76, 8},
    { 0, 0x66, 9},
    { 0, 0x68, 0},
    { 0, 0x69, 42},
    // 330: Local time: 03:52:00 AM
    { 0, 0x65, 24},
    { 0, 0x75, 23},
    { 0, 0x67, 25},
    { 0, 0x79, 37},
    { 0, 0x78, 42},
    { 0, 0x78, 0},
    { 0, 0x78, 0},
    { 0, 0x78, 23},
    { 0, 0x77, 24},
    { 0, 0x67, 15},
    { 0, 0x68, 33},
    { 0, 0x68, 25},
    { 0, 0x68, 31},
    { 0, 0x71, 59},
    { 0, 0x64, 9},
    // 345: Local time: 04:07:00 AM
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x64, 0},
    { 0, 0x24, 10},
    { 0, 0x14, 3},
    { 0, 0x14, 0},
    { 0, 0x14, 0},
    { 0, 0x14, 0},
    { 0, 0x14, 0},
    // 360: Local time: 04:22:00 AM
    { 0, 0x14, 0},
    { 0, 0x14, 0},
    { 0, 0x13, 22},
    { 0, 0x10, 0},
    { 0, 0x10, 0},
    { 0, 0x10, 0},
    { 0, 0x32, 19},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 10},
    { 0, 0x63, 11},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    // 375: Local time: 04:37:00 AM
    { 0, 0x73, 0},
    { 0, 0x73, 0},
    { 0, 0x73, 18},
    { 0, 0x73, 0},
    { 0, 0x73, 14},
    { 0, 0x54, 30},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x54, 0},
    { 0, 0x44, 12},
    // 390: Local time: 04:52:00 AM
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x15, 0},
    { 0, 0x54, 17},
    { 0, 0x55, 0},
    { 0, 0x55, 0},
    { 0, 0x54, 7},
    { 0, 0x44, 0},
    { 0, 0x44, 35},
    { 0, 0x77, 14},
    // 405: Local time: 05:07:00 AM
    { 0, 0x67, 8},
    { 0, 0x67, 0},
    { 0, 0x67, 0},
    { 0, 0x67, 0},
    { 0, 0x67, 3},
    { 0, 0x67, 0},
    { 0, 0x67, 0},
    { 0, 0x67, 0},
    { 0, 0x67, 9},
    { 0, 0x66, 0},
    { 0, 0x66, 9},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 8},
    { 0, 0x66, 0},
    // 420: Local time: 05:22:00 AM
    { 0, 0x66, 5},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x66, 0},
    { 0, 0x67, 20},
    { 0, 0x78, 14},
    { 0, 0x67, 9},
    { 0, 0x77, 24},
    { 0, 0x2e, 46},
    { 0, 0x2f, 0},
    { 0, 0x2f, 0},
    { 0, 0x2f, 0},
    // 435: Local time: 05:37:00 AM
    { 0, 0x3f, 19},
    { 24, 0x72, 35},
    { 0, 0x56, 39},
    { 0, 0x56, 13},
    { 0, 0x56, 30},
    { 0, 0x67, 60},
    { 0, 0x69, 33},
    { 0, 0x68, 27},
    { 0, 0x78, 33},
    { 19, 0x74, 55},
    { 11, 0x81, 49},
    { 0, 0x8c, 0},                          // <- started charging watch
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 450: Local time: 05:52:00 AM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 465: Local time: 06:07:00 AM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 480: Local time: 06:22:00 AM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 495: Local time: 06:39:00 AM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 510: Local time: 06:55:00 AM
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    { 0, 0x8c, 0},
    // 525: Local time: 07:10:00 AM
    { 0, 0x64, 37},
    { 8, 0x52, 43},
    { 12, 0x53, 39},
    { 0, 0x65, 11},
    { 0, 0x63, 12},
    { 0, 0x54, 24},
    { 0, 0x46, 23},
    { 0, 0x55, 19},
    { 0, 0x54, 22},
    { 0, 0x43, 36},
    { 0, 0x55, 10},
    { 0, 0x54, 25},
    { 8, 0x32, 30},
    { 0, 0x42, 21},
    { 0, 0x42, 35},
    // 540: Local time: 07:25:00 AM
    { 12, 0x42, 50},
    { 6, 0x52, 57},
    { 0, 0x63, 64},
    { 20, 0x42, 58},
    { 0, 0x43, 76},
    { 8, 0x53, 68},
    { 0, 0x44, 72},
    { 0, 0x42, 48},
    { 0, 0x51, 48},
    { 27, 0x63, 63},
    { 0, 0x53, 68},
    { 0, 0x53, 68},
    { 0, 0x42, 56},
    { 0, 0x42, 51},
    { 12, 0x54, 62},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

