/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

// ----------------------------------------------------------------
// Sample captured at: 2015-10-25 07:28:00 local, 2015-10-25 14:28:00 GMT
//
// NOTE: The time from 7:31am to 7:59am (offset 1438 to 1467) was actually "not-worn", but the
// algorithm thinks this was sleep time. In this case, the user took the watch off in the
// morning (at 7:31am) and then put it back on again at 7:59am.
// Not sure how to detect this because during this period, the watch actually changed orientation
// once (at 7:46am, offset 1453) and had a small amount of VMC as well, so it looks like just
// deep sleep.
//
// So, we are fudging the expected values here to allow this test to pass
AlgDlsMinuteData *activity_sample_2015_10_25_07_28_00(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME pbl_28365
  //> TEST_VERSION 2
  //> TEST_TOTAL -1
  //> TEST_TOTAL_MIN -1
  //> TEST_TOTAL_MAX -1
  //> TEST_DEEP -1
  //> TEST_DEEP_MIN -1
  //> TEST_DEEP_MAX -1
  //> TEST_START_AT -1
  //> TEST_START_AT_MIN -1
  //> TEST_START_AT_MAX -1
  //> TEST_END_AT 1437
  //> TEST_END_AT_MIN 1415
  //> TEST_END_AT_MAX 1470      // Fudged: see above. Should be just slightly greater than 1437
  //> TEST_CUR_STATE_ELAPSED -1
  //> TEST_CUR_STATE_ELAPSED_MIN -1
  //> TEST_CUR_STATE_ELAPSED_MAX -1
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0

  // list of: {steps, orientation, vmc, light}
  static AlgDlsMinuteData samples[] = {
    { 0, 0x57, 495, 168},
    { 0, 0x68, 1524, 165},
    { 0, 0x58, 1292, 170},
    { 0, 0x57, 166, 168},
    { 0, 0x57, 0, 167},
    { 0, 0x67, 616, 163},
    { 0, 0x58, 550, 171},
    { 8, 0x68, 1051, 172},
    { 0, 0x57, 528, 168},
    { 0, 0x68, 468, 171},
    { 0, 0x69, 323, 169},
    { 8, 0x78, 1156, 168},
    { 0, 0x68, 438, 169},
    { 0, 0x77, 684, 169},
    { 0, 0x77, 302, 170},
    // 15: Local time: 07:43:00 AM
    { 0, 0x67, 1581, 175},
    { 0, 0x57, 634, 172},
    { 0, 0x67, 1355, 166},
    { 0, 0x67, 1369, 172},
    { 0, 0x68, 961, 172},
    { 0, 0x69, 2009, 166},
    { 0, 0x57, 3183, 169},
    { 0, 0x69, 1113, 168},
    { 0, 0x79, 973, 170},
    { 0, 0x59, 1944, 169},
    { 0, 0x58, 807, 169},
    { 0, 0x58, 514, 170},
    { 0, 0x69, 1853, 168},
    { 0, 0x4a, 1244, 166},
    { 0, 0x6a, 1226, 169},
    // 30: Local time: 07:58:00 AM
    { 0, 0x69, 583, 170},
    { 0, 0x7b, 0, 171},
    { 0, 0x7b, 87, 171},
    { 0, 0x7b, 0, 171},
    { 0, 0x7b, 0, 171},
    { 0, 0x7a, 146, 171},
    { 0, 0x7a, 6, 171},
    { 0, 0x7a, 15, 172},
    { 0, 0x7a, 0, 172},
    { 0, 0x8c, 239, 164},
    { 0, 0x7c, 53, 173},
    { 0, 0x8c, 61, 173},
    { 0, 0x8c, 0, 173},
    { 0, 0x8c, 0, 173},
    { 0, 0x8c, 0, 173},
    // 45: Local time: 08:13:00 AM
    { 0, 0x8c, 0, 174},
    { 0, 0x8b, 68, 174},
    { 0, 0x8a, 0, 174},
    { 0, 0x8a, 25, 174},
    { 0, 0x8a, 0, 174},
    { 0, 0x8a, 0, 174},
    { 0, 0x8a, 0, 174},
    { 0, 0x8c, 363, 175},
    { 0, 0x8d, 1, 175},
    { 0, 0x8d, 0, 175},
    { 0, 0x8d, 0, 176},
    { 0, 0x8d, 0, 176},
    { 0, 0x8c, 581, 174},
    { 0, 0x76, 0, 174},
    { 0, 0x87, 0, 175},
    // 60: Local time: 08:28:00 AM
    { 0, 0x87, 0, 175},
    { 0, 0x87, 0, 175},
    { 0, 0x89, 48, 177},
    { 0, 0x8b, 0, 177},
    { 0, 0x8b, 0, 178},
    { 0, 0x8b, 0, 178},
    { 0, 0x8b, 0, 178},
    { 0, 0x8b, 0, 178},
    { 0, 0x8b, 0, 178},
    { 0, 0x8b, 0, 178},
    { 0, 0x8b, 0, 178},
    { 0, 0x8b, 0, 179},
    { 0, 0x8b, 0, 179},
    { 0, 0x8b, 0, 179},
    { 0, 0x8b, 0, 179},
    // 75: Local time: 08:43:00 AM
    { 0, 0x8b, 0, 179},
    { 0, 0x8b, 0, 179},
    { 0, 0x8b, 0, 179},
    { 0, 0x8b, 0, 179},
    { 0, 0x8b, 0, 188},
    { 0, 0x70, 466, 185},
    { 0, 0x50, 0, 185},
    { 0, 0x50, 0, 185},
    { 0, 0x50, 0, 186},
    { 0, 0x50, 0, 186},
    { 0, 0x50, 0, 185},
    { 0, 0x60, 0, 186},
    { 0, 0x60, 0, 186},
    { 0, 0x50, 0, 186},
    { 0, 0x50, 0, 186},
    // 90: Local time: 08:58:00 AM
    { 0, 0x50, 0, 186},
    { 0, 0x50, 0, 186},
    { 0, 0x61, 3426, 186},
    { 0, 0x42, 3481, 186},
    { 0, 0x41, 2056, 185},
    { 0, 0x41, 1664, 176},
    { 0, 0x41, 741, 176},
    { 0, 0x41, 986, 187},
    { 17, 0x53, 3112, 188},
    { 0, 0x44, 4666, 184},
    { 0, 0x45, 3138, 175},
    { 0, 0x28, 3171, 183},
    { 0, 0x45, 2975, 186},
    { 0, 0x56, 2787, 172},
    { 0, 0x26, 3300, 174},
    // 105: Local time: 09:13:00 AM
    { 0, 0x45, 1999, 182},
    { 0, 0x34, 1789, 176},
    { 16, 0x45, 3255, 186},
    { 0, 0x34, 3037, 178},
    { 0, 0x32, 232, 180},
    { 0, 0x22, 12, 179},
    { 0, 0x22, 416, 196},
    { 0, 0x42, 1959, 179},
    { 0, 0x32, 392, 177},
    { 0, 0x54, 2725, 200},
    { 0, 0x64, 1658, 182},
    { 0, 0x35, 1202, 182},
    { 0, 0x53, 6547, 180},
    { 20, 0x45, 6227, 176},
    { 0, 0x25, 4147, 167},
    // 120: Local time: 09:28:00 AM
    { 0, 0x46, 664, 175},
    { 0, 0x37, 2216, 225},
    { 10, 0x47, 1689, 234},
    { 0, 0x56, 221, 233},
    { 0, 0x56, 922, 223},
    { 8, 0x57, 2016, 234},
    { 0, 0x46, 2078, 235},
    { 10, 0x55, 862, 236},
    { 18, 0x47, 703, 238},
    { 12, 0x37, 2194, 219},
    { 0, 0x46, 1042, 232},
    { 0, 0x47, 677, 229},
    { 8, 0x47, 1018, 212},
    { 13, 0x48, 2078, 230},
    { 0, 0x47, 1388, 230},
    // 135: Local time: 09:43:00 AM
    { 0, 0x47, 846, 232},
    { 0, 0x47, 2292, 227},
    { 0, 0x66, 1016, 235},
    { 0, 0x36, 2111, 207},
    { 0, 0x46, 2631, 237},
    { 0, 0x64, 576, 239},
    { 0, 0x56, 1254, 238},
    { 0, 0x47, 2596, 235},
    { 12, 0x47, 1787, 237},
    { 37, 0x47, 3333, 238},
    { 12, 0x57, 3288, 234},
    { 0, 0x58, 999, 232},
    { 12, 0x47, 2486, 239},
    { 0, 0x55, 220, 237},
    { 8, 0x55, 536, 236},
    // 150: Local time: 09:58:00 AM
    { 0, 0x55, 316, 236},
    { 0, 0x55, 163, 236},
    { 0, 0x46, 1374, 216},
    { 0, 0x47, 1221, 238},
    { 0, 0x47, 733, 209},
    { 0, 0x45, 1364, 198},
    { 0, 0x37, 3037, 206},
    { 8, 0x42, 2619, 171},
    { 24, 0x32, 3315, 190},
    { 0, 0x42, 6201, 186},
    { 0, 0x42, 7483, 195},
    { 0, 0x32, 10049, 185},
    { 20, 0x31, 6478, 177},
    { 0, 0x45, 5035, 180},
    { 0, 0x54, 1701, 176},
    // 165: Local time: 10:13:00 AM
    { 13, 0x44, 2104, 180},
    { 15, 0x46, 3283, 186},
    { 0, 0x35, 6134, 187},
    { 8, 0x44, 3980, 180},
    { 0, 0x44, 4195, 168},
    { 0, 0x35, 4742, 177},
    { 0, 0x54, 1643, 173},
    { 0, 0x53, 261, 176},
    { 0, 0x63, 1120, 177},
    { 0, 0x45, 2441, 166},
    { 0, 0x45, 3854, 175},
    { 0, 0x33, 5773, 163},
    { 12, 0x41, 4002, 174},
    { 9, 0x43, 4902, 169},
    { 0, 0x45, 586, 223},
    // 180: Local time: 10:28:00 AM
    { 0, 0x34, 4035, 230},
    { 0, 0x46, 2173, 189},
    { 0, 0x46, 3479, 194},
    { 9, 0x55, 3923, 202},
    { 0, 0x66, 3582, 199},
    { 0, 0x46, 5055, 203},
    { 0, 0x46, 3512, 222},
    { 0, 0x74, 1312, 219},
    { 20, 0x46, 3147, 228},
    { 12, 0x74, 3181, 230},
    { 0, 0x65, 4209, 230},
    { 0, 0x64, 385, 224},
    { 0, 0x64, 175, 222},
    { 0, 0x64, 359, 222},
    { 0, 0x64, 853, 194},
    // 195: Local time: 10:43:00 AM
    { 12, 0x36, 927, 206},
    { 0, 0x47, 633, 202},
    { 0, 0x46, 1121, 228},
    { 0, 0x65, 53, 228},
    { 17, 0x45, 1039, 223},
    { 0, 0x46, 1522, 215},
    { 10, 0x37, 3143, 234},
    { 28, 0x47, 5835, 198},
    { 0, 0x65, 118, 231},
    { 0, 0x65, 63, 233},
    { 0, 0x65, 141, 233},
    { 0, 0x65, 27, 234},
    { 0, 0x65, 73, 233},
    { 0, 0x46, 994, 202},
    { 0, 0x25, 445, 150},
    // 210: Local time: 10:58:00 AM
    { 0, 0x24, 51, 153},
    { 0, 0x24, 178, 152},
    { 0, 0x34, 261, 157},
    { 0, 0x24, 209, 161},
    { 0, 0x44, 912, 212},
    { 9, 0x54, 843, 231},
    { 0, 0x56, 2176, 236},
    { 0, 0x45, 2393, 208},
    { 7, 0x36, 1784, 194},
    { 0, 0x27, 576, 234},
    { 0, 0x55, 6607, 183},
    { 0, 0x6c, 7015, 237},
    { 0, 0x68, 7497, 190},
    { 0, 0x47, 5847, 225},
    { 9, 0x57, 1824, 199},
    // 225: Local time: 11:13:00 AM
    { 0, 0x45, 6912, 238},
    { 0, 0x26, 4936, 232},
    { 0, 0x28, 683, 237},
    { 65, 0x25, 1953, 203},
    { 40, 0x25, 1536, 232},
    { 95, 0x33, 7106, 188},
    { 22, 0x24, 3572, 195},
    { 0, 0x26, 3837, 200},
    { 0, 0x24, 3830, 194},
    { 15, 0x31, 6516, 171},
    { 21, 0x32, 7788, 194},
    { 0, 0x46, 6053, 182},
    { 0, 0x47, 2553, 194},
    { 0, 0x36, 585, 191},
    { 0, 0x57, 2689, 203},
    // 240: Local time: 11:28:00 AM
    { 0, 0x36, 3501, 180},
    { 8, 0x52, 1027, 209},
    { 0, 0x48, 803, 196},
    { 0, 0x44, 142, 191},
    { 0, 0x45, 240, 183},
    { 0, 0x55, 564, 196},
    { 0, 0x44, 2206, 195},
    { 0, 0x45, 1269, 195},
    { 0, 0x36, 2925, 188},
    { 0, 0x27, 1421, 183},
    { 0, 0x16, 227, 180},
    { 0, 0x36, 4429, 197},
    { 0, 0x45, 5098, 181},
    { 0, 0x35, 1354, 197},
    { 0, 0x44, 2421, 167},
    // 255: Local time: 11:44:00 AM
    { 0, 0x44, 3054, 196},
    { 8, 0x42, 1734, 184},
    { 0, 0x43, 1044, 174},
    { 0, 0x41, 0, 177},
    { 0, 0x44, 2047, 188},
    { 0, 0x53, 4702, 194},
    { 9, 0x33, 2317, 187},
    { 0, 0x43, 478, 186},
    { 0, 0x43, 72, 187},
    { 0, 0x43, 1, 184},
    { 0, 0x44, 1347, 201},
    { 0, 0x46, 955, 199},
    { 0, 0x35, 1331, 188},
    { 0, 0x45, 1708, 183},
    { 0, 0x36, 1729, 190},
    // 270: Local time: 11:59:00 AM
    { 0, 0x56, 4047, 188},
    { 9, 0x47, 3365, 209},
    { 0, 0x47, 2175, 201},
    { 0, 0x47, 2329, 204},
    { 0, 0x47, 2161, 184},
    { 0, 0x36, 1060, 188},
    { 0, 0x45, 1889, 186},
    { 0, 0x45, 2853, 190},
    { 0, 0x66, 1834, 191},
    { 9, 0x56, 1280, 193},
    { 0, 0x66, 4875, 193},
    { 8, 0x66, 1600, 189},
    { 9, 0x66, 3548, 196},
    { 0, 0x55, 2761, 191},
    { 0, 0x45, 2453, 193},
    // 285: Local time: 12:14:00 PM
    { 0, 0x34, 2767, 188},
    { 9, 0x44, 2457, 184},
    { 0, 0x51, 0, 182},
    { 0, 0x51, 53, 185},
    { 0, 0x42, 1565, 199},
    { 0, 0x52, 1693, 185},
    { 0, 0x52, 930, 183},
    { 8, 0x53, 2450, 193},
    { 0, 0x43, 407, 187},
    { 0, 0x43, 1670, 184},
    { 0, 0x55, 3047, 193},
    { 0, 0x34, 7127, 198},
    { 0, 0x47, 1784, 192},
    { 0, 0x57, 1194, 201},
    { 0, 0x58, 504, 207},
    // 300: Local time: 12:29:00 PM
    { 0, 0x48, 869, 197},
    { 0, 0x47, 1684, 195},
    { 0, 0x47, 986, 196},
    { 0, 0x48, 511, 192},
    { 0, 0x47, 992, 207},
    { 0, 0x46, 1805, 197},
    { 8, 0x57, 5212, 198},
    { 0, 0x57, 1827, 200},
    { 0, 0x48, 1152, 202},
    { 38, 0x54, 2971, 199},
    { 0, 0x6c, 2274, 202},
    { 8, 0x57, 1837, 202},
    { 0, 0x59, 1713, 201},
    { 0, 0x5a, 495, 190},
    { 0, 0x5a, 1610, 199},
    // 315: Local time: 12:44:00 PM
    { 0, 0x77, 1600, 196},
    { 0, 0x7a, 117, 198},
    { 0, 0x58, 745, 204},
    { 0, 0x35, 3739, 192},
    { 0, 0x46, 986, 191},
    { 0, 0x47, 2632, 186},
    { 0, 0x45, 2221, 208},
    { 0, 0x47, 1643, 189},
    { 0, 0x45, 905, 193},
    { 0, 0x48, 1894, 196},
    { 0, 0x36, 2890, 210},
    { 8, 0x24, 6453, 190},
    { 0, 0x35, 3100, 197},
    { 0, 0x37, 3276, 202},
    { 0, 0x47, 602, 203},
    // 330: Local time: 12:59:00 PM
    { 0, 0x16, 569, 181},
    { 0, 0x23, 2268, 186},
    { 0, 0x34, 4759, 167},
    { 20, 0x26, 1254, 182},
    { 0, 0x23, 3171, 176},
    { 0, 0x25, 2414, 189},
    { 22, 0x34, 2861, 215},
    { 10, 0x13, 2641, 233},
    { 22, 0x33, 2749, 239},
    { 25, 0x44, 4580, 198},
    { 7, 0x53, 3443, 195},
    { 22, 0x56, 2594, 197},
    { 0, 0x14, 800, 190},
    { 13, 0x23, 3606, 188},
    { 22, 0x35, 4243, 185},
    // 345: Local time: 01:14:00 PM
    { 26, 0x25, 3894, 188},
    { 24, 0x14, 5847, 198},
    { 0, 0x44, 9070, 190},
    { 0, 0x34, 4434, 189},
    { 19, 0x41, 3446, 145},
    { 46, 0x32, 2737, 193},
    { 45, 0x41, 3801, 187},
    { 13, 0x41, 8660, 151},
    { 32, 0x32, 7747, 144},
    { 10, 0x31, 5229, 141},
    { 11, 0x41, 2667, 144},
    { 0, 0x31, 2242, 144},
    { 22, 0x34, 5513, 190},
    { 0, 0x54, 9808, 198},
    { 12, 0x43, 5919, 184},
    // 360: Local time: 01:29:00 PM
    { 0, 0x33, 4998, 193},
    { 8, 0x24, 3307, 183},
    { 17, 0x41, 4584, 192},
    { 40, 0x42, 6308, 187},
    { 8, 0x34, 2732, 196},
    { 8, 0x52, 4315, 196},
    { 19, 0x52, 4425, 187},
    { 24, 0x32, 4508, 201},
    { 8, 0x51, 5346, 172},
    { 10, 0x26, 3154, 173},
    { 0, 0x49, 1892, 188},
    { 8, 0x26, 1495, 186},
    { 31, 0x12, 4525, 186},
    { 12, 0x32, 8774, 187},
    { 0, 0x56, 11090, 221},
    // 375: Local time: 01:44:00 PM
    { 8, 0x46, 11668, 183},
    { 0, 0x26, 8084, 169},
    { 0, 0x26, 4231, 187},
    { 0, 0x36, 4281, 202},
    { 0, 0x44, 6509, 144},
    { 7, 0x31, 1724, 185},
    { 12, 0x44, 4730, 177},
    { 7, 0x25, 5009, 196},
    { 0, 0x53, 11069, 189},
    { 0, 0x43, 6537, 185},
    { 11, 0x48, 1569, 201},
    { 11, 0x58, 982, 210},
    { 0, 0x58, 831, 198},
    { 0, 0x58, 1794, 229},
    { 9, 0x44, 9013, 175},
    // 390: Local time: 01:59:00 PM
    { 0, 0x35, 6249, 191},
    { 18, 0x41, 2300, 188},
    { 20, 0x43, 1541, 195},
    { 19, 0x34, 1700, 196},
    { 43, 0x31, 8141, 169},
    { 20, 0x22, 7227, 194},
    { 46, 0x32, 6432, 194},
    { 60, 0x32, 4193, 194},
    { 19, 0x31, 2551, 233},
    { 0, 0x24, 3457, 231},
    { 0, 0x33, 2767, 238},
    { 23, 0x31, 5470, 239},
    { 119, 0x34, 3470, 236},
    { 119, 0x34, 4338, 245},
    { 42, 0x62, 3895, 242},
    // 405: Local time: 02:14:00 PM
    { 0, 0x64, 3040, 238},
    { 0, 0x45, 2452, 236},
    { 13, 0x53, 6105, 237},
    { 61, 0x31, 5984, 244},
    { 48, 0x32, 7001, 234},
    { 0, 0x19, 1281, 237},
    { 24, 0x34, 6379, 228},
    { 12, 0x41, 6986, 233},
    { 0, 0x65, 6516, 207},
    { 0, 0x55, 4172, 209},
    { 0, 0x45, 1629, 212},
    { 0, 0x73, 2655, 216},
    { 16, 0x76, 3527, 237},
    { 35, 0x23, 6690, 207},
    { 41, 0x35, 3660, 238},
    // 420: Local time: 02:29:00 PM
    { 15, 0x37, 4138, 217},
    { 9, 0x56, 4553, 199},
    { 0, 0x74, 3016, 220},
    { 8, 0x66, 2856, 223},
    { 0, 0x65, 1326, 216},
    { 0, 0x71, 359, 230},
    { 0, 0x79, 808, 234},
    { 10, 0x7b, 289, 211},
    { 7, 0x7a, 1097, 229},
    { 9, 0x6b, 421, 226},
    { 0, 0x7c, 609, 243},
    { 0, 0x53, 560, 217},
    { 0, 0x76, 1808, 236},
    { 0, 0x77, 225, 239},
    { 0, 0x77, 266, 237},
    // 435: Local time: 02:44:00 PM
    { 0, 0x77, 147, 236},
    { 0, 0x77, 206, 237},
    { 0, 0x77, 39, 242},
    { 0, 0x77, 178, 242},
    { 0, 0x77, 77, 236},
    { 0, 0x79, 117, 224},
    { 0, 0x78, 2393, 237},
    { 15, 0x65, 3560, 179},
    { 0, 0x34, 2321, 197},
    { 0, 0x24, 1380, 192},
    { 0, 0x34, 68, 195},
    { 16, 0x34, 767, 225},
    { 0, 0x8a, 1786, 205},
    { 9, 0x5c, 579, 203},
    { 0, 0x3c, 216, 199},
    // 450: Local time: 02:59:00 PM
    { 11, 0x3c, 566, 198},
    { 0, 0x3c, 330, 196},
    { 0, 0x34, 1073, 218},
    { 0, 0x45, 132, 216},
    { 0, 0x45, 216, 215},
    { 0, 0x45, 268, 212},
    { 0, 0x45, 61, 214},
    { 0, 0x45, 127, 215},
    { 0, 0x45, 77, 206},
    { 0, 0x45, 60, 203},
    { 7, 0x45, 839, 229},
    { 9, 0x45, 1276, 200},
    { 0, 0x34, 215, 198},
    { 0, 0x34, 27, 165},
    { 0, 0x34, 141, 192},
    // 465: Local time: 03:14:00 PM
    { 0, 0x45, 1538, 199},
    { 0, 0x45, 604, 195},
    { 0, 0x55, 3990, 195},
    { 10, 0x55, 6232, 210},
    { 71, 0x36, 3352, 186},
    { 34, 0x24, 7621, 194},
    { 36, 0x54, 8340, 182},
    { 62, 0x22, 8012, 198},
    { 132, 0x41, 7927, 198},
    { 33, 0x42, 7222, 205},
    { 12, 0x33, 7034, 180},
    { 0, 0x31, 8068, 197},
    { 32, 0x44, 7714, 184},
    { 106, 0x34, 4465, 189},
    { 67, 0x33, 14365, 165},
    // 480: Local time: 03:30:00 PM
    { 30, 0x31, 10486, 191},
    { 0, 0x52, 5429, 184},
    { 0, 0x52, 7220, 176},
    { 0, 0x51, 7561, 189},
    { 0, 0x45, 2589, 191},
    { 0, 0x45, 1273, 202},
    { 0, 0x46, 6026, 191},
    { 0, 0x45, 719, 184},
    { 0, 0x45, 1393, 190},
    { 0, 0x66, 624, 188},
    { 0, 0x65, 10, 170},
    { 0, 0x56, 1579, 193},
    { 0, 0x35, 430, 180},
    { 0, 0x24, 22, 180},
    { 0, 0x45, 702, 189},
    // 495: Local time: 03:45:00 PM
    { 0, 0x46, 1337, 193},
    { 0, 0x46, 185, 209},
    { 0, 0x46, 817, 211},
    { 0, 0x46, 17, 210},
    { 0, 0x46, 0, 205},
    { 0, 0x46, 70, 214},
    { 0, 0x46, 77, 194},
    { 0, 0x46, 2102, 208},
    { 0, 0x57, 139, 192},
    { 0, 0x66, 963, 187},
    { 0, 0x45, 585, 184},
    { 0, 0x44, 1763, 200},
    { 0, 0x45, 3295, 184},
    { 0, 0x37, 671, 188},
    { 0, 0x46, 604, 184},
    // 510: Local time: 04:00:00 PM
    { 0, 0x27, 208, 179},
    { 0, 0x47, 425, 193},
    { 0, 0x56, 1615, 191},
    { 0, 0x46, 779, 197},
    { 0, 0x46, 739, 193},
    { 0, 0x56, 1894, 196},
    { 0, 0x56, 617, 206},
    { 0, 0x57, 2479, 197},
    { 0, 0x56, 504, 198},
    { 0, 0x46, 2446, 172},
    { 0, 0x56, 2947, 194},
    { 0, 0x67, 1414, 193},
    { 0, 0x67, 1256, 198},
    { 0, 0x68, 1121, 193},
    { 0, 0x77, 328, 189},
    // 525: Local time: 04:15:00 PM
    { 0, 0x74, 58, 192},
    { 0, 0x74, 0, 194},
    { 0, 0x67, 247, 190},
    { 0, 0x67, 316, 189},
    { 0, 0x67, 591, 186},
    { 0, 0x68, 1, 191},
    { 0, 0x67, 999, 189},
    { 8, 0x67, 1774, 188},
    { 0, 0x55, 3802, 188},
    { 0, 0x55, 2784, 177},
    { 0, 0x32, 8338, 148},
    { 51, 0x35, 6487, 145},
    { 16, 0x34, 3007, 145},
    { 0, 0x46, 5334, 131},
    { 0, 0x34, 5183, 144},
    // 540: Local time: 04:30:00 PM
    { 0, 0x44, 7552, 146},
    { 15, 0x25, 7951, 154},
    { 26, 0x36, 9660, 146},
    { 0, 0x36, 1476, 147},
    { 0, 0x36, 3460, 147},
    { 0, 0x43, 856, 146},
    { 0, 0x32, 2976, 146},
    { 0, 0x37, 1440, 147},
    { 0, 0x45, 604, 146},
    { 0, 0x44, 63, 143},
    { 0, 0x44, 25, 147},
    { 0, 0x25, 597, 146},
    { 0, 0x31, 2166, 146},
    { 0, 0x36, 2674, 147},
    { 0, 0x28, 263, 144},
    // 555: Local time: 04:46:00 PM
    { 0, 0x28, 925, 147},
    { 0, 0x27, 683, 147},
    { 0, 0x15, 3687, 158},
    { 0, 0x16, 221, 158},
    { 0, 0x17, 416, 158},
    { 0, 0x17, 1178, 173},
    { 0, 0x17, 1164, 162},
    { 0, 0x16, 297, 167},
    { 0, 0x26, 4575, 175},
    { 19, 0x45, 8657, 187},
    { 0, 0x36, 3255, 172},
    { 0, 0x35, 6201, 173},
    { 0, 0x37, 5349, 178},
    { 0, 0x36, 591, 177},
    { 0, 0x37, 779, 179},
    // 570: Local time: 05:01:00 PM
    { 0, 0x48, 25, 181},
    { 0, 0x38, 168, 187},
    { 0, 0x37, 376, 182},
    { 0, 0x37, 154, 184},
    { 0, 0x48, 820, 178},
    { 0, 0x48, 108, 187},
    { 0, 0x48, 0, 184},
    { 0, 0x47, 1564, 184},
    { 0, 0x48, 218, 192},
    { 0, 0x48, 0, 190},
    { 0, 0x48, 0, 178},
    { 0, 0x48, 0, 178},
    { 0, 0x47, 1345, 184},
    { 0, 0x48, 461, 178},
    { 0, 0x48, 268, 175},
    // 585: Local time: 05:16:00 PM
    { 0, 0x48, 249, 178},
    { 0, 0x47, 32, 178},
    { 0, 0x47, 130, 180},
    { 0, 0x47, 1106, 179},
    { 0, 0x65, 0, 176},
    { 0, 0x55, 254, 185},
    { 0, 0x66, 4560, 180},
    { 0, 0x74, 898, 181},
    { 0, 0x74, 1164, 182},
    { 13, 0x65, 2476, 176},
    { 0, 0x66, 84, 179},
    { 8, 0x66, 252, 179},
    { 0, 0x66, 5, 180},
    { 0, 0x66, 8, 191},
    { 0, 0x57, 2154, 175},
    // 600: Local time: 05:31:00 PM
    { 0, 0x65, 32, 177},
    { 0, 0x65, 321, 177},
    { 0, 0x65, 456, 176},
    { 0, 0x65, 0, 176},
    { 0, 0x65, 0, 173},
    { 0, 0x65, 5, 183},
    { 0, 0x65, 1, 182},
    { 0, 0x65, 1097, 182},
    { 0, 0x65, 166, 182},
    { 0, 0x65, 1942, 193},
    { 0, 0x65, 1008, 183},
    { 0, 0x67, 1278, 181},
    { 0, 0x65, 1, 181},
    { 0, 0x65, 5, 180},
    { 0, 0x65, 0, 183},
    // 615: Local time: 05:46:00 PM
    { 0, 0x65, 2584, 169},
    { 0, 0x65, 573, 171},
    { 0, 0x65, 872, 171},
    { 0, 0x64, 22, 171},
    { 0, 0x65, 0, 169},
    { 0, 0x65, 0, 171},
    { 0, 0x65, 13, 158},
    { 8, 0x46, 6401, 161},
    { 0, 0x47, 2713, 152},
    { 0, 0x38, 920, 156},
    { 0, 0x38, 357, 157},
    { 0, 0x48, 58, 157},
    { 0, 0x48, 633, 157},
    { 0, 0x26, 856, 149},
    { 0, 0x26, 196, 146},
    // 630: Local time: 06:01:00 PM
    { 0, 0x26, 404, 151},
    { 0, 0x17, 153, 146},
    { 0, 0x19, 0, 146},
    { 0, 0x19, 20, 152},
    { 0, 0x37, 2643, 159},
    { 0, 0x38, 762, 153},
    { 0, 0x48, 29, 155},
    { 0, 0x48, 10, 149},
    { 0, 0x48, 63, 152},
    { 0, 0x48, 37, 151},
    { 0, 0x37, 1295, 152},
    { 0, 0x48, 803, 147},
    { 0, 0x27, 700, 146},
    { 0, 0x25, 1214, 146},
    { 0, 0x55, 5709, 145},
    // 645: Local time: 06:16:00 PM
    { 0, 0x47, 841, 146},
    { 0, 0x48, 366, 146},
    { 0, 0x58, 123, 146},
    { 0, 0x47, 640, 146},
    { 0, 0x58, 425, 144},
    { 0, 0x25, 1242, 146},
    { 0, 0x58, 382, 146},
    { 0, 0x58, 36, 146},
    { 0, 0x57, 1195, 146},
    { 0, 0x66, 1034, 144},
    { 0, 0x76, 39, 146},
    { 0, 0x65, 1010, 146},
    { 8, 0x35, 5059, 146},
    { 0, 0x34, 5522, 146},
    { 0, 0x37, 690, 144},
    // 660: Local time: 06:31:00 PM
    { 0, 0x36, 5358, 146},
    { 0, 0x27, 836, 146},
    { 0, 0x42, 511, 146},
    { 0, 0x42, 166, 146},
    { 0, 0x42, 552, 144},
    { 0, 0x27, 61, 146},
    { 0, 0x27, 607, 146},
    { 0, 0x24, 178, 146},
    { 38, 0x35, 2219, 146},
    { 119, 0x22, 6088, 144},
    { 98, 0x31, 8280, 146},
    { 70, 0x41, 9039, 160},
    { 24, 0x33, 9149, 146},
    { 120, 0x26, 5098, 145},
    { 132, 0x32, 4551, 143},
    // 675: Local time: 06:46:00 PM
    { 54, 0x24, 5523, 146},
    { 0, 0x36, 3212, 146},
    { 0, 0x47, 6220, 162},
    { 13, 0x47, 3119, 159},
    { 0, 0x38, 3677, 155},
    { 0, 0x58, 2307, 154},
    { 0, 0x59, 4250, 153},
    { 0, 0x49, 1581, 150},
    { 0, 0x49, 736, 149},
    { 0, 0x49, 1392, 150},
    { 0, 0x49, 1158, 151},
    { 0, 0x49, 1233, 161},
    { 0, 0x49, 536, 164},
    { 0, 0x59, 1364, 149},
    { 15, 0x59, 1856, 144},
    // 690: Local time: 07:01:00 PM
    { 32, 0x69, 1622, 158},
    { 0, 0x48, 1786, 155},
    { 0, 0x57, 5033, 147},
    { 56, 0x42, 5692, 146},
    { 119, 0x40, 6225, 142},
    { 74, 0x41, 4778, 144},
    { 26, 0x43, 3367, 145},
    { 18, 0x35, 4737, 147},
    { 12, 0x44, 1183, 146},
    { 0, 0x55, 696, 144},
    { 9, 0x77, 3112, 145},
    { 0, 0x55, 2588, 146},
    { 0, 0x66, 397, 146},
    { 0, 0x47, 708, 145},
    { 0, 0x47, 1230, 144},
    // 705: Local time: 07:16:00 PM
    { 0, 0x47, 1452, 146},
    { 12, 0x57, 1679, 146},
    { 8, 0x44, 8891, 187},
    { 0, 0x64, 223, 196},
    { 0, 0x65, 91, 186},
    { 21, 0x45, 2741, 185},
    { 0, 0x53, 4131, 185},
    { 0, 0x13, 2479, 184},
    { 0, 0x22, 4393, 188},
    { 0, 0x34, 2990, 176},
    { 0, 0x13, 2557, 177},
    { 0, 0x13, 665, 180},
    { 18, 0x34, 4388, 192},
    { 0, 0x54, 628, 194},
    { 0, 0x54, 1491, 184},
    // 720: Local time: 07:31:00 PM
    { 0, 0x34, 519, 187},
    { 9, 0x44, 3214, 178},
    { 0, 0x44, 6201, 186},
    { 0, 0x35, 989, 183},
    { 12, 0x34, 3054, 191},
    { 0, 0x51, 1163, 182},
    { 0, 0x33, 3957, 181},
    { 0, 0x56, 1111, 183},
    { 0, 0x55, 1927, 195},
    { 16, 0x34, 2639, 180},
    { 0, 0x33, 3935, 182},
    { 0, 0x34, 4725, 182},
    { 0, 0x36, 6064, 183},
    { 8, 0x48, 1834, 182},
    { 0, 0x47, 2273, 182},
    // 735: Local time: 07:46:00 PM
    { 0, 0x35, 3240, 180},
    { 0, 0x36, 3381, 187},
    { 0, 0x46, 3966, 185},
    { 0, 0x47, 2976, 182},
    { 0, 0x47, 2047, 184},
    { 0, 0x47, 1233, 182},
    { 0, 0x37, 1417, 184},
    { 0, 0x47, 1970, 182},
    { 0, 0x37, 1517, 182},
    { 0, 0x47, 930, 176},
    { 0, 0x47, 425, 178},
    { 0, 0x36, 2639, 184},
    { 0, 0x36, 4320, 186},
    { 0, 0x47, 2254, 186},
    { 0, 0x58, 610, 178},
    // 750: Local time: 08:01:00 PM
    { 0, 0x47, 1485, 180},
    { 0, 0x48, 313, 189},
    { 0, 0x47, 2268, 184},
    { 8, 0x36, 3233, 186},
    { 0, 0x36, 2681, 187},
    { 0, 0x35, 2718, 182},
    { 0, 0x47, 1638, 183},
    { 0, 0x47, 2262, 186},
    { 11, 0x47, 1509, 180},
    { 0, 0x36, 2042, 177},
    { 9, 0x28, 2651, 180},
    { 17, 0x20, 4059, 188},
    { 0, 0x37, 3627, 181},
    { 0, 0x4b, 1118, 191},
    { 12, 0x7d, 3446, 193},
    // 765: Local time: 08:16:00 PM
    { 0, 0x52, 628, 190},
    { 0, 0x41, 1524, 186},
    { 0, 0x8c, 877, 202},
    { 0, 0x8b, 0, 202},
    { 0, 0x8b, 0, 201},
    { 0, 0x8b, 0, 202},
    { 0, 0x8b, 0, 202},
    { 0, 0x8b, 0, 202},
    { 0, 0x8b, 0, 203},
    { 0, 0x8a, 0, 200},
    { 0, 0x8a, 0, 203},
    { 0, 0x8a, 0, 201},
    { 0, 0x8a, 0, 203},
    { 0, 0x7d, 598, 185},
    { 0, 0x7f, 104, 197},
    // 780: Local time: 08:31:00 PM
    { 0, 0x7f, 2522, 201},
    { 0, 0x85, 130, 199},
    { 0, 0x75, 25, 197},
    { 0, 0x74, 0, 197},
    { 0, 0x74, 0, 195},
    { 0, 0x74, 0, 197},
    { 0, 0x75, 49, 202},
    { 0, 0x8b, 0, 195},
    { 0, 0x7d, 1522, 203},
    { 0, 0x7d, 0, 200},
    { 0, 0x7d, 0, 203},
    { 0, 0x7d, 0, 203},
    { 0, 0x7d, 0, 203},
    { 0, 0x7d, 0, 203},
    { 0, 0x7d, 0, 201},
    // 795: Local time: 08:46:00 PM
    { 0, 0x7d, 0, 202},
    { 0, 0x7d, 0, 203},
    { 0, 0x7d, 0, 203},
    { 0, 0x7d, 0, 203},
    { 0, 0x7d, 0, 200},
    { 0, 0x7d, 0, 202},
    { 0, 0x7d, 0, 202},
    { 0, 0x7d, 0, 202},
    { 0, 0x7d, 0, 202},
    { 0, 0x7d, 0, 200},
    { 0, 0x1b, 3907, 169},
    { 0, 0x0, 0, 170},
    { 0, 0x0, 0, 170},
    { 0, 0x0, 0, 171},
    { 0, 0x0, 0, 177},
    // 810: Local time: 09:01:00 PM
    { 0, 0x0, 0, 170},
    { 0, 0x0, 65, 176},
    { 0, 0x0, 0, 177},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 175},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 176},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 177},
    { 0, 0x0, 0, 175},
    // 825: Local time: 09:16:00 PM
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 177},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 175},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 175},
    { 0, 0x0, 0, 177},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 175},
    // 840: Local time: 09:31:00 PM
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 177},
    { 0, 0x0, 0, 177},
    { 0, 0x0, 0, 174},
    { 0, 0x0, 0, 177},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 175},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 175},
    // 855: Local time: 09:46:00 PM
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 175},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 175},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 175},
    // 870: Local time: 10:01:00 PM
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 175},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 178},
    { 0, 0x0, 0, 175},
    { 0, 0x8, 72, 198},
    { 0, 0x8, 2157, 156},
    { 0, 0x8, 0, 163},
    { 0, 0x8, 0, 155},
    { 0, 0x8, 0, 156},
    // 885: Local time: 10:16:00 PM
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 155},
    { 0, 0x8, 0, 154},
    { 0, 0x8, 0, 155},
    { 0, 0x8, 0, 154},
    { 0, 0x8, 0, 155},
    { 0, 0x8, 0, 155},
    { 0, 0x8, 0, 154},
    { 0, 0x8, 0, 156},
    { 0, 0x8, 0, 155},
    { 0, 0x8, 0, 156},
    { 0, 0x8, 0, 154},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 155},
    // 900: Local time: 10:32:00 PM
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 155},
    { 0, 0x8, 0, 163},
    { 0, 0x8, 0, 156},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 155},
    { 0, 0x8, 0, 155},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 156},
    { 0, 0x8, 0, 155},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    // 915: Local time: 10:47:00 PM
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    { 0, 0x8, 0, 162},
    { 0, 0x2b, 2429, 167},
    { 0, 0x7c, 2531, 192},
    { 0, 0x7e, 0, 196},
    { 0, 0x7e, 0, 196},
    { 0, 0x7e, 0, 197},
    { 0, 0x7e, 0, 196},
    { 0, 0x7e, 0, 194},
    // 930: Local time: 11:02:00 PM
    { 0, 0x7e, 0, 197},
    { 0, 0x7e, 0, 197},
    { 0, 0x7e, 0, 196},
    { 0, 0x7e, 0, 197},
    { 0, 0x7e, 0, 198},
    { 0, 0x7e, 0, 197},
    { 0, 0x7e, 3, 197},
    { 0, 0x7d, 0, 197},
    { 0, 0x7d, 0, 197},
    { 0, 0x7d, 0, 195},
    { 0, 0x7c, 1089, 195},
    { 0, 0x4c, 223, 195},
    { 8, 0x5b, 2102, 175},
    { 0, 0x59, 2798, 171},
    { 0, 0x59, 726, 167},
    // 945: Local time: 11:17:00 PM
    { 0, 0x58, 722, 171},
    { 0, 0x49, 22, 170},
    { 0, 0x49, 774, 146},
    { 0, 0x3a, 1245, 160},
    { 0, 0x35, 979, 169},
    { 0, 0x5a, 1373, 166},
    { 0, 0x5a, 1371, 167},
    { 0, 0x5a, 368, 167},
    { 0, 0x49, 135, 168},
    { 0, 0x5a, 117, 164},
    { 0, 0x59, 2767, 169},
    { 0, 0x5a, 4073, 168},
    { 0, 0x69, 1168, 147},
    { 0, 0x68, 359, 182},
    { 0, 0x61, 15, 180},
    // 960: Local time: 11:32:00 PM
    { 0, 0x62, 4520, 172},
    { 0, 0x53, 1765, 168},
    { 0, 0x51, 1500, 168},
    { 0, 0x52, 1407, 173},
    { 0, 0x45, 2853, 166},
    { 0, 0x52, 189, 165},
    { 0, 0x52, 6, 164},
    { 0, 0x62, 239, 174},
    { 0, 0x61, 0, 174},
    { 0, 0x61, 22, 171},
    { 0, 0x27, 810, 162},
    { 0, 0x29, 29, 158},
    { 0, 0x38, 1245, 165},
    { 0, 0x48, 755, 162},
    { 0, 0x37, 0, 160},
    // 975: Local time: 11:47:00 PM
    { 0, 0x37, 0, 162},
    { 0, 0x37, 0, 162},
    { 0, 0x37, 0, 162},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 6, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 1, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 161},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 161},
    // 990: 10/26/15 Local time: 12:02:00 AM
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 155},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x46, 0, 163},
    { 0, 0x36, 43, 160},
    { 0, 0x36, 70, 162},
    { 0, 0x36, 3219, 148},
    { 15, 0x35, 8457, 188},
    { 35, 0x36, 9763, 146},
    { 0, 0x36, 1911, 143},
    // 1005: Local time: 12:17:00 AM
    { 0, 0x36, 0, 146},
    { 0, 0x36, 0, 147},
    { 0, 0x36, 0, 147},
    { 0, 0x36, 0, 147},
    { 0, 0x36, 0, 147},
    { 0, 0x36, 0, 148},
    { 0, 0x36, 0, 148},
    { 0, 0x36, 0, 148},
    { 0, 0x36, 0, 148},
    { 0, 0x36, 0, 146},
    { 0, 0x36, 0, 148},
    { 0, 0x36, 0, 149},
    { 0, 0x36, 0, 149},
    { 0, 0x36, 0, 149},
    { 0, 0x36, 0, 147},
    // 1020: Local time: 12:32:00 AM
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 149},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 149},
    { 0, 0x36, 0, 147},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 147},
    // 1035: Local time: 12:47:00 AM
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 148},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 148},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 148},
    // 1050: Local time: 01:02:00 AM
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 148},
    { 0, 0x36, 0, 151},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 150},
    { 0, 0x36, 0, 148},
    { 0, 0x36, 0, 150},
    { 0, 0x47, 1146, 149},
    { 0, 0x7a, 0, 149},
    { 0, 0x7a, 0, 149},
    { 0, 0x7a, 660, 147},
    // 1065: Local time: 01:17:00 AM
    { 0, 0x34, 464, 149},
    { 0, 0x34, 0, 148},
    { 0, 0x34, 0, 148},
    { 0, 0x34, 0, 148},
    { 0, 0x34, 0, 148},
    { 0, 0x34, 0, 147},
    { 0, 0x34, 0, 147},
    { 0, 0x34, 0, 147},
    { 0, 0x34, 0, 147},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 146},
    { 0, 0x34, 0, 147},
    { 0, 0x34, 0, 145},
    { 0, 0x34, 0, 146},
    { 0, 0x34, 0, 143},
    // 1080: Local time: 01:32:00 AM
    { 0, 0x34, 0, 147},
    { 0, 0x34, 0, 146},
    { 0, 0x34, 0, 145},
    { 0, 0x55, 724, 146},
    { 0, 0x55, 800, 129},
    { 0, 0x65, 552, 146},
    { 0, 0x65, 0, 147},
    { 0, 0x65, 0, 146},
    { 0, 0x65, 0, 146},
    { 0, 0x65, 0, 143},
    { 0, 0x65, 0, 146},
    { 0, 0x65, 0, 146},
    { 0, 0x65, 0, 146},
    { 0, 0x65, 0, 146},
    { 0, 0x65, 0, 143},
    // 1095: Local time: 01:47:00 AM
    { 0, 0x65, 0, 147},
    { 0, 0x65, 0, 146},
    { 0, 0x65, 0, 146},
    { 0, 0x65, 0, 146},
    { 0, 0x65, 0, 137},
    { 0, 0x65, 0, 146},
    { 0, 0x65, 0, 146},
    { 0, 0x65, 571, 147},
    { 0, 0x56, 2507, 146},
    { 0, 0x45, 0, 143},
    { 0, 0x56, 178, 146},
    { 0, 0x42, 1368, 146},
    { 0, 0x22, 0, 145},
    { 0, 0x22, 0, 145},
    { 0, 0x22, 0, 142},
    // 1110: Local time: 02:02:00 AM
    { 0, 0x22, 0, 145},
    { 0, 0x22, 0, 145},
    { 0, 0x22, 0, 145},
    { 0, 0x22, 0, 145},
    { 0, 0x22, 0, 139},
    { 0, 0x22, 0, 145},
    { 0, 0x22, 0, 145},
    { 0, 0x22, 0, 145},
    { 0, 0x22, 0, 145},
    { 0, 0x22, 0, 142},
    { 0, 0x22, 0, 145},
    { 0, 0x32, 3, 145},
    { 0, 0x32, 0, 145},
    { 0, 0x32, 0, 145},
    { 0, 0x32, 0, 142},
    // 1125: Local time: 02:17:00 AM
    { 0, 0x32, 0, 145},
    { 0, 0x32, 94, 145},
    { 8, 0x75, 1660, 146},
    { 0, 0x74, 980, 146},
    { 0, 0x75, 0, 138},
    { 0, 0x74, 0, 146},
    { 0, 0x74, 0, 146},
    { 0, 0x7, 1397, 146},
    { 8, 0x3c, 3469, 146},
    { 0, 0x81, 1903, 143},
    { 0, 0x6f, 1120, 146},
    { 0, 0x5f, 0, 146},
    { 0, 0x6f, 0, 146},
    { 0, 0x6f, 0, 146},
    { 0, 0x6f, 0, 143},
    // 1140: Local time: 02:32:00 AM
    { 0, 0x6f, 0, 146},
    { 0, 0x6f, 0, 146},
    { 0, 0x6f, 0, 146},
    { 0, 0x6f, 0, 146},
    { 0, 0x6f, 0, 142},
    { 0, 0x60, 0, 146},
    { 0, 0x60, 0, 146},
    { 0, 0x60, 0, 146},
    { 0, 0x50, 397, 145},
    { 0, 0x44, 0, 142},
    { 0, 0x44, 0, 145},
    { 0, 0x44, 3352, 145},
    { 0, 0x55, 0, 145},
    { 0, 0x55, 0, 146},
    { 0, 0x55, 0, 144},
    // 1155: Local time: 02:47:00 AM
    { 0, 0x55, 0, 146},
    { 0, 0x55, 0, 147},
    { 0, 0x55, 0, 147},
    { 0, 0x55, 0, 147},
    { 0, 0x55, 0, 141},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 147},
    { 0, 0x55, 0, 147},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 145},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 145},
    // 1170: Local time: 03:02:00 AM
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 140},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 149},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 145},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 148},
    { 0, 0x55, 0, 149},
    { 0, 0x55, 0, 149},
    { 0, 0x55, 0, 147},
    // 1185: Local time: 03:17:00 AM
    { 0, 0x55, 0, 149},
    { 0, 0x55, 0, 149},
    { 0, 0x55, 0, 149},
    { 0, 0x55, 0, 149},
    { 0, 0x55, 0, 147},
    { 0, 0x55, 0, 149},
    { 0, 0x55, 0, 149},
    { 0, 0x55, 0, 149},
    { 0, 0x55, 0, 149},
    { 0, 0x55, 27, 160},
    { 0, 0x65, 1694, 148},
    { 0, 0x66, 0, 147},
    { 0, 0x66, 0, 147},
    { 0, 0x66, 0, 147},
    { 0, 0x66, 0, 144},
    // 1200: Local time: 03:32:00 AM
    { 0, 0x66, 3, 146},
    { 0, 0x66, 0, 146},
    { 0, 0x66, 0, 147},
    { 0, 0x56, 84, 146},
    { 0, 0x56, 0, 147},
    { 0, 0x56, 0, 146},
    { 0, 0x56, 0, 146},
    { 0, 0x56, 61, 146},
    { 0, 0x56, 0, 146},
    { 0, 0x56, 645, 143},
    { 0, 0x74, 684, 145},
    { 0, 0x75, 0, 146},
    { 0, 0x75, 0, 146},
    { 0, 0x75, 0, 146},
    { 0, 0x76, 314, 142},
    // 1215: Local time: 03:47:00 AM
    { 0, 0x68, 22, 146},
    { 0, 0x69, 2058, 145},
    { 0, 0x69, 1, 146},
    { 0, 0x69, 0, 145},
    { 0, 0x69, 5, 140},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 143},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 142},
    // 1230: Local time: 04:02:00 AM
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 139},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 142},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 142},
    // 1245: Local time: 04:17:00 AM
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 48, 144},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 143},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 143},
    // 1260: Local time: 04:32:00 AM
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 0, 146},
    { 0, 0x68, 103, 146},
    { 0, 0x1c, 1383, 146},
    { 0, 0x1b, 0, 146},
    { 0, 0x1b, 0, 147},
    { 0, 0x9, 192, 146},
    { 0, 0x9, 0, 146},
    { 0, 0x9, 0, 143},
    { 0, 0x9, 0, 146},
    { 0, 0x9, 0, 146},
    { 0, 0x9, 0, 147},
    { 0, 0x9, 0, 147},
    { 0, 0x9, 0, 144},
    // 1275: Local time: 04:47:00 AM
    { 0, 0x9, 0, 146},
    { 0, 0x2d, 1084, 148},
    { 0, 0x2e, 0, 148},
    { 0, 0x5c, 643, 148},
    { 0, 0x6a, 0, 142},
    { 0, 0x6a, 0, 147},
    { 0, 0x6a, 0, 147},
    { 0, 0x6a, 0, 147},
    { 0, 0x6a, 0, 147},
    { 0, 0x6a, 1335, 142},
    { 0, 0x6b, 0, 145},
    { 0, 0x6b, 0, 146},
    { 0, 0x6b, 0, 143},
    { 0, 0x6b, 165, 140},
    { 0, 0x5b, 1, 139},
    // 1290: Local time: 05:02:00 AM
    { 0, 0x5b, 0, 140},
    { 0, 0x5b, 0, 146},
    { 0, 0x5b, 0, 146},
    { 0, 0x31, 1287, 145},
    { 0, 0x32, 0, 138},
    { 0, 0x32, 0, 145},
    { 0, 0x32, 0, 145},
    { 0, 0x32, 609, 145},
    { 0, 0x42, 0, 145},
    { 0, 0x51, 156, 142},
    { 0, 0x61, 0, 145},
    { 0, 0x61, 0, 145},
    { 0, 0x61, 0, 145},
    { 0, 0x60, 3, 145},
    { 0, 0x6f, 335, 142},
    // 1305: Local time: 05:17:00 AM
    { 0, 0x6c, 714, 145},
    { 0, 0x6a, 0, 145},
    { 0, 0x6a, 0, 145},
    { 0, 0x6a, 0, 145},
    { 0, 0x7a, 745, 140},
    { 0, 0x7a, 0, 145},
    { 0, 0x7a, 0, 145},
    { 0, 0x7a, 0, 145},
    { 0, 0x78, 1786, 145},
    { 0, 0x77, 0, 143},
    { 0, 0x77, 1, 145},
    { 0, 0x77, 0, 146},
    { 0, 0x77, 0, 146},
    { 0, 0x77, 0, 146},
    { 0, 0x77, 0, 143},
    // 1320: Local time: 05:32:00 AM
    { 0, 0x77, 0, 147},
    { 0, 0x77, 0, 147},
    { 0, 0x77, 0, 147},
    { 0, 0x77, 0, 147},
    { 0, 0x77, 0, 147},
    { 0, 0x6b, 466, 147},
    { 0, 0x5c, 0, 148},
    { 0, 0x5c, 0, 148},
    { 0, 0x5c, 0, 149},
    { 0, 0x4c, 0, 145},
    { 0, 0x4c, 0, 148},
    { 0, 0x4c, 0, 148},
    { 0, 0x4c, 0, 159},
    { 0, 0x4c, 18, 143},
    { 0, 0x4c, 0, 142},
    // 1335: Local time: 05:47:00 AM
    { 0, 0x4c, 0, 144},
    { 0, 0x4c, 0, 149},
    { 0, 0x4c, 0, 149},
    { 0, 0x3b, 1552, 148},
    { 0, 0x3b, 0, 142},
    { 0, 0x3b, 0, 148},
    { 0, 0x3b, 0, 148},
    { 0, 0x3b, 0, 148},
    { 0, 0x3b, 0, 148},
    { 0, 0x3b, 0, 145},
    { 0, 0x3b, 0, 148},
    { 0, 0x3b, 0, 148},
    { 0, 0x3b, 0, 148},
    { 0, 0x3b, 1056, 148},
    { 0, 0x1b, 0, 144},
    // 1350: Local time: 06:02:00 AM
    { 0, 0x1b, 0, 147},
    { 0, 0x1b, 0, 147},
    { 0, 0x1b, 0, 147},
    { 0, 0x1b, 0, 146},
    { 0, 0x1b, 0, 148},
    { 0, 0x1b, 0, 147},
    { 0, 0x1b, 0, 146},
    { 0, 0xb, 1073, 146},
    { 0, 0x73, 0, 147},
    { 0, 0x73, 0, 144},
    { 0, 0x73, 0, 148},
    { 0, 0x73, 0, 148},
    { 0, 0x73, 0, 148},
    { 0, 0x73, 0, 148},
    { 0, 0x73, 0, 145},
    // 1365: Local time: 06:17:00 AM
    { 0, 0x73, 0, 148},
    { 0, 0x73, 0, 149},
    { 0, 0x73, 0, 148},
    { 0, 0x73, 0, 149},
    { 0, 0x73, 0, 144},
    { 0, 0x83, 263, 149},
    { 0, 0x8f, 0, 149},
    { 0, 0x8f, 0, 149},
    { 0, 0x8f, 0, 149},
    { 0, 0x8f, 0, 146},
    { 0, 0x8f, 0, 149},
    { 0, 0x8f, 0, 149},
    { 0, 0x8f, 0, 149},
    { 15, 0x75, 512, 148},
    { 0, 0x75, 0, 145},
    // 1380: Local time: 06:32:00 AM
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 138},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 144},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 144},
    // 1395: Local time: 06:47:00 AM
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 147},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 148},
    { 0, 0x75, 0, 142},
    { 0, 0x73, 805, 147},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 147},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 145},
    { 0, 0x72, 0, 149},
    { 0, 0x72, 0, 149},
    { 0, 0x72, 0, 149},
    { 0, 0x73, 316, 149},
    { 0, 0x73, 0, 146},
    // 1410: Local time: 07:02:00 AM
    { 0, 0x73, 0, 150},
    { 0, 0x7a, 1669, 148},
    { 0, 0x7a, 0, 149},
    { 0, 0x7a, 0, 149},
    { 0, 0x7a, 5, 149},
    { 0, 0x7a, 132, 148},
    { 0, 0x78, 6, 148},
    { 0, 0x77, 0, 147},
    { 0, 0x7a, 175, 148},
    { 0, 0x7a, 0, 144},
    { 0, 0x7a, 0, 147},
    { 0, 0x7a, 0, 147},
    { 0, 0x7a, 22, 148},
    { 0, 0x7a, 0, 147},
    { 0, 0x89, 0, 145},
    // 1425: Local time: 07:18:00 AM
    { 0, 0x88, 0, 148},
    { 0, 0x88, 0, 148},
    { 0, 0x88, 0, 148},
    { 0, 0x87, 0, 148},
    { 0, 0x87, 0, 143},
    { 0, 0x87, 0, 149},
    { 0, 0x87, 0, 149},
    { 0, 0x87, 0, 149},
    { 0, 0x87, 0, 149},
    { 0, 0x87, 0, 146},
    { 0, 0x79, 530, 163},
    { 0, 0x3b, 2496, 147},
    { 0, 0x7b, 1216, 160},
    { 0, 0x8b, 0, 161},
    { 0, 0x8b, 0, 159},
    // 1440: Local time: 07:33:00 AM
    { 0, 0x8b, 0, 161},
    { 0, 0x8b, 0, 170},
    { 0, 0x8b, 0, 170},
    { 0, 0x8b, 0, 170},
    { 0, 0x8b, 0, 198},
    { 0, 0x8b, 0, 197},
    { 0, 0x8b, 0, 196},
    { 0, 0x8b, 0, 197},
    { 0, 0x8b, 0, 197},
    { 0, 0x8b, 0, 194},
    { 0, 0x8b, 0, 195},
    { 0, 0x89, 5, 196},
    { 0, 0x89, 0, 196},
    { 0, 0x79, 0, 197},
    { 0, 0x79, 0, 195},
    // 1455: Local time: 07:48:00 AM
    { 0, 0x79, 0, 197},
    { 0, 0x79, 0, 197},
    { 0, 0x79, 0, 197},
    { 0, 0x79, 0, 197},
    { 0, 0x79, 0, 198},
    { 0, 0x79, 0, 197},
    { 0, 0x79, 0, 197},
    { 0, 0x79, 0, 198},
    { 0, 0x79, 0, 197},
    { 0, 0x79, 0, 194},
    { 0, 0x79, 0, 198},
    { 0, 0x53, 5284, 195},
    { 8, 0x46, 6676, 192},
    { 0, 0x43, 7303, 158},
    { 22, 0x41, 3570, 170},
    // 1470: Local time: 08:03:00 AM
    { 46, 0x41, 3329, 172},
    { 49, 0x7f, 5291, 185},
    { 55, 0x31, 3823, 207},
    { 104, 0x40, 5134, 206},
    { 132, 0x40, 3950, 223},
    { 128, 0x40, 5114, 210},
    { 131, 0x40, 4436, 195},
    { 120, 0x40, 5356, 204},
    { 120, 0x40, 6189, 213},
    { 126, 0x40, 3498, 214},
    { 81, 0x40, 3584, 190},
    { 0, 0x40, 960, 187},
    { 8, 0x22, 1655, 186},
    { 0, 0x41, 1029, 197},
    { 0, 0x55, 3419, 191},
    // 1485: Local time: 08:18:00 AM
    { 85, 0x45, 3364, 221},
    { 121, 0x45, 1953, 205},
    { 132, 0x10, 4307, 193},
    { 112, 0xa, 3254, 185},
    { 115, 0x9, 2046, 196},
    { 50, 0x7, 2195, 201},
    { 0, 0x36, 2949, 181},
    { 10, 0x36, 896, 215},
    { 0, 0x54, 6972, 187},
    { 12, 0x56, 2157, 191},
    { 0, 0x64, 812, 190},
    { 0, 0x64, 848, 191},
    { 0, 0x55, 1020, 194},
    { 0, 0x63, 113, 196},
    { 8, 0x65, 1818, 195},
    // 1500: Local time: 08:33:00 AM
    { 0, 0x64, 1335, 198},
    { 10, 0x64, 1426, 196},
    { 0, 0x64, 2061, 193},
    { 0, 0x64, 330, 201},
    { 15, 0x55, 2342, 197},
    { 0, 0x63, 113, 197},
    { 0, 0x63, 244, 196},
    { 0, 0x64, 726, 193},
    { 0, 0x56, 1445, 198},
    { 0, 0x45, 856, 194},
    { 7, 0x55, 1620, 191},
    { 10, 0x55, 2815, 190},
    { 0, 0x46, 1237, 189},
    { 0, 0x56, 1885, 195},
    { 16, 0x45, 1438, 178},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

