/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

// @nolint
// please don't change these values manually, they are derived from the spreadsheet
// "Notification Colors"

#if PLATFORM_TINTIN
// Tintin does not have the color arg in its App Metadata. Remove it.
#define APP(id, icon, color) { id, icon }
#else
#define APP(id, icon, color) { id, icon, color }
#endif

    APP(IOS_CALENDAR_APP_ID, TIMELINE_RESOURCE_TIMELINE_CALENDAR, GColorRedARGB8),
    APP(IOS_FACETIME_APP_ID, TIMELINE_RESOURCE_NOTIFICATION_FACETIME, GColorIslamicGreenARGB8),
    APP(IOS_MAIL_APP_ID, TIMELINE_RESOURCE_GENERIC_EMAIL, GColorVividCeruleanARGB8),
    APP(IOS_PHONE_APP_ID, TIMELINE_RESOURCE_DURING_PHONE_CALL, GColorPictonBlueARGB8),
    APP(IOS_REMINDERS_APP_ID, TIMELINE_RESOURCE_NOTIFICATION_REMINDER, GColorFollyARGB8),
    APP(IOS_SMS_APP_ID, TIMELINE_RESOURCE_GENERIC_SMS, GColorIslamicGreenARGB8),
    APP("com.atebits.Tweetie2", TIMELINE_RESOURCE_NOTIFICATION_TWITTER, GColorVividCeruleanARGB8),
    APP("com.burbn.instagram", TIMELINE_RESOURCE_NOTIFICATION_INSTAGRAM, GColorCobaltBlueARGB8),
    APP("com.facebook.Facebook", TIMELINE_RESOURCE_NOTIFICATION_FACEBOOK, GColorCobaltBlueARGB8),
    APP("com.facebook.Messenger", TIMELINE_RESOURCE_NOTIFICATION_FACEBOOK_MESSENGER, GColorBlueMoonARGB8),
    APP("com.getpebble.pebbletime", TIMELINE_RESOURCE_NOTIFICATION_FLAG, GColorOrangeARGB8),
    APP("com.google.calendar", TIMELINE_RESOURCE_TIMELINE_CALENDAR, GColorVeryLightBlueARGB8),
    APP("com.google.Gmail", TIMELINE_RESOURCE_NOTIFICATION_GMAIL, GColorRedARGB8),
    APP("com.google.hangouts", TIMELINE_RESOURCE_NOTIFICATION_GOOGLE_HANGOUTS, GColorJaegerGreenARGB8),
    APP("com.google.inbox", TIMELINE_RESOURCE_NOTIFICATION_GOOGLE_INBOX, GColorBlueMoonARGB8),
    APP("com.microsoft.Office.Outlook", TIMELINE_RESOURCE_NOTIFICATION_OUTLOOK, GColorCobaltBlueARGB8),
    APP("com.orchestra.v2", TIMELINE_RESOURCE_NOTIFICATION_MAILBOX, GColorVividCeruleanARGB8),
    APP("com.skype.skype", TIMELINE_RESOURCE_NOTIFICATION_SKYPE, GColorVividCeruleanARGB8),
    APP("com.tapbots.Tweetbot3", TIMELINE_RESOURCE_NOTIFICATION_TWITTER, GColorVividCeruleanARGB8),
    APP("com.toyopagroup.picaboo", TIMELINE_RESOURCE_NOTIFICATION_SNAPCHAT, GColorIcterineARGB8),
    APP("com.yahoo.Aerogram", TIMELINE_RESOURCE_NOTIFICATION_YAHOO_MAIL, GColorIndigoARGB8),
    APP("jp.naver.line", TIMELINE_RESOURCE_NOTIFICATION_LINE, GColorIslamicGreenARGB8),
    APP("net.whatsapp.WhatsApp", TIMELINE_RESOURCE_NOTIFICATION_WHATSAPP, GColorIslamicGreenARGB8),
    APP("ph.telegra.Telegraph", TIMELINE_RESOURCE_NOTIFICATION_TELEGRAM, GColorVividCeruleanARGB8),
#if !PLATFORM_TINTIN
    APP("com.blackberry.bbm1", TIMELINE_RESOURCE_NOTIFICATION_BLACKBERRY_MESSENGER, GColorDarkGrayARGB8),
    APP("com.getpebble.pebbletime.enterprise", TIMELINE_RESOURCE_NOTIFICATION_FLAG, GColorOrangeARGB8),
    APP("com.google.GoogleMobile", TIMELINE_RESOURCE_NOTIFICATION_GENERIC, GColorBlueMoonARGB8),
    APP("com.google.ios.youtube", TIMELINE_RESOURCE_NOTIFICATION_GENERIC, GColorClearARGB8),
    APP("com.hipchat.ios", TIMELINE_RESOURCE_NOTIFICATION_HIPCHAT, GColorCobaltBlueARGB8),
    APP("com.iwilab.KakaoTalk", TIMELINE_RESOURCE_NOTIFICATION_KAKAOTALK, GColorYellowARGB8),
    APP("com.kik.chat", TIMELINE_RESOURCE_NOTIFICATION_KIK, GColorIslamicGreenARGB8),
    APP("com.tencent.xin", TIMELINE_RESOURCE_NOTIFICATION_WECHAT, GColorKellyGreenARGB8),
    APP("com.viber", TIMELINE_RESOURCE_NOTIFICATION_VIBER, GColorVividVioletARGB8),
    APP("com.amazon.Amazon", TIMELINE_RESOURCE_NOTIFICATION_AMAZON, GColorChromeYellowARGB8),
    APP("com.google.Maps", TIMELINE_RESOURCE_NOTIFICATION_GOOGLE_MAPS, GColorBlueMoonARGB8),
    APP("com.google.photos", TIMELINE_RESOURCE_NOTIFICATION_GOOGLE_PHOTOS, GColorBlueMoonARGB8),
    APP("com.apple.mobileslideshow", TIMELINE_RESOURCE_NOTIFICATION_IOS_PHOTOS, GColorBlueMoonARGB8),
    APP("com.linkedin.LinkedIn", TIMELINE_RESOURCE_NOTIFICATION_LINKEDIN, GColorCobaltBlueARGB8),
    APP("com.tinyspeck.chatlyio", TIMELINE_RESOURCE_NOTIFICATION_SLACK, GColorFollyARGB8),
    APP("com.automattic.beeper", TIMELINE_RESOURCE_NOTIFICATION_BEEPER, GColorVividVioletARGB8),
    APP("xyz.blueskyweb.app", TIMELINE_RESOURCE_NOTIFICATION_BLUESKY, GColorVividCeruleanARGB8),
    APP("com.hammerandchisel.discord", TIMELINE_RESOURCE_NOTIFICATION_DISCORD, GColorIndigoARGB8),
    APP("com.duolingo.DuolingoMobile", TIMELINE_RESOURCE_NOTIFICATION_DUOLINGO, GColorGreenARGB8),
    APP("im.vector.app", TIMELINE_RESOURCE_NOTIFICATION_ELEMENT, GColorMediumAquamarineARGB8),
    APP("io.element.elementx", TIMELINE_RESOURCE_NOTIFICATION_ELEMENT, GColorDarkGreenARGB8),
    APP("com.google.Dynamite", TIMELINE_RESOURCE_NOTIFICATION_GOOGLE_CHAT, GColorGreenARGB8),
    APP("com.google.tasks", TIMELINE_RESOURCE_NOTIFICATION_GOOGLE_TASKS, GColorBlueMoonARGB8),
    APP("io.robbie.HomeAssistant", TIMELINE_RESOURCE_NOTIFICATION_HOME_ASSISTANT, GColorVividCeruleanARGB8),
    APP("com.valvesoftware.Steam", TIMELINE_RESOURCE_NOTIFICATION_STEAM, GColorCobaltBlueARGB8),
    APP("com.microsoft.skype.teams", TIMELINE_RESOURCE_NOTIFICATION_TEAMS, GColorIndigoARGB8),
    APP("com.burbn.barcelona", TIMELINE_RESOURCE_NOTIFICATION_THREADS, GColorDarkGrayARGB8),
    APP("com.ubnt.protect", TIMELINE_RESOURCE_NOTIFICATION_UNIFI_PROTECT, GColorBlueMoonARGB8),
    APP("us.zoom.videomeetings", TIMELINE_RESOURCE_NOTIFICATION_ZOOM, GColorVividCeruleanARGB8),
    APP("com.ebay.iphone", TIMELINE_RESOURCE_NOTIFICATION_EBAY, GColorRedARGB8),
    APP("com.revolut.revolut", TIMELINE_RESOURCE_PAY_BILL, GColorDarkGrayARGB8),
    APP("com.transferwise.Transferwise", TIMELINE_RESOURCE_PAY_BILL, GColorGreenARGB8),
    APP("de.no26.Number26", TIMELINE_RESOURCE_PAY_BILL, GColorCadetBlueARGB8),
    APP("com.bunq.ios", TIMELINE_RESOURCE_PAY_BILL, GColorVividCeruleanARGB8),
#endif

#undef APP
