/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#pragma once

// Increment when adding fields or changing the types of fields & tell Katharine what
// you changed so the new definition is in sync with the server
// Please do not cherrypick any change here into a release branch without first checking
// with Katharine, or something is very likely to break.

#define ANALYTICS_APP_HEARTBEAT_BLOB_VERSION 11
#define ANALYTICS_DEVICE_HEARTBEAT_BLOB_VERSION 69


// Note that every analytics blob we send out (device blob, app blob, or event blob) starts out with
// an 8-bit AnalyticsBlobKind followed by a 16-bit version. This header defines the format of the
// device and app blobs. The format of an event blob is defined in analytics_logging.c

// The device and application heartbeats. Defining them like this allows
// us to also use one table for defining the enum, creating the enum<->type
// table and to generate names for debugging (when enabled).
// DO NOT MOVE ELEMENTS AROUND, THIS WILL CHANGE THE BINARY FORMAT!
#define ANALYTICS_METRIC_TABLE(MARKER, DEVICE, APP, UINT8, UINT16, UINT32, INT8, INT16, INT32) \
  MARKER(ANALYTICS_METRIC_INVALID) \
  MARKER(ANALYTICS_METRIC_START) \
  MARKER(ANALYTICS_DEVICE_METRIC_START) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLOB_KIND, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLOB_VERSION, UINT16) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_TIMESTAMP, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_TIME_INTERVAL, UINT32) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_DEVICE_UP_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_SYSTEM_CRASH_CODE, UINT32) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_BATTERY_VOLTAGE, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BATTERY_VOLTAGE_DELTA, INT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BATTERY_PERCENT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BATTERY_PERCENT_DELTA, INT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BATTERY_CHARGE_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BATTERY_PLUGGED_TIME, UINT32)           \
  DEVICE(ANALYTICS_DEVICE_METRIC_BATTERY_SAMPLE_SKIP_COUNT_EXCEEDED, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_STATIONARY_TIME_MINUTES, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_SYSTEM_CRASH_LR, UINT32) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_RUNNING_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_STOP_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_SLEEP_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_NOSTOP_MAIN_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_NOSTOP_BUTTON_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_NOSTOP_BLUETOOTH_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_NOSTOP_DISPLAY_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_NOSTOP_BACKLIGHT_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_NOSTOP_COMM_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_NOSTOP_FLASH_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_NOSTOP_I2C1_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_NOSTOP_ACCESSORY, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_CPU_NOSTOP_MIC, UINT32)  \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_PHONE_APP_INFO_COUNT, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_PHONE_CALL_INCOMING_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_PHONE_CALL_OUTGOING_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_PHONE_CALL_ANSWER_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_PHONE_CALL_DECLINE_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_PHONE_CALL_POP_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_PHONE_CALL_START_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_PHONE_CALL_END_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_PHONE_CALL_TIME, UINT32) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_AIRPLANE_MODE_QUICK_TOGGLE_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_PAIRING_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_PAIRING_RECORDS_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_PAIRING_FORGET_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_CONNECT_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_CONNECT_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_ACTIVE_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_PRIVATE_BYTE_IN_COUNT, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_PRIVATE_BYTE_OUT_COUNT, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_PUBLIC_BYTE_IN_COUNT, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_PUBLIC_BYTE_OUT_COUNT, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_PEBBLE_SPP_APP_TIME, UINT32)    \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_PEBBLE_PPOGATT_APP_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_PEBBLE_APP_LAUNCH_SUCCESS_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_SYSTEM_SESSION_OPEN_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_IOS_IBEACON_WAKEUP_TIMEOUT_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_SNIFF_INTERVAL, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_AFH_CHAN_USE_COUNT, UINT8)   \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_ROLE, UINT8)  \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_MODE_CHANGE_COUNT, UINT16)  \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_SNIFF_ENTER_REQ, UINT16)    \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_SNIFF_EXIT_REQ, UINT16)             \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_HCILL_CNT, UINT16)          \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_NUM_SDP_REQ, UINT16)                  \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_UART_BYTES_IN, UINT32)              \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_UART_BYTES_OUT, UINT32)             \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_OFF_TIME, UINT32)                \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_DISCONNECT_NOT_PAIRABLE_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_DISCONNECT_MFI_FAILURE_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_DISCONNECT_IAP_PACKET_FAILURE_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_DISCONNECT_IAP_WATCHDOG_FAILURE_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_ZERO_ACL_CREDITS_MAX_DURATION_TICKS, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BT_COMM_SESSION_SEND_DATA_FAIL_COUNT, UINT16) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_CONNECT_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_CONNECT_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_CONNECT_ENCRYPTED_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_CONNECT_NO_INTENT_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_GATT_DROPPED_NOTIFICATIONS_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_GATT_STALLED_NOTIFICATIONS_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_GATT_UNHANDLED1_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_GATT_UNHANDLED2_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_GATT_UNHANDLED3_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_ESTIMATED_BYTES_ADVERTISED_COUNT, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_CHAN_USE_COUNT, UINT8)        \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_CONN_PARAMS, UINT16, 2)    \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_CONN_PARAM_UPDATE_FAILED_COUNT, UINT8)  \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_CONN_EVENT_COUNT, UINT32)  \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_PAIRING_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_PAIRING_RECORDS_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_PAIRING_FORGET_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_LINK_QUALITY_SUM, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_RSSI_SUM, UINT16) \
  \
  DEVICE(ANALYTICS_DEVICE_BT_PERSISTENT_STORAGE_UPDATES, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_MFI_RESET_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_MFI_ON_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_I2C_MAX_TRANSFER_DURATION_TICKS, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_I2C_ERROR_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BUTTON_PRESSED_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_ACCEL_SHAKE_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_ACCEL_DOUBLE_TAP_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_ACCEL_PEEK_COUNT, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_ACCEL_SAMPLE_COUNT, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_ACCEL_XYZ_DELTA, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_ACCEL_FIFO_OVERRUN_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_ACCEL_RESET_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_ALARM_SOUNDED_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BACKLIGHT_ON_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BACKLIGHT_ON_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_VIBRATOR_ON_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_VIBRATOR_ON_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_FPGA_REPROGRAM_COUNT, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_RECEIVED_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_RECEIVED_DND_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_DISMISSED_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_DISMISS_ALL_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_CLOSED_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_BYTE_IN_COUNT, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_JUMBOJI_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_COUNT, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_DS_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_NS_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_PARSE_ERROR_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_DISCOVERED_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_DS_SUBSCRIBE_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_NS_SUBSCRIBE_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_DS_SUBSCRIBE_FAIL_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_NS_SUBSCRIBE_FAIL_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_CONNECT_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_NS_FLAGS_BITSET, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_SMS_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_GROUP_SMS_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_MUTED_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_NOTIFICATION_ANCS_FILTERED_BECAUSE_MUTED_COUNT, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_REMINDER_RECEIVED_COUNT, UINT16) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_APP_ROCKY_LAUNCH_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_APP_ROCKY_CRASHED_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_APP_USER_LAUNCH_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_APP_CRASHED_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_APP_THROTTLED_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_APP_NOTIFIED_DISCONNECTED_COUNT, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_DATA_LOGGING_FLUSH_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_DATA_LOGGING_REALLOC_COUNT, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_DATA_LOGGING_MAX_SPOOLED_BYTES, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_DATA_LOGGING_ENDPOINT_SENDS, UINT16) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_PING_SENT_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_PONG_RECEIVED_COUNT, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_APP_QUICK_LAUNCH_COUNT, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_SETTING_BACKLIGHT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_SETTING_SHAKE_TO_LIGHT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_SETTING_BACKLIGHT_INTENSITY_PCT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_SETTING_BACKLIGHT_TIMEOUT_SEC, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_SETTING_VIBRATION_STRENGTH, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_ALERTS_MASK, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_ALERTS_DND_ACTIVE_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_ALERTS_DND_PREFS_BITMASK, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_SYSTEM_THEME_TEXT_STYLE, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_WATCH_ONLY_TIME, UINT32) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_TIMELINE_PAST_LAUNCH_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_TIMELINE_FUTURE_LAUNCH_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_TIMELINE_PAST_NAVIGATION_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_TIMELINE_FUTURE_NAVIGATION_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_TIMELINE_PINS_VISIBLE_CALENDAR_COUNT,  UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_TIMELINE_PINS_VISIBLE_OTHER_COUNT,  UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_TIMELINE_PINS_HOURLY_CALENDAR_COUNT,  UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_TIMELINE_PINS_HOURLY_OTHER_COUNT,  UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLOB_DB_EVENT_COUNT, UINT16) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_FLASH_READ_BYTES_COUNT, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_FLASH_WRITE_BYTES_COUNT, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_FLASH_ERASE_COUNT, UINT8)  \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_KERNEL_HEAP_MIN_HEADROOM_BYTES, UINT16) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_STACK_FREE_KERNEL_MAIN, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_STACK_FREE_KERNEL_BACKGROUND, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_STACK_FREE_BLUETOPIA_BIG, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_STACK_FREE_BLUETOPIA_MEDIUM, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_STACK_FREE_BLUETOPIA_SMALL, UINT16) \
  DEVICE(ANALYTICS_DEVICE_METRIC_STACK_FREE_NEWTIMERS, UINT16) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_ACTION_INVOKED_FROM_TIMELINE_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_ACTION_INVOKED_FROM_MODAL_NOTIFICATION_COUNT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_ACTION_INVOKED_FROM_NOTIFICATION_APP_COUNT, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_HEALTH_CURRENT_STEP_COUNT__DEPRECATED, UINT16) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_DISPLAY_UPDATES_PER_HOUR,  UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_DISPLAY_OFFSET_X, INT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_DISPLAY_OFFSET_Y, INT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_DISPLAY_OFFSET_MODIFIED_COUNT, UINT8) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_PFS_SPACE_FREE_KB,  UINT16) \
  \
  DEVICE(ANALYTICS_DEVICE_METRIC_HRM_ACCEL_DATA_MISSING, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_HRM_ON_TIME, UINT32) \
  DEVICE(ANALYTICS_DEVICE_METRIC_HRM_WATCHDOG_TIMEOUT, UINT8) \
  DEVICE(ANALYTICS_DEVICE_METRIC_BLE_HRM_SHARING_TIME, UINT32) \
  \
  MARKER(ANALYTICS_DEVICE_METRIC_END) \
  \
  \
  MARKER(ANALYTICS_APP_METRIC_START) \
  \
  APP(ANALYTICS_APP_METRIC_BLOB_KIND, UINT8) \
  APP(ANALYTICS_APP_METRIC_BLOB_VERSION, UINT16) \
  APP(ANALYTICS_APP_METRIC_TIMESTAMP, UINT32) \
  \
  APP(ANALYTICS_APP_METRIC_TIME_INTERVAL, UINT32) \
  APP(ANALYTICS_APP_METRIC_UUID, UINT8, 16) \
  APP(ANALYTICS_APP_METRIC_SDK_MAJOR_VERSION, UINT8) \
  APP(ANALYTICS_APP_METRIC_SDK_MINOR_VERSION, UINT8) \
  APP(ANALYTICS_APP_METRIC_APP_MAJOR_VERSION, UINT8) \
  APP(ANALYTICS_APP_METRIC_APP_MINOR_VERSION, UINT8) \
  APP(ANALYTICS_APP_METRIC_RESOURCE_TIMESTAMP, UINT32) \
  \
  APP(ANALYTICS_APP_METRIC_LAUNCH_COUNT, UINT8) \
  APP(ANALYTICS_APP_METRIC_USER_LAUNCH_COUNT, UINT8) \
  APP(ANALYTICS_APP_METRIC_QUICK_LAUNCH_COUNT, UINT8) \
  APP(ANALYTICS_APP_METRIC_FRONT_MOST_TIME, UINT32) \
  APP(ANALYTICS_APP_METRIC_CRASHED_COUNT, UINT8) \
  APP(ANALYTICS_APP_METRIC_ROCKY_LAUNCH_COUNT, UINT8) \
  APP(ANALYTICS_APP_METRIC_ROCKY_CRASHED_COUNT, UINT8) \
  \
  APP(ANALYTICS_APP_METRIC_CPU_RUNNING_TIME, UINT32) \
  APP(ANALYTICS_APP_METRIC_CPU_SLEEP_TIME, UINT32) \
  APP(ANALYTICS_APP_METRIC_CPU_STOP_TIME, UINT32) \
  \
  APP(ANALYTICS_APP_METRIC_MEM_NATIVE_HEAP_SIZE, UINT32) \
  APP(ANALYTICS_APP_METRIC_MEM_NATIVE_HEAP_PEAK, UINT32) \
  APP(ANALYTICS_APP_METRIC_MEM_ROCKY_HEAP_PEAK, UINT32) \
  APP(ANALYTICS_APP_METRIC_MEM_ROCKY_HEAP_WASTE, UINT32) \
  APP(ANALYTICS_APP_METRIC_MEM_ROCKY_RECURSIVE_MEMORYPRESSURE_EVENT_COUNT, UINT8) \
  \
  APP(ANALYTICS_APP_METRIC_BG_CPU_RUNNING_TIME, UINT32) \
  APP(ANALYTICS_APP_METRIC_BG_CPU_SLEEP_TIME, UINT32) \
  APP(ANALYTICS_APP_METRIC_BG_CPU_STOP_TIME, UINT32) \
  APP(ANALYTICS_APP_METRIC_BG_CRASHED_COUNT, UINT8) \
  \
  APP(ANALYTICS_APP_METRIC_BUTTONS_PRESSED_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_ACCEL_SHAKE_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_ACCEL_PEEK_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_ACCEL_SAMPLE_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_BACKLIGHT_ON_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_BACKLIGHT_ON_TIME, UINT32) \
  APP(ANALYTICS_APP_METRIC_VIBRATOR_ON_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_VIBRATOR_ON_TIME, UINT32) \
  APP(ANALYTICS_APP_METRIC_DISPLAY_WRITE_TIME, UINT32) \
  \
  APP(ANALYTICS_APP_METRIC_MSG_IN_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_MSG_BYTE_IN_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_MSG_OUT_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_MSG_BYTE_OUT_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_MSG_DROP_COUNT, UINT16) \
  \
  APP(ANALYTICS_APP_METRIC_LOG_OUT_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_LOG_BYTE_OUT_COUNT, UINT32) \
  \
  APP(ANALYTICS_APP_METRIC_FLASH_READ_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_FLASH_READ_BYTES_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_FLASH_WRITE_BYTES_COUNT, UINT32) \
  APP(ANALYTICS_APP_METRIC_FLASH_SUBSECTOR_ERASE_COUNT, UINT32) \
  \
  MARKER(ANALYTICS_APP_METRIC_END) \
  MARKER(ANALYTICS_METRIC_END)


#define ENUM(name, ...) name,
typedef enum {
  ANALYTICS_METRIC_TABLE(ENUM, ENUM, ENUM,,,,,,)
} AnalyticsMetric;
#undef ENUM
