/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#include "shadows.h"

//! Top shadow, horizontally-tileable bitmap (32 x 19px):
static const uint8_t s_shadow_top_data[] = {
  // GBitmap bytes generated by bitmapgen.py:
  0xdd, 0xdd, 0xdd, 0xdd, 0x77, 0x77, 0x77, 0x77, 0xdd, 0xdd, 0xdd, 0xdd, 0x77, 0x77, 0x77, 0x77,
  0xda, 0xda, 0xda, 0xda, 0xab, 0xab, 0xab, 0xab, 0x6d, 0x6d, 0x6d, 0x6d, 0xaa, 0xaa, 0xaa, 0xaa,
  0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 0x82, 0x20, 0x82, 0x20, 0x34, 0x4d, 0x34, 0x4d,
  0x41, 0x10, 0x41, 0x10, 0x14, 0x45, 0x14, 0x45, 0x41, 0x10, 0x41, 0x10, 0x10, 0x04, 0x10, 0x04,
  0x82, 0x20, 0x82, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04,
};

static const GBitmap s_shadow_top_bitmap = {
  .addr = (uint8_t *)s_shadow_top_data,
  .row_size_bytes = 4,
  .info.format = GBitmapFormat1Bit,
  .info.version = 1,
  .bounds = { { 0, 0 },
              { 32, 19 } },
};

static const uint8_t s_shadow_bottom_data[] = {
  // GBitmap bytes generated by bitmapgen.py:
  0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x41, 0x04, 0x41, 0x20, 0x08, 0x20, 0x08,
  0x08, 0x82, 0x08, 0x82, 0xa2, 0x28, 0xa2, 0x28, 0x08, 0x82, 0x08, 0x82, 0xb2, 0x2c, 0xb2, 0x2c,
  0x04, 0x41, 0x04, 0x41, 0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
  0xb6, 0xb6, 0xb6, 0xb6, 0xd5, 0xd5, 0xd5, 0xd5, 0x5b, 0x5b, 0x5b, 0x5b, 0xee, 0xee, 0xee, 0xee,
  0xbb, 0xbb, 0xbb, 0xbb, 0xee, 0xee, 0xee, 0xee, 0xbb, 0xbb, 0xbb, 0xbb,
};

//! Bottom shadow, horizontally-tileable bitmap (32 x 19px):
static const GBitmap s_shadow_bottom_bitmap = {
  .addr = (uint8_t *)s_shadow_bottom_data,
  .row_size_bytes = 4,
  .info.format = GBitmapFormat1Bit,
  .info.version = 1,
  .bounds = { { 0, 0 },
              { 32, 19 } },
};

GBitmap* shadow_get_top(void) {
  return (GBitmap*) &s_shadow_top_bitmap;
}

GBitmap* shadow_get_bottom(void) {
  return (GBitmap *) &s_shadow_bottom_bitmap;
}

