/* SPDX-FileCopyrightText: 2015-2016 Samsung Electronics Co., Ltd. */
/* SPDX-FileCopyrightText: 2015-2016 University of Szeged. */
/* SPDX-License-Identifier: Apache-2.0 */

#ifndef LIT_UNICODE_RANGES_INC_H_
#define LIT_UNICODE_RANGES_INC_H_

/**
 * Character interval starting points for the unicode letters.
 *
 * The characters covered by these intervalse are from
 * the following Unicode categories: Lu, Ll, Lt, Lm, Lo, Nl
 */
static const uint16_t unicode_letter_interv_sps[] JERRY_CONST_DATA =
{
/*
 * these are handled separetely
 * 0x0041, len 25
 * 0x0061, len 25
 */
  0x00C0, 0x00D8, 0XF8, 0X1F8, 0x0222, 0x0250, 0x02B0, 0x02BB,
  0x02D0, 0x02E0, 0x0388, 0x038E, 0x03A3, 0x03D0, 0x03DA, 0x0400, 0x048C, 0x04C7,
  0x04CB, 0x04D0, 0x04F8, 0x0531, 0x0561, 0x05D0, 0x05F0, 0x0621, 0x0640, 0x0671,
  0x06E5, 0x06FA, 0x0712, 0x0780, 0x0905, 0x0958, 0x0985, 0x098F, 0x0993, 0x09AA,
  0x09B6, 0x09DC, 0x09DF, 0x09F0, 0x0A05, 0x0A0F, 0x0A13, 0x0A2A, 0x0A32, 0x0A35,
  0x0A38, 0x0A59, 0x0A72, 0x0A85, 0x0A8F, 0x0A93, 0x0AAA, 0x0AB2, 0x0AB5, 0x0B05,
  0x0B0F, 0x0B13, 0x0B2A, 0x0B32, 0x0B36, 0x0B5C, 0x0B5F, 0x0B85, 0x0B8E, 0x0B92,
  0x0B99, 0x0B9E, 0x0BA3, 0x0BA8, 0x0BAE, 0x0BB7, 0x0C05, 0x0C0E, 0x0C12, 0x0C2A,
  0x0C35, 0x0C60, 0x0C85, 0x0C8E, 0x0C92, 0x0CAA, 0x0CB5, 0x0CE0, 0x0D05, 0x0D0E,
  0x0D12, 0x0D2A, 0x0D60, 0x0D85, 0x0D9A, 0x0DB3, 0x0DC0, 0x0E01, 0x0E32, 0x0E40,
  0x0E81, 0x0E87, 0x0E94, 0x0E99, 0x0EA1, 0x0EAA, 0x0EAD, 0x0EB2, 0x0EC0, 0x0EDC,
  0x0F40, 0x0F49, 0x0F88, 0x1000, 0x1023, 0x1029, 0x1050, 0x10A0, 0x10D0, 0x1100,
  0x115F, 0x11A8, 0x1200, 0x1208, 0x124A, 0x1250, 0x125A, 0x1260, 0x128A, 0x1290,
  0x12B2, 0x12B8, 0x12C2, 0x12C8, 0x12D0, 0x12D8, 0x12F0, 0x1312, 0x1318, 0x1320,
  0x1348, 0x13A0, 0X1401, 0X1501, 0X1601, 0x166F, 0x1681, 0x16A0, 0x1780, 0x1820,
  0x1880, 0x1E00, 0x1EA0, 0x1F00, 0x1F18, 0x1F20, 0x1F48, 0x1F50, 0x1F5F, 0x1F80,
  0x1FB6, 0x1FC2, 0x1FC6, 0x1FD0, 0x1FD6, 0x1FE0, 0x1FF2, 0x1FF6, 0x210A, 0x2119,
  0x212A, 0x212F, 0x2133, 0x2160, 0x3005, 0x3021, 0x3031, 0x3038, 0x3041, 0x309D,
  0x30A1, 0x30FC, 0x3105, 0x3131, 0x31A0, 0XA000, 0XA100, 0XA200, 0XA300, 0XA400,
  0XF900, 0XFA00, 0xFB00, 0xFB13, 0xFB1F, 0xFB2A, 0xFB38, 0xFB40, 0xFB43, 0xFB46,
  0XFBD3, 0XFCD3, 0xFD50, 0xFD92, 0xFDF0, 0xFE70, 0xFE76, 0xFF21, 0xFF41, 0xFF66,
  0xFFC2, 0xFFCA, 0xFFD2, 0xFFDA
};

/**
 * Character lengths for the unicode letters.
 *
 * The characters covered by these intervalse are from
 * the following Unicode categories: Lu, Ll, Lt, Lm, Lo, Nl
 */
static const uint8_t unicode_letter_interv_lens[] JERRY_CONST_DATA =
{
  22, 30, 255, 39, 17, 93, 8, 6,
  1, 4, 2, 19, 43, 7, 25, 129, 56, 1,
  1, 37, 1, 37, 38, 26, 2, 25, 10, 98,
  1, 2, 26, 37, 52, 9, 7, 1, 21, 6,
  3, 1, 2, 1, 5, 1, 21, 6, 1, 1,
  1, 3, 2, 6, 2, 21, 6, 1, 4, 7,
  1, 21, 6, 1, 3, 1, 2, 5, 2, 3,
  1, 1, 1, 2, 7, 2, 7, 2, 22, 9,
  4, 1, 7, 2, 22, 9, 4, 1, 7, 2,
  22, 15, 1, 17, 23, 8, 6, 47, 1, 6,
  1, 1, 3, 6, 2, 1, 3, 1, 4, 1,
  7, 33, 3, 33, 4, 1, 5, 37, 38, 89,
  67, 81, 6, 62, 3, 6, 3, 38, 3, 30,
  3, 6, 3, 6, 6, 22, 30, 3, 6, 38,
  18, 84, 255, 255, 107, 7, 25, 74, 51, 87,
  40, 155, 89, 21, 5, 37, 5, 7, 30, 52,
  6, 2, 6, 3, 5, 12, 2, 6, 9, 4,
  3, 2, 6, 35, 2, 8, 4, 2, 83, 1,
  89, 2, 39, 93, 23, 255, 255, 255, 255, 140,
  255, 45, 6, 4, 9, 12, 4, 1, 1, 107,
  255, 106, 63, 53, 11, 2, 134, 25, 25, 88,
  5, 5, 5, 2
};

/**
 * Those unicode letter characters that are not inside any of
 * the intervals specified in unicode_letter_intervals array.
 *
 * The characters are from the following Unicode categories:
 * Lu, Ll, Lt, Lm, Lo, Nl
 */
static const uint16_t unicode_letter_chars[] JERRY_CONST_DATA =
{
  0x00AA, 0x00B5, 0x00BA, 0x02EE, 0x037A, 0x0386, 0x038C, 0x0559, 0x06D5, 0x0710,
  0x093D, 0x0950, 0x09B2, 0x0A5E, 0x0A8D, 0x0ABD, 0x0AD0, 0x0AE0, 0x0B3D, 0x0B9C,
  0x0CDE, 0x0DBD, 0x0E84, 0x0E8A, 0x0E8D, 0x0EA5, 0x0EA7, 0x0EBD, 0x0EC6, 0x0F00,
  0x1248, 0x1258, 0x1288, 0x12B0, 0x12C0, 0x1310, 0x1F59, 0x1F5B, 0x1F5D, 0x1FBE,
  0x207F, 0x2102, 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 0x3400, 0x4DB5, 0x4E00,
  0x9FA5, 0xAC00, 0xD7A3, 0xFB1D, 0xFB3E, 0xFE74
};

/**
 * Character interval starting points for non-letter character
 * that can be used as a non-first character of an identifier.
 *
 * The characters covered by these intervalse are from
 * the following Unicode categories: Nd, Mn, Mc, Pc
 */
static const uint16_t unicode_non_letter_ident_part_interv_sps[] JERRY_CONST_DATA =
{
/*
 * decimal digits: handled separately
 * 0x0030, len: 9
 */
  0x0300, 0x0360, 0x0483, 0x0591, 0x05A3, 0x05BB, 0x05C1, 0x064B, 0x0660,
  0x06D6, 0x06DF, 0x06E7, 0x06EA, 0x06F0, 0x0730, 0x07A6, 0x0901, 0x093E, 0x0951,
  0x0962, 0x0966, 0x0981, 0x09BE, 0x09C7, 0x09CB, 0x09E2, 0x09E6, 0x0A3E, 0x0A47,
  0x0A4B, 0x0A66, 0x0A81, 0x0ABE, 0x0AC7, 0x0ACB, 0x0AE6, 0x0B01, 0x0B3E, 0x0B47,
  0x0B4B, 0x0B56, 0x0B66, 0x0B82, 0x0BBE, 0x0BC6, 0x0BCA, 0x0BE7, 0x0C01, 0x0C3E,
  0x0C46, 0x0C4A, 0x0C55, 0x0C66, 0x0C82, 0x0CBE, 0x0CC6, 0x0CCA, 0x0CD5, 0x0CE6,
  0x0D02, 0x0D3E, 0x0D46, 0x0D4A, 0x0D66, 0x0D82, 0x0DCF, 0x0DD8, 0x0DF2, 0x0E34,
  0x0E47, 0x0E50, 0x0EB4, 0x0EBB, 0x0EC8, 0x0ED0, 0x0F18, 0x0F20, 0x0F3E, 0x0F71,
  0x0F86, 0x0F90, 0x0F99, 0x102C, 0x1036, 0x1040, 0x1056, 0x1369, 0x17B4, 0x17E0,
  0x1810, 0x203F, 0x20D0, 0x302A, 0x3099, 0xFE20, 0xFE33, 0xFE4D, 0xFF10
};

/**
 * Character interval lengths for non-letter character
 * that can be used as a non-first character of an identifier.
 *
 * The characters covered by these intervalse are from
 * the following Unicode categories: Nd, Mn, Mc, Pc
 */
static const uint8_t unicode_non_letter_ident_part_interv_lens[] =
{
  78, 2, 3, 16, 22, 2, 1, 10, 9,
  6, 5, 1, 3, 9, 26, 10, 2, 15, 3,
  1, 9, 2, 6, 1, 2, 1, 9, 4, 1,
  2, 11, 2, 7, 2, 2, 9, 2, 5, 1,
  2, 1, 9, 1, 4, 2, 3, 8, 2, 6,
  2, 3, 1, 9, 1, 6, 2, 3, 1, 9,
  1, 5, 2, 3, 9, 1, 5, 7, 1, 6,
  7, 9, 5, 1, 5, 9, 1, 9, 1, 19,
  1, 7, 35, 6, 3, 9, 3, 8, 31, 9,
  9, 1, 12, 5, 1, 3, 1, 2, 9
};

/**
 * Those non-letter characters that can be used as a non-first
 * character of an identifier and not included in any of the intervals
 * specified in unicode_non_letter_ident_part_intervals array.
 *
 * The characters are from the following Unicode categories:
 * Nd, Mn, Mc, Pc
 */
static const uint16_t unicode_non_letter_ident_part_chars[] =
{
  0x005F, 0x05BF, 0x05C4, 0x0670, 0x0711, 0x093C, 0x09BC, 0x09D7, 0x0A02, 0x0A3C,
  0x0ABC, 0x0B3C, 0x0BD7, 0x0D57, 0x0DCA, 0x0DD6, 0x0E31, 0x0EB1, 0x0F35, 0x0F37,
  0x0F39, 0x0FC6, 0x18A9, 0x20E1, 0x30FB, 0xFB1E, 0xFF3F, 0xFF65
};


/**
 * Unicode separator character interval strting points from Unicode category: Zs
 */
static const uint16_t unicode_separator_char_interv_sps[] =
{
  0x2000
};

/**
 * Unicode separator character interval lengths from Unicode category: Zs
 */
static const uint8_t unicode_separator_char_interv_lens[] =
{
  11
};

/**
 * Unicode separator characters that are not in the
 * unicode_separator_char_intervals array.
 *
 * Unicode category: Zs
 */
static const uint16_t unicode_separator_chars[] =
{
  /*
   * these two chars are handled separatly @see lit_char_is_space_separator
   * 0x0020, space
   * 0x00A0, non-braking space
   */
  0x1680, \
  0x180E, /* manually added */ \
  0x202F, /* manually added */ \
  0x205F, \
  0x3000
};

#endif
