## Setting up prerequisites

Currently, only Ubuntu 14.04+ is officially supported as primary development environment.

There are several dependencies, that should be installed manually. The following list is the absolute minimum for building:

- `gcc` or any C99-compliant compiler (native or cross, e.g., arm-none-eabi)
- `cmake` >= `2.8.12.2`

Several scripts and tools help the building and development process, thus it is recommended to have the following installed as well:

- `bash` >= `4.3.11`
- `cppcheck` >= `1.61`
- `vera++` >= `1.2.1`
- `python` >= `2.7.6`

```bash
sudo apt-get install gcc gcc-arm-none-eabi cmake cppcheck vera++ python
```

To make our scripts run correctly, several shell utilities should be available on the system:

- `awk`
- `bc`
- `find`
- `sed`

## Building JerryScript

**To build debug version for Linux**

```bash
python tools/build.py --debug
```

**To build debug version for Linux without LTO (Link Time Optimization)**

```bash
python tools/build.py --debug --lto=off
```

**Add custom arguments to CMake**

```bash
python tools/build.py --cmake-param=CMAKE_PARAM
```

**Set a profile mode (full, minimal)**

```bash
python tools/build.py --feature=full|minimal
```

**Use (jerry, compiler-default, external) libc**

The default libc is jerry-libc, but you can use compiler-default libc or an external libc:

- compiler-default libc:

```bash
python tools/build.py --jerry-libc=off
```

- external libc:

```bash
python tools/build.py --jerry-libc=off --compile-flag="-nostdlib -I/path/to/ext-libc/include" --link-lib="-lext-c"
```

**Add toolchain file**

The ```cmake``` dir already contains some usable toolchain files, which you can use in the following format:

```bash
python tools/build.py --toolchain=TOOLCHAIN
```

For example the cross-compile to RaspberryPi 2 is something like this:

```bash
python tools/build.py --toolchain=cmake/toolchain_linux_armv7l.cmake
```

**To get a list of all the available buildoptions for Linux**

```bash
python tools/build.py --help
```

## Checking patch

```bash
python tools/run-tests.py --precommit
```

### Running only one type of test

**To run build option tests**

```bash
python tools/run-tests.py --buildoption-test
```

**To run unittests**

```bash
python tools/run-tests.py --unittests
```

**To run jerry-tests**

```bash
python tools/run-tests.py --jerry-tests
```

**To run jerry-test-suite**

```bash
python tools/run-tests.py --jerry-test-suite
```

**To run signed-off check**

```bash
python tools/run-tests.py --check-signed-off
```

**To run cppcheck**

```bash
python tools/run-tests.py --check-cppcheck
```

**To run vera check**

```bash
python tools/run-tests.py --check-vera
```

**To get a list of all the available test options**

```bash
python tools/run-tests.py --help
```
