/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#include <stdint.h>
#include <string.h>

#include "applib/accel_service.h"
#include "util/size.h"


// ----------------------------------------------------------------
// Sample captured: 2015-08-06 13:31:28 GMT
AccelRawData *activity_sample_30_steps(int *len) {
  static AccelRawData samples[] = {
    { -42, -52, -1027},
    { -43, -29, -1054},
    { -76, 12, -975},
    { -72, -17, -906},
    { -64, -40, -892},
    { -81, -37, -933},
    { -77, -15, -1008},
    { -83, 0, -1041},
    { -81, -27, -1029},
    { -80, -57, -993},
    { -97, -27, -973},
    { -119, -21, -991},
    { -120, -19, -1011},
    { -115, -27, -978},
    { -106, -44, -953},
    { -104, -62, -946},
    { -150, -90, -962},
    { -148, -66, -991},
    { -164, -101, -980},
    { -162, -102, -975},
    { -223, -67, -966},
    { -251, -84, -971},
    { -118, -134, -968},
    { -159, -54, -956},
    { -160, -125, -958},
    { -102, -152, -963},
    { -39, -154, -974},
    { 63, -317, -986},
    { -61, -190, -1000},
    { -131, -306, -1022},
    { -189, -295, -844},
    { -224, -317, -694},
    { -243, -177, -563},
    { -420, 58, -499},
    { -677, 416, -469},
    { -796, 908, -426},
    { -844, 1100, -288},
    { -762, 824, -233},
    { -813, 1019, -270},
    { -816, 1041, -119},
    { -865, 914, -6},
    { -848, 872, 24},
    { -817, 776, 42},
    { -765, 655, 14},
    { -804, 635, -20},
    { -839, 657, 13},
    { -874, 659, -1},
    { -926, 587, -19},
    { -976, 510, -31},
    { -937, 466, -78},
    { -1187, 483, 24},
    { -1046, 482, -87},
    { -1071, 566, -238},
    { -884, 460, -301},
    { -844, 144, -211},
    { -880, 213, -78},
    { -972, -2, 38},
    { -786, 53, 32},
    { -739, 232, -12},
    { -695, 344, -61},
    { -706, 394, -72},
    { -743, 351, -67},
    { -775, 334, -58},
    { -819, 333, -45},
    { -869, 365, -70},
    { -833, 405, -36},
    { -1466, 634, 18},
    { -1132, 698, -39},
    { -849, 548, -59},
    { -1073, 483, -47},
    { -970, 540, -84},
    { -883, 458, -35},
    { -781, 364, -41},
    { -732, 345, -40},
    { -751, 324, 2},
    { -752, 287, 42},
    { -727, 285, 29},
    { -718, 304, 44},
    { -813, 325, 79},
    { -903, 335, 75},
    { -880, 323, 4},
    { -1093, 404, 57},
    { -1177, 388, 76},
    { -1098, 513, -82},
    { -892, 549, -256},
    { -739, 484, -199},
    { -695, 337, -82},
    { -846, 302, 0},
    { -787, 298, 24},
    { -712, 392, 29},
    { -733, 439, -20},
    { -740, 464, -49},
    { -739, 450, -50},
    { -752, 411, -87},
    { -837, 438, -93},
    { -961, 453, -73},
    { -994, 442, -23},
    { -1059, 466, 2},
    { -1222, 594, 33},
    { -997, 552, 30},
    { -873, 477, -30},
    { -850, 443, 32},
    { -894, 421, 62},
    { -891, 367, 102},
    { -873, 322, 164},
    { -865, 316, 181},
    { -804, 364, 150},
    { -757, 337, 158},
    { -714, 338, 110},
    { -721, 405, 71},
    { -721, 419, 53},
    { -725, 400, 35},
    { -737, 373, 55},
    { -752, 386, 57},
    { -865, 451, 64},
    { -928, 486, 99},
    { -1113, 519, 257},
    { -1147, 531, 305},
    { -1069, 693, 49},
    { -815, 808, -126},
    { -679, 568, -43},
    { -748, 421, 29},
    { -886, 316, 59},
    { -906, 306, 26},
    { -846, 369, 0},
    { -843, 404, -15},
    { -828, 396, -2},
    { -826, 358, 23},
    { -755, 300, 41},
    { -700, 305, 46},
    { -747, 377, 28},
    { -794, 416, 47},
    { -1102, 470, 161},
    { -1303, 549, 281},
    { -1194, 656, 238},
    { -709, 508, 77},
    { -734, 453, 115},
    { -739, 456, 199},
    { -781, 422, 258},
    { -758, 330, 258},
    { -708, 344, 240},
    { -780, 317, 285},
    { -817, 324, 263},
    { -829, 355, 210},
    { -858, 364, 164},
    { -906, 377, 157},
    { -923, 359, 98},
    { -887, 352, 9},
    { -1061, 369, 100},
    { -1180, 384, 148},
    { -922, 410, 5},
    { -778, 464, -90},
    { -770, 444, -26},
    { -841, 375, 6},
    { -837, 321, 52},
    { -757, 354, 58},
    { -745, 372, 36},
    { -737, 432, -16},
    { -759, 420, -26},
    { -783, 429, -53},
    { -824, 437, -80},
    { -883, 473, -85},
    { -907, 472, -54},
    { -856, 403, 17},
    { -1254, 537, 65},
    { -1046, 516, 93},
    { -1008, 479, 88},
    { -771, 420, 33},
    { -884, 437, 88},
    { -907, 417, 109},
    { -837, 382, 101},
    { -802, 361, 88},
    { -789, 363, 102},
    { -788, 318, 123},
    { -761, 264, 123},
    { -762, 273, 114},
    { -790, 335, 109},
    { -870, 325, 138},
    { -913, 337, 109},
    { -871, 357, 18},
    { -1159, 395, 84},
    { -1036, 382, 52},
    { -907, 491, -125},
    { -798, 533, -195},
    { -784, 460, -111},
    { -835, 375, -31},
    { -840, 327, -9},
    { -773, 403, -1},
    { -739, 434, -30},
    { -773, 450, -57},
    { -786, 449, -64},
    { -862, 447, -89},
    { -934, 463, -112},
    { -975, 473, -92},
    { -897, 430, -62},
    { -851, 399, -43},
    { -1183, 530, 30},
    { -984, 538, 30},
    { -940, 525, 39},
    { -779, 470, 31},
    { -915, 462, 97},
    { -916, 397, 174},
    { -881, 386, 167},
    { -840, 391, 157},
    { -766, 343, 177},
    { -755, 324, 191},
    { -769, 317, 192},
    { -807, 352, 193},
    { -821, 380, 179},
    { -916, 396, 179},
    { -928, 360, 144},
    { -871, 359, 34},
    { -1104, 362, 83},
    { -1048, 368, -61},
    { -819, 467, -296},
    { -747, 536, -384},
    { -840, 488, -258},
    { -858, 404, -178},
    { -831, 316, -141},
    { -734, 466, -161},
    { -715, 431, -110},
    { -760, 436, -88},
    { -762, 422, -44},
    { -726, 430, -46},
    { -778, 447, -31},
    { -872, 477, -16},
    { -987, 484, 33},
    { -962, 420, 126},
    { -1254, 472, 174},
    { -1012, 451, 128},
    { -1023, 473, 152},
    { -863, 461, 115},
    { -836, 440, 169},
    { -887, 418, 182},
    { -946, 397, 235},
    { -878, 358, 206},
    { -779, 327, 142},
    { -748, 269, 156},
    { -745, 232, 145},
    { -737, 260, 111},
    { -772, 324, 96},
    { -874, 366, 115},
    { -954, 347, 148},
    { -919, 360, 83},
    { -994, 403, 83},
    { -1132, 383, 116},
    { -907, 417, -30},
    { -861, 496, -124},
    { -853, 482, -98},
    { -822, 430, -71},
    { -876, 385, -36},
    { -836, 391, -41},
    { -742, 396, -49},
    { -721, 389, -60},
    { -735, 392, -67},
    { -753, 370, -68},
    { -803, 402, -92},
    { -871, 446, -113},
    { -954, 472, -109},
    { -941, 440, -62},
    { -1021, 428, -15},
    { -1181, 546, -10},
    { -979, 498, 48},
    { -970, 454, 18},
    { -808, 412, 6},
    { -925, 465, -8},
    { -942, 404, 39},
    { -851, 352, 49},
    { -788, 336, 43},
    { -760, 304, 71},
    { -755, 270, 106},
    { -744, 257, 119},
    { -724, 280, 111},
    { -745, 307, 103},
    { -874, 345, 116},
    { -948, 331, 95},
    { -958, 361, 58},
    { -1237, 397, 140},
    { -1129, 438, 48},
    { -948, 546, -138},
    { -796, 531, -202},
    { -748, 418, -147},
    { -886, 384, -85},
    { -855, 300, -62},
    { -760, 381, -50},
    { -739, 410, -87},
    { -748, 417, -89},
    { -741, 405, -79},
    { -772, 384, -87},
    { -857, 422, -101},
    { -937, 444, -100},
    { -926, 409, -69},
    { -1087, 440, -28},
    { -1202, 533, -44},
    { -928, 472, -23},
    { -904, 425, -81},
    { -781, 414, -98},
    { -934, 455, -72},
    { -974, 342, -20},
    { -927, 341, 31},
    { -833, 357, 6},
    { -759, 306, 20},
    { -772, 292, 64},
    { -784, 281, 90},
    { -770, 289, 75},
    { -769, 301, 64},
    { -791, 281, 84},
    { -865, 311, 77},
    { -905, 356, 34},
    { -928, 376, 34},
    { -1242, 424, 119},
    { -1062, 453, 58},
    { -963, 584, -126},
    { -810, 527, -67},
    { -812, 403, -9},
    { -880, 330, 21},
    { -792, 329, 40},
    { -692, 363, 0},
    { -689, 397, -46},
    { -698, 405, -71},
    { -710, 379, -79},
    { -795, 419, -102},
    { -892, 468, -119},
    { -1012, 491, -96},
    { -1024, 453, -41},
    { -1262, 560, -19},
    { -1120, 525, 57},
    { -1004, 434, 31},
    { -819, 398, 63},
    { -761, 405, 134},
    { -779, 464, 82},
    { -827, 455, 99},
    { -837, 389, 148},
    { -752, 410, 137},
    { -744, 386, 145},
    { -753, 364, 124},
    { -760, 335, 143},
    { -818, 328, 129},
    { -916, 308, 157},
    { -985, 295, 165},
    { -905, 312, 83},
    { -1069, 368, 131},
    { -1014, 358, 120},
    { -917, 443, -7},
    { -762, 490, -147},
    { -820, 544, -160},
    { -753, 418, -100},
    { -873, 373, -25},
    { -828, 364, -24},
    { -806, 406, -60},
    { -757, 431, -105},
    { -779, 418, -84},
    { -790, 383, -105},
    { -818, 393, -119},
    { -869, 437, -133},
    { -958, 461, -104},
    { -874, 410, -26},
    { -1208, 503, 46},
    { -1075, 527, 44},
    { -1014, 502, 99},
    { -824, 458, 24},
    { -782, 446, 43},
    { -865, 422, 82},
    { -919, 364, 130},
    { -861, 358, 110},
    { -805, 357, 114},
    { -762, 325, 130},
    { -742, 301, 138},
    { -749, 298, 147},
    { -748, 305, 139},
    { -820, 341, 119},
    { -918, 331, 138},
    { -959, 353, 88},
    { -1027, 388, 79},
    { -1112, 380, 70},
    { -941, 440, -98},
    { -921, 522, -223},
    { -848, 539, -239},
    { -787, 394, -149},
    { -890, 329, -70},
    { -888, 341, -52},
    { -802, 381, -61},
    { -742, 399, -88},
    { -739, 403, -76},
    { -741, 364, -54},
    { -778, 357, -64},
    { -824, 402, -103},
    { -912, 451, -105},
    { -893, 426, -70},
    { -854, 394, -25},
    { -1267, 545, 34},
    { -982, 546, 27},
    { -927, 455, 9},
    { -748, 444, -42},
    { -903, 476, 7},
    { -953, 465, 38},
    { -921, 406, 49},
    { -860, 382, 61},
    { -795, 328, 60},
    { -754, 280, 78},
    { -753, 287, 83},
    { -765, 291, 78},
    { -797, 304, 77},
    { -847, 303, 95},
    { -918, 302, 89},
    { -887, 346, 49},
    { -1206, 375, 146},
    { -995, 384, 52},
    { -932, 490, -80},
    { -823, 524, -140},
    { -810, 473, -113},
    { -851, 386, -78},
    { -886, 362, -59},
    { -796, 392, -45},
    { -744, 396, -58},
    { -750, 414, -62},
    { -779, 421, -56},
    { -811, 410, -65},
    { -856, 427, -90},
    { -905, 457, -110},
    { -955, 463, -115},
    { -914, 431, -86},
    { -1064, 447, -36},
    { -1068, 509, -51},
    { -999, 499, 27},
    { -961, 451, 18},
    { -752, 419, -8},
    { -857, 444, 25},
    { -909, 409, 75},
    { -885, 376, 99},
    { -835, 344, 123},
    { -760, 307, 120},
    { -767, 296, 143},
    { -763, 289, 170},
    { -773, 310, 156},
    { -796, 343, 134},
    { -853, 329, 167},
    { -913, 337, 137},
    { -966, 368, 124},
    { -1257, 386, 184},
    { -891, 391, -52},
    { -823, 535, -266},
    { -770, 518, -245},
    { -864, 431, -138},
    { -955, 288, -95},
    { -936, 358, -128},
    { -833, 497, -102},
    { -782, 576, -113},
    { -774, 534, -104},
    { -798, 395, -78},
    { -801, 330, -25},
    { -849, 397, -49},
    { -879, 440, -35},
    { -875, 421, 0},
    { -841, 395, 46},
    { -983, 424, 95},
    { -1097, 478, 126},
    { -983, 499, 146},
    { -854, 450, 37},
    { -674, 450, 43},
    { -906, 448, 80},
    { -965, 379, 158},
    { -882, 328, 162},
    { -835, 354, 136},
    { -857, 347, 171},
    { -828, 307, 190},
    { -841, 307, 192},
    { -855, 339, 173},
    { -863, 323, 195},
    { -876, 319, 192},
    { -888, 320, 150},
    { -841, 343, 63},
    { -918, 377, 11},
    { -1145, 392, 66},
    { -866, 384, -129},
    { -768, 485, -290},
    { -796, 530, -255},
    { -900, 510, -141},
    { -970, 376, -113},
    { -891, 346, -100},
    { -797, 395, -38},
    { -774, 526, -58},
    { -837, 453, -35},
    { -840, 405, 9},
    { -844, 380, 31},
    { -854, 443, 22},
    { -892, 420, 43},
    { -889, 378, 65},
    { -872, 362, 99},
    { -841, 375, 101},
    { -1106, 546, 141},
    { -936, 614, 132},
    { -945, 643, 140},
    { -825, 713, 168},
    { -854, 725, 255},
    { -891, 784, 293},
    { -835, 912, 310},
    { -788, 924, 269},
    { -691, 953, 207},
    { -603, 999, 171},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



// ----------------------------------------------------------------
// Sample captured: 2015-08-06 18:38:11 GMT
AccelRawData *activity_sample_working_at_desk(int *len) {
  static AccelRawData samples[] = {
    { -26, -168, -982},
    { 26, -185, -984},
    { 34, -211, -990},
    { -2, -202, -984},
    { -49, -183, -967},
    { -67, -189, -990},
    { -82, -161, -985},
    { -117, -178, -989},
    { -196, -174, -977},
    { -73, -168, -1009},
    { 125, -180, -1016},
    { -24, -136, -968},
    { -58, -16, -892},
    { 101, -184, -1011},
    { 57, -143, -977},
    { 66, -157, -1015},
    { 67, -156, -1000},
    { 99, -140, -955},
    { 125, -138, -978},
    { 112, -150, -1003},
    { 95, -164, -988},
    { 58, -182, -961},
    { 98, -139, -996},
    { 99, -78, -1005},
    { 103, -25, -1017},
    { 102, -29, -1056},
    { 24, -66, -990},
    { -52, -58, -977},
    { 0, -20, -1012},
    { 111, 187, -1034},
    { 168, 268, -1005},
    { 249, 340, -880},
    { 285, 507, -904},
    { 359, 517, -824},
    { 448, 496, -739},
    { 503, 337, -726},
    { 471, 481, -724},
    { 446, 562, -771},
    { 456, 543, -751},
    { 481, 495, -754},
    { 450, 533, -774},
    { 402, 502, -780},
    { 362, 450, -867},
    { 377, 387, -826},
    { 326, 488, -991},
    { 376, 386, -978},
    { 400, 351, -887},
    { 283, 363, -904},
    { 208, 337, -833},
    { 178, 354, -865},
    { 35, 456, -1089},
    { 169, 358, -944},
    { 174, 280, -918},
    { 218, 325, -944},
    { 193, 383, -920},
    { 268, 350, -925},
    { 287, 356, -919},
    { 308, 397, -905},
    { 399, 369, -937},
    { 234, 369, -963},
    { 168, 15, -380},
    { 185, 643, -1048},
    { 170, 661, -882},
    { 160, 382, -859},
    { 165, 392, -898},
    { 198, 375, -882},
    { 229, 430, -881},
    { 240, 498, -912},
    { 270, 357, -900},
    { 285, 381, -886},
    { 280, 382, -895},
    { 228, 297, -915},
    { 225, 434, -903},
    { 225, 465, -870},
    { 187, 404, -900},
    { 187, 354, -903},
    { 227, 415, -900},
    { 239, 495, -918},
    { 196, 230, -901},
    { 215, 349, -900},
    { 248, 502, -873},
    { 228, 454, -882},
    { 218, 365, -895},
    { 215, 391, -898},
    { 225, 418, -893},
    { 216, 432, -887},
    { 225, 393, -913},
    { 228, 386, -899},
    { -223, 386, -913},
    { 224, 339, -895},
    { 264, 312, -899},
    { 309, 368, -925},
    { 358, 324, -894},
    { 337, 345, -954},
    { 291, 343, -910},
    { 267, 422, -901},
    { 254, 432, -883},
    { 237, 398, -874},
    { 242, 427, -866},
    { 250, 400, -880},
    { 227, 459, -884},
    { 245, 395, -884},
    { 173, 343, -859},
    { 299, 357, -902},
    { 389, 315, -927},
    { 276, 394, -903},
    { 251, 404, -903},
    { 219, 410, -875},
    { 235, 407, -894},
    { 257, 366, -891},
    { 262, 428, -893},
    { 250, 393, -888},
    { 255, 430, -883},
    { 251, 372, -890},
    { 265, 404, -879},
    { 267, 417, -881},
    { 253, 392, -883},
    { 258, 405, -889},
    { 254, 405, -883},
    { 259, 387, -878},
    { 258, 427, -885},
    { 265, 432, -906},
    { 319, 382, -891},
    { 370, 280, -923},
    { 380, 340, -960},
    { 285, 320, -947},
    { 389, 100, 4},
    { 90, 377, -947},
    { 30, 452, -861},
    { 97, 318, -887},
    { 214, 393, -914},
    { 272, 301, -937},
    { 327, 266, -944},
    { 338, 337, -924},
    { 304, 442, -893},
    { 234, 309, -923},
    { 280, 374, -872},
    { 287, 514, -875},
    { 230, 263, -908},
    { 258, 356, -900},
    { 259, 371, -889},
    { 261, 393, -897},
    { 250, 325, -909},
    { 268, 381, -908},
    { 277, 383, -904},
    { 256, 356, -906},
    { 260, 364, -905},
    { 262, 377, -901},
    { 263, 370, -901},
    { 256, 362, -903},
    { 258, 357, -901},
    { 270, 380, -895},
    { 256, 369, -899},
    { 264, 367, -904},
    { 256, 371, -895},
    { 249, 377, -892},
    { 272, 363, -902},
    { 255, 374, -896},
    { 266, 378, -889},
    { 272, 374, -899},
    { 265, 378, -902},
    { 265, 387, -900},
    { 264, 378, -904},
    { 267, 360, -901},
    { 275, 395, -902},
    { 252, 545, -995},
    { 197, 524, -895},
    { 375, 917, -881},
    { 406, 533, -706},
    { 363, 223, -753},
    { 350, 175, -682},
    { 205, 68, -1111},
    { 219, -17, -1334},
    { 94, -285, -948},
    { 197, 129, -1061},
    { 224, 218, -927},
    { 281, 276, -938},
    { 329, 211, -921},
    { 358, 215, -945},
    { 354, 218, -980},
    { 386, 274, -1056},
    { 355, 230, -838},
    { 358, 165, -712},
    { 330, 263, -918},
    { 314, 239, -990},
    { 308, 237, -952},
    { 278, 224, -864},
    { 266, 172, -976},
    { 262, 198, -1051},
    { 259, 85, -1023},
    { 196, -4, -1014},
    { 256, 323, -870},
    { 198, 128, -867},
    { 320, 158, -1036},
    { 294, 190, -985},
    { 264, 129, -913},
    { 367, 315, -904},
    { 401, 296, -920},
    { 385, 300, -855},
    { 329, 232, -925},
    { 298, 158, -942},
    { 305, 197, -942},
    { 326, 245, -937},
    { 302, 209, -931},
    { 308, 257, -914},
    { 298, 253, -945},
    { 299, 201, -945},
    { 301, 214, -948},
    { 310, 233, -930},
    { 329, 260, -929},
    { 322, 278, -927},
    { 306, 209, -930},
    { 303, 229, -929},
    { 315, 249, -930},
    { 303, 234, -936},
    { 299, 236, -929},
    { 309, 244, -933},
    { 308, 244, -926},
    { 302, 250, -938},
    { 304, 261, -937},
    { 304, 231, -932},
    { 302, 228, -931},
    { 304, 239, -939},
    { 307, 248, -936},
    { 303, 243, -930},
    { 303, 244, -935},
    { 300, 247, -933},
    { 304, 253, -930},
    { 299, 248, -932},
    { 304, 250, -934},
    { 301, 248, -932},
    { 301, 249, -931},
    { 302, 249, -933},
    { 300, 260, -935},
    { 300, 254, -932},
    { 297, 257, -927},
    { 305, 253, -928},
    { 302, 247, -930},
    { 298, 250, -926},
    { 303, 250, -932},
    { 304, 256, -928},
    { 304, 250, -931},
    { 295, 242, -928},
    { 300, 252, -932},
    { 307, 250, -932},
    { 302, 247, -927},
    { 301, 250, -927},
    { 302, 248, -936},
    { 306, 269, -947},
    { 294, 224, -934},
    { 307, 260, -947},
    { 320, 238, -944},
    { 330, 225, -942},
    { 333, 213, -951},
    { 327, 213, -952},
    { 325, 240, -950},
    { 313, 215, -924},
    { 307, 180, -921},
    { 216, 244, -977},
    { 291, 208, -910},
    { 261, 237, -920},
    { 265, 221, -939},
    { 283, 216, -965},
    { 289, 189, -962},
    { 301, 199, -951},
    { 313, 222, -969},
    { 308, 228, -971},
    { 303, 270, -978},
    { 328, 283, -1001},
    { 269, 162, -929},
    { 347, 178, -875},
    { 330, 166, -872},
    { 313, 177, -858},
    { 302, 162, -858},
    { 259, 218, -998},
    { 299, 212, -967},
    { 258, 281, -1041},
    { 278, 219, -959},
    { 321, 212, -921},
    { 305, 260, -953},
    { 269, 178, -905},
    { 367, 247, -1049},
    { 329, 250, -935},
    { 322, 232, -956},
    { 327, 229, -930},
    { 346, 231, -929},
    { 366, 229, -915},
    { 333, 243, -927},
    { 316, 229, -917},
    { 315, 216, -937},
    { 318, 224, -942},
    { 323, 236, -926},
    { 318, 218, -924},
    { 318, 217, -945},
    { 350, -43, -941},
    { 255, 221, -939},
    { 322, 222, -916},
    { 370, 173, -920},
    { 376, 227, -941},
    { 335, 235, -945},
    { 317, 235, -943},
    { 313, 220, -936},
    { 323, 217, -947},
    { 346, 214, -946},
    { 322, 223, -919},
    { 295, 200, -923},
    { 302, 211, -924},
    { 311, 214, -926},
    { 320, 222, -929},
    { 325, 226, -929},
    { 325, 206, -935},
    { 318, 215, -938},
    { 324, 226, -935},
    { 323, 221, -933},
    { 322, 220, -932},
    { 321, 226, -935},
    { 332, 224, -939},
    { 338, 229, -957},
    { 332, 214, -947},
    { 342, 192, -960},
    { 371, 206, -963},
    { 348, 203, -947},
    { 337, 205, -935},
    { 363, 217, -905},
    { 328, 185, -911},
    { 331, 187, -903},
    { 308, 176, -914},
    { 163, 222, -942},
    { 274, 205, -934},
    { 267, 187, -906},
    { 274, 162, -937},
    { 197, 194, -1046},
    { 348, 176, -1006},
    { 346, 167, -960},
    { 318, 173, -958},
    { 291, 183, -952},
    { 288, 183, -933},
    { 265, 204, -943},
    { 276, 150, -950},
    { 296, 152, -973},
    { 319, 122, -971},
    { 352, 95, -1000},
    { 386, 329, -931},
    { 171, 32, -904},
    { 161, 201, -776},
    { 246, 144, -1125},
    { 270, 81, -972},
    { 79, 256, -1005},
    { 349, 154, -938},
    { 307, 189, -896},
    { 324, 222, -939},
    { 326, 199, -930},
    { 325, 155, -943},
    { 332, 192, -926},
    { 377, 231, -919},
    { 424, 264, -875},
    { 348, 261, -914},
    { 306, 254, -934},
    { 286, 238, -934},
    { 290, 225, -933},
    { 312, 233, -943},
    { 326, 252, -941},
    { 303, 263, -920},
    { 295, 252, -922},
    { 310, 247, -927},
    { 298, 280, -927},
    { 293, 264, -925},
    { 293, 261, -921},
    { 300, 263, -933},
    { 294, 275, -927},
    { 290, 272, -940},
    { 294, 253, -967},
    { 268, 131, -937},
    { 177, 60, -989},
    { 225, 355, -951},
    { 285, 276, -992},
    { 312, 284, -922},
    { 294, 394, -964},
    { 330, 400, -838},
    { 291, 289, -722},
    { 304, 515, -815},
    { 327, 558, -755},
    { 302, 551, -820},
    { 326, 611, -836},
    { 331, 498, -808},
    { 329, 426, -832},
    { 292, 418, -933},
    { 300, 313, -955},
    { 344, 278, -971},
    { 354, 328, -967},
    { 307, 332, -875},
    { 326, 402, -808},
    { 230, 410, -846},
    { 218, 359, -760},
    { 197, 356, -879},
    { 261, 303, -951},
    { 361, 305, -984},
    { 364, 254, -969},
    { 302, 383, -917},
    { 269, 312, -912},
    { 266, 320, -912},
    { 289, 403, -909},
    { 301, 422, -907},
    { 265, 344, -924},
    { 239, 344, -910},
    { 208, 369, -915},
    { 304, 273, -937},
    { 391, 285, -931},
    { 360, 308, -920},
    { 322, 350, -909},
    { 319, 298, -931},
    { 253, 278, -968},
    { 192, 307, -859},
    { 119, 388, -905},
    { 121, 232, -1012},
    { 269, 196, -923},
    { 449, 339, -947},
    { 423, 249, -926},
    { 349, 361, -923},
    { 269, 337, -930},
    { 226, 327, -825},
    { 185, 312, -973},
    { 260, 218, -968},
    { 291, 328, -920},
    { 263, 300, -922},
    { 286, 283, -938},
    { 300, 403, -895},
    { 248, 303, -898},
    { 284, 301, -913},
    { 301, 313, -950},
    { 279, 303, -913},
    { 260, 307, -895},
    { 264, 310, -916},
    { 283, 334, -920},
    { 295, 317, -928},
    { 292, 324, -946},
    { 294, 329, -945},
    { 326, 346, -997},
    { 329, 311, -961},
    { 351, 242, -928},
    { 349, 348, -910},
    { 308, 269, -799},
    { 313, 209, -749},
    { 269, 253, -822},
    { 247, 359, -947},
    { 235, 308, -918},
    { 217, 401, -996},
    { 222, 269, -966},
    { 249, 307, -949},
    { 332, 585, -1076},
    { 546, 718, -1112},
    { 797, 669, -879},
    { 730, 573, -865},
    { 723, 550, -690},
    { 662, 588, -685},
    { 534, 485, -714},
    { 430, 377, -705},
    { 484, 252, -701},
    { 456, 247, -758},
    { 362, 439, -760},
    { 273, 423, -790},
    { 177, 345, -778},
    { 162, 327, -758},
    { 46, 331, -831},
    { 2, 365, -768},
    { -80, 323, -716},
    { -93, 576, -775},
    { -108, 646, -677},
    { -91, 647, -637},
    { -119, 676, -621},
    { -166, 732, -539},
    { -179, 840, -588},
    { -218, 742, -564},
    { -219, 900, -527},
    { -186, 868, -521},
    { -189, 889, -475},
    { -210, 890, -355},
    { -205, 889, -428},
    { -199, 909, -410},
    { -207, 904, -398},
    { -176, 923, -392},
    { -187, 942, -372},
    { -199, 910, -329},
    { -196, 947, -364},
    { -193, 952, -386},
    { -198, 954, -438},
    { -290, 975, -499},
    { -262, 839, -340},
    { -346, 935, -449},
    { -306, 1221, -462},
    { -260, 1264, -427},
    { -305, 1086, -428},
    { -195, 1092, -322},
    { -254, 945, -267},
    { -139, 785, -356},
    { -11, 860, -364},
    { -103, 750, -255},
    { 180, 739, -487},
    { 157, 708, -413},
    { 322, 695, -452},
    { 384, 616, -540},
    { 492, 614, -560},
    { 534, 512, -676},
    { 589, 462, -649},
    { 649, 368, -736},
    { 694, 327, -750},
    { 717, 253, -746},
    { 702, 234, -782},
    { 695, 173, -743},
    { 687, 112, -752},
    { 699, 104, -744},
    { 680, 84, -724},
    { 657, 40, -731},
    { 668, 10, -748},
    { 647, -48, -757},
    { 647, -38, -760},
    { 668, -69, -780},
    { 650, -107, -785},
    { 666, -125, -760},
    { 662, -112, -798},
    { 660, -156, -780},
    { 663, -191, -774},
    { 661, -201, -796},
    { 669, -213, -780},
    { 658, -259, -768},
    { 649, -261, -760},
    { 644, -259, -765},
    { 639, -279, -738},
    { 622, -276, -757},
    { 626, -290, -742},
    { 623, -300, -751},
    { 620, -309, -747},
    { 619, -315, -743},
    { 619, -327, -739},
    { 619, -347, -739},
    { 621, -345, -734},
    { 635, -342, -741},
    { 619, -345, -748},
    { 618, -351, -749},
    { 628, -349, -747},
    { 626, -348, -746},
    { 627, -367, -748},
    { 627, -377, -726},
    { 622, -368, -718},
    { 626, -386, -733},
    { 612, -381, -725},
    { 618, -393, -720},
    { 620, -391, -721},
    { 637, -398, -728},
    { 618, -409, -723},
    { 622, -402, -710},
    { 624, -409, -714},
    { 618, -405, -703},
    { 609, -409, -690},
    { 615, -417, -692},
    { 607, -404, -684},
    { 606, -414, -675},
    { 614, -392, -672},
    { 614, -391, -697},
    { 616, -360, -701},
    { 620, -352, -719},
    { 636, -326, -731},
    { 638, -295, -733},
    { 649, -260, -723},
    { 647, -230, -760},
    { 663, -180, -735},
    { 659, -166, -733},
    { 675, -100, -732},
    { 692, -59, -721},
    { 701, -35, -695},
    { 687, 35, -700},
    { 691, 48, -619},
    { 676, 144, -589},
    { 677, 243, -603},
    { 690, 369, -574},
    { 682, 456, -582},
    { 666, 528, -631},
    { 638, 584, -662},
    { 615, 624, -649},
    { 571, 669, -649},
    { 591, 753, -647},
    { 565, 769, -678},
    { 576, 663, -649},
    { 523, 622, -646},
    { 473, 677, -729},
    { 429, 708, -601},
    { 236, 744, -733},
    { 158, 526, -676},
    { 143, 529, -655},
    { 163, 480, -591},
    { 221, 488, -654},
    { 276, 519, -668},
    { 300, 475, -767},
    { 328, 615, -911},
    { 348, 704, -984},
    { 372, 615, -925},
    { 353, 611, -950},
    { 323, 522, -893},
    { 292, 461, -943},
    { 265, 391, -965},
    { 236, 411, -975},
    { 136, 333, -993},
    { 44, 280, -1028},
    { -82, 222, -986},
    { -171, 326, -947},
    { -39, 354, -973},
    { -23, 362, -942},
    { -60, 354, -922},
    { -69, 361, -891},
    { -75, 367, -926},
    { -66, 356, -943},
    { -71, 356, -932},
    { -75, 368, -914},
    { -81, 381, -924},
    { -96, 362, -915},
    { -89, 344, -892},
    { -103, 369, -917},
    { -95, 362, -900},
    { -100, 361, -908},
    { -101, 352, -917},
    { -95, 353, -919},
    { -76, 334, -921},
    { -71, 345, -932},
    { -96, 349, -933},
    { -68, 353, -918},
    { -53, 344, -897},
    { -50, 366, -891},
    { -26, 357, -893},
    { -12, 351, -903},
    { 20, 375, -941},
    { 10, 376, -932},
    { 10, 396, -910},
    { 62, 406, -964},
    { 50, 392, -960},
    { 64, 408, -1120},
    { -33, 152, -1313},
    { -74, 422, -1274},
    { -195, 543, -1758},
    { 36, 285, -1299},
    { 330, -35, -741},
    { 446, 260, -651},
    { 591, 357, -440},
    { 207, 515, -462},
    { -241, 345, -788},
    { -433, 796, -1186},
    { -281, 52, -900},
    { -98, -86, -1034},
    { -112, -459, -891},
    { -248, -620, -734},
    { -279, -628, -641},
    { -57, 104, -613},
    { 312, 734, -266},
    { 377, 927, -444},
    { 380, 1260, -673},
    { 258, 759, -470},
    { 725, 1191, -509},
    { 94, 1108, -526},
    { 268, 449, -514},
    { 249, 1047, -675},
    { 244, 750, -448},
    { 236, 847, -546},
    { 224, 781, -571},
    { 213, 748, -609},
    { 180, 758, -600},
    { 210, 825, -581},
    { 229, 808, -599},
    { 215, 793, -615},
    { 209, 722, -639},
    { 149, 759, -669},
    { 171, 682, -690},
    { 158, 651, -669},
    { 190, 720, -687},
    { 142, 667, -675},
    { 215, 721, -748},
    { 177, 767, -714},
    { 163, 634, -678},
    { 113, 608, -666},
    { 141, 673, -686},
    { 195, 744, -716},
    { 186, 759, -683},
    { 163, 675, -691},
    { 144, 589, -724},
    { 150, 609, -725},
    { 160, 666, -683},
    { 186, 831, -716},
    { 220, 810, -701},
    { 207, 744, -658},
    { 129, 491, -735},
    { 134, 681, -701},
    { 154, 758, -660},
    { 180, 677, -746},
    { 176, 651, -756},
    { 177, 651, -675},
    { 150, 680, -683},
    { 173, 680, -747},
    { 227, 780, -723},
    { 178, 739, -716},
    { 136, 561, -734},
    { 142, 623, -662},
    { 205, 725, -692},
    { 196, 781, -685},
    { 166, 647, -706},
    { 131, 655, -686},
    { 185, 754, -674},
    { 185, 718, -740},
    { 169, 708, -709},
    { 172, 656, -730},
    { 166, 657, -662},
    { 178, 718, -719},
    { 181, 652, -719},
    { 174, 677, -711},
    { 168, 659, -680},
    { 142, 679, -687},
    { 179, 662, -741},
    { 182, 662, -748},
    { 198, 677, -734},
    { 206, 698, -750},
    { 191, 718, -746},
    { 102, 452, -699},
    { 133, 653, -718},
    { 167, 699, -714},
    { 192, 680, -789},
    { 173, 571, -829},
    { 192, 655, -726},
    { 150, 594, -911},
    { 83, 685, -865},
    { 125, 869, -924},
    { 186, 925, -917},
    { 86, 380, -785},
    { 183, 263, -732},
    { 106, 4, -622},
    { -47, 27, -830},
    { -272, 194, -1011},
    { -247, -46, -1182},
    { -8, 197, -1166},
    { 131, 213, -1150},
    { 138, 95, -975},
    { 228, 306, -882},
    { 304, 260, -824},
    { 258, 183, -782},
    { 239, 104, -879},
    { 226, 64, -945},
    { 145, 78, -1006},
    { 8, -172, -940},
    { -80, -254, -967},
    { -161, -333, -997},
    { -178, -481, -976},
    { -214, -405, -1138},
    { -154, -458, -1102},
    { -19, -162, -1051},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-09-05 19:50:54 local
AccelRawData *activity_sample_not_moving(int *len) {
  static AccelRawData samples[] = {
    { 88, 8, -1000},
    { 88, 16, -1000},
    { 80, 16, -1000},
    { 88, 16, -1000},
    { 88, 16, -1000},
    { 88, 16, -992},
    { 80, 16, -1000},
    { 88, 8, -1000},
    { 88, 0, -1000},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 88, 16, -1008},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 88, 16, -1000},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 24, -1000},
    { 80, 24, -1000},
    { 80, 8, -1000},
    { 80, 8, -1000},
    { 80, 32, -992},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 24, -992},
    { 80, 24, -992},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 24, -992},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 80, 24, -1000},
    { 72, 16, -1000},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 72, 24, -1008},
    { 72, 8, -1000},
    { 80, 24, -1000},
    { 72, 24, -992},
    { 80, 16, -1000},
    { 80, 24, -1000},
    { 80, 24, -1000},
    { 72, 16, -1000},
    { 80, 24, -1000},
    { 80, 24, -1000},
    { 72, 24, -1000},
    { 80, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 24, -1000},
    { 80, 24, -1008},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 72, 8, -1008},
    { 72, 32, -1000},
    { 72, 16, -992},
    { 80, 24, -992},
    { 72, 24, -1000},
    { 80, 16, -1000},
    { 72, 16, -992},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 80, 16, -1000},
    { 72, 16, -1008},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 8, -1000},
    { 72, 24, -1000},
    { 72, 8, -1000},
    { 80, 8, -1008},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 8, -1000},
    { 72, 24, -1000},
    { 80, 16, -1000},
    { 72, 8, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 24, -1000},
    { 80, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 8, -1000},
    { 80, 24, -1000},
    { 72, 24, -1000},
    { 72, 8, -1000},
    { 72, 24, -1000},
    { 72, 16, -1008},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 24, -1008},
    { 72, 16, -1000},
    { 64, 24, -992},
    { 72, 8, -1008},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1008},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 32, -1000},
    { 64, 16, -1000},
    { 72, 24, -992},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 64, 24, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -992},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 72, 16, -1000},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 64, 32, -1000},
    { 64, 16, -1000},
    { 72, 16, -1000},
    { 64, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 8, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 64, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 72, 16, -1000},
    { 72, 8, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 8, -1000},
    { 64, 16, -1000},
    { 64, 32, -992},
    { 64, 8, -1000},
    { 72, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1008},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 72, 24, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1008},
    { 64, 24, -1000},
    { 64, 24, -1008},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 72, 16, -1000},
    { 64, 16, -992},
    { 64, 24, -992},
    { 64, 24, -1000},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 32, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1008},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1008},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1008},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 32, -992},
    { 64, 8, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 72, 16, -1000},
    { 64, 24, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 72, 16, -1008},
    { 64, 16, -1000},
    { 64, 16, -1008},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 72, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1008},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 8, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 8, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 32, -992},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -992},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -992},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 8, -1008},
    { 64, 32, -1000},
    { 64, 8, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -992},
    { 56, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1008},
    { 56, 32, -992},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 64, 24, -992},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1008},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1008},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -992},
    { 56, 24, -1000},
    { 64, 8, -992},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 8, -1008},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -992},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 32, -992},
    { 56, 24, -992},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 56, 32, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -992},
    { 64, 24, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -992},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 16, -992},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 56, 16, -1000},
    { 64, 0, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1008},
    { 64, 16, -1008},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 8, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1008},
    { 64, 24, -1008},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1008},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1008},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1008},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 8, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 64, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 32, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1008},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 8, -1000},
    { 64, 16, -1000},
    { 64, 24, -1008},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 8, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -992},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 64, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1008},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 8, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 24, -992},
    { 56, 8, -1000},
    { 56, 32, -1000},
    { 56, 8, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 8, -1008},
    { 56, 32, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -992},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 64, 16, -1008},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1008},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 24, -992},
    { 64, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 32, -1008},
    { 56, 24, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 32, -992},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -992},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 8, -1008},
    { 56, 32, -992},
    { 56, 8, -1000},
    { 64, 16, -992},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 32, -1000},
    { 56, 8, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 8, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -992},
    { 56, 16, -992},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 8, -1008},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 8, -1008},
    { 48, 24, -992},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 40, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 8, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -992},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 40, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 48, 24, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



