/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#include <stdint.h>
#include <string.h>

#include "applib/accel_service.h"


// ----------------------------------------------------------------
// Sample captured: 2015-08-06 13:31:28 GMT
AccelRawData *activity_sample_30_steps(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_30
  //> TEST_EXPECTED 30
  //> TEST_EXPECTED_MIN 25
  //> TEST_EXPECTED_MAX 33
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    { -42, -52, -1027},
    { -43, -29, -1054},
    { -76, 12, -975},
    { -72, -17, -906},
    { -64, -40, -892},
    { -81, -37, -933},
    { -77, -15, -1008},
    { -83, 0, -1041},
    { -81, -27, -1029},
    { -80, -57, -993},
    { -97, -27, -973},
    { -119, -21, -991},
    { -120, -19, -1011},
    { -115, -27, -978},
    { -106, -44, -953},
    { -104, -62, -946},
    { -150, -90, -962},
    { -148, -66, -991},
    { -164, -101, -980},
    { -162, -102, -975},
    { -223, -67, -966},
    { -251, -84, -971},
    { -118, -134, -968},
    { -159, -54, -956},
    { -160, -125, -958},
    { -102, -152, -963},
    { -39, -154, -974},
    { 63, -317, -986},
    { -61, -190, -1000},
    { -131, -306, -1022},
    { -189, -295, -844},
    { -224, -317, -694},
    { -243, -177, -563},
    { -420, 58, -499},
    { -677, 416, -469},
    { -796, 908, -426},
    { -844, 1100, -288},
    { -762, 824, -233},
    { -813, 1019, -270},
    { -816, 1041, -119},
    { -865, 914, -6},
    { -848, 872, 24},
    { -817, 776, 42},
    { -765, 655, 14},
    { -804, 635, -20},
    { -839, 657, 13},
    { -874, 659, -1},
    { -926, 587, -19},
    { -976, 510, -31},
    { -937, 466, -78},
    { -1187, 483, 24},
    { -1046, 482, -87},
    { -1071, 566, -238},
    { -884, 460, -301},
    { -844, 144, -211},
    { -880, 213, -78},
    { -972, -2, 38},
    { -786, 53, 32},
    { -739, 232, -12},
    { -695, 344, -61},
    { -706, 394, -72},
    { -743, 351, -67},
    { -775, 334, -58},
    { -819, 333, -45},
    { -869, 365, -70},
    { -833, 405, -36},
    { -1466, 634, 18},
    { -1132, 698, -39},
    { -849, 548, -59},
    { -1073, 483, -47},
    { -970, 540, -84},
    { -883, 458, -35},
    { -781, 364, -41},
    { -732, 345, -40},
    { -751, 324, 2},
    { -752, 287, 42},
    { -727, 285, 29},
    { -718, 304, 44},
    { -813, 325, 79},
    { -903, 335, 75},
    { -880, 323, 4},
    { -1093, 404, 57},
    { -1177, 388, 76},
    { -1098, 513, -82},
    { -892, 549, -256},
    { -739, 484, -199},
    { -695, 337, -82},
    { -846, 302, 0},
    { -787, 298, 24},
    { -712, 392, 29},
    { -733, 439, -20},
    { -740, 464, -49},
    { -739, 450, -50},
    { -752, 411, -87},
    { -837, 438, -93},
    { -961, 453, -73},
    { -994, 442, -23},
    { -1059, 466, 2},
    { -1222, 594, 33},
    { -997, 552, 30},
    { -873, 477, -30},
    { -850, 443, 32},
    { -894, 421, 62},
    { -891, 367, 102},
    { -873, 322, 164},
    { -865, 316, 181},
    { -804, 364, 150},
    { -757, 337, 158},
    { -714, 338, 110},
    { -721, 405, 71},
    { -721, 419, 53},
    { -725, 400, 35},
    { -737, 373, 55},
    { -752, 386, 57},
    { -865, 451, 64},
    { -928, 486, 99},
    { -1113, 519, 257},
    { -1147, 531, 305},
    { -1069, 693, 49},
    { -815, 808, -126},
    { -679, 568, -43},
    { -748, 421, 29},
    { -886, 316, 59},
    { -906, 306, 26},
    { -846, 369, 0},
    { -843, 404, -15},
    { -828, 396, -2},
    { -826, 358, 23},
    { -755, 300, 41},
    { -700, 305, 46},
    { -747, 377, 28},
    { -794, 416, 47},
    { -1102, 470, 161},
    { -1303, 549, 281},
    { -1194, 656, 238},
    { -709, 508, 77},
    { -734, 453, 115},
    { -739, 456, 199},
    { -781, 422, 258},
    { -758, 330, 258},
    { -708, 344, 240},
    { -780, 317, 285},
    { -817, 324, 263},
    { -829, 355, 210},
    { -858, 364, 164},
    { -906, 377, 157},
    { -923, 359, 98},
    { -887, 352, 9},
    { -1061, 369, 100},
    { -1180, 384, 148},
    { -922, 410, 5},
    { -778, 464, -90},
    { -770, 444, -26},
    { -841, 375, 6},
    { -837, 321, 52},
    { -757, 354, 58},
    { -745, 372, 36},
    { -737, 432, -16},
    { -759, 420, -26},
    { -783, 429, -53},
    { -824, 437, -80},
    { -883, 473, -85},
    { -907, 472, -54},
    { -856, 403, 17},
    { -1254, 537, 65},
    { -1046, 516, 93},
    { -1008, 479, 88},
    { -771, 420, 33},
    { -884, 437, 88},
    { -907, 417, 109},
    { -837, 382, 101},
    { -802, 361, 88},
    { -789, 363, 102},
    { -788, 318, 123},
    { -761, 264, 123},
    { -762, 273, 114},
    { -790, 335, 109},
    { -870, 325, 138},
    { -913, 337, 109},
    { -871, 357, 18},
    { -1159, 395, 84},
    { -1036, 382, 52},
    { -907, 491, -125},
    { -798, 533, -195},
    { -784, 460, -111},
    { -835, 375, -31},
    { -840, 327, -9},
    { -773, 403, -1},
    { -739, 434, -30},
    { -773, 450, -57},
    { -786, 449, -64},
    { -862, 447, -89},
    { -934, 463, -112},
    { -975, 473, -92},
    { -897, 430, -62},
    { -851, 399, -43},
    { -1183, 530, 30},
    { -984, 538, 30},
    { -940, 525, 39},
    { -779, 470, 31},
    { -915, 462, 97},
    { -916, 397, 174},
    { -881, 386, 167},
    { -840, 391, 157},
    { -766, 343, 177},
    { -755, 324, 191},
    { -769, 317, 192},
    { -807, 352, 193},
    { -821, 380, 179},
    { -916, 396, 179},
    { -928, 360, 144},
    { -871, 359, 34},
    { -1104, 362, 83},
    { -1048, 368, -61},
    { -819, 467, -296},
    { -747, 536, -384},
    { -840, 488, -258},
    { -858, 404, -178},
    { -831, 316, -141},
    { -734, 466, -161},
    { -715, 431, -110},
    { -760, 436, -88},
    { -762, 422, -44},
    { -726, 430, -46},
    { -778, 447, -31},
    { -872, 477, -16},
    { -987, 484, 33},
    { -962, 420, 126},
    { -1254, 472, 174},
    { -1012, 451, 128},
    { -1023, 473, 152},
    { -863, 461, 115},
    { -836, 440, 169},
    { -887, 418, 182},
    { -946, 397, 235},
    { -878, 358, 206},
    { -779, 327, 142},
    { -748, 269, 156},
    { -745, 232, 145},
    { -737, 260, 111},
    { -772, 324, 96},
    { -874, 366, 115},
    { -954, 347, 148},
    { -919, 360, 83},
    { -994, 403, 83},
    { -1132, 383, 116},
    { -907, 417, -30},
    { -861, 496, -124},
    { -853, 482, -98},
    { -822, 430, -71},
    { -876, 385, -36},
    { -836, 391, -41},
    { -742, 396, -49},
    { -721, 389, -60},
    { -735, 392, -67},
    { -753, 370, -68},
    { -803, 402, -92},
    { -871, 446, -113},
    { -954, 472, -109},
    { -941, 440, -62},
    { -1021, 428, -15},
    { -1181, 546, -10},
    { -979, 498, 48},
    { -970, 454, 18},
    { -808, 412, 6},
    { -925, 465, -8},
    { -942, 404, 39},
    { -851, 352, 49},
    { -788, 336, 43},
    { -760, 304, 71},
    { -755, 270, 106},
    { -744, 257, 119},
    { -724, 280, 111},
    { -745, 307, 103},
    { -874, 345, 116},
    { -948, 331, 95},
    { -958, 361, 58},
    { -1237, 397, 140},
    { -1129, 438, 48},
    { -948, 546, -138},
    { -796, 531, -202},
    { -748, 418, -147},
    { -886, 384, -85},
    { -855, 300, -62},
    { -760, 381, -50},
    { -739, 410, -87},
    { -748, 417, -89},
    { -741, 405, -79},
    { -772, 384, -87},
    { -857, 422, -101},
    { -937, 444, -100},
    { -926, 409, -69},
    { -1087, 440, -28},
    { -1202, 533, -44},
    { -928, 472, -23},
    { -904, 425, -81},
    { -781, 414, -98},
    { -934, 455, -72},
    { -974, 342, -20},
    { -927, 341, 31},
    { -833, 357, 6},
    { -759, 306, 20},
    { -772, 292, 64},
    { -784, 281, 90},
    { -770, 289, 75},
    { -769, 301, 64},
    { -791, 281, 84},
    { -865, 311, 77},
    { -905, 356, 34},
    { -928, 376, 34},
    { -1242, 424, 119},
    { -1062, 453, 58},
    { -963, 584, -126},
    { -810, 527, -67},
    { -812, 403, -9},
    { -880, 330, 21},
    { -792, 329, 40},
    { -692, 363, 0},
    { -689, 397, -46},
    { -698, 405, -71},
    { -710, 379, -79},
    { -795, 419, -102},
    { -892, 468, -119},
    { -1012, 491, -96},
    { -1024, 453, -41},
    { -1262, 560, -19},
    { -1120, 525, 57},
    { -1004, 434, 31},
    { -819, 398, 63},
    { -761, 405, 134},
    { -779, 464, 82},
    { -827, 455, 99},
    { -837, 389, 148},
    { -752, 410, 137},
    { -744, 386, 145},
    { -753, 364, 124},
    { -760, 335, 143},
    { -818, 328, 129},
    { -916, 308, 157},
    { -985, 295, 165},
    { -905, 312, 83},
    { -1069, 368, 131},
    { -1014, 358, 120},
    { -917, 443, -7},
    { -762, 490, -147},
    { -820, 544, -160},
    { -753, 418, -100},
    { -873, 373, -25},
    { -828, 364, -24},
    { -806, 406, -60},
    { -757, 431, -105},
    { -779, 418, -84},
    { -790, 383, -105},
    { -818, 393, -119},
    { -869, 437, -133},
    { -958, 461, -104},
    { -874, 410, -26},
    { -1208, 503, 46},
    { -1075, 527, 44},
    { -1014, 502, 99},
    { -824, 458, 24},
    { -782, 446, 43},
    { -865, 422, 82},
    { -919, 364, 130},
    { -861, 358, 110},
    { -805, 357, 114},
    { -762, 325, 130},
    { -742, 301, 138},
    { -749, 298, 147},
    { -748, 305, 139},
    { -820, 341, 119},
    { -918, 331, 138},
    { -959, 353, 88},
    { -1027, 388, 79},
    { -1112, 380, 70},
    { -941, 440, -98},
    { -921, 522, -223},
    { -848, 539, -239},
    { -787, 394, -149},
    { -890, 329, -70},
    { -888, 341, -52},
    { -802, 381, -61},
    { -742, 399, -88},
    { -739, 403, -76},
    { -741, 364, -54},
    { -778, 357, -64},
    { -824, 402, -103},
    { -912, 451, -105},
    { -893, 426, -70},
    { -854, 394, -25},
    { -1267, 545, 34},
    { -982, 546, 27},
    { -927, 455, 9},
    { -748, 444, -42},
    { -903, 476, 7},
    { -953, 465, 38},
    { -921, 406, 49},
    { -860, 382, 61},
    { -795, 328, 60},
    { -754, 280, 78},
    { -753, 287, 83},
    { -765, 291, 78},
    { -797, 304, 77},
    { -847, 303, 95},
    { -918, 302, 89},
    { -887, 346, 49},
    { -1206, 375, 146},
    { -995, 384, 52},
    { -932, 490, -80},
    { -823, 524, -140},
    { -810, 473, -113},
    { -851, 386, -78},
    { -886, 362, -59},
    { -796, 392, -45},
    { -744, 396, -58},
    { -750, 414, -62},
    { -779, 421, -56},
    { -811, 410, -65},
    { -856, 427, -90},
    { -905, 457, -110},
    { -955, 463, -115},
    { -914, 431, -86},
    { -1064, 447, -36},
    { -1068, 509, -51},
    { -999, 499, 27},
    { -961, 451, 18},
    { -752, 419, -8},
    { -857, 444, 25},
    { -909, 409, 75},
    { -885, 376, 99},
    { -835, 344, 123},
    { -760, 307, 120},
    { -767, 296, 143},
    { -763, 289, 170},
    { -773, 310, 156},
    { -796, 343, 134},
    { -853, 329, 167},
    { -913, 337, 137},
    { -966, 368, 124},
    { -1257, 386, 184},
    { -891, 391, -52},
    { -823, 535, -266},
    { -770, 518, -245},
    { -864, 431, -138},
    { -955, 288, -95},
    { -936, 358, -128},
    { -833, 497, -102},
    { -782, 576, -113},
    { -774, 534, -104},
    { -798, 395, -78},
    { -801, 330, -25},
    { -849, 397, -49},
    { -879, 440, -35},
    { -875, 421, 0},
    { -841, 395, 46},
    { -983, 424, 95},
    { -1097, 478, 126},
    { -983, 499, 146},
    { -854, 450, 37},
    { -674, 450, 43},
    { -906, 448, 80},
    { -965, 379, 158},
    { -882, 328, 162},
    { -835, 354, 136},
    { -857, 347, 171},
    { -828, 307, 190},
    { -841, 307, 192},
    { -855, 339, 173},
    { -863, 323, 195},
    { -876, 319, 192},
    { -888, 320, 150},
    { -841, 343, 63},
    { -918, 377, 11},
    { -1145, 392, 66},
    { -866, 384, -129},
    { -768, 485, -290},
    { -796, 530, -255},
    { -900, 510, -141},
    { -970, 376, -113},
    { -891, 346, -100},
    { -797, 395, -38},
    { -774, 526, -58},
    { -837, 453, -35},
    { -840, 405, 9},
    { -844, 380, 31},
    { -854, 443, 22},
    { -892, 420, 43},
    { -889, 378, 65},
    { -872, 362, 99},
    { -841, 375, 101},
    { -1106, 546, 141},
    { -936, 614, 132},
    { -945, 643, 140},
    { -825, 713, 168},
    { -854, 725, 255},
    { -891, 784, 293},
    { -835, 912, 310},
    { -788, 924, 269},
    { -691, 953, 207},
    { -603, 999, 171},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-08-06 15:10:23 GMT
AccelRawData *activity_sample_30_steps_hand_in_pocket(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_30_hand_in_pocket
  //> TEST_EXPECTED 30
  //> TEST_EXPECTED_MIN 25
  //> TEST_EXPECTED_MAX 35
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    { -293, 573, -734},
    { -306, 545, -747},
    { -280, 556, -746},
    { -294, 548, -745},
    { -310, 549, -733},
    { -270, 570, -747},
    { -251, 578, -744},
    { -265, 554, -740},
    { -235, 558, -754},
    { -258, 606, -735},
    { -259, 632, -724},
    { -266, 654, -742},
    { -253, 636, -747},
    { -303, 652, -712},
    { -269, 540, -702},
    { -199, 547, -776},
    { -276, 567, -752},
    { -294, 565, -750},
    { -198, 479, -808},
    { -293, 554, -716},
    { -343, 512, -657},
    { -385, 405, -659},
    { -958, 394, -186},
    { -440, 684, -694},
    { -385, 714, -636},
    { -382, 724, -570},
    { -211, 776, -518},
    { -158, 732, -522},
    { -148, 847, -536},
    { -221, 905, -497},
    { -361, 705, -367},
    { -465, 715, -380},
    { -504, 936, -596},
    { -715, 1204, -524},
    { -531, 949, -249},
    { -376, 593, -394},
    { -454, 627, -74},
    { -418, 834, 8},
    { -402, 1003, -42},
    { -394, 883, -69},
    { -377, 745, -45},
    { -323, 839, 9},
    { -355, 774, 34},
    { -487, 662, 26},
    { -537, 830, 59},
    { -552, 824, 43},
    { -531, 776, 25},
    { -548, 835, 144},
    { -610, 881, 139},
    { -439, 1162, 265},
    { -716, 1119, 22},
    { -690, 756, 31},
    { -889, 669, -9},
    { -963, 632, -12},
    { -844, 626, 39},
    { -667, 485, -50},
    { -481, 459, -127},
    { -405, 644, -178},
    { -361, 721, -238},
    { -252, 523, -269},
    { -175, 566, -325},
    { -313, 838, -429},
    { -563, 1197, -431},
    { -882, 1009, -503},
    { -577, 644, -495},
    { -722, 1237, -364},
    { -661, 705, -75},
    { -446, 495, -3},
    { -526, 687, -47},
    { -551, 606, -109},
    { -555, 624, -149},
    { -490, 738, -118},
    { -383, 809, -80},
    { -362, 824, -54},
    { -502, 911, -79},
    { -553, 722, -50},
    { -615, 742, -54},
    { -667, 835, -49},
    { -772, 763, -135},
    { -530, 866, 10},
    { -653, 1173, 27},
    { -664, 1114, -36},
    { -838, 588, -101},
    { -910, 447, -59},
    { -676, 596, -30},
    { -486, 649, -97},
    { -332, 654, -177},
    { -290, 624, -272},
    { -363, 632, -284},
    { -317, 635, -272},
    { -360, 840, -374},
    { -513, 1241, -449},
    { -570, 827, -443},
    { -502, 849, -442},
    { -534, 1254, -371},
    { -559, 726, -100},
    { -453, 604, -147},
    { -366, 818, -112},
    { -448, 692, -77},
    { -458, 681, -133},
    { -411, 748, -106},
    { -332, 798, -75},
    { -390, 806, -36},
    { -499, 849, -37},
    { -534, 806, 1},
    { -563, 910, -44},
    { -628, 909, -66},
    { -689, 765, -88},
    { -524, 924, 3},
    { -573, 1213, -33},
    { -509, 911, -77},
    { -657, 537, -51},
    { -934, 536, -114},
    { -1043, 730, -125},
    { -793, 567, -91},
    { -515, 458, -184},
    { -362, 430, -267},
    { -312, 521, -307},
    { -291, 666, -354},
    { -426, 700, -436},
    { -523, 822, -430},
    { -709, 1022, -538},
    { -557, 571, -575},
    { -709, 694, -524},
    { -710, 1507, -142},
    { -642, 742, -259},
    { -432, 369, 42},
    { -519, 627, -27},
    { -494, 731, -168},
    { -491, 625, -223},
    { -442, 773, -172},
    { -402, 875, -144},
    { -410, 784, -64},
    { -504, 735, -72},
    { -569, 708, -42},
    { -626, 876, -41},
    { -733, 847, -23},
    { -662, 866, 0},
    { -728, 1079, 52},
    { -754, 1014, 36},
    { -800, 739, -81},
    { -1002, 324, -122},
    { -957, 453, -5},
    { -740, 601, -69},
    { -487, 553, -143},
    { -350, 503, -231},
    { -358, 425, -333},
    { -365, 590, -352},
    { -410, 739, -443},
    { -535, 741, -458},
    { -629, 1004, -524},
    { -661, 606, -499},
    { -808, 687, -511},
    { -606, 1419, -207},
    { -648, 669, -237},
    { -379, 325, 54},
    { -529, 720, -76},
    { -528, 731, -181},
    { -585, 712, -186},
    { -506, 698, -100},
    { -459, 806, -66},
    { -437, 718, -29},
    { -467, 694, -41},
    { -546, 686, -43},
    { -625, 780, -63},
    { -720, 857, -29},
    { -805, 833, -151},
    { -610, 936, -33},
    { -684, 1228, 3},
    { -592, 909, 7},
    { -742, 536, -108},
    { -844, 357, -112},
    { -866, 535, -86},
    { -681, 648, -167},
    { -463, 638, -287},
    { -416, 606, -305},
    { -398, 633, -283},
    { -377, 626, -276},
    { -392, 645, -295},
    { -511, 776, -371},
    { -601, 949, -439},
    { -625, 663, -441},
    { -747, 837, -449},
    { -598, 1134, -244},
    { -566, 747, -310},
    { -409, 612, -100},
    { -344, 762, -80},
    { -446, 880, -129},
    { -481, 890, -193},
    { -483, 751, -129},
    { -494, 696, -90},
    { -501, 733, -19},
    { -484, 763, -1},
    { -455, 820, -53},
    { -510, 886, -83},
    { -580, 858, -81},
    { -657, 744, -142},
    { -514, 903, -134},
    { -528, 1209, -110},
    { -449, 1110, -112},
    { -591, 714, -244},
    { -735, 493, -140},
    { -905, 656, -73},
    { -752, 747, -86},
    { -545, 666, -141},
    { -440, 684, -289},
    { -412, 693, -296},
    { -392, 759, -241},
    { -468, 697, -183},
    { -519, 682, -153},
    { -562, 619, -210},
    { -532, 740, -372},
    { -480, 835, -309},
    { -345, 790, -421},
    { -765, 1006, -326},
    { -671, 1035, -291},
    { -793, 759, -376},
    { -341, 415, 16},
    { -534, 573, -137},
    { -498, 961, -282},
    { -478, 954, -182},
    { -434, 782, -72},
    { -420, 743, 22},
    { -483, 812, 53},
    { -536, 779, -4},
    { -516, 723, -52},
    { -573, 741, -51},
    { -703, 712, -70},
    { -723, 776, -109},
    { -550, 1089, -45},
    { -648, 1207, -74},
    { -548, 960, -143},
    { -697, 485, -196},
    { -776, 374, -104},
    { -879, 659, -95},
    { -751, 710, -157},
    { -496, 631, -168},
    { -375, 692, -271},
    { -404, 655, -361},
    { -405, 662, -252},
    { -478, 597, -294},
    { -509, 631, -307},
    { -604, 668, -354},
    { -606, 796, -423},
    { -457, 781, -566},
    { -691, 1100, -354},
    { -677, 868, -341},
    { -548, 523, -176},
    { -405, 584, -2},
    { -505, 847, -119},
    { -443, 880, -282},
    { -419, 874, -226},
    { -415, 766, -109},
    { -452, 743, -87},
    { -489, 680, -38},
    { -511, 751, -36},
    { -543, 835, -44},
    { -581, 879, -75},
    { -617, 873, -81},
    { -677, 863, -115},
    { -604, 996, -98},
    { -630, 1125, -130},
    { -536, 812, -127},
    { -656, 576, -151},
    { -834, 491, -104},
    { -960, 625, -60},
    { -771, 607, -98},
    { -551, 560, -216},
    { -431, 572, -293},
    { -397, 589, -362},
    { -410, 599, -343},
    { -430, 530, -323},
    { -494, 653, -373},
    { -515, 879, -429},
    { -571, 871, -526},
    { -572, 585, -566},
    { -900, 1208, -338},
    { -768, 732, -477},
    { -466, 266, -209},
    { -490, 401, 9},
    { -575, 815, -212},
    { -549, 726, -197},
    { -600, 667, -179},
    { -528, 668, -130},
    { -487, 757, -140},
    { -445, 661, -99},
    { -481, 652, -110},
    { -583, 712, -115},
    { -636, 782, -143},
    { -712, 861, -110},
    { -765, 830, -153},
    { -632, 952, -58},
    { -792, 1043, -100},
    { -694, 830, -90},
    { -778, 567, -136},
    { -910, 368, -170},
    { -970, 455, -98},
    { -806, 471, -106},
    { -584, 471, -149},
    { -410, 452, -257},
    { -361, 499, -375},
    { -338, 584, -458},
    { -425, 674, -526},
    { -549, 689, -540},
    { -769, 901, -544},
    { -634, 480, -604},
    { -925, 788, -519},
    { -679, 1130, -503},
    { -672, 450, -211},
    { -494, 364, 26},
    { -584, 820, -137},
    { -554, 679, -209},
    { -602, 652, -254},
    { -546, 694, -196},
    { -528, 755, -170},
    { -490, 636, -134},
    { -494, 642, -128},
    { -514, 684, -153},
    { -544, 778, -122},
    { -692, 882, -42},
    { -668, 870, -104},
    { -842, 1186, -194},
    { -822, 877, -140},
    { -827, 745, -173},
    { -926, 398, -254},
    { -924, 233, -194},
    { -812, 241, -144},
    { -660, 435, -191},
    { -496, 498, -260},
    { -405, 574, -383},
    { -388, 583, -447},
    { -454, 484, -417},
    { -586, 486, -465},
    { -749, 747, -518},
    { -713, 750, -546},
    { -457, 505, -711},
    { -970, 825, -373},
    { -688, 769, -302},
    { -691, 365, -196},
    { -570, 421, 64},
    { -579, 581, -144},
    { -641, 793, -257},
    { -621, 730, -210},
    { -565, 590, -116},
    { -536, 629, -111},
    { -522, 685, -143},
    { -481, 734, -176},
    { -511, 711, -224},
    { -599, 739, -178},
    { -744, 810, -84},
    { -795, 877, -150},
    { -776, 1011, -106},
    { -805, 1015, -124},
    { -736, 778, -74},
    { -890, 415, -152},
    { -954, 322, -160},
    { -890, 318, -96},
    { -695, 447, -123},
    { -479, 498, -228},
    { -348, 539, -356},
    { -325, 568, -500},
    { -352, 586, -497},
    { -502, 632, -512},
    { -678, 692, -539},
    { -721, 878, -493},
    { -558, 633, -713},
    { -816, 1033, -346},
    { -736, 891, -346},
    { -538, 439, -51},
    { -504, 546, 5},
    { -538, 740, -152},
    { -558, 693, -208},
    { -550, 661, -170},
    { -496, 734, -142},
    { -476, 763, -133},
    { -454, 684, -125},
    { -526, 625, -165},
    { -618, 645, -178},
    { -664, 733, -157},
    { -710, 940, -128},
    { -683, 946, -121},
    { -595, 1057, -109},
    { -790, 1111, -102},
    { -652, 752, -89},
    { -840, 511, -131},
    { -950, 258, -126},
    { -983, 424, -99},
    { -750, 473, -104},
    { -517, 480, -191},
    { -395, 514, -348},
    { -386, 558, -399},
    { -367, 577, -364},
    { -476, 505, -406},
    { -626, 547, -487},
    { -701, 881, -486},
    { -645, 623, -501},
    { -880, 596, -571},
    { -753, 1389, -369},
    { -869, 912, -317},
    { -474, 90, -65},
    { -497, 603, -79},
    { -608, 831, -274},
    { -526, 662, -283},
    { -541, 557, -231},
    { -539, 691, -229},
    { -529, 711, -213},
    { -494, 671, -197},
    { -494, 705, -205},
    { -542, 737, -224},
    { -606, 803, -157},
    { -725, 765, -86},
    { -731, 827, -157},
    { -757, 1049, -81},
    { -797, 1085, -141},
    { -839, 795, -146},
    { -944, 364, -118},
    { -871, 227, -83},
    { -808, 395, -49},
    { -660, 474, -105},
    { -496, 576, -224},
    { -417, 529, -323},
    { -384, 501, -415},
    { -430, 513, -513},
    { -495, 536, -513},
    { -654, 718, -527},
    { -717, 756, -519},
    { -541, 631, -654},
    { -955, 957, -420},
    { -722, 851, -404},
    { -546, 354, -132},
    { -497, 505, -20},
    { -546, 722, -148},
    { -580, 702, -166},
    { -578, 667, -234},
    { -510, 668, -199},
    { -463, 757, -183},
    { -471, 679, -111},
    { -528, 662, -141},
    { -584, 678, -149},
    { -653, 776, -149},
    { -716, 844, -147},
    { -793, 799, -161},
    { -756, 1111, -79},
    { -756, 1103, -158},
    { -664, 740, -134},
    { -765, 448, -138},
    { -849, 312, -114},
    { -905, 550, -70},
    { -729, 613, -138},
    { -527, 553, -296},
    { -392, 403, -330},
    { -405, 491, -333},
    { -402, 559, -338},
    { -512, 564, -411},
    { -636, 730, -470},
    { -728, 920, -511},
    { -607, 631, -571},
    { -507, 546, -607},
    { -852, 1296, -225},
    { -896, 679, -383},
    { -498, 397, -45},
    { -545, 501, -16},
    { -570, 766, -220},
    { -590, 712, -278},
    { -564, 648, -235},
    { -492, 630, -174},
    { -515, 688, -155},
    { -519, 668, -113},
    { -634, 786, -235},
    { -697, 894, -571},
    { -784, 1202, -820},
    { -587, 1751, -338},
    { -693, 1061, -497},
    { -625, 716, -581},
    { -568, 509, -674},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-08-06 15:20:05 GMT
AccelRawData *activity_sample_20_hand_swings_at_side(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME hand_swings_at_side
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 25
  //> TEST_WEIGHT 0.0
  static AccelRawData samples[] = {
    { -55, -20, -1002},
    { -41, -51, -986},
    { -48, -57, -1001},
    { 16, -96, -994},
    { -69, -58, -984},
    { -61, -57, -996},
    { -83, -30, -1053},
    { -112, 44, -1064},
    { 13, -189, -1024},
    { 314, -91, -1041},
    { -155, -102, -1010},
    { -147, -165, -976},
    { -101, -273, -1032},
    { -26, -337, -1052},
    { 10, -472, -1008},
    { 127, -448, -809},
    { 182, -367, -568},
    { 151, -131, -395},
    { 85, 106, -284},
    { -127, 257, -211},
    { -433, 409, -27},
    { -803, 616, 152},
    { -1178, 822, 196},
    { -1421, 711, 76},
    { -1760, 793, 192},
    { -1997, 844, 396},
    { -1952, 790, 354},
    { -1911, 729, 326},
    { -1791, 636, 368},
    { -1480, 629, 255},
    { -1147, 577, 192},
    { -868, 649, 42},
    { -620, 677, -15},
    { -500, 693, -28},
    { -475, 677, -69},
    { -566, 604, -42},
    { -855, 579, 34},
    { -1080, 550, 134},
    { -1382, 655, 173},
    { -1806, 682, 296},
    { -2025, 756, 306},
    { -2099, 838, 269},
    { -1951, 902, 218},
    { -1702, 964, 97},
    { -1443, 834, 123},
    { -1070, 547, 39},
    { -681, 320, -60},
    { -404, 191, 7},
    { -197, 94, -29},
    { -120, 67, -46},
    { -80, 55, -22},
    { -93, 113, -44},
    { -259, 271, -42},
    { -515, 414, 15},
    { -836, 542, 49},
    { -1285, 701, 72},
    { -1791, 1010, 141},
    { -1969, 1000, 46},
    { -2057, 1088, 42},
    { -1857, 1034, 162},
    { -1526, 825, 93},
    { -1304, 624, 57},
    { -1052, 394, 31},
    { -885, 372, 159},
    { -723, 505, 151},
    { -552, 562, -17},
    { -497, 614, -34},
    { -549, 574, -21},
    { -766, 488, 74},
    { -885, 522, 93},
    { -1076, 550, 121},
    { -1394, 613, 197},
    { -1733, 687, 276},
    { -1925, 757, 287},
    { -1904, 760, 178},
    { -1726, 790, 132},
    { -1521, 795, 60},
    { -1228, 649, 70},
    { -881, 491, -2},
    { -609, 325, -5},
    { -345, 250, -39},
    { -227, 255, -96},
    { -161, 237, -65},
    { -164, 197, -33},
    { -213, 238, -78},
    { -390, 312, -65},
    { -616, 430, 2},
    { -920, 485, -25},
    { -1317, 674, 48},
    { -1623, 727, 98},
    { -1898, 828, 69},
    { -2017, 962, 141},
    { -1748, 991, 265},
    { -1323, 566, 17},
    { -1191, 423, 19},
    { -1061, 500, 171},
    { -839, 271, 70},
    { -712, 434, 127},
    { -577, 592, -32},
    { -560, 545, -134},
    { -631, 468, -11},
    { -851, 497, 109},
    { -959, 439, 134},
    { -1111, 464, 154},
    { -1282, 485, 239},
    { -1499, 537, 252},
    { -1616, 691, 290},
    { -1666, 785, 203},
    { -1649, 746, 151},
    { -1536, 828, 127},
    { -1320, 847, 102},
    { -1041, 552, 36},
    { -700, 286, 16},
    { -414, 157, 9},
    { -208, 162, -47},
    { -134, 169, -92},
    { -141, 239, -87},
    { -212, 362, -74},
    { -365, 399, -127},
    { -559, 459, -96},
    { -872, 640, -14},
    { -1113, 738, -8},
    { -1416, 797, 18},
    { -1719, 871, 39},
    { -1786, 915, 188},
    { -1587, 813, 208},
    { -1397, 574, 84},
    { -1267, 372, 149},
    { -1104, 311, 151},
    { -957, 329, 286},
    { -762, 442, 113},
    { -621, 602, -16},
    { -583, 529, -36},
    { -605, 457, -9},
    { -807, 413, 131},
    { -877, 374, 144},
    { -938, 491, 86},
    { -1212, 562, 145},
    { -1557, 546, 287},
    { -1813, 590, 365},
    { -1807, 654, 375},
    { -1663, 611, 180},
    { -1598, 744, 170},
    { -1386, 720, 194},
    { -1083, 597, 77},
    { -782, 320, 72},
    { -482, 144, 90},
    { -286, 94, 26},
    { -201, 115, -30},
    { -203, 188, -81},
    { -285, 299, -89},
    { -465, 386, -89},
    { -693, 411, -7},
    { -1091, 739, 73},
    { -1242, 713, -48},
    { -1531, 753, 1},
    { -1698, 734, 196},
    { -1724, 734, 287},
    { -1509, 704, 174},
    { -1324, 604, 124},
    { -1167, 580, 132},
    { -965, 426, 114},
    { -885, 228, 137},
    { -770, 316, 166},
    { -677, 434, 66},
    { -633, 438, -46},
    { -675, 410, -34},
    { -768, 343, 42},
    { -857, 419, 94},
    { -1015, 523, 86},
    { -1238, 475, 239},
    { -1436, 577, 216},
    { -1640, 666, 228},
    { -1702, 708, 317},
    { -1604, 719, 241},
    { -1458, 755, 187},
    { -1302, 701, 184},
    { -1056, 632, 126},
    { -776, 484, 20},
    { -507, 339, 25},
    { -285, 287, -45},
    { -145, 233, -54},
    { -116, 209, -27},
    { -97, 233, -55},
    { -159, 384, -104},
    { -377, 393, -15},
    { -630, 464, 38},
    { -1039, 706, 105},
    { -1317, 758, 130},
    { -1582, 770, 147},
    { -1746, 724, 244},
    { -1749, 695, 314},
    { -1567, 636, 269},
    { -1365, 550, 207},
    { -1176, 522, 184},
    { -993, 535, 132},
    { -800, 483, 72},
    { -657, 508, 58},
    { -622, 542, 31},
    { -615, 477, 1},
    { -772, 463, 47},
    { -875, 426, 80},
    { -1050, 443, 130},
    { -1211, 472, 157},
    { -1369, 518, 216},
    { -1516, 645, 257},
    { -1676, 770, 295},
    { -1641, 816, 332},
    { -1505, 865, 244},
    { -1323, 819, 223},
    { -1030, 652, 147},
    { -758, 454, 132},
    { -487, 317, 58},
    { -302, 327, -5},
    { -193, 316, -50},
    { -130, 326, -92},
    { -93, 316, -102},
    { -111, 324, -73},
    { -252, 371, -85},
    { -466, 505, -1},
    { -760, 567, 80},
    { -992, 579, 100},
    { -1402, 714, 226},
    { -1694, 756, 200},
    { -1881, 735, 224},
    { -1814, 643, 288},
    { -1504, 565, 132},
    { -1375, 434, 186},
    { -1205, 470, 215},
    { -1016, 425, 232},
    { -810, 350, 125},
    { -659, 427, 87},
    { -633, 447, 73},
    { -604, 409, 23},
    { -611, 406, 24},
    { -830, 347, 95},
    { -847, 347, 108},
    { -1038, 450, 101},
    { -1253, 487, 229},
    { -1440, 580, 264},
    { -1624, 688, 255},
    { -1722, 793, 271},
    { -1725, 841, 263},
    { -1554, 867, 176},
    { -1299, 748, 138},
    { -1019, 581, 103},
    { -743, 464, 90},
    { -493, 385, 41},
    { -302, 339, -46},
    { -142, 348, -122},
    { -87, 336, -121},
    { -70, 315, -104},
    { -111, 343, -95},
    { -238, 408, -108},
    { -479, 577, -87},
    { -678, 515, 2},
    { -1000, 615, 109},
    { -1351, 740, 208},
    { -1630, 807, 268},
    { -1790, 749, 313},
    { -1734, 685, 249},
    { -1554, 623, 190},
    { -1401, 533, 192},
    { -1199, 356, 103},
    { -1034, 313, 194},
    { -834, 419, 134},
    { -674, 433, 38},
    { -606, 487, -12},
    { -587, 447, 22},
    { -699, 409, 50},
    { -817, 398, 140},
    { -904, 486, 118},
    { -1152, 545, 174},
    { -1351, 537, 230},
    { -1628, 635, 297},
    { -1802, 732, 324},
    { -1771, 706, 284},
    { -1636, 782, 157},
    { -1422, 729, 139},
    { -1169, 620, 135},
    { -872, 438, 72},
    { -571, 311, 18},
    { -336, 233, -28},
    { -210, 255, -54},
    { -144, 249, -51},
    { -176, 247, -26},
    { -263, 291, -36},
    { -449, 423, -7},
    { -723, 478, 7},
    { -1041, 567, 48},
    { -1375, 754, 74},
    { -1638, 695, 125},
    { -1889, 689, 250},
    { -1893, 715, 387},
    { -1596, 740, 213},
    { -1349, 590, 151},
    { -1171, 455, 156},
    { -954, 447, 149},
    { -762, 451, 183},
    { -634, 520, 92},
    { -570, 562, 31},
    { -593, 525, -14},
    { -769, 523, 57},
    { -924, 531, 115},
    { -1151, 478, 157},
    { -1336, 537, 216},
    { -1578, 586, 225},
    { -1745, 626, 276},
    { -1762, 711, 269},
    { -1636, 759, 168},
    { -1501, 779, 188},
    { -1245, 696, 81},
    { -957, 529, 5},
    { -671, 316, 22},
    { -402, 203, 5},
    { -221, 202, -38},
    { -139, 267, -90},
    { -109, 306, -121},
    { -133, 379, -96},
    { -221, 387, -129},
    { -460, 468, -34},
    { -760, 596, 9},
    { -1020, 449, -18},
    { -1479, 561, 53},
    { -1785, 620, 162},
    { -1945, 698, 239},
    { -1768, 786, 165},
    { -1512, 735, 95},
    { -1351, 497, 169},
    { -1173, 466, 103},
    { -928, 256, 97},
    { -788, 387, 196},
    { -666, 500, 106},
    { -591, 521, -45},
    { -609, 500, -3},
    { -753, 447, 40},
    { -858, 405, 115},
    { -969, 478, 147},
    { -1155, 532, 164},
    { -1376, 528, 236},
    { -1657, 653, 329},
    { -1805, 771, 313},
    { -1816, 705, 324},
    { -1701, 679, 285},
    { -1464, 748, 208},
    { -1149, 727, 264},
    { -766, 480, 98},
    { -415, 453, -111},
    { -223, 348, -320},
    { -155, 253, -517},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-08-06 15:20:23 GMT
AccelRawData *activity_sample_20_hand_movements_y(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME hand_movements_x
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 25
  //> TEST_WEIGHT 0.0
  static AccelRawData samples[] = {
    { -64, -172, -986},
    { -49, -171, -977},
    { -56, -175, -985},
    { -46, -173, -991},
    { -57, -156, -989},
    { -66, -154, -984},
    { -66, -168, -984},
    { -43, -140, -981},
    { -72, -142, -984},
    { -99, -168, -983},
    { -107, -156, -993},
    { -87, -146, -983},
    { -61, -140, -985},
    { -83, -146, -984},
    { -78, -142, -986},
    { -90, -106, -996},
    { -84, -131, -984},
    { -112, -134, -990},
    { -88, -110, -999},
    { -108, -99, -987},
    { -71, -133, -982},
    { -77, -128, -993},
    { -77, -124, -979},
    { -97, -88, -989},
    { -92, -78, -969},
    { -90, -104, -1007},
    { -50, -139, -985},
    { -76, -88, -1002},
    { -82, -66, -1031},
    { -140, -51, -1017},
    { -68, -136, -1009},
    { -66, -160, -986},
    { -19, -167, -1012},
    { 67, -143, -1045},
    { 13, -67, -986},
    { -23, -129, -938},
    { -28, -111, -836},
    { -90, -247, -835},
    { -187, -458, -749},
    { -430, -510, -797},
    { -852, -523, -1132},
    { -1038, -612, -1103},
    { -1147, -454, -1181},
    { -1135, 53, -1164},
    { -976, 502, -1026},
    { -693, 800, -838},
    { -472, 807, -651},
    { -280, 941, -582},
    { -151, 874, -506},
    { -123, 830, -525},
    { -81, 862, -508},
    { -1, 912, -515},
    { 66, 930, -495},
    { 59, 992, -513},
    { 7, 972, -599},
    { -183, 1019, -577},
    { -356, 1041, -702},
    { -598, 897, -797},
    { -780, 688, -911},
    { -942, 600, -1029},
    { -1018, 270, -1162},
    { -1015, 8, -1178},
    { -859, -247, -1276},
    { -766, -366, -1124},
    { -576, -351, -947},
    { -412, -308, -930},
    { -277, -88, -863},
    { -170, -111, -811},
    { -180, -304, -913},
    { -318, -412, -1064},
    { -559, -552, -979},
    { -697, -629, -931},
    { -847, -48, -1155},
    { -829, 424, -1260},
    { -763, 331, -1126},
    { -708, 502, -1037},
    { -599, 659, -969},
    { -385, 800, -813},
    { -241, 749, -749},
    { -135, 788, -740},
    { 18, 745, -770},
    { 79, 703, -681},
    { 147, 777, -682},
    { 178, 795, -658},
    { 153, 825, -704},
    { 98, 721, -699},
    { 36, 686, -735},
    { -57, 734, -788},
    { -154, 698, -840},
    { -228, 687, -794},
    { -245, 635, -965},
    { -381, 578, -935},
    { -465, 532, -1030},
    { -564, 349, -1360},
    { -584, 557, -1030},
    { -741, -55, -1275},
    { -663, -368, -1113},
    { -600, -410, -1001},
    { -475, -477, -1090},
    { -423, -483, -828},
    { -325, -403, -771},
    { -338, -211, -988},
    { -484, -80, -1089},
    { -595, -153, -1186},
    { -664, -209, -1250},
    { -684, -183, -1134},
    { -720, 144, -1198},
    { -580, 116, -1069},
    { -693, 399, -1038},
    { -547, 453, -856},
    { -477, 753, -787},
    { -208, 834, -787},
    { -51, 821, -741},
    { 93, 761, -713},
    { 171, 671, -670},
    { 178, 636, -675},
    { 133, 648, -710},
    { 73, 656, -796},
    { -17, 605, -802},
    { -42, 616, -868},
    { -195, 565, -916},
    { -173, 507, -958},
    { -348, 486, -1048},
    { -404, 356, -1069},
    { -477, 281, -1175},
    { -548, 7, -1192},
    { -547, -136, -1132},
    { -532, -244, -1225},
    { -435, -364, -1160},
    { -384, -113, -1028},
    { -321, -294, -1048},
    { -254, -354, -929},
    { -237, -251, -1000},
    { -308, -148, -1184},
    { -436, -235, -1123},
    { -481, -173, -1174},
    { -492, 92, -1178},
    { -460, 164, -1129},
    { -356, 132, -1008},
    { -381, 261, -1099},
    { -382, 291, -901},
    { -351, 510, -928},
    { -298, 639, -861},
    { -159, 701, -786},
    { -109, 780, -819},
    { 2, 796, -752},
    { 51, 779, -746},
    { 91, 729, -752},
    { 87, 635, -772},
    { 34, 673, -808},
    { -22, 694, -822},
    { -90, 592, -836},
    { -68, 509, -872},
    { -162, 542, -982},
    { -340, 512, -1005},
    { -435, 481, -1046},
    { -481, 262, -1136},
    { -545, 190, -1074},
    { -569, -39, -1132},
    { -557, -348, -1050},
    { -492, -328, -1060},
    { -452, -514, -1082},
    { -358, -373, -934},
    { -282, -388, -955},
    { -216, -365, -892},
    { -235, -334, -934},
    { -433, -343, -1039},
    { -530, -395, -977},
    { -574, -241, -1105},
    { -620, -84, -1103},
    { -613, 92, -1137},
    { -565, 269, -1185},
    { -504, 392, -1026},
    { -453, 538, -959},
    { -322, 779, -898},
    { -162, 789, -802},
    { -12, 823, -817},
    { 118, 680, -775},
    { 141, 597, -761},
    { 142, 566, -768},
    { 126, 575, -799},
    { 98, 572, -881},
    { -11, 571, -875},
    { -60, 492, -893},
    { -71, 436, -911},
    { -209, 424, -965},
    { -271, 334, -1007},
    { -332, 282, -1118},
    { -452, 129, -1176},
    { -426, 160, -1104},
    { -487, -26, -1260},
    { -401, -25, -1007},
    { -419, -272, -1132},
    { -384, -278, -1038},
    { -277, -168, -952},
    { -227, -286, -1002},
    { -172, -223, -912},
    { -241, -204, -1092},
    { -430, -417, -1063},
    { -452, -359, -1044},
    { -466, -13, -1197},
    { -509, 142, -1137},
    { -486, 256, -1067},
    { -391, 319, -1052},
    { -390, 399, -990},
    { -297, 404, -905},
    { -268, 563, -971},
    { -130, 634, -831},
    { -38, 722, -895},
    { 60, 668, -843},
    { 126, 561, -825},
    { 138, 563, -816},
    { 105, 571, -824},
    { 100, 543, -882},
    { 84, 510, -893},
    { 26, 539, -925},
    { -47, 533, -948},
    { -91, 417, -962},
    { -143, 380, -958},
    { -247, 400, -1057},
    { -350, 279, -1017},
    { -452, 135, -1121},
    { -389, -80, -1106},
    { -386, -60, -1080},
    { -349, -320, -1077},
    { -335, -393, -987},
    { -332, -373, -1018},
    { -227, -379, -1033},
    { -215, -314, -975},
    { -217, -325, -1040},
    { -332, -395, -1093},
    { -369, -314, -1047},
    { -393, -132, -1133},
    { -424, -30, -1149},
    { -429, 0, -1027},
    { -414, 121, -1025},
    { -389, 175, -888},
    { -392, 373, -916},
    { -369, 543, -973},
    { -333, 697, -803},
    { -118, 829, -865},
    { -1, 825, -866},
    { 47, 707, -786},
    { 85, 639, -813},
    { 76, 637, -831},
    { 47, 637, -883},
    { -19, 631, -862},
    { -64, 548, -830},
    { -36, 433, -898},
    { -113, 491, -931},
    { -160, 357, -950},
    { -238, 314, -1093},
    { -269, 233, -1083},
    { -268, 243, -1109},
    { -339, 135, -1192},
    { -337, -63, -1092},
    { -292, -299, -1177},
    { -285, -516, -1048},
    { -198, -285, -946},
    { -105, -184, -1060},
    { -74, -52, -998},
    { -79, -221, -988},
    { -206, -372, -1145},
    { -315, -489, -1030},
    { -387, -584, -1012},
    { -570, -279, -1160},
    { -562, -139, -993},
    { -604, 201, -1113},
    { -595, 470, -990},
    { -532, 684, -770},
    { -386, 967, -963},
    { -197, 992, -827},
    { -57, 911, -896},
    { 23, 747, -797},
    { 84, 652, -803},
    { 67, 618, -796},
    { 82, 604, -806},
    { 50, 544, -817},
    { 12, 540, -829},
    { -37, 452, -835},
    { -83, 287, -880},
    { -146, 315, -898},
    { -190, 340, -1042},
    { -276, 289, -1051},
    { -365, 239, -1158},
    { -376, 82, -1182},
    { -369, -123, -1076},
    { -373, -148, -1020},
    { -356, -421, -1146},
    { -301, -242, -981},
    { -296, -97, -1005},
    { -294, 12, -958},
    { -308, 109, -982},
    { -299, 132, -1092},
    { -449, 86, -1154},
    { -470, -64, -1099},
    { -432, -57, -1087},
    { -486, -42, -1066},
    { -463, 39, -996},
    { -419, 299, -1065},
    { -242, 266, -909},
    { -244, 392, -871},
    { -165, 543, -837},
    { -103, 661, -802},
    { -42, 729, -837},
    { 24, 673, -780},
    { 63, 687, -753},
    { 121, 710, -793},
    { 72, 666, -817},
    { -17, 630, -801},
    { -44, 578, -847},
    { -171, 533, -908},
    { -220, 479, -973},
    { -310, 385, -1120},
    { -360, 150, -1178},
    { -397, 163, -1212},
    { -420, -89, -1274},
    { -387, -254, -981},
    { -395, -213, -993},
    { -303, -347, -1013},
    { -195, -251, -875},
    { -198, -81, -942},
    { -211, -101, -1015},
    { -202, -206, -1014},
    { -271, -282, -1116},
    { -423, -319, -1147},
    { -477, -320, -1079},
    { -511, -284, -1004},
    { -560, -123, -1095},
    { -601, 11, -971},
    { -546, 121, -965},
    { -557, 528, -947},
    { -488, 523, -712},
    { -413, 855, -839},
    { -233, 779, -731},
    { -144, 922, -838},
    { -54, 716, -786},
    { -12, 752, -784},
    { 38, 674, -775},
    { -5, 579, -829},
    { -113, 578, -846},
    { -227, 580, -905},
    { -227, 471, -867},
    { -334, 515, -928},
    { -464, 694, -959},
    { -500, 552, -1025},
    { -732, 135, -1200},
    { -856, -336, -1342},
    { -793, -457, -1056},
    { -570, -707, -1117},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-08-06 15:20:40 GMT
AccelRawData *activity_sample_20_hand_movements_x(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME hand_movements_y
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 25
  //> TEST_WEIGHT 0.0
  static AccelRawData samples[] = {
    { -30, -120, -1011},
    { 3, -113, -1038},
    { -21, -107, -993},
    { 0, -108, -972},
    { 1, -130, -997},
    { 2, -119, -986},
    { 0, -128, -1001},
    { -8, -123, -1023},
    { -21, -105, -1008},
    { -14, -93, -1002},
    { 15, -96, -996},
    { 26, -124, -986},
    { -40, -100, -988},
    { -22, -106, -991},
    { -20, -113, -995},
    { -53, -115, -984},
    { -9, -112, -1003},
    { -9, -112, -1000},
    { -18, -117, -999},
    { -14, -133, -1005},
    { -27, -99, -993},
    { -42, -111, -1000},
    { -7, -155, -987},
    { -6, -136, -969},
    { -38, -100, -1012},
    { -92, -114, -986},
    { -78, -109, -1006},
    { -62, -123, -994},
    { -56, -125, -1001},
    { -60, -119, -1044},
    { -57, -168, -1008},
    { 80, -247, -1021},
    { -244, -125, -964},
    { -215, -166, -992},
    { -245, -116, -961},
    { -244, -107, -934},
    { -203, -58, -980},
    { -132, -27, -1009},
    { -65, 9, -1064},
    { 75, -41, -1006},
    { 185, -47, -990},
    { 330, -74, -1017},
    { 496, -68, -1080},
    { 688, -110, -1020},
    { 776, -14, -1142},
    { 834, 79, -1207},
    { 913, -94, -922},
    { 569, 16, -1149},
    { 161, -124, -1208},
    { -100, -146, -1002},
    { -301, -83, -961},
    { -376, -80, -946},
    { -427, -116, -869},
    { -465, -86, -910},
    { -513, -74, -817},
    { -480, 25, -908},
    { -499, -1, -844},
    { -388, -5, -825},
    { -483, -1, -942},
    { -531, -37, -905},
    { -492, 85, -1020},
    { -451, 1, -986},
    { -190, 143, -1064},
    { -33, 356, -1133},
    { 236, 292, -1176},
    { 360, 352, -1251},
    { 461, 433, -1205},
    { 430, 314, -1159},
    { 436, 223, -1109},
    { 459, 98, -980},
    { 430, -17, -906},
    { 389, -43, -964},
    { 394, 23, -1054},
    { 398, 151, -1099},
    { 437, 242, -1228},
    { 474, 190, -1241},
    { 357, 214, -1208},
    { 404, 152, -1211},
    { 336, 238, -1346},
    { 153, 78, -1039},
    { -145, 225, -1144},
    { -489, 42, -983},
    { -857, 248, -820},
    { -667, 117, -873},
    { -614, 72, -742},
    { -485, 77, -828},
    { -433, -50, -805},
    { -321, -55, -751},
    { -293, -27, -897},
    { -526, -10, -841},
    { -417, 80, -901},
    { -440, 160, -1011},
    { -295, 167, -909},
    { -171, 156, -1005},
    { 48, 271, -1130},
    { 188, 302, -1165},
    { 259, 371, -1255},
    { 320, 391, -1243},
    { 354, 433, -1176},
    { 431, 285, -1099},
    { 429, 227, -1043},
    { 493, 101, -965},
    { 435, 97, -953},
    { 391, 147, -965},
    { 380, 179, -1035},
    { 341, 235, -1130},
    { 348, 174, -1096},
    { 338, 314, -1275},
    { 323, 216, -1159},
    { 251, 141, -958},
    { 62, 296, -1090},
    { -114, 143, -913},
    { -280, 122, -858},
    { -579, 343, -1020},
    { -665, 211, -879},
    { -651, 175, -933},
    { -641, 192, -831},
    { -544, 224, -938},
    { -519, 132, -863},
    { -482, 96, -803},
    { -484, 145, -869},
    { -537, 128, -843},
    { -598, 197, -833},
    { -425, 254, -880},
    { -230, 233, -903},
    { -78, 225, -926},
    { 76, 396, -1103},
    { 257, 379, -1120},
    { 355, 414, -1086},
    { 389, 330, -1109},
    { 421, 331, -1133},
    { 432, 283, -1068},
    { 501, 157, -991},
    { 426, 204, -1068},
    { 355, 155, -1000},
    { 213, 234, -1096},
    { 228, 251, -1177},
    { 307, 222, -1134},
    { 358, 332, -1295},
    { 257, 307, -1103},
    { 335, 350, -996},
    { 263, 405, -1170},
    { 107, 172, -935},
    { -179, 287, -905},
    { -350, 217, -924},
    { -708, 214, -758},
    { -779, 255, -913},
    { -610, 153, -844},
    { -536, 90, -909},
    { -501, 3, -843},
    { -429, 15, -800},
    { -441, 142, -905},
    { -560, 109, -805},
    { -451, 198, -843},
    { -388, 241, -900},
    { -225, 285, -922},
    { -26, 391, -1063},
    { 222, 380, -1143},
    { 429, 401, -1160},
    { 539, 371, -1160},
    { 588, 342, -1150},
    { 508, 294, -1119},
    { 553, 227, -964},
    { 587, 261, -946},
    { 480, 226, -947},
    { 383, 279, -986},
    { 370, 247, -1034},
    { 393, 290, -1032},
    { 432, 381, -1134},
    { 404, 363, -1103},
    { 337, 476, -1151},
    { 342, 417, -1154},
    { 368, 246, -1140},
    { 282, 114, -851},
    { 22, 152, -800},
    { -708, 347, -1004},
    { -1118, 264, -827},
    { -862, 45, -764},
    { -622, 130, -789},
    { -449, -16, -755},
    { -448, -77, -737},
    { -415, -24, -803},
    { -582, 81, -815},
    { -416, 137, -780},
    { -428, 187, -886},
    { -325, 174, -859},
    { -113, 289, -1018},
    { 34, 301, -1124},
    { 197, 449, -1186},
    { 307, 388, -1207},
    { 335, 341, -1180},
    { 343, 312, -1185},
    { 398, 313, -1179},
    { 468, 332, -1050},
    { 543, 209, -906},
    { 510, 205, -921},
    { 442, 198, -954},
    { 344, 250, -983},
    { 360, 289, -1072},
    { 395, 355, -1182},
    { 280, 380, -1114},
    { 328, 342, -1186},
    { 198, 377, -1246},
    { 114, 310, -989},
    { 152, 294, -1180},
    { 53, 37, -933},
    { -270, 75, -872},
    { -531, 208, -931},
    { -679, 248, -826},
    { -607, 226, -851},
    { -442, 103, -853},
    { -457, 35, -837},
    { -429, 98, -877},
    { -458, 102, -956},
    { -509, 60, -844},
    { -195, 66, -887},
    { -211, 220, -869},
    { -143, 124, -921},
    { 57, 265, -1010},
    { 215, 316, -1076},
    { 346, 286, -1137},
    { 411, 335, -1132},
    { 407, 352, -1168},
    { 414, 369, -1167},
    { 513, 257, -1153},
    { 539, 180, -1105},
    { 517, 72, -957},
    { 473, 108, -994},
    { 437, 239, -1118},
    { 451, 148, -960},
    { 405, 348, -1195},
    { 326, 381, -1190},
    { 260, 365, -1155},
    { 228, 244, -1099},
    { 140, 87, -901},
    { -76, 93, -869},
    { -413, 93, -954},
    { -709, 97, -796},
    { -777, 192, -781},
    { -703, 259, -795},
    { -586, 156, -818},
    { -572, 55, -801},
    { -480, 75, -768},
    { -550, 109, -871},
    { -602, 113, -723},
    { -447, 217, -912},
    { -400, 162, -949},
    { -217, 214, -917},
    { -17, 284, -1090},
    { 171, 273, -1044},
    { 262, 257, -1098},
    { 387, 254, -1161},
    { 404, 311, -1121},
    { 436, 244, -1192},
    { 486, 194, -1123},
    { 518, 101, -1035},
    { 440, 77, -927},
    { 388, 218, -1087},
    { 394, 274, -1127},
    { 340, 245, -1077},
    { 299, 367, -1244},
    { 279, 323, -1217},
    { 242, 324, -1143},
    { 279, 239, -1094},
    { 197, 140, -1022},
    { 34, 75, -894},
    { -352, 178, -923},
    { -645, 83, -843},
    { -778, 133, -754},
    { -654, 195, -815},
    { -596, 87, -762},
    { -576, 77, -853},
    { -552, 16, -770},
    { -550, 85, -844},
    { -658, 124, -802},
    { -569, 153, -826},
    { -440, 226, -878},
    { -201, 229, -902},
    { 9, 237, -998},
    { 247, 386, -1208},
    { 387, 439, -1141},
    { 541, 344, -1142},
    { 580, 377, -1208},
    { 648, 370, -1052},
    { 654, 197, -1031},
    { 668, 185, -928},
    { 593, 157, -903},
    { 470, 213, -1067},
    { 444, 194, -1009},
    { 454, 258, -1165},
    { 357, 305, -1163},
    { 337, 219, -929},
    { 378, 289, -1096},
    { 213, 145, -972},
    { 16, 274, -984},
    { -300, 197, -1131},
    { -633, 42, -785},
    { -775, 171, -889},
    { -727, 106, -771},
    { -643, 82, -839},
    { -595, 5, -852},
    { -589, 0, -760},
    { -600, 84, -870},
    { -648, 88, -784},
    { -522, 91, -820},
    { -380, 129, -859},
    { -136, 219, -896},
    { 82, 223, -1006},
    { 310, 341, -1092},
    { 405, 437, -1166},
    { 553, 287, -1220},
    { 535, 204, -1187},
    { 580, 281, -1101},
    { 597, 123, -1048},
    { 596, 187, -944},
    { 483, 80, -1009},
    { 380, 98, -959},
    { 317, 134, -1005},
    { 430, 126, -1044},
    { 472, 38, -937},
    { 513, 231, -1163},
    { 385, 184, -1090},
    { 305, 269, -1017},
    { 155, 425, -1229},
    { -62, 255, -906},
    { -406, 354, -986},
    { -525, 104, -882},
    { -818, -46, -604},
    { -958, 194, -733},
    { -838, 70, -714},
    { -775, 120, -815},
    { -807, 18, -742},
    { -831, 53, -791},
    { -857, 95, -804},
    { -859, 105, -884},
    { -780, 210, -1023},
    { -502, 391, -1080},
    { -100, 284, -1111},
    { 656, 321, -842},
    { 1271, 115, -1006},
    { 1054, -187, -1062},
    { 691, 49, -806},
    { 449, -395, -841},
    { 370, -225, -959},
    { 191, -127, -954},
    { -37, -144, -996},
    { -77, -121, -981},
    { -21, -160, -1014},
    { -37, -208, -1034},
    { -270, -345, -751},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

// ----------------------------------------------------------------
// Sample captured: 2015-08-06 15:25:33 GMT
AccelRawData *activity_sample_20_hand_movements_z(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME hand_movements_z
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 25
  //> TEST_WEIGHT 0.0
  static AccelRawData samples[] = {
    { -77, -184, -938},
    { -49, -179, -953},
    { -55, -173, -969},
    { -50, -205, -978},
    { -78, -189, -987},
    { -65, -190, -998},
    { -57, -183, -1000},
    { -61, -151, -995},
    { -62, -165, -990},
    { -81, -155, -991},
    { -120, -171, -978},
    { -66, -168, -990},
    { -96, -163, -980},
    { -76, -177, -965},
    { -103, -166, -991},
    { -164, -161, -963},
    { -83, -157, -990},
    { -159, -149, -973},
    { -157, -159, -919},
    { -172, -161, -935},
    { -197, -132, -929},
    { -293, -87, -906},
    { -194, -187, -905},
    { -120, -145, -984},
    { 123, -110, -760},
    { -79, -128, -998},
    { -160, -46, -1052},
    { -194, -181, -1157},
    { -330, -369, -1614},
    { -535, -525, -2204},
    { -765, -524, -2262},
    { -593, -181, -1902},
    { -287, 226, -1490},
    { -63, 474, -853},
    { 163, 485, -337},
    { 255, 183, -294},
    { 198, 38, 273},
    { 252, -121, 358},
    { 283, -119, 309},
    { 226, -178, 265},
    { 251, -179, 150},
    { 183, -7, 82},
    { 145, 50, -87},
    { 57, 257, -154},
    { -79, 425, -886},
    { -258, 289, -1362},
    { -478, 227, -2015},
    { -661, 280, -2172},
    { -748, 545, -2162},
    { -700, 428, -1793},
    { -615, 370, -1547},
    { -554, 357, -1624},
    { -687, 244, -1727},
    { -789, 249, -1795},
    { -685, 151, -1579},
    { -552, 191, -1527},
    { -304, 232, -1113},
    { -35, 247, -782},
    { 170, 290, -433},
    { 281, 187, -134},
    { 333, 49, 15},
    { 270, 25, 131},
    { 350, -258, 271},
    { 284, -267, 168},
    { 319, -303, 138},
    { 375, -316, 60},
    { 352, -135, -98},
    { 246, -13, -291},
    { 195, 109, -571},
    { 34, 217, -909},
    { -104, 198, -1283},
    { -232, 373, -1580},
    { -293, 343, -1689},
    { -593, 490, -1859},
    { -601, 406, -1883},
    { -615, 309, -1785},
    { -541, 104, -1642},
    { -584, 134, -1635},
    { -531, 115, -1523},
    { -436, 113, -1455},
    { -296, 102, -1370},
    { -90, 48, -1108},
    { 57, 133, -915},
    { 253, 178, -622},
    { 353, 117, -392},
    { 376, 0, -208},
    { 463, -138, -107},
    { 451, -129, -139},
    { 442, -214, -109},
    { 388, -295, -74},
    { 420, -200, -169},
    { 410, -140, -211},
    { 353, -130, -266},
    { 424, 22, -491},
    { 249, 86, -780},
    { 226, 137, -944},
    { 106, 331, -1235},
    { -10, 260, -1310},
    { -125, 328, -1346},
    { -387, 397, -1576},
    { -481, 400, -1623},
    { -527, 416, -1613},
    { -404, 258, -1452},
    { -371, 149, -1275},
    { -373, 269, -1339},
    { -380, 361, -1375},
    { -365, 257, -1587},
    { -309, 39, -1567},
    { -199, 118, -1325},
    { -35, 69, -1060},
    { 148, 113, -738},
    { 262, 183, -543},
    { 368, 104, -359},
    { 428, -88, -151},
    { 463, -168, -151},
    { 504, -171, -190},
    { 484, -265, -139},
    { 463, -282, -214},
    { 445, -232, -301},
    { 509, -215, -248},
    { 471, -90, -390},
    { 355, 2, -405},
    { 291, -54, -532},
    { 236, 123, -680},
    { 57, 204, -1038},
    { -36, 280, -1173},
    { -227, 288, -1464},
    { -450, 449, -1610},
    { -543, 505, -1607},
    { -575, 554, -1658},
    { -475, 350, -1501},
    { -456, 251, -1466},
    { -525, 280, -1505},
    { -524, 290, -1446},
    { -405, 177, -1454},
    { -251, 142, -1312},
    { -125, 80, -1186},
    { 28, 31, -992},
    { 180, 25, -825},
    { 291, 63, -623},
    { 379, 15, -390},
    { 417, -16, -240},
    { 457, -91, -137},
    { 511, -132, -189},
    { 500, -182, -186},
    { 518, -254, -154},
    { 481, -245, -286},
    { 517, -208, -215},
    { 409, -133, -290},
    { 367, -67, -344},
    { 360, 60, -449},
    { 162, 205, -772},
    { 158, 182, -859},
    { -82, 368, -1233},
    { -145, 277, -1372},
    { -323, 286, -1537},
    { -508, 384, -1659},
    { -606, 425, -1797},
    { -590, 305, -1745},
    { -520, 124, -1668},
    { -562, 122, -1647},
    { -473, 118, -1510},
    { -347, 119, -1414},
    { -157, 163, -1267},
    { -1, 91, -1080},
    { 166, -8, -901},
    { 274, 75, -795},
    { 335, 9, -579},
    { 412, -141, -338},
    { 449, -87, -218},
    { 442, -106, -102},
    { 454, -181, -67},
    { 418, -222, -88},
    { 424, -256, -101},
    { 502, -265, -185},
    { 467, -191, -263},
    { 427, -82, -353},
    { 456, -64, -357},
    { 268, 62, -642},
    { 162, 135, -727},
    { 140, 204, -962},
    { -87, 405, -1425},
    { -182, 225, -1432},
    { -415, 335, -1728},
    { -581, 377, -1757},
    { -641, 405, -1763},
    { -499, 239, -1670},
    { -480, 183, -1652},
    { -502, 215, -1569},
    { -400, 220, -1540},
    { -265, 71, -1399},
    { -101, -47, -1264},
    { 47, -4, -1061},
    { 203, 82, -906},
    { 309, 127, -621},
    { 394, -66, -415},
    { 410, -79, -271},
    { 429, -49, -160},
    { 479, -52, -129},
    { 470, -160, -34},
    { 447, -279, -53},
    { 397, -248, -150},
    { 470, -233, -117},
    { 307, -25, -268},
    { 444, 60, -472},
    { 347, 1, -355},
    { 208, 211, -901},
    { 132, 125, -918},
    { -90, 18, -1159},
    { -144, 194, -1502},
    { -353, 215, -1612},
    { -639, 356, -1800},
    { -702, 491, -1849},
    { -594, 250, -1668},
    { -522, 149, -1572},
    { -511, 88, -1479},
    { -453, 28, -1425},
    { -284, -83, -1414},
    { -142, -96, -1298},
    { -26, -158, -1135},
    { 97, -46, -1039},
    { 167, 39, -826},
    { 258, -60, -544},
    { 321, -37, -362},
    { 408, 61, -187},
    { 478, 46, -191},
    { 461, -105, -123},
    { 507, -184, -71},
    { 531, -322, -85},
    { 541, -221, -229},
    { 454, -165, -147},
    { 341, -193, -222},
    { 314, -26, -370},
    { 198, 36, -564},
    { 46, 273, -898},
    { -10, 290, -1116},
    { -191, 390, -1354},
    { -319, 397, -1688},
    { -657, 422, -1751},
    { -661, 543, -1912},
    { -631, 452, -1808},
    { -491, 169, -1611},
    { -497, 180, -1488},
    { -418, 214, -1461},
    { -308, 196, -1424},
    { -166, 188, -1315},
    { -30, 200, -1172},
    { 78, 187, -981},
    { 241, 144, -723},
    { 344, 92, -505},
    { 416, 22, -143},
    { 475, -111, -113},
    { 471, -24, -109},
    { 473, -171, -1},
    { 425, -275, -27},
    { 397, -237, -154},
    { 465, -174, -207},
    { 425, -113, -278},
    { 433, -136, -384},
    { 440, -14, -344},
    { 301, 192, -573},
    { 200, 381, -1021},
    { 123, 379, -1026},
    { -61, 459, -1467},
    { -320, 547, -1623},
    { -456, 485, -1655},
    { -500, 502, -1680},
    { -447, 379, -1518},
    { -367, 266, -1369},
    { -376, 244, -1340},
    { -482, 354, -1570},
    { -505, 271, -1640},
    { -376, 116, -1525},
    { -223, 166, -1423},
    { -82, 225, -1299},
    { 41, 234, -1053},
    { 177, 152, -737},
    { 273, 55, -514},
    { 340, 15, -170},
    { 424, -151, 27},
    { 463, -70, -27},
    { 382, -203, 88},
    { 440, -372, 177},
    { 486, -408, 61},
    { 529, -283, -126},
    { 488, -197, -36},
    { 491, -132, -206},
    { 406, 61, -314},
    { 275, 290, -276},
    { 342, 371, -794},
    { 81, 747, -1577},
    { -160, 880, -2008},
    { -152, 240, -2186},
    { -8, 224, -1830},
    { -74, 11, -1476},
    { -110, -75, -1126},
    { -66, 23, -988},
    { -55, -2, -869},
    { -68, -87, -855},
    { -96, -83, -895},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-08-06 18:38:11 GMT
AccelRawData *activity_sample_working_at_desk(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME working_at_desk
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 20
  //> TEST_WEIGHT 10.0
  static AccelRawData samples[] = {
    { -26, -168, -982},
    { 26, -185, -984},
    { 34, -211, -990},
    { -2, -202, -984},
    { -49, -183, -967},
    { -67, -189, -990},
    { -82, -161, -985},
    { -117, -178, -989},
    { -196, -174, -977},
    { -73, -168, -1009},
    { 125, -180, -1016},
    { -24, -136, -968},
    { -58, -16, -892},
    { 101, -184, -1011},
    { 57, -143, -977},
    { 66, -157, -1015},
    { 67, -156, -1000},
    { 99, -140, -955},
    { 125, -138, -978},
    { 112, -150, -1003},
    { 95, -164, -988},
    { 58, -182, -961},
    { 98, -139, -996},
    { 99, -78, -1005},
    { 103, -25, -1017},
    { 102, -29, -1056},
    { 24, -66, -990},
    { -52, -58, -977},
    { 0, -20, -1012},
    { 111, 187, -1034},
    { 168, 268, -1005},
    { 249, 340, -880},
    { 285, 507, -904},
    { 359, 517, -824},
    { 448, 496, -739},
    { 503, 337, -726},
    { 471, 481, -724},
    { 446, 562, -771},
    { 456, 543, -751},
    { 481, 495, -754},
    { 450, 533, -774},
    { 402, 502, -780},
    { 362, 450, -867},
    { 377, 387, -826},
    { 326, 488, -991},
    { 376, 386, -978},
    { 400, 351, -887},
    { 283, 363, -904},
    { 208, 337, -833},
    { 178, 354, -865},
    { 35, 456, -1089},
    { 169, 358, -944},
    { 174, 280, -918},
    { 218, 325, -944},
    { 193, 383, -920},
    { 268, 350, -925},
    { 287, 356, -919},
    { 308, 397, -905},
    { 399, 369, -937},
    { 234, 369, -963},
    { 168, 15, -380},
    { 185, 643, -1048},
    { 170, 661, -882},
    { 160, 382, -859},
    { 165, 392, -898},
    { 198, 375, -882},
    { 229, 430, -881},
    { 240, 498, -912},
    { 270, 357, -900},
    { 285, 381, -886},
    { 280, 382, -895},
    { 228, 297, -915},
    { 225, 434, -903},
    { 225, 465, -870},
    { 187, 404, -900},
    { 187, 354, -903},
    { 227, 415, -900},
    { 239, 495, -918},
    { 196, 230, -901},
    { 215, 349, -900},
    { 248, 502, -873},
    { 228, 454, -882},
    { 218, 365, -895},
    { 215, 391, -898},
    { 225, 418, -893},
    { 216, 432, -887},
    { 225, 393, -913},
    { 228, 386, -899},
    { -223, 386, -913},
    { 224, 339, -895},
    { 264, 312, -899},
    { 309, 368, -925},
    { 358, 324, -894},
    { 337, 345, -954},
    { 291, 343, -910},
    { 267, 422, -901},
    { 254, 432, -883},
    { 237, 398, -874},
    { 242, 427, -866},
    { 250, 400, -880},
    { 227, 459, -884},
    { 245, 395, -884},
    { 173, 343, -859},
    { 299, 357, -902},
    { 389, 315, -927},
    { 276, 394, -903},
    { 251, 404, -903},
    { 219, 410, -875},
    { 235, 407, -894},
    { 257, 366, -891},
    { 262, 428, -893},
    { 250, 393, -888},
    { 255, 430, -883},
    { 251, 372, -890},
    { 265, 404, -879},
    { 267, 417, -881},
    { 253, 392, -883},
    { 258, 405, -889},
    { 254, 405, -883},
    { 259, 387, -878},
    { 258, 427, -885},
    { 265, 432, -906},
    { 319, 382, -891},
    { 370, 280, -923},
    { 380, 340, -960},
    { 285, 320, -947},
    { 389, 100, 4},
    { 90, 377, -947},
    { 30, 452, -861},
    { 97, 318, -887},
    { 214, 393, -914},
    { 272, 301, -937},
    { 327, 266, -944},
    { 338, 337, -924},
    { 304, 442, -893},
    { 234, 309, -923},
    { 280, 374, -872},
    { 287, 514, -875},
    { 230, 263, -908},
    { 258, 356, -900},
    { 259, 371, -889},
    { 261, 393, -897},
    { 250, 325, -909},
    { 268, 381, -908},
    { 277, 383, -904},
    { 256, 356, -906},
    { 260, 364, -905},
    { 262, 377, -901},
    { 263, 370, -901},
    { 256, 362, -903},
    { 258, 357, -901},
    { 270, 380, -895},
    { 256, 369, -899},
    { 264, 367, -904},
    { 256, 371, -895},
    { 249, 377, -892},
    { 272, 363, -902},
    { 255, 374, -896},
    { 266, 378, -889},
    { 272, 374, -899},
    { 265, 378, -902},
    { 265, 387, -900},
    { 264, 378, -904},
    { 267, 360, -901},
    { 275, 395, -902},
    { 252, 545, -995},
    { 197, 524, -895},
    { 375, 917, -881},
    { 406, 533, -706},
    { 363, 223, -753},
    { 350, 175, -682},
    { 205, 68, -1111},
    { 219, -17, -1334},
    { 94, -285, -948},
    { 197, 129, -1061},
    { 224, 218, -927},
    { 281, 276, -938},
    { 329, 211, -921},
    { 358, 215, -945},
    { 354, 218, -980},
    { 386, 274, -1056},
    { 355, 230, -838},
    { 358, 165, -712},
    { 330, 263, -918},
    { 314, 239, -990},
    { 308, 237, -952},
    { 278, 224, -864},
    { 266, 172, -976},
    { 262, 198, -1051},
    { 259, 85, -1023},
    { 196, -4, -1014},
    { 256, 323, -870},
    { 198, 128, -867},
    { 320, 158, -1036},
    { 294, 190, -985},
    { 264, 129, -913},
    { 367, 315, -904},
    { 401, 296, -920},
    { 385, 300, -855},
    { 329, 232, -925},
    { 298, 158, -942},
    { 305, 197, -942},
    { 326, 245, -937},
    { 302, 209, -931},
    { 308, 257, -914},
    { 298, 253, -945},
    { 299, 201, -945},
    { 301, 214, -948},
    { 310, 233, -930},
    { 329, 260, -929},
    { 322, 278, -927},
    { 306, 209, -930},
    { 303, 229, -929},
    { 315, 249, -930},
    { 303, 234, -936},
    { 299, 236, -929},
    { 309, 244, -933},
    { 308, 244, -926},
    { 302, 250, -938},
    { 304, 261, -937},
    { 304, 231, -932},
    { 302, 228, -931},
    { 304, 239, -939},
    { 307, 248, -936},
    { 303, 243, -930},
    { 303, 244, -935},
    { 300, 247, -933},
    { 304, 253, -930},
    { 299, 248, -932},
    { 304, 250, -934},
    { 301, 248, -932},
    { 301, 249, -931},
    { 302, 249, -933},
    { 300, 260, -935},
    { 300, 254, -932},
    { 297, 257, -927},
    { 305, 253, -928},
    { 302, 247, -930},
    { 298, 250, -926},
    { 303, 250, -932},
    { 304, 256, -928},
    { 304, 250, -931},
    { 295, 242, -928},
    { 300, 252, -932},
    { 307, 250, -932},
    { 302, 247, -927},
    { 301, 250, -927},
    { 302, 248, -936},
    { 306, 269, -947},
    { 294, 224, -934},
    { 307, 260, -947},
    { 320, 238, -944},
    { 330, 225, -942},
    { 333, 213, -951},
    { 327, 213, -952},
    { 325, 240, -950},
    { 313, 215, -924},
    { 307, 180, -921},
    { 216, 244, -977},
    { 291, 208, -910},
    { 261, 237, -920},
    { 265, 221, -939},
    { 283, 216, -965},
    { 289, 189, -962},
    { 301, 199, -951},
    { 313, 222, -969},
    { 308, 228, -971},
    { 303, 270, -978},
    { 328, 283, -1001},
    { 269, 162, -929},
    { 347, 178, -875},
    { 330, 166, -872},
    { 313, 177, -858},
    { 302, 162, -858},
    { 259, 218, -998},
    { 299, 212, -967},
    { 258, 281, -1041},
    { 278, 219, -959},
    { 321, 212, -921},
    { 305, 260, -953},
    { 269, 178, -905},
    { 367, 247, -1049},
    { 329, 250, -935},
    { 322, 232, -956},
    { 327, 229, -930},
    { 346, 231, -929},
    { 366, 229, -915},
    { 333, 243, -927},
    { 316, 229, -917},
    { 315, 216, -937},
    { 318, 224, -942},
    { 323, 236, -926},
    { 318, 218, -924},
    { 318, 217, -945},
    { 350, -43, -941},
    { 255, 221, -939},
    { 322, 222, -916},
    { 370, 173, -920},
    { 376, 227, -941},
    { 335, 235, -945},
    { 317, 235, -943},
    { 313, 220, -936},
    { 323, 217, -947},
    { 346, 214, -946},
    { 322, 223, -919},
    { 295, 200, -923},
    { 302, 211, -924},
    { 311, 214, -926},
    { 320, 222, -929},
    { 325, 226, -929},
    { 325, 206, -935},
    { 318, 215, -938},
    { 324, 226, -935},
    { 323, 221, -933},
    { 322, 220, -932},
    { 321, 226, -935},
    { 332, 224, -939},
    { 338, 229, -957},
    { 332, 214, -947},
    { 342, 192, -960},
    { 371, 206, -963},
    { 348, 203, -947},
    { 337, 205, -935},
    { 363, 217, -905},
    { 328, 185, -911},
    { 331, 187, -903},
    { 308, 176, -914},
    { 163, 222, -942},
    { 274, 205, -934},
    { 267, 187, -906},
    { 274, 162, -937},
    { 197, 194, -1046},
    { 348, 176, -1006},
    { 346, 167, -960},
    { 318, 173, -958},
    { 291, 183, -952},
    { 288, 183, -933},
    { 265, 204, -943},
    { 276, 150, -950},
    { 296, 152, -973},
    { 319, 122, -971},
    { 352, 95, -1000},
    { 386, 329, -931},
    { 171, 32, -904},
    { 161, 201, -776},
    { 246, 144, -1125},
    { 270, 81, -972},
    { 79, 256, -1005},
    { 349, 154, -938},
    { 307, 189, -896},
    { 324, 222, -939},
    { 326, 199, -930},
    { 325, 155, -943},
    { 332, 192, -926},
    { 377, 231, -919},
    { 424, 264, -875},
    { 348, 261, -914},
    { 306, 254, -934},
    { 286, 238, -934},
    { 290, 225, -933},
    { 312, 233, -943},
    { 326, 252, -941},
    { 303, 263, -920},
    { 295, 252, -922},
    { 310, 247, -927},
    { 298, 280, -927},
    { 293, 264, -925},
    { 293, 261, -921},
    { 300, 263, -933},
    { 294, 275, -927},
    { 290, 272, -940},
    { 294, 253, -967},
    { 268, 131, -937},
    { 177, 60, -989},
    { 225, 355, -951},
    { 285, 276, -992},
    { 312, 284, -922},
    { 294, 394, -964},
    { 330, 400, -838},
    { 291, 289, -722},
    { 304, 515, -815},
    { 327, 558, -755},
    { 302, 551, -820},
    { 326, 611, -836},
    { 331, 498, -808},
    { 329, 426, -832},
    { 292, 418, -933},
    { 300, 313, -955},
    { 344, 278, -971},
    { 354, 328, -967},
    { 307, 332, -875},
    { 326, 402, -808},
    { 230, 410, -846},
    { 218, 359, -760},
    { 197, 356, -879},
    { 261, 303, -951},
    { 361, 305, -984},
    { 364, 254, -969},
    { 302, 383, -917},
    { 269, 312, -912},
    { 266, 320, -912},
    { 289, 403, -909},
    { 301, 422, -907},
    { 265, 344, -924},
    { 239, 344, -910},
    { 208, 369, -915},
    { 304, 273, -937},
    { 391, 285, -931},
    { 360, 308, -920},
    { 322, 350, -909},
    { 319, 298, -931},
    { 253, 278, -968},
    { 192, 307, -859},
    { 119, 388, -905},
    { 121, 232, -1012},
    { 269, 196, -923},
    { 449, 339, -947},
    { 423, 249, -926},
    { 349, 361, -923},
    { 269, 337, -930},
    { 226, 327, -825},
    { 185, 312, -973},
    { 260, 218, -968},
    { 291, 328, -920},
    { 263, 300, -922},
    { 286, 283, -938},
    { 300, 403, -895},
    { 248, 303, -898},
    { 284, 301, -913},
    { 301, 313, -950},
    { 279, 303, -913},
    { 260, 307, -895},
    { 264, 310, -916},
    { 283, 334, -920},
    { 295, 317, -928},
    { 292, 324, -946},
    { 294, 329, -945},
    { 326, 346, -997},
    { 329, 311, -961},
    { 351, 242, -928},
    { 349, 348, -910},
    { 308, 269, -799},
    { 313, 209, -749},
    { 269, 253, -822},
    { 247, 359, -947},
    { 235, 308, -918},
    { 217, 401, -996},
    { 222, 269, -966},
    { 249, 307, -949},
    { 332, 585, -1076},
    { 546, 718, -1112},
    { 797, 669, -879},
    { 730, 573, -865},
    { 723, 550, -690},
    { 662, 588, -685},
    { 534, 485, -714},
    { 430, 377, -705},
    { 484, 252, -701},
    { 456, 247, -758},
    { 362, 439, -760},
    { 273, 423, -790},
    { 177, 345, -778},
    { 162, 327, -758},
    { 46, 331, -831},
    { 2, 365, -768},
    { -80, 323, -716},
    { -93, 576, -775},
    { -108, 646, -677},
    { -91, 647, -637},
    { -119, 676, -621},
    { -166, 732, -539},
    { -179, 840, -588},
    { -218, 742, -564},
    { -219, 900, -527},
    { -186, 868, -521},
    { -189, 889, -475},
    { -210, 890, -355},
    { -205, 889, -428},
    { -199, 909, -410},
    { -207, 904, -398},
    { -176, 923, -392},
    { -187, 942, -372},
    { -199, 910, -329},
    { -196, 947, -364},
    { -193, 952, -386},
    { -198, 954, -438},
    { -290, 975, -499},
    { -262, 839, -340},
    { -346, 935, -449},
    { -306, 1221, -462},
    { -260, 1264, -427},
    { -305, 1086, -428},
    { -195, 1092, -322},
    { -254, 945, -267},
    { -139, 785, -356},
    { -11, 860, -364},
    { -103, 750, -255},
    { 180, 739, -487},
    { 157, 708, -413},
    { 322, 695, -452},
    { 384, 616, -540},
    { 492, 614, -560},
    { 534, 512, -676},
    { 589, 462, -649},
    { 649, 368, -736},
    { 694, 327, -750},
    { 717, 253, -746},
    { 702, 234, -782},
    { 695, 173, -743},
    { 687, 112, -752},
    { 699, 104, -744},
    { 680, 84, -724},
    { 657, 40, -731},
    { 668, 10, -748},
    { 647, -48, -757},
    { 647, -38, -760},
    { 668, -69, -780},
    { 650, -107, -785},
    { 666, -125, -760},
    { 662, -112, -798},
    { 660, -156, -780},
    { 663, -191, -774},
    { 661, -201, -796},
    { 669, -213, -780},
    { 658, -259, -768},
    { 649, -261, -760},
    { 644, -259, -765},
    { 639, -279, -738},
    { 622, -276, -757},
    { 626, -290, -742},
    { 623, -300, -751},
    { 620, -309, -747},
    { 619, -315, -743},
    { 619, -327, -739},
    { 619, -347, -739},
    { 621, -345, -734},
    { 635, -342, -741},
    { 619, -345, -748},
    { 618, -351, -749},
    { 628, -349, -747},
    { 626, -348, -746},
    { 627, -367, -748},
    { 627, -377, -726},
    { 622, -368, -718},
    { 626, -386, -733},
    { 612, -381, -725},
    { 618, -393, -720},
    { 620, -391, -721},
    { 637, -398, -728},
    { 618, -409, -723},
    { 622, -402, -710},
    { 624, -409, -714},
    { 618, -405, -703},
    { 609, -409, -690},
    { 615, -417, -692},
    { 607, -404, -684},
    { 606, -414, -675},
    { 614, -392, -672},
    { 614, -391, -697},
    { 616, -360, -701},
    { 620, -352, -719},
    { 636, -326, -731},
    { 638, -295, -733},
    { 649, -260, -723},
    { 647, -230, -760},
    { 663, -180, -735},
    { 659, -166, -733},
    { 675, -100, -732},
    { 692, -59, -721},
    { 701, -35, -695},
    { 687, 35, -700},
    { 691, 48, -619},
    { 676, 144, -589},
    { 677, 243, -603},
    { 690, 369, -574},
    { 682, 456, -582},
    { 666, 528, -631},
    { 638, 584, -662},
    { 615, 624, -649},
    { 571, 669, -649},
    { 591, 753, -647},
    { 565, 769, -678},
    { 576, 663, -649},
    { 523, 622, -646},
    { 473, 677, -729},
    { 429, 708, -601},
    { 236, 744, -733},
    { 158, 526, -676},
    { 143, 529, -655},
    { 163, 480, -591},
    { 221, 488, -654},
    { 276, 519, -668},
    { 300, 475, -767},
    { 328, 615, -911},
    { 348, 704, -984},
    { 372, 615, -925},
    { 353, 611, -950},
    { 323, 522, -893},
    { 292, 461, -943},
    { 265, 391, -965},
    { 236, 411, -975},
    { 136, 333, -993},
    { 44, 280, -1028},
    { -82, 222, -986},
    { -171, 326, -947},
    { -39, 354, -973},
    { -23, 362, -942},
    { -60, 354, -922},
    { -69, 361, -891},
    { -75, 367, -926},
    { -66, 356, -943},
    { -71, 356, -932},
    { -75, 368, -914},
    { -81, 381, -924},
    { -96, 362, -915},
    { -89, 344, -892},
    { -103, 369, -917},
    { -95, 362, -900},
    { -100, 361, -908},
    { -101, 352, -917},
    { -95, 353, -919},
    { -76, 334, -921},
    { -71, 345, -932},
    { -96, 349, -933},
    { -68, 353, -918},
    { -53, 344, -897},
    { -50, 366, -891},
    { -26, 357, -893},
    { -12, 351, -903},
    { 20, 375, -941},
    { 10, 376, -932},
    { 10, 396, -910},
    { 62, 406, -964},
    { 50, 392, -960},
    { 64, 408, -1120},
    { -33, 152, -1313},
    { -74, 422, -1274},
    { -195, 543, -1758},
    { 36, 285, -1299},
    { 330, -35, -741},
    { 446, 260, -651},
    { 591, 357, -440},
    { 207, 515, -462},
    { -241, 345, -788},
    { -433, 796, -1186},
    { -281, 52, -900},
    { -98, -86, -1034},
    { -112, -459, -891},
    { -248, -620, -734},
    { -279, -628, -641},
    { -57, 104, -613},
    { 312, 734, -266},
    { 377, 927, -444},
    { 380, 1260, -673},
    { 258, 759, -470},
    { 725, 1191, -509},
    { 94, 1108, -526},
    { 268, 449, -514},
    { 249, 1047, -675},
    { 244, 750, -448},
    { 236, 847, -546},
    { 224, 781, -571},
    { 213, 748, -609},
    { 180, 758, -600},
    { 210, 825, -581},
    { 229, 808, -599},
    { 215, 793, -615},
    { 209, 722, -639},
    { 149, 759, -669},
    { 171, 682, -690},
    { 158, 651, -669},
    { 190, 720, -687},
    { 142, 667, -675},
    { 215, 721, -748},
    { 177, 767, -714},
    { 163, 634, -678},
    { 113, 608, -666},
    { 141, 673, -686},
    { 195, 744, -716},
    { 186, 759, -683},
    { 163, 675, -691},
    { 144, 589, -724},
    { 150, 609, -725},
    { 160, 666, -683},
    { 186, 831, -716},
    { 220, 810, -701},
    { 207, 744, -658},
    { 129, 491, -735},
    { 134, 681, -701},
    { 154, 758, -660},
    { 180, 677, -746},
    { 176, 651, -756},
    { 177, 651, -675},
    { 150, 680, -683},
    { 173, 680, -747},
    { 227, 780, -723},
    { 178, 739, -716},
    { 136, 561, -734},
    { 142, 623, -662},
    { 205, 725, -692},
    { 196, 781, -685},
    { 166, 647, -706},
    { 131, 655, -686},
    { 185, 754, -674},
    { 185, 718, -740},
    { 169, 708, -709},
    { 172, 656, -730},
    { 166, 657, -662},
    { 178, 718, -719},
    { 181, 652, -719},
    { 174, 677, -711},
    { 168, 659, -680},
    { 142, 679, -687},
    { 179, 662, -741},
    { 182, 662, -748},
    { 198, 677, -734},
    { 206, 698, -750},
    { 191, 718, -746},
    { 102, 452, -699},
    { 133, 653, -718},
    { 167, 699, -714},
    { 192, 680, -789},
    { 173, 571, -829},
    { 192, 655, -726},
    { 150, 594, -911},
    { 83, 685, -865},
    { 125, 869, -924},
    { 186, 925, -917},
    { 86, 380, -785},
    { 183, 263, -732},
    { 106, 4, -622},
    { -47, 27, -830},
    { -272, 194, -1011},
    { -247, -46, -1182},
    { -8, 197, -1166},
    { 131, 213, -1150},
    { 138, 95, -975},
    { 228, 306, -882},
    { 304, 260, -824},
    { 258, 183, -782},
    { 239, 104, -879},
    { 226, 64, -945},
    { 145, 78, -1006},
    { 8, -172, -940},
    { -80, -254, -967},
    { -161, -333, -997},
    { -178, -481, -976},
    { -214, -405, -1138},
    { -154, -458, -1102},
    { -19, -162, -1051},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-08-06 22:32:22 GMT
AccelRawData *activity_sample_running_100(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME running_100
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 94
  //> TEST_EXPECTED_MAX 110
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    { -269, -25, -389},
    { -281, 168, -83},
    { -163, 375, -103},
    { -109, 392, -372},
    { -195, 98, -836},
    { -283, 217, -1963},
    { -340, 135, -2088},
    { 224, -211, -1869},
    { 161, -501, -1308},
    { 274, -354, -599},
    { 568, -216, -308},
    { 354, -236, -212},
    { 549, 101, -433},
    { 575, -219, -1337},
    { 291, -221, -1690},
    { 269, -12, -2123},
    { -137, -201, -1363},
    { -234, -163, -657},
    { -140, 176, -184},
    { 44, 453, -22},
    { -84, 168, -330},
    { -288, -120, -769},
    { -189, 360, -1423},
    { -233, 510, -2068},
    { -202, -101, -1606},
    { -114, -703, -1389},
    { 150, 156, -546},
    { 327, -80, -91},
    { 387, -336, -487},
    { 531, -164, -722},
    { 509, -202, -1313},
    { 483, 202, -2060},
    { 82, -113, -2076},
    { -308, -390, -1386},
    { -264, -79, -964},
    { -163, 72, -268},
    { -169, 221, -6},
    { -78, 316, -186},
    { -354, 219, -256},
    { -633, 93, -654},
    { -994, 802, -1548},
    { -2116, 1226, -1609},
    { -1125, 702, -904},
    { -253, 1645, -1468},
    { 430, 1068, -1056},
    { 696, 815, -488},
    { 1567, 140, -749},
    { 2026, -18, -1238},
    { 946, 1059, -1466},
    { -378, 2205, -2597},
    { -1545, 2549, -1816},
    { -1122, 1109, -729},
    { -886, 358, -79},
    { -746, -263, 211},
    { -1441, -2165, 763},
    { -1175, -543, 647},
    { -1564, -460, 955},
    { -2513, 69, 1098},
    { -3451, 3999, -361},
    { -1189, 2993, -15},
    { 24, 1758, -191},
    { 882, 1073, -429},
    { 1112, 749, -415},
    { 2362, 113, -594},
    { 1014, 371, -225},
    { 341, 1775, -368},
    { -575, 3999, -1180},
    { -1008, 3999, 911},
    { -973, 1647, 626},
    { -1543, 159, 1015},
    { -896, 192, 161},
    { -1471, -1458, 977},
    { -1882, -1407, 725},
    { -1605, -504, 909},
    { -1823, -359, 681},
    { -3812, 1573, 1823},
    { -3613, 3999, 222},
    { -415, 3220, -582},
    { 263, 1250, 144},
    { 804, 693, -405},
    { 1922, 709, -965},
    { 1704, 33, -264},
    { 1166, 489, -399},
    { 112, 2451, -691},
    { -624, 3999, -692},
    { -737, 3999, 275},
    { -987, 1168, 807},
    { -2103, 198, 151},
    { -1102, -408, 948},
    { -1770, -2212, 1245},
    { -1525, -606, 567},
    { -1692, -319, 570},
    { -2285, -547, 829},
    { -3999, 3999, 238},
    { -1872, 3999, -355},
    { 3, 2243, -105},
    { 483, 925, 45},
    { 979, 626, -525},
    { 2636, 397, -565},
    { 1738, 521, -161},
    { 777, 1772, -415},
    { -507, 3999, -1161},
    { -862, 3999, -592},
    { -3858, 3293, 895},
    { -1836, 665, 731},
    { -1042, -240, 733},
    { -1681, -1947, 1085},
    { -1607, -871, 573},
    { -1933, -285, 574},
    { -2285, -569, 818},
    { -3999, 3338, 1036},
    { -2222, 3999, -384},
    { -212, 2300, -17},
    { 392, 1151, -59},
    { 662, 693, -142},
    { 1962, 814, -540},
    { 1830, 228, -497},
    { 1188, 805, -509},
    { 341, 1844, -418},
    { -102, 3999, -364},
    { -880, 3999, -434},
    { -2051, 1742, 1193},
    { -1991, 380, 536},
    { -874, 123, 463},
    { -1725, -2050, 897},
    { -1563, -1075, 577},
    { -1431, -576, 649},
    { -1649, -276, 451},
    { -3734, 2315, 2368},
    { -2565, 3999, -79},
    { -60, 2746, -395},
    { 412, 820, 142},
    { 856, 563, -410},
    { 2914, 488, -840},
    { 1771, 73, -60},
    { 1014, 536, -320},
    { -524, 3999, -1389},
    { -888, 3999, -1060},
    { -3999, 3999, 130},
    { -1453, 565, 581},
    { -1383, 462, -109},
    { -1409, -1046, 1010},
    { -1521, -1728, 776},
    { -1698, -316, 530},
    { -1516, -346, 485},
    { -2699, 478, 1408},
    { -3200, 3999, 303},
    { -1124, 3999, -360},
    { 9, 1760, -27},
    { 448, 683, -16},
    { 600, 334, -302},
    { 2193, 360, -509},
    { 1283, 328, -258},
    { 626, 1969, -382},
    { -367, 3410, -845},
    { -714, 3999, -417},
    { -3775, 3688, 862},
    { -1008, -20, 785},
    { -1131, 338, 276},
    { -1344, -1452, 1098},
    { -1499, -1476, 759},
    { -1639, -555, 683},
    { -1952, -509, 730},
    { -3999, 1749, 2224},
    { -3040, 3999, 220},
    { -432, 2902, -42},
    { 292, 1344, 267},
    { 713, 923, -49},
    { 2084, 819, -612},
    { 1696, 337, -251},
    { 1214, 715, -370},
    { 344, 2102, -434},
    { -371, 3999, -27},
    { -904, 3999, -102},
    { -2142, 1346, 927},
    { -2068, 59, 318},
    { -1059, -240, 565},
    { -1703, -2071, 945},
    { -1506, -709, 525},
    { -1536, -420, 505},
    { -1677, -340, 569},
    { -3786, 1990, 1794},
    { -2930, 3999, -97},
    { -317, 2715, -261},
    { 326, 1225, -69},
    { 561, 422, -158},
    { 1249, 612, -967},
    { 1660, 508, -434},
    { 1413, 37, -171},
    { 769, 2683, -480},
    { -173, 3999, -136},
    { -1053, 3999, 432},
    { -2123, 1410, 654},
    { -1354, -255, 273},
    { -1435, -341, 733},
    { -2108, -2138, 988},
    { -1760, -455, 837},
    { -1877, -27, 488},
    { -2843, -128, 1221},
    { -3999, 3999, 692},
    { -1284, 3999, -170},
    { 210, 1874, 29},
    { 563, 837, -89},
    { 1025, 750, -539},
    { 1681, 321, -804},
    { 1477, 158, -485},
    { 740, 705, -482},
    { -89, 3477, -912},
    { -778, 3999, -764},
    { -2993, 3999, 1205},
    { -831, 514, 710},
    { -1445, 341, 115},
    { -1296, -207, 803},
    { -1982, -2165, 1039},
    { -1551, -445, 704},
    { -1302, -370, 225},
    { -2447, -102, 1297},
    { -3830, 3999, -482},
    { -1194, 3999, 2},
    { 228, 1944, -23},
    { 561, 827, 19},
    { 1060, 677, -407},
    { 2044, 235, -798},
    { 1558, 58, -241},
    { 930, 312, -315},
    { 368, 3860, -816},
    { -466, 3999, -562},
    { -1249, 3767, -82},
    { -3103, 1527, 707},
    { -1012, 7, 251},
    { -1249, -364, 838},
    { -1874, -1943, 1021},
    { -1514, -669, 579},
    { -1706, -631, 477},
    { -3023, 375, 1357},
    { -3929, 3999, -432},
    { -959, 3999, -674},
    { 75, 1687, -179},
    { 570, 897, -346},
    { 710, 713, -533},
    { 2138, 755, -860},
    { 1263, 149, -548},
    { 693, 1146, -563},
    { -173, 3403, -927},
    { -759, 3999, -859},
    { -1311, 3297, 2137},
    { -746, 115, 989},
    { -1022, 309, 186},
    { -1293, -1018, 1007},
    { -1704, -1832, 810},
    { -1699, -224, 677},
    { -1657, -395, 583},
    { -3369, 598, 1556},
    { -3999, 3999, -606},
    { -1072, 3222, -249},
    { 69, 1881, -191},
    { 537, 767, -303},
    { 825, 583, -724},
    { 2720, 460, -660},
    { 1066, 446, -485},
    { 547, 1546, -540},
    { -237, 3999, -934},
    { -999, 3999, -1514},
    { -3999, 3999, 436},
    { -1338, -46, 50},
    { -1328, 45, 414},
    { -1812, -2148, 1232},
    { -1318, -969, 556},
    { -1484, -227, 454},
    { -1801, -506, 637},
    { -3999, 1913, 2027},
    { -3259, 3999, -124},
    { -386, 2935, -339},
    { 352, 1482, 57},
    { 672, 732, -279},
    { 858, 667, -651},
    { 2953, 438, -407},
    { 1312, 430, -351},
    { 507, 1638, -313},
    { -198, 3999, -798},
    { -1073, 3999, -1026},
    { -3999, 3503, 929},
    { -1256, 156, 300},
    { -973, 309, 245},
    { -1256, -973, 1113},
    { -1609, -1353, 618},
    { -1311, -315, 592},
    { -1421, -379, 454},
    { -3082, 277, 1552},
    { -3576, 3999, -585},
    { -977, 3157, -161},
    { 229, 2041, -152},
    { 588, 739, -203},
    { 925, 690, -634},
    { 2525, 115, -807},
    { 1465, 59, -288},
    { 835, 769, -542},
    { -105, 3395, -1201},
    { -679, 3999, -868},
    { -1053, 3461, 404},
    { -1878, 661, 897},
    { -1262, 285, 217},
    { -1239, -668, 688},
    { -1877, -1880, 715},
    { -1569, -489, 740},
    { -1689, -148, 575},
    { -3306, 785, 1672},
    { -3387, 3999, -485},
    { -726, 3008, -263},
    { 237, 1742, -80},
    { 559, 785, -107},
    { 836, 689, -380},
    { 1770, 404, -824},
    { 1703, 185, -388},
    { 988, 773, -478},
    { 219, 2781, -692},
    { -501, 3999, -883},
    { -997, 3820, -200},
    { -2497, 1119, 585},
    { -1239, 281, 337},
    { -1170, -254, 1020},
    { -1852, -2051, 1141},
    { -1495, -405, 683},
    { -1546, -305, 398},
    { -2435, 13, 947},
    { -3427, 3999, -235},
    { -1214, 3982, -250},
    { 154, 1848, -265},
    { 490, 936, -287},
    { 543, 617, -478},
    { 757, 488, -851},
    { 1528, 556, -536},
    { 866, 59, -514},
    { 273, 1740, -383},
    { 186, 3999, -453},
    { -890, 3999, -246},
    { -3929, 2812, 504},
    { -944, -125, 104},
    { -942, 64, 674},
    { -1865, -1813, 1200},
    { -1221, -810, 818},
    { -1363, -332, 378},
    { -1839, -490, 988},
    { -3999, 3945, 901},
    { -2764, 3999, -197},
    { -179, 2523, -289},
    { 440, 1066, 17},
    { 695, 590, -142},
    { 2433, 411, -595},
    { 1338, 312, -502},
    { 852, 294, -441},
    { 402, 1692, -504},
    { -116, 3999, -1263},
    { -1027, 3999, -623},
    { -3776, 2546, 41},
    { -1341, 256, 252},
    { -1124, 161, 564},
    { -1949, -1881, 1419},
    { -1563, -861, 987},
    { -1695, -315, 524},
    { -2430, -478, 1330},
    { -3999, 3999, 890},
    { -2615, 3999, 55},
    { -150, 2413, -111},
    { 419, 1498, -45},
    { 622, 920, -182},
    { 952, 805, -288},
    { 1976, 307, -339},
    { 1021, 491, -482},
    { 593, 754, -294},
    { 435, 2905, -751},
    { -1006, 3999, -1220},
    { -3999, 3932, 618},
    { -2299, 567, 593},
    { -806, 316, -278},
    { -778, -198, 1295},
    { -1855, -2245, 1551},
    { -1108, -390, 1044},
    { -1178, -329, 505},
    { -2648, 397, 1239},
    { -3826, 3999, -513},
    { -790, 3434, -250},
    { 420, 1917, -33},
    { 1001, 1309, -315},
    { 2524, 816, -717},
    { 1461, 333, -684},
    { 912, 68, -357},
    { 411, 1088, -454},
    { -313, 3999, -1011},
    { -918, 3999, -1224},
    { -3999, 3999, -110},
    { -1147, 517, 784},
    { -1388, 291, -157},
    { -1165, -46, 600},
    { -1723, -1987, 998},
    { -1151, -424, 578},
    { -1087, -149, 360},
    { -1704, -407, 1092},
    { -3929, 3999, 291},
    { -1839, 3999, 622},
    { 62, 2770, -37},
    { 518, 1166, 172},
    { 1239, 1290, -278},
    { 1628, 288, -643},
    { 1349, 280, -609},
    { 733, 200, -408},
    { 419, 2011, -724},
    { -329, 3999, -1017},
    { -1106, 3805, -735},
    { -2454, 2331, 368},
    { -720, -264, 313},
    { -983, 428, 520},
    { -1457, -1350, 1070},
    { -1531, -821, 632},
    { -1429, -219, 357},
    { -1616, -355, 608},
    { -3895, 3252, 965},
    { -2111, 3999, -147},
    { -37, 2510, -129},
    { 504, 1213, -74},
    { 780, 817, -140},
    { 2004, 543, -597},
    { 1436, 308, -635},
    { 1052, 55, -479},
    { 485, 1322, -521},
    { -303, 3999, -651},
    { -780, 3999, -469},
    { -3090, 3202, 432},
    { -578, 255, 574},
    { -846, 460, 468},
    { -1083, -804, 868},
    { -1962, -1155, 911},
    { -1322, -437, 715},
    { -1279, -160, 276},
    { -2574, 534, 1107},
    { -3151, 3999, -473},
    { -793, 3406, -63},
    { 264, 2084, -168},
    { 636, 902, 158},
    { 1903, 975, -357},
    { 1561, 136, -588},
    { 1407, 204, -566},
    { 685, 628, -481},
    { 87, 3496, -1042},
    { -388, 3999, -636},
    { -1100, 3350, -242},
    { -2568, 1747, 604},
    { -754, 95, 313},
    { -1122, -10, 734},
    { -1493, -1421, 883},
    { -1320, -431, 470},
    { -1300, -300, 182},
    { -1790, -390, 725},
    { -3999, 3999, 115},
    { -1815, 3999, -206},
    { 36, 2400, -186},
    { 413, 995, -45},
    { 656, 658, -20},
    { 1608, 584, -516},
    { 1755, 109, -488},
    { 1333, 266, -349},
    { 539, 1551, -313},
    { 83, 3999, -924},
    { -876, 3999, -63},
    { -3465, 2864, 349},
    { -695, 120, 355},
    { -750, 220, -16},
    { -914, -206, 601},
    { -1935, -1519, 723},
    { -1042, -389, 649},
    { -1368, -201, 436},
    { -2448, -104, 1180},
    { -3999, 3999, 96},
    { -1256, 3999, -261},
    { 111, 1988, 95},
    { 551, 906, 40},
    { 939, 819, -362},
    { 2075, 323, -893},
    { 1606, 162, -287},
    { 856, 235, -145},
    { 413, 2913, -787},
    { -537, 3999, -530},
    { -1283, 3999, 86},
    { -1714, 1353, 519},
    { -1132, 361, 231},
    { -920, 140, 439},
    { -1673, -1453, 927},
    { -1397, -760, 459},
    { -1256, -332, 428},
    { -1422, -343, 468},
    { -2804, 1702, 1021},
    { -2150, 3999, -271},
    { -183, 2708, -253},
    { 385, 1263, 17},
    { 649, 692, -58},
    { 965, 515, -348},
    { 1740, 321, -853},
    { 1365, 112, -356},
    { 721, 688, -348},
    { 228, 3889, -926},
    { -531, 3999, -651},
    { -985, 3015, 316},
    { -1936, 1011, 632},
    { -847, 319, 141},
    { -1012, -195, 699},
    { -1483, -1439, 780},
    { -1315, -512, 416},
    { -1284, -263, 155},
    { -1824, -255, 705},
    { -3984, 3999, 386},
    { -1591, 3999, -227},
    { 32, 2229, -182},
    { 424, 1006, -60},
    { 674, 708, -241},
    { 1195, 460, -882},
    { 1949, 400, -667},
    { 1064, 314, -395},
    { 569, 2136, -649},
    { -147, 3999, -523},
    { -958, 3601, -169},
    { -2888, 2536, 400},
    { -648, -111, 112},
    { -846, 174, 287},
    { -1498, -1326, 990},
    { -1386, -827, 713},
    { -1318, -222, 456},
    { -1309, -328, 473},
    { -3177, 2702, 766},
    { -2308, 3999, -396},
    { -168, 2508, -322},
    { 266, 1137, -15},
    { 541, 502, -191},
    { 875, 598, -565},
    { 2378, 266, -371},
    { 1094, 429, -305},
    { 435, 1549, -378},
    { 230, 3999, -454},
    { -840, 3999, -472},
    { -1476, 2316, 745},
    { -1031, 45, 459},
    { -984, 250, 229},
    { -1538, -1163, 782},
    { -1478, -1089, 668},
    { -1383, -160, 557},
    { -1496, -197, 451},
    { -3077, 1775, 1469},
    { -2276, 3999, -348},
    { -198, 2664, -324},
    { 409, 1324, -48},
    { 600, 624, -227},
    { 689, 511, -348},
    { 1253, 301, -704},
    { 1472, -54, -463},
    { 688, 516, -373},
    { 220, 2836, -614},
    { -171, 3999, -671},
    { -952, 3238, 663},
    { -1046, 875, 522},
    { -795, 10, 59},
    { -657, 167, 327},
    { -1357, -1328, 1101},
    { -1263, -845, 763},
    { -1127, -437, 512},
    { -1701, -367, 809},
    { -3999, 3965, 388},
    { -2583, 3999, -382},
    { -109, 2704, -289},
    { 442, 1241, -55},
    { 661, 736, -170},
    { 1891, 592, -720},
    { 1627, 57, -536},
    { 1126, -88, -176},
    { 587, 840, -397},
    { -66, 3999, -1430},
    { -743, 3999, -1148},
    { -1126, 2746, 695},
    { -871, 268, 397},
    { -1009, 484, 9},
    { -1116, -599, 823},
    { -1586, -1566, 646},
    { -1176, -168, 476},
    { -1228, -253, 308},
    { -2505, 677, 1019},
    { -2782, 3999, -552},
    { -754, 3407, -458},
    { 188, 1628, -48},
    { 512, 841, -87},
    { 725, 548, -438},
    { 1145, 556, -896},
    { 2312, 214, -213},
    { 1057, 381, -180},
    { 509, 2748, -755},
    { -178, 3999, -679},
    { -1001, 3725, -270},
    { -2814, 2038, 92},
    { -714, 193, 114},
    { -878, 172, 302},
    { -1635, -1303, 980},
    { -1383, -921, 542},
    { -1480, -193, 389},
    { -1701, -321, 736},
    { -3909, 3694, 678},
    { -2398, 3999, -321},
    { -161, 2375, -296},
    { 359, 1252, -50},
    { 597, 784, -274},
    { 700, 672, -378},
    { 2302, 484, -440},
    { 1235, 186, -427},
    { 649, 871, -240},
    { 360, 3545, -610},
    { -835, 3999, -845},
    { -2292, 3611, 1132},
    { -819, 490, 551},
    { -1062, 303, 112},
    { -714, -155, 780},
    { -1594, -1581, 1022},
    { -1158, -389, 630},
    { -1317, -267, 328},
    { -1868, -465, 953},
    { -3988, 3871, 543},
    { -2467, 3999, -363},
    { -213, 2439, -216},
    { 325, 1367, -74},
    { 513, 730, -164},
    { 763, 684, -387},
    { 2935, 370, -557},
    { 1127, 450, -461},
    { 565, 896, -334},
    { 138, 3398, -771},
    { -919, 3999, -1025},
    { -1369, 3287, 1282},
    { -824, 484, 419},
    { -1163, 520, 74},
    { -897, -168, 901},
    { -1814, -1484, 1166},
    { -1301, -493, 778},
    { -1376, -316, 346},
    { -2296, -6, 1074},
    { -3865, 3999, -77},
    { -1402, 3999, -9},
    { 156, 2292, -52},
    { 574, 810, -50},
    { 861, 764, -143},
    { 2078, 149, -484},
    { 1284, 108, -402},
    { 821, 9, -326},
    { 489, 799, -261},
    { 231, 3999, -791},
    { -857, 3999, -1064},
    { -1667, 2775, 551},
    { -958, 244, 489},
    { -919, -180, -26},
    { -860, 307, 397},
    { -1633, -1519, 1138},
    { -1076, -465, 805},
    { -1329, -124, 427},
    { -2563, 843, 828},
    { -3023, 3999, -401},
    { -646, 3276, -77},
    { 307, 2274, -168},
    { 623, 1143, 109},
    { 1167, 1071, -1},
    { 1687, 315, -329},
    { 1440, 227, -507},
    { 905, 106, -274},
    { 501, 906, -371},
    { 183, 3999, -979},
    { -952, 3999, -1606},
    { -3999, 3151, -25},
    { -753, 62, 170},
    { -1008, 444, -2},
    { -1127, -654, 1028},
    { -1507, -1191, 837},
    { -1068, -272, 548},
    { -1119, -257, 364},
    { -2690, 910, 1033},
    { -2867, 3999, -542},
    { -548, 3081, -153},
    { 400, 2018, -149},
    { 616, 904, 135},
    { 1105, 977, -113},
    { 1972, 145, -475},
    { 1355, 240, -371},
    { 748, 247, -220},
    { 488, 2454, -785},
    { 141, 3999, -752},
    { -1037, 3999, -989},
    { -1840, 2070, 136},
    { -1089, -248, 73},
    { -1012, 197, 394},
    { -1654, -1305, 1068},
    { -1292, -648, 601},
    { -1260, -250, 357},
    { -1602, -296, 671},
    { -3999, 3999, -91},
    { -1800, 3999, -399},
    { 77, 2519, -274},
    { 422, 1005, -51},
    { 661, 683, -104},
    { 1072, 467, -229},
    { 1898, 88, -620},
    { 1331, 216, -429},
    { 655, 845, -294},
    { 329, 3999, -747},
    { -638, 3999, -595},
    { -1064, 2712, 145},
    { -1882, 911, 581},
    { -581, 243, -42},
    { -724, -124, 619},
    { -1976, -1696, 1094},
    { -1200, -174, 756},
    { -1539, -263, 659},
    { -2475, 445, 1054},
    { -3570, 3999, -637},
    { -1005, 3562, -460},
    { 190, 1943, -176},
    { 595, 1083, 150},
    { 2701, 1149, -377},
    { 1554, 246, -637},
    { 1421, 133, -385},
    { 597, 502, -388},
    { 187, 3071, -923},
    { -496, 3999, -878},
    { -1176, 3005, -713},
    { -1463, 1533, 192},
    { -927, -187, 67},
    { -1192, 256, 393},
    { -2378, -1877, 1282},
    { -1433, -498, 869},
    { -1550, 77, 279},
    { -2065, 16, 858},
    { -3999, 3999, -139},
    { -1696, 3999, -446},
    { 78, 2112, -408},
    { 398, 823, -87},
    { 568, 437, -119},
    { 1679, 454, -701},
    { 1613, 233, -502},
    { 1167, 614, -385},
    { 221, 2968, -807},
    { -134, 3999, -699},
    { -1232, 3915, -841},
    { -2728, 2228, 487},
    { -595, -393, 196},
    { -979, 200, 588},
    { -1512, -1298, 1127},
    { -1565, -568, 692},
    { -1568, -97, 262},
    { -2031, -332, 630},
    { -3999, 3999, -278},
    { -1770, 3999, -383},
    { 0, 2255, -120},
    { 412, 1021, -38},
    { 591, 695, -171},
    { 696, 499, -147},
    { 2354, 168, -535},
    { 1193, 444, -511},
    { 621, 1133, -346},
    { -60, 3953, -1195},
    { -692, 3999, -733},
    { -1486, 3075, 1640},
    { -662, 471, 708},
    { -679, 256, 213},
    { -665, -240, 681},
    { -1918, -1619, 1170},
    { -1220, -362, 849},
    { -1506, -307, 600},
    { -2068, -478, 1024},
    { -3999, 3999, 244},
    { -2182, 3999, -400},
    { -25, 2417, -230},
    { 531, 1299, -170},
    { 673, 779, -223},
    { 1184, 617, -761},
    { 2216, 277, -588},
    { 1078, 468, -420},
    { 450, 2108, -576},
    { -91, 3999, -818},
    { -1156, 3999, -1372},
    { -3346, 2939, 193},
    { -601, -189, 224},
    { -909, 434, 272},
    { -1159, -1084, 1027},
    { -1439, -913, 757},
    { -1359, -153, 437},
    { -1483, -316, 493},
    { -2895, 1030, 1077},
    { -2763, 3999, -555},
    { -584, 3145, -259},
    { 347, 1804, -123},
    { 541, 748, -27},
    { 1108, 735, -299},
    { 1979, 97, -708},
    { 1352, 218, -357},
    { 716, 730, -357},
    { 108, 3929, -1078},
    { -589, 3999, -516},
    { -1005, 3100, 269},
    { -1772, 907, 583},
    { -531, -53, 189},
    { -596, 131, 303},
    { -1401, -1093, 1111},
    { -1296, -812, 629},
    { -1306, -281, 583},
    { -1634, -259, 768},
    { -3830, 2459, 881},
    { -2874, 3999, -256},
    { -320, 2755, -266},
    { 402, 1692, -154},
    { 573, 712, 13},
    { 1270, 736, -403},
    { 1966, 188, -568},
    { 1416, 275, -326},
    { 710, 894, -493},
    { -63, 2889, -488},
    { -234, 3999, -351},
    { -1074, 3715, -250},
    { -2844, 1928, 496},
    { -953, -183, 46},
    { -1288, -137, 505},
    { -1851, -1873, 1078},
    { -1256, -447, 527},
    { -1307, -165, 283},
    { -2160, -146, 1129},
    { -3769, 3999, 233},
    { -1380, 3999, -146},
    { 57, 1940, -141},
    { 450, 781, -143},
    { 708, 665, -289},
    { 1820, 459, -621},
    { 1506, 312, -381},
    { 1033, 551, -441},
    { 286, 2283, -449},
    { -33, 3999, -564},
    { -1025, 3999, -287},
    { -3495, 2516, 564},
    { -509, 40, 291},
    { -684, 30, 250},
    { -958, -166, 616},
    { -1699, -1663, 795},
    { -1104, -240, 628},
    { -1348, -198, 293},
    { -2407, -52, 1160},
    { -3459, 3999, -85},
    { -1239, 3947, -2},
    { 131, 2225, -105},
    { 531, 995, -103},
    { 607, 731, -247},
    { 1448, 685, -1075},
    { 1859, 279, -291},
    { 993, 427, -303},
    { 348, 2775, -587},
    { -398, 3999, -797},
    { -1084, 3993, -488},
    { -3010, 1887, 474},
    { -812, -274, 192},
    { -1132, 161, 454},
    { -1567, -1350, 1028},
    { -1194, -639, 498},
    { -1381, -90, 352},
    { -1677, -230, 503},
    { -3587, 2450, 1369},
    { -2612, 3999, -344},
    { -269, 2692, -203},
    { 373, 1415, -119},
    { 497, 558, -74},
    { 708, 549, -99},
    { 2736, 344, -299},
    { 1228, 773, -465},
    { 526, 1240, -399},
    { -71, 2572, -467},
    { -272, 3999, -474},
    { -834, 2754, 435},
    { -1940, 851, 574},
    { -635, -25, 140},
    { -895, -190, 813},
    { -1798, -1631, 930},
    { -1120, -344, 747},
    { -1322, -189, 383},
    { -1823, -295, 1018},
    { -3999, 3999, 834},
    { -2308, 3999, -311},
    { -175, 2309, -215},
    { 411, 1175, -150},
    { 533, 536, -346},
    { 1042, 647, -880},
    { 2204, 146, -404},
    { 832, 415, -508},
    { 149, 1930, -590},
    { -298, 3999, -840},
    { -1014, 3999, -718},
    { -2813, 1985, 220},
    { -866, 251, 399},
    { -746, 395, -121},
    { -773, -321, 793},
    { -1482, -1737, 671},
    { -1192, -247, 459},
    { -1063, 8, -98},
    { -2211, 2205, 13},
    { -1921, 3999, -546},
    { -42, 2373, -859},
    { 374, 1158, -242},
    { 618, 768, -244},
    { 1341, 465, -394},
    { 1412, 149, -240},
    { 975, 624, -199},
    { 574, 981, 70},
    { 735, 2000, -61},
    { 85, 2816, -223},
    { -326, 1654, -472},
    { -414, 1196, -969},
    { -620, 99, -468},
    { -794, -469, -387},
    { -103, 351, -267},
    { -212, 624, -390},
    { -444, 493, -359},
    { -436, 185, -1164},
    { 286, -32, -1712},
    { 80, 12, -2224},
    { 161, -325, -1648},
    { 595, -686, -1241},
    { 303, -530, -526},
    { 388, 0, 124},
    { 450, -1, 145},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

// ----------------------------------------------------------------
// Sample captured: 2015-08-07 02:21:25 GMT
AccelRawData *activity_sample_walk_slow_30(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_30_slow
  //> TEST_EXPECTED 30
  //> TEST_EXPECTED_MIN 24
  //> TEST_EXPECTED_MAX 33
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    { -439, -121, -903},
    { -457, -45, -858},
    { -385, 9, -806},
    { -409, 59, -763},
    { -438, 98, -764},
    { -503, 38, -765},
    { -460, -35, -748},
    { -385, -103, -778},
    { -364, -113, -811},
    { -372, -99, -860},
    { -377, -76, -888},
    { -361, -74, -903},
    { -345, -101, -898},
    { -351, -78, -929},
    { -363, -42, -903},
    { -455, -35, -974},
    { -755, 21, -941},
    { -697, -11, -962},
    { -686, -157, -900},
    { -606, -176, -805},
    { -606, -129, -649},
    { -579, -97, -601},
    { -603, -20, -694},
    { -593, 36, -746},
    { -556, -24, -771},
    { -315, -91, -786},
    { -549, -107, -802},
    { -540, -84, -848},
    { -579, -136, -804},
    { -572, -156, -775},
    { -527, -131, -812},
    { -445, -183, -884},
    { -545, -97, -992},
    { -467, -177, -976},
    { -422, -98, -963},
    { -160, -161, -1109},
    { -416, -106, -1102},
    { -308, -97, -1033},
    { -181, 11, -989},
    { -96, 50, -967},
    { -21, 4, -817},
    { 17, 70, -837},
    { 17, 63, -885},
    { -27, 46, -882},
    { -62, 82, -961},
    { -44, 40, -967},
    { -3, -3, -905},
    { 25, -17, -875},
    { 6, -37, -861},
    { 6, -173, -668},
    { -54, -129, -561},
    { -228, 108, -550},
    { -429, 297, -394},
    { -683, 395, -169},
    { -923, 579, -105},
    { -1208, 758, -103},
    { -1572, 975, -41},
    { -1624, 1162, 42},
    { -1051, 722, -186},
    { -1022, 191, -164},
    { -800, 303, -94},
    { -696, 450, -27},
    { -824, 453, 16},
    { -888, 458, 14},
    { -894, 405, 33},
    { -862, 377, -21},
    { -776, 385, -75},
    { -796, 427, -68},
    { -872, 242, -223},
    { -930, 142, -277},
    { -734, 75, -253},
    { -829, 446, -210},
    { -806, 510, -89},
    { -872, 476, -23},
    { -916, 393, 29},
    { -1253, 380, 60},
    { -1160, 448, -3},
    { -936, 428, -4},
    { -964, 413, 6},
    { -758, 371, -53},
    { -690, 367, -46},
    { -846, 342, 0},
    { -924, 417, 53},
    { -941, 406, 98},
    { -910, 400, 88},
    { -837, 330, 98},
    { -803, 307, 82},
    { -834, 337, 61},
    { -819, 352, 65},
    { -770, 296, 68},
    { -773, 296, 57},
    { -824, 309, 49},
    { -865, 356, 33},
    { -878, 410, -35},
    { -902, 444, -45},
    { -1202, 484, 13},
    { -1114, 458, -10},
    { -868, 388, -73},
    { -869, 397, -78},
    { -765, 425, -85},
    { -782, 417, -111},
    { -833, 451, -109},
    { -913, 425, -49},
    { -906, 389, -25},
    { -849, 374, -29},
    { -793, 341, -39},
    { -793, 324, -33},
    { -801, 235, -65},
    { -773, 204, -95},
    { -761, 308, -110},
    { -798, 384, -109},
    { -850, 449, -63},
    { -911, 419, -34},
    { -907, 371, -17},
    { -1133, 400, 29},
    { -1113, 456, -26},
    { -1008, 473, -13},
    { -968, 391, -20},
    { -798, 369, -83},
    { -783, 311, -103},
    { -925, 306, -47},
    { -981, 401, -26},
    { -914, 454, 7},
    { -817, 334, 19},
    { -746, 264, 41},
    { -802, 288, 68},
    { -821, 295, 85},
    { -801, 316, 93},
    { -769, 316, 111},
    { -782, 331, 113},
    { -842, 358, 65},
    { -859, 384, 5},
    { -1077, 423, 21},
    { -1268, 416, 70},
    { -971, 396, -51},
    { -931, 438, -183},
    { -790, 477, -203},
    { -795, 250, -257},
    { -829, 490, -431},
    { -952, 362, -172},
    { -891, 357, -115},
    { -816, 372, -15},
    { -777, 296, 27},
    { -813, 325, -5},
    { -772, 300, -63},
    { -740, 281, -124},
    { -738, 285, -135},
    { -765, 333, -87},
    { -857, 447, -130},
    { -922, 445, -98},
    { -939, 429, -80},
    { -1116, 469, -52},
    { -1169, 553, -83},
    { -911, 483, -61},
    { -868, 364, -35},
    { -902, 369, -36},
    { -729, 366, -68},
    { -818, 410, -47},
    { -924, 447, -27},
    { -965, 409, 49},
    { -909, 375, 67},
    { -830, 303, 85},
    { -794, 311, 83},
    { -823, 308, 98},
    { -823, 318, 109},
    { -795, 314, 102},
    { -772, 300, 91},
    { -793, 306, 83},
    { -836, 325, 69},
    { -911, 362, 13},
    { -915, 395, -21},
    { -1242, 463, 6},
    { -1150, 493, -82},
    { -909, 479, -208},
    { -819, 480, -167},
    { -692, 434, -119},
    { -836, 267, -105},
    { -906, 344, -45},
    { -927, 414, -6},
    { -821, 399, -21},
    { -740, 387, -38},
    { -741, 346, -41},
    { -790, 316, -72},
    { -812, 297, -85},
    { -760, 317, -109},
    { -754, 410, -142},
    { -807, 448, -128},
    { -889, 394, -96},
    { -908, 426, -53},
    { -1081, 393, 9},
    { -1178, 514, -29},
    { -1010, 487, -6},
    { -955, 411, -24},
    { -876, 370, -22},
    { -754, 353, -35},
    { -765, 314, -23},
    { -834, 358, -9},
    { -961, 447, 43},
    { -936, 390, 70},
    { -820, 353, 70},
    { -773, 294, 61},
    { -798, 336, 69},
    { -792, 324, 65},
    { -751, 308, 61},
    { -749, 307, 73},
    { -891, 343, 86},
    { -944, 390, 49},
    { -1172, 432, 66},
    { -1078, 407, 18},
    { -1012, 429, -106},
    { -1014, 464, -178},
    { -713, 376, -192},
    { -702, 277, -163},
    { -844, 258, -130},
    { -953, 298, -131},
    { -922, 247, -130},
    { -833, 266, -137},
    { -779, 285, -119},
    { -768, 281, -116},
    { -728, 256, -110},
    { -718, 289, -120},
    { -723, 344, -140},
    { -770, 335, -105},
    { -909, 410, -100},
    { -981, 431, -75},
    { -1249, 511, -25},
    { -1191, 579, -60},
    { -953, 478, -51},
    { -965, 450, -64},
    { -781, 407, -87},
    { -712, 385, -84},
    { -809, 342, -31},
    { -913, 465, -41},
    { -1031, 414, 52},
    { -943, 368, 97},
    { -835, 293, 71},
    { -845, 303, 85},
    { -838, 309, 101},
    { -781, 309, 102},
    { -736, 288, 91},
    { -738, 284, 98},
    { -839, 315, 106},
    { -880, 337, 63},
    { -978, 380, 10},
    { -1280, 402, 62},
    { -1087, 396, -23},
    { -899, 416, -162},
    { -791, 496, -202},
    { -687, 438, -151},
    { -760, 333, -113},
    { -916, 371, -54},
    { -933, 431, -47},
    { -849, 445, -76},
    { -814, 368, -45},
    { -823, 317, -18},
    { -835, 296, -20},
    { -792, 290, -64},
    { -767, 293, -117},
    { -774, 352, -133},
    { -808, 443, -158},
    { -889, 402, -111},
    { -936, 395, -77},
    { -1034, 360, -20},
    { -1244, 510, -50},
    { -992, 498, -37},
    { -856, 402, -45},
    { -856, 392, -30},
    { -737, 373, -26},
    { -870, 421, -26},
    { -947, 445, 26},
    { -936, 383, 76},
    { -881, 342, 101},
    { -841, 313, 94},
    { -814, 312, 104},
    { -798, 321, 115},
    { -782, 318, 109},
    { -751, 303, 115},
    { -759, 305, 107},
    { -805, 322, 96},
    { -865, 353, 50},
    { -859, 397, -33},
    { -891, 420, -96},
    { -1213, 423, 60},
    { -1198, 441, -4},
    { -908, 453, -117},
    { -923, 544, -167},
    { -791, 493, -170},
    { -803, 335, -134},
    { -907, 384, -111},
    { -916, 383, -64},
    { -847, 394, -60},
    { -832, 372, -63},
    { -785, 331, -53},
    { -782, 304, -54},
    { -749, 311, -85},
    { -735, 323, -91},
    { -745, 326, -110},
    { -800, 354, -112},
    { -847, 367, -101},
    { -903, 399, -87},
    { -958, 408, -50},
    { -1248, 498, -23},
    { -1077, 499, -28},
    { -897, 386, -17},
    { -918, 382, -4},
    { -746, 374, -45},
    { -842, 400, -37},
    { -952, 419, -31},
    { -973, 393, 0},
    { -860, 335, 4},
    { -767, 286, 12},
    { -760, 293, 22},
    { -803, 296, 36},
    { -851, 294, 73},
    { -822, 283, 91},
    { -774, 321, 73},
    { -819, 365, 27},
    { -792, 384, -26},
    { -1102, 432, 2},
    { -1190, 379, 53},
    { -1236, 419, -22},
    { -919, 394, -176},
    { -609, 381, -185},
    { -670, 340, -119},
    { -819, 275, -74},
    { -926, 292, -60},
    { -889, 320, -33},
    { -788, 318, -101},
    { -748, 369, -116},
    { -827, 364, -111},
    { -750, 319, -114},
    { -704, 371, -200},
    { -891, 416, -120},
    { -945, 390, -47},
    { -825, 370, -47},
    { -920, 418, -41},
    { -923, 462, 30},
    { -1157, 500, 56},
    { -972, 466, 30},
    { -941, 473, 34},
    { -953, 447, 60},
    { -917, 399, 63},
    { -888, 373, 67},
    { -956, 378, 82},
    { -971, 383, 94},
    { -940, 372, 89},
    { -840, 299, 110},
    { -798, 283, 121},
    { -809, 283, 125},
    { -813, 286, 149},
    { -801, 281, 170},
    { -800, 312, 158},
    { -792, 336, 165},
    { -831, 364, 139},
    { -888, 369, 120},
    { -1152, 402, 157},
    { -1169, 325, 161},
    { -986, 353, -34},
    { -911, 406, -167},
    { -717, 388, -200},
    { -751, 357, -201},
    { -879, 324, -250},
    { -955, 274, -234},
    { -899, 344, -208},
    { -834, 440, -231},
    { -821, 401, -140},
    { -833, 338, -81},
    { -831, 305, -42},
    { -790, 307, -30},
    { -760, 344, -28},
    { -768, 374, -49},
    { -808, 374, -28},
    { -860, 381, -27},
    { -880, 400, -37},
    { -886, 415, -54},
    { -933, 411, -53},
    { -1298, 500, -11},
    { -1063, 470, -26},
    { -815, 346, -55},
    { -876, 353, -37},
    { -753, 358, -84},
    { -912, 407, -61},
    { -1015, 421, -46},
    { -954, 379, 7},
    { -853, 329, -2},
    { -771, 276, 22},
    { -748, 258, 21},
    { -793, 273, 30},
    { -800, 262, 65},
    { -785, 269, 76},
    { -778, 301, 79},
    { -872, 342, 70},
    { -883, 378, 12},
    { -1087, 402, 33},
    { -1209, 397, 37},
    { -1124, 451, -47},
    { -992, 502, -182},
    { -719, 463, -232},
    { -661, 358, -189},
    { -835, 304, -118},
    { -964, 322, -84},
    { -901, 318, -90},
    { -831, 325, -111},
    { -799, 341, -115},
    { -810, 324, -105},
    { -772, 272, -102},
    { -728, 269, -108},
    { -725, 315, -138},
    { -758, 312, -137},
    { -839, 397, -138},
    { -953, 368, -63},
    { -1177, 411, -14},
    { -1275, 561, -41},
    { -1027, 528, -6},
    { -858, 364, -49},
    { -788, 385, -76},
    { -730, 410, -55},
    { -860, 407, -36},
    { -976, 438, -3},
    { -1013, 385, 61},
    { -934, 336, 57},
    { -807, 305, 34},
    { -795, 320, 32},
    { -799, 324, 42},
    { -795, 282, 64},
    { -762, 241, 70},
    { -773, 270, 75},
    { -834, 299, 85},
    { -866, 339, 44},
    { -857, 371, -12},
    { -1208, 418, 51},
    { -1176, 406, 45},
    { -1098, 476, -59},
    { -887, 472, -126},
    { -653, 393, -146},
    { -706, 308, -76},
    { -890, 391, -85},
    { -953, 403, -41},
    { -852, 349, -38},
    { -757, 376, -72},
    { -779, 389, -84},
    { -818, 353, -80},
    { -808, 321, -76},
    { -768, 314, -107},
    { -775, 363, -130},
    { -813, 389, -125},
    { -883, 383, -101},
    { -950, 388, -60},
    { -1090, 424, -17},
    { -1211, 514, -24},
    { -942, 460, -3},
    { -908, 386, -3},
    { -932, 386, 4},
    { -801, 392, -11},
    { -792, 378, -10},
    { -860, 392, 5},
    { -896, 393, 44},
    { -874, 357, 47},
    { -823, 328, 71},
    { -787, 277, 83},
    { -802, 294, 88},
    { -805, 291, 111},
    { -784, 303, 118},
    { -841, 339, 136},
    { -932, 357, 141},
    { -885, 358, 104},
    { -1206, 378, 160},
    { -1091, 386, 26},
    { -837, 407, -162},
    { -758, 437, -252},
    { -747, 396, -223},
    { -849, 350, -198},
    { -990, 306, -168},
    { -980, 352, -149},
    { -859, 392, -168},
    { -855, 389, -123},
    { -770, 344, -97},
    { -681, 300, -48},
    { -636, 359, -124},
    { -765, 451, -145},
    { -876, 409, -54},
    { -919, 298, 41},
    { -899, 310, 0},
    { -788, 400, -39},
    { -1002, 471, 0},
    { -1161, 541, -63},
    { -1057, 502, 1},
    { -978, 345, 11},
    { -894, 388, -5},
    { -774, 387, -41},
    { -837, 405, -23},
    { -866, 406, 10},
    { -940, 358, 114},
    { -889, 310, 177},
    { -855, 301, 188},
    { -855, 293, 219},
    { -853, 292, 240},
    { -848, 319, 215},
    { -821, 337, 197},
    { -844, 326, 212},
    { -851, 320, 192},
    { -873, 338, 134},
    { -902, 369, 53},
    { -1043, 375, 96},
    { -1041, 363, 10},
    { -934, 379, -130},
    { -697, 332, -173},
    { -881, 480, -278},
    { -1118, 590, -343},
    { -885, 292, -70},
    { -1017, 133, 67},
    { -817, 164, -22},
    { -743, 393, -152},
    { -772, 488, -66},
    { -796, 414, -83},
    { -861, 430, -96},
    { -900, 443, -69},
    { -859, 373, -55},
    { -823, 308, -35},
    { -865, 303, -43},
    { -839, 298, -24},
    { -794, 319, -9},
    { -705, 326, 24},
    { -824, 338, 115},
    { -1194, 487, 26},
    { -1251, 629, -62},
    { -803, 381, 93},
    { -832, 167, 206},
    { -672, 224, 84},
    { -824, 401, 24},
    { -897, 449, 136},
    { -943, 379, 152},
    { -920, 355, 150},
    { -912, 346, 155},
    { -953, 311, 180},
    { -958, 315, 160},
    { -881, 333, 114},
    { -817, 351, 62},
    { -815, 370, 19},
    { -858, 377, 20},
    { -885, 380, -12},
    { -881, 403, -40},
    { -874, 402, -29},
    { -992, 402, 36},
    { -1058, 436, 52},
    { -947, 435, 16},
    { -796, 420, -75},
    { -788, 433, -32},
    { -741, 360, 7},
    { -882, 338, 40},
    { -930, 371, 51},
    { -903, 407, 41},
    { -870, 409, 4},
    { -807, 373, -28},
    { -797, 333, -32},
    { -770, 309, -24},
    { -786, 332, -50},
    { -781, 337, -42},
    { -784, 355, -49},
    { -828, 352, -52},
    { -872, 435, -45},
    { -925, 369, 47},
    { -1286, 467, 62},
    { -1182, 465, 81},
    { -1161, 457, 69},
    { -941, 418, 52},
    { -711, 354, 29},
    { -667, 317, 55},
    { -752, 367, 98},
    { -884, 438, 132},
    { -903, 530, 224},
    { -919, 958, 215},
    { -941, 861, 220},
    { -992, 916, 140},
    { -1025, 1016, -80},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



// ----------------------------------------------------------------
// Sample captured: 2015-08-07 03:30:40 GMT
AccelRawData *activity_sample_washing_up(int *len) {
  //> TEST_NAME washing_up
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 50
  //> TEST_WEIGHT 10.0
  static AccelRawData samples[] = {
    { 100, -90, -1004},
    { 102, -98, -995},
    { 102, -78, -1014},
    { 99, -71, -1004},
    { 93, -84, -1014},
    { 101, -82, -1005},
    { 105, -69, -1011},
    { 104, -75, -1013},
    { 91, -64, -1007},
    { 125, -80, -997},
    { 120, -58, -989},
    { 105, -64, -990},
    { 90, -75, -997},
    { 96, -81, -998},
    { 108, -98, -986},
    { 78, -79, -990},
    { 108, -101, -1001},
    { 86, -87, -1003},
    { 101, -111, -990},
    { 98, -101, -1009},
    { 55, -112, -991},
    { 4, -120, -989},
    { -44, -124, -990},
    { -65, -157, -986},
    { -89, -182, -957},
    { 82, -151, -1008},
    { 95, -120, -1013},
    { 59, -85, -1002},
    { 98, -112, -990},
    { 139, -86, -1008},
    { 100, -68, -996},
    { 94, -52, -992},
    { 134, -81, -1004},
    { 85, -101, -942},
    { 175, -147, -862},
    { -77, -95, -743},
    { -48, 62, -750},
    { -113, 165, -645},
    { -73, 388, -632},
    { -125, 591, -682},
    { -246, 685, -541},
    { -292, 770, -515},
    { -388, 802, -451},
    { -492, 899, -387},
    { -560, 833, -317},
    { -607, 851, -262},
    { -745, 814, -219},
    { -841, 668, -157},
    { -1025, 720, -134},
    { -952, 876, -198},
    { -974, 737, -159},
    { -929, 563, -117},
    { -954, 570, -107},
    { -823, 425, -115},
    { -820, 411, -110},
    { -842, 389, -104},
    { -814, 420, -154},
    { -810, 479, -229},
    { -825, 533, -288},
    { -767, 558, -336},
    { -741, 602, -402},
    { -726, 659, -424},
    { -788, 743, -462},
    { -717, 879, -535},
    { -613, 975, -631},
    { -475, 1032, -625},
    { -407, 1011, -591},
    { -349, 953, -570},
    { -269, 929, -458},
    { -159, 862, -420},
    { -51, 820, -366},
    { -8, 755, -284},
    { 102, 691, -214},
    { 179, 729, -140},
    { 155, 825, -89},
    { 169, 818, -27},
    { 207, 842, 81},
    { 173, 886, 147},
    { 216, 860, 191},
    { 259, 866, 269},
    { 257, 819, 255},
    { 334, 787, 342},
    { 377, 770, 347},
    { 430, 886, 437},
    { 466, 694, 416},
    { 522, 681, 501},
    { 547, 832, 657},
    { 488, 796, 635},
    { 469, 591, 572},
    { 520, 634, 455},
    { 478, 642, 502},
    { 372, 627, 701},
    { 358, 630, 674},
    { 291, 678, 765},
    { 257, 644, 705},
    { 254, 436, 742},
    { 150, 812, 717},
    { 39, 739, 662},
    { 140, 701, 636},
    { 237, 711, 632},
    { 253, 834, 611},
    { 286, 839, 592},
    { 323, 829, 538},
    { 361, 855, 600},
    { 349, 836, 581},
    { 340, 845, 491},
    { 400, 798, 474},
    { 378, 784, 461},
    { 416, 750, 496},
    { 435, 731, 472},
    { 448, 667, 458},
    { 449, 684, 581},
    { 472, 687, 535},
    { 500, 613, 523},
    { 524, 643, 591},
    { 520, 620, 615},
    { 538, 585, 649},
    { 540, 657, 663},
    { 552, 621, 731},
    { 523, 564, 764},
    { 531, 541, 793},
    { 499, 549, 747},
    { 420, 545, 760},
    { 430, 499, 755},
    { 439, 541, 739},
    { 450, 598, 726},
    { 449, 549, 725},
    { 484, 503, 651},
    { 478, 474, 681},
    { 441, 509, 658},
    { 356, 516, 607},
    { 304, 388, 639},
    { 291, 541, 611},
    { 298, 716, 587},
    { 267, 838, 578},
    { 223, 876, 373},
    { 234, 1036, 296},
    { 237, 1111, 308},
    { 171, 1241, 236},
    { 67, 1266, 195},
    { -25, 1204, 105},
    { -137, 1154, 12},
    { -181, 1068, -60},
    { -205, 990, -99},
    { -189, 879, -120},
    { -134, 797, -103},
    { -53, 808, -128},
    { -2, 916, -144},
    { 34, 1024, -143},
    { 50, 1078, -143},
    { 67, 1030, -133},
    { 62, 1031, -114},
    { 40, 1018, -134},
    { 25, 996, -155},
    { -6, 994, -185},
    { -49, 982, -209},
    { -27, 900, -170},
    { 25, 912, -162},
    { 36, 967, -156},
    { 50, 1016, -82},
    { 75, 1067, 38},
    { 55, 1081, 29},
    { 86, 1126, 186},
    { 102, 1027, 198},
    { 108, 1063, 214},
    { 67, 977, 315},
    { 71, 975, 281},
    { 20, 952, 270},
    { 84, 837, 280},
    { 45, 862, 280},
    { 65, 907, 176},
    { 141, 945, 376},
    { 151, 789, 472},
    { 160, 747, 459},
    { 153, 865, 544},
    { 76, 953, 579},
    { -45, 1002, 638},
    { -52, 1018, 539},
    { -25, 996, 576},
    { -28, 974, 524},
    { -3, 1101, 471},
    { -13, 980, 354},
    { 37, 1013, -119},
    { 74, 953, -108},
    { 120, 463, -121},
    { 21, 859, -382},
    { 114, 725, -356},
    { 125, 932, -255},
    { 10, 963, -266},
    { 37, 892, -154},
    { 4, 1161, -163},
    { 4, 916, -203},
    { -26, 840, -244},
    { -45, 1240, -326},
    { 177, 1084, -263},
    { 225, 801, -244},
    { 141, 953, -230},
    { 209, 1039, -200},
    { 263, 822, -129},
    { 215, 856, -277},
    { 145, 679, -481},
    { 138, 712, -539},
    { 216, 790, -566},
    { 268, 721, -568},
    { 168, 650, -612},
    { 33, 462, -578},
    { 19, 922, -954},
    { -1, 659, -922},
    { -54, 544, -954},
    { -116, 561, -996},
    { -128, 684, -1133},
    { -251, 520, -1180},
    { -73, 703, -1200},
    { 233, 784, -1031},
    { 256, 487, -786},
    { 190, 278, -628},
    { 201, 286, -522},
    { 142, -60, -655},
    { 158, 111, -819},
    { 164, 233, -1000},
    { 142, 126, -985},
    { 213, 233, -1029},
    { 228, 181, -944},
    { 237, 165, -920},
    { 224, 129, -923},
    { 237, 184, -967},
    { 227, 122, -964},
    { 237, 185, -1009},
    { 257, 160, -962},
    { 247, 130, -950},
    { 256, 214, -951},
    { 249, 139, -920},
    { 258, 164, -935},
    { 263, 256, -963},
    { 255, 320, -937},
    { 213, 228, -842},
    { 201, 323, -756},
    { 225, 539, -906},
    { 324, 745, -714},
    { 522, 1227, -451},
    { 661, 1659, -329},
    { 920, 1651, 34},
    { 989, 1468, 220},
    { 878, 1019, 211},
    { 679, 626, 146},
    { 504, 259, 128},
    { 255, 89, 26},
    { 64, 184, -53},
    { -20, 123, -176},
    { 50, 435, -247},
    { 444, 870, -462},
    { 1332, 1123, -526},
    { 1886, 540, -279},
    { 1472, 127, -55},
    { 940, 250, -62},
    { 479, 199, -109},
    { 143, 208, -212},
    { 104, 522, -175},
    { 403, 924, -149},
    { 964, 1137, -370},
    { 1704, 822, -168},
    { 1853, 247, 65},
    { 1444, -207, -22},
    { 1090, 194, -19},
    { 595, 66, -20},
    { -115, 199, -454},
    { 106, 487, 50},
    { 373, 779, -64},
    { 849, 1159, -317},
    { 1315, 1092, -286},
    { 1777, 530, 30},
    { 1739, 359, -1},
    { 1215, 140, 17},
    { 688, -119, -8},
    { 216, 169, -14},
    { -41, 496, -177},
    { 149, 1075, -112},
    { 419, 950, -237},
    { 1026, 1225, -226},
    { 1649, 1216, -65},
    { 1947, 148, -3},
    { 1584, 306, 185},
    { 1154, -162, 34},
    { 802, -272, -300},
    { 626, 315, -377},
    { 43, -595, -669},
    { 167, -106, -237},
    { 234, -427, -323},
    { 555, -314, -207},
    { 697, -261, -388},
    { 1153, -480, -951},
    { 1715, -377, -1114},
    { 1582, 190, -1156},
    { 1272, 94, -782},
    { 751, -175, -640},
    { 491, -58, -738},
    { 845, -427, -394},
    { 768, -42, -369},
    { 554, -206, -333},
    { 770, -169, -640},
    { 960, 39, -504},
    { 899, 406, -244},
    { 674, 213, -385},
    { 980, 57, -473},
    { 887, 97, -311},
    { 808, 27, 194},
    { 790, 805, -102},
    { 787, 495, 171},
    { 639, 880, 130},
    { 579, 1041, 55},
    { 670, 1069, 68},
    { 745, 971, 157},
    { 977, 453, 155},
    { 1176, 810, -9},
    { 1101, 464, -229},
    { 1483, 387, -202},
    { 1146, 41, -546},
    { 954, -143, -709},
    { 832, -336, -847},
    { 919, -232, -470},
    { 847, -135, -509},
    { 521, -170, -515},
    { 816, -354, -384},
    { 773, 274, -331},
    { 911, -108, -300},
    { 854, 212, -497},
    { 1057, 42, -381},
    { 844, 162, -334},
    { 923, 553, -68},
    { 556, 1341, -307},
    { 662, 1119, -147},
    { 893, 496, -91},
    { 1023, -106, -163},
    { 658, 380, -661},
    { 690, 65, -259},
    { 712, -594, -194},
    { 690, -247, -481},
    { 598, -379, -551},
    { 690, -196, -309},
    { 795, -387, -446},
    { 730, -344, -511},
    { 719, -491, -849},
    { 610, -350, -1137},
    { 922, -411, -1651},
    { 1629, -509, -805},
    { 2026, -119, -435},
    { 1259, 253, -320},
    { 814, 17, -218},
    { 713, -529, -192},
    { 560, -79, -367},
    { 406, -465, -379},
    { 1059, 726, -203},
    { 438, 347, -1208},
    { 426, -165, -565},
    { 849, -216, -490},
    { 579, -407, -487},
    { 463, -366, -506},
    { 615, -289, -372},
    { 723, -226, -541},
    { 1003, -296, -678},
    { 1183, -205, -1179},
    { 1196, 70, -796},
    { 1027, 165, -522},
    { 844, 73, -518},
    { 953, 219, -423},
    { 866, 53, -448},
    { 849, 277, -234},
    { 721, 158, -189},
    { 898, 319, -85},
    { 983, 283, 62},
    { 909, 606, 86},
    { 772, 668, 23},
    { 836, 677, 27},
    { 784, 488, 4},
    { 772, 587, 142},
    { 754, 593, 86},
    { 718, 879, 47},
    { 756, 864, 95},
    { 899, 608, 214},
    { 1001, 239, 288},
    { 1037, 422, -110},
    { 1106, 473, 66},
    { 1067, 564, 115},
    { 822, 415, -123},
    { 913, 794, 101},
    { 670, 676, -448},
    { 709, 601, -3},
    { 777, 584, -55},
    { 758, 589, -183},
    { 723, 616, -236},
    { 639, 690, -281},
    { 614, 703, -377},
    { 554, 748, -340},
    { 367, 592, -447},
    { 392, 1079, -1046},
    { 764, 591, -673},
    { 1368, 123, -714},
    { 1698, 156, -563},
    { 957, 242, -595},
    { 698, -172, -389},
    { 426, -389, -219},
    { 126, -809, 66},
    { 271, -557, -564},
    { 739, -381, -642},
    { 1000, -332, -79},
    { 885, -349, -13},
    { 947, -418, -84},
    { 1195, -337, -329},
    { 1399, -185, -547},
    { 1510, 359, -658},
    { 1200, 554, -47},
    { 1036, 718, -19},
    { 552, 298, 10},
    { 372, 244, -162},
    { 347, 403, -356},
    { 752, 488, -249},
    { 881, 560, -226},
    { 921, 618, -137},
    { 892, 793, -123},
    { 848, 721, -145},
    { 818, 606, -62},
    { 725, 644, -50},
    { 729, 593, -85},
    { 758, 713, -195},
    { 918, 824, -110},
    { 1137, 1082, -8},
    { 1092, 855, -236},
    { 997, 893, -350},
    { 767, 715, -16},
    { 678, 606, 61},
    { 634, 807, -84},
    { 527, -73, -273},
    { 664, 254, -457},
    { 953, 594, -342},
    { 956, 139, -326},
    { 889, 38, -369},
    { 763, 15, -410},
    { 828, -4, -501},
    { 894, 115, -532},
    { 892, -98, -555},
    { 928, -5, -546},
    { 902, -238, -516},
    { 832, -383, -550},
    { 901, -305, -420},
    { 770, -332, -533},
    { 857, -267, -464},
    { 730, -384, -494},
    { 772, -602, -427},
    { 767, -332, -451},
    { 775, -323, -394},
    { 756, -427, -483},
    { 823, -376, -538},
    { 866, -331, -570},
    { 785, -321, -661},
    { 723, -438, -721},
    { 675, -532, -750},
    { 895, -134, -602},
    { 843, -160, -619},
    { 783, -132, -592},
    { 690, -11, -644},
    { 628, -37, -706},
    { 711, -72, -889},
    { 1052, -29, -670},
    { 1436, 248, -677},
    { 1698, -260, -411},
    { 1392, -398, -481},
    { 1097, 142, -253},
    { 1011, -22, 124},
    { 526, 203, -49},
    { 389, 321, -168},
    { 98, 252, -1197},
    { 895, 328, -234},
    { 810, 9, -775},
    { 859, 151, -670},
    { 790, 194, -650},
    { 911, 224, -572},
    { 834, 108, -573},
    { 851, 64, -610},
    { 829, 32, -577},
    { 803, -10, -657},
    { 817, -35, -646},
    { 802, -103, -666},
    { 809, -213, -612},
    { 796, -228, -646},
    { 777, -333, -613},
    { 697, -349, -590},
    { 698, -365, -598},
    { 608, -380, -580},
    { 554, -329, -481},
    { 423, -529, -657},
    { 762, -356, -1060},
    { 1103, -327, -1038},
    { 1387, -242, -719},
    { 1282, -721, -213},
    { 1163, -288, -91},
    { 1072, -333, 31},
    { 590, -116, -225},
    { 585, -527, -494},
    { 658, -376, -168},
    { 628, -278, -413},
    { 635, -571, -424},
    { 558, -504, -529},
    { 822, -717, -600},
    { 987, -534, -546},
    { 1018, -389, -399},
    { 851, -124, -324},
    { 713, 531, -478},
    { 706, -115, -449},
    { 789, -16, -735},
    { 897, 195, -510},
    { 864, 166, -510},
    { 792, 10, -692},
    { 896, 92, -535},
    { 923, 277, -584},
    { 1026, 312, -696},
    { 930, 415, -612},
    { 870, 265, -477},
    { 922, 407, -492},
    { 966, 268, -413},
    { 768, 222, -329},
    { 901, 215, -200},
    { 845, 538, 16},
    { 831, 358, 2},
    { 903, 597, 83},
    { 841, 734, -104},
    { 859, 529, 65},
    { 849, 497, -3},
    { 881, 532, 68},
    { 777, 628, -260},
    { 777, 613, -135},
    { 716, 856, -339},
    { 736, 1111, -683},
    { 1066, 632, -761},
    { 1444, 36, -437},
    { 1228, 412, -538},
    { 800, -109, -414},
    { 568, -375, -273},
    { 338, -681, -136},
    { 147, -748, -148},
    { 433, -652, -564},
    { 815, -451, -447},
    { 899, -332, -74},
    { 875, -329, -39},
    { 1002, -427, -101},
    { 1208, -576, -288},
    { 1366, -463, -507},
    { 1298, 263, -462},
    { 1156, 448, -264},
    { 859, 499, 270},
    { 711, 730, -11},
    { 572, 300, -66},
    { 507, 180, -196},
    { 607, 915, -480},
    { 877, 541, -70},
    { 966, 570, -164},
    { 900, 601, -67},
    { 786, 603, -41},
    { 880, 532, 25},
    { 964, 505, 53},
    { 931, 577, -19},
    { 930, 544, 29},
    { 894, 568, -79},
    { 887, 658, -62},
    { 856, 646, -39},
    { 813, 567, -52},
    { 816, 591, -149},
    { 786, 609, -200},
    { 735, 593, -156},
    { 692, 737, -188},
    { 677, 551, -451},
    { 630, 692, -323},
    { 724, 447, -313},
    { 734, 758, -524},
    { 617, 667, -466},
    { 691, 526, -433},
    { 654, 678, -427},
    { 629, 528, -473},
    { 583, 495, -563},
    { 639, 529, -475},
    { 649, 625, -619},
    { 534, 545, -516},
    { 538, 545, -541},
    { 479, 414, -494},
    { 332, 299, -438},
    { 126, 425, -659},
    { 337, 402, -530},
    { 371, 584, -343},
    { 648, 907, -482},
    { 717, 1194, -936},
    { 436, 1117, -902},
    { 453, 310, -1004},
    { 279, 351, -962},
    { 144, 334, -1121},
    { 32, 104, -1147},
    { -112, 256, -1014},
    { -45, 239, -1151},
    { -19, 188, -1049},
    { -19, 184, -937},
    { -32, 212, -972},
    { -76, 377, -1112},
    { -75, 389, -981},
    { -103, 360, -955},
    { -138, 346, -922},
    { -253, 372, -849},
    { -172, 547, -926},
    { 43, 727, -580},
    { 262, 1062, -260},
    { 237, 1159, -326},
    { 115, 816, -564},
    { 143, 645, -388},
    { 142, 745, -472},
    { 110, 963, -390},
    { 102, 952, -580},
    { 185, 1103, -484},
    { 195, 945, -430},
    { 305, 799, -472},
    { 284, 889, -482},
    { 245, 463, -445},
    { 228, 703, -531},
    { 204, 673, -594},
    { 200, 754, -600},
    { 181, 764, -557},
    { 146, 763, -460},
    { 153, 895, -402},
    { 165, 1028, -407},
    { 219, 1206, -240},
    { 256, 932, -109},
    { 201, 1121, -192},
    { 214, 755, -44},
    { 296, 1075, -272},
    { 219, 726, -536},
    { 228, 785, -506},
    { 278, 652, -603},
    { 282, 785, -788},
    { 166, 428, -716},
    { 235, 338, -681},
    { 239, 396, -758},
    { 197, 511, -590},
    { 216, 628, -640},
    { 193, 1014, -580},
    { 245, 801, -341},
    { 192, 1154, -288},
    { 195, 978, -130},
    { 194, 1069, 278},
    { 131, 963, 283},
    { 154, 917, 214},
    { 120, 958, 393},
    { 124, 869, 431},
    { 100, 927, 419},
    { 94, 794, 473},
    { 86, 959, 618},
    { 80, 807, 440},
    { 90, 1007, 542},
    { 139, 938, 535},
    { 231, 664, 535},
    { 230, 959, 241},
    { 163, 879, 107},
    { 74, 1001, 80},
    { 118, 1342, -160},
    { 97, 1546, -165},
    { 131, 1203, -50},
    { 135, 1237, 1},
    { 117, 987, 67},
    { 229, 442, 85},
    { 322, 677, 178},
    { 131, 1002, 38},
    { 151, 910, -75},
    { 138, 1166, -183},
    { 90, 911, -472},
    { -34, 766, -688},
    { -106, 547, -842},
    { -223, 357, -824},
    { -375, 487, -915},
    { -406, 475, -921},
    { -411, 500, -893},
    { -343, 474, -875},
    { -294, 331, -824},
    { -348, 346, -816},
    { -325, 385, -849},
    { -318, 352, -817},
    { -350, 358, -800},
    { -356, 386, -813},
    { -366, 484, -904},
    { -407, 425, -812},
    { -444, 489, -906},
    { -571, 543, -875},
    { -576, 432, -851},
    { -562, 421, -697},
    { -462, 575, -711},
    { -365, 499, -593},
    { -200, 654, -582},
    { 54, 679, -504},
    { 271, 738, -516},
    { 318, 696, -662},
    { 402, 851, -643},
    { 348, 919, -661},
    { 358, 1009, -602},
    { 329, 1062, -576},
    { 282, 988, -582},
    { 376, 1101, -499},
    { 393, 906, -438},
    { 389, 686, -255},
    { 352, 678, 26},
    { 265, 775, 147},
    { 147, 1003, 364},
    { 158, 886, 477},
    { 28, 543, 656},
    { -112, 1057, 864},
    { 223, 435, 872},
    { 228, 483, 780},
    { 355, 510, 929},
    { 517, 780, 905},
    { 211, 176, 335},
    { 373, 640, 776},
    { 258, 450, 768},
    { 269, 598, 577},
    { 168, 945, 1077},
    { 209, 497, 462},
    { 686, 1082, 831},
    { 553, 863, 805},
    { 409, 452, 887},
    { 467, 658, 80},
    { 329, 885, 294},
    { 306, 574, -16},
    { 433, 853, 115},
    { 444, 840, -132},
    { 435, 894, 71},
    { 509, 631, -44},
    { 480, 584, -68},
    { 465, 887, -14},
    { 458, 885, 72},
    { 468, 926, 26},
    { 817, 1294, 333},
    { 691, 467, -53},
    { 490, 971, 364},
    { 392, 1088, 336},
    { 625, 242, 247},
    { 554, 874, -34},
    { 660, 960, 174},
    { 680, 603, 99},
    { 536, 1178, 243},
    { 567, 1088, 143},
    { 444, 678, 473},
    { 661, 1114, 136},
    { 580, 1028, -39},
    { 653, 806, 514},
    { 509, 705, 285},
    { 328, 975, -18},
    { 451, 775, -64},
    { 562, 803, 131},
    { 508, 758, 5},
    { 570, 679, -68},
    { 441, 799, -14},
    { 457, 864, 162},
    { 626, 1029, 295},
    { 570, 993, 116},
    { 478, 908, 124},
    { 457, 803, 103},
    { 340, 1022, 208},
    { 395, 864, 291},
    { 437, 825, 188},
    { 349, 910, 292},
    { 287, 914, 420},
    { 554, 1044, 293},
    { 333, 968, 266},
    { 412, 1113, 440},
    { 436, 794, 425},
    { 339, 579, 423},
    { 277, 891, 292},
    { 274, 909, 193},
    { 463, 1103, 365},
    { 463, 1157, 280},
    { 516, 612, 421},
    { 318, 1216, 289},
    { 525, 910, 172},
    { 373, 1021, 28},
    { 486, 789, -11},
    { 364, 727, -280},
    { 412, 837, -223},
    { 383, 857, -363},
    { 406, 810, -499},
    { 325, 477, -614},
    { 277, 521, -922},
    { 364, 747, -953},
    { 510, 682, -670},
    { 319, -282, -594},
    { 242, -248, -983},
    { 198, -146, -1039},
    { 294, -114, -872},
    { 200, -368, -770},
    { 269, 25, -1066},
    { 227, -139, -1036},
    { 138, -194, -1000},
    { 51, -199, -1051},
    { 56, -176, -1108},
    { 33, -229, -1038},
    { 0, -189, -1020},
    { -2, -203, -972},
    { -6, -179, -983},
    { -11, -218, -944},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-08-07 14:13:55 GMT
AccelRawData *activity_sample_walk_slow_50(int *len) {
  //> TEST_NAME walk_50_slow
  //> TEST_EXPECTED 50
  //> TEST_EXPECTED_MIN 38
  //> TEST_EXPECTED_MAX 55
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    { 68, 240, -866},
    { 91, 256, -889},
    { 131, 244, -908},
    { 146, 253, -928},
    { 175, 229, -956},
    { 163, 167, -955},
    { 159, 146, -990},
    { 166, 108, -1031},
    { 161, 200, -1034},
    { 167, 136, -1146},
    { 123, 155, -1216},
    { -10, 436, -1093},
    { 42, 306, -944},
    { -12, 243, -843},
    { -35, 247, -799},
    { -13, 287, -801},
    { -67, 524, -899},
    { -46, 632, -944},
    { 14, 494, -935},
    { 48, 294, -878},
    { 7, 249, -850},
    { -22, 317, -827},
    { -61, 382, -958},
    { 7, 294, -961},
    { 55, 260, -915},
    { 8, 228, -976},
    { 40, 313, -968},
    { -54, 273, -1035},
    { -80, 237, -1084},
    { -67, 248, -1235},
    { 65, 409, -1152},
    { 0, 249, -997},
    { -12, 176, -953},
    { 72, 225, -862},
    { 154, 91, -787},
    { 337, 166, -873},
    { -76, 302, -1062},
    { -107, 261, -973},
    { -103, 147, -940},
    { 0, 63, -948},
    { 12, 50, -911},
    { 20, 60, -904},
    { 9, 38, -892},
    { 6, 59, -904},
    { 47, 0, -870},
    { 25, 8, -828},
    { -108, -75, -668},
    { -285, 42, -476},
    { -438, 549, -448},
    { -605, 623, -422},
    { -797, 698, -452},
    { -1005, 768, -284},
    { -1026, 566, -203},
    { -1187, 751, -151},
    { -1129, 739, -212},
    { -946, 634, -227},
    { -1030, 1138, -318},
    { -818, 658, -269},
    { -868, 699, -322},
    { -829, 606, -178},
    { -791, 380, -111},
    { -699, 267, -132},
    { -674, 254, -198},
    { -673, 281, -188},
    { -801, 298, -95},
    { -1182, 336, -8},
    { -1229, 340, 101},
    { -1018, 312, 83},
    { -912, 295, -1},
    { -929, 354, -10},
    { -940, 339, 109},
    { -922, 315, 90},
    { -829, 276, 72},
    { -735, 268, 94},
    { -778, 301, 73},
    { -780, 321, 56},
    { -817, 344, 45},
    { -867, 365, 33},
    { -925, 371, 38},
    { -965, 353, 58},
    { -989, 310, 100},
    { -1014, 320, 69},
    { -974, 376, 40},
    { -1151, 452, 53},
    { -1032, 447, 6},
    { -885, 457, -109},
    { -818, 462, -169},
    { -770, 351, -68},
    { -834, 336, -58},
    { -964, 273, 24},
    { -973, 290, 41},
    { -854, 311, 25},
    { -799, 346, -18},
    { -817, 361, -73},
    { -793, 200, -104},
    { -818, 149, -87},
    { -813, 209, -116},
    { -806, 378, -144},
    { -849, 366, -35},
    { -919, 406, -31},
    { -1044, 384, 22},
    { -1133, 405, 28},
    { -949, 395, 46},
    { -932, 373, 9},
    { -821, 389, -33},
    { -774, 396, -36},
    { -932, 396, -8},
    { -976, 389, 15},
    { -955, 359, 48},
    { -828, 298, 40},
    { -768, 305, 40},
    { -783, 306, 53},
    { -844, 299, 93},
    { -820, 304, 96},
    { -821, 296, 107},
    { -892, 322, 131},
    { -927, 336, 147},
    { -919, 353, 91},
    { -891, 359, 49},
    { -1123, 384, 83},
    { -1018, 336, 35},
    { -910, 338, -41},
    { -860, 409, -145},
    { -755, 447, -173},
    { -827, 349, -95},
    { -962, 281, -76},
    { -964, 379, -55},
    { -812, 405, -72},
    { -736, 358, -88},
    { -727, 303, -73},
    { -732, 290, -57},
    { -765, 289, -49},
    { -807, 333, -53},
    { -847, 380, -54},
    { -923, 400, 0},
    { -1046, 342, 105},
    { -1238, 396, 119},
    { -968, 355, 129},
    { -897, 330, 99},
    { -792, 316, 73},
    { -842, 254, 130},
    { -991, 183, 190},
    { -1010, 244, 232},
    { -934, 247, 148},
    { -830, 189, 63},
    { -798, 84, 78},
    { -827, 278, 135},
    { -842, 437, 176},
    { -821, 464, 171},
    { -800, 440, 186},
    { -831, 462, 187},
    { -896, 498, 167},
    { -887, 473, 129},
    { -1196, 443, 205},
    { -1064, 413, 111},
    { -1071, 448, 6},
    { -861, 400, -47},
    { -756, 331, -87},
    { -857, 284, -80},
    { -951, 281, -67},
    { -933, 294, -83},
    { -852, 188, -97},
    { -744, 131, -71},
    { -752, 219, -81},
    { -684, 246, -110},
    { -684, 228, -92},
    { -724, 275, -107},
    { -849, 329, -118},
    { -951, 315, -60},
    { -1064, 519, -56},
    { -1229, 522, 0},
    { -1174, 561, -11},
    { -975, 439, -26},
    { -992, 370, -30},
    { -901, 386, -31},
    { -787, 394, -48},
    { -859, 384, -56},
    { -943, 390, -32},
    { -986, 327, 49},
    { -886, 291, 56},
    { -832, 296, 44},
    { -817, 294, 64},
    { -803, 276, 79},
    { -755, 242, 74},
    { -785, 239, 91},
    { -882, 261, 121},
    { -898, 271, 100},
    { -820, 302, 8},
    { -1207, 351, 46},
    { -1099, 309, 60},
    { -1102, 352, -24},
    { -930, 380, -137},
    { -764, 425, -201},
    { -752, 379, -152},
    { -873, 336, -118},
    { -828, 272, -85},
    { -809, 299, -85},
    { -816, 317, -115},
    { -800, 360, -135},
    { -765, 339, -141},
    { -744, 305, -147},
    { -798, 332, -138},
    { -898, 343, -136},
    { -985, 370, -106},
    { -965, 369, -67},
    { -1164, 416, -65},
    { -1120, 427, -62},
    { -911, 352, -27},
    { -941, 343, -34},
    { -818, 363, -70},
    { -837, 389, -67},
    { -922, 376, -48},
    { -940, 361, -11},
    { -895, 334, 4},
    { -816, 282, 28},
    { -762, 251, 42},
    { -756, 270, 39},
    { -762, 298, 34},
    { -766, 298, 53},
    { -837, 297, 91},
    { -923, 313, 77},
    { -916, 342, 38},
    { -1109, 390, 23},
    { -1130, 388, 35},
    { -981, 396, -35},
    { -877, 416, -142},
    { -737, 421, -169},
    { -790, 367, -119},
    { -865, 301, -73},
    { -890, 308, -51},
    { -828, 324, -48},
    { -794, 329, -70},
    { -796, 328, -69},
    { -804, 279, -79},
    { -797, 294, -104},
    { -783, 332, -124},
    { -818, 393, -130},
    { -905, 384, -84},
    { -995, 386, -2},
    { -1359, 447, 38},
    { -1144, 481, 44},
    { -993, 406, 7},
    { -868, 381, -5},
    { -757, 389, 1},
    { -776, 365, 32},
    { -878, 364, 57},
    { -934, 355, 141},
    { -910, 345, 164},
    { -804, 300, 155},
    { -778, 307, 159},
    { -789, 308, 172},
    { -814, 341, 161},
    { -842, 319, 191},
    { -898, 315, 185},
    { -940, 297, 193},
    { -964, 320, 114},
    { -1162, 324, 142},
    { -964, 298, 43},
    { -835, 318, -111},
    { -788, 376, -214},
    { -819, 464, -263},
    { -905, 406, -213},
    { -975, 296, -161},
    { -898, 270, -122},
    { -822, 293, -74},
    { -811, 328, -89},
    { -811, 323, -36},
    { -822, 298, 3},
    { -796, 316, -31},
    { -794, 350, -60},
    { -819, 355, -62},
    { -908, 338, -51},
    { -908, 336, -32},
    { -1140, 391, 11},
    { -1118, 434, -31},
    { -916, 430, -36},
    { -953, 373, -2},
    { -786, 364, -29},
    { -775, 376, -22},
    { -970, 361, 13},
    { -967, 353, 66},
    { -907, 335, 61},
    { -871, 306, 64},
    { -927, 305, 87},
    { -886, 273, 92},
    { -843, 262, 83},
    { -804, 271, 64},
    { -761, 262, 52},
    { -794, 252, 64},
    { -863, 282, 71},
    { -889, 305, 46},
    { -977, 353, 35},
    { -1125, 388, 65},
    { -1061, 428, 29},
    { -935, 461, -70},
    { -767, 496, -128},
    { -796, 418, -75},
    { -882, 333, 18},
    { -940, 319, 32},
    { -864, 345, 14},
    { -789, 370, -4},
    { -786, 386, -64},
    { -802, 357, -70},
    { -808, 298, -119},
    { -811, 320, -179},
    { -851, 366, -201},
    { -928, 394, -129},
    { -942, 388, -72},
    { -1182, 368, 43},
    { -1076, 416, 8},
    { -975, 432, 63},
    { -943, 375, 36},
    { -807, 375, 34},
    { -855, 378, 51},
    { -890, 362, 54},
    { -925, 341, 89},
    { -840, 320, 77},
    { -815, 290, 83},
    { -800, 260, 100},
    { -795, 277, 95},
    { -781, 275, 95},
    { -772, 274, 94},
    { -810, 276, 111},
    { -902, 301, 118},
    { -920, 322, 65},
    { -1035, 358, 32},
    { -1197, 351, 65},
    { -1048, 362, -5},
    { -942, 371, -103},
    { -748, 413, -140},
    { -722, 369, -121},
    { -853, 335, -94},
    { -933, 325, -50},
    { -888, 339, -41},
    { -814, 338, -54},
    { -788, 336, -66},
    { -823, 291, -41},
    { -856, 300, -53},
    { -841, 326, -81},
    { -832, 349, -96},
    { -847, 340, -92},
    { -906, 351, -74},
    { -950, 336, -30},
    { -1089, 352, 12},
    { -1154, 429, 13},
    { -924, 426, 0},
    { -919, 393, 1},
    { -843, 366, -5},
    { -821, 356, 18},
    { -942, 350, 21},
    { -971, 370, 70},
    { -893, 328, 79},
    { -809, 299, 71},
    { -775, 291, 72},
    { -825, 274, 94},
    { -839, 263, 122},
    { -815, 277, 120},
    { -814, 294, 128},
    { -845, 301, 139},
    { -854, 322, 112},
    { -830, 342, 56},
    { -1146, 376, 89},
    { -1094, 343, 93},
    { -925, 364, -14},
    { -860, 436, -107},
    { -763, 484, -182},
    { -772, 387, -134},
    { -949, 346, -180},
    { -1033, 379, -100},
    { -928, 365, -88},
    { -828, 388, -97},
    { -807, 353, -72},
    { -815, 317, -33},
    { -851, 315, -7},
    { -848, 343, -12},
    { -835, 359, -8},
    { -842, 358, 4},
    { -895, 350, 33},
    { -905, 332, 81},
    { -971, 339, 109},
    { -1070, 377, 126},
    { -932, 390, 115},
    { -895, 398, 70},
    { -845, 394, 70},
    { -755, 338, 74},
    { -863, 326, 83},
    { -979, 353, 89},
    { -1005, 347, 122},
    { -896, 328, 99},
    { -860, 311, 80},
    { -849, 296, 82},
    { -852, 271, 114},
    { -824, 266, 119},
    { -864, 282, 147},
    { -904, 290, 177},
    { -894, 312, 156},
    { -935, 362, 138},
    { -1115, 348, 208},
    { -941, 344, 81},
    { -857, 402, -55},
    { -743, 379, -97},
    { -795, 321, -79},
    { -880, 284, -96},
    { -965, 353, -127},
    { -968, 410, -177},
    { -864, 337, -157},
    { -825, 411, -197},
    { -843, 362, -99},
    { -849, 372, -47},
    { -864, 346, -15},
    { -858, 348, -9},
    { -838, 359, 7},
    { -831, 363, 13},
    { -863, 369, 26},
    { -899, 373, 72},
    { -1189, 409, 113},
    { -996, 410, 106},
    { -979, 371, 102},
    { -904, 357, 105},
    { -734, 358, 64},
    { -722, 350, 68},
    { -898, 361, 83},
    { -960, 378, 125},
    { -931, 360, 157},
    { -837, 324, 157},
    { -832, 309, 168},
    { -911, 321, 189},
    { -923, 323, 225},
    { -919, 323, 232},
    { -914, 319, 242},
    { -877, 306, 218},
    { -895, 332, 162},
    { -972, 351, 166},
    { -1002, 301, 136},
    { -890, 287, 40},
    { -726, 288, -93},
    { -801, 330, -127},
    { -919, 392, -143},
    { -996, 373, -149},
    { -1041, 331, -158},
    { -909, 310, -152},
    { -817, 336, -128},
    { -788, 318, -126},
    { -844, 356, -101},
    { -858, 380, -29},
    { -854, 331, -2},
    { -822, 331, 0},
    { -822, 339, 10},
    { -854, 326, 20},
    { -906, 337, 44},
    { -922, 348, 53},
    { -1180, 394, 80},
    { -1015, 409, 39},
    { -922, 372, 18},
    { -903, 343, 11},
    { -807, 328, 9},
    { -730, 288, 23},
    { -895, 316, 37},
    { -1000, 367, 66},
    { -971, 343, 108},
    { -851, 320, 80},
    { -768, 330, 67},
    { -807, 312, 82},
    { -843, 288, 108},
    { -836, 299, 110},
    { -855, 317, 102},
    { -886, 320, 121},
    { -903, 315, 96},
    { -908, 311, 60},
    { -981, 332, 40},
    { -1131, 319, 80},
    { -963, 330, 4},
    { -967, 370, -42},
    { -858, 393, -93},
    { -759, 345, -128},
    { -818, 307, -89},
    { -943, 323, -78},
    { -911, 315, -83},
    { -833, 264, -86},
    { -810, 280, -109},
    { -795, 290, -108},
    { -784, 281, -93},
    { -789, 274, -104},
    { -799, 310, -110},
    { -832, 361, -113},
    { -895, 369, -95},
    { -903, 343, -69},
    { -1085, 321, 14},
    { -1156, 410, -25},
    { -982, 461, -42},
    { -949, 376, -45},
    { -862, 375, -69},
    { -796, 353, -70},
    { -889, 331, -27},
    { -973, 350, 6},
    { -982, 293, 88},
    { -898, 323, 63},
    { -825, 292, 76},
    { -806, 290, 92},
    { -789, 281, 103},
    { -761, 273, 94},
    { -791, 263, 96},
    { -871, 273, 111},
    { -941, 283, 109},
    { -936, 304, 61},
    { -1036, 341, 27},
    { -1134, 334, 68},
    { -1036, 348, 28},
    { -916, 398, -86},
    { -843, 454, -150},
    { -791, 385, -111},
    { -892, 333, -87},
    { -921, 302, -80},
    { -828, 360, -104},
    { -773, 344, -107},
    { -801, 315, -91},
    { -838, 302, -77},
    { -833, 322, -103},
    { -796, 341, -127},
    { -807, 336, -128},
    { -846, 330, -110},
    { -893, 319, -73},
    { -906, 331, -39},
    { -1140, 410, -20},
    { -1104, 447, -40},
    { -883, 379, -42},
    { -936, 344, -33},
    { -833, 334, -64},
    { -859, 338, -54},
    { -936, 306, -12},
    { -950, 312, 38},
    { -911, 303, 42},
    { -862, 298, 43},
    { -818, 281, 47},
    { -814, 274, 63},
    { -817, 267, 67},
    { -802, 250, 79},
    { -854, 256, 84},
    { -905, 288, 86},
    { -913, 307, 45},
    { -948, 338, 35},
    { -1209, 327, 79},
    { -1112, 323, 73},
    { -984, 366, -18},
    { -818, 405, -98},
    { -727, 368, -167},
    { -804, 335, -136},
    { -905, 313, -135},
    { -852, 288, -119},
    { -804, 269, -118},
    { -807, 291, -132},
    { -801, 268, -131},
    { -760, 259, -129},
    { -761, 291, -140},
    { -817, 345, -147},
    { -867, 320, -94},
    { -907, 304, -58},
    { -1000, 376, -34},
    { -1162, 454, -43},
    { -1072, 484, -38},
    { -970, 415, -13},
    { -842, 397, -62},
    { -782, 388, -53},
    { -875, 383, -8},
    { -946, 334, 42},
    { -975, 376, 100},
    { -930, 354, 121},
    { -863, 330, 137},
    { -768, 323, 94},
    { -777, 303, 74},
    { -790, 304, 38},
    { -801, 279, 23},
    { -860, 271, 26},
    { -938, 279, 26},
    { -956, 307, 10},
    { -927, 344, -6},
    { -1153, 360, 84},
    { -1028, 363, 98},
    { -907, 412, 7},
    { -914, 484, -20},
    { -821, 503, -28},
    { -844, 417, 9},
    { -849, 319, 58},
    { -846, 338, 53},
    { -770, 364, -14},
    { -721, 334, -17},
    { -743, 316, -71},
    { -797, 307, -88},
    { -809, 314, -120},
    { -860, 289, -175},
    { -898, 385, -198},
    { -984, 410, -146},
    { -992, 384, -36},
    { -1293, 393, 12},
    { -1095, 465, 16},
    { -974, 401, 3},
    { -886, 371, 7},
    { -781, 357, 31},
    { -838, 342, 65},
    { -901, 339, 106},
    { -902, 334, 144},
    { -830, 303, 159},
    { -808, 302, 147},
    { -812, 296, 139},
    { -800, 296, 150},
    { -813, 295, 153},
    { -868, 304, 157},
    { -930, 299, 167},
    { -957, 300, 138},
    { -940, 305, 80},
    { -1144, 322, 114},
    { -962, 298, -28},
    { -727, 317, -179},
    { -805, 364, -193},
    { -918, 401, -213},
    { -947, 331, -155},
    { -961, 266, -120},
    { -879, 311, -97},
    { -820, 311, -82},
    { -774, 286, -69},
    { -766, 273, -41},
    { -747, 282, -58},
    { -759, 300, -56},
    { -771, 316, -85},
    { -854, 350, -83},
    { -936, 366, 5},
    { -1371, 427, 52},
    { -1104, 419, 87},
    { -1027, 393, 35},
    { -864, 384, 35},
    { -749, 397, 48},
    { -808, 332, 114},
    { -911, 345, 173},
    { -918, 344, 181},
    { -854, 317, 190},
    { -796, 288, 169},
    { -763, 322, 137},
    { -803, 349, 133},
    { -824, 342, 128},
    { -849, 361, 115},
    { -860, 366, 100},
    { -920, 350, 89},
    { -928, 338, 58},
    { -1024, 347, 65},
    { -1209, 335, 128},
    { -1053, 324, 95},
    { -907, 364, -9},
    { -737, 377, -43},
    { -687, 329, -73},
    { -769, 283, -26},
    { -923, 282, -1},
    { -906, 325, -16},
    { -823, 327, -56},
    { -783, 320, -96},
    { -807, 300, -88},
    { -799, 275, -90},
    { -802, 298, -103},
    { -808, 325, -115},
    { -825, 336, -106},
    { -855, 351, -94},
    { -921, 360, -76},
    { -913, 366, -35},
    { -1106, 426, 8},
    { -1045, 466, -13},
    { -911, 457, -1},
    { -932, 422, 12},
    { -777, 396, -19},
    { -852, 407, -5},
    { -954, 417, 11},
    { -1012, 375, 94},
    { -949, 319, 94},
    { -826, 297, 80},
    { -786, 284, 79},
    { -788, 267, 85},
    { -809, 261, 112},
    { -822, 245, 146},
    { -894, 264, 159},
    { -914, 283, 187},
    { -903, 318, 122},
    { -1177, 379, 177},
    { -1036, 329, 113},
    { -899, 396, -50},
    { -844, 397, -137},
    { -832, 386, -163},
    { -831, 306, -166},
    { -944, 285, -164},
    { -916, 303, -170},
    { -849, 281, -158},
    { -817, 312, -173},
    { -799, 315, -130},
    { -776, 287, -99},
    { -774, 284, -94},
    { -774, 316, -101},
    { -831, 333, -79},
    { -911, 319, -38},
    { -924, 310, 20},
    { -1204, 407, 50},
    { -1146, 486, 8},
    { -949, 450, 5},
    { -948, 399, -2},
    { -809, 373, -25},
    { -766, 354, -17},
    { -885, 339, 10},
    { -921, 377, 52},
    { -963, 350, 77},
    { -871, 322, 87},
    { -808, 278, 93},
    { -781, 274, 90},
    { -761, 277, 95},
    { -747, 279, 80},
    { -790, 302, 101},
    { -902, 298, 125},
    { -979, 337, 93},
    { -975, 368, 31},
    { -1219, 368, 108},
    { -1098, 348, 61},
    { -874, 362, -40},
    { -780, 420, -114},
    { -730, 416, -129},
    { -808, 357, -92},
    { -919, 306, -38},
    { -902, 341, -26},
    { -804, 335, -26},
    { -777, 333, -51},
    { -799, 317, -49},
    { -819, 272, -31},
    { -832, 303, -88},
    { -822, 338, -126},
    { -836, 373, -149},
    { -913, 384, -111},
    { -1020, 359, -25},
    { -1297, 406, -2},
    { -1048, 443, 12},
    { -990, 380, 10},
    { -861, 369, 6},
    { -738, 370, 15},
    { -819, 335, 49},
    { -904, 354, 78},
    { -925, 323, 148},
    { -857, 315, 147},
    { -808, 300, 142},
    { -852, 299, 165},
    { -827, 290, 168},
    { -813, 291, 146},
    { -833, 282, 154},
    { -868, 278, 155},
    { -951, 291, 128},
    { -920, 305, 72},
    { -1111, 317, 98},
    { -1086, 312, 37},
    { -842, 332, -138},
    { -763, 375, -201},
    { -823, 399, -192},
    { -906, 325, -118},
    { -1004, 273, -71},
    { -930, 331, -87},
    { -773, 357, -76},
    { -763, 342, -72},
    { -807, 314, -31},
    { -829, 314, -8},
    { -837, 357, -46},
    { -829, 377, -75},
    { -853, 370, -69},
    { -902, 354, -49},
    { -928, 346, -26},
    { -935, 354, 3},
    { -1178, 404, 38},
    { -1050, 408, 39},
    { -930, 361, 30},
    { -936, 345, 38},
    { -810, 348, 23},
    { -823, 330, 45},
    { -912, 340, 62},
    { -946, 360, 104},
    { -857, 317, 103},
    { -802, 286, 110},
    { -802, 284, 102},
    { -815, 276, 116},
    { -853, 304, 126},
    { -833, 307, 123},
    { -840, 304, 127},
    { -879, 305, 131},
    { -931, 328, 92},
    { -910, 327, 61},
    { -1138, 356, 87},
    { -1080, 342, 41},
    { -839, 332, -61},
    { -749, 375, -155},
    { -726, 390, -155},
    { -849, 335, -96},
    { -940, 286, -33},
    { -954, 337, -25},
    { -830, 351, -43},
    { -774, 360, -68},
    { -788, 305, -15},
    { -833, 302, 2},
    { -868, 341, -6},
    { -862, 375, -37},
    { -853, 392, -52},
    { -864, 369, -52},
    { -907, 378, -28},
    { -929, 364, 14},
    { -1124, 420, 44},
    { -1070, 408, 52},
    { -944, 379, 69},
    { -954, 356, 74},
    { -888, 363, 99},
    { -786, 328, 111},
    { -761, 316, 121},
    { -846, 329, 147},
    { -936, 379, 168},
    { -859, 342, 166},
    { -800, 330, 140},
    { -805, 322, 127},
    { -820, 328, 123},
    { -814, 340, 108},
    { -854, 359, 98},
    { -909, 368, 113},
    { -960, 347, 130},
    { -957, 325, 106},
    { -951, 333, 80},
    { -1124, 338, 108},
    { -993, 324, 57},
    { -720, 338, -102},
    { -640, 373, -125},
    { -812, 415, -115},
    { -906, 364, -54},
    { -959, 305, 11},
    { -946, 324, 7},
    { -813, 344, 0},
    { -795, 341, -1},
    { -816, 332, 18},
    { -846, 310, 20},
    { -860, 345, -12},
    { -856, 375, -34},
    { -869, 382, -42},
    { -883, 383, -43},
    { -863, 380, -40},
    { -979, 398, 7},
    { -1027, 426, 2},
    { -1104, 415, 84},
    { -1074, 360, 116},
    { -866, 332, 157},
    { -776, 296, 166},
    { -775, 297, 201},
    { -810, 313, 234},
    { -844, 309, 310},
    { -873, 298, 359},
    { -859, 313, 329},
    { -844, 350, 296},
    { -859, 367, 295},
    { -905, 336, 294},
    { -896, 317, 270},
    { -900, 311, 236},
    { -888, 302, 223},
    { -920, 305, 199},
    { -938, 318, 179},
    { -1075, 322, 206},
    { -1066, 334, 165},
    { -877, 367, 23},
    { -885, 364, 17},
    { -928, 350, 35},
    { -982, 326, -2},
    { -1041, 297, 15},
    { -980, 365, -92},
    { -864, 346, -101},
    { -822, 317, -72},
    { -796, 278, -18},
    { -792, 264, 26},
    { -817, 285, 16},
    { -808, 353, 5},
    { -812, 472, 1},
    { -803, 597, -29},
    { -826, 750, -32},
    { -775, 820, -45},
    { -748, 910, -70},
    { -709, 904, -124},
    { -753, 942, -47},
    { -718, 973, -125},
    { -714, 961, -172},
    { -630, 635, -170},
    { -491, 568, -239},
    { -476, 652, -244},
    { -425, 599, -330},
    { -406, 610, -343},
    { -467, 746, -451},
    { -492, 619, -485},
    { -360, 527, -516},
    { -341, 558, -578},
    { -297, 583, -664},
    { -333, 533, -792},
    { -322, 481, -935},
    { -298, 515, -934},
    { -320, 501, -898},
    { -323, 393, -904},
    { -348, 216, -937},
    { -338, 336, -951},
    { -450, 37, -929},
    { -431, 195, -923},
    { -393, 288, -931},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-08-08 15:44:24 GMT
AccelRawData *activity_sample_50_steps_hand_in_pocket(int *len) {
  //> TEST_NAME walk_50_hands_in_pocket
  //> TEST_EXPECTED 50
  //> TEST_EXPECTED_MIN 44
  //> TEST_EXPECTED_MAX 55
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    { -708, 660, -818},
    { -847, 540, -636},
    { -780, 304, -539},
    { -739, 374, -550},
    { -727, 409, -588},
    { -632, 382, -675},
    { -472, 312, -641},
    { -423, 166, -595},
    { -366, 166, -515},
    { -366, 166, -527},
    { -414, 205, -678},
    { -488, 294, -725},
    { -471, 393, -785},
    { -641, 458, -845},
    { -874, 308, -934},
    { -503, 574, -723},
    { -1099, 978, -620},
    { -908, 751, -478},
    { -502, 519, -521},
    { -123, 488, -459},
    { -477, 616, -317},
    { -81, 879, -191},
    { -717, 427, -477},
    { -386, 435, -554},
    { -514, 404, -501},
    { -541, 485, -460},
    { -631, 359, -506},
    { -578, 582, -553},
    { -479, 643, -589},
    { -458, 966, -282},
    { -868, 880, -277},
    { -1042, 738, -653},
    { -1117, 1064, -567},
    { -960, 844, -154},
    { -627, 732, -152},
    { -528, 582, -189},
    { -382, 410, -125},
    { -301, 305, -89},
    { -295, 350, -170},
    { -316, 390, -304},
    { -415, 619, -510},
    { -1056, 864, -847},
    { -987, 610, -487},
    { -313, 362, -697},
    { -1037, 1035, -360},
    { -1118, 1097, -68},
    { -527, 618, 220},
    { -716, 292, 71},
    { -556, 611, -144},
    { -508, 770, -121},
    { -391, 686, -157},
    { -388, 564, -32},
    { -553, 522, -63},
    { -609, 694, -19},
    { -775, 749, 45},
    { -875, 972, -19},
    { -738, 809, 23},
    { -921, 1171, 291},
    { -1335, 758, 238},
    { -1009, 383, -322},
    { -1291, 301, 103},
    { -939, 619, 19},
    { -679, 616, -20},
    { -424, 475, -56},
    { -180, 209, 27},
    { -129, 89, -109},
    { -262, 248, -297},
    { -564, 768, -568},
    { -945, 1251, -682},
    { -1131, 733, -353},
    { -339, 439, -526},
    { -1377, 873, -248},
    { -899, 655, -3},
    { -502, 492, 328},
    { -656, 589, 137},
    { -523, 689, -39},
    { -592, 627, 82},
    { -559, 489, 74},
    { -604, 627, 66},
    { -631, 616, 35},
    { -624, 568, 25},
    { -673, 589, -2},
    { -775, 844, 24},
    { -840, 851, 87},
    { -867, 649, 104},
    { -939, 1109, 282},
    { -1167, 821, 174},
    { -925, 313, -115},
    { -1151, 84, 178},
    { -946, 552, 23},
    { -735, 719, -109},
    { -487, 515, -53},
    { -253, 263, -2},
    { -176, 106, -146},
    { -285, 283, -292},
    { -548, 747, -528},
    { -1002, 1186, -663},
    { -1062, 717, -441},
    { -603, 666, -529},
    { -1136, 952, -148},
    { -815, 517, -31},
    { -429, 355, 260},
    { -684, 587, 174},
    { -599, 813, -42},
    { -576, 794, 45},
    { -545, 556, 14},
    { -497, 509, 114},
    { -605, 480, 75},
    { -647, 511, -2},
    { -711, 661, 52},
    { -764, 1004, 33},
    { -821, 844, 55},
    { -764, 716, 199},
    { -915, 1127, 310},
    { -1124, 889, 236},
    { -1003, 426, -167},
    { -1068, 94, 118},
    { -858, 486, 50},
    { -677, 791, -65},
    { -485, 574, -40},
    { -315, 320, -33},
    { -289, 166, -147},
    { -315, 364, -187},
    { -456, 731, -348},
    { -865, 975, -495},
    { -1137, 1002, -509},
    { -513, 661, -545},
    { -1010, 835, -125},
    { -920, 583, 200},
    { -421, 534, 50},
    { -645, 484, 175},
    { -754, 548, -51},
    { -660, 846, -81},
    { -531, 649, -5},
    { -469, 500, 96},
    { -510, 365, 109},
    { -598, 410, 71},
    { -751, 572, 128},
    { -886, 910, 155},
    { -858, 863, 36},
    { -874, 824, 164},
    { -1111, 1037, 270},
    { -1027, 688, 65},
    { -1090, 110, -25},
    { -1020, 222, 64},
    { -834, 649, -51},
    { -616, 736, -60},
    { -379, 435, 1},
    { -281, 177, -37},
    { -255, 221, -136},
    { -392, 466, -272},
    { -642, 684, -414},
    { -998, 1145, -522},
    { -837, 938, -418},
    { -910, 1067, -326},
    { -1108, 891, 19},
    { -651, 325, 117},
    { -451, 182, 170},
    { -697, 609, 89},
    { -702, 876, -70},
    { -635, 861, 108},
    { -561, 608, 24},
    { -508, 443, 88},
    { -508, 455, 93},
    { -608, 565, 31},
    { -717, 664, 31},
    { -776, 1018, 103},
    { -798, 809, 92},
    { -810, 926, 275},
    { -1164, 996, 266},
    { -1005, 675, -25},
    { -1137, 155, -23},
    { -966, 296, 106},
    { -790, 578, 74},
    { -590, 634, -21},
    { -383, 388, 40},
    { -251, 174, -16},
    { -253, 249, -172},
    { -412, 479, -302},
    { -683, 864, -482},
    { -1054, 1156, -571},
    { -854, 744, -357},
    { -842, 1171, -199},
    { -1124, 621, 165},
    { -595, 526, 62},
    { -555, 501, 277},
    { -785, 534, 128},
    { -696, 777, -49},
    { -596, 707, 55},
    { -499, 522, 48},
    { -462, 457, 159},
    { -612, 442, 84},
    { -699, 538, 112},
    { -803, 706, 84},
    { -858, 927, 129},
    { -851, 743, 88},
    { -870, 875, 179},
    { -1176, 1061, 235},
    { -1010, 576, 154},
    { -1141, 25, -43},
    { -1019, 212, 117},
    { -875, 648, 3},
    { -642, 718, -41},
    { -394, 376, 60},
    { -199, 122, -19},
    { -193, 143, -175},
    { -327, 563, -307},
    { -743, 949, -489},
    { -1207, 1302, -530},
    { -651, 767, -391},
    { -1043, 1107, -117},
    { -989, 558, 193},
    { -688, 377, 93},
    { -566, 491, 153},
    { -674, 514, 63},
    { -633, 779, -14},
    { -542, 834, 76},
    { -528, 561, 64},
    { -518, 419, 121},
    { -618, 398, 22},
    { -677, 546, 50},
    { -757, 939, 57},
    { -837, 969, 151},
    { -714, 773, 52},
    { -797, 961, 227},
    { -1149, 1116, 120},
    { -1062, 536, 57},
    { -1142, 41, -20},
    { -939, 213, 6},
    { -793, 567, -29},
    { -548, 693, -59},
    { -409, 401, 14},
    { -269, 241, -86},
    { -270, 279, -197},
    { -438, 549, -367},
    { -713, 911, -462},
    { -1131, 1179, -505},
    { -615, 824, -522},
    { -1127, 1044, -134},
    { -915, 387, 246},
    { -563, 267, 197},
    { -647, 705, 199},
    { -672, 599, 82},
    { -616, 908, 5},
    { -531, 691, 32},
    { -517, 458, 90},
    { -519, 391, 139},
    { -641, 462, 65},
    { -711, 603, 111},
    { -745, 937, 72},
    { -788, 971, 146},
    { -685, 804, 59},
    { -812, 991, 335},
    { -1180, 1065, 219},
    { -970, 558, -21},
    { -1064, 154, -49},
    { -936, 358, 66},
    { -748, 581, 92},
    { -593, 735, 15},
    { -421, 478, 38},
    { -322, 326, -117},
    { -290, 389, -143},
    { -427, 363, -200},
    { -543, 625, -343},
    { -915, 908, -440},
    { -905, 1160, -374},
    { -781, 1186, -273},
    { -1276, 551, 220},
    { -683, 402, 145},
    { -502, 411, 224},
    { -716, 640, 20},
    { -648, 767, -96},
    { -542, 790, 33},
    { -499, 638, 33},
    { -474, 527, 115},
    { -580, 422, 122},
    { -672, 479, 106},
    { -738, 661, 134},
    { -831, 850, 135},
    { -835, 767, 86},
    { -710, 927, 106},
    { -876, 1238, 328},
    { -1071, 926, 213},
    { -983, 332, -88},
    { -1056, 144, 77},
    { -837, 439, 110},
    { -679, 658, 9},
    { -538, 605, -5},
    { -346, 346, -3},
    { -277, 259, -123},
    { -361, 342, -169},
    { -502, 607, -277},
    { -868, 839, -382},
    { -1125, 1269, -446},
    { -505, 727, -333},
    { -1053, 1114, -63},
    { -982, 432, 236},
    { -596, 318, 97},
    { -593, 610, 173},
    { -696, 687, 5},
    { -568, 810, -15},
    { -541, 638, 56},
    { -486, 595, 60},
    { -536, 594, 126},
    { -595, 480, 100},
    { -655, 545, 85},
    { -714, 713, 128},
    { -834, 843, 135},
    { -783, 860, 74},
    { -677, 893, 188},
    { -924, 1164, 349},
    { -1018, 785, 255},
    { -870, 382, -83},
    { -1106, 186, 154},
    { -921, 540, 160},
    { -762, 799, 10},
    { -532, 560, -6},
    { -358, 394, -2},
    { -262, 316, -70},
    { -378, 305, -168},
    { -489, 478, -232},
    { -754, 847, -350},
    { -1041, 1248, -416},
    { -663, 687, -306},
    { -1130, 1267, -154},
    { -903, 340, 332},
    { -517, 251, 117},
    { -480, 580, 188},
    { -573, 835, 106},
    { -669, 1139, -29},
    { -576, 675, 68},
    { -571, 461, 105},
    { -555, 493, 161},
    { -597, 489, 165},
    { -647, 509, 139},
    { -744, 646, 166},
    { -849, 804, 164},
    { -818, 845, 126},
    { -774, 954, 178},
    { -1011, 1110, 411},
    { -904, 758, 207},
    { -893, 221, -132},
    { -1046, 174, 167},
    { -824, 583, 135},
    { -724, 730, 15},
    { -533, 572, 11},
    { -422, 365, 11},
    { -373, 329, -85},
    { -421, 320, -111},
    { -519, 528, -265},
    { -727, 823, -380},
    { -1029, 1186, -404},
    { -638, 843, -272},
    { -1055, 1345, -139},
    { -1019, 304, 467},
    { -536, 282, 11},
    { -457, 482, 158},
    { -610, 758, 22},
    { -634, 971, -33},
    { -578, 719, 95},
    { -543, 566, 110},
    { -558, 485, 191},
    { -603, 416, 198},
    { -712, 425, 123},
    { -805, 644, 173},
    { -886, 902, 159},
    { -916, 831, 119},
    { -798, 947, 201},
    { -958, 1182, 320},
    { -853, 654, 218},
    { -905, 253, -135},
    { -1073, 147, 174},
    { -887, 506, 156},
    { -715, 760, -49},
    { -501, 616, -45},
    { -348, 384, -9},
    { -290, 226, -65},
    { -373, 255, -72},
    { -521, 552, -253},
    { -826, 990, -406},
    { -1174, 1203, -327},
    { -516, 858, -469},
    { -991, 972, -91},
    { -867, 362, 298},
    { -565, 176, -14},
    { -540, 512, 171},
    { -717, 825, -5},
    { -562, 901, 18},
    { -499, 650, 56},
    { -517, 492, 74},
    { -557, 555, 137},
    { -615, 411, 177},
    { -727, 440, 102},
    { -863, 683, 207},
    { -890, 1042, 225},
    { -847, 792, 81},
    { -875, 879, 276},
    { -1047, 957, 320},
    { -789, 547, 93},
    { -911, 153, -129},
    { -1075, 272, 147},
    { -867, 588, 61},
    { -687, 674, -36},
    { -493, 482, 18},
    { -322, 272, -31},
    { -260, 211, -101},
    { -332, 416, -190},
    { -644, 687, -422},
    { -1036, 1255, -421},
    { -1047, 828, -377},
    { -604, 864, -443},
    { -925, 637, 49},
    { -888, 478, 72},
    { -552, 115, 131},
    { -593, 499, 168},
    { -720, 744, 10},
    { -653, 884, 59},
    { -617, 657, 73},
    { -557, 542, 102},
    { -548, 506, 125},
    { -642, 426, 92},
    { -737, 492, 136},
    { -824, 727, 99},
    { -873, 992, 179},
    { -850, 729, 145},
    { -961, 978, 417},
    { -1243, 901, 315},
    { -909, 373, -77},
    { -1123, -107, 175},
    { -937, 260, 177},
    { -837, 652, 46},
    { -616, 642, 30},
    { -410, 401, 27},
    { -296, 197, -103},
    { -288, 195, -142},
    { -405, 527, -202},
    { -775, 876, -428},
    { -1276, 1235, -408},
    { -642, 850, -465},
    { -831, 1017, -162},
    { -1109, 439, 222},
    { -718, 590, -40},
    { -508, 278, 213},
    { -680, 615, 79},
    { -646, 834, 3},
    { -563, 776, 83},
    { -567, 497, 73},
    { -560, 463, 148},
    { -613, 439, 139},
    { -700, 499, 78},
    { -802, 662, 141},
    { -865, 1042, 200},
    { -870, 728, 122},
    { -951, 869, 376},
    { -1302, 990, 283},
    { -968, 456, -59},
    { -1082, -54, 43},
    { -923, 216, 157},
    { -812, 586, 31},
    { -606, 627, -40},
    { -393, 436, 19},
    { -299, 213, -109},
    { -281, 214, -157},
    { -402, 512, -225},
    { -698, 812, -400},
    { -1162, 1315, -399},
    { -745, 945, -448},
    { -935, 935, -130},
    { -1120, 573, 177},
    { -703, 542, -64},
    { -524, 307, 229},
    { -712, 571, 122},
    { -696, 778, 19},
    { -667, 736, 137},
    { -591, 602, 77},
    { -566, 506, 118},
    { -577, 475, 109},
    { -638, 498, 49},
    { -801, 615, 105},
    { -906, 934, 180},
    { -929, 842, 102},
    { -844, 729, 173},
    { -991, 934, 267},
    { -984, 662, 135},
    { -948, 236, -47},
    { -1153, 104, 163},
    { -882, 462, 63},
    { -758, 631, -64},
    { -555, 550, -14},
    { -378, 326, 7},
    { -325, 215, -136},
    { -329, 303, -173},
    { -432, 622, -304},
    { -783, 990, -453},
    { -1232, 1076, -327},
    { -751, 827, -505},
    { -956, 912, -120},
    { -859, 402, 158},
    { -595, -10, 42},
    { -508, 298, 242},
    { -722, 713, 104},
    { -734, 970, 72},
    { -674, 696, 97},
    { -617, 548, 94},
    { -561, 475, 120},
    { -580, 428, 103},
    { -669, 470, 86},
    { -818, 605, 109},
    { -883, 920, 179},
    { -892, 851, 141},
    { -940, 784, 291},
    { -1125, 914, 290},
    { -939, 562, 56},
    { -937, 135, -6},
    { -1036, 74, 221},
    { -871, 530, 93},
    { -700, 698, -43},
    { -539, 539, 0},
    { -390, 289, -61},
    { -309, 231, -136},
    { -351, 315, -160},
    { -487, 641, -296},
    { -900, 884, -381},
    { -1137, 1085, -251},
    { -543, 932, -519},
    { -930, 898, -5},
    { -921, 338, 250},
    { -696, 370, -82},
    { -622, 337, 247},
    { -762, 614, 89},
    { -654, 836, 92},
    { -600, 774, 103},
    { -577, 521, 59},
    { -526, 493, 127},
    { -622, 496, 117},
    { -709, 505, 92},
    { -826, 704, 152},
    { -906, 967, 214},
    { -847, 743, 94},
    { -864, 837, 277},
    { -1034, 993, 167},
    { -913, 518, 132},
    { -909, 206, 21},
    { -1027, 157, 188},
    { -877, 564, 48},
    { -678, 752, -79},
    { -500, 489, 19},
    { -309, 257, -52},
    { -297, 218, -149},
    { -314, 438, -162},
    { -626, 707, -376},
    { -1000, 1197, -460},
    { -955, 993, -320},
    { -776, 1145, -265},
    { -944, 611, 137},
    { -761, 407, -112},
    { -546, 185, 159},
    { -699, 543, 82},
    { -735, 806, 5},
    { -587, 833, 130},
    { -569, 674, 90},
    { -530, 470, 153},
    { -566, 417, 133},
    { -687, 460, 52},
    { -809, 560, 114},
    { -843, 908, 135},
    { -906, 856, 163},
    { -773, 751, 144},
    { -959, 1048, 383},
    { -1086, 826, 283},
    { -960, 380, -93},
    { -1147, 31, 173},
    { -897, 424, 74},
    { -700, 656, -33},
    { -533, 555, 8},
    { -307, 310, 17},
    { -280, 162, -92},
    { -291, 272, -131},
    { -540, 609, -306},
    { -922, 997, -430},
    { -1220, 1136, -321},
    { -523, 912, -486},
    { -1054, 608, 5},
    { -824, 307, 193},
    { -576, 170, 134},
    { -689, 558, 181},
    { -698, 662, 47},
    { -665, 786, 113},
    { -575, 694, 60},
    { -540, 553, 62},
    { -542, 533, 102},
    { -595, 470, 67},
    { -714, 523, 27},
    { -887, 769, 182},
    { -919, 935, 249},
    { -782, 797, 97},
    { -889, 955, 346},
    { -1135, 884, 212},
    { -1017, 361, 23},
    { -1138, -3, 130},
    { -873, 293, 62},
    { -762, 581, -14},
    { -590, 665, -30},
    { -390, 345, 48},
    { -319, 138, -102},
    { -299, 211, -151},
    { -394, 619, -200},
    { -902, 924, -508},
    { -1215, 1290, -344},
    { -699, 926, -533},
    { -977, 738, -24},
    { -961, 262, 314},
    { -558, 149, 37},
    { -618, 416, 213},
    { -749, 646, 50},
    { -746, 822, 87},
    { -600, 737, 97},
    { -563, 519, 87},
    { -564, 427, 114},
    { -585, 503, 87},
    { -648, 546, 8},
    { -753, 774, 99},
    { -913, 882, 237},
    { -832, 829, 94},
    { -901, 877, 311},
    { -1095, 956, 120},
    { -999, 396, 91},
    { -1050, 70, 22},
    { -968, 173, 147},
    { -894, 584, 1},
    { -646, 693, -68},
    { -460, 397, 18},
    { -283, 193, -77},
    { -252, 215, -186},
    { -386, 520, -297},
    { -703, 933, -458},
    { -1220, 1269, -448},
    { -803, 846, -480},
    { -928, 991, -143},
    { -1000, 541, 244},
    { -625, 245, -56},
    { -511, 333, 159},
    { -703, 629, 101},
    { -703, 804, 69},
    { -617, 734, 126},
    { -579, 567, 91},
    { -555, 465, 124},
    { -589, 450, 66},
    { -678, 519, 26},
    { -811, 646, 83},
    { -881, 1000, 177},
    { -876, 757, 136},
    { -855, 837, 258},
    { -1144, 981, 246},
    { -1041, 620, 128},
    { -1017, 149, -2},
    { -1009, 68, 164},
    { -824, 418, 87},
    { -643, 609, -44},
    { -525, 479, 26},
    { -314, 246, -48},
    { -299, 207, -212},
    { -314, 433, -243},
    { -583, 744, -395},
    { -968, 1158, -411},
    { -1097, 1054, -344},
    { -892, 1005, -231},
    { -1118, 490, 150},
    { -636, 459, -22},
    { -511, 267, 197},
    { -688, 613, 124},
    { -717, 699, -11},
    { -689, 798, 92},
    { -576, 739, 47},
    { -535, 526, 89},
    { -553, 405, 111},
    { -621, 452, 74},
    { -779, 480, 54},
    { -882, 887, 220},
    { -861, 946, 156},
    { -749, 812, 182},
    { -1180, 1006, 331},
    { -1163, 609, 229},
    { -1043, 65, -6},
    { -1051, 73, 122},
    { -840, 488, 57},
    { -642, 622, 5},
    { -517, 494, 38},
    { -359, 236, -38},
    { -310, 211, -200},
    { -354, 397, -266},
    { -568, 744, -377},
    { -974, 1130, -456},
    { -984, 894, -388},
    { -855, 905, -345},
    { -1321, 679, -96},
    { -732, 428, 155},
    { -508, 291, 205},
    { -626, 663, 117},
    { -576, 678, -55},
    { -578, 717, 6},
    { -536, 718, -19},
    { -495, 612, 76},
    { -592, 541, 8},
    { -651, 551, -46},
    { -696, 654, 0},
    { -732, 838, 70},
    { -755, 831, 155},
    { -882, 1190, 57},
    { -1081, 1014, 129},
    { -880, 674, -138},
    { -1078, 385, 138},
    { -918, 322, 194},
    { -898, 777, -197},
    { -732, 601, -239},
    { -403, 353, -167},
    { -352, 113, -268},
    { -315, 153, -315},
    { -446, 280, -485},
    { -617, 416, -543},
    { -873, 584, -635},
    { -1494, 574, -400},
    { -646, 542, -568},
    { -979, 860, -216},
    { -658, 876, -14},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-08-11 19:49:18 GMT
AccelRawData *activity_sample_raise_arm(int *len) {
  //> TEST_NAME raise_arm
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 50
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    { 153, 301, -947},
    { 91, 263, -925},
    { 126, 235, -938},
    { 136, 199, -947},
    { 153, 201, -943},
    { 152, 209, -931},
    { 107, 198, -925},
    { 234, 191, -940},
    { 104, 193, -925},
    { -109, 8, -852},
    { 53, 87, -940},
    { 47, 137, -955},
    { 14, 110, -964},
    { 35, 162, -956},
    { 117, 195, -946},
    { 157, 161, -900},
    { 140, 163, -874},
    { 115, 163, -850},
    { 157, 170, -850},
    { 161, 337, -813},
    { 135, 638, -807},
    { 73, 748, -646},
    { 66, 843, -565},
    { 98, 810, -502},
    { 70, 820, -419},
    { 80, 841, -406},
    { 102, 861, -413},
    { 73, 938, -398},
    { 91, 935, -425},
    { 105, 901, -422},
    { 111, 897, -430},
    { 110, 867, -431},
    { 120, 871, -434},
    { 126, 873, -411},
    { 133, 849, -396},
    { 144, 841, -392},
    { 147, 841, -379},
    { 150, 832, -375},
    { 152, 844, -355},
    { 166, 884, -335},
    { 173, 916, -302},
    { 178, 925, -245},
    { 220, 978, -225},
    { 228, 1023, -204},
    { 219, 1023, -197},
    { 231, 1052, -198},
    { 198, 1054, -204},
    { 182, 1101, -241},
    { 158, 1158, -267},
    { 142, 1131, -311},
    { 128, 1056, -409},
    { 106, 1003, -564},
    { 109, 936, -599},
    { 103, 631, -730},
    { 63, 492, -778},
    { 44, 373, -788},
    { 4, 180, -824},
    { -24, 14, -803},
    { -73, -100, -760},
    { -114, -198, -769},
    { -141, -237, -809},
    { -146, -244, -810},
    { -170, -277, -822},
    { -185, -270, -831},
    { -201, -275, -867},
    { -194, -282, -886},
    { -203, -285, -887},
    { -197, -281, -885},
    { -201, -257, -896},
    { -202, -269, -875},
    { -202, -239, -890},
    { -209, -237, -866},
    { -196, -238, -866},
    { -186, -238, -841},
    { -187, -249, -802},
    { -164, -252, -723},
    { -89, -194, -708},
    { -26, -99, -625},
    { -15, 81, -682},
    { 11, 502, -590},
    { 33, 786, -531},
    { 93, 1172, -482},
    { 91, 1218, -351},
    { 76, 1180, -253},
    { 112, 1183, -172},
    { 123, 1135, -74},
    { 172, 1090, -85},
    { 136, 1197, -46},
    { 149, 980, 40},
    { 201, 927, 47},
    { 235, 1050, -3},
    { 227, 1048, -12},
    { 216, 944, 0},
    { 215, 954, -3},
    { 216, 991, -12},
    { 205, 979, -6},
    { 204, 982, -22},
    { 209, 1009, -53},
    { 200, 1045, -62},
    { 197, 1004, -89},
    { 190, 1087, -129},
    { 180, 1078, -169},
    { 146, 1081, -259},
    { 124, 1103, -274},
    { 97, 1237, -441},
    { 111, 1225, -553},
    { 26, 965, -567},
    { -90, 605, -568},
    { -85, 371, -664},
    { -79, 159, -759},
    { -96, 42, -791},
    { -85, -89, -835},
    { -76, -192, -822},
    { -123, -252, -812},
    { -168, -311, -790},
    { -220, -337, -732},
    { -239, -362, -739},
    { -263, -362, -727},
    { -275, -323, -788},
    { -286, -294, -828},
    { -285, -299, -828},
    { -301, -283, -875},
    { -314, -273, -881},
    { -315, -291, -868},
    { -328, -276, -878},
    { -326, -280, -883},
    { -328, -278, -875},
    { -317, -272, -887},
    { -308, -254, -885},
    { -304, -259, -860},
    { -303, -249, -871},
    { -293, -251, -849},
    { -294, -248, -866},
    { -290, -245, -868},
    { -292, -260, -853},
    { -288, -260, -846},
    { -269, -272, -811},
    { -229, -308, -732},
    { -216, -355, -578},
    { -144, -281, -546},
    { -116, -52, -541},
    { -79, 299, -527},
    { -5, 866, -525},
    { 30, 1071, -353},
    { 22, 1235, -330},
    { 107, 1355, -227},
    { 160, 1184, -84},
    { 204, 1085, 10},
    { 218, 1147, 51},
    { 217, 1190, 23},
    { 220, 1078, 28},
    { 243, 1044, 0},
    { 228, 1044, -41},
    { 246, 1021, -50},
    { 258, 995, -30},
    { 278, 975, -3},
    { 283, 945, 8},
    { 275, 941, -19},
    { 263, 950, -23},
    { 263, 960, -27},
    { 245, 963, -51},
    { 256, 978, -25},
    { 247, 974, -22},
    { 257, 961, -17},
    { 249, 947, -15},
    { 241, 962, -19},
    { 243, 952, -21},
    { 252, 957, -26},
    { 248, 997, -30},
    { 241, 1001, -34},
    { 249, 1009, -47},
    { 226, 1162, -63},
    { 218, 1221, -115},
    { 204, 1325, -252},
    { 156, 1244, -395},
    { 116, 1083, -530},
    { 88, 820, -655},
    { 77, 429, -647},
    { 72, 132, -694},
    { 39, -20, -703},
    { 50, -172, -826},
    { 4, -261, -819},
    { -21, -260, -829},
    { -50, -290, -865},
    { -76, -305, -894},
    { -107, -298, -836},
    { -141, -321, -821},
    { -159, -356, -811},
    { -169, -342, -824},
    { -167, -323, -843},
    { -178, -328, -838},
    { -178, -312, -855},
    { -191, -320, -862},
    { -182, -308, -891},
    { -178, -305, -917},
    { -177, -310, -915},
    { -170, -303, -916},
    { -177, -310, -929},
    { -173, -314, -911},
    { -173, -316, -907},
    { -180, -311, -904},
    { -179, -306, -895},
    { -171, -290, -898},
    { -180, -301, -894},
    { -170, -297, -906},
    { -173, -296, -899},
    { -175, -298, -889},
    { -172, -302, -902},
    { -169, -295, -902},
    { -167, -305, -906},
    { -175, -302, -894},
    { -162, -310, -897},
    { -152, -306, -873},
    { -137, -326, -823},
    { -96, -380, -692},
    { -41, -334, -571},
    { 14, -38, -584},
    { -3, 455, -620},
    { -70, 691, -613},
    { -60, 795, -520},
    { -18, 903, -367},
    { -7, 994, -244},
    { 80, 1200, -164},
    { 131, 1223, -122},
    { 165, 1161, 3},
    { 229, 1133, 63},
    { 250, 1111, -12},
    { 211, 1235, 10},
    { 212, 1060, 69},
    { 241, 949, 90},
    { 262, 993, 72},
    { 280, 988, 75},
    { 284, 974, 78},
    { 286, 948, 82},
    { 289, 962, 71},
    { 282, 954, 71},
    { 271, 954, 70},
    { 278, 956, 73},
    { 277, 963, 77},
    { 270, 958, 86},
    { 274, 975, 85},
    { 276, 954, 79},
    { 277, 953, 80},
    { 277, 960, 75},
    { 281, 956, 78},
    { 286, 959, 82},
    { 278, 951, 81},
    { 277, 956, 83},
    { 279, 969, 80},
    { 275, 969, 85},
    { 277, 967, 74},
    { 273, 989, 61},
    { 262, 1160, 33},
    { 232, 1154, 0},
    { 251, 1354, -82},
    { 186, 1317, -230},
    { 169, 1276, -410},
    { 122, 1119, -584},
    { 79, 867, -590},
    { 31, 349, -589},
    { -2, 187, -625},
    { -26, -45, -684},
    { -67, -137, -704},
    { -50, -219, -767},
    { -79, -299, -757},
    { -97, -401, -747},
    { -103, -412, -762},
    { -109, -382, -804},
    { -113, -399, -826},
    { -124, -361, -832},
    { -153, -340, -840},
    { -167, -344, -851},
    { -170, -328, -883},
    { -163, -365, -871},
    { -161, -354, -892},
    { -151, -356, -916},
    { -148, -366, -912},
    { -149, -373, -907},
    { -148, -365, -902},
    { -150, -363, -896},
    { -161, -347, -893},
    { -154, -345, -889},
    { -158, -334, -881},
    { -155, -339, -886},
    { -151, -339, -892},
    { -152, -340, -887},
    { -158, -336, -883},
    { -155, -343, -889},
    { -149, -346, -882},
    { -146, -339, -894},
    { -155, -352, -890},
    { -149, -347, -896},
    { -146, -340, -890},
    { -146, -357, -863},
    { -125, -350, -842},
    { -94, -385, -774},
    { -39, -409, -662},
    { -15, -218, -616},
    { -25, 85, -638},
    { -46, 324, -621},
    { -71, 575, -493},
    { -119, 839, -431},
    { -37, 980, -464},
    { 22, 1121, -304},
    { 74, 1299, -225},
    { 107, 1263, -114},
    { 167, 1088, -62},
    { 218, 1118, -14},
    { 237, 1105, -17},
    { 247, 973, -45},
    { 207, 1201, -107},
    { 257, 1085, 25},
    { 283, 969, 40},
    { 297, 928, 57},
    { 288, 973, 14},
    { 284, 951, 16},
    { 284, 940, 26},
    { 284, 956, 26},
    { 282, 962, 29},
    { 277, 966, 27},
    { 269, 960, 21},
    { 280, 960, 24},
    { 279, 953, 31},
    { 276, 958, 34},
    { 281, 962, 26},
    { 284, 952, 22},
    { 279, 953, 21},
    { 274, 962, 28},
    { 270, 963, 28},
    { 272, 955, 24},
    { 276, 958, 24},
    { 279, 962, 19},
    { 281, 984, 18},
    { 275, 1008, -8},
    { 265, 1098, -33},
    { 286, 1184, -39},
    { 221, 1144, -85},
    { 152, 1274, -246},
    { 187, 1294, -328},
    { 121, 1078, -499},
    { 118, 920, -642},
    { 41, 714, -670},
    { 3, 473, -685},
    { -4, 193, -682},
    { -36, -1, -726},
    { -80, -92, -769},
    { -92, -203, -756},
    { -123, -289, -723},
    { -127, -333, -745},
    { -164, -368, -742},
    { -166, -393, -769},
    { -173, -343, -828},
    { -191, -334, -822},
    { -202, -327, -854},
    { -227, -310, -870},
    { -223, -322, -874},
    { -216, -309, -924},
    { -219, -323, -922},
    { -224, -322, -913},
    { -229, -330, -901},
    { -220, -338, -883},
    { -213, -325, -886},
    { -215, -316, -882},
    { -223, -312, -876},
    { -229, -318, -873},
    { -221, -305, -885},
    { -227, -320, -879},
    { -227, -310, -885},
    { -227, -323, -874},
    { -227, -318, -877},
    { -219, -319, -888},
    { -216, -323, -882},
    { -226, -311, -885},
    { -212, -318, -884},
    { -216, -311, -888},
    { -216, -314, -874},
    { -203, -323, -855},
    { -191, -341, -820},
    { -146, -361, -763},
    { -109, -283, -706},
    { -107, -107, -645},
    { -133, 79, -594},
    { -161, 256, -553},
    { -131, 458, -557},
    { -79, 676, -478},
    { -39, 866, -449},
    { 109, 1136, -450},
    { 224, 1261, -340},
    { 238, 1270, -224},
    { 190, 1252, -118},
    { 219, 1181, -69},
    { 137, 1385, -122},
    { 223, 1141, 19},
    { 215, 980, 56},
    { 255, 915, 18},
    { 293, 943, 23},
    { 282, 942, 24},
    { 282, 959, 21},
    { 280, 975, 12},
    { 272, 963, 18},
    { 274, 953, 21},
    { 264, 959, 21},
    { 260, 957, 23},
    { 261, 966, 32},
    { 258, 962, 17},
    { 264, 961, 25},
    { 262, 964, 22},
    { 273, 964, 25},
    { 273, 963, 23},
    { 264, 955, 26},
    { 259, 975, 22},
    { 256, 975, 21},
    { 253, 981, 13},
    { 253, 1010, -5},
    { 244, 1032, -23},
    { 247, 1015, -75},
    { 246, 1107, -90},
    { 224, 1283, -170},
    { 203, 1191, -275},
    { 145, 1194, -422},
    { 83, 1138, -535},
    { 82, 922, -616},
    { 15, 792, -697},
    { -27, 543, -753},
    { -53, 248, -703},
    { -63, 105, -689},
    { -91, -85, -695},
    { -149, -180, -681},
    { -173, -296, -648},
    { -206, -396, -652},
    { -211, -437, -672},
    { -213, -414, -718},
    { -198, -408, -818},
    { -203, -364, -857},
    { -222, -356, -880},
    { -228, -364, -885},
    { -239, -361, -872},
    { -234, -370, -869},
    { -230, -356, -883},
    { -233, -368, -876},
    { -234, -357, -874},
    { -238, -359, -871},
    { -234, -356, -876},
    { -231, -367, -859},
    { -238, -358, -854},
    { -232, -365, -842},
    { -236, -336, -862},
    { -222, -339, -881},
    { -216, -340, -886},
    { -231, -331, -900},
    { -231, -360, -889},
    { -235, -353, -878},
    { -233, -345, -872},
    { -227, -345, -871},
    { -227, -344, -875},
    { -216, -338, -868},
    { -225, -339, -866},
    { -222, -343, -869},
    { -223, -346, -871},
    { -225, -333, -878},
    { -227, -351, -854},
    { -221, -355, -835},
    { -204, -331, -824},
    { -164, -364, -734},
    { -108, -369, -625},
    { -58, -171, -597},
    { -93, 129, -558},
    { -172, 454, -615},
    { -190, 660, -598},
    { -153, 842, -529},
    { -143, 900, -534},
    { -69, 1024, -493},
    { 11, 1088, -427},
    { 97, 1113, -298},
    { 124, 1104, -228},
    { 158, 1088, -170},
    { 184, 1089, -97},
    { 232, 1014, -45},
    { 351, 1201, -410},
    { 238, 1285, -171},
    { 245, 978, -80},
    { 224, 877, -20},
    { 300, 897, -86},
    { 293, 954, -107},
    { 268, 978, -91},
    { 260, 981, -78},
    { 256, 975, -80},
    { 249, 964, -74},
    { 249, 945, -67},
    { 252, 958, -62},
    { 254, 963, -64},
    { 255, 956, -66},
    { 257, 953, -62},
    { 264, 950, -62},
    { 257, 951, -58},
    { 254, 955, -58},
    { 255, 978, -56},
    { 247, 962, -59},
    { 254, 957, -53},
    { 255, 958, -53},
    { 256, 956, -50},
    { 254, 964, -52},
    { 260, 964, -55},
    { 258, 964, -61},
    { 256, 964, -62},
    { 254, 971, -73},
    { 243, 978, -96},
    { 246, 1009, -93},
    { 249, 1054, -135},
    { 242, 1131, -179},
    { 189, 1244, -203},
    { 168, 1167, -273},
    { 107, 1251, -426},
    { 104, 1159, -509},
    { 56, 995, -542},
    { 41, 873, -696},
    { -73, 594, -648},
    { -102, 362, -645},
    { -119, 177, -602},
    { -155, -1, -631},
    { -168, -102, -658},
    { -175, -245, -658},
    { -212, -342, -660},
    { -222, -404, -708},
    { -234, -458, -735},
    { -228, -382, -835},
    { -237, -383, -863},
    { -255, -336, -872},
    { -274, -338, -873},
    { -277, -344, -860},
    { -292, -340, -840},
    { -305, -337, -850},
    { -278, -349, -849},
    { -276, -354, -847},
    { -279, -344, -859},
    { -275, -356, -860},
    { -271, -359, -855},
    { -278, -349, -849},
    { -268, -343, -855},
    { -266, -357, -851},
    { -272, -343, -864},
    { -266, -350, -855},
    { -272, -343, -852},
    { -277, -342, -854},
    { -268, -351, -850},
    { -261, -357, -833},
    { -254, -365, -795},
    { -208, -375, -739},
    { -147, -395, -653},
    { -138, -260, -649},
    { -159, -29, -614},
    { -137, 154, -549},
    { -173, 337, -568},
    { -132, 701, -532},
    { -103, 1005, -409},
    { -124, 1056, -371},
    { -41, 1058, -259},
    { 78, 1123, -177},
    { 168, 1041, -110},
    { 259, 1163, -32},
    { 299, 1159, 7},
    { 324, 1181, 5},
    { 316, 1069, 44},
    { 338, 1099, 71},
    { 366, 990, -20},
    { 352, 1114, -88},
    { 387, 1079, 33},
    { 389, 953, 73},
    { 391, 882, 98},
    { 404, 917, 86},
    { 404, 918, 81},
    { 389, 917, 79},
    { 396, 927, 80},
    { 386, 922, 93},
    { 384, 916, 92},
    { 388, 934, 94},
    { 380, 933, 102},
    { 380, 929, 93},
    { 383, 927, 90},
    { 387, 927, 91},
    { 382, 922, 94},
    { 381, 925, 95},
    { 379, 922, 87},
    { 381, 920, 87},
    { 380, 927, 85},
    { 383, 927, 83},
    { 383, 921, 78},
    { 376, 932, 80},
    { 379, 944, 72},
    { 380, 951, 65},
    { 383, 1007, 51},
    { 352, 976, 45},
    { 356, 1025, 19},
    { 332, 1099, 56},
    { 311, 1173, 48},
    { 236, 1208, -12},
    { 192, 1246, -92},
    { 184, 1286, -208},
    { 141, 1241, -364},
    { 71, 1203, -406},
    { 46, 858, -482},
    { -18, 673, -516},
    { -72, 350, -421},
    { -93, -145, -361},
    { -44, -254, -599},
    { -44, -300, -815},
    { -21, -353, -886},
    { 6, -428, -901},
    { -23, -445, -905},
    { -118, -491, -865},
    { -161, -475, -803},
    { -209, -431, -722},
    { -237, -459, -611},
    { -241, -441, -671},
    { -198, -414, -806},
    { -182, -416, -812},
    { -190, -415, -851},
    { -216, -430, -904},
    { -225, -463, -875},
    { -211, -472, -854},
    { -210, -451, -857},
    { -207, -435, -838},
    { -209, -414, -843},
    { -209, -409, -856},
    { -208, -419, -836},
    { -212, -414, -852},
    { -221, -420, -849},
    { -218, -419, -848},
    { -220, -416, -853},
    { -209, -422, -873},
    { -208, -430, -844},
    { -204, -442, -820},
    { -197, -445, -804},
    { -171, -481, -722},
    { -153, -299, -730},
    { -174, -121, -732},
    { -168, -85, -686},
    { -162, 158, -722},
    { -204, 516, -725},
    { -241, 574, -653},
    { -261, 556, -495},
    { -244, 586, -414},
    { -140, 775, -330},
    { -161, 907, -250},
    { -72, 1049, -113},
    { 16, 1304, -12},
    { 77, 1476, -42},
    { 126, 1082, 28},
    { 149, 1108, 157},
    { 172, 1056, 187},
    { 239, 1107, 28},
    { 286, 1049, -225},
    { 263, 1174, -76},
    { 250, 923, 56},
    { 281, 893, -6},
    { 284, 943, -87},
    { 264, 990, -56},
    { 263, 936, -56},
    { 262, 942, -69},
    { 268, 960, -68},
    { 259, 954, -58},
    { 251, 959, -61},
    { 250, 961, -65},
    { 252, 965, -63},
    { 253, 960, -64},
    { 261, 950, -64},
    { 263, 957, -62},
    { 258, 962, -58},
    { 252, 959, -60},
    { 255, 959, -58},
    { 255, 959, -56},
    { 256, 959, -57},
    { 257, 960, -54},
    { 259, 956, -61},
    { 260, 955, -62},
    { 263, 959, -64},
    { 255, 970, -70},
    { 254, 984, -87},
    { 242, 1087, -128},
    { 283, 1189, -204},
    { 208, 1206, -329},
    { 196, 1149, -424},
    { 199, 1175, -587},
    { 166, 925, -692},
    { 66, 806, -785},
    { 33, 693, -849},
    { 12, 338, -844},
    { -33, 98, -670},
    { -53, -104, -649},
    { -60, -233, -655},
    { -100, -344, -642},
    { -103, -403, -665},
    { -122, -409, -689},
    { -135, -429, -741},
    { -147, -403, -796},
    { -167, -384, -825},
    { -207, -391, -826},
    { -222, -393, -838},
    { -231, -368, -864},
    { -222, -396, -876},
    { -206, -390, -854},
    { -200, -376, -855},
    { -173, -368, -861},
    { -156, -354, -860},
    { -190, -313, -862},
    { -237, -249, -891},
    { -247, -291, -840},
    { -226, -222, -838},
    { -271, -69, -836},
    { -358, -20, -838},
    { -304, -66, -825},
    { -271, 112, -898},
    { -236, 160, -934},
    { -196, 146, -917},
    { -211, 236, -955},
    { -219, 285, -950},
    { -250, 318, -911},
    { -255, 320, -898},
    { -271, 351, -864},
    { -253, 367, -871},
    { -219, 391, -861},
    { -213, 376, -861},
    { -194, 368, -857},
    { -187, 380, -858},
    { -188, 438, -841},
    { -168, 441, -850},
    { -176, 387, -870},
    { -214, 487, -788},
    { -236, 507, -792},
    { -270, 463, -857},
    { -298, 527, -880},
    { -312, 381, -890},
    { -304, 354, -841},
    { -270, 539, -775},
    { -232, 354, -666},
    { -160, 415, -752},
    { -88, 424, -789},
    { -78, 315, -803},
    { -53, 405, -910},
    { -40, 356, -1004},
    { -98, 307, -947},
    { -103, 313, -904},
    { -95, 252, -872},
    { -87, 292, -891},
    { -90, 333, -873},
    { -104, 347, -847},
    { -62, 393, -887},
    { -87, 299, -859},
    { -79, 291, -920},
    { -81, 330, -937},
    { -77, 365, -938},
    { -55, 357, -875},
    { -58, 451, -842},
    { -50, 412, -817},
    { -3, 308, -707},
    { -23, 335, -820},
    { -51, 367, -969},
    { -61, 325, -977},
    { -21, 288, -948},
    { -24, 253, -914},
    { -17, 298, -983},
    { 1, 340, -1010},
    { -69, 357, -924},
    { -63, 385, -893},
    { 8, 533, -912},
    { 35, 378, -879},
    { 44, 177, -1044},
    { -32, 72, -885},
    { 109, -108, -959},
    { 4, -58, -967},
    { -83, 53, -865},
    { -72, -161, -940},
    { -65, -234, -960},
    { -5, -333, -916},
    { 68, -453, -895},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-08-11 21:52:40 GMT
AccelRawData *activity_sample_100_steps(int *len) {
  //> TEST_NAME walk_100
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 110
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    { 66, -2, -1224},
    { 229, -33, -1277},
    { 514, 84, -1293},
    { 362, 143, -1111},
    { 204, 123, -1028},
    { 244, 8, -821},
    { 199, -72, -621},
    { 187, -158, -578},
    { 97, -169, -621},
    { 80, -144, -711},
    { 28, -159, -834},
    { -35, -215, -950},
    { 47, -211, -1044},
    { 102, -193, -1128},
    { -65, -252, -1234},
    { 163, -250, -1268},
    { 722, -24, -1195},
    { 497, 3, -859},
    { 275, -39, -719},
    { 364, -177, -501},
    { 463, -108, -367},
    { 304, -80, -365},
    { 398, -172, -304},
    { 556, -175, -260},
    { 716, -118, -183},
    { 900, 201, -182},
    { 1221, 486, -78},
    { 1516, 802, 13},
    { 1801, 1091, 138},
    { 2151, 1271, 251},
    { 1741, 1575, 335},
    { 928, 1128, 307},
    { 864, 660, 43},
    { 734, 503, 40},
    { 608, 399, 63},
    { 518, 360, 57},
    { 590, 343, 59},
    { 771, 311, 77},
    { 936, 317, 83},
    { 1166, 352, 116},
    { 1480, 288, 226},
    { 1449, 184, 295},
    { 1371, 227, 150},
    { 1308, -6, 37},
    { 948, 151, -150},
    { 922, 93, -43},
    { 888, -72, 144},
    { 786, 72, 131},
    { 780, 167, 107},
    { 820, 276, 103},
    { 897, 335, 101},
    { 1012, 334, 139},
    { 991, 359, 140},
    { 957, 383, 109},
    { 1058, 489, 63},
    { 1026, 607, -40},
    { 1045, 669, -49},
    { 1104, 664, -6},
    { 1052, 492, 83},
    { 1256, 562, 29},
    { 1249, 576, 57},
    { 1146, 470, 128},
    { 1058, 325, 162},
    { 1042, 206, 202},
    { 1011, 165, 242},
    { 936, 143, 252},
    { 899, 173, 229},
    { 907, 178, 234},
    { 1051, 181, 268},
    { 1070, 193, 208},
    { 1200, 200, 201},
    { 1216, 253, 64},
    { 1100, 413, -183},
    { 1126, 410, -120},
    { 1010, 337, 13},
    { 827, 289, 44},
    { 816, 273, 30},
    { 845, 363, 51},
    { 908, 386, 80},
    { 920, 384, 59},
    { 843, 382, -10},
    { 915, 385, -11},
    { 1254, 439, -13},
    { 1175, 436, -8},
    { 1243, 462, -30},
    { 1354, 562, -88},
    { 1317, 553, 45},
    { 1319, 459, 145},
    { 1177, 381, 126},
    { 982, 315, 126},
    { 837, 273, 132},
    { 812, 244, 133},
    { 838, 194, 168},
    { 839, 162, 194},
    { 811, 140, 208},
    { 855, 147, 211},
    { 1075, 153, 253},
    { 1137, 199, 242},
    { 1301, 258, 211},
    { 1325, 317, 135},
    { 1048, 479, -178},
    { 998, 413, -108},
    { 1003, 325, 73},
    { 905, 219, 85},
    { 878, 221, 53},
    { 825, 294, 77},
    { 817, 374, 52},
    { 799, 419, -23},
    { 787, 379, -25},
    { 942, 374, 0},
    { 1253, 415, -19},
    { 1169, 433, -3},
    { 1298, 459, -5},
    { 1506, 594, -99},
    { 1224, 435, 97},
    { 1236, 415, 121},
    { 1123, 379, 91},
    { 997, 355, 129},
    { 875, 262, 193},
    { 823, 220, 187},
    { 826, 185, 201},
    { 842, 170, 210},
    { 789, 169, 191},
    { 879, 168, 211},
    { 1049, 156, 236},
    { 1061, 190, 163},
    { 1259, 236, 153},
    { 1446, 310, 125},
    { 1062, 462, -191},
    { 1082, 371, -88},
    { 998, 278, 100},
    { 867, 229, 89},
    { 873, 233, 65},
    { 866, 319, 128},
    { 864, 374, 130},
    { 864, 393, 91},
    { 761, 407, 2},
    { 815, 415, -34},
    { 1132, 447, 0},
    { 1203, 459, -18},
    { 1230, 477, -15},
    { 1310, 563, -13},
    { 1178, 476, 97},
    { 1202, 456, 96},
    { 1182, 429, 97},
    { 1068, 382, 136},
    { 912, 324, 143},
    { 842, 324, 184},
    { 856, 360, 229},
    { 849, 371, 223},
    { 808, 425, 157},
    { 825, 437, 136},
    { 1043, 624, 83},
    { 1133, 631, 12},
    { 1165, 698, -167},
    { 1073, 673, -278},
    { 866, 417, -575},
    { 803, 188, -424},
    { 713, 30, -435},
    { 544, 63, -416},
    { 441, 20, -457},
    { 397, 73, -593},
    { 381, 75, -655},
    { 405, 136, -739},
    { 427, 109, -845},
    { 357, 98, -894},
    { 422, 133, -980},
    { 439, 172, -996},
    { 462, 272, -994},
    { 562, 465, -1088},
    { 588, 534, -910},
    { 563, 417, -746},
    { 543, 382, -688},
    { 537, 310, -565},
    { 485, 255, -441},
    { 525, 252, -463},
    { 590, 252, -395},
    { 617, 167, -293},
    { 709, 231, -258},
    { 957, 229, -157},
    { 1268, 282, -87},
    { 1523, 319, 94},
    { 1750, 416, 297},
    { 1302, 503, 65},
    { 1138, 469, -39},
    { 1066, 440, 144},
    { 867, 418, 133},
    { 785, 295, 132},
    { 738, 284, 138},
    { 712, 327, 101},
    { 740, 391, 29},
    { 774, 381, -5},
    { 944, 400, -39},
    { 1191, 435, -84},
    { 1209, 475, -99},
    { 1525, 551, -128},
    { 1517, 582, -30},
    { 1428, 369, 168},
    { 1194, 385, 123},
    { 1078, 307, 115},
    { 942, 326, 125},
    { 874, 277, 188},
    { 845, 205, 204},
    { 834, 169, 241},
    { 863, 150, 237},
    { 855, 151, 242},
    { 965, 158, 278},
    { 1100, 163, 306},
    { 1075, 206, 197},
    { 1294, 282, 155},
    { 1185, 320, 37},
    { 1132, 429, -197},
    { 1078, 352, -113},
    { 888, 263, 9},
    { 773, 239, 23},
    { 804, 261, 26},
    { 835, 320, 52},
    { 848, 377, 15},
    { 882, 364, -17},
    { 895, 357, -17},
    { 1048, 354, 12},
    { 1325, 408, 12},
    { 1212, 452, 50},
    { 1247, 487, 38},
    { 1341, 581, -61},
    { 1175, 468, 95},
    { 1130, 432, 96},
    { 1089, 360, 106},
    { 967, 317, 140},
    { 851, 241, 159},
    { 819, 205, 168},
    { 848, 191, 199},
    { 888, 181, 231},
    { 907, 163, 231},
    { 970, 191, 260},
    { 1174, 190, 307},
    { 1125, 224, 237},
    { 1333, 256, 247},
    { 1174, 301, 77},
    { 996, 435, -254},
    { 1001, 302, -107},
    { 881, 220, -54},
    { 728, 148, -37},
    { 762, 206, -37},
    { 856, 316, -2},
    { 920, 381, -10},
    { 939, 375, -64},
    { 903, 354, -58},
    { 972, 328, -26},
    { 1242, 374, -45},
    { 1136, 372, 6},
    { 1202, 418, 34},
    { 1403, 537, -93},
    { 1148, 485, 74},
    { 1206, 426, 142},
    { 1148, 371, 134},
    { 1031, 328, 151},
    { 899, 270, 179},
    { 830, 230, 179},
    { 815, 200, 192},
    { 798, 174, 166},
    { 753, 169, 152},
    { 921, 162, 173},
    { 1143, 162, 214},
    { 1266, 178, 203},
    { 1434, 223, 225},
    { 1213, 356, -40},
    { 1065, 521, -298},
    { 953, 350, -71},
    { 832, 177, 89},
    { 808, 112, 98},
    { 802, 212, 125},
    { 794, 327, 122},
    { 843, 412, 51},
    { 844, 423, -9},
    { 808, 371, 0},
    { 965, 318, 22},
    { 1293, 336, 73},
    { 1186, 392, 29},
    { 1219, 478, -30},
    { 1340, 621, -102},
    { 1238, 464, 116},
    { 1193, 439, 88},
    { 1115, 363, 71},
    { 989, 347, 109},
    { 896, 265, 161},
    { 859, 217, 156},
    { 882, 190, 182},
    { 920, 167, 217},
    { 856, 175, 198},
    { 887, 191, 197},
    { 1051, 185, 251},
    { 1042, 197, 218},
    { 1164, 264, 143},
    { 1307, 268, 168},
    { 1013, 339, -77},
    { 1019, 406, -146},
    { 915, 290, 29},
    { 871, 211, 52},
    { 884, 177, 66},
    { 850, 240, 91},
    { 849, 317, 74},
    { 876, 338, 24},
    { 865, 326, -1},
    { 869, 289, 13},
    { 1067, 308, 39},
    { 1302, 362, 59},
    { 1295, 410, 69},
    { 1374, 480, 60},
    { 1270, 556, -33},
    { 1093, 456, 17},
    { 1066, 391, 54},
    { 1034, 312, 83},
    { 930, 254, 119},
    { 854, 204, 148},
    { 825, 197, 163},
    { 871, 202, 197},
    { 967, 179, 232},
    { 909, 175, 234},
    { 968, 198, 253},
    { 1132, 183, 289},
    { 1163, 234, 211},
    { 1218, 237, 197},
    { 1100, 309, 38},
    { 935, 413, -206},
    { 945, 288, -61},
    { 965, 232, -2},
    { 873, 158, 3},
    { 820, 184, -4},
    { 801, 209, 1},
    { 861, 271, -29},
    { 865, 299, -42},
    { 822, 275, -20},
    { 935, 289, -22},
    { 1275, 352, -3},
    { 1279, 399, 34},
    { 1329, 462, 60},
    { 1415, 588, -40},
    { 1145, 411, 125},
    { 1131, 398, 107},
    { 1048, 351, 84},
    { 908, 322, 100},
    { 808, 265, 125},
    { 787, 231, 131},
    { 839, 217, 169},
    { 869, 187, 185},
    { 808, 173, 174},
    { 948, 183, 209},
    { 1160, 179, 259},
    { 1194, 226, 193},
    { 1368, 261, 185},
    { 1242, 321, 35},
    { 980, 446, -248},
    { 925, 305, -95},
    { 898, 192, 32},
    { 849, 149, 80},
    { 823, 210, 64},
    { 768, 311, 54},
    { 801, 347, 25},
    { 863, 326, 17},
    { 819, 283, 13},
    { 946, 288, 10},
    { 1200, 358, 29},
    { 1219, 436, -23},
    { 1212, 504, -52},
    { 1188, 574, -70},
    { 1161, 498, 30},
    { 1234, 404, 118},
    { 1091, 373, 103},
    { 1015, 379, 117},
    { 855, 325, 134},
    { 758, 259, 136},
    { 793, 222, 152},
    { 856, 197, 191},
    { 861, 174, 190},
    { 959, 173, 231},
    { 1133, 159, 291},
    { 1133, 210, 209},
    { 1253, 248, 149},
    { 1415, 303, 176},
    { 920, 398, -187},
    { 880, 352, -151},
    { 920, 288, -1},
    { 862, 191, 64},
    { 850, 171, 57},
    { 789, 233, 76},
    { 799, 303, 25},
    { 841, 322, -4},
    { 798, 313, -38},
    { 882, 315, -26},
    { 1220, 367, 32},
    { 1275, 442, 29},
    { 1232, 505, 29},
    { 1459, 585, 15},
    { 1153, 488, 54},
    { 1125, 443, 47},
    { 1115, 363, 85},
    { 978, 345, 98},
    { 860, 264, 114},
    { 799, 231, 120},
    { 802, 214, 144},
    { 844, 202, 177},
    { 887, 183, 176},
    { 897, 188, 189},
    { 1064, 185, 260},
    { 1203, 186, 287},
    { 1292, 267, 212},
    { 1256, 289, 130},
    { 967, 442, -236},
    { 909, 380, -162},
    { 871, 236, 0},
    { 834, 145, 26},
    { 815, 197, 32},
    { 781, 285, 20},
    { 789, 327, -14},
    { 832, 300, -8},
    { 836, 274, -10},
    { 900, 279, 6},
    { 1147, 329, 35},
    { 1264, 397, 37},
    { 1291, 430, 50},
    { 1463, 552, -62},
    { 1181, 488, 98},
    { 1230, 398, 124},
    { 1088, 342, 80},
    { 887, 334, 72},
    { 807, 307, 101},
    { 787, 244, 130},
    { 834, 197, 187},
    { 878, 176, 196},
    { 830, 176, 179},
    { 957, 197, 202},
    { 1120, 190, 261},
    { 1062, 224, 195},
    { 1208, 260, 134},
    { 1366, 295, 157},
    { 958, 405, -176},
    { 958, 385, -150},
    { 884, 270, 26},
    { 856, 193, 59},
    { 822, 197, 64},
    { 769, 275, 78},
    { 796, 313, 45},
    { 835, 317, 37},
    { 805, 312, -30},
    { 840, 307, -20},
    { 1149, 329, 34},
    { 1278, 366, 32},
    { 1212, 426, 27},
    { 1271, 513, -15},
    { 1214, 570, -9},
    { 1263, 429, 104},
    { 1119, 395, 109},
    { 1000, 358, 97},
    { 923, 346, 118},
    { 818, 257, 135},
    { 806, 222, 156},
    { 839, 190, 187},
    { 823, 177, 176},
    { 825, 193, 181},
    { 988, 184, 236},
    { 1134, 204, 231},
    { 1281, 245, 203},
    { 1442, 250, 259},
    { 1116, 407, -114},
    { 969, 432, -192},
    { 897, 345, -74},
    { 813, 203, 7},
    { 790, 189, 30},
    { 748, 267, 15},
    { 789, 303, 24},
    { 859, 290, 41},
    { 872, 303, 7},
    { 848, 323, -18},
    { 1070, 370, 25},
    { 1306, 424, 52},
    { 1238, 451, 36},
    { 1221, 497, 12},
    { 1305, 558, -27},
    { 1087, 459, 43},
    { 1079, 416, 78},
    { 1062, 381, 84},
    { 951, 363, 103},
    { 854, 296, 134},
    { 830, 261, 133},
    { 858, 232, 169},
    { 876, 200, 193},
    { 883, 196, 177},
    { 968, 210, 185},
    { 1071, 187, 249},
    { 1086, 190, 197},
    { 1246, 252, 155},
    { 1229, 293, 98},
    { 922, 439, -227},
    { 842, 344, -135},
    { 866, 292, 0},
    { 865, 202, 55},
    { 834, 235, 56},
    { 810, 297, 41},
    { 834, 330, 13},
    { 820, 319, -12},
    { 827, 289, -7},
    { 979, 301, 2},
    { 1231, 351, 53},
    { 1197, 406, 29},
    { 1253, 445, 36},
    { 1419, 524, 12},
    { 1002, 483, 10},
    { 1203, 454, 36},
    { 1107, 386, 77},
    { 1004, 333, 81},
    { 871, 287, 97},
    { 797, 257, 101},
    { 784, 233, 127},
    { 817, 200, 162},
    { 790, 190, 133},
    { 892, 194, 157},
    { 1122, 180, 216},
    { 1222, 198, 218},
    { 1403, 248, 216},
    { 1378, 333, 92},
    { 965, 465, -257},
    { 918, 373, -166},
    { 854, 242, -19},
    { 769, 114, 61},
    { 759, 166, 91},
    { 760, 286, 80},
    { 782, 340, 35},
    { 823, 378, 0},
    { 849, 330, 6},
    { 958, 302, 42},
    { 1265, 351, 49},
    { 1220, 433, -1},
    { 1232, 494, -39},
    { 1360, 593, -99},
    { 1191, 468, 95},
    { 1148, 439, 80},
    { 1066, 384, 75},
    { 939, 367, 109},
    { 825, 286, 125},
    { 790, 249, 106},
    { 840, 229, 136},
    { 875, 211, 154},
    { 860, 190, 134},
    { 943, 187, 163},
    { 1099, 165, 222},
    { 1059, 204, 151},
    { 1214, 264, 92},
    { 1215, 302, 122},
    { 961, 375, -104},
    { 992, 383, -117},
    { 925, 317, 14},
    { 856, 250, 30},
    { 798, 234, 45},
    { 761, 275, 56},
    { 795, 297, 40},
    { 819, 312, 22},
    { 786, 301, -14},
    { 836, 319, -31},
    { 1119, 328, 37},
    { 1257, 361, 32},
    { 1244, 450, 21},
    { 1326, 519, 35},
    { 1338, 566, 39},
    { 1258, 476, 54},
    { 1086, 428, 55},
    { 1006, 381, 76},
    { 891, 306, 94},
    { 802, 247, 102},
    { 786, 209, 130},
    { 808, 190, 170},
    { 849, 184, 148},
    { 805, 192, 160},
    { 992, 203, 211},
    { 1177, 186, 234},
    { 1227, 262, 142},
    { 1351, 255, 203},
    { 1120, 343, 50},
    { 929, 424, -161},
    { 938, 334, -27},
    { 941, 300, 32},
    { 842, 228, 58},
    { 782, 280, 16},
    { 779, 330, 3},
    { 838, 338, -20},
    { 798, 332, -66},
    { 817, 341, -77},
    { 1030, 378, -32},
    { 1380, 425, 6},
    { 1157, 417, 49},
    { 1210, 479, 26},
    { 1413, 584, 4},
    { 1103, 435, 86},
    { 1151, 428, 89},
    { 1125, 389, 109},
    { 959, 328, 132},
    { 803, 265, 119},
    { 761, 239, 121},
    { 783, 221, 152},
    { 823, 181, 156},
    { 798, 180, 148},
    { 909, 179, 188},
    { 1130, 160, 255},
    { 1106, 206, 199},
    { 1341, 278, 164},
    { 1369, 334, 141},
    { 997, 453, -150},
    { 940, 377, -99},
    { 888, 329, -27},
    { 798, 233, 1},
    { 752, 247, 24},
    { 752, 289, 30},
    { 817, 321, 32},
    { 869, 321, 6},
    { 829, 353, -62},
    { 866, 365, -72},
    { 1121, 388, -45},
    { 1355, 392, 28},
    { 1328, 433, 9},
    { 1428, 538, -52},
    { 1190, 472, 12},
    { 1191, 402, 46},
    { 1085, 343, 55},
    { 920, 328, 77},
    { 865, 255, 148},
    { 817, 205, 142},
    { 821, 211, 173},
    { 808, 195, 191},
    { 739, 197, 151},
    { 827, 206, 167},
    { 1049, 187, 217},
    { 1125, 208, 171},
    { 1293, 270, 106},
    { 1450, 268, 202},
    { 1059, 385, -66},
    { 939, 460, -196},
    { 902, 354, -24},
    { 885, 250, 26},
    { 821, 178, 48},
    { 755, 238, 63},
    { 780, 311, 31},
    { 837, 360, -5},
    { 843, 335, -28},
    { 900, 323, -15},
    { 1122, 353, 5},
    { 1255, 393, -13},
    { 1237, 410, 38},
    { 1413, 474, 61},
    { 1215, 504, 4},
    { 1125, 468, 12},
    { 1076, 390, 83},
    { 1029, 331, 110},
    { 929, 288, 133},
    { 840, 250, 145},
    { 836, 230, 167},
    { 869, 208, 190},
    { 807, 189, 162},
    { 767, 205, 146},
    { 934, 194, 177},
    { 1122, 191, 192},
    { 1176, 236, 122},
    { 1410, 252, 177},
    { 1191, 318, 41},
    { 994, 485, -234},
    { 917, 362, -60},
    { 908, 283, 16},
    { 823, 206, 25},
    { 774, 253, 35},
    { 789, 287, 30},
    { 843, 305, 27},
    { 870, 306, -20},
    { 799, 311, -50},
    { 931, 332, -39},
    { 1284, 384, -16},
    { 1251, 393, 20},
    { 1283, 465, 16},
    { 1383, 548, -28},
    { 1043, 413, 68},
    { 1086, 393, 79},
    { 1087, 369, 73},
    { 958, 346, 133},
    { 837, 268, 148},
    { 785, 238, 137},
    { 792, 235, 154},
    { 800, 210, 165},
    { 784, 191, 128},
    { 874, 199, 144},
    { 1019, 169, 218},
    { 1132, 193, 186},
    { 1246, 244, 146},
    { 1382, 280, 204},
    { 1117, 381, -7},
    { 926, 468, -190},
    { 956, 363, -35},
    { 879, 247, 26},
    { 864, 190, 35},
    { 788, 253, 56},
    { 766, 307, 24},
    { 793, 337, -4},
    { 796, 321, -25},
    { 792, 309, -34},
    { 940, 331, -25},
    { 1200, 377, -4},
    { 1162, 384, 49},
    { 1185, 432, 46},
    { 1410, 499, 18},
    { 1135, 455, 112},
    { 1184, 450, 66},
    { 1165, 404, 100},
    { 986, 343, 129},
    { 803, 271, 129},
    { 719, 244, 99},
    { 758, 237, 114},
    { 816, 197, 156},
    { 795, 175, 154},
    { 878, 186, 174},
    { 1153, 198, 246},
    { 1056, 200, 218},
    { 1286, 309, 145},
    { 1390, 318, 169},
    { 981, 376, -78},
    { 919, 402, -170},
    { 968, 326, -54},
    { 879, 225, 5},
    { 781, 209, -10},
    { 763, 296, -51},
    { 809, 344, -42},
    { 833, 349, -88},
    { 782, 331, -108},
    { 863, 333, -104},
    { 1206, 394, -19},
    { 1227, 418, 6},
    { 1315, 474, 10},
    { 1411, 556, 31},
    { 1227, 490, 56},
    { 1077, 435, 68},
    { 1082, 383, 98},
    { 931, 324, 161},
    { 774, 255, 169},
    { 713, 235, 155},
    { 786, 229, 174},
    { 857, 215, 196},
    { 809, 201, 176},
    { 853, 218, 146},
    { 972, 223, 202},
    { 1078, 223, 155},
    { 1162, 303, 77},
    { 1332, 299, 175},
    { 1121, 334, 73},
    { 932, 492, -182},
    { 1005, 400, -43},
    { 930, 323, 23},
    { 835, 207, 6},
    { 761, 227, 2},
    { 801, 290, 13},
    { 842, 327, -10},
    { 848, 345, -34},
    { 841, 357, -40},
    { 968, 375, -11},
    { 1190, 397, 0},
    { 1043, 385, 67},
    { 1260, 415, 72},
    { 1329, 463, 86},
    { 1254, 500, 126},
    { 1248, 487, 123},
    { 1141, 418, 165},
    { 902, 334, 153},
    { 734, 284, 132},
    { 771, 275, 115},
    { 864, 248, 173},
    { 942, 188, 265},
    { 894, 213, 243},
    { 948, 258, 244},
    { 1079, 268, 286},
    { 969, 278, 183},
    { 1068, 289, 107},
    { 1310, 292, 108},
    { 811, 391, -173},
    { 943, 364, -144},
    { 919, 285, -52},
    { 933, 240, -22},
    { 858, 246, -43},
    { 757, 281, -60},
    { 774, 302, -46},
    { 847, 288, -42},
    { 878, 310, -39},
    { 951, 357, -26},
    { 1174, 425, 15},
    { 1180, 443, 31},
    { 1152, 450, 52},
    { 1165, 488, 62},
    { 1291, 533, 41},
    { 1239, 511, 70},
    { 1131, 465, 103},
    { 1062, 384, 119},
    { 852, 312, 110},
    { 707, 262, 91},
    { 735, 231, 107},
    { 829, 197, 167},
    { 887, 166, 201},
    { 895, 189, 201},
    { 1044, 211, 248},
    { 1170, 222, 278},
    { 1194, 260, 202},
    { 1200, 265, 125},
    { 1126, 301, 52},
    { 894, 365, -167},
    { 931, 320, -88},
    { 922, 248, -42},
    { 879, 206, -46},
    { 808, 221, -48},
    { 777, 280, -69},
    { 813, 278, -51},
    { 850, 293, -59},
    { 834, 323, -114},
    { 845, 385, -123},
    { 1215, 473, -17},
    { 1204, 414, 46},
    { 1055, 443, 14},
    { 1188, 544, -27},
    { 1317, 588, -4},
    { 1290, 431, 115},
    { 1192, 403, 163},
    { 1105, 375, 161},
    { 893, 367, 124},
    { 770, 293, 115},
    { 778, 251, 123},
    { 821, 198, 176},
    { 850, 154, 178},
    { 783, 176, 153},
    { 890, 197, 162},
    { 1080, 178, 171},
    { 1107, 244, 102},
    { 1218, 238, 137},
    { 1279, 311, 45},
    { 1034, 425, -204},
    { 1010, 339, -40},
    { 898, 278, 28},
    { 839, 194, 57},
    { 769, 226, 70},
    { 774, 296, 90},
    { 833, 339, 78},
    { 882, 382, 46},
    { 859, 367, 32},
    { 953, 356, 29},
    { 1173, 408, -3},
    { 1114, 424, -9},
    { 1162, 429, 13},
    { 1380, 495, 15},
    { 1152, 483, 57},
    { 1160, 494, 34},
    { 1149, 433, 79},
    { 1098, 365, 105},
    { 950, 293, 123},
    { 837, 234, 119},
    { 822, 193, 138},
    { 853, 169, 171},
    { 807, 162, 155},
    { 790, 181, 169},
    { 1024, 166, 247},
    { 1074, 174, 231},
    { 1185, 257, 112},
    { 1371, 252, 195},
    { 1042, 327, 5},
    { 1045, 432, -158},
    { 1037, 350, -3},
    { 933, 303, 14},
    { 814, 239, -13},
    { 743, 285, -18},
    { 804, 302, -20},
    { 876, 288, -11},
    { 870, 299, -27},
    { 866, 341, -34},
    { 1084, 407, -14},
    { 1279, 429, 6},
    { 1275, 451, 50},
    { 1407, 512, 49},
    { 1135, 513, 24},
    { 1207, 464, 28},
    { 1157, 391, 92},
    { 1048, 335, 111},
    { 869, 259, 128},
    { 774, 217, 130},
    { 790, 209, 146},
    { 836, 183, 179},
    { 808, 165, 166},
    { 853, 179, 176},
    { 1057, 158, 253},
    { 1152, 182, 263},
    { 1297, 265, 220},
    { 1381, 305, 159},
    { 992, 472, -207},
    { 988, 430, -144},
    { 962, 297, -8},
    { 845, 170, 28},
    { 765, 217, 25},
    { 745, 303, -6},
    { 784, 316, 0},
    { 804, 296, -20},
    { 788, 312, -44},
    { 918, 333, -11},
    { 1212, 394, 10},
    { 1250, 436, 20},
    { 1297, 476, 36},
    { 1454, 534, 36},
    { 1076, 481, 18},
    { 1067, 433, 34},
    { 1047, 381, 45},
    { 983, 361, 63},
    { 935, 272, 122},
    { 838, 238, 132},
    { 838, 221, 144},
    { 858, 201, 168},
    { 817, 186, 161},
    { 752, 190, 152},
    { 898, 178, 213},
    { 1141, 172, 232},
    { 1160, 245, 140},
    { 1291, 238, 166},
    { 1244, 335, 74},
    { 985, 463, -221},
    { 983, 390, -74},
    { 939, 293, 28},
    { 851, 202, 31},
    { 785, 237, 23},
    { 765, 274, 34},
    { 808, 300, 13},
    { 816, 291, 3},
    { 791, 313, 0},
    { 935, 358, 4},
    { 1275, 422, 20},
    { 1199, 413, 38},
    { 1283, 443, 51},
    { 1384, 504, 20},
    { 1187, 430, 86},
    { 1112, 406, 70},
    { 1066, 361, 97},
    { 876, 318, 93},
    { 744, 260, 102},
    { 733, 222, 97},
    { 782, 208, 135},
    { 851, 186, 155},
    { 815, 187, 154},
    { 914, 212, 186},
    { 1187, 211, 256},
    { 1187, 281, 202},
    { 1370, 294, 195},
    { 1219, 334, 89},
    { 902, 481, -215},
    { 926, 374, -49},
    { 937, 268, 15},
    { 833, 177, 2},
    { 720, 231, -3},
    { 702, 276, 3},
    { 799, 279, 16},
    { 863, 265, 16},
    { 829, 302, -20},
    { 920, 360, -20},
    { 1168, 422, -4},
    { 1154, 417, -10},
    { 1283, 434, 68},
    { 1462, 544, -31},
    { 1133, 439, 97},
    { 1187, 433, 86},
    { 1084, 380, 92},
    { 900, 326, 90},
    { 791, 256, 101},
    { 769, 212, 110},
    { 789, 220, 109},
    { 819, 206, 120},
    { 729, 194, 99},
    { 865, 198, 117},
    { 1049, 202, 143},
    { 1068, 234, 107},
    { 1286, 266, 117},
    { 1477, 316, 111},
    { 914, 440, -163},
    { 981, 397, -56},
    { 985, 304, 58},
    { 904, 220, 78},
    { 814, 245, 74},
    { 737, 291, 64},
    { 729, 312, 27},
    { 736, 315, -4},
    { 737, 326, -31},
    { 922, 352, -5},
    { 1281, 403, -9},
    { 1156, 446, 4},
    { 1306, 481, -8},
    { 1416, 545, -5},
    { 1222, 431, 85},
    { 1124, 419, 57},
    { 1098, 396, 84},
    { 937, 374, 106},
    { 806, 277, 137},
    { 731, 212, 145},
    { 769, 207, 147},
    { 858, 206, 162},
    { 828, 193, 152},
    { 862, 187, 168},
    { 1044, 185, 220},
    { 1140, 203, 187},
    { 1263, 283, 135},
    { 1457, 303, 189},
    { 937, 388, -71},
    { 886, 416, -161},
    { 995, 344, -2},
    { 876, 224, 49},
    { 787, 203, 35},
    { 757, 271, 32},
    { 790, 327, 24},
    { 841, 327, 1},
    { 836, 316, -35},
    { 850, 351, -62},
    { 1037, 365, -31},
    { 1217, 398, -36},
    { 1159, 410, 20},
    { 1272, 475, 41},
    { 1351, 537, 7},
    { 1204, 467, 44},
    { 1182, 448, 67},
    { 1111, 395, 101},
    { 910, 296, 118},
    { 762, 235, 114},
    { 769, 223, 109},
    { 806, 205, 151},
    { 826, 175, 157},
    { 756, 182, 149},
    { 896, 188, 177},
    { 1111, 186, 203},
    { 1104, 281, 100},
    { 1302, 291, 121},
    { 1263, 309, 76},
    { 962, 427, -178},
    { 993, 355, -23},
    { 996, 318, 0},
    { 861, 253, 0},
    { 783, 265, 16},
    { 760, 293, 14},
    { 814, 317, -5},
    { 835, 340, -42},
    { 824, 345, -47},
    { 934, 364, -41},
    { 1188, 406, -32},
    { 1101, 401, 30},
    { 1234, 443, 45},
    { 1550, 523, 14},
    { 1084, 472, 97},
    { 1185, 437, 108},
    { 1149, 398, 90},
    { 1021, 323, 141},
    { 844, 252, 153},
    { 797, 223, 127},
    { 828, 222, 142},
    { 831, 191, 151},
    { 768, 178, 108},
    { 869, 186, 132},
    { 1057, 162, 207},
    { 1019, 178, 143},
    { 1148, 253, 100},
    { 1450, 303, 149},
    { 966, 385, -69},
    { 1017, 417, -101},
    { 976, 307, 72},
    { 881, 256, 75},
    { 816, 237, 68},
    { 794, 294, 76},
    { 774, 326, 45},
    { 834, 326, 39},
    { 838, 332, -14},
    { 862, 341, -2},
    { 1097, 395, -14},
    { 1217, 431, -6},
    { 1278, 446, 29},
    { 1370, 510, 43},
    { 1277, 530, 22},
    { 1171, 471, 59},
    { 1055, 410, 76},
    { 1027, 381, 88},
    { 956, 305, 127},
    { 853, 237, 157},
    { 806, 192, 167},
    { 817, 191, 186},
    { 804, 181, 173},
    { 753, 184, 167},
    { 920, 183, 195},
    { 1162, 181, 236},
    { 1197, 221, 185},
    { 1381, 248, 218},
    { 1242, 310, 116},
    { 926, 450, -186},
    { 903, 348, -63},
    { 949, 273, 50},
    { 860, 182, 59},
    { 837, 253, 60},
    { 827, 334, 53},
    { 848, 369, 22},
    { 851, 350, -8},
    { 816, 351, -46},
    { 934, 359, -36},
    { 1233, 415, -24},
    { 1157, 436, -17},
    { 1219, 471, 7},
    { 1479, 594, -46},
    { 1157, 447, 79},
    { 1205, 429, 72},
    { 1167, 375, 97},
    { 994, 344, 126},
    { 845, 260, 148},
    { 768, 208, 157},
    { 792, 204, 159},
    { 814, 171, 169},
    { 743, 162, 152},
    { 823, 160, 172},
    { 1013, 145, 228},
    { 1048, 171, 178},
    { 1224, 244, 136},
    { 1500, 269, 194},
    { 1130, 386, -87},
    { 1071, 450, -187},
    { 1022, 354, -24},
    { 863, 226, 14},
    { 795, 195, 17},
    { 756, 262, 33},
    { 763, 306, 30},
    { 840, 329, 18},
    { 871, 331, -16},
    { 887, 354, -36},
    { 1010, 375, -47},
    { 1204, 417, -61},
    { 1257, 407, 23},
    { 1336, 469, 22},
    { 1347, 539, -16},
    { 1254, 464, 57},
    { 1131, 416, 83},
    { 1080, 354, 95},
    { 933, 304, 142},
    { 813, 233, 155},
    { 813, 200, 154},
    { 829, 193, 171},
    { 809, 182, 163},
    { 772, 180, 150},
    { 899, 170, 186},
    { 1120, 158, 218},
    { 1142, 219, 146},
    { 1222, 256, 138},
    { 1419, 304, 160},
    { 1003, 431, -140},
    { 925, 380, -97},
    { 973, 337, 28},
    { 861, 210, 47},
    { 813, 212, 29},
    { 797, 279, 63},
    { 842, 338, 37},
    { 862, 381, -3},
    { 826, 360, -35},
    { 930, 360, -8},
    { 1238, 401, 6},
    { 1178, 395, 24},
    { 1182, 435, 19},
    { 1334, 504, 22},
    { 1099, 485, 22},
    { 1103, 471, 23},
    { 1146, 422, 78},
    { 1098, 338, 154},
    { 949, 262, 171},
    { 842, 208, 156},
    { 820, 203, 164},
    { 794, 196, 193},
    { 779, 176, 165},
    { 846, 176, 185},
    { 1086, 151, 240},
    { 1155, 164, 237},
    { 1298, 241, 219},
    { 1396, 291, 184},
    { 980, 467, -197},
    { 1006, 405, -124},
    { 964, 286, 56},
    { 839, 140, 68},
    { 801, 187, 49},
    { 770, 286, 60},
    { 804, 348, 23},
    { 815, 363, -24},
    { 845, 354, -49},
    { 958, 354, -41},
    { 1195, 383, -40},
    { 1214, 400, 8},
    { 1292, 431, 49},
    { 1443, 517, -45},
    { 1058, 425, 63},
    { 1211, 412, 102},
    { 1109, 350, 88},
    { 975, 312, 123},
    { 821, 242, 146},
    { 768, 220, 129},
    { 793, 204, 134},
    { 795, 172, 153},
    { 770, 164, 129},
    { 902, 156, 166},
    { 1174, 153, 221},
    { 1145, 183, 173},
    { 1239, 254, 151},
    { 1374, 314, 131},
    { 961, 408, -105},
    { 996, 392, -85},
    { 958, 308, 24},
    { 825, 217, 37},
    { 770, 209, 32},
    { 743, 267, 52},
    { 790, 331, 33},
    { 854, 351, 21},
    { 878, 353, -13},
    { 973, 379, -22},
    { 1224, 437, -57},
    { 1235, 446, -55},
    { 1295, 439, -5},
    { 1475, 501, -44},
    { 1112, 389, 65},
    { 1126, 404, 42},
    { 1118, 374, 70},
    { 1005, 311, 135},
    { 833, 220, 157},
    { 762, 183, 152},
    { 788, 199, 159},
    { 810, 179, 169},
    { 750, 165, 153},
    { 878, 176, 158},
    { 1130, 151, 243},
    { 1178, 166, 219},
    { 1332, 251, 188},
    { 1311, 299, 119},
    { 1013, 501, -233},
    { 985, 365, -84},
    { 960, 252, 62},
    { 822, 137, 62},
    { 742, 213, 37},
    { 709, 330, 24},
    { 775, 367, -4},
    { 808, 373, -41},
    { 892, 380, -45},
    { 1117, 436, -18},
    { 1275, 544, -48},
    { 1309, 501, 3},
    { 1482, 576, 9},
    { 1224, 469, 30},
    { 1243, 398, 107},
    { 1154, 362, 115},
    { 1025, 367, 112},
    { 878, 278, 155},
    { 758, 226, 163},
    { 749, 180, 174},
    { 753, 160, 190},
    { 760, 159, 171},
    { 814, 160, 189},
    { 963, 150, 252},
    { 1151, 182, 236},
    { 1217, 267, 157},
    { 1339, 254, 201},
    { 1138, 327, 34},
    { 1090, 449, -171},
    { 1062, 353, -26},
    { 944, 272, 35},
    { 803, 214, 39},
    { 764, 261, 21},
    { 738, 316, 12},
    { 754, 345, -30},
    { 805, 347, -44},
    { 964, 381, -29},
    { 1189, 444, -42},
    { 1113, 485, -51},
    { 1172, 458, -21},
    { 1395, 567, -37},
    { 1446, 479, 150},
    { 1377, 450, 144},
    { 1270, 409, 132},
    { 1083, 333, 179},
    { 807, 245, 159},
    { 726, 208, 120},
    { 774, 194, 159},
    { 812, 145, 181},
    { 734, 115, 170},
    { 818, 124, 176},
    { 1025, 127, 214},
    { 1056, 170, 173},
    { 1286, 263, 121},
    { 1464, 297, 154},
    { 1141, 471, -139},
    { 1090, 433, -58},
    { 1043, 361, 59},
    { 852, 292, 23},
    { 753, 287, 18},
    { 742, 321, 39},
    { 795, 340, 33},
    { 874, 335, 14},
    { 844, 352, -15},
    { 873, 367, -7},
    { 1153, 436, -37},
    { 1259, 422, -19},
    { 1415, 468, 29},
    { 1525, 524, 0},
    { 1304, 427, 82},
    { 1157, 397, 73},
    { 1114, 367, 75},
    { 965, 284, 129},
    { 849, 214, 159},
    { 787, 153, 169},
    { 780, 160, 178},
    { 769, 154, 171},
    { 730, 161, 152},
    { 827, 169, 186},
    { 1097, 156, 234},
    { 1056, 173, 181},
    { 1257, 236, 154},
    { 1594, 273, 256},
    { 1030, 402, -71},
    { 1043, 465, -156},
    { 980, 381, 19},
    { 870, 250, 33},
    { 802, 157, 16},
    { 787, 252, 55},
    { 792, 338, 4},
    { 788, 376, -54},
    { 763, 373, -89},
    { 931, 388, -43},
    { 1268, 417, -34},
    { 1202, 388, 40},
    { 1435, 475, 17},
    { 1466, 527, -20},
    { 1280, 425, 132},
    { 1190, 395, 114},
    { 1083, 368, 129},
    { 905, 299, 173},
    { 758, 223, 166},
    { 759, 192, 169},
    { 830, 175, 200},
    { 848, 152, 217},
    { 786, 152, 197},
    { 857, 158, 223},
    { 1086, 149, 276},
    { 1083, 217, 207},
    { 1156, 251, 165},
    { 1520, 327, 171},
    { 1086, 429, -88},
    { 1085, 466, -143},
    { 942, 343, -13},
    { 835, 248, -22},
    { 801, 213, -40},
    { 791, 267, -17},
    { 802, 300, -20},
    { 837, 337, -41},
    { 822, 343, -61},
    { 915, 347, -40},
    { 1198, 380, -5},
    { 1159, 353, 52},
    { 1273, 406, 53},
    { 1464, 462, 42},
    { 1278, 474, 112},
    { 1159, 426, 116},
    { 1148, 401, 124},
    { 985, 317, 187},
    { 784, 239, 184},
    { 703, 191, 148},
    { 769, 205, 158},
    { 867, 186, 210},
    { 837, 145, 222},
    { 884, 172, 223},
    { 1062, 186, 265},
    { 1089, 210, 221},
    { 1130, 262, 151},
    { 1572, 272, 229},
    { 1021, 322, -33},
    { 987, 472, -218},
    { 928, 341, -42},
    { 881, 245, 11},
    { 828, 188, -38},
    { 793, 255, -20},
    { 832, 314, -5},
    { 893, 344, -25},
    { 875, 335, -18},
    { 836, 316, -21},
    { 1029, 346, 0},
    { 1216, 363, 22},
    { 1166, 358, 71},
    { 1403, 438, 75},
    { 1361, 480, 61},
    { 1199, 401, 135},
    { 1104, 360, 148},
    { 1070, 339, 160},
    { 914, 264, 198},
    { 763, 223, 175},
    { 763, 206, 172},
    { 835, 198, 216},
    { 831, 162, 238},
    { 786, 174, 223},
    { 903, 190, 242},
    { 1065, 186, 273},
    { 1202, 227, 241},
    { 1368, 260, 235},
    { 1366, 312, 136},
    { 1031, 488, -231},
    { 910, 428, -176},
    { 905, 340, -95},
    { 878, 258, -80},
    { 838, 287, -51},
    { 779, 350, -40},
    { 805, 348, -8},
    { 828, 349, -5},
    { 816, 335, -6},
    { 837, 319, -12},
    { 896, 299, 12},
    { 1033, 301, 30},
    { 936, 309, 45},
    { 1190, 381, 78},
    { 1649, 449, 133},
    { 1451, 458, 262},
    { 1233, 464, 150},
    { 1176, 475, 171},
    { 1013, 512, 198},
    { 882, 472, 215},
    { 832, 488, 251},
    { 869, 564, 266},
    { 851, 679, 255},
    { 880, 767, 142},
    { 780, 836, 136},
    { 640, 936, -19},
    { 593, 890, -255},
    { 533, 832, -394},
    { 502, 571, -529},
    { 419, 411, -538},
    { 347, 179, -609},
    { 329, 169, -690},
    { 256, 24, -740},
    { 218, 1, -771},
    { 195, -78, -784},
    { 171, -95, -779},
    { 169, -96, -880},
    { 228, -177, -908},
    { 228, -194, -906},
    { 246, -199, -960},
    { 213, -206, -945},
    { 203, -225, -912},
    { 203, -226, -926},
    { 155, -229, -980},
    { 145, -244, -976},
    { 148, -260, -953},
    { 144, -252, -962},
    { 131, -267, -964},
    { 83, -283, -937},
    { 70, -267, -897},
    { 65, -273, -908},
    { 54, -289, -904},
    { 76, -286, -903},
    { 95, -310, -895},
    { 90, -311, -915},
    { 84, -315, -921},
    { 73, -319, -893},
    { 60, -320, -915},
    { 50, -312, -921},
    { 50, -300, -933},
    { 69, -300, -927},
    { 61, -298, -926},
    { 54, -305, -913},
    { 41, -302, -914},
    { 38, -289, -931},
    { 23, -291, -940},
    { 19, -291, -936},
    { 21, -294, -940},
    { 25, -294, -937},
    { 34, -290, -930},
    { 40, -289, -923},
    { 37, -285, -917},
    { 38, -298, -921},
    { 34, -285, -925},
    { 33, -290, -925},
    { 33, -283, -927},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



// ----------------------------------------------------------------
// Sample captured: 2015-08-11 22:02:59 GMT
AccelRawData *activity_sample_200_steps(int *len) {
  //> TEST_NAME walk_200
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 190
  //> TEST_EXPECTED_MAX 210
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    { 163, -135, -713},
    { 194, -165, -807},
    { 151, -216, -875},
    { 143, -209, -962},
    { 118, -221, -1115},
    { 7, -133, -1185},
    { -112, -205, -1217},
    { 161, 2, -1353},
    { 179, 179, -1211},
    { -46, 221, -1063},
    { 105, -202, -799},
    { 447, -95, -752},
    { 220, -114, -713},
    { 149, -153, -660},
    { 151, -138, -645},
    { 175, -172, -624},
    { 182, -175, -576},
    { 174, -113, -421},
    { 430, -76, -424},
    { 960, 15, -298},
    { 1227, 234, 61},
    { 1914, 447, 294},
    { 2135, 755, 93},
    { 1923, 972, -61},
    { 1097, 990, 152},
    { 852, 370, 184},
    { 949, 223, 218},
    { 934, 305, 159},
    { 968, 359, 173},
    { 924, 295, 252},
    { 926, 396, 127},
    { 784, 488, -7},
    { 801, 520, -81},
    { 919, 575, -146},
    { 1035, 563, -110},
    { 1114, 489, 30},
    { 1096, 329, 121},
    { 1200, 412, 75},
    { 1292, 485, 109},
    { 1388, 494, 213},
    { 1132, 381, 241},
    { 965, 267, 251},
    { 901, 155, 261},
    { 877, 125, 257},
    { 812, 137, 236},
    { 929, 162, 236},
    { 1084, 177, 279},
    { 1084, 195, 247},
    { 1197, 233, 166},
    { 1334, 241, 204},
    { 1036, 325, -77},
    { 1147, 380, -89},
    { 1068, 293, 72},
    { 970, 284, 91},
    { 864, 280, 51},
    { 830, 341, 30},
    { 853, 378, 34},
    { 899, 394, 2},
    { 958, 358, -3},
    { 1026, 386, -12},
    { 1180, 458, -44},
    { 1140, 518, -11},
    { 1183, 491, 29},
    { 1266, 536, -31},
    { 1307, 510, 76},
    { 1361, 478, 153},
    { 1240, 403, 152},
    { 1135, 354, 155},
    { 977, 257, 201},
    { 883, 200, 203},
    { 838, 160, 207},
    { 804, 149, 209},
    { 805, 157, 210},
    { 942, 144, 277},
    { 1129, 147, 324},
    { 1119, 218, 236},
    { 1232, 268, 162},
    { 1130, 317, 25},
    { 1105, 463, -152},
    { 1127, 356, 25},
    { 1042, 295, 88},
    { 893, 274, 46},
    { 869, 286, 5},
    { 912, 380, 9},
    { 1008, 398, 53},
    { 1087, 378, 24},
    { 933, 401, -51},
    { 907, 427, -23},
    { 1048, 484, -34},
    { 1080, 543, -30},
    { 1244, 602, -3},
    { 1101, 567, 90},
    { 1250, 444, 149},
    { 1222, 456, 116},
    { 1274, 470, 149},
    { 1057, 332, 195},
    { 862, 235, 201},
    { 840, 156, 206},
    { 869, 136, 247},
    { 856, 145, 241},
    { 907, 175, 239},
    { 1091, 176, 309},
    { 1121, 205, 302},
    { 1145, 246, 180},
    { 1334, 262, 156},
    { 1079, 362, -133},
    { 1050, 418, -161},
    { 1033, 327, -74},
    { 906, 237, -10},
    { 866, 217, 4},
    { 858, 306, -17},
    { 851, 321, 13},
    { 880, 377, -5},
    { 854, 360, -34},
    { 838, 346, -16},
    { 1027, 364, -8},
    { 1190, 419, -15},
    { 1096, 440, 36},
    { 1308, 537, 25},
    { 1372, 679, 37},
    { 1420, 443, 211},
    { 1298, 452, 147},
    { 1268, 387, 155},
    { 1058, 318, 180},
    { 882, 225, 181},
    { 839, 186, 159},
    { 869, 171, 190},
    { 814, 152, 199},
    { 877, 131, 228},
    { 1012, 105, 277},
    { 1006, 122, 279},
    { 1129, 221, 183},
    { 1265, 276, 118},
    { 1189, 456, -216},
    { 1262, 506, -200},
    { 1026, 356, 28},
    { 828, 215, 108},
    { 917, 240, 50},
    { 889, 346, 52},
    { 854, 390, 83},
    { 852, 407, 22},
    { 858, 379, 14},
    { 941, 389, -2},
    { 1124, 419, -42},
    { 1227, 519, -97},
    { 1206, 516, -25},
    { 1393, 508, 0},
    { 1185, 458, 41},
    { 1274, 460, 73},
    { 1226, 446, 96},
    { 1171, 418, 124},
    { 1060, 313, 176},
    { 914, 220, 206},
    { 843, 159, 213},
    { 832, 157, 196},
    { 771, 166, 169},
    { 833, 172, 184},
    { 1067, 144, 277},
    { 1038, 128, 287},
    { 1152, 233, 157},
    { 1300, 256, 119},
    { 1062, 367, -154},
    { 1083, 389, -127},
    { 1071, 318, -27},
    { 962, 275, 26},
    { 929, 282, 29},
    { 931, 347, 28},
    { 920, 396, 21},
    { 942, 403, 12},
    { 939, 369, -1},
    { 950, 352, -32},
    { 1008, 408, -66},
    { 1057, 478, -76},
    { 1174, 510, -23},
    { 1346, 597, -14},
    { 1173, 530, 120},
    { 1168, 462, 103},
    { 1046, 402, 115},
    { 1027, 374, 152},
    { 1077, 323, 172},
    { 896, 263, 176},
    { 848, 196, 191},
    { 866, 148, 221},
    { 854, 138, 217},
    { 871, 166, 218},
    { 1059, 163, 284},
    { 1072, 188, 244},
    { 1120, 244, 126},
    { 1446, 259, 167},
    { 1054, 359, -112},
    { 1073, 410, -197},
    { 1042, 349, -99},
    { 894, 268, 0},
    { 839, 224, 26},
    { 827, 262, 14},
    { 831, 336, 42},
    { 866, 374, 33},
    { 878, 367, 25},
    { 901, 352, 10},
    { 1058, 368, 9},
    { 1166, 434, -49},
    { 1163, 449, -4},
    { 1412, 496, 16},
    { 1230, 546, 6},
    { 1365, 417, 134},
    { 1174, 421, 96},
    { 1057, 365, 89},
    { 931, 332, 125},
    { 839, 251, 152},
    { 815, 184, 162},
    { 825, 152, 185},
    { 763, 158, 150},
    { 812, 177, 164},
    { 1019, 162, 246},
    { 1049, 169, 219},
    { 1184, 260, 114},
    { 1400, 268, 141},
    { 1073, 375, -61},
    { 1169, 415, -140},
    { 1012, 257, 32},
    { 857, 216, 65},
    { 774, 231, 54},
    { 780, 280, 67},
    { 786, 354, 49},
    { 868, 376, 24},
    { 857, 388, -16},
    { 937, 393, -34},
    { 1182, 437, -32},
    { 1205, 482, -22},
    { 1213, 476, -6},
    { 1383, 588, -46},
    { 1249, 502, 66},
    { 1218, 468, 84},
    { 1227, 427, 110},
    { 1114, 355, 166},
    { 950, 290, 162},
    { 871, 234, 157},
    { 862, 203, 185},
    { 880, 188, 204},
    { 749, 150, 177},
    { 827, 160, 172},
    { 989, 140, 226},
    { 1001, 161, 204},
    { 1125, 226, 109},
    { 1373, 245, 146},
    { 1111, 342, -13},
    { 1195, 466, -164},
    { 1076, 304, 65},
    { 946, 272, 111},
    { 828, 234, 69},
    { 778, 278, 52},
    { 776, 340, 68},
    { 851, 380, 45},
    { 867, 376, 8},
    { 962, 389, -5},
    { 1126, 446, -29},
    { 1226, 534, -46},
    { 1241, 509, 15},
    { 1455, 534, 12},
    { 1208, 484, 42},
    { 1196, 479, 57},
    { 1189, 407, 114},
    { 1074, 374, 125},
    { 972, 292, 155},
    { 879, 228, 183},
    { 844, 180, 200},
    { 849, 164, 209},
    { 799, 167, 185},
    { 813, 174, 178},
    { 1017, 161, 239},
    { 1108, 141, 264},
    { 1184, 228, 156},
    { 1416, 250, 195},
    { 1095, 391, -153},
    { 1032, 457, -226},
    { 974, 325, -35},
    { 877, 236, 64},
    { 886, 229, 45},
    { 857, 329, 29},
    { 843, 425, 17},
    { 890, 438, -8},
    { 912, 374, -10},
    { 949, 335, -33},
    { 1050, 360, -41},
    { 1119, 450, -49},
    { 1194, 490, -19},
    { 1341, 562, 1},
    { 1221, 558, 95},
    { 1220, 444, 116},
    { 1074, 426, 109},
    { 1044, 392, 147},
    { 992, 348, 164},
    { 877, 270, 182},
    { 834, 192, 205},
    { 882, 151, 225},
    { 912, 150, 207},
    { 906, 167, 224},
    { 1052, 169, 299},
    { 1132, 182, 296},
    { 1110, 246, 160},
    { 1282, 280, 117},
    { 1046, 336, -96},
    { 995, 363, -140},
    { 1069, 287, -59},
    { 976, 234, 23},
    { 886, 265, 48},
    { 909, 314, 24},
    { 901, 372, 43},
    { 920, 367, 61},
    { 930, 327, 58},
    { 867, 315, 39},
    { 870, 387, -40},
    { 1039, 450, -67},
    { 1144, 483, -56},
    { 1401, 557, -5},
    { 1226, 609, 21},
    { 1281, 417, 106},
    { 1138, 434, 87},
    { 1104, 440, 80},
    { 1059, 376, 150},
    { 883, 259, 189},
    { 821, 201, 177},
    { 857, 188, 200},
    { 913, 184, 222},
    { 881, 175, 222},
    { 1003, 176, 278},
    { 1097, 142, 305},
    { 1141, 231, 166},
    { 1212, 219, 140},
    { 1036, 292, 11},
    { 973, 342, -157},
    { 1090, 297, -69},
    { 1030, 280, -20},
    { 848, 296, 10},
    { 794, 310, -16},
    { 802, 358, -24},
    { 831, 340, -3},
    { 829, 344, -75},
    { 821, 342, -85},
    { 1147, 406, -32},
    { 1321, 536, -56},
    { 1273, 601, -14},
    { 1384, 617, -47},
    { 1330, 516, 52},
    { 1295, 440, 114},
    { 1236, 402, 144},
    { 1064, 353, 185},
    { 879, 312, 158},
    { 778, 254, 163},
    { 793, 220, 188},
    { 862, 193, 222},
    { 850, 166, 214},
    { 809, 163, 192},
    { 914, 155, 236},
    { 1092, 144, 269},
    { 1109, 239, 152},
    { 1150, 246, 105},
    { 1259, 312, 93},
    { 1050, 396, -71},
    { 1147, 411, -53},
    { 1124, 401, 40},
    { 913, 372, 53},
    { 815, 304, 2},
    { 821, 312, 38},
    { 876, 353, 18},
    { 894, 363, -26},
    { 905, 376, -56},
    { 993, 395, -65},
    { 1119, 492, -87},
    { 1019, 456, -20},
    { 1151, 451, 43},
    { 1480, 541, 46},
    { 1311, 502, 165},
    { 1146, 463, 158},
    { 1212, 416, 178},
    { 1180, 380, 218},
    { 967, 259, 237},
    { 825, 195, 196},
    { 817, 173, 202},
    { 860, 158, 222},
    { 768, 154, 212},
    { 872, 158, 227},
    { 1037, 137, 273},
    { 1001, 210, 178},
    { 1179, 272, 100},
    { 1349, 278, 107},
    { 1114, 442, -168},
    { 1188, 391, -101},
    { 1101, 297, 59},
    { 909, 260, 43},
    { 834, 255, 1},
    { 787, 357, 26},
    { 830, 383, 25},
    { 869, 388, -25},
    { 837, 383, -53},
    { 992, 361, -28},
    { 1243, 411, 7},
    { 1146, 419, 18},
    { 1153, 451, -21},
    { 1321, 524, -9},
    { 1178, 557, 19},
    { 1303, 431, 145},
    { 1245, 397, 170},
    { 1082, 359, 169},
    { 922, 319, 171},
    { 846, 243, 196},
    { 838, 216, 201},
    { 895, 193, 189},
    { 859, 178, 167},
    { 801, 154, 166},
    { 846, 135, 206},
    { 966, 145, 198},
    { 1065, 235, 97},
    { 1160, 266, 98},
    { 1344, 324, 83},
    { 1133, 455, -122},
    { 1121, 422, -29},
    { 1057, 331, 78},
    { 929, 296, 43},
    { 845, 263, 42},
    { 777, 318, 29},
    { 794, 321, 44},
    { 836, 368, -17},
    { 790, 366, -48},
    { 950, 392, -54},
    { 1210, 465, -54},
    { 1151, 464, -48},
    { 1167, 425, -2},
    { 1384, 519, 5},
    { 1294, 529, 80},
    { 1235, 476, 76},
    { 1258, 417, 124},
    { 1119, 395, 156},
    { 968, 313, 160},
    { 854, 235, 166},
    { 839, 183, 199},
    { 919, 167, 227},
    { 844, 160, 215},
    { 790, 186, 187},
    { 891, 187, 209},
    { 948, 177, 210},
    { 1095, 252, 96},
    { 1273, 265, 98},
    { 1084, 334, -58},
    { 1080, 405, -189},
    { 1019, 298, -23},
    { 931, 214, 62},
    { 926, 239, 40},
    { 868, 289, 10},
    { 826, 348, 23},
    { 872, 369, 7},
    { 941, 358, 1},
    { 949, 333, 4},
    { 1040, 345, -11},
    { 1230, 411, -23},
    { 1079, 419, 2},
    { 1140, 436, -24},
    { 1261, 478, 0},
    { 1033, 547, -15},
    { 1248, 524, 96},
    { 1195, 459, 135},
    { 1162, 341, 170},
    { 1026, 300, 163},
    { 917, 257, 167},
    { 889, 231, 176},
    { 893, 189, 182},
    { 843, 177, 165},
    { 886, 170, 192},
    { 1042, 151, 243},
    { 994, 140, 219},
    { 1205, 215, 156},
    { 1193, 274, 69},
    { 1069, 453, -310},
    { 1052, 355, -200},
    { 924, 215, -9},
    { 827, 172, 90},
    { 868, 221, 91},
    { 876, 350, 79},
    { 878, 450, 53},
    { 864, 455, 0},
    { 778, 421, -18},
    { 873, 353, -6},
    { 1240, 343, 24},
    { 1208, 370, 27},
    { 1240, 465, -35},
    { 1359, 615, -101},
    { 1243, 544, 19},
    { 1270, 439, 83},
    { 1241, 399, 103},
    { 1100, 360, 140},
    { 947, 310, 163},
    { 874, 242, 172},
    { 855, 198, 201},
    { 886, 183, 212},
    { 814, 175, 175},
    { 788, 174, 183},
    { 915, 149, 238},
    { 1039, 154, 232},
    { 1115, 232, 126},
    { 1322, 256, 143},
    { 1123, 323, 18},
    { 1127, 478, -186},
    { 1072, 365, 22},
    { 1046, 270, 133},
    { 934, 259, 72},
    { 871, 283, 77},
    { 809, 346, 104},
    { 836, 384, 92},
    { 845, 409, 25},
    { 812, 422, -58},
    { 932, 419, -48},
    { 1207, 435, -24},
    { 1132, 404, -6},
    { 1168, 454, -12},
    { 1345, 552, -5},
    { 1170, 524, 61},
    { 1141, 457, 77},
    { 1179, 438, 104},
    { 1176, 391, 182},
    { 1044, 292, 213},
    { 896, 225, 196},
    { 868, 191, 194},
    { 873, 186, 215},
    { 807, 177, 192},
    { 750, 184, 176},
    { 888, 180, 212},
    { 1064, 170, 216},
    { 1127, 233, 121},
    { 1279, 254, 118},
    { 1185, 296, 21},
    { 1034, 437, -183},
    { 1064, 365, -71},
    { 1007, 305, 24},
    { 919, 275, 28},
    { 873, 277, 43},
    { 824, 324, 46},
    { 842, 354, 23},
    { 875, 356, -20},
    { 816, 349, -31},
    { 963, 337, -19},
    { 1214, 377, 0},
    { 1162, 420, 24},
    { 1247, 470, 2},
    { 1455, 548, -18},
    { 1138, 466, 68},
    { 1123, 399, 102},
    { 1134, 393, 79},
    { 1059, 382, 129},
    { 973, 291, 180},
    { 847, 237, 175},
    { 803, 202, 182},
    { 850, 190, 198},
    { 829, 178, 184},
    { 802, 181, 176},
    { 912, 164, 238},
    { 1037, 153, 246},
    { 1083, 242, 123},
    { 1102, 265, 76},
    { 1322, 304, 114},
    { 1046, 359, -82},
    { 1055, 376, -100},
    { 1045, 337, 6},
    { 957, 322, 10},
    { 876, 257, 36},
    { 807, 282, 42},
    { 809, 305, 38},
    { 881, 322, 38},
    { 875, 328, 6},
    { 853, 355, -54},
    { 991, 391, -74},
    { 1254, 424, -71},
    { 1242, 384, 4},
    { 1367, 441, 28},
    { 1317, 564, -21},
    { 1200, 494, 75},
    { 1159, 481, 64},
    { 1163, 369, 175},
    { 996, 301, 175},
    { 858, 224, 163},
    { 804, 208, 164},
    { 849, 197, 194},
    { 816, 168, 191},
    { 810, 162, 191},
    { 938, 145, 243},
    { 1095, 144, 270},
    { 1142, 202, 215},
    { 1344, 257, 166},
    { 1182, 348, -65},
    { 1025, 435, -195},
    { 1015, 360, -108},
    { 969, 259, -9},
    { 893, 218, 12},
    { 909, 245, -5},
    { 856, 389, 7},
    { 900, 374, -3},
    { 898, 352, -17},
    { 819, 333, -48},
    { 888, 328, -57},
    { 1161, 381, 6},
    { 1195, 399, -2},
    { 1145, 451, 35},
    { 1385, 578, 12},
    { 1063, 503, 75},
    { 1170, 450, 67},
    { 1162, 401, 112},
    { 1094, 371, 145},
    { 1012, 277, 160},
    { 852, 221, 156},
    { 800, 194, 151},
    { 850, 189, 172},
    { 822, 173, 155},
    { 879, 181, 152},
    { 998, 152, 221},
    { 1090, 145, 222},
    { 1172, 209, 163},
    { 1316, 262, 151},
    { 1177, 357, 2},
    { 1003, 439, -183},
    { 971, 321, -28},
    { 922, 244, 72},
    { 860, 215, 77},
    { 881, 251, 65},
    { 831, 331, 77},
    { 814, 379, 25},
    { 832, 383, -24},
    { 833, 359, -38},
    { 975, 340, -34},
    { 1226, 360, -5},
    { 1189, 386, 18},
    { 1232, 433, 33},
    { 1392, 533, -27},
    { 1118, 457, 81},
    { 1181, 447, 79},
    { 1212, 396, 111},
    { 1072, 306, 179},
    { 901, 227, 173},
    { 840, 191, 155},
    { 845, 186, 167},
    { 847, 161, 178},
    { 734, 141, 145},
    { 808, 150, 160},
    { 1027, 134, 227},
    { 1055, 173, 183},
    { 1223, 258, 92},
    { 1421, 287, 146},
    { 1111, 390, -62},
    { 995, 421, -137},
    { 983, 313, 37},
    { 954, 259, 82},
    { 876, 227, 62},
    { 823, 267, 71},
    { 809, 329, 74},
    { 844, 379, 6},
    { 804, 367, -52},
    { 842, 344, -70},
    { 1101, 343, -28},
    { 1296, 392, -11},
    { 1217, 371, 1},
    { 1316, 454, -12},
    { 1343, 503, -11},
    { 1198, 398, 107},
    { 1161, 373, 110},
    { 1101, 368, 131},
    { 967, 316, 176},
    { 832, 234, 184},
    { 773, 182, 176},
    { 820, 174, 209},
    { 818, 169, 212},
    { 759, 173, 186},
    { 891, 178, 207},
    { 1122, 166, 246},
    { 1124, 234, 164},
    { 1311, 278, 142},
    { 1254, 326, 60},
    { 971, 451, -190},
    { 1038, 358, -80},
    { 1005, 269, 21},
    { 892, 193, 17},
    { 817, 207, 28},
    { 786, 287, 10},
    { 831, 332, 10},
    { 870, 351, -25},
    { 845, 319, -48},
    { 894, 307, -44},
    { 1159, 333, -17},
    { 1238, 364, 12},
    { 1260, 407, 41},
    { 1499, 518, -19},
    { 1166, 467, 113},
    { 1145, 385, 120},
    { 1098, 379, 78},
    { 988, 348, 135},
    { 895, 268, 161},
    { 822, 217, 174},
    { 810, 184, 180},
    { 836, 179, 188},
    { 799, 170, 168},
    { 865, 194, 164},
    { 1001, 179, 208},
    { 1193, 173, 218},
    { 1267, 204, 185},
    { 1379, 265, 149},
    { 1088, 359, -103},
    { 947, 424, -234},
    { 857, 281, -66},
    { 853, 169, 58},
    { 809, 167, 98},
    { 878, 271, 69},
    { 857, 370, 41},
    { 871, 411, -1},
    { 837, 365, -32},
    { 786, 287, -49},
    { 973, 255, -24},
    { 1297, 304, 38},
    { 1236, 387, 20},
    { 1254, 510, -49},
    { 1399, 688, -48},
    { 1147, 463, 101},
    { 1164, 421, 79},
    { 1175, 369, 124},
    { 1028, 324, 168},
    { 910, 229, 183},
    { 853, 198, 178},
    { 840, 192, 194},
    { 861, 185, 201},
    { 806, 179, 165},
    { 844, 174, 164},
    { 1033, 147, 214},
    { 1051, 147, 177},
    { 1148, 223, 79},
    { 1346, 237, 136},
    { 1036, 341, -41},
    { 1093, 407, -134},
    { 1113, 342, 12},
    { 1003, 328, 63},
    { 870, 284, 32},
    { 805, 293, 39},
    { 807, 355, 33},
    { 834, 391, -11},
    { 793, 365, -46},
    { 913, 358, -64},
    { 1112, 422, -66},
    { 1202, 458, -73},
    { 1212, 420, 18},
    { 1463, 501, 30},
    { 1216, 463, 90},
    { 1259, 436, 107},
    { 1247, 384, 127},
    { 1148, 358, 169},
    { 976, 263, 180},
    { 862, 216, 174},
    { 823, 183, 181},
    { 844, 148, 205},
    { 770, 141, 175},
    { 724, 143, 160},
    { 849, 139, 215},
    { 986, 145, 226},
    { 1193, 224, 170},
    { 1543, 276, 200},
    { 1143, 421, -127},
    { 1187, 476, -216},
    { 1097, 354, -22},
    { 952, 213, 1},
    { 826, 196, 24},
    { 769, 286, 33},
    { 807, 347, 41},
    { 888, 361, 51},
    { 906, 368, 18},
    { 943, 378, 20},
    { 1004, 394, 8},
    { 1131, 426, -11},
    { 1227, 452, 16},
    { 1381, 498, 28},
    { 1183, 458, 125},
    { 1131, 409, 89},
    { 1039, 389, 69},
    { 1008, 377, 93},
    { 984, 286, 142},
    { 900, 234, 126},
    { 841, 179, 148},
    { 828, 146, 178},
    { 808, 127, 182},
    { 772, 152, 190},
    { 932, 190, 217},
    { 1140, 193, 260},
    { 1222, 241, 204},
    { 1413, 260, 229},
    { 1215, 346, 30},
    { 1009, 476, -202},
    { 936, 360, -88},
    { 901, 249, 7},
    { 830, 185, 55},
    { 818, 219, 28},
    { 815, 278, 47},
    { 867, 310, 38},
    { 869, 301, -2},
    { 801, 309, -46},
    { 894, 323, -66},
    { 1209, 349, -16},
    { 1190, 352, 3},
    { 1190, 407, 37},
    { 1503, 531, 17},
    { 1160, 523, 102},
    { 1162, 443, 92},
    { 1199, 396, 100},
    { 1064, 341, 151},
    { 921, 248, 157},
    { 828, 202, 138},
    { 821, 200, 148},
    { 829, 177, 167},
    { 770, 157, 155},
    { 818, 158, 156},
    { 1018, 153, 203},
    { 1106, 181, 185},
    { 1201, 250, 113},
    { 1286, 265, 147},
    { 1143, 342, 11},
    { 1019, 411, -136},
    { 1062, 355, -43},
    { 977, 307, 33},
    { 844, 247, 46},
    { 766, 240, 41},
    { 762, 299, 53},
    { 824, 353, 2},
    { 825, 356, -52},
    { 859, 350, -75},
    { 1043, 355, -62},
    { 1273, 427, -77},
    { 1182, 406, -23},
    { 1341, 473, -18},
    { 1473, 559, -55},
    { 1143, 395, 101},
    { 1163, 385, 99},
    { 1122, 357, 90},
    { 985, 343, 127},
    { 868, 254, 168},
    { 804, 200, 168},
    { 792, 179, 167},
    { 801, 173, 169},
    { 748, 159, 152},
    { 835, 166, 153},
    { 981, 169, 180},
    { 1062, 199, 106},
    { 1223, 257, 47},
    { 1384, 254, 105},
    { 1107, 339, -97},
    { 1130, 405, -165},
    { 1040, 368, -55},
    { 879, 288, 32},
    { 806, 225, 44},
    { 773, 252, 53},
    { 766, 293, 72},
    { 835, 326, 52},
    { 837, 341, -7},
    { 908, 366, -63},
    { 1095, 380, -64},
    { 1255, 444, -82},
    { 1251, 445, -50},
    { 1428, 497, -26},
    { 1284, 550, -10},
    { 1167, 432, 60},
    { 1146, 407, 90},
    { 1125, 360, 158},
    { 1006, 294, 180},
    { 869, 216, 200},
    { 806, 197, 186},
    { 817, 186, 203},
    { 827, 172, 195},
    { 774, 165, 192},
    { 894, 158, 224},
    { 1103, 139, 266},
    { 1155, 206, 199},
    { 1390, 252, 190},
    { 1219, 316, 6},
    { 1046, 461, -255},
    { 1042, 336, -88},
    { 1001, 245, 31},
    { 872, 205, 70},
    { 842, 253, 33},
    { 839, 349, 42},
    { 846, 391, 28},
    { 839, 384, -30},
    { 818, 362, -75},
    { 963, 327, -51},
    { 1254, 380, -8},
    { 1212, 436, -15},
    { 1351, 521, -23},
    { 1432, 629, -69},
    { 1201, 381, 102},
    { 1196, 358, 115},
    { 1161, 329, 132},
    { 987, 304, 137},
    { 861, 227, 172},
    { 807, 190, 189},
    { 818, 163, 197},
    { 853, 154, 203},
    { 799, 150, 175},
    { 870, 146, 184},
    { 1012, 126, 217},
    { 1038, 145, 149},
    { 1215, 208, 98},
    { 1489, 227, 183},
    { 1082, 369, -83},
    { 1113, 445, -227},
    { 1048, 297, 31},
    { 961, 215, 131},
    { 874, 190, 103},
    { 812, 249, 72},
    { 760, 319, 68},
    { 758, 369, -17},
    { 758, 360, -42},
    { 934, 328, -30},
    { 1217, 323, -16},
    { 1296, 428, -65},
    { 1335, 467, -34},
    { 1463, 525, -44},
    { 1165, 387, 79},
    { 1152, 346, 113},
    { 1095, 328, 90},
    { 992, 304, 122},
    { 915, 229, 166},
    { 862, 190, 164},
    { 844, 157, 199},
    { 837, 155, 200},
    { 776, 148, 164},
    { 775, 161, 157},
    { 960, 157, 197},
    { 1137, 169, 164},
    { 1270, 225, 113},
    { 1494, 217, 193},
    { 1128, 324, -38},
    { 1015, 443, -237},
    { 950, 263, 12},
    { 961, 193, 136},
    { 878, 164, 108},
    { 787, 228, 77},
    { 755, 281, 105},
    { 789, 352, 57},
    { 794, 374, 12},
    { 927, 354, -30},
    { 1172, 342, 19},
    { 1302, 404, -3},
    { 1192, 420, -14},
    { 1169, 474, -36},
    { 1275, 569, -97},
    { 1053, 460, 38},
    { 1224, 450, 73},
    { 1183, 389, 129},
    { 1024, 334, 132},
    { 882, 229, 172},
    { 818, 180, 146},
    { 839, 168, 175},
    { 833, 162, 167},
    { 802, 153, 178},
    { 932, 127, 220},
    { 1159, 133, 265},
    { 1149, 207, 160},
    { 1290, 257, 121},
    { 1297, 288, 75},
    { 971, 404, -198},
    { 1009, 292, -75},
    { 995, 211, 48},
    { 885, 190, 60},
    { 819, 201, 42},
    { 790, 292, 26},
    { 853, 350, 17},
    { 895, 357, -20},
    { 859, 340, -57},
    { 961, 322, -54},
    { 1224, 363, -38},
    { 1157, 396, -31},
    { 1207, 455, -35},
    { 1483, 612, -95},
    { 1221, 558, 102},
    { 1292, 420, 149},
    { 1177, 351, 140},
    { 1006, 329, 137},
    { 879, 285, 134},
    { 815, 199, 165},
    { 853, 174, 181},
    { 896, 150, 191},
    { 848, 127, 208},
    { 896, 119, 228},
    { 1038, 128, 269},
    { 1080, 165, 197},
    { 1282, 249, 138},
    { 1253, 267, 73},
    { 1080, 406, -252},
    { 1050, 313, -148},
    { 945, 210, 11},
    { 799, 204, 35},
    { 876, 227, -10},
    { 831, 313, 31},
    { 828, 355, 39},
    { 884, 355, 23},
    { 862, 336, -9},
    { 889, 333, -29},
    { 1132, 351, -31},
    { 1275, 429, -32},
    { 1222, 462, -17},
    { 1352, 589, -57},
    { 1253, 575, -12},
    { 1327, 465, 73},
    { 1291, 417, 109},
    { 1198, 320, 189},
    { 987, 256, 190},
    { 899, 218, 167},
    { 883, 199, 190},
    { 860, 181, 209},
    { 774, 139, 194},
    { 777, 130, 197},
    { 843, 121, 212},
    { 1032, 149, 201},
    { 1135, 191, 134},
    { 1417, 221, 166},
    { 1285, 282, 43},
    { 1130, 458, -215},
    { 1061, 355, -27},
    { 999, 269, 113},
    { 909, 237, 86},
    { 877, 265, 70},
    { 848, 368, 104},
    { 881, 408, 98},
    { 894, 424, 33},
    { 837, 398, -18},
    { 922, 366, -26},
    { 1248, 419, 0},
    { 1189, 416, -8},
    { 1212, 431, -29},
    { 1437, 550, -73},
    { 1188, 463, 34},
    { 1272, 412, 94},
    { 1226, 355, 102},
    { 1056, 340, 149},
    { 906, 252, 176},
    { 824, 204, 178},
    { 889, 184, 207},
    { 897, 155, 244},
    { 830, 139, 222},
    { 828, 161, 213},
    { 889, 165, 236},
    { 1007, 169, 228},
    { 1156, 245, 142},
    { 1300, 256, 156},
    { 1077, 323, -8},
    { 1058, 419, -160},
    { 1061, 340, -48},
    { 935, 273, -14},
    { 870, 249, -19},
    { 812, 245, -23},
    { 791, 299, -44},
    { 840, 297, -63},
    { 837, 301, -100},
    { 870, 307, -113},
    { 1103, 321, -48},
    { 1310, 379, -9},
    { 1267, 421, 28},
    { 1307, 516, -23},
    { 1349, 582, 43},
    { 1323, 440, 165},
    { 1192, 398, 135},
    { 1073, 337, 179},
    { 894, 272, 190},
    { 772, 205, 181},
    { 776, 193, 182},
    { 853, 186, 202},
    { 861, 160, 217},
    { 838, 150, 195},
    { 968, 155, 238},
    { 1107, 153, 254},
    { 1185, 231, 141},
    { 1346, 272, 105},
    { 1148, 315, -24},
    { 987, 403, -201},
    { 999, 290, -55},
    { 997, 238, 56},
    { 901, 234, 50},
    { 856, 269, 26},
    { 807, 341, 31},
    { 825, 379, 3},
    { 805, 357, -43},
    { 801, 320, -80},
    { 985, 303, -46},
    { 1301, 350, 11},
    { 1252, 392, 25},
    { 1250, 459, 8},
    { 1364, 539, -18},
    { 1118, 487, 52},
    { 1153, 435, 73},
    { 1175, 383, 136},
    { 1040, 331, 182},
    { 900, 246, 182},
    { 820, 194, 169},
    { 805, 190, 176},
    { 849, 185, 192},
    { 801, 168, 175},
    { 813, 157, 160},
    { 935, 143, 225},
    { 1071, 151, 218},
    { 1183, 234, 145},
    { 1377, 264, 171},
    { 1203, 340, 27},
    { 1028, 474, -193},
    { 1021, 362, -46},
    { 984, 263, 60},
    { 884, 199, 45},
    { 791, 226, 28},
    { 783, 297, 27},
    { 821, 366, -3},
    { 820, 363, -53},
    { 864, 338, -57},
    { 1025, 326, -23},
    { 1277, 378, -23},
    { 1233, 410, -7},
    { 1451, 500, -42},
    { 1322, 500, 1},
    { 1178, 358, 142},
    { 1138, 353, 119},
    { 1072, 346, 117},
    { 967, 327, 162},
    { 872, 223, 209},
    { 802, 178, 203},
    { 812, 153, 210},
    { 801, 148, 212},
    { 772, 158, 182},
    { 824, 156, 199},
    { 1034, 143, 264},
    { 1020, 175, 145},
    { 1198, 273, 29},
    { 1345, 248, 110},
    { 1122, 315, -24},
    { 1081, 383, -150},
    { 1068, 326, -31},
    { 974, 334, 17},
    { 865, 274, 23},
    { 794, 265, 36},
    { 807, 292, 56},
    { 828, 332, 19},
    { 810, 343, -43},
    { 851, 342, -67},
    { 1054, 348, -52},
    { 1276, 408, -66},
    { 1161, 373, 16},
    { 1265, 413, 37},
    { 1476, 547, -18},
    { 1198, 455, 117},
    { 1152, 443, 85},
    { 1200, 373, 153},
    { 1044, 303, 186},
    { 874, 206, 181},
    { 811, 173, 194},
    { 828, 169, 222},
    { 801, 149, 233},
    { 688, 157, 198},
    { 819, 164, 211},
    { 1014, 141, 265},
    { 1126, 222, 170},
    { 1278, 271, 124},
    { 1457, 314, 80},
    { 1054, 465, -266},
    { 981, 326, -96},
    { 1010, 218, 75},
    { 949, 204, 85},
    { 902, 213, 57},
    { 808, 341, 71},
    { 824, 370, 54},
    { 836, 402, 20},
    { 803, 372, -15},
    { 863, 348, -36},
    { 1164, 388, -17},
    { 1283, 435, -34},
    { 1226, 397, 10},
    { 1401, 482, -6},
    { 1289, 487, 5},
    { 1141, 400, 80},
    { 1114, 342, 79},
    { 1063, 338, 101},
    { 944, 335, 122},
    { 841, 255, 164},
    { 811, 204, 203},
    { 861, 168, 244},
    { 894, 166, 258},
    { 811, 178, 227},
    { 851, 213, 223},
    { 1036, 203, 255},
    { 1038, 217, 187},
    { 1236, 259, 139},
    { 1320, 313, 62},
    { 1045, 402, -193},
    { 1035, 359, -148},
    { 992, 268, -70},
    { 888, 228, -33},
    { 835, 216, -19},
    { 820, 279, -15},
    { 835, 312, -12},
    { 884, 326, -25},
    { 875, 322, -44},
    { 890, 321, -46},
    { 980, 321, -18},
    { 1141, 374, -17},
    { 1236, 409, 6},
    { 1442, 474, 55},
    { 1276, 531, 101},
    { 1130, 381, 137},
    { 1019, 378, 68},
    { 1005, 387, 72},
    { 919, 340, 122},
    { 803, 238, 133},
    { 754, 172, 142},
    { 800, 163, 170},
    { 823, 162, 172},
    { 804, 177, 163},
    { 961, 216, 204},
    { 1169, 191, 244},
    { 1208, 252, 194},
    { 1421, 257, 239},
    { 1197, 347, 37},
    { 977, 426, -198},
    { 956, 341, -113},
    { 927, 250, -50},
    { 835, 164, -4},
    { 795, 201, -4},
    { 821, 281, 5},
    { 872, 322, 20},
    { 888, 330, -2},
    { 813, 323, -44},
    { 803, 326, -71},
    { 1013, 335, -32},
    { 1291, 352, 29},
    { 1214, 338, 99},
    { 1262, 414, 83},
    { 1400, 550, 19},
    { 1112, 496, 91},
    { 1097, 396, 88},
    { 1063, 358, 113},
    { 960, 326, 124},
    { 846, 245, 139},
    { 803, 208, 137},
    { 831, 190, 153},
    { 853, 177, 152},
    { 770, 171, 136},
    { 916, 176, 151},
    { 1120, 173, 216},
    { 1381, 202, 278},
    { 1389, 257, 236},
    { 1202, 403, -99},
    { 937, 418, -123},
    { 848, 331, -20},
    { 821, 180, 77},
    { 896, 158, 71},
    { 851, 279, 72},
    { 793, 346, 46},
    { 791, 374, 12},
    { 826, 343, -1},
    { 850, 300, -10},
    { 946, 277, 0},
    { 1170, 322, 28},
    { 1215, 397, -17},
    { 1251, 453, -29},
    { 1463, 517, -39},
    { 1138, 508, -34},
    { 1131, 377, 58},
    { 1123, 380, 78},
    { 1012, 349, 96},
    { 924, 307, 148},
    { 850, 236, 177},
    { 858, 217, 165},
    { 860, 206, 182},
    { 823, 187, 158},
    { 797, 194, 136},
    { 876, 163, 177},
    { 1025, 166, 162},
    { 1032, 207, 64},
    { 1173, 221, 83},
    { 1406, 250, 160},
    { 1025, 378, -101},
    { 1080, 417, -134},
    { 1047, 346, 57},
    { 952, 295, 82},
    { 864, 249, 56},
    { 806, 279, 84},
    { 825, 328, 75},
    { 858, 378, 18},
    { 803, 366, -43},
    { 857, 346, -67},
    { 1128, 373, -47},
    { 1272, 430, -31},
    { 1256, 424, -2},
    { 1473, 530, -5},
    { 1273, 522, 92},
    { 1194, 455, 73},
    { 1150, 399, 101},
    { 1059, 369, 151},
    { 944, 271, 178},
    { 843, 216, 183},
    { 829, 178, 191},
    { 850, 177, 209},
    { 802, 163, 205},
    { 770, 172, 184},
    { 885, 165, 228},
    { 1080, 163, 238},
    { 1146, 228, 157},
    { 1362, 244, 193},
    { 1254, 331, 23},
    { 1110, 465, -211},
    { 1050, 341, -59},
    { 979, 246, 45},
    { 851, 213, 35},
    { 846, 246, 18},
    { 819, 338, 49},
    { 881, 375, 33},
    { 879, 363, 34},
    { 843, 349, 0},
    { 956, 376, -30},
    { 1182, 430, -31},
    { 1137, 406, -8},
    { 1227, 400, 24},
    { 1473, 510, 49},
    { 1137, 521, 53},
    { 1171, 451, 64},
    { 1163, 420, 92},
    { 1099, 373, 161},
    { 998, 276, 182},
    { 903, 201, 189},
    { 858, 186, 184},
    { 873, 187, 193},
    { 826, 166, 183},
    { 782, 160, 169},
    { 875, 155, 202},
    { 1021, 145, 198},
    { 1095, 207, 101},
    { 1282, 219, 139},
    { 1274, 297, 33},
    { 1123, 433, -192},
    { 1130, 395, -118},
    { 994, 316, -7},
    { 870, 239, 25},
    { 838, 223, 40},
    { 806, 290, 59},
    { 839, 335, 49},
    { 843, 371, 17},
    { 822, 368, -34},
    { 908, 377, -47},
    { 1190, 409, -71},
    { 1138, 396, -28},
    { 1177, 386, -15},
    { 1448, 509, -49},
    { 1241, 480, 81},
    { 1212, 474, 72},
    { 1255, 420, 105},
    { 1142, 360, 180},
    { 976, 257, 199},
    { 881, 195, 174},
    { 853, 193, 174},
    { 816, 186, 178},
    { 711, 166, 142},
    { 744, 155, 143},
    { 892, 133, 182},
    { 999, 166, 145},
    { 1158, 219, 91},
    { 1484, 228, 209},
    { 1266, 333, 16},
    { 1192, 486, -183},
    { 1034, 359, 15},
    { 949, 281, 62},
    { 804, 203, 45},
    { 735, 229, 55},
    { 778, 296, 76},
    { 873, 348, 70},
    { 888, 412, -4},
    { 910, 437, -65},
    { 1062, 455, -57},
    { 1226, 468, -50},
    { 1153, 370, -3},
    { 1229, 440, 7},
    { 1425, 560, -42},
    { 1280, 493, 68},
    { 1264, 458, 101},
    { 1278, 351, 203},
    { 1029, 279, 187},
    { 868, 236, 139},
    { 854, 221, 147},
    { 863, 205, 170},
    { 818, 147, 169},
    { 726, 123, 153},
    { 818, 126, 148},
    { 1025, 145, 154},
    { 1052, 182, 106},
    { 1245, 196, 153},
    { 1374, 275, 107},
    { 1227, 465, -123},
    { 1173, 439, -44},
    { 1021, 364, 45},
    { 873, 278, 53},
    { 816, 231, 57},
    { 808, 278, 75},
    { 849, 339, 51},
    { 861, 401, -7},
    { 833, 415, -51},
    { 932, 410, -50},
    { 1186, 438, -39},
    { 1134, 422, -48},
    { 1243, 447, -40},
    { 1457, 515, -25},
    { 1278, 458, 62},
    { 1269, 454, 54},
    { 1320, 419, 118},
    { 1151, 342, 176},
    { 943, 251, 167},
    { 852, 190, 163},
    { 830, 186, 157},
    { 816, 157, 192},
    { 701, 143, 136},
    { 692, 165, 118},
    { 820, 148, 161},
    { 1016, 168, 148},
    { 1165, 224, 92},
    { 1353, 222, 204},
    { 1256, 315, 32},
    { 1192, 496, -171},
    { 1120, 385, -4},
    { 981, 260, 64},
    { 862, 206, 52},
    { 800, 226, 59},
    { 785, 302, 74},
    { 825, 356, 33},
    { 858, 427, -49},
    { 916, 453, -90},
    { 1101, 488, -94},
    { 1298, 566, -114},
    { 1137, 456, -40},
    { 1322, 535, -27},
    { 1468, 584, 19},
    { 1267, 458, 118},
    { 1197, 436, 107},
    { 1225, 425, 151},
    { 1076, 359, 206},
    { 916, 245, 217},
    { 849, 174, 229},
    { 858, 165, 224},
    { 847, 156, 229},
    { 742, 155, 190},
    { 829, 165, 189},
    { 961, 148, 239},
    { 1057, 175, 176},
    { 1297, 227, 167},
    { 1224, 264, 36},
    { 1084, 436, -261},
    { 1110, 368, -141},
    { 1037, 272, -25},
    { 905, 232, 26},
    { 874, 275, 6},
    { 828, 363, 8},
    { 840, 398, 5},
    { 871, 366, -8},
    { 892, 352, -25},
    { 998, 343, -11},
    { 1174, 398, -9},
    { 1188, 454, -22},
    { 1302, 502, 2},
    { 1472, 613, -28},
    { 1144, 471, 44},
    { 1224, 435, 70},
    { 1216, 379, 106},
    { 1074, 330, 150},
    { 915, 245, 172},
    { 821, 204, 160},
    { 853, 200, 179},
    { 887, 188, 213},
    { 821, 149, 208},
    { 855, 156, 197},
    { 932, 153, 233},
    { 1012, 155, 191},
    { 1078, 225, 120},
    { 1350, 232, 201},
    { 1143, 311, 23},
    { 1150, 439, -181},
    { 1070, 384, -107},
    { 939, 286, -24},
    { 810, 193, 3},
    { 791, 196, 11},
    { 808, 290, 1},
    { 869, 343, -39},
    { 839, 373, -91},
    { 853, 361, -111},
    { 1035, 369, -59},
    { 1284, 405, -49},
    { 1168, 398, 27},
    { 1252, 478, 4},
    { 1417, 602, 22},
    { 1293, 487, 157},
    { 1236, 444, 130},
    { 1126, 358, 188},
    { 981, 316, 185},
    { 885, 252, 189},
    { 862, 216, 198},
    { 864, 185, 205},
    { 848, 157, 204},
    { 747, 149, 177},
    { 797, 158, 169},
    { 958, 152, 197},
    { 1055, 174, 144},
    { 1239, 222, 128},
    { 1446, 266, 146},
    { 1215, 408, -120},
    { 1155, 476, -185},
    { 1011, 372, 0},
    { 878, 253, 47},
    { 835, 219, 37},
    { 793, 283, 59},
    { 801, 322, 69},
    { 853, 357, 38},
    { 837, 346, 14},
    { 862, 356, -18},
    { 1095, 391, 7},
    { 1247, 432, -2},
    { 1207, 441, 4},
    { 1371, 536, -29},
    { 1286, 594, -12},
    { 1229, 472, 56},
    { 1247, 410, 122},
    { 1138, 345, 165},
    { 964, 293, 174},
    { 828, 223, 177},
    { 821, 204, 176},
    { 868, 186, 205},
    { 812, 156, 213},
    { 770, 152, 197},
    { 885, 153, 225},
    { 1060, 154, 237},
    { 1080, 231, 121},
    { 1305, 253, 157},
    { 1301, 314, 83},
    { 1128, 482, -211},
    { 1109, 416, -99},
    { 1026, 332, 24},
    { 878, 226, 21},
    { 807, 208, 8},
    { 813, 303, 40},
    { 859, 350, 17},
    { 884, 389, -45},
    { 840, 386, -110},
    { 901, 366, -80},
    { 1189, 376, -51},
    { 1233, 324, 0},
    { 1268, 371, 18},
    { 1304, 429, 43},
    { 1193, 494, -11},
    { 1101, 417, 79},
    { 1168, 402, 91},
    { 1103, 365, 132},
    { 965, 282, 164},
    { 815, 220, 146},
    { 765, 220, 120},
    { 795, 207, 140},
    { 760, 169, 138},
    { 738, 155, 141},
    { 880, 153, 176},
    { 1060, 160, 204},
    { 1287, 213, 177},
    { 1494, 265, 202},
    { 1226, 387, -93},
    { 1021, 444, -253},
    { 1022, 307, -69},
    { 920, 177, 21},
    { 822, 187, 30},
    { 753, 261, 61},
    { 759, 327, 72},
    { 764, 333, 53},
    { 781, 321, -3},
    { 771, 330, -64},
    { 935, 330, -31},
    { 1300, 384, 15},
    { 1357, 467, -21},
    { 1420, 634, -55},
    { 1389, 631, -42},
    { 1190, 442, 23},
    { 1145, 368, 64},
    { 1116, 313, 113},
    { 991, 285, 135},
    { 862, 263, 124},
    { 844, 253, 133},
    { 861, 218, 172},
    { 839, 168, 192},
    { 741, 148, 152},
    { 825, 160, 143},
    { 1029, 149, 169},
    { 1123, 148, 171},
    { 1525, 187, 239},
    { 1516, 299, 121},
    { 1278, 513, -220},
    { 897, 384, -137},
    { 830, 253, 78},
    { 909, 157, 88},
    { 816, 228, 115},
    { 807, 335, 155},
    { 755, 341, 129},
    { 771, 358, 92},
    { 845, 325, 78},
    { 944, 344, 43},
    { 1193, 394, 41},
    { 1242, 413, 14},
    { 1271, 446, -66},
    { 1419, 541, -194},
    { 1160, 455, -111},
    { 1266, 360, -25},
    { 1225, 304, 46},
    { 1119, 307, 59},
    { 972, 276, 115},
    { 899, 254, 131},
    { 896, 227, 131},
    { 874, 195, 140},
    { 790, 157, 126},
    { 746, 142, 100},
    { 814, 125, 138},
    { 978, 137, 140},
    { 945, 169, 63},
    { 1353, 237, 78},
    { 1595, 267, 243},
    { 1332, 437, 35},
    { 1077, 472, -113},
    { 865, 447, 12},
    { 878, 355, 94},
    { 837, 244, 100},
    { 787, 258, 137},
    { 772, 297, 99},
    { 774, 340, 44},
    { 789, 336, -33},
    { 869, 320, -70},
    { 1103, 338, -56},
    { 1281, 372, -60},
    { 1266, 353, -92},
    { 1250, 409, -102},
    { 1303, 440, -120},
    { 1151, 354, -14},
    { 1186, 321, 44},
    { 1168, 289, 72},
    { 1059, 271, 115},
    { 899, 244, 107},
    { 862, 226, 87},
    { 847, 185, 108},
    { 774, 136, 116},
    { 681, 120, 94},
    { 740, 143, 83},
    { 956, 160, 124},
    { 1168, 210, 125},
    { 1418, 257, 216},
    { 1618, 270, 460},
    { 1375, 438, 247},
    { 1127, 483, -1},
    { 990, 329, 171},
    { 941, 331, 172},
    { 837, 197, 150},
    { 701, 234, 174},
    { 646, 294, 146},
    { 656, 340, 105},
    { 724, 322, 61},
    { 804, 304, 28},
    { 994, 318, 7},
    { 1190, 345, 29},
    { 1260, 368, -20},
    { 1407, 440, -52},
    { 1429, 555, -144},
    { 1094, 391, -119},
    { 1159, 348, -57},
    { 1175, 297, 20},
    { 1085, 284, 55},
    { 934, 220, 114},
    { 900, 202, 121},
    { 911, 188, 138},
    { 848, 165, 125},
    { 756, 143, 104},
    { 786, 146, 109},
    { 988, 139, 132},
    { 1081, 155, 125},
    { 1308, 189, 148},
    { 1551, 199, 375},
    { 1366, 357, 225},
    { 1153, 470, -40},
    { 1065, 330, 100},
    { 918, 324, 137},
    { 778, 192, 112},
    { 702, 217, 105},
    { 735, 297, 101},
    { 744, 347, 86},
    { 820, 347, 55},
    { 851, 336, 40},
    { 993, 343, 44},
    { 1222, 364, 28},
    { 1310, 390, -11},
    { 1488, 449, -79},
    { 1388, 441, -76},
    { 1255, 289, 38},
    { 1102, 306, -5},
    { 1058, 318, -36},
    { 916, 285, 68},
    { 826, 221, 94},
    { 792, 174, 109},
    { 832, 185, 131},
    { 809, 141, 155},
    { 735, 151, 139},
    { 858, 170, 162},
    { 1097, 161, 205},
    { 1179, 188, 184},
    { 1362, 232, 172},
    { 1463, 268, 213},
    { 1052, 363, -65},
    { 986, 404, -111},
    { 988, 310, 45},
    { 844, 187, 75},
    { 754, 172, 40},
    { 730, 244, 57},
    { 782, 300, 32},
    { 832, 325, -4},
    { 803, 317, -74},
    { 863, 321, -86},
    { 1162, 361, -71},
    { 1345, 414, -57},
    { 1161, 410, -56},
    { 1310, 510, -50},
    { 1414, 577, 0},
    { 1260, 446, 77},
    { 1242, 383, 130},
    { 1118, 333, 190},
    { 934, 255, 211},
    { 792, 196, 182},
    { 814, 195, 193},
    { 855, 193, 216},
    { 765, 149, 208},
    { 799, 149, 200},
    { 910, 126, 248},
    { 1055, 168, 210},
    { 1202, 261, 69},
    { 1269, 274, 80},
    { 1324, 298, 54},
    { 1000, 355, -150},
    { 1113, 364, -36},
    { 1076, 357, 71},
    { 906, 303, 54},
    { 771, 277, 10},
    { 750, 328, 20},
    { 808, 355, -22},
    { 828, 312, -39},
    { 857, 290, -64},
    { 970, 353, -67},
    { 1188, 441, -76},
    { 1151, 412, 30},
    { 1538, 531, 58},
    { 1479, 560, 102},
    { 1315, 458, 138},
    { 1236, 397, 175},
    { 1125, 360, 212},
    { 931, 271, 233},
    { 825, 198, 231},
    { 815, 184, 217},
    { 811, 172, 254},
    { 718, 149, 244},
    { 902, 178, 247},
    { 1071, 146, 329},
    { 1012, 171, 255},
    { 1120, 258, 126},
    { 1447, 250, 187},
    { 978, 272, -31},
    { 1065, 406, -186},
    { 1085, 294, -35},
    { 1008, 285, 9},
    { 853, 259, 0},
    { 813, 299, -38},
    { 808, 355, -38},
    { 797, 368, -108},
    { 838, 369, -151},
    { 907, 350, -106},
    { 1183, 395, -66},
    { 1249, 406, -9},
    { 1453, 461, 64},
    { 1591, 544, 77},
    { 1260, 393, 171},
    { 1201, 400, 134},
    { 1131, 372, 151},
    { 969, 354, 169},
    { 853, 230, 226},
    { 775, 183, 225},
    { 816, 172, 227},
    { 861, 174, 230},
    { 753, 161, 209},
    { 818, 176, 196},
    { 962, 156, 253},
    { 1141, 165, 247},
    { 1260, 235, 189},
    { 1416, 256, 189},
    { 1024, 375, -113},
    { 1122, 436, -197},
    { 1049, 375, -78},
    { 888, 219, -5},
    { 813, 208, -8},
    { 831, 271, 6},
    { 881, 349, 14},
    { 912, 359, 6},
    { 788, 329, -29},
    { 769, 364, -70},
    { 1029, 390, -36},
    { 1166, 403, -36},
    { 1189, 391, 32},
    { 1375, 522, 15},
    { 1346, 493, 147},
    { 1288, 447, 146},
    { 1195, 402, 131},
    { 1095, 383, 162},
    { 916, 270, 200},
    { 791, 192, 200},
    { 766, 166, 193},
    { 777, 156, 211},
    { 767, 162, 187},
    { 876, 170, 220},
    { 1066, 148, 274},
    { 1084, 175, 209},
    { 1226, 260, 116},
    { 1450, 271, 161},
    { 1054, 340, -45},
    { 1046, 428, -180},
    { 1028, 316, 14},
    { 946, 238, 93},
    { 868, 217, 64},
    { 811, 274, 78},
    { 796, 328, 69},
    { 820, 356, 14},
    { 811, 329, -21},
    { 884, 318, -35},
    { 1104, 327, -3},
    { 1271, 374, -12},
    { 1280, 411, 16},
    { 1429, 501, 11},
    { 1297, 512, 74},
    { 1167, 436, 75},
    { 1149, 399, 94},
    { 1061, 351, 145},
    { 920, 265, 175},
    { 816, 204, 177},
    { 784, 192, 177},
    { 809, 183, 195},
    { 788, 165, 186},
    { 801, 175, 172},
    { 924, 162, 235},
    { 1168, 158, 285},
    { 1214, 205, 229},
    { 1306, 281, 168},
    { 1323, 330, 88},
    { 990, 428, -187},
    { 905, 341, -98},
    { 967, 260, 10},
    { 905, 196, 50},
    { 868, 214, 44},
    { 848, 300, 47},
    { 917, 353, 24},
    { 965, 349, 21},
    { 920, 351, -20},
    { 850, 337, -53},
    { 966, 373, -39},
    { 1154, 410, -53},
    { 1236, 450, -4},
    { 1258, 606, -4},
    { 1102, 432, 136},
    { 1169, 443, 62},
    { 1139, 424, 104},
    { 1106, 429, 141},
    { 927, 277, 178},
    { 853, 206, 206},
    { 865, 159, 231},
    { 922, 173, 240},
    { 823, 187, 210},
    { 847, 200, 203},
    { 1006, 195, 266},
    { 1135, 182, 246},
    { 1203, 227, 154},
    { 1353, 260, 147},
    { 1098, 294, -53},
    { 951, 375, -180},
    { 1032, 314, -79},
    { 926, 246, -8},
    { 871, 232, 29},
    { 869, 248, 47},
    { 844, 302, 52},
    { 885, 317, 46},
    { 883, 314, 25},
    { 870, 329, -4},
    { 952, 344, -23},
    { 1136, 381, -27},
    { 1183, 406, -18},
    { 1263, 448, 21},
    { 1259, 553, -4},
    { 1002, 419, 49},
    { 1108, 427, 44},
    { 1093, 397, 82},
    { 1027, 342, 141},
    { 945, 261, 164},
    { 879, 219, 186},
    { 867, 197, 202},
    { 873, 180, 223},
    { 849, 184, 187},
    { 912, 192, 200},
    { 1094, 161, 259},
    { 1198, 165, 228},
    { 1249, 203, 163},
    { 1330, 219, 153},
    { 1064, 325, -68},
    { 1005, 363, -151},
    { 958, 284, -41},
    { 837, 221, 26},
    { 783, 228, 38},
    { 788, 279, 40},
    { 768, 327, 44},
    { 816, 327, 25},
    { 849, 301, 9},
    { 929, 309, 16},
    { 1121, 322, 16},
    { 1218, 380, -10},
    { 1192, 427, -49},
    { 1274, 490, -45},
    { 1337, 536, -23},
    { 1236, 356, 116},
    { 1103, 377, 92},
    { 1043, 340, 112},
    { 954, 305, 166},
    { 863, 219, 188},
    { 838, 165, 209},
    { 836, 159, 221},
    { 793, 153, 201},
    { 779, 172, 174},
    { 901, 168, 212},
    { 1145, 159, 255},
    { 1114, 193, 186},
    { 1181, 250, 112},
    { 1568, 297, 146},
    { 1046, 356, -93},
    { 991, 408, -139},
    { 984, 286, 65},
    { 928, 217, 97},
    { 808, 191, 82},
    { 743, 262, 79},
    { 762, 311, 61},
    { 797, 352, 9},
    { 778, 316, -30},
    { 837, 301, -33},
    { 1167, 328, 17},
    { 1214, 360, 14},
    { 1207, 408, 12},
    { 1401, 502, 4},
    { 1299, 535, 53},
    { 1170, 410, 72},
    { 1166, 372, 102},
    { 1047, 345, 142},
    { 864, 261, 147},
    { 762, 202, 157},
    { 775, 174, 177},
    { 831, 173, 208},
    { 816, 157, 183},
    { 832, 175, 167},
    { 1001, 164, 240},
    { 1154, 148, 270},
    { 1263, 206, 243},
    { 1457, 256, 235},
    { 1004, 387, -65},
    { 1061, 432, -132},
    { 1022, 322, 24},
    { 888, 161, 79},
    { 783, 174, 37},
    { 745, 264, 18},
    { 759, 305, 19},
    { 826, 297, 6},
    { 825, 301, -24},
    { 936, 306, -11},
    { 1217, 340, 8},
    { 1257, 387, 11},
    { 1288, 443, 11},
    { 1418, 548, -46},
    { 1174, 483, 68},
    { 1218, 397, 122},
    { 1166, 345, 128},
    { 1001, 335, 152},
    { 867, 263, 185},
    { 778, 216, 176},
    { 804, 190, 198},
    { 845, 174, 229},
    { 797, 166, 217},
    { 836, 165, 224},
    { 1004, 147, 285},
    { 1148, 178, 263},
    { 1304, 220, 230},
    { 1431, 255, 218},
    { 1109, 401, -111},
    { 980, 421, -222},
    { 976, 279, -28},
    { 908, 172, 33},
    { 847, 172, 11},
    { 802, 264, 14},
    { 788, 321, 8},
    { 872, 318, 22},
    { 933, 288, 13},
    { 826, 283, -38},
    { 957, 339, -63},
    { 1191, 407, -39},
    { 1159, 428, -27},
    { 1177, 571, -22},
    { 1246, 627, 13},
    { 1148, 455, 102},
    { 1187, 452, 115},
    { 1228, 444, 165},
    { 1036, 365, 196},
    { 886, 267, 212},
    { 867, 191, 226},
    { 880, 191, 243},
    { 863, 190, 216},
    { 805, 208, 182},
    { 916, 192, 216},
    { 1097, 177, 219},
    { 1052, 211, 74},
    { 1185, 217, 72},
    { 1249, 191, 139},
    { 1121, 343, -160},
    { 1125, 348, -57},
    { 1023, 346, 46},
    { 838, 287, 70},
    { 760, 253, 62},
    { 797, 292, 103},
    { 882, 334, 73},
    { 877, 346, 15},
    { 891, 375, -29},
    { 1074, 413, -10},
    { 1241, 479, -49},
    { 1210, 492, 12},
    { 1434, 548, 11},
    { 1252, 526, 36},
    { 1301, 448, 74},
    { 1215, 378, 110},
    { 1094, 362, 124},
    { 949, 305, 146},
    { 866, 239, 174},
    { 864, 185, 183},
    { 901, 164, 208},
    { 818, 141, 192},
    { 801, 184, 165},
    { 887, 159, 217},
    { 1042, 159, 233},
    { 1169, 197, 176},
    { 1391, 232, 191},
    { 1087, 287, -21},
    { 1110, 436, -208},
    { 1041, 315, -41},
    { 872, 216, 60},
    { 882, 209, 68},
    { 854, 279, 73},
    { 801, 345, 64},
    { 820, 353, 17},
    { 848, 348, -30},
    { 828, 324, -54},
    { 989, 335, -36},
    { 1296, 395, 0},
    { 1226, 451, 17},
    { 1366, 582, -72},
    { 1359, 624, -33},
    { 1264, 425, 106},
    { 1242, 381, 124},
    { 1164, 345, 159},
    { 1008, 332, 184},
    { 907, 262, 205},
    { 868, 209, 213},
    { 866, 175, 232},
    { 826, 169, 205},
    { 749, 163, 188},
    { 830, 157, 187},
    { 1023, 137, 238},
    { 1048, 156, 185},
    { 1131, 231, 118},
    { 1461, 268, 144},
    { 1166, 391, -106},
    { 1126, 480, -188},
    { 997, 350, 24},
    { 919, 252, 37},
    { 875, 223, 49},
    { 816, 281, 90},
    { 811, 314, 74},
    { 843, 327, 58},
    { 835, 336, 20},
    { 875, 329, 8},
    { 1072, 357, 3},
    { 1272, 387, 2},
    { 1241, 375, 30},
    { 1318, 423, 45},
    { 1315, 527, -37},
    { 1167, 435, 50},
    { 1104, 428, 73},
    { 1130, 356, 118},
    { 1004, 294, 161},
    { 855, 222, 167},
    { 816, 218, 141},
    { 855, 209, 171},
    { 869, 165, 200},
    { 876, 181, 198},
    { 960, 167, 250},
    { 1117, 162, 255},
    { 1085, 265, 113},
    { 1150, 268, 95},
    { 1220, 281, 69},
    { 1012, 369, -206},
    { 957, 304, -98},
    { 941, 251, 8},
    { 894, 234, 31},
    { 884, 242, 43},
    { 818, 301, 66},
    { 825, 346, 19},
    { 855, 345, -18},
    { 826, 313, -47},
    { 931, 315, -71},
    { 1243, 348, -21},
    { 1248, 368, 24},
    { 1341, 484, -1},
    { 1401, 628, -42},
    { 1143, 448, 50},
    { 1173, 400, 81},
    { 1125, 347, 111},
    { 984, 327, 147},
    { 887, 251, 194},
    { 833, 221, 192},
    { 838, 210, 189},
    { 838, 189, 203},
    { 804, 175, 169},
    { 806, 185, 142},
    { 911, 163, 187},
    { 1100, 151, 200},
    { 1232, 175, 181},
    { 1495, 232, 215},
    { 1283, 347, 8},
    { 1085, 524, -251},
    { 951, 384, -79},
    { 853, 229, 62},
    { 874, 158, 53},
    { 868, 207, 88},
    { 912, 305, 114},
    { 972, 330, 155},
    { 909, 369, 105},
    { 729, 395, -33},
    { 726, 431, -71},
    { 969, 421, -47},
    { 1162, 432, -61},
    { 1123, 449, -6},
    { 1199, 553, 72},
    { 1272, 570, 100},
    { 1220, 578, 43},
    { 1216, 507, 121},
    { 1174, 368, 216},
    { 1006, 257, 191},
    { 892, 215, 180},
    { 880, 205, 207},
    { 890, 189, 219},
    { 784, 168, 202},
    { 858, 171, 217},
    { 1101, 147, 284},
    { 1042, 145, 231},
    { 1184, 250, 118},
    { 1320, 254, 124},
    { 1067, 352, -196},
    { 1036, 362, -194},
    { 1020, 297, -55},
    { 927, 247, -7},
    { 852, 221, 16},
    { 812, 281, 32},
    { 845, 325, 39},
    { 869, 358, -7},
    { 850, 359, -76},
    { 871, 341, -73},
    { 1080, 377, -88},
    { 1239, 409, -100},
    { 1225, 416, 2},
    { 1365, 475, 32},
    { 1309, 532, -3},
    { 1181, 453, 68},
    { 1147, 436, 85},
    { 1139, 382, 138},
    { 1003, 306, 165},
    { 877, 238, 182},
    { 836, 193, 181},
    { 844, 188, 176},
    { 824, 176, 157},
    { 750, 175, 123},
    { 823, 152, 158},
    { 971, 127, 209},
    { 995, 177, 129},
    { 1137, 239, 62},
    { 1546, 277, 140},
    { 1103, 351, -83},
    { 1126, 447, -202},
    { 1090, 362, 11},
    { 995, 278, 54},
    { 885, 225, 69},
    { 819, 275, 103},
    { 753, 324, 56},
    { 767, 361, 10},
    { 753, 363, -50},
    { 818, 346, -73},
    { 1086, 367, -55},
    { 1253, 429, -84},
    { 1271, 450, -29},
    { 1417, 554, -38},
    { 1344, 472, 78},
    { 1249, 423, 90},
    { 1210, 385, 109},
    { 1053, 368, 146},
    { 902, 262, 190},
    { 823, 210, 187},
    { 825, 183, 196},
    { 854, 179, 196},
    { 807, 160, 184},
    { 797, 167, 163},
    { 912, 142, 208},
    { 1060, 164, 181},
    { 1132, 225, 105},
    { 1235, 232, 119},
    { 1296, 302, 80},
    { 1068, 412, -145},
    { 1107, 397, -65},
    { 1044, 357, 23},
    { 900, 269, 12},
    { 839, 242, 42},
    { 794, 284, 46},
    { 824, 314, 30},
    { 832, 346, -14},
    { 806, 341, -36},
    { 982, 369, -45},
    { 1237, 424, -69},
    { 1213, 396, 18},
    { 1274, 412, 66},
    { 1387, 505, 5},
    { 1132, 472, 75},
    { 1178, 476, 76},
    { 1232, 391, 159},
    { 1047, 288, 180},
    { 872, 198, 178},
    { 794, 187, 150},
    { 814, 187, 145},
    { 821, 167, 165},
    { 761, 144, 170},
    { 886, 141, 191},
    { 1117, 127, 261},
    { 1187, 171, 250},
    { 1334, 250, 213},
    { 1291, 333, 53},
    { 1074, 450, -211},
    { 966, 345, -97},
    { 919, 221, 6},
    { 850, 167, 29},
    { 823, 221, 34},
    { 808, 308, 24},
    { 848, 346, -14},
    { 888, 342, -54},
    { 852, 328, -76},
    { 962, 325, -50},
    { 1289, 395, -59},
    { 1141, 407, -21},
    { 1340, 514, -35},
    { 1516, 660, -102},
    { 1269, 441, 97},
    { 1257, 442, 129},
    { 1217, 342, 173},
    { 984, 293, 190},
    { 829, 220, 197},
    { 806, 199, 184},
    { 817, 187, 190},
    { 831, 170, 198},
    { 804, 137, 190},
    { 871, 136, 214},
    { 1047, 124, 246},
    { 1141, 172, 183},
    { 1382, 235, 202},
    { 1321, 298, 62},
    { 1160, 480, -227},
    { 1055, 386, -135},
    { 947, 253, 40},
    { 886, 156, 39},
    { 832, 173, 34},
    { 803, 285, 72},
    { 810, 333, 52},
    { 851, 376, 13},
    { 868, 361, -31},
    { 994, 361, -29},
    { 1259, 404, -5},
    { 1249, 440, -32},
    { 1331, 528, -19},
    { 1433, 587, -1},
    { 1178, 455, 56},
    { 1112, 426, 65},
    { 1141, 367, 108},
    { 1042, 323, 161},
    { 945, 224, 188},
    { 898, 198, 197},
    { 899, 184, 215},
    { 889, 177, 221},
    { 808, 174, 206},
    { 814, 181, 185},
    { 937, 153, 237},
    { 1087, 157, 220},
    { 1261, 236, 164},
    { 1249, 249, 139},
    { 1080, 390, -151},
    { 1020, 382, -166},
    { 909, 249, 11},
    { 833, 183, 39},
    { 852, 193, 18},
    { 831, 286, 29},
    { 822, 324, 13},
    { 882, 340, 0},
    { 876, 353, -39},
    { 893, 318, -52},
    { 1136, 350, -29},
    { 1306, 405, -33},
    { 1173, 396, -1},
    { 1245, 490, 0},
    { 1349, 616, -71},
    { 1121, 445, 64},
    { 1139, 441, 74},
    { 1227, 381, 141},
    { 1078, 316, 196},
    { 995, 244, 204},
    { 936, 218, 209},
    { 906, 208, 209},
    { 845, 193, 178},
    { 688, 193, 105},
    { 744, 186, 137},
    { 982, 140, 179},
    { 1057, 162, 132},
    { 1116, 177, 98},
    { 1419, 210, 162},
    { 1111, 347, -131},
    { 1148, 408, -159},
    { 1033, 292, 49},
    { 933, 217, 81},
    { 877, 198, 103},
    { 806, 271, 140},
    { 800, 323, 112},
    { 802, 382, 38},
    { 805, 413, -30},
    { 969, 411, -39},
    { 1225, 470, -58},
    { 1202, 502, -51},
    { 1338, 520, -28},
    { 1436, 605, -23},
    { 1281, 441, 88},
    { 1143, 397, 77},
    { 1171, 405, 102},
    { 1093, 371, 140},
    { 961, 266, 200},
    { 891, 205, 208},
    { 914, 178, 217},
    { 911, 158, 232},
    { 807, 149, 194},
    { 850, 179, 200},
    { 964, 141, 254},
    { 979, 161, 203},
    { 1093, 215, 112},
    { 1296, 234, 140},
    { 1103, 298, -23},
    { 1100, 417, -193},
    { 1092, 353, -53},
    { 977, 276, 19},
    { 919, 267, 11},
    { 883, 272, 40},
    { 855, 319, 45},
    { 868, 359, 11},
    { 846, 359, -26},
    { 823, 343, -56},
    { 942, 341, -55},
    { 1233, 394, -60},
    { 1235, 388, -12},
    { 1290, 424, 41},
    { 1423, 524, 0},
    { 1250, 465, 104},
    { 1170, 465, 96},
    { 1182, 389, 170},
    { 1088, 305, 186},
    { 899, 220, 185},
    { 832, 192, 179},
    { 848, 178, 190},
    { 817, 159, 197},
    { 749, 145, 180},
    { 860, 145, 204},
    { 1090, 128, 264},
    { 1111, 186, 205},
    { 1317, 237, 208},
    { 1321, 287, 108},
    { 1160, 471, -217},
    { 1093, 420, -163},
    { 990, 281, -20},
    { 858, 163, 5},
    { 823, 181, 4},
    { 823, 279, 46},
    { 848, 341, 28},
    { 892, 383, -19},
    { 834, 380, -68},
    { 895, 369, -79},
    { 1137, 380, -49},
    { 1248, 355, -21},
    { 1260, 380, 17},
    { 1458, 472, 17},
    { 1226, 496, 12},
    { 1205, 406, 91},
    { 1171, 399, 109},
    { 1092, 328, 161},
    { 969, 271, 184},
    { 887, 227, 182},
    { 863, 207, 168},
    { 858, 181, 175},
    { 833, 164, 166},
    { 772, 159, 128},
    { 856, 151, 162},
    { 983, 125, 178},
    { 1042, 182, 111},
    { 1228, 224, 107},
    { 1449, 277, 132},
    { 1215, 420, -141},
    { 1062, 450, -197},
    { 953, 324, 7},
    { 861, 226, 71},
    { 906, 202, 63},
    { 861, 258, 90},
    { 816, 289, 111},
    { 878, 367, 56},
    { 827, 399, 9},
    { 889, 369, -38},
    { 1015, 341, -37},
    { 1164, 385, -42},
    { 1162, 407, -53},
    { 1275, 488, -11},
    { 1400, 624, -46},
    { 1140, 493, 47},
    { 1056, 453, 45},
    { 1163, 397, 101},
    { 1143, 337, 153},
    { 1003, 246, 192},
    { 921, 200, 206},
    { 904, 178, 217},
    { 890, 167, 234},
    { 814, 179, 181},
    { 852, 186, 184},
    { 989, 161, 208},
    { 985, 148, 174},
    { 1155, 188, 126},
    { 1388, 201, 160},
    { 1116, 336, -134},
    { 1097, 410, -232},
    { 1034, 298, 9},
    { 933, 224, 72},
    { 909, 205, 74},
    { 867, 322, 105},
    { 854, 384, 82},
    { 848, 414, 43},
    { 817, 391, 9},
    { 886, 370, -23},
    { 1058, 399, -26},
    { 1214, 458, -67},
    { 1213, 455, -9},
    { 1355, 540, -16},
    { 1203, 535, -42},
    { 1246, 459, 33},
    { 1207, 404, 78},
    { 1245, 385, 128},
    { 1083, 276, 197},
    { 915, 219, 191},
    { 887, 205, 187},
    { 935, 189, 220},
    { 873, 170, 206},
    { 829, 159, 205},
    { 909, 140, 234},
    { 1006, 127, 260},
    { 1140, 187, 210},
    { 1273, 230, 191},
    { 1118, 357, -128},
    { 1052, 442, -236},
    { 1007, 294, -64},
    { 885, 173, 19},
    { 899, 217, 11},
    { 898, 312, 22},
    { 851, 364, 8},
    { 883, 354, -4},
    { 918, 335, -4},
    { 854, 310, -28},
    { 959, 314, -21},
    { 1164, 395, -19},
    { 1228, 438, -20},
    { 1385, 543, -47},
    { 1253, 567, 47},
    { 1163, 417, 67},
    { 1159, 424, 62},
    { 1133, 406, 101},
    { 1000, 303, 153},
    { 849, 218, 168},
    { 808, 173, 178},
    { 881, 182, 208},
    { 870, 169, 223},
    { 856, 188, 214},
    { 1047, 186, 257},
    { 1128, 160, 276},
    { 1178, 219, 195},
    { 1258, 214, 182},
    { 1104, 267, 29},
    { 949, 383, -186},
    { 1013, 353, -137},
    { 931, 280, -52},
    { 870, 231, -24},
    { 845, 244, -6},
    { 839, 306, 9},
    { 835, 339, -7},
    { 849, 342, -46},
    { 845, 343, -89},
    { 934, 331, -63},
    { 1228, 366, -58},
    { 1245, 372, -8},
    { 1354, 420, 31},
    { 1430, 513, -29},
    { 1253, 416, 107},
    { 1182, 410, 110},
    { 1145, 362, 124},
    { 1005, 323, 168},
    { 857, 236, 191},
    { 795, 204, 179},
    { 797, 180, 193},
    { 786, 169, 195},
    { 733, 175, 155},
    { 826, 181, 159},
    { 1031, 163, 229},
    { 1125, 180, 206},
    { 1258, 246, 156},
    { 1472, 293, 137},
    { 1003, 403, -159},
    { 992, 402, -146},
    { 1018, 275, 72},
    { 914, 188, 82},
    { 875, 208, 77},
    { 816, 289, 97},
    { 818, 344, 80},
    { 830, 376, 27},
    { 805, 355, -22},
    { 859, 345, -61},
    { 1089, 371, -53},
    { 1278, 369, -36},
    { 1246, 334, 33},
    { 1355, 460, 0},
    { 1296, 540, -45},
    { 1174, 407, 72},
    { 1186, 375, 84},
    { 1150, 350, 126},
    { 965, 281, 168},
    { 828, 224, 162},
    { 801, 203, 161},
    { 816, 189, 174},
    { 830, 173, 179},
    { 815, 162, 172},
    { 911, 160, 225},
    { 1026, 174, 230},
    { 1052, 224, 130},
    { 1155, 268, 92},
    { 1350, 295, 90},
    { 1038, 354, -141},
    { 998, 355, -137},
    { 906, 254, 20},
    { 888, 232, 38},
    { 866, 223, 44},
    { 810, 280, 74},
    { 849, 322, 43},
    { 1004, 339, 12},
    { 1001, 328, 17},
    { 1004, 356, -51},
    { 985, 352, -19},
    { 1090, 403, -25},
    { 1177, 431, -2},
    { 1374, 547, -16},
    { 1109, 518, 67},
    { 1053, 450, 58},
    { 1119, 440, 66},
    { 1164, 422, 110},
    { 992, 307, 145},
    { 851, 194, 182},
    { 841, 128, 208},
    { 913, 149, 241},
    { 865, 184, 206},
    { 884, 209, 211},
    { 1113, 196, 278},
    { 1092, 179, 249},
    { 1171, 243, 137},
    { 1329, 237, 169},
    { 962, 321, -115},
    { 909, 337, -162},
    { 960, 260, 0},
    { 922, 209, 34},
    { 883, 219, 33},
    { 880, 297, 44},
    { 896, 344, 38},
    { 910, 362, -16},
    { 861, 362, -58},
    { 836, 328, -51},
    { 1044, 364, -40},
    { 1288, 417, -76},
    { 1203, 377, 35},
    { 1256, 444, 50},
    { 1343, 528, -41},
    { 1344, 434, 112},
    { 1229, 367, 138},
    { 1137, 326, 139},
    { 928, 304, 131},
    { 788, 229, 157},
    { 786, 195, 174},
    { 837, 161, 195},
    { 843, 145, 203},
    { 857, 154, 208},
    { 954, 162, 248},
    { 1066, 176, 224},
    { 1175, 238, 145},
    { 1315, 239, 205},
    { 1188, 353, 30},
    { 1038, 471, -206},
    { 961, 348, -60},
    { 875, 262, 3},
    { 847, 222, 0},
    { 804, 253, 14},
    { 796, 295, 15},
    { 858, 305, 18},
    { 909, 311, 21},
    { 873, 318, 30},
    { 963, 346, 45},
    { 1201, 422, 10},
    { 1177, 440, 0},
    { 1235, 440, 26},
    { 1361, 513, -53},
    { 1210, 389, 109},
    { 1077, 400, 92},
    { 1081, 348, 89},
    { 932, 360, 85},
    { 794, 276, 101},
    { 745, 220, 125},
    { 794, 177, 160},
    { 848, 153, 188},
    { 859, 176, 184},
    { 956, 192, 221},
    { 1183, 194, 262},
    { 1235, 239, 226},
    { 1408, 256, 223},
    { 1154, 317, 63},
    { 901, 435, -185},
    { 918, 342, -82},
    { 895, 217, 30},
    { 821, 145, 52},
    { 771, 217, 46},
    { 755, 291, 33},
    { 810, 313, 22},
    { 825, 300, -13},
    { 775, 293, -34},
    { 984, 309, -15},
    { 1312, 374, -9},
    { 1200, 386, 27},
    { 1317, 457, 21},
    { 1507, 567, -27},
    { 1127, 438, 73},
    { 1095, 417, 65},
    { 1136, 360, 107},
    { 965, 329, 150},
    { 835, 248, 155},
    { 793, 220, 165},
    { 801, 216, 179},
    { 853, 186, 204},
    { 781, 158, 186},
    { 885, 179, 195},
    { 1103, 171, 250},
    { 1161, 192, 217},
    { 1263, 241, 183},
    { 1333, 302, 132},
    { 970, 412, -153},
    { 939, 382, -158},
    { 946, 281, -17},
    { 860, 148, 23},
    { 826, 198, 29},
    { 800, 258, 38},
    { 831, 327, 24},
    { 865, 350, -4},
    { 861, 328, -33},
    { 891, 315, -41},
    { 1068, 331, -28},
    { 1244, 355, -27},
    { 1234, 361, 15},
    { 1339, 446, 16},
    { 1264, 544, -68},
    { 1225, 414, 87},
    { 1174, 413, 102},
    { 1087, 353, 122},
    { 926, 298, 152},
    { 808, 229, 160},
    { 778, 203, 155},
    { 799, 193, 176},
    { 814, 176, 171},
    { 822, 172, 175},
    { 948, 155, 219},
    { 1101, 166, 215},
    { 1157, 220, 130},
    { 1312, 244, 142},
    { 1308, 297, 95},
    { 1009, 399, -166},
    { 970, 347, -112},
    { 964, 305, -4},
    { 862, 202, 30},
    { 825, 221, 36},
    { 820, 269, 63},
    { 831, 321, 51},
    { 854, 340, 14},
    { 809, 323, -12},
    { 849, 327, -43},
    { 1103, 352, -35},
    { 1258, 357, -18},
    { 1267, 369, 27},
    { 1428, 459, 47},
    { 1243, 511, 22},
    { 1148, 464, 50},
    { 1153, 421, 89},
    { 1119, 364, 140},
    { 979, 257, 180},
    { 837, 201, 164},
    { 801, 209, 145},
    { 810, 195, 184},
    { 791, 158, 179},
    { 768, 161, 165},
    { 907, 166, 191},
    { 1162, 164, 244},
    { 1201, 215, 194},
    { 1375, 278, 193},
    { 1259, 330, 37},
    { 984, 448, -192},
    { 907, 331, -72},
    { 937, 226, 29},
    { 866, 165, 49},
    { 834, 227, 44},
    { 824, 303, 53},
    { 862, 359, 22},
    { 873, 366, -8},
    { 842, 341, -27},
    { 938, 314, -14},
    { 1145, 354, -28},
    { 1269, 390, -24},
    { 1415, 434, 49},
    { 1487, 516, 2},
    { 1103, 391, 71},
    { 1054, 394, 71},
    { 1042, 361, 68},
    { 961, 303, 129},
    { 880, 233, 165},
    { 831, 198, 172},
    { 828, 194, 180},
    { 827, 180, 191},
    { 775, 182, 166},
    { 868, 201, 160},
    { 1101, 171, 218},
    { 1112, 177, 184},
    { 1197, 217, 134},
    { 1447, 243, 171},
    { 1032, 334, -32},
    { 932, 444, -198},
    { 983, 338, -56},
    { 930, 244, 7},
    { 843, 187, 33},
    { 795, 232, 35},
    { 795, 309, 35},
    { 828, 343, 16},
    { 820, 346, -21},
    { 817, 324, -38},
    { 990, 337, -8},
    { 1252, 355, 6},
    { 1164, 334, 71},
    { 1176, 401, 41},
    { 1382, 501, -29},
    { 1158, 395, 99},
    { 1157, 388, 86},
    { 1148, 349, 105},
    { 994, 327, 130},
    { 839, 239, 158},
    { 798, 206, 140},
    { 804, 193, 147},
    { 809, 177, 163},
    { 766, 161, 151},
    { 861, 172, 152},
    { 1075, 166, 202},
    { 1159, 192, 178},
    { 1230, 238, 167},
    { 1511, 305, 173},
    { 1052, 420, -100},
    { 942, 421, -133},
    { 939, 293, 39},
    { 859, 194, 72},
    { 792, 184, 51},
    { 742, 244, 48},
    { 769, 298, 48},
    { 815, 323, 23},
    { 817, 310, -16},
    { 884, 317, -21},
    { 1166, 355, -3},
    { 1234, 380, 5},
    { 1262, 400, 21},
    { 1406, 468, 12},
    { 1286, 491, -23},
    { 1059, 408, 7},
    { 1099, 354, 60},
    { 1024, 307, 105},
    { 899, 282, 124},
    { 815, 236, 149},
    { 811, 213, 169},
    { 836, 200, 187},
    { 822, 180, 176},
    { 812, 196, 148},
    { 921, 195, 170},
    { 1156, 175, 214},
    { 1152, 198, 176},
    { 1096, 236, 138},
    { 1418, 339, 115},
    { 915, 378, -99},
    { 979, 397, -90},
    { 1012, 314, 43},
    { 930, 248, 38},
    { 823, 230, 22},
    { 787, 274, 27},
    { 844, 313, 20},
    { 858, 343, -10},
    { 827, 333, -59},
    { 827, 326, -41},
    { 1034, 325, -8},
    { 1238, 346, -4},
    { 1272, 358, 57},
    { 1438, 421, 86},
    { 1310, 454, 37},
    { 1115, 381, 108},
    { 1118, 336, 134},
    { 1020, 313, 118},
    { 969, 294, 141},
    { 850, 218, 163},
    { 792, 201, 136},
    { 797, 188, 156},
    { 769, 174, 162},
    { 762, 165, 165},
    { 801, 167, 155},
    { 905, 178, 177},
    { 1022, 204, 145},
    { 1020, 246, 100},
    { 1505, 264, 173},
    { 1573, 359, 129},
    { 1184, 544, -223},
    { 934, 486, -206},
    { 851, 384, -49},
    { 897, 197, -9},
    { 936, 163, 24},
    { 916, 256, 84},
    { 984, 327, 85},
    { 966, 419, 87},
    { 935, 462, 72},
    { 992, 512, 76},
    { 977, 530, 78},
    { 937, 544, 101},
    { 932, 624, 75},
    { 913, 684, 62},
    { 853, 744, 16},
    { 832, 802, -39},
    { 807, 886, -113},
    { 736, 815, -169},
    { 698, 760, -289},
    { 681, 554, -333},
    { 581, 466, -477},
    { 515, 330, -545},
    { 417, 133, -609},
    { 375, 84, -716},
    { 359, -36, -773},
    { 255, -115, -760},
    { 202, -241, -754},
    { 247, -114, -909},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-09-05 19:50:54 local
AccelRawData *activity_sample_not_moving(int *len) {
  //> TEST_NAME not_moving
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 0
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    { 88, 8, -1000},
    { 88, 16, -1000},
    { 80, 16, -1000},
    { 88, 16, -1000},
    { 88, 16, -1000},
    { 88, 16, -992},
    { 80, 16, -1000},
    { 88, 8, -1000},
    { 88, 0, -1000},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 88, 16, -1008},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 88, 16, -1000},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 24, -1000},
    { 80, 24, -1000},
    { 80, 8, -1000},
    { 80, 8, -1000},
    { 80, 32, -992},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 24, -992},
    { 80, 24, -992},
    { 80, 16, -1000},
    { 80, 16, -1000},
    { 80, 24, -992},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 80, 24, -1000},
    { 72, 16, -1000},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 72, 24, -1008},
    { 72, 8, -1000},
    { 80, 24, -1000},
    { 72, 24, -992},
    { 80, 16, -1000},
    { 80, 24, -1000},
    { 80, 24, -1000},
    { 72, 16, -1000},
    { 80, 24, -1000},
    { 80, 24, -1000},
    { 72, 24, -1000},
    { 80, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 24, -1000},
    { 80, 24, -1008},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 80, 24, -1000},
    { 80, 16, -1000},
    { 72, 8, -1008},
    { 72, 32, -1000},
    { 72, 16, -992},
    { 80, 24, -992},
    { 72, 24, -1000},
    { 80, 16, -1000},
    { 72, 16, -992},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 80, 16, -1000},
    { 72, 16, -1008},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 8, -1000},
    { 72, 24, -1000},
    { 72, 8, -1000},
    { 80, 8, -1008},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 8, -1000},
    { 72, 24, -1000},
    { 80, 16, -1000},
    { 72, 8, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 24, -1000},
    { 80, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 8, -1000},
    { 80, 24, -1000},
    { 72, 24, -1000},
    { 72, 8, -1000},
    { 72, 24, -1000},
    { 72, 16, -1008},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 24, -1008},
    { 72, 16, -1000},
    { 64, 24, -992},
    { 72, 8, -1008},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1008},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 32, -1000},
    { 64, 16, -1000},
    { 72, 24, -992},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 64, 24, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -992},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 72, 16, -1000},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 64, 32, -1000},
    { 64, 16, -1000},
    { 72, 16, -1000},
    { 64, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 16, -1000},
    { 72, 16, -992},
    { 72, 16, -1000},
    { 72, 24, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 8, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 64, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 72, 16, -1000},
    { 72, 8, -1000},
    { 72, 16, -1000},
    { 72, 16, -1000},
    { 72, 8, -1000},
    { 64, 16, -1000},
    { 64, 32, -992},
    { 64, 8, -1000},
    { 72, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1008},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 72, 24, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1008},
    { 64, 24, -1000},
    { 64, 24, -1008},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 72, 16, -1000},
    { 64, 16, -992},
    { 64, 24, -992},
    { 64, 24, -1000},
    { 72, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 32, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1008},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1008},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1008},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 32, -992},
    { 64, 8, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 72, 16, -1000},
    { 64, 24, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 72, 16, -1008},
    { 64, 16, -1000},
    { 64, 16, -1008},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 72, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1008},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 8, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 8, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 32, -992},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 72, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -992},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -992},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 8, -1008},
    { 64, 32, -1000},
    { 64, 8, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -992},
    { 56, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1008},
    { 56, 32, -992},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 64, 24, -992},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1008},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1008},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -992},
    { 56, 24, -1000},
    { 64, 8, -992},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 8, -1008},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -992},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 32, -992},
    { 56, 24, -992},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -992},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 56, 32, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -992},
    { 64, 24, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -992},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 16, -992},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -992},
    { 56, 16, -1000},
    { 64, 0, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1008},
    { 64, 16, -1008},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 8, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1008},
    { 64, 24, -1008},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1008},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -992},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1008},
    { 64, 16, -1000},
    { 64, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1008},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 8, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 64, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 32, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1008},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 8, -1000},
    { 64, 16, -1000},
    { 64, 24, -1008},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 8, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -992},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 64, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 64, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1008},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 8, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 24, -992},
    { 56, 8, -1000},
    { 56, 32, -1000},
    { 56, 8, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 8, -1008},
    { 56, 32, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -992},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 64, 16, -1008},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1008},
    { 64, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 24, -992},
    { 64, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 32, -1008},
    { 56, 24, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 64, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 32, -992},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 64, 24, -992},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 8, -1008},
    { 56, 32, -992},
    { 56, 8, -1000},
    { 64, 16, -992},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 64, 16, -1000},
    { 56, 32, -1000},
    { 56, 8, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 8, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -992},
    { 56, 16, -992},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 8, -1008},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 8, -1008},
    { 48, 24, -992},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 64, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 40, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 8, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -992},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 40, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 48, 24, -1008},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 32, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 56, 16, -992},
    { 56, 16, -1000},
    { 48, 24, -1008},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1008},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1008},
    { 48, 32, -1000},
    { 48, 16, -1008},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1008},
    { 48, 32, -1000},
    { 56, 16, -992},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 56, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -992},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 40, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -1008},
    { 48, 40, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 40, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 48, 24, -992},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 48, 16, -1008},
    { 56, 16, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 8, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -992},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 16, -992},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 40, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -992},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 8, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 24, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 32, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 16, -1008},
    { 48, 32, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 32, -992},
    { 48, 8, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 56, 32, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1008},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 48, 16, -992},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -992},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 56, 24, -992},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1008},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 16, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1008},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1008},
    { 56, 32, -1000},
    { 48, 24, -1008},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 16, -1000},
    { 48, 32, -1008},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -992},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 56, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 48, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 40, -1000},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 40, -992},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 40, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 40, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 40, -992},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -992},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1008},
    { 56, 40, -1000},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1008},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 32, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 40, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 32, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 40, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1008},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 56, 16, -992},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 32, -992},
    { 48, 16, -1008},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -992},
    { 56, 16, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 56, 32, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 40, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 56, 16, -992},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 56, 24, -1008},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 56, 16, -992},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -992},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 40, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 32, -992},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 16, -992},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 40, -992},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 32, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1008},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 56, 16, -1000},
    { 48, 24, -992},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -992},
    { 48, 24, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1008},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 40, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 40, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1008},
    { 48, 16, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 16, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 56, 32, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 40, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 40, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 40, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 40, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 40, -992},
    { 48, 16, -992},
    { 40, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 40, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 48, 16, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 40, 32, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -992},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 16, -1008},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 32, -992},
    { 48, 8, -1000},
    { 56, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -1008},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 40, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -992},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -1008},
    { 48, 16, -1008},
    { 40, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 8, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 40, 16, -1000},
    { 40, 32, -992},
    { 56, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 56, 24, -992},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1008},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1008},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 56, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 40, 16, -992},
    { 40, 16, -1008},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 40, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 40, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1008},
    { 48, 8, -992},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 32, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -992},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1008},
    { 40, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1008},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 40, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 56, 8, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 32, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -992},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 40, -992},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 32, -1000},
    { 48, 8, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 40, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 56, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 40, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 40, 24, -992},
    { 48, 16, -1000},
    { 40, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 40, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -992},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 40, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 40, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1008},
    { 48, 32, -992},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -992},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -992},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 40, 8, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 40, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 40, 32, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 40, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 8, -992},
    { 48, 32, -1000},
    { 40, 8, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 40, -1000},
    { 48, 16, -1000},
    { 40, 16, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 8, -1000},
    { 40, 32, -1000},
    { 40, 8, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 40, 16, -1000},
    { 48, 16, -992},
    { 48, 8, -1008},
    { 48, 40, -1000},
    { 40, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1008},
    { 48, 40, -1000},
    { 48, 8, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 40, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1008},
    { 48, 24, -992},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1008},
    { 48, 40, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 40, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -992},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 40, 8, -1000},
    { 40, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 8, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -992},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 40, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 40, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -992},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -992},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1008},
    { 48, 8, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1008},
    { 48, 40, -1000},
    { 40, 8, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 40, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 56, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -992},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1008},
    { 40, 32, -992},
    { 48, 8, -1008},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 40, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 8, -992},
    { 40, 16, -1008},
    { 40, 16, -1000},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 40, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 40, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 40, 24, -992},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 48, 8, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 16, -1008},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 56, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 56, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 32, -1000},
    { 40, 8, -992},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 40, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 40, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1008},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 48, 8, -1000},
    { 40, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 8, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 56, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -992},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 56, 8, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -992},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 40, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 8, -992},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 8, -1008},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 40, 32, -1000},
    { 40, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 56, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1008},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 40, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 32, -992},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -992},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 8, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1000},
    { 48, 32, -1000},
    { 40, 16, -1000},
    { 40, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 8, -1000},
    { 40, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 8, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 32, -1000},
    { 40, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 40, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1008},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 40, 24, -1000},
    { 40, 16, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 40, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 8, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 8, -1008},
    { 48, 32, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -992},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 32, -992},
    { 40, 8, -1000},
    { 48, 24, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -992},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 40, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -992},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1008},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1008},
    { 40, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 16, -1000},
    { 48, 24, -1008},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -992},
    { 48, 24, -992},
    { 48, 16, -1000},
    { 40, 8, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -992},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 40, 8, -1008},
    { 48, 32, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 16, -1000},
    { 48, 16, -1000},
    { 40, 16, -1000},
    { 40, 16, -1008},
    { 40, 24, -1008},
    { 40, 16, -1000},
    { 48, 16, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
    { 48, 24, -1000},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



