/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */



// ----------------------------------------------------------------
// Sample captured: 2015-10-22 10:35:30 local
AccelRawData *activity_sample_walk_200_pbl_28359_3(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_28359_3
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 180
  //> TEST_EXPECTED_MAX 220
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 176, 152, -968},
    { 104, 112, -976},
    { 200, 88, -968},
    { 296, 88, -992},
    { 416, 32, -920},
    { 168, 24, -944},
    { 208, -120, -984},
    { 104, 160, -952},
    { 216, 32, -952},
    { 232, 104, -944},
    { 184, 184, -976},
    { 216, 256, -984},
    { 248, 296, -960},
    { 240, 312, -888},
    { 208, 328, -920},
    { 248, 320, -920},
    { 216, 296, -952},
    { 112, 208, -976},
    { 112, 160, -944},
    { 24, 64, -1032},
    { 312, 288, -1080},
    { -40, -736, -688},
    { -144, 408, -520},
    { 480, 408, -784},
    { 176, 248, -888},
    // 1 seconds
    { 248, 312, -848},
    { 176, 432, -808},
    { 168, 520, -840},
    { 176, 504, -856},
    { 248, 456, -904},
    { 336, 336, -992},
    { 424, 280, -1008},
    { 496, 424, -832},
    { 432, 376, -552},
    { 256, 504, -576},
    { 136, 664, -440},
    { 96, 952, -400},
    { 144, 856, -360},
    { 224, 976, -296},
    { 208, 936, -232},
    { 240, 880, -192},
    { 288, 928, -104},
    { 288, 944, -64},
    { 280, 960, 56},
    { 328, 872, 136},
    { 256, 1080, 176},
    { 272, 944, 256},
    { 200, 896, 200},
    { 248, 688, 256},
    { 176, 848, 288},
    // 2 seconds
    { 280, 696, 328},
    { 272, 904, 224},
    { 328, 768, 152},
    { 304, 760, 352},
    { 256, 712, 448},
    { 64, 760, 832},
    { 0, 624, 880},
    { -56, 728, 792},
    { -32, 728, 784},
    { 72, 680, 640},
    { 64, 808, 440},
    { 184, 472, 272},
    { 168, 928, 232},
    { -32, 704, 512},
    { -40, 704, 496},
    { -72, 792, 592},
    { -8, 536, 616},
    { -48, 680, 704},
    { -96, 736, 784},
    { -144, 688, 808},
    { -72, 488, 648},
    { -40, 464, 760},
    { -72, 584, 800},
    { -80, 440, 776},
    { -200, 568, 824},
    // 3 seconds
    { -136, 520, 672},
    { -136, 584, 688},
    { -128, 560, 696},
    { -144, 696, 544},
    { -104, 720, 624},
    { -104, 744, 584},
    { -104, 696, 536},
    { -104, 784, 496},
    { -248, 840, 568},
    { -280, 768, 408},
    { -256, 832, 320},
    { -224, 688, 304},
    { -224, 936, 352},
    { -296, 936, 272},
    { -256, 928, 200},
    { -160, 728, 192},
    { -136, 840, 120},
    { -112, 880, 208},
    { -128, 960, 144},
    { -136, 936, 208},
    { -144, 952, 824},
    { -96, 792, 376},
    { -96, 824, 368},
    { -120, 712, 600},
    { -176, 808, 568},
    // 4 seconds
    { -176, 784, 616},
    { -264, 728, 752},
    { -288, 832, 704},
    { -248, 856, 640},
    { -264, 728, 536},
    { -312, 720, 560},
    { -336, 720, 584},
    { -296, 720, 504},
    { -272, 720, 560},
    { -240, 760, 584},
    { -168, 832, 512},
    { -112, 872, 472},
    { -80, 936, 384},
    { -48, 904, 320},
    { -72, 728, 416},
    { -160, 752, 304},
    { -248, 848, 320},
    { -280, 864, 392},
    { -304, 816, 352},
    { -360, 752, 352},
    { -424, 656, 368},
    { -480, 648, 400},
    { -512, 680, 424},
    { -560, 648, 472},
    { -608, 648, 592},
    // 5 seconds
    { -608, 768, 672},
    { -528, 872, 784},
    { -432, 824, 704},
    { -400, 632, 656},
    { -432, 600, 632},
    { -520, 560, 680},
    { -560, 448, 568},
    { -584, 400, 560},
    { -664, 408, 496},
    { -696, 312, 480},
    { -720, 344, 488},
    { -696, 288, 504},
    { -704, 312, 568},
    { -672, 368, 592},
    { -664, 440, 568},
    { -600, 504, 688},
    { -576, 616, 568},
    { -672, 648, 512},
    { -704, 816, 488},
    { -536, 832, 464},
    { -504, 800, 432},
    { -536, 736, 384},
    { -576, 632, 328},
    { -640, 592, 376},
    { -624, 560, 416},
    // 6 seconds
    { -584, 552, 440},
    { -568, 512, 464},
    { -592, 432, 488},
    { -664, 392, 424},
    { -728, 352, 464},
    { -752, 400, 488},
    { -752, 488, 568},
    { -704, 600, 568},
    { -696, 760, 688},
    { -416, 1032, 944},
    { -208, 944, 784},
    { -312, 976, 776},
    { -352, 880, 568},
    { -392, 768, 536},
    { -376, 624, 576},
    { -408, 512, 592},
    { -496, 440, 632},
    { -536, 448, 664},
    { -528, 480, 680},
    { -536, 488, 568},
    { -608, 504, 480},
    { -648, 632, 520},
    { -560, 664, 288},
    { -600, 728, 192},
    { -608, 792, 136},
    // 7 seconds
    { -488, 776, 56},
    { -480, 672, 136},
    { -544, 608, 400},
    { -592, 568, 608},
    { -584, 736, 824},
    { -520, 640, 696},
    { -520, 576, 592},
    { -600, 552, 424},
    { -640, 480, 416},
    { -672, 512, 504},
    { -600, 544, 496},
    { -568, 488, 528},
    { -544, 552, 512},
    { -488, 504, 408},
    { -448, 504, 448},
    { -400, 576, 352},
    { -368, 632, 232},
    { -488, 784, 256},
    { -568, 1016, 160},
    { -760, 1000, -280},
    { -1048, 1072, -168},
    { -672, 1088, -200},
    { -256, 1224, -168},
    { -64, 1144, -96},
    { 40, 872, -216},
    // 8 seconds
    { -24, 752, -192},
    { -80, 672, -176},
    { -168, 792, -240},
    { -272, 720, -240},
    { -408, 880, -248},
    { -544, 864, -240},
    { -592, 960, -288},
    { -592, 880, -216},
    { -544, 680, -216},
    { -472, 712, -280},
    { -272, 680, -296},
    { -16, 744, -384},
    { 280, 816, -336},
    { 728, 784, -552},
    { 936, 912, -648},
    { 984, 568, -664},
    { 888, 376, -632},
    { 720, 1056, -632},
    { 720, 144, -792},
    { 648, 416, -544},
    { 248, 520, -1056},
    { 216, 144, -912},
    { 448, 392, -752},
    { 136, 288, -880},
    { 360, 464, -840},
    // 9 seconds
    { 328, 312, -944},
    { 232, 312, -880},
    { 352, 368, -896},
    { 344, 376, -872},
    { 304, 216, -928},
    { 312, 176, -824},
    { 176, 360, -912},
    { 112, 0, -720},
    { 416, 152, -912},
    { 400, 392, -808},
    { 376, 344, -880},
    { 472, 296, -848},
    { 392, 288, -840},
    { 416, 208, -784},
    { 280, -64, -848},
    { 416, 176, -752},
    { 576, 304, -1216},
    { 528, 648, -56},
    { 376, 488, -864},
    { 384, 280, -776},
    { 496, 168, -944},
    { 472, 16, -1136},
    { 712, -144, -800},
    { 568, -144, -832},
    { 328, 200, -832},
    // 10 seconds
    { 552, 72, -904},
    { 640, -96, -776},
    { 632, 56, -720},
    { 592, 16, -800},
    { 528, 120, -800},
    { 352, 288, -864},
    { 440, 48, -696},
    { 488, 352, -880},
    { 432, 200, -712},
    { 456, 368, -1016},
    { 360, 616, -1200},
    { 128, 728, -1160},
    { 248, 728, -1112},
    { 96, 848, -664},
    { 56, 904, -512},
    { 112, 680, -360},
    { 24, 664, -304},
    { -72, 640, -200},
    { -72, 880, -168},
    { -104, 976, 16},
    { -176, 896, 80},
    { -272, 1000, 96},
    { -368, 960, 144},
    { -432, 920, 200},
    { -496, 968, 128},
    // 11 seconds
    { -464, 968, 88},
    { -416, 912, -8},
    { -520, 1024, -192},
    { -384, 1048, -256},
    { -320, 848, -248},
    { -168, 1040, -472},
    { -32, 1064, -440},
    { 0, 752, -280},
    { -48, 640, -312},
    { -160, 728, -288},
    { -224, 808, -272},
    { -168, 1048, -440},
    { -176, 808, -448},
    { -224, 744, -496},
    { -280, 544, -520},
    { -456, 600, -504},
    { -520, 432, -472},
    { -760, 824, -648},
    { -728, 1248, -728},
    { -648, 1064, -584},
    { -672, 1256, -632},
    { -536, 968, -456},
    { -352, 704, -384},
    { -320, 456, -320},
    { -312, 344, -304},
    // 12 seconds
    { -256, 240, -304},
    { -112, 184, -312},
    { 160, 192, -328},
    { 568, 224, -424},
    { 1632, 16, -696},
    { 1248, 568, -432},
    { 1536, 600, -680},
    { 1864, 704, -784},
    { 1768, 632, -480},
    { 1280, 720, -576},
    { 896, 648, -488},
    { 776, 480, -424},
    { 864, 512, -496},
    { 720, 608, -592},
    { 552, 784, -760},
    { 480, 848, -768},
    { 800, 904, -648},
    { 1296, 800, -472},
    { 1312, 648, -248},
    { 1528, 584, -144},
    { 1488, 456, 40},
    { 1248, 384, 64},
    { 1032, 328, -8},
    { 928, 264, -88},
    { 824, 216, -128},
    // 13 seconds
    { 736, 128, -160},
    { 680, 80, -232},
    { 712, 56, -328},
    { 648, 104, -336},
    { 584, 80, -408},
    { 936, 184, -312},
    { 1192, 352, -352},
    { 1344, 392, -360},
    { 1608, 480, -456},
    { 1368, 368, -280},
    { 976, 448, -424},
    { 832, 416, -368},
    { 840, 448, -184},
    { 808, 320, -224},
    { 896, 336, -184},
    { 856, 512, -280},
    { 992, 528, -328},
    { 1072, 552, -456},
    { 656, 1000, -672},
    { 664, 880, -584},
    { 848, 832, -512},
    { 1240, 768, -408},
    { 1336, 600, -384},
    { 1200, 432, -360},
    { 1168, 320, -360},
    // 14 seconds
    { 1152, 288, -272},
    { 1344, 232, -368},
    { 1408, 168, -288},
    { 1168, 72, -336},
    { 1000, -16, -344},
    { 800, -112, -120},
    { 672, -96, -400},
    { 928, 200, -624},
    { 1176, 224, -552},
    { 1000, 160, -272},
    { 976, 448, -416},
    { 1088, 528, -344},
    { 1280, 616, -464},
    { 1232, 792, -496},
    { 1000, 864, -520},
    { 672, 992, -600},
    { 552, 928, -528},
    { 784, 1072, -440},
    { 1240, 944, -384},
    { 1632, 984, -176},
    { 1720, 752, -112},
    { 1608, 576, -40},
    { 1584, 496, 56},
    { 1352, 344, -152},
    { 1296, 408, -240},
    // 15 seconds
    { 1248, 296, -88},
    { 992, 264, -184},
    { 896, 312, -216},
    { 792, 256, -136},
    { 640, 208, -160},
    { 464, 160, -296},
    { 432, 176, -248},
    { 344, 240, -520},
    { 544, 264, -816},
    { 816, 312, -744},
    { 712, 328, -1000},
    { 600, 784, -1192},
    { 384, 864, -1152},
    { 288, 800, -992},
    { 360, 768, -688},
    { 592, 816, -576},
    { 856, 984, -432},
    { 1256, 1056, -472},
    { 1464, 936, -432},
    { 1608, 616, -304},
    { 1224, 296, -352},
    { 904, 208, -496},
    { 832, -24, -696},
    { 648, -360, -520},
    { 736, -360, -584},
    // 16 seconds
    { 816, -160, -408},
    { 928, -136, -272},
    { 1016, 0, -264},
    { 1696, 224, -56},
    { 1360, 144, -248},
    { 1656, 304, -240},
    { 1648, 336, -16},
    { 1224, 488, -104},
    { 968, 520, -104},
    { 1032, 488, -48},
    { 1120, 608, -48},
    { 1304, 608, -24},
    { 1192, 808, -24},
    { 1016, 976, 72},
    { 656, 952, 80},
    { 568, 1048, -112},
    { 648, 856, 16},
    { 1008, 816, -88},
    { 1312, 704, -136},
    { 1456, 616, -312},
    { 1208, 480, -384},
    { 1400, 472, -528},
    { 1504, 104, -296},
    { 1336, 152, -392},
    { 1176, 144, -432},
    // 17 seconds
    { 920, -16, -256},
    { 576, -88, -296},
    { 992, 168, -208},
    { 1112, 112, -168},
    { 1376, 600, -376},
    { 1552, 440, -112},
    { 1160, 376, -96},
    { 1008, 416, -24},
    { 984, 480, 0},
    { 1128, 536, 0},
    { 1200, 624, 40},
    { 1152, 744, 0},
    { 1008, 936, -24},
    { 936, 888, 32},
    { 920, 1008, -112},
    { 648, 680, -104},
    { 896, 760, -152},
    { 1272, 672, -160},
    { 1536, 624, -240},
    { 1400, 432, -360},
    { 1440, 408, -416},
    { 1456, 208, -336},
    { 1352, 264, -328},
    { 1240, 0, -232},
    { 1056, -88, -112},
    // 18 seconds
    { 760, -96, -48},
    { 896, 144, -248},
    { 824, 104, -136},
    { 1040, 288, -280},
    { 1368, 392, -408},
    { 1360, 368, -184},
    { 1288, 376, -168},
    { 1232, 704, -224},
    { 1360, 704, -208},
    { 1320, 832, -328},
    { 1016, 976, -272},
    { 712, 1056, -456},
    { 584, 1024, -360},
    { 784, 1112, -336},
    { 984, 904, -264},
    { 1296, 824, -192},
    { 1808, 680, -240},
    { 1752, 432, -144},
    { 1584, 440, -360},
    { 1608, 336, -368},
    { 1528, 168, -192},
    { 1160, -72, -216},
    { 976, -128, -176},
    { 744, -168, -176},
    { 656, -128, -320},
    // 19 seconds
    { 944, 136, -216},
    { 1000, 176, -424},
    { 1344, 320, -512},
    { 1400, 472, -504},
    { 1288, 296, -272},
    { 1192, 560, -328},
    { 1232, 704, -392},
    { 1264, 768, -368},
    { 968, 848, -448},
    { 736, 880, -536},
    { 720, 880, -400},
    { 936, 968, -336},
    { 968, 720, -344},
    { 1312, 704, -280},
    { 1664, 656, -216},
    { 1544, 400, -208},
    { 1344, 400, -344},
    { 1296, 96, -88},
    { 1256, 336, -280},
    { 1080, 72, -264},
    { 1072, 48, -216},
    { 896, -96, -160},
    { 864, -72, -360},
    { 1040, -48, -128},
    { 1008, 152, -424},
    // 20 seconds
    { 1216, 200, -504},
    { 1168, 264, -416},
    { 1040, 264, -368},
    { 1080, 392, -312},
    { 1240, 496, -360},
    { 1360, 696, -416},
    { 1264, 888, -504},
    { 960, 1032, -568},
    { 800, 856, -464},
    { 976, 1024, -488},
    { 808, 752, -488},
    { 1032, 688, -400},
    { 1520, 592, -320},
    { 1504, 416, -240},
    { 1384, 336, -320},
    { 1464, 168, -192},
    { 1368, 216, -232},
    { 1176, 40, -208},
    { 1208, -24, -216},
    { 960, -112, -104},
    { 856, -144, -208},
    { 992, 0, -216},
    { 936, 80, -408},
    { 1280, 192, -496},
    { 1256, 224, -456},
    // 21 seconds
    { 1080, 208, -368},
    { 968, 440, -384},
    { 1104, 488, -392},
    { 1264, 616, -416},
    { 1160, 824, -456},
    { 872, 952, -544},
    { 736, 832, -456},
    { 920, 792, -392},
    { 960, 704, -352},
    { 1224, 672, -272},
    { 1536, 568, -192},
    { 1416, 400, -168},
    { 1232, 328, -256},
    { 1264, 264, -256},
    { 1224, 184, -280},
    { 1208, 56, -256},
    { 1192, -24, -264},
    { 960, -168, -168},
    { 896, -144, -336},
    { 1032, -80, -192},
    { 952, 184, -464},
    { 1176, 128, -544},
    { 1080, 272, -392},
    { 984, 240, -344},
    { 1008, 416, -296},
    // 22 seconds
    { 1176, 536, -376},
    { 1216, 608, -416},
    { 1056, 744, -464},
    { 888, 824, -512},
    { 800, 752, -480},
    { 968, 912, -496},
    { 1088, 824, -440},
    { 1200, 728, -360},
    { 1456, 592, -336},
    { 1344, 408, -240},
    { 1272, 320, -272},
    { 1360, 192, -184},
    { 1256, 264, -240},
    { 1192, 128, -224},
    { 1064, 16, -160},
    { 816, -168, -96},
    { 808, -176, -216},
    { 1016, -88, -160},
    { 1040, 208, -432},
    { 1240, 152, -480},
    { 1160, 232, -416},
    { 1056, 248, -352},
    { 1048, 416, -320},
    { 1232, 504, -360},
    { 1344, 664, -408},
    // 23 seconds
    { 1152, 840, -464},
    { 888, 1048, -560},
    { 808, 944, -504},
    { 1008, 1064, -448},
    { 992, 880, -352},
    { 1136, 672, -288},
    { 1456, 664, -256},
    { 1352, 440, -208},
    { 1200, 320, -216},
    { 1312, 288, -248},
    { 1344, 288, -240},
    { 1360, 200, -248},
    { 1232, 24, -192},
    { 960, -216, -112},
    { 880, -240, -232},
    { 1016, -192, -112},
    { 1032, 128, -448},
    { 1288, 152, -448},
    { 1216, 240, -432},
    { 1080, 224, -352},
    { 1080, 456, -280},
    { 1240, 520, -328},
    { 1304, 704, -392},
    { 1200, 872, -416},
    { 864, 1000, -544},
    // 24 seconds
    { 720, 936, -528},
    { 992, 1080, -480},
    { 976, 760, -360},
    { 1240, 840, -320},
    { 1472, 712, -280},
    { 1448, 488, -208},
    { 1240, 360, -224},
    { 1216, 264, -256},
    { 1328, 304, -208},
    { 1400, 264, -248},
    { 1352, 224, -248},
    { 1144, 64, -168},
    { 744, -216, -112},
    { 952, -128, -192},
    { 752, -224, -176},
    { 968, 192, -464},
    { 1208, 112, -440},
    { 1072, 208, -368},
    { 1048, 304, -360},
    { 1200, 464, -304},
    { 1464, 584, -336},
    { 1608, 824, -400},
    { 1336, 936, -424},
    { 848, 1088, -576},
    { 680, 928, -448},
    // 25 seconds
    { 960, 1112, -400},
    { 824, 816, -304},
    { 1072, 744, -256},
    { 1400, 696, -240},
    { 1408, 504, -192},
    { 1192, 416, -240},
    { 1192, 312, -272},
    { 1328, 336, -240},
    { 1464, 264, -216},
    { 1328, 264, -240},
    { 1224, 176, -224},
    { 736, -208, -56},
    { 816, -120, -200},
    { 728, -160, -64},
    { 936, 192, -256},
    { 1112, 176, -328},
    { 1072, 264, -296},
    { 1000, 216, -344},
    { 1056, 344, -240},
    { 1336, 592, -320},
    { 1456, 832, -416},
    { 1304, 1016, -480},
    { 1016, 1168, -552},
    { 952, 1048, -384},
    { 1128, 1112, -328},
    // 26 seconds
    { 992, 792, -240},
    { 1208, 744, -160},
    { 1352, 616, -144},
    { 1168, 416, -144},
    { 1008, 328, -176},
    { 1016, 296, -184},
    { 1240, 336, -184},
    { 1504, 304, -152},
    { 1384, 248, -152},
    { 1136, 72, -112},
    { 640, -184, -176},
    { 912, -80, -88},
    { 864, -120, -120},
    { 968, 256, -320},
    { 1176, 224, -336},
    { 1096, 296, -304},
    { 1032, 272, -304},
    { 1152, 448, -232},
    { 1432, 640, -304},
    { 1528, 808, -248},
    { 1272, 1120, -360},
    { 928, 1168, -344},
    { 696, 976, -304},
    { 832, 952, -240},
    { 928, 864, -184},
    // 27 seconds
    { 1224, 760, -144},
    { 1472, 648, -136},
    { 1312, 448, -120},
    { 1152, 376, -200},
    { 1224, 288, -160},
    { 1392, 352, -144},
    { 1440, 264, -144},
    { 1384, 240, -144},
    { 1040, -88, -72},
    { 1112, -176, -160},
    { 752, -456, -16},
    { 1008, 224, -424},
    { 1360, 24, -216},
    { 1152, 360, -336},
    { 1024, 240, -344},
    { 1096, 384, -192},
    { 1296, 568, -232},
    { 1504, 776, -272},
    { 1400, 1024, -216},
    { 1008, 1224, -360},
    { 688, 1024, -288},
    { 912, 1136, -248},
    { 888, 800, -152},
    { 1000, 800, -200},
    { 1304, 720, -168},
    // 28 seconds
    { 1568, 560, -136},
    { 1288, 408, -168},
    { 1264, 360, -256},
    { 1408, 360, -160},
    { 1408, 264, -128},
    { 1360, 288, -160},
    { 1256, 192, -144},
    { 848, -200, -88},
    { 936, -136, -208},
    { 952, -216, 80},
    { 1008, 224, -280},
    { 1048, 176, -368},
    { 1032, 280, -384},
    { 1008, 208, -352},
    { 1096, 528, -360},
    { 1384, 712, -256},
    { 1448, 1104, -392},
    { 1184, 1008, -232},
    { 896, 1024, -392},
    { 864, 1008, -288},
    { 1080, 1168, -248},
    { 896, 848, -176},
    { 1072, 896, -176},
    { 1320, 712, -160},
    { 1416, 528, -72},
    // 29 seconds
    { 1184, 408, -160},
    { 1096, 232, -128},
    { 1224, 360, -120},
    { 1448, 280, -88},
    { 1456, 264, -120},
    { 1344, 232, -88},
    { 992, -96, -120},
    { 1080, -112, 88},
    { 720, -320, -256},
    { 1112, 280, -384},
    { 1280, 40, -176},
    { 968, 312, -376},
    { 920, 272, -400},
    { 1048, 352, -168},
    { 1416, 592, -264},
    { 1696, 776, -232},
    { 1440, 1168, -208},
    { 1056, 1080, -240},
    { 624, 1000, -168},
    { 864, 1032, -160},
    { 768, 888, -96},
    { 1016, 840, -128},
    { 1384, 752, -112},
    { 1432, 592, -112},
    { 1264, 432, -152},
    // 30 seconds
    { 1224, 336, -192},
    { 1416, 352, -144},
    { 1576, 296, -104},
    { 1344, 280, -152},
    { 1216, 224, -176},
    { 1064, -224, -112},
    { 1000, -304, 152},
    { 984, -184, -360},
    { 1280, -88, -240},
    { 1240, 200, -208},
    { 888, 192, -368},
    { 848, 296, -296},
    { 1080, 392, -232},
    { 1456, 584, -320},
    { 1704, 856, -320},
    { 1368, 1016, -240},
    { 944, 1240, -320},
    { 720, 904, -176},
    { 1048, 1048, -216},
    { 840, 848, -168},
    { 1056, 776, -136},
    { 1520, 744, -96},
    { 1432, 512, -72},
    { 1168, 384, -160},
    { 1184, 304, -160},
    // 31 seconds
    { 1312, 392, -136},
    { 1504, 256, -80},
    { 1432, 272, -80},
    { 1128, 152, -80},
    { 728, -40, -160},
    { 1048, -24, -80},
    { 784, -280, -168},
    { 968, 176, -440},
    { 1096, 80, -256},
    { 976, 240, -272},
    { 960, 256, -248},
    { 1080, 416, -168},
    { 1448, 576, -232},
    { 1656, 744, -232},
    { 1424, 1080, -280},
    { 1048, 1104, -336},
    { 704, 1112, -328},
    { 1040, 1144, -288},
    { 864, 928, -208},
    { 1080, 768, -160},
    { 1288, 672, -136},
    { 1176, 488, -104},
    { 1048, 360, -160},
    { 1120, 312, -176},
    { 1304, 352, -144},
    // 32 seconds
    { 1688, 320, -136},
    { 1512, 256, -64},
    { 1224, 64, -112},
    { 864, -280, -152},
    { 936, -368, 104},
    { 936, -88, -400},
    { 1264, -64, -240},
    { 1240, 320, -328},
    { 976, 200, -360},
    { 984, 384, -296},
    { 1192, 440, -272},
    { 1344, 744, -272},
    { 1368, 1008, -200},
    { 1200, 1024, -224},
    { 824, 1224, -224},
    { 688, 808, -200},
    { 1008, 1176, -120},
    { 1160, 864, -104},
    { 1200, 760, -128},
    { 1488, 608, -136},
    { 1272, 408, -64},
    { 1104, 336, -224},
    { 1160, 256, -160},
    { 1312, 328, -144},
    { 1376, 272, -144},
    // 33 seconds
    { 1320, 248, -152},
    { 992, -72, -136},
    { 768, -152, -304},
    { 880, -328, -104},
    { 1128, 112, -456},
    { 1392, 80, -400},
    { 1224, 256, -368},
    { 1104, 256, -352},
    { 1128, 488, -248},
    { 1232, 552, -256},
    { 1288, 680, -384},
    { 1288, 816, -296},
    { 1112, 960, -496},
    { 800, 960, -592},
    { 696, 936, -504},
    { 1128, 1112, -504},
    { 952, 720, -376},
    { 1296, 680, -288},
    { 1696, 544, -208},
    { 1592, 408, -168},
    { 1416, 312, -240},
    { 1344, 136, -88},
    { 1232, 264, -192},
    { 1184, 168, -256},
    { 1320, 80, -208},
    // 34 seconds
    { 1048, -96, -104},
    { 656, -264, -192},
    { 872, -96, -176},
    { 768, -40, -344},
    { 1184, 176, -304},
    { 1536, 280, -480},
    { 1488, 312, -288},
    { 1360, 568, -336},
    { 1272, 608, -296},
    { 1360, 688, -320},
    { 1320, 832, -256},
    { 1032, 832, -304},
    { 800, 968, -464},
    { 672, 912, -368},
    { 1000, 1040, -384},
    { 936, 712, -368},
    { 1192, 736, -288},
    { 1544, 608, -272},
    { 1488, 344, -200},
    { 1392, 368, -296},
    { 1264, 112, -104},
    { 1392, 416, -288},
    { 1408, 232, -256},
    { 1368, 200, -192},
    { 1160, -24, -104},
    // 35 seconds
    { 880, -200, -136},
    { 800, -216, -48},
    { 768, 24, -392},
    { 1152, 16, -256},
    { 1320, 208, -304},
    { 1136, 224, -416},
    { 1056, 328, -352},
    { 1200, 424, -264},
    { 1456, 576, -320},
    { 1616, 744, -272},
    { 1368, 904, -336},
    { 1016, 968, -408},
    { 736, 856, -344},
    { 936, 992, -360},
    { 736, 704, -264},
    { 1064, 752, -224},
    { 1368, 648, -216},
    { 1344, 408, -112},
    { 1176, 376, -168},
    { 1240, 280, -152},
    { 1384, 328, -128},
    { 1480, 256, -120},
    { 1568, 280, -104},
    { 1264, 8, 0},
    { 880, -328, -40},
    // 36 seconds
    { 952, -288, 56},
    { 816, -112, -312},
    { 1224, 64, -304},
    { 1312, 288, -272},
    { 1008, 168, -344},
    { 888, 288, -336},
    { 992, 400, -264},
    { 1224, 496, -336},
    { 1456, 640, -328},
    { 1304, 864, -392},
    { 976, 864, -408},
    { 736, 832, -368},
    { 1120, 864, -392},
    { 936, 736, -288},
    { 1120, 784, -208},
    { 1336, 664, -272},
    { 1200, 480, -200},
    { 1088, 320, -192},
    { 1184, 184, -216},
    { 1224, 232, -104},
    { 1336, 256, -208},
    { 1464, 256, -192},
    { 1288, 144, -152},
    { 824, -120, -216},
    { 920, -96, -152},
    // 37 seconds
    { 864, -160, -272},
    { 872, 168, -472},
    { 1136, 160, -368},
    { 1032, 200, -360},
    { 968, 264, -280},
    { 984, 432, -176},
    { 1184, 544, -224},
    { 1440, 656, -168},
    { 1312, 824, -176},
    { 1008, 1040, -208},
    { 784, 864, -184},
    { 1000, 1072, -136},
    { 872, 832, -176},
    { 1080, 800, -144},
    { 1232, 680, -176},
    { 1152, 544, -144},
    { 1008, 376, -216},
    { 1032, 288, -256},
    { 1296, 336, -208},
    { 1672, 272, -200},
    { 1576, 232, -144},
    { 1256, 264, -216},
    { 960, -64, -184},
    { 808, -240, 56},
    { 648, -224, -408},
    // 38 seconds
    { 848, 200, -440},
    { 1208, 144, -216},
    { 888, 208, -544},
    { 792, 144, -328},
    { 936, 192, -128},
    { 1248, 504, -368},
    { 1480, 656, -312},
    { 1472, 936, -520},
    { 1288, 1104, -576},
    { 736, 1072, -544},
    { 928, 920, -624},
    { 832, 760, -400},
    { 936, 832, -352},
    { 1208, 608, -288},
    { 1240, 432, -232},
    { 1056, 384, -216},
    { 1152, 288, -288},
    { 1296, 264, -224},
    { 1488, 352, -184},
    { 1520, 240, -176},
    { 1200, 56, 8},
    { 480, -648, 80},
    { 1024, 128, -168},
    { 952, -184, -168},
    { 1200, 48, -368},
    // 39 seconds
    { 1216, 160, -392},
    { 1024, 96, -328},
    { 920, 240, -392},
    { 1040, 376, -288},
    { 1328, 520, -328},
    { 1456, 672, -392},
    { 1328, 856, -432},
    { 1088, 1064, -600},
    { 792, 824, -440},
    { 936, 1008, -536},
    { 776, 688, -336},
    { 1008, 712, -296},
    { 1288, 592, -280},
    { 1272, 464, -216},
    { 1144, 360, -216},
    { 1152, 304, -208},
    { 1264, 312, -192},
    { 1504, 304, -128},
    { 1456, 232, -104},
    { 1296, 96, -88},
    { 800, -472, -72},
    { 1040, -392, 64},
    { 1192, -176, -280},
    { 1328, -64, -304},
    { 1192, 304, -344},
    // 40 seconds
    { 912, 120, -280},
    { 984, 304, -248},
    { 1224, 496, -192},
    { 1632, 672, -200},
    { 1584, 1208, -256},
    { 1112, 1344, -312},
    { 664, 1208, -272},
    { 568, 1176, -120},
    { 952, 944, -40},
    { 1080, 816, -112},
    { 1304, 760, -32},
    { 1584, 704, 16},
    { 1360, 432, -32},
    { 1248, 400, -88},
    { 1336, 400, -80},
    { 1512, 376, -64},
    { 1464, 272, -8},
    { 1256, 280, -8},
    { 1080, 88, -128},
    { 600, -320, -288},
    { 984, -320, 104},
    { 1112, -216, -184},
    { 1112, 160, -296},
    { 1304, 344, -320},
    { 1120, 336, -312},
    // 41 seconds
    { 1112, 288, -264},
    { 1328, 496, -192},
    { 1744, 712, -232},
    { 1688, 1000, -120},
    { 1256, 1296, -208},
    { 808, 1280, -248},
    { 616, 1080, -120},
    { 952, 1224, -88},
    { 968, 848, -8},
    { 1216, 792, -32},
    { 1424, 736, -32},
    { 1472, 552, -40},
    { 1208, 376, -80},
    { 1144, 312, -144},
    { 1296, 392, -120},
    { 1504, 336, -88},
    { 1488, 208, -72},
    { 1192, 216, -88},
    { 696, -176, -112},
    { 704, 64, -328},
    { 688, -200, -24},
    { 832, 112, -304},
    { 856, 152, -368},
    { 960, 184, -352},
    { 992, 264, -392},
    // 42 seconds
    { 1056, 384, -344},
    { 1400, 384, -464},
    { 1640, 888, -752},
    { 1424, 480, -496},
    { 1232, 880, -656},
    { 1064, 776, -640},
    { 816, 1032, -776},
    { 928, 880, -552},
    { 832, 1032, -480},
    { 1176, 560, -488},
    { 1592, 672, -352},
    { 1296, 400, -280},
    { 1248, 304, -248},
    { 1328, 280, -256},
    { 1448, 280, -168},
    { 1472, 176, -144},
    { 1280, 176, -88},
    { 896, -64, 0},
    { 680, -216, -80},
    { 928, -184, 56},
    { 832, -88, -240},
    { 1040, 192, -312},
    { 1312, 152, -200},
    { 1208, 312, -336},
    { 1168, 296, -288},
    // 43 seconds
    { 1280, 472, -280},
    { 1528, 592, -328},
    { 1600, 744, -392},
    { 1408, 1016, -528},
    { 920, 1184, -672},
    { 648, 952, -584},
    { 856, 1080, -592},
    { 872, 752, -336},
    { 1184, 944, -304},
    { 1616, 752, -256},
    { 1648, 512, -160},
    { 1368, 416, -176},
    { 1296, 328, -224},
    { 1384, 320, -168},
    { 1488, 304, -176},
    { 1408, 256, -136},
    { 1160, 96, -96},
    { 736, -432, -24},
    { 1056, -216, 0},
    { 792, -296, -144},
    { 1056, 200, -280},
    { 1376, 200, -168},
    { 1248, 368, -288},
    { 1232, 272, -224},
    { 1344, 512, -192},
    // 44 seconds
    { 1568, 656, -168},
    { 1600, 880, -168},
    { 1360, 984, -232},
    { 984, 1240, -288},
    { 592, 1280, -296},
    { 936, 1248, -176},
    { 984, 856, -104},
    { 1184, 888, -112},
    { 1440, 728, -104},
    { 1576, 592, -88},
    { 1408, 432, -128},
    { 1336, 360, -144},
    { 1352, 360, -128},
    { 1416, 320, -80},
    { 1464, 264, -96},
    { 1304, 248, -72},
    { 976, -120, -24},
    { 840, -144, -168},
    { 632, -456, 64},
    { 984, 72, -320},
    { 1152, 48, -208},
    { 1312, 360, -280},
    { 1128, 232, -280},
    { 1160, 384, -280},
    { 1336, 544, -280},
    // 45 seconds
    { 1664, 704, -304},
    { 1672, 888, -320},
    { 1304, 1032, -456},
    { 976, 1088, -512},
    { 760, 960, -424},
    { 984, 1152, -336},
    { 920, 888, -280},
    { 1072, 744, -288},
    { 1384, 696, -232},
    { 1336, 464, -128},
    { 1208, 336, -208},
    { 1208, 296, -208},
    { 1280, 312, -144},
    { 1512, 320, -120},
    { 1520, 208, -56},
    { 1184, 272, -88},
    { 968, -144, -192},
    { 904, -88, 48},
    { 720, -352, -232},
    { 1008, 136, -304},
    { 1200, 104, -256},
    { 1064, 272, -256},
    { 992, 264, -304},
    { 1200, 464, -288},
    { 1632, 608, -320},
    // 46 seconds
    { 1832, 880, -456},
    { 1528, 880, -432},
    { 976, 1368, -704},
    { 680, 808, -608},
    { 880, 1208, -488},
    { 840, 912, -384},
    { 1200, 696, -312},
    { 1496, 680, -224},
    { 1344, 456, -216},
    { 1192, 304, -216},
    { 1240, 288, -200},
    { 1496, 336, -144},
    { 1440, 280, -152},
    { 1344, 288, -168},
    { 1104, -72, -16},
    { 576, -368, -160},
    { 984, -288, -32},
    { 976, -184, -192},
    { 1216, 80, -280},
    { 1368, 232, -304},
    { 1216, 256, -248},
    { 1104, 320, -320},
    { 1304, 408, -248},
    { 1520, 640, -264},
    { 1552, 864, -264},
    // 47 seconds
    { 1248, 1128, -344},
    { 856, 1168, -440},
    { 640, 952, -304},
    { 880, 1088, -376},
    { 1000, 784, -184},
    { 1240, 840, -184},
    { 1456, 712, -120},
    { 1464, 496, -96},
    { 1232, 352, -128},
    { 1232, 328, -152},
    { 1392, 360, -112},
    { 1512, 296, -72},
    { 1344, 224, -56},
    { 1080, 232, -112},
    { 776, -328, -16},
    { 1048, -136, 72},
    { 808, -88, -288},
    { 1112, 0, -272},
    { 1328, 272, -264},
    { 1080, 232, -288},
    { 1048, 232, -320},
    { 1216, 440, -232},
    { 1512, 592, -296},
    { 1496, 944, -296},
    { 1248, 1024, -256},
    // 48 seconds
    { 944, 1352, -296},
    { 736, 1096, -128},
    { 1168, 1088, -80},
    { 776, 712, -16},
    { 1176, 768, -40},
    { 1360, 664, 0},
    { 1304, 456, -32},
    { 1072, 352, -88},
    { 1048, 312, -104},
    { 1216, 328, -128},
    { 1376, 304, -128},
    { 1376, 248, -144},
    { 1304, 144, -184},
    { 800, -392, -112},
    { 1208, -80, -104},
    { 728, -360, -280},
    { 1016, 168, -416},
    { 1352, 144, -240},
    { 1088, 256, -312},
    { 928, 232, -352},
    { 1040, 400, -224},
    { 1296, 576, -264},
    { 1472, 720, -264},
    { 1344, 928, -296},
    { 1056, 1040, -360},
    // 49 seconds
    { 800, 1120, -376},
    { 1120, 1104, -328},
    { 896, 728, -200},
    { 976, 800, -280},
    { 1288, 656, -208},
    { 1528, 560, -208},
    { 1304, 416, -184},
    { 1184, -8, -168},
    { 1080, 376, -128},
    { 1200, 256, -176},
    { 1424, 264, -120},
    { 1384, 200, -40},
    { 1128, -72, 64},
    { 904, -168, -152},
    { 632, -320, -40},
    { 1056, 72, -304},
    { 1264, 40, -192},
    { 1272, 384, -304},
    { 1136, 176, -280},
    { 1112, 368, -312},
    { 1288, 512, -248},
    { 1456, 632, -400},
    { 1464, 864, -352},
    { 1120, 976, -568},
    { 808, 984, -664},
    // 50 seconds
    { 696, 768, -504},
    { 952, 1072, -472},
    { 848, 704, -344},
    { 1072, 752, -304},
    { 1488, 640, -248},
    { 1432, 424, -136},
    { 1288, 320, -184},
    { 1248, 304, -184},
    { 1400, 328, -168},
    { 1376, 248, -112},
    { 1224, 248, -144},
    { 1144, 232, -176},
    { 760, -192, -48},
    { 712, -232, -240},
    { 792, -320, 0},
    { 976, 32, -328},
    { 1272, 128, -360},
    { 1384, 384, -360},
    { 1256, 184, -320},
    { 1216, 360, -344},
    { 1344, 520, -272},
    { 1512, 752, -336},
    { 1392, 904, -368},
    { 1096, 1144, -440},
    { 680, 1112, -480},
    // 51 seconds
    { 632, 760, -304},
    { 992, 1112, -272},
    { 1104, 752, -120},
    { 1328, 792, -216},
    { 1544, 704, -120},
    { 1464, 488, -64},
    { 1248, 384, -144},
    { 1248, 344, -168},
    { 1448, 360, -136},
    { 1568, 280, -96},
    { 1296, 216, -144},
    { 1120, -136, 16},
    { 632, -336, -40},
    { 1008, -336, 16},
    { 1080, -128, -88},
    { 1304, 240, -376},
    { 1432, 352, -336},
    { 1168, 240, -296},
    { 1024, 272, -272},
    { 1144, 400, -216},
    { 1400, 608, -232},
    { 1496, 800, -272},
    { 1288, 1128, -296},
    { 984, 1072, -360},
    { 600, 1040, -304},
    // 52 seconds
    { 1008, 1120, -224},
    { 960, 776, -96},
    { 1256, 864, -200},
    { 1496, 736, -120},
    { 1384, 480, -64},
    { 1192, 384, -104},
    { 1216, 336, -136},
    { 1376, 368, -136},
    { 1600, 328, -64},
    { 1520, 240, -48},
    { 1264, 248, -96},
    { 880, -152, -96},
    { 544, -232, -248},
    { 648, -408, 72},
    { 928, -112, -176},
    { 1064, 128, -256},
    { 1328, 424, -336},
    { 1248, 288, -264},
    { 1312, 376, -280},
    { 1464, 624, -304},
    { 1592, 776, -360},
    { 1352, 928, -448},
    { 936, 1080, -608},
    { 608, 1104, -720},
    { 768, 928, -576},
    // 53 seconds
    { 1280, 992, -368},
    { 1232, 848, -320},
    { 1424, 696, -320},
    { 1608, 568, -208},
    { 1464, 424, -88},
    { 1272, 288, -128},
    { 1360, 328, -128},
    { 1432, 296, -80},
    { 1520, 280, -56},
    { 1424, 272, -56},
    { 1016, -64, 72},
    { 840, -152, 32},
    { 424, -312, 0},
    { 552, 80, -280},
    { 768, 56, -280},
    { 1160, 288, -272},
    { 1200, 256, -360},
    { 1208, 280, -376},
    { 1312, 408, -376},
    { 1384, 552, -552},
    { 1352, 672, -712},
    { 1088, 864, -872},
    { 832, 704, -888},
    { 792, 576, -728},
    { 1456, 808, -720},
    // 54 seconds
    { 1024, 424, -280},
    { 1248, 944, -448},
    { 1664, 576, -256},
    { 1320, 448, 32},
    { 1192, 408, -72},
    { 1264, 400, -16},
    { 1456, 376, -16},
    { 1504, 440, 64},
    { 1600, 416, 0},
    { 1368, 352, 16},
    { 920, -96, 144},
    { 552, -408, 80},
    { 592, -352, -128},
    { 752, -8, -488},
    { 1080, -128, -376},
    { 1288, 408, -648},
    { 1072, 40, -464},
    { 1136, 176, -440},
    { 1312, 456, -496},
    { 1488, 624, -664},
    { 1448, 952, -848},
    { 872, 992, -848},
    { 616, 1512, -992},
    { 656, 888, -584},
    { 952, 1440, -448},
    // 55 seconds
    { 1480, 848, -248},
    { 1816, 928, -240},
    { 2432, 856, -120},
    { 2176, 528, 16},
    { 1600, 384, -104},
    { 1592, 392, -232},
    { 1568, 376, -184},
    { 1400, 264, -256},
    { 1416, 216, -312},
    { 816, -728, -104},
    { 488, -640, -264},
    { 696, -736, -8},
    { 1160, -184, -224},
    { 1264, -104, -152},
    { 1376, 352, -224},
    { 1264, 336, -264},
    { 1376, 400, -168},
    { 1680, 576, -168},
    { 2024, 936, -312},
    { 2008, 1144, -224},
    { 1528, 1536, -336},
    { 536, 1872, -352},
    { 896, 1104, -360},
    { 744, 1240, -264},
    { 760, 824, -152},
    // 56 seconds
    { 1112, 800, -112},
    { 1648, 736, -64},
    { 1472, 488, -24},
    { 1432, 464, -112},
    { 1568, 416, -152},
    { 1712, 384, -24},
    { 1648, 336, -80},
    { 1408, 312, -168},
    { 1120, -112, -104},
    { 616, -392, -232},
    { 976, -760, 288},
    { 1296, -280, -104},
    { 1280, -24, -240},
    { 1296, 168, -96},
    { 1032, 352, -312},
    { 976, 288, -312},
    { 1248, 424, -232},
    { 1624, 640, -392},
    { 1696, 1040, -488},
    { 1392, 1240, -640},
    { 1000, 1248, -616},
    { 584, 944, -576},
    { 656, 1008, -408},
    { 944, 960, -304},
    { 1584, 808, -144},
    // 57 seconds
    { 1736, 624, -128},
    { 1488, 480, -88},
    { 1352, 440, -120},
    { 1496, 392, -176},
    { 1592, 360, -72},
    { 1480, 296, -152},
    { 1384, 192, -176},
    { 776, -616, 24},
    { 776, -512, -128},
    { 1072, -624, 336},
    { 1408, 0, -200},
    { 1600, 72, -216},
    { 1488, 544, -272},
    { 1312, 320, -248},
    { 1424, 512, -200},
    { 1664, 744, -248},
    { 1704, 864, -256},
    { 1480, 1128, -288},
    { 1008, 1256, -480},
    { 648, 1168, -416},
    { 656, 1064, -400},
    { 840, 920, -216},
    { 1128, 904, -240},
    { 1464, 776, -160},
    { 1816, 664, -152},
    // 58 seconds
    { 1632, 472, -120},
    { 1480, 472, -176},
    { 1536, 576, -168},
    { 1608, 624, -88},
    { 1600, 832, -216},
    { 1416, 616, -168},
    { 984, 280, -240},
    { 704, 496, -448},
    { 552, 40, -392},
    { -8, -112, -632},
    { 104, -328, -784},
    { -40, -264, -632},
    { 0, -400, -592},
    { -32, -624, -600},
    { -104, -624, -640},
    { -144, -616, -744},
    { -208, -688, -880},
    { -192, -648, -968},
    { -104, -544, -1168},
    { -136, -584, -1112},
    { -56, -536, -1280},
    { -200, -384, -1120},
    { -272, -320, -1112},
    { -56, -264, -1056},
    { 8, -288, -816},
    // 59 seconds
    { 0, -304, -656},
    { 24, -304, -560},
    { 48, -312, -488},
    { 104, -344, -448},
    { 288, -328, -472},
    { 520, -352, -400},
    { 784, -128, -304},
    { 1624, 392, -376},
    { 2008, 896, -328},
    { 2184, 1048, -296},
    { 1800, 752, -896},
    { 1568, 736, -256},
    { 1392, 544, -168},
    { 1200, 704, -224},
    { 1160, 816, -168},
    { 1040, 800, -128},
    { 728, 1088, -176},
    { 520, 1136, -296},
    { 504, 912, -224},
    { 968, 1032, -288},
    { 1336, 728, -136},
    { 1816, 896, -168},
    { 2168, 720, -144},
    { 2000, 480, -96},
    { 1712, 424, -168},
    // 60 seconds
    // elapsed: 1 minutes
    { 1488, 96, 40},
    { 1528, 568, -168},
    { 1296, 200, -104},
    { 1264, 216, -72},
    { 1040, -88, 56},
    { 512, -376, 24},
    { 1000, -96, -64},
    { 888, -120, -168},
    { 1160, 232, -288},
    { 1488, 368, -344},
    { 1488, 352, -288},
    { 1488, 384, -240},
    { 1512, 648, -280},
    { 1544, 696, -296},
    { 1488, 768, -376},
    { 1232, 1008, -376},
    { 816, 1128, -432},
    { 616, 1040, -400},
    { 976, 1360, -320},
    { 1152, 816, -128},
    { 1408, 936, -136},
    { 1616, 744, -144},
    { 1528, 512, -144},
    { 1360, 432, -184},
    { 1336, 360, -176},
    // 61 seconds
    { 1408, 352, -208},
    { 1392, 304, -120},
    { 1416, 240, -112},
    { 1112, 176, -64},
    { 728, -144, 96},
    { 696, -288, -48},
    { 752, -312, 0},
    { 1248, 232, -344},
    { 1584, 160, -256},
    { 1512, 432, -440},
    { 1384, 120, -256},
    { 1464, 480, -288},
    { 1480, 856, -576},
    { 1536, 712, -520},
    { 1568, 736, -728},
    { 1168, 880, -944},
    { 624, 744, -904},
    { 808, 976, -944},
    { 808, 696, -544},
    { 1312, 872, -528},
    { 1840, 696, -304},
    { 1856, 528, -240},
    { 1576, 360, -240},
    { 1408, 296, -216},
    { 1472, 360, -192},
    // 62 seconds
    { 1496, 320, -208},
    { 1432, 248, -160},
    { 1288, 96, -48},
    { 648, -512, 40},
    { 1056, -160, 48},
    { 1024, -256, -160},
    { 1216, 184, -264},
    { 1296, 232, -224},
    { 1176, 232, -312},
    { 1176, 320, -240},
    { 1384, 472, -240},
    { 1624, 608, -328},
    { 1736, 816, -392},
    { 1464, 952, -536},
    { 1048, 1088, -600},
    { 704, 1280, -632},
    { 768, 1168, -400},
    { 968, 1008, -320},
    { 1296, 840, -304},
    { 1568, 880, -360},
    { 1544, 904, -400},
    { 1784, 880, -296},
    { 1992, 1024, -232},
    { 2088, 1176, 8},
    { 1832, 904, -40},
    // 63 seconds
    { 1344, 624, -24},
    { 952, 48, -64},
    { 480, -184, -168},
    { 352, -448, -152},
    { -80, -432, -432},
    { 24, -528, -696},
    { 104, -520, -728},
    { 104, -432, -704},
    { 16, -464, -792},
    { -128, -520, -776},
    { -216, -544, -816},
    { -248, -560, -1008},
    { -264, -608, -1088},
    { -144, -504, -1240},
    { -96, -560, -1160},
    { -112, -464, -1216},
    { -120, -336, -1152},
    { -160, -240, -1072},
    { 40, -208, -1056},
    { 104, -256, -848},
    { 96, -328, -760},
    { 72, -336, -712},
    { 96, -352, -712},
    { 160, -408, -760},
    { 264, -344, -928},
    // 64 seconds
    { 248, -408, -1064},
    { 224, -416, -1120},
    { 280, -384, -1272},
    { 240, -208, -1200},
    { 312, -280, -1040},
    { 352, -176, -928},
    { 272, -200, -680},
    { 192, -200, -656},
    { 8, -280, -680},
    { -88, -352, -912},
    { -136, -328, -1128},
    { -168, -296, -1304},
    { -16, -248, -1464},
    { -88, -152, -1456},
    { 104, -72, -1392},
    { 80, 16, -1272},
    { 80, 88, -1248},
    { 136, -32, -1032},
    { 112, -136, -808},
    { 104, -216, -664},
    { 128, -192, -584},
    { 192, -176, -552},
    { 360, -176, -552},
    { 536, -200, -568},
    { 616, -184, -592},
    // 65 seconds
    { 864, -48, -616},
    { 992, 104, -808},
    { 1120, 32, -576},
    { 1288, 224, -624},
    { 1248, 248, -528},
    { 944, 168, -392},
    { 840, 352, -416},
    { 920, 224, -496},
    { 928, 136, -664},
    { 1024, 248, -944},
    { 1152, 528, -1312},
    { 976, 488, -944},
    { 1288, 720, -952},
    { 1024, 448, -744},
    { 1208, 568, -560},
    { 1480, 416, -496},
    { 1104, 168, -280},
    { 864, 224, -296},
    { 952, 232, -352},
    { 1232, 160, -336},
    { 1320, 112, -304},
    { 1288, 96, -272},
    { 1024, 32, -152},
    { 504, -560, 0},
    { 1008, 216, -328},
    // 66 seconds
    { 952, -64, -536},
    { 1328, 104, -304},
    { 1384, 208, -368},
    { 1192, 144, -360},
    { 1096, 384, -264},
    { 1152, 520, -168},
    { 1376, 632, -216},
    { 1392, 896, -144},
    { 1120, 1104, -176},
    { 752, 1056, -184},
    { 792, 1160, -168},
    { 904, 736, -152},
    { 1248, 920, -168},
    { 1408, 648, -200},
    { 1448, 552, -264},
    { 1224, 352, -176},
    { 1200, 368, -312},
    { 1424, 176, -256},
    { 1704, 336, -168},
    { 1520, 136, -192},
    { 1440, 232, -168},
    { 896, -400, 136},
    { 832, -208, -152},
    { 776, -312, -24},
    { 976, 136, -280},
    // 67 seconds
    { 1224, 80, -184},
    { 1200, 368, -304},
    { 1096, 256, -296},
    { 1192, 432, -120},
    { 1400, 672, -224},
    { 1600, 912, -264},
    { 1408, 1024, -136},
    { 920, 1360, -272},
    { 520, 1296, -288},
    { 624, 1056, -168},
    { 1032, 1104, -136},
    { 1400, 928, -112},
    { 1664, 824, -48},
    { 1736, 632, -64},
    { 1336, 440, -120},
    { 1232, 368, -208},
    { 1400, 360, -200},
    { 1592, 328, -168},
    { 1496, 240, -176},
    { 1312, 152, -200},
    { 712, -448, -16},
    { 616, -224, -272},
    { 656, -256, 16},
    { 1080, 232, -256},
    { 1352, 232, -352},
    // 68 seconds
    { 1528, 368, -408},
    { 1472, 264, -280},
    { 1392, 448, -304},
    { 1496, 648, -232},
    { 1560, 744, -280},
    { 1464, 936, -192},
    { 1176, 1288, -184},
    { 824, 1224, -232},
    { 568, 1072, -136},
    { 776, 1000, -136},
    { 792, 824, -96},
    { 1368, 872, -32},
    { 1872, 824, 24},
    { 1680, 432, 48},
    { 1472, 336, -104},
    { 1456, 352, -136},
    { 1440, 408, -208},
    { 1504, 232, -144},
    { 1296, 120, -104},
    { 1040, 184, -184},
    { 776, -232, -8},
    { 1064, -176, 72},
    { 1072, -40, -296},
    { 1208, 112, -376},
    { 1304, 232, -224},
    // 69 seconds
    { 1152, 176, -304},
    { 1096, 328, -336},
    { 1264, 496, -224},
    { 1496, 600, -304},
    { 1648, 816, -376},
    { 1408, 872, -360},
    { 992, 976, -464},
    { 632, 752, -448},
    { 960, 1200, -456},
    { 872, 832, -376},
    { 1120, 936, -312},
    { 1400, 664, -352},
    { 1456, 528, -272},
    { 1384, 392, -256},
    { 1376, 176, -336},
    { 1520, 368, -224},
    { 1568, 192, -216},
    { 1352, 264, -208},
    { 1368, 248, -200},
    { 960, -288, 80},
    { 952, -288, -16},
    { 800, -376, -128},
    { 888, 200, -424},
    { 1136, -80, -160},
    { 1280, 328, -192},
    // 70 seconds
    { 1136, 264, -352},
    { 1296, 360, -112},
    { 1720, 640, -128},
    { 1720, 976, -288},
    { 1464, 1104, -280},
    { 968, 1112, -432},
    { 592, 1224, -504},
    { 880, 1160, -304},
    { 944, 896, -216},
    { 1216, 896, -224},
    { 1416, 712, -168},
    { 1656, 576, -144},
    { 1328, 368, -104},
    { 1312, 320, -232},
    { 1528, 368, -208},
    { 1736, 288, -120},
    { 1384, 224, -168},
    { 1240, 216, -224},
    { 632, -552, -32},
    { 568, -232, -360},
    { 760, -360, 0},
    { 1056, 56, -256},
    { 1056, 248, -408},
    { 1200, 280, -368},
    { 1352, 288, -288},
    // 71 seconds
    { 1440, 472, -272},
    { 1528, 776, -376},
    { 1480, 808, -416},
    { 1232, 1088, -504},
    { 776, 1280, -664},
    { 608, 1048, -520},
    { 704, 1192, -464},
    { 1040, 968, -224},
    { 1544, 904, -208},
    { 1712, 744, -120},
    { 1600, 520, -128},
    { 1288, 376, -160},
    { 1240, 344, -224},
    { 1368, 320, -232},
    { 1488, 296, -232},
    { 1224, 176, -248},
    { 968, -152, -128},
    { 584, -344, -232},
    { 904, -296, -272},
    { 1080, -240, -216},
    { 1160, 224, -544},
    { 1376, 136, -424},
    { 1328, 232, -384},
    { 1272, 280, -304},
    { 1360, 568, -232},
    // 72 seconds
    { 1544, 752, -312},
    { 1584, 888, -320},
    { 1232, 1056, -296},
    { 888, 1144, -360},
    { 616, 1024, -224},
    { 1016, 1304, -160},
    { 912, 792, -64},
    { 1120, 800, -80},
    { 1400, 648, -120},
    { 1456, 512, -168},
    { 1272, 384, -192},
    { 1400, 336, -272},
    { 1584, 336, -200},
    { 1512, 288, -272},
    { 1464, 256, -416},
    { 1216, -8, -280},
    { 712, -560, -216},
    { 960, -312, -112},
    { 840, -216, -368},
    { 1056, 192, -392},
    { 1160, 152, -304},
    { 1056, 208, -336},
    { 1016, 328, -296},
    { 1152, 440, -240},
    { 1392, 536, -336},
    // 73 seconds
    { 1544, 752, -432},
    { 1304, 896, -432},
    { 912, 1056, -528},
    { 872, 1192, -552},
    { 872, 760, -376},
    { 1112, 1024, -312},
    { 1248, 672, -304},
    { 1344, 568, -304},
    { 1152, 384, -216},
    { 1152, 200, -280},
    { 1240, 240, -272},
    { 1424, 264, -208},
    { 1512, 240, -264},
    { 1448, 112, -224},
    { 840, -448, 16},
    { 1120, -344, -200},
    { 968, -464, 16},
    { 1120, 104, -336},
    { 1408, 112, -264},
    { 1296, 280, -336},
    { 1152, 248, -280},
    { 1200, 504, -248},
    { 1368, 600, -272},
    { 1448, 760, -304},
    { 1336, 960, -280},
    // 74 seconds
    { 936, 1152, -400},
    { 664, 992, -408},
    { 784, 1160, -328},
    { 976, 848, -240},
    { 1200, 888, -264},
    { 1504, 696, -240},
    { 1624, 520, -216},
    { 1432, 368, -216},
    { 1328, 312, -224},
    { 1384, 320, -224},
    { 1408, 248, -160},
    { 1456, 232, -224},
    { 1272, -112, -48},
    { 744, -472, -64},
    { 1240, -352, 24},
    { 984, -368, -224},
    { 1280, 120, -296},
    { 1440, 248, -336},
    { 1304, 232, -336},
    { 1264, 336, -296},
    { 1384, 520, -264},
    { 1552, 672, -344},
    { 1544, 960, -384},
    { 1224, 1144, -368},
    { 688, 1352, -552},
    // 75 seconds
    { 680, 1008, -376},
    { 976, 1000, -216},
    { 896, 864, -208},
    { 1088, 672, -176},
    { 1416, 664, -248},
    { 1424, 480, -152},
    { 1288, 384, -216},
    { 1352, 288, -208},
    { 1472, 336, -184},
    { 1488, 272, -152},
    { 1376, 184, -184},
    { 1056, -272, -16},
    { 920, -376, -208},
    { 864, -416, 8},
    { 1040, 24, -408},
    { 1392, 40, -336},
    { 1312, 288, -400},
    { 1144, 176, -384},
    { 1136, 384, -296},
    { 1264, 520, -312},
    { 1368, 632, -392},
    { 1368, 848, -368},
    { 1064, 888, -464},
    { 704, 968, -536},
    { 584, 736, -400},
    // 76 seconds
    { 920, 1072, -416},
    { 1032, 784, -320},
    { 1280, 792, -280},
    { 1608, 632, -280},
    { 1456, 416, -192},
    { 1296, 352, -256},
    { 1400, 312, -264},
    { 1464, 320, -168},
    { 1376, 288, -200},
    { 1232, 184, -176},
    { 992, -224, 8},
    { 992, -368, -96},
    { 1040, -440, 128},
    { 1032, 8, -400},
    { 1232, -32, -280},
    { 1288, 272, -344},
    { 1208, 176, -320},
    { 1312, 448, -272},
    { 1528, 624, -296},
    { 1512, 888, -456},
    { 1304, 808, -304},
    { 968, 1216, -520},
    { 672, 904, -480},
    { 840, 1048, -360},
    { 896, 880, -248},
    // 77 seconds
    { 1256, 1056, -256},
    { 1624, 688, -144},
    { 1696, 504, -144},
    { 1408, 344, -192},
    { 1384, 312, -272},
    { 1272, 64, -40},
    { 1312, 256, -200},
    { 1296, 232, -256},
    { 1184, 144, -200},
    { 872, -152, -48},
    { 648, -288, -176},
    { 848, -160, -176},
    { 1136, 88, -424},
    { 1576, 208, -448},
    { 1336, 168, -432},
    { 1176, 168, -360},
    { 1176, 472, -312},
    { 1376, 560, -320},
    { 1592, 792, -376},
    { 1384, 1048, -408},
    { 856, 1008, -488},
    { 528, 1056, -584},
    { 680, 936, -432},
    { 992, 832, -296},
    { 1096, 840, -320},
    // 78 seconds
    { 1368, 632, -264},
    { 1560, 560, -272},
    { 1352, 400, -232},
    { 1272, 304, -272},
    { 1344, 264, -304},
    { 1480, 264, -240},
    { 1424, 184, -280},
    { 1408, 88, -304},
    { 864, -512, 0},
    { 1264, -304, -144},
    { 800, -512, -96},
    { 1240, 16, -304},
    { 1576, 96, -216},
    { 1392, 256, -352},
    { 1344, 264, -312},
    { 1448, 552, -232},
    { 1512, 680, -344},
    { 1520, 872, -256},
    { 1328, 1056, -304},
    { 816, 1248, -448},
    { 608, 1072, -448},
    { 688, 1224, -328},
    { 1072, 856, -240},
    { 1256, 936, -232},
    { 1504, 704, -192},
    // 79 seconds
    { 1904, 520, -176},
    { 1632, 408, -120},
    { 1552, 344, -200},
    { 1592, 312, -152},
    { 1424, 168, -16},
    { 1208, 80, -80},
    { 1048, -72, -64},
    { 768, -256, -56},
    { 1048, -144, -88},
    { 728, -224, -272},
    { 1144, 168, -368},
    { 1536, 232, -448},
    { 1400, 240, -408},
    { 1296, 328, -320},
    { 1280, 544, -280},
    { 1240, 656, -344},
    { 1336, 680, -208},
    { 1152, 872, -272},
    { 856, 864, -328},
    { 720, 944, -304},
    { 744, 1104, -296},
    { 992, 776, -296},
    { 1176, 912, -224},
    { 1456, 736, -224},
    { 1528, 520, -216},
    // 80 seconds
    { 1248, 384, -200},
    { 1264, 336, -256},
    { 1488, 320, -240},
    { 1504, 272, -192},
    { 1432, 264, -272},
    { 1280, 112, -176},
    { 672, -456, -56},
    { 992, -216, -192},
    { 848, -360, -88},
    { 1168, 184, -328},
    { 1408, 192, -328},
    { 1160, 232, -360},
    { 1104, 264, -312},
    { 1240, 464, -208},
    { 1472, 616, -272},
    { 1568, 784, -296},
    { 1336, 1040, -224},
    { 896, 1136, -424},
    { 672, 968, -360},
    { 928, 1264, -248},
    { 888, 816, -144},
    { 1120, 904, -216},
    { 1368, 728, -232},
    { 1504, 552, -216},
    { 1352, 432, -192},
    // 81 seconds
    { 1312, 328, -240},
    { 1480, 336, -248},
    { 1608, 288, -128},
    { 1384, 264, -184},
    { 1272, 128, -160},
    { 536, -648, -88},
    { 1152, -320, -64},
    { 1072, -440, -104},
    { 1360, 48, -304},
    { 1464, 256, -360},
    { 1176, 240, -304},
    { 1040, 296, -336},
    { 1184, 424, -208},
    { 1416, 584, -240},
    { 1560, 816, -216},
    { 1352, 1184, -208},
    { 808, 1240, -376},
    { 704, 1120, -272},
    { 936, 1160, -96},
    { 1032, 816, -48},
    { 1112, 880, -112},
    { 1336, 744, -112},
    { 1584, 608, -128},
    { 1504, 456, -144},
    { 1416, 416, -168},
    // 82 seconds
    { 1392, 344, -216},
    { 1384, 304, -120},
    { 1288, 264, -136},
    { 1232, 168, -120},
    { 840, -136, -8},
    { 600, -232, -216},
    { 736, -256, -88},
    { 984, -48, -240},
    { 1408, 176, -328},
    { 1528, 384, -424},
    { 1392, 296, -264},
    { 1256, 416, -288},
    { 1296, 608, -272},
    { 1512, 608, -264},
    { 1544, 768, -264},
    { 1296, 888, -280},
    { 928, 1056, -368},
    { 672, 1008, -416},
    { 768, 1040, -352},
    { 808, 824, -256},
    { 1072, 872, -256},
    { 1392, 752, -264},
    { 1680, 584, -192},
    { 1472, 456, -200},
    { 1440, 360, -216},
    // 83 seconds
    { 1472, 360, -216},
    { 1520, 312, -152},
    { 1464, 272, -152},
    { 1288, 256, -136},
    { 928, -184, 24},
    { 824, -336, -80},
    { 624, -504, 40},
    { 912, -16, -320},
    { 1232, -56, -104},
    { 1368, 448, -392},
    { 1288, 232, -240},
    { 1376, 424, -240},
    { 1520, 600, -240},
    { 1592, 808, -320},
    { 1480, 896, -304},
    { 1144, 1120, -368},
    { 704, 1184, -464},
    { 616, 1064, -368},
    { 1080, 1272, -280},
    { 1120, 840, -200},
    { 1248, 808, -168},
    { 1528, 672, -200},
    { 1440, 448, -144},
    { 1344, 384, -192},
    { 1496, 352, -184},
    // 84 seconds
    { 1528, 312, -128},
    { 1456, 320, -168},
    { 1312, 264, -192},
    { 1064, -32, -72},
    { 656, -360, -176},
    { 888, -368, 128},
    { 1080, -144, -264},
    { 1256, 40, -232},
    { 1400, 312, -304},
    { 1200, 232, -320},
    { 1240, 360, -320},
    { 1512, 536, -208},
    { 1704, 784, -320},
    { 1568, 976, -256},
    { 1248, 1088, -296},
    { 776, 1232, -360},
    { 704, 928, -256},
    { 920, 1216, -168},
    { 960, 912, -152},
    { 1232, 840, -128},
    { 1632, 768, -104},
    { 1512, 512, -136},
    { 1312, 416, -200},
    { 1392, 360, -208},
    { 1536, 384, -152},
    // 85 seconds
    { 1528, 272, -136},
    { 1384, 264, -160},
    { 1088, 112, -184},
    { 744, -384, -224},
    { 1032, -336, 72},
    { 912, -464, -120},
    { 1088, 112, -336},
    { 1368, 120, -200},
    { 1272, 336, -336},
    { 1240, 328, -232},
    { 1408, 560, -240},
    { 1680, 712, -280},
    { 1632, 928, -280},
    { 1384, 1064, -304},
    { 872, 1392, -400},
    { 688, 1032, -352},
    { 912, 1296, -200},
    { 1008, 976, -152},
    { 1192, 888, -96},
    { 1512, 784, -168},
    { 1472, 520, -136},
    { 1296, 424, -176},
    { 1352, 344, -208},
    { 1480, 360, -192},
    { 1568, 272, -152},
    // 86 seconds
    { 1336, 232, -160},
    { 1152, 8, -112},
    { 752, -408, -160},
    { 1032, -392, 152},
    { 1064, -296, -272},
    { 1216, 48, -264},
    { 1312, 208, -352},
    { 1128, 200, -344},
    { 1128, 336, -344},
    { 1376, 576, -304},
    { 1656, 720, -384},
    { 1600, 1008, -352},
    { 1256, 1184, -528},
    { 776, 1248, -584},
    { 648, 1000, -408},
    { 1040, 1160, -288},
    { 992, 920, -240},
    { 1256, 736, -168},
    { 1584, 696, -208},
    { 1424, 488, -176},
    { 1272, 392, -240},
    { 1352, 328, -232},
    { 1504, 304, -192},
    { 1496, 256, -200},
    { 1336, 192, -248},
    // 87 seconds
    { 1056, -296, 0},
    { 744, -480, -280},
    { 912, -536, 96},
    { 1144, -88, -296},
    { 1328, 96, -280},
    { 1352, 360, -376},
    { 1240, 208, -280},
    { 1344, 464, -264},
    { 1552, 664, -280},
    { 1640, 880, -384},
    { 1464, 920, -296},
    { 936, 1304, -464},
    { 608, 1096, -496},
    { 704, 1072, -344},
    { 976, 936, -240},
    { 1112, 912, -256},
    { 1424, 752, -224},
    { 1520, 576, -184},
    { 1328, 448, -168},
    { 1328, 352, -232},
    { 1488, 368, -192},
    { 1640, 320, -168},
    { 1568, 272, -152},
    { 1464, 168, -184},
    { 856, -472, -32},
    // 88 seconds
    { 976, -424, -8},
    { 808, -520, 0},
    { 1096, 16, -272},
    { 1384, 160, -224},
    { 1240, 296, -352},
    { 1216, 280, -280},
    { 1352, 496, -224},
    { 1544, 640, -296},
    { 1624, 864, -256},
    { 1384, 1096, -248},
    { 840, 1448, -456},
    { 600, 1112, -368},
    { 768, 1272, -224},
    { 1000, 896, -112},
    { 1256, 936, -152},
    { 1600, 760, -96},
    { 1632, 568, -88},
    { 1328, 384, -160},
    { 1376, 400, -224},
    { 1592, 400, -144},
    { 1528, 272, -56},
    { 1528, 288, -96},
    { 1336, 112, 24},
    { 640, -464, -56},
    { 720, -392, -144},
    // 89 seconds
    { 896, -400, -72},
    { 1080, 88, -408},
    { 1504, 232, -480},
    { 1560, 336, -512},
    { 1528, 304, -296},
    { 1424, 640, -400},
    { 1360, 760, -376},
    { 1480, 640, -280},
    { 1232, 840, -336},
    { 944, 856, -448},
    { 656, 1032, -504},
    { 672, 976, -392},
    { 984, 1112, -432},
    { 1224, 832, -288},
    { 1456, 832, -176},
    { 1904, 656, -224},
    { 1712, 448, -176},
    { 1528, 448, -272},
    { 1544, 88, -128},
    { 1584, 376, -112},
    { 1432, 272, -184},
    { 1296, 232, -120},
    { 960, -24, 104},
    { 624, -312, 40},
    { 584, -224, 0},
    // 90 seconds
    { 744, 48, -368},
    { 1040, -56, -112},
    { 1400, 360, -328},
    { 1344, 216, -424},
    { 1392, 328, -368},
    { 1632, 488, -264},
    { 1888, 872, -384},
    { 1712, 872, -416},
    { 1360, 1024, -424},
    { 792, 1072, -440},
    { 600, 1016, -424},
    { 1008, 1296, -288},
    { 1064, 904, -208},
    { 1176, 880, -160},
    { 1568, 736, -120},
    { 1432, 480, -104},
    { 1352, 384, -216},
    { 1448, 304, -224},
    { 1640, 376, -152},
    { 1672, 256, -152},
    { 1392, 264, -144},
    { 1120, 216, -160},
    { 720, -232, 32},
    { 808, -176, 48},
    { 592, -288, -248},
    // 91 seconds
    { 816, 144, -288},
    { 1144, 72, -280},
    { 1184, 264, -384},
    { 1256, 264, -288},
    { 1408, 560, -240},
    { 1568, 752, -304},
    { 1640, 824, -168},
    { 1336, 1064, -272},
    { 976, 920, -272},
    { 760, 928, -232},
    { 888, 1280, -288},
    { 928, 792, -160},
    { 1056, 1024, -160},
    { 1328, 728, -152},
    { 1432, 568, -152},
    { 1248, 480, -192},
    { 1288, 368, -224},
    { 1352, 312, -176},
    { 1496, 288, -200},
    { 1536, 216, -120},
    { 1280, 232, -200},
    { 992, -104, -88},
    { 984, -168, -96},
    { 616, -384, -56},
    { 944, 144, -304},
    // 92 seconds
    { 1200, 112, -240},
    { 1152, 288, -312},
    { 1064, 216, -288},
    { 1128, 424, -248},
    { 1384, 520, -288},
    { 1592, 760, -400},
    { 1408, 904, -352},
    { 1120, 1000, -520},
    { 816, 984, -528},
    { 744, 904, -448},
    { 960, 960, -408},
    { 936, 840, -336},
    { 1224, 712, -304},
    { 1592, 656, -280},
    { 1360, 440, -160},
    { 1320, 376, -288},
    { 1360, 216, -120},
    { 1408, 336, -200},
    { 1384, 248, -160},
    { 1256, 280, -176},
    { 1144, 56, -72},
    { 944, -384, 0},
    { 728, -392, 16},
    { 936, 40, -360},
    { 1312, -56, -120},
    // 93 seconds
    { 1280, 400, -384},
    { 1088, 176, -312},
    { 1128, 368, -288},
    { 1416, 488, -208},
    { 1640, 720, -320},
    { 1536, 1008, -264},
    { 1160, 1128, -424},
    { 696, 1168, -448},
    { 688, 992, -352},
    { 976, 1072, -296},
    { 1072, 904, -248},
    { 1368, 744, -176},
    { 1656, 640, -184},
    { 1408, 456, -168},
    { 1432, 376, -232},
    { 1544, 328, -192},
    { 1552, 272, -72},
    { 1496, 304, -200},
    { 1392, 248, -152},
    { 952, -296, 32},
    { 704, -344, -216},
    { 936, -384, 144},
    { 1032, -80, -336},
    { 1256, 128, -280},
    { 1440, 320, -296},
    // 94 seconds
    { 1440, 280, -296},
    { 1448, 472, -304},
    { 1560, 680, -208},
    { 1624, 848, -256},
    { 1576, 856, -192},
    { 1184, 1000, -304},
    { 840, 944, -368},
    { 624, 912, -312},
    { 904, 1224, -376},
    { 984, 848, -272},
    { 1256, 856, -256},
    { 1528, 688, -232},
    { 1512, 504, -128},
    { 1528, 320, -64},
    { 1432, 240, -112},
    { 1608, 424, -120},
    { 1704, 240, -16},
    { 1488, 256, -32},
    { 1200, 144, 16},
    { 728, -344, -32},
    { 1000, -224, 144},
    { 896, -208, 16},
    { 992, 216, -208},
    { 1224, 256, -168},
    { 1152, 280, -344},
    // 95 seconds
    { 1168, 184, -256},
    { 1312, 416, -248},
    { 1512, 648, -400},
    { 1592, 792, -496},
    { 1312, 808, -528},
    { 1000, 872, -664},
    { 664, 672, -552},
    { 976, 992, -576},
    { 944, 856, -368},
    { 1336, 856, -312},
    { 1648, 680, -240},
    { 1352, 464, -176},
    { 1184, 328, -208},
    { 1184, 264, -232},
    { 1512, 384, -224},
    { 1648, 208, -80},
    { 1336, 216, -120},
    { 1176, 112, -56},
    { 632, -376, -32},
    { 920, -144, 104},
    { 880, -136, -136},
    { 1040, 168, -312},
    { 1280, 320, -296},
    { 1080, 232, -312},
    { 992, 176, -320},
    // 96 seconds
    { 1080, 456, -232},
    { 1416, 512, -408},
    { 1520, 648, -432},
    { 1304, 776, -560},
    { 1000, 704, -624},
    { 768, 688, -592},
    { 920, 912, -680},
    { 960, 784, -472},
    { 1144, 848, -400},
    { 1320, 608, -376},
    { 1392, 520, -336},
    { 1288, 360, -232},
    { 1064, 136, -288},
    { 1168, 328, -128},
    { 1376, 256, -240},
    { 1424, 200, -144},
    { 1320, 280, -120},
    { 1112, 160, -72},
    { 776, -280, 24},
    { 688, -152, 32},
    { 752, -56, -256},
    { 1008, 104, -248},
    { 1288, 264, -272},
    { 1144, 208, -304},
    { 1128, 320, -376},
    // 97 seconds
    { 1224, 488, -256},
    { 1456, 592, -416},
    { 1496, 792, -456},
    { 1232, 872, -544},
    { 872, 896, -672},
    { 680, 768, -576},
    { 1168, 1072, -568},
    { 992, 672, -360},
    { 1288, 824, -368},
    { 1544, 632, -312},
    { 1360, 456, -184},
    { 1264, 304, -232},
    { 1224, 192, -168},
    { 1344, 344, -208},
    { 1432, 392, -136},
    { 1480, 576, -168},
    { 1344, 800, -312},
    { 400, 928, -456},
    { 1064, 984, -736},
    { -24, 224, -624},
    { 280, 408, -648},
    { 216, -352, -472},
    { 264, -328, -480},
    { 176, -400, -480},
    { -40, -552, -384},
    // 98 seconds
    { -136, -672, -416},
    { -144, -680, -600},
    { -152, -680, -728},
    { -152, -680, -824},
    { -88, -672, -960},
    { -120, -688, -968},
    { -184, -720, -1136},
    { -192, -640, -1152},
    { -272, -568, -1048},
    { -192, -392, -1136},
    { -32, -360, -992},
    { 24, -416, -824},
    { 24, -416, -728},
    { 24, -480, -656},
    { 8, -496, -616},
    { 56, -576, -632},
    { 88, -568, -616},
    { 152, -576, -640},
    { 296, -464, -576},
    { 544, -288, -408},
    { 848, 160, -360},
    { 992, 360, -368},
    { 1536, 408, -344},
    { 1632, 672, -464},
    { 1688, 472, -520},
    // 99 seconds
    { 1528, 584, -552},
    { 1496, 552, -464},
    { 1616, 576, -448},
    { 1464, 720, -488},
    { 1168, 656, -576},
    { 952, 784, -744},
    { 704, 936, -728},
    { 944, 1072, -856},
    { 744, 688, -600},
    { 1192, 824, -592},
    { 1576, 664, -488},
    { 1696, 576, -432},
    { 1544, 568, -368},
    { 1576, 696, -328},
    { 1728, 808, -344},
    { 1728, 776, -312},
    { 1432, 520, -232},
    { 912, 376, -320},
    { 640, 0, -224},
    { 448, -176, -328},
    { 80, -360, -528},
    { 152, -368, -592},
    { 152, -408, -800},
    { 96, -376, -768},
    { 8, -392, -696},
    // 100 seconds
    { -80, -392, -760},
    { -176, -432, -752},
    { -200, -432, -928},
    { -232, -512, -1024},
    { -152, -424, -1160},
    { -56, -536, -1240},
    { -152, -384, -1336},
    { -128, -328, -1288},
    { -192, -240, -1144},
    { -72, -72, -1200},
    { 40, -240, -888},
    { 16, -320, -712},
    { 56, -296, -624},
    { 88, -400, -464},
    { 152, -264, -448},
    { 376, -112, -520},
    { 664, -248, -384},
    { 1040, 16, -312},
    { 1632, 496, -416},
    { 1624, 552, -424},
    { 1760, 752, -608},
    { 1872, 440, -736},
    { 1776, 528, -408},
    { 1176, 568, -368},
    { 968, 576, -352},
    // 101 seconds
    { 960, 552, -248},
    { 936, 568, -208},
    { 944, 760, -208},
    { 704, 1000, -560},
    { 592, 1120, -576},
    { 784, 968, -392},
    { 1272, 736, -496},
    { 1216, 704, -424},
    { 1624, 752, -384},
    { 1992, 608, -360},
    { 1792, 416, -256},
    { 1584, 464, -216},
    { 1480, 232, -240},
    { 1384, 216, -208},
    { 1224, 192, -152},
    { 1104, 168, -168},
    { 1016, 192, -152},
    { 600, -448, 168},
    { 768, -280, -128},
    { 656, -232, -192},
    { 1208, 112, -304},
    { 1520, 184, -296},
    { 1520, 376, -480},
    { 1512, 264, -312},
    { 1544, 600, -320},
    // 102 seconds
    { 1648, 704, -328},
    { 1904, 840, -360},
    { 1544, 1016, -376},
    { 1016, 1152, -432},
    { 696, 1416, -520},
    { 576, 1032, -440},
    { 784, 1024, -408},
    { 1064, 912, -280},
    { 1456, 864, -256},
    { 1976, 696, -248},
    { 1760, 568, -200},
    { 1720, 520, -272},
    { 1752, 336, -208},
    { 1744, 368, -144},
    { 1608, 240, -168},
    { 1264, 256, -208},
    { 944, -16, -88},
    { 784, -432, -40},
    { 504, -512, 72},
    { 920, 104, -400},
    { 1000, -16, -224},
    { 1264, 400, -368},
    { 1280, 232, -288},
    { 1416, 400, -168},
    { 1712, 704, -240},
    // 103 seconds
    { 1888, 928, -344},
    { 1776, 952, -288},
    { 1192, 1136, -448},
    { 712, 1176, -560},
    { 600, 1088, -440},
    { 912, 1288, -440},
    { 912, 896, -216},
    { 1216, 896, -200},
    { 1584, 768, -208},
    { 1600, 568, -168},
    { 1400, 440, -200},
    { 1400, 360, -224},
    { 1480, 352, -216},
    { 1536, 312, -160},
    { 1360, 216, -168},
    { 1128, 192, -200},
    { 672, -416, -80},
    { 920, -272, -152},
    { 792, -424, 8},
    { 1144, 168, -384},
    { 1376, 208, -296},
    { 1272, 320, -376},
    { 1304, 264, -208},
    { 1432, 584, -208},
    { 1608, 760, -272},
    // 104 seconds
    { 1584, 896, -272},
    { 1520, 944, -248},
    { 1088, 1176, -328},
    { 680, 1008, -320},
    { 824, 1264, -264},
    { 1016, 1144, -192},
    { 1216, 968, -192},
    { 1456, 792, -232},
    { 1640, 640, -200},
    { 1520, 472, -160},
    { 1552, 376, -208},
    { 1624, 312, -160},
    { 1648, 288, -64},
    { 1304, 240, -56},
    { 1248, 328, -136},
    { 1144, -104, 128},
    { 1024, -504, 376},
    { 696, -552, -96},
    { 904, 32, -240},
    { 1456, -104, 88},
    { 1432, 520, -360},
    { 1344, 272, -280},
    { 1584, 480, -224},
    { 1744, 688, -272},
    { 1672, 1040, -408},
    // 105 seconds
    { 1440, 984, -472},
    { 1048, 1320, -592},
    { 664, 1064, -504},
    { 776, 1240, -584},
    { 792, 952, -328},
    { 1008, 880, -352},
    { 1496, 824, -208},
    { 1880, 672, -240},
    { 1592, 456, -152},
    { 1456, 360, -208},
    { 1416, 328, -192},
    { 1488, 336, -176},
    { 1600, 280, -152},
    { 1312, 208, -72},
    { 896, -40, -112},
    { 632, -384, -168},
    { 696, -512, 144},
    { 1024, -88, -296},
    { 1072, 40, -288},
    { 1296, 312, -408},
    { 1248, 272, -320},
    { 1336, 352, -208},
    { 1592, 672, -392},
    { 1696, 808, -432},
    { 1592, 928, -456},
    // 106 seconds
    { 1344, 1096, -504},
    { 1000, 1168, -568},
    { 792, 1344, -688},
    { 888, 936, -360},
    { 1128, 1104, -368},
    { 1440, 776, -280},
    { 1552, 640, -256},
    { 1336, 448, -184},
    { 1240, 368, -192},
    { 1320, 328, -208},
    { 1464, 336, -200},
    { 1808, 280, -136},
    { 1344, 160, -72},
    { 1056, 104, -184},
    { 584, -472, -192},
    { 704, -416, 40},
    { 928, -208, -328},
    { 1240, 64, -224},
    { 1464, 312, -272},
    { 1352, 296, -320},
    { 1456, 408, -192},
    { 1632, 672, -240},
    { 1760, 832, -296},
    { 1664, 912, -184},
    { 1216, 1272, -320},
    // 107 seconds
    { 688, 1312, -384},
    { 704, 1096, -296},
    { 832, 1344, -312},
    { 1120, 912, -112},
    { 1416, 904, -160},
    { 1576, 744, -96},
    { 1704, 584, -104},
    { 1576, 512, -112},
    { 1608, 400, -168},
    { 1768, 384, -24},
    { 1560, 288, -32},
    { 1432, 272, -104},
    { 1216, 168, -64},
    { 744, -312, -56},
    { 968, -136, 24},
    { 648, -304, -152},
    { 848, 160, -248},
    { 1112, 56, -176},
    { 1176, 352, -296},
    { 1144, 240, -304},
    { 1336, 400, -200},
    { 1672, 568, -304},
    { 1896, 832, -384},
    { 1640, 1040, -496},
    { 1232, 1176, -720},
    // 108 seconds
    { 648, 1184, -632},
    { 688, 864, -448},
    { 936, 1152, -304},
    { 944, 832, -160},
    { 1432, 848, -296},
    { 1768, 776, -40},
    { 1672, 512, -40},
    { 1424, 392, -128},
    { 1376, 384, -136},
    { 1432, 384, -128},
    { 1400, 288, -88},
    { 1248, 224, -96},
    { 1032, 200, -112},
    { 512, -264, -96},
    { 568, -64, -376},
    { 656, -360, -200},
    { 1024, 128, -504},
    { 1240, 152, -424},
    { 1216, 376, -448},
    { 1136, 232, -232},
    { 1144, 336, -176},
    { 1352, 504, -200},
    { 1560, 616, -216},
    { 1544, 744, -264},
    { 1440, 960, -432},
    // 109 seconds
    { 968, 1080, -480},
    { 528, 1280, -560},
    { 1016, 1496, -304},
    { 1304, 1096, -176},
    { 1416, 1216, -256},
    { 1616, 1040, -96},
    { 1720, 992, -64},
    { 1872, 984, 0},
    { 1856, 1064, 136},
    { 1696, 776, -64},
    { 1304, 792, 0},
    { 888, 504, -232},
    { 568, 288, -240},
    { 280, -144, -312},
    { 160, -384, -416},
    { 96, -528, -616},
    { 32, -680, -776},
    { -80, -512, -800},
    { -8, -568, -912},
    { 104, -344, -1048},
    { 64, -512, -792},
    { -96, -504, -744},
    { -192, -504, -760},
    { -264, -544, -728},
    { -216, -528, -816},
    // 110 seconds
    { -160, -560, -864},
    { -112, -568, -912},
    { -128, -560, -944},
    { -120, -600, -992},
    { -192, -624, -1056},
    { -216, -496, -1216},
    { -240, -528, -1088},
    { -304, -360, -1112},
    { -200, -240, -1144},
    { -48, -272, -968},
    { -72, -312, -912},
    { -72, -304, -888},
    { -80, -376, -816},
    { -80, -344, -872},
    { -48, -376, -904},
    { -56, -432, -928},
    { -56, -464, -976},
    { -32, -520, -960},
    { -16, -520, -960},
    { 32, -536, -976},
    { 136, -336, -968},
    { 136, -88, -888},
    { 152, -64, -880},
    { 248, -16, -848},
    { 280, 152, -832},
    // 111 seconds
    { 232, 200, -872},
    { 152, 144, -848},
    { 56, 368, -880},
    { -80, 536, -976},
    { -176, 600, -1000},
    { -280, 728, -1008},
    { -376, 840, -1016},
    { -352, 768, -1024},
    { -264, 784, -1024},
    { -144, 744, -920},
    { -216, 712, -888},
    { -128, 944, -1040},
    { 272, 864, -856},
    { 240, 720, -792},
    { 192, 736, -776},
    { 152, 560, -648},
    { 112, 440, -560},
    { 24, 424, -560},
    { 40, 392, -528},
    { 32, 312, -528},
    { 24, 400, -560},
    { 56, 424, -552},
    { 48, 504, -560},
    { 40, 576, -528},
    { 24, 616, -536},
    // 112 seconds
    { 40, 680, -664},
    { 408, 1024, -832},
    { 416, 880, -872},
    { 592, 792, -776},
    { 480, 432, -736},
    { 552, 536, -768},
    { 592, 488, -568},
    { 488, 464, -552},
    { 520, 480, -528},
    { 568, 520, -480},
    { 648, 592, -448},
    { 640, 624, -408},
    { 584, 672, -344},
    { 536, 600, -288},
    { 528, 632, -232},
    { 696, 816, -280},
    { 816, 928, -280},
    { 720, 720, -184},
    { 592, 688, -184},
    { 552, 800, -184},
    { 544, 968, -168},
    { 504, 992, -88},
    { 448, 992, -40},
    { 392, 1008, -8},
    { 288, 976, 8},
    // 113 seconds
    { 176, 984, 24},
    { 144, 960, 144},
    { 112, 880, 208},
    { 72, 800, 240},
    { -8, 768, 312},
    { -48, 800, 328},
    { -72, 744, 312},
    { -40, 776, 312},
    { -56, 800, 288},
    { -64, 800, 320},
    { -64, 784, 288},
    { -96, 768, 224},
    { -104, 808, 168},
    { -88, 864, 136},
    { -88, 912, 144},
    { -88, 936, 72},
    { -72, 864, 80},
    { -104, 888, 144},
    { -160, 936, 168},
    { -176, 944, 208},
    { -144, 968, 176},
    { -136, 944, 192},
    { -64, 1000, 96},
    { -16, 992, 24},
    { -8, 840, 96},
    // 114 seconds
    { -24, 888, 24},
    { -32, 936, 64},
    { -24, 896, 48},
    { 24, 896, -72},
    { 24, 856, -208},
    { -176, 944, -208},
    { -80, 872, -272},
    { -152, 920, -136},
    { -320, 1088, -328},
    { -592, 1560, -16},
    { -440, 704, -144},
    { -384, 808, -512},
    { -104, 608, -520},
    { -64, 648, -584},
    { 184, 312, -640},
    { 416, 272, -880},
    { 448, 168, -920},
    { 464, 72, -1008},
    { 384, 176, -1112},
    { 320, 224, -1152},
    { 256, 96, -1160},
    { 176, 96, -1032},
    { 128, 104, -984},
    { 72, 104, -1024},
    { 72, 56, -1016},
    // 115 seconds
    { 64, 64, -1008},
    { 72, 24, -992},
    { 48, 24, -976},
    { 64, 16, -984},
    { 72, 8, -992},
    { 64, -8, -976},
    { 88, 0, -992},
    { 112, 0, -976},
    { 144, 8, -944},
    { 224, 0, -952},
    { 272, 80, -848},
    { 200, 216, -784},
    { 56, 408, -816},
    { -48, 344, -904},
    { -120, 424, -904},
    { -160, 472, -952},
    { -96, 480, -1024},
    { 24, 408, -1048},
    { 120, 328, -1016},
    { 128, 416, -1024},
    { 120, 440, -928},
    { 112, 456, -904},
    { 112, 472, -864},
    { 120, 464, -896},
    { 104, 456, -880},
    // 116 seconds
    { 120, 480, -872},
    { 120, 488, -880},
    { 120, 456, -888},
    { 112, 456, -848},
    { 112, 456, -856},
    { 112, 440, -848},
    { 128, 432, -872},
    { 128, 464, -872},
    { 120, 432, -864},
    { 120, 440, -872},
    { 112, 448, -880},
    { 120, 432, -864},
    { 120, 432, -840},
    { 112, 432, -864},
    { 112, 432, -880},
    { 120, 448, -864},
    { 112, 448, -864},
    { 112, 456, -872},
    { 112, 448, -864},
    { 112, 448, -864},
    { 104, 440, -872},
    { 104, 456, -872},
    { 104, 456, -872},
    { 104, 456, -872},
    { 104, 464, -880},
    // 117 seconds
    { 96, 464, -872},
    { 104, 464, -872},
    { 104, 448, -856},
    { 112, 440, -848},
    { 104, 448, -856},
    { 104, 464, -880},
    { 96, 464, -880},
    { 104, 456, -880},
    { 104, 440, -856},
    { 104, 440, -864},
    { 112, 448, -856},
    { 112, 456, -864},
    { 112, 448, -864},
    { 112, 448, -880},
    { 104, 456, -888},
    { 104, 456, -864},
    { 112, 432, -856},
    { 112, 440, -872},
    { 112, 448, -880},
    { 104, 440, -888},
    { 96, 440, -896},
    { 104, 440, -880},
    { 112, 408, -864},
    { 112, 424, -888},
    { 112, 440, -904},
    // 118 seconds
    { 96, 432, -896},
    { 104, 424, -896},
    { 104, 448, -936},
    { 104, 424, -1008},
    { 96, 336, -968},
    { 128, 320, -968},
    { 144, 152, -920},
    { 208, 80, -920},
    { 168, 192, -1072},
    { 176, 264, -1104},
    { 96, 216, -1064},
    { 40, 256, -984},
    { -8, 224, -936},
    { -32, 216, -912},
    { -216, 128, -848},
    { 24, 256, -912},
    { 8, 392, -976},
    { 88, 264, -904},
    { 48, 248, -944},
    { 40, 72, -928},
    { 16, 192, -976},
    { -24, 280, -1008},
    { -24, 272, -1040},
    { 40, 216, -1008},
    { -56, 272, -1016},
    // 119 seconds
    { -136, 416, -968},
    { -96, 200, -944},
    { -104, 320, -960},
    { -160, 352, -952},
    { -224, 296, -904},
    { -208, 296, -920},
    { -176, 248, -968},
    { -144, 240, -1000},
    { -144, 272, -984},
    { -136, 248, -1016},
    { -136, 216, -952},
    { -120, 176, -968},
    { -112, 184, -984},
    { -112, 176, -984},
    { -88, 160, -1008},
    { -104, 144, -1000},
    { -104, 152, -1000},
    { -88, 144, -1008},
    { -96, 136, -1000},
    { -112, 136, -1008},
    { -104, 144, -1000},
    { -96, 136, -1000},
    { -104, 136, -1008},
    { -96, 152, -1008},
    { -96, 152, -1000},
    // elapsed: 2 minutes
    { -96, 152, -1000},
    { -104, 160, -1008},
    { -104, 136, -1000},
    { -80, 152, -1024},
    { -88, 168, -1024},
    { -80, 152, -992},
    { -104, 200, -1024},
    { -400, 264, -1072},
    { -48, -184, -864},
    { 1048, 344, -840},
    { -136, 56, -928},
    { -24, 200, -1016},
    { -32, 200, -1048},
    { -304, 600, -952},
    { 72, 8, -984},
    { -16, 128, -984},
    { -16, 152, -1008},
    { -48, 168, -992},
    { 8, 208, -992},
    { -24, 200, -1032},
    { -40, 120, -1008},
    { -32, 144, -1032},
    { -40, 208, -1024},
    { -8, 152, -992},
    { -8, 160, -992},
    // 121 seconds
    { -32, 128, -1008},
    { -56, 200, -1000},
    { 0, 152, -1016},
    { -32, 176, -1024},
    { -48, 176, -1000},
    { -40, 160, -1016},
    { -40, 184, -1000},
    { -40, 184, -1008},
    { -56, 192, -992},
    { -24, 168, -992},
    { -24, 160, -992},
    { -40, 168, -992},
    { -32, 208, -992},
    { -8, 216, -992},
    { -56, 160, -992},
    { -16, 208, -992},
    { -16, 216, -1016},
    { -48, 184, -1008},
    { -16, 184, -1008},
    { -48, 200, -1008},
    { -56, 176, -1024},
    { -24, 200, -984},
    { -48, 192, -984},
    { -48, 184, -976},
    { -32, 200, -992},
    // 122 seconds
    { -64, 152, -976},
    { -32, 184, -952},
    { -16, 192, -928},
    { -40, 160, -920},
    { 64, 56, -792},
    { -64, 480, -936},
    { 96, 288, -1000},
    { 80, 264, -992},
    { 88, 360, -1040},
    { 88, 296, -1008},
    { 96, 320, -1008},
    { 120, 296, -1000},
    { 128, 280, -984},
    { 128, 272, -976},
    { 144, 280, -968},
    { 168, 272, -968},
    { 168, 280, -944},
    { 136, 296, -928},
    { 144, 288, -952},
    { 144, 280, -936},
    { 144, 280, -944},
    { 128, 264, -936},
    { 128, 296, -968},
    { 144, 328, -968},
    { 136, 304, -944},
    // 123 seconds
    { 152, 296, -936},
    { 144, 296, -912},
    { 160, 280, -920},
    { 160, 312, -936},
    { 144, 312, -952},
    { 144, 304, -952},
    { 144, 304, -944},
    { 144, 296, -936},
    { 144, 296, -928},
    { 160, 304, -944},
    { 136, 296, -936},
    { 144, 296, -928},
    { 144, 304, -936},
    { 144, 312, -936},
    { 136, 304, -928},
    { 136, 304, -936},
    { 136, 304, -936},
    { 144, 312, -928},
    { 136, 320, -944},
    { 152, 312, -944},
    { 136, 320, -928},
    { 128, 320, -912},
    { 136, 328, -936},
    { 136, 320, -928},
    { 136, 328, -936},
    // 124 seconds
    { 128, 328, -936},
    { 128, 328, -928},
    { 136, 328, -928},
    { 136, 328, -936},
    { 136, 328, -928},
    { 136, 336, -928},
    { 128, 328, -936},
    { 128, 336, -936},
    { 128, 336, -936},
    { 128, 328, -928},
    { 136, 328, -912},
    { 144, 320, -912},
    { 136, 328, -928},
    { 136, 336, -936},
    { 136, 328, -936},
    { 136, 328, -928},
    { 144, 320, -920},
    { 136, 328, -920},
    { 136, 328, -920},
    { 136, 328, -928},
    { 136, 328, -928},
    { 128, 320, -928},
    { 136, 336, -936},
    { 128, 320, -936},
    { 128, 336, -936},
    // 125 seconds
    { 128, 336, -928},
    { 136, 328, -920},
    { 144, 320, -912},
    { 144, 328, -920},
    { 136, 328, -936},
    { 136, 336, -944},
    { 136, 320, -920},
    { 136, 320, -920},
    { 136, 320, -912},
    { 136, 320, -920},
    { 136, 328, -928},
    { 136, 328, -936},
    { 136, 320, -936},
    { 136, 328, -920},
    { 136, 328, -928},
    { 136, 328, -928},
    { 144, 320, -920},
    { 136, 328, -928},
    { 136, 328, -936},
    { 144, 320, -928},
    { 144, 320, -912},
    { 144, 320, -920},
    { 144, 328, -952},
    { 136, 336, -952},
    { 128, 320, -928},
    // 126 seconds
    { 144, 304, -904},
    { 152, 320, -920},
    { 136, 328, -936},
    { 136, 320, -944},
    { 144, 312, -928},
    { 136, 312, -928},
    { 136, 304, -928},
    { 144, 312, -952},
    { 144, 320, -952},
    { 128, 296, -936},
    { 144, 352, -1024},
    { 96, 312, -1064},
    { 144, 192, -1000},
    { 152, 184, -928},
    { 104, 256, -1032},
    { 72, 264, -1024},
    { 80, 264, -1008},
    { 88, 280, -984},
    { 72, 264, -968},
    { 48, 264, -928},
    { 24, 232, -904},
    { -8, 224, -920},
    { -32, 216, -936},
    { -40, 208, -936},
    { -56, 200, -944},
    // 127 seconds
    { -48, 112, -936},
    { -32, 120, -976},
    { -56, 176, -1024},
    { 0, -32, -1024},
    { -112, 208, -1040},
    { -288, 240, -952},
    { -152, 352, -1080},
    { -120, 328, -1000},
    { -56, 200, -968},
    { -64, 240, -960},
    { -104, 280, -984},
    { -120, 256, -952},
    { -96, 232, -928},
    { -128, 312, -920},
    { -112, 296, -928},
    { -112, 304, -960},
    { -160, 304, -968},
    { -120, 320, -976},
    { -184, 304, -984},
    { -128, 256, -984},
    { -136, 264, -992},
    { -144, 208, -984},
    { -104, 192, -984},
    { -104, 152, -1000},
    { -120, 160, -992},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-22 10:37:41 local
AccelRawData *activity_sample_walk_200_pbl_28359_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_28359_4
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 180
  //> TEST_EXPECTED_MAX 220
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -104, 184, -992},
    { -96, 192, -992},
    { -104, 192, -1000},
    { -96, 192, -1000},
    { -104, 192, -1000},
    { -96, 192, -1008},
    { -96, 192, -1000},
    { -96, 192, -992},
    { -96, 192, -1000},
    { -96, 184, -1000},
    { -96, 192, -1000},
    { -104, 184, -992},
    { -96, 184, -1000},
    { -88, 184, -1000},
    { -96, 192, -1000},
    { -96, 184, -992},
    { -88, 184, -1000},
    { -88, 184, -992},
    { -96, 184, -992},
    { -88, 176, -1000},
    { -96, 192, -1008},
    { -96, 192, -1008},
    { -104, 192, -1000},
    { -96, 184, -1008},
    { -96, 184, -992},
    // 1 seconds
    { -96, 184, -1000},
    { -96, 184, -992},
    { -96, 184, -992},
    { -96, 184, -992},
    { -88, 184, -1000},
    { -104, 176, -1000},
    { -104, 176, -1000},
    { -96, 168, -1008},
    { -64, 192, -1016},
    { -80, 160, -1008},
    { -144, 120, -1000},
    { -144, 136, -992},
    { -176, 104, -976},
    { -168, 120, -1008},
    { -200, 104, -984},
    { -128, 192, -1040},
    { -96, 160, -1024},
    { -24, 152, -1008},
    { -88, 136, -1008},
    { -104, 160, -1024},
    { -56, 160, -992},
    { -88, 176, -1008},
    { -80, -416, -408},
    { 592, -208, -816},
    { 480, -48, -752},
    // 2 seconds
    { 480, 408, -720},
    { 384, 592, -664},
    { 272, 640, -504},
    { 264, 744, -400},
    { 200, 896, -408},
    { 184, 976, -424},
    { 64, 1016, -264},
    { 136, 864, -432},
    { 328, 944, -496},
    { 496, 704, -544},
    { 576, 560, -576},
    { 608, 560, -544},
    { 672, 584, -552},
    { 768, 560, -440},
    { 800, 536, -416},
    { 840, 504, -352},
    { 784, 560, -216},
    { 768, 552, -304},
    { 720, 520, -320},
    { 656, 536, -240},
    { 640, 672, -288},
    { 600, 752, -248},
    { 584, 776, -256},
    { 560, 736, -264},
    { 568, 752, -200},
    // 3 seconds
    { 560, 856, -280},
    { 512, 808, -256},
    { 560, 896, -200},
    { 592, 1040, -320},
    { 552, 1064, -320},
    { 512, 1112, -336},
    { 456, 1128, -352},
    { 384, 1104, -360},
    { 280, 992, -280},
    { 160, 912, -272},
    { 96, 776, -256},
    { 104, 808, -280},
    { -24, 664, -160},
    { 0, 808, -200},
    { -48, 600, -120},
    { -64, 744, -168},
    { -96, 728, -128},
    { -104, 784, -192},
    { -112, 752, -152},
    { -104, 768, -96},
    { -120, 840, -176},
    { -96, 856, -200},
    { -88, 848, -200},
    { -120, 872, -144},
    { -168, 872, -144},
    // 4 seconds
    { -184, 944, -136},
    { -176, 928, -120},
    { -168, 944, -128},
    { -192, 976, -160},
    { -208, 984, -152},
    { -224, 976, -168},
    { -224, 984, -160},
    { -232, 984, -176},
    { -216, 1048, -240},
    { -184, 1040, -264},
    { -192, 976, -216},
    { -216, 944, -192},
    { -256, 944, -192},
    { -248, 960, -184},
    { -232, 904, -208},
    { -200, 864, -264},
    { -208, 856, -288},
    { -216, 824, -328},
    { -256, 800, -304},
    { -288, 768, -256},
    { -288, 776, -296},
    { -320, 784, -264},
    { -320, 840, -296},
    { -344, 760, -312},
    { -368, 792, -296},
    // 5 seconds
    { -400, 720, -320},
    { -392, 768, -336},
    { -400, 776, -360},
    { -416, 808, -368},
    { -400, 800, -296},
    { -408, 848, -296},
    { -400, 904, -312},
    { -392, 888, -264},
    { -400, 800, -208},
    { -432, 848, -128},
    { -400, 856, -120},
    { -400, 816, -160},
    { -416, 792, -160},
    { -440, 728, -192},
    { -464, 800, -232},
    { -456, 776, -232},
    { -456, 832, -184},
    { -488, 792, -224},
    { -496, 784, -272},
    { -552, 768, -232},
    { -560, 872, -320},
    { -568, 752, -304},
    { -536, 744, -288},
    { -544, 936, -288},
    { -472, 1008, -448},
    // 6 seconds
    { -400, 944, -424},
    { -320, 840, -352},
    { -392, 880, -272},
    { -336, 816, -192},
    { -296, 840, -312},
    { -352, 696, -264},
    { -392, 672, -264},
    { -416, 728, -280},
    { -472, 760, -304},
    { -464, 768, -352},
    { -464, 744, -384},
    { -496, 816, -384},
    { -496, 816, -368},
    { -584, 904, -392},
    { -576, 1048, -304},
    { -504, 792, -248},
    { -560, 904, -176},
    { -464, 952, -184},
    { -384, 680, -240},
    { -456, 648, -208},
    { -496, 664, -208},
    { -496, 664, -208},
    { -480, 664, -232},
    { -488, 856, -248},
    { -464, 920, -216},
    // 7 seconds
    { -520, 824, -264},
    { -576, 1008, -224},
    { -424, 864, -200},
    { -440, 888, -240},
    { -456, 856, -168},
    { -440, 928, -248},
    { -432, 832, -232},
    { -456, 720, -232},
    { -504, 704, -240},
    { -512, 712, -280},
    { -520, 624, -192},
    { -512, 680, -168},
    { -552, 808, -184},
    { -520, 792, -168},
    { -472, 752, -136},
    { -552, 824, -104},
    { -504, 792, -72},
    { -528, 800, -96},
    { -448, 792, -136},
    { -472, 856, -112},
    { -440, 784, -80},
    { -392, 888, -152},
    { -360, 800, -144},
    { -312, 808, -168},
    { -280, 808, -208},
    // 8 seconds
    { -272, 720, -208},
    { -264, 784, -208},
    { -232, 728, -304},
    { -240, 648, -168},
    { -128, 752, -240},
    { -56, 736, -176},
    { -8, 800, -272},
    { 72, 904, -280},
    { 144, 816, -264},
    { 248, 944, -272},
    { 336, 936, -248},
    { 432, 952, -288},
    { 480, 952, -256},
    { 536, 984, -312},
    { 536, 1016, -344},
    { 536, 992, -232},
    { 496, 984, -288},
    { 488, 992, -272},
    { 440, 920, -200},
    { 424, 920, -224},
    { 432, 1144, -360},
    { 408, 880, -168},
    { 384, 808, -232},
    { 416, 1016, -304},
    { 616, 808, -152},
    // 9 seconds
    { 928, 872, 128},
    { 1000, 1144, 32},
    { 744, 1056, -16},
    { 352, 1024, -96},
    { 128, 928, -232},
    { -32, 760, -192},
    { -80, 768, -200},
    { -80, 608, -64},
    { 56, 744, 8},
    { 128, 856, 96},
    { 232, 760, 224},
    { 456, 784, 224},
    { 312, 856, 240},
    { 400, 688, 104},
    { 336, 776, 328},
    { 344, 744, 336},
    { 296, 840, 200},
    { 168, 728, 176},
    { 320, 920, 152},
    { 312, 776, 264},
    { 360, 744, 216},
    { 376, 888, 152},
    { 384, 864, 152},
    { 376, 920, 312},
    { 296, 760, 352},
    // 10 seconds
    { 272, 840, 344},
    { 248, 888, 296},
    { 280, 832, 264},
    { 304, 928, 304},
    { 304, 904, 296},
    { 272, 960, 248},
    { 240, 160, 32},
    { 408, 1360, 88},
    { 288, 632, 248},
    { 256, 792, 208},
    { 264, 888, 360},
    { 256, 880, 368},
    { 264, 872, 352},
    { 272, 872, 288},
    { 280, 824, 296},
    { 280, 664, 184},
    { 272, 896, 216},
    { 248, 816, 280},
    { 256, 800, 392},
    { 240, 808, 400},
    { 248, 712, 400},
    { 256, 720, 432},
    { 320, 672, 472},
    { 304, 672, 544},
    { 272, 864, 528},
    // 11 seconds
    { 288, 840, 432},
    { 312, 936, 328},
    { 248, 1000, 184},
    { 232, 1176, 136},
    { 400, 1016, -360},
    { -168, 1136, -200},
    { 80, 440, -512},
    { 232, 632, -888},
    { 216, 232, -864},
    { 248, 264, -952},
    { 288, 208, -936},
    { 384, -16, -848},
    { 416, 208, -952},
    { 328, 40, -960},
    { 312, 56, -976},
    { 312, 0, -1016},
    { 352, -16, -1016},
    { 368, -24, -1016},
    { 448, 40, -1008},
    { 560, 16, -824},
    { 720, 128, -624},
    { 728, 392, -504},
    { 736, 400, -464},
    { 776, 448, -480},
    { 824, 576, -392},
    // 12 seconds
    { 1024, 544, -304},
    { 1296, 584, -216},
    { 1480, 784, -216},
    { 1616, 640, -312},
    { 1744, 720, -160},
    { 1568, 936, -312},
    { 1400, 888, -408},
    { 832, 888, -432},
    { 408, 944, -496},
    { 296, 760, -448},
    { 576, 680, -528},
    { 1152, 760, -624},
    { 1488, 600, -488},
    { 1696, 488, -488},
    { 1864, 312, -424},
    { 1808, 208, -352},
    { 1600, 176, -360},
    { 1368, 160, -352},
    { 1184, 56, -288},
    { 936, -136, -216},
    { 656, -216, -208},
    { 896, -40, -216},
    { 1008, 0, -200},
    { 1112, 256, -328},
    { 1312, 176, -344},
    // 13 seconds
    { 1304, 256, -304},
    { 1288, 328, -232},
    { 1224, 512, -232},
    { 1216, 544, -232},
    { 1320, 768, -296},
    { 1216, 808, -336},
    { 904, 848, -368},
    { 648, 656, -296},
    { 928, 968, -344},
    { 984, 784, -272},
    { 1336, 896, -272},
    { 1448, 880, -208},
    { 1608, 416, -168},
    { 1488, 376, -240},
    { 1528, 168, -192},
    { 1504, 416, -296},
    { 1568, 256, -232},
    { 1448, 224, -208},
    { 1280, 104, -152},
    { 736, -488, 104},
    { 920, -168, -56},
    { 696, -104, -376},
    { 1032, 64, -112},
    { 1464, 96, -168},
    { 1288, 320, -392},
    // 14 seconds
    { 1248, 288, -352},
    { 1296, 448, -264},
    { 1464, 640, -304},
    { 1544, 736, -344},
    { 1408, 888, -424},
    { 1008, 968, -480},
    { 720, 968, -368},
    { 720, 1120, -360},
    { 1016, 1136, -192},
    { 1496, 992, -200},
    { 1624, 928, -144},
    { 1744, 816, -216},
    { 1632, 728, -184},
    { 1592, 872, -96},
    { 1720, 696, -120},
    { 1608, 544, -176},
    { 1432, 384, -272},
    { 1200, 264, -456},
    { 784, 96, -344},
    { 352, 48, -280},
    { 32, -456, -408},
    { 176, -328, -640},
    { 232, -464, -784},
    { 232, -464, -760},
    { 96, -432, -728},
    // 15 seconds
    { -96, -448, -720},
    { -240, -440, -728},
    { -280, -496, -808},
    { -408, -472, -896},
    { -480, -520, -1048},
    { -392, -480, -1232},
    { -448, -528, -1256},
    { -272, -448, -1360},
    { -304, -248, -1168},
    { -288, -96, -1160},
    { -40, -240, -928},
    { -24, -216, -728},
    { -48, -360, -528},
    { -16, -232, -448},
    { 80, -40, -432},
    { 272, -144, -376},
    { 608, -56, -408},
    { 976, -16, -336},
    { 1392, 416, -552},
    { 1552, 384, -760},
    { 1952, 576, -712},
    { 1784, 584, -904},
    { 1400, 520, -640},
    { 936, 384, -496},
    { 832, 328, -368},
    // 16 seconds
    { 848, 296, -232},
    { 928, 568, -248},
    { 920, 712, -464},
    { 936, 1008, -656},
    { 800, 1000, -640},
    { 1160, 920, -696},
    { 944, 488, -376},
    { 1280, 744, -432},
    { 1360, 704, -424},
    { 1424, 544, -320},
    { 1448, 448, -248},
    { 1264, 224, -272},
    { 1344, 432, -272},
    { 1424, 264, -232},
    { 1336, 224, -192},
    { 1240, 184, -160},
    { 808, -360, 216},
    { 784, -360, 24},
    { 728, -168, -144},
    { 1016, 176, -216},
    { 1312, 104, -152},
    { 1320, 448, -400},
    { 1272, 200, -256},
    { 1384, 448, -208},
    { 1640, 624, -248},
    // 17 seconds
    { 1600, 944, -272},
    { 1280, 936, -344},
    { 952, 1048, -432},
    { 656, 1072, -440},
    { 912, 1032, -424},
    { 952, 768, -216},
    { 1192, 872, -272},
    { 1488, 712, -192},
    { 1608, 536, -184},
    { 1320, 344, -136},
    { 1240, 328, -248},
    { 1312, 304, -168},
    { 1448, 264, -192},
    { 1552, 224, -128},
    { 1312, 184, -112},
    { 936, -456, 104},
    { 1096, -488, 32},
    { 800, -368, -200},
    { 960, 192, -312},
    { 1408, 80, -120},
    { 1264, 416, -368},
    { 1216, 200, -280},
    { 1336, 464, -168},
    { 1504, 696, -248},
    { 1520, 824, -224},
    // 18 seconds
    { 1376, 920, -312},
    { 1232, 1072, -296},
    { 712, 1016, -240},
    { 968, 1216, -304},
    { 928, 784, -144},
    { 1248, 800, -96},
    { 1488, 712, -168},
    { 1408, 488, -136},
    { 1408, 384, -216},
    { 1320, 264, -144},
    { 1496, 424, -200},
    { 1512, 176, -96},
    { 1336, 224, -144},
    { 1288, 160, -32},
    { 728, -528, -32},
    { 1024, -136, 40},
    { 808, -224, -184},
    { 968, 168, -248},
    { 1320, 280, -216},
    { 1240, 352, -328},
    { 1336, 248, -320},
    { 1560, 456, -264},
    { 1592, 928, -456},
    { 1424, 800, -360},
    { 1248, 1088, -400},
    // 19 seconds
    { 784, 1336, -336},
    { 680, 960, -240},
    { 1088, 1176, -160},
    { 1072, 768, -40},
    { 1344, 824, -8},
    { 1664, 688, 0},
    { 1488, 456, -32},
    { 1336, 400, -120},
    { 1432, 384, -136},
    { 1616, 400, -136},
    { 1456, 216, -160},
    { 1296, 144, -192},
    { 952, -368, 88},
    { 488, -408, -104},
    { 880, -88, -112},
    { 856, -136, -192},
    { 1024, 208, -352},
    { 1208, 176, -360},
    { 1240, 264, -400},
    { 1312, 280, -264},
    { 1440, 576, -296},
    { 1520, 784, -384},
    { 1528, 824, -304},
    { 1312, 1016, -432},
    { 776, 1232, -496},
    // 20 seconds
    { 848, 1040, -368},
    { 1072, 920, -248},
    { 1064, 816, -184},
    { 1320, 752, -120},
    { 1488, 616, -96},
    { 1224, 400, -104},
    { 1144, 368, -136},
    { 1216, 296, -120},
    { 1408, 320, -184},
    { 1536, 248, -144},
    { 1576, 248, -152},
    { 1200, -288, 96},
    { 936, -600, 64},
    { 648, -288, -192},
    { 1048, -16, -352},
    { 1592, -136, -24},
    { 1496, 440, -240},
    { 1288, 184, -320},
    { 1360, 328, -192},
    { 1568, 536, -128},
    { 1528, 856, -216},
    { 1304, 744, -224},
    { 1144, 912, -328},
    { 864, 1120, -376},
    { 736, 920, -280},
    // 21 seconds
    { 1040, 1016, -328},
    { 928, 776, -160},
    { 1328, 840, -136},
    { 1816, 760, -192},
    { 1616, 464, -72},
    { 1512, 424, -112},
    { 1528, 272, -112},
    { 1616, 336, -128},
    { 1584, 216, -96},
    { 1384, 192, -88},
    { 1248, 72, 16},
    { 768, -584, 104},
    { 880, -288, 48},
    { 792, -112, -320},
    { 1144, 48, -88},
    { 1488, 248, -168},
    { 1312, 272, -312},
    { 1336, 256, -224},
    { 1544, 504, -168},
    { 1688, 784, -184},
    { 1592, 760, -168},
    { 1392, 944, -224},
    { 1032, 1024, -208},
    { 688, 1144, -184},
    { 960, 1176, -160},
    // 22 seconds
    { 880, 824, -48},
    { 1184, 896, -64},
    { 1472, 752, -72},
    { 1472, 512, -88},
    { 1344, 408, -88},
    { 1416, 360, -184},
    { 1616, 344, -128},
    { 1768, 264, -56},
    { 1600, 224, -104},
    { 1496, 80, -48},
    { 712, -656, 80},
    { 960, -392, -40},
    { 840, -344, -88},
    { 1216, 120, -208},
    { 1472, 224, -152},
    { 1312, 352, -288},
    { 1328, 208, -248},
    { 1488, 440, -160},
    { 1672, 696, -184},
    { 1616, 880, -200},
    { 1312, 920, -248},
    { 960, 1088, -328},
    { 640, 1136, -312},
    { 968, 1208, -248},
    { 912, 760, -128},
    // 23 seconds
    { 1152, 896, -160},
    { 1504, 808, -128},
    { 1584, 544, -56},
    { 1440, 384, -88},
    { 1480, 368, -120},
    { 1656, 344, -88},
    { 1688, 240, -48},
    { 1576, 264, -80},
    { 1576, 224, -112},
    { 880, -768, 8},
    { 944, -424, -40},
    { 664, -496, -104},
    { 1056, 88, -256},
    { 1480, 8, -72},
    { 1384, 448, -328},
    { 1336, 192, -256},
    { 1496, 440, -216},
    { 1672, 688, -280},
    { 1608, 880, -328},
    { 1368, 952, -448},
    { 904, 1160, -616},
    { 624, 1072, -488},
    { 1096, 1144, -456},
    { 1032, 728, -208},
    { 1360, 888, -224},
    // 24 seconds
    { 1608, 712, -160},
    { 1488, 480, -112},
    { 1440, 408, -136},
    { 1400, 368, -120},
    { 1480, 368, -144},
    { 1640, 296, -96},
    { 1528, 184, -40},
    { 1200, 208, -120},
    { 1056, -336, 8},
    { 816, -488, 184},
    { 616, -504, -216},
    { 1080, 8, -248},
    { 1496, -32, -56},
    { 1376, 512, -296},
    { 1344, 184, -176},
    { 1616, 488, -176},
    { 1872, 784, -256},
    { 1664, 968, -248},
    { 1344, 848, -408},
    { 968, 1064, -544},
    { 632, 1208, -520},
    { 888, 952, -408},
    { 1032, 984, -280},
    { 1128, 888, -240},
    { 1496, 832, -160},
    // 25 seconds
    { 1776, 640, -88},
    { 1616, 408, -80},
    { 1496, 368, -136},
    { 1520, 344, -96},
    { 1536, 320, -96},
    { 1496, 272, -72},
    { 1384, 272, -72},
    { 1056, 32, -64},
    { 624, -656, 16},
    { 632, -480, -40},
    { 888, -136, -336},
    { 1192, -96, -40},
    { 1408, 312, -200},
    { 1224, 280, -208},
    { 1304, 328, -200},
    { 1600, 456, -176},
    { 1792, 680, -288},
    { 1832, 944, -344},
    { 1424, 1040, -496},
    { 864, 1304, -768},
    { 640, 1120, -720},
    { 1040, 968, -488},
    { 1072, 776, -416},
    { 1200, 864, -320},
    { 1480, 760, -280},
    // 26 seconds
    { 1424, 440, -120},
    { 1312, 376, -160},
    { 1416, 344, -208},
    { 1536, 336, -136},
    { 1736, 272, -152},
    { 1544, 216, -40},
    { 1208, 248, -112},
    { 832, -592, -80},
    { 760, -312, 72},
    { 736, -392, -200},
    { 1096, 80, -184},
    { 1384, 256, -232},
    { 1344, 320, -296},
    { 1408, 320, -304},
    { 1600, 512, -200},
    { 1768, 792, -248},
    { 1584, 752, -256},
    { 1376, 1016, -296},
    { 1024, 1152, -376},
    { 672, 1160, -320},
    { 944, 1144, -264},
    { 792, 792, -120},
    { 1168, 920, -144},
    { 1536, 776, -88},
    { 1632, 568, -88},
    // 27 seconds
    { 1480, 448, -128},
    { 1488, 416, -160},
    { 1608, 368, -184},
    { 1712, 288, -136},
    { 1424, 152, -88},
    { 1200, 216, -216},
    { 720, -464, 8},
    { 504, -280, -208},
    { 576, -360, -72},
    { 936, 16, -216},
    { 1256, 168, -232},
    { 1464, 440, -408},
    { 1440, 184, -240},
    { 1432, 376, -248},
    { 1568, 648, -200},
    { 1656, 824, -240},
    { 1496, 744, -216},
    { 1264, 888, -224},
    { 816, 1184, -224},
    { 704, 1088, -168},
    { 944, 1160, -104},
    { 920, 776, -24},
    { 1208, 912, -48},
    { 1592, 800, -56},
    { 1560, 536, -72},
    // 28 seconds
    { 1376, 424, -112},
    { 1440, 376, -136},
    { 1520, 344, -136},
    { 1568, 264, -120},
    { 1416, 168, -104},
    { 1224, 208, -136},
    { 920, -160, 40},
    { 672, -336, 80},
    { 464, -328, -192},
    { 904, 136, -320},
    { 1240, -16, -80},
    { 1360, 424, -376},
    { 1240, 144, -264},
    { 1312, 376, -232},
    { 1536, 544, -216},
    { 1752, 768, -304},
    { 1560, 856, -240},
    { 1288, 1088, -384},
    { 832, 1344, -408},
    { 680, 904, -304},
    { 856, 1264, -304},
    { 888, 800, -120},
    { 1120, 856, -160},
    { 1656, 776, -72},
    { 1752, 512, -48},
    // 29 seconds
    { 1480, 408, -112},
    { 1520, 392, -184},
    { 1632, 312, -40},
    { 1432, 272, -112},
    { 1336, 256, -128},
    { 1032, -112, -24},
    { 584, -408, -136},
    { 992, -248, -192},
    { 856, -304, -240},
    { 1112, 208, -464},
    { 1400, 128, -328},
    { 1416, 304, -392},
    { 1408, 288, -264},
    { 1488, 624, -240},
    { 1592, 768, -312},
    { 1496, 848, -240},
    { 1232, 1032, -288},
    { 832, 1240, -496},
    { 624, 1048, -408},
    { 968, 1144, -432},
    { 1048, 720, -152},
    { 1400, 880, -192},
    { 1568, 704, -136},
    { 1616, 536, -88},
    { 1536, 440, 16},
    // 30 seconds
    { 1544, 296, 56},
    { 1528, 280, 48},
    { 1704, 176, 56},
    { 1296, 48, 48},
    { 1152, -288, 72},
    { 656, -568, 8},
    { 920, -296, -152},
    { 824, -176, -352},
    { 1264, 96, -320},
    { 1760, 320, -416},
    { 1528, 224, -344},
    { 1368, 304, -240},
    { 1400, 624, -192},
    { 1512, 720, -216},
    { 1416, 696, -176},
    { 1256, 816, -224},
    { 896, 1080, -280},
    { 632, 1112, -264},
    { 824, 1056, -216},
    { 1000, 816, -128},
    { 1264, 864, -152},
    { 1608, 760, -112},
    { 1816, 616, -136},
    { 1672, 408, -112},
    { 1504, 288, -192},
    // 31 seconds
    { 1528, 344, -88},
    { 1488, 160, -72},
    { 1432, 208, -104},
    { 1248, 192, -24},
    { 928, -272, 128},
    { 680, -368, 24},
    { 608, -488, 192},
    { 1128, 88, -104},
    { 1456, 48, -64},
    { 1552, 352, -320},
    { 1432, 120, -248},
    { 1488, 320, -320},
    { 1616, 576, -312},
    { 1720, 840, -224},
    { 1560, 832, -304},
    { 1240, 976, -384},
    { 776, 1088, -368},
    { 824, 1184, -352},
    { 856, 744, -136},
    { 1104, 944, -184},
    { 1360, 792, -96},
    { 1640, 696, -144},
    { 1496, 448, -112},
    { 1456, 376, -128},
    { 1544, 304, -136},
    // 32 seconds
    { 1608, 288, -120},
    { 1632, 216, -96},
    { 1368, 240, -104},
    { 1152, -152, 72},
    { 688, -440, 8},
    { 768, -424, 56},
    { 920, -96, -248},
    { 1144, 80, -168},
    { 1472, 272, -160},
    { 1320, 288, -256},
    { 1400, 320, -192},
    { 1696, 568, -184},
    { 1736, 872, -184},
    { 1568, 824, -224},
    { 1288, 1032, -328},
    { 744, 1264, -352},
    { 640, 1040, -256},
    { 1040, 1112, -240},
    { 1016, 800, -112},
    { 1312, 856, -88},
    { 1648, 712, -80},
    { 1576, 472, -88},
    { 1384, 416, -128},
    { 1408, 336, -120},
    { 1528, 368, -128},
    // 33 seconds
    { 1560, 208, -80},
    { 1360, 208, -88},
    { 1264, 64, -56},
    { 728, -544, -8},
    { 1024, -328, 48},
    { 792, -200, -328},
    { 1200, 80, -208},
    { 1672, 192, -152},
    { 1384, 336, -376},
    { 1288, 240, -296},
    { 1376, 448, -176},
    { 1616, 656, -216},
    { 1648, 888, -232},
    { 1280, 1024, -328},
    { 872, 1088, -368},
    { 616, 1136, -360},
    { 1080, 1240, -320},
    { 976, 704, -208},
    { 1224, 880, -192},
    { 1624, 704, -176},
    { 1424, 480, -168},
    { 1328, 424, -160},
    { 1432, 344, -192},
    { 1504, 304, -152},
    { 1616, 232, -168},
    // 34 seconds
    { 1512, 192, -120},
    { 1272, 192, -176},
    { 856, -400, 0},
    { 840, -264, -88},
    { 552, -472, -144},
    { 1120, 88, -264},
    { 1392, 40, -184},
    { 1344, 384, -328},
    { 1240, 192, -224},
    { 1432, 384, -152},
    { 1760, 600, -168},
    { 1744, 960, -168},
    { 1448, 1048, -168},
    { 1104, 1160, -328},
    { 544, 1320, -336},
    { 760, 1112, -224},
    { 1000, 1008, -144},
    { 1128, 888, -136},
    { 1488, 840, -104},
    { 1776, 648, -72},
    { 1440, 400, -72},
    { 1408, 368, -144},
    { 1560, 352, -152},
    { 1616, 264, -104},
    { 1360, 200, -112},
    // 35 seconds
    { 1296, 176, -184},
    { 848, -432, 8},
    { 752, -320, -184},
    { 672, -416, -96},
    { 968, 64, -272},
    { 1344, 56, -96},
    { 1336, 352, -336},
    { 1200, 152, -232},
    { 1232, 312, -184},
    { 1456, 520, -240},
    { 1656, 728, -256},
    { 1496, 912, -264},
    { 1256, 1016, -416},
    { 760, 1336, -456},
    { 632, 1088, -328},
    { 1080, 1168, -248},
    { 1032, 768, -128},
    { 1312, 840, -112},
    { 1616, 712, -96},
    { 1632, 456, -80},
    { 1432, 376, -80},
    { 1400, 328, -136},
    { 1408, 296, -144},
    { 1368, 256, -80},
    { 1296, 224, -96},
    // 36 seconds
    { 1080, 80, -80},
    { 648, -416, -88},
    { 944, -264, -80},
    { 704, -384, -72},
    { 1136, 160, -248},
    { 1376, 184, -160},
    { 1320, 392, -296},
    { 1304, 248, -208},
    { 1424, 472, -240},
    { 1600, 664, -280},
    { 1456, 728, -256},
    { 1296, 864, -384},
    { 1024, 1016, -472},
    { 728, 1088, -504},
    { 912, 976, -448},
    { 1048, 856, -256},
    { 1144, 800, -256},
    { 1528, 728, -232},
    { 1648, 608, -128},
    { 1464, 376, -104},
    { 1336, 312, -72},
    { 1368, 296, -120},
    { 1456, 296, -80},
    { 1440, 192, -56},
    { 1240, 184, -8},
    // 37 seconds
    { 1096, 96, 0},
    { 824, -496, 32},
    { 648, -288, 32},
    { 872, -8, -288},
    { 1128, 16, -64},
    { 1416, 336, -200},
    { 1224, 288, -264},
    { 1288, 248, -176},
    { 1568, 488, -224},
    { 1760, 752, -256},
    { 1552, 896, -360},
    { 1296, 1096, -560},
    { 688, 1328, -664},
    { 704, 1096, -592},
    { 1136, 1136, -424},
    { 1128, 720, -216},
    { 1472, 768, -200},
    { 1672, 672, -96},
    { 1720, 496, -56},
    { 1464, 376, -80},
    { 1400, 344, -120},
    { 1384, 312, -72},
    { 1360, 272, -96},
    { 1312, 216, -32},
    { 1104, 176, -48},
    // 38 seconds
    { 648, -256, 0},
    { 552, -240, -88},
    { 440, -224, -184},
    { 920, 176, -248},
    { 1176, 48, -168},
    { 1424, 384, -336},
    { 1376, 240, -304},
    { 1464, 400, -224},
    { 1704, 632, -288},
    { 1848, 768, -272},
    { 1584, 1000, -448},
    { 1016, 1216, -600},
    { 664, 1360, -712},
    { 736, 912, -648},
    { 1040, 976, -488},
    { 1208, 720, -304},
    { 1496, 792, -232},
    { 2000, 720, -128},
    { 1672, 408, -48},
    { 1400, 376, -112},
    { 1416, 392, -96},
    { 1496, 312, 8},
    { 1424, 264, -48},
    { 1288, 200, -24},
    { 1000, -32, 80},
    // 39 seconds
    { 616, -328, 0},
    { 816, -136, -72},
    { 704, -120, -224},
    { 1032, 152, -216},
    { 1312, 168, -136},
    { 1400, 264, -288},
    { 1600, 304, -216},
    { 1784, 512, -112},
    { 1880, 896, -248},
    { 1672, 752, -128},
    { 1384, 1032, -320},
    { 976, 1024, -320},
    { 688, 1144, -376},
    { 976, 1104, -312},
    { 944, 896, -192},
    { 1088, 864, -192},
    { 1376, 760, -112},
    { 1664, 616, -56},
    { 1592, 440, -80},
    { 1448, 312, -32},
    { 1592, 336, -48},
    { 1760, 240, -64},
    { 1512, 128, 24},
    { 1264, 168, 0},
    { 1032, 160, 72},
    // 40 seconds
    { 880, -408, 96},
    { 704, -208, 80},
    { 856, 64, -320},
    { 1072, 0, -24},
    { 1344, 248, -144},
    { 1176, 224, -280},
    { 1344, 280, -208},
    { 1624, 496, -208},
    { 1936, 960, -296},
    { 1744, 808, -208},
    { 1288, 1088, -304},
    { 808, 1104, -224},
    { 664, 1032, -232},
    { 880, 1144, -216},
    { 1008, 1040, -40},
    { 1256, 904, -48},
    { 1568, 760, -56},
    { 1784, 528, -16},
    { 1536, 360, -72},
    { 1496, 344, -152},
    { 1552, 352, -112},
    { 1568, 304, -96},
    { 1416, 264, -96},
    { 1248, 128, -56},
    { 736, -464, 0},
    // 41 seconds
    { 888, -296, -64},
    { 704, -336, -64},
    { 1088, 144, -240},
    { 1472, 80, -72},
    { 1472, 424, -328},
    { 1416, 224, -224},
    { 1568, 432, -200},
    { 1824, 632, -224},
    { 1720, 944, -176},
    { 1456, 1048, -296},
    { 960, 1272, -376},
    { 592, 1240, -320},
    { 792, 952, -224},
    { 1040, 1056, -112},
    { 1144, 800, -72},
    { 1480, 832, -24},
    { 1832, 720, 0},
    { 1664, 464, -8},
    { 1448, 384, -72},
    { 1488, 376, -104},
    { 1544, 304, -72},
    { 1520, 200, -56},
    { 1312, 160, -48},
    { 1056, -40, 16},
    { 816, -488, 144},
    // 42 seconds
    { 712, -240, 32},
    { 920, 184, -368},
    { 1176, 24, -120},
    { 1392, 376, -312},
    { 1328, 144, -312},
    { 1384, 264, -336},
    { 1560, 488, -272},
    { 1736, 888, -376},
    { 1656, 768, -224},
    { 1264, 1056, -304},
    { 792, 1080, -288},
    { 648, 960, -224},
    { 880, 976, -264},
    { 1000, 840, -104},
    { 1176, 800, -128},
    { 1672, 760, -184},
    { 1696, 568, -32},
    { 1480, 416, -104},
    { 1456, 368, -160},
    { 1520, 440, -104},
    { 1632, 224, -88},
    { 1552, 184, -72},
    { 1264, 168, -104},
    { 728, -576, -16},
    { 888, -136, -216},
    // 43 seconds
    { 632, -416, -48},
    { 1160, 160, -216},
    { 1448, 184, -176},
    { 1360, 392, -312},
    { 1368, 232, -232},
    { 1448, 472, -184},
    { 1664, 704, -144},
    { 1712, 832, -128},
    { 1440, 944, -72},
    { 1008, 1032, -112},
    { 616, 1024, -128},
    { 848, 1064, -32},
    { 992, 856, 56},
    { 1200, 872, -24},
    { 1408, 816, -48},
    { 1552, 640, -32},
    { 1424, 472, -72},
    { 1336, 336, -48},
    { 1456, 248, -64},
    { 1640, 248, -104},
    { 1680, 208, -48},
    { 1504, 232, -56},
    { 1200, 128, -24},
    { 592, -448, -64},
    { 816, -344, -64},
    // 44 seconds
    { 768, -344, -88},
    { 1112, 120, -248},
    { 1424, 176, -144},
    { 1328, 400, -272},
    { 1344, 264, -208},
    { 1520, 504, -160},
    { 1832, 720, -168},
    { 1688, 944, -96},
    { 1288, 1296, -144},
    { 704, 1472, -152},
    { 672, 1232, -56},
    { 1160, 1144, -16},
    { 1352, 992, 40},
    { 1512, 840, 8},
    { 1720, 752, -48},
    { 1656, 448, 0},
    { 1520, 344, -64},
    { 1680, 216, -16},
    { 1816, 288, 56},
    { 1464, 112, 48},
    { 1168, -48, 56},
    { 848, -224, 24},
    { 560, -280, -112},
    { 976, -104, -104},
    { 896, -24, -224},
    // 45 seconds
    { 1096, 224, -360},
    { 1552, 240, -408},
    { 1680, 336, -440},
    { 1656, 312, -336},
    { 1696, 504, -328},
    { 1576, 856, -264},
    { 1096, 760, -320},
    { 800, 936, -296},
    { 792, 1104, -216},
    { 896, 1064, -128},
    { 848, 912, -152},
    { 1128, 1168, -56},
    { 1272, 728, 48},
    { 1416, 728, -56},
    { 1488, 616, -8},
    { 1464, 448, -8},
    { 1336, 328, -32},
    { 1344, 344, -96},
    { 1408, 360, -120},
    { 1328, 272, -120},
    { 1216, 208, -144},
    { 1176, 136, -224},
    { 712, -504, -32},
    { 1184, -248, -144},
    { 1104, -264, -224},
    // 46 seconds
    { 1416, 128, -272},
    { 1664, 248, -184},
    { 1408, 296, -288},
    { 1368, 248, -208},
    { 1504, 480, -96},
    { 1648, 784, -104},
    { 1608, 808, -104},
    { 1392, 896, -136},
    { 1120, 1040, -104},
    { 808, 1080, -24},
    { 784, 1056, -104},
    { 608, 832, -32},
    { 864, 784, -16},
    { 1600, 752, -40},
    { 2032, 544, 24},
    { 1872, 240, -32},
    { 1656, 160, 64},
    { 1480, 328, -160},
    { 1312, 144, -24},
    { 1496, 48, 8},
    { 1352, -120, 8},
    { 880, -320, 24},
    { 1168, -208, 40},
    { 1120, -224, -120},
    { 1264, 256, -336},
    // 47 seconds
    { 1504, 144, -192},
    { 1360, 312, -344},
    { 1248, 248, -280},
    { 1296, 408, -112},
    { 1504, 704, -216},
    { 1512, 808, -64},
    { 1192, 872, -120},
    { 944, 1008, -128},
    { 816, 1072, -96},
    { 808, 792, -112},
    { 880, 824, -128},
    { 1368, 664, -104},
    { 1600, 608, -112},
    { 1360, 360, -128},
    { 1192, 392, -152},
    { 1376, 72, -80},
    { 1584, 296, -104},
    { 1704, 208, -168},
    { 1504, -96, -24},
    { 904, -488, -168},
    { 1392, -392, 0},
    { 1088, -504, -128},
    { 1352, -56, -184},
    { 1416, 64, -152},
    { 1272, 240, -216},
    // 48 seconds
    { 1216, 264, -232},
    { 1400, 432, -88},
    { 1584, 672, -176},
    { 1568, 920, -80},
    { 1304, 960, -40},
    { 992, 1128, -112},
    { 680, 1168, 8},
    { 944, 1048, -24},
    { 824, 752, -16},
    { 1104, 768, -24},
    { 1480, 728, -32},
    { 1464, 496, -24},
    { 1352, 416, -104},
    { 1432, 336, -120},
    { 1568, 360, -120},
    { 1760, 208, -112},
    { 1464, 176, -72},
    { 1312, -88, -24},
    { 840, -480, 24},
    { 896, -488, 16},
    { 1048, -72, -344},
    { 1288, -64, -120},
    { 1376, 296, -160},
    { 1152, 192, -248},
    { 1232, 304, -200},
    // 49 seconds
    { 1496, 456, -88},
    { 1760, 736, -152},
    { 1664, 1104, -104},
    { 1240, 1032, -240},
    { 720, 1360, -104},
    { 696, 1304, 56},
    { 1032, 856, 24},
    { 1032, 856, 16},
    { 1320, 768, 48},
    { 1576, 680, 32},
    { 1344, 448, -24},
    { 1336, 408, -80},
    { 1464, 368, -104},
    { 1608, 288, -80},
    { 1648, 160, -96},
    { 1368, 176, -112},
    { 1200, -24, -24},
    { 904, -592, 168},
    { 704, -384, -128},
    { 992, 88, -392},
    { 1264, -56, -32},
    { 1408, 264, -160},
    { 1168, 264, -232},
    { 1336, 296, -216},
    { 1792, 512, -152},
    // 50 seconds
    { 2016, 816, -224},
    { 1616, 1208, -200},
    { 1096, 1008, -328},
    { 624, 1280, -344},
    { 552, 1272, -160},
    { 1000, 1176, -176},
    { 1224, 928, -152},
    { 1552, 848, -136},
    { 1808, 744, -80},
    { 1720, 472, -48},
    { 1584, 384, -64},
    { 1568, 392, -64},
    { 1616, 352, -96},
    { 1688, 232, 24},
    { 1304, 128, 24},
    { 992, 168, -88},
    { 680, -728, -88},
    { 664, -400, -56},
    { 848, -208, -272},
    { 1200, 0, -152},
    { 1464, 200, -152},
    { 1360, 392, -304},
    { 1472, 272, -136},
    { 1776, 528, -192},
    { 1888, 752, -200},
    // 51 seconds
    { 1928, 936, -248},
    { 1520, 1152, -360},
    { 952, 1192, -368},
    { 656, 1152, -432},
    { 1072, 1336, -400},
    { 1000, 712, -128},
    { 1208, 920, -200},
    { 1600, 760, -104},
    { 1656, 560, -80},
    { 1456, 400, -80},
    { 1376, 352, -144},
    { 1480, 376, -72},
    { 1640, 288, -56},
    { 1560, 176, -16},
    { 1168, 168, -32},
    { 896, -504, 96},
    { 1040, -112, -24},
    { 792, -264, -80},
    { 1008, 184, -216},
    { 1296, 128, -144},
    { 1344, 344, -264},
    { 1288, 168, -208},
    { 1432, 384, -136},
    { 1616, 624, -208},
    { 1656, 832, -192},
    // 52 seconds
    { 1456, 928, -288},
    { 1160, 1104, -344},
    { 752, 1136, -368},
    { 1008, 1248, -352},
    { 936, 752, -80},
    { 1352, 944, -144},
    { 1544, 752, -80},
    { 1480, 512, -56},
    { 1256, 360, -80},
    { 1232, 304, -136},
    { 1456, 328, -144},
    { 1752, 288, -56},
    { 1592, 192, -64},
    { 1504, 136, -32},
    { 1096, -656, 120},
    { 776, -296, -152},
    { 992, -72, -352},
    { 1296, -176, -32},
    { 1264, 184, -88},
    { 888, 192, -280},
    { 920, 208, -200},
    { 1128, 296, -120},
    { 1528, 592, -248},
    { 1704, 864, -224},
    { 1392, 1088, -272},
    // 53 seconds
    { 1096, 952, -424},
    { 696, 1032, -216},
    { 1048, 1176, -168},
    { 896, 672, -104},
    { 1352, 712, -200},
    { 1544, 768, -72},
    { 1472, 488, -48},
    { 1336, 352, -152},
    { 1264, 184, -24},
    { 1280, 408, -136},
    { 1432, 264, -96},
    { 1408, 200, -64},
    { 1176, 160, -56},
    { 888, -40, -88},
    { 864, -80, -40},
    { 784, -224, -144},
    { 1024, 224, -416},
    { 1208, -8, -176},
    { 1112, 216, -208},
    { 944, 184, -232},
    { 992, 336, -176},
    { 1232, 408, -104},
    { 1672, 672, -152},
    { 1664, 944, -200},
    { 1344, 960, -288},
    // 54 seconds
    { 984, 1080, -240},
    { 984, 1312, -32},
    { 1048, 864, -80},
    { 1056, 1008, -72},
    { 1376, 960, -16},
    { 1568, 808, -24},
    { 1576, 736, -24},
    { 1616, 704, -40},
    { 1696, 768, -144},
    { 1760, 1168, -224},
    { 1536, 440, -192},
    { 1048, 240, -224},
    { 680, 192, -312},
    { 312, -176, -328},
    { 168, -376, -352},
    { -24, -352, -456},
    { -72, -416, -608},
    { 24, -208, -848},
    { 144, -280, -824},
    { 96, -200, -800},
    { -48, -280, -816},
    { -144, -256, -816},
    { -248, -288, -912},
    { -344, -312, -1120},
    { -432, -288, -1224},
    // 55 seconds
    { -400, -104, -1552},
    { -304, -80, -1592},
    { -176, 96, -1688},
    { -312, -24, -1224},
    { -312, 112, -1200},
    { -176, 88, -1032},
    { -40, 8, -880},
    { -40, -136, -680},
    { -32, -152, -544},
    { 40, -120, -504},
    { 248, -40, -408},
    { 536, -24, -400},
    { 944, 192, -424},
    { 1080, 144, -400},
    { 1448, 456, -432},
    { 1880, 352, -480},
    { 2256, 528, -784},
    { 2088, 768, -680},
    { 1176, 720, -360},
    { 896, 120, -288},
    { 896, 552, -352},
    { 760, 600, -320},
    { 656, 696, -528},
    { 696, 912, -680},
    { 840, 736, -624},
    // 56 seconds
    { 1064, 464, -528},
    { 1368, 592, -424},
    { 1224, 256, -200},
    { 1584, 448, -304},
    { 1752, 352, -96},
    { 1520, 336, -224},
    { 1056, 56, 0},
    { 928, 400, -200},
    { 1160, 224, -264},
    { 1288, 120, -168},
    { 1088, -232, 0},
    { 800, -384, -32},
    { 1168, -56, -216},
    { 928, -16, -192},
    { 1224, 200, -336},
    { 1584, 336, -240},
    { 1456, 200, -240},
    { 1376, 248, -232},
    { 1424, 464, -152},
    { 1512, 696, -176},
    { 1400, 824, -136},
    { 1144, 952, -136},
    { 696, 1104, -192},
    { 648, 872, -128},
    { 936, 968, -88},
    // 57 seconds
    { 880, 664, -16},
    { 1192, 728, -120},
    { 1576, 664, -24},
    { 1656, 472, -72},
    { 1496, 360, -160},
    { 1520, 392, -224},
    { 1672, 376, -104},
    { 1656, 240, -152},
    { 1496, 200, -224},
    { 1360, 104, -216},
    { 768, -768, 16},
    { 1048, -312, 0},
    { 848, -152, -392},
    { 1104, 48, -256},
    { 1440, 272, -264},
    { 1296, 216, -328},
    { 1336, 264, -232},
    { 1536, 528, -200},
    { 1688, 864, -224},
    { 1624, 904, -168},
    { 1200, 920, -264},
    { 856, 952, -256},
    { 712, 1024, -264},
    { 1008, 1040, -160},
    { 944, 904, -208},
    // 58 seconds
    { 1160, 744, -168},
    { 1592, 672, -184},
    { 1560, 432, -120},
    { 1576, 392, -224},
    { 1616, 192, -72},
    { 1672, 352, -192},
    { 1552, 256, -168},
    { 1584, 224, -192},
    { 1192, -104, 80},
    { 760, -472, 16},
    { 608, -288, -88},
    { 712, 112, -448},
    { 1104, -56, -56},
    { 1432, 336, -272},
    { 1256, 248, -384},
    { 1296, 304, -256},
    { 1512, 424, -184},
    { 1640, 752, -256},
    { 1512, 896, -152},
    { 1208, 1040, -232},
    { 792, 1176, -136},
    { 680, 960, -96},
    { 984, 992, -120},
    { 872, 680, -88},
    { 1160, 784, -64},
    // 59 seconds
    { 1488, 672, 0},
    { 1664, 464, -32},
    { 1528, 368, -120},
    { 1496, 288, -104},
    { 1584, 344, -112},
    { 1504, 248, -96},
    { 1216, 144, -112},
    { 1056, -80, -48},
    { 624, -424, -16},
    { 1040, -168, -160},
    { 880, -152, -232},
    { 1128, 184, -336},
    { 1552, 184, -256},
    { 1456, 304, -352},
    { 1280, 264, -288},
    { 1328, 448, -176},
    { 1608, 568, -136},
    { 1616, 752, -64},
    { 1392, 896, 8},
    { 1096, 1040, 32},
    { 696, 1008, 16},
    { 728, 984, 120},
    { 848, 776, 144},
    { 1024, 744, 48},
    { 1240, 720, 40},
    // 60 seconds
    // elapsed: 1 minutes
    { 1568, 672, 24},
    { 1464, 472, -40},
    { 1512, 472, -112},
    { 1680, 232, -24},
    { 1624, 368, -72},
    { 1496, 184, -80},
    { 1344, 272, -104},
    { 1120, 24, -40},
    { 992, -336, 48},
    { 600, -384, -32},
    { 760, 104, -448},
    { 1104, -120, -120},
    { 1240, 280, -248},
    { 1008, 136, -360},
    { 1056, 272, -256},
    { 1288, 336, -176},
    { 1560, 608, -224},
    { 1688, 880, -192},
    { 1400, 960, -208},
    { 1072, 1048, -288},
    { 632, 1072, -152},
    { 928, 904, -80},
    { 880, 696, -72},
    { 1168, 800, -40},
    { 1384, 728, -32},
    // 61 seconds
    { 1304, 504, -72},
    { 1160, 448, -96},
    { 1256, 408, -128},
    { 1432, 328, -144},
    { 1568, 208, -128},
    { 1536, 112, -88},
    { 1240, 192, -160},
    { 880, -288, 0},
    { 888, -264, -24},
    { 568, -224, -232},
    { 904, 168, -416},
    { 1280, -16, -208},
    { 1168, 352, -288},
    { 1032, 72, -336},
    { 1048, 288, -160},
    { 1384, 440, -160},
    { 1536, 736, -216},
    { 1472, 848, -168},
    { 1144, 888, -208},
    { 912, 864, -168},
    { 720, 848, -120},
    { 976, 960, -56},
    { 936, 760, -64},
    { 1128, 760, -64},
    { 1352, 728, -96},
    // 62 seconds
    { 1384, 512, -96},
    { 1160, 400, -112},
    { 1280, 368, -168},
    { 1360, 264, -96},
    { 1336, 208, -144},
    { 1440, 192, -112},
    { 1248, 136, -88},
    { 872, -88, 16},
    { 872, -208, -88},
    { 640, -248, -144},
    { 976, 120, -320},
    { 1240, 80, -240},
    { 1296, 288, -328},
    { 1112, 112, -288},
    { 1112, 264, -192},
    { 1320, 416, -88},
    { 1616, 744, -128},
    { 1448, 872, -24},
    { 1200, 960, -104},
    { 952, 936, -40},
    { 712, 992, -32},
    { 968, 1000, -16},
    { 968, 736, -16},
    { 1120, 800, -32},
    { 1440, 720, -88},
    // 63 seconds
    { 1312, 480, -88},
    { 1280, 448, -128},
    { 1392, 384, -128},
    { 1552, 288, -144},
    { 1592, 168, -40},
    { 1432, 136, -32},
    { 1224, 200, -40},
    { 936, -160, 72},
    { 728, -216, 88},
    { 688, -288, -56},
    { 944, 96, -264},
    { 1192, 56, -160},
    { 1384, 432, -344},
    { 1208, 192, -352},
    { 1320, 272, -256},
    { 1576, 496, -248},
    { 1680, 1016, -264},
    { 1448, 824, -240},
    { 936, 1040, -312},
    { 584, 1232, -184},
    { 792, 888, -104},
    { 1112, 984, -192},
    { 968, 712, -32},
    { 1408, 832, -80},
    { 1776, 688, -16},
    // 64 seconds
    { 1704, 464, -56},
    { 1416, 376, -72},
    { 1368, 352, -96},
    { 1416, 288, -96},
    { 1408, 272, -120},
    { 1288, 208, -144},
    { 1040, 16, -104},
    { 432, -520, -48},
    { 768, -200, -160},
    { 592, -184, -160},
    { 1080, 136, -216},
    { 1400, 240, -280},
    { 1400, 304, -328},
    { 1368, 208, -264},
    { 1416, 408, -264},
    { 1736, 544, -216},
    { 1760, 736, -232},
    { 1560, 888, -360},
    { 1072, 1120, -448},
    { 688, 1232, -480},
    { 776, 880, -352},
    { 1000, 1088, -264},
    { 912, 648, -176},
    { 1216, 760, -144},
    { 1560, 736, -112},
    // 65 seconds
    { 1624, 488, -88},
    { 1528, 400, -64},
    { 1448, 296, -120},
    { 1384, 264, -80},
    { 1368, 208, -80},
    { 1328, 168, -16},
    { 1128, 200, -48},
    { 744, -144, 56},
    { 792, -304, 96},
    { 752, -312, -152},
    { 1128, 144, -360},
    { 1528, 56, -264},
    { 1360, 368, -312},
    { 1224, 96, -280},
    { 1296, 344, -312},
    { 1528, 400, -216},
    { 1608, 864, -304},
    { 1272, 832, -264},
    { 1128, 968, -384},
    { 792, 1024, -296},
    { 736, 784, -184},
    { 888, 1016, -176},
    { 944, 776, -8},
    { 1304, 920, -48},
    { 1880, 888, -88},
    // 66 seconds
    { 1848, 608, -24},
    { 1656, 800, -56},
    { 1720, 880, 0},
    { 1728, 888, -288},
    { 1784, 1152, -312},
    { 1424, 736, -240},
    { 1184, 120, -240},
    { 616, -64, -216},
    { 472, -216, -224},
    { 32, -280, -384},
    { 136, -480, -496},
    { 184, -432, -664},
    { 184, -432, -704},
    { 80, -560, -688},
    { -48, -504, -704},
    { -208, -512, -728},
    { -312, -584, -856},
    { -448, -616, -992},
    { -424, -552, -1168},
    { -280, -584, -1320},
    { -336, -552, -1232},
    { -200, -472, -1328},
    { -224, -408, -1040},
    { -248, -296, -1016},
    { -104, -312, -904},
    // 67 seconds
    { -80, -376, -752},
    { -56, -384, -632},
    { 8, -448, -504},
    { 104, -464, -432},
    { 264, -240, -496},
    { 448, -368, -440},
    { 736, -192, -336},
    { 1248, 112, -192},
    { 1696, 544, -256},
    { 2256, 520, -504},
    { 2424, 552, -552},
    { 1976, 816, -440},
    { 1296, 312, -256},
    { 1624, 424, -304},
    { 1496, 608, -160},
    { 1384, 728, -16},
    { 1264, 1176, 8},
    { 648, 1544, 72},
    { 632, 992, -88},
    { 864, 1120, 0},
    { 936, 808, 24},
    { 1344, 824, -88},
    { 1720, 816, -56},
    { 2072, 672, -96},
    { 1768, 464, -80},
    // 68 seconds
    { 1696, 472, -120},
    { 1728, 184, -120},
    { 1736, 304, -184},
    { 1640, 224, -96},
    { 1272, 112, -120},
    { 1048, -96, 112},
    { 528, -608, 208},
    { 744, -48, -80},
    { 976, 88, -400},
    { 1224, 32, -32},
    { 1480, 288, -208},
    { 1328, 264, -288},
    { 1448, 208, -176},
    { 1744, 520, -128},
    { 2008, 832, -224},
    { 1840, 968, -168},
    { 1416, 904, -312},
    { 736, 992, -264},
    { 600, 1088, -168},
    { 1088, 1264, 56},
    { 1112, 728, 32},
    { 1136, 808, 0},
    { 1336, 800, 16},
    { 1456, 704, -16},
    { 1472, 456, -80},
    // 69 seconds
    { 1608, 376, -120},
    { 1672, 224, -144},
    { 1568, 144, -88},
    { 1576, 264, -192},
    { 1456, 288, -184},
    { 1024, -512, 32},
    { 776, -520, -16},
    { 648, -384, -248},
    { 1192, 64, -272},
    { 1528, 328, -328},
    { 1352, 304, -288},
    { 1368, 152, -280},
    { 1520, 392, -168},
    { 1744, 768, -96},
    { 1632, 920, -176},
    { 1400, 896, -104},
    { 1112, 952, -104},
    { 624, 1120, -24},
    { 752, 944, -48},
    { 952, 1008, -32},
    { 1104, 824, -24},
    { 1408, 816, 8},
    { 1704, 712, -32},
    { 1464, 456, -24},
    { 1384, 416, -96},
    // 70 seconds
    { 1496, 352, -104},
    { 1728, 408, -88},
    { 1656, 168, -24},
    { 1408, 176, -48},
    { 1272, 96, -72},
    { 768, -816, 48},
    { 792, -224, 24},
    { 888, -224, -304},
    { 1224, -16, -128},
    { 1512, 336, -200},
    { 1368, 432, -232},
    { 1512, 232, -200},
    { 1720, 568, -136},
    { 1776, 976, -168},
    { 1624, 848, -192},
    { 1304, 1056, -256},
    { 656, 1376, -240},
    { 688, 1000, -200},
    { 1008, 1184, -144},
    { 1056, 728, -48},
    { 1200, 864, -64},
    { 1632, 776, -144},
    { 1632, 536, -24},
    { 1456, 376, -88},
    { 1488, 352, -104},
    // 71 seconds
    { 1592, 368, -96},
    { 1616, 256, 0},
    { 1352, 192, -48},
    { 1176, 184, -120},
    { 784, -528, -72},
    { 1080, -256, 24},
    { 680, -456, -256},
    { 1048, 120, -320},
    { 1360, 72, -152},
    { 1336, 368, -304},
    { 1352, 176, -240},
    { 1496, 424, -200},
    { 1632, 624, -376},
    { 1600, 968, -184},
    { 1352, 768, -464},
    { 1104, 1016, -464},
    { 816, 1032, -376},
    { 952, 928, -392},
    { 848, 856, -184},
    { 1072, 832, -208},
    { 1240, 728, -176},
    { 1536, 632, -160},
    { 1296, 408, -112},
    { 1280, 392, -104},
    { 1400, 296, -88},
    // 72 seconds
    { 1520, 288, -136},
    { 1600, 208, -48},
    { 1288, 200, -80},
    { 1048, -152, -56},
    { 1040, -272, -48},
    { 736, -552, -32},
    { 1112, 0, -272},
    { 1216, -120, -168},
    { 1176, 304, -256},
    { 1080, 112, -240},
    { 1296, 296, -168},
    { 1672, 504, -176},
    { 1832, 1008, -216},
    { 1440, 1168, -128},
    { 1032, 1088, -368},
    { 656, 1240, -168},
    { 1096, 1304, -32},
    { 952, 672, -32},
    { 1032, 840, -72},
    { 1320, 776, -32},
    { 1344, 544, -32},
    { 1176, 376, -80},
    { 1304, 400, -104},
    { 1520, 280, -144},
    { 1632, 232, -136},
    // 73 seconds
    { 1400, 200, -184},
    { 1368, 112, -208},
    { 768, -632, -208},
    { 904, -424, -216},
    { 928, -504, -192},
    { 1304, -56, -248},
    { 1432, 88, -152},
    { 1344, 272, -216},
    { 1216, 216, -248},
    { 1472, 408, -112},
    { 1824, 672, -168},
    { 1728, 1072, -72},
    { 1288, 1112, -152},
    { 792, 1208, -224},
    { 664, 1200, -160},
    { 1016, 1248, -120},
    { 920, 680, -96},
    { 1248, 872, -104},
    { 1664, 776, -64},
    { 1744, 544, -64},
    { 1472, 384, -64},
    { 1416, 296, -120},
    { 1504, 280, -136},
    { 1672, 200, -56},
    { 1376, 152, -88},
    // 74 seconds
    { 1264, 208, -152},
    { 920, -496, 48},
    { 1024, -760, -64},
    { 784, -416, -224},
    { 1136, -16, -200},
    { 1488, 152, -184},
    { 1344, 344, -248},
    { 1240, 192, -232},
    { 1400, 360, -200},
    { 1784, 528, -152},
    { 2024, 920, -184},
    { 1704, 1064, -200},
    { 1184, 1200, -368},
    { 648, 1232, -352},
    { 1008, 1192, -272},
    { 704, 712, -200},
    { 1184, 800, -192},
    { 1472, 832, -144},
    { 1504, 560, -96},
    { 1360, 432, -120},
    { 1400, 312, -168},
    { 1608, 312, -144},
    { 1872, 192, -24},
    { 1488, 208, -104},
    { 1424, 96, -160},
    // 75 seconds
    { 736, -680, 112},
    { 1008, -432, -152},
    { 976, -328, -176},
    { 1240, -32, -200},
    { 1504, 152, -248},
    { 1256, 272, -280},
    { 1232, 224, -304},
    { 1416, 384, -136},
    { 1800, 672, -176},
    { 1760, 1088, -144},
    { 1424, 1296, -216},
    { 560, 1880, -416},
    { 728, 1200, -200},
    { 1072, 1184, -104},
    { 1040, 800, -48},
    { 1424, 848, 24},
    { 1776, 720, 8},
    { 1728, 456, -24},
    { 1456, 344, -56},
    { 1408, 328, -160},
    { 1568, 344, -120},
    { 1536, 288, -144},
    { 1344, 208, -216},
    { 1096, -152, -64},
    { 384, -624, -8},
    // 76 seconds
    { 944, -240, -312},
    { 800, -344, -208},
    { 1280, 168, -336},
    { 1640, 208, -344},
    { 1528, 296, -336},
    { 1464, 232, -272},
    { 1480, 488, -176},
    { 1624, 712, -144},
    { 1720, 800, -64},
    { 1472, 1040, -56},
    { 1024, 1160, -40},
    { 736, 1120, -96},
    { 896, 1104, -16},
    { 904, 880, 32},
    { 1072, 848, 0},
    { 1352, 800, 16},
    { 1656, 664, -80},
    { 1448, 432, -88},
    { 1408, 440, -160},
    { 1496, 200, -112},
    { 1544, 280, -152},
    { 1608, 216, -128},
    { 1424, 232, -128},
    { 1200, -64, 16},
    { 888, -464, 64},
    // 77 seconds
    { 696, -536, 64},
    { 992, 80, -384},
    { 1216, -48, -96},
    { 1456, 400, -256},
    { 1336, 264, -264},
    { 1440, 336, -184},
    { 1736, 608, -144},
    { 1776, 1000, -144},
    { 1576, 872, -128},
    { 1240, 992, -216},
    { 736, 1216, -216},
    { 664, 888, -224},
    { 968, 1184, -240},
    { 1064, 816, -152},
    { 1376, 880, -112},
    { 1768, 720, -120},
    { 1576, 432, -80},
    { 1360, 392, -80},
    { 1432, 344, -128},
    { 1440, 320, -48},
    { 1320, 264, -48},
    { 1344, 184, 0},
    { 1112, 136, 24},
    { 784, -120, -80},
    { 880, -328, 152},
    // 78 seconds
    { 808, -232, -320},
    { 1120, 56, -400},
    { 1392, 160, -280},
    { 1176, 264, -304},
    { 1128, 192, -240},
    { 1304, 360, -176},
    { 1768, 512, -160},
    { 1824, 848, -144},
    { 1616, 1024, -168},
    { 1224, 1040, -248},
    { 864, 984, -144},
    { 984, 1160, -80},
    { 808, 808, -8},
    { 960, 904, -88},
    { 1200, 832, -56},
    { 1432, 640, -72},
    { 1240, 464, -112},
    { 1288, 392, -104},
    { 1440, 312, -40},
    { 1488, 256, -104},
    { 1656, 224, -56},
    { 1400, 192, -16},
    { 1104, 144, -136},
    { 944, -576, -136},
    { 784, -480, 24},
    // 79 seconds
    { 1096, 0, -376},
    { 1176, -80, -160},
    { 1272, 328, -256},
    { 976, 264, -168},
    { 1192, 184, -184},
    { 1560, 448, -88},
    { 1912, 768, -200},
    { 1648, 1128, -192},
    { 1224, 720, -392},
    { 880, 944, -408},
    { 920, 1184, -208},
    { 888, 896, -136},
    { 848, 688, -280},
    { 1136, 728, -200},
    { 1392, 768, -120},
    { 1336, 464, -112},
    { 1336, 352, -144},
    { 1448, 280, -136},
    { 1608, 272, -64},
    { 1592, 232, -112},
    { 1584, 208, -144},
    { 1288, -104, 48},
    { 728, -576, 48},
    { 872, -232, -64},
    { 912, -152, -248},
    // 80 seconds
    { 1184, 32, -128},
    { 1312, 280, -208},
    { 1080, 264, -224},
    { 1112, 144, -208},
    { 1344, 384, -128},
    { 1696, 648, -192},
    { 1664, 1056, -160},
    { 1240, 984, -328},
    { 904, 1080, -400},
    { 704, 1136, -240},
    { 976, 1024, -224},
    { 944, 744, -152},
    { 1200, 840, -152},
    { 1584, 768, -104},
    { 1496, 488, -40},
    { 1312, 344, -96},
    { 1312, 328, -112},
    { 1432, 408, -88},
    { 1552, 248, 8},
    { 1368, 152, -40},
    { 1248, 208, -72},
    { 904, -416, 128},
    { 944, -272, 40},
    { 592, -336, -216},
    { 1048, 128, -304},
    // 81 seconds
    { 1496, 56, -88},
    { 1368, 424, -248},
    { 1248, 160, -224},
    { 1408, 344, -184},
    { 1640, 584, -208},
    { 1680, 880, -280},
    { 1416, 880, -352},
    { 1040, 1024, -504},
    { 712, 1112, -464},
    { 896, 968, -392},
    { 936, 840, -224},
    { 1040, 752, -232},
    { 1296, 720, -160},
    { 1720, 688, -104},
    { 1440, 328, -40},
    { 1336, 288, -128},
    { 1536, 312, -32},
    { 1472, 256, -8},
    { 1328, 248, -24},
    { 1240, 256, -56},
    { 984, 112, -56},
    { 1000, -272, -24},
    { 672, -240, -8},
    { 864, 96, -400},
    { 976, -48, -136},
    // 82 seconds
    { 1200, 136, -200},
    { 1016, 160, -272},
    { 1040, 176, -272},
    { 1272, 328, -192},
    { 1568, 528, -288},
    { 1696, 864, -200},
    { 1424, 1008, -408},
    { 1200, 1024, -504},
    { 720, 1216, -312},
    { 992, 1240, -192},
    { 1024, 928, 24},
    { 1184, 1136, 40},
    { 1576, 1016, 32},
    { 1512, 792, 24},
    { 1456, 1272, -72},
    { 1808, 976, 48},
    { 1592, 824, -200},
    { 1408, 720, -304},
    { 1096, 240, -224},
    { 736, -8, -392},
    { 336, -128, -432},
    { 336, -200, -616},
    { -32, -320, -624},
    { 144, -560, -696},
    { 216, -352, -912},
    // 83 seconds
    { 176, -448, -792},
    { 24, -496, -688},
    { -128, -424, -736},
    { -200, -480, -768},
    { -256, -400, -904},
    { -304, -440, -1040},
    { -272, -344, -1200},
    { -120, -440, -1312},
    { -280, -384, -1280},
    { -256, -304, -1320},
    { -264, -176, -1168},
    { -232, 8, -1184},
    { -96, -176, -1032},
    { -128, -144, -840},
    { -88, -296, -712},
    { -40, -352, -584},
    { 40, -360, -512},
    { 200, -344, -496},
    { 368, -240, -480},
    { 592, -48, -368},
    { 984, 32, -208},
    { 1552, 720, -488},
    { 1752, 536, -456},
    { 1808, 728, -664},
    { 1608, 712, -608},
    // 84 seconds
    { 1448, 408, -336},
    { 1312, 472, -288},
    { 1344, 592, -296},
    { 1344, 832, -248},
    { 1104, 880, -264},
    { 808, 1008, -384},
    { 696, 1160, -296},
    { 896, 928, -272},
    { 1088, 888, -248},
    { 1144, 680, -176},
    { 1320, 800, -192},
    { 1720, 704, -200},
    { 1664, 376, -104},
    { 1528, 336, -104},
    { 1400, 176, -144},
    { 1288, 440, -224},
    { 1416, 200, -104},
    { 1376, 192, -40},
    { 1024, 128, -40},
    { 920, -432, -24},
    { 840, -232, 264},
    { 920, 88, -336},
    { 960, 120, -216},
    { 1320, 192, -152},
    { 1224, 408, -416},
    // 85 seconds
    { 1232, 144, -272},
    { 1496, 400, -352},
    { 1824, 1016, -88},
    { 1624, 920, -432},
    { 1352, 928, -208},
    { 896, 936, -192},
    { 648, 928, -184},
    { 912, 1128, -168},
    { 864, 800, -72},
    { 1152, 840, -112},
    { 1360, 736, -80},
    { 1392, 488, -88},
    { 1216, 400, -120},
    { 1288, 344, -192},
    { 1536, 328, -176},
    { 1760, 248, -136},
    { 1464, 144, -120},
    { 1224, 192, -168},
    { 808, -456, -72},
    { 984, -176, -8},
    { 824, -240, -240},
    { 1016, 128, -328},
    { 1256, 184, -192},
    { 1168, 336, -224},
    { 1152, 176, -240},
    // 86 seconds
    { 1392, 352, -80},
    { 1736, 696, -216},
    { 1656, 1000, -232},
    { 1304, 944, -360},
    { 872, 1104, -392},
    { 664, 1112, -336},
    { 1032, 1128, -304},
    { 848, 752, -160},
    { 1192, 832, -208},
    { 1648, 736, -248},
    { 1616, 552, -88},
    { 1400, 328, -120},
    { 1304, 296, -128},
    { 1376, 320, -144},
    { 1488, 248, -80},
    { 1392, 200, -80},
    { 1176, 176, -104},
    { 800, -432, 0},
    { 1112, -200, -32},
    { 736, -328, -176},
    { 1080, 224, -344},
    { 1376, 120, -192},
    { 1304, 376, -360},
    { 1224, 104, -224},
    { 1360, 352, -168},
    // 87 seconds
    { 1664, 640, -240},
    { 1720, 944, -280},
    { 1440, 776, -384},
    { 1184, 944, -448},
    { 760, 1048, -432},
    { 912, 1128, -440},
    { 864, 800, -272},
    { 1064, 896, -232},
    { 1272, 728, -176},
    { 1424, 608, -152},
    { 1240, 392, -128},
    { 1312, 368, -152},
    { 1448, 304, -136},
    { 1672, 280, -112},
    { 1624, 184, -96},
    { 1368, 224, -96},
    { 1112, -224, -80},
    { 1008, -392, -32},
    { 768, -632, -40},
    { 1048, 24, -368},
    { 1264, -24, -136},
    { 1248, 432, -248},
    { 1152, 168, -216},
    { 1392, 352, -176},
    { 1704, 584, -216},
    // 88 seconds
    { 1696, 1032, -216},
    { 1392, 944, -272},
    { 1072, 1208, -344},
    { 632, 1160, -168},
    { 896, 1160, -88},
    { 1128, 880, 8},
    { 1304, 872, -64},
    { 1424, 768, -32},
    { 1488, 576, -16},
    { 1288, 328, -64},
    { 1344, 328, -56},
    { 1432, 328, -112},
    { 1640, 280, -96},
    { 1408, 144, -32},
    { 1120, -64, -64},
    { 656, -240, -32},
    { 1016, -136, -136},
    { 752, -248, 64},
    { 1152, 184, -304},
    { 1216, 104, -136},
    { 1112, 216, -224},
    { 1000, 136, -200},
    { 1040, 312, -224},
    { 1312, 400, -248},
    { 1648, 584, -288},
    // 89 seconds
    { 1664, 872, -432},
    { 1384, 1136, -504},
    { 984, 840, -584},
    { 944, 1112, -560},
    { 808, 792, -152},
    { 1072, 752, -304},
    { 1112, 616, -264},
    { 1320, 632, -200},
    { 1168, 384, -136},
    { 1168, 336, -152},
    { 1296, 304, -128},
    { 1552, 296, -72},
    { 1616, 192, 0},
    { 1408, 232, -16},
    { 1152, -128, 8},
    { 1072, -368, 80},
    { 696, -464, -112},
    { 1008, 32, -368},
    { 1216, -80, -128},
    { 1264, 208, -16},
    { 960, 184, -264},
    { 1080, 168, -280},
    { 1400, 376, -152},
    { 1752, 736, -256},
    { 1544, 1096, -240},
    // 90 seconds
    { 1128, 928, -504},
    { 824, 992, -488},
    { 784, 1008, -312},
    { 1016, 1016, -216},
    { 1000, 656, -232},
    { 1200, 688, -224},
    { 1600, 712, -136},
    { 1432, 384, -88},
    { 1368, 336, -96},
    { 1392, 280, -112},
    { 1448, 264, -112},
    { 1448, 184, -40},
    { 1272, 208, -56},
    { 1144, -88, 80},
    { 776, -528, 136},
    { 928, -280, 64},
    { 992, -88, -112},
    { 1152, 160, -192},
    { 1304, 336, -248},
    { 1192, 328, -240},
    { 1240, 152, -192},
    { 1488, 400, -176},
    { 1704, 664, -256},
    { 1576, 808, -256},
    { 1288, 1008, -456},
    // 91 seconds
    { 872, 1104, -504},
    { 776, 952, -384},
    { 1056, 984, -272},
    { 904, 760, -176},
    { 1192, 824, -128},
    { 1520, 768, -80},
    { 1424, 464, -72},
    { 1328, 384, -112},
    { 1352, 304, -96},
    { 1472, 312, -88},
    { 1488, 192, -80},
    { 1336, 160, -56},
    { 1032, 160, -104},
    { 880, -344, -24},
    { 1000, -200, 128},
    { 856, -176, -304},
    { 1064, 96, -304},
    { 1216, 240, -200},
    { 1072, 208, -240},
    { 1088, 184, -208},
    { 1328, 360, -160},
    { 1704, 584, -240},
    { 1752, 944, -312},
    { 1352, 904, -424},
    { 1104, 992, -576},
    // 92 seconds
    { 704, 1000, -336},
    { 1056, 1112, -328},
    { 824, 728, -200},
    { 1048, 784, -176},
    { 1304, 760, -112},
    { 1448, 536, -56},
    { 1336, 376, -80},
    { 1280, 304, -136},
    { 1448, 320, -104},
    { 1600, 240, -56},
    { 1408, 168, -64},
    { 1176, 232, -144},
    { 984, -352, 40},
    { 1056, -264, 56},
    { 704, -392, -200},
    { 1000, 104, -352},
    { 1304, -88, -96},
    { 1272, 344, -136},
    { 1016, 160, -328},
    { 1200, 280, -232},
    { 1584, 424, -168},
    { 1808, 752, -312},
    { 1576, 960, -288},
    { 1144, 872, -544},
    { 800, 952, -472},
    // 93 seconds
    { 1064, 1056, -368},
    { 816, 616, -200},
    { 1136, 760, -272},
    { 1288, 672, -168},
    { 1296, 608, -136},
    { 1232, 400, -144},
    { 1224, 232, -80},
    { 1392, 272, -88},
    { 1552, 104, -56},
    { 1600, 216, -128},
    { 1328, 200, -168},
    { 1232, 176, -96},
    { 1008, -480, 88},
    { 472, -392, -248},
    { 880, -32, -376},
    { 1416, -240, 16},
    { 1344, 200, -192},
    { 1056, 256, -336},
    { 1080, 360, -320},
    { 1352, 352, -248},
    { 1656, 560, -328},
    { 1664, 840, -216},
    { 1272, 936, -488},
    { 912, 1080, -376},
    { 768, 1360, -296},
    // 94 seconds
    { 808, 808, -160},
    { 984, 880, -176},
    { 1240, 712, -56},
    { 1352, 624, -72},
    { 1224, 400, -56},
    { 1192, 368, -64},
    { 1360, 344, -144},
    { 1728, 280, -152},
    { 1616, 168, -136},
    { 1632, 128, -200},
    { 928, -712, -48},
    { 968, -352, -72},
    { 648, -320, -232},
    { 1080, -8, -224},
    { 1376, 192, -216},
    { 1152, 200, -304},
    { 1072, 112, -296},
    { 1208, 296, -168},
    { 1464, 528, -208},
    { 1608, 840, -264},
    { 1304, 984, -280},
    { 1040, 1128, -384},
    { 640, 1240, -272},
    { 848, 1120, -184},
    { 1040, 840, -120},
    // 95 seconds
    { 1152, 800, -104},
    { 1520, 752, -24},
    { 1544, 576, 40},
    { 1264, 344, -72},
    { 1184, 328, -96},
    { 1280, 352, -120},
    { 1456, 288, -88},
    { 1496, 184, -120},
    { 1304, 160, -144},
    { 904, -376, 24},
    { 688, -280, -224},
    { 672, -376, -40},
    { 1120, 64, -216},
    { 1240, 232, -288},
    { 1288, 392, -352},
    { 1176, 184, -248},
    { 1200, 280, -248},
    { 1344, 544, -192},
    { 1560, 824, -256},
    { 1392, 840, -264},
    { 1152, 1000, -392},
    { 720, 1240, -392},
    { 800, 1032, -416},
    { 1056, 1000, -280},
    { 1112, 784, -224},
    // 96 seconds
    { 1624, 688, -304},
    { 1608, 592, -136},
    { 1288, 328, -120},
    { 1128, 312, -136},
    { 1280, 232, -144},
    { 1512, 240, -184},
    { 1512, 184, -88},
    { 1248, 160, -184},
    { 1008, -288, 16},
    { 704, -312, -88},
    { 736, -312, -176},
    { 1048, 48, -304},
    { 1232, 88, -224},
    { 1248, 352, -360},
    { 1280, 136, -208},
    { 1408, 376, -176},
    { 1608, 704, -200},
    { 1704, 840, -256},
    { 1520, 888, -168},
    { 1144, 1080, -176},
    { 752, 1216, -208},
    { 760, 1224, -96},
    { 880, 896, -80},
    { 1096, 872, -96},
    { 1376, 744, -80},
    // 97 seconds
    { 1624, 568, -112},
    { 1448, 392, -144},
    { 1496, 344, -224},
    { 1560, 192, -136},
    { 1648, 256, -136},
    { 1472, 288, -216},
    { 1352, 240, -256},
    { 952, -360, -64},
    { 1080, -280, -80},
    { 688, -480, -248},
    { 944, 96, -376},
    { 1280, -32, -232},
    { 1272, 256, -344},
    { 1232, 208, -328},
    { 1328, 392, -272},
    { 1520, 536, -240},
    { 1592, 896, -304},
    { 1544, 744, -192},
    { 1200, 1168, -288},
    { 832, 1184, -216},
    { 936, 1128, -152},
    { 864, 720, -96},
    { 904, 824, -120},
    { 1192, 696, -112},
    { 1392, 536, -80},
    // 98 seconds
    { 1312, 352, -176},
    { 1376, 344, -152},
    { 1488, 136, -8},
    { 1424, 304, -96},
    { 1528, 320, -136},
    { 1384, 152, -32},
    { 872, -472, -16},
    { 920, -288, -128},
    { 936, -344, -72},
    { 1024, 120, -312},
    { 1208, 96, -192},
    { 1112, 280, -296},
    { 1096, 168, -232},
    { 1208, 320, -176},
    { 1464, 520, -200},
    { 1592, 760, -264},
    { 1320, 1096, -112},
    { 1008, 896, -240},
    { 808, 1048, -88},
    { 944, 1176, -40},
    { 816, 728, -32},
    { 1008, 792, -32},
    { 1448, 680, -56},
    { 1392, 488, -88},
    { 1352, 408, -168},
    // 99 seconds
    { 1488, 280, -168},
    { 1472, 128, -56},
    { 1368, 208, -192},
    { 1464, 200, -192},
    { 960, -368, -8},
    { 1144, -272, -176},
    { 928, -456, -16},
    { 1024, 120, -424},
    { 1320, 24, -160},
    { 1176, 232, -288},
    { 1128, 152, -240},
    { 1184, 352, -208},
    { 1400, 544, -184},
    { 1408, 720, -304},
    { 1280, 1112, -240},
    { 1040, 1008, -304},
    { 672, 1216, -216},
    { 1072, 1264, -112},
    { 1016, 792, 8},
    { 1264, 824, -48},
    { 1576, 664, -56},
    { 1328, 432, -72},
    { 1280, 376, -184},
    { 1456, 312, -160},
    { 1480, 248, -112},
    // 100 seconds
    { 1528, 256, -232},
    { 1456, 168, -248},
    { 1080, -216, -136},
    { 824, -352, -224},
    { 808, -472, -80},
    { 1040, 40, -432},
    { 1304, -48, -208},
    { 1288, 328, -320},
    { 1248, 208, -272},
    { 1304, 376, -232},
    { 1448, 552, -208},
    { 1448, 832, -296},
    { 1352, 944, -120},
    { 1080, 1248, -240},
    { 824, 1264, -216},
    { 824, 1024, -136},
    { 1016, 800, -24},
    { 1048, 816, -128},
    { 1448, 680, -80},
    { 1632, 624, -88},
    { 1520, 504, -232},
    { 1312, 72, 0},
    { 1216, 272, -168},
    { 1344, 176, -192},
    { 1336, 208, -152},
    // 101 seconds
    { 1256, 160, -152},
    { 968, -176, 0},
    { 792, -408, -8},
    { 712, -224, -136},
    { 928, 160, -416},
    { 1176, 64, -240},
    { 1272, 320, -392},
    { 1120, 128, -280},
    { 1152, 216, -176},
    { 1352, 464, -200},
    { 1504, 624, -256},
    { 1496, 776, -304},
    { 1288, 952, -272},
    { 928, 1040, -344},
    { 960, 1320, -240},
    { 856, 720, -168},
    { 1040, 920, -160},
    { 1288, 760, -160},
    { 1384, 584, -168},
    { 1216, 392, -160},
    { 1264, 312, -192},
    { 1392, 240, -152},
    { 1552, 232, -192},
    { 1464, 192, -144},
    { 1400, 160, -208},
    // 102 seconds
    { 856, -544, -16},
    { 1096, -264, -216},
    { 840, -448, -24},
    { 1032, 136, -312},
    { 1272, 160, -216},
    { 1184, 328, -272},
    { 1160, 152, -176},
    { 1280, 328, -160},
    { 1472, 608, -216},
    { 1480, 816, -240},
    { 1296, 888, -280},
    { 1056, 1096, -448},
    { 664, 1088, -408},
    { 920, 1064, -360},
    { 928, 800, -232},
    { 1240, 880, -232},
    { 1568, 752, -144},
    { 1632, 672, -128},
    { 1432, 352, -24},
    { 1352, 168, -168},
    { 1464, 264, -32},
    { 1432, 208, -120},
    { 1416, 168, -104},
    { 1144, 160, -40},
    { 976, 64, 16},
    // 103 seconds
    { 752, -336, 0},
    { 696, -168, -48},
    { 920, -72, -240},
    { 1144, 16, -96},
    { 1224, 320, -240},
    { 1080, 216, -248},
    { 1280, 272, -152},
    { 1712, 544, -184},
    { 1880, 912, -320},
    { 1568, 992, -256},
    { 1152, 920, -600},
    { 744, 952, -656},
    { 752, 808, -648},
    { 1064, 888, -544},
    { 944, 664, -376},
    { 1112, 840, -360},
    { 1464, 752, -224},
    { 1568, 496, -88},
    { 1472, 304, -72},
    { 1584, 432, -72},
    { 1608, 680, -88},
    { 1400, 768, -192},
    { 1368, 760, -320},
    { 1200, 888, -392},
    { 680, 568, -400},
    // 104 seconds
    { 800, 104, -168},
    { 200, -224, -304},
    { 440, 48, -472},
    { 472, -240, -488},
    { 360, -304, -408},
    { 160, -296, -520},
    { -128, -440, -760},
    { -128, -384, -928},
    { -104, -392, -976},
    { -232, -320, -1272},
    { -280, -264, -1432},
    { -160, -184, -1544},
    { -192, 0, -1688},
    { 48, -40, -1520},
    { -136, 16, -1240},
    { -168, 168, -1176},
    { -40, 48, -1016},
    { 48, 0, -872},
    { 128, -112, -768},
    { 168, -216, -696},
    { 208, -280, -608},
    { 248, -312, -512},
    { 336, -248, -528},
    { 496, -184, -520},
    { 632, -152, -328},
    // 105 seconds
    { 1216, 256, -416},
    { 1504, 408, -328},
    { 2064, 536, -312},
    { 1912, 672, -320},
    { 1424, 544, -392},
    { 1224, 528, -344},
    { 1336, 608, -168},
    { 1376, 616, -224},
    { 1176, 768, -232},
    { 888, 1136, -328},
    { 600, 1272, -336},
    { 704, 776, -224},
    { 1136, 1048, -280},
    { 1176, 768, -216},
    { 1304, 744, -208},
    { 1760, 704, -216},
    { 1560, 352, -120},
    { 1416, 352, -216},
    { 1464, 152, -176},
    { 1360, 320, -160},
    { 1520, 208, -160},
    { 1216, 176, -176},
    { 1088, -24, -104},
    { 712, -576, -48},
    { 992, -72, -40},
    // 106 seconds
    { 920, -24, -360},
    { 1064, 96, -200},
    { 1336, 264, -224},
    { 1184, 288, -272},
    { 1288, 128, -208},
    { 1528, 448, -128},
    { 1648, 832, -272},
    { 1528, 848, -192},
    { 1304, 768, -360},
    { 944, 1096, -272},
    { 624, 1152, -240},
    { 1064, 1144, -248},
    { 864, 696, -136},
    { 1104, 864, -112},
    { 1504, 720, -136},
    { 1416, 416, -104},
    { 1312, 368, -168},
    { 1376, 368, -136},
    { 1448, 296, -208},
    { 1568, 232, -112},
    { 1456, 128, -120},
    { 1184, 104, -184},
    { 768, -544, -72},
    { 1032, -224, -96},
    { 720, -376, -288},
    // 107 seconds
    { 1048, 152, -432},
    { 1400, 128, -264},
    { 1288, 216, -240},
    { 1288, 72, -200},
    { 1504, 384, -104},
    { 1640, 784, -200},
    { 1504, 928, -184},
    { 1352, 808, -232},
    { 1136, 1080, -216},
    { 640, 1112, -208},
    { 832, 1208, -120},
    { 1016, 880, -72},
    { 1136, 832, -120},
    { 1408, 800, -144},
    { 1608, 592, -112},
    { 1384, 400, -120},
    { 1480, 376, -128},
    { 1600, 272, -176},
    { 1664, 264, -40},
    { 1448, 160, -24},
    { 1200, 184, 8},
    { 1088, 96, 32},
    { 1072, -344, 136},
    { 672, -208, 0},
    { 832, -56, -288},
    // 108 seconds
    { 1152, -72, -80},
    { 1336, 192, -200},
    { 1208, 240, -336},
    { 1376, 312, -320},
    { 1600, 400, -408},
    { 1744, 1080, -168},
    { 1576, 520, -328},
    { 1280, 944, -368},
    { 856, 992, -256},
    { 864, 944, -328},
    { 912, 992, -176},
    { 944, 776, -232},
    { 1152, 768, -160},
    { 1528, 736, -136},
    { 1312, 376, -80},
    { 1328, 360, -160},
    { 1472, 280, -136},
    { 1584, 344, -80},
    { 1584, 152, -48},
    { 1288, 192, -72},
    { 1168, 152, -128},
    { 784, -544, -88},
    { 952, -184, 48},
    { 752, -248, -248},
    { 1104, 128, -304},
    // 109 seconds
    { 1392, 96, -136},
    { 1200, 328, -264},
    { 1240, 160, -256},
    { 1504, 384, -104},
    { 1880, 664, -192},
    { 1688, 1112, -152},
    { 1312, 872, -336},
    { 968, 1144, -248},
    { 584, 1176, -144},
    { 936, 1136, -80},
    { 888, 768, -32},
    { 1168, 816, -40},
    { 1536, 784, -32},
    { 1536, 512, -40},
    { 1360, 352, -104},
    { 1368, 344, -120},
    { 1512, 304, -160},
    { 1624, 248, -104},
    { 1448, 200, -144},
    { 1312, 128, -168},
    { 808, -528, -64},
    { 888, -296, -96},
    { 576, -344, -192},
    { 1000, 112, -232},
    { 1280, 88, -152},
    // 110 seconds
    { 1256, 368, -264},
    { 1216, 192, -176},
    { 1400, 384, -152},
    { 1696, 688, -192},
    { 1680, 880, -200},
    { 1384, 776, -296},
    { 1088, 976, -392},
    { 576, 1248, -400},
    { 752, 1096, -376},
    { 1016, 920, -224},
    { 1176, 880, -216},
    { 1408, 792, -112},
    { 1760, 688, -120},
    { 1512, 360, -88},
    { 1376, 344, -136},
    { 1440, 312, -104},
    { 1360, 264, -40},
    { 1448, 240, -72},
    { 1272, 152, 40},
    { 968, 200, -72},
    { 728, -256, -96},
    { 824, -112, 72},
    { 680, -280, -208},
    { 976, 160, -312},
    { 1208, 144, -216},
    // 111 seconds
    { 1280, 296, -344},
    { 1376, 200, -216},
    { 1560, 448, -232},
    { 1632, 592, -320},
    { 1432, 872, -224},
    { 1208, 784, -424},
    { 896, 1032, -352},
    { 640, 1216, -440},
    { 968, 1128, -384},
    { 1184, 1088, -272},
    { 1568, 816, -128},
    { 1760, 744, -288},
    { 1584, 600, -96},
    { 1840, 664, 40},
    { 2104, 712, 88},
    { 2064, 792, 176},
    { 2008, 856, 104},
    { 1888, 992, 144},
    { 1592, 1088, 128},
    { 1304, 760, 40},
    { 872, 592, 192},
    { 376, 232, -104},
    { 192, -96, -400},
    { 40, -200, -400},
    { -16, -648, -424},
    // 112 seconds
    { -56, -816, -584},
    { -232, -1008, -720},
    { -256, -952, -824},
    { -104, -744, -920},
    { 88, -664, -888},
    { 176, -592, -928},
    { 224, -520, -944},
    { 200, -632, -896},
    { 184, -608, -896},
    { 120, -584, -856},
    { 88, -568, -904},
    { 120, -568, -912},
    { 88, -592, -880},
    { 32, -632, -888},
    { 16, -592, -896},
    { 48, -616, -864},
    { 72, -616, -832},
    { 48, -592, -824},
    { -8, -592, -824},
    { -16, -560, -856},
    { 24, -568, -896},
    { 56, -584, -912},
    { 48, -592, -896},
    { -16, -584, -880},
    { -40, -568, -888},
    // 113 seconds
    { -32, -568, -888},
    { -16, -568, -888},
    { -8, -568, -904},
    { 8, -560, -920},
    { 32, -568, -896},
    { 32, -560, -896},
    { 32, -568, -880},
    { 0, -568, -864},
    { -32, -568, -856},
    { -56, -536, -872},
    { -64, -528, -888},
    { -24, -512, -912},
    { 16, -536, -928},
    { 40, -536, -928},
    { 72, -584, -912},
    { 104, -616, -904},
    { 128, -624, -888},
    { 144, -600, -856},
    { 112, -592, -840},
    { 88, -568, -744},
    { -32, -296, -840},
    { -184, 32, -912},
    { -320, -80, -904},
    { -336, 24, -896},
    { -440, 168, -904},
    // 114 seconds
    { -520, 248, -968},
    { -560, 192, -944},
    { -568, 368, -960},
    { -568, 312, -888},
    { -568, 296, -888},
    { -576, 272, -928},
    { -568, 296, -856},
    { -552, 248, -872},
    { -544, 280, -808},
    { -552, 240, -792},
    { -536, 232, -816},
    { -616, 408, -808},
    { -640, 408, -840},
    { -616, 312, -816},
    { -576, 264, -808},
    { -576, 216, -800},
    { -576, 232, -800},
    { -576, 248, -824},
    { -560, 240, -816},
    { -568, 272, -816},
    { -560, 224, -800},
    { -520, 168, -808},
    { -440, 112, -760},
    { -400, 304, -624},
    { -496, 512, -464},
    // 115 seconds
    { -520, 712, -248},
    { -528, 920, -16},
    { -536, 880, 64},
    { -544, 1032, 128},
    { -512, 816, 88},
    { -488, 856, 80},
    { -464, 952, 16},
    { -416, 848, -56},
    { -416, 880, 80},
    { -464, 856, 112},
    { -424, 832, 48},
    { -504, 920, 272},
    { -400, 808, 120},
    { -440, 880, 152},
    { -392, 792, 192},
    { -368, 888, 144},
    { -360, 880, 128},
    { -344, 864, 144},
    { -392, 896, 192},
    { -432, 816, 232},
    { -464, 824, 280},
    { -472, 840, 304},
    { -424, 768, 256},
    { -376, 856, 200},
    { -328, 832, 72},
    // 116 seconds
    { -288, 840, 104},
    { -272, 920, 24},
    { -312, 864, 24},
    { -344, 904, 48},
    { -352, 936, 24},
    { -376, 904, 32},
    { -368, 928, 72},
    { -336, 936, 56},
    { -280, 848, -32},
    { -272, 880, -64},
    { -264, 904, -16},
    { -264, 872, 144},
    { -280, 888, 280},
    { -296, 792, 224},
    { -320, 840, 320},
    { -280, 872, 464},
    { -296, 880, 424},
    { -264, 736, 408},
    { -224, 776, 408},
    { -224, 824, 416},
    { -176, 912, 392},
    { -224, 904, 392},
    { -216, 808, 336},
    { -232, 816, 320},
    { -288, 872, 320},
    // 117 seconds
    { -280, 872, 304},
    { -280, 912, 312},
    { -224, 944, 352},
    { -176, 968, 344},
    { -160, 912, 344},
    { -176, 824, 360},
    { -192, 808, 376},
    { -136, 816, 344},
    { -136, 888, 336},
    { -120, 856, 304},
    { -64, 872, 224},
    { -80, 896, 288},
    { -80, 880, 360},
    { -96, 896, 344},
    { -152, 816, 352},
    { -152, 832, 320},
    { -176, 872, 320},
    { -176, 896, 320},
    { -184, 880, 296},
    { -168, 864, 296},
    { -120, 776, 328},
    { -144, 840, 264},
    { -144, 904, 256},
    { -152, 904, 296},
    { -152, 872, 288},
    // 118 seconds
    { -144, 864, 280},
    { -136, 856, 264},
    { -144, 880, 272},
    { -184, 928, 296},
    { -168, 896, 264},
    { -152, 864, 232},
    { -152, 848, 264},
    { -160, 864, 280},
    { -168, 888, 304},
    { -152, 896, 272},
    { -152, 864, 256},
    { -144, 888, 264},
    { -152, 888, 296},
    { -168, 856, 256},
    { -144, 880, 256},
    { -144, 904, 272},
    { -144, 888, 280},
    { -144, 880, 280},
    { -152, 864, 280},
    { -152, 888, 272},
    { -144, 888, 280},
    { -152, 880, 280},
    { -160, 872, 280},
    { -144, 800, 240},
    { -168, 880, 280},
    // 119 seconds
    { -152, 888, 304},
    { -152, 936, 288},
    { -160, 872, 240},
    { -192, 912, 248},
    { -168, 808, 320},
    { -144, 864, 288},
    { -168, 936, 264},
    { -184, 856, 256},
    { -176, 888, 248},
    { -136, 864, 240},
    { -160, 872, 280},
    { -184, 904, 288},
    { -192, 872, 248},
    { -176, 904, 248},
    { -168, 864, 240},
    { -168, 896, 296},
    { -176, 904, 272},
    { -184, 840, 248},
    { -144, 824, 224},
    { -160, 904, 264},
    { -192, 936, 272},
    { -200, 864, 264},
    { -192, 856, 240},
    { -184, 920, 264},
    { -152, 960, 264},
    // 120 seconds
    // elapsed: 2 minutes
    { -176, 864, 224},
    { -136, 760, 128},
    { -216, 896, 224},
    { -264, 1000, 216},
    { -368, 1232, 216},
    { -416, 1120, 56},
    { -400, 992, -64},
    { -320, 464, -24},
    { -192, 352, -568},
    { -88, 304, -952},
    { -64, 416, -976},
    { 72, 208, -1024},
    { 32, -16, -1048},
    { 32, 152, -1040},
    { 48, -32, -936},
    { 32, 184, -1048},
    { -88, 216, -1136},
    { 48, -16, -936},
    { -104, 24, -1040},
    { -88, 96, -1000},
    { -176, 16, -1040},
    { 64, 32, -984},
    { -8, 64, -1024},
    { -40, -8, -1008},
    { -32, 64, -1024},
    // 121 seconds
    { 16, 48, -1000},
    { -16, 24, -1040},
    { -48, 64, -1080},
    { -32, 64, -1040},
    { -56, 80, -1032},
    { -48, 40, -1016},
    { -32, 56, -1040},
    { -48, 64, -1016},
    { -40, 80, -1016},
    { -40, 72, -1024},
    { -48, 80, -1008},
    { -40, 56, -1040},
    { -48, 80, -912},
    { -40, -8, -1032},
    { 24, 80, -1024},
    { 16, 24, -1016},
    { -64, 96, -1016},
    { -32, 64, -1016},
    { -40, 80, -1016},
    { -40, 48, -1040},
    { -40, 56, -1024},
    { -32, 56, -1008},
    { -40, 64, -1000},
    { -48, 64, -1008},
    { -32, 72, -1024},
    // 122 seconds
    { -40, 64, -1024},
    { -48, 64, -1032},
    { -48, 64, -1024},
    { -48, 64, -1016},
    { -48, 80, -1016},
    { -120, 144, -1016},
    { -16, 120, -1032},
    { -32, 48, -1024},
    { -16, 40, -1024},
    { -16, 24, -1008},
    { -80, 120, -1040},
    { -56, 72, -1008},
    { -56, 112, -1032},
    { -56, 56, -1016},
    { -48, 72, -1024},
    { -48, 80, -1016},
    { -56, 80, -1016},
    { -48, 88, -1024},
    { -56, 72, -1024},
    { -48, 64, -1016},
    { -56, 80, -1016},
    { -48, 80, -1024},
    { -48, 80, -1024},
    { -48, 80, -1016},
    { -48, 88, -1016},
    // 123 seconds
    { -48, 88, -1008},
    { -56, 96, -1016},
    { -48, 96, -1016},
    { -40, 80, -1016},
    { -48, 96, -1016},
    { -48, 96, -1016},
    { -48, 104, -1024},
    { -80, 128, -1016},
    { -32, 96, -1040},
    { -40, 56, -1016},
    { -48, 64, -1008},
    { -40, 48, -992},
    { -24, 64, -1032},
    { -64, 104, -1016},
    { -64, 120, -1008},
    { -64, 96, -1024},
    { -64, 88, -1024},
    { -48, 88, -1008},
    { -48, 96, -1016},
    { -64, 96, -1016},
    { -88, 128, -1016},
    { -48, 136, -992},
    { -40, 64, -1024},
    { -32, 80, -1024},
    { -32, 32, -1032},
    // 124 seconds
    { -48, 112, -1032},
    { -48, 80, -1016},
    { -64, 128, -1024},
    { -48, 72, -1008},
    { -56, 104, -1008},
    { -56, 88, -1008},
    { -48, 104, -1016},
    { -40, 96, -1008},
    { -48, 136, -976},
    { -48, 32, -1016},
    { -24, 104, -1032},
    { -32, 80, -1032},
    { 0, 56, -1024},
    { -56, 112, -1024},
    { -48, 128, -1008},
    { -48, 104, -1024},
    { -56, 104, -1016},
    { -48, 104, -1016},
    { -56, 96, -1008},
    { -48, 96, -1016},
    { -48, 96, -1008},
    { -56, 104, -1008},
    { -48, 96, -1024},
    { -48, 96, -1008},
    { -56, 104, -1008},
    // 125 seconds
    { -56, 104, -1016},
    { -48, 104, -1024},
    { -56, 104, -1016},
    { -48, 96, -1016},
    { -48, 96, -1016},
    { -48, 96, -1016},
    { -48, 96, -1024},
    { -48, 104, -1016},
    { -48, 88, -1016},
    { -40, 72, -1032},
    { -48, -8, -1096},
    { 112, 0, -976},
    { 232, 64, -360},
    { -64, 1280, -248},
    { -160, 928, -200},
    { -240, 1040, 304},
    { -328, 1416, 288},
    { -224, 664, 16},
    { -240, 920, 96},
    { -264, 976, 144},
    { -192, 912, 88},
    { -192, 992, 136},
    { -160, 968, 168},
    { -160, 912, 184},
    { -176, 912, 216},
    // 126 seconds
    { -176, 880, 248},
    { -168, 920, 208},
    { -128, 776, 224},
    { -160, 840, 216},
    { -208, 896, 240},
    { -200, 896, 240},
    { -192, 864, 256},
    { -176, 864, 288},
    { -160, 944, 280},
    { -144, 856, 296},
    { -136, 856, 288},
    { -144, 896, 272},
    { -152, 904, 264},
    { -144, 872, 272},
    { -112, 808, 280},
    { -152, 880, 288},
    { -160, 896, 280},
    { -128, 896, 264},
    { -136, 880, 224},
    { -160, 904, 256},
    { -160, 840, 288},
    { -144, 848, 288},
    { -160, 944, 280},
    { -168, 864, 264},
    { -184, 936, 264},
    // 127 seconds
    { -152, 912, 240},
    { -88, 768, 304},
    { -144, 928, 312},
    { -192, 848, 296},
    { -200, 904, 280},
    { -152, 872, 216},
    { -112, 832, 280},
    { -168, 904, 272},
    { -192, 912, 312},
    { -184, 896, 296},
    { -136, 904, 240},
    { -96, 792, 304},
    { -160, 912, 304},
    { -200, 832, 280},
    { -208, 896, 280},
    { -152, 872, 216},
    { -128, 864, 224},
    { -192, 928, 296},
    { -208, 848, 328},
    { -160, 928, 272},
    { -72, 712, 112},
    { -192, 984, 272},
    { -184, 872, 256},
    { -208, 824, 296},
    { -136, 816, 248},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-22 10:39:51 local
AccelRawData *activity_sample_walk_200_pbl_28359_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_28359_5
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 180
  //> TEST_EXPECTED_MAX 220
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 120, -32, -1032},
    { 136, -32, -1024},
    { 128, -40, -1024},
    { 120, -40, -1016},
    { 144, -16, -992},
    { 144, -32, -1016},
    { 160, -24, -1000},
    { 152, -32, -1008},
    { 128, -16, -1016},
    { 168, -32, -1016},
    { 160, -40, -1024},
    { 128, -40, -1024},
    { 152, -40, -1016},
    { 160, -40, -1016},
    { 152, -32, -1000},
    { 144, -40, -1000},
    { 152, -48, -992},
    { 168, -40, -1000},
    { 160, -48, -1000},
    { 168, -48, -1000},
    { 160, -48, -1008},
    { 152, -40, -1000},
    { 168, -56, -992},
    { 248, -8, -1000},
    { 176, -88, -960},
    // 1 seconds
    { 56, -128, -968},
    { 168, 8, -1016},
    { 160, -32, -1048},
    { 112, -24, -1024},
    { 176, -32, -1048},
    { 208, -240, -1120},
    { 488, -416, 2280},
    { 1272, -40, -664},
    { 320, 216, -784},
    { 320, 576, -584},
    { 96, 848, -376},
    { -72, 1040, 8},
    { -248, 1104, 264},
    { -240, 1088, 504},
    { -240, 1096, 472},
    { -152, 672, 312},
    { -96, 872, 280},
    { -56, 760, 256},
    { 24, 920, 144},
    { -56, 928, 344},
    { -96, 904, 328},
    { -120, 808, 344},
    { -176, 808, 392},
    { -120, 664, 304},
    { -16, 672, 168},
    // 2 seconds
    { 48, 632, 72},
    { 144, 536, 16},
    { 328, 376, 0},
    { 600, 480, 0},
    { 880, 504, 8},
    { 1264, 504, 32},
    { 1560, 576, 8},
    { 1608, 632, 128},
    { 1216, 672, 192},
    { 1064, 456, -32},
    { 984, 560, -16},
    { 960, 288, -32},
    { 984, 256, -88},
    { 984, 72, -120},
    { 904, 144, -304},
    { 824, 16, -264},
    { 864, -24, -264},
    { 856, 64, -280},
    { 912, 128, -280},
    { 912, 176, -304},
    { 872, 192, -304},
    { 848, 288, -352},
    { 792, 360, -432},
    { 728, 392, -488},
    { 688, 376, -544},
    // 3 seconds
    { 704, 376, -560},
    { 800, 344, -512},
    { 952, 288, -472},
    { 1032, 304, -368},
    { 1008, 320, -280},
    { 1016, 384, -136},
    { 1032, 424, -104},
    { 1112, 408, -72},
    { 1568, 504, -16},
    { 1608, 352, 56},
    { 1296, 408, 24},
    { 1120, 392, -24},
    { 992, 336, -40},
    { 920, 320, -48},
    { 832, 280, -112},
    { 696, 240, -184},
    { 504, 144, -296},
    { 336, 48, -288},
    { 720, 128, -312},
    { 952, 248, -272},
    { 1376, 408, -240},
    { 1448, 408, -32},
    { 1656, 504, -160},
    { 1680, 480, 8},
    { 1432, 600, -24},
    // 4 seconds
    { 1256, 456, -8},
    { 1136, 576, 112},
    { 1032, 520, 176},
    { 880, 472, 136},
    { 856, 552, 144},
    { 752, 776, 144},
    { 624, 776, 40},
    { 680, 728, 40},
    { 1008, 864, 32},
    { 1128, 632, 8},
    { 1344, 672, -24},
    { 1704, 608, -32},
    { 1768, 432, -16},
    { 1544, 408, -104},
    { 1608, 344, -56},
    { 1616, 312, -24},
    { 1448, 216, -40},
    { 1304, 8, -88},
    { 1016, -304, -88},
    { 936, -384, -200},
    { 984, -272, -32},
    { 1096, 160, -288},
    { 1328, 264, -184},
    { 1312, 376, -280},
    { 1184, 360, -176},
    // 5 seconds
    { 1184, 448, -120},
    { 1360, 528, -32},
    { 1504, 712, -16},
    { 1392, 872, 64},
    { 1072, 920, -8},
    { 808, 1120, 64},
    { 800, 1000, 88},
    { 960, 872, 96},
    { 992, 848, 0},
    { 1232, 720, 24},
    { 1528, 576, -16},
    { 1368, 384, -64},
    { 1384, 376, -104},
    { 1488, 304, -64},
    { 1568, 296, -48},
    { 1472, 248, -80},
    { 1336, -32, -64},
    { 904, -328, -104},
    { 1024, -344, -128},
    { 872, -280, -144},
    { 1016, 216, -328},
    { 1288, 240, -240},
    { 1208, 328, -272},
    { 1096, 312, -264},
    { 1152, 424, -152},
    // 6 seconds
    { 1376, 560, -160},
    { 1512, 760, -176},
    { 1368, 880, -160},
    { 1040, 1040, -272},
    { 736, 1000, -240},
    { 840, 1088, -176},
    { 816, 720, -72},
    { 1280, 928, -136},
    { 1392, 688, -80},
    { 1496, 528, -80},
    { 1248, 296, -120},
    { 1144, 304, -192},
    { 1368, 368, -168},
    { 1584, 216, -40},
    { 1400, 248, -64},
    { 1344, 184, -112},
    { 808, -512, -8},
    { 1112, -320, 48},
    { 1008, -304, -96},
    { 1104, 144, -288},
    { 1288, 200, -200},
    { 1144, 288, -256},
    { 1016, 280, -288},
    { 1264, 400, -168},
    { 1592, 624, -208},
    // 7 seconds
    { 1720, 912, -184},
    { 1376, 1056, -136},
    { 888, 1200, -216},
    { 584, 1056, -120},
    { 1056, 1056, -128},
    { 936, 888, -64},
    { 1216, 784, -40},
    { 1464, 696, -64},
    { 1376, 464, -72},
    { 1264, 408, -152},
    { 1392, 384, -184},
    { 1640, 360, -120},
    { 1640, 232, -120},
    { 1456, 264, -136},
    { 1136, -128, 40},
    { 584, -336, -104},
    { 832, -336, -32},
    { 976, -152, -160},
    { 1112, 120, -224},
    { 1272, 336, -312},
    { 1136, 296, -312},
    { 1128, 296, -272},
    { 1336, 464, -152},
    { 1632, 656, -248},
    { 1624, 848, -184},
    // 8 seconds
    { 1296, 1064, -304},
    { 928, 1168, -328},
    { 608, 1008, -280},
    { 880, 1112, -296},
    { 840, 808, -120},
    { 1232, 848, -136},
    { 1592, 720, -104},
    { 1480, 448, -72},
    { 1264, 352, -112},
    { 1280, 352, -160},
    { 1432, 328, -128},
    { 1504, 296, -104},
    { 1440, 128, -24},
    { 1152, -8, -56},
    { 880, -256, -136},
    { 952, -376, -24},
    { 888, -328, -192},
    { 1080, 56, -336},
    { 1320, 152, -304},
    { 1256, 352, -352},
    { 1208, 264, -312},
    { 1352, 408, -200},
    { 1592, 656, -312},
    { 1576, 832, -264},
    { 1384, 1104, -280},
    // 9 seconds
    { 984, 1256, -328},
    { 576, 1104, -264},
    { 832, 1200, -200},
    { 1000, 824, -80},
    { 1168, 744, -80},
    { 1416, 616, -72},
    { 1560, 488, -48},
    { 1456, 368, -120},
    { 1408, 320, -144},
    { 1536, 368, -160},
    { 1488, 288, -128},
    { 1464, 264, -160},
    { 1184, -248, -24},
    { 760, -416, -192},
    { 1024, -368, 32},
    { 1064, -80, -264},
    { 1240, 192, -296},
    { 1400, 296, -328},
    { 1264, 280, -288},
    { 1168, 320, -224},
    { 1376, 536, -184},
    { 1632, 808, -160},
    { 1576, 912, -80},
    { 1216, 1008, -120},
    { 824, 1128, -144},
    // 10 seconds
    { 640, 1000, -96},
    { 864, 960, 0},
    { 1104, 904, -56},
    { 1408, 792, 8},
    { 1672, 672, -16},
    { 1456, 448, -88},
    { 1352, 368, -152},
    { 1416, 232, -104},
    { 1544, 376, -136},
    { 1496, 248, -120},
    { 1440, 264, -136},
    { 1136, -128, 0},
    { 912, -312, -96},
    { 816, -624, 88},
    { 1088, 0, -256},
    { 1312, 56, -176},
    { 1360, 376, -256},
    { 1280, 328, -248},
    { 1376, 448, -224},
    { 1552, 624, -152},
    { 1504, 888, -192},
    { 1408, 744, -112},
    { 1144, 1112, -144},
    { 824, 1160, -48},
    { 752, 912, -40},
    // 11 seconds
    { 904, 1032, -8},
    { 976, 864, 24},
    { 1320, 816, 64},
    { 1640, 696, 0},
    { 1368, 384, -8},
    { 1280, 320, -80},
    { 1384, 336, -72},
    { 1512, 312, -24},
    { 1512, 264, -16},
    { 1392, 240, -8},
    { 1248, -32, -40},
    { 656, -456, -104},
    { 1048, -680, 104},
    { 1128, -32, -304},
    { 1352, 136, -152},
    { 1376, 344, -248},
    { 1296, 352, -120},
    { 1256, 480, -128},
    { 1392, 520, -56},
    { 1472, 704, -88},
    { 1392, 808, -72},
    { 1192, 1144, 0},
    { 784, 1320, 24},
    { 696, 992, -80},
    { 904, 976, -8},
    // 12 seconds
    { 1120, 840, 0},
    { 1296, 728, -8},
    { 1448, 600, -80},
    { 1304, 392, -72},
    { 1248, 352, -136},
    { 1296, 296, -144},
    { 1520, 320, -104},
    { 1576, 296, -56},
    { 1384, 280, -120},
    { 1120, -40, -216},
    { 712, -320, -160},
    { 856, -568, -88},
    { 1040, 48, -352},
    { 1240, 72, -224},
    { 1184, 392, -312},
    { 1040, 312, -216},
    { 1088, 408, -248},
    { 1368, 480, -112},
    { 1520, 776, -208},
    { 1400, 872, -176},
    { 1160, 912, -312},
    { 904, 984, -312},
    { 696, 936, -248},
    { 1104, 1096, -200},
    { 936, 728, -200},
    // 13 seconds
    { 1240, 792, -184},
    { 1528, 656, -120},
    { 1336, 384, -96},
    { 1280, 272, -208},
    { 1232, 184, -40},
    { 1280, 328, -136},
    { 1328, 264, -120},
    { 1360, 272, -96},
    { 1184, 176, -152},
    { 824, -224, -144},
    { 944, -40, -104},
    { 696, -264, -208},
    { 928, 152, -296},
    { 1096, 200, -336},
    { 1104, 248, -296},
    { 1152, 240, -256},
    { 1264, 424, -192},
    { 1408, 664, -296},
    { 1448, 856, -296},
    { 1296, 808, -304},
    { 1120, 1088, -416},
    { 840, 936, -320},
    { 1024, 1136, -288},
    { 880, 728, -192},
    { 1024, 848, -192},
    // 14 seconds
    { 1304, 656, -144},
    { 1424, 496, -112},
    { 1152, 352, -136},
    { 1184, 320, -176},
    { 1248, 312, -144},
    { 1416, 288, -104},
    { 1432, 200, -88},
    { 1192, 184, -176},
    { 696, -376, -96},
    { 960, -184, -184},
    { 824, -280, -144},
    { 1056, 136, -344},
    { 1376, 264, -296},
    { 1248, 232, -312},
    { 1064, 192, -344},
    { 1040, 328, -224},
    { 1280, 504, -240},
    { 1416, 696, -240},
    { 1336, 1008, -232},
    { 1008, 1072, -280},
    { 760, 1056, -232},
    { 680, 880, -128},
    { 928, 936, -64},
    { 1024, 760, -80},
    { 1336, 728, -72},
    // 15 seconds
    { 1608, 624, -40},
    { 1312, 376, -56},
    { 1200, 368, -168},
    { 1320, 368, -160},
    { 1416, 328, -144},
    { 1448, 224, -112},
    { 1288, 200, -104},
    { 1024, 72, -168},
    { 616, -336, -96},
    { 832, -224, -40},
    { 888, -8, -296},
    { 1144, 72, -168},
    { 1328, 296, -328},
    { 1184, 272, -264},
    { 1152, 296, -264},
    { 1280, 480, -288},
    { 1624, 704, -152},
    { 1408, 776, -176},
    { 1248, 912, -56},
    { 944, 1088, -80},
    { 912, 952, 32},
    { 1064, 920, -16},
    { 808, 696, 32},
    { 1064, 712, 8},
    { 1376, 696, -128},
    // 16 seconds
    { 1168, 448, -64},
    { 1216, 400, -144},
    { 1320, 296, -8},
    { 1304, 344, -24},
    { 1416, 264, -88},
    { 1512, 288, 32},
    { 1352, 296, -56},
    { 1016, -344, -56},
    { 792, -224, 48},
    { 584, -280, -400},
    { 960, 48, -280},
    { 1344, 288, -328},
    { 1120, 224, -352},
    { 976, 232, -336},
    { 1088, 360, -216},
    { 1336, 488, -224},
    { 1528, 648, -224},
    { 1392, 920, -192},
    { 1080, 1048, -232},
    { 872, 912, -184},
    { 928, 1016, -72},
    { 680, 720, -24},
    { 992, 808, -64},
    { 1280, 648, -16},
    { 1520, 504, -128},
    // 17 seconds
    { 1384, 312, -128},
    { 1336, 336, -200},
    { 1360, 320, -168},
    { 1352, 296, -184},
    { 1256, 200, -152},
    { 1080, 80, -96},
    { 784, -208, -88},
    { 1016, 40, -112},
    { 760, -72, -152},
    { 920, 256, -392},
    { 1200, 200, -352},
    { 1104, 200, -296},
    { 936, 256, -352},
    { 992, 360, -224},
    { 1360, 464, -320},
    { 1544, 616, -352},
    { 1392, 944, -384},
    { 928, 944, -480},
    { 680, 1088, -376},
    { 960, 984, -312},
    { 976, 704, -176},
    { 1136, 816, -184},
    { 1360, 632, -144},
    { 1520, 552, -136},
    { 1208, 304, -104},
    // 18 seconds
    { 1192, 280, -176},
    { 1264, 304, -192},
    { 1400, 288, -152},
    { 1408, 200, -136},
    { 1200, 216, -200},
    { 952, -272, -8},
    { 960, -344, -32},
    { 704, -224, -256},
    { 1056, 160, -296},
    { 1312, 192, -288},
    { 1200, 304, -336},
    { 1168, 232, -280},
    { 1280, 456, -232},
    { 1576, 584, -216},
    { 1656, 816, -208},
    { 1360, 960, 16},
    { 960, 1080, -80},
    { 728, 1016, 24},
    { 712, 976, 96},
    { 976, 968, 24},
    { 1008, 792, 56},
    { 1296, 744, 48},
    { 1664, 656, 24},
    { 1504, 480, -72},
    { 1408, 432, -128},
    // 19 seconds
    { 1440, 368, -152},
    { 1504, 352, -120},
    { 1448, 240, -104},
    { 1296, 248, -128},
    { 976, -56, -104},
    { 480, -288, -168},
    { 872, -344, -64},
    { 888, -88, -200},
    { 1040, 200, -320},
    { 1280, 360, -344},
    { 1400, 376, -264},
    { 1432, 352, -184},
    { 1520, 584, -200},
    { 1680, 784, -104},
    { 1504, 912, -96},
    { 1216, 1064, -96},
    { 704, 1400, -56},
    { 600, 1056, -88},
    { 792, 1248, -56},
    { 984, 768, 48},
    { 1168, 808, -8},
    { 1528, 752, -8},
    { 1832, 584, 8},
    { 1488, 368, -56},
    { 1320, 376, -120},
    // 20 seconds
    { 1392, 352, -128},
    { 1360, 296, -120},
    { 1456, 272, -120},
    { 1240, 208, -160},
    { 824, -344, -64},
    { 616, -264, -232},
    { 696, -408, -96},
    { 1080, 224, -344},
    { 1288, 232, -312},
    { 1304, 344, -472},
    { 1216, 200, -256},
    { 1216, 384, -240},
    { 1368, 536, -280},
    { 1704, 696, -56},
    { 1408, 896, -144},
    { 1200, 920, 0},
    { 952, 1112, 24},
    { 760, 912, 104},
    { 1048, 1008, 80},
    { 968, 840, 72},
    { 1088, 736, 88},
    { 1328, 680, 16},
    { 1312, 472, -24},
    { 1288, 440, -96},
    { 1368, 368, -128},
    // 21 seconds
    { 1440, 352, -88},
    { 1408, 208, -120},
    { 1320, 272, -128},
    { 1128, 232, -144},
    { 800, -200, -136},
    { 864, -216, -168},
    { 728, -352, -96},
    { 1024, 224, -352},
    { 1224, 248, -256},
    { 1184, 320, -312},
    { 1128, 304, -224},
    { 1152, 400, -160},
    { 1400, 512, -136},
    { 1584, 672, -128},
    { 1408, 864, -104},
    { 1152, 1024, -136},
    { 840, 1120, -160},
    { 736, 976, -64},
    { 1008, 944, -16},
    { 992, 824, -32},
    { 1168, 736, -16},
    { 1424, 656, -48},
    { 1312, 432, -64},
    { 1272, 384, -120},
    { 1328, 368, -128},
    // 22 seconds
    { 1528, 296, -120},
    { 1464, 224, -96},
    { 1280, 280, -152},
    { 1184, 72, -112},
    { 976, -232, -104},
    { 704, -480, -16},
    { 904, 72, -336},
    { 1248, 8, -136},
    { 1152, 312, -312},
    { 976, 224, -232},
    { 992, 352, -248},
    { 1280, 416, -136},
    { 1552, 584, -240},
    { 1632, 896, -168},
    { 1264, 904, -176},
    { 960, 1144, -248},
    { 656, 1000, -64},
    { 1120, 1072, -16},
    { 960, 768, -24},
    { 1144, 816, -16},
    { 1424, 752, 8},
    { 1344, 440, -24},
    { 1224, 384, -96},
    { 1288, 384, -120},
    { 1392, 312, -64},
    // 23 seconds
    { 1504, 264, -96},
    { 1392, 232, -72},
    { 1232, 240, -136},
    { 872, -208, -120},
    { 816, -224, -104},
    { 632, -480, -64},
    { 976, 192, -256},
    { 1208, 192, -224},
    { 1192, 352, -320},
    { 1120, 264, -224},
    { 1168, 400, -208},
    { 1440, 520, -176},
    { 1584, 728, -216},
    { 1376, 880, -168},
    { 1096, 1024, -272},
    { 776, 1072, -264},
    { 872, 1024, -160},
    { 1120, 880, -88},
    { 1144, 824, -80},
    { 1256, 736, -64},
    { 1408, 608, -64},
    { 1232, 376, -72},
    { 1168, 344, -80},
    { 1256, 336, -112},
    { 1472, 304, -88},
    // 24 seconds
    { 1432, 208, -40},
    { 1352, 264, -64},
    { 1152, 216, -56},
    { 752, -272, -72},
    { 816, -120, -112},
    { 584, -344, -88},
    { 984, 192, -232},
    { 1256, 264, -240},
    { 1240, 336, -288},
    { 1232, 344, -280},
    { 1328, 424, -224},
    { 1496, 584, -240},
    { 1480, 800, -216},
    { 1240, 976, -304},
    { 920, 1200, -320},
    { 672, 1120, -240},
    { 1000, 1096, -168},
    { 1120, 744, -48},
    { 1160, 792, -88},
    { 1304, 672, -32},
    { 1440, 552, -40},
    { 1320, 360, -40},
    { 1256, 352, -48},
    { 1312, 360, -64},
    { 1352, 272, -24},
    // 25 seconds
    { 1368, 240, -8},
    { 1272, 224, 0},
    { 1016, 224, -16},
    { 792, -192, -128},
    { 704, -104, -128},
    { 504, -248, -240},
    { 856, 176, -304},
    { 1160, 280, -360},
    { 1240, 296, -328},
    { 1272, 368, -264},
    { 1368, 520, -264},
    { 1416, 672, -288},
    { 1288, 784, -248},
    { 1128, 992, -176},
    { 1000, 864, -128},
    { 856, 976, -136},
    { 888, 888, -24},
    { 1128, 960, 0},
    { 872, 656, 40},
    { 1024, 616, -24},
    { 1264, 576, -40},
    { 1200, 416, -56},
    { 1088, 352, -112},
    { 1144, 328, -112},
    { 1176, 312, -192},
    // 26 seconds
    { 1296, 248, -136},
    { 1072, 216, -176},
    { 1096, 64, -232},
    { 672, -296, -104},
    { 1080, -152, -224},
    { 864, -112, -184},
    { 1192, 296, -320},
    { 1440, 272, -320},
    { 1336, 312, -280},
    { 1168, 392, -288},
    { 1192, 448, -120},
    { 1312, 632, -48},
    { 1296, 608, 8},
    { 1120, 752, 32},
    { 912, 864, 72},
    { 792, 872, 80},
    { 880, 872, 128},
    { 936, 808, 104},
    { 968, 704, 48},
    { 1192, 640, 8},
    { 1656, 680, -48},
    { 1576, 472, -80},
    { 1384, 432, -176},
    { 1368, 296, -120},
    { 1384, 288, -176},
    // 27 seconds
    { 1312, 216, -192},
    { 1272, 216, -232},
    { 960, -200, -160},
    { 552, -336, -280},
    { 912, -248, -272},
    { 896, -88, -272},
    { 1144, 216, -304},
    { 1384, 312, -296},
    { 1376, 376, -224},
    { 1352, 456, -192},
    { 1432, 584, -104},
    { 1456, 664, -48},
    { 1296, 800, -104},
    { 1064, 832, 0},
    { 832, 1032, -24},
    { 744, 1040, 0},
    { 808, 1120, 48},
    { 1136, 936, 24},
    { 1208, 832, -16},
    { 1320, 696, -48},
    { 1568, 608, 0},
    { 1520, 464, -40},
    { 1448, 384, -64},
    { 1504, 360, -48},
    { 1544, 336, -104},
    // 28 seconds
    { 1432, 232, 24},
    { 1320, 288, -104},
    { 1240, 248, -80},
    { 928, -192, -184},
    { 504, -344, -304},
    { 488, -504, -296},
    { 1016, 24, -408},
    { 1240, 224, -384},
    { 1328, 320, -440},
    { 1456, 424, -432},
    { 1600, 456, -320},
    { 1616, 760, -328},
    { 1424, 880, -192},
    { 1128, 1112, -192},
    { 768, 1264, -152},
    { 648, 1160, -216},
    { 624, 1104, -136},
    { 1136, 976, -104},
    { 904, 768, 32},
    { 1360, 712, 80},
    { 1912, 576, 96},
    { 1952, 480, -56},
    { 1496, 456, -136},
    { 1384, 360, -168},
    { 1192, 272, -168},
    // 29 seconds
    { 1000, 216, -240},
    { 936, 88, -280},
    { 592, -200, -296},
    { 544, -192, -384},
    { 984, 8, -344},
    { 856, 8, -224},
    { 1344, 424, -456},
    { 1776, 264, -288},
    { 1832, 472, -280},
    { 1600, 536, -216},
    { 1424, 640, -56},
    { 1424, 632, -56},
    { 1536, 704, -32},
    { 1312, 864, 208},
    { 1000, 1336, 232},
    { 824, 984, 296},
    { 608, 1448, 376},
    { 912, 744, 216},
    { 1120, 816, 136},
    { 1688, 752, -24},
    { 1880, 520, -80},
    { 1624, 520, -168},
    { 1496, 352, -216},
    { 1464, 336, -160},
    { 1456, 304, -136},
    // 30 seconds
    { 1528, 280, -256},
    { 1328, 0, -160},
    { 776, -472, -144},
    { 648, -504, -448},
    { 1080, -560, 64},
    { 1720, 232, -488},
    { 1720, 240, -360},
    { 1712, 448, -456},
    { 1680, 360, -216},
    { 1672, 568, -208},
    { 1720, 704, -200},
    { 1520, 744, -112},
    { 1256, 984, -96},
    { 960, 1376, 104},
    { 656, 1200, 16},
    { 720, 1280, 80},
    { 712, 824, 112},
    { 1200, 800, 24},
    { 1736, 736, -56},
    { 1920, 568, -88},
    { 1712, 496, -136},
    { 1640, 376, -192},
    { 1816, 392, -176},
    { 1824, 288, -168},
    { 1688, 304, -216},
    // 31 seconds
    { 1352, -184, -208},
    { 680, -600, -224},
    { 984, -680, -144},
    { 1144, -368, -224},
    { 1360, 0, -256},
    { 1472, 256, -240},
    { 1408, 296, -248},
    { 1488, 408, -200},
    { 1712, 520, -48},
    { 1928, 744, -136},
    { 1976, 952, -32},
    { 1704, 1064, 16},
    { 1016, 1408, 56},
    { 600, 1376, 40},
    { 728, 1264, 160},
    { 720, 888, 72},
    { 1128, 840, 64},
    { 1552, 712, -16},
    { 1728, 536, -88},
    { 1592, 456, -96},
    { 1576, 368, -136},
    { 1680, 392, -176},
    { 1712, 264, -128},
    { 1544, 296, -160},
    { 1344, 40, -192},
    // 32 seconds
    { 800, -520, -192},
    { 1008, -728, -32},
    { 1072, -192, -400},
    { 1464, -96, -112},
    { 1392, 304, -336},
    { 1248, 272, -200},
    { 1200, 384, -184},
    { 1480, 472, -80},
    { 1752, 696, -144},
    { 1824, 912, -56},
    { 1512, 1000, -48},
    { 976, 1336, -64},
    { 664, 1152, 32},
    { 1016, 1056, 96},
    { 776, 824, 32},
    { 976, 728, 16},
    { 1264, 664, -40},
    { 1296, 472, -96},
    { 1272, 408, -128},
    { 1384, 400, -192},
    { 1616, 288, -120},
    { 1664, 248, -88},
    { 1456, 272, -144},
    { 1464, 168, -104},
    { 736, -656, -80},
    // 33 seconds
    { 1112, -432, 56},
    { 1000, -272, -208},
    { 1064, 128, -288},
    { 1280, 320, -296},
    { 1112, 240, -288},
    { 1080, 256, -264},
    { 1216, 376, -168},
    { 1416, 616, -208},
    { 1448, 744, -232},
    { 1280, 840, -232},
    { 1000, 1000, -312},
    { 712, 864, -256},
    { 1016, 1064, -200},
    { 912, 664, -64},
    { 1144, 848, -136},
    { 1424, 704, -80},
    { 1432, 488, -104},
    { 1312, 360, -128},
    { 1240, 320, -160},
    { 1232, 296, -88},
    { 1280, 248, -80},
    { 1368, 264, -104},
    { 1240, 224, -72},
    { 920, -48, -112},
    { 800, -152, -200},
    // 34 seconds
    { 736, -392, 8},
    { 944, 136, -352},
    { 1136, 136, -248},
    { 1272, 352, -376},
    { 1264, 288, -232},
    { 1200, 384, -224},
    { 1320, 480, -176},
    { 1432, 616, -184},
    { 1440, 736, -160},
    { 1256, 928, -152},
    { 968, 1056, -192},
    { 696, 928, -120},
    { 1040, 1104, -32},
    { 960, 776, 8},
    { 1096, 784, -32},
    { 1264, 696, -32},
    { 1432, 560, -72},
    { 1392, 400, -112},
    { 1352, 336, -88},
    { 1392, 336, -128},
    { 1424, 264, -72},
    { 1328, 240, -96},
    { 1216, 240, -120},
    { 1040, -16, -160},
    { 776, -328, -160},
    // 35 seconds
    { 880, -520, 8},
    { 888, 16, -320},
    { 1112, 80, -200},
    { 1368, 416, -368},
    { 1288, 216, -184},
    { 1224, 368, -232},
    { 1376, 472, -168},
    { 1528, 648, -176},
    { 1464, 760, -168},
    { 1208, 880, -184},
    { 888, 1064, -232},
    { 640, 1264, -152},
    { 1088, 1368, -56},
    { 1128, 1048, -96},
    { 1440, 880, 0},
    { 1648, 720, -56},
    { 1544, 376, -80},
    { 1408, 416, -112},
    { 1400, 360, -88},
    { 1392, 344, -88},
    { 1416, 304, -64},
    { 1384, 272, -104},
    { 1248, 272, -120},
    { 888, 152, -160},
    { 640, -224, -264},
    // 36 seconds
    { 696, -448, -80},
    { 792, -72, -360},
    { 1040, 96, -376},
    { 1352, 352, -464},
    { 1448, 272, -328},
    { 1424, 400, -240},
    { 1520, 632, -312},
    { 1648, 672, -176},
    { 1512, 1120, -200},
    { 1432, 1096, -80},
    { 1000, 1192, -104},
    { 688, 1008, -80},
    { 1032, 1296, 24},
    { 1016, 816, 72},
    { 1224, 824, 40},
    { 1464, 712, 8},
    { 1352, 480, -48},
    { 1240, 368, -80},
    { 1304, 360, -104},
    { 1464, 320, -96},
    { 1576, 312, -104},
    { 1408, 248, -96},
    { 1320, 248, -144},
    { 1008, -80, -112},
    { 952, -304, -64},
    // 37 seconds
    { 712, -536, -72},
    { 1080, 192, -320},
    { 1288, 104, -192},
    { 1264, 408, -360},
    { 1232, 304, -256},
    { 1408, 424, -248},
    { 1616, 544, -264},
    { 1632, 864, -320},
    { 1352, 984, -424},
    { 1016, 1264, -696},
    { 600, 1272, -632},
    { 840, 864, -440},
    { 1232, 1184, -256},
    { 1152, 768, -176},
    { 1584, 768, -104},
    { 1976, 576, -16},
    { 1608, 336, -24},
    { 1360, 384, -64},
    { 1528, 368, -80},
    { 1488, 312, -24},
    { 1448, 320, -32},
    { 1352, 240, -120},
    { 1048, -232, -80},
    { 400, -424, -152},
    { 816, -464, -40},
    // 38 seconds
    { 608, -64, -208},
    { 904, 192, -224},
    { 1264, 304, -240},
    { 1280, 416, -432},
    { 1320, 136, -152},
    { 1392, 352, -296},
    { 1528, 464, -368},
    { 1496, 632, -496},
    { 1352, 808, -744},
    { 840, 1192, -976},
    { 824, 880, -784},
    { 856, 1032, -640},
    { 1224, 912, -320},
    { 1384, 816, -200},
    { 1400, 744, -168},
    { 1328, 472, 24},
    { 1208, 344, 24},
    { 1288, 392, -16},
    { 1584, 368, 32},
    { 1704, 280, 88},
    { 1432, 296, -8},
    { 1368, 320, -48},
    { 1248, 48, -40},
    { 664, -480, 48},
    { 568, -600, 40},
    // 39 seconds
    { 648, -56, -400},
    { 912, -96, -112},
    { 1360, 216, -160},
    { 1176, 320, -464},
    { 1160, 200, -344},
    { 1376, 264, -360},
    { 1552, 440, -600},
    { 1608, 520, -864},
    { 1416, 1064, -1232},
    { 936, 792, -1056},
    { 808, 880, -768},
    { 984, 736, -448},
    { 1064, 848, -272},
    { 1680, 776, -112},
    { 1632, 496, -24},
    { 1408, 416, -104},
    { 1368, 408, -56},
    { 1392, 352, -56},
    { 1464, 328, -56},
    { 1432, 240, -16},
    { 1320, 280, -80},
    { 1128, 120, -80},
    { 696, -488, 8},
    { 856, -360, -32},
    { 816, -208, -360},
    // 40 seconds
    { 1152, -16, -192},
    { 1456, 240, -176},
    { 1280, 328, -352},
    { 1296, 312, -280},
    { 1432, 408, -224},
    { 1736, 560, -248},
    { 1760, 896, -248},
    { 1504, 1040, -280},
    { 1032, 1232, -312},
    { 640, 1128, -152},
    { 888, 1120, -88},
    { 864, 840, -24},
    { 1160, 880, -8},
    { 1464, 712, -16},
    { 1600, 488, -56},
    { 1544, 376, -144},
    { 1528, 360, -144},
    { 1648, 344, -168},
    { 1536, 280, -112},
    { 1464, 288, -152},
    { 1368, 112, -80},
    { 904, -256, -48},
    { 864, -296, -152},
    { 640, -352, -88},
    { 1016, 96, -296},
    // 41 seconds
    { 1328, 48, -208},
    { 1360, 336, -368},
    { 1208, 264, -336},
    { 1192, 352, -304},
    { 1416, 464, -240},
    { 1640, 712, -432},
    { 1608, 888, -392},
    { 1328, 1144, -544},
    { 760, 1264, -432},
    { 792, 1128, -248},
    { 856, 896, -136},
    { 768, 672, -96},
    { 1080, 680, -8},
    { 1384, 592, -24},
    { 1376, 448, -16},
    { 1280, 360, -56},
    { 1344, 376, -128},
    { 1616, 344, -144},
    { 1488, 208, -80},
    { 1528, 232, -248},
    { 960, -528, -48},
    { 880, -416, -248},
    { 824, -168, -208},
    { 1072, -96, -344},
    { 1240, 136, -312},
    // 42 seconds
    { 1136, 248, -360},
    { 1040, 224, -240},
    { 1144, 400, -208},
    { 1272, 496, -152},
    { 1520, 632, -232},
    { 1488, 832, -232},
    { 1264, 880, -272},
    { 992, 1064, -280},
    { 816, 1016, -224},
    { 928, 920, -216},
    { 776, 776, -168},
    { 920, 672, -136},
    { 1280, 640, -144},
    { 1320, 440, -120},
    { 1232, 360, -168},
    { 1216, 272, -112},
    { 1280, 344, -160},
    { 1408, 264, -120},
    { 1408, 248, -56},
    { 1224, 80, -112},
    { 976, -280, -152},
    { 856, -248, 128},
    { 856, -88, -304},
    { 1112, 72, -240},
    { 1176, 264, -256},
    // 43 seconds
    { 1032, 192, -240},
    { 1040, 304, -288},
    { 1232, 400, -200},
    { 1400, 592, -272},
    { 1496, 840, -304},
    { 1424, 904, -288},
    { 1080, 1168, -344},
    { 704, 1064, -280},
    { 888, 888, -248},
    { 736, 624, -160},
    { 1104, 720, -160},
    { 1488, 608, -144},
    { 1424, 400, -104},
    { 1296, 392, -168},
    { 1256, 280, -136},
    { 1296, 272, -128},
    { 1408, 288, -128},
    { 1440, 200, -80},
    { 1184, -40, -80},
    { 888, -352, -88},
    { 824, -376, 0},
    { 872, -72, -344},
    { 1248, -24, -224},
    { 1312, 296, -312},
    { 1168, 144, -248},
    // 44 seconds
    { 1192, 336, -264},
    { 1432, 456, -136},
    { 1552, 736, -232},
    { 1528, 1000, -184},
    { 1256, 856, -160},
    { 928, 1144, -136},
    { 784, 1080, 40},
    { 1032, 944, 24},
    { 824, 736, 24},
    { 1064, 712, -16},
    { 1328, 704, -48},
    { 1288, 472, -80},
    { 1248, 360, -136},
    { 1256, 312, -80},
    { 1336, 376, -216},
    { 1576, 256, -72},
    { 1584, 216, -72},
    { 1296, 16, -104},
    { 936, -440, -64},
    { 840, -464, -32},
    { 1024, -104, -352},
    { 1496, -48, -160},
    { 1368, 360, -288},
    { 1224, 192, -256},
    { 1264, 376, -256},
    // 45 seconds
    { 1464, 528, -128},
    { 1488, 792, -240},
    { 1464, 928, -152},
    { 1240, 1048, -256},
    { 864, 1136, -352},
    { 720, 880, -272},
    { 984, 1040, -264},
    { 848, 656, -176},
    { 1160, 760, -224},
    { 1528, 736, -168},
    { 1712, 528, -96},
    { 1584, 392, -136},
    { 1464, 200, -80},
    { 1408, 384, -104},
    { 1400, 256, -136},
    { 1352, 192, -64},
    { 1152, 40, 0},
    { 744, -376, -8},
    { 1000, -296, -24},
    { 792, -312, -136},
    { 1104, 120, -304},
    { 1344, 112, -192},
    { 1304, 328, -344},
    { 1288, 216, -264},
    { 1432, 392, -272},
    // 46 seconds
    { 1768, 608, -328},
    { 1616, 808, -352},
    { 1312, 1000, -344},
    { 1040, 1000, -384},
    { 752, 1184, -288},
    { 944, 1080, -160},
    { 896, 864, -112},
    { 1000, 784, -136},
    { 1256, 688, -104},
    { 1600, 616, -88},
    { 1448, 328, -88},
    { 1336, 336, -160},
    { 1432, 336, -160},
    { 1520, 312, -120},
    { 1512, 280, -152},
    { 1360, 256, -176},
    { 1016, -168, -40},
    { 1056, -112, -168},
    { 632, -240, -64},
    { 864, 56, -376},
    { 1176, -32, -264},
    { 1296, 152, -344},
    { 1240, 200, -328},
    { 1280, 400, -360},
    { 1464, 488, -264},
    // 47 seconds
    { 1656, 632, -416},
    { 1680, 968, -264},
    { 1368, 872, -328},
    { 1088, 1000, -312},
    { 800, 896, -144},
    { 856, 984, -200},
    { 648, 768, -152},
    { 1056, 720, -112},
    { 1384, 672, -112},
    { 1328, 464, -112},
    { 1208, 392, -152},
    { 1288, 312, -136},
    { 1448, 344, -176},
    { 1584, 264, -128},
    { 1480, 232, -104},
    { 1320, 200, -200},
    { 792, -600, -32},
    { 1032, -208, 64},
    { 952, -128, -296},
    { 1248, 48, -200},
    { 1336, 288, -264},
    { 992, 184, -208},
    { 968, 216, -280},
    { 1152, 344, -88},
    { 1576, 608, -160},
    // 48 seconds
    { 1688, 768, -160},
    { 1432, 1176, -128},
    { 1064, 944, -248},
    { 704, 904, -200},
    { 928, 1016, -160},
    { 816, 736, -56},
    { 1184, 816, -128},
    { 1448, 640, -160},
    { 1360, 456, -184},
    { 1208, 408, -200},
    { 1280, 8, -176},
    { 1456, 632, -216},
    { 1672, 184, -120},
    { 1480, 136, -24},
    { 1344, 88, 40},
    { 784, -440, 240},
    { 1072, 8, 24},
    { 632, -152, -200},
    { 960, -48, -48},
    { 1352, 272, -152},
    { 1160, 248, -264},
    { 1128, 280, -224},
    { 1288, 456, -160},
    { 1488, 592, -184},
    { 1664, 816, -184},
    // 49 seconds
    { 1448, 928, -216},
    { 1080, 1208, -304},
    { 792, 1160, -312},
    { 864, 1176, -264},
    { 816, 840, -120},
    { 1200, 880, -232},
    { 1488, 776, -136},
    { 1632, 648, -72},
    { 1496, 568, -72},
    { 1576, 704, -64},
    { 1736, 888, -24},
    { 1736, 928, -48},
    { 1616, 1040, -160},
    { 1304, 880, -248},
    { 816, 280, -216},
    { 304, 56, -272},
    { 200, -192, -448},
    { -24, -120, -584},
    { -24, -544, -440},
    { -136, -280, -664},
    { -200, -288, -592},
    { -296, -408, -632},
    { -408, -376, -768},
    { -496, -424, -896},
    { -576, -456, -992},
    // 50 seconds
    { -600, -416, -1144},
    { -448, -368, -1304},
    { -544, -304, -1280},
    { -328, -208, -1352},
    { -336, -160, -1088},
    { -312, 24, -1072},
    { -160, -144, -888},
    { -128, -216, -696},
    { -112, -272, -576},
    { -48, -272, -496},
    { 104, -208, -504},
    { 288, -176, -488},
    { 512, -152, -464},
    { 928, 160, -656},
    { 1240, 328, -672},
    { 1536, 496, -544},
    { 1728, 600, -688},
    { 1864, 512, -728},
    { 1680, 400, -496},
    { 1160, 488, -464},
    { 1024, 496, -384},
    { 1032, 552, -272},
    { 976, 528, -232},
    { 920, 664, -304},
    { 944, 760, -464},
    // 51 seconds
    { 792, 1048, -504},
    { 840, 744, -384},
    { 1040, 880, -480},
    { 1080, 688, -312},
    { 1336, 784, -304},
    { 2096, 696, -224},
    { 1800, 440, -192},
    { 1496, 416, -224},
    { 1448, 344, -168},
    { 1368, 352, -152},
    { 1440, 664, -144},
    { 1632, 664, -200},
    { 1304, 736, -304},
    { 800, 336, -472},
    { 672, 520, -512},
    { 312, -352, -328},
    { 272, -568, -536},
    { 304, -440, -616},
    { 240, -576, -456},
    { 72, -640, -552},
    { -8, -576, -656},
    { -72, -592, -680},
    { -168, -640, -856},
    { -240, -592, -1024},
    { -136, -544, -1160},
    // 52 seconds
    { -88, -592, -1184},
    { -184, -424, -1296},
    { -192, -344, -1144},
    { -312, -288, -1080},
    { -184, -160, -1120},
    { -16, -240, -936},
    { -32, -280, -824},
    { -48, -320, -784},
    { -32, -328, -768},
    { -8, -352, -832},
    { 48, -352, -944},
    { 152, -376, -1008},
    { 104, -480, -984},
    { 96, -408, -1120},
    { 96, -256, -1128},
    { 152, -184, -1216},
    { 136, -232, -1168},
    { 56, -208, -1008},
    { -24, -296, -856},
    { -144, -352, -736},
    { -200, -368, -744},
    { -208, -352, -848},
    { -248, -360, -872},
    { -264, -280, -1048},
    { -184, -336, -1144},
    // 53 seconds
    { -352, -240, -1288},
    { -248, -24, -1480},
    { -176, -152, -1216},
    { -224, 96, -1272},
    { -120, 0, -1120},
    { -64, -64, -944},
    { -40, -88, -880},
    { -32, -136, -800},
    { -32, -160, -792},
    { -24, -160, -936},
    { -24, -232, -1000},
    { 0, -320, -1032},
    { -48, -392, -1008},
    { -96, -408, -1000},
    { -56, -400, -1080},
    { 8, -312, -1112},
    { -8, -264, -1072},
    { 8, -184, -1120},
    { 32, -184, -1032},
    { -8, -264, -944},
    { -104, -336, -856},
    { -176, -368, -816},
    { -192, -368, -840},
    { -160, -344, -880},
    { -96, -312, -952},
    // 54 seconds
    { -104, -336, -968},
    { -120, -344, -992},
    { -96, -384, -1016},
    { -80, -408, -1016},
    { -120, -432, -1016},
    { -184, -432, -1016},
    { -256, -360, -1080},
    { -96, -224, -1192},
    { -40, -272, -1064},
    { -144, -168, -1016},
    { -160, -128, -1024},
    { -112, -144, -1008},
    { -128, -136, -1008},
    { -104, -184, -976},
    { -88, -240, -944},
    { -104, -240, -968},
    { -96, -232, -992},
    { -112, -240, -1008},
    { -128, -256, -1016},
    { -136, -272, -1016},
    { -144, -304, -1016},
    { -136, -344, -1008},
    { -136, -368, -1000},
    { -104, -376, -1048},
    { -152, -312, -1072},
    // 55 seconds
    { -136, -296, -1032},
    { -120, -288, -976},
    { -64, -296, -936},
    { -24, -272, -928},
    { -8, -256, -984},
    { 16, -216, -1064},
    { 32, -240, -1112},
    { -32, -280, -1032},
    { -88, -336, -984},
    { -104, -352, -952},
    { -128, -320, -976},
    { -144, -296, -992},
    { -128, -280, -1016},
    { -96, -256, -1080},
    { -64, -280, -1040},
    { -104, -312, -1000},
    { -120, -336, -960},
    { -128, -320, -944},
    { -112, -272, -984},
    { -96, -256, -992},
    { -112, -280, -976},
    { -144, -296, -960},
    { -168, -312, -960},
    { -160, -288, -992},
    { -136, -288, -1016},
    // 56 seconds
    { -144, -288, -1016},
    { -144, -304, -1008},
    { -152, -304, -992},
    { -160, -320, -984},
    { -152, -312, -1000},
    { -144, -320, -992},
    { -144, -312, -984},
    { -144, -328, -984},
    { -136, -336, -984},
    { -144, -336, -984},
    { -144, -344, -984},
    { -144, -352, -976},
    { -144, -344, -968},
    { -160, -336, -960},
    { -160, -344, -960},
    { -176, -312, -952},
    { -208, -336, -968},
    { -208, -320, -976},
    { -264, -352, -984},
    { -296, -368, -1016},
    { -280, -392, -984},
    { -288, -344, -976},
    { -272, -320, -928},
    { -280, -296, -896},
    { -288, -296, -864},
    // 57 seconds
    { -288, -320, -832},
    { -280, -376, -784},
    { -272, -400, -720},
    { -152, -336, -704},
    { 120, -248, -624},
    { 408, -200, -648},
    { 680, 112, -592},
    { 1080, 176, -504},
    { 1464, 328, -576},
    { 1752, 464, -584},
    { 1864, 336, -400},
    { 1656, 416, -480},
    { 1240, 360, -424},
    { 1016, 360, -368},
    { 960, 384, -256},
    { 936, 400, -208},
    { 824, 480, -224},
    { 872, 728, -280},
    { 1056, 944, -464},
    { 864, 704, -240},
    { 1008, 976, -288},
    { 832, 528, -168},
    { 960, 640, -152},
    { 1288, 600, -184},
    { 1784, 576, -144},
    // 58 seconds
    { 1704, 336, -280},
    { 1544, 112, 64},
    { 1160, 688, -360},
    { 1416, 184, -200},
    { 1152, 264, -280},
    { 1096, 72, -256},
    { 760, -248, -120},
    { 656, -248, -296},
    { 832, -72, -176},
    { 800, -24, -376},
    { 1312, 224, -464},
    { 1544, 232, -408},
    { 1392, 272, -296},
    { 1320, 480, -248},
    { 1352, 672, -168},
    { 1456, 744, -168},
    { 1376, 624, -64},
    { 1032, 824, -24},
    { 816, 984, 88},
    { 1056, 1200, 88},
    { 912, 696, 32},
    { 1032, 752, -8},
    { 1168, 688, -16},
    { 1264, 608, -96},
    { 1216, 488, -112},
    // 59 seconds
    { 1288, 456, -272},
    { 1472, 208, -72},
    { 1600, 464, -200},
    { 1656, 136, -144},
    { 1416, 192, -160},
    { 1200, -384, 104},
    { 1152, -304, 272},
    { 840, -256, -416},
    { 976, 80, -376},
    { 1296, 16, -184},
    { 1040, 304, -352},
    { 1048, 200, -368},
    { 1280, 336, -120},
    { 1696, 664, -224},
    { 1728, 968, -280},
    { 1344, 952, -120},
    { 840, 1184, -264},
    { 712, 1120, -160},
    { 984, 944, -104},
    { 888, 912, -88},
    { 1128, 728, -104},
    { 1456, 616, -128},
    { 1280, 448, -152},
    { 1296, 360, -200},
    { 1440, 296, -192},
    // 60 seconds
    // elapsed: 1 minutes
    { 1592, 304, -200},
    { 1520, 256, -232},
    { 1568, 184, -256},
    { 960, -520, 32},
    { 728, -424, -224},
    { 824, -368, -104},
    { 1072, 8, -312},
    { 1384, 200, -312},
    { 1232, 288, -336},
    { 1200, 208, -288},
    { 1288, 416, -264},
    { 1504, 624, -232},
    { 1504, 680, -400},
    { 1392, 936, -320},
    { 1008, 1000, -472},
    { 760, 976, -496},
    { 880, 1032, -440},
    { 752, 792, -368},
    { 1320, 936, -248},
    { 1448, 624, -256},
    { 1688, 416, -112},
    { 1440, 312, -184},
    { 1392, 248, -168},
    { 1568, 392, -224},
    { 1592, 248, -136},
    // 61 seconds
    { 1528, 264, -160},
    { 1288, -232, 128},
    { 920, -512, 96},
    { 824, -328, -72},
    { 824, -40, -432},
    { 1352, -88, -88},
    { 1376, 192, -280},
    { 1120, 184, -392},
    { 1048, 296, -376},
    { 1208, 328, -224},
    { 1432, 480, -336},
    { 1576, 632, -296},
    { 1304, 1040, -280},
    { 920, 936, -424},
    { 744, 1152, -344},
    { 1016, 864, -304},
    { 808, 768, -208},
    { 1128, 704, -240},
    { 1344, 504, -368},
    { 1368, 400, -328},
    { 1432, 328, -336},
    { 1568, 32, -264},
    { 1544, 328, -304},
    { 1416, 24, -248},
    { 1112, -304, 16},
    // 62 seconds
    { 816, -376, 0},
    { 808, -176, -184},
    { 1112, 48, -24},
    { 1232, 184, -112},
    { 1536, 384, -392},
    { 1416, 352, -304},
    { 1160, 264, -200},
    { 1192, 376, -96},
    { 1568, 576, -144},
    { 1488, 824, -24},
    { 1200, 832, -32},
    { 896, 1080, -128},
    { 936, 1144, -40},
    { 896, 800, -96},
    { 600, 712, -176},
    { 1000, 648, -200},
    { 1264, 576, -216},
    { 1288, 440, -232},
    { 1232, 400, -232},
    { 1296, 248, -176},
    { 1416, 328, -200},
    { 1464, 168, -200},
    { 1272, 200, -200},
    { 1312, 240, -232},
    { 688, -560, 24},
    // 63 seconds
    { 1040, -152, -216},
    { 936, -256, -80},
    { 1176, 144, -264},
    { 1416, 392, -376},
    { 1224, 296, -288},
    { 1136, 256, -232},
    { 1280, 392, -96},
    { 1488, 624, -96},
    { 1448, 792, -112},
    { 1280, 824, -56},
    { 1016, 952, -40},
    { 848, 960, -24},
    { 720, 1008, -56},
    { 712, 840, -72},
    { 952, 792, -136},
    { 1352, 760, -160},
    { 1616, 744, -296},
    { 1432, 664, -376},
    { 1512, 664, -328},
    { 1624, 632, -240},
    { 1640, 624, -248},
    { 1560, 672, -232},
    { 1344, 376, -152},
    { 808, 16, -152},
    { 384, -104, -408},
    // 64 seconds
    { 352, -80, -496},
    { -88, -256, -664},
    { 16, -128, -856},
    { -24, -144, -976},
    { -48, -144, -808},
    { -160, -152, -832},
    { -360, -200, -824},
    { -416, -208, -880},
    { -464, -200, -944},
    { -512, -96, -1144},
    { -368, -40, -1288},
    { -408, 40, -1400},
    { -56, 184, -1544},
    { -256, 112, -1208},
    { -192, 288, -1240},
    { -104, 16, -1000},
    { -176, -16, -992},
    { -176, -64, -880},
    { -104, -104, -704},
    { -48, -128, -552},
    { 24, -24, -480},
    { 232, 56, -472},
    { 496, 72, -360},
    { 672, 96, -320},
    { 1320, 552, -568},
    // 65 seconds
    { 1528, 504, -472},
    { 1752, 848, -672},
    { 1768, 800, -840},
    { 1528, 672, -368},
    { 1400, 720, -312},
    { 1224, 848, -248},
    { 992, 632, -288},
    { 1056, 808, -48},
    { 928, 912, -64},
    { 720, 1240, -8},
    { 744, 776, -8},
    { 728, 1080, -64},
    { 1144, 784, -8},
    { 1392, 768, 0},
    { 1728, 656, -96},
    { 1504, 496, -104},
    { 1424, 408, -192},
    { 1488, 384, -160},
    { 1648, 360, -256},
    { 1560, 248, -264},
    { 1480, 208, -224},
    { 1088, -424, -56},
    { 712, -504, -208},
    { 1128, -512, 160},
    { 1328, 80, -168},
    // 66 seconds
    { 1272, 240, -272},
    { 1304, 448, -312},
    { 1312, 320, -200},
    { 1528, 392, -104},
    { 1856, 640, -80},
    { 1744, 936, -48},
    { 1504, 856, -48},
    { 1080, 1096, 88},
    { 712, 1048, 208},
    { 952, 1160, 168},
    { 824, 792, 160},
    { 992, 880, 112},
    { 1360, 784, 80},
    { 1568, 664, 8},
    { 1376, 424, -56},
    { 1400, 376, -144},
    { 1464, 272, -104},
    { 1608, 448, -176},
    { 1704, 288, -104},
    { 1416, 232, -64},
    { 1104, 192, -176},
    { 1016, -392, -96},
    { 696, -464, -40},
    { 936, 0, -424},
    { 1128, -56, -40},
    // 67 seconds
    { 1272, 480, -296},
    { 1176, 288, -192},
    { 1288, 496, -160},
    { 1592, 832, -192},
    { 1784, 840, -344},
    { 1624, 960, -176},
    { 1264, 880, -464},
    { 896, 896, -408},
    { 808, 1144, -408},
    { 752, 1080, -224},
    { 968, 960, -224},
    { 1184, 752, -200},
    { 1456, 584, -208},
    { 1312, 376, -168},
    { 1232, 280, -216},
    { 1384, 288, -256},
    { 1728, 288, -152},
    { 1552, 208, -152},
    { 1496, 248, -216},
    { 1224, -144, -8},
    { 992, -376, -16},
    { 808, -680, 64},
    { 896, 56, -424},
    { 1208, -216, 24},
    { 1456, 320, -120},
    // 68 seconds
    { 1232, 232, -344},
    { 1344, 408, -232},
    { 1592, 584, -232},
    { 1584, 800, -392},
    { 1480, 816, -208},
    { 1048, 1192, -472},
    { 744, 1120, -440},
    { 960, 1152, -368},
    { 968, 824, -216},
    { 1032, 864, -272},
    { 1264, 648, -208},
    { 1520, 560, -168},
    { 1384, 344, -160},
    { 1328, 304, -224},
    { 1392, 240, -152},
    { 1488, 264, -160},
    { 1488, 248, -96},
    { 1336, 240, -104},
    { 1072, -40, -104},
    { 696, -456, -56},
    { 912, -392, 72},
    { 992, -88, -312},
    { 1152, 72, -248},
    { 1352, 376, -304},
    { 1312, 272, -248},
    // 69 seconds
    { 1408, 392, -288},
    { 1576, 592, -208},
    { 1608, 896, -312},
    { 1448, 832, -264},
    { 1104, 1240, -408},
    { 680, 1248, -352},
    { 736, 976, -272},
    { 1016, 1080, -152},
    { 928, 728, -16},
    { 1280, 728, -40},
    { 1808, 568, 0},
    { 1648, 384, -40},
    { 1288, 392, -200},
    { 1208, 200, -184},
    { 1344, 296, -152},
    { 1440, 256, -216},
    { 1344, 192, -176},
    { 1056, -184, -64},
    { 864, -296, -160},
    { 856, -376, 8},
    { 1056, 80, -384},
    { 1376, 72, -160},
    { 1384, 360, -384},
    { 1304, 280, -256},
    { 1240, 376, -240},
    // 70 seconds
    { 1376, 472, -152},
    { 1568, 656, -208},
    { 1624, 848, -152},
    { 1344, 904, -120},
    { 984, 1144, -184},
    { 728, 984, -112},
    { 840, 1144, -104},
    { 864, 832, -56},
    { 1032, 768, -40},
    { 1408, 704, -88},
    { 1504, 472, -88},
    { 1360, 416, -144},
    { 1416, 376, -128},
    { 1640, 344, -112},
    { 1632, 200, -64},
    { 1416, 208, -136},
    { 1088, -296, -88},
    { 832, -296, -264},
    { 1072, -488, 56},
    { 1120, 80, -344},
    { 1288, 72, -152},
    { 1144, 240, -248},
    { 968, 248, -200},
    { 912, 328, -160},
    { 1120, 408, -80},
    // 71 seconds
    { 1448, 528, -112},
    { 1656, 728, -152},
    { 1472, 1328, 8},
    { 1080, 944, -256},
    { 712, 1312, 40},
    { 944, 1048, 72},
    { 904, 792, 8},
    { 1152, 800, 40},
    { 1424, 680, 24},
    { 1240, 440, -24},
    { 1104, 344, -96},
    { 1224, 344, -72},
    { 1416, 336, -144},
    { 1544, 224, -32},
    { 1328, 216, -80},
    { 1152, -16, -128},
    { 680, -376, -144},
    { 1200, -256, -72},
    { 1088, -168, -248},
    { 1248, 168, -288},
    { 1328, 360, -272},
    { 1184, 312, -168},
    { 1120, 408, -168},
    { 1280, 496, -80},
    { 1536, 640, -72},
    // 72 seconds
    { 1544, 920, 40},
    { 1208, 912, -40},
    { 832, 1232, 80},
    { 656, 1088, 88},
    { 1128, 1120, 200},
    { 1136, 792, 104},
    { 1128, 720, 64},
    { 1248, 640, 24},
    { 1288, 440, 16},
    { 1200, 328, -72},
    { 1392, 400, -104},
    { 1704, 296, -56},
    { 1488, 296, -88},
    { 1360, 256, -136},
    { 1272, 88, -152},
    { 656, -416, -200},
    { 1032, -584, -152},
    { 1008, -272, -160},
    { 1144, 200, -248},
    { 1216, 376, -256},
    { 1176, 360, -232},
    { 1184, 416, -200},
    { 1304, 512, -160},
    { 1504, 688, -136},
    { 1536, 824, -112},
    // 73 seconds
    { 1336, 1016, -144},
    { 912, 1296, -232},
    { 672, 1032, -168},
    { 904, 1176, -152},
    { 904, 792, -56},
    { 1152, 792, -88},
    { 1520, 712, -64},
    { 1472, 432, -40},
    { 1264, 352, -128},
    { 1264, 312, -120},
    { 1472, 360, -104},
    { 1456, 232, -40},
    { 1296, 256, -48},
    { 1272, 240, -40},
    { 896, -264, -56},
    { 1080, -192, 48},
    { 864, -352, -184},
    { 1024, 144, -296},
    { 1272, 344, -248},
    { 1160, 304, -264},
    { 1144, 376, -224},
    { 1344, 464, -184},
    { 1656, 640, -176},
    { 1560, 880, -152},
    { 1312, 984, -184},
    // 74 seconds
    { 904, 1496, -288},
    { 736, 1056, -136},
    { 984, 1128, -280},
    { 1024, 832, -120},
    { 1176, 760, -192},
    { 1584, 632, -168},
    { 1640, 344, -112},
    { 1312, 304, -136},
    { 1320, 296, -208},
    { 1384, 328, -120},
    { 1384, 216, -80},
    { 1296, 88, -32},
    { 952, -184, 48},
    { 528, -272, -40},
    { 976, 8, -216},
    { 1056, -88, 64},
    { 1232, 328, -280},
    { 1344, 288, -296},
    { 1272, 384, -256},
    { 1184, 240, -152},
    { 1288, 416, -176},
    { 1408, 552, -224},
    { 1416, 776, -264},
    { 1168, 872, -344},
    { 1008, 904, -384},
    // 75 seconds
    { 856, 792, -272},
    { 1088, 1056, -288},
    { 1000, 616, -104},
    { 1096, 736, -248},
    { 1344, 632, -160},
    { 1408, 392, -64},
    { 1336, 288, -128},
    { 1224, 224, -136},
    { 1392, 288, -96},
    { 1344, 280, -48},
    { 1432, 232, -96},
    { 1272, 112, 0},
    { 704, -216, -88},
    { 968, -80, -208},
    { 728, -208, 8},
    { 952, 304, -280},
    { 1144, 224, -176},
    { 1232, 384, -248},
    { 1304, 352, -208},
    { 1352, 496, -216},
    { 1448, 784, -200},
    { 1488, 800, -192},
    { 1208, 1056, -112},
    { 872, 1160, -216},
    { 760, 1200, -192},
    // 76 seconds
    { 1128, 1136, -112},
    { 776, 624, -72},
    { 968, 824, -88},
    { 1352, 712, 0},
    { 1448, 528, -32},
    { 1376, 416, -144},
    { 1336, 272, -80},
    { 1352, 424, -160},
    { 1440, 192, -72},
    { 1360, 288, -152},
    { 1288, 216, -120},
    { 920, -160, -32},
    { 824, -216, -88},
    { 736, -272, -152},
    { 920, 88, -312},
    { 1208, 160, -256},
    { 1240, 368, -344},
    { 1192, 256, -304},
    { 1280, 336, -176},
    { 1576, 496, -200},
    { 1672, 808, -248},
    { 1416, 1128, -80},
    { 1016, 1112, -288},
    { 688, 1160, -96},
    { 872, 1112, -24},
    // 77 seconds
    { 1024, 696, -40},
    { 1152, 768, -72},
    { 1416, 712, -32},
    { 1560, 536, -32},
    { 1336, 360, -96},
    { 1272, 344, -168},
    { 1464, 408, -88},
    { 1568, 240, -72},
    { 1480, 256, -88},
    { 1304, 248, -104},
    { 992, -224, -24},
    { 760, -240, -136},
    { 736, -408, 16},
    { 992, 56, -216},
    { 1224, 136, -120},
    { 1312, 440, -288},
    { 1232, 304, -240},
    { 1328, 408, -208},
    { 1544, 560, -168},
    { 1720, 728, -168},
    { 1624, 848, -168},
    { 1208, 1128, -240},
    { 840, 1224, -272},
    { 768, 952, -200},
    { 888, 968, -120},
    // 78 seconds
    { 1032, 784, -192},
    { 1320, 704, -56},
    { 1488, 624, -72},
    { 1400, 400, -56},
    { 1288, 344, -112},
    { 1328, 312, -160},
    { 1552, 320, -88},
    { 1584, 248, -96},
    { 1408, 280, -96},
    { 1320, 192, -104},
    { 976, -360, -64},
    { 848, -400, 224},
    { 824, -56, -288},
    { 1040, 144, -224},
    { 1224, 256, -160},
    { 1160, 280, -224},
    { 1176, 360, -208},
    { 1376, 464, -240},
    { 1584, 640, -256},
    { 1664, 976, -288},
    { 1432, 800, -312},
    { 1032, 1192, -352},
    { 792, 1032, -272},
    { 816, 1048, -312},
    { 760, 832, -160},
    // 79 seconds
    { 1168, 808, -160},
    { 1520, 744, -88},
    { 1544, 512, -72},
    { 1328, 384, -128},
    { 1320, 336, -144},
    { 1576, 384, -112},
    { 1680, 224, -48},
    { 1424, 248, -112},
    { 1344, 152, -136},
    { 800, -328, -96},
    { 1112, -296, 24},
    { 808, -264, -104},
    { 1000, 224, -328},
    { 1256, 192, -192},
    { 1208, 288, -256},
    { 1144, 312, -232},
    { 1272, 416, -168},
    { 1520, 536, -176},
    { 1720, 752, -208},
    { 1584, 944, -136},
    { 1168, 1104, -264},
    { 864, 1208, -184},
    { 840, 1224, -72},
    { 792, 808, -32},
    { 968, 848, -80},
    // 80 seconds
    { 1280, 744, -8},
    { 1576, 560, -56},
    { 1400, 376, -112},
    { 1352, 312, -144},
    { 1496, 344, -160},
    { 1600, 288, -144},
    { 1440, 296, -200},
    { 1408, 176, -240},
    { 840, -376, -72},
    { 1000, -376, -272},
    { 904, -384, -48},
    { 1112, 144, -344},
    { 1328, 240, -224},
    { 1216, 280, -248},
    { 1104, 312, -208},
    { 1176, 408, -152},
    { 1384, 544, -168},
    { 1568, 704, -160},
    { 1488, 1000, -112},
    { 1176, 992, -240},
    { 744, 1224, -232},
    { 632, 992, -88},
    { 1080, 1072, 16},
    { 1016, 696, -24},
    { 1280, 792, -24},
    // 81 seconds
    { 1592, 688, 0},
    { 1496, 408, -80},
    { 1288, 344, -104},
    { 1328, 216, -96},
    { 1392, 304, -80},
    { 1472, 264, -96},
    { 1224, 208, -80},
    { 1120, 104, -136},
    { 592, -368, -64},
    { 992, -96, -128},
    { 760, -176, -128},
    { 984, 272, -256},
    { 1240, 272, -216},
    { 1280, 352, -272},
    { 1264, 304, -200},
    { 1336, 456, -176},
    { 1496, 624, -144},
    { 1520, 752, -160},
    { 1320, 888, -208},
    { 1040, 1112, -256},
    { 640, 1000, -224},
    { 824, 1040, -128},
    { 968, 808, 24},
    { 1272, 824, 0},
    { 1448, 712, -8},
    // 82 seconds
    { 1512, 536, -24},
    { 1304, 384, -80},
    { 1264, 352, -120},
    { 1416, 312, -88},
    { 1472, 232, -88},
    { 1336, 264, -112},
    { 1320, 192, -160},
    { 816, -344, -88},
    { 1144, -256, -160},
    { 768, -416, -40},
    { 1040, 208, -392},
    { 1336, 168, -160},
    { 1216, 312, -264},
    { 1176, 328, -224},
    { 1296, 432, -152},
    { 1592, 600, -176},
    { 1704, 888, -152},
    { 1408, 896, -136},
    { 960, 1304, -248},
    { 616, 1272, -80},
    { 1072, 1152, -56},
    { 872, 840, -32},
    { 1224, 816, -24},
    { 1544, 680, 0},
    { 1344, 424, -48},
    // 83 seconds
    { 1248, 352, -120},
    { 1336, 328, -120},
    { 1496, 312, -80},
    { 1616, 232, -112},
    { 1416, 264, -128},
    { 1368, 168, -160},
    { 792, -384, -128},
    { 968, -384, -64},
    { 808, -312, -184},
    { 1048, 80, -248},
    { 1304, 240, -208},
    { 1216, 288, -264},
    { 1152, 312, -224},
    { 1272, 416, -184},
    { 1592, 544, -168},
    { 1792, 704, -120},
    { 1632, 1264, -72},
    { 992, 1264, -240},
    { 696, 1176, -168},
    { 912, 1128, -128},
    { 768, 872, -136},
    { 1032, 704, -160},
    { 1480, 632, -104},
    { 1592, 352, -8},
    { 1320, 312, -160},
    // 84 seconds
    { 1368, 280, -72},
    { 1456, 272, -88},
    { 1464, 192, -96},
    { 1400, 248, -136},
    { 1304, 160, -120},
    { 840, -272, -120},
    { 992, -256, -32},
    { 816, -256, -248},
    { 1048, 88, -360},
    { 1336, 200, -320},
    { 1248, 232, -328},
    { 1216, 296, -296},
    { 1264, 456, -224},
    { 1368, 688, -408},
    { 1448, 880, -416},
    { 1304, 896, -184},
    { 864, 1328, -384},
    { 760, 712, -288},
    { 1032, 912, -224},
    { 824, 592, -168},
    { 1248, 640, -200},
    { 1368, 552, -144},
    { 1416, 432, -128},
    { 1296, 304, -176},
    { 1312, 264, -176},
    // 85 seconds
    { 1400, 272, -160},
    { 1344, 224, -144},
    { 1368, 224, -192},
    { 1280, 48, -104},
    { 768, -344, -112},
    { 984, -184, -192},
    { 760, -192, -208},
    { 1008, 120, -352},
    { 1288, 184, -336},
    { 1272, 232, -360},
    { 1176, 232, -336},
    { 1256, 368, -216},
    { 1432, 568, -208},
    { 1496, 752, -176},
    { 1392, 840, -88},
    { 992, 1008, -184},
    { 768, 968, -128},
    { 664, 976, -48},
    { 896, 832, -32},
    { 1104, 808, -56},
    { 1384, 704, -24},
    { 1520, 512, -64},
    { 1336, 400, -168},
    { 1240, 336, -96},
    { 1424, 344, -120},
    // 86 seconds
    { 1624, 232, 0},
    { 1464, 168, -48},
    { 1256, 192, -72},
    { 944, -136, 0},
    { 840, -240, -64},
    { 792, -424, -40},
    { 984, 136, -344},
    { 1288, 96, -176},
    { 1248, 336, -264},
    { 1176, 240, -232},
    { 1208, 392, -224},
    { 1480, 448, -128},
    { 1720, 696, -160},
    { 1624, 984, -40},
    { 1192, 944, -160},
    { 784, 1256, -16},
    { 792, 1256, 0},
    { 912, 648, -16},
    { 928, 848, -88},
    { 1232, 712, -32},
    { 1440, 496, -40},
    { 1368, 320, -120},
    { 1408, 296, -104},
    { 1544, 272, -72},
    { 1560, 264, -64},
    // 87 seconds
    { 1536, 232, -80},
    { 1360, -32, -72},
    { 816, -352, -168},
    { 1096, -240, -96},
    { 920, -96, -232},
    { 1040, 176, -408},
    { 1224, 296, -368},
    { 1144, 256, -336},
    { 1080, 320, -288},
    { 1216, 432, -200},
    { 1440, 592, -208},
    { 1536, 800, -232},
    { 1272, 984, -168},
    { 896, 1056, -320},
    { 752, 920, -224},
    { 976, 1144, -264},
    { 960, 832, -176},
    { 1104, 728, -176},
    { 1480, 624, -176},
    { 1432, 408, -160},
    { 1408, 288, -192},
    { 1464, 232, -144},
    { 1504, 248, -104},
    { 1456, 232, -136},
    { 1296, -24, -48},
    // 88 seconds
    { 952, -296, -48},
    { 1152, -320, -80},
    { 952, -352, -24},
    { 1048, 112, -296},
    { 1320, 128, -192},
    { 1208, 272, -312},
    { 1096, 280, -264},
    { 1216, 368, -216},
    { 1456, 504, -232},
    { 1568, 704, -264},
    { 1352, 1016, -200},
    { 1008, 1192, -272},
    { 672, 1328, -176},
    { 1112, 1080, -176},
    { 944, 776, -112},
    { 1200, 744, -112},
    { 1400, 648, -120},
    { 1384, 424, -96},
    { 1248, 360, -160},
    { 1320, 336, -208},
    { 1544, 320, -128},
    { 1512, 216, -128},
    { 1400, 264, -184},
    { 1272, -8, -96},
    { 824, -352, -120},
    // 89 seconds
    { 1000, -376, 32},
    { 800, -168, -288},
    { 1096, 32, -256},
    { 1272, 248, -248},
    { 1200, 216, -264},
    { 1232, 368, -312},
    { 1416, 448, -216},
    { 1592, 656, -336},
    { 1520, 944, -296},
    { 1256, 1064, -296},
    { 816, 1560, -400},
    { 672, 1032, -240},
    { 1096, 1104, -160},
    { 984, 680, -80},
    { 1256, 704, -96},
    { 1648, 520, 0},
    { 1488, 264, 8},
    { 1312, 272, -96},
    { 1432, 312, -96},
    { 1336, 256, -96},
    { 1320, 192, -128},
    { 1176, 48, -136},
    { 984, -168, -104},
    { 736, -160, -248},
    { 928, -40, -72},
    // 90 seconds
    { 848, 72, -264},
    { 1040, 288, -400},
    { 1384, 328, -440},
    { 1296, 264, -376},
    { 1248, 272, -272},
    { 1400, 440, -184},
    { 1392, 840, -216},
    { 1152, 792, -136},
    { 872, 968, -272},
    { 672, 1072, -168},
    { 776, 800, -96},
    { 1096, 864, -152},
    { 1040, 664, -72},
    { 1304, 672, -72},
    { 1640, 584, -72},
    { 1504, 352, -64},
    { 1248, 280, -104},
    { 1376, 288, -176},
    { 1448, 240, -16},
    { 1304, 224, -128},
    { 1248, 144, -112},
    { 872, -288, 32},
    { 680, -200, -224},
    { 856, -184, -72},
    { 1016, 16, -192},
    // 91 seconds
    { 1304, 232, -224},
    { 1328, 360, -352},
    { 1224, 256, -224},
    { 1224, 360, -192},
    { 1352, 472, -184},
    { 1504, 616, -152},
    { 1464, 800, -152},
    { 1184, 984, -216},
    { 840, 1096, -168},
    { 792, 1296, -80},
    { 992, 744, -64},
    { 984, 792, -80},
    { 1272, 688, -40},
    { 1440, 528, -64},
    { 1224, 320, -104},
    { 1240, 320, -160},
    { 1400, 304, -144},
    { 1480, 232, -80},
    { 1440, 248, -160},
    { 1408, 160, -144},
    { 952, -328, -24},
    { 1160, -232, -128},
    { 792, -392, -48},
    { 976, 128, -288},
    { 1240, 144, -176},
    // 92 seconds
    { 1208, 304, -264},
    { 1216, 288, -256},
    { 1344, 400, -192},
    { 1512, 584, -224},
    { 1472, 864, -280},
    { 1272, 752, -240},
    { 976, 1152, -336},
    { 624, 984, -240},
    { 840, 1080, -200},
    { 1008, 784, -56},
    { 1240, 808, -104},
    { 1408, 648, -80},
    { 1592, 496, -96},
    { 1432, 336, -104},
    { 1336, 296, -136},
    { 1400, 344, -104},
    { 1424, 248, -56},
    { 1256, 120, -64},
    { 1104, -16, 0},
    { 792, -112, -64},
    { 1000, 8, -184},
    { 872, -176, -24},
    { 992, 248, -352},
    { 1144, 168, -296},
    { 1152, 312, -288},
    // 93 seconds
    { 1064, 248, -248},
    { 1128, 352, -200},
    { 1320, 472, -232},
    { 1456, 624, -256},
    { 1392, 864, -328},
    { 1104, 960, -400},
    { 784, 1040, -400},
    { 968, 1152, -336},
    { 960, 656, -112},
    { 1232, 904, -272},
    { 1416, 808, -176},
    { 1584, 640, -96},
    { 1576, 736, -152},
    { 1680, 816, -32},
    { 1576, 792, -40},
    { 1488, 896, -160},
    { 1352, 704, -16},
    { 736, 496, -272},
    { 600, 16, -376},
    { 280, -248, -384},
    { 192, -288, -632},
    { -16, -280, -744},
    { 112, -376, -792},
    { 176, -152, -880},
    { 72, -264, -680},
    // 94 seconds
    { -96, -216, -776},
    { -256, -256, -792},
    { -280, -280, -872},
    { -328, -232, -1056},
    { -352, -256, -1144},
    { -328, -176, -1296},
    { -392, -192, -1304},
    { -296, -72, -1568},
    { -328, 0, -1304},
    { -296, 112, -1312},
    { -96, 72, -1192},
    { -40, -88, -912},
    { -88, -32, -768},
    { -104, -80, -600},
    { -96, -32, -464},
    { -40, 8, -432},
    { 160, 16, -488},
    { 488, -48, -480},
    { 1064, 120, -400},
    { 1440, 328, -704},
    { 1528, 352, -584},
    { 1920, 504, -744},
    { 1952, 392, -624},
    { 1584, 472, -456},
    { 1192, 552, -440},
    // 95 seconds
    { 1064, 504, -392},
    { 1120, 520, -232},
    { 1088, 568, -240},
    { 928, 648, -296},
    { 768, 672, -384},
    { 768, 704, -456},
    { 896, 696, -344},
    { 920, 560, -440},
    { 1088, 528, -360},
    { 1184, 632, -304},
    { 1400, 480, -600},
    { 1408, 472, -152},
    { 1392, 456, -232},
    { 1416, 376, -192},
    { 1328, 344, -144},
    { 1344, 288, -176},
    { 1408, 224, -88},
    { 1160, 176, -80},
    { 1000, -64, 8},
    { 904, -328, 208},
    { 616, -128, -288},
    { 928, 48, -360},
    { 1328, 8, -192},
    { 1232, 296, -368},
    { 1144, 240, -368},
    // 96 seconds
    { 1312, 384, -264},
    { 1648, 560, -240},
    { 1704, 872, -336},
    { 1416, 920, -288},
    { 1056, 1176, -336},
    { 696, 1112, -288},
    { 1000, 1064, -224},
    { 832, 696, -120},
    { 1272, 808, -128},
    { 1536, 688, -144},
    { 1392, 472, -168},
    { 1320, 368, -192},
    { 1208, 240, -112},
    { 1216, 408, -168},
    { 1480, 232, -152},
    { 1480, 176, -72},
    { 1272, 160, -168},
    { 1000, -384, 112},
    { 1008, -128, -40},
    { 800, -288, -160},
    { 1128, 80, -264},
    { 1392, 120, -168},
    { 1216, 280, -264},
    { 1144, 248, -264},
    { 1240, 408, -216},
    // 97 seconds
    { 1504, 520, -176},
    { 1608, 760, -240},
    { 1488, 816, -176},
    { 1128, 1040, -328},
    { 832, 1008, -312},
    { 672, 960, -200},
    { 1040, 1104, -216},
    { 1112, 848, -176},
    { 1288, 776, -160},
    { 1640, 648, -160},
    { 1592, 424, -72},
    { 1496, 360, -152},
    { 1520, 264, -72},
    { 1448, 304, -32},
    { 1336, 240, -72},
    { 1360, 232, -40},
    { 1160, 192, -8},
    { 736, -240, -56},
    { 848, -136, -168},
    { 792, -312, -40},
    { 1008, 192, -328},
    { 1216, 184, -296},
    { 1320, 376, -400},
    { 1304, 240, -232},
    { 1368, 416, -232},
    // 98 seconds
    { 1504, 624, -256},
    { 1496, 776, -248},
    { 1344, 880, -240},
    { 1112, 1040, -312},
    { 808, 1080, -264},
    { 888, 1104, -264},
    { 952, 928, -112},
    { 1104, 928, -152},
    { 1320, 704, -120},
    { 1600, 616, -104},
    { 1384, 408, -96},
    { 1328, 352, -176},
    { 1360, 312, -120},
    { 1440, 288, -96},
    { 1488, 216, -104},
    { 1360, 232, -72},
    { 1040, 184, -104},
    { 736, -256, -168},
    { 824, -216, 16},
    { 704, -208, -200},
    { 872, 176, -320},
    { 1152, 200, -192},
    { 1224, 360, -312},
    { 1304, 304, -248},
    { 1512, 472, -216},
    // 99 seconds
    { 1616, 632, -264},
    { 1544, 800, -304},
    { 1304, 1000, -392},
    { 968, 1080, -368},
    { 616, 1000, -296},
    { 1008, 1296, -248},
    { 1104, 952, -88},
    { 1240, 816, -88},
    { 1472, 760, -104},
    { 1488, 560, -64},
    { 1520, 552, -112},
    { 1608, 656, -96},
    { 1656, 720, -72},
    { 1608, 848, -184},
    { 1488, 1064, -304},
    { 1464, 816, -392},
    { 888, 168, -232},
    { 536, 8, -408},
    { -40, -376, -520},
    { 88, -384, -488},
    { 24, -464, -592},
    { 128, -440, -616},
    { 32, -576, -528},
    { -136, -576, -592},
    { -256, -592, -656},
    // 100 seconds
    { -288, -608, -712},
    { -272, -624, -760},
    { -248, -664, -816},
    { -216, -664, -912},
    { -160, -728, -944},
    { -280, -744, -960},
    { -104, -736, -1248},
    { -272, -544, -1064},
    { -272, -448, -1208},
    { -136, -432, -1120},
    { -56, -424, -936},
    { -32, -408, -832},
    { -8, -416, -712},
    { 16, -432, -648},
    { 16, -440, -704},
    { 24, -480, -776},
    { -16, -536, -752},
    { -72, -528, -864},
    { -128, -560, -904},
    { -72, -648, -968},
    { 72, -512, -1208},
    { 96, -272, -1232},
    { 112, -368, -1176},
    { 152, -272, -1168},
    { 120, -384, -1048},
    // 101 seconds
    { 16, -416, -1000},
    { -72, -424, -936},
    { -96, -368, -928},
    { -168, -352, -904},
    { -184, -376, -904},
    { -216, -408, -864},
    { -232, -424, -880},
    { -152, -448, -848},
    { 72, -600, -664},
    { 176, -232, -584},
    { 72, 176, -504},
    { 32, 200, -424},
    { 64, 1096, -1040},
    { -40, 1440, -1168},
    { -192, 1472, -1144},
    { -632, 1368, -1064},
    { -560, 840, -1120},
    { -352, 632, -840},
    { -232, 632, -696},
    { -192, 600, -672},
    { -80, 480, -528},
    { -56, 400, -408},
    { -64, 288, -312},
    { -80, 224, -288},
    { 64, 184, -296},
    // 102 seconds
    { 336, 328, -352},
    { 696, 528, -448},
    { 1248, 648, -400},
    { 1576, 480, -312},
    { 1848, 576, -48},
    { 2144, 912, -304},
    { 1904, 968, -40},
    { 1440, 704, -80},
    { 1104, 584, -16},
    { 912, 552, 56},
    { 896, 488, 64},
    { 792, 488, 48},
    { 792, 496, -40},
    { 736, 640, -184},
    { 720, 768, -352},
    { 912, 688, -408},
    { 920, 576, -392},
    { 960, 600, -360},
    { 920, 528, -376},
    { 1056, 464, -296},
    { 1520, 448, -320},
    { 1856, 416, -232},
    { 1800, 408, -352},
    { 1528, 280, -120},
    { 1216, 424, -104},
    // 103 seconds
    { 1048, 408, -176},
    { 880, 320, -128},
    { 840, 264, -128},
    { 784, 168, -112},
    { 744, 56, -120},
    { 680, 0, -232},
    { 840, 56, -112},
    { 1016, 160, -304},
    { 1384, 336, -408},
    { 1696, 376, -408},
    { 1632, 368, -248},
    { 1464, 536, -312},
    { 1480, 568, -16},
    { 1536, 784, -80},
    { 1344, 656, 0},
    { 1264, 712, 32},
    { 1104, 760, 160},
    { 856, 808, 152},
    { 776, 776, 120},
    { 528, 776, 64},
    { 704, 624, 80},
    { 1056, 656, 104},
    { 1456, 624, -8},
    { 1528, 544, -72},
    { 1568, 528, -104},
    // 104 seconds
    { 1672, 432, -176},
    { 1672, 408, -80},
    { 1728, 336, -288},
    { 1568, 216, -32},
    { 1296, 248, -264},
    { 1216, -184, -160},
    { 840, -424, 96},
    { 840, -184, -440},
    { 1120, -48, -240},
    { 1304, 304, -336},
    { 1080, 232, -296},
    { 1056, 304, -232},
    { 1272, 392, -112},
    { 1544, 584, -88},
    { 1744, 720, -48},
    { 1696, 864, 56},
    { 1320, 824, 40},
    { 920, 872, 104},
    { 824, 864, 208},
    { 768, 1048, 152},
    { 800, 864, 40},
    { 1080, 952, 56},
    { 1440, 856, 40},
    { 1480, 768, -56},
    { 1792, 944, -88},
    // 105 seconds
    { 2032, 984, -80},
    { 1960, 1088, -136},
    { 1736, 1136, -112},
    { 1392, 576, -160},
    { 648, 416, -224},
    { 504, 64, -408},
    { 432, -248, -360},
    { 72, -368, -544},
    { 184, -344, -632},
    { 128, -504, -704},
    { 152, -464, -736},
    { 64, -472, -744},
    { -96, -544, -736},
    { -184, -560, -704},
    { -280, -560, -752},
    { -304, -608, -760},
    { -312, -672, -784},
    { -280, -528, -912},
    { -256, -680, -944},
    { -216, -584, -1032},
    { -264, -608, -1176},
    { -216, -464, -1184},
    { -232, -448, -1024},
    { -216, -224, -1104},
    { -80, -312, -1024},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

