/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */



// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:14:14 local
AccelRawData *activity_sample_walk_100_pbl_25477_15(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25477_15
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 75
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 240, -296, -968},
    { -248, 320, -720},
    { 128, -152, -976},
    { 224, -160, -984},
    { 136, 320, -1080},
    { 0, 176, -1040},
    { 136, -16, -1056},
    { 176, 56, -1104},
    { 200, -176, -1040},
    { 24, -168, -960},
    { 120, -144, -1008},
    { 336, -8, -1080},
    { 96, -32, -1000},
    { 72, -32, -1048},
    { 72, -56, -1000},
    { 24, -16, -1008},
    { 40, 32, -1048},
    { -8, -8, -1032},
    { 16, -32, -904},
    { -112, 24, -1024},
    { -96, 24, -1008},
    { -96, -32, -1008},
    { -136, -16, -968},
    { 224, 48, -984},
    { -32, -32, -1048},
    // 1 seconds
    { 80, -120, -1056},
    { 24, -24, -1056},
    { -128, -48, -960},
    { 48, -112, -960},
    { 48, -112, -920},
    { 48, -144, -840},
    { 168, -264, -696},
    { 264, -280, -584},
    { 392, -224, -504},
    { 560, -112, -520},
    { 792, -48, -512},
    { 1056, 136, -440},
    { 1304, 416, -344},
    { 1304, 544, -232},
    { 1360, 696, -168},
    { 1368, 704, -272},
    { 1472, 512, -384},
    { 1536, 576, -320},
    { 1256, 448, -232},
    { 1088, 264, -208},
    { 1048, 168, -232},
    { 968, 176, -272},
    { 888, 240, -328},
    { 800, 248, -416},
    { 896, 280, -400},
    // 2 seconds
    { 1024, 312, -416},
    { 1056, 336, -400},
    { 936, 272, -344},
    { 912, 200, -256},
    { 888, 272, -240},
    { 896, 328, -224},
    { 1056, 368, -176},
    { 1312, 288, -96},
    { 1536, 232, -48},
    { 1504, 120, -48},
    { 1368, 56, 8},
    { 1280, 72, 0},
    { 1232, 88, -24},
    { 1176, 144, -48},
    { 1072, 96, -16},
    { 968, 32, -80},
    { 1080, 8, -152},
    { 896, -112, -208},
    { 752, -216, -160},
    { 912, -200, -216},
    { 832, -80, -208},
    { 816, -24, -184},
    { 1112, -16, -256},
    { 1272, 24, -232},
    { 1192, 136, -184},
    // 3 seconds
    { 1088, 160, -208},
    { 1072, 208, -280},
    { 1088, 248, -336},
    { 1064, 296, -352},
    { 1024, 296, -360},
    { 1200, 384, -328},
    { 1304, 488, -296},
    { 872, 416, -216},
    { 1320, 472, -272},
    { 1048, 504, -264},
    { 976, 352, -192},
    { 1248, 288, -136},
    { 1488, 208, -104},
    { 1376, 112, -56},
    { 1312, 72, -40},
    { 1376, 112, -64},
    { 1464, 104, -40},
    { 1296, 64, -40},
    { 1072, -8, -56},
    { 992, -216, -112},
    { 728, -288, -128},
    { 696, -264, -112},
    { 1040, -192, -136},
    { 920, -80, -152},
    { 1024, 48, -232},
    // 4 seconds
    { 1136, 16, -336},
    { 1184, -24, -304},
    { 1104, -32, -224},
    { 1136, 56, -192},
    { 1248, 208, -224},
    { 1456, 312, -264},
    { 1384, 424, -272},
    { 1368, 512, -304},
    { 1224, 544, -296},
    { 848, 576, -312},
    { 1216, 768, -464},
    { 880, 368, -360},
    { 1136, 344, -288},
    { 1496, 288, -280},
    { 1424, 144, -184},
    { 1328, 80, -88},
    { 1400, -8, -128},
    { 1424, 48, -128},
    { 1320, 24, -160},
    { 1096, -72, -88},
    { 1088, -216, -104},
    { 864, -224, -144},
    { 704, -304, -32},
    { 992, -192, -152},
    { 984, -112, -208},
    // 5 seconds
    { 1216, -48, -240},
    { 1368, -24, -296},
    { 1112, 88, -240},
    { 872, 72, -248},
    { 960, 24, -224},
    { 1080, 72, -216},
    { 1136, 168, -264},
    { 1264, 272, -336},
    { 1456, 584, -472},
    { 1272, 608, -520},
    { 1000, 392, -392},
    { 1184, 640, -448},
    { 1040, 392, -376},
    { 1176, 320, -240},
    { 1416, 264, -176},
    { 1400, 144, -152},
    { 1224, 96, -88},
    { 1288, 56, -112},
    { 1376, 80, -72},
    { 1312, 64, -48},
    { 1152, 0, -96},
    { 1128, -104, -80},
    { 872, -232, -88},
    { 568, -272, -104},
    { 936, -184, -56},
    // 6 seconds
    { 960, -96, -144},
    { 1240, 40, -144},
    { 1512, 40, -312},
    { 1272, 56, -248},
    { 904, 24, -224},
    { 896, 120, -272},
    { 920, 80, -256},
    { 984, 40, -184},
    { 1112, 112, -160},
    { 1344, 256, -216},
    { 1584, 400, -376},
    { 1152, 320, -424},
    { 1296, 320, -528},
    { 1176, 280, -544},
    { 1000, 152, -384},
    { 1336, 184, -368},
    { 1576, 144, -176},
    { 1280, 0, -120},
    { 960, -40, -56},
    { 896, -8, -56},
    { 1048, 160, -96},
    { 1112, 160, -32},
    { 1080, 80, 0},
    { 1064, 64, -72},
    { 1008, 80, -200},
    // 7 seconds
    { 792, -8, -216},
    { 1072, -80, -136},
    { 920, -80, -120},
    { 872, 0, -216},
    { 1056, 40, -312},
    { 1120, 72, -328},
    { 944, 104, -248},
    { 912, 112, -224},
    { 1032, 184, -232},
    { 1152, 280, -216},
    { 1208, 352, -240},
    { 1184, 416, -264},
    { 1296, 464, -296},
    { 1016, 464, -256},
    { 1296, 480, -376},
    { 1088, 520, -392},
    { 1112, 400, -336},
    { 1272, 304, -224},
    { 1416, 240, -160},
    { 1248, 112, -56},
    { 1136, 16, -24},
    { 1232, 40, -48},
    { 1320, 136, -96},
    { 1280, 184, -56},
    { 1096, 104, 8},
    // 8 seconds
    { 904, -232, 144},
    { 664, -320, 48},
    { 1128, -256, 48},
    { 1072, -152, -48},
    { 1112, -48, -112},
    { 1192, -8, -240},
    { 1112, 8, -256},
    { 896, 32, -208},
    { 832, 0, -272},
    { 856, 0, -240},
    { 1016, 104, -248},
    { 1176, 184, -296},
    { 1288, 288, -328},
    { 1416, 408, -408},
    { 1112, 432, -416},
    { 1496, 432, -432},
    { 1136, 416, -464},
    { 1200, 336, -360},
    { 1312, 264, -296},
    { 1360, 184, -224},
    { 1160, 40, -64},
    { 1104, -48, -64},
    { 1200, 56, -104},
    { 1256, 80, -40},
    { 1064, 32, 24},
    // 9 seconds
    { 1136, -48, -8},
    { 1040, -128, 0},
    { 696, -208, 0},
    { 1096, -248, 56},
    { 944, -112, -48},
    { 1184, -24, -144},
    { 1344, 56, -272},
    { 1184, 24, -280},
    { 896, 24, -296},
    { 856, 32, -296},
    { 984, 72, -288},
    { 1096, 144, -304},
    { 1184, 200, -376},
    { 1416, 288, -352},
    { 1456, 640, -472},
    { 952, 480, -464},
    { 1224, 536, -432},
    { 1040, 280, -328},
    { 1208, 320, -344},
    { 1408, 288, -304},
    { 1336, 200, -176},
    { 1136, -40, -56},
    { 1096, -24, -96},
    { 1240, 24, -160},
    { 1248, 56, -144},
    // 10 seconds
    { 1048, -24, -96},
    { 1184, -56, -152},
    { 904, -184, -96},
    { 640, -184, -112},
    { 952, -88, -112},
    { 944, -80, -168},
    { 1184, -8, -248},
    { 1384, 8, -360},
    { 1160, 0, -360},
    { 848, 16, -288},
    { 840, 88, -336},
    { 984, 192, -368},
    { 1120, 256, -344},
    { 1128, 384, -376},
    { 1376, 456, -384},
    { 1240, 456, -352},
    { 1184, 448, -328},
    { 1232, 536, -440},
    { 928, 360, -368},
    { 1144, 296, -328},
    { 1384, 248, -304},
    { 1280, 176, -192},
    { 1096, 0, -64},
    { 1112, 16, -80},
    { 1224, 136, -144},
    // 11 seconds
    { 1192, 96, -120},
    { 1064, -16, -112},
    { 1088, -96, -152},
    { 864, -232, -192},
    { 712, -368, -192},
    { 1192, -160, -112},
    { 1008, -136, -208},
    { 1192, 48, -280},
    { 1264, 48, -320},
    { 1056, 88, -256},
    { 896, 72, -232},
    { 1000, 128, -160},
    { 1136, 232, -120},
    { 1232, 368, -144},
    { 1176, 352, -168},
    { 1352, 400, -232},
    { 1224, 552, -280},
    { 1144, 576, -464},
    { 1384, 656, -512},
    { 824, 288, -488},
    { 1008, 328, -464},
    { 1304, 336, -400},
    { 1408, 248, -264},
    { 1336, 104, -24},
    { 1280, -32, 0},
    // 12 seconds
    { 1384, 24, -56},
    { 1320, 128, -104},
    { 1200, 88, -120},
    { 1200, -64, -88},
    { 944, -264, -72},
    { 680, -320, -136},
    { 1120, -168, -24},
    { 1064, -56, -96},
    { 1160, 80, -136},
    { 1240, 112, -192},
    { 1136, 152, -224},
    { 976, 160, -200},
    { 1032, 128, -272},
    { 1088, 200, -168},
    { 1296, 360, -176},
    { 1328, 400, -208},
    { 1288, 416, -256},
    { 1272, 488, -280},
    { 920, 464, -248},
    { 1184, 632, -360},
    { 984, 584, -384},
    { 1040, 376, -360},
    { 1264, 328, -256},
    { 1360, 272, -304},
    { 1264, 160, -224},
    // 13 seconds
    { 1296, 104, -168},
    { 1368, 80, -152},
    { 1352, 48, -224},
    { 1200, 40, -232},
    { 1072, -136, -168},
    { 960, -272, -176},
    { 680, -368, -248},
    { 1168, -264, -24},
    { 1144, -136, -160},
    { 1256, 0, -216},
    { 1360, 48, -272},
    { 1168, 128, -304},
    { 912, 136, -240},
    { 920, 152, -184},
    { 1032, 192, -128},
    { 1160, 240, -128},
    { 1248, 272, -136},
    { 1344, 344, -192},
    { 1360, 488, -280},
    { 960, 584, -312},
    { 1152, 712, -400},
    { 848, 472, -344},
    { 1144, 416, -328},
    { 1464, 336, -256},
    { 1432, 248, -264},
    // 14 seconds
    { 1264, 176, -288},
    { 1320, 96, -152},
    { 1456, -40, -184},
    { 1336, 72, -216},
    { 1096, -24, -280},
    { 1032, -136, -280},
    { 904, -344, -216},
    { 608, -416, -208},
    { 1328, -256, -80},
    { 1248, -80, -112},
    { 1448, 80, -176},
    { 1528, 104, -216},
    { 1256, 104, -224},
    { 968, 120, -216},
    { 1000, 152, -144},
    { 1136, 224, -104},
    { 1192, 264, -128},
    { 1240, 296, -144},
    { 1384, 544, -152},
    { 1240, 696, -272},
    { 1232, 664, -288},
    { 976, 640, -328},
    { 1016, 456, -320},
    { 1272, 416, -280},
    { 1560, 288, -272},
    // 15 seconds
    { 1456, 216, -312},
    { 1544, 144, -216},
    { 1536, -32, 16},
    { 1416, -32, -128},
    { 1288, 104, -256},
    { 1064, -96, -136},
    { 1096, -240, -112},
    { 720, -256, -152},
    { 664, -296, -112},
    { 1024, -168, -64},
    { 1064, -56, -112},
    { 1320, 48, -176},
    { 1488, 112, -264},
    { 1320, 120, -232},
    { 1128, 120, -208},
    { 1080, 192, -176},
    { 1144, 264, -192},
    { 1176, 288, -192},
    { 1136, 208, -216},
    { 1328, 352, -304},
    { 1120, 608, -328},
    { 1000, 656, -488},
    { 1080, 584, -440},
    { 1016, 344, -352},
    { 1384, 376, -288},
    // 16 seconds
    { 1616, 296, -232},
    { 1352, 104, -152},
    { 1328, 48, -88},
    { 1408, 32, -88},
    { 1472, 72, -128},
    { 1240, 80, -160},
    { 1032, -80, -120},
    { 1008, -248, -88},
    { 760, -272, -152},
    { 952, -296, -64},
    { 1096, -200, -80},
    { 1176, -48, -168},
    { 1344, 16, -272},
    { 1320, 0, -296},
    { 1048, 8, -264},
    { 1008, 64, -248},
    { 1104, 128, -248},
    { 1256, 224, -184},
    { 1296, 320, -200},
    { 1264, 352, -232},
    { 1392, 368, -256},
    { 1120, 424, -272},
    { 1192, 568, -368},
    { 1024, 648, -472},
    { 1000, 368, -384},
    // 17 seconds
    { 1200, 320, -312},
    { 1440, 288, -312},
    { 1376, 200, -280},
    { 1384, 40, -144},
    { 1336, -48, -16},
    { 1344, 0, -128},
    { 1224, 144, -192},
    { 1144, 64, -160},
    { 1184, -56, -152},
    { 840, -208, -88},
    { 832, -240, -144},
    { 1024, -88, -40},
    { 1048, -56, -192},
    { 1288, 88, -216},
    { 1344, 32, -304},
    { 1128, 64, -312},
    { 992, 72, -272},
    { 1064, 160, -224},
    { 1200, 280, -112},
    { 1256, 312, -112},
    { 1168, 416, -152},
    { 1328, 496, -168},
    { 1096, 568, -216},
    { 1176, 552, -216},
    { 1152, 520, -272},
    // 18 seconds
    { 944, 392, -304},
    { 1000, 344, -272},
    { 1312, 296, -280},
    { 1384, 208, -248},
    { 1272, 120, -112},
    { 1248, 48, -24},
    { 1328, 16, -128},
    { 1336, 208, -136},
    { 1200, 128, -112},
    { 1160, 0, -72},
    { 1088, -192, 0},
    { 824, -280, 64},
    { 1160, -216, 88},
    { 1040, -80, 8},
    { 1168, -32, -136},
    { 1224, 48, -232},
    { 1184, 0, -272},
    { 1048, -32, -288},
    { 1080, 16, -272},
    { 1136, 120, -256},
    { 1136, 256, -304},
    { 1032, 280, -336},
    { 1256, 256, -320},
    { 1312, 328, -328},
    { 936, 352, -352},
    // 19 seconds
    { 1288, 416, -432},
    { 1104, 416, -424},
    { 1168, 312, -400},
    { 1304, 248, -280},
    { 1496, 192, -248},
    { 1480, 88, -96},
    { 1440, -8, -64},
    { 1520, 112, -128},
    { 1496, 160, -104},
    { 1264, 40, 40},
    { 976, -112, 112},
    { 768, -288, 104},
    { 552, -400, 48},
    { 976, -280, 72},
    { 1112, -208, -96},
    { 1232, -216, -24},
    { 1336, -112, -216},
    { 1144, -112, -232},
    { 912, -56, -192},
    { 960, -32, -256},
    { 1176, 32, -208},
    { 1456, 144, -184},
    { 1432, 208, -232},
    { 1288, 272, -296},
    { 1416, 392, -384},
    // 20 seconds
    { 1080, 408, -416},
    { 1328, 448, -392},
    { 1144, 352, -400},
    { 976, 344, -408},
    { 1008, 256, -384},
    { 1232, 176, -296},
    { 1128, 64, -176},
    { 1072, 24, -136},
    { 1168, 16, -112},
    { 1336, 16, -88},
    { 1424, 16, -64},
    { 1336, 24, -40},
    { 1288, -72, -56},
    { 1032, -280, -32},
    { 912, -456, 40},
    { 992, -408, 72},
    { 1056, -392, 56},
    { 1192, 16, -200},
    { 1136, 80, -272},
    { 1000, 144, -312},
    { 952, 152, -312},
    { 1040, 160, -192},
    { 1208, 224, -184},
    { 1256, 352, -248},
    { 1176, 432, -256},
    // 21 seconds
    { 1296, 448, -384},
    { 1208, 512, -352},
    { 944, 536, -360},
    { 1064, 552, -376},
    { 960, 368, -320},
    { 1120, 336, -296},
    { 1312, 312, -264},
    { 1288, 224, -168},
    { 1176, 88, -96},
    { 1232, 32, -48},
    { 1400, 24, -80},
    { 1328, 96, -72},
    { 1064, 56, -112},
    { 1072, -72, -96},
    { 952, -256, -104},
    { 760, -320, -40},
    { 984, -216, -32},
    { 1016, -88, -136},
    { 1176, -64, -168},
    { 1248, -40, -232},
    { 1120, -16, -216},
    { 984, 24, -240},
    { 1032, 56, -272},
    { 1144, 112, -224},
    { 1248, 136, -264},
    // 22 seconds
    { 1200, 272, -304},
    { 1208, 376, -328},
    { 1384, 456, -368},
    { 1016, 448, -360},
    { 1368, 568, -416},
    { 1008, 424, -368},
    { 920, 248, -296},
    { 1064, 240, -264},
    { 1288, 240, -216},
    { 1232, 168, -128},
    { 1200, 104, -64},
    { 1272, 88, -56},
    { 1320, 120, -80},
    { 1296, 104, -56},
    { 1016, 0, -56},
    { 1040, -72, -80},
    { 864, -264, -88},
    { 840, -288, -104},
    { 1024, -208, -104},
    { 944, -136, -144},
    { 1096, -48, -192},
    { 1152, -56, -240},
    { 1120, -8, -208},
    { 1016, 24, -200},
    { 1080, 96, -192},
    // 23 seconds
    { 1224, 192, -136},
    { 1288, 296, -128},
    { 1248, 320, -144},
    { 1464, 464, -248},
    { 1320, 640, -344},
    { 1056, 704, -432},
    { 1160, 712, -448},
    { 840, 408, -416},
    { 968, 392, -360},
    { 1296, 352, -328},
    { 1528, 288, -224},
    { 1504, 64, -16},
    { 1504, 8, -16},
    { 1576, 80, -64},
    { 1456, 160, -96},
    { 1112, 40, 64},
    { 976, -112, -24},
    { 896, -184, -48},
    { 696, -328, -80},
    { 1072, -264, 40},
    { 1112, -176, -112},
    { 1248, -32, -160},
    { 1184, -32, -264},
    { 1016, 0, -248},
    { 920, 32, -240},
    // 24 seconds
    { 1032, 64, -256},
    { 1232, 136, -192},
    { 1512, 200, -184},
    { 1392, 280, -216},
    { 1400, 384, -248},
    { 1384, 472, -280},
    { 920, 424, -344},
    { 1272, 608, -392},
    { 976, 608, -456},
    { 928, 416, -392},
    { 1040, 376, -320},
    { 1248, 280, -264},
    { 1096, 176, -152},
    { 1152, 96, -136},
    { 1376, 104, -96},
    { 1552, 128, -112},
    { 1568, 248, -72},
    { 1328, -96, -152},
    { 1200, -392, 64},
    { 800, -480, -16},
    { 1024, -456, 136},
    { 1000, -256, 0},
    { 1064, -168, -128},
    { 1120, -88, -152},
    { 1056, -48, -216},
    // 25 seconds
    { 880, -56, -216},
    { 888, 8, -224},
    { 1024, 88, -248},
    { 1176, 152, -296},
    { 1216, 160, -344},
    { 1240, 328, -392},
    { 1424, 560, -544},
    { 1008, 264, -440},
    { 1392, 352, -456},
    { 1248, 336, -456},
    { 1136, 232, -360},
    { 1192, 208, -320},
    { 1280, 96, -200},
    { 1120, 24, -104},
    { 992, -16, -104},
    { 1080, 8, -136},
    { 1232, 40, -104},
    { 1200, 0, -56},
    { 1128, -40, -72},
    { 1208, -168, -128},
    { 816, -256, -80},
    { 1120, -272, 104},
    { 976, -104, -16},
    { 1064, -152, -152},
    { 1176, -48, -256},
    // 26 seconds
    { 1112, -48, -288},
    { 888, -40, -304},
    { 880, 0, -320},
    { 1000, 24, -328},
    { 1088, 72, -304},
    { 1168, 168, -344},
    { 1376, 376, -384},
    { 1456, 496, -408},
    { 1240, 520, -416},
    { 1232, 600, -424},
    { 936, 320, -344},
    { 1112, 304, -312},
    { 1256, 240, -248},
    { 1272, 200, -224},
    { 1128, 64, -80},
    { 1064, 48, -64},
    { 1208, 104, -104},
    { 1312, 112, -112},
    { 1136, 48, -56},
    { 1200, -32, -88},
    { 1088, -128, -152},
    { 880, -224, -224},
    { 1128, -152, -40},
    { 856, -168, -168},
    { 880, -88, -200},
    // 27 seconds
    { 1056, -16, -312},
    { 1088, 8, -312},
    { 944, 40, -272},
    { 1024, 88, -256},
    { 1152, 160, -192},
    { 1256, 224, -192},
    { 1216, 264, -240},
    { 1304, 296, -248},
    { 1424, 440, -312},
    { 1088, 568, -344},
    { 1240, 648, -408},
    { 952, 368, -392},
    { 1056, 360, -344},
    { 1184, 312, -320},
    { 1344, 264, -312},
    { 1248, 208, -96},
    { 1152, 24, 0},
    { 1160, 0, -16},
    { 1216, 120, -80},
    { 1160, 144, -48},
    { 1112, 136, 24},
    { 1040, 56, 0},
    { 848, -112, -32},
    { 1024, -240, -8},
    { 1048, -184, 24},
    // 28 seconds
    { 1088, -88, -104},
    { 1224, 16, -128},
    { 1152, 32, -184},
    { 936, 120, -208},
    { 768, 72, -288},
    { 864, 152, -312},
    { 1088, 152, -280},
    { 1288, 224, -288},
    { 1272, 344, -296},
    { 1504, 424, -312},
    { 1256, 456, -328},
    { 1184, 432, -320},
    { 1096, 464, -392},
    { 920, 352, -336},
    { 1016, 312, -312},
    { 1216, 272, -256},
    { 1240, 224, -176},
    { 1104, 96, -104},
    { 1120, 48, -120},
    { 1272, 80, -104},
    { 1344, 160, -136},
    { 1088, 0, 56},
    { 1032, -320, 0},
    { 968, -392, 136},
    { 936, -296, 136},
    // 29 seconds
    { 1184, -32, 24},
    { 1072, -208, -136},
    { 1208, -56, -200},
    { 1200, -48, -296},
    { 944, -128, -264},
    { 776, -56, -264},
    { 840, 40, -272},
    { 992, 136, -280},
    { 1136, 184, -288},
    { 1120, 224, -360},
    { 1408, 336, -432},
    { 1232, 384, -400},
    { 1280, 352, -384},
    { 1256, 400, -416},
    { 1120, 272, -344},
    { 1208, 224, -304},
    { 1304, 144, -232},
    { 1152, 80, -184},
    { 984, 56, -152},
    { 1032, 64, -128},
    { 1192, 120, -120},
    { 1160, 112, -104},
    { 1016, 64, -24},
    { 1120, 24, -104},
    { 880, -152, -152},
    // 30 seconds
    { 800, -232, -24},
    { 1048, -216, -88},
    { 1064, -128, -112},
    { 1184, 8, -200},
    { 1160, 56, -248},
    { 984, 40, -296},
    { 888, 16, -304},
    { 1008, 104, -248},
    { 1184, 184, -240},
    { 1344, 288, -216},
    { 1176, 496, -264},
    { 1336, 464, -344},
    { 1208, 480, -280},
    { 1104, 432, -264},
    { 1240, 488, -344},
    { 1008, 392, -360},
    { 952, 344, -264},
    { 1064, 288, -272},
    { 1160, 192, -192},
    { 1120, 112, -96},
    { 1104, 32, -56},
    { 1184, 32, -88},
    { 1232, 96, -136},
    { 1208, 64, -104},
    { 1192, 48, -72},
    // 31 seconds
    { 1128, -40, -160},
    { 872, -184, -96},
    { 1088, -336, 88},
    { 1000, -232, -32},
    { 1040, -72, -128},
    { 1104, -24, -256},
    { 1032, -8, -256},
    { 856, 0, -296},
    { 856, 16, -288},
    { 1016, 104, -312},
    { 1168, 152, -344},
    { 1152, 248, -360},
    { 1296, 424, -368},
    { 1352, 464, -448},
    { 1080, 400, -328},
    { 1280, 512, -352},
    { 1016, 384, -344},
    { 1040, 328, -312},
    { 1160, 280, -296},
    { 1312, 216, -208},
    { 1176, 96, -72},
    { 1120, 0, -72},
    { 1240, 72, -136},
    { 1296, 120, -120},
    { 1192, 56, -40},
    // 32 seconds
    { 1144, -56, -32},
    { 1088, -232, -40},
    { 992, -312, -32},
    { 1248, -216, 16},
    { 1016, -72, -112},
    { 936, 8, -224},
    { 968, 24, -312},
    { 1008, 16, -312},
    { 936, 104, -328},
    { 1008, 64, -288},
    { 1128, 200, -168},
    { 1200, 256, -240},
    { 1136, 456, -336},
    { 1328, 488, -304},
    { 1448, 448, -184},
    { 1016, 424, -152},
    { 1176, 632, -288},
    { 880, 512, -288},
    { 840, 416, -312},
    { 1032, 368, -256},
    { 1328, 304, -232},
    { 1280, 232, -120},
    { 1256, 32, -40},
    { 1344, 32, -48},
    { 1392, 112, -112},
    // 33 seconds
    { 1272, 104, -152},
    { 1080, 24, -128},
    { 1168, -104, -176},
    { 784, -288, -80},
    { 984, -304, -104},
    { 1000, -192, -40},
    { 1048, -136, -272},
    { 1168, -32, -272},
    { 1200, 0, -328},
    { 968, 40, -328},
    { 888, 104, -328},
    { 1016, 112, -296},
    { 1216, 168, -240},
    { 1288, 304, -272},
    { 1256, 376, -328},
    { 1416, 472, -448},
    { 1136, 440, -360},
    { 1240, 488, -392},
    { 1040, 440, -432},
    { 952, 360, -392},
    { 1056, 304, -336},
    { 1328, 248, -288},
    { 1256, 80, -136},
    { 1096, -32, -88},
    { 1136, -56, -200},
    // 34 seconds
    { 1312, 120, -184},
    { 1256, 80, -208},
    { 1088, 16, -208},
    { 1096, -56, -264},
    { 848, -320, -176},
    { 960, -368, -48},
    { 1072, -224, -56},
    { 1120, -88, -96},
    { 1224, 48, -216},
    { 1216, 0, -272},
    { 976, 40, -256},
    { 856, 72, -232},
    { 984, 144, -216},
    { 1192, 200, -248},
    { 1248, 248, -288},
    { 1224, 384, -344},
    { 1392, 568, -392},
    { 1128, 464, -400},
    { 1368, 512, -384},
    { 1168, 464, -400},
    { 1040, 336, -360},
    { 1096, 288, -296},
    { 1320, 240, -256},
    { 1272, 48, -64},
    { 1152, 8, -24},
    // 35 seconds
    { 1256, 40, -104},
    { 1336, 144, -136},
    { 1328, 104, -88},
    { 1096, -64, -64},
    { 1104, -184, -56},
    { 800, -336, -32},
    { 1024, -336, 72},
    { 1032, -168, 8},
    { 1144, -72, -120},
    { 1232, -8, -224},
    { 1232, 16, -256},
    { 1016, 72, -264},
    { 920, 112, -296},
    { 1064, 136, -248},
    { 1168, 216, -264},
    { 1240, 416, -336},
    { 1272, 504, -336},
    { 1368, 544, -424},
    { 1040, 464, -320},
    { 1248, 600, -368},
    { 928, 376, -328},
    { 1000, 320, -264},
    { 1184, 280, -272},
    { 1392, 288, -224},
    { 1248, 112, -80},
    // 36 seconds
    { 1120, 40, -48},
    { 1200, 56, -104},
    { 1344, 104, -112},
    { 1144, 56, -80},
    { 1064, -64, -88},
    { 1024, -184, -88},
    { 696, -336, -144},
    { 1096, -264, -48},
    { 1064, -184, -144},
    { 1152, -48, -168},
    { 1232, -32, -288},
    { 1160, -8, -272},
    { 952, 16, -280},
    { 928, 72, -272},
    { 1072, 136, -248},
    { 1224, 280, -264},
    { 1192, 368, -296},
    { 1248, 384, -296},
    { 1368, 488, -312},
    { 1040, 536, -312},
    { 1248, 664, -416},
    { 976, 464, -384},
    { 1000, 360, -336},
    { 1176, 304, -296},
    { 1416, 264, -264},
    // 37 seconds
    { 1216, 160, -112},
    { 1136, 64, -72},
    { 1240, 80, -72},
    { 1352, 152, -112},
    { 1264, 112, -56},
    { 1112, 40, -64},
    { 1128, -48, -152},
    { 704, -336, -104},
    { 1112, -320, -96},
    { 976, -280, -152},
    { 1120, -120, -192},
    { 1224, -56, -280},
    { 1136, 0, -256},
    { 904, 40, -248},
    { 912, 80, -256},
    { 1104, 128, -184},
    { 1384, 216, -176},
    { 1496, 360, -232},
    { 1456, 648, -200},
    { 1344, 616, -592},
    { 1072, 576, -360},
    { 1184, 696, -408},
    { 952, 464, -384},
    { 1040, 400, -312},
    { 1224, 344, -264},
    // 38 seconds
    { 1456, 320, -256},
    { 1320, 176, -96},
    { 1264, 88, -48},
    { 1320, 72, -56},
    { 1328, 104, -104},
    { 1216, 128, -112},
    { 1056, 64, -88},
    { 1016, -24, -128},
    { 760, -216, -184},
    { 1024, -304, -120},
    { 1112, -248, -224},
    { 1216, -96, -224},
    { 1304, -40, -320},
    { 1200, 16, -280},
    { 992, 112, -296},
    { 968, 144, -288},
    { 1096, 144, -192},
    { 1272, 256, -144},
    { 1352, 376, -144},
    { 1160, 384, -216},
    { 1376, 424, -248},
    { 1144, 528, -288},
    { 1032, 584, -336},
    { 1136, 640, -328},
    { 968, 480, -336},
    // 39 seconds
    { 1072, 432, -312},
    { 1280, 360, -296},
    { 1336, 272, -208},
    { 1192, 160, -120},
    { 1280, 96, -72},
    { 1424, 112, -96},
    { 1408, 128, -104},
    { 1264, 120, -88},
    { 1264, -24, -48},
    { 1160, -160, -80},
    { 1024, -280, 8},
    { 1008, -256, 0},
    { 1096, -144, -144},
    { 1072, -64, -152},
    { 1088, 0, -256},
    { 960, 32, -240},
    { 880, 88, -296},
    { 944, 104, -288},
    { 1168, 168, -256},
    { 1392, 264, -256},
    { 1336, 496, -288},
    { 1376, 456, -400},
    { 1328, 512, -296},
    { 1104, 624, -296},
    { 1304, 704, -392},
    // 40 seconds
    { 952, 376, -352},
    { 992, 368, -296},
    { 1208, 312, -280},
    { 1232, 264, -152},
    { 1112, 120, -64},
    { 1200, 80, -48},
    { 1384, 40, -88},
    { 1304, 104, 0},
    { 1232, 80, -40},
    { 1224, 56, -64},
    { 960, -80, -120},
    { 656, -264, -200},
    { 936, -280, -184},
    { 920, -224, -288},
    { 1048, -104, -296},
    { 1176, -48, -344},
    { 1136, 40, -320},
    { 968, 88, -232},
    { 960, 152, -240},
    { 1128, 184, -208},
    { 1312, 312, -256},
    { 1232, 392, -296},
    { 1392, 384, -328},
    { 1328, 456, -312},
    { 952, 552, -240},
    // 41 seconds
    { 1008, 696, -368},
    { 840, 464, -304},
    { 1088, 408, -264},
    { 1320, 320, -184},
    { 1296, 256, -176},
    { 1096, 128, -80},
    { 1160, 88, -96},
    { 1296, 0, -88},
    { 1264, 80, -72},
    { 1120, 0, -176},
    { 1136, -32, -280},
    { 960, -184, -296},
    { 720, -288, -264},
    { 1040, -184, -184},
    { 1192, -96, -240},
    { 1280, 0, -264},
    { 1312, 56, -256},
    { 1040, 104, -264},
    { 808, 128, -240},
    { 848, 208, -152},
    { 992, 216, -120},
    { 1080, 272, -144},
    { 1144, 304, -160},
    { 1264, 392, -184},
    { 1328, 560, -216},
    // 42 seconds
    { 1056, 552, -248},
    { 1088, 568, -264},
    { 944, 440, -288},
    { 1064, 368, -272},
    { 1208, 312, -184},
    { 1280, 248, -160},
    { 1128, 136, -128},
    { 1144, 128, -136},
    { 1280, 88, -120},
    { 1304, 64, -144},
    { 1184, 32, -184},
    { 1016, 0, -216},
    { 984, -128, -304},
    { 704, -288, -256},
    { 1008, -272, -200},
    { 984, -120, -296},
    { 1136, -32, -288},
    { 1256, 48, -288},
    { 1104, 104, -240},
    { 880, 176, -216},
    { 872, 232, -192},
    { 992, 224, -120},
    { 1184, 272, -88},
    { 1168, 304, -200},
    { 1320, 456, -376},
    // 43 seconds
    { 1176, 816, -384},
    { 952, 528, -416},
    { 1112, 544, -336},
    { 984, 432, -336},
    { 1120, 416, -296},
    { 1208, 320, -224},
    { 1232, 264, -144},
    { 1096, 152, -96},
    { 1072, 120, -88},
    { 1216, 112, -112},
    { 1344, 128, -88},
    { 1152, 88, -144},
    { 1088, -72, -144},
    { 1080, -152, -168},
    { 776, -304, -144},
    { 1152, -192, -136},
    { 1096, -112, -248},
    { 1112, -8, -280},
    { 1152, 16, -344},
    { 1080, 56, -368},
    { 896, 104, -368},
    { 936, 128, -312},
    { 1064, 160, -248},
    { 1192, 248, -232},
    { 1112, 352, -272},
    // 44 seconds
    { 1296, 392, -288},
    { 1288, 552, -352},
    { 904, 504, -296},
    { 1224, 616, -320},
    { 992, 512, -336},
    { 1040, 416, -336},
    { 1200, 360, -264},
    { 1376, 280, -248},
    { 1248, 168, -152},
    { 1232, 80, -88},
    { 1384, 72, -72},
    { 1328, 88, -136},
    { 1104, 64, -152},
    { 1000, -48, -184},
    { 1048, -144, -248},
    { 736, -288, -256},
    { 1144, -296, -64},
    { 960, -184, -160},
    { 1096, -16, -144},
    { 1240, 24, -256},
    { 1184, 24, -272},
    { 960, 88, -224},
    { 944, 152, -280},
    { 1096, 160, -168},
    { 1272, 216, -232},
    // 45 seconds
    { 1248, 328, -312},
    { 1304, 544, -352},
    { 1288, 560, -480},
    { 1096, 496, -400},
    { 1160, 576, -432},
    { 1016, 392, -392},
    { 1096, 360, -336},
    { 1256, 288, -264},
    { 1360, 248, -264},
    { 1192, 72, -96},
    { 1112, 72, -88},
    { 1216, 64, -168},
    { 1272, 128, -160},
    { 1080, 24, -136},
    { 1040, -104, -104},
    { 992, -288, -104},
    { 728, -352, -88},
    { 1328, -264, 8},
    { 1160, -136, -120},
    { 1272, 16, -120},
    { 1256, 0, -280},
    { 1096, 8, -232},
    { 912, 80, -232},
    { 960, 136, -232},
    { 1096, 168, -200},
    // 46 seconds
    { 1216, 216, -240},
    { 1152, 424, -376},
    { 1344, 504, -504},
    { 1184, 488, -368},
    { 1144, 456, -304},
    { 1240, 600, -376},
    { 1088, 440, -360},
    { 1208, 352, -280},
    { 1392, 256, -232},
    { 1280, 176, -168},
    { 1136, 56, -64},
    { 1168, 32, -96},
    { 1304, 96, -144},
    { 1272, 104, -112},
    { 1096, -56, -48},
    { 1216, -184, -80},
    { 840, -296, -16},
    { 1056, -296, 48},
    { 1056, -192, -8},
    { 1176, -72, -112},
    { 1320, -24, -224},
    { 1312, 0, -264},
    { 1048, 80, -272},
    { 904, 176, -320},
    { 1016, 152, -280},
    // 47 seconds
    { 1160, 216, -296},
    { 1104, 344, -328},
    { 1128, 376, -312},
    { 1400, 464, -368},
    { 1112, 504, -288},
    { 1336, 536, -312},
    { 1192, 448, -312},
    { 1104, 352, -296},
    { 1152, 312, -248},
    { 1336, 272, -224},
    { 1256, 176, -128},
    { 1160, 96, -88},
    { 1288, 120, -88},
    { 1376, 128, -64},
    { 1296, 96, -64},
    { 1120, 40, -72},
    { 1064, -48, -136},
    { 808, -208, -136},
    { 776, -280, -120},
    { 1024, -224, -104},
    { 1008, -136, -168},
    { 1184, -48, -224},
    { 1152, -8, -248},
    { 1000, 56, -232},
    { 920, 80, -224},
    // 48 seconds
    { 1104, 144, -216},
    { 1344, 184, -128},
    { 1576, 296, -144},
    { 1400, 440, -280},
    { 1416, 928, -352},
    { 1080, 536, -432},
    { 1072, 496, -336},
    { 1184, 632, -392},
    { 1000, 480, -376},
    { 1104, 400, -304},
    { 1328, 344, -256},
    { 1240, 248, -160},
    { 1184, 128, -72},
    { 1320, 96, -56},
    { 1472, 112, -72},
    { 1392, 136, -40},
    { 1208, 104, -48},
    { 1216, 16, -72},
    { 952, -112, -88},
    { 904, -224, -136},
    { 1064, -184, -32},
    { 936, -176, -176},
    { 1032, -48, -256},
    { 1048, -48, -328},
    { 968, 32, -352},
    // 49 seconds
    { 864, 32, -352},
    { 976, 72, -336},
    { 1136, 104, -328},
    { 1296, 216, -328},
    { 1280, 400, -352},
    { 1528, 504, -432},
    { 1264, 488, -392},
    { 1448, 552, -392},
    { 1080, 528, -392},
    { 976, 352, -368},
    { 1056, 328, -296},
    { 1240, 272, -248},
    { 1088, 184, -176},
    { 1024, 120, -112},
    { 1136, 88, -120},
    { 1344, 96, -112},
    { 1336, 104, -144},
    { 1216, 16, -144},
    { 1320, -96, -184},
    { 840, -328, -72},
    { 1056, -328, -144},
    { 1032, -280, -56},
    { 1080, -120, -184},
    { 1160, -40, -208},
    { 1208, 8, -312},
    // 50 seconds
    { 976, 96, -264},
    { 920, 144, -312},
    { 984, 192, -208},
    { 1112, 256, -240},
    { 1112, 296, -264},
    { 1232, 456, -288},
    { 1360, 560, -448},
    { 1032, 464, -296},
    { 1328, 608, -344},
    { 1008, 472, -368},
    { 1112, 376, -320},
    { 1304, 360, -224},
    { 1352, 272, -184},
    { 1192, 136, -120},
    { 1168, 104, -104},
    { 1400, 72, -160},
    { 1408, 64, -144},
    { 1200, 16, -160},
    { 1096, -160, -168},
    { 936, -344, -144},
    { 760, -400, -88},
    { 1080, -240, -80},
    { 1192, -112, -160},
    { 1336, -40, -208},
    { 1368, 8, -304},
    // 51 seconds
    { 1080, 48, -312},
    { 872, 104, -336},
    { 960, 200, -264},
    { 1120, 248, -272},
    { 1176, 328, -232},
    { 1240, 392, -240},
    { 1328, 480, -208},
    { 1120, 616, -280},
    { 1152, 656, -232},
    { 1032, 544, -240},
    { 1040, 384, -216},
    { 1256, 400, -176},
    { 1448, 328, -168},
    { 1288, 256, -168},
    { 1144, 152, -144},
    { 1248, 136, -160},
    { 1384, 72, -144},
    { 1240, 32, -176},
    { 1080, -8, -200},
    { 984, -104, -232},
    { 760, -336, -168},
    { 784, -296, -128},
    { 1128, -88, -216},
    { 1176, 136, -256},
    { 1368, 256, -312},
    // 52 seconds
    { 1280, 264, -320},
    { 960, 256, -240},
    { 816, 200, -240},
    { 928, 208, -152},
    { 1080, 216, -112},
    { 1112, 272, -136},
    { 1144, 392, -224},
    { 1440, 560, -224},
    { 1120, 712, -200},
    { 1240, 648, -248},
    { 928, 480, -312},
    { 976, 488, -288},
    { 1104, 392, -256},
    { 1264, 336, -200},
    { 1136, 208, -120},
    { 1056, 160, -136},
    { 1192, 136, -136},
    { 1336, 112, -120},
    { 1296, 56, -152},
    { 1144, 48, -232},
    { 1152, -16, -288},
    { 832, -240, -176},
    { 1016, -312, -104},
    { 936, -168, -176},
    { 1056, -56, -224},
    // 53 seconds
    { 1240, 24, -296},
    { 1224, 72, -312},
    { 992, 104, -264},
    { 960, 176, -296},
    { 1088, 232, -240},
    { 1152, 304, -272},
    { 1072, 400, -280},
    { 984, 384, -280},
    { 1152, 472, -296},
    { 976, 528, -224},
    { 1376, 696, -208},
    { 1304, 520, -296},
    { 1080, 336, -264},
    { 1216, 384, -240},
    { 1416, 320, -256},
    { 1232, 216, -144},
    { 1232, 160, -80},
    { 1376, 160, -88},
    { 1448, 208, -80},
    { 1256, 232, -104},
    { 1048, 184, -112},
    { 984, 192, -184},
    { 832, 224, -296},
    { 584, 152, -328},
    { 608, 304, -392},
    // 54 seconds
    { 376, 576, -584},
    { 296, 824, -624},
    { 400, 968, -728},
    { 296, 832, -712},
    { 152, 656, -520},
    { 32, 592, -416},
    { -88, 608, -280},
    { -152, 744, -184},
    { -248, 848, -32},
    { -336, 896, -48},
    { -336, 968, 72},
    { -272, 1112, 96},
    { -288, 1296, 152},
    { -16, 1424, 88},
    { 16, 1264, -16},
    { -8, 1032, -56},
    { 16, 912, -128},
    { -96, 976, -152},
    { -104, 1192, -248},
    { -120, 1064, -424},
    { 24, 888, -384},
    { 184, 496, -648},
    { 184, 240, -824},
    { 120, 120, -856},
    { 120, -176, -928},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:16:06 local
AccelRawData *activity_sample_walk_100_pbl_25477_16(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25477_16
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 264, -360, -984},
    { 104, -368, -1000},
    { 72, -344, -1000},
    { 40, -384, -984},
    { 24, -336, -1032},
    { 8, -184, -1056},
    { 40, -184, -1072},
    { 240, 104, -760},
    { 112, -104, -1192},
    { 88, -168, -1064},
    { 0, -208, -992},
    { 0, -152, -976},
    { -32, -192, -984},
    { -144, -264, -912},
    { -104, -128, -952},
    { -80, -272, -984},
    { -56, -304, -992},
    { -56, -240, -1024},
    { -240, -296, -968},
    { -136, -296, -968},
    { -136, -312, -1016},
    { -128, -288, -1024},
    { -120, -296, -1000},
    { -152, -312, -992},
    { -80, -296, -1000},
    // 1 seconds
    { -128, -280, -984},
    { -72, -264, -1008},
    { -80, -240, -1008},
    { -88, -240, -1000},
    { -200, -216, -976},
    { -128, -176, -1008},
    { -120, -280, -1024},
    { -120, -248, -1000},
    { -144, -272, -1000},
    { -88, -336, -976},
    { -112, -384, -880},
    { -128, -496, -776},
    { -152, -480, -720},
    { -152, -520, -648},
    { -8, -336, -592},
    { 208, -240, -520},
    { 656, -8, -608},
    { 1288, 240, -600},
    { 1800, 360, 0},
    { 1952, 688, 152},
    { 1808, 656, 144},
    { 1544, 656, 56},
    { 1384, 568, 64},
    { 1240, 368, 56},
    { 1184, 352, 80},
    // 2 seconds
    { 1048, 264, 128},
    { 960, 240, 152},
    { 896, 264, 184},
    { 848, 320, 184},
    { 888, 368, 96},
    { 984, 424, 96},
    { 1224, 464, 160},
    { 1200, 592, 304},
    { 1120, 680, 368},
    { 672, 600, 120},
    { 696, 608, 96},
    { 1008, 584, 144},
    { 1480, 376, 168},
    { 1600, 328, 56},
    { 1472, 184, 16},
    { 1448, 144, -16},
    { 1344, 136, -8},
    { 1296, 96, -24},
    { 1192, 80, -128},
    { 1280, 56, -240},
    { 1104, -104, -288},
    { 816, -288, -192},
    { 928, -304, -200},
    { 696, -168, -208},
    { 712, -80, -224},
    // 3 seconds
    { 920, 56, -328},
    { 1216, 16, -336},
    { 1312, 112, -256},
    { 1280, 128, -224},
    { 1288, 232, -216},
    { 1248, 376, -240},
    { 1168, 488, -272},
    { 1112, 568, -264},
    { 1384, 688, -208},
    { 1200, 776, -120},
    { 1008, 704, -168},
    { 1088, 696, -128},
    { 904, 544, -176},
    { 1200, 432, -144},
    { 1480, 368, -112},
    { 1544, 264, -80},
    { 1392, 120, 0},
    { 1352, 136, -80},
    { 1368, 160, -136},
    { 1288, 120, -48},
    { 1144, 32, -152},
    { 992, -104, -112},
    { 912, -288, -104},
    { 680, -392, -136},
    { 944, -320, -72},
    // 4 seconds
    { 976, -152, -208},
    { 1096, -88, -288},
    { 1312, -96, -304},
    { 1264, -24, -272},
    { 1040, 56, -264},
    { 1000, 112, -288},
    { 1080, 160, -256},
    { 1240, 280, -248},
    { 1312, 336, -200},
    { 1440, 456, -224},
    { 1536, 632, -216},
    { 952, 728, -192},
    { 1136, 728, -296},
    { 1000, 608, -240},
    { 872, 472, -248},
    { 1064, 464, -256},
    { 1392, 384, -224},
    { 1440, 192, -104},
    { 1400, 120, -80},
    { 1496, 136, -152},
    { 1536, 72, -152},
    { 1392, 32, -120},
    { 1104, -40, -144},
    { 1056, -104, -272},
    { 752, -400, -152},
    // 5 seconds
    { 728, -440, -104},
    { 912, -336, -40},
    { 1008, -64, -152},
    { 1256, 16, -224},
    { 1416, 8, -296},
    { 1248, 120, -304},
    { 1072, 144, -296},
    { 1072, 264, -304},
    { 1152, 336, -288},
    { 1200, 384, -280},
    { 1208, 336, -248},
    { 1448, 448, -240},
    { 1176, 608, -112},
    { 1056, 776, -272},
    { 1056, 680, -320},
    { 936, 520, -264},
    { 1088, 416, -320},
    { 1280, 344, -272},
    { 1264, 208, -200},
    { 1216, 96, -112},
    { 1240, 88, -136},
    { 1352, 128, -168},
    { 1312, 48, -56},
    { 1096, 104, -128},
    { 1184, 0, -152},
    // 6 seconds
    { 952, -272, -24},
    { 936, -336, 8},
    { 984, -304, 80},
    { 960, -144, -112},
    { 1160, -96, -176},
    { 1224, -8, -232},
    { 1096, 0, -232},
    { 976, 16, -304},
    { 1032, 56, -360},
    { 1128, 80, -344},
    { 1192, 208, -408},
    { 1088, 240, -456},
    { 1336, 264, -488},
    { 1176, 360, -432},
    { 1120, 456, -448},
    { 1184, 488, -472},
    { 1008, 384, -424},
    { 1224, 312, -368},
    { 1368, 216, -232},
    { 1336, 112, -120},
    { 1136, 24, -104},
    { 1128, 48, -128},
    { 1224, 104, -152},
    { 1192, 72, -40},
    { 1008, 24, -56},
    // 7 seconds
    { 1176, -64, -56},
    { 928, -264, -16},
    { 928, -312, -24},
    { 1040, -192, -24},
    { 960, -96, -160},
    { 1160, -32, -264},
    { 1280, -64, -296},
    { 1128, -32, -224},
    { 976, 128, -232},
    { 944, 144, -248},
    { 1000, 200, -168},
    { 1072, 296, -176},
    { 1104, 376, -192},
    { 1392, 464, -184},
    { 1240, 688, -104},
    { 1440, 912, -200},
    { 1176, 560, -256},
    { 968, 488, -264},
    { 1048, 456, -320},
    { 1296, 336, -200},
    { 1248, 136, -56},
    { 1088, 72, -16},
    { 1120, 96, -104},
    { 1248, 120, -120},
    { 1224, 64, 8},
    // 8 seconds
    { 1120, 128, -72},
    { 1096, 72, -184},
    { 848, -160, -80},
    { 936, -256, -88},
    { 984, -208, -56},
    { 1048, -24, -200},
    { 1248, 8, -248},
    { 1208, 40, -296},
    { 944, 24, -288},
    { 832, 48, -288},
    { 936, 160, -296},
    { 1032, 200, -272},
    { 1232, 272, -264},
    { 1360, 344, -272},
    { 1544, 424, -280},
    { 1224, 632, -264},
    { 1184, 568, -440},
    { 1048, 520, -400},
    { 912, 384, -352},
    { 1104, 360, -344},
    { 1320, 272, -248},
    { 1216, 168, -128},
    { 1152, 80, -136},
    { 1216, 72, -120},
    { 1312, 104, -136},
    // 9 seconds
    { 1240, 104, -40},
    { 984, -16, -8},
    { 1048, -128, -144},
    { 872, -208, -72},
    { 1080, -336, 0},
    { 1144, -216, -16},
    { 1096, -96, -184},
    { 1232, -64, -288},
    { 1144, -48, -328},
    { 872, -32, -352},
    { 784, 48, -416},
    { 872, 0, -344},
    { 1032, 168, -320},
    { 1144, 216, -312},
    { 1368, 288, -312},
    { 1440, 472, -344},
    { 1048, 464, -320},
    { 1320, 480, -376},
    { 992, 432, -416},
    { 1080, 376, -408},
    { 1232, 288, -320},
    { 1288, 128, -200},
    { 1120, 80, -184},
    { 1104, 16, -208},
    { 1192, 32, -208},
    // 10 seconds
    { 1200, 32, -176},
    { 1096, 24, -136},
    { 1176, -8, -224},
    { 1000, -224, -224},
    { 848, -360, -216},
    { 1056, -256, -72},
    { 992, -168, -200},
    { 1112, -96, -264},
    { 1192, -24, -272},
    { 976, -8, -288},
    { 824, 48, -304},
    { 864, 96, -240},
    { 1072, 152, -232},
    { 1128, 208, -216},
    { 1208, 256, -280},
    { 1576, 432, -320},
    { 1264, 600, -320},
    { 1424, 544, -456},
    { 1176, 440, -392},
    { 960, 368, -400},
    { 1072, 408, -416},
    { 1320, 400, -344},
    { 1208, 248, -160},
    { 1112, 32, -16},
    { 1200, 152, -104},
    // 11 seconds
    { 1352, 200, -128},
    { 1312, 88, -8},
    { 1120, 48, -152},
    { 1232, -88, -312},
    { 872, -408, -96},
    { 1008, -304, -144},
    { 936, -216, -64},
    { 888, -48, -176},
    { 1064, 56, -200},
    { 1176, 56, -280},
    { 1016, 80, -280},
    { 872, 80, -240},
    { 920, 176, -256},
    { 1016, 224, -272},
    { 1112, 288, -384},
    { 1096, 304, -408},
    { 1384, 488, -472},
    { 1328, 672, -456},
    { 1048, 536, -440},
    { 1272, 528, -352},
    { 936, 424, -312},
    { 1032, 408, -368},
    { 1256, 400, -304},
    { 1392, 168, -56},
    { 1120, 0, 16},
    // 12 seconds
    { 1064, 152, -168},
    { 1184, 152, -160},
    { 1216, 120, -40},
    { 1032, -16, -88},
    { 1136, -96, -120},
    { 960, -280, -56},
    { 832, -320, -88},
    { 1112, -216, 24},
    { 1048, -48, -168},
    { 1192, 8, -224},
    { 1216, -8, -224},
    { 1056, 72, -296},
    { 816, 64, -272},
    { 888, 80, -304},
    { 1016, 136, -336},
    { 1136, 200, -376},
    { 1200, 264, -400},
    { 1440, 376, -400},
    { 1240, 512, -392},
    { 1400, 424, -352},
    { 1168, 432, -376},
    { 936, 328, -360},
    { 1080, 304, -360},
    { 1296, 264, -280},
    { 1232, 40, -112},
    // 13 seconds
    { 1048, 48, -128},
    { 1080, 112, -168},
    { 1200, 72, -104},
    { 1248, 72, -96},
    { 1088, -16, -88},
    { 1200, -176, -104},
    { 848, -344, -24},
    { 1008, -256, -24},
    { 960, -208, 48},
    { 1048, -56, -208},
    { 1264, -48, -280},
    { 1304, -24, -280},
    { 992, 24, -288},
    { 824, 88, -312},
    { 888, 96, -328},
    { 992, 112, -328},
    { 1048, 184, -384},
    { 1152, 248, -408},
    { 1456, 432, -416},
    { 1152, 528, -400},
    { 1416, 456, -416},
    { 1152, 360, -384},
    { 1040, 296, -368},
    { 1184, 224, -280},
    { 1336, 176, -200},
    // 14 seconds
    { 1136, 136, -208},
    { 1000, 128, -200},
    { 1120, 136, -248},
    { 1272, 136, -192},
    { 1200, 104, -152},
    { 1056, 24, -176},
    { 1040, -72, -128},
    { 736, -232, -104},
    { 944, -160, -72},
    { 944, -128, -96},
    { 1032, 0, -256},
    { 1304, -8, -280},
    { 1256, 104, -312},
    { 912, 104, -336},
    { 824, 88, -320},
    { 976, 104, -264},
    { 1088, 264, -240},
    { 1128, 328, -256},
    { 1272, 384, -264},
    { 1408, 568, -288},
    { 1016, 624, -256},
    { 1264, 600, -312},
    { 976, 576, -264},
    { 992, 448, -240},
    { 1216, 448, -232},
    // 15 seconds
    { 1432, 368, -136},
    { 1232, 240, -56},
    { 1096, 144, -56},
    { 1104, 104, -32},
    { 1112, 96, -40},
    { 1072, 56, -8},
    { 1048, 88, -32},
    { 1096, 96, -16},
    { 872, 64, -64},
    { 1112, 112, -144},
    { 864, 88, -184},
    { 888, 32, -312},
    { 1088, 112, -416},
    { 1008, 80, -312},
    { 776, 80, -280},
    { 792, 160, -400},
    { 912, 240, -448},
    { 1064, 280, -360},
    { 1088, 328, -336},
    { 1256, 464, -352},
    { 1240, 520, -264},
    { 1224, 576, -400},
    { 1128, 672, -408},
    { 848, 520, -352},
    { 960, 440, -288},
    // 16 seconds
    { 1200, 408, -280},
    { 1088, 312, -152},
    { 976, 160, -96},
    { 984, 152, -136},
    { 1080, 160, -136},
    { 1104, 160, -176},
    { 1032, 104, -16},
    { 1064, 0, -24},
    { 960, -80, -64},
    { 1088, -136, -88},
    { 1160, -120, -32},
    { 1152, 8, -288},
    { 1208, -24, -280},
    { 1136, 8, -256},
    { 832, 40, -312},
    { 672, 80, -304},
    { 696, 64, -280},
    { 808, 136, -280},
    { 936, 200, -240},
    { 1008, 248, -264},
    { 1320, 312, -408},
    { 1184, 376, -328},
    { 1128, 440, -456},
    { 1304, 488, -552},
    { 1000, 384, -448},
    // 17 seconds
    { 1056, 352, -432},
    { 1328, 304, -304},
    { 1264, 176, -88},
    { 1000, 40, -80},
    { 992, 96, -136},
    { 1072, 112, -152},
    { 1040, 56, 16},
    { 896, 64, -24},
    { 1072, 56, -88},
    { 856, -40, -96},
    { 1120, -88, -72},
    { 1080, -8, -24},
    { 992, 104, -248},
    { 1160, 96, -280},
    { 1160, 88, -448},
    { 808, 56, -456},
    { 696, 72, -392},
    { 800, 88, -328},
    { 1000, 224, -248},
    { 1072, 264, -256},
    { 1168, 320, -304},
    { 1392, 416, -280},
    { 1144, 488, -248},
    { 1304, 568, -384},
    { 1040, 488, -416},
    // 18 seconds
    { 1008, 376, -368},
    { 1144, 320, -312},
    { 1328, 192, -168},
    { 1080, 88, -96},
    { 864, 88, -72},
    { 952, 160, -184},
    { 1136, 120, -128},
    { 1216, 192, -112},
    { 936, -16, 112},
    { 1048, -152, 32},
    { 896, -248, 120},
    { 1280, -224, 248},
    { 1224, -136, -48},
    { 1256, -88, -168},
    { 1264, -8, -120},
    { 1064, 48, -288},
    { 752, 48, -320},
    { 792, 40, -344},
    { 896, 112, -264},
    { 1000, 176, -248},
    { 1080, 216, -304},
    { 1288, 320, -360},
    { 1248, 408, -312},
    { 984, 424, -240},
    { 1328, 408, -432},
    // 19 seconds
    { 1160, 416, -488},
    { 1224, 368, -360},
    { 1360, 232, -320},
    { 1320, 120, -88},
    { 1064, 0, -32},
    { 920, 80, -88},
    { 1000, 128, -104},
    { 1120, 168, -152},
    { 1032, 120, -16},
    { 1240, 120, 16},
    { 1104, 40, 8},
    { 912, -48, 16},
    { 1096, -72, 112},
    { 968, 32, -56},
    { 1120, 40, -184},
    { 1120, 80, -168},
    { 960, 104, -176},
    { 752, 152, -256},
    { 760, 144, -280},
    { 976, 120, -312},
    { 1176, 128, -408},
    { 1160, 248, -520},
    { 1392, 408, -584},
    { 1384, 608, -344},
    { 992, 448, -432},
    // 20 seconds
    { 1280, 496, -432},
    { 976, 352, -312},
    { 1000, 328, -304},
    { 1088, 288, -264},
    { 1120, 200, -136},
    { 936, 168, -96},
    { 944, 160, -120},
    { 1112, 168, -112},
    { 1256, 144, -40},
    { 1168, 104, 8},
    { 1160, 104, -80},
    { 1144, -8, 0},
    { 960, -56, -72},
    { 1000, -72, 0},
    { 968, -24, -248},
    { 928, -8, -376},
    { 1040, 72, -408},
    { 928, 88, -336},
    { 728, 80, -304},
    { 720, 144, -352},
    { 840, 160, -384},
    { 1000, 176, -352},
    { 1096, 152, -344},
    { 1280, 184, -376},
    { 1424, 360, -272},
    // 21 seconds
    { 1256, 448, -496},
    { 1416, 504, -528},
    { 1008, 344, -472},
    { 984, 264, -360},
    { 1128, 176, -312},
    { 1192, 128, -168},
    { 968, 24, -96},
    { 928, 88, -144},
    { 1056, 104, -168},
    { 1152, 112, -96},
    { 1072, 88, -40},
    { 1008, 56, -56},
    { 1112, 64, -72},
    { 960, -40, -80},
    { 1120, -152, 16},
    { 952, -160, -120},
    { 1088, -104, -272},
    { 1224, -64, -232},
    { 1080, -8, -256},
    { 792, 32, -288},
    { 744, 56, -344},
    { 848, 88, -312},
    { 984, 120, -248},
    { 1104, 224, -240},
    { 1184, 240, -272},
    // 22 seconds
    { 1392, 344, -376},
    { 1056, 504, -304},
    { 1392, 568, -616},
    { 1144, 440, -480},
    { 920, 304, -448},
    { 1008, 304, -416},
    { 1128, 256, -288},
    { 1056, 216, -216},
    { 1040, 88, -104},
    { 1160, 120, -144},
    { 1320, 136, -152},
    { 1248, 72, -56},
    { 1072, -80, 0},
    { 1104, -288, -24},
    { 864, -328, 24},
    { 1432, -280, 72},
    { 1272, -112, -24},
    { 1256, -16, -112},
    { 1200, -8, -160},
    { 1008, 32, -232},
    { 808, 48, -224},
    { 840, 72, -232},
    { 1000, 160, -168},
    { 1128, 296, -216},
    { 1080, 328, -288},
    // 23 seconds
    { 1240, 432, -368},
    { 1304, 656, -368},
    { 920, 608, -440},
    { 1184, 616, -432},
    { 1048, 472, -408},
    { 1184, 392, -376},
    { 1384, 344, -272},
    { 1528, 288, -168},
    { 1392, 168, -24},
    { 1232, 80, -8},
    { 1232, 160, -136},
    { 1232, 120, -64},
    { 1088, 56, 8},
    { 1072, 24, -64},
    { 1112, -64, -48},
    { 840, -192, -96},
    { 1128, -232, 8},
    { 1072, -176, -48},
    { 1096, -8, -224},
    { 1200, 8, -200},
    { 1184, 64, -232},
    { 1008, 104, -248},
    { 1000, 128, -312},
    { 1104, 160, -296},
    { 1184, 216, -200},
    // 24 seconds
    { 1352, 352, -240},
    { 1280, 360, -288},
    { 1344, 496, -360},
    { 952, 640, -440},
    { 1264, 592, -496},
    { 1080, 520, -480},
    { 1136, 408, -424},
    { 1272, 336, -368},
    { 1352, 248, -240},
    { 1304, 184, -184},
    { 1312, 40, -104},
    { 1384, 136, -136},
    { 1400, 104, -176},
    { 1176, 80, -80},
    { 1208, -40, -32},
    { 1024, -272, 40},
    { 720, -336, 0},
    { 1048, -256, 176},
    { 1216, -72, -72},
    { 1208, -32, -200},
    { 1312, 8, -208},
    { 1168, 40, -272},
    { 976, 96, -352},
    { 984, 80, -344},
    { 1104, 152, -368},
    // 25 seconds
    { 1200, 264, -384},
    { 1072, 384, -408},
    { 1248, 400, -424},
    { 1256, 472, -400},
    { 1064, 408, -344},
    { 1192, 480, -392},
    { 1032, 440, -416},
    { 1120, 384, -352},
    { 1248, 288, -280},
    { 1232, 184, -200},
    { 1120, 136, -128},
    { 1152, 120, -144},
    { 1304, 104, -160},
    { 1288, 64, -72},
    { 1072, 8, -80},
    { 1104, -128, -104},
    { 976, -288, -8},
    { 888, -288, -88},
    { 1128, -232, 96},
    { 1192, -48, -184},
    { 1312, 16, -232},
    { 1336, 32, -264},
    { 1072, 32, -296},
    { 848, 80, -320},
    { 880, 200, -360},
    // 26 seconds
    { 976, 224, -272},
    { 1080, 272, -248},
    { 1192, 392, -328},
    { 1464, 408, -248},
    { 1168, 632, -264},
    { 1216, 584, -352},
    { 1128, 576, -336},
    { 968, 464, -328},
    { 1120, 392, -312},
    { 1336, 320, -256},
    { 1328, 232, -152},
    { 1264, 120, -104},
    { 1280, 120, -104},
    { 1328, 128, -176},
    { 1248, 64, -96},
    { 1024, 0, -72},
    { 976, -72, -136},
    { 888, -224, -64},
    { 840, -280, -112},
    { 1136, -200, -40},
    { 1160, -56, -240},
    { 1304, -8, -264},
    { 1328, 24, -288},
    { 1064, 160, -328},
    { 848, 160, -328},
    // 27 seconds
    { 904, 160, -248},
    { 1040, 248, -232},
    { 1136, 280, -192},
    { 1272, 328, -200},
    { 1352, 360, -224},
    { 1152, 536, -240},
    { 1168, 616, -376},
    { 1048, 616, -416},
    { 968, 448, -360},
    { 1168, 400, -352},
    { 1376, 352, -312},
    { 1216, 216, -176},
    { 1184, 128, -112},
    { 1200, 112, -128},
    { 1264, 96, -152},
    { 1224, 56, -88},
    { 1040, 24, -80},
    { 1104, -40, -96},
    { 968, -144, -24},
    { 1024, -192, -104},
    { 1112, -192, 16},
    { 1064, -48, -208},
    { 1152, -40, -248},
    { 1176, 0, -232},
    { 1000, 64, -280},
    // 28 seconds
    { 864, 88, -312},
    { 920, 80, -280},
    { 1032, 136, -240},
    { 1160, 256, -272},
    { 1072, 256, -312},
    { 1216, 352, -400},
    { 1304, 488, -432},
    { 1016, 448, -416},
    { 1184, 432, -408},
    { 1016, 376, -424},
    { 1128, 328, -392},
    { 1272, 288, -304},
    { 1344, 200, -200},
    { 1160, 120, -112},
    { 1096, 120, -136},
    { 1192, 104, -136},
    { 1240, 64, -56},
    { 1104, 56, -88},
    { 1160, 0, -88},
    { 1088, -152, -8},
    { 832, -272, -48},
    { 1104, -248, 72},
    { 976, -96, -72},
    { 976, 0, -216},
    { 1096, 0, -224},
    // 29 seconds
    { 1152, 88, -272},
    { 992, 224, -344},
    { 912, 160, -264},
    { 1048, 224, -280},
    { 1144, 264, -320},
    { 1128, 312, -352},
    { 1184, 336, -384},
    { 1264, 432, -408},
    { 1064, 480, -328},
    { 1288, 528, -456},
    { 1016, 424, -424},
    { 1040, 344, -400},
    { 1176, 320, -320},
    { 1280, 240, -208},
    { 1128, 104, -80},
    { 1104, 128, -136},
    { 1288, 128, -152},
    { 1368, 112, -56},
    { 1120, 80, -40},
    { 1152, 40, -56},
    { 1080, -184, 24},
    { 824, -248, 16},
    { 1120, -312, 144},
    { 1080, -128, -80},
    { 1120, 0, -160},
    // 30 seconds
    { 1144, -24, -232},
    { 1096, 48, -272},
    { 912, 88, -336},
    { 920, 72, -384},
    { 1032, 112, -360},
    { 1144, 272, -368},
    { 1112, 336, -368},
    { 1248, 400, -352},
    { 1320, 504, -360},
    { 968, 456, -232},
    { 1192, 480, -304},
    { 1008, 480, -352},
    { 1056, 400, -352},
    { 1160, 336, -296},
    { 1248, 216, -184},
    { 1120, 176, -144},
    { 1120, 136, -168},
    { 1240, 112, -136},
    { 1328, 72, -104},
    { 1120, 8, -80},
    { 1200, -136, -136},
    { 1064, -336, 32},
    { 872, -304, -56},
    { 1088, -272, 128},
    { 1088, -64, -176},
    // 31 seconds
    { 1128, -16, -208},
    { 1184, 32, -280},
    { 1024, 56, -288},
    { 880, 96, -312},
    { 912, 104, -304},
    { 1032, 128, -328},
    { 1088, 216, -304},
    { 1024, 296, -304},
    { 1320, 408, -328},
    { 1248, 464, -216},
    { 1248, 432, -192},
    { 1248, 512, -264},
    { 968, 456, -272},
    { 984, 400, -264},
    { 1208, 376, -240},
    { 1216, 232, -112},
    { 1016, 72, 24},
    { 976, 40, -48},
    { 1120, 80, -152},
    { 1152, 80, -56},
    { 1032, 40, 32},
    { 1232, 32, -80},
    { 944, -136, 48},
    { 1152, -264, -8},
    { 1144, -192, 104},
    // 32 seconds
    { 1208, -24, -152},
    { 1296, 64, -232},
    { 1184, 112, -384},
    { 776, 120, -384},
    { 632, 112, -392},
    { 712, 128, -416},
    { 872, 184, -312},
    { 1032, 256, -336},
    { 1184, 400, -312},
    { 1328, 536, -248},
    { 1016, 584, -192},
    { 1312, 560, -296},
    { 1016, 464, -248},
    { 1072, 400, -216},
    { 1248, 352, -192},
    { 1272, 288, -112},
    { 1008, 184, -96},
    { 928, 160, -144},
    { 1008, 144, -168},
    { 1096, 104, -136},
    { 1048, 48, -128},
    { 1104, -24, -200},
    { 1136, -160, -200},
    { 768, -328, -176},
    { 1352, -232, -168},
    // 33 seconds
    { 1232, -80, -144},
    { 1216, 16, -160},
    { 1248, 104, -304},
    { 1128, 120, -272},
    { 960, 112, -176},
    { 984, 176, -144},
    { 1104, 272, -96},
    { 1144, 376, -128},
    { 1096, 416, -176},
    { 1176, 536, -184},
    { 1168, 712, -256},
    { 1152, 744, -208},
    { 1104, 680, -216},
    { 992, 536, -304},
    { 1168, 456, -240},
    { 1464, 408, -208},
    { 1608, 264, -120},
    { 1440, 168, -24},
    { 1360, 152, -24},
    { 1312, 144, -112},
    { 1280, 112, -88},
    { 1192, 64, -8},
    { 1072, -48, 8},
    { 960, -144, -64},
    { 752, -248, -144},
    // 34 seconds
    { 1072, -328, 48},
    { 1008, -176, -80},
    { 1160, -16, -96},
    { 1288, 32, -200},
    { 1256, 136, -224},
    { 1096, 168, -224},
    { 1152, 232, -264},
    { 1224, 272, -200},
    { 1352, 352, -192},
    { 1232, 472, -224},
    { 1368, 528, -240},
    { 1224, 656, -128},
    { 928, 608, -176},
    { 1128, 696, -208},
    { 920, 528, -224},
    { 1024, 448, -184},
    { 1264, 352, -176},
    { 1392, 256, -104},
    { 1272, 168, -32},
    { 1336, 136, -72},
    { 1488, 152, -88},
    { 1416, 88, -64},
    { 1216, 32, -40},
    { 1160, -112, -80},
    { 968, -336, 8},
    // 35 seconds
    { 952, -392, -72},
    { 1048, -384, 72},
    { 1136, -56, -176},
    { 1256, -16, -144},
    { 1400, 80, -320},
    { 1200, 136, -336},
    { 992, 144, -328},
    { 1024, 224, -344},
    { 1072, 312, -312},
    { 1024, 424, -280},
    { 1096, 456, -288},
    { 1336, 440, -224},
    { 1136, 472, -144},
    { 1160, 528, -152},
    { 1144, 560, -216},
    { 1016, 488, -232},
    { 1144, 384, -184},
    { 1360, 320, -144},
    { 1360, 200, -80},
    { 1192, 96, -56},
    { 1200, 72, -88},
    { 1256, 96, -184},
    { 1208, 40, -88},
    { 920, -80, -16},
    { 1016, -144, -112},
    // 36 seconds
    { 848, -320, -56},
    { 928, -296, 0},
    { 1192, -216, -16},
    { 1232, -8, -128},
    { 1400, 40, -200},
    { 1344, 96, -272},
    { 1072, 128, -272},
    { 912, 184, -264},
    { 944, 224, -192},
    { 1096, 272, -184},
    { 1128, 328, -192},
    { 1152, 312, -192},
    { 1288, 432, -224},
    { 1032, 544, -152},
    { 1368, 656, -296},
    { 1040, 568, -328},
    { 1056, 392, -272},
    { 1224, 344, -248},
    { 1352, 248, -240},
    { 1352, 184, -80},
    { 1192, -16, -8},
    { 1160, 16, 0},
    { 1248, 136, -224},
    { 1176, 96, -80},
    { 1048, -72, 8},
    // 37 seconds
    { 1120, -144, 8},
    { 752, -224, -64},
    { 1184, -320, 152},
    { 1208, -112, -136},
    { 1240, -40, -144},
    { 1384, 80, -240},
    { 1224, 160, -280},
    { 944, 192, -288},
    { 920, 216, -304},
    { 1016, 296, -232},
    { 1056, 320, -200},
    { 984, 360, -224},
    { 1192, 384, -232},
    { 1216, 496, -240},
    { 960, 552, -240},
    { 1248, 616, -288},
    { 1024, 480, -296},
    { 1136, 368, -280},
    { 1320, 328, -248},
    { 1456, 272, -152},
    { 1240, 24, -16},
    { 1104, 96, 0},
    { 1192, 128, -176},
    { 1224, 96, -96},
    { 968, -24, 24},
    // 38 seconds
    { 1056, -40, -80},
    { 968, -184, -8},
    { 832, -192, -56},
    { 1192, -224, 64},
    { 1152, -72, -96},
    { 1272, 0, -144},
    { 1352, 48, -192},
    { 1152, 112, -240},
    { 928, 120, -272},
    { 992, 144, -240},
    { 1104, 200, -200},
    { 1152, 264, -216},
    { 1120, 296, -264},
    { 1352, 472, -360},
    { 1168, 624, -384},
    { 1096, 520, -360},
    { 1184, 472, -368},
    { 1000, 376, -320},
    { 1216, 336, -296},
    { 1416, 272, -200},
    { 1480, 184, -88},
    { 1312, 40, -56},
    { 1248, 64, -16},
    { 1304, 136, -176},
    { 1168, 32, -32},
    // 39 seconds
    { 976, 16, -8},
    { 976, -72, -48},
    { 880, -224, 32},
    { 736, -240, -48},
    { 1128, -256, 56},
    { 1136, -64, -104},
    { 1296, 40, -160},
    { 1416, 56, -240},
    { 1256, 128, -272},
    { 1032, 152, -264},
    { 1056, 208, -240},
    { 1112, 264, -208},
    { 1192, 320, -232},
    { 1136, 312, -256},
    { 1336, 400, -296},
    { 1112, 536, -280},
    { 1152, 528, -360},
    { 1152, 464, -352},
    { 984, 336, -320},
    { 1168, 304, -280},
    { 1400, 240, -200},
    { 1352, 168, -112},
    { 1200, 40, -80},
    { 1184, 88, -72},
    { 1280, 136, -160},
    // 40 seconds
    { 1208, 72, -16},
    { 1104, 40, -24},
    { 1184, -32, -80},
    { 864, -216, 48},
    { 1032, -240, 0},
    { 1016, -160, 16},
    { 1008, -48, -96},
    { 1200, 16, -160},
    { 1232, 56, -224},
    { 1064, 104, -280},
    { 928, 96, -296},
    { 984, 80, -320},
    { 1120, 136, -312},
    { 1104, 240, -344},
    { 1064, 288, -360},
    { 1360, 392, -400},
    { 1064, 464, -312},
    { 1096, 376, -352},
    { 1168, 392, -360},
    { 1056, 328, -288},
    { 1192, 280, -256},
    { 1360, 224, -160},
    { 1240, 136, -88},
    { 1144, 104, -72},
    { 1216, 72, -56},
    // 41 seconds
    { 1280, 80, -88},
    { 1136, 32, -48},
    { 848, -40, -48},
    { 1096, -152, -72},
    { 800, -264, -40},
    { 1048, -272, 24},
    { 1136, -168, -24},
    { 1160, -16, -136},
    { 1344, 8, -152},
    { 1288, 56, -232},
    { 1000, 64, -240},
    { 888, 136, -232},
    { 968, 200, -232},
    { 1088, 240, -144},
    { 1112, 288, -184},
    { 1216, 288, -224},
    { 1392, 432, -240},
    { 1192, 648, -264},
    { 1376, 592, -352},
    { 968, 432, -296},
    { 1088, 368, -312},
    { 1264, 296, -224},
    { 1392, 208, -136},
    { 1192, 24, 56},
    { 1048, 24, -8},
    // 42 seconds
    { 1208, 168, -168},
    { 1280, 120, -88},
    { 1136, 0, 56},
    { 1112, 8, -40},
    { 1072, -88, 0},
    { 704, -216, 16},
    { 1144, -232, 72},
    { 1000, -136, -48},
    { 992, -8, -144},
    { 1232, 24, -208},
    { 1232, 88, -288},
    { 1032, 96, -224},
    { 1000, 136, -280},
    { 1088, 168, -344},
    { 1176, 232, -336},
    { 1088, 352, -320},
    { 1008, 408, -320},
    { 1248, 440, -304},
    { 1032, 440, -160},
    { 1288, 480, -248},
    { 1176, 456, -216},
    { 936, 368, -192},
    { 1168, 344, -168},
    { 1392, 320, -120},
    { 1240, 216, -32},
    // 43 seconds
    { 1096, 112, -8},
    { 1128, 88, -24},
    { 1216, 104, -32},
    { 1208, 88, -40},
    { 920, 8, 0},
    { 1136, 0, -128},
    { 848, -176, -72},
    { 1000, -216, -128},
    { 1168, -112, -72},
    { 1040, -56, -96},
    { 1152, 80, -192},
    { 1144, 120, -192},
    { 992, 152, -184},
    { 928, 168, -168},
    { 1080, 136, -120},
    { 1304, 200, -72},
    { 1344, 320, -112},
    { 1072, 376, -160},
    { 1136, 496, -272},
    { 1080, 600, -248},
    { 1072, 544, -208},
    { 1304, 520, -232},
    { 992, 392, -184},
    { 1064, 336, -192},
    { 1256, 328, -184},
    // 44 seconds
    { 1368, 272, -96},
    { 1280, 168, 40},
    { 1216, 16, 48},
    { 1152, 32, 8},
    { 1064, 88, -24},
    { 992, 96, 16},
    { 1024, 72, 80},
    { 1144, 96, 136},
    { 888, 144, 64},
    { 1112, 120, -56},
    { 1040, 48, 16},
    { 816, 72, -128},
    { 824, 8, -240},
    { 992, 0, -232},
    { 992, 16, -184},
    { 936, 24, -248},
    { 960, 64, -360},
    { 1064, 88, -568},
    { 1144, 96, -624},
    { 1056, 216, -536},
    { 976, 312, -424},
    { 1128, 520, -376},
    { 1192, 400, -232},
    { 1520, 400, -256},
    { 1200, 384, -136},
    // 45 seconds
    { 1280, 336, -104},
    { 1496, 344, -56},
    { 1312, 272, 24},
    { 1152, 176, 72},
    { 1216, 192, 56},
    { 1248, 128, 96},
    { 1240, 56, 160},
    { 1192, 104, 112},
    { 1096, 88, 120},
    { 1008, 72, 88},
    { 840, -8, 8},
    { 800, -152, 40},
    { 728, -112, -88},
    { 720, -72, -280},
    { 832, -136, -288},
    { 1184, -176, -424},
    { 1464, -48, -576},
    { 1264, -104, -456},
    { 1184, -16, -424},
    { 1176, 96, -576},
    { 1112, 184, -552},
    { 960, 232, -512},
    { 904, 240, -560},
    { 976, 768, -864},
    { 1232, 832, -592},
    // 46 seconds
    { 1288, 672, -312},
    { 1304, 904, -560},
    { 1480, 752, -504},
    { 1648, 1176, -320},
    { 2336, 1488, -352},
    { 2544, 1040, 96},
    { 1960, 400, 16},
    { 1304, 296, -56},
    { 904, 168, -56},
    { 584, -72, -48},
    { 400, -152, -144},
    { 264, -224, -256},
    { 328, -280, -672},
    { 464, -192, -872},
    { 384, -416, -944},
    { 216, -96, -1160},
    { 232, -208, -1120},
    { 336, -32, -1208},
    { 272, -144, -960},
    { 64, -264, -728},
    { -32, -248, -704},
    { -112, -384, -776},
    { -176, -344, -984},
    { -176, -304, -1056},
    { -200, -488, -1080},
    // 47 seconds
    { -104, -400, -1128},
    { -264, -392, -1096},
    { -296, -232, -1168},
    { -224, -144, -1200},
    { -264, -112, -1088},
    { -288, -144, -984},
    { -208, -136, -880},
    { -200, -176, -768},
    { -248, -176, -696},
    { -288, -224, -624},
    { -296, -304, -528},
    { -232, -312, -440},
    { -112, -352, -384},
    { 240, -296, -464},
    { 856, -208, -480},
    { 1456, -40, -272},
    { 1896, 344, -152},
    { 2240, 440, -256},
    { 2104, 280, -240},
    { 1808, 232, -152},
    { 1480, 208, -160},
    { 1144, 72, -264},
    { 1016, 104, -248},
    { 944, 64, -200},
    { 992, 216, -200},
    // 48 seconds
    { 1016, 256, -200},
    { 1136, 256, -272},
    { 1312, 360, -296},
    { 1352, 528, -320},
    { 1192, 824, -488},
    { 1024, 432, -384},
    { 1352, 384, -176},
    { 1720, 296, -104},
    { 1720, 128, 56},
    { 1440, 56, 88},
    { 1232, 48, 32},
    { 1152, 96, -16},
    { 1056, 64, 8},
    { 1088, 48, 24},
    { 1016, -32, -64},
    { 1192, -80, -8},
    { 800, -280, 104},
    { 800, -272, -48},
    { 1056, -136, -32},
    { 1016, -16, -120},
    { 1256, -64, -152},
    { 1440, -112, -8},
    { 1528, 48, -40},
    { 1320, 208, -112},
    { 1216, 360, -200},
    // 49 seconds
    { 1128, 376, -208},
    { 1144, 344, -240},
    { 1072, 304, -216},
    { 1232, 360, -208},
    { 1216, 552, -160},
    { 944, 688, -136},
    { 1336, 760, -280},
    { 1192, 488, -168},
    { 1440, 440, -72},
    { 1752, 384, -64},
    { 1776, 224, 56},
    { 1480, -120, 160},
    { 1256, -64, 56},
    { 1280, 128, -176},
    { 1240, 96, -40},
    { 936, -96, 64},
    { 984, -88, 8},
    { 784, -200, 40},
    { 608, -320, 56},
    { 1000, -192, 72},
    { 1232, 8, -208},
    { 1392, -88, -80},
    { 1824, -40, 0},
    { 1552, 128, -136},
    { 1144, 240, -256},
    // 50 seconds
    { 1096, 304, -208},
    { 1080, 240, -88},
    { 1224, 272, -56},
    { 1136, 272, -80},
    { 1296, 360, -32},
    { 1240, 664, 72},
    { 856, 936, -64},
    { 1368, 488, -104},
    { 1064, 448, -144},
    { 1312, 488, -112},
    { 1496, 424, -72},
    { 1672, 344, -48},
    { 1656, 200, 144},
    { 1472, -152, 160},
    { 1328, -112, 56},
    { 1296, 160, -112},
    { 1144, 64, 24},
    { 992, -80, 88},
    { 1008, -64, 64},
    { 608, -128, 48},
    { 744, -264, 136},
    { 1000, -64, 16},
    { 1128, 48, -184},
    { 1408, -56, -96},
    { 1624, -56, -72},
    // 51 seconds
    { 1384, 64, -208},
    { 1144, 152, -288},
    { 1184, 216, -272},
    { 1168, 248, -80},
    { 1248, 320, -136},
    { 1128, 312, -112},
    { 1320, 400, -104},
    { 1048, 576, 96},
    { 920, 632, -112},
    { 1280, 624, -112},
    { 1176, 480, -112},
    { 1280, 456, -72},
    { 1560, 400, -32},
    { 1584, 224, -32},
    { 1488, 128, 160},
    { 1392, -104, 72},
    { 1264, -112, 32},
    { 1184, 200, -96},
    { 952, 56, 40},
    { 1088, -152, 112},
    { 808, -168, 104},
    { 520, -128, 16},
    { 976, -216, 184},
    { 1072, 16, -8},
    { 1296, 48, -64},
    // 52 seconds
    { 1856, -48, -32},
    { 1776, 176, -160},
    { 1280, 272, -288},
    { 1048, 216, -304},
    { 1112, 144, -248},
    { 1104, 208, -104},
    { 1104, 304, -160},
    { 1216, 432, -176},
    { 1176, 608, -40},
    { 840, 664, -168},
    { 1560, 688, -208},
    { 1184, 432, -176},
    { 1368, 408, -96},
    { 1736, 360, -40},
    { 1672, 224, -16},
    { 1448, 104, 144},
    { 1280, -40, 80},
    { 1224, 8, -32},
    { 1136, 112, -40},
    { 920, 16, 8},
    { 1064, -88, 0},
    { 936, -216, 16},
    { 456, -320, 16},
    { 1224, -176, 8},
    { 1240, -48, -64},
    // 53 seconds
    { 1640, 24, -120},
    { 2064, 96, -200},
    { 1552, 192, -224},
    { 1168, 184, -136},
    { 1264, 248, -248},
    { 1400, 280, -176},
    { 1392, 336, -16},
    { 1232, 504, -64},
    { 992, 616, -192},
    { 800, 464, -176},
    { 928, 440, -184},
    { 1168, 632, -344},
    { 1160, 360, -288},
    { 1344, 224, -120},
    { 2016, 304, -104},
    { 2112, 232, 24},
    { 1968, 288, 160},
    { 1960, 416, 112},
    { 1848, 336, 240},
    { 1488, 336, 192},
    { 1136, 344, 56},
    { 776, 280, -80},
    { 552, 272, -352},
    { 392, 136, -504},
    { 280, -168, -568},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:17:39 local
AccelRawData *activity_sample_walk_100_pbl_25477_17(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25477_17
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 50
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -40, -152, -1024},
    { -24, -144, -1032},
    { -40, -136, -1040},
    { -48, -136, -1040},
    { -40, -144, -1040},
    { -48, -136, -1032},
    { -48, -136, -1032},
    { -64, -112, -1000},
    { -64, -120, -1008},
    { -56, -104, -1008},
    { -48, -112, -1016},
    { -32, -152, -1024},
    { -32, -136, -1024},
    { -56, -120, -1048},
    { -96, -112, -1040},
    { -120, -48, -1032},
    { -120, -88, -1032},
    { -104, -104, -1016},
    { -88, -104, -1008},
    { -80, -136, -1016},
    { -200, -232, -1104},
    { -40, -104, -1040},
    { -24, -120, -1032},
    { -40, -120, -1032},
    { -48, -96, -1040},
    // 1 seconds
    { -24, -128, -1032},
    { -40, -104, -1032},
    { 24, -40, -1072},
    { -96, -128, -1040},
    { -32, -96, -1056},
    { -24, -96, -1048},
    { -56, -112, -1032},
    { 8, -80, -1056},
    { -96, -88, -1024},
    { -80, -80, -1048},
    { -96, -88, -1056},
    { -96, -120, -1056},
    { -120, -128, -1016},
    { -136, -160, -1008},
    { -120, -112, -1040},
    { -80, -112, -1064},
    { -96, -136, -1048},
    { -96, -160, -1000},
    { -96, -200, -984},
    { -120, -224, -960},
    { -112, -240, -952},
    { -96, -248, -952},
    { -56, -248, -960},
    { 0, -256, -928},
    { 136, -344, -776},
    // 2 seconds
    { 368, -472, -608},
    { 624, -280, -448},
    { 904, 24, -312},
    { 1104, 304, -208},
    { 1360, 312, -16},
    { 1720, 504, 184},
    { 1840, 672, 448},
    { 1744, 712, 464},
    { 1464, 632, 232},
    { 1320, 528, 136},
    { 1200, 320, 216},
    { 1136, 248, 168},
    { 1160, 288, 168},
    { 1088, 344, 144},
    { 896, 432, 88},
    { 944, 528, 56},
    { 992, 648, 72},
    { 840, 704, 48},
    { 1056, 744, 88},
    { 912, 632, 80},
    { 872, 512, 80},
    { 1216, 424, 120},
    { 1640, 352, 144},
    { 1560, 192, 128},
    { 1456, 144, 96},
    // 3 seconds
    { 1408, 216, 56},
    { 1344, 136, 104},
    { 1208, 112, 88},
    { 1048, 112, 40},
    { 976, 112, -40},
    { 968, 72, -120},
    { 816, 144, -296},
    { 816, 48, -328},
    { 904, 0, -208},
    { 800, 80, -136},
    { 888, 240, -184},
    { 1224, 328, -280},
    { 1472, 280, -128},
    { 1200, 272, 24},
    { 1072, 368, -40},
    { 1080, 400, 8},
    { 1072, 448, 96},
    { 952, 456, 208},
    { 928, 472, 208},
    { 1096, 440, 368},
    { 952, 504, 696},
    { 1216, 640, 688},
    { 1104, 688, 792},
    { 1224, 544, 624},
    { 1416, 400, 728},
    // 4 seconds
    { 1752, 96, 784},
    { 1520, -32, 600},
    { 1376, 0, 552},
    { 1272, 16, 560},
    { 1120, 16, 616},
    { 968, 48, 552},
    { 808, 224, 544},
    { 776, 304, 416},
    { 536, 448, 576},
    { 416, 592, 336},
    { 344, 576, 776},
    { 288, 648, 656},
    { 248, 664, 776},
    { 152, 656, 728},
    { 8, 408, 840},
    { -112, 272, 768},
    { -200, 112, 720},
    { -280, 200, 608},
    { -416, 296, 776},
    { -552, 432, 824},
    { -744, 488, 984},
    { -656, 968, 1032},
    { -728, 1056, 744},
    { -568, 1360, 816},
    { -352, 1464, 416},
    // 5 seconds
    { -352, 808, 168},
    { -288, 664, -416},
    { -264, 360, -608},
    { -128, 280, -616},
    { -128, 104, -648},
    { -72, -80, -840},
    { -48, -216, -840},
    { -56, -216, -824},
    { -56, -288, -936},
    { 128, -352, -896},
    { 144, -392, -816},
    { 264, -224, -904},
    { 400, -104, -832},
    { 568, 16, -792},
    { 856, 272, -1008},
    { 792, 240, -848},
    { 664, 272, -656},
    { 664, 592, -736},
    { 560, 864, -848},
    { 432, 920, -928},
    { 160, 952, -1072},
    { -184, 1240, -1352},
    { -152, 1160, -1416},
    { -144, 1064, -1384},
    { 160, 992, -1144},
    // 6 seconds
    { 152, 872, -904},
    { 232, 784, -896},
    { 520, 696, -880},
    { 624, 432, -776},
    { 512, 112, -768},
    { 344, 64, -672},
    { 280, -24, -576},
    { 408, -96, -560},
    { 640, -128, -448},
    { 1016, -104, -336},
    { 1248, 24, -208},
    { 1416, 176, -56},
    { 1552, 184, -216},
    { 1656, 264, -296},
    { 1648, 232, -248},
    { 1368, 248, -248},
    { 1104, 296, -232},
    { 1152, 280, -272},
    { 1208, 312, -80},
    { 1256, 440, -64},
    { 1144, 584, -48},
    { 1136, 656, -56},
    { 1152, 824, -32},
    { 1088, 784, 24},
    { 1144, 672, -144},
    // 7 seconds
    { 872, 544, -192},
    { 1080, 488, -168},
    { 1440, 488, -144},
    { 1592, 240, -64},
    { 1392, 160, 32},
    { 1392, 72, -48},
    { 1456, 136, -80},
    { 1440, 160, -40},
    { 1208, 96, -112},
    { 1344, -56, -216},
    { 944, -416, -120},
    { 808, -480, -104},
    { 1168, -280, -136},
    { 936, -64, -168},
    { 1096, 32, -192},
    { 1296, 168, -272},
    { 1288, 208, -152},
    { 1240, 232, -112},
    { 1320, 312, -104},
    { 1376, 384, -40},
    { 1368, 528, -56},
    { 1168, 600, -112},
    { 1280, 760, -48},
    { 1016, 864, -64},
    { 736, 664, -96},
    // 8 seconds
    { 1160, 768, -176},
    { 912, 600, -208},
    { 1088, 504, -200},
    { 1368, 456, -184},
    { 1688, 288, -80},
    { 1560, 176, 32},
    { 1536, 120, -56},
    { 1592, 128, -88},
    { 1488, 88, 8},
    { 1208, 48, -144},
    { 1248, -112, -136},
    { 968, -296, -136},
    { 648, -336, -208},
    { 992, -344, -168},
    { 904, -192, -72},
    { 976, -8, -176},
    { 1200, 16, -240},
    { 1352, 16, -184},
    { 1384, 104, -112},
    { 1384, 256, -88},
    { 1480, 424, -80},
    { 1600, 536, -40},
    { 1456, 664, -40},
    { 1400, 776, 192},
    { 1240, 976, -32},
    // 9 seconds
    { 760, 808, -8},
    { 1208, 984, 120},
    { 888, 800, -112},
    { 1064, 624, -136},
    { 1592, 584, -160},
    { 1824, 496, -112},
    { 1712, 224, 64},
    { 1744, 48, 16},
    { 1680, 120, -104},
    { 1512, 56, -32},
    { 1288, 72, -56},
    { 1272, 24, -56},
    { 968, -120, 64},
    { 648, -208, 40},
    { 936, -184, 80},
    { 800, -96, -8},
    { 976, -88, -192},
    { 1280, -104, -224},
    { 1408, 72, -208},
    { 1336, 72, -192},
    { 1360, 200, -312},
    { 1536, 264, -552},
    { 1488, 400, -368},
    { 1368, 560, -416},
    { 1392, 688, -336},
    // 10 seconds
    { 1144, 768, -160},
    { 1088, 720, -48},
    { 936, 816, 112},
    { 944, 600, 240},
    { 1200, 664, 304},
    { 1568, 592, 288},
    { 1640, 584, 256},
    { 1592, 576, 232},
    { 1696, 704, 584},
    { 1792, 832, 536},
    { 1552, 880, 248},
    { 1272, 816, 200},
    { 1016, 656, -8},
    { 680, 328, -192},
    { 544, 64, -432},
    { 272, -144, -512},
    { 96, -280, -624},
    { 112, -712, -888},
    { 184, -656, -896},
    { 176, -528, -1056},
    { 32, -488, -960},
    { -48, -448, -920},
    { -120, -480, -872},
    { -160, -472, -848},
    { -248, -480, -832},
    // 11 seconds
    { -272, -520, -912},
    { -224, -488, -976},
    { -336, -504, -944},
    { -248, -280, -1248},
    { -296, -224, -1088},
    { -360, -216, -904},
    { -232, -176, -1032},
    { -152, -200, -976},
    { -136, -248, -864},
    { -144, -360, -824},
    { -104, -408, -792},
    { -16, -432, -712},
    { -16, -464, -624},
    { 104, -528, -464},
    { 256, -432, -296},
    { 536, -408, -96},
    { 1112, -24, 72},
    { 1840, 304, 184},
    { 2488, 584, 544},
    { 2624, 816, 968},
    { 1976, 1112, 352},
    { 1560, 576, -40},
    { 1520, 568, 184},
    { 1616, 344, 256},
    { 1432, 224, 256},
    // 12 seconds
    { 1080, 208, 216},
    { 1232, 408, 344},
    { 888, 680, 776},
    { 1208, 952, 280},
    { 736, 320, 56},
    { 816, 584, 160},
    { 1176, 672, 248},
    { 1624, 536, 208},
    { 1688, 376, 144},
    { 1824, 232, 80},
    { 1960, 144, -32},
    { 1792, 0, 80},
    { 1480, 88, 0},
    { 1168, 40, -72},
    { 1192, -144, 56},
    { 648, -432, 232},
    { 760, -384, 40},
    { 928, -128, -80},
    { 1120, -64, -176},
    { 1440, 8, -72},
    { 1456, 88, -168},
    { 1232, -64, -280},
    { 1160, 32, -248},
    { 1312, 72, -248},
    { 1400, 144, -112},
    // 13 seconds
    { 1456, 296, -96},
    { 1160, 344, -176},
    { 1432, 336, -232},
    { 1120, 464, -208},
    { 848, 576, -240},
    { 1176, 584, -264},
    { 1056, 416, -256},
    { 1048, 368, -232},
    { 1288, 328, -208},
    { 1472, 312, -160},
    { 1416, 208, 8},
    { 1472, -16, 96},
    { 1416, -104, 16},
    { 1360, 16, 8},
    { 1152, 200, -24},
    { 1016, 96, 56},
    { 1000, 24, 88},
    { 704, 112, -16},
    { 864, 80, -88},
    { 1008, -32, -88},
    { 856, -112, -280},
    { 768, -120, -184},
    { 1008, -56, -264},
    { 1216, 96, -352},
    { 1096, 112, -168},
    // 14 seconds
    { 1200, 152, -128},
    { 1328, 248, -72},
    { 1360, 312, -64},
    { 1168, 344, -112},
    { 912, 336, -24},
    { 1256, 424, -128},
    { 944, 448, -104},
    { 1024, 432, -80},
    { 1352, 464, -216},
    { 968, 368, -120},
    { 1080, 328, -112},
    { 1328, 352, -104},
    { 1528, 240, -64},
    { 1240, -8, 112},
    { 1080, -64, 80},
    { 936, -120, 32},
    { 952, 40, -56},
    { 840, 168, 0},
    { 888, 112, 48},
    { 1080, 152, -56},
    { 1040, 96, -72},
    { 1240, 48, -24},
    { 1032, 48, -120},
    { 848, 88, -240},
    { 1000, 120, -208},
    // 15 seconds
    { 1000, 96, -136},
    { 864, 24, -152},
    { 840, 248, -232},
    { 816, 160, -80},
    { 896, 200, -136},
    { 936, 200, -128},
    { 872, 200, -48},
    { 1128, 264, -144},
    { 1376, 440, -304},
    { 904, 392, -112},
    { 1368, 504, -272},
    { 1136, 424, -256},
    { 832, 256, -120},
    { 992, 296, -80},
    { 1240, 304, -64},
    { 1280, 224, -48},
    { 1072, 72, 8},
    { 976, -16, 24},
    { 952, 8, -32},
    { 968, 112, -80},
    { 944, 160, -56},
    { 1000, 40, -72},
    { 1208, 112, -168},
    { 936, -96, -168},
    { 1072, -248, -72},
    // 16 seconds
    { 1080, -152, -312},
    { 896, -8, -304},
    { 1088, -16, -248},
    { 1048, 96, -192},
    { 824, 104, -96},
    { 744, 136, -56},
    { 808, 192, -48},
    { 944, 216, -32},
    { 1064, 240, 0},
    { 1008, 304, -64},
    { 984, 328, -152},
    { 1400, 496, -320},
    { 872, 624, -40},
    { 1416, 464, -336},
    { 1216, 344, -304},
    { 960, 344, -184},
    { 1088, 392, -216},
    { 1376, 360, -136},
    { 1208, 136, 16},
    { 992, -24, 48},
    { 928, -80, 40},
    { 1016, -8, -24},
    { 1024, 104, 8},
    { 952, 96, 72},
    { 1024, 96, 40},
    // 17 seconds
    { 1016, 32, -72},
    { 856, 96, -280},
    { 1240, -40, -160},
    { 1008, -32, -216},
    { 856, 0, -320},
    { 1128, 8, -320},
    { 1064, 56, -256},
    { 816, 88, -184},
    { 800, 152, -160},
    { 856, 184, -112},
    { 944, 216, -72},
    { 1024, 232, -48},
    { 1000, 280, -16},
    { 1320, 328, -40},
    { 1384, 504, -120},
    { 936, 712, -88},
    { 1296, 400, -200},
    { 968, 376, -216},
    { 904, 360, -128},
    { 1128, 384, -136},
    { 1400, 352, -72},
    { 1216, 192, 48},
    { 1112, 32, 56},
    { 1080, -64, 64},
    { 1096, -8, -48},
    // 18 seconds
    { 1144, 216, -72},
    { 944, 8, 40},
    { 824, -128, 40},
    { 984, -48, -96},
    { 856, -88, -96},
    { 1152, -128, -184},
    { 1128, -128, -256},
    { 1024, -152, -264},
    { 1112, 8, -256},
    { 1096, 208, -304},
    { 944, 136, -216},
    { 880, 136, -144},
    { 912, 112, -80},
    { 960, 120, -32},
    { 1096, 176, 0},
    { 960, 248, -56},
    { 968, 328, -72},
    { 1392, 464, 0},
    { 984, 680, 48},
    { 1368, 488, -128},
    { 1008, 424, -144},
    { 944, 440, -128},
    { 1104, 424, -144},
    { 1328, 384, -48},
    { 1336, 192, 40},
    // 19 seconds
    { 1272, -32, 88},
    { 1216, -104, -72},
    { 1168, -128, -208},
    { 1072, 96, -8},
    { 984, 144, -16},
    { 1008, 64, -24},
    { 1064, 88, -144},
    { 768, 64, -192},
    { 1032, 8, -160},
    { 968, 8, -168},
    { 800, 24, -144},
    { 944, 40, -184},
    { 1224, 160, -240},
    { 1072, 216, -184},
    { 888, 200, -176},
    { 896, 232, -216},
    { 1040, 240, -200},
    { 1184, 272, -184},
    { 1032, 312, -192},
    { 1088, 400, -160},
    { 1184, 520, -16},
    { 936, 432, -104},
    { 1168, 344, -144},
    { 1240, 528, -160},
    { 920, 456, -128},
    // 20 seconds
    { 992, 376, -104},
    { 1296, 312, -56},
    { 1304, 152, 152},
    { 1112, -104, 64},
    { 1032, -80, 16},
    { 1104, -8, 0},
    { 1152, 136, 8},
    { 1168, 112, 32},
    { 1136, 128, -24},
    { 1080, 160, -240},
    { 928, -88, -200},
    { 896, -432, 72},
    { 704, -200, -288},
    { 688, -56, -256},
    { 1176, 0, -264},
    { 1208, 40, -304},
    { 1112, 0, -264},
    { 1160, 32, -272},
    { 1176, 152, -288},
    { 1096, 304, -424},
    { 1024, 416, -408},
    { 816, 472, -368},
    { 928, 424, -320},
    { 928, 424, -216},
    { 1624, 520, -248},
    // 21 seconds
    { 1424, 456, -136},
    { 1224, 312, -24},
    { 1376, 224, 80},
    { 1400, 152, 56},
    { 1288, 128, 48},
    { 1296, 160, 40},
    { 1288, 144, 72},
    { 1200, 160, 80},
    { 1120, 24, 72},
    { 872, -144, 80},
    { 720, -120, 16},
    { 808, -168, -64},
    { 904, -232, -48},
    { 888, -144, -216},
    { 1024, -56, -264},
    { 1216, -136, -264},
    { 1312, -144, -336},
    { 1104, -32, -232},
    { 992, -32, -192},
    { 1136, 0, -264},
    { 1256, -8, -320},
    { 1208, 168, -384},
    { 1256, 216, -304},
    { 1472, 280, -400},
    { 1128, 592, -352},
    // 22 seconds
    { 1272, 408, -416},
    { 1256, 352, -296},
    { 960, 248, -184},
    { 1112, 240, -144},
    { 1392, 240, -112},
    { 1376, 152, -48},
    { 1144, 16, 24},
    { 1152, 32, 56},
    { 1264, 96, 16},
    { 1264, 112, 112},
    { 1032, 48, 88},
    { 1008, 56, 16},
    { 952, 0, -64},
    { 760, -112, -64},
    { 888, -192, -136},
    { 832, -96, -184},
    { 792, -64, -240},
    { 1016, -24, -288},
    { 1200, 40, -304},
    { 1040, 56, -208},
    { 1008, 104, -192},
    { 1080, 192, -176},
    { 1224, 264, -184},
    { 1192, 336, -144},
    { 944, 344, -64},
    // 23 seconds
    { 1160, 360, -104},
    { 1152, 384, -16},
    { 1200, 432, -16},
    { 1336, 504, -112},
    { 992, 416, -144},
    { 872, 376, -136},
    { 1000, 408, -184},
    { 1200, 400, -104},
    { 1128, 192, 152},
    { 1048, -40, 128},
    { 1048, -104, 32},
    { 1096, 8, -16},
    { 1128, 128, -8},
    { 1040, 88, 48},
    { 1152, 96, 48},
    { 936, 88, -48},
    { 1088, -64, -8},
    { 1032, -136, 32},
    { 792, -40, -160},
    { 832, -72, -176},
    { 968, -64, -72},
    { 1008, 32, -128},
    { 840, 56, -160},
    { 816, 232, -328},
    { 912, 120, -232},
    // 24 seconds
    { 1048, 192, -112},
    { 1056, 208, -160},
    { 1040, 304, -160},
    { 1400, 464, -200},
    { 1152, 544, 16},
    { 1504, 464, -192},
    { 1112, 328, -176},
    { 904, 304, -88},
    { 976, 296, -136},
    { 1216, 344, -120},
    { 1176, 224, -40},
    { 1048, 96, 24},
    { 1032, 16, 24},
    { 1144, 32, -24},
    { 1176, 80, 0},
    { 1120, 64, 8},
    { 1176, 80, -72},
    { 1152, -8, -104},
    { 864, -256, 72},
    { 920, -104, -24},
    { 736, 16, -152},
    { 792, 32, -208},
    { 1000, 24, -112},
    { 1184, 72, -8},
    { 1048, 144, -88},
    // 25 seconds
    { 936, 192, -136},
    { 960, 208, -144},
    { 1128, 248, -160},
    { 1104, 248, -144},
    { 1040, 280, -144},
    { 1432, 384, -280},
    { 1128, 520, -112},
    { 1232, 584, -256},
    { 1240, 320, -232},
    { 840, 296, -176},
    { 968, 344, -160},
    { 1208, 384, -104},
    { 1256, 240, -16},
    { 1144, 64, 64},
    { 1144, -16, 72},
    { 1264, 56, 8},
    { 1216, 112, 24},
    { 1024, 48, 64},
    { 904, 48, -40},
    { 1088, 0, -64},
    { 792, -192, -72},
    { 1032, -168, -48},
    { 880, -24, -144},
    { 760, 112, -208},
    { 1016, 152, -256},
    // 26 seconds
    { 1168, 240, -216},
    { 960, 152, -160},
    { 904, 120, -128},
    { 1040, 168, -104},
    { 1168, 240, -96},
    { 1288, 280, -88},
    { 1104, 320, -48},
    { 1304, 424, -160},
    { 1112, 568, -96},
    { 1056, 584, -248},
    { 1208, 408, -264},
    { 904, 360, -208},
    { 1008, 376, -208},
    { 1248, 392, -160},
    { 1368, 232, 0},
    { 1128, 0, 40},
    { 1096, -40, 48},
    { 1152, 0, 16},
    { 1232, 144, 24},
    { 1080, 120, 96},
    { 1128, 120, 32},
    { 1032, 40, 24},
    { 1024, -120, 128},
    { 1032, -152, 48},
    { 832, -8, -200},
    // 27 seconds
    { 728, -104, -296},
    { 888, -128, -104},
    { 1040, -8, -152},
    { 984, 32, -200},
    { 928, 16, -232},
    { 1000, 72, -256},
    { 1192, 160, -264},
    { 1216, 176, -176},
    { 1032, 240, -208},
    { 1120, 328, -176},
    { 1216, 392, -208},
    { 1224, 392, -160},
    { 1376, 448, -264},
    { 912, 328, -168},
    { 984, 288, -160},
    { 1120, 264, -136},
    { 1248, 200, -112},
    { 1160, 80, -8},
    { 1080, 16, 0},
    { 1096, 48, -40},
    { 1112, 104, -48},
    { 984, 48, -8},
    { 864, 32, -16},
    { 1008, 64, -88},
    { 920, 40, -152},
    // 28 seconds
    { 920, -32, -88},
    { 1168, -32, -136},
    { 928, 72, -232},
    { 864, 96, -320},
    { 1120, 80, -272},
    { 1088, 64, -128},
    { 880, 88, -48},
    { 832, 136, -160},
    { 864, 192, -120},
    { 944, 216, -96},
    { 992, 224, -16},
    { 992, 264, -40},
    { 1344, 336, -120},
    { 1312, 488, -152},
    { 896, 800, -224},
    { 1408, 400, -272},
    { 944, 496, -288},
    { 816, 440, -192},
    { 1056, 440, -200},
    { 1352, 360, -104},
    { 1288, 144, 72},
    { 1152, -48, 40},
    { 1080, -64, 48},
    { 1160, 32, -72},
    { 1144, 136, -40},
    // 29 seconds
    { 968, 56, -16},
    { 920, 80, -56},
    { 1016, 56, -128},
    { 808, -128, -152},
    { 1152, -176, -136},
    { 880, -112, -104},
    { 896, -48, -264},
    { 1168, 0, -184},
    { 1192, 80, -112},
    { 984, 152, -144},
    { 960, 208, -88},
    { 1080, 256, -8},
    { 1224, 328, 0},
    { 1256, 360, -16},
    { 1032, 376, -56},
    { 1304, 440, -136},
    { 1144, 632, -56},
    { 984, 728, -56},
    { 1160, 496, -160},
    { 984, 464, -184},
    { 984, 456, -152},
    { 1136, 464, -120},
    { 1416, 368, -56},
    { 1440, 216, 128},
    { 1272, -32, 120},
    // 30 seconds
    { 1200, -112, 72},
    { 1160, -16, -24},
    { 1080, 104, -24},
    { 840, 120, -8},
    { 1048, 112, -48},
    { 976, 120, -168},
    { 1064, -24, -40},
    { 992, -128, 16},
    { 872, -64, -56},
    { 888, 128, -64},
    { 1088, 248, -144},
    { 1120, 232, -136},
    { 1040, 216, -144},
    { 1024, 192, -168},
    { 1096, 232, -240},
    { 1192, 288, -216},
    { 1120, 344, -176},
    { 976, 360, -208},
    { 1368, 464, -200},
    { 968, 456, -24},
    { 1200, 472, -104},
    { 1248, 504, -120},
    { 888, 384, -104},
    { 1000, 360, -80},
    { 1152, 344, -56},
    // 31 seconds
    { 1296, 264, -40},
    { 1168, 160, 48},
    { 1144, 32, 40},
    { 1184, 72, 16},
    { 1216, 56, 0},
    { 1064, 40, -8},
    { 992, 0, -32},
    { 1056, 0, -64},
    { 936, -32, -88},
    { 976, -8, -128},
    { 840, 24, -224},
    { 800, 32, -264},
    { 1016, 24, -288},
    { 1136, 48, -304},
    { 1000, 88, -328},
    { 848, 112, -280},
    { 832, 96, -216},
    { 960, 152, -192},
    { 1088, 208, -112},
    { 1104, 288, -96},
    { 1232, 344, -96},
    { 1408, 456, -104},
    { 1144, 592, -48},
    { 1352, 464, -160},
    { 872, 400, -216},
    // 32 seconds
    { 888, 392, -160},
    { 1040, 384, -184},
    { 1256, 344, -152},
    { 1144, 224, -16},
    { 1016, 0, 48},
    { 936, -32, 0},
    { 1000, 24, -88},
    { 1088, 96, -88},
    { 1088, 64, -8},
    { 1200, 56, -16},
    { 1064, 112, -64},
    { 1152, 112, -168},
    { 1056, 80, -192},
    { 776, 72, -248},
    { 688, 16, -288},
    { 920, 40, -296},
    { 968, 80, -248},
    { 768, 88, -224},
    { 744, 112, -216},
    { 840, 160, -248},
    { 976, 176, -192},
    { 1056, 224, -200},
    { 1224, 296, -208},
    { 1496, 464, -224},
    { 1048, 632, -72},
    // 33 seconds
    { 1224, 336, -208},
    { 1032, 496, -184},
    { 760, 368, -112},
    { 976, 328, -128},
    { 1184, 288, -112},
    { 1232, 216, -88},
    { 1112, 96, -72},
    { 1120, 64, -56},
    { 1200, 56, -88},
    { 1120, 72, -80},
    { 872, 56, -112},
    { 936, 64, -136},
    { 1000, 32, -272},
    { 856, -168, -264},
    { 1224, -160, -152},
    { 992, -56, -248},
    { 1008, -32, -256},
    { 1176, 120, -248},
    { 984, 168, -240},
    { 760, 152, -152},
    { 848, 160, -160},
    { 960, 200, -152},
    { 1080, 184, -112},
    { 1000, 240, -104},
    { 1144, 264, -184},
    // 34 seconds
    { 1448, 360, -184},
    { 1032, 528, 8},
    { 1320, 776, -344},
    { 888, 480, -208},
    { 832, 512, -200},
    { 1080, 424, -152},
    { 1256, 328, -120},
    { 1208, 264, -48},
    { 1152, 168, -32},
    { 1200, 96, 0},
    { 1336, 96, -56},
    { 1304, 72, -64},
    { 1168, 48, -112},
    { 1136, 0, -200},
    { 1000, -128, -256},
    { 832, -304, -208},
    { 1072, -320, -224},
    { 1008, -168, -128},
    { 976, -128, -200},
    { 1104, -8, -176},
    { 1232, 72, -88},
    { 1216, 152, -112},
    { 1248, 192, -32},
    { 1360, 272, 0},
    { 1424, 320, 48},
    // 35 seconds
    { 1416, 368, 48},
    { 1144, 464, -32},
    { 1264, 712, -64},
    { 984, 864, 104},
    { 864, 560, -72},
    { 984, 728, -104},
    { 920, 528, -16},
    { 1264, 528, 16},
    { 1584, 456, 32},
    { 1864, 208, 128},
    { 1664, 16, 208},
    { 1504, -88, 104},
    { 1496, -24, -8},
    { 1512, 88, -48},
    { 1248, 24, 112},
    { 984, 40, -72},
    { 1008, -32, -88},
    { 784, -224, -136},
    { 960, -280, -72},
    { 968, -112, -216},
    { 992, -96, -200},
    { 1160, -8, -264},
    { 1152, 80, -296},
    { 1040, 72, -224},
    { 1088, 104, -232},
    // 36 seconds
    { 1240, 160, -264},
    { 1400, 240, -288},
    { 1448, 352, -224},
    { 1248, 528, -152},
    { 1408, 528, -176},
    { 1096, 480, -16},
    { 1136, 520, -48},
    { 1088, 584, -56},
    { 872, 432, -40},
    { 1000, 432, -96},
    { 1224, 376, -80},
    { 1360, 256, -56},
    { 1336, 96, 8},
    { 1384, -24, 0},
    { 1432, -24, -192},
    { 1344, 8, -176},
    { 1096, 32, -152},
    { 992, 24, -216},
    { 960, 32, -312},
    { 784, -208, -192},
    { 1024, -144, -136},
    { 904, -16, -160},
    { 936, 8, -176},
    { 1104, 56, -256},
    { 1096, 96, -216},
    // 37 seconds
    { 952, 136, -184},
    { 960, 192, -184},
    { 1080, 240, -176},
    { 1216, 232, -208},
    { 1192, 312, -240},
    { 1176, 424, -176},
    { 1480, 568, -184},
    { 1072, 488, -64},
    { 1128, 552, -64},
    { 1200, 688, -48},
    { 960, 392, -48},
    { 1104, 408, -88},
    { 1312, 416, -48},
    { 1336, 192, 24},
    { 1224, 72, 48},
    { 1232, 16, 24},
    { 1328, 40, -8},
    { 1304, 56, -48},
    { 1120, 32, -56},
    { 1040, 24, -104},
    { 984, -88, -56},
    { 728, -168, -120},
    { 912, -240, -200},
    { 984, -160, -80},
    { 1112, -32, -248},
    // 38 seconds
    { 1280, -8, -280},
    { 1464, 32, -392},
    { 1136, 64, -320},
    { 992, 96, -312},
    { 1088, 176, -328},
    { 1200, 240, -352},
    { 1080, 320, -256},
    { 1176, 392, -200},
    { 1448, 488, -112},
    { 1080, 488, -56},
    { 1064, 512, -112},
    { 1056, 672, -112},
    { 1016, 416, -96},
    { 1264, 368, -104},
    { 1568, 320, -72},
    { 1512, 144, 24},
    { 1256, -72, 24},
    { 1224, -16, -72},
    { 1264, 16, -136},
    { 1192, 8, -112},
    { 1064, -24, -80},
    { 1048, -24, -64},
    { 872, -48, -104},
    { 784, -88, -184},
    { 880, -72, -152},
    // 39 seconds
    { 920, -8, -280},
    { 1104, -64, -296},
    { 1424, 8, -352},
    { 1216, 136, -280},
    { 848, 192, -240},
    { 824, 256, -280},
    { 984, 256, -256},
    { 1080, 232, -192},
    { 1152, 248, -176},
    { 1152, 280, -168},
    { 1440, 416, -184},
    { 1016, 608, 16},
    { 1392, 520, -184},
    { 1184, 584, -136},
    { 920, 432, -160},
    { 992, 368, -160},
    { 1176, 352, -144},
    { 1160, 272, -40},
    { 1056, 56, 32},
    { 1016, 24, 8},
    { 1200, 48, -80},
    { 1296, 96, -24},
    { 1056, 56, -32},
    { 1192, -72, -48},
    { 1040, -224, 16},
    // 40 seconds
    { 888, -256, -72},
    { 1184, -208, 32},
    { 1072, -32, -104},
    { 1192, -24, -112},
    { 1216, 16, -144},
    { 1040, 96, -168},
    { 888, 120, -192},
    { 1000, 144, -192},
    { 1152, 184, -120},
    { 1232, 312, -88},
    { 1200, 408, -96},
    { 1272, 528, -184},
    { 1192, 648, -104},
    { 1264, 576, -120},
    { 1136, 480, -80},
    { 1224, 432, -216},
    { 1344, 456, -240},
    { 1552, 248, -152},
    { 1440, 184, -64},
    { 1200, 64, 16},
    { 1096, 16, -56},
    { 1120, 88, -72},
    { 1152, 56, 16},
    { 1088, 48, 40},
    { 1128, 32, 8},
    // 41 seconds
    { 944, -8, -24},
    { 920, -96, -104},
    { 1064, -200, -40},
    { 1000, -64, -200},
    { 1104, -24, -192},
    { 1176, -8, -136},
    { 1176, 120, -192},
    { 1000, 200, -176},
    { 1016, 208, -184},
    { 1152, 224, -216},
    { 1312, 272, -272},
    { 1248, 416, -264},
    { 1256, 592, -240},
    { 1296, 560, -184},
    { 928, 408, -48},
    { 1440, 608, -160},
    { 1032, 456, -136},
    { 1144, 352, -40},
    { 1344, 328, 8},
    { 1520, 248, -32},
    { 1256, 120, 8},
    { 1168, 40, 0},
    { 1288, 8, -64},
    { 1288, 80, -128},
    { 1168, -24, -104},
    // 42 seconds
    { 952, -96, -152},
    { 936, -232, -112},
    { 600, -296, -184},
    { 936, -216, -104},
    { 992, -40, -216},
    { 1016, -16, -168},
    { 1312, -8, -240},
    { 1360, 88, -208},
    { 1096, 144, -88},
    { 1208, 224, -232},
    { 1296, 296, -240},
    { 1304, 344, -232},
    { 1104, 368, -208},
    { 984, 424, -104},
    { 1184, 656, -136},
    { 880, 416, 48},
    { 1152, 528, -72},
    { 1264, 576, -40},
    { 1320, 424, -40},
    { 1328, 408, -56},
    { 1376, 304, -64},
    { 1296, 104, -40},
    { 1192, 48, 16},
    { 1288, 24, -168},
    { 1336, 32, -184},
    // 43 seconds
    { 1120, -40, -160},
    { 1168, -112, -216},
    { 936, -336, -80},
    { 776, -328, -240},
    { 1008, -216, -88},
    { 1152, -16, -288},
    { 1208, -88, -120},
    { 1624, 24, -208},
    { 1448, 256, -376},
    { 1032, 232, -240},
    { 840, 304, -176},
    { 936, 352, -208},
    { 976, 368, -136},
    { 992, 376, -104},
    { 1240, 376, -40},
    { 1384, 528, 88},
    { 864, 608, 80},
    { 1272, 608, 80},
    { 1160, 552, 40},
    { 1160, 440, -80},
    { 1328, 416, -16},
    { 1560, 360, -80},
    { 1440, 288, 8},
    { 1320, -32, 16},
    { 1192, -48, -80},
    // 44 seconds
    { 1176, -56, -200},
    { 1088, -8, -232},
    { 968, -24, -216},
    { 1040, -8, -240},
    { 728, -152, -296},
    { 592, -328, -304},
    { 1152, -248, -168},
    { 1200, -16, -192},
    { 1376, -16, -56},
    { 1544, 64, -56},
    { 1384, 232, -24},
    { 1168, 272, -24},
    { 1160, 264, 64},
    { 1288, 280, 176},
    { 1416, 320, 136},
    { 1152, 384, 32},
    { 1264, 416, 80},
    { 1296, 736, 224},
    { 976, 888, 136},
    { 1112, 568, 40},
    { 1112, 568, -112},
    { 1064, 600, -56},
    { 1344, 520, 0},
    { 1632, 472, 16},
    { 1616, 296, 264},
    // 45 seconds
    { 1456, -128, 288},
    { 1232, -104, 72},
    { 1224, -24, -24},
    { 1296, 120, 32},
    { 1200, 104, 120},
    { 1368, 128, 16},
    { 920, -48, 32},
    { 1032, -160, 8},
    { 928, -104, -80},
    { 856, -64, -208},
    { 896, -88, -216},
    { 1032, 0, -208},
    { 984, 88, -240},
    { 928, 168, -272},
    { 1056, 264, -344},
    { 1256, 296, -432},
    { 1336, 304, -304},
    { 1104, 552, -88},
    { 1240, 320, -344},
    { 1408, 472, -136},
    { 960, 576, 24},
    { 1112, 616, 8},
    { 1072, 576, 0},
    { 976, 440, 0},
    { 1200, 432, 8},
    // 46 seconds
    { 1384, 408, 48},
    { 1432, 280, 64},
    { 1352, 136, 96},
    { 1400, 88, 64},
    { 1464, 80, 8},
    { 1352, 72, -40},
    { 1160, 56, -112},
    { 904, -8, -160},
    { 952, -48, -208},
    { 528, -344, -96},
    { 856, -240, -144},
    { 832, -112, -184},
    { 992, 0, -216},
    { 1440, -56, -320},
    { 1600, 40, -352},
    { 1304, 80, -232},
    { 1064, 192, -240},
    { 1128, 272, -336},
    { 1232, 248, -312},
    { 1224, 272, -240},
    { 1064, 344, -208},
    { 1224, 504, -144},
    { 1032, 688, -120},
    { 1048, 528, -72},
    { 1280, 512, -136},
    // 47 seconds
    { 1216, 472, -88},
    { 1272, 408, -120},
    { 1336, 352, -72},
    { 1344, 192, 24},
    { 1320, 96, 48},
    { 1424, 96, 8},
    { 1504, 96, 0},
    { 1392, 104, 32},
    { 1144, 56, 32},
    { 1008, 32, -32},
    { 952, -40, -24},
    { 600, -240, 24},
    { 880, -152, -96},
    { 800, -128, -168},
    { 896, -56, -280},
    { 1128, -96, -272},
    { 1312, -88, -392},
    { 1288, -16, -384},
    { 1248, 160, -400},
    { 1240, 168, -448},
    { 1328, 232, -640},
    { 1224, 576, -536},
    { 848, 424, -376},
    { 1136, 448, -256},
    { 1152, 432, -64},
    // 48 seconds
    { 1224, 328, 8},
    { 1352, 504, -96},
    { 1104, 416, -16},
    { 1192, 360, -8},
    { 1312, 280, -8},
    { 1144, 160, 40},
    { 1120, 72, 64},
    { 1240, 112, -24},
    { 1272, 96, -32},
    { 1232, 96, 16},
    { 1120, 40, -40},
    { 1064, 0, -104},
    { 920, -112, -24},
    { 928, -312, 8},
    { 992, -176, -56},
    { 912, -128, -224},
    { 1016, -96, -200},
    { 1160, -88, -288},
    { 1096, -24, -296},
    { 1008, 24, -312},
    { 1112, 72, -336},
    { 1232, 176, -312},
    { 1280, 288, -376},
    { 1080, 448, -248},
    { 1032, 512, -296},
    // 49 seconds
    { 1144, 440, -72},
    { 1064, 400, 16},
    { 1448, 488, -104},
    { 1080, 344, -40},
    { 1064, 384, -8},
    { 1352, 344, -104},
    { 1272, 184, 0},
    { 1136, 64, 64},
    { 1200, 8, -24},
    { 1296, 88, -88},
    { 1296, 56, -72},
    { 1096, 0, -72},
    { 1016, -56, -96},
    { 880, -184, -120},
    { 752, -312, -32},
    { 1056, -208, -88},
    { 1016, -40, -336},
    { 1144, -128, -248},
    { 1304, -48, -312},
    { 1048, 80, -328},
    { 800, 152, -288},
    { 904, 192, -328},
    { 1064, 200, -264},
    { 1208, 264, -192},
    { 1088, 384, -160},
    // 50 seconds
    { 1312, 728, -168},
    { 1264, 648, -120},
    { 840, 488, -112},
    { 1328, 624, -120},
    { 1136, 488, -104},
    { 1016, 424, -144},
    { 1208, 400, -88},
    { 1480, 368, -40},
    { 1400, 176, 16},
    { 1256, 56, 64},
    { 1288, 48, -56},
    { 1256, 56, -96},
    { 1056, 56, -152},
    { 872, -64, -224},
    { 936, -272, -224},
    { 704, -440, -224},
    { 1032, -408, -128},
    { 1248, -120, -176},
    { 1280, 0, -152},
    { 1512, -24, -104},
    { 1504, 120, -224},
    { 1200, 184, -192},
    { 1040, 256, -120},
    { 1056, 288, -64},
    { 1112, 336, -16},
    // 51 seconds
    { 1168, 416, -24},
    { 1064, 472, -16},
    { 1336, 616, 8},
    { 1104, 696, 40},
    { 992, 568, 8},
    { 1152, 616, -8},
    { 1024, 504, -64},
    { 1200, 456, -96},
    { 1448, 424, -64},
    { 1648, 376, -24},
    { 1536, 128, 72},
    { 1464, 80, 48},
    { 1384, 48, -40},
    { 1312, 88, -80},
    { 1112, 24, -56},
    { 888, -32, -112},
    { 1024, -104, -176},
    { 664, -328, -112},
    { 1032, -320, -8},
    { 1024, -80, -184},
    { 1072, -32, -144},
    { 1368, 8, -120},
    { 1480, 184, -248},
    { 1312, 232, -160},
    { 1232, 280, -112},
    // 52 seconds
    { 1224, 360, -168},
    { 1288, 384, -96},
    { 1208, 416, -72},
    { 1072, 376, -72},
    { 1336, 480, -24},
    { 1008, 576, 136},
    { 1248, 720, 24},
    { 1032, 560, -16},
    { 984, 528, -56},
    { 1128, 496, -40},
    { 1480, 392, -96},
    { 1424, 280, 16},
    { 1424, 128, 16},
    { 1432, 56, -8},
    { 1520, 64, -32},
    { 1320, 88, -112},
    { 1088, -32, -104},
    { 1088, -144, -112},
    { 664, -248, -120},
    { 936, -184, -128},
    { 952, -128, -112},
    { 936, -40, -184},
    { 1160, 0, -200},
    { 1232, 88, -280},
    { 1032, 144, -224},
    // 53 seconds
    { 944, 160, -264},
    { 1048, 184, -224},
    { 1256, 272, -200},
    { 1344, 312, -192},
    { 1208, 464, -192},
    { 1400, 648, -192},
    { 1120, 592, -32},
    { 1288, 656, -48},
    { 1168, 608, -80},
    { 936, 496, -80},
    { 1000, 440, -112},
    { 1272, 424, -144},
    { 1264, 304, -56},
    { 1232, 104, -8},
    { 1248, 56, -16},
    { 1320, 80, -88},
    { 1240, 96, -120},
    { 1072, 72, -120},
    { 1168, 16, -168},
    { 824, -96, -200},
    { 912, -264, -120},
    { 944, -224, -64},
    { 1000, -40, -216},
    { 1152, -40, -168},
    { 1272, 56, -256},
    // 54 seconds
    { 1008, 96, -288},
    { 856, 136, -304},
    { 928, 160, -272},
    { 1080, 216, -224},
    { 1256, 280, -216},
    { 1160, 408, -208},
    { 1200, 584, -200},
    { 1232, 568, -136},
    { 880, 464, -104},
    { 1288, 592, -128},
    { 1040, 480, -104},
    { 1096, 440, -120},
    { 1288, 408, -96},
    { 1448, 320, -8},
    { 1288, 184, 32},
    { 1264, 72, 48},
    { 1320, 72, -32},
    { 1256, 88, -72},
    { 1072, 64, -112},
    { 840, 8, -200},
    { 960, -32, -256},
    { 704, -224, -272},
    { 728, -288, -256},
    { 1240, -144, -232},
    { 1160, -16, -208},
    // 55 seconds
    { 1248, 48, -240},
    { 1352, 192, -304},
    { 1224, 200, -144},
    { 1080, 208, -80},
    { 1088, 248, -64},
    { 1104, 304, 24},
    { 1216, 344, 64},
    { 1168, 344, 88},
    { 1032, 360, 24},
    { 1304, 480, -24},
    { 1072, 672, 96},
    { 832, 752, 0},
    { 1184, 576, -80},
    { 1056, 616, -152},
    { 1184, 520, -88},
    { 1384, 416, -24},
    { 1592, 304, -8},
    { 1624, 200, 40},
    { 1552, 104, 104},
    { 1544, 72, 16},
    { 1448, 152, -16},
    { 1304, 208, 24},
    { 1160, 288, -24},
    { 1048, 280, -80},
    { 944, 312, -176},
    // 56 seconds
    { 648, 272, -320},
    { 376, 224, -480},
    { 200, 232, -600},
    { 8, 296, -632},
    { -24, 584, -704},
    { 8, 784, -784},
    { -8, 840, -808},
    { 0, 864, -760},
    { 24, 712, -792},
    { 24, 768, -776},
    { -24, 408, -768},
    { -8, 352, -864},
    { -8, 192, -896},
    { 0, -16, -904},
    { 8, -56, -952},
    { 56, -48, -1024},
    { 80, 8, -1000},
    { 64, 0, -984},
    { 48, -16, -1000},
    { 40, -16, -992},
    { 24, -8, -992},
    { -8, -8, -976},
    { -64, -8, -984},
    { -80, 8, -1032},
    { -48, 56, -1088},
    // 57 seconds
    { -32, 40, -1104},
    { -16, -8, -1112},
    { 0, -24, -1072},
    { 8, -80, -1064},
    { 40, -56, -1072},
    { 64, -136, -1040},
    { 64, -144, -1008},
    { 80, -176, -984},
    { 96, -136, -1096},
    { 8, -144, -1048},
    { 32, -176, -992},
    { 24, -160, -1000},
    { -48, -168, -992},
    { -104, -160, -984},
    { -80, -120, -1008},
    { -80, -136, -1024},
    { -104, -208, -1000},
    { -120, -224, -1024},
    { -152, -112, -984},
    { -72, -208, -1008},
    { 32, -240, -1056},
    { -72, -216, -1040},
    { -32, -192, -1024},
    { -56, -208, -992},
    { -80, -224, -992},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:19:17 local
AccelRawData *activity_sample_walk_100_pbl_25477_18(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25477_18
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 50
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -16, -184, -1008},
    { -16, -184, -1000},
    { -16, -176, -992},
    { -56, -184, -984},
    { 88, -296, -1000},
    { 48, -144, -1064},
    { 152, -144, -1064},
    { -48, -112, -1048},
    { -80, -184, -1000},
    { -64, -160, -1000},
    { -72, -168, -1000},
    { -56, -192, -992},
    { -16, -216, -1000},
    { -8, -208, -1000},
    { -72, -200, -1000},
    { 40, -200, -1024},
    { 0, -264, -960},
    { 248, -312, -976},
    { 16, -256, -856},
    { 320, -8, -864},
    { 112, 160, -896},
    { 56, 584, -752},
    { -144, 856, -656},
    { -224, 856, -584},
    { -264, 1000, -448},
    // 1 seconds
    { -288, 1056, -216},
    { -312, 1160, -168},
    { -320, 1136, -144},
    { -296, 976, -264},
    { -272, 752, -264},
    { -272, 784, -256},
    { -256, 1032, -160},
    { -360, 776, 72},
    { -240, 1152, 224},
    { -272, 872, 464},
    { -264, 728, 392},
    { -264, 872, 336},
    { -288, 872, 336},
    { -320, 664, 344},
    { -352, 800, 416},
    { -280, 848, 616},
    { -208, 824, 592},
    { -168, 824, 632},
    { -256, 688, 576},
    { -248, 744, 656},
    { -232, 928, 672},
    { -128, 1104, 664},
    { -32, 832, 616},
    { 168, 696, 280},
    { 344, 720, -48},
    // 2 seconds
    { 416, 656, -112},
    { 136, 496, -104},
    { 184, 536, -120},
    { 184, 856, -120},
    { 120, 752, -200},
    { 224, 960, -96},
    { 168, 1112, 0},
    { 64, 1192, -72},
    { 56, 1384, -136},
    { 16, 1576, -288},
    { -224, 1152, -520},
    { -304, 672, -1000},
    { -48, 1008, -928},
    { 88, 1240, -760},
    { 184, 920, -744},
    { 288, 776, -784},
    { 400, 728, -776},
    { 496, 632, -808},
    { 496, 536, -736},
    { 416, 168, -632},
    { 376, 56, -648},
    { 400, -40, -576},
    { 592, -120, -480},
    { 784, -168, -416},
    { 776, -88, -296},
    // 3 seconds
    { 1136, -40, -184},
    { 1384, 72, -208},
    { 1632, -32, -176},
    { 2016, 136, -32},
    { 1880, 400, 24},
    { 1384, 536, -256},
    { 1120, 488, -400},
    { 1104, 320, -160},
    { 1136, 216, -8},
    { 1104, 288, -16},
    { 952, 408, -16},
    { 1008, 544, -32},
    { 1008, 704, -40},
    { 784, 608, 32},
    { 1288, 536, -184},
    { 1128, 448, -120},
    { 1232, 416, -48},
    { 1496, 368, -40},
    { 1624, 280, -56},
    { 1432, 192, 8},
    { 1512, 160, -32},
    { 1456, 112, -24},
    { 1336, 112, -56},
    { 1056, 96, -112},
    { 976, 176, -120},
    // 4 seconds
    { 1016, 128, -168},
    { 768, 80, -168},
    { 600, 0, -128},
    { 720, 8, -176},
    { 520, 8, -128},
    { 672, -64, -168},
    { 1296, -48, -376},
    { 1608, 56, -368},
    { 1408, 104, -80},
    { 1248, 368, -288},
    { 1168, 288, -208},
    { 1376, 336, -256},
    { 1176, 320, -128},
    { 872, 288, -80},
    { 912, 368, -160},
    { 1048, 456, -72},
    { 768, 448, 64},
    { 1232, 456, -168},
    { 1256, 464, -120},
    { 904, 416, -96},
    { 936, 376, -160},
    { 1048, 352, -192},
    { 992, 384, -200},
    { 1216, 1432, -936},
    { 896, -328, -152},
    // 5 seconds
    { 952, -312, 312},
    { 792, -320, -32},
    { 824, 264, -296},
    { 912, 216, -208},
    { 1040, 120, -80},
    { 1096, 192, -40},
    { 1416, 216, -264},
    { 1032, 104, -192},
    { 848, -8, -264},
    { 848, -40, -264},
    { 936, -112, -136},
    { 872, -72, -112},
    { 760, -56, -160},
    { 712, -56, -168},
    { 776, -104, -168},
    { 952, -24, -144},
    { 880, 112, -216},
    { 872, 256, -288},
    { 1192, 384, -376},
    { 1200, 440, -304},
    { 1032, 424, -160},
    { 1488, 504, -296},
    { 1008, 384, -200},
    { 776, 352, -192},
    { 912, 328, -152},
    // 6 seconds
    { 1176, 296, -136},
    { 1232, 216, -64},
    { 1192, 144, -16},
    { 1240, 112, -40},
    { 1288, 128, -56},
    { 1080, 112, -48},
    { 848, 120, -136},
    { 928, 64, -248},
    { 1016, 0, -360},
    { 848, -136, -216},
    { 1088, -184, -192},
    { 1008, -128, -272},
    { 944, 0, -272},
    { 904, 96, -296},
    { 1040, 184, -344},
    { 1104, 240, -312},
    { 1048, 232, -184},
    { 1008, 216, -136},
    { 984, 224, -112},
    { 1000, 288, -96},
    { 960, 336, -104},
    { 1016, 336, -128},
    { 1192, 400, -184},
    { 1192, 464, -208},
    { 944, 488, -176},
    // 7 seconds
    { 1008, 576, -216},
    { 1088, 696, -208},
    { 896, 608, -328},
    { 880, 528, -288},
    { 1176, 504, -192},
    { 1624, 384, -128},
    { 1704, 296, -48},
    { 1552, 96, 16},
    { 1424, 32, -8},
    { 1304, 144, -120},
    { 1112, 152, -144},
    { 840, 16, -72},
    { 728, -24, -152},
    { 768, -104, -200},
    { 560, -328, -192},
    { 848, -200, -144},
    { 1184, -32, -144},
    { 1232, 56, -184},
    { 1384, 144, -272},
    { 1512, 184, -296},
    { 1352, 216, -184},
    { 1192, 192, -208},
    { 1112, 320, -208},
    { 1056, 368, -112},
    { 1048, 352, -72},
    // 8 seconds
    { 968, 360, -32},
    { 952, 400, -72},
    { 1072, 456, -72},
    { 1040, 560, -40},
    { 792, 560, -200},
    { 1136, 560, -200},
    { 1120, 504, -256},
    { 976, 416, -240},
    { 1184, 328, -224},
    { 1408, 280, -136},
    { 1544, 248, -200},
    { 1384, 168, -136},
    { 1272, 80, -112},
    { 1152, 112, -216},
    { 1048, 88, -248},
    { 824, -24, -232},
    { 672, -56, -256},
    { 736, -120, -232},
    { 648, -136, -288},
    { 736, -136, -224},
    { 1216, -16, -184},
    { 1360, 112, -216},
    { 1448, 256, -288},
    { 1440, 400, -208},
    { 1152, 472, -88},
    // 9 seconds
    { 928, 360, -208},
    { 896, 352, -160},
    { 944, 272, -112},
    { 920, 240, 0},
    { 880, 256, -16},
    { 936, 336, -32},
    { 1264, 536, -64},
    { 1048, 960, 264},
    { 864, 456, -240},
    { 1136, 672, -200},
    { 960, 464, -232},
    { 1000, 416, -296},
    { 1152, 400, -232},
    { 1408, 304, -232},
    { 1424, 256, -248},
    { 1496, 248, -288},
    { 1512, 176, -296},
    { 1320, 48, -368},
    { 1008, -8, -408},
    { 712, -112, -352},
    { 616, -312, -224},
    { 560, -360, -240},
    { 656, -256, -208},
    { 1160, -88, -128},
    { 1240, -16, -144},
    // 10 seconds
    { 1528, 152, -208},
    { 1672, 216, -216},
    { 1392, 368, -192},
    { 1104, 352, -232},
    { 1080, 336, -216},
    { 1152, 304, -176},
    { 1176, 264, -144},
    { 1000, 296, -176},
    { 1088, 408, -224},
    { 1168, 768, -16},
    { 816, 800, -296},
    { 1056, 648, -312},
    { 968, 488, -256},
    { 1064, 480, -288},
    { 1264, 424, -240},
    { 1400, 280, -184},
    { 1416, 232, -192},
    { 1448, 136, -160},
    { 1360, 120, -80},
    { 1304, 136, -160},
    { 1168, 184, -256},
    { 832, 72, -48},
    { 808, -176, 32},
    { 752, -264, -72},
    { 664, -192, -128},
    // 11 seconds
    { 1064, -120, 32},
    { 1200, -88, -144},
    { 1408, -64, -200},
    { 1648, 104, -320},
    { 1232, 280, -320},
    { 856, 152, -272},
    { 928, 168, -296},
    { 1112, 216, -240},
    { 1256, 304, -176},
    { 1008, 360, -144},
    { 1280, 432, -168},
    { 1392, 688, -96},
    { 832, 648, -88},
    { 1224, 536, -240},
    { 952, 552, -144},
    { 816, 424, -120},
    { 976, 360, -160},
    { 1304, 344, -120},
    { 1464, 288, -120},
    { 1288, 128, -40},
    { 1152, 8, 16},
    { 1136, 32, -88},
    { 1120, 128, -120},
    { 960, 96, -8},
    { 888, 120, -152},
    // 12 seconds
    { 880, 88, -200},
    { 752, -16, -304},
    { 952, -152, -280},
    { 976, -128, -128},
    { 992, -8, -224},
    { 1160, 120, -360},
    { 1384, 200, -352},
    { 1224, 232, -232},
    { 992, 256, -312},
    { 864, 232, -280},
    { 896, 208, -232},
    { 1008, 192, -160},
    { 984, 264, -96},
    { 920, 264, -104},
    { 1144, 328, -168},
    { 1240, 456, -216},
    { 992, 616, -56},
    { 1304, 776, -360},
    { 1008, 536, -304},
    { 824, 440, -232},
    { 976, 416, -272},
    { 1296, 312, -200},
    { 1312, 240, -152},
    { 1208, 80, -80},
    { 1120, 64, -40},
    // 13 seconds
    { 1112, 72, -120},
    { 1104, 152, -144},
    { 896, 80, -72},
    { 832, 112, -136},
    { 1000, 112, -256},
    { 768, -40, -288},
    { 992, -200, -200},
    { 1152, -128, -112},
    { 1008, -8, -184},
    { 1152, 144, -280},
    { 1296, 320, -368},
    { 1040, 248, -136},
    { 872, 208, -136},
    { 880, 256, -168},
    { 952, 256, -128},
    { 1008, 272, -64},
    { 936, 288, -40},
    { 1008, 352, -104},
    { 1336, 504, -152},
    { 984, 704, -48},
    { 1112, 520, -248},
    { 1344, 560, -224},
    { 840, 528, -216},
    { 1000, 472, -248},
    { 1280, 416, -168},
    // 14 seconds
    { 1560, 280, -112},
    { 1376, 160, -8},
    { 1304, 48, 88},
    { 1208, 24, 8},
    { 1216, 472, -248},
    { 1216, 640, -56},
    { 1056, 720, -256},
    { 1160, 544, -288},
    { 776, 336, -496},
    { 536, 64, -696},
    { 360, 120, -952},
    { 120, 368, -848},
    { 176, 216, -560},
    { 160, 16, -584},
    { 96, -152, -696},
    { 40, -264, -776},
    { -32, -344, -848},
    { -32, -328, -864},
    { -16, -288, -904},
    { -32, -264, -920},
    { -128, -336, -944},
    { -64, -328, -1064},
    { -24, -200, -1104},
    { -152, -296, -1144},
    { -48, -96, -1200},
    // 15 seconds
    { -144, -32, -1104},
    { -216, -32, -1032},
    { -96, -8, -1064},
    { 8, -56, -1008},
    { -24, -200, -824},
    { -64, -384, -688},
    { -104, -456, -552},
    { -80, -464, -456},
    { 80, -336, -440},
    { 200, -320, -464},
    { 520, -200, -536},
    { 1144, -48, -744},
    { 1400, -8, -296},
    { 1760, 488, 80},
    { 1992, 856, -224},
    { 1704, 544, -136},
    { 1608, 336, -344},
    { 1336, 408, -72},
    { 1184, 384, -32},
    { 1120, 368, -40},
    { 1008, 248, -40},
    { 912, 272, 8},
    { 904, 304, 64},
    { 896, 352, 104},
    { 1208, 464, 16},
    // 16 seconds
    { 1088, 632, -136},
    { 1008, 608, -136},
    { 1304, 624, -288},
    { 856, 496, -264},
    { 904, 400, -192},
    { 1184, 440, -192},
    { 1552, 328, -112},
    { 1536, 208, -16},
    { 1456, 72, 16},
    { 1368, 40, 24},
    { 1280, 72, -16},
    { 1112, 120, -64},
    { 840, 112, -80},
    { 872, 120, -168},
    { 904, 0, -152},
    { 672, -120, -176},
    { 864, -136, -152},
    { 824, -120, -232},
    { 768, -40, -240},
    { 1032, 40, -304},
    { 1360, 128, -336},
    { 1192, 136, -128},
    { 1040, 176, -80},
    { 1032, 304, -128},
    { 1112, 320, -80},
    // 17 seconds
    { 1176, 328, -72},
    { 1088, 280, -24},
    { 1120, 296, -8},
    { 1424, 400, -80},
    { 1128, 520, -64},
    { 1120, 720, -136},
    { 1104, 608, -216},
    { 808, 464, -224},
    { 864, 424, -192},
    { 1136, 400, -176},
    { 1352, 360, -104},
    { 1256, 240, -80},
    { 1192, 128, -8},
    { 1128, 72, 8},
    { 1088, 88, -48},
    { 1024, 112, -16},
    { 904, 80, -32},
    { 920, 88, -64},
    { 1080, 136, -200},
    { 920, 112, -240},
    { 912, -48, -208},
    { 976, -72, -200},
    { 848, -64, -208},
    { 816, 8, -304},
    { 1112, 64, -488},
    // 18 seconds
    { 1240, 208, -208},
    { 1016, 168, 0},
    { 896, 272, -168},
    { 872, 344, -208},
    { 960, 344, -176},
    { 992, 248, -120},
    { 832, 232, -136},
    { 872, 296, -224},
    { 1152, 400, -264},
    { 968, 496, -8},
    { 1360, 520, -344},
    { 1216, 456, -272},
    { 920, 400, -184},
    { 1032, 368, -208},
    { 1240, 312, -96},
    { 1200, 232, -80},
    { 992, 152, -8},
    { 968, 72, -8},
    { 1072, 96, -40},
    { 1128, 120, -16},
    { 1024, 104, 16},
    { 872, 104, -48},
    { 1008, 120, -64},
    { 992, 128, -32},
    { 928, 72, -40},
    // 19 seconds
    { 1080, 104, -160},
    { 872, 112, -208},
    { 680, 112, -360},
    { 912, 72, -488},
    { 1040, 8, -352},
    { 960, 48, -272},
    { 840, 192, -232},
    { 848, 312, -240},
    { 904, 264, -176},
    { 952, 256, -80},
    { 872, 208, -56},
    { 968, 264, -104},
    { 1304, 304, -120},
    { 1152, 368, -104},
    { 1432, 512, -160},
    { 1096, 576, -256},
    { 840, 440, -264},
    { 864, 400, -280},
    { 1072, 344, -184},
    { 1216, 216, -72},
    { 1040, 128, -56},
    { 904, 8, -8},
    { 920, 56, -80},
    { 968, 120, -80},
    { 952, 120, -32},
    // 20 seconds
    { 936, 112, -32},
    { 1136, 184, -136},
    { 1016, 160, -248},
    { 976, 64, -392},
    { 1152, -104, -304},
    { 944, -144, -248},
    { 784, -72, -400},
    { 952, 0, -312},
    { 1040, 72, -152},
    { 984, 120, -16},
    { 920, 216, -24},
    { 920, 288, -24},
    { 936, 312, 8},
    { 968, 288, 8},
    { 928, 280, -40},
    { 1048, 320, -120},
    { 1264, 424, -200},
    { 920, 456, -104},
    { 1344, 544, -312},
    { 1056, 496, -296},
    { 824, 416, -248},
    { 1024, 408, -240},
    { 1184, 400, -184},
    { 1176, 288, -96},
    { 1072, 168, 0},
    // 21 seconds
    { 1056, 40, 8},
    { 1064, 72, -64},
    { 1072, 120, -64},
    { 1024, 112, -40},
    { 992, 80, -40},
    { 1096, 104, -56},
    { 992, 112, -120},
    { 1136, 88, -136},
    { 1024, 24, -128},
    { 784, 56, -248},
    { 728, 80, -320},
    { 912, 144, -400},
    { 944, 104, -200},
    { 832, 96, -168},
    { 760, 128, -192},
    { 816, 200, -208},
    { 896, 208, -208},
    { 936, 184, -184},
    { 832, 160, -208},
    { 968, 216, -272},
    { 1320, 336, -304},
    { 1080, 368, -112},
    { 1400, 496, -248},
    { 1256, 456, -264},
    { 896, 392, -152},
    // 22 seconds
    { 856, 344, -160},
    { 1024, 344, -184},
    { 1000, 280, -160},
    { 912, 168, -64},
    { 928, 80, -80},
    { 1032, 104, -64},
    { 1168, 112, -64},
    { 1080, 128, -72},
    { 1016, 136, -120},
    { 1216, 168, -256},
    { 936, -72, -272},
    { 1128, -200, -120},
    { 1008, -184, -160},
    { 832, -48, -240},
    { 928, 72, -272},
    { 1000, 136, -288},
    { 888, 160, -248},
    { 800, 208, -216},
    { 768, 232, -200},
    { 792, 208, -176},
    { 896, 216, -136},
    { 904, 224, -112},
    { 1000, 264, -88},
    { 1368, 328, -128},
    { 1160, 440, -120},
    // 23 seconds
    { 1296, 552, -176},
    { 1344, 744, -208},
    { 776, 456, -256},
    { 832, 424, -240},
    { 1056, 472, -216},
    { 1200, 408, -120},
    { 1168, 152, -24},
    { 1112, 8, 24},
    { 1112, -72, -104},
    { 1120, 40, -72},
    { 1000, 104, 0},
    { 800, 184, -72},
    { 856, 176, -192},
    { 968, 168, -288},
    { 808, 72, -376},
    { 1120, -40, -144},
    { 1032, -80, -96},
    { 800, 8, -208},
    { 1000, 128, -312},
    { 1160, 224, -280},
    { 920, 168, -112},
    { 744, 144, -96},
    { 816, 216, -176},
    { 920, 248, -160},
    { 984, 248, -136},
    // 24 seconds
    { 872, 224, -128},
    { 1000, 288, -152},
    { 1424, 400, -184},
    { 1040, 504, 40},
    { 1392, 576, -264},
    { 1232, 456, -192},
    { 968, 368, -208},
    { 896, 352, -216},
    { 1024, 344, -136},
    { 1160, 224, -40},
    { 1000, 112, -24},
    { 912, 80, -24},
    { 944, 32, -80},
    { 936, 56, 8},
    { 936, 88, 8},
    { 872, 128, 48},
    { 1008, 200, -16},
    { 1128, 216, -72},
    { 984, 176, -144},
    { 1296, 104, -272},
    { 1008, 48, -80},
    { 656, 16, -160},
    { 688, 56, -280},
    { 976, 152, -296},
    { 976, 152, -200},
    // 25 seconds
    { 800, 272, -128},
    { 768, 248, -304},
    { 872, 264, -264},
    { 1040, 208, -192},
    { 984, 280, -264},
    { 944, 328, -240},
    { 1232, 376, -232},
    { 1168, 504, 8},
    { 1072, 376, -200},
    { 1272, 368, -184},
    { 1040, 392, -144},
    { 888, 360, -120},
    { 984, 288, -128},
    { 1120, 256, -96},
    { 1000, 216, -88},
    { 912, 128, -48},
    { 920, 40, -56},
    { 1000, 56, -120},
    { 1032, 112, -96},
    { 872, 104, -112},
    { 808, 136, -104},
    { 1032, 136, -200},
    { 1008, 112, -264},
    { 968, -48, -400},
    { 1024, -120, -248},
    // 26 seconds
    { 976, -72, -224},
    { 880, 56, -304},
    { 1032, 208, -248},
    { 1160, 320, -184},
    { 928, 280, -88},
    { 800, 272, -72},
    { 800, 272, -96},
    { 840, 224, -72},
    { 912, 168, 0},
    { 808, 152, 16},
    { 1024, 208, 0},
    { 1320, 304, -72},
    { 1200, 456, 32},
    { 1736, 1256, -128},
    { 976, 360, -264},
    { 704, 552, -408},
    { 856, 600, -416},
    { 1200, 528, -288},
    { 1152, 152, 80},
    { 1024, -24, 120},
    { 1136, 24, -56},
    { 1264, 176, -104},
    { 1296, 176, 0},
    { 1032, 104, 56},
    { 920, 96, -72},
    // 27 seconds
    { 912, 200, -208},
    { 776, 128, -368},
    { 992, -80, -168},
    { 824, -136, -120},
    { 664, -16, -104},
    { 936, 88, -344},
    { 1208, 280, -480},
    { 1088, 224, -184},
    { 904, 104, -128},
    { 912, 192, -248},
    { 1016, 288, -264},
    { 968, 216, -192},
    { 776, 192, -184},
    { 888, 240, -192},
    { 1312, 344, -216},
    { 984, 408, -48},
    { 1656, 576, -336},
    { 1296, 496, -352},
    { 760, 384, -320},
    { 752, 384, -496},
    { 1120, 384, -408},
    { 1352, 240, -192},
    { 1192, 32, -16},
    { 1144, -8, -24},
    { 1144, 72, -48},
    // 28 seconds
    { 976, 200, -112},
    { 784, 120, -96},
    { 912, 88, -48},
    { 1024, 112, -144},
    { 904, 72, -264},
    { 1176, 40, -160},
    { 968, 8, -128},
    { 768, 72, -240},
    { 976, 152, -336},
    { 1112, 184, -312},
    { 880, 120, -176},
    { 760, 112, -120},
    { 816, 232, -184},
    { 936, 264, -168},
    { 1048, 304, -128},
    { 976, 296, -96},
    { 1232, 320, -104},
    { 1472, 416, -128},
    { 1304, 480, -56},
    { 1232, 664, -144},
    { 944, 520, -240},
    { 784, 464, -272},
    { 824, 432, -208},
    { 1064, 400, -152},
    { 1288, 304, -72},
    // 29 seconds
    { 1168, 152, 24},
    { 1064, 96, 16},
    { 1024, 96, -8},
    { 960, 112, -48},
    { 912, 88, -24},
    { 904, 88, -8},
    { 1104, 152, -72},
    { 1016, 144, -80},
    { 856, 480, -392},
    { 1320, 520, -520},
    { 992, 744, -800},
    { 744, 648, -984},
    { 728, 344, -832},
    { 728, 224, -744},
    { 680, -16, -672},
    { 488, -144, -592},
    { 320, -192, -616},
    { 200, -240, -680},
    { 184, -264, -808},
    { 104, -224, -568},
    { 80, -344, -568},
    { 16, -368, -816},
    { 144, -288, -1048},
    { 112, -232, -1096},
    { 144, -152, -1184},
    // 30 seconds
    { 224, 0, -1240},
    { 208, -16, -1120},
    { 80, -80, -984},
    { 16, 8, -976},
    { 56, 0, -944},
    { 96, -72, -872},
    { 48, -112, -824},
    { 8, -120, -816},
    { 24, -168, -808},
    { 80, -312, -736},
    { 104, -448, -616},
    { 240, -520, -496},
    { 424, -480, -344},
    { 648, -464, -168},
    { 1168, -512, 72},
    { 2280, 72, 320},
    { 2624, 992, 248},
    { 1912, 832, 328},
    { 1464, 440, -136},
    { 1328, 240, -448},
    { 1264, 192, -96},
    { 1136, 128, 128},
    { 1120, 208, 48},
    { 1128, 328, 56},
    { 1032, 376, 104},
    // 31 seconds
    { 952, 448, 8},
    { 1424, 552, 104},
    { 1024, 616, 256},
    { 1112, 688, 216},
    { 1128, 568, 32},
    { 768, 520, -80},
    { 856, 608, 24},
    { 1152, 592, 72},
    { 1536, 456, 72},
    { 1640, 240, 120},
    { 1664, 112, 136},
    { 1552, 8, 64},
    { 1392, 64, -40},
    { 1232, 200, -104},
    { 1000, 32, -24},
    { 952, 48, -80},
    { 832, 0, -152},
    { 808, -184, -224},
    { 1016, -152, -144},
    { 928, -32, -296},
    { 992, 0, -264},
    { 1136, 48, -288},
    { 1040, 104, -240},
    { 992, 120, -152},
    { 1112, 160, -112},
    // 32 seconds
    { 1336, 208, -120},
    { 1336, 320, -144},
    { 1152, 240, -80},
    { 1240, 320, -184},
    { 1336, 448, -168},
    { 1024, 552, -128},
    { 1424, 560, -232},
    { 1088, 608, -192},
    { 824, 536, -232},
    { 896, 560, -240},
    { 1176, 544, -248},
    { 1256, 440, -120},
    { 1320, 248, 64},
    { 1344, 0, 120},
    { 1400, 16, 0},
    { 1336, 80, 16},
    { 1240, 184, 8},
    { 1296, 144, 48},
    { 1184, 88, 64},
    { 936, 112, -136},
    { 1152, -32, -88},
    { 888, -240, 64},
    { 736, -168, -232},
    { 760, -112, -216},
    { 1008, -16, -200},
    // 33 seconds
    { 1056, 32, -224},
    { 944, 24, -192},
    { 984, 72, -168},
    { 1120, 144, -224},
    { 1192, 264, -248},
    { 1168, 344, -336},
    { 1048, 320, -344},
    { 1184, 344, -304},
    { 1304, 392, -256},
    { 936, 312, -120},
    { 1256, 336, -168},
    { 1192, 416, -152},
    { 992, 384, -136},
    { 1048, 312, -80},
    { 1168, 288, -56},
    { 1240, 232, -56},
    { 1160, 192, 16},
    { 1120, 64, 32},
    { 1080, 56, 16},
    { 1048, 72, 8},
    { 952, 128, 24},
    { 864, 112, 48},
    { 808, 72, 16},
    { 952, 104, -104},
    { 960, 104, -184},
    // 34 seconds
    { 1056, -24, -144},
    { 1168, -80, -96},
    { 984, -48, -176},
    { 816, 72, -320},
    { 952, 48, -440},
    { 1064, 32, -352},
    { 992, 40, -224},
    { 896, 128, -192},
    { 864, 216, -200},
    { 880, 280, -216},
    { 888, 248, -168},
    { 840, 200, -120},
    { 920, 192, -152},
    { 1240, 264, -224},
    { 1120, 360, -256},
    { 968, 328, -152},
    { 1432, 448, -280},
    { 1040, 416, -200},
    { 960, 312, -152},
    { 1056, 288, -128},
    { 1152, 264, -72},
    { 1096, 200, -56},
    { 1024, 152, -24},
    { 1056, 88, 8},
    { 1120, 80, -40},
    // 35 seconds
    { 1104, 48, -24},
    { 944, 48, -40},
    { 904, 88, -88},
    { 1032, 64, -128},
    { 856, 32, -280},
    { 1104, -56, -168},
    { 1032, -64, -192},
    { 888, 32, -248},
    { 936, 88, -344},
    { 1160, 168, -344},
    { 1096, 160, -168},
    { 896, 184, -120},
    { 824, 240, -176},
    { 832, 272, -152},
    { 928, 256, -120},
    { 920, 240, -144},
    { 800, 248, -168},
    { 1024, 312, -256},
    { 1256, 384, -304},
    { 904, 384, -216},
    { 1352, 504, -400},
    { 1280, 488, -312},
    { 864, 360, -264},
    { 1008, 336, -240},
    { 1184, 312, -136},
    // 36 seconds
    { 1208, 248, -40},
    { 1128, 160, -32},
    { 1056, 96, -40},
    { 1064, 72, -72},
    { 1072, 64, -104},
    { 976, 56, -120},
    { 872, 48, -128},
    { 984, 96, -280},
    { 920, 8, -376},
    { 792, -256, -288},
    { 1104, -184, -112},
    { 1224, 40, -208},
    { 1088, 96, -320},
    { 1128, 176, -240},
    { 1160, 160, -104},
    { 1000, 184, 8},
    { 896, 224, -88},
    { 856, 296, -104},
    { 888, 264, -24},
    { 904, 232, -64},
    { 840, 216, -128},
    { 888, 296, -248},
    { 1224, 384, -328},
    { 1104, 432, -240},
    { 1144, 456, -200},
    // 37 seconds
    { 1240, 536, -320},
    { 920, 392, -224},
    { 1024, 368, -168},
    { 1192, 312, -96},
    { 1304, 264, -40},
    { 1224, 144, -24},
    { 1136, 80, 8},
    { 1072, 80, -48},
    { 1064, 88, -72},
    { 1040, 80, -48},
    { 936, 56, -72},
    { 1040, 16, -80},
    { 1008, 40, -264},
    { 920, -128, -216},
    { 1192, -160, -136},
    { 1032, -64, -200},
    { 880, 16, -264},
    { 1048, 104, -320},
    { 1088, 120, -256},
    { 928, 120, -160},
    { 864, 184, -208},
    { 912, 240, -176},
    { 1000, 216, -144},
    { 1104, 232, -104},
    { 1040, 272, -16},
    // 38 seconds
    { 1216, 464, -120},
    { 1224, 544, -40},
    { 888, 560, -208},
    { 1344, 672, -192},
    { 936, 576, -208},
    { 880, 432, -200},
    { 1008, 440, -224},
    { 1232, 432, -224},
    { 1264, 312, -104},
    { 1304, 120, 48},
    { 1272, 8, 0},
    { 1344, 72, -112},
    { 1248, 56, -104},
    { 904, -24, -96},
    { 992, -80, -200},
    { 928, -152, -192},
    { 848, -256, -96},
    { 1080, -216, -64},
    { 984, -72, -120},
    { 1136, 8, -192},
    { 1296, 0, -208},
    { 1192, 144, -208},
    { 968, 112, -176},
    { 928, 176, -240},
    { 976, 224, -224},
    // 39 seconds
    { 1072, 232, -224},
    { 1016, 240, -280},
    { 944, 320, -304},
    { 1312, 384, -304},
    { 1008, 472, -136},
    { 1400, 576, -216},
    { 1144, 632, -280},
    { 928, 432, -256},
    { 1072, 392, -240},
    { 1392, 360, -216},
    { 1464, 232, -8},
    { 1296, -40, 64},
    { 1208, -16, -40},
    { 1296, 96, -104},
    { 1280, 80, -48},
    { 1032, 16, -24},
    { 1096, -56, -48},
    { 784, -224, -16},
    { 1032, -248, -40},
    { 928, -128, -40},
    { 920, -32, -176},
    { 1176, 64, -216},
    { 1432, 112, -272},
    { 1232, 224, -248},
    { 1056, 248, -240},
    // 40 seconds
    { 1048, 312, -288},
    { 1080, 352, -208},
    { 1080, 376, -184},
    { 952, 376, -208},
    { 1160, 432, -216},
    { 1096, 464, -112},
    { 1184, 504, -136},
    { 1296, 600, -176},
    { 888, 472, -232},
    { 992, 384, -192},
    { 1232, 344, -136},
    { 1384, 264, -152},
    { 1216, 192, -120},
    { 1072, 96, -16},
    { 1064, 80, -112},
    { 1144, 176, -152},
    { 1056, 104, -112},
    { 944, 48, -120},
    { 1048, 8, -224},
    { 856, -96, -240},
    { 1008, -176, -160},
    { 1088, -152, -176},
    { 1040, -88, -216},
    { 1248, -24, -264},
    { 1216, 32, -176},
    // 41 seconds
    { 992, 96, -152},
    { 872, 192, -184},
    { 912, 248, -152},
    { 992, 272, -64},
    { 1104, 304, -64},
    { 1040, 368, -96},
    { 1136, 440, -184},
    { 1384, 536, -224},
    { 1048, 512, -160},
    { 1192, 600, -232},
    { 1032, 528, -248},
    { 1000, 432, -232},
    { 1104, 344, -160},
    { 1344, 304, -104},
    { 1392, 216, -32},
    { 1240, 144, 0},
    { 1136, 112, 0},
    { 1088, 112, -80},
    { 1032, 120, -56},
    { 936, 56, -32},
    { 920, 40, -56},
    { 1016, 40, -144},
    { 872, -104, -216},
    { 1048, -200, -176},
    { 1168, -136, -104},
    // 42 seconds
    { 1008, -40, -176},
    { 1128, 16, -144},
    { 1360, 176, -200},
    { 1240, 280, -96},
    { 1032, 288, -80},
    { 960, 328, -112},
    { 920, 336, -104},
    { 1000, 280, -128},
    { 920, 280, -152},
    { 888, 272, -264},
    { 1312, 416, -272},
    { 1016, 448, -48},
    { 1256, 512, -296},
    { 1216, 472, -272},
    { 1008, 408, -216},
    { 1120, 336, -168},
    { 1312, 272, -104},
    { 1352, 232, -40},
    { 1208, 112, 32},
    { 1208, 48, 8},
    { 1216, 56, -16},
    { 1192, 56, 0},
    { 1104, 96, 0},
    { 904, 24, -64},
    { 928, 16, -96},
    // 43 seconds
    { 840, -24, -168},
    { 808, -128, -120},
    { 904, -72, -168},
    { 888, 16, -184},
    { 1024, 0, -184},
    { 1352, 136, -328},
    { 1304, 224, -168},
    { 1024, 200, -112},
    { 904, 232, -160},
    { 960, 232, -240},
    { 1080, 264, -200},
    { 1080, 224, -208},
    { 888, 320, -256},
    { 1176, 416, -336},
    { 1128, 480, -216},
    { 1008, 504, -208},
    { 1336, 392, -264},
    { 1000, 368, -200},
    { 1048, 344, -128},
    { 1288, 280, -104},
    { 1424, 240, -88},
    { 1176, 104, -8},
    { 1056, 56, 8},
    { 1072, 72, -64},
    { 1096, 80, -40},
    // 44 seconds
    { 1016, 80, -64},
    { 928, 56, -88},
    { 1016, 40, -88},
    { 920, 16, -208},
    { 1136, -64, -152},
    { 992, -56, -248},
    { 984, -48, -296},
    { 1048, 16, -208},
    { 1080, 56, -184},
    { 1008, 104, -192},
    { 912, 160, -208},
    { 928, 152, -184},
    { 976, 184, -152},
    { 1024, 232, -144},
    { 1008, 288, -176},
    { 1120, 304, -168},
    { 1592, 432, -248},
    { 1136, 440, -136},
    { 1304, 472, -256},
    { 1032, 504, -224},
    { 928, 384, -224},
    { 1040, 320, -160},
    { 1232, 264, -88},
    { 1400, 216, -40},
    { 1216, 128, 40},
    // 45 seconds
    { 1136, 72, 0},
    { 1104, 80, 0},
    { 1080, 88, 24},
    { 1048, 72, 72},
    { 944, 72, 72},
    { 1008, 64, 24},
    { 976, 104, -32},
    { 824, 0, -112},
    { 1160, -16, -120},
    { 1072, -48, -168},
    { 888, -32, -216},
    { 944, 80, -248},
    { 1088, 144, -328},
    { 928, 96, -240},
    { 832, 56, -224},
    { 904, 104, -240},
    { 1000, 144, -184},
    { 1040, 232, -208},
    { 960, 328, -312},
    { 1056, 376, -368},
    { 1368, 416, -416},
    { 1048, 248, -168},
    { 1552, 200, -368},
    { 1320, 296, -280},
    { 1048, 248, -184},
    // 46 seconds
    { 1040, 264, -168},
    { 1176, 208, -88},
    { 1232, 152, -104},
    { 1040, 136, -24},
    { 976, 104, 24},
    { 992, 128, 0},
    { 1008, 96, 40},
    { 952, 64, 24},
    { 840, 32, -8},
    { 872, 32, -120},
    { 936, 104, -112},
    { 792, 112, -184},
    { 1088, 64, -312},
    { 1072, 64, -216},
    { 1152, 176, -504},
    { 1200, 1040, -1224},
    { 984, 672, -712},
    { 920, 656, -920},
    { 624, 592, -800},
    { 408, 528, -704},
    { 192, 496, -680},
    { 120, 440, -792},
    { -16, 544, -904},
    { -64, 320, -848},
    { -192, 232, -672},
    // 47 seconds
    { -152, 352, -872},
    { 32, 416, -1072},
    { 64, 368, -952},
    { 240, 440, -1040},
    { 368, 512, -1112},
    { 336, 304, -904},
    { 192, 224, -792},
    { 144, 200, -824},
    { 104, 192, -816},
    { 72, 96, -848},
    { 0, 80, -824},
    { -8, 48, -888},
    { -48, 8, -944},
    { -16, -8, -984},
    { -48, -72, -1008},
    { -56, -96, -1072},
    { 48, -88, -1144},
    { 80, 0, -1152},
    { 120, -40, -1232},
    { 272, 16, -1240},
    { 232, -56, -1024},
    { 216, 24, -920},
    { 216, 16, -912},
    { 192, -32, -856},
    { 32, 8, -760},
    // 48 seconds
    { -48, 0, -816},
    { -80, -16, -872},
    { -88, -56, -928},
    { -96, -64, -976},
    { -136, -80, -984},
    { -136, -72, -1032},
    { -48, -72, -1080},
    { -48, 0, -968},
    { -88, 296, -1096},
    { 40, 496, -1192},
    { -48, 408, -1040},
    { -136, 544, -984},
    { -248, 648, -888},
    { -200, 416, -784},
    { -256, 176, -664},
    { -280, 200, -576},
    { -216, 336, -640},
    { -40, 216, -560},
    { 296, 304, -552},
    { 688, 200, -416},
    { 1304, 176, -424},
    { 1528, 288, -312},
    { 1864, 288, -16},
    { 1792, 568, -128},
    { 1336, 352, -256},
    // 49 seconds
    { 1160, 192, -200},
    { 1152, 120, -248},
    { 920, 32, -272},
    { 736, 8, -280},
    { 672, -16, -288},
    { 688, 8, -296},
    { 800, 64, -344},
    { 808, 104, -352},
    { 912, 168, -360},
    { 1312, 224, -464},
    { 1128, 256, -392},
    { 896, 312, -320},
    { 1416, 384, -512},
    { 1160, 416, -432},
    { 1040, 296, -296},
    { 1288, 264, -168},
    { 1512, 128, -96},
    { 1408, 64, -64},
    { 1312, 64, -64},
    { 1312, 80, -104},
    { 1272, 72, -72},
    { 1144, 8, -128},
    { 816, -96, -160},
    { 840, -240, -216},
    { 752, -320, -224},
    // 50 seconds
    { 632, -408, -208},
    { 1104, -224, -176},
    { 1096, -104, -248},
    { 1200, -64, -248},
    { 1480, 40, -280},
    { 1376, 64, -136},
    { 1200, 216, -96},
    { 1112, 296, -104},
    { 1176, 256, -8},
    { 1336, 344, 48},
    { 1216, 416, -8},
    { 1224, 440, -80},
    { 1536, 528, 8},
    { 1056, 856, 160},
    { 1200, 816, 0},
    { 856, 640, -88},
    { 872, 560, -136},
    { 1096, 584, -88},
    { 1472, 648, -112},
    { 1544, 456, -40},
    { 1576, 248, 112},
    { 1512, 88, 72},
    { 1336, 56, 40},
    { 1216, 104, -24},
    { 1128, 120, -16},
    // 51 seconds
    { 1024, 32, 32},
    { 992, 48, -80},
    { 824, 64, -216},
    { 1024, -32, -112},
    { 1024, -80, -144},
    { 992, -8, -272},
    { 1056, 24, -232},
    { 1136, 72, -272},
    { 1008, 136, -176},
    { 904, 160, -136},
    { 968, 136, -160},
    { 1072, 248, -152},
    { 1264, 328, -104},
    { 1168, 392, -96},
    { 1176, 440, -120},
    { 1392, 560, -200},
    { 1000, 568, -104},
    { 1336, 632, -144},
    { 1160, 648, -176},
    { 800, 504, -208},
    { 896, 464, -184},
    { 1216, 464, -176},
    { 1352, 376, -88},
    { 1288, 184, 72},
    { 1296, 72, 32},
    // 52 seconds
    { 1344, 128, -40},
    { 1392, 160, -32},
    { 1232, 96, 24},
    { 1104, 120, -104},
    { 1040, 96, -128},
    { 808, -112, -192},
    { 880, -224, -152},
    { 832, -288, -152},
    { 792, -104, -200},
    { 856, -24, -216},
    { 1136, 32, -328},
    { 1224, 80, -304},
    { 1080, 128, -168},
    { 1024, 168, -144},
    { 1064, 280, -208},
    { 1112, 344, -232},
    { 1096, 360, -256},
    { 904, 368, -256},
    { 1104, 440, -296},
    { 1192, 560, -208},
    { 912, 424, -224},
    { 1424, 520, -256},
    { 1128, 432, -200},
    { 952, 360, -200},
    { 1160, 344, -168},
    // 53 seconds
    { 1480, 264, -64},
    { 1264, 112, 8},
    { 1064, 40, 24},
    { 1016, 56, -24},
    { 992, 120, -56},
    { 976, 80, 48},
    { 848, 88, 0},
    { 920, 128, -72},
    { 1016, 120, -104},
    { 840, 40, -176},
    { 1168, 0, -200},
    { 1144, -40, -168},
    { 904, -16, -248},
    { 960, 64, -360},
    { 1112, 128, -368},
    { 1008, 112, -184},
    { 904, 128, -136},
    { 928, 272, -256},
    { 968, 280, -144},
    { 1072, 296, -120},
    { 992, 296, -80},
    { 960, 320, -112},
    { 1240, 424, -176},
    { 1016, 504, -72},
    { 1136, 528, -208},
    // 54 seconds
    { 1272, 576, -208},
    { 904, 480, -240},
    { 992, 408, -216},
    { 1184, 376, -168},
    { 1312, 280, -104},
    { 1176, 184, 0},
    { 1120, 120, -8},
    { 1176, 112, -56},
    { 1192, 120, -16},
    { 1128, 80, -24},
    { 984, 80, -64},
    { 1040, 64, -144},
    { 936, 16, -256},
    { 904, -64, -240},
    { 992, -88, -224},
    { 816, -48, -208},
    { 728, 40, -208},
    { 896, 104, -272},
    { 1184, 176, -312},
    { 1144, 200, -128},
    { 1024, 176, -80},
    { 1048, 240, -128},
    { 1128, 344, -136},
    { 1136, 368, -144},
    { 944, 376, -192},
    // 55 seconds
    { 1016, 424, -272},
    { 1112, 568, -200},
    { 1064, 632, -312},
    { 1496, 584, -304},
    { 968, 488, -256},
    { 1064, 376, -184},
    { 1256, 304, -144},
    { 1360, 280, -128},
    { 1184, 184, 0},
    { 1176, 96, -16},
    { 1176, 80, 0},
    { 1160, 80, -24},
    { 1056, 72, -16},
    { 856, 64, -56},
    { 920, 112, -144},
    { 928, 56, -216},
    { 936, -24, -232},
    { 1032, -56, -184},
    { 968, -56, -232},
    { 1024, 8, -248},
    { 1176, 104, -304},
    { 1112, 152, -152},
    { 976, 184, -128},
    { 952, 248, -168},
    { 976, 304, -160},
    // 56 seconds
    { 1048, 288, -64},
    { 1120, 312, -24},
    { 1032, 336, -40},
    { 1328, 440, -80},
    { 1224, 504, 24},
    { 1104, 608, -16},
    { 1224, 688, -32},
    { 808, 536, -160},
    { 840, 504, -200},
    { 984, 488, -152},
    { 1168, 456, -144},
    { 1200, 280, -48},
    { 1248, 80, 72},
    { 1296, 64, -24},
    { 1320, 120, -8},
    { 1216, 104, -48},
    { 1040, 72, -40},
    { 1064, 48, -128},
    { 960, -8, -176},
    { 1112, -144, -80},
    { 1048, -80, -128},
    { 976, -56, -296},
    { 1056, -8, -272},
    { 1112, 80, -312},
    { 960, 128, -256},
    // 57 seconds
    { 840, 168, -240},
    { 904, 184, -264},
    { 984, 224, -184},
    { 1064, 272, -120},
    { 1064, 352, -88},
    { 1064, 408, -160},
    { 1312, 536, -208},
    { 976, 544, -88},
    { 1216, 544, -184},
    { 1184, 528, -152},
    { 944, 440, -192},
    { 1080, 384, -136},
    { 1272, 368, -160},
    { 1424, 296, -136},
    { 1232, 88, 32},
    { 1016, -72, 88},
    { 968, 72, -112},
    { 1032, 192, -224},
    { 952, 96, -48},
    { 880, 120, -80},
    { 928, 128, -152},
    { 928, 136, -192},
    { 800, 136, -376},
    { 1096, 96, -392},
    { 1128, 88, -304},
    // 58 seconds
    { 936, 8, -288},
    { 976, 72, -424},
    { 984, 152, -344},
    { 824, 144, -152},
    { 792, 200, -160},
    { 912, 256, -128},
    { 1088, 256, -80},
    { 1120, 296, -48},
    { 1000, 304, -56},
    { 960, 344, -88},
    { 1096, 408, -120},
    { 1096, 504, -112},
    { 816, 536, -288},
    { 1240, 616, -400},
    { 1072, 504, -328},
    { 1088, 376, -360},
    { 1184, 384, -344},
    { 1176, 400, -152},
    { 1336, 536, -152},
    { 1456, 544, 96},
    { 1512, 776, 200},
    { 1400, 648, 160},
    { 1280, 632, 56},
    { 1048, 528, 56},
    { 912, 392, -152},
    // 59 seconds
    { 664, 288, -280},
    { 520, -40, -464},
    { 368, -168, -592},
    { 296, -112, -696},
    { 296, -240, -800},
    { 256, -336, -824},
    { 304, -344, -968},
    { 296, -176, -1016},
    { 160, -184, -864},
    { 160, -136, -936},
    { 216, -136, -960},
    { 248, -192, -928},
    { 296, -152, -1048},
    { 288, -184, -1144},
    { 224, -88, -1048},
    { 176, -56, -1024},
    { 216, -16, -976},
    { 152, 56, -984},
    { 32, -72, -904},
    { 0, -144, -880},
    { -136, -152, -904},
    { -16, -208, -952},
    { 0, -216, -1008},
    { 40, -208, -1048},
    { 24, -176, -1048},
    // 60 seconds
    // elapsed: 1 minutes
    { -16, -176, -1008},
    { -48, -192, -1008},
    { -16, -240, -1024},
    { 24, -248, -1040},
    { 0, -240, -1016},
    { -96, -360, -1032},
    { 192, -352, -984},
    { 232, -456, -1016},
    { -72, -304, -1048},
    { -40, -272, -1016},
    { -64, -288, -968},
    { -48, -272, -952},
    { -72, -256, -960},
    { -208, -304, -1000},
    { -16, -224, -976},
    { -16, -360, -872},
    { -32, -240, -936},
    { -72, -192, -976},
    { -56, -328, -1032},
    { -24, -296, -1096},
    { 16, -240, -1064},
    { 40, -320, -1016},
    { 40, -328, -1008},
    { 64, -312, -968},
    { 56, -304, -992},
    // 61 seconds
    { 56, -128, -1000},
    { 40, -96, -968},
    { -8, -184, -992},
    { -24, -152, -1024},
    { -8, -176, -1016},
    { 0, -208, -984},
    { -24, -264, -984},
    { 88, -168, -1008},
    { 136, -64, -1040},
    { 880, 160, -1176},
    { 64, -240, -1056},
    { 32, -128, -1024},
    { 8, -64, -1008},
    { 24, -184, -984},
    { -56, -184, -976},
    { -56, -192, -992},
    { 96, -120, -1040},
    { 120, -96, -1048},
    { -24, -48, -1016},
    { -8, -72, -1024},
    { 208, -296, -784},
    { -48, -40, -1008},
    { 64, -120, -1152},
    { 136, -96, -1112},
    { 208, -96, -992},
    // 62 seconds
    { 360, 120, -1088},
    { 320, -32, -976},
    { 184, -104, -1008},
    { 56, -120, -1048},
    { 16, -64, -1016},
    { 48, -8, -992},
    { 24, 24, -1008},
    { 72, -32, -1056},
    { 144, -56, -1056},
    { 16, -24, -1000},
    { 96, -8, -1008},
    { 168, -96, -1040},
    { 160, 48, -1032},
    { 64, -80, -1008},
    { 72, -64, -968},
    { 72, -144, -968},
    { 320, 280, -1152},
    { 48, -72, -992},
    { 296, 0, -960},
    { 704, -1496, -896},
    { 368, 80, -1000},
    { 344, 24, -976},
    { 192, -88, -1000},
    { 200, -48, -1008},
    { 144, 48, -1096},
    // 63 seconds
    { 40, 0, -976},
    { 16, 16, -952},
    { 40, 24, -984},
    { 136, -24, -1032},
    { 80, -8, -1040},
    { 136, -48, -1024},
    { 96, -40, -1008},
    { 112, -48, -1008},
    { 112, -24, -1024},
    { 88, -32, -1016},
    { 104, 40, -1008},
    { 88, -8, -1024},
    { 96, 0, -1008},
    { 72, 0, -1000},
    { 96, -32, -1000},
    { 56, -32, -1008},
    { 16, -32, -1008},
    { 88, 8, -1040},
    { 80, -64, -1024},
    { 88, -72, -1024},
    { 48, -96, -1000},
    { 104, -128, -984},
    { 120, -88, -1032},
    { 64, -24, -1008},
    { 72, -40, -1008},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:20:44 local
AccelRawData *activity_sample_walk_100_pbl_25477_19(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25477_19
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 50
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 56, -96, -1016},
    { 24, -104, -1024},
    { 40, -144, -1032},
    { 48, -136, -1040},
    { 56, -128, -1040},
    { 64, -176, -1016},
    { 40, -104, -1040},
    { 88, -200, -992},
    { 40, -112, -976},
    { 64, -104, -1032},
    { 88, -72, -1048},
    { 32, -72, -984},
    { 56, -96, -1016},
    { 96, -56, -1024},
    { 72, -56, -1016},
    { 80, -120, -1032},
    { 56, -128, -1024},
    { 64, -136, -1040},
    { 80, -200, -1016},
    { 40, -168, -1000},
    { 80, -64, -1016},
    { 80, -64, -1008},
    { 96, -64, -1032},
    { 80, -80, -1032},
    { 96, -120, -1040},
    // 1 seconds
    { 112, -128, -1032},
    { 48, -120, -1016},
    { 48, -80, -1032},
    { -64, -88, -968},
    { 24, -88, -1048},
    { 40, -120, -1048},
    { 0, -160, -1032},
    { 16, -168, -1016},
    { 40, -136, -1032},
    { 0, -112, -1024},
    { 48, -96, -1032},
    { 48, -88, -1048},
    { 32, -128, -1032},
    { 56, -120, -1032},
    { 48, -160, -1008},
    { 56, -120, -1016},
    { 0, -88, -1008},
    { 56, -96, -1024},
    { -72, -152, -1000},
    { 328, -16, -1136},
    { -32, -96, -1024},
    { 64, -104, -1040},
    { 0, -104, -1040},
    { 16, -128, -1016},
    { 8, -96, -1008},
    // 2 seconds
    { 0, -88, -1024},
    { 8, -104, -1032},
    { -8, -120, -1032},
    { -8, -120, -1024},
    { 8, -120, -1032},
    { 8, -120, -1024},
    { 0, -128, -1032},
    { 8, -128, -1016},
    { 8, -120, -1032},
    { 8, -120, -1032},
    { 0, -128, -1024},
    { -8, -120, -1032},
    { 16, -120, -1032},
    { 0, -128, -1032},
    { 8, -120, -1024},
    { 0, -128, -1024},
    { 0, -128, -1016},
    { -8, -120, -1024},
    { 8, -128, -1032},
    { -8, -120, -1032},
    { -16, -136, -1032},
    { 16, -120, -1024},
    { -40, -160, -1024},
    { -16, -128, -1032},
    { 8, -136, -1040},
    // 3 seconds
    { 40, -104, -1008},
    { -24, -72, -1048},
    { 120, -120, -1040},
    { 24, -168, -1000},
    { 16, -152, -1016},
    { 24, -128, -1040},
    { 8, -160, -1024},
    { -8, -152, -1016},
    { -32, -112, -992},
    { 0, -96, -1040},
    { -48, -128, -1032},
    { -40, -96, -1040},
    { -56, -80, -1016},
    { -64, -80, -1032},
    { -48, -72, -1048},
    { -48, -48, -1064},
    { -40, -56, -1072},
    { -48, -16, -1072},
    { -48, -24, -1056},
    { -32, -88, -1032},
    { -8, -72, -1032},
    { -32, -72, -1040},
    { -40, -88, -1032},
    { -48, -88, -1032},
    { -56, -112, -1024},
    // 4 seconds
    { -56, -104, -1024},
    { -48, -144, -976},
    { -48, -112, -984},
    { -56, -72, -992},
    { -56, -80, -1008},
    { -56, -72, -1024},
    { -80, -112, -1024},
    { -88, -136, -1016},
    { -80, -128, -1024},
    { -72, -152, -1024},
    { -32, -96, -1056},
    { -16, -168, -1032},
    { 16, -184, -984},
    { 24, -272, -936},
    { 32, -320, -872},
    { 56, -272, -840},
    { 24, -208, -776},
    { 80, -208, -680},
    { 216, -88, -584},
    { 328, -8, -464},
    { 552, 32, -184},
    { 1016, 136, -32},
    { 2096, 464, 48},
    { 2416, 784, 464},
    { 2272, 792, 592},
    // 5 seconds
    { 1736, 576, -88},
    { 1392, 288, 160},
    { 1256, 416, 384},
    { 1112, 568, 400},
    { 1008, 736, 440},
    { 712, 176, 112},
    { 624, -344, -112},
    { 920, 24, -104},
    { 792, 384, 32},
    { 768, 520, 184},
    { 992, 656, 80},
    { 1360, 488, 16},
    { 1576, 288, -96},
    { 1480, 112, -216},
    { 1368, -40, -176},
    { 1648, -8, -88},
    { 1096, 136, -160},
    { 984, 144, -400},
    { 968, -24, -368},
    { 976, -216, -184},
    { 904, -344, -32},
    { 728, -208, -56},
    { 608, 8, -128},
    { 720, 152, -184},
    { 872, 144, -200},
    // 6 seconds
    { 1096, 32, -24},
    { 1008, 8, 200},
    { 1240, 128, 48},
    { 1688, 280, -16},
    { 1896, 536, -8},
    { 1520, 640, 272},
    { 976, 1112, -112},
    { 1192, 288, 200},
    { 1024, 600, 104},
    { 552, 496, -64},
    { 648, 472, -72},
    { 968, 592, -40},
    { 1432, 560, 8},
    { 1448, 328, 88},
    { 1544, 64, 136},
    { 1504, -56, 72},
    { 1472, -16, -8},
    { 1344, 120, -24},
    { 1136, 120, 40},
    { 1040, 136, -16},
    { 1064, 128, -152},
    { 1000, 56, -312},
    { 824, -96, -280},
    { 768, -136, -160},
    { 640, -8, -200},
    // 7 seconds
    { 576, 168, -280},
    { 776, 256, -240},
    { 1408, 360, -200},
    { 1376, 408, -152},
    { 1056, 200, -48},
    { 896, 80, 24},
    { 1096, 56, 48},
    { 1240, 176, -24},
    { 1296, 296, -16},
    { 1080, 248, 104},
    { 992, 272, 112},
    { 1392, 440, 96},
    { 1184, 1120, 392},
    { 880, 696, -48},
    { 1112, 456, -56},
    { 872, 456, -208},
    { 896, 456, -112},
    { 1256, 520, -48},
    { 1712, 456, -24},
    { 1640, 128, 144},
    { 1528, -184, 128},
    { 1328, -24, 32},
    { 1248, 32, 64},
    { 1112, 112, 88},
    { 984, 184, 16},
    // 8 seconds
    { 1024, 152, 8},
    { 976, 112, -80},
    { 776, 0, -184},
    { 840, -128, -112},
    { 688, -72, -72},
    { 560, 144, -128},
    { 600, 208, -264},
    { 1232, 336, -496},
    { 1600, 368, -344},
    { 1240, 312, -136},
    { 952, 208, -112},
    { 1016, -48, -144},
    { 1272, -8, -96},
    { 1248, 192, -32},
    { 1080, 464, 32},
    { 1136, 760, 184},
    { 1008, 976, 216},
    { 840, 752, 216},
    { 1200, 768, 120},
    { 976, 760, 112},
    { 1072, 856, 120},
    { 1392, 872, 264},
    { 1640, 656, 360},
    { 1624, 768, 192},
    { 1448, 712, 328},
    // 9 seconds
    { 1328, 768, 136},
    { 1064, 584, -88},
    { 808, 544, -40},
    { 528, 424, -144},
    { 344, 368, -32},
    { 256, 232, -208},
    { 48, 232, 8},
    { 152, 280, -432},
    { 296, 280, -896},
    { 600, 392, -936},
    { 600, 1072, -928},
    { 504, 864, -968},
    { 576, 752, -472},
    { 544, 768, -192},
    { 560, 728, -8},
    { 496, 512, 80},
    { 456, 344, 72},
    { 584, 240, 88},
    { 768, 192, 112},
    { 1168, 288, 152},
    { 1864, 320, 168},
    { 2528, 600, 320},
    { 1904, 800, 408},
    { 1224, 1096, 472},
    { 1288, 760, 256},
    // 10 seconds
    { 784, 768, 272},
    { 536, 736, 232},
    { 640, 704, 192},
    { 1008, 680, 96},
    { 1216, 584, 88},
    { 1408, 472, 96},
    { 1624, 256, 128},
    { 1632, 168, 104},
    { 1664, 80, -24},
    { 1528, 64, 0},
    { 1208, 72, -8},
    { 1048, 40, -216},
    { 1008, 64, -264},
    { 864, -240, -200},
    { 848, -264, -160},
    { 648, -144, -312},
    { 544, -152, -384},
    { 584, -64, -384},
    { 856, -48, -408},
    { 1120, 96, -416},
    { 1216, 104, -440},
    { 1176, 184, -464},
    { 1136, 192, -408},
    { 1112, 184, -400},
    { 1064, 272, -416},
    // 11 seconds
    { 976, 264, -376},
    { 1056, 360, -464},
    { 1176, 376, -424},
    { 1072, 496, -216},
    { 1032, 592, -400},
    { 1184, 680, -368},
    { 904, 576, -336},
    { 824, 400, -312},
    { 1056, 400, -288},
    { 1440, 360, -328},
    { 1472, 136, -160},
    { 1256, 48, -288},
    { 1168, 216, -376},
    { 1176, 232, -272},
    { 1120, 152, -256},
    { 896, 120, -288},
    { 752, 40, -344},
    { 896, 128, -456},
    { 824, 184, -680},
    { 1056, 104, -632},
    { 816, 312, -912},
    { 568, 328, -928},
    { 520, 120, -816},
    { 504, -24, -832},
    { 336, -40, -768},
    // 12 seconds
    { 224, -112, -760},
    { 144, -120, -856},
    { 24, -144, -728},
    { 144, -192, -784},
    { 112, 32, -840},
    { -8, 184, -872},
    { 24, 304, -936},
    { 40, 536, -992},
    { -184, 632, -928},
    { -184, 824, -952},
    { -96, 872, -960},
    { -128, 640, -864},
    { -192, 520, -704},
    { -168, 592, -680},
    { 48, 600, -768},
    { -8, 200, -744},
    { -80, -56, -608},
    { -96, -88, -528},
    { 48, -120, -696},
    { 512, -24, -728},
    { 640, -136, -512},
    { 1024, -168, -328},
    { 1536, 8, -144},
    { 1632, 232, 168},
    { 1856, 368, 8},
    // 13 seconds
    { 1624, 304, -192},
    { 1168, 368, -392},
    { 1032, 344, -296},
    { 1032, 240, -128},
    { 1120, 184, -176},
    { 1040, 200, -120},
    { 944, 248, -144},
    { 960, 280, -152},
    { 984, 336, -192},
    { 840, 320, -192},
    { 736, 360, -296},
    { 920, 400, -256},
    { 1112, 472, -152},
    { 912, 360, -88},
    { 1352, 280, -168},
    { 1216, 416, -152},
    { 984, 328, -88},
    { 1088, 232, -88},
    { 1376, 208, -88},
    { 1352, 240, -56},
    { 1216, 136, 16},
    { 1176, 96, -8},
    { 1168, 96, 16},
    { 1104, 104, 40},
    { 984, 104, 16},
    // 14 seconds
    { 920, 112, -64},
    { 1016, 112, -160},
    { 784, 64, -168},
    { 1008, -24, -136},
    { 872, -24, -264},
    { 640, 64, -248},
    { 632, 56, -256},
    { 976, 104, -376},
    { 1232, 184, -424},
    { 1184, 152, -208},
    { 1112, 168, -224},
    { 1088, 208, -208},
    { 1200, 288, -312},
    { 1056, 344, -264},
    { 872, 368, -184},
    { 1112, 432, -192},
    { 1072, 488, -40},
    { 1032, 432, -120},
    { 1360, 344, -176},
    { 976, 360, -80},
    { 992, 320, -104},
    { 1136, 368, -152},
    { 1368, 304, -120},
    { 1296, 96, -8},
    { 1120, -72, -32},
    // 15 seconds
    { 1064, -32, -64},
    { 1072, 72, -80},
    { 952, 136, -96},
    { 856, 104, -104},
    { 1032, 104, -128},
    { 944, 120, -152},
    { 1000, 112, -208},
    { 992, 80, -184},
    { 776, 80, -200},
    { 608, 96, -296},
    { 816, 96, -416},
    { 1088, 80, -240},
    { 1040, 72, -160},
    { 904, 168, -216},
    { 872, 216, -240},
    { 968, 232, -248},
    { 1080, 240, -200},
    { 1000, 216, -136},
    { 1152, 280, -120},
    { 1320, 376, -144},
    { 1296, 512, -128},
    { 1272, 744, -112},
    { 856, 296, -160},
    { 752, 352, -208},
    { 824, 424, -232},
    // 16 seconds
    { 1080, 312, -152},
    { 1312, 200, -96},
    { 1144, 128, -64},
    { 1024, 88, -48},
    { 992, 32, -48},
    { 992, 96, -88},
    { 984, 128, -56},
    { 928, 96, -96},
    { 1008, 112, -168},
    { 1032, 96, -272},
    { 1032, 64, -304},
    { 1176, -24, -280},
    { 1000, 40, -304},
    { 704, 40, -328},
    { 824, -8, -376},
    { 968, 56, -216},
    { 928, 152, -128},
    { 848, 176, -88},
    { 824, 224, -96},
    { 832, 248, -64},
    { 904, 248, -72},
    { 952, 224, 8},
    { 976, 232, -16},
    { 1280, 272, -32},
    { 1344, 328, -56},
    // 17 seconds
    { 1432, 480, -240},
    { 1112, 688, -280},
    { 800, 440, -496},
    { 696, 424, -472},
    { 928, 448, -416},
    { 1192, 296, -232},
    { 1128, 128, -120},
    { 1000, 72, -104},
    { 1016, 136, -120},
    { 1096, 160, -104},
    { 1136, 176, -80},
    { 1080, 152, -40},
    { 1168, 144, -64},
    { 1184, 128, -80},
    { 944, 184, -264},
    { 1072, 80, -384},
    { 888, -48, -312},
    { 624, -16, -328},
    { 456, -144, -328},
    { 696, -88, -408},
    { 968, 40, -376},
    { 1000, 80, -328},
    { 896, 112, -240},
    { 888, 168, -232},
    { 984, 216, -232},
    // 18 seconds
    { 1056, 208, -208},
    { 984, 224, -216},
    { 1096, 232, -208},
    { 1344, 320, -224},
    { 1264, 432, -160},
    { 1160, 544, -80},
    { 1136, 536, -256},
    { 856, 312, -112},
    { 744, 424, -120},
    { 832, 408, -112},
    { 1024, 352, -80},
    { 1168, 312, -72},
    { 1256, 168, 0},
    { 1248, 88, 16},
    { 1200, 72, -16},
    { 1152, 72, 8},
    { 1048, 128, 0},
    { 944, 128, 0},
    { 1000, 128, -40},
    { 984, 128, -112},
    { 960, 80, -168},
    { 1120, 0, -144},
    { 936, 16, -192},
    { 672, 40, -256},
    { 648, 32, -296},
    // 19 seconds
    { 856, 88, -384},
    { 912, 104, -296},
    { 848, 104, -248},
    { 864, 112, -232},
    { 904, 144, -216},
    { 1016, 184, -224},
    { 1000, 192, -200},
    { 1008, 240, -240},
    { 1344, 328, -288},
    { 1328, 440, -224},
    { 1232, 496, -152},
    { 1320, 432, -288},
    { 856, 296, -152},
    { 776, 296, -176},
    { 912, 280, -152},
    { 1128, 280, -144},
    { 1088, 224, -112},
    { 1048, 112, -64},
    { 1080, 88, -48},
    { 1088, 96, -56},
    { 1080, 104, -16},
    { 984, 104, -40},
    { 1024, 96, -128},
    { 1008, 24, -192},
    { 992, -72, -208},
    // 20 seconds
    { 1224, -128, -128},
    { 1080, -48, -200},
    { 888, 24, -224},
    { 896, 80, -256},
    { 960, 120, -256},
    { 944, 136, -232},
    { 888, 136, -200},
    { 872, 160, -184},
    { 888, 200, -216},
    { 912, 224, -200},
    { 928, 216, -240},
    { 904, 224, -240},
    { 1064, 280, -224},
    { 1296, 368, -280},
    { 992, 400, -208},
    { 1248, 472, -264},
    { 1200, 576, -224},
    { 848, 312, -216},
    { 904, 296, -160},
    { 1152, 320, -176},
    { 1384, 256, -136},
    { 1248, 80, -112},
    { 1152, 112, -144},
    { 1136, 136, -136},
    { 1096, 104, -96},
    // 21 seconds
    { 920, 64, -88},
    { 856, 56, -128},
    { 896, 88, -200},
    { 912, 104, -312},
    { 848, -16, -352},
    { 1088, -64, -320},
    { 1064, 16, -344},
    { 856, -16, -256},
    { 968, 48, -320},
    { 1144, 136, -232},
    { 1048, 160, -104},
    { 936, 200, -72},
    { 880, 208, -32},
    { 968, 256, -72},
    { 1080, 248, 0},
    { 1016, 256, 0},
    { 1064, 280, 0},
    { 1400, 384, -72},
    { 1216, 568, -160},
    { 944, 752, -264},
    { 1216, 536, -376},
    { 1008, 432, -360},
    { 856, 504, -352},
    { 1040, 368, -240},
    { 1376, 352, -112},
    // 22 seconds
    { 1440, 224, -8},
    { 1360, 72, 64},
    { 1328, 40, 24},
    { 1304, 64, 24},
    { 1232, 88, 32},
    { 1008, 104, 8},
    { 904, 104, -40},
    { 944, 160, -128},
    { 800, 112, -200},
    { 904, -16, -248},
    { 832, -128, -328},
    { 664, -120, -272},
    { 648, -40, -312},
    { 792, -32, -352},
    { 1136, 32, -352},
    { 1296, 80, -328},
    { 1184, 168, -256},
    { 1080, 192, -200},
    { 1112, 208, -184},
    { 1136, 240, -208},
    { 1048, 256, -192},
    { 912, 272, -128},
    { 1216, 376, -224},
    { 1112, 448, -200},
    { 1056, 528, -200},
    // 23 seconds
    { 1392, 560, -312},
    { 928, 272, -184},
    { 848, 248, -176},
    { 1096, 280, -192},
    { 1480, 256, -136},
    { 1384, 160, -48},
    { 1232, 32, 0},
    { 1184, 56, -32},
    { 1136, 80, -32},
    { 1008, 128, -64},
    { 808, 88, -104},
    { 848, 104, -176},
    { 984, 128, -312},
    { 784, 0, -264},
    { 1016, -120, -176},
    { 920, -8, -208},
    { 760, 56, -240},
    { 968, 64, -432},
    { 1168, 104, -264},
    { 1048, 104, -104},
    { 920, 144, -128},
    { 912, 272, -168},
    { 1032, 288, -176},
    { 1096, 264, -144},
    { 960, 256, -72},
    // 24 seconds
    { 1192, 296, -136},
    { 1472, 440, -192},
    { 1040, 560, 72},
    { 1272, 552, -296},
    { 1184, 352, -96},
    { 840, 448, -136},
    { 784, 448, -176},
    { 864, 384, -176},
    { 1160, 392, -152},
    { 1248, 168, -8},
    { 1168, -16, -16},
    { 1144, 64, -96},
    { 1112, 104, -80},
    { 1096, 136, -88},
    { 1024, 112, -64},
    { 1136, 72, -128},
    { 1160, 64, -264},
    { 1128, -80, -248},
    { 1064, -128, -184},
    { 792, 8, -264},
    { 576, 16, -280},
    { 792, 64, -344},
    { 984, 120, -288},
    { 984, 64, -104},
    { 944, 160, -136},
    // 25 seconds
    { 896, 208, -128},
    { 952, 176, -120},
    { 1136, 168, -152},
    { 1048, 416, -272},
    { 936, 400, -328},
    { 1248, 504, -352},
    { 1072, 712, -224},
    { 1320, 624, -352},
    { 1064, 504, -224},
    { 816, 432, -216},
    { 904, 392, -184},
    { 1192, 328, -128},
    { 1272, 248, -88},
    { 1160, 176, -24},
    { 1152, 112, -56},
    { 1216, 104, -80},
    { 1192, 104, -104},
    { 1016, 96, -120},
    { 800, 96, -232},
    { 984, 80, -312},
    { 904, 40, -376},
    { 864, -56, -400},
    { 960, -104, -280},
    { 856, 0, -208},
    { 816, 24, -248},
    // 26 seconds
    { 1008, 144, -376},
    { 1104, 184, -232},
    { 1016, 168, -128},
    { 920, 184, -72},
    { 936, 240, -104},
    { 1000, 288, -136},
    { 1016, 248, -120},
    { 944, 256, -120},
    { 1040, 296, -152},
    { 1328, 392, -208},
    { 1152, 472, -128},
    { 1064, 528, -224},
    { 1160, 544, -216},
    { 944, 520, -240},
    { 704, 392, -240},
    { 952, 352, -256},
    { 1376, 320, -248},
    { 1624, 232, -192},
    { 1448, 32, -104},
    { 1280, 40, -120},
    { 1200, -32, -152},
    { 1040, 64, -208},
    { 800, 32, -272},
    { 776, 0, -344},
    { 880, -24, -400},
    // 27 seconds
    { 824, -104, -376},
    { 872, -176, -272},
    { 1096, -40, -288},
    { 1136, 104, -232},
    { 1120, 120, -176},
    { 1200, 160, -40},
    { 1088, 136, -24},
    { 960, 144, 8},
    { 936, 192, -56},
    { 936, 224, -88},
    { 896, 200, 0},
    { 936, 192, -24},
    { 960, 232, -24},
    { 1056, 240, -24},
    { 1264, 280, -16},
    { 1408, 344, -176},
    { 1248, 400, -264},
    { 1280, 520, -448},
    { 1072, 496, -352},
    { 816, 216, -376},
    { 1048, 248, -448},
    { 1512, 176, -360},
    { 1416, 0, -136},
    { 1048, -16, -104},
    { 784, -32, -64},
    // 28 seconds
    { 800, 40, -96},
    { 816, 128, -144},
    { 856, 152, -96},
    { 952, 136, -72},
    { 1080, 112, -120},
    { 1264, 104, -120},
    { 1104, 104, -216},
    { 1216, 48, -272},
    { 1160, 40, -224},
    { 856, 32, -264},
    { 712, 8, -352},
    { 848, 32, -312},
    { 920, 64, -240},
    { 856, 120, -176},
    { 856, 168, -184},
    { 848, 216, -184},
    { 880, 224, -184},
    { 880, 240, -168},
    { 856, 256, -176},
    { 1048, 264, -184},
    { 1312, 344, -240},
    { 1016, 360, -184},
    { 1376, 448, -288},
    { 1216, 496, -240},
    { 736, 352, -264},
    // 29 seconds
    { 896, 368, -272},
    { 1208, 368, -224},
    { 1352, 192, -144},
    { 1240, 16, -72},
    { 1152, 32, -104},
    { 1096, 40, -104},
    { 1088, 56, -144},
    { 976, 0, -104},
    { 896, 56, -144},
    { 1144, 112, -296},
    { 936, 48, -264},
    { 1144, -152, -112},
    { 1104, -16, -104},
    { 856, 40, -112},
    { 952, 16, -208},
    { 1120, 88, -200},
    { 1064, 152, -152},
    { 888, 200, -184},
    { 832, 192, -168},
    { 880, 216, -176},
    { 976, 232, -208},
    { 976, 232, -216},
    { 896, 248, -272},
    { 1208, 336, -352},
    { 1136, 432, -256},
    // 30 seconds
    { 1184, 536, -272},
    { 1264, 368, -312},
    { 904, 304, -160},
    { 1064, 344, -184},
    { 1288, 328, -136},
    { 1496, 200, -120},
    { 1248, 32, -32},
    { 1112, 48, -56},
    { 1104, 56, -112},
    { 1080, 144, -120},
    { 984, 56, -104},
    { 864, 64, -152},
    { 944, 72, -224},
    { 792, 56, -288},
    { 984, -88, -216},
    { 1008, 16, -152},
    { 848, 64, -136},
    { 1064, 48, -264},
    { 1320, 192, -232},
    { 1144, 224, -112},
    { 872, 192, -136},
    { 824, 200, -176},
    { 936, 240, -176},
    { 1040, 216, -136},
    { 976, 248, -80},
    // 31 seconds
    { 1120, 304, -128},
    { 1336, 440, -184},
    { 1048, 552, -40},
    { 1400, 720, -320},
    { 1112, 256, -168},
    { 808, 240, -104},
    { 960, 400, -224},
    { 1304, 464, -168},
    { 1336, 256, -80},
    { 1152, 80, -40},
    { 1104, 64, -56},
    { 1160, 0, -48},
    { 1112, 64, -40},
    { 928, 56, -72},
    { 1032, 72, -88},
    { 856, 80, -160},
    { 856, 40, -192},
    { 1112, 0, -104},
    { 936, 80, -200},
    { 904, 64, -224},
    { 1144, 136, -320},
    { 1072, 160, -200},
    { 784, 96, -120},
    { 752, 168, -200},
    { 856, 184, -184},
    // 32 seconds
    { 1040, 232, -184},
    { 1120, 272, -184},
    { 1112, 328, -192},
    { 1480, 472, -312},
    { 1128, 584, -136},
    { 1080, 536, -272},
    { 1192, 448, -240},
    { 856, 344, -208},
    { 1048, 352, -184},
    { 1328, 328, -136},
    { 1368, 216, -80},
    { 1160, 40, -32},
    { 1048, 8, -40},
    { 1128, 40, -96},
    { 1088, 112, -112},
    { 936, 48, -96},
    { 952, 64, -176},
    { 1048, 72, -272},
    { 816, -16, -272},
    { 1080, -88, -72},
    { 1056, 32, -136},
    { 936, 128, -232},
    { 1176, 40, -264},
    { 1136, 152, -168},
    { 864, 136, -112},
    // 33 seconds
    { 800, 176, -136},
    { 856, 240, -152},
    { 960, 216, -96},
    { 1008, 224, -80},
    { 968, 256, -72},
    { 1328, 368, -192},
    { 1352, 472, -184},
    { 1136, 648, 24},
    { 1312, 448, -296},
    { 928, 344, -192},
    { 936, 416, -176},
    { 1080, 536, -168},
    { 1264, 400, -112},
    { 1248, 128, 24},
    { 1088, -112, 24},
    { 1088, -8, -72},
    { 1144, 72, -64},
    { 1096, 120, -32},
    { 992, 88, -80},
    { 1056, 64, -112},
    { 944, 96, -224},
    { 1000, -8, -216},
    { 1072, -40, -136},
    { 872, 48, -184},
    { 864, 16, -240},
    // 34 seconds
    { 1080, 64, -280},
    { 1040, 128, -184},
    { 856, 160, -160},
    { 840, 168, -176},
    { 920, 216, -136},
    { 1056, 248, -120},
    { 1104, 280, -104},
    { 1056, 320, -96},
    { 1352, 416, -232},
    { 1136, 472, -152},
    { 1072, 488, -160},
    { 1216, 464, -272},
    { 920, 360, -176},
    { 1048, 384, -184},
    { 1184, 376, -152},
    { 1304, 192, -88},
    { 1128, 16, -32},
    { 1016, 40, -56},
    { 1024, 104, -72},
    { 1080, 120, -64},
    { 1064, 120, -16},
    { 976, 96, -64},
    { 1056, 96, -152},
    { 1000, 104, -288},
    { 976, -64, -248},
    // 35 seconds
    { 1064, -80, -96},
    { 808, 32, -144},
    { 776, 40, -240},
    { 1040, 96, -312},
    { 1080, 144, -168},
    { 920, 136, -128},
    { 888, 184, -160},
    { 928, 248, -168},
    { 1024, 264, -192},
    { 1048, 272, -192},
    { 936, 320, -224},
    { 1384, 416, -296},
    { 1224, 496, -128},
    { 904, 472, -152},
    { 1336, 424, -232},
    { 952, 432, -136},
    { 944, 360, -136},
    { 1128, 344, -160},
    { 1320, 240, -56},
    { 1152, 104, -8},
    { 1040, 40, -24},
    { 1120, 56, -80},
    { 1160, 112, -8},
    { 1096, 120, 8},
    { 928, 72, -48},
    // 36 seconds
    { 1016, 64, -88},
    { 928, 72, -200},
    { 896, -8, -192},
    { 968, -40, -128},
    { 808, 56, -152},
    { 792, 40, -240},
    { 1120, 104, -384},
    { 1160, 128, -168},
    { 936, 128, -128},
    { 888, 152, -200},
    { 984, 232, -176},
    { 1112, 256, -200},
    { 1072, 280, -176},
    { 968, 304, -144},
    { 1360, 392, -216},
    { 1208, 464, -80},
    { 1096, 520, -176},
    { 1352, 512, -224},
    { 888, 352, -136},
    { 896, 360, -152},
    { 1032, 392, -160},
    { 1176, 312, -72},
    { 1128, 128, 16},
    { 1064, 16, -8},
    { 1136, 48, -16},
    // 37 seconds
    { 1208, 104, -16},
    { 1136, 96, 24},
    { 1000, 72, 16},
    { 1032, 80, -32},
    { 944, 96, -184},
    { 960, -40, -208},
    { 1112, -120, -168},
    { 944, 0, -232},
    { 888, -88, -240},
    { 1016, -40, -248},
    { 992, 48, -200},
    { 840, 72, -176},
    { 856, 96, -176},
    { 1016, 160, -128},
    { 1184, 224, -104},
    { 1248, 304, -88},
    { 1192, 376, -112},
    { 1400, 480, -248},
    { 1144, 656, -48},
    { 1128, 472, -208},
    { 1208, 608, -152},
    { 864, 416, -152},
    { 904, 344, -120},
    { 1160, 384, -112},
    { 1344, 336, -72},
    // 38 seconds
    { 1328, 176, 0},
    { 1304, 72, 8},
    { 1328, 56, 0},
    { 1328, 104, 24},
    { 1216, 112, -8},
    { 1024, 120, -24},
    { 1048, 216, -216},
    { 1000, -56, -32},
    { 712, -256, -136},
    { 952, -256, -176},
    { 992, -48, -200},
    { 808, -56, -240},
    { 864, -88, -296},
    { 1104, 56, -264},
    { 1080, 120, -176},
    { 1040, 160, -144},
    { 1072, 216, -176},
    { 1160, 232, -128},
    { 1216, 304, -88},
    { 1080, 336, -56},
    { 1144, 328, -128},
    { 1360, 392, -136},
    { 1008, 376, -24},
    { 1096, 376, -112},
    { 1216, 544, -120},
    // 39 seconds
    { 896, 496, -152},
    { 872, 328, -144},
    { 1008, 384, -160},
    { 1208, 368, -152},
    { 1248, 160, -32},
    { 1184, -8, -16},
    { 1216, 64, -88},
    { 1216, 80, -56},
    { 1160, 144, -56},
    { 992, 96, -72},
    { 1008, 120, -120},
    { 936, 104, -80},
    { 880, 72, -224},
    { 1032, 8, -160},
    { 920, 40, -136},
    { 688, 8, -168},
    { 776, 56, -264},
    { 960, 128, -312},
    { 968, 128, -224},
    { 896, 136, -192},
    { 896, 176, -136},
    { 952, 240, -240},
    { 1064, 232, -120},
    { 1080, 280, -176},
    { 1088, 280, -152},
    // 40 seconds
    { 1392, 360, -184},
    { 1160, 408, -168},
    { 1448, 400, -288},
    { 1144, 360, -256},
    { 912, 240, -248},
    { 1008, 224, -248},
    { 1240, 112, -184},
    { 1088, -16, -144},
    { 864, 96, -88},
    { 832, 72, -112},
    { 936, 192, -152},
    { 1024, 184, -96},
    { 1088, 112, -24},
    { 1008, 112, -56},
    { 1104, 144, -112},
    { 984, 128, -240},
    { 1072, 80, -288},
    { 1104, 24, -192},
    { 760, -8, -192},
    { 704, 32, -272},
    { 928, 112, -352},
    { 968, 128, -192},
    { 848, 120, -184},
    { 816, 152, -160},
    { 896, 176, -112},
    // 41 seconds
    { 1008, 232, -152},
    { 1008, 232, -128},
    { 960, 264, -160},
    { 1200, 344, -232},
    { 1328, 512, -304},
    { 920, 608, -16},
    { 1392, 488, -360},
    { 1144, 536, -256},
    { 856, 432, -224},
    { 1000, 360, -208},
    { 1232, 320, -136},
    { 1360, 256, -64},
    { 1168, 80, 32},
    { 1104, 40, 0},
    { 1144, 104, -24},
    { 1184, 120, 8},
    { 1032, 80, 24},
    { 928, 80, -56},
    { 968, 96, -112},
    { 840, 80, -192},
    { 1008, -40, -136},
    { 1040, -80, -184},
    { 776, -32, -200},
    { 768, 16, -272},
    { 1008, 104, -368},
    // 42 seconds
    { 1056, 72, -296},
    { 944, 32, -184},
    { 944, 104, -216},
    { 1024, 192, -216},
    { 1096, 256, -240},
    { 1088, 280, -272},
    { 984, 312, -224},
    { 1232, 440, -336},
    { 1160, 488, -208},
    { 912, 392, -192},
    { 1344, 360, -264},
    { 1040, 400, -184},
    { 912, 280, -160},
    { 1088, 232, -128},
    { 1320, 288, -80},
    { 1256, 208, -64},
    { 1128, 16, 8},
    { 1136, 0, 0},
    { 1120, 24, -64},
    { 1056, 104, -72},
    { 824, 56, -72},
    { 768, 72, -160},
    { 968, 64, -232},
    { 784, 40, -272},
    { 960, -32, -248},
    // 43 seconds
    { 1008, 24, -232},
    { 840, 96, -200},
    { 872, 88, -320},
    { 1080, 136, -288},
    { 1120, 152, -112},
    { 976, 128, -112},
    { 880, 160, -88},
    { 944, 184, -128},
    { 1008, 208, -120},
    { 976, 200, -128},
    { 864, 216, -128},
    { 1080, 272, -184},
    { 1312, 416, -224},
    { 1008, 536, -128},
    { 1440, 512, -448},
    { 984, 280, -216},
    { 840, 360, -328},
    { 1104, 328, -288},
    { 1360, 224, -136},
    { 1176, 8, -24},
    { 1000, -8, -64},
    { 1024, 48, -104},
    { 1096, 88, -80},
    { 1008, 120, -88},
    { 880, 56, -48},
    // 44 seconds
    { 1016, 96, -112},
    { 968, 120, -144},
    { 816, 112, -288},
    { 1072, 32, -240},
    { 1000, 40, -256},
    { 728, 32, -272},
    { 832, 32, -352},
    { 1072, 96, -272},
    { 984, 200, -192},
    { 848, 144, -128},
    { 880, 112, -112},
    { 984, 216, -168},
    { 1072, 232, -128},
    { 1000, 232, -104},
    { 1024, 288, -144},
    { 1320, 376, -200},
    { 1120, 472, -96},
    { 1056, 400, -328},
    { 1336, 496, -248},
    { 856, 464, -216},
    { 784, 344, -240},
    { 1032, 368, -264},
    { 1336, 240, -192},
    { 1208, 56, -16},
    { 1056, 8, -80},
    // 45 seconds
    { 944, 8, -88},
    { 992, 136, -104},
    { 968, 120, -96},
    { 872, 40, -56},
    { 992, 152, -144},
    { 1112, 136, -224},
    { 968, 8, -272},
    { 1152, -8, -304},
    { 1072, 32, -272},
    { 712, 0, -264},
    { 696, 48, -360},
    { 872, 24, -376},
    { 912, 64, -248},
    { 808, 72, -176},
    { 808, 128, -152},
    { 896, 192, -144},
    { 1008, 240, -184},
    { 1000, 240, -112},
    { 1048, 264, -184},
    { 1232, 320, -208},
    { 1168, 392, -208},
    { 1544, 664, -160},
    { 1200, 432, -320},
    { 728, 264, -208},
    { 776, 432, -320},
    // 46 seconds
    { 1072, 392, -240},
    { 1168, 184, -136},
    { 992, 32, -80},
    { 920, 64, -112},
    { 1056, 144, -176},
    { 1096, 88, -136},
    { 1016, 72, -88},
    { 984, 120, -152},
    { 1192, 104, -208},
    { 984, 104, -264},
    { 1168, 32, -216},
    { 928, -32, -96},
    { 768, 16, -176},
    { 816, 48, -240},
    { 968, 120, -248},
    { 912, 120, -224},
    { 784, 144, -248},
    { 784, 136, -256},
    { 912, 168, -296},
    { 1040, 264, -336},
    { 1040, 288, -336},
    { 1056, 368, -368},
    { 1472, 480, -368},
    { 1160, 496, -208},
    { 1176, 440, -288},
    // 47 seconds
    { 1176, 488, -224},
    { 864, 392, -152},
    { 888, 344, -168},
    { 1032, 304, -128},
    { 1240, 272, -112},
    { 1136, 208, -80},
    { 1016, 160, -48},
    { 1040, 104, -88},
    { 1096, 104, -96},
    { 1008, 72, -88},
    { 920, 104, -56},
    { 920, 112, -152},
    { 1056, 80, -184},
    { 872, 40, -208},
    { 952, 32, -264},
    { 944, 24, -248},
    { 912, 72, -288},
    { 1000, 112, -408},
    { 1152, 184, -392},
    { 1032, 200, -304},
    { 816, 152, -152},
    { 768, 176, -240},
    { 800, 200, -256},
    { 808, 208, -208},
    { 816, 200, -216},
    // 48 seconds
    { 840, 216, -224},
    { 1192, 288, -280},
    { 1352, 360, -328},
    { 1056, 352, -280},
    { 1288, 496, -392},
    { 976, 576, -344},
    { 824, 440, -368},
    { 840, 376, -288},
    { 1000, 320, -224},
    { 1136, 280, -240},
    { 1096, 264, -160},
    { 1072, 176, -48},
    { 1096, 176, -96},
    { 1064, 136, -72},
    { 1040, 88, -104},
    { 968, 96, -80},
    { 1048, 88, -216},
    { 1088, 112, -280},
    { 888, 24, -320},
    { 1120, 96, -448},
    { 936, 32, -400},
    { 744, -16, -320},
    { 816, 24, -360},
    { 1072, 120, -360},
    { 1056, 224, -352},
    // 49 seconds
    { 808, 192, -240},
    { 720, 184, -200},
    { 744, 232, -184},
    { 848, 192, -184},
    { 904, 208, -144},
    { 920, 224, -200},
    { 1280, 296, -328},
    { 1368, 408, -368},
    { 1240, 536, -360},
    { 1280, 752, -480},
    { 952, 224, -296},
    { 824, 448, -408},
    { 928, 360, -288},
    { 1200, 296, -224},
    { 1216, 184, -136},
    { 1096, 112, -16},
    { 1104, 120, -112},
    { 1072, 144, -112},
    { 1040, 96, -48},
    { 1008, 80, -16},
    { 1096, 88, -96},
    { 1128, 104, -176},
    { 968, 48, -280},
    { 1008, -56, -352},
    { 1040, -104, -320},
    // 50 seconds
    { 840, -112, -320},
    { 712, -104, -304},
    { 824, 16, -432},
    { 1016, 112, -344},
    { 992, 200, -176},
    { 896, 184, -120},
    { 912, 200, -120},
    { 928, 232, -136},
    { 976, 264, -184},
    { 936, 240, -208},
    { 976, 240, -248},
    { 1272, 320, -312},
    { 1232, 352, -304},
    { 992, 432, -304},
    { 1208, 640, -328},
    { 1040, 560, -336},
    { 688, 400, -280},
    { 896, 392, -184},
    { 1160, 376, -80},
    { 1296, 264, -40},
    { 1288, 192, -8},
    { 1296, 152, -24},
    { 1304, 136, -56},
    { 1264, 128, -80},
    { 1104, 112, -120},
    // 51 seconds
    { 952, 88, -208},
    { 864, 64, -352},
    { 920, 56, -384},
    { 752, -48, -360},
    { 824, -136, -360},
    { 792, -104, -312},
    { 848, -80, -304},
    { 1056, 48, -320},
    { 1288, 168, -256},
    { 1296, 272, -104},
    { 1064, 280, -40},
    { 968, 288, -120},
    { 952, 248, -56},
    { 1080, 240, -32},
    { 1128, 240, -16},
    { 992, 240, -88},
    { 1288, 344, -216},
    { 1424, 512, -208},
    { 928, 968, 48},
    { 1144, 456, -240},
    { 984, 632, -240},
    { 832, 552, -144},
    { 1000, 496, -112},
    { 1208, 400, -40},
    { 1392, 272, 0},
    // 52 seconds
    { 1368, 176, 56},
    { 1352, 152, 24},
    { 1320, 128, -8},
    { 1216, 144, 8},
    { 1080, 80, -24},
    { 952, 72, -40},
    { 912, 88, -176},
    { 960, 64, -264},
    { 800, 0, -336},
    { 960, -80, -296},
    { 936, -72, -264},
    { 792, -24, -280},
    { 968, 56, -368},
    { 1240, 160, -392},
    { 1216, 160, -144},
    { 1032, 176, -64},
    { 1000, 272, -152},
    { 1088, 328, -128},
    { 1160, 312, -80},
    { 1016, 272, -48},
    { 1000, 312, -104},
    { 1288, 456, -136},
    { 1016, 744, 152},
    { 992, 488, -240},
    { 1176, 592, -192},
    // 53 seconds
    { 1000, 528, -176},
    { 1008, 440, -144},
    { 1168, 408, -136},
    { 1448, 304, -48},
    { 1384, 192, 32},
    { 1240, 96, 104},
    { 1224, 96, 24},
    { 1200, 112, 32},
    { 1144, 80, 64},
    { 944, 64, 32},
    { 976, 80, -32},
    { 888, 112, -128},
    { 784, 64, -272},
    { 1000, 0, -208},
    { 888, -40, -280},
    { 712, -64, -312},
    { 792, 32, -352},
    { 1120, 112, -408},
    { 1168, 128, -304},
    { 1104, 168, -240},
    { 1064, 240, -216},
    { 1040, 344, -256},
    { 1048, 352, -240},
    { 960, 320, -208},
    { 968, 312, -192},
    // 54 seconds
    { 1232, 352, -136},
    { 1008, 384, -8},
    { 1032, 472, -64},
    { 1320, 568, -8},
    { 920, 504, -112},
    { 928, 416, -136},
    { 1128, 384, -88},
    { 1304, 392, -120},
    { 1312, 240, -48},
    { 1224, 80, 64},
    { 1128, 80, -16},
    { 1112, 128, -128},
    { 1024, -40, 0},
    { 808, -152, -40},
    { 928, 0, -200},
    { 1032, 16, -240},
    { 928, -96, -248},
    { 1088, -96, -216},
    { 1048, -136, -264},
    { 920, -88, -288},
    { 1072, 80, -384},
    { 1136, 96, -264},
    { 1016, 120, -160},
    { 920, 240, -280},
    { 840, 144, -176},
    // 55 seconds
    { 848, 80, -168},
    { 920, 136, -144},
    { 888, 168, -160},
    { 864, 224, -176},
    { 1232, 336, -208},
    { 1216, 520, -128},
    { 992, 664, -272},
    { 1336, 456, -184},
    { 928, 488, -240},
    { 808, 408, -168},
    { 1016, 336, -176},
    { 1312, 272, -184},
    { 1336, 216, -152},
    { 1256, 56, -72},
    { 1112, 32, -40},
    { 1048, 56, -120},
    { 984, 64, -144},
    { 824, 40, -96},
    { 864, 40, -152},
    { 1032, 72, -264},
    { 880, 8, -272},
    { 1056, -32, -240},
    { 1144, -32, -224},
    { 1016, 56, -264},
    { 1000, 120, -240},
    // 56 seconds
    { 1072, 104, -296},
    { 944, 144, -256},
    { 792, 112, -176},
    { 840, 112, -160},
    { 904, 176, -168},
    { 984, 184, -176},
    { 944, 200, -168},
    { 912, 208, -232},
    { 1056, 288, -320},
    { 1208, 360, -344},
    { 936, 336, -240},
    { 1056, 432, -304},
    { 1264, 504, -240},
    { 920, 376, -224},
    { 872, 312, -176},
    { 1104, 280, -152},
    { 1360, 272, -112},
    { 1272, 208, -120},
    { 1152, 120, -48},
    { 1112, 96, -72},
    { 1112, 72, -104},
    { 1024, 64, -128},
    { 776, 56, -184},
    { 848, 32, -224},
    { 984, 32, -328},
    // 57 seconds
    { 816, 16, -368},
    { 992, -64, -304},
    { 1144, -64, -192},
    { 1088, 0, -264},
    { 1128, 128, -272},
    { 1216, 256, -232},
    { 1184, 296, -168},
    { 1048, 296, -160},
    { 904, 280, -144},
    { 864, 256, -88},
    { 888, 216, -40},
    { 880, 200, -24},
    { 848, 240, -48},
    { 944, 272, -104},
    { 1136, 368, -240},
    { 1032, 408, -240},
    { 1152, 528, -360},
    { 1304, 696, -416},
    { 712, 408, -456},
    { 824, 280, -456},
    { 1200, 272, -424},
    { 1536, 296, -408},
    { 1360, 72, -392},
    { 1136, -8, -256},
    { 984, -72, -256},
    // 58 seconds
    { 888, 0, -392},
    { 728, 8, -360},
    { 616, -8, -368},
    { 616, 32, -376},
    { 736, 16, -392},
    { 960, 56, -312},
    { 1024, 56, -240},
    { 1080, 64, -328},
    { 1528, 80, -176},
    { 1392, 136, -136},
    { 1000, 200, -288},
    { 864, 232, -352},
    { 912, 208, -248},
    { 856, 168, -184},
    { 848, 176, -192},
    { 824, 152, -192},
    { 808, 136, -184},
    { 904, 136, -272},
    { 960, 136, -360},
    { 936, 168, -384},
    { 1128, 224, -528},
    { 1232, 248, -488},
    { 1248, 312, -408},
    { 1000, 392, -368},
    { 872, 456, -384},
    // 59 seconds
    { 800, 344, -280},
    { 968, 320, -168},
    { 1224, 224, -32},
    { 1248, 192, -24},
    { 1112, 176, -32},
    { 1064, 176, -24},
    { 1064, 152, 0},
    { 1080, 144, 24},
    { 1152, 152, 16},
    { 1112, 160, 0},
    { 1216, 184, -64},
    { 1064, 168, -48},
    { 984, 0, -48},
    { 1016, -184, -120},
    { 904, -248, 32},
    { 792, -208, -280},
    { 848, -240, -296},
    { 1096, -216, -440},
    { 1144, -168, -480},
    { 944, -104, -384},
    { 800, -88, -408},
    { 752, -88, -448},
    { 792, -64, -512},
    { 864, -24, -456},
    { 968, 112, -480},
    // 60 seconds
    // elapsed: 1 minutes
    { 1072, 152, -360},
    { 1344, 288, -344},
    { 1072, 368, -320},
    { 808, 304, -280},
    { 1472, 400, -272},
    { 1544, 352, -312},
    { 960, 368, -256},
    { 1056, 320, -232},
    { 1176, 232, -136},
    { 1272, 176, -88},
    { 1248, 136, -64},
    { 1224, 88, -48},
    { 1232, 96, -56},
    { 1128, 48, -24},
    { 1040, 48, -112},
    { 1056, 24, -168},
    { 936, -48, -120},
    { 632, -168, -104},
    { 896, -184, -136},
    { 688, -176, -112},
    { 808, -88, -272},
    { 1128, -160, -408},
    { 1424, -160, -384},
    { 1272, -8, -320},
    { 992, 88, -224},
    // 61 seconds
    { 1032, 208, -352},
    { 1024, 224, -360},
    { 1024, 64, -288},
    { 952, 144, -296},
    { 968, 232, -376},
    { 1152, 304, -344},
    { 1208, 496, -312},
    { 928, 384, -320},
    { 1128, 424, -264},
    { 1288, 472, -272},
    { 912, 392, -288},
    { 1080, 360, -216},
    { 1344, 248, -176},
    { 1464, 192, -48},
    { 1232, 80, -16},
    { 1112, 112, -40},
    { 1096, 144, -88},
    { 1072, 120, -16},
    { 1024, 96, -32},
    { 968, 104, -72},
    { 1072, 24, -184},
    { 1056, -48, -216},
    { 1120, -184, -64},
    { 992, -208, -192},
    { 936, -120, -304},
    // 62 seconds
    { 960, -136, -304},
    { 1072, -120, -384},
    { 984, -40, -304},
    { 888, 32, -304},
    { 832, 24, -280},
    { 936, 40, -320},
    { 936, 80, -256},
    { 888, 176, -232},
    { 920, 176, -248},
    { 1144, 208, -256},
    { 1384, 248, -272},
    { 1112, 368, -136},
    { 1312, 584, -312},
    { 1152, 688, -352},
    { 832, 400, -336},
    { 1072, 384, -264},
    { 1352, 336, -168},
    { 1336, 216, -136},
    { 1216, 176, -136},
    { 1192, 104, -128},
    { 1128, 56, -24},
    { 1056, 72, -96},
    { 984, 96, -120},
    { 904, 64, -80},
    { 1024, 224, -136},
    // 63 seconds
    { 1080, 320, -200},
    { 1024, 352, -312},
    { 1088, 488, -400},
    { 840, 528, -576},
    { 656, 408, -640},
    { 648, 480, -744},
    { 624, 408, -808},
    { 408, 408, -720},
    { 272, 456, -728},
    { 136, 472, -688},
    { -72, 552, -688},
    { -176, 568, -816},
    { -288, 608, -880},
    { -272, 592, -840},
    { -208, 536, -696},
    { -168, 480, -616},
    { -144, 480, -600},
    { -144, 560, -616},
    { -152, 560, -616},
    { -176, 568, -688},
    { -288, 640, -712},
    { -48, 1376, -1360},
    { 240, 912, -1040},
    { 160, 864, -952},
    { 360, 1032, -928},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:26:06 local
AccelRawData *activity_sample_walk_100_pbl_25477_20(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25477_20
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 40
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -40, -24, -1048},
    { 24, -120, -1128},
    { -232, -488, -816},
    { 144, -248, -1056},
    { 8, -112, -1064},
    { -24, -144, -1032},
    { -32, -152, -1016},
    { -40, -96, -1032},
    { -32, -120, -1008},
    { -32, -104, -1072},
    { 96, -136, -1040},
    { -168, -24, -1056},
    { 48, -48, -1064},
    { -8, -104, -1048},
    { -64, -72, -1008},
    { -40, -64, -1016},
    { -64, -64, -1032},
    { -56, -88, -1008},
    { -48, -64, -1024},
    { -56, -56, -1000},
    { -72, -24, -992},
    { -24, -160, -1024},
    { -40, -56, -1048},
    { -120, -88, -1040},
    { -120, -120, -1032},
    // 1 seconds
    { -88, -128, -1080},
    { 0, -240, -976},
    { 144, 80, -1032},
    { -136, -112, -1000},
    { -96, -104, -1000},
    { -8, -24, -1048},
    { -48, -24, -1064},
    { -64, -8, -1048},
    { -64, -32, -1040},
    { -48, -40, -1024},
    { -8, -120, -968},
    { 72, -104, -928},
    { 0, -104, -952},
    { -16, 32, -1048},
    { -48, 80, -1096},
    { -48, 128, -1080},
    { -32, 144, -1096},
    { -72, 104, -1048},
    { -48, 96, -1032},
    { -48, 0, -1000},
    { -48, -64, -928},
    { -16, -48, -976},
    { 72, 8, -1000},
    { 104, 88, -1080},
    { 88, 24, -1056},
    // 2 seconds
    { 48, -48, -1008},
    { 0, 40, -992},
    { 184, 64, -1056},
    { 240, 80, -1112},
    { 352, 112, -1160},
    { 368, 88, -1144},
    { 280, 48, -1072},
    { 200, -56, -1032},
    { 160, -176, -952},
    { 112, -200, -920},
    { 136, -184, -896},
    { 184, -200, -904},
    { 152, -176, -888},
    { 32, -120, -944},
    { 72, -232, -952},
    { 120, -24, -944},
    { 112, -8, -1000},
    { 176, -32, -1000},
    { 128, -112, -1008},
    { 208, 24, -1024},
    { 288, 56, -1024},
    { 344, -24, -1048},
    { 344, 176, -992},
    { 160, 360, -888},
    { 232, 496, -968},
    // 3 seconds
    { 288, 344, -712},
    { 56, 56, -912},
    { 256, 296, -984},
    { 328, 416, -1000},
    { 248, 128, -920},
    { 168, 176, -896},
    { 64, 408, -776},
    { -72, 792, -688},
    { -224, 840, -592},
    { -368, 888, -568},
    { -608, 912, -584},
    { -632, 800, -672},
    { -560, 712, -736},
    { -440, 576, -760},
    { -280, 696, -808},
    { -184, 576, -904},
    { -88, 360, -944},
    { -88, 296, -992},
    { -96, 280, -976},
    { -144, 216, -968},
    { -144, 152, -992},
    { -120, 72, -960},
    { -120, 80, -1000},
    { -88, 48, -1000},
    { -104, 16, -984},
    // 4 seconds
    { -104, 24, -984},
    { -104, 16, -1008},
    { -104, 32, -1000},
    { -88, 0, -984},
    { -80, -8, -1008},
    { -88, 72, -952},
    { -120, 48, -984},
    { -152, 40, -1048},
    { -184, 48, -1048},
    { -192, 40, -1064},
    { -192, 48, -1000},
    { -160, 24, -960},
    { -112, -16, -920},
    { -48, -56, -880},
    { 32, -112, -744},
    { 128, -64, -656},
    { 264, 224, -656},
    { 408, 352, -664},
    { 560, 544, -600},
    { 608, 624, -512},
    { 760, 704, -472},
    { 800, 680, -440},
    { 904, 672, -376},
    { 1008, 488, -368},
    { 1120, 416, -216},
    // 5 seconds
    { 1184, 360, -232},
    { 1232, 392, -192},
    { 1128, 368, -168},
    { 1040, 336, -192},
    { 992, 328, -176},
    { 920, 256, -80},
    { 896, 168, -72},
    { 896, 112, -88},
    { 928, 152, -184},
    { 920, 216, -288},
    { 920, 296, -384},
    { 920, 264, -376},
    { 904, 200, -304},
    { 928, 168, -320},
    { 896, 128, -312},
    { 888, 96, -312},
    { 880, 72, -272},
    { 912, 88, -208},
    { 944, 184, -216},
    { 848, 40, -248},
    { 840, 24, -256},
    { 896, 96, -272},
    { 1040, 128, -184},
    { 1096, 208, -224},
    { 856, 208, -224},
    // 6 seconds
    { 800, 192, -216},
    { 832, 176, -208},
    { 960, 168, -176},
    { 1056, 152, -128},
    { 1144, 176, -120},
    { 1128, 176, -112},
    { 1072, 104, -168},
    { 1024, 64, -184},
    { 920, 96, -232},
    { 816, 120, -240},
    { 696, 88, -288},
    { 656, 56, -248},
    { 800, 56, -224},
    { 1056, 40, -216},
    { 1112, 40, -160},
    { 1248, 80, -120},
    { 1448, 136, 0},
    { 1064, 216, 16},
    { 808, 272, -200},
    { 952, 320, -184},
    { 936, 200, -40},
    { 800, 256, -184},
    { 784, 240, -224},
    { 744, 240, -224},
    { 728, 240, -224},
    // 7 seconds
    { 696, 256, -240},
    { 672, 304, -184},
    { 912, 336, -120},
    { 1168, 352, -72},
    { 952, 360, -16},
    { 1224, 368, -40},
    { 1320, 424, -32},
    { 896, 400, -104},
    { 904, 368, -128},
    { 1200, 280, -96},
    { 1248, 200, -144},
    { 1080, 120, -168},
    { 1032, 104, -176},
    { 1048, 72, -240},
    { 952, 56, -240},
    { 824, 96, -256},
    { 784, 80, -304},
    { 968, 64, -280},
    { 928, 32, -248},
    { 1160, 48, -240},
    { 1128, 64, -128},
    { 1064, 144, -144},
    { 1128, 216, -168},
    { 1056, 216, -128},
    { 936, 248, -256},
    // 8 seconds
    { 832, 240, -216},
    { 800, 208, -144},
    { 776, 224, -80},
    { 880, 248, -32},
    { 968, 304, -32},
    { 1008, 328, -48},
    { 1312, 416, 16},
    { 1128, 552, 128},
    { 1096, 496, 80},
    { 1248, 560, 40},
    { 824, 512, -48},
    { 848, 440, -72},
    { 1024, 416, -112},
    { 1248, 320, -104},
    { 1224, 232, -96},
    { 1264, 128, -56},
    { 1312, 112, -112},
    { 1240, 88, -120},
    { 1040, 64, -168},
    { 912, 56, -232},
    { 1080, 32, -288},
    { 848, -64, -312},
    { 816, -128, -280},
    { 1000, -136, -200},
    { 848, -8, -192},
    // 9 seconds
    { 1008, 64, -264},
    { 1232, 168, -288},
    { 1128, 176, -136},
    { 992, 240, -160},
    { 952, 296, -128},
    { 1008, 288, -80},
    { 1072, 264, -56},
    { 1032, 264, -56},
    { 1136, 320, -56},
    { 1392, 424, 32},
    { 1008, 680, 184},
    { 1176, 640, -48},
    { 1184, 648, -40},
    { 856, 464, -96},
    { 928, 432, -136},
    { 1152, 416, -136},
    { 1272, 256, -80},
    { 1248, 184, -48},
    { 1232, 112, -56},
    { 1280, 160, -80},
    { 1232, 104, -80},
    { 1072, 80, -64},
    { 1040, 112, -136},
    { 1096, 64, -216},
    { 792, 8, -288},
    // 10 seconds
    { 976, -56, -272},
    { 824, -104, -160},
    { 672, -24, -216},
    { 816, 64, -296},
    { 1176, 144, -368},
    { 1136, 200, -264},
    { 960, 224, -184},
    { 904, 280, -176},
    { 968, 336, -192},
    { 1064, 328, -200},
    { 984, 336, -160},
    { 1088, 376, -128},
    { 1384, 480, -48},
    { 984, 512, 136},
    { 1160, 472, -40},
    { 1296, 544, 32},
    { 840, 440, -40},
    { 872, 400, -104},
    { 1056, 376, -136},
    { 1232, 304, -112},
    { 1128, 216, -24},
    { 1104, 160, -16},
    { 1128, 128, -48},
    { 1128, 104, -32},
    { 960, 72, -32},
    // 11 seconds
    { 880, 72, -112},
    { 1048, 72, -136},
    { 952, 72, -216},
    { 976, 80, -320},
    { 960, 8, -312},
    { 736, 16, -304},
    { 736, 24, -392},
    { 1056, 96, -392},
    { 1168, 160, -200},
    { 968, 184, -160},
    { 816, 280, -176},
    { 792, 288, -176},
    { 864, 264, -136},
    { 944, 240, -56},
    { 960, 272, -64},
    { 1344, 320, -104},
    { 1368, 416, 24},
    { 1064, 528, 208},
    { 1264, 552, -24},
    { 936, 488, -24},
    { 720, 504, -72},
    { 856, 464, -80},
    { 1064, 440, -56},
    { 1016, 288, -48},
    { 992, 152, -48},
    // 12 seconds
    { 1128, 152, -144},
    { 1232, 184, -80},
    { 1216, 136, -56},
    { 1008, 72, -104},
    { 1056, 96, -152},
    { 1088, 128, -248},
    { 816, 112, -312},
    { 1096, 24, -192},
    { 928, 0, -144},
    { 760, 64, -144},
    { 960, 104, -264},
    { 1040, 136, -272},
    { 768, 144, -168},
    { 696, 96, -152},
    { 720, 96, -112},
    { 856, 128, -120},
    { 1016, 216, -120},
    { 1000, 272, -88},
    { 1392, 392, -112},
    { 1352, 608, -80},
    { 1112, 632, -128},
    { 1280, 480, -176},
    { 920, 496, -168},
    { 920, 424, -144},
    { 1104, 360, -152},
    // 13 seconds
    { 1120, 296, -112},
    { 960, 152, -24},
    { 936, 96, -40},
    { 1048, 120, -48},
    { 1120, 112, -40},
    { 1072, 96, -24},
    { 944, 72, -64},
    { 1064, 80, -160},
    { 952, 64, -208},
    { 856, -40, -184},
    { 1080, -24, -168},
    { 816, 56, -160},
    { 800, 144, -208},
    { 1032, 216, -352},
    { 1000, 184, -192},
    { 848, 128, -56},
    { 856, 136, -64},
    { 936, 160, -56},
    { 1056, 184, -64},
    { 1024, 224, -64},
    { 832, 320, -80},
    { 1200, 424, -96},
    { 1048, 520, -64},
    { 1344, 408, -104},
    { 1208, 400, -152},
    // 14 seconds
    { 888, 384, -104},
    { 1072, 304, -128},
    { 1288, 288, -96},
    { 1144, 160, -24},
    { 936, 72, 32},
    { 920, 112, -40},
    { 1000, 128, -32},
    { 1024, 104, 40},
    { 944, 104, 32},
    { 1048, 80, -16},
    { 1056, 88, -80},
    { 888, 8, -144},
    { 1176, -80, -8},
    { 816, -88, -24},
    { 712, 88, -152},
    { 1008, 264, -392},
    { 1104, 248, -400},
    { 928, 192, -160},
    { 784, 232, -216},
    { 784, 240, -232},
    { 808, 248, -192},
    { 816, 232, -176},
    { 848, 256, -128},
    { 1336, 312, -160},
    { 1384, 408, -72},
    // 15 seconds
    { 824, 472, 72},
    { 1384, 528, -248},
    { 1152, 520, -168},
    { 776, 400, -176},
    { 928, 376, -248},
    { 1192, 360, -208},
    { 1200, 248, -120},
    { 1104, 128, 0},
    { 1144, 224, -56},
    { 1176, 136, 8},
    { 1008, 56, 72},
    { 784, 24, -16},
    { 952, 40, -56},
    { 976, 80, -72},
    { 768, 48, -152},
    { 1192, 56, -120},
    { 936, 40, -96},
    { 744, 120, -184},
    { 984, 224, -408},
    { 1136, 248, -400},
    { 976, 216, -168},
    { 824, 224, -120},
    { 864, 288, -136},
    { 992, 296, -152},
    { 1008, 264, -112},
    // 16 seconds
    { 856, 240, -56},
    { 960, 280, -72},
    { 1160, 320, -32},
    { 888, 368, 48},
    { 1384, 456, -120},
    { 1312, 504, -144},
    { 920, 376, -128},
    { 952, 288, -200},
    { 1160, 312, -328},
    { 1024, 184, -192},
    { 880, 56, -8},
    { 824, 40, -40},
    { 928, 96, -80},
    { 1024, 144, -88},
    { 896, 104, 0},
    { 872, 88, -16},
    { 1096, 152, -104},
    { 984, 128, -88},
    { 1208, 112, -152},
    { 1128, 96, -160},
    { 824, 120, -208},
    { 848, 168, -392},
    { 1016, 200, -328},
    { 984, 128, -104},
    { 800, 136, -104},
    // 17 seconds
    { 760, 200, -240},
    { 760, 216, -192},
    { 792, 160, -160},
    { 848, 144, -120},
    { 800, 192, -128},
    { 880, 232, -160},
    { 1296, 328, -208},
    { 1064, 392, -88},
    { 1288, 536, -144},
    { 1272, 488, -224},
    { 808, 392, -168},
    { 872, 328, -168},
    { 1136, 288, -128},
    { 1096, 216, -48},
    { 920, 144, 0},
    { 976, 144, -24},
    { 1056, 160, -8},
    { 1080, 176, 24},
    { 928, 120, 56},
    { 872, 72, 0},
    { 1048, 40, -48},
    { 1008, 72, -88},
    { 1008, -48, -8},
    { 1040, -32, -64},
    { 952, 264, -216},
    // 18 seconds
    { 728, -136, -336},
    { 920, -120, -376},
    { 1072, -264, -232},
    { 1016, -272, -192},
    { 848, -112, -128},
    { 776, 8, -144},
    { 816, 160, -184},
    { 880, 216, -168},
    { 872, 224, -184},
    { 776, 144, -176},
    { 952, 160, -240},
    { 1320, 280, -288},
    { 1272, 288, -192},
    { 1600, 400, -208},
    { 984, 296, -216},
    { 760, 224, -168},
    { 928, 160, -152},
    { 1216, 112, -136},
    { 1008, 96, -88},
    { 888, 80, -40},
    { 944, 120, -48},
    { 1032, 104, -24},
    { 976, 88, -40},
    { 824, 88, -72},
    { 920, 88, -120},
    // 19 seconds
    { 1056, 104, -240},
    { 816, 24, -248},
    { 1168, -80, -64},
    { 1024, -32, -104},
    { 808, 64, -168},
    { 1056, 160, -304},
    { 1032, 192, -240},
    { 832, 88, -128},
    { 816, 64, -128},
    { 896, 144, -104},
    { 1032, 248, -80},
    { 1056, 240, -88},
    { 896, 272, -64},
    { 1144, 312, -96},
    { 1056, 408, 56},
    { 1152, 528, -120},
    { 1600, 528, -176},
    { 912, 376, -128},
    { 840, 272, -160},
    { 1072, 272, -256},
    { 1216, 192, -240},
    { 1048, 16, -64},
    { 976, 8, -40},
    { 1064, 120, -112},
    { 1144, 184, -104},
    // 20 seconds
    { 864, 104, -96},
    { 928, 96, -168},
    { 1112, 8, -312},
    { 1000, -144, -120},
    { 1056, -160, 80},
    { 944, -8, -112},
    { 1064, 104, -112},
    { 1192, 208, -216},
    { 960, 184, -184},
    { 744, 136, -104},
    { 776, 160, -112},
    { 976, 248, -80},
    { 1144, 280, -56},
    { 1048, 312, -72},
    { 1136, 384, -88},
    { 1280, 528, -96},
    { 816, 544, -80},
    { 1224, 472, -96},
    { 1344, 464, -96},
    { 864, 352, -136},
    { 968, 336, -160},
    { 1352, 304, -128},
    { 1312, 232, -136},
    { 1192, 64, 40},
    { 1176, 72, 16},
    // 21 seconds
    { 1152, 112, -72},
    { 984, 96, -72},
    { 792, 72, -80},
    { 920, 88, -152},
    { 920, 40, -168},
    { 760, -16, -224},
    { 968, -64, -88},
    { 880, 0, -208},
    { 1000, 72, -256},
    { 1416, 184, -320},
    { 1232, 216, -192},
    { 808, 160, -88},
    { 792, 224, -120},
    { 904, 216, -104},
    { 1032, 152, -32},
    { 1032, 208, 24},
    { 968, 232, 24},
    { 1408, 360, -16},
    { 1216, 504, 368},
    { 976, 624, -72},
    { 1176, 384, -32},
    { 1008, 520, -56},
    { 824, 448, -112},
    { 920, 424, -144},
    { 1056, 384, -128},
    // 22 seconds
    { 1096, 336, -120},
    { 1128, 272, 112},
    { 1304, 376, 24},
    { 1464, 560, 40},
    { 1368, 656, 64},
    { 1176, 656, 24},
    { 1104, 536, -192},
    { 1128, 432, -296},
    { 896, 248, -456},
    { 752, 0, -536},
    { 616, 0, -664},
    { 432, -80, -704},
    { 448, -104, -720},
    { 336, -56, -752},
    { 216, -80, -864},
    { 104, -80, -864},
    { -112, -8, -864},
    { -224, -48, -888},
    { -312, -80, -904},
    { -336, -120, -864},
    { -432, -136, -808},
    { -400, -40, -968},
    { -320, -8, -1048},
    { -520, 128, -1088},
    { -240, 416, -1272},
    // 23 seconds
    { -184, 264, -1104},
    { -288, 224, -944},
    { -272, 304, -1008},
    { -136, 168, -992},
    { -128, 88, -896},
    { -184, 32, -872},
    { -200, 0, -912},
    { -144, -48, -936},
    { -104, -72, -928},
    { -176, -112, -1008},
    { -104, -136, -1064},
    { -168, -104, -976},
    { -256, -88, -1088},
    { -16, -8, -1232},
    { 32, 0, -1072},
    { -8, 56, -928},
    { 24, -144, -808},
    { 104, -24, -696},
    { 136, 456, -448},
    { -40, 768, -432},
    { -120, 968, -200},
    { -104, 904, 8},
    { -112, 872, 16},
    { -208, 912, 312},
    { -400, 1000, 624},
    // 24 seconds
    { -280, 1000, 952},
    { -384, 768, 1032},
    { -296, 616, 1288},
    { -216, 536, 1096},
    { -288, 368, 880},
    { -392, 304, 880},
    { -384, 408, 872},
    { -288, 504, 832},
    { -296, 552, 592},
    { -304, 536, 424},
    { -248, 504, 264},
    { -104, 544, 152},
    { 112, 456, 176},
    { 520, 440, 184},
    { 1056, 568, 144},
    { 1256, 392, 40},
    { 1824, 272, 248},
    { 1720, 368, 312},
    { 1464, 464, 112},
    { 1240, 360, 104},
    { 1096, 280, 168},
    { 1008, 248, 96},
    { 936, 248, 96},
    { 944, 280, 104},
    { 968, 296, 120},
    // 25 seconds
    { 1008, 344, 104},
    { 912, 424, 112},
    { 952, 544, 184},
    { 1152, 680, 440},
    { 720, 416, 128},
    { 1216, 464, 168},
    { 1216, 528, 256},
    { 1040, 368, 200},
    { 1168, 336, 104},
    { 1400, 256, 136},
    { 1248, 208, 136},
    { 1224, 144, 88},
    { 1272, 160, 88},
    { 1296, 144, 120},
    { 1176, 152, 112},
    { 952, 136, 32},
    { 960, 184, -64},
    { 952, 272, -224},
    { 744, 104, -264},
    { 1000, 96, -128},
    { 848, 128, -104},
    { 888, 224, -104},
    { 1232, 312, -144},
    { 1232, 304, 0},
    { 1032, 296, 80},
    // 26 seconds
    { 952, 320, 56},
    { 1024, 336, 48},
    { 1208, 352, 96},
    { 1136, 320, 128},
    { 1168, 344, 144},
    { 1464, 408, 280},
    { 1008, 456, 616},
    { 1160, 496, 328},
    { 1104, 464, 296},
    { 792, 440, 192},
    { 944, 456, 168},
    { 1176, 440, 144},
    { 1184, 328, 88},
    { 1152, 224, -32},
    { 1216, 128, 40},
    { 1296, 184, 72},
    { 1320, 200, 56},
    { 1120, 136, 8},
    { 1000, 80, 8},
    { 1128, 128, -96},
    { 816, 96, -232},
    { 832, 16, -208},
    { 1016, 24, -136},
    { 888, 40, -112},
    { 984, 208, -184},
    // 27 seconds
    { 1208, 288, -272},
    { 1080, 280, -136},
    { 896, 248, -104},
    { 864, 280, -96},
    { 992, 312, -104},
    { 1152, 336, -72},
    { 1032, 392, -32},
    { 1104, 464, 24},
    { 1320, 632, 152},
    { 872, 464, 96},
    { 1296, 520, 80},
    { 1216, 560, 96},
    { 952, 432, -8},
    { 1048, 408, 0},
    { 1288, 448, -32},
    { 1248, 336, 48},
    { 1152, 192, 120},
    { 1144, 216, 64},
    { 1200, 272, 64},
    { 1136, 240, 56},
    { 944, 120, 48},
    { 912, 64, -8},
    { 864, 64, -96},
    { 728, 0, -176},
    { 1032, 8, -176},
    // 28 seconds
    { 1008, -16, -224},
    { 992, 48, -264},
    { 1336, 160, -392},
    { 1344, 200, -288},
    { 1088, 240, -128},
    { 928, 280, -176},
    { 912, 296, -160},
    { 976, 296, -56},
    { 1064, 264, -16},
    { 936, 288, 0},
    { 1104, 360, -56},
    { 1232, 448, 112},
    { 1032, 616, 40},
    { 1256, 608, -48},
    { 904, 536, -128},
    { 856, 464, -136},
    { 1000, 416, -80},
    { 1208, 344, -64},
    { 1136, 232, -40},
    { 1112, 136, 8},
    { 1184, 168, -40},
    { 1264, 152, -56},
    { 1232, 160, -32},
    { 1088, 96, -64},
    { 1048, 48, -144},
    // 29 seconds
    { 1016, 48, -296},
    { 760, -48, -336},
    { 1048, -88, -232},
    { 944, -112, -248},
    { 888, -8, -208},
    { 1152, 112, -264},
    { 1224, 176, -216},
    { 1016, 168, -80},
    { 936, 176, -72},
    { 984, 224, -64},
    { 1096, 296, -40},
    { 1168, 336, -24},
    { 1008, 400, -64},
    { 1272, 520, -104},
    { 1240, 720, 24},
    { 1216, 680, 56},
    { 1264, 648, -16},
    { 928, 456, -80},
    { 1040, 504, -96},
    { 1272, 376, -48},
    { 1360, 240, -80},
    { 1184, 88, 32},
    { 1136, 104, 0},
    { 1136, 120, -48},
    { 1104, 120, -48},
    // 30 seconds
    { 1064, 128, 16},
    { 984, 64, -48},
    { 1120, 128, -192},
    { 904, 72, -304},
    { 984, 32, -256},
    { 1072, 8, -200},
    { 856, 56, -176},
    { 888, 184, -280},
    { 1200, 240, -320},
    { 1200, 256, -160},
    { 992, 248, -64},
    { 928, 320, -136},
    { 928, 344, -144},
    { 1032, 360, -96},
    { 1024, 360, -56},
    { 984, 376, -24},
    { 1272, 448, 104},
    { 1016, 576, 216},
    { 1296, 512, 152},
    { 1248, 560, 160},
    { 840, 432, 24},
    { 960, 416, -8},
    { 1208, 416, 0},
    { 1208, 352, -80},
    { 1160, 88, 72},
    // 31 seconds
    { 1168, 128, 88},
    { 1232, 176, -72},
    { 1152, 120, -96},
    { 1024, 64, -48},
    { 992, 120, -144},
    { 1080, 128, -288},
    { 800, -16, -328},
    { 1128, -96, -168},
    { 1032, -48, -152},
    { 984, 128, -200},
    { 1240, 232, -256},
    { 1208, 248, -160},
    { 976, 224, -72},
    { 928, 272, -88},
    { 936, 288, -24},
    { 1000, 296, 16},
    { 1064, 304, 48},
    { 976, 344, 32},
    { 1232, 360, 168},
    { 1104, 496, 152},
    { 920, 456, 136},
    { 1232, 544, 152},
    { 888, 528, 88},
    { 936, 440, 16},
    { 1104, 424, 0},
    // 32 seconds
    { 1184, 392, -16},
    { 1144, 288, -96},
    { 1200, 64, 32},
    { 1232, 120, 72},
    { 1272, 120, -16},
    { 1144, 144, -104},
    { 928, 88, -56},
    { 1136, 128, -152},
    { 856, 8, -208},
    { 1000, -64, -168},
    { 1120, -64, -32},
    { 880, 40, -80},
    { 1048, 176, -184},
    { 1160, 224, -240},
    { 1008, 216, -168},
    { 896, 208, -152},
    { 952, 264, -120},
    { 1016, 296, -64},
    { 1056, 336, -72},
    { 920, 368, -72},
    { 1096, 400, -56},
    { 1272, 472, 96},
    { 1000, 664, 32},
    { 1344, 608, 16},
    { 968, 544, -88},
    // 33 seconds
    { 928, 560, -128},
    { 1120, 408, -8},
    { 1288, 336, 48},
    { 1200, 256, 0},
    { 1176, 192, -8},
    { 1208, 232, 0},
    { 1232, 192, 24},
    { 1128, 96, 16},
    { 952, 80, -56},
    { 1040, 64, -168},
    { 968, -32, -280},
    { 856, -200, -248},
    { 1056, -200, -224},
    { 1040, -88, -240},
    { 1048, 24, -224},
    { 1240, 128, -280},
    { 1248, 200, -208},
    { 1104, 216, -88},
    { 1112, 232, -64},
    { 1184, 320, 8},
    { 1248, 392, 96},
    { 1160, 464, -8},
    { 1072, 544, -8},
    { 1232, 792, 104},
    { 904, 632, 144},
    // 34 seconds
    { 1080, 688, 80},
    { 1144, 616, 64},
    { 912, 512, 0},
    { 1176, 456, -8},
    { 1536, 384, 40},
    { 1648, 256, 56},
    { 1456, 96, 144},
    { 1440, 144, 72},
    { 1416, 160, 16},
    { 1264, 128, 40},
    { 1024, 72, -32},
    { 800, 48, -136},
    { 912, -8, -352},
    { 712, -160, -384},
    { 1000, -216, -288},
    { 1152, -208, -224},
    { 1096, -16, -216},
    { 1256, 136, -280},
    { 1352, 208, -232},
    { 1184, 208, -48},
    { 1120, 248, 16},
    { 1232, 296, 64},
    { 1400, 312, 128},
    { 1296, 336, 152},
    { 1168, 328, 144},
    // 35 seconds
    { 1360, 432, 200},
    { 1120, 816, 560},
    { 912, 648, 208},
    { 1104, 504, 360},
    { 944, 576, 160},
    { 976, 552, 128},
    { 1184, 392, 128},
    { 1352, 328, 48},
    { 1288, 296, 40},
    { 1432, 152, 8},
    { 1544, 144, 56},
    { 1536, 136, 48},
    { 1376, 120, -8},
    { 1184, 72, -32},
    { 1136, 56, -96},
    { 832, -64, -176},
    { 688, -144, -232},
    { 984, -160, -128},
    { 936, -88, -176},
    { 1016, -8, -144},
    { 1296, 144, -296},
    { 1288, 184, -208},
    { 1152, 216, -88},
    { 1160, 280, -80},
    { 1224, 336, 0},
    // 36 seconds
    { 1304, 384, 32},
    { 1160, 424, -8},
    { 1024, 488, -16},
    { 1272, 576, 96},
    { 944, 560, 184},
    { 1016, 560, 112},
    { 1168, 608, 184},
    { 920, 512, 48},
    { 1072, 448, 16},
    { 1288, 416, 16},
    { 1248, 360, 0},
    { 1224, 216, 8},
    { 1304, 176, 24},
    { 1376, 168, 88},
    { 1328, 136, 40},
    { 1120, 48, -24},
    { 928, 56, -48},
    { 1032, 24, -128},
    { 712, -64, -168},
    { 1040, -96, -88},
    { 976, -56, -120},
    { 976, 24, -184},
    { 1240, 88, -208},
    { 1264, 128, -192},
    { 984, 184, -184},
    // 37 seconds
    { 856, 192, -160},
    { 936, 232, -112},
    { 1056, 272, -88},
    { 1136, 320, -72},
    { 992, 352, -64},
    { 1320, 440, -32},
    { 1192, 560, 16},
    { 968, 472, 88},
    { 1336, 552, 8},
    { 1000, 408, -56},
    { 1040, 368, -16},
    { 1208, 376, -24},
    { 1240, 352, -72},
    { 1120, 120, 128},
    { 1040, -48, 88},
    { 1064, -64, -56},
    { 1208, 80, 8},
    { 1192, 184, 112},
    { 960, 64, 80},
    { 1024, 16, -88},
    { 872, 72, -120},
    { 768, 40, -152},
    { 960, -64, -112},
    { 944, -8, -120},
    { 1032, 48, -152},
    // 38 seconds
    { 1336, 208, -264},
    { 1136, 232, -176},
    { 808, 184, -128},
    { 744, 200, -144},
    { 848, 224, -152},
    { 1008, 200, -64},
    { 1120, 216, -16},
    { 1008, 264, -32},
    { 1280, 336, -88},
    { 1280, 528, -136},
    { 1056, 688, -192},
    { 1424, 544, -368},
    { 1096, 552, -232},
    { 1320, 328, -160},
    { 1672, 384, -120},
    { 1680, 304, 24},
    { 1488, 304, -72},
    { 1392, 312, -48},
    { 1120, 216, -72},
    { 856, 208, -216},
    { 704, 288, -392},
    { 544, 96, -496},
    { 424, 0, -600},
    { 384, 120, -760},
    { 208, -136, -664},
    // 39 seconds
    { 128, -144, -848},
    { 168, 80, -976},
    { 200, -152, -848},
    { 296, -80, -912},
    { 336, -32, -920},
    { 232, -72, -808},
    { 16, 48, -832},
    { -144, 104, -984},
    { -248, -24, -976},
    { -184, -120, -936},
    { -200, -24, -824},
    { -272, 424, -904},
    { -264, 384, -968},
    { -392, 664, -1016},
    { 0, 1240, -1144},
    { -120, 968, -904},
    { -200, 816, -736},
    { -248, 656, -680},
    { -88, 664, -656},
    { -184, 344, -616},
    { -256, 168, -528},
    { -224, 104, -424},
    { -72, 168, -384},
    { 176, 248, -352},
    { 576, 256, -256},
    // 40 seconds
    { 1320, 184, -56},
    { 1632, 208, 104},
    { 2168, 128, 256},
    { 2336, 328, 8},
    { 1976, 608, -176},
    { 1464, 440, 16},
    { 1120, 208, 224},
    { 936, -80, 0},
    { 984, 32, 24},
    { 1104, 216, 168},
    { 1136, 408, 144},
    { 976, 568, 32},
    { 744, 592, -72},
    { 944, 864, 128},
    { 936, 296, -104},
    { 992, 248, -64},
    { 1464, 568, -64},
    { 1336, 456, 8},
    { 1488, 320, 48},
    { 1680, 256, 88},
    { 1656, 208, 128},
    { 1416, -64, 216},
    { 1264, -64, 136},
    { 1224, -16, 64},
    { 1088, 120, 32},
    // 41 seconds
    { 896, 32, 64},
    { 832, 16, 8},
    { 816, 24, 0},
    { 656, 48, -104},
    { 816, -8, -88},
    { 856, 16, -64},
    { 856, 72, -144},
    { 1136, 96, -152},
    { 1656, 160, -280},
    { 1504, 216, -128},
    { 1056, 184, -40},
    { 1016, 288, -176},
    { 1128, 296, -216},
    { 1144, 312, -136},
    { 1008, 224, -32},
    { 1176, 312, -40},
    { 1328, 360, 160},
    { 1016, 520, 96},
    { 1048, 400, -24},
    { 1160, 632, -8},
    { 920, 584, -104},
    { 944, 448, -176},
    { 1056, 472, -192},
    { 1184, 448, -200},
    { 1304, 256, 144},
    // 42 seconds
    { 1240, 32, 168},
    { 1216, 192, -32},
    { 1128, 232, 8},
    { 888, 144, 40},
    { 848, 176, -24},
    { 1016, 176, -16},
    { 888, 144, -64},
    { 1112, 104, -32},
    { 1144, 120, -64},
    { 1032, 96, -288},
    { 1040, 80, -504},
    { 1016, 8, -496},
    { 816, -96, -552},
    { 720, -120, -616},
    { 648, 64, -528},
    { 744, 152, -352},
    { 768, 184, -280},
    { 840, 296, -240},
    { 1008, 392, -200},
    { 1320, 432, -120},
    { 1328, 528, -40},
    { 1392, 680, -80},
    { 1040, 472, 96},
    { 872, 480, -24},
    { 776, 352, -72},
    // 43 seconds
    { 896, 432, -200},
    { 960, 360, -120},
    { 944, 352, -104},
    { 992, 264, -32},
    { 1064, 176, 16},
    { 1048, 152, 32},
    { 1016, 120, -48},
    { 1112, -16, -144},
    { 1120, -224, 48},
    { 1208, -104, 104},
    { 896, 264, -200},
    { 1144, 176, -560},
    { 1240, 200, -320},
    { 912, 168, -144},
    { 1000, 104, -136},
    { 976, 112, -160},
    { 792, 128, -96},
    { 632, 184, -64},
    { 680, 200, -112},
    { 696, 192, -112},
    { 736, 200, -88},
    { 784, 248, -120},
    { 1072, 312, -160},
    { 1376, 424, -184},
    { 1008, 448, 0},
    // 44 seconds
    { 1512, 504, -240},
    { 1216, 480, -184},
    { 968, 272, -184},
    { 1240, 280, -240},
    { 1664, 280, -136},
    { 1432, 152, 64},
    { 1144, 232, 64},
    { 1112, 448, -8},
    { 1104, 416, 56},
    { 936, 400, 192},
    { 704, 456, 88},
    { 568, 496, 80},
    { 472, 536, 96},
    { 280, 688, 112},
    { 88, 744, 144},
    { 80, 896, 320},
    { 40, 1096, 416},
    { 88, 1048, 216},
    { 48, 792, 112},
    { 72, 816, 88},
    { 16, 824, 88},
    { -120, 696, 56},
    { -240, 696, 136},
    { -328, 728, 232},
    { -328, 912, 112},
    // 45 seconds
    { -392, 864, 264},
    { -480, 880, 416},
    { -384, 912, 552},
    { -400, 880, 512},
    { -376, 1040, 592},
    { -128, 1256, 552},
    { -112, 896, 280},
    { -80, 704, 216},
    { -24, 816, 224},
    { 16, 888, 152},
    { -80, 744, 40},
    { -152, 728, 8},
    { -200, 768, -48},
    { -240, 792, -112},
    { -280, 736, -232},
    { -224, 640, -256},
    { 16, 576, -136},
    { 440, 544, -184},
    { 1056, 504, -16},
    { 1664, 336, 200},
    { 1984, 472, 136},
    { 1848, 456, 56},
    { 1456, 336, 184},
    { 1160, 280, 64},
    { 1040, 304, -16},
    // 46 seconds
    { 1032, 272, 24},
    { 1064, 280, 112},
    { 984, 296, 120},
    { 984, 336, 88},
    { 936, 352, 24},
    { 1104, 392, 64},
    { 1168, 440, 128},
    { 960, 480, 104},
    { 1176, 616, 152},
    { 1040, 648, 56},
    { 840, 472, -48},
    { 1048, 440, -32},
    { 1456, 360, -32},
    { 1672, 208, -72},
    { 1504, -16, 152},
    { 1336, -64, 16},
    { 1176, 32, -96},
    { 1000, 80, -136},
    { 840, 32, -104},
    { 816, 56, -136},
    { 944, 96, -176},
    { 864, 96, -256},
    { 1096, 72, -272},
    { 1152, 40, -160},
    { 1120, 88, -232},
    // 47 seconds
    { 1088, 136, -168},
    { 1128, 216, -168},
    { 1072, 232, -160},
    { 952, 240, -160},
    { 944, 200, -80},
    { 1016, 208, -8},
    { 1032, 224, 40},
    { 1072, 264, 72},
    { 992, 320, -16},
    { 1176, 336, 16},
    { 1312, 432, 120},
    { 936, 488, 72},
    { 1104, 496, 88},
    { 1096, 568, 144},
    { 800, 464, 8},
    { 952, 400, 0},
    { 1184, 336, 32},
    { 1448, 240, 48},
    { 1408, 64, 32},
    { 1360, -72, 56},
    { 1344, -8, -32},
    { 1248, -80, -88},
    { 1032, -32, -96},
    { 864, -32, -168},
    { 920, -40, -232},
    // 48 seconds
    { 944, -24, -328},
    { 904, -48, -360},
    { 1176, -56, -264},
    { 1072, 0, -280},
    { 984, 24, -256},
    { 1184, 88, -168},
    { 1168, 144, -104},
    { 984, 152, -56},
    { 960, 144, -32},
    { 960, 192, -8},
    { 1032, 176, -16},
    { 1128, 192, -48},
    { 984, 216, -72},
    { 1360, 304, -96},
    { 1344, 584, 128},
    { 904, 744, -168},
    { 1088, 560, -176},
    { 864, 608, -192},
    { 840, 456, -72},
    { 1088, 440, -64},
    { 1312, 312, 8},
    { 1336, 208, 32},
    { 1288, 72, 56},
    { 1384, 40, 48},
    { 1424, 72, -8},
    // 49 seconds
    { 1288, 16, 0},
    { 1144, 48, -48},
    { 1120, 48, -160},
    { 1072, -64, -312},
    { 800, -248, -264},
    { 1096, -232, -296},
    { 1040, -160, -304},
    { 1080, -40, -216},
    { 1168, -8, -160},
    { 1192, 32, -80},
    { 1088, 120, -56},
    { 1096, 168, -72},
    { 1136, 168, 8},
    { 1224, 200, 48},
    { 1296, 304, -8},
    { 1144, 440, -80},
    { 1200, 640, -56},
    { 1216, 568, -80},
    { 1016, 440, 48},
    { 1264, 632, -32},
    { 1016, 512, -112},
    { 1032, 416, -48},
    { 1280, 360, 72},
    { 1552, 200, 152},
    { 1464, 64, 184},
    // 50 seconds
    { 1304, -192, 280},
    { 1208, -280, 104},
    { 1192, -184, 32},
    { 1176, 16, 64},
    { 1096, 56, 64},
    { 1160, 16, 16},
    { 1016, 16, -32},
    { 824, -24, -184},
    { 1096, -112, -152},
    { 928, 0, -280},
    { 800, -40, -304},
    { 936, -16, -248},
    { 1136, 64, -312},
    { 1024, 112, -200},
    { 920, 128, -120},
    { 968, 104, -112},
    { 1040, 128, -104},
    { 1104, 216, -112},
    { 1056, 288, -152},
    { 1256, 328, -144},
    { 1408, 456, -48},
    { 960, 472, -120},
    { 1336, 576, -80},
    { 1096, 520, -48},
    { 960, 384, -136},
    // 51 seconds
    { 1048, 376, -128},
    { 1232, 320, -104},
    { 1208, 152, -40},
    { 1104, -144, 80},
    { 1064, -224, -64},
    { 1152, -32, -40},
    { 1128, 32, -56},
    { 1104, 64, 24},
    { 1176, 64, -24},
    { 1272, 72, -72},
    { 1000, 72, -144},
    { 1144, 48, -160},
    { 968, 0, -216},
    { 784, 16, -264},
    { 816, 0, -288},
    { 944, 48, -240},
    { 912, 96, -216},
    { 872, 128, -176},
    { 896, 120, -200},
    { 1000, 120, -264},
    { 1024, 152, -240},
    { 1016, 168, -216},
    { 1112, 256, -40},
    { 1304, 400, 40},
    { 992, 368, 0},
    // 52 seconds
    { 1264, 368, 64},
    { 1176, 504, 96},
    { 1000, 352, 0},
    { 968, 296, -16},
    { 1064, 304, -32},
    { 960, 232, -64},
    { 952, 104, 40},
    { 1040, -64, 8},
    { 1120, -64, 40},
    { 1072, -16, -16},
    { 1032, -16, -40},
    { 1088, 40, -48},
    { 1216, 40, -56},
    { 1088, 72, -144},
    { 1176, -176, -248},
    { 1184, -240, -152},
    { 1144, -88, -296},
    { 1200, -112, -208},
    { 1160, -16, -168},
    { 912, 40, -168},
    { 776, 80, -136},
    { 784, 104, -80},
    { 792, 160, -40},
    { 824, 208, -96},
    { 880, 248, -232},
    // 53 seconds
    { 984, 280, -376},
    { 1344, 216, -280},
    { 1200, 248, -208},
    { 1272, 336, -80},
    { 1056, 584, -160},
    { 792, 384, -128},
    { 904, 352, 16},
    { 1176, 280, 80},
    { 1296, 208, 56},
    { 1192, 168, 48},
    { 1160, 48, 24},
    { 1216, 16, -32},
    { 1240, -16, -48},
    { 1128, -56, -112},
    { 1008, -88, -120},
    { 1056, 32, -136},
    { 1136, 72, -200},
    { 952, 72, -232},
    { 1128, 16, -240},
    { 976, 16, -168},
    { 928, 40, -240},
    { 1136, 112, -216},
    { 1152, 144, -144},
    { 912, 64, -64},
    { 776, 88, -32},
    // 54 seconds
    { 800, 192, -96},
    { 896, 208, -72},
    { 928, 200, -16},
    { 944, 168, -64},
    { 1208, 168, 0},
    { 1376, 296, 56},
    { 1048, 408, -16},
    { 1432, 560, 8},
    { 1200, 960, -72},
    { 704, 328, -192},
    { 736, 512, -136},
    { 984, 488, -88},
    { 1120, 360, -88},
    { 1104, 168, 32},
    { 1160, -32, 72},
    { 1184, -56, 40},
    { 1208, 72, 40},
    { 1160, 80, 16},
    { 1040, 56, -8},
    { 1160, 56, 32},
    { 920, 88, -56},
    { 920, 72, -176},
    { 1080, 64, -168},
    { 912, 40, -216},
    { 960, 32, -232},
    // 55 seconds
    { 1120, 48, -224},
    { 1008, 88, -160},
    { 744, 96, -168},
    { 696, 120, -144},
    { 776, 128, -128},
    { 880, 112, -96},
    { 960, 128, -88},
    { 992, 192, -72},
    { 1352, 256, -104},
    { 1488, 392, -120},
    { 1176, 488, 112},
    { 1400, 472, -288},
    { 776, 368, -208},
    { 712, 296, -176},
    { 960, 336, -160},
    { 1240, 216, -120},
    { 1016, 160, -48},
    { 1024, -40, -16},
    { 1056, -32, 8},
    { 1144, -8, -40},
    { 1088, 48, -48},
    { 1016, 8, -24},
    { 1112, 48, -64},
    { 1040, 56, -120},
    { 944, 56, -240},
    // 56 seconds
    { 1216, -16, -184},
    { 1040, -16, -280},
    { 912, -40, -264},
    { 984, 0, -240},
    { 936, 56, -192},
    { 776, 80, -152},
    { 752, 88, -128},
    { 792, 96, -72},
    { 864, 112, -32},
    { 1016, 152, 0},
    { 1072, 216, -96},
    { 1280, 288, -152},
    { 1640, 456, -120},
    { 1096, 720, 232},
    { 1384, 368, -200},
    { 1016, 472, -208},
    { 824, 488, -128},
    { 928, 432, -48},
    { 1200, 248, -56},
    { 1232, 152, -8},
    { 1120, 40, 48},
    { 1160, -8, 24},
    { 1232, 24, -24},
    { 1272, 96, 56},
    { 1096, 32, 32},
    // 57 seconds
    { 1128, 8, 16},
    { 1168, 16, -80},
    { 848, 24, -176},
    { 1056, 24, -176},
    { 880, 0, -256},
    { 800, 40, -232},
    { 1008, 112, -256},
    { 1136, 168, -248},
    { 920, 136, -128},
    { 760, 96, -64},
    { 808, 120, -64},
    { 904, 176, -80},
    { 1016, 216, -56},
    { 1024, 240, -112},
    { 1344, 304, -136},
    { 1464, 456, -184},
    { 992, 640, -32},
    { 1416, 352, -280},
    { 992, 448, -232},
    { 792, 392, -176},
    { 912, 280, -168},
    { 1192, 272, -104},
    { 1192, 200, -8},
    { 1080, 56, 112},
    { 1112, 8, 56},
    // 58 seconds
    { 1208, 120, 16},
    { 1224, 176, 64},
    { 1184, 80, 96},
    { 1088, 56, 104},
    { 1128, 80, 24},
    { 904, 96, -16},
    { 1032, 88, -48},
    { 880, 112, -160},
    { 736, 144, -224},
    { 920, 216, -328},
    { 1240, 424, -464},
    { 1056, 424, -368},
    { 824, 456, -456},
    { 736, 816, -528},
    { 560, 856, -464},
    { 240, 920, -368},
    { -16, 1080, -232},
    { -224, 1024, 32},
    { -224, 1208, 144},
    { -176, 1080, 168},
    { 152, 1296, 264},
    { 216, 1096, 320},
    { 248, 1176, 384},
    { 224, 1160, 352},
    { 256, 1008, 152},
    // 59 seconds
    { 256, 872, -120},
    { 112, 672, -240},
    { 48, 344, -240},
    { 72, 88, -176},
    { 248, -8, -256},
    { 520, -24, -480},
    { 928, 8, -504},
    { 1120, 72, -256},
    { 1624, 288, -88},
    { 1912, 208, 56},
    { 1824, 400, -24},
    { 1600, 624, -248},
    { 1248, 560, -120},
    { 1040, 312, -40},
    { 1000, 136, -72},
    { 1048, 136, -24},
    { 1120, 128, 16},
    { 1072, 192, 48},
    { 984, 352, -56},
    { 952, 424, -160},
    { 1256, 640, -192},
    { 824, 568, -152},
    { 1336, 416, -176},
    { 1128, 480, -200},
    { 1008, 368, -104},
    // 60 seconds
    // elapsed: 1 minutes
    { 1256, 296, -48},
    { 1528, 248, 8},
    { 1392, 80, 80},
    { 1248, 8, 168},
    { 1368, -16, 8},
    { 1344, 56, 112},
    { 1376, 168, 152},
    { 1088, 256, 24},
    { 1024, 184, -56},
    { 904, 152, -144},
    { 608, 56, -200},
    { 736, -32, -216},
    { 736, 8, -256},
    { 736, -56, -280},
    { 1112, -24, -288},
    { 1496, 88, -320},
    { 1336, 232, -200},
    { 1088, 264, -96},
    { 1056, 304, -144},
    { 1096, 320, -64},
    { 1168, 272, 8},
    { 1104, 304, 48},
    { 1312, 344, 80},
    { 1240, 424, 168},
    { 960, 520, 64},
    // 61 seconds
    { 1328, 672, 80},
    { 776, 488, -56},
    { 776, 472, -144},
    { 1032, 472, -80},
    { 1216, 424, -56},
    { 1136, 280, -32},
    { 1240, 152, 16},
    { 1392, 56, 48},
    { 1448, 72, 64},
    { 1320, 96, 40},
    { 1112, 64, 0},
    { 1000, 96, -16},
    { 1016, 280, 32},
    { 888, 416, -56},
    { 992, 464, -192},
    { 976, 728, -224},
    { 696, 976, -504},
    { 520, 904, -600},
    { 448, 640, -584},
    { 256, 528, -624},
    { 80, 656, -728},
    { -48, 536, -688},
    { -152, 576, -584},
    { -136, 424, -696},
    { 0, 312, -776},
    // 62 seconds
    { 112, 320, -864},
    { 136, 256, -904},
    { 72, 160, -952},
    { 104, 40, -1000},
    { 16, 120, -984},
    { -40, 176, -968},
    { -72, 184, -976},
    { -96, 168, -928},
    { -160, 184, -904},
    { -160, 208, -920},
    { -144, 176, -928},
    { -144, 168, -928},
    { -64, 176, -984},
    { -8, 168, -1048},
    { -56, 128, -1024},
    { -88, 96, -1032},
    { -88, 64, -1064},
    { -72, 32, -1040},
    { -80, 48, -1064},
    { -176, 56, -1000},
    { -64, -16, -1000},
    { -112, -136, -1008},
    { 24, -32, -1024},
    { -16, -40, -1008},
    { -40, -104, -1024},
    // 63 seconds
    { -32, -144, -1008},
    { 8, -160, -992},
    { -24, -128, -1040},
    { -8, -136, -1040},
    { 0, -128, -1040},
    { 8, -136, -1080},
    { 56, -136, -1088},
    { 48, -112, -1096},
    { 48, -136, -1048},
    { 24, -168, -1008},
    { 0, -176, -984},
    { -8, -184, -984},
    { -8, -176, -1008},
    { 0, -160, -1008},
    { 0, -176, -1048},
    { -32, -120, -1024},
    { -32, -176, -1016},
    { -56, -144, -1016},
    { -48, -128, -1000},
    { -8, -144, -1032},
    { 0, -160, -1032},
    { 8, -136, -1040},
    { 32, -152, -1024},
    { 8, -152, -1008},
    { 32, -184, -992},
    // 64 seconds
    { 48, -136, -1000},
    { 16, -168, -1024},
    { 24, -144, -1032},
    { 8, -160, -1048},
    { -24, -168, -1032},
    { 16, -168, -1024},
    { 8, -152, -1024},
    { 24, -152, -1024},
    { 32, -144, -1032},
    { 24, -136, -1024},
    { 0, -144, -1024},
    { 16, -128, -1024},
    { 16, -168, -1040},
    { 32, -160, -1024},
    { 40, -168, -1008},
    { 40, -200, -1008},
    { 168, -112, -1048},
    { 64, -160, -1040},
    { 8, -136, -1032},
    { -32, -152, -1032},
    { -24, -152, -1016},
    { -24, -144, -1016},
    { -16, -152, -1032},
    { -24, -144, -1024},
    { -24, -160, -1024},
    // 65 seconds
    { -48, -160, -1016},
    { -24, -168, -1024},
    { -8, -184, -1040},
    { -40, -184, -1032},
    { -32, -152, -1024},
    { -56, -152, -1016},
    { -48, -152, -1024},
    { 24, -144, -1080},
    { -24, -104, -1056},
    { -24, -136, -1032},
    { -32, -144, -1008},
    { -64, -136, -1000},
    { -32, -136, -1016},
    { -48, -120, -1008},
    { -32, -136, -1024},
    { -40, -144, -1024},
    { -32, -136, -1040},
    { -32, -144, -1040},
    { -48, -136, -1032},
    { -40, -136, -1032},
    { -32, -136, -1024},
    { -40, -136, -1032},
    { -48, -128, -1016},
    { -48, -136, -1032},
    { -48, -120, -1032},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

