/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured at: 2015-09-04 19:31:00 local, 2015-09-05 02:31:00 GMT
// According to Misfit:
//  sleep start: 11:06pm (offset 216)
//  wake: 4:20am (offset 529)
//  light sleep: 97 min
//  deep sleep: 218 min
//  total sleep: 315 min
//
// But, it looks like MIsfit didn't pick up on the 72 minute sleep session
// from 9:48pm to 10:53pm (offset 138 to 203, 65 min)
// Which had deep sleep of about 55 min
//
//
AlgDlsMinuteData *activity_sample_sleep_1(int *len) {  
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_1
  //> TEST_VERSION 2
  //> TEST_TOTAL 380
  //> TEST_TOTAL_MIN 360
  //> TEST_TOTAL_MAX 400
  //> TEST_DEEP 273
  //> TEST_DEEP_MIN 240
  //> TEST_DEEP_MAX 300
  //> TEST_START_AT 137
  //> TEST_START_AT_MIN 130
  //> TEST_START_AT_MAX 150
  //> TEST_END_AT 529
  //> TEST_END_AT_MIN 515
  //> TEST_END_AT_MAX 545
  //> TEST_CUR_STATE_ELAPSED 70
  //> TEST_CUR_STATE_ELAPSED_MIN 60
  //> TEST_CUR_STATE_ELAPSED_MAX 80
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: {  steps, orientation, vmc, light}
  static AlgDlsMinuteData samples[] = {  
    {  0, 0x74, 1269, 0x0},
    {  0, 0x64, 822, 0x0},
    {  7, 0x63, 2239, 0x0},
    {  0, 0x54, 5585, 0x0},
    {  8, 0x53, 5526, 0x0},
    {  6, 0x65, 5077, 0x0},
    {  9, 0x64, 2027, 0x0},
    {  40, 0x41, 7592, 0x0},
    {  12, 0x42, 8541, 0x0},
    {  12, 0x54, 9556, 0x0},
    {  0, 0x54, 7203, 0x0},
    {  6, 0x64, 6292, 0x0},
    {  6, 0x53, 3805, 0x0},
    {  12, 0x52, 7127, 0x0},
    {  0, 0x52, 3549, 0x0},
    // 15: Local time: 07:45:00 PM
    {  23, 0x52, 3177, 0x0},
    {  0, 0x62, 3922, 0x0},
    {  9, 0x65, 6005, 0x0},
    {  6, 0x64, 1139, 0x0},
    {  0, 0x41, 3184, 0x0},
    {  0, 0x42, 9815, 0x0},
    {  10, 0x52, 3559, 0x0},
    {  0, 0x43, 6958, 0x0},
    {  0, 0x63, 1638, 0x0},
    {  0, 0x67, 313, 0x0},
    {  0, 0x58, 303, 0x0},
    {  0, 0x57, 1673, 0x0},
    {  11, 0x52, 3692, 0x0},
    {  16, 0x53, 4885, 0x0},
    {  6, 0x52, 4215, 0x0},
    // 30: Local time: 08:00:00 PM
    {  0, 0x42, 2813, 0x0},
    {  0, 0x54, 4750, 0x0},
    {  0, 0x54, 3097, 0x0},
    {  23, 0x53, 5092, 0x0},
    {  18, 0x64, 5601, 0x0},
    {  0, 0x55, 3364, 0x0},
    {  0, 0x24, 1850, 0x0},
    {  0, 0x23, 993, 0x0},
    {  0, 0x25, 266, 0x0},
    {  0, 0x34, 1796, 0x0},
    {  0, 0x25, 2060, 0x0},
    {  11, 0x34, 3439, 0x0},
    {  20, 0x33, 3824, 0x0},
    {  51, 0x33, 3448, 0x0},
    {  0, 0x42, 10311, 0x0},
    // 45: Local time: 08:15:00 PM
    {  0, 0x44, 1074, 0x0},
    {  0, 0x44, 2711, 0x0},
    {  0, 0x45, 288, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 685, 0x0},
    {  0, 0x55, 1525, 0x0},
    {  0, 0x45, 0, 0x0},
    {  0, 0x45, 0, 0x0},
    {  0, 0x45, 0, 0x0},
    {  0, 0x45, 0, 0x0},
    {  0, 0x45, 0, 0x0},
    {  0, 0x55, 47, 0x0},
    {  0, 0x55, 14, 0x0},
    {  0, 0x55, 53, 0x0},
    {  0, 0x55, 0, 0x0},
    // 60: Local time: 08:30:00 PM
    {  0, 0x55, 48, 0x0},
    {  8, 0x55, 927, 0x0},
    {  0, 0x55, 5517, 0x0},
    {  0, 0x78, 1410, 0x0},
    {  0, 0x78, 54, 0x0},
    {  0, 0x78, 0, 0x0},
    {  0, 0x78, 0, 0x0},
    {  0, 0x69, 852, 0x0},
    {  0, 0x6a, 2502, 0x0},
    {  0, 0x78, 486, 0x0},
    {  0, 0x56, 1240, 0x0},
    {  0, 0x64, 580, 0x0},
    {  0, 0x75, 161, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    // 75: Local time: 08:45:00 PM
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x76, 103, 0x0},
    {  0, 0x86, 0, 0x0},
    {  0, 0x75, 180, 0x0},
    {  0, 0x65, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 13, 0x0},
    {  0, 0x75, 0, 0x0},
    // 90: Local time: 09:00:00 PM
    {  0, 0x75, 199, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x76, 377, 0x0},
    {  0, 0x76, 47, 0x0},
    {  0, 0x76, 66, 0x0},
    {  0, 0x76, 97, 0x0},
    {  0, 0x76, 164, 0x0},
    {  0, 0x65, 38, 0x0},
    {  0, 0x76, 519, 0x0},
    {  0, 0x6f, 2635, 0x0},
    {  0, 0x6f, 39, 0x0},
    {  0, 0x6f, 890, 0x0},
    // 105: Local time: 09:15:00 PM
    {  0, 0x70, 364, 0x0},
    {  0, 0x75, 0, 0x0},
    {  6, 0x85, 1184, 0x0},
    {  0, 0x78, 35, 0x0},
    {  0, 0x78, 0, 0x0},
    {  0, 0x79, 10, 0x0},
    {  0, 0x79, 0, 0x0},
    {  0, 0x79, 0, 0x0},
    {  0, 0x7a, 0, 0x0},
    {  0, 0x7a, 288, 0x0},
    {  0, 0x70, 0, 0x0},
    {  0, 0x7f, 0, 0x0},
    {  0, 0x7f, 146, 0x0},
    {  0, 0x7f, 0, 0x0},
    {  0, 0x7f, 202, 0x0},
    // 120: Local time: 09:30:00 PM
    {  20, 0x7f, 1093, 0x0},
    {  0, 0x7f, 0, 0x0},
    {  0, 0x60, 828, 0x0},
    {  0, 0x6f, 1444, 0x0},
    {  7, 0x64, 3683, 0x0},
    {  0, 0x66, 2122, 0x0},
    {  0, 0x76, 78, 0x0},
    {  0, 0x77, 814, 0x0},
    {  0, 0x6a, 0, 0x0},
    {  0, 0x6a, 0, 0x0},
    {  0, 0x6a, 0, 0x0},
    {  0, 0x6a, 988, 0x0},
    {  25, 0x72, 6494, 0x0},
    {  10, 0x43, 3466, 0x0},
    {  8, 0x51, 8006, 0x0},
    // 135: Local time: 09:45:00 PM
    {  0, 0x61, 1441, 0x0},
    {  0, 0x61, 19, 0x0},
    {  0, 0x14, 1750, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 14, 0x0},
    // 150: Local time: 10:00:00 PM
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    // 165: Local time: 10:15:00 PM
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    // 180: Local time: 10:30:00 PM
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    // 195: Local time: 10:45:00 PM
    {  0, 0x8, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x56, 648, 0x0},
    {  0, 0x76, 1018, 0x0},
    {  0, 0x76, 196, 0x0},
    {  0, 0x78, 671, 0x0},
    {  0, 0x78, 510, 0x0},
    {  0, 0x77, 143, 0x0},
    {  9, 0x73, 3714, 0x0},
    // 210: Local time: 11:00:00 PM
    {  17, 0x33, 5092, 0x0},
    {  0, 0x61, 6762, 0x0},
    {  38, 0x62, 3870, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 25, 0x0},
    {  0, 0x53, 294, 0x0},
    {  0, 0x24, 0, 0x0},
    {  0, 0x1f, 581, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    // 225: Local time: 11:15:00 PM
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    // 240: Local time: 11:30:00 PM
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    // 255: Local time: 11:45:00 PM
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    {  0, 0x1e, 0, 0x0},
    // 270: Local time: 12:00:00 AM
    {  0, 0x1e, 13, 0x0},
    {  0, 0x1e, 19, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 14, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 25, 0x0},
    // 285: Local time: 12:15:00 AM
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  0, 0x1f, 0, 0x0},
    {  6, 0x3f, 816, 0x0},
    {  0, 0x50, 0, 0x0},
    {  0, 0x61, 1218, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    // 300: Local time: 12:31:00 AM
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    // 315: Local time: 12:46:00 AM
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x7f, 1528, 0x0},
    {  0, 0x6d, 0, 0x0},
    {  0, 0x6d, 0, 0x0},
    {  0, 0x6d, 0, 0x0},
    {  0, 0x6d, 0, 0x0},
    {  0, 0x6d, 0, 0x0},
    {  0, 0x6d, 0, 0x0},
    {  0, 0x6d, 0, 0x0},
    {  0, 0x6d, 0, 0x0},
    {  0, 0x6d, 0, 0x0},
    {  0, 0x6d, 0, 0x0},
    // 330: Local time: 01:01:00 AM
    {  6, 0x7e, 703, 0x0},
    {  0, 0x8a, 711, 0x0},
    {  0, 0x86, 0, 0x0},
    {  0, 0x86, 50, 0x0},
    {  0, 0x73, 2739, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x64, 38, 0x0},
    // 345: Local time: 01:17:00 AM
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 19, 0x0},
    {  0, 0x73, 2125, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    // 360: Local time: 01:32:00 AM
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 287, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    // 375: Local time: 01:47:00 AM
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 0, 0x0},
    {  0, 0x72, 1031, 0x0},
    {  0, 0x7e, 0, 0x0},
    {  0, 0x7e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 17, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    // 390: Local time: 02:02:00 AM
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 10, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8e, 0, 0x0},
    {  6, 0x8e, 581, 0x0},
    // 405: Local time: 02:17:00 AM
    {  0, 0x8e, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    // 420: Local time: 02:32:00 AM
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 0, 0x0},
    {  0, 0x8d, 10, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    // 435: Local time: 02:47:00 AM
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8c, 0, 0x0},
    {  0, 0x8d, 938, 0x0},
    {  0, 0x0, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 42, 0x0},
    // 450: Local time: 03:01:00 AM
    {  0, 0x85, 0, 0x0},
    {  0, 0x85, 0, 0x0},
    {  0, 0x85, 0, 0x0},
    {  0, 0x85, 0, 0x0},
    {  0, 0x85, 0, 0x0},
    {  6, 0x42, 4670, 0x0},
    {  18, 0x42, 6374, 0x0},
    {  0, 0x6, 3547, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    // 465: Local time: 03:16:00 AM
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    // 480: Local time: 03:31:00 AM
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    // 495: Local time: 03:46:00 AM
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0x1c, 0, 0x0},
    {  0, 0xb, 76, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    // 510: Local time: 04:01:00 AM
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    // 525: Local time: 04:16:00 AM
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x4, 0, 0x0},
    {  0, 0x5, 429, 0x0},
    {  9, 0x12, 2735, 0x0},
    {  0, 0x32, 4817, 0x0},
    {  0, 0x60, 34, 0x0},
    {  0, 0x60, 0, 0x0},
    {  0, 0x60, 824, 0x0},
    {  0, 0x70, 1482, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 35, 0x0},
    // 540: Local time: 04:31:00 AM
    {  0, 0x60, 0, 0x0},
    {  0, 0x69, 2976, 0x0},
    {  0, 0x6a, 2994, 0x0},
    {  0, 0x78, 976, 0x0},
    {  0, 0x79, 771, 0x0},
    {  0, 0x69, 408, 0x0},
    {  0, 0x68, 0, 0x0},
    {  0, 0x68, 0, 0x0},
    {  0, 0x68, 436, 0x0},
    {  0, 0x68, 211, 0x0},
    {  0, 0x59, 235, 0x0},
    {  0, 0x66, 922, 0x0},
    {  0, 0x69, 2359, 0x0},
    {  0, 0x67, 1869, 0x0},
    {  0, 0x66, 874, 0x0},
    // 555: Local time: 04:46:00 AM
    {  0, 0x76, 125, 0x0},
    {  0, 0x75, 3099, 0x0},
    {  0, 0x6f, 32, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    // 570: Local time: 05:01:00 AM
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 1704, 0x0},
    {  0, 0x77, 217, 0x0},
    {  0, 0x78, 463, 0x0},
    {  0, 0x78, 183, 0x0},
    {  0, 0x79, 0, 0x0},
    {  0, 0x79, 1589, 0x0},
    {  0, 0x78, 615, 0x0},
    {  0, 0x69, 312, 0x0},
    {  0, 0x68, 0, 0x0},
    {  0, 0x68, 115, 0x0},
    {  0, 0x68, 341, 0x0},
    {  0, 0x69, 3892, 0x0},
    {  0, 0x59, 633, 0x0},
    // 585: Local time: 05:16:00 AM
    {  0, 0x77, 1540, 0x0},
    {  0, 0x76, 555, 0x0},
    {  0, 0x76, 54, 0x0},
    {  0, 0x76, 435, 0x0},
    {  11, 0x54, 4599, 0x0},
    {  7, 0x42, 6584, 0x0},
    {  24, 0x42, 4287, 0x0},
    {  0, 0x64, 3287, 0x0},
    {  0, 0x76, 1537, 0x0},
    {  0, 0x64, 603, 0x0},
    {  8, 0x75, 1598, 0x0},
    {  0, 0x74, 187, 0x0},
    {  0, 0x74, 537, 0x0},
    {  0, 0x74, 902, 0x0},
    {  0, 0x74, 819, 0x0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



// ----------------------------------------------------------------
// Sample captured at: 2015-09-04 19:31:00 local, 2015-09-05 02:31:00 GMT
// This sample should end in deep sleep mode
//
AlgDlsMinuteData *activity_sample_sleep_1_end_deep(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_1_end_deep
  //> TEST_VERSION 2
  //> TEST_TOTAL -1
  //> TEST_TOTAL_MIN -1
  //> TEST_TOTAL_MAX -1
  //> TEST_DEEP -1
  //> TEST_DEEP_MIN -1
  //> TEST_DEEP_MAX -1
  //> TEST_START_AT -1
  //> TEST_START_AT_MIN -1
  //> TEST_START_AT_MAX -1
  //> TEST_END_AT -1
  //> TEST_END_AT_MIN -1
  //> TEST_END_AT_MAX -1
  //> TEST_CUR_STATE_ELAPSED 68
  //> TEST_CUR_STATE_ELAPSED_MIN 60
  //> TEST_CUR_STATE_ELAPSED_MAX 80
  //> TEST_IN_SLEEP 1
  //> TEST_IN_SLEEP_MIN 1
  //> TEST_IN_SLEEP_MAX 1
  //> TEST_IN_DEEP_SLEEP 1
  //> TEST_IN_DEEP_SLEEP_MIN 1
  //> TEST_IN_DEEP_SLEEP_MAX 1
  //> TEST_WEIGHT 1.0
  // list of: {  steps, orientation, vmc, light}
  static AlgDlsMinuteData samples[] = {
    {  0, 0x74, 1269, 0x0},
    {  0, 0x64, 822, 0x0},
    {  7, 0x63, 2239, 0x0},
    {  0, 0x54, 5585, 0x0},
    {  8, 0x53, 5526, 0x0},
    {  6, 0x65, 5077, 0x0},
    {  9, 0x64, 2027, 0x0},
    {  40, 0x41, 7592, 0x0},
    {  12, 0x42, 8541, 0x0},
    {  12, 0x54, 9556, 0x0},
    {  0, 0x54, 7203, 0x0},
    {  6, 0x64, 6292, 0x0},
    {  6, 0x53, 3805, 0x0},
    {  12, 0x52, 7127, 0x0},
    {  0, 0x52, 3549, 0x0},
    // 15: Local time: 07:45:00 PM
    {  23, 0x52, 3177, 0x0},
    {  0, 0x62, 3922, 0x0},
    {  9, 0x65, 6005, 0x0},
    {  6, 0x64, 1139, 0x0},
    {  0, 0x41, 3184, 0x0},
    {  0, 0x42, 9815, 0x0},
    {  10, 0x52, 3559, 0x0},
    {  0, 0x43, 6958, 0x0},
    {  0, 0x63, 1638, 0x0},
    {  0, 0x67, 313, 0x0},
    {  0, 0x58, 303, 0x0},
    {  0, 0x57, 1673, 0x0},
    {  11, 0x52, 3692, 0x0},
    {  16, 0x53, 4885, 0x0},
    {  6, 0x52, 4215, 0x0},
    // 30: Local time: 08:00:00 PM
    {  0, 0x42, 2813, 0x0},
    {  0, 0x54, 4750, 0x0},
    {  0, 0x54, 3097, 0x0},
    {  23, 0x53, 5092, 0x0},
    {  18, 0x64, 5601, 0x0},
    {  0, 0x55, 3364, 0x0},
    {  0, 0x24, 1850, 0x0},
    {  0, 0x23, 993, 0x0},
    {  0, 0x25, 266, 0x0},
    {  0, 0x34, 1796, 0x0},
    {  0, 0x25, 2060, 0x0},
    {  11, 0x34, 3439, 0x0},
    {  20, 0x33, 3824, 0x0},
    {  51, 0x33, 3448, 0x0},
    {  0, 0x42, 10311, 0x0},
    // 45: Local time: 08:15:00 PM
    {  0, 0x44, 1074, 0x0},
    {  0, 0x44, 2711, 0x0},
    {  0, 0x45, 288, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 685, 0x0},
    {  0, 0x55, 1525, 0x0},
    {  0, 0x45, 0, 0x0},
    {  0, 0x45, 0, 0x0},
    {  0, 0x45, 0, 0x0},
    {  0, 0x45, 0, 0x0},
    {  0, 0x45, 0, 0x0},
    {  0, 0x55, 47, 0x0},
    {  0, 0x55, 14, 0x0},
    {  0, 0x55, 53, 0x0},
    {  0, 0x55, 0, 0x0},
    // 60: Local time: 08:30:00 PM
    {  0, 0x55, 48, 0x0},
    {  8, 0x55, 927, 0x0},
    {  0, 0x55, 5517, 0x0},
    {  0, 0x78, 1410, 0x0},
    {  0, 0x78, 54, 0x0},
    {  0, 0x78, 0, 0x0},
    {  0, 0x78, 0, 0x0},
    {  0, 0x69, 852, 0x0},
    {  0, 0x6a, 2502, 0x0},
    {  0, 0x78, 486, 0x0},
    {  0, 0x56, 1240, 0x0},
    {  0, 0x64, 580, 0x0},
    {  0, 0x75, 161, 0x0},
    {  0, 0x6a, 2502, 0x0},
    {  0, 0x78, 486, 0x0},
    // 75: Local time: 08:45:00 PM
    {  0, 0x6a, 2502, 0x0},
    {  0, 0x78, 486, 0x0},
    {  0, 0x6a, 2502, 0x0},
    {  0, 0x78, 486, 0x0},
    {  0, 0x6a, 2502, 0x0},
    {  0, 0x78, 486, 0x0},
    {  0, 0x6a, 2502, 0x0},
    {  0, 0x78, 486, 0x0},
    {  0, 0x6a, 2502, 0x0},
    {  0, 0x78, 486, 0x0},
    {  0, 0x6a, 2502, 0x0},
    {  0, 0x78, 486, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 13, 0x0},
    {  0, 0x75, 0, 0x0},
    // 90: Local time: 09:00:00 PM
    {  0, 0x75, 199, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x76, 377, 0x0},
    {  0, 0x76, 47, 0x0},
    {  0, 0x76, 66, 0x0},
    {  0, 0x76, 97, 0x0},
    {  0, 0x76, 164, 0x0},
    {  0, 0x65, 38, 0x0},
    {  0, 0x76, 519, 0x0},
    {  0, 0x6f, 2635, 0x0},
    {  0, 0x6f, 39, 0x0},
    {  0, 0x6f, 890, 0x0},
    // 105: Local time: 09:15:00 PM
    {  0, 0x70, 364, 0x0},
    {  0, 0x75, 0, 0x0},
    {  6, 0x85, 1184, 0x0},
    {  0, 0x78, 35, 0x0},
    {  0, 0x78, 0, 0x0},
    {  0, 0x79, 10, 0x0},
    {  0, 0x79, 0, 0x0},
    {  0, 0x79, 0, 0x0},
    {  0, 0x7a, 0, 0x0},
    {  0, 0x7a, 288, 0x0},
    {  0, 0x70, 0, 0x0},
    {  0, 0x7f, 0, 0x0},
    {  0, 0x7f, 146, 0x0},
    {  0, 0x7f, 0, 0x0},
    {  0, 0x7f, 202, 0x0},
    // 120: Local time: 09:30:00 PM
    {  20, 0x7f, 1093, 0x0},
    {  0, 0x7f, 0, 0x0},
    {  0, 0x60, 828, 0x0},
    {  0, 0x6f, 1444, 0x0},
    {  7, 0x64, 3683, 0x0},
    {  0, 0x66, 2122, 0x0},
    {  0, 0x76, 78, 0x0},
    {  0, 0x77, 814, 0x0},
    {  0, 0x6a, 0, 0x0},
    {  0, 0x6a, 0, 0x0},
    {  0, 0x6a, 0, 0x0},
    {  0, 0x6a, 988, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    // 135: Local time: 09:45:00 PM
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 14, 0x0},
    // 150: Local time: 10:00:00 PM
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    // 165: Local time: 10:15:00 PM
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    // 180: Local time: 10:30:00 PM
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    {  0, 0x8, 0, 0x0},
    // 195: Local time: 10:45:00 PM
    {  0, 0x8, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
    {  0, 0x9, 0, 0x0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured at: 2015-09-05 20:12:00 local, 2015-09-06 03:12:00 GMT
// According to Misfit:
//  start sleep: 9:45pm (offset 93)
//  total sleep: 547 min
//  deep sleep: 303 min
//  light: 244 min
//  wake: ?
AlgDlsMinuteData *activity_sample_sleep_2(int *len) { 
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_2
  //> TEST_VERSION 2
  //> TEST_TOTAL 547
  //> TEST_TOTAL_MIN 460
  //> TEST_TOTAL_MAX 570
  //> TEST_DEEP 303
  //> TEST_DEEP_MIN 270
  //> TEST_DEEP_MAX 350
  //> TEST_START_AT 93
  //> TEST_START_AT_MIN 84
  //> TEST_START_AT_MAX 100
  //> TEST_END_AT -1
  //> TEST_END_AT_MIN -1
  //> TEST_END_AT_MAX -1
  //> TEST_CUR_STATE_ELAPSED -1
  //> TEST_CUR_STATE_ELAPSED_MIN -1
  //> TEST_CUR_STATE_ELAPSED_MAX -1
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: {  steps, orientation, vmc, light}
  static AlgDlsMinuteData samples[] = { 
    {  0, 0x64, 57, 0x0},
    {  0, 0x64, 420, 0x0},
    {  0, 0x64, 778, 0x0},
    {  6, 0x56, 1768, 0x0},
    {  0, 0x65, 674, 0x0},
    {  0, 0x64, 254, 0x0},
    {  0, 0x64, 627, 0x0},
    {  0, 0x64, 550, 0x0},
    {  0, 0x65, 1198, 0x0},
    {  0, 0x57, 790, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 39, 0x0},
    {  8, 0x65, 642, 0x0},
    {  0, 0x65, 1342, 0x0},
    {  0, 0x64, 469, 0x0},
    // 15: Local time: 08:27:00 PM
    {  0, 0x83, 3583, 0x0},
    {  0, 0x80, 0, 0x0},
    {  0, 0x80, 0, 0x0},
    {  0, 0x80, 0, 0x0},
    {  0, 0x80, 0, 0x0},
    {  0, 0x80, 0, 0x0},
    {  0, 0x80, 19, 0x0},
    {  0, 0x80, 0, 0x0},
    {  0, 0x8f, 272, 0x0},
    {  14, 0x7f, 4022, 0x0},
    {  0, 0x81, 0, 0x0},
    {  0, 0x81, 0, 0x0},
    {  0, 0x81, 0, 0x0},
    {  0, 0x81, 0, 0x0},
    {  0, 0x81, 0, 0x0},
    // 30: Local time: 08:42:00 PM
    {  23, 0x72, 2671, 0x0},
    {  0, 0x74, 253, 0x0},
    {  0, 0x74, 198, 0x0},
    {  0, 0x64, 337, 0x0},
    {  0, 0x64, 1872, 0x0},
    {  0, 0x64, 328, 0x0},
    {  0, 0x55, 760, 0x0},
    {  0, 0x64, 1238, 0x0},
    {  0, 0x74, 972, 0x0},
    {  0, 0x64, 1034, 0x0},
    {  0, 0x64, 572, 0x0},
    {  28, 0x63, 2668, 0x0},
    {  0, 0x34, 1601, 0x0},
    {  0, 0x34, 4855, 0x0},
    {  6, 0x55, 7491, 0x0},
    // 45: Local time: 08:57:00 PM
    {  0, 0x65, 8202, 0x0},
    {  33, 0x52, 6387, 0x0},
    {  18, 0x52, 9258, 0x0},
    {  10, 0x41, 2698, 0x0},
    {  11, 0x51, 2706, 0x0},
    {  9, 0x55, 5626, 0x0},
    {  0, 0x54, 3130, 0x0},
    {  0, 0x54, 2270, 0x0},
    {  0, 0x42, 3578, 0x0},
    {  0, 0x54, 8899, 0x0},
    {  17, 0x52, 11187, 0x0},
    {  0, 0x52, 3546, 0x0},
    {  0, 0x53, 1432, 0x0},
    {  0, 0x64, 1366, 0x0},
    {  0, 0x73, 2733, 0x0},
    // 60: Local time: 09:12:00 PM
    {  7, 0x41, 3031, 0x0},
    {  0, 0x52, 6889, 0x0},
    {  22, 0x72, 3173, 0x0},
    {  12, 0x42, 3822, 0x0},
    {  0, 0x64, 572, 0x0},
    {  0, 0x64, 467, 0x0},
    {  0, 0x74, 652, 0x0},
    {  0, 0x64, 947, 0x0},
    {  0, 0x65, 1771, 0x0},
    {  0, 0x75, 507, 0x0},
    {  0, 0x64, 1065, 0x0},
    {  0, 0x42, 1573, 0x0},
    {  6, 0x41, 3600, 0x0},
    {  16, 0x20, 2982, 0x0},
    {  20, 0x41, 7851, 0x0},
    // 75: Local time: 09:27:00 PM
    {  58, 0x52, 5440, 0x0},
    {  0, 0x31, 2518, 0x0},
    {  35, 0x41, 6458, 0x0},
    {  7, 0x52, 8777, 0x0},
    {  7, 0x42, 4437, 0x0},
    {  9, 0x30, 2746, 0x0},
    {  9, 0x74, 8851, 0x0},
    {  0, 0x56, 407, 0x0},
    {  0, 0x57, 108, 0x0},
    {  17, 0x57, 463, 0x0},
    {  0, 0x57, 143, 0x0},
    {  0, 0x56, 0, 0x0},
    {  0, 0x56, 0, 0x0},
    {  0, 0x46, 0, 0x0},
    {  0, 0x46, 81, 0x0},
    // 90: Local time: 09:42:00 PM
    {  0, 0x56, 16, 0x0},
    {  0, 0x56, 0, 0x0},
    {  0, 0x56, 26, 0x0},
    {  0, 0x56, 2280, 0x0},
    {  0, 0x67, 473, 0x0},
    {  0, 0x65, 586, 0x0},
    {  0, 0x51, 1858, 0x0},
    {  0, 0x51, 0, 0x0},
    {  0, 0x51, 0, 0x0},
    {  9, 0x62, 883, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    // 105: Local time: 09:57:00 PM
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    // 120: Local time: 10:12:00 PM
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 412, 0x0},
    {  0, 0x62, 109, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    // 135: Local time: 10:27:00 PM
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x62, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    // 150: Local time: 10:42:00 PM
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x63, 0, 0x0},
    {  0, 0x61, 899, 0x0},
    // 165: Local time: 10:57:00 PM
    {  0, 0x60, 0, 0x0},
    {  0, 0x60, 383, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  8, 0x52, 5063, 0x0},
    {  0, 0x23, 3745, 0x0},
    {  0, 0x13, 4685, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x5, 37, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    // 180: Local time: 11:12:00 PM
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    // 195: Local time: 11:27:00 PM
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x5, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    // 210: Local time: 11:42:00 PM
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    // 225: Local time: 11:57:01 PM
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x6, 0, 0x0},
    {  0, 0x16, 381, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    // 240: Local time: 12:12:00 AM
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 16, 0x0},
    {  0, 0x16, 37, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 13, 0x0},
    {  0, 0x65, 731, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    // 255: Local time: 12:27:00 AM
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 54, 0x0},
    {  0, 0x75, 11, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    // 270: Local time: 12:43:00 AM
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    // 285: Local time: 12:58:00 AM
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    // 300: Local time: 01:13:00 AM
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x75, 0, 0x0},
    {  0, 0x46, 457, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    // 315: Local time: 01:28:00 AM
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 14, 0x0},
    {  0, 0x15, 0, 0x0},
    {  0, 0x15, 0, 0x0},
    // 330: Local time: 01:43:00 AM
    {  0, 0x35, 1185, 0x0},
    {  0, 0x87, 0, 0x0},
    {  0, 0x7c, 96, 0x0},
    {  0, 0x7c, 0, 0x0},
    {  0, 0x7c, 0, 0x0},
    {  0, 0x7c, 0, 0x0},
    {  0, 0x70, 5166, 0x0},
    {  0, 0x12, 1653, 0x0},
    {  0, 0x26, 2603, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    // 345: Local time: 01:58:00 AM
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    // 360: Local time: 02:13:00 AM
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    // 375: Local time: 02:28:00 AM
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x16, 0, 0x0},
    {  0, 0x45, 352, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    // 390: Local time: 02:43:01 AM
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 222, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 156, 0x0},
    {  0, 0x55, 0, 0x0},
    // 405: Local time: 02:58:00 AM
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    // 420: Local time: 03:13:00 AM
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 10, 0x0},
    {  0, 0x26, 232, 0x0},
    {  0, 0x26, 0, 0x0},
    {  0, 0x26, 0, 0x0},
    {  0, 0x26, 0, 0x0},
    {  0, 0x26, 0, 0x0},
    {  0, 0x26, 0, 0x0},
    {  0, 0x37, 1645, 0x0},
    {  0, 0x67, 0, 0x0},
    {  0, 0x67, 121, 0x0},
    {  0, 0x64, 2960, 0x0},
    {  0, 0x63, 66, 0x0},
    {  0, 0x73, 671, 0x0},
    {  0, 0x73, 0, 0x0},
    // 435: Local time: 03:28:00 AM
    {  0, 0x73, 0, 0x0},
    {  0, 0x73, 248, 0x0},
    {  0, 0x24, 0, 0x0},
    {  0, 0x24, 0, 0x0},
    {  0, 0x24, 0, 0x0},
    {  0, 0x24, 0, 0x0},
    {  0, 0x24, 0, 0x0},
    {  0, 0x24, 0, 0x0},
    {  13, 0x32, 3059, 0x0},
    {  10, 0x51, 5939, 0x0},
    {  0, 0x61, 171, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    // 450: Local time: 03:43:00 AM
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 37, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x78, 2039, 0x0},
    {  0, 0x67, 969, 0x0},
    {  0, 0x66, 79, 0x0},
    {  0, 0x68, 768, 0x0},
    {  0, 0x5a, 2529, 0x0},
    {  0, 0x76, 1786, 0x0},
    {  0, 0x76, 614, 0x0},
    // 465: Local time: 03:58:00 AM
    {  0, 0x76, 1218, 0x0},
    {  11, 0x66, 1712, 0x0},
    {  0, 0x66, 427, 0x0},
    {  0, 0x66, 219, 0x0},
    {  0, 0x66, 996, 0x0},
    {  0, 0x59, 1857, 0x0},
    {  0, 0x62, 2462, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 475, 0x0},
    {  0, 0x60, 1118, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    // 480: Local time: 04:13:00 AM
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x6f, 1346, 0x0},
    {  8, 0x61, 2033, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 486, 0x0},
    {  0, 0x78, 2529, 0x0},
    {  0, 0x69, 0, 0x0},
    {  0, 0x69, 414, 0x0},
    {  0, 0x68, 503, 0x0},
    {  0, 0x69, 13, 0x0},
    {  0, 0x0, 0, 0x0},
    {  0, 0x69, 0, 0x0},
    // 495: Local time: 04:27:00 AM
    {  0, 0x69, 0, 0x0},
    {  0, 0x68, 734, 0x0},
    {  0, 0x69, 227, 0x0},
    {  0, 0x5a, 118, 0x0},
    {  0, 0x66, 1240, 0x0},
    {  0, 0x66, 333, 0x0},
    {  0, 0x76, 722, 0x0},
    {  0, 0x71, 1728, 0x0},
    {  0, 0x6f, 1346, 0x0},
    {  0, 0x6f, 1697, 0x0},
    {  0, 0x60, 0, 0x0},
    {  0, 0x60, 19, 0x0},
    {  0, 0x62, 541, 0x0},
    {  0, 0x54, 28, 0x0},
    {  0, 0x0, 0, 0x0},
    // 510: Local time: 04:41:00 AM
    {  0, 0x54, 0, 0x0},
    {  0, 0x54, 0, 0x0},
    {  0, 0x54, 1582, 0x0},
    {  0, 0x34, 565, 0x0},
    {  0, 0x24, 432, 0x0},
    {  0, 0x14, 0, 0x0},
    {  0, 0x24, 0, 0x0},
    {  0, 0x24, 0, 0x0},
    {  0, 0x54, 284, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 156, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    // 525: Local time: 04:56:00 AM
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 25, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x64, 0, 0x0},
    {  0, 0x54, 315, 0x0},
    {  0, 0x24, 0, 0x0},
    {  0, 0x24, 0, 0x0},
    {  0, 0x24, 0, 0x0},
    // 540: Local time: 05:11:00 AM
    {  0, 0x24, 0, 0x0},
    {  0, 0x24, 0, 0x0},
    {  0, 0x23, 1749, 0x0},
    {  0, 0x82, 34, 0x0},
    {  0, 0x82, 0, 0x0},
    {  0, 0x82, 0, 0x0},
    {  0, 0x82, 0, 0x0},
    {  0, 0x82, 0, 0x0},
    {  0, 0x75, 2230, 0x0},
    {  0, 0x43, 1922, 0x0},
    {  7, 0x42, 3574, 0x0},
    {  7, 0x52, 8659, 0x0},
    {  0, 0x60, 0, 0x0},
    {  0, 0x61, 886, 0x0},
    {  0, 0x61, 0, 0x0},
    // 555: Local time: 05:26:00 AM
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    // 570: Local time: 05:41:00 AM
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    // 585: Local time: 05:56:00 AM
    {  0, 0x61, 0, 0x0},
    {  0, 0x73, 1067, 0x0},
    {  0, 0x69, 0, 0x0},
    {  0, 0x69, 0, 0x0},
    {  0, 0x69, 0, 0x0},
    {  0, 0x69, 0, 0x0},
    {  0, 0x78, 1263, 0x0},
    {  0, 0x78, 0, 0x0},
    {  0, 0x78, 0, 0x0},
    {  12, 0x74, 2664, 0x0},
    {  0, 0x43, 1537, 0x0},
    {  0, 0x61, 4003, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    // 600: Local time: 06:11:00 AM
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 149, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    // 615: Local time: 06:26:00 AM
    {  0, 0x61, 19, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 118, 0x0},
    {  0, 0x60, 0, 0x0},
    {  0, 0x71, 594, 0x0},
    {  0, 0x72, 0, 0x0},
    // 630: Local time: 06:41:00 AM
    {  0, 0x72, 0, 0x0},
    {  0, 0x72, 11, 0x0},
    {  0, 0x72, 32, 0x0},
    {  0, 0x80, 0, 0x0},
    {  0, 0x80, 0, 0x0},
    {  0, 0x65, 1681, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    // 645: Local time: 06:56:00 AM
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x55, 488, 0x0},
    {  0, 0x55, 512, 0x0},
    {  0, 0x55, 0, 0x0},
    {  0, 0x65, 35, 0x0},
    {  0, 0x65, 0, 0x0},
    {  0, 0x65, 0, 0x0},
    {  0, 0x65, 0, 0x0},
    {  0, 0x65, 0, 0x0},
    {  0, 0x65, 0, 0x0},
    {  0, 0x65, 0, 0x0},
    {  0, 0x67, 753, 0x0},
    {  0, 0x68, 0, 0x0},
    {  0, 0x68, 0, 0x0},
    // 660: Local time: 07:11:00 AM
    {  0, 0x68, 0, 0x0},
    {  0, 0x68, 0, 0x0},
    {  0, 0x68, 563, 0x0},
    {  0, 0x35, 0, 0x0},
    {  0, 0x35, 0, 0x0},
    {  0, 0x35, 0, 0x0},
    {  0, 0x35, 0, 0x0},
    {  0, 0x35, 0, 0x0},
    {  0, 0x35, 0, 0x0},
    {  0, 0x35, 0, 0x0},
    {  0, 0x35, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    // 675: Local time: 07:26:00 AM
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    // 690: Local time: 07:41:00 AM
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  0, 0x25, 0, 0x0},
    {  13, 0x45, 606, 0x0},
    {  0, 0x54, 0, 0x0},
    {  0, 0x54, 0, 0x0},
    {  0, 0x54, 0, 0x0},
    {  0, 0x54, 919, 0x0},
    {  0, 0x66, 1986, 0x0},
    {  0, 0x68, 0, 0x0},
    {  0, 0x68, 0, 0x0},
    {  0, 0x68, 0, 0x0},
    {  0, 0x7c, 2406, 0x0},
    {  0, 0x60, 1077, 0x0},
    // 705: Local time: 07:56:00 AM
    {  0, 0x6f, 127, 0x0},
    {  0, 0x6f, 0, 0x0},
    {  0, 0x61, 245, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 0, 0x0},
    {  0, 0x61, 356, 0x0},
    {  14, 0x42, 4000, 0x0},
    {  0, 0x43, 76, 0x0},
    {  0, 0x42, 4938, 0x0},
    {  0, 0x42, 3420, 0x0},
    {  0, 0x42, 3520, 0x0},
    {  12, 0x42, 5809, 0x0},
    {  0, 0x51, 4623, 0x0},
    {  12, 0x62, 4080, 0x0},
    // 720: Local time: 08:11:00 AM
    {  0, 0x44, 2376, 0x0},
    {  8, 0x35, 3133, 0x0},
    {  0, 0x64, 2473, 0x0},
    {  0, 0x64, 960, 0x0},
    {  0, 0x34, 1138, 0x0},
    {  0, 0x34, 343, 0x0},
    {  0, 0x24, 821, 0x0},
    {  0, 0x54, 6572, 0x0},
    {  0, 0x23, 6128, 0x0},
    {  0, 0x23, 2567, 0x0},
    {  0, 0x24, 750, 0x0},
    {  14, 0x33, 2113, 0x0},
    {  0, 0x44, 1038, 0x0},
    {  7, 0x24, 2465, 0x0},
    {  0, 0x25, 1414, 0x0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



// ----------------------------------------------------------------
// Sample captured at: 2015-09-06 21:11:00 local, 2015-09-07 04:11:00 GMT
// According to Misfit:
//  Total sleep: 409 min
//  deep: 241 min
//  light: 168 min
//  Enter at: 10:20pm (index 69)
//  Exit at: 5:08am (index 477)
AlgDlsMinuteData *activity_sample_sleep_3(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_3
  //> TEST_VERSION 2
  //> TEST_TOTAL 409
  //> TEST_TOTAL_MIN 360
  //> TEST_TOTAL_MAX 420
  //> TEST_DEEP 241
  //> TEST_DEEP_MIN 190
  //> TEST_DEEP_MAX 260
  //> TEST_START_AT 69
  //> TEST_START_AT_MIN 60
  //> TEST_START_AT_MAX 80
  //> TEST_END_AT 477
  //> TEST_END_AT_MIN 440
  //> TEST_END_AT_MAX 490
  //> TEST_CUR_STATE_ELAPSED 78
  //> TEST_CUR_STATE_ELAPSED_MIN 70
  //> TEST_CUR_STATE_ELAPSED_MAX 120
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc, flags}
  static AlgDlsMinuteData samples[] = { 
    { 0, 0x53, 11197, 0x0},
    { 42, 0x43, 6217, 0x0},
    { 30, 0x51, 3569, 0x0},
    { 0, 0x42, 8074, 0x0},
    { 9, 0x53, 10044, 0x0},
    { 10, 0x53, 10152, 0x0},
    { 6, 0x53, 9156, 0x0},
    { 12, 0x53, 9361, 0x0},
    { 0, 0x53, 9263, 0x0},
    { 0, 0x43, 10275, 0x0},
    { 9, 0x42, 8222, 0x0},
    { 31, 0x41, 6153, 0x0},
    { 23, 0x42, 5736, 0x0},
    { 0, 0x64, 4238, 0x0},
    { 0, 0x54, 5578, 0x0},
    // 15: Local time: 09:26:00 PM
    { 0, 0x54, 633, 0x0},
    { 8, 0x54, 9847, 0x0},
    { 0, 0x43, 4474, 0x0},
    { 22, 0x42, 5354, 0x0},
    { 0, 0x32, 5344, 0x0},
    { 32, 0x52, 5236, 0x0},
    { 0, 0x53, 5891, 0x0},
    { 0, 0x54, 8607, 0x0},
    { 0, 0x54, 8088, 0x0},
    { 0, 0x42, 5604, 0x0},
    { 0, 0x42, 926, 0x0},
    { 0, 0x64, 287, 0x0},
    { 7, 0x54, 828, 0x0},
    { 0, 0x68, 674, 0x0},
    { 12, 0x55, 4129, 0x0},
    // 30: Local time: 09:41:00 PM
    { 0, 0x67, 1138, 0x0},
    { 0, 0x54, 498, 0x0},
    { 0, 0x54, 389, 0x0},
    { 0, 0x65, 1262, 0x0},
    { 0, 0x64, 219, 0x0},
    { 0, 0x64, 433, 0x0},
    { 8, 0x66, 923, 0x0},
    { 0, 0x64, 278, 0x0},
    { 0, 0x64, 618, 0x0},
    { 0, 0x64, 374, 0x0},
    { 0, 0x64, 565, 0x0},
    { 0, 0x64, 629, 0x0},
    { 0, 0x64, 566, 0x0},
    { 0, 0x53, 2701, 0x0},
    { 20, 0x42, 7228, 0x0},
    // 45: Local time: 09:56:00 PM
    { 43, 0x41, 5422, 0x0},
    { 20, 0x42, 3710, 0x0},
    { 0, 0x42, 3211, 0x0},
    { 0, 0x32, 1539, 0x0},
    { 14, 0x42, 7117, 0x0},
    { 0, 0x57, 2837, 0x0},
    { 0, 0x58, 109, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 137, 0x0},
    { 0, 0x68, 28, 0x0},
    { 0, 0x58, 109, 0x0},
    { 0, 0x58, 108, 0x0},
    { 0, 0x57, 0, 0x0},
    { 0, 0x67, 44, 0x0},
    { 0, 0x58, 56, 0x0},
    // 60: Local time: 10:11:00 PM
    { 0, 0x58, 356, 0x0},
    { 0, 0x58, 1111, 0x0},
    { 0, 0x58, 88, 0x0},
    { 0, 0x57, 1604, 0x0},
    { 0, 0x67, 645, 0x0},
    { 0, 0x67, 822, 0x0},
    { 0, 0x62, 2594, 0x0},
    { 0, 0x63, 10, 0x0},
    { 0, 0x62, 318, 0x0},
    { 6, 0x61, 2917, 0x0},
    { 0, 0x62, 0, 0x0},
    { 0, 0x62, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x62, 516, 0x0},
    // 75: Local time: 10:26:00 PM
    { 0, 0x61, 0, 0x0},
    { 0, 0x61, 0, 0x0},
    { 0, 0x61, 0, 0x0},
    { 0, 0x61, 0, 0x0},
    { 0, 0x61, 0, 0x0},
    { 0, 0x61, 0, 0x0},
    { 0, 0x61, 162, 0x0},
    { 0, 0x52, 171, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    // 90: Local time: 10:41:00 PM
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    // 105: Local time: 10:56:00 PM
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    // 120: Local time: 11:11:00 PM
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    // 135: Local time: 11:26:00 PM
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x62, 444, 0x0},
    { 0, 0x62, 0, 0x0},
    { 0, 0x62, 0, 0x0},
    { 0, 0x62, 0, 0x0},
    { 0, 0x62, 16, 0x0},
    { 0, 0x62, 0, 0x0},
    { 0, 0x62, 362, 0x0},
    { 7, 0x41, 4506, 0x0},
    { 7, 0x22, 5674, 0x0},
    { 0, 0x18, 1653, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 13, 0x0},
    // 150: Local time: 11:41:00 PM
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    // 165: Local time: 11:56:00 PM
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    // 180: Local time: 12:11:00 AM
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    // 195: Local time: 12:26:00 AM
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 0, 0x0},
    { 0, 0x18, 467, 0x0},
    { 0, 0x15, 32, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    // 210: Local time: 12:41:00 AM
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x34, 3609, 0x0},
    { 0, 0x64, 11, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x63, 0, 0x0},
    // 225: Local time: 12:56:00 AM
    { 0, 0x63, 0, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x63, 11, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x64, 383, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 340, 0x0},
    // 240: Local time: 01:11:00 AM
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 17, 0x0},
    { 0, 0x7e, 905, 0x0},
    { 0, 0x7e, 0, 0x0},
    // 255: Local time: 01:26:00 AM
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    // 270: Local time: 01:41:00 AM
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    // 285: Local time: 01:56:00 AM
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7d, 297, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x76, 423, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 454, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    // 300: Local time: 02:11:00 AM
    { 0, 0x7e, 0, 0x0},
    { 0, 0x73, 1986, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    // 315: Local time: 02:26:00 AM
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x55, 343, 0x0},
    { 0, 0x55, 0, 0x0},
    // 330: Local time: 02:41:00 AM
    { 0, 0x55, 113, 0x0},
    { 0, 0x55, 0, 0x0},
    { 0, 0x55, 0, 0x0},
    { 0, 0x55, 0, 0x0},
    { 0, 0x55, 0, 0x0},
    { 0, 0x55, 0, 0x0},
    { 0, 0x55, 0, 0x0},
    { 0, 0x55, 1207, 0x0},
    { 0, 0x64, 4496, 0x0},
    { 0, 0x64, 69, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    // 345: Local time: 02:56:00 AM
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x64, 381, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    // 360: Local time: 03:11:00 AM
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 17, 0x0},
    // 375: Local time: 03:26:00 AM
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    // 390: Local time: 03:41:00 AM
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 0, 0x24, 0, 0x0},
    { 12, 0x24, 1181, 0x0},
    { 0, 0x7f, 279, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 738, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    // 405: Local time: 03:56:00 AM
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 16, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 387, 0x0},
    { 0, 0x64, 127, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x7f, 834, 0x0},
    { 0, 0x7e, 0, 0x0},
    // 420: Local time: 04:11:00 AM
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 119, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 23, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 26, 0x0},
    { 10, 0x7e, 694, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 9, 0x7e, 771, 0x0},
    { 0, 0x7e, 0, 0x0},
    // 435: Local time: 04:26:00 AM
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7d, 568, 0x0},
    { 0, 0x6c, 0, 0x0},
    { 0, 0x6c, 0, 0x0},
    { 0, 0x31, 3670, 0x0},
    { 0, 0x13, 156, 0x0},
    { 9, 0x62, 8046, 0x0},
    // 450: Local time: 04:41:00 AM
    { 0, 0x70, 25, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 926, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    // 465: Local time: 04:56:00 AM
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x88, 1179, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 42, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    // 480: Local time: 05:11:00 AM
    { 0, 0x68, 1263, 0x0},
    { 8, 0x86, 267, 0x0},
    { 0, 0x76, 275, 0x0},
    { 0, 0x77, 355, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 2658, 0x0},
    { 0, 0x5a, 2362, 0x0},
    { 0, 0x6a, 1567, 0x0},
    { 0, 0x0, 0, 0x0},
    { 0, 0x79, 4670, 0x0},
    { 0, 0x69, 1756, 0x0},
    { 0, 0x68, 1635, 0x0},
    { 0, 0x66, 2230, 0x0},
    { 12, 0x61, 1256, 0x0},
    { 0, 0x61, 0, 0x0},
    // 495: Local time: 05:25:00 AM
    { 0, 0x6f, 1941, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 18, 0x60, 1056, 0x0},
    { 0, 0x60, 2695, 0x0},
    { 0, 0x6f, 1155, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x6f, 612, 0x0},
    { 0, 0x6f, 938, 0x0},
    { 0, 0x6f, 1135, 0x0},
    { 0, 0x6f, 1403, 0x0},
    { 0, 0x78, 5613, 0x0},
    { 0, 0x69, 583, 0x0},
    { 0, 0x68, 1614, 0x0},
    { 0, 0x80, 2307, 0x0},
    { 0, 0x60, 703, 0x0},
    // 510: Local time: 05:40:00 AM
    { 0, 0x6f, 701, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 9, 0x84, 2999, 0x0},
    { 0, 0x66, 893, 0x0},
    { 0, 0x66, 164, 0x0},
    { 0, 0x66, 267, 0x0},
    { 0, 0x66, 645, 0x0},
    { 0, 0x66, 833, 0x0},
    { 0, 0x67, 1308, 0x0},
    // 525: Local time: 05:55:00 AM
    { 0, 0x67, 1149, 0x0},
    { 0, 0x59, 367, 0x0},
    { 0, 0x57, 272, 0x0},
    { 0, 0x58, 364, 0x0},
    { 0, 0x58, 441, 0x0},
    { 0, 0x59, 10, 0x0},
    { 0, 0x57, 491, 0x0},
    { 0, 0x69, 29, 0x0},
    { 0, 0x59, 57, 0x0},
    { 0, 0x69, 186, 0x0},
    { 0, 0x59, 51, 0x0},
    { 0, 0x58, 772, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 99, 0x0},
    { 0, 0x59, 56, 0x0},
    // 540: Local time: 06:10:01 AM
    { 0, 0x58, 578, 0x0},
    { 0, 0x58, 264, 0x0},
    { 0, 0x57, 331, 0x0},
    { 0, 0x58, 28, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x57, 112, 0x0},
    { 0, 0x79, 5242, 0x0},
    { 0, 0x69, 1164, 0x0},
    { 12, 0x52, 6445, 0x0},
    { 0, 0x42, 2998, 0x0},
    { 0, 0x43, 5119, 0x0},
    { 0, 0x42, 6073, 0x0},
    { 0, 0x42, 6554, 0x0},
    { 12, 0x42, 3553, 0x0},
    { 16, 0x42, 4721, 0x0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}





// ----------------------------------------------------------------
// Sample captured at: 2015-09-05 21:34:00 local, 2015-09-06 04:34:00 GMT
// According to Itai:
//   Went to bed around 10pm (offset 26)
//   Feel asleep sometime after
//   Woke and watched moving 11:30pm to 2:30am (offset 116 to 295)
//   Back to sleep again
//   Woke up at 8:50am (offset 675)
AlgDlsMinuteData *activity_sample_sleep_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_4
  //> TEST_VERSION 2
  //> TEST_TOTAL -1
  //> TEST_TOTAL_MIN -1
  //> TEST_TOTAL_MAX -1
  //> TEST_DEEP -1
  //> TEST_DEEP_MIN -1
  //> TEST_DEEP_MAX -1
  //> TEST_START_AT -1
  //> TEST_START_AT_MIN -1
  //> TEST_START_AT_MAX -1
  //> TEST_END_AT 675
  //> TEST_END_AT_MIN 660
  //> TEST_END_AT_MAX 690
  //> TEST_CUR_STATE_ELAPSED 30
  //> TEST_CUR_STATE_ELAPSED_MIN 25
  //> TEST_CUR_STATE_ELAPSED_MAX 35
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc, flags}
  static AlgDlsMinuteData samples[] = { 
    { 0, 0x78, 1472, 0x0},
    { 0, 0x68, 94, 0x0},
    { 0, 0x68, 88, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 66, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 56, 0x0},
    { 0, 0x68, 1222, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 35, 0x0},
    { 0, 0x76, 0, 0x0},
    // 15: Local time: 09:49:00 PM
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 8, 0x29, 575, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 180, 0x0},
    { 0, 0x2b, 358, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    // 30: Local time: 10:04:00 PM
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 10, 0x0},
    // 45: Local time: 10:19:00 PM
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x1b, 0, 0x0},
    { 0, 0x5b, 384, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    // 60: Local time: 10:34:00 PM
    { 0, 0x6b, 0, 0x0},
    { 0, 0x5b, 304, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 214, 0x0},
    { 0, 0x5b, 266, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x2a, 1993, 0x0},
    { 0, 0x1a, 0, 0x0},
    { 0, 0x1a, 0, 0x0},
    { 0, 0x1a, 0, 0x0},
    { 0, 0x1a, 0, 0x0},
    { 0, 0x1a, 0, 0x0},
    { 0, 0x2a, 111, 0x0},
    // 75: Local time: 10:49:00 PM
    { 0, 0x2b, 281, 0x0},
    { 0, 0x3b, 528, 0x0},
    { 0, 0x3b, 53, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 10, 0x3b, 794, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 211, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 17, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    // 90: Local time: 11:04:01 PM
    { 0, 0x3b, 583, 0x0},
    { 0, 0x75, 0, 0x0},
    { 0, 0x75, 0, 0x0},
    { 0, 0x75, 0, 0x0},
    { 0, 0x75, 0, 0x0},
    { 0, 0x75, 0, 0x0},
    { 7, 0x87, 1854, 0x0},
    { 0, 0x66, 0, 0x0},
    { 0, 0x67, 97, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 27, 0x74, 4167, 0x0},
    { 8, 0x51, 2172, 0x0},
    { 0, 0x52, 575, 0x0},
    // 105: Local time: 11:19:00 PM
    { 48, 0x41, 6189, 0x0},
    { 0, 0x71, 3898, 0x0},
    { 0, 0x70, 297, 0x0},
    { 0, 0x7f, 566, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    // 120: Local time: 11:34:00 PM
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x61, 331, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 11, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    // 135: Local time: 11:49:00 PM
    { 0, 0x71, 37, 0x0},
    { 7, 0x6f, 3948, 0x0},
    { 0, 0x2b, 1050, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 6, 0x4a, 2706, 0x0},
    { 0, 0x59, 204, 0x0},
    { 8, 0x59, 1855, 0x0},
    { 0, 0x68, 1398, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x59, 182, 0x0},
    // 150: Local time: 12:04:00 AM
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 20, 0x0},
    { 0, 0x59, 88, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 105, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    // 165: Local time: 12:19:00 AM
    { 0, 0x58, 128, 0x0},
    { 0, 0x3b, 999, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    // 180: Local time: 12:34:00 AM
    { 0, 0x3b, 75, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 13, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 375, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    // 195: Local time: 12:49:01 AM
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 48, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x4b, 392, 0x0},
    { 0, 0x5c, 19, 0x0},
    // 210: Local time: 01:04:00 AM
    { 0, 0x5a, 4287, 0x0},
    { 0, 0x79, 1827, 0x0},
    { 0, 0x3b, 2037, 0x0},
    { 0, 0x2c, 1838, 0x0},
    { 0, 0x2d, 1981, 0x0},
    { 0, 0x3c, 1956, 0x0},
    { 0, 0x4a, 1753, 0x0},
    { 0, 0x55, 503, 0x0},
    { 0, 0x55, 344, 0x0},
    { 0, 0x69, 1178, 0x0},
    { 0, 0x3a, 2594, 0x0},
    { 0, 0x68, 5299, 0x0},
    { 0, 0x59, 1958, 0x0},
    { 0, 0x59, 75, 0x0},
    { 0, 0x59, 0, 0x0},
    // 225: Local time: 01:19:01 AM
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 241, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 159, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 0, 0x0},
    // 240: Local time: 01:34:00 AM
    { 0, 0x58, 17, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 17, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 14, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 287, 0x0},
    { 0, 0x59, 50, 0x0},
    { 0, 0x59, 0, 0x0},
    // 255: Local time: 01:49:00 AM
    { 0, 0x59, 65, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x81, 1044, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 139, 0x0},
    { 0, 0x52, 247, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x52, 0, 0x0},
    { 0, 0x71, 1519, 0x0},
    { 9, 0x61, 867, 0x0},
    { 0, 0x5d, 79, 0x0},
    { 0, 0x5d, 0, 0x0},
    // 270: Local time: 02:04:00 AM
    { 0, 0x5d, 26, 0x0},
    { 0, 0x5d, 0, 0x0},
    { 6, 0x5d, 259, 0x0},
    { 3, 0x6d, 301, 0x0},
    { 0, 0x59, 1361, 0x0},
    { 0, 0x58, 29, 0x0},
    { 0, 0x59, 241, 0x0},
    { 0, 0x59, 48, 0x0},
    { 0, 0x59, 22, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 51, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x58, 436, 0x0},
    { 0, 0x59, 28, 0x0},
    // 285: Local time: 02:19:00 AM
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 51, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 94, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x69, 2464, 0x0},
    { 0, 0x6f, 506, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    // 300: Local time: 02:35:00 AM
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7e, 818, 0x0},
    { 0, 0x6a, 10, 0x0},
    { 0, 0x6a, 48, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x3b, 1213, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 315: Local time: 02:50:00 AM
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 330: Local time: 03:05:00 AM
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 1102, 0x0},
    { 0, 0x5b, 1124, 0x0},
    // 345: Local time: 03:20:00 AM
    { 0, 0x4b, 244, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 16, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    // 360: Local time: 03:35:00 AM
    { 0, 0x4b, 0, 0x0},
    { 0, 0x6f, 1623, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 11, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    // 375: Local time: 03:50:00 AM
    { 0, 0x70, 264, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    // 390: Local time: 04:05:00 AM
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    // 405: Local time: 04:20:00 AM
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 13, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 1431, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x18, 438, 0x0},
    { 0, 0x16, 0, 0x0},
    { 0, 0x16, 0, 0x0},
    { 0, 0x16, 0, 0x0},
    // 420: Local time: 04:35:00 AM
    { 0, 0x16, 0, 0x0},
    { 0, 0x16, 53, 0x0},
    { 0, 0x17, 0, 0x0},
    { 0, 0x17, 0, 0x0},
    { 0, 0x17, 0, 0x0},
    { 0, 0x16, 20, 0x0},
    { 0, 0x16, 60, 0x0},
    { 0, 0x1a, 1204, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 11, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 435: Local time: 04:50:00 AM
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 535, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x9, 1120, 0x0},
    { 0, 0x5, 0, 0x0},
    { 0, 0x5, 0, 0x0},
    { 0, 0x5, 0, 0x0},
    { 0, 0x5, 0, 0x0},
    // 450: Local time: 05:05:00 AM
    { 0, 0x5, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    // 465: Local time: 05:20:00 AM
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    { 0, 0x4, 0, 0x0},
    // 480: Local time: 05:35:00 AM
    { 0, 0x4, 0, 0x0},
    { 10, 0x6, 808, 0x0},
    { 0, 0x2c, 1204, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    // 495: Local time: 05:50:00 AM
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    // 510: Local time: 06:05:00 AM
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x6f, 802, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    // 525: Local time: 06:20:00 AM
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6e, 1440, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 11, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x3b, 846, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    // 540: Local time: 06:35:00 AM
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    // 555: Local time: 06:50:00 AM
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x78, 893, 0x0},
    { 0, 0x76, 10, 0x0},
    { 0, 0x6a, 932, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    // 570: Local time: 07:05:01 AM
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 25, 0x0},
    { 0, 0x6c, 1845, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 14, 0x0},
    // 585: Local time: 07:20:00 AM
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 39, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x7f, 133, 0x0},
    { 0, 0x6f, 518, 0x0},
    // 600: Local time: 07:35:00 AM
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 48, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 1007, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x1d, 1490, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 9, 0x1d, 768, 0x0},
    { 0, 0x6a, 259, 0x0},
    // 615: Local time: 07:50:00 AM
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x5a, 0, 0x0},
    { 0, 0x5a, 0, 0x0},
    { 0, 0x5a, 0, 0x0},
    { 0, 0x5a, 0, 0x0},
    { 0, 0x5a, 0, 0x0},
    { 0, 0x5a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x4b, 711, 0x0},
    { 0, 0x4c, 0, 0x0},
    // 630: Local time: 08:05:00 AM
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 682, 0x0},
    { 0, 0x4c, 14, 0x0},
    { 0, 0x4c, 53, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    // 645: Local time: 08:20:00 AM
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 26, 0x0},
    { 0, 0x6f, 2159, 0x0},
    { 0, 0x6f, 94, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 296, 0x0},
    // 660: Local time: 08:35:00 AM
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6d, 1154, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    // 675: Local time: 08:50:00 AM
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 654, 0x0},
    { 0, 0x5c, 1778, 0x0},
    { 0, 0x72, 1863, 0x0},
    { 0, 0x86, 2276, 0x0},
    { 10, 0x72, 2058, 0x0},
    { 8, 0x51, 2902, 0x0},
    { 14, 0x51, 4741, 0x0},
    { 0, 0x76, 298, 0x0},
    { 0, 0x76, 63, 0x0},
    { 0, 0x76, 694, 0x0},
    { 0, 0x87, 3182, 0x0},
    { 0, 0x76, 94, 0x0},
    { 0, 0x76, 69, 0x0},
    { 0, 0x76, 84, 0x0},
    // 690: Local time: 09:05:00 AM
    { 0, 0x76, 389, 0x0},
    { 0, 0x36, 164, 0x0},
    { 0, 0x56, 1228, 0x0},
    { 0, 0x74, 1089, 0x0},
    { 0, 0x76, 48, 0x0},
    { 8, 0x76, 384, 0x0},
    { 0, 0x76, 75, 0x0},
    { 0, 0x76, 102, 0x0},
    { 0, 0x76, 199, 0x0},
    { 0, 0x70, 895, 0x0},
    { 0, 0x78, 587, 0x0},
    { 0, 0x78, 862, 0x0},
    { 0, 0x76, 137, 0x0},
    { 0, 0x76, 266, 0x0},
    { 0, 0x75, 1998, 0x0},
    { 0, 0x66, 2698, 0x0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured at: 2015-09-07 21:24:00 local, 2015-09-08 04:24:00 GMT
// According to Misfit:
//  total sleep: 309 min
//  deep: 200 min
//  light: 109 min
//  start at: 9:52pm (offset 27)
//  end at: 3:11am (offset 346)
AlgDlsMinuteData *activity_sample_sleep_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_5
  //> TEST_VERSION 2
  //> TEST_TOTAL 309
  //> TEST_TOTAL_MIN 290
  //> TEST_TOTAL_MAX 325
  //> TEST_DEEP 200
  //> TEST_DEEP_MIN 180
  //> TEST_DEEP_MAX 250
  //> TEST_START_AT 27
  //> TEST_START_AT_MIN 22
  //> TEST_START_AT_MAX 32
  //> TEST_END_AT 346
  //> TEST_END_AT_MIN 330
  //> TEST_END_AT_MAX 360
  //> TEST_CUR_STATE_ELAPSED 114
  //> TEST_CUR_STATE_ELAPSED_MIN 100
  //> TEST_CUR_STATE_ELAPSED_MAX 130
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc, flags}
  static AlgDlsMinuteData samples[] = { 
    { 18, 0x52, 4736, 0x0},
    { 4, 0x42, 4126, 0x0},
    { 7, 0x42, 3883, 0x0},
    { 0, 0x52, 4139, 0x0},
    { 0, 0x55, 5629, 0x0},
    { 0, 0x54, 1895, 0x0},
    { 0, 0x52, 4345, 0x0},
    { 8, 0x62, 1935, 0x0},
    { 6, 0x51, 2881, 0x0},
    { 0, 0x51, 11, 0x0},
    { 0, 0x51, 14, 0x0},
    { 21, 0x40, 2641, 0x0},
    { 16, 0x42, 6808, 0x0},
    { 20, 0x52, 9076, 0x0},
    { 8, 0x42, 5367, 0x0},
    // 15: Local time: 09:40:00 PM
    { 0, 0x51, 5903, 0x0},
    { 0, 0x60, 515, 0x0},
    { 0, 0x6f, 1611, 0x0},
    { 0, 0x6f, 2294, 0x0},
    { 0, 0x6f, 1713, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 9, 0x61, 387, 0x0},
    { 0, 0x61, 3398, 0x0},
    { 0, 0x61, 0, 0x0},
    { 0, 0x72, 1903, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x54, 159, 0x0},
    { 0, 0x34, 137, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    // 30: Local time: 09:55:00 PM
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 148, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    // 45: Local time: 10:10:00 PM
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 88, 0x0},
    { 0, 0x54, 72, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 121, 0x0},
    { 0, 0x44, 0, 0x0},
    // 60: Local time: 10:25:00 PM
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    // 75: Local time: 10:40:00 PM
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 23, 0x0},
    { 0, 0x54, 106, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 263, 0x0},
    // 90: Local time: 10:55:00 PM
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 165, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x54, 0, 0x0},
    { 0, 0x64, 174, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 14, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    // 105: Local time: 11:10:00 PM
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 279, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    // 120: Local time: 11:25:00 PM
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    // 135: Local time: 11:40:00 PM
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    // 150: Local time: 11:55:00 PM
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x72, 1389, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    // 165: Local time: 12:10:00 AM
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    // 180: Local time: 12:25:00 AM
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    // 195: Local time: 12:40:00 AM
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    // 210: Local time: 12:55:00 AM
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8e, 269, 0x0},
    // 225: Local time: 01:10:00 AM
    { 0, 0x7f, 3546, 0x0},
    { 0, 0x23, 340, 0x0},
    { 0, 0x52, 4183, 0x0},
    { 0, 0x73, 0, 0x0},
    { 0, 0x73, 0, 0x0},
    { 0, 0x73, 0, 0x0},
    { 0, 0x73, 0, 0x0},
    { 0, 0x63, 565, 0x0},
    { 0, 0x32, 0, 0x0},
    { 0, 0x32, 0, 0x0},
    { 0, 0x32, 0, 0x0},
    { 0, 0x32, 0, 0x0},
    { 0, 0x32, 0, 0x0},
    { 0, 0x32, 0, 0x0},
    { 0, 0x32, 0, 0x0},
    // 240: Local time: 01:25:00 AM
    { 0, 0x32, 0, 0x0},
    { 0, 0x72, 371, 0x0},
    { 0, 0x43, 313, 0x0},
    { 0, 0x34, 31, 0x0},
    { 0, 0x34, 37, 0x0},
    { 0, 0x34, 44, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x42, 441, 0x0},
    { 0, 0x62, 0, 0x0},
    { 0, 0x62, 0, 0x0},
    { 0, 0x62, 0, 0x0},
    { 0, 0x42, 544, 0x0},
    { 0, 0x32, 0, 0x0},
    { 0, 0x32, 0, 0x0},
    // 255: Local time: 01:40:00 AM
    { 0, 0x32, 0, 0x0},
    { 0, 0x32, 0, 0x0},
    { 0, 0x42, 3580, 0x0},
    { 0, 0x64, 50, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    { 0, 0x64, 0, 0x0},
    // 270: Local time: 01:55:00 AM
    { 0, 0x64, 0, 0x0},
    { 0, 0x54, 3908, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    // 285: Local time: 02:10:00 AM
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    // 300: Local time: 02:25:00 AM
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    // 315: Local time: 02:40:00 AM
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 11, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 10, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    // 330: Local time: 02:55:00 AM
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x15, 0, 0x0},
    { 0, 0x5, 63, 0x0},
    { 0, 0x7, 0, 0x0},
    { 0, 0x9, 0, 0x0},
    { 0, 0x9, 0, 0x0},
    { 0, 0x9, 0, 0x0},
    { 0, 0x9, 0, 0x0},
    { 0, 0x9, 0, 0x0},
    { 0, 0x9, 0, 0x0},
    // 345: Local time: 03:10:00 AM
    { 0, 0x9, 0, 0x0},
    { 0, 0x9, 0, 0x0},
    { 0, 0x65, 695, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x76, 415, 0x0},
    { 0, 0x78, 250, 0x0},
    { 0, 0x78, 0, 0x0},
    { 0, 0x77, 3082, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x63, 1339, 0x0},
    { 0, 0x53, 0, 0x0},
    { 0, 0x70, 497, 0x0},
    // 360: Local time: 03:25:00 AM
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 8, 0x60, 4149, 0x0},
    { 8, 0x22, 1263, 0x0},
    { 0, 0x4d, 5595, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x83, 654, 0x0},
    { 10, 0x77, 2421, 0x0},
    { 0, 0x76, 393, 0x0},
    { 0, 0x76, 663, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    // 375: Local time: 03:40:00 AM
    { 0, 0x76, 290, 0x0},
    { 0, 0x65, 528, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 1059, 0x0},
    { 0, 0x65, 75, 0x0},
    { 0, 0x65, 119, 0x0},
    { 0, 0x26, 2952, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    // 390: Local time: 03:55:00 AM
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x61, 6140, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x6f, 432, 0x0},
    { 8, 0x60, 506, 0x0},
    { 9, 0x60, 390, 0x0},
    { 0, 0x6f, 852, 0x0},
    { 0, 0x60, 11, 0x0},
    { 6, 0x69, 3426, 0x0},
    { 0, 0x78, 1089, 0x0},
    { 0, 0x65, 560, 0x0},
    { 0, 0x66, 1166, 0x0},
    // 405: Local time: 04:10:00 AM
    { 0, 0x65, 762, 0x0},
    { 0, 0x66, 1864, 0x0},
    { 0, 0x76, 198, 0x0},
    { 0, 0x66, 204, 0x0},
    { 0, 0x55, 1503, 0x0},
    { 0, 0x25, 198, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x36, 346, 0x0},
    { 0, 0x26, 1830, 0x0},
    { 0, 0x36, 563, 0x0},
    { 0, 0x45, 14, 0x0},
    { 0, 0x45, 344, 0x0},
    { 0, 0x45, 17, 0x0},
    { 0, 0x45, 105, 0x0},
    // 420: Local time: 04:25:00 AM
    { 0, 0x55, 1922, 0x0},
    { 0, 0x67, 3371, 0x0},
    { 0, 0x68, 1850, 0x0},
    { 0, 0x59, 377, 0x0},
    { 0, 0x67, 2114, 0x0},
    { 9, 0x52, 5181, 0x0},
    { 14, 0x42, 4050, 0x0},
    { 32, 0x32, 4522, 0x0},
    { 0, 0x44, 2555, 0x0},
    { 14, 0x54, 3227, 0x0},
    { 0, 0x54, 2693, 0x0},
    { 0, 0x44, 2446, 0x0},
    { 10, 0x34, 2282, 0x0},
    { 22, 0x43, 2402, 0x0},
    { 0, 0x42, 3173, 0x0},
    // 435: Local time: 04:40:00 AM
    { 0, 0x64, 1337, 0x0},
    { 0, 0x64, 269, 0x0},
    { 0, 0x64, 161, 0x0},
    { 0, 0x57, 501, 0x0},
    { 0, 0x64, 182, 0x0},
    { 0, 0x64, 386, 0x0},
    { 0, 0x66, 2791, 0x0},
    { 0, 0x64, 37, 0x0},
    { 7, 0x57, 1192, 0x0},
    { 0, 0x66, 333, 0x0},
    { 0, 0x65, 609, 0x0},
    { 0, 0x65, 241, 0x0},
    { 0, 0x64, 204, 0x0},
    { 6, 0x65, 473, 0x0},
    { 0, 0x57, 334, 0x0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Manufactured sample representing watch on table surrounded by activity
// first 15 minutes: walking
// 15: start watch on table
// 195: watch put back on, walking
AlgDlsMinuteData *activity_sample_sleep_watch_on_table(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME watch_on_table
  //> TEST_VERSION 2
  //> TEST_TOTAL 0
  //> TEST_TOTAL_MIN 0
  //> TEST_TOTAL_MAX 0
  //> TEST_DEEP 0
  //> TEST_DEEP_MIN 0
  //> TEST_DEEP_MAX 0
  //> TEST_START_AT -1
  //> TEST_START_AT_MIN -1
  //> TEST_START_AT_MAX -1
  //> TEST_END_AT -1
  //> TEST_END_AT_MIN -1
  //> TEST_END_AT_MAX -1
  //> TEST_CUR_STATE_ELAPSED 255
  //> TEST_CUR_STATE_ELAPSED_MIN 255
  //> TEST_CUR_STATE_ELAPSED_MAX 255
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 100.0
  // list of: { steps, orientation, vmc, flags}
  static AlgDlsMinuteData samples[] = { 
    // 0:
    { 0, 0x55, 1922, 0x0},
    { 0, 0x67, 3371, 0x0},
    { 0, 0x68, 1850, 0x0},
    { 0, 0x59, 377, 0x0},
    { 0, 0x67, 2114, 0x0},
    { 9, 0x52, 5181, 0x0},
    { 14, 0x42, 4050, 0x0},
    { 32, 0x32, 4522, 0x0},
    { 0, 0x44, 2555, 0x0},
    { 14, 0x54, 3227, 0x0},
    { 0, 0x54, 2693, 0x0},
    { 0, 0x44, 2446, 0x0},
    { 10, 0x34, 2282, 0x0},
    { 22, 0x43, 2402, 0x0},
    { 0, 0x42, 3173, 0x0},
    // 15:
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    // 30:
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    // 45:
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    // 60:
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    // 75: Local time: 10:40:00 PM
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    // 90: Local time: 10:55:00 PM
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    // 105: Local time: 11:10:00 PM
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    // 120: Local time: 11:25:00 PM
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    // 135: Local time: 11:40:00 PM
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    // 150: Local time: 11:55:00 PM
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    { 0, 0x8c, 0, 0x0},
    // 165: Local time: 12:10:00 AM
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    // 180:
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    // 195:
    { 0, 0x65, 762, 0x0},
    { 0, 0x66, 1864, 0x0},
    { 0, 0x76, 198, 0x0},
    { 0, 0x66, 204, 0x0},
    { 0, 0x61, 6140, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x6f, 432, 0x0},
    { 8, 0x60, 506, 0x0},
    { 9, 0x60, 390, 0x0},
    { 0, 0x6f, 852, 0x0},
    { 0, 0x60, 11, 0x0},
    { 6, 0x69, 3426, 0x0},
    { 0, 0x78, 1089, 0x0},
    { 0, 0x65, 560, 0x0},
    { 0, 0x66, 1166, 0x0},
    // 210
    { 0, 0x65, 762, 0x0},
    { 0, 0x66, 1864, 0x0},
    { 0, 0x76, 198, 0x0},
    { 0, 0x66, 204, 0x0},
    { 0, 0x55, 1503, 0x0},
    { 0, 0x25, 198, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x36, 346, 0x0},
    { 0, 0x26, 1830, 0x0},
    { 0, 0x36, 563, 0x0},
    { 0, 0x45, 14, 0x0},
    { 0, 0x45, 344, 0x0},
    { 0, 0x45, 17, 0x0},
    { 0, 0x45, 105, 0x0},
    // 225
    { 0, 0x55, 1922, 0x0},
    { 0, 0x67, 3371, 0x0},
    { 0, 0x68, 1850, 0x0},
    { 0, 0x59, 377, 0x0},
    { 0, 0x67, 2114, 0x0},
    { 9, 0x52, 5181, 0x0},
    { 14, 0x42, 4050, 0x0},
    { 32, 0x32, 4522, 0x0},
    { 0, 0x44, 2555, 0x0},
    { 14, 0x54, 3227, 0x0},
    { 0, 0x54, 2693, 0x0},
    { 0, 0x44, 2446, 0x0},
    { 10, 0x34, 2282, 0x0},
    { 22, 0x43, 2402, 0x0},
    { 0, 0x42, 3173, 0x0},
    // 240
    { 0, 0x64, 1337, 0x0},
    { 0, 0x64, 269, 0x0},
    { 0, 0x64, 161, 0x0},
    { 0, 0x57, 501, 0x0},
    { 0, 0x64, 182, 0x0},
    { 0, 0x64, 386, 0x0},
    { 0, 0x66, 2791, 0x0},
    { 0, 0x64, 37, 0x0},
    { 7, 0x57, 1192, 0x0},
    { 0, 0x66, 333, 0x0},
    { 0, 0x65, 609, 0x0},
    { 0, 0x65, 241, 0x0},
    { 0, 0x64, 204, 0x0},
    { 6, 0x65, 473, 0x0},
    { 0, 0x57, 334, 0x0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured at: 2015-09-06 23:07:00 local, 2015-09-07 06:07:00 GMT
// According to Itai:
//   woke at 5:20am (offset 628)
//   took watch off from 7:10am to 7:30am (offset 739 to 759)
AlgDlsMinuteData *activity_sample_sleep_6(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_6
  //> TEST_VERSION 2
  //> TEST_TOTAL -1
  //> TEST_TOTAL_MIN -1
  //> TEST_TOTAL_MAX -1
  //> TEST_DEEP -1
  //> TEST_DEEP_MIN -1
  //> TEST_DEEP_MAX -1
  //> TEST_START_AT -1
  //> TEST_START_AT_MIN -1
  //> TEST_START_AT_MAX -1
  //> TEST_END_AT 628
  //> TEST_END_AT_MIN 610
  //> TEST_END_AT_MAX 640
  //> TEST_CUR_STATE_ELAPSED 332
  //> TEST_CUR_STATE_ELAPSED_MIN 310
  //> TEST_CUR_STATE_ELAPSED_MAX 350
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc, flags}
  static AlgDlsMinuteData samples[] = { 
    // 0: Local time: 06:52:00 PM
    { 0, 0x79, 3657, 0x0},
    { 25, 0x79, 2940, 0x0},
    { 12, 0x78, 4247, 0x0},
    { 0, 0x49, 1622, 0x0},
    { 0, 0x54, 264, 0x0},
    { 0, 0x65, 676, 0x0},
    { 0, 0x67, 2206, 0x0},
    { 0, 0x76, 433, 0x0},
    { 0, 0x76, 355, 0x0},
    { 0, 0x64, 14, 0x0},
    { 0, 0x64, 105, 0x0},
    { 0, 0x64, 460, 0x0},
    { 0, 0x75, 0, 0x0},
    { 0, 0x79, 1158, 0x0},
    { 8, 0x5a, 1554, 0x0},
    // 15: Local time: 07:07:00 PM
    { 0, 0x59, 802, 0x0},
    { 18, 0x57, 1533, 0x0},
    { 0, 0x68, 3258, 0x0},
    { 0, 0x7a, 2535, 0x0},
    { 0, 0x78, 3275, 0x0},
    { 0, 0x79, 1872, 0x0},
    { 0, 0x79, 2804, 0x0},
    { 0, 0x76, 2129, 0x0},
    { 0, 0x76, 3081, 0x0},
    { 0, 0x79, 5856, 0x0},
    { 25, 0x41, 3896, 0x0},
    { 0, 0x41, 2862, 0x0},
    { 12, 0x41, 3643, 0x0},
    { 70, 0x40, 5558, 0x0},
    { 77, 0x40, 6180, 0x0},
    // 30: Local time: 07:22:00 PM
    { 27, 0x40, 4019, 0x0},
    { 31, 0x4f, 3790, 0x0},
    { 22, 0x41, 4540, 0x0},
    { 20, 0x42, 6276, 0x0},
    { 0, 0x32, 6765, 0x0},
    { 30, 0x41, 6216, 0x0},
    { 0, 0x76, 1622, 0x0},
    { 0, 0x46, 4395, 0x0},
    { 0, 0x56, 676, 0x0},
    { 0, 0x57, 224, 0x0},
    { 0, 0x46, 438, 0x0},
    { 0, 0x45, 14, 0x0},
    { 0, 0x45, 0, 0x0},
    { 0, 0x56, 1574, 0x0},
    { 0, 0x56, 2039, 0x0},
    // 45: Local time: 07:37:00 PM
    { 0, 0x55, 41, 0x0},
    { 0, 0x58, 1389, 0x0},
    { 0, 0x57, 929, 0x0},
    { 0, 0x66, 3587, 0x0},
    { 0, 0x57, 1761, 0x0},
    { 0, 0x56, 1786, 0x0},
    { 0, 0x56, 845, 0x0},
    { 6, 0x64, 1078, 0x0},
    { 0, 0x73, 0, 0x0},
    { 0, 0x65, 2166, 0x0},
    { 0, 0x56, 1527, 0x0},
    { 0, 0x65, 2989, 0x0},
    { 0, 0x65, 3112, 0x0},
    { 0, 0x57, 825, 0x0},
    { 0, 0x54, 871, 0x0},
    // 60: Local time: 07:52:00 PM
    { 0, 0x54, 2362, 0x0},
    { 0, 0x33, 205, 0x0},
    { 0, 0x33, 217, 0x0},
    { 8, 0x44, 1104, 0x0},
    { 0, 0x65, 1645, 0x0},
    { 0, 0x64, 1025, 0x0},
    { 0, 0x53, 1206, 0x0},
    { 6, 0x66, 1542, 0x0},
    { 12, 0x66, 1870, 0x0},
    { 0, 0x65, 0, 0x0},
    { 0, 0x65, 287, 0x0},
    { 8, 0x58, 2122, 0x0},
    { 0, 0x66, 1413, 0x0},
    { 0, 0x55, 503, 0x0},
    { 7, 0x43, 3626, 0x0},
    // 75: Local time: 08:07:00 PM
    { 0, 0x41, 4278, 0x0},
    { 25, 0x51, 6081, 0x0},
    { 12, 0x41, 3026, 0x0},
    { 0, 0x41, 3097, 0x0},
    { 0, 0x51, 1327, 0x0},
    { 12, 0x52, 2339, 0x0},
    { 0, 0x74, 0, 0x0},
    { 0, 0x64, 667, 0x0},
    { 0, 0x64, 244, 0x0},
    { 0, 0x64, 435, 0x0},
    { 0, 0x74, 278, 0x0},
    { 0, 0x54, 439, 0x0},
    { 0, 0x54, 316, 0x0},
    { 0, 0x64, 13, 0x0},
    { 0, 0x64, 10, 0x0},
    // 90: Local time: 08:22:00 PM
    { 0, 0x74, 343, 0x0},
    { 0, 0x89, 173, 0x0},
    { 0, 0x7b, 25, 0x0},
    { 0, 0x7b, 257, 0x0},
    { 0, 0x7b, 448, 0x0},
    { 14, 0x75, 503, 0x0},
    { 0, 0x64, 3260, 0x0},
    { 0, 0x57, 4204, 0x0},
    { 0, 0x47, 2740, 0x0},
    { 0, 0x47, 2997, 0x0},
    { 8, 0x57, 1962, 0x0},
    { 0, 0x57, 1546, 0x0},
    { 0, 0x56, 281, 0x0},
    { 0, 0x56, 1130, 0x0},
    { 0, 0x55, 349, 0x0},
    // 105: Local time: 08:37:01 PM
    { 0, 0x56, 577, 0x0},
    { 0, 0x64, 1108, 0x0},
    { 0, 0x75, 10, 0x0},
    { 0, 0x55, 3424, 0x0},
    { 0, 0x62, 703, 0x0},
    { 12, 0x66, 1317, 0x0},
    { 0, 0x65, 2757, 0x0},
    { 36, 0x52, 4910, 0x0},
    { 22, 0x51, 3808, 0x0},
    { 30, 0x41, 4959, 0x0},
    { 42, 0x41, 4974, 0x0},
    { 26, 0x51, 2812, 0x0},
    { 52, 0x51, 5624, 0x0},
    { 26, 0x43, 7030, 0x0},
    { 8, 0x61, 6355, 0x0},
    // 120: Local time: 08:52:00 PM
    { 0, 0x6a, 2104, 0x0},
    { 0, 0x78, 3298, 0x0},
    { 18, 0x5b, 2159, 0x0},
    { 0, 0x6a, 3341, 0x0},
    { 0, 0x69, 2535, 0x0},
    { 10, 0x68, 1881, 0x0},
    { 0, 0x69, 2211, 0x0},
    { 6, 0x68, 4302, 0x0},
    { 7, 0x69, 849, 0x0},
    { 0, 0x68, 2595, 0x0},
    { 0, 0x55, 173, 0x0},
    { 7, 0x56, 569, 0x0},
    { 0, 0x45, 180, 0x0},
    { 0, 0x45, 176, 0x0},
    { 0, 0x45, 637, 0x0},
    // 135: Local time: 09:07:00 PM
    { 0, 0x52, 7178, 0x0},
    { 36, 0x52, 6815, 0x0},
    { 14, 0x53, 6078, 0x0},
    { 0, 0x74, 1111, 0x0},
    { 0, 0x74, 2156, 0x0},
    { 0, 0x65, 1844, 0x0},
    { 0, 0x74, 210, 0x0},
    { 0, 0x75, 621, 0x0},
    { 0, 0x76, 642, 0x0},
    { 0, 0x75, 1306, 0x0},
    { 0, 0x75, 957, 0x0},
    { 0, 0x75, 504, 0x0},
    { 0, 0x75, 509, 0x0},
    { 0, 0x75, 146, 0x0},
    { 0, 0x75, 651, 0x0},
    // 150: Local time: 09:22:00 PM
    { 0, 0x76, 651, 0x0},
    { 0, 0x76, 590, 0x0},
    { 0, 0x75, 189, 0x0},
    { 0, 0x73, 2764, 0x0},
    { 0, 0x6f, 17, 0x0},
    { 0, 0x53, 6300, 0x0},
    { 20, 0x43, 7719, 0x0},
    { 0, 0x32, 1881, 0x0},
    { 0, 0x42, 2020, 0x0},
    { 9, 0x52, 3364, 0x0},
    { 7, 0x51, 2394, 0x0},
    { 0, 0x53, 1704, 0x0},
    { 12, 0x42, 2701, 0x0},
    { 10, 0x52, 4966, 0x0},
    { 36, 0x52, 6705, 0x0},
    // 165: Local time: 09:37:00 PM
    { 0, 0x72, 1798, 0x0},
    { 0, 0x73, 112, 0x0},
    { 0, 0x73, 164, 0x0},
    { 0, 0x73, 38, 0x0},
    { 0, 0x73, 0, 0x0},
    { 0, 0x73, 13, 0x0},
    { 0, 0x73, 0, 0x0},
    { 9, 0x76, 338, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x58, 210, 0x0},
    { 0, 0x58, 94, 0x0},
    { 0, 0x58, 1509, 0x0},
    { 0, 0x49, 1913, 0x0},
    { 0, 0x49, 158, 0x0},
    { 0, 0x49, 0, 0x0},
    // 180: Local time: 09:52:00 PM
    { 0, 0x49, 0, 0x0},
    { 0, 0x59, 23, 0x0},
    { 0, 0x48, 2899, 0x0},
    { 29, 0x27, 1807, 0x0},
    { 0, 0x3a, 1517, 0x0},
    { 0, 0x3b, 57, 0x0},
    { 0, 0x3b, 148, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 45, 0x0},
    { 0, 0x3b, 0, 0x0},
    // 195: Local time: 10:07:00 PM
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x2c, 1093, 0x0},
    { 0, 0x2d, 0, 0x0},
    { 0, 0x2d, 29, 0x0},
    { 0, 0x1d, 759, 0x0},
    { 0, 0x65, 1172, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    // 210: Local time: 10:22:00 PM
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 11, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x5a, 534, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    // 225: Local time: 10:37:00 PM
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x4a, 568, 0x0},
    { 0, 0x57, 0, 0x0},
    { 0, 0x57, 0, 0x0},
    { 0, 0x57, 0, 0x0},
    { 0, 0x67, 2138, 0x0},
    // 240: Local time: 10:52:00 PM
    { 0, 0x60, 414, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x81, 287, 0x0},
    { 0, 0x76, 708, 0x0},
    { 8, 0x52, 4690, 0x0},
    { 0, 0x52, 3933, 0x0},
    { 59, 0x41, 5317, 0x0},
    { 0, 0x68, 2780, 0x0},
    // 255: Local time: 11:07:00 PM
    { 0, 0x5a, 165, 0x0},
    { 0, 0x5a, 0, 0x0},
    { 0, 0x5a, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x6a, 523, 0x0},
    { 0, 0x7a, 10, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 74, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    // 270: Local time: 11:22:00 PM
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6b, 404, 0x0},
    { 0, 0x6c, 2015, 0x0},
    { 0, 0x75, 96, 0x0},
    { 0, 0x75, 0, 0x0},
    { 0, 0x75, 0, 0x0},
    { 0, 0x1c, 1478, 0x0},
    // 285: Local time: 11:37:00 PM
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    // 300: Local time: 11:52:01 PM
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 11, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 19, 0x0},
    { 0, 0x1d, 0, 0x0},
    // 315: Local time: 12:07:00 AM
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    // 330: Local time: 12:22:00 AM
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x1d, 0, 0x0},
    { 0, 0x3d, 1690, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 460, 0x0},
    { 0, 0x6f, 651, 0x0},
    // 345: Local time: 12:37:00 AM
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    // 360: Local time: 12:52:00 AM
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 1306, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 387, 0x0},
    { 0, 0x5f, 0, 0x0},
    { 0, 0x5f, 0, 0x0},
    { 0, 0x5f, 0, 0x0},
    { 7, 0x5f, 1630, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 23, 0x0},
    // 375: Local time: 01:07:00 AM
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 0, 0x0},
    { 0, 0x77, 657, 0x0},
    { 0, 0x4c, 121, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    // 390: Local time: 01:22:00 AM
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 552, 0x0},
    { 0, 0x6c, 1941, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    // 405: Local time: 01:37:00 AM
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    // 420: Local time: 01:52:00 AM
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7e, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x7d, 0, 0x0},
    { 0, 0x6d, 1632, 0x0},
    { 0, 0x1c, 0, 0x0},
    // 435: Local time: 02:07:00 AM
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x5f, 1762, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 769, 0x0},
    { 0, 0x71, 1796, 0x0},
    { 0, 0x3b, 25, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    // 450: Local time: 02:22:00 AM
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    // 465: Local time: 02:37:00 AM
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    // 480: Local time: 02:52:00 AM
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 11, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    // 495: Local time: 03:07:00 AM
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x5b, 1961, 0x0},
    // 510: Local time: 03:22:00 AM
    { 0, 0x5b, 418, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    // 525: Local time: 03:37:00 AM
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x2b, 719, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    // 540: Local time: 03:52:00 AM
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 330, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x1c, 211, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    // 555: Local time: 04:07:00 AM
    { 0, 0x1c, 0, 0x0},
    { 0, 0x6f, 1551, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x71, 0, 0x0},
    { 0, 0x72, 1543, 0x0},
    { 0, 0x73, 0, 0x0},
    { 0, 0x73, 0, 0x0},
    { 0, 0x6e, 405, 0x0},
    { 0, 0x5e, 0, 0x0},
    { 0, 0x5e, 0, 0x0},
    { 0, 0x5e, 0, 0x0},
    // 570: Local time: 04:22:00 AM
    { 0, 0x5e, 0, 0x0},
    { 0, 0x5e, 0, 0x0},
    { 0, 0x5e, 0, 0x0},
    { 0, 0x5e, 0, 0x0},
    { 0, 0x5d, 1841, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4c, 303, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    // 585: Local time: 04:37:00 AM
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    // 600: Local time: 04:52:00 AM
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x6b, 1481, 0x0},
    { 0, 0x88, 0, 0x0},
    // 615: Local time: 05:07:00 AM
    { 0, 0x88, 0, 0x0},
    { 0, 0x88, 0, 0x0},
    { 0, 0x88, 0, 0x0},
    { 0, 0x87, 0, 0x0},
    { 0, 0x87, 0, 0x0},
    { 0, 0x5b, 794, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x6f, 2137, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x60, 0, 0x0},
    { 0, 0x51, 2936, 0x0},
    // 630: Local time: 05:22:00 AM
    { 0, 0x6b, 2686, 0x0},
    { 0, 0x7a, 0, 0x0},
    { 0, 0x5d, 1068, 0x0},
    { 16, 0x41, 3020, 0x0},
    { 0, 0x41, 1881, 0x0},
    { 0, 0x44, 1367, 0x0},
    { 0, 0x53, 2320, 0x0},
    { 21, 0x61, 3885, 0x0},
    { 0, 0x72, 22, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x72, 0, 0x0},
    { 0, 0x71, 236, 0x0},
    { 0, 0x8f, 0, 0x0},
    // 645: Local time: 05:37:00 AM
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 229, 0x0},
    { 0, 0x7f, 1105, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x70, 0, 0x0},
    { 0, 0x3e, 750, 0x0},
    { 0, 0x1d, 59, 0x0},
    { 0, 0x2d, 506, 0x0},
    { 0, 0x2d, 56, 0x0},
    { 0, 0x4c, 556, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x7a, 0, 0x0},
    { 0, 0x7a, 103, 0x0},
    // 660: Local time: 05:51:00 AM
    { 0, 0x7a, 0, 0x0},
    { 0, 0x7a, 0, 0x0},
    { 0, 0x7a, 0, 0x0},
    { 0, 0x7a, 0, 0x0},
    { 0, 0x7a, 0, 0x0},
    { 0, 0x7a, 0, 0x0},
    { 0, 0x7a, 0, 0x0},
    { 0, 0x6b, 1191, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 337, 0x0},
    { 0, 0x5b, 145, 0x0},
    // 675: Local time: 06:06:00 AM
    { 0, 0x4c, 808, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 350, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 20, 0x0},
    { 0, 0x3c, 20, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x4d, 856, 0x0},
    { 9, 0x52, 8564, 0x0},
    // 690: Local time: 06:21:00 AM
    { 0, 0x45, 2655, 0x0},
    { 0, 0x47, 1166, 0x0},
    { 0, 0x55, 1074, 0x0},
    { 0, 0x47, 50, 0x0},
    { 0, 0x47, 38, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 31, 0x0},
    { 0, 0x47, 11, 0x0},
    { 0, 0x47, 17, 0x0},
    { 0, 0x47, 19, 0x0},
    { 0, 0x47, 346, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 146, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 22, 0x0},
    // 705: Local time: 06:36:00 AM
    { 0, 0x47, 10, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 60, 0x0},
    { 0, 0x47, 84, 0x0},
    { 0, 0x47, 71, 0x0},
    { 0, 0x47, 189, 0x0},
    { 0, 0x57, 112, 0x0},
    { 0, 0x65, 2600, 0x0},
    { 0, 0x52, 4047, 0x0},
    { 0, 0x41, 1004, 0x0},
    { 0, 0x52, 4397, 0x0},
    { 0, 0x4b, 414, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    // 720: Local time: 06:51:00 AM
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 6, 0x4a, 648, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x4b, 93, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 500, 0x0},
    { 0, 0x59, 1223, 0x0},
    { 0, 0x59, 38, 0x0},
    { 0, 0x59, 32, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 0, 0x0},
    // 735: Local time: 07:06:00 AM
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 63, 0x0},
    { 0, 0x59, 31, 0x0},
    { 0, 0x59, 0, 0x0},
    { 0, 0x59, 97, 0x0},
    { 0, 0x69, 116, 0x0},
    { 0, 0x69, 20, 0x0},
    { 0, 0x69, 0, 0x0},
    { 0, 0x69, 11, 0x0},
    { 0, 0x69, 211, 0x0},
    { 0, 0x69, 0, 0x0},
    { 0, 0x61, 1468, 0x0},
    { 9, 0x51, 3589, 0x0},
    { 0, 0x47, 109, 0x0},
    { 0, 0x47, 34, 0x0},
    // 750: Local time: 07:21:00 AM
    { 0, 0x47, 22, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 233, 0x0},
    { 0, 0x47, 216, 0x0},
    { 0, 0x47, 22, 0x0},
    { 0, 0x47, 362, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 17, 0x0},
    { 0, 0x47, 155, 0x0},
    { 0, 0x47, 540, 0x0},
    { 0, 0x58, 208, 0x0},
    { 0, 0x66, 2437, 0x0},
    { 0, 0x51, 2655, 0x0},
    { 16, 0x41, 6143, 0x0},
    // 765: Local time: 07:36:00 AM
    { 13, 0x53, 3408, 0x0},
    { 8, 0x44, 3186, 0x0},
    { 11, 0x43, 3745, 0x0},
    { 7, 0x44, 2908, 0x0},
    { 11, 0x45, 3513, 0x0},
    { 0, 0x40, 1181, 0x0},
    { 0, 0x56, 1432, 0x0},
    { 13, 0x55, 1946, 0x0},
    { 18, 0x42, 3219, 0x0},
    { 6, 0x41, 2259, 0x0},
    { 8, 0x42, 4327, 0x0},
    { 0, 0x47, 17, 0x0},
    { 0, 0x47, 16, 0x0},
    { 0, 0x47, 229, 0x0},
    { 0, 0x47, 20, 0x0},
    // 780: Local time: 07:51:01 AM
    { 0, 0x47, 14, 0x0},
    { 0, 0x47, 23, 0x0},
    { 0, 0x47, 213, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 19, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 14, 0x0},
    { 0, 0x47, 47, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 39, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x63, 1512, 0x0},
    { 12, 0x52, 4055, 0x0},
    { 0, 0x51, 3997, 0x0},
    // 795: Local time: 08:06:00 AM
    { 6, 0x53, 1972, 0x0},
    { 39, 0x42, 4755, 0x0},
    { 0, 0x46, 264, 0x0},
    { 0, 0x47, 10, 0x0},
    { 0, 0x47, 278, 0x0},
    { 0, 0x43, 4363, 0x0},
    { 6, 0x32, 1579, 0x0},
    { 0, 0x35, 78, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 445, 0x0},
    { 0, 0x44, 668, 0x0},
    { 0, 0x34, 291, 0x0},
    { 0, 0x34, 0, 0x0},
    { 0, 0x34, 0, 0x0},
    // 810: Local time: 08:21:00 AM
    { 0, 0x34, 677, 0x0},
    { 0, 0x34, 84, 0x0},
    { 0, 0x34, 50, 0x0},
    { 0, 0x54, 3713, 0x0},
    { 0, 0x51, 5563, 0x0},
    { 0, 0x66, 3367, 0x0},
    { 0, 0x78, 0, 0x0},
    { 0, 0x78, 45, 0x0},
    { 0, 0x78, 0, 0x0},
    { 0, 0x78, 165, 0x0},
    { 0, 0x78, 0, 0x0},
    { 0, 0x78, 0, 0x0},
    { 0, 0x78, 0, 0x0},
    { 0, 0x78, 0, 0x0},
    { 0, 0x78, 0, 0x0},
    // 825: Local time: 08:36:01 AM
    { 0, 0x78, 14, 0x0},
    { 0, 0x78, 2535, 0x0},
    { 0, 0x53, 10869, 0x0},
    { 12, 0x63, 9047, 0x0},
    { 14, 0x51, 8382, 0x0},
    { 0, 0x60, 69, 0x0},
    { 0, 0x63, 7983, 0x0},
    { 0, 0x51, 5039, 0x0},
    { 16, 0x42, 7053, 0x0},
    { 0, 0x43, 6207, 0x0},
    { 14, 0x34, 2986, 0x0},
    { 12, 0x43, 5578, 0x0},
    { 0, 0x66, 6199, 0x1},
    { 0, 0x46, 1873, 0x1},
    { 7, 0x69, 4567, 0x1},
    // 840: Local time: 08:51:00 AM
    { 0, 0x69, 248, 0x1},
    { 0, 0x59, 1364, 0x1},
    { 0, 0x78, 2949, 0x1},
    { 0, 0x79, 2590, 0x1},
    { 0, 0x5a, 988, 0x1},
    { 0, 0x5a, 1028, 0x1},
    { 0, 0x69, 1971, 0x1},
    { 0, 0x77, 1493, 0x1},
    { 0, 0x66, 633, 0x1},
    { 0, 0x79, 1265, 0x1},
    { 0, 0x79, 666, 0x1},
    { 0, 0x69, 600, 0x1},
    { 0, 0x59, 1256, 0x1},
    { 0, 0x59, 390, 0x1},
    { 0, 0x5a, 671, 0x1},
    // 855: Local time: 09:06:00 AM
    { 0, 0x68, 2468, 0x1},
    { 0, 0x6a, 1201, 0x1},
    { 0, 0x6a, 960, 0x1},
    { 0, 0x77, 728, 0x1},
    { 0, 0x78, 492, 0x1},
    { 0, 0x79, 2749, 0x1},
    { 0, 0x79, 809, 0x1},
    { 0, 0x6a, 222, 0x1},
    { 0, 0x6a, 566, 0x1},
    { 0, 0x6a, 639, 0x1},
    { 6, 0x6b, 1839, 0x1},
    { 7, 0x6b, 2114, 0x1},
    { 0, 0x6c, 1274, 0x1},
    { 0, 0x6b, 960, 0x1},
    { 0, 0x6c, 263, 0x1},
    // 870: Local time: 09:21:00 AM
    { 15, 0x6c, 1132, 0x1},
    { 0, 0x69, 1382, 0x1},
    { 0, 0x6a, 2162, 0x1},
    { 6, 0x69, 2576, 0x1},
    { 0, 0x78, 2313, 0x1},
    { 0, 0x67, 1953, 0x1},
    { 0, 0x7a, 1628, 0x1},
    { 0, 0x75, 1592, 0x0},
    { 0, 0x79, 1414, 0x0},
    { 0, 0x8c, 2116, 0x0},
    { 0, 0x79, 1502, 0x0},
    { 0, 0x79, 991, 0x0},
    { 0, 0x79, 66, 0x0},
    { 0, 0x79, 1955, 0x0},
    { 10, 0x77, 3537, 0x0},
    // 885: Local time: 09:36:00 AM
    { 0, 0x6b, 4191, 0x0},
    { 0, 0x5c, 2570, 0x0},
    { 26, 0x5c, 3689, 0x0},
    { 6, 0x79, 7394, 0x0},
    { 31, 0x62, 8018, 0x0},
    { 12, 0x41, 3845, 0x0},
    { 19, 0x44, 3618, 0x0},
    { 18, 0x41, 4189, 0x0},
    { 0, 0x41, 6710, 0x0},
    { 12, 0x73, 2444, 0x0},
    { 0, 0x72, 3960, 0x0},
    { 0, 0x79, 2595, 0x0},
    { 0, 0x7b, 663, 0x0},
    { 0, 0x75, 2151, 0x0},
    { 8, 0x55, 3572, 0x0},
    // 900: Local time: 09:51:00 AM
    { 6, 0x35, 3930, 0x0},
    { 16, 0x43, 4216, 0x0},
    { 0, 0x45, 3276, 0x0},
    { 0, 0x44, 3404, 0x0},
    { 0, 0x62, 1863, 0x0},
    { 0, 0x7d, 4904, 0x0},
    { 0, 0x7d, 962, 0x0},
    { 13, 0x53, 4589, 0x0},
    { 0, 0x61, 170, 0x0},
    { 20, 0x51, 7858, 0x0},
    { 26, 0x52, 6242, 0x0},
    { 9, 0x41, 1598, 0x0},
    { 0, 0x42, 1151, 0x0},
    { 0, 0x43, 742, 0x0},
    { 0, 0x35, 156, 0x0},
    // 915: Local time: 10:06:00 AM
    { 0, 0x43, 1271, 0x0},
    { 0, 0x43, 3963, 0x0},
    { 15, 0x34, 2277, 0x0},
    { 8, 0x53, 3455, 0x0},
    { 70, 0x51, 6260, 0x0},
    { 50, 0x41, 5736, 0x0},
    { 42, 0x40, 6392, 0x0},
    { 24, 0x6f, 7561, 0x0},
    { 8, 0x62, 2909, 0x0},
    { 0, 0x6c, 436, 0x0},
    { 24, 0x41, 6004, 0x0},
    { 89, 0x41, 7931, 0x0},
    { 16, 0x59, 2328, 0x0},
    { 29, 0x59, 2809, 0x0},
    { 0, 0x51, 4027, 0x0},
    // 930: Local time: 10:21:00 AM
    { 0, 0x41, 1149, 0x0},
    { 0, 0x41, 959, 0x0},
    { 0, 0x63, 5988, 0x0},
    { 30, 0x47, 9267, 0x0},
    { 0, 0x77, 8029, 0x0},
    { 0, 0x8d, 2859, 0x0},
    { 66, 0x44, 4619, 0x0},
    { 71, 0x42, 6054, 0x0},
    { 0, 0x66, 3735, 0x0},
    { 0, 0x65, 2780, 0x0},
    { 0, 0x67, 1702, 0x0},
    { 0, 0x55, 0, 0x0},
    { 0, 0x44, 1750, 0x0},
    { 0, 0x57, 2677, 0x0},
    { 0, 0x57, 2212, 0x0},
    // 945: Local time: 10:36:00 AM
    { 0, 0x67, 991, 0x0},
    { 0, 0x56, 1154, 0x0},
    { 18, 0x76, 3155, 0x0},
    { 0, 0x7e, 618, 0x0},
    { 0, 0x71, 448, 0x0},
    { 0, 0x53, 330, 0x0},
    { 0, 0x63, 1650, 0x0},
    { 0, 0x86, 1037, 0x0},
    { 0, 0x75, 5635, 0x0},
    { 37, 0x62, 3328, 0x0},
    { 0, 0x44, 1407, 0x0},
    { 0, 0x44, 2311, 0x0},
    { 0, 0x75, 2339, 0x0},
    { 0, 0x57, 1764, 0x0},
    { 8, 0x68, 390, 0x0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

// ----------------------------------------------------------------
// Sample captured at: 2015-09-13 23:34:00 local, 2015-09-14 06:34:00 GMT
// According to Itai:
//  went to sleep around 1:30am (offset 239)
//  woke up at 7:00am (offset 570)
AlgDlsMinuteData *activity_sample_sleep_7(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_7
  //> TEST_VERSION 2
  //> TEST_TOTAL -1
  //> TEST_TOTAL_MIN -1
  //> TEST_TOTAL_MAX -1
  //> TEST_DEEP -1
  //> TEST_DEEP_MIN -1
  //> TEST_DEEP_MAX -1
  //> TEST_START_AT 239
  //> TEST_START_AT_MIN 180
  //> TEST_START_AT_MAX 260
  //> TEST_END_AT 570
  //> TEST_END_AT_MIN 560
  //> TEST_END_AT_MAX 580
  //> TEST_CUR_STATE_ELAPSED 130
  //> TEST_CUR_STATE_ELAPSED_MIN 120
  //> TEST_CUR_STATE_ELAPSED_MAX 140
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc, flags}
  static AlgDlsMinuteData samples[] = { 
    // 0: Local time: 09:30:01 PM
    { 0, 0x58, 999, 0x0},
    { 0, 0x57, 415, 0x0},
    { 0, 0x57, 818, 0x0},
    { 0, 0x64, 1247, 0x0},
    { 0, 0x55, 2624, 0x0},
    { 0, 0x56, 1519, 0x0},
    { 0, 0x57, 1386, 0x0},
    { 0, 0x57, 1346, 0x0},
    { 0, 0x57, 972, 0x0},
    { 0, 0x57, 2755, 0x0},
    { 0, 0x48, 273, 0x0},
    { 0, 0x58, 333, 0x0},
    { 0, 0x58, 325, 0x0},
    { 0, 0x58, 364, 0x0},
    { 0, 0x58, 242, 0x0},
    // 15: Local time: 09:45:00 PM
    { 18, 0x67, 845, 0x0},
    { 7, 0x74, 1546, 0x0},
    { 0, 0x74, 516, 0x0},
    { 0, 0x84, 652, 0x0},
    { 0, 0x77, 365, 0x0},
    { 0, 0x75, 1080, 0x0},
    { 0, 0x7e, 71, 0x0},
    { 0, 0x7e, 16, 0x0},
    { 0, 0x8e, 13, 0x0},
    { 0, 0x8f, 25, 0x0},
    { 0, 0x8f, 0, 0x0},
    { 0, 0x8f, 31, 0x0},
    { 0, 0x8f, 26, 0x0},
    { 0, 0x66, 1312, 0x0},
    { 0, 0x48, 193, 0x0},
    // 30: Local time: 10:00:00 PM
    { 0, 0x48, 753, 0x0},
    { 0, 0x58, 778, 0x0},
    { 0, 0x57, 1237, 0x0},
    { 0, 0x57, 1102, 0x0},
    { 0, 0x58, 1511, 0x0},
    { 0, 0x58, 1112, 0x0},
    { 0, 0x77, 1101, 0x0},
    { 10, 0x5e, 2957, 0x0},
    { 0, 0x51, 5108, 0x0},
    { 6, 0x78, 4743, 0x0},
    { 0, 0x75, 2296, 0x0},
    { 0, 0x77, 3392, 0x0},
    { 0, 0x76, 4034, 0x0},
    { 0, 0x75, 2813, 0x0},
    { 0, 0x76, 2755, 0x0},
    // 45: Local time: 10:15:00 PM
    { 0, 0x67, 2394, 0x0},
    { 8, 0x77, 3349, 0x0},
    { 6, 0x66, 3615, 0x0},
    { 0, 0x65, 2772, 0x0},
    { 0, 0x78, 3523, 0x0},
    { 18, 0x78, 2551, 0x0},
    { 7, 0x77, 2476, 0x0},
    { 0, 0x78, 2705, 0x0},
    { 0, 0x77, 2259, 0x0},
    { 19, 0x63, 4696, 0x0},
    { 26, 0x51, 4623, 0x0},
    { 59, 0x41, 4385, 0x0},
    { 26, 0x51, 3608, 0x0},
    { 26, 0x42, 6238, 0x0},
    { 0, 0x65, 4417, 0x0},
    // 60: Local time: 10:30:00 PM
    { 0, 0x65, 1081, 0x0},
    { 0, 0x65, 266, 0x0},
    { 0, 0x65, 236, 0x0},
    { 0, 0x75, 593, 0x0},
    { 0, 0x75, 577, 0x0},
    { 0, 0x75, 136, 0x0},
    { 0, 0x65, 244, 0x0},
    { 0, 0x66, 10, 0x0},
    { 0, 0x65, 116, 0x0},
    { 0, 0x66, 173, 0x0},
    { 0, 0x65, 156, 0x0},
    { 7, 0x65, 3643, 0x0},
    { 0, 0x75, 233, 0x0},
    { 0, 0x76, 118, 0x0},
    { 0, 0x76, 85, 0x0},
    // 75: Local time: 10:45:00 PM
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 287, 0x0},
    { 0, 0x76, 91, 0x0},
    { 0, 0x76, 359, 0x0},
    { 0, 0x76, 32, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 0, 0x0},
    { 0, 0x76, 482, 0x0},
    { 0, 0x65, 278, 0x0},
    { 0, 0x66, 587, 0x0},
    { 0, 0x66, 190, 0x0},
    { 0, 0x75, 239, 0x0},
    { 0, 0x65, 0, 0x0},
    // 90: Local time: 11:01:00 PM
    { 0, 0x65, 655, 0x0},
    { 0, 0x65, 62, 0x0},
    { 8, 0x65, 633, 0x0},
    { 6, 0x79, 2086, 0x0},
    { 0, 0x7b, 41, 0x0},
    { 0, 0x7b, 68, 0x0},
    { 0, 0x7b, 834, 0x0},
    { 0, 0x7c, 0, 0x0},
    { 0, 0x7b, 686, 0x0},
    { 0, 0x7c, 0, 0x0},
    { 0, 0x7c, 0, 0x0},
    { 7, 0x7c, 580, 0x0},
    { 0, 0x4b, 734, 0x0},
    { 0, 0x4d, 809, 0x0},
    { 0, 0x68, 2292, 0x0},
    // 105: Local time: 11:16:00 PM
    { 0, 0x69, 125, 0x0},
    { 0, 0x69, 29, 0x0},
    { 0, 0x69, 124, 0x0},
    { 0, 0x69, 31, 0x0},
    { 0, 0x69, 13, 0x0},
    { 0, 0x69, 0, 0x0},
    { 0, 0x69, 13, 0x0},
    { 0, 0x69, 13, 0x0},
    { 0, 0x69, 0, 0x0},
    { 0, 0x69, 1767, 0x0},
    { 0, 0x6a, 2385, 0x0},
    { 0, 0x69, 69, 0x0},
    { 0, 0x69, 0, 0x0},
    { 0, 0x69, 48, 0x0},
    { 0, 0x67, 2156, 0x0},
    // 120: Local time: 11:31:00 PM
    { 0, 0x66, 103, 0x0},
    { 0, 0x7b, 782, 0x0},
    { 0, 0x6c, 133, 0x0},
    { 0, 0x6c, 0, 0x0},
    { 0, 0x6c, 0, 0x0},
    { 0, 0x6c, 455, 0x0},
    { 0, 0x6c, 0, 0x0},
    { 0, 0x6c, 0, 0x0},
    { 0, 0x6c, 134, 0x0},
    { 0, 0x6c, 149, 0x0},
    { 0, 0x5c, 62, 0x0},
    { 0, 0x6c, 102, 0x0},
    { 0, 0x6c, 205, 0x0},
    { 0, 0x78, 355, 0x0},
    { 0, 0x77, 528, 0x0},
    // 135: Local time: 11:46:00 PM
    { 18, 0x62, 4367, 0x0},
    { 8, 0x62, 3993, 0x0},
    { 0, 0x68, 145, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 230, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 19, 0x0},
    { 0, 0x68, 547, 0x0},
    { 0, 0x68, 1013, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x58, 1075, 0x0},
    { 0, 0x68, 1811, 0x0},
    { 0, 0x68, 20, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    // 150: Local time: 12:01:00 AM
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 0, 0x0},
    { 0, 0x68, 337, 0x0},
    { 0, 0x79, 1052, 0x0},
    { 0, 0x6a, 663, 0x0},
    { 0, 0x69, 179, 0x0},
    { 0, 0x69, 446, 0x0},
    { 0, 0x69, 506, 0x0},
    { 0, 0x6a, 865, 0x0},
    { 9, 0x77, 2461, 0x0},
    { 0, 0x65, 3189, 0x0},
    { 0, 0x75, 148, 0x0},
    { 0, 0x76, 217, 0x0},
    { 8, 0x7f, 2018, 0x0},
    { 0, 0x75, 300, 0x0},
    // 165: Local time: 12:16:00 AM
    { 0, 0x76, 275, 0x0},
    { 0, 0x7f, 1031, 0x0},
    { 0, 0x79, 1813, 0x0},
    { 0, 0x67, 1558, 0x0},
    { 9, 0x67, 1916, 0x0},
    { 6, 0x65, 988, 0x0},
    { 0, 0x66, 1266, 0x0},
    { 0, 0x59, 261, 0x0},
    { 0, 0x4a, 204, 0x0},
    { 0, 0x39, 79, 0x0},
    { 0, 0x39, 259, 0x0},
    { 0, 0x4a, 1542, 0x0},
    { 0, 0x75, 393, 0x0},
    { 0, 0x75, 176, 0x0},
    { 0, 0x86, 159, 0x0},
    // 180: Local time: 12:31:00 AM
    { 0, 0x87, 38, 0x0},
    { 0, 0x77, 38, 0x0},
    { 0, 0x76, 78, 0x0},
    { 0, 0x75, 0, 0x0},
    { 0, 0x75, 76, 0x0},
    { 0, 0x75, 37, 0x0},
    { 0, 0x75, 0, 0x0},
    { 0, 0x75, 0, 0x0},
    { 0, 0x75, 180, 0x0},
    { 0, 0x75, 0, 0x0},
    { 0, 0x76, 47, 0x0},
    { 0, 0x8b, 657, 0x0},
    { 0, 0x75, 489, 0x0},
    { 0, 0x64, 1591, 0x0},
    { 20, 0x51, 5780, 0x0},
    // 195: Local time: 12:46:00 AM
    { 0, 0x65, 5018, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    // 210: Local time: 01:01:00 AM
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    // 225: Local time: 01:16:00 AM
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 0, 0x0},
    { 0, 0x48, 1475, 0x0},
    { 0, 0x51, 1913, 0x0},
    { 0, 0x51, 3260, 0x0},
    { 31, 0x41, 4394, 0x0},
    { 0, 0x67, 2214, 0x0},
    { 0, 0x68, 39, 0x0},
    { 0, 0x69, 0, 0x0},
    { 0, 0x69, 217, 0x0},
    // 240: Local time: 01:31:00 AM
    { 0, 0x68, 59, 0x0},
    { 0, 0x68, 59, 0x0},
    { 0, 0x68, 38, 0x0},
    { 0, 0x68, 121, 0x0},
    { 0, 0x58, 150, 0x0},
    { 0, 0x58, 42, 0x0},
    { 0, 0x58, 122, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 22, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x68, 3137, 0x0},
    { 0, 0x6e, 1422, 0x0},
    { 0, 0x7f, 947, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 11, 0x0},
    // 255: Local time: 01:46:00 AM
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 17, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 0, 0x0},
    { 0, 0x7f, 182, 0x0},
    { 0, 0x6f, 1334, 0x0},
    // 270: Local time: 02:01:00 AM
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    // 285: Local time: 02:16:00 AM
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 149, 0x0},
    { 0, 0x22, 757, 0x0},
    { 0, 0x23, 0, 0x0},
    { 0, 0x23, 0, 0x0},
    { 0, 0x23, 0, 0x0},
    { 0, 0x23, 0, 0x0},
    { 0, 0x23, 0, 0x0},
    { 0, 0x23, 0, 0x0},
    { 0, 0x23, 0, 0x0},
    { 0, 0x23, 0, 0x0},
    { 0, 0x23, 0, 0x0},
    { 0, 0x23, 0, 0x0},
    { 0, 0x23, 0, 0x0},
    // 300: Local time: 02:31:00 AM
    { 0, 0x23, 0, 0x0},
    { 0, 0x4c, 1589, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    // 315: Local time: 02:46:00 AM
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 22, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x6b, 1320, 0x0},
    { 0, 0x6a, 82, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 248, 0x0},
    { 0, 0x6b, 0, 0x0},
    // 330: Local time: 03:01:01 AM
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 245, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 11, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    // 345: Local time: 03:16:00 AM
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7b, 0, 0x0},
    { 0, 0x7c, 2304, 0x0},
    { 0, 0x6f, 668, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    // 360: Local time: 03:31:00 AM
    { 0, 0x6f, 17, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 26, 0x0},
    { 0, 0x4b, 1548, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    // 375: Local time: 03:46:01 AM
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    // 390: Local time: 04:01:00 AM
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x3c, 452, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    // 405: Local time: 04:16:00 AM
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    // 420: Local time: 04:31:00 AM
    { 0, 0x5e, 1956, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    // 435: Local time: 04:46:00 AM
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 100, 0x0},
    { 0, 0x6f, 386, 0x0},
    // 450: Local time: 05:01:00 AM
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 827, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 26, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x5d, 1379, 0x0},
    { 0, 0x4c, 17, 0x0},
    // 465: Local time: 05:16:00 AM
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 23, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    // 480: Local time: 05:31:00 AM
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 113, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x2c, 623, 0x0},
    // 495: Local time: 05:46:01 AM
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 0, 0x0},
    { 0, 0x2c, 16, 0x0},
    { 0, 0x2c, 171, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 259, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 510: Local time: 06:01:00 AM
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 525: Local time: 06:16:00 AM
    { 0, 0x2b, 0, 0x0},
    { 0, 0x3c, 1620, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    // 540: Local time: 06:31:00 AM
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x6f, 0, 0x0},
    { 0, 0x7e, 1907, 0x0},
    // 555: Local time: 06:46:00 AM  NOTE: This 15 minute block was originally missing from the data
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 570: Local time: 07:01:00AM
    { 0, 0x65, 1823, 0x0},
    { 0, 0x3c, 2036, 0x0},
    { 0, 0x2a, 4786, 0x0},
    { 0, 0x28, 3628, 0x0},
    { 0, 0x1b, 839, 0x0},
    { 0, 0x16, 1385, 0x0},
    { 9, 0x44, 2680, 0x0},
    { 0, 0x44, 507, 0x0},
    { 7, 0x44, 2798, 0x0},
    { 0, 0x47, 535, 0x0},
    { 0, 0x57, 559, 0x0},
    { 0, 0x64, 1545, 0x0},
    { 0, 0x54, 1959, 0x0},
    { 8, 0x62, 5481, 0x0},
    { 0, 0x47, 301, 0x0},
    // 585: Local time: 07:16:00 AM
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 276, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 10, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 29, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 186, 0x0},
    { 0, 0x47, 79, 0x0},
    { 0, 0x47, 38, 0x0},
    { 0, 0x47, 78, 0x0},
    { 0, 0x47, 180, 0x0},
    { 0, 0x47, 0, 0x0},
    // 600: Local time: 07:31:01 AM
    { 0, 0x47, 59, 0x0},
    { 8, 0x47, 717, 0x0},
    { 0, 0x44, 5774, 0x0},
    { 9, 0x41, 2637, 0x0},
    { 0, 0x42, 3907, 0x0},
    { 0, 0x6f, 3424, 0x0},
    { 0, 0x86, 321, 0x0},
    { 0, 0x83, 0, 0x0},
    { 0, 0x83, 0, 0x0},
    { 0, 0x83, 0, 0x0},
    { 0, 0x83, 0, 0x0},
    { 0, 0x83, 0, 0x0},
    { 0, 0x83, 0, 0x0},
    { 0, 0x83, 0, 0x0},
    { 0, 0x83, 0, 0x0},
    // 615: Local time: 07:46:00 AM
    { 0, 0x83, 0, 0x0},
    { 0, 0x83, 0, 0x0},
    { 0, 0x83, 0, 0x0},
    { 0, 0x83, 0, 0x0},
    { 0, 0x63, 4195, 0x0},
    { 0, 0x54, 7876, 0x0},
    { 0, 0x63, 4499, 0x0},
    { 0, 0x42, 7351, 0x0},
    { 26, 0x42, 4576, 0x0},
    { 0, 0x42, 4070, 0x0},
    { 28, 0x53, 4878, 0x0},
    { 10, 0x41, 3830, 0x0},
    { 0, 0x54, 7204, 0x0},
    { 0, 0x41, 1761, 0x0},
    { 8, 0x42, 6924, 0x0},
    // 630: Local time: 08:01:00 AM
    { 58, 0x51, 4956, 0x0},
    { 10, 0x45, 2643, 0x0},
    { 9, 0x47, 1863, 0x0},
    { 8, 0x46, 2847, 0x0},
    { 33, 0x42, 4940, 0x0},
    { 0, 0x41, 581, 0x0},
    { 0, 0x62, 1696, 0x0},
    { 0, 0x63, 0, 0x0},
    { 0, 0x47, 475, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 0, 0x0},
    { 0, 0x47, 11, 0x0},
    { 0, 0x47, 35, 0x0},
    { 0, 0x47, 186, 0x0},
    // 645: Local time: 08:15:00 AM
    { 0, 0x58, 0, 0x0},
    { 0, 0x58, 17, 0x0},
    { 0, 0x58, 0, 0x0},
    { 0, 0x57, 48, 0x0},
    { 0, 0x57, 11, 0x0},
    { 0, 0x57, 0, 0x0},
    { 0, 0x57, 60, 0x0},
    { 6, 0x45, 4025, 0x0},
    { 6, 0x42, 3997, 0x0},
    { 8, 0x51, 6886, 0x0},
    { 15, 0x43, 8656, 0x0},
    { 8, 0x52, 5791, 0x0},
    { 29, 0x41, 7302, 0x0},
    { 32, 0x42, 6094, 0x0},
    { 38, 0x41, 3156, 0x0},
    // 660: Local time: 08:30:00 AM
    { 0, 0x85, 5964, 0x0},
    { 0, 0x69, 694, 0x0},
    { 8, 0x68, 1620, 0x0},
    { 0, 0x78, 4072, 0x0},
    { 0, 0x67, 2951, 0x0},
    { 0, 0x66, 2387, 0x0},
    { 0, 0x68, 1182, 0x0},
    { 0, 0x77, 2712, 0x0},
    { 0, 0x77, 1104, 0x0},
    { 0, 0x77, 3374, 0x0},
    { 0, 0x68, 1851, 0x0},
    { 0, 0x7a, 2129, 0x0},
    { 0, 0x78, 2061, 0x0},
    { 8, 0x78, 1505, 0x0},
    { 0, 0x79, 951, 0x0},
    // 675: Local time: 08:45:00 AM
    { 0, 0x79, 404, 0x0},
    { 0, 0x78, 1496, 0x0},
    { 0, 0x78, 830, 0x0},
    { 0, 0x79, 1555, 0x0},
    { 0, 0x79, 895, 0x0},
    { 0, 0x77, 1130, 0x0},
    { 0, 0x79, 1630, 0x0},
    { 0, 0x79, 609, 0x0},
    { 0, 0x7a, 575, 0x0},
    { 0, 0x7a, 1117, 0x0},
    { 0, 0x79, 1512, 0x0},
    { 0, 0x79, 1247, 0x0},
    { 0, 0x79, 1206, 0x0},
    { 0, 0x79, 1469, 0x0},
    { 0, 0x79, 1053, 0x0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured at: 2015-09-16 11:06:00 local, 2015-09-16 18:06:00 GMT
AlgDlsMinuteData *activity_sample_sleep_watch_on_table_2(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME watch_on_table_2
  //> TEST_VERSION 2
  //> TEST_TOTAL 0
  //> TEST_TOTAL_MIN 0
  //> TEST_TOTAL_MAX 0
  //> TEST_DEEP 0
  //> TEST_DEEP_MIN 0
  //> TEST_DEEP_MAX 0
  //> TEST_START_AT -1
  //> TEST_START_AT_MIN -1
  //> TEST_START_AT_MAX -1
  //> TEST_END_AT -1
  //> TEST_END_AT_MIN -1
  //> TEST_END_AT_MAX -1
  //> TEST_CUR_STATE_ELAPSED 225
  //> TEST_CUR_STATE_ELAPSED_MIN 225
  //> TEST_CUR_STATE_ELAPSED_MAX 225
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 100.0
  // list of: { steps, orientation, vmc, light}
  static AlgDlsMinuteData samples[] = { 
    { 0, 0x0, 0, 207},
    { 0, 0x8c, 174, 206},
    { 0, 0x7c, 233, 210},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 31, 205},
    { 0, 0x7c, 0, 198},
    { 0, 0x8c, 11, 204},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 202},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 206},
    // 15: Local time: 11:21:00 AM
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 209},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 209},
    { 0, 0x8c, 0, 211},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 202},
    { 0, 0x8c, 0, 202},
    { 0, 0x8c, 0, 201},
    { 0, 0x8c, 0, 201},
    // 30: Local time: 11:36:00 AM
    { 0, 0x8c, 0, 201},
    { 0, 0x8c, 0, 201},
    { 0, 0x8c, 0, 200},
    { 0, 0x8c, 0, 200},
    { 0, 0x8c, 0, 200},
    { 0, 0x8c, 0, 201},
    { 0, 0x8c, 0, 201},
    { 0, 0x8c, 0, 201},
    { 0, 0x8c, 0, 202},
    { 0, 0x8c, 0, 200},
    { 0, 0x8c, 91, 209},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 202},
    // 45: Local time: 11:51:00 AM
    { 0, 0x8c, 0, 202},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 201},
    { 0, 0x8c, 0, 201},
    { 0, 0x8c, 0, 201},
    { 0, 0x8c, 0, 200},
    { 0, 0x8c, 19, 201},
    { 0, 0x8c, 0, 200},
    { 0, 0x8c, 0, 200},
    { 0, 0x8c, 0, 201},
    // 60: Local time: 12:06:00 PM
    { 0, 0x8c, 0, 201},
    { 0, 0x8c, 0, 201},
    { 0, 0x8c, 0, 202},
    { 0, 0x8c, 0, 202},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 206},
    // 75: Local time: 12:21:00 PM
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 207},
    // 90: Local time: 12:36:00 PM
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 212},
    { 0, 0x8c, 0, 210},
    { 0, 0x8c, 0, 210},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 210},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 209},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 212},
    { 0, 0x8c, 0, 206},
    // 105: Local time: 12:51:00 PM
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 210},
    // 120: Local time: 01:06:00 PM
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 214},
    { 0, 0x8c, 0, 211},
    { 0, 0x8c, 0, 211},
    { 0, 0x8c, 0, 212},
    { 0, 0x8c, 0, 213},
    { 0, 0x8c, 0, 214},
    { 0, 0x8c, 0, 214},
    { 0, 0x8c, 0, 215},
    { 0, 0x8c, 0, 211},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    // 135: Local time: 01:21:00 PM
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 211},
    { 0, 0x8c, 26, 208},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 207},
    // 150: Local time: 01:36:00 PM
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 212},
    { 0, 0x8c, 0, 213},
    { 0, 0x8c, 0, 210},
    { 0, 0x8c, 0, 210},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 210},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 13, 206},
    { 0, 0x8c, 0, 212},
    { 0, 0x8c, 0, 209},
    // 165: Local time: 01:51:00 PM
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 209},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 19, 210},
    // 180: Local time: 02:06:00 PM
    { 0, 0x8c, 0, 209},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 209},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 209},
    { 0, 0x8c, 0, 207},
    { 0, 0x8c, 0, 208},
    { 0, 0x8c, 0, 210},
    { 0, 0x8c, 0, 206},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 205},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 204},
    // 195: Local time: 02:21:00 PM
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 202},
    // 210: Local time: 02:36:00 PM
    { 0, 0x8c, 0, 202},
    { 0, 0x8c, 0, 202},
    { 0, 0x8c, 0, 202},
    { 0, 0x8c, 0, 203},
    { 0, 0x8c, 0, 204},
    { 0, 0x8c, 0, 204},
    { 0, 0x7c, 195, 205},
    { 0, 0x7c, 0, 206},
    { 0, 0x7c, 0, 206},
    { 0, 0x7c, 0, 206},
    { 0, 0x7c, 0, 206},
    { 0, 0x7c, 0, 207},
    { 0, 0x7c, 0, 207},
    { 0, 0x7c, 0, 207},
    { 0, 0x7c, 0, 207},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



// ----------------------------------------------------------------
// Sample captured at: 2015-09-16 20:02:00 local, 2015-09-17 03:02:00 GMT
// According to Fitbit:
//   sleep entry 9:06pn (offset 65)
//   sleep exit 6:03am (offset 602)
//     Fitbit was wrong here, the real wake time is closer to 4:50am (offset 529)
//   total sleep 477 min
//     Fitbit was wrong here, the total sleep is closer to 420 min)
AlgDlsMinuteData *activity_sample_sleep_8(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_8
  //> TEST_VERSION 2
  //> TEST_TOTAL 420
  //> TEST_TOTAL_MIN 400
  //> TEST_TOTAL_MAX 440
  //> TEST_DEEP -1
  //> TEST_DEEP_MIN -1
  //> TEST_DEEP_MAX -1
  //> TEST_START_AT 65
  //> TEST_START_AT_MIN 60
  //> TEST_START_AT_MAX 75
  //> TEST_END_AT 529
  //> TEST_END_AT_MIN 510
  //> TEST_END_AT_MAX 550
  //> TEST_CUR_STATE_ELAPSED -1
  //> TEST_CUR_STATE_ELAPSED_MIN -1
  //> TEST_CUR_STATE_ELAPSED_MAX -1
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc, light}
  static AlgDlsMinuteData samples[] = { 
    { 0, 0x79, 119, 242},
    { 0, 0x79, 3038, 164},
    { 0, 0x52, 5894, 157},
    { 17, 0x53, 9998, 158},
    { 0, 0x64, 6662, 164},
    { 0, 0x62, 6429, 160},
    { 0, 0x24, 3196, 165},
    { 37, 0x45, 5848, 163},
    { 0, 0x53, 8054, 144},
    { 42, 0x50, 7518, 242},
    { 0, 0x65, 6517, 151},
    { 0, 0x0, 0, 160},
    { 0, 0x53, 10894, 158},
    { 14, 0x65, 7391, 164},
    { 13, 0x74, 7875, 164},
    // 15: Local time: 08:16:00 PM
    { 51, 0x54, 4891, 161},
    { 0, 0x52, 6649, 154},
    { 14, 0x52, 6164, 156},
    { 47, 0x41, 3883, 157},
    { 0, 0x51, 2051, 158},
    { 0, 0x50, 364, 159},
    { 0, 0x4f, 1145, 164},
    { 18, 0x52, 5200, 145},
    { 0, 0x41, 4027, 167},
    { 0, 0x51, 3291, 164},
    { 0, 0x75, 4844, 171},
    { 6, 0x63, 3448, 165},
    { 0, 0x54, 3859, 166},
    { 0, 0x41, 5616, 168},
    { 10, 0x42, 4413, 167},
    // 30: Local time: 08:31:00 PM
    { 0, 0x42, 1864, 165},
    { 7, 0x42, 1558, 167},
    { 10, 0x63, 3324, 166},
    { 0, 0x53, 4912, 173},
    { 0, 0x52, 9759, 163},
    { 6, 0x52, 3276, 231},
    { 0, 0x61, 2557, 171},
    { 12, 0x61, 3461, 157},
    { 17, 0x41, 7191, 163},
    { 0, 0x51, 1275, 168},
    { 14, 0x41, 1889, 148},
    { 48, 0x43, 3235, 156},
    { 0, 0x34, 254, 158},
    { 0, 0x68, 1212, 162},
    { 0, 0x68, 1037, 155},
    // 45: Local time: 08:46:00 PM
    { 0, 0x51, 4663, 164},
    { 14, 0x52, 4543, 171},
    { 46, 0x42, 6731, 157},
    { 18, 0x64, 7604, 158},
    { 10, 0x52, 1651, 132},
    { 9, 0x53, 2339, 168},
    { 0, 0x74, 9892, 189},
    { 0, 0x57, 818, 153},
    { 0, 0x57, 0, 151},
    { 0, 0x56, 50, 151},
    { 0, 0x56, 0, 151},
    { 0, 0x56, 16, 151},
    { 0, 0x57, 11, 151},
    { 0, 0x57, 941, 156},
    { 0, 0x67, 0, 151},
    // 60: Local time: 09:01:00 PM
    { 0, 0x75, 2439, 155},
    { 0, 0x51, 19, 155},
    { 10, 0x60, 711, 156},
    { 0, 0x6f, 13, 155},
    { 0, 0x6f, 1789, 151},
    { 36, 0x53, 4632, 145},
    { 28, 0x32, 4025, 143},
    { 0, 0x22, 2931, 140},
    { 0, 0x19, 719, 142},
    { 0, 0x1a, 0, 141},
    { 0, 0x1a, 0, 141},
    { 0, 0x1a, 0, 141},
    { 0, 0x1a, 0, 142},
    { 0, 0x1a, 230, 147},
    { 0, 0x19, 112, 142},
    // 75: Local time: 09:16:00 PM
    { 0, 0x19, 0, 142},
    { 0, 0x19, 0, 142},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 142},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 142},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 142},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 141},
    { 0, 0x19, 0, 143},
    // 90: Local time: 09:31:00 PM
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 143},
    { 0, 0x19, 0, 148},
    { 0, 0x19, 0, 144},
    // 105: Local time: 09:46:00 PM
    { 0, 0x19, 0, 149},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 119},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 113},
    { 0, 0x19, 0, 144},
    // 120: Local time: 10:01:00 PM
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 316, 144},
    { 0, 0x1a, 0, 144},
    { 0, 0x1a, 0, 144},
    { 0, 0x1a, 0, 132},
    { 0, 0x1a, 0, 144},
    { 0, 0x1a, 0, 144},
    { 0, 0x1a, 0, 149},
    { 0, 0x1a, 0, 144},
    // 135: Local time: 10:16:01 PM
    { 0, 0x1a, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x19, 0, 144},
    { 0, 0x18, 26, 144},
    { 0, 0x18, 14, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 149},
    { 0, 0x17, 0, 144},
    // 150: Local time: 10:31:00 PM
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 143},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 125},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 149},
    { 0, 0x18, 0, 144},
    // 165: Local time: 10:46:00 PM
    { 0, 0x18, 0, 140},
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 143},
    { 0, 0x18, 0, 143},
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 107},
    { 0, 0x18, 0, 144},
    // 180: Local time: 11:01:00 PM
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 144},
    { 0, 0x18, 0, 121},
    { 0, 0x16, 864, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 2046, 149},
    { 0, 0x22, 2982, 163},
    { 0, 0x53, 5285, 143},
    { 0, 0x64, 0, 143},
    { 0, 0x64, 0, 143},
    { 0, 0x34, 276, 143},
    { 0, 0x24, 0, 148},
    { 0, 0x24, 0, 143},
    // 195: Local time: 11:16:00 PM
    { 0, 0x24, 0, 143},
    { 0, 0x24, 0, 143},
    { 0, 0x34, 179, 143},
    { 0, 0x64, 204, 143},
    { 0, 0x64, 0, 143},
    { 0, 0x64, 0, 142},
    { 0, 0x64, 0, 143},
    { 0, 0x64, 325, 142},
    { 0, 0x63, 0, 142},
    { 0, 0x63, 0, 143},
    { 0, 0x41, 708, 142},
    { 0, 0x31, 0, 142},
    { 0, 0x31, 0, 142},
    { 0, 0x52, 362, 145},
    { 0, 0x53, 0, 142},
    // 210: Local time: 11:31:00 PM
    { 0, 0x53, 0, 142},
    { 0, 0x53, 0, 142},
    { 0, 0x63, 115, 142},
    { 0, 0x63, 0, 142},
    { 0, 0x63, 0, 142},
    { 0, 0x63, 0, 142},
    { 0, 0x63, 0, 142},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 121},
    { 0, 0x63, 0, 142},
    { 0, 0x52, 892, 142},
    { 0, 0x3d, 0, 142},
    { 0, 0x3d, 0, 143},
    { 0, 0x3d, 0, 148},
    { 0, 0x3d, 0, 142},
    // 225: Local time: 11:46:00 PM
    { 0, 0x3d, 0, 143},
    { 0, 0x3d, 0, 143},
    { 0, 0x3d, 0, 123},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 149},
    { 0, 0x3d, 0, 144},
    // 240: Local time: 12:01:00 AM
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 138},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    // 255: Local time: 12:16:00 AM
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    // 270: Local time: 12:31:00 AM
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 144},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    // 285: Local time: 12:46:00 AM
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    // 300: Local time: 01:01:00 AM
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x3d, 0, 145},
    { 0, 0x5e, 1453, 144},
    { 0, 0x71, 0, 144},
    { 0, 0x72, 0, 144},
    { 0, 0x72, 152, 144},
    { 0, 0x72, 0, 143},
    { 0, 0x75, 241, 143},
    { 0, 0x75, 0, 143},
    { 0, 0x75, 26, 143},
    { 0, 0x75, 0, 147},
    { 0, 0x75, 0, 142},
    // 315: Local time: 01:16:00 AM
    { 0, 0x75, 0, 142},
    { 0, 0x75, 0, 142},
    { 0, 0x75, 0, 142},
    { 0, 0x76, 20, 142},
    { 0, 0x76, 0, 141},
    { 0, 0x76, 0, 141},
    { 0, 0x76, 42, 141},
    { 0, 0x76, 0, 135},
    { 0, 0x76, 0, 142},
    { 0, 0x75, 528, 142},
    { 0, 0x68, 794, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 142},
    { 0, 0x68, 0, 142},
    { 0, 0x68, 0, 141},
    // 330: Local time: 01:31:00 AM
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 142},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 145},
    { 0, 0x68, 0, 140},
    // 345: Local time: 01:46:00 AM
    { 0, 0x68, 17, 140},
    { 0, 0x68, 53, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 135},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    // 360: Local time: 02:01:00 AM
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    // 375: Local time: 02:16:00 AM
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    // 390: Local time: 02:31:00 AM
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    // 405: Local time: 02:46:00 AM
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 141},
    { 0, 0x68, 0, 140},
    { 0, 0x68, 85, 139},
    { 0, 0x79, 970, 141},
    { 0, 0x2a, 572, 140},
    { 0, 0x2a, 0, 140},
    { 0, 0x2a, 0, 140},
    { 0, 0x2a, 0, 140},
    { 0, 0x2a, 0, 140},
    { 0, 0x2a, 0, 145},
    { 0, 0x2a, 0, 140},
    // 420: Local time: 03:01:00 AM
    { 0, 0x2a, 0, 140},
    { 0, 0x2a, 0, 140},
    { 0, 0x4b, 852, 141},
    { 0, 0x7e, 0, 141},
    { 0, 0x7e, 0, 141},
    { 0, 0x7e, 0, 142},
    { 0, 0x7e, 20, 143},
    { 0, 0x79, 2106, 142},
    { 0, 0x21, 3122, 151},
    { 0, 0x32, 10232, 143},
    { 0, 0x64, 0, 141},
    { 0, 0x64, 0, 131},
    { 0, 0x64, 0, 141},
    { 0, 0x64, 0, 142},
    { 0, 0x64, 0, 141},
    // 435: Local time: 03:16:00 AM
    { 0, 0x64, 0, 142},
    { 0, 0x64, 0, 141},
    { 0, 0x65, 3321, 141},
    { 0, 0x67, 766, 141},
    { 0, 0x66, 1022, 142},
    { 0, 0x65, 1287, 142},
    { 0, 0x65, 692, 142},
    { 0, 0x68, 6068, 142},
    { 0, 0x58, 661, 142},
    { 0, 0x65, 3911, 201},
    { 0, 0x65, 1568, 153},
    { 0, 0x41, 5277, 152},
    { 0, 0x52, 10521, 141},
    { 0, 0x52, 0, 141},
    { 0, 0x52, 0, 141},
    // 450: Local time: 03:31:00 AM
    { 0, 0x52, 0, 141},
    { 0, 0x52, 1158, 196},
    { 0, 0x4d, 2005, 142},
    { 0, 0x6f, 0, 141},
    { 0, 0x6f, 0, 142},
    { 0, 0x6f, 0, 142},
    { 0, 0x6f, 0, 130},
    { 0, 0x6f, 0, 143},
    { 0, 0x6f, 0, 143},
    { 0, 0x6f, 0, 142},
    { 0, 0x6f, 0, 142},
    { 0, 0x6f, 0, 143},
    { 0, 0x6f, 0, 143},
    { 0, 0x6f, 0, 148},
    { 0, 0x6f, 0, 143},
    // 465: Local time: 03:46:00 AM
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 0, 143},
    { 0, 0x62, 5292, 123},
    { 0, 0x62, 3460, 148},
    { 0, 0x1c, 0, 143},
    { 0, 0x1c, 0, 143},
    { 0, 0x1c, 0, 142},
    { 0, 0x1c, 0, 142},
    { 0, 0x1c, 0, 143},
    { 0, 0x1c, 0, 143},
    { 0, 0x1c, 0, 143},
    { 0, 0x1c, 0, 143},
    { 0, 0x1c, 0, 143},
    { 0, 0x1c, 0, 148},
    { 0, 0xc, 105, 242},
    // 480: Local time: 04:01:00 AM
    { 0, 0x2, 0, 199},
    { 0, 0x2, 0, 243},
    { 0, 0x2, 0, 200},
    { 0, 0x2, 0, 242},
    { 0, 0x2, 0, 240},
    { 0, 0x2, 0, 227},
    { 0, 0x2, 0, 241},
    { 0, 0x2, 0, 188},
    { 0, 0x2, 0, 242},
    { 0, 0x2, 17, 143},
    { 0, 0x2, 0, 143},
    { 0, 0x1, 0, 142},
    { 0, 0x1, 0, 143},
    { 0, 0xb, 584, 142},
    { 0, 0x1b, 0, 143},
    // 495: Local time: 04:16:00 AM
    { 0, 0x1b, 0, 144},
    { 0, 0x1b, 0, 144},
    { 0, 0x19, 1999, 143},
    { 0, 0x46, 1400, 143},
    { 0, 0x55, 0, 143},
    { 0, 0x55, 0, 143},
    { 0, 0x55, 0, 143},
    { 0, 0x55, 10, 143},
    { 0, 0x55, 0, 143},
    { 0, 0x55, 0, 143},
    { 0, 0x55, 0, 143},
    { 0, 0x55, 0, 143},
    { 0, 0x55, 0, 143},
    { 0, 0x55, 0, 143},
    { 0, 0x55, 0, 143},
    // 510: Local time: 04:31:00 AM
    { 0, 0x55, 0, 143},
    { 0, 0x55, 0, 143},
    { 0, 0x55, 0, 143},
    { 0, 0x55, 0, 64},
    { 0, 0x55, 0, 122},
    { 0, 0x46, 1354, 143},
    { 0, 0x2c, 0, 143},
    { 0, 0x2c, 0, 143},
    { 0, 0x2c, 0, 143},
    { 0, 0x2c, 0, 143},
    { 0, 0x2c, 0, 143},
    { 0, 0x2c, 0, 143},
    { 0, 0x2c, 115, 143},
    { 0, 0x1c, 0, 147},
    { 0, 0x1c, 0, 143},
    // 525: Local time: 04:46:00 AM
    { 0, 0x1b, 245, 143},
    { 0, 0x1b, 0, 142},
    { 0, 0x1b, 0, 143},
    { 0, 0x1b, 0, 142},
    { 16, 0x38, 2342, 142},
    { 0, 0x69, 988, 143},
    { 0, 0x66, 165, 142},
    { 0, 0x63, 5473, 143},
    { 0, 0x44, 25, 143},
    { 0, 0x54, 565, 143},
    { 0, 0x24, 196, 143},
    { 0, 0x44, 1046, 143},
    { 0, 0x44, 0, 143},
    { 0, 0x44, 0, 148},
    { 0, 0x44, 0, 144},
    // 540: Local time: 05:01:00 AM
    { 0, 0x44, 0, 144},
    { 0, 0x44, 11, 144},
    { 0, 0x54, 214, 144},
    { 0, 0x44, 0, 144},
    { 0, 0x44, 26, 106},
    { 0, 0x63, 1118, 125},
    { 0, 0x71, 0, 144},
    { 0, 0x61, 673, 145},
    { 0, 0x61, 0, 144},
    { 0, 0x61, 0, 144},
    { 0, 0x61, 0, 145},
    { 0, 0x61, 0, 144},
    { 0, 0x61, 11, 145},
    { 0, 0x61, 0, 145},
    { 0, 0x61, 0, 144},
    // 555: Local time: 05:16:00 AM
    { 0, 0x61, 0, 144},
    { 0, 0x61, 0, 144},
    { 0, 0x61, 0, 144},
    { 0, 0x61, 0, 144},
    { 0, 0x62, 1240, 145},
    { 0, 0x64, 4944, 143},
    { 0, 0x54, 0, 143},
    { 0, 0x54, 0, 144},
    { 0, 0x54, 0, 143},
    { 0, 0x54, 0, 143},
    { 0, 0x54, 0, 143},
    { 0, 0x54, 0, 143},
    { 0, 0x34, 259, 142},
    { 0, 0x14, 0, 144},
    { 0, 0x15, 0, 143},
    // 570: Local time: 05:31:00 AM
    { 0, 0x15, 0, 143},
    { 0, 0x44, 238, 143},
    { 0, 0x54, 0, 143},
    { 0, 0x54, 0, 143},
    { 0, 0x54, 17, 143},
    { 0, 0x54, 0, 94},
    { 0, 0x54, 0, 142},
    { 0, 0x54, 0, 144},
    { 0, 0x54, 0, 143},
    { 0, 0x54, 26, 143},
    { 0, 0x54, 0, 143},
    { 0, 0x54, 288, 143},
    { 0, 0x32, 4909, 198},
    { 0, 0x71, 5548, 147},
    { 0, 0x6f, 238, 147},
    // 585: Local time: 05:46:00 AM
    { 0, 0x6f, 0, 147},
    { 0, 0x6f, 0, 147},
    { 0, 0x6e, 589, 147},
    { 0, 0x5e, 0, 147},
    { 0, 0x5e, 0, 148},
    { 0, 0x5e, 23, 148},
    { 0, 0x6e, 28, 148},
    { 0, 0x6e, 0, 148},
    { 0, 0x6e, 51, 148},
    { 0, 0x7c, 1219, 148},
    { 0, 0x69, 0, 148},
    { 0, 0x69, 0, 148},
    { 0, 0x69, 0, 148},
    { 0, 0x69, 11, 148},
    { 0, 0x69, 57, 148},
    // 600: Local time: 06:01:00 AM
    { 0, 0x69, 0, 148},
    { 0, 0x68, 556, 148},
    { 0, 0x67, 97, 143},
    { 0, 0x67, 210, 143},
    { 0, 0x5a, 1423, 151},
    { 0, 0x3b, 2416, 148},
    { 0, 0x6e, 4694, 178},
    { 13, 0x41, 4265, 194},
    { 25, 0x53, 5634, 174},
    { 0, 0x8e, 0, 142},
    { 0, 0x8e, 0, 140},
    { 0, 0x8e, 0, 139},
    { 0, 0x8e, 0, 138},
    { 0, 0x8e, 0, 143},
    { 0, 0x8e, 0, 137},
    // 615: Local time: 06:16:00 AM
    { 0, 0x8e, 0, 137},
    { 0, 0x8e, 0, 137},
    { 0, 0x8e, 0, 137},
    { 0, 0x8e, 0, 137},
    { 0, 0x8f, 741, 156},
    { 0, 0x74, 9269, 159},
    { 16, 0x53, 3356, 159},
    { 0, 0x52, 963, 175},
    { 20, 0x51, 7738, 168},
    { 104, 0x40, 9807, 168},
    { 31, 0x41, 7210, 169},
    { 0, 0x52, 9334, 162},
    { 0, 0x51, 4738, 168},
    { 0, 0x73, 726, 177},
    { 0, 0x86, 263, 167},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



// ----------------------------------------------------------------
// Sample captured at: 2015-09-19 10:30:00 local, 2015-09-19 17:30:00 GMT
// According to Fitbit:
//  Sleep enter 8:04pm (offset 66)
//  Sleep exit: 5:38am (offset 630)
//  Total sleep: 480 minutes
AlgDlsMinuteData *activity_sample_sleep_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_9
  //> TEST_VERSION 2
  //> TEST_TOTAL 480
  //> TEST_TOTAL_MIN 460
  //> TEST_TOTAL_MAX 500
  //> TEST_DEEP -1
  //> TEST_DEEP_MIN -1
  //> TEST_DEEP_MAX -1
  //> TEST_START_AT 117
  //> TEST_START_AT_MIN 100
  //> TEST_START_AT_MAX 130
  //> TEST_END_AT 615
  //> TEST_END_AT_MIN 600
  //> TEST_END_AT_MAX 630
  //> TEST_CUR_STATE_ELAPSED -1
  //> TEST_CUR_STATE_ELAPSED_MIN -1
  //> TEST_CUR_STATE_ELAPSED_MAX -1
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc, light}
  static AlgDlsMinuteData samples[] = { 
    // 0: Local time: 06:58:00 PM
    { 15, 0x42, 5222, 198},
    { 33, 0x42, 4035, 191},
    { 6, 0x42, 1093, 197},
    { 0, 0x43, 501, 199},
    { 0, 0x52, 1370, 187},
    { 0, 0x41, 2274, 192},
    { 0, 0x41, 1656, 193},
    { 0, 0x52, 1144, 193},
    { 20, 0x62, 5388, 186},
    { 0, 0x41, 6130, 185},
    { 0, 0x41, 3738, 160},
    { 41, 0x41, 5069, 170},
    { 9, 0x51, 6004, 202},
    { 0, 0x8a, 4824, 205},
    { 0, 0x78, 4179, 187},
    // 15: Local time: 07:13:00 PM
    { 12, 0x77, 3775, 186},
    { 14, 0x75, 4059, 185},
    { 24, 0x74, 2514, 184},
    { 9, 0x74, 2897, 183},
    { 0, 0x79, 1887, 178},
    { 0, 0x79, 1820, 183},
    { 6, 0x78, 2265, 175},
    { 0, 0x77, 1934, 173},
    { 6, 0x53, 1078, 177},
    { 0, 0x86, 3008, 177},
    { 12, 0x75, 3796, 176},
    { 10, 0x85, 4842, 173},
    { 12, 0x88, 3356, 177},
    { 7, 0x85, 3047, 172},
    { 13, 0x85, 2819, 178},
    // 30: Local time: 07:28:00 PM
    { 0, 0x78, 936, 173},
    { 16, 0x68, 2629, 169},
    { 17, 0x68, 1968, 173},
    { 6, 0x78, 3744, 163},
    { 8, 0x78, 2061, 164},
    { 0, 0x78, 3590, 160},
    { 0, 0x75, 2757, 165},
    { 9, 0x54, 1953, 164},
    { 19, 0x64, 3938, 160},
    { 0, 0x65, 3624, 154},
    { 0, 0x78, 3549, 153},
    { 14, 0x75, 1904, 156},
    { 8, 0x77, 3057, 150},
    { 0, 0x76, 4379, 159},
    { 0, 0x53, 4437, 164},
    // 45: Local time: 07:43:00 PM
    { 11, 0x41, 4494, 184},
    { 0, 0x20, 1858, 178},
    { 19, 0x32, 5600, 167},
    { 0, 0x42, 5598, 196},
    { 6, 0x55, 6380, 166},
    { 0, 0x54, 10053, 163},
    { 0, 0x64, 6520, 160},
    { 31, 0x41, 4814, 149},
    { 6, 0x62, 1151, 174},
    { 0, 0x62, 1480, 166},
    { 0, 0x55, 4352, 176},
    { 0, 0x64, 5145, 167},
    { 0, 0x54, 2246, 174},
    { 0, 0x53, 6082, 174},
    { 15, 0x41, 5409, 174},
    // 60: Local time: 07:58:00 PM
    { 0, 0x52, 8434, 179},
    { 0, 0x42, 7966, 174},
    { 14, 0x41, 4292, 160},
    { 49, 0x41, 5493, 174},
    { 0, 0x78, 0, 172},
    { 0, 0x79, 1197, 171},
    { 0, 0x7b, 3482, 173},
    { 0, 0x5b, 3591, 164},
    { 0, 0x4b, 679, 164},
    { 0, 0x4a, 201, 157},
    { 0, 0x3b, 0, 157},
    { 0, 0x3b, 0, 157},
    { 0, 0x3b, 0, 156},
    { 0, 0x3b, 0, 157},
    { 0, 0x4a, 380, 159},
    // 75: Local time: 08:13:00 PM
    { 0, 0x5a, 668, 168},
    { 0, 0x5a, 0, 167},
    { 0, 0x5a, 0, 167},
    { 0, 0x5a, 0, 166},
    { 0, 0x62, 4937, 151},
    { 0, 0x54, 0, 149},
    { 0, 0x54, 22, 148},
    { 0, 0x54, 0, 147},
    { 0, 0x54, 1281, 134},
    { 0, 0x54, 0, 146},
    { 0, 0x44, 199, 143},
    { 0, 0x45, 222, 145},
    { 0, 0x46, 383, 150},
    { 0, 0x5a, 1067, 150},
    { 0, 0x5a, 793, 147},
    // 90: Local time: 08:28:00 PM
    { 0, 0x64, 5749, 162},
    { 0, 0x69, 11, 161},
    { 0, 0x6a, 423, 159},
    { 0, 0x6a, 0, 159},
    { 0, 0x6a, 0, 160},
    { 0, 0x59, 855, 162},
    { 0, 0x4a, 219, 156},
    { 0, 0x4a, 0, 156},
    { 0, 0x59, 333, 157},
    { 0, 0x4a, 429, 156},
    { 0, 0x4a, 156, 158},
    { 0, 0x59, 836, 160},
    { 0, 0x69, 0, 159},
    { 0, 0x69, 0, 158},
    { 0, 0x69, 0, 159},
    // 105: Local time: 08:43:00 PM
    { 0, 0x69, 0, 160},
    { 0, 0x69, 0, 159},
    { 0, 0x69, 1237, 159},
    { 0, 0x54, 6214, 154},
    { 0, 0x68, 1178, 157},
    { 19, 0x63, 4065, 142},
    { 29, 0x51, 5949, 196},
    { 0, 0x6d, 4428, 147},
    { 0, 0x75, 1796, 147},
    { 0, 0x55, 0, 147},
    { 0, 0x56, 330, 147},
    { 0, 0x56, 409, 147},
    { 0, 0x56, 0, 147},
    { 0, 0x56, 0, 147},
    { 0, 0x56, 0, 147},
    // 120: Local time: 08:58:00 PM
    { 0, 0x56, 0, 147},
    { 0, 0x56, 0, 147},
    { 0, 0x56, 0, 147},
    { 0, 0x56, 0, 147},
    { 0, 0x56, 0, 147},
    { 0, 0x46, 0, 147},
    { 0, 0x56, 71, 147},
    { 0, 0x57, 189, 147},
    { 0, 0x57, 1577, 142},
    { 0, 0x57, 0, 142},
    { 0, 0x5a, 312, 142},
    { 0, 0x5a, 0, 141},
    { 0, 0x33, 3498, 145},
    { 0, 0x41, 5366, 141},
    { 0, 0x6f, 94, 142},
    // 135: Local time: 09:13:00 PM
    { 0, 0x60, 0, 143},
    { 0, 0x6f, 0, 142},
    { 0, 0x6f, 0, 143},
    { 0, 0x6f, 0, 143},
    { 0, 0x6f, 0, 143},
    { 0, 0x60, 0, 148},
    { 0, 0x60, 0, 142},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 137},
    { 0, 0x60, 0, 144},
    // 150: Local time: 09:28:00 PM
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 149},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 145},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 144},
    // 165: Local time: 09:43:00 PM
    { 0, 0x60, 0, 149},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 143},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 145},
    { 0, 0x60, 0, 144},
    { 0, 0x60, 0, 144},
    // 180: Local time: 09:58:00 PM
    { 0, 0x6f, 44, 144},
    { 0, 0x6f, 0, 149},
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 0, 145},
    { 0, 0x6f, 0, 145},
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 0, 145},
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 0, 145},
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 14, 144},
    { 0, 0x6f, 0, 145},
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 39, 145},
    { 0, 0x6f, 162, 144},
    // 195: Local time: 10:13:00 PM
    { 0, 0x6f, 34, 145},
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 17, 144},
    { 0, 0x6f, 0, 149},
    { 0, 0x6f, 17, 144},
    { 0, 0x6f, 11, 144},
    { 0, 0x6f, 0, 143},
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 0, 145},
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 0, 144},
    { 0, 0x6f, 0, 136},
    { 0, 0x6f, 14, 146},
    // 210: Local time: 10:28:00 PM
    { 0, 0x6f, 0, 144},
    { 0, 0x64, 6241, 144},
    { 0, 0x57, 676, 143},
    { 0, 0x57, 0, 143},
    { 0, 0x57, 0, 143},
    { 0, 0x57, 0, 148},
    { 0, 0x57, 0, 142},
    { 0, 0x57, 0, 143},
    { 0, 0x57, 0, 142},
    { 0, 0x57, 0, 143},
    { 0, 0x57, 0, 143},
    { 0, 0x57, 0, 141},
    { 0, 0x57, 0, 143},
    { 0, 0x57, 0, 143},
    { 0, 0x57, 0, 148},
    // 225: Local time: 10:43:00 PM
    { 0, 0x57, 0, 143},
    { 0, 0x57, 0, 143},
    { 0, 0x47, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 148},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 142},
    { 0, 0x46, 0, 142},
    { 0, 0x46, 0, 142},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 144},
    // 240: Local time: 10:58:00 PM
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 135},
    { 0, 0x46, 37, 148},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 142},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 142},
    { 0, 0x46, 0, 143},
    // 255: Local time: 11:14:00 PM
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 59, 148},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 145},
    // 270: Local time: 11:29:00 PM
    { 0, 0x46, 0, 149},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 149},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 145},
    // 285: Local time: 11:44:00 PM
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 143},
    { 0, 0x56, 91, 143},
    { 0, 0x56, 0, 143},
    { 0, 0x56, 0, 143},
    { 0, 0x56, 0, 148},
    { 0, 0x56, 0, 142},
    { 0, 0x56, 0, 142},
    { 0, 0x56, 0, 142},
    { 0, 0x56, 0, 143},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 142},
    { 0, 0x56, 0, 143},
    { 0, 0x56, 0, 142},
    { 0, 0x56, 0, 148},
    // 300: Local time: 11:59:00 PM
    { 0, 0x56, 0, 148},
    { 0, 0x56, 0, 143},
    { 0, 0x56, 0, 142},
    { 0, 0x56, 0, 142},
    { 0, 0x57, 535, 143},
    { 0, 0x3b, 0, 148},
    { 0, 0x3b, 26, 143},
    { 0, 0x3b, 0, 143},
    { 0, 0x3b, 0, 143},
    { 0, 0x3b, 0, 141},
    { 0, 0x3b, 0, 143},
    { 0, 0x3b, 0, 143},
    { 0, 0x3b, 0, 142},
    { 0, 0x3b, 0, 142},
    { 0, 0x3b, 0, 143},
    // 315: Local time: 12:14:00 AM
    { 0, 0x3b, 0, 144},
    { 0, 0x3b, 325, 143},
    { 0, 0x3b, 0, 143},
    { 0, 0x3b, 0, 143},
    { 0, 0x3b, 0, 142},
    { 0, 0x3b, 0, 148},
    { 0, 0x3b, 0, 142},
    { 0, 0x3b, 0, 142},
    { 0, 0x2b, 11, 142},
    { 0, 0x2b, 0, 143},
    { 0, 0x2b, 0, 143},
    { 0, 0x2b, 0, 142},
    { 0, 0x2b, 13, 143},
    { 0, 0x2b, 0, 142},
    { 0, 0x2b, 0, 144},
    // 330: Local time: 12:29:00 AM
    { 0, 0x2b, 0, 148},
    { 0, 0x2b, 16, 142},
    { 0, 0x2b, 0, 143},
    { 0, 0x2b, 0, 143},
    { 0, 0x2b, 0, 143},
    { 0, 0x2b, 0, 149},
    { 0, 0x2b, 0, 143},
    { 0, 0x2b, 0, 143},
    { 0, 0x2b, 0, 142},
    { 0, 0x3b, 626, 143},
    { 0, 0x2b, 0, 143},
    { 0, 0x2b, 0, 142},
    { 0, 0x2b, 0, 142},
    { 0, 0x2b, 0, 141},
    { 0, 0x2b, 0, 142},
    // 345: Local time: 12:44:00 AM
    { 0, 0x2b, 0, 142},
    { 0, 0x2b, 1894, 142},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 142},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 148},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 145},
    // 360: Local time: 12:59:00 AM
    { 0, 0x16, 0, 148},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 148},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 149},
    // 375: Local time: 01:14:00 AM
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 11, 143},
    { 0, 0x16, 0, 144},
    // 390: Local time: 01:29:00 AM
    { 0, 0x16, 0, 149},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    // 405: Local time: 01:44:00 AM
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 145},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 132},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 145},
    { 0, 0x16, 0, 145},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 145},
    // 420: Local time: 01:59:00 AM
    { 0, 0x16, 0, 149},
    { 0, 0x16, 0, 144},
    { 0, 0x17, 519, 150},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 50, 144},
    { 0, 0x17, 0, 149},
    { 0, 0x17, 0, 143},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 139},
    { 0, 0x17, 11, 144},
    { 0, 0x17, 85, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    // 435: Local time: 02:14:00 AM
    { 0, 0x17, 0, 144},
    { 0, 0x17, 0, 144},
    { 0, 0x35, 159, 143},
    { 0, 0x35, 0, 144},
    { 0, 0x35, 0, 143},
    { 0, 0x35, 0, 149},
    { 12, 0x23, 3568, 154},
    { 0, 0x42, 3998, 144},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 142},
    { 0, 0x63, 0, 142},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    // 450: Local time: 02:29:00 AM
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 148},
    { 0, 0x63, 0, 142},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 144},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    // 465: Local time: 02:44:00 AM
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 143},
    { 0, 0x63, 0, 132},
    { 0, 0x63, 0, 148},
    { 0, 0x5e, 936, 142},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 142},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 142},
    // 480: Local time: 02:59:00 AM
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 144},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 149},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 143},
    { 0, 0x5e, 0, 144},
    { 0, 0x7f, 836, 143},
    { 0, 0x84, 0, 143},
    { 0, 0x84, 0, 142},
    { 0, 0x84, 0, 142},
    // 495: Local time: 03:14:00 AM
    { 0, 0x84, 0, 133},
    { 0, 0x84, 0, 142},
    { 0, 0x84, 0, 142},
    { 0, 0x84, 37, 142},
    { 0, 0x84, 14, 142},
    { 0, 0x84, 0, 147},
    { 0, 0x84, 0, 137},
    { 0, 0x84, 0, 142},
    { 0, 0x84, 0, 142},
    { 0, 0x84, 0, 141},
    { 0, 0x84, 0, 142},
    { 0, 0x84, 72, 142},
    { 0, 0x84, 0, 141},
    { 0, 0x84, 0, 141},
    { 0, 0x84, 1616, 141},
    // 510: Local time: 03:29:00 AM
    { 0, 0x77, 2259, 142},
    { 0, 0x66, 0, 142},
    { 0, 0x66, 0, 142},
    { 0, 0x66, 0, 141},
    { 0, 0x66, 0, 141},
    { 0, 0x66, 0, 146},
    { 0, 0x66, 0, 141},
    { 0, 0x66, 0, 141},
    { 0, 0x66, 0, 141},
    { 0, 0x66, 0, 141},
    { 0, 0x66, 0, 141},
    { 0, 0x66, 226, 141},
    { 0, 0x66, 0, 140},
    { 0, 0x66, 0, 141},
    { 0, 0x66, 0, 140},
    // 525: Local time: 03:44:00 AM
    { 0, 0x66, 11, 141},
    { 0, 0x66, 0, 140},
    { 0, 0x66, 0, 140},
    { 0, 0x79, 1542, 141},
    { 0, 0x89, 179, 141},
    { 0, 0x88, 0, 143},
    { 0, 0x88, 109, 142},
    { 0, 0x87, 0, 142},
    { 0, 0x87, 0, 142},
    { 0, 0x87, 0, 142},
    { 0, 0x76, 196, 142},
    { 0, 0x76, 94, 143},
    { 0, 0x76, 0, 142},
    { 0, 0x76, 11, 143},
    { 0, 0x76, 0, 143},
    // 540: Local time: 03:59:01 AM
    { 0, 0x76, 0, 124},
    { 0, 0x76, 307, 143},
    { 0, 0x69, 1958, 143},
    { 0, 0x6a, 0, 143},
    { 0, 0x6a, 0, 143},
    { 0, 0x6a, 0, 148},
    { 0, 0x7a, 3427, 149},
    { 0, 0x72, 174, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x73, 45, 148},
    { 0, 0x73, 0, 148},
    // 555: Local time: 04:14:00 AM
    { 0, 0x73, 0, 148},
    { 0, 0x73, 0, 148},
    { 0, 0x73, 0, 148},
    { 0, 0x73, 266, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 147},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    // 570: Local time: 04:29:00 AM
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x72, 0, 148},
    { 0, 0x7f, 996, 148},
    { 0, 0x7e, 0, 148},
    // 585: Local time: 04:44:00 AM
    { 0, 0x7e, 0, 148},
    { 0, 0x7e, 0, 147},
    { 0, 0x7e, 0, 147},
    { 0, 0x7e, 663, 147},
    { 0, 0x6d, 0, 147},
    { 0, 0x6d, 0, 147},
    { 0, 0x6d, 0, 147},
    { 0, 0x6d, 0, 147},
    { 0, 0x6d, 0, 147},
    { 0, 0x6d, 0, 147},
    { 0, 0x7e, 754, 147},
    { 0, 0x7f, 0, 147},
    { 0, 0x7f, 0, 148},
    { 0, 0x7f, 0, 147},
    { 0, 0x7f, 14, 147},
    // 600: Local time: 04:59:00 AM
    { 0, 0x7f, 0, 147},
    { 0, 0x7f, 11, 147},
    { 0, 0x7f, 11, 147},
    { 0, 0x7e, 116, 147},
    { 0, 0x7e, 0, 147},
    { 0, 0x7e, 0, 147},
    { 0, 0x7e, 531, 147},
    { 0, 0x6e, 0, 148},
    { 0, 0x6e, 16, 148},
    { 0, 0x6e, 0, 148},
    { 0, 0x6e, 0, 148},
    { 0, 0x6e, 0, 148},
    { 0, 0x6e, 0, 148},
    { 0, 0x6e, 698, 148},
    { 7, 0x63, 745, 143},
    // 615: Local time: 05:14:00 AM
    { 0, 0x63, 0, 143},
    { 0, 0x61, 6473, 235},
    { 7, 0x5f, 1798, 148},
    { 0, 0x6f, 0, 148},
    { 0, 0x6f, 997, 142},
    { 0, 0x6f, 0, 147},
    { 0, 0x6f, 0, 143},
    { 0, 0x6f, 756, 142},
    { 0, 0x5d, 651, 195},
    { 0, 0x5e, 842, 148},
    { 0, 0x6f, 714, 148},
    { 0, 0x75, 1987, 148},
    { 0, 0x66, 165, 148},
    { 0, 0x65, 11, 148},
    { 0, 0x66, 0, 148},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured at: 2015-09-29 16:39:00 local, 2015-09-29 23:39:00 GMT
// Sleep enter: 12:17am (offset 459)
// Sleep exit: 4:50am (offset 730)
// Total sleep: 286 min (according to fitbit)
AlgDlsMinuteData *activity_sample_sleep_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_10
  //> TEST_VERSION 2
  //> TEST_TOTAL 286
  //> TEST_TOTAL_MIN 270
  //> TEST_TOTAL_MAX 300
  //> TEST_DEEP -1
  //> TEST_DEEP_MIN -1
  //> TEST_DEEP_MAX -1
  //> TEST_START_AT 459
  //> TEST_START_AT_MIN 450
  //> TEST_START_AT_MAX 470
  //> TEST_END_AT 730
  //> TEST_END_AT_MIN 720
  //> TEST_END_AT_MAX 740
  //> TEST_CUR_STATE_ELAPSED -1
  //> TEST_CUR_STATE_ELAPSED_MIN -1
  //> TEST_CUR_STATE_ELAPSED_MAX -1
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc, light}
  static AlgDlsMinuteData samples[] = { 
    { 30, 0x60, 2405, 243},
    { 119, 0x60, 8788, 237},
    { 120, 0x40, 8767, 242},
    { 49, 0x53, 5561, 237},
    { 12, 0x52, 3356, 241},
    { 3, 0x42, 1718, 238},
    { 13, 0x52, 2615, 239},
    { 0, 0x42, 1197, 238},
    { 26, 0x41, 4604, 240},
    { 13, 0x41, 1820, 234},
    { 12, 0x43, 2689, 202},
    { 12, 0x61, 1966, 197},
    { 0, 0x62, 1147, 195},
    { 6, 0x62, 3476, 195},
    { 0, 0x62, 4704, 199},
    // 15: Local time: 04:54:00 PM
    { 0, 0x62, 5317, 198},
    { 0, 0x62, 5222, 191},
    { 13, 0x72, 5510, 195},
    { 16, 0x63, 2137, 184},
    { 0, 0x44, 744, 194},
    { 0, 0x44, 559, 187},
    { 0, 0x43, 491, 174},
    { 0, 0x53, 2587, 205},
    { 0, 0x44, 3131, 201},
    { 15, 0x63, 4672, 206},
    { 12, 0x63, 3982, 208},
    { 0, 0x44, 3930, 188},
    { 0, 0x44, 2795, 188},
    { 0, 0x43, 2930, 189},
    { 0, 0x53, 2351, 214},
    // 30: Local time: 05:09:00 PM
    { 6, 0x63, 3510, 195},
    { 12, 0x63, 3054, 198},
    { 6, 0x6e, 3435, 196},
    { 0, 0x7d, 933, 193},
    { 47, 0x61, 3762, 213},
    { 109, 0x41, 10644, 226},
    { 100, 0x41, 7428, 235},
    { 71, 0x51, 8071, 232},
    { 93, 0x42, 7870, 241},
    { 59, 0x51, 3528, 235},
    { 89, 0x41, 5419, 235},
    { 21, 0x52, 3750, 193},
    { 0, 0x33, 236, 198},
    { 0, 0x34, 390, 198},
    { 0, 0x33, 421, 191},
    // 45: Local time: 05:24:00 PM
    { 38, 0x53, 2920, 198},
    { 6, 0x53, 1968, 212},
    { 0, 0x62, 1345, 214},
    { 0, 0x62, 355, 216},
    { 0, 0x62, 405, 215},
    { 0, 0x62, 569, 217},
    { 0, 0x72, 606, 224},
    { 8, 0x63, 1299, 189},
    { 71, 0x42, 9291, 241},
    { 72, 0x50, 6118, 236},
    { 108, 0x41, 7133, 235},
    { 94, 0x41, 6720, 237},
    { 26, 0x62, 8709, 228},
    { 7, 0x69, 3210, 227},
    { 6, 0x79, 1527, 232},
    // 60: Local time: 05:39:00 PM
    { 0, 0x79, 3734, 222},
    { 0, 0x78, 4746, 233},
    { 6, 0x7a, 4383, 171},
    { 0, 0x64, 2020, 226},
    { 67, 0x52, 8021, 202},
    { 14, 0x52, 10386, 174},
    { 12, 0x52, 7836, 169},
    { 10, 0x43, 5298, 185},
    { 31, 0x63, 6409, 195},
    { 10, 0x54, 6876, 196},
    { 36, 0x64, 6159, 201},
    { 9, 0x42, 5813, 185},
    { 18, 0x44, 7434, 178},
    { 11, 0x42, 5840, 185},
    { 25, 0x62, 8406, 187},
    // 75: Local time: 05:54:00 PM
    { 22, 0x63, 6859, 175},
    { 0, 0x53, 6597, 182},
    { 6, 0x55, 4847, 177},
    { 7, 0x54, 6911, 171},
    { 19, 0x54, 6368, 191},
    { 0, 0x64, 1915, 184},
    { 0, 0x64, 2424, 183},
    { 0, 0x74, 1638, 183},
    { 29, 0x74, 3174, 188},
    { 20, 0x73, 4937, 187},
    { 13, 0x65, 9044, 187},
    { 0, 0x64, 9158, 190},
    { 0, 0x44, 950, 181},
    { 33, 0x52, 3393, 172},
    { 44, 0x54, 4061, 171},
    // 90: Local time: 06:09:00 PM
    { 37, 0x41, 10018, 174},
    { 19, 0x52, 10102, 185},
    { 45, 0x51, 3667, 175},
    { 23, 0x61, 5853, 185},
    { 10, 0x74, 3745, 203},
    { 0, 0x55, 6768, 197},
    { 0, 0x64, 646, 156},
    { 15, 0x52, 5912, 195},
    { 15, 0x54, 6784, 165},
    { 19, 0x33, 7300, 150},
    { 90, 0x31, 7502, 150},
    { 64, 0x41, 7610, 178},
    { 64, 0x41, 8669, 184},
    { 81, 0x40, 5683, 176},
    { 38, 0x41, 7371, 157},
    // 105: Local time: 06:24:00 PM
    { 62, 0x41, 8623, 143},
    { 44, 0x51, 6839, 197},
    { 6, 0x7a, 4786, 191},
    { 0, 0x79, 4373, 194},
    { 0, 0x78, 2884, 205},
    { 8, 0x78, 3261, 194},
    { 17, 0x75, 6233, 200},
    { 26, 0x33, 2779, 179},
    { 32, 0x52, 6559, 192},
    { 0, 0x79, 5255, 191},
    { 10, 0x68, 2166, 201},
    { 0, 0x79, 2575, 204},
    { 22, 0x67, 6041, 186},
    { 22, 0x56, 4024, 190},
    { 75, 0x44, 5616, 207},
    // 120: Local time: 06:39:00 PM
    { 40, 0x43, 3763, 196},
    { 0, 0x51, 1342, 217},
    { 23, 0x42, 4876, 172},
    { 31, 0x52, 4812, 184},
    { 9, 0x62, 4166, 189},
    { 8, 0x73, 2769, 213},
    { 0, 0x73, 1931, 219},
    { 16, 0x73, 2450, 216},
    { 0, 0x73, 2298, 218},
    { 0, 0x73, 2086, 219},
    { 0, 0x84, 680, 216},
    { 25, 0x65, 4300, 197},
    { 8, 0x24, 2217, 182},
    { 0, 0x44, 1149, 209},
    { 0, 0x75, 1895, 202},
    // 135: Local time: 06:54:00 PM
    { 0, 0x75, 2257, 174},
    { 0, 0x35, 2884, 188},
    { 0, 0x55, 2462, 204},
    { 8, 0x75, 1922, 181},
    { 14, 0x74, 2763, 209},
    { 0, 0x75, 500, 192},
    { 0, 0x75, 737, 204},
    { 0, 0x76, 852, 205},
    { 0, 0x75, 867, 208},
    { 0, 0x64, 2995, 209},
    { 13, 0x54, 3848, 190},
    { 0, 0x62, 2359, 201},
    { 7, 0x43, 3146, 184},
    { 26, 0x63, 8227, 184},
    { 0, 0x6e, 63, 192},
    // 150: Local time: 07:09:00 PM
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 197},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 166},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 192},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    // 165: Local time: 07:24:00 PM
    { 0, 0x6e, 0, 187},
    { 0, 0x6e, 0, 185},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 197},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 192},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    // 180: Local time: 07:39:01 PM
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 192},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 192},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 192},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    // 195: Local time: 07:54:01 PM
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 192},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 189},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    // 210: Local time: 08:09:00 PM
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 167},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    // 225: Local time: 08:24:00 PM
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 167},
    { 0, 0x6e, 0, 190},
    { 0, 0x6e, 0, 191},
    { 0, 0x6e, 0, 191},
    { 10, 0x7e, 6075, 161},
    { 35, 0x62, 9892, 186},
    { 9, 0x51, 9458, 184},
    { 35, 0x53, 5856, 192},
    { 28, 0x53, 2499, 181},
    // 240: Local time: 08:39:00 PM
    { 48, 0x54, 2467, 150},
    { 82, 0x54, 4357, 153},
    { 9, 0x71, 6799, 148},
    { 0, 0x75, 2942, 147},
    { 0, 0x73, 933, 155},
    { 0, 0x75, 2965, 170},
    { 8, 0x67, 4895, 160},
    { 0, 0x69, 2184, 117},
    { 13, 0x68, 3432, 169},
    { 7, 0x75, 1915, 151},
    { 0, 0x79, 2665, 152},
    { 16, 0x68, 3677, 153},
    { 10, 0x54, 3781, 144},
    { 0, 0x44, 919, 144},
    { 0, 0x54, 1585, 152},
    // 255: Local time: 08:54:00 PM
    { 0, 0x65, 1278, 165},
    { 8, 0x65, 3014, 147},
    { 0, 0x44, 31, 146},
    { 0, 0x54, 180, 148},
    { 7, 0x55, 2060, 149},
    { 0, 0x45, 103, 143},
    { 0, 0x45, 0, 143},
    { 0, 0x55, 427, 153},
    { 0, 0x75, 639, 153},
    { 0, 0x55, 697, 144},
    { 0, 0x45, 0, 144},
    { 0, 0x66, 602, 155},
    { 7, 0x76, 1075, 152},
    { 56, 0x42, 7133, 173},
    { 77, 0x42, 7259, 153},
    // 270: Local time: 09:09:00 PM
    { 0, 0x31, 4305, 127},
    { 0, 0x42, 4070, 212},
    { 7, 0x43, 3541, 180},
    { 18, 0x42, 8486, 173},
    { 0, 0x6f, 4733, 165},
    { 0, 0x4f, 0, 158},
    { 0, 0x4f, 0, 158},
    { 0, 0x4f, 50, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 150},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 150},
    // 285: Local time: 09:24:00 PM
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 156},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 148},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 149},
    { 0, 0x3f, 0, 148},
    { 0, 0x3f, 0, 149},
    // 300: Local time: 09:39:01 PM
    { 0, 0x3f, 0, 147},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 152},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 144},
    // 315: Local time: 09:54:00 PM
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 145},
    // 330: Local time: 10:09:00 PM
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 145},
    { 0, 0x3f, 0, 144},
    { 0, 0x3f, 0, 138},
    { 0, 0x3f, 0, 138},
    { 0, 0x3f, 0, 138},
    { 0, 0x3f, 0, 137},
    { 0, 0x3f, 0, 137},
    { 0, 0x3f, 0, 137},
    { 0, 0x3f, 0, 137},
    { 0, 0x3f, 0, 138},
    // 345: Local time: 10:24:00 PM
    { 0, 0x3f, 0, 137},
    { 0, 0x3f, 0, 137},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 146},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 140},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 140},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 138},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 140},
    // 360: Local time: 10:39:00 PM
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 146},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 140},
    { 0, 0x3f, 0, 130},
    { 0, 0x3f, 0, 140},
    { 0, 0x3f, 0, 140},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    // 375: Local time: 10:54:00 PM
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 140},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 140},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    // 390: Local time: 11:09:00 PM
    { 0, 0x3f, 0, 140},
    { 0, 0x3f, 0, 140},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 138},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 138},
    { 0, 0x3f, 0, 139},
    // 405: Local time: 11:24:00 PM
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    // 420: Local time: 11:39:00 PM
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 138},
    { 0, 0x3f, 0, 135},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 138},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 139},
    { 0, 0x3f, 0, 138},
    { 0, 0x70, 5610, 170},
    { 6, 0x52, 10117, 167},
    { 28, 0x52, 4950, 202},
    // 435: Local time: 11:54:00 PM
    { 0, 0x42, 6982, 178},
    { 0, 0x40, 889, 169},
    { 0, 0x40, 886, 160},
    { 15, 0x51, 2576, 158},
    { 88, 0x40, 5342, 163},
    { 74, 0x40, 6162, 158},
    { 42, 0x67, 6005, 147},
    { 0, 0x68, 4342, 175},
    { 0, 0x77, 2437, 156},
    { 0, 0x68, 2251, 148},
    { 8, 0x68, 2868, 156},
    { 0, 0x69, 3509, 143},
    { 0, 0x76, 7564, 184},
    { 64, 0x51, 5504, 165},
    { 34, 0x43, 9522, 171},
    // 450: Local time: 12:09:00 AM
    { 0, 0x53, 9094, 184},
    { 9, 0x52, 7476, 203},
    { 0, 0x54, 7336, 193},
    { 30, 0x42, 9164, 43},
    { 0, 0x61, 4191, 146},
    { 7, 0x62, 1734, 141},
    { 0, 0x63, 6688, 140},
    { 0, 0x44, 1551, 140},
    { 0, 0x34, 0, 140},
    { 0, 0x34, 0, 142},
    { 0, 0x34, 0, 140},
    { 0, 0x34, 0, 141},
    { 0, 0x34, 0, 140},
    { 0, 0x34, 0, 140},
    { 0, 0x34, 0, 142},
    // 465: Local time: 12:24:00 AM
    { 0, 0x34, 0, 140},
    { 0, 0x34, 0, 141},
    { 0, 0x34, 0, 141},
    { 0, 0x34, 0, 141},
    { 0, 0x34, 0, 148},
    { 0, 0x34, 0, 141},
    { 0, 0x34, 0, 142},
    { 0, 0x34, 0, 141},
    { 0, 0x34, 0, 142},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 141},
    { 0, 0x34, 0, 141},
    { 0, 0x34, 0, 141},
    { 0, 0x34, 0, 141},
    { 0, 0x34, 0, 143},
    // 480: Local time: 12:39:00 AM
    { 0, 0x34, 0, 142},
    { 0, 0x34, 0, 132},
    { 0, 0x34, 0, 142},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 149},
    { 0, 0x34, 0, 142},
    { 0, 0x34, 0, 128},
    { 0, 0x34, 0, 142},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 142},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 142},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 143},
    // 495: Local time: 12:54:00 AM
    { 0, 0x34, 0, 131},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 81},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    // 510: Local time: 01:09:00 AM
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 143},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 145},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 145},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 136},
    { 0, 0x34, 0, 145},
    // 525: Local time: 01:25:00 AM
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 145},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 145},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    // 540: Local time: 01:40:00 AM
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 136},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 136},
    { 0, 0x34, 0, 145},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 145},
    { 0, 0x34, 0, 144},
    { 0, 0x34, 0, 144},
    { 0, 0x45, 1962, 144},
    { 0, 0x46, 0, 145},
    // 555: Local time: 01:55:00 AM
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 143},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 151},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 99, 144},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 145},
    { 0, 0x46, 0, 145},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 145},
    // 570: Local time: 02:10:00 AM
    { 0, 0x46, 0, 144},
    { 0, 0x46, 0, 145},
    { 0, 0x46, 0, 144},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 150},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 145},
    { 0, 0x56, 0, 145},
    { 0, 0x56, 0, 143},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 145},
    // 585: Local time: 02:25:00 AM
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 151},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 136},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 145},
    { 0, 0x56, 0, 144},
    { 0, 0x56, 0, 144},
    { 0, 0x37, 1281, 144},
    { 0, 0x2c, 0, 140},
    { 0, 0x2c, 0, 145},
    // 600: Local time: 02:40:00 AM
    { 0, 0x2c, 0, 144},
    { 0, 0x2c, 0, 144},
    { 0, 0x2c, 0, 144},
    { 0, 0x2c, 0, 145},
    { 0, 0x2c, 0, 151},
    { 0, 0x2c, 0, 144},
    { 0, 0x2c, 0, 144},
    { 0, 0x67, 1487, 144},
    { 0, 0x65, 0, 144},
    { 0, 0x65, 100, 144},
    { 0, 0x65, 0, 144},
    { 0, 0x65, 0, 144},
    { 0, 0x65, 0, 143},
    { 0, 0x65, 0, 144},
    { 0, 0x65, 0, 145},
    // 615: Local time: 02:55:00 AM
    { 0, 0x65, 0, 144},
    { 0, 0x67, 404, 144},
    { 0, 0x69, 0, 143},
    { 0, 0x69, 0, 144},
    { 0, 0x69, 0, 149},
    { 0, 0x69, 17, 145},
    { 0, 0x69, 0, 144},
    { 0, 0x69, 0, 144},
    { 0, 0x69, 0, 145},
    { 0, 0x69, 0, 145},
    { 0, 0x69, 0, 143},
    { 0, 0x69, 0, 144},
    { 0, 0x69, 586, 144},
    { 0, 0x69, 1127, 144},
    { 0, 0x68, 0, 146},
    // 630: Local time: 03:10:00 AM
    { 0, 0x69, 528, 144},
    { 0, 0x69, 0, 144},
    { 0, 0x69, 0, 144},
    { 0, 0x69, 0, 144},
    { 0, 0x69, 0, 150},
    { 0, 0x69, 0, 144},
    { 0, 0x69, 0, 144},
    { 0, 0x69, 0, 144},
    { 0, 0x26, 1231, 144},
    { 0, 0x16, 0, 145},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 145},
    // 645: Local time: 03:25:00 AM
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 151},
    { 0, 0x16, 0, 123},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 143},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 145},
    { 0, 0x16, 0, 145},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 145},
    // 660: Local time: 03:40:00 AM
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 145},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 146},
    { 0, 0x16, 0, 150},
    { 0, 0x16, 0, 145},
    { 0, 0x16, 0, 145},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 145},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 145},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 144},
    { 0, 0x16, 0, 145},
    { 0, 0x66, 592, 145},
    // 675: Local time: 03:55:00 AM
    { 0, 0x65, 0, 144},
    { 0, 0x65, 0, 144},
    { 0, 0x65, 0, 144},
    { 0, 0x65, 0, 144},
    { 0, 0x66, 16, 150},
    { 0, 0x78, 1756, 144},
    { 0, 0x6a, 0, 143},
    { 0, 0x6a, 0, 142},
    { 0, 0x6a, 264, 143},
    { 0, 0x6a, 0, 143},
    { 0, 0x6a, 0, 143},
    { 0, 0x6a, 0, 142},
    { 0, 0x6a, 883, 142},
    { 0, 0x4b, 0, 141},
    { 0, 0x4b, 0, 142},
    // 690: Local time: 04:10:00 AM
    { 0, 0x4b, 0, 141},
    { 0, 0x4b, 0, 141},
    { 0, 0x3c, 318, 141},
    { 0, 0x2c, 0, 142},
    { 0, 0x4b, 740, 149},
    { 0, 0x5b, 0, 142},
    { 0, 0x5b, 0, 142},
    { 0, 0x5b, 0, 141},
    { 0, 0x5b, 0, 141},
    { 0, 0x5b, 0, 142},
    { 0, 0x5b, 0, 141},
    { 0, 0x4b, 765, 141},
    { 0, 0x2c, 0, 142},
    { 0, 0x2c, 0, 142},
    { 0, 0x2c, 0, 144},
    // 705: Local time: 04:25:00 AM
    { 0, 0x2c, 0, 143},
    { 0, 0x2c, 0, 143},
    { 0, 0x2c, 0, 144},
    { 8, 0x1d, 3643, 188},
    { 0, 0x43, 2283, 153},
    { 0, 0xa, 964, 142},
    { 0, 0xc, 0, 143},
    { 0, 0xc, 0, 143},
    { 0, 0xc, 0, 143},
    { 0, 0xc, 0, 144},
    { 0, 0xc, 0, 144},
    { 0, 0xc, 0, 143},
    { 0, 0xc, 0, 143},
    { 0, 0xc, 0, 143},
    { 0, 0xc, 0, 144},
    // 720: Local time: 04:41:00 AM
    { 0, 0xc, 0, 143},
    { 0, 0xc, 29, 143},
    { 0, 0xc, 0, 132},
    { 0, 0xc, 0, 143},
    { 0, 0xc, 0, 150},
    { 0, 0xc, 0, 143},
    { 0, 0xc, 0, 144},
    { 0, 0xc, 0, 143},
    { 0, 0xc, 0, 144},
    { 0, 0xc, 0, 145},
    { 0, 0x1c, 421, 143},
    { 0, 0x1c, 0, 144},
    { 0, 0x1c, 0, 144},
    { 0, 0x1c, 0, 143},
    { 0, 0x1c, 0, 145},
    // 735: Local time: 04:56:00 AM
    { 0, 0x1c, 0, 143},
    { 0, 0x1c, 0, 144},
    { 8, 0x40, 2952, 144},
    { 7, 0x61, 3969, 156},
    { 36, 0x53, 4210, 149},
    { 0, 0x70, 4050, 143},
    { 0, 0x71, 0, 143},
    { 0, 0x71, 0, 144},
    { 0, 0x71, 0, 144},
    { 0, 0x71, 0, 145},
    { 0, 0x72, 2402, 143},
    { 0, 0x64, 0, 143},
    { 0, 0x64, 0, 143},
    { 0, 0x64, 0, 142},
    { 0, 0x64, 296, 145},
    // 750: Local time: 05:11:00 AM
    { 0, 0x76, 0, 144},
    { 0, 0x76, 0, 143},
    { 0, 0x76, 0, 143},
    { 0, 0x76, 0, 143},
    { 0, 0x76, 0, 143},
    { 0, 0x76, 0, 143},
    { 0, 0x76, 0, 142},
    { 0, 0x46, 2986, 142},
    { 0, 0x56, 0, 143},
    { 0, 0x56, 402, 129},
    { 0, 0x56, 2294, 142},
    { 0, 0x66, 41, 142},
    { 0, 0x66, 202, 143},
    { 0, 0x66, 48, 142},
    { 0, 0x66, 278, 143},
    // 765: Local time: 05:26:00 AM
    { 7, 0x69, 5373, 157},
    { 0, 0x4b, 0, 164},
    { 0, 0x59, 587, 164},
    { 0, 0x58, 778, 157},
    { 0, 0x4a, 127, 164},
    { 0, 0x4a, 75, 164},
    { 0, 0x68, 238, 149},
    { 0, 0x66, 113, 148},
    { 0, 0x66, 10, 149},
    { 0, 0x66, 630, 148},
    { 0, 0x66, 950, 148},
    { 0, 0x66, 1876, 150},
    { 0, 0x69, 2323, 143},
    { 0, 0x69, 642, 141},
    { 0, 0x68, 2040, 165},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



// ----------------------------------------------------------------
// Sample captured at: 2015-09-27 00:31:00 local, 2015-09-27 07:31:00 GMT
// According to Tyler:
// sleep entry: 1am (offset 116)
AlgDlsMinuteData *activity_sample_sleep_11(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME sleep_11
  //> TEST_VERSION 2
  //> TEST_TOTAL -1
  //> TEST_TOTAL_MIN -1
  //> TEST_TOTAL_MAX -1
  //> TEST_DEEP -1
  //> TEST_DEEP_MIN -1
  //> TEST_DEEP_MAX -1
  //> TEST_START_AT 116
  //> TEST_START_AT_MIN 95
  //> TEST_START_AT_MAX 126
  //> TEST_END_AT -1
  //> TEST_END_AT_MIN -1
  //> TEST_END_AT_MAX -1
  //> TEST_CUR_STATE_ELAPSED -1
  //> TEST_CUR_STATE_ELAPSED_MIN -1
  //> TEST_CUR_STATE_ELAPSED_MAX -1
  //> TEST_IN_SLEEP 0
  //> TEST_IN_SLEEP_MIN 0
  //> TEST_IN_SLEEP_MAX 0
  //> TEST_IN_DEEP_SLEEP 0
  //> TEST_IN_DEEP_SLEEP_MIN 0
  //> TEST_IN_DEEP_SLEEP_MAX 0
  //> TEST_WEIGHT 1.0
  // list of: { steps, orientation, vmc, flags}
  static AlgDlsMinuteData samples[] = { 
    // 0: Local time: 11:06:00 PM
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 304, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 60, 0x0},
    { 0, 0x3c, 42, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 14, 0x0},
    { 0, 0x3c, 78, 0x0},
    { 0, 0x3c, 962, 0x0},
    { 0, 0x4b, 2592, 0x0},
    // 15: Local time: 11:21:00 PM
    { 0, 0x3b, 361, 0x0},
    { 0, 0x5b, 580, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 220, 0x0},
    { 0, 0x6b, 195, 0x0},
    { 0, 0x6b, 57, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 552, 0x0},
    { 0, 0x6a, 1058, 0x0},
    { 0, 0x4b, 254, 0x0},
    { 0, 0x4b, 639, 0x0},
    { 0, 0x6b, 0, 0x0},
    // 30: Local time: 11:36:00 PM
    { 0, 0x6b, 136, 0x0},
    { 0, 0x5b, 79, 0x0},
    { 0, 0x5b, 173, 0x0},
    { 0, 0x6b, 325, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x6a, 0, 0x0},
    { 0, 0x5b, 856, 0x0},
    { 0, 0x5b, 22, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 22, 0x0},
    { 0, 0x5b, 20, 0x0},
    { 0, 0x5b, 140, 0x0},
    // 45: Local time: 11:51:00 PM
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 362, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x4b, 164, 0x0},
    { 0, 0x4b, 244, 0x0},
    { 0, 0x4b, 190, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x4b, 208, 0x0},
    { 0, 0x5b, 155, 0x0},
    { 0, 0x6a, 232, 0x0},
    // 60: Local time: 12:06:00 AM
    { 0, 0x4b, 584, 0x0},
    { 0, 0x4b, 242, 0x0},
    { 0, 0x4b, 79, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 520, 0x0},
    { 0, 0x3b, 149, 0x0},
    { 0, 0x3b, 158, 0x0},
    { 0, 0x3b, 244, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 904, 0x0},
    { 10, 0x42, 6381, 0x0},
    { 6, 0x41, 6334, 0x0},
    { 0, 0x63, 5185, 0x0},
    // 75: Local time: 12:21:00 AM
    { 33, 0x51, 7220, 0x0},
    { 6, 0x42, 9001, 0x0},
    { 23, 0x41, 5899, 0x0},
    { 0, 0x42, 4392, 0x0},
    { 0, 0x62, 12541, 0x0},
    { 9, 0x68, 3732, 0x0},
    { 0, 0x67, 1278, 0x0},
    { 0, 0x67, 253, 0x0},
    { 0, 0x67, 11, 0x0},
    { 0, 0x67, 0, 0x0},
    { 0, 0x67, 0, 0x0},
    { 0, 0x67, 45, 0x0},
    { 8, 0x57, 466, 0x0},
    { 0, 0x29, 0, 0x0},
    { 0, 0x29, 35, 0x0},
    // 90: Local time: 12:36:00 AM
    { 0, 0x2a, 1728, 0x0},
    { 0, 0x2a, 3549, 0x0},
    { 0, 0x28, 124, 0x0},
    { 0, 0x27, 0, 0x0},
    { 0, 0x27, 0, 0x0},
    { 0, 0x27, 0, 0x0},
    { 0, 0x28, 449, 0x0},
    { 0, 0x39, 0, 0x0},
    { 0, 0x29, 0, 0x0},
    { 0, 0x29, 0, 0x0},
    { 0, 0x29, 0, 0x0},
    { 0, 0x29, 17, 0x0},
    { 0, 0x29, 20, 0x0},
    { 0, 0x29, 19, 0x0},
    { 0, 0x39, 34, 0x0},
    // 105: Local time: 12:51:01 AM
    { 0, 0x39, 193, 0x0},
    { 0, 0x38, 241, 0x0},
    { 0, 0x38, 0, 0x0},
    { 0, 0x38, 11, 0x0},
    { 0, 0x38, 0, 0x0},
    { 0, 0x2a, 2789, 0x0},
    { 0, 0x2e, 10, 0x0},
    { 0, 0x2e, 124, 0x0},
    { 0, 0x2e, 45, 0x0},
    { 0, 0x3d, 1009, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 368, 0x0},
    { 0, 0x2b, 10, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 120: Local time: 01:06:01 AM
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 26, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 135: Local time: 01:21:01 AM
    { 0, 0x2b, 0, 0x0},
    { 0, 0x3c, 845, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2f, 0, 0x0},
    { 0, 0x2e, 20, 0x0},
    { 0, 0x2e, 63, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    // 150: Local time: 01:36:01 AM
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 0, 0x0},
    { 0, 0x2e, 1252, 0x0},
    { 0, 0x1a, 337, 0x0},
    { 0, 0x9, 0, 0x0},
    { 0, 0x9, 0, 0x0},
    { 0, 0xa, 0, 0x0},
    { 0, 0x1c, 1235, 0x0},
    { 0, 0x29, 1240, 0x0},
    // 165: Local time: 01:51:00 AM
    { 0, 0x2a, 45, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 54, 0x0},
    { 0, 0x2a, 814, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 103, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 149, 0x0},
    { 0, 0x2b, 47, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 128, 0x0},
    // 180: Local time: 02:06:01 AM
    { 0, 0x2a, 232, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 22, 0x0},
    { 0, 0x2a, 31, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x35, 790, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 486, 0x0},
    { 0, 0x45, 0, 0x0},
    { 0, 0x45, 20, 0x0},
    { 0, 0x45, 0, 0x0},
    { 0, 0x35, 14, 0x0},
    { 0, 0x35, 0, 0x0},
    // 195: Local time: 02:21:00 AM
    { 0, 0x35, 0, 0x0},
    { 0, 0x29, 1053, 0x0},
    { 0, 0x29, 0, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x69, 612, 0x0},
    { 0, 0x88, 0, 0x0},
    { 0, 0x79, 602, 0x0},
    { 0, 0x6a, 133, 0x0},
    { 0, 0x6b, 189, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    // 210: Local time: 02:36:00 AM
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x4a, 408, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x29, 75, 0x0},
    { 0, 0x2a, 352, 0x0},
    { 0, 0x29, 0, 0x0},
    { 0, 0x29, 0, 0x0},
    { 0, 0x2a, 1308, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 225: Local time: 02:51:00 AM
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 240: Local time: 03:06:00 AM
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 255: Local time: 03:21:00 AM
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    // 270: Local time: 03:36:00 AM
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 0, 0x0},
    { 0, 0x2b, 71, 0x0},
    { 0, 0x55, 1123, 0x0},
    { 0, 0x45, 0, 0x0},
    { 0, 0x45, 0, 0x0},
    { 0, 0x45, 408, 0x0},
    { 0, 0x25, 396, 0x0},
    { 0, 0x25, 0, 0x0},
    // 285: Local time: 03:51:00 AM
    { 0, 0x35, 296, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x44, 0, 0x0},
    { 0, 0x55, 1046, 0x0},
    { 0, 0x7a, 0, 0x0},
    { 0, 0x7a, 0, 0x0},
    { 0, 0x7a, 0, 0x0},
    { 0, 0x6a, 689, 0x0},
    { 0, 0x5a, 0, 0x0},
    { 0, 0x5a, 0, 0x0},
    { 0, 0x6a, 411, 0x0},
    // 300: Local time: 04:06:00 AM
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x6b, 0, 0x0},
    { 0, 0x3b, 1290, 0x0},
    { 0, 0x45, 1080, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    // 315: Local time: 04:21:00 AM
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 16, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x35, 0, 0x0},
    { 0, 0x28, 1645, 0x0},
    { 0, 0x3a, 0, 0x0},
    // 330: Local time: 04:36:00 AM
    { 0, 0x3a, 0, 0x0},
    { 0, 0x2a, 146, 0x0},
    { 0, 0x29, 1269, 0x0},
    { 13, 0x38, 4142, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x3c, 0, 0x0},
    { 0, 0x2c, 713, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    { 0, 0x1c, 0, 0x0},
    // 345: Local time: 04:51:00 AM
    { 0, 0x3b, 531, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x4b, 0, 0x0},
    { 0, 0x3b, 259, 0x0},
    { 0, 0x2b, 438, 0x0},
    { 0, 0x3b, 257, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    // 360: Local time: 05:06:00 AM
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 0, 0x0},
    { 0, 0x3b, 208, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    // 375: Local time: 05:21:00 AM
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x3b, 199, 0x0},
    { 0, 0x1d, 1807, 0x0},
    { 0, 0x1f, 0, 0x0},
    // 390: Local time: 05:36:00 AM
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1e, 291, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1f, 0, 0x0},
    { 0, 0x2f, 466, 0x0},
    { 0, 0x2f, 0, 0x0},
    { 0, 0x2f, 0, 0x0},
    { 0, 0x2f, 0, 0x0},
    { 0, 0x2f, 2735, 0x0},
    { 0, 0x1e, 17, 0x0},
    // 405: Local time: 05:51:00 AM
    { 0, 0x1e, 25, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x2f, 310, 0x0},
    { 0, 0x2f, 222, 0x0},
    { 0, 0x21, 267, 0x0},
    { 0, 0x3e, 1016, 0x0},
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5c, 0, 0x0},
    { 0, 0x5c, 22, 0x0},
    { 0, 0x5c, 387, 0x0},
    { 0, 0x5c, 0, 0x0},
    { 0, 0x5c, 0, 0x0},
    { 0, 0x1d, 574, 0x0},
    // 420: Local time: 06:06:00 AM
    { 0, 0xf, 0, 0x0},
    { 0, 0xf, 0, 0x0},
    { 0, 0xf, 0, 0x0},
    { 0, 0x1d, 467, 0x0},
    { 0, 0x5c, 0, 0x0},
    { 0, 0x5c, 233, 0x0},
    { 0, 0x5c, 0, 0x0},
    { 0, 0x3b, 1514, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    // 435: Local time: 06:21:00 AM
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x1a, 862, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    // 450: Local time: 06:36:00 AM
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 0, 0x0},
    { 0, 0x1e, 515, 0x0},
    { 0, 0x2f, 0, 0x0},
    { 0, 0x2f, 53, 0x0},
    { 0, 0x2f, 0, 0x0},
    { 0, 0x2f, 0, 0x0},
    { 0, 0x1e, 846, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x19, 0, 0x0},
    { 0, 0x1a, 599, 0x0},
    // 465: Local time: 06:51:00 AM
    { 0, 0x1b, 568, 0x0},
    { 0, 0x26, 1977, 0x0},
    { 0, 0x16, 0, 0x0},
    { 0, 0x16, 0, 0x0},
    { 0, 0x16, 56, 0x0},
    { 0, 0x26, 0, 0x0},
    { 0, 0x26, 0, 0x0},
    { 0, 0x25, 444, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 333, 0x0},
    { 0, 0x2a, 492, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 0, 0x0},
    { 0, 0x2a, 11, 0x0},
    { 0, 0x2a, 0, 0x0},
    // 480: Local time: 07:06:00 AM
    { 0, 0x29, 241, 0x0},
    { 0, 0x29, 0, 0x0},
    { 0, 0x29, 0, 0x0},
    { 0, 0x29, 17, 0x0},
    { 0, 0x29, 458, 0x0},
    { 0, 0x16, 0, 0x0},
    { 0, 0x16, 60, 0x0},
    { 0, 0x19, 865, 0x0},
    { 0, 0x1a, 0, 0x0},
    { 0, 0x1b, 1934, 0x0},
    { 0, 0x5b, 1721, 0x0},
    { 0, 0x5c, 0, 0x0},
    { 0, 0x5c, 0, 0x0},
    { 0, 0x4c, 5095, 0x0},
    { 0, 0x1f, 433, 0x0},
    // 495: Local time: 07:21:00 AM
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1f, 180, 0x0},
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1f, 0, 0x0},
    { 0, 0x1f, 660, 0x0},
    { 0, 0x1e, 159, 0x0},
    { 0, 0x1f, 395, 0x0},
    { 0, 0x2c, 1416, 0x0},
    { 0, 0x5b, 599, 0x0},
    // 510: Local time: 07:36:00 AM
    { 0, 0x5b, 0, 0x0},
    { 0, 0x5c, 287, 0x0},
    { 0, 0x5c, 0, 0x0},
    { 0, 0x5c, 63, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x4c, 2320, 0x0},
    { 0, 0x19, 1296, 0x0},
    { 0, 0x19, 99, 0x0},
    { 0, 0x19, 76, 0x0},
    { 0, 0x19, 0, 0x0},
    // 525: Local time: 07:51:00 AM
    { 0, 0x17, 982, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 105, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    // 540: Local time: 08:06:00 AM
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 0, 0x0},
    { 0, 0x25, 244, 0x0},
    { 0, 0x29, 399, 0x0},
    { 8, 0x17, 1244, 0x0},
    { 0, 0x1b, 1460, 0x0},
    { 0, 0x4c, 0, 0x0},
    { 0, 0x3d, 1098, 0x0},
    { 0, 0x20, 5752, 0x0},
    { 0, 0x29, 34, 0x0},
    { 0, 0x29, 51, 0x0},
    { 0, 0x29, 210, 0x0},
    { 0, 0x29, 106, 0x0},
    { 0, 0x29, 0, 0x0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}
