/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#pragma once

#include "item.h"
#include "layout_layer.h"
#include "timeline_layout.h"

#include "applib/graphics/graphics.h"
#include "applib/graphics/text.h"
#include "applib/ui/bitmap_layer.h"

typedef enum {
  GameStatePreGame = 0,
  GameStateInGame,
  GameStatePostGame
} GameState;

typedef struct {
  TimelineLayout timeline_layout;
  GameState state;
} SportsLayout;

LayoutLayer *sports_layout_create(const LayoutLayerConfig *config);

bool sports_layout_verify(bool existing_attributes[]);
