/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#pragma once

#include <stddef.h>

#include "applib/graphics/gtypes.h"

// GBitmap + pixel data generated by bitmapgen.py:

/** Status Bar Icons */

static const uint8_t s_status_icon_launcher_pixels[] = {
  0xdf, 0x07, 0x00, 0x00, 0x8f, 0x07, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x03, 0x06, 0x00, 0x00, /* bytes 0 - 16 */
  0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x04, 0x00, 0x00, 0x71, 0x04, 0x00, 0x00, /* bytes 16 - 32 */
  0x71, 0x04, 0x00, 0x00, 0x71, 0x04, 0x00, 0x00,
};

static const GBitmap s_status_icon_launcher_bitmap = {
  .addr = (void*) &s_status_icon_launcher_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 11, .h = 10 },
  },
};

static const uint8_t s_status_icon_sms_pixels[] = {
  0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* bytes 0 - 16 */
  0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0xc7, 0x03, 0x00, 0x00, 0xe7, 0x03, 0x00, 0x00, /* bytes 16 - 32 */
  0xf7, 0x03, 0x00, 0x00,
};

static const GBitmap s_status_icon_sms_bitmap = {
  .addr = (void*) &s_status_icon_sms_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 10, .h = 9 },
  },
};

static const uint8_t s_status_icon_bluetooth_pixels[] = {
  0x77, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, /* bytes 0 - 16 */
  0x55, 0x00, 0x00, 0x00, 0x63, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, /* bytes 16 - 32 */
  0x57, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00,
};

static const GBitmap s_status_icon_bluetooth_bitmap = {
  .addr = (void*) &s_status_icon_bluetooth_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 7, .h = 11 },
  },
};

static const uint8_t s_status_icon_settings_pixels[] = {
  0x3f, 0x03, 0x00, 0x00, 0xbf, 0x03, 0x00, 0x00, 0x3f, 0x01, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, /* bytes 0 - 16 */
  0x8f, 0x03, 0x00, 0x00, 0xc7, 0x03, 0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0xf2, 0x03, 0x00, 0x00, /* bytes 16 - 32 */
  0xf7, 0x03, 0x00, 0x00, 0xf3, 0x03, 0x00, 0x00,
};

static const GBitmap s_status_icon_settings_bitmap = {
  .addr = (void*) &s_status_icon_settings_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 10, .h = 10 },
  },
};

static const uint8_t s_status_icon_phone_pixels[] = {
  0xfd, 0x07, 0x00, 0x00, 0xf8, 0x07, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0xf8, 0x07, 0x00, 0x00, /* bytes 0 - 16 */
  0xf9, 0x07, 0x00, 0x00, 0xf1, 0x07, 0x00, 0x00, 0xe3, 0x07, 0x00, 0x00, 0xc7, 0x06, 0x00, 0x00, /* bytes 16 - 32 */
  0x0f, 0x04, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x7f, 0x04, 0x00, 0x00,
};

static const GBitmap s_status_icon_phone_bitmap = {
  .addr = (void*) &s_status_icon_phone_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 11, .h = 11 },
  },
};

static const uint8_t s_status_icon_music_pixels[] = {
  0x3f, 0x00, 0x00, 0x00, 0xc7, 0x00, 0x00, 0x00, 0xf7, 0x00, 0x00, 0x00, 0xf7, 0x00, 0x00, 0x00, /* bytes 0 - 16 */
  0xf7, 0x00, 0x00, 0x00, 0xf7, 0x00, 0x00, 0x00, 0x37, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, /* bytes 16 - 32 */
  0x10, 0x01, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00,
};

static const GBitmap s_status_icon_music_bitmap = {
  .addr = (void*) &s_status_icon_music_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 9, .h = 10 },
  },
};

static const uint8_t s_status_icon_silent_pixels[] = {
    0x7f, 0x03, 0x00, 0x00, 0x3f, 0x01, 0x00, 0x00, 0x9f, 0x04, 0x00, 0x00, 0x43, 0x06, 0x00, 0x00, /* bytes 0 - 16 */
    0x23, 0x07, 0x00, 0x00, 0x93, 0x07, 0x00, 0x00, 0x4b, 0x07, 0x00, 0x00, 0x27, 0x07, 0x00, 0x00, /* bytes 16 - 32 */
    0x13, 0x07, 0x00, 0x00, 0x39, 0x07, 0x00, 0x00, 0x7c, 0x07, 0x00, 0x00, 
};

static const GBitmap s_status_icon_silent_bitmap = {
  .addr = (void*) &s_status_icon_silent_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 11, .h = 11 },
  },
};

static const uint8_t s_quiet_time_status_icon_pixels[] = {
    0x03, 0x03, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* bytes 0 - 16 */
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* bytes 16 - 32 */
    0x01, 0x02, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00,
};

static const GBitmap s_quiet_time_status_icon_bitmap = {
    .addr = (void*) &s_quiet_time_status_icon_pixels,
    .row_size_bytes = 4,
    .info_flags = 0x1000,
    .bounds = {
        .origin = { .x = 0, .y = 0 },
        .size = { .w = 10, .h = 10 },
    },
};

/** Action Bar Icons */

static const uint8_t s_bar_icon_actions_pixels[] = {
  0xff, 0xf7, 0x00, 0x00, 0xff, 0xe7, 0x00, 0x00, 0x83, 0xc7, 0x00, 0x00, 0xfd, 0x81, 0x00, 0x00, /* bytes 0 - 16 */
  0x7d, 0x00, 0x00, 0x00, 0x1d, 0x80, 0x00, 0x00, 0x9d, 0xc7, 0x00, 0x00, 0xed, 0xe7, 0x00, 0x00, /* bytes 16 - 32 */
  0xed, 0xf7, 0x00, 0x00, 0xfd, 0xbf, 0x00, 0x00, 0xfd, 0xbf, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00,
};

static const GBitmap s_bar_icon_actions_bitmap = {
  .addr = (void*) &s_bar_icon_actions_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 16, .h = 12 },
  },
};

static const uint8_t s_bar_icon_phone_pixels[] = {
  0xf3, 0x7f, 0x00, 0x00, 0xe1, 0x7f, 0x00, 0x00, 0xc1, 0x7f, 0x00, 0x00, 0xc1, 0x7f, 0x00, 0x00, /* bytes 0 - 16 */
  0xe1, 0x7f, 0x00, 0x00, 0xe3, 0x7f, 0x00, 0x00, 0xe3, 0x7f, 0x00, 0x00, 0xc7, 0x7f, 0x00, 0x00, /* bytes 16 - 32 */
  0x87, 0x7f, 0x00, 0x00, 0x0f, 0x67, 0x00, 0x00, 0x1f, 0x40, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, /* bytes 32 - 48 */
  0xff, 0x00, 0x00, 0x00, 0xff, 0x43, 0x00, 0x00,
};

static const GBitmap s_bar_icon_phone_bitmap = {
  .addr = (void*) &s_bar_icon_phone_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 15, .h = 14 },
  },
};

static const uint8_t s_bar_icon_x_pixels[] = {
  0xfb, 0x0d, 0x00, 0x00, 0xf1, 0x08, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, /* bytes 0 - 16 */
  0x03, 0x0c, 0x00, 0x00, 0x07, 0x0e, 0x00, 0x00, 0x07, 0x0e, 0x00, 0x00, 0x03, 0x0c, 0x00, 0x00, /* bytes 16 - 32 */
  0x01, 0x08, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0xf1, 0x08, 0x00, 0x00, 0xfb, 0x0d, 0x00, 0x00,
};

static const GBitmap s_bar_icon_x_bitmap = {
  .addr = (void*) &s_bar_icon_x_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 12, .h = 12 },
  },
};

static const uint8_t s_bar_icon_check_pixels[] = {
  0x00, 0x80, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0xf0, 0x01, 0x00, /* bytes 0 - 16 */
  0x00, 0xf8, 0x00, 0x00, 0x04, 0x7c, 0x00, 0x00, 0x0e, 0x3e, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, /* bytes 16 - 32 */
  0xbe, 0x0f, 0x00, 0x00, 0xfc, 0x07, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, /* bytes 32 - 48 */
  0xe0, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
};

static const GBitmap s_bar_icon_check_bitmap = {
  .addr = (void*) &s_bar_icon_check_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 18, .h = 14 },
  },
};

static const uint8_t s_bar_icon_up_pixels[] = {
  0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, /* bytes 0 - 16 */
  0xfc, 0x03, 0x00, 0x00, 0xfe, 0x07, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00,
};

static const GBitmap s_bar_icon_up_bitmap = {
  .addr = (void*) &s_bar_icon_up_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 12, .h = 7 },
  },
};

static const uint8_t s_bar_icon_down_pixels[] = {
  0xff, 0x0f, 0x00, 0x00, 0xfe, 0x07, 0x00, 0x00, 0xfc, 0x03, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, /* bytes 0 - 16 */
  0xf0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const GBitmap s_bar_icon_down_bitmap = {
  .addr = (void*) &s_bar_icon_down_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 12, .h = 7 },
  },
};

static const uint8_t s_bar_icon_yes_pixels[] = {
  0xf8, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x71, 0x04, 0x00, 0x00, /* bytes 0 - 16 */
  0x71, 0x04, 0x00, 0x00, 0x71, 0x04, 0x00, 0x00, 0x23, 0x06, 0x00, 0x00, 0x23, 0x06, 0x00, 0x00, /* bytes 16 - 32 */
  0x27, 0x07, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x8f, 0x07, 0x00, 0x00, /* bytes 32 - 48 */
  0x8f, 0x07, 0x00, 0x00, 0x8f, 0x07, 0x00, 0x00, 0x8f, 0x07, 0x00, 0x00, 0x8f, 0x07, 0x00, 0x00, /* bytes 48 - 64 */
  0x8f, 0x07, 0x00, 0x00, 0x8f, 0x07, 0x00, 0x00,
};

static const GBitmap s_bar_icon_yes_bitmap = {
  .addr = (void*) &s_bar_icon_yes_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 11, .h = 18 },
  },
};

static const uint8_t s_bar_icon_no_pixels[] = {
  0x78, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, /* bytes 0 - 16 */
  0x60, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, /* bytes 16 - 32 */
  0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, /* bytes 32 - 48 */
  0x18, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, /* bytes 48 - 64 */
  0x78, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
};

static const GBitmap s_bar_icon_no_bitmap = {
  .addr = (void*) &s_bar_icon_no_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 10, .h = 18 },
  },
};

static const uint8_t s_bar_icon_snooze_pixels[] = {
    0x3f, 0x00, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0x80, 0x0e, 0x00, 0x00, /* bytes 0 - 16 */
    0x00, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0xc7, 0x0f, 0x00, 0x00, 0xe3, 0x0f, 0x00, 0x00, /* bytes 16 - 32 */
    0xf1, 0x0f, 0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 
};

static const GBitmap s_bar_icon_snooze_bitmap = {
  .addr = (void*) &s_bar_icon_snooze_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 12, .h = 12 },
  },
};

// Battery Icons
////////////////////////////////////////////////////////////
static const uint8_t s_status_battery_empty_pixels[] = {
    0xff, 0x3f, 0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0x01, 0x60, 0x00, 0x00, 0x01, 0x60, 0x00, 0x00, /* bytes 0 - 16 */
    0x01, 0x60, 0x00, 0x00, 0x01, 0x60, 0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 
};

static const GBitmap s_status_battery_empty_bitmap = {
  .addr = (void*) &s_status_battery_empty_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 15, .h = 8 },
  },
};

static const uint8_t s_status_battery_charging_pixels[] = {
    0x88, 0xff, 0x1f, 0x00, 0x8c, 0x00, 0x10, 0x00, 0x86, 0x00, 0x30, 0x00, 0x87, 0x00, 0x30, 0x00, /* bytes 0 - 16 */
    0x9c, 0x00, 0x30, 0x00, 0x8c, 0x00, 0x30, 0x00, 0x86, 0x00, 0x10, 0x00, 0x82, 0xff, 0x1f, 0x00, 
};

static const GBitmap s_status_battery_charging_bitmap = {
  .addr = (void*) &s_status_battery_charging_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 22, .h = 8 },
  },
};

static const uint8_t s_status_battery_charged_pixels[] = {
    0x0f, 0x3c, 0x00, 0x00, 0xc1, 0x21, 0x00, 0x00, 0xe1, 0x67, 0x00, 0x00, 0xfd, 0x61, 0x00, 0x00, /* bytes 0 - 16 */
    0xfd, 0x61, 0x00, 0x00, 0xe1, 0x67, 0x00, 0x00, 0xc1, 0x21, 0x00, 0x00, 0x0f, 0x3c, 0x00, 0x00, 
};

static const GBitmap s_status_battery_charged_bitmap = {
  .addr = (void*) &s_status_battery_charged_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 15, .h = 8 },
  },
};

static const uint8_t s_status_icon_phone_only_pixels[] = {
    0x41, 0x02, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, /* bytes 0 - 16 */
    0x24, 0x00, 0x00, 0x00, 0x13, 0x02, 0x00, 0x00, 0xc9, 0x03, 0x00, 0x00, 0xe4, 0x03, 0x00, 0x00, /* bytes 16 - 32 */
    0xf6, 0x03, 0x00, 0x00, 
};

static const GBitmap s_status_icon_phone_only_bitmap = {
  .addr = (void*) &s_status_icon_phone_only_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 10, .h = 9 },
  },
};

static const uint8_t s_status_icon_airplane_mode_pixels[] = {
  0xcf, 0x0f, 0x00, 0x00, 0x9f, 0x0f, 0x00, 0x00, 0x1c, 0x0f, 0x00, 0x00, 0x39, 0x0e, 0x00, 0x00, /* bytes 0 - 16 */
  0x01, 0x08, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x39, 0x0e, 0x00, 0x00, /* bytes 16 - 32 */
  0x1c, 0x0f, 0x00, 0x00, 0x9f, 0x0f, 0x00, 0x00, 0xcf, 0x0f, 0x00, 0x00,
};

static const GBitmap s_status_icon_airplane_mode_bitmap = {
  .addr = (void*) &s_status_icon_airplane_mode_pixels,
  .row_size_bytes = 4,
  .info_flags = 0x1000,
  .bounds = {
    .origin = { .x = 0, .y = 0 },
    .size = { .w = 12, .h = 11 },
  },
};
