/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */



// ----------------------------------------------------------------
// Sample captured: 2015-10-16 12:36:34 local
AccelRawData *activity_sample_walk_100_pbl_28397_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28397_9
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 32, 40, -1048},
    { 24, 0, -1008},
    { -8, 88, -1040},
    { 0, 32, -1040},
    { -24, 112, -936},
    { -24, 8, -1016},
    { -88, 72, -1000},
    { -40, -40, -984},
    { -72, 0, -1008},
    { -80, -48, -1040},
    { -120, -24, -1048},
    { -112, -24, -1024},
    { -136, 24, -1040},
    { -104, 144, -1024},
    { -56, 40, -1056},
    { -40, 40, -1024},
    { -24, 40, -1024},
    { -64, 80, -1024},
    { -16, 32, -1016},
    { 24, -32, -984},
    { 0, -64, -976},
    { 136, -168, -944},
    { 160, -264, -848},
    { 128, -344, -784},
    { 200, 160, -888},
    // 1 seconds
    { 304, 560, -904},
    { 280, 984, -816},
    { 200, 1032, -656},
    { 128, 1000, -528},
    { 184, 984, -368},
    { 296, 944, -296},
    { 344, 800, -344},
    { 368, 560, -368},
    { 464, 528, -360},
    { 600, 440, -336},
    { 808, 720, -384},
    { 920, 800, -464},
    { 1048, 552, -392},
    { 1160, 472, -360},
    { 1312, 520, -360},
    { 1352, 504, -408},
    { 1344, 488, -472},
    { 1248, 416, -424},
    { 1152, 344, -528},
    { 1112, 344, -568},
    { 1088, 344, -648},
    { 1072, 288, -688},
    { 1048, 288, -600},
    { 1008, 408, -512},
    { 976, 368, -448},
    // 2 seconds
    { 816, 368, -384},
    { 768, 352, -384},
    { 976, 344, -328},
    { 1288, 352, -304},
    { 1472, 344, -304},
    { 1512, 280, -248},
    { 1480, 248, -296},
    { 1392, 216, -304},
    { 1256, 160, -312},
    { 1152, 80, -376},
    { 992, 48, -392},
    { 968, 0, -424},
    { 1024, -16, -440},
    { 840, -136, -392},
    { 1016, -136, -384},
    { 1000, 0, -256},
    { 864, 88, -264},
    { 1000, 152, -312},
    { 1128, 176, -328},
    { 1176, 192, -280},
    { 1064, 224, -328},
    { 1016, 208, -344},
    { 1016, 200, -384},
    { 1024, 216, -488},
    { 1024, 184, -552},
    // 3 seconds
    { 1336, 248, -304},
    { 1128, 336, -328},
    { 1216, 288, -392},
    { 1448, 592, -400},
    { 952, 656, -592},
    { 1488, 640, -696},
    { 1016, 464, -576},
    { 1048, 352, -440},
    { 1200, 336, -392},
    { 1256, 336, -328},
    { 1112, 352, -152},
    { 1224, 168, -152},
    { 1424, 248, -152},
    { 1336, 136, -192},
    { 1144, 64, -232},
    { 1184, -48, -272},
    { 976, -168, -304},
    { 880, -104, -352},
    { 1056, -40, -368},
    { 856, -40, -312},
    { 1176, 8, -408},
    { 1136, 24, -376},
    { 920, 112, -360},
    { 712, 176, -336},
    { 808, 168, -296},
    // 4 seconds
    { 1024, 176, -224},
    { 1184, 232, -264},
    { 1408, 264, -288},
    { 1848, 656, -472},
    { 1328, 864, -616},
    { 1440, 960, -624},
    { 992, 704, -528},
    { 752, 584, -504},
    { 1064, 536, -424},
    { 1336, 416, -288},
    { 1200, 328, -264},
    { 1144, 256, -264},
    { 1272, 240, -224},
    { 1280, 160, -216},
    { 1160, 128, -240},
    { 1000, 104, -296},
    { 1152, 8, -328},
    { 888, -144, -352},
    { 1008, -184, -272},
    { 1128, -112, -232},
    { 1064, 104, -360},
    { 1304, 96, -368},
    { 1232, 136, -376},
    { 944, 216, -272},
    { 816, 232, -320},
    // 5 seconds
    { 928, 280, -224},
    { 1192, 328, -280},
    { 1296, 384, -280},
    { 1264, 400, -328},
    { 1512, 704, -448},
    { 1056, 832, -472},
    { 936, 616, -472},
    { 1032, 608, -416},
    { 1064, 576, -512},
    { 1320, 520, -416},
    { 1424, 400, -320},
    { 1288, 272, -216},
    { 1208, 176, -232},
    { 1304, 152, -248},
    { 1336, 200, -248},
    { 1192, 176, -216},
    { 1072, 128, -256},
    { 1232, 16, -304},
    { 896, -176, -208},
    { 1048, -200, -280},
    { 1032, -128, -120},
    { 1024, 40, -304},
    { 1192, 64, -360},
    { 1264, 120, -384},
    { 1128, 160, -376},
    // 6 seconds
    { 928, 240, -392},
    { 1000, 264, -368},
    { 1192, 264, -360},
    { 1224, 312, -392},
    { 1208, 328, -392},
    { 1512, 496, -448},
    { 1216, 680, -480},
    { 1432, 720, -648},
    { 1112, 592, -456},
    { 1000, 416, -504},
    { 1136, 392, -424},
    { 1328, 384, -352},
    { 1232, 320, -232},
    { 1176, 192, -176},
    { 1280, 280, -168},
    { 1392, 184, -192},
    { 1312, 176, -184},
    { 1168, 48, -208},
    { 1136, -64, -216},
    { 816, -184, -216},
    { 1088, -184, -248},
    { 1144, -208, -224},
    { 1152, -8, -320},
    { 1296, -48, -400},
    { 1240, 80, -424},
    // 7 seconds
    { 1008, 112, -328},
    { 944, 160, -344},
    { 1112, 280, -296},
    { 1296, 288, -296},
    { 1384, 360, -320},
    { 1432, 624, -656},
    { 1440, 816, -672},
    { 1152, 736, -552},
    { 1392, 872, -552},
    { 1024, 600, -600},
    { 1160, 464, -424},
    { 1360, 400, -344},
    { 1472, 344, -248},
    { 1328, 264, -168},
    { 1280, 144, -160},
    { 1360, 216, -224},
    { 1392, 160, -280},
    { 1248, 96, -296},
    { 1240, 24, -352},
    { 984, -176, -232},
    { 672, -152, -352},
    { 904, -24, -232},
    { 840, -8, -248},
    { 1040, 112, -304},
    { 1328, 112, -336},
    // 8 seconds
    { 1384, 240, -368},
    { 1064, 216, -384},
    { 920, 232, -360},
    { 1072, 216, -328},
    { 1232, 232, -328},
    { 1160, 240, -440},
    { 1536, 304, -496},
    { 1624, 616, -576},
    { 1096, 616, -760},
    { 1288, 616, -600},
    { 1152, 480, -520},
    { 1008, 432, -528},
    { 1048, 384, -416},
    { 1256, 296, -296},
    { 1224, 272, -240},
    { 1168, 176, -200},
    { 1264, 224, -216},
    { 1368, 192, -224},
    { 1312, 184, -224},
    { 1296, 144, -368},
    { 1232, -144, -264},
    { 752, -360, -112},
    { 1096, -288, -24},
    { 1096, -48, -176},
    { 1144, 80, -240},
    // 9 seconds
    { 1272, 64, -328},
    { 1176, 144, -336},
    { 1000, 144, -312},
    { 896, 208, -328},
    { 1016, 216, -328},
    { 1144, 232, -336},
    { 1192, 296, -400},
    { 1488, 376, -488},
    { 1552, 584, -552},
    { 1120, 528, -712},
    { 1304, 848, -688},
    { 1176, 488, -528},
    { 1184, 416, -504},
    { 1264, 352, -448},
    { 1352, 320, -288},
    { 1232, 200, -136},
    { 1256, 128, -128},
    { 1408, 192, -216},
    { 1344, 144, -208},
    { 1104, 80, -184},
    { 1224, 48, -256},
    { 936, -144, -128},
    { 856, -168, -256},
    { 1032, -88, -40},
    { 1160, 8, -296},
    // 10 seconds
    { 1248, 48, -328},
    { 1400, 72, -464},
    { 1176, 136, -424},
    { 928, 152, -440},
    { 944, 184, -328},
    { 1160, 208, -296},
    { 1280, 288, -296},
    { 1336, 384, -328},
    { 1584, 744, -536},
    { 1248, 784, -496},
    { 1160, 648, -440},
    { 1056, 592, -368},
    { 952, 520, -456},
    { 1208, 496, -440},
    { 1440, 408, -352},
    { 1512, 360, -264},
    { 1368, 128, -120},
    { 1296, 200, -144},
    { 1344, 216, -256},
    { 1216, 144, -128},
    { 1024, 64, -144},
    { 1152, -32, -184},
    { 976, -112, -176},
    { 952, -168, -144},
    { 1200, -80, -64},
    // 11 seconds
    { 1192, 0, -296},
    { 1280, 40, -288},
    { 1280, 80, -312},
    { 1080, 176, -304},
    { 904, 256, -264},
    { 984, 376, -192},
    { 1128, 408, -88},
    { 1328, 512, -224},
    { 1472, 584, -192},
    { 1680, 848, -336},
    { 1152, 1016, -136},
    { 1288, 784, -264},
    { 952, 752, -328},
    { 880, 664, -328},
    { 984, 552, -280},
    { 1176, 480, -208},
    { 1152, 344, -144},
    { 1168, 272, -96},
    { 1328, 304, -112},
    { 1528, 264, -184},
    { 1448, 216, -224},
    { 1400, 152, -360},
    { 1264, 40, -376},
    { 792, -200, -232},
    { 1040, -224, -72},
    // 12 seconds
    { 896, 0, -200},
    { 1008, 192, -288},
    { 1232, 232, -376},
    { 1224, 240, -384},
    { 984, 232, -264},
    { 872, 264, -304},
    { 992, 344, -288},
    { 1144, 424, -288},
    { 1152, 616, -408},
    { 1496, 832, -440},
    { 1248, 864, -384},
    { 1008, 720, -328},
    { 1232, 808, -304},
    { 1056, 672, -384},
    { 1168, 536, -336},
    { 1240, 416, -232},
    { 1192, 336, -200},
    { 1016, 240, -176},
    { 1072, 216, -208},
    { 1248, 224, -240},
    { 1200, 136, -288},
    { 1088, 64, -224},
    { 1200, 32, -344},
    { 920, -96, -280},
    { 1160, -24, -160},
    // 13 seconds
    { 1104, -32, -232},
    { 1128, 128, -280},
    { 1304, 120, -368},
    { 1240, 152, -416},
    { 920, 176, -408},
    { 816, 168, -288},
    { 952, 272, -320},
    { 1112, 320, -272},
    { 1120, 336, -296},
    { 1384, 440, -368},
    { 1488, 632, -432},
    { 1112, 616, -392},
    { 1400, 720, -488},
    { 968, 536, -488},
    { 1000, 456, -448},
    { 1144, 376, -328},
    { 1120, 296, -264},
    { 1000, 280, -232},
    { 1088, 208, -120},
    { 1304, 256, -208},
    { 1376, 200, -176},
    { 1208, 192, -216},
    { 1448, 64, -296},
    { 968, -336, -72},
    { 1024, -192, -104},
    // 14 seconds
    { 1064, -104, -64},
    { 1224, -8, -224},
    { 1400, 56, -312},
    { 1192, 24, -352},
    { 864, 0, -416},
    { 680, 24, -336},
    { 784, 72, -336},
    { 1016, 200, -360},
    { 1280, 240, -352},
    { 1560, 344, -432},
    { 1712, 472, -680},
    { 1176, 704, -648},
    { 1432, 576, -648},
    { 1056, 400, -560},
    { 1200, 440, -600},
    { 1328, 344, -408},
    { 1440, 312, -264},
    { 1208, 264, -208},
    { 1128, 216, -176},
    { 1184, 208, -128},
    { 1272, 192, -144},
    { 1176, 152, -144},
    { 1240, 136, -176},
    { 1184, 24, -192},
    { 736, 56, 168},
    // 15 seconds
    { 1000, -176, -280},
    { 1008, -112, -208},
    { 1048, 32, -344},
    { 1200, 32, -376},
    { 1256, 120, -456},
    { 1000, 136, -280},
    { 888, 152, -344},
    { 1088, 224, -256},
    { 1336, 368, -320},
    { 1296, 408, -392},
    { 1328, 672, -624},
    { 1528, 752, -704},
    { 1032, 728, -496},
    { 1312, 752, -488},
    { 1080, 568, -424},
    { 1088, 520, -432},
    { 1240, 496, -336},
    { 1424, 392, -248},
    { 1264, 312, -200},
    { 1208, 272, -168},
    { 1336, 248, -192},
    { 1352, 200, -160},
    { 1224, 152, -184},
    { 1240, 64, -240},
    { 1160, -80, -176},
    // 16 seconds
    { 936, -232, -128},
    { 1136, -104, -24},
    { 1152, 16, -296},
    { 1272, 152, -376},
    { 1184, 168, -376},
    { 928, 136, -320},
    { 784, 168, -296},
    { 896, 160, -248},
    { 1288, 352, -320},
    { 1392, 328, -392},
    { 1288, 416, -424},
    { 1424, 688, -680},
    { 1048, 560, -648},
    { 1368, 400, -608},
    { 1184, 456, -624},
    { 1128, 416, -592},
    { 1160, 320, -504},
    { 1352, 280, -424},
    { 1256, 264, -304},
    { 1184, 208, -200},
    { 1280, 232, -192},
    { 1296, 208, -144},
    { 1192, 176, -160},
    { 1152, 96, -152},
    { 1192, -80, -72},
    // 17 seconds
    { 840, -208, -64},
    { 1184, -184, 16},
    { 976, -24, -80},
    { 1104, 88, -272},
    { 1288, 64, -336},
    { 1320, 80, -352},
    { 1088, 96, -352},
    { 1056, 176, -368},
    { 1168, 232, -384},
    { 1328, 256, -392},
    { 1104, 352, -456},
    { 1288, 488, -672},
    { 1312, 536, -632},
    { 1128, 600, -472},
    { 1336, 552, -456},
    { 1080, 408, -432},
    { 1128, 360, -432},
    { 1224, 392, -344},
    { 1296, 344, -248},
    { 1272, 168, -104},
    { 1248, 160, -40},
    { 1312, 184, -200},
    { 1232, 200, -192},
    { 1072, 176, -192},
    { 1160, 16, -8},
    // 18 seconds
    { 896, -176, 48},
    { 1048, -192, 56},
    { 1192, -96, 96},
    { 1152, 64, -224},
    { 1296, 144, -264},
    { 1256, 128, -304},
    { 1232, 152, -376},
    { 1080, 264, -376},
    { 1048, 256, -408},
    { 1168, 264, -376},
    { 1152, 280, -408},
    { 1096, 224, -432},
    { 1384, 368, -440},
    { 1168, 520, -488},
    { 1304, 480, -592},
    { 1080, 392, -520},
    { 1000, 296, -472},
    { 1128, 312, -464},
    { 1272, 280, -376},
    { 1192, 264, -216},
    { 1136, 168, -144},
    { 1184, 240, -184},
    { 1240, 216, -176},
    { 1216, 176, -96},
    { 1216, 64, -120},
    // 19 seconds
    { 1272, -144, -224},
    { 1056, -264, -72},
    { 1168, 48, -72},
    { 944, 64, -216},
    { 864, 64, -336},
    { 1208, 56, -400},
    { 1272, 56, -376},
    { 1072, 152, -296},
    { 936, 360, -384},
    { 960, 280, -352},
    { 1072, 256, -336},
    { 1072, 264, -336},
    { 1280, 360, -384},
    { 1312, 504, -464},
    { 992, 568, -440},
    { 1448, 608, -576},
    { 1208, 488, -528},
    { 1072, 392, -504},
    { 1176, 352, -448},
    { 1272, 288, -328},
    { 1152, 224, -256},
    { 1184, 160, -176},
    { 1376, 200, -224},
    { 1312, 192, -208},
    { 1112, 96, -208},
    // 20 seconds
    { 1080, 56, -256},
    { 1104, -112, -128},
    { 920, -152, -192},
    { 1168, -16, 16},
    { 1136, 72, -272},
    { 1264, 168, -240},
    { 1280, 168, -392},
    { 1024, 104, -400},
    { 832, 128, -352},
    { 848, 168, -296},
    { 1160, 240, -408},
    { 1312, 392, -448},
    { 1240, 576, -536},
    { 1432, 592, -664},
    { 1128, 632, -512},
    { 1152, 552, -480},
    { 1272, 560, -456},
    { 1160, 472, -504},
    { 1208, 416, -384},
    { 1280, 328, -168},
    { 1280, 264, -216},
    { 1192, 200, -136},
    { 1280, 96, -104},
    { 1368, 88, -272},
    { 1160, 200, -248},
    // 21 seconds
    { 1048, 64, -136},
    { 1064, -184, -24},
    { 832, -232, -56},
    { 960, -184, -40},
    { 1112, -112, 48},
    { 1128, 96, -200},
    { 1320, 120, -144},
    { 1336, 120, -152},
    { 1216, 168, -240},
    { 1072, 184, -232},
    { 1144, 224, -248},
    { 1344, 224, -248},
    { 1248, 240, -336},
    { 944, 312, -504},
    { 1416, 488, -576},
    { 1152, 504, -440},
    { 1552, 584, -488},
    { 1320, 488, -440},
    { 1048, 368, -384},
    { 1104, 312, -328},
    { 1240, 264, -256},
    { 1208, 304, -240},
    { 1232, 240, -168},
    { 1328, 192, -88},
    { 1320, 200, -104},
    // 22 seconds
    { 1096, 96, -40},
    { 1024, 72, -128},
    { 1152, -56, -120},
    { 912, -136, -56},
    { 1248, 32, -48},
    { 1128, 32, -248},
    { 1184, 144, -288},
    { 1192, 104, -296},
    { 1072, 152, -336},
    { 912, 184, -320},
    { 944, 216, -264},
    { 1136, 264, -288},
    { 1296, 352, -352},
    { 1176, 544, -432},
    { 1472, 648, -712},
    { 1168, 592, -432},
    { 1392, 544, -328},
    { 1280, 520, -312},
    { 952, 536, -360},
    { 1000, 408, -240},
    { 1184, 376, -176},
    { 1224, 248, -144},
    { 1176, 208, -192},
    { 1264, 208, -280},
    { 1280, 184, -264},
    // 23 seconds
    { 1184, 128, -272},
    { 1056, 64, -264},
    { 1200, -8, -296},
    { 912, -136, -288},
    { 1056, -40, -152},
    { 840, 56, -192},
    { 872, 176, -280},
    { 1128, 216, -336},
    { 1248, 216, -352},
    { 1040, 264, -336},
    { 960, 240, -344},
    { 1096, 272, -264},
    { 1264, 296, -320},
    { 1160, 440, -400},
    { 1128, 560, -368},
    { 1368, 632, -552},
    { 1080, 640, -448},
    { 1344, 648, -416},
    { 1032, 496, -384},
    { 1136, 416, -344},
    { 1200, 376, -280},
    { 1192, 272, -208},
    { 1056, 216, -160},
    { 1096, 224, -160},
    { 1304, 216, -216},
    // 24 seconds
    { 1288, 200, -144},
    { 1088, 104, -216},
    { 1160, 32, -304},
    { 944, -120, -168},
    { 1040, -96, -136},
    { 1152, -32, -88},
    { 1088, 136, -272},
    { 1216, 120, -272},
    { 1200, 136, -352},
    { 936, 152, -320},
    { 808, 160, -328},
    { 992, 232, -312},
    { 1168, 216, -296},
    { 1232, 256, -328},
    { 1256, 344, -360},
    { 1536, 656, -504},
    { 1136, 784, -632},
    { 1440, 712, -552},
    { 1120, 520, -512},
    { 1024, 432, -496},
    { 1160, 424, -416},
    { 1336, 352, -256},
    { 1240, 288, -184},
    { 1232, 256, -192},
    { 1328, 184, -168},
    // 25 seconds
    { 1376, 104, -160},
    { 1256, 112, -200},
    { 1064, 40, -224},
    { 1064, -160, -224},
    { 832, -224, -280},
    { 1168, -192, -192},
    { 1104, -80, -320},
    { 1200, 0, -360},
    { 1224, 56, -352},
    { 1080, 120, -320},
    { 920, 168, -304},
    { 936, 296, -240},
    { 1208, 296, -176},
    { 1336, 408, -264},
    { 1264, 552, -328},
    { 1496, 824, -656},
    { 1192, 832, -616},
    { 1168, 736, -504},
    { 1120, 656, -416},
    { 864, 592, -480},
    { 1032, 520, -384},
    { 1272, 456, -312},
    { 1368, 400, -232},
    { 1184, 256, -200},
    { 1160, 216, -160},
    // 26 seconds
    { 1272, 216, -208},
    { 1272, 168, -216},
    { 1192, 144, -256},
    { 1368, 192, -368},
    { 1120, -56, -408},
    { 1008, -240, -160},
    { 952, -184, -184},
    { 912, -48, -248},
    { 1168, 96, -352},
    { 1184, 56, -304},
    { 1056, 104, -312},
    { 904, 192, -320},
    { 1000, 264, -288},
    { 1224, 232, -328},
    { 1320, 296, -352},
    { 1352, 376, -464},
    { 1520, 584, -432},
    { 1192, 936, -568},
    { 1296, 624, -384},
    { 1136, 624, -440},
    { 1032, 464, -376},
    { 1104, 416, -376},
    { 1200, 376, -264},
    { 1080, 304, -232},
    { 1064, 200, -200},
    // 27 seconds
    { 1248, 216, -184},
    { 1352, 192, -200},
    { 1304, 144, -200},
    { 1192, 112, -272},
    { 1248, -32, -200},
    { 880, -208, -168},
    { 1192, -112, -144},
    { 992, -72, -80},
    { 936, 72, -272},
    { 1088, 64, -328},
    { 1104, 104, -352},
    { 984, 96, -320},
    { 992, 136, -328},
    { 1208, 208, -352},
    { 1384, 248, -392},
    { 1264, 320, -504},
    { 1240, 480, -720},
    { 1304, 608, -608},
    { 1024, 416, -464},
    { 1384, 656, -544},
    { 1080, 400, -392},
    { 1232, 408, -344},
    { 1296, 304, -248},
    { 1200, 232, -224},
    { 1040, 160, -184},
    // 28 seconds
    { 1144, 184, -200},
    { 1280, 192, -184},
    { 1136, 184, -152},
    { 1120, 128, -192},
    { 1224, 32, -136},
    { 880, -144, -80},
    { 976, -96, -160},
    { 1064, -32, -40},
    { 1264, 80, -336},
    { 1280, 16, -272},
    { 1224, 48, -392},
    { 896, 96, -368},
    { 792, 72, -344},
    { 992, 160, -328},
    { 1208, 176, -344},
    { 1224, 256, -376},
    { 1360, 416, -264},
    { 1352, 896, -392},
    { 1144, 440, -480},
    { 1312, 600, -376},
    { 992, 408, -440},
    { 976, 440, -456},
    { 1064, 408, -392},
    { 1112, 312, -256},
    { 1136, 112, -136},
    // 29 seconds
    { 1216, 200, -168},
    { 1344, 160, -264},
    { 1352, 144, -224},
    { 1136, 104, -272},
    { 1200, -16, -288},
    { 1016, -96, -264},
    { 1200, -128, -224},
    { 1120, -96, -120},
    { 1144, 56, -272},
    { 1160, 88, -312},
    { 1096, 112, -392},
    { 912, 88, -456},
    { 856, 192, -360},
    { 888, 176, -328},
    { 1064, 336, -360},
    { 1160, 392, -376},
    { 1264, 392, -400},
    { 1496, 576, -512},
    { 1208, 568, -448},
    { 1328, 616, -472},
    { 1152, 608, -488},
    { 984, 464, -544},
    { 1160, 408, -456},
    { 1352, 352, -336},
    { 1272, 320, -264},
    // 30 seconds
    { 1184, 152, -144},
    { 1224, 224, -200},
    { 1312, 216, -200},
    { 1296, 152, -200},
    { 1160, 136, -232},
    { 1152, 0, -200},
    { 888, -56, -200},
    { 896, -88, -288},
    { 1072, -48, -152},
    { 1064, 48, -344},
    { 1128, 64, -392},
    { 1200, 64, -416},
    { 1104, 176, -368},
    { 976, 168, -296},
    { 1080, 304, -392},
    { 1320, 352, -328},
    { 1336, 400, -472},
    { 1056, 624, -736},
    { 1224, 752, -960},
    { 1168, 720, -624},
    { 1272, 632, -456},
    { 1272, 528, -456},
    { 1152, 536, -440},
    { 1168, 400, -296},
    { 1320, 448, -280},
    // 31 seconds
    { 1344, 336, -200},
    { 1272, 352, -216},
    { 1312, 296, -168},
    { 1376, 312, -120},
    { 1280, 312, -80},
    { 1248, 224, -64},
    { 1296, 248, -160},
    { 1032, 168, -184},
    { 888, 120, -392},
    { 856, 32, -128},
    { 720, 16, -184},
    { 816, 24, -352},
    { 1000, 0, -448},
    { 1176, -32, -592},
    { 1176, -96, -536},
    { 1168, -40, -632},
    { 1152, -16, -672},
    { 1184, 248, -648},
    { 1104, 184, -744},
    { 1080, 472, -600},
    { 1216, 544, -672},
    { 1080, 544, -504},
    { 1440, 480, -392},
    { 1240, 496, -368},
    { 1088, 368, -336},
    // 32 seconds
    { 1056, 336, -248},
    { 1144, 304, -232},
    { 1072, 280, -208},
    { 1104, 224, -216},
    { 1200, 264, -192},
    { 1272, 200, -112},
    { 1264, 208, -168},
    { 1208, 136, -240},
    { 1120, 96, -352},
    { 944, -32, -368},
    { 872, -96, -320},
    { 952, -104, -256},
    { 824, 0, -344},
    { 1032, 24, -456},
    { 1248, 16, -552},
    { 1136, 56, -488},
    { 1032, 48, -448},
    { 1000, 184, -480},
    { 1080, 280, -576},
    { 1064, 280, -584},
    { 984, 304, -616},
    { 1248, 408, -624},
    { 1160, 488, -512},
    { 1080, 512, -504},
    { 1368, 472, -408},
    // 33 seconds
    { 1200, 464, -432},
    { 1288, 328, -368},
    { 1352, 304, -280},
    { 1184, 208, -224},
    { 1056, 216, -216},
    { 1120, 128, -200},
    { 1168, 152, -224},
    { 1168, 184, -208},
    { 1088, 128, -184},
    { 1184, 104, -296},
    { 952, 112, -280},
    { 984, 56, -304},
    { 1024, -64, -128},
    { 944, 32, -288},
    { 1104, 96, -376},
    { 1344, 104, -464},
    { 1128, 104, -488},
    { 872, 136, -336},
    { 904, 280, -432},
    { 1080, 232, -464},
    { 1248, 288, -480},
    { 1160, 368, -432},
    { 1456, 600, -520},
    { 1240, 632, -472},
    { 1144, 688, -448},
    // 34 seconds
    { 1296, 632, -384},
    { 1016, 488, -480},
    { 1184, 392, -384},
    { 1288, 336, -288},
    { 1224, 264, -224},
    { 1120, 224, -200},
    { 1184, 168, -224},
    { 1232, 168, -264},
    { 1160, 160, -240},
    { 1016, 96, -248},
    { 1096, 88, -456},
    { 848, 80, -400},
    { 856, -120, -312},
    { 1120, -16, -104},
    { 1104, 80, -288},
    { 1208, 184, -296},
    { 1272, 128, -488},
    { 1064, 144, -312},
    { 896, 144, -304},
    { 1024, 312, -368},
    { 1232, 304, -384},
    { 1264, 280, -368},
    { 1208, 512, -472},
    { 1368, 816, -704},
    { 1000, 584, -488},
    // 35 seconds
    { 1416, 608, -448},
    { 1176, 592, -528},
    { 1184, 464, -464},
    { 1296, 400, -304},
    { 1368, 328, -272},
    { 1152, 272, -200},
    { 1152, 200, -176},
    { 1280, 168, -152},
    { 1296, 160, -176},
    { 1184, 192, -240},
    { 1112, 72, -248},
    { 1048, -72, -184},
    { 792, -248, -272},
    { 1264, -112, -96},
    { 1192, -88, -288},
    { 1264, 72, -352},
    { 1232, 80, -416},
    { 1008, 80, -384},
    { 864, 136, -296},
    { 1000, 224, -288},
    { 1240, 304, -304},
    { 1376, 512, -344},
    { 1248, 840, -392},
    { 1424, 920, -776},
    { 1080, 776, -464},
    // 36 seconds
    { 1320, 624, -280},
    { 1232, 648, -456},
    { 1096, 536, -472},
    { 1240, 456, -328},
    { 1384, 344, -272},
    { 1296, 272, -232},
    { 1184, 208, -272},
    { 1224, 208, -256},
    { 1264, 224, -256},
    { 1160, 136, -208},
    { 1120, 152, -240},
    { 1208, 96, -352},
    { 856, -112, -168},
    { 1128, -80, -224},
    { 1088, -48, -176},
    { 1240, 120, -312},
    { 1384, 168, -360},
    { 1368, 200, -448},
    { 992, 184, -344},
    { 832, 280, -384},
    { 928, 280, -424},
    { 1112, 296, -464},
    { 1080, 344, -464},
    { 1256, 464, -456},
    { 1232, 704, -536},
    // 37 seconds
    { 1192, 616, -424},
    { 1320, 568, -432},
    { 1208, 448, -432},
    { 1208, 424, -424},
    { 1200, 336, -304},
    { 1072, 240, -280},
    { 960, 240, -264},
    { 1048, 192, -240},
    { 1208, 184, -256},
    { 1232, 152, -240},
    { 1200, 104, -264},
    { 1344, 16, -360},
    { 944, -168, -144},
    { 1144, -128, -176},
    { 1080, -64, -152},
    { 1160, 112, -336},
    { 1272, 104, -392},
    { 1240, 120, -448},
    { 904, 104, -360},
    { 728, 216, -344},
    { 856, 280, -392},
    { 1040, 336, -440},
    { 1136, 392, -408},
    { 1408, 544, -552},
    { 1416, 616, -488},
    // 38 seconds
    { 1120, 608, -560},
    { 1256, 712, -496},
    { 1200, 504, -504},
    { 1272, 424, -464},
    { 1344, 328, -392},
    { 1328, 272, -256},
    { 1168, 208, -216},
    { 1136, 192, -152},
    { 1224, 128, -200},
    { 1184, 160, -184},
    { 1080, 104, -232},
    { 1144, -24, -128},
    { 864, -72, -152},
    { 952, 64, -192},
    { 1024, 112, -48},
    { 1048, 144, -296},
    { 1240, 104, -344},
    { 1480, 16, -360},
    { 1232, 104, -392},
    { 928, 168, -456},
    { 976, 256, -448},
    { 1184, 208, -424},
    { 1240, 288, -392},
    { 1200, 416, -424},
    { 1472, 608, -568},
    // 39 seconds
    { 1016, 712, -384},
    { 1440, 568, -456},
    { 1232, 472, -464},
    { 1248, 392, -432},
    { 1344, 360, -400},
    { 1424, 288, -264},
    { 1176, 176, -176},
    { 1056, 216, -216},
    { 1192, 168, -208},
    { 1256, 128, -152},
    { 1192, 184, -216},
    { 1200, 56, -256},
    { 1024, -64, -168},
    { 768, -128, -264},
    { 1016, -16, -104},
    { 1080, 48, -272},
    { 1296, 144, -376},
    { 1416, 112, -392},
    { 1232, 144, -456},
    { 944, 88, -384},
    { 992, 248, -400},
    { 1128, 272, -360},
    { 1264, 304, -320},
    { 1272, 472, -416},
    { 1544, 496, -536},
    // 40 seconds
    { 1176, 720, -392},
    { 1144, 624, -536},
    { 1208, 696, -416},
    { 1024, 480, -456},
    { 1168, 440, -416},
    { 1312, 360, -288},
    { 1184, 312, -224},
    { 1088, 256, -200},
    { 1192, 256, -192},
    { 1368, 272, -152},
    { 1400, 200, -152},
    { 1296, 96, -224},
    { 1296, 112, -248},
    { 1008, -56, -176},
    { 864, -112, -344},
    { 1016, -96, -152},
    { 928, -16, -280},
    { 1080, 48, -352},
    { 1200, 96, -392},
    { 1016, 176, -448},
    { 928, 224, -344},
    { 1072, 288, -320},
    { 1256, 336, -344},
    { 1264, 400, -384},
    { 1288, 592, -352},
    // 41 seconds
    { 1360, 840, -352},
    { 1112, 792, -472},
    { 1256, 800, -432},
    { 1064, 672, -440},
    { 1064, 616, -400},
    { 1112, 528, -360},
    { 1208, 480, -360},
    { 1088, 352, -176},
    { 1072, 312, -152},
    { 1296, 256, -224},
    { 1360, 208, -160},
    { 1264, 168, -176},
    { 1312, 176, -288},
    { 1136, 88, -344},
    { 848, -40, -304},
    { 1064, -96, -160},
    { 984, -32, -184},
    { 1072, 88, -328},
    { 1152, 168, -360},
    { 1080, 232, -424},
    { 920, 160, -328},
    { 976, 304, -352},
    { 1088, 296, -336},
    { 1248, 320, -376},
    { 1200, 384, -432},
    // 42 seconds
    { 1416, 696, -712},
    { 1208, 720, -560},
    { 1272, 592, -672},
    { 1216, 656, -584},
    { 1024, 488, -552},
    { 1088, 368, -456},
    { 1240, 320, -360},
    { 1200, 256, -312},
    { 1096, 224, -280},
    { 1184, 224, -264},
    { 1320, 192, -288},
    { 1216, 80, -216},
    { 1168, -24, -200},
    { 1208, -112, -176},
    { 848, -176, -152},
    { 1176, -80, -24},
    { 1168, 80, -136},
    { 1200, 48, -232},
    { 1288, 144, -304},
    { 1160, 160, -368},
    { 928, 120, -320},
    { 840, 168, -344},
    { 936, 152, -392},
    { 1112, 256, -440},
    { 1224, 288, -416},
    // 43 seconds
    { 1520, 408, -416},
    { 1392, 704, -528},
    { 1080, 400, -520},
    { 1224, 584, -496},
    { 1008, 416, -400},
    { 1168, 392, -384},
    { 1280, 344, -304},
    { 1208, 288, -240},
    { 1096, 184, -240},
    { 1192, 176, -240},
    { 1352, 168, -216},
    { 1232, 0, -120},
    { 1168, 8, -216},
    { 1184, -96, -264},
    { 872, -192, -216},
    { 848, -96, -192},
    { 1200, 80, -64},
    { 1248, 136, -272},
    { 1296, 168, -248},
    { 1272, 144, -376},
    { 944, 160, -280},
    { 848, 192, -296},
    { 960, 264, -312},
    { 1168, 272, -352},
    { 1240, 344, -352},
    // 44 seconds
    { 1408, 552, -536},
    { 1328, 944, -712},
    { 1184, 224, -528},
    { 1288, 624, -560},
    { 1096, 448, -456},
    { 1136, 376, -392},
    { 1224, 312, -344},
    { 1120, 240, -288},
    { 1024, 184, -240},
    { 1080, 200, -248},
    { 1248, 192, -216},
    { 1208, 104, -112},
    { 1136, 72, -240},
    { 1232, -32, -256},
    { 888, -152, -256},
    { 1208, -96, -120},
    { 1128, -72, -176},
    { 1232, 64, -288},
    { 1296, 56, -336},
    { 1096, 128, -376},
    { 784, 96, -336},
    { 744, 160, -336},
    { 968, 208, -328},
    { 1192, 288, -408},
    { 1208, 328, -432},
    // 45 seconds
    { 1376, 760, -368},
    { 1192, 672, -760},
    { 1208, 712, -696},
    { 1336, 552, -440},
    { 1128, 504, -488},
    { 1248, 400, -416},
    { 1312, 376, -320},
    { 1168, 280, -232},
    { 1000, 208, -192},
    { 1040, 272, -200},
    { 1248, 216, -208},
    { 1264, 152, -120},
    { 1152, 120, -200},
    { 1200, 80, -208},
    { 864, -104, -120},
    { 1008, -32, -352},
    { 1136, 8, -208},
    { 1184, 56, -368},
    { 1320, 104, -384},
    { 1208, 128, -464},
    { 848, 152, -392},
    { 744, 192, -352},
    { 912, 248, -432},
    { 1176, 320, -392},
    { 1264, 496, -400},
    // 46 seconds
    { 1448, 784, -544},
    { 1296, 728, -544},
    { 952, 688, -536},
    { 1248, 608, -376},
    { 1080, 544, -432},
    { 1208, 480, -416},
    { 1360, 432, -304},
    { 1432, 336, -248},
    { 1216, 320, -240},
    { 1160, 232, -232},
    { 1280, 280, -256},
    { 1168, 152, -144},
    { 1032, 136, -272},
    { 1016, 48, -248},
    { 984, -40, -216},
    { 744, -136, -280},
    { 1208, -64, -144},
    { 1192, 56, -304},
    { 1368, 128, -368},
    { 1400, 136, -400},
    { 1128, 176, -352},
    { 896, 208, -336},
    { 936, 304, -320},
    { 1144, 312, -296},
    { 1296, 360, -376},
    // 47 seconds
    { 1184, 568, -536},
    { 1328, 624, -696},
    { 1144, 720, -504},
    { 1400, 744, -488},
    { 1200, 584, -424},
    { 1144, 552, -512},
    { 1128, 448, -376},
    { 1248, 360, -352},
    { 1160, 264, -264},
    { 1104, 216, -224},
    { 1160, 200, -280},
    { 1320, 240, -280},
    { 1280, 160, -240},
    { 1168, 104, -248},
    { 1136, 24, -208},
    { 888, -200, -200},
    { 1184, -16, -16},
    { 1208, 40, -336},
    { 1264, 136, -336},
    { 1288, 192, -400},
    { 1048, 256, -344},
    { 832, 200, -360},
    { 784, 248, -320},
    { 1000, 320, -376},
    { 1264, 408, -408},
    // 48 seconds
    { 1248, 424, -408},
    { 1208, 688, -304},
    { 1192, 752, -496},
    { 1104, 640, -528},
    { 1248, 592, -384},
    { 1072, 552, -416},
    { 1120, 448, -384},
    { 1160, 392, -392},
    { 1136, 280, -360},
    { 984, 280, -216},
    { 1032, 152, -200},
    { 1152, 208, -192},
    { 1192, 192, -224},
    { 1088, 128, -248},
    { 1224, 56, -280},
    { 1040, -56, -184},
    { 1072, -72, -224},
    { 1120, 0, -128},
    { 1024, 88, -368},
    { 1176, 112, -448},
    { 1208, 104, -448},
    { 856, 88, -416},
    { 680, 152, -400},
    { 768, 208, -408},
    { 976, 232, -384},
    // 49 seconds
    { 1088, 304, -384},
    { 1312, 392, -408},
    { 1472, 640, -336},
    { 1024, 616, -560},
    { 1416, 768, -472},
    { 1136, 512, -400},
    { 1136, 392, -456},
    { 1152, 320, -528},
    { 1192, 304, -536},
    { 1048, 200, -264},
    { 1008, 152, -128},
    { 1240, 200, -232},
    { 1264, 176, -264},
    { 1128, 176, -208},
    { 1200, 112, -280},
    { 1080, 56, -216},
    { 784, -64, -240},
    { 1128, -8, -120},
    { 1024, 8, -248},
    { 1096, 104, -344},
    { 1368, 112, -488},
    { 1216, 144, -400},
    { 904, 176, -376},
    { 832, 248, -360},
    { 1008, 312, -368},
    // 50 seconds
    { 1168, 320, -360},
    { 1152, 376, -344},
    { 1280, 472, -352},
    { 1272, 688, -312},
    { 856, 504, -408},
    { 1384, 648, -488},
    { 1096, 448, -384},
    { 1040, 400, -448},
    { 1264, 376, -440},
    { 1384, 360, -360},
    { 1240, 328, -280},
    { 1200, 368, -256},
    { 1272, 384, -184},
    { 1272, 464, -216},
    { 1152, 512, -136},
    { 1088, 576, -296},
    { 1104, 608, -288},
    { 1056, 712, -368},
    { 744, 608, -544},
    { 616, 472, -456},
    { 400, 616, -568},
    { 136, 568, -568},
    { 184, 592, -720},
    { 200, 656, -728},
    { 168, 880, -688},
    // 51 seconds
    { 144, 872, -528},
    { 32, 896, -368},
    { -24, 968, -280},
    { -96, 976, -192},
    { -120, 1008, -56},
    { -128, 920, -72},
    { -152, 952, 80},
    { -152, 1080, 128},
    { -152, 1128, 184},
    { -192, 1032, 200},
    { -208, 1072, 192},
    { -216, 984, 128},
    { -216, 936, -8},
    { -160, 944, -136},
    { -240, 808, 48},
    { -296, 1160, -376},
    { -352, 752, -128},
    { -360, 1040, -272},
    { -344, 1072, -288},
    { -360, 1160, -256},
    { -328, 1008, -392},
    { -344, 944, -312},
    { -464, 960, -432},
    { -408, 448, -432},
    { -336, 416, -672},
    // 52 seconds
    { -272, 680, -904},
    { -128, 336, -1040},
    { -168, 176, -1104},
    { -112, 16, -960},
    { -152, -144, -920},
    { -32, -240, -872},
    { -24, -152, -992},
    { 200, -440, -1000},
    { -200, -200, -1192},
    { -144, 24, -1144},
    { -168, -104, -1056},
    { -104, -136, -928},
    { 48, -320, -984},
    { -176, 24, -944},
    { 312, -216, -1016},
    { -24, -224, -1064},
    { 48, -256, -1064},
    { -16, -336, -1016},
    { 56, -280, -984},
    { 192, -504, -1000},
    { 16, -384, -896},
    { -112, -224, -1000},
    { -136, -336, -920},
    { -32, -312, -920},
    { 40, -208, -984},
    // 53 seconds
    { 16, -48, -992},
    { 16, 232, -1016},
    { -8, 240, -1032},
    { 24, -120, -856},
    { -24, -176, -1056},
    { 40, -440, -1056},
    { -24, -352, -1088},
    { -16, -528, -936},
    { -104, -416, -1048},
    { -88, -288, -1096},
    { 56, -112, -1184},
    { -152, -8, -1072},
    { -120, 64, -1016},
    { -296, 56, -992},
    { -232, 80, -912},
    { -304, 8, -904},
    { -256, 0, -912},
    { -232, 40, -936},
    { -272, 0, -960},
    { -280, -8, -968},
    { -304, -24, -992},
    { -288, -32, -960},
    { -280, -104, -984},
    { -296, -88, -960},
    { -280, -128, -976},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 12:37:54 local
AccelRawData *activity_sample_walk_100_pbl_28397_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28397_10
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -96, 304, -1064},
    { -40, 192, -1032},
    { 32, 112, -1128},
    { 48, 56, -1112},
    { 152, 560, -1200},
    { 96, 72, -1136},
    { 32, -24, -1088},
    { 16, -48, -1000},
    { 8, -8, -1040},
    { -32, 24, -1032},
    { -24, 96, -1040},
    { -24, 40, -1040},
    { -16, 40, -1032},
    { -24, 88, -1048},
    { -8, 64, -1064},
    { -64, 24, -1016},
    { 24, 40, -1024},
    { 0, 40, -1024},
    { -56, 8, -984},
    { -80, 0, -1056},
    { -96, -8, -984},
    { -72, 24, -1048},
    { -96, 32, -1024},
    { -80, 16, -1064},
    { -96, 40, -1080},
    // 1 seconds
    { -88, -40, -1048},
    { -168, 32, -960},
    { -96, 48, -1024},
    { -24, 80, -1056},
    { -32, 104, -1016},
    { -24, 72, -960},
    { 88, -256, -912},
    { 96, -8, -968},
    { 24, -48, -968},
    { 48, -16, -1080},
    { 24, 72, -1112},
    { 16, 40, -1128},
    { 48, 24, -1088},
    { 40, 16, -1064},
    { 40, 16, -1048},
    { 32, 32, -1024},
    { 24, 64, -1040},
    { 24, 40, -1032},
    { 32, 40, -1008},
    { 16, 40, -1008},
    { 24, 32, -1024},
    { 16, 32, -1032},
    { 32, 16, -1048},
    { 24, 32, -1040},
    { 32, 24, -1024},
    // 2 seconds
    { 48, 8, -1032},
    { 32, 0, -1024},
    { 40, 0, -1008},
    { 40, 16, -1000},
    { 64, 16, -1000},
    { 96, 16, -960},
    { 64, 152, -920},
    { 8, 192, -912},
    { -40, 312, -880},
    { -104, 408, -904},
    { -80, 352, -872},
    { -88, 496, -888},
    { -88, 672, -904},
    { -128, 592, -928},
    { -128, 600, -920},
    { -136, 648, -984},
    { -96, 536, -1000},
    { -32, 488, -1040},
    { 40, 416, -1008},
    { 168, 416, -960},
    { 296, 328, -840},
    { 392, 296, -736},
    { 544, 248, -680},
    { 792, 288, -528},
    { 1176, 384, -280},
    // 3 seconds
    { 1384, 368, -160},
    { 1608, 408, -144},
    { 1536, 456, -232},
    { 1336, 312, -200},
    { 1104, 296, -232},
    { 960, 296, -360},
    { 944, 248, -272},
    { 1024, 304, -280},
    { 1032, 368, -336},
    { 928, 344, -464},
    { 952, 392, -560},
    { 1088, 496, -496},
    { 1520, 592, -464},
    { 1256, 560, -360},
    { 1152, 624, -400},
    { 984, 640, -368},
    { 864, 528, -320},
    { 1088, 480, -240},
    { 1328, 416, -168},
    { 1496, 312, -96},
    { 1368, 336, -112},
    { 1464, 384, -112},
    { 1544, 216, -64},
    { 1440, 200, 64},
    { 1248, 224, -24},
    // 4 seconds
    { 1160, 8, -24},
    { 880, -216, 40},
    { 824, -248, -88},
    { 984, -232, -112},
    { 1000, -232, -520},
    { 1200, -176, -656},
    { 1144, -336, -712},
    { 984, -440, -712},
    { 816, -392, -1008},
    { 720, -440, -904},
    { 816, 16, -1160},
    { 648, 880, -1120},
    { 664, 1224, -816},
    { 912, 1600, -296},
    { 616, 1080, 136},
    { 728, 1200, -8},
    { 536, 832, -128},
    { 328, 984, -112},
    { 360, 808, -216},
    { 224, 832, -160},
    { 104, 784, -80},
    { -24, 992, -208},
    { -16, 1088, -80},
    { -64, 880, -152},
    { -32, 1080, -216},
    // 5 seconds
    { -32, 1096, -160},
    { 64, 992, -64},
    { -32, 1112, -288},
    { 240, 656, -128},
    { 320, 984, -72},
    { 448, 736, 112},
    { 320, 1024, 136},
    { 24, 944, 160},
    { -56, 920, -144},
    { -248, 928, 24},
    { -288, 888, 120},
    { -400, 856, 160},
    { -536, 888, -24},
    { -656, 936, 312},
    { -752, 952, 376},
    { -864, 1032, 360},
    { -600, 1120, 416},
    { -448, 1248, 248},
    { -320, 1304, -40},
    { -216, 1056, -184},
    { -152, 776, -768},
    { -64, 432, -704},
    { 16, 280, -392},
    { 160, -80, -536},
    { 320, 152, -624},
    // 6 seconds
    { 616, -136, -440},
    { 1048, -176, -456},
    { 1144, -184, -360},
    { 1512, 176, -176},
    { 1680, 304, -160},
    { 1936, 432, -352},
    { 2016, 336, -384},
    { 1632, 328, -320},
    { 1096, 312, -328},
    { 1024, 312, -392},
    { 1128, 160, -352},
    { 1160, 136, -384},
    { 1160, 344, -432},
    { 1568, 656, -560},
    { 1264, 920, -808},
    { 1128, 840, -744},
    { 1152, 488, -496},
    { 1248, 432, -568},
    { 1432, 384, -536},
    { 1608, 376, -392},
    { 1792, 312, -160},
    { 1640, 96, -72},
    { 1496, 216, -200},
    { 1496, 152, -144},
    { 1336, 152, -128},
    // 7 seconds
    { 1200, 56, -176},
    { 1144, 8, -152},
    { 808, -152, -128},
    { 728, -208, -160},
    { 816, -136, -8},
    { 984, 56, -272},
    { 1232, 40, -232},
    { 1528, 96, -376},
    { 1280, 160, -232},
    { 1152, 224, -328},
    { 1184, 264, -336},
    { 1392, 280, -312},
    { 1568, 304, -424},
    { 1776, 344, -424},
    { 1664, 728, -520},
    { 984, 704, -576},
    { 1256, 736, -736},
    { 1096, 560, -560},
    { 1232, 440, -480},
    { 1360, 400, -416},
    { 1400, 320, -312},
    { 1208, 200, -160},
    { 1176, 0, -32},
    { 1368, 272, -192},
    { 1392, 216, -184},
    // 8 seconds
    { 1384, 152, -152},
    { 1440, 176, -176},
    { 1064, -64, -96},
    { 1096, -64, 64},
    { 952, -192, -24},
    { 1104, 32, -104},
    { 1248, 40, -280},
    { 1184, 96, -312},
    { 928, 40, -296},
    { 816, 144, -328},
    { 1000, 168, -320},
    { 1264, 288, -320},
    { 1376, 312, -344},
    { 1488, 424, -480},
    { 1568, 632, -848},
    { 1128, 624, -600},
    { 1544, 512, -440},
    { 1096, 512, -536},
    { 1144, 400, -464},
    { 1208, 320, -368},
    { 1256, 240, -248},
    { 1136, 256, -224},
    { 1104, 232, -160},
    { 1168, 200, -152},
    { 1184, 224, -144},
    // 9 seconds
    { 1128, 200, -152},
    { 1304, 144, -200},
    { 1016, 88, -160},
    { 776, 32, -280},
    { 1128, -40, -16},
    { 1072, 72, -200},
    { 1120, 152, -264},
    { 1440, 72, -472},
    { 1112, 168, -384},
    { 752, 64, -360},
    { 792, 224, -392},
    { 1072, 280, -424},
    { 1216, 232, -400},
    { 1272, 336, -368},
    { 1608, 600, -520},
    { 1224, 552, -504},
    { 1336, 672, -408},
    { 1192, 632, -432},
    { 1096, 472, -392},
    { 1208, 416, -360},
    { 1240, 336, -232},
    { 968, 248, -200},
    { 944, 168, -192},
    { 1144, 200, -232},
    { 1296, 152, -256},
    // 10 seconds
    { 1136, 128, -320},
    { 1264, 32, -368},
    { 1152, -128, -152},
    { 760, -176, -208},
    { 1096, -48, -24},
    { 1160, 48, -200},
    { 1400, 176, -272},
    { 1480, 112, -328},
    { 1152, 152, -320},
    { 808, 216, -352},
    { 816, 232, -344},
    { 1008, 224, -352},
    { 1152, 280, -456},
    { 1208, 424, -608},
    { 1600, 560, -760},
    { 1144, 672, -528},
    { 1504, 752, -320},
    { 1208, 544, -456},
    { 1296, 504, -384},
    { 1344, 400, -296},
    { 1392, 320, -176},
    { 1232, 264, -144},
    { 1096, 208, -176},
    { 1256, 240, -224},
    { 1352, 152, -224},
    // 11 seconds
    { 1280, 96, -264},
    { 1408, 16, -328},
    { 1000, -328, -56},
    { 792, -280, -144},
    { 952, -160, 48},
    { 1168, 64, -256},
    { 1448, 120, -256},
    { 1528, 160, -296},
    { 1200, 232, -296},
    { 920, 272, -296},
    { 952, 296, -312},
    { 1152, 248, -288},
    { 1256, 224, -336},
    { 1288, 344, -560},
    { 1520, 648, -656},
    { 1032, 576, -608},
    { 1504, 544, -408},
    { 1264, 640, -448},
    { 1344, 416, -320},
    { 1240, 424, -320},
    { 1216, 312, -192},
    { 1016, 224, -136},
    { 1008, 120, -112},
    { 1184, 200, -192},
    { 1400, 160, -168},
    // 12 seconds
    { 1320, 144, -200},
    { 1456, 8, -208},
    { 1072, -208, -72},
    { 904, -96, -200},
    { 976, -32, -48},
    { 1048, 96, -200},
    { 1272, 88, -304},
    { 1376, 104, -344},
    { 1096, 128, -352},
    { 728, 144, -288},
    { 760, 176, -312},
    { 1016, 224, -312},
    { 1176, 248, -336},
    { 1232, 288, -328},
    { 1640, 496, -496},
    { 1336, 680, -624},
    { 1464, 568, -480},
    { 1328, 464, -464},
    { 1160, 368, -448},
    { 1200, 360, -392},
    { 1344, 280, -288},
    { 1184, 200, -104},
    { 1032, 112, -64},
    { 1056, 192, -160},
    { 1256, 200, -152},
    // 13 seconds
    { 1240, 184, -136},
    { 1184, 168, -176},
    { 1168, 48, -120},
    { 824, -48, -160},
    { 928, -24, -104},
    { 888, 56, -160},
    { 1160, 128, -280},
    { 1560, 64, -344},
    { 1496, 152, -336},
    { 968, 144, -336},
    { 664, 248, -456},
    { 760, 104, -408},
    { 968, 0, -376},
    { 1048, 56, -360},
    { 1208, 88, -352},
    { 1672, 392, -416},
    { 1232, 552, -440},
    { 1176, 448, -504},
    { 1184, 464, -384},
    { 1192, 344, -392},
    { 1144, 352, -384},
    { 1112, 304, -344},
    { 944, 256, -256},
    { 872, -16, -168},
    { 992, 72, -208},
    // 14 seconds
    { 1192, 120, -264},
    { 1208, 136, -312},
    { 1304, 88, -384},
    { 1344, 72, -408},
    { 880, -72, -208},
    { 1152, -240, -144},
    { 1088, -88, -160},
    { 1264, -8, -240},
    { 1288, 56, -264},
    { 1000, 8, -288},
    { 672, 176, -416},
    { 624, 216, -336},
    { 904, 224, -392},
    { 1216, 240, -328},
    { 1488, 344, -288},
    { 1688, 600, -488},
    { 1208, 792, -448},
    { 1512, 680, -432},
    { 984, 552, -408},
    { 1104, 504, -432},
    { 1272, 448, -344},
    { 1336, 336, -216},
    { 1064, 280, -176},
    { 936, 200, -112},
    { 1080, 216, -136},
    // 15 seconds
    { 1312, 224, -152},
    { 1336, 136, -192},
    { 1376, 104, -184},
    { 1136, -120, -24},
    { 696, -168, -64},
    { 936, -64, -24},
    { 1056, 80, -120},
    { 1288, 144, -304},
    { 1552, 128, -360},
    { 1320, 120, -336},
    { 896, 208, -344},
    { 768, 296, -400},
    { 976, 272, -416},
    { 1160, 288, -336},
    { 1168, 472, -400},
    { 1416, 528, -408},
    { 1176, 568, -392},
    { 1056, 592, -384},
    { 1104, 608, -408},
    { 1312, 528, -376},
    { 1448, 424, -264},
    { 1392, 328, -184},
    { 1152, 232, -136},
    { 1064, 192, -208},
    { 1128, 168, -184},
    // 16 seconds
    { 1192, 144, -216},
    { 1176, 152, -272},
    { 1312, 16, -296},
    { 920, -96, -208},
    { 752, -184, -312},
    { 1136, -88, -48},
    { 1168, 112, -288},
    { 1336, 120, -272},
    { 1504, 104, -432},
    { 1184, 168, -296},
    { 864, 216, -328},
    { 840, 288, -336},
    { 1096, 296, -312},
    { 1304, 296, -328},
    { 1472, 432, -352},
    { 1600, 640, -544},
    { 984, 624, -560},
    { 1280, 720, -520},
    { 1096, 536, -424},
    { 1328, 488, -392},
    { 1320, 392, -368},
    { 1160, 304, -240},
    { 960, 224, -176},
    { 1048, 144, -152},
    { 1288, 232, -176},
    // 17 seconds
    { 1424, 176, -176},
    { 1328, 128, -192},
    { 1488, 72, -280},
    { 960, -176, -88},
    { 856, -176, -248},
    { 1000, -112, -48},
    { 1048, -24, -304},
    { 1272, 16, -344},
    { 1424, 112, -392},
    { 1128, 264, -424},
    { 856, 104, -296},
    { 944, 336, -344},
    { 1136, 312, -320},
    { 1272, 408, -304},
    { 1344, 584, -360},
    { 1512, 744, -376},
    { 1104, 776, -272},
    { 1448, 744, -296},
    { 1000, 672, -296},
    { 1048, 536, -304},
    { 1160, 520, -280},
    { 1272, 424, -208},
    { 1080, 376, -144},
    { 1072, 216, -104},
    { 1192, 224, -112},
    // 18 seconds
    { 1296, 264, -104},
    { 1176, 192, -24},
    { 1280, 304, -136},
    { 1256, 128, -80},
    { 880, -168, -344},
    { 1272, -144, 96},
    { 1184, -232, -304},
    { 1256, 56, -328},
    { 1296, -16, -408},
    { 1080, 96, -368},
    { 800, 112, -400},
    { 760, 184, -320},
    { 896, 232, -264},
    { 992, 296, -312},
    { 1128, 408, -376},
    { 1408, 656, -512},
    { 1240, 808, -424},
    { 1584, 808, -392},
    { 1288, 640, -344},
    { 1232, 536, -336},
    { 1192, 432, -304},
    { 1184, 408, -304},
    { 968, 304, -296},
    { 888, 248, -200},
    { 1000, 240, -208},
    // 19 seconds
    { 1216, 288, -216},
    { 1224, 136, -192},
    { 1288, 96, -256},
    { 1168, 48, -208},
    { 848, -112, -176},
    { 1160, 0, -8},
    { 1080, 96, -176},
    { 1256, 184, -240},
    { 1384, 280, -392},
    { 1136, 272, -312},
    { 792, 248, -336},
    { 792, 368, -344},
    { 968, 328, -296},
    { 1136, 392, -296},
    { 1152, 448, -328},
    { 1408, 568, -400},
    { 1192, 776, -312},
    { 1144, 648, -448},
    { 1104, 672, -368},
    { 1104, 512, -384},
    { 1288, 480, -320},
    { 1384, 392, -256},
    { 1184, 272, -184},
    { 1040, 200, -208},
    { 1120, 208, -208},
    // 20 seconds
    { 1248, 200, -232},
    { 1136, 136, -232},
    { 1264, 96, -304},
    { 1088, -72, -144},
    { 856, -160, -240},
    { 1184, 16, -32},
    { 1064, 16, -176},
    { 1264, 176, -272},
    { 1360, 120, -352},
    { 1160, 208, -376},
    { 896, 160, -376},
    { 880, 248, -312},
    { 1120, 280, -376},
    { 1288, 288, -384},
    { 1296, 376, -456},
    { 1544, 568, -504},
    { 1144, 600, -504},
    { 1424, 600, -568},
    { 1008, 456, -520},
    { 1104, 400, -456},
    { 1216, 368, -392},
    { 1352, 248, -248},
    { 1136, 200, -136},
    { 1104, 200, -240},
    { 1216, 216, -232},
    // 21 seconds
    { 1240, 248, -152},
    { 1240, 96, -256},
    { 1392, 64, -368},
    { 1064, -152, -184},
    { 752, -280, -152},
    { 1040, -136, 48},
    { 1136, 24, -224},
    { 1384, 128, -280},
    { 1392, 128, -320},
    { 1128, 208, -320},
    { 896, 184, -368},
    { 904, 176, -384},
    { 1080, 224, -424},
    { 1248, 392, -480},
    { 1376, 600, -624},
    { 1472, 720, -544},
    { 1032, 616, -440},
    { 1376, 648, -344},
    { 1072, 584, -504},
    { 1280, 448, -400},
    { 1440, 384, -296},
    { 1424, 336, -240},
    { 1184, 240, -192},
    { 1096, 72, -216},
    { 1272, 96, -392},
    // 22 seconds
    { 1352, 24, -400},
    { 1208, 48, -400},
    { 1272, 0, -456},
    { 936, -104, -176},
    { 688, -160, -176},
    { 992, 40, -64},
    { 1008, 32, -200},
    { 1272, 152, -232},
    { 1512, 160, -344},
    { 1232, 208, -328},
    { 912, 160, -240},
    { 952, 320, -296},
    { 1168, 392, -392},
    { 1280, 504, -312},
    { 1376, 752, -360},
    { 1488, 968, -352},
    { 1032, 760, -328},
    { 1344, 792, -144},
    { 984, 672, -248},
    { 1152, 600, -304},
    { 1256, 560, -216},
    { 1360, 408, -192},
    { 1168, 368, -184},
    { 1088, 312, -152},
    { 1272, 224, -120},
    // 23 seconds
    { 1448, 248, -152},
    { 1240, 80, -208},
    { 1256, 24, -256},
    { 1024, -160, -168},
    { 728, -232, -336},
    { 960, -160, -88},
    { 960, 64, -128},
    { 1264, 80, -312},
    { 1576, 96, -376},
    { 1344, 144, -384},
    { 1056, 168, -280},
    { 984, 288, -280},
    { 1152, 384, -320},
    { 1200, 360, -296},
    { 1224, 520, -408},
    { 1360, 904, -440},
    { 944, 752, -392},
    { 1408, 872, -440},
    { 1256, 656, -392},
    { 1600, 560, -288},
    { 1656, 432, -272},
    { 1336, 336, -288},
    { 1112, 264, -168},
    { 1056, 112, -104},
    { 1152, 256, -152},
    // 24 seconds
    { 1312, 288, -304},
    { 1272, 248, -72},
    { 1264, -16, 32},
    { 824, -168, 64},
    { 720, -192, -40},
    { 888, -128, 48},
    { 1328, 88, -256},
    { 1632, 32, -296},
    { 1848, 120, -320},
    { 1352, 184, -336},
    { 896, 168, -416},
    { 864, 120, -384},
    { 968, 152, -368},
    { 1152, 160, -376},
    { 1184, 320, -416},
    { 1448, 464, -520},
    { 1168, 624, -360},
    { 840, 424, -424},
    { 1200, 552, -432},
    { 1224, 344, -440},
    { 1368, 392, -424},
    { 1384, 304, -336},
    { 1280, 264, -264},
    { 1160, 272, -168},
    { 1288, 88, -80},
    // 25 seconds
    { 1440, 152, -136},
    { 1328, 160, -160},
    { 1104, 40, -136},
    { 1120, -72, -88},
    { 792, -104, -160},
    { 864, -88, -112},
    { 1048, 8, -128},
    { 1232, 24, -288},
    { 1536, 96, -344},
    { 1496, 96, -352},
    { 1048, 112, -400},
    { 776, 144, -288},
    { 936, 184, -256},
    { 1152, 264, -272},
    { 1248, 256, -264},
    { 1360, 296, -320},
    { 1640, 552, -536},
    { 952, 944, -520},
    { 1368, 632, -552},
    { 1096, 608, -456},
    { 1088, 464, -448},
    { 1184, 464, -376},
    { 1344, 432, -328},
    { 1312, 288, -208},
    { 1208, 264, -160},
    // 26 seconds
    { 1336, 256, -200},
    { 1448, 216, -184},
    { 1312, 152, -216},
    { 1128, 128, -248},
    { 1104, 24, -200},
    { 760, -144, -216},
    { 928, -160, -224},
    { 1040, -104, -112},
    { 1152, 112, -336},
    { 1368, 136, -352},
    { 1432, 192, -408},
    { 1152, 208, -336},
    { 1048, 280, -280},
    { 1144, 296, -352},
    { 1288, 304, -320},
    { 1160, 392, -392},
    { 1368, 560, -568},
    { 1264, 848, -504},
    { 1032, 704, -552},
    { 1144, 648, -440},
    { 1112, 552, -472},
    { 1296, 424, -376},
    { 1416, 376, -296},
    { 1336, 328, -216},
    { 1160, 216, -176},
    // 27 seconds
    { 1176, 200, -160},
    { 1304, 208, -168},
    { 1312, 152, -200},
    { 1192, 88, -192},
    { 1240, -80, -136},
    { 872, -192, -112},
    { 1096, -232, -176},
    { 1192, -128, -128},
    { 1320, 8, -320},
    { 1480, 80, -336},
    { 1368, 112, -344},
    { 1024, 208, -296},
    { 936, 288, -240},
    { 1112, 352, -224},
    { 1280, 432, -200},
    { 1312, 496, -200},
    { 1344, 880, -288},
    { 1288, 1040, -392},
    { 928, 744, -360},
    { 1368, 744, -144},
    { 1152, 680, -328},
    { 1200, 544, -288},
    { 1368, 472, -288},
    { 1512, 440, -280},
    { 1312, 344, -232},
    // 28 seconds
    { 1360, 288, -216},
    { 1480, 272, -240},
    { 1368, 192, -208},
    { 1168, 120, -224},
    { 1064, 16, -176},
    { 944, -88, -160},
    { 576, -160, -248},
    { 896, -80, -200},
    { 1080, 0, -176},
    { 1312, 168, -256},
    { 1608, 112, -360},
    { 1760, 200, -568},
    { 1320, 240, -344},
    { 1056, 224, -288},
    { 1184, 384, -496},
    { 1272, 480, -352},
    { 1144, 552, -264},
    { 1176, 880, -232},
    { 1040, 976, -264},
    { 784, 648, -264},
    { 1232, 704, -176},
    { 1160, 632, -216},
    { 1416, 536, -176},
    { 1672, 456, -200},
    { 1600, 392, -208},
    // 29 seconds
    { 1328, 344, -256},
    { 1336, 248, -264},
    { 1408, 240, -272},
    { 1288, 160, -272},
    { 1064, 80, -224},
    { 952, 24, -192},
    { 816, -24, -128},
    { 736, 16, -184},
    { 984, 144, -160},
    { 944, 120, -232},
    { 1080, 128, -352},
    { 1208, 152, -448},
    { 1312, 208, -424},
    { 1360, 256, -352},
    { 1264, 272, -352},
    { 1168, 336, -416},
    { 1096, 360, -368},
    { 1096, 368, -352},
    { 1040, 384, -304},
    { 944, 520, -320},
    { 1152, 608, -456},
    { 1416, 736, -208},
    { 1192, 592, -248},
    { 1184, 616, -176},
    { 920, 496, -216},
    // 30 seconds
    { 1040, 488, -264},
    { 1112, 440, -200},
    { 1368, 408, -176},
    { 1360, 368, -80},
    { 1320, 216, -56},
    { 1336, 320, -128},
    { 1328, 240, -192},
    { 1176, 232, -168},
    { 1064, 144, -216},
    { 1152, 104, -296},
    { 1176, 32, -336},
    { 1016, -80, -416},
    { 1104, -48, -416},
    { 968, -72, -192},
    { 1160, 88, -280},
    { 1336, 184, -288},
    { 1416, 232, -288},
    { 1224, 168, -320},
    { 1000, 288, -392},
    { 936, 272, -328},
    { 960, 328, -360},
    { 1064, 400, -368},
    { 1176, 472, -368},
    { 1400, 560, -328},
    { 1384, 800, -136},
    // 31 seconds
    { 1184, 680, -192},
    { 992, 680, -112},
    { 920, 536, -248},
    { 1184, 552, -224},
    { 1488, 504, -144},
    { 1472, 424, -128},
    { 1224, 320, -96},
    { 1136, 256, -128},
    { 1080, 320, -96},
    { 1080, 248, -160},
    { 1160, 176, -152},
    { 1112, 160, -224},
    { 1280, 128, -224},
    { 1000, 80, -312},
    { 1336, 128, -312},
    { 1208, 96, -200},
    { 1264, 168, -304},
    { 1256, 176, -240},
    { 1168, 208, -264},
    { 904, 208, -320},
    { 696, 232, -272},
    { 736, 224, -232},
    { 896, 224, -288},
    { 1128, 280, -360},
    { 1328, 320, -408},
    // 32 seconds
    { 1800, 472, -264},
    { 1368, 624, -464},
    { 1384, 536, -456},
    { 1160, 616, -400},
    { 992, 456, -424},
    { 1088, 472, -368},
    { 1128, 360, -336},
    { 1112, 280, -232},
    { 1064, 232, -224},
    { 1112, 224, -168},
    { 1208, 224, -152},
    { 1304, 208, -152},
    { 1248, 184, -112},
    { 1256, 184, -184},
    { 1152, 72, -200},
    { 984, -64, -208},
    { 1168, -160, -128},
    { 1016, -72, -168},
    { 1088, 56, -280},
    { 1208, 96, -368},
    { 1240, 144, -344},
    { 1024, 176, -296},
    { 944, 288, -272},
    { 1016, 336, -288},
    { 1168, 400, -296},
    // 33 seconds
    { 1120, 464, -256},
    { 1128, 464, -360},
    { 1440, 632, -320},
    { 1080, 768, -368},
    { 1424, 672, -408},
    { 1088, 624, -440},
    { 1120, 496, -400},
    { 1176, 424, -304},
    { 1280, 352, -208},
    { 1088, 304, -176},
    { 1048, 256, -184},
    { 1128, 240, -96},
    { 1264, 248, -128},
    { 1224, 184, -192},
    { 1224, 40, -160},
    { 1120, -104, -64},
    { 760, -264, -176},
    { 1400, -112, -56},
    { 1256, -24, -264},
    { 1320, 72, -304},
    { 1376, 80, -408},
    { 1224, 160, -336},
    { 984, 240, -336},
    { 896, 280, -320},
    { 1040, 264, -280},
    // 34 seconds
    { 1200, 408, -312},
    { 1120, 632, -272},
    { 1288, 664, -448},
    { 1184, 792, -392},
    { 872, 672, -336},
    { 1248, 712, -272},
    { 1104, 616, -336},
    { 1296, 520, -240},
    { 1536, 432, -120},
    { 1656, 392, -136},
    { 1336, 296, -232},
    { 1280, 248, -288},
    { 1352, 160, -304},
    { 1248, 88, -152},
    { 1112, 16, -208},
    { 1048, -8, -264},
    { 800, -144, -264},
    { 672, -152, -336},
    { 1088, -56, -112},
    { 1096, 24, -312},
    { 1368, 152, -320},
    { 1736, 192, -480},
    { 1512, 304, -392},
    { 1048, 288, -384},
    { 936, 344, -384},
    // 35 seconds
    { 1152, 328, -304},
    { 1304, 304, -344},
    { 1232, 400, -360},
    { 1408, 728, -480},
    { 1096, 944, -456},
    { 808, 704, -584},
    { 984, 600, -376},
    { 1192, 608, -440},
    { 1408, 544, -384},
    { 1560, 464, -344},
    { 1672, 384, -240},
    { 1448, 288, -192},
    { 1312, 184, -176},
    { 1272, 80, -128},
    { 1184, 120, -144},
    { 1048, -8, -152},
    { 1032, -72, -176},
    { 912, -152, -136},
    { 616, -176, -232},
    { 984, -112, -176},
    { 1200, 24, -128},
    { 1600, 216, -320},
    { 2072, 224, -408},
    { 1776, 320, -432},
    { 976, 408, -320},
    // 36 seconds
    { 704, 360, -480},
    { 840, 400, -456},
    { 1088, 472, -432},
    { 1168, 488, -192},
    { 1224, 864, -288},
    { 1352, 888, -632},
    { 888, 608, -536},
    { 1328, 560, -528},
    { 1440, 576, -632},
    { 1720, 488, -584},
    { 2000, 352, -368},
    { 1840, 360, -224},
    { 1416, 208, -120},
    { 1160, 200, -208},
    { 1072, 80, -200},
    { 1048, 32, -144},
    { 1040, -64, -200},
    { 1128, 0, -96},
    { 960, -120, -120},
    { 832, -80, -296},
    { 1024, -112, -168},
    { 1304, 0, -248},
    { 1800, 160, -384},
    { 2072, 240, -512},
    { 1576, 296, -392},
    // 37 seconds
    { 992, 376, -592},
    { 872, 424, -400},
    { 840, 368, -232},
    { 888, 440, -280},
    { 984, 320, -392},
    { 1304, 376, -624},
    { 1592, 280, -592},
    { 1080, 320, -616},
    { 1336, 424, -688},
    { 1072, 520, -648},
    { 1280, 448, -544},
    { 1400, 320, -336},
    { 1400, 240, -216},
    { 1136, 208, -224},
    { 1024, 168, -280},
    { 1080, 144, -240},
    { 1136, 136, -240},
    { 1088, 80, -216},
    { 1160, 56, -280},
    { 1104, -24, -296},
    { 1064, -88, -288},
    { 1232, 0, -200},
    { 1384, 80, -376},
    { 1480, 152, -392},
    { 1472, 200, -384},
    // 38 seconds
    { 1176, 288, -400},
    { 800, 320, -360},
    { 744, 312, -328},
    { 832, 424, -312},
    { 1136, 416, -288},
    { 1280, 528, -240},
    { 1456, 632, -208},
    { 1208, 744, -264},
    { 1312, 760, -296},
    { 1000, 672, -272},
    { 1024, 576, -352},
    { 1120, 520, -296},
    { 1296, 464, -240},
    { 1232, 376, -176},
    { 1072, 288, -160},
    { 1072, 280, -168},
    { 1168, 248, -184},
    { 1248, 224, -224},
    { 1152, 176, -312},
    { 1336, 128, -352},
    { 1064, 40, -328},
    { 872, -136, -328},
    { 1080, -48, -208},
    { 1048, 24, -256},
    { 1112, 160, -304},
    // 39 seconds
    { 1312, 216, -392},
    { 1224, 256, -384},
    { 968, 288, -304},
    { 912, 360, -272},
    { 1056, 384, -288},
    { 1152, 480, -328},
    { 1088, 608, -336},
    { 1160, 680, -424},
    { 1336, 776, -336},
    { 976, 648, -264},
    { 1336, 728, -208},
    { 1096, 608, -288},
    { 1200, 560, -280},
    { 1296, 552, -216},
    { 1440, 448, -160},
    { 1168, 328, -128},
    { 1104, 240, -192},
    { 1216, 328, -168},
    { 1328, 200, -200},
    { 1168, 192, -200},
    { 1304, 120, -264},
    { 1120, 0, -264},
    { 840, -176, -376},
    { 1056, -120, -40},
    { 1200, 0, -328},
    // 40 seconds
    { 1376, 136, -336},
    { 1496, 168, -408},
    { 1232, 232, -352},
    { 904, 296, -304},
    { 880, 392, -344},
    { 1048, 376, -280},
    { 1192, 416, -224},
    { 1200, 536, -248},
    { 1504, 696, -296},
    { 1152, 856, -160},
    { 1120, 776, -336},
    { 1056, 752, -216},
    { 1016, 648, -288},
    { 1160, 584, -248},
    { 1312, 480, -208},
    { 1248, 416, -192},
    { 1072, 280, -192},
    { 1152, 272, -200},
    { 1384, 280, -272},
    { 1328, 160, -240},
    { 1272, 144, -360},
    { 1344, 40, -376},
    { 896, -144, -304},
    { 968, -200, -200},
    { 976, -80, -168},
    // 41 seconds
    { 1056, 80, -304},
    { 1400, 152, -312},
    { 1336, 192, -376},
    { 928, 192, -320},
    { 768, 256, -304},
    { 936, 328, -312},
    { 1224, 360, -280},
    { 1184, 512, -368},
    { 1296, 616, -400},
    { 1400, 920, -432},
    { 1024, 688, -376},
    { 1392, 728, -272},
    { 1088, 640, -416},
    { 1192, 520, -336},
    { 1304, 448, -184},
    { 1208, 344, -176},
    { 976, 296, -216},
    { 976, 248, -248},
    { 1152, 232, -216},
    { 1320, 224, -224},
    { 1184, 152, -280},
    { 1232, 56, -264},
    { 952, -160, -200},
    { 776, -176, -248},
    { 1256, -24, -72},
    // 42 seconds
    { 1120, 112, -352},
    { 1376, 184, -312},
    { 1456, 192, -416},
    { 1056, 248, -296},
    { 816, 256, -320},
    { 936, 328, -312},
    { 1160, 344, -328},
    { 1160, 416, -368},
    { 1168, 536, -400},
    { 1352, 792, -368},
    { 984, 672, -408},
    { 1448, 728, -200},
    { 1184, 608, -352},
    { 1208, 512, -400},
    { 1352, 464, -344},
    { 1328, 392, -184},
    { 1072, 312, -144},
    { 1032, 248, -168},
    { 1168, 208, -192},
    { 1296, 192, -216},
    { 1168, 120, -144},
    { 1192, -24, -232},
    { 952, -152, -136},
    { 776, -176, -272},
    { 1208, -16, -40},
    // 43 seconds
    { 1160, 128, -368},
    { 1376, 144, -336},
    { 1496, 168, -464},
    { 1184, 232, -368},
    { 848, 256, -360},
    { 856, 400, -344},
    { 1032, 448, -360},
    { 1192, 392, -272},
    { 1376, 464, -272},
    { 1576, 672, -272},
    { 1032, 768, -224},
    { 1272, 792, -392},
    { 1080, 728, -392},
    { 1008, 536, -464},
    { 1152, 480, -400},
    { 1240, 408, -336},
    { 1048, 312, -192},
    { 1072, 224, -200},
    { 1312, 248, -216},
    { 1384, 224, -224},
    { 1200, 136, -176},
    { 1176, 0, -264},
    { 1040, -192, -200},
    { 880, -232, -224},
    { 1392, -96, 24},
    // 44 seconds
    { 1424, 64, -312},
    { 1456, 160, -296},
    { 1368, 160, -352},
    { 984, 192, -344},
    { 744, 216, -328},
    { 824, 272, -264},
    { 1080, 344, -320},
    { 1200, 424, -208},
    { 1224, 520, -232},
    { 1368, 816, -336},
    { 976, 680, -344},
    { 1376, 808, -200},
    { 1168, 720, -280},
    { 1240, 640, -352},
    { 1352, 464, -240},
    { 1408, 472, -328},
    { 1168, 400, -296},
    { 1160, 248, -224},
    { 1352, 256, -288},
    { 1416, 256, -224},
    { 1240, 72, -168},
    { 1208, 80, -240},
    { 1008, -8, -264},
    { 712, -112, -352},
    { 1208, -56, -224},
    // 45 seconds
    { 1120, 16, -248},
    { 1272, 176, -352},
    { 1456, 224, -384},
    { 1288, 320, -432},
    { 1000, 336, -376},
    { 1032, 528, -496},
    { 1128, 616, -320},
    { 1240, 656, -264},
    { 1088, 672, -240},
    { 1264, 736, -240},
    { 1080, 824, -72},
    { 1232, 800, -120},
    { 1088, 784, -256},
    { 1112, 640, -360},
    { 1296, 512, -520},
    { 1336, 480, -392},
    { 1104, 312, -224},
    { 1048, 304, -152},
    { 1144, 264, -192},
    { 1208, 304, -200},
    { 1136, 232, -240},
    { 1216, 200, -352},
    { 1144, 112, -296},
    { 760, -104, -280},
    { 1192, -128, 0},
    // 46 seconds
    { 1144, 40, -248},
    { 1256, 192, -304},
    { 1408, 216, -432},
    { 1176, 296, -392},
    { 920, 184, -328},
    { 944, 384, -280},
    { 1136, 448, -304},
    { 1232, 432, -344},
    { 1120, 552, -376},
    { 1432, 688, -432},
    { 1160, 752, -288},
    { 1112, 704, -296},
    { 1048, 760, -248},
    { 1024, 576, -304},
    { 1176, 504, -248},
    { 1360, 440, -200},
    { 1264, 288, -120},
    { 1176, 320, -192},
    { 1288, 296, -240},
    { 1360, 224, -264},
    { 1184, 192, -336},
    { 1144, 56, -384},
    { 1128, -120, -288},
    { 688, -248, -144},
    { 1248, -176, -200},
    // 47 seconds
    { 1024, 32, -152},
    { 1264, 128, -312},
    { 1416, 248, -416},
    { 1240, 248, -424},
    { 936, 168, -328},
    { 824, 128, -200},
    { 1032, 248, -256},
    { 1232, 400, -280},
    { 1176, 480, -248},
    { 1488, 624, -336},
    { 1160, 712, -344},
    { 1184, 656, -296},
    { 1120, 744, -368},
    { 1088, 544, -464},
    { 1232, 512, -416},
    { 1432, 416, -432},
    { 1368, 200, -440},
    { 1160, 64, -24},
    { 1224, 128, -336},
    { 1256, 72, -272},
    { 1128, 136, -248},
    { 1016, 120, 0},
    { 1064, 24, -352},
    { 752, -104, -296},
    { 1088, -120, -280},
    // 48 seconds
    { 1112, -32, -248},
    { 1096, 104, -256},
    { 1280, 72, -368},
    { 1272, 176, -352},
    { 1000, 128, -272},
    { 904, 184, -296},
    { 1096, 216, -296},
    { 1328, 224, -280},
    { 1184, 288, -304},
    { 1480, 488, -504},
    { 1320, 704, -528},
    { 1256, 664, -616},
    { 1176, 488, -472},
    { 960, 504, -536},
    { 1224, 376, -440},
    { 1368, 360, -288},
    { 1312, 280, -200},
    { 1144, 216, -168},
    { 1136, 184, -160},
    { 1200, 176, -136},
    { 1232, 168, -144},
    { 1144, 128, -176},
    { 1248, 48, -232},
    { 1048, -80, -144},
    { 928, -160, -192},
    // 49 seconds
    { 1144, -72, -104},
    { 1120, -40, -296},
    { 1328, 0, -304},
    { 1344, 56, -400},
    { 1088, 112, -416},
    { 856, 184, -360},
    { 928, 280, -392},
    { 1120, 288, -280},
    { 1312, 368, -280},
    { 1208, 528, -368},
    { 1432, 600, -520},
    { 1224, 656, -392},
    { 1096, 584, -376},
    { 1088, 608, -384},
    { 1032, 512, -448},
    { 1288, 464, -344},
    { 1440, 408, -264},
    { 1400, 272, -168},
    { 1224, 200, -104},
    { 1272, 240, -184},
    { 1360, 184, -168},
    { 1224, 168, -120},
    { 1056, 48, -160},
    { 1088, -24, -192},
    { 888, -112, -208},
    // 50 seconds
    { 832, -104, -256},
    { 1216, -24, -112},
    { 1112, 72, -312},
    { 1312, 112, -296},
    { 1368, 152, -344},
    { 1104, 144, -272},
    { 896, 264, -320},
    { 960, 288, -248},
    { 1216, 392, -280},
    { 1288, 448, -240},
    { 1240, 464, -224},
    { 1656, 872, -320},
    { 1016, 928, -288},
    { 1280, 784, -392},
    { 984, 720, -296},
    { 1056, 584, -376},
    { 1240, 496, -304},
    { 1400, 408, -152},
    { 1232, 352, -192},
    { 1160, 256, -192},
    { 1304, 288, -168},
    { 1320, 208, -216},
    { 1152, 216, -224},
    { 1160, 88, -320},
    { 1096, -80, -136},
    // 51 seconds
    { 744, -344, -200},
    { 1184, -96, -16},
    { 1152, 32, -208},
    { 1272, 176, -200},
    { 1376, 176, -312},
    { 1264, 224, -320},
    { 1000, 160, -240},
    { 864, 352, -320},
    { 1032, 352, -336},
    { 1256, 408, -320},
    { 1168, 528, -424},
    { 1248, 640, -520},
    { 1288, 832, -528},
    { 1088, 664, -504},
    { 1296, 592, -368},
    { 1216, 552, -456},
    { 1264, 408, -288},
    { 1352, 360, -224},
    { 1304, 320, -144},
    { 1192, 264, -128},
    { 1240, 216, -144},
    { 1320, 216, -184},
    { 1208, 128, -216},
    { 992, 40, -320},
    { 1096, -152, -352},
    // 52 seconds
    { 744, -328, -224},
    { 792, -200, -160},
    { 1136, 16, -128},
    { 1240, 96, -264},
    { 1488, 144, -280},
    { 1560, 184, -376},
    { 1152, 216, -304},
    { 936, 288, -360},
    { 1088, 352, -408},
    { 1256, 336, -320},
    { 1200, 368, -296},
    { 1136, 496, -376},
    { 1192, 696, -440},
    { 896, 632, -376},
    { 1416, 696, -416},
    { 1280, 488, -328},
    { 1200, 456, -416},
    { 1248, 488, -296},
    { 1504, 424, -208},
    { 1360, 320, -80},
    { 1192, 256, -88},
    { 1304, 280, -128},
    { 1408, 296, -144},
    { 1376, 256, -152},
    { 1160, 176, -168},
    // 53 seconds
    { 1144, 64, -184},
    { 840, -176, -216},
    { 688, -168, -208},
    { 824, -72, -144},
    { 968, 40, -216},
    { 1136, 144, -248},
    { 1552, 224, -512},
    { 1616, 312, -560},
    { 1272, 280, -280},
    { 1160, 264, -88},
    { 1128, 344, -328},
    { 1248, 376, -320},
    { 1112, 384, -272},
    { 936, 400, -232},
    { 1104, 536, -288},
    { 1104, 664, -240},
    { 1000, 728, -240},
    { 1464, 664, -288},
    { 680, 584, -280},
    { 1192, 464, -240},
    { 1704, 416, -104},
    { 1480, 440, -80},
    { 1504, 432, -128},
    { 1448, 512, -64},
    { 1504, 552, 8},
    // 54 seconds
    { 1408, 568, -56},
    { 1256, 648, -264},
    { 1160, 728, -400},
    { 976, 800, -376},
    { 840, 608, -408},
    { 696, 304, -488},
    { 512, -56, -568},
    { 240, -160, -664},
    { 192, -248, -720},
    { 344, -472, -816},
    { 752, -1040, -1096},
    { 168, 240, -1080},
    { 1152, -520, -1280},
    { -184, -352, -760},
    { -200, -80, -832},
    { 184, 96, -1072},
    { 96, -416, -1088},
    { 312, -128, -1064},
    { -16, -184, -1048},
    { 472, -288, -968},
    { -72, -40, -768},
    { 224, -272, -704},
    { 408, -296, -888},
    { 424, -192, -1136},
    { 392, -264, -1064},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 12:39:07 local
AccelRawData *activity_sample_walk_100_pbl_28397_11(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28397_11
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -104, 288, -960},
    { -144, 392, -960},
    { -120, 296, -960},
    { -128, 336, -992},
    { -120, 296, -968},
    { -112, 304, -976},
    { -128, 344, -968},
    { -136, 312, -984},
    { -144, 336, -976},
    { -112, 352, -984},
    { -128, 312, -984},
    { -136, 320, -1008},
    { -80, 240, -1000},
    { -96, 200, -960},
    { -72, 240, -1008},
    { -104, 280, -1040},
    { -56, 208, -1032},
    { -128, 256, -1024},
    { -120, 472, -1056},
    { -224, 128, -952},
    { -168, 104, -1016},
    { -56, 256, -1016},
    { -112, 240, -1008},
    { -120, 272, -984},
    { -144, 248, -992},
    // 1 seconds
    { -112, 280, -992},
    { -264, 248, -856},
    { -136, 272, -984},
    { -48, 296, -1008},
    { -88, 280, -1016},
    { -8, -56, -976},
    { -184, 376, -976},
    { -152, 176, -944},
    { 8, -128, -984},
    { -56, 264, -1024},
    { -24, 208, -1000},
    { -64, 264, -1064},
    { -48, 288, -1000},
    { -88, 240, -1016},
    { -104, 312, -992},
    { -136, 672, -936},
    { -176, 672, -880},
    { -136, 544, -856},
    { -152, 768, -848},
    { -128, 496, -824},
    { -88, 488, -880},
    { -96, 424, -968},
    { -48, 368, -992},
    { -48, 504, -928},
    { -120, 544, -808},
    // 2 seconds
    { -72, 464, -736},
    { -96, 600, -688},
    { -88, 576, -728},
    { -96, 728, -648},
    { -80, 872, -672},
    { -104, 968, -688},
    { -64, 1016, -664},
    { -80, 928, -640},
    { -88, 880, -544},
    { -72, 944, -544},
    { -120, 1032, -424},
    { -128, 1048, -496},
    { -72, 896, -408},
    { -56, 776, -416},
    { -8, 984, -448},
    { -216, 1144, -320},
    { -144, 840, -152},
    { -152, 1032, -184},
    { -56, 952, -248},
    { -232, 968, -224},
    { -88, 736, -328},
    { -32, 720, -432},
    { -88, 1128, -280},
    { -80, 1120, -336},
    { -152, 1264, -48},
    // 3 seconds
    { -192, 1184, -48},
    { -96, 1064, -104},
    { -144, 1000, -48},
    { -128, 1064, -152},
    { -160, 952, -328},
    { -144, 920, -8},
    { -120, 1128, -120},
    { -160, 1016, -120},
    { -96, 904, -112},
    { -144, 960, -88},
    { -120, 1088, -88},
    { -96, 1024, -120},
    { -72, 976, -184},
    { 24, 800, -224},
    { 120, 712, -408},
    { 264, 600, -424},
    { 432, 512, -440},
    { 648, 456, -408},
    { 816, 600, -504},
    { 1040, 576, -456},
    { 1240, 608, -456},
    { 1448, 584, -400},
    { 1472, 544, -400},
    { 1456, 512, -440},
    { 1392, 456, -440},
    // 4 seconds
    { 1336, 472, -448},
    { 1176, 400, -528},
    { 1120, 352, -576},
    { 1152, 376, -624},
    { 1112, 392, -544},
    { 1040, 400, -440},
    { 920, 472, -456},
    { 752, 416, -440},
    { 664, 432, -440},
    { 832, 432, -376},
    { 1192, 368, -296},
    { 1552, 240, -224},
    { 1608, 432, -304},
    { 1528, 280, -216},
    { 1536, 464, -280},
    { 1448, 432, -184},
    { 1360, 624, -96},
    { 1200, 616, -80},
    { 1120, 624, -152},
    { 992, 488, -120},
    { 792, 440, -216},
    { 552, 352, -408},
    { 552, 240, -496},
    { 704, 280, -352},
    { 712, 456, -336},
    // 5 seconds
    { 992, 744, -152},
    { 1072, 1160, -32},
    { 880, 1368, 56},
    { 568, 1096, 24},
    { 456, 1024, -24},
    { 360, 1120, 40},
    { 248, 1048, 40},
    { 72, 1024, 128},
    { -152, 1232, 176},
    { -248, 1160, 360},
    { 0, 1360, 344},
    { 72, 1272, 440},
    { 416, 1384, 416},
    { 400, 1056, 352},
    { 272, 912, 312},
    { 240, 824, 296},
    { 168, 784, 248},
    { 144, 720, 152},
    { 80, 752, 152},
    { 40, 904, 112},
    { 64, 920, 64},
    { 168, 968, -48},
    { 280, 1112, -80},
    { 376, 1296, -192},
    { 232, 1216, -264},
    // 6 seconds
    { 296, 1256, -336},
    { 224, 1272, -312},
    { 232, 1024, -288},
    { 192, 824, -208},
    { 128, 848, -160},
    { 40, 728, -128},
    { -192, 592, -72},
    { -240, 680, -240},
    { -344, 776, -280},
    { -352, 1048, -256},
    { -416, 1144, -184},
    { -328, 1224, 64},
    { -304, 1280, 96},
    { -216, 1320, 344},
    { -96, 1488, 240},
    { -208, 1016, 568},
    { -152, 768, 664},
    { 0, 624, 400},
    { 112, 632, 56},
    { -120, 688, -432},
    { -48, 576, -456},
    { 72, 584, -464},
    { 336, 480, -392},
    { 832, 752, -480},
    { 1352, 872, -496},
    // 7 seconds
    { 1400, 424, -160},
    { 1904, 288, 224},
    { 1920, 624, -208},
    { 1848, 776, -272},
    { 1544, 296, -168},
    { 1200, 600, -264},
    { 960, 360, -240},
    { 864, 344, -280},
    { 928, 312, -320},
    { 928, 752, -424},
    { 1136, 512, -568},
    { 1384, 592, -480},
    { 1008, 536, -456},
    { 1280, 720, -640},
    { 1056, 312, -704},
    { 1256, 264, -600},
    { 1336, 208, -416},
    { 1392, 232, -264},
    { 1184, 72, -168},
    { 1008, 64, -224},
    { 984, -144, -56},
    { 1152, 200, -200},
    { 1288, 112, -8},
    { 1520, 128, -208},
    { 1336, 16, -8},
    // 8 seconds
    { 1168, -24, -216},
    { 1096, -168, 72},
    { 1120, -160, -176},
    { 1320, -152, -288},
    { 1368, -160, -352},
    { 1072, -120, -416},
    { 688, -56, -384},
    { 640, -8, -344},
    { 800, 88, -328},
    { 992, 168, -320},
    { 1176, 216, -352},
    { 1632, 408, -392},
    { 1592, 568, -320},
    { 992, 592, -384},
    { 1368, 656, -448},
    { 976, 536, -400},
    { 1232, 456, -368},
    { 1336, 456, -344},
    { 1296, 312, -216},
    { 1000, 152, -136},
    { 944, 192, -216},
    { 1088, 192, -176},
    { 1192, 160, -80},
    { 1088, 152, -88},
    { 1208, 72, -88},
    // 9 seconds
    { 1088, -40, -160},
    { 1048, -104, -168},
    { 1352, -48, -128},
    { 1192, 8, -328},
    { 1376, -8, -368},
    { 1272, 72, -392},
    { 968, 80, -360},
    { 760, 136, -376},
    { 736, 88, -336},
    { 848, 192, -328},
    { 952, 200, -408},
    { 1168, 160, -464},
    { 1544, 336, -544},
    { 1200, 344, -576},
    { 1592, 504, -696},
    { 1248, 320, -608},
    { 1224, 264, -624},
    { 1240, 296, -472},
    { 1376, 424, -384},
    { 1152, 296, -288},
    { 952, 312, -200},
    { 1008, 472, -200},
    { 1136, 288, -96},
    { 1024, 160, -32},
    { 872, 112, -88},
    // 10 seconds
    { 1112, 168, -272},
    { 792, -40, -216},
    { 1072, 32, -248},
    { 1024, -8, -240},
    { 1136, -48, -336},
    { 1512, 96, -480},
    { 1464, 104, -408},
    { 1008, 120, -288},
    { 776, 192, -384},
    { 808, 208, -384},
    { 904, 192, -312},
    { 1088, 168, -432},
    { 1384, 336, -504},
    { 1736, 584, -608},
    { 1056, 608, -488},
    { 1400, 664, -560},
    { 960, 528, -504},
    { 1088, 488, -496},
    { 1408, 504, -376},
    { 1424, 416, -288},
    { 1168, 192, -136},
    { 1056, 144, -128},
    { 1208, 144, -160},
    { 1280, 56, -104},
    { 1160, -8, -88},
    // 11 seconds
    { 1168, -24, -192},
    { 1104, -80, -216},
    { 888, -136, -296},
    { 1288, -32, -88},
    { 1144, 8, -272},
    { 1352, 40, -272},
    { 1528, 232, -416},
    { 1032, 248, -272},
    { 656, 160, -280},
    { 744, 280, -272},
    { 992, 280, -208},
    { 1224, 272, -264},
    { 1152, 376, -256},
    { 1720, 808, -408},
    { 1080, 1008, -280},
    { 1312, 1032, -440},
    { 1128, 808, -328},
    { 1272, 640, -376},
    { 1296, 584, -344},
    { 1408, 448, -240},
    { 1160, 384, -192},
    { 1008, 192, -144},
    { 1016, 168, -112},
    { 1128, 200, -136},
    { 1168, 160, -136},
    // 12 seconds
    { 1088, 112, -80},
    { 1240, 64, -192},
    { 704, -72, -232},
    { 1136, 8, -168},
    { 1176, 16, -224},
    { 1400, 96, -312},
    { 1680, 216, -504},
    { 1312, 224, -336},
    { 800, 264, -376},
    { 640, 320, -424},
    { 816, 320, -336},
    { 1080, 400, -296},
    { 1088, 304, -184},
    { 1552, 464, -256},
    { 1472, 992, -416},
    { 928, 536, -480},
    { 1440, 640, -464},
    { 1328, 488, -520},
    { 1336, 472, -512},
    { 1376, 304, -368},
    { 1320, 216, -232},
    { 1032, 152, -224},
    { 1056, 240, -200},
    { 1232, 144, -192},
    { 1240, 152, -136},
    // 13 seconds
    { 1104, 32, -176},
    { 1136, -40, -208},
    { 872, -128, -168},
    { 928, -136, -80},
    { 1104, 16, -48},
    { 1344, 136, -200},
    { 1608, 232, -264},
    { 1608, 176, -360},
    { 1128, 256, -344},
    { 816, 360, -336},
    { 880, 336, -408},
    { 1048, 360, -392},
    { 1104, 376, -312},
    { 1264, 560, -368},
    { 1416, 760, -288},
    { 880, 608, -376},
    { 1568, 680, -312},
    { 1312, 488, -352},
    { 1448, 520, -320},
    { 1520, 384, -272},
    { 1416, 344, -248},
    { 1048, 248, -72},
    { 1008, 184, -88},
    { 1144, 216, -112},
    { 1216, 184, -120},
    // 14 seconds
    { 1088, 128, -40},
    { 1280, 136, -144},
    { 1008, 24, -120},
    { 824, 32, -248},
    { 1192, 104, -152},
    { 1032, 32, -248},
    { 1256, 120, -360},
    { 1512, 144, -448},
    { 1312, 264, -400},
    { 832, 248, -312},
    { 768, 272, -600},
    { 912, 232, -304},
    { 1152, 344, -296},
    { 1224, 384, -376},
    { 1648, 536, -424},
    { 1256, 736, -440},
    { 1200, 640, -472},
    { 1168, 656, -344},
    { 1056, 520, -488},
    { 1264, 464, -360},
    { 1408, 384, -272},
    { 1304, 288, -200},
    { 1104, 280, -160},
    { 1120, 176, -96},
    { 1320, 240, -136},
    // 15 seconds
    { 1344, 104, -144},
    { 1128, 56, -144},
    { 1128, -32, -256},
    { 880, -200, -200},
    { 728, -240, -408},
    { 1288, -144, -152},
    { 1120, -8, -304},
    { 1352, 144, -336},
    { 1488, 136, -336},
    { 1264, 232, -272},
    { 968, 192, -240},
    { 912, 248, -248},
    { 1136, 280, -280},
    { 1208, 352, -552},
    { 1232, 448, -456},
    { 1616, 872, -640},
    { 1160, 672, -424},
    { 1216, 600, -440},
    { 1128, 576, -400},
    { 1128, 416, -424},
    { 1288, 448, -312},
    { 1496, 288, -184},
    { 1384, 232, -192},
    { 1208, 240, -256},
    { 1288, 128, -224},
    // 16 seconds
    { 1376, 144, -152},
    { 1208, -8, -192},
    { 1088, 16, -216},
    { 1104, -144, -144},
    { 752, -216, -272},
    { 992, -216, -232},
    { 1072, -144, -128},
    { 1288, 32, -232},
    { 1424, 48, -168},
    { 1312, 160, -256},
    { 984, 176, -264},
    { 840, 184, -280},
    { 968, 192, -224},
    { 1208, 200, -256},
    { 1368, 256, -320},
    { 1544, 456, -416},
    { 1720, 1016, -376},
    { 712, 984, -728},
    { 1272, 872, -376},
    { 1368, 720, -336},
    { 1152, 520, -416},
    { 1192, 536, -432},
    { 1256, 376, -280},
    { 1080, 240, -168},
    { 1032, 144, -160},
    // 17 seconds
    { 1144, 224, -200},
    { 1288, 184, -256},
    { 1280, 184, -296},
    { 1296, 120, -352},
    { 1312, -8, -264},
    { 808, -312, -168},
    { 1024, -240, 16},
    { 1040, 16, -224},
    { 1200, 144, -312},
    { 1472, 152, -352},
    { 1328, 240, -352},
    { 960, 160, -224},
    { 824, 312, -352},
    { 1056, 336, -344},
    { 1264, 376, -336},
    { 1104, 512, -400},
    { 1400, 720, -456},
    { 1152, 848, -296},
    { 904, 616, -352},
    { 1344, 712, -304},
    { 1272, 640, -344},
    { 1240, 544, -272},
    { 1280, 408, -160},
    { 1112, 320, -208},
    { 992, 280, -208},
    // 18 seconds
    { 1128, 216, -128},
    { 1424, 216, -160},
    { 1232, 104, -160},
    { 1136, -56, -120},
    { 1120, -200, -136},
    { 720, -304, -192},
    { 1384, -72, -72},
    { 1280, 0, -216},
    { 1408, 136, -296},
    { 1424, 96, -336},
    { 1184, 184, -304},
    { 688, 160, -208},
    { 768, 320, -312},
    { 992, 320, -280},
    { 1136, 392, -240},
    { 1112, 504, -408},
    { 1544, 696, -432},
    { 1056, 816, -368},
    { 1344, 680, -360},
    { 1168, 576, -296},
    { 1296, 536, -392},
    { 1352, 488, -296},
    { 1424, 376, -200},
    { 1152, 344, -152},
    { 1008, 232, -96},
    // 19 seconds
    { 1080, 192, -120},
    { 1296, 184, -144},
    { 1280, 136, -152},
    { 1144, -64, -112},
    { 1304, -56, -160},
    { 896, -120, -160},
    { 1224, -64, -160},
    { 1040, 40, -64},
    { 1056, 136, -304},
    { 1224, 128, -328},
    { 1352, 168, -392},
    { 1096, 280, -280},
    { 776, 296, -272},
    { 760, 312, -296},
    { 1072, 264, -240},
    { 1272, 272, -288},
    { 1216, 400, -440},
    { 1608, 536, -488},
    { 1104, 720, -400},
    { 1352, 584, -352},
    { 1136, 752, -384},
    { 920, 480, -440},
    { 1200, 536, -360},
    { 1336, 456, -184},
    { 1088, 336, -104},
    // 20 seconds
    { 1032, 248, -112},
    { 1128, 256, -128},
    { 1248, 184, -112},
    { 1144, 144, -128},
    { 1088, 48, -184},
    { 1296, -16, -216},
    { 888, -144, -184},
    { 1104, -96, -176},
    { 1384, 40, -40},
    { 1152, 104, -224},
    { 1144, 264, -384},
    { 1080, 232, -424},
    { 792, 184, -320},
    { 744, 296, -280},
    { 1056, 264, -256},
    { 1416, 376, -352},
    { 1328, 496, -280},
    { 1120, 664, -336},
    { 1264, 768, -432},
    { 872, 608, -280},
    { 1520, 576, -232},
    { 1056, 528, -296},
    { 984, 496, -248},
    { 1096, 392, -160},
    { 1176, 344, -152},
    // 21 seconds
    { 1040, 312, -224},
    { 1080, 240, -192},
    { 1208, 248, -144},
    { 1192, 120, -128},
    { 1008, 72, -200},
    { 1120, 24, -248},
    { 1168, -16, -304},
    { 856, -24, -264},
    { 1480, -24, -160},
    { 976, 64, -200},
    { 1152, 160, -360},
    { 1192, 192, -352},
    { 944, 192, -264},
    { 776, 232, -104},
    { 864, 272, -232},
    { 1104, 360, -256},
    { 1240, 360, -280},
    { 1192, 480, -248},
    { 1408, 608, -288},
    { 1136, 600, -160},
    { 1648, 736, -256},
    { 1040, 488, -400},
    { 1000, 472, -352},
    { 992, 496, -312},
    { 1056, 320, -176},
    // 22 seconds
    { 864, 176, -128},
    { 856, 136, -168},
    { 1152, 184, -200},
    { 1544, 184, -224},
    { 1400, 104, -248},
    { 1488, -16, -272},
    { 1064, -264, -104},
    { 744, -248, -112},
    { 1192, -16, -48},
    { 1136, 64, -248},
    { 1296, 128, -216},
    { 1288, 96, -304},
    { 888, 184, -288},
    { 584, 136, -280},
    { 648, 144, -272},
    { 888, 112, -368},
    { 1048, 224, -240},
    { 1248, 408, -368},
    { 1800, 544, -552},
    { 1080, 480, -336},
    { 1560, 512, -392},
    { 1248, 472, -360},
    { 1000, 328, -392},
    { 1088, 352, -344},
    { 1160, 216, -240},
    // 23 seconds
    { 904, 112, -192},
    { 888, -8, -256},
    { 1128, 184, -272},
    { 1272, 120, -272},
    { 1224, 88, -248},
    { 1280, -80, -240},
    { 1128, -280, -120},
    { 768, -296, -160},
    { 1240, -32, 24},
    { 1312, -16, -280},
    { 1256, 88, -272},
    { 1368, 56, -296},
    { 984, 16, -248},
    { 656, 184, -352},
    { 616, 216, -328},
    { 808, 208, -288},
    { 976, 208, -264},
    { 1072, 336, -264},
    { 1728, 432, -392},
    { 1144, 776, -264},
    { 1712, 552, -472},
    { 1296, 400, -352},
    { 1080, 344, -496},
    { 1136, 360, -400},
    { 1272, 232, -320},
    // 24 seconds
    { 1072, 144, -96},
    { 832, -8, 0},
    { 880, 248, -256},
    { 1080, 120, -192},
    { 1152, 136, -40},
    { 1000, 24, -88},
    { 1176, 24, -192},
    { 984, -40, -136},
    { 1200, 72, -208},
    { 1264, 56, -112},
    { 1080, 136, -288},
    { 1272, 104, -368},
    { 1200, 128, -352},
    { 832, 128, -304},
    { 640, 224, -304},
    { 792, 248, -256},
    { 1024, 248, -248},
    { 1040, 248, -256},
    { 1056, 344, -304},
    { 1504, 480, -368},
    { 1056, 496, -264},
    { 1608, 544, -320},
    { 1128, 440, -328},
    { 1040, 368, -408},
    { 1040, 368, -320},
    // 25 seconds
    { 1104, 304, -328},
    { 928, 304, -256},
    { 976, 184, -136},
    { 1128, 184, -96},
    { 1256, 200, -136},
    { 1184, 176, -112},
    { 1232, 112, -176},
    { 1168, -40, -64},
    { 752, -136, -208},
    { 1168, -88, -72},
    { 1216, 72, -240},
    { 1160, 88, -296},
    { 1216, 224, -352},
    { 952, 224, -280},
    { 664, 208, -216},
    { 680, 304, -216},
    { 888, 328, -216},
    { 1256, 456, -304},
    { 1296, 408, -264},
    { 1256, 368, -296},
    { 1272, 552, -368},
    { 1032, 592, -360},
    { 1344, 592, -384},
    { 1040, 552, -432},
    { 1120, 480, -352},
    // 26 seconds
    { 1176, 392, -256},
    { 1056, 272, -136},
    { 912, 184, -120},
    { 944, 224, -136},
    { 1120, 216, -144},
    { 1272, 224, -112},
    { 1272, 160, -152},
    { 1480, 112, -120},
    { 1048, -88, 48},
    { 1232, -56, -128},
    { 1024, 0, -72},
    { 1008, 112, -328},
    { 1184, 80, -336},
    { 1200, 88, -376},
    { 864, 80, -280},
    { 672, 160, -296},
    { 848, 216, -320},
    { 1048, 248, -408},
    { 1072, 184, -400},
    { 1344, 272, -440},
    { 1488, 392, -480},
    { 1160, 344, -504},
    { 1208, 448, -480},
    { 920, 256, -440},
    { 1056, 264, -416},
    // 27 seconds
    { 1192, 256, -288},
    { 1152, 168, -160},
    { 928, 88, -152},
    { 888, 176, -216},
    { 1048, 80, -160},
    { 1176, 152, -80},
    { 1016, -56, -64},
    { 1240, -64, -152},
    { 1072, -208, -48},
    { 1048, -224, -240},
    { 1392, -104, -16},
    { 1216, 64, -296},
    { 1192, 72, -336},
    { 1264, 32, -368},
    { 968, 88, -296},
    { 680, 128, -296},
    { 720, 208, -280},
    { 936, 152, -264},
    { 1040, 64, -304},
    { 976, 224, -312},
    { 1344, 480, -352},
    { 1184, 496, -376},
    { 1280, 400, -368},
    { 1360, 424, -416},
    { 1128, 296, -456},
    // 28 seconds
    { 1152, 296, -360},
    { 1160, 264, -264},
    { 992, 232, -208},
    { 864, 80, -144},
    { 960, 88, -160},
    { 1160, 112, -176},
    { 1192, 96, -168},
    { 1112, 8, -192},
    { 1264, -48, -200},
    { 904, -192, -184},
    { 1008, -128, -192},
    { 1192, -8, -112},
    { 1160, 80, -272},
    { 1312, 144, -344},
    { 1288, 168, -376},
    { 896, 200, -280},
    { 704, 256, -288},
    { 856, 328, -344},
    { 1024, 272, -264},
    { 1040, 320, -296},
    { 1024, 392, -344},
    { 1392, 528, -368},
    { 1032, 608, -408},
    { 1656, 600, -408},
    { 992, 536, -440},
    // 29 seconds
    { 1112, 368, -400},
    { 1216, 384, -296},
    { 1136, 280, -240},
    { 888, 248, -216},
    { 888, 216, -216},
    { 1064, 208, -168},
    { 1224, 152, -160},
    { 1216, 112, -192},
    { 1168, 80, -280},
    { 1184, -8, -312},
    { 800, -208, -232},
    { 1384, -128, -136},
    { 1136, 16, -288},
    { 1160, 136, -352},
    { 1344, 128, -336},
    { 1240, 216, -328},
    { 856, 208, -272},
    { 776, 248, -256},
    { 960, 288, -224},
    { 1120, 288, -240},
    { 1064, 280, -280},
    { 1384, 392, -304},
    { 1392, 584, -360},
    { 880, 664, -400},
    { 1624, 672, -488},
    // 30 seconds
    { 904, 488, -400},
    { 1048, 376, -400},
    { 1240, 400, -304},
    { 1328, 312, -248},
    { 1072, 224, -232},
    { 1112, 176, -192},
    { 1360, 200, -240},
    { 1336, 160, -208},
    { 1128, 128, -208},
    { 1224, 80, -256},
    { 1104, 88, -360},
    { 888, -24, -280},
    { 1160, -184, 104},
    { 944, 16, -272},
    { 1144, 128, -280},
    { 1296, 112, -336},
    { 1048, 168, -304},
    { 880, 144, -264},
    { 1048, 264, -216},
    { 1320, 352, -232},
    { 1344, 344, -248},
    { 1232, 480, -440},
    { 1400, 800, -512},
    { 992, 648, -464},
    { 1304, 664, -288},
    // 31 seconds
    { 1096, 592, -264},
    { 1112, 568, -304},
    { 1192, 488, -240},
    { 1264, 392, -248},
    { 1080, 320, -240},
    { 1048, 272, -232},
    { 1232, 280, -184},
    { 1288, 168, -152},
    { 1112, 112, -176},
    { 1000, 8, -216},
    { 1056, -64, -168},
    { 792, -152, -192},
    { 1272, -56, -56},
    { 1200, 72, -224},
    { 1232, 192, -264},
    { 1384, 160, -248},
    { 1224, 176, -240},
    { 888, 192, -240},
    { 824, 272, -264},
    { 984, 264, -272},
    { 1128, 296, -272},
    { 976, 328, -304},
    { 1184, 464, -344},
    { 1232, 552, -232},
    { 1304, 608, -272},
    // 32 seconds
    { 1480, 544, -312},
    { 1144, 432, -352},
    { 1072, 360, -352},
    { 1128, 312, -296},
    { 1016, 192, -216},
    { 816, 144, -88},
    { 888, 224, -200},
    { 1152, 216, -144},
    { 1368, 208, -88},
    { 1208, 144, -152},
    { 1192, 72, -208},
    { 992, -88, -80},
    { 1040, -56, -152},
    { 1192, -8, 0},
    { 1056, 72, -240},
    { 1200, 152, -288},
    { 1216, 112, -368},
    { 944, 136, -312},
    { 680, 136, -256},
    { 752, 216, -320},
    { 1024, 288, -320},
    { 1280, 264, -312},
    { 1184, 336, -304},
    { 1480, 472, -400},
    { 1104, 744, -424},
    // 33 seconds
    { 1304, 600, -392},
    { 1144, 512, -368},
    { 1040, 432, -304},
    { 1192, 392, -216},
    { 1248, 320, -200},
    { 1104, 208, -128},
    { 1032, 272, -160},
    { 1232, 208, -192},
    { 1256, 168, -200},
    { 1072, 56, -200},
    { 856, -56, -200},
    { 1080, -168, -160},
    { 736, -176, -120},
    { 1400, 0, -56},
    { 1328, 104, -200},
    { 1496, 192, -272},
    { 1528, 176, -328},
    { 1128, 168, -280},
    { 808, 224, -320},
    { 800, 264, -264},
    { 968, 320, -312},
    { 1072, 264, -280},
    { 1032, 336, -256},
    { 1256, 552, -360},
    { 936, 584, -272},
    // 34 seconds
    { 1392, 544, -432},
    { 1536, 536, -312},
    { 1128, 424, -304},
    { 1096, 432, -304},
    { 1176, 328, -240},
    { 952, 264, -264},
    { 1008, 128, -168},
    { 1144, 184, -152},
    { 1064, 128, -208},
    { 1056, 112, -240},
    { 1296, 56, -288},
    { 1160, -48, -216},
    { 848, -152, -160},
    { 1360, -104, 120},
    { 1472, 72, -328},
    { 1480, 144, -256},
    { 1544, 160, -288},
    { 1016, 144, -328},
    { 696, 160, -304},
    { 720, 232, -336},
    { 872, 216, -320},
    { 1080, 320, -328},
    { 1280, 424, -256},
    { 1648, 600, -232},
    { 1368, 680, -248},
    // 35 seconds
    { 1320, 672, -368},
    { 1080, 608, -360},
    { 1152, 472, -272},
    { 1352, 400, -160},
    { 1200, 296, -120},
    { 984, 296, -168},
    { 936, 304, -176},
    { 968, 256, -144},
    { 1016, 224, -144},
    { 1104, 200, -168},
    { 1312, 144, -232},
    { 1264, 48, -256},
    { 1072, 8, -320},
    { 1304, 8, -208},
    { 1272, 8, -216},
    { 1360, 120, -280},
    { 1296, 168, -272},
    { 1240, 200, -208},
    { 1008, 272, -304},
    { 792, 280, -256},
    { 728, 288, -200},
    { 832, 352, -288},
    { 960, 336, -312},
    { 1144, 344, -376},
    { 1584, 472, -360},
    // 36 seconds
    { 1400, 568, -432},
    { 1320, 576, -456},
    { 1048, 616, -328},
    { 840, 488, -384},
    { 1168, 536, -336},
    { 1368, 424, -184},
    { 1296, 344, -168},
    { 1104, 224, -112},
    { 1040, 216, -208},
    { 1112, 256, -192},
    { 1112, 184, -200},
    { 1048, 192, -296},
    { 1096, 160, -320},
    { 1152, 96, -328},
    { 1080, 64, -360},
    { 1224, 88, -264},
    { 1128, 80, -216},
    { 1272, 160, -280},
    { 1320, 272, -312},
    { 1224, 392, -472},
    { 752, 312, -400},
    { 608, 416, -440},
    { 616, 344, -392},
    { 776, 376, -368},
    { 1096, 384, -376},
    // 37 seconds
    { 1384, 440, -320},
    { 1624, 616, -440},
    { 1120, 744, -304},
    { 1384, 688, -488},
    { 1072, 752, -408},
    { 1112, 544, -392},
    { 1144, 504, -288},
    { 1216, 408, -216},
    { 1008, 352, -184},
    { 872, 288, -184},
    { 1008, 256, -128},
    { 1272, 248, -176},
    { 1312, 168, -176},
    { 1392, 120, -248},
    { 1200, 8, -248},
    { 776, -128, -312},
    { 1192, 0, -168},
    { 1048, 48, -272},
    { 1184, 80, -392},
    { 1504, 136, -472},
    { 1304, 216, -328},
    { 856, 208, -200},
    { 696, 328, -304},
    { 776, 456, -296},
    { 928, 232, -280},
    // 38 seconds
    { 1112, 336, -208},
    { 1496, 512, -408},
    { 1736, 808, -256},
    { 752, 616, -400},
    { 1552, 824, -240},
    { 1064, 552, -240},
    { 1112, 568, -304},
    { 1240, 560, -296},
    { 1368, 400, -160},
    { 1120, 360, -200},
    { 984, 328, -168},
    { 1120, 232, -168},
    { 1304, 256, -112},
    { 1232, 136, -152},
    { 1200, 120, -296},
    { 1232, 0, -368},
    { 808, -192, -192},
    { 760, -184, -192},
    { 1064, 0, -64},
    { 1160, 176, -240},
    { 1448, 200, -256},
    { 1736, 248, -360},
    { 1256, 312, -264},
    { 784, 320, -272},
    { 872, 272, -320},
    // 39 seconds
    { 1072, 360, -320},
    { 1208, 304, -264},
    { 1072, 376, -296},
    { 1376, 552, -432},
    { 1176, 888, -336},
    { 792, 592, -488},
    { 1456, 656, -328},
    { 1384, 528, -296},
    { 1256, 448, -408},
    { 1200, 424, -288},
    { 1280, 344, -176},
    { 1208, 328, -152},
    { 1304, 256, -64},
    { 1440, 256, -56},
    { 1392, 240, -120},
    { 1112, 128, -152},
    { 984, -40, -184},
    { 1024, -224, -104},
    { 568, -288, -120},
    { 1536, -104, -88},
    { 1344, 24, -216},
    { 1376, 88, -328},
    { 1408, 160, -368},
    { 1208, 168, -312},
    { 1016, 168, -208},
    // 40 seconds
    { 1056, 328, -208},
    { 1240, 368, -216},
    { 1384, 392, -224},
    { 1240, 504, -184},
    { 1296, 696, -240},
    { 1208, 952, -336},
    { 816, 648, -176},
    { 1544, 848, -232},
    { 1320, 512, -360},
    { 1288, 488, -352},
    { 1408, 408, -368},
    { 1352, 400, -232},
    { 1312, 344, -232},
    { 1456, 80, 128},
    { 1552, 160, -24},
    { 1312, 120, -184},
    { 1032, 128, -256},
    { 1056, 96, -248},
    { 1008, -160, 32},
    { 704, -304, -80},
    { 1376, -152, 264},
    { 1360, 48, -208},
    { 1448, 192, -232},
    { 1704, 160, -376},
    { 1392, 168, -344},
    // 41 seconds
    { 1120, 224, -288},
    { 1112, 392, -232},
    { 1272, 464, -320},
    { 1360, 544, -216},
    { 1184, 664, -312},
    { 1240, 848, -200},
    { 1088, 784, -176},
    { 800, 520, -64},
    { 1360, 768, -56},
    { 1432, 816, -304},
    { 1288, 576, -304},
    { 1472, 568, -216},
    { 1376, 456, -192},
    { 1360, 376, -240},
    { 1480, 440, -32},
    { 1392, 184, -16},
    { 1312, 216, -192},
    { 1400, 32, -200},
    { 1168, -240, 80},
    { 1216, -152, -136},
    { 1152, -16, 48},
    { 1592, 160, -200},
    { 1608, 216, -240},
    { 1416, 232, -328},
    { 1104, 224, -312},
    // 42 seconds
    { 816, 224, -296},
    { 712, 240, -240},
    { 816, 312, -328},
    { 992, 352, -328},
    { 1216, 456, -288},
    { 1568, 664, -296},
    { 1328, 848, -184},
    { 1408, 592, -344},
    { 1056, 592, -240},
    { 1120, 384, -344},
    { 1216, 440, -312},
    { 1288, 312, -264},
    { 1096, 248, -280},
    { 920, 200, -248},
    { 960, 128, -136},
    { 1064, 248, -192},
    { 1216, 104, -184},
    { 1320, 104, -208},
    { 1368, 0, -200},
    { 1168, -64, -136},
    { 1336, -80, -272},
    { 1208, 8, -72},
    { 1304, 144, -344},
    { 1456, 176, -328},
    { 1280, 224, -272},
    // 43 seconds
    { 864, 272, -344},
    { 608, 272, -288},
    { 576, 272, -312},
    { 720, 288, -296},
    { 968, 296, -272},
    { 1112, 320, -248},
    { 1664, 472, -264},
    { 1224, 624, -408},
    { 1288, 768, -448},
    { 1136, 672, -472},
    { 1120, 448, -448},
    { 1256, 392, -408},
    { 1368, 328, -368},
    { 1152, 256, -256},
    { 976, 160, -152},
    { 920, 208, -192},
    { 1016, 144, -152},
    { 1088, 104, -160},
    { 1200, 112, -216},
    { 1272, 40, -192},
    { 1000, -56, -208},
    { 1304, -72, -184},
    { 1240, 24, -64},
    { 1408, 104, -264},
    { 1488, 128, -264},
    // 44 seconds
    { 1224, 152, -280},
    { 816, 176, -376},
    { 688, 240, -304},
    { 816, 224, -264},
    { 1080, 312, -304},
    { 1192, 328, -272},
    { 1256, 424, -336},
    { 1560, 624, -432},
    { 1000, 608, -448},
    { 1472, 672, -344},
    { 1224, 552, -392},
    { 1280, 488, -440},
    { 1344, 456, -360},
    { 1464, 352, -264},
    { 1200, 328, -248},
    { 1104, 224, -112},
    { 1240, 184, -96},
    { 1384, 208, -96},
    { 1256, 120, -88},
    { 1120, -8, -136},
    { 1120, -88, -96},
    { 768, -200, -120},
    { 1224, -80, -40},
    { 1256, 40, -200},
    { 1344, 136, -328},
    // 45 seconds
    { 1560, 104, -424},
    { 1408, 192, -376},
    { 936, 224, -352},
    { 792, 232, -352},
    { 984, 304, -312},
    { 1312, 328, -280},
    { 1320, 344, -256},
    { 1360, 448, -312},
    { 1552, 672, -416},
    { 968, 720, -480},
    { 1216, 728, -520},
    { 1008, 472, -448},
    { 1112, 472, -464},
    { 1208, 400, -360},
    { 1432, 400, -264},
    { 1264, 352, -152},
    { 1136, 232, -120},
    { 1176, 248, -128},
    { 1296, 232, -144},
    { 1360, 160, -176},
    { 1192, 88, -160},
    { 1304, -104, -288},
    { 816, -272, -128},
    { 760, -248, -248},
    { 1160, -40, -144},
    // 46 seconds
    { 1256, 192, -288},
    { 1640, 168, -456},
    { 1408, 216, -240},
    { 976, 240, -112},
    { 744, 344, -336},
    { 864, 248, -264},
    { 1088, 184, -256},
    { 1224, 192, -264},
    { 1248, 328, -296},
    { 1816, 616, -448},
    { 1024, 1376, -496},
    { 1712, 800, -632},
    { 920, 584, -424},
    { 1160, 560, -432},
    { 1248, 456, -320},
    { 1240, 336, -232},
    { 1104, 352, -208},
    { 1120, 304, -136},
    { 1208, 272, -96},
    { 1328, 256, -96},
    { 1248, 232, -104},
    { 1304, 104, -120},
    { 1216, 8, -160},
    { 952, -160, -176},
    { 1288, -152, -88},
    // 47 seconds
    { 1096, -56, -160},
    { 1240, 104, -344},
    { 1336, 80, -376},
    { 1264, 160, -416},
    { 1032, 96, -344},
    { 832, 272, -376},
    { 928, 256, -336},
    { 1144, 264, -336},
    { 1272, 296, -304},
    { 1432, 480, -424},
    { 1536, 824, -472},
    { 1128, 656, -520},
    { 1344, 720, -360},
    { 904, 504, -408},
    { 1232, 536, -408},
    { 1392, 400, -296},
    { 1384, 328, -248},
    { 1160, 256, -208},
    { 1088, 192, -184},
    { 1200, 176, -192},
    { 1344, 192, -168},
    { 1296, 88, -224},
    { 1336, 32, -232},
    { 1080, -152, -128},
    { 768, -176, -280},
    // 48 seconds
    { 1176, -96, -64},
    { 1088, 32, -200},
    { 1168, 176, -248},
    { 1424, 128, -336},
    { 1408, 152, -368},
    { 1024, 160, -328},
    { 912, 256, -384},
    { 992, 328, -408},
    { 1184, 360, -392},
    { 1216, 496, -488},
    { 1472, 552, -512},
    { 1352, 736, -456},
    { 992, 624, -472},
    { 1208, 720, -408},
    { 1048, 536, -400},
    { 1392, 496, -304},
    { 1616, 416, -248},
    { 1616, 352, -144},
    { 1304, 208, -120},
    { 1184, 232, -200},
    { 1280, 176, -208},
    { 1320, 112, -200},
    { 1128, 64, -176},
    { 1048, -160, -96},
    { 832, -192, -136},
    // 49 seconds
    { 544, -160, -232},
    { 1160, -64, -120},
    { 1296, 88, -256},
    { 1560, 152, -344},
    { 1728, 112, -416},
    { 1440, 168, -328},
    { 1088, 272, -256},
    { 1024, 224, -360},
    { 1208, 264, -288},
    { 1272, 240, -240},
    { 1176, 280, -264},
    { 1288, 400, -368},
    { 1336, 616, -440},
    { 856, 512, -408},
    { 1280, 592, -512},
    { 1120, 552, -512},
    { 1160, 448, -560},
    { 1440, 456, -472},
    { 1712, 352, -296},
    { 1528, 352, -200},
    { 1392, 128, -88},
    { 1408, 256, -136},
    { 1448, 216, -168},
    { 1368, 184, -136},
    { 1128, 128, -168},
    // 50 seconds
    { 1176, 8, -136},
    { 888, -208, -80},
    { 792, -208, -184},
    { 1192, -144, 8},
    { 1112, 56, -176},
    { 1304, 152, -264},
    { 1424, 136, -272},
    { 1360, 240, -240},
    { 1240, 368, -192},
    { 1272, 424, -216},
    { 1512, 480, -264},
    { 1496, 504, -144},
    { 1384, 880, -520},
    { 1504, 880, -504},
    { 1024, 800, -408},
    { 1192, 704, -344},
    { 1016, 688, -400},
    { 1120, 608, -456},
    { 1336, 560, -256},
    { 1664, 416, -176},
    { 1480, 392, -176},
    { 1368, 280, -120},
    { 1456, 280, -64},
    { 1576, 280, -136},
    { 1432, 208, -40},
    // 51 seconds
    { 1264, 72, -176},
    { 1200, 8, -208},
    { 736, -184, -128},
    { 928, -224, -224},
    { 968, -216, -8},
    { 1248, 48, -304},
    { 1496, 80, -272},
    { 1608, 120, -280},
    { 1288, 216, -320},
    { 960, 264, -312},
    { 976, 408, -400},
    { 1192, 384, -336},
    { 1248, 112, -368},
    { 1392, 256, -520},
    { 1704, 528, -616},
    { 1056, 520, -600},
    { 1552, 632, -672},
    { 1240, 400, -512},
    { 1272, 416, -640},
    { 1344, 296, -384},
    { 1440, 184, -224},
    { 1192, 224, -176},
    { 1096, 104, -112},
    { 1200, 200, -112},
    { 1368, 192, -32},
    // 52 seconds
    { 1272, 144, -8},
    { 1304, 152, -112},
    { 1096, 48, -96},
    { 784, -112, -112},
    { 1088, -104, 56},
    { 1032, -80, -136},
    { 1344, 120, -256},
    { 1616, 8, -352},
    { 1408, 64, -328},
    { 952, 120, -288},
    { 784, 192, -320},
    { 984, 200, -360},
    { 1200, 104, -328},
    { 1192, 264, -376},
    { 1616, 432, -544},
    { 1320, 680, -616},
    { 1160, 568, -512},
    { 1272, 520, -408},
    { 1072, 592, -432},
    { 1120, 472, -368},
    { 1320, 424, -296},
    { 1376, 328, -224},
    { 1208, 208, -144},
    { 1240, 184, -176},
    { 1312, 152, -136},
    // 53 seconds
    { 1240, 168, -192},
    { 1016, 72, -264},
    { 1048, 88, -344},
    { 968, -88, -144},
    { 928, -192, -72},
    { 1096, -176, 176},
    { 1344, 104, -128},
    { 1512, 216, -232},
    { 1592, 304, -320},
    { 1320, 304, -368},
    { 1000, 384, -312},
    { 1000, 368, -408},
    { 1160, 408, -264},
    { 1208, 536, -272},
    { 1088, 600, -280},
    { 1416, 800, -384},
    { 1064, 656, -120},
    { 1392, 712, -168},
    { 1264, 688, -152},
    { 1208, 592, -288},
    { 1216, 552, -256},
    { 1376, 464, -176},
    { 1264, 392, -152},
    { 1176, 296, -112},
    { 1336, 320, -96},
    // 54 seconds
    { 1488, 248, -136},
    { 1328, 176, -176},
    { 1176, 56, -216},
    { 1160, -216, -256},
    { 728, -464, -104},
    { 1168, -120, -80},
    { 1248, 8, -296},
    { 1408, 216, -248},
    { 1648, 112, -320},
    { 1512, 168, -432},
    { 1048, 208, -264},
    { 936, 296, -272},
    { 1040, 368, -344},
    { 1296, 360, -280},
    { 1248, 288, -280},
    { 1280, 488, -400},
    { 1384, 720, -456},
    { 872, 664, -472},
    { 1328, 664, -432},
    { 1056, 512, -360},
    { 1232, 488, -400},
    { 1480, 392, -368},
    { 1768, 320, -264},
    { 1568, 344, -184},
    { 1464, 272, -168},
    // 55 seconds
    { 1384, 328, -160},
    { 1312, 360, -80},
    { 1184, 552, -88},
    { 936, 464, -112},
    { 920, 560, -296},
    { 904, 584, -408},
    { 512, 392, -520},
    { 504, 432, -728},
    { 144, 464, -848},
    { 160, 568, -1040},
    { 272, 520, -1056},
    { 224, 344, -1024},
    { 224, 24, -1064},
    { 168, -104, -944},
    { 120, -264, -808},
    { 152, -312, -712},
    { 368, -352, -736},
    { 552, -376, -712},
    { 832, -416, -952},
    { 1024, -240, -1264},
    { 1160, -248, -1168},
    { 936, -464, -784},
    { 840, -416, -632},
    { 536, -400, -608},
    { 344, -552, -576},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 12:40:37 local
AccelRawData *activity_sample_walk_100_pbl_28397_12(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28397_12
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 48, 64, -968},
    { -16, 96, -1008},
    { 24, 120, -1080},
    { 112, 80, -1096},
    { 24, 88, -1064},
    { -32, 56, -1096},
    { 48, 24, -1032},
    { -8, 40, -1040},
    { -16, 32, -1024},
    { -8, 8, -1040},
    { 32, 88, -1032},
    { -8, 64, -1048},
    { 24, 80, -1040},
    { 32, 96, -1040},
    { 32, 80, -1048},
    { 32, 80, -1064},
    { -24, 112, -1056},
    { 24, 64, -1032},
    { 32, 72, -1032},
    { 40, 72, -1040},
    { 56, 80, -1032},
    { 48, 72, -1040},
    { 56, 72, -1040},
    { 48, 72, -1024},
    { 40, 80, -1032},
    // 1 seconds
    { 48, 72, -1032},
    { 40, 72, -1032},
    { 40, 72, -1040},
    { 48, 64, -1032},
    { 56, 64, -1040},
    { 48, 80, -1032},
    { 48, 64, -1024},
    { 48, 72, -1032},
    { 16, 168, -1088},
    { 56, 72, -1024},
    { 32, 136, -1056},
    { 112, 48, -1048},
    { 88, 72, -1048},
    { 104, 48, -1048},
    { 112, 56, -1040},
    { 112, 16, -1024},
    { 120, 80, -1016},
    { 96, 48, -1016},
    { 64, 128, -1024},
    { 16, 120, -1048},
    { -24, 120, -1080},
    { 24, 88, -1096},
    { 80, 112, -1120},
    { 128, 104, -1096},
    { 200, 72, -1024},
    // 2 seconds
    { 200, 216, -1016},
    { 216, 280, -952},
    { 64, 512, -944},
    { 0, 712, -936},
    { -136, 624, -808},
    { -128, 576, -800},
    { -144, 512, -688},
    { -160, 368, -616},
    { -160, 512, -584},
    { -264, 1000, -600},
    { -320, 984, -512},
    { -280, 960, -344},
    { -288, 1032, -224},
    { -296, 1064, -128},
    { -272, 1000, -24},
    { -272, 1080, 8},
    { -280, 1024, 80},
    { -288, 992, 216},
    { -320, 1072, 232},
    { -288, 1056, 256},
    { -272, 1128, 264},
    { -280, 1168, 240},
    { -184, 1240, 360},
    { 48, 1344, 240},
    { 176, 1200, 272},
    // 3 seconds
    { 136, 1080, 232},
    { 24, 944, 184},
    { -24, 808, 88},
    { -64, 688, 16},
    { -136, 680, 8},
    { -200, 752, 24},
    { -224, 840, 32},
    { -232, 936, 32},
    { -288, 992, -24},
    { -312, 1232, -8},
    { -328, 1392, -64},
    { -280, 1456, -96},
    { -144, 1392, -152},
    { -80, 1128, -32},
    { 64, 960, -8},
    { 104, 840, 40},
    { -24, 848, 72},
    { -80, 800, 16},
    { -88, 752, 8},
    { -152, 752, 8},
    { -176, 888, 8},
    { -200, 864, 80},
    { -232, 960, -8},
    { -408, 1032, -16},
    { -504, 1344, 56},
    // 4 seconds
    { -408, 1440, 64},
    { -472, 1296, 0},
    { -320, 1400, 128},
    { -40, 952, 128},
    { -128, 848, 168},
    { -96, 904, 40},
    { -16, 856, -128},
    { 0, 672, -112},
    { -120, 528, -72},
    { -200, 656, -120},
    { -264, 912, -144},
    { -352, 1096, -136},
    { -384, 1320, -248},
    { -184, 1304, -160},
    { -320, 1608, -248},
    { 64, 1296, -120},
    { 264, 1112, -232},
    { 88, 904, -160},
    { 8, 816, -128},
    { -112, 640, -128},
    { -232, 640, -96},
    { -296, 664, -152},
    { -368, 808, -192},
    { -408, 968, -240},
    { -520, 1224, -136},
    // 5 seconds
    { -272, 1440, -88},
    { -440, 1272, -136},
    { -272, 1608, 152},
    { 88, 1256, -64},
    { -216, 896, 40},
    { -152, 816, -160},
    { -104, 632, -112},
    { -96, 624, -160},
    { -112, 592, -224},
    { -128, 768, -232},
    { -152, 952, -232},
    { -184, 1288, -352},
    { -120, 1136, -272},
    { -256, 1160, -336},
    { -224, 1768, -200},
    { 176, 1288, -240},
    { 96, 1048, -264},
    { 0, 792, -160},
    { -112, 584, -144},
    { -248, 480, -120},
    { -336, 592, -112},
    { -360, 880, -144},
    { -344, 1152, -328},
    { -472, 1272, -336},
    { -344, 1408, -240},
    // 6 seconds
    { -472, 1224, -160},
    { -328, 1408, 112},
    { -88, 1312, 32},
    { -224, 1112, 0},
    { -176, 912, -72},
    { -72, 704, -152},
    { -64, 488, -168},
    { -96, 440, -136},
    { -120, 616, -120},
    { -168, 808, -136},
    { -360, 1136, -240},
    { -192, 1504, -376},
    { -312, 1272, -400},
    { -248, 1616, -264},
    { 128, 1480, -416},
    { 128, 1016, -360},
    { 40, 704, -352},
    { -104, 688, -280},
    { -296, 528, -160},
    { -312, 408, -216},
    { -384, 608, -344},
    { -384, 800, -488},
    { -496, 1048, -488},
    { -480, 1352, -408},
    { -432, 1264, -472},
    // 7 seconds
    { -672, 1312, -280},
    { -72, 1440, -280},
    { -200, 944, -176},
    { -216, 912, -256},
    { -128, 616, -264},
    { -80, 488, -256},
    { -144, 472, -248},
    { -200, 600, -224},
    { -248, 896, -296},
    { -224, 1176, -440},
    { -264, 1384, -552},
    { -296, 1168, -512},
    { -432, 1416, -560},
    { -72, 1280, -504},
    { 56, 1008, -440},
    { -8, 808, -384},
    { 0, 720, -368},
    { -48, 528, -288},
    { -160, 464, -248},
    { -264, 528, -224},
    { -352, 792, -232},
    { -424, 976, -272},
    { -600, 1176, -280},
    { -408, 1368, -288},
    { -544, 1592, -472},
    // 8 seconds
    { -48, 1544, -280},
    { -120, 984, -216},
    { -168, 968, -224},
    { -64, 928, -248},
    { -8, 592, -224},
    { -88, 416, -224},
    { -160, 584, -208},
    { -240, 808, -176},
    { -272, 1008, -280},
    { -296, 1264, -368},
    { -256, 1320, -392},
    { -352, 1096, -440},
    { -256, 1320, -344},
    { 104, 1216, -312},
    { 16, 1088, -344},
    { 8, 928, -352},
    { -32, 736, -344},
    { -168, 544, -264},
    { -304, 544, -264},
    { -384, 704, -288},
    { -360, 912, -320},
    { -440, 1016, -344},
    { -368, 1312, -392},
    { -184, 1088, -488},
    { -568, 1192, -552},
    // 9 seconds
    { -104, 1488, -400},
    { -80, 864, -256},
    { -240, 776, -248},
    { -184, 768, -232},
    { -96, 608, -176},
    { -144, 616, -224},
    { -208, 768, -240},
    { -272, 992, -240},
    { -224, 1192, -416},
    { -328, 1104, -520},
    { -424, 1176, -528},
    { -336, 1080, -640},
    { -192, 1240, -464},
    { 152, 1224, -304},
    { 80, 1008, -232},
    { 16, 824, -280},
    { -128, 648, -280},
    { -248, 504, -232},
    { -352, 560, -280},
    { -384, 728, -344},
    { -432, 904, -392},
    { -376, 1104, -488},
    { -400, 1208, -472},
    { -248, 1096, -528},
    { -584, 1208, -392},
    // 10 seconds
    { -112, 1448, -224},
    { -112, 1032, -160},
    { -248, 1016, -192},
    { -168, 752, -224},
    { -104, 528, -208},
    { -144, 552, -192},
    { -216, 672, -264},
    { -248, 920, -288},
    { -248, 1184, -376},
    { -344, 1312, -440},
    { -304, 1184, -368},
    { -480, 1424, -440},
    { -104, 1336, -392},
    { 120, 1184, -408},
    { -24, 856, -352},
    { -80, 696, -352},
    { -80, 480, -280},
    { -176, 448, -240},
    { -248, 520, -208},
    { -320, 696, -256},
    { -384, 896, -328},
    { -560, 1296, -376},
    { -304, 1456, -520},
    { -568, 1496, -616},
    { -128, 1616, -360},
    // 11 seconds
    { -72, 904, -248},
    { -256, 760, -128},
    { -192, 856, -200},
    { -88, 696, -184},
    { -136, 520, -192},
    { -160, 584, -200},
    { -152, 792, -208},
    { -200, 984, -264},
    { -288, 1192, -352},
    { -344, 1288, -344},
    { -424, 1240, -424},
    { -312, 1576, -400},
    { 224, 1336, -368},
    { 56, 912, -280},
    { -8, 824, -224},
    { -16, 632, -240},
    { -120, 512, -208},
    { -208, 528, -208},
    { -288, 648, -224},
    { -352, 896, -312},
    { -368, 1184, -424},
    { -528, 1248, -368},
    { -384, 1400, -304},
    { -552, 1408, -240},
    { -144, 1424, -96},
    // 12 seconds
    { -88, 984, -120},
    { -192, 872, -88},
    { -152, 856, -176},
    { -56, 696, -160},
    { -128, 528, -152},
    { -192, 560, -168},
    { -272, 768, -176},
    { -296, 1040, -192},
    { -360, 1352, -288},
    { -320, 1464, -312},
    { -392, 1216, -336},
    { -352, 1392, -368},
    { 72, 1216, -296},
    { 112, 872, -320},
    { -8, 760, -240},
    { -88, 680, -232},
    { -176, 624, -200},
    { -336, 624, -176},
    { -408, 680, -216},
    { -456, 752, -224},
    { -496, 888, -256},
    { -584, 1184, -256},
    { -352, 1424, -376},
    { -544, 1464, -456},
    { -224, 1528, -208},
    // 13 seconds
    { -40, 904, -80},
    { -176, 784, -80},
    { -168, 824, -240},
    { -104, 704, -208},
    { -160, 576, -232},
    { -224, 688, -248},
    { -288, 936, -256},
    { -240, 1104, -304},
    { -264, 1208, -456},
    { -208, 1208, -512},
    { -280, 1208, -584},
    { -40, 1336, -408},
    { 184, 1200, -360},
    { 24, 832, -352},
    { -56, 752, -320},
    { -136, 632, -256},
    { -200, 600, -200},
    { -312, 600, -208},
    { -384, 776, -280},
    { -392, 808, -368},
    { -472, 864, -416},
    { -504, 1248, -440},
    { -312, 1368, -384},
    { -464, 1320, -328},
    { -248, 1384, -208},
    // 14 seconds
    { -208, 1032, -136},
    { -232, 1000, -128},
    { -192, 904, -184},
    { -80, 688, -160},
    { -96, 560, -176},
    { -144, 656, -192},
    { -200, 856, -208},
    { -232, 1096, -280},
    { -240, 1152, -360},
    { -256, 1120, -320},
    { -240, 1064, -368},
    { -248, 1320, -200},
    { 168, 1448, -352},
    { 184, 1064, -376},
    { 16, 872, -392},
    { -16, 752, -376},
    { -96, 640, -288},
    { -264, 592, -240},
    { -304, 760, -256},
    { -376, 808, -160},
    { -456, 880, -248},
    { -456, 1392, -448},
    { -216, 1136, -464},
    { -464, 1544, -568},
    { 40, 1440, -424},
    // 15 seconds
    { 0, 1000, -312},
    { -64, 816, -256},
    { -48, 776, -296},
    { 16, 624, -280},
    { 16, 536, -256},
    { -8, 672, -224},
    { -64, 904, -224},
    { -208, 1040, -360},
    { -312, 1184, -496},
    { -392, 1376, -480},
    { -328, 1336, -432},
    { -216, 1504, -368},
    { 288, 1152, -320},
    { 160, 848, -344},
    { 112, 744, -320},
    { 8, 616, -336},
    { -120, 528, -304},
    { -232, 600, -320},
    { -280, 728, -368},
    { -312, 912, -400},
    { -344, 920, -456},
    { -464, 1136, -496},
    { -272, 1176, -504},
    { -456, 1464, -576},
    { 40, 1296, -416},
    // 16 seconds
    { -96, 912, -352},
    { -104, 864, -312},
    { -72, 824, -336},
    { -40, 632, -280},
    { -112, 512, -296},
    { -200, 640, -296},
    { -248, 912, -328},
    { -200, 1112, -408},
    { -232, 1240, -584},
    { -184, 1176, -544},
    { -208, 920, -568},
    { -296, 1232, -512},
    { 176, 1312, -392},
    { 184, 984, -448},
    { 56, 840, -440},
    { -8, 648, -392},
    { -136, 512, -320},
    { -272, 536, -304},
    { -376, 664, -312},
    { -416, 848, -336},
    { -448, 1000, -416},
    { -520, 1160, -480},
    { -328, 1136, -560},
    { -616, 1216, -520},
    { -32, 1544, -368},
    // 17 seconds
    { -144, 960, -248},
    { -168, 968, -256},
    { -72, 800, -224},
    { -48, 536, -232},
    { -136, 528, -280},
    { -240, 616, -256},
    { -272, 880, -312},
    { -240, 1120, -408},
    { -288, 1288, -528},
    { -272, 1064, -456},
    { -376, 1144, -528},
    { -168, 1496, -480},
    { 272, 1232, -456},
    { 88, 864, -392},
    { -40, 760, -376},
    { -48, 576, -312},
    { -176, 528, -264},
    { -288, 552, -280},
    { -376, 728, -320},
    { -376, 848, -360},
    { -576, 976, -376},
    { -472, 1256, -408},
    { -488, 1216, -464},
    { -352, 1808, -336},
    { 32, 1256, -312},
    // 18 seconds
    { -168, 936, -224},
    { -112, 976, -264},
    { -56, 688, -200},
    { -96, 440, -216},
    { -152, 504, -240},
    { -192, 720, -248},
    { -232, 928, -296},
    { -232, 1272, -472},
    { -232, 1232, -480},
    { -296, 976, -464},
    { -376, 1264, -496},
    { 40, 1304, -384},
    { 112, 1136, -384},
    { 0, 1016, -376},
    { 8, 760, -352},
    { -96, 480, -272},
    { -200, 440, -280},
    { -312, 624, -280},
    { -344, 824, -304},
    { -352, 992, -400},
    { -440, 1264, -496},
    { -240, 1248, -600},
    { -408, 1576, -568},
    { 80, 1392, -480},
    { -48, 824, -296},
    // 19 seconds
    { -112, 880, -400},
    { -64, 808, -344},
    { -80, 528, -288},
    { -120, 472, -296},
    { -168, 584, -312},
    { -168, 792, -312},
    { -184, 936, -432},
    { -360, 1256, -632},
    { -192, 1200, -584},
    { -400, 1368, -776},
    { -56, 1296, -688},
    { 240, 1000, -568},
    { 152, 776, -520},
    { 48, 736, -424},
    { -80, 536, -288},
    { -232, 520, -280},
    { -368, 552, -288},
    { -448, 712, -392},
    { -464, 936, -536},
    { -472, 1048, -528},
    { -272, 1312, -600},
    { -312, 1232, -544},
    { -152, 1480, -432},
    { -104, 992, -304},
    { -248, 984, -304},
    // 20 seconds
    { -176, 1048, -320},
    { -120, 768, -264},
    { -112, 504, -224},
    { -168, 528, -216},
    { -176, 800, -288},
    { -120, 952, -392},
    { -160, 1264, -672},
    { -176, 1080, -680},
    { -312, 976, -752},
    { -376, 1464, -600},
    { 112, 1368, -504},
    { 56, 832, -392},
    { -16, 704, -424},
    { -64, 536, -336},
    { -152, 416, -232},
    { -264, 480, -272},
    { -368, 648, -320},
    { -400, 832, -384},
    { -464, 976, -512},
    { -640, 1104, -632},
    { -384, 1096, -624},
    { -664, 1264, -608},
    { -88, 1520, -496},
    { -88, 888, -264},
    { -136, 904, -360},
    // 21 seconds
    { -96, 784, -296},
    { -112, 512, -232},
    { -168, 480, -280},
    { -264, 656, -288},
    { -264, 896, -368},
    { -224, 1160, -504},
    { -304, 1152, -568},
    { -264, 1112, -552},
    { -256, 1064, -536},
    { -56, 1432, -624},
    { 352, 1104, -512},
    { 88, 784, -464},
    { 16, 800, -424},
    { -16, 712, -352},
    { -112, 616, -328},
    { -176, 584, -328},
    { -272, 688, -376},
    { -320, 800, -440},
    { -432, 872, -488},
    { -576, 1112, -528},
    { -368, 1168, -648},
    { -632, 1312, -616},
    { -184, 1560, -568},
    { -48, 888, -296},
    { -120, 824, -328},
    // 22 seconds
    { -128, 760, -304},
    { -112, 624, -240},
    { -120, 624, -304},
    { -176, 696, -304},
    { -208, 816, -376},
    { -240, 864, -496},
    { -376, 992, -568},
    { -352, 1136, -592},
    { -320, 1136, -680},
    { -328, 1400, -664},
    { 152, 1224, -608},
    { 112, 720, -496},
    { 8, 688, -464},
    { -16, 648, -448},
    { -72, 520, -368},
    { -152, 504, -376},
    { -272, 632, -392},
    { -360, 856, -480},
    { -392, 944, -536},
    { -552, 1112, -608},
    { -368, 1152, -648},
    { -632, 1280, -608},
    { -120, 1456, -480},
    { -80, 928, -352},
    { -128, 824, -368},
    // 23 seconds
    { -104, 752, -344},
    { -80, 520, -280},
    { -128, 448, -376},
    { -248, 608, -400},
    { -256, 960, -512},
    { -144, 1136, -632},
    { -200, 1008, -704},
    { -200, 1008, -648},
    { -376, 936, -704},
    { -192, 1432, -776},
    { 280, 1128, -560},
    { 8, 800, -400},
    { -32, 888, -424},
    { -88, 568, -288},
    { -192, 480, -288},
    { -296, 608, -336},
    { -312, 696, -416},
    { -368, 792, -536},
    { -456, 808, -600},
    { -504, 992, -584},
    { -360, 1072, -584},
    { -432, 1600, -640},
    { 8, 1232, -480},
    { -56, 904, -400},
    { -144, 896, -424},
    // 24 seconds
    { -88, 672, -344},
    { -88, 440, -272},
    { -152, 480, -280},
    { -256, 744, -312},
    { -280, 1120, -416},
    { -200, 1144, -504},
    { -336, 1096, -584},
    { -352, 1048, -584},
    { -384, 1040, -600},
    { -32, 1464, -656},
    { 280, 1160, -480},
    { 112, 832, -496},
    { 24, 720, -504},
    { -32, 504, -360},
    { -168, 440, -344},
    { -312, 576, -344},
    { -384, 736, -432},
    { -424, 856, -560},
    { -504, 912, -600},
    { -536, 1152, -544},
    { -280, 1048, -592},
    { -560, 1152, -576},
    { -96, 1488, -528},
    { -32, 832, -344},
    { -112, 872, -344},
    // 25 seconds
    { -104, 808, -368},
    { -112, 616, -304},
    { -184, 504, -288},
    { -264, 712, -352},
    { -280, 912, -440},
    { -200, 1160, -584},
    { -184, 1048, -632},
    { -192, 1072, -664},
    { -224, 896, -632},
    { -336, 1048, -560},
    { -8, 1280, -560},
    { 72, 1056, -456},
    { -32, 920, -480},
    { -56, 664, -432},
    { -144, 488, -280},
    { -288, 528, -256},
    { -448, 648, -256},
    { -544, 832, -352},
    { -520, 904, -464},
    { -528, 1088, -568},
    { -304, 1152, -608},
    { -408, 1456, -760},
    { 24, 1272, -608},
    { 0, 784, -448},
    { -32, 800, -400},
    // 26 seconds
    { 0, 688, -328},
    { -40, 552, -312},
    { -120, 536, -312},
    { -200, 712, -384},
    { -256, 944, -480},
    { -200, 1104, -544},
    { -264, 1232, -632},
    { -200, 1120, -584},
    { -304, 1032, -600},
    { -136, 1248, -600},
    { 216, 1016, -472},
    { 64, 840, -456},
    { 8, 832, -432},
    { 24, 728, -384},
    { -40, 560, -368},
    { -176, 536, -352},
    { -296, 712, -416},
    { -384, 784, -448},
    { -432, 864, -512},
    { -576, 1016, -528},
    { -424, 1096, -576},
    { -528, 1264, -616},
    { -96, 1696, -648},
    { -72, 1064, -448},
    { -112, 888, -384},
    // 27 seconds
    { -88, 768, -352},
    { -56, 488, -264},
    { -136, 464, -248},
    { -192, 624, -248},
    { -200, 928, -328},
    { -176, 1104, -432},
    { -176, 1152, -488},
    { -224, 1152, -488},
    { -192, 1024, -512},
    { -272, 1304, -520},
    { 152, 1312, -520},
    { 208, 1032, -472},
    { 40, 888, -416},
    { 32, 632, -320},
    { -136, 472, -240},
    { -264, 536, -216},
    { -336, 720, -280},
    { -400, 928, -360},
    { -408, 984, -464},
    { -496, 1248, -536},
    { -320, 1192, -568},
    { -544, 1272, -480},
    { -152, 1304, -440},
    { -168, 952, -296},
    { -136, 880, -296},
    // 28 seconds
    { -112, 816, -272},
    { -40, 576, -256},
    { -120, 504, -240},
    { -176, 608, -280},
    { -248, 896, -352},
    { -224, 1120, -504},
    { -288, 1312, -608},
    { -232, 1208, -608},
    { -248, 1088, -600},
    { -128, 1248, -520},
    { 192, 1120, -512},
    { 72, 904, -456},
    { 8, 744, -424},
    { -96, 608, -336},
    { -168, 584, -272},
    { -296, 600, -264},
    { -360, 648, -320},
    { -408, 800, -400},
    { -544, 944, -504},
    { -592, 1168, -368},
    { -352, 1384, -272},
    { -504, 1608, 0},
    { 32, 1360, -112},
    { -56, 832, -48},
    { -136, 848, 40},
    // 29 seconds
    { -96, 792, -64},
    { -96, 688, -144},
    { -184, 520, -160},
    { -256, 648, -176},
    { -304, 912, -168},
    { -344, 1344, -240},
    { -344, 1472, -320},
    { -264, 1376, -304},
    { -208, 1224, -336},
    { -112, 1328, -200},
    { 272, 1136, -224},
    { 120, 896, -232},
    { 56, 752, -224},
    { -32, 592, -200},
    { -168, 536, -200},
    { -288, 640, -232},
    { -344, 768, -280},
    { -376, 968, -360},
    { -504, 1088, -368},
    { -560, 1352, -328},
    { -472, 1408, -368},
    { -264, 1824, -304},
    { 48, 992, -288},
    { -168, 640, -120},
    { -136, 752, -120},
    // 30 seconds
    { -104, 808, -144},
    { -72, 640, -104},
    { -144, 656, -192},
    { -192, 728, -184},
    { -264, 1008, -240},
    { -240, 1288, -352},
    { -232, 1384, -464},
    { -240, 1328, -472},
    { -272, 1112, -528},
    { -128, 1112, -480},
    { 160, 1072, -392},
    { 56, 912, -376},
    { 80, 752, -368},
    { 0, 688, -368},
    { -88, 600, -344},
    { -176, 560, -328},
    { -272, 576, -368},
    { -440, 744, -416},
    { -544, 880, -464},
    { -664, 1072, -488},
    { -456, 1312, -528},
    { -456, 1160, -520},
    { -408, 1328, -456},
    { -96, 1000, -360},
    { -240, 848, -264},
    // 31 seconds
    { -200, 784, -304},
    { -152, 776, -264},
    { -112, 608, -280},
    { -160, 608, -344},
    { -192, 696, -384},
    { -208, 896, -464},
    { -240, 1112, -608},
    { -336, 1192, -592},
    { -248, 976, -536},
    { -440, 968, -488},
    { -320, 1160, -536},
    { -16, 1376, -536},
    { 24, 1096, -504},
    { 0, 808, -480},
    { -40, 456, -328},
    { -128, 424, -280},
    { -288, 456, -304},
    { -368, 672, -328},
    { -344, 824, -376},
    { -432, 1008, -472},
    { -368, 1336, -568},
    { -376, 1240, -600},
    { -272, 1696, -736},
    { -56, 1016, -448},
    { -128, 856, -384},
    // 32 seconds
    { -208, 904, -376},
    { -88, 808, -352},
    { -104, 496, -288},
    { -184, 472, -328},
    { -224, 600, -360},
    { -160, 872, -472},
    { -104, 1104, -608},
    { -144, 1152, -680},
    { -192, 912, -584},
    { -360, 1216, -728},
    { -8, 1400, -696},
    { 128, 1144, -568},
    { 24, 832, -624},
    { 40, 552, -488},
    { -32, 424, -344},
    { -160, 528, -328},
    { -288, 560, -304},
    { -392, 768, -376},
    { -424, 880, -400},
    { -624, 1080, -480},
    { -464, 1104, -528},
    { -568, 1088, -528},
    { -472, 1520, -656},
    { -64, 1064, -488},
    { -232, 848, -368},
    // 33 seconds
    { -240, 904, -416},
    { -152, 704, -312},
    { -120, 600, -296},
    { -152, 560, -320},
    { -232, 656, -328},
    { -232, 856, -416},
    { -232, 1024, -552},
    { -232, 1160, -600},
    { -240, 992, -592},
    { -368, 1088, -696},
    { -288, 1120, -664},
    { -48, 1104, -728},
    { -24, 888, -696},
    { 32, 640, -664},
    { -32, 408, -432},
    { -136, 400, -392},
    { -248, 488, -352},
    { -368, 632, -360},
    { -408, 784, -408},
    { -552, 880, -432},
    { -584, 1120, -552},
    { -320, 1240, -608},
    { -592, 1216, -584},
    { -152, 1288, -592},
    { -24, 968, -416},
    // 34 seconds
    { -32, 888, -512},
    { 0, 840, -488},
    { -32, 672, -400},
    { -120, 632, -440},
    { -144, 672, -440},
    { -128, 784, -536},
    { -144, 856, -608},
    { -176, 872, -632},
    { -216, 984, -648},
    { -128, 824, -520},
    { -256, 1080, -488},
    { 240, 1304, -504},
    { 192, 1280, -552},
    { 72, 1096, -568},
    { -40, 744, -472},
    { -176, 480, -352},
    { -264, 544, -344},
    { -336, 624, -352},
    { -320, 832, -464},
    { -376, 896, -512},
    { -488, 1128, -520},
    { -264, 1200, -576},
    { -448, 1184, -592},
    { -144, 1392, -584},
    { 80, 968, -392},
    // 35 seconds
    { -112, 832, -352},
    { -168, 768, -416},
    { -112, 728, -376},
    { -168, 544, -304},
    { -240, 544, -344},
    { -288, 752, -312},
    { -256, 984, -392},
    { -240, 992, -456},
    { -376, 1136, -536},
    { -288, 1056, -560},
    { -152, 936, -568},
    { -264, 1144, -464},
    { 264, 1144, -264},
    { 160, 1184, -264},
    { 40, 1192, -400},
    { -56, 848, -352},
    { -240, 584, -328},
    { -328, 488, -304},
    { -424, 600, -280},
    { -464, 768, -208},
    { -424, 976, -104},
    { -536, 1360, -96},
    { -136, 1408, -80},
    { -448, 1320, -256},
    { -112, 1440, -24},
    // 36 seconds
    { 64, 1144, -120},
    { -88, 904, -40},
    { -120, 800, -96},
    { -80, 840, -120},
    { -104, 640, -144},
    { -200, 552, -160},
    { -296, 664, -128},
    { -312, 1000, -128},
    { -296, 1280, -200},
    { -272, 1368, -288},
    { -232, 1200, -224},
    { -136, 976, -208},
    { -176, 1568, -200},
    { 328, 1304, -112},
    { 176, 1272, -192},
    { -24, 848, -224},
    { -128, 584, -176},
    { -224, 512, -112},
    { -296, 680, -144},
    { -328, 904, -152},
    { -256, 1080, -152},
    { -192, 1392, -304},
    { -152, 1400, -384},
    { -384, 1608, -224},
    { 224, 1624, -192},
    // 37 seconds
    { 216, 1272, -88},
    { -24, 920, -192},
    { -72, 536, -152},
    { -152, 368, -72},
    { -128, 440, -104},
    { -160, 576, -40},
    { -192, 840, -40},
    { -288, 1080, 8},
    { -360, 1416, -16},
    { -440, 1456, -312},
    { -432, 1520, -520},
    { -160, 1760, 48},
    { 424, 1272, 40},
    { 224, 1064, -32},
    { 176, 912, -184},
    { 64, 608, -280},
    { -8, 480, -296},
    { -88, 456, -288},
    { -112, 464, -272},
    { -184, 632, -352},
    { -320, 920, -456},
    { -392, 1200, -488},
    { -488, 1552, -472},
    { -616, 1696, -416},
    { -168, 1672, -272},
    // 38 seconds
    { 48, 1112, -280},
    { -32, 888, -128},
    { -88, 792, -112},
    { -64, 552, -80},
    { -96, 480, -64},
    { -104, 520, -96},
    { -160, 656, -104},
    { -256, 944, -200},
    { -328, 1184, -312},
    { -264, 1480, -496},
    { -264, 1192, -520},
    { -416, 1240, -632},
    { -120, 1272, -488},
    { 248, 1176, -440},
    { 112, 1032, -464},
    { 80, 800, -424},
    { -16, 488, -320},
    { -104, 424, -320},
    { -192, 424, -304},
    { -280, 600, -392},
    { -376, 720, -512},
    { -560, 896, -464},
    { -696, 1224, -432},
    { -464, 1376, -472},
    { -280, 1752, -672},
    // 39 seconds
    { -24, 1160, -416},
    { -176, 864, -296},
    { -224, 704, -192},
    { -144, 712, -256},
    { -136, 600, -216},
    { -176, 568, -224},
    { -216, 648, -232},
    { -304, 824, -280},
    { -296, 1088, -392},
    { -344, 1136, -520},
    { -424, 1272, -664},
    { -304, 984, -632},
    { -392, 1072, -672},
    { -104, 1112, -680},
    { 168, 1056, -592},
    { 48, 880, -632},
    { 40, 616, -560},
    { 0, 432, -416},
    { -120, 520, -384},
    { -224, 496, -400},
    { -312, 560, -456},
    { -352, 736, -504},
    { -488, 792, -560},
    { -600, 1016, -664},
    { -480, 976, -648},
    // 40 seconds
    { -720, 1288, -792},
    { -168, 1424, -824},
    { -80, 968, -528},
    { -160, 952, -544},
    { -112, 856, -528},
    { -48, 560, -376},
    { -88, 368, -328},
    { -168, 440, -384},
    { -224, 624, -416},
    { -200, 752, -528},
    { -264, 936, -672},
    { -312, 984, -624},
    { -232, 880, -584},
    { -432, 912, -552},
    { -288, 1568, -744},
    { 128, 1184, -688},
    { 96, 1208, -736},
    { 96, 784, -560},
    { -16, 424, -384},
    { -120, 464, -336},
    { -240, 480, -288},
    { -320, 600, -296},
    { -392, 776, -416},
    { -480, 880, -472},
    { -560, 1128, -616},
    // 41 seconds
    { -256, 992, -528},
    { -568, 1312, -648},
    { -136, 1456, -632},
    { -24, 1136, -552},
    { -104, 896, -512},
    { -120, 808, -464},
    { -120, 640, -360},
    { -128, 480, -272},
    { -160, 456, -288},
    { -240, 552, -288},
    { -296, 816, -368},
    { -248, 968, -472},
    { -320, 1168, -608},
    { -296, 1144, -592},
    { -184, 840, -544},
    { -424, 1184, -640},
    { 160, 1480, -760},
    { 208, 1304, -656},
    { 64, 976, -624},
    { -112, 592, -312},
    { -256, 592, -280},
    { -256, 536, -208},
    { -288, 568, -272},
    { -296, 648, -352},
    { -440, 968, -472},
    // 42 seconds
    { -216, 1488, -752},
    { -32, 1168, -632},
    { -272, 1616, -744},
    { 136, 1464, -504},
    { 80, 1224, -384},
    { 96, 976, -320},
    { 40, 848, -328},
    { -40, 648, -344},
    { -104, 512, -296},
    { -112, 456, -256},
    { -128, 488, -256},
    { -160, 552, -224},
    { -224, 832, -336},
    { -336, 1160, -448},
    { -320, 1544, -624},
    { -320, 1376, -720},
    { -320, 1376, -712},
    { 8, 1184, -640},
    { 376, 1112, -536},
    { 280, 896, -464},
    { 176, 600, -408},
    { -8, 432, -328},
    { -152, 456, -296},
    { -240, 504, -288},
    { -360, 608, -336},
    // 43 seconds
    { -352, 808, -432},
    { -472, 1040, -488},
    { -416, 1288, -568},
    { -280, 1576, -608},
    { 48, 1816, -584},
    { 64, 1360, -424},
    { 64, 1064, -280},
    { 56, 904, -280},
    { 56, 584, -256},
    { 8, 416, -240},
    { 0, 416, -176},
    { -56, 496, -152},
    { -176, 704, -256},
    { -184, 1112, -368},
    { -232, 1312, -472},
    { -240, 1576, -456},
    { -216, 1560, -352},
    { -112, 1552, -248},
    { 216, 1304, -72},
    { 456, 1192, -168},
    { 328, 976, -120},
    { 176, 824, -128},
    { 40, 520, -264},
    { -56, 504, -312},
    { -128, 520, -272},
    // 44 seconds
    { -224, 552, -272},
    { -304, 736, -312},
    { -424, 920, -368},
    { -576, 1208, -456},
    { -456, 1376, -488},
    { -440, 1232, -456},
    { -296, 1520, -392},
    { 8, 1216, -304},
    { -56, 896, -216},
    { -88, 744, -304},
    { -72, 600, -328},
    { -88, 552, -288},
    { -152, 512, -264},
    { -192, 680, -336},
    { -232, 928, -384},
    { -224, 1160, -488},
    { -248, 1320, -600},
    { -216, 1200, -576},
    { -288, 1208, -640},
    { -24, 1208, -608},
    { 200, 1032, -544},
    { 112, 848, -536},
    { 40, 800, -472},
    { 32, 680, -440},
    { -80, 520, -368},
    // 45 seconds
    { -184, 488, -344},
    { -256, 536, -336},
    { -344, 728, -384},
    { -520, 920, -448},
    { -632, 1224, -568},
    { -376, 1168, -600},
    { -584, 1296, -608},
    { -144, 1528, -584},
    { -56, 840, -360},
    { -120, 800, -304},
    { -152, 832, -344},
    { -88, 672, -272},
    { -112, 512, -256},
    { -192, 560, -280},
    { -288, 824, -312},
    { -280, 1120, -432},
    { -248, 1184, -552},
    { -240, 1248, -608},
    { -176, 1080, -560},
    { -256, 1144, -520},
    { -32, 1152, -480},
    { 184, 1120, -536},
    { 104, 808, -448},
    { 16, 624, -384},
    { -56, 512, -320},
    // 46 seconds
    { -144, 560, -312},
    { -264, 656, -352},
    { -336, 896, -448},
    { -384, 936, -464},
    { -616, 1000, -512},
    { -520, 1056, -576},
    { -712, 1184, -488},
    { -344, 1712, -712},
    { -80, 912, -384},
    { -184, 736, -368},
    { -224, 880, -424},
    { -176, 584, -256},
    { -104, 504, -264},
    { -184, 560, -360},
    { -248, 688, -400},
    { -232, 896, -488},
    { -280, 1144, -672},
    { -184, 1088, -624},
    { -272, 920, -600},
    { -352, 1224, -704},
    { -56, 1240, -672},
    { 8, 1064, -672},
    { 8, 760, -664},
    { 0, 480, -464},
    { -64, 344, -368},
    // 47 seconds
    { -168, 480, -328},
    { -376, 600, -200},
    { -600, 848, -272},
    { -576, 992, -352},
    { -648, 1160, -472},
    { -432, 1080, -632},
    { -584, 1512, -784},
    { -32, 1288, -520},
    { -200, 640, -320},
    { -312, 784, -352},
    { -208, 824, -296},
    { -96, 688, -288},
    { -144, 568, -296},
    { -200, 608, -312},
    { -248, 824, -400},
    { -208, 1072, -536},
    { -232, 1320, -680},
    { -200, 1032, -600},
    { -408, 1272, -768},
    { -136, 1248, -688},
    { 112, 984, -624},
    { -8, 672, -600},
    { -32, 568, -480},
    { -80, 432, -344},
    { -216, 568, -320},
    // 48 seconds
    { -336, 600, -304},
    { -424, 736, -360},
    { -464, 800, -416},
    { -680, 960, -464},
    { -512, 1160, -576},
    { -584, 1128, -648},
    { -416, 1616, -648},
    { -16, 1048, -376},
    { -192, 680, -344},
    { -192, 848, -392},
    { -64, 688, -320},
    { -64, 504, -328},
    { -128, 504, -336},
    { -224, 712, -352},
    { -296, 984, -472},
    { -312, 1152, -616},
    { -336, 1184, -568},
    { -264, 1144, -576},
    { -304, 1232, -520},
    { 24, 1288, -512},
    { 120, 1096, -464},
    { 0, 824, -464},
    { -40, 584, -416},
    { -32, 520, -304},
    { -144, 512, -224},
    // 49 seconds
    { -288, 608, -344},
    { -368, 816, -368},
    { -408, 920, -392},
    { -528, 1112, -520},
    { -440, 1224, -600},
    { -536, 1096, -640},
    { -168, 1376, -704},
    { 8, 1008, -504},
    { -96, 936, -464},
    { -120, 840, -464},
    { -112, 568, -312},
    { -136, 488, -280},
    { -184, 576, -272},
    { -232, 784, -336},
    { -232, 1000, -512},
    { -184, 1240, -704},
    { -104, 1104, -624},
    { -112, 968, -712},
    { -128, 1208, -688},
    { 288, 1232, -656},
    { 208, 912, -616},
    { 56, 816, -584},
    { -40, 640, -432},
    { -152, 512, -312},
    { -240, 528, -344},
    // 50 seconds
    { -336, 608, -392},
    { -368, 720, -432},
    { -512, 912, -520},
    { -464, 1216, -624},
    { -416, 1072, -632},
    { -376, 1616, -712},
    { 80, 1176, -480},
    { -112, 816, -344},
    { -152, 912, -368},
    { -80, 712, -296},
    { -104, 488, -248},
    { -120, 480, -264},
    { -192, 600, -272},
    { -264, 888, -376},
    { -216, 1208, -576},
    { -168, 1272, -672},
    { -192, 1128, -632},
    { -312, 1256, -712},
    { 32, 1352, -712},
    { 280, 1032, -584},
    { 112, 816, -608},
    { 16, 624, -456},
    { -56, 440, -344},
    { -160, 456, -336},
    { -248, 520, -296},
    // 51 seconds
    { -328, 680, -352},
    { -368, 872, -464},
    { -520, 1024, -520},
    { -352, 1200, -608},
    { -600, 1504, -776},
    { 40, 1560, -672},
    { -64, 968, -480},
    { -120, 912, -480},
    { -72, 832, -424},
    { -72, 536, -312},
    { -88, 440, -272},
    { -160, 528, -296},
    { -192, 712, -312},
    { -232, 920, -464},
    { -208, 1048, -576},
    { -296, 1040, -608},
    { -264, 928, -512},
    { -352, 1008, -616},
    { -40, 1568, -712},
    { 328, 1168, -632},
    { 168, 1016, -664},
    { 0, 808, -536},
    { -80, 544, -392},
    { -184, 504, -328},
    { -280, 528, -264},
    // 52 seconds
    { -368, 672, -272},
    { -400, 744, -296},
    { -496, 832, -352},
    { -448, 1160, -416},
    { -216, 1200, -480},
    { -632, 1312, -520},
    { -96, 1736, -504},
    { -48, 992, -344},
    { -152, 992, -400},
    { -72, 1048, -368},
    { 16, 736, -272},
    { -64, 520, -312},
    { -88, 584, -320},
    { -128, 712, -288},
    { -176, 984, -392},
    { -176, 1024, -472},
    { -264, 1032, -512},
    { -312, 992, -520},
    { -240, 912, -568},
    { -304, 824, -600},
    { -424, 1096, -624},
    { -40, 1096, -600},
    { -16, 800, -528},
    { 64, 792, -480},
    { 168, 1112, -424},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 12:41:47 local
AccelRawData *activity_sample_walk_100_pbl_28397_13(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28397_13
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -80, 640, -824},
    { -120, 648, -768},
    { -128, 584, -728},
    { -128, 800, -808},
    { -128, 568, -816},
    { -112, 544, -904},
    { -48, 368, -928},
    { 40, 176, -952},
    { 88, 104, -992},
    { 192, 24, -1016},
    { 272, -48, -1040},
    { -24, 104, -1176},
    { 400, 24, -1136},
    { 208, -8, -1120},
    { 128, 16, -944},
    { 544, -144, -1096},
    { 192, 64, -1128},
    { 56, 8, -1024},
    { 192, 24, -952},
    { 136, 96, -1048},
    { 80, 56, -1008},
    { 40, 96, -1032},
    { 72, 128, -1016},
    { 192, 160, -1024},
    { 16, 136, -1000},
    // 1 seconds
    { 24, 104, -1032},
    { 40, 88, -1072},
    { 48, 72, -1088},
    { -8, 168, -1080},
    { 8, 176, -1112},
    { 216, -240, -1024},
    { 280, -112, -872},
    { -32, 200, -1000},
    { 128, 120, -1008},
    { 128, 152, -1056},
    { 96, 96, -1032},
    { 88, 152, -1040},
    { 104, 120, -1008},
    { 88, 136, -1016},
    { 80, 176, -1040},
    { 104, 160, -1056},
    { 104, 152, -1056},
    { 112, 136, -1032},
    { 96, 136, -1024},
    { 136, 120, -1016},
    { 120, 112, -1000},
    { 208, 96, -1008},
    { 296, 16, -976},
    { 368, 8, -904},
    { 400, 328, -840},
    // 2 seconds
    { 336, 544, -800},
    { 144, 848, -568},
    { -32, 1080, -384},
    { -112, 1008, -144},
    { -152, 1056, 80},
    { -136, 928, 320},
    { -152, 992, 624},
    { -152, 864, 744},
    { -184, 744, 840},
    { -184, 624, 824},
    { -280, 552, 864},
    { -344, 560, 840},
    { -376, 592, 816},
    { -360, 640, 816},
    { -272, 672, 720},
    { -232, 648, 800},
    { -240, 672, 800},
    { -192, 672, 800},
    { -384, 656, 952},
    { -448, 608, 968},
    { -344, 680, 880},
    { -312, 744, 1016},
    { -16, 848, 1064},
    { 152, 832, 960},
    { 328, 768, 768},
    // 3 seconds
    { 360, 648, 640},
    { 312, 608, 608},
    { 184, 544, 504},
    { 40, 520, 448},
    { 0, 496, 344},
    { -56, 496, 384},
    { -152, 488, 440},
    { -232, 536, 480},
    { -320, 624, 592},
    { -368, 760, 840},
    { -408, 912, 1200},
    { -328, 1008, 1096},
    { -400, 1056, 1328},
    { -152, 888, 1040},
    { -160, 584, 832},
    { -216, 512, 760},
    { -96, 472, 672},
    { -32, 392, 576},
    { -56, 344, 464},
    { -88, 376, 568},
    { -80, 384, 656},
    { -80, 552, 808},
    { -48, 760, 984},
    { -120, 808, 1064},
    { -152, 952, 968},
    // 4 seconds
    { -240, 1104, 1232},
    { 128, 1000, 1056},
    { 88, 752, 800},
    { 0, 560, 648},
    { -72, 504, 416},
    { -88, 376, 336},
    { -120, 344, 296},
    { -160, 384, 368},
    { -256, 504, 536},
    { -400, 592, 672},
    { -536, 792, 1024},
    { -456, 984, 1192},
    { -544, 960, 1328},
    { -184, 920, 1248},
    { -88, 632, 912},
    { -160, 520, 832},
    { -96, 432, 616},
    { -40, 376, 440},
    { -16, 376, 296},
    { -32, 416, 352},
    { -144, 496, 496},
    { -240, 688, 864},
    { -280, 840, 1200},
    { -128, 776, 992},
    { -280, 912, 1032},
    // 5 seconds
    { -224, 744, 1240},
    { 72, 736, 968},
    { 64, 592, 656},
    { 24, 512, 520},
    { -32, 384, 376},
    { -144, 312, 304},
    { -296, 344, 432},
    { -464, 416, 656},
    { -560, 528, 824},
    { -632, 688, 1040},
    { -368, 832, 1184},
    { -496, 840, 1280},
    { -104, 776, 1344},
    { -24, 512, 920},
    { -152, 464, 864},
    { -128, 424, 640},
    { -64, 336, 352},
    { -88, 344, 288},
    { -168, 416, 400},
    { -232, 480, 584},
    { -256, 608, 856},
    { -208, 760, 1256},
    { -88, 664, 920},
    { -296, 768, 1384},
    { -200, 768, 1400},
    // 6 seconds
    { 88, 760, 976},
    { -8, 656, 792},
    { -48, 496, 472},
    { -88, 408, 224},
    { -160, 352, 232},
    { -232, 360, 344},
    { -288, 432, 536},
    { -448, 536, 712},
    { -576, 640, 984},
    { -544, 696, 1080},
    { -720, 840, 1400},
    { -208, 736, 1280},
    { -184, 584, 912},
    { -272, 512, 912},
    { -152, 424, 608},
    { -88, 360, 344},
    { -128, 424, 288},
    { -168, 472, 392},
    { -184, 608, 536},
    { -208, 720, 768},
    { -136, 872, 1032},
    { -128, 752, 784},
    { -248, 872, 1016},
    { -240, 832, 1224},
    { 16, 872, 936},
    // 7 seconds
    { -8, 696, 728},
    { -128, 568, 616},
    { -104, 432, 312},
    { -176, 376, 280},
    { -280, 352, 424},
    { -400, 400, 552},
    { -544, 504, 704},
    { -656, 664, 984},
    { -552, 752, 1024},
    { -736, 816, 1168},
    { -256, 864, 1256},
    { -136, 616, 912},
    { -216, 512, 840},
    { -152, 432, 632},
    { -88, 328, 408},
    { -120, 408, 360},
    { -184, 456, 408},
    { -224, 552, 520},
    { -296, 696, 768},
    { -256, 776, 1024},
    { -168, 768, 952},
    { -304, 816, 1080},
    { -296, 712, 1288},
    { -40, 744, 928},
    { -56, 608, 720},
    // 8 seconds
    { -56, 504, 448},
    { -152, 480, 448},
    { -232, 392, 488},
    { -320, 328, 464},
    { -376, 368, 544},
    { -464, 432, 632},
    { -632, 520, 832},
    { -600, 752, 976},
    { -712, 1168, 1208},
    { -264, 1208, 1104},
    { -184, 864, 736},
    { -176, 720, 544},
    { -200, 664, 464},
    { -96, 432, 320},
    { -112, 496, 240},
    { -176, 552, 296},
    { -264, 720, 536},
    { -256, 856, 624},
    { -240, 1064, 896},
    { -152, 920, 728},
    { -344, 1048, 752},
    { -224, 864, 936},
    { -96, 960, 792},
    { 24, 808, 640},
    { -64, 744, 472},
    // 9 seconds
    { -112, 536, 328},
    { -200, 448, 248},
    { -312, 440, 336},
    { -448, 512, 480},
    { -504, 632, 680},
    { -616, 768, 776},
    { -520, 896, 936},
    { -688, 1016, 912},
    { -224, 1072, 1320},
    { -88, 824, 824},
    { -176, 608, 712},
    { -224, 504, 624},
    { -112, 384, 392},
    { -128, 400, 264},
    { -160, 488, 376},
    { -200, 584, 504},
    { -216, 760, 688},
    { -232, 960, 1024},
    { -120, 832, 944},
    { -264, 1000, 816},
    { -224, 848, 1192},
    { 0, 880, 912},
    { 56, 728, 688},
    { -88, 664, 616},
    { -104, 448, 360},
    // 10 seconds
    { -224, 368, 296},
    { -320, 360, 392},
    { -416, 400, 520},
    { -480, 520, 696},
    { -592, 656, 920},
    { -456, 784, 1064},
    { -624, 888, 1232},
    { -32, 824, 1408},
    { -72, 584, 960},
    { -248, 544, 904},
    { -184, 368, 632},
    { -144, 328, 272},
    { -168, 336, 304},
    { -216, 392, 336},
    { -264, 560, 616},
    { -288, 744, 928},
    { -136, 792, 1096},
    { -216, 760, 832},
    { -376, 832, 1072},
    { -224, 816, 1240},
    { 16, 832, 816},
    { -32, 624, 608},
    { -136, 528, 392},
    { -200, 416, 296},
    { -288, 360, 312},
    // 11 seconds
    { -352, 408, 456},
    { -440, 520, 648},
    { -560, 640, 768},
    { -576, 776, 1000},
    { -536, 864, 856},
    { -552, 1040, 1528},
    { -56, 768, 1048},
    { -144, 608, 784},
    { -256, 552, 768},
    { -96, 448, 448},
    { -88, 384, 208},
    { -128, 424, 232},
    { -200, 528, 312},
    { -272, 720, 608},
    { -360, 856, 704},
    { -264, 1088, 1056},
    { -320, 1000, 840},
    { -400, 1064, 1216},
    { -64, 944, 1000},
    { 64, 824, 648},
    { 72, 592, 488},
    { -96, 352, 272},
    { -264, 344, 248},
    { -320, 368, 408},
    { -392, 560, 480},
    // 12 seconds
    { -408, 752, 552},
    { -552, 872, 672},
    { -504, 920, 1016},
    { -536, 888, 784},
    { -512, 952, 1368},
    { -72, 696, 864},
    { -232, 576, 728},
    { -272, 504, 720},
    { -120, 400, 408},
    { -128, 360, 264},
    { -192, 424, 304},
    { -288, 472, 464},
    { -328, 688, 704},
    { -424, 888, 880},
    { -224, 984, 1080},
    { -328, 992, 800},
    { -296, 992, 1200},
    { 48, 920, 1016},
    { 112, 864, 640},
    { -8, 672, 480},
    { -128, 520, 296},
    { -176, 384, 216},
    { -312, 416, 320},
    { -352, 464, 432},
    { -448, 624, 624},
    // 13 seconds
    { -600, 768, 752},
    { -504, 944, 944},
    { -496, 944, 736},
    { -648, 1096, 1104},
    { -64, 824, 920},
    { -192, 712, 776},
    { -224, 624, 696},
    { -88, 448, 400},
    { -120, 416, 216},
    { -152, 424, 288},
    { -248, 584, 472},
    { -272, 784, 632},
    { -272, 896, 768},
    { -264, 1032, 944},
    { -240, 912, 720},
    { -344, 928, 960},
    { -16, 888, 1024},
    { 112, 824, 664},
    { 48, 608, 480},
    { -40, 608, 344},
    { -112, 440, 336},
    { -264, 512, 400},
    { -312, 576, 552},
    { -408, 664, 656},
    { -520, 744, 760},
    // 14 seconds
    { -544, 864, 1008},
    { -440, 920, 888},
    { -416, 1080, 1392},
    { -48, 784, 952},
    { -144, 632, 864},
    { -160, 544, 712},
    { -88, 400, 424},
    { -80, 384, 264},
    { -136, 400, 304},
    { -216, 488, 456},
    { -208, 696, 752},
    { -224, 912, 984},
    { -104, 904, 1072},
    { -224, 984, 920},
    { -192, 872, 1112},
    { -16, 872, 880},
    { 72, 752, 624},
    { -64, 672, 568},
    { -80, 480, 352},
    { -168, 400, 312},
    { -240, 400, 424},
    { -312, 440, 528},
    { -416, 568, 728},
    { -544, 672, 840},
    { -464, 712, 1072},
    // 15 seconds
    { -592, 760, 1152},
    { -256, 808, 1736},
    { -24, 560, 1008},
    { -168, 528, 864},
    { -184, 432, 664},
    { -112, 336, 400},
    { -136, 400, 344},
    { -200, 480, 360},
    { -248, 600, 536},
    { -264, 792, 776},
    { -232, 912, 880},
    { -144, 880, 816},
    { -344, 936, 768},
    { -280, 864, 1080},
    { 56, 928, 944},
    { 88, 864, 624},
    { 0, 712, 560},
    { -88, 488, 336},
    { -192, 480, 200},
    { -280, 472, 352},
    { -384, 552, 512},
    { -448, 664, 624},
    { -584, 752, 768},
    { -584, 880, 984},
    { -568, 856, 848},
    // 16 seconds
    { -528, 1088, 1312},
    { 32, 736, 784},
    { -152, 648, 744},
    { -152, 552, 704},
    { -72, 440, 400},
    { -80, 440, 240},
    { -184, 456, 336},
    { -336, 584, 512},
    { -384, 792, 816},
    { -384, 960, 944},
    { -248, 952, 920},
    { -480, 1000, 912},
    { -200, 880, 1128},
    { 112, 848, 840},
    { 72, 792, 672},
    { 8, 656, 496},
    { -72, 472, 256},
    { -192, 416, 232},
    { -296, 424, 384},
    { -352, 504, 504},
    { -424, 624, 664},
    { -560, 792, 808},
    { -488, 968, 1000},
    { -560, 1008, 816},
    { -480, 1064, 1344},
    // 17 seconds
    { -72, 720, 800},
    { -208, 544, 712},
    { -256, 480, 720},
    { -88, 320, 424},
    { -112, 328, 288},
    { -192, 344, 376},
    { -328, 512, 544},
    { -304, 736, 824},
    { -400, 984, 1000},
    { -280, 1016, 1072},
    { -416, 984, 816},
    { -336, 912, 984},
    { -24, 856, 792},
    { 48, 744, 624},
    { -48, 648, 504},
    { -64, 488, 320},
    { -160, 440, 272},
    { -256, 440, 344},
    { -376, 480, 448},
    { -472, 544, 568},
    { -640, 672, 784},
    { -576, 872, 1072},
    { -672, 1032, 1200},
    { -304, 1072, 1368},
    { -104, 768, 848},
    // 18 seconds
    { -216, 584, 784},
    { -152, 496, 608},
    { -40, 376, 416},
    { -88, 384, 312},
    { -160, 424, 352},
    { -272, 528, 560},
    { -264, 672, 736},
    { -328, 872, 1008},
    { -248, 792, 1024},
    { -232, 856, 832},
    { -232, 880, 1216},
    { 16, 840, 1096},
    { 96, 744, 784},
    { -56, 560, 528},
    { -128, 464, 344},
    { -208, 384, 320},
    { -312, 376, 408},
    { -416, 456, 512},
    { -504, 568, 664},
    { -600, 664, 912},
    { -472, 832, 1192},
    { -512, 848, 1032},
    { -304, 888, 1384},
    { -160, 664, 936},
    { -240, 504, 888},
    // 19 seconds
    { -224, 432, 696},
    { -104, 304, 408},
    { -80, 288, 272},
    { -128, 360, 336},
    { -208, 432, 488},
    { -288, 672, 872},
    { -304, 800, 1096},
    { -256, 792, 1040},
    { -368, 920, 1016},
    { -344, 728, 1272},
    { -48, 744, 904},
    { 16, 648, 808},
    { -16, 568, 632},
    { -48, 432, 408},
    { -152, 360, 312},
    { -280, 392, 384},
    { -352, 456, 536},
    { -472, 632, 664},
    { -560, 792, 832},
    { -416, 944, 1024},
    { -592, 1048, 1176},
    { -184, 848, 1136},
    { -192, 616, 736},
    { -304, 520, 800},
    { -224, 480, 696},
    // 20 seconds
    { -96, 408, 440},
    { -104, 392, 312},
    { -160, 408, 368},
    { -288, 552, 528},
    { -296, 656, 776},
    { -288, 848, 976},
    { -176, 784, 976},
    { -328, 936, 992},
    { -144, 824, 1424},
    { 128, 776, 856},
    { 64, 600, 688},
    { -64, 496, 472},
    { -128, 336, 344},
    { -264, 360, 400},
    { -376, 368, 520},
    { -464, 464, 640},
    { -528, 520, 760},
    { -576, 648, 888},
    { -464, 768, 1088},
    { -536, 920, 1512},
    { -24, 688, 1072},
    { -176, 504, 784},
    { -304, 456, 840},
    { -152, 344, 616},
    { -88, 368, 424},
    // 21 seconds
    { -104, 384, 336},
    { -176, 424, 464},
    { -240, 488, 648},
    { -376, 672, 928},
    { -232, 808, 1208},
    { -256, 712, 1064},
    { -288, 792, 1184},
    { 32, 808, 1056},
    { 112, 696, 776},
    { -40, 728, 632},
    { -96, 544, 504},
    { -192, 392, 352},
    { -256, 328, 296},
    { -376, 328, 480},
    { -448, 472, 568},
    { -544, 592, 712},
    { -496, 864, 1024},
    { -456, 864, 920},
    { -464, 1160, 1296},
    { -128, 848, 1024},
    { -160, 664, 752},
    { -192, 504, 648},
    { -104, 416, 360},
    { -88, 288, 240},
    { -160, 368, 344},
    // 22 seconds
    { -240, 536, 552},
    { -320, 712, 776},
    { -384, 960, 904},
    { -256, 992, 952},
    { -304, 952, 728},
    { -280, 1064, 928},
    { 16, 1000, 1000},
    { 168, 856, 656},
    { 24, 712, 528},
    { -96, 560, 392},
    { -184, 416, 240},
    { -280, 408, 304},
    { -400, 464, 440},
    { -448, 584, 560},
    { -648, 704, 752},
    { -600, 920, 1000},
    { -600, 952, 832},
    { -464, 1144, 1232},
    { -8, 848, 944},
    { -128, 688, 760},
    { -152, 600, 656},
    { -64, 456, 376},
    { -96, 432, 224},
    { -152, 416, 256},
    { -208, 616, 472},
    // 23 seconds
    { -256, 792, 776},
    { -320, 1000, 840},
    { -344, 1064, 888},
    { -408, 1016, 704},
    { -400, 1064, 976},
    { -104, 984, 904},
    { 112, 792, 608},
    { -40, 608, 456},
    { -96, 520, 312},
    { -152, 400, 296},
    { -280, 376, 320},
    { -384, 440, 464},
    { -472, 608, 584},
    { -592, 752, 664},
    { -536, 1000, 880},
    { -536, 1088, 856},
    { -376, 1096, 1288},
    { -104, 752, 856},
    { -176, 592, 800},
    { -200, 584, 672},
    { -88, 448, 432},
    { -104, 440, 328},
    { -144, 464, 336},
    { -256, 552, 480},
    { -296, 712, 792},
    // 24 seconds
    { -296, 936, 968},
    { -112, 848, 928},
    { -352, 968, 880},
    { -288, 928, 1160},
    { 0, 944, 952},
    { 64, 800, 600},
    { -48, 632, 368},
    { -128, 480, 312},
    { -192, 352, 280},
    { -288, 352, 376},
    { -352, 432, 536},
    { -496, 640, 760},
    { -576, 736, 744},
    { -568, 1000, 904},
    { -696, 1112, 840},
    { -336, 1176, 1272},
    { -64, 800, 824},
    { -240, 648, 688},
    { -160, 504, 488},
    { -96, 384, 232},
    { -128, 408, 208},
    { -192, 504, 304},
    { -248, 696, 552},
    { -288, 928, 792},
    { -240, 1096, 848},
    // 25 seconds
    { -264, 1048, 864},
    { -344, 1128, 776},
    { -192, 928, 952},
    { 80, 888, 696},
    { 24, 712, 512},
    { -80, 640, 480},
    { -80, 352, 304},
    { -224, 352, 256},
    { -336, 392, 360},
    { -440, 528, 552},
    { -584, 648, 704},
    { -664, 872, 992},
    { -424, 848, 1080},
    { -472, 840, 1792},
    { -88, 616, 1040},
    { -192, 424, 864},
    { -280, 368, 840},
    { -136, 344, 576},
    { -104, 248, 336},
    { -136, 344, 352},
    { -208, 368, 384},
    { -304, 528, 608},
    { -424, 744, 888},
    { -304, 888, 1008},
    { -320, 864, 896},
    // 26 seconds
    { -448, 1032, 1160},
    { -104, 944, 1112},
    { 32, 856, 656},
    { -56, 688, 560},
    { -80, 456, 416},
    { -144, 344, 320},
    { -280, 288, 352},
    { -336, 328, 384},
    { -400, 464, 472},
    { -536, 696, 744},
    { -488, 880, 1080},
    { -584, 1000, 1176},
    { -464, 1112, 1448},
    { -56, 776, 808},
    { -208, 656, 688},
    { -216, 576, 744},
    { -72, 432, 432},
    { -64, 416, 224},
    { -136, 416, 280},
    { -256, 536, 448},
    { -280, 664, 680},
    { -352, 952, 936},
    { -208, 960, 1120},
    { -208, 968, 864},
    { -232, 904, 960},
    // 27 seconds
    { -72, 800, 992},
    { 136, 720, 648},
    { 0, 584, 568},
    { -104, 512, 384},
    { -160, 336, 272},
    { -264, 352, 352},
    { -360, 368, 464},
    { -464, 568, 712},
    { -536, 656, 784},
    { -552, 896, 1008},
    { -480, 944, 952},
    { -496, 1040, 1496},
    { -80, 752, 896},
    { -160, 560, 848},
    { -176, 488, 672},
    { -104, 328, 440},
    { -112, 368, 288},
    { -184, 456, 384},
    { -168, 568, 520},
    { -208, 712, 800},
    { -184, 840, 912},
    { -112, 840, 944},
    { -256, 904, 840},
    { -264, 984, 1424},
    { 232, 856, 952},
    // 28 seconds
    { 96, 752, 664},
    { -104, 624, 544},
    { -128, 448, 320},
    { -216, 416, 304},
    { -328, 392, 440},
    { -384, 496, 592},
    { -536, 552, 696},
    { -592, 648, 848},
    { -504, 744, 1032},
    { -664, 768, 1056},
    { -304, 952, 1528},
    { -16, 648, 944},
    { -136, 576, 856},
    { -160, 480, 592},
    { -104, 360, 296},
    { -128, 424, 296},
    { -168, 504, 368},
    { -216, 616, 608},
    { -264, 760, 816},
    { -264, 848, 920},
    { -296, 848, 928},
    { -344, 832, 792},
    { -256, 856, 1088},
    { 16, 832, 968},
    { 104, 744, 656},
    // 29 seconds
    { -72, 640, 520},
    { -128, 512, 328},
    { -240, 440, 320},
    { -344, 536, 448},
    { -368, 512, 464},
    { -424, 664, 576},
    { -560, 848, 688},
    { -448, 1016, 856},
    { -480, 1000, 664},
    { -464, 1120, 1224},
    { -16, 872, 920},
    { -144, 688, 760},
    { -168, 544, 504},
    { -112, 408, 248},
    { -120, 416, 232},
    { -152, 512, 296},
    { -216, 624, 440},
    { -240, 936, 728},
    { -232, 1024, 776},
    { -152, 1040, 744},
    { -280, 1040, 656},
    { -240, 1136, 1080},
    { 96, 1032, 952},
    { 184, 904, 648},
    { 8, 680, 448},
    // 30 seconds
    { -48, 456, 208},
    { -176, 400, 216},
    { -320, 440, 392},
    { -360, 552, 616},
    { -456, 672, 712},
    { -624, 816, 1008},
    { -416, 1112, 992},
    { -616, 1160, 1008},
    { -48, 912, 1256},
    { -72, 584, 728},
    { -248, 536, 720},
    { -176, 472, 656},
    { -64, 392, 392},
    { -48, 384, 296},
    { -120, 384, 368},
    { -296, 528, 568},
    { -336, 792, 760},
    { -344, 912, 816},
    { -224, 920, 808},
    { -416, 1008, 832},
    { -248, 1024, 1328},
    { 112, 960, 1056},
    { 168, 760, 768},
    { 24, 672, 552},
    { -56, 448, 320},
    // 31 seconds
    { -176, 376, 240},
    { -320, 368, 344},
    { -416, 456, 472},
    { -504, 640, 648},
    { -528, 720, 776},
    { -528, 920, 968},
    { -624, 984, 928},
    { -344, 1176, 1456},
    { -48, 824, 864},
    { -208, 672, 792},
    { -192, 552, 632},
    { -80, 360, 312},
    { -96, 360, 176},
    { -192, 384, 320},
    { -288, 544, 472},
    { -280, 752, 648},
    { -248, 1040, 872},
    { -152, 960, 776},
    { -304, 1040, 672},
    { -264, 1048, 1040},
    { -48, 1064, 960},
    { 88, 904, 640},
    { -24, 720, 448},
    { -80, 472, 200},
    { -192, 408, 248},
    // 32 seconds
    { -336, 400, 328},
    { -432, 464, 520},
    { -536, 632, 664},
    { -576, 832, 920},
    { -432, 928, 928},
    { -656, 1080, 1000},
    { -208, 1184, 1160},
    { -24, 920, 848},
    { -200, 824, 800},
    { -144, 648, 552},
    { -32, 432, 232},
    { -88, 456, 152},
    { -200, 464, 256},
    { -264, 616, 424},
    { -272, 888, 600},
    { -272, 1080, 792},
    { -192, 848, 616},
    { -456, 1016, 656},
    { -360, 1208, 1088},
    { 40, 1088, 856},
    { 8, 824, 616},
    { -168, 704, 448},
    { -152, 552, 96},
    { -256, 440, 184},
    { -304, 496, 296},
    // 33 seconds
    { -336, 584, 416},
    { -424, 680, 600},
    { -568, 840, 752},
    { -504, 1000, 896},
    { -584, 1000, 760},
    { -488, 1208, 1096},
    { -24, 888, 896},
    { -160, 768, 744},
    { -160, 608, 632},
    { -48, 472, 408},
    { -80, 464, 272},
    { -128, 496, 360},
    { -200, 584, 432},
    { -224, 760, 568},
    { -224, 904, 680},
    { -216, 968, 784},
    { -248, 896, 696},
    { -368, 1096, 960},
    { -88, 1056, 1064},
    { 104, 904, 728},
    { 40, 800, 616},
    { -40, 536, 336},
    { -160, 440, 280},
    { -256, 424, 336},
    { -376, 504, 504},
    // 34 seconds
    { -448, 568, 632},
    { -488, 672, 664},
    { -504, 824, 904},
    { -392, 848, 872},
    { -488, 1000, 1240},
    { 24, 872, 960},
    { -152, 760, 880},
    { -192, 720, 736},
    { -88, 480, 504},
    { -48, 464, 256},
    { -104, 512, 224},
    { -176, 512, 344},
    { -232, 712, 512},
    { -200, 928, 720},
    { -160, 992, 896},
    { -176, 904, 760},
    { -264, 1000, 776},
    { -112, 984, 1080},
    { 96, 920, 752},
    { -16, 848, 736},
    { -80, 648, 408},
    { -208, 456, 336},
    { -328, 416, 368},
    { -472, 416, 512},
    { -456, 496, 592},
    // 35 seconds
    { -496, 544, 624},
    { -544, 752, 928},
    { -280, 768, 896},
    { -464, 904, 1256},
    { -88, 784, 1128},
    { -176, 648, 928},
    { -296, 616, 888},
    { -144, 488, 640},
    { -112, 432, 360},
    { -120, 440, 336},
    { -168, 440, 392},
    { -232, 544, 536},
    { -280, 760, 728},
    { -232, 856, 920},
    { -184, 784, 792},
    { -408, 936, 864},
    { -248, 944, 1280},
    { -24, 968, 1048},
    { 56, 776, 776},
    { -72, 632, 472},
    { -192, 464, 352},
    { -264, 376, 328},
    { -368, 376, 376},
    { -440, 512, 488},
    { -432, 608, 624},
    // 36 seconds
    { -520, 736, 752},
    { -488, 840, 912},
    { -472, 840, 688},
    { -496, 1144, 1400},
    { -112, 816, 800},
    { -248, 640, 784},
    { -248, 672, 776},
    { -48, 496, 584},
    { -88, 512, 408},
    { -136, 488, 440},
    { -184, 528, 512},
    { -176, 664, 624},
    { -200, 800, 680},
    { -152, 896, 864},
    { -168, 856, 792},
    { -248, 960, 824},
    { -144, 896, 976},
    { 40, 920, 800},
    { -40, 816, 672},
    { -40, 688, 496},
    { -104, 504, 264},
    { -216, 496, 272},
    { -352, 488, 424},
    { -368, 640, 568},
    { -424, 680, 560},
    // 37 seconds
    { -512, 864, 728},
    { -416, 920, 712},
    { -648, 992, 872},
    { -280, 1120, 1176},
    { -80, 896, 864},
    { -128, 760, 776},
    { -96, 608, 608},
    { -64, 456, 344},
    { -104, 480, 272},
    { -184, 544, 392},
    { -224, 648, 512},
    { -216, 848, 648},
    { -160, 856, 696},
    { -184, 816, 712},
    { -304, 848, 704},
    { -360, 1000, 1080},
    { -48, 920, 1152},
    { 136, 792, 664},
    { -120, 640, 688},
    { -128, 536, 544},
    { -152, 432, 384},
    { -248, 424, 400},
    { -336, 448, 528},
    { -408, 520, 664},
    { -536, 600, 800},
    // 38 seconds
    { -528, 744, 1008},
    { -392, 784, 832},
    { -488, 1056, 1520},
    { -32, 872, 1144},
    { -56, 680, 936},
    { -136, 600, 712},
    { -72, 392, 344},
    { -104, 432, 256},
    { -168, 488, 312},
    { -200, 576, 512},
    { -200, 752, 760},
    { -152, 760, 896},
    { -112, 744, 928},
    { -136, 648, 704},
    { -296, 752, 968},
    { -168, 840, 1296},
    { 104, 800, 840},
    { -40, 776, 720},
    { -88, 520, 440},
    { -216, 432, 336},
    { -312, 400, 392},
    { -416, 384, 568},
    { -416, 560, 728},
    { -424, 616, 792},
    { -336, 880, 944},
    // 39 seconds
    { -328, 888, 664},
    { -256, 984, 1112},
    { -120, 912, 920},
    { -104, 760, 872},
    { -184, 704, 744},
    { -128, 512, 496},
    { -152, 432, 304},
    { -240, 496, 376},
    { -328, 584, 464},
    { -224, 616, 584},
    { -264, 912, 736},
    { -136, 904, 776},
    { -216, 960, 744},
    { -208, 1096, 1192},
    { 64, 984, 920},
    { 128, 896, 592},
    { -48, 744, 608},
    { -112, 712, 480},
    { -104, 512, 264},
    { -208, 552, 288},
    { -280, 544, 400},
    { -344, 648, 512},
    { -512, 816, 688},
    { -480, 936, 864},
    { -416, 888, 712},
    // 40 seconds
    { -528, 1176, 1208},
    { -48, 944, 1000},
    { -104, 848, 840},
    { -144, 712, 744},
    { -48, 536, 488},
    { -64, 392, 224},
    { -144, 448, 224},
    { -280, 480, 352},
    { -344, 624, 536},
    { -344, 792, 688},
    { -240, 952, 888},
    { -232, 872, 904},
    { -280, 912, 808},
    { -272, 960, 1152},
    { 104, 888, 848},
    { 40, 848, 608},
    { -16, 720, 536},
    { -72, 552, 416},
    { -160, 472, 304},
    { -240, 512, 416},
    { -288, 520, 504},
    { -360, 656, 648},
    { -480, 704, 680},
    { -520, 832, 840},
    { -528, 824, 672},
    // 41 seconds
    { -656, 928, 944},
    { -248, 824, 856},
    { -288, 744, 792},
    { -296, 616, 752},
    { -160, 488, 440},
    { -144, 416, 336},
    { -192, 464, 352},
    { -280, 536, 472},
    { -256, 736, 632},
    { -256, 880, 688},
    { -192, 1016, 872},
    { -224, 880, 712},
    { -360, 992, 832},
    { -224, 944, 1000},
    { 0, 936, 712},
    { -40, 728, 536},
    { -96, 608, 424},
    { -160, 504, 328},
    { -264, 456, 320},
    { -416, 424, 480},
    { -504, 536, 592},
    { -528, 648, 696},
    { -608, 832, 856},
    { -376, 984, 920},
    { -488, 1240, 1096},
    // 42 seconds
    { -80, 1040, 960},
    { -96, 808, 696},
    { -192, 648, 720},
    { -176, 568, 584},
    { -120, 472, 416},
    { -184, 464, 368},
    { -232, 464, 408},
    { -240, 528, 512},
    { -224, 544, 648},
    { -288, 672, 928},
    { -304, 752, 1024},
    { -328, 760, 880},
    { -480, 800, 1528},
    { -48, 800, 1112},
    { 120, 728, 720},
    { -24, 656, 560},
    { 0, 432, 272},
    { -96, 344, 128},
    { -264, 488, 408},
    { -336, 576, 632},
    { -320, 704, 808},
    { -424, 744, 864},
    { -528, 800, 1040},
    { -520, 784, 840},
    { -408, 840, 1312},
    // 43 seconds
    { -176, 576, 928},
    { -200, 520, 928},
    { -184, 480, 952},
    { -80, 344, 600},
    { -96, 320, 456},
    { -176, 376, 480},
    { -240, 424, 600},
    { -208, 552, 704},
    { -224, 632, 864},
    { -144, 640, 1024},
    { -200, 656, 968},
    { -200, 544, 1352},
    { 24, 616, 1304},
    { 200, 624, 1056},
    { 64, 544, 776},
    { -32, 440, 448},
    { -112, 400, 320},
    { -216, 392, 432},
    { -304, 400, 576},
    { -360, 480, 776},
    { -440, 480, 888},
    { -512, 520, 1072},
    { -544, 536, 1136},
    { -648, 520, 1304},
    { -200, 608, 1400},
    // 44 seconds
    { -128, 424, 1080},
    { -184, 376, 880},
    { -96, 336, 624},
    { -80, 288, 328},
    { -120, 312, 360},
    { -208, 344, 472},
    { -264, 496, 664},
    { -256, 592, 864},
    { -192, 736, 1128},
    { -160, 648, 912},
    { -296, 736, 1248},
    { -136, 728, 1272},
    { -16, 688, 952},
    { -88, 584, 696},
    { -80, 504, 408},
    { -144, 416, 280},
    { -216, 384, 384},
    { -328, 368, 584},
    { -464, 416, 888},
    { -592, 352, 896},
    { -744, 344, 1000},
    { -744, 352, 1024},
    { -808, 320, 1176},
    { -296, 432, 1296},
    { -232, 288, 952},
    // 45 seconds
    { -296, 280, 960},
    { -160, 280, 704},
    { -80, 296, 424},
    { -152, 336, 400},
    { -288, 352, 472},
    { -408, 488, 680},
    { -368, 568, 968},
    { -208, 600, 992},
    { -176, 480, 784},
    { -472, 536, 1048},
    { -456, 480, 1264},
    { -224, 544, 1080},
    { -104, 416, 736},
    { -152, 416, 816},
    { -144, 336, 440},
    { -208, 344, 416},
    { -320, 312, 496},
    { -416, 352, 664},
    { -480, 352, 720},
    { -592, 432, 896},
    { -576, 544, 1256},
    { -672, 600, 1344},
    { -208, 552, 1528},
    { -128, 312, 1024},
    { -232, 304, 1000},
    // 46 seconds
    { -240, 304, 840},
    { -120, 264, 496},
    { -96, 272, 320},
    { -168, 328, 432},
    { -248, 376, 584},
    { -256, 472, 720},
    { -352, 584, 992},
    { -248, 552, 1056},
    { -360, 616, 984},
    { -360, 584, 1488},
    { -96, 584, 1256},
    { 88, 440, 952},
    { -40, 400, 856},
    { -72, 352, 456},
    { -192, 304, 256},
    { -312, 296, 384},
    { -480, 336, 496},
    { -560, 424, 816},
    { -648, 488, 912},
    { -520, 480, 1432},
    { -392, 448, 1120},
    { -416, 352, 1432},
    { -256, 272, 1032},
    { -320, 216, 1064},
    { -288, 288, 1064},
    // 47 seconds
    { -72, 224, 680},
    { -32, 240, 440},
    { -128, 264, 384},
    { -272, 344, 472},
    { -368, 416, 680},
    { -472, 592, 944},
    { -232, 528, 1104},
    { -128, 552, 904},
    { -320, 512, 1216},
    { -264, 560, 1400},
    { 56, 696, 968},
    { -88, 464, 912},
    { -144, 400, 696},
    { -136, 328, 440},
    { -160, 288, 416},
    { -216, 216, 488},
    { -432, 128, 760},
    { -456, 152, 936},
    { -536, 352, 1008},
    { -424, 672, 1192},
    { -304, 648, 2192},
    { 16, 496, 1200},
    { -192, 472, 864},
    { -304, 336, 784},
    { -264, 352, 696},
    // 48 seconds
    { -128, 272, 472},
    { -104, 304, 432},
    { -160, 376, 504},
    { -208, 440, 600},
    { -232, 608, 832},
    { -88, 688, 992},
    { -144, 616, 936},
    { -304, 720, 936},
    { -352, 752, 1512},
    { -48, 672, 1216},
    { 72, 640, 840},
    { -48, 504, 728},
    { -112, 424, 488},
    { -152, 352, 376},
    { -232, 344, 408},
    { -336, 336, 512},
    { -376, 416, 720},
    { -512, 496, 816},
    { -576, 592, 992},
    { -480, 768, 1080},
    { -608, 640, 1424},
    { -144, 624, 1352},
    { -32, 416, 896},
    { -152, 360, 752},
    { -168, 336, 680},
    // 49 seconds
    { -96, 256, 408},
    { -136, 304, 392},
    { -240, 400, 560},
    { -256, 536, 816},
    { -248, 592, 928},
    { -264, 640, 984},
    { -256, 616, 976},
    { -448, 704, 1056},
    { -384, 632, 1320},
    { -96, 720, 1120},
    { 88, 640, 816},
    { 56, 528, 640},
    { -24, 416, 384},
    { -136, 336, 344},
    { -200, 312, 400},
    { -328, 384, 560},
    { -392, 440, 840},
    { -480, 472, 832},
    { -528, 656, 976},
    { -504, 656, 1040},
    { -592, 816, 1520},
    { -176, 592, 1192},
    { -160, 496, 968},
    { -192, 432, 1008},
    { -72, 392, 736},
    // 50 seconds
    { -8, 288, 416},
    { -48, 328, 392},
    { -136, 368, 504},
    { -200, 440, 600},
    { -256, 560, 704},
    { -240, 616, 760},
    { -304, 728, 928},
    { -272, 672, 888},
    { -504, 864, 1080},
    { -200, 704, 1048},
    { -80, 808, 792},
    { -112, 768, 872},
    { -80, 696, 832},
    { -24, 568, 688},
    { -40, 512, 512},
    { -96, 448, 496},
    { -152, 432, 464},
    { -224, 424, 424},
    { -392, 456, 512},
    { -512, 608, 648},
    { -528, 752, 768},
    { -472, 800, 808},
    { -624, 960, 1064},
    { -280, 960, 1080},
    { -208, 824, 904},
    // 51 seconds
    { -160, 736, 776},
    { -136, 680, 600},
    { -88, 672, 592},
    { -8, 712, 424},
    { -72, 816, 616},
    { -40, 912, 432},
    { -112, 1056, 456},
    { -144, 1128, 288},
    { -352, 1224, 112},
    { -32, 1264, -184},
    { -8, 896, -280},
    { 144, 816, -576},
    { 272, 336, -816},
    { 272, 248, -840},
    { 344, 232, -1016},
    { 320, 32, -960},
    { 384, -32, -1040},
    { 384, -16, -1096},
    { 360, -24, -1056},
    { 296, 8, -1040},
    { 264, 64, -1032},
    { 248, 56, -1040},
    { 776, -72, -1144},
    { 200, 56, -1056},
    { 232, 104, -1040},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 12:42:55 local
AccelRawData *activity_sample_walk_100_pbl_28397_14(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28397_14
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 64, 88, -1048},
    { 72, 72, -1024},
    { 48, 40, -1008},
    { 48, 80, -1032},
    { 88, 64, -1008},
    { 0, 24, -1056},
    { 32, 56, -1016},
    { 16, 64, -1096},
    { -16, 88, -1032},
    { 16, 104, -1040},
    { -32, 112, -1016},
    { 72, 88, -1016},
    { 64, 96, -1032},
    { 32, 104, -1016},
    { 128, -8, -984},
    { 72, 80, -1024},
    { 72, 56, -1032},
    { 88, 64, -1040},
    { 200, -72, -1016},
    { 176, 0, -1024},
    { 184, 16, -1016},
    { 136, 168, -1000},
    { 56, 296, -1040},
    { -24, 272, -984},
    { -80, 448, -984},
    // 1 seconds
    { -104, 488, -1000},
    { -88, 432, -936},
    { -104, 456, -976},
    { -88, 472, -920},
    { -96, 368, -872},
    { -80, 520, -976},
    { -120, 544, -872},
    { -176, 560, -888},
    { -120, 472, -960},
    { -80, 312, -984},
    { -144, 416, -976},
    { -104, 224, -1008},
    { -64, 136, -952},
    { -16, 320, -992},
    { -24, 416, -984},
    { -88, 496, -896},
    { -88, 568, -944},
    { -176, 536, -848},
    { -200, 640, -880},
    { -304, 712, -784},
    { -296, 480, -768},
    { -336, 680, -848},
    { -304, 664, -864},
    { -264, 544, -896},
    { -216, 496, -800},
    // 2 seconds
    { -176, 488, -904},
    { -152, 360, -856},
    { -112, 296, -1016},
    { -128, 328, -960},
    { -88, 248, -1048},
    { -64, 136, -1000},
    { -72, 128, -1000},
    { -104, 328, -888},
    { -80, 608, -952},
    { 32, 712, -816},
    { 128, 888, -544},
    { 104, 1216, -312},
    { 176, 1240, -216},
    { 120, 1104, -128},
    { 112, 1120, -8},
    { 88, 1032, 24},
    { 56, 1016, 16},
    { 24, 904, -24},
    { -40, 880, -8},
    { -80, 848, -56},
    { -160, 880, -8},
    { -200, 968, 8},
    { -272, 1016, 64},
    { -320, 1120, 248},
    { -240, 1144, 408},
    // 3 seconds
    { -384, 1168, 544},
    { -192, 1152, 888},
    { -16, 968, 664},
    { -72, 648, 648},
    { -56, 576, 720},
    { 16, 536, 688},
    { 24, 504, 576},
    { -16, 456, 616},
    { -64, 464, 680},
    { -120, 496, 840},
    { -160, 528, 984},
    { -112, 560, 1080},
    { -40, 448, 1320},
    { -64, 600, 1176},
    { 8, 392, 1288},
    { 120, 504, 992},
    { 224, 512, 776},
    { 168, 512, 664},
    { 64, 440, 488},
    { -64, 368, 424},
    { -192, 368, 496},
    { -280, 400, 648},
    { -360, 472, 832},
    { -432, 480, 912},
    { -512, 600, 1176},
    // 4 seconds
    { -448, 704, 1160},
    { -536, 656, 1232},
    { -152, 672, 1168},
    { -104, 456, 736},
    { -192, 408, 824},
    { -144, 392, 752},
    { -56, 368, 608},
    { -64, 336, 496},
    { -112, 400, 480},
    { -152, 496, 656},
    { -152, 552, 800},
    { -120, 704, 976},
    { -72, 696, 1088},
    { -120, 784, 920},
    { -144, 712, 1336},
    { 104, 752, 1024},
    { 128, 720, 728},
    { 24, 624, 624},
    { -96, 464, 368},
    { -168, 376, 272},
    { -248, 432, 424},
    { -328, 568, 624},
    { -456, 640, 816},
    { -600, 760, 1016},
    { -504, 888, 1056},
    // 5 seconds
    { -688, 880, 1104},
    { -176, 864, 1136},
    { -168, 648, 800},
    { -232, 544, 800},
    { -152, 496, 656},
    { -64, 392, 392},
    { -120, 400, 288},
    { -176, 424, 456},
    { -232, 544, 680},
    { -168, 632, 840},
    { -80, 816, 1032},
    { -48, 768, 1016},
    { -168, 920, 952},
    { -192, 744, 1224},
    { 16, 848, 928},
    { 96, 728, 552},
    { -88, 600, 464},
    { -120, 448, 384},
    { -200, 400, 336},
    { -256, 384, 464},
    { -320, 464, 680},
    { -440, 552, 784},
    { -504, 688, 1064},
    { -488, 792, 1048},
    { -672, 864, 1208},
    // 6 seconds
    { -176, 952, 1328},
    { -72, 672, 912},
    { -192, 584, 816},
    { -128, 480, 672},
    { -48, 360, 368},
    { -64, 392, 296},
    { -112, 464, 360},
    { -152, 576, 544},
    { -120, 784, 792},
    { 8, 840, 1032},
    { -56, 824, 808},
    { -160, 880, 920},
    { -232, 928, 1168},
    { 32, 888, 896},
    { 0, 824, 608},
    { -48, 608, 424},
    { -128, 448, 192},
    { -200, 400, 232},
    { -304, 384, 392},
    { -376, 520, 552},
    { -472, 648, 704},
    { -600, 896, 976},
    { -520, 968, 960},
    { -704, 1168, 1080},
    { -216, 1104, 1048},
    // 7 seconds
    { -176, 848, 744},
    { -248, 712, 784},
    { -168, 552, 664},
    { -40, 464, 440},
    { -64, 424, 328},
    { -112, 520, 352},
    { -152, 576, 416},
    { -128, 808, 576},
    { -112, 1016, 792},
    { -64, 1008, 736},
    { -152, 1032, 616},
    { -272, 1048, 928},
    { -104, 1032, 704},
    { 0, 984, 568},
    { -96, 848, 472},
    { -56, 640, 272},
    { -128, 480, 184},
    { -208, 440, 264},
    { -296, 488, 416},
    { -424, 616, 608},
    { -560, 760, 776},
    { -648, 960, 1048},
    { -512, 928, 784},
    { -624, 1200, 1192},
    { -24, 1000, 904},
    // 8 seconds
    { -96, 784, 712},
    { -144, 696, 728},
    { -64, 560, 552},
    { 32, 456, 320},
    { 40, 480, 296},
    { 8, 560, 464},
    { 24, 688, 624},
    { 40, 864, 752},
    { 8, 920, 800},
    { -176, 880, 888},
    { -224, 984, 760},
    { -184, 1008, 1280},
    { -8, 888, 880},
    { -104, 704, 640},
    { -272, 640, 592},
    { -240, 552, 376},
    { -304, 344, 400},
    { -400, 352, 432},
    { -480, 408, 536},
    { -528, 448, 648},
    { -632, 544, 824},
    { -528, 672, 896},
    { -712, 744, 1128},
    { -488, 872, 1208},
    { -264, 768, 992},
    // 9 seconds
    { -256, 720, 864},
    { -32, 616, 544},
    { -8, 432, 312},
    { -56, 432, 280},
    { -160, 400, 320},
    { -288, 536, 576},
    { -336, 656, 824},
    { -296, 952, 1080},
    { -120, 896, 968},
    { -304, 1040, 968},
    { -208, 936, 1368},
    { 176, 968, 832},
    { 288, 872, 696},
    { 96, 736, 552},
    { 0, 528, 320},
    { -88, 408, 240},
    { -192, 408, 344},
    { -296, 496, 552},
    { -392, 648, 712},
    { -440, 680, 728},
    { -576, 800, 928},
    { -528, 880, 744},
    { -640, 1024, 1536},
    { -48, 880, 872},
    { -216, 536, 760},
    // 10 seconds
    { -264, 480, 784},
    { -240, 440, 632},
    { -88, 408, 440},
    { -112, 408, 392},
    { -144, 472, 424},
    { -224, 552, 576},
    { -200, 696, 776},
    { -152, 936, 992},
    { -96, 872, 920},
    { -168, 1016, 920},
    { -168, 992, 1160},
    { 160, 1008, 808},
    { 176, 880, 616},
    { 64, 664, 504},
    { -16, 472, 288},
    { -120, 368, 272},
    { -256, 344, 384},
    { -328, 432, 552},
    { -424, 560, 744},
    { -552, 704, 888},
    { -592, 872, 1136},
    { -520, 896, 944},
    { -536, 1056, 1272},
    { -232, 864, 888},
    { -176, 680, 792},
    // 11 seconds
    { -160, 552, 656},
    { -72, 424, 448},
    { -80, 440, 328},
    { -144, 440, 400},
    { -192, 568, 592},
    { -192, 656, 720},
    { -152, 704, 808},
    { -128, 776, 992},
    { -72, 624, 736},
    { -328, 840, 896},
    { -312, 832, 1192},
    { -24, 984, 1008},
    { 64, 840, 728},
    { -16, 672, 600},
    { -72, 432, 368},
    { -120, 376, 288},
    { -184, 368, 384},
    { -256, 392, 488},
    { -336, 488, 680},
    { -544, 640, 944},
    { -528, 792, 1120},
    { -688, 944, 1128},
    { -448, 1048, 1496},
    { -144, 872, 872},
    { -224, 576, 880},
    // 12 seconds
    { -224, 504, 704},
    { -144, 352, 568},
    { -112, 328, 368},
    { -152, 344, 408},
    { -208, 448, 544},
    { -176, 592, 664},
    { -208, 800, 872},
    { -104, 824, 1048},
    { -184, 856, 768},
    { -264, 920, 1152},
    { -152, 880, 1056},
    { 80, 816, 720},
    { -48, 640, 616},
    { -72, 568, 400},
    { -152, 440, 312},
    { -224, 408, 352},
    { -312, 440, 480},
    { -400, 536, 656},
    { -496, 616, 784},
    { -576, 744, 936},
    { -520, 776, 928},
    { -696, 1000, 1160},
    { -72, 896, 1096},
    { -104, 688, 784},
    { -200, 568, 712},
    // 13 seconds
    { -152, 464, 584},
    { -64, 408, 392},
    { -104, 400, 368},
    { -168, 424, 464},
    { -216, 536, 600},
    { -216, 728, 816},
    { -264, 928, 1104},
    { -104, 808, 896},
    { -304, 952, 936},
    { -200, 824, 1152},
    { 24, 848, 832},
    { 64, 736, 704},
    { -8, 656, 600},
    { -48, 472, 344},
    { -168, 424, 320},
    { -288, 400, 408},
    { -408, 456, 552},
    { -480, 632, 840},
    { -560, 656, 872},
    { -480, 808, 984},
    { -648, 912, 1024},
    { -240, 1040, 1416},
    { -56, 696, 800},
    { -216, 592, 728},
    { -224, 552, 696},
    // 14 seconds
    { -88, 400, 488},
    { -120, 416, 344},
    { -184, 480, 480},
    { -240, 512, 584},
    { -224, 656, 816},
    { -248, 840, 1056},
    { -64, 728, 872},
    { -360, 936, 912},
    { -256, 872, 1184},
    { 24, 808, 800},
    { 40, 712, 696},
    { -48, 568, 616},
    { -120, 416, 424},
    { -168, 376, 344},
    { -272, 344, 408},
    { -416, 416, 576},
    { -512, 568, 800},
    { -560, 696, 1056},
    { -400, 808, 1088},
    { -640, 888, 1080},
    { -328, 848, 1360},
    { -128, 544, 808},
    { -144, 456, 720},
    { -176, 400, 688},
    { -96, 336, 464},
    // 15 seconds
    { -88, 368, 416},
    { -128, 464, 496},
    { -176, 656, 752},
    { -112, 736, 880},
    { -152, 808, 896},
    { -120, 752, 848},
    { -392, 824, 816},
    { -416, 872, 1216},
    { -104, 800, 968},
    { 48, 728, 616},
    { 0, 648, 656},
    { -56, 504, 472},
    { -120, 408, 216},
    { -272, 464, 312},
    { -360, 560, 464},
    { -456, 664, 656},
    { -568, 832, 848},
    { -360, 960, 1008},
    { -624, 1016, 1040},
    { -240, 936, 1160},
    { -144, 624, 688},
    { -224, 520, 720},
    { -232, 504, 704},
    { -80, 400, 464},
    { -72, 424, 384},
    // 16 seconds
    { -160, 440, 440},
    { -208, 568, 584},
    { -240, 720, 768},
    { -280, 944, 1016},
    { -128, 840, 960},
    { -400, 976, 896},
    { -304, 896, 1232},
    { -24, 864, 888},
    { 80, 792, 704},
    { 32, 664, 632},
    { -48, 464, 376},
    { -224, 336, 296},
    { -336, 312, 384},
    { -400, 376, 536},
    { -424, 536, 640},
    { -480, 648, 808},
    { -432, 920, 1192},
    { -544, 968, 976},
    { -304, 944, 1496},
    { -48, 672, 800},
    { -168, 496, 792},
    { -240, 496, 800},
    { -112, 368, 560},
    { -96, 368, 368},
    { -128, 376, 408},
    // 17 seconds
    { -216, 512, 584},
    { -192, 624, 744},
    { -176, 792, 968},
    { -24, 792, 1040},
    { -176, 824, 888},
    { -328, 880, 1400},
    { -32, 848, 1040},
    { 112, 768, 736},
    { 32, 688, 632},
    { 0, 512, 384},
    { -80, 424, 248},
    { -136, 384, 312},
    { -272, 392, 464},
    { -448, 528, 648},
    { -536, 608, 744},
    { -576, 808, 944},
    { -416, 864, 1040},
    { -416, 1200, 1480},
    { 144, 920, 944},
    { -24, 728, 704},
    { -136, 624, 688},
    { -136, 512, 544},
    { -112, 440, 368},
    { -160, 464, 392},
    { -200, 488, 448},
    // 18 seconds
    { -216, 760, 648},
    { -136, 840, 856},
    { -120, 984, 920},
    { -168, 832, 776},
    { -248, 952, 672},
    { -184, 1048, 1144},
    { 72, 960, 728},
    { 48, 832, 600},
    { -48, 640, 496},
    { -128, 424, 280},
    { -256, 392, 320},
    { -328, 416, 456},
    { -384, 512, 528},
    { -360, 632, 608},
    { -536, 848, 904},
    { -432, 992, 1008},
    { -560, 1080, 936},
    { -256, 1064, 1152},
    { -80, 752, 704},
    { -192, 608, 784},
    { -160, 504, 704},
    { -56, 432, 480},
    { -56, 408, 336},
    { -104, 408, 360},
    { -240, 504, 552},
    // 19 seconds
    { -256, 672, 800},
    { -264, 840, 1000},
    { -96, 888, 864},
    { -200, 928, 880},
    { -224, 968, 1376},
    { 48, 832, 952},
    { 112, 696, 720},
    { -8, 592, 632},
    { -88, 504, 440},
    { -136, 416, 320},
    { -200, 416, 304},
    { -312, 440, 408},
    { -472, 592, 640},
    { -592, 640, 792},
    { -552, 816, 1104},
    { -568, 888, 1152},
    { -288, 1032, 1480},
    { -64, 696, 808},
    { -152, 624, 816},
    { -184, 632, 696},
    { -16, 408, 480},
    { -40, 472, 320},
    { -96, 456, 328},
    { -168, 544, 480},
    { -144, 696, 688},
    // 20 seconds
    { -160, 904, 920},
    { -56, 808, 952},
    { -216, 928, 896},
    { -272, 896, 1344},
    { 48, 856, 944},
    { 64, 744, 736},
    { -32, 648, 528},
    { -80, 456, 280},
    { -160, 408, 280},
    { -248, 376, 320},
    { -296, 440, 496},
    { -400, 536, 712},
    { -528, 648, 968},
    { -488, 776, 1288},
    { -616, 808, 1216},
    { -344, 944, 1544},
    { -96, 632, 920},
    { -216, 560, 976},
    { -152, 504, 768},
    { -32, 376, 440},
    { -32, 376, 288},
    { -80, 416, 296},
    { -176, 504, 480},
    { -184, 672, 736},
    { -216, 816, 896},
    // 21 seconds
    { -152, 816, 1048},
    { -328, 832, 872},
    { -416, 912, 1200},
    { -144, 816, 1008},
    { 40, 736, 736},
    { -40, 640, 624},
    { -48, 528, 480},
    { -96, 416, 352},
    { -176, 400, 328},
    { -256, 416, 440},
    { -352, 512, 600},
    { -464, 624, 768},
    { -576, 736, 976},
    { -512, 888, 1072},
    { -656, 1000, 1336},
    { -224, 856, 1056},
    { -176, 632, 784},
    { -240, 568, 760},
    { -176, 512, 664},
    { -64, 408, 472},
    { -96, 424, 384},
    { -160, 480, 440},
    { -216, 600, 640},
    { -160, 696, 656},
    { -168, 864, 824},
    // 22 seconds
    { -144, 784, 776},
    { -312, 952, 904},
    { -312, 1072, 1104},
    { -72, 1032, 744},
    { 16, 904, 640},
    { -8, 744, 448},
    { -48, 592, 328},
    { -56, 464, 296},
    { -112, 432, 304},
    { -216, 480, 456},
    { -368, 584, 616},
    { -424, 680, 632},
    { -536, 928, 824},
    { -616, 872, 984},
    { -672, 784, 896},
    { -680, 1080, 1320},
    { -192, 800, 872},
    { -144, 696, 840},
    { -32, 656, 744},
    { 48, 496, 440},
    { 24, 432, 344},
    { -80, 480, 376},
    { -144, 568, 544},
    { -160, 656, 680},
    { -216, 856, 824},
    // 23 seconds
    { -120, 784, 864},
    { -336, 960, 848},
    { -328, 1008, 1424},
    { 40, 928, 968},
    { 136, 840, 816},
    { 112, 640, 648},
    { -24, 408, 312},
    { -160, 336, 264},
    { -312, 360, 360},
    { -424, 432, 432},
    { -552, 600, 712},
    { -560, 824, 944},
    { -344, 920, 1080},
    { -472, 920, 936},
    { -448, 880, 1328},
    { -184, 648, 912},
    { -152, 576, 816},
    { -160, 488, 728},
    { -112, 400, 584},
    { -80, 376, 392},
    { -152, 408, 400},
    { -216, 488, 512},
    { -224, 640, 720},
    { -248, 784, 896},
    { -120, 808, 912},
    // 24 seconds
    { -304, 904, 912},
    { -312, 896, 1376},
    { -88, 880, 968},
    { 80, 688, 680},
    { -8, 616, 536},
    { -56, 488, 448},
    { -120, 480, 448},
    { -168, 432, 416},
    { -232, 544, 536},
    { -320, 672, 712},
    { -336, 696, 704},
    { -504, 840, 904},
    { -472, 840, 1040},
    { -512, 896, 1080},
    { -200, 880, 1232},
    { -24, 616, 784},
    { -64, 512, 760},
    { -48, 520, 712},
    { 16, 384, 496},
    { -8, 368, 320},
    { -64, 432, 416},
    { -168, 504, 520},
    { -160, 712, 784},
    { -264, 904, 952},
    { -208, 928, 1120},
    // 25 seconds
    { -248, 880, 904},
    { -264, 848, 936},
    { -88, 776, 1032},
    { 64, 712, 760},
    { 96, 624, 616},
    { 16, 528, 432},
    { -64, 384, 336},
    { -200, 384, 360},
    { -312, 448, 512},
    { -424, 592, 736},
    { -456, 648, 776},
    { -560, 792, 952},
    { -440, 808, 968},
    { -496, 904, 1048},
    { -192, 824, 984},
    { -80, 696, 744},
    { -184, 632, 816},
    { -104, 584, 720},
    { -40, 456, 488},
    { -88, 416, 384},
    { -168, 488, 440},
    { -200, 600, 616},
    { -176, 752, 800},
    { -104, 848, 904},
    { -32, 776, 864},
    // 26 seconds
    { -256, 896, 872},
    { -176, 928, 1360},
    { 56, 920, 1000},
    { 88, 744, 792},
    { -24, 640, 504},
    { -80, 416, 248},
    { -184, 392, 280},
    { -272, 400, 384},
    { -328, 480, 504},
    { -352, 608, 672},
    { -544, 752, 896},
    { -360, 864, 1016},
    { -584, 960, 976},
    { -288, 1176, 1472},
    { 56, 888, 856},
    { -128, 752, 856},
    { -168, 632, 672},
    { -48, 432, 432},
    { -56, 440, 280},
    { -120, 448, 312},
    { -256, 664, 440},
    { -184, 744, 528},
    { -216, 904, 752},
    { -112, 952, 848},
    { -144, 800, 560},
    // 27 seconds
    { -344, 1144, 912},
    { -136, 1096, 1120},
    { 168, 1000, 656},
    { -8, 832, 696},
    { -16, 608, 360},
    { -80, 424, 248},
    { -184, 384, 320},
    { -256, 384, 384},
    { -408, 512, 576},
    { -512, 688, 720},
    { -552, 1024, 1024},
    { -312, 1008, 952},
    { -520, 1216, 1136},
    { -56, 992, 968},
    { -56, 776, 704},
    { -160, 712, 736},
    { -96, 576, 624},
    { -16, 504, 392},
    { -72, 504, 344},
    { -104, 496, 392},
    { -136, 680, 488},
    { -136, 848, 640},
    { -56, 1072, 808},
    { -80, 976, 704},
    { -160, 1048, 600},
    // 28 seconds
    { -240, 1128, 1104},
    { 56, 1000, 576},
    { 64, 944, 576},
    { 0, 760, 416},
    { -72, 488, 232},
    { -176, 480, 288},
    { -288, 440, 424},
    { -368, 608, 552},
    { -376, 696, 568},
    { -496, 872, 784},
    { -448, 1000, 864},
    { -648, 1320, 1160},
    { -16, 1152, 1088},
    { 16, 776, 648},
    { -152, 672, 656},
    { -184, 640, 616},
    { -40, 440, 376},
    { -72, 504, 320},
    { -128, 512, 360},
    { -176, 608, 512},
    { -176, 800, 624},
    { -168, 976, 896},
    { -8, 832, 792},
    { -152, 976, 736},
    { -152, 1024, 1216},
    // 29 seconds
    { 24, 1016, 992},
    { 168, 912, 752},
    { 48, 720, 536},
    { -16, 528, 232},
    { -128, 424, 232},
    { -264, 432, 360},
    { -376, 496, 472},
    { -400, 640, 568},
    { -544, 784, 736},
    { -488, 952, 984},
    { -592, 1040, 912},
    { -432, 1224, 1464},
    { -56, 880, 768},
    { -224, 688, 848},
    { -224, 584, 704},
    { -64, 384, 464},
    { -120, 440, 336},
    { -144, 472, 360},
    { -216, 552, 496},
    { -160, 688, 608},
    { -184, 808, 720},
    { -56, 792, 728},
    { -160, 832, 616},
    { -352, 1008, 1112},
    { -264, 1080, 1120},
    // 30 seconds
    { 104, 1016, 728},
    { -80, 840, 656},
    { -80, 600, 296},
    { -104, 424, 280},
    { -216, 376, 304},
    { -344, 368, 392},
    { -416, 472, 448},
    { -584, 664, 688},
    { -592, 920, 960},
    { -624, 952, 952},
    { -600, 1456, 1384},
    { 40, 1008, 752},
    { -248, 824, 824},
    { -160, 824, 640},
    { -112, 520, 456},
    { -64, 544, 272},
    { -160, 608, 264},
    { -192, 592, 416},
    { -176, 736, 456},
    { -160, 784, 640},
    { -112, 912, 632},
    { -136, 768, 552},
    { -456, 1048, 744},
    { -336, 1144, 1112},
    { -48, 1096, 640},
    // 31 seconds
    { -144, 968, 656},
    { -104, 736, 392},
    { -144, 536, 192},
    { -208, 432, 240},
    { -264, 440, 240},
    { -352, 576, 400},
    { -424, 656, 496},
    { -528, 888, 680},
    { -456, 1016, 792},
    { -752, 1488, 1024},
    { -200, 1240, 912},
    { -72, 912, 584},
    { -256, 744, 624},
    { -168, 616, 504},
    { -96, 544, 336},
    { -144, 528, 320},
    { -176, 560, 328},
    { -208, 728, 448},
    { -144, 864, 568},
    { -152, 1048, 632},
    { -120, 896, 576},
    { -368, 1064, 592},
    { -328, 1216, 1064},
    { -88, 1072, 664},
    { 0, 968, 464},
    // 32 seconds
    { -120, 688, 336},
    { -88, 480, 168},
    { -184, 432, 248},
    { -256, 456, 360},
    { -344, 600, 544},
    { -400, 688, 656},
    { -480, 808, 784},
    { -480, 1000, 992},
    { -552, 1096, 784},
    { -536, 1392, 1368},
    { 80, 984, 616},
    { -152, 720, 624},
    { -168, 640, 552},
    { -136, 504, 448},
    { -112, 512, 288},
    { -160, 544, 336},
    { -232, 656, 480},
    { -216, 792, 592},
    { -200, 928, 712},
    { -152, 992, 808},
    { -184, 952, 752},
    { -256, 952, 776},
    { -168, 984, 936},
    { 96, 864, 600},
    { 0, 760, 576},
    // 33 seconds
    { -8, 672, 352},
    { -88, 488, 216},
    { -184, 472, 240},
    { -312, 496, 384},
    { -440, 640, 600},
    { -504, 744, 720},
    { -568, 904, 1000},
    { -568, 1000, 992},
    { -520, 1296, 1544},
    { 64, 936, 784},
    { -104, 632, 672},
    { -136, 560, 544},
    { -120, 440, 456},
    { -56, 408, 336},
    { -112, 448, 344},
    { -160, 472, 464},
    { -200, 656, 688},
    { -216, 728, 736},
    { -200, 952, 936},
    { -176, 896, 912},
    { -304, 1072, 1048},
    { -160, 984, 1248},
    { 216, 936, 816},
    { 176, 832, 656},
    { 120, 728, 464},
    // 34 seconds
    { 48, 520, 240},
    { -48, 432, 224},
    { -136, 416, 288},
    { -240, 480, 440},
    { -352, 608, 608},
    { -488, 768, 872},
    { -504, 944, 1112},
    { -552, 1000, 1128},
    { -432, 1112, 1536},
    { -24, 872, 880},
    { -64, 600, 760},
    { -104, 536, 600},
    { -96, 392, 504},
    { -64, 352, 336},
    { -96, 336, 296},
    { -160, 408, 408},
    { -216, 504, 544},
    { -264, 688, 792},
    { -288, 824, 952},
    { -136, 832, 960},
    { -280, 896, 896},
    { -360, 904, 1256},
    { -168, 864, 1016},
    { 56, 824, 720},
    { 8, 776, 752},
    // 35 seconds
    { 8, 520, 472},
    { -72, 408, 288},
    { -168, 384, 280},
    { -304, 352, 352},
    { -448, 448, 464},
    { -552, 592, 680},
    { -624, 664, 816},
    { -576, 856, 992},
    { -712, 888, 1048},
    { -408, 1072, 1456},
    { -72, 736, 856},
    { -256, 704, 904},
    { -192, 568, 696},
    { -72, 408, 488},
    { -64, 384, 296},
    { -88, 392, 264},
    { -144, 472, 408},
    { -232, 632, 576},
    { -272, 872, 776},
    { -216, 880, 872},
    { -288, 904, 656},
    { -424, 1104, 1208},
    { -216, 1088, 1120},
    { 8, 944, 752},
    { -136, 736, 600},
    // 36 seconds
    { -96, 544, 336},
    { -152, 408, 296},
    { -216, 352, 280},
    { -320, 400, 384},
    { -448, 472, 552},
    { -520, 632, 656},
    { -648, 856, 888},
    { -576, 928, 976},
    { -584, 1416, 1432},
    { 24, 1016, 800},
    { -208, 752, 736},
    { -240, 752, 720},
    { -96, 544, 576},
    { 16, 512, 312},
    { -64, 456, 224},
    { -144, 520, 304},
    { -232, 640, 504},
    { -192, 840, 696},
    { -128, 984, 896},
    { -104, 848, 696},
    { -376, 1032, 920},
    { -256, 952, 1016},
    { -56, 960, 712},
    { -72, 808, 640},
    { -88, 752, 472},
    // 37 seconds
    { -96, 504, 240},
    { -152, 440, 184},
    { -224, 416, 232},
    { -336, 440, 376},
    { -432, 568, 544},
    { -624, 848, 888},
    { -400, 1008, 1088},
    { -736, 1280, 1192},
    { -184, 1088, 1200},
    { -96, 792, 768},
    { -232, 656, 736},
    { -216, 544, 704},
    { -40, 392, 392},
    { -88, 376, 264},
    { -120, 392, 328},
    { -216, 504, 432},
    { -232, 696, 656},
    { -216, 904, 936},
    { -72, 840, 848},
    { -224, 944, 808},
    { -352, 1056, 1312},
    { -96, 952, 960},
    { 80, 864, 672},
    { 8, 720, 576},
    { 0, 552, 352},
    // 38 seconds
    { -96, 424, 328},
    { -160, 376, 360},
    { -248, 408, 472},
    { -384, 528, 640},
    { -432, 600, 696},
    { -592, 784, 896},
    { -568, 1016, 1184},
    { -440, 1136, 1592},
    { -32, 888, 968},
    { -160, 624, 744},
    { -232, 576, 792},
    { -176, 448, 728},
    { -48, 392, 456},
    { -72, 400, 400},
    { -96, 432, 400},
    { -128, 568, 536},
    { -112, 672, 688},
    { -104, 832, 880},
    { -112, 856, 872},
    { -184, 960, 896},
    { -184, 992, 1248},
    { 72, 920, 816},
    { -8, 760, 672},
    { -48, 688, 520},
    { -40, 440, 296},
    // 39 seconds
    { -160, 408, 336},
    { -232, 376, 344},
    { -408, 504, 560},
    { -528, 640, 744},
    { -600, 800, 856},
    { -472, 856, 1152},
    { -536, 1016, 1008},
    { -280, 992, 1168},
    { -64, 840, 776},
    { -168, 656, 600},
    { -112, 616, 504},
    { -32, 464, 296},
    { -48, 456, 224},
    { -136, 520, 352},
    { -176, 704, 504},
    { -104, 880, 680},
    { -72, 1248, 856},
    { -96, 968, 800},
    { -232, 1064, 680},
    { -208, 1136, 968},
    { 40, 992, 672},
    { 112, 888, 544},
    { 16, 752, 432},
    { -8, 592, 288},
    { -104, 488, 216},
    // 40 seconds
    { -168, 480, 256},
    { -264, 536, 352},
    { -424, 688, 584},
    { -520, 760, 648},
    { -624, 920, 944},
    { -656, 1032, 960},
    { -344, 1368, 1456},
    { 48, 952, 760},
    { -136, 696, 712},
    { -176, 640, 560},
    { -88, 432, 432},
    { -32, 448, 272},
    { -80, 464, 288},
    { -128, 616, 392},
    { -120, 760, 616},
    { -128, 864, 800},
    { 0, 888, 840},
    { -168, 1000, 872},
    { -304, 1064, 1344},
    { 8, 992, 1016},
    { 272, 968, 656},
    { 104, 792, 624},
    { 24, 528, 312},
    { -16, 448, 128},
    { -112, 376, 256},
    // 41 seconds
    { -232, 400, 296},
    { -352, 576, 432},
    { -488, 712, 640},
    { -576, 992, 880},
    { -520, 1064, 840},
    { -744, 1344, 1016},
    { -288, 1232, 992},
    { -200, 992, 768},
    { -184, 808, 656},
    { -144, 696, 552},
    { -48, 448, 304},
    { -64, 400, 232},
    { -144, 448, 240},
    { -216, 584, 392},
    { -160, 736, 440},
    { -152, 1112, 792},
    { -24, 912, 592},
    { -200, 1232, 640},
    { -272, 1208, 1136},
    { -128, 1208, 800},
    { 56, 960, 600},
    { -64, 800, 528},
    { -80, 568, 288},
    { -136, 440, 280},
    { -216, 408, 320},
    // 42 seconds
    { -296, 408, 400},
    { -408, 584, 632},
    { -512, 648, 704},
    { -528, 864, 1008},
    { -504, 944, 936},
    { -520, 1288, 1552},
    { -72, 984, 944},
    { -152, 816, 912},
    { -168, 712, 768},
    { -80, 496, 576},
    { 0, 416, 312},
    { -64, 400, 240},
    { -128, 488, 336},
    { -168, 600, 472},
    { -136, 768, 640},
    { -128, 984, 864},
    { -64, 832, 664},
    { -248, 1072, 800},
    { -352, 1088, 1152},
    { -32, 1032, 736},
    { -8, 856, 584},
    { -72, 720, 504},
    { -72, 496, 320},
    { -120, 432, 368},
    { -192, 504, 440},
    // 43 seconds
    { -216, 584, 504},
    { -248, 600, 424},
    { -352, 608, 536},
    { -312, 560, 520},
    { -688, 1288, 1440},
    { 184, 1200, 1208},
    { 56, 1312, 1144},
    { 216, 936, 792},
    { 312, 616, 496},
    { 392, 488, 240},
    { 368, 432, 304},
    { 416, 456, 360},
    { 392, 440, 424},
    { 456, 520, 472},
    { 472, 640, 632},
    { 544, 688, 616},
    { 592, 664, 536},
    { 600, 632, 512},
    { 672, 728, 448},
    { 768, 824, 456},
    { 824, 800, 440},
    { 880, 768, 424},
    { 912, 672, 360},
    { 944, 680, 304},
    { 880, 672, 304},
    // 44 seconds
    { 840, 632, 224},
    { 840, 552, 208},
    { 864, 464, 184},
    { 912, 512, 112},
    { 960, 512, 136},
    { 1008, 496, 144},
    { 1080, 456, 128},
    { 1064, 456, 136},
    { 1048, 472, 168},
    { 1064, 480, 264},
    { 1056, 584, 320},
    { 1016, 592, 344},
    { 968, 568, 328},
    { 920, 616, 424},
    { 920, 648, 472},
    { 912, 712, 552},
    { 920, 688, 552},
    { 880, 680, 504},
    { 768, 648, 416},
    { 656, 632, 360},
    { 488, 632, 344},
    { 336, 632, 296},
    { 248, 656, 368},
    { 184, 632, 400},
    { 192, 640, 416},
    // 45 seconds
    { 120, 640, 432},
    { 48, 672, 424},
    { -8, 736, 480},
    { -80, 848, 624},
    { -64, 944, 856},
    { 40, 1000, 904},
    { 56, 1040, 944},
    { 72, 1048, 1128},
    { 160, 704, 944},
    { -24, 712, 888},
    { -144, 616, 760},
    { -160, 488, 488},
    { -120, 408, 312},
    { -160, 424, 352},
    { -192, 424, 392},
    { -232, 488, 552},
    { -336, 744, 672},
    { -304, 952, 800},
    { -248, 1008, 824},
    { -208, 1000, 832},
    { -216, 1112, 1008},
    { 8, 1048, 888},
    { 144, 992, 656},
    { -16, 816, 544},
    { -56, 648, 352},
    // 46 seconds
    { -128, 496, 240},
    { -152, 408, 216},
    { -224, 392, 264},
    { -320, 480, 360},
    { -472, 616, 576},
    { -656, 800, 736},
    { -600, 1040, 1016},
    { -592, 1048, 928},
    { -440, 1312, 1232},
    { -24, 1008, 832},
    { -168, 848, 816},
    { -144, 672, 688},
    { -56, 536, 408},
    { -8, 400, 200},
    { -56, 384, 168},
    { -152, 472, 304},
    { -280, 696, 456},
    { -296, 1040, 808},
    { -208, 1160, 752},
    { -160, 952, 488},
    { -440, 1240, 936},
    { -240, 1264, 864},
    { 24, 1112, 640},
    { -104, 920, 464},
    { -88, 624, 304},
    // 47 seconds
    { -112, 440, 224},
    { -160, 360, 208},
    { -288, 400, 336},
    { -408, 472, 424},
    { -480, 592, 512},
    { -688, 880, 792},
    { -544, 960, 816},
    { -816, 1296, 1240},
    { -328, 1144, 968},
    { -208, 904, 752},
    { -280, 648, 656},
    { -216, 520, 440},
    { -128, 424, 264},
    { -168, 432, 248},
    { -232, 488, 288},
    { -384, 752, 472},
    { -136, 808, 776},
    { -224, 1128, 816},
    { -128, 896, 544},
    { -264, 1024, 640},
    { -264, 1008, 920},
    { -80, 1184, 696},
    { 88, 936, 512},
    { -56, 808, 480},
    { -56, 504, 264},
    // 48 seconds
    { -136, 432, 224},
    { -216, 432, 304},
    { -320, 456, 400},
    { -488, 656, 656},
    { -600, 752, 736},
    { -680, 992, 1040},
    { -640, 1032, 952},
    { -472, 1360, 1448},
    { -40, 936, 776},
    { -136, 768, 784},
    { -208, 632, 672},
    { -104, 448, 464},
    { -72, 416, 272},
    { -128, 416, 288},
    { -256, 472, 344},
    { -264, 600, 576},
    { -320, 800, 616},
    { -216, 976, 872},
    { -184, 928, 680},
    { -240, 976, 912},
    { -264, 1048, 1048},
    { 56, 984, 736},
    { -32, 920, 680},
    { -64, 728, 496},
    { -96, 472, 208},
    // 49 seconds
    { -168, 400, 232},
    { -264, 368, 312},
    { -416, 464, 512},
    { -512, 632, 712},
    { -696, 776, 880},
    { -608, 912, 976},
    { -688, 1000, 1056},
    { -472, 1192, 1232},
    { -112, 1008, 864},
    { -192, 848, 880},
    { -136, 640, 632},
    { -56, 448, 344},
    { -56, 376, 216},
    { -144, 392, 216},
    { -296, 520, 336},
    { -376, 672, 440},
    { -416, 904, 656},
    { -200, 1016, 720},
    { -264, 984, 600},
    { -352, 1064, 968},
    { -248, 992, 840},
    { -48, 1056, 808},
    { -120, 912, 736},
    { -120, 696, 464},
    { -144, 512, 240},
    // 50 seconds
    { -160, 416, 192},
    { -232, 376, 232},
    { -376, 416, 368},
    { -496, 576, 560},
    { -792, 760, 816},
    { -656, 1032, 1112},
    { -632, 1032, 968},
    { -424, 1072, 1192},
    { -224, 824, 856},
    { -272, 680, 872},
    { -224, 592, 776},
    { -104, 472, 552},
    { -96, 384, 360},
    { -152, 400, 368},
    { -296, 456, 472},
    { -328, 536, 600},
    { -352, 592, 656},
    { -384, 656, 680},
    { -272, 616, 832},
    { -368, 672, 776},
    { -312, 640, 1224},
    { -208, 640, 1144},
    { 112, 552, 912},
    { 88, 520, 984},
    { 8, 400, 728},
    // 51 seconds
    { -64, 296, 560},
    { -144, 256, 528},
    { -240, 240, 656},
    { -328, 248, 784},
    { -360, 264, 824},
    { -520, 264, 984},
    { -520, 304, 1168},
    { -544, 248, 968},
    { -664, 304, 1864},
    { -88, 296, 1488},
    { -80, 208, 1240},
    { -144, 256, 1064},
    { -80, 248, 696},
    { -96, 208, 496},
    { -192, 296, 528},
    { -232, 280, 552},
    { -240, 304, 600},
    { -168, 312, 728},
    { -256, 352, 776},
    { -192, 320, 728},
    { -296, 384, 704},
    { -408, 448, 1176},
    { -400, 496, 1536},
    { -24, 680, 1360},
    { -16, 688, 1240},
    // 52 seconds
    { -128, 544, 736},
    { -184, 464, 528},
    { -176, 408, 440},
    { -208, 344, 504},
    { -256, 320, 624},
    { -304, 336, 664},
    { -464, 416, 816},
    { -600, 528, 1096},
    { -408, 536, 984},
    { -488, 552, 808},
    { -544, 784, 1112},
    { -296, 696, 976},
    { -192, 728, 880},
    { -104, 712, 792},
    { -32, 600, 664},
    { -24, 664, 728},
    { -8, 672, 648},
    { 0, 776, 656},
    { 16, 808, 568},
    { 24, 856, 544},
    { -8, 976, 464},
    { -64, 1016, 360},
    { -88, 992, 400},
    { -40, 1208, 136},
    { -72, 768, 16},
    // 53 seconds
    { -136, 928, -16},
    { -232, 1072, 8},
    { -224, 1040, -64},
    { -224, 1056, -72},
    { -232, 1024, -136},
    { -208, 1224, -160},
    { -240, 1056, -216},
    { -232, 1104, -240},
    { -192, 1072, -264},
    { -144, 1072, -200},
    { -64, 1144, -88},
    { -128, 1048, -184},
    { -120, 912, -216},
    { -200, 824, -88},
    { -248, 1056, -120},
    { -264, 976, -112},
    { -264, 1056, -144},
    { -312, 1056, -208},
    { -264, 928, -312},
    { -16, 728, -752},
    { -120, 568, -264},
    { -624, 1112, -560},
    { -328, 696, -400},
    { -352, 960, -560},
    { -240, 1000, -728},
    // 54 seconds
    { -192, 768, -520},
    { -216, 384, -712},
    { -168, 504, -992},
    { -112, 336, -1016},
    { -216, 280, -944},
    { -120, 208, -1000},
    { -248, 256, -904},
    { -264, 32, -1016},
    { -232, 128, -1024},
    { -208, 56, -1040},
    { -216, 152, -984},
    { -240, 168, -872},
    { -256, 168, -936},
    { -240, 136, -888},
    { -264, 88, -880},
    { -248, 64, -920},
    { -200, 32, -928},
    { -136, 48, -1080},
    { -104, 24, -1104},
    { -120, -16, -1128},
    { -104, 0, -1152},
    { 584, -264, -544},
    { -192, -96, -1024},
    { -96, 128, -1000},
    { -112, 144, -1048},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

