/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:11:00 local
AccelRawData *activity_sample_walk_200_pbl_25667_13(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25667_13
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -184, 64, -1024},
    { -192, 56, -1032},
    { -144, 40, -1064},
    { -128, 24, -1040},
    { -184, 24, -1032},
    { -160, 40, -1032},
    { -120, 32, -1000},
    { -176, 40, -992},
    { -192, 24, -1008},
    { -200, 48, -1016},
    { -200, 56, -1032},
    { -184, 48, -1064},
    { -160, 56, -1024},
    { -248, 672, -1008},
    { -40, 56, -1072},
    { -72, 0, -1032},
    { -152, -16, -984},
    { -112, 40, -1024},
    { -88, -8, -1024},
    { -136, 24, -1008},
    { -128, 32, -1040},
    { -96, 56, -1040},
    { -160, 24, -1032},
    { -112, 8, -1064},
    { -192, 8, -1040},
    // 1 seconds
    { -176, -24, -1056},
    { -64, -24, -1016},
    { -152, 32, -1008},
    { -128, -8, -1024},
    { -120, -16, -1008},
    { -136, 0, -1032},
    { -120, -16, -1016},
    { -176, -16, -992},
    { -136, -48, -1040},
    { -160, -64, -1048},
    { -144, -64, -1064},
    { -184, -64, -1080},
    { -136, -48, -1056},
    { -40, 72, -1080},
    { -168, -56, -1024},
    { -152, -64, -1016},
    { -176, -96, -984},
    { -128, -152, -952},
    { -144, -96, -968},
    { -144, -40, -1048},
    { -152, 8, -1024},
    { -152, 56, -1032},
    { -144, 72, -1024},
    { -120, 40, -968},
    { -152, 168, -864},
    // 2 seconds
    { -256, 384, -728},
    { -320, 688, -520},
    { -264, 1016, -304},
    { -264, 1136, -72},
    { -288, 992, 64},
    { -320, 880, 112},
    { -336, 872, 184},
    { -360, 856, 232},
    { -352, 848, 272},
    { -368, 856, 296},
    { -336, 864, 352},
    { -328, 864, 360},
    { -312, 848, 360},
    { -312, 896, 328},
    { -288, 896, 336},
    { -256, 872, 320},
    { -240, 928, 288},
    { -112, 936, 248},
    { -72, 944, 208},
    { -56, 888, 192},
    { -48, 864, 200},
    { -8, 864, 216},
    { 24, 920, 192},
    { 0, 920, 136},
    { -48, 896, 96},
    // 3 seconds
    { -104, 840, 80},
    { -112, 880, 64},
    { -160, 880, 96},
    { -208, 856, 120},
    { -288, 896, 176},
    { -272, 920, 176},
    { -264, 856, 176},
    { -288, 808, 200},
    { -344, 888, 224},
    { -328, 968, 488},
    { -96, 1200, 688},
    { -104, 960, 704},
    { -144, 744, 688},
    { -144, 640, 640},
    { -120, 536, 728},
    { -80, 424, 664},
    { -104, 408, 648},
    { -176, 408, 616},
    { -352, 464, 480},
    { -320, 768, 408},
    { -416, 816, 416},
    { -448, 1040, 392},
    { -464, 912, 416},
    { -400, 848, 528},
    { -352, 968, 528},
    // 4 seconds
    { -336, 952, 376},
    { -392, 1152, 264},
    { -296, 1040, 256},
    { -136, 984, 232},
    { -88, 728, 312},
    { -72, 632, 272},
    { -72, 680, 224},
    { -152, 712, 136},
    { -160, 752, 200},
    { -176, 784, 168},
    { -192, 816, 136},
    { -176, 864, 72},
    { -184, 936, -80},
    { -256, 896, -88},
    { -360, 944, 88},
    { -368, 1056, 104},
    { -336, 1104, 88},
    { -344, 960, -40},
    { -368, 880, -152},
    { -320, 1048, 0},
    { -176, 1192, 176},
    { -144, 1120, 128},
    { -136, 896, 56},
    { -168, 856, -40},
    { -144, 864, -168},
    // 5 seconds
    { -216, 776, 16},
    { -304, 648, -88},
    { -336, 680, -240},
    { -320, 744, -192},
    { -368, 752, -184},
    { -360, 888, -248},
    { -384, 912, -248},
    { -392, 1016, -304},
    { -352, 1208, -368},
    { -344, 1064, -304},
    { -272, 1040, -272},
    { -272, 1016, -168},
    { -56, 1096, -104},
    { 56, 984, 24},
    { 0, 824, 56},
    { -48, 776, 168},
    { -136, 688, 168},
    { -232, 600, 184},
    { -280, 592, 240},
    { -264, 704, 304},
    { -344, 544, 432},
    { -376, 840, 544},
    { -184, 792, 320},
    { -152, 808, 176},
    { 56, 1256, 968},
    // 6 seconds
    { 216, 1232, 896},
    { 104, 1168, 1080},
    { 16, 872, 840},
    { -80, 672, 744},
    { -80, 656, 544},
    { -96, 536, 312},
    { -136, 536, 184},
    { -248, 648, 128},
    { -320, 496, 128},
    { -440, 616, -72},
    { -504, 816, -312},
    { -528, 928, -496},
    { -416, 1144, -616},
    { -392, 960, -672},
    { -344, 616, -608},
    { -168, 264, -624},
    { 304, 96, -448},
    { 728, 144, 8},
    { 1128, 376, -64},
    { 1368, 520, -184},
    { 1560, 336, 0},
    { 1712, 136, 192},
    { 1952, 56, 64},
    { 2248, 192, -40},
    { 2088, 384, 232},
    // 7 seconds
    { 1840, 464, 280},
    { 1584, 512, 8},
    { 1496, 392, -56},
    { 1560, 608, 56},
    { 1096, 952, 176},
    { 968, 816, 88},
    { 848, 608, -56},
    { 1088, 424, -112},
    { 1352, 424, 24},
    { 1792, 336, 88},
    { 1800, 208, 64},
    { 1736, 32, 96},
    { 1768, -56, 80},
    { 1760, -32, 0},
    { 1584, 8, 0},
    { 1240, -16, -72},
    { 1080, -40, -192},
    { 968, -152, -168},
    { 456, -576, -80},
    { 872, -400, -88},
    { 1240, -8, -304},
    { 1248, 24, -360},
    { 1576, -144, -152},
    { 1672, -96, -16},
    { 1488, 48, 24},
    // 8 seconds
    { 1496, 208, -40},
    { 1440, 312, -16},
    { 1392, 336, 72},
    { 1288, 256, -64},
    { 1368, 216, 56},
    { 1552, 536, 152},
    { 1016, 760, 168},
    { 968, 616, 128},
    { 1064, 544, 72},
    { 1080, 368, -72},
    { 1272, 312, 32},
    { 1656, 368, 96},
    { 1744, 296, 96},
    { 1576, 64, 128},
    { 1584, -104, 112},
    { 1552, -104, 16},
    { 1424, -48, -24},
    { 1168, -40, -56},
    { 1112, -64, -88},
    { 992, -64, -72},
    { 568, -200, -80},
    { 744, -168, -176},
    { 904, -96, -16},
    { 1056, 64, -144},
    { 1256, 80, -280},
    // 9 seconds
    { 1656, 48, -232},
    { 1512, 112, -80},
    { 1216, 152, -72},
    { 1176, 256, -56},
    { 1184, 224, -136},
    { 1200, 144, -72},
    { 1216, 168, 40},
    { 1640, 360, 144},
    { 1216, 672, 456},
    { 1008, 744, 16},
    { 1168, 440, 80},
    { 1024, 360, -32},
    { 1096, 328, 8},
    { 1416, 400, 136},
    { 1544, 312, 96},
    { 1344, 64, 88},
    { 1400, -80, 104},
    { 1424, -80, 8},
    { 1296, -16, 0},
    { 1080, 0, 16},
    { 1176, -40, -16},
    { 1016, -8, -88},
    { 720, -104, -128},
    { 960, -192, -32},
    { 1016, -80, -104},
    // 10 seconds
    { 1104, 80, -256},
    { 1280, 40, -256},
    { 1344, 24, -328},
    { 1040, 56, -272},
    { 896, 32, -88},
    { 1080, 144, -152},
    { 1128, 232, -80},
    { 1096, 272, -56},
    { 1488, 232, 40},
    { 1560, 512, 152},
    { 1088, 704, 72},
    { 1264, 512, 16},
    { 976, 432, -96},
    { 1024, 296, -32},
    { 1200, 328, 56},
    { 1480, 280, 48},
    { 1240, 136, 24},
    { 1176, -32, 72},
    { 1208, -64, 24},
    { 1176, -32, -48},
    { 992, 32, -40},
    { 952, -24, -24},
    { 1192, -40, -8},
    { 856, 8, -96},
    { 1032, -88, -48},
    // 11 seconds
    { 1064, -112, 32},
    { 1160, 80, -208},
    { 1208, 64, -200},
    { 1256, -24, -208},
    { 1016, 56, -264},
    { 784, 64, -160},
    { 872, 136, -168},
    { 1008, 232, -104},
    { 1096, 296, -64},
    { 1112, 280, -80},
    { 1528, 288, -64},
    { 1344, 408, -40},
    { 1152, 352, 16},
    { 1192, 416, -24},
    { 936, 416, -112},
    { 1072, 280, -32},
    { 1272, 264, 80},
    { 1392, 208, 56},
    { 1104, 96, 80},
    { 1024, -40, 104},
    { 1064, -72, 16},
    { 1072, -16, -32},
    { 976, 24, -24},
    { 1112, -48, 24},
    { 1168, -48, 0},
    // 12 seconds
    { 896, -56, -88},
    { 1104, -112, -56},
    { 1144, -48, -80},
    { 1168, 88, -288},
    { 1160, 40, -264},
    { 1144, -16, -240},
    { 864, 24, -168},
    { 752, 64, -112},
    { 872, 144, -88},
    { 968, 192, -40},
    { 1056, 240, -72},
    { 1160, 240, -64},
    { 1512, 296, -40},
    { 1312, 448, 8},
    { 1104, 488, -24},
    { 1024, 360, -112},
    { 920, 320, -128},
    { 1088, 296, -16},
    { 1264, 264, 64},
    { 1368, 184, 48},
    { 1128, 64, 32},
    { 1072, -40, 48},
    { 1120, -48, -40},
    { 1096, 16, -80},
    { 976, 48, -112},
    // 13 seconds
    { 1000, -24, -48},
    { 1192, -56, -72},
    { 840, -96, -136},
    { 1112, -168, -48},
    { 1136, -104, 24},
    { 1200, 80, -248},
    { 1232, 48, -152},
    { 1248, 0, -144},
    { 984, 96, -144},
    { 768, 120, -128},
    { 824, 144, -40},
    { 1000, 168, 16},
    { 1128, 216, -16},
    { 1080, 256, -56},
    { 1376, 248, -24},
    { 1368, 408, -16},
    { 1224, 504, 112},
    { 1272, 536, -120},
    { 896, 304, -136},
    { 984, 208, -32},
    { 1240, 256, 48},
    { 1376, 192, 16},
    { 1128, 80, 0},
    { 1096, -24, 40},
    { 1088, -40, -8},
    // 14 seconds
    { 1056, 16, -32},
    { 984, 16, -8},
    { 1064, -56, 32},
    { 1224, -16, -16},
    { 992, -40, -80},
    { 1144, -112, -40},
    { 1128, -96, -80},
    { 1128, 32, -208},
    { 1120, 24, -224},
    { 1192, 16, -312},
    { 896, 56, -240},
    { 704, 40, -96},
    { 808, 128, -128},
    { 936, 224, -72},
    { 1016, 296, -112},
    { 1208, 272, -128},
    { 1544, 344, -144},
    { 1216, 384, -48},
    { 1272, 328, -96},
    { 1120, 304, -168},
    { 1032, 272, -120},
    { 1152, 240, -48},
    { 1288, 200, 48},
    { 1104, 136, 24},
    { 904, 48, 56},
    // 15 seconds
    { 984, -24, 40},
    { 1072, -24, -32},
    { 1088, 0, -48},
    { 952, 8, -8},
    { 1056, -64, 0},
    { 1224, -48, -72},
    { 944, -24, -136},
    { 1144, -72, -144},
    { 1112, -80, -80},
    { 1120, 48, -192},
    { 1184, 72, -240},
    { 1208, 72, -296},
    { 896, 96, -184},
    { 728, 48, -96},
    { 840, 104, -56},
    { 976, 168, -32},
    { 1096, 208, -80},
    { 1144, 224, -104},
    { 1400, 256, -40},
    { 1184, 448, 16},
    { 1312, 680, -8},
    { 1224, 400, -176},
    { 1016, 168, -48},
    { 1144, 232, 24},
    { 1432, 256, 0},
    // 16 seconds
    { 1176, 128, -24},
    { 1032, -32, 72},
    { 1064, -56, 8},
    { 1112, 0, -32},
    { 1144, 40, -16},
    { 976, -8, 0},
    { 1096, -64, 16},
    { 976, -40, -32},
    { 1064, -96, -16},
    { 1032, -80, 24},
    { 1104, 64, -280},
    { 1152, 56, -272},
    { 1200, -72, -200},
    { 960, -16, -200},
    { 800, 56, -168},
    { 872, 160, -216},
    { 984, 256, -168},
    { 1112, 360, -160},
    { 1160, 376, -192},
    { 1464, 288, -160},
    { 1304, 296, -48},
    { 1112, 288, -64},
    { 1480, 344, -104},
    { 1056, 368, -24},
    { 1144, 280, 88},
    // 17 seconds
    { 1344, 168, 160},
    { 1344, 96, 104},
    { 1112, 16, 88},
    { 1040, -16, 24},
    { 984, -24, -8},
    { 968, -8, -24},
    { 896, 8, -24},
    { 976, -32, -8},
    { 1128, -24, -32},
    { 808, 0, -120},
    { 1088, -16, -104},
    { 1224, -8, -24},
    { 1224, 80, -112},
    { 1248, 96, -120},
    { 1176, 96, -120},
    { 808, 120, -112},
    { 688, 64, -8},
    { 864, 104, 16},
    { 1072, 128, 40},
    { 1032, 200, 0},
    { 1200, 168, 24},
    { 1688, 256, 40},
    { 1344, 608, 336},
    { 1152, 760, -304},
    { 1048, 216, -136},
    // 18 seconds
    { 848, 288, -160},
    { 1128, 336, -24},
    { 1456, 328, 16},
    { 1288, 192, -24},
    { 1056, 0, -16},
    { 1056, -144, 40},
    { 1104, -120, -8},
    { 1104, 0, -8},
    { 960, 40, 8},
    { 1032, -24, -16},
    { 1080, 16, -72},
    { 968, 16, -192},
    { 1112, -112, -56},
    { 1120, -80, 0},
    { 1112, 24, -144},
    { 1104, 72, -208},
    { 992, 88, -232},
    { 752, 88, -128},
    { 744, 64, -80},
    { 936, 64, 0},
    { 1200, 128, 64},
    { 1192, 232, -16},
    { 1216, 224, -104},
    { 1400, 400, -128},
    { 1176, 800, -16},
    // 19 seconds
    { 1288, 272, -144},
    { 1024, 280, -120},
    { 992, 336, -128},
    { 1080, 320, -32},
    { 1256, 296, 0},
    { 1040, 160, 32},
    { 1048, -8, 80},
    { 1136, -80, 48},
    { 1216, -24, -16},
    { 1104, 32, 16},
    { 1216, 24, -40},
    { 1312, -144, -168},
    { 800, -376, -80},
    { 1120, -288, 0},
    { 1200, 16, -120},
    { 1232, 104, -232},
    { 1160, -8, -208},
    { 1120, -48, -184},
    { 792, 16, -200},
    { 680, 24, -152},
    { 832, 72, -112},
    { 1032, 144, -56},
    { 1208, 248, -104},
    { 1080, 304, -168},
    { 1352, 344, -56},
    // 20 seconds
    { 1320, 648, 48},
    { 1000, 312, -32},
    { 1272, 256, -64},
    { 1112, 368, -112},
    { 1120, 304, -24},
    { 1328, 264, 72},
    { 1360, 192, 32},
    { 1128, 48, 48},
    { 1088, -80, 72},
    { 1160, -88, 0},
    { 1136, -8, -48},
    { 952, 48, -72},
    { 968, -16, -80},
    { 1008, -160, -72},
    { 752, -240, -136},
    { 1096, -240, -32},
    { 1384, -56, -32},
    { 1432, 128, -200},
    { 1424, 80, -240},
    { 1256, -8, -208},
    { 840, 24, -72},
    { 752, 40, -88},
    { 856, 136, 24},
    { 1016, 216, 64},
    { 1096, 280, -24},
    // 21 seconds
    { 1064, 288, -72},
    { 1392, 304, -8},
    { 1296, 464, 72},
    { 1336, 520, 32},
    { 1192, 256, -136},
    { 824, 200, -96},
    { 1008, 280, -64},
    { 1264, 280, 8},
    { 1320, 200, 8},
    { 1136, 48, 40},
    { 1104, -64, 40},
    { 1080, -72, 32},
    { 992, -32, 16},
    { 912, 0, 0},
    { 848, -24, 16},
    { 1200, -64, 56},
    { 1024, -16, 40},
    { 1320, -80, 72},
    { 1200, -24, -16},
    { 1200, 96, -224},
    { 1112, 56, -216},
    { 1080, 0, -264},
    { 800, 16, -224},
    { 640, 24, -120},
    { 776, 112, -200},
    // 22 seconds
    { 928, 168, -104},
    { 1104, 232, -152},
    { 1032, 248, -208},
    { 1384, 208, -80},
    { 1336, 280, -88},
    { 1168, 280, 16},
    { 1280, 368, -80},
    { 1000, 432, -136},
    { 1080, 224, -56},
    { 1240, 184, 88},
    { 1304, 112, 24},
    { 1024, 56, -8},
    { 952, -16, 24},
    { 944, 0, -32},
    { 944, 24, -56},
    { 912, 24, -16},
    { 896, -24, -32},
    { 1200, -56, -40},
    { 1096, -56, -112},
    { 1216, -80, -112},
    { 1272, -72, -72},
    { 1272, 32, -192},
    { 1232, 48, -192},
    { 1200, 48, -264},
    { 880, 104, -264},
    // 23 seconds
    { 608, 56, -128},
    { 680, 88, -168},
    { 800, 136, -120},
    { 952, 176, -112},
    { 1000, 232, -232},
    { 1208, 200, -168},
    { 1488, 240, -152},
    { 1152, 272, -80},
    { 1432, 336, -144},
    { 1000, 480, -216},
    { 1056, 240, -72},
    { 1200, 184, 72},
    { 1472, 80, 88},
    { 1232, 48, 0},
    { 1080, -24, 48},
    { 1016, -16, 32},
    { 928, 24, -24},
    { 888, 32, -32},
    { 784, -16, -16},
    { 952, -40, -64},
    { 1064, -24, -80},
    { 840, -8, -208},
    { 1088, -56, -184},
    { 1256, -64, -96},
    { 1312, 64, -168},
    // 24 seconds
    { 1344, 64, -224},
    { 1272, 56, -216},
    { 872, 120, -184},
    { 680, 104, -104},
    { 752, 136, -40},
    { 976, 144, -24},
    { 1000, 192, -80},
    { 920, 216, -128},
    { 1192, 192, -128},
    { 1352, 288, -112},
    { 1080, 336, -48},
    { 1200, 368, -120},
    { 1064, 400, -200},
    { 1136, 272, -56},
    { 1240, 248, 40},
    { 1360, 192, 8},
    { 1104, 88, -8},
    { 976, -32, 0},
    { 1000, -48, -56},
    { 1088, 8, -120},
    { 1008, 40, -112},
    { 1040, -40, -24},
    { 1344, -80, -48},
    { 944, -40, -136},
    { 1160, -104, -48},
    // 25 seconds
    { 1112, -112, 0},
    { 1104, 72, -184},
    { 1096, 96, -240},
    { 1176, 48, -296},
    { 976, 40, -168},
    { 736, 32, -80},
    { 832, 112, -88},
    { 880, 184, -80},
    { 968, 216, -112},
    { 1040, 224, -144},
    { 1264, 208, -72},
    { 1504, 320, -88},
    { 1120, 400, 0},
    { 1424, 512, -56},
    { 1000, 416, -176},
    { 1152, 160, -32},
    { 1288, 216, 72},
    { 1400, 216, 8},
    { 1112, 120, 16},
    { 1048, -32, 64},
    { 1040, -64, -40},
    { 1032, -72, -256},
    { 968, -80, -184},
    { 800, -144, -16},
    { 1024, -128, -8},
    // 26 seconds
    { 1104, 48, -208},
    { 1096, 120, -288},
    { 1088, -32, -152},
    { 1184, -48, -16},
    { 1312, 40, -96},
    { 1360, 96, -72},
    { 1120, 200, -200},
    { 840, 208, -96},
    { 776, 208, 40},
    { 872, 208, 16},
    { 1016, 160, -8},
    { 1176, 200, -8},
    { 1376, 272, 72},
    { 1528, 440, 152},
    { 1048, 584, 64},
    { 1136, 272, 32},
    { 1080, 376, -24},
    { 1072, 384, -8},
    { 1192, 328, 104},
    { 1376, 256, 104},
    { 1064, 160, 120},
    { 1048, -24, 128},
    { 1072, -104, 56},
    { 1112, -56, 0},
    { 1064, 8, 8},
    // 27 seconds
    { 1000, 16, 8},
    { 1224, -48, 40},
    { 1008, 0, -16},
    { 1088, -8, -88},
    { 1152, -16, -120},
    { 1064, -24, -168},
    { 1032, 8, -200},
    { 1056, -24, -256},
    { 1008, 40, -296},
    { 784, 72, -240},
    { 712, 72, -144},
    { 888, 136, -216},
    { 1064, 176, -184},
    { 1144, 232, -192},
    { 1192, 208, -128},
    { 1504, 280, -120},
    { 1176, 312, -64},
    { 1192, 240, -72},
    { 1088, 352, -224},
    { 1080, 344, -96},
    { 1224, 216, 72},
    { 1400, 128, 96},
    { 1120, 88, 24},
    { 952, 24, 48},
    { 960, -8, 24},
    // 28 seconds
    { 992, 16, -16},
    { 1040, 24, -24},
    { 968, 16, -16},
    { 1200, -72, 0},
    { 1144, -72, -24},
    { 1096, -80, -64},
    { 1208, -136, -24},
    { 1176, -8, -120},
    { 1184, 96, -232},
    { 1152, 24, -216},
    { 1112, 16, -224},
    { 824, 48, -160},
    { 720, 72, -152},
    { 800, 104, -136},
    { 896, 144, -64},
    { 960, 176, -112},
    { 1016, 184, -200},
    { 1488, 176, -136},
    { 1368, 272, -104},
    { 1248, 344, -72},
    { 1104, 424, -208},
    { 888, 320, -192},
    { 1072, 248, -40},
    { 1328, 216, 56},
    { 1344, 136, 32},
    // 29 seconds
    { 1088, 56, 24},
    { 1024, -24, 80},
    { 1088, -16, 24},
    { 1104, 16, -8},
    { 976, 32, -8},
    { 936, -16, 0},
    { 1168, -64, 0},
    { 952, -16, -64},
    { 1144, -40, -144},
    { 1160, -56, -96},
    { 1104, 0, -136},
    { 1128, 32, -184},
    { 1136, 24, -192},
    { 1064, 88, -248},
    { 792, 88, -200},
    { 736, 56, -136},
    { 864, 96, -152},
    { 968, 120, -80},
    { 1040, 168, -176},
    { 1072, 176, -184},
    { 1536, 232, -176},
    { 1216, 280, -128},
    { 1128, 256, -80},
    { 1072, 328, -192},
    { 968, 432, -144},
    // 30 seconds
    { 1136, 272, -16},
    { 1296, 184, 96},
    { 1344, 88, 72},
    { 1104, 32, 40},
    { 1064, -32, 56},
    { 1096, -16, -24},
    { 1096, 16, -48},
    { 992, 8, -32},
    { 928, -40, -32},
    { 1144, -64, -56},
    { 896, -32, -176},
    { 976, -40, -184},
    { 1040, -64, -96},
    { 1112, 8, -80},
    { 1200, 72, -176},
    { 1240, 80, -224},
    { 1144, 120, -240},
    { 832, 80, -120},
    { 808, 72, -56},
    { 944, 136, -56},
    { 1032, 184, -80},
    { 1016, 216, -136},
    { 1064, 192, -120},
    { 1368, 264, -120},
    { 1120, 328, -56},
    // 31 seconds
    { 1216, 312, -80},
    { 1192, 376, -232},
    { 1128, 272, -64},
    { 1224, 200, 32},
    { 1392, 152, 24},
    { 1120, 112, -16},
    { 984, 8, 80},
    { 1016, -40, 40},
    { 1064, -8, -16},
    { 1032, 24, -40},
    { 944, -8, 8},
    { 1096, -72, 0},
    { 1096, -72, 0},
    { 896, -80, -48},
    { 1072, -136, -16},
    { 1208, 8, -80},
    { 1296, 120, -184},
    { 1328, 72, -248},
    { 1192, 16, -192},
    { 800, 32, -128},
    { 704, 32, -168},
    { 856, 72, -96},
    { 960, 128, -32},
    { 976, 200, -96},
    { 976, 224, -176},
    // 32 seconds
    { 1288, 200, -96},
    { 1328, 304, -120},
    { 968, 376, -48},
    { 1104, 400, -120},
    { 1128, 328, -168},
    { 1200, 272, -40},
    { 1304, 240, 56},
    { 1432, 184, 24},
    { 1184, 96, 0},
    { 1112, -24, 48},
    { 1216, -88, -16},
    { 1200, -32, -136},
    { 1024, 0, -112},
    { 840, -48, -104},
    { 920, -152, -64},
    { 864, -120, -136},
    { 832, -144, -72},
    { 1152, -144, 88},
    { 1352, 64, -32},
    { 1512, 168, -128},
    { 1496, 96, -224},
    { 1056, 96, -120},
    { 688, 16, -96},
    { 776, 40, -40},
    { 984, 104, 8},
    // 33 seconds
    { 1136, 208, -32},
    { 1040, 304, -104},
    { 1160, 232, -40},
    { 1384, 376, 24},
    { 1096, 608, 144},
    { 1288, 288, -128},
    { 1032, 232, -120},
    { 1136, 288, 8},
    { 1288, 264, 56},
    { 1416, 192, 32},
    { 1072, 80, 24},
    { 1040, -40, 64},
    { 1072, -80, 0},
    { 1072, -40, -40},
    { 960, 0, -40},
    { 928, -48, -8},
    { 1176, -80, -24},
    { 968, -40, -64},
    { 1056, -64, -96},
    { 1200, -104, -48},
    { 1160, 8, -88},
    { 1184, 40, -128},
    { 1216, 40, -184},
    { 1128, 104, -200},
    { 800, 112, -112},
    // 34 seconds
    { 752, 104, -96},
    { 880, 144, -40},
    { 992, 192, -88},
    { 992, 248, -168},
    { 1184, 240, -96},
    { 1472, 376, -72},
    { 1104, 480, 64},
    { 1408, 360, -152},
    { 1000, 264, -168},
    { 1200, 248, -64},
    { 1304, 256, 32},
    { 1408, 208, 40},
    { 1088, 80, 24},
    { 976, -48, 88},
    { 1032, -64, 16},
    { 1112, -24, -48},
    { 1096, 24, -16},
    { 1136, -56, 8},
    { 1296, -88, -72},
    { 976, -128, -104},
    { 1048, -200, -64},
    { 1048, -120, -128},
    { 1112, 24, -208},
    { 1136, 16, -224},
    { 1200, 0, -320},
    // 35 seconds
    { 1008, 48, -280},
    { 824, 48, -168},
    { 904, 88, -136},
    { 1080, 184, -112},
    { 1144, 256, -112},
    { 1144, 280, -160},
    { 1392, 296, -112},
    { 1360, 496, -96},
    { 936, 408, 16},
    { 1120, 392, -24},
    { 952, 432, -152},
    { 1128, 304, -16},
    { 1384, 272, 104},
    { 1632, 224, 88},
    { 1384, 104, 88},
    { 1280, -40, 128},
    { 1296, -80, 48},
    { 1264, -32, -56},
    { 1104, 32, -80},
    { 944, -8, -72},
    { 1072, -80, -88},
    { 840, -224, -112},
    { 800, -368, -88},
    { 1200, -176, -16},
    { 1344, 72, -96},
    // 36 seconds
    { 1432, 96, -136},
    { 1408, 8, -168},
    { 1192, 48, -96},
    { 968, 72, -88},
    { 1008, 112, -16},
    { 1120, 176, 56},
    { 1200, 208, 24},
    { 1128, 280, -96},
    { 1272, 272, -16},
    { 1312, 424, 80},
    { 944, 648, 88},
    { 1296, 416, -56},
    { 1048, 376, -72},
    { 1168, 272, -16},
    { 1504, 320, 88},
    { 1616, 232, 64},
    { 1336, 96, 88},
    { 1344, -56, 128},
    { 1320, -88, 64},
    { 1216, -24, -16},
    { 1016, 16, -56},
    { 960, -56, 0},
    { 1128, -112, 24},
    { 736, -120, 0},
    { 1016, -136, -16},
    // 37 seconds
    { 1104, -48, -32},
    { 1232, 80, -200},
    { 1400, 24, -128},
    { 1424, -32, -72},
    { 1152, 72, -80},
    { 952, 152, -160},
    { 984, 160, -128},
    { 1072, 160, -16},
    { 1128, 160, -40},
    { 1072, 192, -112},
    { 1472, 248, -96},
    { 1440, 496, -32},
    { 1024, 672, 32},
    { 1184, 304, -144},
    { 888, 216, -128},
    { 1144, 256, -16},
    { 1368, 272, 56},
    { 1440, 216, 32},
    { 1160, 104, 56},
    { 1128, -8, 104},
    { 1176, -48, 48},
    { 1176, -32, -8},
    { 1032, -8, -16},
    { 984, -48, 16},
    { 1192, -72, 0},
    // 38 seconds
    { 912, -80, -64},
    { 1088, -96, -88},
    { 1112, -96, -56},
    { 1184, 16, -200},
    { 1264, 48, -232},
    { 1256, 0, -208},
    { 1056, 32, -216},
    { 848, 64, -184},
    { 848, 112, -152},
    { 944, 144, -48},
    { 1024, 176, -40},
    { 1032, 216, -152},
    { 1256, 200, -144},
    { 1448, 288, -160},
    { 1176, 392, -64},
    { 1104, 520, -72},
    { 992, 376, -232},
    { 1024, 192, -72},
    { 1200, 224, 48},
    { 1464, 168, 72},
    { 1336, 72, -8},
    { 1064, 16, 16},
    { 1072, -16, 16},
    { 1144, 0, -56},
    { 1168, 24, 0},
    // 39 seconds
    { 1024, -8, -24},
    { 1040, -72, -72},
    { 1112, -160, -88},
    { 896, -208, -168},
    { 944, -192, -216},
    { 1120, -96, -72},
    { 1264, 0, -120},
    { 1440, 32, -160},
    { 1496, 48, -184},
    { 1232, 136, -96},
    { 936, 112, -104},
    { 936, 112, -24},
    { 984, 176, -80},
    { 1032, 192, -200},
    { 1144, 216, -272},
    { 1360, 240, -104},
    { 1240, 432, -96},
    { 936, 528, -32},
    { 1112, 352, -216},
    { 1104, 296, -96},
    { 1304, 288, 8},
    { 1480, 224, 104},
    { 1536, 152, 64},
    { 1272, 48, 96},
    { 1224, -32, 128},
    // 40 seconds
    { 1240, -40, 48},
    { 1216, -16, 0},
    { 1096, 16, 8},
    { 1120, -64, 0},
    { 1184, -144, -32},
    { 896, -264, 8},
    { 968, -216, -104},
    { 1136, -112, -96},
    { 1288, 0, -216},
    { 1384, -32, -136},
    { 1432, -48, -144},
    { 1216, 64, -192},
    { 944, 128, -192},
    { 992, 152, -120},
    { 1096, 216, -40},
    { 1112, 248, -80},
    { 1080, 224, -120},
    { 1416, 288, -88},
    { 1248, 432, 8},
    { 1008, 472, 16},
    { 1144, 456, -64},
    { 1008, 384, -80},
    { 1264, 248, 16},
    { 1480, 224, 120},
    { 1520, 160, 80},
    // 41 seconds
    { 1264, 72, 80},
    { 1192, -16, 80},
    { 1248, -48, -8},
    { 1248, -16, -104},
    { 1064, 32, -160},
    { 1040, -120, -96},
    { 1048, -232, -112},
    { 720, -224, -168},
    { 984, -192, -136},
    { 1096, -88, -80},
    { 1256, 32, -160},
    { 1440, 24, -128},
    { 1456, 32, -128},
    { 1112, 120, -104},
    { 864, 136, -112},
    { 880, 152, -48},
    { 1080, 192, -56},
    { 1176, 224, -112},
    { 1160, 232, -104},
    { 1432, 360, -80},
    { 1168, 608, 64},
    { 1064, 392, -72},
    { 1160, 360, -72},
    { 1120, 368, -96},
    { 1232, 280, 8},
    // 42 seconds
    { 1448, 248, 64},
    { 1368, 208, 48},
    { 1184, 48, 128},
    { 1192, -96, 112},
    { 1200, -120, 0},
    { 1168, -8, -72},
    { 1000, 0, -32},
    { 1096, -72, -24},
    { 1104, -136, -104},
    { 792, -256, -80},
    { 1024, -232, -24},
    { 1176, -80, -56},
    { 1304, -8, -104},
    { 1408, -8, -144},
    { 1368, 32, -192},
    { 976, 88, -128},
    { 840, 80, -128},
    { 976, 136, -80},
    { 1096, 208, -88},
    { 1128, 256, -144},
    { 1088, 224, -120},
    { 1448, 312, -112},
    { 1160, 432, -48},
    { 1144, 352, -24},
    { 1240, 392, -96},
    // 43 seconds
    { 1096, 296, -88},
    { 1128, 256, 0},
    { 1408, 240, 40},
    { 1320, 168, 48},
    { 1128, 40, 120},
    { 1152, -64, 104},
    { 1176, -72, 16},
    { 1112, -8, -24},
    { 944, 8, -24},
    { 1128, -72, -8},
    { 1112, -88, -64},
    { 880, -112, -104},
    { 1096, -192, -32},
    { 1216, -112, -72},
    { 1224, 8, -176},
    { 1232, -16, -160},
    { 1208, 40, -224},
    { 952, 112, -208},
    { 792, 72, -120},
    { 896, 104, -104},
    { 1040, 152, -48},
    { 1040, 192, -120},
    { 1120, 200, -160},
    { 1528, 256, -120},
    { 1296, 464, -72},
    // 44 seconds
    { 1104, 480, -40},
    { 1168, 328, -152},
    { 952, 272, -112},
    { 1168, 264, -32},
    { 1352, 256, 32},
    { 1488, 192, 16},
    { 1272, 88, 56},
    { 1216, -40, 112},
    { 1240, -88, 0},
    { 1192, -56, -56},
    { 968, 8, -80},
    { 832, -32, -80},
    { 976, -96, -56},
    { 712, -64, -112},
    { 792, -48, -120},
    { 1120, -56, -56},
    { 1304, 72, -128},
    { 1512, 136, -208},
    { 1368, 104, -56},
    { 920, 80, -120},
    { 664, 48, 0},
    { 768, 264, -248},
    { 936, 152, -40},
    { 944, 136, -88},
    { 896, 120, -136},
    // 45 seconds
    { 1304, 136, -88},
    { 1792, 416, -104},
    { 1328, 1520, -88},
    { 1344, 16, -168},
    { 936, 96, -168},
    { 1144, 336, -96},
    { 1296, 328, 64},
    { 1296, 240, 0},
    { 920, 104, -8},
    { 912, 32, 16},
    { 960, 8, 0},
    { 1032, 8, -24},
    { 984, 8, -32},
    { 1072, -48, -16},
    { 1184, -88, -32},
    { 968, -104, -40},
    { 1112, -80, -136},
    { 1160, -88, -80},
    { 1192, 48, -184},
    { 1168, 56, -280},
    { 1160, -8, -240},
    { 936, 8, -216},
    { 696, 8, -120},
    { 752, 104, -112},
    { 880, 152, -24},
    // 46 seconds
    { 1056, 200, -8},
    { 1088, 224, -96},
    { 1312, 208, -80},
    { 1472, 360, -80},
    { 1088, 592, 200},
    { 1272, 416, -200},
    { 1120, 248, -96},
    { 1112, 336, -104},
    { 1176, 336, 16},
    { 1312, 272, 0},
    { 1080, 120, 40},
    { 1056, -8, 88},
    { 1144, -72, 32},
    { 1224, -40, -40},
    { 1192, 24, -8},
    { 1144, 0, 16},
    { 1176, -40, 8},
    { 1000, -136, 16},
    { 944, -224, 0},
    { 984, -184, -56},
    { 1176, 24, -112},
    { 1248, 56, -184},
    { 1264, 0, -256},
    { 1104, 24, -312},
    { 816, 8, -208},
    // 47 seconds
    { 800, 24, -120},
    { 952, 144, -152},
    { 1056, 224, -128},
    { 952, 264, -152},
    { 1080, 224, -64},
    { 1392, 280, -72},
    { 1080, 296, -8},
    { 1176, 216, 16},
    { 1136, 408, -72},
    { 1024, 464, -104},
    { 1104, 288, 8},
    { 1376, 248, 80},
    { 1208, 176, 40},
    { 1056, 32, 96},
    { 1088, -96, 80},
    { 1112, -80, -16},
    { 1056, 16, -64},
    { 968, 48, -48},
    { 1048, -56, -40},
    { 1192, -56, -80},
    { 952, -128, 8},
    { 1232, -184, 144},
    { 1128, 40, -56},
    { 1176, 152, -240},
    { 1184, 72, -224},
    // 48 seconds
    { 1144, 64, -312},
    { 792, 8, -216},
    { 704, -24, -112},
    { 888, 80, -176},
    { 1008, 200, -128},
    { 1024, 248, -144},
    { 1080, 216, -136},
    { 1384, 264, -96},
    { 1080, 344, -8},
    { 1352, 344, -40},
    { 1144, 416, -200},
    { 1152, 264, -40},
    { 1192, 240, 48},
    { 1384, 192, 56},
    { 1144, 112, 16},
    { 1024, 0, 72},
    { 1088, -56, 40},
    { 1144, -32, -40},
    { 1048, 40, -80},
    { 928, 8, -72},
    { 1048, -72, -56},
    { 968, -88, -160},
    { 792, -152, -168},
    { 1104, -184, -16},
    { 1184, -40, -120},
    // 49 seconds
    { 1272, 56, -192},
    { 1352, 32, -208},
    { 1200, 80, -200},
    { 816, 80, -112},
    { 792, 96, -40},
    { 952, 152, 16},
    { 1096, 176, 0},
    { 1072, 232, -72},
    { 1064, 192, -72},
    { 1456, 264, -40},
    { 1160, 448, 56},
    { 1040, 496, -80},
    { 1232, 288, -96},
    { 976, 320, -96},
    { 1144, 312, 0},
    { 1336, 280, 40},
    { 1296, 208, 24},
    { 1096, 88, 72},
    { 1152, -48, 96},
    { 1224, -88, -8},
    { 1160, -24, -88},
    { 976, 16, -80},
    { 1064, -56, -24},
    { 1112, -40, -120},
    { 808, -104, -88},
    // 50 seconds
    { 1024, -144, -8},
    { 1096, -48, -24},
    { 1112, 88, -208},
    { 1216, 56, -208},
    { 1288, -8, -160},
    { 992, 48, -152},
    { 792, 80, -160},
    { 888, 168, -112},
    { 952, 216, -88},
    { 928, 224, -104},
    { 856, 168, -120},
    { 1232, 184, -48},
    { 1488, 296, -24},
    { 1184, 328, 40},
    { 1296, 424, 0},
    { 1008, 480, -176},
    { 1016, 216, -40},
    { 1208, 248, 72},
    { 1376, 240, 64},
    { 1112, 160, 32},
    { 1000, 24, 104},
    { 1064, -48, 32},
    { 1096, -40, -64},
    { 1040, 0, -40},
    { 944, -40, -8},
    // 51 seconds
    { 1152, -80, -8},
    { 968, -56, -56},
    { 1056, -24, -144},
    { 1112, -104, -16},
    { 1152, 16, -120},
    { 1112, 88, -216},
    { 1128, 56, -248},
    { 1040, 88, -224},
    { 760, 64, -64},
    { 784, 80, -80},
    { 920, 152, -72},
    { 1064, 208, -112},
    { 1000, 224, -152},
    { 1128, 184, -104},
    { 1424, 288, -88},
    { 1080, 384, -16},
    { 1192, 384, -72},
    { 1176, 448, -192},
    { 1200, 264, -56},
    { 1304, 232, 64},
    { 1496, 200, 48},
    { 1176, 144, 0},
    { 1040, 8, 104},
    { 1080, -56, 56},
    { 1136, -32, -40},
    // 52 seconds
    { 1040, 16, -48},
    { 872, -16, -16},
    { 984, -72, 0},
    { 888, -16, -88},
    { 824, -16, -136},
    { 1064, -56, -104},
    { 1128, -16, -88},
    { 1256, 56, -216},
    { 1416, 72, -256},
    { 1312, 80, -208},
    { 808, 96, -168},
    { 696, 64, -128},
    { 808, 128, -64},
    { 992, 160, -56},
    { 1000, 224, -96},
    { 984, 224, -96},
    { 1328, 224, -48},
    { 1272, 392, -24},
    { 1128, 456, 16},
    { 1392, 336, -184},
    { 1096, 280, -104},
    { 1168, 272, 0},
    { 1384, 256, 0},
    { 1200, 216, -16},
    { 1000, 72, 72},
    // 53 seconds
    { 1016, -56, 88},
    { 1104, -64, -8},
    { 1112, 0, -32},
    { 936, 16, 0},
    { 1040, -72, 40},
    { 1096, -32, -16},
    { 824, 16, -48},
    { 1064, 16, -120},
    { 1064, -40, -88},
    { 1056, 16, -128},
    { 1168, 40, -200},
    { 1264, 64, -264},
    { 992, 120, -232},
    { 696, 56, -128},
    { 816, 64, -120},
    { 992, 112, -96},
    { 1064, 192, -144},
    { 1008, 216, -168},
    { 1312, 216, -128},
    { 1400, 384, -112},
    { 920, 432, -88},
    { 1280, 272, -176},
    { 1144, 392, -192},
    { 1352, 560, -176},
    { 1552, 496, -16},
    // 54 seconds
    { 1840, 400, 128},
    { 1712, 184, 128},
    { 1584, 56, -48},
    { 1472, 184, -240},
    { 1424, 304, -360},
    { 1104, 232, -376},
    { 760, 112, -328},
    { 584, -56, -440},
    { 328, -56, -608},
    { 88, -112, -544},
    { -40, -216, -608},
    { -48, -104, -792},
    { 96, -200, -856},
    { 256, -184, -968},
    { 328, -272, -1024},
    { 144, -312, -904},
    { 24, -208, -912},
    { -80, -248, -912},
    { -128, -176, -928},
    { -176, -200, -952},
    { -192, -192, -904},
    { -288, -256, -912},
    { -96, -200, -1152},
    { -8, -72, -1344},
    { 0, 48, -1368},
    // 55 seconds
    { 32, 56, -1248},
    { -72, 64, -1024},
    { -104, 152, -904},
    { -56, 168, -920},
    { -56, 32, -872},
    { -96, -88, -832},
    { -168, -152, -768},
    { -216, -248, -688},
    { -104, -176, -544},
    { 88, -168, -464},
    { 336, -176, -296},
    { 960, -24, -72},
    { 1864, 352, 128},
    { 2424, 600, 368},
    { 2528, 656, 144},
    { 2016, 688, -608},
    { 1568, 224, -320},
    { 1368, 280, 176},
    { 1056, 184, 312},
    { 776, -24, 136},
    { 752, 0, 112},
    { 672, 232, 88},
    { 744, 400, -8},
    { 776, 360, -56},
    { 1160, 288, 112},
    // 56 seconds
    { 1208, 440, 72},
    { 1080, 464, 0},
    { 1248, 456, -72},
    { 1216, 424, -104},
    { 1344, 264, 16},
    { 1496, 240, 120},
    { 1608, 208, 56},
    { 1368, 88, 72},
    { 1320, -88, 112},
    { 1264, -136, 16},
    { 1096, -40, -32},
    { 928, 0, -16},
    { 768, -40, 8},
    { 920, -96, 0},
    { 808, -96, 24},
    { 928, -16, -48},
    { 1136, -56, 24},
    { 1320, 40, 16},
    { 1440, 144, -152},
    { 1552, 128, -88},
    { 1384, 168, -120},
    { 920, 152, -216},
    { 832, 104, -104},
    { 968, 120, 16},
    { 1032, 144, 24},
    // 57 seconds
    { 1040, 232, -16},
    { 904, 288, -32},
    { 1288, 264, 40},
    { 1216, 464, 128},
    { 1096, 656, 8},
    { 1176, 424, -104},
    { 1048, 296, -112},
    { 1160, 280, 16},
    { 1416, 328, 72},
    { 1496, 248, 24},
    { 1272, 104, 80},
    { 1272, -40, 144},
    { 1320, -56, 48},
    { 1224, 0, 0},
    { 1056, 24, -16},
    { 848, 0, 16},
    { 1056, -24, 0},
    { 816, 0, -80},
    { 840, -72, -32},
    { 1080, -240, 176},
    { 1128, 48, -80},
    { 1184, 160, -152},
    { 1296, 80, -200},
    { 1168, 120, -288},
    { 976, 112, -216},
    // 58 seconds
    { 1016, 144, -160},
    { 1112, 184, 0},
    { 1200, 200, -8},
    { 1120, 192, -64},
    { 936, 216, -72},
    { 1344, 248, 16},
    { 1112, 376, 64},
    { 944, 360, 192},
    { 1160, 432, 8},
    { 904, 400, -56},
    { 992, 240, 0},
    { 1256, 272, 136},
    { 1504, 256, 120},
    { 1256, 176, 64},
    { 1192, 16, 136},
    { 1192, -32, 48},
    { 1120, -16, -40},
    { 984, 8, -80},
    { 800, -8, -88},
    { 1000, -64, -48},
    { 1056, -56, -88},
    { 824, -240, -40},
    { 1072, -216, 80},
    { 1248, 88, -192},
    { 1272, 224, -344},
    // 59 seconds
    { 1384, 64, -160},
    { 1224, -40, 24},
    { 992, 0, -72},
    { 824, 232, -136},
    { 832, 184, 0},
    { 952, 200, 32},
    { 1088, 192, 48},
    { 992, 240, 8},
    { 1000, 160, 24},
    { 1272, 216, 64},
    { 1296, 416, 240},
    { 1504, 824, -160},
    { 976, 208, -160},
    { 880, 184, -16},
    { 1208, 360, -32},
    { 1480, 280, -32},
    { 1208, 48, 72},
    { 1072, -56, 104},
    { 992, -88, 24},
    { 984, -8, 0},
    { 952, 40, 32},
    { 936, 32, 64},
    { 1080, -24, 120},
    { 1064, 0, 112},
    { 1016, 32, -80},
    // 60 seconds
    // elapsed: 1 minutes
    { 1200, -112, -32},
    { 1224, -80, -32},
    { 1128, 80, -176},
    { 1064, 72, -248},
    { 1000, 112, -352},
    { 672, 88, -200},
    { 632, -8, -88},
    { 872, -8, -120},
    { 1160, 104, -200},
    { 1336, 472, -744},
    { 704, -192, 176},
    { 1344, -344, -32},
    { 1544, 392, -264},
    { 1232, 368, -344},
    { 1320, 80, -200},
    { 1472, 320, -264},
    { 1656, 408, -48},
    { 1728, 296, 112},
    { 1872, 168, 64},
    { 1784, 168, 80},
    { 1664, 224, 72},
    { 1400, 192, -16},
    { 1064, 184, -144},
    { 680, 152, -280},
    { 400, -96, -424},
    // 61 seconds
    { 200, -136, -664},
    { 232, 88, -800},
    { 120, 40, -784},
    { -8, -216, -816},
    { -16, -128, -928},
    { 176, -192, -1056},
    { 200, -288, -960},
    { 88, -144, -856},
    { -8, -144, -784},
    { -168, -200, -776},
    { -232, -288, -800},
    { -240, -280, -840},
    { -216, -280, -920},
    { -224, -272, -1000},
    { -344, -312, -1064},
    { -216, -176, -1144},
    { -280, -200, -1168},
    { -384, -152, -1176},
    { -168, 152, -1216},
    { -240, 104, -1096},
    { -296, 40, -944},
    { -200, -16, -888},
    { -120, -120, -760},
    { -160, -224, -616},
    { -272, -456, -392},
    // 62 seconds
    { -168, -544, -344},
    { 96, -512, -416},
    { 352, -472, -432},
    { 608, -648, -208},
    { 1336, -504, 104},
    { 2440, 480, 200},
    { 2448, 896, 248},
    { 1968, 96, -656},
    { 1600, -336, -152},
    { 1616, -120, 176},
    { 1656, 24, -56},
    { 1056, 488, 128},
    { 792, 176, 168},
    { 856, 168, -32},
    { 904, 200, 48},
    { 920, 336, 160},
    { 920, 368, 168},
    { 1128, 376, 24},
    { 1512, 752, 40},
    { 904, 768, -344},
    { 840, 88, -48},
    { 1304, 400, 16},
    { 1224, 512, -96},
    { 1496, 216, 24},
    { 1768, 152, 96},
    // 63 seconds
    { 1792, 72, 72},
    { 1512, -56, 88},
    { 1320, -104, 112},
    { 1112, -120, 24},
    { 904, -24, -16},
    { 688, 16, 0},
    { 560, 32, -8},
    { 808, 0, 72},
    { 904, 48, -40},
    { 968, 40, -176},
    { 1272, -72, 32},
    { 1376, 8, -24},
    { 1456, 144, -248},
    { 1336, 72, -152},
    { 1192, 48, -176},
    { 1080, 120, -264},
    { 1000, 224, -120},
    { 992, 208, 8},
    { 1032, 192, -24},
    { 1080, 184, -48},
    { 856, 184, -152},
    { 1256, 312, -88},
    { 1520, 688, -48},
    { 992, 1200, -200},
    { 976, 128, -104},
    // 64 seconds
    { 1160, 208, -128},
    { 1328, 336, -24},
    { 1408, 416, 112},
    { 1752, 512, 16},
    { 1736, 384, 96},
    { 1872, 304, 104},
    { 1952, 424, 32},
    { 1856, 392, -16},
    { 1488, 312, -160},
    { 1048, 16, -312},
    { 736, -112, -296},
    { 568, -96, -448},
    { 288, -184, -448},
    { 184, -352, -528},
    { -40, -296, -704},
    { -88, -240, -872},
    { -56, -264, -864},
    { 48, -288, -840},
    { 40, -312, -808},
    { -8, -256, -816},
    { -80, -232, -832},
    { -120, -240, -888},
    { -128, -232, -928},
    { -88, -208, -1008},
    { -176, -256, -1032},
    // 65 seconds
    { -176, -224, -1096},
    { -112, -208, -1184},
    { -160, -144, -1192},
    { -216, 112, -1136},
    { -112, 200, -1088},
    { -168, 48, -1000},
    { -176, 128, -968},
    { -56, 136, -984},
    { -48, 96, -904},
    { -56, 64, -880},
    { -64, 64, -904},
    { -80, 72, -960},
    { -104, 16, -928},
    { -160, -152, -776},
    { -160, -344, -576},
    { 248, -288, -304},
    { 984, 304, -80},
    { 1584, 1048, -240},
    { 1848, 1144, -576},
    { 1624, 136, -544},
    { 1248, -216, -456},
    { 1040, -136, -208},
    { 1088, 8, -208},
    { 1080, 200, -80},
    { 976, 472, 280},
    // 66 seconds
    { 912, 408, 368},
    { 1096, 432, 128},
    { 1128, 448, -144},
    { 1272, 264, -112},
    { 1624, 392, 128},
    { 1120, 864, 8},
    { 1048, 384, 0},
    { 1048, 280, -8},
    { 1064, 360, -8},
    { 1160, 344, 0},
    { 1304, 288, 24},
    { 1232, 240, -40},
    { 1120, 152, 8},
    { 1176, 24, 64},
    { 1168, -24, 32},
    { 1080, -32, -24},
    { 920, -8, -24},
    { 1032, -48, 40},
    { 1296, 8, 8},
    { 1000, 64, 0},
    { 1200, -112, 88},
    { 1232, -304, 40},
    { 1320, 48, -64},
    { 1176, -32, -24},
    { 1120, 16, -192},
    // 67 seconds
    { 832, 112, -160},
    { 792, 104, -120},
    { 912, 104, 40},
    { 1128, 192, 152},
    { 1216, 288, 48},
    { 1096, 336, -128},
    { 1376, 320, -56},
    { 1224, 504, 136},
    { 912, 472, -16},
    { 1104, 304, -24},
    { 1096, 440, -104},
    { 1096, 360, -32},
    { 1280, 328, 64},
    { 1440, 272, 40},
    { 1232, 176, 80},
    { 1248, 0, 184},
    { 1288, -80, 72},
    { 1192, -48, -8},
    { 1032, 24, -8},
    { 952, -16, 64},
    { 1176, -24, 72},
    { 840, -48, 88},
    { 1032, -96, 80},
    { 1096, -104, 72},
    { 1344, 120, -192},
    // 68 seconds
    { 1360, 144, -160},
    { 1320, 24, -160},
    { 992, 16, -224},
    { 936, -120, -320},
    { 832, 480, -336},
    { 880, 272, -56},
    { 984, 240, -56},
    { 1000, 192, -72},
    { 1272, 168, -64},
    { 1336, 304, -80},
    { 920, 368, 96},
    { 1128, 408, -96},
    { 1264, 456, -104},
    { 1128, 384, -64},
    { 1096, 304, 16},
    { 1264, 280, 24},
    { 1096, 224, 32},
    { 992, 112, 96},
    { 1032, 0, 16},
    { 1016, -48, -16},
    { 952, 0, -64},
    { 848, 8, -64},
    { 1192, 0, 0},
    { 1120, 24, -16},
    { 952, 8, -88},
    // 69 seconds
    { 1024, -96, -48},
    { 1168, -8, -96},
    { 1128, 112, -280},
    { 1112, 24, -208},
    { 1040, 0, -184},
    { 720, 24, -144},
    { 656, 80, -120},
    { 832, 128, -32},
    { 1040, 160, 40},
    { 1080, 232, -8},
    { 1144, 264, -72},
    { 1600, 368, -88},
    { 1344, 728, 144},
    { 952, 472, -240},
    { 1152, 88, -88},
    { 1032, 336, -152},
    { 1056, 352, -72},
    { 1240, 312, -16},
    { 1328, 256, -16},
    { 1104, 160, 8},
    { 1040, 8, 88},
    { 1120, -72, 72},
    { 1136, -24, 16},
    { 1040, 32, -16},
    { 1064, 8, 8},
    // 70 seconds
    { 1336, 16, 16},
    { 896, 24, -56},
    { 912, -96, -88},
    { 1088, -160, 16},
    { 1104, 40, -192},
    { 1128, 56, -224},
    { 1064, -48, -160},
    { 960, 0, -232},
    { 872, 64, -288},
    { 832, 112, -136},
    { 968, 144, -48},
    { 1072, 216, -48},
    { 1016, 248, -112},
    { 1080, 208, -96},
    { 1448, 264, -24},
    { 1184, 352, 32},
    { 1232, 384, 72},
    { 1096, 456, -152},
    { 1016, 320, -104},
    { 1064, 304, 8},
    { 1264, 312, 56},
    { 1176, 224, 24},
    { 1024, 96, 88},
    { 1064, -24, 104},
    { 1128, -48, 24},
    // 71 seconds
    { 1128, 0, 8},
    { 1040, 24, 0},
    { 1136, -40, 80},
    { 1168, -24, 72},
    { 1120, 0, 64},
    { 1096, -56, 128},
    { 1264, 24, -200},
    { 1080, 120, -256},
    { 1040, -24, -152},
    { 1008, -56, -232},
    { 840, -16, -304},
    { 744, 40, -288},
    { 784, 80, -240},
    { 880, 160, -144},
    { 1024, 208, -120},
    { 944, 232, -160},
    { 1192, 200, -112},
    { 1376, 248, -88},
    { 1096, 280, 16},
    { 1312, 408, -56},
    { 1136, 624, -200},
    { 1144, 216, -40},
    { 1192, 184, 104},
    { 1368, 184, 48},
    { 1160, 152, -32},
    // 72 seconds
    { 1000, 32, 56},
    { 1000, -16, 56},
    { 1000, 16, -16},
    { 928, 56, -64},
    { 760, 40, -64},
    { 848, -40, -16},
    { 1040, -48, -16},
    { 904, -24, -80},
    { 1128, -56, -32},
    { 1272, -40, -8},
    { 1352, 120, -224},
    { 1392, 88, -248},
    { 1312, 0, -120},
    { 936, 56, -88},
    { 784, 192, -128},
    { 832, 224, 16},
    { 952, 232, 24},
    { 1024, 248, -32},
    { 936, 272, -88},
    { 960, 232, -56},
    { 1344, 376, -40},
    { 960, 592, 120},
    { 1192, 328, -128},
    { 1192, 200, -120},
    { 1312, 304, -48},
    // 73 seconds
    { 1408, 296, 16},
    { 1512, 240, 72},
    { 1328, 128, 48},
    { 1144, 24, 72},
    { 1136, -56, 48},
    { 1088, -32, -24},
    { 944, 16, -48},
    { 736, 16, -40},
    { 848, -56, -8},
    { 888, -40, -48},
    { 800, 8, -128},
    { 1072, -16, -96},
    { 1224, -32, 0},
    { 1320, 88, -136},
    { 1400, 120, -176},
    { 1448, 136, -152},
    { 1104, 192, -168},
    { 864, 104, -136},
    { 912, 152, -112},
    { 992, 184, -96},
    { 968, 192, -88},
    { 888, 224, -120},
    { 1048, 264, -88},
    { 1376, 352, 0},
    { 1640, 528, 120},
    // 74 seconds
    { 1104, 448, -232},
    { 816, 168, -128},
    { 1024, 256, -16},
    { 1448, 296, 24},
    { 1440, 128, 72},
    { 1088, -8, 56},
    { 944, -64, 64},
    { 856, -8, 0},
    { 816, 40, 16},
    { 824, 72, 24},
    { 1112, 32, 56},
    { 1216, 24, 120},
    { 1128, -48, 0},
    { 1256, -336, 208},
    { 1320, -40, -96},
    { 1208, 112, -304},
    { 1120, -8, -320},
    { 976, -88, -400},
    { 776, -128, -376},
    { 760, -120, -400},
    { 800, 0, -376},
    { 880, 128, -304},
    { 1064, 200, -288},
    { 1104, 208, -184},
    { 1264, 184, -128},
    // 75 seconds
    { 1184, 256, -176},
    { 1128, 280, -144},
    { 1272, 416, -224},
    { 1024, 432, -216},
    { 1016, 216, -40},
    { 1224, 136, 96},
    { 1272, 64, 0},
    { 1056, 32, -64},
    { 1040, -24, -48},
    { 1112, 8, -120},
    { 1112, 80, -176},
    { 1008, 40, -152},
    { 800, -16, -176},
    { 832, -152, -136},
    { 984, -240, -184},
    { 752, -328, -88},
    { 1136, -200, 24},
    { 1440, 64, -112},
    { 1704, 184, -184},
    { 1744, 112, -192},
    { 1360, 144, -208},
    { 864, 136, -192},
    { 688, 208, -40},
    { 736, 248, -48},
    { 928, 240, -48},
    // 76 seconds
    { 992, 256, -56},
    { 1136, 240, 40},
    { 1392, 320, 136},
    { 944, 448, 200},
    { 1408, 544, 40},
    { 1136, 536, -72},
    { 1224, 296, 16},
    { 1392, 328, 152},
    { 1576, 320, 128},
    { 1232, 152, 112},
    { 1136, 8, 152},
    { 1152, -56, 56},
    { 1112, -32, -40},
    { 984, 24, -56},
    { 952, -24, -16},
    { 1160, -64, 56},
    { 944, -24, 40},
    { 1136, -24, -64},
    { 1216, -24, -16},
    { 1424, 64, -104},
    { 1544, 64, -192},
    { 1528, -8, -128},
    { 1096, 80, -200},
    { 744, 80, -144},
    { 808, 128, -152},
    // 77 seconds
    { 992, 176, -80},
    { 1144, 216, -104},
    { 1152, 288, -240},
    { 1320, 280, -232},
    { 1504, 288, -136},
    { 1136, 216, -72},
    { 1080, 232, -80},
    { 712, 400, -104},
    { 904, 464, -24},
    { 1160, 336, 40},
    { 1432, 200, 136},
    { 1344, 160, 128},
    { 1192, 88, 96},
    { 1168, 56, 72},
    { 1152, 40, -8},
    { 1104, 96, -160},
    { 1056, 128, -184},
    { 1216, 72, -112},
    { 1272, 40, -128},
    { 1072, 8, -248},
    { 1192, -80, -168},
    { 1192, -72, -64},
    { 1280, 32, -136},
    { 1240, -8, -48},
    { 1088, 24, -32},
    // 78 seconds
    { 808, 104, -104},
    { 632, 120, -120},
    { 704, 128, -88},
    { 872, 128, -8},
    { 1160, 136, 24},
    { 1232, 200, -88},
    { 1608, 248, -192},
    { 1728, 288, -72},
    { 1376, 440, 48},
    { 1168, 568, -216},
    { 808, 488, -192},
    { 888, 376, -96},
    { 1056, 352, 48},
    { 1304, 296, 56},
    { 1112, 192, 56},
    { 976, 72, 72},
    { 1056, 40, 40},
    { 1080, 80, 8},
    { 1144, 104, -24},
    { 1136, 120, -56},
    { 1400, 40, -32},
    { 1272, 0, -48},
    { 1152, -104, -128},
    { 1168, -144, -112},
    { 1168, -16, -160},
    // 79 seconds
    { 1280, 8, -176},
    { 1176, -48, -88},
    { 984, -16, -104},
    { 704, 80, -208},
    { 616, 88, -176},
    { 664, 72, -88},
    { 840, 120, -64},
    { 1080, 168, -136},
    { 1192, 224, -232},
    { 1664, 256, -232},
    { 1416, 368, -184},
    { 1200, 352, -152},
    { 968, 264, -320},
    { 864, 344, -192},
    { 1088, 360, -48},
    { 1256, 304, 48},
    { 1256, 192, 48},
    { 1040, 104, 32},
    { 928, 72, 56},
    { 960, 136, -48},
    { 1072, 160, -120},
    { 1056, 136, -152},
    { 1128, 56, -120},
    { 1360, 8, -168},
    { 1024, -88, -224},
    // 80 seconds
    { 1160, -256, -208},
    { 1184, -280, -32},
    { 1352, -32, -128},
    { 1288, -16, -104},
    { 1128, -32, -56},
    { 880, 40, -80},
    { 752, 104, -104},
    { 832, 112, -24},
    { 1072, 120, 120},
    { 1248, 192, 48},
    { 1224, 272, -112},
    { 1528, 336, -40},
    { 1432, 1048, 16},
    { 968, 288, -32},
    { 1208, 320, -32},
    { 1224, 584, -88},
    { 1160, 360, -16},
    { 1320, 288, 72},
    { 1336, 224, 16},
    { 1160, 160, 32},
    { 1208, 48, 64},
    { 1328, 0, 32},
    { 1288, 56, -40},
    { 1120, 56, -88},
    { 1176, -56, -56},
    // 81 seconds
    { 1152, -160, -80},
    { 688, -320, -88},
    { 992, -368, 16},
    { 1312, -136, -24},
    { 1456, 96, -136},
    { 1504, 32, -136},
    { 1424, 24, -168},
    { 1056, 96, -96},
    { 904, 80, -56},
    { 1112, 136, 64},
    { 1232, 240, 40},
    { 1224, 312, -104},
    { 1200, 376, -64},
    { 1488, 760, 80},
    { 880, 592, -56},
    { 1096, 304, 8},
    { 1280, 552, -104},
    { 1448, 368, 8},
    { 1528, 312, 96},
    { 1784, 256, 72},
    { 1424, 208, 24},
    { 1248, 56, 128},
    { 1328, -24, 104},
    { 1368, -16, 16},
    { 1152, 48, 0},
    // 82 seconds
    { 1000, -16, 8},
    { 1168, -96, 24},
    { 736, -152, 64},
    { 784, -184, 56},
    { 1024, -192, 144},
    { 1280, 168, -280},
    { 1376, 128, -240},
    { 1736, -56, -112},
    { 1560, -16, -88},
    { 1240, 32, -72},
    { 1216, 184, -248},
    { 1176, 272, -184},
    { 1040, 280, -112},
    { 1000, 232, -144},
    { 1152, 280, -8},
    { 1456, 552, 88},
    { 864, 496, 72},
    { 1104, 408, 88},
    { 1344, 656, -24},
    { 1368, 344, -32},
    { 1560, 224, 160},
    { 1976, 200, 168},
    { 1640, 144, 72},
    { 1432, 0, 144},
    { 1288, -40, 104},
    // 83 seconds
    { 1160, 16, -8},
    { 1016, 48, -8},
    { 848, 8, 0},
    { 768, -96, 24},
    { 816, -176, 72},
    { 544, -224, 56},
    { 728, -96, -72},
    { 1288, -48, 56},
    { 1600, 96, -128},
    { 2032, 136, -200},
    { 2168, 24, -72},
    { 1584, 112, -112},
    { 1144, -8, -256},
    { 1056, 360, -232},
    { 1112, 112, 16},
    { 1144, 88, 56},
    { 1088, 184, 16},
    { 984, 344, 88},
    { 1328, 464, 312},
    { 904, 1000, 376},
    { 760, 248, 0},
    { 1224, 232, 112},
    { 1512, 568, 120},
    { 1480, 456, 144},
    { 1800, 288, 240},
    // 84 seconds
    { 1744, 184, 144},
    { 1608, 40, 168},
    { 1584, -48, 160},
    { 1472, -48, 112},
    { 1312, -16, 48},
    { 1232, -40, 40},
    { 1272, -40, 48},
    { 1040, 72, 8},
    { 744, 40, -32},
    { 848, -144, 128},
    { 1064, -64, 64},
    { 1192, 128, -128},
    { 1352, 160, -184},
    { 1336, 176, -264},
    { 1072, 136, -56},
    { 872, 56, -40},
    { 952, 120, -144},
    { 976, 168, -192},
    { 1040, 224, -240},
    { 1144, 256, -432},
    { 1096, 176, -320},
    { 1528, -72, -24},
    { 1576, -56, 96},
    { 1304, 168, -56},
    { 1096, 272, -64},
    // 85 seconds
    { 856, 288, 40},
    { 904, 184, 48},
    { 1232, 120, -8},
    { 1304, 112, -48},
    { 856, 48, -40},
    { 536, -16, 64},
    { 576, 40, -48},
    { 744, 144, -48},
    { 912, 184, 24},
    { 1080, 120, 16},
    { 1504, 48, 32},
    { 1304, 40, -120},
    { 1400, -40, -240},
    { 1128, -136, -96},
    { 984, -48, -184},
    { 912, 16, -248},
    { 960, 8, -296},
    { 1016, 48, -352},
    { 808, 40, -256},
    { 680, 32, -240},
    { 728, 56, -280},
    { 808, 112, -304},
    { 888, 128, -360},
    { 960, 136, -360},
    { 1024, 144, -304},
    // 86 seconds
    { 1328, 192, -232},
    { 1192, 208, -216},
    { 1048, 192, -40},
    { 960, 368, -72},
    { 752, 560, -184},
    { 920, 400, -80},
    { 1128, 192, 216},
    { 1384, 120, 144},
    { 1272, 64, 40},
    { 1248, 32, 32},
    { 1248, 48, -24},
    { 1200, 224, -272},
    { 1040, 264, -296},
    { 904, 208, -184},
    { 984, 72, -120},
    { 1168, 8, -152},
    { 1128, 32, -184},
    { 1208, -16, -72},
    { 1288, -72, 40},
    { 1392, 72, -80},
    { 1192, 72, -64},
    { 1032, 0, -8},
    { 952, 72, -64},
    { 864, 120, -128},
    { 920, 96, -24},
    // 87 seconds
    { 1008, 136, 88},
    { 1112, 192, 128},
    { 1208, 240, 24},
    { 1184, 288, -120},
    { 1352, 272, -144},
    { 1312, 288, 32},
    { 1136, 360, 128},
    { 1176, 528, -24},
    { 840, 496, -104},
    { 928, 296, 24},
    { 1072, 288, 104},
    { 1320, 280, 72},
    { 1296, 200, 80},
    { 1240, 104, 112},
    { 1264, 48, 96},
    { 1232, 8, 8},
    { 1096, 24, -88},
    { 936, 56, -176},
    { 896, -32, -112},
    { 1128, -104, -16},
    { 960, -88, -136},
    { 1184, -96, -136},
    { 1224, -96, 24},
    { 1344, 104, -176},
    { 1264, 104, -104},
    // 88 seconds
    { 1224, 40, -8},
    { 1040, 112, -72},
    { 864, 136, -88},
    { 888, 144, 0},
    { 960, 160, 48},
    { 1040, 184, -8},
    { 1000, 248, -144},
    { 1016, 248, -152},
    { 1288, 264, -8},
    { 1080, 464, 40},
    { 1208, 464, -96},
    { 1168, 272, -128},
    { 1104, 312, -40},
    { 1096, 328, 16},
    { 1328, 264, 56},
    { 1224, 184, 24},
    { 1088, 88, 80},
    { 1104, 24, 96},
    { 1144, 0, 40},
    { 1152, 8, 0},
    { 1040, 24, -32},
    { 1168, -48, 8},
    { 1232, -8, -40},
    { 976, -160, -48},
    { 1064, -272, 64},
    // 89 seconds
    { 1112, -128, -8},
    { 1224, 208, -256},
    { 1200, 128, -272},
    { 1264, 0, -248},
    { 1000, 8, -144},
    { 784, 8, -104},
    { 872, 120, -112},
    { 968, 192, -64},
    { 1040, 224, -120},
    { 968, 216, -160},
    { 1280, 216, -64},
    { 1368, 344, -32},
    { 880, 416, 72},
    { 1184, 464, -16},
    { 1208, 536, -128},
    { 1176, 280, -32},
    { 1296, 280, 120},
    { 1480, 296, 72},
    { 1192, 184, 72},
    { 1120, 16, 136},
    { 1208, -88, 32},
    { 1200, -32, -88},
    { 1032, 48, -128},
    { 896, -16, -96},
    { 1072, -72, -24},
    // 90 seconds
    { 920, -80, -136},
    { 824, -112, -136},
    { 1088, -176, 48},
    { 1288, 0, -128},
    { 1432, 112, -184},
    { 1464, 24, -120},
    { 1232, 64, -192},
    { 856, 104, -136},
    { 872, 136, -72},
    { 1000, 192, 32},
    { 1120, 216, 64},
    { 1056, 272, -56},
    { 1056, 256, -104},
    { 1384, 320, -24},
    { 1088, 496, 112},
    { 1104, 456, -64},
    { 1264, 448, -80},
    { 1176, 376, -96},
    { 1168, 296, 8},
    { 1496, 288, 64},
    { 1432, 232, 16},
    { 1216, 104, 96},
    { 1176, -40, 120},
    { 1168, -88, 0},
    { 1064, -8, -80},
    // 91 seconds
    { 920, 8, -56},
    { 1104, -80, 16},
    { 1112, -48, -48},
    { 904, -144, 16},
    { 1072, -200, 104},
    { 1256, 40, -40},
    { 1280, 192, -208},
    { 1352, 88, -184},
    { 1312, 40, -216},
    { 952, 40, -120},
    { 856, 56, -112},
    { 960, 168, -56},
    { 1032, 240, -8},
    { 1008, 280, -104},
    { 1072, 264, -96},
    { 1432, 312, -32},
    { 1072, 472, 56},
    { 1344, 576, -16},
    { 1200, 472, -160},
    { 1192, 224, -48},
    { 1232, 264, 56},
    { 1552, 264, 56},
    { 1360, 176, 24},
    { 1192, 24, 128},
    { 1176, -48, 80},
    // 92 seconds
    { 1120, -32, -48},
    { 1000, 32, -64},
    { 872, 16, -48},
    { 1024, -64, 32},
    { 1024, -48, -8},
    { 936, -88, -24},
    { 1160, -120, 128},
    { 1256, 88, -48},
    { 1360, 168, -256},
    { 1456, 24, -104},
    { 1312, 56, -88},
    { 888, 80, -104},
    { 856, 120, -136},
    { 1000, 192, -40},
    { 1104, 248, -32},
    { 1072, 296, -88},
    { 1216, 264, -80},
    { 1464, 352, -32},
    { 1064, 456, 80},
    { 1208, 448, -64},
    { 1080, 392, -152},
    { 1120, 256, -56},
    { 1216, 264, 32},
    { 1552, 232, 80},
    { 1376, 168, 32},
    // 93 seconds
    { 1112, 64, 96},
    { 1064, -8, 96},
    { 1048, -16, -8},
    { 1016, 8, -64},
    { 896, 32, -40},
    { 936, -48, 16},
    { 1136, -48, -8},
    { 824, 0, -88},
    { 1048, -24, -96},
    { 1056, -40, -24},
    { 1136, 80, -128},
    { 1336, 96, -224},
    { 1504, 80, -224},
    { 1192, 144, -112},
    { 840, 120, -128},
    { 840, 168, -72},
    { 936, 200, -24},
    { 1032, 192, -64},
    { 976, 224, -88},
    { 1288, 272, -32},
    { 1344, 384, 40},
    { 864, 456, 136},
    { 1232, 424, -128},
    { 1128, 384, -104},
    { 1120, 296, 0},
    // 94 seconds
    { 1192, 304, 96},
    { 1424, 280, 56},
    { 1152, 176, 64},
    { 1104, 16, 168},
    { 1256, -72, 96},
    { 1240, -56, -40},
    { 1104, 0, -48},
    { 896, -8, -32},
    { 1000, -32, -48},
    { 960, -96, -72},
    { 784, -136, -80},
    { 1056, -184, 16},
    { 1232, 32, -88},
    { 1360, 160, -256},
    { 1424, 88, -192},
    { 1296, 8, -112},
    { 880, 48, -128},
    { 832, 104, -96},
    { 928, 168, 8},
    { 1040, 208, 16},
    { 1064, 272, -40},
    { 952, 296, -96},
    { 1184, 264, -16},
    { 1120, 368, 32},
    { 1056, 456, 64},
    // 95 seconds
    { 1272, 400, -168},
    { 1104, 280, -56},
    { 1216, 288, 40},
    { 1456, 280, 48},
    { 1432, 240, -24},
    { 1200, 112, 72},
    { 1192, -48, 120},
    { 1216, -120, -16},
    { 1048, -16, -120},
    { 880, 16, -88},
    { 696, -16, -40},
    { 920, -40, -8},
    { 856, 0, -80},
    { 992, -64, 16},
    { 1192, -80, 128},
    { 1344, 128, -160},
    { 1504, 192, -128},
    { 1544, 88, -72},
    { 1112, 104, -128},
    { 816, 64, -144},
    { 920, 120, -56},
    { 1040, 160, 8},
    { 1080, 184, -16},
    { 944, 264, -96},
    { 848, 240, -48},
    // 96 seconds
    { 1200, 288, 24},
    { 1096, 528, 312},
    { 1464, 528, -160},
    { 1104, 200, -80},
    { 1112, 272, 0},
    { 1296, 368, 88},
    { 1592, 344, -16},
    { 1328, 160, 24},
    { 1144, -16, 216},
    { 1104, -72, 104},
    { 952, -152, -16},
    { 832, -8, -24},
    { 768, 48, -16},
    { 944, 0, 40},
    { 1080, 8, 104},
    { 864, -48, 192},
    { 1216, -96, 112},
    { 1216, 136, -112},
    { 1296, 224, -216},
    { 1400, 64, -288},
    { 1336, -64, -240},
    { 904, 8, -288},
    { 784, 160, -336},
    { 856, 176, -120},
    { 1096, 144, 8},
    // 97 seconds
    { 1088, 168, -32},
    { 856, 248, -80},
    { 1016, 200, -48},
    { 1056, 296, 48},
    { 1168, 512, 176},
    { 1328, 560, -248},
    { 1040, 112, 8},
    { 1184, 184, 88},
    { 1392, 360, 48},
    { 1320, 312, -80},
    { 1104, 88, 8},
    { 1056, -32, 104},
    { 1000, -80, 24},
    { 928, -80, -64},
    { 856, 8, -56},
    { 864, -24, -48},
    { 1248, -72, 8},
    { 832, -224, 136},
    { 1168, -184, 112},
    { 1416, 112, -48},
    { 1424, 232, -176},
    { 1312, 144, -192},
    { 1096, 40, -152},
    { 656, -16, -112},
    { 592, -8, -112},
    // 98 seconds
    { 760, 80, -56},
    { 960, 168, -16},
    { 928, 256, -120},
    { 904, 232, -192},
    { 1344, 224, -160},
    { 1144, 352, -144},
    { 1152, 392, -72},
    { 1664, 392, -200},
    { 1040, 200, -88},
    { 1096, 192, -40},
    { 1256, 216, -32},
    { 1136, 224, -48},
    { 928, 88, 32},
    { 952, -24, 64},
    { 1032, -32, 0},
    { 1064, 16, -32},
    { 920, 32, -8},
    { 896, -24, -16},
    { 1128, -56, -24},
    { 912, -56, -56},
    { 1152, -104, 40},
    { 1248, -8, 8},
    { 1328, 136, -256},
    { 1312, 72, -136},
    { 1216, 0, -56},
    // 99 seconds
    { 824, 56, -112},
    { 672, 96, -152},
    { 736, 136, -104},
    { 832, 152, -24},
    { 928, 168, -48},
    { 840, 216, -192},
    { 1192, 176, -160},
    { 1440, 272, -80},
    { 1272, 400, 48},
    { 1472, 440, -264},
    { 936, 216, -176},
    { 992, 192, -48},
    { 1152, 224, 8},
    { 1232, 232, -24},
    { 952, 128, -24},
    { 848, 8, 64},
    { 952, -8, 16},
    { 1024, 40, -16},
    { 984, 40, -8},
    { 1000, -24, 16},
    { 1232, -40, 8},
    { 1088, -48, -8},
    { 1024, -128, 24},
    { 1008, -160, 56},
    { 1200, 136, -176},
    // 100 seconds
    { 1256, 184, -256},
    { 1224, 32, -208},
    { 1088, -40, -176},
    { 792, -24, -160},
    { 712, 40, -152},
    { 768, 136, -112},
    { 848, 208, -48},
    { 904, 248, -112},
    { 880, 216, -168},
    { 1288, 168, -96},
    { 1304, 288, -88},
    { 1080, 352, -8},
    { 1304, 480, -64},
    { 1152, 488, -200},
    { 1136, 176, -40},
    { 1168, 200, 88},
    { 1272, 216, 24},
    { 1016, 184, 0},
    { 928, 56, 56},
    { 968, 0, 8},
    { 1104, 8, -48},
    { 1120, 40, -200},
    { 928, -24, -96},
    { 1088, -152, 64},
    { 1048, -64, -128},
    // 101 seconds
    { 888, 24, -152},
    { 1032, -40, -48},
    { 1136, -16, 40},
    { 1280, 104, -48},
    { 1288, 144, -112},
    { 1288, 112, -104},
    { 904, 144, -120},
    { 704, 88, -112},
    { 848, 112, -24},
    { 1024, 176, -40},
    { 1096, 216, -72},
    { 992, 240, -168},
    { 1328, 232, -88},
    { 1360, 440, -64},
    { 1088, 688, 32},
    { 1408, 464, -104},
    { 1008, 256, -120},
    { 1048, 264, -32},
    { 1328, 320, 48},
    { 1424, 288, 16},
    { 1176, 104, 104},
    { 1104, -32, 144},
    { 1144, -48, 64},
    { 1152, 0, 16},
    { 1064, 24, 16},
    // 102 seconds
    { 952, -24, 80},
    { 1104, -32, 72},
    { 984, 0, 0},
    { 1056, 0, -64},
    { 1016, -40, -8},
    { 1176, 16, -152},
    { 1256, 64, -232},
    { 1272, 16, -240},
    { 1080, 8, -200},
    { 784, 24, -192},
    { 736, 64, -208},
    { 888, 128, -224},
    { 976, 160, -168},
    { 1120, 208, -216},
    { 1112, 200, -224},
    { 1464, 200, -104},
    { 1264, 296, -80},
    { 1120, 312, 48},
    { 1112, 424, -88},
    { 936, 552, -136},
    { 1160, 304, -8},
    { 1336, 216, 168},
    { 1512, 128, 128},
    { 1224, 64, 40},
    { 1120, 8, 56},
    // 103 seconds
    { 1088, 24, 16},
    { 1016, 64, -24},
    { 880, 72, -40},
    { 800, 8, -32},
    { 1000, -64, 16},
    { 1072, -48, -16},
    { 1128, -32, -88},
    { 1224, 8, -104},
    { 1296, 48, -96},
    { 1400, 104, -192},
    { 1344, 48, -120},
    { 1200, 80, -104},
    { 856, 128, -184},
    { 688, 112, -144},
    { 672, 152, -80},
    { 792, 176, -64},
    { 1024, 232, -112},
    { 1080, 256, -160},
    { 1344, 208, -88},
    { 1304, 304, -128},
    { 1104, 352, -64},
    { 1136, 456, -120},
    { 1040, 480, -208},
    { 1176, 168, 16},
    { 1328, 152, 144},
    // 104 seconds
    { 1416, 128, 48},
    { 1160, 104, 0},
    { 1008, 40, 40},
    { 984, 40, 32},
    { 976, 56, -8},
    { 944, 56, -16},
    { 848, 16, -16},
    { 1024, -48, 16},
    { 1104, -48, 24},
    { 1056, 40, -112},
    { 1280, 56, -360},
    { 1288, -48, -104},
    { 1208, -16, -200},
    { 1088, -32, -200},
    { 1048, -24, -128},
    { 952, 96, -176},
    { 792, 120, -144},
    { 776, 152, -64},
    { 880, 176, -56},
    { 984, 200, -48},
    { 1016, 216, -72},
    { 968, 232, -152},
    { 1288, 240, -80},
    { 1296, 456, -16},
    { 976, 488, -16},
    // 105 seconds
    { 1328, 368, -56},
    { 1000, 360, -128},
    { 1240, 280, -24},
    { 1384, 256, 40},
    { 1488, 240, 16},
    { 1296, 168, 40},
    { 1208, 64, 120},
    { 1224, -16, 120},
    { 1184, -32, 24},
    { 1048, -16, -16},
    { 840, 8, -32},
    { 840, -56, -24},
    { 944, -48, 8},
    { 720, 8, -120},
    { 1032, -48, -96},
    { 1232, -104, 40},
    { 1312, 112, -168},
    { 1368, 112, -272},
    { 1392, 24, -152},
    { 1056, 104, -48},
    { 856, 88, -72},
    { 1008, 152, -24},
    { 1176, 200, 40},
    { 1192, 224, 0},
    { 1032, 288, -112},
    // 106 seconds
    { 1200, 304, -112},
    { 1168, 520, 0},
    { 1240, 696, -32},
    { 1272, 272, -136},
    { 968, 152, -56},
    { 1128, 264, -8},
    { 1584, 320, 0},
    { 1600, 224, -8},
    { 1352, 80, 88},
    { 1256, -32, 120},
    { 1176, -56, 48},
    { 1032, -24, 8},
    { 840, 0, 16},
    { 712, -16, 32},
    { 832, -16, 40},
    { 824, 320, -16},
    { 1064, 1264, -360},
    { 1040, 1232, -728},
    { 1104, 1000, -968},
    { 1088, 360, -520},
    { 952, 184, -528},
    { 784, 32, -504},
    { 496, -288, -552},
    { 272, -424, -744},
    { 72, -440, -704},
    // 107 seconds
    { -8, -296, -592},
    { -48, -280, -656},
    { -64, -408, -792},
    { -136, -432, -896},
    { -112, -328, -1056},
    { -88, -288, -1120},
    { -224, -184, -1128},
    { -256, -40, -1120},
    { -240, 88, -1056},
    { -264, 104, -992},
    { -264, 32, -952},
    { -264, 88, -960},
    { -144, 88, -984},
    { -128, -32, -944},
    { -160, -48, -904},
    { -152, -64, -904},
    { -160, -56, -920},
    { -160, -64, -968},
    { -208, -152, -992},
    { -192, -256, -1032},
    { -224, -248, -1040},
    { -208, -216, -1080},
    { -200, -272, -1096},
    { -152, -296, -1112},
    { -120, -224, -1096},
    // 108 seconds
    { -88, -48, -1112},
    { 48, -24, -1184},
    { 136, -96, -1152},
    { 112, -128, -1000},
    { 40, -32, -912},
    { -48, 8, -888},
    { -120, -24, -920},
    { -128, -56, -952},
    { -128, -40, -1000},
    { -96, 16, -1064},
    { -72, 8, -1112},
    { -64, -8, -1144},
    { -96, -32, -1104},
    { -80, -64, -1088},
    { -96, -56, -1032},
    { -104, 32, -1064},
    { -144, -136, -1056},
    { -56, -32, -1048},
    { -8, -80, -1016},
    { -72, -144, -936},
    { -176, -208, -952},
    { -288, -208, -936},
    { -360, -160, -976},
    { -392, -136, -992},
    { -408, -168, -984},
    // 109 seconds
    { -416, -176, -960},
    { -440, -192, -952},
    { -424, -144, -968},
    { -416, -144, -984},
    { -416, -168, -976},
    { -440, -184, -952},
    { -440, -136, -952},
    { -424, -152, -944},
    { -352, -104, -936},
    { -376, -112, -912},
    { -408, -208, -968},
    { -408, -168, -992},
    { -408, -192, -968},
    { -448, -192, -960},
    { -448, -184, -952},
    { -432, -192, -968},
    { -384, -200, -960},
    { -2056, 24, -688},
    { -568, -184, -912},
    { -568, -152, -920},
    { -504, -152, -928},
    { -472, -160, -936},
    { -488, -160, -920},
    { -496, -168, -928},
    { -472, -224, -936},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:13:17 local
AccelRawData *activity_sample_walk_200_pbl_25667_14(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25667_14
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -472, 360, 568},
    { -424, 584, 680},
    { -400, 624, 584},
    { -400, 512, 608},
    { -400, 688, 568},
    { -440, 808, 600},
    { -480, 928, 520},
    { -512, 968, 344},
    { -480, 912, 80},
    { -400, 752, -232},
    { -328, 680, -536},
    { -256, 536, -720},
    { -216, 408, -864},
    { -168, 344, -952},
    { -192, 216, -944},
    { -136, 112, -976},
    { -136, 96, -968},
    { -96, 24, -984},
    { -96, -16, -1008},
    { -112, -56, -976},
    { -40, -72, -1056},
    { 248, 96, -1056},
    { -192, -160, -976},
    { -256, 0, -1024},
    { -168, -8, -1072},
    // 1 seconds
    { -272, -80, -1032},
    { -272, -96, -1008},
    { -312, -40, -984},
    { -344, -64, -976},
    { -328, -64, -992},
    { 240, -344, -928},
    { -304, -48, -992},
    { -280, -32, -1000},
    { -232, -64, -1040},
    { -192, -48, -1024},
    { -224, -96, -1016},
    { -216, -128, -984},
    { -144, -56, -1000},
    { -192, 24, -976},
    { -200, 104, -992},
    { -256, 72, -1024},
    { -264, 88, -1048},
    { -264, 104, -1048},
    { -264, 96, -1024},
    { -288, 80, -992},
    { -304, 96, -984},
    { -304, 96, -960},
    { -336, 216, -936},
    { -360, 360, -928},
    { -376, 344, -928},
    // 2 seconds
    { -384, 320, -912},
    { -400, 376, -920},
    { -376, 384, -888},
    { -424, 352, -856},
    { -448, 376, -856},
    { -496, 368, -856},
    { -536, 376, -848},
    { -552, 392, -912},
    { -568, 448, -872},
    { -528, 416, -928},
    { -520, 448, -880},
    { -464, 504, -960},
    { -312, 496, -760},
    { -152, 488, -720},
    { -144, 392, -864},
    { -144, 504, -696},
    { -112, 592, -672},
    { -160, 696, -688},
    { -312, 552, -664},
    { -408, 528, -720},
    { -432, 560, -592},
    { -464, 568, -528},
    { -456, 544, -616},
    { -504, 520, -736},
    { -624, 504, -608},
    // 3 seconds
    { -656, 768, -592},
    { -656, 872, -480},
    { -720, 864, -448},
    { -600, 1040, -512},
    { -464, 1040, -392},
    { -400, 824, -208},
    { -400, 760, -120},
    { -376, 696, -176},
    { -304, 608, -352},
    { -288, 528, -456},
    { -288, 384, -576},
    { -360, 424, -616},
    { -368, 552, -744},
    { -376, 544, -912},
    { -288, 512, -848},
    { -152, 512, -816},
    { 208, 464, -800},
    { 448, 296, -672},
    { 720, 368, -384},
    { 984, 592, -312},
    { 1232, 432, -280},
    { 1352, 272, -128},
    { 1376, 296, 16},
    { 1224, 344, 64},
    { 1136, 328, 8},
    // 4 seconds
    { 1192, 360, -24},
    { 1240, 392, 96},
    { 1168, 408, 16},
    { 1224, 392, -88},
    { 1520, 416, -56},
    { 1176, 520, 72},
    { 1256, 568, -88},
    { 968, 624, -176},
    { 840, 456, -96},
    { 1080, 392, -16},
    { 1304, 384, 24},
    { 1352, 296, -8},
    { 1280, 192, 48},
    { 1328, 80, 32},
    { 1296, 48, -48},
    { 1168, 48, -168},
    { 1024, 16, -128},
    { 1152, -24, 8},
    { 1272, 40, -64},
    { 896, 80, -64},
    { 1016, 64, -48},
    { 864, 72, -56},
    { 944, 144, -128},
    { 1128, 112, -152},
    { 1216, 112, -168},
    // 5 seconds
    { 1000, 120, -144},
    { 816, 96, -136},
    { 920, 128, -168},
    { 1048, 184, -104},
    { 1088, 240, -120},
    { 1048, 264, -152},
    { 1352, 328, -136},
    { 1456, 472, -112},
    { 984, 480, -8},
    { 1144, 440, -232},
    { 1008, 488, -224},
    { 936, 448, -112},
    { 1088, 360, 32},
    { 1416, 256, 24},
    { 1312, 144, -16},
    { 1256, 56, 48},
    { 1272, 48, 32},
    { 1208, 80, -48},
    { 1104, 88, -56},
    { 944, 64, -104},
    { 816, 8, -56},
    { 896, 16, -88},
    { 760, 48, -184},
    { 832, 32, -112},
    { 1088, 24, -8},
    // 6 seconds
    { 1056, 80, -80},
    { 1392, 160, -200},
    { 1368, 104, -152},
    { 1040, 112, -128},
    { 856, 112, -200},
    { 928, 176, -128},
    { 1056, 200, -8},
    { 1120, 224, 16},
    { 1048, 296, 0},
    { 1304, 336, 8},
    { 1408, 504, 56},
    { 1088, 704, 120},
    { 1200, 488, -56},
    { 1016, 344, -48},
    { 1000, 376, -32},
    { 1032, 408, -8},
    { 1192, 360, -16},
    { 1072, 232, 8},
    { 1120, 80, 48},
    { 1176, 8, 8},
    { 1192, 8, -16},
    { 1176, 56, 0},
    { 1048, 80, 48},
    { 1232, 64, 24},
    { 1096, 48, 56},
    // 7 seconds
    { 1072, -8, 0},
    { 1152, -88, 88},
    { 1016, 88, -168},
    { 984, 120, -240},
    { 1000, -8, -96},
    { 952, 16, -96},
    { 760, 80, -120},
    { 800, 128, -232},
    { 1024, 280, -256},
    { 1032, 248, -56},
    { 1256, 296, -96},
    { 1368, 320, -208},
    { 1352, 368, -248},
    { 1216, 424, -216},
    { 1544, 512, -336},
    { 992, 304, -160},
    { 1136, 232, -104},
    { 1360, 184, -40},
    { 1448, 120, -48},
    { 1080, 48, -48},
    { 976, 24, -8},
    { 952, 40, -32},
    { 920, 88, -48},
    { 824, 80, -8},
    { 864, 16, -16},
    // 8 seconds
    { 1112, 8, 0},
    { 832, 32, -56},
    { 1080, 32, -40},
    { 1136, 64, 24},
    { 1192, 152, -32},
    { 1424, 232, -184},
    { 1416, 208, -248},
    { 952, 152, -120},
    { 688, 32, -136},
    { 792, 80, -160},
    { 936, 160, -120},
    { 968, 256, -120},
    { 952, 320, -232},
    { 1344, 376, -208},
    { 1392, 552, -184},
    { 1072, 536, -64},
    { 1280, 272, -184},
    { 1088, 264, -168},
    { 1144, 296, -104},
    { 1176, 288, 0},
    { 1360, 240, 32},
    { 1104, 144, 24},
    { 960, 40, 88},
    { 984, 24, 48},
    { 1008, 72, 8},
    // 9 seconds
    { 992, 72, 32},
    { 912, 40, 32},
    { 1144, 8, 24},
    { 1032, -8, -16},
    { 944, -8, -88},
    { 1096, -40, -24},
    { 1072, 72, -144},
    { 1200, 104, -216},
    { 1360, 72, -224},
    { 1240, 88, -192},
    { 840, 96, -144},
    { 784, 128, -224},
    { 920, 184, -136},
    { 976, 264, -80},
    { 1048, 320, -160},
    { 1328, 368, -136},
    { 1360, 512, -112},
    { 1000, 648, 0},
    { 1496, 440, -192},
    { 1088, 288, -88},
    { 1208, 304, -40},
    { 1296, 320, -16},
    { 1408, 272, 0},
    { 1144, 112, 48},
    { 1040, 0, 112},
    // 10 seconds
    { 1080, 16, 16},
    { 1080, 56, -16},
    { 1008, 80, -8},
    { 1136, 8, 40},
    { 1144, 8, 16},
    { 840, -48, 8},
    { 936, -56, -48},
    { 944, 8, -16},
    { 1048, 120, -168},
    { 1232, 72, -168},
    { 1408, 80, -304},
    { 1088, 120, -240},
    { 800, 64, -112},
    { 968, 120, -168},
    { 1064, 216, -144},
    { 1072, 304, -184},
    { 1152, 328, -96},
    { 1504, 504, -48},
    { 1088, 680, 80},
    { 920, 472, -120},
    { 1336, 512, -88},
    { 1152, 376, -48},
    { 1240, 320, 48},
    { 1552, 328, 56},
    { 1336, 280, 24},
    // 11 seconds
    { 1152, 96, 88},
    { 1120, -40, 112},
    { 1104, -16, -24},
    { 976, 56, -72},
    { 960, 32, 8},
    { 1224, 40, 0},
    { 872, -32, -56},
    { 800, -120, 32},
    { 1096, -96, 64},
    { 1232, 176, -192},
    { 1328, 192, -240},
    { 1448, 40, -176},
    { 1240, 0, -200},
    { 808, 0, -112},
    { 848, 80, -160},
    { 1000, 208, -120},
    { 1136, 312, -24},
    { 1136, 408, -8},
    { 1208, 472, 0},
    { 1368, 656, 24},
    { 872, 584, -24},
    { 1160, 432, 24},
    { 1160, 528, -72},
    { 1320, 352, 0},
    { 1424, 336, 96},
    // 12 seconds
    { 1672, 312, 72},
    { 1360, 232, 32},
    { 1240, 80, 128},
    { 1288, -16, 56},
    { 1200, 16, -80},
    { 1008, 56, -128},
    { 880, -32, -80},
    { 1008, -96, -40},
    { 768, -104, -104},
    { 728, -64, -112},
    { 1056, -56, 56},
    { 1176, 104, -8},
    { 1480, 192, -160},
    { 1696, 216, -224},
    { 1360, 232, -88},
    { 856, 152, -112},
    { 872, 80, -80},
    { 1040, 128, -64},
    { 1112, 192, -80},
    { 1024, 304, -160},
    { 1192, 360, -64},
    { 1320, 512, 32},
    { 1008, 720, 112},
    { 1400, 488, -200},
    { 1008, 312, -112},
    // 13 seconds
    { 1128, 328, 0},
    { 1256, 360, 64},
    { 1520, 296, 48},
    { 1264, 168, 40},
    { 1152, 16, 96},
    { 1120, -24, 48},
    { 1096, 24, -16},
    { 968, 48, -16},
    { 880, 40, 24},
    { 1120, 16, 56},
    { 944, 64, -40},
    { 952, 72, -120},
    { 1088, 24, -56},
    { 1184, 48, -160},
    { 1280, 96, -288},
    { 1320, 40, -216},
    { 1160, 64, -200},
    { 800, 104, -160},
    { 808, 152, -136},
    { 864, 248, -72},
    { 960, 272, -80},
    { 1008, 288, -120},
    { 1240, 288, -56},
    { 1408, 392, -24},
    { 1080, 400, 88},
    // 14 seconds
    { 1296, 432, -136},
    { 944, 496, -168},
    { 1088, 360, -64},
    { 1184, 312, 72},
    { 1400, 256, 64},
    { 1160, 152, 16},
    { 1048, 32, 64},
    { 1032, -16, -16},
    { 992, 16, -112},
    { 936, 72, -128},
    { 928, 16, -32},
    { 1288, 0, 0},
    { 1064, 24, -80},
    { 1200, 56, -56},
    { 1136, 56, 24},
    { 1224, 152, -184},
    { 1288, 152, -192},
    { 1216, 40, -56},
    { 856, 64, -80},
    { 616, 80, -144},
    { 624, 152, -120},
    { 680, 192, -72},
    { 872, 200, -16},
    { 1024, 264, -176},
    { 1368, 272, -208},
    // 15 seconds
    { 1608, 264, -120},
    { 1264, 296, -88},
    { 1152, 360, -192},
    { 1000, 472, -264},
    { 944, 392, -128},
    { 944, 296, 24},
    { 1152, 248, 48},
    { 1128, 168, 8},
    { 1032, 64, 8},
    { 1032, 40, 16},
    { 1032, 80, -16},
    { 968, 112, -40},
    { 944, 64, 8},
    { 904, 32, -8},
    { 1192, 8, 24},
    { 1120, 72, -96},
    { 1032, 80, -176},
    { 1016, 56, -208},
    { 1080, 24, -72},
    { 1144, 96, -184},
    { 1200, 160, -376},
    { 1168, 128, -280},
    { 832, 96, -96},
    { 688, 56, -160},
    { 752, 136, -120},
    // 16 seconds
    { 840, 200, -88},
    { 912, 272, -168},
    { 928, 296, -208},
    { 1192, 288, -112},
    { 1328, 432, -168},
    { 856, 496, -88},
    { 1152, 432, -112},
    { 1320, 384, -160},
    { 1248, 296, -8},
    { 1312, 272, 48},
    { 1520, 272, 72},
    { 1264, 200, 16},
    { 1032, 80, 88},
    { 1048, 0, 40},
    { 1080, 8, -40},
    { 1000, 64, -96},
    { 896, 16, -72},
    { 1000, -24, -40},
    { 856, -96, -80},
    { 592, -64, -160},
    { 952, -40, -104},
    { 1272, 32, -16},
    { 1376, 160, -160},
    { 1544, 176, -224},
    { 1504, 128, -144},
    // 17 seconds
    { 1000, 168, -128},
    { 832, 72, -72},
    { 960, 176, -64},
    { 1064, 232, -80},
    { 1056, 304, -64},
    { 944, 328, -80},
    { 1200, 392, 16},
    { 1288, 664, 184},
    { 864, 656, -48},
    { 1248, 328, -24},
    { 1176, 416, -112},
    { 1344, 400, 16},
    { 1464, 384, 128},
    { 1544, 304, 96},
    { 1264, 152, 104},
    { 1208, 8, 136},
    { 1184, -72, 32},
    { 1168, 128, 16},
    { 984, -16, -88},
    { 880, 0, -64},
    { 1008, -48, -104},
    { 712, -24, -32},
    { 840, -48, -152},
    { 1144, 56, -200},
    { 1200, 16, -160},
    // 18 seconds
    { 1488, 104, -440},
    { 1448, 112, -432},
    { 912, 112, -256},
    { 632, 216, -416},
    { 744, 208, -408},
    { 912, 104, -320},
    { 976, 184, -288},
    { 992, 176, -320},
    { 1200, 208, -368},
    { 1360, 408, -416},
    { 976, 440, -400},
    { 1128, 328, -392},
    { 1256, 312, -256},
    { 1104, 392, -208},
    { 1152, 352, -88},
    { 1448, 312, -56},
    { 1272, 208, 8},
    { 1080, 64, 64},
    { 1048, 0, 0},
    { 1080, -8, -24},
    { 1008, 8, -64},
    { 816, 8, -72},
    { 992, -8, -8},
    { 1008, 16, -16},
    { 816, 72, -72},
    // 19 seconds
    { 1184, 0, -8},
    { 1256, -8, -16},
    { 1336, 112, -264},
    { 1312, 80, -184},
    { 1192, 48, -184},
    { 824, 104, -208},
    { 680, 184, -240},
    { 776, 200, -160},
    { 928, 224, -64},
    { 1064, 296, -96},
    { 1064, 304, -88},
    { 1448, 344, -40},
    { 1216, 456, 8},
    { 1032, 488, -24},
    { 1200, 472, -120},
    { 1088, 424, -72},
    { 1128, 352, -8},
    { 1256, 336, 48},
    { 1256, 280, 8},
    { 1072, 176, 56},
    { 1040, 48, 96},
    { 1056, 0, 0},
    { 1032, 32, -80},
    { 960, 24, -40},
    { 888, 0, 0},
    // 20 seconds
    { 1144, 0, 48},
    { 984, 40, 32},
    { 1072, 80, -48},
    { 1184, 72, -56},
    { 1168, 120, -192},
    { 1224, 128, -304},
    { 1256, 32, -280},
    { 1096, 8, -160},
    { 824, 24, -264},
    { 768, 136, -312},
    { 816, 184, -272},
    { 864, 264, -200},
    { 928, 296, -232},
    { 920, 256, -160},
    { 1280, 296, -112},
    { 1216, 368, -56},
    { 1240, 384, 16},
    { 1272, 528, -120},
    { 1120, 432, -136},
    { 1160, 256, 8},
    { 1328, 224, 80},
    { 1336, 160, 32},
    { 1080, 104, 0},
    { 1016, 24, 16},
    { 960, 16, -72},
    // 21 seconds
    { 912, 48, -120},
    { 840, 16, -152},
    { 776, -48, -232},
    { 984, -160, -56},
    { 1120, -16, -56},
    { 992, 96, -152},
    { 1264, 144, -128},
    { 1336, 192, -184},
    { 1312, 304, -288},
    { 1248, 192, -144},
    { 1080, 128, -112},
    { 792, 104, -72},
    { 720, 192, -72},
    { 752, 264, -88},
    { 792, 312, -80},
    { 880, 344, -56},
    { 960, 320, 0},
    { 1360, 376, 24},
    { 1272, 608, -64},
    { 968, 456, -120},
    { 1200, 408, -64},
    { 1192, 432, -144},
    { 1184, 392, -136},
    { 1288, 400, -48},
    { 1480, 344, 96},
    // 22 seconds
    { 1336, 112, 136},
    { 1160, -56, 112},
    { 1040, -80, 48},
    { 968, -24, -88},
    { 880, 80, -120},
    { 712, 96, -128},
    { 680, 24, -104},
    { 896, 0, -104},
    { 808, 16, -176},
    { 1056, 32, -200},
    { 1248, 8, -48},
    { 1232, 120, -136},
    { 1248, 192, -192},
    { 1296, 224, -184},
    { 1264, 256, -160},
    { 1032, 168, -72},
    { 944, 184, -64},
    { 976, 192, -40},
    { 1032, 232, -32},
    { 1056, 320, -72},
    { 904, 336, -112},
    { 1136, 424, -56},
    { 1184, 888, 80},
    { 872, 408, -72},
    { 1008, 216, 24},
    // 23 seconds
    { 1208, 368, -112},
    { 1248, 408, -64},
    { 1304, 328, 40},
    { 1512, 272, 96},
    { 1344, 208, 64},
    { 1192, 96, 112},
    { 1152, 16, 104},
    { 1136, 16, 32},
    { 1064, 56, -32},
    { 944, 48, -24},
    { 848, 16, -24},
    { 920, 32, -8},
    { 824, 56, -184},
    { 912, 24, -240},
    { 1072, -16, -128},
    { 1104, 32, -176},
    { 1216, 48, -304},
    { 1256, 24, -248},
    { 1144, 80, -192},
    { 928, 96, -104},
    { 1016, 160, -160},
    { 1104, 208, -112},
    { 1072, 248, -88},
    { 1056, 280, -176},
    { 840, 224, -320},
    // 24 seconds
    { 1208, 120, -216},
    { 1328, 248, -88},
    { 960, 272, -8},
    { 1112, 352, 32},
    { 960, 440, 104},
    { 752, 464, -24},
    { 936, 344, 16},
    { 1152, 368, 120},
    { 1088, 344, 160},
    { 1056, 208, 160},
    { 1192, 72, 104},
    { 1280, 16, -8},
    { 1288, 16, -80},
    { 1240, 0, -48},
    { 1200, -32, -56},
    { 1416, 0, -120},
    { 1072, -104, -192},
    { 936, -136, -184},
    { 992, -48, -256},
    { 992, 56, -368},
    { 1088, -16, -288},
    { 1112, -96, -112},
    { 1032, -24, -88},
    { 928, 96, -120},
    { 872, 192, -136},
    // 25 seconds
    { 904, 216, -72},
    { 904, 216, -40},
    { 992, 248, -152},
    { 1008, 264, -192},
    { 1312, 296, -48},
    { 1312, 456, -64},
    { 984, 536, 56},
    { 1104, 424, -112},
    { 856, 368, -96},
    { 1016, 376, -40},
    { 1152, 376, 48},
    { 1376, 336, 64},
    { 1296, 232, 72},
    { 1248, 104, 104},
    { 1296, 16, 72},
    { 1224, 0, -32},
    { 1096, 32, -96},
    { 904, 24, -88},
    { 888, -8, -56},
    { 1048, 8, -56},
    { 856, 40, -136},
    { 1176, 8, -96},
    { 1256, 8, -48},
    { 1256, 104, -104},
    { 1240, 120, -120},
    // 26 seconds
    { 1200, 120, -120},
    { 968, 152, -112},
    { 848, 168, -144},
    { 896, 136, -80},
    { 1000, 168, -8},
    { 1112, 192, 8},
    { 1080, 264, -72},
    { 1040, 280, -72},
    { 1296, 368, -64},
    { 1096, 432, 32},
    { 1024, 472, -24},
    { 1128, 448, -128},
    { 896, 376, -96},
    { 1016, 344, -16},
    { 1184, 336, 16},
    { 1328, 296, 24},
    { 1256, 176, 72},
    { 1240, 24, 88},
    { 1208, -40, 8},
    { 1104, 16, -24},
    { 968, 32, -24},
    { 856, 24, -16},
    { 984, 40, -24},
    { 1072, 80, -96},
    { 1000, 72, -200},
    // 27 seconds
    { 1024, 0, -216},
    { 1096, -48, -72},
    { 936, 24, -248},
    { 1048, 80, -256},
    { 1208, 88, -184},
    { 1120, 112, -96},
    { 976, 144, -112},
    { 984, 208, -120},
    { 1000, 248, -64},
    { 968, 264, -88},
    { 872, 272, -176},
    { 1000, 280, -152},
    { 1272, 368, -104},
    { 992, 424, -48},
    { 1080, 408, -80},
    { 1280, 472, -136},
    { 920, 416, -104},
    { 1112, 336, -24},
    { 1336, 344, 16},
    { 1440, 248, 24},
    { 1264, 112, 56},
    { 1208, -24, 32},
    { 1208, -40, -56},
    { 1080, 48, -96},
    { 880, 64, -88},
    // 28 seconds
    { 768, 24, -56},
    { 928, 16, -72},
    { 864, 40, -160},
    { 856, 24, -192},
    { 1208, -40, -8},
    { 1296, 88, -208},
    { 1240, 136, -240},
    { 1288, 112, -280},
    { 1008, 136, -224},
    { 792, 40, -96},
    { 992, 80, -104},
    { 1144, 136, -16},
    { 1200, 256, -40},
    { 1072, 344, -96},
    { 1280, 376, -32},
    { 1272, 744, 192},
    { 976, 408, -136},
    { 1208, 264, 16},
    { 1048, 440, -80},
    { 992, 432, -56},
    { 1064, 368, -8},
    { 1288, 336, -8},
    { 1112, 264, 16},
    { 1064, 128, 80},
    { 1192, 0, 64},
    // 29 seconds
    { 1264, -32, -16},
    { 1192, 8, -80},
    { 1040, 24, -40},
    { 1144, 8, 8},
    { 1016, 24, -16},
    { 904, 32, -80},
    { 984, 32, -64},
    { 1072, 88, -192},
    { 1072, 136, -336},
    { 1160, 32, -248},
    { 1160, -80, -144},
    { 968, -24, -192},
    { 896, 64, -232},
    { 960, 160, -200},
    { 992, 208, -184},
    { 1016, 232, -128},
    { 968, 264, -160},
    { 1000, 240, -104},
    { 1296, 304, -32},
    { 1176, 384, -40},
    { 1112, 392, 24},
    { 968, 424, -104},
    { 704, 320, -152},
    { 912, 304, -16},
    { 1072, 320, 120},
    // 30 seconds
    { 1272, 280, 160},
    { 1200, 184, 128},
    { 1176, 136, 128},
    { 1128, 112, 120},
    { 1056, 120, -32},
    { 1032, 256, -224},
    { 976, 192, -144},
    { 1024, 96, -72},
    { 1096, 24, -104},
    { 856, 24, -288},
    { 840, -24, -280},
    { 968, -56, -40},
    { 992, 80, -184},
    { 1096, 168, -216},
    { 1208, 136, -160},
    { 1224, 128, -112},
    { 1000, 96, -64},
    { 920, 104, -88},
    { 952, 136, -72},
    { 984, 200, -120},
    { 1048, 240, -160},
    { 960, 248, -264},
    { 1200, 312, -152},
    { 1240, 616, -40},
    { 904, 528, -88},
    // 31 seconds
    { 1240, 328, -72},
    { 1048, 416, -128},
    { 1160, 368, -8},
    { 1248, 360, 56},
    { 1384, 336, 16},
    { 1216, 240, 48},
    { 1192, 192, 160},
    { 1344, 88, 32},
    { 1248, -88, -56},
    { 1080, -48, -112},
    { 952, -104, -96},
    { 1136, -128, -96},
    { 904, -80, -112},
    { 888, -112, -120},
    { 1104, -144, 24},
    { 1112, -16, -280},
    { 1160, -24, -288},
    { 1224, -40, -248},
    { 1152, 32, -248},
    { 904, 88, -184},
    { 848, 152, -208},
    { 960, 168, -216},
    { 1016, 176, -176},
    { 1016, 200, -176},
    { 1024, 232, -184},
    // 32 seconds
    { 1344, 304, -176},
    { 1144, 392, -64},
    { 1048, 416, -112},
    { 1360, 480, -160},
    { 1088, 408, -152},
    { 1176, 280, -40},
    { 1312, 272, -64},
    { 1304, 232, -136},
    { 1144, 144, 0},
    { 1176, 16, -88},
    { 1136, -40, -152},
    { 1088, -32, -240},
    { 1032, -32, -160},
    { 872, -32, -200},
    { 1152, 8, -216},
    { 936, -16, -264},
    { 904, -40, -288},
    { 1056, -88, -136},
    { 960, -24, -200},
    { 1040, 32, -256},
    { 1192, 80, -280},
    { 1152, 104, -136},
    { 928, 88, -128},
    { 920, 136, -152},
    { 992, 168, -80},
    // 33 seconds
    { 1088, 200, 8},
    { 1224, 248, -24},
    { 1096, 304, -184},
    { 1352, 360, -464},
    { 1304, 464, -336},
    { 1112, 832, -440},
    { 1384, 256, -224},
    { 1032, 208, -160},
    { 1136, 232, -104},
    { 1296, 256, -32},
    { 1304, 256, -104},
    { 1160, 208, -96},
    { 1168, 112, 40},
    { 1288, 120, 64},
    { 1280, 120, 40},
    { 1136, 72, 8},
    { 912, -24, -32},
    { 1024, -80, 56},
    { 912, -16, 8},
    { 688, 40, -144},
    { 824, 48, -208},
    { 992, 8, -136},
    { 1152, 136, -400},
    { 1256, 104, -496},
    { 1392, -24, -304},
    // 34 seconds
    { 1080, -24, -272},
    { 848, -32, -240},
    { 1016, 120, -232},
    { 1072, 232, -128},
    { 1016, 272, -200},
    { 944, 280, -232},
    { 1184, 296, -96},
    { 1312, 424, 0},
    { 920, 520, 96},
    { 1072, 472, -56},
    { 1192, 496, -56},
    { 880, 376, -48},
    { 1104, 344, 32},
    { 1456, 368, 88},
    { 1400, 288, 72},
    { 1288, 136, 128},
    { 1368, -8, 80},
    { 1376, -40, -72},
    { 1216, 8, -144},
    { 952, 0, -216},
    { 712, -64, -96},
    { 792, -88, -24},
    { 744, -72, -128},
    { 848, 0, -184},
    { 1152, -8, -24},
    // 35 seconds
    { 1304, 88, -80},
    { 1424, 168, -160},
    { 1344, 104, -104},
    { 1072, 104, -112},
    { 888, 200, -64},
    { 992, 296, -120},
    { 1120, 208, 16},
    { 1128, 240, -8},
    { 1040, 232, -88},
    { 872, 208, -168},
    { 1344, 232, -96},
    { 1296, 432, 8},
    { 944, 592, 96},
    { 1080, 440, -176},
    { 992, 384, -144},
    { 1112, 424, -32},
    { 1200, 384, 48},
    { 1400, 288, 40},
    { 1360, 184, 88},
    { 1216, 88, 128},
    { 1216, 32, 120},
    { 1200, 32, 64},
    { 1136, 56, 64},
    { 1008, 80, 56},
    { 944, 32, 32},
    // 36 seconds
    { 1112, 16, 40},
    { 856, 24, -16},
    { 920, -56, -80},
    { 1080, -80, -72},
    { 1064, 112, -120},
    { 1040, 48, -72},
    { 1200, 0, -216},
    { 1168, -16, -112},
    { 1040, -208, -152},
    { 984, 528, -248},
    { 1064, 344, -72},
    { 1096, 256, -104},
    { 1136, 200, -128},
    { 1096, 248, -216},
    { 1352, 312, -184},
    { 1248, 512, -168},
    { 928, 592, -128},
    { 1216, 328, -184},
    { 1040, 336, -144},
    { 1224, 304, -16},
    { 1328, 256, 32},
    { 1400, 224, 16},
    { 1232, 152, 16},
    { 1160, 72, 104},
    { 1160, 64, 96},
    // 37 seconds
    { 1136, 80, 32},
    { 1032, 72, 40},
    { 848, 24, 24},
    { 920, 0, 24},
    { 1048, -24, -56},
    { 912, -72, -144},
    { 1160, -160, 48},
    { 1408, 8, -224},
    { 1216, 96, -320},
    { 1184, -40, -120},
    { 1200, -32, -152},
    { 1000, 96, -88},
    { 976, 224, -80},
    { 1104, 304, 40},
    { 1168, 312, 104},
    { 1152, 328, 24},
    { 912, 288, -24},
    { 1112, 328, 48},
    { 1200, 448, 208},
    { 800, 512, 144},
    { 1072, 472, 120},
    { 1184, 496, 48},
    { 1104, 424, 8},
    { 1144, 368, 80},
    { 1416, 320, 88},
    // 38 seconds
    { 1344, 272, 64},
    { 1296, 176, 96},
    { 1408, 80, 112},
    { 1456, 16, 16},
    { 1264, 8, -56},
    { 1000, -48, -128},
    { 800, -128, -24},
    { 936, -72, -32},
    { 720, 8, -112},
    { 760, 64, -136},
    { 1144, 48, -72},
    { 1256, 168, -240},
    { 1352, 160, -280},
    { 1336, 0, -56},
    { 1136, 56, -96},
    { 944, 104, -152},
    { 968, 216, -72},
    { 1048, 248, -40},
    { 1104, 256, -32},
    { 976, 296, -88},
    { 984, 280, -48},
    { 1304, 392, 16},
    { 952, 568, 208},
    { 1096, 496, -80},
    { 1232, 344, -24},
    // 39 seconds
    { 936, 384, -56},
    { 1064, 400, 24},
    { 1280, 360, 64},
    { 1264, 296, 32},
    { 1160, 208, 72},
    { 1184, 88, 144},
    { 1248, -72, -40},
    { 1248, -80, -432},
    { 992, -264, -200},
    { 600, -256, -48},
    { 784, 0, -72},
    { 1056, 248, -312},
    { 944, 216, -432},
    { 1232, 32, -104},
    { 1192, -8, 32},
    { 1168, 80, -24},
    { 1080, 136, -96},
    { 960, 216, -120},
    { 856, 240, -144},
    { 864, 232, -96},
    { 976, 168, -48},
    { 1056, 144, -104},
    { 1072, 168, -128},
    { 936, 288, 0},
    { 904, 528, 240},
    // 40 seconds
    { 1280, 680, -88},
    { 984, 360, 144},
    { 1128, 408, 192},
    { 1320, 480, 192},
    { 960, 400, 72},
    { 1048, 400, 88},
    { 1232, 336, 184},
    { 1208, 208, 128},
    { 1104, 64, 72},
    { 1104, 16, 16},
    { 1184, 64, -32},
    { 1144, 104, -32},
    { 968, 64, -80},
    { 728, 24, -104},
    { 832, 0, -48},
    { 1032, 32, -168},
    { 920, 80, -312},
    { 1240, -16, -48},
    { 1280, -8, -152},
    { 1312, 56, -192},
    { 1312, 72, -136},
    { 1160, 152, -176},
    { 856, 176, -216},
    { 760, 184, -192},
    { 872, 192, -128},
    // 41 seconds
    { 1032, 184, -88},
    { 1024, 184, -112},
    { 944, 232, -40},
    { 1384, 400, 16},
    { 1376, 576, 256},
    { 872, 616, -24},
    { 1096, 296, 64},
    { 1200, 352, 24},
    { 1040, 408, 16},
    { 976, 440, 48},
    { 1176, 376, 80},
    { 1168, 280, 112},
    { 1184, 96, 168},
    { 1280, -16, 136},
    { 1344, -32, 80},
    { 1232, 0, 48},
    { 1008, 48, 16},
    { 1016, 56, -8},
    { 1032, 96, -104},
    { 872, -8, -88},
    { 1000, -120, -32},
    { 1024, -112, -120},
    { 1016, 80, -240},
    { 1048, 48, -208},
    { 1176, 32, -240},
    // 42 seconds
    { 1104, 120, -232},
    { 952, 128, -168},
    { 968, 184, -176},
    { 1040, 232, -88},
    { 1184, 256, -96},
    { 1000, 232, -200},
    { 1096, 240, -128},
    { 1416, 384, -56},
    { 880, 440, 128},
    { 1072, 408, -16},
    { 1224, 408, -88},
    { 1096, 416, -48},
    { 1088, 360, 32},
    { 1248, 344, 96},
    { 1152, 256, 80},
    { 1072, 136, 128},
    { 1192, 56, 120},
    { 1304, 24, 24},
    { 1264, 40, -40},
    { 1096, 24, -56},
    { 904, -64, 32},
    { 1008, -80, 32},
    { 760, -56, -96},
    { 840, 16, -176},
    { 1184, -56, 8},
    // 43 seconds
    { 1400, 48, -272},
    { 1408, 64, -224},
    { 1280, -56, -128},
    { 1064, 48, -144},
    { 840, 152, -136},
    { 864, 200, -72},
    { 1024, 224, 40},
    { 1096, 248, 0},
    { 1000, 272, -112},
    { 1152, 280, -16},
    { 1352, 464, 112},
    { 912, 632, 96},
    { 1136, 416, -40},
    { 1032, 352, -40},
    { 944, 368, -16},
    { 1064, 368, 32},
    { 1240, 320, 64},
    { 1304, 256, 40},
    { 1304, 184, 80},
    { 1352, 160, 144},
    { 1360, 48, 72},
    { 1264, -56, -24},
    { 1024, -64, -120},
    { 792, -80, -120},
    { 912, -48, 24},
    // 44 seconds
    { 984, 8, -88},
    { 936, -16, -72},
    { 968, -40, 0},
    { 1144, 48, -64},
    { 1160, 80, -160},
    { 1168, 24, -136},
    { 1168, 8, -128},
    { 1008, 48, -160},
    { 928, 80, -136},
    { 968, 144, -64},
    { 1056, 208, -48},
    { 1104, 256, -136},
    { 984, 280, -168},
    { 1232, 304, -48},
    { 1200, 400, 8},
    { 944, 440, 160},
    { 1248, 400, -128},
    { 968, 352, -72},
    { 1000, 368, 0},
    { 1112, 376, 88},
    { 1264, 328, 48},
    { 1112, 192, 88},
    { 1104, 72, 104},
    { 1192, -24, 24},
    { 1216, -24, -16},
    // 45 seconds
    { 1128, 32, -48},
    { 960, 40, -48},
    { 1160, 32, 16},
    { 1056, 56, -80},
    { 944, 80, -112},
    { 1104, 8, -40},
    { 1104, 32, -112},
    { 1008, 72, -208},
    { 1096, 56, -216},
    { 1072, 72, -224},
    { 768, 96, -160},
    { 696, 104, -160},
    { 832, 144, -136},
    { 952, 160, -88},
    { 1064, 200, -144},
    { 936, 208, -280},
    { 1080, 176, -232},
    { 1416, 288, -192},
    { 992, 344, -104},
    { 1128, 408, -8},
    { 1152, 464, -200},
    { 1048, 304, -48},
    { 1080, 304, 56},
    { 1248, 320, 56},
    { 1160, 272, 0},
    // 46 seconds
    { 1040, 144, 56},
    { 1072, 64, 80},
    { 1184, 16, -16},
    { 1232, 24, -96},
    { 1056, 24, -104},
    { 960, -16, -72},
    { 1120, 8, -152},
    { 832, 32, -272},
    { 896, -8, -152},
    { 1024, -32, -48},
    { 1112, 112, -112},
    { 1360, 288, -392},
    { 1240, 224, -296},
    { 856, 56, 16},
    { 608, -88, 56},
    { 640, -40, 24},
    { 864, 88, -32},
    { 952, 256, -104},
    { 888, 248, -120},
    { 832, 208, -224},
    { 1456, 280, -424},
    { 1600, 408, -328},
    { 1072, 968, -368},
    { 1520, 176, -424},
    { 1136, 152, -280},
    // 47 seconds
    { 1328, 320, -232},
    { 1600, 376, -32},
    { 1768, 360, -288},
    { 1552, 376, -416},
    { 1528, 464, -328},
    { 1440, 568, -144},
    { 1200, 440, -224},
    { 896, 184, -328},
    { 624, 64, -576},
    { 472, -136, -424},
    { 352, 32, -536},
    { 176, -152, -592},
    { 16, -384, -664},
    { -24, -248, -960},
    { 176, -256, -1072},
    { 136, -376, -904},
    { 80, -264, -848},
    { -32, -344, -768},
    { -160, -352, -696},
    { -208, -392, -704},
    { -232, -368, -776},
    { -128, -136, -952},
    { -152, -240, -1080},
    { -160, -256, -1160},
    { -72, -200, -1248},
    // 48 seconds
    { -112, -208, -1272},
    { -160, -128, -1272},
    { -184, -40, -1216},
    { -312, 16, -1096},
    { -296, 88, -1016},
    { -144, -32, -984},
    { -104, -136, -904},
    { -176, -152, -816},
    { -224, -184, -824},
    { -264, -240, -864},
    { -224, -224, -872},
    { -232, -320, -776},
    { -224, -576, -616},
    { -48, -600, -440},
    { 200, -520, -144},
    { 688, -272, 328},
    { 1480, 320, 672},
    { 2896, 1200, 1440},
    { 2272, 1928, 1888},
    { 1112, 1264, -16},
    { 1376, 328, 152},
    { 1344, 856, 72},
    { 1272, 360, 520},
    { 1296, 112, 448},
    { 1376, 56, 216},
    // 49 seconds
    { 1064, 312, 72},
    { 1304, 424, 144},
    { 1240, 616, 408},
    { 824, 720, 376},
    { 984, 568, 192},
    { 872, 424, 88},
    { 944, 368, 136},
    { 1056, 432, 192},
    { 1352, 408, 208},
    { 1392, 312, 144},
    { 1440, 224, 144},
    { 1528, 176, 168},
    { 1520, 112, 136},
    { 1344, 72, -16},
    { 1040, 24, -96},
    { 840, -16, -72},
    { 1024, -56, -16},
    { 800, -120, -56},
    { 920, -120, -8},
    { 1192, -160, 176},
    { 1368, 144, -56},
    { 1240, 248, -96},
    { 1208, 128, -240},
    { 1120, 152, -256},
    { 976, 136, -184},
    // 50 seconds
    { 1040, 168, -16},
    { 1160, 248, 152},
    { 1296, 320, 48},
    { 1096, 328, -16},
    { 888, 296, -40},
    { 1288, 416, -16},
    { 1040, 536, 160},
    { 1168, 728, 128},
    { 1128, 448, -88},
    { 928, 256, -24},
    { 1056, 368, 56},
    { 1392, 416, 88},
    { 1320, 320, 48},
    { 1224, 160, 96},
    { 1248, 104, 160},
    { 1264, 56, 200},
    { 1032, 112, 72},
    { 896, 216, -96},
    { 960, 112, -48},
    { 1248, -96, 192},
    { 784, -272, 144},
    { 1016, -296, -16},
    { 1232, -96, 8},
    { 1328, 80, -344},
    { 1280, -16, -200},
    // 51 seconds
    { 1296, -56, -8},
    { 1112, 56, -56},
    { 936, 136, -120},
    { 928, 184, -8},
    { 1008, 216, 96},
    { 1088, 280, 32},
    { 960, 344, -128},
    { 952, 328, -120},
    { 1408, 432, -32},
    { 968, 632, 168},
    { 1080, 616, -112},
    { 1136, 328, -104},
    { 1088, 312, -56},
    { 1248, 352, 48},
    { 1456, 352, 80},
    { 1392, 272, 24},
    { 1248, 184, 64},
    { 1216, 104, 144},
    { 1192, 64, 48},
    { 1080, 64, -64},
    { 848, 80, -144},
    { 832, -16, -48},
    { 1024, -48, -24},
    { 792, -48, -96},
    { 1096, -16, -64},
    // 52 seconds
    { 1136, -8, 96},
    { 1256, 160, -32},
    { 1376, 216, -104},
    { 1336, 192, -48},
    { 1096, 200, -80},
    { 848, 168, -128},
    { 832, 160, -56},
    { 936, 176, 16},
    { 1104, 232, 32},
    { 1024, 288, -112},
    { 952, 280, -184},
    { 1416, 320, -104},
    { 1184, 456, -48},
    { 1032, 552, 8},
    { 1024, 440, -208},
    { 1008, 328, -96},
    { 1184, 352, 0},
    { 1272, 344, 88},
    { 1304, 280, 32},
    { 1152, 160, 48},
    { 1112, 88, 112},
    { 1176, 80, 80},
    { 1168, 72, 24},
    { 1024, 88, -8},
    { 856, 48, 8},
    // 53 seconds
    { 1120, 0, 48},
    { 984, 48, -16},
    { 1272, 0, 40},
    { 1136, -24, 16},
    { 1184, 128, -176},
    { 1096, 112, -136},
    { 1088, 24, -64},
    { 1032, 88, -144},
    { 880, 152, -176},
    { 872, 168, -184},
    { 928, 184, -88},
    { 1056, 240, 0},
    { 1104, 296, -128},
    { 1008, 312, -192},
    { 1336, 344, -72},
    { 1208, 416, -16},
    { 1272, 488, 40},
    { 1104, 520, -192},
    { 1040, 288, -64},
    { 1112, 296, 48},
    { 1328, 304, 64},
    { 1384, 224, 32},
    { 1200, 96, 80},
    { 1144, 40, 104},
    { 1072, 64, 32},
    // 54 seconds
    { 968, 88, 0},
    { 872, 64, 8},
    { 760, 32, 16},
    { 1032, 16, 48},
    { 1168, 40, 24},
    { 1040, 96, -24},
    { 1256, 120, -56},
    { 1208, 176, -184},
    { 1216, 240, -336},
    { 1136, 120, -256},
    { 1000, 40, -104},
    { 760, 40, -144},
    { 760, 144, -144},
    { 792, 240, -72},
    { 880, 240, -16},
    { 1032, 256, -56},
    { 960, 272, -232},
    { 1096, 224, -112},
    { 1480, 344, -128},
    { 944, 400, -96},
    { 960, 440, -48},
    { 1088, 568, -120},
    { 1056, 360, -72},
    { 1232, 256, 72},
    { 1416, 272, 88},
    // 55 seconds
    { 1320, 256, 8},
    { 1096, 160, 16},
    { 1032, 80, 88},
    { 1048, 64, 16},
    { 1040, 72, -56},
    { 904, 80, -56},
    { 776, 32, -56},
    { 1024, -24, 32},
    { 864, 24, -40},
    { 944, 64, -88},
    { 1168, 64, 8},
    { 1248, 136, -8},
    { 1280, 232, -192},
    { 1288, 184, -232},
    { 1064, 136, -160},
    { 688, 32, -136},
    { 712, 72, -152},
    { 840, 160, -48},
    { 1040, 240, 40},
    { 1112, 328, -40},
    { 864, 320, -184},
    { 1040, 256, -232},
    { 1432, 400, -336},
    { 944, 440, -192},
    { 1104, 456, -48},
    // 56 seconds
    { 1248, 256, -176},
    { 1064, 160, 8},
    { 1240, 216, 32},
    { 1312, 312, -72},
    { 1136, 272, -72},
    { 1104, 128, 72},
    { 1184, 112, 88},
    { 1224, 96, 40},
    { 1120, 56, 0},
    { 864, 24, -8},
    { 752, -16, -16},
    { 1056, 8, 16},
    { 744, 24, -56},
    { 984, -48, 48},
    { 1072, 72, 8},
    { 1152, 176, -256},
    { 1288, 176, -200},
    { 1304, 72, -80},
    { 1104, 80, -32},
    { 872, 128, -184},
    { 832, 184, -160},
    { 920, 176, -56},
    { 1040, 192, -32},
    { 1088, 264, -120},
    { 928, 312, -176},
    // 57 seconds
    { 1200, 320, -48},
    { 1264, 512, -24},
    { 1144, 832, 16},
    { 1216, 232, -152},
    { 824, 104, -24},
    { 1088, 256, 24},
    { 1296, 376, -24},
    { 1384, 328, -8},
    { 1104, 160, 56},
    { 1032, 64, 136},
    { 1032, 24, 24},
    { 1000, 32, -24},
    { 944, 48, -16},
    { 792, 56, 8},
    { 1000, 40, 64},
    { 1096, 8, 0},
    { 944, -48, -40},
    { 1256, -200, 128},
    { 1280, 152, -56},
    { 1200, 208, -176},
    { 1176, 88, -160},
    { 1120, 80, -136},
    { 848, -56, -168},
    { 792, 272, -136},
    { 928, 184, 48},
    // 58 seconds
    { 1040, 256, 40},
    { 1128, 320, -104},
    { 976, 304, -136},
    { 1368, 368, -80},
    { 1136, 568, 8},
    { 1184, 592, -56},
    { 1208, 264, -160},
    { 944, 256, -80},
    { 1128, 640, -144},
    { 1656, 712, 32},
    { 1840, 632, 232},
    { 1752, 312, 264},
    { 1688, 416, -16},
    { 1592, 496, -56},
    { 1312, 560, -184},
    { 960, 424, -272},
    { 624, 48, -216},
    { 496, -200, -432},
    { 360, -128, -568},
    { 216, -336, -600},
    { 112, -456, -784},
    { 8, -192, -952},
    { 72, -112, -992},
    { 40, -272, -872},
    { 32, -272, -848},
    // 59 seconds
    { -80, -256, -816},
    { -184, -272, -800},
    { -208, -248, -816},
    { -208, -240, -864},
    { -192, -280, -936},
    { -200, -352, -1016},
    { -240, -384, -1104},
    { -144, -296, -1192},
    { -184, -288, -1224},
    { -224, -120, -1176},
    { -200, -8, -1144},
    { -352, -24, -1048},
    { -376, 48, -992},
    { -176, -16, -1008},
    { -112, -120, -936},
    { -168, -104, -800},
    { -224, -168, -792},
    { -224, -232, -832},
    { -192, -264, -824},
    { -200, -368, -728},
    { -240, -608, -552},
    { -88, -552, -368},
    { 208, -456, -232},
    { 800, 80, -232},
    { 1416, 376, -120},
    // 60 seconds
    // elapsed: 1 minutes
    { 1984, 648, -72},
    { 2248, 704, -176},
    { 2112, 544, -128},
    { 1712, 400, -408},
    { 1400, 328, -240},
    { 1288, 376, 224},
    { 1216, 256, 448},
    { 1304, 200, 184},
    { 1080, 240, 0},
    { 920, 392, -64},
    { 1328, 448, 184},
    { 992, 616, 360},
    { 896, 752, 112},
    { 984, 544, 128},
    { 912, 440, 64},
    { 1136, 392, 128},
    { 1320, 448, 144},
    { 1552, 392, 64},
    { 1456, 264, 144},
    { 1616, 152, 224},
    { 1704, 40, 144},
    { 1504, 0, 16},
    { 1208, -16, -56},
    { 856, -48, -56},
    { 784, -112, 80},
    // 61 seconds
    { 808, -120, 72},
    { 640, -24, -120},
    { 928, -48, -56},
    { 1248, 24, -8},
    { 1440, 208, -112},
    { 1496, 200, -240},
    { 1384, 16, -136},
    { 1104, 120, -192},
    { 968, 216, -112},
    { 1088, 240, 8},
    { 1264, 232, 32},
    { 1232, 272, 24},
    { 992, 304, -8},
    { 1216, 312, 0},
    { 1120, 416, 192},
    { 1056, 680, 64},
    { 1200, 600, -88},
    { 888, 352, -32},
    { 1000, 344, 0},
    { 1208, 400, 104},
    { 1360, 320, 32},
    { 1200, 192, 8},
    { 1272, 120, 72},
    { 1312, 80, 112},
    { 1176, 32, 16},
    // 62 seconds
    { 1016, 40, -32},
    { 848, 0, -8},
    { 1072, -56, 96},
    { 952, -16, 144},
    { 1088, -24, 120},
    { 1232, -16, 144},
    { 1448, 320, -200},
    { 1248, 296, -208},
    { 1176, 48, -56},
    { 992, 16, 16},
    { 816, 120, -320},
    { 752, 264, -120},
    { 872, 200, 128},
    { 992, 240, 24},
    { 960, 264, -32},
    { 984, 240, 8},
    { 1464, 368, 24},
    { 1072, 728, 224},
    { 1312, 536, -160},
    { 1088, 184, -80},
    { 1040, 304, -48},
    { 1072, 408, 0},
    { 1336, 352, 8},
    { 1136, 208, 8},
    { 1080, 104, 64},
    // 63 seconds
    { 1168, 16, 64},
    { 1192, 8, -8},
    { 1096, 40, -56},
    { 920, 48, -104},
    { 952, -8, 16},
    { 1120, -16, 40},
    { 840, -24, -8},
    { 1064, -48, 0},
    { 1280, 56, -8},
    { 1264, 216, -168},
    { 1184, 184, -136},
    { 1152, 40, 24},
    { 976, 88, -104},
    { 752, 96, -104},
    { 776, 152, -40},
    { 912, 192, 0},
    { 992, 232, -16},
    { 1072, 296, -72},
    { 976, 304, -88},
    { 1296, 336, 16},
    { 1112, 504, 160},
    { 1088, 648, -88},
    { 1144, 304, -128},
    { 1072, 288, -48},
    { 1216, 376, 64},
    // 64 seconds
    { 1352, 352, 40},
    { 1208, 240, 16},
    { 1040, 96, 88},
    { 1040, 8, 72},
    { 1048, -16, -8},
    { 1032, 24, -64},
    { 984, 80, -8},
    { 944, 32, 80},
    { 1168, 56, 64},
    { 1096, -24, 48},
    { 976, -96, -16},
    { 1216, 32, -120},
    { 1216, 224, -296},
    { 1104, 104, -160},
    { 1016, -160, 104},
    { 952, -88, 40},
    { 840, 48, -64},
    { 848, 176, -72},
    { 984, 240, -16},
    { 1032, 272, -16},
    { 952, 320, -208},
    { 1072, 304, -224},
    { 1368, 376, -72},
    { 992, 608, 128},
    { 1176, 440, -176},
    // 65 seconds
    { 1144, 248, -128},
    { 1008, 352, -80},
    { 1088, 392, 0},
    { 1352, 376, 32},
    { 1208, 248, 48},
    { 1136, 120, 144},
    { 1184, -8, 128},
    { 1216, -32, 24},
    { 1112, 24, 0},
    { 968, 56, 32},
    { 1080, 8, 80},
    { 1144, 40, 56},
    { 872, 24, 0},
    { 976, 24, -72},
    { 1144, -24, -8},
    { 1200, 128, -216},
    { 1144, 104, -216},
    { 1120, -8, -128},
    { 1008, 48, -152},
    { 840, 104, -120},
    { 888, 176, -120},
    { 1000, 224, 24},
    { 1064, 280, 16},
    { 1016, 312, -144},
    { 1072, 272, -160},
    // 66 seconds
    { 1376, 368, -64},
    { 1000, 576, 72},
    { 984, 608, -80},
    { 1312, 296, -80},
    { 1160, 288, -80},
    { 1136, 360, -56},
    { 1296, 376, 0},
    { 1224, 304, 16},
    { 1120, 168, 120},
    { 1184, 48, 144},
    { 1264, -16, 64},
    { 1168, 0, -16},
    { 992, 24, 0},
    { 856, 0, 24},
    { 1120, 16, 32},
    { 808, 16, -40},
    { 992, -8, -24},
    { 1120, -8, -8},
    { 1112, 160, -240},
    { 1216, 160, -304},
    { 1288, 64, -256},
    { 1040, 64, -96},
    { 816, 40, -88},
    { 952, 136, -88},
    { 1080, 240, -16},
    // 67 seconds
    { 1128, 296, -48},
    { 1000, 304, -112},
    { 840, 280, -80},
    { 1200, 320, 8},
    { 1064, 472, 40},
    { 960, 552, -8},
    { 1248, 384, -152},
    { 1056, 304, -24},
    { 1280, 352, 56},
    { 1360, 360, 32},
    { 1416, 288, -8},
    { 1224, 104, 144},
    { 1136, -24, 72},
    { 1040, -120, -16},
    { 952, -40, -56},
    { 832, 40, -48},
    { 848, 8, 72},
    { 1088, 72, 48},
    { 920, 136, -88},
    { 1072, 56, -16},
    { 1240, 0, 64},
    { 1352, 152, -80},
    { 1336, 160, -200},
    { 1256, 32, -72},
    { 992, 48, -80},
    // 68 seconds
    { 816, 96, -184},
    { 872, 168, -136},
    { 960, 208, -24},
    { 984, 240, -48},
    { 952, 304, -176},
    { 920, 264, -112},
    { 1224, 280, 16},
    { 1040, 400, 80},
    { 1112, 528, 48},
    { 1216, 672, -184},
    { 1040, 320, -48},
    { 1184, 256, 88},
    { 1424, 328, 88},
    { 1512, 280, -48},
    { 1416, 80, 88},
    { 1320, -32, 96},
    { 1112, -88, -72},
    { 960, 8, -104},
    { 776, 8, -80},
    { 656, -24, -40},
    { 952, 16, -16},
    { 928, 64, -80},
    { 1024, 48, -88},
    { 1344, 16, 48},
    { 1520, 152, -24},
    // 69 seconds
    { 1504, 216, -104},
    { 1408, 104, 0},
    { 1192, 120, -64},
    { 928, 144, -136},
    { 872, 160, -80},
    { 896, 176, 24},
    { 880, 216, 64},
    { 904, 280, -40},
    { 848, 312, -184},
    { 1160, 288, -48},
    { 1288, 344, 16},
    { 1000, 400, 112},
    { 1200, 520, -64},
    { 1048, 576, -216},
    { 1096, 240, 0},
    { 1232, 296, 128},
    { 1480, 320, 56},
    { 1440, 224, -24},
    { 1368, 64, 40},
    { 1296, -40, -16},
    { 1088, -64, -104},
    { 904, -16, -48},
    { 704, -32, -48},
    { 808, -8, -56},
    { 1144, 64, -32},
    // 70 seconds
    { 864, 136, -200},
    { 1200, 8, -88},
    { 1512, 0, 40},
    { 1448, 168, -112},
    { 1312, 120, -24},
    { 1240, 96, -112},
    { 1016, 136, -88},
    { 920, 168, 24},
    { 944, 200, 192},
    { 976, 256, 112},
    { 1032, 304, -8},
    { 952, 288, -64},
    { 1128, 304, 40},
    { 1264, 472, 256},
    { 1000, 848, 152},
    { 1392, 592, 64},
    { 784, 288, -8},
    { 1144, 288, -40},
    { 1432, 464, 80},
    { 1688, 432, 96},
    { 1608, 232, 64},
    { 1544, 104, 136},
    { 1440, 8, 104},
    { 1184, -24, -120},
    { 944, -96, -160},
    // 71 seconds
    { 680, -208, -96},
    { 624, -344, 0},
    { 840, -176, -48},
    { 1008, -16, -16},
    { 1544, 56, 152},
    { 1776, 224, -80},
    { 1688, 328, -32},
    { 1456, 152, -56},
    { 1072, 56, -104},
    { 888, 120, -24},
    { 960, 152, 72},
    { 1016, 192, 112},
    { 1112, 264, 56},
    { 1056, 304, 48},
    { 1072, 320, 128},
    { 1328, 568, 256},
    { 888, 1064, -8},
    { 1096, 272, 48},
    { 992, 360, -64},
    { 1096, 360, 0},
    { 1288, 376, 80},
    { 1544, 336, 64},
    { 1448, 248, 0},
    { 1472, 192, 8},
    { 1544, 96, 136},
    // 72 seconds
    { 1360, 0, 0},
    { 1088, -8, -216},
    { 792, -64, -168},
    { 632, -240, 8},
    { 848, -136, -96},
    { 760, -40, -192},
    { 1112, -40, 32},
    { 1464, 16, 152},
    { 1520, 272, -120},
    { 1544, 248, -24},
    { 1440, 168, 40},
    { 1112, 176, 0},
    { 960, 160, 48},
    { 1048, 176, 144},
    { 1120, 224, 104},
    { 1120, 280, 40},
    { 888, 296, 16},
    { 1184, 344, 88},
    { 1176, 632, 256},
    { 896, 920, -112},
    { 1048, 256, 8},
    { 1040, 440, -104},
    { 1128, 440, -32},
    { 1256, 424, 72},
    { 1512, 312, 56},
    // 73 seconds
    { 1328, 192, 32},
    { 1328, 120, 88},
    { 1440, 72, 120},
    { 1400, 48, 64},
    { 1224, 48, -8},
    { 936, 40, -64},
    { 880, -56, 8},
    { 1008, -64, 48},
    { 672, -80, 32},
    { 1120, -64, 48},
    { 1264, 40, 24},
    { 1296, 248, -192},
    { 1280, 120, -88},
    { 1304, 16, -72},
    { 1088, 128, -192},
    { 952, 168, -160},
    { 968, 184, -8},
    { 1080, 224, 56},
    { 1120, 280, -24},
    { 912, 280, -120},
    { 1208, 296, -120},
    { 1280, 448, -64},
    { 1064, 616, 160},
    { 1240, 488, -192},
    { 904, 264, -104},
    // 74 seconds
    { 1024, 336, -40},
    { 1120, 344, 16},
    { 1384, 304, 0},
    { 1232, 184, 8},
    { 1168, 96, 16},
    { 1224, 64, -40},
    { 1200, 64, -96},
    { 1016, 40, -72},
    { 824, 8, -104},
    { 1040, -32, -64},
    { 1056, -8, -152},
    { 792, -64, -64},
    { 1104, -112, 104},
    { 1272, 104, -64},
    { 1328, 224, -248},
    { 1280, 96, -64},
    { 1152, 64, 0},
    { 872, 88, -88},
    { 784, 120, -112},
    { 864, 160, -80},
    { 992, 184, 0},
    { 952, 240, -72},
    { 896, 256, -136},
    { 1368, 296, -112},
    { 1328, 472, -96},
    // 75 seconds
    { 1048, 744, 80},
    { 1336, 368, -200},
    { 840, 240, -136},
    { 1008, 328, -8},
    { 1144, 352, 0},
    { 1344, 304, -32},
    { 1152, 176, 16},
    { 1144, 56, 96},
    { 1200, 24, 48},
    { 1152, 32, -56},
    { 1040, 48, -96},
    { 920, 16, -64},
    { 1080, 0, -24},
    { 1080, -56, -64},
    { 1040, -152, 0},
    { 1200, -160, 96},
    { 1240, 144, -152},
    { 1128, 152, -176},
    { 1120, 24, -64},
    { 1104, 72, -112},
    { 920, 120, -136},
    { 888, 160, -160},
    { 960, 184, -56},
    { 1040, 240, -48},
    { 1056, 272, -168},
    // 76 seconds
    { 976, 240, -224},
    { 1288, 264, -112},
    { 1144, 368, -64},
    { 1144, 440, 56},
    { 1200, 464, -176},
    { 912, 336, -120},
    { 960, 304, -24},
    { 1120, 304, 40},
    { 1272, 256, 16},
    { 1128, 152, 64},
    { 1104, 56, 88},
    { 1144, 40, 32},
    { 1120, 96, -32},
    { 1040, 112, -24},
    { 872, 80, -72},
    { 1088, 32, 0},
    { 1088, 72, -88},
    { 984, 80, -32},
    { 1160, 0, 104},
    { 1192, 72, -112},
    { 1120, 120, -272},
    { 1040, -40, -64},
    { 1008, -24, -152},
    { 824, 104, -192},
    { 792, 176, -232},
    // 77 seconds
    { 920, 200, -120},
    { 1024, 224, -8},
    { 1160, 248, -16},
    { 1104, 264, -112},
    { 1320, 312, -96},
    { 1216, 472, -64},
    { 968, 512, 24},
    { 1168, 336, -136},
    { 968, 352, -104},
    { 1072, 352, -16},
    { 1152, 312, 24},
    { 1304, 280, 8},
    { 1184, 192, 32},
    { 1144, 40, 64},
    { 1112, -24, 8},
    { 1024, 8, -96},
    { 944, 72, -144},
    { 784, 32, -80},
    { 952, -8, 24},
    { 1192, 96, -88},
    { 936, 104, -96},
    { 1200, -32, 72},
    { 1112, 8, 16},
    { 1176, 160, -128},
    { 1176, 96, -32},
    // 78 seconds
    { 1088, 96, -48},
    { 880, 144, -112},
    { 800, 160, -128},
    { 880, 184, -96},
    { 976, 200, -72},
    { 1040, 232, -88},
    { 896, 256, -208},
    { 1168, 280, -200},
    { 1352, 408, -120},
    { 1000, 592, 64},
    { 1384, 424, -176},
    { 1024, 264, -128},
    { 1064, 304, -8},
    { 1120, 360, 24},
    { 1352, 352, -8},
    { 1184, 192, 24},
    { 1080, 64, 96},
    { 1136, 32, 32},
    { 1176, 48, -24},
    { 1096, 80, -32},
    { 856, 64, -80},
    { 928, 8, -32},
    { 1064, -48, -88},
    { 672, -128, -104},
    { 1072, -120, -24},
    // 79 seconds
    { 1288, 16, -80},
    { 1280, 152, -200},
    { 1352, 72, -56},
    { 1264, 8, 0},
    { 920, 80, -120},
    { 792, 136, -152},
    { 872, 168, -48},
    { 1008, 224, -8},
    { 1048, 296, -96},
    { 904, 336, -176},
    { 1256, 400, -56},
    { 1216, 808, 72},
    { 928, 272, 16},
    { 1200, 240, -48},
    { 1176, 448, -160},
    { 1080, 432, -32},
    { 1168, 368, 40},
    { 1400, 336, 32},
    { 1360, 184, 48},
    { 1248, 32, 120},
    { 1264, -32, 40},
    { 1200, 8, -48},
    { 976, 88, -80},
    { 808, 56, -40},
    { 1080, 48, -8},
    // 80 seconds
    { 848, 24, -96},
    { 656, -72, -72},
    { 920, -128, 16},
    { 1136, 56, -104},
    { 1040, 144, -152},
    { 1240, 120, -104},
    { 1344, 144, -80},
    { 1032, 168, -112},
    { 888, 136, -136},
    { 968, 168, -96},
    { 1088, 184, -64},
    { 1024, 216, -112},
    { 904, 248, -128},
    { 1248, 336, -56},
    { 1264, 576, 32},
    { 984, 616, -56},
    { 1208, 240, -152},
    { 1048, 360, -88},
    { 1104, 416, 8},
    { 1192, 376, 64},
    { 1296, 296, 16},
    { 1168, 208, 48},
    { 1200, 32, 112},
    { 1264, -40, 40},
    { 1160, -8, -88},
    // 81 seconds
    { 976, 56, -112},
    { 760, 40, -88},
    { 992, 40, 0},
    { 832, 64, -104},
    { 736, 48, -80},
    { 1160, -40, 72},
    { 1160, 96, -16},
    { 1272, 176, -104},
    { 1264, 96, -64},
    { 1104, 144, -120},
    { 752, 136, -144},
    { 768, 112, -120},
    { 1008, 160, -32},
    { 1200, 208, -64},
    { 1152, 280, -152},
    { 952, 312, -152},
    { 1456, 424, -112},
    { 1160, 680, -40},
    { 1040, 320, -72},
    { 984, 208, -88},
    { 1008, 336, -64},
    { 1144, 344, 16},
    { 1224, 296, 72},
    { 1312, 216, 32},
    { 1088, 152, 0},
    // 82 seconds
    { 1056, 72, 88},
    { 1112, 32, 32},
    { 1096, 56, -24},
    { 944, 88, -80},
    { 768, 56, -80},
    { 1032, 16, 8},
    { 1056, 56, -112},
    { 952, 40, -96},
    { 1112, -16, 16},
    { 1080, 64, -56},
    { 1080, 144, -216},
    { 1112, 72, -136},
    { 1096, 72, -96},
    { 864, 104, -96},
    { 808, 160, -144},
    { 888, 176, -56},
    { 1016, 192, 8},
    { 1064, 240, -32},
    { 944, 272, -152},
    { 1120, 288, -128},
    { 1320, 440, -144},
    { 1096, 624, 32},
    { 1272, 432, -208},
    { 1000, 168, -152},
    { 1008, 224, -32},
    // 83 seconds
    { 1136, 288, -16},
    { 1288, 296, -32},
    { 1176, 184, -32},
    { 992, 80, 40},
    { 1040, 16, 72},
    { 1136, 32, 64},
    { 984, 72, 0},
    { 752, 120, -64},
    { 824, 104, -56},
    { 1104, 56, 40},
    { 1056, 32, 64},
    { 1320, -56, 104},
    { 1176, -40, 32},
    { 1096, 184, -320},
    { 952, 8, -176},
    { 960, -88, -88},
    { 848, -16, -144},
    { 800, 88, -184},
    { 896, 160, -136},
    { 1008, 176, -48},
    { 1080, 232, -24},
    { 1040, 272, -136},
    { 1272, 288, -80},
    { 1584, 472, -24},
    { 1032, 720, 64},
    // 84 seconds
    { 1192, 496, -112},
    { 1104, 376, -136},
    { 912, 312, -80},
    { 1056, 376, 0},
    { 1288, 368, 48},
    { 1264, 256, 32},
    { 1168, 112, 80},
    { 1208, 24, 104},
    { 1248, 40, 48},
    { 1192, 80, -16},
    { 1016, 88, -24},
    { 864, 40, -88},
    { 1000, -24, 0},
    { 816, -40, -96},
    { 912, -16, -136},
    { 1104, -80, 64},
    { 1208, 112, -96},
    { 1232, 152, -152},
    { 1264, 88, -88},
    { 1248, 120, -96},
    { 976, 144, -96},
    { 952, 168, -128},
    { 1080, 208, -16},
    { 1152, 248, -16},
    { 1088, 296, -128},
    // 85 seconds
    { 928, 312, -160},
    { 1248, 384, -56},
    { 1128, 624, 64},
    { 928, 472, -40},
    { 1104, 304, -96},
    { 1056, 384, -96},
    { 1240, 400, 24},
    { 1328, 336, 80},
    { 1496, 256, 80},
    { 1312, 168, 80},
    { 1272, 56, 128},
    { 1272, 0, 72},
    { 1184, 32, -8},
    { 1008, 64, -24},
    { 816, 48, -72},
    { 880, -16, 32},
    { 856, -8, -48},
    { 800, 8, -128},
    { 1048, -72, 16},
    { 1224, 24, 24},
    { 1288, 128, -136},
    { 1336, 128, -104},
    { 1368, 144, -128},
    { 1040, 168, -128},
    { 928, 136, -160},
    // 86 seconds
    { 1000, 192, -40},
    { 1104, 248, -8},
    { 1088, 296, -96},
    { 968, 296, -160},
    { 1200, 320, -56},
    { 1264, 488, 8},
    { 872, 504, 96},
    { 1096, 392, -40},
    { 1120, 432, -96},
    { 1136, 392, -8},
    { 1200, 352, 80},
    { 1400, 304, 80},
    { 1304, 208, 72},
    { 1232, 96, 144},
    { 1288, 24, 128},
    { 1264, 24, 24},
    { 1096, 72, -32},
    { 856, 48, -40},
    { 864, -32, -16},
    { 928, -72, 16},
    { 728, -72, -40},
    { 992, -144, 40},
    { 1376, -112, 72},
    { 1496, 144, -8},
    { 1472, 192, 8},
    // 87 seconds
    { 1384, 120, -184},
    { 1208, 176, -304},
    { 1048, 192, -216},
    { 1056, 192, 80},
    { 1064, 280, 128},
    { 1152, 328, -80},
    { 928, 352, -48},
    { 984, 344, 8},
    { 1176, 424, 152},
    { 880, 496, 120},
    { 1064, 360, 64},
    { 1128, 408, -8},
    { 1128, 408, 32},
    { 1272, 368, 72},
    { 1480, 336, 112},
    { 1488, 248, 96},
    { 1360, 96, 144},
    { 1360, -32, 96},
    { 1248, -32, 16},
    { 1096, 32, -40},
    { 864, 56, -48},
    { 768, -8, -24},
    { 952, -72, -8},
    { 680, -56, -88},
    { 1080, -80, 0},
    // 88 seconds
    { 1320, -32, 56},
    { 1376, 160, -48},
    { 1480, 160, -56},
    { 1512, 128, -72},
    { 1216, 200, -112},
    { 976, 176, -128},
    { 976, 208, -24},
    { 1056, 240, -8},
    { 1096, 304, -96},
    { 960, 312, -144},
    { 1176, 352, -24},
    { 1184, 592, 88},
    { 848, 544, 32},
    { 1168, 360, -24},
    { 1112, 456, -80},
    { 1224, 400, -8},
    { 1344, 368, 88},
    { 1536, 304, 120},
    { 1432, 192, 120},
    { 1328, 64, 160},
    { 1312, -16, 112},
    { 1216, 8, 16},
    { 1064, 64, -24},
    { 872, 48, -32},
    { 1016, -32, 16},
    // 89 seconds
    { 864, -80, 0},
    { 752, -64, -88},
    { 992, -96, 0},
    { 1176, -16, 56},
    { 1336, 136, -96},
    { 1336, 128, -104},
    { 1496, 136, -120},
    { 1240, 200, -96},
    { 1032, 152, -104},
    { 1048, 216, -48},
    { 1176, 264, -24},
    { 1144, 288, -104},
    { 1016, 296, -144},
    { 1328, 424, -48},
    { 1192, 768, 120},
    { 888, 488, -64},
    { 1064, 344, -24},
    { 1120, 440, -128},
    { 1192, 368, 0},
    { 1376, 360, 96},
    { 1552, 296, 96},
    { 1392, 192, 88},
    { 1312, 64, 144},
    { 1288, 8, 128},
    { 1200, 40, 32},
    // 90 seconds
    { 1040, 80, 0},
    { 856, 32, 16},
    { 1032, -16, 64},
    { 848, -8, -16},
    { 832, -48, -72},
    { 1144, -48, 32},
    { 1280, 48, -120},
    { 1352, 120, -216},
    { 1424, 56, -176},
    { 1328, 56, -168},
    { 1056, 96, -192},
    { 1000, 144, -224},
    { 1088, 208, -112},
    { 1088, 280, -24},
    { 1048, 304, -120},
    { 920, 272, -168},
    { 1216, 320, -64},
    { 1208, 480, 24},
    { 920, 504, 104},
    { 1224, 512, 16},
    { 1056, 432, -120},
    { 1168, 304, -16},
    { 1304, 336, 80},
    { 1496, 312, 88},
    { 1368, 216, 80},
    // 91 seconds
    { 1256, 80, 168},
    { 1272, 8, 120},
    { 1208, 8, -32},
    { 1064, 48, -56},
    { 848, 24, -80},
    { 856, -48, -40},
    { 920, -96, 0},
    { 728, -56, -88},
    { 1048, -64, -24},
    { 1264, 24, 40},
    { 1344, 184, -112},
    { 1392, 168, -128},
    { 1400, 80, -24},
    { 1168, 144, -88},
    { 928, 136, -112},
    { 944, 184, -48},
    { 1096, 232, -32},
    { 1112, 288, -104},
    { 952, 304, -152},
    { 1208, 320, -24},
    { 1264, 520, 80},
    { 984, 616, 72},
    { 1456, 544, 8},
    { 992, 416, -144},
    { 992, 296, -16},
    // 92 seconds
    { 1240, 384, 96},
    { 1536, 328, 88},
    { 1456, 168, 96},
    { 1288, -16, 152},
    { 1176, -40, 80},
    { 1080, -24, -16},
    { 1000, 40, -8},
    { 856, 64, 8},
    { 920, 32, 24},
    { 1056, 8, 56},
    { 816, -32, -16},
    { 1000, -72, -8},
    { 1312, 48, 16},
    { 1264, 176, -104},
    { 1296, 128, -120},
    { 1320, 40, -48},
    { 1200, 112, -40},
    { 1024, 160, -104},
    { 1040, 232, -32},
    { 1136, 272, 24},
    { 1160, 304, -56},
    { 1024, 328, -160},
    { 928, 336, -72},
    { 1224, 496, 0},
    { 904, 688, 80},
    // 93 seconds
    { 1192, 368, -48},
    { 1072, 304, -88},
    { 1144, 352, -16},
    { 1240, 368, 64},
    { 1552, 328, 72},
    { 1504, 232, 56},
    { 1360, 104, 152},
    { 1328, -24, 136},
    { 1224, -32, 24},
    { 1064, 40, -32},
    { 832, 56, -48},
    { 848, 8, 8},
    { 1008, -8, 0},
    { 784, -16, -64},
    { 1080, -88, 40},
    { 1224, -8, 24},
    { 1160, 120, -160},
    { 1192, 96, -120},
    { 1264, 64, -104},
    { 1168, 120, -88},
    { 1080, 136, -128},
    { 1152, 200, -16},
    { 1184, 256, 64},
    { 1232, 296, 8},
    { 1080, 312, -112},
    // 94 seconds
    { 1032, 296, -88},
    { 1272, 440, -16},
    { 856, 648, 216},
    { 1176, 568, -112},
    { 1104, 360, -80},
    { 1104, 328, -32},
    { 1240, 392, 80},
    { 1536, 352, 56},
    { 1416, 216, 48},
    { 1336, 112, 136},
    { 1384, 32, 144},
    { 1336, 24, 48},
    { 1144, 56, -8},
    { 856, 8, -40},
    { 944, -48, -16},
    { 976, -72, 8},
    { 760, -8, -104},
    { 1120, -56, 0},
    { 1176, 8, 0},
    { 1264, 128, -136},
    { 1336, 112, -104},
    { 1312, 96, -72},
    { 1072, 136, -80},
    { 936, 160, -160},
    { 984, 160, -56},
    // 95 seconds
    { 1080, 200, 24},
    { 1120, 264, -40},
    { 1008, 320, -160},
    { 1120, 336, -88},
    { 1360, 624, -16},
    { 912, 600, -24},
    { 1168, 264, -32},
    { 1144, 344, -128},
    { 1128, 376, -40},
    { 1192, 344, 40},
    { 1392, 296, 48},
    { 1400, 240, 32},
    { 1256, 144, 96},
    { 1232, 40, 136},
    { 1184, 24, 64},
    { 1088, 64, -16},
    { 928, 72, 0},
    { 792, 32, -32},
    { 1032, 16, 8},
    { 856, 16, -64},
    { 968, 16, -128},
    { 1160, -80, 64},
    { 1152, 80, -144},
    { 1168, 80, -144},
    { 1256, 72, -136},
    // 96 seconds
    { 1224, 120, -112},
    { 1032, 152, -104},
    { 1024, 176, -24},
    { 1144, 240, 96},
    { 1160, 288, 64},
    { 1128, 328, -56},
    { 920, 320, -80},
    { 1192, 384, 0},
    { 1192, 616, 232},
    { 864, 592, -56},
    { 1072, 248, 0},
    { 1168, 424, -104},
    { 1160, 456, -8},
    { 1224, 392, 88},
    { 1440, 320, 64},
    { 1360, 224, 72},
    { 1352, 88, 176},
    { 1336, -16, 128},
    { 1224, -8, 64},
    { 1112, 48, 56},
    { 912, 56, 72},
    { 1064, 48, 80},
    { 904, 48, 48},
    { 896, 8, 48},
    { 1040, -200, 184},
    // 97 seconds
    { 1168, 16, -32},
    { 1152, 192, -200},
    { 1168, 56, -128},
    { 1208, -16, -120},
    { 1024, 48, -184},
    { 960, 80, -232},
    { 1072, 144, -128},
    { 1256, 240, -24},
    { 1264, 352, -88},
    { 1056, 336, -168},
    { 1272, 376, -144},
    { 1080, 544, -96},
    { 984, 480, 8},
    { 1232, 512, -112},
    { 1128, 360, -96},
    { 1192, 296, -8},
    { 1344, 288, 48},
    { 1448, 240, 40},
    { 1328, 144, 72},
    { 1280, 48, 120},
    { 1264, 16, 80},
    { 1152, 48, 8},
    { 960, 80, -16},
    { 752, 32, -72},
    { 936, -64, 24},
    // 98 seconds
    { 848, -96, -32},
    { 832, -56, -128},
    { 1192, -104, 64},
    { 1360, 64, -40},
    { 1344, 152, -192},
    { 1280, 64, -120},
    { 1288, 80, -128},
    { 1048, 136, -104},
    { 1080, 168, -104},
    { 1152, 240, 0},
    { 1176, 304, -8},
    { 1080, 336, -120},
    { 904, 336, -120},
    { 1256, 456, -64},
    { 1080, 592, 64},
    { 952, 432, -16},
    { 1296, 432, -80},
    { 1096, 392, -112},
    { 1288, 336, 8},
    { 1432, 288, 48},
    { 1552, 248, 32},
    { 1352, 256, 40},
    { 1568, 640, 16},
    { 1968, 664, 232},
    { 1792, 448, 72},
    // 99 seconds
    { 1344, 200, -72},
    { 728, 176, -160},
    { 552, 56, -192},
    { 400, -104, -488},
    { 192, -184, -544},
    { 176, -328, -760},
    { 160, 0, -1016},
    { 304, 40, -1048},
    { 312, -96, -976},
    { 256, -48, -952},
    { 96, -40, -856},
    { -120, -72, -776},
    { -168, -144, -728},
    { -136, -40, -792},
    { -136, 24, -904},
    { -136, -40, -1024},
    { -224, -64, -1112},
    { -144, 104, -1208},
    { -192, 176, -1248},
    { -144, 400, -1256},
    { -64, 416, -1192},
    { -128, 192, -1024},
    { -184, 232, -896},
    { -120, 344, -920},
    { -88, 216, -864},
    // 100 seconds
    { -160, 32, -760},
    { -224, 64, -768},
    { -272, 128, -856},
    { -264, 64, -936},
    { -152, -64, -896},
    { -168, -128, -760},
    { 40, -152, -640},
    { 392, -120, -448},
    { 1008, 360, -136},
    { 1472, 616, 0},
    { 2032, 608, -360},
    { 1816, 456, -512},
    { 1632, 192, -104},
    { 1416, 192, -8},
    { 1168, 344, 40},
    { 1088, 352, 144},
    { 1120, 200, 224},
    { 1224, 168, 96},
    { 1096, 288, -112},
    { 840, 328, -216},
    { 1384, 456, -96},
    { 1160, 768, 24},
    { 984, 808, -200},
    { 1080, 200, -128},
    { 968, 208, -80},
    // 101 seconds
    { 1160, 336, -40},
    { 1328, 360, -8},
    { 1384, 304, -56},
    { 1256, 176, 0},
    { 1288, 96, 120},
    { 1288, 48, 80},
    { 1176, 24, -16},
    { 976, 24, -72},
    { 928, -16, -8},
    { 1184, -8, 88},
    { 904, 48, -32},
    { 1016, 16, -56},
    { 1000, -64, 56},
    { 1192, 120, -152},
    { 1184, 168, -224},
    { 1216, 80, -176},
    { 1136, 56, -168},
    { 912, 40, -104},
    { 896, 176, -168},
    { 992, 160, -8},
    { 1104, 240, 24},
    { 1096, 280, -104},
    { 944, 304, -184},
    { 1240, 296, -32},
    { 1120, 424, 8},
    // 102 seconds
    { 1320, 528, 72},
    { 1192, 504, -256},
    { 960, 248, -80},
    { 984, 288, 0},
    { 1288, 320, 40},
    { 1408, 248, 24},
    { 1200, 96, 64},
    { 1096, 0, 112},
    { 1016, -8, 24},
    { 952, 32, -40},
    { 872, 88, -40},
    { 832, 56, -8},
    { 1208, 32, 40},
    { 1048, 64, 8},
    { 1224, 48, 16},
    { 1248, 40, 56},
    { 1296, 136, -144},
    { 1184, 88, -128},
    { 1176, -24, -24},
    { 928, 64, -152},
    { 696, 80, -80},
    { 744, 240, -192},
    { 832, 120, -40},
    { 952, 168, 0},
    { 1040, 248, -80},
    // 103 seconds
    { 1024, 304, -136},
    { 1352, 328, -16},
    { 1144, 472, 112},
    { 1024, 488, -80},
    { 1104, 264, -144},
    { 1088, 384, -48},
    { 1104, 392, 48},
    { 1264, 312, 64},
    { 1288, 208, -8},
    { 1088, 120, 48},
    { 1080, 32, 96},
    { 1080, 16, 16},
    { 1024, 32, -72},
    { 920, 80, -56},
    { 992, 40, 16},
    { 1336, 32, 32},
    { 1424, -16, 256},
    { 1088, -64, 168},
    { 1232, 112, -192},
    { 1048, 112, -80},
    { 1080, -16, 48},
    { 1016, 8, -152},
    { 840, -32, -296},
    { 768, 56, -224},
    { 792, 200, -152},
    // 104 seconds
    { 896, 192, -48},
    { 1024, 272, -128},
    { 1112, 256, -64},
    { 1480, 304, 24},
    { 1192, 360, 104},
    { 1272, 424, 16},
    { 1136, 608, -88},
    { 1120, 400, -48},
    { 1160, 272, 88},
    { 1328, 280, 88},
    { 1176, 216, 8},
    { 1032, 88, 56},
    { 1056, 16, 56},
    { 1048, 16, -8},
    { 1016, 72, -32},
    { 920, 64, 0},
    { 1040, 8, 8},
    { 1320, 32, 24},
    { 872, -40, 48},
    { 1272, -152, 40},
    { 1232, -24, -24},
    { 1336, 192, -216},
    { 1288, 120, -152},
    { 1216, 8, -144},
    { 920, 16, -120},
    // 105 seconds
    { 904, 88, -136},
    { 928, 176, -16},
    { 984, 256, 80},
    { 984, 280, -8},
    { 912, 304, -56},
    { 1248, 368, 32},
    { 1152, 512, 240},
    { 1464, 792, 72},
    { 1104, 312, -16},
    { 944, 232, -40},
    { 1024, 352, 24},
    { 1400, 408, 40},
    { 1216, 232, 48},
    { 1192, 64, 88},
    { 1192, -8, 80},
    { 1160, 0, -8},
    { 1104, 56, -8},
    { 992, 56, 16},
    { 1128, 0, 0},
    { 1104, -104, 48},
    { 816, -208, 104},
    { 1320, -200, 160},
    { 1368, 168, -80},
    { 1272, 224, -240},
    { 1168, 64, -176},
    // 106 seconds
    { 1040, 32, -224},
    { 768, -16, -144},
    { 856, 16, -56},
    { 1112, 168, -48},
    { 1184, 312, -16},
    { 1040, 368, -88},
    { 1088, 336, -48},
    { 1328, 440, 16},
    { 1016, 560, 88},
    { 1336, 624, 88},
    { 1192, 592, -40},
    { 1104, 288, -24},
    { 1248, 336, 32},
    { 1528, 376, 32},
    { 1424, 256, 104},
    { 1344, 24, 192},
    { 1264, -56, 104},
    { 1096, -24, -8},
    { 992, 64, -48},
    { 824, 56, 8},
    { 936, -24, 40},
    { 952, -88, 48},
    { 904, -144, 72},
    { 1248, -96, 128},
    { 1488, 200, -184},
    // 107 seconds
    { 1488, 216, -160},
    { 1424, 24, -16},
    { 1200, 8, -216},
    { 960, 64, -224},
    { 976, 216, -112},
    { 1072, 256, 80},
    { 1152, 296, 40},
    { 1192, 320, -104},
    { 1152, 264, -56},
    { 1320, 312, 64},
    { 968, 368, 312},
    { 1136, 504, 40},
    { 960, 696, 0},
    { 1024, 528, 8},
    { 1096, 344, 128},
    { 1536, 408, 152},
    { 1552, 304, 128},
    { 1512, 120, 168},
    { 1488, -24, 176},
    { 1336, -16, 80},
    { 1184, 64, -16},
    { 976, 48, -24},
    { 912, -24, 8},
    { 1072, -64, 32},
    { 680, -152, -16},
    // 108 seconds
    { 1008, -160, -48},
    { 1320, -120, 72},
    { 1408, 128, -112},
    { 1504, 128, -48},
    { 1512, 104, -16},
    { 1224, 216, -112},
    { 952, 184, -96},
    { 1000, 224, -48},
    { 1080, 240, -8},
    { 1080, 272, -40},
    { 944, 320, -72},
    { 1184, 320, 32},
    { 1184, 448, 192},
    { 936, 568, 40},
    { 1192, 456, -48},
    { 1120, 512, -56},
    { 1112, 392, 32},
    { 1320, 376, 152},
    { 1536, 312, 72},
    { 1376, 192, 80},
    { 1256, 8, 144},
    { 1160, -48, 88},
    { 1096, 0, -64},
    { 968, 72, -88},
    { 1008, 16, -8},
    // 109 seconds
    { 1104, -24, -16},
    { 816, -120, 8},
    { 1128, -152, 48},
    { 1280, -8, 56},
    { 1352, 200, -168},
    { 1312, 128, -104},
    { 1240, 32, -80},
    { 936, 88, -144},
    { 768, 80, -112},
    { 960, 152, -8},
    { 1176, 224, 72},
    { 1264, 336, 0},
    { 1128, 376, -72},
    { 1408, 432, -48},
    { 1200, 752, 144},
    { 1064, 464, -32},
    { 1184, 536, -72},
    { 1024, 520, -112},
    { 1168, 384, -16},
    { 1440, 392, 56},
    { 1576, 296, 40},
    { 1424, 72, 112},
    { 1344, -80, 136},
    { 1280, -48, 40},
    { 1184, 64, -32},
    // 110 seconds
    { 1008, 112, -32},
    { 888, 40, -24},
    { 992, -72, 32},
    { 664, -152, -120},
    { 992, -144, -56},
    { 1248, -40, 72},
    { 1280, 136, -112},
    { 1376, 128, -56},
    { 1480, 88, -24},
    { 1184, 216, -80},
    { 944, 176, -56},
    { 1016, 224, -40},
    { 1280, 256, -120},
    { 1224, 352, -320},
    { 1160, 632, -296},
    { 1272, 624, -184},
    { 1160, 472, 24},
    { 1016, 408, 72},
    { 1448, 456, 16},
    { 1144, 416, -48},
    { 1136, 400, 16},
    { 1344, 392, 120},
    { 1528, 328, 136},
    { 1288, 192, 168},
    { 1224, 64, 184},
    // 111 seconds
    { 1256, -8, 104},
    { 1160, -24, 16},
    { 1032, 24, -16},
    { 1024, 0, -80},
    { 1040, -192, 0},
    { 688, -352, 48},
    { 872, -184, -24},
    { 1256, 16, -24},
    { 1296, 192, -104},
    { 1456, 168, -144},
    { 1608, 152, -176},
    { 1336, 152, -56},
    { 992, 64, -64},
    { 1040, 104, -112},
    { 1176, 224, -72},
    { 1176, 288, -80},
    { 984, 320, -128},
    { 1000, 360, -56},
    { 1280, 528, 32},
    { 1112, 672, 72},
    { 1496, 480, -128},
    { 888, 296, -104},
    { 1024, 304, 32},
    { 1280, 360, 32},
    { 1608, 296, 40},
    // 112 seconds
    { 1424, 152, 96},
    { 1248, 16, 96},
    { 1216, -128, -192},
    { 1136, -208, -184},
    { 880, -56, 24},
    { 664, 96, -72},
    { 712, 160, -160},
    { 992, 200, -240},
    { 800, 128, -264},
    { 1240, -72, -104},
    { 1264, -96, -120},
    { 1264, -8, -24},
    { 1392, 88, -64},
    { 1296, 248, -184},
    { 888, 296, -152},
    { 744, 248, -24},
    { 872, 248, 40},
    { 1160, 216, 40},
    { 1240, 264, 56},
    { 1080, 336, 72},
    { 1360, 496, 160},
    { 1080, 872, 120},
    { 1032, 384, 120},
    { 1144, 384, 16},
    { 1040, 432, -24},
    // 113 seconds
    { 1088, 584, 88},
    { 1328, 528, 136},
    { 1656, 584, 128},
    { 1616, 464, 328},
    { 1784, 272, 344},
    { 1816, 224, 88},
    { 1568, 256, -32},
    { 1176, 232, -200},
    { 744, 208, -288},
    { 624, 112, -480},
    { 512, -56, -656},
    { 312, 0, -632},
    { 232, -144, -696},
    { 32, -8, -912},
    { 64, 72, -1040},
    { 120, -24, -968},
    { 112, -32, -888},
    { 88, -128, -800},
    { -56, -104, -792},
    { -112, -40, -864},
    { -128, -88, -904},
    { -104, -96, -896},
    { -88, -72, -928},
    { -168, -104, -960},
    { -232, -64, -1008},
    // 114 seconds
    { -232, 0, -1072},
    { -128, 8, -1216},
    { -168, -64, -1128},
    { -232, -88, -1128},
    { -224, 72, -1184},
    { -144, 104, -1056},
    { -184, 184, -1000},
    { -144, 232, -1000},
    { -136, 280, -944},
    { -96, 312, -992},
    { 0, 240, -960},
    { 8, 200, -1024},
    { 0, 120, -1136},
    { -8, 56, -1080},
    { -8, 144, -1024},
    { 88, 56, -1096},
    { -16, 56, -992},
    { 16, 40, -992},
    { 32, 96, -1064},
    { 16, 184, -944},
    { 56, 384, -888},
    { -112, 392, -920},
    { 0, 416, -904},
    { -40, 520, -920},
    { -104, 352, -944},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:15:30 local
AccelRawData *activity_sample_walk_200_pbl_25667_15(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25667_15
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 150
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -224, 600, 576},
    { -240, 696, 584},
    { -232, 776, 576},
    { -216, 920, 600},
    { -256, 1008, 528},
    { -216, 984, 280},
    { -264, 976, 120},
    { -280, 944, -72},
    { -288, 720, -312},
    { -248, 488, -504},
    { -176, 384, -688},
    { -72, 400, -880},
    { -80, 328, -960},
    { -64, 192, -1064},
    { -48, 168, -1064},
    { -56, 112, -1056},
    { -32, 40, -1048},
    { -112, -48, -992},
    { -32, 40, -1040},
    { -16, 16, -1048},
    { 104, -96, -1088},
    { -256, -32, -976},
    { -112, -16, -1048},
    { -80, 48, -1008},
    { -40, 24, -1048},
    // 1 seconds
    { -136, 0, -1008},
    { -136, 0, -1032},
    { -160, -16, -1040},
    { -152, 0, -1056},
    { -168, -24, -1056},
    { -72, -16, -1072},
    { -56, -16, -1048},
    { -96, 0, -1048},
    { -96, -8, -1032},
    { -88, 0, -1024},
    { -64, 0, -1016},
    { -64, -8, -1008},
    { -80, -8, -1000},
    { -144, 16, -1000},
    { -40, -8, -1016},
    { -32, -24, -1024},
    { -80, 0, -1024},
    { -40, 16, -1056},
    { -24, -24, -1024},
    { 64, -24, -1072},
    { 0, 0, -1032},
    { 0, -40, -1016},
    { 8, -48, -1000},
    { 56, 240, -880},
    { 0, 480, -824},
    // 2 seconds
    { -80, 616, -680},
    { -144, 856, -488},
    { -200, 968, -360},
    { -208, 960, -184},
    { -224, 968, 16},
    { -200, 968, 160},
    { -184, 848, 224},
    { -232, 808, 176},
    { -248, 808, 328},
    { -224, 792, 424},
    { -240, 936, 336},
    { -288, 1144, 336},
    { -208, 1056, 312},
    { -16, 776, 464},
    { -80, 1136, 344},
    { -112, 992, 240},
    { -216, 960, 192},
    { -216, 840, 160},
    { -240, 800, 192},
    { -208, 752, 136},
    { -168, 688, 56},
    { -184, 712, -32},
    { -248, 736, -144},
    { -224, 736, -56},
    { -240, 888, 40},
    // 3 seconds
    { -216, 1000, -232},
    { -232, 888, -504},
    { -256, 1024, -824},
    { -192, 848, -1040},
    { -104, 704, -1024},
    { -104, 288, -848},
    { 144, -264, -600},
    { 584, -64, -312},
    { 1024, 256, -112},
    { 1376, 368, -40},
    { 1552, 328, -8},
    { 1568, 304, 88},
    { 1440, 296, 232},
    { 1368, 344, 168},
    { 1352, 384, 24},
    { 1320, 344, 168},
    { 1320, 264, 248},
    { 1248, 184, 184},
    { 1200, 200, 88},
    { 1312, 384, -96},
    { 1416, 592, -8},
    { 1224, 616, 152},
    { 1088, 856, 8},
    { 800, 792, 72},
    { 728, 536, 32},
    // 4 seconds
    { 816, 600, 48},
    { 1128, 584, 48},
    { 1368, 440, 56},
    { 1536, 312, -16},
    { 1664, 272, -8},
    { 1680, 280, -56},
    { 1584, 160, -104},
    { 1432, 160, -184},
    { 1192, 136, -200},
    { 1136, 176, -304},
    { 1016, 136, -456},
    { 640, -16, -720},
    { 720, -200, -608},
    { 808, -184, -240},
    { 856, -64, -360},
    { 984, 48, -576},
    { 1112, 144, -568},
    { 1136, 224, -496},
    { 1064, 368, -496},
    { 1144, 368, -424},
    { 1272, 416, -384},
    { 1392, 488, -336},
    { 1272, 480, -280},
    { 1248, 536, -200},
    { 1384, 696, 192},
    // 5 seconds
    { 1024, 880, 208},
    { 880, 440, 264},
    { 968, 736, 352},
    { 880, 672, 296},
    { 1008, 536, 248},
    { 1272, 432, 176},
    { 1592, 368, 112},
    { 1624, 288, 144},
    { 1824, 96, 168},
    { 1792, -8, 88},
    { 1584, 56, -8},
    { 1200, 48, -64},
    { 840, 40, -80},
    { 928, 16, -56},
    { 824, -72, -136},
    { 696, -144, -216},
    { 1024, -136, -24},
    { 1128, 40, -152},
    { 1168, 104, -224},
    { 1312, 88, -184},
    { 1464, 136, -176},
    { 1320, 168, -160},
    { 1272, 216, -184},
    { 1328, 296, -80},
    { 1280, 304, 56},
    // 6 seconds
    { 1232, 248, 0},
    { 1040, 272, 24},
    { 1264, 336, 128},
    { 1216, 496, 464},
    { 832, 728, 264},
    { 1128, 520, 248},
    { 1016, 504, 64},
    { 976, 400, 48},
    { 1168, 488, 160},
    { 1560, 496, 176},
    { 1488, 328, 144},
    { 1520, 160, 192},
    { 1608, 16, 144},
    { 1440, -8, 56},
    { 1248, 64, 24},
    { 952, 56, 16},
    { 936, 40, 24},
    { 1032, 88, -8},
    { 680, -32, 32},
    { 832, -40, -40},
    { 1128, 0, 0},
    { 1072, 144, -96},
    { 1152, 168, -152},
    { 1264, 112, -184},
    { 1296, 160, -128},
    // 7 seconds
    { 1152, 168, -112},
    { 1192, 208, -208},
    { 1224, 232, -136},
    { 1224, 280, -32},
    { 1016, 328, -48},
    { 760, 336, -48},
    { 1088, 384, 0},
    { 1072, 480, 184},
    { 1128, 472, 32},
    { 1288, 440, -48},
    { 1032, 456, -48},
    { 1024, 408, 16},
    { 1272, 416, -8},
    { 1480, 304, 16},
    { 1344, 96, 112},
    { 1280, 0, 72},
    { 1288, -8, -16},
    { 1248, 56, 16},
    { 1144, 88, 56},
    { 1048, 64, 136},
    { 1232, -160, 208},
    { 640, -320, 168},
    { 880, -144, -152},
    { 1192, -104, 16},
    { 1288, 136, -224},
    // 8 seconds
    { 1360, 112, -216},
    { 1520, 56, -320},
    { 1288, 64, -192},
    { 1072, -40, -240},
    { 1104, 392, -168},
    { 1088, 296, 8},
    { 1120, 288, 40},
    { 1064, 320, 40},
    { 816, 336, 88},
    { 1032, 336, 112},
    { 1024, 424, 296},
    { 840, 512, 168},
    { 1192, 336, 88},
    { 1192, 456, 0},
    { 1096, 496, 8},
    { 1192, 504, 8},
    { 1688, 472, -32},
    { 1600, 248, 152},
    { 1584, -16, 200},
    { 1552, -144, 40},
    { 1336, -112, -56},
    { 1056, -16, -64},
    { 792, 32, -72},
    { 840, 32, 24},
    { 760, -24, -32},
    // 9 seconds
    { 464, -32, -80},
    { 752, -16, 0},
    { 872, 112, -40},
    { 1072, 192, -104},
    { 1552, 312, -312},
    { 1704, 320, -120},
    { 1120, 264, 8},
    { 856, -24, -136},
    { 1104, -176, -280},
    { 1264, 40, -352},
    { 1264, 408, -104},
    { 1040, 552, -48},
    { 1024, 584, 88},
    { 1280, 648, 56},
    { 920, 408, 0},
    { 1176, 288, 8},
    { 1232, 368, -48},
    { 1032, 360, 88},
    { 1144, 360, 136},
    { 1264, 312, 120},
    { 1272, 264, 56},
    { 1128, 136, 56},
    { 1200, 16, 40},
    { 1256, -48, -72},
    { 1168, 8, -40},
    // 10 seconds
    { 872, 40, -80},
    { 616, 32, -136},
    { 872, -64, -144},
    { 784, -136, -192},
    { 752, -128, -144},
    { 1040, -136, 8},
    { 1616, 104, -176},
    { 1496, 200, -240},
    { 1520, 120, -280},
    { 1328, 128, -120},
    { 976, 200, -48},
    { 880, 200, 64},
    { 1008, 216, 8},
    { 1080, 248, -16},
    { 880, 312, 0},
    { 864, 344, 88},
    { 1312, 496, 240},
    { 840, 1008, 232},
    { 1064, 288, -8},
    { 1248, 272, 16},
    { 1320, 504, 24},
    { 1408, 496, 128},
    { 1624, 352, 136},
    { 1400, 248, 48},
    { 1328, 176, 96},
    // 11 seconds
    { 1376, 0, 112},
    { 1216, -88, -24},
    { 960, 16, -112},
    { 928, -24, -120},
    { 1080, -48, -8},
    { 776, -96, 8},
    { 824, -104, 0},
    { 1368, 16, 0},
    { 1384, 208, -136},
    { 1344, 168, -64},
    { 1424, 48, -48},
    { 1232, 120, -40},
    { 992, 120, -56},
    { 1000, 200, 0},
    { 1072, 248, 72},
    { 1144, 288, 24},
    { 1200, 344, -16},
    { 1040, 448, 0},
    { 1200, 888, 88},
    { 1072, 784, 48},
    { 544, 288, 112},
    { 1336, 528, 104},
    { 1648, 584, 72},
    { 1600, 408, 136},
    { 1976, 344, 240},
    // 12 seconds
    { 2008, 344, 112},
    { 1696, 216, 96},
    { 1544, 88, 136},
    { 1456, 64, 96},
    { 1264, 64, -16},
    { 1024, 24, -48},
    { 1064, -96, 24},
    { 880, -160, 96},
    { 808, -112, 96},
    { 1072, -48, 96},
    { 1288, 200, -272},
    { 1336, 136, -120},
    { 1632, 32, -32},
    { 1488, 64, -200},
    { 1136, 144, -152},
    { 1048, 280, -288},
    { 1072, 352, -192},
    { 1176, 312, -96},
    { 1416, 216, -24},
    { 1504, 280, 56},
    { 1640, 456, 176},
    { 1192, 472, 248},
    { 1136, 432, 72},
    { 808, 448, 8},
    { 776, 472, 40},
    // 13 seconds
    { 912, 432, 80},
    { 1208, 392, 128},
    { 1328, 304, 128},
    { 1248, 152, 160},
    { 1216, 16, 128},
    { 1184, -16, 64},
    { 1056, 56, 24},
    { 952, 104, 0},
    { 968, 96, 24},
    { 1224, 112, 56},
    { 1168, 96, 40},
    { 1120, 56, 40},
    { 1264, 24, -216},
    { 1296, -64, -152},
    { 1112, -72, -96},
    { 992, -72, -136},
    { 936, 8, -248},
    { 856, 104, -232},
    { 784, 96, -144},
    { 872, 184, -144},
    { 928, 240, -120},
    { 1032, 320, -80},
    { 1096, 368, -144},
    { 1128, 280, -96},
    { 1520, 328, -64},
    // 14 seconds
    { 1176, 360, -32},
    { 1152, 336, -128},
    { 1224, 456, -256},
    { 960, 600, -168},
    { 944, 440, 16},
    { 1256, 224, 40},
    { 1080, 168, -112},
    { 1088, 80, -16},
    { 1184, 40, 64},
    { 1264, 88, 112},
    { 1368, 168, 96},
    { 1320, 152, 48},
    { 1232, 64, 24},
    { 1208, -40, -192},
    { 1096, -280, 0},
    { 880, -312, -24},
    { 976, -328, -216},
    { 944, -352, -128},
    { 1024, -184, -264},
    { 1128, -144, -160},
    { 1128, -96, -96},
    { 1120, 16, -216},
    { 1080, 64, -96},
    { 1216, 144, -80},
    { 1464, 272, -128},
    // 15 seconds
    { 1488, 376, -24},
    { 1328, 520, 184},
    { 1168, 552, -144},
    { 1296, 200, 16},
    { 976, 368, 176},
    { 1072, 624, 200},
    { 912, 696, 136},
    { 1128, 416, 64},
    { 1392, 368, 88},
    { 1536, 456, 160},
    { 1464, 488, 32},
    { 1552, 488, 40},
    { 1800, 304, 64},
    { 1752, 88, -192},
    { 1440, -136, -168},
    { 848, -728, 80},
    { 408, -752, 56},
    { 504, -272, -184},
    { 496, -72, -328},
    { 688, -72, -120},
    { 1368, -184, 216},
    { 2256, 88, 352},
    { 2416, 512, 152},
    { 1888, 560, -136},
    { 1496, 488, -352},
    // 16 seconds
    { 1208, 288, 80},
    { 1224, 208, 216},
    { 1144, 200, 24},
    { 848, 240, -256},
    { 904, 488, -272},
    { 760, 1224, 176},
    { 776, 648, -56},
    { 824, 600, 112},
    { 1152, 560, 128},
    { 1944, 608, 144},
    { 1816, 424, 104},
    { 1728, 424, 88},
    { 1896, 408, 192},
    { 1760, 344, 168},
    { 1664, 208, 240},
    { 1584, 80, 280},
    { 1480, -8, 184},
    { 1272, 16, 88},
    { 1032, 48, 32},
    { 856, 24, 56},
    { 768, 40, 88},
    { 584, -128, -136},
    { 488, -368, -264},
    { 1056, -328, 56},
    { 1464, 56, -184},
    // 17 seconds
    { 1392, 72, -192},
    { 1640, -72, -232},
    { 1864, 56, -240},
    { 1792, 216, -208},
    { 1784, 272, -408},
    { 1512, 488, -152},
    { 1440, 320, -296},
    { 1032, 240, -152},
    { 936, 536, -120},
    { 872, 816, -88},
    { 704, 608, 32},
    { 1544, 632, -112},
    { 1472, 360, 40},
    { 1520, 264, 64},
    { 1880, 304, 56},
    { 1944, 400, -8},
    { 1760, 208, 80},
    { 1512, 32, 168},
    { 1272, -24, 40},
    { 1032, -64, -40},
    { 808, -72, -64},
    { 640, -224, 56},
    { 816, -168, 88},
    { 712, -104, 72},
    { 1024, -80, 80},
    // 18 seconds
    { 1544, 48, 120},
    { 1792, 344, -200},
    { 2152, 424, -240},
    { 1896, 184, -40},
    { 1104, 80, -104},
    { 1000, -152, -128},
    { 1224, 104, -192},
    { 1280, 216, 32},
    { 1256, 352, 112},
    { 1248, 512, 144},
    { 1240, 552, 224},
    { 952, 576, 280},
    { 1088, 640, -24},
    { 968, 528, -48},
    { 1184, 304, 24},
    { 1440, 352, 272},
    { 2032, 480, 128},
    { 1992, 256, 80},
    { 1632, 16, 240},
    { 1240, -24, 160},
    { 928, -40, 24},
    { 816, 40, -80},
    { 792, 56, -104},
    { 800, 40, -8},
    { 1024, 16, 96},
    // 19 seconds
    { 928, 16, 72},
    { 1040, 0, -56},
    { 1368, 112, -104},
    { 1424, 280, -200},
    { 1624, 264, -264},
    { 1624, 16, 64},
    { 1208, 88, -40},
    { 832, 48, -136},
    { 792, 120, -232},
    { 928, 208, -160},
    { 1024, 208, -8},
    { 1120, 248, -40},
    { 1016, 304, -80},
    { 1232, 328, -56},
    { 1392, 416, -104},
    { 1160, 336, -24},
    { 1072, 336, -56},
    { 792, 544, -136},
    { 752, 512, -96},
    { 928, 352, 88},
    { 1320, 256, 168},
    { 1448, 136, 96},
    { 1296, 88, 16},
    { 1152, 48, 8},
    { 1096, 56, -40},
    // 20 seconds
    { 1008, 96, -96},
    { 944, 104, -136},
    { 968, 40, -72},
    { 1240, 8, -40},
    { 1168, -232, -72},
    { 1056, -432, 24},
    { 1376, 56, -168},
    { 1488, 216, -136},
    { 1280, 168, -160},
    { 1160, -40, -144},
    { 1080, 16, -104},
    { 856, 88, -72},
    { 840, 160, -8},
    { 888, 232, 88},
    { 992, 256, 72},
    { 1064, 296, -24},
    { 1080, 280, -8},
    { 1376, 296, 128},
    { 1160, 464, 392},
    { 1496, 984, -32},
    { 968, 408, -8},
    { 768, 200, 0},
    { 832, 360, 56},
    { 1216, 480, 72},
    { 1480, 328, -112},
    // 21 seconds
    { 1472, 184, -32},
    { 1424, 8, 184},
    { 1424, -8, 72},
    { 1112, -144, 0},
    { 872, -48, -80},
    { 800, -16, -48},
    { 1176, 48, 24},
    { 920, 40, 16},
    { 1136, 0, 8},
    { 1288, 40, -40},
    { 1328, 256, -336},
    { 1264, 152, -168},
    { 1232, -32, -16},
    { 944, -8, -40},
    { 856, 96, -104},
    { 920, 208, -24},
    { 992, 264, 112},
    { 952, 320, 16},
    { 960, 320, -160},
    { 1304, 352, -104},
    { 1576, 552, -16},
    { 896, 688, 48},
    { 1120, 376, 0},
    { 1088, 528, -72},
    { 1136, 392, -64},
    // 22 seconds
    { 1360, 336, 56},
    { 1640, 344, 120},
    { 1632, 272, 72},
    { 1440, 160, 80},
    { 1368, 64, 128},
    { 1240, 64, 0},
    { 1040, 104, -136},
    { 880, 88, -144},
    { 808, -88, -48},
    { 840, -200, 0},
    { 720, -112, -112},
    { 1192, 16, -152},
    { 1272, 16, 16},
    { 1448, 120, -40},
    { 1448, 160, -96},
    { 1504, 168, -128},
    { 1312, 224, -88},
    { 1128, 192, 8},
    { 1120, 216, 136},
    { 1264, 264, 56},
    { 1296, 304, 24},
    { 1120, 312, 72},
    { 1304, 456, 272},
    { 1232, 1144, 328},
    { 736, 384, 88},
    // 23 seconds
    { 968, 328, 168},
    { 1168, 536, 32},
    { 1280, 472, 64},
    { 1432, 400, 184},
    { 1632, 296, 176},
    { 1464, 256, 96},
    { 1360, 160, 168},
    { 1408, 64, 168},
    { 1368, 24, 72},
    { 1168, 24, 40},
    { 904, 24, -8},
    { 840, -32, -8},
    { 920, -64, 88},
    { 720, -32, 24},
    { 1184, 24, -88},
    { 1312, 96, -80},
    { 1472, 160, -136},
    { 1472, 104, -56},
    { 1416, 64, -48},
    { 1136, 160, -128},
    { 936, 224, -184},
    { 920, 232, -48},
    { 936, 232, 40},
    { 1088, 240, 0},
    { 1184, 320, -88},
    // 24 seconds
    { 1320, 368, 40},
    { 1552, 496, 216},
    { 1024, 672, 144},
    { 1016, 464, -16},
    { 864, 392, -8},
    { 1000, 432, 8},
    { 1200, 408, 128},
    { 1576, 336, 224},
    { 1632, 176, 168},
    { 1424, 72, 128},
    { 1296, 24, 128},
    { 1184, 40, 32},
    { 976, 80, 0},
    { 808, 88, -16},
    { 664, 64, -8},
    { 704, 48, -56},
    { 960, 56, -168},
    { 864, 184, -184},
    { 1064, -8, -112},
    { 1384, -64, -48},
    { 1440, 0, -120},
    { 1328, 48, -144},
    { 1216, 72, -168},
    { 1080, 96, -224},
    { 928, 112, -248},
    // 25 seconds
    { 880, 208, -216},
    { 856, 248, -152},
    { 936, 304, -152},
    { 984, 312, -80},
    { 904, 280, -104},
    { 1064, 256, -16},
    { 1296, 464, -64},
    { 928, 608, -48},
    { 1248, 440, -72},
    { 1344, 376, -88},
    { 1280, 336, -104},
    { 1296, 280, -16},
    { 1416, 256, 72},
    { 1344, 240, 152},
    { 1176, 64, 200},
    { 1048, -72, 128},
    { 1000, -48, -120},
    { 952, 72, 32},
    { 816, 128, 88},
    { 856, 32, 112},
    { 992, 0, 0},
    { 784, -160, 160},
    { 1136, -248, 256},
    { 1544, 96, 48},
    { 1400, 160, -224},
    // 26 seconds
    { 1264, -56, -232},
    { 1176, -80, -280},
    { 896, -16, -264},
    { 840, 8, -240},
    { 1000, 104, -192},
    { 1064, 120, -152},
    { 1176, 96, -288},
    { 1024, 64, -288},
    { 1240, 320, -432},
    { 1112, 400, -576},
    { 1184, 112, -400},
    { 1472, 232, -512},
    { 1272, 144, -320},
    { 1400, 80, -232},
    { 1640, 168, -184},
    { 1536, 200, 40},
    { 1296, 208, 56},
    { 1168, 352, 64},
    { 1080, 384, 184},
    { 992, 288, 232},
    { 704, 288, 192},
    { 576, 496, 272},
    { 624, 480, 368},
    { 328, 536, 304},
    { 256, 592, 480},
    // 27 seconds
    { 168, 600, 808},
    { 192, 688, 928},
    { 280, 888, 704},
    { 248, 752, 560},
    { 192, 672, 328},
    { 104, 624, 184},
    { 56, 792, 176},
    { -56, 832, 192},
    { -64, 416, 96},
    { 48, 1088, 328},
    { -312, 1120, 800},
    { -360, 1144, 1208},
    { -152, 856, 1296},
    { -128, 536, 1368},
    { 48, 392, 1384},
    { 128, 312, 1112},
    { 88, 48, 1016},
    { 16, 80, 928},
    { 32, -32, 776},
    { -24, 72, 584},
    { -168, 48, 584},
    { -304, 152, 568},
    { -408, 168, 656},
    { -424, 264, 744},
    { -488, 288, 752},
    // 28 seconds
    { -560, 272, 944},
    { -456, 296, 920},
    { -472, 272, 1032},
    { -424, 192, 1152},
    { -152, 240, 1168},
    { -128, 208, 936},
    { -240, 192, 864},
    { -256, 160, 640},
    { -312, 168, 584},
    { -384, 128, 584},
    { -448, 192, 680},
    { -544, 264, 760},
    { -520, 328, 784},
    { -640, 320, 896},
    { -584, 264, 1096},
    { -512, 328, 1064},
    { -568, 336, 1320},
    { -384, 288, 1272},
    { -376, 232, 984},
    { -392, 248, 832},
    { -360, 392, 600},
    { -320, 472, 448},
    { -440, 448, 368},
    { -480, 152, 344},
    { -376, -40, -296},
    // 29 seconds
    { -160, 768, -840},
    { -16, 368, -1040},
    { -176, 480, -1264},
    { 8, 328, -1184},
    { 80, 432, -1120},
    { 120, 400, -1128},
    { 304, 568, -1184},
    { 400, 520, -1056},
    { 384, 456, -960},
    { 264, 384, -808},
    { 160, 272, -680},
    { 24, 256, -608},
    { -80, 200, -640},
    { -128, 224, -728},
    { -56, 224, -960},
    { 40, 240, -1096},
    { 16, 224, -1376},
    { 120, 328, -1624},
    { 104, -24, -1296},
    { 136, 128, -1056},
    { 288, 328, -960},
    { 328, 264, -976},
    { 224, 304, -872},
    { 272, 264, -896},
    { 280, 120, -896},
    // 30 seconds
    { 112, 16, -728},
    { 48, -72, -760},
    { 40, -112, -872},
    { 184, 24, -928},
    { 208, 48, -976},
    { 216, -72, -1080},
    { 392, -64, -1144},
    { 376, -96, -920},
    { 456, 0, -760},
    { 664, 304, -680},
    { 592, 88, -376},
    { 680, 0, -88},
    { 728, 128, -16},
    { 808, 440, -72},
    { 1032, 1128, -520},
    { 1064, 1560, -992},
    { 744, 480, -480},
    { 784, -16, -672},
    { 760, 160, -792},
    { 624, 592, -776},
    { 752, 952, -920},
    { 824, 904, -968},
    { 840, 768, -944},
    { 992, 576, -928},
    { 952, 496, -800},
    // 31 seconds
    { 896, 544, -656},
    { 1032, 536, -592},
    { 1008, 360, -584},
    { 832, 128, -504},
    { 720, 64, -480},
    { 680, 112, -472},
    { 576, 80, -432},
    { 472, -40, -368},
    { 400, -112, -184},
    { 592, -64, -112},
    { 704, 80, -128},
    { 1072, 144, 56},
    { 1536, 160, 136},
    { 2000, 408, -168},
    { 1944, 432, -104},
    { 1592, 288, 40},
    { 1128, 224, -88},
    { 944, 88, -112},
    { 1064, 104, -32},
    { 1160, 176, 64},
    { 1160, 312, 24},
    { 1016, 456, -56},
    { 1000, 448, 32},
    { 1256, 552, 272},
    { 944, 640, -16},
    // 32 seconds
    { 1200, 320, 104},
    { 1168, 408, -64},
    { 1088, 376, 32},
    { 1176, 408, 72},
    { 1528, 384, 96},
    { 1584, 272, 136},
    { 1440, 80, 168},
    { 1296, -56, 104},
    { 1136, -80, 24},
    { 1040, -16, -24},
    { 912, 56, -8},
    { 792, 80, 0},
    { 1080, 72, 72},
    { 784, 16, -32},
    { 896, -24, -160},
    { 1064, -96, 88},
    { 1264, 112, 0},
    { 1264, 176, -88},
    { 1384, 168, -144},
    { 1408, 224, -168},
    { 1088, 208, -160},
    { 944, 168, -72},
    { 1064, 208, -16},
    { 1208, 224, 32},
    { 1160, 288, 0},
    // 33 seconds
    { 1024, 336, -32},
    { 1320, 408, 16},
    { 1088, 568, 352},
    { 840, 688, -8},
    { 1080, 400, 0},
    { 1136, 464, -56},
    { 1200, 408, 48},
    { 1336, 440, 112},
    { 1568, 360, 80},
    { 1440, 208, 144},
    { 1472, 24, 256},
    { 1424, -48, 128},
    { 1296, -8, 24},
    { 1056, 64, -8},
    { 728, 64, -16},
    { 792, -16, 32},
    { 792, -128, 32},
    { 536, -192, 32},
    { 880, -64, -32},
    { 1272, 64, -48},
    { 1352, 160, -176},
    { 1568, 128, -184},
    { 1520, 72, -8},
    { 1256, 144, -80},
    { 960, 104, -160},
    // 34 seconds
    { 1048, 136, -120},
    { 1184, 168, 16},
    { 1232, 264, 64},
    { 1048, 368, -40},
    { 920, 384, -48},
    { 1296, 440, 64},
    { 928, 672, 96},
    { 1024, 464, -56},
    { 1136, 272, -64},
    { 1008, 352, -8},
    { 1216, 416, 64},
    { 1344, 368, 64},
    { 1528, 272, 40},
    { 1424, 160, 136},
    { 1352, 8, 160},
    { 1192, -48, 56},
    { 1032, -32, -16},
    { 840, 32, -32},
    { 672, 56, -16},
    { 920, 24, 96},
    { 896, -16, 8},
    { 752, -56, -56},
    { 1280, -128, 128},
    { 1400, 168, -88},
    { 1280, 224, -240},
    // 35 seconds
    { 1248, 56, -88},
    { 1176, 24, -48},
    { 944, -144, -152},
    { 896, 256, -112},
    { 1056, 160, 40},
    { 1224, 240, 80},
    { 1136, 312, 16},
    { 880, 344, -104},
    { 1184, 344, -40},
    { 1272, 1008, 384},
    { 904, 816, -280},
    { 1264, 200, 32},
    { 1288, 168, -216},
    { 1152, 232, -160},
    { 1424, 384, -120},
    { 1672, 352, 152},
    { 1736, 168, 104},
    { 1760, 40, 152},
    { 1624, 136, -48},
    { 1392, 224, -152},
    { 1064, 136, -144},
    { 744, -80, -200},
    { 504, -312, -248},
    { 368, -304, -552},
    { 232, -144, -696},
    // 36 seconds
    { 80, -80, -800},
    { 88, 48, -1096},
    { 216, 16, -1040},
    { 296, -80, -912},
    { 208, -64, -872},
    { 112, 16, -912},
    { 24, -32, -904},
    { -104, -120, -856},
    { -144, -120, -840},
    { -184, -104, -920},
    { -160, -128, -984},
    { -216, -72, -1008},
    { -216, -16, -1104},
    { -32, 16, -1208},
    { -48, 72, -1200},
    { -96, 264, -1128},
    { 48, 224, -1088},
    { -152, 88, -936},
    { -160, 240, -888},
    { -88, 392, -944},
    { -16, 264, -920},
    { -40, 96, -904},
    { -56, 88, -960},
    { -104, -56, -960},
    { -152, -288, -832},
    // 37 seconds
    { -64, -216, -672},
    { 24, -152, -496},
    { 344, -24, -304},
    { 1024, 328, -96},
    { 1592, 496, 256},
    { 2352, 728, 432},
    { 1968, 1096, -168},
    { 1328, 520, -408},
    { 1264, -32, -248},
    { 1176, 344, 0},
    { 1200, 392, 336},
    { 984, 104, 296},
    { 1016, 48, 112},
    { 960, 160, -16},
    { 872, 384, -160},
    { 712, 424, -128},
    { 1184, 520, 40},
    { 1112, 792, 248},
    { 1112, 480, -8},
    { 1288, 264, -16},
    { 1024, 352, -72},
    { 1056, 352, -24},
    { 1256, 328, 56},
    { 1448, 312, 16},
    { 1328, 192, 24},
    // 38 seconds
    { 1304, 16, 96},
    { 1208, -16, 40},
    { 1152, 24, 8},
    { 1072, 48, 24},
    { 896, 72, 104},
    { 1112, 72, 88},
    { 952, 80, 64},
    { 1024, -16, 0},
    { 1008, -112, 112},
    { 1024, 120, 24},
    { 1032, 208, -136},
    { 1112, 136, -192},
    { 1288, 112, -232},
    { 1032, 120, -224},
    { 824, 8, -232},
    { 1016, 72, -288},
    { 1088, 184, -192},
    { 1144, 296, -216},
    { 944, 336, -184},
    { 1208, 368, -88},
    { 1240, 488, -40},
    { 976, 424, -8},
    { 1344, 272, -128},
    { 1096, 296, -64},
    { 1112, 296, -8},
    // 39 seconds
    { 1120, 304, 32},
    { 1280, 280, 24},
    { 1136, 168, 40},
    { 1112, 32, 24},
    { 1128, -24, -136},
    { 1080, -8, -136},
    { 960, 16, -136},
    { 728, 40, -176},
    { 800, 8, -88},
    { 1032, 32, -96},
    { 1032, 8, -8},
    { 1240, -24, 264},
    { 1152, 160, -8},
    { 1128, 264, -128},
    { 1088, 152, -80},
    { 1088, 128, -64},
    { 960, 112, -96},
    { 920, 88, -120},
    { 1008, 88, -144},
    { 1120, 176, -128},
    { 1224, 288, -160},
    { 1112, 328, -128},
    { 1272, 368, 0},
    { 1280, 576, 96},
    { 952, 680, 16},
    // 40 seconds
    { 1136, 360, -8},
    { 928, 352, -112},
    { 1000, 312, 24},
    { 1128, 408, 88},
    { 1392, 376, 96},
    { 1424, 256, 72},
    { 1296, 112, 112},
    { 1288, 8, 96},
    { 1192, -32, 16},
    { 1064, 32, -56},
    { 888, 56, -104},
    { 888, 16, -8},
    { 1136, 24, 24},
    { 800, 16, -48},
    { 1040, 16, -80},
    { 1168, -32, 72},
    { 1120, 152, -56},
    { 1104, 176, -160},
    { 1128, 112, -128},
    { 1112, 136, -88},
    { 880, 80, -64},
    { 912, 80, -48},
    { 1072, 160, -40},
    { 1208, 232, -64},
    { 1160, 312, -160},
    // 41 seconds
    { 920, 336, -192},
    { 1224, 352, -184},
    { 1304, 456, -176},
    { 1016, 480, -56},
    { 1368, 400, -272},
    { 976, 264, -168},
    { 1000, 264, -64},
    { 1160, 280, -16},
    { 1456, 272, -24},
    { 1280, 128, 8},
    { 1192, -8, 64},
    { 1168, -8, 48},
    { 1136, 48, 40},
    { 1008, 104, 40},
    { 856, 80, 72},
    { 1176, 56, 80},
    { 944, 88, 16},
    { 1032, 72, -120},
    { 1008, -56, 0},
    { 960, -8, 16},
    { 984, 88, -112},
    { 1016, 80, -128},
    { 1160, 136, -152},
    { 992, 168, -160},
    { 912, 112, -128},
    // 42 seconds
    { 1096, 144, -152},
    { 1248, 216, -64},
    { 1232, 288, -72},
    { 1040, 320, -136},
    { 1168, 320, -152},
    { 1280, 480, -152},
    { 952, 512, -24},
    { 1304, 480, -80},
    { 1120, 304, -152},
    { 1016, 256, -48},
    { 1128, 352, -16},
    { 1544, 504, -72},
    { 1480, 440, 64},
    { 1464, 208, 328},
    { 1440, 112, 160},
    { 1376, 360, -56},
    { 1200, 864, 32},
    { 1088, 480, -208},
    { 984, -8, -328},
    { 752, -112, -456},
    { 552, -88, -560},
    { 456, -264, -768},
    { 456, -168, -1024},
    { 528, -192, -920},
    { 464, -120, -816},
    // 43 seconds
    { 296, -168, -744},
    { 128, -232, -712},
    { -8, -184, -752},
    { -80, -192, -752},
    { -88, -152, -824},
    { -104, -160, -888},
    { -64, -168, -920},
    { -216, -104, -920},
    { -168, 8, -1064},
    { -96, 96, -1176},
    { -104, 168, -1256},
    { -32, 136, -1272},
    { -80, 112, -1208},
    { -160, 176, -1056},
    { -136, 296, -1000},
    { 0, 208, -976},
    { -64, 48, -832},
    { -152, 32, -784},
    { -248, 112, -856},
    { -216, 128, -960},
    { -32, -40, -1040},
    { -24, -144, -1040},
    { 32, -72, -1136},
    { 112, -24, -1152},
    { -96, -16, -1080},
    // 44 seconds
    { 48, 208, -1160},
    { 368, 408, -1264},
    { 408, 96, -1088},
    { 368, 112, -816},
    { 368, 176, -640},
    { 320, 256, -472},
    { 192, 368, -408},
    { 104, 456, -496},
    { 32, 568, -640},
    { 32, 680, -872},
    { 48, 480, -1048},
    { 24, 416, -1232},
    { 344, 472, -1496},
    { 320, 528, -1344},
    { 184, 888, -1264},
    { 216, 1016, -1232},
    { 208, 848, -1048},
    { 192, 672, -928},
    { 272, 568, -944},
    { 352, 496, -840},
    { 296, 408, -656},
    { 240, 496, -584},
    { 96, 360, -640},
    { 32, 224, -664},
    { 88, -72, -784},
    // 45 seconds
    { 56, -152, -904},
    { 88, 56, -1048},
    { 288, 296, -1112},
    { 152, 176, -992},
    { 56, 336, -968},
    { 48, 352, -1120},
    { 296, 224, -1360},
    { 176, -120, -1216},
    { 120, 0, -992},
    { 24, 88, -784},
    { -112, 280, -696},
    { -264, 352, -712},
    { -312, 272, -776},
    { -256, 120, -872},
    { -264, 16, -952},
    { -288, 80, -1032},
    { -160, 176, -1120},
    { -160, 280, -1192},
    { -168, 576, -1272},
    { -64, 552, -1208},
    { -144, 336, -1032},
    { -232, 352, -968},
    { -168, 312, -960},
    { -168, 176, -832},
    { -248, 168, -728},
    // 46 seconds
    { -328, 112, -680},
    { -432, -152, -600},
    { -328, -176, -496},
    { -88, 24, -352},
    { 216, 152, -232},
    { 952, 472, -128},
    { 1240, 392, -112},
    { 1776, 208, -88},
    { 2456, 416, -256},
    { 2176, 448, -104},
    { 1800, 320, -208},
    { 1368, 280, -176},
    { 1160, 312, -24},
    { 880, 240, 232},
    { 824, 112, 112},
    { 816, 144, 0},
    { 800, 312, -56},
    { 872, 448, -104},
    { 992, 464, 64},
    { 1312, 680, 168},
    { 1064, 928, -88},
    { 1496, 448, 64},
    { 1136, 368, -120},
    { 1320, 224, -8},
    { 1584, 288, -16},
    // 47 seconds
    { 2056, 360, 24},
    { 1960, 344, 40},
    { 1752, 152, 264},
    { 1568, 200, 72},
    { 1320, 136, -64},
    { 944, 136, -120},
    { 600, 144, -288},
    { 352, -48, -416},
    { 264, -136, -560},
    { 152, -80, -760},
    { -40, -168, -816},
    { -160, -24, -992},
    { 64, 56, -1096},
    { 232, -120, -1000},
    { 168, -112, -896},
    { 136, -56, -872},
    { -24, -24, -864},
    { -160, -72, -872},
    { -216, -88, -888},
    { -200, -80, -944},
    { -96, -128, -1040},
    { -192, -176, -1048},
    { -160, -120, -1136},
    { -64, -24, -1248},
    { -152, 16, -1256},
    // 48 seconds
    { -144, 128, -1264},
    { 8, 232, -1208},
    { -152, 192, -968},
    { -224, 144, -872},
    { -200, 192, -896},
    { -88, 160, -904},
    { -136, 72, -808},
    { -192, -8, -776},
    { -224, -104, -824},
    { -200, -104, -880},
    { -192, -240, -776},
    { -216, -440, -576},
    { 72, -576, -360},
    { 608, -496, -88},
    { 1400, -48, 432},
    { 2576, 864, 752},
    { 2568, 1576, 368},
    { 1768, 1048, -192},
    { 1184, 56, -328},
    { 1112, 200, -232},
    { 952, 480, 120},
    { 968, 176, 248},
    { 1048, -8, 152},
    { 1040, 40, 176},
    { 1000, 344, 96},
    // 49 seconds
    { 928, 504, -56},
    { 1360, 512, 48},
    { 1064, 800, 352},
    { 928, 808, -312},
    { 1128, 360, -32},
    { 1048, 416, -56},
    { 1160, 328, 16},
    { 1416, 256, 48},
    { 1600, 216, 0},
    { 1432, 96, 8},
    { 1320, -56, 72},
    { 1184, -32, 32},
    { 1072, 48, 0},
    { 992, 80, 24},
    { 872, 56, 72},
    { 1008, 72, 80},
    { 912, 24, 72},
    { 1032, -56, 80},
    { 1280, -88, 184},
    { 1272, 240, -176},
    { 1224, 224, -168},
    { 1200, 80, -96},
    { 1128, 56, -136},
    { 1000, -80, -256},
    { 1032, 408, -184},
    // 50 seconds
    { 1056, 280, 72},
    { 1176, 264, 72},
    { 1200, 296, -56},
    { 952, 336, -32},
    { 1280, 320, 80},
    { 1016, 448, 152},
    { 1080, 480, 40},
    { 1152, 472, -56},
    { 1016, 400, -48},
    { 1056, 304, 40},
    { 1264, 296, 96},
    { 1440, 256, 8},
    { 1352, 152, 56},
    { 1256, 8, 104},
    { 1104, -32, 56},
    { 960, -24, -40},
    { 848, 64, -88},
    { 816, 48, 0},
    { 1144, 64, 32},
    { 984, 32, 24},
    { 1232, -72, 168},
    { 1296, -8, 128},
    { 1280, 304, -216},
    { 1184, 176, -56},
    { 1160, 64, 0},
    // 51 seconds
    { 888, 96, -80},
    { 792, 48, -112},
    { 920, 192, 0},
    { 1112, 224, 112},
    { 1176, 328, 40},
    { 976, 360, -104},
    { 1048, 344, -40},
    { 1280, 472, 32},
    { 1016, 536, 104},
    { 1488, 464, -8},
    { 1064, 336, -96},
    { 1000, 280, -16},
    { 1120, 320, 16},
    { 1432, 368, -32},
    { 1344, 200, 8},
    { 1248, 16, 144},
    { 1176, -8, 40},
    { 1056, -56, -32},
    { 920, 48, -8},
    { 784, 64, 48},
    { 896, 48, 80},
    { 1032, 56, 72},
    { 848, 24, 56},
    { 1120, -8, -8},
    { 1240, 48, 0},
    // 52 seconds
    { 1232, 176, -216},
    { 1248, 112, -192},
    { 1256, 32, -120},
    { 1016, 72, -96},
    { 856, 80, -112},
    { 976, 136, -80},
    { 1112, 208, 0},
    { 1096, 264, -16},
    { 952, 320, -120},
    { 952, 328, -128},
    { 1280, 472, -152},
    { 1048, 616, -72},
    { 1488, 512, -232},
    { 1040, 248, -216},
    { 904, 224, -40},
    { 1184, 248, 8},
    { 1520, 264, -40},
    { 1304, 144, -48},
    { 1192, 24, 32},
    { 1200, 16, 64},
    { 1168, 72, -16},
    { 1040, 96, -48},
    { 840, 40, -72},
    { 888, -56, -8},
    { 912, -72, -120},
    // 53 seconds
    { 808, -56, -160},
    { 1176, -56, -120},
    { 1320, 8, -80},
    { 1280, 120, -168},
    { 1280, 80, -152},
    { 1264, 56, -88},
    { 1032, 104, -48},
    { 944, 136, -72},
    { 1016, 160, -32},
    { 1088, 216, 56},
    { 1120, 280, -16},
    { 1016, 360, -224},
    { 1248, 392, -136},
    { 1304, 712, -64},
    { 1104, 584, -120},
    { 1080, 432, -200},
    { 1024, 432, -312},
    { 1080, 344, -96},
    { 1312, 312, 48},
    { 1672, 216, 88},
    { 1640, 120, 40},
    { 1472, 64, 40},
    { 1392, 40, 120},
    { 1264, 104, 24},
    { 1096, 136, -64},
    // 54 seconds
    { 752, 120, -152},
    { 728, 32, -216},
    { 824, -96, -176},
    { 664, -152, -200},
    { 752, -120, -280},
    { 1016, -64, -152},
    { 1160, 48, -48},
    { 1272, 128, -112},
    { 1344, 128, -80},
    { 1368, 128, 16},
    { 1216, 160, -16},
    { 1128, 152, -16},
    { 1216, 192, 24},
    { 1312, 232, 56},
    { 1336, 288, 64},
    { 1104, 368, -136},
    { 1120, 408, -248},
    { 1376, 704, -64},
    { 1000, 592, -176},
    { 1080, 272, -80},
    { 1032, 544, -168},
    { 944, 496, -168},
    { 1128, 376, 0},
    { 1408, 312, 112},
    { 1736, 216, 112},
    // 55 seconds
    { 1608, 104, 104},
    { 1520, 24, 120},
    { 1448, 24, 136},
    { 1272, 80, 48},
    { 1064, 104, 64},
    { 832, 64, 24},
    { 784, 8, 8},
    { 888, -48, -16},
    { 808, -24, -192},
    { 1080, -32, -224},
    { 1304, -32, 0},
    { 1360, 72, -176},
    { 1480, 96, -248},
    { 1456, 72, -128},
    { 1248, 176, -128},
    { 1008, 160, -200},
    { 1008, 192, -160},
    { 1064, 232, -80},
    { 1016, 264, -112},
    { 984, 304, -184},
    { 1008, 304, -96},
    { 1240, 400, -32},
    { 952, 448, 32},
    { 1016, 360, -40},
    { 1080, 400, -48},
    // 56 seconds
    { 1136, 520, -72},
    { 1176, 400, 16},
    { 1376, 328, 128},
    { 1448, 216, 128},
    { 1312, 112, 136},
    { 1336, 8, 152},
    { 1288, -16, 64},
    { 1152, 56, -16},
    { 952, 88, -40},
    { 816, 48, -16},
    { 1056, 0, 48},
    { 904, 16, -40},
    { 912, 56, -192},
    { 1128, 8, -112},
    { 1280, 64, -168},
    { 1288, 88, -272},
    { 1224, -8, -160},
    { 1136, 24, -120},
    { 920, 104, -88},
    { 872, 136, -64},
    { 1040, 192, 8},
    { 1128, 256, 48},
    { 1112, 320, -56},
    { 968, 336, -184},
    { 1232, 440, -208},
    // 57 seconds
    { 1216, 760, -120},
    { 848, 344, -120},
    { 1232, 272, -32},
    { 1376, 432, -176},
    { 1184, 344, -104},
    { 1192, 328, -32},
    { 1392, 320, -16},
    { 1320, 240, 16},
    { 1312, 104, 128},
    { 1344, 16, 120},
    { 1320, 8, 64},
    { 1216, 48, 24},
    { 960, 72, 0},
    { 832, 32, -16},
    { 872, -24, -24},
    { 664, -112, -56},
    { 872, -128, -40},
    { 1296, -56, 56},
    { 1280, 136, -256},
    { 1392, 128, -240},
    { 1432, 8, -120},
    { 1176, 88, -136},
    { 896, 96, -136},
    { 1048, 168, -152},
    { 1168, 248, -72},
    // 58 seconds
    { 1208, 272, -40},
    { 1056, 312, -128},
    { 864, 296, -120},
    { 1264, 440, -88},
    { 1008, 592, -8},
    { 1216, 376, -48},
    { 1320, 424, -128},
    { 1064, 384, -88},
    { 1192, 336, 0},
    { 1416, 312, 40},
    { 1448, 240, 32},
    { 1272, 112, 104},
    { 1232, 8, 128},
    { 1208, -8, 32},
    { 1112, 56, -40},
    { 944, 72, -24},
    { 728, 32, -32},
    { 864, 8, -48},
    { 816, -16, -144},
    { 752, -48, -184},
    { 1184, -152, 0},
    { 1440, 32, -56},
    { 1336, 128, -160},
    { 1280, 64, -136},
    { 1200, 80, -120},
    // 59 seconds
    { 968, 128, -56},
    { 1032, 128, -24},
    { 1248, 168, 104},
    { 1448, 256, 96},
    { 1408, 392, -48},
    { 1096, 552, -72},
    { 1144, 1016, -248},
    { 1056, 472, -96},
    { 952, 480, 8},
    { 1248, 576, -168},
    { 1056, 384, -136},
    { 1248, 352, -48},
    { 1472, 344, 40},
    { 1792, 272, 80},
    { 1624, 136, 96},
    { 1488, 32, 152},
    { 1376, 8, 128},
    { 1232, 48, 56},
    { 992, 96, 8},
    { 832, 40, 16},
    { 968, -48, -16},
    { 736, -96, -32},
    { 712, -120, -144},
    { 984, -144, -168},
    { 1088, -16, -200},
    // 60 seconds
    // elapsed: 1 minutes
    { 1192, 32, -272},
    { 1416, -16, -160},
    { 1528, 56, -80},
    { 1328, 176, -48},
    { 1184, 216, -152},
    { 1200, 256, -104},
    { 1176, 296, -40},
    { 1168, 296, -104},
    { 1032, 312, -192},
    { 1160, 376, -120},
    { 1264, 688, -88},
    { 1072, 592, -120},
    { 1192, 464, -224},
    { 1000, 376, -240},
    { 1080, 320, -112},
    { 1256, 312, 24},
    { 1536, 272, 88},
    { 1456, 176, 56},
    { 1368, 56, 80},
    { 1336, -8, 96},
    { 1280, 24, 16},
    { 1168, 80, -32},
    { 984, 80, -80},
    { 840, 16, -64},
    { 936, -80, -96},
    // 61 seconds
    { 664, -152, -168},
    { 800, -112, -248},
    { 984, -80, -8},
    { 1280, 32, -136},
    { 1440, 96, -160},
    { 1520, 72, -80},
    { 1424, 128, -72},
    { 1136, 184, -144},
    { 1104, 168, -104},
    { 1184, 184, -32},
    { 1160, 248, -80},
    { 1120, 296, -176},
    { 1128, 352, -144},
    { 1360, 616, -32},
    { 984, 768, -24},
    { 1432, 560, -40},
    { 1032, 416, -144},
    { 1176, 248, -72},
    { 1336, 352, 40},
    { 1616, 384, 40},
    { 1488, 216, 80},
    { 1376, 56, 152},
    { 1376, 0, 112},
    { 1304, 24, 56},
    { 1168, 72, 72},
    // 62 seconds
    { 1024, 40, 72},
    { 1104, 8, 88},
    { 1000, 16, 40},
    { 776, -8, -32},
    { 976, -16, -40},
    { 1128, 32, -120},
    { 1160, 144, -200},
    { 1184, 56, -296},
    { 1216, 0, -248},
    { 1032, 32, -112},
    { 968, 80, -88},
    { 1192, 168, -184},
    { 1312, 248, -184},
    { 1240, 296, -128},
    { 1144, 304, -168},
    { 1336, 360, -160},
    { 1304, 536, -96},
    { 856, 472, -8},
    { 1136, 504, -64},
    { 1040, 528, -152},
    { 1160, 352, -24},
    { 1320, 312, 72},
    { 1576, 272, 56},
    { 1440, 200, 32},
    { 1360, 80, 96},
    // 63 seconds
    { 1312, 8, 48},
    { 1216, 16, -32},
    { 1008, 56, -128},
    { 824, 24, -120},
    { 840, -64, 32},
    { 968, -32, -64},
    { 840, 24, -144},
    { 1072, 8, 0},
    { 1264, 40, -24},
    { 1328, 136, -176},
    { 1424, 104, -128},
    { 1344, 72, -40},
    { 1024, 144, -144},
    { 872, 168, -224},
    { 944, 208, -136},
    { 1008, 192, -32},
    { 1008, 224, -56},
    { 976, 272, -184},
    { 1104, 272, -136},
    { 1400, 408, -120},
    { 1024, 536, -24},
    { 1200, 464, -152},
    { 1064, 328, -168},
    { 1176, 400, -88},
    { 1376, 600, -96},
    // 64 seconds
    { 1840, 600, 48},
    { 1928, 512, 232},
    { 1896, 320, 72},
    { 1768, 376, 24},
    { 1464, 384, -72},
    { 1048, 360, -32},
    { 784, 128, -128},
    { 456, -256, -216},
    { 352, -384, -592},
    { 216, -248, -736},
    { 160, -280, -808},
    { 112, -328, -864},
    { 168, -56, -1008},
    { 200, -136, -944},
    { 152, -240, -840},
    { 128, -144, -832},
    { 0, -224, -792},
    { -80, -256, -800},
    { -128, -264, -808},
    { -136, -256, -864},
    { -136, -288, -952},
    { -144, -328, -1032},
    { -176, -344, -1096},
    { -104, -256, -1152},
    { -176, -144, -1176},
    // 65 seconds
    { -192, 88, -1216},
    { -72, 144, -1280},
    { -128, -112, -1136},
    { -168, -56, -984},
    { -112, -8, -880},
    { -96, -64, -784},
    { -136, -64, -736},
    { -200, -152, -704},
    { -256, -264, -720},
    { -240, -240, -792},
    { -80, -40, -864},
    { 80, 160, -856},
    { 352, 312, -824},
    { 552, -96, -640},
    { 1056, -176, -288},
    { 1776, 344, 64},
    { 1984, 720, 16},
    { 1808, 616, -88},
    { 1680, 560, -240},
    { 1368, 392, -16},
    { 1160, 280, 120},
    { 1072, 168, 152},
    { 1096, 64, 32},
    { 1088, 160, 40},
    { 1032, 312, 0},
    // 66 seconds
    { 912, 424, -136},
    { 1048, 480, -40},
    { 1312, 760, 128},
    { 928, 856, -200},
    { 1224, 176, -48},
    { 1088, 336, -208},
    { 1232, 400, -120},
    { 1304, 368, 8},
    { 1704, 336, 48},
    { 1616, 208, 40},
    { 1360, 80, 80},
    { 1232, -16, 128},
    { 1128, 0, 80},
    { 1016, 40, 24},
    { 880, 88, 32},
    { 896, 56, 64},
    { 1112, 40, 96},
    { 800, 72, 48},
    { 1152, 72, -64},
    { 1184, 56, -32},
    { 1152, 120, -208},
    { 1192, 88, -256},
    { 1200, -8, -144},
    { 1096, 24, -136},
    { 936, 72, -144},
    // 67 seconds
    { 1024, 216, -176},
    { 1160, 272, -104},
    { 1184, 328, 8},
    { 1160, 352, -32},
    { 1200, 312, -40},
    { 1376, 424, 0},
    { 1016, 568, 80},
    { 1032, 440, -8},
    { 1176, 464, -72},
    { 1016, 408, -80},
    { 1056, 376, -8},
    { 1288, 368, 24},
    { 1392, 288, 24},
    { 1296, 144, 160},
    { 1328, 0, 192},
    { 1272, -40, 64},
    { 1160, 16, 8},
    { 984, 56, 32},
    { 848, 48, 88},
    { 1024, 32, 80},
    { 888, -32, 144},
    { 824, -96, 128},
    { 1200, -96, 112},
    { 1312, 232, -72},
    { 1272, 176, -192},
    // 68 seconds
    { 1280, 0, -40},
    { 1272, 56, -176},
    { 1016, 72, -224},
    { 1000, 424, -312},
    { 1008, 264, -40},
    { 1016, 272, -8},
    { 1040, 248, -88},
    { 960, 280, -88},
    { 1328, 368, -48},
    { 1032, 592, 144},
    { 864, 456, -48},
    { 1448, 368, 0},
    { 1272, 440, -64},
    { 1152, 344, -16},
    { 1224, 320, 0},
    { 1544, 336, -24},
    { 1424, 176, 120},
    { 1376, -40, 160},
    { 1296, -120, 48},
    { 1136, -40, -48},
    { 928, 64, -48},
    { 688, 80, -48},
    { 736, -16, 64},
    { 784, -96, 56},
    { 608, -104, -8},
    // 69 seconds
    { 1200, -64, 80},
    { 1464, 72, -112},
    { 1512, 136, -112},
    { 1592, 72, -16},
    { 1360, 104, -152},
    { 1008, -40, -192},
    { 992, 344, -48},
    { 1128, 240, 88},
    { 1280, 256, 56},
    { 1176, 352, 0},
    { 824, 368, -8},
    { 1032, 456, 80},
    { 1040, 888, 112},
    { 936, 376, 80},
    { 1328, 280, 32},
    { 1184, 352, -72},
    { 1304, 424, -8},
    { 1424, 384, 40},
    { 1568, 296, 32},
    { 1464, 208, 144},
    { 1416, 56, 248},
    { 1288, -32, 120},
    { 1120, 0, -24},
    { 904, 96, -64},
    { 672, 8, -40},
    // 70 seconds
    { 752, -32, -24},
    { 728, -64, -184},
    { 728, -48, -176},
    { 864, -120, -24},
    { 992, -32, -216},
    { 1144, -40, -304},
    { 1304, -144, -184},
    { 1344, -144, 8},
    { 1152, -16, 16},
    { 992, 48, 16},
    { 1016, 288, -40},
    { 1152, 336, -16},
    { 1184, 304, 24},
    { 952, 264, -88},
    { 896, 248, -200},
    { 1408, 360, -200},
    { 1152, 688, 8},
    { 1280, 680, -288},
    { 1080, 120, -176},
    { 976, 160, -24},
    { 1136, 304, -64},
    { 1456, 352, -80},
    { 1344, 232, -32},
    { 1136, 96, 48},
    { 1080, 8, 88},
    // 71 seconds
    { 1040, 8, 32},
    { 944, 48, 32},
    { 848, 72, 40},
    { 1136, 48, 64},
    { 1064, 56, 72},
    { 1064, -16, -56},
    { 1216, -192, 152},
    { 1200, 8, -40},
    { 1048, 112, -208},
    { 1072, 16, -112},
    { 1152, 32, -128},
    { 928, 104, -120},
    { 840, 112, -136},
    { 968, 136, -80},
    { 1064, 200, 8},
    { 1064, 264, -56},
    { 1040, 312, -152},
    { 1408, 408, -128},
    { 1200, 704, 32},
    { 1064, 496, -104},
    { 1216, 272, -80},
    { 1024, 320, -120},
    { 1120, 328, -72},
    { 1320, 360, -40},
    { 1432, 320, 0},
    // 72 seconds
    { 1296, 200, 64},
    { 1208, 40, 152},
    { 1160, -40, 80},
    { 1072, -32, -40},
    { 904, 56, -56},
    { 776, 40, -24},
    { 1080, 16, 88},
    { 816, -8, 32},
    { 832, 64, -64},
    { 1040, -32, 128},
    { 1280, 136, -8},
    { 1224, 208, -168},
    { 1224, 112, -96},
    { 1176, 64, -40},
    { 936, 120, -112},
    { 848, 592, -344},
    { 1000, 288, -64},
    { 1104, 216, 16},
    { 1136, 216, -80},
    { 952, 264, -144},
    { 1208, 296, -104},
    { 1304, 600, -96},
    { 1208, 712, -40},
    { 1280, 288, -64},
    { 912, 176, -96},
    // 73 seconds
    { 1016, 256, -56},
    { 1232, 320, -48},
    { 1400, 320, 0},
    { 1264, 200, 56},
    { 1120, 64, 128},
    { 1080, -16, 88},
    { 984, 0, 0},
    { 872, 64, -24},
    { 720, 72, -32},
    { 824, 24, 32},
    { 1080, 32, 16},
    { 1072, -32, 80},
    { 1264, -104, 192},
    { 1216, 144, -96},
    { 1104, 256, -280},
    { 1104, 128, -192},
    { 1168, -16, -104},
    { 1112, -168, -224},
    { 880, 544, -288},
    { 800, 296, -56},
    { 840, 216, 0},
    { 952, 184, -64},
    { 944, 264, -128},
    { 1056, 288, -112},
    { 1408, 480, -104},
    // 74 seconds
    { 936, 1032, 160},
    { 1432, 360, -8},
    { 1120, 144, -32},
    { 1320, 224, 0},
    { 1424, 376, -16},
    { 1568, 360, 8},
    { 1344, 224, 16},
    { 1136, 128, 88},
    { 1016, 56, 48},
    { 872, 24, -72},
    { 704, 16, -168},
    { 768, 48, -216},
    { 1072, 40, -32},
    { 1096, 32, 40},
    { 1168, 64, 16},
    { 1232, 0, 304},
    { 1328, 192, 16},
    { 1216, 264, -176},
    { 1152, 96, -112},
    { 992, 8, -144},
    { 696, -24, -224},
    { 672, 24, -224},
    { 896, 96, -216},
    { 1240, 232, -224},
    { 1392, 360, -256},
    // 75 seconds
    { 1416, 720, -48},
    { 1448, 512, -264},
    { 1376, 144, 8},
    { 1416, 592, -136},
    { 976, 608, -272},
    { 944, 400, -128},
    { 1112, 344, 48},
    { 1504, 200, 128},
    { 1472, 56, 88},
    { 1176, 32, 72},
    { 976, 32, 88},
    { 952, 128, -8},
    { 904, 160, 8},
    { 864, 144, -24},
    { 928, 88, -96},
    { 1064, 24, -16},
    { 976, 0, -24},
    { 1144, 80, -144},
    { 1296, 96, -176},
    { 1096, 88, -160},
    { 1208, 0, -56},
    { 1192, 0, -72},
    { 1112, 88, -136},
    { 888, 144, -232},
    { 768, 120, -304},
    // 76 seconds
    { 840, 120, -248},
    { 976, 160, -152},
    { 1152, 272, -136},
    { 1224, 360, -144},
    { 1536, 488, -64},
    { 1248, 456, -24},
    { 1384, 400, -136},
    { 920, 464, -168},
    { 1104, 376, -56},
    { 1224, 312, 72},
    { 1400, 208, 64},
    { 1184, 104, 40},
    { 1024, 16, 48},
    { 1008, 0, -16},
    { 1016, 40, -120},
    { 960, 136, -176},
    { 928, 88, -136},
    { 1216, 0, -24},
    { 1024, -32, -96},
    { 1200, 8, -40},
    { 1168, 40, 80},
    { 1152, 152, -80},
    { 1120, 144, -88},
    { 1072, 88, -40},
    { 952, 104, -80},
    // 77 seconds
    { 776, 112, -160},
    { 768, 120, -240},
    { 816, 104, -216},
    { 1000, 128, -168},
    { 1184, 184, -232},
    { 1176, 224, -224},
    { 1640, 336, -280},
    { 1232, 400, -152},
    { 1096, 384, -88},
    { 992, 344, -264},
    { 840, 360, -160},
    { 1056, 368, -88},
    { 1208, 328, 8},
    { 1264, 192, 56},
    { 1008, 56, 56},
    { 944, -16, 48},
    { 1000, 40, -8},
    { 1008, 96, -56},
    { 968, 152, -88},
    { 1120, 112, 0},
    { 1256, 56, -40},
    { 1064, 24, -144},
    { 1192, -72, -168},
    { 1080, -96, -112},
    { 1032, -56, -232},
    // 78 seconds
    { 1168, -112, -176},
    { 1224, -128, -136},
    { 992, -24, -264},
    { 784, 0, -304},
    { 800, 56, -304},
    { 792, 104, -256},
    { 848, 240, -360},
    { 888, 360, -416},
    { 1040, 648, -520},
    { 1288, 728, -384},
    { 1352, 784, -232},
    { 1080, 888, -304},
    { 872, 384, -408},
    { 1032, 376, -240},
    { 1824, 432, -72},
    { 2384, 232, 144},
    { 2640, 136, -24},
    { 2536, 8, -120},
    { 2016, -232, 296},
    { 1344, -312, 288},
    { 704, -600, 264},
    { 232, -760, 352},
    { 256, -880, 624},
    { 336, -824, 576},
    { 912, -592, 656},
    // 79 seconds
    { 1768, 64, 384},
    { 2272, -72, 104},
    { 2672, -64, 152},
    { 2888, -16, 64},
    { 2496, 200, -40},
    { 1656, 888, -152},
    { 632, 120, -616},
    { 200, 632, -936},
    { 336, 848, -776},
    { 416, 912, -544},
    { 880, 1136, -400},
    { 2264, 640, 80},
    { 2696, 8, 408},
    { 2816, -80, -88},
    { 2712, 384, -160},
    { 2424, 360, 312},
    { 1880, 304, 200},
    { 1656, 288, 32},
    { 1616, 72, -104},
    { 1864, -168, -48},
    { 1400, -608, 320},
    { 304, -944, 512},
    { 456, -488, -16},
    { 664, -616, 360},
    { 1136, -72, 120},
    // 80 seconds
    { 1792, 72, -112},
    { 2624, 216, -216},
    { 2992, -32, 104},
    { 2736, 144, -56},
    { 2200, 480, 96},
    { 1824, 96, -72},
    { 1528, 120, 16},
    { 1536, 232, -32},
    { 1528, 808, 72},
    { 792, 1584, 512},
    { 472, 632, -40},
    { 1192, 744, 0},
    { 1304, 576, -48},
    { 1408, 488, 120},
    { 2064, 536, 104},
    { 2376, 440, 200},
    { 2208, 80, 248},
    { 1856, -104, 256},
    { 1672, -64, 120},
    { 1512, 32, 8},
    { 1256, 112, 48},
    { 1280, -40, 136},
    { 1040, -304, 328},
    { 512, -320, 280},
    { 768, -144, -40},
    // 81 seconds
    { 992, -112, 104},
    { 1264, 88, -152},
    { 1680, 120, -320},
    { 2208, -40, -88},
    { 1968, -16, 16},
    { 1632, 152, -72},
    { 1560, 272, -288},
    { 1480, 288, -168},
    { 1408, 264, -32},
    { 1208, 360, 112},
    { 1448, 552, 200},
    { 1208, 728, 256},
    { 1144, 776, 56},
    { 856, 584, -104},
    { 992, 352, -56},
    { 1256, 360, 112},
    { 1920, 416, 200},
    { 1832, 248, 128},
    { 1672, 64, 104},
    { 1480, 16, 112},
    { 1296, 24, 96},
    { 1096, 64, 8},
    { 936, 40, 0},
    { 784, -24, 40},
    { 816, -80, 48},
    // 82 seconds
    { 824, -112, 120},
    { 664, 16, -48},
    { 1104, 96, -160},
    { 1320, 72, 0},
    { 1712, 152, -136},
    { 1792, 184, -256},
    { 1616, 96, -40},
    { 1216, 128, -144},
    { 992, 64, -152},
    { 1080, 120, -80},
    { 1120, 160, 24},
    { 1184, 208, 48},
    { 1152, 304, -88},
    { 1144, 360, -8},
    { 1272, 376, 144},
    { 1016, 464, 328},
    { 1176, 632, -80},
    { 872, 440, -120},
    { 864, 312, -24},
    { 1080, 384, 144},
    { 1560, 424, 168},
    { 1640, 216, 112},
    { 1456, 48, 152},
    { 1352, -8, 144},
    { 1192, -8, 64},
    // 83 seconds
    { 1008, 40, 0},
    { 896, 40, 24},
    { 888, 8, 80},
    { 1144, 16, 104},
    { 1016, 48, 72},
    { 1160, 24, -88},
    { 1224, -8, -24},
    { 1320, 72, -88},
    { 1232, 104, -144},
    { 1312, 80, -160},
    { 1312, 144, -216},
    { 992, 192, -152},
    { 912, 184, -200},
    { 936, 216, -48},
    { 944, 232, -24},
    { 984, 240, -168},
    { 1024, 272, -160},
    { 1352, 328, -8},
    { 1048, 504, 104},
    { 1240, 616, -8},
    { 1168, 496, -192},
    { 1168, 272, -64},
    { 1344, 376, 16},
    { 1824, 568, 32},
    { 1960, 392, 120},
    // 84 seconds
    { 1840, 176, 328},
    { 1704, 32, 144},
    { 1472, 208, -128},
    { 1160, 256, -120},
    { 760, 160, -128},
    { 512, -16, -264},
    { 424, -88, -512},
    { 288, -80, -688},
    { 152, -280, -696},
    { 96, -200, -992},
    { 208, 48, -1200},
    { 264, -32, -1080},
    { 200, -128, -928},
    { 152, -96, -848},
    { 24, -200, -680},
    { -88, -176, -632},
    { -128, -176, -728},
    { -80, -176, -680},
    { -72, -176, -824},
    { 8, 112, -1040},
    { -24, 248, -1152},
    { -160, 560, -1056},
    { -344, 1144, -808},
    { -400, 1392, -496},
    { -392, 1320, -200},
    // 85 seconds
    { -296, 1136, 104},
    { -328, 1032, 280},
    { -232, 840, 152},
    { -168, 744, 232},
    { -128, 816, 216},
    { -128, 304, 48},
    { -408, 696, 40},
    { -328, 728, 64},
    { -304, 968, -328},
    { -480, 1280, -512},
    { -328, 1016, -744},
    { -320, 960, -736},
    { -416, 648, -720},
    { -296, 392, -664},
    { 0, 384, -640},
    { 392, 776, -800},
    { 456, 512, -856},
    { 472, 216, -904},
    { 296, 56, -880},
    { 136, -120, -840},
    { -96, -208, -816},
    { 160, -192, -808},
    { 104, -168, -864},
    { 104, -240, -1056},
    { 216, -216, -1072},
    // 86 seconds
    { 264, -112, -1208},
    { 200, -216, -1184},
    { 320, -176, -1208},
    { 424, -80, -1232},
    { 304, 8, -1160},
    { 152, 16, -1016},
    { 48, 112, -976},
    { 24, 0, -952},
    { 64, -56, -816},
    { 32, -104, -800},
    { 8, -152, -848},
    { -72, -216, -872},
    { -96, -280, -960},
    { -88, -288, -1040},
    { -8, -320, -1096},
    { 112, -304, -1168},
    { 136, -264, -1208},
    { 192, -240, -1216},
    { 264, -64, -1160},
    { 312, -16, -1096},
    { 320, -40, -952},
    { 256, -80, -864},
    { 152, -176, -808},
    { 32, -176, -760},
    { 40, -176, -784},
    // 87 seconds
    { 16, -248, -856},
    { 8, -216, -912},
    { -8, -264, -1024},
    { -88, -240, -1104},
    { -128, -200, -1200},
    { -88, -136, -1264},
    { -136, -112, -1240},
    { -88, -32, -1240},
    { -152, 24, -1144},
    { -232, -32, -1016},
    { -264, 56, -960},
    { -224, 64, -920},
    { -128, 16, -864},
    { -168, 0, -808},
    { -224, -24, -832},
    { -240, -48, -864},
    { -224, -120, -880},
    { -264, -112, -960},
    { -288, -280, -1112},
    { -248, -288, -1232},
    { -80, -232, -1216},
    { -176, -176, -1200},
    { -64, -128, -1240},
    { -32, 56, -1168},
    { 56, 40, -1152},
    // 88 seconds
    { 64, 128, -1080},
    { -8, 128, -992},
    { -96, 8, -864},
    { -208, 8, -792},
    { -304, -80, -776},
    { -320, -56, -816},
    { -328, -96, -864},
    { -312, -152, -944},
    { -336, -104, -1000},
    { -352, -136, -1096},
    { -304, -72, -1160},
    { -304, 64, -1280},
    { -216, 184, -1296},
    { -312, 208, -1264},
    { -432, 312, -872},
    { -392, 544, -784},
    { -288, 264, -712},
    { -264, 328, -728},
    { -280, 216, -720},
    { -312, 128, -768},
    { -344, 152, -888},
    { -312, 72, -960},
    { -376, 120, -992},
    { -272, 192, -1136},
    { -224, 168, -1144},
    // 89 seconds
    { -328, 216, -1168},
    { -304, 176, -1184},
    { -136, 256, -1248},
    { 80, 232, -1224},
    { 88, 248, -1048},
    { 16, 216, -928},
    { -96, 152, -800},
    { -216, 168, -760},
    { -272, 104, -768},
    { -280, 72, -808},
    { -272, 72, -904},
    { -264, 40, -1000},
    { -328, -24, -1032},
    { -312, 48, -1120},
    { -368, -24, -1184},
    { -496, 88, -1296},
    { -280, 224, -1376},
    { -328, 96, -1008},
    { -272, 136, -872},
    { -176, 64, -784},
    { -40, 24, -808},
    { -64, -56, -792},
    { -80, -32, -864},
    { -152, -96, -912},
    { -120, -176, -952},
    // 90 seconds
    { -32, -216, -1016},
    { -24, -144, -1096},
    { 128, -72, -1336},
    { 72, -144, -1384},
    { -48, -192, -1312},
    { 104, -64, -1184},
    { 152, 112, -1056},
    { 216, 88, -1008},
    { 184, -16, -912},
    { 184, -8, -856},
    { 8, -8, -800},
    { -192, -88, -784},
    { -152, -168, -832},
    { -96, -136, -896},
    { -56, -88, -984},
    { -8, -120, -1032},
    { -128, -184, -1024},
    { -112, -256, -1120},
    { 8, -224, -1216},
    { -160, -336, -1216},
    { -208, -216, -1224},
    { -72, 120, -1288},
    { -176, 48, -1120},
    { -120, 40, -1040},
    { 40, -32, -968},
    // 91 seconds
    { -56, -136, -776},
    { -120, -88, -736},
    { -152, -80, -800},
    { -104, -80, -936},
    { -96, -200, -976},
    { -144, -208, -1016},
    { -64, -272, -1096},
    { 24, -352, -968},
    { -8, -536, -672},
    { 280, -408, -184},
    { 672, -48, 184},
    { 1240, 392, 136},
    { 2088, 888, -200},
    { 1800, 672, -96},
    { 1728, 384, 72},
    { 1480, 312, -24},
    { 1432, 288, -112},
    { 1456, 360, 184},
    { 1344, 344, 272},
    { 1360, 280, 40},
    { 1296, 264, -120},
    { 1464, 408, 24},
    { 1000, 584, 216},
    { 1080, 568, -40},
    { 968, 504, -16},
    // 92 seconds
    { 992, 528, -24},
    { 1024, 424, 48},
    { 1280, 392, 104},
    { 1416, 336, 8},
    { 1304, 200, 72},
    { 1384, 96, 144},
    { 1480, 24, 80},
    { 1344, 16, -16},
    { 1128, 56, -64},
    { 920, 8, -40},
    { 992, -16, 56},
    { 920, 48, 16},
    { 816, 112, -48},
    { 1080, 64, -72},
    { 1208, 56, -8},
    { 1296, 104, -72},
    { 1224, 80, -40},
    { 1120, 88, -32},
    { 880, 144, -128},
    { 784, 136, -144},
    { 880, 152, -40},
    { 1056, 176, 72},
    { 1208, 264, 56},
    { 1160, 360, -32},
    { 1224, 392, -48},
    // 93 seconds
    { 1368, 576, 80},
    { 1024, 512, -8},
    { 1184, 296, -48},
    { 1136, 432, -128},
    { 1040, 440, -56},
    { 1056, 376, 24},
    { 1296, 336, 8},
    { 1160, 216, 32},
    { 1224, 32, 96},
    { 1248, -56, 64},
    { 1224, -24, -24},
    { 1120, 64, -72},
    { 896, 56, -56},
    { 992, 24, 8},
    { 1040, 40, -40},
    { 640, -88, 16},
    { 1088, -160, 96},
    { 1160, 0, 56},
    { 1232, 240, -144},
    { 1272, 168, -152},
    { 1264, 136, -144},
    { 888, 160, -152},
    { 760, 16, -104},
    { 984, 96, -32},
    { 1160, 200, -24},
    // 94 seconds
    { 1184, 352, -176},
    { 976, 368, -216},
    { 960, 320, -88},
    { 1296, 488, -144},
    { 1056, 512, -48},
    { 1384, 416, -136},
    { 1200, 280, -96},
    { 1216, 216, 24},
    { 1296, 184, 64},
    { 1448, 224, 8},
    { 1144, 160, -40},
    { 984, 56, 80},
    { 952, 0, 24},
    { 952, 48, -40},
    { 896, 64, 8},
    { 880, 24, 32},
    { 1048, 16, 64},
    { 1112, -88, 104},
    { 1072, -232, 192},
    { 1320, 32, 112},
    { 1328, 320, -296},
    { 1336, 288, -400},
    { 1328, 72, -192},
    { 1184, -112, -80},
    { 856, -248, -200},
    // 95 seconds
    { 728, -32, -184},
    { 744, 160, 0},
    { 816, 304, 56},
    { 912, 416, -80},
    { 952, 432, -216},
    { 1032, 304, -72},
    { 1112, 360, -8},
    { 1160, 472, 112},
    { 1408, 560, -256},
    { 1240, 152, 24},
    { 1232, 200, 144},
    { 1424, 232, 104},
    { 1560, 216, -24},
    { 1224, 112, -24},
    { 1016, 24, 64},
    { 944, 0, -72},
    { 952, 32, -152},
    { 928, 32, -128},
    { 872, -40, 0},
    { 1120, 16, -8},
    { 832, 48, -120},
    { 864, 40, -144},
    { 1104, 48, -40},
    { 1288, 128, -128},
    { 1408, 104, -72},
    // 96 seconds
    { 1408, 64, 88},
    { 1128, 160, -32},
    { 752, 136, -72},
    { 824, 168, -120},
    { 1016, 200, -40},
    { 1176, 216, 80},
    { 1120, 264, -32},
    { 904, 272, -176},
    { 1336, 296, -160},
    { 1208, 464, -88},
    { 904, 608, 8},
    { 1408, 504, -168},
    { 912, 280, -128},
    { 1080, 264, 0},
    { 1280, 312, 32},
    { 1464, 328, -40},
    { 1288, 200, 32},
    { 1264, 56, 160},
    { 1264, -16, 32},
    { 1184, -24, -64},
    { 992, -8, -144},
    { 720, -24, -128},
    { 656, -56, 0},
    { 928, -8, -72},
    { 736, 48, -184},
    // 97 seconds
    { 1160, 0, 8},
    { 1360, 40, 0},
    { 1544, 200, -80},
    { 1496, 160, 48},
    { 1256, 152, -96},
    { 776, 144, -192},
    { 648, 104, -112},
    { 824, 128, 32},
    { 1072, 168, 88},
    { 1128, 256, -8},
    { 936, 344, -200},
    { 1096, 296, -128},
    { 1488, 472, -112},
    { 944, 800, 136},
    { 1312, 192, -88},
    { 1176, 184, -96},
    { 1000, 456, -104},
    { 1160, 512, -48},
    { 1432, 528, 48},
    { 1576, 472, 248},
    { 1720, 472, 80},
    { 1680, 344, 96},
    { 1472, 224, 0},
    { 1088, 272, -80},
    { 832, 248, -232},
    // 98 seconds
    { 784, 264, -392},
    { 872, 120, -608},
    { 560, -32, -736},
    { 184, -256, -688},
    { -24, -104, -736},
    { -16, 192, -896},
    { 144, 8, -912},
    { 168, -16, -864},
    { 168, 8, -888},
    { 120, -48, -888},
    { 32, -112, -840},
    { -56, -104, -840},
    { -56, -72, -920},
    { -32, -64, -984},
    { -16, -40, -1032},
    { -104, -24, -1104},
    { -8, 48, -1208},
    { -32, 88, -1248},
    { -56, 312, -1280},
    { 88, 312, -1192},
    { -112, 184, -968},
    { -136, 216, -920},
    { -56, 240, -968},
    { 16, 120, -920},
    { -80, -112, -832},
    // 99 seconds
    { -168, -40, -848},
    { -240, 184, -896},
    { -184, 144, -912},
    { -144, -160, -896},
    { -104, -208, -784},
    { 96, -208, -672},
    { 416, -136, -640},
    { 704, -224, -368},
    { 1256, -64, 104},
    { 2096, 528, 328},
    { 2128, 880, 192},
    { 1776, 664, 112},
    { 1544, 448, -240},
    { 1184, 360, -104},
    { 1056, 352, 72},
    { 1176, 208, 280},
    { 1248, 56, 152},
    { 1184, 160, 80},
    { 1040, 360, -24},
    { 1144, 448, 128},
    { 1320, 656, 400},
    { 936, 792, 104},
    { 1064, 384, 96},
    { 1000, 472, -40},
    { 1064, 448, 40},
    // 100 seconds
    { 1208, 448, 136},
    { 1600, 400, 152},
    { 1544, 280, 104},
    { 1512, 128, 232},
    { 1512, -40, 200},
    { 1312, -80, 64},
    { 1072, 0, -8},
    { 824, 24, -8},
    { 872, 24, 32},
    { 1064, 80, 80},
    { 816, 96, 24},
    { 1120, 0, 8},
    { 1120, -80, 112},
    { 1200, 128, -152},
    { 1144, 88, -56},
    { 1240, 56, -96},
    { 1144, 120, -144},
    { 1216, 800, -264},
    { 1152, 264, -32},
    { 1320, 240, 192},
    { 1280, 320, 88},
    { 1152, 360, -48},
    { 1232, 360, 56},
    { 1384, 480, 208},
    { 992, 560, 144},
    // 101 seconds
    { 1096, 448, 88},
    { 904, 488, -72},
    { 928, 400, -8},
    { 1120, 416, 64},
    { 1416, 376, 112},
    { 1536, 280, 88},
    { 1480, 120, 144},
    { 1480, -8, 144},
    { 1368, -48, 64},
    { 1200, 16, -40},
    { 1000, 40, -40},
    { 816, 48, -80},
    { 832, -16, 8},
    { 792, -112, 40},
    { 720, -112, 24},
    { 1184, 16, -16},
    { 1168, 120, -112},
    { 1376, 144, -112},
    { 1480, 104, -40},
    { 1464, 120, -32},
    { 1200, 192, -184},
    { 1096, 248, -160},
    { 1024, 248, -32},
    { 1032, 216, 0},
    { 1032, 248, -72},
    // 102 seconds
    { 896, 280, -120},
    { 1216, 344, -32},
    { 1176, 480, 72},
    { 1064, 640, 112},
    { 1336, 440, -104},
    { 944, 248, -104},
    { 1016, 264, 40},
    { 1272, 376, 48},
    { 1520, 320, 64},
    { 1304, 168, 120},
    { 1248, 64, 176},
    { 1216, -16, 96},
    { 1136, -32, 8},
    { 1024, 32, -32},
    { 832, 40, 0},
    { 872, -24, 48},
    { 1072, -80, 56},
    { 800, -24, -72},
    { 1152, -144, -64},
    { 1344, -56, 32},
    { 1360, 104, -160},
    { 1328, 88, -224},
    { 1320, 112, -216},
    { 1096, 136, -120},
    { 1016, 136, -8},
    // 103 seconds
    { 1112, 200, 64},
    { 1168, 248, 8},
    { 1040, 288, -96},
    { 880, 264, -16},
    { 1240, 480, 168},
    { 920, 904, 152},
    { 920, 336, 96},
    { 1288, 368, 0},
    { 1112, 400, -40},
    { 1160, 408, 96},
    { 1440, 376, 200},
    { 1504, 272, 152},
    { 1392, 152, 160},
    { 1360, 40, 168},
    { 1312, -40, 48},
    { 1208, -24, -72},
    { 1024, 0, -72},
    { 896, -56, -8},
    { 1048, -144, 72},
    { 728, -128, -8},
    { 1008, -128, -80},
    { 1312, -40, 16},
    { 1312, 128, -104},
    { 1320, 136, -104},
    { 1416, 72, -120},
    // 104 seconds
    { 1200, 120, -24},
    { 1112, 152, -16},
    { 1120, 224, 96},
    { 1216, 280, 112},
    { 1224, 320, 0},
    { 1040, 328, 8},
    { 1176, 360, 136},
    { 1128, 624, 288},
    { 896, 632, 152},
    { 1208, 368, 88},
    { 952, 408, -32},
    { 1016, 416, 56},
    { 1272, 440, 144},
    { 1520, 376, 144},
    { 1392, 224, 152},
    { 1464, 72, 192},
    { 1496, -32, 112},
    { 1376, -48, 24},
    { 1168, 32, -56},
    { 936, 16, -96},
    { 1064, -96, 64},
    { 784, -160, 72},
    { 696, -96, -40},
    { 1136, -104, 56},
    { 1352, 80, -32},
    // 105 seconds
    { 1376, 144, -88},
    { 1328, 56, -16},
    { 1272, 96, -80},
    { 1024, 120, -112},
    { 1016, 104, -40},
    { 1240, 200, 32},
    { 1312, 280, 16},
    { 1200, 344, -72},
    { 992, 376, -72},
    { 1216, 496, 48},
    { 1040, 688, 40},
    { 1280, 448, 40},
    { 1056, 440, -104},
    { 1080, 312, -8},
    { 1248, 344, 72},
    { 1552, 320, 96},
    { 1432, 224, 48},
    { 1296, 112, 112},
    { 1280, 32, 128},
    { 1216, 16, -16},
    { 1056, 64, -120},
    { 880, 32, -128},
    { 960, -64, 32},
    { 1032, -80, -8},
    { 704, -56, -40},
    // 106 seconds
    { 1184, -64, 32},
    { 1248, 64, 8},
    { 1304, 184, -112},
    { 1288, 104, -64},
    { 1304, 80, -32},
    { 1040, 120, -72},
    { 960, 128, -80},
    { 1048, 184, -8},
    { 1160, 248, 32},
    { 1192, 304, -32},
    { 1080, 328, -104},
    { 1400, 360, -24},
    { 1224, 560, 160},
    { 1112, 680, 24},
    { 1128, 488, -72},
    { 976, 312, -96},
    { 1040, 328, 32},
    { 1432, 400, 112},
    { 1528, 312, 72},
    { 1304, 160, 104},
    { 1248, 56, 160},
    { 1240, -8, 72},
    { 1160, 0, 0},
    { 1008, 16, -16},
    { 840, 8, 16},
    // 107 seconds
    { 1016, -8, 24},
    { 968, -88, 24},
    { 784, -32, -48},
    { 1208, -32, -72},
    { 1384, 56, -72},
    { 1392, 128, -104},
    { 1376, 48, -64},
    { 1344, 56, -48},
    { 1120, 152, -112},
    { 1024, 192, -128},
    { 1040, 240, -32},
    { 1024, 296, -16},
    { 1064, 312, -80},
    { 1000, 320, -176},
    { 1096, 328, -56},
    { 1248, 512, 0},
    { 880, 528, 24},
    { 1160, 392, -40},
    { 1168, 416, -104},
    { 1296, 376, 8},
    { 1432, 336, 104},
    { 1600, 272, 112},
    { 1432, 192, 112},
    { 1352, 72, 168},
    { 1320, 0, 128},
    // 108 seconds
    { 1248, 8, 48},
    { 1112, 56, 0},
    { 888, 40, 0},
    { 752, -40, 8},
    { 920, -104, 80},
    { 616, -72, -24},
    { 984, 0, -152},
    { 1200, 0, 56},
    { 1400, 104, -48},
    { 1528, 152, -128},
    { 1552, 104, -96},
    { 1320, 176, -80},
    { 992, 144, -176},
    { 960, 144, -112},
    { 1016, 216, -72},
    { 1048, 264, -96},
    { 1064, 304, -192},
    { 968, 304, -120},
    { 1400, 440, -40},
    { 1024, 576, 16},
    { 1176, 424, -48},
    { 1200, 464, -112},
    { 1152, 344, -64},
    { 1256, 312, 64},
    { 1568, 272, 112},
    // 109 seconds
    { 1536, 200, 80},
    { 1312, 104, 104},
    { 1232, 16, 136},
    { 1184, 8, 24},
    { 1072, 48, -24},
    { 888, 48, -64},
    { 880, -48, -40},
    { 1032, -80, 48},
    { 728, -40, -80},
    { 1056, 16, -152},
    { 1232, 24, -32},
    { 1304, 112, -120},
    { 1392, 88, -128},
    { 1344, 32, -48},
    { 1208, 128, -72},
    { 1000, 184, -192},
    { 944, 168, -120},
    { 1056, 192, -24},
    { 1104, 248, -56},
    { 1096, 296, -160},
    { 1096, 304, -128},
    { 1376, 424, -48},
    { 936, 608, 8},
    { 1040, 384, -48},
    { 1080, 424, -120},
    // 110 seconds
    { 1040, 408, -72},
    { 1256, 344, 24},
    { 1464, 288, 96},
    { 1536, 216, 72},
    { 1368, 144, 88},
    { 1336, 48, 112},
    { 1280, 0, 24},
    { 1144, 8, -136},
    { 976, 16, -168},
    { 784, -56, -24},
    { 1016, -40, 0},
    { 784, 16, -184},
    { 1032, -40, -16},
    { 1088, -72, 128},
    { 1320, 168, -176},
    { 1328, 168, -88},
    { 1432, 88, -8},
    { 1224, 136, -24},
    { 984, 136, -120},
    { 1016, 192, -48},
    { 1072, 224, -16},
    { 1144, 248, -16},
    { 1144, 304, -120},
    { 1176, 320, -32},
    { 1296, 504, 96},
    // 111 seconds
    { 912, 696, 40},
    { 1168, 368, -24},
    { 1048, 496, -128},
    { 1072, 408, -8},
    { 1240, 408, 104},
    { 1568, 336, 120},
    { 1416, 192, 88},
    { 1360, 64, 152},
    { 1312, -16, 136},
    { 1216, 0, 24},
    { 1080, 56, -40},
    { 920, 48, 8},
    { 1040, -24, 120},
    { 976, -72, 64},
    { 888, -40, 40},
    { 1256, -152, 176},
    { 1336, 56, 40},
    { 1352, 112, -200},
    { 1344, 16, -40},
    { 1288, -16, -32},
    { 1080, 32, -80},
    { 1056, 176, -184},
    { 1088, 240, -128},
    { 1072, 312, -48},
    { 1112, 312, -152},
    // 112 seconds
    { 992, 304, -192},
    { 1192, 336, -64},
    { 1144, 488, -24},
    { 848, 424, 24},
    { 1208, 432, -80},
    { 1088, 480, -144},
    { 1304, 328, 32},
    { 1480, 256, 136},
    { 1688, 208, 88},
    { 1456, 144, 56},
    { 1296, 40, 80},
    { 1200, -8, 8},
    { 1072, 24, -120},
    { 880, 40, -152},
    { 688, -24, -112},
    { 688, -168, 24},
    { 808, -168, -48},
    { 968, -56, -152},
    { 1472, -104, 192},
    { 1728, 144, -24},
    { 1584, 216, -32},
    { 1408, 88, -48},
    { 1144, 136, -152},
    { 984, 96, -64},
    { 1120, 144, 72},
    // 113 seconds
    { 1256, 216, 136},
    { 1280, 304, 112},
    { 1152, 368, -24},
    { 960, 360, 96},
    { 1248, 680, 72},
    { 792, 712, 56},
    { 1248, 368, 136},
    { 1168, 568, -24},
    { 1168, 304, -48},
    { 1264, 336, 40},
    { 1584, 336, 80},
    { 1528, 296, 56},
    { 1480, 152, 176},
    { 1456, -8, 152},
    { 1288, -48, 32},
    { 1128, 16, 0},
    { 1016, 8, 56},
    { 1064, -40, 112},
    { 904, -40, 104},
    { 808, -40, 88},
    { 1136, -96, 128},
    { 1232, 40, 88},
    { 1280, 168, -112},
    { 1280, 96, -48},
    { 1312, 120, -88},
    // 114 seconds
    { 1160, 152, -152},
    { 1160, 128, -112},
    { 1304, 184, -8},
    { 1288, 296, 72},
    { 1136, 328, -80},
    { 1104, 328, -72},
    { 1352, 472, 0},
    { 952, 656, 80},
    { 1208, 448, -64},
    { 1248, 528, -112},
    { 1064, 424, -120},
    { 1072, 392, 8},
    { 1520, 352, 48},
    { 1424, 176, 96},
    { 1328, 0, 136},
    { 1360, -64, 80},
    { 1368, 8, 24},
    { 1304, 96, 64},
    { 1104, 88, 144},
    { 1112, 24, 104},
    { 880, -112, 72},
    { 776, -216, -64},
    { 1160, -248, 112},
    { 1296, -8, -64},
    { 1328, 80, -248},
    // 115 seconds
    { 1272, -24, -128},
    { 1280, -8, -176},
    { 1144, 56, -200},
    { 1104, 120, -168},
    { 1336, 256, -168},
    { 1304, 496, -104},
    { 1080, 584, -328},
    { 1008, 112, -120},
    { 1288, 408, -32},
    { 1000, 504, 8},
    { 1080, 472, 88},
    { 1160, 648, -64},
    { 1208, 472, -40},
    { 1304, 336, 88},
    { 1648, 296, 168},
    { 1552, 168, 120},
    { 1392, 40, 112},
    { 1360, -24, 104},
    { 1264, 24, 0},
    { 1096, 96, -96},
    { 904, 64, -152},
    { 848, -112, -80},
    { 880, -176, -32},
    { 576, -144, -112},
    { 1064, -72, -88},
    // 116 seconds
    { 1328, -16, 0},
    { 1360, 152, -112},
    { 1488, 128, -96},
    { 1504, 88, -112},
    { 1272, 152, -96},
    { 1112, 168, -128},
    { 1168, 248, -8},
    { 1184, 272, 16},
    { 1128, 280, -72},
    { 1000, 296, -112},
    { 1032, 320, -24},
    { 1216, 480, 176},
    { 968, 664, 112},
    { 1312, 528, 48},
    { 1056, 360, -64},
    { 1152, 296, 40},
    { 1296, 376, 128},
    { 1536, 304, 112},
    { 1320, 192, 80},
    { 1256, 96, 152},
    { 1224, 8, 80},
    { 1128, 0, 24},
    { 1016, 16, 0},
    { 848, 0, 0},
    { 1072, 0, 64},
    // 117 seconds
    { 1080, -32, 88},
    { 840, -64, 104},
    { 1344, -128, 144},
    { 1400, 120, -96},
    { 1360, 216, -232},
    { 1312, 32, -56},
    { 1232, -48, -16},
    { 960, -24, 88},
    { 960, 264, -336},
    { 992, 208, -136},
    { 1032, 248, -8},
    { 1032, 344, -80},
    { 896, 360, -144},
    { 1336, 352, -104},
    { 1184, 464, -24},
    { 1032, 448, -16},
    { 1216, 528, -144},
    { 1032, 416, -144},
    { 1224, 336, 8},
    { 1528, 304, 104},
    { 1672, 192, 64},
    { 1384, 112, 72},
    { 1512, 272, 112},
    { 1816, 712, 0},
    { 1952, 1328, 176},
    // 118 seconds
    { 1536, 1416, 368},
    { 1112, 1432, 432},
    { 640, 824, 208},
    { 136, 184, 136},
    { -112, 56, -56},
    { -272, -176, -248},
    { -456, -128, -384},
    { -480, -48, -264},
    { -576, 144, -192},
    { -664, 336, -48},
    { -840, 368, -32},
    { -848, 376, -40},
    { -792, 368, -104},
    { -736, 432, -184},
    { -736, 496, -88},
    { -864, 464, 8},
    { -920, 592, -48},
    { -936, 560, 16},
    { -1000, 648, 80},
    { -776, 664, 24},
    { -992, 520, 72},
    { -952, 656, 88},
    { -832, 528, -200},
    { -856, 528, -136},
    { -584, 384, 16},
    // 119 seconds
    { -840, 136, 168},
    { -928, 192, 40},
    { -1008, 288, 24},
    { -800, 128, -400},
    { -560, 80, -744},
    { -232, -232, -1136},
    { 56, -176, -1240},
    { 184, -64, -1392},
    { 160, -16, -1424},
    { 224, 8, -1448},
    { 296, -56, -1392},
    { 272, -152, -1208},
    { 200, -104, -1008},
    { 88, -80, -872},
    { -32, -136, -792},
    { -72, -128, -776},
    { -72, -168, -808},
    { -40, -128, -864},
    { -32, -96, -936},
    { -104, -112, -976},
    { -192, -128, -1048},
    { -128, -24, -1144},
    { -224, 104, -1104},
    { -200, 136, -992},
    { -8, 184, -944},
    // 120 seconds
    // elapsed: 2 minutes
    { 8, 224, -864},
    { -16, 392, -832},
    { 8, 648, -928},
    { 120, 736, -936},
    { 0, 776, -744},
    { -248, 888, -456},
    { -288, 1000, -376},
    { -208, 1056, -264},
    { -208, 1168, -248},
    { 32, 584, -432},
    { -88, 872, -400},
    { -56, 1032, -376},
    { -104, 1032, -360},
    { -56, 1240, -272},
    { 56, 1200, -128},
    { 72, 1080, -416},
    { -24, 912, -392},
    { -96, 760, -360},
    { -184, 736, -504},
    { -160, 584, -584},
    { -192, 504, -608},
    { -240, 40, -768},
    { -224, 440, -864},
    { -224, 176, -848},
    { -256, 144, -840},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

