/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */



// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:19:54 local
AccelRawData *activity_sample_walk_200_pbl_25301_7(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25301_7
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 120
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 144, 144, -1056},
    { 160, 56, -1072},
    { 192, 16, -1048},
    { 232, 8, -1096},
    { 256, -48, -1112},
    { 272, -80, -904},
    { 104, 24, -1016},
    { 72, 120, -1024},
    { 48, -56, -968},
    { 0, -56, -1040},
    { 72, -64, -984},
    { 48, 120, -1000},
    { 24, 0, -1024},
    { 160, -56, -1104},
    { 32, 40, -992},
    { 112, 8, -1144},
    { -72, 24, -1016},
    { 8, -56, -960},
    { 16, -48, -944},
    { -16, -80, -992},
    { -8, -120, -1144},
    { -136, 64, -1096},
    { 272, 16, -1048},
    { 0, -80, -1000},
    { 16, -88, -984},
    // 1 seconds
    { 0, 56, -1008},
    { 24, 0, -1040},
    { 0, 16, -1072},
    { -16, 56, -1064},
    { -32, 56, -1024},
    { -40, 96, -1016},
    { -64, 72, -1040},
    { -64, 96, -1040},
    { -56, 104, -1032},
    { -48, 56, -1024},
    { -40, -24, -992},
    { 0, 96, -1032},
    { -24, 80, -1096},
    { -56, 56, -1008},
    { -24, 112, -992},
    { -48, 128, -960},
    { -8, 144, -1032},
    { -56, 192, -944},
    { -8, 88, -912},
    { -8, 152, -960},
    { 8, 152, -1072},
    { 32, 88, -1096},
    { 0, 176, -1120},
    { 16, 168, -1136},
    { 0, 240, -1088},
    // 2 seconds
    { -80, 120, -992},
    { -104, 56, -944},
    { -88, 80, -904},
    { -48, 112, -936},
    { -56, 120, -976},
    { -64, 216, -984},
    { -64, 312, -1064},
    { -56, 400, -1056},
    { -104, 536, -1016},
    { -176, 696, -944},
    { -272, 904, -856},
    { -368, 968, -728},
    { -352, 864, -624},
    { -392, 728, -456},
    { -448, 696, -328},
    { -536, 800, -248},
    { -488, 744, -296},
    { -472, 672, -352},
    { -560, 672, -592},
    { -608, 896, -600},
    { -664, 1312, -440},
    { -568, 536, -432},
    { -536, -96, -512},
    { -408, 24, -768},
    { 24, 136, -712},
    // 3 seconds
    { 344, 192, -648},
    { 712, 312, -440},
    { 1192, 576, -208},
    { 1632, 336, 144},
    { 2072, 336, -56},
    { 2016, 584, -136},
    { 1632, 544, -64},
    { 1592, 432, -80},
    { 1488, 448, -96},
    { 1512, 528, -80},
    { 1400, 560, 24},
    { 1296, 584, 40},
    { 1248, 616, 48},
    { 1448, 712, 0},
    { 1496, 840, 0},
    { 1056, 920, -56},
    { 904, 928, -80},
    { 672, 832, -72},
    { 656, 744, -72},
    { 792, 712, -64},
    { 1216, 776, 16},
    { 1880, 688, 104},
    { 2008, 392, 152},
    { 1936, 264, 96},
    { 1880, 232, 64},
    // 4 seconds
    { 1744, 360, 24},
    { 1512, 464, 64},
    { 1464, 368, 8},
    { 1344, 240, -104},
    { 1256, -40, 0},
    { 784, -416, 160},
    { 808, 64, -40},
    { 824, -8, -160},
    { 1080, 152, -160},
    { 1256, 384, -264},
    { 1280, 392, -256},
    { 1344, 368, -216},
    { 1536, 416, -232},
    { 1560, 520, -224},
    { 1464, 648, -192},
    { 1744, 744, -328},
    { 1472, 856, -424},
    { 1152, 928, -400},
    { 1016, 824, -416},
    { 960, 592, -256},
    { 1072, 504, -136},
    { 1288, 496, -64},
    { 1448, 432, -80},
    { 1296, 328, -80},
    { 1272, 264, -80},
    // 5 seconds
    { 1344, 176, -288},
    { 1264, 232, -96},
    { 1208, 328, 40},
    { 1392, 408, -248},
    { 1232, 360, -512},
    { 1080, 176, -352},
    { 952, -32, 40},
    { 792, -48, -88},
    { 1056, 216, -264},
    { 1184, 328, -232},
    { 1240, 344, -280},
    { 1072, 312, -168},
    { 1064, 320, -136},
    { 1264, 416, -96},
    { 1384, 528, -112},
    { 1328, 608, -160},
    { 1584, 752, -96},
    { 1296, 896, -96},
    { 1088, 752, -32},
    { 1056, 816, -88},
    { 920, 712, -48},
    { 1008, 648, -24},
    { 1272, 600, 16},
    { 1472, 464, 16},
    { 1304, 336, 32},
    // 6 seconds
    { 1224, 264, 8},
    { 1192, 280, -24},
    { 1168, 336, -56},
    { 1120, 320, -8},
    { 1480, 296, -80},
    { 1160, 272, -184},
    { 1128, 72, -120},
    { 1128, -56, 104},
    { 1144, 128, -96},
    { 1128, 296, -272},
    { 1256, 296, -248},
    { 1160, 280, -264},
    { 968, 240, -208},
    { 1016, 288, -120},
    { 1152, 416, -72},
    { 1248, 552, -32},
    { 1208, 640, -32},
    { 1504, 640, -104},
    { 1368, 680, -8},
    { 1248, 712, 24},
    { 1128, 808, -56},
    { 968, 744, -120},
    { 832, 568, -104},
    { 1080, 624, -24},
    { 1336, 496, -8},
    // 7 seconds
    { 1264, 288, 16},
    { 1240, 208, -16},
    { 1304, 248, -64},
    { 1360, 328, -80},
    { 1344, 360, -8},
    { 1544, 352, -104},
    { 1248, 256, -176},
    { 1144, -152, -80},
    { 896, -232, 120},
    { 1040, 184, -120},
    { 1112, 296, -176},
    { 1256, 304, -184},
    { 1088, 320, -176},
    { 968, 280, -176},
    { 1024, 312, -152},
    { 1072, 376, -96},
    { 1120, 464, -80},
    { 1144, 520, -136},
    { 1600, 624, -96},
    { 1360, 672, 0},
    { 1088, 560, -56},
    { 1208, 672, -80},
    { 944, 848, -104},
    { 1008, 792, -136},
    { 1120, 632, -72},
    // 8 seconds
    { 1248, 592, -56},
    { 1288, 416, 40},
    { 1280, 104, 88},
    { 1296, 64, 16},
    { 1320, 248, -88},
    { 1184, 320, -24},
    { 1328, 336, -8},
    { 1184, 344, -72},
    { 1080, 144, -64},
    { 1096, -200, 240},
    { 1160, 56, 72},
    { 1288, 336, -232},
    { 1248, 248, -184},
    { 1040, 248, -184},
    { 832, 200, -200},
    { 952, 248, -152},
    { 1144, 368, -48},
    { 1360, 520, -8},
    { 1416, 720, 8},
    { 1672, 824, -176},
    { 1280, 816, -72},
    { 1096, 776, -56},
    { 944, 792, -152},
    { 1088, 696, -144},
    { 1184, 624, -80},
    // 9 seconds
    { 1424, 616, -40},
    { 1480, 376, -16},
    { 1320, 256, -16},
    { 1344, 224, -24},
    { 1392, 288, -72},
    { 1296, 336, -96},
    { 1232, 304, -16},
    { 1360, 288, -144},
    { 912, 192, -184},
    { 744, 32, -136},
    { 920, 40, -32},
    { 720, 184, -72},
    { 1104, 264, -176},
    { 1528, 400, -216},
    { 1328, 440, -200},
    { 1008, 312, -168},
    { 1024, 344, -216},
    { 1096, 376, -88},
    { 1200, 408, -144},
    { 1328, 448, -104},
    { 1760, 688, -72},
    { 1304, 920, -24},
    { 1264, 1296, -224},
    { 1088, 600, -208},
    { 1072, 504, -136},
    // 10 seconds
    { 1000, 608, -88},
    { 1336, 624, -64},
    { 1408, 432, -48},
    { 1256, 264, -40},
    { 1264, 208, -16},
    { 1320, 272, -72},
    { 1208, 328, -80},
    { 1208, 320, 8},
    { 1328, 336, -112},
    { 976, 272, -192},
    { 1192, 160, -176},
    { 840, 16, 32},
    { 1024, 152, -120},
    { 1248, 264, -168},
    { 1296, 344, -208},
    { 1096, 328, -208},
    { 944, 304, -224},
    { 1016, 336, -96},
    { 1200, 408, -64},
    { 1288, 544, -104},
    { 1288, 592, -80},
    { 1648, 776, -96},
    { 1256, 864, -112},
    { 1160, 736, -40},
    { 968, 744, -112},
    // 11 seconds
    { 1128, 640, -120},
    { 1056, 608, -96},
    { 1256, 616, -40},
    { 1400, 528, -24},
    { 1296, 344, 40},
    { 1272, 240, 56},
    { 1312, 240, -8},
    { 1280, 296, -48},
    { 1136, 304, -24},
    { 1240, 280, -64},
    { 1120, 232, -112},
    { 992, 128, -104},
    { 1080, 88, -80},
    { 856, 120, -40},
    { 1008, 256, -136},
    { 1272, 320, -264},
    { 1280, 336, -256},
    { 1088, 296, -224},
    { 960, 280, -184},
    { 1056, 344, -176},
    { 1168, 424, -176},
    { 1184, 496, -152},
    { 1440, 600, -80},
    { 1672, 848, -16},
    { 1080, 728, -88},
    // 12 seconds
    { 1264, 648, -56},
    { 960, 680, -120},
    { 952, 592, -120},
    { 960, 616, -64},
    { 1216, 648, -32},
    { 1424, 480, 8},
    { 1352, 200, 64},
    { 1256, 112, 24},
    { 1264, 184, -40},
    { 1128, 312, -48},
    { 1024, 360, -32},
    { 1272, 344, -88},
    { 1016, 312, -208},
    { 1088, 112, -144},
    { 1008, 32, 0},
    { 976, 120, -104},
    { 1088, 248, -232},
    { 1280, 320, -240},
    { 1168, 288, -232},
    { 952, 248, -152},
    { 952, 312, -168},
    { 992, 384, -120},
    { 1128, 456, -88},
    { 1216, 520, -104},
    { 1736, 632, -88},
    // 13 seconds
    { 1368, 832, -48},
    { 1144, 976, -256},
    { 1064, 608, -200},
    { 976, 592, -184},
    { 952, 640, -144},
    { 1216, 552, -32},
    { 1408, 440, -32},
    { 1288, 312, -40},
    { 1216, 224, 16},
    { 1336, 304, -48},
    { 1312, 352, -64},
    { 1160, 352, 8},
    { 1416, 304, -72},
    { 1064, 264, -168},
    { 1016, 96, -144},
    { 928, -48, 88},
    { 976, 112, -112},
    { 1120, 296, -192},
    { 1312, 328, -184},
    { 1184, 344, -200},
    { 952, 304, -232},
    { 952, 312, -176},
    { 1072, 376, -72},
    { 1224, 472, -88},
    { 1344, 544, -168},
    // 14 seconds
    { 1800, 672, -136},
    { 1368, 896, -40},
    { 1176, 848, -248},
    { 896, 632, -208},
    { 912, 560, -192},
    { 984, 584, -136},
    { 1216, 592, -40},
    { 1416, 440, -8},
    { 1304, 296, -16},
    { 1240, 224, 8},
    { 1280, 256, -8},
    { 1296, 360, -32},
    { 1056, 328, -64},
    { 1104, 256, -24},
    { 1128, 264, -104},
    { 872, 688, -392},
    { 1128, 1952, -824},
    { 808, 552, -1080},
    { 688, -48, -968},
    { 632, 144, -800},
    { 552, 40, -784},
    { 416, -128, -720},
    { 232, -176, -640},
    { 80, -216, -560},
    { -24, -160, -584},
    // 15 seconds
    { -40, -168, -752},
    { -160, -208, -880},
    { -152, -144, -1088},
    { -160, -128, -1088},
    { -256, -64, -1072},
    { -144, 248, -1136},
    { -104, 48, -1136},
    { -96, -88, -992},
    { 8, -80, -1024},
    { 88, -32, -1000},
    { 136, -128, -840},
    { 104, -272, -672},
    { 88, -360, -560},
    { 104, -440, -504},
    { 136, -440, -424},
    { 384, -352, -464},
    { 848, 184, -752},
    { 1384, 288, -704},
    { 1832, 480, -128},
    { 1800, 992, 200},
    { 1544, 1128, 0},
    { 1440, 952, -304},
    { 1480, 672, -384},
    { 1312, 648, -152},
    { 1208, 672, 264},
    // 16 seconds
    { 1152, 528, 280},
    { 1256, 456, 160},
    { 1144, 536, -56},
    { 1184, 584, -8},
    { 1200, 768, 120},
    { 872, 856, -40},
    { 1128, 920, -48},
    { 880, 936, -128},
    { 1168, 656, -48},
    { 1376, 624, 16},
    { 1664, 592, 8},
    { 1648, 408, 0},
    { 1600, 232, 64},
    { 1552, 232, 8},
    { 1392, 288, -16},
    { 1168, 336, 8},
    { 1128, 256, 16},
    { 1064, 200, 8},
    { 880, 168, -88},
    { 1056, 80, -40},
    { 888, 120, -40},
    { 1040, 264, -192},
    { 1184, 280, -168},
    { 1416, 360, -144},
    { 1296, 392, -128},
    // 17 seconds
    { 1136, 368, -200},
    { 1200, 432, -96},
    { 1312, 464, 16},
    { 1312, 536, -32},
    { 1288, 568, -64},
    { 1560, 712, 16},
    { 1168, 1016, -8},
    { 1072, 1016, -232},
    { 976, 688, -256},
    { 1104, 808, -296},
    { 1216, 952, -208},
    { 1800, 824, -48},
    { 1936, 712, 24},
    { 1808, 288, -112},
    { 1592, 464, -184},
    { 1424, 480, -288},
    { 1136, 464, -336},
    { 816, 448, -392},
    { 672, 176, -528},
    { 448, 24, -648},
    { 376, 80, -808},
    { 312, -120, -976},
    { 280, -8, -1008},
    { 344, -64, -880},
    { 336, -32, -808},
    // 18 seconds
    { 280, -48, -792},
    { 144, -48, -752},
    { 56, -136, -752},
    { -8, -144, -800},
    { -56, -104, -840},
    { -72, -96, -920},
    { -80, -144, -1008},
    { -24, -128, -1152},
    { -32, -72, -1240},
    { -160, 8, -1256},
    { -120, 200, -1272},
    { -88, 288, -1256},
    { -112, 192, -1088},
    { -24, 208, -1024},
    { 56, 88, -936},
    { 0, 24, -784},
    { -56, 8, -720},
    { -80, 0, -784},
    { -56, -32, -888},
    { -16, 16, -936},
    { 40, 16, -984},
    { 104, 144, -1104},
    { 32, 240, -1144},
    { 360, 152, -1080},
    { 528, 240, -896},
    // 19 seconds
    { 712, 136, -632},
    { 904, 24, -376},
    { 992, 272, -264},
    { 976, 472, -168},
    { 936, 576, -72},
    { 968, 504, -8},
    { 1072, 1056, 176},
    { 1312, 920, -96},
    { 1352, 520, 208},
    { 1832, 752, 0},
    { 1848, 896, 40},
    { 1184, 960, 0},
    { 1216, 456, -64},
    { 1056, 976, -144},
    { 744, 928, -272},
    { 960, 880, -296},
    { 1128, 760, -208},
    { 1456, 480, -24},
    { 1352, 336, -24},
    { 1464, 232, -72},
    { 1584, 360, -128},
    { 1448, 416, -128},
    { 1344, 344, -48},
    { 1360, 288, 0},
    { 1256, 280, -64},
    // 20 seconds
    { 1040, 80, 8},
    { 1040, -336, 280},
    { 1160, 0, 96},
    { 1344, 216, -200},
    { 1264, 184, -56},
    { 1376, 208, -24},
    { 1448, 256, -72},
    { 1560, 440, -200},
    { 1536, 560, -96},
    { 1328, 624, 160},
    { 1224, 664, -120},
    { 1184, 440, -24},
    { 1064, 456, 32},
    { 1432, 792, 112},
    { 912, 864, 88},
    { 1184, 760, 8},
    { 1040, 760, -104},
    { 1032, 624, -144},
    { 1072, 576, -48},
    { 1456, 648, 88},
    { 1760, 560, 56},
    { 1664, 392, 48},
    { 1600, 240, 88},
    { 1496, 232, 80},
    { 1288, 288, 8},
    // 21 seconds
    { 1088, 304, -56},
    { 912, 240, -72},
    { 992, 216, -64},
    { 856, 160, -160},
    { 1136, 152, -144},
    { 1032, 144, -96},
    { 1232, 224, -192},
    { 1376, 256, -144},
    { 1480, 336, -96},
    { 1368, 376, -80},
    { 1240, 408, -192},
    { 1192, 488, -120},
    { 1200, 464, 8},
    { 1232, 480, 8},
    { 1152, 472, -40},
    { 1120, 496, -8},
    { 1448, 680, 144},
    { 1048, 888, 272},
    { 1120, 824, -64},
    { 1040, 656, -16},
    { 984, 688, -128},
    { 928, 640, -24},
    { 1216, 712, 40},
    { 1648, 560, 64},
    { 1536, 360, 64},
    // 22 seconds
    { 1464, 224, 72},
    { 1400, 216, 32},
    { 1304, 280, 8},
    { 1160, 296, 72},
    { 1152, 296, 56},
    { 1264, 328, -8},
    { 952, 256, -8},
    { 1232, 216, 16},
    { 960, 128, 0},
    { 1024, 232, -112},
    { 1072, 248, -128},
    { 1168, 288, -144},
    { 1144, 296, -136},
    { 1080, 336, -176},
    { 1088, 376, -200},
    { 1136, 400, -184},
    { 1200, 424, -224},
    { 1088, 496, -216},
    { 1224, 536, -160},
    { 1656, 632, -152},
    { 1152, 616, -56},
    { 1304, 656, -104},
    { 976, 728, -160},
    { 1008, 656, -128},
    { 1032, 568, -64},
    // 23 seconds
    { 1304, 568, -8},
    { 1448, 392, 24},
    { 1232, 264, 40},
    { 1160, 216, 32},
    { 1192, 256, 8},
    { 1128, 320, 0},
    { 1008, 328, 48},
    { 1232, 288, 8},
    { 1240, 296, -24},
    { 1280, 144, -96},
    { 1288, -328, 392},
    { 976, 64, 8},
    { 1168, 400, -416},
    { 1336, 256, -352},
    { 1528, 272, -472},
    { 1240, 240, -288},
    { 1008, 240, -152},
    { 888, 464, -136},
    { 944, 472, -232},
    { 1016, 352, -120},
    { 1264, 496, -8},
    { 1520, 752, 32},
    { 968, 720, 136},
    { 1368, 744, -24},
    { 1040, 808, -88},
    // 24 seconds
    { 1272, 632, -32},
    { 1312, 584, 96},
    { 1488, 616, 128},
    { 1512, 408, 48},
    { 1344, 184, 112},
    { 1312, 200, 40},
    { 1264, 216, -48},
    { 1104, 304, -80},
    { 1048, 240, -48},
    { 1152, 240, -40},
    { 864, 176, -120},
    { 1080, 152, -104},
    { 1008, 176, -32},
    { 1184, 288, -120},
    { 1384, 352, -160},
    { 1568, 392, -160},
    { 1288, 400, -96},
    { 1016, 344, -176},
    { 936, 384, -112},
    { 1040, 392, -48},
    { 1152, 464, -104},
    { 976, 496, -152},
    { 1328, 568, -56},
    { 1488, 752, 8},
    { 1064, 832, -32},
    // 25 seconds
    { 1112, 760, -168},
    { 1088, 640, -152},
    { 1056, 560, -112},
    { 1192, 592, 0},
    { 1512, 496, 40},
    { 1456, 352, 0},
    { 1296, 264, 8},
    { 1232, 248, -16},
    { 1192, 280, -72},
    { 1080, 288, -80},
    { 1000, 216, -72},
    { 1136, 216, -88},
    { 976, 216, -192},
    { 1192, 184, -136},
    { 1096, 176, -80},
    { 1224, 272, -136},
    { 1352, 328, -176},
    { 1392, 328, -144},
    { 1144, 344, -80},
    { 960, 344, -184},
    { 928, 376, -128},
    { 984, 392, -40},
    { 1056, 464, -48},
    { 1008, 488, -136},
    { 1288, 552, -128},
    // 26 seconds
    { 1536, 728, -72},
    { 1040, 680, -80},
    { 1344, 648, -96},
    { 888, 760, -176},
    { 1104, 632, -120},
    { 1224, 584, -48},
    { 1384, 576, -40},
    { 1368, 456, 16},
    { 1296, 272, 88},
    { 1280, 216, 64},
    { 1288, 248, 16},
    { 1192, 272, -16},
    { 1064, 264, -24},
    { 1200, 264, -8},
    { 1040, 272, -88},
    { 1104, 192, -136},
    { 1064, 136, 0},
    { 936, 184, -120},
    { 1112, 280, -184},
    { 1376, 296, -192},
    { 1344, 344, -168},
    { 1104, 336, -168},
    { 992, 360, -200},
    { 992, 400, -104},
    { 1096, 480, -96},
    // 27 seconds
    { 1056, 496, -168},
    { 1208, 520, -152},
    { 1736, 704, -104},
    { 1144, 704, -16},
    { 1336, 656, -80},
    { 904, 664, -136},
    { 1032, 624, -112},
    { 1120, 576, -56},
    { 1392, 560, 8},
    { 1496, 408, 24},
    { 1328, 264, 32},
    { 1224, 240, 8},
    { 1200, 248, -64},
    { 1080, 296, -88},
    { 968, 288, -56},
    { 1008, 232, -96},
    { 1072, 208, -160},
    { 944, 128, -168},
    { 1240, 112, -24},
    { 1096, 208, -88},
    { 1312, 328, -264},
    { 1520, 344, -200},
    { 1408, 352, -88},
    { 1096, 312, -104},
    { 968, 360, -160},
    // 28 seconds
    { 992, 432, -56},
    { 1104, 488, -48},
    { 1096, 528, -128},
    { 1216, 568, -64},
    { 1504, 808, 56},
    { 1088, 752, -72},
    { 1240, 600, 8},
    { 992, 760, -128},
    { 1144, 680, -80},
    { 1176, 632, -8},
    { 1472, 608, 64},
    { 1520, 400, 64},
    { 1376, 224, 56},
    { 1336, 200, 40},
    { 1336, 272, -24},
    { 1216, 328, -48},
    { 1048, 296, -48},
    { 1048, 248, -48},
    { 944, 192, -88},
    { 848, 136, -128},
    { 1120, 200, -96},
    { 1104, 200, -96},
    { 1352, 304, -144},
    { 1592, 336, -192},
    { 1424, 392, -136},
    // 29 seconds
    { 1168, 360, -192},
    { 1056, 416, -200},
    { 1080, 432, -112},
    { 1088, 464, -168},
    { 1048, 488, -168},
    { 1120, 536, -136},
    { 1456, 728, -48},
    { 1216, 728, -56},
    { 976, 504, -64},
    { 1184, 632, -56},
    { 1064, 760, -88},
    { 1104, 640, -64},
    { 1288, 544, 64},
    { 1504, 416, 56},
    { 1376, 296, 32},
    { 1264, 264, 16},
    { 1232, 264, 0},
    { 1160, 320, -32},
    { 1032, 320, 8},
    { 960, 256, -16},
    { 1096, 272, -104},
    { 896, 232, -160},
    { 1208, 168, -168},
    { 1208, 160, -56},
    { 1232, 200, -160},
    // 30 seconds
    { 1400, 304, -296},
    { 1360, 368, -368},
    { 1032, 312, -192},
    { 912, 248, -168},
    { 1064, 352, -120},
    { 1224, 472, -56},
    { 1128, 568, -120},
    { 984, 576, -104},
    { 1312, 696, -32},
    { 1152, 736, -16},
    { 1056, 616, 8},
    { 1216, 824, -96},
    { 1184, 688, -112},
    { 1120, 552, -8},
    { 1416, 576, 80},
    { 1616, 456, 88},
    { 1432, 312, 80},
    { 1264, 232, 120},
    { 1248, 256, -24},
    { 1120, 296, -64},
    { 888, 304, -72},
    { 824, 224, -104},
    { 944, 208, -112},
    { 864, 200, -184},
    { 1120, 224, -136},
    // 31 seconds
    { 1032, 248, -112},
    { 1296, 336, -104},
    { 1368, 408, -200},
    { 1312, 424, -88},
    { 976, 344, -64},
    { 824, 240, -72},
    { 768, 304, -96},
    { 848, 384, -112},
    { 992, 424, -96},
    { 1184, 384, -176},
    { 1184, 392, -136},
    { 1136, 408, -168},
    { 1600, 520, -144},
    { 1392, 608, -192},
    { 1336, 624, -248},
    { 976, 576, -336},
    { 952, 488, -272},
    { 832, 536, -144},
    { 1088, 496, -72},
    { 1256, 352, -56},
    { 1152, 256, -88},
    { 1128, 264, -56},
    { 1168, 304, -48},
    { 1184, 352, -64},
    { 1072, 336, -48},
    // 32 seconds
    { 1144, 296, -80},
    { 1264, 288, -216},
    { 1080, 120, -208},
    { 1176, 32, 8},
    { 992, 120, -96},
    { 1088, 296, -256},
    { 1192, 296, -216},
    { 1112, 296, -152},
    { 904, 248, -160},
    { 824, 280, -168},
    { 912, 320, -112},
    { 1040, 384, -72},
    { 1016, 424, -104},
    { 976, 456, -144},
    { 1456, 584, -128},
    { 1344, 712, -104},
    { 1224, 768, -184},
    { 1200, 680, -216},
    { 1008, 528, -248},
    { 784, 496, -200},
    { 1000, 568, -96},
    { 1240, 544, -64},
    { 1272, 344, -8},
    { 1208, 208, 8},
    { 1240, 216, -8},
    // 33 seconds
    { 1240, 288, -40},
    { 1096, 336, -32},
    { 1032, 304, -64},
    { 1192, 304, -96},
    { 1000, 288, -160},
    { 1224, 224, -152},
    { 1008, 184, -136},
    { 1016, 176, -96},
    { 1008, 240, -288},
    { 1120, 272, -288},
    { 1120, 296, -352},
    { 904, 232, -296},
    { 840, 240, -232},
    { 912, 304, -216},
    { 1000, 400, -200},
    { 1056, 448, -184},
    { 1088, 488, -168},
    { 1552, 608, -80},
    { 1304, 664, -56},
    { 1304, 616, -24},
    { 1024, 664, -128},
    { 1024, 696, -136},
    { 848, 576, -96},
    { 1056, 608, 16},
    { 1280, 432, 24},
    // 34 seconds
    { 1184, 256, 32},
    { 1088, 216, 0},
    { 1128, 248, -40},
    { 1152, 336, -56},
    { 1136, 352, -32},
    { 1216, 304, -56},
    { 1344, 296, -160},
    { 1120, 176, -192},
    { 1360, 48, -8},
    { 952, 24, -32},
    { 1064, 248, -240},
    { 1184, 296, -296},
    { 1184, 272, -200},
    { 920, 232, -144},
    { 768, 256, -144},
    { 816, 336, -80},
    { 960, 408, -8},
    { 1216, 504, -24},
    { 1296, 536, -32},
    { 1592, 616, -32},
    { 1328, 848, -64},
    { 912, 808, -232},
    { 1296, 568, -56},
    { 952, 664, -176},
    { 1008, 600, -136},
    // 35 seconds
    { 1136, 616, -56},
    { 1320, 504, -24},
    { 1248, 336, -24},
    { 1184, 240, 16},
    { 1272, 248, -16},
    { 1312, 312, -56},
    { 1192, 344, -40},
    { 1272, 296, -80},
    { 1192, 264, -200},
    { 904, 40, -184},
    { 1168, -64, -24},
    { 904, 88, -104},
    { 1048, 264, -224},
    { 1232, 272, -216},
    { 1392, 328, -248},
    { 1152, 304, -200},
    { 960, 288, -160},
    { 1000, 368, -128},
    { 1040, 424, -80},
    { 1112, 464, -104},
    { 1192, 480, -96},
    { 1632, 640, 64},
    { 1248, 888, 80},
    { 1048, 944, -48},
    { 960, 696, -32},
    // 36 seconds
    { 976, 616, -16},
    { 896, 600, -32},
    { 1104, 664, 96},
    { 1360, 560, 104},
    { 1344, 360, 48},
    { 1272, 232, 48},
    { 1336, 248, 8},
    { 1320, 320, -80},
    { 1160, 360, -80},
    { 1240, 336, -96},
    { 1096, 336, -224},
    { 888, 224, -312},
    { 1128, 88, -96},
    { 880, 72, -64},
    { 984, 208, -176},
    { 1240, 312, -240},
    { 1344, 424, -240},
    { 1104, 360, -184},
    { 912, 304, -168},
    { 936, 344, -104},
    { 1080, 392, -96},
    { 1088, 400, -80},
    { 1168, 424, 64},
    { 1680, 584, 128},
    { 1304, 752, 136},
    // 37 seconds
    { 1120, 784, -24},
    { 1088, 1016, -112},
    { 864, 656, -112},
    { 880, 488, -24},
    { 1048, 640, 0},
    { 1400, 480, 0},
    { 1336, 320, -16},
    { 1208, 168, 56},
    { 1264, 248, -16},
    { 1288, 312, -24},
    { 1168, 376, -16},
    { 1216, 336, -32},
    { 1160, 272, -120},
    { 936, -32, -48},
    { 1120, -80, 0},
    { 1016, 176, -168},
    { 1080, 264, -144},
    { 1312, 288, -216},
    { 1392, 360, -224},
    { 1120, 312, -200},
    { 928, 280, -176},
    { 976, 328, -136},
    { 1088, 392, -152},
    { 1192, 464, -128},
    { 1128, 520, -152},
    // 38 seconds
    { 1312, 600, -48},
    { 1336, 760, 24},
    { 1024, 744, -48},
    { 1128, 600, -96},
    { 984, 624, -104},
    { 992, 592, -56},
    { 1200, 592, 40},
    { 1384, 464, 32},
    { 1272, 344, 8},
    { 1240, 256, 16},
    { 1272, 256, -24},
    { 1232, 304, -48},
    { 1112, 304, -32},
    { 1144, 264, -32},
    { 1192, 240, -136},
    { 1024, 136, -160},
    { 1296, 88, -112},
    { 1072, 96, -96},
    { 1224, 280, -240},
    { 1320, 280, -216},
    { 1216, 296, -248},
    { 976, 272, -232},
    { 872, 272, -104},
    { 920, 328, -96},
    { 968, 408, -32},
    // 39 seconds
    { 1048, 488, -48},
    { 1248, 544, 0},
    { 1704, 728, 24},
    { 1160, 824, -72},
    { 1440, 832, -40},
    { 912, 704, -112},
    { 920, 576, -112},
    { 904, 576, -112},
    { 1144, 624, -40},
    { 1368, 520, 0},
    { 1368, 320, 32},
    { 1296, 200, 24},
    { 1280, 208, -40},
    { 1232, 272, -72},
    { 1128, 312, -48},
    { 1168, 296, -72},
    { 1144, 248, -184},
    { 904, 56, -200},
    { 1368, -16, -32},
    { 1016, 112, -112},
    { 1200, 248, -208},
    { 1384, 272, -184},
    { 1320, 336, -160},
    { 1072, 320, -88},
    { 1008, 368, -136},
    // 40 seconds
    { 1000, 432, -32},
    { 1112, 488, -64},
    { 1224, 520, -104},
    { 1248, 528, -72},
    { 1552, 616, -32},
    { 1104, 720, 72},
    { 1232, 952, -88},
    { 976, 736, -184},
    { 944, 544, -152},
    { 968, 584, -40},
    { 1304, 616, -24},
    { 1520, 432, -32},
    { 1384, 296, 8},
    { 1344, 248, -8},
    { 1328, 296, -72},
    { 1248, 336, -48},
    { 1112, 296, -8},
    { 1280, 280, -96},
    { 1056, 200, -144},
    { 912, 96, -176},
    { 1088, 72, -32},
    { 984, 200, -88},
    { 1120, 288, -232},
    { 1336, 296, -208},
    { 1296, 336, -224},
    // 41 seconds
    { 992, 288, -136},
    { 896, 320, -168},
    { 960, 368, -120},
    { 1096, 432, -80},
    { 1216, 520, -24},
    { 1320, 576, 16},
    { 1648, 664, -40},
    { 1184, 768, -16},
    { 1240, 776, -112},
    { 1056, 864, -136},
    { 1024, 664, -152},
    { 1016, 600, -56},
    { 1224, 648, -80},
    { 1376, 528, -128},
    { 1288, 288, 72},
    { 1304, -8, 80},
    { 1280, 304, -144},
    { 1128, 216, 0},
    { 1016, 360, 0},
    { 1104, 320, -16},
    { 1152, 352, -96},
    { 872, 280, -192},
    { 1264, 184, -120},
    { 984, 88, 8},
    { 1168, 216, -176},
    // 42 seconds
    { 1336, 312, -232},
    { 1248, 392, -360},
    { 824, 264, -264},
    { 744, 184, -152},
    { 968, 280, -88},
    { 1208, 400, -56},
    { 1248, 536, -120},
    { 1400, 608, -88},
    { 1728, 800, 40},
    { 1136, 896, -56},
    { 1352, 496, 16},
    { 952, 656, -104},
    { 936, 640, -112},
    { 864, 624, -56},
    { 1112, 616, 24},
    { 1320, 488, 16},
    { 1232, 296, 32},
    { 1200, 208, 8},
    { 1264, 216, -40},
    { 1288, 280, -56},
    { 1176, 336, -40},
    { 1152, 288, -48},
    { 1232, 288, -96},
    { 1112, 240, -152},
    { 1224, 104, -104},
    // 43 seconds
    { 968, 0, -16},
    { 1080, 240, -200},
    { 1168, 272, -192},
    { 1224, 280, -144},
    { 1112, 320, -192},
    { 1048, 368, -216},
    { 1048, 368, -168},
    { 1064, 416, -112},
    { 1120, 464, -144},
    { 1160, 488, -192},
    { 1424, 576, -168},
    { 1304, 648, -128},
    { 960, 536, -80},
    { 1152, 656, -128},
    { 936, 672, -128},
    { 1048, 568, -104},
    { 1152, 552, 0},
    { 1392, 504, 24},
    { 1392, 368, 16},
    { 1304, 264, 24},
    { 1304, 240, -32},
    { 1304, 280, -160},
    { 1160, 240, -208},
    { 1040, 184, -40},
    { 1152, 264, -136},
    // 44 seconds
    { 968, 296, -400},
    { 1200, 248, -200},
    { 1032, 184, -200},
    { 1056, 168, -112},
    { 1072, 200, -176},
    { 1192, 280, -176},
    { 1168, 320, -184},
    { 1016, 336, -152},
    { 1024, 384, -168},
    { 1152, 424, -136},
    { 1208, 472, -144},
    { 1160, 472, -136},
    { 1312, 544, -104},
    { 1520, 776, -32},
    { 1104, 728, -56},
    { 1264, 744, -40},
    { 936, 744, -120},
    { 976, 616, -104},
    { 1008, 632, -16},
    { 1336, 608, 32},
    { 1424, 424, 32},
    { 1344, 232, 40},
    { 1304, 216, -16},
    { 1280, 272, -64},
    { 1208, 328, -72},
    // 45 seconds
    { 1096, 304, -72},
    { 1160, 264, -88},
    { 1112, 240, -192},
    { 1208, 168, -112},
    { 1040, 104, -32},
    { 1128, 208, -184},
    { 1088, 264, -232},
    { 1248, 256, -208},
    { 1248, 272, -192},
    { 1096, 320, -280},
    { 1064, 344, -256},
    { 1096, 344, -200},
    { 1168, 408, -144},
    { 1144, 496, -136},
    { 1136, 552, -160},
    { 1528, 664, -128},
    { 1200, 664, -64},
    { 1088, 608, -64},
    { 928, 736, -136},
    { 984, 736, -112},
    { 1088, 576, -32},
    { 1312, 576, 24},
    { 1560, 464, 32},
    { 1448, 336, 48},
    { 1352, 272, 24},
    // 46 seconds
    { 1352, 280, -16},
    { 1296, 328, -64},
    { 1184, 328, -16},
    { 1336, 288, -40},
    { 1184, 296, -216},
    { 1048, 144, -208},
    { 992, -64, 56},
    { 1064, 88, -104},
    { 1128, 280, -272},
    { 1336, 232, -176},
    { 1312, 248, -88},
    { 1168, 296, -144},
    { 1104, 384, -184},
    { 1128, 408, -104},
    { 1168, 472, -80},
    { 1160, 480, -136},
    { 1120, 536, -112},
    { 1488, 640, 8},
    { 1392, 720, 40},
    { 1208, 664, -40},
    { 904, 752, -128},
    { 880, 712, -200},
    { 944, 568, -128},
    { 1176, 608, -32},
    { 1528, 544, -16},
    // 47 seconds
    { 1480, 376, 16},
    { 1368, 200, 32},
    { 1296, 240, -16},
    { 1264, 272, -32},
    { 1168, 336, -16},
    { 1128, 312, -8},
    { 1296, 304, -64},
    { 960, 224, -80},
    { 1224, 160, -96},
    { 880, 112, -120},
    { 992, 200, -176},
    { 1088, 272, -192},
    { 1288, 304, -216},
    { 1136, 320, -192},
    { 920, 280, -208},
    { 880, 272, -152},
    { 1032, 328, -120},
    { 1192, 400, -144},
    { 1216, 488, -168},
    { 1536, 600, -96},
    { 1640, 816, -96},
    { 976, 1032, -112},
    { 1272, 552, -144},
    { 816, 616, -160},
    { 976, 600, -144},
    // 48 seconds
    { 1152, 672, -24},
    { 1400, 560, -8},
    { 1360, 360, -8},
    { 1248, 288, -8},
    { 1304, 272, -16},
    { 1336, 328, -72},
    { 1208, 312, -56},
    { 1136, 256, 8},
    { 1272, 280, -80},
    { 952, 264, -200},
    { 1256, 152, -136},
    { 944, 8, 32},
    { 1040, 208, -184},
    { 1088, 264, -224},
    { 1216, 288, -168},
    { 1168, 344, -200},
    { 1040, 352, -232},
    { 1040, 352, -168},
    { 1096, 376, -104},
    { 1152, 456, -128},
    { 1200, 488, -184},
    { 1424, 520, -112},
    { 1464, 656, -80},
    { 1032, 672, -16},
    { 1248, 752, -120},
    // 49 seconds
    { 840, 768, -136},
    { 1112, 656, -88},
    { 1144, 616, -24},
    { 1320, 592, -16},
    { 1368, 400, 16},
    { 1280, 280, 32},
    { 1304, 264, -8},
    { 1344, 304, -56},
    { 1224, 344, -56},
    { 1136, 296, -16},
    { 1256, 280, -96},
    { 952, 208, -176},
    { 1248, 88, -80},
    { 896, 24, -16},
    { 1160, 240, -216},
    { 1184, 240, -184},
    { 1240, 280, -160},
    { 1112, 304, -192},
    { 992, 344, -224},
    { 1008, 360, -176},
    { 1128, 376, -152},
    { 1224, 440, -152},
    { 1240, 512, -112},
    { 1664, 624, -48},
    { 1328, 736, -48},
    // 50 seconds
    { 1160, 696, -88},
    { 944, 856, -88},
    { 1048, 752, -104},
    { 1056, 560, -72},
    { 1264, 640, -32},
    { 1432, 568, 0},
    { 1312, 392, 32},
    { 1264, 272, 56},
    { 1320, 264, -16},
    { 1288, 304, -40},
    { 1160, 312, -8},
    { 1168, 272, 8},
    { 1200, 272, -48},
    { 936, 224, -112},
    { 1184, 160, -88},
    { 880, 104, -136},
    { 1016, 216, -208},
    { 1144, 232, -208},
    { 1392, 288, -256},
    { 1256, 312, -336},
    { 1000, 272, -288},
    { 952, 296, -216},
    { 1120, 336, -240},
    { 1128, 400, -232},
    { 1032, 464, -232},
    // 51 seconds
    { 1216, 544, -160},
    { 1616, 712, -112},
    { 1136, 624, -32},
    { 1280, 632, -96},
    { 864, 768, -136},
    { 968, 672, -112},
    { 1040, 600, 0},
    { 1344, 640, 24},
    { 1520, 488, 48},
    { 1384, 320, 80},
    { 1368, 216, 40},
    { 1408, 240, -16},
    { 1272, 312, -80},
    { 1096, 288, -32},
    { 1016, 256, -64},
    { 1008, 272, -152},
    { 776, 232, -272},
    { 1088, 144, -152},
    { 1072, 128, -56},
    { 1344, 224, -160},
    { 1352, 280, -192},
    { 1344, 368, -256},
    { 992, 336, -160},
    { 880, 264, -176},
    { 1064, 344, -48},
    // 52 seconds
    { 1304, 440, 48},
    { 1280, 560, -8},
    { 1232, 568, -64},
    { 1600, 624, 48},
    { 1272, 784, 128},
    { 880, 712, -8},
    { 1000, 672, 24},
    { 976, 784, 0},
    { 1048, 648, -24},
    { 1256, 696, 40},
    { 1528, 664, 32},
    { 1440, 528, 72},
    { 1400, 304, 120},
    { 1424, 288, 16},
    { 1472, 448, -96},
    { 1264, 392, 8},
    { 1136, 112, 128},
    { 1208, 128, -64},
    { 880, 184, -176},
    { 1184, 32, -184},
    { 1048, -32, 16},
    { 1176, 96, -24},
    { 1280, 272, -128},
    { 1360, 360, -176},
    { 1224, 408, -192},
    // 53 seconds
    { 1064, 416, -232},
    { 1152, 424, -64},
    { 1336, 464, 136},
    { 1456, 576, 144},
    { 1408, 608, -88},
    { 1512, 744, 112},
    { 1064, 1504, -160},
    { 1216, 1080, -8},
    { 944, 856, -200},
    { 1272, 792, -376},
    { 1376, 768, -312},
    { 1976, 832, -128},
    { 2344, 864, -120},
    { 2272, 408, -96},
    { 1984, 384, -160},
    { 1560, 480, -208},
    { 1136, 392, -232},
    { 776, 336, -368},
    { 568, 184, -496},
    { 288, 24, -296},
    { 312, -168, -592},
    { 304, -536, -640},
    { 240, -360, -856},
    { 224, -136, -976},
    { 208, -136, -976},
    // 54 seconds
    { 192, -48, -976},
    { 176, -120, -912},
    { 88, -232, -800},
    { 8, -256, -744},
    { -48, -192, -800},
    { -72, -160, -864},
    { -24, -256, -960},
    { -48, -368, -1040},
    { 32, -328, -1184},
    { 8, -352, -1256},
    { -80, -248, -1264},
    { -80, -136, -1256},
    { -128, -32, -1208},
    { -152, -16, -1080},
    { -96, 104, -1048},
    { 48, 24, -960},
    { 64, -112, -784},
    { 0, -120, -664},
    { -8, -168, -704},
    { -16, -216, -800},
    { -16, -272, -856},
    { 80, -344, -912},
    { 176, -320, -944},
    { 240, -160, -1072},
    { 296, -160, -1368},
    // 55 seconds
    { 464, -32, -1656},
    { 416, -120, -1488},
    { 408, -80, -1240},
    { 392, -24, -992},
    { 288, -24, -736},
    { 208, -64, -608},
    { 144, -96, -536},
    { 176, -152, -520},
    { 288, -96, -496},
    { 304, 208, -544},
    { 224, 384, -648},
    { 32, 792, -928},
    { 8, 872, -1280},
    { -48, 760, -1424},
    { -200, 808, -1664},
    { 88, 800, -1536},
    { -200, 1056, -1208},
    { -272, 888, -824},
    { -240, 904, -800},
    { -8, 784, -968},
    { 104, 504, -984},
    { 64, 392, -840},
    { 48, 232, -648},
    { -8, 80, -464},
    { 16, 200, -384},
    // 56 seconds
    { 176, 392, -288},
    { 544, 488, 56},
    { 960, 784, 184},
    { 1384, 1000, 128},
    { 1416, 1112, -104},
    { 1616, 840, -216},
    { 1672, 584, -232},
    { 1344, 320, -136},
    { 1112, 152, -48},
    { 1032, 112, -64},
    { 1096, 240, -64},
    { 1192, 448, -32},
    { 1128, 608, -64},
    { 1096, 640, -104},
    { 1136, 648, -104},
    { 1560, 784, 24},
    { 1016, 1000, -56},
    { 1216, 656, -56},
    { 976, 784, -112},
    { 1080, 712, -112},
    { 1160, 664, -24},
    { 1520, 672, 56},
    { 1704, 480, 48},
    { 1536, 312, 72},
    { 1448, 248, 64},
    // 57 seconds
    { 1376, 256, 8},
    { 1240, 304, -16},
    { 1056, 288, 8},
    { 1048, 256, -16},
    { 968, 248, -56},
    { 752, 184, -136},
    { 928, 96, -80},
    { 928, 144, -24},
    { 1168, 296, -144},
    { 1360, 304, -168},
    { 1584, 360, -200},
    { 1432, 400, -176},
    { 1168, 344, -168},
    { 1160, 336, -288},
    { 1288, 256, -152},
    { 1336, 464, -40},
    { 1160, 672, -16},
    { 1384, 808, 72},
    { 1376, 928, 160},
    { 920, 712, 88},
    { 1192, 688, 152},
    { 1096, 832, 56},
    { 1152, 648, 32},
    { 1304, 696, 104},
    { 1600, 744, 128},
    // 58 seconds
    { 1528, 560, 160},
    { 1472, 288, 192},
    { 1456, 200, 96},
    { 1368, 232, 32},
    { 1248, 288, -16},
    { 1136, 248, 48},
    { 1216, 280, -8},
    { 984, 240, -64},
    { 912, 208, -40},
    { 952, 208, -96},
    { 1000, 248, -88},
    { 1176, 328, -208},
    { 1544, 352, -384},
    { 1352, 320, -224},
    { 1056, 264, -152},
    { 1000, 288, -312},
    { 1112, 352, -240},
    { 1200, 440, -184},
    { 1240, 472, -120},
    { 1448, 584, -56},
    { 1640, 784, -8},
    { 1048, 816, 144},
    { 1144, 768, 0},
    { 792, 752, -8},
    { 968, 720, 8},
    // 59 seconds
    { 1024, 664, 32},
    { 1296, 736, 88},
    { 1544, 640, 96},
    { 1528, 440, 136},
    { 1576, 272, 120},
    { 1568, 224, 16},
    { 1392, 248, -72},
    { 1080, 248, -104},
    { 1072, 240, -120},
    { 1064, 256, -160},
    { 848, 208, -232},
    { 1064, 120, -144},
    { 800, 96, -8},
    { 1136, 296, -208},
    { 1248, 344, -232},
    { 1512, 392, -144},
    { 1360, 408, -96},
    { 1128, 376, -184},
    { 1104, 432, -112},
    { 1216, 456, -48},
    { 1304, 472, -88},
    { 1152, 472, -80},
    { 1400, 560, -64},
    { 1408, 736, 32},
    { 928, 800, 80},
    // 60 seconds
    // elapsed: 1 minutes
    { 1104, 848, -64},
    { 1040, 672, -88},
    { 984, 608, -64},
    { 1072, 664, 8},
    { 1416, 664, 64},
    { 1552, 520, 96},
    { 1448, 328, 128},
    { 1440, 240, 64},
    { 1376, 216, 0},
    { 1240, 264, -8},
    { 1032, 264, -32},
    { 1040, 256, -40},
    { 1048, 272, -88},
    { 832, 224, -136},
    { 1144, 232, -128},
    { 912, 192, -16},
    { 1144, 320, -168},
    { 1312, 344, -240},
    { 1400, 352, -176},
    { 1160, 336, -96},
    { 984, 344, -216},
    { 968, 352, -144},
    { 1096, 376, -88},
    { 1232, 408, -104},
    { 1120, 456, -104},
    // 61 seconds
    { 1344, 544, -72},
    { 1592, 696, -8},
    { 1000, 768, 208},
    { 1272, 872, -152},
    { 952, 632, -96},
    { 952, 600, -96},
    { 928, 656, -56},
    { 1168, 696, 0},
    { 1448, 576, 72},
    { 1384, 352, 72},
    { 1368, 224, 80},
    { 1368, 224, 32},
    { 1336, 344, 8},
    { 1168, 408, -8},
    { 992, 288, 56},
    { 1144, 232, 48},
    { 920, 224, -24},
    { 1144, 208, -48},
    { 952, 176, -112},
    { 1032, 232, -168},
    { 1112, 264, -232},
    { 1256, 304, -264},
    { 1136, 304, -200},
    { 904, 288, -192},
    { 904, 312, -208},
    // 62 seconds
    { 1024, 568, -232},
    { 1136, 400, -120},
    { 1160, 432, -120},
    { 1248, 464, -120},
    { 1760, 648, -168},
    { 1272, 784, -24},
    { 1248, 904, -456},
    { 1008, 752, -344},
    { 1056, 728, -304},
    { 1080, 672, -136},
    { 1400, 864, -192},
    { 1712, 968, -240},
    { 1680, 872, -200},
    { 1640, 720, -168},
    { 1440, 648, -176},
    { 1192, 520, -296},
    { 808, 448, -352},
    { 536, 224, -264},
    { 456, 56, -608},
    { 296, 168, -768},
    { 352, -136, -840},
    { 200, -32, -1008},
    { 304, 56, -1104},
    { 352, 8, -1040},
    { 320, -56, -952},
    // 63 seconds
    { 176, -96, -872},
    { 48, -72, -760},
    { 16, -200, -680},
    { 0, -184, -712},
    { 32, -168, -832},
    { 32, -144, -968},
    { 32, -240, -1040},
    { 24, -208, -1136},
    { 56, -168, -1272},
    { -56, -296, -1264},
    { -8, 16, -1312},
    { -48, 80, -1264},
    { -104, 8, -1096},
    { -136, 88, -976},
    { -56, 96, -936},
    { 0, 16, -856},
    { -64, -72, -736},
    { -56, -176, -688},
    { -64, -296, -720},
    { -48, -312, -736},
    { -24, -288, -744},
    { 104, -216, -712},
    { 424, 96, -752},
    { 704, 328, -760},
    { 1352, 416, -440},
    // 64 seconds
    { 1320, 720, -216},
    { 1448, 824, -288},
    { 1600, 752, -432},
    { 1624, 576, -416},
    { 1376, 560, -120},
    { 1176, 520, -16},
    { 1120, 448, 56},
    { 1192, 392, 32},
    { 1248, 496, 8},
    { 1160, 576, -56},
    { 1248, 592, -48},
    { 1392, 776, 32},
    { 904, 1016, -64},
    { 1088, 728, -168},
    { 888, 656, -152},
    { 1064, 624, -184},
    { 984, 592, -120},
    { 1136, 616, -32},
    { 1408, 616, 8},
    { 1440, 536, 56},
    { 1328, 416, 104},
    { 1344, 256, 136},
    { 1336, 240, 16},
    { 1184, 256, -32},
    { 1040, 248, -96},
    // 65 seconds
    { 1096, 264, -120},
    { 1000, 248, -112},
    { 1080, 256, -192},
    { 1040, 192, -224},
    { 1088, 240, -240},
    { 1024, 264, -296},
    { 1136, 280, -208},
    { 1176, 296, -120},
    { 1112, 320, -160},
    { 1072, 576, -112},
    { 1216, 456, -168},
    { 1288, 464, -48},
    { 1384, 488, -80},
    { 1264, 528, -112},
    { 1112, 536, -128},
    { 1280, 632, -88},
    { 1024, 624, -64},
    { 984, 544, -88},
    { 1016, 752, -104},
    { 1008, 920, -176},
    { 992, 664, -112},
    { 1224, 616, 40},
    { 1576, 480, 120},
    { 1512, 280, 72},
    { 1392, 216, 32},
    // 66 seconds
    { 1336, 256, 24},
    { 1328, 336, 16},
    { 1288, 376, 96},
    { 1256, 352, 120},
    { 1280, 304, 120},
    { 1072, 280, -16},
    { 912, 256, -80},
    { 1008, 216, -248},
    { 784, 72, -224},
    { 912, 128, -192},
    { 1136, 176, -368},
    { 1200, 248, -400},
    { 1176, 256, -296},
    { 1232, 312, -320},
    { 1336, 376, -256},
    { 1392, 432, -360},
    { 1232, 568, -288},
    { 1120, 704, -256},
    { 1496, 560, -80},
    { 1192, 616, -64},
    { 840, 568, -72},
    { 1280, 752, 128},
    { 1192, 1080, 32},
    { 1088, 712, 16},
    { 1136, 584, 120},
    // 67 seconds
    { 1440, 656, 128},
    { 1504, 512, 128},
    { 1496, 296, 136},
    { 1544, 280, 88},
    { 1552, 288, 48},
    { 1392, 336, 40},
    { 1232, 296, 56},
    { 1208, 280, -48},
    { 952, 240, -72},
    { 752, 168, -88},
    { 864, 144, -200},
    { 680, 136, -208},
    { 888, 208, -144},
    { 1232, 272, -320},
    { 1608, 416, -552},
    { 1360, 352, -360},
    { 1152, 296, -256},
    { 1208, 280, -312},
    { 1312, 320, -328},
    { 1272, 432, -408},
    { 1096, 544, -272},
    { 1320, 824, -152},
    { 1136, 696, -200},
    { 920, 536, -104},
    { 1200, 872, -160},
    // 68 seconds
    { 1256, 840, -88},
    { 1264, 600, 24},
    { 1424, 608, 56},
    { 1544, 488, 64},
    { 1424, 312, 80},
    { 1384, 216, 80},
    { 1384, 232, 0},
    { 1336, 296, -40},
    { 1136, 296, -8},
    { 1088, 256, -8},
    { 992, 264, -104},
    { 760, 224, -184},
    { 1016, 176, -176},
    { 760, 160, -88},
    { 952, 216, -184},
    { 1312, 296, -312},
    { 1656, 376, -400},
    { 1352, 336, -136},
    { 1048, 288, -168},
    { 1048, 352, -256},
    { 1200, 400, -256},
    { 1200, 400, -264},
    { 1128, 432, -184},
    { 1544, 632, -8},
    { 1320, 824, 56},
    // 69 seconds
    { 896, 672, -56},
    { 1208, 696, -56},
    { 944, 800, -72},
    { 1128, 632, -40},
    { 1176, 624, 56},
    { 1392, 616, 72},
    { 1400, 432, 80},
    { 1320, 256, 104},
    { 1336, 192, 80},
    { 1320, 232, 0},
    { 1192, 272, -48},
    { 1016, 256, 8},
    { 1080, 272, 0},
    { 1024, 280, -80},
    { 1000, 248, -96},
    { 1376, 224, -104},
    { 1184, 112, 80},
    { 1184, 304, -160},
    { 1224, 344, -288},
    { 1288, 416, -408},
    { 1152, 376, -360},
    { 1144, 320, -80},
    { 1184, 456, -88},
    { 1096, 632, -128},
    { 1136, 392, -200},
    // 70 seconds
    { 1064, 408, -40},
    { 1520, 616, 48},
    { 1104, 688, 144},
    { 1024, 640, 40},
    { 1008, 624, -48},
    { 1112, 680, -96},
    { 1064, 576, -24},
    { 1224, 576, 96},
    { 1448, 544, 48},
    { 1392, 456, 16},
    { 1312, 184, 144},
    { 1192, 184, 48},
    { 1128, 168, -24},
    { 984, 248, -48},
    { 880, 256, 0},
    { 1088, 272, 0},
    { 960, 264, -40},
    { 1192, 272, -32},
    { 1120, 296, -24},
    { 1352, 336, -72},
    { 1376, 352, -208},
    { 1368, 328, -176},
    { 1104, 288, -144},
    { 824, 256, -184},
    { 840, 328, -232},
    // 71 seconds
    { 904, 328, -104},
    { 1008, 376, -88},
    { 984, 432, -136},
    { 1088, 480, -104},
    { 1600, 632, -104},
    { 1072, 704, 64},
    { 1080, 640, -104},
    { 1072, 584, -80},
    { 1160, 632, -88},
    { 1080, 592, -40},
    { 1224, 600, 0},
    { 1400, 528, 8},
    { 1280, 432, 40},
    { 1288, 272, 80},
    { 1312, 216, 16},
    { 1248, 224, -56},
    { 1056, 256, -88},
    { 936, 224, -56},
    { 1072, 248, -64},
    { 888, 248, -152},
    { 920, 176, -120},
    { 1256, 240, -24},
    { 1208, 240, -56},
    { 1344, 336, -176},
    { 1432, 320, -112},
    // 72 seconds
    { 1240, 360, -96},
    { 952, 288, -160},
    { 920, 344, -136},
    { 1008, 368, -32},
    { 1152, 424, 0},
    { 1096, 472, -24},
    { 1008, 472, -72},
    { 1320, 536, -64},
    { 1224, 624, -88},
    { 792, 616, -40},
    { 1400, 864, -96},
    { 1208, 800, -192},
    { 1112, 504, -104},
    { 1280, 608, -8},
    { 1504, 592, -32},
    { 1376, 448, -8},
    { 1304, 264, 80},
    { 1304, 224, 32},
    { 1288, 240, -40},
    { 1144, 288, 0},
    { 1072, 248, 48},
    { 1128, 272, -16},
    { 960, 216, -16},
    { 1144, 184, 40},
    { 1080, 216, 64},
    // 73 seconds
    { 1344, 352, -96},
    { 1464, 336, -80},
    { 1432, 344, -160},
    { 1080, 344, -184},
    { 816, 280, -216},
    { 872, 264, -216},
    { 976, 312, -72},
    { 1160, 408, -24},
    { 1168, 528, -48},
    { 1496, 632, -56},
    { 1480, 760, -64},
    { 872, 792, 8},
    { 1352, 664, -80},
    { 968, 712, -88},
    { 1008, 608, -80},
    { 1096, 616, -16},
    { 1384, 600, 0},
    { 1488, 472, 0},
    { 1400, 296, 80},
    { 1384, 240, 40},
    { 1360, 248, -8},
    { 1224, 272, -24},
    { 1056, 256, -32},
    { 1144, 256, -48},
    { 1008, 248, -104},
    // 74 seconds
    { 784, 240, -176},
    { 1184, 216, -128},
    { 888, 216, -32},
    { 1184, 288, -80},
    { 1360, 344, -168},
    { 1336, 416, -160},
    { 1032, 344, -136},
    { 904, 312, -160},
    { 968, 368, -88},
    { 1168, 408, -88},
    { 1272, 480, -136},
    { 1144, 520, -152},
    { 1360, 576, -72},
    { 1424, 744, -80},
    { 1288, 856, -168},
    { 1048, 616, -256},
    { 1016, 560, -192},
    { 1024, 560, -72},
    { 1264, 520, -8},
    { 1424, 384, -32},
    { 1272, 296, -32},
    { 1184, 272, 0},
    { 1184, 288, -40},
    { 1168, 304, -56},
    { 1088, 272, -56},
    // 75 seconds
    { 1048, 240, -16},
    { 1160, 264, -56},
    { 912, 248, -136},
    { 1232, 248, -80},
    { 920, 224, -64},
    { 1096, 288, -128},
    { 1344, 320, -200},
    { 1360, 368, -224},
    { 1016, 320, -184},
    { 808, 248, -224},
    { 888, 296, -168},
    { 1024, 320, -192},
    { 1096, 392, -168},
    { 1144, 448, -136},
    { 1504, 552, -104},
    { 1512, 720, -144},
    { 968, 728, -8},
    { 1176, 712, -208},
    { 1032, 592, -152},
    { 1040, 560, -152},
    { 1128, 616, -56},
    { 1392, 592, -48},
    { 1360, 400, 0},
    { 1240, 248, 40},
    { 1240, 216, -8},
    // 76 seconds
    { 1264, 232, -72},
    { 1144, 264, -80},
    { 1064, 248, -32},
    { 1216, 280, -8},
    { 1024, 280, -96},
    { 968, 280, -104},
    { 1040, 264, -64},
    { 1056, 232, -64},
    { 1160, 288, -184},
    { 1400, 296, -264},
    { 1224, 304, -208},
    { 872, 264, -216},
    { 816, 312, -304},
    { 960, 336, -264},
    { 1064, 344, -168},
    { 1120, 360, -120},
    { 1224, 400, -112},
    { 1696, 552, -144},
    { 1448, 640, -168},
    { 1056, 576, -96},
    { 1208, 720, -88},
    { 720, 864, -280},
    { 968, 608, -128},
    { 1064, 576, -24},
    { 1352, 560, 0},
    // 77 seconds
    { 1440, 440, -8},
    { 1352, 320, 8},
    { 1296, 248, 40},
    { 1288, 296, 8},
    { 1232, 352, -8},
    { 1088, 320, 8},
    { 1080, 232, -32},
    { 1224, 232, -16},
    { 928, 216, -144},
    { 1160, 168, -136},
    { 1000, 160, 0},
    { 1128, 264, -112},
    { 1264, 320, -280},
    { 1416, 352, -192},
    { 1216, 288, -80},
    { 1008, 208, -160},
    { 1008, 424, -208},
    { 984, 408, -80},
    { 1072, 432, -56},
    { 1056, 464, -56},
    { 1280, 512, -40},
    { 1504, 592, -8},
    { 1032, 608, 104},
    { 1400, 688, -80},
    { 968, 792, -136},
    // 78 seconds
    { 1064, 608, -120},
    { 1096, 600, -24},
    { 1248, 608, -24},
    { 1328, 464, -8},
    { 1240, 272, 96},
    { 1216, 144, 56},
    { 1256, 152, -48},
    { 1160, 232, -40},
    { 1048, 280, 0},
    { 1176, 288, 8},
    { 1088, 296, 8},
    { 952, 288, -104},
    { 1320, 288, -72},
    { 944, 240, -72},
    { 1032, 264, -184},
    { 1224, 272, -216},
    { 1192, 280, -136},
    { 1016, 272, -128},
    { 928, 336, -224},
    { 912, 360, -144},
    { 960, 400, -104},
    { 1032, 432, -120},
    { 1048, 448, -112},
    { 1560, 520, -64},
    { 1488, 632, -48},
    // 79 seconds
    { 1008, 664, 104},
    { 1184, 936, -200},
    { 856, 600, -144},
    { 888, 488, -88},
    { 1048, 632, -24},
    { 1416, 648, -8},
    { 1400, 456, 8},
    { 1312, 288, 48},
    { 1312, 216, 48},
    { 1256, 248, 0},
    { 1096, 272, 0},
    { 976, 272, 8},
    { 1120, 264, 16},
    { 1040, 272, -8},
    { 960, 256, -104},
    { 1128, 216, -144},
    { 904, 192, -8},
    { 1088, 280, -96},
    { 1256, 344, -248},
    { 1296, 384, -224},
    { 1080, 352, -168},
    { 960, 272, -160},
    { 1032, 352, -80},
    { 1184, 416, -40},
    { 1224, 512, -64},
    // 80 seconds
    { 1160, 528, -16},
    { 1560, 600, -8},
    { 1312, 704, 56},
    { 1048, 968, 8},
    { 968, 792, -200},
    { 1024, 576, -112},
    { 1024, 632, -72},
    { 1328, 728, -16},
    { 1528, 520, -8},
    { 1400, 232, 64},
    { 1280, 96, 128},
    { 1416, 248, -24},
    { 1408, 312, 8},
    { 1216, 384, 80},
    { 1208, 336, 32},
    { 1016, 312, -64},
    { 872, 192, -112},
    { 992, -48, 88},
    { 760, 16, 24},
    { 1272, 336, -208},
    { 1528, 328, -144},
    { 1528, 400, -264},
    { 1080, 352, -200},
    { 896, 304, -256},
    { 1000, 384, -168},
    // 81 seconds
    { 1256, 384, -160},
    { 1200, 536, -128},
    { 1248, 560, -72},
    { 1568, 688, -48},
    { 1120, 808, 64},
    { 1232, 840, -128},
    { 944, 600, -96},
    { 1064, 560, -104},
    { 1120, 624, -48},
    { 1424, 648, -8},
    { 1584, 456, -48},
    { 1384, 168, 72},
    { 1184, 208, 0},
    { 1240, 192, -32},
    { 1168, 304, -80},
    { 1016, 296, -32},
    { 928, 232, -16},
    { 952, 232, -32},
    { 920, 248, -136},
    { 1048, 232, -168},
    { 912, 240, -88},
    { 1072, 240, -136},
    { 1544, 352, -224},
    { 1552, 408, -184},
    { 1120, 352, -184},
    // 82 seconds
    { 888, 384, -216},
    { 856, 472, -120},
    { 1088, 344, -8},
    { 1208, 472, -48},
    { 1056, 464, -40},
    { 1376, 528, -8},
    { 1440, 672, 64},
    { 1000, 848, 112},
    { 1184, 784, -32},
    { 928, 480, -48},
    { 904, 536, -24},
    { 1016, 664, -8},
    { 1344, 664, 0},
    { 1440, 440, 16},
    { 1288, 320, 48},
    { 1336, 216, 24},
    { 1304, 280, -56},
    { 1168, 368, -64},
    { 1056, 288, -16},
    { 1216, 200, 16},
    { 1008, 128, -8},
    { 1016, 16, -56},
    { 1032, 64, 80},
    { 1200, 248, -152},
    { 1272, 216, -144},
    // 83 seconds
    { 1344, 224, -192},
    { 1120, 272, -232},
    { 928, 200, -256},
    { 1000, 104, -176},
    { 1096, 456, -128},
    { 1240, 488, -48},
    { 1232, 576, -88},
    { 1728, 720, -96},
    { 1240, 920, 96},
    { 1040, 656, -152},
    { 1064, 560, -104},
    { 1016, 672, -152},
    { 1000, 664, -64},
    { 1168, 720, 24},
    { 1504, 560, 40},
    { 1376, 336, 32},
    { 1312, 208, 56},
    { 1360, 216, 24},
    { 1320, 296, -32},
    { 1152, 320, -32},
    { 1104, 296, -16},
    { 1136, 296, -40},
    { 848, 248, -120},
    { 912, 208, -120},
    { 896, 184, -16},
    // 84 seconds
    { 936, 200, -80},
    { 1208, 288, -232},
    { 1488, 320, -160},
    { 1312, 368, -96},
    { 1000, 304, -168},
    { 1008, 288, -224},
    { 1128, 440, -88},
    { 1256, 448, -96},
    { 1088, 504, -96},
    { 1336, 560, -56},
    { 1384, 704, -48},
    { 1040, 704, -72},
    { 1304, 624, -160},
    { 1040, 640, -144},
    { 1024, 584, -80},
    { 1184, 576, 0},
    { 1472, 528, -32},
    { 1400, 448, -72},
    { 1336, 136, 128},
    { 1192, 160, 64},
    { 1160, 192, -8},
    { 1040, 272, -16},
    { 992, 312, 24},
    { 1160, 288, 0},
    { 920, 256, -24},
    // 85 seconds
    { 1160, 192, 8},
    { 1016, 168, 64},
    { 1192, 320, -80},
    { 1320, 336, -96},
    { 1392, 344, -104},
    { 1144, 352, -112},
    { 888, 288, -192},
    { 840, 296, -144},
    { 992, 320, -64},
    { 1168, 408, -72},
    { 1096, 472, -120},
    { 1248, 528, -120},
    { 1608, 760, -168},
    { 952, 1032, -56},
    { 1368, 552, -208},
    { 984, 512, -176},
    { 1120, 568, -184},
    { 1184, 576, -64},
    { 1480, 544, -40},
    { 1472, 320, -16},
    { 1216, 144, 56},
    { 1032, 272, -8},
    { 1080, 216, -16},
    { 1088, 344, -16},
    { 968, 304, 96},
    // 86 seconds
    { 952, 256, 56},
    { 1056, 256, 0},
    { 992, 280, -96},
    { 1312, 272, -136},
    { 1040, 240, -56},
    { 1144, 264, -176},
    { 1336, 288, -280},
    { 1320, 344, -256},
    { 1000, 320, -168},
    { 832, 256, -208},
    { 896, 320, -152},
    { 1072, 368, -88},
    { 1160, 448, -80},
    { 1048, 480, -72},
    { 1520, 560, -40},
    { 1384, 664, 8},
    { 1152, 712, -8},
    { 1160, 672, -168},
    { 1064, 560, -152},
    { 880, 568, -120},
    { 1024, 648, -40},
    { 1352, 576, -56},
    { 1304, 376, 64},
    { 1200, 120, 136},
    { 1184, 184, -24},
    // 87 seconds
    { 1152, 176, -16},
    { 1072, 320, -32},
    { 968, 320, -8},
    { 1112, 304, -24},
    { 1072, 280, -64},
    { 1048, 264, -144},
    { 1304, 256, -80},
    { 1112, 224, -56},
    { 1136, 312, -200},
    { 1296, 328, -272},
    { 1184, 328, -192},
    { 880, 240, -136},
    { 792, 264, -184},
    { 880, 288, -152},
    { 968, 344, -120},
    { 1008, 392, -88},
    { 1008, 432, -56},
    { 1224, 504, -88},
    { 1576, 632, -160},
    { 1088, 640, -72},
    { 1392, 784, -280},
    { 1080, 656, -264},
    { 992, 496, -144},
    { 1136, 536, -72},
    { 1376, 536, -72},
    // 88 seconds
    { 1344, 376, 16},
    { 1216, 128, 72},
    { 1176, 288, -56},
    { 1400, 880, -280},
    { 1336, 1424, -312},
    { 1384, 968, -312},
    { 1336, 456, -288},
    { 912, 280, -448},
    { 704, 304, -680},
    { 584, 128, -784},
    { 384, 184, -840},
    { 416, 8, -768},
    { 336, 88, -848},
    { 208, 32, -808},
    { 40, 0, -736},
    { -104, -104, -664},
    { -184, -168, -680},
    { -216, -128, -760},
    { -240, -112, -832},
    { -296, -144, -864},
    { -312, -192, -992},
    { -288, -168, -1144},
    { -464, -96, -1184},
    { -248, 272, -1400},
    { -128, 176, -1376},
    // 89 seconds
    { -128, 0, -1104},
    { -176, 112, -928},
    { -136, 248, -944},
    { -56, 104, -896},
    { -88, -24, -760},
    { -96, -16, -720},
    { -112, -40, -784},
    { -120, -72, -840},
    { -136, -24, -960},
    { -80, -8, -1192},
    { -8, -16, -1312},
    { -64, -80, -1304},
    { 8, 48, -1328},
    { 152, 208, -1280},
    { 248, 144, -1128},
    { 296, 152, -1024},
    { 368, 176, -992},
    { 272, 56, -816},
    { 104, 40, -704},
    { 64, 0, -664},
    { 128, -8, -640},
    { 192, 8, -648},
    { 176, 208, -648},
    { 80, 392, -760},
    { -40, 800, -1040},
    // 90 seconds
    { -136, 752, -1280},
    { -304, 784, -1432},
    { -128, 1008, -1760},
    { -232, 792, -1488},
    { -376, 896, -968},
    { -304, 872, -824},
    { -136, 848, -952},
    { 72, 576, -1064},
    { 72, 296, -1000},
    { 16, 240, -856},
    { -40, 72, -568},
    { -48, 32, -384},
    { 24, 120, -320},
    { 264, 264, -256},
    { 656, 488, -264},
    { 968, 608, -176},
    { 1416, 544, 56},
    { 1800, 560, -112},
    { 2272, 720, -288},
    { 1984, 704, -208},
    { 1424, 520, -16},
    { 1184, 192, -32},
    { 1128, 128, -104},
    { 1224, 232, -136},
    { 1288, 448, -80},
    // 91 seconds
    { 1232, 608, -16},
    { 1104, 616, -8},
    { 1472, 704, -16},
    { 1264, 888, 64},
    { 984, 928, -88},
    { 1056, 728, -64},
    { 1000, 648, -96},
    { 936, 680, -96},
    { 1160, 736, 0},
    { 1760, 624, 24},
    { 1808, 352, 64},
    { 1688, 280, 56},
    { 1712, 264, 24},
    { 1624, 320, 0},
    { 1376, 336, 24},
    { 1128, 304, -32},
    { 1064, 280, -72},
    { 960, 264, -224},
    { 744, 80, -256},
    { 824, -128, -72},
    { 760, 144, -120},
    { 1048, 352, -232},
    { 1376, 336, -344},
    { 1624, 344, -216},
    { 1472, 320, 40},
    // 92 seconds
    { 1400, 320, 8},
    { 1504, 448, -16},
    { 1656, 584, 16},
    { 1528, 632, 0},
    { 1304, 624, 80},
    { 1480, 712, 128},
    { 1216, 840, 208},
    { 912, 920, 72},
    { 968, 840, 32},
    { 912, 720, -80},
    { 880, 696, -88},
    { 1096, 808, -16},
    { 1672, 800, 64},
    { 1952, 552, 144},
    { 1832, 296, 192},
    { 1744, 160, 152},
    { 1632, 216, 56},
    { 1336, 256, 120},
    { 1088, 312, 56},
    { 1000, 320, 8},
    { 1000, 288, -56},
    { 840, 240, -152},
    { 976, 152, -96},
    { 840, 128, -256},
    { 904, 272, -168},
    // 93 seconds
    { 1144, 280, -312},
    { 1440, 296, -336},
    { 1344, 272, -32},
    { 1248, 320, -24},
    { 1328, 432, -88},
    { 1456, 504, -104},
    { 1448, 512, -104},
    { 1288, 520, -16},
    { 1528, 600, -48},
    { 1552, 712, -24},
    { 1016, 808, 56},
    { 1192, 912, -80},
    { 824, 784, -96},
    { 880, 632, -120},
    { 936, 648, -112},
    { 1240, 728, -24},
    { 1576, 640, 48},
    { 1544, 392, 88},
    { 1584, 216, 120},
    { 1552, 224, 72},
    { 1488, 296, 56},
    { 1224, 288, 112},
    { 1040, 288, 64},
    { 1128, 288, 8},
    { 904, 264, -16},
    // 94 seconds
    { 992, 240, -24},
    { 880, 232, -96},
    { 880, 256, -144},
    { 1000, 248, -160},
    { 1352, 320, -256},
    { 1368, 368, -304},
    { 1080, 304, -184},
    { 960, 288, -184},
    { 1080, 304, -184},
    { 1184, 328, -184},
    { 1192, 384, -176},
    { 1104, 432, -128},
    { 1464, 544, -128},
    { 1552, 720, -128},
    { 1144, 744, 16},
    { 1232, 704, -224},
    { 936, 640, -184},
    { 840, 584, -152},
    { 936, 600, -80},
    { 1304, 608, -40},
    { 1456, 440, 16},
    { 1360, 272, 48},
    { 1360, 208, 48},
    { 1352, 224, 8},
    { 1272, 288, 16},
    // 95 seconds
    { 1112, 296, 8},
    { 1168, 288, 8},
    { 1088, 312, -64},
    { 912, 272, -120},
    { 1096, 240, -136},
    { 896, 200, -56},
    { 952, 256, -160},
    { 1232, 320, -328},
    { 1328, 336, -296},
    { 1072, 272, -152},
    { 848, 208, -104},
    { 968, 248, -176},
    { 1216, 312, -152},
    { 1304, 424, -152},
    { 1240, 472, -216},
    { 1584, 256, -176},
    { 1376, 840, 1008},
    { 832, 1872, -136},
    { 1096, 624, 32},
    { 816, 960, 296},
    { 928, 872, 448},
    { 1328, 792, 464},
    { 1664, 880, 584},
    { 1760, 976, 384},
    { 1656, 936, 344},
    // 96 seconds
    { 1568, 992, 296},
    { 1464, 1000, 168},
    { 1200, 728, 40},
    { 840, 384, -160},
    { 568, 160, -328},
    { 416, -200, -584},
    { 184, -48, -648},
    { 152, -32, -784},
    { 40, 128, -952},
    { 208, 32, -1088},
    { 336, -88, -1048},
    { 392, 32, -1064},
    { 336, -24, -992},
    { 136, -88, -872},
    { 0, 8, -840},
    { -128, -24, -856},
    { -176, -40, -904},
    { -192, -112, -992},
    { -176, -112, -1144},
    { -96, -72, -1240},
    { -176, -48, -1232},
    { -96, 168, -1256},
    { -24, 216, -1272},
    { -40, 136, -1120},
    { -88, 128, -984},
    // 97 seconds
    { -40, 200, -984},
    { 48, 24, -936},
    { 48, -120, -856},
    { 8, -280, -848},
    { -32, -256, -824},
    { -72, -160, -696},
    { -8, 24, -560},
    { 176, 64, -424},
    { 672, 48, -128},
    { 1344, 304, 640},
    { 2232, 1032, 1496},
    { 2224, 2328, 608},
    { 1624, 1280, -352},
    { 1488, 552, 112},
    { 1208, 920, -120},
    { 984, 408, 424},
    { 1176, -136, 104},
    { 1168, 56, 0},
    { 1112, 288, 72},
    { 1088, 704, 192},
    { 1088, 800, 88},
    { 1576, 984, 160},
    { 928, 1640, 48},
    { 936, 424, -56},
    { 1064, 736, -80},
    // 98 seconds
    { 896, 768, -136},
    { 1128, 744, -56},
    { 1448, 792, -24},
    { 1808, 576, 72},
    { 1792, 344, 112},
    { 1624, 176, 128},
    { 1560, 224, 16},
    { 1432, 248, 8},
    { 1208, 296, 24},
    { 1016, 288, -8},
    { 952, 296, -64},
    { 872, 248, -160},
    { 632, -40, -104},
    { 728, -32, 8},
    { 976, 384, -136},
    { 1240, 344, -264},
    { 1560, 312, -232},
    { 1648, 432, -112},
    { 1280, 376, -56},
    { 1128, 336, -112},
    { 1280, 400, -152},
    { 1440, 440, -96},
    { 1360, 504, -56},
    { 1120, 496, 16},
    { 1256, 576, 40},
    // 99 seconds
    { 1424, 744, 160},
    { 1000, 776, 32},
    { 1200, 760, 16},
    { 1024, 1016, 8},
    { 1032, 744, -104},
    { 920, 608, -40},
    { 1208, 736, 40},
    { 1664, 728, 56},
    { 1784, 504, 288},
    { 1680, 32, 256},
    { 1408, 96, 72},
    { 1336, 208, 32},
    { 1056, 208, 120},
    { 912, 336, 0},
    { 912, 320, 24},
    { 800, 280, 16},
    { 776, 288, -184},
    { 936, 248, -184},
    { 928, 224, -144},
    { 1176, 280, -64},
    { 1504, 352, -312},
    { 1608, 416, -384},
    { 1128, 336, -80},
    { 864, 224, -144},
    { 936, 296, -120},
    // 100 seconds
    { 1128, 360, -112},
    { 1216, 456, -104},
    { 1096, 488, -72},
    { 1144, 496, -80},
    { 1480, 616, -88},
    { 1336, 672, -48},
    { 1016, 656, -56},
    { 1208, 792, -192},
    { 880, 704, -232},
    { 960, 584, -152},
    { 1128, 632, -32},
    { 1408, 584, 0},
    { 1560, 424, 64},
    { 1472, 192, 96},
    { 1344, 176, 80},
    { 1256, 192, 0},
    { 1152, 264, -56},
    { 1008, 264, -24},
    { 936, 224, 48},
    { 1048, 272, -56},
    { 912, 288, -224},
    { 1104, 256, -104},
    { 1120, 240, -160},
    { 1152, 288, -208},
    { 1336, 312, -328},
    // 101 seconds
    { 1352, 272, -168},
    { 1192, 256, -80},
    { 1040, 288, -136},
    { 1088, 392, -96},
    { 1168, 456, -64},
    { 1184, 504, -48},
    { 1072, 496, -8},
    { 1176, 496, 0},
    { 1536, 592, 32},
    { 1152, 648, 24},
    { 1168, 744, -56},
    { 928, 928, -184},
    { 952, 608, -176},
    { 880, 512, -48},
    { 1136, 656, 24},
    { 1576, 544, 32},
    { 1488, 352, 64},
    { 1392, 224, 80},
    { 1368, 208, 40},
    { 1312, 280, 24},
    { 1192, 304, -8},
    { 1088, 224, 80},
    { 1064, 232, 56},
    { 968, 272, -16},
    { 1056, 312, -88},
    // 102 seconds
    { 1064, 320, -80},
    { 1016, 304, -200},
    { 1088, 328, -328},
    { 1352, 328, -416},
    { 1280, 240, -216},
    { 1096, 160, 216},
    { 1184, 632, -520},
    { 1064, 384, -104},
    { 1200, 536, -64},
    { 1176, 488, -8},
    { 1112, 488, -16},
    { 1400, 544, 72},
    { 1104, 584, 104},
    { 984, 608, 24},
    { 1032, 744, -16},
    { 968, 800, -72},
    { 1040, 560, -8},
    { 1200, 648, 48},
    { 1440, 616, 32},
    { 1488, 472, 56},
    { 1480, 208, 216},
    { 1448, 96, 80},
    { 1320, 144, -56},
    { 1128, 192, -160},
    { 960, 184, -168},
    // 103 seconds
    { 936, 208, 96},
    { 968, 296, -32},
    { 904, 352, -240},
    { 1184, 320, -128},
    { 912, 256, -32},
    { 1160, 288, -80},
    { 1448, 304, -96},
    { 1432, 400, -48},
    { 1168, 368, -104},
    { 984, 376, -176},
    { 968, 408, -64},
    { 1088, 440, -32},
    { 1120, 464, -32},
    { 1112, 472, -32},
    { 1536, 568, 0},
    { 1296, 664, 72},
    { 992, 768, -16},
    { 1136, 824, -96},
    { 1048, 608, -112},
    { 928, 528, -72},
    { 1048, 632, -16},
    { 1352, 584, -16},
    { 1328, 432, 72},
    { 1304, 264, 96},
    { 1360, 208, 56},
    // 104 seconds
    { 1352, 232, 16},
    { 1216, 280, 64},
    { 1056, 280, 32},
    { 1040, 272, 16},
    { 992, 256, -16},
    { 840, 248, -112},
    { 1200, 216, -48},
    { 1048, 208, -24},
    { 1200, 336, -184},
    { 1360, 344, -280},
    { 1248, 352, -256},
    { 896, 280, -120},
    { 856, 232, -120},
    { 1072, 328, -48},
    { 1320, 472, -40},
    { 1280, 576, -104},
    { 1128, 600, -48},
    { 1472, 664, -128},
    { 1144, 744, -40},
    { 1168, 600, -176},
    { 1088, 664, -200},
    { 1064, 632, -200},
    { 1024, 568, -104},
    { 1264, 608, -56},
    { 1592, 496, 32},
    // 105 seconds
    { 1400, 232, 136},
    { 1256, 8, 112},
    { 1216, 192, -40},
    { 1056, 160, 8},
    { 928, 344, -8},
    { 872, 288, 40},
    { 992, 288, 32},
    { 1032, 344, -176},
    { 1136, 304, -168},
    { 1200, 264, -24},
    { 1248, 232, 0},
    { 1312, 304, -168},
    { 1352, 368, -216},
    { 1120, 368, -184},
    { 896, 280, -200},
    { 880, 312, -160},
    { 968, 352, -96},
    { 1064, 440, -96},
    { 992, 472, -128},
    { 976, 472, -120},
    { 1416, 584, -96},
    { 1184, 616, -32},
    { 1304, 592, -8},
    { 1144, 624, -144},
    { 1104, 616, -160},
    // 106 seconds
    { 960, 512, -72},
    { 1160, 528, 8},
    { 1320, 456, -24},
    { 1240, 352, 16},
    { 1152, 184, 88},
    { 1168, 224, -16},
    { 1120, 240, 0},
    { 1056, 312, -32},
    { 952, 256, 0},
    { 1024, 240, -8},
    { 960, 224, -48},
    { 1120, 136, 24},
    { 1216, 200, 48},
    { 1352, 352, -120},
    { 1464, 344, -120},
    { 1392, 304, -120},
    { 1064, 344, -16},
    { 952, 96, -376},
    { 856, 472, -160},
    { 952, 304, 24},
    { 1048, 432, -64},
    { 1000, 448, -104},
    { 1280, 528, -56},
    { 1552, 984, -8},
    { 800, 1400, 80},
    // 107 seconds
    { 1232, 1088, 256},
    { 912, 1160, 440},
    { 1304, 1128, 376},
    { 1560, 1144, 376},
    { 1960, 1192, 584},
    { 2008, 1328, 712},
    { 2088, 1176, 384},
    { 1656, 528, 384},
    { 1256, 440, -16},
    { 928, 320, -168},
    { 600, 296, -224},
    { 472, 88, -360},
    { 352, -240, -488},
    { 288, -416, -672},
    { 248, -536, -904},
    { 136, -128, -1192},
    { 208, -56, -1240},
    { 240, -184, -1120},
    { 256, -104, -1136},
    { 136, 8, -1048},
    { -64, -8, -872},
    { -104, -168, -784},
    { -96, -192, -768},
    { -56, -64, -824},
    { 0, -80, -928},
    // 108 seconds
    { -24, -152, -1000},
    { 32, -160, -1136},
    { 0, -104, -1232},
    { -192, -160, -1256},
    { -8, 152, -1328},
    { -72, 288, -1208},
    { -128, 288, -1024},
    { -144, 264, -896},
    { -56, 256, -936},
    { 24, 64, -912},
    { 8, -88, -784},
    { -48, 48, -704},
    { -16, 0, -704},
    { 96, -224, -688},
    { 264, -104, -360},
    { 640, -40, 176},
    { 1248, 248, 928},
    { 1752, 1504, 1520},
    { 1536, 2192, 1312},
    { 1768, 1352, -496},
    { 1696, 1360, 616},
    { 904, 584, 392},
    { 1056, -40, 584},
    { 1128, -128, 344},
    { 1032, 256, 168},
    // 109 seconds
    { 1000, 784, 40},
    { 848, 720, 152},
    { 784, 552, 304},
    { 688, 536, 208},
    { 1032, 536, 48},
    { 1280, 728, 136},
    { 1016, 1392, -256},
    { 1184, 688, -144},
    { 1096, 656, -104},
    { 1256, 768, 88},
    { 1424, 512, -24},
    { 1472, 352, -48},
    { 1384, 208, -80},
    { 1352, 168, -16},
    { 1448, 232, -16},
    { 1360, 312, -48},
    { 1168, 288, -64},
    { 960, 200, -32},
    { 928, 176, -16},
    { 776, 216, -136},
    { 968, 256, -104},
    { 1056, 280, -48},
    { 1384, 384, -136},
    { 1672, 480, -264},
    { 1552, 408, -64},
    // 110 seconds
    { 1072, 280, -80},
    { 808, 176, -136},
    { 888, 168, -152},
    { 1040, 456, -88},
    { 1144, 408, -8},
    { 1096, 472, -32},
    { 1184, 480, 8},
    { 1480, 568, -64},
    { 1296, 672, -120},
    { 1008, 688, -144},
    { 1336, 872, -320},
    { 720, 728, -288},
    { 960, 520, -168},
    { 1184, 640, -48},
    { 1496, 592, -16},
    { 1536, 408, 16},
    { 1480, 240, 32},
    { 1440, 216, 56},
    { 1440, 264, 8},
    { 1208, 288, 8},
    { 1008, 272, -8},
    { 1000, 280, -56},
    { 944, 288, -128},
    { 808, 264, -232},
    { 952, 152, -160},
    // 111 seconds
    { 944, 112, 0},
    { 1200, 256, -192},
    { 1416, 296, -192},
    { 1544, 360, -104},
    { 1280, 408, -48},
    { 1016, 360, 64},
    { 984, 1504, -272},
    { 992, 456, -72},
    { 1240, 416, 16},
    { 1120, 432, 80},
    { 1200, 456, 112},
    { 1352, 512, 48},
    { 1160, 560, 88},
    { 960, 616, 16},
    { 1336, 816, 128},
    { 880, 1112, -16},
    { 1000, 584, -192},
    { 968, 544, -48},
    { 1304, 688, 8},
    { 1632, 584, -8},
    { 1640, 400, 16},
    { 1616, 376, 64},
    { 1504, 496, 104},
    { 1496, 760, -56},
    { 1392, 880, 8},
    // 112 seconds
    { 1128, 984, 32},
    { 944, 792, -192},
    { 680, 624, -296},
    { 480, 304, -488},
    { 272, 112, -632},
    { 232, 208, -792},
    { 288, 104, -944},
    { 392, -104, -1016},
    { 360, -96, -952},
    { 312, -88, -936},
    { 296, -168, -952},
    { 168, -104, -928},
    { 24, -64, -928},
    { -8, -48, -904},
    { 24, -24, -904},
    { 48, -16, -944},
    { 24, 80, -1024},
    { -32, 112, -1024},
    { -32, 72, -1040},
    { -56, 104, -1096},
    { -56, 152, -1104},
    { -120, 240, -1024},
    { 32, 40, -1032},
    { -8, -72, -912},
    { 0, 56, -1096},
    // 113 seconds
    { -16, 136, -1136},
    { -40, 328, -1040},
    { -104, 192, -912},
    { -72, 48, -1056},
    { -80, 96, -1112},
    { -144, 160, -1128},
    { -256, 136, -1072},
    { -288, 96, -1048},
    { -216, 144, -1048},
    { -80, 96, -1032},
    { 8, 40, -912},
    { -128, 128, -1016},
    { -88, 104, -1008},
    { -48, 112, -1040},
    { -144, 104, -1048},
    { -128, 56, -1024},
    { -112, 16, -1016},
    { -88, 0, -1000},
    { -104, -40, -1000},
    { -168, -40, -984},
    { -152, 8, -992},
    { -152, 0, -1008},
    { -112, 0, -1024},
    { -64, 16, -1040},
    { -8, -24, -1080},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:22:13 local
AccelRawData *activity_sample_walk_150_pbl_25301_8(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_150_pbl_25301_8
  //> TEST_EXPECTED 150
  //> TEST_EXPECTED_MIN 90
  //> TEST_EXPECTED_MAX 170
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -8, 56, -1032},
    { 0, 80, -1040},
    { -16, 80, -1032},
    { 16, 64, -1032},
    { 0, 64, -1032},
    { 0, 72, -1032},
    { 0, 72, -1032},
    { 8, 80, -1040},
    { 16, 88, -1048},
    { 0, 88, -1040},
    { 0, 128, -1040},
    { 48, 136, -1032},
    { 32, 8, -1000},
    { 8, 136, -1040},
    { -24, 96, -1024},
    { -16, 88, -1048},
    { -32, 88, -1040},
    { 104, 72, -1056},
    { 32, 72, -1032},
    { 24, 72, -1040},
    { -16, 112, -1040},
    { 40, 112, -1016},
    { 48, 112, -1032},
    { 80, 104, -1064},
    { 80, 144, -1072},
    // 1 seconds
    { 280, -8, -1016},
    { -56, 192, -1056},
    { -264, 176, -1032},
    { -64, 200, -976},
    { -64, 176, -984},
    { -64, 128, -1008},
    { -136, 168, -1032},
    { -64, 136, -984},
    { -104, 136, -976},
    { -80, 152, -1016},
    { -40, 192, -1080},
    { -24, 80, -1032},
    { 0, -64, -936},
    { -8, 184, -792},
    { -48, 456, -704},
    { -120, 632, -648},
    { -200, 912, -568},
    { -224, 1160, -424},
    { -296, 1056, -288},
    { -272, 928, -256},
    { -224, 960, -64},
    { -216, 1088, -80},
    { -216, 1040, -32},
    { -200, 1200, 32},
    { -168, 1128, 120},
    // 2 seconds
    { -192, 1208, 248},
    { -192, 1216, 304},
    { -184, 1200, 328},
    { -104, 976, 240},
    { -160, 792, 216},
    { -248, 784, 288},
    { -272, 832, 344},
    { -208, 880, 376},
    { -168, 872, 328},
    { -232, 856, 248},
    { -288, 824, 224},
    { -296, 960, 24},
    { -344, 976, -104},
    { -432, 1008, -144},
    { -360, 1112, -120},
    { -320, 1176, -200},
    { -216, 1112, -192},
    { -40, 936, -256},
    { 240, 752, -248},
    { 608, 680, -24},
    { 960, 568, 120},
    { 1152, 432, 104},
    { 1336, 352, 216},
    { 1696, 400, 328},
    { 1952, 544, 424},
    // 3 seconds
    { 2000, 656, 336},
    { 1904, 776, 40},
    { 1568, 592, 232},
    { 1464, 472, 328},
    { 1472, 392, 216},
    { 1392, 432, 128},
    { 1280, 544, 176},
    { 1080, 720, 328},
    { 856, 1168, 208},
    { 672, 1656, 48},
    { 688, 672, 96},
    { 776, 728, 8},
    { 1368, 816, 112},
    { 1992, 656, 136},
    { 2048, 304, 160},
    { 2008, 160, 120},
    { 2136, 272, 88},
    { 2040, 424, 168},
    { 1560, 336, 216},
    { 1312, 304, 112},
    { 1192, 352, 0},
    { 976, 312, -144},
    { 1000, 56, -152},
    { 760, -192, 160},
    { 568, -120, 32},
    // 4 seconds
    { 864, 152, -152},
    { 1088, 320, -272},
    { 1232, 360, -224},
    { 1408, 304, -112},
    { 1752, 312, -104},
    { 1824, 440, -96},
    { 1600, 672, -320},
    { 1360, 432, -224},
    { 1680, 544, -112},
    { 1408, 560, -88},
    { 1072, 720, -152},
    { 1208, 984, -240},
    { 976, 888, -288},
    { 864, 552, -152},
    { 1136, 512, -64},
    { 1552, 456, 0},
    { 1504, 288, 32},
    { 1464, 240, 16},
    { 1520, 272, 40},
    { 1576, 328, 72},
    { 1520, 368, 152},
    { 1392, 320, 120},
    { 1288, 280, -16},
    { 1016, 232, -56},
    { 1096, 160, -112},
    // 5 seconds
    { 736, 72, -184},
    { 624, 48, -88},
    { 736, 176, -168},
    { 944, 272, -248},
    { 1112, 320, -288},
    { 1104, 304, -224},
    { 1168, 272, -136},
    { 1352, 280, -128},
    { 1432, 336, -256},
    { 1368, 392, -416},
    { 1288, 464, -320},
    { 1528, 552, -224},
    { 1328, 480, -272},
    { 1200, 504, -256},
    { 1240, 672, -376},
    { 1072, 680, -288},
    { 928, 480, -160},
    { 1104, 392, -72},
    { 1432, 360, -48},
    { 1296, 296, 8},
    { 1232, 256, 32},
    { 1280, 232, 48},
    { 1240, 272, 96},
    { 1160, 288, 160},
    { 1168, 312, 144},
    // 6 seconds
    { 1320, 320, 168},
    { 1256, 304, 48},
    { 1128, 272, 8},
    { 1072, 248, -128},
    { 864, 184, -272},
    { 816, 176, -280},
    { 912, 144, -344},
    { 1008, 144, -464},
    { 992, 128, -488},
    { 1008, 160, -456},
    { 1144, 192, -416},
    { 1256, 288, -488},
    { 1144, 472, -360},
    { 976, 680, -232},
    { 1464, 448, -160},
    { 1528, 472, 16},
    { 1136, 672, 112},
    { 1336, 968, -16},
    { 976, 824, -160},
    { 976, 440, 16},
    { 1224, 600, 136},
    { 1512, 520, 152},
    { 1368, 240, 120},
    { 1248, 152, 64},
    { 1240, 184, 0},
    // 7 seconds
    { 1248, 288, -32},
    { 1184, 344, 24},
    { 1256, 320, -64},
    { 1152, 352, -312},
    { 1008, 192, -384},
    { 1168, -144, 8},
    { 440, -144, 96},
    { 1176, 256, -224},
    { 1344, 408, -376},
    { 1472, 448, -392},
    { 1144, 336, -192},
    { 1096, 208, -168},
    { 1200, 304, -192},
    { 1208, 712, -448},
    { 928, 1112, -952},
    { 1248, 704, -576},
    { 1688, 432, -296},
    { 1032, 464, -280},
    { 1424, 704, -200},
    { 1248, 672, -144},
    { 1464, 552, -64},
    { 1512, 568, 128},
    { 1736, 544, 104},
    { 1552, 400, 80},
    { 1192, 256, 72},
    // 8 seconds
    { 1120, 232, -104},
    { 1072, 256, -184},
    { 984, 240, -136},
    { 896, 160, -176},
    { 952, 80, -320},
    { 672, 8, -440},
    { 704, -8, -40},
    { 912, 160, -32},
    { 1408, 264, -240},
    { 2072, 488, -392},
    { 2032, 488, -192},
    { 1416, 464, -216},
    { 888, 368, -240},
    { 976, 96, -256},
    { 1216, 96, -8},
    { 1360, 352, 72},
    { 1624, 672, 104},
    { 1584, 1032, 136},
    { 736, 1344, 328},
    { 1040, 1232, -200},
    { 1056, 408, -24},
    { 1264, 472, -56},
    { 1416, 800, 128},
    { 1752, 760, 136},
    { 1784, 368, 64},
    // 9 seconds
    { 1680, 120, 64},
    { 1456, 112, 72},
    { 1376, 280, -88},
    { 1104, 272, -88},
    { 1072, 248, 0},
    { 1048, 232, -104},
    { 744, 16, -160},
    { 936, -80, 8},
    { 1088, 88, -112},
    { 1520, 248, -176},
    { 1592, 224, -24},
    { 1552, 280, -136},
    { 1240, 312, -192},
    { 1120, 584, -32},
    { 1256, 440, 48},
    { 1448, 480, 112},
    { 1576, 576, 64},
    { 1520, 624, 264},
    { 1432, 920, 304},
    { 736, 1336, 144},
    { 1112, 848, 144},
    { 1008, 840, 128},
    { 1232, 696, 104},
    { 1496, 624, 88},
    { 1888, 520, 56},
    // 10 seconds
    { 1560, 320, 64},
    { 1448, 312, 16},
    { 1424, 272, 32},
    { 1456, 344, 8},
    { 1304, 288, 56},
    { 1152, 232, 104},
    { 1176, 240, 32},
    { 904, 216, 16},
    { 1120, 136, 112},
    { 920, 80, 144},
    { 1096, 296, -48},
    { 1136, 288, -40},
    { 1328, 328, -72},
    { 1352, 376, -152},
    { 1168, 352, -96},
    { 1168, 376, -128},
    { 1288, 384, -184},
    { 1400, 368, -256},
    { 1272, 536, -112},
    { 1512, 536, -128},
    { 1440, 808, -232},
    { 864, 744, -192},
    { 1288, 928, -328},
    { 1096, 688, -192},
    { 1296, 528, -72},
    // 11 seconds
    { 1448, 504, 40},
    { 1648, 408, 32},
    { 1480, 304, -8},
    { 1344, 240, 56},
    { 1320, 248, 72},
    { 1296, 296, 8},
    { 1136, 296, 40},
    { 1104, 224, 8},
    { 1112, 232, -48},
    { 816, 136, -120},
    { 936, 16, 24},
    { 856, 136, -40},
    { 1096, 368, -208},
    { 1320, 328, -328},
    { 1672, 368, -368},
    { 1264, 264, -120},
    { 952, 168, -144},
    { 1072, 288, -192},
    { 1264, 352, -184},
    { 1376, 416, -104},
    { 1184, 488, -64},
    { 1400, 584, -16},
    { 1440, 744, 40},
    { 872, 760, 40},
    { 1280, 928, -48},
    // 12 seconds
    { 960, 720, -104},
    { 1200, 568, -56},
    { 1240, 776, 0},
    { 1672, 1000, 0},
    { 1856, 648, 304},
    { 1664, 280, 384},
    { 1480, 80, 48},
    { 1320, 352, -104},
    { 1112, 368, -56},
    { 880, 176, -16},
    { 888, 64, -32},
    { 848, 96, -120},
    { 696, 80, -160},
    { 920, 40, -96},
    { 904, 64, -8},
    { 1296, 272, -176},
    { 1720, 352, -232},
    { 1960, 520, -288},
    { 1336, 504, -80},
    { 976, 328, -80},
    { 1176, 312, -40},
    { 1528, 264, -8},
    { 1400, 416, 32},
    { 1336, 560, 152},
    { 1560, 648, 328},
    // 13 seconds
    { 880, 1000, 744},
    { 1024, 1248, 424},
    { 856, 760, 368},
    { 1136, 760, 464},
    { 1424, 752, 632},
    { 1848, 848, 728},
    { 1920, 936, 784},
    { 2080, 976, 832},
    { 2024, 960, 856},
    { 1904, 1144, 584},
    { 1640, 1320, 360},
    { 1232, 96, 320},
    { 632, 256, -232},
    { 416, -232, -352},
    { 208, -416, -368},
    { 56, -592, -512},
    { 24, -352, -848},
    { 208, -456, -1008},
    { 296, -312, -1056},
    { 216, -360, -904},
    { 16, -352, -744},
    { -88, -368, -688},
    { -112, -328, -696},
    { -152, -256, -720},
    { -168, -264, -816},
    // 14 seconds
    { -208, -368, -944},
    { -160, -496, -1088},
    { -144, -424, -1192},
    { -296, -464, -1200},
    { -232, -120, -1168},
    { -224, -32, -1184},
    { -256, -16, -1112},
    { -240, -8, -976},
    { -128, 0, -920},
    { -96, -88, -808},
    { -120, -144, -696},
    { -136, -176, -704},
    { -144, -208, -808},
    { -168, -224, -904},
    { -160, -224, -952},
    { -48, -272, -1024},
    { -32, -248, -1048},
    { 24, -240, -1032},
    { 280, -72, -1024},
    { 384, 168, -1152},
    { 528, 192, -1192},
    { 576, 56, -1016},
    { 616, 96, -768},
    { 536, 192, -488},
    { 496, 344, -344},
    // 15 seconds
    { 464, 640, -400},
    { 512, 864, -648},
    { 440, 1064, -944},
    { 400, 680, -1096},
    { 560, 736, -1544},
    { 744, 616, -1576},
    { 440, 960, -1496},
    { 80, 1216, -1400},
    { -24, 1312, -1264},
    { 120, 912, -912},
    { 336, 704, -768},
    { 600, 624, -888},
    { 768, 464, -1080},
    { 640, -328, -1216},
    { 440, -64, -1208},
    { 656, 856, -992},
    { 680, 736, -608},
    { 504, 352, -344},
    { 296, 0, -216},
    { 160, 40, -384},
    { 136, 120, -192},
    { 544, 408, -296},
    { 832, 488, -592},
    { 1088, 416, -416},
    { 1680, 200, -56},
    // 16 seconds
    { 2360, 248, -72},
    { 1992, 520, -352},
    { 1336, 552, -272},
    { 1216, 336, -96},
    { 1488, 56, -160},
    { 1512, 168, -280},
    { 1608, 632, -24},
    { 1688, 968, -40},
    { 1056, 1192, 80},
    { 1112, 1160, -368},
    { 960, 648, -256},
    { 1104, 552, -176},
    { 1128, 576, -16},
    { 1656, 560, -16},
    { 1872, 320, -8},
    { 1712, 160, 8},
    { 1504, 128, 96},
    { 1488, 392, -56},
    { 1312, 392, 0},
    { 1104, 408, 48},
    { 1128, 320, 0},
    { 1064, 304, -96},
    { 792, 192, -96},
    { 840, 96, -8},
    { 624, 32, 112},
    // 17 seconds
    { 976, 232, -48},
    { 1400, 352, -152},
    { 1840, 552, -360},
    { 1408, 512, -360},
    { 920, 312, -192},
    { 1056, 224, -160},
    { 1376, 176, -240},
    { 1368, 320, -184},
    { 1208, 536, -40},
    { 1488, 648, 48},
    { 1392, 816, 48},
    { 1032, 768, 40},
    { 1304, 816, -88},
    { 1176, 656, -104},
    { 944, 512, -40},
    { 1024, 600, 56},
    { 1392, 600, 24},
    { 1480, 392, 48},
    { 1400, 176, 104},
    { 1320, 88, 104},
    { 1296, 216, 8},
    { 1128, 272, 56},
    { 968, 344, 40},
    { 1176, 376, -8},
    { 960, 320, -72},
    // 18 seconds
    { 824, 240, -56},
    { 1144, 160, -32},
    { 832, 112, 96},
    { 960, 304, -160},
    { 1176, 344, -280},
    { 1448, 400, -288},
    { 1192, 336, -184},
    { 992, 200, -112},
    { 1120, 256, -144},
    { 1272, 328, -128},
    { 1264, 448, -120},
    { 1032, 520, -104},
    { 1352, 592, -88},
    { 1184, 696, 24},
    { 952, 592, -104},
    { 1384, 656, -136},
    { 1376, 728, -128},
    { 1104, 576, -32},
    { 1248, 576, 8},
    { 1416, 536, -24},
    { 1328, 344, 136},
    { 1256, 48, 152},
    { 1224, 64, 24},
    { 1272, 136, -72},
    { 1128, 248, 16},
    // 19 seconds
    { 1112, 296, 96},
    { 1216, 328, 64},
    { 968, 312, -88},
    { 1224, 304, -120},
    { 912, 160, 40},
    { 936, 216, -88},
    { 1112, 280, -224},
    { 1192, 280, -176},
    { 1088, 256, -152},
    { 912, 232, -128},
    { 1000, 312, -200},
    { 1112, 336, -200},
    { 1136, 376, -168},
    { 1064, 408, -80},
    { 1432, 488, -24},
    { 1672, 632, -32},
    { 1144, 624, 72},
    { 1352, 728, -88},
    { 992, 872, -152},
    { 856, 544, -128},
    { 912, 504, -64},
    { 1192, 592, 8},
    { 1352, 496, 0},
    { 1296, 272, 64},
    { 1352, 120, 96},
    // 20 seconds
    { 1360, 176, -8},
    { 1240, 224, -8},
    { 1032, 240, 8},
    { 920, 232, -24},
    { 1000, 264, -24},
    { 920, 272, -104},
    { 928, 224, -136},
    { 1152, 152, -80},
    { 1048, 168, -16},
    { 1256, 248, -144},
    { 1440, 272, -120},
    { 1328, 312, -96},
    { 1056, 312, -184},
    { 1064, 344, -200},
    { 1096, 360, -24},
    { 1184, 424, 16},
    { 1072, 456, 0},
    { 1080, 472, -48},
    { 1544, 576, 56},
    { 1184, 688, 176},
    { 1032, 776, 24},
    { 1144, 840, -24},
    { 1016, 608, -80},
    { 944, 512, -16},
    { 1104, 632, 16},
    // 21 seconds
    { 1408, 656, 40},
    { 1528, 456, 112},
    { 1488, 248, 136},
    { 1456, 120, 104},
    { 1368, 176, -8},
    { 1168, 232, 0},
    { 960, 256, -32},
    { 968, 288, -56},
    { 944, 288, -144},
    { 824, 256, -232},
    { 1128, 184, -120},
    { 976, 128, 32},
    { 1096, 216, -112},
    { 1240, 288, -176},
    { 1304, 344, -128},
    { 1144, 320, -80},
    { 1000, 272, -136},
    { 1080, 328, -64},
    { 1256, 384, 0},
    { 1360, 464, -24},
    { 1104, 480, -16},
    { 1184, 480, 64},
    { 1400, 592, 56},
    { 1120, 544, 40},
    { 1120, 624, -80},
    // 22 seconds
    { 1168, 816, -168},
    { 1080, 864, -224},
    { 936, 528, -112},
    { 1048, 544, -56},
    { 1272, 504, -40},
    { 1280, 336, 56},
    { 1344, 200, 80},
    { 1376, 176, 32},
    { 1352, 264, 0},
    { 1208, 272, 64},
    { 1048, 280, 48},
    { 1160, 280, 16},
    { 1000, 264, -8},
    { 904, 120, -72},
    { 1184, -192, 168},
    { 944, 144, 80},
    { 1264, 328, -160},
    { 1312, 280, -184},
    { 1272, 320, -160},
    { 992, 256, -120},
    { 896, 216, -184},
    { 1048, 304, -200},
    { 1168, 336, -152},
    { 1248, 368, -120},
    { 1056, 400, -104},
    // 23 seconds
    { 1448, 448, -144},
    { 1568, 600, -232},
    { 1032, 648, -144},
    { 1232, 816, -480},
    { 1152, 480, -320},
    { 1112, 456, -152},
    { 1288, 456, -64},
    { 1488, 408, -56},
    { 1440, 304, -64},
    { 1280, 224, -16},
    { 1216, 208, 32},
    { 1208, 224, -72},
    { 1120, 208, -200},
    { 992, 112, -40},
    { 1032, 160, 168},
    { 960, 320, -72},
    { 840, 360, -248},
    { 944, 312, -112},
    { 816, 272, 32},
    { 1192, 328, -72},
    { 1576, 448, -336},
    { 1544, 408, -160},
    { 1144, 264, -72},
    { 896, 168, -192},
    { 896, 56, -208},
    // 24 seconds
    { 1168, 120, -128},
    { 1176, 472, -64},
    { 1064, 712, 8},
    { 1360, 848, 168},
    { 1520, 944, 88},
    { 1024, 592, 16},
    { 1272, 488, 80},
    { 1048, 640, 40},
    { 976, 624, 16},
    { 1080, 656, 88},
    { 1424, 640, 192},
    { 1504, 496, 184},
    { 1440, 288, 192},
    { 1480, 128, 112},
    { 1424, 96, 24},
    { 1256, 176, -16},
    { 1064, 208, -80},
    { 1000, 280, -184},
    { 936, 232, -144},
    { 728, 208, -256},
    { 816, 160, -176},
    { 664, 184, -56},
    { 928, 320, -72},
    { 1368, 496, -408},
    { 1824, 808, -960},
    // 25 seconds
    { 1080, 456, 280},
    { 784, -136, 208},
    { 872, -24, -32},
    { 1016, -32, 16},
    { 1416, 376, 104},
    { 1448, 848, -32},
    { 1272, 712, 112},
    { 1504, 720, 0},
    { 1304, 832, -144},
    { 1008, 1360, -120},
    { 1104, 424, -464},
    { 1008, 392, -224},
    { 1008, 584, -152},
    { 1296, 584, -88},
    { 1528, 512, -48},
    { 1504, 208, -16},
    { 1480, 80, -32},
    { 1536, 8, 48},
    { 1536, 168, -136},
    { 1352, 768, 656},
    { 1400, 1184, 984},
    { 520, 1200, 960},
    { 552, 848, 88},
    { -144, -200, -824},
    { 160, -312, 168},
    // 26 seconds
    { 184, 1176, 560},
    { -376, 2728, 2656},
    { -880, 1600, 1056},
    { 1808, -1160, 3096},
    { 184, -1632, -1576},
    { -160, -968, -664},
    { -216, 1152, -840},
    { -128, 824, -1336},
    { -72, -312, -1024},
    { -80, -432, -920},
    { -24, -192, -1008},
    { 104, -96, -1096},
    { 0, 16, -1160},
    { -40, 128, -1168},
    { -24, 208, -1168},
    { -96, 160, -1088},
    { -144, 208, -960},
    { -88, 216, -928},
    { -8, 128, -880},
    { -8, -16, -816},
    { -64, 0, -792},
    { -88, 32, -840},
    { -80, 48, -904},
    { -24, 24, -976},
    { 56, -136, -1112},
    // 27 seconds
    { 104, -152, -1200},
    { 40, -176, -1232},
    { 88, -16, -1328},
    { 216, 136, -1368},
    { 304, 128, -1184},
    { 320, 48, -960},
    { 336, 120, -824},
    { 216, 32, -672},
    { 48, -8, -608},
    { 104, -216, -584},
    { 328, -520, -600},
    { 632, 168, -320},
    { 544, 624, 376},
    { 352, 240, 1056},
    { 336, -192, 2112},
    { 336, 1648, 2552},
    { -144, 1640, 3088},
    { 104, -296, 264},
    { 1000, -608, 1224},
    { 344, 232, 1216},
    { -288, 864, 1384},
    { -184, 656, 1304},
    { -16, 632, 1048},
    { 120, 992, 808},
    { 128, 1112, 712},
    // 28 seconds
    { 200, 1200, 8},
    { 128, 720, 88},
    { 248, 104, -624},
    { 240, 176, -832},
    { 192, 48, -736},
    { 248, -216, -856},
    { 168, -112, -1040},
    { 160, 48, -1160},
    { 256, 0, -1216},
    { 328, -64, -1176},
    { 232, -96, -1032},
    { 72, -112, -840},
    { -40, -88, -744},
    { -64, -96, -720},
    { -40, -96, -792},
    { 96, 72, -1080},
    { 216, 72, -1144},
    { 128, -272, -1008},
    { -96, -296, -872},
    { -232, -240, -824},
    { -456, 816, -888},
    { -696, 1392, -688},
    { -736, 1208, -568},
    { -856, 944, -472},
    { -720, 536, -800},
    // 29 seconds
    { -296, 512, -1080},
    { -328, 496, -744},
    { -384, 624, -584},
    { -424, 520, -656},
    { -480, 336, -656},
    { -480, 112, -456},
    { -424, -264, -280},
    { -112, -240, -72},
    { 496, 256, 64},
    { 1192, 480, 368},
    { 1824, 1288, 424},
    { 2120, 1752, -384},
    { 1864, 1200, -552},
    { 1680, 328, 168},
    { 1296, 328, -224},
    { 1008, 40, -48},
    { 1096, 96, 0},
    { 1232, 392, -40},
    { 1160, 568, -72},
    { 1072, 632, -48},
    { 1064, 632, -8},
    { 1592, 728, 40},
    { 1304, 1000, 232},
    { 984, 1192, -240},
    { 1008, 520, -56},
    // 30 seconds
    { 1008, 640, -64},
    { 1032, 736, 40},
    { 1392, 680, 96},
    { 1712, 528, 56},
    { 1552, 368, 40},
    { 1472, 264, 88},
    { 1400, 216, 56},
    { 1280, 208, 8},
    { 1040, 208, 24},
    { 848, 208, 56},
    { 1000, 232, 48},
    { 928, 296, -40},
    { 904, 336, -120},
    { 1104, 280, -56},
    { 1120, 296, -112},
    { 1192, 344, -216},
    { 1456, 392, -320},
    { 1320, 384, -232},
    { 960, 248, -168},
    { 920, 184, -168},
    { 1008, 240, -152},
    { 1072, 320, -136},
    { 1136, 408, -112},
    { 1112, 472, -48},
    { 1560, 624, -32},
    // 31 seconds
    { 1400, 808, -32},
    { 848, 760, -88},
    { 1384, 720, -144},
    { 824, 648, -128},
    { 1096, 592, -72},
    { 1216, 664, 16},
    { 1520, 576, 56},
    { 1496, 408, 96},
    { 1528, 264, 128},
    { 1608, 184, 40},
    { 1416, 216, -24},
    { 1128, 248, 24},
    { 936, 248, 64},
    { 1016, 272, 40},
    { 992, 312, -136},
    { 1040, 288, -296},
    { 984, 128, -16},
    { 1088, 96, -56},
    { 1248, 200, -120},
    { 1512, 296, -112},
    { 1368, 416, -128},
    { 1120, 376, -112},
    { 1176, 416, -88},
    { 1200, 440, 88},
    { 1336, 472, 144},
    // 32 seconds
    { 1216, 512, 24},
    { 1344, 520, 56},
    { 1576, 624, 160},
    { 992, 720, 200},
    { 1328, 888, 64},
    { 760, 800, -72},
    { 992, 608, -40},
    { 944, 624, -8},
    { 1176, 680, 64},
    { 1504, 600, 80},
    { 1464, 400, 136},
    { 1472, 240, 128},
    { 1504, 216, 88},
    { 1472, 264, 32},
    { 1304, 280, 32},
    { 1128, 232, -24},
    { 1144, 224, -16},
    { 928, 224, -128},
    { 808, 168, -40},
    { 920, 176, -96},
    { 928, 248, -80},
    { 1072, 312, -240},
    { 1344, 328, -264},
    { 1264, 280, -56},
    { 1096, 248, -32},
    // 33 seconds
    { 1040, 312, -144},
    { 1136, 384, -48},
    { 1336, 432, -16},
    { 1224, 464, -24},
    { 1160, 480, 0},
    { 1496, 552, 8},
    { 1256, 672, 168},
    { 1072, 928, -24},
    { 1232, 840, -128},
    { 1136, 560, -96},
    { 968, 520, -80},
    { 1144, 640, -8},
    { 1400, 632, -8},
    { 1448, 392, 48},
    { 1448, 128, 128},
    { 1344, 72, 80},
    { 1352, 208, 8},
    { 1152, 248, 16},
    { 1144, 336, 24},
    { 1272, 344, -48},
    { 896, 320, -192},
    { 1088, 240, -160},
    { 816, 160, -144},
    { 752, 136, 0},
    { 904, 216, -128},
    // 34 seconds
    { 1216, 352, -312},
    { 1304, 408, -320},
    { 952, 280, -168},
    { 920, 176, -72},
    { 1200, 288, -136},
    { 1464, 392, -256},
    { 1184, 456, -256},
    { 1040, 472, -192},
    { 1480, 688, -136},
    { 1128, 712, -48},
    { 1480, 568, -80},
    { 960, 544, -144},
    { 864, 528, -168},
    { 856, 520, -80},
    { 1112, 560, 16},
    { 1400, 472, 56},
    { 1320, 328, 64},
    { 1296, 216, 64},
    { 1224, 200, 8},
    { 1200, 320, -64},
    { 1040, 352, -120},
    { 920, 328, -120},
    { 1136, 296, -152},
    { 1032, 264, -312},
    { 984, 112, -40},
    // 35 seconds
    { 1200, 48, 24},
    { 1128, 168, -80},
    { 1144, 288, -120},
    { 1248, 328, -88},
    { 1152, 352, -112},
    { 944, 288, -120},
    { 1016, 304, -56},
    { 1232, 360, 24},
    { 1296, 448, -56},
    { 968, 464, -144},
    { 1080, 480, -72},
    { 1640, 696, -8},
    { 944, 728, 96},
    { 1384, 664, -64},
    { 832, 616, -112},
    { 872, 560, -120},
    { 880, 520, 16},
    { 1144, 512, 88},
    { 1488, 400, 72},
    { 1392, 328, 48},
    { 1360, 264, 40},
    { 1368, 248, -8},
    { 1296, 288, -64},
    { 1032, 280, -80},
    { 864, 256, -64},
    // 36 seconds
    { 1144, 264, -184},
    { 944, 248, -256},
    { 1200, 88, -24},
    { 960, 24, 16},
    { 1000, 208, -152},
    { 1176, 304, -160},
    { 1312, 336, -88},
    { 1328, 360, -120},
    { 1200, 360, -128},
    { 1088, 400, -56},
    { 1056, 440, 32},
    { 1216, 408, -72},
    { 1072, 392, -56},
    { 1064, 408, -32},
    { 1392, 592, 0},
    { 976, 728, 232},
    { 1152, 960, -80},
    { 1144, 608, -96},
    { 984, 504, -80},
    { 952, 536, 24},
    { 1216, 576, 64},
    { 1576, 448, 72},
    { 1424, 320, 64},
    { 1408, 200, 112},
    { 1336, 224, 64},
    // 37 seconds
    { 1224, 232, 32},
    { 952, 280, 0},
    { 1040, 272, -24},
    { 1168, 272, -64},
    { 928, 72, -32},
    { 1152, -16, 72},
    { 1040, 136, -16},
    { 1040, 288, -168},
    { 1184, 288, -160},
    { 1288, 288, -136},
    { 1216, 320, -168},
    { 1096, 536, -120},
    { 1088, 448, -80},
    { 1096, 376, 16},
    { 1240, 440, -24},
    { 1152, 448, -16},
    { 1336, 512, 64},
    { 1320, 632, 128},
    { 920, 688, 104},
    { 1240, 768, -8},
    { 976, 576, -80},
    { 992, 512, -32},
    { 1064, 592, 48},
    { 1384, 624, 32},
    { 1480, 536, -24},
    // 38 seconds
    { 1312, 472, 400},
    { 1400, 64, 280},
    { 1272, 152, 40},
    { 1048, 136, 32},
    { 816, 264, -16},
    { 1048, 280, -24},
    { 1008, 280, 32},
    { 952, 240, -8},
    { 1264, 256, -32},
    { 1048, 232, -40},
    { 1016, 272, -144},
    { 1160, 296, -152},
    { 1272, 320, -144},
    { 1104, 288, -128},
    { 1016, 280, -104},
    { 1112, 344, -24},
    { 1208, 440, 16},
    { 1208, 512, -48},
    { 1080, 528, -48},
    { 1376, 656, 16},
    { 1040, 768, 40},
    { 1184, 560, 16},
    { 1192, 664, -104},
    { 1128, 624, -88},
    { 1008, 560, -16},
    // 39 seconds
    { 1216, 576, 0},
    { 1448, 512, -16},
    { 1400, 384, 56},
    { 1416, 48, 160},
    { 1216, 80, 32},
    { 1112, 160, -8},
    { 936, 264, -40},
    { 936, 336, -32},
    { 1096, 304, -16},
    { 856, 264, -88},
    { 1320, 152, -32},
    { 1176, 96, 96},
    { 1216, 272, -96},
    { 1216, 280, -184},
    { 1216, 256, -88},
    { 1136, 288, -88},
    { 1032, 296, -128},
    { 1072, 368, -88},
    { 1144, 432, -16},
    { 1184, 488, -72},
    { 1016, 488, -144},
    { 1144, 496, -88},
    { 1488, 616, -64},
    { 976, 584, 0},
    { 1472, 696, -8},
    // 40 seconds
    { 904, 736, -168},
    { 1064, 528, -88},
    { 1072, 512, 24},
    { 1336, 528, 80},
    { 1472, 400, 56},
    { 1304, 288, 72},
    { 1312, 208, 48},
    { 1280, 224, -32},
    { 1168, 264, -48},
    { 992, 240, -32},
    { 1008, 224, -48},
    { 1016, 240, -112},
    { 800, 216, -184},
    { 1112, 176, -120},
    { 1016, 184, -56},
    { 1168, 280, -160},
    { 1320, 320, -200},
    { 1416, 376, -192},
    { 1144, 344, -128},
    { 936, 296, -168},
    { 912, 344, -72},
    { 1104, 376, -24},
    { 1280, 456, -32},
    { 1136, 528, -48},
    { 1208, 560, 32},
    // 41 seconds
    { 1208, 672, 72},
    { 952, 664, -8},
    { 1424, 552, -32},
    { 1072, 568, -88},
    { 976, 528, -40},
    { 1112, 552, 8},
    { 1320, 536, -40},
    { 1296, 472, -88},
    { 1312, 160, 104},
    { 1160, 40, 96},
    { 1072, 176, -8},
    { 992, 240, -24},
    { 920, 336, -16},
    { 1192, 336, -24},
    { 968, 320, -72},
    { 1216, 216, -8},
    { 1200, 168, 56},
    { 1096, 216, -8},
    { 976, 280, -176},
    { 1152, 320, -192},
    { 1136, 336, -176},
    { 888, 256, -128},
    { 848, 256, -160},
    { 984, 328, -104},
    { 1144, 416, -64},
    // 42 seconds
    { 1072, 488, -136},
    { 1080, 512, -104},
    { 1448, 608, -112},
    { 1104, 632, 16},
    { 1192, 552, -136},
    { 1136, 536, -192},
    { 1080, 552, -136},
    { 1024, 488, -56},
    { 1208, 496, -56},
    { 1464, 480, -80},
    { 1304, 376, 24},
    { 1232, 40, 136},
    { 1200, 128, -104},
    { 1032, 160, -48},
    { 808, 440, -192},
    { 800, 336, -88},
    { 1064, 248, -32},
    { 1000, 208, -104},
    { 1264, 136, 8},
    { 1064, 80, 192},
    { 1176, 248, 32},
    { 1280, 320, -136},
    { 1256, 328, 8},
    { 1136, 272, -8},
    { 336, -688, -392},
    // 43 seconds
    { 600, 992, -632},
    { 800, -184, 488},
    { 1160, 872, -152},
    { 1024, 400, 224},
    { 1256, 328, 168},
    { 1624, 592, 8},
    { 1072, 704, -56},
    { 1336, 600, -80},
    { 904, 672, -176},
    { 1032, 608, -184},
    { 992, 536, -64},
    { 1280, 528, -24},
    { 1464, 416, 8},
    { 1320, 304, 8},
    { 1232, 192, 64},
    { 1216, 224, 8},
    { 1168, 256, -48},
    { 1024, 264, 8},
    { 984, 232, 16},
    { 1088, 224, 16},
    { 968, 264, -56},
    { 984, 216, -32},
    { 1144, 240, -16},
    { 1184, 272, -24},
    { 1104, 312, -240},
    // 44 seconds
    { 1272, 280, -176},
    { 1280, 272, 48},
    { 1184, 280, -40},
    { 1080, 368, -160},
    { 1024, 448, -96},
    { 1016, 416, -80},
    { 1040, 424, -72},
    { 1000, 416, -112},
    { 1224, 496, -88},
    { 1320, 616, 8},
    { 952, 672, 32},
    { 1440, 760, -128},
    { 1136, 640, -88},
    { 1056, 560, -56},
    { 1168, 584, 32},
    { 1464, 544, 80},
    { 1472, 392, 112},
    { 1392, 232, 144},
    { 1336, 184, 80},
    { 1264, 216, 24},
    { 1096, 264, 32},
    { 968, 256, 0},
    { 960, 240, -8},
    { 904, 232, -32},
    { 768, 248, -152},
    // 45 seconds
    { 776, 232, -272},
    { 1168, 224, -48},
    { 1128, 232, -64},
    { 1240, 264, -176},
    { 1496, 336, -224},
    { 1472, 408, -80},
    { 1136, 352, -96},
    { 968, 320, -112},
    { 1040, 392, -24},
    { 1128, 408, -24},
    { 1112, 456, -16},
    { 1048, 496, -32},
    { 1368, 576, 24},
    { 1232, 720, 192},
    { 896, 760, -72},
    { 1392, 568, -48},
    { 1184, 648, -104},
    { 1048, 640, -32},
    { 1176, 680, 32},
    { 1528, 584, 72},
    { 1496, 392, 128},
    { 1400, 200, 176},
    { 1368, 184, 72},
    { 1296, 184, 56},
    { 1152, 248, 40},
    // 46 seconds
    { 960, 256, 24},
    { 1080, 264, -16},
    { 968, 248, -16},
    { 864, 248, -56},
    { 1040, 264, -120},
    { 1032, 264, -96},
    { 1056, 304, -128},
    { 1368, 328, -296},
    { 1272, 288, -128},
    { 1032, 240, -80},
    { 944, 264, -176},
    { 1048, 320, -168},
    { 1176, 352, -128},
    { 1184, 416, -152},
    { 1000, 432, -152},
    { 1344, 544, -152},
    { 1504, 696, -96},
    { 1224, 624, -32},
    { 1176, 616, -192},
    { 1096, 576, -216},
    { 936, 536, -104},
    { 1024, 528, -32},
    { 1240, 464, -8},
    { 1240, 352, 16},
    { 1208, 248, 56},
    // 47 seconds
    { 1224, 224, 32},
    { 1264, 264, 0},
    { 1200, 288, 32},
    { 1016, 264, 0},
    { 1008, 248, -8},
    { 1088, 280, -104},
    { 840, 256, -152},
    { 1344, 208, -40},
    { 992, 144, 48},
    { 1160, 272, -168},
    { 1304, 280, -208},
    { 1280, 296, -144},
    { 1024, 272, -88},
    { 824, 256, -152},
    { 912, 312, -128},
    { 1064, 328, -32},
    { 1200, 400, -24},
    { 1128, 472, -48},
    { 1448, 536, -88},
    { 1488, 640, -104},
    { 1048, 608, -8},
    { 1504, 792, -216},
    { 864, 656, -200},
    { 1080, 560, -160},
    { 1032, 592, -88},
    // 48 seconds
    { 1272, 568, -16},
    { 1440, 392, 48},
    { 1344, 232, 88},
    { 1320, 200, 72},
    { 1328, 240, 24},
    { 1256, 272, 40},
    { 1048, 264, 56},
    { 1056, 240, 56},
    { 1104, 248, 16},
    { 880, 272, -112},
    { 1056, 224, -152},
    { 904, 176, -96},
    { 1040, 248, -152},
    { 1144, 288, -376},
    { 1256, 320, -296},
    { 1064, 280, -200},
    { 896, 184, -128},
    { 928, 264, -136},
    { 1032, 336, -128},
    { 1104, 376, -152},
    { 1088, 376, -64},
    { 1264, 416, 0},
    { 1800, 576, 8},
    { 1296, 680, 128},
    { 1168, 704, -112},
    // 49 seconds
    { 1096, 736, -168},
    { 912, 744, -160},
    { 880, 616, -88},
    { 1024, 664, -72},
    { 1288, 512, -32},
    { 1272, 320, 40},
    { 1360, 144, 48},
    { 1496, 152, 0},
    { 1368, 248, -8},
    { 1144, 288, -24},
    { 1144, 344, -8},
    { 1264, 360, -80},
    { 992, 352, -232},
    { 1168, 128, -64},
    { 864, -144, 136},
    { 1088, 216, -256},
    { 1120, 248, -232},
    { 1208, 232, -112},
    { 1032, 216, -152},
    { 888, 248, -152},
    { 1048, 328, -136},
    { 1144, 360, -112},
    { 1136, 392, -88},
    { 1112, 416, -16},
    { 1496, 496, 0},
    // 50 seconds
    { 1648, 624, 16},
    { 1184, 648, 32},
    { 1368, 864, -160},
    { 784, 784, -240},
    { 936, 464, -112},
    { 1000, 568, -48},
    { 1216, 608, -8},
    { 1320, 440, 8},
    { 1192, 272, 0},
    { 1200, 200, 24},
    { 1304, 280, -32},
    { 1200, 352, -40},
    { 1024, 328, -64},
    { 1096, 280, -24},
    { 1248, 288, -112},
    { 896, 256, -144},
    { 1360, 192, -96},
    { 992, 120, 0},
    { 1032, 272, -184},
    { 1080, 272, -224},
    { 1144, 256, -136},
    { 1016, 216, -120},
    { 864, 256, -128},
    { 896, 312, -96},
    { 1088, 360, -64},
    // 51 seconds
    { 1216, 392, -40},
    { 1152, 432, -56},
    { 1360, 488, -24},
    { 1688, 656, -48},
    { 1104, 728, 96},
    { 1480, 776, -152},
    { 920, 616, -144},
    { 992, 520, -128},
    { 1008, 576, -40},
    { 1184, 600, 8},
    { 1336, 504, 8},
    { 1304, 360, 80},
    { 1256, 112, 160},
    { 1264, 192, -8},
    { 1128, 208, -16},
    { 952, 256, -8},
    { 968, 248, 8},
    { 1152, 256, -8},
    { 1016, 280, -104},
    { 1184, 296, -128},
    { 1216, 232, -208},
    { 1104, 184, -208},
    { 1088, 160, -208},
    { 1216, 152, -248},
    { 1144, 208, -232},
    // 52 seconds
    { 896, 248, -272},
    { 816, 288, -232},
    { 896, 296, -128},
    { 1032, 360, -128},
    { 1056, 424, -128},
    { 1032, 448, -120},
    { 1552, 512, -104},
    { 1408, 624, -24},
    { 1096, 584, -8},
    { 1376, 672, -80},
    { 904, 704, -152},
    { 992, 576, -80},
    { 1072, 632, 16},
    { 1352, 592, 32},
    { 1392, 408, 104},
    { 1320, 160, 64},
    { 1320, -32, -136},
    { 1248, 168, 64},
    { 1200, 344, -40},
    { 1080, 384, -120},
    { 1112, 336, -96},
    { 1032, 336, -344},
    { 944, 216, -512},
    { 1496, 88, -360},
    { 1032, -40, -128},
    // 53 seconds
    { 992, 0, -56},
    { 1408, 304, -240},
    { 1536, 496, -280},
    { 1192, 440, -216},
    { 992, 424, 8},
    { 1008, 400, 168},
    { 1192, 424, 104},
    { 1176, 448, 88},
    { 1024, 488, 80},
    { 1424, 672, 256},
    { 1216, 1000, 0},
    { 928, 992, -8},
    { 1064, 576, 24},
    { 1000, 576, -96},
    { 1056, 568, -112},
    { 1288, 680, 40},
    { 1664, 640, 144},
    { 1808, 400, 144},
    { 1560, 192, 152},
    { 1464, 168, 72},
    { 1352, 224, 0},
    { 1160, 288, -48},
    { 936, 272, -40},
    { 1032, 248, -56},
    { 928, 232, -176},
    // 54 seconds
    { 776, 168, -168},
    { 864, 104, -56},
    { 864, 168, 0},
    { 1096, 296, -152},
    { 1360, 368, -128},
    { 1632, 440, -120},
    { 1344, 472, -112},
    { 1080, 400, -144},
    { 1144, 336, -48},
    { 1432, 280, -136},
    { 1384, 488, -80},
    { 1096, 472, -24},
    { 1392, 544, -88},
    { 1312, 744, -80},
    { 1040, 1096, 32},
    { 1152, 768, -216},
    { 1136, 544, -120},
    { 1152, 584, -72},
    { 1400, 680, 0},
    { 1976, 824, -8},
    { 1992, 880, 88},
    { 2016, 944, 144},
    { 1968, 1264, 376},
    { 1536, 600, 32},
    { 1128, 472, -320},
    // 55 seconds
    { 752, 400, -304},
    { 576, 160, -288},
    { 480, -176, -480},
    { 328, -320, -568},
    { 216, -408, -752},
    { 160, -280, -872},
    { 248, -288, -952},
    { 264, -288, -952},
    { 248, -224, -912},
    { 120, -192, -840},
    { -48, -176, -776},
    { -120, -208, -800},
    { -128, -192, -872},
    { -104, -200, -928},
    { -96, -240, -992},
    { 40, -304, -1208},
    { 280, -384, -1448},
    { 176, -144, -1392},
    { -288, 336, -560},
    { -1008, 384, 736},
    { -1744, 416, 1592},
    { -1472, 680, 1232},
    { -808, 776, 680},
    { -552, 416, 304},
    { -584, 8, 408},
    // 56 seconds
    { -528, 224, 72},
    { -632, 200, 0},
    { -672, 136, -48},
    { -696, 704, -208},
    { -872, 368, -120},
    { -976, 336, -8},
    { -1088, 480, -152},
    { -1272, 480, -216},
    { -1184, 584, -16},
    { -952, 496, 280},
    { -664, 352, 144},
    { -688, 400, 32},
    { -672, 416, -120},
    { -608, 304, -208},
    { -552, 144, -152},
    { -640, 208, -160},
    { -608, 216, -288},
    { -696, 200, -296},
    { -968, 320, -352},
    { -1184, 248, -400},
    { -1248, 312, -320},
    { -1352, 136, -168},
    { -1376, 424, 48},
    { -1200, 480, 48},
    { -968, 344, 96},
    // 57 seconds
    { -912, 320, -24},
    { -880, 528, 8},
    { -584, 224, -64},
    { -472, 208, -168},
    { -496, 184, -96},
    { -536, 176, -160},
    { -664, 112, -296},
    { -840, 48, -416},
    { -920, -280, -392},
    { -680, -360, -328},
    { -608, 1440, -568},
    { -1056, 2816, -816},
    { -920, 1304, 136},
    { 56, -568, -1104},
    { 120, -688, -1448},
    { 40, -80, -848},
    { 176, 824, -752},
    { -24, 744, -952},
    { -152, -8, -792},
    { -256, -48, -648},
    { -288, -32, -696},
    { -360, -120, -824},
    { -504, -64, -984},
    { -424, 112, -1128},
    { -456, 272, -1224},
    // 58 seconds
    { -448, 328, -1296},
    { -416, 392, -1232},
    { -240, 320, -1088},
    { -272, 152, -872},
    { -272, 328, -864},
    { -152, 352, -960},
    { -120, 200, -880},
    { -168, 64, -736},
    { -224, 88, -744},
    { -256, 64, -816},
    { -256, 72, -904},
    { -312, 112, -1024},
    { -272, 16, -1144},
    { -216, 56, -1216},
    { -288, 88, -1256},
    { -96, 176, -1328},
    { 96, 176, -1264},
    { 160, 136, -1104},
    { 224, 64, -912},
    { 320, 8, -784},
    { 352, 16, -576},
    { 368, 136, -328},
    { 344, 192, -80},
    { 384, 296, 104},
    { 448, 352, 336},
    // 59 seconds
    { 600, 432, 552},
    { 912, 624, 728},
    { 1464, 1192, 1160},
    { 1960, 1616, 1072},
    { 3216, 976, 256},
    { 2040, 1272, 1456},
    { 1272, 392, -352},
    { 736, 496, 120},
    { 496, 1256, 472},
    { 624, 1176, 320},
    { 632, 616, 80},
    { 808, 624, -120},
    { 1080, 504, 152},
    { 1424, 352, 248},
    { 1416, 344, 72},
    { 1360, 384, -64},
    { 1648, 456, -48},
    { 1416, 392, 16},
    { 1264, 280, -144},
    { 1416, 296, 0},
    { 792, 160, -120},
    { 936, 56, -296},
    { 1048, 40, -304},
    { 1056, 128, -248},
    { 872, 144, -280},
    // 60 seconds
    // elapsed: 1 minutes
    { 776, 192, -224},
    { 808, 248, -168},
    { 936, 280, -168},
    { 1072, 336, -56},
    { 1200, 408, -8},
    { 1368, 488, 0},
    { 1928, 640, -112},
    { 1368, 720, -56},
    { 1016, 560, -80},
    { 1296, 648, -120},
    { 912, 688, -144},
    { 1032, 680, -80},
    { 1000, 672, -64},
    { 1200, 608, -32},
    { 1344, 488, 48},
    { 1304, 296, 120},
    { 1352, 208, 104},
    { 1312, 280, 56},
    { 1176, 432, 0},
    { 1016, 344, 16},
    { 1032, 288, 16},
    { 1096, 264, 80},
    { 976, 272, -32},
    { 1000, 280, -208},
    { 1144, 192, -112},
    // 61 seconds
    { 960, 200, -128},
    { 1176, 256, -280},
    { 1336, 232, -224},
    { 1376, 280, -104},
    { 1104, 272, -136},
    { 968, 440, -192},
    { 1096, 408, -168},
    { 1176, 432, -40},
    { 1168, 448, -8},
    { 1128, 456, 40},
    { 1304, 488, 16},
    { 1368, 552, 24},
    { 1432, 696, 40},
    { 1120, 960, -40},
    { 824, 696, -264},
    { 736, 408, -72},
    { 952, 568, 8},
    { 1528, 568, 8},
    { 1560, 336, 64},
    { 1520, 456, -8},
    { 1600, 624, 0},
    { 1576, 712, 64},
    { 1464, 680, -48},
    { 1176, 976, -232},
    { 1048, 760, -264},
    // 62 seconds
    { 984, 616, -472},
    { 696, 504, -688},
    { 416, 392, -648},
    { 32, 152, -560},
    { 16, 104, -728},
    { 144, -24, -832},
    { 176, -112, -848},
    { 168, -144, -864},
    { 72, 0, -880},
    { -40, 128, -872},
    { -104, 104, -848},
    { -136, 64, -872},
    { -136, 16, -928},
    { -200, 24, -960},
    { -328, 104, -1024},
    { -328, 272, -1136},
    { -368, 344, -1216},
    { -296, 480, -1320},
    { -224, 464, -1232},
    { -192, 400, -968},
    { -456, 800, -456},
    { -792, 1080, 16},
    { -728, 880, 224},
    { -648, 592, 248},
    { -696, 560, 248},
    // 63 seconds
    { -736, 440, 288},
    { -776, 528, -48},
    { -808, 544, 24},
    { -760, 576, -104},
    { -664, 920, -136},
    { -496, 984, -400},
    { -736, 968, -232},
    { -536, 768, -80},
    { -768, 776, 176},
    { -728, 592, 128},
    { -696, 752, -32},
    { -552, 744, -352},
    { -728, 1104, -128},
    { -680, 216, 104},
    { -408, -16, -456},
    { -432, 152, -448},
    { -560, 608, -472},
    { -600, 648, -728},
    { -568, 424, -752},
    { -680, 816, -632},
    { -600, 888, -920},
    { -232, 976, -992},
    { -472, 424, -544},
    { -600, 496, -416},
    { -624, 472, -392},
    // 64 seconds
    { -600, 592, -424},
    { -360, 624, -632},
    { -320, 680, -608},
    { -328, 512, -624},
    { -360, 456, -560},
    { -408, 568, -632},
    { -432, 512, -688},
    { -424, 560, -896},
    { -408, 608, -904},
    { -792, 488, -976},
    { -992, 800, -640},
    { -1120, 952, -360},
    { -744, 656, -376},
    { -640, 448, -304},
    { -696, 480, -376},
    { -688, 224, -392},
    { -480, 432, -392},
    { -344, 528, -520},
    { -352, 384, -472},
    { -504, 384, -496},
    { -712, 520, -840},
    { -768, 640, -984},
    { -656, 656, -784},
    { -920, 752, -1032},
    { -904, 496, -568},
    // 65 seconds
    { -872, 360, -416},
    { -712, 192, -304},
    { -432, 152, -520},
    { -672, 336, -368},
    { -408, 232, -304},
    { -576, 440, -368},
    { -576, 416, -632},
    { -824, 400, -568},
    { -704, 272, -352},
    { -544, 168, -184},
    { -176, 280, -48},
    { 72, 240, 256},
    { 312, 224, 416},
    { 904, 224, 104},
    { 2368, 888, -168},
    { 3168, 1048, 240},
    { 3392, 736, 936},
    { 2264, 1176, 112},
    { 1840, 448, -72},
    { 1936, 488, 216},
    { 1720, 768, 344},
    { 1400, 648, 248},
    { 1128, 568, 288},
    { 840, 624, 256},
    { 968, 672, 216},
    // 66 seconds
    { 1072, 800, 536},
    { 552, 984, 576},
    { 1072, 744, 96},
    { 960, 784, 208},
    { 1256, 936, 96},
    { 1552, 848, 216},
    { 2144, 808, 368},
    { 2432, 624, 376},
    { 2312, 352, 368},
    { 2096, 224, 264},
    { 1800, 208, 192},
    { 1432, 216, 216},
    { 1072, 224, 144},
    { 944, 272, -8},
    { 936, 128, -112},
    { 552, -320, -72},
    { 472, -264, 128},
    { 936, 360, -112},
    { 1272, 488, -120},
    { 1568, 376, -56},
    { 2120, 504, -248},
    { 1688, 552, -56},
    { 1320, 432, 8},
    { 1344, 320, -8},
    { 1616, 264, 40},
    // 67 seconds
    { 1736, 448, 88},
    { 1608, 616, 168},
    { 1600, 720, 240},
    { 1440, 1128, 840},
    { 680, 1264, 64},
    { 1048, 648, 320},
    { 792, 880, 152},
    { 896, 776, 184},
    { 1176, 840, 200},
    { 1728, 856, 360},
    { 2152, 616, 360},
    { 2152, 320, 264},
    { 1952, 176, 264},
    { 1824, 400, 96},
    { 1680, 728, -8},
    { 1488, 648, 144},
    { 1232, 640, 88},
    { 1040, 520, -136},
    { 640, 168, -312},
    { 352, -216, -576},
    { 88, -8, -880},
    { 48, 304, -1056},
    { 248, -8, -984},
    { 232, 56, -856},
    { 192, -160, -840},
    // 68 seconds
    { 0, -200, -856},
    { -120, -136, -848},
    { -192, 32, -864},
    { -232, 112, -928},
    { -224, 152, -968},
    { -240, 72, -1016},
    { -144, -8, -1080},
    { -120, -112, -1064},
    { -152, -80, -968},
    { -64, 408, -1080},
    { 0, 600, -1232},
    { -40, 464, -1136},
    { -48, 336, -1072},
    { 16, 272, -1064},
    { 16, 80, -928},
    { 24, -176, -880},
    { -8, -344, -840},
    { -48, 32, -472},
    { 8, 232, 176},
    { 112, 48, 696},
    { 552, 576, 1216},
    { 960, 1312, 616},
    { 1344, 640, 808},
    { 1776, 1176, 536},
    { 2384, 3720, -1344},
    // 69 seconds
    { 488, 2360, 2576},
    { 888, -1320, 1736},
    { 1200, -16, 120},
    { 888, 96, -24},
    { 1000, 720, 40},
    { 944, 944, 216},
    { 560, 496, 112},
    { 584, 464, 176},
    { 840, 576, 88},
    { 968, 568, -224},
    { 1536, 472, -712},
    { 1136, 344, -320},
    { 1544, 512, -280},
    { 1160, 800, -472},
    { 832, 960, -352},
    { 704, 848, -168},
    { 1128, 552, 72},
    { 1184, 32, 88},
    { 1096, 168, -72},
    { 1248, 32, -32},
    { 1464, 288, -96},
    { 1424, 200, -40},
    { 1312, 80, -112},
    { 1216, 64, -200},
    { 1088, 296, -392},
    // 70 seconds
    { 1160, 296, -512},
    { 1360, -112, -400},
    { 1272, -456, 120},
    { 960, -304, 208},
    { 1240, 120, 40},
    { 1232, 224, 40},
    { 1248, 248, -8},
    { 1184, 328, -264},
    { 1112, 392, -224},
    { 1272, 376, -168},
    { 1400, 416, -152},
    { 1440, 608, -88},
    { 1320, 680, -80},
    { 1408, 960, -112},
    { 1120, 968, -304},
    { 1072, 880, -232},
    { 896, 864, -256},
    { 744, 856, -248},
    { 928, 656, -360},
    { 1144, 632, -344},
    { 1480, 592, -240},
    { 1512, 344, -184},
    { 1440, 312, -128},
    { 1392, 176, -104},
    { 1312, 392, -320},
    // 71 seconds
    { 1336, 528, -864},
    { 1192, -496, -632},
    { 696, -168, 408},
    { 784, 1040, 24},
    { 896, 200, -136},
    { 1136, 56, -56},
    { 928, 128, 32},
    { 1144, 176, -16},
    { 1480, -112, -64},
    { 1656, -16, -224},
    { 1400, 400, -304},
    { 1072, 544, -192},
    { 1024, 456, -160},
    { 1264, 344, -136},
    { 1296, 376, -88},
    { 1192, 456, -72},
    { 1464, 560, -80},
    { 1496, 896, -64},
    { 960, 736, -136},
    { 1368, 728, -168},
    { 968, 808, -184},
    { 1016, 600, -144},
    { 1184, 600, -32},
    { 1624, 528, 56},
    { 1688, 360, 80},
    // 72 seconds
    { 1504, 216, 96},
    { 1488, 184, 96},
    { 1472, 248, 40},
    { 1304, 296, 0},
    { 1040, 272, -32},
    { 936, 216, -56},
    { 912, 208, -120},
    { 640, 8, -64},
    { 856, -16, 24},
    { 1080, 272, -96},
    { 1248, 360, -240},
    { 1488, 304, -216},
    { 1792, 352, -168},
    { 1344, 352, -40},
    { 1056, 264, -192},
    { 1056, 360, -256},
    { 1152, 312, -200},
    { 1224, 344, -152},
    { 1056, 400, -96},
    { 1168, 512, -112},
    { 1520, 680, -128},
    { 1096, 696, 0},
    { 1072, 688, -96},
    { 1104, 720, -176},
    { 1176, 584, -128},
    // 73 seconds
    { 1176, 544, 0},
    { 1344, 560, 64},
    { 1632, 448, 72},
    { 1472, 336, 88},
    { 1376, 256, 104},
    { 1344, 224, 80},
    { 1288, 240, 24},
    { 1144, 224, 16},
    { 944, 200, -24},
    { 928, 208, -24},
    { 896, 232, -80},
    { 792, 248, -160},
    { 1144, 264, -120},
    { 1024, 272, -112},
    { 1176, 320, -120},
    { 1360, 376, -392},
    { 1408, 336, -152},
    { 1224, 240, -24},
    { 1056, 272, -136},
    { 1040, 352, -88},
    { 1144, 400, -80},
    { 1184, 440, -56},
    { 1032, 456, -80},
    { 1128, 504, -64},
    { 1560, 624, -40},
    // 74 seconds
    { 1104, 720, 48},
    { 1336, 816, -136},
    { 888, 632, -160},
    { 960, 504, -120},
    { 1032, 560, -16},
    { 1376, 584, 32},
    { 1568, 440, 48},
    { 1416, 312, 80},
    { 1360, 216, 96},
    { 1312, 240, 72},
    { 1256, 256, 32},
    { 1096, 264, 24},
    { 984, 232, 24},
    { 1040, 232, -32},
    { 944, 232, -80},
    { 880, 256, -120},
    { 1232, 256, -248},
    { 1032, 216, -200},
    { 1152, 224, -176},
    { 1408, 224, -272},
    { 1368, 288, -200},
    { 1120, 272, -160},
    { 976, 296, -144},
    { 1008, 320, -104},
    { 1064, 344, -56},
    // 75 seconds
    { 1128, 400, -32},
    { 1088, 424, -32},
    { 1408, 512, -48},
    { 1552, 656, -56},
    { 1000, 672, 176},
    { 1248, 784, -8},
    { 440, 824, -96},
    { 1056, 600, -48},
    { 1056, 600, -16},
    { 1240, 680, 24},
    { 1448, 568, 80},
    { 1408, 376, 152},
    { 1472, 184, 144},
    { 1480, 176, 48},
    { 1408, 232, 32},
    { 1224, 232, 64},
    { 1056, 240, 40},
    { 1056, 256, -8},
    { 856, 240, -104},
    { 856, 120, -80},
    { 976, 72, -88},
    { 1224, 232, -144},
    { 1304, 264, -128},
    { 1512, 248, -192},
    { 1320, 272, -224},
    // 76 seconds
    { 1064, 320, -200},
    { 1080, 384, -192},
    { 1176, 392, -16},
    { 1280, 464, 56},
    { 1256, 480, 8},
    { 1376, 520, 24},
    { 1528, 624, 160},
    { 992, 736, 160},
    { 1344, 960, 112},
    { 864, 720, -40},
    { 1048, 552, 0},
    { 1088, 608, 32},
    { 1360, 664, 72},
    { 1520, 560, 0},
    { 1504, 392, 120},
    { 1512, 72, 240},
    { 1384, 184, 8},
    { 1280, 152, -16},
    { 1072, 232, -64},
    { 992, 240, -56},
    { 1040, 280, -120},
    { 776, 168, -176},
    { 920, 48, -112},
    { 880, 184, -104},
    { 1088, 256, -120},
    // 77 seconds
    { 1384, 304, -168},
    { 1768, 384, -184},
    { 1456, 440, -32},
    { 1040, 368, -136},
    { 944, 344, -56},
    { 1176, 320, -40},
    { 1256, 360, 8},
    { 1088, 488, -24},
    { 1248, 592, 88},
    { 1344, 784, 392},
    { 904, 1168, 104},
    { 1184, 624, 0},
    { 944, 600, 0},
    { 1144, 688, 8},
    { 1240, 648, 120},
    { 1448, 560, 184},
    { 1664, 376, 96},
    { 1432, 328, 24},
    { 1248, 216, 72},
    { 1288, 192, 8},
    { 1216, 224, -24},
    { 1072, 208, -48},
    { 1008, 200, -16},
    { 1072, 248, -64},
    { 864, 232, -160},
    // 78 seconds
    { 904, 144, -96},
    { 864, 208, -72},
    { 1000, 264, -136},
    { 1224, 288, -168},
    { 1536, 360, -176},
    { 1328, 408, 0},
    { 1040, 312, -40},
    { 1024, 328, -72},
    { 1288, 392, -64},
    { 1392, 456, -48},
    { 1216, 520, -56},
    { 1248, 560, -40},
    { 1280, 720, 88},
    { 912, 1040, -96},
    { 1304, 624, -120},
    { 1056, 560, -48},
    { 1016, 552, -32},
    { 1120, 552, 32},
    { 1392, 512, 8},
    { 1416, 336, 8},
    { 1352, 264, 64},
    { 1416, 280, 32},
    { 1376, 256, 32},
    { 1200, 280, 0},
    { 1000, 248, -40},
    // 79 seconds
    { 1120, 248, -112},
    { 984, 272, -184},
    { 848, 224, -96},
    { 1064, 216, -160},
    { 1032, 216, -72},
    { 1128, 272, -152},
    { 1296, 288, -144},
    { 1144, 296, -104},
    { 872, 264, -112},
    { 832, 288, -104},
    { 1048, 344, -40},
    { 1328, 408, -32},
    { 1264, 480, -88},
    { 1312, 512, -56},
    { 1616, 648, -80},
    { 1208, 688, 64},
    { 1216, 712, -112},
    { 928, 576, -96},
    { 880, 528, -128},
    { 880, 536, -56},
    { 1104, 544, 32},
    { 1320, 448, 56},
    { 1192, 336, 32},
    { 1144, 248, 56},
    { 1208, 232, 40},
    // 80 seconds
    { 1256, 256, -32},
    { 1176, 288, -56},
    { 1064, 264, -48},
    { 1160, 280, -88},
    { 1104, 280, -200},
    { 1088, 152, -216},
    { 1080, 48, -16},
    { 1000, 136, -104},
    { 1160, 264, -216},
    { 1400, 288, -192},
    { 1304, 344, -240},
    { 984, 264, -96},
    { 936, 328, -264},
    { 960, 288, 0},
    { 1112, 400, 8},
    { 1144, 432, 8},
    { 1136, 464, -32},
    { 1536, 576, 48},
    { 1104, 744, 248},
    { 1072, 1032, 88},
    { 1112, 520, -32},
    { 1072, 512, -16},
    { 976, 552, 32},
    { 1144, 624, 128},
    { 1344, 512, 112},
    // 81 seconds
    { 1280, 336, 88},
    { 1312, 248, 96},
    { 1392, 264, 48},
    { 1336, 296, -48},
    { 1152, 288, -64},
    { 1016, 256, -112},
    { 1096, 248, -224},
    { 864, 96, -296},
    { 928, -240, 16},
    { 1120, -72, 88},
    { 1336, 328, -120},
    { 1368, 400, -120},
    { 1584, 392, -136},
    { 1368, 392, -168},
    { 1072, 296, -112},
    { 992, 392, 8},
    { 1104, 424, -16},
    { 1224, 456, -48},
    { 1080, 472, 0},
    { 1120, 512, 96},
    { 1280, 704, 176},
    { 888, 872, 136},
    { 1384, 768, 64},
    { 1064, 528, -24},
    { 1120, 536, -24},
    // 82 seconds
    { 1320, 616, 112},
    { 1584, 592, 128},
    { 1568, 480, -72},
    { 1408, 216, 200},
    { 1360, 96, 184},
    { 1232, 224, -88},
    { 992, 200, -136},
    { 832, 256, -112},
    { 992, 232, -80},
    { 944, 256, -232},
    { 840, 176, -224},
    { 1096, 152, -128},
    { 960, 160, -40},
    { 1208, 304, -120},
    { 1496, 376, -136},
    { 1424, 464, -64},
    { 1080, 376, -72},
    { 944, 328, -24},
    { 1088, 328, -32},
    { 1256, 360, -32},
    { 1096, 440, -80},
    { 1016, 472, -48},
    { 1528, 584, 40},
    { 1128, 816, 312},
    { 1128, 1096, -160},
    // 83 seconds
    { 1064, 408, -40},
    { 1144, 560, -96},
    { 1032, 648, -8},
    { 1184, 688, 48},
    { 1344, 488, 88},
    { 1192, 304, 80},
    { 1168, 152, 104},
    { 1352, 168, 8},
    { 1336, 240, -16},
    { 1184, 272, 0},
    { 1056, 264, -8},
    { 1072, 280, -80},
    { 904, 256, -224},
    { 1056, 88, -136},
    { 976, 96, 8},
    { 1216, 192, -120},
    { 1320, 240, -96},
    { 1432, 264, -64},
    { 1264, 336, -184},
    { 1008, 240, -160},
    { 1048, 368, -264},
    { 1136, 368, 0},
    { 1256, 440, 16},
    { 1120, 440, 24},
    { 1232, 488, -16},
    // 84 seconds
    { 1560, 568, 24},
    { 1136, 624, 144},
    { 1088, 656, 16},
    { 968, 768, -88},
    { 992, 728, -144},
    { 920, 576, 0},
    { 1160, 640, 64},
    { 1400, 536, 72},
    { 1472, 328, 112},
    { 1416, 232, 120},
    { 1448, 272, 72},
    { 1400, 296, 40},
    { 1224, 296, 40},
    { 1032, 240, 40},
    { 1152, 232, -16},
    { 920, 264, -160},
    { 952, 200, -136},
    { 1008, 128, -128},
    { 1032, 136, -112},
    { 1080, 216, -224},
    { 1360, 256, -264},
    { 1344, 280, -192},
    { 1112, 272, -200},
    { 936, 304, -160},
    { 1056, 336, -176},
    // 85 seconds
    { 1232, 352, -88},
    { 1216, 400, -48},
    { 1136, 432, 8},
    { 1448, 544, -8},
    { 1400, 672, 64},
    { 936, 648, 56},
    { 1416, 848, 16},
    { 992, 800, -48},
    { 920, 584, -40},
    { 936, 640, 8},
    { 1288, 672, 72},
    { 1576, 512, 128},
    { 1464, 264, 176},
    { 1512, 184, 120},
    { 1512, 224, 40},
    { 1392, 272, -16},
    { 1120, 272, -8},
    { 1008, 272, -16},
    { 1056, 256, -48},
    { 800, 192, -136},
    { 1088, 88, -64},
    { 872, 128, -24},
    { 1072, 256, -56},
    { 1208, 280, -216},
    { 1360, 312, -160},
    // 86 seconds
    { 1304, 328, -112},
    { 1064, 312, -152},
    { 1080, 320, -200},
    { 1192, 344, -136},
    { 1328, 384, -160},
    { 1192, 424, -104},
    { 1144, 464, -128},
    { 1512, 592, -192},
    { 1096, 680, -104},
    { 1328, 968, -256},
    { 1000, 688, -344},
    { 1128, 568, -112},
    { 1296, 648, 8},
    { 1704, 704, -16},
    { 1848, 704, -88},
    { 1784, 840, -120},
    { 1720, 1112, 32},
    { 1568, 872, 8},
    { 1344, 408, -32},
    { 888, 408, -176},
    { 616, 176, -272},
    { 456, -232, -488},
    { 352, -184, -704},
    { 280, -392, -840},
    { 152, -72, -928},
    // 87 seconds
    { 248, -72, -1056},
    { 272, -80, -1008},
    { 288, -112, -992},
    { 216, -96, -912},
    { 88, -112, -776},
    { 24, -136, -704},
    { 0, -96, -728},
    { 0, -24, -800},
    { 56, -72, -872},
    { -48, -72, -968},
    { 40, -16, -1064},
    { 136, 416, -832},
    { -72, 624, -312},
    { -216, 888, 288},
    { -264, 1008, 896},
    { -360, 1352, 1496},
    { -408, 1048, 1504},
    { -496, 1168, 1616},
    { -496, 896, 744},
    { -72, 368, 464},
    { -120, 200, 464},
    { -496, 672, 752},
    { -440, 512, 816},
    { -224, 432, 520},
    { -16, 392, 112},
    // 88 seconds
    { 216, 440, 32},
    { 536, 504, 304},
    { 1304, 64, 920},
    { 1712, 400, 872},
    { 2128, 856, 232},
    { 2192, 584, 216},
    { 1824, 688, 72},
    { 1312, 624, 80},
    { 1200, 616, 128},
    { 1192, 456, 176},
    { 1192, 352, 96},
    { 1080, 376, 128},
    { 952, 504, 160},
    { 1120, 624, 232},
    { 1320, 744, 360},
    { 848, 696, 160},
    { 1264, 608, 152},
    { 1176, 712, 24},
    { 1072, 688, 0},
    { 1168, 600, 128},
    { 1496, 624, 200},
    { 1760, 520, 192},
    { 1624, 336, 184},
    { 1584, 224, 160},
    { 1472, 208, 48},
    // 89 seconds
    { 1224, 208, 8},
    { 1000, 200, -32},
    { 872, 200, -88},
    { 952, 216, -80},
    { 768, 160, -160},
    { 904, 128, -64},
    { 944, 200, -8},
    { 1232, 312, -88},
    { 1472, 408, -232},
    { 1744, 432, -104},
    { 1424, 416, 40},
    { 1064, 328, -128},
    { 960, 344, -120},
    { 1152, 344, -40},
    { 1344, 400, 8},
    { 1120, 488, 8},
    { 1104, 552, -24},
    { 1616, 680, -16},
    { 1080, 832, 168},
    { 1200, 976, -184},
    { 888, 464, -168},
    { 1000, 504, -128},
    { 1104, 656, -16},
    { 1416, 656, 72},
    { 1704, 456, 104},
    // 90 seconds
    { 1448, 312, 96},
    { 1352, 256, 120},
    { 1368, 240, 96},
    { 1304, 256, 32},
    { 1088, 256, 24},
    { 912, 232, -16},
    { 992, 224, -32},
    { 896, 240, -88},
    { 800, 232, -104},
    { 1080, 232, -120},
    { 1032, 272, -16},
    { 1200, 328, -240},
    { 1472, 360, -328},
    { 1336, 272, 16},
    { 1088, 224, -16},
    { 920, 240, -168},
    { 1008, 352, -152},
    { 1152, 400, -64},
    { 1192, 448, -40},
    { 1040, 464, -64},
    { 1264, 504, -72},
    { 1616, 648, -64},
    { 1008, 752, 144},
    { 1360, 784, -184},
    { 800, 536, -144},
    // 91 seconds
    { 984, 552, -104},
    { 1024, 624, -16},
    { 1248, 608, 48},
    { 1536, 456, 64},
    { 1344, 288, 104},
    { 1296, 216, 88},
    { 1304, 216, 48},
    { 1240, 256, 16},
    { 1040, 280, -16},
    { 896, 248, -24},
    { 1104, 248, -16},
    { 896, 272, -160},
    { 1016, 144, -120},
    { 1200, 112, 16},
    { 1352, 224, -128},
    { 1344, 312, -224},
    { 1416, 264, -184},
    { 1200, 288, -200},
    { 936, 32, -232},
    { 976, 240, -304},
    { 1040, 432, 0},
    { 1192, 424, 88},
    { 1200, 512, 48},
    { 1160, 536, 32},
    { 1576, 576, 72},
    // 92 seconds
    { 992, 656, 96},
    { 1240, 624, 8},
    { 952, 664, -48},
    { 1200, 696, -88},
    { 1008, 600, -72},
    { 1152, 632, -40},
    { 1320, 536, 32},
    { 1272, 320, 128},
    { 1336, 176, 88},
    { 1400, 176, 8},
    { 1384, 248, -8},
    { 1224, 280, 40},
    { 1080, 264, 16},
    { 1136, 272, 16},
    { 824, 256, -64},
    { 984, 224, -72},
    { 960, 160, -48},
    { 1160, 240, -56},
    { 1248, 280, -160},
    { 1360, 256, -160},
    { 1240, 280, -160},
    { 960, 312, -200},
    { 872, 320, -200},
    { 1048, 296, -120},
    { 1200, 352, -56},
    // 93 seconds
    { 1216, 400, -24},
    { 1424, 528, -24},
    { 1760, 720, 8},
    { 1104, 928, 304},
    { 1472, 848, -120},
    { 1048, 504, 0},
    { 928, 584, -104},
    { 808, 600, -8},
    { 1080, 664, 64},
    { 1360, 520, 88},
    { 1272, 320, 136},
    { 1368, 216, 112},
    { 1424, 208, 80},
    { 1352, 264, 64},
    { 1128, 256, 48},
    { 1008, 248, 48},
    { 1104, 264, 16},
    { 984, 256, -88},
    { 1056, 184, -88},
    { 1096, 120, -8},
    { 1056, 192, -16},
    { 1120, 288, -216},
    { 1344, 320, -248},
    { 1352, 368, -176},
    { 1088, 288, -152},
    // 94 seconds
    { 984, 248, -168},
    { 1072, 312, -104},
    { 1152, 376, -32},
    { 1080, 448, -48},
    { 936, 488, -96},
    { 1432, 576, -56},
    { 1280, 648, 8},
    { 1048, 648, 80},
    { 1288, 736, -160},
    { 1056, 512, -200},
    { 880, 544, -64},
    { 1016, 664, 0},
    { 1464, 584, 32},
    { 1536, 336, 144},
    { 1464, 216, 152},
    { 1464, 168, 120},
    { 1336, 232, 96},
    { 1104, 248, 128},
    { 984, 304, 16},
    { 1160, 312, -32},
    { 1136, 304, -200},
    { 880, 208, -104},
    { 904, -120, 152},
    { 848, -56, -104},
    { 1008, 152, -304},
    // 95 seconds
    { 1368, 112, -352},
    { 1456, 120, -240},
    { 1208, 72, -144},
    { 1088, 104, -176},
    { 1192, 504, -104},
    { 1352, 472, -88},
    { 1280, 480, -72},
    { 1136, 448, -88},
    { 1352, 464, -64},
    { 1224, 616, 56},
    { 1032, 752, -8},
    { 1256, 752, -184},
    { 1128, 560, -160},
    { 928, 576, -48},
    { 1080, 640, -8},
    { 1416, 568, 0},
    { 1416, 408, 72},
    { 1384, 280, 136},
    { 1416, 128, 128},
    { 1392, 160, 32},
    { 1208, 216, 8},
    { 992, 256, -8},
    { 1000, 248, -56},
    { 992, 256, -72},
    { 856, 248, -152},
    // 96 seconds
    { 896, 248, -136},
    { 768, 240, -128},
    { 896, 216, -40},
    { 1168, 288, -184},
    { 1424, 376, -240},
    { 1464, 408, -120},
    { 1176, 368, -120},
    { 976, 360, -88},
    { 1032, 336, -48},
    { 1264, 328, -72},
    { 1208, 400, -72},
    { 1000, 424, -120},
    { 1008, 440, -152},
    { 1248, 528, -112},
    { 1016, 504, -64},
    { 984, 504, -56},
    { 1240, 640, -120},
    { 1200, 712, -136},
    { 944, 504, -48},
    { 1000, 480, -8},
    { 1256, 472, 16},
    { 1384, 408, 48},
    { 1376, 336, 64},
    { 1360, 288, 80},
    { 1328, 264, 88},
    // 97 seconds
    { 1168, 320, 96},
    { 856, 344, -24},
    { 792, 360, -176},
    { 968, 392, -120},
    { 944, 320, -168},
    { 856, 304, -392},
    { 896, 256, -472},
    { 960, 112, -152},
    { 880, 120, -104},
    { 904, 256, -136},
    { 984, 384, -184},
    { 1296, 496, -216},
    { 1408, 584, -288},
    { 1136, 432, -88},
    { 1088, 328, 8},
    { 1168, 304, -88},
    { 1184, 352, -120},
    { 1080, 400, -128},
    { 1040, 464, -224},
    { 1360, 608, -296},
    { 1128, 600, -232},
    { 1256, 592, -208},
    { 1120, 752, -240},
    { 936, 576, -224},
    { 1064, 440, -64},
    // 98 seconds
    { 1408, 480, -16},
    { 1528, 408, 40},
    { 1440, 296, 64},
    { 1368, 200, 80},
    { 1408, 160, 32},
    { 1344, 232, 8},
    { 1104, 272, 72},
    { 936, 368, 24},
    { 1064, 448, -96},
    { 944, 472, -288},
    { 904, 368, -344},
    { 1024, 224, -120},
    { 1016, 80, 8},
    { 1120, 168, -288},
    { 1280, 232, -272},
    { 1512, 296, -224},
    { 1312, 312, -192},
    { 1112, 296, -176},
    { 1168, 384, -160},
    { 1168, 400, -120},
    { 1152, 416, -80},
    { 1024, 392, -56},
    { 1080, 480, -72},
    { 1528, 592, -16},
    { 1192, 608, 136},
    // 99 seconds
    { 1048, 632, 144},
    { 816, 688, 40},
    { 768, 776, 8},
    { 1008, 584, 24},
    { 1176, 576, 160},
    { 1576, 632, 152},
    { 1624, 472, 128},
    { 1552, 336, 104},
    { 1584, 328, 56},
    { 1384, 392, -232},
    { 1184, 424, -384},
    { 960, 488, -408},
    { 944, 408, -288},
    { 880, 136, -184},
    { 656, -80, -144},
    { 744, 24, -128},
    { 952, 120, 144},
    { 1160, 320, 312},
    { 1608, 472, 0},
    { 1712, 416, -8},
    { 1864, 568, 48},
    { 1680, 456, 240},
    { 1648, 392, 128},
    { 1544, 584, 80},
    { 1352, 496, -40},
    // 100 seconds
    { 1168, 448, 8},
    { 1232, 512, 128},
    { 1552, 584, 240},
    { 1216, 608, 232},
    { 648, 880, 80},
    { 752, 1504, -40},
    { 888, 456, -24},
    { 1144, 528, 192},
    { 1544, 744, 296},
    { 1776, 432, 176},
    { 1680, 184, 104},
    { 1456, 184, 120},
    { 1328, 288, 16},
    { 1248, 344, -16},
    { 1336, 320, 8},
    { 1344, 264, 96},
    { 1200, 160, 72},
    { 1080, 216, -24},
    { 1064, 240, -40},
    { 1248, 296, -112},
    { 1248, 304, -256},
    { 1248, 224, -168},
    { 1208, 160, -24},
    { 1064, 208, -184},
    { 1024, 304, -296},
    // 101 seconds
    { 1008, 384, -248},
    { 1024, 448, -168},
    { 1096, 496, -192},
    { 1192, 472, -136},
    { 1616, 496, 8},
    { 1464, 496, 24},
    { 1104, 544, 48},
    { 1024, 728, -16},
    { 1008, 1120, -120},
    { 1072, 520, -80},
    { 1248, 472, 176},
    { 1408, 520, 176},
    { 1304, 312, 80},
    { 1104, 192, 32},
    { 1032, 200, -8},
    { 1008, 280, -112},
    { 1008, 320, -64},
    { 1256, 280, 24},
    { 1352, 256, -40},
    { 1096, 200, -96},
    { 1392, 176, -104},
    { 1128, 152, -48},
    { 1424, 296, -168},
    { 1480, 272, -208},
    { 1400, 256, -160},
    // 102 seconds
    { 984, 216, -192},
    { 720, 208, -192},
    { 760, 264, -136},
    { 944, 320, -168},
    { 1120, 456, -184},
    { 1248, 576, -192},
    { 1720, 712, -112},
    { 1296, 976, -40},
    { 952, 392, -168},
    { 1216, 672, -48},
    { 648, 880, -200},
    { 1176, 624, -112},
    { 1280, 608, 120},
    { 1600, 472, 112},
    { 1568, 296, 64},
    { 1424, 272, 32},
    { 1416, 288, -8},
    { 1336, 352, -8},
    { 1208, 280, 24},
    { 1272, 816, -120},
    { 1352, 1200, -336},
    { 1104, 784, -424},
    { 936, 224, -376},
    { 440, 328, -696},
    { 744, -40, -776},
    // 103 seconds
    { 624, -16, -728},
    { 480, 48, -840},
    { 112, 112, -536},
    { -160, 224, -648},
    { -240, 24, -728},
    { -136, -16, -936},
    { -48, -40, -1048},
    { 8, -24, -1200},
    { 64, -64, -1216},
    { 48, -408, -1352},
    { -352, 48, -1176},
    { -408, 272, -976},
    { -400, 304, -1144},
    { -296, 160, -1032},
    { -216, 160, -832},
    { -112, 96, -800},
    { -160, 88, -872},
    { -80, 64, -888},
    { -112, -48, -944},
    { -96, -80, -888},
    { -240, 40, -848},
    { -168, -392, -1136},
    { 16, -40, -1072},
    { -64, -96, -1072},
    { -144, -384, -1112},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-29 15:24:32 local
AccelRawData *activity_sample_walk_200_pbl_25301_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25301_9
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 75
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -152, 360, -1000},
    { 16, 224, -1024},
    { 32, 192, -1008},
    { -16, 200, -1016},
    { 24, 232, -1008},
    { 56, 224, -1016},
    { 32, 224, -1024},
    { 40, 240, -1016},
    { 32, 248, -1016},
    { 32, 256, -1024},
    { 40, 240, -1024},
    { 16, 240, -1000},
    { -40, 240, -984},
    { -80, 248, -992},
    { -72, 272, -1032},
    { -48, 280, -1056},
    { -32, 280, -1048},
    { -96, 256, -1024},
    { -40, 216, -1008},
    { -96, 192, -1000},
    { -168, 192, -968},
    { -160, 328, -944},
    { -24, 184, -944},
    { -104, 312, -968},
    { -184, 296, -1016},
    // 1 seconds
    { -248, 264, -1056},
    { -264, 224, -1080},
    { -312, 344, -1064},
    { -264, 472, -1104},
    { -264, 568, -1048},
    { -40, 256, -1072},
    { 160, 144, -992},
    { 224, 272, -872},
    { 264, 392, -792},
    { 344, 488, -688},
    { 440, 568, -680},
    { 528, 496, -624},
    { 536, 432, -432},
    { 480, 368, -432},
    { 592, 544, -512},
    { 616, 200, -336},
    { 800, 328, -264},
    { 1096, 280, -168},
    { 1520, 288, 152},
    { 2184, 312, 496},
    { 2968, 624, 744},
    { 2480, 1088, 600},
    { 1528, 976, 336},
    { 808, 728, 8},
    { 688, 456, 168},
    // 2 seconds
    { 600, 560, 272},
    { 760, 664, 208},
    { 968, 656, 64},
    { 1176, 728, -72},
    { 1376, 728, 16},
    { 1656, 680, 200},
    { 1888, 424, 120},
    { 1640, -56, 80},
    { 1312, -24, -120},
    { 1208, 16, -208},
    { 1248, 96, -184},
    { 1184, 96, -136},
    { 1136, -48, 64},
    { 768, -328, 176},
    { 1024, 264, -88},
    { 1136, 432, -80},
    { 1352, 352, 16},
    { 1376, 376, -32},
    { 1256, 384, -48},
    { 1296, 392, 8},
    { 1424, 352, 104},
    { 1424, 400, 24},
    { 1320, 480, -216},
    { 1248, 560, -416},
    { 1128, 600, -392},
    // 3 seconds
    { 1264, 752, -392},
    { 1088, 664, -328},
    { 1160, 632, -240},
    { 1016, 656, -280},
    { 1368, 648, -232},
    { 1824, 544, 72},
    { 2232, 368, 400},
    { 2240, 208, 344},
    { 1792, 176, 80},
    { 1824, 184, 320},
    { 1712, 296, 256},
    { 1480, 344, 280},
    { 1256, 296, 248},
    { 1056, 216, 64},
    { 752, 304, -184},
    { 768, 40, -384},
    { 344, -600, -112},
    { 616, -456, -128},
    { 1152, -104, -408},
    { 1608, -168, -216},
    { 1816, -88, 72},
    { 2104, 24, 152},
    { 1944, 248, 144},
    { 1696, 488, -56},
    { 1624, 640, -288},
    // 4 seconds
    { 1496, 496, -16},
    { 1408, 464, 88},
    { 1168, 504, 56},
    { 1248, 488, 120},
    { 1440, 688, 360},
    { 1048, 792, 288},
    { 1176, 792, 208},
    { 896, 760, 120},
    { 960, 656, 168},
    { 1048, 632, 200},
    { 1544, 592, 216},
    { 1920, 504, 136},
    { 1776, 304, 272},
    { 1808, 360, 288},
    { 1744, 488, 16},
    { 1472, 272, 144},
    { 1224, 216, 152},
    { 1152, 160, 96},
    { 960, 88, 56},
    { 792, -40, -48},
    { 736, -32, -64},
    { 848, 24, -96},
    { 1072, 112, -64},
    { 1464, 232, -96},
    { 1744, 352, -280},
    // 5 seconds
    { 1632, 472, -192},
    { 1328, 312, -32},
    { 1224, 320, 8},
    { 1344, 352, -184},
    { 1280, 472, -224},
    { 1088, 600, -232},
    { 976, 832, -72},
    { 1408, 704, -168},
    { 1080, 488, -32},
    { 1312, 648, 0},
    { 1200, 752, -96},
    { 1096, 584, -16},
    { 1200, 536, 128},
    { 1576, 456, 224},
    { 1592, 256, 232},
    { 1360, 168, 152},
    { 1304, 168, 88},
    { 1272, 240, 16},
    { 1240, 288, -24},
    { 1128, 248, -24},
    { 1160, 192, -112},
    { 928, 168, -248},
    { 728, 80, -312},
    { 872, 48, -264},
    { 704, 32, -88},
    // 6 seconds
    { 1000, 120, -136},
    { 1400, 224, -224},
    { 1752, 432, -392},
    { 1232, 384, -112},
    { 880, 144, -112},
    { 944, 128, -96},
    { 1168, 216, -128},
    { 1264, 336, -128},
    { 1176, 432, 0},
    { 1576, 544, 120},
    { 1616, 744, 160},
    { 1208, 1000, 24},
    { 1176, 632, -56},
    { 872, 496, -32},
    { 808, 624, -56},
    { 968, 736, 48},
    { 1320, 616, 136},
    { 1368, 352, 184},
    { 1352, 136, 160},
    { 1424, 80, 96},
    { 1432, 128, 0},
    { 1296, 168, 32},
    { 1184, 224, 64},
    { 1320, 264, 16},
    { 1008, 320, -168},
    // 7 seconds
    { 888, 304, -120},
    { 928, 152, -112},
    { 936, 80, -104},
    { 1104, 152, -208},
    { 1280, 192, -232},
    { 1080, 208, -200},
    { 760, 160, -96},
    { 752, 200, -120},
    { 968, 240, -176},
    { 1200, 240, -96},
    { 1320, 272, 8},
    { 1576, 344, 240},
    { 2032, 696, 368},
    { 1216, 1664, 496},
    { 1192, 704, -104},
    { 768, 648, 320},
    { 792, 920, 544},
    { 1064, 896, 560},
    { 1464, 968, 648},
    { 1872, 1224, 696},
    { 2080, 1272, 808},
    { 2128, 1088, 568},
    { 1984, 576, 312},
    { 1296, 264, -16},
    { 824, 344, -232},
    // 8 seconds
    { 584, 120, -232},
    { 416, -168, -336},
    { 304, -248, -520},
    { 192, -560, -632},
    { 72, -264, -848},
    { 112, -88, -1040},
    { 216, -208, -952},
    { 296, -192, -960},
    { 240, -216, -824},
    { 152, -208, -696},
    { 136, -40, -560},
    { 200, -40, -360},
    { 248, 168, -264},
    { 256, 424, -328},
    { 288, 1136, -576},
    { 336, 2360, -944},
    { -344, 1608, -904},
    { -24, 424, -1424},
    { 424, 448, -1816},
    { 144, 1032, -1256},
    { -136, 1064, -768},
    { -112, 992, -712},
    { 24, 640, -736},
    { 64, 264, -672},
    { -8, 168, -464},
    // 9 seconds
    { 0, 632, -520},
    { 72, 1072, -552},
    { 280, 552, -440},
    { 576, 88, -176},
    { 1400, -56, -304},
    { 1664, 344, -424},
    { 1824, 288, -64},
    { 1408, 248, 88},
    { 1632, 296, -56},
    { 1576, 416, -224},
    { 1344, 408, -256},
    { 1016, 256, -216},
    { 880, 200, -152},
    { 944, 240, -40},
    { 1096, 344, 24},
    { 1152, 464, 8},
    { 1112, 544, 8},
    { 1488, 648, 48},
    { 1120, 840, 120},
    { 1072, 1088, -120},
    { 1080, 704, -160},
    { 1216, 752, -120},
    { 1392, 744, 48},
    { 2080, 832, 144},
    { 2272, 440, 360},
    // 10 seconds
    { 1928, 136, 208},
    { 1672, 384, 64},
    { 1392, 360, -88},
    { 1072, 312, -152},
    { 792, 224, -256},
    { 528, 216, -464},
    { 432, 96, -744},
    { 272, -56, -784},
    { 168, -64, -864},
    { 16, 64, -1040},
    { 240, -56, -1120},
    { 312, -32, -1016},
    { 248, 16, -936},
    { 88, -8, -840},
    { -104, -16, -760},
    { -200, 0, -784},
    { -192, 8, -848},
    { -176, -16, -928},
    { -240, -64, -984},
    { -232, -112, -1136},
    { -192, -40, -1248},
    { -384, 112, -1232},
    { -160, 312, -1280},
    { -88, 288, -1184},
    { -120, 128, -992},
    // 11 seconds
    { -160, 184, -864},
    { -88, 256, -888},
    { -32, 72, -848},
    { -48, -176, -752},
    { -136, -128, -736},
    { -160, -64, -704},
    { -32, 80, -584},
    { 144, 232, -424},
    { 448, 232, -280},
    { 1128, 512, -80},
    { 1744, 896, 136},
    { 2032, 1024, -32},
    { 1824, 768, -344},
    { 1760, 504, -328},
    { 1488, 480, 64},
    { 1280, 512, 64},
    { 1096, 272, 104},
    { 1032, 160, 80},
    { 968, 264, 104},
    { 912, 440, 152},
    { 968, 592, 96},
    { 912, 616, 64},
    { 1368, 624, 304},
    { 1168, 864, 376},
    { 960, 1072, -184},
    // 12 seconds
    { 1032, 592, 56},
    { 1152, 736, 16},
    { 1256, 680, 72},
    { 1600, 568, 112},
    { 1712, 448, 144},
    { 1608, 352, 144},
    { 1552, 264, 152},
    { 1504, 160, 72},
    { 1280, 144, -32},
    { 1064, 128, -16},
    { 880, 144, 16},
    { 944, 160, 8},
    { 856, 192, -88},
    { 816, 216, -208},
    { 1008, 160, -56},
    { 1008, 192, 0},
    { 1352, 248, -144},
    { 1640, 288, -104},
    { 1640, 328, -16},
    { 1360, 288, -128},
    { 1216, 288, -168},
    { 1240, 312, 104},
    { 1344, 408, 240},
    { 1312, 512, 168},
    { 1192, 584, 184},
    // 13 seconds
    { 1208, 632, 136},
    { 888, 864, 184},
    { 1312, 944, 40},
    { 1016, 536, 152},
    { 896, 632, -64},
    { 928, 656, -24},
    { 1248, 760, 80},
    { 1344, 584, 64},
    { 1360, 480, 104},
    { 1488, 344, 168},
    { 1568, 280, 96},
    { 1424, 264, 8},
    { 1104, 232, -128},
    { 968, 208, -200},
    { 864, 168, -144},
    { 696, 112, -152},
    { 592, 24, -192},
    { 776, -56, 40},
    { 1104, 16, 392},
    { 1720, 504, 88},
    { 1744, 704, -200},
    { 1752, 552, -64},
    { 1320, 456, -72},
    { 1088, 200, -16},
    { 1136, 144, 88},
    // 14 seconds
    { 1256, 216, 64},
    { 1248, 384, -8},
    { 1000, 576, -216},
    { 976, 560, -152},
    { 1360, 696, -64},
    { 904, 728, 8},
    { 1208, 584, -64},
    { 1072, 496, -80},
    { 1232, 536, -32},
    { 1320, 528, 88},
    { 1592, 472, 152},
    { 1648, 368, 144},
    { 1400, 304, 136},
    { 1272, 240, 216},
    { 1248, 264, 120},
    { 1200, 272, 96},
    { 1080, 224, 112},
    { 1208, 192, 152},
    { 1304, 192, 56},
    { 944, 152, -120},
    { 1088, -24, -136},
    { 912, 72, -64},
    { 1088, 272, -296},
    { 1256, 240, -312},
    { 1416, 152, -104},
    // 15 seconds
    { 1160, 168, 0},
    { 1016, 184, -104},
    { 1048, 312, -40},
    { 1232, 360, 40},
    { 1264, 448, 8},
    { 1096, 520, -24},
    { 1376, 544, 80},
    { 1416, 704, 280},
    { 952, 992, 16},
    { 1240, 496, -96},
    { 1024, 472, -64},
    { 1024, 656, -16},
    { 1112, 720, 72},
    { 1448, 600, 136},
    { 1528, 384, 144},
    { 1352, 224, 160},
    { 1328, 136, 120},
    { 1352, 152, 72},
    { 1248, 256, 16},
    { 1032, 272, -8},
    { 1008, 248, 8},
    { 1040, 232, -16},
    { 848, 200, -64},
    { 920, 168, -40},
    { 944, 200, -88},
    // 16 seconds
    { 1088, 184, -88},
    { 1176, 208, -112},
    { 1504, 248, -200},
    { 1376, 272, -88},
    { 1104, 256, -120},
    { 960, 288, -208},
    { 1008, 296, -96},
    { 1144, 304, -40},
    { 1112, 352, -24},
    { 1048, 440, -32},
    { 1520, 560, 24},
    { 1424, 712, 96},
    { 904, 800, 48},
    { 1328, 656, -88},
    { 880, 496, -64},
    { 984, 568, -56},
    { 1088, 656, 16},
    { 1368, 616, 104},
    { 1552, 416, 152},
    { 1400, 248, 176},
    { 1408, 176, 152},
    { 1408, 168, 112},
    { 1304, 216, 88},
    { 1080, 224, 40},
    { 1008, 216, 24},
    // 17 seconds
    { 1088, 232, -40},
    { 872, 200, -104},
    { 1056, 144, -80},
    { 920, 112, -152},
    { 1040, 192, -104},
    { 1072, 216, -240},
    { 1352, 256, -352},
    { 1264, 208, -120},
    { 1104, 176, -80},
    { 1104, 256, -160},
    { 1112, 328, -216},
    { 1096, 368, -96},
    { 1128, 400, -48},
    { 1048, 392, -24},
    { 1432, 448, -24},
    { 1472, 536, -96},
    { 1072, 496, -40},
    { 1312, 616, -48},
    { 880, 664, -104},
    { 1040, 592, -144},
    { 936, 520, -8},
    { 1200, 592, 32},
    { 1376, 432, 104},
    { 1328, 264, 128},
    { 1304, 120, 104},
    // 18 seconds
    { 1320, 112, 32},
    { 1280, 216, 8},
    { 1120, 264, 0},
    { 1040, 264, -32},
    { 1176, 272, -112},
    { 912, 248, -256},
    { 1096, 168, -256},
    { 912, 88, -104},
    { 1064, 96, -16},
    { 1104, 208, -240},
    { 1344, 280, -176},
    { 1272, 272, -72},
    { 992, 264, -104},
    { 912, 272, -144},
    { 960, 288, -120},
    { 1064, 304, -48},
    { 1152, 344, 0},
    { 1136, 408, -24},
    { 1680, 488, -64},
    { 1432, 656, -88},
    { 1240, 976, 104},
    { 1096, 640, -248},
    { 952, 400, -136},
    { 912, 488, -104},
    { 1104, 600, -40},
    // 19 seconds
    { 1408, 512, 24},
    { 1352, 272, 72},
    { 1296, 144, 96},
    { 1360, 168, 32},
    { 1352, 208, 0},
    { 1168, 240, 0},
    { 968, 216, -8},
    { 1152, 232, -16},
    { 952, 256, -184},
    { 1024, 184, -72},
    { 984, 176, -56},
    { 1144, 200, -128},
    { 1128, 240, -248},
    { 1312, 224, -136},
    { 1216, 224, -64},
    { 944, 224, -144},
    { 888, 288, -160},
    { 992, 296, -72},
    { 1168, 304, 8},
    { 1184, 352, 8},
    { 1112, 408, 8},
    { 1584, 480, 8},
    { 1488, 640, -24},
    { 1048, 752, 112},
    { 1288, 848, -216},
    // 20 seconds
    { 928, 480, -120},
    { 840, 496, -120},
    { 976, 624, -72},
    { 1320, 648, 16},
    { 1432, 400, 104},
    { 1344, 200, 128},
    { 1344, 136, 104},
    { 1384, 168, 48},
    { 1360, 224, 32},
    { 1176, 248, 24},
    { 1160, 248, 8},
    { 1080, 280, -144},
    { 872, 200, -136},
    { 1048, 64, -88},
    { 928, 88, -32},
    { 1032, 216, -192},
    { 1208, 208, -264},
    { 1352, 200, -120},
    { 1176, 216, -72},
    { 976, 240, -136},
    { 1008, 312, -192},
    { 1096, 328, -112},
    { 1168, 320, -40},
    { 1112, 352, -16},
    { 1328, 424, 16},
    // 21 seconds
    { 1816, 544, 40},
    { 1304, 640, 144},
    { 1232, 792, 64},
    { 960, 768, -128},
    { 904, 464, -96},
    { 792, 536, -40},
    { 1024, 688, 16},
    { 1240, 584, 56},
    { 1296, 376, 88},
    { 1344, 224, 128},
    { 1488, 136, 104},
    { 1448, 128, 80},
    { 1232, 176, 48},
    { 1056, 208, 48},
    { 1192, 280, 8},
    { 1032, 304, -128},
    { 1160, 224, -144},
    { 1080, -40, 64},
    { 936, 32, 32},
    { 1080, 232, -272},
    { 1160, 208, -168},
    { 1136, 200, -48},
    { 1016, 208, -80},
    { 1040, 280, -128},
    { 1128, 344, -32},
    // 22 seconds
    { 1224, 400, 40},
    { 1208, 440, -24},
    { 1080, 432, -64},
    { 1440, 472, 0},
    { 1344, 576, 104},
    { 1096, 664, 176},
    { 1360, 808, -8},
    { 1000, 600, -120},
    { 888, 488, -40},
    { 960, 584, 48},
    { 1320, 600, 80},
    { 1368, 368, 120},
    { 1344, 208, 152},
    { 1376, 160, 96},
    { 1360, 200, 32},
    { 1224, 304, 16},
    { 1032, 240, 64},
    { 1264, 192, 48},
    { 1088, 240, -24},
    { 1008, 176, -56},
    { 1008, 96, 0},
    { 1040, 48, -48},
    { 1008, 216, -224},
    { 1184, 216, -192},
    { 1224, 176, -144},
    // 23 seconds
    { 1088, 232, -184},
    { 1056, 288, -128},
    { 1128, 336, -112},
    { 1216, 400, -32},
    { 1168, 432, -24},
    { 1064, 400, -96},
    { 1408, 464, -8},
    { 1464, 584, 48},
    { 976, 568, 128},
    { 1312, 744, 8},
    { 824, 672, -120},
    { 1024, 472, -24},
    { 1088, 560, 16},
    { 1384, 584, 96},
    { 1504, 448, 136},
    { 1424, 264, 144},
    { 1376, 176, 128},
    { 1368, 200, 48},
    { 1280, 288, 16},
    { 1072, 296, -40},
    { 944, 264, -80},
    { 1032, 216, -88},
    { 848, 176, -160},
    { 848, 8, -96},
    { 664, -16, -8},
    // 24 seconds
    { 944, 328, -112},
    { 1304, 384, -336},
    { 1784, 408, -160},
    { 1480, 400, 112},
    { 1024, 248, -96},
    { 848, 200, -80},
    { 1048, 224, -40},
    { 1288, 304, 0},
    { 1192, 408, -48},
    { 1048, 440, 40},
    { 1472, 584, 104},
    { 1208, 816, 352},
    { 1264, 1264, -152},
    { 1016, 400, -56},
    { 1008, 496, -48},
    { 952, 608, 56},
    { 1288, 664, 128},
    { 1416, 440, 152},
    { 1304, 224, 120},
    { 1256, 136, 88},
    { 1336, 144, 32},
    { 1240, 232, 24},
    { 1056, 256, 8},
    { 960, 248, 32},
    { 1136, 256, -8},
    // 25 seconds
    { 920, 272, -128},
    { 936, 232, -208},
    { 1016, 160, -136},
    { 968, 128, 72},
    { 1112, 224, -144},
    { 1384, 312, -280},
    { 1360, 344, -224},
    { 984, 280, -160},
    { 824, 192, -184},
    { 976, 168, -192},
    { 1104, 184, -88},
    { 1192, 384, -48},
    { 1184, 504, -8},
    { 1696, 632, 48},
    { 1344, 720, 96},
    { 1168, 800, 120},
    { 1048, 608, -40},
    { 936, 472, 8},
    { 944, 560, 16},
    { 1152, 656, 88},
    { 1344, 560, 152},
    { 1248, 336, 152},
    { 1208, 152, 96},
    { 1224, 104, 40},
    { 1152, 200, -40},
    // 26 seconds
    { 1016, 248, -40},
    { 920, 272, -24},
    { 1152, 264, -8},
    { 1096, 272, -136},
    { 1032, 280, -152},
    { 1176, 216, -96},
    { 1240, 224, -96},
    { 1216, 280, -272},
    { 1288, 224, -136},
    { 1216, 192, 8},
    { 1048, 184, -136},
    { 888, 248, -144},
    { 848, 288, -56},
    { 888, 312, 32},
    { 936, 360, 24},
    { 1024, 400, -24},
    { 1728, 488, 64},
    { 1480, 816, -24},
    { 1064, 1352, -376},
    { 1400, 216, -40},
    { 960, 512, -184},
    { 1008, 512, -152},
    { 1128, 624, -24},
    { 1424, 688, 32},
    { 1328, 512, 96},
    // 27 seconds
    { 1312, 376, 136},
    { 1264, 336, 120},
    { 1320, 512, 24},
    { 1224, 480, 40},
    { 1200, 344, 32},
    { 1256, 200, 88},
    { 976, 88, -80},
    { 840, -72, -72},
    { 784, -48, -160},
    { 1064, 160, -240},
    { 1080, 176, -208},
    { 1232, 192, -136},
    { 1248, 160, -112},
    { 1112, 200, -80},
    { 1112, 304, 32},
    { 1336, 216, -120},
    { 1488, 536, 40},
    { 1496, 432, 136},
    { 1504, 528, 72},
    { 1776, 552, 0},
    { 1440, 912, 48},
    { 1080, 1024, -248},
    { 1112, 880, -160},
    { 1128, 728, -216},
    { 928, 600, -144},
    // 28 seconds
    { 1184, 552, -80},
    { 1456, 400, -8},
    { 1504, 224, 48},
    { 1496, 184, 40},
    { 1584, 224, 48},
    { 1528, 288, 112},
    { 1360, 272, 200},
    { 1304, 280, 216},
    { 1200, 280, 168},
    { 952, 288, 32},
    { 1072, 216, 120},
    { 944, 128, 96},
    { 952, 152, -120},
    { 968, 152, -256},
    { 1072, 104, -72},
    { 1080, 128, -72},
    { 1080, 176, -168},
    { 1288, 176, -224},
    { 1664, 776, -216},
    { 1432, 656, -96},
    { 1152, 584, 160},
    { 1296, 408, 24},
    { 1704, 352, 192},
    { 1160, 536, 128},
    { 1192, 744, 168},
    // 29 seconds
    { 952, 1064, 328},
    { 848, 936, 448},
    { 984, 1016, 408},
    { 1408, 920, 752},
    { 1792, 888, 704},
    { 1600, 632, 800},
    { 1552, 992, 728},
    { 1552, 1256, 784},
    { 1560, 1224, 656},
    { 1280, 1272, 168},
    { 936, 488, 248},
    { 648, 120, -208},
    { 448, -296, -264},
    { 264, -544, -408},
    { 48, -288, -704},
    { 112, -200, -912},
    { 264, -216, -1016},
    { 344, -192, -1080},
    { 200, -144, -936},
    { -48, -40, -832},
    { -176, 32, -880},
    { -208, 144, -928},
    { -200, 120, -928},
    { -192, 8, -976},
    { -248, -96, -1032},
    // 30 seconds
    { -264, -136, -1112},
    { -232, -136, -1160},
    { -288, -256, -1184},
    { -232, -200, -1200},
    { -248, -24, -1120},
    { -336, 152, -1008},
    { -392, 232, -872},
    { -296, 136, -832},
    { -48, 72, -864},
    { -32, -136, -816},
    { -88, -112, -800},
    { -104, -64, -880},
    { -128, -8, -968},
    { -144, 88, -1016},
    { -152, 24, -1016},
    { -64, -120, -976},
    { -96, -400, -856},
    { -8, -208, -520},
    { 32, 496, -752},
    { 416, 976, -1736},
    { 784, -312, -1752},
    { 672, -392, -1480},
    { 344, -136, -1128},
    { 176, 32, -864},
    { 32, 56, -752},
    // 31 seconds
    { -80, -72, -808},
    { -72, -256, -808},
    { 16, -408, -792},
    { 24, -368, -832},
    { 80, -320, -1000},
    { 80, -312, -1136},
    { -80, -368, -1168},
    { 72, -96, -1304},
    { 104, 40, -1336},
    { 56, -96, -1160},
    { 80, -32, -1032},
    { 168, -96, -920},
    { 96, -160, -728},
    { 32, -176, -664},
    { 16, -152, -728},
    { -16, -112, -784},
    { 24, -200, -840},
    { 72, -152, -984},
    { 160, -200, -1064},
    { 208, -280, -976},
    { 328, -384, -600},
    { 528, 88, -136},
    { 1072, 336, -128},
    { 1592, 248, 56},
    { 2120, 736, -40},
    // 32 seconds
    { 1760, 744, 312},
    { 1392, 656, 304},
    { 1264, 568, -144},
    { 1248, 544, 88},
    { 1248, 632, -72},
    { 1152, 368, 56},
    { 1256, 344, 16},
    { 1600, 456, 32},
    { 1264, 560, 80},
    { 1232, 704, 48},
    { 1016, 1072, -160},
    { 872, 664, -112},
    { 864, 472, -24},
    { 1064, 544, 8},
    { 1352, 488, -8},
    { 1376, 368, 16},
    { 1368, 248, 80},
    { 1424, 232, 56},
    { 1448, 256, -16},
    { 1248, 240, -32},
    { 1064, 184, -24},
    { 1072, 192, 64},
    { 1144, 288, -48},
    { 944, 352, -200},
    { 1032, 368, -112},
    // 33 seconds
    { 760, 184, 136},
    { 1128, 112, -48},
    { 1232, 88, -296},
    { 1288, 208, -200},
    { 1168, 208, 40},
    { 976, 248, -136},
    { 848, 400, -184},
    { 888, 272, -160},
    { 1128, 176, -120},
    { 1120, 208, -112},
    { 1144, 184, -64},
    { 1544, 304, -184},
    { 1320, 632, -344},
    { 1192, 632, -312},
    { 992, 584, -560},
    { 1176, 224, -272},
    { 1072, 320, 0},
    { 1160, 416, -16},
    { 1312, 424, -64},
    { 1248, 328, -80},
    { 1200, 152, -56},
    { 1176, 104, -56},
    { 1200, 224, -96},
    { 1104, 232, -96},
    { 960, 160, -136},
    // 34 seconds
    { 960, 104, -144},
    { 1056, 128, -168},
    { 904, 112, -256},
    { 1080, 40, -112},
    { 1096, 72, -96},
    { 1296, 136, -120},
    { 1328, 160, -72},
    { 1344, 200, -24},
    { 1200, 264, -112},
    { 920, 1056, -8},
    { 944, 568, -192},
    { 904, 336, 136},
    { 984, 336, 144},
    { 1000, 344, 80},
    { 1184, 376, 120},
    { 1688, 496, 352},
    { 1208, 1024, 224},
    { 1328, 1432, -272},
    { 992, 400, 24},
    { 984, 720, -144},
    { 1096, 640, -32},
    { 1344, 488, 32},
    { 1488, 400, 32},
    { 1456, 280, 96},
    { 1480, 184, 120},
    // 35 seconds
    { 1456, 176, 80},
    { 1328, 216, 40},
    { 1088, 264, 16},
    { 1088, 264, -16},
    { 1080, 32, 104},
    { 752, -80, -24},
    { 1128, -88, -56},
    { 1080, -8, 0},
    { 1280, 128, -168},
    { 1296, 152, -128},
    { 1408, 176, -40},
    { 1280, 184, -80},
    { 1128, 256, -56},
    { 1184, 368, 32},
    { 1304, 440, 96},
    { 1352, 472, 40},
    { 1216, 512, 24},
    { 1416, 488, 72},
    { 1456, 592, 40},
    { 1000, 848, -112},
    { 1208, 992, -344},
    { 816, 440, -176},
    { 952, 488, -152},
    { 1200, 568, -16},
    { 1584, 568, 24},
    // 36 seconds
    { 1816, 376, 48},
    { 1640, 216, 32},
    { 1568, 176, 112},
    { 1552, 208, 48},
    { 1392, 192, 8},
    { 1152, 136, -40},
    { 1080, 104, -24},
    { 960, 72, 0},
    { 640, -72, -40},
    { 752, 0, -128},
    { 704, 72, -120},
    { 896, 176, -120},
    { 1176, 80, -176},
    { 1720, 96, -192},
    { 1704, 192, -200},
    { 1272, 168, -112},
    { 1088, 152, -96},
    { 1192, 168, -104},
    { 1352, 264, -168},
    { 1200, 448, -120},
    { 1088, 432, -88},
    { 1608, 504, -176},
    { 1280, 648, -168},
    { 1064, 856, -72},
    { 1104, 768, -416},
    // 37 seconds
    { 1016, 320, -184},
    { 880, 456, -64},
    { 1312, 576, -24},
    { 1720, 488, 56},
    { 1688, 288, 112},
    { 1560, 144, 144},
    { 1440, 96, 160},
    { 1264, 160, 96},
    { 1000, 240, 0},
    { 880, 272, -80},
    { 1096, 248, -40},
    { 960, 192, -136},
    { 816, 112, -80},
    { 816, 72, -8},
    { 928, 168, 8},
    { 1192, 288, -160},
    { 1552, 360, -192},
    { 1504, 352, -16},
    { 1144, 280, -64},
    { 968, 128, -120},
    { 1072, 488, -160},
    { 1216, 248, -8},
    { 1296, 344, -24},
    { 1144, 376, 8},
    { 1472, 472, 16},
    // 38 seconds
    { 1528, 632, -48},
    { 1080, 712, 120},
    { 1152, 856, -312},
    { 920, 408, -160},
    { 832, 480, -64},
    { 1000, 632, -24},
    { 1328, 536, 16},
    { 1456, 328, 80},
    { 1352, 176, 88},
    { 1352, 120, 96},
    { 1376, 192, 72},
    { 1328, 256, 48},
    { 1144, 288, 32},
    { 1080, 280, -8},
    { 1096, 264, -80},
    { 896, 152, -96},
    { 1112, 24, 40},
    { 984, 136, -88},
    { 1080, 208, -168},
    { 1248, 200, -168},
    { 1240, 192, -56},
    { 1104, 232, -48},
    { 920, 272, -112},
    { 968, 320, -112},
    { 1104, 312, -32},
    // 39 seconds
    { 1256, 328, 0},
    { 1200, 384, 8},
    { 1344, 440, 16},
    { 1728, 568, 0},
    { 1224, 704, 168},
    { 1272, 816, -144},
    { 976, 568, -104},
    { 936, 512, -128},
    { 856, 536, -64},
    { 1088, 616, -8},
    { 1360, 568, 40},
    { 1344, 320, 120},
    { 1296, 136, 160},
    { 1352, 144, 88},
    { 1352, 176, 64},
    { 1232, 232, 72},
    { 1112, 240, 80},
    { 1160, 240, 48},
    { 1008, 248, -56},
    { 1016, 232, -48},
    { 920, 160, -144},
    { 976, 192, -120},
    { 1024, 232, -248},
    { 1256, 256, -296},
    { 1208, 240, -128},
    // 40 seconds
    { 984, 168, -104},
    { 872, 160, -80},
    { 968, 224, -80},
    { 1040, 312, -144},
    { 1032, 344, -160},
    { 992, 304, -88},
    { 1200, 360, -24},
    { 1792, 488, 0},
    { 1416, 568, 0},
    { 1400, 664, 56},
    { 1080, 864, -280},
    { 768, 392, -168},
    { 768, 504, -104},
    { 1056, 688, -48},
    { 1288, 536, 24},
    { 1224, 272, 96},
    { 1248, 88, 112},
    { 1352, 128, 80},
    { 1368, 232, 48},
    { 1200, 288, 48},
    { 1096, 280, 48},
    { 1216, 264, 16},
    { 1112, 264, -120},
    { 1080, 112, -64},
    { 1128, 8, -16},
    // 41 seconds
    { 1072, 88, -112},
    { 1032, 200, -216},
    { 1136, 192, -200},
    { 1112, 192, -136},
    { 944, 200, -176},
    { 880, 240, -104},
    { 1008, 280, -64},
    { 1224, 344, 0},
    { 1336, 440, 48},
    { 1128, 480, 88},
    { 1264, 488, -64},
    { 1392, 520, -32},
    { 1160, 488, 16},
    { 1304, 528, -32},
    { 944, 584, -152},
    { 848, 584, -160},
    { 888, 576, -88},
    { 1096, 608, -40},
    { 1352, 448, 64},
    { 1400, 240, 120},
    { 1312, 112, 120},
    { 1344, 152, 64},
    { 1304, 208, 48},
    { 1120, 256, 16},
    { 984, 272, -16},
    // 42 seconds
    { 1136, 280, -40},
    { 1080, 280, -136},
    { 1056, 192, -152},
    { 1080, 80, -112},
    { 896, 0, 16},
    { 1000, 160, -184},
    { 1080, 208, -136},
    { 1176, 240, -40},
    { 1192, 296, -128},
    { 1080, 328, -184},
    { 1032, 256, -64},
    { 1120, 280, 0},
    { 1296, 352, -8},
    { 1176, 400, 0},
    { 1136, 408, 8},
    { 1528, 472, -24},
    { 1288, 560, -56},
    { 1304, 688, -80},
    { 936, 888, -256},
    { 1008, 480, -240},
    { 888, 536, -104},
    { 1184, 952, -104},
    { 1944, 1064, 80},
    { 1976, 792, 664},
    { 1824, 144, 224},
    // 43 seconds
    { 1728, 240, -256},
    { 1568, 456, -536},
    { 1296, 456, -440},
    { 1056, 360, -456},
    { 1016, 160, -544},
    { 824, 136, -576},
    { 512, -88, -416},
    { 128, -184, -456},
    { -144, -144, -576},
    { -8, -144, -768},
    { 96, -152, -832},
    { 176, -88, -920},
    { 168, -96, -952},
    { 8, -184, -888},
    { -80, -232, -840},
    { -80, -208, -872},
    { -128, -176, -952},
    { -160, -168, -992},
    { -184, -216, -1032},
    { -72, -224, -1160},
    { -128, -152, -1216},
    { 48, 8, -1368},
    { -8, 0, -1280},
    { -128, -40, -1072},
    { -200, 104, -944},
    // 44 seconds
    { -152, 160, -952},
    { -8, 64, -1008},
    { 56, -72, -944},
    { 8, -104, -816},
    { 0, -104, -816},
    { -8, -208, -880},
    { 24, -208, -960},
    { 0, -216, -928},
    { 104, -560, -960},
    { 256, -688, -808},
    { 416, -840, -440},
    { 776, -256, 472},
    { 1304, 504, 1728},
    { 1136, 1416, 2192},
    { 680, 1504, 1384},
    { 1120, 584, -120},
    { 1464, 112, -128},
    { 1432, 608, 336},
    { 1208, 296, 776},
    { 992, 352, 584},
    { 1160, 360, 296},
    { 1256, 424, 240},
    { 1560, 512, 304},
    { 1408, 440, 472},
    { 1048, 632, 536},
    // 45 seconds
    { 1232, 1248, 368},
    { 832, 928, -152},
    { 904, 576, 168},
    { 848, 568, 72},
    { 1352, 312, -8},
    { 1496, 256, 16},
    { 1440, 80, 0},
    { 1400, 40, -32},
    { 1424, 152, -80},
    { 1304, 320, -128},
    { 1128, 264, -112},
    { 1008, 120, -48},
    { 1176, 104, -8},
    { 968, 112, -200},
    { 1032, 320, -144},
    { 976, 152, 32},
    { 1008, 152, -88},
    { 1024, 88, -280},
    { 1360, 120, -168},
    { 1336, 160, 80},
    { 1104, 192, -8},
    { 920, 320, -24},
    { 1048, 408, -80},
    { 1176, 392, -16},
    { 1176, 432, -24},
    // 46 seconds
    { 1056, 400, -8},
    { 1440, 448, 56},
    { 1480, 584, 104},
    { 1072, 712, 144},
    { 1416, 984, -64},
    { 952, 648, -112},
    { 896, 496, -24},
    { 944, 576, 16},
    { 1320, 592, 64},
    { 1464, 416, 112},
    { 1456, 224, 128},
    { 1432, 112, 120},
    { 1392, 128, 56},
    { 1240, 200, 16},
    { 1056, 216, 8},
    { 1040, 248, 24},
    { 1152, 272, -32},
    { 896, 240, -224},
    { 1096, 40, 8},
    { 904, -32, 48},
    { 1080, 216, -136},
    { 1120, 240, -152},
    { 1440, 256, -56},
    { 1448, 304, -24},
    { 1200, 320, -176},
    // 47 seconds
    { 1064, 352, -128},
    { 1088, 312, -16},
    { 1208, 336, 16},
    { 1160, 384, 16},
    { 1056, 440, -8},
    { 1520, 552, 72},
    { 1128, 712, 296},
    { 1072, 1040, -48},
    { 1040, 600, -80},
    { 1088, 496, -24},
    { 984, 552, -8},
    { 1224, 600, 48},
    { 1616, 544, 120},
    { 1672, 368, 160},
    { 1616, 208, 168},
    { 1552, 96, 72},
    { 1328, 104, -40},
    { 912, 184, -128},
    { 800, 280, -104},
    { 1040, 248, -40},
    { 848, 200, -80},
    { 920, 184, -16},
    { 880, 128, 88},
    { 1072, 200, 56},
    { 1240, 304, -56},
    // 48 seconds
    { 1336, 336, 24},
    { 1360, 336, 40},
    { 1120, 288, -80},
    { 944, 224, -48},
    { 1128, 344, -72},
    { 1304, 376, 8},
    { 1296, 352, 40},
    { 1152, 384, 80},
    { 1584, 448, 200},
    { 1512, 656, 368},
    { 1016, 808, 88},
    { 1232, 880, -32},
    { 904, 704, -40},
    { 864, 600, 40},
    { 912, 648, 48},
    { 1224, 608, 72},
    { 1496, 400, 128},
    { 1400, 248, 160},
    { 1472, 112, 160},
    { 1400, 176, 112},
    { 1376, 216, 104},
    { 1144, 288, 128},
    { 1160, 320, 8},
    { 1216, 296, -24},
    { 984, 184, -48},
    // 49 seconds
    { 1192, -56, 120},
    { 880, -96, 128},
    { 1040, 248, -184},
    { 1016, 200, -112},
    { 1152, 208, -64},
    { 1136, 240, -64},
    { 1056, 280, -112},
    { 1168, 320, -56},
    { 1304, 360, 16},
    { 1288, 432, -40},
    { 1120, 448, -64},
    { 1392, 512, 16},
    { 1432, 664, 16},
    { 1144, 680, 0},
    { 1224, 704, -88},
    { 896, 512, -128},
    { 976, 448, -40},
    { 1096, 504, 32},
    { 1336, 464, 56},
    { 1376, 360, 40},
    { 1288, 256, 80},
    { 1280, 192, 104},
    { 1280, 240, 56},
    { 1152, 240, 40},
    { 1008, 232, 48},
    // 50 seconds
    { 1152, 208, 24},
    { 1056, 224, -16},
    { 952, 160, -32},
    { 1264, 136, 0},
    { 1048, 160, -24},
    { 1048, 240, -168},
    { 1280, 240, -176},
    { 1232, 248, -104},
    { 976, 240, -120},
    { 856, 224, -160},
    { 984, 248, -56},
    { 1160, 304, 16},
    { 1216, 376, 40},
    { 1064, 440, 8},
    { 1240, 472, -32},
    { 1416, 568, -40},
    { 992, 632, 120},
    { 1448, 792, -56},
    { 912, 520, -120},
    { 1008, 384, -40},
    { 1088, 504, 0},
    { 1384, 536, 16},
    { 1424, 424, 40},
    { 1296, 336, 72},
    { 1256, 144, 176},
    // 51 seconds
    { 1264, 152, 64},
    { 1160, 168, -16},
    { 960, 232, -56},
    { 856, 208, -8},
    { 1104, 224, 0},
    { 992, 224, -72},
    { 1296, 176, 32},
    { 1000, 104, 104},
    { 1160, 200, -64},
    { 1128, 216, -16},
    { 1232, 240, 24},
    { 1224, 304, -48},
    { 1040, 344, -184},
    { 928, 352, -128},
    { 960, 320, -48},
    { 1088, 328, -48},
    { 976, 304, -136},
    { 984, 368, -96},
    { 1616, 520, 8},
    { 1408, 696, 40},
    { 1184, 776, 32},
    { 1112, 592, -32},
    { 960, 528, -64},
    { 784, 528, 32},
    { 960, 504, 104},
    // 52 seconds
    { 1224, 392, 120},
    { 1272, 328, 96},
    { 1208, 264, 88},
    { 1208, 232, 64},
    { 1256, 216, 16},
    { 1192, 232, -8},
    { 984, 232, -40},
    { 976, 216, -48},
    { 1176, 248, -128},
    { 976, 224, -152},
    { 1152, 104, -160},
    { 1120, 120, -72},
    { 1080, 136, -72},
    { 1088, 208, -184},
    { 1200, 224, -120},
    { 1160, 240, -64},
    { 976, 256, -128},
    { 912, 288, -64},
    { 1008, 320, 8},
    { 1120, 360, 32},
    { 1112, 368, 8},
    { 928, 376, -32},
    { 1440, 408, 40},
    { 1448, 528, 24},
    { 1160, 648, 152},
    // 53 seconds
    { 1216, 1048, -112},
    { 984, 584, -136},
    { 808, 360, -40},
    { 872, 496, 0},
    { 1200, 528, 8},
    { 1280, 456, 16},
    { 1240, 240, 80},
    { 1328, 184, 96},
    { 1376, 192, 40},
    { 1248, 208, -24},
    { 1048, 192, -64},
    { 1144, 200, 16},
    { 1176, 192, -128},
    { 1032, 80, -144},
    { 1200, 8, -88},
    { 992, 48, -16},
    { 1024, 208, -152},
    { 960, 184, -144},
    { 1112, 208, -80},
    { 1168, 240, -128},
    { 1032, 264, -168},
    { 992, 264, -96},
    { 1040, 280, -48},
    { 1208, 320, -80},
    { 1096, 336, -72},
    // 54 seconds
    { 1128, 376, -48},
    { 1528, 472, -88},
    { 1120, 456, -48},
    { 1344, 480, 0},
    { 952, 616, -120},
    { 960, 664, -96},
    { 968, 472, 16},
    { 1128, 488, 56},
    { 1264, 424, 64},
    { 1224, 304, 72},
    { 1280, 192, 104},
    { 1336, 176, 40},
    { 1296, 192, -16},
    { 1128, 200, -24},
    { 984, 184, -32},
    { 1112, 216, -56},
    { 1072, 264, -192},
    { 912, 216, -216},
    { 1240, 136, -136},
    { 1088, 88, -8},
    { 1080, 184, -128},
    { 1208, 224, -88},
    { 1200, 256, 8},
    { 1104, 288, -80},
    { 1008, 312, -80},
    // 55 seconds
    { 1040, 328, 40},
    { 1152, 360, 64},
    { 1208, 392, 24},
    { 1048, 400, -48},
    { 1336, 432, -72},
    { 1448, 544, 0},
    { 992, 736, 104},
    { 1288, 856, -120},
    { 880, 512, -64},
    { 976, 504, -48},
    { 1024, 544, 24},
    { 1256, 536, 40},
    { 1440, 432, 72},
    { 1376, 296, 136},
    { 1448, 232, 120},
    { 1528, 208, 72},
    { 1352, 216, 0},
    { 1064, 216, -16},
    { 1040, 200, -8},
    { 1152, 248, -120},
    { 864, 208, -192},
    { 1184, 104, -128},
    { 912, 8, 40},
    { 1088, 160, -80},
    { 1136, 216, -160},
    // 56 seconds
    { 1304, 248, -80},
    { 1264, 264, -56},
    { 1072, 280, -120},
    { 1000, 320, -120},
    { 1072, 320, -32},
    { 1176, 360, -8},
    { 1144, 376, -40},
    { 1176, 400, -56},
    { 1632, 544, 0},
    { 1248, 720, 40},
    { 1040, 840, -88},
    { 1256, 560, -32},
    { 968, 496, -80},
    { 912, 472, -64},
    { 1104, 552, 0},
    { 1328, 528, 48},
    { 1312, 360, 80},
    { 1288, 224, 120},
    { 1328, 184, 104},
    { 1328, 192, 40},
    { 1232, 224, 40},
    { 1056, 216, 40},
    { 1152, 200, 16},
    { 1112, 232, -104},
    { 920, 184, -120},
    // 57 seconds
    { 1280, 128, -144},
    { 1040, 88, -96},
    { 1072, 160, -160},
    { 1192, 168, -184},
    { 1232, 248, -200},
    { 1048, 248, -152},
    { 936, 240, -120},
    { 1016, 256, -64},
    { 1136, 304, 24},
    { 1280, 392, 48},
    { 1160, 440, 8},
    { 1264, 440, -56},
    { 1512, 504, -32},
    { 1152, 592, 40},
    { 1032, 656, -72},
    { 1232, 744, -64},
    { 904, 624, -128},
    { 936, 520, -24},
    { 1136, 584, -8},
    { 1344, 536, 8},
    { 1384, 400, 88},
    { 1440, 216, 176},
    { 1512, 120, 144},
    { 1464, 192, 56},
    { 1248, 224, 48},
    // 58 seconds
    { 968, 224, 48},
    { 976, 240, 8},
    { 1096, 248, -48},
    { 968, 264, -184},
    { 976, 136, -160},
    { 1144, -16, 144},
    { 1016, 64, -16},
    { 1200, 200, -136},
    { 1352, 264, -112},
    { 1312, 312, -96},
    { 1120, 264, -64},
    { 1128, 304, -40},
    { 1216, 376, 88},
    { 1304, 440, 48},
    { 1152, 448, -32},
    { 1200, 448, 24},
    { 1472, 624, 96},
    { 1088, 896, 96},
    { 1416, 768, 48},
    { 992, 512, 0},
    { 1000, 480, -112},
    { 960, 520, -40},
    { 1248, 568, 32},
    { 1456, 488, 64},
    { 1384, 328, 104},
    // 59 seconds
    { 1352, 200, 136},
    { 1344, 192, 104},
    { 1280, 216, 88},
    { 1152, 216, 80},
    { 984, 184, 64},
    { 1128, 176, 72},
    { 1040, 192, 0},
    { 856, 216, -72},
    { 1152, 208, -88},
    { 960, 224, -104},
    { 1064, 280, -128},
    { 1280, 312, -288},
    { 1296, 296, -184},
    { 1040, 192, -8},
    { 864, 176, -88},
    { 872, 224, -88},
    { 1008, 272, -40},
    { 1136, 352, -16},
    { 1120, 392, -24},
    { 1472, 448, 8},
    { 1848, 656, -112},
    { 1088, 952, 144},
    { 1328, 640, -280},
    { 848, 432, -96},
    { 936, 512, -136},
    // 60 seconds
    // elapsed: 1 minutes
    { 992, 544, -48},
    { 1304, 528, 0},
    { 1464, 376, 48},
    { 1352, 240, 72},
    { 1312, 184, 112},
    { 1304, 224, 72},
    { 1240, 240, 48},
    { 1008, 256, 56},
    { 904, 200, 104},
    { 1128, 216, 64},
    { 992, 216, 16},
    { 1136, 200, 32},
    { 1040, 192, 0},
    { 1176, 240, -104},
    { 1216, 256, -160},
    { 1312, 248, -160},
    { 1200, 240, -160},
    { 920, 208, -200},
    { 808, 216, -192},
    { 880, 280, -232},
    { 952, 248, -200},
    { 1048, 328, -160},
    { 1040, 368, -168},
    { 1368, 416, -80},
    { 1592, 504, -24},
    // 61 seconds
    { 1392, 488, 72},
    { 1176, 536, -120},
    { 1000, 568, -208},
    { 848, 504, -160},
    { 936, 552, 32},
    { 1408, 664, 32},
    { 1664, 544, 40},
    { 1552, 880, 0},
    { 1616, 1160, -112},
    { 1600, 1112, 112},
    { 1440, 856, -80},
    { 1096, 472, -160},
    { 800, 432, -304},
    { 696, 240, -584},
    { 432, 88, -608},
    { 384, -144, -672},
    { 192, -232, -712},
    { 176, -144, -856},
    { 240, -192, -912},
    { 240, -192, -912},
    { 280, -200, -952},
    { 144, -88, -920},
    { -8, -216, -808},
    { 0, -256, -752},
    { -8, -216, -768},
    // 62 seconds
    { -48, -216, -856},
    { -56, -208, -944},
    { -128, -232, -1000},
    { -128, -240, -1136},
    { -104, -184, -1264},
    { -232, -184, -1240},
    { -104, 64, -1272},
    { -56, -8, -1200},
    { -48, 72, -1096},
    { -80, 136, -960},
    { -48, 120, -944},
    { 16, 88, -928},
    { -8, 0, -832},
    { -48, -32, -800},
    { -56, -144, -832},
    { -32, -248, -856},
    { -16, -272, -840},
    { -24, -400, -712},
    { 120, -496, -496},
    { 432, -416, -384},
    { 944, 120, -296},
    { 1696, 528, -16},
    { 2144, 968, 184},
    { 1944, 992, -8},
    { 1632, 768, -144},
    // 63 seconds
    { 1488, 464, -296},
    { 1376, 416, -128},
    { 1480, 624, 128},
    { 1320, 576, 312},
    { 1192, 280, 160},
    { 1112, 232, 72},
    { 992, 368, 24},
    { 1072, 448, -96},
    { 1272, 544, -40},
    { 1120, 672, 40},
    { 1016, 760, 112},
    { 960, 952, 96},
    { 840, 856, -176},
    { 800, 280, 104},
    { 1056, 528, 112},
    { 1560, 680, 144},
    { 1760, 520, 144},
    { 1688, 296, 168},
    { 1632, 240, 160},
    { 1600, 256, 48},
    { 1368, 248, 64},
    { 1112, 200, 8},
    { 1016, 168, 24},
    { 1064, 184, -56},
    { 784, 160, -104},
    // 64 seconds
    { 1024, 32, 32},
    { 1040, 56, 80},
    { 1264, 352, -240},
    { 1120, 280, -176},
    { 1512, 208, 32},
    { 1368, 240, 104},
    { 1160, 216, -64},
    { 1128, 208, -144},
    { 1248, 512, -64},
    { 1320, 328, 56},
    { 1248, 416, 56},
    { 1120, 392, 48},
    { 1432, 472, 80},
    { 1288, 560, 152},
    { 936, 616, 240},
    { 1248, 864, 32},
    { 872, 824, -72},
    { 936, 472, 8},
    { 1024, 608, 80},
    { 1344, 688, 88},
    { 1456, 432, 96},
    { 1584, 112, 88},
    { 1464, -136, 112},
    { 1352, 184, -8},
    { 1232, 208, 32},
    // 65 seconds
    { 1136, 304, -32},
    { 1152, 328, 0},
    { 1024, 320, -96},
    { 848, 304, -248},
    { 1064, 136, -104},
    { 1048, 16, 88},
    { 1256, 120, -96},
    { 1232, 192, -136},
    { 1536, 336, -224},
    { 1224, 336, -192},
    { 1008, 216, -128},
    { 1120, 296, -56},
    { 1256, 392, 16},
    { 1352, 456, -8},
    { 1168, 464, -32},
    { 1216, 496, 8},
    { 1528, 624, 176},
    { 1064, 704, 152},
    { 1296, 704, 176},
    { 840, 768, 32},
    { 1056, 576, 8},
    { 1072, 456, 64},
    { 1440, 480, 200},
    { 1760, 400, 136},
    { 1552, 296, 72},
    // 66 seconds
    { 1456, 232, 64},
    { 1344, 288, 8},
    { 1184, 296, 32},
    { 1056, 240, 8},
    { 984, 208, 0},
    { 1056, 208, -136},
    { 984, 152, -88},
    { 984, 88, -88},
    { 1144, 152, -32},
    { 1136, 200, -56},
    { 1248, 336, -192},
    { 1424, 336, -224},
    { 1464, 304, -56},
    { 1248, 248, -72},
    { 1104, 288, -128},
    { 1032, 312, -160},
    { 1000, 304, -96},
    { 944, 312, -24},
    { 904, 360, 0},
    { 800, 392, -48},
    { 1016, 432, -16},
    { 1456, 552, 56},
    { 872, 584, 88},
    { 1400, 536, 24},
    { 1144, 560, 0},
    // 67 seconds
    { 1088, 552, -80},
    { 888, 472, -24},
    { 1064, 488, 56},
    { 1464, 440, 56},
    { 1584, 336, -8},
    { 1472, 144, 144},
    { 1264, 0, 160},
    { 1064, 96, 40},
    { 968, 192, -40},
    { 792, 320, -64},
    { 1104, 280, -32},
    { 968, 192, -72},
    { 864, 0, 32},
    { 1360, 48, 56},
    { 1240, 264, -32},
    { 1248, 352, -296},
    { 1304, 296, -208},
    { 1248, 264, -8},
    { 1016, 152, -104},
    { 928, 216, -40},
    { 984, 312, 32},
    { 1168, 400, 24},
    { 1248, 496, 0},
    { 1120, 520, 0},
    { 1208, 600, 224},
    // 68 seconds
    { 1064, 992, 56},
    { 1064, 544, 48},
    { 1272, 480, -8},
    { 1152, 496, -16},
    { 1104, 512, 40},
    { 1264, 504, 80},
    { 1544, 432, 0},
    { 1360, 416, 16},
    { 1216, 72, 272},
    { 1152, 72, 64},
    { 1088, 96, -8},
    { 960, 240, -16},
    { 928, 256, 16},
    { 1168, 280, -16},
    { 1000, 256, -80},
    { 976, 216, -72},
    { 1224, 200, -48},
    { 992, 176, 16},
    { 1016, 256, -144},
    { 1192, 288, -192},
    { 1288, 320, -120},
    { 1128, 256, -72},
    { 984, 264, -112},
    { 936, 320, -64},
    { 1072, 336, -80},
    // 69 seconds
    { 1088, 328, -88},
    { 968, 352, -104},
    { 1240, 408, -72},
    { 1440, 528, -56},
    { 1048, 520, 8},
    { 1328, 576, -96},
    { 1080, 680, -224},
    { 896, 408, -56},
    { 1008, 392, 88},
    { 1272, 344, 112},
    { 1336, 304, 8},
    { 1152, 288, -32},
    { 1088, 200, 64},
    { 1136, 256, -24},
    { 1120, 256, -64},
    { 1016, 224, -32},
    { 992, 176, -24},
    { 1144, 208, -80},
    { 1032, 232, -128},
    { 1312, 208, -56},
    { 1136, 152, -8},
    { 1160, 192, 80},
    { 1104, 216, 56},
    { 1120, 256, -80},
    { 1032, 304, -160},
    // 70 seconds
    { 912, 272, -176},
    { 904, 216, -64},
    { 1016, 248, -48},
    { 1168, 296, 16},
    { 1096, 456, 120},
    { 1024, 552, -104},
    { 1496, 640, -56},
    { 1160, 608, 40},
    { 1160, 568, 64},
    { 1096, 584, 0},
    { 1048, 600, -56},
    { 936, 504, -32},
    { 1104, 528, 72},
    { 1352, 504, 128},
    { 1416, 376, 152},
    { 1360, 200, 224},
    { 1304, 104, 120},
    { 1192, 144, 24},
    { 1008, 208, -16},
    { 880, 224, -24},
    { 1000, 224, -24},
    { 1056, 208, -120},
    { 976, 88, -64},
    { 1168, -56, 88},
    { 1096, 120, 72},
    // 71 seconds
    { 1280, 312, -176},
    { 1408, 288, -120},
    { 1368, 288, -48},
    { 1112, 248, -136},
    { 960, 232, -184},
    { 928, 264, -96},
    { 1024, 320, -72},
    { 1088, 376, -112},
    { 944, 400, -144},
    { 1304, 464, -72},
    { 1440, 624, -96},
    { 1040, 576, 8},
    { 1280, 536, -168},
    { 1040, 440, -104},
    { 1080, 448, -40},
    { 1144, 432, 48},
    { 1360, 392, 80},
    { 1400, 312, 56},
    { 1240, 232, 72},
    { 1208, 176, 8},
    { 1136, 288, -24},
    { 1064, 384, 0},
    { 960, 304, -96},
    { 904, 200, -176},
    { 920, 200, -184},
    // 72 seconds
    { 920, 192, -296},
    { 1096, 136, -176},
    { 1216, 184, -120},
    { 1000, 208, -16},
    { 1264, 256, -128},
    { 1472, 336, -200},
    { 1296, 336, -24},
    { 1064, 264, -80},
    { 976, 304, -16},
    { 1040, 368, 32},
    { 1192, 376, 16},
    { 1080, 408, -56},
    { 1128, 408, 8},
    { 1576, 512, 56},
    { 1096, 704, 176},
    { 1056, 864, -32},
    { 1008, 528, -72},
    { 904, 520, -56},
    { 992, 568, 0},
    { 1240, 608, 88},
    { 1568, 480, 120},
    { 1584, 280, 136},
    { 1480, 208, 128},
    { 1544, 168, 32},
    { 1424, 232, 8},
    // 73 seconds
    { 1104, 240, -56},
    { 904, 208, -96},
    { 1080, 200, -176},
    { 856, 168, -256},
    { 904, 72, -128},
    { 920, 88, -72},
    { 944, 168, -120},
    { 1104, 208, -96},
    { 1480, 280, -56},
    { 1408, 376, -8},
    { 1144, 312, -80},
    { 1016, 288, -80},
    { 1168, 336, 0},
    { 1320, 344, 0},
    { 1160, 384, -32},
    { 1152, 400, -40},
    { 1680, 552, 16},
    { 1168, 816, 272},
    { 1240, 888, -112},
    { 976, 472, -40},
    { 824, 536, -96},
    { 856, 536, 8},
    { 1176, 584, 72},
    { 1488, 456, 104},
    { 1440, 296, 104},
    // 74 seconds
    { 1384, 224, 120},
    { 1416, 184, 72},
    { 1344, 256, 0},
    { 1112, 264, -32},
    { 944, 240, -32},
    { 1072, 216, -40},
    { 984, 224, -112},
    { 1064, 168, -48},
    { 1024, 152, -56},
    { 1128, 168, -16},
    { 1056, 232, -120},
    { 1224, 248, -104},
    { 1344, 264, -64},
    { 1232, 272, -152},
    { 1024, 280, -168},
    { 992, 280, -184},
    { 1032, 288, -104},
    { 1104, 328, -96},
    { 1048, 376, -96},
    { 1040, 416, -64},
    { 1400, 488, 8},
    { 1368, 552, -40},
    { 1304, 536, 0},
    { 1008, 592, -56},
    { 1016, 648, -168},
    // 75 seconds
    { 880, 488, -64},
    { 1056, 456, 104},
    { 1360, 360, 120},
    { 1392, 232, 88},
    { 1248, 200, 64},
    { 1224, 184, 32},
    { 1208, 248, -24},
    { 1104, 272, -16},
    { 936, 224, -32},
    { 792, 200, -104},
    { 864, 192, -104},
    { 1080, 224, -168},
    { 1184, 176, -96},
    { 1392, 184, -40},
    { 1280, 184, -96},
    { 1176, 224, -80},
    { 1264, 232, -48},
    { 1280, 296, -32},
    { 1120, 320, -104},
    { 1008, 336, -80},
    { 960, 344, -8},
    { 984, 360, 0},
    { 1000, 384, -8},
    { 1016, 384, -24},
    { 1248, 408, -16},
    // 76 seconds
    { 1456, 528, 16},
    { 960, 584, 40},
    { 1168, 632, -48},
    { 928, 632, -104},
    { 1024, 560, -48},
    { 1064, 544, 16},
    { 1240, 544, 40},
    { 1488, 400, 96},
    { 1440, 224, 160},
    { 1408, 144, 144},
    { 1416, 176, 64},
    { 1312, 240, 32},
    { 1104, 264, 24},
    { 960, 240, -8},
    { 1072, 232, -120},
    { 872, 0, -152},
    { 912, -216, 72},
    { 1176, -56, 128},
    { 1440, 264, -72},
    { 1384, 312, -120},
    { 1512, 296, -88},
    { 1232, 288, -80},
    { 1080, 288, -48},
    { 1160, 424, -56},
    { 1216, 344, 128},
    // 77 seconds
    { 1360, 464, 40},
    { 1184, 448, 32},
    { 1328, 472, 56},
    { 1392, 568, 144},
    { 936, 632, 120},
    { 1000, 672, 32},
    { 1008, 760, -16},
    { 1192, 600, -40},
    { 1048, 536, 16},
    { 1352, 608, 64},
    { 1680, 568, 80},
    { 1688, 408, 184},
    { 1672, 32, 320},
    { 1456, 80, 104},
    { 1296, 88, 48},
    { 1016, 216, 0},
    { 928, 280, -32},
    { 1032, 256, -16},
    { 848, 216, -72},
    { 808, 176, -56},
    { 1120, 120, -16},
    { 912, 136, 128},
    { 1152, 248, -24},
    { 1352, 288, -72},
    { 1512, 360, -144},
    // 78 seconds
    { 1304, 304, -96},
    { 1136, 56, -24},
    { 1192, 216, 112},
    { 1232, 608, 64},
    { 1216, 792, -8},
    { 1152, 640, 112},
    { 1488, 624, 288},
    { 1312, 576, 296},
    { 960, 504, 296},
    { 1208, 560, 352},
    { 936, 584, 208},
    { 888, 600, 144},
    { 992, 640, 240},
    { 1304, 600, 352},
    { 1448, 480, 312},
    { 1424, 232, 192},
    { 1416, -24, 16},
    { 1328, 0, 24},
    { 1120, 200, 72},
    { 984, 352, -88},
    { 1144, 424, -112},
    { 1120, 424, -344},
    { 952, 288, -272},
    { 1232, 96, -96},
    { 880, -112, 40},
    // 79 seconds
    { 968, -8, -8},
    { 1216, 128, -200},
    { 1424, 344, -136},
    { 1256, 384, -64},
    { 1008, 344, -136},
    { 1016, 328, -64},
    { 1144, 336, 8},
    { 1240, 368, 16},
    { 1168, 392, 0},
    { 1416, 472, 88},
    { 1608, 648, 256},
    { 1008, 904, 120},
    { 1224, 752, 88},
    { 864, 600, 32},
    { 960, 616, -8},
    { 880, 592, 56},
    { 1144, 608, 128},
    { 1432, 512, 136},
    { 1432, 336, 168},
    { 1464, 192, 168},
    { 1504, 168, 120},
    { 1416, 208, 48},
    { 1208, 264, 16},
    { 1008, 248, -8},
    { 976, 240, -96},
    // 80 seconds
    { 904, 224, -192},
    { 816, 128, -240},
    { 1080, 16, -64},
    { 960, 8, 8},
    { 1144, 192, -120},
    { 1280, 248, -184},
    { 1344, 296, -136},
    { 1168, 272, -48},
    { 1088, 272, -56},
    { 1200, 344, 0},
    { 1296, 392, 32},
    { 1272, 440, 16},
    { 1056, 440, -16},
    { 1072, 456, -8},
    { 1432, 552, 40},
    { 1096, 576, 96},
    { 1256, 592, 16},
    { 968, 696, -112},
    { 1000, 616, -104},
    { 1120, 736, -88},
    { 1344, 584, 232},
    { 1608, 328, 320},
    { 1432, 224, 240},
    { 1336, 144, 136},
    { 1248, 40, 64},
    // 81 seconds
    { 1104, 56, 40},
    { 928, 184, -104},
    { 872, 248, -120},
    { 1128, 264, -104},
    { 1048, 272, -224},
    { 904, 184, -144},
    { 1304, 160, -88},
    { 840, 208, -8},
    { 1200, 200, -16},
    { 1320, 232, -32},
    { 1312, 344, -72},
    { 1008, 320, -112},
    { 920, 272, -88},
    { 1064, 304, -8},
    { 1232, 328, -40},
    { 1152, 368, -64},
    { 1048, 408, -24},
    { 1464, 496, 0},
    { 1312, 632, -64},
    { 1000, 664, -64},
    { 1256, 840, -288},
    { 904, 424, -152},
    { 944, 448, -48},
    { 1184, 480, 24},
    { 1552, 376, 24},
    // 82 seconds
    { 1536, 272, 24},
    { 1408, 200, 88},
    { 1360, 256, 80},
    { 1296, 232, 88},
    { 1096, 256, 16},
    { 872, 200, -24},
    { 928, 168, -40},
    { 960, 200, -104},
    { 872, 168, -80},
    { 1120, 184, -80},
    { 1056, 208, -40},
    { 1104, 256, -64},
    { 1352, 304, -104},
    { 1376, 320, -8},
    { 1200, 272, -48},
    { 1024, 296, -128},
    { 976, 328, -72},
    { 1112, 320, -56},
    { 1120, 328, -32},
    { 1040, 360, -16},
    { 1368, 432, 56},
    { 1560, 568, 72},
    { 1088, 616, 216},
    { 1360, 816, -24},
    { 824, 720, -112},
    // 83 seconds
    { 920, 512, -8},
    { 1032, 568, 40},
    { 1336, 600, 48},
    { 1464, 400, 80},
    { 1384, 216, 136},
    { 1424, 152, 112},
    { 1432, 208, 48},
    { 1352, 232, 32},
    { 1112, 232, 32},
    { 1048, 208, 32},
    { 1080, 224, -24},
    { 920, 216, -120},
    { 968, 136, -72},
    { 888, 128, -40},
    { 976, 192, -32},
    { 1104, 256, -232},
    { 1360, 288, -216},
    { 1264, 272, -96},
    { 1008, 192, -40},
    { 1008, 248, -120},
    { 1152, 296, -40},
    { 1280, 360, -64},
    { 1128, 392, -88},
    { 1120, 408, -104},
    { 1448, 520, -80},
    // 84 seconds
    { 1312, 616, 0},
    { 960, 576, 0},
    { 1424, 704, -96},
    { 880, 544, -144},
    { 1000, 488, -40},
    { 1120, 536, 32},
    { 1472, 504, 64},
    { 1416, 352, 104},
    { 1336, 224, 144},
    { 1352, 152, 128},
    { 1352, 184, 16},
    { 1160, 232, 72},
    { 912, 320, -32},
    { 784, 392, -128},
    { 920, 352, -48},
    { 880, 328, -152},
    { 816, 288, -192},
    { 1112, 256, -72},
    { 880, 248, -136},
    { 1112, 224, -64},
    { 1288, 216, 8},
    { 1264, 296, 32},
    { 1160, 296, 8},
    { 1000, 288, -8},
    { 1016, 352, 0},
    // 85 seconds
    { 1048, 368, 16},
    { 1152, 352, 16},
    { 1080, 336, -16},
    { 1288, 344, -40},
    { 1712, 480, -104},
    { 1272, 496, -24},
    { 1336, 696, -152},
    { 912, 832, -456},
    { 952, 360, -176},
    { 984, 504, -64},
    { 1256, 544, -64},
    { 1328, 352, -24},
    { 1240, 192, 32},
    { 1240, 136, 64},
    { 1352, 232, 40},
    { 1264, 264, 56},
    { 1104, 264, 72},
    { 1048, 232, 56},
    { 1184, 240, 32},
    { 1040, 240, -56},
    { 1056, 224, -72},
    { 1016, 200, -136},
    { 1016, 192, -64},
    { 976, 232, -232},
    { 1144, 264, -288},
    // 86 seconds
    { 1032, 248, -256},
    { 816, 192, -192},
    { 808, 216, -120},
    { 968, 288, -112},
    { 1112, 344, -72},
    { 1184, 384, -56},
    { 1192, 376, 32},
    { 1576, 424, 104},
    { 1448, 552, 56},
    { 1136, 576, 48},
    { 1192, 792, -160},
    { 864, 592, -232},
    { 992, 424, -120},
    { 1032, 560, -112},
    { 1216, 576, -72},
    { 1392, 424, 8},
    { 1232, 208, 80},
    { 1248, 56, 96},
    { 1320, 112, 64},
    { 1296, 208, 32},
    { 1112, 248, 32},
    { 960, 256, 8},
    { 976, 240, -8},
    { 904, 232, -80},
    { 840, 224, -144},
    // 87 seconds
    { 1048, 184, -208},
    { 984, 200, -48},
    { 1112, 224, -144},
    { 1304, 272, -296},
    { 1368, 256, -56},
    { 1184, 240, -112},
    { 936, 240, -160},
    { 912, 296, -64},
    { 1064, 328, -40},
    { 1160, 352, 0},
    { 1056, 408, -8},
    { 1112, 432, 0},
    { 1632, 544, 48},
    { 1232, 784, 248},
    { 1016, 912, -232},
    { 1160, 568, -16},
    { 952, 664, -88},
    { 1048, 568, -32},
    { 1256, 616, -16},
    { 1552, 568, 32},
    { 1576, 328, 160},
    { 1576, 128, 184},
    { 1592, 152, 96},
    { 1448, 200, 24},
    { 1168, 240, -24},
    // 88 seconds
    { 928, 256, -56},
    { 968, 256, -120},
    { 864, 200, -232},
    { 744, 104, -184},
    { 928, 0, -24},
    { 800, 72, 16},
    { 1016, 264, -168},
    { 1376, 320, -240},
    { 1752, 408, -200},
    { 1272, 368, 16},
    { 1008, 232, -40},
    { 1144, 296, -120},
    { 1360, 280, -104},
    { 1360, 352, -176},
    { 1128, 424, -56},
    { 1656, 536, 0},
    { 1432, 744, 8},
    { 1048, 880, -144},
    { 1120, 640, -232},
    { 1112, 616, -136},
    { 1160, 552, -8},
    { 1256, 544, 48},
    { 1528, 400, 40},
    { 1464, 216, 56},
    { 1296, 152, 128},
    // 89 seconds
    { 1336, 200, 32},
    { 1280, 264, 8},
    { 1104, 256, 40},
    { 976, 208, 56},
    { 1096, 208, 24},
    { 976, 224, -120},
    { 864, 208, -96},
    { 1008, 160, -88},
    { 1096, 192, -56},
    { 1192, 232, -200},
    { 1424, 248, -192},
    { 1240, 224, -64},
    { 976, 200, -72},
    { 944, 280, -136},
    { 1088, 344, -136},
    { 1224, 352, -112},
    { 1152, 336, -80},
    { 1184, 352, -48},
    { 1520, 464, -24},
    { 1528, 560, -32},
    { 1168, 568, 32},
    { 1168, 792, -88},
    { 976, 744, -168},
    { 808, 392, -112},
    { 896, 456, -32},
    // 90 seconds
    { 1272, 512, 24},
    { 1440, 424, 56},
    { 1336, 280, 80},
    { 1328, 208, 96},
    { 1320, 224, 64},
    { 1264, 232, 40},
    { 1104, 224, 56},
    { 928, 184, 24},
    { 1056, 200, 16},
    { 1064, 224, -40},
    { 1072, 256, -112},
    { 1176, 200, -168},
    { 1192, 176, -144},
    { 1008, 152, -136},
    { 1088, 152, -152},
    { 1136, 216, -128},
    { 1056, 248, -176},
    { 968, 264, -160},
    { 992, 272, -120},
    { 1056, 296, -120},
    { 1136, 336, -88},
    { 1120, 384, -88},
    { 1264, 400, -72},
    { 1696, 512, -96},
    { 1168, 552, -8},
    // 91 seconds
    { 1472, 728, -24},
    { 904, 712, -200},
    { 928, 456, -128},
    { 928, 528, -48},
    { 1200, 560, 16},
    { 1408, 448, 48},
    { 1376, 288, 112},
    { 1368, 208, 120},
    { 1416, 184, 72},
    { 1320, 224, 40},
    { 1088, 240, 40},
    { 920, 216, -8},
    { 1064, 208, 0},
    { 1000, 240, -80},
    { 888, 224, -96},
    { 1224, 200, -184},
    { 1120, 160, -112},
    { 1128, 192, -160},
    { 1288, 208, -280},
    { 1256, 184, -120},
    { 1072, 208, -136},
    { 912, 280, -184},
    { 960, 304, -192},
    { 1032, 288, -96},
    { 1104, 320, -64},
    // 92 seconds
    { 1088, 368, -56},
    { 1176, 408, -80},
    { 1616, 544, -120},
    { 1232, 704, -72},
    { 1144, 616, -80},
    { 1048, 552, -128},
    { 1128, 528, -136},
    { 1128, 528, -56},
    { 1304, 520, 24},
    { 1560, 464, 56},
    { 1400, 336, 80},
    { 1248, 200, 136},
    { 1232, 136, 80},
    { 1240, 152, -40},
    { 1136, 168, -168},
    { 968, 128, -48},
    { 904, 128, -16},
    { 984, 232, -152},
    { 816, 296, -312},
    { 1128, 232, -208},
    { 1064, 216, -104},
    { 1328, 240, -80},
    { 1352, 248, -144},
    { 1312, 280, -8},
    { 1136, 272, -136},
    // 93 seconds
    { 968, 264, -112},
    { 976, 304, -80},
    { 1048, 304, -40},
    { 1112, 304, 0},
    { 1160, 408, 32},
    { 1256, 592, 8},
    { 1592, 696, 80},
    { 1056, 896, 32},
    { 1256, 784, 64},
    { 736, 784, -24},
    { 976, 704, -8},
    { 1184, 664, 88},
    { 1480, 616, 232},
    { 1584, 480, 264},
    { 1472, 312, 224},
    { 1448, 152, 152},
    { 1432, 128, 48},
    { 1288, 168, -8},
    { 1080, 168, -16},
    { 1032, 192, -24},
    { 1024, 192, -96},
    { 768, 128, -112},
    { 1032, 64, -56},
    { 936, 120, -16},
    { 1160, 208, -72},
    // 94 seconds
    { 1312, 232, -136},
    { 1440, 272, -104},
    { 1216, 280, -24},
    { 1040, 256, -128},
    { 1144, 336, -136},
    { 1280, 360, -24},
    { 1360, 400, 16},
    { 1216, 440, -8},
    { 1432, 480, 16},
    { 1544, 560, 88},
    { 1040, 616, 184},
    { 1424, 840, 8},
    { 864, 704, -96},
    { 904, 560, -48},
    { 976, 616, 24},
    { 1280, 640, 48},
    { 1400, 456, 104},
    { 1376, 264, 152},
    { 1424, 152, 136},
    { 1448, 200, 80},
    { 1368, 232, 56},
    { 1136, 232, 96},
    { 1144, 224, 136},
    { 1168, 256, 56},
    { 928, 240, -72},
    // 95 seconds
    { 1136, 144, -80},
    { 920, 8, -8},
    { 1096, 120, -120},
    { 1224, 192, -208},
    { 1344, 224, -200},
    { 1152, 224, -144},
    { 984, 248, -136},
    { 1016, 272, -120},
    { 1096, 304, -72},
    { 1160, 368, 8},
    { 1104, 432, 24},
    { 1272, 472, 24},
    { 1584, 560, -40},
    { 1088, 536, 96},
    { 1528, 712, 64},
    { 952, 784, -120},
    { 1000, 456, -112},
    { 920, 488, -40},
    { 1240, 584, -8},
    { 1408, 504, 32},
    { 1344, 360, 112},
    { 1320, 200, 184},
    { 1352, 168, 96},
    { 1256, 144, 32},
    { 1096, 200, 0},
    // 96 seconds
    { 952, 208, -8},
    { 944, 232, -24},
    { 968, 216, -64},
    { 888, 248, -176},
    { 1128, 240, -256},
    { 952, 160, -72},
    { 1144, 168, -64},
    { 1216, 240, -176},
    { 1376, 296, -104},
    { 1216, 288, -32},
    { 1032, 256, -96},
    { 960, 288, -80},
    { 1048, 320, -64},
    { 1088, 328, -56},
    { 1040, 344, -16},
    { 1128, 352, 16},
    { 1256, 408, 8},
    { 1288, 472, -96},
    { 1080, 480, -88},
    { 912, 464, -72},
    { 1296, 664, -136},
    { 944, 784, -152},
    { 952, 480, -24},
    { 1112, 448, 16},
    { 1320, 440, 0},
    // 97 seconds
    { 1424, 400, 16},
    { 1392, 304, 88},
    { 1328, 224, 120},
    { 1296, 208, 56},
    { 1216, 200, 56},
    { 976, 208, 48},
    { 832, 184, 24},
    { 1000, 224, 0},
    { 1048, 240, -88},
    { 904, 192, -24},
    { 1168, 152, -40},
    { 1096, 152, 48},
    { 1064, 296, -240},
    { 1272, 280, -288},
    { 1296, 208, -72},
    { 1088, 152, -8},
    { 936, 224, -72},
    { 1008, 360, -184},
    { 976, 328, -96},
    { 1080, 376, 0},
    { 1096, 368, 48},
    { 1192, 424, 24},
    { 1496, 520, -56},
    { 1128, 584, 8},
    { 856, 536, 0},
    // 98 seconds
    { 1664, 744, -96},
    { 1280, 728, -112},
    { 1168, 528, -32},
    { 1168, 544, -8},
    { 1384, 544, -24},
    { 1520, 392, 192},
    { 1312, 48, 224},
    { 1136, 24, 104},
    { 1288, -8, -128},
    { 1152, 160, 16},
    { 992, 248, 64},
    { 920, 296, 0},
    { 984, 336, -136},
    { 912, 312, -296},
    { 1072, 224, -160},
    { 1104, 152, 48},
    { 1384, 176, -32},
    { 1416, 240, -152},
    { 1424, 216, -24},
    { 1064, 192, -168},
    { 936, 184, -264},
    { 936, 264, -336},
    { 1040, 296, -272},
    { 1064, 312, -216},
    { 968, 328, -200},
    // 99 seconds
    { 896, 368, -128},
    { 1120, 408, -80},
    { 1368, 488, 16},
    { 1224, 520, 96},
    { 1040, 576, 8},
    { 904, 672, -8},
    { 1328, 1048, 360},
    { 760, 816, 112},
    { 1480, 496, 104},
    { 1544, 632, 216},
    { 1824, 768, 240},
    { 1648, 576, 328},
    { 1544, 272, 400},
    { 1496, 120, 256},
    { 1360, 136, 48},
    { 1232, 176, -80},
    { 1096, 184, -72},
    { 1112, 128, 32},
    { 1040, 56, 56},
    { 864, 96, -56},
    { 896, 152, 40},
    { 1160, 248, 96},
    { 1576, 416, -320},
    { 1872, 512, -544},
    { 1616, 216, 144},
    // 100 seconds
    { 1264, 112, 16},
    { 1120, -56, -336},
    { 1008, 792, -336},
    { 1136, 200, -80},
    { 1184, 376, 0},
    { 1248, 392, 40},
    { 1600, 480, 144},
    { 1312, 576, 328},
    { 1264, 800, 168},
    { 936, 1088, -64},
    { 1000, 472, 0},
    { 896, 720, 96},
    { 1456, 888, 304},
    { 1784, 656, 312},
    { 1944, 920, 224},
    { 1904, 760, 464},
    { 1816, 1528, 312},
    { 1712, 1488, 344},
    { 1320, 1432, 280},
    { 1024, 1464, 16},
    { 736, 880, -48},
    { 328, 72, -40},
    { 88, -256, -336},
    { -416, -320, -424},
    { -560, -176, -800},
    // 101 seconds
    { -616, -32, -488},
    { -608, 632, -504},
    { -664, 96, -288},
    { -616, -88, -376},
    { -512, -56, -512},
    { -584, -72, -376},
    { -624, -64, -352},
    { -704, -88, -424},
    { -792, -232, -680},
    { -1080, -360, -728},
    { -1112, -360, -632},
    { -1280, -64, -696},
    { -1456, 208, -632},
    { -1200, 272, -272},
    { -912, 256, 0},
    { -680, 80, 96},
    { -648, -88, 48},
    { -392, -296, -136},
    { -272, -288, -376},
    { -368, 208, -592},
    { -696, 144, -344},
    { -872, 72, -552},
    { -984, 88, -792},
    { -936, 120, -768},
    { -816, 64, -456},
    // 102 seconds
    { -432, -32, -104},
    { 56, 280, -256},
    { 576, 1176, -1008},
    { 880, 576, -304},
    { 2048, -704, 208},
    { 2328, 48, 112},
    { 2232, 552, -8},
    { 1752, 800, -48},
    { 1544, 744, 16},
    { 1560, 792, 8},
    { 1448, 752, 120},
    { 1488, 608, 208},
    { 1504, 488, 184},
    { 1696, 448, 120},
    { 1328, 608, 208},
    { 1320, 936, 56},
    { 976, 1416, 120},
    { 864, 912, -200},
    { 688, 552, -120},
    { 912, 624, -8},
    { 1392, 560, 96},
    { 1432, 392, 72},
    { 1400, 328, 16},
    { 1528, 304, 40},
    { 1608, 344, 64},
    // 103 seconds
    { 1544, 320, 88},
    { 1312, 240, 88},
    { 1168, 160, -16},
    { 1200, 120, -152},
    { 1032, 144, -184},
    { 1080, 144, -224},
    { 968, 104, -352},
    { 960, 104, -320},
    { 1096, 136, -288},
    { 1248, 160, -160},
    { 1240, 224, -80},
    { 1184, 296, -56},
    { 1168, 360, -24},
    { 1176, 416, 48},
    { 1232, 448, 88},
    { 1200, 456, 88},
    { 1240, 440, 96},
    { 1568, 464, 136},
    { 1160, 632, 104},
    { 976, 1080, -72},
    { 1152, 1144, -192},
    { 1032, 544, -80},
    { 1136, 568, -112},
    { 1336, 720, 0},
    { 1816, 808, 40},
    // 104 seconds
    { 1920, 584, 104},
    { 1952, 616, -32},
    { 1952, 712, -64},
    { 1744, 808, 72},
    { 1496, 496, -24},
    { 1016, 240, -32},
    { 664, 248, -256},
    { 608, 184, -640},
    { 320, 104, -528},
    { 320, -200, -592},
    { 112, -184, -800},
    { 208, -200, -984},
    { 232, -144, -1024},
    { 216, -232, -968},
    { 104, -288, -856},
    { -56, -184, -720},
    { -152, -88, -696},
    { -192, -152, -784},
    { -144, -104, -952},
    { -144, -168, -1032},
    { -152, -208, -1104},
    { -104, -184, -1200},
    { -216, -144, -1184},
    { -240, -96, -1176},
    { -120, 136, -1296},
    // 105 seconds
    { 16, 136, -1344},
    { -48, 24, -1128},
    { 0, 128, -1056},
    { 48, 40, -992},
    { 64, -120, -848},
    { 32, -128, -776},
    { 32, -184, -800},
    { 16, -200, -792},
    { 0, -224, -736},
    { -8, -368, -608},
    { 88, -416, -480},
    { 280, -472, -384},
    { 720, -352, -80},
    { 1368, 232, 384},
    { 2408, 952, 712},
    { 2552, 1536, 424},
    { 2040, 1336, -112},
    { 1344, 544, -368},
    { 1160, 320, -296},
    { 1128, 552, 80},
    { 1360, 448, 384},
    { 1304, 152, 256},
    { 1264, 296, 224},
    { 1104, 520, 392},
    { 1384, 760, 176},
    // 106 seconds
    { 1296, 856, 264},
    { 736, 1032, 288},
    { 1320, 1016, 136},
    { 712, 696, 104},
    { 1184, 768, -8},
    { 1208, 784, 56},
    { 1744, 728, 184},
    { 1944, 584, 256},
    { 1896, 336, 352},
    { 1840, 176, 312},
    { 1736, 104, 168},
    { 1456, 168, 120},
    { 1128, 184, 128},
    { 912, 224, -8},
    { 888, 232, -8},
    { 768, 184, -56},
    { 592, 168, -144},
    { 656, 112, -64},
    { 576, 112, -64},
    { 928, 208, -120},
    { 1640, 296, -176},
    { 2816, 488, -552},
    { 2040, 400, -104},
    { 1136, 168, -64},
    { 1032, -24, -184},
    // 107 seconds
    { 1376, 0, -136},
    { 1352, 280, -16},
    { 1336, 568, 72},
    { 1464, 744, 96},
    { 1704, 896, 248},
    { 1448, 992, 56},
    { 1312, 1000, 16},
    { 712, 768, -16},
    { 472, 616, -64},
    { 976, 648, 80},
    { 2152, 408, 352},
    { 3040, 104, 232},
    { 2912, 472, 96},
    { 2560, 784, 224},
    { 2048, 632, 240},
    { 1624, 576, 144},
    { 1368, 800, -40},
    { 1064, 832, -192},
    { 728, 704, -216},
    { 304, 88, -72},
    { -152, 312, -304},
    { -192, 352, -912},
    { -544, -96, -896},
    { -1072, -144, -648},
    { -1144, 544, -568},
    // 108 seconds
    { -816, 720, -552},
    { -560, 592, -392},
    { -488, 448, -368},
    { -480, 344, -360},
    { -472, 224, -376},
    { -472, 200, -352},
    { -584, 240, -344},
    { -592, 312, -416},
    { -688, 352, -608},
    { -816, 424, -760},
    { -1032, 288, -800},
    { -1032, 80, -776},
    { -1112, 88, -640},
    { -1256, 96, -488},
    { -1128, 160, -384},
    { -968, 144, -304},
    { -888, 120, -272},
    { -976, 304, -216},
    { -824, 160, -80},
    { -736, 64, -40},
    { -720, -40, -48},
    { -648, -176, -56},
    { -640, -160, -144},
    { -712, -448, -144},
    { -928, -352, -464},
    // 109 seconds
    { -1160, -448, -568},
    { -1184, -504, -648},
    { -1120, -384, -720},
    { -1176, -376, -664},
    { -1032, -192, -632},
    { -792, -88, -608},
    { -568, -48, -736},
    { -536, 104, -632},
    { -648, 176, -392},
    { -608, 208, -432},
    { -576, 280, -376},
    { -472, 232, -360},
    { -368, 272, -432},
    { -328, 184, -464},
    { -224, 96, -760},
    { -24, 24, -952},
    { -64, -376, -1016},
    { -144, -768, -1232},
    { -72, -672, -1024},
    { -80, -528, -760},
    { -360, -664, 400},
    { -640, -520, 672},
    { -800, -416, 624},
    { -832, -648, 736},
    { -928, -856, 728},
    // 110 seconds
    { -936, -640, 712},
    { -800, 80, 768},
    { -872, 1232, 624},
    { -1216, 1952, 1120},
    { -1648, 1824, 1376},
    { -1640, 2032, 1344},
    { 328, -1184, 1312},
    { 224, -632, -1128},
    { -176, -816, -1288},
    { -456, 432, -1112},
    { -24, 696, -1408},
    { -32, 80, -1304},
    { -32, -264, -968},
    { -80, -240, -800},
    { -152, -136, -752},
    { -200, -120, -784},
    { -192, -88, -880},
    { -144, -80, -976},
    { -152, -144, -1000},
    { -232, -176, -1024},
    { -168, -112, -1136},
    { -280, -16, -1224},
    { -152, 288, -1376},
    { -184, 200, -1304},
    { -272, 120, -1072},
    // 111 seconds
    { -232, 152, -992},
    { -120, 72, -952},
    { -152, -16, -848},
    { -176, -88, -768},
    { -232, -48, -752},
    { -224, -128, -784},
    { -200, -160, -800},
    { -248, -216, -752},
    { -104, -96, -872},
    { 96, 88, -1176},
    { 272, -16, -1408},
    { 496, -40, -1384},
    { 696, -112, -1152},
    { 744, -248, -696},
    { 816, 80, -216},
    { 720, 336, 16},
    { 664, 544, 96},
    { 648, 640, 144},
    { 768, 664, 176},
    { 1088, 520, 368},
    { 1728, 528, 688},
    { 1904, 616, 760},
    { 2640, 888, 400},
    { 2016, 976, 480},
    { 1768, 1168, 456},
    // 112 seconds
    { 1320, 792, 48},
    { 960, 1024, -384},
    { 648, 1080, -536},
    { 712, 768, -384},
    { 1152, 504, -128},
    { 1264, 408, 32},
    { 1368, 168, 136},
    { 1592, 48, 0},
    { 1768, 336, -112},
    { 1648, 400, 104},
    { 1504, 312, 120},
    { 1464, 328, 104},
    { 1384, 320, 80},
    { 1184, 296, -472},
    { 1240, -408, -304},
    { 664, -944, 408},
    { 1336, 8, -272},
    { 1240, 304, -408},
    { 1392, 240, -192},
    { 1392, 256, -56},
    { 1584, 296, -48},
    { 1760, 488, 72},
    { 1488, 672, 424},
    { 1352, 592, 80},
    { 1272, 304, 120},
    // 113 seconds
    { 1336, 384, 192},
    { 1408, 640, 200},
    { 976, 784, 152},
    { 1024, 1216, 120},
    { 816, 920, -120},
    { 944, 544, -120},
    { 1008, 576, -40},
    { 1512, 640, 112},
    { 1816, 568, 136},
    { 1768, 376, 168},
    { 1784, 232, 216},
    { 1744, 200, 176},
    { 1528, 232, 104},
    { 1200, 224, 88},
    { 976, 208, -8},
    { 888, 200, -16},
    { 840, 192, -88},
    { 704, 184, -192},
    { 800, 112, -248},
    { 992, 112, -144},
    { 1024, 136, -56},
    { 1352, 232, -160},
    { 1704, 360, -288},
    { 1480, 416, -152},
    { 1136, 272, -32},
    // 114 seconds
    { 1136, 240, -32},
    { 1256, 296, 16},
    { 1424, 344, -8},
    { 1232, 440, 40},
    { 1112, 472, 56},
    { 1256, 536, 8},
    { 1288, 576, 96},
    { 968, 632, 120},
    { 1384, 848, 176},
    { 944, 832, -80},
    { 1016, 512, -56},
    { 1016, 568, 24},
    { 1312, 656, 96},
    { 1632, 568, 160},
    { 1536, 368, 224},
    { 1568, 216, 232},
    { 1504, 160, 152},
    { 1360, 200, 112},
    { 1144, 224, 152},
    { 968, 232, 120},
    { 952, 256, 112},
    { 976, 432, 72},
    { 1048, 896, -88},
    { 1256, 992, -184},
    { 608, 1064, -640},
    // 115 seconds
    { 344, 1120, -832},
    { 352, 880, -784},
    { 472, 424, -784},
    { 336, 128, -712},
    { 192, 232, -752},
    { 88, 200, -760},
    { 0, 112, -736},
    { 0, 72, -792},
    { 168, 0, -728},
    { -120, 0, -864},
    { -216, 0, -912},
    { -256, 0, -1000},
    { -256, 24, -1072},
    { -328, 32, -1032},
    { -288, 160, -1112},
    { -208, 304, -1184},
    { -128, 296, -1080},
    { -200, 368, -976},
    { -224, 392, -848},
    { -176, 496, -920},
    { -216, 352, -944},
    { -208, 232, -968},
    { -200, 160, -856},
    { -168, 128, -840},
    { -144, 112, -928},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

