#!/usr/bin/env python
# SPDX-FileCopyrightText: 2024 Google LLC
# SPDX-License-Identifier: Apache-2.0


from __future__ import print_function

CRC_POLY = 0xEDB88320


def crc_table(bits):
    lookup_table = []
    for i in xrange(2**bits):
        rr = i * 16
        for x in xrange(8):
            rr = (rr >> 1) ^ (-(rr & 1) & CRC_POLY)
        lookup_table.append(rr & 0xffffffff)
    return lookup_table

table = ['0x{:08x},'.format(entry) for entry in crc_table(4)]
chunks = zip(*[iter(table)]*4)

print('static const uint32_t s_lookup_table[] = {')
for chunk in chunks:
    print('  ' + ' '.join(chunk))
print('};')
