/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#pragma once

#define DISPLAY_ORIENTATION_COLUMN_MAJOR_INVERTED 0
#define DISPLAY_ORIENTATION_ROTATED_180 1
#define DISPLAY_ORIENTATION_ROW_MAJOR 0
#define DISPLAY_ORIENTATION_ROW_MAJOR_INVERTED 0

#define PBL_BW 1
#define PBL_COLOR 0

#define PBL_RECT 1
#define PBL_ROUND 0

#define PBL_DISPLAY_WIDTH 144
#define PBL_DISPLAY_HEIGHT 168

#define LEGACY_2X_DISP_COLS PBL_DISPLAY_WIDTH
#define LEGACY_2X_DISP_ROWS PBL_DISPLAY_HEIGHT
#define LEGACY_3X_DISP_COLS PBL_DISPLAY_WIDTH
#define LEGACY_3X_DISP_ROWS PBL_DISPLAY_HEIGHT

#define DISPLAY_FRAMEBUFFER_BYTES \
    (ROUND_TO_MOD_CEIL(PBL_DISPLAY_WIDTH, 32) / 8 * PBL_DISPLAY_HEIGHT)
