/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#include <stdint.h>
#include <string.h>

#include "applib/accel_service.h"


// ----------------------------------------------------------------
// Sample captured: 2015-09-26 10:52:34 local
AccelRawData *activity_sample_driving_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME driving_4
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 10
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // elapsed: 0 minutes
    { -216, -96, -992},
    { -224, -88, -992},
    { -240, -112, -984},
    { -224, -88, -1000},
    { -200, -72, -1032},
    { -240, -72, -992},
    { -248, -64, -1000},
    { -296, -24, -968},
    { -232, -64, -992},
    { -248, -80, -1000},
    { -240, -80, -984},
    { -232, -80, -992},
    { -232, -64, -1024},
    { -256, -64, -984},
    { -216, -96, -992},
    { -296, -136, -984},
    { -288, -72, -984},
    { -288, -96, -968},
    { -248, -96, -976},
    { -240, -56, -1008},
    { -224, -64, -1008},
    { -232, -96, -984},
    { -232, -80, -992},
    { -240, -64, -1000},
    { -240, -64, -992},
    { -232, -48, -1000},
    { -232, -56, -1000},
    { -232, -56, -1000},
    { -232, -48, -1000},
    { -232, -48, -1008},
    { -240, -48, -1000},
    { -224, -40, -1000},
    { -192, 48, -1016},
    { -312, -208, -960},
    { -272, -120, -992},
    { -232, -48, -976},
    { -272, -120, -992},
    { -288, -88, -1008},
    { -208, -64, -1016},
    { -200, -104, -1008},
    { -176, -96, -1000},
    { -168, -64, -1008},
    { -208, -96, -1008},
    { -208, -96, -1024},
    { -168, -88, -1048},
    { -160, -48, -1112},
    { -264, -56, -1224},
    { -264, -88, -1176},
    { -248, -136, -1248},
    { -352, -72, -1200},
    { -520, 24, -1072},
    { -752, 168, -968},
    { -800, 264, -904},
    { -896, 360, -752},
    { -912, 216, -472},
    { -920, 168, -464},
    { -784, 72, -456},
    { -792, -232, -368},
    { -752, -32, -520},
    { -592, 56, -480},
    { -432, 72, -680},
    { -240, 8, -520},
    { 224, 1344, -1968},
    { -16, -1232, -680},
    { -616, 160, -744},
    { -752, 0, -792},
    { -768, 176, -704},
    { -728, 120, -696},
    { -816, -40, -1008},
    { -656, 48, -768},
    { -576, 48, -768},
    { -576, -80, -864},
    { -536, -64, -760},
    { -592, 24, -832},
    { -664, 16, -856},
    { -696, 64, -816},
    { -632, -40, -832},
    { -648, -24, -800},
    { -632, -40, -784},
    { -760, -248, -712},
    { -816, -280, -800},
    { -784, -16, -640},
    { -728, -96, -600},
    { -776, -128, -672},
    { -856, -64, -640},
    { -816, -8, -656},
    { -808, -16, -672},
    { -808, -24, -680},
    { -752, -48, -656},
    { -784, -40, -752},
    { -728, 0, -704},
    { -696, 88, -704},
    { -688, 120, -776},
    { -632, 144, -752},
    { -656, 176, -760},
    { -656, 168, -744},
    { -664, 208, -768},
    { -704, 200, -776},
    { -712, 216, -760},
    { -696, 200, -728},
    { -704, 192, -744},
    { -680, 144, -720},
    { -704, 200, -680},
    { -672, 160, -688},
    { -688, 168, -664},
    { -688, 208, -656},
    { -680, 216, -664},
    { -744, 296, -624},
    { -712, 272, -632},
    { -704, 296, -616},
    { -720, 320, -608},
    { -712, 344, -584},
    { -736, 400, -552},
    { -736, 496, -520},
    { -712, 280, -592},
    { -736, 408, -632},
    { -808, 536, -528},
    { -784, 488, -600},
    { -768, 472, -600},
    { -728, 472, -552},
    { -728, 496, -528},
    { -704, 496, -512},
    { -720, 440, -528},
    { -728, 528, -424},
    { -704, 432, -504},
    { -720, 504, -440},
    { -704, 520, -472},
    { -744, 552, -480},
    { -688, 568, -416},
    { -704, 608, -424},
    { -672, 632, -440},
    { -728, 640, -400},
    { -664, 672, -400},
    { -688, 688, -408},
    { -688, 696, -424},
    { -696, 688, -368},
    { -688, 696, -408},
    { -648, 672, -400},
    { -600, 664, -376},
    { -608, 640, -360},
    { -640, 680, -352},
    { -648, 664, -352},
    { -640, 688, -360},
    { -640, 720, -328},
    { -624, 680, -384},
    { -600, 696, -352},
    { -704, 760, -400},
    { -712, 776, -360},
    { -640, 672, -440},
    { -680, 696, -432},
    { -704, 624, -488},
    { -672, 632, -488},
    { -744, 648, -576},
    { -824, 608, -632},
    { -872, 536, -616},
    { -848, 504, -624},
    { -816, 544, -568},
    { -864, 480, -560},
    { -784, 456, -504},
    { -736, 400, -440},
    { -664, 376, -464},
    { -648, 216, -448},
    { -680, 112, -456},
    { -640, 8, -528},
    { -696, -112, -544},
    { -696, -168, -520},
    { -584, -216, -456},
    { -720, -280, -752},
    { -656, -280, -672},
    { -520, -320, -688},
    { -528, -280, -680},
    { -400, -280, -792},
    { -280, -336, -720},
    { -280, -280, -792},
    { -152, -392, -672},
    { -24, -304, -696},
    { 128, -600, -760},
    { 208, -536, -784},
    { 376, -872, -880},
    { 264, -1000, -1032},
    { 248, -1344, -816},
    { 320, -784, -1336},
    { 184, -536, 1960},
    { 232, -152, -1704},
    { -328, -520, -1504},
    { -312, -248, -536},
    { -416, -104, -368},
    { -320, 264, -160},
    { -504, 896, -456},
    { -864, 720, -208},
    { -1288, 1272, -336},
    { -1376, -104, -704},
    { -704, 632, -216},
    { -568, 768, -472},
    { -280, -192, -712},
    { -832, 312, -744},
    { -504, -24, -752},
    { -464, -248, -744},
    { -304, -416, -720},
    { -368, -416, -800},
    { -400, -368, -856},
    { -184, -680, -832},
    { -384, -440, -944},
    { -528, -624, -968},
    { -568, -576, -896},
    { -712, -328, -840},
    { -608, -400, -816},
    { -600, -352, -856},
    { -632, -256, -760},
    { -648, -208, -696},
    { -688, -56, -672},
    { -728, 48, -672},
    { -736, -112, -776},
    { -688, -104, -720},
    { -584, -192, -792},
    { -504, -232, -840},
    { -432, -280, -768},
    { -400, -352, -808},
    { -400, -440, -856},
    { -456, -368, -792},
    { -440, -488, -840},
    { -448, -368, -896},
    { -408, -592, -736},
    { -464, -496, -872},
    { -448, -656, -784},
    { -456, -560, -760},
    { -368, -608, -768},
    { -272, -600, -824},
    { -288, -608, -704},
    { -256, -672, -896},
    { -304, -600, -824},
    { -336, -736, -824},
    { -376, -680, -824},
    { -256, -664, -744},
    { -336, -824, -880},
    { -344, -648, -856},
    { -280, -616, -888},
    { -288, -680, -856},
    { -312, -504, -896},
    { -240, -472, -816},
    { -496, -496, -880},
    { -456, -768, -1064},
    { -192, -664, -776},
    { -280, -664, -752},
    { -128, -712, -840},
    { -200, -728, -840},
    { -24, -776, -768},
    { -8, -624, -784},
    { -96, -664, -720},
    { -120, -664, -656},
    { -96, -736, -808},
    { -144, -720, -752},
    { -216, -776, -848},
    { -224, -696, -840},
    { -352, -672, -888},
    { -336, -768, -856},
    { -400, -752, -872},
    { -368, -736, -920},
    { -312, -520, -896},
    { -448, -648, -912},
    { -584, -424, -752},
    { -376, -728, -872},
    { -544, -424, -728},
    { -400, -608, -976},
    { -200, -32, -712},
    { -136, -944, -992},
    { -432, 16, -736},
    { -488, -688, -872},
    { -528, -32, -776},
    { -536, -440, -1072},
    { -952, -256, -736},
    { -464, -584, -896},
    { -440, -200, -704},
    { -472, -144, -560},
    { -472, 208, -616},
    { -744, 320, -680},
    { -904, 360, -520},
    { -1088, 552, -568},
    { -968, 192, -904},
    { -904, 128, -784},
    { -832, 168, -648},
    { -696, 120, -752},
    { -712, 104, -720},
    { -648, 176, -680},
    { -608, 432, -336},
    { -368, -168, -704},
    { -416, -424, -808},
    { -224, -1096, -1352},
    { -152, -1520, -1208},
    { -352, -328, -608},
    { -624, -40, -1096},
    { -624, -640, -864},
    { -392, -352, -696},
    { -240, -272, -536},
    { -208, -160, -672},
    { -336, -24, -656},
    { -592, 64, -576},
    { -640, 88, -832},
    { -752, 104, -800},
    { -808, 168, -664},
    { -704, 104, -712},
    { -664, 264, -672},
    { -672, 312, -600},
    { -584, 296, -672},
    { -544, 624, -632},
    { -600, 904, -720},
    { -592, 592, -784},
    { -616, 688, -744},
    { -600, 768, -880},
    { -464, 728, -968},
    { -544, 736, -904},
    { -576, 560, -856},
    { -856, 792, -816},
    { -832, 752, -864},
    { -736, 664, -784},
    { -680, 480, -632},
    { -568, 352, -672},
    { -496, 152, -560},
    { -424, 56, -568},
    { -336, -136, -640},
    { -296, -320, -544},
    { -296, -416, -632},
    { -336, -504, -632},
    { -472, -584, -664},
    { -552, -488, -800},
    { -592, -360, -920},
    { -608, -344, -872},
    { -648, -352, -776},
    { -680, -336, -856},
    { -664, -256, -832},
    { -624, -272, -760},
    { -472, -288, -784},
    { -440, -344, -888},
    { -472, -424, -976},
    { -464, -144, -736},
    { -472, -232, -856},
    { -592, -368, -1008},
    { -600, -320, -976},
    { -504, -160, -720},
    { -528, -80, -792},
    { -520, -160, -840},
    { -448, -32, -960},
    { -464, -168, -896},
    { -400, -240, -824},
    { -272, -360, -880},
    { -200, -464, -976},
    { -208, -432, -1056},
    { -168, -336, -1008},
    { -144, -296, -1032},
    { -120, -288, -1056},
    { -112, -192, -992},
    { -104, -200, -1048},
    { -112, -232, -984},
    { -88, -184, -1048},
    { -72, -184, -1064},
    { -48, -176, -1048},
    { -24, -184, -1040},
    { -24, -184, -1056},
    { -24, -168, -1048},
    { -8, -184, -1048},
    { -16, -144, -1064},
    { 0, -144, -1040},
    { 24, -152, -1032},
    { 24, -136, -1032},
    { 32, -136, -1024},
    { 48, -128, -1016},
    { 48, -120, -1024},
    { 40, -144, -1024},
    { 40, -136, -1008},
    { 32, -136, -1024},
    { 24, -144, -1016},
    { 24, -144, -1024},
    { 16, -144, -1016},
    { 8, -144, -1024},
    { 8, -136, -1024},
    { 16, -168, -1016},
    { 16, -160, -1008},
    { 0, -168, -1000},
    { -16, -208, -976},
    { -48, -256, -992},
    { -64, -296, -1048},
    { -96, -320, -1064},
    { -128, -304, -1032},
    { -136, -288, -1000},
    { -136, -296, -984},
    { -128, -304, -944},
    { -136, -280, -936},
    { -128, -248, -944},
    { -104, -240, -944},
    { -112, -200, -976},
    { -88, -184, -1008},
    { -112, -184, -1008},
    { -120, -192, -1040},
    { -128, -184, -1048},
    { -128, -208, -1032},
    { -112, -200, -1040},
    { -104, -208, -1016},
    { -112, -216, -984},
    { -144, -200, -968},
    { -184, -200, -968},
    { -200, -168, -984},
    { -200, -160, -1000},
    { -176, -168, -1032},
    { -144, -176, -1032},
    { -104, -216, -1008},
    { -104, -232, -984},
    { -128, -232, -952},
    { -120, -216, -976},
    { -120, -224, -992},
    { -136, -216, -992},
    { -152, -176, -1008},
    { -128, -216, -1040},
    { -120, -256, -1048},
    { -152, -264, -1040},
    { -200, -264, -1024},
    { -232, -216, -1032},
    { -184, -192, -1032},
    { -136, -240, -1008},
    { -120, -272, -952},
    { -144, -264, -928},
    { -184, -264, -904},
    { -200, -272, -904},
    { -200, -256, -936},
    { -192, -280, -968},
    { -200, -312, -976},
    { -200, -328, -984},
    { -208, -320, -992},
    { -208, -312, -984},
    { -200, -304, -976},
    { -208, -296, -968},
    { -200, -304, -968},
    { -192, -296, -968},
    { -200, -304, -984},
    { -192, -320, -976},
    { -200, -312, -984},
    { -208, -336, -976},
    { -208, -336, -976},
    { -208, -328, -984},
    { -224, -336, -984},
    { -240, -344, -1000},
    { -256, -352, -1032},
    { -320, -392, -1056},
    { -392, -440, -1128},
    { -512, -472, -1224},
    { -616, -536, -1208},
    { -568, -528, -1056},
    { -568, -432, -872},
    { -496, -336, -712},
    { -368, -256, -680},
    { -208, -224, -672},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-28 17:07:07 local
AccelRawData *activity_sample_100_steps_heather_16(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_heather_16
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 105
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -184, -96, -1000},
    { -168, -200, -1016},
    { -72, -200, -1056},
    { -128, -160, -1040},
    { -136, -160, -1032},
    { -192, -16, -1048},
    { -96, -48, -1040},
    { -24, -128, -984},
    { -16, -120, -984},
    { -72, -88, -1024},
    { -64, -152, -960},
    { -64, -168, -1024},
    { -40, -128, -1040},
    { -56, -136, -1040},
    { -104, -96, -1016},
    { -96, -72, -1040},
    { -72, -112, -1000},
    { -72, -144, -1000},
    { -72, -128, -1008},
    { -64, -112, -1032},
    { -56, -112, -1024},
    { -96, -112, -1016},
    { -32, -120, -1032},
    { -32, -144, -1024},
    { -40, -136, -1008},
    // 1 seconds
    { -72, -96, -1016},
    { -96, -48, -1032},
    { -32, -120, -1008},
    { -72, -80, -1040},
    { 8, -152, -1032},
    { 40, -72, -1032},
    { 24, -224, -984},
    { 24, -72, -1040},
    { -104, 0, -1056},
    { -72, -120, -1008},
    { -48, -88, -1016},
    { -80, -64, -1048},
    { -72, -64, -1072},
    { -64, -104, -1048},
    { -72, -120, -1032},
    { -56, -160, -1008},
    { -16, -160, -1016},
    { -8, -136, -992},
    { -152, -280, -928},
    { -96, -136, -936},
    { -64, -144, -1000},
    { -96, -144, -1024},
    { 16, -104, -1080},
    { -136, -232, -1008},
    { 40, -120, -976},
    // 2 seconds
    { -80, -144, -880},
    { -112, -120, -864},
    { -120, -48, -928},
    { -64, -64, -984},
    { -88, -32, -1048},
    { -72, -72, -1064},
    { -56, -96, -1072},
    { -24, -144, -1072},
    { -64, -120, -1048},
    { -64, -80, -1080},
    { 64, -136, -984},
    { 256, -232, -744},
    { 600, 224, -816},
    { 952, 392, -920},
    { 1000, 472, -992},
    { 864, 400, -904},
    { 752, 368, -776},
    { 784, 336, -744},
    { 808, 232, -616},
    { 712, -112, -288},
    { 696, 72, 112},
    { 696, 328, 392},
    { 744, 432, 632},
    { 1000, 776, 728},
    { 1456, 1136, 728},
    // 3 seconds
    { 1656, 1216, 672},
    { 2216, 1528, 176},
    { 1432, 272, 504},
    { 1936, 984, 280},
    { 1000, -1360, 328},
    { 784, -728, 296},
    { 568, -104, -376},
    { 720, -400, -368},
    { 840, -376, -288},
    { 984, -512, -208},
    { 1304, -616, 184},
    { 1496, 272, 528},
    { 1136, 840, 728},
    { 1408, 672, 304},
    { 1840, 736, 400},
    { 2104, 776, -8},
    { 1784, 840, -736},
    { 1408, 96, -288},
    { 760, -984, 368},
    { 792, -664, -328},
    { 1272, -376, -360},
    { 1096, 24, -208},
    { 1032, 64, -320},
    { 1048, 160, -288},
    { 1040, 216, -64},
    // 4 seconds
    { 1120, 280, 0},
    { 1336, 352, -16},
    { 1352, 536, -8},
    { 1600, 632, -88},
    { 1360, 712, -80},
    { 1184, 712, -96},
    { 1160, 792, -192},
    { 992, 624, -216},
    { 1264, 552, -48},
    { 1608, 408, 176},
    { 1496, 184, 104},
    { 1328, 32, 104},
    { 1096, 96, 152},
    { 1160, 288, 104},
    { 1192, 320, 32},
    { 1192, 280, -32},
    { 1312, 176, 120},
    { 1184, 136, -24},
    { 928, -104, -128},
    { 968, -128, -32},
    { 1144, 128, -112},
    { 1088, 168, -256},
    { 1368, 112, -224},
    { 1392, 136, -240},
    { 1288, 176, -224},
    // 5 seconds
    { 1128, 288, -200},
    { 1136, 328, -32},
    { 1184, 368, -32},
    { 1216, 352, -80},
    { 1456, 504, 112},
    { 1288, 656, 96},
    { 1088, 768, -24},
    { 1384, 784, -160},
    { 1000, 600, -192},
    { 1312, 536, -8},
    { 1744, 472, 64},
    { 1808, 176, 64},
    { 1384, 8, 248},
    { 1088, -128, 72},
    { 1016, 24, 0},
    { 1000, 152, -56},
    { 1016, 208, -64},
    { 1208, 168, 16},
    { 1048, 152, -128},
    { 944, 56, -120},
    { 1184, 56, 0},
    { 1208, 144, -72},
    { 1408, 184, -32},
    { 1552, 208, -192},
    { 1168, 272, -288},
    // 6 seconds
    { 904, 264, -192},
    { 936, 256, -64},
    { 1072, 312, -16},
    { 1144, 384, -24},
    { 1336, 448, 24},
    { 1696, 648, -56},
    { 1248, 632, -232},
    { 1496, 712, -192},
    { 1400, 400, 264},
    { 1312, -640, 344},
    { 912, -848, 16},
    { 1168, 136, -216},
    { 704, -656, -24},
    { 800, -704, -224},
    { 832, -216, 240},
    { 816, 40, 232},
    { 872, 168, 488},
    { 1176, 528, 416},
    { 1280, 328, 680},
    { 1224, 256, 600},
    { 1160, 56, 384},
    { 1160, -8, 256},
    { 1112, 192, -32},
    { 1224, -144, -128},
    { 1240, -64, 168},
    // 7 seconds
    { 824, -24, 208},
    { 472, -240, 616},
    { 424, -128, 504},
    { 576, 112, 344},
    { 656, 464, 248},
    { 568, 840, 512},
    { 968, 1360, 176},
    { 1008, 416, 632},
    { 1144, 1008, 600},
    { 1256, 424, 768},
    { 1464, -264, 152},
    { 1136, -16, 344},
    { 792, 440, 752},
    { 608, 392, 576},
    { 456, 424, 144},
    { 472, 120, 168},
    { 504, 80, 280},
    { 600, 632, 312},
    { 808, 808, 648},
    { 976, 624, 760},
    { 1176, 728, 784},
    { 1024, 928, 376},
    { 1008, 840, 272},
    { 1064, 776, 64},
    { 1128, 600, -136},
    // 8 seconds
    { 1064, 296, -48},
    { 904, 312, -40},
    { 544, 352, 160},
    { 112, 632, 264},
    { 0, 632, 432},
    { -248, 816, 560},
    { -264, 752, 840},
    { -208, 960, 1120},
    { -40, 920, 1208},
    { 48, 1088, 1240},
    { 480, 952, 1272},
    { 984, 560, 1224},
    { 1192, 760, 624},
    { 792, 368, 888},
    { 952, 560, 680},
    { 816, 704, 424},
    { 632, 760, 200},
    { 456, 720, -72},
    { 632, 216, -272},
    { 288, 944, 416},
    { 264, 1184, 832},
    { 280, 992, 936},
    { 224, 880, 1200},
    { 408, 744, 1304},
    { 512, 168, 952},
    // 9 seconds
    { 600, 296, 808},
    { 512, 488, 840},
    { 112, 216, 664},
    { 168, 616, 456},
    { 168, 464, 776},
    { 272, 592, 560},
    { -8, 752, 920},
    { 552, 784, 568},
    { 480, 776, 1336},
    { 296, 752, 1112},
    { 416, 840, 1104},
    { 376, 768, 1096},
    { 336, 656, 720},
    { 288, 536, 520},
    { 264, 560, 392},
    { 184, 344, 400},
    { 168, 136, 360},
    { 112, 472, 96},
    { 288, 1336, 72},
    { 424, 1440, 488},
    { 568, 1144, 952},
    { 376, 1192, 432},
    { 456, 1264, 224},
    { 624, 1216, 408},
    { 504, 976, 416},
    // 10 seconds
    { 360, 792, 328},
    { 120, 800, 80},
    { -56, 712, -144},
    { -64, 624, 72},
    { -112, 720, 0},
    { 24, 864, -224},
    { 104, 1072, -424},
    { 88, 1152, -216},
    { 184, 1504, -264},
    { 128, 1584, -224},
    { 248, 1360, 312},
    { 200, 1288, 320},
    { 248, 936, 488},
    { -8, 848, 392},
    { -16, 784, 128},
    { -72, 624, -24},
    { -128, 384, -56},
    { -240, 160, 24},
    { -88, 776, 184},
    { 408, 1424, -24},
    { 544, 1776, 120},
    { 616, 1536, -88},
    { 408, 1528, -48},
    { 632, 1672, 152},
    { 888, 1240, 504},
    // 11 seconds
    { 1280, 512, 472},
    { 808, 840, 360},
    { 720, 1056, -168},
    { -64, 600, 368},
    { -720, 384, 536},
    { -992, 256, 128},
    { -152, 912, -888},
    { 296, 912, -664},
    { 472, 704, -144},
    { 544, 1072, 472},
    { 272, 1680, 688},
    { 400, 1872, 128},
    { 880, 1328, 56},
    { 1848, -88, -408},
    { 1656, 648, -336},
    { 1416, 912, -336},
    { 1000, 744, -304},
    { 992, 464, -352},
    { 1096, 280, -320},
    { 1096, 184, -328},
    { 1024, 72, -240},
    { 1072, 32, -248},
    { 952, 8, -264},
    { 1088, 48, -24},
    { 1224, 168, 72},
    // 12 seconds
    { 1352, 336, -104},
    { 1472, 344, -152},
    { 1336, 272, -64},
    { 1176, 280, -96},
    { 1128, 280, -48},
    { 1224, 328, 64},
    { 1392, 408, 192},
    { 1392, 512, 168},
    { 1520, 520, 104},
    { 1464, 656, 152},
    { 1112, 1048, -104},
    { 1160, 1280, -192},
    { 928, 816, -80},
    { 984, 576, 24},
    { 1416, 448, 152},
    { 1608, 320, 8},
    { 1392, 216, -56},
    { 1416, 248, 48},
    { 1336, 136, 112},
    { 1344, 304, 0},
    { 1304, 256, 80},
    { 1440, 168, 88},
    { 1448, 136, 32},
    { 1144, -152, 80},
    { 1216, -336, 272},
    // 13 seconds
    { 1432, 64, -168},
    { 1264, 64, -88},
    { 1304, 128, -192},
    { 1096, 184, -216},
    { 1080, 184, -168},
    { 1176, 240, 16},
    { 1376, 336, 120},
    { 1576, 536, 240},
    { 1568, 688, 80},
    { 1400, 824, 128},
    { 936, 984, 56},
    { 1232, 848, -16},
    { 896, 720, -24},
    { 1208, 592, 64},
    { 1640, 616, 176},
    { 1696, 472, 48},
    { 1496, 248, 72},
    { 1456, 32, 120},
    { 1400, 80, 88},
    { 1296, 112, 56},
    { 1208, 152, -16},
    { 1312, 128, -16},
    { 1064, -48, -16},
    { 840, -208, -56},
    { 1232, 32, -80},
    // 14 seconds
    { 1264, 144, -152},
    { 1512, 136, -16},
    { 1744, 152, -144},
    { 1400, 264, -248},
    { 1080, 328, -160},
    { 976, 344, -32},
    { 1080, 360, 88},
    { 1328, 376, -8},
    { 1488, 472, 48},
    { 1440, 712, 184},
    { 1016, 968, 80},
    { 1328, 992, -96},
    { 960, 664, -96},
    { 1104, 536, -48},
    { 1552, 600, 128},
    { 1584, 472, 48},
    { 1400, 168, 40},
    { 1280, 32, 64},
    { 1336, 32, 40},
    { 1288, 136, -8},
    { 1192, 200, 8},
    { 1328, 120, -24},
    { 1096, 8, -80},
    { 944, -128, 8},
    { 1160, -48, 64},
    // 15 seconds
    { 1368, 176, -160},
    { 1456, 184, -136},
    { 1608, 144, -208},
    { 1304, 216, -368},
    { 984, 224, -168},
    { 968, 288, -120},
    { 1032, 368, -24},
    { 1240, 456, -80},
    { 1352, 464, -16},
    { 1584, 608, 40},
    { 1048, 744, 40},
    { 1280, 752, -48},
    { 1072, 776, -160},
    { 1144, 488, -128},
    { 1416, 536, 64},
    { 1696, 480, 112},
    { 1496, 160, 80},
    { 1256, 16, 56},
    { 1104, 16, 32},
    { 1024, 80, -24},
    { 944, 176, -56},
    { 1056, 144, 32},
    { 1352, 184, -32},
    { 1048, 136, -72},
    { 1256, 64, -16},
    // 16 seconds
    { 1264, 120, -24},
    { 1192, 168, -120},
    { 1456, 160, -128},
    { 1552, 248, -304},
    { 1208, 336, -328},
    { 960, 280, -256},
    { 952, 352, -152},
    { 952, 376, -160},
    { 1112, 288, -144},
    { 1344, 384, 24},
    { 1376, 616, 88},
    { 1096, 688, 56},
    { 1496, 680, -240},
    { 1024, 624, -264},
    { 1128, 552, -24},
    { 1600, 472, 136},
    { 1528, 152, 136},
    { 1160, 24, 24},
    { 992, -24, 40},
    { 936, 80, 24},
    { 944, 176, -72},
    { 976, 208, -40},
    { 1272, 160, 48},
    { 1256, 144, -104},
    { 1264, -56, 40},
    // 17 seconds
    { 1320, -80, 152},
    { 1488, 160, -128},
    { 1528, 184, -144},
    { 1472, 168, -360},
    { 1048, 224, -448},
    { 832, 96, -112},
    { 848, 168, -40},
    { 984, 312, 0},
    { 1176, 472, -48},
    { 1336, 568, -56},
    { 1392, 632, 40},
    { 960, 640, -16},
    { 1216, 592, -128},
    { 1168, 672, -128},
    { 1208, 600, -104},
    { 1480, 560, 120},
    { 1576, 400, 136},
    { 1328, 152, 88},
    { 1168, 40, 72},
    { 1152, 64, 120},
    { 1152, 144, -16},
    { 1104, 208, -48},
    { 1144, 120, 48},
    { 1304, 144, -112},
    { 944, 8, -96},
    // 18 seconds
    { 1208, 0, -88},
    { 1376, 72, -160},
    { 1472, 144, -248},
    { 1536, 176, -336},
    { 1256, 184, -416},
    { 904, 224, -248},
    { 776, 288, -96},
    { 880, 328, -104},
    { 1072, 440, -72},
    { 1248, 440, -72},
    { 1432, 472, -24},
    { 1336, 560, 80},
    { 1088, 680, -104},
    { 1288, 720, -184},
    { 1008, 632, -192},
    { 1088, 600, -144},
    { 1408, 496, -56},
    { 1416, 352, -40},
    { 1248, 160, 24},
    { 1136, 72, 0},
    { 1120, 136, -64},
    { 1104, 144, 8},
    { 1040, 128, -24},
    { 1208, 144, 8},
    { 1304, 104, -56},
    // 19 seconds
    { 1176, -160, 104},
    { 1256, -256, 120},
    { 1352, 128, -120},
    { 1408, 272, -264},
    { 1488, 272, -416},
    { 1288, 88, -440},
    { 976, 24, -352},
    { 848, 192, -192},
    { 872, 368, -176},
    { 880, 496, -24},
    { 1040, 504, -136},
    { 1240, 472, -120},
    { 1376, 552, 48},
    { 1096, 560, -136},
    { 1320, 584, -168},
    { 1224, 664, -240},
    { 1248, 560, -272},
    { 1472, 568, -136},
    { 1560, 400, 8},
    { 1328, 208, 16},
    { 1176, 40, 8},
    { 1112, 64, 24},
    { 1032, 48, -104},
    { 920, 112, -72},
    { 904, 72, -72},
    // 20 seconds
    { 1072, 104, -40},
    { 944, 48, -192},
    { 1096, 48, -248},
    { 1360, 80, -200},
    { 1456, 64, -392},
    { 1536, 56, -560},
    { 1312, 80, -656},
    { 960, 96, -568},
    { 776, 152, -392},
    { 768, 200, -352},
    { 872, 224, -360},
    { 960, 240, -208},
    { 1024, 272, -224},
    { 1408, 360, -160},
    { 1144, 416, -88},
    { 1520, 656, -232},
    { 1296, 792, -416},
    { 1096, 624, -432},
    { 1392, 592, -424},
    { 1520, 504, -136},
    { 1304, 128, 8},
    { 1056, 0, 64},
    { 976, 16, -112},
    { 928, 72, -120},
    { 904, 88, -112},
    // 21 seconds
    { 1104, 144, -112},
    { 1264, 128, -24},
    { 1088, 128, -160},
    { 1336, 120, -16},
    { 1312, 152, -256},
    { 1184, -8, -344},
    { 1280, -88, -456},
    { 1128, 40, -328},
    { 840, 112, -368},
    { 712, 176, -280},
    { 736, 224, -208},
    { 880, 256, -168},
    { 968, 248, -240},
    { 1168, 264, -200},
    { 1616, 416, -256},
    { 1184, 448, -144},
    { 1272, 488, -120},
    { 1384, 640, -344},
    { 936, 536, -312},
    { 1184, 512, -160},
    { 1472, 416, -144},
    { 1208, 256, -120},
    { 1008, 88, -8},
    { 992, 144, -104},
    { 1032, 136, -48},
    // 22 seconds
    { 1000, 136, -48},
    { 960, 88, -72},
    { 1152, 72, -48},
    { 1232, 152, -120},
    { 1096, 88, -160},
    { 1192, 112, -280},
    { 1272, 96, -448},
    { 1232, 24, -480},
    { 1256, -40, -280},
    { 984, -16, -280},
    { 680, -16, -16},
    { 672, 136, -216},
    { 728, 248, -200},
    { 832, 232, -136},
    { 896, 248, -160},
    { 1128, 248, -144},
    { 1608, 304, -120},
    { 1464, 432, -168},
    { 1552, 744, -216},
    { 1040, 536, -536},
    { 1048, 528, -224},
    { 1352, 432, -200},
    { 1336, 248, -176},
    { 1056, 176, -72},
    { 952, 104, -64},
    // 23 seconds
    { 920, 112, -32},
    { 920, 120, -56},
    { 912, 128, -48},
    { 1184, 120, -24},
    { 1528, 144, -40},
    { 1280, 88, 40},
    { 1232, 56, 48},
    { 1256, 192, -152},
    { 1048, 216, -336},
    { 1200, 120, -296},
    { 1104, 152, -216},
    { 832, 136, -144},
    { 680, 256, -160},
    { 784, 304, -120},
    { 928, 312, -144},
    { 1008, 352, -264},
    { 1240, 368, -232},
    { 1472, 392, -168},
    { 1064, 456, -160},
    { 1288, 528, -136},
    { 1328, 616, -328},
    { 1208, 440, -160},
    { 1408, 440, 0},
    { 1504, 240, 24},
    { 1120, 112, -48},
    // 24 seconds
    { 944, 80, -48},
    { 936, 104, -32},
    { 960, 168, -48},
    { 1024, 184, -40},
    { 1088, 176, 8},
    { 1312, 160, -8},
    { 1072, 152, -80},
    { 1208, 128, -112},
    { 1208, 136, -40},
    { 1072, 176, -160},
    { 1272, 200, -272},
    { 1352, 232, -400},
    { 952, 216, -352},
    { 704, 152, -264},
    { 816, 216, -184},
    { 976, 296, -136},
    { 1112, 344, -184},
    { 1112, 416, -168},
    { 1496, 464, -56},
    { 1216, 568, -56},
    { 1008, 600, -64},
    { 1384, 608, -224},
    { 1088, 712, -248},
    { 1392, 776, 8},
    { 1824, 736, 248},
    // 25 seconds
    { 1632, 272, 312},
    { 1360, 248, -8},
    { 1256, 600, -32},
    { 1144, 840, 40},
    { 968, 664, -112},
    { 840, 688, -280},
    { 856, 552, -440},
    { 864, 336, -592},
    { 632, -48, -584},
    { 560, -400, -728},
    { 592, -392, -1056},
    { 768, -560, -776},
    { 600, -136, -608},
    { 264, -104, -704},
    { 184, 56, -720},
    { -200, 256, -1032},
    { 368, 1472, -1280},
    { 512, -784, -1824},
    { 8, -368, -1040},
    { 32, -288, -904},
    { -120, -224, -1224},
    { -344, -184, -1280},
    { -272, -272, -1336},
    { -80, -208, -1248},
    { -64, 200, -1336},
    // 26 seconds
    { -200, 176, -992},
    { -136, 72, -856},
    { 8, -184, -760},
    { 8, -72, -704},
    { -112, -168, -696},
    { -120, -56, -704},
    { -136, -224, -832},
    { -216, -344, -944},
    { -168, -360, -1088},
    { -216, -344, -1184},
    { -208, -192, -1288},
    { -32, -160, -1472},
    { -232, 24, -1256},
    { -264, -640, -568},
    { 96, 920, -1072},
    { -64, 800, -800},
    { -160, 192, -632},
    { -192, 120, -624},
    { -208, 72, -720},
    { -224, -16, -864},
    { -320, 16, -960},
    { -464, 8, -984},
    { -432, -88, -1040},
    { -576, -48, -1024},
    { -560, 56, -1064},
    // 27 seconds
    { -424, 72, -1120},
    { -424, 168, -1064},
    { -408, 96, -880},
    { -280, 112, -896},
    { -136, 32, -832},
    { -96, -56, -712},
    { -152, -120, -688},
    { -208, -184, -696},
    { -216, -240, -712},
    { -224, -296, -632},
    { -136, -408, -496},
    { 256, -480, -368},
    { 816, -144, -288},
    { 1552, 376, -216},
    { 2160, 664, -240},
    { 2184, 456, -408},
    { 2280, 328, -520},
    { 1952, 392, -160},
    { 1504, 416, -144},
    { 1320, 368, -64},
    { 1312, 336, 32},
    { 1232, 360, -32},
    { 1080, 464, -184},
    { 1056, 504, -208},
    { 1376, 704, -16},
    // 28 seconds
    { 912, 984, -96},
    { 1096, 704, -384},
    { 1184, 528, -160},
    { 1112, 600, -256},
    { 1440, 560, -152},
    { 1912, 544, -48},
    { 1952, 336, -16},
    { 1848, 56, 16},
    { 1640, -112, 8},
    { 1456, -16, -32},
    { 1272, 104, -96},
    { 1048, 88, -128},
    { 976, 104, -96},
    { 976, 64, -136},
    { 624, -104, -200},
    { 704, -88, -168},
    { 1104, 64, -104},
    { 1288, 72, -232},
    { 1808, 80, -168},
    { 1976, 208, -392},
    { 1448, 296, -392},
    { 1136, 424, -344},
    { 1112, 184, -112},
    { 1152, 168, -96},
    { 1184, 264, -112},
    // 29 seconds
    { 1144, 384, -64},
    { 1512, 576, 32},
    { 1112, 840, 264},
    { 1040, 856, -224},
    { 1320, 664, -112},
    { 976, 608, -152},
    { 1144, 512, -128},
    { 1624, 616, -48},
    { 1952, 576, -136},
    { 1840, 304, 128},
    { 1656, -200, 128},
    { 1336, -216, 0},
    { 1136, 0, -64},
    { 968, 56, -56},
    { 816, 136, -72},
    { 920, 176, -80},
    { 816, 128, -240},
    { 816, 48, -184},
    { 1136, -48, -16},
    { 1352, 8, -168},
    { 1648, 72, -264},
    { 1688, 168, -312},
    { 1392, 240, -416},
    { 1192, 304, -392},
    { 1048, 248, -168},
    // 30 seconds
    { 1096, 264, -72},
    { 1120, 312, -104},
    { 1016, 328, -80},
    { 1064, 368, -72},
    { 1472, 472, -88},
    { 1040, 784, -64},
    { 1112, 680, -264},
    { 1512, 632, -176},
    { 1072, 488, -272},
    { 1328, 440, -224},
    { 1448, 456, -232},
    { 1416, 384, -192},
    { 1448, 224, -56},
    { 1496, 64, -16},
    { 1360, -16, 48},
    { 1192, 40, -96},
    { 1024, 8, -64},
    { 824, 72, -56},
    { 1000, 64, -80},
    { 880, 24, -88},
    { 896, 0, -112},
    { 1280, -24, -88},
    { 1248, 56, -208},
    { 1456, 64, -224},
    { 1680, 184, -352},
    // 31 seconds
    { 1224, 256, -376},
    { 1048, 112, -168},
    { 944, 208, -328},
    { 1064, 224, -256},
    { 1120, 240, -256},
    { 960, 328, -232},
    { 1176, 320, -176},
    { 1304, 480, -272},
    { 936, 496, -360},
    { 1416, 376, -408},
    { 1400, 312, -448},
    { 1328, 352, -384},
    { 1640, 384, -208},
    { 1768, 152, 0},
    { 1240, 8, -16},
    { 1040, 64, -72},
    { 1000, 144, -72},
    { 1048, 168, -72},
    { 1048, 56, 8},
    { 896, 96, -56},
    { 880, 48, -56},
    { 960, -16, -136},
    { 744, 40, -304},
    { 1008, -48, -344},
    { 1344, -120, -176},
    // 32 seconds
    { 1656, 0, -320},
    { 1888, 40, -416},
    { 1440, 80, -600},
    { 808, -16, -480},
    { 720, -24, -320},
    { 872, 104, -320},
    { 960, 200, -224},
    { 976, 248, -208},
    { 1008, 312, -208},
    { 1288, 328, -208},
    { 1456, 408, -168},
    { 1048, 576, -328},
    { 1224, 712, -288},
    { 1584, 792, -368},
    { 1224, 552, -464},
    { 1952, 344, -200},
    { 2008, 240, -144},
    { 1824, 152, 56},
    { 1560, 88, -16},
    { 1400, 72, 0},
    { 1184, 24, -64},
    { 1064, 48, -72},
    { 960, 48, -16},
    { 1000, 112, 0},
    { 1024, 64, -64},
    // 33 seconds
    { 968, 32, 16},
    { 1096, 208, 56},
    { 1344, 96, -200},
    { 1488, 168, -264},
    { 1832, 224, -576},
    { 1344, 336, -552},
    { 864, 136, -296},
    { 960, -112, -216},
    { 1120, 72, -272},
    { 1200, 136, -400},
    { 1192, 312, -456},
    { 1080, 296, -400},
    { 1448, 376, -280},
    { 1552, 512, -288},
    { 1328, 440, -264},
    { 1072, 512, -368},
    { 968, 536, -320},
    { 1168, 384, -192},
    { 1392, 256, -104},
    { 1408, 144, -56},
    { 1240, 144, -56},
    { 1128, 160, -48},
    { 1072, 192, -72},
    { 1024, 176, -64},
    { 960, 56, -128},
    // 34 seconds
    { 960, 32, -96},
    { 1240, -32, -72},
    { 1264, 8, -192},
    { 1208, -176, -168},
    { 1416, 56, -408},
    { 1360, -24, -352},
    { 1288, -8, -392},
    { 1104, -48, -328},
    { 960, -32, -568},
    { 720, -344, -744},
    { 800, -168, -168},
    { 872, 144, -24},
    { 960, 448, -152},
    { 1208, 536, -328},
    { 1344, 448, -256},
    { 1416, 368, -80},
    { 1256, 416, 32},
    { 1128, 520, -24},
    { 960, 720, -288},
    { 888, 608, -168},
    { 1088, 520, 32},
    { 1328, 480, 104},
    { 1296, 288, 8},
    { 1248, 72, -16},
    { 1208, 24, -56},
    // 35 seconds
    { 1232, 48, -168},
    { 1160, 104, -240},
    { 1056, 80, -168},
    { 1280, 32, -104},
    { 1312, 48, -320},
    { 1248, 24, -360},
    { 1272, -24, -160},
    { 1272, 24, -168},
    { 1168, 64, -200},
    { 1168, 104, -160},
    { 1064, 112, -272},
    { 824, 144, -352},
    { 808, 192, -224},
    { 848, 192, -152},
    { 1056, 224, -144},
    { 1144, 264, -216},
    { 1176, 296, -192},
    { 1536, 384, -48},
    { 1256, 728, 176},
    { 1296, 928, -376},
    { 1152, 352, -192},
    { 952, 560, -296},
    { 1184, 584, -120},
    { 1536, 448, -64},
    { 1616, 272, -176},
    // 36 seconds
    { 1472, 184, 0},
    { 1016, -8, 16},
    { 1088, 0, -72},
    { 976, 24, -72},
    { 928, 200, -128},
    { 1064, 168, -56},
    { 1264, 144, -104},
    { 1056, 104, -136},
    { 1280, 40, -16},
    { 1368, 128, -32},
    { 1288, 168, -168},
    { 1336, 136, -136},
    { 1168, 192, -336},
    { 992, 288, -312},
    { 912, 216, -184},
    { 952, 288, -96},
    { 1120, 344, -112},
    { 1160, 392, -200},
    { 1272, 424, -136},
    { 1344, 536, -128},
    { 1048, 656, -208},
    { 1312, 600, -264},
    { 1152, 552, -312},
    { 1240, 496, -264},
    { 1592, 536, -200},
    // 37 seconds
    { 1768, 496, -112},
    { 1752, 504, -32},
    { 1832, 224, 96},
    { 1752, 248, -136},
    { 1432, 248, -184},
    { 1024, 304, -400},
    { 752, 288, -528},
    { 496, 184, -528},
    { 376, 160, -520},
    { 176, -72, -600},
    { 56, -184, -720},
    { 152, -16, -944},
    { 224, -48, -928},
    { 232, 0, -984},
    { 136, -24, -960},
    { -64, -128, -816},
    { -120, -48, -840},
    { -128, 88, -888},
    { -64, 112, -952},
    { -32, 48, -1024},
    { -120, -80, -1056},
    { -24, 160, -1208},
    { -352, 128, -1176},
    { -176, -16, -1224},
    { -40, 528, -1160},
    // 38 seconds
    { -360, 576, -1008},
    { -312, 960, -888},
    { -216, 664, -896},
    { -8, 208, -672},
    { -32, 152, -624},
    { -232, 416, -912},
    { -168, 304, -992},
    { -248, 288, -1056},
    { -272, 384, -816},
    { 8, 336, -832},
    { -144, -136, -816},
    { 120, -152, -544},
    { 536, 72, -40},
    { 1240, 408, -40},
    { 2248, 1240, -184},
    { 2312, 816, 96},
    { 2360, 584, 320},
    { 2168, 608, 48},
    { 1960, 736, 80},
    { 1704, 704, 392},
    { 1616, 536, 240},
    { 1408, 464, 24},
    { 1560, 800, 88},
    { 936, 1456, 216},
    { 920, 1040, -32},
    // 39 seconds
    { 1096, 976, 96},
    { 1080, 784, -176},
    { 1480, 728, -56},
    { 2040, 728, -56},
    { 2064, 664, -56},
    { 2168, 352, 56},
    { 1952, 0, 112},
    { 1600, 64, -8},
    { 1416, 152, -112},
    { 1192, 88, 24},
    { 1120, 112, 72},
    { 968, -8, 8},
    { 664, -144, -128},
    { 896, -120, -56},
    { 1328, 56, -56},
    { 1568, 104, -128},
    { 2192, 40, -264},
    { 2192, 192, -520},
    { 1544, 408, -520},
    { 1304, 528, -256},
    { 1392, 312, -424},
    { 1552, 360, -184},
    { 1264, 400, -152},
    { 1528, 504, -104},
    { 1200, 728, 136},
    // 40 seconds
    { 1088, 1136, -200},
    { 1056, 944, -224},
    { 1128, 768, -288},
    { 1456, 648, -168},
    { 2040, 592, -136},
    { 2024, 344, 56},
    { 1664, -72, 456},
    { 1376, 16, -56},
    { 1232, 136, -72},
    { 1080, 112, -56},
    { 1008, 128, -8},
    { 1272, 160, 24},
    { 1256, 160, 56},
    { 1088, 216, -104},
    { 1224, 184, -224},
    { 1296, 192, -200},
    { 1280, 96, -336},
    { 1288, 56, -264},
    { 1224, 40, -384},
    { 984, 88, -424},
    { 968, 312, -488},
    { 1056, 184, -480},
    { 1104, 352, -432},
    { 1208, 256, -352},
    { 1328, 296, -392},
    // 41 seconds
    { 1448, 328, -328},
    { 1248, 392, -248},
    { 1120, 424, -256},
    { 1088, 528, -392},
    { 920, 568, -440},
    { 1064, 520, -312},
    { 1368, 424, -96},
    { 1480, 280, -16},
    { 1328, 176, -48},
    { 1216, 168, -64},
    { 1120, 160, -88},
    { 1032, 144, -112},
    { 1008, 144, -96},
    { 880, 120, -80},
    { 1088, 136, -56},
    { 1248, 176, -176},
    { 1112, 176, -264},
    { 1272, 80, -288},
    { 1272, 8, -144},
    { 1200, 0, -264},
    { 1336, 120, -352},
    { 1344, 216, -520},
    { 1024, 232, -424},
    { 848, 184, -184},
    { 928, 256, -184},
    // 42 seconds
    { 984, 280, -32},
    { 1128, 448, -296},
    { 1000, 432, -248},
    { 1352, 416, -160},
    { 1128, 504, -104},
    { 1312, 560, -264},
    { 1232, 616, -440},
    { 1056, 520, -288},
    { 1288, 536, -112},
    { 1720, 408, -80},
    { 1552, 144, -56},
    { 1328, 32, -72},
    { 1168, 24, -72},
    { 1080, 104, -72},
    { 1072, 160, -152},
    { 992, 168, -104},
    { 1144, 128, -72},
    { 1096, 112, -216},
    { 984, 48, -184},
    { 1128, 24, -48},
    { 1272, 152, -240},
    { 1280, 176, -248},
    { 1608, 184, -400},
    { 1288, 256, -440},
    { 872, 208, -288},
    // 43 seconds
    { 856, 184, -216},
    { 960, 272, -152},
    { 1128, 336, -152},
    { 1184, 368, -224},
    { 1320, 496, -240},
    { 1296, 592, -160},
    { 944, 776, -128},
    { 1312, 744, -368},
    { 1160, 560, -280},
    { 1216, 504, -248},
    { 1624, 568, -136},
    { 1720, 416, -144},
    { 1504, 40, 0},
    { 1208, -112, 0},
    { 1112, 24, -88},
    { 1056, 112, -160},
    { 928, 200, -136},
    { 880, 184, -80},
    { 1112, 128, -160},
    { 968, 24, -232},
    { 1096, -88, 56},
    { 1544, 32, -72},
    { 1616, 200, -304},
    { 1680, 160, -280},
    { 1400, 192, -528},
    // 44 seconds
    { 984, 248, -360},
    { 920, 256, -160},
    { 1064, 176, -128},
    { 1112, 376, -176},
    { 1144, 264, -240},
    { 1200, 464, -56},
    { 1400, 1056, -136},
    { 832, 880, -304},
    { 1296, 536, -96},
    { 1328, 776, -152},
    { 1240, 520, -224},
    { 1440, 592, -56},
    { 1760, 544, 64},
    { 1552, 352, 16},
    { 1400, 96, 16},
    { 1336, -8, -64},
    { 1264, 40, -152},
    { 1088, 0, -272},
    { 944, -32, -216},
    { 1040, -72, -256},
    { 768, -88, -360},
    { 760, -88, -336},
    { 1104, -72, -224},
    { 1424, 24, -320},
    { 1648, 80, -264},
    // 45 seconds
    { 1792, 168, -448},
    { 1392, 400, -472},
    { 984, 360, -208},
    { 880, 336, -200},
    { 1088, 328, -216},
    { 1184, 352, -136},
    { 1168, 368, -168},
    { 1576, 432, -64},
    { 1248, 648, 0},
    { 1272, 952, -168},
    { 1112, 872, -208},
    { 944, 736, -320},
    { 1208, 632, -272},
    { 1688, 608, -320},
    { 1640, 520, -40},
    { 1600, -64, 192},
    { 1216, -280, 112},
    { 1184, 64, -160},
    { 1144, 224, -168},
    { 1032, 152, -136},
    { 1160, 144, -120},
    { 1096, 112, -208},
    { 936, 16, -168},
    { 904, -160, 48},
    { 1184, -48, -192},
    // 46 seconds
    { 1488, 176, -288},
    { 1648, 104, -8},
    { 1424, 80, -408},
    { 1080, -40, -344},
    { 984, 176, -328},
    { 1008, 184, -264},
    { 1048, 216, -184},
    { 1048, 360, -224},
    { 1200, 448, -216},
    { 1536, 512, -200},
    { 1152, 744, 48},
    { 1464, 944, -488},
    { 1112, 432, -336},
    { 1032, 480, -192},
    { 1456, 480, -168},
    { 1616, 248, -168},
    { 1344, 152, -112},
    { 1160, 80, -48},
    { 1096, 96, -88},
    { 1040, 136, -48},
    { 936, 136, -40},
    { 880, 128, 16},
    { 1144, 152, 8},
    { 1048, 200, -72},
    { 1200, 160, -136},
    // 47 seconds
    { 1408, 64, -56},
    { 1448, 72, -288},
    { 1440, 32, -328},
    { 1392, 64, -512},
    { 1192, -56, -504},
    { 816, 496, -512},
    { 832, 144, -256},
    { 976, 336, -280},
    { 984, 328, -224},
    { 1072, 344, -208},
    { 1496, 368, -216},
    { 1144, 400, -192},
    { 1192, 528, -208},
    { 1256, 696, -488},
    { 1168, 624, -432},
    { 1408, 472, -344},
    { 1672, 408, -248},
    { 1528, 232, -56},
    { 1224, 88, 24},
    { 1024, 32, 16},
    { 848, 504, -152},
    { 928, 152, -56},
    { 896, 136, 32},
    { 1184, 176, -8},
    { 1224, 192, -32},
    // 48 seconds
    { 1160, 184, -64},
    { 1248, 208, -120},
    { 1376, 104, -160},
    { 1400, 248, -408},
    { 1376, 184, -392},
    { 1160, 152, -616},
    { 824, 128, -616},
    { 712, 120, -480},
    { 760, 200, -360},
    { 896, 304, -352},
    { 968, 368, -392},
    { 1440, 448, -280},
    { 1360, 528, -184},
    { 1192, 504, -248},
    { 1464, 576, -392},
    { 1104, 416, -376},
    { 1032, 392, -432},
    { 1576, 456, -480},
    { 1552, 216, -104},
    { 1208, -200, 104},
    { 808, 224, -8},
    { 816, 80, -120},
    { 904, 144, -128},
    { 920, 184, -128},
    { 1080, 160, -88},
    // 49 seconds
    { 1344, 144, -152},
    { 1048, 160, -152},
    { 1312, 224, -128},
    { 1400, 216, -136},
    { 1224, 144, -288},
    { 1256, 128, -368},
    { 1176, 144, -608},
    { 792, 296, -592},
    { 664, 72, -384},
    { 744, 184, -272},
    { 888, 256, -296},
    { 944, 296, -360},
    { 1120, 256, -360},
    { 1504, 368, -344},
    { 1208, 392, -352},
    { 1312, 408, -464},
    { 1336, 480, -504},
    { 1096, 344, -432},
    { 1272, 392, -360},
    { 1368, 160, 8},
    { 1016, 232, -80},
    { 960, 136, -200},
    { 1016, 64, -128},
    { 1152, 160, -128},
    { 1120, 104, -96},
    // 50 seconds
    { 952, 112, -96},
    { 1224, 120, -192},
    { 1024, 48, -256},
    { 1224, 8, -224},
    { 1336, 40, -184},
    { 1256, 104, -288},
    { 1296, 64, -384},
    { 1240, 216, -448},
    { 912, 200, -408},
    { 728, 200, -296},
    { 760, 184, -296},
    { 824, 208, -248},
    { 904, 240, -224},
    { 912, 272, -256},
    { 1320, 256, -304},
    { 1344, 376, -240},
    { 1280, 456, -240},
    { 1368, 568, -440},
    { 976, 600, -472},
    { 1000, 504, -416},
    { 1328, 400, -360},
    { 1256, 232, -224},
    { 1032, 112, -112},
    { 992, 88, -152},
    { 944, 128, -168},
    // 51 seconds
    { 936, 144, -112},
    { 888, 120, -112},
    { 1120, 136, -144},
    { 1352, 128, -160},
    { 1296, 88, -224},
    { 1408, 32, -160},
    { 1416, 128, -168},
    { 1176, 128, -400},
    { 1176, 136, -656},
    { 976, 56, -608},
    { 664, -32, -320},
    { 672, 88, -256},
    { 712, 288, -280},
    { 912, 304, -224},
    { 976, 272, -168},
    { 1080, 328, -256},
    { 1416, 336, -304},
    { 1144, 384, -280},
    { 1256, 488, -360},
    { 1184, 504, -488},
    { 1064, 496, -528},
    { 1232, 440, -416},
    { 1344, 344, -224},
    { 1136, 280, -248},
    { 1072, 176, -200},
    // 52 seconds
    { 1120, 88, -144},
    { 1064, 96, -112},
    { 1008, 56, -176},
    { 872, 16, -136},
    { 1056, 24, -208},
    { 1256, 16, -264},
    { 1080, -24, -392},
    { 1240, 112, -344},
    { 1344, 48, -368},
    { 1200, 32, -376},
    { 1320, 176, -408},
    { 1168, 216, -352},
    { 840, 224, -280},
    { 744, 312, -280},
    { 728, 296, -216},
    { 864, 264, -160},
    { 896, 240, -224},
    { 936, 168, -288},
    { 1432, 248, -368},
    { 1168, 320, -408},
    { 1320, 424, -544},
    { 1328, 520, -648},
    { 1096, 376, -632},
    { 1456, 328, -544},
    { 1704, 352, -336},
    // 53 seconds
    { 1432, 224, -136},
    { 1208, 144, -112},
    { 1048, 128, 80},
    { 896, 56, -16},
    { 872, -16, 24},
    { 856, 344, 144},
    { 1168, 16, -56},
    { 1168, 24, -56},
    { 1104, 80, -96},
    { 1224, 24, -152},
    { 1336, 56, -184},
    { 1288, 88, -328},
    { 1384, 136, -328},
    { 1320, 176, -400},
    { 944, 240, -376},
    { 728, 320, -336},
    { 760, 192, -216},
    { 936, 272, -240},
    { 960, 328, -272},
    { 984, 280, -240},
    { 1520, 288, -176},
    { 1240, 552, -248},
    { 1296, 656, -408},
    { 1312, 536, -480},
    { 1080, 392, -384},
    // 54 seconds
    { 1464, 360, -512},
    { 1544, 528, -216},
    { 1464, 168, 88},
    { 976, -384, 88},
    { 1008, 0, -192},
    { 1128, 40, -176},
    { 1032, 168, -56},
    { 872, 120, 0},
    { 920, 128, 0},
    { 992, 200, -72},
    { 928, 592, -432},
    { 1248, 752, -568},
    { 1096, 1256, -976},
    { 856, 1144, -1184},
    { 896, 736, -776},
    { 912, 448, -808},
    { 536, 208, -768},
    { 336, 128, -744},
    { 144, 208, -760},
    { 88, 192, -752},
    { 112, 264, -728},
    { 160, 256, -744},
    { 32, 168, -768},
    { -80, 88, -848},
    { -32, 96, -1000},
    // 55 seconds
    { 176, 280, -1160},
    { -128, 264, -960},
    { 32, 296, -1160},
    { 208, 248, -1120},
    { 64, 104, -992},
    { -112, 384, -896},
    { -192, 560, -1104},
    { 288, -464, -776},
    { 248, -48, -1016},
    { 64, 200, -1096},
    { 8, 136, -1096},
    { -24, -16, -1080},
    { 24, 112, -1144},
    { 0, 240, -1056},
    { -24, 88, -976},
    { -16, 184, -1024},
    { 128, -112, -904},
    { -24, 136, -1024},
    { -224, 328, -952},
    { -72, 72, -984},
    { -56, 40, -1080},
    { 16, 152, -1080},
    { -8, 136, -1048},
    { 40, 120, -1024},
    { -24, 112, -1040},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-28 17:09:02 local
AccelRawData *activity_sample_100_steps_heather_17(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_heather_17
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 85
  //> TEST_EXPECTED_MAX 110
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 56, 40, -1032},
    { 112, 56, -1024},
    { 176, -32, -992},
    { 232, 56, -1072},
    { 152, 0, -1024},
    { 144, 32, -1008},
    { 168, 0, -1024},
    { 384, -176, -1000},
    { -208, 368, -880},
    { 184, 136, -744},
    { 88, -64, -1008},
    { 152, 8, -1016},
    { 136, 32, -1024},
    { 120, 56, -1088},
    { 16, 128, -1080},
    { 192, 0, -1056},
    { 128, 24, -1048},
    { 152, 48, -1032},
    { 152, 48, -1016},
    { 144, 32, -1000},
    { 152, 32, -1008},
    { 136, 40, -1032},
    { 176, 56, -1040},
    { 176, 48, -1040},
    { 168, 48, -1040},
    // 1 seconds
    { 200, 64, -1016},
    { 160, 48, -1040},
    { 104, 32, -1016},
    { 152, 48, -1008},
    { 128, 80, -1016},
    { 184, 56, -1016},
    { 144, 24, -1016},
    { 136, 32, -1024},
    { 144, 72, -1048},
    { 128, 64, -1048},
    { 120, 56, -1040},
    { 144, 48, -1064},
    { 360, 32, -1032},
    { 72, 184, -1104},
    { 168, 48, -1072},
    { 16, 24, -1008},
    { 104, 80, -1008},
    { 80, 72, -992},
    { 56, 72, -1008},
    { 80, 8, -968},
    { 120, 80, -848},
    { 176, 176, -912},
    { 96, 208, -976},
    { 40, 24, -912},
    { 64, 64, -856},
    // 2 seconds
    { -8, 208, -1024},
    { -96, 456, -1168},
    { -88, 352, -992},
    { -144, 768, -1400},
    { -160, 432, -1240},
    { -120, 264, -1072},
    { -104, 328, -864},
    { -32, 184, -840},
    { -16, 48, -840},
    { -24, 104, -904},
    { -8, 240, -1056},
    { 56, 304, -1120},
    { -8, 344, -1152},
    { 40, 408, -1224},
    { 168, 576, -1352},
    { 168, 528, -928},
    { 48, 496, -808},
    { 32, 496, -808},
    { 24, 464, -832},
    { 48, 384, -904},
    { 24, 160, -928},
    { -56, 192, -1000},
    { -192, 248, -1064},
    { -216, 96, -1016},
    { -112, 128, -984},
    // 3 seconds
    { -88, 112, -920},
    { 96, 248, -1192},
    { 256, 344, -1336},
    { 328, 456, -1288},
    { 160, 392, -1216},
    { 280, 408, -1272},
    { 312, 256, -912},
    { 312, 160, -832},
    { 256, 88, -856},
    { 184, 24, -832},
    { 120, -24, -792},
    { 96, 48, -1024},
    { -8, 112, -896},
    { 152, -40, -880},
    { 8, -72, -976},
    { -248, 144, -1136},
    { -208, 344, -1312},
    { -192, 136, -1216},
    { -208, 312, -1192},
    { 0, 496, -1168},
    { -88, 304, -872},
    { -72, 120, -784},
    { -8, -288, -832},
    { 0, -640, -808},
    { -72, 192, -824},
    // 4 seconds
    { -40, 960, -416},
    { -32, 784, 248},
    { -40, 400, 736},
    { 160, 656, 696},
    { 584, 1088, 384},
    { 1216, 1160, 136},
    { 1328, 760, 40},
    { 1616, 296, 296},
    { 1968, 240, 296},
    { 1672, 192, -64},
    { 1648, 112, 24},
    { 1600, 328, -120},
    { 1304, 464, -344},
    { 1096, 568, -104},
    { 1088, 560, 0},
    { 1072, 576, -32},
    { 904, 632, -80},
    { 1320, 704, -56},
    { 1224, 776, -32},
    { 904, 656, -88},
    { 1264, 648, -128},
    { 1024, 592, -152},
    { 1264, 552, -48},
    { 1736, 520, -56},
    { 1976, 384, -96},
    // 5 seconds
    { 1512, -72, -56},
    { 1168, 56, -56},
    { 1152, 200, -176},
    { 1176, 208, -176},
    { 1080, 136, -248},
    { 1088, 32, -248},
    { 976, -24, -304},
    { 816, 128, -304},
    { 928, 120, -400},
    { 1040, 56, -216},
    { 1008, 120, -256},
    { 1280, 200, -288},
    { 1624, 344, -352},
    { 1336, 432, -248},
    { 1072, 552, -272},
    { 1024, 632, -472},
    { 1120, 400, -304},
    { 1104, 288, -224},
    { 1216, 320, -40},
    { 1624, 600, 136},
    { 1128, 768, 224},
    { 1368, 944, 96},
    { 976, 888, -112},
    { 928, 752, -312},
    { 1256, 800, -368},
    // 6 seconds
    { 1848, 512, -80},
    { 1504, -144, 200},
    { 960, -192, 72},
    { 904, 168, -64},
    { 1024, 304, -152},
    { 1024, 264, -104},
    { 1200, 168, 16},
    { 1600, -80, -40},
    { 1032, -448, 224},
    { 1224, -16, -488},
    { 960, 168, -528},
    { 816, 232, -632},
    { 1248, 288, -696},
    { 1336, 16, -352},
    { 960, 264, -280},
    { 872, 368, -312},
    { 840, 560, -168},
    { 904, 488, -232},
    { 1024, 520, -120},
    { 1392, 560, -48},
    { 1456, 640, 136},
    { 1184, 792, 184},
    { 1352, 888, 16},
    { 864, 816, -184},
    { 896, 872, -240},
    // 7 seconds
    { 1328, 688, -120},
    { 1400, 440, 0},
    { 1192, 312, 72},
    { 1120, 240, 8},
    { 1136, 200, -64},
    { 1104, 208, -40},
    { 1032, 184, -160},
    { 1224, 128, -48},
    { 1232, 104, -256},
    { 1080, 8, -232},
    { 1208, -32, -128},
    { 1152, 96, -280},
    { 1016, 112, -424},
    { 1464, 32, -448},
    { 1328, 120, -272},
    { 1008, 128, -280},
    { 1072, 216, -272},
    { 1024, 408, -168},
    { 1016, 464, -64},
    { 904, 480, -104},
    { 1240, 552, 24},
    { 1432, 656, 104},
    { 1000, 744, 112},
    { 1320, 768, -56},
    { 1072, 640, -136},
    // 8 seconds
    { 1160, 616, -200},
    { 1448, 688, -136},
    { 1712, 600, -96},
    { 1440, 400, 136},
    { 1296, 112, 160},
    { 1096, -80, 128},
    { 1008, 16, -104},
    { 936, 104, -192},
    { 1048, 104, -48},
    { 1192, 88, -120},
    { 888, 200, -256},
    { 992, 104, -256},
    { 1200, 104, -208},
    { 1136, 96, -216},
    { 1440, 168, -304},
    { 1472, 264, -424},
    { 1072, 168, -376},
    { 768, 296, -352},
    { 880, 296, -304},
    { 1024, 256, -192},
    { 1040, 328, -136},
    { 1072, 472, -96},
    { 1552, 640, -88},
    { 1192, 832, 56},
    { 1376, 832, -176},
    // 9 seconds
    { 1288, 456, -192},
    { 752, 456, -288},
    { 992, 488, -328},
    { 1456, 464, -208},
    { 1288, 256, -88},
    { 1032, 104, 32},
    { 944, 40, -8},
    { 992, 168, -96},
    { 1000, 216, -24},
    { 976, 192, -72},
    { 1400, 208, -112},
    { 1304, 152, -152},
    { 1160, 128, -264},
    { 1216, -8, -144},
    { 992, 24, -256},
    { 848, 128, -304},
    { 1208, 160, -432},
    { 1112, 128, -512},
    { 840, 96, -336},
    { 744, 200, -264},
    { 824, 336, -240},
    { 912, 376, -216},
    { 952, 360, -112},
    { 1312, 504, -32},
    { 1528, 456, 0},
    // 10 seconds
    { 1080, 544, -24},
    { 1456, 808, -200},
    { 1184, 768, -392},
    { 944, 560, -320},
    { 1152, 288, -432},
    { 1360, 552, -288},
    { 1152, 64, -48},
    { 920, -8, -16},
    { 872, 32, -80},
    { 944, 168, -112},
    { 1040, 224, -88},
    { 1016, 264, -64},
    { 1360, 248, -48},
    { 1216, 240, -208},
    { 1320, 184, -224},
    { 1272, 64, -120},
    { 992, 104, -304},
    { 1000, 72, -328},
    { 1136, 112, -416},
    { 1008, 200, -464},
    { 832, 200, -304},
    { 776, 264, -232},
    { 840, 368, -184},
    { 848, 400, -216},
    { 888, 408, -192},
    // 11 seconds
    { 1376, 432, -120},
    { 1448, 448, 40},
    { 1096, 544, 32},
    { 1592, 768, -16},
    { 1032, 1008, -384},
    { 856, 472, -248},
    { 1448, 472, -336},
    { 1560, 232, -160},
    { 1096, 0, -64},
    { 936, -8, -48},
    { 968, 168, -88},
    { 1024, 224, -120},
    { 1008, 232, -88},
    { 1104, 184, -88},
    { 1304, 168, -272},
    { 1056, 128, -288},
    { 1192, -96, -72},
    { 1328, -16, -120},
    { 1096, 144, -304},
    { 1248, 152, -312},
    { 1304, 200, -376},
    { 944, 208, -216},
    { 784, 272, -184},
    { 912, 152, -120},
    { 968, 368, -208},
    // 12 seconds
    { 960, 376, -272},
    { 1184, 456, -280},
    { 1600, 680, -136},
    { 1088, 752, 32},
    { 1528, 680, -72},
    { 1144, 624, -160},
    { 1040, 624, -184},
    { 1216, 504, 56},
    { 1560, 312, 56},
    { 1216, 272, -120},
    { 1064, 184, -120},
    { 1144, 160, -96},
    { 1192, 80, -104},
    { 1096, 80, -136},
    { 1064, 64, -136},
    { 1240, 80, -320},
    { 992, 32, -392},
    { 1040, -96, -192},
    { 1232, -104, -144},
    { 1280, 104, -248},
    { 1472, 112, -152},
    { 1512, 232, -240},
    { 1096, 336, -296},
    { 784, 344, -248},
    { 800, 376, -176},
    // 13 seconds
    { 944, 368, -192},
    { 1104, 376, -168},
    { 1176, 416, -80},
    { 1520, 600, -32},
    { 1064, 800, -120},
    { 1464, 824, -168},
    { 1208, 648, -144},
    { 1056, 528, -272},
    { 1320, 520, -160},
    { 1592, 464, -152},
    { 1336, 152, 0},
    { 1088, -24, 8},
    { 1000, 88, -56},
    { 1048, 144, -120},
    { 1080, 168, -136},
    { 1096, 160, -56},
    { 1376, 168, -192},
    { 1064, 160, -264},
    { 1200, 64, -120},
    { 1176, 80, -120},
    { 1048, 168, -224},
    { 1280, 216, -272},
    { 1296, 248, -392},
    { 984, 272, -312},
    { 808, 288, -304},
    // 14 seconds
    { 792, 320, -256},
    { 872, 312, -216},
    { 1008, 312, -216},
    { 1280, 432, -72},
    { 1720, 632, -120},
    { 1088, 760, 8},
    { 1296, 800, -224},
    { 1080, 632, -192},
    { 880, 544, -176},
    { 1272, 552, 32},
    { 1544, 424, 56},
    { 1336, 184, -40},
    { 1064, 112, -32},
    { 1048, 168, -40},
    { 1080, 168, -80},
    { 992, 184, -120},
    { 968, 144, -80},
    { 1168, 120, -160},
    { 1104, 168, -448},
    { 1160, 72, -360},
    { 1368, -56, -32},
    { 1200, 32, -128},
    { 1280, 176, -328},
    { 1464, 272, -384},
    { 1280, 392, -504},
    // 15 seconds
    { 1072, 1408, -1152},
    { 1016, 656, -528},
    { 1136, 640, -776},
    { 616, 736, -1080},
    { 728, 840, -1304},
    { 808, 824, -1288},
    { 904, 568, -1272},
    { 592, 336, -1008},
    { 536, 344, -880},
    { 632, 296, -880},
    { 608, 160, -760},
    { 496, 56, -768},
    { 392, 8, -792},
    { 304, -112, -616},
    { 136, -200, -536},
    { 64, -144, -552},
    { 64, -192, -688},
    { 72, -232, -888},
    { 80, -264, -1064},
    { 120, -360, -1128},
    { 104, -376, -1120},
    { 96, -416, -1104},
    { 144, -288, -1080},
    { 248, -128, -1104},
    { 376, -192, -1008},
    // 16 seconds
    { 312, -208, -800},
    { 264, -104, -656},
    { 112, -112, -616},
    { -48, -120, -784},
    { -160, -136, -976},
    { -152, -176, -1056},
    { -104, -280, -1088},
    { -152, -264, -1192},
    { -104, -200, -1344},
    { -152, -176, -1368},
    { -144, -64, -1328},
    { -32, 64, -1248},
    { -40, 80, -1080},
    { 0, 80, -960},
    { 56, 24, -896},
    { 88, -48, -760},
    { 32, -88, -600},
    { 16, -184, -496},
    { -8, -312, -392},
    { 80, -384, -384},
    { 304, -48, -432},
    { 728, 192, -512},
    { 1560, 248, -440},
    { 2008, 360, 40},
    { 2064, 712, 440},
    // 17 seconds
    { 2176, 896, -64},
    { 1728, 864, -696},
    { 1536, 592, -448},
    { 1280, 600, -8},
    { 848, 376, -40},
    { 760, 40, -136},
    { 928, 272, -112},
    { 984, 480, -56},
    { 992, 688, -152},
    { 1000, 680, -24},
    { 1392, 704, 48},
    { 960, 712, -96},
    { 1136, 584, -24},
    { 1304, 672, -120},
    { 1040, 640, -160},
    { 1504, 704, -72},
    { 1768, 488, 136},
    { 1576, 232, 104},
    { 1256, 40, 72},
    { 1120, 48, 24},
    { 1128, 144, -80},
    { 1080, 160, -128},
    { 904, 152, -152},
    { 896, 16, -176},
    { 976, -16, -272},
    // 18 seconds
    { 784, -24, -272},
    { 1112, -48, -240},
    { 1312, 96, -176},
    { 1616, 120, -184},
    { 1784, 224, -224},
    { 1568, 328, -336},
    { 1016, 312, -240},
    { 768, 360, -168},
    { 920, 432, -224},
    { 1128, 392, -128},
    { 1056, 384, -88},
    { 1136, 528, -32},
    { 1440, 712, 80},
    { 984, 1096, -144},
    { 1312, 840, -56},
    { 1280, 600, -168},
    { 1176, 360, 0},
    { 1552, 408, -392},
    { 1456, 416, -136},
    { 1432, 328, 104},
    { 1048, 328, 632},
    { 1032, 1000, 72},
    { 1280, 864, 232},
    { 1416, 440, 360},
    { 1392, 368, 224},
    // 19 seconds
    { 1264, 192, -128},
    { 824, -144, -224},
    { 632, -344, -272},
    { 1000, -224, -288},
    { 1200, -136, -368},
    { 1416, -24, -424},
    { 1432, 88, -320},
    { 1160, 232, -208},
    { 1080, 320, -296},
    { 1112, 280, -344},
    { 1104, 288, -336},
    { 1080, 312, -432},
    { 952, 488, -720},
    { 728, 640, -808},
    { 1296, 416, -296},
    { 1008, 352, -488},
    { 1544, 352, -472},
    { 1520, 192, -352},
    { 1248, 256, -288},
    { 1368, 248, -144},
    { 1568, 248, -104},
    { 1176, 144, -72},
    { 896, 80, -88},
    { 712, 104, -216},
    { 704, 112, -344},
    // 20 seconds
    { 656, 264, -384},
    { 632, -112, -288},
    { 808, -144, -248},
    { 1072, -40, -272},
    { 1152, 24, -336},
    { 1488, 48, -128},
    { 1880, 192, 136},
    { 1776, 496, 32},
    { 1480, 632, -80},
    { 1200, 576, -192},
    { 880, 288, -168},
    { 784, 272, -16},
    { 832, 288, 56},
    { 824, 344, 24},
    { 824, 336, 8},
    { 808, 360, -96},
    { 1288, 416, -24},
    { 1392, 664, -64},
    { 1136, 1232, -264},
    { 984, 544, -248},
    { 1144, 608, -192},
    { 1216, 664, -208},
    { 1512, 504, -104},
    { 1840, 472, -16},
    { 1600, 112, 168},
    // 21 seconds
    { 1248, -136, 128},
    { 1064, -8, 24},
    { 1072, 104, -24},
    { 976, 184, -48},
    { 960, 240, -8},
    { 1128, 176, 0},
    { 1024, 216, -200},
    { 1184, 112, -184},
    { 1304, 64, 40},
    { 1360, 168, -240},
    { 1480, 168, -216},
    { 1448, 152, -232},
    { 1120, 200, -288},
    { 1016, 264, -184},
    { 1056, 360, -80},
    { 1096, 432, -16},
    { 1120, 392, -80},
    { 1064, 456, -64},
    { 1320, 496, 64},
    { 976, 640, 80},
    { 1160, 704, 72},
    { 1280, 872, -56},
    { 1160, 584, -160},
    { 1400, 440, 80},
    { 1744, 568, 96},
    // 22 seconds
    { 1536, 432, 32},
    { 1432, 176, 88},
    { 1272, 0, 152},
    { 1136, 64, 8},
    { 1024, 120, -96},
    { 920, 128, -40},
    { 1120, 88, -8},
    { 1160, 112, -72},
    { 1144, 88, -24},
    { 1360, 120, 64},
    { 1480, 232, -136},
    { 1672, 312, -216},
    { 1608, 288, -184},
    { 1256, 288, -312},
    { 904, 336, -288},
    { 776, 384, -184},
    { 760, 376, -136},
    { 944, 368, -136},
    { 1000, 400, -136},
    { 1312, 456, 32},
    { 1256, 632, 64},
    { 1040, 744, -64},
    { 1248, 632, -136},
    { 1144, 528, -232},
    { 1136, 640, -144},
    // 23 seconds
    { 1432, 504, -144},
    { 1584, 448, -40},
    { 1416, 216, 72},
    { 1176, -16, 136},
    { 1056, 0, 0},
    { 1040, 128, -72},
    { 936, 152, -88},
    { 904, 128, -16},
    { 1232, 136, -104},
    { 1040, 128, -184},
    { 1208, 8, -176},
    { 1360, 0, -56},
    { 1384, 128, -280},
    { 1312, 128, -232},
    { 1368, 144, -296},
    { 1160, 160, -328},
    { 880, 120, -176},
    { 824, 400, -256},
    { 912, 272, -304},
    { 1008, 248, -152},
    { 1064, 288, -144},
    { 1216, 240, -224},
    { 1320, 328, -256},
    { 1104, 392, -192},
    { 1272, 584, -264},
    // 24 seconds
    { 1176, 776, -440},
    { 1096, 512, -248},
    { 1400, 584, -200},
    { 1640, 312, 32},
    { 1272, 32, 48},
    { 1008, -40, 24},
    { 904, 72, -48},
    { 920, 136, -72},
    { 920, 200, -48},
    { 944, 176, -48},
    { 1376, 168, -48},
    { 1296, 144, -112},
    { 1280, 112, -120},
    { 1360, 152, -240},
    { 1208, 152, -288},
    { 1096, 136, -328},
    { 1128, 160, -312},
    { 1128, 208, -344},
    { 848, 192, -264},
    { 800, 224, -208},
    { 872, 256, -136},
    { 976, 312, -184},
    { 968, 360, -248},
    { 1024, 352, -152},
    { 1232, 416, -120},
    // 25 seconds
    { 1208, 496, -80},
    { 1240, 528, -200},
    { 1232, 552, -264},
    { 1216, 504, -128},
    { 1280, 464, 8},
    { 1440, 264, -24},
    { 1208, 120, -16},
    { 992, 88, -24},
    { 896, 136, -24},
    { 928, 168, -64},
    { 992, 176, -40},
    { 984, 152, 16},
    { 1408, 144, 16},
    { 1248, 192, -64},
    { 1320, 200, -72},
    { 1344, 184, -144},
    { 1232, 256, -304},
    { 1168, 152, -240},
    { 1168, 112, -272},
    { 936, 176, -392},
    { 664, 216, -256},
    { 720, 272, -288},
    { 768, 344, -144},
    { 1024, 392, -136},
    { 1024, 328, -128},
    // 26 seconds
    { 1440, 368, -80},
    { 1464, 512, -88},
    { 1048, 528, -40},
    { 1296, 568, -232},
    { 1128, 672, -352},
    { 1000, 568, -208},
    { 1336, 536, -8},
    { 1536, 216, 104},
    { 1152, -32, 40},
    { 912, -24, -32},
    { 880, 104, -8},
    { 984, 208, -104},
    { 1000, 272, -96},
    { 984, 208, -40},
    { 1272, 160, -152},
    { 992, 152, -256},
    { 1240, 56, -80},
    { 1408, 64, -24},
    { 1336, 216, -272},
    { 1424, 264, -352},
    { 1224, 200, -360},
    { 760, 176, -232},
    { 656, 176, -176},
    { 768, 256, -120},
    { 864, 328, -64},
    // 27 seconds
    { 1056, 392, -104},
    { 1080, 400, -128},
    { 1480, 480, -72},
    { 1240, 560, -32},
    { 1216, 624, 24},
    { 1352, 840, -232},
    { 944, 560, -256},
    { 1112, 488, -112},
    { 1448, 584, 56},
    { 1416, 256, 56},
    { 1160, -16, 32},
    { 992, -8, 16},
    { 984, 120, -56},
    { 1008, 200, -136},
    { 960, 240, -112},
    { 1016, 168, -56},
    { 1192, 152, -152},
    { 1112, 136, -200},
    { 1296, 80, -168},
    { 1360, 112, -80},
    { 1184, 208, -280},
    { 1168, 216, -264},
    { 1136, 208, -272},
    { 928, 216, -248},
    { 824, 256, -216},
    // 28 seconds
    { 872, 288, -176},
    { 952, 352, -176},
    { 984, 360, -192},
    { 952, 384, -184},
    { 1408, 448, -64},
    { 1248, 536, -8},
    { 1080, 528, -80},
    { 1392, 560, -216},
    { 960, 632, -192},
    { 1224, 560, -80},
    { 1432, 504, 48},
    { 1200, 272, 24},
    { 1104, 32, 56},
    { 992, -16, 32},
    { 1016, 104, -64},
    { 1024, 192, -120},
    { 1000, 216, -32},
    { 1312, 144, 0},
    { 1264, 208, -192},
    { 1144, 144, -160},
    { 1224, 120, -56},
    { 1208, 168, -184},
    { 1280, 184, -232},
    { 1400, 224, -320},
    { 1008, 216, -368},
    // 29 seconds
    { 688, 184, -256},
    { 696, 224, -224},
    { 776, 264, -152},
    { 896, 312, -168},
    { 952, 304, -112},
    { 1376, 416, -80},
    { 1344, 456, -48},
    { 1024, 472, -16},
    { 1288, 512, -200},
    { 1144, 704, -248},
    { 1112, 552, -176},
    { 1384, 496, 32},
    { 1424, 280, -24},
    { 1096, 16, -32},
    { 880, -88, 0},
    { 824, 72, -56},
    { 840, 160, -104},
    { 864, 224, -128},
    { 1128, 168, -24},
    { 1576, 208, -160},
    { 1152, 168, -192},
    { 1296, 104, -136},
    { 1432, 128, -128},
    { 1224, 176, -320},
    { 1224, 200, -288},
    // 30 seconds
    { 1016, 144, -256},
    { 744, 144, -184},
    { 720, 256, -128},
    { 744, 312, -88},
    { 896, 328, -96},
    { 976, 336, -136},
    { 1032, 352, -104},
    { 1448, 392, -40},
    { 1136, 504, -8},
    { 1096, 544, -8},
    { 1392, 816, -184},
    { 1056, 760, -296},
    { 1224, 424, -56},
    { 1448, 536, -64},
    { 1320, 320, -16},
    { 1200, -8, 104},
    { 984, -128, 96},
    { 880, 56, -40},
    { 952, 152, -144},
    { 1000, 232, -48},
    { 1352, 192, 16},
    { 1168, 208, -96},
    { 1256, 168, -96},
    { 1400, 176, -48},
    { 1176, 200, -240},
    // 31 seconds
    { 1144, 176, -264},
    { 1168, 120, -264},
    { 912, 120, -336},
    { 760, 184, -296},
    { 768, 256, -256},
    { 824, 328, -176},
    { 928, 344, -184},
    { 952, 320, -176},
    { 1376, 368, -120},
    { 1576, 432, -136},
    { 1000, 488, -80},
    { 1296, 536, -160},
    { 1184, 728, -336},
    { 960, 496, -264},
    { 1312, 392, 16},
    { 1488, 184, 16},
    { 1112, 24, -96},
    { 960, 40, -112},
    { 920, 128, -128},
    { 952, 176, -136},
    { 928, 144, -88},
    { 928, 104, -64},
    { 1296, 120, -112},
    { 1168, 160, -272},
    { 1336, 64, -160},
    // 32 seconds
    { 1400, 88, 16},
    { 1272, 192, -200},
    { 1256, 240, -224},
    { 1200, 224, -256},
    { 872, 208, -232},
    { 712, 208, -176},
    { 728, 280, -144},
    { 808, 336, -56},
    { 1000, 344, -112},
    { 1088, 408, -144},
    { 1352, 408, 8},
    { 1320, 528, 48},
    { 1048, 664, -16},
    { 1344, 664, -304},
    { 1040, 528, -224},
    { 1176, 568, -64},
    { 1448, 584, -32},
    { 1448, 272, -40},
    { 1208, -24, 32},
    { 968, -120, 72},
    { 896, 72, -64},
    { 920, 192, -136},
    { 912, 256, -104},
    { 1120, 184, -8},
    { 1336, 176, -144},
    // 33 seconds
    { 1032, 144, -128},
    { 1192, 56, 8},
    { 1376, 152, -16},
    { 1296, 248, -216},
    { 1432, 240, -320},
    { 1096, 232, -416},
    { 696, 144, -232},
    { 728, 152, -184},
    { 808, 280, -96},
    { 952, 352, -88},
    { 1008, 352, -136},
    { 1192, 400, -120},
    { 1488, 440, -8},
    { 1096, 512, 72},
    { 1152, 584, -80},
    { 1312, 824, -208},
    { 856, 688, -296},
    { 1184, 464, 24},
    { 1464, 504, 48},
    { 1224, 280, -16},
    { 1088, -24, 48},
    { 952, -8, 48},
    { 1032, 104, -16},
    { 1064, 224, -96},
    { 1016, 248, -40},
    // 34 seconds
    { 1200, 176, 8},
    { 1192, 184, -136},
    { 1080, 152, -184},
    { 1248, 88, -128},
    { 1288, 112, -112},
    { 1160, 144, -272},
    { 1304, 168, -352},
    { 1160, 200, -320},
    { 880, 208, -192},
    { 808, 280, -176},
    { 864, 328, -80},
    { 936, 360, -104},
    { 976, 360, -136},
    { 1040, 384, -128},
    { 1384, 432, 0},
    { 1208, 512, 40},
    { 1064, 680, -136},
    { 1376, 744, -320},
    { 1064, 480, -216},
    { 1288, 448, -72},
    { 1680, 432, 16},
    { 1520, 208, 72},
    { 1216, 48, 16},
    { 1024, 24, 64},
    { 960, 128, 64},
    // 35 seconds
    { 912, 208, -56},
    { 824, 240, -96},
    { 872, 128, 32},
    { 1088, 104, 0},
    { 968, 136, -96},
    { 1280, 144, -80},
    { 1472, 208, -32},
    { 1448, 368, -304},
    { 1400, 304, -376},
    { 1256, 176, -184},
    { 896, 80, -184},
    { 784, 32, -96},
    { 856, 224, -88},
    { 920, 352, -48},
    { 1040, 448, -176},
    { 1016, 456, -264},
    { 1552, 512, -80},
    { 1288, 952, -16},
    { 1048, 728, -416},
    { 1424, 152, -72},
    { 936, 416, -232},
    { 1280, 576, -160},
    { 1624, 528, 0},
    { 1416, 384, 40},
    { 1528, 448, -80},
    // 36 seconds
    { 1440, 680, 168},
    { 1528, 864, -72},
    { 1392, 488, -120},
    { 1184, 416, -424},
    { 1080, 280, -536},
    { 1024, 232, -656},
    { 760, -56, -528},
    { 432, -280, -480},
    { 336, -168, -752},
    { 464, -208, -752},
    { 448, -272, -672},
    { 368, -288, -672},
    { 240, -312, -680},
    { 128, -296, -688},
    { 120, -304, -712},
    { 104, -296, -784},
    { 40, -272, -928},
    { -80, -408, -960},
    { -176, -360, -1064},
    { -120, -280, -1184},
    { -200, -344, -1192},
    { -160, -240, -1144},
    { -40, -16, -1064},
    { -80, -56, -800},
    { -144, -176, -600},
    // 37 seconds
    { -56, 104, -776},
    { -32, 328, -968},
    { -96, 248, -816},
    { -128, 40, -560},
    { 8, -72, -456},
    { 224, -32, -384},
    { 592, 56, -304},
    { 1376, 144, -120},
    { 2248, 416, 216},
    { 2352, 624, 208},
    { 2552, 728, -96},
    { 2056, 776, -312},
    { 1448, 592, -72},
    { 1472, 248, 56},
    { 1088, 128, -104},
    { 840, 136, -88},
    { 784, 384, -104},
    { 888, 528, -192},
    { 976, 656, -256},
    { 944, 600, -192},
    { 1328, 680, -72},
    { 1088, 552, -120},
    { 1072, 384, -56},
    { 1280, 504, -80},
    { 1032, 648, -224},
    // 38 seconds
    { 1336, 600, -96},
    { 1648, 520, 160},
    { 1872, 264, 208},
    { 1624, 104, 72},
    { 1392, 88, 40},
    { 1312, 120, 0},
    { 1216, 160, -80},
    { 1040, 160, -120},
    { 856, 104, -144},
    { 856, 32, -120},
    { 784, 64, -272},
    { 752, 32, -296},
    { 1112, 16, 16},
    { 1584, 136, -32},
    { 1872, 336, -128},
    { 1936, 384, -176},
    { 1488, 336, -304},
    { 1024, 256, -48},
    { 880, 384, -256},
    { 1192, 400, -112},
    { 1120, 424, -16},
    { 1048, 488, -136},
    { 1168, 512, 8},
    { 1344, 600, 312},
    { 1024, 864, 72},
    // 39 seconds
    { 1016, 656, 0},
    { 1008, 704, -96},
    { 1048, 688, -88},
    { 1328, 712, -64},
    { 1560, 696, -8},
    { 1512, 568, 40},
    { 1496, 384, 128},
    { 1376, 192, 144},
    { 1216, 64, 40},
    { 1016, 16, -16},
    { 880, 24, -72},
    { 1112, 88, -8},
    { 1056, 184, -168},
    { 960, 200, -264},
    { 1176, 136, -160},
    { 1312, 256, -96},
    { 1328, 256, -200},
    { 1368, 272, -96},
    { 1288, 288, -168},
    { 944, 280, -200},
    { 856, 328, -200},
    { 936, 368, -96},
    { 1056, 344, -216},
    { 1096, 376, -248},
    { 1064, 416, -192},
    // 40 seconds
    { 1432, 576, -96},
    { 1144, 648, -32},
    { 1072, 568, -136},
    { 1360, 616, -168},
    { 968, 536, -208},
    { 1200, 520, -56},
    { 1536, 504, 104},
    { 1440, 240, 72},
    { 1224, 80, 40},
    { 1136, 40, 32},
    { 1184, 128, -24},
    { 1176, 208, -80},
    { 1008, 232, -136},
    { 968, 152, -64},
    { 1064, 112, -136},
    { 912, 136, -288},
    { 1104, 64, -208},
    { 1304, 104, -16},
    { 1336, 224, -184},
    { 1400, 288, -208},
    { 1432, 304, -248},
    { 1048, 288, -288},
    { 824, 264, -264},
    { 888, 248, -176},
    { 992, 328, -152},
    // 41 seconds
    { 1008, 328, -208},
    { 912, 368, -216},
    { 1224, 472, -40},
    { 1360, 584, 104},
    { 1008, 672, -40},
    { 1328, 592, -176},
    { 1208, 656, -208},
    { 1040, 648, -216},
    { 1368, 696, 48},
    { 1808, 376, 328},
    { 1600, -144, 112},
    { 1144, -224, 48},
    { 1016, 24, 40},
    { 992, 224, -64},
    { 984, 328, -192},
    { 872, 296, -176},
    { 832, 48, -56},
    { 1072, -336, -120},
    { 1024, 352, -128},
    { 1176, 608, 56},
    { 1448, 608, 176},
    { 1336, 576, 64},
    { 1352, 440, -40},
    { 1200, 464, -72},
    { 816, 456, 32},
    // 42 seconds
    { 696, 584, 24},
    { 856, 576, -8},
    { 984, 648, -56},
    { 1016, 392, 80},
    { 1048, 280, 112},
    { 1544, 208, 184},
    { 1160, 712, 408},
    { 1184, 1072, -136},
    { 1104, 672, -160},
    { 1024, 520, -96},
    { 1184, 528, -40},
    { 1536, 576, 40},
    { 1448, 312, 136},
    { 1280, 24, 120},
    { 1072, -40, 56},
    { 1032, 104, 0},
    { 1024, 184, -24},
    { 936, 256, -32},
    { 1024, 192, 40},
    { 1240, 184, 0},
    { 1024, 232, -144},
    { 1224, 152, -176},
    { 1456, 144, -104},
    { 1344, 184, -136},
    { 1304, 144, -192},
    // 43 seconds
    { 1280, 184, -344},
    { 1096, 232, -408},
    { 912, 304, -104},
    { 888, 400, -104},
    { 896, 416, -56},
    { 1048, 400, -200},
    { 1120, 296, -272},
    { 1344, 312, -144},
    { 1280, 416, -56},
    { 928, 488, -96},
    { 1200, 576, -192},
    { 896, 784, -96},
    { 816, 800, -248},
    { 1304, 344, 152},
    { 1400, 432, 136},
    { 1280, 336, 8},
    { 1328, 192, 0},
    { 1352, 136, 24},
    { 1384, 184, -40},
    { 1280, 224, -48},
    { 1320, 176, -24},
    { 1448, 168, -208},
    { 1080, 96, -288},
    { 1136, -88, -192},
    { 1024, -136, -56},
    // 44 seconds
    { 1040, 88, -216},
    { 1112, 160, -192},
    { 1384, 192, -280},
    { 1264, 296, -304},
    { 1128, 336, -144},
    { 1064, 400, -208},
    { 1016, 504, -160},
    { 952, 384, -264},
    { 912, 224, -168},
    { 1320, 336, -72},
    { 1384, 576, -32},
    { 992, 736, 48},
    { 1336, 832, -232},
    { 1080, 696, -224},
    { 1208, 528, -56},
    { 1608, 584, 136},
    { 1704, 272, 128},
    { 1408, 24, 88},
    { 1200, 80, 48},
    { 1160, 136, 16},
    { 1128, 240, -48},
    { 992, 248, -104},
    { 856, 168, -56},
    { 984, 80, -56},
    { 912, 112, -216},
    // 45 seconds
    { 944, 80, -240},
    { 1360, 48, 40},
    { 1632, 216, -160},
    { 1520, 296, -224},
    { 1400, 232, -168},
    { 1232, 208, -224},
    { 1096, 264, -168},
    { 1112, 368, -24},
    { 1072, 440, 56},
    { 1152, 448, -32},
    { 1096, 496, -104},
    { 1216, 472, 40},
    { 1256, 672, 128},
    { 976, 808, 56},
    { 1200, 744, -48},
    { 1024, 608, -120},
    { 1256, 536, -128},
    { 1584, 648, 40},
    { 1832, 576, 152},
    { 1696, 192, 88},
    { 1400, -80, 176},
    { 1160, 72, 80},
    { 1112, 136, -40},
    { 1000, 232, -72},
    { 872, 208, 8},
    // 46 seconds
    { 1040, 144, -16},
    { 992, 176, -136},
    { 880, 112, -144},
    { 1264, 80, 0},
    { 1360, 192, -112},
    { 1424, 248, -184},
    { 1592, 272, -232},
    { 1336, 312, -296},
    { 1008, 304, -240},
    { 992, 344, -192},
    { 1120, 392, -112},
    { 1176, 352, -136},
    { 1064, 352, -120},
    { 1248, 552, -32},
    { 1240, 672, 104},
    { 984, 752, -16},
    { 1312, 576, -152},
    { 1024, 576, -152},
    { 1192, 584, -112},
    { 1472, 624, 72},
    { 1672, 400, 144},
    { 1432, 72, 120},
    { 1200, -32, 72},
    { 1152, 72, 8},
    { 1096, 184, -64},
    // 47 seconds
    { 1000, 256, -120},
    { 896, 192, -80},
    { 1056, 112, -80},
    { 944, 120, -232},
    { 1056, 24, -72},
    { 1320, 72, 112},
    { 1464, 264, -112},
    { 1504, 320, -136},
    { 1584, 320, -232},
    { 1160, 336, -328},
    { 928, 288, -224},
    { 952, 296, -120},
    { 1024, 376, -96},
    { 1056, 344, -88},
    { 1008, 400, -96},
    { 1440, 504, 0},
    { 1096, 616, 144},
    { 1168, 672, 8},
    { 1320, 720, -168},
    { 1008, 624, -176},
    { 1160, 552, -24},
    { 1520, 576, 80},
    { 1512, 352, 144},
    { 1304, 64, 128},
    { 1144, -32, 80},
    // 48 seconds
    { 1048, 88, 24},
    { 1048, 184, -72},
    { 968, 248, -64},
    { 1056, 176, 32},
    { 1280, 152, -40},
    { 944, 208, -176},
    { 1160, 96, -96},
    { 1288, 120, -24},
    { 1288, 240, -144},
    { 1344, 224, -144},
    { 1288, 264, -280},
    { 992, 296, -280},
    { 880, 272, -184},
    { 952, 336, -72},
    { 1000, 392, -104},
    { 1120, 360, -120},
    { 1048, 368, -128},
    { 1472, 488, 0},
    { 1240, 592, 64},
    { 1144, 696, -56},
    { 1312, 592, -240},
    { 1128, 504, -192},
    { 1168, 544, -80},
    { 1456, 496, 56},
    { 1496, 176, 128},
    // 49 seconds
    { 1136, 48, 48},
    { 968, 64, 8},
    { 904, 144, 8},
    { 904, 208, -16},
    { 864, 232, -40},
    { 896, 168, 8},
    { 1232, 160, 32},
    { 1160, 200, -96},
    { 1216, 168, -136},
    { 1408, 192, -8},
    { 1336, 304, -272},
    { 1216, 272, -224},
    { 1192, 184, -304},
    { 1000, 208, -368},
    { 776, 200, -264},
    { 768, 288, -232},
    { 864, 384, -128},
    { 960, 328, -144},
    { 952, 352, -176},
    { 1304, 488, -48},
    { 1440, 576, -32},
    { 944, 728, 48},
    { 1512, 672, -200},
    { 1080, 496, -160},
    { 1152, 536, -120},
    // 50 seconds
    { 1456, 584, 64},
    { 1528, 344, 88},
    { 1280, 56, 88},
    { 1048, 72, 40},
    { 1040, 120, -8},
    { 1064, 200, -64},
    { 1008, 240, -64},
    { 888, 184, -40},
    { 1088, 128, -40},
    { 1112, 176, -232},
    { 1120, 120, -280},
    { 1352, 72, -24},
    { 1352, 176, -168},
    { 1328, 232, -248},
    { 1360, 248, -232},
    { 1160, 264, -312},
    { 936, 312, -280},
    { 888, 288, -136},
    { 960, 360, -88},
    { 1000, 368, -104},
    { 992, 376, -152},
    { 1168, 424, -64},
    { 1408, 536, 8},
    { 1096, 632, 48},
    { 1272, 696, -152},
    // 51 seconds
    { 1152, 640, -216},
    { 984, 512, -152},
    { 1304, 568, 8},
    { 1616, 472, 80},
    { 1432, 200, 72},
    { 1264, 48, 64},
    { 1112, 40, 48},
    { 1064, 136, -48},
    { 992, 224, -96},
    { 856, 208, -56},
    { 1008, 136, -32},
    { 1216, 152, -128},
    { 1032, 160, -200},
    { 1320, 88, -48},
    { 1456, 136, -64},
    { 1328, 248, -200},
    { 1328, 248, -152},
    { 1256, 288, -288},
    { 992, 280, -256},
    { 920, 328, -176},
    { 832, 368, -120},
    { 928, 392, -128},
    { 1008, 328, -144},
    { 1064, 368, -128},
    { 1480, 472, -72},
    // 52 seconds
    { 1136, 560, -40},
    { 1144, 616, -80},
    { 1240, 696, -232},
    { 984, 576, -240},
    { 1288, 488, -24},
    { 1560, 488, 128},
    { 1352, 264, 72},
    { 1192, 120, 32},
    { 1112, 64, 48},
    { 1088, 144, 0},
    { 1088, 208, -88},
    { 960, 216, -72},
    { 1024, 152, -24},
    { 1152, 120, -104},
    { 968, 152, -208},
    { 1296, 88, -200},
    { 1384, 120, -128},
    { 1232, 176, -304},
    { 1288, 176, -232},
    { 1288, 216, -296},
    { 1016, 232, -224},
    { 936, 296, -176},
    { 944, 368, -144},
    { 1032, 416, -104},
    { 992, 400, -136},
    // 53 seconds
    { 984, 392, -136},
    { 1472, 520, -80},
    { 1160, 624, 0},
    { 1048, 624, -64},
    { 1304, 664, -136},
    { 1016, 608, -232},
    { 1288, 544, -72},
    { 1600, 576, 104},
    { 1480, 352, 80},
    { 1296, 72, 80},
    { 1176, 32, 80},
    { 1152, 120, -32},
    { 1120, 208, -72},
    { 936, 224, -72},
    { 872, 120, -24},
    { 1024, 120, -48},
    { 912, 184, -224},
    { 960, 112, -184},
    { 1320, 112, -8},
    { 1464, 208, -240},
    { 1568, 256, -168},
    { 1624, 280, -336},
    { 1080, 280, -416},
    { 816, 272, -256},
    { 880, 288, -152},
    // 54 seconds
    { 936, 328, -80},
    { 1008, 400, -104},
    { 952, 464, -112},
    { 1288, 480, 0},
    { 1296, 512, 56},
    { 1064, 576, 32},
    { 1392, 736, -152},
    { 1064, 624, -232},
    { 1152, 448, 16},
    { 1560, 544, 96},
    { 1784, 320, 32},
    { 1424, 24, 8},
    { 1144, -72, 56},
    { 1048, 72, -16},
    { 1048, 192, -88},
    { 936, 256, -88},
    { 856, 192, -40},
    { 944, 136, -16},
    { 864, 168, -176},
    { 888, 128, -176},
    { 1304, 96, 16},
    { 1488, 216, -48},
    { 1496, 288, -184},
    { 1584, 312, -200},
    { 1216, 280, -224},
    // 55 seconds
    { 928, 216, -200},
    { 936, 264, -120},
    { 976, 360, -72},
    { 1024, 384, -64},
    { 976, 408, -88},
    { 872, 416, -72},
    { 1280, 504, 24},
    { 1216, 664, -16},
    { 848, 688, -64},
    { 1408, 656, -40},
    { 1192, 608, -176},
    { 1184, 520, -120},
    { 1568, 776, 8},
    { 1952, 784, 216},
    { 1888, 512, 360},
    { 1728, 224, 208},
    { 1432, 488, -120},
    { 1264, 688, -112},
    { 1104, 720, -192},
    { 864, 448, -208},
    { 664, 320, -472},
    { 480, 80, -616},
    { 256, -16, -608},
    { 112, -144, -600},
    { 48, -264, -760},
    // 56 seconds
    { 16, -360, -832},
    { 40, -176, -992},
    { 112, -96, -1080},
    { 312, -176, -992},
    { 424, -248, -920},
    { 256, -160, -864},
    { 96, -104, -904},
    { 56, -104, -912},
    { 80, -128, -936},
    { 88, -144, -920},
    { 128, -168, -896},
    { 184, -272, -1072},
    { 24, -40, -1144},
    { -128, 144, -1048},
    { -192, 208, -960},
    { -248, 336, -1000},
    { -224, 416, -1072},
    { -48, 440, -1128},
    { -80, 408, -1080},
    { -152, 232, -1040},
    { -200, 184, -1000},
    { -224, 184, -984},
    { -264, 208, -880},
    { -264, 216, -832},
    { -192, 176, -872},
    // 57 seconds
    { -192, 456, -1024},
    { -256, 560, -968},
    { -280, 528, -896},
    { -272, 512, -912},
    { -272, 560, -952},
    { -248, 568, -976},
    { -232, 344, -904},
    { -216, 320, -912},
    { -240, 280, -912},
    { -656, 264, -952},
    { -272, 232, -888},
    { -272, 272, -904},
    { -264, 304, -912},
    { -264, 312, -928},
    { -232, 320, -944},
    { -208, 160, -952},
    { -128, 104, -792},
    { -128, 160, -720},
    { -72, 592, -552},
    { -152, 896, -224},
    { -336, 1056, 120},
    { -368, 1480, 312},
    { -544, 1232, 128},
    { -496, 888, 168},
    { -416, 1128, -72},
    // 58 seconds
    { -360, 896, 128},
    { -336, 944, 352},
    { -288, 872, 440},
    { -320, 800, 480},
    { -384, 808, 464},
    { -432, 824, 440},
    { -408, 808, 432},
    { -408, 872, 504},
    { -376, 832, 464},
    { -304, 736, 304},
    { -368, 824, 472},
    { -416, 792, 544},
    { -448, 744, 512},
    { -432, 720, 448},
    { -400, 736, 400},
    { -384, 760, 464},
    { -408, 752, 496},
    { -424, 776, 528},
    { -416, 760, 464},
    { -416, 736, 512},
    { -440, 840, 528},
    { -456, 776, 488},
    { -432, 752, 488},
    { -392, 776, 488},
    { -392, 752, 488},
    // 59 seconds
    { -456, 776, 480},
    { -408, 792, 432},
    { -392, 824, 504},
    { -432, 808, 512},
    { -432, 768, 472},
    { -400, 808, 448},
    { -392, 752, 456},
    { -464, 792, 488},
    { -400, 784, 440},
    { -392, 832, 440},
    { -408, 776, 480},
    { -448, 704, 480},
    { -432, 840, 448},
    { -432, 760, 448},
    { -424, 736, 424},
    { -400, 808, 448},
    { -424, 784, 496},
    { -448, 776, 464},
    { -432, 760, 456},
    { -384, 800, 424},
    { -408, 800, 520},
    { -432, 744, 504},
    { -440, 792, 480},
    { -416, 856, 488},
    { -400, 840, 448},
    // 60 seconds
    // elapsed: 1 minutes
    { -464, 744, 472},
    { -448, 776, 512},
    { -432, 768, 496},
    { -392, 784, 440},
    { -368, 768, 456},
    { -424, 744, 464},
    { -464, 800, 456},
    { -408, 824, 424},
    { -400, 792, 464},
    { -496, 776, 512},
    { -432, 792, 416},
    { -408, 784, 344},
    { -408, 680, 456},
    { -416, 752, 568},
    { -416, 904, 424},
    { -360, 744, 336},
    { -432, 912, 400},
    { -464, 832, 488},
    { -416, 776, 376},
    { -400, 824, 400},
    { -416, 792, 432},
    { -384, 768, 416},
    { -400, 824, 456},
    { -448, 896, 472},
    { -424, 784, 416},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-28 17:10:23 local
AccelRawData *activity_sample_100_steps_heather_18(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_heather_18
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 30
  //> TEST_EXPECTED_MAX 105
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 0, 80, -1016},
    { 16, 56, -1000},
    { 184, -544, -944},
    { -112, 32, -976},
    { -136, 216, -976},
    { -88, -176, -968},
    { 48, -48, -1128},
    { -64, 0, -1184},
    { 152, 128, -1056},
    { 88, 32, -1000},
    { 112, 32, -1088},
    { -40, -16, -1056},
    { -40, -112, -1008},
    { 32, -56, -1008},
    { -16, 32, -1040},
    { -112, -8, -1008},
    { -88, 0, -1000},
    { -120, -8, -1024},
    { 128, -176, -1064},
    { -8, 0, -1088},
    { 56, -8, -1056},
    { 80, 8, -1032},
    { 120, 8, -1008},
    { 152, 16, -984},
    { 248, -136, -1072},
    // 1 seconds
    { 136, 24, -1016},
    { 136, 32, -1048},
    { 144, 24, -1048},
    { 136, 16, -1032},
    { 136, 48, -1008},
    { 144, 40, -1008},
    { 144, 24, -1040},
    { 160, 24, -1024},
    { 128, -8, -1032},
    { 112, 0, -1064},
    { 152, 48, -1048},
    { 112, 56, -1048},
    { 104, 64, -1048},
    { 40, 8, -1040},
    { -16, 24, -1072},
    { -136, 0, -1008},
    { -40, 24, -1016},
    { -64, 16, -984},
    { -80, -32, -928},
    { -80, -16, -968},
    { -56, 88, -936},
    { -8, 392, -952},
    { -272, 584, -848},
    { -296, 464, -712},
    { -344, 712, -656},
    // 2 seconds
    { -304, 648, -512},
    { -360, 664, -496},
    { -368, 768, -400},
    { -360, 960, -384},
    { -256, 1152, -328},
    { -256, 1088, -488},
    { -256, 1048, -632},
    { -248, 1112, -744},
    { -136, 1016, -768},
    { -120, 960, -736},
    { -64, 816, -704},
    { -48, 752, -568},
    { 168, 1008, -800},
    { 392, 1056, -384},
    { 992, 848, -456},
    { 848, 816, -312},
    { 688, 568, -152},
    { 744, 416, -32},
    { 832, 424, -16},
    { 888, 448, 24},
    { 968, 408, 80},
    { 1152, 384, 112},
    { 1512, 432, 32},
    { 1696, 472, -112},
    { 1872, 528, -40},
    // 3 seconds
    { 1768, 552, -72},
    { 1840, 536, -112},
    { 1608, 520, -128},
    { 1344, 568, -144},
    { 960, 856, -280},
    { 384, 848, -544},
    { 696, 616, -168},
    { 1080, 704, 96},
    { 1648, 496, 128},
    { 1520, 256, 128},
    { 1568, 256, 24},
    { 1664, 288, 104},
    { 1736, 296, 168},
    { 1784, 336, 80},
    { 1640, 304, 32},
    { 1560, 208, -16},
    { 1464, 136, -248},
    { 1048, -152, -384},
    { 800, -504, 88},
    { 992, -296, -48},
    { 1168, 120, -360},
    { 1112, 128, -128},
    { 1456, 128, -64},
    { 1448, 232, -232},
    { 1520, 304, -240},
    // 4 seconds
    { 1560, 312, -24},
    { 1352, 488, 0},
    { 1144, 496, -224},
    { 1208, 320, -96},
    { 1792, 456, 272},
    { 1184, 776, 392},
    { 856, 936, 120},
    { 1216, 968, 120},
    { 712, 744, -104},
    { 864, 616, 32},
    { 1264, 728, 152},
    { 1784, 680, 280},
    { 1600, 416, 216},
    { 1696, 88, 184},
    { 1576, 8, 136},
    { 1544, 152, 24},
    { 1352, 184, 8},
    { 1312, 192, -48},
    { 1456, 200, -280},
    { 1080, -112, -216},
    { 832, -496, 176},
    { 1104, -152, -56},
    { 1264, 264, -384},
    { 1208, 152, -136},
    { 1704, 128, -144},
    // 5 seconds
    { 1584, 280, -256},
    { 1360, 344, -192},
    { 1112, 416, -96},
    { 1064, 432, -144},
    { 1176, 248, -64},
    { 1200, 328, 48},
    { 1576, 624, 136},
    { 1104, 920, 304},
    { 1192, 1088, -120},
    { 1024, 624, -184},
    { 952, 600, -152},
    { 1352, 696, 48},
    { 1800, 640, 184},
    { 1664, 392, 136},
    { 1520, 88, 176},
    { 1312, -152, 144},
    { 1176, 56, 0},
    { 1128, 136, -112},
    { 1032, 152, -8},
    { 1304, 168, -104},
    { 1024, 136, -216},
    { 1056, 16, -16},
    { 1184, 24, 64},
    { 1168, 184, -112},
    { 1336, 176, -88},
    // 6 seconds
    { 1528, 208, -104},
    { 1280, 296, -224},
    { 1072, 320, -168},
    { 1056, 360, -144},
    { 1040, 376, -24},
    { 1056, 352, -144},
    { 1192, 328, -32},
    { 1840, 520, 64},
    { 976, 752, 160},
    { 1168, 816, -184},
    { 1152, 752, -216},
    { 888, 584, -144},
    { 1368, 600, 0},
    { 1672, 552, 96},
    { 1472, 240, 80},
    { 1320, 40, 96},
    { 1200, 16, 40},
    { 1176, 112, -32},
    { 1096, 168, -40},
    { 1024, 184, -8},
    { 1320, 152, -56},
    { 1056, 160, -192},
    { 1128, 64, -152},
    { 1176, 56, -72},
    { 1032, 128, -216},
    // 7 seconds
    { 1168, 136, -224},
    { 1488, 160, -272},
    { 1216, 224, -264},
    { 976, 272, -136},
    { 984, 304, -144},
    { 1008, 360, -112},
    { 1000, 336, -104},
    { 1112, 344, -72},
    { 1608, 552, 48},
    { 1168, 784, 40},
    { 1136, 768, -192},
    { 1384, 672, -160},
    { 848, 608, -216},
    { 1104, 576, -48},
    { 1520, 600, 72},
    { 1376, 368, 56},
    { 1240, 96, 48},
    { 1176, -8, 48},
    { 1216, 112, -16},
    { 1160, 184, -40},
    { 1064, 192, -24},
    { 1320, 192, -120},
    { 1120, 104, -184},
    { 1000, -48, -16},
    { 1184, -88, 56},
    // 8 seconds
    { 1216, 152, -272},
    { 1280, 168, -272},
    { 1432, 160, -312},
    { 1152, 200, -336},
    { 880, 216, -168},
    { 960, 240, -136},
    { 1096, 344, -88},
    { 1040, 360, -112},
    { 1056, 344, -168},
    { 1544, 448, -72},
    { 1280, 608, -8},
    { 1208, 760, -8},
    { 1256, 752, -344},
    { 848, 504, -232},
    { 1152, 568, 0},
    { 1480, 576, 96},
    { 1312, 328, 128},
    { 1136, 144, 144},
    { 1152, 0, 64},
    { 1168, 40, 16},
    { 1168, 208, -88},
    { 1136, 144, -96},
    { 1344, 104, -56},
    { 1040, 120, -184},
    { 1056, -8, -120},
    // 9 seconds
    { 1160, 8, -64},
    { 1072, 192, -288},
    { 1256, 104, -256},
    { 1448, 72, -240},
    { 1168, 200, -288},
    { 920, 272, -272},
    { 824, 304, -208},
    { 840, 320, -56},
    { 928, 296, -120},
    { 1072, 320, -120},
    { 1672, 464, -16},
    { 1296, 592, 8},
    { 1248, 672, 64},
    { 1352, 912, -288},
    { 864, 408, -184},
    { 1104, 416, -40},
    { 1496, 568, 56},
    { 1400, 424, 8},
    { 1208, 144, 8},
    { 1088, 24, 32},
    { 1048, 56, 0},
    { 1056, 168, -96},
    { 984, 160, -40},
    { 1112, 152, 8},
    { 1312, 160, -104},
    // 10 seconds
    { 1008, 152, -112},
    { 1208, 120, -24},
    { 1200, 176, -160},
    { 1096, 192, -176},
    { 1416, 184, -216},
    { 1336, 216, -304},
    { 1040, 280, -240},
    { 880, 296, -200},
    { 848, 320, -112},
    { 952, 344, -80},
    { 1008, 328, -128},
    { 1224, 416, -32},
    { 1576, 616, 8},
    { 976, 736, 48},
    { 1272, 736, -120},
    { 1256, 592, -128},
    { 936, 496, -104},
    { 1208, 512, -24},
    { 1568, 416, 32},
    { 1512, 120, 80},
    { 1192, -56, 32},
    { 1128, -8, 40},
    { 1160, 136, 0},
    { 1088, 248, -48},
    { 952, 240, -32},
    // 11 seconds
    { 1176, 208, 0},
    { 1136, 192, -184},
    { 1000, 104, -152},
    { 1072, -24, 40},
    { 1104, 104, -112},
    { 1088, 184, -168},
    { 1496, 224, -232},
    { 1392, 280, -304},
    { 1016, 304, -224},
    { 896, 264, -248},
    { 928, 288, -136},
    { 984, 280, -80},
    { 1040, 280, -88},
    { 1384, 368, 40},
    { 1512, 576, 80},
    { 1080, 720, 80},
    { 1248, 784, -192},
    { 1104, 712, -224},
    { 744, 512, -128},
    { 1080, 528, 8},
    { 1416, 480, 72},
    { 1456, 240, 48},
    { 1224, 88, 80},
    { 1160, 40, 40},
    { 1136, 104, 0},
    // 12 seconds
    { 1072, 208, -56},
    { 976, 192, -32},
    { 1088, 168, 8},
    { 1336, 184, -112},
    { 1024, 152, -128},
    { 1280, 32, -56},
    { 1304, 72, -72},
    { 1048, 152, -296},
    { 1128, 136, -344},
    { 1176, 104, -256},
    { 1016, 160, -184},
    { 960, 232, -144},
    { 976, 320, -96},
    { 1008, 400, 0},
    { 1056, 392, -80},
    { 1000, 376, -80},
    { 1440, 456, 16},
    { 1296, 584, -16},
    { 976, 616, -32},
    { 1280, 640, -208},
    { 984, 584, -240},
    { 1064, 528, -96},
    { 1368, 528, 16},
    { 1432, 336, 0},
    { 1240, 144, 24},
    // 13 seconds
    { 1176, 40, 40},
    { 1096, 64, 16},
    { 1064, 176, -8},
    { 992, 184, -64},
    { 968, 152, -8},
    { 1272, 144, -56},
    { 1144, 176, -144},
    { 1240, 96, -176},
    { 1168, 64, -136},
    { 1200, 112, -200},
    { 1088, 128, -264},
    { 1272, 184, -304},
    { 1200, 200, -288},
    { 904, 216, -192},
    { 824, 248, -144},
    { 880, 280, -88},
    { 912, 328, -104},
    { 888, 360, -192},
    { 1000, 376, -168},
    { 1528, 432, -96},
    { 1152, 512, -88},
    { 1200, 536, -104},
    { 1288, 600, -248},
    { 984, 552, -272},
    { 1152, 560, -96},
    // 14 seconds
    { 1432, 464, 56},
    { 1448, 224, 40},
    { 1184, 40, 40},
    { 1064, 16, 32},
    { 1048, 112, -40},
    { 1016, 192, -96},
    { 920, 208, -88},
    { 864, 144, -40},
    { 1232, 152, -72},
    { 1112, 168, -232},
    { 1264, 112, -160},
    { 1432, 72, -8},
    { 1320, 160, -272},
    { 1096, 184, -320},
    { 1232, 112, -288},
    { 1016, 160, -240},
    { 864, 192, -120},
    { 896, 312, -96},
    { 904, 384, -16},
    { 952, 392, -40},
    { 968, 344, -144},
    { 1312, 392, -96},
    { 1480, 512, -56},
    { 1120, 576, 8},
    { 1360, 736, -168},
    // 15 seconds
    { 1016, 680, -376},
    { 944, 432, -88},
    { 1232, 528, 56},
    { 1464, 336, 40},
    { 1208, 120, 0},
    { 1048, 80, -8},
    { 1080, 88, -8},
    { 1128, 176, -56},
    { 1112, 216, -40},
    { 1032, 168, 0},
    { 1320, 168, -56},
    { 1120, 176, -192},
    { 1136, 80, -152},
    { 1232, 40, -56},
    { 1120, 120, -256},
    { 1032, 144, -264},
    { 1272, 144, -256},
    { 1160, 224, -200},
    { 992, 248, -176},
    { 992, 296, -176},
    { 952, 320, -80},
    { 984, 336, -72},
    { 888, 296, -144},
    { 984, 360, -64},
    { 1616, 512, 8},
    // 16 seconds
    { 1000, 640, 32},
    { 1200, 640, -208},
    { 1328, 600, -216},
    { 760, 544, -136},
    { 1168, 528, 16},
    { 1608, 456, 0},
    { 1312, 248, 40},
    { 1176, 32, 88},
    { 1104, 0, 56},
    { 1080, 128, -8},
    { 1064, 232, -40},
    { 1016, 224, 8},
    { 1288, 200, 0},
    { 1232, 208, -168},
    { 1160, 88, -72},
    { 1144, 32, -16},
    { 1016, 152, -216},
    { 1072, 168, -320},
    { 1192, 160, -248},
    { 1024, 160, -248},
    { 800, 144, -200},
    { 904, 200, -208},
    { 928, 248, -160},
    { 944, 288, -144},
    { 888, 320, -176},
    // 17 seconds
    { 1464, 384, -40},
    { 1456, 480, -64},
    { 1056, 552, -16},
    { 1416, 552, -224},
    { 952, 544, -288},
    { 832, 480, -136},
    { 1216, 504, 24},
    { 1384, 384, 8},
    { 1056, 168, 16},
    { 976, 0, 48},
    { 992, 16, 8},
    { 1016, 192, -56},
    { 1032, 304, -88},
    { 1056, 272, -40},
    { 1504, 248, -112},
    { 1144, 200, -240},
    { 1296, 96, -152},
    { 1232, -32, -8},
    { 880, 80, -208},
    { 968, 120, -208},
    { 1088, 136, -144},
    { 904, 208, -168},
    { 816, 232, -128},
    { 864, 240, -72},
    { 976, 288, -24},
    // 18 seconds
    { 1136, 288, -56},
    { 1048, 352, -112},
    { 1464, 416, -64},
    { 1472, 616, -176},
    { 1016, 760, -192},
    { 1384, 424, -296},
    { 1040, 408, -296},
    { 848, 456, -216},
    { 1120, 448, -128},
    { 1336, 352, -48},
    { 1136, 192, -8},
    { 1080, 32, 8},
    { 1032, 80, 40},
    { 1016, 200, -32},
    { 968, 328, -40},
    { 928, 328, 96},
    { 1288, 312, 136},
    { 1312, 376, -56},
    { 1104, 312, -120},
    { 1336, 200, -72},
    { 1080, 328, -248},
    { 856, 144, -168},
    { 1032, -32, -200},
    { 952, 24, -240},
    { 880, 96, -232},
    // 19 seconds
    { 928, 248, -200},
    { 1016, 288, -184},
    { 1088, 312, -176},
    { 992, 328, -200},
    { 1088, 408, -168},
    { 1592, 536, -176},
    { 1040, 648, -64},
    { 1240, 392, -224},
    { 1344, 392, -176},
    { 1032, 528, -176},
    { 1136, 456, -72},
    { 1272, 320, 24},
    { 1152, 200, 32},
    { 944, 152, 96},
    { 936, 184, 88},
    { 1008, 240, 144},
    { 1072, 264, 168},
    { 1232, 272, 72},
    { 1256, 232, 32},
    { 1344, 152, -152},
    { 1144, 72, -208},
    { 1040, -32, -80},
    { 1080, 8, -176},
    { 832, 64, -368},
    { 984, 40, -408},
    // 20 seconds
    { 1152, 56, -264},
    { 896, 80, -232},
    { 880, 112, -352},
    { 928, 128, -360},
    { 1016, 112, -392},
    { 1024, 80, -400},
    { 872, 176, -408},
    { 1288, 400, -320},
    { 1464, 496, -216},
    { 928, 376, -80},
    { 1456, 432, -56},
    { 1248, 520, -72},
    { 848, 520, -104},
    { 1120, 480, -8},
    { 1112, 384, 48},
    { 840, 248, -32},
    { 760, 136, 0},
    { 856, 152, -32},
    { 992, 192, -48},
    { 1080, 200, -8},
    { 1112, 176, -40},
    { 1472, 160, -104},
    { 1408, 152, -264},
    { 1296, 32, -272},
    { 1272, -16, -184},
    // 21 seconds
    { 1088, 64, -456},
    { 1016, 80, -336},
    { 1128, 48, -112},
    { 984, 104, -176},
    { 752, 144, -168},
    { 704, 176, -128},
    { 752, 216, -80},
    { 888, 248, -56},
    { 880, 296, -152},
    { 1136, 328, -80},
    { 1840, 400, -56},
    { 1136, 624, 24},
    { 1256, 920, -192},
    { 1304, 656, -136},
    { 808, 552, -168},
    { 1048, 632, -120},
    { 1440, 624, -8},
    { 1488, 320, 96},
    { 1320, -40, 168},
    { 1128, -24, 32},
    { 1128, 80, 8},
    { 1088, 208, -16},
    { 968, 264, -24},
    { 992, 232, -16},
    { 1256, 208, -96},
    // 22 seconds
    { 1040, 160, -296},
    { 1152, 0, -104},
    { 1256, -56, -8},
    { 1152, 88, -216},
    { 1288, 144, -240},
    { 1360, 192, -336},
    { 1032, 200, -240},
    { 872, 216, -112},
    { 968, 264, -24},
    { 1112, 280, 24},
    { 1272, 320, -56},
    { 1168, 400, -40},
    { 1456, 536, 24},
    { 1232, 664, 192},
    { 1224, 904, 0},
    { 1040, 720, -240},
    { 888, 376, -72},
    { 1048, 512, 48},
    { 1528, 512, 112},
    { 1408, 312, 32},
    { 1296, 136, 64},
    { 1184, 64, 48},
    { 1136, 104, -40},
    { 1056, 160, -32},
    { 968, 112, -40},
    // 23 seconds
    { 1144, 104, 8},
    { 1352, 168, -56},
    { 1056, 200, -224},
    { 1176, 128, -176},
    { 1360, 168, -144},
    { 1152, 176, -224},
    { 1168, 160, -248},
    { 1280, 152, -216},
    { 1080, 208, -200},
    { 872, 256, -208},
    { 888, 296, -128},
    { 896, 320, -120},
    { 968, 304, -192},
    { 984, 344, -112},
    { 1360, 480, 72},
    { 1368, 672, 72},
    { 784, 720, -128},
    { 1304, 528, -72},
    { 1136, 600, -72},
    { 1000, 584, -56},
    { 1368, 544, 128},
    { 1616, 360, 160},
    { 1304, 136, 48},
    { 1168, 40, 40},
    { 1208, 40, 0},
    // 24 seconds
    { 1208, 152, -32},
    { 1128, 200, -72},
    { 1000, 168, -96},
    { 1176, 96, -152},
    { 992, 0, -232},
    { 1000, -88, 40},
    { 1424, 16, -8},
    { 1368, 256, -240},
    { 1456, 240, -208},
    { 1424, 184, -256},
    { 1064, 224, -168},
    { 872, 264, -144},
    { 968, 304, -56},
    { 1096, 344, -24},
    { 1184, 360, -112},
    { 1040, 480, -80},
    { 1568, 648, -48},
    { 1032, 928, -24},
    { 1088, 512, -136},
    { 1288, 440, -80},
    { 1048, 568, -176},
    { 1360, 560, -8},
    { 1632, 496, 64},
    { 1520, 272, 64},
    { 1256, 128, 64},
    // 25 seconds
    { 1184, 32, 72},
    { 1144, 72, 56},
    { 1112, 152, -32},
    { 976, 184, -32},
    { 1008, 144, 16},
    { 1200, 136, -80},
    { 904, 104, -184},
    { 1072, 8, -88},
    { 1288, 72, -80},
    { 1168, 176, -208},
    { 1448, 184, -224},
    { 1592, 232, -312},
    { 1240, 344, -208},
    { 960, 312, -152},
    { 1048, 360, -80},
    { 1160, 352, -96},
    { 1112, 384, -64},
    { 1024, 496, 64},
    { 1296, 704, 72},
    { 928, 848, -8},
    { 1288, 656, -64},
    { 1248, 536, -80},
    { 1104, 472, -40},
    { 1376, 520, 48},
    { 1720, 456, 152},
    // 26 seconds
    { 1616, 192, 160},
    { 1224, 56, 128},
    { 1104, -8, 144},
    { 1024, 80, 72},
    { 920, 200, 24},
    { 840, 216, 8},
    { 1144, 208, 16},
    { 1024, 192, -48},
    { 1072, 160, -64},
    { 1296, 120, 0},
    { 1256, 224, -160},
    { 1232, 208, -280},
    { 1352, 168, -312},
    { 1176, 176, -304},
    { 952, 136, -216},
    { 968, 248, -224},
    { 1064, 288, -128},
    { 992, 320, -112},
    { 976, 352, -88},
    { 1480, 424, 72},
    { 1296, 584, 120},
    { 1064, 704, 48},
    { 1488, 832, -176},
    { 848, 520, -144},
    { 960, 416, -24},
    // 27 seconds
    { 1352, 520, 48},
    { 1384, 368, -8},
    { 1096, 152, 0},
    { 1040, 48, 56},
    { 1096, 72, 16},
    { 1224, 184, -40},
    { 1128, 240, 0},
    { 1248, 176, 16},
    { 1248, 128, -72},
    { 856, 72, -40},
    { 944, 24, 16},
    { 1224, 192, -128},
    { 1120, 280, -280},
    { 1360, 256, -264},
    { 1272, 160, -312},
    { 744, 64, -184},
    { 768, -32, -192},
    { 832, 8, -120},
    { 1008, 176, -64},
    { 1080, 352, -176},
    { 960, 432, -160},
    { 1576, 440, -64},
    { 1288, 504, -48},
    { 1408, 528, -64},
    { 1312, 776, -368},
    // 28 seconds
    { 744, 400, -208},
    { 1032, 424, 56},
    { 1504, 496, 0},
    { 1216, 344, -48},
    { 1088, 104, -32},
    { 1056, -24, 24},
    { 1080, 168, -8},
    { 1104, 288, -48},
    { 1072, 288, -56},
    { 1232, 200, -56},
    { 1216, 200, -256},
    { 1048, 56, -192},
    { 1128, -64, 72},
    { 1264, 88, -64},
    { 1248, 216, -176},
    { 1432, 256, -224},
    { 1216, 240, -184},
    { 888, 240, -64},
    { 896, 256, -72},
    { 960, 304, 16},
    { 1008, 360, -16},
    { 984, 392, -136},
    { 1064, 416, -16},
    { 1520, 544, 80},
    { 1048, 840, 32},
    // 29 seconds
    { 1080, 728, -288},
    { 1280, 488, -104},
    { 944, 584, -120},
    { 1392, 584, 16},
    { 1656, 544, 72},
    { 1448, 344, 104},
    { 1344, 88, 104},
    { 1296, -32, 112},
    { 1168, 168, 0},
    { 1048, 232, -24},
    { 808, 240, -88},
    { 840, 184, -56},
    { 984, 120, -112},
    { 968, 88, -104},
    { 1280, 32, 136},
    { 1368, 168, 112},
    { 1400, 296, -104},
    { 1568, 336, -128},
    { 1456, 328, -104},
    { 1136, 200, -136},
    { 1048, 272, -120},
    { 1040, 272, 24},
    { 1096, 336, 24},
    { 1120, 408, 0},
    { 976, 480, 120},
    // 30 seconds
    { 1656, 664, 64},
    { 984, 880, 184},
    { 1016, 752, -96},
    { 1464, 520, 40},
    { 960, 600, -168},
    { 1280, 496, -64},
    { 1552, 496, 0},
    { 1424, 360, -48},
    { 1304, 312, 0},
    { 1376, 168, 64},
    { 1304, 80, 32},
    { 1120, 120, -16},
    { 984, 120, -8},
    { 1032, 120, 8},
    { 1200, 144, -48},
    { 880, 144, -120},
    { 1088, 64, 0},
    { 1320, 152, -24},
    { 1208, 224, -120},
    { 1424, 192, -16},
    { 1456, 256, -176},
    { 1104, 296, -224},
    { 960, 256, -160},
    { 992, 264, -24},
    { 1128, 328, 0},
    // 31 seconds
    { 1120, 368, -72},
    { 1160, 352, -80},
    { 1552, 536, 40},
    { 1128, 1016, 64},
    { 1056, 952, -360},
    { 1376, 336, -8},
    { 936, 512, -216},
    { 1152, 512, -64},
    { 1456, 512, 72},
    { 1536, 384, 88},
    { 1408, 176, 104},
    { 1328, 104, 144},
    { 1336, 160, 96},
    { 1344, 216, 64},
    { 1128, 240, -16},
    { 928, 160, 16},
    { 1152, 112, -104},
    { 808, 0, -208},
    { 904, -128, 8},
    { 1256, 8, -16},
    { 1264, 232, -208},
    { 1512, 232, -192},
    { 1576, 248, -392},
    { 1144, 248, -320},
    { 920, 120, -184},
    // 32 seconds
    { 1064, 216, -104},
    { 1192, 304, -16},
    { 1216, 408, -96},
    { 1136, 464, -104},
    { 1504, 552, 0},
    { 1032, 800, 64},
    { 1184, 760, -224},
    { 1272, 440, -64},
    { 920, 496, -104},
    { 1208, 496, -16},
    { 1536, 480, -24},
    { 1384, 344, 16},
    { 1288, 224, 64},
    { 1288, 112, 104},
    { 1288, 104, 40},
    { 1144, 144, -24},
    { 952, 160, -16},
    { 968, 112, 56},
    { 1216, 152, -104},
    { 960, 128, -144},
    { 1160, 48, 32},
    { 1408, 128, -112},
    { 1312, 232, -248},
    { 1352, 184, -296},
    { 1232, 192, -352},
    // 33 seconds
    { 920, 192, -176},
    { 832, 216, -136},
    { 904, 336, -112},
    { 1000, 352, -80},
    { 1032, 384, -136},
    { 1216, 376, -128},
    { 1552, 432, -8},
    { 1112, 560, -8},
    { 1256, 680, -48},
    { 1296, 736, -264},
    { 808, 464, -208},
    { 1136, 472, -8},
    { 1552, 512, 64},
    { 1448, 312, 56},
    { 1240, 112, 32},
    { 1152, -8, 56},
    { 1096, 96, -8},
    { 1088, 168, -64},
    { 1016, 192, -64},
    { 1136, 168, -16},
    { 1312, 168, -184},
    { 1040, 96, -160},
    { 1176, 8, -8},
    { 1152, 120, -128},
    { 1048, 176, -184},
    // 34 seconds
    { 1296, 168, -136},
    { 1360, 232, -216},
    { 1104, 288, -144},
    { 976, 304, -136},
    { 1008, 336, -72},
    { 1056, 360, -56},
    { 992, 352, -136},
    { 1072, 360, -88},
    { 1616, 512, 8},
    { 1080, 656, 64},
    { 1312, 752, -120},
    { 1328, 624, -232},
    { 808, 512, -168},
    { 1096, 576, -8},
    { 1560, 488, 80},
    { 1448, 144, 88},
    { 1152, 24, 16},
    { 1104, 104, 0},
    { 1160, 216, 0},
    { 1192, 264, -8},
    { 1104, 280, -88},
    { 1072, 192, -120},
    { 1264, 128, -224},
    { 1120, 0, -264},
    { 1312, -176, 144},
    // 35 seconds
    { 1160, 0, -144},
    { 1112, 152, -248},
    { 1360, 168, -280},
    { 1376, 216, -272},
    { 1200, 272, -80},
    { 1040, 352, -56},
    { 952, 432, 16},
    { 1064, 416, -128},
    { 1136, 368, -104},
    { 1264, 512, -8},
    { 1376, 744, 96},
    { 888, 936, -88},
    { 1312, 632, -80},
    { 1048, 536, -112},
    { 1136, 552, -96},
    { 1472, 560, 88},
    { 1776, 448, 128},
    { 1496, 288, 72},
    { 1400, 168, 104},
    { 1336, 112, 112},
    { 1288, 144, 48},
    { 1168, 168, -16},
    { 1024, 168, 24},
    { 1168, 120, 0},
    { 936, 104, -112},
    // 36 seconds
    { 904, 24, -72},
    { 1176, 72, -16},
    { 1240, 208, -192},
    { 1408, 216, -224},
    { 1608, 192, -224},
    { 1352, 232, -280},
    { 1064, 240, -248},
    { 1040, 296, -224},
    { 1040, 352, -136},
    { 1064, 352, -144},
    { 1056, 352, -112},
    { 1368, 552, -96},
    { 1376, 704, -64},
    { 968, 800, -96},
    { 1416, 520, -112},
    { 992, 424, -160},
    { 1112, 464, -120},
    { 1456, 544, -8},
    { 1624, 464, 64},
    { 1400, 248, 72},
    { 1280, 88, 88},
    { 1184, 24, 56},
    { 1120, 88, -16},
    { 1016, 160, -72},
    { 896, 160, -96},
    // 37 seconds
    { 1064, 128, -88},
    { 1008, 128, -264},
    { 976, 40, -208},
    { 1216, -16, -16},
    { 1280, 120, -152},
    { 1304, 176, -136},
    { 1568, 208, -168},
    { 1384, 280, -256},
    { 1088, 304, -176},
    { 1008, 272, -136},
    { 1016, 344, -16},
    { 1120, 360, -80},
    { 1032, 328, -112},
    { 1336, 480, 16},
    { 1416, 800, -24},
    { 872, 928, -152},
    { 1280, 504, -152},
    { 1104, 472, -184},
    { 1000, 488, -160},
    { 1376, 624, 0},
    { 1704, 520, 56},
    { 1448, 320, 96},
    { 1368, 64, 128},
    { 1296, -24, 88},
    { 1224, 64, -24},
    // 38 seconds
    { 1096, 152, -128},
    { 880, 120, -144},
    { 888, 56, -64},
    { 1000, 80, -216},
    { 880, 64, -280},
    { 1168, 8, -56},
    { 1352, 96, -120},
    { 1368, 176, -184},
    { 1576, 216, -136},
    { 1416, 256, -256},
    { 1056, 272, -208},
    { 984, 264, -144},
    { 1016, 280, -24},
    { 1112, 320, -16},
    { 1112, 360, -128},
    { 1128, 488, -56},
    { 1616, 696, -56},
    { 944, 1168, 88},
    { 1072, 496, -240},
    { 1152, 496, -16},
    { 976, 608, -168},
    { 1392, 552, 24},
    { 1656, 504, 56},
    { 1424, 328, 8},
    { 1336, 160, 32},
    // 39 seconds
    { 1376, 64, 72},
    { 1360, 120, 8},
    { 1200, 168, -88},
    { 992, 144, -104},
    { 1104, 104, -56},
    { 1072, 72, -280},
    { 776, 0, -136},
    { 1072, -32, 64},
    { 1248, 168, -184},
    { 1416, 256, -344},
    { 1672, 256, -200},
    { 1360, 296, -40},
    { 872, 168, -120},
    { 864, 232, -120},
    { 976, 272, -48},
    { 1064, 312, -32},
    { 1024, 376, -104},
    { 1232, 440, 16},
    { 1592, 608, 72},
    { 1008, 1080, 160},
    { 1376, 824, -352},
    { 1048, 360, -80},
    { 960, 448, -120},
    { 1416, 584, -16},
    { 1632, 512, 16},
    // 40 seconds
    { 1368, 280, 16},
    { 1224, 72, 56},
    { 1112, 48, 80},
    { 1104, 120, 56},
    { 1080, 176, -16},
    { 952, 208, -8},
    { 1104, 168, 24},
    { 1096, 152, -112},
    { 952, 144, -160},
    { 1192, 56, -24},
    { 1280, 152, -88},
    { 1200, 192, -248},
    { 1472, 176, -248},
    { 1344, 208, -280},
    { 1000, 224, -184},
    { 944, 248, -152},
    { 1016, 304, -40},
    { 1096, 352, -24},
    { 1080, 400, -72},
    { 1256, 440, 56},
    { 1496, 584, 168},
    { 1008, 768, 152},
    { 1136, 888, -184},
    { 1272, 608, -168},
    { 992, 552, -160},
    // 41 seconds
    { 1376, 680, -40},
    { 1816, 552, 40},
    { 1720, 104, 184},
    { 1232, -176, 104},
    { 1032, 16, 16},
    { 1088, 144, 64},
    { 1112, 248, 56},
    { 968, 296, 8},
    { 872, 232, 48},
    { 1112, 176, -32},
    { 904, 160, -144},
    { 1072, 56, -32},
    { 1336, 72, 0},
    { 1280, 200, -256},
    { 1544, 216, -248},
    { 1480, 216, -408},
    { 1072, 208, -320},
    { 976, 200, -104},
    { 1048, 248, -56},
    { 1176, 336, 8},
    { 1144, 392, -16},
    { 992, 440, -48},
    { 1384, 520, 96},
    { 1136, 664, 232},
    { 976, 808, -8},
    // 42 seconds
    { 1296, 560, -56},
    { 1032, 560, -96},
    { 1136, 560, -16},
    { 1392, 560, 40},
    { 1496, 496, 40},
    { 1408, 264, 120},
    { 1352, 40, 120},
    { 1216, 0, 104},
    { 1128, 120, 16},
    { 1016, 168, -24},
    { 888, 200, -8},
    { 1168, 168, 32},
    { 976, 176, -96},
    { 1000, 120, -72},
    { 1232, 96, 16},
    { 1224, 208, -176},
    { 1168, 200, -192},
    { 1408, 176, -208},
    { 1328, 232, -312},
    { 1024, 240, -296},
    { 968, 272, -240},
    { 992, 312, -176},
    { 1072, 304, -136},
    { 968, 304, -176},
    { 936, 376, -88},
    // 43 seconds
    { 1424, 520, 24},
    { 1080, 648, 72},
    { 1416, 680, -56},
    { 1344, 576, -168},
    { 968, 464, -144},
    { 1264, 512, -16},
    { 1576, 560, 88},
    { 1376, 256, 160},
    { 1240, -24, 120},
    { 1048, -32, 72},
    { 1048, 80, -8},
    { 1040, 184, 0},
    { 936, 232, -40},
    { 920, 184, 0},
    { 1128, 168, -72},
    { 952, 176, -240},
    { 1072, 56, -128},
    { 1392, 24, 48},
    { 1288, 176, -264},
    { 1336, 200, -224},
    { 1480, 176, -344},
    { 1176, 216, -256},
    { 944, 192, -168},
    { 920, 288, -80},
    { 992, 336, 8},
    // 44 seconds
    { 1064, 368, 0},
    { 1000, 400, -72},
    { 984, 432, -48},
    { 1448, 512, 40},
    { 1032, 680, 64},
    { 1232, 768, -184},
    { 1320, 448, -160},
    { 816, 456, -176},
    { 1144, 512, -112},
    { 1536, 592, -56},
    { 1664, 448, 184},
    { 1480, 104, 208},
    { 1288, -104, 144},
    { 1184, -8, 88},
    { 1088, 104, 32},
    { 936, 200, -16},
    { 736, 232, -80},
    { 792, 208, -64},
    { 1072, 192, -208},
    { 888, 136, -304},
    { 1096, 24, -8},
    { 1480, 80, -8},
    { 1368, 232, -224},
    { 1408, 288, -248},
    { 1352, 264, -200},
    // 45 seconds
    { 1112, 200, -192},
    { 952, 208, -128},
    { 992, 248, -80},
    { 1048, 288, -16},
    { 1016, 344, 0},
    { 928, 384, -64},
    { 848, 400, -64},
    { 1264, 456, 16},
    { 1152, 656, 56},
    { 1496, 968, -128},
    { 1232, 432, -184},
    { 920, 344, -96},
    { 1104, 448, -96},
    { 1632, 480, -152},
    { 1616, 256, -8},
    { 1464, -24, 88},
    { 1232, -8, -40},
    { 1136, 88, -8},
    { 1032, 176, -24},
    { 888, 216, -40},
    { 704, 208, -104},
    { 688, 152, -104},
    { 968, 152, -120},
    { 824, 136, -200},
    { 824, 72, -96},
    // 46 seconds
    { 1136, 96, 32},
    { 1704, 240, 64},
    { 1808, 432, -112},
    { 1560, 608, -280},
    { 1032, 704, -144},
    { 1032, 128, -232},
    { 1008, 24, 32},
    { 976, 184, -32},
    { 944, 352, -96},
    { 880, 440, -168},
    { 816, 360, -152},
    { 768, 328, -152},
    { 1008, 352, -128},
    { 1320, 488, -184},
    { 992, 520, -112},
    { 1008, 352, -48},
    { 1384, 336, -64},
    { 1344, 432, -176},
    { 1216, 424, -136},
    { 1272, 328, -64},
    { 1368, 240, -24},
    { 1208, 192, 16},
    { 1160, 176, 8},
    { 1088, 184, 24},
    { 1024, 216, 56},
    // 47 seconds
    { 928, 216, 88},
    { 840, 208, 56},
    { 856, 208, 56},
    { 920, 208, 88},
    { 888, 216, 40},
    { 912, 232, -8},
    { 1096, 232, -96},
    { 1208, 256, -312},
    { 1392, 88, -416},
    { 952, -40, -400},
    { 1280, 40, -664},
    { 1624, 192, -480},
    { 1464, 336, -416},
    { 1128, 336, -328},
    { 960, 272, -168},
    { 1064, 304, -120},
    { 1016, 352, -96},
    { 840, 456, -120},
    { 736, 480, -104},
    { 856, 504, -64},
    { 944, 424, -72},
    { 1016, 328, 32},
    { 1384, 336, 40},
    { 1112, 336, 32},
    { 1384, 360, 104},
    // 48 seconds
    { 1408, 392, 48},
    { 1240, 408, 88},
    { 1280, 336, 128},
    { 1336, 272, 184},
    { 1232, 216, 224},
    { 1152, 200, 184},
    { 1056, 208, 120},
    { 984, 248, 96},
    { 952, 232, 128},
    { 1072, 216, 96},
    { 1112, 184, 112},
    { 1208, 192, 40},
    { 1368, 176, -272},
    { 1312, 136, -432},
    { 1200, -64, -280},
    { 1024, -184, -392},
    { 984, -216, -608},
    { 1264, -120, -960},
    { 1200, -184, -784},
    { 1088, -152, -512},
    { 992, -32, -432},
    { 952, 144, -384},
    { 960, 184, -312},
    { 984, 208, -288},
    { 984, 240, -256},
    // 49 seconds
    { 872, 280, -248},
    { 768, 272, -200},
    { 720, 280, -160},
    { 760, 288, -120},
    { 1024, 312, -24},
    { 1384, 384, -72},
    { 1192, 480, -136},
    { 1424, 456, 40},
    { 1528, 368, 144},
    { 1592, 272, 80},
    { 1264, 208, 48},
    { 1168, 160, 88},
    { 1120, 136, 0},
    { 976, 152, -224},
    { 880, 120, -376},
    { 832, 64, -320},
    { 840, -40, -264},
    { 1064, -16, -288},
    { 1088, 48, -312},
    { 1264, 80, -112},
    { 1704, 128, 8},
    { 1456, 320, -64},
    { 1224, 360, -48},
    { 1152, 328, 64},
    { 1208, 320, 64},
    // 50 seconds
    { 1088, 304, 24},
    { 1064, 320, 72},
    { 992, 344, 104},
    { 984, 344, 64},
    { 1024, 384, -8},
    { 808, 344, -200},
    { 984, 392, -384},
    { 1376, 488, -248},
    { 1096, 544, -280},
    { 1240, 536, -312},
    { 1232, 504, -360},
    { 824, 416, -240},
    { 1064, 408, -80},
    { 1288, 368, 8},
    { 1400, 280, 24},
    { 1312, 184, 48},
    { 1304, 104, 88},
    { 1280, 120, 24},
    { 1248, 200, -72},
    { 1200, 184, -64},
    { 1032, 152, -216},
    { 880, 128, -208},
    { 1144, 64, -336},
    { 960, -32, -224},
    { 1016, -64, 16},
    // 51 seconds
    { 1416, 88, -112},
    { 1168, 232, -224},
    { 1328, 232, -104},
    { 1336, 200, -32},
    { 1168, 264, -112},
    { 1056, 280, -96},
    { 1000, 352, -8},
    { 952, 336, -16},
    { 1088, 272, -104},
    { 976, 280, -192},
    { 1120, 336, -112},
    { 1552, 472, -112},
    { 928, 792, -8},
    { 1448, 712, -312},
    { 1032, 352, -184},
    { 944, 448, -80},
    { 1288, 432, 16},
    { 1400, 384, 0},
    { 1336, 248, -32},
    { 1296, 152, 48},
    { 1264, 80, 56},
    { 1168, 112, -32},
    { 1072, 136, -16},
    { 928, 144, -40},
    { 944, 136, -32},
    // 52 seconds
    { 1272, 160, -112},
    { 936, 136, -168},
    { 1080, 48, 8},
    { 1512, 96, 24},
    { 1192, 248, -200},
    { 1200, 224, -160},
    { 1328, 152, -136},
    { 1104, 240, -80},
    { 928, 240, -80},
    { 1032, 264, -24},
    { 1080, 328, 0},
    { 1048, 392, -80},
    { 944, 384, -136},
    { 1008, 432, 24},
    { 1320, 616, 96},
    { 872, 840, -24},
    { 1544, 568, -136},
    { 984, 416, -112},
    { 1000, 504, -24},
    { 1464, 512, 56},
    { 1608, 472, 16},
    { 1496, 304, 112},
    { 1448, 40, 184},
    { 1296, -72, 104},
    { 1096, 48, 32},
    // 53 seconds
    { 1008, 128, -48},
    { 832, 208, -72},
    { 1048, 184, -32},
    { 1240, 192, -240},
    { 928, 96, -184},
    { 1096, -96, 160},
    { 1304, 120, -72},
    { 1256, 216, -136},
    { 1536, 216, -80},
    { 1424, 304, -136},
    { 1064, 264, -120},
    { 1008, 280, -48},
    { 1032, 320, 64},
    { 1080, 328, 40},
    { 1072, 368, -80},
    { 872, 376, -88},
    { 1440, 464, -8},
    { 1048, 640, 16},
    { 1232, 728, -96},
    { 1248, 472, -320},
    { 952, 384, -120},
    { 1128, 496, -72},
    { 1424, 472, -64},
    { 1440, 368, 16},
    { 1328, 160, 32},
    // 54 seconds
    { 1264, 8, 72},
    { 1200, -8, 0},
    { 1088, 104, -16},
    { 1000, 160, -64},
    { 840, 192, -96},
    { 1024, 160, -80},
    { 1000, 152, -256},
    { 928, 88, -96},
    { 1288, 48, 80},
    { 1384, 224, -184},
    { 1336, 232, -128},
    { 1464, 208, -144},
    { 1152, 304, -232},
    { 952, 304, -144},
    { 888, 352, -40},
    { 912, 328, 8},
    { 992, 280, -24},
    { 1032, 248, -24},
    { 1048, 416, 160},
    { 1528, 640, 320},
    { 976, 800, 200},
    { 1256, 752, -80},
    { 1120, 512, -8},
    { 904, 592, -8},
    { 1128, 632, 184},
    // 55 seconds
    { 1416, 472, 216},
    { 1448, 272, 144},
    { 1296, 64, 96},
    { 1128, -56, 80},
    { 1032, 0, 32},
    { 960, 104, 40},
    { 952, 368, -128},
    { 920, 224, -184},
    { 1256, 96, -280},
    { 904, 88, -248},
    { 1200, 120, -168},
    { 1392, 104, -88},
    { 1128, 144, -184},
    { 1240, 80, -128},
    { 1328, 88, -40},
    { 1152, 320, -96},
    { 912, 392, -128},
    { 888, 336, -56},
    { 960, 256, -48},
    { 992, 280, -96},
    { 952, 336, -136},
    { 1112, 384, 8},
    { 1584, 544, 24},
    { 984, 784, 160},
    { 1440, 752, -288},
    // 56 seconds
    { 1048, 384, -152},
    { 928, 472, -80},
    { 1304, 568, -24},
    { 1520, 528, 48},
    { 1400, 256, 136},
    { 1184, 88, 128},
    { 1144, 48, 72},
    { 1136, 112, 72},
    { 1080, 192, 40},
    { 968, 200, 24},
    { 920, 184, 8},
    { 1112, 184, 16},
    { 928, 184, -64},
    { 1000, 136, -80},
    { 1304, 120, -64},
    { 1128, 288, -224},
    { 1248, 232, -368},
    { 1528, 240, -384},
    { 1184, 160, -248},
    { 792, 72, -264},
    { 896, 152, -280},
    { 992, 240, -216},
    { 1072, 376, -232},
    { 992, 624, -216},
    { 792, 744, -104},
    // 57 seconds
    { 984, 1264, -360},
    { 1064, 936, -328},
    { 960, 936, -376},
    { 1168, 1304, -480},
    { 1256, 1096, -312},
    { 1256, 992, -320},
    { 1184, 760, -280},
    { 1032, 640, -240},
    { 848, 424, -280},
    { 680, 384, -424},
    { 592, 352, -528},
    { 376, 248, -408},
    { 224, 328, -592},
    { 160, 744, -736},
    { 120, 1136, -728},
    { 32, 1016, -528},
    { -40, 984, -504},
    { -40, 936, -496},
    { -32, 856, -600},
    { -40, 976, -760},
    { -56, 880, -696},
    { 56, 952, -712},
    { 128, 648, -728},
    { 200, 568, -864},
    { 200, 424, -888},
    // 58 seconds
    { 264, 312, -936},
    { 312, 136, -928},
    { 464, -328, -680},
    { 3248, -2096, -2224},
    { -32, 192, -1184},
    { 184, -152, -1832},
    { 992, 712, -1192},
    { 1184, -80, -1184},
    { 280, 80, -888},
    { 272, 168, -952},
    { 304, 96, -1040},
    { 264, 96, -1048},
    { 152, 24, -968},
    { 128, 8, -1008},
    { 120, 16, -952},
    { 120, -144, -960},
    { 112, -96, -968},
    { 88, -16, -1008},
    { 216, 96, -1064},
    { 128, 32, -1048},
    { 80, 8, -1040},
    { 40, -16, -1024},
    { 40, -80, -1008},
    { 32, -96, -1016},
    { 24, -120, -976},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-09-28 17:11:50 local
AccelRawData *activity_sample_100_steps_heather_19(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_heather_19
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 85
  //> TEST_EXPECTED_MAX 105
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 584, -240, -1104},
    { 112, -48, -1016},
    { 16, -32, -984},
    { 88, 80, -1040},
    { 56, 80, -1016},
    { 56, 80, -1008},
    { 64, 88, -1032},
    { 56, 96, -1048},
    { 32, 104, -1048},
    { 32, 104, -1032},
    { 32, 88, -1032},
    { 48, 80, -1024},
    { 80, 64, -1040},
    { 264, 56, -1056},
    { -32, 112, -1064},
    { 48, 88, -1040},
    { 80, 88, -1008},
    { 96, 80, -1032},
    { 184, 32, -1032},
    { 136, 168, -1032},
    { 32, 104, -1040},
    { 8, 184, -1040},
    { -40, 48, -992},
    { 16, 88, -1040},
    { 40, 80, -1056},
    // 1 seconds
    { 0, 72, -1056},
    { 8, 72, -1040},
    { 0, 96, -1024},
    { -32, 16, -1056},
    { -128, 40, -992},
    { -96, 88, -1072},
    { 216, 368, -704},
    { 136, 16, -1024},
    { 88, 128, -1024},
    { 56, 112, -1016},
    { 40, 112, -1016},
    { 24, 104, -1016},
    { 32, 120, -1024},
    { 16, 144, -1040},
    { 8, 128, -1024},
    { 0, 168, -1032},
    { -16, 216, -1032},
    { -64, 264, -1056},
    { -72, 264, -1032},
    { -96, 248, -1008},
    { -104, 280, -968},
    { -72, 272, -1000},
    { -40, 224, -1048},
    { -40, 256, -1048},
    { -56, 232, -1008},
    // 2 seconds
    { -96, 200, -968},
    { -112, 200, -936},
    { -120, 216, -976},
    { -120, 216, -984},
    { -136, 216, -944},
    { -160, 184, -952},
    { -128, 200, -1072},
    { -128, 200, -1136},
    { -128, 264, -1144},
    { -120, 256, -1096},
    { -24, 376, -1008},
    { 168, 344, -904},
    { 368, 240, -736},
    { 616, 312, -752},
    { 752, 704, -456},
    { 768, 696, -16},
    { 824, 336, 160},
    { 832, 376, 144},
    { 1008, 576, 232},
    { 1104, 584, 336},
    { 1336, 608, 232},
    { 1760, 600, 32},
    { 1896, 736, -32},
    { 1960, 616, 160},
    { 1688, 720, 120},
    // 3 seconds
    { 1216, 696, 112},
    { 1504, 480, -96},
    { 1016, 688, -224},
    { 656, 704, -280},
    { 768, 680, -184},
    { 1080, 712, -64},
    { 1352, 512, -32},
    { 1408, 336, 24},
    { 1544, 192, 88},
    { 1648, 128, 80},
    { 1632, 248, 0},
    { 1544, 328, 64},
    { 1392, 272, 128},
    { 1432, 264, 104},
    { 1304, 280, -64},
    { 992, -184, -120},
    { 888, -320, 152},
    { 1168, -56, -56},
    { 1040, 80, -184},
    { 1192, 104, -128},
    { 1280, 192, -160},
    { 1216, 240, -224},
    { 1304, 272, -256},
    { 1256, 272, -328},
    { 1312, 400, -136},
    // 4 seconds
    { 1200, 536, -80},
    { 1152, 416, -144},
    { 1560, 528, -64},
    { 1088, 792, -40},
    { 1056, 792, -200},
    { 1160, 880, -208},
    { 848, 648, -216},
    { 1200, 520, -96},
    { 1680, 648, 8},
    { 1752, 448, 40},
    { 1672, 104, 136},
    { 1448, 8, 120},
    { 1376, 112, 0},
    { 1248, 192, -24},
    { 1032, 200, -8},
    { 1024, 168, 32},
    { 1008, 64, -32},
    { 728, -72, -152},
    { 928, -96, -8},
    { 1376, 168, -80},
    { 1336, 232, -208},
    { 1720, 232, -240},
    { 1624, 280, -304},
    { 1176, 272, -240},
    { 1096, 272, -208},
    // 5 seconds
    { 1152, 336, -24},
    { 1192, 368, -8},
    { 1192, 416, -136},
    { 1336, 512, -24},
    { 1280, 928, 56},
    { 912, 1408, -216},
    { 1448, 552, -16},
    { 1080, 520, -168},
    { 1216, 496, -72},
    { 1608, 672, 64},
    { 1800, 520, 88},
    { 1600, 184, 120},
    { 1360, 120, 64},
    { 1296, 136, 72},
    { 1216, 152, 0},
    { 1056, 184, 16},
    { 1008, 112, 48},
    { 984, 32, -16},
    { 760, 8, -192},
    { 968, 24, -64},
    { 1432, 120, -40},
    { 1536, 224, -200},
    { 1840, 240, -216},
    { 1720, 272, -256},
    { 1224, 296, -208},
    // 6 seconds
    { 1136, 312, -168},
    { 1176, 344, 8},
    { 1184, 376, 32},
    { 1064, 432, -64},
    { 928, 536, 48},
    { 1304, 760, 32},
    { 832, 1032, 112},
    { 1344, 736, 16},
    { 1320, 680, -24},
    { 1272, 584, -80},
    { 1552, 632, 24},
    { 1776, 680, 80},
    { 1728, 432, 96},
    { 1600, 152, 144},
    { 1480, 48, 128},
    { 1312, 120, 56},
    { 1128, 144, -8},
    { 952, 144, 24},
    { 1040, 144, 40},
    { 816, 112, -40},
    { 800, 80, -104},
    { 1104, 104, 32},
    { 1136, 208, -96},
    { 1480, 232, -120},
    { 1928, 280, -200},
    // 7 seconds
    { 1528, 376, -280},
    { 1144, 328, -304},
    { 1000, 384, -288},
    { 1120, 240, -232},
    { 1240, 216, -112},
    { 1160, 360, -72},
    { 1544, 744, -16},
    { 1096, 1128, 96},
    { 976, 1008, -200},
    { 1344, 592, -104},
    { 1152, 528, -184},
    { 1472, 592, 8},
    { 1872, 752, 184},
    { 1920, 368, 176},
    { 1536, 104, 64},
    { 1304, 24, 144},
    { 1216, 96, 64},
    { 1112, 160, 8},
    { 936, 232, -56},
    { 936, 128, 24},
    { 896, 48, -8},
    { 704, 24, -144},
    { 960, 40, 24},
    { 1232, 176, -8},
    { 1552, 240, -160},
    // 8 seconds
    { 2096, 328, -200},
    { 1824, 408, -288},
    { 1096, 376, -320},
    { 936, 320, -264},
    { 1080, 112, -80},
    { 1152, 208, -32},
    { 1040, 368, -184},
    { 1600, 800, -80},
    { 1192, 976, 208},
    { 936, 856, -256},
    { 1424, 480, -104},
    { 1064, 616, -192},
    { 1200, 632, 16},
    { 1664, 680, 168},
    { 1688, 464, 136},
    { 1520, 224, 56},
    { 1336, 72, 96},
    { 1240, 96, 80},
    { 1168, 160, -32},
    { 984, 216, -32},
    { 1000, 160, 48},
    { 1088, 144, -64},
    { 840, 88, -112},
    { 1064, 64, 112},
    { 1344, 184, -32},
    // 9 seconds
    { 1464, 288, -184},
    { 1704, 272, -80},
    { 1568, 288, -168},
    { 1192, 280, -256},
    { 1000, 328, -232},
    { 944, 248, -32},
    { 1008, 336, -88},
    { 1024, 344, -120},
    { 1304, 552, 24},
    { 1448, 912, -8},
    { 832, 944, -208},
    { 1472, 488, -104},
    { 1240, 464, -176},
    { 1144, 496, -96},
    { 1536, 584, 8},
    { 1680, 608, 8},
    { 1584, 352, 72},
    { 1360, -16, 152},
    { 1168, -56, 56},
    { 1040, 64, -8},
    { 904, 160, -56},
    { 784, 208, -56},
    { 1016, 184, -24},
    { 928, 208, -200},
    { 944, 104, -16},
    // 10 seconds
    { 1320, 88, 120},
    { 1416, 280, -120},
    { 1656, 344, -160},
    { 1648, 328, -184},
    { 1024, 312, -312},
    { 776, 216, -256},
    { 896, 224, -112},
    { 1048, 256, 0},
    { 1104, 336, -56},
    { 1024, 448, -104},
    { 1640, 544, -16},
    { 1136, 736, -56},
    { 1136, 1016, -144},
    { 1376, 648, -288},
    { 944, 328, -168},
    { 1192, 480, -48},
    { 1616, 544, -56},
    { 1512, 440, -24},
    { 1384, 144, 16},
    { 1256, -8, 64},
    { 1136, 56, 40},
    { 1032, 144, -16},
    { 872, 192, -32},
    { 760, 184, 48},
    { 1000, 200, -24},
    // 11 seconds
    { 888, 208, -136},
    { 1112, 136, -24},
    { 1336, 200, -8},
    { 1288, 264, -224},
    { 1544, 256, -248},
    { 1256, 296, -176},
    { 856, 152, -216},
    { 856, 192, -264},
    { 968, 160, -144},
    { 992, 192, -120},
    { 1080, 328, -168},
    { 968, 384, -152},
    { 1464, 456, -40},
    { 1256, 656, -144},
    { 1176, 848, -16},
    { 1472, 752, -448},
    { 920, 352, -152},
    { 952, 448, -32},
    { 1312, 488, -48},
    { 1328, 336, -72},
    { 1104, 168, -16},
    { 1056, 72, 48},
    { 1128, 136, 56},
    { 1224, 632, -216},
    { 1680, 1616, -472},
    // 12 seconds
    { 1448, 608, -88},
    { 1320, 344, -272},
    { 760, 120, -360},
    { 592, 152, -584},
    { 464, 128, -832},
    { 504, 56, -600},
    { 640, -88, -592},
    { 600, -136, -544},
    { 496, -112, -456},
    { 376, 56, -480},
    { 360, 232, -704},
    { 248, 360, -1064},
    { -112, 552, -1456},
    { -432, -40, -1280},
    { -312, 24, -1264},
    { -176, 264, -1400},
    { -192, 272, -1360},
    { -96, 296, -1168},
    { 24, 272, -1016},
    { -128, 264, -896},
    { -192, 232, -832},
    { 32, 296, -904},
    { 80, 112, -776},
    { -16, -8, -656},
    { -104, -16, -680},
    // 13 seconds
    { -160, -128, -664},
    { -56, -24, -696},
    { 32, -16, -768},
    { 304, -96, -752},
    { 584, -216, -496},
    { 808, -8, 0},
    { 1544, 288, 248},
    { 2488, 768, 48},
    { 2392, 960, -16},
    { 1976, 576, 144},
    { 1448, 560, -288},
    { 1280, 392, -232},
    { 1224, 472, 184},
    { 1208, 304, 288},
    { 1184, 352, 40},
    { 1128, 424, -56},
    { 1552, 752, 104},
    { 1008, 1232, 72},
    { 1056, 1264, -288},
    { 1208, 584, -88},
    { 896, 544, -192},
    { 1232, 472, -16},
    { 1672, 448, 24},
    { 1728, 376, 0},
    { 1648, 216, 56},
    // 14 seconds
    { 1496, 64, 120},
    { 1400, 112, 72},
    { 1240, 144, -64},
    { 1088, 88, -64},
    { 936, 112, 96},
    { 1096, 192, -16},
    { 888, 256, -216},
    { 1000, 80, 8},
    { 1112, 104, 88},
    { 1128, 240, -184},
    { 1192, 176, -40},
    { 1632, 192, -24},
    { 1608, 296, -312},
    { 1248, 392, -392},
    { 1072, 440, -360},
    { 1200, 280, -64},
    { 1224, 192, -8},
    { 1128, 320, 40},
    { 1368, 480, 64},
    { 1192, 768, 48},
    { 920, 920, 0},
    { 1288, 904, -200},
    { 1024, 536, -112},
    { 1024, 552, -96},
    { 1392, 680, 48},
    // 15 seconds
    { 1752, 624, 128},
    { 1576, 248, 272},
    { 1240, -200, 224},
    { 1200, 0, 64},
    { 1152, 104, 80},
    { 1072, 216, 64},
    { 960, 280, 16},
    { 1184, 248, 8},
    { 968, 168, -120},
    { 1000, 0, -32},
    { 1240, 64, 96},
    { 1232, 216, -136},
    { 1320, 216, -152},
    { 1520, 184, -168},
    { 1344, 280, -240},
    { 1040, 320, -216},
    { 1032, 320, -240},
    { 1088, 280, -16},
    { 1144, 352, 32},
    { 1016, 392, 0},
    { 1104, 472, 0},
    { 1304, 616, 72},
    { 912, 848, 40},
    { 1304, 928, -256},
    { 1208, 496, -128},
    // 16 seconds
    { 960, 456, -120},
    { 1384, 592, -40},
    { 1936, 720, -88},
    { 2024, 424, 376},
    { 1248, -344, 320},
    { 992, -152, 136},
    { 912, 56, 56},
    { 920, 280, -40},
    { 832, 400, -48},
    { 968, 328, 32},
    { 1128, 200, -16},
    { 912, 152, -128},
    { 1096, 120, 56},
    { 1248, 184, -104},
    { 1336, 192, -320},
    { 1488, 200, 8},
    { 1168, 168, -280},
    { 944, 104, -528},
    { 1008, 184, -184},
    { 1000, 256, -64},
    { 1056, 352, 24},
    { 1056, 456, 56},
    { 944, 640, 40},
    { 1424, 560, 24},
    { 1240, 544, 24},
    // 17 seconds
    { 1216, 640, -24},
    { 1160, 736, -472},
    { 912, 344, -120},
    { 1016, 496, -56},
    { 1448, 552, -208},
    { 1920, 520, -40},
    { 1224, -576, 328},
    { 984, -152, 24},
    { 952, 24, 24},
    { 1000, 288, -16},
    { 936, 472, -128},
    { 928, 304, -48},
    { 1288, 200, -56},
    { 1248, 136, -32},
    { 1344, 72, 216},
    { 1312, 160, -120},
    { 1088, 216, -208},
    { 1080, 112, -256},
    { 1120, 184, -432},
    { 1032, 232, -368},
    { 744, 272, -240},
    { 888, 296, -112},
    { 952, 360, -112},
    { 944, 360, -144},
    { 952, 328, -160},
    // 18 seconds
    { 1144, 376, -104},
    { 1168, 448, -56},
    { 1136, 544, -56},
    { 1480, 744, -216},
    { 1144, 696, -360},
    { 1224, 408, -48},
    { 1536, 536, 56},
    { 1736, 392, -16},
    { 1480, -144, 40},
    { 1120, -160, 72},
    { 1072, -16, 0},
    { 984, 128, -24},
    { 896, 272, -64},
    { 816, 240, -176},
    { 1016, 144, -72},
    { 1088, 104, -184},
    { 1008, 8, -40},
    { 1360, 64, 48},
    { 1360, 280, -168},
    { 1464, 328, -232},
    { 1520, 304, -184},
    { 1280, 48, -152},
    { 1000, 264, -96},
    { 976, 504, -24},
    { 1024, 312, 88},
    // 19 seconds
    { 1072, 400, 8},
    { 968, 312, -80},
    { 1120, 392, 8},
    { 1456, 744, -104},
    { 912, 1448, -320},
    { 1536, 352, 8},
    { 1096, 512, -248},
    { 968, 504, -216},
    { 1264, 544, -56},
    { 1592, 520, -32},
    { 1544, 400, 16},
    { 1656, 192, 80},
    { 1384, -24, 112},
    { 1336, -32, -16},
    { 1120, 64, -128},
    { 880, 128, -176},
    { 768, 120, -136},
    { 1008, 80, -152},
    { 832, 32, -168},
    { 992, 24, 80},
    { 1224, 144, 104},
    { 1416, 312, -64},
    { 1640, 424, -24},
    { 1592, 448, -104},
    { 1168, 384, -264},
    // 20 seconds
    { 936, 312, -136},
    { 984, 216, -16},
    { 1048, 232, 0},
    { 1056, 328, -24},
    { 904, 416, -136},
    { 976, 464, -72},
    { 1400, 616, -40},
    { 1064, 880, -24},
    { 1384, 840, -360},
    { 1104, 320, -168},
    { 992, 424, -64},
    { 1368, 528, -64},
    { 1664, 480, 8},
    { 1656, 280, 24},
    { 1408, -48, 120},
    { 1264, 64, 48},
    { 1192, 56, -32},
    { 1096, 168, -48},
    { 968, 184, -88},
    { 776, 168, -152},
    { 728, 88, -112},
    { 880, -32, -168},
    { 784, -72, -80},
    { 1232, 136, 48},
    { 1840, 240, 48},
    // 21 seconds
    { 2056, 448, -112},
    { 1760, 520, -136},
    { 1224, 416, -72},
    { 1096, 120, -88},
    { 1024, 208, -24},
    { 1000, 328, 48},
    { 912, 392, 96},
    { 752, 416, -24},
    { 632, 296, -40},
    { 640, 336, 0},
    { 880, 384, 48},
    { 1096, 496, 16},
    { 1040, 744, -184},
    { 1000, 616, -64},
    { 960, 424, -136},
    { 816, 376, -136},
    { 1312, 640, 8},
    { 2112, 176, 328},
    { 1680, -520, 392},
    { 2672, -1080, -1616},
    { 1464, -1304, 472},
    { 1216, 224, 512},
    { 776, 72, 456},
    { 600, 152, 304},
    { 512, 176, 400},
    // 22 seconds
    { 488, 160, 488},
    { 584, 72, 368},
    { 736, 376, 464},
    { 712, 704, 544},
    { 800, 544, 152},
    { 1336, -208, -8},
    { 2496, 168, -80},
    { 2056, -32, 200},
    { 1328, 264, 176},
    { 912, 360, 240},
    { 640, 336, 88},
    { 520, 32, 32},
    { 440, 128, -24},
    { 464, 344, 128},
    { 552, 392, 360},
    { 544, 656, 464},
    { 760, 976, 144},
    { 976, 616, 208},
    { 944, 424, 360},
    { 1064, 728, 16},
    { 992, 304, 8},
    { 992, 536, 360},
    { 1376, 1096, 176},
    { 1008, 928, 96},
    { 768, 616, -56},
    // 23 seconds
    { 672, 400, -192},
    { 584, 528, -296},
    { 632, 648, -240},
    { 688, 632, -176},
    { 976, 408, 64},
    { 1256, 440, 16},
    { 1200, 528, -88},
    { 1368, 440, 0},
    { 1400, 480, 192},
    { 1320, 424, -248},
    { 1264, 336, -320},
    { 1144, 128, -224},
    { 856, 24, -376},
    { 656, 16, -480},
    { 800, 144, -456},
    { 968, 224, -216},
    { 992, 360, -144},
    { 976, 360, -136},
    { 1128, 336, -200},
    { 1528, 424, -56},
    { 1384, 496, 8},
    { 1264, 520, 80},
    { 1216, 680, -160},
    { 880, 1016, -216},
    { 1016, 584, -56},
    // 24 seconds
    { 1168, 552, 168},
    { 1296, 352, 96},
    { 1216, 216, -32},
    { 1120, 136, -88},
    { 1088, 344, -120},
    { 1168, 520, -64},
    { 1264, 600, -32},
    { 1248, 424, 8},
    { 1376, 328, -96},
    { 1144, 144, -208},
    { 960, -312, -48},
    { 1184, -16, 120},
    { 1272, 400, 24},
    { 1344, 456, 104},
    { 1424, 392, 72},
    { 1240, 368, -104},
    { 1016, 392, -64},
    { 960, 360, 72},
    { 1016, 352, 144},
    { 1112, 432, 88},
    { 1064, 440, -32},
    { 1296, 504, 80},
    { 1504, 760, 104},
    { 928, 1312, 16},
    { 1352, 712, -64},
    // 25 seconds
    { 936, 608, -200},
    { 1016, 496, -72},
    { 1376, 416, 64},
    { 1608, 384, 24},
    { 1440, 320, -16},
    { 1416, 216, 32},
    { 1256, 208, 88},
    { 1120, 160, 72},
    { 936, 168, -16},
    { 808, 112, -80},
    { 1112, 120, 16},
    { 1216, 64, 0},
    { 1024, 32, -16},
    { 1176, 40, 176},
    { 1520, 256, 16},
    { 1400, 352, -192},
    { 1400, 320, -64},
    { 1312, 272, -208},
    { 1120, 48, -200},
    { 872, 352, -80},
    { 952, 328, 16},
    { 1104, 392, 40},
    { 944, 440, -104},
    { 1040, 368, -88},
    { 1584, 616, -120},
    // 26 seconds
    { 1000, 832, -168},
    { 1216, 848, -200},
    { 1328, 360, -224},
    { 984, 368, -168},
    { 1344, 520, -56},
    { 1656, 560, -8},
    { 1520, 400, 0},
    { 1392, 208, 24},
    { 1296, 96, 80},
    { 1240, 120, 8},
    { 1096, 184, -64},
    { 920, 168, -104},
    { 1016, 104, -56},
    { 976, 8, -112},
    { 776, -64, -160},
    { 976, -48, 80},
    { 1312, 216, -24},
    { 1432, 280, -208},
    { 1784, 360, -80},
    { 1576, 400, -120},
    { 1048, 320, -264},
    { 952, 424, -128},
    { 1048, 192, 24},
    { 1248, 376, -32},
    { 1144, 424, -136},
    // 27 seconds
    { 856, 424, -32},
    { 1392, 584, 24},
    { 1024, 1000, 88},
    { 1384, 1016, -288},
    { 1320, 336, -32},
    { 1128, 400, -112},
    { 1400, 632, -24},
    { 1912, 600, 56},
    { 1648, 384, 16},
    { 1384, -128, 264},
    { 1000, 88, 32},
    { 928, 16, 8},
    { 888, 160, -88},
    { 768, 224, -80},
    { 920, 192, -8},
    { 1048, 168, -136},
    { 864, 112, -120},
    { 1288, 104, 232},
    { 1792, 224, 32},
    { 1664, 360, -24},
    { 1744, 328, -296},
    { 1360, 344, -392},
    { 872, 312, -24},
    { 904, 280, -24},
    { 992, 392, 48},
    // 28 seconds
    { 1072, 464, -16},
    { 984, 472, -112},
    { 1104, 520, 40},
    { 1336, 752, 16},
    { 856, 800, -80},
    { 1312, 568, 0},
    { 1344, 648, -112},
    { 1344, 536, -96},
    { 1608, 592, 8},
    { 1672, 584, 72},
    { 1600, 384, 152},
    { 1432, 88, 120},
    { 1216, -24, 8},
    { 1136, -96, -264},
    { 992, -24, -88},
    { 768, 80, 64},
    { 768, 192, 8},
    { 904, 256, -240},
    { 832, 224, -264},
    { 1200, 144, 0},
    { 1464, 240, -16},
    { 1600, 256, -64},
    { 1856, 304, -200},
    { 1424, 408, -248},
    { 952, 352, -312},
    // 29 seconds
    { 912, 432, -296},
    { 1128, 264, -128},
    { 1248, 344, -96},
    { 1104, 472, -72},
    { 1272, 696, 0},
    { 1272, 1000, 224},
    { 840, 840, -24},
    { 1528, 648, 152},
    { 1248, 696, -56},
    { 1408, 624, -8},
    { 1768, 768, 112},
    { 1752, 592, 200},
    { 1584, 144, 232},
    { 1312, 80, 184},
    { 1168, 144, 96},
    { 1048, 160, 0},
    { 920, 200, 8},
    { 1104, 184, 72},
    { 1144, 160, 96},
    { 1176, 216, 16},
    { 1488, 176, 56},
    { 1592, 312, -64},
    { 1592, 264, -288},
    { 1552, 216, -312},
    { 1208, 128, -256},
    // 30 seconds
    { 880, 104, -312},
    { 832, 64, -416},
    { 1016, 256, -416},
    { 1024, 312, -264},
    { 1144, 408, -224},
    { 1208, 376, -152},
    { 1432, 448, -48},
    { 1256, 472, -8},
    { 1232, 528, 120},
    { 1152, 696, -64},
    { 920, 824, -248},
    { 1048, 512, -24},
    { 1392, 544, 176},
    { 1440, 432, 152},
    { 1384, 240, 80},
    { 1248, 136, 112},
    { 1080, 160, 64},
    { 952, 216, -56},
    { 888, 176, -32},
    { 856, 144, -16},
    { 1104, 152, -32},
    { 1256, 192, -120},
    { 1144, 176, -216},
    { 1296, 160, -104},
    { 1480, 184, -104},
    // 31 seconds
    { 1576, 208, -176},
    { 1504, 248, -200},
    { 1272, 272, -392},
    { 856, 264, -280},
    { 768, 248, -144},
    { 776, 352, -192},
    { 832, 344, -128},
    { 992, 352, -248},
    { 1296, 440, -248},
    { 1584, 472, -152},
    { 1096, 440, -72},
    { 1256, 544, -120},
    { 1120, 736, -296},
    { 1104, 616, -240},
    { 1272, 464, 56},
    { 1520, 456, 128},
    { 1408, 272, -24},
    { 1232, 200, 8},
    { 1160, 192, 104},
    { 1080, 224, 24},
    { 1008, 224, -48},
    { 944, 168, -16},
    { 912, 96, 0},
    { 1224, 112, -8},
    { 1136, 136, -136},
    // 32 seconds
    { 1336, 144, -192},
    { 1536, 176, 48},
    { 1504, 248, -184},
    { 1480, 256, -152},
    { 1384, 264, -136},
    { 1064, 280, -320},
    { 880, 288, -360},
    { 768, 296, -184},
    { 864, 304, -64},
    { 1064, 384, -152},
    { 1136, 416, -216},
    { 1296, 432, -168},
    { 1376, 480, -168},
    { 1016, 480, -104},
    { 1104, 528, -144},
    { 1144, 648, -240},
    { 1096, 688, -192},
    { 1312, 520, 88},
    { 1536, 400, 184},
    { 1344, 240, 104},
    { 1208, 152, 80},
    { 1176, 128, 56},
    { 1128, 208, 8},
    { 1096, 224, -48},
    { 928, 184, -56},
    // 33 seconds
    { 1048, 136, -32},
    { 1144, 144, -112},
    { 1048, 112, -240},
    { 1344, 64, -128},
    { 1400, 88, -80},
    { 1328, 176, -152},
    { 1424, 216, -136},
    { 1296, 280, -288},
    { 1064, 264, -320},
    { 928, 272, -168},
    { 936, 272, -80},
    { 976, 384, -56},
    { 1024, 416, -144},
    { 1056, 432, -120},
    { 1448, 512, 32},
    { 1104, 592, 144},
    { 1232, 648, 8},
    { 1256, 680, -136},
    { 1040, 600, -136},
    { 1128, 560, 16},
    { 1408, 552, 88},
    { 1376, 328, 8},
    { 1280, 48, -88},
    { 1128, 24, -32},
    { 1120, 136, -80},
    // 34 seconds
    { 1120, 216, -136},
    { 1040, 208, -128},
    { 1048, 144, -56},
    { 1256, 168, -104},
    { 1048, 192, -216},
    { 1184, 136, -192},
    { 1232, 120, -64},
    { 1104, 184, -80},
    { 1248, 264, -88},
    { 1384, 320, -232},
    { 1096, 352, -272},
    { 816, 304, -224},
    { 752, 216, -120},
    { 936, 152, -152},
    { 1104, 328, -256},
    { 1016, 488, -280},
    { 1392, 672, -144},
    { 1512, 648, -24},
    { 832, 624, 192},
    { 1288, 632, -112},
    { 928, 504, 24},
    { 896, 656, -72},
    { 1168, 688, 88},
    { 1496, 520, 248},
    { 1400, 352, 160},
    // 35 seconds
    { 1320, 224, 144},
    { 1328, 144, 80},
    { 1328, 136, 8},
    { 1208, 160, -16},
    { 1016, 144, -64},
    { 1000, 144, -56},
    { 1096, 160, -176},
    { 880, 128, -296},
    { 1016, 56, -136},
    { 1232, 104, -112},
    { 1312, 168, -280},
    { 1440, 208, -208},
    { 1432, 208, -184},
    { 1136, 240, -208},
    { 1008, 280, -200},
    { 1008, 272, -88},
    { 1088, 336, -16},
    { 1064, 360, -72},
    { 952, 392, -160},
    { 1048, 424, -144},
    { 1456, 528, -16},
    { 1096, 680, 24},
    { 1272, 824, -144},
    { 1128, 504, -224},
    { 888, 416, -160},
    // 36 seconds
    { 1104, 568, 0},
    { 1544, 528, 72},
    { 1512, 304, 104},
    { 1384, 152, 40},
    { 1240, 64, 104},
    { 1160, 128, 64},
    { 1080, 176, 0},
    { 944, 216, -24},
    { 824, 168, -48},
    { 1008, 160, -24},
    { 984, 184, -184},
    { 952, 144, -192},
    { 1280, 120, 72},
    { 1520, 248, -80},
    { 1472, 344, -240},
    { 1392, 328, -168},
    { 1144, 280, -224},
    { 904, 224, -160},
    { 864, 280, -104},
    { 952, 272, -24},
    { 968, 328, -24},
    { 1032, 384, -56},
    { 888, 408, -136},
    { 1200, 464, 40},
    { 1272, 648, 120},
    // 37 seconds
    { 1440, 784, -48},
    { 1224, 408, -152},
    { 864, 424, -104},
    { 1032, 528, 0},
    { 1408, 480, 96},
    { 1360, 328, 40},
    { 1136, 168, 80},
    { 976, 24, 136},
    { 952, 112, 0},
    { 944, 176, 0},
    { 928, 248, -8},
    { 992, 192, 80},
    { 1536, 200, 112},
    { 1240, 288, 128},
    { 1288, 304, 88},
    { 1352, 264, -136},
    { 992, 232, -344},
    { 968, 168, -352},
    { 1080, -72, -208},
    { 856, 136, -256},
    { 808, 312, -208},
    { 752, 336, -216},
    { 872, 352, -120},
    { 968, 328, -168},
    { 1008, 320, -208},
    // 38 seconds
    { 1256, 368, -112},
    { 1448, 456, -104},
    { 1120, 496, -88},
    { 1440, 624, -192},
    { 1136, 624, -368},
    { 1008, 440, -152},
    { 1328, 488, 72},
    { 1520, 328, 104},
    { 1232, 160, -24},
    { 1024, 72, 32},
    { 952, 104, 72},
    { 960, 176, 16},
    { 960, 224, -40},
    { 928, 216, 24},
    { 1080, 176, 40},
    { 1200, 200, -80},
    { 1112, 184, -176},
    { 1408, 160, -32},
    { 1448, 264, -200},
    { 1248, 240, -280},
    { 1208, 136, -152},
    { 1080, 152, -192},
    { 896, 216, -160},
    { 904, 312, -72},
    { 904, 328, -32},
    // 39 seconds
    { 984, 376, -24},
    { 1032, 440, -80},
    { 1016, 432, -56},
    { 1376, 440, -16},
    { 1240, 512, -56},
    { 1304, 584, -96},
    { 1280, 608, -312},
    { 952, 480, -248},
    { 1104, 496, -128},
    { 1488, 504, -88},
    { 1360, 344, 40},
    { 1176, 80, 24},
    { 952, -80, 144},
    { 944, 64, 16},
    { 944, 144, -16},
    { 1000, 280, -48},
    { 1160, 216, 72},
    { 1400, 240, 232},
    { 1080, 328, 40},
    { 1152, 224, -280},
    { 1280, 224, -224},
    { 984, 272, -224},
    { 1080, 104, -256},
    { 1240, 16, -200},
    { 1056, 256, -368},
    // 40 seconds
    { 936, 304, -336},
    { 840, 304, -256},
    { 888, 352, -168},
    { 984, 328, -168},
    { 976, 336, -160},
    { 1176, 376, -88},
    { 1304, 416, -40},
    { 984, 496, -32},
    { 1312, 576, -104},
    { 1304, 752, -272},
    { 1088, 528, -176},
    { 1240, 544, 48},
    { 1536, 424, 128},
    { 1360, 192, 88},
    { 1136, 96, 40},
    { 1024, 72, 80},
    { 1008, 120, 48},
    { 1000, 176, -16},
    { 896, 208, -32},
    { 904, 168, 16},
    { 1128, 200, -16},
    { 1008, 248, -184},
    { 1288, 208, -120},
    { 1504, 272, -32},
    { 1304, 288, -232},
    // 41 seconds
    { 1288, 216, -152},
    { 1312, 192, -160},
    { 992, 248, -168},
    { 808, 296, -128},
    { 864, 312, -80},
    { 920, 360, -40},
    { 1016, 400, -112},
    { 992, 352, -136},
    { 1304, 392, -8},
    { 1320, 496, -40},
    { 1056, 504, -24},
    { 1352, 600, -232},
    { 952, 840, -360},
    { 976, 544, -128},
    { 1360, 520, 152},
    { 1600, 320, 200},
    { 1504, 48, 32},
    { 1184, -104, 136},
    { 1144, 40, 40},
    { 1064, 112, 48},
    { 984, 280, -32},
    { 936, 280, 24},
    { 1176, 232, 48},
    { 1024, 200, -104},
    { 1088, 136, -96},
    // 42 seconds
    { 1224, 128, 80},
    { 1208, 232, -104},
    { 1216, 256, -208},
    { 1296, 248, -144},
    { 1072, 224, -152},
    { 872, 232, -168},
    { 880, 288, -80},
    { 1008, 320, -24},
    { 1176, 320, -40},
    { 1120, 384, -128},
    { 1016, 392, -120},
    { 1400, 472, -72},
    { 1104, 576, -88},
    { 1184, 624, -160},
    { 1224, 504, -352},
    { 1000, 464, -160},
    { 1224, 528, 8},
    { 1592, 440, 48},
    { 1384, 224, 32},
    { 1152, 112, 32},
    { 1000, 16, 48},
    { 984, 112, 16},
    { 968, 192, 16},
    { 896, 240, -8},
    { 1064, 200, 40},
    // 43 seconds
    { 1232, 192, 8},
    { 952, 208, -48},
    { 1352, 168, -8},
    { 1448, 288, -80},
    { 1256, 280, -232},
    { 1192, 224, -208},
    { 1056, 200, -256},
    { 824, 104, -112},
    { 744, 280, -144},
    { 864, 256, -64},
    { 992, 288, 16},
    { 1008, 392, -88},
    { 944, 392, -64},
    { 1520, 448, 8},
    { 1232, 560, -104},
    { 1280, 656, -96},
    { 1440, 680, -304},
    { 864, 416, -200},
    { 1016, 456, -64},
    { 1400, 480, -24},
    { 1296, 264, 8},
    { 1016, 96, 16},
    { 904, 40, 56},
    { 928, 120, 24},
    { 1000, 208, 8},
    // 44 seconds
    { 992, 272, 40},
    { 1176, 208, 88},
    { 1320, 200, 104},
    { 1264, 232, -8},
    { 1400, 160, 56},
    { 1336, 200, -200},
    { 1064, 184, -304},
    { 1136, 64, -248},
    { 1128, 80, -352},
    { 840, 80, -384},
    { 768, 344, -312},
    { 792, 224, -112},
    { 928, 328, -128},
    { 936, 336, -168},
    { 944, 384, -136},
    { 1456, 448, -24},
    { 1160, 576, -8},
    { 1512, 720, 0},
    { 1296, 768, -344},
    { 1064, 368, -128},
    { 1280, 496, 24},
    { 1544, 456, 8},
    { 1360, 272, 8},
    { 1152, 64, 40},
    { 1024, 24, 80},
    // 45 seconds
    { 952, 104, -8},
    { 888, 168, -48},
    { 776, 160, -24},
    { 888, 136, 8},
    { 1200, 176, -16},
    { 1088, 224, -88},
    { 1488, 176, 8},
    { 1776, 280, -32},
    { 1544, 384, -264},
    { 1216, 248, -80},
    { 1096, 184, -152},
    { 960, 200, -152},
    { 864, 256, -96},
    { 872, 320, -48},
    { 896, 344, -16},
    { 872, 368, -40},
    { 832, 352, -112},
    { 944, 352, -40},
    { 1392, 432, -24},
    { 1072, 464, -104},
    { 1200, 448, -120},
    { 1456, 608, -264},
    { 968, 640, -304},
    { 1112, 480, -104},
    { 1448, 488, -48},
    // 46 seconds
    { 1504, 368, 80},
    { 1336, 72, 88},
    { 1128, -32, 64},
    { 1056, 24, -24},
    { 1032, 24, -272},
    { 1024, 32, -328},
    { 856, 32, 64},
    { 976, 200, -8},
    { 1184, 320, -520},
    { 1240, 200, -256},
    { 1472, 184, 128},
    { 1488, 216, 0},
    { 1304, 280, -24},
    { 1184, 264, -88},
    { 976, 232, -296},
    { 760, 256, -208},
    { 744, 264, -144},
    { 872, 264, -72},
    { 936, 312, -88},
    { 960, 328, -104},
    { 1184, 360, -112},
    { 1600, 480, -48},
    { 1200, 568, -88},
    { 1096, 664, -96},
    { 1208, 944, -280},
    // 47 seconds
    { 1000, 560, -264},
    { 1224, 520, -80},
    { 1528, 528, 104},
    { 1640, 312, 80},
    { 1520, 96, 8},
    { 1344, 16, -56},
    { 1160, 56, -192},
    { 1000, 104, -224},
    { 872, 120, -144},
    { 736, 64, -144},
    { 832, 32, -136},
    { 1048, 56, -168},
    { 1096, 184, -40},
    { 1408, 192, 264},
    { 1744, 296, 272},
    { 1880, 560, 0},
    { 1520, 592, -16},
    { 1136, 496, -208},
    { 952, 200, -296},
    { 880, 160, -56},
    { 904, 168, 88},
    { 944, 328, 72},
    { 992, 472, -48},
    { 968, 520, -152},
    { 1280, 520, -24},
    // 48 seconds
    { 1280, 624, -16},
    { 1080, 848, 16},
    { 1272, 680, -288},
    { 952, 432, -184},
    { 1104, 512, 0},
    { 1536, 560, 48},
    { 1672, 416, 64},
    { 1528, 192, 56},
    { 1352, 112, 120},
    { 1240, 120, 96},
    { 1144, 152, 24},
    { 992, 176, 16},
    { 832, 168, 0},
    { 896, 136, 48},
    { 1080, 176, -32},
    { 960, 176, -152},
    { 1224, 136, 24},
    { 1544, 248, -40},
    { 1456, 360, -296},
    { 1352, 312, -288},
    { 1200, 152, -304},
    { 1064, 8, -144},
    { 960, 776, -352},
    { 832, 336, -32},
    { 888, 296, -48},
    // 49 seconds
    { 896, 248, -56},
    { 920, 328, -88},
    { 1240, 368, -16},
    { 1440, 504, -128},
    { 1224, 664, -128},
    { 1456, 1056, -384},
    { 1056, 392, -360},
    { 944, 224, -64},
    { 1272, 320, -64},
    { 1456, 344, -72},
    { 1352, 136, -184},
    { 1232, 56, -88},
    { 1128, 80, -24},
    { 1096, 152, -64},
    { 1000, 216, -56},
    { 816, 192, -64},
    { 784, 136, -32},
    { 1128, 144, -72},
    { 1024, 176, -160},
    { 1272, 136, -64},
    { 1592, 168, 0},
    { 1440, 288, -200},
    { 1280, 320, -232},
    { 1136, 264, -288},
    { 1064, 224, -208},
    // 50 seconds
    { 840, 224, -96},
    { 848, 248, -48},
    { 872, 296, -8},
    { 904, 368, 32},
    { 1000, 392, -72},
    { 856, 360, -128},
    { 1296, 400, -88},
    { 1368, 528, -208},
    { 1088, 680, -256},
    { 1288, 904, -408},
    { 1152, 472, -440},
    { 1336, 1032, -320},
    { 2120, 784, 104},
    { 2208, 424, 120},
    { 1952, 208, -352},
    { 1648, 488, -288},
    { 1312, 480, -128},
    { 1000, 392, -48},
    { 816, 216, -208},
    { 688, 200, -480},
    { 504, 80, -568},
    { 456, -120, -664},
    { 288, -120, -800},
    { 104, -232, -896},
    { 24, -280, -904},
    // 51 seconds
    { 112, -128, -1072},
    { 304, -112, -1016},
    { 280, -208, -864},
    { 152, -168, -792},
    { -16, -208, -720},
    { -96, -232, -696},
    { -88, -240, -712},
    { -80, -184, -776},
    { -88, -224, -904},
    { -192, -264, -1056},
    { -152, -216, -1208},
    { -160, -96, -1288},
    { -200, -72, -1336},
    { -200, 96, -1312},
    { -152, 160, -1248},
    { -176, 160, -1072},
    { -152, 184, -968},
    { -64, 120, -920},
    { -32, -8, -824},
    { -64, -40, -736},
    { -112, -16, -744},
    { -120, -40, -824},
    { -88, -48, -984},
    { -64, -56, -1088},
    { -64, -96, -1184},
    // 52 seconds
    { 16, -136, -1224},
    { -104, -216, -1224},
    { -80, -48, -1256},
    { 120, 272, -1352},
    { 296, 136, -1256},
    { 280, -112, -992},
    { 200, 56, -832},
    { 56, 104, -776},
    { -64, 16, -784},
    { -64, 0, -808},
    { -48, -88, -840},
    { -48, -96, -904},
    { -112, -112, -976},
    { -248, -112, -1040},
    { -208, -72, -1136},
    { -208, -80, -1200},
    { -216, -32, -1280},
    { -96, 208, -1368},
    { -96, 120, -1240},
    { -112, 120, -1048},
    { -96, 144, -936},
    { -48, 160, -864},
    { -40, 16, -744},
    { -80, -120, -616},
    { -120, -240, -552},
    // 53 seconds
    { -72, -304, -592},
    { -8, -200, -640},
    { 184, -24, -744},
    { 576, 288, -720},
    { 1048, 568, -584},
    { 1448, 512, -64},
    { 1920, 696, 592},
    { 2120, 976, 296},
    { 1840, 1072, -400},
    { 1200, 912, -80},
    { 1160, 472, 384},
    { 1312, 152, 320},
    { 1128, -48, 0},
    { 1000, 80, 56},
    { 960, 328, 200},
    { 1048, 512, 160},
    { 1048, 672, -144},
    { 1072, 760, -368},
    { 1792, 960, -280},
    { 960, 1192, -344},
    { 1280, 232, -152},
    { 1200, 352, -312},
    { 984, 472, -344},
    { 1192, 472, -144},
    { 1616, 560, -40},
    // 54 seconds
    { 1784, 392, -8},
    { 1600, 152, 16},
    { 1408, 96, 112},
    { 1296, 168, 144},
    { 1232, 232, 104},
    { 1088, 256, 24},
    { 912, 216, 24},
    { 1024, 168, 16},
    { 920, 160, -160},
    { 816, 112, -280},
    { 984, 32, -128},
    { 1208, 96, -104},
    { 1368, 152, -264},
    { 1592, 216, -312},
    { 1448, 240, -272},
    { 1072, 256, -192},
    { 1080, 248, -200},
    { 1168, 296, -96},
    { 1184, 336, -8},
    { 1152, 408, -64},
    { 984, 448, -144},
    { 1312, 528, -64},
    { 1232, 640, -56},
    { 1008, 824, -8},
    { 1344, 712, -248},
    // 55 seconds
    { 976, 480, -200},
    { 1040, 504, -104},
    { 1392, 592, 8},
    { 1664, 488, 64},
    { 1544, 224, 96},
    { 1384, 88, 88},
    { 1280, 88, 96},
    { 1256, 160, 40},
    { 1144, 216, 24},
    { 968, 200, -40},
    { 976, 176, -8},
    { 1032, 184, -96},
    { 840, 160, -240},
    { 1136, 64, -104},
    { 1320, 96, -72},
    { 1232, 152, -216},
    { 1360, 192, -176},
    { 1376, 232, -224},
    { 1120, 264, -216},
    { 1000, 328, -184},
    { 1080, 312, -64},
    { 1224, 352, 40},
    { 1280, 384, 0},
    { 1064, 392, -96},
    { 1176, 440, -64},
    // 56 seconds
    { 1504, 568, 0},
    { 976, 704, 56},
    { 1088, 888, -176},
    { 1216, 592, -144},
    { 888, 456, -176},
    { 1096, 568, -88},
    { 1424, 648, -8},
    { 1560, 456, 48},
    { 1520, 112, 104},
    { 1432, -40, 64},
    { 1376, 112, 24},
    { 1280, 256, 24},
    { 1152, 408, 32},
    { 1040, 576, -80},
    { 1176, 664, -8},
    { 1200, 536, -40},
    { 800, 840, -272},
    { 432, 960, -200},
    { 48, 1064, -336},
    { -80, 1088, -576},
    { 208, 920, -816},
    { 192, 712, -832},
    { 232, 320, -744},
    { 280, 168, -752},
    { 192, 40, -720},
    // 57 seconds
    { 176, 0, -768},
    { 112, -96, -736},
    { 96, -56, -824},
    { 32, -96, -936},
    { -48, -128, -920},
    { -104, -72, -1032},
    { -144, -72, -1080},
    { -208, 0, -1208},
    { -248, 208, -1176},
    { -128, 296, -1112},
    { -120, 352, -1112},
    { -32, 328, -1104},
    { -40, 128, -928},
    { -184, 288, -832},
    { -216, 312, -872},
    { -128, 320, -880},
    { -24, 440, -944},
    { 0, 440, -856},
    { -16, 520, -952},
    { -24, 536, -976},
    { -72, 584, -1016},
    { -56, 504, -928},
    { -112, 504, -888},
    { -152, 480, -864},
    { -136, 496, -864},
    // 58 seconds
    { -88, 544, -832},
    { -80, 632, -728},
    { -56, 824, -584},
    { -56, 936, -400},
    { -152, 1048, -120},
    { -168, 1208, 56},
    { -224, 1192, 160},
    { -216, 968, 200},
    { -232, 1032, 296},
    { -240, 1032, 288},
    { -224, 1016, 304},
    { -224, 984, 312},
    { -208, 952, 280},
    { -240, 960, 352},
    { -232, 968, 208},
    { -232, 968, 216},
    { -240, 976, 192},
    { -264, 912, 208},
    { -248, 896, 256},
    { -272, 960, 208},
    { -320, 976, 240},
    { -336, 936, 224},
    { -336, 984, 240},
    { -312, 928, 144},
    { -320, 928, 168},
    // 59 seconds
    { -304, 912, 176},
    { -320, 960, 168},
    { -328, 960, 168},
    { -328, 960, 152},
    { -336, 928, 160},
    { -304, 920, 176},
    { -328, 1016, 208},
    { -336, 1016, 184},
    { -344, 912, 208},
    { -328, 992, 144},
    { -240, 816, 136},
    { -352, 1016, 224},
    { -320, 936, 160},
    { -288, 952, 144},
    { -304, 1040, 184},
    { -336, 968, 200},
    { -320, 920, 160},
    { -248, 896, 144},
    { -336, 992, 208},
    { -328, 976, 184},
    { -280, 944, 136},
    { -296, 976, 176},
    { -336, 936, 216},
    { -320, 960, 216},
    { -312, 944, 192},
    // 60 seconds
    // elapsed: 1 minutes
    { -304, 952, 168},
    { -288, 968, 144},
    { -280, 984, 184},
    { -304, 984, 208},
    { -312, 952, 208},
    { -296, 944, 168},
    { -288, 960, 200},
    { -288, 904, 200},
    { -344, 984, 240},
    { -304, 960, 200},
    { -280, 952, 176},
    { -280, 960, 216},
    { -312, 976, 232},
    { -312, 968, 216},
    { -296, 944, 216},
    { -288, 952, 208},
    { -280, 936, 192},
    { -264, 944, 192},
    { -280, 976, 240},
    { -304, 952, 232},
    { -312, 976, 160},
    { -296, 968, 184},
    { -256, 880, 224},
    { -288, 984, 208},
    { -312, 1024, 192},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-09-28 17:13:12 local
AccelRawData *activity_sample_100_steps_heather_20(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_heather_20
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 40
  //> TEST_EXPECTED_MAX 105
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -8, 216, -1008},
    { 192, 288, -1000},
    { 368, 224, -1064},
    { 240, 56, -976},
    { 176, 360, -920},
    { 72, 712, -736},
    { -96, 952, -592},
    { -96, 1008, -472},
    { -96, 992, -232},
    { -72, 1040, -136},
    { -56, 1064, -96},
    { -64, 1056, -24},
    { -80, 1056, -24},
    { -112, 1080, 24},
    { -128, 1104, -16},
    { -120, 1032, -96},
    { -120, 1088, -280},
    { -88, 968, -440},
    { -56, 728, -616},
    { 8, 560, -808},
    { 48, 664, -928},
    { 8, 664, -904},
    { -16, 560, -856},
    { -32, 560, -936},
    { -16, 392, -968},
    // 1 seconds
    { -24, 424, -920},
    { -40, 384, -952},
    { 64, 336, -968},
    { -40, 304, -968},
    { -16, 240, -984},
    { 0, 248, -976},
    { 208, 176, -1040},
    { -120, 240, -952},
    { -80, 248, -992},
    { -72, 200, -1008},
    { -136, 232, -1048},
    { 0, 176, -1064},
    { 16, 296, -1064},
    { 40, 328, -1024},
    { -16, 288, -976},
    { -8, 272, -984},
    { -40, 288, -976},
    { -32, 296, -1008},
    { -32, 296, -1008},
    { 48, 328, -1032},
    { 8, 264, -968},
    { 152, 24, -1056},
    { -112, 176, -936},
    { -128, 184, -968},
    { -144, 176, -1080},
    // 2 seconds
    { -40, 216, -1080},
    { 80, 368, -1080},
    { 296, 272, -1064},
    { 32, 328, -968},
    { 24, 296, -936},
    { 0, 312, -952},
    { -8, 328, -968},
    { -24, 352, -1008},
    { -16, 352, -1016},
    { -16, 384, -1000},
    { -24, 424, -1000},
    { -24, 432, -992},
    { -8, 384, -968},
    { -16, 424, -952},
    { -16, 384, -928},
    { -8, 376, -912},
    { 8, 384, -896},
    { 16, 400, -864},
    { 32, 504, -824},
    { 40, 640, -752},
    { 40, 568, -760},
    { 64, 608, -832},
    { 56, 768, -928},
    { 40, 864, -800},
    { 72, 808, -712},
    // 3 seconds
    { 72, 752, -672},
    { 32, 656, -584},
    { 32, 712, -568},
    { 0, 792, -592},
    { 8, 912, -632},
    { 8, 1080, -672},
    { 120, 1192, -712},
    { 104, 1144, -728},
    { 72, 1120, -768},
    { 176, 1232, -720},
    { 216, 1120, -576},
    { 216, 632, -416},
    { 200, 592, -488},
    { 160, 704, -600},
    { 184, 752, -696},
    { 104, 648, -688},
    { -8, 576, -680},
    { -80, 552, -720},
    { -128, 400, -848},
    { -176, 376, -1008},
    { -104, 592, -1064},
    { -40, 624, -968},
    { 0, 408, -808},
    { 176, 128, -624},
    { 464, 40, -296},
    // 4 seconds
    { 848, 176, 32},
    { 1272, 488, 152},
    { 1896, 872, -32},
    { 1744, 824, -184},
    { 1512, 472, -144},
    { 1352, 408, -88},
    { 1224, 424, 16},
    { 1224, 296, 56},
    { 1224, 200, 48},
    { 1296, 360, -16},
    { 1184, 448, -40},
    { 1152, 496, -112},
    { 1504, 600, -352},
    { 1072, 592, -192},
    { 1144, 712, -312},
    { 944, 784, -464},
    { 752, 496, -232},
    { 1152, 600, -8},
    { 1616, 488, 16},
    { 1504, 296, -24},
    { 1440, 200, -16},
    { 1496, 88, 64},
    { 1512, 152, 48},
    { 1408, 248, -32},
    { 1168, 264, -56},
    // 5 seconds
    { 1184, 208, -88},
    { 1200, 128, -184},
    { 944, -48, -256},
    { 1016, -232, 112},
    { 1224, 104, -96},
    { 1168, 232, -216},
    { 1256, 208, -136},
    { 1272, 184, -208},
    { 1176, 232, -224},
    { 1208, 544, -144},
    { 1264, 376, -88},
    { 1312, 368, 48},
    { 1184, 456, 72},
    { 1280, 400, -88},
    { 1536, 544, 16},
    { 1096, 824, -40},
    { 1416, 1048, -296},
    { 1032, 672, -304},
    { 864, 392, -192},
    { 1176, 448, -40},
    { 1552, 504, -32},
    { 1424, 400, -64},
    { 1432, 72, 16},
    { 1288, -8, 88},
    { 1264, 120, 16},
    // 6 seconds
    { 1168, 208, -8},
    { 1120, 232, 24},
    { 1256, 216, 48},
    { 1200, 184, -32},
    { 1048, -368, 152},
    { 1288, -168, 208},
    { 1472, 312, -200},
    { 1344, 240, -208},
    { 1456, 160, -368},
    { 1280, 128, -296},
    { 1032, 304, -48},
    { 1096, 376, -16},
    { 1168, 416, 64},
    { 1152, 504, -72},
    { 1064, 440, -136},
    { 1424, 592, -8},
    { 960, 928, -56},
    { 1352, 808, -176},
    { 1312, 544, -208},
    { 1048, 448, -184},
    { 1344, 576, -48},
    { 1736, 680, -80},
    { 1768, 688, 96},
    { 1880, 296, 448},
    { 1672, 288, -48},
    // 7 seconds
    { 1496, 392, -88},
    { 1208, 424, -144},
    { 992, 264, -216},
    { 920, 216, -424},
    { 736, 128, -496},
    { 496, 32, -528},
    { 440, 24, -1040},
    { 400, 32, -1072},
    { 384, -40, -944},
    { 344, -32, -880},
    { 192, -104, -792},
    { -16, -120, -712},
    { -96, -104, -648},
    { -88, 16, -656},
    { -32, 368, -864},
    { -120, 360, -984},
    { -192, 352, -1160},
    { 32, 40, -1328},
    { -72, 8, -1400},
    { -24, 168, -1384},
    { 80, 464, -1248},
    { -80, 456, -1008},
    { -64, 384, -968},
    { 88, -48, -856},
    { 88, -336, -640},
    // 8 seconds
    { -56, -256, -512},
    { -8, -104, -336},
    { 192, 176, -256},
    { 520, 312, -72},
    { 1040, 456, 168},
    { 1784, 592, 408},
    { 2072, 848, 208},
    { 2560, 616, -56},
    { 2160, 552, -320},
    { 1672, 376, -224},
    { 1576, 440, 32},
    { 1200, 344, 112},
    { 888, 224, 56},
    { 720, 312, -32},
    { 824, 440, -80},
    { 984, 472, -144},
    { 832, 584, 80},
    { 1192, 744, 264},
    { 832, 864, 216},
    { 1272, 672, 120},
    { 1304, 600, -8},
    { 1304, 592, -8},
    { 1544, 672, 152},
    { 1872, 680, 288},
    { 1728, 456, 240},
    // 9 seconds
    { 1456, 136, 160},
    { 1384, 176, -16},
    { 1256, 128, 24},
    { 1096, 104, 168},
    { 920, 112, 168},
    { 952, 152, 56},
    { 888, 160, -24},
    { 792, 136, -104},
    { 1080, 184, 24},
    { 1264, 272, -96},
    { 1656, 120, 136},
    { 2288, 552, -184},
    { 1584, 448, -488},
    { 976, 752, -544},
    { 992, 232, -272},
    { 1096, 344, -88},
    { 1120, 384, -16},
    { 912, 544, -24},
    { 1136, 456, 88},
    { 1232, 632, 56},
    { 816, 840, 64},
    { 1200, 800, -184},
    { 1200, 896, -200},
    { 1248, 720, -200},
    { 1448, 768, -216},
    // 10 seconds
    { 1816, 784, -288},
    { 1808, -48, 176},
    { 1152, -280, 408},
    { 1176, -48, -128},
    { 1112, 64, -136},
    { 1008, 216, -88},
    { 1096, 296, -224},
    { 1152, 272, -288},
    { 816, 144, -280},
    { 888, 112, -136},
    { 1072, -16, -96},
    { 1464, -8, -280},
    { 1912, 144, -216},
    { 1568, 360, -320},
    { 904, 520, -568},
    { 776, 352, -448},
    { 960, 280, -224},
    { 1128, 256, -96},
    { 1016, 320, -96},
    { 1040, 392, -104},
    { 1320, 528, -104},
    { 1200, 720, -152},
    { 1344, 928, -360},
    { 1288, 752, -336},
    { 1024, 536, -128},
    // 11 seconds
    { 1352, 400, -376},
    { 1752, 472, -256},
    { 1600, 184, 72},
    { 1024, -216, 144},
    { 960, 16, -48},
    { 968, 64, -16},
    { 1000, 240, -16},
    { 1016, 296, 72},
    { 1280, 296, 48},
    { 976, 248, -176},
    { 1120, 184, -152},
    { 1272, 192, 8},
    { 1112, 192, -192},
    { 1344, 160, -200},
    { 1488, 176, -288},
    { 1016, 248, -312},
    { 768, 248, -256},
    { 832, 208, -96},
    { 1000, 264, -72},
    { 1120, 328, -128},
    { 1064, 416, -280},
    { 1648, 480, -144},
    { 1040, 640, -120},
    { 1216, 928, -40},
    { 1232, 624, -376},
    // 12 seconds
    { 856, 432, -136},
    { 1104, 672, 0},
    { 1504, 536, 104},
    { 1320, 192, 8},
    { 1120, 176, -8},
    { 1120, 88, 72},
    { 1208, 184, 16},
    { 1184, 272, -32},
    { 952, 272, -48},
    { 992, 152, 8},
    { 1232, 160, -96},
    { 1008, 136, -200},
    { 1208, 80, -16},
    { 1280, 152, -168},
    { 1288, 208, -192},
    { 1472, 208, -112},
    { 1328, 240, -168},
    { 944, 312, -136},
    { 872, 392, -176},
    { 888, 272, -16},
    { 1000, 320, 8},
    { 944, 352, -32},
    { 800, 408, -120},
    { 1416, 448, 56},
    { 1312, 672, 32},
    // 13 seconds
    { 1008, 1032, -152},
    { 1448, 520, -168},
    { 888, 416, -168},
    { 1024, 536, -16},
    { 1448, 576, -8},
    { 1520, 456, -40},
    { 1416, 320, 40},
    { 1152, -304, 184},
    { 1160, 184, -112},
    { 1064, 96, -56},
    { 896, 256, -144},
    { 816, 256, -72},
    { 1112, 200, -40},
    { 928, 192, -216},
    { 1008, 128, -136},
    { 1272, 128, 88},
    { 1144, 208, -56},
    { 1328, 272, -56},
    { 1512, 344, -112},
    { 1360, 240, -296},
    { 952, 272, -240},
    { 952, 232, -24},
    { 1008, 288, -32},
    { 1056, 320, -64},
    { 912, 344, -176},
    // 14 seconds
    { 1016, 408, -8},
    { 1680, 648, -128},
    { 1024, 1008, 160},
    { 1240, 720, -416},
    { 1240, 240, -80},
    { 840, 496, -176},
    { 1112, 616, -24},
    { 1440, 568, -24},
    { 1344, 352, -8},
    { 1240, 200, 32},
    { 1160, 120, 40},
    { 1184, 128, -8},
    { 1160, 168, -80},
    { 976, 184, -176},
    { 728, 184, -184},
    { 1024, 192, -176},
    { 992, 152, -232},
    { 1312, 120, -32},
    { 1448, 112, 120},
    { 1080, 256, -16},
    { 1112, 272, -64},
    { 1224, 312, -112},
    { 1040, 328, -200},
    { 872, 264, -248},
    { 944, 280, -144},
    // 15 seconds
    { 1104, 224, -72},
    { 1216, 352, -120},
    { 1144, 432, -192},
    { 1096, 480, -64},
    { 1432, 720, -24},
    { 936, 928, -192},
    { 1464, 496, -128},
    { 1208, 568, -192},
    { 984, 504, -128},
    { 1240, 560, -48},
    { 1672, 552, -40},
    { 1480, 224, 120},
    { 1192, 40, 64},
    { 1024, 8, 32},
    { 1024, 112, -24},
    { 944, 216, -16},
    { 872, 248, -8},
    { 1144, 232, 40},
    { 1128, 272, -72},
    { 1056, 248, -200},
    { 1232, 168, -48},
    { 1120, 232, -160},
    { 1048, 184, -280},
    { 1312, 224, -320},
    { 1248, 176, -320},
    // 16 seconds
    { 816, 152, -232},
    { 816, 208, -272},
    { 960, 272, -128},
    { 1168, 336, -192},
    { 1120, 312, -184},
    { 1040, 408, -72},
    { 1560, 584, -8},
    { 1120, 632, 248},
    { 1080, 688, -48},
    { 1472, 840, -64},
    { 896, 608, -128},
    { 1032, 576, -104},
    { 1384, 640, -184},
    { 1560, 528, 136},
    { 1472, -112, 256},
    { 1040, -240, 200},
    { 1072, 112, -8},
    { 1040, 160, -8},
    { 944, 328, -64},
    { 784, 296, 0},
    { 1080, 264, 0},
    { 1088, 216, -168},
    { 1056, 136, -152},
    { 1280, 72, -8},
    { 1224, 168, -224},
    // 17 seconds
    { 1272, 208, -256},
    { 1280, 296, -280},
    { 1008, 240, -280},
    { 824, 224, -216},
    { 936, 256, -216},
    { 1000, 264, -120},
    { 1000, 272, -40},
    { 920, 304, -24},
    { 800, 368, -48},
    { 1232, 384, 16},
    { 1488, 520, -32},
    { 1224, 672, 88},
    { 1336, 696, -352},
    { 984, 512, -248},
    { 928, 464, -256},
    { 1216, 536, -432},
    { 1368, 512, -136},
    { 1408, 320, 248},
    { 1008, -32, 208},
    { 904, -40, 64},
    { 912, 48, -16},
    { 960, 208, -48},
    { 912, 280, -24},
    { 824, 280, -24},
    { 1328, 264, -96},
    // 18 seconds
    { 1104, 192, -152},
    { 1280, 96, -192},
    { 1416, 40, -152},
    { 1072, 8, -296},
    { 864, 72, -360},
    { 1000, 64, -376},
    { 1080, 136, -328},
    { 952, 192, -400},
    { 856, 128, -272},
    { 1016, -272, -424},
    { 1008, 24, -232},
    { 992, 240, -152},
    { 840, 152, -152},
    { 824, 264, -48},
    { 1304, 424, -112},
    { 1280, 520, -168},
    { 1520, 512, -72},
    { 1376, 960, -448},
    { 704, 408, -376},
    { 864, 512, -560},
    { 1264, 392, -560},
    { 1504, 264, -144},
    { 1232, -56, 8},
    { 1072, -88, -64},
    { 1032, 104, -248},
    // 19 seconds
    { 1032, 176, -256},
    { 928, 184, -144},
    { 776, 144, -192},
    { 864, 112, -176},
    { 1184, 8, -272},
    { 1032, 0, -216},
    { 1248, 88, 24},
    { 1432, 176, -112},
    { 1312, 256, -224},
    { 1256, 168, -136},
    { 1184, 168, -216},
    { 984, -72, -352},
    { 736, 336, -288},
    { 728, 88, -96},
    { 808, 128, -72},
    { 936, 216, -56},
    { 928, 280, -88},
    { 1112, 296, -192},
    { 1520, 248, -248},
    { 1160, 552, -120},
    { 1368, 440, -448},
    { 1264, 544, -672},
    { 936, 320, -528},
    { 1064, 192, -400},
    { 1312, 296, -360},
    // 20 seconds
    { 1312, 192, -216},
    { 1184, 48, -128},
    { 1104, 72, -144},
    { 1128, 112, -160},
    { 1096, 144, -120},
    { 976, 120, -160},
    { 880, 152, -144},
    { 1200, 136, -200},
    { 1120, 72, -328},
    { 1144, 24, -24},
    { 1336, 40, 0},
    { 1184, 200, -88},
    { 1200, 256, -208},
    { 1272, 240, -232},
    { 1056, 208, -256},
    { 832, 216, -216},
    { 832, 128, -144},
    { 864, 240, -48},
    { 1008, 384, -88},
    { 960, 344, -208},
    { 1072, 336, -224},
    { 1536, 360, -160},
    { 1088, 576, -144},
    { 1336, 672, -352},
    { 1152, 528, -376},
    // 21 seconds
    { 824, 456, -320},
    { 1072, 424, -168},
    { 1376, 448, -136},
    { 1288, 384, -64},
    { 1216, 304, -32},
    { 1160, 304, 120},
    { 1184, 72, -8},
    { 1064, 128, -96},
    { 888, 32, -176},
    { 832, 128, -184},
    { 1248, 88, -216},
    { 1032, 104, -272},
    { 1160, 112, -128},
    { 1424, 48, 24},
    { 1288, 192, -144},
    { 1192, 280, -144},
    { 1200, 312, -216},
    { 1040, 312, -184},
    { 832, 256, -152},
    { 800, 312, -104},
    { 872, 312, -80},
    { 992, 336, -80},
    { 960, 72, -392},
    { 960, 272, -352},
    { 1432, 456, -200},
    // 22 seconds
    { 1016, 568, -184},
    { 1336, 600, -376},
    { 1408, 576, -360},
    { 992, 536, -304},
    { 1272, 536, -136},
    { 1592, 520, 0},
    { 1304, 264, 104},
    { 1232, 80, 88},
    { 1056, 56, 72},
    { 1032, 136, -32},
    { 984, 192, -24},
    { 880, 176, -8},
    { 872, 192, 8},
    { 1216, 160, -24},
    { 920, 200, -168},
    { 1112, 136, -88},
    { 1392, 120, -16},
    { 1256, 192, -144},
    { 1296, 280, -264},
    { 1392, 200, -424},
    { 1016, 280, -368},
    { 816, 192, -312},
    { 808, 208, -280},
    { 856, 208, -160},
    { 944, 264, -160},
    // 23 seconds
    { 904, 304, -200},
    { 952, 352, -144},
    { 1600, 440, -96},
    { 1232, 720, -136},
    { 1560, 888, -304},
    { 1184, 280, -224},
    { 816, 424, -136},
    { 1184, 488, -48},
    { 1552, 432, -8},
    { 1336, 152, -32},
    { 1096, -8, 24},
    { 912, 96, 40},
    { 960, 128, -32},
    { 960, 224, -16},
    { 896, 224, -32},
    { 1080, 208, -8},
    { 1304, 232, -80},
    { 1080, 184, -112},
    { 1336, 128, 32},
    { 1352, 208, -72},
    { 1088, 232, -208},
    { 1192, 200, -192},
    { 1192, 288, -272},
    { 936, 200, -192},
    { 856, 216, -216},
    // 24 seconds
    { 856, 264, -160},
    { 904, 280, -104},
    { 928, 312, -192},
    { 840, 288, -232},
    { 1088, 320, -96},
    { 1440, 400, -88},
    { 1032, 520, -80},
    { 1384, 672, -152},
    { 1280, 704, -408},
    { 968, 440, -144},
    { 1176, 512, -32},
    { 1472, 448, -40},
    { 1392, 264, -48},
    { 1264, 64, -8},
    { 1184, 64, -24},
    { 1160, 128, -72},
    { 1080, 176, -64},
    { 928, 200, -104},
    { 784, 200, -72},
    { 1152, 200, -104},
    { 944, 160, -232},
    { 1072, 56, -40},
    { 1312, 40, 88},
    { 1168, 168, -144},
    { 1200, 224, -144},
    // 25 seconds
    { 1416, 272, -248},
    { 1096, 248, -280},
    { 928, 176, -112},
    { 1056, 320, -24},
    { 1264, 344, 48},
    { 1272, 440, 56},
    { 992, 448, -80},
    { 856, 432, -72},
    { 1424, 568, -72},
    { 944, 704, -104},
    { 1024, 512, -200},
    { 1488, 568, -160},
    { 976, 544, -272},
    { 1080, 512, -160},
    { 1376, 536, -56},
    { 1592, 464, 56},
    { 1512, 168, 104},
    { 1288, 16, 136},
    { 1152, 88, 80},
    { 1080, 152, 24},
    { 952, 240, 8},
    { 784, 232, 0},
    { 936, 224, 72},
    { 1224, 240, -88},
    { 960, 192, -152},
    // 26 seconds
    { 1328, 112, -8},
    { 1376, 168, -112},
    { 1168, 176, -272},
    { 1232, 160, -288},
    { 1104, 200, -256},
    { 896, 128, -144},
    { 968, 232, -168},
    { 1096, 272, -24},
    { 1176, 384, -16},
    { 1104, 432, -80},
    { 904, 416, -48},
    { 1344, 480, 80},
    { 1256, 568, 72},
    { 1392, 688, -48},
    { 1152, 768, -392},
    { 720, 464, -248},
    { 992, 528, -152},
    { 1536, 600, -88},
    { 1544, 224, 8},
    { 1256, -216, 120},
    { 1040, -8, -8},
    { 1072, 160, -48},
    { 1040, 352, -56},
    { 936, 352, -88},
    { 888, 240, -16},
    // 27 seconds
    { 1224, 160, -32},
    { 1048, 136, -112},
    { 1200, 72, 112},
    { 1104, 160, -40},
    { 984, 224, -200},
    { 1192, 224, -256},
    { 1184, 224, -264},
    { 952, 200, -248},
    { 920, 184, -256},
    { 1016, 232, -192},
    { 1168, 288, -168},
    { 1152, 432, -224},
    { 976, 384, -128},
    { 1464, 464, -104},
    { 1248, 632, -120},
    { 1264, 912, -144},
    { 1320, 360, -272},
    { 776, 336, -120},
    { 992, 448, -104},
    { 1408, 488, -120},
    { 1280, 328, -64},
    { 1112, 104, 8},
    { 1056, 64, 32},
    { 1104, 144, -16},
    { 1072, 232, 0},
    // 28 seconds
    { 920, 248, -8},
    { 960, 216, 32},
    { 1296, 208, 0},
    { 1056, 216, -104},
    { 1216, 112, 16},
    { 1192, 136, -72},
    { 1016, 200, -208},
    { 1264, 192, -232},
    { 1248, 264, -328},
    { 904, 208, -440},
    { 712, 248, -152},
    { 928, 232, -200},
    { 1032, 232, -96},
    { 1024, 392, -192},
    { 944, 368, -136},
    { 1440, 464, -8},
    { 1256, 600, -32},
    { 1032, 736, -32},
    { 1376, 536, -288},
    { 944, 448, -144},
    { 1008, 560, -32},
    { 1360, 520, -24},
    { 1392, 400, 0},
    { 1224, 200, 24},
    { 1120, 56, 104},
    // 29 seconds
    { 1072, 96, 40},
    { 1024, 168, -16},
    { 896, 224, -56},
    { 760, 200, -8},
    { 1064, 176, 48},
    { 1088, 208, -112},
    { 1016, 160, -120},
    { 1352, 136, 64},
    { 1336, 216, -128},
    { 1296, 280, -376},
    { 1288, 232, -320},
    { 952, 240, -296},
    { 784, 24, -96},
    { 824, 280, -144},
    { 920, 280, -96},
    { 984, 344, -104},
    { 976, 352, -168},
    { 880, 320, -104},
    { 1432, 440, -64},
    { 1200, 584, -120},
    { 1240, 712, -128},
    { 1624, 504, -296},
    { 1024, 440, -192},
    { 1128, 472, -136},
    { 1416, 448, -32},
    // 30 seconds
    { 1280, 184, 0},
    { 1064, 96, 0},
    { 968, 64, 8},
    { 968, 144, -24},
    { 1024, 192, -72},
    { 968, 200, -56},
    { 856, 184, -56},
    { 1096, 192, -16},
    { 1056, 216, -168},
    { 1144, 144, -176},
    { 1280, 120, 64},
    { 1304, 184, -96},
    { 1288, 272, -216},
    { 1344, 264, -272},
    { 976, 208, -328},
    { 720, 128, -240},
    { 784, 144, -136},
    { 888, 256, -64},
    { 1088, 328, -144},
    { 1008, 376, -216},
    { 1208, 336, -40},
    { 1568, 552, 40},
    { 1048, 840, 40},
    { 1392, 720, -192},
    { 1208, 504, -136},
    // 31 seconds
    { 960, 544, -184},
    { 1184, 568, -40},
    { 1480, 528, 56},
    { 1448, 328, 104},
    { 1272, 120, 72},
    { 1160, 32, 56},
    { 1104, 80, -16},
    { 1048, 160, -48},
    { 920, 216, -72},
    { 800, 168, -48},
    { 1016, 152, -8},
    { 1008, 208, -136},
    { 1072, 200, -136},
    { 1360, 200, 48},
    { 1464, 280, -128},
    { 1304, 328, -240},
    { 1144, 264, -88},
    { 1096, 184, -184},
    { 952, 160, -136},
    { 896, 296, -320},
    { 976, 48, -168},
    { 1024, 128, -16},
    { 944, 368, 0},
    { 832, 552, -88},
    { 1192, 664, -96},
    // 32 seconds
    { 1488, 752, -96},
    { 968, 672, 64},
    { 1304, 440, -40},
    { 1104, 456, -40},
    { 872, 528, -112},
    { 1024, 552, -24},
    { 1288, 512, 56},
    { 1296, 368, 136},
    { 1248, 192, 88},
    { 1168, 96, 72},
    { 1136, 160, 16},
    { 1088, 176, -16},
    { 976, 224, -72},
    { 848, 176, -128},
    { 944, 152, -56},
    { 1104, 184, -168},
    { 1040, 208, -232},
    { 1336, 168, -248},
    { 1256, 208, -208},
    { 1032, 176, -256},
    { 992, 192, -192},
    { 1112, 232, -112},
    { 1072, 264, -248},
    { 896, 296, -240},
    { 808, 240, -144},
    // 33 seconds
    { 960, 272, -104},
    { 1080, 280, -88},
    { 1064, 312, -184},
    { 856, 336, -136},
    { 1360, 440, -56},
    { 1464, 672, -208},
    { 880, 992, -112},
    { 1304, 272, -200},
    { 1160, 416, -144},
    { 1000, 608, -232},
    { 1072, 584, -144},
    { 1256, 392, 72},
    { 1400, 176, 120},
    { 1264, 152, 56},
    { 1152, 176, 64},
    { 1152, 224, 80},
    { 1112, 280, 112},
    { 1064, 280, 80},
    { 920, 232, 8},
    { 912, 192, -16},
    { 1064, 176, -80},
    { 1008, 152, -216},
    { 1000, 96, -360},
    { 1000, 32, -328},
    { 1272, 32, -168},
    // 34 seconds
    { 1136, 152, -472},
    { 1152, 224, -520},
    { 1208, 184, -272},
    { 1096, 168, -88},
    { 992, 224, -120},
    { 944, 320, -112},
    { 984, 336, -72},
    { 992, 352, -80},
    { 928, 352, -144},
    { 888, 352, -104},
    { 1320, 416, -8},
    { 1160, 640, 8},
    { 1088, 720, -240},
    { 1352, 416, -184},
    { 1000, 536, -168},
    { 992, 552, -120},
    { 1352, 464, -56},
    { 1544, 320, -48},
    { 1504, 160, 48},
    { 1152, 72, 104},
    { 1072, 56, 8},
    { 1000, 152, 40},
    { 912, 272, -8},
    { 768, 256, 0},
    { 1080, 232, 40},
    // 35 seconds
    { 1240, 248, -32},
    { 1000, 192, -64},
    { 1200, 144, -8},
    { 1232, 216, -104},
    { 1088, 248, -280},
    { 1152, 264, -320},
    { 1144, 224, -288},
    { 872, 240, -144},
    { 824, 168, -176},
    { 928, 224, -128},
    { 968, 296, -128},
    { 976, 296, -96},
    { 808, 296, -128},
    { 840, 312, -96},
    { 1248, 376, -72},
    { 1232, 472, -136},
    { 904, 440, -88},
    { 1288, 392, -168},
    { 1520, 552, -232},
    { 904, 512, -136},
    { 1040, 440, -96},
    { 1272, 352, -64},
    { 1192, 232, -24},
    { 1088, 152, 40},
    { 1088, 120, 24},
    // 36 seconds
    { 1080, 160, 8},
    { 1056, 232, 16},
    { 936, 224, -16},
    { 896, 216, -8},
    { 1240, 232, -40},
    { 1152, 248, -120},
    { 1192, 168, -40},
    { 1432, 152, -56},
    { 1064, 240, -200},
    { 944, 288, -224},
    { 1016, 208, -136},
    { 928, 240, -56},
    { 848, -8, 88},
    { 968, 232, 40},
    { 864, 752, 160},
    { 856, 632, 184},
    { 824, 544, -16},
    { 784, 240, -160},
    { 904, 224, -296},
    { 1024, 776, 136},
    { 1256, 776, 328},
    { 1080, 512, 360},
    { 1288, 360, -128},
    { 1432, 648, 56},
    { 1112, 168, 400},
    // 37 seconds
    { 912, 176, 272},
    { 872, -16, 248},
    { 864, 16, 248},
    { 800, 80, 296},
    { 792, 144, 224},
    { 856, 72, 120},
    { 920, 80, 144},
    { 920, 176, 176},
    { 1040, 264, 520},
    { 1072, 64, 200},
    { 1288, 40, 224},
    { 1536, 176, 232},
    { 1408, 104, 128},
    { 1360, -160, 88},
    { 1128, 216, 24},
    { 840, -160, 160},
    { 752, -312, 184},
    { 864, -352, 40},
    { 736, -144, -32},
    { 720, -112, -24},
    { 648, 40, 96},
    { 648, 168, 272},
    { 744, 344, 336},
    { 960, 152, 8},
    { 1184, 88, -192},
    // 38 seconds
    { 1520, 384, 96},
    { 1576, 536, 328},
    { 1288, 0, 568},
    { 1296, 256, 56},
    { 1192, 152, 160},
    { 1008, -24, 424},
    { 936, -72, 584},
    { 864, -56, 568},
    { 800, 56, 320},
    { 688, -48, 208},
    { 672, 24, 144},
    { 664, 152, 224},
    { 768, 304, 328},
    { 864, 112, 424},
    { 1136, -184, 544},
    { 1424, -312, 672},
    { 1632, 160, 536},
    { 1584, 232, 688},
    { 1120, 488, 440},
    { 848, 296, 184},
    { 688, 176, 136},
    { 776, -16, 128},
    { 912, -160, 112},
    { 936, -384, 8},
    { 896, -8, 0},
    // 39 seconds
    { 808, 152, 96},
    { 768, 168, 96},
    { 776, 48, 8},
    { 808, 0, 88},
    { 816, 224, 256},
    { 1120, 496, 264},
    { 1376, 704, 672},
    { 1272, 352, 584},
    { 1368, 424, -160},
    { 1376, 336, -48},
    { 1240, -48, 0},
    { 1048, -160, 168},
    { 824, -16, 360},
    { 744, 160, 104},
    { 584, 72, 112},
    { 456, 48, 200},
    { 496, 96, 304},
    { 752, -168, 32},
    { 1056, -24, 272},
    { 1200, 48, 608},
    { 1320, 168, 992},
    { 1344, 168, 760},
    { 1336, 48, 408},
    { 1088, 184, 176},
    { 976, -24, -96},
    // 40 seconds
    { 1008, -632, -16},
    { 928, -576, 248},
    { 768, -168, 296},
    { 592, -8, 64},
    { 568, 272, 0},
    { 576, 392, 176},
    { 816, 352, 240},
    { 944, 64, 120},
    { 1008, 64, 336},
    { 1360, 32, -32},
    { 1496, 896, 88},
    { 1192, 720, 448},
    { 1200, 424, 32},
    { 1144, 400, -128},
    { 1040, 560, 104},
    { 896, 624, 232},
    { 1024, 584, 144},
    { 1096, 400, -104},
    { 896, 248, -88},
    { 688, 424, 56},
    { 760, 584, -216},
    { 904, 640, -224},
    { 1056, 600, -304},
    { 1088, 472, -360},
    { 1136, 336, -216},
    // 41 seconds
    { 1240, 280, -312},
    { 1096, 264, -400},
    { 1128, 152, -280},
    { 1176, 144, -128},
    { 1088, 168, -136},
    { 1040, 192, -64},
    { 1080, 208, -88},
    { 944, 248, -144},
    { 840, 272, -136},
    { 840, 272, -128},
    { 944, 344, -96},
    { 1112, 312, -32},
    { 1192, 360, -88},
    { 1216, 408, -152},
    { 1728, 536, -104},
    { 1240, 680, -48},
    { 1056, 856, -336},
    { 1168, 664, -352},
    { 1056, 984, -472},
    { 1248, 992, -224},
    { 1752, 688, 104},
    { 1912, 552, 80},
    { 1904, 664, -32},
    { 1952, 784, -72},
    { 1840, 544, -104},
    // 42 seconds
    { 1464, 496, -168},
    { 1136, 488, -344},
    { 856, 264, -376},
    { 592, -48, -392},
    { 528, -136, -568},
    { 320, -160, -512},
    { 168, -280, -680},
    { 32, -400, -920},
    { 72, -208, -1040},
    { 264, -120, -992},
    { 216, -64, -864},
    { 128, -64, -840},
    { 16, -64, -864},
    { -8, -96, -856},
    { -8, -128, -848},
    { -24, -88, -840},
    { -72, -104, -864},
    { -144, -112, -952},
    { -216, -64, -1112},
    { -152, 152, -1072},
    { -424, 488, -520},
    { -760, 912, -32},
    { -760, 1176, 248},
    { -656, 1208, 152},
    { -552, 976, 72},
    // 43 seconds
    { -448, 912, 216},
    { -240, 864, 192},
    { -192, 824, 40},
    { -232, 824, -32},
    { -256, 808, -184},
    { -304, 960, -256},
    { -296, 1064, -208},
    { -360, 1136, 24},
    { -312, 1232, 120},
    { -112, 1216, 96},
    { -152, 992, 240},
    { -264, 1048, 680},
    { -120, 1312, 872},
    { -56, 992, 656},
    { 80, 744, 464},
    { 80, 592, 296},
    { 48, 480, 176},
    { -8, 560, 216},
    { -80, 616, 288},
    { -184, 760, 384},
    { -304, 920, 464},
    { -520, 992, 392},
    { -696, 1280, 488},
    { -544, 1296, 504},
    { -480, 888, 696},
    // 44 seconds
    { -416, 1264, 1016},
    { -104, 1224, 864},
    { -200, 984, 632},
    { -72, 616, 424},
    { -24, 976, 184},
    { 104, 800, 16},
    { 96, 616, -88},
    { 16, 552, -72},
    { -72, 736, -120},
    { -112, 1088, -144},
    { -72, 1104, -144},
    { -56, 1008, -288},
    { 96, 1120, -400},
    { 192, 928, -448},
    { -64, 1224, -400},
    { -40, 2264, -264},
    { 160, 1496, -128},
    { 312, 608, -112},
    { 304, 856, -176},
    { 192, 904, -120},
    { 80, 584, -8},
    { 16, 520, 56},
    { -56, 672, 80},
    { -160, 776, 144},
    { -256, 912, 120},
    // 45 seconds
    { -440, 1056, -24},
    { -512, 1784, -536},
    { 152, 1720, -936},
    { 152, 1768, -584},
    { 248, 1368, -600},
    { 320, 776, -472},
    { 160, 912, -560},
    { 184, 672, -552},
    { 288, 544, -512},
    { 216, 616, -552},
    { 168, 512, -560},
    { 72, 536, -512},
    { 80, 616, -592},
    { 112, 568, -552},
    { 280, 480, -488},
    { 608, 648, -584},
    { 800, 472, -496},
    { 1112, 424, -344},
    { 1648, 376, -272},
    { 1872, 336, -296},
    { 1584, 272, -312},
    { 1200, 240, -328},
    { 1000, 336, -248},
    { 912, 136, -352},
    { 888, 144, -224},
    // 46 seconds
    { 928, 472, -168},
    { 1040, 256, -96},
    { 1040, 296, -128},
    { 928, 288, -216},
    { 832, 280, -240},
    { 768, 280, -232},
    { 888, 288, -136},
    { 1344, 328, -144},
    { 1304, 424, -216},
    { 1088, 392, -168},
    { 1056, 360, -96},
    { 1008, 296, -64},
    { 1000, 240, -24},
    { 928, 200, 16},
    { 888, 208, 16},
    { 944, 232, -16},
    { 936, 240, 8},
    { 1032, 232, 16},
    { 1104, 240, 24},
    { 1352, 272, -16},
    { 1360, 304, -80},
    { 1312, 224, 0},
    { 1440, 136, 176},
    { 1152, 88, 256},
    { 968, 128, -64},
    // 47 seconds
    { 904, 160, -368},
    { 824, 16, -304},
    { 680, -40, -200},
    { 792, -80, -216},
    { 904, 40, -376},
    { 912, 0, -328},
    { 920, -128, -280},
    { 1168, -80, -216},
    { 1376, -16, -304},
    { 1336, 48, -208},
    { 1488, 208, -168},
    { 1224, 320, -192},
    { 1072, 448, -272},
    { 720, 512, -344},
    { 736, 544, -64},
    { 1168, 576, 120},
    { 1424, 328, 136},
    { 1272, 248, 64},
    { 1264, 256, 72},
    { 1296, 400, 184},
    { 1344, 688, 160},
    { 1392, 1248, 64},
    { 1448, 736, 304},
    { 1424, 448, 144},
    { 1312, 288, -72},
    // 48 seconds
    { 1192, -32, -80},
    { 1328, -176, 112},
    { 1472, 248, -144},
    { 1336, 192, -64},
    { 1296, 8, 240},
    { 1424, 216, 64},
    { 1496, 168, -328},
    { 1672, -832, -152},
    { 1088, 888, -432},
    { 1104, 272, 0},
    { 1208, 400, -152},
    { 1112, 368, -144},
    { 1320, 360, -192},
    { 1048, 528, -56},
    { 1080, 576, -56},
    { 1248, 824, -72},
    { 1000, 840, -32},
    { 1192, 648, 112},
    { 1464, 728, 344},
    { 1608, 592, 104},
    { 1640, 296, 32},
    { 1608, -200, -104},
    { 1304, -128, 56},
    { 1088, 272, -24},
    { 992, 376, -160},
    // 49 seconds
    { 832, 232, -64},
    { 1008, 160, -56},
    { 1008, 136, -208},
    { 848, 96, -96},
    { 1256, 112, 40},
    { 1816, 328, -80},
    { 1768, 576, -72},
    { 1360, 528, -144},
    { 888, 328, -160},
    { 816, 128, -88},
    { 864, 216, -80},
    { 952, 304, -96},
    { 984, 360, -120},
    { 936, 352, -120},
    { 960, 464, -200},
    { 1480, 496, -88},
    { 1192, 840, 32},
    { 1128, 680, -272},
    { 1352, 296, -24},
    { 968, 504, -160},
    { 1112, 584, -112},
    { 1456, 520, 8},
    { 1480, 176, 88},
    { 1064, 96, 88},
    { 1016, 216, 0},
    // 50 seconds
    { 1088, 344, 0},
    { 1248, 416, -8},
    { 1256, 336, -64},
    { 1080, 264, -136},
    { 1144, 120, -104},
    { 1080, 56, -272},
    { 976, -16, -200},
    { 1256, -16, -136},
    { 1224, 96, -240},
    { 1336, 144, -224},
    { 1448, 256, -368},
    { 1192, 320, -312},
    { 944, 328, -248},
    { 896, 408, -208},
    { 976, 352, -136},
    { 1048, 376, -144},
    { 1056, 392, -176},
    { 1048, 432, -120},
    { 1384, 528, -40},
    { 1072, 664, 40},
    { 1336, 736, -104},
    { 1152, 600, -136},
    { 928, 568, -200},
    { 1128, 624, -24},
    { 1552, 624, 8},
    // 51 seconds
    { 1504, 408, 104},
    { 1408, 232, 160},
    { 1368, 72, 112},
    { 1296, 104, -8},
    { 1192, 112, -56},
    { 1000, 168, -96},
    { 968, 112, -72},
    { 1040, 144, -152},
    { 864, 80, -280},
    { 1048, 32, -128},
    { 1272, 136, -24},
    { 1352, 208, -152},
    { 1552, 248, -16},
    { 1440, 248, -96},
    { 1208, 328, -344},
    { 1096, 384, -232},
    { 1056, 328, -80},
    { 1048, 296, 0},
    { 1064, 392, -64},
    { 1000, 408, -184},
    { 1248, 432, -120},
    { 1392, 544, -64},
    { 928, 656, 16},
    { 1352, 792, -112},
    { 1120, 648, -304},
    // 52 seconds
    { 936, 424, -192},
    { 1192, 600, -16},
    { 1504, 568, 96},
    { 1544, 344, 128},
    { 1456, 152, 120},
    { 1360, 88, 136},
    { 1304, 144, 64},
    { 1208, 184, 8},
    { 1016, 192, -8},
    { 840, 152, -16},
    { 1008, 152, -16},
    { 896, 160, -176},
    { 944, 104, -152},
    { 1288, 80, 64},
    { 1336, 240, -40},
    { 1472, 264, -232},
    { 1544, 216, -232},
    { 1208, 264, -288},
    { 944, 208, -264},
    { 1040, 312, -216},
    { 1088, 272, -80},
    { 1120, 392, -80},
    { 1088, 384, -200},
    { 936, 416, -184},
    { 1432, 472, -104},
    // 53 seconds
    { 1128, 600, -136},
    { 1160, 632, -104},
    { 1408, 688, -296},
    { 1008, 576, -288},
    { 1176, 712, -32},
    { 1720, 832, 144},
    { 2048, 664, 32},
    { 1872, 760, 32},
    { 1752, 1048, 120},
    { 1576, 1248, 184},
    { 1320, 1464, 328},
    { 1016, 1464, 336},
    { 720, 1216, 304},
    { 472, 472, 88},
    { 240, 408, -160},
    { 104, 272, -616},
    { -200, -8, -656},
    { -712, 192, -400},
    { -688, 584, -240},
    { -520, 440, -368},
    { -560, 560, -528},
    { -688, 624, -408},
    { -616, 264, -368},
    { -544, -56, -384},
    { -632, -184, -392},
    // 54 seconds
    { -720, -80, -536},
    { -824, -80, -600},
    { -1040, -440, -552},
    { -968, -192, -560},
    { -1072, 224, -880},
    { -1288, 0, -728},
    { -992, 200, -400},
    { -912, 176, -80},
    { -824, 136, -88},
    { -680, 88, -176},
    { -392, -8, -200},
    { -472, 64, -312},
    { -544, 112, -400},
    { -712, 96, -440},
    { -800, 168, -520},
    { -768, 144, -624},
    { -720, -216, -272},
    { -152, -504, -184},
    { 576, -120, -432},
    { 1568, 944, -984},
    { 2008, 248, -192},
    { 2584, -112, 152},
    { 2704, 464, -216},
    { 2072, 560, -272},
    { 1648, 440, 32},
    // 55 seconds
    { 1536, 392, -48},
    { 1464, 600, -32},
    { 1360, 496, -80},
    { 1296, 576, -200},
    { 1320, 656, -144},
    { 1360, 888, 80},
    { 1408, 1112, -112},
    { 832, 816, -136},
    { 1104, 680, 24},
    { 1072, 736, -176},
    { 1024, 624, -160},
    { 1424, 672, 0},
    { 1848, 616, 152},
    { 1808, 424, 240},
    { 1824, 208, 264},
    { 1688, 112, 208},
    { 1512, 144, 112},
    { 1320, 184, 80},
    { 1072, 152, -32},
    { 856, 144, -48},
    { 896, 64, 40},
    { 656, -96, -64},
    { 584, -16, -72},
    { 1144, 200, -16},
    { 1416, 288, -232},
    // 56 seconds
    { 1664, 288, -248},
    { 1896, 272, -48},
    { 1544, 288, -144},
    { 1096, 240, -200},
    { 1184, 120, -136},
    { 1304, 232, -192},
    { 1352, 240, -72},
    { 1112, 416, -136},
    { 1120, 408, 48},
    { 1560, 704, 168},
    { 992, 968, 176},
    { 1272, 936, -160},
    { 1176, 552, 8},
    { 752, 576, -136},
    { 912, 608, 24},
    { 1336, 704, 144},
    { 1784, 512, 272},
    { 1696, 240, 232},
    { 1512, 72, 168},
    { 1392, 32, 144},
    { 1272, 128, 72},
    { 1104, 208, -48},
    { 904, 232, -144},
    { 928, 176, -152},
    { 968, 64, -336},
    // 57 seconds
    { 840, -112, -232},
    { 1272, -112, 72},
    { 1464, 96, -160},
    { 1480, 232, -136},
    { 1624, 256, -136},
    { 1504, 336, -224},
    { 1296, 328, -136},
    { 1104, 360, -80},
    { 1176, 352, 48},
    { 1248, 384, 16},
    { 1080, 384, -72},
    { 848, 408, -192},
    { 1240, 512, 48},
    { 1056, 704, 272},
    { 960, 816, -24},
    { 1328, 608, 0},
    { 816, 536, -104},
    { 1048, 552, 8},
    { 1408, 632, 144},
    { 1664, 520, 136},
    { 1600, 400, 160},
    { 1600, 192, 232},
    { 1544, 96, 128},
    { 1352, 96, 24},
    { 1136, 120, -64},
    // 58 seconds
    { 872, 136, -88},
    { 776, 136, -24},
    { 928, 160, -112},
    { 792, 128, -256},
    { 912, 88, -72},
    { 1400, 128, 32},
    { 1496, 264, -216},
    { 1544, 336, -152},
    { 1464, 312, -48},
    { 1160, 192, -168},
    { 1016, 192, -72},
    { 1032, 280, 0},
    { 1072, 320, 8},
    { 1056, 344, 40},
    { 968, 392, -24},
    { 816, 408, -104},
    { 1240, 448, 0},
    { 1288, 600, -72},
    { 920, 720, 56},
    { 1408, 640, -176},
    { 1224, 528, -160},
    { 1160, 680, -168},
    { 1368, 712, 0},
    { 1680, 696, 200},
    { 1960, 520, 304},
    // 59 seconds
    { 1888, 464, 96},
    { 1608, 528, 8},
    { 1448, 752, -200},
    { 1256, 832, -128},
    { 968, 688, -48},
    { 672, 528, -176},
    { 472, 256, -296},
    { 328, 8, -424},
    { 200, -192, -592},
    { 104, -136, -824},
    { 96, 0, -1056},
    { 184, 128, -1088},
    { 280, 104, -1016},
    { 320, -24, -912},
    { 280, 8, -872},
    { 272, 64, -944},
    { 296, 104, -1016},
    { 224, 56, -1000},
    { 176, 8, -1008},
    { 184, -32, -1040},
    { 176, 0, -1056},
    { 136, 64, -1088},
    { 176, 56, -1128},
    { 112, 88, -1112},
    { 64, 48, -1056},
    // 60 seconds
    // elapsed: 1 minutes
    { 16, 64, -1024},
    { 8, 24, -960},
    { 64, 24, -872},
    { 104, 72, -704},
    { 104, 112, -904},
    { 40, 216, -1072},
    { -24, 576, -592},
    { -192, 808, -376},
    { -344, 1048, -392},
    { -392, 1048, -352},
    { -352, 888, -304},
    { -240, 1168, -568},
    { -168, 1664, -544},
    { -104, 1136, 120},
    { -88, 1104, 224},
    { -88, 1016, 360},
    { -120, 888, 408},
    { -128, 872, 376},
    { -168, 952, 352},
    { -184, 960, 264},
    { -200, 1016, 232},
    { -168, 1048, 264},
    { -168, 1000, 256},
    { -168, 976, 256},
    { -176, 944, 232},
    // 61 seconds
    { -176, 976, 208},
    { -152, 984, 232},
    { -152, 952, 224},
    { -128, 968, 176},
    { -128, 984, 280},
    { -128, 1024, 288},
    { -144, 1000, 320},
    { -144, 992, 320},
    { -160, 1000, 360},
    { -152, 976, 352},
    { -152, 1000, 328},
    { -152, 952, 328},
    { -136, 928, 328},
    { -144, 920, 368},
    { -128, 968, 368},
    { -144, 1032, 400},
    { -144, 1080, 320},
    { -152, 984, 224},
    { -144, 920, 120},
    { -128, 968, -40},
    { -96, 952, -96},
    { -104, 1096, -224},
    { -120, 1064, -192},
    { -104, 976, -312},
    { -112, 1016, -256},
    // 62 seconds
    { -88, 912, -256},
    { -104, 936, -328},
    { -80, 960, -360},
    { -72, 928, -280},
    { -64, 968, -272},
    { -64, 936, -128},
    { -48, 952, 0},
    { -40, 1056, 112},
    { -32, 1128, 200},
    { -56, 1112, 384},
    { -96, 1016, 472},
    { -120, 936, 568},
    { -120, 912, 584},
    { -120, 872, 664},
    { -104, 832, 584},
    { -40, 928, 544},
    { -8, 832, 288},
    { -80, 880, 528},
    { -128, 840, 464},
    { -120, 888, 536},
    { -144, 808, 544},
    { -104, 976, 424},
    { -80, 944, 440},
    { -88, 936, 392},
    { -120, 888, 432},
    // 63 seconds
    { -128, 880, 448},
    { -136, 880, 472},
    { -120, 912, 464},
    { -112, 944, 456},
    { -112, 904, 440},
    { -152, 1088, 504},
    { -72, 704, 408},
    { -136, 944, 472},
    { -152, 912, 504},
    { -144, 904, 504},
    { -120, 864, 488},
    { -120, 872, 472},
    { -144, 904, 480},
    { -144, 896, 512},
    { -120, 896, 496},
    { -128, 896, 480},
    { -136, 888, 496},
    { -144, 872, 512},
    { -128, 904, 496},
    { -104, 888, 472},
    { -160, 1008, 528},
    { -152, 880, 520},
    { -144, 856, 504},
    { -64, 728, 448},
    { -152, 896, 528},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-09-29 18:03:45 local
AccelRawData *activity_sample_taking_vitamins(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME taking_vitamins
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 100
  //> TEST_WEIGHT 10.0
  static AccelRawData samples[] = {
    // elapsed: 0 minutes
    // 1 seconds
    { 128, -264, -976},
    { 136, -304, -960},
    { 144, -280, -960},
    { 160, -264, -984},
    { 128, -272, -976},
    { 120, -264, -960},
    { 152, -272, -976},
    { 160, -264, -968},
    { 160, -264, -968},
    { 160, -256, -968},
    { 160, -272, -968},
    { 176, -272, -960},
    { 208, -280, -968},
    { 208, -304, -968},
    { 288, -368, -1048},
    { 280, -400, -968},
    { 376, -376, -960},
    { 472, -256, -968},
    { 384, -72, -768},
    { 288, 424, -776},
    { 40, 432, -864},
    { -136, 456, -728},
    { -232, 616, -672},
    { -304, 752, -624},
    { -384, 832, -544},
    // 2 seconds
    { -344, 880, -544},
    { -256, 976, -560},
    { -208, 856, -528},
    { -168, 776, -512},
    { -152, 744, -488},
    { -136, 728, -496},
    { -176, 736, -480},
    { -216, 776, -440},
    { -280, 808, -392},
    { -352, 840, -336},
    { -424, 896, -296},
    { -464, 928, -304},
    { -480, 960, -352},
    { -496, 1032, -400},
    { -544, 1144, -472},
    { -528, 1240, -576},
    { -648, 1200, -544},
    { -744, 1200, -456},
    { -824, 1000, -344},
    { -1016, 904, -272},
    { -944, 768, -272},
    { -856, 496, -408},
    { -760, 328, -376},
    { -552, 168, -408},
    { -312, 64, -480},
    // 3 seconds
    { -88, 128, -560},
    { 136, 248, -608},
    { 136, 320, -736},
    { 32, 328, -744},
    { 32, 328, -736},
    { 32, 464, -760},
    { -64, 656, -704},
    { -40, 616, -720},
    { -152, 792, -536},
    { -88, 640, -560},
    { -248, 672, -456},
    { -152, 680, -672},
    { -200, 784, -496},
    { -56, 744, -736},
    { 64, 744, -712},
    { -208, 944, -744},
    { -208, 864, -536},
    { 8, 736, -440},
    { -56, 536, -344},
    { -24, 424, -288},
    { -264, 320, -360},
    { -128, 176, -208},
    { -368, 120, -280},
    { -424, 136, -240},
    { -568, 80, -264},
    // 4 seconds
    { -864, 320, -456},
    { -1000, 616, -568},
    { -992, 944, -680},
    { -760, 1224, -808},
    { -728, 1040, -664},
    { -488, 1040, -824},
    { -424, 912, -816},
    { -448, 1120, -736},
    { -352, 776, -664},
    { -152, 552, -792},
    { -32, 840, -976},
    { -144, 1368, -1088},
    { -8, 552, -792},
    { -120, 560, -264},
    { -8, 1040, -768},
    { -48, 896, -696},
    { -8, 880, -496},
    { 24, 640, -656},
    { -96, 984, -528},
    { -112, 672, -696},
    { -176, 464, -656},
    { -160, 640, -744},
    { -104, 608, -704},
    { -24, 448, -824},
    { 24, 352, -760},
    // 5 seconds
    { 24, 592, -904},
    { -88, 672, -840},
    { -96, 432, -688},
    { -96, 624, -736},
    { 0, 312, -528},
    { 80, 480, -552},
    { 56, 944, -448},
    { -104, 1032, -440},
    { -152, 792, -352},
    { -160, 808, -400},
    { -112, 880, -408},
    { -88, 872, -480},
    { -80, 864, -496},
    { -80, 792, -544},
    { -88, 808, -600},
    { -112, 872, -480},
    { -120, 832, -528},
    { -120, 800, -512},
    { -104, 792, -520},
    { -48, 744, -592},
    { -32, 800, -600},
    { -24, 800, -544},
    { -56, 632, -592},
    { -72, 680, -576},
    { -112, 768, -616},
    // 6 seconds
    { -80, 776, -616},
    { -48, 616, -632},
    { -88, 784, -592},
    { -104, 696, -640},
    { -80, 688, -680},
    { -72, 712, -624},
    { -72, 632, -640},
    { -88, 752, -648},
    { -64, 592, -672},
    { -56, 632, -696},
    { -56, 752, -648},
    { -72, 768, -688},
    { -136, 752, -528},
    { -88, 664, -680},
    { -56, 608, -624},
    { -32, 640, -800},
    { -32, 664, -752},
    { -80, 688, -688},
    { -80, 648, -736},
    { -96, 664, -664},
    { -64, 616, -728},
    { -48, 616, -760},
    { -56, 576, -760},
    { -40, 544, -832},
    { -48, 536, -840},
    // 7 seconds
    { -56, 560, -848},
    { -40, 448, -824},
    { -32, 432, -880},
    { -40, 448, -848},
    { -72, 488, -816},
    { -64, 392, -896},
    { -64, 336, -904},
    { -64, 344, -920},
    { -56, 392, -944},
    { -72, 392, -920},
    { -88, 376, -888},
    { -88, 320, -840},
    { -72, 368, -848},
    { -56, 392, -872},
    { -64, 400, -888},
    { -88, 480, -872},
    { -96, 544, -824},
    { -96, 560, -808},
    { -104, 576, -768},
    { -88, 624, -784},
    { -88, 608, -760},
    { -88, 592, -736},
    { -72, 608, -712},
    { -72, 624, -744},
    { -80, 632, -720},
    // 8 seconds
    { -80, 648, -688},
    { -80, 680, -664},
    { -72, 672, -664},
    { -48, 688, -624},
    { -40, 712, -600},
    { -24, 752, -608},
    { -32, 824, -664},
    { -16, 816, -632},
    { -48, 1040, -640},
    { 56, 720, -704},
    { 152, 968, -800},
    { -168, 1136, -792},
    { -432, 1008, -416},
    { -536, 784, -112},
    { -512, 696, 176},
    { -368, 584, 320},
    { -296, 464, 408},
    { -208, 488, 600},
    { -168, 448, 704},
    { -176, 376, 808},
    { -216, 328, 800},
    { -256, 256, 896},
    { -304, 248, 880},
    { -328, 192, 896},
    { -328, 176, 960},
    // 9 seconds
    { -312, 224, 976},
    { -288, 208, 960},
    { -256, 208, 960},
    { -256, 232, 960},
    { -240, 224, 960},
    { -248, 136, 976},
    { -272, 136, 992},
    { -304, 120, 1040},
    { -344, 104, 1008},
    { -352, 160, 1024},
    { -360, 200, 1008},
    { -360, 240, 1024},
    { -392, 256, 1008},
    { -400, 264, 1080},
    { -472, 272, 1168},
    { -568, 288, 1376},
    { -696, 248, 1232},
    { -728, 256, 1328},
    { -712, 224, 1192},
    { -472, 248, 656},
    { -368, 192, -32},
    { -272, 88, -408},
    { 144, -16, -968},
    { -648, 448, 120},
    { -904, 440, 88},
    // 10 seconds
    { -896, 416, -72},
    { -672, 400, -344},
    { -344, 408, -272},
    { -272, 392, -64},
    { -304, 416, 112},
    { -304, 408, 272},
    { -352, 576, 336},
    { -472, 864, 624},
    { -488, 744, 472},
    { -528, 1136, 272},
    { -432, 1136, 240},
    { -432, 1232, 96},
    { -360, 1416, 32},
    { -248, 1328, -112},
    { -160, 1288, -208},
    { -104, 1128, -256},
    { -104, 936, -352},
    { -64, 896, -296},
    { -72, 832, -376},
    { -112, 808, -392},
    { -80, 816, -456},
    { -48, 792, -392},
    { 40, 856, -528},
    { 64, 824, -464},
    { 104, 832, -496},
    // 11 seconds
    { 120, 736, -536},
    { 160, 792, -512},
    { 176, 792, -552},
    { 160, 736, -504},
    { 192, 632, -576},
    { 160, 816, -592},
    { 112, 792, -616},
    { 56, 760, -576},
    { 56, 832, -632},
    { 88, 760, -600},
    { 96, 720, -616},
    { 80, 720, -624},
    { 64, 696, -664},
    { 48, 744, -608},
    { 56, 752, -592},
    { 64, 736, -592},
    { 64, 720, -600},
    { 64, 744, -584},
    { 64, 744, -592},
    { 64, 728, -608},
    { 64, 736, -584},
    { 56, 744, -592},
    { 56, 744, -592},
    { 64, 744, -592},
    { 64, 752, -592},
    // 12 seconds
    { 64, 744, -592},
    { 64, 744, -592},
    { 72, 736, -592},
    { 72, 744, -584},
    { 72, 744, -600},
    { 80, 736, -600},
    { 80, 744, -584},
    { 80, 744, -584},
    { 80, 736, -592},
    { 80, 736, -592},
    { 80, 736, -592},
    { 80, 744, -592},
    { 88, 744, -584},
    { 88, 736, -600},
    { 88, 736, -584},
    { 88, 736, -592},
    { 88, 736, -592},
    { 96, 736, -592},
    { 96, 736, -600},
    { 96, 736, -592},
    { 104, 736, -592},
    { 104, 728, -592},
    { 104, 736, -592},
    { 104, 728, -608},
    { 104, 728, -592},
    // 13 seconds
    { 104, 736, -600},
    { 112, 728, -600},
    { 104, 728, -600},
    { 112, 728, -592},
    { 104, 728, -608},
    { 112, 728, -608},
    { 112, 720, -608},
    { 104, 720, -608},
    { 104, 720, -608},
    { 88, 720, -600},
    { 104, 712, -624},
    { 96, 712, -616},
    { 88, 720, -624},
    { 104, 712, -624},
    { 96, 712, -624},
    { 104, 704, -624},
    { 112, 696, -632},
    { 96, 704, -624},
    { 104, 704, -648},
    { 104, 696, -632},
    { 104, 712, -632},
    { 104, 696, -640},
    { 104, 704, -632},
    { 104, 704, -640},
    { 120, 688, -648},
    // 14 seconds
    { 104, 712, -632},
    { 112, 696, -640},
    { 104, 680, -632},
    { 96, 704, -640},
    { 112, 696, -648},
    { 112, 680, -648},
    { 112, 696, -648},
    { 112, 688, -648},
    { 120, 688, -656},
    { 112, 688, -656},
    { 88, 704, -640},
    { 64, 704, -656},
    { 72, 688, -632},
    { 128, 672, -648},
    { 136, 664, -696},
    { 152, 656, -688},
    { 112, 680, -640},
    { 80, 704, -648},
    { 136, 664, -624},
    { 120, 688, -640},
    { 112, 688, -664},
    { 112, 704, -688},
    { 80, 712, -624},
    { 80, 712, -640},
    { 88, 680, -648},
    // 15 seconds
    { 88, 680, -656},
    { 104, 680, -680},
    { 104, 664, -672},
    { 96, 664, -680},
    { 88, 664, -696},
    { 80, 672, -680},
    { 80, 672, -664},
    { 88, 664, -688},
    { 104, 656, -688},
    { 120, 680, -640},
    { 64, 680, -688},
    { 80, 648, -680},
    { 80, 632, -720},
    { 80, 640, -712},
    { 136, 656, -616},
    { 48, 648, -808},
    { 96, 648, -688},
    { 64, 632, -720},
    { 64, 640, -728},
    { 80, 624, -744},
    { 80, 624, -736},
    { 80, 616, -728},
    { 8, 720, -640},
    { -40, 552, -808},
    { 72, 664, -664},
    // 16 seconds
    { 80, 624, -712},
    { 72, 640, -720},
    { 80, 624, -736},
    { 88, 624, -720},
    { 72, 632, -712},
    { 48, 640, -752},
    { 96, 600, -712},
    { 88, 632, -744},
    { 80, 648, -744},
    { 80, 624, -712},
    { 72, 664, -664},
    { 32, 640, -712},
    { 32, 696, -704},
    { 64, 744, -720},
    { 112, 752, -792},
    { 48, 888, -1152},
    { -64, 512, -1184},
    { -144, 968, -1432},
    { -280, 1096, -1288},
    { -320, 976, -920},
    { -368, 976, -704},
    { -408, 864, -704},
    { -504, 616, -600},
    { -504, 424, -552},
    { -440, 304, -584},
    // 17 seconds
    { -360, 208, -536},
    { -272, -32, -544},
    { -144, -144, -624},
    { -104, -192, -648},
    { -112, -296, -472},
    { -160, -216, -488},
    { -128, -448, -720},
    { -72, -272, -888},
    { -168, -296, -1112},
    { -264, -304, -872},
    { 72, -112, -1048},
    { -136, -488, -808},
    { -280, -208, -944},
    { -472, -184, -1024},
    { -552, -392, -800},
    { -696, -432, -624},
    { -856, -80, -768},
    { -1056, 96, -576},
    { -1296, -24, -472},
    { -1016, -48, -256},
    { -1024, 464, 320},
    { -976, 240, 288},
    { -976, 440, 672},
    { -744, 496, 512},
    { -632, 192, 760},
    // 18 seconds
    { -456, -48, 952},
    { -568, -336, 1072},
    { -840, 264, 1048},
    { -1408, 792, 600},
    { -1408, 2072, -464},
    { -1480, 2232, -912},
    { -848, 520, -552},
    { -520, -1480, -440},
    { -128, -776, -360},
    { -16, -440, -488},
    { 48, -80, -552},
    { 96, -208, -608},
    { -120, 88, -1016},
    { -112, 240, -1296},
    { -448, -160, -600},
    { -288, -104, -1112},
    { -416, 112, -1152},
    { -352, -96, -776},
    { -296, -144, -864},
    { -280, -224, -832},
    { -152, -48, -952},
    { -184, 256, -936},
    { -288, -152, -1072},
    { -280, -136, -1152},
    { -328, -80, -1024},
    // 19 seconds
    { -368, -296, -952},
    { -424, -368, -912},
    { -528, -616, -744},
    { -576, -432, -840},
    { -576, -288, -752},
    { -656, -424, -680},
    { -640, -656, -952},
    { -640, -560, -464},
    { -584, -480, -352},
    { -680, -408, -200},
    { -592, -160, -584},
    { -648, -192, -832},
    { -744, 24, -672},
    { -480, -8, -680},
    { -456, 200, -944},
    { -248, 328, -1120},
    { -160, 264, -1112},
    { -216, 280, -1056},
    { -248, 40, -960},
    { -312, -64, -880},
    { -280, 24, -800},
    { -272, 40, -816},
    { -264, -64, -752},
    { -200, -200, -856},
    { -152, -312, -1120},
    // 20 seconds
    { -120, 336, -1632},
    { -360, -80, -640},
    { -344, 0, -912},
    { -344, -56, -1088},
    { -304, -112, -1176},
    { -312, 0, -1240},
    { -272, 88, -1240},
    { -208, 48, -1168},
    { -120, 88, -1144},
    { -88, 48, -1224},
    { -136, 128, -1256},
    { -8, 88, -1208},
    { 136, 168, -1256},
    { -32, 472, -1328},
    { -264, 288, -1264},
    { -192, -16, -1000},
    { -136, -208, -920},
    { -104, -336, -784},
    { -104, -448, -744},
    { -104, -464, -720},
    { -72, -536, -632},
    { -40, -496, -720},
    { 0, -560, -776},
    { 40, -624, -784},
    { 104, -664, -792},
    // 21 seconds
    { 136, -688, -736},
    { 168, -704, -712},
    { 152, -712, -696},
    { 136, -728, -688},
    { 128, -744, -696},
    { 136, -736, -744},
    { 128, -728, -752},
    { 96, -704, -752},
    { 80, -640, -792},
    { 56, -632, -800},
    { 64, -632, -816},
    { 72, -648, -848},
    { 64, -656, -840},
    { 72, -664, -848},
    { 80, -640, -840},
    { 88, -648, -832},
    { 88, -640, -832},
    { 80, -640, -824},
    { 88, -640, -816},
    { 104, -640, -824},
    { 112, -648, -816},
    { 112, -640, -816},
    { 112, -632, -808},
    { 120, -632, -808},
    { 136, -624, -824},
    // 22 seconds
    { 152, -600, -848},
    { 144, -584, -800},
    { 80, -1024, -904},
    { 24, -1256, -784},
    { -88, -664, -864},
    { -128, -232, -968},
    { 160, 656, -1000},
    { 120, 120, -1032},
    { -72, -600, -1024},
    { -40, 336, -992},
    { -40, -736, -856},
    { -40, -320, -872},
    { -136, -392, -904},
    { -112, -416, -872},
    { -136, -504, -984},
    { -136, -488, -968},
    { -96, -448, -968},
    { -96, -432, -944},
    { -88, -400, -912},
    { -64, -424, -920},
    { -48, -376, -880},
    { -56, -296, -888},
    { -64, -432, -824},
    { -24, -448, -808},
    { 24, -424, -936},
    // 23 seconds
    { -8, -480, -984},
    { -40, -440, -1000},
    { -16, -384, -944},
    { -8, -376, -920},
    { -8, -400, -1024},
    { -32, -216, -1072},
    { -32, -296, -960},
    { 16, -320, -968},
    { 40, -312, -1064},
    { 40, -368, -1024},
    { 64, -320, -960},
    { 88, -448, -1024},
    { 64, -296, -944},
    { 96, -408, -976},
    { 56, -376, -960},
    { 16, -376, -944},
    { 24, -336, -936},
    { 16, -336, -976},
    { 24, -344, -960},
    { 32, -344, -968},
    { 48, -344, -992},
    { 48, -352, -984},
    { 48, -360, -992},
    { 48, -360, -968},
    { 48, -352, -976},
    // 24 seconds
    { 40, -336, -968},
    { 48, -328, -952},
    { 40, -344, -968},
    { 40, -336, -968},
    { 40, -344, -968},
    { 40, -328, -976},
    { 32, -328, -992},
    { 32, -336, -992},
    { 32, -328, -976},
    { 32, -320, -976},
    { 40, -336, -976},
    { 40, -336, -976},
    { 32, -328, -968},
    { 24, -328, -968},
    { 32, -328, -976},
    { 40, -320, -984},
    { 32, -336, -976},
    { 32, -336, -976},
    { 32, -320, -976},
    { 32, -328, -968},
    { 32, -328, -968},
    { 32, -320, -968},
    { 32, -320, -976},
    { 32, -320, -984},
    { 32, -328, -976},
    // 25 seconds
    { 24, -328, -976},
    { 32, -320, -976},
    { 32, -320, -984},
    { 24, -320, -984},
    { 24, -320, -976},
    { 32, -320, -976},
    { 32, -320, -976},
    { 40, -312, -984},
    { 40, -320, -976},
    { 40, -328, -968},
    { 48, -328, -968},
    { 32, -328, -968},
    { 40, -320, -976},
    { 40, -320, -976},
    { 24, -328, -976},
    { 32, -320, -976},
    { 32, -328, -976},
    { 32, -320, -976},
    { 40, -320, -976},
    { 40, -320, -976},
    { 32, -312, -976},
    { 40, -320, -984},
    { 32, -328, -976},
    { 48, -328, -968},
    { 48, -336, -968},
    { 48, -336, -968},
    { 32, -344, -976},
    { 16, -320, -984},
    { 32, -336, -984},
    { 40, -312, -992},
    { 48, -344, -984},
    { 40, -344, -952},
    { 24, -304, -952},
    { 40, -328, -984},
    { 88, -328, -1000},
    { 96, -352, -936},
    { 120, -368, -984},
    { 64, -344, -992},
    { 96, -312, -984},
    { 120, -296, -992},
    { 184, -328, -1000},
    { 104, -280, -992},
    { 80, -280, -984},
    { 40, -280, -968},
    { 88, -272, -936},
    { 160, -280, -936},
    { 160, -320, -952},
    { 176, -328, -1000},
    { 184, -360, -1056},
    { 240, -240, -1048},
    // 27 seconds
    { -280, -160, -936},
    { 16, -264, -896},
    { 48, -248, -936},
    { 16, -256, -984},
    { -8, -248, -984},
    { -40, -248, -1032},
    { -56, -256, -1032},
    { -32, -296, -1000},
    { -24, -256, -984},
    { -8, -248, -1008},
    { 8, -312, -1032},
    { 24, -320, -976},
    { 40, -312, -976},
    { 48, -280, -992},
    { 32, -256, -976},
    { 32, -288, -960},
    { 32, -312, -976},
    { 40, -272, -1008},
    { 32, -256, -992},
    { 32, -312, -1000},
    { 48, -296, -984},
    { 56, -312, -984},
    { 56, -320, -984},
    { 32, -216, -1008},
    { -24, 64, -1032},
    // 28 seconds
    { -48, 360, -920},
    { -72, 480, -800},
    { -56, 632, -832},
    { -80, 752, -744},
    { -40, 776, -568},
    { -64, 1032, -336},
    { -136, 952, -264},
    { -192, 856, 0},
    { -232, 808, 256},
    { -256, 704, 376},
    { -304, 640, 464},
    { -312, 632, 496},
    { -456, 472, 632},
    { -368, 688, 560},
    { -376, 656, 808},
    { -392, 656, 896},
    { -408, 976, 920},
    { -512, 976, 936},
    { -536, 632, 760},
    { -392, 352, 208},
    { -224, 512, -368},
    { -288, 272, -544},
    { -296, 24, -904},
    { -312, 144, -1072},
    { -208, 104, -1168},
    // 29 seconds
    { -232, 144, -1224},
    { -176, -368, -1376},
    { -168, 8, -1536},
    { -144, 560, -1184},
    { -592, 760, -480},
    { -392, 1240, -48},
    { -472, 512, -80},
    { -88, 448, -560},
    { 32, 488, -1016},
    { 104, 48, -1064},
    { 112, -184, -888},
    { 208, -48, -1112},
    { 248, -192, -1080},
    { 312, -328, -984},
    { 288, -560, -856},
    { 592, -584, -1080},
    { 864, -264, -1504},
    { 368, 80, -1104},
    { -160, 216, -832},
    { -240, 456, -888},
    { -240, 424, -856},
    { -128, 184, -880},
    { -184, 408, -864},
    { -344, 592, -792},
    { -448, 528, -584},
    // 30 seconds
    { -488, 464, -568},
    { -400, 344, -592},
    { -344, 272, -664},
    { -304, 256, -728},
    { -112, 120, -960},
    { -272, 320, -768},
    { -360, 176, -464},
    { -304, 624, -752},
    { -400, 600, -752},
    { -448, 816, -640},
    { -384, 904, -736},
    { -344, 728, -616},
    { -352, 688, -352},
    { -288, 704, -616},
    { -224, 552, -504},
    { -184, 392, -624},
    { -168, 600, -704},
    { -144, 680, -728},
    { -80, 488, -976},
    { -120, 856, -872},
    { -168, 800, -664},
    { -216, 432, -632},
    { -56, 528, -592},
    { 160, 504, -808},
    { 296, 760, -1144},
    // 31 seconds
    { 392, 624, -1088},
    { 400, 680, -1232},
    { 144, 872, -960},
    { -128, 680, -584},
    { -104, 544, -400},
    { -64, 576, -576},
    { 192, 824, -640},
    { 152, 768, -384},
    { 128, 1056, 8},
    { 80, 1048, 112},
    { 40, 984, -80},
    { 0, 952, -64},
    { 8, 944, -96},
    { 16, 920, -144},
    { 72, 960, -104},
    { 64, 1008, -64},
    { 40, 976, -16},
    { 80, 1016, 72},
    { 120, 912, 72},
    { 112, 936, -16},
    { 144, 904, 0},
    { 136, 960, -112},
    { 96, 928, -144},
    { 56, 864, -168},
    { 104, 800, -216},
    // 32 seconds
    { 80, 864, -296},
    { 48, 912, -312},
    { 40, 832, -312},
    { 56, 784, -360},
    { 48, 880, -384},
    { 40, 896, -336},
    { 0, 840, -352},
    { 8, 832, -384},
    { -8, 856, -344},
    { 0, 960, -320},
    { 8, 984, -296},
    { 16, 936, -368},
    { 0, 944, -392},
    { -16, 968, -424},
    { -48, 840, -448},
    { -40, 808, -520},
    { -32, 744, -568},
    { -40, 680, -624},
    { -56, 600, -640},
    { -96, 536, -664},
    { -104, 584, -688},
    { -128, 560, -656},
    { -120, 568, -680},
    { -104, 560, -648},
    { -136, 488, -616},
    // 33 seconds
    { -144, 616, -592},
    { -104, 760, -624},
    { -128, 320, -544},
    { 72, 800, -872},
    { 88, 296, -920},
    { 176, 432, -1112},
    { 200, 304, -1088},
    { 224, 280, -1080},
    { 200, 144, -1008},
    { 224, 136, -984},
    { 240, 136, -976},
    { 280, 208, -1040},
    { 208, 184, -1000},
    { 200, 184, -944},
    { 184, 224, -960},
    { 192, 240, -984},
    { 200, 216, -944},
    { 216, 280, -928},
    { 232, 272, -896},
    { 216, 272, -888},
    { 224, 344, -896},
    { 248, 368, -896},
    { 384, 344, -976},
    { 480, 400, -1040},
    { 528, 528, -1016},
    // 34 seconds
    { 360, 312, -896},
    { 0, 104, -664},
    { -104, 88, -736},
    { -120, 40, -784},
    { -48, -16, -856},
    { 296, 680, -1192},
    { 192, 336, -1024},
    { 368, 144, -960},
    { 448, 624, -872},
    { 32, 1088, -456},
    { -240, 1256, -216},
    { -160, 968, -472},
    { -136, 512, -488},
    { -64, 560, -584},
    { 24, 496, -840},
    { -88, 312, -1064},
    { -120, 552, -1104},
    { -96, 536, -872},
    { -88, 368, -1072},
    { -152, 208, -864},
    { -200, 200, -832},
    { -136, 512, -800},
    { -144, 560, -672},
    { -144, 616, -536},
    { -112, 760, -560},
    // 35 seconds
    { -136, 832, -520},
    { -160, 848, -424},
    { -304, 1056, -400},
    { -296, 392, -1040},
    { -216, 240, -840},
    { -184, 112, -936},
    { -240, 456, -824},
    { -168, 520, -976},
    { -232, 816, -1000},
    { -248, 488, -712},
    { -312, 416, -824},
    { -392, -64, -816},
    { -248, -344, -1128},
    { -224, -200, -776},
    { -32, 120, -992},
    { -160, 472, -752},
    { -280, 512, -728},
    { -368, 392, -680},
    { -448, 352, -1048},
    { -416, -176, -1128},
    { -200, -560, -1096},
    { -376, 440, -792},
    { -128, 408, -888},
    { -88, 608, -976},
    { -312, 648, -760},
    // 36 seconds
    { -432, 552, -608},
    { -392, 192, -584},
    { -272, -40, -736},
    { 80, -144, -1040},
    { 256, 64, -1216},
    { 264, 32, -1272},
    { 184, -24, -1240},
    { 104, 8, -1048},
    { 16, 192, -1152},
    { 72, 264, -1056},
    { 216, 240, -1000},
    { 24, 568, -872},
    { -280, 664, -728},
    { -432, 648, -512},
    { -520, 824, -528},
    { -336, 432, -928},
    { -296, -120, -960},
    { -200, -120, -1096},
    { -136, -480, -816},
    { -176, -8, -936},
    { -208, -224, -992},
    { -264, -368, -704},
    { -288, -192, -728},
    { -200, -456, -944},
    { -136, -312, -952},
    // 37 seconds
    { -152, -168, -984},
    { -56, -368, -960},
    { 0, -376, -1208},
    { -64, -104, -856},
    { 112, -16, -936},
    { 24, -256, -1144},
    { 8, -224, -1016},
    { 8, 96, -920},
    { -152, 768, -752},
    { -336, 1008, -504},
    { -184, 680, -408},
    { -192, 896, -136},
    { -112, 904, -184},
    { -88, 944, -384},
    { -136, 832, -328},
    { -152, 888, -256},
    { -128, 1136, -248},
    { -64, 944, -416},
    { -64, 480, -320},
    { -64, 848, -216},
    { -120, 768, -80},
    { -32, 976, -320},
    { -8, 1232, -224},
    { 56, 1128, -104},
    { 80, 1032, -104},
    // 38 seconds
    { 80, 944, -128},
    { 112, 792, -32},
    { 128, 920, 8},
    { 80, 936, 56},
    { 64, 1040, 144},
    { 104, 1024, 192},
    { 88, 1040, 96},
    { 96, 1008, 16},
    { 72, 1000, -40},
    { 56, 936, -160},
    { 40, 936, -248},
    { 0, 912, -328},
    { -8, 896, -416},
    { -48, 600, -480},
    { -64, 536, -704},
    { -56, 464, -744},
    { -104, 464, -664},
    { -112, 616, -704},
    { -176, 552, -688},
    { -160, 488, -704},
    { -232, 528, -744},
    { -200, 536, -736},
    { -224, 608, -728},
    { -216, 592, -696},
    { -240, 464, -632},
    // 39 seconds
    { -240, 416, -616},
    { -184, 904, -624},
    { -248, 520, -552},
    { -24, 720, -752},
    { 64, 328, -792},
    { 256, 400, -1008},
    { 296, 408, -1080},
    { 352, 376, -1088},
    { 400, 432, -1008},
    { 432, 320, -1016},
    { 440, 312, -992},
    { 424, 352, -944},
    { 336, 384, -888},
    { 120, 392, -664},
    { -48, 768, -376},
    { -192, 744, -232},
    { -464, 1144, -184},
    { -440, 1032, -96},
    { -280, 872, -192},
    { 112, 1392, -592},
    { 112, 1096, -48},
    { 208, 1048, -32},
    { -144, 1048, -40},
    { -232, 824, -144},
    { -272, 464, 16},
    // 40 seconds
    { -352, 864, -128},
    { -360, 896, 104},
    { -456, 896, 160},
    { -464, 952, 0},
    { -472, 752, 224},
    { -376, 856, 64},
    { -344, 752, 136},
    { -280, 736, 136},
    { -288, 728, 160},
    { -320, 640, 144},
    { -256, 616, 480},
    { -296, 984, 712},
    { -224, 1352, 640},
    { -128, 1400, 616},
    { -224, 1656, 552},
    { -408, 1104, 696},
    { -512, 656, 416},
    { -456, 464, 56},
    { -288, -40, 16},
    { -88, -544, -504},
    { -120, -88, -1048},
    { -200, 0, -816},
    { -240, 152, -1056},
    { -248, -136, -1128},
    { -288, -40, -976},
    // 41 seconds
    { -328, 288, -1016},
    { -328, 264, -1120},
    { -376, 232, -1056},
    { -368, 128, -1016},
    { -376, 192, -904},
    { -296, 224, -888},
    { -360, 312, -904},
    { -448, 336, -744},
    { -328, 264, -704},
    { -184, -208, -872},
    { -280, 168, -968},
    { -312, 280, -880},
    { -336, 256, -992},
    { -360, 264, -1040},
    { -304, 136, -968},
    { -288, 192, -920},
    { -280, 272, -968},
    { -264, 200, -968},
    { -272, 216, -952},
    { -336, 240, -864},
    { -344, 272, -864},
    { -328, 296, -896},
    { -280, 336, -992},
    { -200, 304, -792},
    { -328, 400, -912},
    // 42 seconds
    { -384, 328, -824},
    { -448, 288, -704},
    { -400, 600, -696},
    { -328, 752, -616},
    { -248, 672, -736},
    { -248, 536, -640},
    { -208, 392, -584},
    { -416, 720, -672},
    { -360, 688, -632},
    { -328, 720, -672},
    { -328, 784, -720},
    { -272, 584, -560},
    { -128, 712, -688},
    { -120, 656, -856},
    { -264, 456, -744},
    { -264, 680, -840},
    { -256, 608, -424},
    { -184, 1000, -856},
    { -112, 840, -600},
    { 96, 448, -1048},
    { 56, 160, -976},
    { -56, 296, -608},
    { -320, 600, -352},
    { -440, 728, -176},
    { -480, 656, -136},
    // 43 seconds
    { -496, 640, -176},
    { -624, 704, -272},
    { -656, 744, -400},
    { -656, 752, -496},
    { -592, 744, -560},
    { -512, 760, -576},
    { -472, 752, -568},
    { -464, 704, -544},
    { -528, 696, -472},
    { -544, 752, -416},
    { -512, 800, -416},
    { -488, 816, -408},
    { -464, 744, -464},
    { -512, 728, -480},
    { -584, 768, -384},
    { -688, 800, -432},
    { -776, 960, -488},
    { -800, 928, -488},
    { -624, 744, -616},
    { -432, 472, -512},
    { -216, -176, -536},
    { 16, -696, -648},
    { -40, 192, -688},
    { -280, -160, -952},
    { -512, 272, -848},
    // 44 seconds
    { -616, 712, -808},
    { -584, 632, -896},
    { -496, 464, -744},
    { -384, 704, -664},
    { -376, 424, -744},
    { -552, 856, -632},
    { -464, 768, -384},
    { -336, 624, -192},
    { -264, 536, -464},
    { -328, 880, -928},
    { -232, 728, -584},
    { -96, 840, -480},
    { -264, 888, -392},
    { -352, 712, -416},
    { -328, 568, -512},
    { -344, 544, -272},
    { -192, 1032, -208},
    { -88, 1040, -264},
    { -8, 960, -160},
    { -16, 1152, 96},
    { -16, 992, 208},
    { -64, 904, 80},
    { -48, 880, 80},
    { -40, 928, 40},
    { -56, 952, 56},
    // 45 seconds
    { -24, 928, 136},
    { 8, 992, 200},
    { 16, 1048, 208},
    { 48, 1008, 224},
    { 64, 1032, 104},
    { 64, 976, -72},
    { 80, 920, -144},
    { 128, 896, -248},
    { 128, 760, -336},
    { 80, 872, -352},
    { 16, 704, -456},
    { 48, 648, -576},
    { 24, 648, -432},
    { 40, 672, -384},
    { 64, 680, -384},
    { 120, 840, -200},
    { 232, 1072, -168},
    { 216, 1096, -184},
    { 144, 1008, -208},
    { 112, 920, -112},
    { 104, 1000, -40},
    { 192, 960, 40},
    { 24, 992, -96},
    { 24, 880, -176},
    { 72, 856, -264},
    // 46 seconds
    { 48, 912, -248},
    { -8, 864, -328},
    { -32, 744, -392},
    { -32, 608, -528},
    { -80, 584, -536},
    { -40, 752, -552},
    { -96, 640, -520},
    { 40, 704, -656},
    { 120, 632, -720},
    { 200, 640, -800},
    { 384, 664, -936},
    { 392, 656, -936},
    { 408, 656, -816},
    { 368, 592, -832},
    { 296, 600, -752},
    { 176, 720, -608},
    { 80, 760, -608},
    { -32, 728, -648},
    { -144, 632, -736},
    { -160, 656, -752},
    { -192, 704, -752},
    { -224, 576, -680},
    { -224, 544, -704},
    { -248, 488, -632},
    { -232, 408, -608},
    // 47 seconds
    { -272, 208, -616},
    { -296, 264, -648},
    { -296, 448, -768},
    { -392, 280, -776},
    { -384, 240, -968},
    { -344, 176, -984},
    { -248, 320, -1200},
    { -152, 152, -1312},
    { -160, -80, -1208},
    { -176, -128, -840},
    { -56, -24, -696},
    { 240, -8, -1216},
    { 160, -216, -1104},
    { 32, -200, -1080},
    { -48, -144, -920},
    { 88, 88, -1496},
    { 136, 112, -1384},
    { -48, 40, -1304},
    { 96, -264, -824},
    { -152, -120, -1136},
    { -240, -336, -1312},
    { -344, -184, -1192},
    { -440, -208, -1120},
    { -456, -216, -960},
    { -480, -336, -1064},
    // 48 seconds
    { -488, -264, -984},
    { -576, -280, -800},
    { -560, -104, -800},
    { -528, -112, -704},
    { -568, -264, -776},
    { -440, -160, -608},
    { -488, -176, -648},
    { -496, -472, -768},
    { -424, -456, -760},
    { -560, -416, -880},
    { -736, -664, -448},
    { -680, -328, -640},
    { -656, -152, -664},
    { -552, -320, -616},
    { -456, -288, -816},
    { -352, -312, -392},
    { -336, -200, -800},
    { 152, -312, -1920},
    { -240, -32, -904},
    { -248, -392, -712},
    { -176, -368, -712},
    { -80, 272, -888},
    { -712, -136, -552},
    { 136, -528, -928},
    { 192, -240, -824},
    // 49 seconds
    { 528, -232, -856},
    { 448, -256, -768},
    { 128, -296, -664},
    { -232, -552, -832},
    { -448, -632, -880},
    { -800, -312, -720},
    { -504, 352, -1040},
    { -544, 704, -1536},
    { -536, 560, -1296},
    { -376, 632, -1464},
    { -208, 24, -1312},
    { -24, -56, -1152},
    { 80, 56, -1008},
    { 104, 40, -1088},
    { 248, 8, -1328},
    { 424, 328, -1352},
    { 640, 568, -1624},
    { 312, 472, -1336},
    { -16, 552, -840},
    { -360, 600, -352},
    { -648, 528, -48},
    { -720, 416, 80},
    { -544, 320, 112},
    { -472, 456, -112},
    { -376, 448, -312},
    // 50 seconds
    { -352, 576, -424},
    { -248, 832, -680},
    { -200, 1032, -680},
    { -120, 960, -600},
    { -80, 936, -840},
    { -128, 752, -672},
    { -336, 768, -104},
    { -392, 672, 360},
    { -232, 888, 168},
    { -8, 1144, 96},
    { -48, 1232, 216},
    { -104, 1152, 344},
    { -184, 872, 376},
    { -208, 712, 424},
    { -264, 880, 88},
    { -192, 736, -8},
    { -56, 864, -96},
    { 16, 1168, 80},
    { 40, 1088, 176},
    { 32, 976, 72},
    { 8, 1008, 56},
    { 0, 976, 64},
    { 0, 928, 40},
    { 0, 920, 88},
    { -8, 984, 240},
    // 51 seconds
    { 136, 880, 368},
    { 16, 944, 240},
    { 96, 728, 160},
    { 80, 1016, 104},
    { 96, 1040, 136},
    { 48, 992, 136},
    { 64, 968, 72},
    { 80, 1000, -72},
    { 96, 1008, -192},
    { 80, 880, -280},
    { 56, 776, -400},
    { 24, 872, -448},
    { -16, 864, -464},
    { -64, 664, -528},
    { -80, 512, -672},
    { -104, 416, -680},
    { -120, 384, -616},
    { -208, 208, -544},
    { -168, 480, -560},
    { -192, 488, -400},
    { -16, 696, -552},
    { 48, 808, -696},
    { 136, 792, -808},
    { 232, 824, -976},
    { 384, 752, -1048},
    // 52 seconds
    { 408, 776, -1104},
    { 304, 592, -952},
    { 128, 664, -648},
    { -120, 784, -368},
    { -112, 824, 40},
    { -368, 1200, 184},
    { -280, 928, -8},
    { -280, 912, -64},
    { -128, 992, -96},
    { -136, 1072, -72},
    { -56, 1208, -360},
    { -184, 776, -280},
    { -288, 824, -464},
    { -312, 888, -912},
    { -360, 752, -1248},
    { -328, 384, -736},
    { -408, 440, -488},
    { -656, 200, 128},
    { -688, 352, 152},
    { -616, 536, -56},
    { -400, 624, -224},
    { -272, 792, -552},
    { -144, 712, -656},
    { -40, 792, -872},
    { -48, 952, -1344},
    // 53 seconds
    { -40, 592, -1064},
    { -176, 536, -904},
    { -112, 576, -864},
    { -80, 488, -944},
    { -160, 448, -856},
    { -280, 616, -968},
    { -376, 648, -872},
    { -352, 584, -656},
    { -344, 216, -552},
    { -48, 664, -792},
    { -16, 472, -752},
    { 288, 224, -1040},
    { 176, 24, -1080},
    { 128, -64, -936},
    { 144, -176, -816},
    { 192, -40, -904},
    { 264, -200, -1024},
    { 392, -552, -1088},
    { 400, -240, -1080},
    { 280, -272, -824},
    { 184, -200, -752},
    { 368, -240, -1128},
    { 312, -304, -880},
    { 680, -296, -1128},
    { 1056, -448, -1600},
    // 54 seconds
    { 672, -56, -1208},
    { 208, 280, -888},
    { -384, 640, -488},
    { -1248, 608, 32},
    { -728, 296, -72},
    { -528, 184, -224},
    { -320, 200, -528},
    { -216, 288, -768},
    { -56, 296, -952},
    { 96, 280, -1024},
    { 240, 288, -1560},
    { -72, 392, -640},
    { -152, 552, -360},
    { -136, 712, -704},
    { -120, 640, -640},
    { -112, 816, -448},
    { -72, 888, -448},
    { -40, 920, -424},
    { -120, 904, -360},
    { -64, 1000, -344},
    { -32, 992, -440},
    { 48, 1064, -448},
    { 32, 1112, -512},
    { 8, 1024, -648},
    { 64, 904, -792},
    // 55 seconds
    { 96, 992, -440},
    { 64, 1024, -264},
    { -16, 448, -320},
    { -104, 592, -560},
    { 16, 384, -720},
    { 144, 400, -792},
    { 296, 816, -1008},
    { 344, 648, -1208},
    { 72, 816, -880},
    { -104, 552, -496},
    { -88, 464, -608},
    { -80, 440, -520},
    { -88, 304, -648},
    { 120, 968, -168},
    { 64, 1128, 40},
    { 40, 992, 48},
    { 16, 1016, 128},
    { -8, 984, 136},
    { -8, 1000, 88},
    { 16, 968, 112},
    { 40, 888, 136},
    { 48, 968, 160},
    { 64, 888, 248},
    { 40, 920, 248},
    { 40, 928, 280},
    // 56 seconds
    { 16, 880, 296},
    { 8, 888, 328},
    { 8, 864, 320},
    { 64, 872, 304},
    { 56, 888, 304},
    { 56, 896, 296},
    { 80, 896, 248},
    { 104, 920, 248},
    { 64, 944, 272},
    { 80, 960, 288},
    { 64, 944, 152},
    { 72, 848, 32},
    { 80, 832, 32},
    { 88, 936, 16},
    { 64, 976, 48},
    { 40, 960, 32},
    { 32, 928, -64},
    { -40, 864, -112},
    { -16, 832, -200},
    { -80, 776, -192},
    { -120, 808, -272},
    { -152, 592, -224},
    { 64, 568, -552},
    { 256, 544, -640},
    { 344, 360, -904},
    // 57 seconds
    { 408, 384, -1048},
    { 616, 440, -1336},
    { 376, 208, -1032},
    { 360, 256, -1056},
    { 296, 128, -848},
    { 312, 96, -864},
    { 432, 264, -1024},
    { 472, 336, -872},
    { 408, 336, -944},
    { 88, -56, -760},
    { 8, 256, -832},
    { -72, 400, -784},
    { 48, 328, -832},
    { 136, 296, -792},
    { 152, 520, -1248},
    { 248, 296, -872},
    { 560, 376, -864},
    { 544, 904, -744},
    { -24, 1400, -96},
    { -248, 1184, -424},
    { -176, 664, -712},
    { -112, 328, -784},
    { -24, 344, -816},
    { -56, 672, -1024},
    { -136, 440, -840},
    // 58 seconds
    { -168, 424, -944},
    { -288, 248, -832},
    { -224, 512, -824},
    { 8, 520, -880},
    { -200, 888, -400},
    { -16, 1200, -784},
    { -240, 984, -344},
    { -296, 464, -912},
    { -392, 64, -696},
    { -192, -16, -1112},
    { -160, -144, -976},
    { -160, -160, -616},
    { -216, 544, -896},
    { -440, 808, -840},
    { -560, 496, -888},
    { -304, -240, -1136},
    { -304, -104, -1136},
    { -272, -568, -1120},
    { -208, -360, -808},
    { -200, 64, -936},
    { -312, 368, -848},
    { -664, 336, -544},
    { -296, 232, -592},
    { -112, 120, -736},
    { 8, -104, -1248},
    // 59 seconds
    { 96, 208, -1184},
    { 56, -96, -1040},
    { -40, -96, -1120},
    { -48, 40, -920},
    { 120, 208, -1280},
    { 112, 112, -1112},
    { 192, -16, -960},
    { -152, 416, -888},
    { -424, 664, -696},
    { -496, 856, -744},
    { -416, 888, -896},
    { -208, 312, -1184},
    { -8, 32, -1328},
    { -128, -48, -976},
    { -328, 168, -856},
    { -256, -208, -664},
    { -424, 352, -192},
    { -440, 624, -200},
    { -496, 720, 304},
    { -280, 816, 320},
    { -352, 920, 384},
    { -264, 1176, 472},
    { -328, 872, 408},
    { -480, 656, 488},
    { -496, 992, 184},
    // 60 seconds
    // elapsed: 1 minutes
    { -528, 704, 232},
    { -392, 680, 176},
    { -400, 848, 264},
    { -376, 784, 272},
    { -288, 920, 0},
    { -152, 1008, -72},
    { -184, 1272, -360},
    { -184, 808, -472},
    { -64, 680, -368},
    { -104, 784, -112},
    { -200, 704, -32},
    { -192, 952, -120},
    { -136, 1008, 16},
    { -32, 1096, 32},
    { 16, 1200, 208},
    { 40, 1072, 112},
    { 24, 976, 120},
    { 16, 952, 88},
    { 0, 984, 64},
    { 0, 968, 72},
    { 48, 912, 208},
    { -32, 928, 400},
    { 0, 896, 392},
    { -24, 848, 352},
    { 0, 808, 336},
    // 61 seconds
    { 0, 856, 320},
    { 0, 888, 304},
    { 40, 880, 288},
    { 16, 872, 304},
    { 40, 928, 232},
    { 40, 952, 184},
    { 40, 944, 200},
    { 40, 864, 120},
    { 24, 856, 56},
    { 8, 816, 72},
    { 24, 832, 56},
    { 0, 904, 64},
    { -24, 936, 128},
    { -32, 944, 152},
    { -32, 1024, 88},
    { -24, 1016, -40},
    { -72, 808, -144},
    { -88, 688, -192},
    { -168, 680, -160},
    { -120, 640, -128},
    { 24, 680, -368},
    { 248, 808, -632},
    { 328, 552, -880},
    { 416, 600, -1016},
    { 528, 592, -1072},
    // 62 seconds
    { 344, 312, -992},
    { 320, 344, -920},
    { 304, 288, -880},
    { 328, 368, -800},
    { 352, 520, -816},
    { 424, 640, -768},
    { 336, 624, -760},
    { 48, 848, -304},
    { -96, 784, -32},
    { -272, 976, -176},
    { -272, 1000, -240},
    { -216, 808, -232},
    { -48, 1040, -592},
    { 48, 1368, -216},
    { 16, 992, 160},
    { -24, 1096, -8},
    { -80, 992, 80},
    { -184, 696, 184},
    { -216, 736, 144},
    { -376, 856, 304},
    { -400, 888, 240},
    { -376, 800, 344},
    { -424, 872, 216},
    { -344, 848, 136},
    { -288, 872, -40},
    // 63 seconds
    { -232, 744, -24},
    { -208, 856, 280},
    { -232, 848, 208},
    { -200, 736, 328},
    { -200, 888, 472},
    { -64, 1136, 272},
    { -104, 1000, 488},
    { -80, 1016, 472},
    { -120, 1408, 624},
    { -344, 1280, 680},
    { -360, 1224, 240},
    { -408, 1080, 264},
    { -304, 192, -152},
    { -224, -688, -680},
    { -352, -424, -888},
    { -144, -240, -776},
    { -160, -128, -1120},
    { -184, -304, -880},
    { -152, 104, -824},
    { -176, 456, -680},
    { -200, 752, -552},
    { -256, 664, -416},
    { -136, 720, -592},
    { -192, 696, -616},
    { -32, 872, -800},
    // 64 seconds
    { -32, 848, -1040},
    { -96, 744, -840},
    { -32, 752, -960},
    { -160, 488, -840},
    { 256, 536, -960},
    { -56, 624, -920},
    { 120, 656, -488},
    { -80, 760, -352},
    { -352, 1200, -368},
    { -512, 856, -296},
    { -368, 648, -664},
    { -400, 336, -816},
    { -288, 48, -1024},
    { -120, -624, -1200},
    { -200, -328, -592},
    { -184, 216, -856},
    { -328, -368, -656},
    { -496, 488, -104},
    { -432, 984, -144},
    { -512, 784, 280},
    { -256, 840, 80},
    { -368, 960, 48},
    { -296, 1184, 320},
    { -512, 1080, 272},
    { -624, 872, 296},
    // 65 seconds
    { -496, 840, 352},
    { -440, 840, 272},
    { -336, 888, 400},
    { -280, 752, 248},
    { -208, 848, 168},
    { -136, 936, 152},
    { -80, 1704, -504},
    { -64, 1128, -312},
    { -24, 680, -168},
    { 16, 1016, -160},
    { -176, 696, 40},
    { -120, 552, -88},
    { -64, 1024, -152},
    { -64, 1104, -88},
    { 40, 968, -8},
    { 72, 1064, -16},
    { 56, 984, -88},
    { 40, 952, -24},
    { 64, 912, -16},
    { 8, 968, 128},
    { 48, 968, 224},
    { 80, 952, 256},
    { 64, 944, 232},
    { 56, 888, 216},
    { 72, 896, 192},
    // 66 seconds
    { 80, 960, 128},
    { 80, 896, 80},
    { 80, 920, -32},
    { 64, 928, -112},
    { 56, 808, -200},
    { 64, 800, -232},
    { 48, 800, -248},
    { -8, 808, -168},
    { -8, 816, -88},
    { 16, 848, -144},
    { 24, 848, -104},
    { 8, 808, -88},
    { 40, 824, -120},
    { 8, 904, 80},
    { 8, 1000, 184},
    { -24, 968, 232},
    { -112, 1072, 256},
    { -128, 1112, 232},
    { -152, 880, 120},
    { -48, 888, -192},
    { 8, 832, -400},
    { 120, 672, -640},
    { 232, 520, -752},
    { 304, 336, -848},
    { 344, 232, -880},
    // 67 seconds
    { 352, 280, -1048},
    { 248, 200, -1016},
    { 264, 192, -1016},
    { 376, 320, -952},
    { 560, 536, -864},
    { 400, 408, -840},
    { 48, 440, -520},
    { -72, 888, -360},
    { -128, 1208, -32},
    { -360, 1088, 96},
    { -440, 976, -200},
    { -320, 648, -256},
    { -192, 696, -248},
    { 128, 656, -504},
    { 128, 1272, -368},
    { 112, 1168, 136},
    { -8, 1080, 16},
    { -48, 824, 160},
    { -168, 816, 176},
    { -256, 784, 200},
    { -336, 768, 328},
    { -360, 856, 384},
    { -312, 976, 224},
    { -272, 960, 208},
    { -184, 888, 72},
    // 68 seconds
    { -184, 968, 8},
    { -184, 920, 72},
    { -216, 888, 112},
    { -224, 952, 32},
    { -256, 856, 32},
    { -248, 840, 40},
    { -248, 904, 24},
    { -248, 896, 80},
    { -248, 936, 72},
    { -200, 984, 48},
    { -232, 928, 96},
    { -272, 888, 72},
    { -272, 896, 104},
    { -240, 936, 112},
    { -208, 960, 136},
    { -192, 936, 104},
    { -168, 920, 40},
    { -144, 824, 104},
    { -184, 928, 0},
    { -248, 1024, 0},
    { -272, 1000, 56},
    { -224, 1048, 56},
    { -240, 928, 128},
    { -264, 800, 88},
    { -312, 760, 160},
    // 69 seconds
    { -320, 808, 104},
    { -272, 856, -8},
    { -240, 888, -40},
    { -232, 936, -40},
    { -224, 1000, -40},
    { -232, 944, -32},
    { -136, 984, -80},
    { 32, 584, -328},
    { -208, 984, -32},
    { -232, 832, 16},
    { -320, 912, 144},
    { -184, 816, 0},
    { -192, 640, 152},
    { -144, 1016, 136},
    { -128, 1032, 160},
    { -312, 1208, 304},
    { -88, 1376, 400},
    { -296, 1392, 328},
    { -168, 1000, -120},
    { -192, 1080, -144},
    { -304, 1168, -408},
    { -408, 472, -424},
    { -528, 280, -520},
    { -544, 584, -744},
    { -512, 440, -872},
    // 70 seconds
    { -392, 176, -584},
    { -328, -888, -784},
    { -264, 40, -704},
    { -136, -264, -1056},
    { -40, 168, -840},
    { -40, 520, -664},
    { -176, 1416, -136},
    { -408, 1168, -224},
    { -344, 800, -360},
    { -320, 688, -584},
    { -8, 248, -928},
    { 104, -16, -1016},
    { 232, 112, -1064},
    { 288, -136, -1000},
    { 304, -128, -928},
    { 344, -32, -1000},
    { 312, 0, -1168},
    { 456, -48, -1048},
    { 736, 144, -1568},
    { 528, 192, -1416},
    { 216, 560, -1232},
    { -312, 688, -848},
    { -512, 648, -552},
    { -616, 336, -200},
    { -536, 144, -184},
    // 71 seconds
    { -336, 72, -352},
    { -224, 72, -568},
    { -152, -80, -696},
    { -88, -456, -960},
    { -264, -272, -648},
    { -264, 280, -440},
    { -224, 680, -928},
    { -320, 472, -1000},
    { -272, 744, -992},
    { -304, 856, -664},
    { -320, 840, -640},
    { -232, 720, -728},
    { -176, 752, -840},
    { -160, 496, -744},
    { -120, 432, -752},
    { -80, 536, -488},
    { -72, 432, -432},
    { -80, 600, -560},
    { 80, 536, -768},
    { 160, 784, -1104},
    { 240, 848, -1136},
    { 472, 824, -1232},
    { 184, 992, -1128},
    { -32, 800, -704},
    { -64, 496, -280},
    // 72 seconds
    { -40, 368, -504},
    { -8, 408, -440},
    { -16, 392, -640},
    { -160, 920, -304},
    { 64, 1192, -24},
    { 32, 1032, -192},
    { 24, 1032, -184},
    { 24, 1032, -208},
    { 0, 976, -208},
    { 72, 904, -64},
    { 80, 1088, -16},
    { 32, 1024, 80},
    { 48, 920, 176},
    { 80, 984, 8},
    { 80, 888, -96},
    { 120, 936, -232},
    { 64, 864, -256},
    { 40, 816, -360},
    { 0, 712, -448},
    { -56, 640, -504},
    { -96, 544, -504},
    { -104, 544, -536},
    { -160, 504, -552},
    { -56, 432, -624},
    { 160, 600, -752},
    // 73 seconds
    { 288, 744, -896},
    { 424, 664, -1000},
    { 512, 624, -1152},
    { 432, 320, -1008},
    { 456, 368, -1016},
    { 336, -16, -896},
    { 80, 112, -728},
    { -80, 176, -784},
    { -40, 120, -768},
    { 120, 216, -872},
    { 136, 16, -1088},
    { 208, 224, -856},
    { 408, 592, -752},
    { 56, 1504, -320},
    { -216, 1376, -176},
    { -32, 728, -480},
    { 0, 536, -648},
    { 56, 272, -1032},
    { 32, 360, -888},
    { -24, 528, -912},
    { -48, 528, -896},
    { -152, 544, -832},
    { 8, 832, -672},
    { -136, 904, -472},
    { -144, 688, -536},
    // 74 seconds
    { -200, 416, -448},
    { -32, 872, -368},
    { -72, 1208, -280},
    { -168, 744, -480},
    { -128, 600, -408},
    { -40, 928, -296},
    { 32, 1288, -88},
    { -16, 856, -344},
    { -120, 648, -720},
    { -248, 272, -760},
    { -40, 200, -800},
    { -232, 320, -968},
    { -152, 728, -864},
    { -56, 584, -1072},
    { -320, 896, -1040},
    { -352, 368, -1048},
    { -256, -144, -1120},
    { -56, -616, -928},
    { 168, -288, -480},
    { 72, 608, -536},
    { -184, 656, -656},
    { -464, 408, -496},
    { -344, 464, -664},
    { 32, 184, -1000},
    { 176, 8, -1016},
    // 75 seconds
    { 416, -104, -1184},
    { 408, 56, -1272},
    { 232, 16, -1088},
    { 224, -136, -1304},
    { 200, 192, -1080},
    { 248, 40, -1024},
    { 192, 40, -1040},
    { 336, 80, -1032},
    { 368, 176, -816},
    { -144, 720, -568},
    { -304, 792, -576},
    { -664, 1120, -624},
    { -448, 840, -904},
    { -288, 216, -1016},
    { -128, 24, -1016},
    { -24, -336, -1072},
    { -208, 112, -792},
    { -344, -88, -584},
    { -368, 216, -392},
    { -432, 640, -272},
    { -456, 456, 360},
    { -248, 952, 208},
    { -288, 760, 184},
    { -328, 984, 664},
    { -504, 1072, 512},
    // 76 seconds
    { -472, 680, 640},
    { -456, 904, 408},
    { -424, 808, 616},
    { -336, 632, 544},
    { -376, 1064, 344},
    { -328, 624, 464},
    { -248, 896, 296},
    { -200, 896, -8},
    { -88, 936, -184},
    { -80, 1112, -328},
    { -80, 872, -304},
    { -200, 760, -296},
    { -184, 928, 8},
    { -152, 808, 80},
    { -160, 1080, 0},
    { -104, 1112, 176},
    { -40, 1040, 248},
    { -8, 992, 256},
    { -8, 960, 192},
    { -16, 936, 240},
    { 0, 896, 232},
    { -8, 896, 224},
    { 0, 936, 272},
    { 8, 816, 400},
    { -16, 848, 352},
    // 77 seconds
    { 0, 880, 296},
    { 72, 896, 384},
    { 80, 912, 432},
    { 56, 848, 400},
    { 72, 864, 344},
    { 40, 872, 232},
    { 128, 808, 304},
    { 168, 872, 176},
    { 168, 896, 168},
    { 128, 840, 216},
    { 88, 888, 208},
    { 72, 880, 264},
    { 32, 1040, 208},
    { -112, 1208, 120},
    { -144, 944, 64},
    { -8, 888, -96},
    { 104, 792, -264},
    { 272, 656, -488},
    { 392, 568, -600},
    { 528, 616, -832},
    { 608, 464, -808},
    { 704, 560, -784},
    { 472, 344, -488},
    { 0, 520, -224},
    { -264, 936, -136},
    // 78 seconds
    { -600, 1008, 96},
    { -472, 1088, -392},
    { -240, 944, -304},
    { -24, 992, -232},
    { 320, 1408, -296},
    { 280, 1152, 104},
    { 176, 1032, 104},
    { -8, 968, 232},
    { -200, 928, 192},
    { -280, 728, 224},
    { -312, 936, 144},
    { -360, 920, 128},
    { -320, 920, 112},
    { -280, 840, -8},
    { -224, 872, 8},
    { -240, 848, 56},
    { -184, 704, -16},
    { -280, 752, 312},
    { -168, 384, 320},
    { -352, 616, 952},
    { -8, 816, 616},
    { -152, 1464, 776},
    { -248, 1328, 904},
    { -312, 1536, 640},
    { -464, 1008, 696},
    // 79 seconds
    { -224, 576, 248},
    { -472, 640, -168},
    { -384, -368, -696},
    { 184, -672, -792},
    { 32, -536, -1048},
    { -48, -464, -856},
    { 0, -272, -912},
    { 0, 344, -920},
    { -176, 688, -784},
    { -328, 808, -640},
    { -200, 808, -648},
    { -104, 664, -648},
    { -96, 568, -536},
    { 152, 824, -808},
    { 48, 624, -920},
    { 184, 368, -848},
    { 448, 272, -960},
    { 368, 688, -1200},
    { 456, 440, -960},
    { 208, 552, -672},
    { -72, 728, -560},
    { -88, 928, -464},
    { -216, 704, -552},
    { -176, 544, -776},
    { -232, 592, -736},
    // 80 seconds
    { -448, 720, -728},
    { -480, 744, -856},
    { -424, 536, -824},
    { -344, 408, -768},
    { -216, 352, -864},
    { -104, 120, -1032},
    { -72, -392, -1056},
    { -280, 296, -720},
    { -248, 64, -880},
    { -232, -416, -520},
    { -408, 592, 80},
    { -288, 976, -296},
    { -280, 744, -176},
    { -288, 848, 328},
    { -272, 1024, 424},
    { -88, 720, 104},
    { -216, 928, 96},
    { -272, 1192, 536},
    { -432, 1040, 256},
    { -672, 888, 488},
    { -552, 952, 344},
    { -424, 808, 456},
    { -224, 648, 312},
    { -192, 896, 200},
    { -184, 880, 272},
    // 81 seconds
    { -32, 1136, -208},
    { -24, 1296, -160},
    { 8, 616, -616},
    { 32, 768, -448},
    { -64, 888, -96},
    { -152, 664, 0},
    { -216, 832, -48},
    { -144, 928, -88},
    { -32, 1032, -8},
    { 40, 1160, -80},
    { 48, 1104, -8},
    { 48, 992, -16},
    { 0, 984, -40},
    { -64, 1016, -48},
    { -32, 928, 88},
    { 8, 1024, 160},
    { 56, 1056, 248},
    { 32, 1048, 152},
    { 64, 1064, 32},
    { 88, 944, -96},
    { 80, 984, -240},
    { 24, 824, -392},
    { -24, 584, -416},
    { -32, 568, -568},
    { -72, 408, -656},
    // 82 seconds
    { -96, 416, -712},
    { -128, 392, -712},
    { -152, 352, -792},
    { -168, 224, -720},
    { -152, 344, -664},
    { -192, 360, -584},
    { -176, 488, -576},
    { -104, 648, -736},
    { 24, 728, -832},
    { 184, 584, -960},
    { 448, 728, -1096},
    { 504, 784, -1232},
    { 424, 496, -1072},
    { 304, 336, -768},
    { 104, 696, -416},
    { -168, 872, -240},
    { -408, 952, 88},
    { -584, 1144, 8},
    { -368, 824, -72},
    { -136, 1040, -176},
    { 184, 1208, -304},
    { 336, 992, 232},
    { 192, 1152, -8},
    { -80, 800, 184},
    { -192, 752, 200},
    // 83 seconds
    { -248, 944, 160},
    { -304, 984, 192},
    { -328, 944, 176},
    { -312, 896, 280},
    { -296, 800, 168},
    { -248, 832, 232},
    { -216, 784, 360},
    { -8, 704, 200},
    { -208, 552, 640},
    { -144, 576, 720},
    { -48, 1040, 648},
    { -104, 1112, 632},
    { -80, 1048, 768},
    { -48, 1456, 808},
    { -264, 1248, 696},
    { -608, 1272, 872},
    { -168, 720, 192},
    { -408, -280, -72},
    { -176, -1200, -328},
    { 24, 24, -840},
    { -288, -40, -1648},
    { 40, -432, -792},
    { 0, -48, -928},
    { -120, 224, -768},
    { -208, 344, -488},
    // 84 seconds
    { -280, 792, -456},
    { -280, 1064, -416},
    { -232, 784, -520},
    { -192, 704, -576},
    { -96, 816, -784},
    { -112, 664, -928},
    { -112, 376, -880},
    { -40, 264, -816},
    { 144, 392, -1096},
    { 40, 632, -1112},
    { 40, 664, -848},
    { -16, 592, -760},
    { 64, 424, -840},
    { 240, 392, -728},
    { 48, 600, -864},
    { -88, 560, -832},
    { -296, 776, -896},
    { -320, 952, -1056},
    { -384, 640, -632},
    { -288, 480, -680},
    { -216, 336, -656},
    { -80, 272, -672},
    { -424, 384, -416},
    { -448, 488, -248},
    { -568, 600, -368},
    // 85 seconds
    { -576, 704, -344},
    { -504, 704, -472},
    { -496, 848, -624},
    { -568, 704, -544},
    { -464, 656, -592},
    { -456, 592, -640},
    { -496, 440, -616},
    { -440, 512, -696},
    { -432, 568, -784},
    { -440, 288, -816},
    { -392, 248, -968},
    { -320, 64, -976},
    { -232, 104, -992},
    { -240, 104, -1072},
    { -256, 120, -1024},
    { -264, 224, -1024},
    { -264, 232, -960},
    { -280, 312, -976},
    { -264, 328, -864},
    { -200, 264, -856},
    { -216, 248, -936},
    { -240, 368, -768},
    { -240, 520, -824},
    { -240, 544, -688},
    { -216, 536, -704},
    // 86 seconds
    { -200, 408, -656},
    { -128, 552, -536},
    { -72, 816, -616},
    { -72, 920, -592},
    { -32, 960, -480},
    { -72, 904, -624},
    { -120, 832, -544},
    { -160, 880, -488},
    { -96, 856, -400},
    { 8, 872, -376},
    { 144, 840, -416},
    { 368, 816, -536},
    { 552, 944, -704},
    { 488, 896, -720},
    { 344, 872, -632},
    { -96, 1168, -472},
    { -232, 1000, -368},
    { -320, 648, -592},
    { -224, 704, -752},
    { 16, 600, -1128},
    { 216, 704, -1216},
    { 144, 704, -1464},
    { 64, 448, -976},
    { -120, 192, -600},
    { -256, 184, -384},
    // 87 seconds
    { -384, 392, -96},
    { -408, 504, 136},
    { -32, 800, -120},
    { -136, 1000, -368},
    { -32, 792, -784},
    { 24, 608, -832},
    { 24, 704, -960},
    { 80, 472, -1232},
    { 432, 320, -1344},
    { 1136, 320, -1376},
    { 760, -32, -1072},
    { 480, 144, -616},
    { 104, 216, -264},
    { -232, 328, -192},
    { -320, -96, -480},
    { -568, -288, -600},
    { -568, -248, -1200},
    { -392, -248, -1440},
    { -216, -264, -1296},
    { 0, -248, -1696},
    { 232, -344, -1272},
    { 240, 64, -920},
    { 304, 688, -968},
    { 408, -168, -1696},
    { 352, -432, -1288},
    // 88 seconds
    { 16, -120, -1264},
    { -64, -96, -1040},
    { -208, -288, -1304},
    { -320, -448, -1424},
    { -440, -360, -1208},
    { -464, -240, -992},
    { -496, -192, -984},
    { -528, -440, -864},
    { -472, -312, -776},
    { -552, -352, -600},
    { -408, -280, -512},
    { -528, -344, -584},
    { -536, -616, -392},
    { -488, -336, -624},
    { -552, -504, -512},
    { -456, -448, -552},
    { -432, -416, -704},
    { -328, -360, -688},
    { -304, -240, -712},
    { -224, -296, -848},
    { -160, -280, -856},
    { -120, -264, -872},
    { 264, -1504, -1384},
    { -272, 88, -200},
    { -64, -304, -1008},
    // 89 seconds
    { -48, 80, -808},
    { 32, 16, -648},
    { 376, 304, -872},
    { 368, -176, -880},
    { 368, -64, -720},
    { 208, -160, -840},
    { 0, -128, -992},
    { -224, 72, -1152},
    { -1112, 312, -1136},
    { -1328, 912, -728},
    { -1608, 1536, 144},
    { -1072, 1000, 1344},
    { -864, 248, 1648},
    { -824, 240, 1312},
    { -816, 24, 776},
    { -696, -64, 744},
    { -640, 128, 712},
    { -512, -16, 128},
    { -504, 368, 0},
    { -664, 576, 632},
    { -800, 368, 400},
    { -848, 344, 328},
    { -920, 360, 352},
    { -936, 312, 120},
    { -920, 264, -80},
    // 90 seconds
    { -864, 304, -200},
    { -776, 184, -216},
    { -552, 168, -480},
    { -384, 176, -520},
    { -40, 224, -1328},
    { -208, -72, -1568},
    { 320, -520, -1416},
    { 592, -376, -1032},
    { -464, -1200, 96},
    { -2328, -960, 2152},
    { -144, 4000, -640},
    { -1376, 1704, -312},
    { 2656, -1160, -1704},
    { 168, -1208, -1808},
    { -120, -384, -880},
    { -72, -400, -368},
    { 16, -600, -576},
    { 136, -480, -648},
    { 248, -576, -840},
    { 312, -664, -872},
    { 368, -640, -864},
    { 352, -648, -824},
    { 344, -632, -768},
    { 312, -560, -760},
    { 272, -552, -792},
    // 91 seconds
    { 264, -520, -808},
    { 288, -512, -848},
    { 320, -536, -848},
    { 312, -560, -872},
    { 320, -560, -864},
    { 304, -528, -872},
    { 280, -488, -872},
    { 264, -448, -856},
    { 232, -432, -848},
    { 224, -408, -912},
    { 224, -200, -1008},
    { 144, 8, -952},
    { -16, 264, -752},
    { -80, 544, -816},
    { 32, 464, -920},
    { 160, 400, -968},
    { 352, 344, -920},
    { 424, 336, -960},
    { 328, 192, -976},
    { 336, 88, -872},
    { 552, 552, -816},
    { 456, 576, -992},
    { 128, 216, -696},
    { 224, 64, -824},
    { 264, 32, -872},
    // 92 seconds
    { 256, 48, -896},
    { 304, 216, -952},
    { 328, 344, -992},
    { 368, 248, -1056},
    { 232, 280, -928},
    { 224, 344, -912},
    { 240, 264, -896},
    { 256, 168, -912},
    { 368, 48, -904},
    { 592, 224, -1184},
    { 544, 656, -1040},
    { 208, 1608, -472},
    { -136, 1960, -128},
    { -344, 1248, 16},
    { -424, 768, 32},
    { -440, 320, -40},
    { -392, 72, -128},
    { -392, 56, -224},
    { -464, 208, -344},
    { -520, 432, -248},
    { -584, 536, -256},
    { -624, 464, -200},
    { -624, 480, -256},
    { -592, 384, -344},
    { -472, 400, -184},
    // 93 seconds
    { -392, 408, -72},
    { -688, 528, 0},
    { -648, 728, -16},
    { -520, 824, -96},
    { -648, 984, -64},
    { -664, 1128, -88},
    { -528, 1104, -192},
    { -520, 1040, -216},
    { -456, 1016, -192},
    { -416, 912, -192},
    { -416, 912, -136},
    { -400, 912, -88},
    { -392, 880, -64},
    { -360, 872, -56},
    { -352, 872, -48},
    { -344, 904, -80},
    { -336, 880, -96},
    { -328, 880, -112},
    { -320, 864, -128},
    { -296, 848, -144},
    { -280, 840, -152},
    { -256, 856, -184},
    { -240, 920, -192},
    { -224, 928, -216},
    { -224, 920, -216},
    // 94 seconds
    { -224, 920, -224},
    { -224, 928, -232},
    { -208, 920, -224},
    { -208, 912, -224},
    { -200, 920, -224},
    { -200, 928, -224},
    { -184, 904, -216},
    { -184, 912, -216},
    { -184, 920, -224},
    { -184, 912, -224},
    { -168, 904, -224},
    { -168, 896, -224},
    { -160, 896, -224},
    { -152, 904, -224},
    { -152, 904, -224},
    { -152, 904, -232},
    { -152, 896, -232},
    { -160, 896, -232},
    { -152, 904, -248},
    { -152, 912, -240},
    { -152, 912, -248},
    { -144, 896, -240},
    { -144, 888, -256},
    { -160, 888, -272},
    { -168, 888, -272},
    // 95 seconds
    { -160, 896, -304},
    { -176, 864, -320},
    { -184, 848, -320},
    { -192, 856, -368},
    { -184, 816, -408},
    { -184, 888, -480},
    { -160, 728, -544},
    { -112, 680, -576},
    { -96, 608, -632},
    { -32, 712, -712},
    { -48, 512, -712},
    { 24, 536, -832},
    { 144, 424, -864},
    { 176, 376, -792},
    { 280, 272, -816},
    { 408, 312, -920},
    { 384, 264, -920},
    { 368, 128, -952},
    { 376, 160, -952},
    { 344, 88, -912},
    { 344, 48, -888},
    { 336, 40, -952},
    { 352, 8, -952},
    { 360, 72, -968},
    { 352, 48, -952},
    // 96 seconds
    { 328, 16, -936},
    { 320, 8, -944},
    { 336, 24, -960},
    { 352, 16, -944},
    { 344, 16, -904},
    { 352, -64, -936},
    { 368, -72, -912},
    { 368, -48, -968},
    { 424, -88, -944},
    { 552, -88, -1048},
    { 536, 32, -1040},
    { 448, 192, -920},
    { 320, 568, -784},
    { 128, 1024, -472},
    { -208, 1248, -216},
    { -320, 1440, 56},
    { -408, 1216, 160},
    { -488, 992, 104},
    { -440, 600, -16},
    { -536, 560, -96},
    { -496, 296, -208},
    { -568, 360, -168},
    { -584, 352, -208},
    { -640, 328, -168},
    { -712, 488, -72},
    // 97 seconds
    { -808, 528, -88},
    { -816, 448, -48},
    { -824, 560, -48},
    { -768, 384, -256},
    { -728, 480, -256},
    { -752, 544, -120},
    { -704, 384, -168},
    { -576, 392, -264},
    { -632, 408, -176},
    { -720, 488, 96},
    { -720, 488, 48},
    { -744, 648, 8},
    { -712, 720, -56},
    { -648, 792, -160},
    { -544, 832, -320},
    { -488, 736, -456},
    { -384, 744, -568},
    { -304, 752, -640},
    { -224, 800, -688},
    { -168, 816, -824},
    { -136, 712, -848},
    { -80, 648, -856},
    { -56, 632, -856},
    { -40, 624, -864},
    { -32, 592, -848},
    // 98 seconds
    { -24, 568, -824},
    { -24, 576, -816},
    { -16, 592, -824},
    { -8, 568, -816},
    { 0, 568, -816},
    { 16, 560, -816},
    { 24, 544, -800},
    { 24, 544, -792},
    { 16, 536, -792},
    { 24, 544, -784},
    { 32, 536, -784},
    { 24, 544, -792},
    { 32, 552, -800},
    { 32, 528, -792},
    { 32, 544, -792},
    { 40, 544, -808},
    { 40, 544, -800},
    { 48, 536, -800},
    { 48, 552, -800},
    { 56, 544, -792},
    { 56, 536, -792},
    { 64, 536, -792},
    { 64, 560, -792},
    { 72, 568, -800},
    { 64, 560, -800},
    // 99 seconds
    { 56, 552, -792},
    { 56, 560, -792},
    { 40, 576, -784},
    { 24, 592, -744},
    { 16, 560, -768},
    { 0, 520, -832},
    { -16, 520, -904},
    { 32, 496, -888},
    { -8, 448, -856},
    { 72, 624, -888},
    { 32, 464, -784},
    { 80, 496, -872},
    { 224, 448, -856},
    { 312, 224, -848},
    { 472, 208, -888},
    { 584, 16, -832},
    { 568, 24, -864},
    { 520, 24, -912},
    { 432, 88, -848},
    { 384, 64, -784},
    { 352, -16, -832},
    { 368, 64, -920},
    { 368, 104, -888},
    { 424, 64, -952},
    { 416, 16, -952},
    // 100 seconds
    { 400, 48, -904},
    { 408, 56, -928},
    { 416, 80, -896},
    { 392, 112, -904},
    { 360, 224, -928},
    { 320, 168, -880},
    { 384, 168, -856},
    { 400, 264, -832},
    { 392, 304, -872},
    { 408, 288, -896},
    { 368, 208, -672},
    { 440, 272, -824},
    { 456, 416, -824},
    { 400, 488, -696},
    { 416, 624, -760},
    { 352, 552, -696},
    { 352, 424, -752},
    { 336, 384, -760},
    { 384, 344, -744},
    { 424, 328, -784},
    { 496, 128, -784},
    { 488, 288, -680},
    { 464, 520, -432},
    { 320, 688, -80},
    { 152, 976, 112},
    // 101 seconds
    { 88, 952, 440},
    { 56, 920, 624},
    { 8, 880, 712},
    { 56, 688, 776},
    { 72, 624, 864},
    { 72, 576, 904},
    { 80, 560, 912},
    { 80, 512, 928},
    { 80, 512, 920},
    { 104, 408, 880},
    { 56, 504, 976},
    { 80, 440, 984},
    { 48, 488, 1096},
    { -32, 464, 1064},
    { -40, 512, 1168},
    { -160, 504, 1344},
    { -248, 520, 1384},
    { -368, 504, 1296},
    { -344, 416, 1168},
    { -296, 312, 544},
    { -272, 344, -72},
    { -256, 192, -560},
    { -280, 224, -568},
    { -400, -16, -616},
    { -640, 424, 32},
    // 102 seconds
    { -688, 256, -64},
    { -680, 240, -304},
    { -472, 376, -264},
    { -464, 256, -184},
    { -592, 328, 128},
    { -536, 560, 56},
    { -608, 920, 88},
    { -584, 1064, 0},
    { -440, 1256, -352},
    { -376, 1216, -560},
    { -400, 1024, -624},
    { -336, 920, -656},
    { -304, 880, -624},
    { -272, 792, -576},
    { -280, 760, -552},
    { -232, 728, -576},
    { -216, 736, -600},
    { -216, 720, -600},
    { -216, 712, -608},
    { -208, 720, -600},
    { -200, 696, -616},
    { -200, 704, -624},
    { -192, 720, -640},
    { -184, 712, -640},
    { -168, 712, -656},
    // 103 seconds
    { -168, 720, -664},
    { -152, 720, -664},
    { -136, 712, -664},
    { -120, 688, -664},
    { -104, 696, -656},
    { -96, 696, -664},
    { -88, 680, -664},
    { -96, 680, -656},
    { -80, 696, -664},
    { -80, 688, -656},
    { -80, 696, -672},
    { -80, 680, -664},
    { -88, 688, -664},
    { -80, 696, -664},
    { -80, 696, -664},
    { -80, 688, -672},
    { -72, 680, -656},
    { -72, 688, -664},
    { -72, 688, -656},
    { -72, 680, -648},
    { -80, 688, -656},
    { -96, 672, -648},
    { -104, 648, -648},
    { -144, 672, -648},
    { -128, 728, -720},
    // 104 seconds
    { -128, 608, -712},
    { -96, 544, -696},
    { -16, 656, -752},
    { 16, 664, -752},
    { 64, 608, -792},
    { 144, 480, -824},
    { 248, 640, -848},
    { 296, 408, -792},
    { 312, 312, -880},
    { 472, 392, -928},
    { 496, 288, -944},
    { 488, 256, -840},
    { 456, 56, -840},
    { 432, 24, -784},
    { 416, 104, -760},
    { 440, 128, -840},
    { 416, -8, -856},
    { 416, 24, -888},
    { 440, 32, -888},
    { 448, -104, -928},
    { 448, -160, -952},
    { 456, -208, -912},
    { 448, -192, -904},
    { 432, -224, -872},
    { 448, -240, -872},
    // 105 seconds
    { 456, -216, -856},
    { 456, -288, -848},
    { 464, -304, -872},
    { 448, -304, -888},
    { 440, -336, -944},
    { 440, -264, -904},
    { 424, -296, -872},
    { 416, -312, -800},
    { 432, -312, -816},
    { 472, -144, -936},
    { 440, -168, -848},
    { 464, -248, -792},
    { 488, 144, -856},
    { 480, -40, -840},
    { 456, -80, -872},
    { 448, -32, -776},
    { 608, -280, -880},
    { 648, -272, -1040},
    { 560, -280, -824},
    { 504, -24, -568},
    { 320, 424, -256},
    { 232, 720, -48},
    { -8, 792, 368},
    { 8, 976, 816},
    { -24, 896, 896},
    // 106 seconds
    { -24, 560, 936},
    { -88, 600, 920},
    { -104, 664, 840},
    { -40, 616, 824},
    { 32, 640, 816},
    { 80, 504, 848},
    { 88, 536, 856},
    { 112, 608, 824},
    { 64, 664, 720},
    { 0, 1008, 488},
    { 120, 1048, 576},
    { 64, 944, 104},
    { 96, 768, -320},
    { 408, 480, -600},
    { 248, 320, -760},
    { 248, 248, -648},
    { 360, 416, -856},
    { 376, 328, -872},
    { 368, 192, -872},
    { 424, 400, -928},
    { 392, 344, -832},
    { 424, 224, -736},
    { 528, 200, -736},
    { 360, 728, -352},
    { 176, 936, 48},
    // 107 seconds
    { 24, 1032, 392},
    { 16, 912, 760},
    { -16, 744, 832},
    { -64, 696, 848},
    { -24, 624, 936},
    { -56, 584, 1008},
    { -40, 568, 944},
    { -72, 504, 1064},
    { -176, 480, 1128},
    { -264, 488, 1256},
    { -328, 480, 1352},
    { -416, 424, 1384},
    { -408, 360, 1040},
    { -328, 296, 608},
    { -264, 392, -64},
    { -304, 232, -560},
    { -216, 144, -848},
    { -432, 264, -536},
    { -800, 536, 96},
    { -880, 504, -168},
    { -776, 256, -264},
    { -648, 328, -200},
    { -624, 336, -288},
    { -608, 384, -272},
    { -768, 288, -8},
    // 108 seconds
    { -736, 440, 40},
    { -832, 608, 40},
    { -776, 664, 8},
    { -736, 800, 40},
    { -752, 944, -144},
    { -576, 800, -192},
    { -608, 816, -384},
    { -544, 792, -472},
    { -528, 808, -528},
    { -488, 712, -560},
    { -480, 704, -544},
    { -464, 696, -536},
    { -448, 704, -568},
    { -432, 696, -616},
    { -432, 688, -608},
    { -416, 664, -616},
    { -400, 672, -648},
    { -384, 664, -656},
    { -368, 656, -664},
    { -352, 656, -656},
    { -344, 656, -664},
    { -336, 648, -672},
    { -312, 640, -672},
    { -312, 624, -680},
    { -296, 632, -680},
    // 109 seconds
    { -296, 616, -680},
    { -296, 616, -672},
    { -288, 632, -688},
    { -288, 640, -680},
    { -272, 640, -688},
    { -264, 632, -696},
    { -264, 616, -696},
    { -264, 632, -688},
    { -256, 640, -696},
    { -240, 624, -688},
    { -240, 624, -696},
    { -240, 624, -688},
    { -232, 624, -664},
    { -224, 632, -672},
    { -224, 600, -656},
    { -248, 608, -632},
    { -248, 600, -608},
    { -240, 672, -616},
    { -200, 640, -656},
    { -216, 672, -648},
    { -144, 680, -704},
    { -104, 640, -760},
    { -56, 632, -784},
    { -24, 464, -792},
    { 88, 512, -904},
    // 110 seconds
    { 112, 504, -888},
    { 200, 408, -936},
    { 296, 296, -872},
    { 384, 336, -880},
    { 440, 272, -896},
    { 448, 320, -784},
    { 424, 328, -832},
    { 432, 232, -880},
    { 472, 256, -832},
    { 424, 168, -864},
    { 384, 152, -848},
    { 408, 176, -904},
    { 424, 184, -936},
    { 384, 168, -872},
    { 376, 160, -896},
    { 368, 200, -912},
    { 368, 264, -856},
    { 336, 264, -848},
    { 376, 360, -840},
    { 328, 416, -848},
    { 360, 360, -872},
    { 360, 296, -856},
    { 336, 288, -840},
    { 384, 376, -808},
    { 376, 296, -664},
    // 111 seconds
    { 464, 488, -760},
    { 504, 568, -776},
    { 512, 512, -712},
    { 424, 368, -736},
    { 416, 216, -792},
    { 392, 208, -824},
    { 424, 256, -872},
    { 448, 200, -816},
    { 416, 192, -848},
    { 480, 456, -888},
    { 336, 568, -920},
    { 264, 496, -864},
    { 288, 168, -784},
    { 344, 152, -744},
    { 424, -80, -784},
    { 488, -120, -752},
    { 528, -144, -880},
    { 536, -232, -824},
    { 576, -240, -1032},
    { 440, -200, -856},
    { 408, -128, -808},
    { 520, -264, -976},
    { 432, -192, -840},
    { 552, -200, -880},
    { 560, -216, -808},
    // 112 seconds
    { 664, -128, -1016},
    { 544, -224, -1008},
    { 464, -296, -968},
    { 400, -376, -920},
    { 368, -424, -800},
    { 320, -416, -760},
    { 312, -448, -744},
    { 296, -432, -752},
    { 288, -456, -768},
    { 280, -480, -760},
    { 288, -528, -768},
    { 304, -536, -800},
    { 312, -544, -800},
    { 304, -504, -840},
    { 296, -512, -808},
    { 280, -504, -792},
    { 272, -416, -864},
    { 288, -432, -856},
    { 312, -416, -912},
    { 328, -400, -952},
    { 336, -424, -928},
    { 328, -432, -904},
    { 320, -440, -872},
    { 320, -424, -872},
    { 336, -448, -872},
    // 113 seconds
    { 344, -448, -864},
    { 344, -440, -864},
    { 344, -472, -832},
    { 352, -472, -816},
    { 344, -552, -688},
    { 408, -168, -728},
    { 328, 312, -600},
    { 224, 696, -464},
    { 88, 928, -232},
    { -48, 1008, 208},
    { -112, 1048, 480},
    { -104, 936, 688},
    { -88, 752, 792},
    { -104, 616, 880},
    { -80, 632, 872},
    { -80, 568, 896},
    { -80, 480, 944},
    { -144, 464, 912},
    { -104, 432, 952},
    { -136, 392, 1048},
    { -144, 440, 1048},
    { -232, 432, 1136},
    { -296, 464, 1328},
    { -368, 472, 1368},
    { -488, 416, 1376},
    // 114 seconds
    { -448, 440, 1112},
    { -336, 304, 576},
    { -280, 272, -72},
    { -296, 248, -560},
    { -160, 144, -880},
    { -488, 480, -216},
    { -736, 528, 48},
    { -840, 408, -80},
    { -696, 280, -240},
    { -576, 376, -224},
    { -696, 408, -136},
    { -704, 448, -64},
    { -768, 488, 64},
    { -768, 584, 112},
    { -736, 712, 48},
    { -784, 792, -8},
    { -616, 832, -16},
    { -600, 840, -128},
    { -496, 768, -216},
    { -440, 832, -272},
    { -392, 864, -384},
    { -312, 920, -440},
    { -288, 928, -528},
    { -248, 920, -584},
    { -216, 824, -632},
    // 115 seconds
    { -208, 784, -640},
    { -184, 752, -656},
    { -176, 744, -656},
    { -160, 720, -656},
    { -144, 712, -680},
    { -136, 712, -664},
    { -128, 728, -688},
    { -104, 696, -688},
    { -96, 688, -672},
    { -88, 696, -680},
    { -88, 688, -672},
    { -80, 696, -664},
    { -72, 680, -672},
    { -64, 688, -680},
    { -56, 680, -672},
    { -56, 672, -672},
    { -48, 688, -672},
    { -48, 688, -688},
    { -48, 672, -680},
    { -40, 680, -680},
    { -48, 688, -672},
    { -40, 672, -672},
    { -40, 680, -672},
    { -32, 688, -680},
    { -40, 664, -672},
    // 116 seconds
    { -32, 672, -680},
    { -32, 672, -680},
    { -40, 680, -688},
    { -48, 672, -688},
    { -48, 656, -680},
    { -64, 656, -672},
    { -72, 656, -664},
    { -72, 616, -656},
    { -40, 696, -712},
    { -48, 688, -712},
    { -8, 568, -728},
    { 0, 640, -808},
    { -8, 472, -752},
    { 48, 496, -784},
    { 104, 552, -888},
    { 168, 376, -824},
    { 224, 320, -880},
    { 368, 232, -1024},
    { 424, 56, -904},
    { 504, -72, -872},
    { 488, -200, -800},
    { 576, -184, -840},
    { 568, -176, -768},
    { 600, -224, -896},
    { 496, -248, -912},
    // 117 seconds
    { 456, -240, -880},
    { 448, -328, -904},
    { 592, -480, -896},
    { 680, -560, -776},
    { 784, -216, -904},
    { 560, 216, -720},
    { 408, 648, -680},
    { 256, 624, -592},
    { 216, 576, -560},
    { 280, 400, -736},
    { 288, 296, -792},
    { 288, 304, -904},
    { 264, 296, -904},
    { 216, 192, -904},
    { 336, 232, -952},
    { 368, 88, -920},
    { 448, 120, -872},
    { 448, 48, -928},
    { 424, -8, -952},
    { 400, 0, -912},
    { 376, -112, -936},
    { 376, -160, -960},
    { 384, -160, -864},
    { 456, -192, -792},
    { 656, 168, -824},
    // 118 seconds
    { 664, 712, -912},
    { 360, 528, -680},
    { 264, 528, -600},
    { 232, 416, -752},
    { 216, 192, -808},
    { 272, 72, -832},
    { 352, 136, -880},
    { 432, 96, -992},
    { 384, 120, -984},
    { 392, 88, -880},
    { 400, 56, -864},
    { 360, -40, -856},
    { 360, -80, -872},
    { 352, 8, -888},
    { 312, 120, -896},
    { 304, 136, -912},
    { 328, 112, -952},
    { 296, 200, -928},
    { 344, 104, -912},
    { 344, 208, -944},
    { 328, 280, -864},
    { 352, 336, -856},
    { 312, 624, -824},
    { 248, 912, -520},
    { 192, 1384, -48},
    // 119 seconds
    { 56, 1624, 552},
    { -104, 1536, 848},
    { -216, 1096, 936},
    { -256, 944, 744},
    { -296, 584, 416},
    { -208, 320, 120},
    { -192, 272, -48},
    { -304, 384, -224},
    { -448, 448, -216},
    { -560, 544, -280},
    { -656, 504, 16},
    { -792, 576, 224},
    { -840, 440, 136},
    { -880, 624, 128},
    { -904, 552, 144},
    { -816, 456, 0},
    { -864, 496, 56},
    { -840, 480, 32},
    { -696, 368, -192},
    { -680, 456, -152},
    { -744, 400, 0},
    { -784, 352, -16},
    { -880, 480, 136},
    { -832, 552, 104},
    { -840, 632, 40},
    // 120 seconds
    // elapsed: 2 minutes
    { -792, 664, -32},
    { -712, 712, -48},
    { -720, 752, -136},
    { -656, 752, -144},
    { -656, 744, -216},
    { -640, 728, -248},
    { -600, 736, -264},
    { -600, 752, -256},
    { -584, 768, -280},
    { -576, 776, -280},
    { -560, 760, -288},
    { -552, 776, -296},
    { -552, 784, -304},
    { -544, 752, -272},
    { -544, 768, -296},
    { -552, 784, -280},
    { -528, 776, -288},
    { -520, 784, -296},
    { -512, 784, -304},
    { -504, 768, -304},
    { -496, 768, -320},
    { -488, 768, -320},
    { -488, 776, -328},
    { -480, 760, -352},
    { -472, 768, -344},
    // 121 seconds
    { -464, 768, -352},
    { -464, 760, -360},
    { -456, 768, -352},
    { -432, 768, -368},
    { -432, 760, -360},
    { -424, 768, -360},
    { -416, 776, -360},
    { -408, 784, -352},
    { -400, 800, -352},
    { -392, 824, -360},
    { -376, 824, -368},
    { -360, 816, -360},
    { -352, 824, -368},
    { -328, 800, -352},
    { -320, 768, -360},
    { -304, 784, -352},
    { -304, 720, -344},
    { -288, 712, -376},
    { -264, 712, -408},
    { -256, 728, -416},
    { -224, 784, -496},
    { -144, 864, -632},
    { -184, 864, -616},
    { -88, 808, -688},
    { 8, 672, -736},
    // 122 seconds
    { 72, 760, -800},
    { 216, 560, -776},
    { 304, 440, -800},
    { 376, 464, -864},
    { 400, 320, -888},
    { 392, 256, -880},
    { 416, 200, -904},
    { 360, 112, -888},
    { 336, 32, -904},
    { 344, 40, -936},
    { 312, 0, -944},
    { 312, -16, -952},
    { 352, 48, -1000},
    { 312, 8, -912},
    { 392, -48, -856},
    { 496, 128, -864},
    { 528, 368, -968},
    { 336, 744, -880},
    { 160, 1240, -600},
    { -40, 1568, -400},
    { -120, 1336, -104},
    { -272, 1200, 128},
    { -264, 896, 64},
    { -312, 552, 64},
    { -448, 504, -88},
    // 123 seconds
    { -504, 312, -72},
    { -608, 288, -120},
    { -632, 336, -96},
    { -688, 376, -16},
    { -712, 456, 40},
    { -824, 512, 136},
    { -840, 416, 112},
    { -816, 600, 48},
    { -816, 568, -16},
    { -808, 592, 0},
    { -856, 512, 112},
    { -928, 416, 136},
    { -920, 536, 120},
    { -776, 368, 0},
    { -712, 360, -168},
    { -600, 424, -168},
    { -632, 480, -24},
    { -680, 448, 8},
    { -704, 480, -40},
    { -736, 536, 0},
    { -672, 560, -120},
    { -664, 648, -136},
    { -664, 792, -200},
    { -568, 952, -280},
    { -504, 960, -408},
    // 124 seconds
    { -440, 928, -512},
    { -376, 872, -584},
    { -360, 776, -608},
    { -336, 728, -600},
    { -312, 728, -616},
    { -312, 704, -632},
    { -304, 728, -640},
    { -288, 680, -640},
    { -304, 704, -624},
    { -280, 720, -632},
    { -264, 712, -632},
    { -256, 704, -648},
    { -256, 704, -656},
    { -240, 688, -648},
    { -232, 680, -648},
    { -216, 688, -656},
    { -216, 680, -656},
    { -200, 688, -664},
    { -192, 696, -672},
    { -192, 696, -672},
    { -184, 656, -672},
    { -176, 672, -664},
    { -160, 680, -672},
    { -152, 672, -664},
    { -152, 672, -664},
    // 125 seconds
    { -152, 680, -656},
    { -144, 688, -656},
    { -136, 688, -656},
    { -128, 696, -664},
    { -112, 696, -664},
    { -96, 688, -664},
    { -96, 672, -672},
    { -88, 688, -680},
    { -80, 688, -680},
    { -72, 680, -680},
    { -80, 672, -672},
    { -88, 664, -664},
    { -80, 680, -664},
    { -80, 680, -664},
    { -64, 704, -672},
    { -56, 704, -672},
    { -48, 672, -664},
    { -48, 680, -680},
    { -48, 696, -680},
    { -48, 688, -680},
    { -56, 688, -672},
    { -40, 704, -672},
    { -24, 712, -664},
    { -16, 696, -656},
    { -16, 688, -656},
    // 126 seconds
    { -8, 696, -672},
    { -16, 680, -656},
    { -24, 696, -672},
    { -32, 720, -720},
    { -24, 728, -800},
    { -24, 744, -912},
    { 0, 1056, -1032},
    { -128, 1280, -672},
    { -320, 552, 40},
    { -696, 40, 240},
    { -688, 160, -288},
    { 200, 1296, -288},
    { -848, 1632, 2560},
    { -1336, 2216, 3816},
    { 1496, -392, -768},
    { 400, 448, -1880},
    { 144, -496, -1104},
    { 168, -272, -728},
    { 120, -392, -848},
    { 120, -168, -936},
    { 136, -360, -872},
    { 144, -368, -1016},
    { 152, -368, -936},
    { 184, -376, -1000},
    { 168, -352, -992},
    // 127 seconds
    { 168, -352, -960},
    { 160, -376, -976},
    { 152, -352, -976},
    { 152, -320, -992},
    { 144, -312, -1000},
    { 144, -312, -984},
    { 136, -320, -968},
    { 136, -328, -960},
    { 136, -304, -984},
    { 120, -304, -976},
    { 120, -312, -968},
    { 128, -296, -976},
    { 120, -296, -984},
    { 112, -288, -984},
    { 104, -288, -1008},
    { 64, -272, -1000},
    { 64, -296, -1024},
    { 64, -272, -1024},
    { 64, -360, -944},
    { 136, -288, -1000},
    { 104, -296, -992},
    { 56, -312, -952},
    { 32, -272, -960},
    { 40, -272, -992},
    { 56, -320, -992},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}



// ---------------------------------------------------------------
// Sample captured: 2015-09-30 06:46:20 local
AccelRawData *activity_sample_washing_up_2(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME washing_up_2
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 60
  //> TEST_WEIGHT 10.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 192, -64, -976},
    { 192, -24, -976},
    { 200, -64, -976},
    { 168, -112, -992},
    { 168, -72, -1008},
    { 184, -64, -1000},
    { 152, -104, -976},
    { 224, -48, -984},
    { 200, -32, -992},
    { 192, -64, -976},
    { 184, -64, -984},
    { 192, -48, -992},
    { 192, -48, -984},
    { 192, -64, -992},
    { 184, -56, -992},
    { 192, -56, -992},
    { 192, -48, -976},
    { 192, -48, -976},
    { 192, -56, -976},
    { 192, -56, -984},
    { 176, -56, -976},
    { 192, -48, -984},
    { 192, -48, -976},
    { 192, -32, -976},
    { 304, -64, -976},
    // 1 seconds
    { 160, -112, -1008},
    { 144, -80, -1008},
    { 176, -16, -992},
    { 192, -72, -984},
    { 208, -80, -992},
    { 192, -40, -984},
    { 184, -48, -992},
    { 176, -64, -984},
    { 208, -40, -984},
    { 176, -40, -992},
    { 192, -48, -984},
    { 192, -56, -984},
    { 184, -40, -976},
    { 192, -56, -984},
    { 200, -56, -984},
    { 200, -32, -984},
    { 200, -24, -984},
    { 200, -40, -984},
    { 192, -32, -984},
    { 208, -40, -992},
    { 200, -24, -976},
    { 192, -8, -976},
    { 192, -24, -992},
    { 192, -8, -984},
    { 192, -16, -984},
    { 192, -16, -984},
    { 192, -16, -984},
    { 200, 0, -976},
    { 192, 0, -984},
    { 200, -16, -992},
    { 192, -8, -976},
    { 192, -8, -984},
    { 184, -16, -984},
    { 184, -8, -984},
    { 192, 0, -984},
    { 192, 0, -976},
    { 200, -8, -984},
    { 200, 0, -976},
    { 200, -8, -984},
    { 200, -16, -976},
    { 232, -40, -1008},
    { 240, -32, -976},
    { 224, -56, -968},
    { 256, -40, -992},
    { 272, -72, -1000},
    { 304, -208, -1024},
    { 312, -296, -1072},
    { 312, -200, -1120},
    { 168, -256, -776},
    { 168, 576, -848},
    // 3 seconds
    { -24, 960, -1048},
    { -256, 1072, -856},
    { -416, 1024, -600},
    { -400, 936, -416},
    { -440, 864, -296},
    { -424, 872, -192},
    { -400, 688, -120},
    { -368, 616, -104},
    { -312, 712, -248},
    { -280, 656, -224},
    { -272, 712, -320},
    { -248, 704, -432},
    { -288, 624, -320},
    { -304, 688, -440},
    { -352, 688, -432},
    { -360, 696, -384},
    { -392, 696, -424},
    { -344, 880, -528},
    { -456, 768, -416},
    { -360, 904, -488},
    { -368, 800, -512},
    { -328, 728, -520},
    { -344, 840, -408},
    { -336, 848, -392},
    { -264, 1000, -192},
    // 4 seconds
    { -312, 896, -8},
    { -328, 792, -80},
    { -288, 848, -264},
    { -344, 800, -336},
    { -432, 672, -480},
    { -448, 648, -600},
    { -424, 536, -712},
    { -416, 400, -704},
    { -344, 208, -544},
    { -352, 392, -488},
    { -336, 760, -408},
    { -288, 864, -336},
    { -280, 896, -424},
    { -304, 1040, -288},
    { -296, 1040, -296},
    { -312, 1000, -168},
    { -304, 992, -120},
    { -272, 1024, -232},
    { -248, 1000, -288},
    { -192, 1008, -312},
    { -112, 992, -384},
    { -32, 920, -384},
    { 56, 872, -392},
    { 136, 896, -368},
    { 192, 912, -352},
    // 5 seconds
    { 184, 840, -344},
    { 160, 792, -320},
    { 120, 824, -312},
    { 72, 824, -264},
    { 72, 864, -280},
    { 72, 904, -264},
    { 72, 920, -240},
    { 88, 912, -256},
    { 80, 872, -272},
    { 64, 856, -208},
    { 192, 1000, -320},
    { 64, 928, -280},
    { 144, 928, -256},
    { 144, 856, -296},
    { 144, 856, -304},
    { 112, 864, -296},
    { 72, 888, -272},
    { 24, 936, -232},
    { -40, 920, -168},
    { -88, 952, -160},
    { -72, 1000, -208},
    { -40, 1112, -240},
    { -32, 1048, -216},
    { -48, 928, -184},
    { -80, 872, -136},
    // 6 seconds
    { -136, 920, -120},
    { -160, 912, -128},
    { -192, 872, -56},
    { -192, 864, -88},
    { -120, 888, -272},
    { -96, 960, -232},
    { -48, 904, -264},
    { 32, 792, -408},
    { 96, 728, -264},
    { 152, 752, -312},
    { 104, 856, -584},
    { -184, 856, -240},
    { -192, 928, -280},
    { -232, 952, -400},
    { -88, 800, -448},
    { -184, 992, -256},
    { -248, 960, -128},
    { -288, 1088, -232},
    { -104, 736, -448},
    { -184, 872, -320},
    { -168, 784, -216},
    { -184, 864, -232},
    { -200, 880, -248},
    { -216, 920, -256},
    { -208, 880, -240},
    // 7 seconds
    { -168, 872, -272},
    { -136, 800, -224},
    { -112, 912, -256},
    { -120, 984, -168},
    { -152, 1008, -128},
    { -152, 984, -240},
    { -152, 984, -304},
    { -144, 896, -328},
    { -120, 904, -312},
    { -96, 624, -312},
    { -88, 784, -392},
    { -40, 992, -640},
    { -8, 736, -856},
    { -16, 688, -864},
    { 24, 576, -736},
    { 8, 464, -720},
    { 0, 664, -664},
    { -64, 664, -592},
    { -80, 696, -584},
    { -80, 608, -632},
    { -80, 536, -624},
    { -40, 592, -752},
    { 72, 496, -792},
    { 240, 520, -1088},
    { 184, 288, -960},
    // 8 seconds
    { 176, 376, -904},
    { 112, 584, -792},
    { 80, 584, -768},
    { 80, 696, -688},
    { 88, 720, -664},
    { 80, 744, -696},
    { 96, 728, -624},
    { 104, 720, -656},
    { 160, 736, -704},
    { 192, 744, -728},
    { 192, 648, -712},
    { 216, 664, -704},
    { 360, 744, -840},
    { 312, 768, -880},
    { 120, 696, -760},
    { 48, 560, -600},
    { 32, 456, -528},
    { 32, 512, -472},
    { 24, 600, -528},
    { 72, 648, -616},
    { 152, 744, -744},
    { 152, 752, -720},
    { 104, 744, -696},
    { 72, 768, -640},
    { 24, 808, -568},
    // 9 seconds
    { 8, 848, -536},
    { 8, 904, -504},
    { 40, 960, -496},
    { 8, 936, -392},
    { -40, 872, -288},
    { -112, 904, -224},
    { -168, 920, -160},
    { -232, 928, -136},
    { -248, 1000, -192},
    { -192, 1000, -312},
    { -184, 904, -304},
    { -112, 752, -392},
    { -48, 712, -592},
    { -16, 624, -672},
    { 48, 392, -704},
    { 24, 424, -656},
    { -48, 480, -672},
    { -264, 744, -776},
    { -288, 544, -808},
    { -240, 360, -1008},
    { -280, 280, -824},
    { -304, 440, -720},
    { -168, 696, -696},
    { -80, 448, -840},
    { -192, 280, -608},
    // 10 seconds
    { -40, 1064, -456},
    { -112, 1024, -560},
    { -168, 888, -456},
    { -80, 800, -280},
    { -104, 944, -256},
    { -96, 840, -64},
    { -104, 3224, 232},
    { -208, 952, 416},
    { -96, 1040, 232},
    { -96, 1424, -80},
    { -224, 928, 320},
    { -216, 976, 280},
    { -200, 936, 120},
    { -176, 664, 88},
    { 240, 400, -184},
    { -176, 672, -144},
    { -264, 784, -112},
    { -344, 840, -224},
    { -376, 952, -216},
    { -424, 1024, -136},
    { -384, 888, -216},
    { -312, 840, -208},
    { -248, 904, -256},
    { -208, 808, -192},
    { -184, 928, -144},
    // 11 seconds
    { -112, 952, -360},
    { -168, 856, -96},
    { -112, 936, -144},
    { -48, 1096, -256},
    { -96, 1152, -80},
    { -56, 1032, -184},
    { -40, 832, -296},
    { -128, 856, -328},
    { -104, 512, -288},
    { -112, 904, -240},
    { -120, 960, -128},
    { -64, 904, -152},
    { -72, 1160, -16},
    { -88, 1080, 32},
    { -88, 920, 0},
    { -64, 984, 80},
    { -64, 968, 128},
    { -80, 872, 128},
    { -56, 936, 40},
    { -48, 944, 56},
    { -80, 944, 88},
    { -64, 1016, 120},
    { -72, 952, 136},
    { -64, 952, 128},
    { -40, 928, 112},
    // 12 seconds
    { -32, 992, 8},
    { -48, 944, 8},
    { -56, 952, -72},
    { -48, 936, -112},
    { -64, 960, -152},
    { -80, 984, -240},
    { -72, 848, -368},
    { -88, 840, -488},
    { -120, 696, -616},
    { -112, 576, -688},
    { -120, 512, -744},
    { -136, 496, -824},
    { -184, 568, -824},
    { -176, 344, -824},
    { -160, 352, -816},
    { -176, 552, -864},
    { -192, 464, -800},
    { -200, 424, -832},
    { -200, 496, -840},
    { -208, 536, -784},
    { -232, 552, -752},
    { -232, 488, -720},
    { -216, 392, -696},
    { -152, 440, -720},
    { -104, 480, -752},
    // 13 seconds
    { -112, 384, -672},
    { -40, 640, -728},
    { -88, 696, -632},
    { -72, 728, -704},
    { -56, 824, -704},
    { -8, 784, -736},
    { 72, 776, -784},
    { 112, 680, -784},
    { 120, 584, -792},
    { 184, 584, -848},
    { 176, 568, -832},
    { 168, 512, -848},
    { 200, 440, -872},
    { 224, 432, -824},
    { 200, 576, -688},
    { 176, 528, -704},
    { 128, 576, -696},
    { 112, 624, -688},
    { 112, 592, -744},
    { 72, 656, -848},
    { 88, 632, -840},
    { 120, 584, -824},
    { 96, 568, -736},
    { 96, 672, -784},
    { 128, 624, -784},
    // 14 seconds
    { 96, 608, -736},
    { 104, 560, -744},
    { 152, 552, -776},
    { 160, 528, -768},
    { 176, 488, -808},
    { 192, 512, -824},
    { 224, 440, -872},
    { 184, 408, -760},
    { 248, 376, -720},
    { 304, 696, -864},
    { 176, 1016, -800},
    { 40, 1152, -568},
    { -80, 960, -392},
    { -80, 752, -416},
    { -32, 592, -536},
    { -8, 480, -648},
    { -8, 504, -696},
    { 104, 384, -720},
    { 112, 568, -808},
    { 72, 648, -840},
    { 8, 584, -768},
    { -48, 672, -720},
    { -40, 640, -720},
    { -72, 632, -624},
    { -56, 680, -600},
    // 15 seconds
    { -56, 696, -576},
    { -32, 688, -688},
    { -120, 752, -496},
    { -80, 808, -488},
    { -8, 736, -392},
    { 0, 944, -128},
    { 32, 1232, -104},
    { -16, 888, -144},
    { 48, 1040, -80},
    { 24, 1024, -152},
    { 32, 928, -72},
    { -16, 968, 120},
    { -56, 984, -24},
    { -48, 888, 16},
    { -64, 968, -96},
    { -48, 1024, -80},
    { -48, 816, -128},
    { -72, 992, -208},
    { -120, 920, -104},
    { -160, 864, -72},
    { -168, 984, -120},
    { -168, 984, -16},
    { -144, 896, -56},
    { -144, 936, -56},
    { -32, 864, -104},
    // 16 seconds
    { -64, 920, -136},
    { -248, 928, 72},
    { -272, 928, 32},
    { -232, 856, 136},
    { -296, 936, 200},
    { -264, 744, 208},
    { -192, 528, 424},
    { -264, 1056, 496},
    { -288, 872, 480},
    { -248, 680, 560},
    { -200, 560, 512},
    { -216, 696, 904},
    { -232, 520, 928},
    { -224, 192, 632},
    { -328, 576, 672},
    { -328, 512, 784},
    { -328, 464, 920},
    { -296, 528, 952},
    { -112, 344, 640},
    { -216, 536, 872},
    { -264, 568, 952},
    { -352, 200, 744},
    { -336, 320, 776},
    { -344, 488, 872},
    { -280, 464, 984},
    // 17 seconds
    { -264, 272, 928},
    { -304, 240, 824},
    { -248, 584, 736},
    { -288, 344, 1192},
    { -336, 88, 760},
    { -256, 448, 848},
    { -296, 1160, 696},
    { -392, 552, 1016},
    { -352, -352, 632},
    { -312, 1064, 304},
    { -392, 1392, 416},
    { -240, 88, 64},
    { -312, 1200, -384},
    { -456, 944, -152},
    { -464, 976, -80},
    { -408, 1176, 64},
    { -312, 648, -88},
    { -216, 752, -176},
    { -360, 1024, -104},
    { -248, 504, -504},
    { -432, 632, -48},
    { -360, 984, -320},
    { -112, 672, -976},
    { -224, -808, -800},
    { -344, 384, -1064},
    // 18 seconds
    { -288, 600, -1000},
    { -280, 776, -720},
    { -64, 464, -888},
    { -128, 400, -888},
    { -136, 464, -816},
    { -112, 616, -696},
    { -232, 736, -480},
    { -32, 552, -608},
    { -16, 568, -632},
    { 0, 592, -528},
    { 40, 656, -488},
    { -8, 768, -472},
    { -24, 920, -448},
    { -48, 968, -448},
    { -40, 1008, -528},
    { -32, 992, -568},
    { 32, 992, -576},
    { 56, 960, -560},
    { 72, 872, -520},
    { 88, 768, -488},
    { 88, 784, -472},
    { 88, 792, -480},
    { 104, 784, -488},
    { 168, 760, -520},
    { 224, 744, -536},
    // 19 seconds
    { 216, 696, -480},
    { 200, 672, -456},
    { 160, 760, -424},
    { 144, 856, -464},
    { 152, 912, -536},
    { 160, 848, -544},
    { 184, 792, -608},
    { 208, 752, -600},
    { 192, 736, -512},
    { 296, 672, -520},
    { 272, 584, -496},
    { 336, 608, -576},
    { 280, 624, -520},
    { 216, 720, -560},
    { 200, 728, -632},
    { 232, 696, -688},
    { 240, 584, -736},
    { 248, 584, -808},
    { 248, 584, -776},
    { 248, 560, -720},
    { 248, 592, -712},
    { 232, 608, -712},
    { 216, 624, -720},
    { 208, 624, -696},
    { 200, 600, -664},
    // 20 seconds
    { 232, 632, -696},
    { 208, 616, -672},
    { 200, 608, -680},
    { 216, 592, -712},
    { 256, 592, -760},
    { 264, 568, -760},
    { 272, 576, -736},
    { 256, 584, -720},
    { 240, 576, -704},
    { 240, 584, -712},
    { 256, 584, -720},
    { 256, 568, -720},
    { 256, 560, -712},
    { 256, 568, -712},
    { 256, 576, -712},
    { 256, 568, -728},
    { 248, 568, -720},
    { 248, 576, -712},
    { 256, 576, -728},
    { 248, 576, -728},
    { 248, 576, -704},
    { 248, 568, -704},
    { 256, 584, -728},
    { 248, 576, -720},
    { 248, 560, -712},
    // 21 seconds
    { 256, 584, -728},
    { 264, 584, -720},
    { 256, 568, -720},
    { 256, 568, -720},
    { 256, 568, -728},
    { 264, 576, -712},
    { 264, 568, -720},
    { 264, 568, -720},
    { 264, 576, -712},
    { 272, 568, -720},
    { 272, 576, -712},
    { 272, 560, -712},
    { 272, 576, -720},
    { 272, 576, -712},
    { 280, 568, -712},
    { 280, 568, -720},
    { 280, 576, -712},
    { 288, 576, -712},
    { 280, 568, -720},
    { 280, 568, -704},
    { 288, 576, -712},
    { 288, 560, -704},
    { 288, 568, -720},
    { 288, 576, -712},
    { 288, 560, -712},
    // 22 seconds
    { 288, 568, -712},
    { 280, 560, -712},
    { 288, 568, -712},
    { 288, 560, -712},
    { 296, 568, -712},
    { 296, 568, -704},
    { 296, 568, -720},
    { 296, 552, -704},
    { 296, 568, -720},
    { 288, 560, -712},
    { 304, 544, -720},
    { 288, 544, -696},
    { 288, 576, -728},
    { 272, 560, -744},
    { 296, 568, -728},
    { 280, 552, -720},
    { 272, 576, -736},
    { 272, 552, -720},
    { 280, 568, -712},
    { 272, 560, -712},
    { 288, 568, -728},
    { 288, 568, -728},
    { 280, 560, -696},
    { 272, 560, -696},
    { 272, 568, -728},
    // 23 seconds
    { 288, 552, -720},
    { 288, 568, -704},
    { 288, 560, -712},
    { 288, 560, -720},
    { 288, 568, -728},
    { 288, 568, -712},
    { 288, 568, -704},
    { 296, 576, -712},
    { 288, 568, -736},
    { 320, 576, -728},
    { 336, 552, -712},
    { 312, 560, -712},
    { 304, 560, -720},
    { 288, 552, -680},
    { 280, 560, -640},
    { 304, 568, -688},
    { 304, 560, -720},
    { 304, 584, -728},
    { 336, 584, -784},
    { 336, 568, -800},
    { 344, 600, -840},
    { 384, 712, -1048},
    { 328, 448, -912},
    { -32, 936, -512},
    { -320, 1880, -808},
    // 24 seconds
    { -296, 1472, -672},
    { -200, 816, -392},
    { -288, 808, -448},
    { -344, 936, -384},
    { -288, 784, -456},
    { -296, 624, -440},
    { -232, 336, -240},
    { -88, 432, -392},
    { -72, 576, -512},
    { -72, 464, -416},
    { -40, 376, -576},
    { -48, 592, -552},
    { -160, 624, -584},
    { -88, 384, -760},
    { -104, 520, -768},
    { -96, 648, -688},
    { -40, 520, -784},
    { 40, 584, -720},
    { 56, 648, -640},
    { 144, 864, -776},
    { 208, 568, -888},
    { 296, 760, -680},
    { 400, 952, -512},
    { 152, 848, -320},
    { -216, 512, -80},
    // 25 seconds
    { -512, 384, -192},
    { -456, 200, -24},
    { -760, 320, -208},
    { -784, 456, -480},
    { -768, 840, -520},
    { -728, 1040, -344},
    { -696, 1280, -528},
    { -672, 1176, -288},
    { -600, 1040, -152},
    { -552, 1048, -136},
    { -536, 968, -104},
    { -456, 832, -32},
    { -472, 936, 120},
    { -408, 856, 24},
    { -376, 1008, 88},
    { -360, 888, 80},
    { -256, 832, -168},
    { -296, 864, -208},
    { -328, 632, -424},
    { -320, 800, -288},
    { -408, 1040, -248},
    { -424, 928, -320},
    { -384, 648, -328},
    { 72, -64, -2312},
    { -144, 976, -352},
    // 26 seconds
    { -16, 1344, 760},
    { -224, 1144, 912},
    { -336, 544, 696},
    { -280, 696, 336},
    { -264, 888, -216},
    { -296, 896, -344},
    { -224, 1360, -416},
    { -144, 1208, -432},
    { -136, 1040, -392},
    { -112, 1032, -408},
    { -40, 1112, -392},
    { -232, 952, -320},
    { -216, 1064, -720},
    { -64, 1408, -1544},
    { -16, 1792, -1736},
    { -120, 1936, -1976},
    { -216, 1664, -1448},
    { -160, 1552, -592},
    { 72, 1232, -64},
    { 320, 736, 48},
    { 592, 120, 56},
    { 480, -400, 328},
    { 144, -528, -304},
    { 24, -520, -600},
    { -128, -616, -696},
    // 27 seconds
    { -240, -600, -728},
    { -400, -472, -784},
    { -528, -368, -864},
    { -544, -200, -912},
    { -552, 24, -1040},
    { -544, 80, -1048},
    { -536, 56, -1072},
    { -496, -64, -1032},
    { -408, -184, -960},
    { -416, -360, -800},
    { -448, -312, -896},
    { -528, -344, -760},
    { -528, -304, -768},
    { -528, -296, -784},
    { -552, -272, -832},
    { -560, -224, -928},
    { -544, -264, -912},
    { -536, -240, -920},
    { -536, -248, -840},
    { -496, -264, -760},
    { -552, -232, -776},
    { -552, -296, -776},
    { -536, -280, -848},
    { -528, -328, -888},
    { -488, -376, -872},
    // 28 seconds
    { -432, -360, -864},
    { -312, -320, -832},
    { -296, -312, -648},
    { -112, -344, -472},
    { 64, -296, -400},
    { 128, -232, -312},
    { 264, -200, -408},
    { 112, -232, -272},
    { -224, -48, -320},
    { -752, -8, -360},
    { -1168, 80, -728},
    { -1104, 512, -1320},
    { -1128, 472, -1536},
    { -984, 408, -1552},
    { -680, 592, -1872},
    { -472, 240, -1520},
    { -416, 360, -1040},
    { -232, 304, -1160},
    { -392, 456, -976},
    { -240, 216, -1136},
    { -352, 600, -1224},
    { -384, 680, -784},
    { -424, 440, 0},
    { -408, 328, 608},
    { -208, 1728, 264},
    // 29 seconds
    { -400, 648, 296},
    { -600, 1336, 320},
    { -504, 1408, 88},
    { -944, 1216, 736},
    { -1376, 1072, 864},
    { -1096, 944, 688},
    { -696, 736, 40},
    { -120, 920, -408},
    { 368, 752, -480},
    { 568, 608, -568},
    { 560, 512, -488},
    { 560, 336, -448},
    { 536, -360, -584},
    { 32, 824, -856},
    { -568, -360, -736},
    { -456, -632, -1624},
    { -328, -832, -1848},
    { -216, -872, -1368},
    { -48, -568, -1488},
    { -48, 408, -1192},
    { 32, 584, -224},
    { 40, 856, 216},
    { -88, -1144, -72},
    { -456, 760, -360},
    { -24, -3192, -440},
    // 30 seconds
    { -184, -1072, -1752},
    { -408, -656, -1688},
    { -168, -1096, -1424},
    { -80, 40, -1624},
    { -280, 816, -848},
    { -64, 536, 32},
    { 192, -944, 96},
    { 280, -376, -504},
    { 304, -16, -512},
    { 464, -656, -624},
    { 392, -872, -608},
    { 312, -456, -864},
    { 128, 40, -1352},
    { 128, 136, -1472},
    { -88, 184, -1368},
    { -192, -40, -1320},
    { -160, -184, -1224},
    { -96, -248, -1216},
    { -80, -272, -1264},
    { -88, -328, -1192},
    { -32, -248, -1152},
    { -8, -312, -1128},
    { 32, -320, -1040},
    { 72, -336, -944},
    { 112, -288, -936},
    // 31 seconds
    { 128, -280, -992},
    { 80, -256, -976},
    { 48, -264, -920},
    { 24, -208, -944},
    { 8, -208, -976},
    { 16, -200, -984},
    { 40, -200, -992},
    { 56, -160, -1048},
    { 48, -152, -1016},
    { 40, -160, -1008},
    { 48, -152, -1008},
    { 64, -136, -1016},
    { 64, -136, -1000},
    { 64, -136, -1016},
    { 88, -144, -1016},
    { 80, -136, -992},
    { 96, -136, -992},
    { 112, -104, -1024},
    { 120, -48, -1008},
    { 160, 48, -1072},
    { 136, 248, -1056},
    { 96, 344, -480},
    { 16, 1200, 56},
    { -104, 1384, -16},
    { -64, 808, 144},
    // 32 seconds
    { -152, 768, 192},
    { -256, 872, 96},
    { -240, 824, -64},
    { -248, 832, -88},
    { -224, 912, -240},
    { -208, 984, -144},
    { -232, 1016, -112},
    { -216, 944, -112},
    { -232, 936, -144},
    { -232, 976, -136},
    { -256, 832, -80},
    { -280, 952, -120},
    { -296, 1064, -184},
    { -184, 520, 288},
    { -272, 872, 56},
    { -320, 1088, -360},
    { -320, 992, -376},
    { -144, 568, -288},
    { -296, 696, -56},
    { -312, 768, -200},
    { -368, 888, -376},
    { -504, 1096, -656},
    { -480, 1304, -568},
    { -368, 848, -944},
    { -408, 1208, -792},
    // 33 seconds
    { -544, 976, -464},
    { -568, 920, -328},
    { -528, 656, -176},
    { -440, 728, 40},
    { -288, 672, -104},
    { -168, 600, -152},
    { -32, 752, -40},
    { 80, 888, -192},
    { 8, 696, -136},
    { 32, 824, -416},
    { 56, 760, -264},
    { 16, 720, -384},
    { -32, 1184, -704},
    { -72, 696, -528},
    { -168, 752, -624},
    { -200, 760, -440},
    { -184, 1096, -608},
    { -160, 1648, -1048},
    { -640, 1336, -1136},
    { -672, 880, -984},
    { -648, 432, -672},
    { -648, 40, -464},
    { -560, 40, -320},
    { -504, 88, -136},
    { -320, 200, -456},
    // 34 seconds
    { -392, 384, -496},
    { -376, 368, -520},
    { -400, 600, -744},
    { -400, 464, -664},
    { -120, 672, -656},
    { -144, 728, -608},
    { -32, 952, -496},
    { -48, 784, -368},
    { -264, 720, 72},
    { -424, 472, 144},
    { -536, 40, 32},
    { -712, 16, 48},
    { -680, 80, -104},
    { -624, 200, -560},
    { -680, 672, -896},
    { -608, 1032, -1112},
    { -440, 1184, -1080},
    { -480, 1640, -840},
    { -376, 1400, -736},
    { -256, 976, -560},
    { -184, 1128, -624},
    { -264, 752, -544},
    { -280, 712, -672},
    { -408, 640, -552},
    { -432, 680, -832},
    // 35 seconds
    { -408, 760, -664},
    { -280, 768, -704},
    { -328, 584, -368},
    { -296, 512, -368},
    { -216, 560, -496},
    { -216, 272, -880},
    { -176, 528, -992},
    { -288, 400, -840},
    { -104, 224, -992},
    { -192, 264, -1040},
    { -240, 208, -768},
    { -192, 320, -840},
    { -152, 392, -1152},
    { -152, 408, -944},
    { -144, 512, -1000},
    { -200, 320, -904},
    { -192, 320, -904},
    { -184, 280, -928},
    { -240, 264, -904},
    { -216, 440, -872},
    { 560, -1984, -4000},
    { 56, 664, -1432},
    { -88, 1320, -424},
    { -264, 752, 152},
    { -376, 664, 336},
    // 36 seconds
    { -392, 424, 384},
    { -288, 320, 248},
    { -224, 312, 48},
    { -200, 696, -312},
    { -224, 1064, -688},
    { -296, 1080, -776},
    { -176, 1152, -912},
    { -40, 928, -1072},
    { -8, 816, -1000},
    { 64, 752, -1008},
    { 144, 640, -976},
    { 192, 504, -824},
    { 176, 504, -704},
    { 152, 560, -640},
    { 104, 632, -640},
    { 104, 696, -672},
    { 144, 672, -672},
    { 128, 600, -656},
    { 96, 624, -672},
    { 72, 656, -672},
    { 56, 712, -720},
    { 104, 728, -784},
    { 184, 680, -776},
    { 176, 560, -688},
    { 144, 576, -664},
    // 37 seconds
    { 120, 600, -584},
    { 72, 608, -560},
    { 24, 696, -560},
    { 0, 808, -616},
    { 16, 880, -680},
    { 48, 824, -696},
    { 64, 760, -680},
    { 104, 752, -640},
    { 136, 712, -576},
    { 152, 688, -576},
    { 168, 704, -568},
    { 176, 688, -600},
    { 152, 768, -624},
    { 88, 784, -728},
    { 40, 1216, -824},
    { -48, 1384, -728},
    { -184, 1304, -520},
    { -168, 880, -400},
    { -264, 600, -136},
    { -200, 376, -176},
    { -192, 232, -200},
    { -192, 392, -360},
    { -232, 680, -496},
    { -304, 736, -608},
    { -312, 736, -712},
    // 38 seconds
    { -336, 616, -744},
    { -376, 544, -728},
    { -376, 576, -776},
    { -312, 520, -960},
    { -376, 648, -920},
    { -344, 376, -720},
    { -248, 232, -832},
    { -328, 480, -688},
    { -256, 336, -688},
    { -200, 368, -856},
    { -280, 400, -680},
    { -232, 640, -824},
    { -200, 568, -624},
    { -168, 768, -776},
    { -120, 1000, -424},
    { -280, 752, -688},
    { -176, 768, -624},
    { -168, 744, -640},
    { -152, 656, -640},
    { -224, 616, -488},
    { -216, 488, -120},
    { -264, 816, -272},
    { -280, 1016, -384},
    { -392, 1048, -264},
    { -560, 1024, -312},
    // 39 seconds
    { -528, 904, -272},
    { -440, 560, -384},
    { -352, 688, -728},
    { -272, 624, -480},
    { -208, 880, -640},
    { -512, 896, -600},
    { -464, 1072, -800},
    { -504, 1088, -816},
    { -608, 1208, -696},
    { -680, 1240, -480},
    { -744, 1040, -352},
    { -760, 920, -360},
    { -776, 760, -152},
    { -688, 720, 16},
    { -624, 632, -168},
    { -552, 624, -120},
    { -432, 576, -80},
    { -320, 576, -288},
    { -288, 472, -168},
    { -272, 560, -360},
    { -232, 512, -472},
    { -288, 544, -368},
    { -256, 472, -616},
    { -288, 560, -624},
    { -344, 616, -600},
    // 40 seconds
    { -360, 640, -688},
    { -416, 648, -664},
    { -520, 808, -760},
    { -464, 592, -632},
    { -464, 632, -632},
    { -472, 512, -608},
    { -392, 560, -696},
    { -264, 480, -592},
    { -240, 432, -824},
    { -352, 448, -1088},
    { -784, 360, -1112},
    { -944, 296, -976},
    { -840, 544, -664},
    { -624, 808, -448},
    { -528, 792, -360},
    { -528, 632, -344},
    { -416, 648, -576},
    { -408, 496, -696},
    { -408, 440, -784},
    { -320, 328, -760},
    { -400, 424, -704},
    { -392, 488, -680},
    { -368, 568, -672},
    { -368, 648, -608},
    { -352, 600, -616},
    // 41 seconds
    { -384, 504, -632},
    { -352, 488, -592},
    { -320, 552, -776},
    { -336, 576, -784},
    { -376, 504, -696},
    { -232, 824, -280},
    { 56, 1080, 72},
    { -32, 784, 312},
    { -304, 488, 368},
    { -544, 136, 288},
    { -608, 208, 48},
    { -512, 280, -432},
    { -632, 512, -688},
    { -504, 776, -1144},
    { -440, 592, -1136},
    { -256, 912, -1416},
    { -216, 840, -1320},
    { -176, 520, -1248},
    { -24, 328, -1304},
    { -56, 232, -1160},
    { -64, 232, -1080},
    { -24, 56, -1008},
    { 0, 88, -992},
    { 24, -40, -1032},
    { 56, -40, -984},
    // 42 seconds
    { 104, -104, -1032},
    { 40, -200, -1024},
    { 168, -128, -1056},
    { 152, -80, -1056},
    { 136, -88, -1080},
    { 88, -104, -1048},
    { 120, -152, -984},
    { 128, -144, -1048},
    { 128, -112, -1032},
    { 112, -112, -1000},
    { 112, -112, -1016},
    { 128, -152, -1000},
    { 136, -128, -968},
    { 168, -168, -952},
    { 168, -168, -928},
    { 160, -144, -976},
    { 160, -192, -968},
    { 168, -176, -976},
    { 176, -168, -976},
    { 192, -176, -976},
    { 232, -224, -992},
    { 232, -240, -992},
    { 248, -248, -912},
    { 264, -248, -896},
    { 288, -184, -968},
    // 43 seconds
    { 288, -144, -984},
    { 296, -184, -960},
    { 304, -160, -968},
    { 296, -176, -968},
    { 296, -160, -960},
    { 288, -160, -944},
    { 288, -168, -944},
    { 280, -144, -944},
    { 288, -136, -944},
    { 280, -144, -960},
    { 296, -136, -968},
    { 288, -120, -952},
    { 296, -120, -944},
    { 288, -128, -960},
    { 288, -80, -944},
    { 288, -120, -952},
    { 312, -128, -976},
    { 304, -168, -976},
    { 304, -168, -976},
    { 304, -184, -1000},
    { 312, -200, -952},
    { 304, -184, -952},
    { 304, -176, -968},
    { 296, -216, -936},
    { 296, -224, -912},
    // 44 seconds
    { 296, -216, -920},
    { 288, -248, -928},
    { 272, -232, -928},
    { 288, -256, -920},
    { 272, -272, -904},
    { 296, -272, -912},
    { 280, -256, -896},
    { 288, -272, -912},
    { 272, -272, -920},
    { 264, -240, -952},
    { 248, -224, -928},
    { 232, -200, -968},
    { 224, -176, -952},
    { 216, -168, -968},
    { 200, -168, -960},
    { 208, -184, -984},
    { 200, -136, -1000},
    { 208, -88, -992},
    { 208, -104, -992},
    { 216, -120, -992},
    { 216, -96, -992},
    { 200, -64, -960},
    { 200, -40, -960},
    { 200, -56, -928},
    { 280, 48, -864},
    // 45 seconds
    { 264, 352, -864},
    { 224, 312, -560},
    { 232, 904, -336},
    { 80, 1112, -296},
    { 16, 1040, -136},
    { 8, 952, 8},
    { 16, 992, 24},
    { 16, 1072, 80},
    { 32, 1024, 24},
    { 56, 960, 32},
    { 32, 992, 40},
    { 32, 984, -48},
    { 32, 928, 8},
    { 0, 968, -16},
    { -40, 904, 16},
    { -88, 888, -16},
    { -72, 848, -88},
    { -40, 1032, -144},
    { -96, 936, -160},
    { -64, 872, -208},
    { -32, 888, -360},
    { -48, 832, -312},
    { -64, 832, -248},
    { -80, 888, -312},
    { -120, 824, -328},
    // 46 seconds
    { -128, 856, -344},
    { -144, 864, -360},
    { -96, 792, -384},
    { -80, 832, -416},
    { -120, 944, -400},
    { -120, 856, -384},
    { -144, 832, -392},
    { -104, 824, -448},
    { -144, 808, -376},
    { -136, 816, -424},
    { -128, 848, -440},
    { -152, 872, -368},
    { -136, 824, -432},
    { -128, 896, -464},
    { -144, 880, -448},
    { -144, 792, -400},
    { -120, 808, -464},
    { -144, 888, -480},
    { -152, 840, -408},
    { -136, 832, -392},
    { -152, 880, -432},
    { -168, 864, -336},
    { -136, 808, -416},
    { -168, 872, -408},
    { -184, 920, -352},
    // 47 seconds
    { -184, 984, -464},
    { -160, 784, -496},
    { -64, 808, -600},
    { -152, 872, -272},
    { -248, 840, -88},
    { -264, 848, -176},
    { -256, 840, -240},
    { -216, 888, -288},
    { -176, 888, -336},
    { -144, 880, -312},
    { -128, 864, -288},
    { -120, 864, -296},
    { -104, 912, -320},
    { -112, 896, -328},
    { -120, 888, -320},
    { -184, 808, -280},
    { -232, 856, -280},
    { -216, 944, -280},
    { -168, 1032, -272},
    { -120, 992, -304},
    { -104, 928, -320},
    { -48, 896, -320},
    { -24, 816, -320},
    { -88, 720, -280},
    { -200, 736, -304},
    // 48 seconds
    { -216, 864, -344},
    { -144, 1048, -376},
    { -88, 1008, -464},
    { -64, 840, -456},
    { -32, 784, -360},
    { 16, 776, -368},
    { -8, 752, -432},
    { -80, 688, -400},
    { -216, 712, -352},
    { -264, 880, -384},
    { -208, 1064, -392},
    { -192, 1064, -456},
    { -136, 896, -424},
    { -72, 792, -368},
    { 0, 744, -376},
    { 24, 744, -376},
    { -32, 712, -368},
    { -160, 744, -360},
    { -248, 920, -408},
    { -184, 1120, -448},
    { -192, 1048, -488},
    { -152, 880, -416},
    { -80, 768, -360},
    { -48, 776, -336},
    { 0, 816, -376},
    // 49 seconds
    { 32, 832, -384},
    { 48, 808, -464},
    { -16, 792, -504},
    { -104, 800, -472},
    { -128, 872, -512},
    { -192, 864, -472},
    { -224, 848, -424},
    { -224, 880, -408},
    { -216, 880, -368},
    { -192, 888, -352},
    { -144, 864, -376},
    { -128, 776, -368},
    { -120, 720, -360},
    { -120, 792, -376},
    { -96, 880, -392},
    { -88, 872, -376},
    { -96, 848, -376},
    { -136, 840, -336},
    { -192, 896, -280},
    { -248, 992, -280},
    { -224, 1136, -360},
    { -176, 1088, -408},
    { -152, 912, -360},
    { -104, 824, -304},
    { -56, 832, -344},
    // 50 seconds
    { -64, 800, -352},
    { -80, 792, -320},
    { -64, 856, -368},
    { -56, 856, -400},
    { -96, 832, -416},
    { -128, 808, -440},
    { -152, 776, -408},
    { -184, 784, -352},
    { -192, 864, -352},
    { -184, 872, -336},
    { -192, 872, -312},
    { -192, 872, -320},
    { -160, 880, -328},
    { -144, 872, -320},
    { -160, 856, -328},
    { -200, 880, -320},
    { -232, 920, -304},
    { -192, 1112, -368},
    { -144, 1024, -432},
    { -136, 880, -360},
    { -88, 792, -320},
    { -64, 856, -352},
    { -56, 864, -368},
    { -48, 816, -376},
    { -64, 800, -408},
    // 51 seconds
    { -80, 808, -432},
    { -104, 816, -440},
    { -136, 848, -456},
    { -144, 880, -464},
    { -160, 824, -440},
    { -176, 776, -424},
    { -192, 784, -392},
    { -208, 832, -384},
    { -192, 880, -392},
    { -184, 864, -408},
    { -184, 784, -384},
    { -200, 784, -392},
    { -184, 816, -384},
    { -200, 840, -384},
    { -216, 888, -400},
    { -200, 896, -408},
    { -200, 848, -368},
    { -224, 848, -352},
    { -232, 888, -328},
    { -208, 936, -336},
    { -176, 944, -344},
    { -152, 936, -352},
    { -104, 896, -392},
    { -80, 864, -416},
    { -56, 800, -424},
    // 52 seconds
    { -80, 800, -456},
    { -104, 800, -472},
    { -144, 808, -464},
    { -160, 840, -456},
    { -168, 840, -424},
    { -176, 832, -408},
    { -184, 792, -392},
    { -216, 792, -376},
    { -224, 840, -384},
    { -216, 824, -400},
    { -208, 760, -384},
    { -224, 760, -368},
    { -208, 840, -376},
    { -176, 848, -360},
    { -192, 824, -352},
    { -184, 896, -384},
    { -192, 912, -384},
    { -200, 904, -384},
    { -232, 912, -360},
    { -240, 1000, -384},
    { -240, 1048, -368},
    { -240, 1024, -392},
    { -160, 944, -408},
    { -128, 792, -344},
    { -120, 736, -312},
    // 53 seconds
    { -112, 832, -344},
    { -104, 848, -360},
    { -88, 824, -384},
    { -88, 744, -440},
    { -96, 672, -464},
    { -128, 696, -432},
    { -120, 816, -464},
    { -128, 808, -448},
    { -152, 784, -416},
    { -184, 880, -424},
    { -176, 912, -400},
    { -200, 904, -368},
    { -216, 928, -400},
    { -240, 904, -376},
    { -280, 896, -336},
    { -280, 984, -360},
    { -208, 1008, -384},
    { -160, 880, -336},
    { -144, 816, -328},
    { -96, 840, -368},
    { -96, 808, -368},
    { -80, 832, -392},
    { -56, 840, -432},
    { -64, 784, -440},
    { -80, 776, -440},
    // 54 seconds
    { -112, 792, -432},
    { -120, 816, -416},
    { -120, 840, -400},
    { -112, 888, -424},
    { -72, 888, -440},
    { -88, 816, -432},
    { -136, 840, -440},
    { -144, 928, -456},
    { -128, 912, -448},
    { -160, 832, -448},
    { -160, 824, -432},
    { -136, 832, -408},
    { -136, 816, -368},
    { -136, 824, -384},
    { -96, 800, -392},
    { -112, 736, -368},
    { -120, 832, -392},
    { -136, 888, -376},
    { -152, 912, -392},
    { -168, 912, -400},
    { -144, 920, -408},
    { -128, 880, -384},
    { -112, 888, -384},
    { -88, 872, -376},
    { -72, 856, -376},
    // 55 seconds
    { -56, 840, -368},
    { -56, 824, -368},
    { -64, 824, -368},
    { -88, 872, -384},
    { -72, 856, -384},
    { -88, 856, -400},
    { -80, 904, -440},
    { -32, 880, -448},
    { -48, 776, -416},
    { -104, 816, -416},
    { -136, 920, -408},
    { -144, 896, -344},
    { -200, 904, -328},
    { -240, 952, -352},
    { -208, 968, -376},
    { -192, 920, -368},
    { -152, 888, -384},
    { -112, 848, -392},
    { -72, 760, -392},
    { -80, 672, -360},
    { -112, 744, -400},
    { -104, 824, -416},
    { -80, 864, -432},
    { -104, 800, -456},
    { -136, 800, -464},
    // 56 seconds
    { -152, 872, -480},
    { -128, 872, -456},
    { -152, 872, -440},
    { -168, 856, -424},
    { -184, 848, -416},
    { -176, 896, -432},
    { -168, 840, -432},
    { -176, 816, -408},
    { -184, 856, -400},
    { -176, 864, -384},
    { -160, 848, -400},
    { -152, 864, -416},
    { -128, 816, -448},
    { -168, 736, -448},
    { -200, 816, -480},
    { -216, 880, -472},
    { -200, 864, -456},
    { -216, 800, -424},
    { -232, 776, -424},
    { -232, 784, -400},
    { -240, 760, -376},
    { -232, 776, -360},
    { -248, 784, -344},
    { -248, 832, -360},
    { -248, 896, -384},
    // 57 seconds
    { -232, 856, -400},
    { -272, 800, -416},
    { -280, 832, -424},
    { -288, 872, -392},
    { -264, 952, -392},
    { -232, 944, -400},
    { -208, 872, -360},
    { -192, 840, -360},
    { -184, 840, -368},
    { -176, 832, -360},
    { -176, 800, -336},
    { -200, 840, -336},
    { -184, 856, -328},
    { -160, 936, -344},
    { -128, 888, -360},
    { -112, 848, -384},
    { -104, 824, -400},
    { -96, 856, -424},
    { -88, 872, -416},
    { -72, 840, -416},
    { -80, 816, -392},
    { -88, 776, -360},
    { -128, 824, -360},
    { -120, 944, -344},
    { -80, 1024, -392},
    // 58 seconds
    { -96, 920, -416},
    { -40, 816, -432},
    { -56, 752, -384},
    { -56, 848, -352},
    { -64, 896, -320},
    { -56, 904, -320},
    { -48, 848, -312},
    { -32, 896, -360},
    { 0, 920, -392},
    { 16, 872, -416},
    { 16, 848, -432},
    { 0, 840, -416},
    { -8, 872, -376},
    { -40, 840, -320},
    { -64, 872, -320},
    { -104, 888, -272},
    { -128, 872, -240},
    { -160, 872, -256},
    { -192, 904, -288},
    { -176, 936, -304},
    { -136, 952, -328},
    { -112, 1000, -312},
    { -88, 928, -328},
    { -96, 872, -304},
    { -120, 856, -264},
    // 59 seconds
    { -144, 856, -232},
    { -176, 888, -192},
    { -184, 880, -200},
    { -176, 888, -184},
    { -184, 872, -192},
    { -192, 896, -216},
    { -208, 928, -240},
    { -224, 912, -240},
    { -232, 968, -288},
    { -224, 976, -264},
    { -216, 920, -264},
    { -224, 864, -240},
    { -232, 840, -184},
    { -264, 856, -144},
    { -248, 912, -152},
    { -240, 920, -160},
    { -240, 920, -184},
    { -216, 912, -216},
    { -216, 888, -208},
    { -224, 896, -256},
    { -224, 888, -232},
    { -240, 856, -200},
    { -232, 872, -248},
    { -224, 800, -144},
    { -264, 936, -40},
    // 60 seconds
    // elapsed: 1 minutes
    { -296, 880, 40},
    { -280, 880, 144},
    { -288, 920, 192},
    { -248, 848, 296},
    { -256, 736, 496},
    { -208, 784, 536},
    { -208, 688, 600},
    { -264, 664, 736},
    { -216, 656, 760},
    { -216, 744, 752},
    { -232, 744, 736},
    { -296, 600, 872},
    { -272, 384, 776},
    { -192, 552, 688},
    { -224, 744, 760},
    { -240, 752, 808},
    { -256, 720, 744},
    { -240, 712, 656},
    { -288, 864, 488},
    { -256, 728, 360},
    { -336, 696, 240},
    { -296, 896, -104},
    { -288, 784, -224},
    { -344, 752, -392},
    { -312, 720, -416},
    // 61 seconds
    { -320, 800, -544},
    { -312, 624, -528},
    { -352, 664, -520},
    { -344, 680, -528},
    { -312, 544, -624},
    { -304, 432, -512},
    { -328, 872, -624},
    { -376, 1392, -616},
    { -552, 1464, -472},
    { -664, 1504, -200},
    { -688, 1424, 192},
    { -760, 1192, 448},
    { -792, 816, 464},
    { -832, 736, 456},
    { -752, 728, 216},
    { -616, 496, 472},
    { -432, 720, 400},
    { -320, 496, 64},
    { -288, 512, 120},
    { -208, 552, 136},
    { -288, 632, 104},
    { -304, 408, -152},
    { -312, 512, -200},
    { -336, 688, -408},
    { -368, 776, -536},
    // 62 seconds
    { -328, 688, -560},
    { -392, 624, -560},
    { -400, 696, -680},
    { -432, 720, -584},
    { -464, 680, -536},
    { -488, 624, -592},
    { -512, 672, -600},
    { -512, 584, -552},
    { -512, 696, -568},
    { -480, 672, -552},
    { -408, 608, -624},
    { -408, 648, -664},
    { -344, 608, -696},
    { -320, 432, -656},
    { -320, 688, -440},
    { -112, 800, 0},
    { 464, 1016, -256},
    { 424, 712, 40},
    { -128, 80, 424},
    { -304, -32, 336},
    { -400, 56, -136},
    { -648, -48, -576},
    { -848, 312, -1008},
    { -616, 1304, -1600},
    { -568, 1448, -1992},
    // 63 seconds
    { -584, 840, -1680},
    { -312, 576, -1336},
    { -96, 440, -1112},
    { -56, 344, -984},
    { 16, 320, -1000},
    { 48, 296, -736},
    { 152, 528, -928},
    { 96, 408, -968},
    { 88, 344, -904},
    { 104, 424, -880},
    { 112, 352, -888},
    { 136, 440, -944},
    { 104, 624, -896},
    { -16, 696, -968},
    { -160, 688, -912},
    { -336, 896, -856},
    { -432, 872, -840},
    { -400, 768, -816},
    { -512, 904, -776},
    { -520, 736, -816},
    { -576, 528, -752},
    { -552, 544, -728},
    { -544, 416, -752},
    { -384, 280, -792},
    { -272, 24, -496},
    // 64 seconds
    { 56, 112, -760},
    { 280, 152, -808},
    { 440, 64, -632},
    { 384, 592, -928},
    { 104, 488, -864},
    { 8, 240, -808},
    { -8, 496, -936},
    { -96, 536, -856},
    { -160, 312, -856},
    { -152, 392, -912},
    { -184, 416, -832},
    { -144, 320, -848},
    { -72, 208, -920},
    { 16, 240, -896},
    { 120, 320, -944},
    { 176, 248, -952},
    { 160, 280, -888},
    { 168, 392, -872},
    { 184, 288, -872},
    { 200, 288, -904},
    { 208, 288, -936},
    { 192, 256, -936},
    { 160, 312, -952},
    { 176, 304, -936},
    { 312, 288, -984},
    // 65 seconds
    { 344, 424, -936},
    { 344, 288, -744},
    { 504, 448, -488},
    { 616, 976, -576},
    { 648, 720, -592},
    { 184, 312, -448},
    { -176, 104, -720},
    { -184, -16, -824},
    { -408, 40, -712},
    { -168, 336, -1176},
    { -176, 552, -824},
    { -256, 904, -808},
    { -272, 1080, -904},
    { -328, 1160, -632},
    { -336, 1056, -512},
    { -360, 1040, -488},
    { -400, 1008, -392},
    { -336, 976, -376},
    { -248, 944, -472},
    { -192, 888, -448},
    { -136, 832, -464},
    { -104, 808, -504},
    { -72, 816, -480},
    { -56, 816, -456},
    { -56, 816, -456},
    // 66 seconds
    { -72, 816, -440},
    { -104, 808, -416},
    { -128, 840, -384},
    { -144, 864, -376},
    { -144, 896, -376},
    { -144, 896, -368},
    { -152, 920, -360},
    { -144, 888, -360},
    { -112, 904, -368},
    { -88, 896, -392},
    { -72, 864, -376},
    { -56, 832, -360},
    { -40, 800, -392},
    { -48, 800, -368},
    { -40, 888, -440},
    { -96, 888, -376},
    { -200, 912, -368},
    { -272, 1136, -448},
    { -272, 1104, -544},
    { -272, 984, -448},
    { -128, 752, -528},
    { -8, 560, -600},
    { 48, 312, -664},
    { 64, 240, -744},
    { 104, 72, -816},
    // 67 seconds
    { 104, 32, -896},
    { 112, 0, -960},
    { 120, -40, -992},
    { 112, -112, -1024},
    { 120, -120, -1040},
    { 136, -104, -1024},
    { 136, -112, -1016},
    { 128, -96, -1008},
    { 152, -88, -1008},
    { 176, -56, -1008},
    { 176, -72, -1008},
    { 192, -72, -1016},
    { 200, -56, -1024},
    { 192, -24, -1040},
    { 192, -32, -1016},
    { 192, -32, -1008},
    { 184, -24, -1000},
    { 176, -16, -1008},
    { 168, -16, -968},
    { 168, -8, -976},
    { 168, 8, -960},
    { 184, 16, -984},
    { 192, -8, -992},
    { 200, 0, -1016},
    { 200, -8, -992},
    // 68 seconds
    { 216, -24, -976},
    { 224, -48, -952},
    { 240, -64, -944},
    { 256, -64, -944},
    { 264, -56, -952},
    { 272, -32, -992},
    { 264, -48, -984},
    { 272, -48, -984},
    { 264, -64, -960},
    { 280, -64, -960},
    { 280, -64, -952},
    { 288, -48, -960},
    { 288, -48, -960},
    { 280, -32, -968},
    { 280, -40, -968},
    { 288, -40, -968},
    { 288, -56, -960},
    { 288, -56, -952},
    { 296, -48, -944},
    { 296, -40, -960},
    { 288, -48, -936},
    { 296, -48, -936},
    { 296, -32, -952},
    { 296, -32, -944},
    { 312, -40, -952},
    // 69 seconds
    { 328, -32, -928},
    { 344, 64, -976},
    { 320, 232, -952},
    { 208, 568, -760},
    { 128, 856, -704},
    { 80, 712, -584},
    { 16, 744, -392},
    { -32, 792, -344},
    { -32, 840, -360},
    { -32, 856, -368},
    { 8, 896, -432},
    { 8, 880, -432},
    { -8, 880, -424},
    { 0, 912, -464},
    { -32, 928, -432},
    { -64, 920, -392},
    { -72, 896, -376},
    { -56, 840, -344},
    { -32, 776, -360},
    { 0, 664, -336},
    { 56, 712, -376},
    { 128, 936, -608},
    { 112, 1024, -704},
    { 160, 1032, -464},
    { 128, 1016, -336},
    // 70 seconds
    { 88, 1000, -152},
    { 56, 1040, 168},
    { 40, 960, 560},
    { 48, 776, 624},
    { 0, 720, 696},
    { -16, 600, 904},
    { -40, 408, 880},
    { -168, 400, 976},
    { -224, 352, 928},
    { -240, 328, 824},
    { -280, 312, 856},
    { -256, 272, 832},
    { -320, 272, 656},
    { -312, 408, 648},
    { -312, 488, 512},
    { -352, 552, 760},
    { -312, 472, 856},
    { -336, 360, 816},
    { -296, 248, 760},
    { -328, 440, 816},
    { -408, 512, 896},
    { -456, 288, 864},
    { -440, 784, 728},
    { -520, 912, 672},
    { -440, 576, 616},
    // 71 seconds
    { -384, 480, 616},
    { -472, 584, 600},
    { -520, 688, 584},
    { -568, 648, 704},
    { -576, 520, 592},
    { -568, 472, 536},
    { -496, 592, 744},
    { -632, 680, 800},
    { -472, 664, 568},
    { -64, 592, 424},
    { 40, 712, 488},
    { -192, 672, 696},
    { -240, 712, 664},
    { -208, 792, 736},
    { -216, 688, 568},
    { -336, 880, 488},
    { -440, 816, 632},
    { -472, 648, 624},
    { -464, 688, 616},
    { -424, 408, 896},
    { -528, 272, 936},
    { -688, 272, 704},
    { -656, 336, 776},
    { -560, 208, 784},
    { -472, 200, 528},
    // 72 seconds
    { -384, 8, 1016},
    { -304, -64, 1088},
    { -272, -16, 920},
    { -328, -160, 944},
    { -240, -600, 920},
    { -240, -472, 1192},
    { -824, 56, 1552},
    { -1704, 1248, 1680},
    { -1896, 2152, 1168},
    { -1248, 1768, 944},
    { -464, 1200, 328},
    { -320, 144, -8},
    { -384, -72, -448},
    { -144, 96, -512},
    { -64, 56, -272},
    { 72, 224, -320},
    { -56, 496, -488},
    { -224, 352, -288},
    { -312, 400, -360},
    { -408, 432, -400},
    { -416, 408, -544},
    { -488, 576, -344},
    { -544, 672, -480},
    { -536, 768, -576},
    { -472, 608, -584},
    // 73 seconds
    { -416, 576, -264},
    { -272, 616, -352},
    { -320, 632, -304},
    { -296, 792, -152},
    { 88, 648, -72},
    { -96, 992, 8},
    { -104, 464, 104},
    { -488, 208, 64},
    { -648, 192, 104},
    { -928, 80, 272},
    { -816, 368, -352},
    { -1040, 192, 448},
    { -768, 888, -8},
    { -592, 1128, -360},
    { -432, 1504, -376},
    { -304, 2184, -528},
    { -272, 2000, -760},
    { -192, 1336, -304},
    { -152, 1240, -608},
    { -136, 1040, -584},
    { -168, 992, -288},
    { -152, 704, 48},
    { -208, 920, -24},
    { -288, 920, -280},
    { -192, 880, -232},
    // 74 seconds
    { -96, 736, -96},
    { -72, 792, -272},
    { -128, 1208, -160},
    { -344, 800, -96},
    { -200, 896, -312},
    { -184, 912, -280},
    { -112, 680, -288},
    { -128, 992, -360},
    { -192, 1032, -200},
    { -216, 920, -312},
    { -232, 744, -248},
    { -256, 944, -224},
    { -200, 856, -448},
    { -176, 944, -304},
    { -168, 904, -288},
    { -176, 888, -384},
    { -160, 704, -416},
    { -192, 880, -424},
    { -256, 880, -512},
    { -216, 536, -376},
    { -224, 856, -528},
    { -264, 792, -472},
    { -232, 736, -368},
    { -256, 888, -568},
    { -232, 704, -544},
    // 75 seconds
    { -248, 728, -496},
    { -264, 736, -504},
    { -264, 720, -544},
    { -272, 808, -544},
    { -296, 800, -496},
    { -312, 744, -496},
    { -288, 728, -496},
    { -208, 672, -472},
    { -168, 656, -488},
    { -160, 640, -440},
    { -152, 672, -552},
    { -168, 768, -440},
    { -96, 792, -456},
    { -80, 904, -176},
    { -8, 984, -224},
    { 96, 1104, -216},
    { 80, 1072, -96},
    { 96, 984, -120},
    { 208, 952, -112},
    { 248, 952, -136},
    { 264, 936, -200},
    { 208, 1248, -376},
    { 224, 1096, -280},
    { 224, 912, -248},
    { 272, 816, -272},
    // 76 seconds
    { 280, 784, -264},
    { 560, 920, -264},
    { 832, 1232, -32},
    { 600, 1056, -64},
    { 144, 840, 0},
    { -216, 368, -48},
    { -408, 336, -264},
    { -464, 160, -360},
    { -344, 560, -152},
    { 328, 1120, 48},
    { 672, 1008, -184},
    { 896, 792, -88},
    { 1192, 784, 48},
    { 1136, 840, 168},
    { 1032, 648, 96},
    { 1000, 512, 96},
    { 896, 432, 72},
    { 832, 392, 112},
    { 688, 496, 216},
    { 616, 584, 320},
    { 568, 416, 312},
    { 560, 600, 368},
    { 600, 640, 456},
    { 616, 632, 272},
    { 544, 512, 352},
    // 77 seconds
    { 552, 672, 288},
    { 600, 656, 304},
    { 560, 672, 336},
    { 568, 720, 312},
    { 552, 768, 280},
    { 528, 808, 280},
    { 520, 680, 304},
    { 544, 744, 192},
    { 520, 792, 224},
    { 512, 680, 200},
    { 512, 640, 160},
    { 496, 664, 176},
    { 496, 768, 152},
    { 512, 848, 144},
    { 496, 760, 152},
    { 520, 768, 64},
    { 528, 768, 56},
    { 528, 704, 40},
    { 544, 672, 56},
    { 528, 736, 32},
    { 512, 640, 40},
    { 528, 848, 120},
    { 536, 912, 88},
    { 512, 976, 32},
    { 480, 872, -80},
    // 78 seconds
    { 456, 744, -112},
    { 456, 696, -216},
    { 472, 736, -272},
    { 520, 712, -320},
    { 488, 640, -272},
    { 472, 648, -328},
    { 456, 608, -248},
    { 480, 704, -272},
    { 480, 824, -272},
    { 464, 688, -240},
    { 456, 808, -240},
    { 440, 728, -192},
    { 448, 760, -176},
    { 448, 816, -176},
    { 448, 856, -144},
    { 448, 848, -96},
    { 440, 800, -136},
    { 480, 736, -192},
    { 464, 768, -40},
    { 488, 784, -88},
    { 512, 736, -200},
    { 464, 768, -136},
    { 496, 704, -88},
    { 448, 696, -56},
    { 448, 832, -56},
    // 79 seconds
    { 448, 784, -48},
    { 464, 752, -40},
    { 488, 736, -56},
    { 504, 696, -40},
    { 496, 800, 0},
    { 488, 912, 96},
    { 512, 792, 80},
    { 520, 760, 16},
    { 528, 680, 72},
    { 544, 688, 48},
    { 552, 728, 112},
    { 536, 808, 120},
    { 528, 592, 320},
    { 536, 520, 320},
    { 592, 752, 208},
    { 600, 680, 192},
    { 608, 656, 232},
    { 672, 792, 216},
    { 648, 680, 168},
    { 624, 672, 216},
    { 560, 624, 320},
    { 536, 664, 248},
    { 576, 568, 208},
    { 576, 608, 248},
    { 608, 616, 240},
    // 80 seconds
    { 640, 568, 216},
    { 648, 680, 232},
    { 656, 648, 344},
    { 648, 664, 312},
    { 632, 616, 264},
    { 584, 704, 352},
    { 584, 696, 320},
    { 592, 664, 256},
    { 592, 688, 304},
    { 584, 672, 256},
    { 616, 568, 288},
    { 600, 648, 288},
    { 640, 688, 272},
    { 672, 456, 160},
    { 704, 512, 280},
    { 648, 696, 360},
    { 600, 736, 336},
    { 592, 592, 224},
    { 616, 664, 224},
    { 608, 768, 232},
    { 600, 688, 192},
    { 616, 632, 160},
    { 640, 600, 80},
    { 632, 592, 64},
    { 640, 704, 16},
    // 81 seconds
    { 656, 872, -56},
    { 624, 968, -72},
    { 560, 928, -144},
    { 464, 736, 56},
    { 424, 712, -104},
    { 416, 608, -192},
    { 488, 520, -312},
    { 536, 440, -296},
    { 544, 632, -272},
    { 528, 600, -184},
    { 536, 712, -248},
    { 496, 704, -160},
    { 504, 648, -48},
    { 488, 840, -64},
    { 496, 704, 16},
    { 504, 856, 88},
    { 512, 864, 88},
    { 520, 840, 104},
    { 544, 880, 160},
    { 544, 816, 88},
    { 536, 704, 80},
    { 544, 752, 128},
    { 560, 760, 112},
    { 560, 872, 104},
    { 544, 984, 96},
    // 82 seconds
    { 504, 880, 8},
    { 464, 736, -168},
    { 440, 648, -176},
    { 456, 568, -128},
    { 472, 632, -216},
    { 760, 336, -360},
    { 536, 672, -200},
    { 520, 504, -120},
    { 504, 688, 40},
    { 480, 832, 40},
    { 488, 776, 48},
    { 480, 824, -8},
    { 520, 848, 0},
    { 544, 808, 64},
    { 560, 800, 128},
    { 560, 736, 168},
    { 576, 704, 184},
    { 584, 704, 224},
    { 584, 720, 184},
    { 592, 752, 168},
    { 584, 792, 128},
    { 576, 856, 128},
    { 544, 760, 120},
    { 512, 832, 56},
    { 496, 784, 104},
    // 83 seconds
    { 520, 616, 120},
    { 552, 576, 80},
    { 592, 440, 88},
    { 560, 608, 96},
    { 592, 504, -80},
    { 608, 776, 16},
    { 568, 712, 192},
    { 568, 712, 256},
    { 584, 640, 384},
    { 600, 840, 288},
    { 664, 776, 312},
    { 720, 832, 240},
    { 768, 640, 216},
    { 656, 584, 328},
    { 568, 656, 320},
    { 736, -120, 96},
    { 648, 848, 128},
    { 592, 800, 360},
    { 592, 696, 40},
    { 632, 592, 72},
    { 696, 512, 40},
    { 640, 600, 48},
    { 640, 656, 64},
    { 632, 752, 8},
    { 648, 648, 0},
    // 84 seconds
    { 680, 584, -16},
    { 680, 696, -8},
    { 664, 656, -64},
    { 640, 632, -40},
    { 648, 648, -56},
    { 672, 640, -24},
    { 672, 632, -80},
    { 672, 656, -96},
    { 648, 616, -80},
    { 632, 576, -40},
    { 656, 608, -96},
    { 672, 648, -104},
    { 600, 584, 16},
    { 640, 384, 224},
    { 712, 800, 0},
    { 672, 896, -80},
    { 608, 800, 80},
    { 520, 584, 288},
    { 552, 488, 288},
    { 624, 520, 184},
    { 744, 616, 240},
    { 672, 712, 480},
    { 664, 640, 424},
    { 624, 592, 424},
    { 608, 696, 432},
    // 85 seconds
    { 616, 712, 344},
    { 648, 320, 200},
    { 656, 584, 360},
    { 664, 576, 360},
    { 664, 640, 272},
    { 632, 640, 224},
    { 632, 904, 200},
    { 624, 816, -32},
    { 624, 816, -208},
    { 552, 600, -248},
    { 528, 336, -344},
    { 560, 352, -480},
    { 480, 464, -664},
    { 424, 400, -800},
    { 432, 376, -824},
    { 408, 408, -856},
    { 368, 384, -800},
    { 392, 296, -776},
    { 408, 272, -856},
    { 376, 248, -880},
    { 368, 224, -848},
    { 368, 240, -800},
    { 368, 240, -824},
    { 368, 192, -864},
    { 376, 176, -888},
    // 86 seconds
    { 376, 144, -896},
    { 376, 160, -896},
    { 376, 160, -904},
    { 368, 144, -864},
    { 376, 168, -872},
    { 376, 160, -872},
    { 368, 136, -856},
    { 328, 112, -728},
    { 312, 232, -696},
    { 360, 520, -616},
    { 424, 648, -160},
    { 408, 768, 136},
    { 512, 1080, 264},
    { 688, 768, 448},
    { 720, 536, -360},
    { 656, 984, 416},
    { 504, 960, 408},
    { 480, 288, 24},
    { 488, 856, 176},
    { 576, 768, 272},
    { 584, 664, 176},
    { 608, 648, 104},
    { 584, 592, 144},
    { 608, 600, 128},
    { 600, 600, 80},
    // 87 seconds
    { 592, 824, 176},
    { 656, 776, 232},
    { 656, 824, 256},
    { 592, 728, 200},
    { 600, 568, 104},
    { 664, 600, 80},
    { 696, 568, 64},
    { 688, 656, 64},
    { 664, 640, 80},
    { 656, 584, 48},
    { 672, 664, 32},
    { 656, 592, 0},
    { 688, 616, -24},
    { 680, 664, 0},
    { 672, 616, 8},
    { 672, 624, -32},
    { 656, 616, 0},
    { 672, 640, -40},
    { 672, 648, -40},
    { 672, 592, -48},
    { 688, 656, -64},
    { 672, 656, -32},
    { 664, 608, -24},
    { 656, 624, -56},
    { 672, 608, -72},
    // 88 seconds
    { 664, 664, -56},
    { 672, 616, -56},
    { 672, 624, -40},
    { 688, 640, -72},
    { 688, 592, -40},
    { 696, 624, -48},
    { 688, 600, -72},
    { 688, 584, -72},
    { 688, 640, -72},
    { 624, 488, 0},
    { 696, 560, 208},
    { 680, 656, 120},
    { 608, 848, -56},
    { 536, 848, 88},
    { 576, 672, 168},
    { 584, 440, 168},
    { 568, 576, 320},
    { 696, 712, 400},
    { 704, 624, 456},
    { 640, 784, 416},
    { 568, 776, 384},
    { 632, 616, 304},
    { 584, 576, 376},
    { 576, 600, 240},
    { 672, 384, 240},
    // 89 seconds
    { 640, 616, 256},
    { 624, 544, 240},
    { 616, 688, 296},
    { 624, 680, 192},
    { 640, 672, 272},
    { 576, 704, 368},
    { 504, 552, 272},
    { 696, 504, 336},
    { 592, 544, 408},
    { 600, 504, 360},
    { 584, 512, 520},
    { 568, 528, 552},
    { 568, 512, 640},
    { 584, 480, 560},
    { 592, 456, 560},
    { 600, 440, 560},
    { 616, 488, 528},
    { 616, 488, 560},
    { 616, 456, 544},
    { 608, 464, 560},
    { 600, 480, 568},
    { 592, 464, 520},
    { 576, 480, 552},
    { 584, 448, 648},
    { 608, 544, 584},
    // 90 seconds
    { 624, 536, 624},
    { 592, 472, 656},
    { 568, 368, 464},
    { 584, 384, 464},
    { 624, 448, 520},
    { 744, 416, -72},
    { 688, 696, 432},
    { 664, 712, 672},
    { 552, 616, 592},
    { 488, 592, 432},
    { 608, 224, 160},
    { 640, 568, 464},
    { 640, 800, 440},
    { 656, 544, 288},
    { 632, 648, 384},
    { 608, 576, 304},
    { 656, 488, 248},
    { 624, 680, 280},
    { 656, 608, 256},
    { 632, 616, 216},
    { 648, 664, 168},
    { 640, 640, 176},
    { 648, 584, 160},
    { 672, 632, 168},
    { 664, 624, 136},
    // 91 seconds
    { 648, 632, 168},
    { 648, 632, 136},
    { 640, 632, 120},
    { 648, 656, 128},
    { 656, 624, 112},
    { 640, 640, 96},
    { 656, 640, 96},
    { 648, 656, 120},
    { 656, 624, 96},
    { 656, 632, 72},
    { 624, 672, 80},
    { 632, 608, 120},
    { 664, 696, 64},
    { 656, 632, 48},
    { 640, 624, 80},
    { 640, 632, 80},
    { 648, 696, 32},
    { 648, 640, 96},
    { 656, 640, 56},
    { 656, 656, 40},
    { 656, 616, 64},
    { 648, 648, 56},
    { 656, 664, 56},
    { 656, 640, 48},
    { 656, 632, 72},
    // 92 seconds
    { 656, 640, 72},
    { 656, 648, 32},
    { 648, 616, 48},
    { 664, 640, 24},
    { 656, 640, 40},
    { 664, 640, 40},
    { 608, 552, 128},
    { 632, 712, 328},
    { 776, 680, -208},
    { 616, 1096, 8},
    { 432, 600, 320},
    { 400, 624, 312},
    { 504, 400, 312},
    { 560, 512, 368},
    { 640, 824, 320},
    { 624, 656, 448},
    { 648, 496, 424},
    { 560, 760, 352},
    { 560, 632, 544},
    { 496, 656, 480},
    { 632, 616, 464},
    { 560, 704, 320},
    { 624, 472, 296},
    { 616, 616, 304},
    { 592, 680, 224},
    // 93 seconds
    { 640, 624, 176},
    { 592, 688, 240},
    { 616, 704, 184},
    { 624, 688, 120},
    { 640, 624, 96},
    { 656, 600, 80},
    { 648, 648, 80},
    { 648, 656, 80},
    { 632, 640, 64},
    { 648, 664, 48},
    { 664, 672, 32},
    { 656, 624, 40},
    { 648, 680, 72},
    { 632, 664, 40},
    { 640, 632, 24},
    { 656, 656, 16},
    { 648, 648, 48},
    { 640, 688, 56},
    { 640, 656, 32},
    { 648, 648, 16},
    { 632, 656, 32},
    { 648, 632, 24},
    { 656, 632, 24},
    { 664, 680, 8},
    { 640, 656, 16},
    // 94 seconds
    { 640, 672, 24},
    { 640, 640, 8},
    { 656, 664, 16},
    { 648, 688, 16},
    { 648, 680, 0},
    { 640, 672, -8},
    { 664, 680, -16},
    { 664, 640, -8},
    { 656, 624, -16},
    { 648, 608, -48},
    { 664, 616, -40},
    { 648, 680, -32},
    { 648, 624, -40},
    { 656, 648, -48},
    { 640, 672, -72},
    { 648, 800, -136},
    { 736, 912, -248},
    { 736, 656, -232},
    { 768, 456, -232},
    { 760, 376, -512},
    { 664, 336, -656},
    { 568, 304, -744},
    { 456, 200, -712},
    { 448, 240, -792},
    { 408, 160, -744},
    // 95 seconds
    { 432, 80, -776},
    { 456, 136, -824},
    { 456, 72, -848},
    { 448, 72, -792},
    { 448, 80, -848},
    { 448, 88, -848},
    { 448, 104, -872},
    { 432, 104, -888},
    { 424, 88, -856},
    { 408, 96, -864},
    { 416, 104, -856},
    { 440, 128, -888},
    { 440, 120, -904},
    { 432, 80, -864},
    { 432, 104, -856},
    { 424, 104, -824},
    { 408, 120, -768},
    { 376, 160, -728},
    { 344, 288, -624},
    { 328, 232, -280},
    { 416, 920, 48},
    { 440, 1128, 208},
    { 552, 776, 336},
    { 664, 704, 272},
    { 688, 944, 152},
    // 96 seconds
    { 704, 912, 304},
    { 608, 896, 232},
    { 552, 600, 400},
    { 528, 432, 288},
    { 512, 856, 384},
    { 624, 568, 456},
    { 600, 664, 280},
    { 560, 616, 312},
    { 640, 600, 192},
    { 632, 768, 384},
    { 568, 592, 296},
    { 632, 584, 168},
    { 616, 632, 288},
    { 656, 640, 360},
    { 584, 560, 400},
    { 544, 584, 512},
    { 576, 568, 392},
    { 560, 600, 416},
    { 528, 648, 448},
    { 560, 536, 472},
    { 576, 496, 560},
    { 576, 504, 536},
    { 576, 464, 544},
    { 592, 488, 560},
    { 592, 504, 536},
    // 97 seconds
    { 608, 480, 520},
    { 616, 464, 552},
    { 600, 552, 576},
    { 608, 400, 552},
    { 584, 472, 576},
    { 600, 488, 592},
    { 624, 600, 600},
    { 640, 512, 616},
    { 600, 440, 592},
    { 600, 312, 592},
    { 592, 312, 488},
    { 600, 376, 424},
    { 640, 752, 208},
    { 752, 808, 240},
    { 704, 440, 456},
    { 656, 472, 608},
    { 584, 448, 472},
    { 576, 480, 368},
    { 616, 704, 424},
    { 536, 744, 496},
    { 608, 512, 400},
    { 640, 560, 328},
    { 624, 632, 312},
    { 664, 504, 232},
    { 656, 576, 240},
    // 98 seconds
    { 664, 648, 248},
    { 648, 608, 208},
    { 664, 592, 168},
    { 672, 656, 184},
    { 656, 600, 152},
    { 656, 592, 144},
    { 664, 576, 120},
    { 664, 592, 136},
    { 664, 688, 136},
    { 648, 640, 104},
    { 640, 616, 120},
    { 656, 608, 96},
    { 664, 656, 96},
    { 664, 680, 104},
    { 656, 656, 104},
    { 656, 632, 88},
    { 648, 664, 112},
    { 648, 608, 104},
    { 672, 648, 72},
    { 656, 640, 96},
    { 648, 624, 104},
    { 648, 632, 88},
    { 648, 640, 88},
    { 648, 696, 112},
    { 664, 632, 112},
    // 99 seconds
    { 648, 624, 72},
    { 656, 632, 96},
    { 656, 632, 96},
    { 664, 656, 80},
    { 656, 632, 96},
    { 664, 648, 96},
    { 664, 624, 96},
    { 656, 632, 88},
    { 648, 640, 80},
    { 648, 624, 96},
    { 648, 608, 112},
    { 672, 640, 80},
    { 688, 624, 64},
    { 680, 600, 64},
    { 576, 584, 344},
    { 728, 568, 128},
    { 752, 968, -192},
    { 496, 976, 184},
    { 448, 584, 320},
    { 472, 528, 240},
    { 512, 416, 320},
    { 568, 416, 448},
    { 648, 776, 368},
    { 640, 624, 432},
    { 584, 744, 408},
    // 100 seconds
    { 576, 744, 488},
    { 528, 576, 384},
    { 496, 520, 352},
    { 600, 760, 392},
    { 568, 544, 224},
    { 656, 640, 248},
    { 632, 696, 264},
    { 584, 616, 240},
    { 640, 632, 184},
    { 632, 688, 184},
    { 640, 648, 112},
    { 648, 632, 104},
    { 632, 632, 144},
    { 664, 656, 120},
    { 648, 600, 112},
    { 648, 648, 96},
    { 640, 704, 88},
    { 640, 624, 72},
    { 656, 640, 72},
    { 664, 696, 96},
    { 640, 648, 64},
    { 640, 616, 72},
    { 648, 704, 72},
    { 632, 664, 72},
    { 632, 632, 56},
    // 101 seconds
    { 640, 680, 64},
    { 656, 672, 72},
    { 640, 624, 56},
    { 648, 680, 40},
    { 648, 640, 40},
    { 640, 648, 48},
    { 640, 696, 56},
    { 640, 648, 40},
    { 648, 632, 40},
    { 640, 672, 48},
    { 632, 672, 40},
    { 640, 672, 24},
    { 640, 672, 48},
    { 640, 664, 32},
    { 640, 632, 32},
    { 640, 656, 40},
    { 648, 680, 16},
    { 648, 640, 32},
    { 640, 648, 24},
    { 648, 648, 8},
    { 648, 648, 32},
    { 656, 648, 16},
    { 648, 632, 40},
    { 648, 632, 40},
    { 640, 632, 48},
    // 102 seconds
    { 648, 672, 24},
    { 648, 656, 40},
    { 648, 640, 40},
    { 648, 632, 56},
    { 672, 680, 40},
    { 584, 608, 120},
    { 640, 712, 176},
    { 688, 488, -104},
    { 648, 952, -64},
    { 472, 824, 192},
    { 472, 680, 256},
    { 496, 640, 280},
    { 552, 536, 304},
    { 584, 624, 320},
    { 608, 712, 296},
    { 624, 640, 344},
    { 600, 608, 352},
    { 576, 712, 248},
    { 568, 720, 424},
    { 528, 680, 456},
    { 536, 632, 432},
    { 600, 640, 352},
    { 584, 720, 96},
    { 632, 896, 368},
    { 560, 576, 200},
    // 103 seconds
    { 608, 672, 120},
    { 576, 696, 176},
    { 624, 672, 144},
    { 632, 696, 112},
    { 616, 680, 96},
    { 616, 640, 96},
    { 624, 616, 48},
    { 616, 712, 64},
    { 616, 664, 104},
    { 640, 648, 16},
    { 640, 680, 16},
    { 624, 672, 40},
    { 624, 680, 32},
    { 616, 664, 48},
    { 632, 680, 32},
    { 632, 680, 48},
    { 624, 664, 32},
    { 632, 680, 16},
    { 632, 672, 24},
    { 632, 688, 32},
    { 632, 664, 8},
    { 624, 664, 8},
    { 632, 656, 8},
    { 632, 680, 16},
    { 632, 688, 8},
    // 104 seconds
    { 632, 672, -8},
    { 624, 672, 0},
    { 640, 672, 0},
    { 624, 672, 0},
    { 624, 656, 8},
    { 632, 696, 0},
    { 632, 664, 0},
    { 640, 656, -16},
    { 640, 664, 8},
    { 640, 664, -16},
    { 640, 656, 0},
    { 648, 672, -8},
    { 640, 648, 0},
    { 640, 664, -8},
    { 640, 664, -8},
    { 640, 656, -8},
    { 632, 672, -8},
    { 632, 664, 8},
    { 632, 640, -8},
    { 648, 664, -16},
    { 648, 656, -8},
    { 624, 648, 40},
    { 624, 672, 8},
    { 624, 680, 32},
    { 640, 704, -24},
    // 105 seconds
    { 600, 736, 8},
    { 576, 760, 40},
    { 528, 736, 208},
    { 504, 688, 248},
    { 568, 616, 184},
    { 576, 600, 176},
    { 600, 568, 240},
    { 616, 704, 288},
    { 640, 680, 360},
    { 600, 704, 408},
    { 544, 712, 456},
    { 568, 680, 408},
    { 616, 672, 344},
    { 608, 560, 264},
    { 616, 712, 264},
    { 624, 472, 288},
    { 600, 728, 272},
    { 624, 608, 200},
    { 600, 712, 280},
    { 608, 664, 240},
    { 608, 568, 160},
    { 616, 728, 360},
    { 608, 608, 296},
    { 544, 600, 304},
    { 480, 592, 504},
    // 106 seconds
    { 592, 592, 384},
    { 576, 552, 384},
    { 544, 560, 528},
    { 560, 576, 560},
    { 568, 520, 512},
    { 544, 536, 568},
    { 560, 464, 552},
    { 568, 464, 544},
    { 576, 480, 584},
    { 592, 496, 600},
    { 584, 496, 584},
    { 592, 464, 568},
    { 584, 496, 520},
    { 600, 448, 568},
    { 600, 472, 568},
    { 600, 472, 536},
    { 600, 488, 544},
    { 592, 488, 536},
    { 576, 480, 552},
    { 608, 416, 568},
    { 592, 488, 544},
    { 592, 552, 512},
    { 616, 584, 680},
    { 600, 560, 584},
    { 600, 456, 544},
    // 107 seconds
    { 584, 400, 544},
    { 568, 456, 496},
    { 600, 408, 448},
    { 752, 608, -16},
    { 688, 784, 352},
    { 600, 696, 624},
    { 520, 680, 424},
    { 544, 280, 288},
    { 600, 496, 296},
    { 616, 624, 352},
    { 632, 704, 360},
    { 600, 696, 360},
    { 608, 592, 312},
    { 648, 632, 264},
    { 664, 608, 240},
    { 656, 592, 232},
    { 640, 608, 256},
    { 624, 648, 240},
    { 624, 608, 168},
    { 640, 640, 176},
    { 656, 672, 192},
    { 640, 624, 152},
    { 624, 640, 152},
    { 624, 664, 144},
    { 624, 632, 128},
    // 108 seconds
    { 640, 664, 144},
    { 648, 672, 112},
    { 624, 632, 112},
    { 632, 680, 112},
    { 632, 680, 136},
    { 624, 704, 96},
    { 632, 656, 96},
    { 632, 624, 88},
    { 632, 704, 104},
    { 632, 616, 88},
    { 640, 680, 80},
    { 624, 688, 88},
    { 632, 640, 80},
    { 640, 664, 80},
    { 632, 696, 80},
    { 624, 648, 80},
    { 624, 672, 88},
    { 640, 672, 80},
    { 640, 664, 72},
    { 648, 664, 96},
    { 640, 648, 80},
    { 640, 664, 80},
    { 640, 656, 80},
    { 640, 664, 80},
    { 640, 656, 88},
    // 109 seconds
    { 648, 656, 88},
    { 632, 648, 88},
    { 648, 656, 80},
    { 640, 640, 112},
    { 640, 640, 80},
    { 648, 648, 72},
    { 648, 632, 96},
    { 664, 640, 88},
    { 664, 656, 72},
    { 664, 640, 80},
    { 680, 688, 80},
    { 656, 656, 80},
    { 648, 592, 104},
    { 640, 592, 168},
    { 696, 600, -80},
    { 600, 944, -8},
    { 520, 904, 208},
    { 496, 712, 224},
    { 472, 640, 232},
    { 488, 608, 232},
    { 552, 600, 248},
    { 600, 560, 256},
    { 600, 664, 368},
    { 648, 704, 352},
    { 592, 632, 320},
    // 110 seconds
    { 552, 784, 464},
    { 536, 672, 496},
    { 512, 672, 464},
    { 576, 712, 360},
    { 592, 608, 184},
    { 608, 640, 328},
    { 584, 672, 296},
    { 632, 616, 200},
    { 616, 656, 240},
    { 584, 704, 272},
    { 600, 672, 168},
    { 600, 648, 168},
    { 624, 632, 136},
    { 632, 696, 112},
    { 608, 648, 120},
    { 608, 608, 112},
    { 616, 696, 96},
    { 632, 704, 96},
    { 616, 624, 72},
    { 632, 688, 80},
    { 624, 672, 104},
    { 616, 720, 88},
    { 624, 672, 72},
    { 616, 640, 104},
    { 632, 680, 80},
    // 111 seconds
    { 632, 712, 80},
    { 624, 672, 88},
    { 616, 680, 72},
    { 616, 656, 88},
    { 624, 680, 88},
    { 632, 680, 80},
    { 624, 704, 80},
    { 616, 640, 80},
    { 624, 640, 80},
    { 624, 680, 88},
    { 616, 688, 96},
    { 616, 688, 88},
    { 616, 672, 88},
    { 624, 672, 96},
    { 616, 696, 96},
    { 616, 680, 80},
    { 632, 672, 80},
    { 632, 704, 56},
    { 632, 696, 72},
    { 632, 672, 80},
    { 648, 672, 56},
    { 656, 680, 24},
    { 656, 704, -48},
    { 752, 832, -232},
    { 824, 880, -144},
    // 112 seconds
    { 848, 768, -240},
    { 760, 600, -512},
    { 616, 680, -688},
    { 496, 480, -680},
    { 384, 248, -696},
    { 328, 120, -704},
    { 264, 120, -752},
    { 256, -8, -808},
    { 248, -48, -848},
    { 224, -80, -912},
    { 184, -136, -880},
    { 184, -136, -936},
    { 192, -168, -984},
    { 168, -160, -984},
    { 128, -184, -944},
    { 136, -184, -944},
    { 144, -208, -960},
    { 168, -200, -952},
    { 184, -232, -936},
    { 192, -232, -928},
    { 184, -216, -952},
    { 184, -232, -968},
    { 176, -248, -944},
    { 168, -240, -960},
    { 152, -272, -912},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}


// ----------------------------------------------------------------
// Sample captured: 2015-09-30 07:09:23 local
AccelRawData *activity_sample_reading_paper(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME reading_paper
  //> TEST_EXPECTED 0
  //> TEST_EXPECTED_MIN 0
  //> TEST_EXPECTED_MAX 60
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -144, -408, -872},
    { -72, -416, -952},
    { -104, -448, -936},
    { -80, -448, -936},
    { -80, -440, -936},
    { -80, -440, -936},
    { -80, -432, -936},
    { -72, -440, -936},
    { -64, -440, -944},
    { -72, -440, -944},
    { -72, -448, -936},
    { -72, -440, -936},
    { -64, -440, -944},
    { -88, -456, -936},
    { -72, -440, -928},
    { -72, -432, -952},
    { -64, -440, -944},
    { -72, -432, -944},
    { -64, -424, -944},
    { -64, -424, -944},
    { -40, -432, -936},
    { -80, -488, -928},
    { -136, -488, -912},
    { -144, -440, -928},
    { -112, -424, -944},
    // 1 seconds
    { -96, -448, -936},
    { -72, -440, -928},
    { -64, -432, -944},
    { -72, -440, -936},
    { -64, -448, -928},
    { -128, -384, -912},
    { -72, -408, -952},
    { -32, -416, -944},
    { -32, -416, -944},
    { -24, -400, -952},
    { -24, -408, -936},
    { -8, -416, -952},
    { -24, -408, -952},
    { -32, -416, -976},
    { -8, -320, -1032},
    { -32, -352, -1040},
    { -120, -224, -1096},
    { -160, -40, -1160},
    { -216, 56, -1080},
    { -152, 208, -984},
    { -216, 216, -808},
    { -152, 304, -720},
    { -56, 424, -704},
    { 0, 440, -680},
    { 24, 576, -840},
    // 2 seconds
    { -40, 360, -744},
    { -72, 496, -824},
    { -96, 552, -1000},
    { -192, 608, -1032},
    { -168, 328, -648},
    { -176, 704, -720},
    { -184, 672, -640},
    { -184, 776, -520},
    { -168, 840, -536},
    { -88, 792, -368},
    { -144, 976, -344},
    { -136, 920, -288},
    { -112, 944, -240},
    { -80, 1008, -192},
    { -112, 976, -216},
    { -136, 928, -288},
    { -168, 776, -248},
    { -176, 704, -464},
    { -120, 784, -552},
    { -136, 808, -512},
    { -168, 808, -456},
    { -144, 872, -400},
    { -184, 848, -264},
    { -200, 992, -232},
    { -208, 912, -224},
    // 3 seconds
    { -216, 952, -248},
    { -232, 888, -176},
    { -240, 904, -208},
    { -248, 872, -208},
    { -240, 912, -200},
    { -248, 856, -240},
    { -280, 848, -192},
    { -272, 936, -128},
    { -224, 856, -48},
    { -256, 936, -24},
    { -192, 920, -112},
    { -216, 976, -64},
    { -264, 824, 88},
    { -264, 912, 120},
    { -216, 976, -136},
    { -184, 912, 0},
    { -208, 1024, 24},
    { -176, 912, 24},
    { -200, 888, 48},
    { -232, 872, 128},
    { -224, 1040, -184},
    { -192, 840, -288},
    { -176, 832, -288},
    { -136, 856, -392},
    { -104, 832, -360},
    // 4 seconds
    { -128, 768, -336},
    { -120, 1008, -248},
    { -136, 1056, -232},
    { -144, 856, -240},
    { -152, 896, -192},
    { -136, 928, -248},
    { -136, 888, -256},
    { -136, 864, -256},
    { -160, 888, -240},
    { -136, 904, -320},
    { -152, 944, -192},
    { -144, 896, -176},
    { -128, 920, -208},
    { -160, 952, -80},
    { -168, 992, -16},
    { -200, 912, -24},
    { -176, 888, -112},
    { -152, 912, -224},
    { -144, 880, -256},
    { -136, 912, -248},
    { -128, 904, -248},
    { -120, 920, -232},
    { -120, 904, -232},
    { -120, 904, -232},
    { -120, 912, -232},
    // 5 seconds
    { -120, 904, -248},
    { -120, 904, -248},
    { -120, 912, -240},
    { -120, 904, -240},
    { -112, 880, -256},
    { -112, 896, -264},
    { -112, 912, -248},
    { -112, 888, -256},
    { -112, 896, -248},
    { -112, 912, -248},
    { -112, 896, -248},
    { -120, 896, -256},
    { -120, 896, -256},
    { -120, 904, -248},
    { -120, 896, -264},
    { -120, 904, -248},
    { -120, 904, -248},
    { -128, 896, -248},
    { -120, 904, -256},
    { -120, 904, -256},
    { -128, 904, -248},
    { -120, 904, -248},
    { -112, 896, -256},
    { -120, 904, -256},
    { -120, 904, -256},
    // 6 seconds
    { -120, 904, -248},
    { -120, 904, -248},
    { -120, 904, -248},
    { -112, 896, -256},
    { -112, 904, -248},
    { -112, 912, -248},
    { -120, 912, -248},
    { -112, 896, -240},
    { -112, 904, -248},
    { -112, 904, -248},
    { -112, 896, -248},
    { -112, 912, -248},
    { -112, 912, -256},
    { -112, 904, -256},
    { -112, 912, -256},
    { -112, 904, -256},
    { -112, 904, -248},
    { -112, 896, -256},
    { -112, 904, -248},
    { -112, 904, -256},
    { -112, 896, -256},
    { -112, 904, -248},
    { -120, 896, -256},
    { -120, 896, -248},
    { -112, 904, -248},
    // 7 seconds
    { -112, 896, -256},
    { -120, 896, -248},
    { -120, 904, -256},
    { -112, 904, -256},
    { -112, 896, -256},
    { -112, 896, -256},
    { -120, 904, -264},
    { -112, 896, -256},
    { -112, 896, -256},
    { -112, 896, -256},
    { -120, 896, -256},
    { -112, 904, -256},
    { -120, 904, -256},
    { -120, 904, -256},
    { -120, 904, -256},
    { -112, 896, -256},
    { -112, 896, -256},
    { -112, 904, -256},
    { -120, 904, -256},
    { -120, 896, -248},
    { -112, 904, -256},
    { -120, 904, -256},
    { -120, 904, -256},
    { -120, 904, -256},
    { -120, 904, -256},
    { -120, 904, -256},
    { -120, 904, -256},
    { -120, 904, -256},
    { -112, 896, -256},
    { -120, 904, -256},
    { -120, 904, -248},
    { -112, 896, -256},
    { -120, 896, -256},
    { -120, 896, -256},
    { -120, 896, -256},
    { -120, 896, -248},
    { -112, 896, -256},
    { -120, 904, -256},
    { -112, 904, -256},
    { -112, 904, -256},
    { -120, 904, -256},
    { -120, 896, -256},
    { -120, 896, -256},
    { -120, 896, -256},
    { -120, 896, -256},
    { -112, 904, -256},
    { -120, 904, -256},
    { -120, 896, -256},
    { -120, 904, -256},
    { -120, 896, -256},
    // 9 seconds
    { -120, 904, -256},
    { -120, 896, -256},
    { -120, 904, -264},
    { -120, 904, -264},
    { -120, 904, -256},
    { -120, 904, -248},
    { -120, 896, -264},
    { -120, 896, -264},
    { -120, 896, -264},
    { -120, 896, -256},
    { -120, 896, -264},
    { -120, 904, -256},
    { -112, 904, -256},
    { -120, 896, -256},
    { -120, 896, -248},
    { -112, 904, -248},
    { -112, 896, -264},
    { -112, 896, -248},
    { -112, 904, -256},
    { -112, 896, -256},
    { -112, 904, -256},
    { -112, 904, -248},
    { -112, 904, -256},
    { -112, 904, -256},
    { -112, 904, -256},
    // 10 seconds
    { -112, 896, -248},
    { -112, 896, -256},
    { -112, 904, -256},
    { -112, 904, -256},
    { -112, 904, -248},
    { -120, 896, -256},
    { -120, 896, -248},
    { -112, 904, -248},
    { -112, 904, -248},
    { -120, 904, -256},
    { -112, 896, -248},
    { -112, 904, -248},
    { -112, 904, -256},
    { -112, 896, -248},
    { -112, 904, -248},
    { -112, 904, -248},
    { -112, 896, -248},
    { -112, 896, -256},
    { -104, 904, -256},
    { -112, 904, -248},
    { -112, 904, -256},
    { -112, 896, -256},
    { -120, 904, -248},
    { -112, 904, -256},
    { -112, 896, -256},
    // 11 seconds
    { -112, 904, -248},
    { -112, 904, -256},
    { -112, 896, -248},
    { -120, 896, -248},
    { -112, 904, -256},
    { -112, 904, -256},
    { -112, 896, -256},
    { -112, 904, -256},
    { -112, 904, -256},
    { -112, 904, -256},
    { -112, 896, -256},
    { -120, 904, -256},
    { -112, 904, -256},
    { -120, 896, -256},
    { -120, 896, -256},
    { -112, 896, -256},
    { -112, 896, -256},
    { -112, 904, -248},
    { -112, 896, -256},
    { -112, 904, -256},
    { -112, 904, -256},
    { -120, 904, -256},
    { -112, 904, -256},
    { -112, 896, -256},
    { -112, 904, -256},
    // 12 seconds
    { -112, 904, -248},
    { -112, 896, -256},
    { -112, 904, -248},
    { -112, 896, -256},
    { -120, 904, -256},
    { -112, 896, -256},
    { -112, 904, -256},
    { -112, 896, -256},
    { -112, 896, -256},
    { -120, 904, -248},
    { -120, 896, -256},
    { -120, 896, -264},
    { -112, 896, -256},
    { -120, 904, -256},
    { -112, 904, -256},
    { -112, 904, -256},
    { -112, 904, -256},
    { -120, 904, -248},
    { -112, 896, -256},
    { -112, 896, -256},
    { -120, 904, -248},
    { -112, 904, -264},
    { -112, 904, -256},
    { -120, 896, -256},
    { -112, 896, -256},
    // 13 seconds
    { -112, 896, -248},
    { -112, 896, -248},
    { -112, 904, -256},
    { -112, 896, -256},
    { -120, 896, -256},
    { -120, 896, -256},
    { -112, 896, -256},
    { -112, 896, -256},
    { -112, 896, -256},
    { -112, 904, -256},
    { -112, 896, -256},
    { -120, 896, -256},
    { -112, 904, -256},
    { -120, 904, -256},
    { -112, 896, -256},
    { -120, 904, -256},
    { -112, 904, -248},
    { -112, 912, -248},
    { -112, 896, -256},
    { -120, 896, -256},
    { -112, 904, -248},
    { -112, 904, -256},
    { -120, 896, -256},
    { -120, 904, -256},
    { -112, 904, -256},
    // 14 seconds
    { -120, 904, -256},
    { -120, 904, -248},
    { -120, 904, -256},
    { -112, 904, -248},
    { -112, 904, -248},
    { -112, 904, -256},
    { -120, 904, -256},
    { -112, 904, -248},
    { -104, 904, -248},
    { -112, 904, -256},
    { -120, 904, -256},
    { -112, 888, -248},
    { -112, 904, -248},
    { -112, 904, -256},
    { -112, 904, -256},
    { -120, 904, -256},
    { -112, 904, -248},
    { -104, 904, -256},
    { -112, 904, -248},
    { -112, 904, -248},
    { -112, 904, -256},
    { -112, 904, -248},
    { -112, 896, -256},
    { -112, 904, -248},
    { -120, 896, -256},
    // 15 seconds
    { -120, 904, -256},
    { -120, 904, -256},
    { -120, 904, -248},
    { -112, 904, -248},
    { -120, 896, -256},
    { -112, 904, -256},
    { -112, 904, -248},
    { -120, 904, -256},
    { -112, 904, -248},
    { -120, 904, -248},
    { -120, 920, -240},
    { -136, 952, -248},
    { -144, 920, -192},
    { -136, 864, -216},
    { -152, 920, -160},
    { -160, 944, -168},
    { -160, 928, -128},
    { -104, 864, -136},
    { -160, 960, -112},
    { -136, 936, -216},
    { -112, 856, -232},
    { -128, 904, -192},
    { -128, 888, -224},
    { -152, 936, -152},
    { -168, 936, -120},
    // 16 seconds
    { -152, 944, -120},
    { -128, 904, -128},
    { -128, 928, -128},
    { -128, 920, -120},
    { -120, 904, -136},
    { -120, 936, -120},
    { -104, 912, -104},
    { -120, 936, -96},
    { -120, 928, -96},
    { -128, 936, -96},
    { -128, 928, -104},
    { -120, 920, -112},
    { -120, 936, -104},
    { -120, 920, -112},
    { -128, 928, -104},
    { -144, 928, -88},
    { -136, 928, -96},
    { -136, 920, -112},
    { -136, 928, -96},
    { -136, 928, -88},
    { -128, 928, -96},
    { -136, 928, -96},
    { -136, 928, -96},
    { -136, 928, -88},
    { -128, 920, -88},
    // 17 seconds
    { -120, 928, -88},
    { -160, 912, -96},
    { -152, 920, -80},
    { -136, 928, -72},
    { -120, 936, -72},
    { -112, 936, -72},
    { -112, 928, -72},
    { -128, 928, -80},
    { -136, 920, -72},
    { -136, 928, -72},
    { -128, 928, -64},
    { -128, 928, -64},
    { -128, 928, -72},
    { -128, 928, -64},
    { -128, 928, -64},
    { -128, 928, -64},
    { -128, 928, -72},
    { -128, 928, -72},
    { -128, 928, -64},
    { -128, 928, -64},
    { -128, 920, -72},
    { -128, 928, -72},
    { -128, 928, -64},
    { -136, 928, -64},
    { -136, 928, -64},
    // 18 seconds
    { -128, 928, -64},
    { -128, 928, -64},
    { -128, 936, -64},
    { -128, 928, -64},
    { -128, 928, -64},
    { -128, 936, -56},
    { -128, 928, -64},
    { -128, 928, -64},
    { -120, 928, -64},
    { -128, 936, -56},
    { -128, 928, -56},
    { -120, 928, -56},
    { -128, 936, -56},
    { -128, 936, -56},
    { -128, 928, -56},
    { -128, 920, -56},
    { -128, 928, -56},
    { -128, 928, -64},
    { -128, 928, -56},
    { -128, 936, -56},
    { -128, 928, -56},
    { -128, 928, -56},
    { -128, 928, -56},
    { -128, 920, -64},
    { -128, 928, -56},
    { -128, 928, -56},
    { -120, 920, -56},
    { -128, 928, -64},
    { -128, 936, -48},
    { -120, 936, -56},
    { -120, 928, -56},
    { -128, 928, -56},
    { -128, 920, -64},
    { -128, 928, -56},
    { -120, 928, -56},
    { -120, 928, -56},
    { -120, 936, -48},
    { -120, 928, -48},
    { -120, 928, -56},
    { -128, 928, -48},
    { -120, 928, -48},
    { -120, 928, -40},
    { -120, 920, -48},
    { -128, 928, -48},
    { -120, 928, -48},
    { -120, 928, -48},
    { -120, 928, -48},
    { -120, 928, -48},
    { -112, 928, -40},
    { -112, 928, -40},
    // 20 seconds
    { -120, 928, -48},
    { -120, 928, -40},
    { -128, 928, -40},
    { -120, 920, -40},
    { -112, 928, -32},
    { -112, 928, -48},
    { -112, 936, -40},
    { -112, 936, -32},
    { -120, 928, -40},
    { -112, 928, -40},
    { -112, 928, -40},
    { -120, 928, -40},
    { -120, 928, -40},
    { -120, 928, -40},
    { -120, 936, -32},
    { -120, 928, -40},
    { -120, 928, -40},
    { -120, 928, -40},
    { -120, 928, -40},
    { -112, 928, -32},
    { -128, 944, -32},
    { -128, 928, -32},
    { -120, 928, -32},
    { -112, 920, -40},
    { -112, 936, -32},
    // 21 seconds
    { -112, 928, -40},
    { -120, 936, -40},
    { -112, 936, -40},
    { -112, 928, -32},
    { -112, 928, -40},
    { -112, 928, -40},
    { -112, 936, -48},
    { -112, 928, -40},
    { -120, 928, -40},
    { -120, 920, -40},
    { -120, 928, -40},
    { -128, 920, -32},
    { -128, 928, -32},
    { -128, 928, -40},
    { -96, 944, -32},
    { -104, 944, -40},
    { -104, 936, -32},
    { -104, 936, -24},
    { -112, 936, -32},
    { -120, 936, -32},
    { -128, 920, -32},
    { -128, 936, -40},
    { -128, 928, -32},
    { -112, 928, -32},
    { -104, 936, -24},
    // 22 seconds
    { -120, 936, -40},
    { -104, 928, -32},
    { -104, 936, -24},
    { -104, 920, -32},
    { -112, 936, -32},
    { -112, 928, -32},
    { -112, 928, -32},
    { -112, 928, -40},
    { -112, 936, -32},
    { -112, 936, -40},
    { -112, 936, -32},
    { -112, 928, -32},
    { -112, 928, -40},
    { -112, 928, -32},
    { -112, 928, -32},
    { -112, 936, -32},
    { -112, 920, -32},
    { -120, 928, -32},
    { -120, 920, -40},
    { -112, 936, -32},
    { -120, 928, -40},
    { -112, 928, -32},
    { -112, 928, -32},
    { -112, 928, -32},
    { -112, 928, -32},
    // 23 seconds
    { -112, 936, -32},
    { -112, 928, -32},
    { -112, 936, -32},
    { -112, 928, -24},
    { -112, 936, -32},
    { -112, 936, -32},
    { -112, 928, -32},
    { -112, 928, -24},
    { -112, 928, -24},
    { -112, 936, -32},
    { -112, 928, -24},
    { -104, 912, -24},
    { -112, 928, -16},
    { -112, 920, -32},
    { -112, 936, -24},
    { -112, 928, -16},
    { -112, 928, -24},
    { -112, 944, -24},
    { -112, 928, -24},
    { -112, 928, -24},
    { -112, 928, -24},
    { -104, 936, -24},
    { -112, 936, -24},
    { -112, 920, -24},
    { -112, 928, -24},
    { -112, 928, -24},
    { -96, 920, 0},
    { -112, 928, -24},
    { -112, 928, -24},
    { -112, 936, -24},
    { -104, 928, -24},
    { -112, 928, -24},
    { -112, 936, -24},
    { -112, 928, -32},
    { -112, 936, -32},
    { -112, 936, -24},
    { -112, 936, -24},
    { -112, 928, -24},
    { -112, 928, -24},
    { -112, 928, -24},
    { -112, 928, -24},
    { -112, 928, -24},
    { -112, 928, -24},
    { -112, 928, -32},
    { -112, 928, -24},
    { -112, 936, -24},
    { -112, 928, -24},
    { -112, 936, -32},
    { -112, 936, -24},
    { -112, 928, -24},
    { -112, 928, -24},
    { -104, 928, -32},
    { -112, 928, -24},
    { -112, 936, -24},
    { -112, 936, -24},
    { -104, 928, -24},
    { -112, 928, -32},
    { -112, 928, -32},
    { -112, 928, -32},
    { -112, 928, -40},
    { -112, 936, -24},
    { -112, 928, -32},
    { -112, 928, -32},
    { -120, 928, -32},
    { -112, 928, -32},
    { -112, 928, -32},
    { -112, 928, -32},
    { -112, 928, -32},
    { -112, 928, -40},
    { -112, 928, -32},
    { -112, 928, -32},
    { -112, 936, -32},
    { -112, 928, -32},
    { -112, 928, -40},
    { -112, 928, -40},
    // 26 seconds
    { -128, 936, -40},
    { -120, 928, -56},
    { -128, 944, -48},
    { -120, 976, -72},
    { -136, 944, -72},
    { -144, 936, -80},
    { -144, 976, -80},
    { -160, 952, -72},
    { -176, 920, -40},
    { -176, 880, -32},
    { -200, 896, -24},
    { -216, 880, -8},
    { -224, 872, 0},
    { -224, 880, -8},
    { -216, 872, -8},
    { -216, 880, 24},
    { -216, 904, 32},
    { -208, 920, 64},
    { -200, 912, 96},
    { -200, 920, 104},
    { -200, 936, 128},
    { -192, 920, 96},
    { -184, 912, 72},
    { -176, 944, 64},
    { -168, 936, 40},
    // 27 seconds
    { -160, 936, 56},
    { -160, 936, 64},
    { -168, 928, 64},
    { -168, 920, 64},
    { -160, 920, 72},
    { -152, 928, 56},
    { -152, 936, 72},
    { -152, 928, 56},
    { -144, 920, 56},
    { -144, 928, 56},
    { -144, 936, 48},
    { -144, 936, 56},
    { -152, 936, 56},
    { -152, 1000, 40},
    { -144, 944, 48},
    { -144, 904, 48},
    { -144, 960, 24},
    { -152, 1008, 16},
    { -152, 1112, -88},
    { -120, 1144, -384},
    { -96, 704, -480},
    { -136, 344, -696},
    { -128, 312, -1016},
    { -152, 232, -944},
    { -144, 64, -856},
    // 28 seconds
    { -120, -40, -928},
    { -136, -104, -968},
    { -160, -120, -968},
    { -168, -104, -984},
    { -176, -120, -1008},
    { -184, -120, -1000},
    { -184, -96, -1000},
    { -176, -72, -1000},
    { -176, -88, -1008},
    { -176, -120, -1000},
    { -184, -112, -1008},
    { -176, -96, -1016},
    { -184, -104, -992},
    { -200, -112, -1008},
    { -184, -104, -1008},
    { -192, -104, -1000},
    { -184, -112, -1000},
    { -184, -120, -1000},
    { -192, -104, -1008},
    { -200, -112, -1000},
    { -192, -112, -992},
    { -184, -128, -952},
    { -192, -168, -824},
    { -144, -128, -808},
    { -224, 136, -920},
    // 29 seconds
    { -184, 504, -840},
    { -96, 656, -768},
    { -48, 864, -608},
    { -48, 1176, -504},
    { -96, 864, -328},
    { -120, 840, -272},
    { -112, 936, -320},
    { -120, 872, -280},
    { -136, 920, -272},
    { -128, 856, -272},
    { -136, 936, -256},
    { -160, 920, -232},
    { -144, 904, -248},
    { -160, 944, -232},
    { -160, 896, -200},
    { -168, 896, -232},
    { -168, 912, -208},
    { -168, 928, -208},
    { -168, 904, -216},
    { -160, 904, -216},
    { -168, 896, -208},
    { -176, 992, -216},
    { -200, 928, -168},
    { -184, 896, -192},
    { -184, 912, -224},
    // 30 seconds
    { -176, 912, -184},
    { -184, 904, -184},
    { -176, 888, -184},
    { -176, 904, -168},
    { -176, 936, -168},
    { -176, 912, -168},
    { -176, 928, -168},
    { -176, 928, -160},
    { -168, 888, -152},
    { -168, 904, -168},
    { -176, 936, -152},
    { -168, 872, -128},
    { -168, 912, -160},
    { -176, 920, -144},
    { -176, 928, -144},
    { -176, 920, -136},
    { -168, 920, -136},
    { -176, 920, -144},
    { -176, 920, -144},
    { -168, 912, -144},
    { -168, 904, -144},
    { -176, 936, -144},
    { -168, 928, -136},
    { -168, 904, -152},
    { -160, 920, -160},
    // 31 seconds
    { -168, 928, -144},
    { -168, 912, -152},
    { -168, 904, -152},
    { -168, 912, -144},
    { -168, 920, -152},
    { -168, 912, -144},
    { -168, 912, -152},
    { -168, 920, -144},
    { -168, 912, -152},
    { -160, 912, -152},
    { -168, 920, -144},
    { -168, 912, -152},
    { -168, 920, -152},
    { -168, 912, -152},
    { -168, 912, -152},
    { -168, 912, -152},
    { -168, 912, -152},
    { -168, 912, -160},
    { -168, 920, -152},
    { -168, 920, -152},
    { -168, 912, -152},
    { -160, 920, -152},
    { -160, 912, -152},
    { -168, 912, -152},
    { -160, 912, -152},
    // 32 seconds
    { -160, 904, -152},
    { -160, 912, -160},
    { -160, 912, -152},
    { -168, 920, -160},
    { -160, 912, -160},
    { -160, 912, -160},
    { -160, 912, -152},
    { -160, 912, -152},
    { -160, 920, -160},
    { -160, 912, -160},
    { -160, 912, -152},
    { -160, 920, -160},
    { -160, 904, -160},
    { -160, 920, -152},
    { -152, 912, -168},
    { -160, 912, -160},
    { -160, 912, -160},
    { -160, 920, -168},
    { -160, 912, -160},
    { -160, 920, -160},
    { -160, 912, -160},
    { -152, 912, -168},
    { -160, 912, -160},
    { -160, 920, -168},
    { -152, 912, -160},
    // 33 seconds
    { -160, 912, -168},
    { -152, 920, -160},
    { -160, 920, -168},
    { -152, 912, -168},
    { -152, 912, -160},
    { -160, 912, -160},
    { -160, 920, -168},
    { -160, 920, -168},
    { -160, 912, -160},
    { -144, 920, -176},
    { -152, 904, -168},
    { -160, 912, -168},
    { -160, 912, -168},
    { -160, 912, -168},
    { -160, 920, -168},
    { -160, 912, -160},
    { -152, 920, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 920, -168},
    { -160, 912, -168},
    { -160, 920, -168},
    // 34 seconds
    { -160, 912, -168},
    { -152, 920, -168},
    { -152, 920, -168},
    { -152, 912, -168},
    { -160, 920, -168},
    { -160, 912, -168},
    { -152, 912, -168},
    { -160, 912, -168},
    { -152, 920, -168},
    { -160, 912, -168},
    { -152, 912, -176},
    { -152, 912, -160},
    { -152, 920, -168},
    { -152, 912, -176},
    { -160, 920, -168},
    { -152, 912, -168},
    { -152, 920, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 920, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -160, 920, -168},
    { -152, 912, -168},
    { -152, 920, -168},
    { -152, 920, -168},
    { -152, 912, -168},
    { -160, 912, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 920, -168},
    { -152, 912, -176},
    { -152, 920, -160},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 912, -160},
    { -144, 912, -176},
    { -144, 912, -176},
    { -152, 920, -160},
    { -152, 920, -160},
    { -144, 912, -168},
    { -152, 912, -168},
    { -136, 912, -168},
    { -144, 912, -168},
    { -144, 912, -168},
    { -144, 920, -168},
    { -144, 920, -168},
    { -144, 920, -168},
    // 36 seconds
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 920, -168},
    { -144, 920, -176},
    { -144, 912, -176},
    { -136, 920, -176},
    { -136, 912, -176},
    { -144, 912, -176},
    { -144, 920, -168},
    { -136, 912, -168},
    { -144, 912, -176},
    { -144, 912, -168},
    { -136, 920, -176},
    { -136, 912, -176},
    { -144, 920, -176},
    { -136, 920, -168},
    { -136, 912, -176},
    { -144, 920, -160},
    { -144, 904, -152},
    { -144, 912, -176},
    { -136, 912, -176},
    { -136, 920, -168},
    { -144, 912, -168},
    { -144, 920, -168},
    { -144, 912, -168},
    { -144, 912, -168},
    { -144, 912, -168},
    { -136, 920, -168},
    { -144, 912, -168},
    { -144, 912, -176},
    { -128, 896, -192},
    { -144, 912, -168},
    { -144, 920, -176},
    { -144, 912, -168},
    { -144, 920, -168},
    { -144, 920, -168},
    { -152, 920, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 912, -168},
    { -168, 952, -184},
    { -152, 928, -168},
    { -152, 920, -160},
    { -144, 920, -176},
    { -152, 920, -168},
    { -152, 912, -176},
    { -152, 912, -168},
    { -144, 912, -168},
    // 38 seconds
    { -152, 912, -176},
    { -152, 912, -168},
    { -152, 912, -176},
    { -152, 920, -168},
    { -152, 920, -168},
    { -152, 912, -176},
    { -152, 920, -168},
    { -152, 912, -176},
    { -152, 912, -168},
    { -152, 920, -168},
    { -152, 904, -176},
    { -152, 912, -168},
    { -152, 912, -176},
    { -152, 912, -168},
    { -160, 920, -176},
    { -152, 920, -176},
    { -152, 920, -176},
    { -152, 912, -168},
    { -152, 912, -176},
    { -152, 896, -176},
    { -152, 912, -176},
    { -152, 912, -168},
    { -160, 920, -168},
    { -152, 912, -176},
    { -152, 912, -168},
    // 39 seconds
    { -152, 912, -176},
    { -152, 904, -168},
    { -152, 912, -176},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 920, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 912, -176},
    { -160, 920, -168},
    { -152, 912, -168},
    { -152, 912, -168},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 912, -176},
    { -160, 912, -168},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 920, -168},
    { -152, 912, -168},
    { -152, 920, -168},
    { -152, 912, -168},
    { -152, 920, -176},
    // 40 seconds
    { -152, 912, -168},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 920, -168},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 904, -168},
    { -160, 912, -168},
    { -152, 920, -176},
    { -152, 912, -176},
    { -152, 920, -176},
    { -152, 912, -184},
    { -152, 912, -168},
    { -152, 920, -176},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 912, -176},
    { -152, 912, -176},
    { -144, 912, -184},
    { -144, 920, -176},
    { -152, 904, -176},
    // 41 seconds
    { -152, 912, -168},
    { -152, 912, -176},
    { -144, 920, -176},
    { -144, 920, -176},
    { -144, 912, -176},
    { -144, 920, -176},
    { -152, 912, -176},
    { -152, 920, -184},
    { -144, 912, -176},
    { -144, 912, -184},
    { -144, 920, -176},
    { -144, 920, -184},
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 920, -176},
    { -144, 904, -176},
    { -144, 920, -184},
    { -144, 912, -176},
    { -144, 920, -176},
    { -144, 920, -176},
    { -144, 920, -176},
    { -144, 912, -176},
    { -144, 920, -168},
    { -144, 912, -176},
    { -144, 920, -176},
    // 42 seconds
    { -136, 920, -176},
    { -136, 912, -176},
    { -136, 904, -176},
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 920, -176},
    { -136, 912, -176},
    { -136, 912, -176},
    { -144, 920, -176},
    { -144, 912, -184},
    { -136, 912, -176},
    { -144, 920, -176},
    { -136, 920, -176},
    { -144, 904, -184},
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 912, -184},
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 912, -184},
    { -136, 912, -176},
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 920, -168},
    { -144, 920, -184},
    { -144, 912, -176},
    { -144, 920, -176},
    { -144, 912, -184},
    { -144, 912, -176},
    { -144, 912, -184},
    { -144, 912, -176},
    { -152, 912, -176},
    { -144, 920, -184},
    { -144, 912, -184},
    { -144, 912, -176},
    { -144, 912, -184},
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 920, -184},
    { -144, 920, -184},
    { -152, 912, -184},
    { -144, 920, -176},
    { -144, 912, -176},
    { -144, 920, -176},
    { -144, 912, -176},
    { -144, 920, -176},
    // 44 seconds
    { -144, 920, -184},
    { -144, 920, -184},
    { -144, 912, -176},
    { -144, 920, -184},
    { -152, 912, -176},
    { -152, 920, -176},
    { -144, 920, -176},
    { -144, 920, -176},
    { -144, 912, -184},
    { -152, 912, -176},
    { -144, 920, -176},
    { -144, 912, -176},
    { -152, 912, -176},
    { -144, 912, -176},
    { -144, 912, -184},
    { -144, 904, -176},
    { -144, 912, -176},
    { -152, 920, -184},
    { -152, 912, -184},
    { -152, 912, -176},
    { -152, 912, -168},
    { -152, 920, -176},
    { -144, 912, -176},
    { -136, 920, -176},
    { -144, 920, -168},
    // 45 seconds
    { -144, 912, -176},
    { -144, 912, -176},
    { -144, 920, -168},
    { -144, 912, -176},
    { -152, 912, -176},
    { -144, 904, -176},
    { -144, 912, -176},
    { -152, 912, -168},
    { -144, 936, -168},
    { -144, 912, -168},
    { -152, 920, -160},
    { -144, 912, -176},
    { -144, 912, -168},
    { -144, 904, -184},
    { -144, 920, -168},
    { -152, 912, -168},
    { -144, 904, -168},
    { -136, 912, -176},
    { -136, 920, -168},
    { -128, 936, -168},
    { -128, 912, -176},
    { -136, 912, -176},
    { -136, 912, -168},
    { -136, 912, -176},
    { -128, 912, -168},
    // 46 seconds
    { -136, 920, -168},
    { -136, 920, -168},
    { -136, 920, -168},
    { -136, 912, -168},
    { -136, 920, -168},
    { -136, 912, -168},
    { -136, 912, -168},
    { -136, 912, -160},
    { -136, 928, -160},
    { -136, 920, -160},
    { -136, 920, -160},
    { -144, 912, -160},
    { -136, 912, -160},
    { -136, 920, -152},
    { -136, 912, -152},
    { -136, 920, -160},
    { -136, 920, -160},
    { -136, 920, -152},
    { -136, 928, -160},
    { -144, 920, -152},
    { -136, 912, -152},
    { -136, 912, -152},
    { -136, 912, -160},
    { -128, 920, -144},
    { -136, 920, -152},
    // 47 seconds
    { -136, 912, -160},
    { -136, 912, -160},
    { -136, 920, -160},
    { -136, 912, -152},
    { -136, 920, -152},
    { -136, 920, -160},
    { -128, 920, -152},
    { -136, 912, -168},
    { -136, 920, -168},
    { -136, 920, -160},
    { -136, 912, -160},
    { -136, 912, -160},
    { -128, 912, -160},
    { -136, 912, -152},
    { -136, 912, -160},
    { -136, 912, -160},
    { -128, 920, -160},
    { -136, 920, -152},
    { -128, 920, -152},
    { -128, 920, -152},
    { -128, 920, -160},
    { -128, 920, -160},
    { -136, 920, -160},
    { -136, 920, -160},
    { -136, 912, -152},
    // 48 seconds
    { -136, 920, -152},
    { -136, 920, -160},
    { -136, 912, -160},
    { -128, 912, -160},
    { -136, 920, -152},
    { -128, 920, -152},
    { -128, 920, -152},
    { -128, 928, -152},
    { -128, 912, -152},
    { -128, 920, -152},
    { -128, 928, -152},
    { -136, 912, -160},
    { -128, 912, -152},
    { -128, 920, -152},
    { -128, 920, -152},
    { -128, 920, -152},
    { -128, 928, -160},
    { -136, 920, -152},
    { -128, 920, -152},
    { -128, 928, -152},
    { -120, 912, -152},
    { -128, 920, -160},
    { -136, 920, -144},
    { -128, 912, -152},
    { -128, 920, -152},
    // 49 seconds
    { -128, 928, -144},
    { -128, 920, -152},
    { -128, 920, -144},
    { -128, 920, -152},
    { -128, 928, -152},
    { -120, 928, -152},
    { -128, 920, -152},
    { -128, 928, -152},
    { -128, 920, -160},
    { -128, 920, -160},
    { -128, 920, -152},
    { -128, 912, -152},
    { -136, 912, -144},
    { -120, 912, -160},
    { -128, 920, -152},
    { -128, 912, -160},
    { -128, 920, -160},
    { -128, 920, -168},
    { -128, 912, -160},
    { -128, 920, -168},
    { -128, 912, -160},
    { -120, 920, -160},
    { -120, 928, -160},
    { -128, 920, -168},
    { -128, 920, -160},
    { -128, 920, -160},
    { -128, 920, -160},
    { -136, 920, -160},
    { -136, 912, -168},
    { -136, 912, -160},
    { -128, 920, -168},
    { -112, 928, -160},
    { -112, 920, -168},
    { -120, 928, -168},
    { -136, 912, -168},
    { -144, 904, -176},
    { -136, 920, -168},
    { -136, 920, -168},
    { -136, 920, -168},
    { -136, 920, -176},
    { -136, 904, -160},
    { -120, 920, -160},
    { -120, 928, -152},
    { -120, 920, -168},
    { -120, 920, -168},
    { -120, 928, -176},
    { -120, 928, -152},
    { -128, 928, -168},
    { -128, 904, -168},
    { -136, 912, -168},
    // 51 seconds
    { -128, 912, -168},
    { -128, 920, -160},
    { -120, 920, -168},
    { -112, 920, -168},
    { -128, 920, -160},
    { -120, 920, -160},
    { -120, 912, -168},
    { -120, 920, -168},
    { -120, 920, -168},
    { -120, 912, -168},
    { -120, 920, -168},
    { -128, 912, -168},
    { -120, 912, -176},
    { -120, 912, -168},
    { -128, 920, -176},
    { -120, 920, -176},
    { -128, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -128, 912, -176},
    { -128, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 904, -176},
    { -128, 912, -168},
    { -128, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -128, 912, -176},
    { -120, 912, -176},
    { -128, 912, -176},
    { -128, 912, -176},
    { -120, 920, -176},
    { -120, 912, -184},
    { -120, 912, -176},
    { -128, 920, -176},
    { -120, 920, -176},
    { -120, 920, -168},
    { -120, 912, -184},
    { -128, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -128, 920, -176},
    { -128, 912, -176},
    { -128, 912, -176},
    { -120, 912, -176},
    { -128, 920, -184},
    { -128, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 912, -184},
    { -120, 912, -176},
    { -128, 920, -176},
    { -120, 912, -176},
    { -128, 920, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 920, -184},
    { -120, 912, -184},
    { -128, 920, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -128, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    // 54 seconds
    { -128, 912, -176},
    { -128, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -128, 912, -176},
    { -120, 920, -176},
    { -128, 912, -176},
    { -120, 920, -184},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -128, 912, -184},
    { -128, 920, -184},
    { -120, 912, -184},
    { -120, 912, -184},
    { -128, 904, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -184},
    { -128, 920, -176},
    { -120, 912, -176},
    { -120, 904, -176},
    // 55 seconds
    { -120, 912, -176},
    { -120, 920, -176},
    { -128, 912, -184},
    { -128, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -184},
    { -120, 920, -176},
    { -128, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 920, -184},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    // 56 seconds
    { -120, 912, -168},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 912, -184},
    { -120, 920, -176},
    { -120, 920, -176},
    { -112, 912, -176},
    { -120, 920, -184},
    { -120, 912, -184},
    { -120, 912, -176},
    { -120, 912, -176},
    { -112, 920, -184},
    { -120, 912, -176},
    { -120, 920, -176},
    { -128, 920, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 920, -184},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -184},
    { -120, 920, -176},
    { -120, 912, -184},
    { -120, 920, -176},
    { -120, 912, -176},
    { -128, 912, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -184},
    { -120, 912, -184},
    { -120, 920, -184},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -128, 920, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -112, 912, -184},
    { -120, 920, -176},
    { -112, 912, -176},
    // 58 seconds
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 920, -184},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -120, 912, -184},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -112, 920, -184},
    { -120, 912, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    // 59 seconds
    { -112, 912, -176},
    { -120, 912, -168},
    { -120, 920, -176},
    { -120, 912, -184},
    { -120, 928, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -112, 912, -176},
    { -112, 920, -184},
    { -112, 920, -176},
    { -112, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -120, 912, -184},
    { -120, 920, -176},
    { -112, 920, -176},
    { -112, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -184},
    { -120, 920, -184},
    // 60 seconds
    // elapsed: 1 minutes
    { -120, 912, -176},
    { -112, 912, -184},
    { -120, 920, -176},
    { -112, 912, -176},
    { -120, 912, -184},
    { -120, 920, -176},
    { -120, 920, -176},
    { -112, 912, -184},
    { -120, 920, -176},
    { -120, 920, -176},
    { -112, 920, -176},
    { -120, 920, -176},
    { -112, 920, -176},
    { -112, 912, -176},
    { -120, 920, -184},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -112, 920, -176},
    { -112, 912, -176},
    { -112, 912, -176},
    { -112, 920, -176},
    // 61 seconds
    { -112, 912, -176},
    { -120, 912, -176},
    { -112, 920, -176},
    { -112, 912, -176},
    { -112, 920, -176},
    { -120, 920, -184},
    { -112, 920, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 920, -176},
    { -112, 920, -176},
    { -120, 912, -176},
    { -112, 912, -184},
    { -120, 920, -176},
    { -112, 912, -176},
    { -112, 920, -176},
    { -112, 920, -168},
    { -120, 912, -176},
    { -112, 920, -176},
    { -112, 912, -176},
    { -112, 920, -176},
    { -120, 920, -176},
    { -120, 920, -168},
    { -112, 912, -176},
    // 62 seconds
    { -112, 920, -176},
    { -120, 912, -176},
    { -112, 912, -176},
    { -112, 912, -176},
    { -120, 912, -184},
    { -112, 920, -176},
    { -112, 912, -184},
    { -112, 920, -176},
    { -120, 912, -184},
    { -120, 920, -176},
    { -112, 912, -184},
    { -120, 920, -176},
    { -112, 920, -184},
    { -120, 912, -176},
    { -112, 920, -176},
    { -120, 912, -176},
    { -120, 920, -176},
    { -120, 912, -176},
    { -112, 912, -176},
    { -112, 904, -184},
    { -120, 920, -176},
    { -120, 920, -176},
    { -112, 920, -176},
    { -120, 920, -176},
    { -112, 912, -176},
    // 63 seconds
    { -112, 920, -184},
    { -112, 912, -176},
    { -120, 912, -184},
    { -120, 912, -176},
    { -120, 920, -176},
    { -112, 920, -176},
    { -112, 920, -184},
    { -112, 920, -176},
    { -112, 912, -176},
    { -112, 912, -176},
    { -112, 912, -176},
    { -112, 912, -176},
    { -120, 912, -176},
    { -120, 912, -184},
    { -112, 920, -176},
    { -112, 912, -176},
    { -112, 920, -176},
    { -120, 920, -176},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 912, -176},
    { -120, 920, -184},
    { -112, 912, -184},
    { -112, 912, -176},
    // 64 seconds
    { -120, 912, -184},
    { -112, 912, -176},
    { -112, 920, -176},
    { -112, 912, -184},
    { -112, 912, -176},
    { -112, 920, -176},
    { -112, 912, -184},
    { -112, 912, -176},
    { -112, 920, -176},
    { -112, 912, -176},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 912, -176},
    { -112, 912, -184},
    { -112, 920, -176},
    { -112, 912, -184},
    { -112, 912, -176},
    { -112, 912, -184},
    { -112, 936, -176},
    { -112, 912, -184},
    { -112, 912, -184},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 904, -176},
    // 65 seconds
    { -112, 904, -192},
    { -104, 912, -176},
    { -112, 920, -176},
    { -112, 920, -176},
    { -112, 912, -176},
    { -104, 912, -184},
    { -112, 920, -176},
    { -112, 912, -176},
    { -112, 912, -184},
    { -104, 920, -184},
    { -104, 920, -176},
    { -112, 912, -176},
    { -112, 920, -184},
    { -104, 912, -184},
    { -104, 920, -176},
    { -112, 912, -184},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 920, -176},
    { -112, 912, -184},
    { -112, 904, -176},
    { -104, 920, -176},
    { -112, 920, -184},
    { -112, 912, -176},
    { -104, 912, -176},
    // 66 seconds
    { -112, 920, -176},
    { -104, 920, -184},
    { -112, 920, -184},
    { -112, 912, -176},
    { -112, 912, -176},
    { -104, 920, -184},
    { -104, 920, -176},
    { -112, 912, -176},
    { -112, 912, -176},
    { -112, 920, -176},
    { -112, 912, -176},
    { -112, 920, -184},
    { -112, 912, -184},
    { -112, 920, -176},
    { -104, 920, -176},
    { -112, 920, -176},
    { -112, 912, -176},
    { -112, 912, -184},
    { -112, 912, -184},
    { -112, 920, -176},
    { -112, 920, -176},
    { -104, 912, -184},
    { -112, 920, -176},
    { -112, 920, -176},
    { -112, 912, -176},
    // 67 seconds
    { -112, 912, -184},
    { -112, 920, -184},
    { -104, 920, -176},
    { -112, 920, -176},
    { -104, 920, -176},
    { -112, 912, -184},
    { -112, 912, -184},
    { -112, 912, -176},
    { -112, 920, -176},
    { -112, 920, -184},
    { -112, 912, -176},
    { -112, 920, -184},
    { -112, 920, -176},
    { -112, 912, -176},
    { -112, 920, -176},
    { -112, 912, -176},
    { -104, 912, -176},
    { -112, 920, -176},
    { -112, 920, -176},
    { -112, 920, -176},
    { -112, 912, -184},
    { -112, 912, -184},
    { -112, 912, -184},
    { -112, 912, -184},
    { -112, 912, -176},
    // 68 seconds
    { -112, 912, -184},
    { -112, 920, -176},
    { -112, 912, -184},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 912, -184},
    { -112, 920, -176},
    { -112, 920, -184},
    { -112, 912, -184},
    { -112, 920, -184},
    { -112, 920, -176},
    { -112, 920, -184},
    { -112, 912, -184},
    { -112, 920, -184},
    { -112, 912, -184},
    { -112, 920, -184},
    { -112, 912, -184},
    { -104, 920, -176},
    { -112, 912, -184},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 912, -184},
    { -112, 920, -176},
    { -112, 920, -176},
    { -112, 904, -192},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 912, -184},
    { -104, 912, -184},
    { -112, 912, -184},
    { -104, 912, -184},
    { -112, 912, -184},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 912, -184},
    { -112, 912, -184},
    { -112, 912, -184},
    { -112, 920, -184},
    { -112, 920, -184},
    { -104, 912, -192},
    { -112, 920, -192},
    { -104, 912, -184},
    { -112, 920, -184},
    { -112, 920, -184},
    { -112, 912, -184},
    { -112, 912, -184},
    { -104, 912, -184},
    { -104, 912, -184},
    // 70 seconds
    { -104, 920, -176},
    { -112, 920, -184},
    { -104, 920, -184},
    { -112, 912, -184},
    { -104, 920, -192},
    { -104, 920, -192},
    { -104, 912, -184},
    { -112, 912, -184},
    { -104, 920, -184},
    { -104, 912, -176},
    { -104, 912, -192},
    { -104, 920, -184},
    { -112, 912, -184},
    { -104, 912, -184},
    { -104, 912, -184},
    { -104, 920, -184},
    { -104, 912, -184},
    { -104, 920, -184},
    { -104, 920, -184},
    { -112, 920, -184},
    { -112, 912, -184},
    { -104, 912, -176},
    { -104, 920, -184},
    { -112, 920, -184},
    { -104, 912, -184},
    // 71 seconds
    { -104, 920, -176},
    { -104, 912, -184},
    { -104, 920, -184},
    { -112, 912, -184},
    { -104, 920, -184},
    { -104, 920, -184},
    { -104, 920, -184},
    { -104, 920, -184},
    { -104, 920, -176},
    { -104, 912, -184},
    { -112, 912, -176},
    { -104, 920, -184},
    { -104, 912, -184},
    { -112, 920, -176},
    { -112, 912, -184},
    { -112, 920, -184},
    { -104, 920, -184},
    { -104, 920, -184},
    { -104, 920, -184},
    { -112, 912, -176},
    { -112, 912, -184},
    { -112, 912, -184},
    { -104, 920, -184},
    { -104, 912, -184},
    { -112, 912, -176},
    // 72 seconds
    { -112, 920, -184},
    { -112, 912, -184},
    { -104, 912, -176},
    { -112, 920, -176},
    { -104, 920, -184},
    { -112, 912, -184},
    { -104, 920, -176},
    { -112, 912, -176},
    { -104, 928, -184},
    { -112, 920, -184},
    { -104, 912, -184},
    { -104, 920, -176},
    { -112, 920, -184},
    { -104, 912, -184},
    { -112, 912, -184},
    { -104, 920, -176},
    { -112, 912, -184},
    { -104, 920, -176},
    { -112, 920, -184},
    { -104, 912, -184},
    { -104, 912, -176},
    { -104, 920, -184},
    { -104, 920, -184},
    { -112, 912, -184},
    { -104, 920, -176},
    // 73 seconds
    { -112, 912, -176},
    { -104, 912, -184},
    { -112, 920, -184},
    { -104, 920, -184},
    { -112, 912, -184},
    { -112, 912, -184},
    { -104, 920, -176},
    { -112, 920, -176},
    { -112, 912, -184},
    { -112, 912, -176},
    { -112, 920, -184},
    { -104, 920, -184},
    { -104, 912, -184},
    { -104, 920, -184},
    { -104, 912, -184},
    { -112, 920, -176},
    { -112, 912, -176},
    { -104, 920, -184},
    { -112, 912, -184},
    { -104, 920, -184},
    { -104, 920, -176},
    { -104, 880, -192},
    { -104, 912, -168},
    { -96, 912, -176},
    { -104, 920, -184},
    // 74 seconds
    { -104, 936, -192},
    { -112, 920, -184},
    { -112, 912, -216},
    { -104, 928, -224},
    { -104, 936, -248},
    { -96, 872, -312},
    { -96, 872, -352},
    { -88, 896, -384},
    { -64, 856, -424},
    { -48, 880, -584},
    { -40, 928, -608},
    { -24, 856, -792},
    { -48, 624, -824},
    { -64, 592, -864},
    { -120, 416, -792},
    { -136, 232, -744},
    { -96, 0, -864},
    { -128, -120, -888},
    { -168, -216, -880},
    { -152, -296, -944},
    { -152, -336, -896},
    { -120, -392, -912},
    { -88, -408, -928},
    { -80, -400, -912},
    { -56, -440, -936},
    // 75 seconds
    { -72, -464, -920},
    { -72, -440, -936},
    { -80, -416, -928},
    { -72, -408, -960},
    { -88, -408, -928},
    { -80, -416, -928},
    { -56, -424, -936},
    { -24, -376, -968},
    { -8, -360, -992},
    { -16, -360, -984},
    { -16, -352, -1000},
    { -8, -368, -1016},
    { 0, -352, -1024},
    { 0, -328, -992},
    { 24, -304, -1048},
    { 80, -240, -1152},
    { 136, -112, -1048},
    { 104, 280, -1056},
    { -56, 280, -912},
    { -112, 216, -888},
    { -160, 200, -824},
    { -144, 56, -848},
    { -120, 64, -1000},
    { -144, 120, -1000},
    { -168, 288, -1008},
    // 76 seconds
    { -160, 216, -1064},
    { -160, 168, -1000},
    { -184, 216, -952},
    { -184, 280, -1016},
    { -192, 280, -1000},
    { -200, 336, -928},
    { -216, 336, -856},
    { -208, 400, -912},
    { -192, 352, -896},
    { -192, 344, -912},
    { -224, 312, -912},
    { -224, 376, -888},
    { -216, 320, -904},
    { -240, 320, -872},
    { -264, 376, -872},
    { -248, 328, -904},
    { -240, 352, -912},
    { -272, 328, -904},
    { -224, 320, -928},
    { -248, 336, -896},
    { -224, 376, -896},
    { -216, 368, -920},
    { -232, 400, -896},
    { -232, 400, -872},
    { -216, 368, -880},
    // 77 seconds
    { -216, 384, -912},
    { -216, 376, -896},
    { -216, 368, -920},
    { -224, 376, -904},
    { -224, 408, -888},
    { -224, 400, -872},
    { -224, 424, -880},
    { -224, 408, -880},
    { -224, 424, -856},
    { -240, 440, -824},
    { -224, 424, -864},
    { -224, 416, -904},
    { -232, 392, -864},
    { -216, 408, -888},
    { -216, 408, -888},
    { -224, 408, -872},
    { -216, 416, -880},
    { -216, 408, -872},
    { -216, 408, -872},
    { -208, 408, -872},
    { -208, 424, -896},
    { -216, 392, -888},
    { -216, 392, -880},
    { -216, 408, -888},
    { -216, 400, -880},
    // 78 seconds
    { -216, 408, -896},
    { -216, 408, -880},
    { -208, 400, -880},
    { -208, 400, -872},
    { -192, 392, -880},
    { -208, 408, -872},
    { -200, 416, -872},
    { -200, 384, -856},
    { -192, 376, -864},
    { -184, 360, -920},
    { -160, 328, -912},
    { -152, 288, -888},
    { -136, 272, -912},
    { -152, 344, -944},
    { -192, 288, -944},
    { -160, 336, -1056},
    { -152, 320, -960},
    { -144, 344, -912},
    { -128, 336, -952},
    { -128, 320, -920},
    { -128, 312, -928},
    { -136, 304, -944},
    { -144, 312, -920},
    { -136, 320, -928},
    { -136, 320, -944},
    // 79 seconds
    { -128, 312, -936},
    { -136, 304, -928},
    { -136, 320, -936},
    { -136, 320, -928},
    { -136, 296, -936},
    { -136, 296, -952},
    { -120, 288, -936},
    { -112, 288, -944},
    { -112, 272, -952},
    { -128, 288, -944},
    { -120, 304, -920},
    { -120, 296, -944},
    { -120, 288, -960},
    { -112, 272, -960},
    { -104, 264, -952},
    { -112, 280, -936},
    { -120, 296, -960},
    { -120, 288, -960},
    { -128, 280, -960},
    { -120, 264, -952},
    { -104, 272, -968},
    { -112, 272, -960},
    { -112, 272, -944},
    { -128, 280, -944},
    { -128, 280, -952},
    // 80 seconds
    { -128, 272, -936},
    { -136, 280, -936},
    { -152, 288, -936},
    { -160, 288, -944},
    { -144, 280, -992},
    { -120, 256, -984},
    { -96, 264, -960},
    { -80, 272, -944},
    { -88, 272, -936},
    { -104, 264, -928},
    { -128, 264, -944},
    { -144, 264, -968},
    { -144, 264, -960},
    { -144, 264, -968},
    { -136, 256, -944},
    { -128, 264, -936},
    { -128, 288, -960},
    { -136, 296, -1000},
    { -144, 288, -968},
    { -128, 232, -952},
    { -120, 272, -960},
    { -160, 280, -976},
    { -160, 288, -936},
    { -128, 304, -872},
    { -152, 264, -896},
    // 81 seconds
    { -144, 216, -864},
    { -104, 240, -904},
    { -80, 296, -936},
    { -72, 328, -952},
    { -96, 392, -936},
    { -120, 520, -936},
    { -144, 480, -888},
    { -128, 424, -880},
    { -128, 416, -896},
    { -120, 448, -912},
    { -120, 432, -880},
    { -112, 464, -864},
    { -120, 456, -928},
    { -136, 552, -808},
    { -104, 528, -792},
    { -144, 632, -736},
    { -136, 656, -648},
    { -152, 680, -624},
    { -160, 696, -616},
    { -192, 736, -600},
    { -168, 696, -624},
    { -152, 680, -648},
    { -168, 688, -688},
    { -160, 664, -696},
    { -160, 592, -752},
    // 82 seconds
    { -152, 552, -808},
    { -152, 528, -832},
    { -144, 536, -808},
    { -144, 544, -784},
    { -144, 544, -808},
    { -136, 512, -840},
    { -152, 528, -840},
    { -144, 512, -840},
    { -120, 528, -816},
    { -120, 544, -840},
    { -136, 528, -840},
    { -128, 544, -856},
    { -104, 544, -856},
    { -104, 464, -832},
    { -128, 472, -808},
    { -128, 504, -872},
    { -160, 448, -856},
    { -184, 432, -808},
    { -192, 432, -792},
    { -200, 408, -768},
    { -184, 424, -784},
    { -144, 488, -840},
    { -136, 544, -832},
    { -136, 600, -832},
    { -144, 568, -816},
    // 83 seconds
    { -128, 536, -832},
    { -128, 496, -864},
    { -136, 480, -880},
    { -136, 496, -856},
    { -128, 512, -832},
    { -128, 504, -832},
    { -136, 496, -832},
    { -128, 496, -840},
    { -128, 496, -840},
    { -128, 496, -840},
    { -120, 488, -840},
    { -128, 496, -840},
    { -128, 488, -832},
    { -128, 488, -832},
    { -128, 488, -848},
    { -128, 480, -848},
    { -128, 488, -848},
    { -136, 488, -840},
    { -136, 472, -848},
    { -128, 480, -848},
    { -128, 472, -832},
    { -120, 472, -848},
    { -128, 464, -848},
    { -136, 496, -832},
    { -144, 520, -848},
    // 84 seconds
    { -128, 504, -880},
    { -88, 504, -912},
    { -48, 464, -904},
    { 24, 496, -904},
    { 216, 816, -768},
    { 256, 832, -672},
    { 208, 496, -584},
    { 168, 544, -440},
    { 64, 376, -256},
    { -48, 232, 0},
    { 64, 648, 40},
    { 56, 1344, -88},
    { 88, 912, -536},
    { 328, 1088, -320},
    { 488, 824, -312},
    { 800, 600, -552},
    { 1152, 696, -504},
    { 1120, 440, -440},
    { 1248, 488, -696},
    { 968, 136, -160},
    { 784, 456, -48},
    { 808, 616, 88},
    { 856, 640, -232},
    { 856, 160, -240},
    { 872, 192, -104},
    // 85 seconds
    { 848, 392, -16},
    { 832, 472, 0},
    { 744, 208, -160},
    { 1024, 304, -240},
    { 960, 472, 128},
    { 952, 288, 24},
    { 960, -56, 240},
    { 1168, 440, 104},
    { 840, 136, 56},
    { 520, 376, -272},
    { 824, 328, -104},
    { 936, 0, 200},
    { 888, 144, 360},
    { 984, -264, 784},
    { 1168, 16, 256},
    { 928, 464, -48},
    { 840, 208, -72},
    { 936, 144, -72},
    { 880, 216, -136},
    { 904, 360, -144},
    { 880, 376, -120},
    { 872, 224, -216},
    { 936, 488, -176},
    { 888, 432, -384},
    { 832, 400, -552},
    // 86 seconds
    { 840, 368, -440},
    { 664, 48, -424},
    { 560, 512, -272},
    { 624, 152, -240},
    { 776, -56, 24},
    { 992, -40, -96},
    { 1232, 536, -312},
    { 1048, 280, -64},
    { 680, 224, -184},
    { 728, 296, -480},
    { 1280, -8, 424},
    { 896, 304, 24},
    { 944, 328, -80},
    { 888, 184, -8},
    { 944, 128, 48},
    { 936, 288, 120},
    { 936, 280, 112},
    { 912, 88, 104},
    { 896, 176, -24},
    { 864, 144, 216},
    { 936, 192, 96},
    { 888, 200, 224},
    { 944, 192, -144},
    { 968, 112, -256},
    { 976, 328, -32},
    // 87 seconds
    { 896, 224, 192},
    { 864, 208, 56},
    { 904, 248, -24},
    { 912, 312, 56},
    { 840, 168, 16},
    { 848, -48, -112},
    { 936, 488, -112},
    { 880, 192, -48},
    { 888, 296, -184},
    { 888, 304, -120},
    { 888, 264, -80},
    { 872, 216, -104},
    { 872, 256, -128},
    { 864, 240, -112},
    { 872, 296, -112},
    { 856, 264, -160},
    { 936, 232, -40},
    { 880, 368, -112},
    { 888, 352, -320},
    { 1056, 344, -80},
    { 968, 264, -96},
    { 880, 272, 96},
    { 872, 240, 88},
    { 928, 280, 112},
    { 920, 264, 128},
    // 88 seconds
    { 896, 200, 16},
    { 880, 208, -32},
    { 888, 120, -104},
    { 920, 376, -192},
    { 928, 192, -152},
    { 904, 64, -152},
    { 992, 368, -200},
    { 1000, 192, -144},
    { 1000, 112, -192},
    { 1024, 336, -264},
    { 912, 376, -264},
    { 800, 320, -288},
    { 800, 520, -488},
    { 720, 816, -600},
    { 624, 984, -528},
    { 544, 1136, -512},
    { 504, 1016, -560},
    { 496, 648, -640},
    { 272, 488, -584},
    { 0, 472, -336},
    { -216, 416, -272},
    { -288, 824, -384},
    { -184, 512, -416},
    { -304, 360, -288},
    { -216, 208, -352},
    // 89 seconds
    { -80, -216, -688},
    { 184, 232, -1056},
    { 200, 32, -1080},
    { 192, -72, -992},
    { 120, -192, -968},
    { 128, -256, -968},
    { 152, -368, -1168},
    { 64, -160, -1120},
    { -8, -96, -1008},
    { -8, -168, -1064},
    { -16, -240, -1064},
    { 8, -200, -1000},
    { 24, -192, -1000},
    { 0, -200, -1016},
    { -16, -176, -1000},
    { -16, -216, -1000},
    { -16, -200, -1008},
    { -24, -200, -1008},
    { -24, -208, -1008},
    { -32, -184, -1008},
    { -32, -176, -1008},
    { -32, -200, -1008},
    { -40, -208, -1008},
    { -24, -176, -1008},
    { -32, -152, -1000},
    // 90 seconds
    { -40, -184, -1024},
    { -32, -152, -1080},
    { -8, -216, -1128},
    { 80, 200, -1216},
    { -128, 192, -912},
    { -176, 232, -800},
    { -176, 224, -864},
    { -216, 248, -888},
    { -216, 200, -776},
    { -184, 280, -944},
    { -224, 264, -1000},
    { -256, 344, -952},
    { -272, 328, -944},
    { -272, 264, -936},
    { -288, 320, -904},
    { -272, 360, -896},
    { -216, 416, -968},
    { -200, 336, -936},
    { -240, 368, -888},
    { -224, 288, -904},
    { -200, 328, -912},
    { -200, 328, -912},
    { -224, 336, -912},
    { -200, 232, -952},
    { -256, 328, -896},
    // 91 seconds
    { -248, 240, -896},
    { -208, 168, -984},
    { -208, 104, -952},
    { -176, 112, -992},
    { -192, 16, -984},
    { -168, 40, -968},
    { -168, 104, -1008},
    { -144, 144, -1040},
    { -192, 288, -952},
    { -184, 352, -888},
    { -224, 424, -880},
    { -216, 368, -888},
    { -200, 344, -880},
    { -216, 360, -904},
    { -192, 336, -928},
    { -160, 344, -952},
    { -136, 328, -968},
    { -104, 328, -1016},
    { -64, 392, -952},
    { -136, 584, -920},
    { -240, 640, -784},
    { -304, 752, -640},
    { -320, 792, -512},
    { -376, 888, -416},
    { -400, 752, -368},
    // 92 seconds
    { -416, 744, -208},
    { -432, 904, -256},
    { -424, 896, -208},
    { -432, 776, -8},
    { -416, 792, 40},
    { -400, 720, 160},
    { -368, 624, 272},
    { -328, 552, 360},
    { -328, 624, 424},
    { -344, 664, 488},
    { -360, 672, 568},
    { -384, 752, 552},
    { -392, 880, 488},
    { -464, 992, 376},
    { -504, 1056, 352},
    { -512, 1120, 456},
    { -480, 1280, 464},
    { -568, 1304, 328},
    { -648, 944, 104},
    { -608, 528, -152},
    { -608, 384, -312},
    { -648, 160, -448},
    { -640, -32, -504},
    { -584, 184, -568},
    { -440, 72, -760},
    // 93 seconds
    { -352, -120, -760},
    { -256, -152, -792},
    { -144, -32, -904},
    { -24, -96, -800},
    { 96, -216, -888},
    { 224, 0, -1088},
    { 344, 344, -1136},
    { 848, 808, -1320},
    { 408, 336, -1504},
    { 168, 624, -984},
    { -72, 480, -728},
    { -40, 496, -656},
    { -120, 216, -848},
    { -240, 160, -960},
    { -200, 120, -1072},
    { -120, 16, -1168},
    { -184, 208, -952},
    { -144, 456, -968},
    { -168, 424, -1024},
    { -216, 376, -896},
    { -248, 416, -872},
    { -272, 464, -920},
    { -256, 432, -872},
    { -272, 440, -808},
    { -280, 472, -808},
    // 94 seconds
    { -240, 568, -728},
    { -216, 608, -776},
    { -232, 552, -712},
    { -192, 576, -712},
    { -200, 664, -744},
    { -224, 632, -712},
    { -224, 696, -632},
    { -208, 680, -600},
    { -208, 736, -592},
    { -192, 784, -520},
    { -200, 792, -472},
    { -208, 824, -448},
    { -216, 824, -416},
    { -216, 856, -392},
    { -224, 872, -384},
    { -232, 832, -360},
    { -200, 872, -368},
    { -208, 904, -360},
    { -208, 888, -288},
    { -208, 904, -256},
    { -208, 896, -248},
    { -176, 896, -216},
    { -184, 880, -224},
    { -200, 968, -208},
    { -232, 912, -176},
    // 95 seconds
    { -208, 864, -224},
    { -240, 928, -192},
    { -224, 872, -192},
    { -224, 880, -240},
    { -192, 888, -232},
    { -184, 920, -264},
    { -184, 896, -272},
    { -200, 880, -224},
    { -200, 912, -224},
    { -200, 864, -200},
    { -208, 880, -216},
    { -216, 936, -224},
    { -192, 880, -248},
    { -176, 880, -264},
    { -176, 936, -280},
    { -168, 904, -216},
    { -144, 896, -336},
    { -200, 920, -328},
    { -248, 776, -232},
    { -224, 880, -304},
    { -240, 968, -312},
    { -288, 912, -256},
    { -264, 952, -232},
    { -288, 864, -272},
    { -248, 848, -320},
    // 96 seconds
    { -240, 888, -312},
    { -240, 832, -304},
    { -216, 824, -296},
    { -232, 832, -280},
    { -208, 880, -312},
    { -232, 856, -272},
    { -232, 856, -304},
    { -240, 880, -288},
    { -248, 888, -280},
    { -240, 872, -280},
    { -264, 888, -248},
    { -272, 888, -264},
    { -264, 872, -264},
    { -256, 872, -256},
    { -256, 872, -248},
    { -248, 880, -256},
    { -256, 896, -248},
    { -256, 880, -240},
    { -256, 888, -248},
    { -248, 896, -248},
    { -248, 880, -240},
    { -240, 872, -248},
    { -248, 896, -248},
    { -256, 888, -240},
    { -248, 872, -256},
    // 97 seconds
    { -248, 880, -240},
    { -248, 880, -240},
    { -248, 880, -240},
    { -248, 888, -232},
    { -256, 888, -240},
    { -256, 904, -240},
    { -264, 896, -224},
    { -240, 896, -224},
    { -248, 944, -224},
    { -232, 880, -280},
    { -240, 840, -312},
    { -232, 832, -360},
    { -264, 880, -352},
    { -224, 920, -392},
    { -256, 896, -376},
    { -264, 832, -352},
    { -296, 808, -352},
    { -304, 824, -360},
    { -280, 824, -400},
    { -200, 808, -432},
    { -192, 848, -472},
    { -160, 792, -576},
    { -176, 824, -568},
    { -152, 784, -552},
    { -120, 752, -624},
    // 98 seconds
    { -144, 712, -632},
    { -184, 664, -664},
    { -288, 720, -552},
    { -296, 1032, -568},
    { -424, 824, -496},
    { -456, 632, -416},
    { -392, 832, -536},
    { -328, 816, -776},
    { -240, 416, -832},
    { -160, 264, -760},
    { -72, 320, -808},
    { -64, 272, -1000},
    { -80, 48, -960},
    { -152, 504, -1008},
    { -224, 320, -920},
    { -144, 296, -904},
    { -152, 240, -848},
    { -72, 448, -816},
    { -56, 656, -864},
    { 16, 568, -904},
    { -56, 408, -800},
    { -64, 536, -784},
    { -120, 632, -560},
    { -144, 800, -296},
    { -96, 1184, -272},
    // 99 seconds
    { -216, 976, -120},
    { -264, 1024, 176},
    { -200, 1048, 48},
    { -240, 1008, 64},
    { -160, 1264, -304},
    { -160, 888, -368},
    { -184, 608, -448},
    { -216, 680, -632},
    { -296, 1144, -464},
    { -408, 872, -616},
    { -400, 680, -560},
    { -376, 768, -568},
    { -320, 520, -608},
    { -384, 464, -672},
    { -392, 400, -616},
    { -424, 296, -688},
    { -424, 216, -720},
    { -424, 136, -736},
    { -424, 72, -808},
    { -408, 72, -872},
    { -400, -16, -816},
    { -376, -72, -840},
    { -272, -24, -992},
    { -280, 56, -928},
    { -224, 16, -1080},
    // 100 seconds
    { -216, 56, -1040},
    { -216, 192, -1024},
    { -184, 352, -1160},
    { -240, 288, -984},
    { -264, 216, -1040},
    { -288, 176, -992},
    { -288, 96, -928},
    { -280, 136, -856},
    { -264, 256, -896},
    { -264, 328, -960},
    { -264, 256, -936},
    { -256, 264, -944},
    { -224, 248, -968},
    { -224, 216, -944},
    { -216, 224, -936},
    { -192, 264, -944},
    { -176, 240, -952},
    { -160, 288, -992},
    { -176, 288, -1000},
    { -192, 264, -1000},
    { -192, 272, -960},
    { -184, 288, -944},
    { -176, 296, -936},
    { -184, 312, -960},
    { -176, 280, -936},
    // 101 seconds
    { -176, 280, -944},
    { -176, 296, -944},
    { -176, 288, -936},
    { -192, 304, -928},
    { -184, 288, -960},
    { -176, 288, -952},
    { -192, 248, -944},
    { -200, 256, -976},
    { -224, 248, -992},
    { -184, 192, -1008},
    { -184, 200, -960},
    { -208, 152, -944},
    { -184, 144, -968},
    { -184, 120, -984},
    { -176, 8, -1040},
    { -184, 8, -1032},
    { -168, -56, -1000},
    { -152, -72, -1000},
    { -168, -112, -968},
    { -152, -144, -968},
    { -160, -112, -992},
    { -152, -144, -992},
    { -152, -168, -1000},
    { -160, -168, -992},
    { -144, -168, -1008},
    // 102 seconds
    { -136, -144, -1008},
    { -144, -152, -1000},
    { -152, -160, -984},
    { -152, -152, -984},
    { -152, -160, -1000},
    { -160, -152, -992},
    { -152, -144, -1008},
    { -144, -136, -1024},
    { -136, -136, -1024},
    { -136, -144, -1024},
    { -144, -152, -1000},
    { -120, -168, -1024},
    { -96, -192, -1032},
    { -64, -224, -1040},
    { -16, -288, -1080},
    { 24, -256, -1072},
    { 16, -48, -1112},
    { -8, 208, -1032},
    { -128, 320, -816},
    { -240, 544, -632},
    { -304, 696, -528},
    { -344, 736, -352},
    { -368, 720, -264},
    { -376, 776, -96},
    { -368, 824, -64},
    // 103 seconds
    { -376, 784, 16},
    { -336, 872, 96},
    { -352, 912, 136},
    { -368, 944, 88},
    { -368, 928, 104},
    { -336, 952, 24},
    { -320, 976, -72},
    { -384, 1008, -120},
    { -480, 1112, -208},
    { -552, 1184, -216},
    { -552, 1208, -72},
    { -656, 1056, 56},
    { -656, 880, 48},
    { -632, 712, -40},
    { -584, 744, -272},
    { -480, 952, -576},
    { -248, 568, -464},
    { -280, 64, -432},
    { -336, -80, -656},
    { -264, 80, -728},
    { -64, 112, -672},
    { 128, 176, -736},
    { 376, 280, -880},
    { 584, 320, -880},
    { 560, 304, -944},
    // 104 seconds
    { 472, 416, -968},
    { 360, 208, -952},
    { 440, 488, -1264},
    { 96, 472, -864},
    { 184, 544, -920},
    { 80, 520, -696},
    { 80, 536, -704},
    { 96, 496, -736},
    { 128, 544, -648},
    { 0, 424, -536},
    { 16, 664, -640},
    { 72, 600, -648},
    { -296, 1840, -1216},
    { -72, 240, -480},
    { -224, 656, -488},
    { -40, 992, -448},
    { -80, 800, -408},
    { -104, 928, -352},
    { -96, 872, -360},
    { -96, 880, -368},
    { -88, 872, -368},
    { -88, 872, -360},
    { -80, 880, -360},
    { -72, 856, -368},
    { -72, 888, -360},
    // 105 seconds
    { -80, 880, -376},
    { -72, 864, -384},
    { -80, 864, -376},
    { -72, 864, -376},
    { -72, 856, -376},
    { -72, 872, -376},
    { -80, 864, -368},
    { -72, 864, -376},
    { -56, 856, -384},
    { -64, 856, -384},
    { -56, 864, -384},
    { -64, 864, -384},
    { -56, 856, -384},
    { -56, 864, -384},
    { -56, 856, -376},
    { -56, 872, -376},
    { -56, 856, -384},
    { -56, 872, -376},
    { -56, 872, -376},
    { -56, 864, -376},
    { -56, 872, -376},
    { -56, 864, -376},
    { -56, 864, -368},
    { -56, 856, -376},
    { -56, 864, -384},
    // 106 seconds
    { -56, 856, -376},
    { -56, 864, -376},
    { -56, 864, -368},
    { -56, 864, -376},
    { -56, 856, -376},
    { -56, 864, -376},
    { -56, 864, -376},
    { -56, 856, -384},
    { -56, 864, -376},
    { -48, 864, -376},
    { -56, 864, -384},
    { -56, 864, -384},
    { -56, 864, -384},
    { -48, 856, -384},
    { -56, 864, -384},
    { -56, 864, -384},
    { -56, 864, -384},
    { -56, 872, -376},
    { -48, 856, -384},
    { -56, 864, -384},
    { -48, 864, -384},
    { -48, 864, -376},
    { -48, 864, -384},
    { -56, 864, -376},
    { -48, 864, -376},
    // 107 seconds
    { -48, 864, -384},
    { -56, 864, -384},
    { -56, 872, -376},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -376},
    { -48, 856, -384},
    { -48, 864, -384},
    { -48, 864, -376},
    { -48, 864, -384},
    { -48, 856, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 856, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -376},
    { -48, 864, -384},
    { -48, 856, -384},
    { -48, 872, -376},
    { -48, 864, -376},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    // 108 seconds
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 856, -384},
    { -48, 864, -384},
    { -48, 864, -376},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 856, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -392},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 856, -384},
    { -48, 864, -384},
    { -48, 856, -376},
    { -40, 856, -384},
    { -40, 864, -384},
    { -48, 864, -384},
    { -48, 864, -392},
    { -40, 856, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 864, -376},
    { -48, 864, -376},
    { -48, 864, -384},
    { -48, 864, -384},
    { -40, 864, -384},
    { -40, 856, -376},
    { -48, 864, -376},
    { -48, 864, -384},
    { -40, 856, -384},
    { -48, 864, -376},
    // 110 seconds
    { -40, 856, -384},
    { -48, 864, -376},
    { -48, 864, -384},
    { -48, 864, -376},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -40, 864, -376},
    { -48, 872, -384},
    { -40, 856, -384},
    { -48, 864, -384},
    { -48, 864, -376},
    { -40, 856, -384},
    { -48, 864, -384},
    { -40, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -48, 856, -384},
    { -40, 864, -384},
    { -48, 864, -384},
    { -48, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    // 111 seconds
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -48, 856, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -376},
    { -40, 872, -384},
    { -48, 864, -384},
    { -40, 864, -384},
    { -40, 864, -392},
    { -40, 864, -384},
    { -40, 864, -384},
    { -48, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    // 112 seconds
    { -40, 856, -384},
    { -48, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -48, 864, -384},
    { -40, 864, -392},
    { -32, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 856, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -40, 864, -376},
    { -40, 864, -392},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -32, 856, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -32, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 864, -392},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 856, -384},
    { -40, 856, -384},
    { -32, 872, -384},
    { -32, 864, -384},
    // 114 seconds
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 872, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 864, -376},
    { -40, 856, -392},
    { -32, 864, -384},
    { -40, 864, -384},
    { -32, 872, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 864, -392},
    { -40, 856, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -32, 864, -392},
    { -32, 864, -376},
    { -40, 856, -384},
    { -40, 864, -384},
    { -40, 856, -392},
    // 115 seconds
    { -40, 864, -384},
    { -32, 864, -384},
    { -40, 864, -384},
    { -32, 864, -376},
    { -32, 864, -384},
    { -40, 872, -384},
    { -40, 872, -384},
    { -32, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -32, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -376},
    { -32, 856, -384},
    { -32, 864, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -40, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -40, 856, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -40, 864, -384},
    { -32, 864, -384},
    { -40, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -40, 864, -376},
    { -32, 864, -376},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -40, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    // 117 seconds
    { -40, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 864, -384},
    { -32, 856, -392},
    { -40, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -40, 864, -384},
    { -32, 864, -384},
    { -32, 864, -376},
    { -32, 856, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 872, -376},
    { -32, 864, -384},
    { -32, 864, -392},
    // 118 seconds
    { -32, 864, -384},
    { -32, 856, -392},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 864, -384},
    { -40, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -24, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 864, -384},
    { -40, 864, -384},
    { -40, 856, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 856, -384},
    { -32, 856, -384},
    // 119 seconds
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -392},
    { -32, 864, -392},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -392},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -40, 864, -384},
    { -32, 856, -384},
    { -32, 864, -384},
    { -32, 856, -392},
    { -32, 864, -384},
    { -32, 864, -384},
    // 120 seconds
    // elapsed: 2 minutes
    { -32, 856, -384},
    { -32, 864, -384},
    { -40, 864, -384},
    { -32, 864, -376},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -376},
    { -32, 856, -384},
    { -32, 864, -392},
    { -32, 864, -392},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -376},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 864, -384},
    { -24, 864, -384},
    { -32, 864, -384},
    // 121 seconds
    { -32, 856, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -24, 864, -392},
    { -32, 856, -384},
    { -32, 856, -384},
    { -32, 856, -384},
    // 122 seconds
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -392},
    { -32, 864, -384},
    { -32, 856, -392},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 856, -392},
    { -32, 872, -384},
    { -32, 856, -384},
    { -32, 864, -392},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 864, -392},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 856, -384},
    { -32, 864, -392},
    // 123 seconds
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -24, 856, -384},
    { -24, 864, -392},
    { -32, 864, -392},
    { -32, 856, -384},
    { -32, 856, -384},
    { -32, 856, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 856, -384},
    { -24, 864, -384},
    { -32, 864, -392},
    { -32, 864, -392},
    { -32, 856, -384},
    { -32, 856, -392},
    { -32, 864, -384},
    { -32, 864, -392},
    { -32, 864, -384},
    { -32, 864, -392},
    { -24, 856, -384},
    { -32, 864, -384},
    // 124 seconds
    { -24, 856, -392},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -392},
    { -24, 856, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -392},
    { -32, 864, -392},
    { -32, 864, -384},
    { -32, 864, -392},
    { -32, 856, -392},
    { -32, 856, -384},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 864, -392},
    { -32, 864, -384},
    { -32, 864, -384},
    { -32, 856, -392},
    { -32, 856, -392},
    { -24, 856, -392},
    { -24, 864, -384},
    { -24, 856, -392},
    { -32, 856, -392},
    { -24, 872, -384},
    // 125 seconds
    { -24, 864, -392},
    { -32, 856, -384},
    { -32, 864, -392},
    { -32, 864, -384},
    { -32, 864, -392},
    { -32, 864, -392},
    { -24, 856, -384},
    { -24, 864, -392},
    { -32, 864, -392},
    { -32, 856, -392},
    { -32, 864, -392},
    { -32, 864, -384},
    { -24, 856, -384},
    { -32, 856, -392},
    { -32, 856, -384},
    { -24, 864, -376},
    { -24, 848, -392},
    { -24, 856, -384},
    { -32, 864, -392},
    { -24, 856, -384},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 864, -384},
    { -24, 864, -384},
    { -32, 856, -384},
    // 126 seconds
    { -32, 864, -384},
    { -24, 856, -392},
    { -32, 864, -384},
    { -32, 856, -392},
    { -32, 856, -384},
    { -32, 864, -392},
    { -24, 856, -384},
    { -32, 856, -384},
    { -24, 856, -392},
    { -32, 856, -384},
    { -32, 856, -384},
    { -24, 864, -384},
    { -32, 856, -384},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 864, -384},
    { -32, 864, -392},
    { -24, 856, -384},
    { -32, 864, -384},
    { -32, 856, -384},
    { -32, 856, -384},
    { -32, 856, -384},
    { -24, 864, -392},
    { -32, 864, -392},
    { -32, 856, -384},
    // 127 seconds
    { -24, 856, -384},
    { -32, 864, -384},
    { -32, 856, -392},
    { -32, 864, -384},
    { -24, 864, -392},
    { -32, 856, -392},
    { -32, 864, -384},
    { -32, 864, -392},
    { -32, 856, -392},
    { -32, 864, -392},
    { -24, 856, -384},
    { -32, 856, -392},
    { -32, 856, -392},
    { -24, 864, -384},
    { -32, 856, -392},
    { -32, 856, -384},
    { -32, 864, -392},
    { -32, 864, -392},
    { -32, 856, -392},
    { -24, 864, -384},
    { -32, 864, -392},
    { -24, 856, -392},
    { -24, 864, -384},
    { -32, 856, -384},
    { -24, 864, -392},
    { -24, 864, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 864, -384},
    { -24, 856, -392},
    { -24, 864, -384},
    { -24, 864, -392},
    { -24, 856, -384},
    { -24, 856, -392},
    { -32, 856, -392},
    { -24, 856, -384},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 864, -384},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -384},
    { -24, 864, -384},
    { -24, 864, -384},
    // 129 seconds
    { -24, 856, -400},
    { -24, 856, -384},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    { -32, 856, -392},
    { -32, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 864, -392},
    { -24, 856, -392},
    { -24, 856, -384},
    { -24, 864, -392},
    { -32, 864, -392},
    { -24, 864, -392},
    { -32, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 864, -384},
    { -32, 856, -392},
    { -24, 856, -392},
    { -32, 864, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -384},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 864, -400},
    { -32, 856, -384},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    { -32, 856, -392},
    { -24, 864, -392},
    { -32, 856, -392},
    { -24, 856, -384},
    { -32, 864, -384},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -384},
    // 131 seconds
    { -24, 864, -392},
    { -24, 864, -392},
    { -24, 864, -384},
    { -24, 864, -392},
    { -32, 856, -392},
    { -24, 856, -384},
    { -32, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -32, 864, -392},
    { -24, 856, -392},
    { -32, 864, -392},
    { -32, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -32, 864, -384},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -32, 864, -392},
    { -24, 864, -392},
    { -24, 864, -392},
    { -32, 856, -392},
    { -32, 864, -392},
    { -32, 856, -400},
    { -24, 848, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    { -24, 856, -384},
    { -24, 864, -392},
    { -24, 856, -392},
    { -32, 864, -392},
    { -32, 856, -376},
    { -32, 864, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 864, -392},
    { -24, 856, -392},
    // 133 seconds
    { -24, 864, -392},
    { -24, 856, -400},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -32, 872, -392},
    { -32, 864, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    // 134 seconds
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 864, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    { -24, 856, -392},
    { -16, 856, -392},
    { -32, 856, -392},
    { -24, 856, -400},
    // 135 seconds
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 864, -392},
    { -24, 864, -392},
    { -24, 864, -384},
    { -32, 864, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -400},
    { -24, 864, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 864, -392},
    { -24, 856, -400},
    { -24, 864, -400},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    // 136 seconds
    { -24, 864, -392},
    { -24, 864, -392},
    { -24, 864, -392},
    { -24, 856, -400},
    { -24, 864, -392},
    { -24, 856, -392},
    { -32, 864, -392},
    { -32, 856, -400},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    { -24, 856, -392},
    { -32, 856, -400},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 848, -400},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 848, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 864, -392},
    // 137 seconds
    { -32, 856, -392},
    { -24, 856, -400},
    { -16, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 848, -392},
    { -24, 864, -392},
    { -32, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    // 138 seconds
    { -24, 864, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 864, -392},
    { -24, 864, -400},
    { -32, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    // 139 seconds
    { -24, 856, -384},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 864, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -16, 856, -392},
    { -24, 856, -400},
    { -24, 856, -408},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -32, 856, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 864, -400},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    { -16, 856, -392},
    { -24, 864, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 864, -400},
    { -24, 856, -392},
    // 141 seconds
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 864, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 848, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 856, -392},
    { -24, 864, -400},
    { -24, 856, -392},
    { -24, 856, -392},
    { -24, 856, -400},
    { -24, 856, -400},
    { -24, 848, -400},
    { -24, 856, -392},
    { -24, 856, -400},
    // 142 seconds
    { -24, 856, -392},
    { -32, 856, -392},
    { -24, 856, -392},
    { -24, 864, -392},
    { -24, 856, -392},
    { -32, 856, -392},
    { -32, 864, -384},
    { -40, 872, -376},
    { -48, 856, -368},
    { -48, 864, -368},
    { -48, 864, -360},
    { -56, 872, -344},
    { -56, 888, -336},
    { -56, 864, -352},
    { -56, 880, -336},
    { -64, 888, -320},
    { -72, 888, -320},
    { -72, 896, -328},
    { -64, 880, -328},
    { -64, 888, -328},
    { -72, 888, -312},
    { -72, 872, -320},
    { -64, 880, -328},
    { -64, 904, -328},
    { -64, 912, -312},
    // 143 seconds
    { -64, 888, -328},
    { -56, 888, -336},
    { -64, 880, -336},
    { -56, 888, -336},
    { -56, 904, -328},
    { -48, 856, -352},
    { -48, 848, -392},
    { -56, 872, -352},
    { -40, 872, -360},
    { -48, 872, -360},
    { -64, 864, -344},
    { -64, 888, -336},
    { -56, 856, -352},
    { -56, 872, -352},
    { -64, 880, -336},
    { -72, 888, -336},
    { -64, 872, -328},
    { -56, 896, -320},
    { -56, 888, -328},
    { -64, 912, -328},
    { -64, 928, -288},
    { -56, 856, -304},
    { -56, 896, -304},
    { -72, 912, -264},
    { -88, 944, -232},
    // 144 seconds
    { -96, 904, -136},
    { -112, 928, -120},
    { -112, 928, -112},
    { -120, 928, -96},
    { -128, 928, -72},
    { -120, 936, -32},
    { -120, 928, 8},
    { -144, 896, 56},
    { -144, 936, 32},
    { -136, 912, 48},
    { -144, 928, 48},
    { -152, 928, 96},
    { -152, 920, 136},
    { -168, 912, 168},
    { -152, 864, 168},
    { -152, 920, 136},
    { -152, 912, 136},
    { -152, 896, 160},
    { -144, 912, 144},
    { -152, 912, 152},
    { -160, 904, 152},
    { -152, 880, 136},
    { -160, 912, 160},
    { -160, 920, 144},
    { -176, 912, 112},
    // 145 seconds
    { -160, 936, 136},
    { -152, 936, 136},
    { -160, 920, 136},
    { -152, 936, 128},
    { -168, 928, 160},
    { -176, 880, 168},
    { -152, 920, 136},
    { -136, 920, 144},
    { -152, 904, 152},
    { -152, 920, 136},
    { -152, 904, 144},
    { -160, 912, 144},
    { -168, 912, 176},
    { -160, 904, 160},
    { -160, 912, 168},
    { -160, 920, 168},
    { -152, 912, 168},
    { -152, 904, 160},
    { -160, 912, 160},
    { -168, 912, 192},
    { -160, 904, 160},
    { -160, 912, 160},
    { -160, 920, 160},
    { -152, 912, 168},
    { -160, 912, 160},
    // 146 seconds
    { -152, 912, 152},
    { -168, 912, 160},
    { -160, 912, 160},
    { -160, 904, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 920, 152},
    { -160, 912, 160},
    { -160, 904, 160},
    { -160, 912, 168},
    { -152, 904, 160},
    { -160, 912, 152},
    { -160, 912, 160},
    { -160, 904, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -168, 912, 152},
    { -160, 904, 152},
    { -160, 912, 160},
    { -160, 912, 160},
    { -168, 920, 152},
    { -160, 912, 160},
    { -160, 904, 168},
    { -160, 904, 160},
    // 147 seconds
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -152, 904, 160},
    { -160, 904, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -168, 912, 160},
    { -160, 920, 160},
    { -160, 912, 152},
    { -168, 912, 160},
    { -160, 912, 160},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 904, 160},
    { -160, 912, 152},
    { -160, 912, 160},
    { -160, 920, 152},
    { -152, 904, 152},
    { -160, 912, 152},
    { -160, 920, 160},
    // 148 seconds
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 904, 160},
    { -152, 912, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -168, 912, 160},
    { -160, 912, 160},
    { -152, 912, 160},
    { -160, 912, 152},
    { -152, 912, 152},
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 912, 152},
    { -168, 912, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -168, 912, 160},
    { -152, 912, 160},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 912, 152},
    // 149 seconds
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 912, 152},
    { -160, 912, 160},
    { -160, 912, 152},
    { -160, 904, 160},
    { -160, 912, 152},
    { -160, 912, 160},
    { -152, 912, 152},
    { -160, 904, 160},
    { -160, 912, 152},
    { -160, 912, 160},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 152},
    { -168, 912, 152},
    { -160, 912, 160},
    { -160, 920, 152},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 168},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 920, 160},
    { -160, 912, 160},
    // 150 seconds
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 144},
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 912, 152},
    { -152, 904, 160},
    { -152, 912, 152},
    { -160, 912, 152},
    { -168, 912, 152},
    { -160, 912, 160},
    { -160, 912, 152},
    { -160, 912, 160},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 152},
    { -152, 912, 152},
    { -160, 912, 152},
    { -160, 912, 152},
    { -168, 912, 144},
    { -152, 912, 152},
    { -160, 912, 144},
    { -160, 920, 144},
    { -160, 920, 144},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 144},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 152},
    { -152, 920, 144},
    { -160, 912, 152},
    { -160, 912, 160},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 920, 160},
    { -160, 920, 144},
    { -152, 912, 144},
    { -160, 912, 152},
    { -160, 912, 144},
    { -160, 912, 152},
    { -160, 912, 144},
    { -152, 912, 144},
    { -160, 912, 144},
    { -160, 912, 152},
    { -160, 920, 144},
    { -160, 920, 144},
    { -160, 912, 152},
    { -152, 920, 144},
    { -160, 920, 144},
    // 152 seconds
    { -160, 912, 144},
    { -152, 912, 144},
    { -152, 912, 144},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 920, 152},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 136},
    { -152, 920, 144},
    { -152, 912, 136},
    { -160, 912, 152},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 152},
    { -160, 912, 144},
    { -160, 912, 144},
    // 153 seconds
    { -160, 920, 152},
    { -160, 912, 144},
    { -160, 920, 144},
    { -160, 912, 152},
    { -160, 912, 152},
    { -160, 912, 136},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 152},
    { -160, 912, 144},
    { -160, 920, 144},
    { -160, 920, 144},
    { -160, 912, 144},
    { -160, 912, 136},
    { -160, 912, 144},
    { -168, 920, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -152, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    // 154 seconds
    { -160, 912, 136},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 920, 144},
    { -160, 920, 144},
    { -160, 912, 136},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 920, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 912, 136},
    { -168, 912, 136},
    { -152, 920, 136},
    { -160, 912, 144},
    { -160, 912, 152},
    { -152, 920, 144},
    { -160, 912, 136},
    { -160, 912, 144},
    { -168, 912, 136},
    { -160, 912, 144},
    // 155 seconds
    { -160, 912, 136},
    { -160, 920, 136},
    { -152, 912, 136},
    { -160, 920, 136},
    { -160, 920, 144},
    { -160, 912, 144},
    { -160, 912, 136},
    { -160, 920, 136},
    { -152, 912, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 920, 136},
    { -160, 920, 128},
    { -152, 920, 136},
    { -152, 920, 128},
    { -160, 912, 136},
    { -160, 912, 128},
    { -160, 912, 128},
    // 156 seconds
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 920, 128},
    { -160, 912, 136},
    { -152, 920, 128},
    { -152, 912, 136},
    { -160, 920, 128},
    { -160, 920, 136},
    { -152, 912, 136},
    { -160, 920, 136},
    { -160, 920, 128},
    { -160, 920, 144},
    { -152, 912, 136},
    { -160, 920, 128},
    { -160, 912, 128},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 912, 144},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 920, 136},
    { -152, 920, 136},
    // 157 seconds
    { -152, 920, 128},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -152, 920, 128},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -168, 912, 128},
    { -160, 912, 128},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 912, 128},
    { -152, 912, 136},
    { -160, 912, 128},
    { -160, 912, 128},
    { -160, 920, 136},
    { -160, 920, 128},
    { -160, 912, 144},
    { -160, 912, 128},
    { -160, 920, 128},
    { -160, 912, 136},
    { -160, 912, 136},
    // 158 seconds
    { -160, 920, 128},
    { -152, 912, 136},
    { -168, 912, 136},
    { -160, 912, 128},
    { -160, 912, 136},
    { -152, 912, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 912, 128},
    { -160, 912, 128},
    { -160, 912, 136},
    { -160, 920, 128},
    { -152, 920, 136},
    { -152, 920, 136},
    { -160, 920, 128},
    { -152, 920, 128},
    { -160, 920, 136},
    { -160, 920, 136},
    { -152, 928, 128},
    { -152, 912, 136},
    { -152, 912, 136},
    { -152, 912, 128},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 920, 136},
    // 159 seconds
    { -160, 912, 136},
    { -160, 912, 136},
    { -152, 920, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -152, 912, 136},
    { -160, 912, 128},
    { -160, 912, 136},
    { -152, 912, 136},
    { -152, 912, 128},
    { -152, 920, 128},
    { -160, 912, 128},
    { -160, 904, 128},
    { -152, 920, 128},
    { -152, 920, 128},
    { -168, 920, 136},
    { -152, 912, 128},
    { -160, 920, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 920, 136},
    { -152, 912, 128},
    { -152, 920, 136},
    // 160 seconds
    { -160, 920, 136},
    { -160, 912, 128},
    { -160, 920, 128},
    { -160, 920, 144},
    { -152, 920, 128},
    { -160, 920, 136},
    { -160, 920, 128},
    { -152, 912, 128},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -152, 912, 136},
    { -160, 920, 144},
    { -160, 920, 128},
    { -160, 920, 136},
    { -152, 912, 128},
    { -160, 920, 128},
    { -160, 920, 136},
    { -160, 920, 136},
    { -152, 912, 136},
    { -160, 912, 128},
    { -160, 920, 136},
    { -160, 912, 136},
    { -152, 912, 128},
    { -160, 912, 128},
    // 161 seconds
    { -160, 912, 136},
    { -152, 912, 136},
    { -152, 920, 136},
    { -160, 920, 128},
    { -160, 912, 128},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 920, 128},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 912, 128},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 920, 128},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 920, 128},
    { -160, 920, 128},
    { -160, 912, 128},
    { -160, 920, 136},
    // 162 seconds
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -152, 912, 136},
    { -160, 912, 128},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 920, 136},
    { -168, 912, 136},
    { -160, 912, 136},
    { -152, 920, 128},
    { -160, 912, 136},
    { -152, 920, 136},
    { -160, 912, 136},
    { -152, 912, 128},
    { -160, 920, 128},
    { -160, 912, 136},
    { -152, 920, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    // 163 seconds
    { -160, 920, 128},
    { -160, 912, 136},
    { -160, 920, 128},
    { -160, 912, 128},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 920, 128},
    { -160, 912, 136},
    { -152, 920, 136},
    { -160, 912, 128},
    { -160, 912, 144},
    { -160, 912, 136},
    { -160, 920, 136},
    { -160, 920, 136},
    { -160, 912, 128},
    { -152, 920, 128},
    { -160, 912, 136},
    { -152, 912, 128},
    { -152, 920, 136},
    { -160, 912, 128},
    { -160, 912, 144},
    { -160, 920, 120},
    { -160, 920, 128},
    { -160, 920, 128},
    // 164 seconds
    { -168, 912, 136},
    { -160, 920, 128},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 920, 128},
    { -160, 912, 128},
    { -160, 912, 136},
    { -160, 920, 128},
    { -160, 912, 128},
    { -160, 920, 136},
    { -160, 920, 128},
    { -152, 912, 128},
    { -160, 912, 128},
    { -160, 920, 128},
    { -160, 920, 128},
    { -152, 912, 128},
    { -152, 912, 128},
    { -160, 920, 136},
    { -160, 920, 136},
    { -160, 920, 128},
    { -160, 920, 128},
    { -152, 920, 128},
    { -160, 920, 128},
    { -152, 920, 128},
    { -160, 896, 136},
    // 165 seconds
    { -168, 920, 136},
    { -168, 920, 136},
    { -168, 928, 144},
    { -160, 912, 136},
    { -160, 912, 160},
    { -152, 904, 128},
    { -168, 912, 144},
    { -160, 912, 136},
    { -160, 912, 144},
    { -160, 920, 152},
    { -160, 920, 136},
    { -168, 920, 136},
    { -168, 904, 144},
    { -160, 904, 152},
    { -168, 904, 152},
    { -168, 912, 160},
    { -176, 912, 168},
    { -168, 912, 160},
    { -168, 912, 160},
    { -160, 920, 160},
    { -160, 912, 152},
    { -160, 912, 160},
    { -168, 912, 160},
    { -168, 912, 160},
    { -168, 912, 160},
    // 166 seconds
    { -160, 912, 160},
    { -160, 912, 160},
    { -160, 904, 160},
    { -160, 904, 160},
    { -168, 904, 168},
    { -168, 904, 168},
    { -168, 920, 168},
    { -168, 912, 168},
    { -168, 912, 160},
    { -168, 912, 168},
    { -168, 912, 168},
    { -160, 904, 176},
    { -168, 912, 168},
    { -168, 920, 168},
    { -168, 904, 176},
    { -168, 912, 176},
    { -160, 912, 184},
    { -160, 904, 176},
    { -160, 912, 176},
    { -160, 904, 184},
    { -160, 896, 176},
    { -160, 904, 176},
    { -168, 904, 184},
    { -160, 904, 192},
    { -160, 912, 168},
    // 167 seconds
    { -160, 904, 168},
    { -160, 912, 176},
    { -160, 904, 184},
    { -160, 904, 176},
    { -160, 904, 176},
    { -160, 912, 176},
    { -160, 904, 176},
    { -160, 904, 184},
    { -160, 912, 176},
    { -160, 912, 176},
    { -160, 912, 176},
    { -160, 912, 176},
    { -160, 904, 176},
    { -168, 904, 184},
    { -168, 912, 184},
    { -160, 904, 176},
    { -160, 912, 184},
    { -160, 904, 176},
    { -168, 904, 192},
    { -168, 912, 176},
    { -168, 904, 176},
    { -160, 904, 184},
    { -160, 912, 184},
    { -168, 912, 176},
    { -160, 904, 184},
    { -160, 904, 184},
    { -160, 904, 176},
    { -160, 912, 176},
    { -168, 904, 184},
    { -168, 912, 176},
    { -160, 904, 176},
    { -160, 912, 176},
    { -160, 904, 176},
    { -160, 904, 176},
    { -160, 904, 176},
    { -160, 904, 176},
    { -160, 912, 184},
    { -168, 912, 176},
    { -160, 904, 176},
    { -168, 912, 176},
    { -168, 912, 184},
    { -160, 912, 176},
    { -160, 904, 176},
    { -168, 904, 176},
    { -160, 912, 184},
    { -160, 904, 176},
    { -160, 904, 176},
    { -160, 904, 184},
    { -160, 912, 184},
    { -160, 904, 176},
    { -160, 904, 176},
    { -160, 904, 176},
    { -160, 904, 176},
    { -160, 912, 184},
    { -160, 904, 176},
    { -160, 904, 184},
    { -168, 912, 176},
    { -160, 904, 176},
    { -160, 912, 176},
    { -168, 912, 176},
    { -168, 904, 176},
    { -160, 904, 184},
    { -160, 904, 176},
    { -160, 904, 168},
    { -160, 912, 184},
    { -168, 904, 184},
    { -168, 912, 184},
    { -160, 912, 168},
    { -168, 904, 168},
    { -160, 904, 184},
    { -160, 912, 192},
    { -168, 904, 176},
    { -168, 912, 176},
    { -160, 904, 184},
    { -168, 904, 184},
    // 170 seconds
    { -168, 912, 184},
    { -168, 912, 176},
    { -168, 904, 168},
    { -160, 904, 176},
    { -160, 912, 168},
    { -168, 912, 160},
    { -176, 912, 168},
    { -160, 912, 168},
    { -152, 904, 160},
    { -160, 912, 152},
    { -160, 912, 168},
    { -144, 904, 168},
    { -160, 912, 176},
    { -160, 904, 160},
    { -176, 928, 184},
    { -184, 912, 184},
    { -160, 904, 184},
    { -160, 912, 176},
    { -176, 912, 176},
    { -168, 904, 160},
    { -168, 912, 176},
    { -160, 912, 192},
    { -176, 912, 192},
    { -160, 912, 144},
    { -160, 912, 120},
    // 171 seconds
    { -152, 920, 128},
    { -176, 920, 144},
    { -168, 912, 128},
    { -160, 920, 120},
    { -152, 912, 136},
    { -168, 920, 128},
    { -168, 920, 104},
    { -168, 920, 128},
    { -144, 912, 120},
    { -160, 920, 112},
    { -152, 920, 120},
    { -176, 904, 136},
    { -152, 912, 104},
    { -168, 920, 128},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 912, 144},
    { -152, 920, 144},
    { -168, 912, 144},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 920, 128},
    { -168, 912, 136},
    // 172 seconds
    { -152, 912, 144},
    { -168, 920, 144},
    { -152, 912, 128},
    { -160, 920, 128},
    { -168, 912, 136},
    { -160, 920, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -160, 912, 128},
    { -168, 912, 136},
    { -152, 912, 144},
    { -160, 912, 136},
    { -152, 912, 136},
    { -160, 920, 136},
    { -168, 912, 136},
    { -152, 920, 136},
    { -152, 912, 136},
    { -168, 912, 136},
    { -160, 920, 144},
    { -168, 912, 144},
    { -168, 912, 128},
    { -168, 920, 136},
    { -160, 920, 136},
    { -152, 920, 136},
    { -168, 912, 128},
    // 173 seconds
    { -168, 912, 136},
    { -152, 912, 136},
    { -152, 912, 136},
    { -160, 912, 152},
    { -168, 920, 136},
    { -152, 920, 136},
    { -160, 912, 144},
    { -168, 912, 136},
    { -168, 912, 136},
    { -160, 912, 144},
    { -160, 912, 144},
    { -152, 904, 136},
    { -168, 920, 136},
    { -152, 912, 136},
    { -160, 912, 136},
    { -160, 912, 136},
    { -168, 912, 136},
    { -160, 912, 136},
    { -152, 920, 136},
    { -160, 920, 136},
    { -176, 912, 152},
    { -168, 912, 160},
    { -160, 904, 160},
    { -168, 912, 160},
    { -168, 912, 168},
    // 174 seconds
    { -160, 912, 152},
    { -168, 912, 168},
    { -160, 912, 168},
    { -168, 904, 176},
    { -168, 904, 168},
    { -168, 904, 168},
    { -160, 912, 168},
    { -168, 912, 168},
    { -168, 912, 168},
    { -160, 904, 160},
    { -160, 912, 160},
    { -168, 912, 160},
    { -160, 912, 152},
    { -168, 912, 176},
    { -160, 904, 168},
    { -168, 920, 152},
    { -176, 912, 152},
    { -160, 912, 160},
    { -168, 904, 160},
    { -168, 912, 160},
    { -160, 904, 168},
    { -160, 912, 160},
    { -160, 904, 176},
    { -168, 912, 168},
    { -160, 912, 160},
    // 175 seconds
    { -160, 912, 168},
    { -160, 912, 168},
    { -168, 904, 168},
    { -168, 912, 168},
    { -160, 904, 168},
    { -160, 912, 176},
    { -168, 912, 176},
    { -184, 904, 176},
    { -168, 912, 184},
    { -152, 912, 168},
    { -152, 904, 144},
    { -160, 912, 168},
    { -176, 912, 176},
    { -176, 904, 176},
    { -168, 912, 160},
    { -168, 904, 160},
    { -168, 912, 176},
    { -160, 904, 168},
    { -168, 904, 176},
    { -168, 904, 176},
    { -160, 912, 176},
    { -160, 912, 168},
    { -168, 912, 176},
    { -176, 904, 176},
    { -160, 912, 176},
    // 176 seconds
    { -160, 912, 168},
    { -168, 904, 176},
    { -168, 912, 168},
    { -160, 912, 176},
    { -168, 912, 176},
    { -168, 904, 160},
    { -168, 912, 168},
    { -168, 904, 176},
    { -160, 904, 176},
    { -168, 904, 168},
    { -160, 912, 176},
    { -168, 912, 176},
    { -160, 904, 168},
    { -160, 904, 168},
    { -176, 912, 168},
    { -160, 904, 168},
    { -160, 912, 176},
    { -168, 904, 168},
    { -168, 904, 168},
    { -160, 904, 176},
    { -168, 912, 176},
    { -160, 904, 184},
    { -160, 904, 176},
    { -168, 904, 184},
    { -168, 904, 168},
    // 177 seconds
    { -160, 912, 168},
    { -168, 904, 176},
    { -168, 904, 168},
    { -168, 912, 168},
    { -168, 912, 168},
    { -160, 904, 168},
    { -168, 904, 168},
    { -168, 912, 176},
    { -168, 912, 168},
    { -168, 912, 168},
    { -160, 912, 168},
    { -160, 904, 176},
    { -160, 912, 168},
    { -160, 912, 168},
    { -168, 912, 176},
    { -168, 912, 168},
    { -168, 912, 176},
    { -160, 912, 160},
    { -160, 904, 168},
    { -168, 912, 168},
    { -168, 912, 176},
    { -168, 912, 168},
    { -160, 912, 160},
    { -168, 912, 168},
    { -168, 912, 184},
    // 178 seconds
    { -160, 904, 176},
    { -160, 928, 168},
    { -160, 912, 176},
    { -168, 904, 176},
    { -168, 912, 168},
    { -168, 912, 168},
    { -160, 912, 168},
    { -168, 912, 176},
    { -160, 912, 176},
    { -168, 912, 168},
    { -168, 912, 168},
    { -160, 912, 168},
    { -160, 904, 168},
    { -168, 912, 168},
    { -168, 912, 168},
    { -160, 912, 168},
    { -168, 912, 168},
    { -168, 904, 168},
    { -160, 912, 160},
    { -160, 912, 168},
    { -168, 912, 168},
    { -168, 912, 176},
    { -160, 912, 168},
    { -160, 904, 160},
    { -160, 912, 168},
    // 179 seconds
    { -160, 904, 168},
    { -168, 904, 168},
    { -168, 912, 168},
    { -160, 912, 168},
    { -160, 912, 168},
    { -168, 912, 176},
    { -160, 912, 168},
    { -160, 912, 160},
    { -160, 912, 160},
    { -168, 912, 168},
    { -168, 904, 168},
    { -160, 904, 168},
    { -160, 912, 160},
    { -160, 912, 168},
    { -160, 912, 168},
    { -160, 912, 168},
    { -160, 912, 160},
    { -168, 912, 168},
    { -160, 904, 160},
    { -160, 912, 160},
    { -168, 912, 168},
    { -168, 912, 160},
    { -160, 912, 160},
    { -168, 912, 160},
    { -168, 904, 168},
    // 180 seconds
    // elapsed: 3 minutes
    { -160, 912, 152},
    { -160, 912, 160},
    { -168, 904, 160},
    { -168, 912, 160},
    { -168, 912, 152},
    { -168, 912, 152},
    { -160, 912, 160},
    { -168, 912, 160},
    { -168, 912, 160},
    { -168, 912, 160},
    { -168, 912, 160},
    { -160, 912, 152},
    { -160, 912, 160},
    { -168, 912, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -168, 920, 176},
    { -168, 904, 160},
    { -160, 904, 152},
    { -168, 912, 160},
    { -160, 912, 160},
    { -160, 912, 160},
    { -168, 912, 152},
    { -168, 912, 152},
    { -160, 912, 152},
    { -160, 912, 152},
    { -168, 904, 152},
    { -168, 912, 160},
    { -168, 912, 160},
    { -160, 912, 160},
    { -160, 912, 152},
    { -160, 920, 152},
    { -160, 904, 144},
    { -160, 912, 152},
    { -160, 920, 152},
    { -160, 912, 144},
    { -152, 904, 120},
    { -160, 912, 144},
    { -168, 928, 152},
    { -160, 912, 128},
    { -160, 912, 136},
    { -160, 920, 152},
    { -168, 920, 136},
    { -160, 920, 120},
    { -160, 912, 136},
    { -152, 904, 136},
    { -152, 904, 136},
    { -160, 920, 152},
    { -160, 920, 144},
    { -168, 920, 136},
    // 182 seconds
    { -160, 920, 144},
    { -160, 912, 144},
    { -160, 912, 144},
    { -152, 912, 144},
    { -160, 912, 136},
    { -160, 912, 144},
    { -160, 912, 144},
    { -160, 920, 152},
    { -160, 920, 136},
    { -168, 920, 120},
    { -152, 920, 120},
    { -152, 936, 128},
    { -144, 920, 184},
    { -120, 944, 264},
    { -112, 1416, 224},
    { -72, 1472, -40},
    { -136, 1072, 88},
    { -96, 1008, 184},
    { 56, 912, 32},
    { 112, 832, -192},
    { 96, 512, -408},
    { 88, 384, -736},
    { -40, 72, -616},
    { -152, 120, -1128},
    { -176, 216, -1192},
    // 183 seconds
    { -360, 88, -872},
    { -112, 504, -1408},
    { -144, 328, -1256},
    { -136, 192, -1016},
    { -144, 264, -1088},
    { -168, 120, -960},
    { -136, 16, -976},
    { -72, -64, -1040},
    { -80, -112, -1016},
    { -32, -144, -992},
    { -32, -160, -984},
    { -8, -112, -960},
    { 0, -136, -960},
    { -8, -152, -984},
    { 0, -216, -984},
    { 16, -304, -952},
    { 32, -304, -968},
    { 32, -336, -976},
    { 32, -336, -984},
    { 48, -312, -960},
    { 72, -320, -984},
    { 64, -336, -984},
    { 80, -296, -968},
    { 64, -312, -928},
    { 80, -280, -952},
    // 184 seconds
    { 72, -256, -1008},
    { 72, -256, -1024},
    { 48, -232, -1008},
    { 48, -224, -976},
    { 56, -216, -976},
    { 64, -208, -1008},
    { 64, -192, -1040},
    { 56, -184, -1040},
    { 64, -184, -1016},
    { 64, -184, -984},
    { 72, -176, -1008},
    { 56, -184, -1032},
    { 48, -168, -1000},
    { 40, -160, -1016},
    { 48, -168, -1008},
    { 48, -176, -1024},
    { 24, -56, -1016},
    { 16, -32, -1072},
    { 96, 224, -1128},
    { 8, 272, -944},
    { -8, 488, -936},
    { -120, 632, -952},
    { -200, 632, -752},
    { -272, 688, -672},
    { -296, 672, -616},
    // 185 seconds
    { -320, 648, -560},
    { -392, 648, -536},
    { -416, 656, -440},
    { -448, 704, -360},
    { -488, 776, -320},
    { -480, 744, -240},
    { -464, 736, -128},
    { -472, 688, -24},
    { -456, 656, 40},
    { -464, 672, 112},
    { -488, 688, 176},
    { -496, 720, 256},
    { -488, 744, 264},
    { -480, 792, 312},
    { -488, 784, 344},
    { -496, 824, 296},
    { -488, 888, 232},
    { -488, 1000, 216},
    { -504, 1088, 216},
    { -504, 1128, 248},
    { -448, 1168, 320},
    { -512, 1232, 320},
    { -560, 1072, 144},
    { -552, 760, -104},
    { -528, 432, -208},
    // 186 seconds
    { -584, 304, -344},
    { -592, 200, -472},
    { -560, 216, -752},
    { -576, 80, -816},
    { -472, 24, -856},
    { -448, -152, -840},
    { -344, -160, -888},
    { -328, -240, -720},
    { -192, -48, -928},
    { -40, 72, -1040},
    { 24, 16, -944},
    { 168, 232, -1240},
    { 184, 600, -1248},
    { 24, 264, -1256},
    { -8, 432, -1048},
    { -184, 528, -808},
    { -256, 576, -720},
    { -280, 424, -712},
    { -272, 136, -856},
    { -232, 224, -960},
    { -216, 256, -1088},
    { -264, 232, -1016},
    { -256, 368, -968},
    { -224, 464, -920},
    { -248, 408, -856},
    // 187 seconds
    { -248, 424, -824},
    { -264, 464, -864},
    { -248, 464, -840},
    { -256, 432, -792},
    { -280, 424, -792},
    { -240, 568, -800},
    { -240, 568, -784},
    { -248, 560, -736},
    { -200, 696, -712},
    { -216, 704, -704},
    { -248, 744, -648},
    { -256, 728, -616},
    { -216, 712, -592},
    { -200, 760, -640},
    { -200, 728, -584},
    { -224, 680, -544},
    { -248, 792, -512},
    { -216, 744, -528},
    { -208, 760, -544},
    { -160, 784, -552},
    { -192, 776, -528},
    { -168, 760, -552},
    { -192, 768, -512},
    { -176, 784, -520},
    { -208, 768, -520},
    // 188 seconds
    { -184, 752, -504},
    { -128, 784, -512},
    { -200, 824, -512},
    { -208, 792, -528},
    { -216, 800, -512},
    { -208, 776, -496},
    { -192, 776, -488},
    { -192, 784, -520},
    { -192, 736, -528},
    { -216, 824, -584},
    { -240, 744, -568},
    { -208, 728, -624},
    { -192, 728, -616},
    { -184, 728, -624},
    { -184, 720, -608},
    { -200, 720, -608},
    { -208, 728, -600},
    { -200, 736, -600},
    { -200, 720, -608},
    { -200, 720, -616},
    { -208, 728, -616},
    { -208, 720, -608},
    { -200, 728, -600},
    { -200, 720, -616},
    { -200, 720, -608},
    // 189 seconds
    { -192, 720, -616},
    { -200, 712, -624},
    { -200, 720, -608},
    { -200, 728, -616},
    { -200, 720, -616},
    { -200, 712, -616},
    { -200, 720, -616},
    { -200, 720, -616},
    { -200, 720, -616},
    { -200, 712, -624},
    { -200, 712, -616},
    { -200, 720, -616},
    { -200, 712, -616},
    { -200, 704, -624},
    { -208, 712, -624},
    { -200, 712, -616},
    { -208, 704, -624},
    { -208, 712, -632},
    { -200, 712, -624},
    { -200, 712, -632},
    { -200, 704, -624},
    { -200, 712, -624},
    { -200, 712, -624},
    { -200, 704, -632},
    { -200, 704, -632},
    // 190 seconds
    { -200, 712, -632},
    { -200, 704, -624},
    { -200, 704, -640},
    { -192, 712, -632},
    { -200, 704, -624},
    { -200, 704, -632},
    { -200, 704, -632},
    { -200, 704, -640},
    { -200, 696, -640},
    { -200, 712, -624},
    { -200, 704, -632},
    { -192, 704, -632},
    { -200, 696, -632},
    { -208, 704, -640},
    { -200, 704, -640},
    { -200, 704, -640},
    { -208, 704, -632},
    { -200, 712, -632},
    { -192, 696, -640},
    { -192, 704, -632},
    { -192, 704, -632},
    { -200, 704, -648},
    { -192, 696, -640},
    { -192, 696, -640},
    { -192, 704, -648},
    // 191 seconds
    { -192, 696, -640},
    { -192, 704, -640},
    { -192, 696, -640},
    { -192, 696, -640},
    { -192, 704, -640},
    { -192, 704, -648},
    { -192, 696, -640},
    { -192, 696, -648},
    { -192, 696, -648},
    { -192, 696, -640},
    { -192, 696, -640},
    { -192, 696, -640},
    { -184, 704, -648},
    { -184, 696, -648},
    { -184, 704, -640},
    { -192, 696, -648},
    { -184, 696, -640},
    { -184, 704, -648},
    { -184, 696, -648},
    { -184, 704, -640},
    { -192, 688, -648},
    { -192, 696, -648},
    { -200, 696, -640},
    { -192, 696, -648},
    { -192, 688, -648},
    // 192 seconds
    { -192, 688, -656},
    { -200, 688, -648},
    { -200, 688, -656},
    { -200, 688, -656},
    { -192, 688, -656},
    { -200, 680, -656},
    { -208, 688, -656},
    { -200, 688, -648},
    { -208, 680, -664},
    { -200, 680, -664},
    { -200, 680, -664},
    { -200, 688, -648},
    { -200, 680, -656},
    { -192, 680, -664},
    { -192, 680, -656},
    { -192, 672, -672},
    { -200, 672, -664},
    { -200, 672, -672},
    { -200, 672, -672},
    { -192, 672, -664},
    { -200, 672, -672},
    { -192, 672, -664},
    { -192, 672, -664},
    { -192, 672, -664},
    { -200, 672, -672},
    // 193 seconds
    { -216, 680, -664},
    { -208, 656, -688},
    { -192, 664, -680},
    { -192, 680, -672},
    { -200, 672, -664},
    { -208, 664, -664},
    { -208, 664, -672},
    { -200, 664, -664},
    { -200, 672, -672},
    { -216, 672, -672},
    { -216, 672, -672},
    { -216, 664, -680},
    { -208, 672, -672},
    { -216, 672, -672},
    { -216, 672, -672},
    { -216, 664, -664},
    { -208, 672, -680},
    { -224, 672, -672},
    { -216, 672, -680},
    { -216, 672, -664},
    { -208, 664, -672},
    { -216, 664, -680},
    { -216, 664, -664},
    { -208, 664, -672},
    { -200, 672, -664},
    // 194 seconds
    { -200, 672, -672},
    { -200, 664, -680},
    { -200, 664, -672},
    { -208, 672, -680},
    { -200, 672, -672},
    { -200, 672, -672},
    { -192, 672, -680},
    { -200, 672, -672},
    { -192, 672, -672},
    { -192, 672, -680},
    { -200, 680, -672},
    { -192, 664, -680},
    { -192, 672, -672},
    { -192, 672, -672},
    { -200, 672, -672},
    { -184, 672, -672},
    { -192, 672, -672},
    { -192, 672, -672},
    { -176, 672, -672},
    { -184, 672, -672},
    { -184, 680, -672},
    { -184, 672, -680},
    { -176, 672, -672},
    { -176, 672, -672},
    { -176, 672, -672},
    // 195 seconds
    { -176, 672, -672},
    { -176, 672, -680},
    { -168, 664, -672},
    { -168, 672, -672},
    { -160, 672, -680},
    { -160, 664, -680},
    { -160, 672, -696},
    { -160, 664, -696},
    { -160, 688, -688},
    { -168, 696, -712},
    { -160, 656, -776},
    { -128, 632, -768},
    { -144, 632, -824},
    { -160, 536, -816},
    { -152, 488, -880},
    { -160, 424, -848},
    { -168, 416, -856},
    { -152, 352, -856},
    { -136, 288, -832},
    { -128, 264, -824},
    { -128, 312, -896},
    { -136, 360, -936},
    { -152, 344, -904},
    { -168, 328, -944},
    { -168, 288, -952},
    // 196 seconds
    { -144, 240, -968},
    { -144, 216, -976},
    { -128, 208, -1000},
    { -128, 184, -1000},
    { -104, 152, -1008},
    { -96, 104, -1000},
    { -80, 72, -1016},
    { -64, 56, -1024},
    { -80, 48, -992},
    { -64, 8, -1000},
    { -56, -40, -984},
    { -56, -80, -1000},
    { -56, -112, -1016},
    { -48, -128, -1016},
    { -40, -144, -1016},
    { -32, -144, -1016},
    { -32, -136, -1008},
    { -32, -104, -1016},
    { -24, -104, -1000},
    { -24, -128, -1008},
    { -32, -136, -1008},
    { -48, -144, -992},
    { -48, -128, -1008},
    { -48, -128, -1024},
    { -32, -120, -1040},
    // 197 seconds
    { 0, -112, -1032},
    { 8, -120, -1040},
    { 8, -120, -1032},
    { -8, -112, -1000},
    { -8, -112, -1008},
    { 0, -112, -1016},
    { 8, -144, -1000},
    { 8, -144, -1016},
    { 0, -112, -1032},
    { -8, -104, -1024},
    { -8, -120, -1008},
    { 8, -96, -1016},
    { 0, -96, -984},
    { 0, -112, -1000},
    { 0, -56, -1056},
    { -40, 40, -1008},
    { -24, 32, -984},
    { -8, -16, -1008},
    { -16, 32, -1016},
    { 0, 16, -1016},
    { 8, -8, -1048},
    { 24, -24, -1168},
    { 32, -24, -1320},
    { 24, 40, -1288},
    { -32, 560, -1032},
    // 198 seconds
    { -32, 128, -1280},
    { -104, 16, -1048},
    { -72, -272, -832},
    { -24, -280, -696},
    { 64, -384, -672},
    { 136, -288, -712},
    { 168, -296, -800},
    { 160, -296, -952},
    { 104, -368, -960},
    { 48, -464, -880},
    { 24, -464, -872},
    { 16, -568, -840},
    { 8, -624, -824},
    { 24, -648, -832},
    { 48, -720, -856},
    { 72, -720, -864},
    { 96, -696, -872},
    { 96, -672, -856},
    { 88, -672, -856},
    { 80, -648, -808},
    { 80, -624, -800},
    { 72, -624, -792},
    { 80, -648, -784},
    { 88, -640, -800},
    { 88, -648, -816},
    // 199 seconds
    { 96, -648, -824},
    { 80, -632, -832},
    { 72, -616, -840},
    { 64, -632, -832},
    { 56, -632, -840},
    { 64, -624, -848},
    { 56, -616, -840},
    { 56, -624, -840},
    { 48, -624, -840},
    { 56, -616, -848},
    { 48, -616, -848},
    { 56, -600, -856},
    { 56, -600, -840},
    { 48, -600, -832},
    { 56, -600, -832},
    { 56, -600, -840},
    { 56, -608, -832},
    { 64, -608, -848},
    { 56, -600, -848},
    { 72, -600, -848},
    { 64, -600, -848},
    { 64, -616, -840},
    { 64, -616, -848},
    { 64, -600, -840},
    { 56, -600, -848},
    // 200 seconds
    { 56, -592, -856},
    { 56, -592, -848},
    { 56, -600, -856},
    { 64, -584, -864},
    { 56, -584, -880},
    { 56, -576, -872},
    { 56, -592, -872},
    { 48, -584, -864},
    { 64, -528, -928},
    { 80, -448, -992},
    { 24, -224, -1016},
    { -24, 96, -984},
    { -104, 304, -936},
    { -160, 336, -784},
    { -176, 248, -824},
    { -200, 216, -880},
    { -320, 240, -864},
    { -256, 344, -1024},
    { -296, 360, -936},
    { -264, 208, -1048},
    { -200, 216, -1056},
    { -200, 248, -1080},
    { -160, 168, -1088},
    { -200, 136, -1048},
    { -200, 208, -1024},
    // 201 seconds
    { -232, 352, -904},
    { -256, 448, -904},
    { -304, 496, -768},
    { -360, 648, -728},
    { -400, 656, -608},
    { -392, 816, -496},
    { -424, 808, -320},
    { -400, 816, -176},
    { -416, 816, -56},
    { -448, 864, 0},
    { -424, 752, 136},
    { -392, 672, 312},
    { -408, 656, 424},
    { -408, 576, 480},
    { -408, 568, 528},
    { -392, 584, 592},
    { -400, 656, 608},
    { -408, 696, 592},
    { -448, 760, 528},
    { -504, 864, 488},
    { -520, 904, 520},
    { -504, 928, 608},
    { -480, 936, 648},
    { -472, 1056, 656},
    { -528, 1040, 504},
    // 202 seconds
    { -576, 808, 232},
    { -544, 560, -32},
    { -520, 384, -248},
    { -528, 272, -352},
    { -512, 224, -416},
    { -472, 200, -672},
    { -424, 224, -864},
    { -336, -232, -888},
    { -280, -64, -968},
    { -232, 32, -1072},
    { -304, 112, -1096},
    { -224, 208, -1056},
    { -192, 384, -1112},
    { -232, 312, -1016},
    { -256, 216, -920},
    { -280, 296, -872},
    { -336, 456, -864},
    { -336, 424, -904},
    { -352, 368, -792},
    { -280, 352, -920},
    { -264, 224, -1008},
    { -232, 304, -912},
    { -176, 376, -1008},
    { -216, 320, -976},
    { -240, 352, -904},
    // 203 seconds
    { -280, 432, -896},
    { -304, 384, -888},
    { -328, 360, -840},
    { -296, 208, -928},
    { -288, 296, -888},
    { -232, 104, -984},
    { -200, 80, -1016},
    { -208, 112, -1016},
    { -144, 72, -1040},
    { -216, 184, -984},
    { -208, 336, -856},
    { -264, 496, -824},
    { -328, 536, -704},
    { -368, 608, -600},
    { -392, 792, -488},
    { -392, 800, -376},
    { -416, 792, -256},
    { -440, 808, -144},
    { -456, 856, -56},
    { -448, 960, 56},
    { -456, 824, 96},
    { -432, 816, 184},
    { -408, 800, 248},
    { -416, 744, 280},
    { -408, 720, 296},
    // 204 seconds
    { -400, 736, 336},
    { -368, 784, 416},
    { -400, 824, 344},
    { -416, 896, 232},
    { -424, 936, 232},
    { -448, 1008, 208},
    { -424, 1016, 296},
    { -376, 1000, 416},
    { -368, 1048, 528},
    { -432, 1128, 528},
    { -528, 912, 216},
    { -496, 648, -48},
    { -496, 504, -272},
    { -520, 432, -376},
    { -544, 472, -528},
    { -496, 224, -760},
    { -504, 64, -872},
    { -456, 192, -976},
    { -432, -48, -888},
    { -376, -48, -952},
    { -312, -80, -792},
    { -232, 40, -960},
    { -120, 264, -1128},
    { 32, 320, -1024},
    { -48, 440, -1152},
    // 205 seconds
    { -200, 216, -1088},
    { -264, 376, -904},
    { -304, 432, -880},
    { -328, 376, -696},
    { -312, 280, -768},
    { -288, 472, -912},
    { -240, 280, -1024},
    { -216, 112, -984},
    { -184, 184, -1008},
    { -168, 392, -1080},
    { -224, 360, -984},
    { -232, 352, -880},
    { -232, 368, -880},
    { -256, 392, -872},
    { -256, 424, -856},
    { -264, 384, -872},
    { -264, 416, -872},
    { -264, 432, -856},
    { -256, 440, -848},
    { -240, 440, -848},
    { -248, 480, -816},
    { -240, 504, -824},
    { -256, 520, -824},
    { -264, 568, -792},
    { -264, 584, -792},
    // 206 seconds
    { -256, 464, -784},
    { -248, 480, -848},
    { -256, 384, -840},
    { -224, 272, -896},
    { -224, 280, -928},
    { -248, 272, -944},
    { -232, 240, -968},
    { -232, 288, -960},
    { -232, 256, -944},
    { -216, 272, -944},
    { -208, 312, -936},
    { -224, 288, -920},
    { -224, 272, -920},
    { -240, 296, -936},
    { -232, 288, -928},
    { -216, 320, -952},
    { -224, 320, -928},
    { -216, 312, -920},
    { -208, 320, -928},
    { -216, 328, -920},
    { -216, 312, -928},
    { -216, 328, -936},
    { -208, 304, -936},
    { -208, 304, -936},
    { -208, 304, -928},
    // 207 seconds
    { -224, 320, -944},
    { -232, 304, -952},
    { -216, 272, -984},
    { -200, 216, -992},
    { -200, 200, -1000},
    { -176, 176, -992},
    { -168, 112, -984},
    { -152, 64, -984},
    { -144, 40, -992},
    { -128, 8, -1000},
    { -152, 8, -992},
    { -136, 16, -1016},
    { -136, -80, -1016},
    { -136, -56, -1024},
    { -184, -64, -1016},
    { -184, -80, -1032},
    { -224, -56, -1048},
    { -248, -80, -1040},
    { -224, -136, -1016},
    { -192, -144, -984},
    { -112, -232, -936},
    { -24, -312, -912},
    { 16, -360, -880},
    { 56, -352, -952},
    { 56, -360, -960},
    // 208 seconds
    { 40, -384, -952},
    { 24, -368, -952},
    { 24, -344, -968},
    { 0, -320, -976},
    { 0, -312, -976},
    { -16, -360, -944},
    { 0, -360, -984},
    { 32, -424, -976},
    { 32, -424, -968},
    { 48, -400, -968},
    { 56, -384, -960},
    { 40, -376, -920},
    { -8, -328, -912},
    { -24, -328, -928},
    { -40, -352, -952},
    { -56, -304, -984},
    { -32, -312, -1008},
    { -72, -336, -1048},
    { -88, -328, -992},
    { -56, -264, -928},
    { -48, -176, -1024},
    { -32, -224, -1088},
    { -40, -224, -1048},
    { -56, -104, -1024},
    { -72, -72, -1000},
    // 209 seconds
    { -88, -32, -1008},
    { -136, 16, -1024},
    { -136, 32, -1064},
    { -144, -8, -1024},
    { -136, -40, -984},
    { -240, -56, -1040},
    { -152, -136, -1080},
    { -136, -192, -1000},
    { -48, -280, -984},
    { 48, -264, -1032},
    { 96, -336, -960},
    { 152, -368, -952},
    { 152, -360, -960},
    { 104, -376, -936},
    { 56, -360, -960},
    { 0, -376, -864},
    { -256, -288, -1104},
    { 96, -552, -952},
    { 16, -496, -960},
    { -40, -464, -1000},
    { -32, -448, -928},
    { -192, 328, -584},
    { 216, -544, -1200},
    { -64, -464, -784},
    { 80, -464, -984},
    // 210 seconds
    { 56, -488, -920},
    { 48, -416, -904},
    { 64, -408, -912},
    { 16, -392, -944},
    { -8, -368, -960},
    { -32, -384, -968},
    { -64, -392, -1024},
    { -48, -384, -984},
    { -32, -400, -976},
    { -24, -384, -984},
    { 0, -400, -968},
    { -8, -376, -984},
    { 32, -368, -1000},
    { 32, -360, -984},
    { 24, -328, -976},
    { 32, -352, -992},
    { 16, -336, -976},
    { 8, -304, -968},
    { 8, -328, -968},
    { 0, -344, -952},
    { -8, -320, -936},
    { 8, -304, -992},
    { 16, -312, -1000},
    { 16, -272, -1024},
    { 16, -264, -992},
    // 211 seconds
    { 8, -288, -984},
    { 24, -280, -984},
    { 24, -288, -1000},
    { 24, -288, -1000},
    { 24, -280, -992},
    { 16, -264, -1016},
    { 8, -232, -992},
    { -8, -256, -960},
    { -8, -240, -984},
    { 0, -272, -1008},
    { 0, -272, -992},
    { -8, -248, -976},
    { -8, -232, -968},
    { -24, -200, -992},
    { -24, -192, -1040},
    { -32, -160, -1040},
    { -24, -152, -1000},
    { -40, -176, -984},
    { -32, -160, -1000},
    { -24, -168, -992},
    { -24, -192, -1008},
    { -8, -168, -1032},
    { -40, -128, -1008},
    { -48, -104, -1016},
    { -48, -64, -1056},
    // 212 seconds
    { -56, -72, -1032},
    { -64, -32, -1000},
    { -56, -16, -1016},
    { -56, 0, -1000},
    { -56, -56, -1016},
    { -64, -80, -1024},
    { -56, -104, -1008},
    { -40, -56, -1024},
    { -64, -8, -1000},
    { -56, 40, -1024},
    { -72, 72, -1008},
    { -88, 80, -984},
    { -88, 112, -1000},
    { -112, 144, -1000},
    { -112, 192, -1024},
    { -120, 216, -1000},
    { -128, 184, -1000},
    { -144, 56, -912},
    { -104, -96, -896},
    { -96, -24, -952},
    { -104, -96, -936},
    { -96, -136, -1016},
    { -88, -176, -1024},
    { -72, -192, -1064},
    { -48, -144, -1080},
    // 213 seconds
    { -48, -16, -1128},
    { -72, -80, -1152},
    { -88, 40, -1064},
    { -152, 248, -976},
    { -208, 384, -952},
    { -216, 320, -872},
    { -240, 416, -808},
    { -264, 504, -768},
    { -320, 480, -712},
    { -376, 512, -728},
    { -424, 536, -640},
    { -424, 640, -640},
    { -392, 696, -632},
    { -408, 680, -544},
    { -416, 664, -504},
    { -432, 736, -480},
    { -440, 792, -384},
    { -472, 784, -312},
    { -504, 816, -240},
    { -488, 808, -136},
    { -488, 784, -8},
    { -504, 744, 128},
    { -480, 752, 224},
    { -480, 752, 256},
    { -464, 768, 296},
    // 214 seconds
    { -480, 832, 184},
    { -544, 976, 16},
    { -576, 1016, -40},
    { -560, 1032, 56},
    { -520, 1072, 232},
    { -544, 1040, 360},
    { -624, 968, 216},
    { -608, 672, -8},
    { -528, 456, -312},
    { -568, 312, -432},
    { -600, 216, -416},
    { -504, 232, -616},
    { -472, 104, -744},
    { -264, 264, -848},
    { -264, 168, -968},
    { -248, 144, -1096},
    { -264, 224, -1104},
    { -232, 200, -1008},
    { -256, 208, -1088},
    { -256, 248, -984},
    { -264, 232, -880},
    { -264, 216, -952},
    { -256, 256, -936},
    { -224, 344, -920},
    { -216, 256, -952},
    // 215 seconds
    { -208, 256, -944},
    { -208, 280, -968},
    { -224, 312, -1016},
    { -232, 296, -960},
    { -312, 384, -896},
    { -368, 488, -808},
    { -416, 536, -672},
    { -416, 536, -632},
    { -328, 448, -736},
    { -296, 384, -808},
    { -272, 504, -888},
    { -272, 504, -920},
    { -248, 384, -896},
    { -264, 448, -888},
    { -264, 312, -928},
    { -248, 296, -864},
    { -232, 368, -904},
    { -232, 320, -912},
    { -232, 352, -888},
    { -232, 408, -888},
    { -248, 424, -888},
    { -272, 448, -872},
    { -280, 448, -872},
    { -272, 432, -848},
    { -280, 456, -824},
    // 216 seconds
    { -264, 440, -824},
    { -256, 448, -832},
    { -248, 416, -872},
    { -240, 400, -896},
    { -240, 408, -888},
    { -232, 408, -888},
    { -224, 408, -880},
    { -224, 400, -880},
    { -224, 408, -896},
    { -248, 416, -880},
    { -224, 416, -880},
    { -232, 416, -880},
    { -232, 384, -872},
    { -240, 400, -856},
    { -240, 408, -864},
    { -240, 424, -880},
    { -248, 424, -864},
    { -240, 408, -872},
    { -232, 416, -896},
    { -224, 400, -896},
    { -208, 384, -936},
    { -192, 392, -968},
    { -208, 408, -928},
    { -168, 424, -872},
    { -184, 320, -912},
    // 217 seconds
    { -224, 264, -920},
    { -224, 208, -952},
    { -256, 208, -912},
    { -296, 192, -864},
    { -272, 96, -848},
    { -240, 192, -1000},
    { -224, 120, -1048},
    { -176, -8, -1008},
    { -176, 48, -1048},
    { -160, -8, -1072},
    { -184, 112, -1048},
    { -200, 104, -1024},
    { -192, 104, -928},
    { -184, 152, -912},
    { -160, 168, -1008},
    { -240, 408, -888},
    { -208, 296, -904},
    { -232, 216, -960},
    { -232, 256, -976},
    { -160, 88, -984},
    { -112, 72, -1064},
    { -168, 176, -1072},
    { -192, 200, -1008},
    { -240, 240, -920},
    { -248, 320, -864},
    // 218 seconds
    { -288, 440, -832},
    { -192, 360, -864},
    { -240, 312, -912},
    { -240, 488, -848},
    { -232, 368, -800},
    { -232, 560, -792},
    { -280, 704, -736},
    { -256, 640, -688},
    { -296, 752, -608},
    { -272, 808, -568},
    { -248, 440, -640},
    { -176, 440, -744},
    { -176, 240, -856},
    { -128, 192, -984},
    { -160, 232, -1040},
    { -208, 312, -968},
    { -216, 360, -904},
    { -232, 384, -952},
    { -264, 456, -920},
    { -240, 464, -912},
    { -280, 472, -952},
    { -280, 440, -936},
    { -288, 392, -904},
    { -264, 408, -872},
    { -248, 432, -896},
    // 219 seconds
    { -272, 376, -824},
    { -264, 328, -848},
    { -264, 424, -888},
    { -328, 416, -1024},
    { -272, 320, -968},
    { -240, 232, -920},
    { -248, 280, -904},
    { -272, 328, -888},
    { -208, 328, -928},
    { -104, 256, -872},
    { -16, 192, -848},
    { 40, 416, -912},
    { -168, 456, -920},
    { -64, 448, -976},
    { -48, 248, -984},
    { -48, 168, -976},
    { -128, 136, -976},
    { -96, 32, -880},
    { -104, 56, -944},
    { 104, 176, -1040},
    { 336, 136, -1160},
    { 552, 192, -1072},
    { 552, 208, -1280},
    { 320, 288, -1328},
    { 152, 128, -904},
    // 220 seconds
    { -80, 472, -704},
    { -304, 864, -536},
    { -264, 968, -680},
    { -184, 1016, -552},
    { -328, 744, -464},
    { -368, 480, -808},
    { -224, 648, -784},
    { -264, 528, -768},
    { -48, 480, -944},
    { 24, 488, -840},
    { -80, 568, -744},
    { 24, 696, -808},
    { 112, 600, -728},
    { 104, 584, -752},
    { 48, 496, -728},
    { 8, 600, -696},
    { -80, 456, -712},
    { -48, 808, -696},
    { -104, 808, -592},
    { -64, 888, -632},
    { -72, 640, -648},
    { -48, 712, -576},
    { -16, 616, -568},
    { 16, 776, -512},
    { 96, 744, -448},
    // 221 seconds
    { 96, 808, -392},
    { 120, 920, -344},
    { 88, 656, -408},
    { -48, 856, -912},
    { -560, 792, -992},
    { 64, 656, -384},
    { -168, 752, -368},
    { -192, 944, -392},
    { -112, 968, -328},
    { -136, 880, -304},
    { -112, 800, -384},
    { -120, 928, -320},
    { -112, 944, -256},
    { -96, 960, -200},
    { -96, 952, -184},
    { -96, 936, -152},
    { -112, 904, -136},
    { -112, 992, -80},
    { -104, 928, -120},
    { -112, 928, -120},
    { -112, 944, -104},
    { -96, 920, -120},
    { -104, 904, -128},
    { -112, 936, -104},
    { -104, 936, -104},
    // 222 seconds
    { -112, 928, -120},
    { -104, 928, -104},
    { -104, 920, -112},
    { -104, 928, -112},
    { -104, 928, -96},
    { -104, 920, -96},
    { -96, 912, -112},
    { -96, 920, -104},
    { -96, 936, -88},
    { -104, 936, -88},
    { -104, 928, -96},
    { -104, 936, -80},
    { -104, 928, -72},
    { -104, 928, -72},
    { -104, 936, -72},
    { -104, 928, -80},
    { -104, 928, -72},
    { -112, 936, -72},
    { -104, 936, -72},
    { -104, 928, -80},
    { -104, 928, -72},
    { -104, 936, -64},
    { -104, 928, -72},
    { -104, 928, -72},
    { -104, 936, -64},
    // 223 seconds
    { -104, 936, -72},
    { -104, 928, -64},
    { -104, 928, -64},
    { -104, 928, -64},
    { -104, 928, -64},
    { -104, 936, -56},
    { -104, 928, -64},
    { -104, 928, -64},
    { -104, 928, -64},
    { -112, 928, -56},
    { -104, 928, -56},
    { -104, 928, -56},
    { -104, 936, -56},
    { -104, 928, -64},
    { -104, 928, -56},
    { -104, 928, -56},
    { -104, 928, -56},
    { -104, 928, -64},
    { -104, 936, -48},
    { -104, 936, -48},
    { -104, 928, -48},
    { -104, 928, -48},
    { -112, 936, -40},
    { -104, 936, -40},
    { -112, 936, -16},
    // 224 seconds
    { -104, 936, -16},
    { -104, 936, -8},
    { -104, 928, -16},
    { -104, 936, -8},
    { -104, 928, -16},
    { -104, 936, -8},
    { -104, 928, -16},
    { -112, 928, -8},
    { -104, 928, -8},
    { -104, 936, -8},
    { -112, 936, -16},
    { -104, 928, -8},
    { -104, 928, -16},
    { -112, 928, -8},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -112, 928, -16},
    { -104, 928, -16},
    { -104, 928, -16},
    { -112, 928, -16},
    { -104, 928, -8},
    { -104, 936, -16},
    { -104, 928, -8},
    // 225 seconds
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 928, -8},
    { -104, 928, -16},
    { -112, 936, -8},
    { -104, 936, -8},
    { -104, 928, -8},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 928, -8},
    { -104, 936, -16},
    { -104, 936, -8},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 936, -16},
    { -104, 936, -8},
    { -104, 928, -16},
    { -104, 936, -8},
    { -104, 936, -16},
    { -96, 928, -8},
    { -104, 928, -16},
    { -104, 936, -16},
    // 226 seconds
    { -112, 936, -16},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 936, -16},
    { -104, 936, -16},
    { -112, 928, -16},
    { -104, 928, -8},
    { -104, 936, -8},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 936, -16},
    { -104, 928, -16},
    { -104, 928, -8},
    { -112, 928, -8},
    { -104, 928, -16},
    { -104, 928, -16},
    { -96, 928, -24},
    { -104, 928, -16},
    { -96, 936, -16},
    { -104, 928, -24},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 936, -16},
    { -104, 928, -8},
    { -104, 936, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -96, 928, -16},
    { -96, 936, -24},
    { -104, 928, -24},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 936, -16},
    { -104, 928, -16},
    { -104, 928, -8},
    { -104, 928, -16},
    { -96, 936, -24},
    { -96, 936, -8},
    { -104, 936, -16},
    { -96, 928, -16},
    { -96, 936, -16},
    { -104, 936, -8},
    { -104, 936, -16},
    { -96, 928, -16},
    { -104, 936, -24},
    { -96, 928, -16},
    { -96, 936, -16},
    { -104, 928, -16},
    { -104, 928, -8},
    { -96, 928, -16},
    { -104, 928, -16},
    { -96, 928, -8},
    { -104, 928, -8},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 936, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -104, 928, -8},
    { -104, 936, -16},
    { -96, 936, -16},
    { -104, 936, -16},
    { -104, 928, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 936, -16},
    { -104, 928, -16},
    { -104, 928, -8},
    { -96, 936, -16},
    { -104, 928, -16},
    { -96, 928, -8},
    { -96, 936, -8},
    { -96, 928, -8},
    { -104, 928, -8},
    { -104, 936, -16},
    { -104, 936, -16},
    { -104, 928, -8},
    { -96, 928, -16},
    { -96, 936, -8},
    { -96, 936, -16},
    { -96, 936, -16},
    { -96, 936, -16},
    { -104, 928, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 936, -8},
    { -96, 928, -8},
    { -104, 936, -8},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 936, -16},
    { -96, 936, -16},
    { -96, 936, -16},
    { -96, 936, -8},
    { -104, 928, -16},
    { -104, 928, -16},
    { -104, 936, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 936, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 928, -8},
    { -96, 936, -16},
    { -96, 936, -16},
    // 231 seconds
    { -96, 928, -8},
    { -96, 936, -16},
    { -96, 936, -16},
    { -96, 928, -16},
    { -96, 928, -8},
    { -96, 928, -16},
    { -96, 936, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -104, 928, -8},
    { -96, 928, -16},
    { -96, 936, -8},
    { -96, 928, -16},
    { -96, 936, -16},
    { -96, 936, -16},
    { -104, 928, -16},
    { -96, 936, -16},
    { -96, 928, -16},
    { -104, 936, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    // 232 seconds
    { -96, 928, -16},
    { -96, 928, -24},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 936, -24},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 936, -24},
    { -96, 936, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 928, -24},
    { -96, 928, -16},
    { -104, 928, -24},
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 944, -24},
    { -96, 928, -24},
    { -96, 936, -24},
    { -96, 936, -16},
    { -96, 928, -16},
    { -96, 928, -24},
    { -96, 928, -24},
    // 233 seconds
    { -96, 928, -16},
    { -96, 928, -16},
    { -96, 920, -24},
    { -96, 936, -24},
    { -104, 912, -16},
    { -96, 936, -24},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 936, -16},
    { -96, 928, -16},
    { -96, 928, -24},
    { -96, 936, -24},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 928, -24},
    { -96, 928, -24},
    { -104, 936, -16},
    { -96, 928, -24},
    { -96, 936, -24},
    { -96, 936, -24},
    { -96, 928, -32},
    { -96, 928, -16},
    { -104, 936, -24},
    { -96, 936, -24},
    { -88, 928, -24},
    // 234 seconds
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 928, -24},
    { -96, 936, -24},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 936, -24},
    { -104, 928, -24},
    { -96, 928, -24},
    { -104, 928, -32},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 920, -24},
    { -96, 928, -24},
    { -96, 928, -24},
    { -96, 928, -32},
    { -96, 936, -24},
    { -96, 936, -24},
    { -88, 928, -24},
    { -96, 928, -32},
    { -96, 928, -24},
    { -96, 928, -32},
    // 235 seconds
    { -96, 936, -24},
    { -96, 928, -32},
    { -96, 928, -24},
    { -96, 928, -24},
    { -96, 936, -24},
    { -96, 936, -24},
    { -96, 928, -32},
    { -96, 936, -32},
    { -96, 928, -32},
    { -96, 928, -32},
    { -104, 936, -32},
    { -96, 936, -32},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 936, -32},
    { -96, 936, -24},
    { -88, 936, -24},
    { -96, 928, -32},
    { -96, 928, -24},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 936, -24},
    { -96, 928, -32},
    { -96, 928, -32},
    { -88, 928, -24},
    { -96, 928, -32},
    { -96, 936, -32},
    { -96, 928, -32},
    { -96, 928, -32},
    { -88, 928, -32},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 936, -32},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 936, -24},
    { -96, 928, -32},
    { -96, 928, -24},
    { -96, 928, -32},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 936, -32},
    { -96, 928, -32},
    { -88, 928, -32},
    { -96, 928, -24},
    { -96, 928, -24},
    { -96, 928, -24},
    { -96, 928, -32},
    { -88, 928, -32},
    { -96, 928, -24},
    { -96, 928, -24},
    { -96, 928, -32},
    { -96, 936, -24},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 928, -32},
    { -88, 928, -24},
    { -96, 936, -32},
    { -96, 936, -24},
    { -96, 928, -24},
    { -88, 936, -32},
    { -96, 936, -32},
    { -96, 928, -32},
    { -96, 936, -32},
    { -96, 928, -32},
    { -88, 936, -24},
    { -88, 936, -32},
    { -96, 928, -32},
    { -96, 936, -32},
    { -96, 936, -32},
    // 238 seconds
    { -96, 928, -32},
    { -88, 936, -32},
    { -96, 936, -24},
    { -88, 928, -32},
    { -96, 936, -32},
    { -96, 928, -32},
    { -88, 928, -32},
    { -96, 936, -24},
    { -96, 936, -32},
    { -96, 928, -24},
    { -96, 928, -32},
    { -96, 936, -24},
    { -96, 936, -24},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 936, -32},
    { -88, 928, -24},
    { -96, 928, -24},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 928, -24},
    { -88, 928, -24},
    { -96, 936, -24},
    // 239 seconds
    { -96, 928, -32},
    { -96, 936, -24},
    { -96, 936, -24},
    { -96, 928, -32},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 936, -24},
    { -88, 928, -24},
    { -96, 936, -32},
    { -96, 928, -24},
    { -96, 936, -32},
    { -88, 936, -24},
    { -96, 928, -24},
    { -88, 928, -32},
    { -96, 936, -24},
    { -88, 936, -24},
    { -96, 936, -32},
    { -88, 936, -32},
    { -96, 928, -24},
    { -88, 928, -24},
    { -96, 936, -24},
    { -96, 936, -24},
    { -88, 936, -32},
    { -96, 928, -32},
    { -96, 936, -24},
    // elapsed: 4 minutes
    { -96, 936, -24},
    { -96, 928, -32},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 928, -24},
    { -96, 936, -32},
    { -88, 928, -32},
    { -96, 928, -16},
    { -96, 928, -24},
    { -96, 928, -24},
    { -96, 928, -16},
    { -96, 936, -24},
    { -88, 928, -24},
    { -96, 928, -24},
    { -96, 936, -24},
    { -96, 928, -32},
    { -96, 928, -24},
    { -96, 936, -24},
    { -96, 936, -24},
    { -96, 928, -32},
    { -88, 936, -24},
    { -88, 936, -24},
    { -96, 936, -24},
    { -88, 928, -32},
    { -88, 928, -32},
    // 241 seconds
    { -88, 928, -24},
    { -88, 936, -16},
    { -96, 928, -32},
    { -88, 928, -24},
    { -96, 936, -24},
    { -88, 928, -24},
    { -96, 928, -24},
    { -96, 928, -24},
    { -96, 936, -32},
    { -96, 928, -24},
    { -88, 928, -24},
    { -88, 928, -24},
    { -96, 928, -32},
    { -88, 936, -24},
    { -96, 936, -32},
    { -96, 936, -24},
    { -96, 936, -24},
    { -88, 936, -16},
    { -96, 928, -24},
    { -96, 936, -32},
    { -96, 928, -24},
    { -88, 928, -24},
    { -96, 936, -24},
    { -96, 936, -24},
    { -88, 936, -24},
    { -88, 936, -24},
    { -88, 936, -24},
    { -88, 928, -32},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 936, -24},
    { -96, 936, -24},
    { -88, 936, -24},
    { -88, 928, -24},
    { -88, 928, -32},
    { -88, 928, -24},
    { -96, 936, -24},
    { -88, 928, -24},
    { -96, 928, -32},
    { -96, 928, -32},
    { -96, 936, -32},
    { -96, 936, -32},
    { -96, 928, -24},
    { -88, 928, -24},
    { -88, 928, -24},
    { -96, 936, -24},
    { -88, 936, -24},
    { -88, 928, -24},
    { -96, 928, -24},
    { -88, 936, -24},
    // 243 seconds
    { -96, 928, -24},
    { -96, 928, -32},
    { -88, 936, -32},
    { -96, 936, -24},
    { -96, 936, -32},
    { -88, 928, -24},
    { -96, 936, -24},
    { -88, 928, -24},
    { -88, 936, -24},
    { -96, 936, -24},
    { -88, 936, -32},
    { -96, 936, -24},
    { -96, 936, -24},
    { -88, 928, -32},
    { -96, 936, -24},
    { -96, 936, -24},
    { -96, 928, -32},
    { -96, 936, -32},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 928, -24},
    { -88, 928, -24},
    { -96, 928, -24},
    { -88, 928, -24},
    { -88, 936, -32},
    // 244 seconds
    { -88, 936, -24},
    { -88, 928, -24},
    { -88, 928, -32},
    { -96, 928, -32},
    { -88, 928, -32},
    { -96, 928, -24},
    { -88, 928, -24},
    { -96, 928, -24},
    { -96, 936, -24},
    { -88, 928, -24},
    { -96, 936, -32},
    { -88, 928, -24},
    { -96, 936, -32},
    { -88, 936, -32},
    { -88, 928, -32},
    { -88, 936, -24},
    { -96, 928, -24},
    { -96, 928, -24},
    { -96, 936, -24},
    { -88, 936, -24},
    { -88, 936, -24},
    { -96, 936, -24},
    { -88, 928, -24},
    { -88, 928, -24},
    { -88, 928, -24},
    // 245 seconds
    { -96, 936, -24},
    { -88, 928, -24},
    { -88, 928, -24},
    { -96, 928, -24},
    { -96, 928, -24},
    { -88, 936, -24},
    { -88, 928, -24},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 936, -24},
    { -96, 928, -24},
    { -96, 928, -32},
    { -96, 928, -24},
    { -96, 928, -24},
    { -88, 928, -32},
    { -88, 928, -24},
    { -88, 928, -32},
    { -96, 928, -24},
    { -88, 936, -24},
    { -96, 928, -24},
    { -88, 936, -24},
    { -88, 928, -24},
    { -96, 928, -24},
    { -88, 936, -32},
    { -96, 928, -24},
    // 246 seconds
    { -88, 928, -32},
    { -96, 928, -32},
    { -88, 936, -24},
    { -88, 928, -24},
    { -88, 928, -24},
    { -96, 936, -24},
    { -96, 936, -32},
    { -88, 928, -24},
    { -88, 928, -24},
    { -88, 936, -24},
    { -88, 928, -32},
    { -88, 928, -32},
    { -88, 928, -24},
    { -88, 936, -24},
    { -88, 936, -24},
    { -88, 928, -24},
    { -88, 936, -24},
    { -88, 936, -32},
    { -88, 936, -24},
    { -96, 944, -24},
    { -96, 960, -16},
    { -104, 976, -40},
    { -88, 968, -88},
    { -120, 1168, -176},
    { -80, 1200, -312},
    // 247 seconds
    { -120, 976, -392},
    { -120, 848, -624},
    { -136, 424, -704},
    { -112, 208, -736},
    { -192, -8, -888},
    { -192, -56, -936},
    { -224, -112, -896},
    { -240, -160, -896},
    { -216, -216, -928},
    { -208, -232, -976},
    { -192, -256, -1000},
    { -192, -264, -1024},
    { -192, -232, -1008},
    { -200, -256, -992},
    { -200, -264, -960},
    { -208, -232, -968},
    { -224, -264, -960},
    { -216, -248, -984},
    { -216, -280, -968},
    { -216, -280, -968},
    { -208, -272, -976},
    { -208, -272, -984},
    { -224, -256, -992},
    { -224, -240, -976},
    { -232, -232, -960},
    { -232, -232, -960},
    { -232, -240, -968},
    { -224, -240, -984},
    { -232, -232, -1000},
    { -224, -232, -968},
    { -224, -224, -992},
    { -232, -232, -968},
    { -224, -232, -984},
    { -224, -232, -976},
    { -224, -216, -992},
    { -232, -216, -984},
    { -232, -216, -984},
    { -232, -216, -976},
    { -232, -200, -984},
    { -224, -216, -984},
    { -224, -192, -1024},
    { -224, -192, -1160},
    { -192, -224, -1160},
    { -152, -184, -1288},
    { -192, -128, -1072},
    { -296, 16, -840},
    { -296, -216, -872},
    { -232, -432, -752},
    { -112, -544, -712},
    { -16, -672, -728},
    // 249 seconds
    { -48, -720, -680},
    { -88, -656, -712},
    { -128, -624, -776},
    { -160, -544, -816},
    { -184, -512, -856},
    { -192, -544, -840},
    { -192, -584, -856},
    { -200, -616, -864},
    { -200, -584, -896},
    { -208, -568, -896},
    { -216, -520, -904},
    { -224, -496, -896},
    { -224, -480, -912},
    { -176, -512, -928},
    { -160, -496, -912},
    { -152, -488, -936},
    { -144, -480, -928},
    { -152, -472, -928},
    { -160, -432, -920},
    { -160, -408, -928},
    { -160, -424, -952},
    { -152, -408, -960},
    { -152, -392, -976},
    { -136, -376, -976},
    { -144, -376, -976},
    // 250 seconds
    { -136, -368, -968},
    { -128, -360, -960},
    { -120, -352, -968},
    { -120, -384, -1080},
    { -160, -328, -960},
    { -144, -296, -944},
    { -120, -312, -984},
    { -112, -352, -968},
    { -128, -344, -976},
    { -128, -328, -984},
    { -128, -336, -976},
    { -128, -336, -968},
    { -128, -328, -976},
    { -120, -344, -968},
    { -120, -336, -976},
    { -128, -336, -968},
    { -136, -336, -976},
    { -136, -328, -968},
    { -128, -328, -976},
    { -128, -312, -976},
    { -120, -312, -976},
    { -120, -320, -976},
    { -112, -320, -976},
    { -120, -328, -984},
    { -120, -320, -984},
    { -120, -320, -984},
    { -120, -320, -976},
    { -120, -320, -976},
    { -120, -320, -976},
    { -112, -280, -944},
    { -120, -328, -976},
    { -128, -328, -968},
    { -128, -320, -976},
    { -136, -328, -968},
    { -80, -336, -1008},
    { 112, -264, -1056},
    { 344, -80, -1088},
    { -40, 176, -984},
    { -88, 168, -912},
    { -256, 120, -848},
    { -192, 224, -936},
    { -304, 456, -560},
    { -288, 616, -440},
    { -224, 672, -312},
    { -192, 600, -320},
    { -88, 848, -168},
    { -40, 776, -184},
    { -88, 1112, -328},
    { -40, 1344, -360},
    { 56, 912, -192},
    // 252 seconds
    { 192, 784, -152},
    { 448, 896, -576},
    { 440, 696, -464},
    { 632, 872, -360},
    { 616, 960, -408},
    { 488, 856, -264},
    { 392, 784, -200},
    { 400, 776, -216},
    { 400, 784, -232},
    { 440, 784, -224},
    { 472, 792, -216},
    { 496, 792, -280},
    { 456, 752, -184},
    { 472, 760, -232},
    { 504, 744, -216},
    { 472, 784, -248},
    { 464, 752, -280},
    { 448, 792, -312},
    { 448, 784, -280},
    { 448, 768, -240},
    { 464, 768, -248},
    { 456, 784, -264},
    { 448, 776, -264},
    { 448, 768, -264},
    { 456, 760, -240},
    // 253 seconds
    { 448, 768, -240},
    { 456, 776, -248},
    { 448, 768, -248},
    { 440, 768, -256},
    { 440, 768, -256},
    { 440, 776, -264},
    { 432, 768, -264},
    { 440, 768, -264},
    { 432, 776, -272},
    { 440, 776, -272},
    { 424, 776, -264},
    { 424, 776, -272},
    { 432, 768, -272},
    { 432, 776, -272},
    { 432, 784, -264},
    { 432, 776, -264},
    { 440, 776, -264},
    { 440, 776, -264},
    { 432, 768, -264},
    { 440, 776, -264},
    { 440, 768, -264},
    { 448, 768, -264},
    { 440, 776, -256},
    { 448, 776, -264},
    { 448, 760, -256},
    // 254 seconds
    { 456, 768, -256},
    { 448, 776, -264},
    { 448, 768, -256},
    { 448, 768, -256},
    { 448, 768, -264},
    { 456, 768, -264},
    { 456, 760, -264},
    { 464, 760, -256},
    { 464, 760, -256},
    { 464, 760, -264},
    { 456, 768, -264},
    { 464, 760, -256},
    { 464, 752, -256},
    { 464, 760, -256},
    { 464, 752, -256},
    { 464, 760, -264},
    { 464, 760, -264},
    { 464, 752, -264},
    { 472, 752, -264},
    { 472, 760, -256},
    { 472, 744, -256},
    { 488, 752, -248},
    { 496, 752, -240},
    { 504, 736, -248},
    { 512, 728, -304},
    // 255 seconds
    { 504, 696, -376},
    { 480, 680, -400},
    { 432, 704, -448},
    { 432, 720, -416},
    { 464, 664, -472},
    { 448, 680, -440},
    { 448, 680, -464},
    { 456, 696, -464},
    { 448, 640, -456},
    { 464, 576, -504},
    { 480, 608, -448},
    { 488, 592, -464},
    { 480, 560, -528},
    { 448, 600, -528},
    { 448, 592, -552},
    { 432, 592, -560},
    { 448, 608, -504},
    { 536, 688, -480},
    { 568, 712, -456},
    { 544, 624, -424},
    { 520, 632, -424},
    { 504, 616, -416},
    { 504, 632, -448},
    { 512, 648, -472},
    { 504, 640, -472},
    // 256 seconds
    { 504, 640, -480},
    { 504, 624, -472},
    { 504, 640, -480},
    { 504, 648, -504},
    { 512, 624, -464},
    { 528, 624, -464},
    { 536, 624, -440},
    { 544, 608, -432},
    { 560, 608, -408},
    { 528, 640, -448},
    { 528, 624, -488},
    { 544, 624, -464},
    { 544, 624, -480},
    { 544, 632, -488},
    { 544, 608, -464},
    { 536, 600, -464},
    { 560, 608, -480},
    { 552, 600, -496},
    { 520, 536, -512},
    { 496, 504, -568},
    { 472, 568, -600},
    { 488, 512, -680},
    { 504, 464, -624},
    { 552, 488, -664},
    { 640, 432, -672},
    // 257 seconds
    { 680, 400, -768},
    { 624, 336, -800},
    { 672, 312, -704},
    { 632, 352, -688},
    { 560, 256, -768},
    { 504, 320, -624},
    { 544, 208, -536},
    { 584, 64, -656},
    { 568, 296, -824},
    { 464, 96, -792},
    { 400, 80, -736},
    { 584, 96, -744},
    { 656, 184, -656},
    { 896, 304, -280},
    { 904, 224, -224},
    { 728, 280, -856},
    { 672, 168, -752},
    { 624, 104, -712},
    { 536, 24, -816},
    { 504, 56, -512},
    { 696, 240, -408},
    { 816, 312, -888},
    { 704, 200, -760},
    { 624, 256, -824},
    { 592, 240, -704},
    // 258 seconds
    { 592, 248, -744},
    { 520, 352, -824},
    { 560, 296, -760},
    { 552, 288, -688},
    { 560, 336, -760},
    { 568, 336, -680},
    { 600, 304, -672},
    { 576, 360, -768},
    { 560, 336, -704},
    { 528, 352, -728},
    { 544, 352, -720},
    { 560, 320, -744},
    { 576, 320, -768},
    { 520, 328, -816},
    { 520, 320, -760},
    { 544, 288, -672},
    { 496, 312, -672},
    { 528, 312, -672},
    { 536, 336, -608},
    { 576, 352, -776},
    { 528, 320, -640},
    { 528, 312, -592},
    { 520, 336, -704},
    { 544, 368, -776},
    { 544, 360, -800},
    // 259 seconds
    { 520, 368, -728},
    { 568, 360, -744},
    { 568, 360, -688},
    { 640, 360, -712},
    { 576, 344, -656},
    { 584, 352, -696},
    { 592, 344, -688},
    { 616, 352, -760},
    { 608, 312, -672},
    { 600, 304, -624},
    { 608, 304, -632},
    { 632, 280, -624},
    { 616, 256, -600},
    { 616, 264, -592},
    { 632, 288, -664},
    { 624, 288, -688},
    { 616, 296, -704},
    { 624, 288, -704},
    { 616, 280, -672},
    { 640, 288, -688},
    { 632, 288, -656},
    { 592, 280, -712},
    { 536, 248, -552},
    { 496, 288, -776},
    { 584, 296, -792},
    // 260 seconds
    { 560, 288, -752},
    { 560, 264, -728},
    { 560, 296, -696},
    { 552, 328, -696},
    { 536, 328, -720},
    { 544, 336, -744},
    { 552, 312, -736},
    { 552, 312, -728},
    { 552, 328, -720},
    { 552, 328, -696},
    { 552, 336, -720},
    { 544, 352, -720},
    { 560, 344, -728},
    { 544, 328, -704},
    { 552, 328, -720},
    { 552, 328, -712},
    { 544, 328, -712},
    { 544, 336, -704},
    { 552, 320, -712},
    { 552, 320, -704},
    { 552, 320, -720},
    { 544, 320, -720},
    { 544, 320, -720},
    { 544, 328, -728},
    { 544, 320, -728},
    // 261 seconds
    { 560, 328, -712},
    { 544, 328, -712},
    { 544, 328, -712},
    { 544, 328, -712},
    { 552, 320, -728},
    { 544, 320, -720},
    { 544, 320, -712},
    { 552, 320, -720},
    { 544, 312, -712},
    { 544, 320, -720},
    { 544, 320, -720},
    { 552, 320, -720},
    { 544, 328, -712},
    { 552, 328, -728},
    { 544, 320, -728},
    { 544, 320, -728},
    { 544, 320, -728},
    { 544, 320, -720},
    { 544, 320, -728},
    { 544, 320, -720},
    { 544, 328, -728},
    { 544, 320, -720},
    { 544, 320, -720},
    { 544, 328, -720},
    { 536, 320, -728},
    // 262 seconds
    { 536, 328, -728},
    { 544, 328, -728},
    { 544, 328, -728},
    { 544, 320, -728},
    { 544, 320, -728},
    { 536, 328, -720},
    { 536, 328, -728},
    { 544, 328, -720},
    { 544, 320, -720},
    { 536, 328, -720},
    { 536, 328, -720},
    { 536, 328, -720},
    { 536, 320, -720},
    { 544, 320, -728},
    { 544, 328, -720},
    { 536, 320, -720},
    { 536, 320, -720},
    { 536, 320, -728},
    { 536, 328, -720},
    { 536, 320, -720},
    { 544, 328, -720},
    { 536, 320, -728},
    { 536, 320, -728},
    { 536, 328, -728},
    { 536, 320, -728},
    // 263 seconds
    { 536, 328, -728},
    { 536, 320, -728},
    { 536, 320, -728},
    { 536, 328, -728},
    { 528, 320, -720},
    { 536, 328, -728},
    { 536, 328, -728},
    { 536, 328, -728},
    { 536, 320, -720},
    { 536, 320, -728},
    { 544, 320, -720},
    { 536, 328, -720},
    { 536, 328, -728},
    { 536, 328, -728},
    { 528, 328, -720},
    { 536, 328, -728},
    { 536, 320, -728},
    { 536, 328, -728},
    { 528, 328, -720},
    { 536, 328, -728},
    { 536, 320, -728},
    { 536, 328, -728},
    { 536, 328, -728},
    { 536, 328, -720},
    { 536, 328, -720},
    // 264 seconds
    { 536, 328, -728},
    { 536, 320, -728},
    { 536, 328, -728},
    { 536, 328, -728},
    { 536, 328, -728},
    { 536, 328, -728},
    { 536, 320, -728},
    { 536, 328, -728},
    { 528, 320, -728},
    { 528, 328, -728},
    { 536, 320, -720},
    { 536, 328, -728},
    { 528, 320, -712},
    { 536, 328, -736},
    { 536, 320, -744},
    { 536, 328, -720},
    { 536, 328, -728},
    { 536, 328, -736},
    { 528, 328, -736},
    { 536, 320, -736},
    { 528, 328, -736},
    { 528, 328, -736},
    { 528, 328, -736},
    { 528, 320, -728},
    { 528, 320, -736},
    // 265 seconds
    { 536, 320, -736},
    { 528, 328, -736},
    { 528, 320, -728},
    { 536, 328, -736},
    { 520, 328, -736},
    { 528, 328, -728},
    { 536, 320, -728},
    { 536, 328, -736},
    { 528, 328, -728},
    { 520, 320, -728},
    { 528, 328, -728},
    { 528, 320, -728},
    { 528, 328, -728},
    { 528, 320, -736},
    { 520, 328, -728},
    { 528, 328, -736},
    { 528, 328, -744},
    { 528, 328, -736},
    { 528, 328, -728},
    { 528, 328, -736},
    { 536, 328, -728},
    { 528, 328, -728},
    { 528, 328, -728},
    { 536, 328, -736},
    { 520, 328, -728},
    // 266 seconds
    { 528, 336, -736},
    { 528, 328, -736},
    { 528, 328, -736},
    { 520, 328, -736},
    { 528, 328, -736},
    { 520, 320, -728},
    { 520, 328, -736},
    { 520, 328, -728},
    { 528, 328, -736},
    { 520, 328, -736},
    { 520, 328, -736},
    { 520, 320, -736},
    { 520, 328, -736},
    { 520, 328, -736},
    { 520, 328, -736},
    { 520, 328, -736},
    { 528, 328, -736},
    { 520, 320, -736},
    { 528, 328, -736},
    { 520, 328, -736},
    { 520, 328, -736},
    { 528, 328, -744},
    { 520, 328, -744},
    { 520, 328, -728},
    { 520, 328, -736},
    { 520, 328, -736},
    { 520, 328, -744},
    { 528, 328, -736},
    { 520, 328, -736},
    { 520, 328, -744},
    { 512, 320, -736},
    { 520, 328, -736},
    { 528, 328, -736},
    { 520, 328, -736},
    { 520, 328, -752},
    { 520, 328, -736},
    { 520, 320, -736},
    { 520, 328, -744},
    { 520, 328, -728},
    { 520, 328, -744},
    { 520, 328, -744},
    { 520, 320, -736},
    { 520, 336, -736},
    { 520, 328, -736},
    { 520, 328, -736},
    { 520, 320, -736},
    { 520, 328, -744},
    { 520, 328, -736},
    { 512, 328, -744},
    { 520, 328, -744},
    { 520, 328, -744},
    { 528, 328, -744},
    { 528, 328, -744},
    { 528, 328, -736},
    { 528, 328, -752},
    { 536, 328, -760},
    { 536, 312, -760},
    { 544, 304, -776},
    { 536, 288, -776},
    { 552, 264, -792},
    { 576, 248, -784},
    { 584, 208, -816},
    { 576, 160, -776},
    { 552, 128, -800},
    { 576, 72, -840},
    { 576, 104, -840},
    { 560, 72, -808},
    { 560, 104, -856},
    { 608, 128, -824},
    { 608, 112, -720},
    { 696, 72, -816},
    { 696, 328, -912},
    { 664, 352, -1024},
    { 560, 240, -1048},
    { 488, 680, -968},
    // 269 seconds
    { 136, 904, -544},
    { -88, 608, -304},
    { -200, 616, -328},
    { -272, 584, -392},
    { -256, 672, -400},
    { -232, 600, -568},
    { -136, -104, -480},
    { 32, -440, -912},
    { 0, -288, -1056},
    { 0, -320, -1040},
    { -8, -488, -824},
    { 120, -544, -920},
    { 104, -544, -840},
    { 168, -560, -856},
    { 176, -608, -792},
    { 168, -584, -792},
    { 128, -576, -808},
    { 128, -560, -824},
    { 72, -552, -832},
    { 40, -496, -928},
    { 160, -568, -984},
    { -64, -576, -968},
    { 72, -440, -1032},
    { -152, -416, -904},
    { -64, -424, -880},
    // 270 seconds
    { -56, -456, -984},
    { -96, -496, -952},
    { -80, -480, -936},
    { -80, -432, -936},
    { -64, -456, -952},
    { -112, -464, -952},
    { -112, -432, -960},
    { -96, -416, -928},
    { -88, -416, -960},
    { -88, -408, -960},
    { -104, -408, -952},
    { -80, -408, -944},
    { -88, -400, -952},
    { -88, -408, -952},
    { -80, -416, -944},
    { -88, -392, -944},
    { -72, -384, -920},
    { -72, -392, -904},
    { -64, -400, -984},
    { -88, -368, -984},
    { -104, -344, -984},
    { -104, -344, -1000},
    { -112, -312, -1008},
    { -112, -304, -1008},
    { -104, -312, -1000},
    // 271 seconds
    { -104, -288, -992},
    { -104, -280, -984},
    { -104, -296, -992},
    { -80, -280, -992},
    { -80, -296, -968},
    { -80, -304, -984},
    { -88, -304, -984},
    { -48, -288, -984},
    { -80, -304, -968},
    { -80, -304, -984},
    { -88, -296, -992},
    { -88, -296, -976},
    { -88, -304, -992},
    { -88, -304, -984},
    { -80, -304, -984},
    { -80, -304, -984},
    { -80, -296, -984},
    { -88, -296, -992},
    { -88, -288, -984},
    { -80, -296, -992},
    { -88, -296, -976},
    { -88, -304, -984},
    { -88, -288, -992},
    { -96, -288, -984},
    { -96, -288, -992},
    // 272 seconds
    { -88, -288, -992},
    { -96, -280, -1000},
    { -104, -288, -984},
    { -96, -280, -984},
    { -96, -288, -976},
    { -96, -288, -984},
    { -96, -272, -992},
    { -104, -288, -992},
    { -96, -272, -976},
    { -104, -280, -992},
    { -104, -280, -984},
    { -96, -280, -992},
    { -96, -288, -976},
    { -96, -280, -984},
    { -96, -280, -992},
    { -80, -256, -984},
    { -104, -296, -984},
    { -80, -272, -1016},
    { -56, -296, -1000},
    { -8, -288, -1040},
    { 32, -192, -1152},
    { 136, -232, -1056},
    { 56, -184, -920},
    { -80, -80, -872},
    { -160, 96, -856},
    // 273 seconds
    { -264, 432, -824},
    { -352, 480, -736},
    { -344, 624, -736},
    { -344, 632, -720},
    { -304, 576, -672},
    { -272, 688, -608},
    { -296, 704, -528},
    { -240, 728, -456},
    { -192, 784, -368},
    { -144, 928, -424},
    { -128, 920, -512},
    { -48, 760, -464},
    { 24, 872, -464},
    { 96, 792, -384},
    { 88, 912, -200},
    { 88, 992, -48},
    { 112, 1048, 16},
    { 112, 1032, 56},
    { 88, 1080, 128},
    { 72, 1072, 208},
    { 56, 1016, 248},
    { -16, 968, 256},
    { -56, 944, 352},
    { -64, 800, 256},
    { -104, 856, 360},
    // 274 seconds
    { -168, 864, 344},
    { -168, 840, 320},
    { -152, 776, 344},
    { -176, 800, 336},
    { -160, 856, 280},
    { -128, 872, 296},
    { -128, 776, 296},
    { -128, 824, 256},
    { -152, 1016, 200},
    { -184, 1008, 136},
    { -224, 968, -16},
    { -216, 1032, -128},
    { -248, 992, -216},
    { -288, 800, -440},
    { -296, 656, -800},
    { -272, 720, -800},
    { -256, 504, -832},
    { -224, -224, -728},
    { -176, -240, -920},
    { -64, -144, -904},
    { -8, -216, -816},
    { 40, -256, -872},
    { 48, -320, -848},
    { 40, -352, -872},
    { 40, -400, -904},
    // 275 seconds
    { 40, -472, -888},
    { 56, -464, -920},
    { 80, -440, -960},
    { 88, -432, -976},
    { 88, -408, -1008},
    { 128, -568, -1272},
    { 32, -400, -984},
    { 56, -368, -888},
    { 120, -464, -984},
    { 104, -432, -912},
    { 120, -432, -912},
    { 112, -416, -928},
    { 104, -416, -928},
    { 96, -424, -928},
    { 96, -424, -936},
    { 96, -416, -936},
    { 96, -408, -960},
    { 88, -400, -952},
    { 80, -400, -952},
    { 80, -400, -952},
    { 72, -400, -944},
    { 72, -384, -960},
    { 80, -384, -960},
    { 72, -392, -952},
    { 72, -392, -960},
    // 276 seconds
    { 72, -376, -960},
    { 72, -384, -952},
    { 72, -384, -960},
    { 72, -376, -952},
    { 72, -376, -952},
    { 72, -376, -952},
    { 80, -384, -960},
    { 72, -368, -952},
    { 72, -376, -960},
    { 72, -368, -960},
    { 72, -368, -960},
    { 64, -368, -960},
    { 72, -376, -952},
    { 72, -368, -960},
    { 72, -368, -960},
    { 72, -376, -952},
    { 72, -368, -960},
    { 64, -368, -960},
    { 64, -376, -960},
    { 72, -368, -960},
    { 72, -368, -952},
    { 72, -368, -960},
    { 64, -368, -960},
    { 72, -368, -960},
    { 64, -376, -952},
    // 277 seconds
    { 64, -360, -960},
    { 72, -360, -968},
    { 72, -360, -960},
    { 72, -368, -960},
    { 64, -368, -960},
    { 64, -360, -960},
    { 72, -368, -960},
    { 64, -376, -960},
    { 72, -368, -968},
    { 64, -360, -960},
    { 64, -368, -960},
    { 64, -368, -960},
    { 72, -368, -952},
    { 64, -360, -960},
    { 64, -360, -960},
    { 56, -368, -960},
    { 64, -376, -960},
    { 56, -376, -968},
    { 56, -384, -976},
    { 64, -376, -1008},
    { 56, -384, -1040},
    { 32, -424, -984},
    { 16, -440, -968},
    { 8, -416, -976},
    { -32, -384, -936},
    // 278 seconds
    { -64, -360, -952},
    { -104, -368, -960},
    { -112, -408, -928},
    { -96, -408, -952},
    { -96, -400, -992},
    { -88, -432, -944},
    { -80, -408, -920},
    { -96, -376, -936},
    { -88, -400, -936},
    { -64, -432, -880},
    { -40, -440, -856},
    { -24, -424, -912},
    { -32, -440, -896},
    { -48, -440, -840},
    { -24, -416, -904},
    { -32, -416, -936},
    { -64, -440, -992},
    { -64, -416, -1008},
    { -80, -384, -968},
    { -80, -376, -976},
    { -80, -376, -1000},
    { -56, -320, -984},
    { -96, -328, -992},
    { -104, -304, -1008},
    { -104, -328, -1008},
    // 279 seconds
    { -104, -312, -992},
    { -104, -304, -984},
    { -112, -304, -984},
    { -96, -288, -976},
    { -104, -312, -968},
    { -88, -304, -992},
    { -88, -304, -992},
    { -72, -320, -984},
    { -80, -320, -992},
    { -88, -328, -984},
    { -96, -320, -976},
    { -112, -320, -976},
    { -120, -304, -976},
    { -128, -312, -984},
    { -136, -304, -968},
    { -128, -304, -968},
    { -144, -296, -968},
    { -144, -296, -968},
    { -136, -296, -976},
    { -144, -296, -984},
    { -152, -288, -992},
    { -152, -296, -976},
    { -144, -288, -984},
    { -152, -288, -976},
    { -152, -296, -976},
    // 280 seconds
    { -144, -296, -984},
    { -136, -296, -984},
    { -136, -304, -984},
    { -136, -288, -976},
    { -128, -304, -976},
    { -136, -304, -976},
    { -136, -288, -976},
    { -128, -296, -984},
    { -136, -296, -984},
    { -128, -288, -984},
    { -136, -296, -976},
    { -136, -288, -984},
    { -136, -296, -992},
    { -128, -288, -984},
    { -136, -288, -976},
    { -136, -288, -992},
    { -136, -288, -992},
    { -136, -288, -992},
    { -96, -280, -992},
    { -112, -328, -976},
    { -112, -304, -1008},
    { -112, -280, -1064},
    { 48, -352, -1088},
    { 48, -280, -1112},
    { 96, -272, -1040},
    // 281 seconds
    { 8, -192, -968},
    { -48, -168, -840},
    { -144, 160, -840},
    { -272, 336, -728},
    { -376, 448, -640},
    { -456, 544, -720},
    { -448, 440, -744},
    { -480, 456, -704},
    { -448, 624, -832},
    { -432, 648, -880},
    { -432, 592, -848},
    { -408, 544, -816},
    { -336, 520, -848},
    { -312, 480, -824},
    { -280, 448, -840},
    { -264, 432, -832},
    { -264, 432, -792},
    { -312, 400, -832},
    { -440, 544, -928},
    { -560, 504, -984},
    { -624, 272, -976},
    { -528, 184, -832},
    { -400, 48, -832},
    { -256, 8, -904},
    { -128, -144, -888},
    // 282 seconds
    { 8, -192, -840},
    { 104, -208, -944},
    { 224, -288, -1096},
    { 32, -344, -1040},
    { -40, -328, -872},
    { -88, -320, -904},
    { -8, -328, -984},
    { -224, -360, -1032},
    { -144, -304, -1008},
    { -192, -312, -1000},
    { -152, -296, -984},
    { -160, -296, -968},
    { -72, -304, -984},
    { -120, -304, -992},
    { -136, -320, -984},
    { -152, -280, -1000},
    { -184, -280, -1008},
    { -168, -280, -984},
    { -160, -272, -968},
    { -200, -264, -968},
    { -216, -264, -984},
    { -208, -264, -976},
    { -208, -256, -976},
    { -216, -240, -984},
    { -216, -248, -984},
    // 283 seconds
    { -224, -224, -976},
    { -224, -224, -984},
    { -216, -224, -976},
    { -232, -224, -984},
    { -224, -224, -976},
    { -224, -208, -984},
    { -224, -208, -992},
    { -232, -224, -976},
    { -232, -224, -984},
    { -224, -216, -992},
    { -232, -216, -984},
    { -224, -208, -984},
    { -224, -216, -992},
    { -232, -216, -984},
    { -232, -216, -976},
    { -224, -216, -984},
    { -232, -208, -992},
    { -224, -216, -992},
    { -232, -208, -992},
    { -232, -208, -984},
    { -232, -200, -984},
    { -232, -192, -992},
    { -240, -192, -992},
    { -240, -184, -984},
    { -248, -168, -984},
    // 284 seconds
    { -240, -160, -992},
    { -256, -160, -992},
    { -256, -160, -984},
    { -256, -152, -992},
    { -248, -160, -984},
    { -240, -168, -992},
    { -248, -160, -992},
    { -256, -160, -976},
    { -240, -152, -992},
    { -240, -152, -992},
    { -240, -152, -992},
    { -240, -152, -984},
    { -248, -144, -992},
    { -248, -144, -984},
    { -256, -144, -992},
    { -256, -136, -984},
    { -256, -136, -984},
    { -248, -128, -992},
    { -256, -136, -992},
    { -248, -136, -992},
    { -248, -136, -984},
    { -240, -136, -992},
    { -248, -136, -992},
    { -240, -144, -992},
    { -240, -152, -984},
    // 285 seconds
    { -240, -144, -984},
    { -240, -144, -992},
    { -248, -144, -992},
    { -248, -144, -992},
    { -248, -144, -992},
    { -232, -136, -992},
    { -240, -136, -984},
    { -240, -144, -992},
    { -240, -144, -992},
    { -240, -144, -992},
    { -240, -144, -1000},
    { -240, -144, -992},
    { -240, -136, -992},
    { -240, -144, -992},
    { -240, -144, -992},
    { -240, -136, -984},
    { -240, -136, -984},
    { -240, -136, -1000},
    { -248, -144, -992},
    { -248, -136, -992},
    { -248, -144, -992},
    { -248, -144, -992},
    { -240, -152, -992},
    { -240, -144, -992},
    { -240, -144, -984},
    // 286 seconds
    { -248, -144, -992},
    { -240, -136, -992},
    { -240, -136, -984},
    { -240, -152, -984},
    { -240, -144, -1000},
    { -240, -152, -992},
    { -224, -144, -1000},
    { -208, -152, -1040},
    { -80, -296, -968},
    { -8, -240, -1064},
    { -32, -208, -1000},
    { 64, -144, -896},
    { -8, 48, -832},
    { -88, 64, -928},
    { -208, 280, -928},
    { -328, 432, -840},
    { -384, 536, -728},
    { -400, 696, -704},
    { -432, 672, -576},
    { -336, 544, -544},
    { -200, 672, -480},
    { -224, 744, -280},
    { -216, 992, -160},
    { -312, 712, 8},
    { -144, 552, 304},
    // 287 seconds
    { -24, 856, 304},
    { -32, 1096, 152},
    { 144, 1168, -144},
    { 264, 1192, -200},
    { 312, 1280, -456},
    { 392, 624, -416},
    { 472, 560, -296},
    { 560, 672, -320},
    { 536, 968, -472},
    { 520, 920, -376},
    { 416, 776, -272},
    { 344, 720, -256},
    { 384, 776, -312},
    { 432, 808, -360},
    { 448, 784, -272},
    { 472, 800, -224},
    { 464, 792, -208},
    { 440, 776, -192},
    { 432, 784, -240},
    { 424, 784, -232},
    { 416, 792, -256},
    { 416, 776, -288},
    { 416, 792, -304},
    { 408, 784, -288},
    { 408, 776, -296},
    // 288 seconds
    { 408, 784, -288},
    { 416, 784, -280},
    { 408, 784, -280},
    { 416, 784, -272},
    { 416, 784, -272},
    { 416, 776, -272},
    { 424, 784, -272},
    { 424, 784, -280},
    { 416, 776, -280},
    { 408, 792, -288},
    { 424, 784, -264},
    { 424, 784, -272},
    { 424, 776, -264},
    { 424, 776, -272},
    { 424, 776, -272},
    { 432, 776, -272},
    { 440, 768, -272},
    { 440, 776, -272},
    { 440, 776, -264},
    { 440, 768, -272},
    { 440, 768, -272},
    { 448, 768, -256},
    { 448, 768, -256},
    { 448, 768, -264},
    { 456, 768, -264},
    // 289 seconds
    { 448, 768, -264},
    { 448, 768, -264},
    { 448, 768, -264},
    { 456, 760, -256},
    { 456, 760, -256},
    { 464, 760, -264},
    { 456, 760, -256},
    { 472, 752, -264},
    { 472, 752, -256},
    { 464, 760, -256},
    { 464, 760, -264},
    { 472, 752, -248},
    { 472, 752, -248},
    { 472, 760, -256},
    { 480, 752, -256},
    { 480, 752, -256},
    { 480, 752, -248},
    { 472, 752, -248},
    { 480, 744, -256},
    { 488, 752, -256},
    { 488, 744, -256},
    { 488, 744, -248},
    { 488, 744, -264},
    { 496, 744, -256},
    { 488, 744, -248},
    // 290 seconds
    { 488, 744, -256},
    { 512, 728, -256},
    { 496, 744, -256},
    { 488, 736, -248},
    { 488, 728, -248},
    { 504, 736, -248},
    { 504, 728, -248},
    { 504, 728, -264},
    { 496, 736, -264},
    { 496, 744, -264},
    { 496, 728, -256},
    { 488, 744, -272},
    { 496, 736, -256},
    { 480, 744, -256},
    { 480, 752, -288},
    { 480, 744, -280},
    { 480, 736, -256},
    { 488, 744, -272},
    { 488, 744, -272},
    { 480, 752, -272},
    { 488, 752, -264},
    { 496, 744, -272},
    { 504, 768, -304},
    { 504, 768, -328},
    { 496, 728, -296},
    // 291 seconds
    { 464, 712, -264},
    { 440, 696, -216},
    { 432, 744, -240},
    { 424, 776, -296},
    { 440, 744, -320},
    { 448, 736, -312},
    { 464, 736, -320},
    { 464, 720, -288},
    { 472, 744, -264},
    { 488, 752, -288},
    { 520, 744, -304},
    { 496, 752, -264},
    { 480, 744, -272},
    { 480, 744, -280},
    { 488, 744, -272},
    { 504, 728, -272},
    { 512, 752, -280},
    { 536, 776, -288},
    { 504, 728, -312},
    { 504, 752, -328},
    { 544, 768, -336},
    { 568, 728, -288},
    { 528, 760, -280},
    { 504, 848, -328},
    { 464, 904, -344},
    // 292 seconds
    { 464, 880, -368},
    { 488, 928, -520},
    { 448, 1008, -456},
    { 344, 824, -336},
    { 232, 936, -120},
    { -8, 832, 80},
    { -232, 776, 208},
    { -328, 840, 200},
    { -280, 824, 208},
    { -312, 720, 192},
    { -344, 720, 48},
    { -288, 816, -168},
    { -200, 728, -504},
    { -208, 592, -528},
    { -136, 680, -736},
    { -96, 672, -856},
    { -72, 312, -840},
    { 72, -40, -848},
    { 120, -152, -912},
    { 160, -192, -968},
    { 136, -288, -952},
    { 88, -344, -912},
    { 80, -304, -944},
    { 64, -408, -1072},
    { 0, -384, -1064},
    // 293 seconds
    { -136, -344, -1120},
    { -24, -280, -1008},
    { 0, -288, -1000},
    { 0, -320, -1008},
    { -32, -296, -976},
    { -32, -320, -992},
    { -32, -328, -976},
    { -24, -296, -992},
    { -32, -296, -984},
    { -32, -336, -976},
    { -48, -320, -984},
    { -48, -296, -984},
    { -48, -320, -984},
    { -48, -312, -984},
    { -56, -312, -976},
    { -56, -288, -992},
    { -48, -312, -984},
    { -40, -304, -984},
    { -40, -296, -984},
    { -40, -304, -984},
    { -56, -328, -976},
    { -88, -296, -1000},
    { -56, -256, -1000},
    { -112, -296, -976},
    { -8, -312, -1016},
    // 294 seconds
    { -96, -280, -992},
    { -88, -288, -976},
    { -72, -296, -984},
    { -80, -288, -1000},
    { -96, -304, -976},
    { -80, -304, -976},
    { -96, -280, -1000},
    { -112, -312, -976},
    { -104, -304, -976},
    { -120, -272, -984},
    { -112, -296, -984},
    { -104, -288, -984},
    { -104, -304, -984},
    { -104, -312, -984},
    { -112, -304, -984},
    { -112, -280, -992},
    { -128, -288, -984},
    { -120, -312, -976},
    { -112, -304, -992},
    { -136, -280, -992},
    { -136, -280, -984},
    { -152, -296, -976},
    { -144, -304, -976},
    { -128, -320, -984},
    { -136, -320, -984},
    // 295 seconds
    { -144, -304, -968},
    { -144, -296, -984},
    { -144, -296, -976},
    { -136, -312, -976},
    { -136, -312, -976},
    { -144, -312, -976},
    { -136, -320, -976},
    { -128, -312, -984},
    { -136, -360, -960},
    { -128, -344, -976},
    { -128, -344, -976},
    { -128, -352, -968},
    { -128, -352, -968},
    { -128, -352, -968},
    { -136, -344, -968},
    { -136, -344, -968},
    { -136, -336, -968},
    { -136, -344, -968},
    { -128, -344, -968},
    { -136, -344, -968},
    { -128, -344, -968},
    { -136, -328, -968},
    { -136, -328, -968},
    { -136, -328, -976},
    { -144, -320, -976},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}
