/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */




// ----------------------------------------------------------------
// Sample captured: 2015-10-22 10:02:15 local
AccelRawData *activity_sample_walk_600_pbl_28361_1(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_600_pbl_28361_1
  //> TEST_EXPECTED 600
  //> TEST_EXPECTED_MIN 550
  //> TEST_EXPECTED_MAX 650
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 88, 224, -1080},
    { -40, 136, -1096},
    { -152, -64, -1032},
    { -120, -72, -1032},
    { -232, -184, -920},
    { -112, -216, -944},
    { -176, -240, -984},
    { -120, -288, -1000},
    { -296, -264, -984},
    { -192, -376, -1016},
    { -344, -464, -1032},
    { -24, -368, -1112},
    { -192, -496, -1024},
    { 120, -200, -1008},
    { 48, -272, -1000},
    { 256, -144, -968},
    { 16, -240, -944},
    { -152, -392, -888},
    { -144, -448, -840},
    { -264, -424, -888},
    { -256, -456, -832},
    { -224, -552, -808},
    { -368, -552, -752},
    { -344, -560, -880},
    { -280, -552, -880},
    // 1 seconds
    { -368, -600, -832},
    { -368, -744, -816},
    { -304, -384, -1128},
    { -224, -336, -1032},
    { -376, -376, -992},
    { -184, -192, -952},
    { -152, -208, -1016},
    { 144, -736, -616},
    { -48, -168, -896},
    { -88, -400, -912},
    { -56, -352, -920},
    { -88, -584, -896},
    { -72, -448, -896},
    { -8, -576, -912},
    { 24, -496, -920},
    { -88, 480, -960},
    { -416, 272, -1000},
    { -200, 72, -1136},
    { -200, 256, -984},
    { 64, 48, -1096},
    { 152, -16, -936},
    { 176, -80, -848},
    { 0, 184, -792},
    { -136, 256, -704},
    { -800, 544, -744},
    // 2 seconds
    { -768, 536, -872},
    { -808, 464, -912},
    { -848, 608, -872},
    { -696, 384, -952},
    { -776, 600, -1176},
    { -224, 472, -1184},
    { -168, 328, -1016},
    { -192, 416, -1064},
    { -40, 400, -984},
    { 72, 296, -864},
    { -24, 312, -816},
    { -80, 232, -744},
    { -88, 136, -736},
    { -72, 344, -800},
    { 24, 152, -824},
    { 136, 160, -864},
    { 280, 152, -696},
    { 320, 16, -496},
    { 624, 536, -688},
    { 760, 216, -568},
    { 976, 496, -688},
    { 1272, 1024, -1080},
    { 984, 640, -592},
    { 952, 576, -792},
    { 568, 760, -480},
    // 3 seconds
    { 440, 696, -408},
    { 376, 600, -456},
    { 296, 720, -456},
    { 216, 752, -472},
    { 384, 760, -616},
    { 472, 776, -560},
    { 768, 744, -744},
    { 864, 816, -704},
    { 648, 640, -552},
    { 768, 760, -656},
    { 744, 536, -488},
    { 600, 464, -384},
    { 496, 360, -376},
    { 624, 416, -360},
    { 720, 424, -344},
    { 896, 344, -368},
    { 944, 264, -328},
    { 952, 136, -328},
    { 968, 112, -424},
    { 1112, 160, -456},
    { 632, 64, -544},
    { 904, 72, -536},
    { 1152, 48, -440},
    { 1048, 56, -432},
    { 976, 216, -424},
    // 4 seconds
    { 920, 208, -440},
    { 896, 288, -488},
    { 888, 360, -536},
    { 888, 360, -536},
    { 832, 424, -536},
    { 776, 264, -400},
    { 1248, 528, -488},
    { 1272, 288, -328},
    { 1320, 400, -232},
    { 1480, 280, -200},
    { 1112, 144, -128},
    { 952, 80, -176},
    { 1032, 136, -144},
    { 1024, 72, -168},
    { 952, 72, -192},
    { 1056, 40, -208},
    { 1128, 8, -216},
    { 824, -128, -304},
    { 904, -88, -352},
    { 840, 64, -368},
    { 720, 16, -488},
    { 992, 128, -560},
    { 1024, 136, -352},
    { 896, 16, -264},
    { 840, 264, -368},
    // 5 seconds
    { 928, 232, -320},
    { 1000, 504, -408},
    { 976, 520, -424},
    { 872, 656, -448},
    { 840, 552, -376},
    { 952, 584, -296},
    { 1280, 536, -320},
    { 1320, 464, -192},
    { 1280, 312, -160},
    { 1112, 272, -208},
    { 816, 160, -200},
    { 736, 104, -160},
    { 960, 120, -176},
    { 1112, 120, -160},
    { 1120, 112, -176},
    { 1144, 80, -216},
    { 1136, 80, -216},
    { 816, -72, -216},
    { 1120, 88, -280},
    { 632, -112, -392},
    { 896, 200, -528},
    { 1064, 88, -416},
    { 840, -32, -328},
    { 752, 176, -392},
    { 768, 144, -368},
    // 6 seconds
    { 904, 280, -360},
    { 1056, 360, -424},
    { 1080, 480, -448},
    { 960, 544, -464},
    { 888, 496, -448},
    { 1136, 616, -392},
    { 1096, 456, -336},
    { 1368, 496, -272},
    { 1464, 368, -224},
    { 1120, 224, -216},
    { 832, 128, -240},
    { 768, 128, -192},
    { 952, 112, -184},
    { 1104, 104, -160},
    { 1232, 112, -136},
    { 1208, 96, -176},
    { 1048, 56, -216},
    { 744, -120, -184},
    { 1104, 8, -216},
    { 712, 8, -432},
    { 968, 24, -448},
    { 1040, 8, -312},
    { 792, -8, -320},
    { 736, 192, -408},
    { 888, 160, -400},
    // 7 seconds
    { 1136, 344, -456},
    { 1232, 448, -488},
    { 1064, 512, -448},
    { 992, 656, -472},
    { 896, 544, -392},
    { 1168, 648, -368},
    { 1200, 488, -248},
    { 1192, 432, -248},
    { 1256, 336, -216},
    { 952, 192, -192},
    { 840, 136, -232},
    { 888, 104, -192},
    { 1024, 96, -192},
    { 1128, 88, -184},
    { 1184, 32, -264},
    { 1200, -40, -216},
    { 824, -32, -256},
    { 1048, -8, -280},
    { 824, 0, -360},
    { 776, 152, -560},
    { 1136, 64, -496},
    { 976, -48, -256},
    { 816, 104, -360},
    { 736, 248, -464},
    { 816, 160, -328},
    // 8 seconds
    { 1056, 272, -424},
    { 1072, 432, -512},
    { 1008, 528, -592},
    { 936, 528, -592},
    { 1288, 456, -512},
    { 944, 232, -280},
    { 1112, 280, -320},
    { 1152, 232, -312},
    { 1008, 144, -248},
    { 904, 64, -216},
    { 800, -120, -104},
    { 856, 40, -176},
    { 872, -104, -168},
    { 1136, -16, -184},
    { 1264, -224, -8},
    { 792, -168, -224},
    { 1472, -152, 8},
    { 1208, -136, -384},
    { 1368, -64, -368},
    { 1080, -120, -160},
    { 736, -64, -288},
    { 552, 72, -288},
    { 648, 96, -272},
    { 832, 264, -384},
    { 888, 232, -424},
    // 9 seconds
    { 920, 320, -544},
    { 896, 336, -528},
    { 896, 320, -376},
    { 1384, 472, -496},
    { 1296, 344, -296},
    { 1344, 304, -280},
    { 1368, 248, -288},
    { 912, 144, -232},
    { 712, 48, -272},
    { 696, 128, -296},
    { 904, 24, -264},
    { 1192, 48, -248},
    { 1280, 0, -248},
    { 1080, -16, -248},
    { 704, -80, -376},
    { 1192, 48, -280},
    { 760, -40, -424},
    { 1008, 80, -496},
    { 1072, 80, -448},
    { 824, 56, -336},
    { 656, 216, -336},
    { 728, 136, -304},
    { 872, 320, -320},
    { 1112, 352, -344},
    { 1056, 504, -448},
    // 10 seconds
    { 976, 600, -472},
    { 928, 520, -368},
    { 1040, 616, -416},
    { 1088, 480, -352},
    { 1272, 512, -272},
    { 1272, 432, -280},
    { 1016, 248, -248},
    { 760, 192, -240},
    { 784, 80, -232},
    { 984, 136, -232},
    { 1224, 72, -232},
    { 1288, 48, -184},
    { 1280, 56, -208},
    { 952, -72, -168},
    { 824, -200, -152},
    { 1088, -16, -152},
    { 784, 48, -384},
    { 1056, 88, -424},
    { 912, 56, -264},
    { 688, -24, -248},
    { 776, 176, -312},
    { 880, 232, -320},
    { 1144, 456, -400},
    { 1240, 576, -456},
    { 1088, 584, -392},
    // 11 seconds
    { 992, 640, -448},
    { 984, 608, -400},
    { 1168, 568, -312},
    { 1128, 496, -248},
    { 1176, 424, -288},
    { 1168, 328, -216},
    { 888, 192, -192},
    { 784, 80, -184},
    { 880, 176, -216},
    { 1184, 104, -200},
    { 1336, 88, -160},
    { 1240, 56, -224},
    { 976, -40, -216},
    { 768, 40, -296},
    { 1048, 88, -264},
    { 528, 72, -408},
    { 1000, 144, -472},
    { 992, -48, -264},
    { 776, -48, -360},
    { 664, 144, -392},
    { 728, 120, -296},
    { 968, 376, -456},
    { 1160, 464, -456},
    { 1248, 552, -464},
    { 1160, 680, -496},
    // 12 seconds
    { 952, 464, -328},
    { 1128, 744, -472},
    { 960, 440, -264},
    { 1016, 488, -248},
    { 1056, 336, -256},
    { 808, 240, -232},
    { 712, 168, -256},
    { 824, 168, -280},
    { 1064, 96, -232},
    { 1224, 56, -224},
    { 1240, 8, -264},
    { 1064, -128, -240},
    { 848, -160, -280},
    { 1160, -32, -328},
    { 1000, 24, -512},
    { 1104, 56, -560},
    { 856, 8, -256},
    { 528, 40, -248},
    { 576, 96, -328},
    { 632, 248, -264},
    { 936, 440, -408},
    { 1120, 544, -424},
    { 1128, 608, -440},
    { 960, 544, -344},
    { 1128, 664, -408},
    // 13 seconds
    { 1080, 440, -256},
    { 1136, 536, -224},
    { 1144, 352, -192},
    { 1128, 320, -224},
    { 936, 144, -216},
    { 792, 120, -208},
    { 968, 104, -192},
    { 1040, 96, -152},
    { 1152, 8, -168},
    { 1112, -104, -80},
    { 904, -112, -120},
    { 1464, -96, -256},
    { 1088, 72, -200},
    { 960, 168, -424},
    { 1080, 144, -480},
    { 976, 80, -256},
    { 728, 120, -288},
    { 696, 160, -312},
    { 784, 304, -336},
    { 888, 384, -368},
    { 1040, 456, -416},
    { 1048, 496, -376},
    { 992, 448, -352},
    { 888, 520, -376},
    { 1120, 480, -208},
    // 14 seconds
    { 1216, 480, -144},
    { 1336, 416, -248},
    { 1304, 304, -208},
    { 920, 168, -304},
    { 800, 56, -200},
    { 872, 136, -256},
    { 976, 64, -216},
    { 1016, 104, -208},
    { 1072, 96, -216},
    { 1104, 80, -192},
    { 1048, 128, -240},
    { 896, 136, -288},
    { 728, 96, -400},
    { 1128, 64, -384},
    { 976, 144, -304},
    { 704, 48, -296},
    { 632, 168, -320},
    { 696, 176, -312},
    { 920, 288, -360},
    { 1176, 400, -376},
    { 1328, 584, -448},
    { 1104, 568, -376},
    { 1064, 384, -296},
    { 1360, 568, -408},
    { 1048, 336, -208},
    // 15 seconds
    { 1040, 480, -288},
    { 1024, 328, -280},
    { 856, 248, -288},
    { 712, 168, -272},
    { 760, 96, -256},
    { 984, 152, -256},
    { 1224, 88, -192},
    { 1296, 80, -224},
    { 1248, 56, -272},
    { 856, -192, -232},
    { 1288, 0, -160},
    { 640, -280, -312},
    { 1144, 0, -424},
    { 1152, -112, -248},
    { 856, -104, -240},
    { 776, -8, -296},
    { 768, 112, -280},
    { 960, 296, -368},
    { 1056, 320, -360},
    { 1104, 432, -408},
    { 1072, 488, -440},
    { 1000, 544, -408},
    { 1208, 768, -440},
    { 944, 488, -304},
    { 1056, 576, -320},
    // 16 seconds
    { 1056, 384, -344},
    { 1080, 272, -344},
    { 1000, 184, -296},
    { 960, 136, -264},
    { 1096, 88, -176},
    { 1104, 56, -160},
    { 1168, 64, -200},
    { 1208, 56, -192},
    { 1000, -80, -136},
    { 1008, -136, -88},
    { 840, -136, -184},
    { 1008, 40, -376},
    { 1088, -32, -360},
    { 944, -8, -264},
    { 624, -72, -328},
    { 680, 32, -272},
    { 952, 200, -360},
    { 1168, 344, -440},
    { 1296, 392, -464},
    { 1192, 536, -568},
    { 952, 456, -472},
    { 1000, 576, -424},
    { 1288, 592, -416},
    { 1208, 504, -272},
    { 1232, 448, -312},
    // 17 seconds
    { 1136, 320, -272},
    { 856, 200, -240},
    { 760, 96, -240},
    { 864, 232, -256},
    { 1256, 72, -176},
    { 1400, 120, -88},
    { 1304, 48, -128},
    { 1088, -56, -112},
    { 672, -176, -200},
    { 1360, -64, -128},
    { 936, -56, -304},
    { 944, 112, -456},
    { 1000, 96, -336},
    { 824, 40, -240},
    { 688, 128, -328},
    { 776, 136, -240},
    { 1040, 312, -320},
    { 1368, 464, -368},
    { 1256, 600, -424},
    { 1072, 624, -440},
    { 824, 544, -368},
    { 960, 696, -416},
    { 1040, 624, -280},
    { 1376, 600, -232},
    { 1360, 448, -240},
    // 18 seconds
    { 1136, 272, -208},
    { 840, 168, -200},
    { 808, 136, -240},
    { 1064, 160, -208},
    { 1240, 96, -160},
    { 1272, 32, -128},
    { 1232, 96, -208},
    { 784, -104, -216},
    { 976, -56, -168},
    { 768, -80, -296},
    { 976, 184, -488},
    { 1008, 72, -360},
    { 848, 104, -280},
    { 704, 72, -304},
    { 776, 152, -280},
    { 968, 296, -368},
    { 1232, 448, -456},
    { 1240, 552, -456},
    { 1128, 648, -512},
    { 904, 624, -440},
    { 1208, 800, -456},
    { 1056, 576, -232},
    { 1240, 568, -248},
    { 1280, 432, -232},
    { 1136, 296, -216},
    // 19 seconds
    { 872, 208, -192},
    { 792, 152, -192},
    { 976, 192, -136},
    { 1120, 160, -168},
    { 1200, 72, -184},
    { 1096, -48, -96},
    { 864, -64, -256},
    { 864, -48, -304},
    { 976, 24, -208},
    { 952, 112, -456},
    { 1032, 88, -448},
    { 1016, 112, -280},
    { 840, 56, -344},
    { 752, 136, -280},
    { 872, 256, -384},
    { 1040, 384, -464},
    { 1168, 464, -448},
    { 1120, 504, -448},
    { 952, 576, -480},
    { 848, 488, -392},
    { 1304, 664, -368},
    { 1224, 504, -232},
    { 1336, 488, -240},
    { 1256, 360, -240},
    { 1072, 192, -224},
    // 20 seconds
    { 888, 152, -184},
    { 856, 176, -208},
    { 1008, 152, -200},
    { 1112, 120, -128},
    { 1168, 96, -152},
    { 1160, 72, -176},
    { 864, 8, -168},
    { 816, 40, -280},
    { 840, 24, -248},
    { 792, 64, -328},
    { 1112, 112, -352},
    { 1032, 72, -296},
    { 776, 88, -336},
    { 720, 200, -320},
    { 880, 176, -264},
    { 1120, 472, -360},
    { 1216, 544, -304},
    { 1176, 576, -288},
    { 1160, 640, -384},
    { 936, 520, -336},
    { 1144, 624, -320},
    { 1088, 544, -216},
    { 1344, 536, -216},
    { 1288, 424, -208},
    { 1000, 256, -216},
    // 21 seconds
    { 760, 160, -216},
    { 808, 192, -224},
    { 1104, 144, -160},
    { 1328, 80, -48},
    { 1264, 48, -136},
    { 1224, 80, -176},
    { 856, -96, -160},
    { 1312, -152, -144},
    { 800, -112, -216},
    { 904, 136, -456},
    { 1000, 64, -424},
    { 880, 24, -288},
    { 568, 56, -360},
    { 704, 184, -360},
    { 1016, 320, -376},
    { 1296, 512, -488},
    { 1232, 512, -408},
    { 1080, 680, -512},
    { 904, 544, -456},
    { 1152, 728, -424},
    { 1128, 664, -344},
    { 1264, 544, -248},
    { 1304, 456, -264},
    { 1008, 256, -216},
    { 752, 144, -200},
    // 22 seconds
    { 776, 144, -128},
    { 1016, 256, -96},
    { 1240, 144, -96},
    { 1240, 200, -112},
    { 1256, 136, -112},
    { 960, 16, -152},
    { 1512, -48, -88},
    { 600, -136, -320},
    { 872, 128, -456},
    { 1016, 72, -360},
    { 888, 56, -296},
    { 744, 88, -368},
    { 776, 112, -456},
    { 872, 136, -336},
    { 1048, 376, -424},
    { 1080, 344, -392},
    { 1064, 512, -472},
    { 992, 440, -424},
    { 984, 440, -336},
    { 1304, 608, -408},
    { 1288, 488, -232},
    { 1184, 424, -264},
    { 1016, 304, -288},
    { 800, 224, -224},
    { 768, 160, -232},
    // 23 seconds
    { 824, 160, -224},
    { 968, 104, -184},
    { 1088, 88, -168},
    { 1224, 80, -168},
    { 1232, 96, -248},
    { 936, 8, -264},
    { 1112, -40, -256},
    { 760, -48, -296},
    { 824, 104, -504},
    { 1024, 32, -440},
    { 880, 48, -288},
    { 664, 24, -320},
    { 656, 168, -328},
    { 792, 240, -320},
    { 1000, 368, -368},
    { 1072, 416, -344},
    { 1104, 520, -408},
    { 1040, 552, -400},
    { 960, 584, -352},
    { 1304, 648, -360},
    { 1160, 488, -224},
    { 1120, 472, -272},
    { 1080, 384, -264},
    { 880, 280, -224},
    { 808, 136, -176},
    // 24 seconds
    { 848, 168, -224},
    { 952, 88, -120},
    { 1112, 88, -152},
    { 1248, 80, -128},
    { 1200, 112, -184},
    { 1032, 24, -208},
    { 1008, 24, -216},
    { 816, -32, -248},
    { 720, 104, -368},
    { 1040, 56, -336},
    { 1040, 72, -264},
    { 832, 96, -320},
    { 744, 176, -272},
    { 840, 224, -264},
    { 1016, 376, -320},
    { 1088, 456, -280},
    { 1080, 552, -336},
    { 1032, 560, -336},
    { 936, 504, -264},
    { 1216, 672, -352},
    { 1064, 448, -192},
    { 1184, 496, -232},
    { 1152, 352, -224},
    { 1000, 264, -224},
    { 880, 184, -248},
    // 25 seconds
    { 888, 112, -160},
    { 1064, 144, -160},
    { 1208, 48, -120},
    { 1192, 96, -144},
    { 1216, 96, -176},
    { 912, -40, -192},
    { 968, -48, -184},
    { 768, -48, -296},
    { 888, 176, -456},
    { 1080, 72, -384},
    { 976, 96, -280},
    { 704, 64, -312},
    { 688, 192, -296},
    { 856, 280, -328},
    { 1064, 408, -344},
    { 1160, 488, -352},
    { 1040, 576, -392},
    { 968, 568, -376},
    { 936, 576, -272},
    { 1280, 632, -272},
    { 1160, 528, -184},
    { 1168, 504, -208},
    { 1168, 352, -216},
    { 960, 224, -200},
    { 872, 216, -272},
    // 26 seconds
    { 912, 168, -248},
    { 1056, 120, -144},
    { 1112, 88, -168},
    { 1208, 88, -176},
    { 1216, 120, -192},
    { 896, -24, -224},
    { 984, -72, -192},
    { 776, -80, -256},
    { 776, 120, -376},
    { 1056, 112, -384},
    { 1040, 80, -312},
    { 816, 88, -312},
    { 752, 128, -248},
    { 960, 248, -320},
    { 1072, 352, -328},
    { 1104, 496, -336},
    { 1064, 560, -360},
    { 1072, 592, -384},
    { 984, 496, -304},
    { 1232, 672, -336},
    { 992, 408, -184},
    { 1144, 528, -256},
    { 1112, 320, -248},
    { 968, 248, -248},
    { 768, 152, -248},
    // 27 seconds
    { 800, 120, -248},
    { 952, 152, -184},
    { 1144, 144, -168},
    { 1160, 128, -160},
    { 1312, 136, -256},
    { 1032, 56, -248},
    { 1072, 184, -328},
    { 904, 144, -352},
    { 408, 32, -336},
    { 840, 128, -496},
    { 904, 56, -376},
    { 680, 24, -352},
    { 608, 112, -352},
    { 728, 168, -328},
    { 968, 368, -464},
    { 1128, 464, -440},
    { 1064, 528, -432},
    { 968, 640, -440},
    { 976, 600, -360},
    { 1344, 728, -392},
    { 896, 520, -256},
    { 1072, 536, -304},
    { 1088, 448, -304},
    { 968, 304, -272},
    { 752, 264, -272},
    // 28 seconds
    { 704, 152, -240},
    { 832, 112, -216},
    { 976, 104, -160},
    { 1240, 48, -184},
    { 1288, 72, -216},
    { 1040, 88, -296},
    { 992, -8, -288},
    { 728, -24, -280},
    { 560, 64, -448},
    { 1064, 56, -416},
    { 960, 72, -240},
    { 832, 72, -304},
    { 712, 192, -256},
    { 792, 232, -320},
    { 984, 400, -352},
    { 1088, 456, -352},
    { 1064, 592, -456},
    { 1016, 688, -488},
    { 928, 560, -384},
    { 1344, 752, -400},
    { 1136, 504, -288},
    { 1168, 576, -320},
    { 1056, 368, -296},
    { 888, 280, -280},
    { 704, 200, -240},
    // 29 seconds
    { 752, 128, -232},
    { 936, 160, -176},
    { 1112, 128, -128},
    { 1176, 64, -112},
    { 1256, 72, -160},
    { 1048, 16, -168},
    { 872, -64, -280},
    { 1008, -80, -176},
    { 648, -32, -352},
    { 800, 32, -400},
    { 1016, 104, -320},
    { 840, 48, -304},
    { 784, 136, -288},
    { 880, 232, -328},
    { 1080, 368, -392},
    { 1104, 480, -400},
    { 1008, 496, -408},
    { 1024, 568, -464},
    { 976, 496, -392},
    { 1064, 576, -392},
    { 1064, 528, -368},
    { 1288, 472, -272},
    { 1176, 400, -280},
    { 1112, 248, -248},
    { 872, 200, -224},
    // 30 seconds
    { 768, 88, -208},
    { 832, 144, -216},
    { 1008, 112, -136},
    { 1160, 88, -136},
    { 1184, 112, -144},
    { 1224, 32, -128},
    { 880, -64, -168},
    { 1040, -16, -176},
    { 632, -48, -352},
    { 840, 128, -480},
    { 992, 96, -336},
    { 840, -16, -296},
    { 760, 136, -336},
    { 848, 288, -376},
    { 1072, 336, -408},
    { 1152, 344, -408},
    { 1104, 400, -464},
    { 1096, 520, -568},
    { 960, 456, -432},
    { 1184, 640, -496},
    { 1064, 480, -320},
    { 1192, 488, -280},
    { 1112, 368, -272},
    { 912, 216, -232},
    { 712, 112, -176},
    // 31 seconds
    { 800, 56, -168},
    { 1112, 200, -216},
    { 1296, 24, -104},
    { 1184, 88, -128},
    { 1280, 104, -208},
    { 984, 48, -232},
    { 1288, 128, -128},
    { 496, -152, -208},
    { 632, 216, -440},
    { 912, 88, -368},
    { 808, 80, -312},
    { 680, 184, -320},
    { 712, 216, -216},
    { 904, 320, -240},
    { 1176, 400, -224},
    { 1184, 448, -176},
    { 1176, 592, -184},
    { 1168, 584, -200},
    { 1240, 568, -160},
    { 872, 584, -248},
    { 1072, 536, -112},
    { 960, 480, -160},
    { 840, 400, -216},
    { 608, 288, -200},
    { 664, 216, -200},
    // 32 seconds
    { 840, 280, -96},
    { 1144, 240, -184},
    { 1192, -216, -32},
    { 1280, -152, -160},
    { 1096, -272, -112},
    { 1288, -208, -168},
    { 1192, -168, -48},
    { 960, -56, -360},
    { 1048, -80, -288},
    { 1000, -56, -248},
    { 824, 0, -312},
    { 656, 144, -272},
    { 792, 232, -264},
    { 1040, 392, -280},
    { 1008, 440, -296},
    { 968, 464, -360},
    { 944, 504, -336},
    { 920, 480, -256},
    { 1216, 584, -328},
    { 1096, 464, -200},
    { 1144, 416, -216},
    { 1144, 304, -176},
    { 856, 200, -192},
    { 736, 168, -216},
    { 880, 144, -200},
    // 33 seconds
    { 1096, 136, -112},
    { 1200, 88, -112},
    { 1216, 56, -192},
    { 1120, -40, -184},
    { 872, -8, -288},
    { 1152, -8, -216},
    { 648, -72, -256},
    { 840, 72, -456},
    { 1112, 104, -368},
    { 976, 72, -272},
    { 784, 112, -296},
    { 760, 168, -272},
    { 872, 272, -304},
    { 1080, 392, -320},
    { 1120, 504, -328},
    { 1096, 632, -392},
    { 1136, 624, -384},
    { 1160, 680, -360},
    { 1048, 512, -240},
    { 1128, 512, -240},
    { 1040, 400, -272},
    { 1000, 328, -224},
    { 864, 224, -184},
    { 832, 184, -200},
    { 896, 144, -168},
    // 34 seconds
    { 1112, 128, -120},
    { 1248, 80, -56},
    { 1320, 80, -120},
    { 1192, 72, -176},
    { 1000, 0, -216},
    { 1072, -24, -96},
    { 600, -56, -248},
    { 784, 112, -472},
    { 968, 112, -376},
    { 808, 24, -320},
    { 640, 128, -304},
    { 752, 152, -288},
    { 984, 288, -336},
    { 1232, 384, -344},
    { 1312, 552, -360},
    { 1136, 592, -392},
    { 1008, 624, -392},
    { 1192, 672, -344},
    { 1072, 496, -160},
    { 1160, 576, -240},
    { 1064, 392, -264},
    { 928, 312, -224},
    { 696, 224, -184},
    { 728, 152, -216},
    { 880, 160, -192},
    // 35 seconds
    { 1120, 176, -128},
    { 1232, 80, -128},
    { 1312, 104, -232},
    { 1160, 104, -232},
    { 1128, 96, -304},
    { 920, -16, -216},
    { 456, -104, -280},
    { 1120, 56, -448},
    { 928, 144, -264},
    { 672, 32, -264},
    { 544, 168, -280},
    { 752, 160, -288},
    { 1088, 376, -376},
    { 1160, 488, -392},
    { 1064, 568, -528},
    { 1064, 640, -536},
    { 968, 528, -392},
    { 1248, 640, -520},
    { 1024, 512, -304},
    { 1104, 544, -376},
    { 1088, 432, -352},
    { 896, 280, -264},
    { 608, 200, -232},
    { 608, 128, -208},
    { 792, 152, -208},
    // 36 seconds
    { 1040, 168, -152},
    { 1288, 120, -112},
    { 1344, 152, -120},
    { 1088, 120, -256},
    { 816, 48, -256},
    { 1000, -8, -136},
    { 728, -32, -368},
    { 1008, 144, -448},
    { 976, 72, -272},
    { 752, 48, -296},
    { 680, 144, -264},
    { 792, 216, -280},
    { 1040, 408, -328},
    { 1200, 456, -320},
    { 1120, 632, -304},
    { 1032, 464, -304},
    { 848, 592, -368},
    { 984, 600, -320},
    { 1264, 640, -240},
    { 1360, 472, -136},
    { 1048, 480, -256},
    { 880, 264, -224},
    { 720, 272, -192},
    { 752, 152, -112},
    { 992, 200, -176},
    // 37 seconds
    { 1184, 64, -64},
    { 1184, 56, -88},
    { 1248, 104, -112},
    { 1072, 96, -144},
    { 1128, 176, -208},
    { 904, 16, -152},
    { 656, 0, -352},
    { 872, 112, -544},
    { 880, 72, -320},
    { 672, -64, -264},
    { 608, 112, -344},
    { 704, 104, -264},
    { 1080, 216, -336},
    { 1280, 288, -392},
    { 1296, 504, -584},
    { 1024, 576, -464},
    { 1088, 392, -368},
    { 1288, 544, -392},
    { 1128, 488, -224},
    { 1104, 448, -288},
    { 1024, 384, -312},
    { 744, 176, -248},
    { 624, 248, -320},
    { 728, 8, -216},
    { 880, 160, -256},
    // 38 seconds
    { 1280, 40, -200},
    { 1392, 40, -144},
    { 1280, 72, -200},
    { 968, 40, -368},
    { 1192, 56, -208},
    { 800, -128, -352},
    { 944, 32, -512},
    { 936, -32, -312},
    { 648, -120, -200},
    { 488, 104, -328},
    { 680, 224, -344},
    { 1072, 568, -544},
    { 1048, 568, -472},
    { 808, 672, -584},
    { 728, 664, -640},
    { 984, 592, -544},
    { 1312, 632, -464},
    { 1040, 576, -440},
    { 1048, 584, -400},
    { 1144, 376, -296},
    { 1176, 248, -224},
    { 832, 136, -240},
    { 720, 64, -176},
    { 736, 136, -248},
    { 872, 88, -96},
    // 39 seconds
    { 1184, 256, -88},
    { 1296, 56, -80},
    { 1176, 104, -160},
    { 1128, 56, -192},
    { 840, 40, -240},
    { 472, 32, -424},
    { 1064, 48, -400},
    { 968, 48, -296},
    { 736, 48, -360},
    { 688, 128, -336},
    { 784, 208, -336},
    { 960, 384, -384},
    { 1176, 480, -320},
    { 1232, 576, -384},
    { 1088, 616, -384},
    { 960, 552, -304},
    { 1136, 608, -392},
    { 944, 536, -256},
    { 1048, 440, -192},
    { 1080, 352, -232},
    { 912, 240, -208},
    { 704, 192, -200},
    { 784, 160, -208},
    { 992, 200, -184},
    { 1264, 112, -136},
    // 40 seconds
    { 1376, 48, -128},
    { 1304, 88, -200},
    { 960, -24, -264},
    { 1080, -88, -168},
    { 776, -144, -344},
    { 936, 56, -496},
    { 968, 96, -384},
    { 744, 24, -264},
    { 664, 168, -280},
    { 728, 216, -232},
    { 1024, 352, -296},
    { 1184, 392, -280},
    { 1168, 560, -352},
    { 1032, 600, -320},
    { 1000, 536, -336},
    { 1184, 640, -392},
    { 952, 416, -200},
    { 1072, 552, -272},
    { 1096, 416, -248},
    { 1048, 336, -216},
    { 776, 208, -208},
    { 824, 128, -248},
    { 896, 200, -256},
    { 1144, 88, -184},
    { 1184, 64, -176},
    // 41 seconds
    { 1288, 120, -216},
    { 1056, 88, -248},
    { 944, -32, -264},
    { 896, 0, -200},
    { 720, 40, -344},
    { 1056, 96, -416},
    { 1000, 96, -264},
    { 936, 88, -304},
    { 824, 192, -248},
    { 912, 232, -240},
    { 1072, 360, -304},
    { 1152, 424, -288},
    { 1040, 584, -344},
    { 1048, 632, -368},
    { 936, 568, -280},
    { 1200, 688, -280},
    { 928, 392, -136},
    { 1160, 544, -232},
    { 1104, 384, -184},
    { 1032, 280, -192},
    { 816, 192, -176},
    { 864, 144, -208},
    { 1024, 144, -216},
    { 1224, 72, -128},
    { 1152, 64, -160},
    // 42 seconds
    { 1256, 88, -208},
    { 880, -104, -184},
    { 1080, -32, -208},
    { 760, -96, -216},
    { 848, 112, -352},
    { 984, 104, -368},
    { 1040, 152, -272},
    { 952, 88, -280},
    { 800, 216, -256},
    { 824, 264, -264},
    { 1024, 448, -344},
    { 1168, 560, -320},
    { 1064, 696, -352},
    { 960, 640, -368},
    { 792, 584, -264},
    { 1112, 680, -240},
    { 1360, 656, -120},
    { 1472, 536, -96},
    { 1264, 328, -128},
    { 688, 208, -184},
    { 608, 168, -192},
    { 840, 184, -184},
    { 1392, 136, -192},
    { 1200, 88, -88},
    { 1184, 112, -144},
    // 43 seconds
    { 1064, 56, -168},
    { 696, 0, -232},
    { 1096, 48, -232},
    { 784, 16, -328},
    { 952, 160, -392},
    { 1088, 104, -336},
    { 976, 120, -312},
    { 816, 208, -344},
    { 808, 280, -248},
    { 1032, 328, -272},
    { 1208, 432, -272},
    { 1224, 568, -256},
    { 1096, 664, -272},
    { 944, 688, -272},
    { 1024, 808, -192},
    { 1152, 480, -144},
    { 1024, 600, -168},
    { 1120, 384, -200},
    { 1120, 344, -208},
    { 944, 240, -152},
    { 856, 192, -160},
    { 960, 144, -144},
    { 1216, 192, -104},
    { 1376, 80, -160},
    { 1352, 88, -104},
    // 44 seconds
    { 1040, 32, -160},
    { 808, 24, -184},
    { 840, 48, -112},
    { 680, 120, -320},
    { 1112, 192, -400},
    { 992, 56, -296},
    { 736, 40, -368},
    { 584, 152, -408},
    { 744, 208, -296},
    { 952, 320, -352},
    { 1120, 456, -344},
    { 1168, 744, -480},
    { 1096, 584, -416},
    { 984, 552, -312},
    { 1368, 744, -456},
    { 1024, 624, -320},
    { 1088, 616, -304},
    { 1104, 448, -232},
    { 856, 232, -248},
    { 616, 232, -240},
    { 744, 160, -208},
    { 880, 192, -144},
    { 1088, 144, -168},
    { 1136, 56, -112},
    { 1272, 112, -160},
    // 45 seconds
    { 992, 120, -240},
    { 888, 72, -280},
    { 1104, 0, -152},
    { 712, 8, -408},
    { 848, 120, -464},
    { 1032, 80, -320},
    { 864, 8, -304},
    { 720, 128, -296},
    { 816, 192, -272},
    { 1016, 400, -360},
    { 1112, 496, -304},
    { 1096, 624, -368},
    { 1056, 688, -448},
    { 928, 584, -312},
    { 1040, 688, -344},
    { 856, 584, -288},
    { 1008, 608, -240},
    { 1120, 464, -216},
    { 1064, 288, -192},
    { 848, 272, -208},
    { 832, 136, -216},
    { 888, 192, -160},
    { 1064, 136, -168},
    { 1080, 168, -136},
    { 1168, 104, -192},
    // 46 seconds
    { 1064, 80, -224},
    { 1408, 248, -256},
    { 632, 16, -360},
    { 632, 184, -416},
    { 1032, 96, -408},
    { 904, 40, -296},
    { 672, 96, -400},
    { 528, 144, -320},
    { 728, 168, -368},
    { 896, 216, -360},
    { 912, 304, -336},
    { 992, 400, -280},
    { 1400, 504, -368},
    { 1328, 456, -240},
    { 1416, 552, -312},
    { 872, 464, -344},
    { 872, 552, -296},
    { 896, 568, -248},
    { 928, 376, -256},
    { 656, 288, -304},
    { 648, 208, -288},
    { 776, 176, -224},
    { 1104, 152, -272},
    { 1216, 64, -176},
    { 1288, 136, -248},
    // 47 seconds
    { 1248, 88, -208},
    { 888, 88, -312},
    { 1192, 80, -144},
    { 680, -88, -216},
    { 592, 120, -456},
    { 840, 128, -448},
    { 896, 64, -256},
    { 688, 96, -328},
    { 696, 136, -320},
    { 816, 152, -304},
    { 1008, 280, -376},
    { 1136, 352, -432},
    { 1088, 512, -528},
    { 1064, 488, -488},
    { 1112, 416, -384},
    { 1160, 568, -368},
    { 1240, 432, -208},
    { 1168, 456, -312},
    { 1032, 256, -288},
    { 728, 248, -272},
    { 696, 184, -288},
    { 856, 64, -192},
    { 1096, 152, -136},
    { 1264, 16, -144},
    { 1232, 88, -184},
    // 48 seconds
    { 1208, 128, -224},
    { 960, 96, -248},
    { 984, 104, -192},
    { 584, -48, -360},
    { 792, 128, -456},
    { 992, 64, -288},
    { 832, -16, -272},
    { 648, 112, -320},
    { 712, 96, -280},
    { 992, 240, -336},
    { 1208, 336, -352},
    { 1280, 448, -376},
    { 1120, 664, -472},
    { 1208, 440, -384},
    { 1240, 592, -432},
    { 944, 408, -304},
    { 1032, 520, -280},
    { 1040, 456, -312},
    { 1048, 352, -296},
    { 840, 240, -264},
    { 712, 200, -248},
    { 792, 112, -208},
    { 984, 160, -168},
    { 1288, 112, -192},
    { 1312, 32, -152},
    // 49 seconds
    { 1272, 120, -232},
    { 1000, 96, -256},
    { 1040, 8, -160},
    { 680, -48, -344},
    { 816, 112, -464},
    { 1016, 96, -368},
    { 856, 40, -280},
    { 616, 80, -304},
    { 632, 96, -240},
    { 856, 232, -296},
    { 1152, 320, -328},
    { 1120, 424, -384},
    { 1152, 528, -432},
    { 1240, 536, -376},
    { 1008, 520, -344},
    { 1152, 696, -360},
    { 1000, 552, -224},
    { 1056, 616, -264},
    { 1072, 440, -288},
    { 992, 360, -248},
    { 784, 296, -200},
    { 808, 184, -200},
    { 952, 208, -104},
    { 1176, 176, -152},
    { 1224, 64, -112},
    // 50 seconds
    { 1320, 144, -144},
    { 1080, 144, -160},
    { 1144, 40, -160},
    { 968, 8, -128},
    { 632, -112, -336},
    { 832, 8, -360},
    { 920, 56, -280},
    { 768, -24, -232},
    { 720, 168, -320},
    { 920, 176, -256},
    { 1200, 384, -352},
    { 1296, 512, -336},
    { 1176, 592, -368},
    { 1032, 640, -472},
    { 960, 576, -360},
    { 1296, 784, -448},
    { 1216, 560, -344},
    { 1080, 448, -312},
    { 928, 448, -400},
    { 944, 368, -304},
    { 968, 320, -216},
    { 1080, 376, -224},
    { 1272, 392, -136},
    { 1376, 576, -168},
    { 1248, 616, -104},
    // 51 seconds
    { 1096, 608, -40},
    { 912, 552, -56},
    { 648, 544, -56},
    { 520, 712, -128},
    { 512, 760, -304},
    { 32, 976, -240},
    { 72, 1104, -200},
    { 224, 1064, -112},
    { 0, 816, -152},
    { -120, 768, -104},
    { -224, 608, -80},
    { -328, 584, -40},
    { -408, 600, 32},
    { -456, 704, 80},
    { -488, 776, 56},
    { -536, 904, 56},
    { -528, 872, 96},
    { -520, 864, 104},
    { -568, 936, 184},
    { -608, 1000, 280},
    { -392, 984, 288},
    { -376, 832, 192},
    { -360, 720, 104},
    { -400, 672, 112},
    { -504, 840, 216},
    // 52 seconds
    { -528, 984, 440},
    { -312, 992, 480},
    { -256, 912, 296},
    { -296, 864, 248},
    { -408, 1064, 192},
    { -568, 1096, -48},
    { -632, 840, -280},
    { -440, 992, -568},
    { -240, 280, -528},
    { -96, -176, -704},
    { -72, -248, -848},
    { -16, -312, -872},
    { -48, -272, -928},
    { 24, -456, -952},
    { 0, -272, -1000},
    { -16, -432, -1008},
    { -8, -336, -1016},
    { 0, -400, -984},
    { -16, -400, -984},
    { -8, -368, -992},
    { 0, -456, -960},
    { -24, -352, -952},
    { -56, -392, -952},
    { -80, -320, -976},
    { -88, -384, -976},
    // 53 seconds
    { -104, -344, -976},
    { -112, -312, -984},
    { -112, -368, -992},
    { -96, -312, -992},
    { -112, -360, -1008},
    { -104, -320, -1000},
    { -112, -328, -1000},
    { -104, -360, -992},
    { -88, -408, -928},
    { 16, -552, -880},
    { 120, -232, -696},
    { 0, 328, -728},
    { -136, 472, -576},
    { -184, 760, -240},
    { -384, 1096, -120},
    { -424, 1248, -8},
    { -536, 976, -56},
    { -528, 952, -24},
    { -560, 1024, 24},
    { -560, 888, 64},
    { -568, 920, 104},
    { -536, 880, 120},
    { -520, 824, 128},
    { -544, 800, 144},
    { -480, 824, 64},
    // 54 seconds
    { -480, 784, 120},
    { -464, 832, 64},
    { -448, 816, 64},
    { -456, 856, 88},
    { -464, 704, -56},
    { -496, 752, 32},
    { -520, 888, 56},
    { -560, 840, 80},
    { -592, 744, 168},
    { -560, 752, 112},
    { -520, 776, 136},
    { -536, 744, 168},
    { -528, 816, 80},
    { -560, 800, 144},
    { -552, 808, 128},
    { -520, 800, 80},
    { -528, 776, 80},
    { -560, 816, 96},
    { -576, 768, 120},
    { -560, 776, 96},
    { -576, 760, 112},
    { -600, 784, 88},
    { -600, 784, 128},
    { -624, 784, 128},
    { -608, 736, 96},
    // 55 seconds
    { -584, 768, 48},
    { -592, 736, 56},
    { -608, 736, 64},
    { -616, 720, 80},
    { -608, 736, 80},
    { -600, 744, 72},
    { -616, 752, 64},
    { -592, 736, 56},
    { -608, 776, 72},
    { -616, 768, 96},
    { -616, 760, 72},
    { -616, 744, 80},
    { -616, 736, 80},
    { -600, 752, 80},
    { -616, 736, 88},
    { -616, 744, 88},
    { -624, 792, 72},
    { -616, 712, 64},
    { -608, 768, 80},
    { -616, 728, 96},
    { -608, 728, 80},
    { -616, 752, 64},
    { -640, 736, 64},
    { -648, 768, 96},
    { -624, 728, 80},
    // 56 seconds
    { -608, 744, 64},
    { -624, 752, 80},
    { -616, 744, 80},
    { -560, 696, 16},
    { -632, 736, 112},
    { -624, 752, 80},
    { -624, 712, 80},
    { -632, 744, 88},
    { -632, 776, 80},
    { -608, 752, 72},
    { -592, 736, 88},
    { -616, 736, 80},
    { -624, 760, 96},
    { -632, 744, 104},
    { -624, 736, 112},
    { -616, 768, -16},
    { -656, 712, -96},
    { -760, 752, -184},
    { -784, 848, -312},
    { -848, 952, -232},
    { -680, 728, -528},
    { -608, 584, -576},
    { -456, 656, -552},
    { -256, 88, -928},
    { -264, 168, -880},
    // 57 seconds
    { -232, -280, -888},
    { -104, -200, -880},
    { -104, -232, -1016},
    { -96, -536, -1016},
    { -88, -104, -1000},
    { -120, -344, -1000},
    { -144, -224, -968},
    { -144, -304, -968},
    { -136, -256, -944},
    { -88, -256, -992},
    { -120, -208, -1056},
    { -56, -160, -944},
    { -56, -272, -992},
    { -136, -248, -1016},
    { -104, -296, -1016},
    { -120, -232, -1016},
    { -112, -296, -1024},
    { -120, -200, -1032},
    { -152, -208, -1040},
    { -88, -240, -1040},
    { -208, -144, -1016},
    { -184, -200, -1024},
    { -104, -232, -1024},
    { -160, -248, -1048},
    { -112, -176, -1008},
    // 58 seconds
    { -144, -208, -1040},
    { -136, -256, -1024},
    { -208, -192, -1056},
    { -128, -176, -1064},
    { -152, -256, -1008},
    { -184, -160, -1016},
    { -192, -216, -1024},
    { -176, -192, -992},
    { -160, -184, -1008},
    { -176, -200, -1016},
    { -176, -184, -1008},
    { -152, -224, -1008},
    { -152, -192, -1032},
    { -176, -176, -1032},
    { -176, -168, -1008},
    { -192, -184, -1016},
    { -168, -192, -1016},
    { -184, -176, -1024},
    { -176, -200, -1008},
    { -176, -184, -1016},
    { -184, -184, -1016},
    { -176, -192, -1016},
    { -168, -200, -1016},
    { -128, -240, -1016},
    { -64, -360, -920},
    // 59 seconds
    { -56, -224, -672},
    { 112, 408, -808},
    { -328, 536, -824},
    { -288, 792, -352},
    { -440, 1288, 72},
    { -520, 1192, -280},
    { -424, 760, -128},
    { -520, 992, -128},
    { -456, 872, -72},
    { -472, 896, -32},
    { -464, 856, -72},
    { -488, 896, -96},
    { -536, 864, -48},
    { -496, 640, -56},
    { -536, 816, -80},
    { -568, 808, -40},
    { -560, 808, 8},
    { -544, 768, 0},
    { -584, 792, -24},
    { -584, 760, 16},
    { -576, 744, 8},
    { -584, 768, 8},
    { -584, 776, 16},
    { -584, 768, -16},
    { -576, 736, -24},
    // 60 seconds
    // elapsed: 1 minutes
    { -584, 776, 0},
    { -592, 768, -8},
    { -600, 768, -8},
    { -608, 752, 0},
    { -608, 768, 8},
    { -600, 760, 0},
    { -592, 744, 8},
    { -616, 744, 0},
    { -608, 760, 16},
    { -624, 720, 24},
    { -640, 800, 8},
    { -600, 696, -8},
    { -616, 776, 8},
    { -624, 768, 16},
    { -600, 736, 0},
    { -616, 768, 0},
    { -624, 752, 16},
    { -600, 736, -8},
    { -624, 736, 32},
    { -632, 744, 32},
    { -616, 728, 16},
    { -624, 736, 16},
    { -648, 744, 16},
    { -624, 720, -8},
    { -624, 760, 24},
    // 61 seconds
    { -640, 768, 24},
    { -616, 744, 0},
    { -568, 664, -96},
    { -648, 728, 40},
    { -640, 752, 48},
    { -632, 696, 24},
    { -640, 792, 32},
    { -608, 752, 0},
    { -640, 728, 40},
    { -640, 752, 8},
    { -632, 736, 0},
    { -608, 744, 0},
    { -624, 752, 24},
    { -600, 680, -40},
    { -640, 736, 64},
    { -632, 752, 24},
    { -640, 760, 16},
    { -640, 752, 8},
    { -624, 728, 32},
    { -640, 720, 32},
    { -624, 704, 16},
    { -640, 768, -16},
    { -632, 736, 16},
    { -664, 712, 40},
    { -640, 728, 0},
    // 62 seconds
    { -640, 752, 24},
    { -624, 736, 8},
    { -592, 664, -72},
    { -656, 736, 64},
    { -624, 728, 48},
    { -624, 736, 32},
    { -656, 760, 8},
    { -640, 696, 0},
    { -608, 720, -8},
    { -632, 776, 48},
    { -616, 728, 32},
    { -624, 720, 40},
    { -608, 768, 40},
    { -600, 776, 48},
    { -608, 768, 56},
    { -592, 768, 40},
    { -592, 760, 40},
    { -576, 744, 24},
    { -584, 712, 8},
    { -584, 728, 32},
    { -560, 760, 24},
    { -552, 752, 0},
    { -536, 784, 24},
    { -520, 824, 24},
    { -520, 848, 56},
    // 63 seconds
    { -528, 848, 32},
    { -520, 840, 48},
    { -536, 816, 48},
    { -504, 824, -16},
    { -480, 824, 80},
    { -504, 856, -8},
    { -512, 952, -112},
    { -560, 960, -200},
    { -616, 944, -448},
    { -640, 528, -440},
    { -392, 816, -520},
    { -224, 192, -760},
    { -200, 216, -920},
    { -144, 88, -976},
    { -120, 40, -1008},
    { -112, -112, -968},
    { -96, -64, -1016},
    { -64, -120, -1008},
    { -96, -168, -1024},
    { -104, -120, -1024},
    { -112, -176, -992},
    { -136, -88, -1024},
    { -120, -192, -1016},
    { -128, -144, -1024},
    { -136, -176, -1032},
    // 64 seconds
    { -136, -80, -1040},
    { -128, -176, -1048},
    { -120, -80, -1040},
    { -104, -200, -984},
    { -48, -144, -1024},
    { -64, -128, -1032},
    { 0, -216, -992},
    { 24, -152, -1024},
    { 40, -184, -1008},
    { 56, -200, -952},
    { 88, -320, -832},
    { 40, -320, -696},
    { 168, -272, -592},
    { 288, -272, -544},
    { 424, -160, -520},
    { 576, -40, -688},
    { 720, 112, -712},
    { 840, 120, -672},
    { 984, 264, -680},
    { 1040, 232, -672},
    { 1184, 336, -608},
    { 1216, 240, -760},
    { 1136, 280, -656},
    { 1048, 248, -560},
    { 1032, 352, -576},
    // 65 seconds
    { 944, 232, -528},
    { 880, 280, -568},
    { 840, 320, -560},
    { 920, 216, -600},
    { 1040, 400, -640},
    { 1032, 248, -640},
    { 944, 264, -592},
    { 952, 272, -560},
    { 952, 232, -504},
    { 832, 160, -328},
    { 1096, 216, -360},
    { 1408, 208, -312},
    { 1376, 176, -296},
    { 1136, 112, -296},
    { 1032, 96, -296},
    { 880, 48, -272},
    { 768, 0, -320},
    { 816, 40, -272},
    { 848, -24, -320},
    { 824, -16, -352},
    { 760, -64, -440},
    { 888, 16, -384},
    { 744, 40, -416},
    { 864, 48, -456},
    { 1224, 112, -432},
    // 66 seconds
    { 1224, 152, -360},
    { 1048, 304, -408},
    { 912, 304, -360},
    { 952, 272, -296},
    { 944, 384, -424},
    { 872, 376, -400},
    { 856, 528, -544},
    { 944, 552, -488},
    { 864, 472, -424},
    { 944, 552, -432},
    { 1384, 504, -456},
    { 1416, 336, -304},
    { 1400, 296, -344},
    { 1336, 224, -288},
    { 1056, 112, -232},
    { 888, 72, -264},
    { 1008, 48, -208},
    { 1072, 64, -224},
    { 1088, 40, -240},
    { 1120, 40, -216},
    { 952, 24, -264},
    { 816, -8, -344},
    { 808, 56, -256},
    { 600, 32, -400},
    { 776, 104, -496},
    // 67 seconds
    { 1064, 128, -432},
    { 1024, 64, -328},
    { 968, 224, -432},
    { 976, 72, -264},
    { 1160, 336, -424},
    { 1224, 336, -440},
    { 1184, 448, -528},
    { 1128, 560, -640},
    { 968, 408, -488},
    { 1144, 632, -544},
    { 848, 440, -416},
    { 1112, 488, -392},
    { 1208, 344, -320},
    { 1048, 232, -272},
    { 912, 120, -280},
    { 992, 120, -280},
    { 1160, 72, -328},
    { 1296, 0, -240},
    { 1224, 0, -296},
    { 1256, 16, -336},
    { 912, -104, -280},
    { 1016, -16, -256},
    { 752, -16, -384},
    { 568, 96, -440},
    { 816, 48, -368},
    // 68 seconds
    { 800, 96, -360},
    { 712, 88, -280},
    { 816, 216, -328},
    { 1088, 280, -328},
    { 1344, 416, -392},
    { 1304, 544, -496},
    { 1072, 576, -552},
    { 960, 656, -608},
    { 1120, 688, -544},
    { 976, 552, -416},
    { 1168, 520, -368},
    { 1232, 360, -336},
    { 1144, 264, -296},
    { 848, 160, -280},
    { 808, 128, -216},
    { 992, 88, -256},
    { 1184, 120, -232},
    { 1136, 56, -264},
    { 1160, 72, -296},
    { 872, 24, -304},
    { 752, -16, -312},
    { 776, 16, -328},
    { 648, 8, -448},
    { 912, 16, -432},
    { 1056, 56, -384},
    // 69 seconds
    { 880, 56, -344},
    { 832, 200, -312},
    { 1040, 280, -336},
    { 1352, 392, -376},
    { 1392, 488, -400},
    { 1272, 608, -464},
    { 1160, 664, -472},
    { 1248, 792, -488},
    { 952, 432, -360},
    { 944, 504, -328},
    { 1008, 408, -376},
    { 960, 280, -312},
    { 784, 216, -280},
    { 784, 144, -248},
    { 936, 96, -288},
    { 1288, 88, -288},
    { 1368, 16, -248},
    { 1304, 32, -296},
    { 1192, -16, -240},
    { 864, -184, -224},
    { 904, -72, -232},
    { 600, -80, -344},
    { 920, -16, -320},
    { 1080, 56, -344},
    { 880, 48, -320},
    // 70 seconds
    { 792, 128, -320},
    { 832, 192, -336},
    { 1048, 280, -368},
    { 1224, 408, -416},
    { 1288, 512, -520},
    { 1248, 536, -496},
    { 1032, 544, -512},
    { 1144, 640, -600},
    { 784, 424, -360},
    { 1024, 536, -408},
    { 1128, 304, -344},
    { 1112, 192, -272},
    { 960, 80, -296},
    { 976, 64, -280},
    { 1128, 64, -280},
    { 1264, 40, -256},
    { 1232, 16, -264},
    { 1144, -64, -208},
    { 824, -128, -232},
    { 1000, -8, -208},
    { 848, -40, -296},
    { 872, 112, -440},
    { 1000, 8, -336},
    { 952, 88, -288},
    { 816, 104, -296},
    // 71 seconds
    { 800, 200, -240},
    { 968, 328, -336},
    { 1248, 432, -360},
    { 1312, 656, -464},
    { 1192, 704, -440},
    { 936, 680, -456},
    { 888, 720, -480},
    { 936, 576, -280},
    { 1056, 576, -264},
    { 1248, 456, -304},
    { 1240, 296, -232},
    { 960, 112, -224},
    { 952, 32, -208},
    { 1232, 80, -264},
    { 1208, 96, -216},
    { 968, -72, -200},
    { 888, -112, -240},
    { 584, -120, -256},
    { 1008, 144, -344},
    { 920, 8, -400},
    { 1232, 200, -448},
    { 1344, 160, -512},
    { 992, 72, -192},
    { 808, 176, -232},
    { 792, 192, -264},
    // 72 seconds
    { 984, 328, -216},
    { 1192, 488, -320},
    { 1160, 552, -336},
    { 1024, 720, -320},
    { 832, 608, -376},
    { 992, 720, -456},
    { 1160, 456, -216},
    { 1360, 536, -312},
    { 1424, 240, -320},
    { 968, 136, -280},
    { 896, 112, -368},
    { 1024, 32, -232},
    { 1120, 104, -192},
    { 1128, 32, -240},
    { 1136, -8, -200},
    { 880, -24, -248},
    { 608, -32, -360},
    { 1064, 160, -248},
    { 816, 120, -352},
    { 1040, 144, -456},
    { 1192, 160, -416},
    { 1040, 64, -232},
    { 928, 208, -216},
    { 968, 272, -304},
    { 1144, 416, -352},
    // 73 seconds
    { 1160, 536, -336},
    { 1048, 696, -384},
    { 952, 624, -304},
    { 1232, 768, -392},
    { 1056, 456, -208},
    { 1160, 496, -320},
    { 1088, 368, -296},
    { 992, 200, -304},
    { 888, 112, -288},
    { 976, 64, -296},
    { 1080, 24, -304},
    { 1200, 80, -304},
    { 1168, -16, -248},
    { 1136, -24, -216},
    { 736, -96, -264},
    { 1032, 32, -208},
    { 840, 0, -304},
    { 928, 152, -400},
    { 1096, 160, -400},
    { 944, 128, -288},
    { 808, 112, -232},
    { 864, 248, -288},
    { 1064, 376, -376},
    { 1200, 552, -440},
    { 976, 680, -400},
    // 74 seconds
    { 904, 568, -456},
    { 840, 584, -368},
    { 1432, 672, -512},
    { 1240, 488, -248},
    { 1256, 496, -320},
    { 1224, 288, -312},
    { 1040, 192, -288},
    { 888, 88, -328},
    { 1008, 64, -256},
    { 1128, 88, -192},
    { 1128, 80, -240},
    { 1072, 16, -192},
    { 1008, 40, -176},
    { 696, -32, -272},
    { 992, 144, -192},
    { 776, 80, -360},
    { 888, 152, -432},
    { 1024, 120, -392},
    { 936, 104, -336},
    { 840, 136, -280},
    { 944, 232, -272},
    { 1136, 384, -392},
    { 1192, 456, -416},
    { 1160, 584, -504},
    { 1024, 608, -560},
    // 75 seconds
    { 864, 600, -544},
    { 1112, 696, -512},
    { 1072, 488, -320},
    { 1280, 496, -384},
    { 1352, 336, -280},
    { 1152, 144, -240},
    { 936, 120, -264},
    { 1032, 40, -192},
    { 1168, 104, -240},
    { 1112, 72, -240},
    { 1056, 16, -176},
    { 912, 56, -192},
    { 736, 32, -272},
    { 1024, 192, -200},
    { 608, 80, -400},
    { 952, 104, -368},
    { 1040, 136, -288},
    { 912, 72, -352},
    { 808, 192, -320},
    { 936, 248, -360},
    { 1192, 456, -440},
    { 1280, 648, -408},
    { 1112, 840, -488},
    { 960, 632, -400},
    { 912, 656, -336},
    // 76 seconds
    { 1344, 696, -368},
    { 1080, 480, -200},
    { 1136, 560, -240},
    { 1248, 320, -208},
    { 976, 184, -176},
    { 800, 136, -200},
    { 904, 56, -184},
    { 1088, 136, -168},
    { 1168, 80, -192},
    { 1144, 96, -208},
    { 1128, 80, -200},
    { 880, 40, -256},
    { 1008, 128, -216},
    { 552, 0, -400},
    { 928, 176, -472},
    { 976, 112, -376},
    { 800, 80, -352},
    { 744, 176, -280},
    { 904, 272, -304},
    { 1184, 440, -368},
    { 1280, 544, -392},
    { 1072, 664, -368},
    { 960, 528, -312},
    { 872, 704, -384},
    { 1192, 600, -304},
    // 77 seconds
    { 1200, 472, -152},
    { 1192, 504, -288},
    { 1168, 376, -232},
    { 952, 216, -224},
    { 792, 136, -232},
    { 904, 72, -232},
    { 1176, 104, -176},
    { 1232, 80, -176},
    { 1240, 96, -224},
    { 1168, 56, -128},
    { 824, -32, -232},
    { 1064, 96, -176},
    { 624, -16, -312},
    { 984, 112, -352},
    { 1112, 160, -312},
    { 944, 56, -280},
    { 792, 144, -304},
    { 784, 200, -296},
    { 992, 392, -352},
    { 1208, 448, -328},
    { 1208, 736, -464},
    { 992, 632, -424},
    { 848, 736, -400},
    { 1256, 672, -360},
    { 1040, 432, -144},
    // 78 seconds
    { 1240, 512, -312},
    { 1232, 336, -240},
    { 1056, 256, -208},
    { 928, 176, -224},
    { 912, 136, -224},
    { 1152, 144, -184},
    { 1248, 88, -128},
    { 1200, 56, -224},
    { 1160, 0, -144},
    { 752, -168, -168},
    { 1176, -32, -88},
    { 680, -40, -304},
    { 1088, 176, -368},
    { 1144, 112, -280},
    { 952, 80, -280},
    { 832, 168, -304},
    { 856, 200, -280},
    { 1000, 400, -336},
    { 1168, 432, -312},
    { 1248, 648, -424},
    { 1152, 632, -424},
    { 960, 632, -344},
    { 1176, 800, -416},
    { 984, 472, -160},
    { 1112, 600, -272},
    // 79 seconds
    { 1184, 376, -272},
    { 1120, 280, -240},
    { 944, 176, -224},
    { 936, 96, -216},
    { 1064, 144, -184},
    { 1240, 88, -144},
    { 1256, 112, -144},
    { 1256, 104, -168},
    { 856, -96, -152},
    { 1088, -48, -96},
    { 648, -128, -240},
    { 984, 120, -416},
    { 1216, 40, -264},
    { 1080, 112, -304},
    { 848, 168, -400},
    { 872, 224, -296},
    { 984, 400, -400},
    { 1072, 512, -384},
    { 1080, 592, -376},
    { 1080, 672, -408},
    { 1016, 592, -408},
    { 1128, 784, -328},
    { 1072, 488, -192},
    { 1024, 520, -296},
    { 1080, 368, -272},
    // 80 seconds
    { 1184, 288, -216},
    { 1008, 168, -168},
    { 864, 112, -216},
    { 936, 96, -232},
    { 1072, 96, -176},
    { 1144, 104, -224},
    { 1216, 48, -168},
    { 968, -104, -168},
    { 1072, -64, -200},
    { 768, -24, -240},
    { 760, 128, -424},
    { 976, 48, -376},
    { 1056, 120, -272},
    { 880, 64, -296},
    { 776, 168, -264},
    { 880, 264, -320},
    { 1016, 392, -360},
    { 1088, 424, -368},
    { 1104, 568, -456},
    { 1120, 552, -392},
    { 1192, 640, -392},
    { 1080, 600, -360},
    { 1112, 536, -256},
    { 1128, 424, -272},
    { 1064, 288, -256},
    // 81 seconds
    { 832, 184, -304},
    { 696, 216, -208},
    { 792, 136, -176},
    { 1064, 120, -152},
    { 1288, 88, -136},
    { 1256, 16, -160},
    { 1056, -104, -152},
    { 1224, -120, -176},
    { 976, -88, -192},
    { 880, 16, -416},
    { 976, -64, -288},
    { 912, 8, -232},
    { 736, 32, -264},
    { 744, 144, -232},
    { 856, 280, -312},
    { 1072, 392, -336},
    { 1216, 488, -400},
    { 1232, 648, -464},
    { 1064, 424, -328},
    { 1096, 680, -432},
    { 928, 552, -328},
    { 1080, 504, -200},
    { 1152, 464, -248},
    { 1072, 320, -192},
    { 800, 184, -184},
    // 82 seconds
    { 728, 200, -248},
    { 872, 144, -200},
    { 1192, 184, -144},
    { 1432, 48, -96},
    { 1448, 88, -200},
    { 1128, -8, -176},
    { 920, -152, -128},
    { 744, -152, -224},
    { 776, 8, -360},
    { 1064, 24, -400},
    { 984, 0, -216},
    { 752, 104, -280},
    { 744, 144, -256},
    { 936, 312, -296},
    { 1168, 432, -264},
    { 1152, 672, -360},
    { 992, 768, -328},
    { 1016, 760, -384},
    { 1288, 856, -360},
    { 1024, 536, -112},
    { 1080, 568, -248},
    { 1104, 440, -216},
    { 968, 304, -184},
    { 704, 216, -184},
    { 680, 128, -216},
    // 83 seconds
    { 976, 152, -208},
    { 1400, 192, -168},
    { 1232, 48, -168},
    { 1080, 112, -232},
    { 624, 8, -232},
    { 984, 112, -184},
    { 728, 64, -312},
    { 904, 224, -448},
    { 1048, 152, -392},
    { 792, 120, -336},
    { 576, 160, -288},
    { 784, 240, -296},
    { 1152, 448, -376},
    { 1264, 632, -328},
    { 1000, 744, -320},
    { 928, 672, -464},
    { 864, 808, -400},
    { 1168, 744, -192},
    { 984, 512, -96},
    { 1256, 496, -264},
    { 1264, 376, -200},
    { 1008, 232, -152},
    { 744, 128, -136},
    { 720, 136, -200},
    { 984, 144, -192},
    // 84 seconds
    { 1224, 128, -200},
    { 1208, 40, -192},
    { 960, -104, -144},
    { 768, -120, -240},
    { 1032, 64, -56},
    { 912, 144, -360},
    { 1080, 184, -376},
    { 1136, 224, -312},
    { 960, 120, -272},
    { 824, 272, -256},
    { 880, 296, -320},
    { 984, 424, -392},
    { 1120, 504, -352},
    { 1064, 704, -456},
    { 992, 696, -440},
    { 1160, 696, -408},
    { 1136, 520, -360},
    { 1176, 496, -248},
    { 1248, 432, -264},
    { 1272, 344, -216},
    { 920, 152, -208},
    { 744, 80, -168},
    { 856, 152, -208},
    { 1040, 112, -160},
    { 1216, 136, -144},
    // 85 seconds
    { 1216, 120, -176},
    { 1064, 88, -168},
    { 920, 8, -232},
    { 872, 56, -184},
    { 688, 96, -344},
    { 904, 136, -424},
    { 1008, 152, -296},
    { 856, 72, -320},
    { 728, 152, -272},
    { 824, 248, -296},
    { 1088, 392, -352},
    { 1192, 480, -352},
    { 1136, 624, -448},
    { 1040, 616, -416},
    { 904, 576, -328},
    { 1192, 752, -376},
    { 1104, 424, -208},
    { 1240, 520, -256},
    { 1224, 408, -224},
    { 992, 264, -208},
    { 760, 176, -280},
    { 720, 120, -200},
    { 912, 144, -168},
    { 1176, 144, -144},
    { 1216, 96, -136},
    // 86 seconds
    { 1280, 136, -208},
    { 968, 32, -184},
    { 1168, 56, -152},
    { 672, -40, -304},
    { 816, 152, -472},
    { 1008, 64, -360},
    { 920, 56, -288},
    { 688, 104, -392},
    { 632, 152, -320},
    { 800, 328, -440},
    { 1032, 448, -424},
    { 1208, 504, -416},
    { 1128, 632, -464},
    { 1032, 560, -352},
    { 984, 608, -328},
    { 992, 704, -352},
    { 1192, 544, -280},
    { 1168, 504, -240},
    { 1104, 400, -272},
    { 736, 248, -264},
    { 624, 264, -248},
    { 944, 152, -264},
    { 1416, 144, -168},
    { 1224, 32, -184},
    { 1176, 80, -296},
    // 87 seconds
    { 1016, 104, -280},
    { 944, 88, -328},
    { 840, 136, -312},
    { 536, 136, -528},
    { 888, 168, -528},
    { 856, 144, -312},
    { 600, 32, -296},
    { 600, 176, -256},
    { 720, 232, -240},
    { 984, 440, -328},
    { 1176, 520, -288},
    { 1152, 744, -408},
    { 872, 448, -176},
    { 1024, 696, -360},
    { 1432, 760, -376},
    { 1616, 664, -152},
    { 1184, 576, -216},
    { 848, 368, -352},
    { 624, 192, -280},
    { 544, 320, -264},
    { 808, 120, -136},
    { 1152, 152, -136},
    { 1416, 80, -152},
    { 1480, 112, -112},
    { 1200, 144, -256},
    // 88 seconds
    { 928, 16, -128},
    { 592, 16, -248},
    { 616, 64, -432},
    { 1080, 120, -408},
    { 984, 104, -280},
    { 744, 96, -392},
    { 632, 128, -240},
    { 736, 176, -280},
    { 992, 360, -368},
    { 1264, 472, -352},
    { 1208, 744, -384},
    { 1056, 488, -336},
    { 904, 888, -352},
    { 1144, 552, -288},
    { 1344, 568, -120},
    { 1248, 504, -200},
    { 1072, 376, -224},
    { 808, 248, -168},
    { 712, 296, -208},
    { 768, 184, -168},
    { 1088, 152, -208},
    { 1384, 88, -144},
    { 1432, 48, -176},
    { 1144, 72, -192},
    { 904, -48, -232},
    // 89 seconds
    { 808, 0, -168},
    { 712, 40, -360},
    { 944, 128, -448},
    { 880, 160, -272},
    { 648, 48, -296},
    { 624, 160, -208},
    { 776, 280, -256},
    { 1056, 432, -264},
    { 1280, 632, -384},
    { 1176, 776, -400},
    { 1024, 504, -408},
    { 784, 800, -464},
    { 1280, 696, -192},
    { 1344, 616, -72},
    { 1240, 592, -232},
    { 1096, 416, -232},
    { 744, 264, -200},
    { 600, 280, -200},
    { 736, 184, -208},
    { 1040, 192, -136},
    { 1256, 128, -144},
    { 1296, 104, -192},
    { 1112, 144, -192},
    { 752, 128, -328},
    { 832, 16, -208},
    // 90 seconds
    { 800, 32, -312},
    { 728, 232, -528},
    { 984, 128, -424},
    { 944, 176, -304},
    { 768, 120, -304},
    { 752, 248, -272},
    { 952, 400, -352},
    { 1136, 544, -336},
    { 1096, 736, -360},
    { 904, 632, -392},
    { 880, 680, -360},
    { 1136, 712, -272},
    { 1360, 664, -224},
    { 1344, 544, -176},
    { 1216, 488, -200},
    { 1088, 360, -160},
    { 776, 272, -136},
    { 696, 200, -176},
    { 944, 160, -208},
    { 1352, 128, -128},
    { 1448, 32, -168},
    { 1232, 0, -224},
    { 856, -88, -264},
    { 784, -88, -184},
    { 776, -32, -192},
    // 91 seconds
    { 720, 112, -328},
    { 856, 200, -464},
    { 1000, 208, -384},
    { 920, 176, -408},
    { 848, 288, -448},
    { 912, 288, -456},
    { 848, 512, -560},
    { 792, 616, -616},
    { 752, 568, -576},
    { 856, 536, -536},
    { 824, 376, -424},
    { 1264, 560, -304},
    { 1424, 320, -280},
    { 1488, 440, -256},
    { 1496, 336, -128},
    { 1112, 184, -176},
    { 736, 96, -96},
    { 728, 152, -88},
    { 800, 128, -72},
    { 904, 120, -48},
    { 1112, 120, -136},
    { 1128, 24, -184},
    { 1040, 40, -344},
    { 816, -48, -576},
    { 1144, -184, -408},
    // 92 seconds
    { 680, -176, -648},
    { 1088, -16, -808},
    { 1192, -152, -440},
    { 792, -216, -400},
    { 584, 72, -432},
    { 608, 176, -336},
    { 720, 328, -360},
    { 712, 296, -352},
    { 904, 448, -472},
    { 872, 608, -472},
    { 784, 632, -504},
    { 880, 480, -480},
    { 2160, 648, -896},
    { 1712, 168, -440},
    { 1448, 456, -376},
    { 1592, 144, -280},
    { 1064, 104, -144},
    { 864, 200, -272},
    { 1312, 184, -160},
    { 1168, 24, -120},
    { 1600, -32, -144},
    { 1328, -256, 16},
    { 1192, -416, 0},
    { 1024, -368, 64},
    { 1304, 0, -480},
    // 93 seconds
    { 1240, -112, -304},
    { 1040, -80, -224},
    { 816, 56, -360},
    { 664, 48, -256},
    { 864, 200, -296},
    { 1064, 240, -304},
    { 1392, 384, -504},
    { 1640, 584, -664},
    { 1440, 696, -624},
    { 1096, 600, -536},
    { 832, 624, -568},
    { 864, 448, -256},
    { 896, 512, -216},
    { 1128, 328, -272},
    { 968, 216, -224},
    { 800, 160, -248},
    { 928, 136, -256},
    { 1400, 136, -208},
    { 1720, 136, -208},
    { 1664, 40, -128},
    { 1144, -352, 16},
    { 888, -384, -200},
    { 1008, -424, 96},
    { 1160, -56, -360},
    { 1104, -72, -312},
    // 94 seconds
    { 984, -72, -176},
    { 800, 40, -336},
    { 728, 168, -304},
    { 904, 232, -328},
    { 1256, 384, -440},
    { 1456, 504, -432},
    { 1192, 536, -512},
    { 840, 624, -528},
    { 768, 472, -360},
    { 1016, 632, -376},
    { 1176, 552, -320},
    { 1464, 472, -368},
    { 1336, 360, -320},
    { 1072, 272, -232},
    { 888, 32, -208},
    { 872, 144, -144},
    { 1248, 72, -216},
    { 1480, 152, -192},
    { 1456, 120, -176},
    { 1008, -120, -56},
    { 776, -264, -176},
    { 976, -112, -40},
    { 920, 0, -416},
    { 1008, 40, -416},
    { 1016, -64, -208},
    // 95 seconds
    { 888, 24, -328},
    { 776, 160, -360},
    { 872, 192, -272},
    { 1088, 392, -400},
    { 1352, 528, -440},
    { 1360, 736, -472},
    { 1008, 600, -432},
    { 736, 688, -464},
    { 1216, 800, -480},
    { 1120, 488, -152},
    { 1096, 592, -320},
    { 1040, 336, -304},
    { 920, 216, -256},
    { 816, 160, -216},
    { 952, 144, -232},
    { 1224, 104, -184},
    { 1352, 112, -160},
    { 1440, 80, -256},
    { 1096, -128, -176},
    { 728, -224, -272},
    { 1088, -72, -136},
    { 680, -88, -336},
    { 1056, 168, -440},
    { 1168, 128, -296},
    { 896, 32, -328},
    // 96 seconds
    { 704, 120, -360},
    { 784, 176, -288},
    { 968, 328, -368},
    { 1160, 416, -392},
    { 1208, 640, -488},
    { 1032, 560, -384},
    { 864, 728, -384},
    { 1216, 800, -456},
    { 1160, 528, -152},
    { 1312, 584, -352},
    { 1208, 376, -320},
    { 944, 280, -240},
    { 744, 24, 32},
    { 816, 200, -152},
    { 1008, 144, -184},
    { 1312, 80, -96},
    { 1336, 80, -168},
    { 1248, 48, -120},
    { 744, -168, -144},
    { 1240, -112, -88},
    { 864, -120, -312},
    { 1120, 152, -488},
    { 1176, 48, -312},
    { 952, 80, -320},
    { 736, 96, -360},
    // 97 seconds
    { 784, 224, -288},
    { 944, 336, -384},
    { 1120, 408, -360},
    { 1176, 592, -448},
    { 1024, 568, -448},
    { 808, 664, -480},
    { 1088, 792, -440},
    { 1328, 552, -216},
    { 1400, 616, -384},
    { 1264, 424, -360},
    { 1056, 288, -280},
    { 896, 184, -208},
    { 936, 152, -232},
    { 1072, 96, -160},
    { 1144, 104, -136},
    { 1176, 144, -208},
    { 1240, 104, -168},
    { 880, -8, -192},
    { 1160, -88, -144},
    { 744, -88, -264},
    { 784, 168, -448},
    { 1080, 112, -424},
    { 1016, 136, -304},
    { 816, 96, -384},
    { 776, 168, -320},
    // 98 seconds
    { 896, 280, -336},
    { 1056, 408, -424},
    { 1224, 560, -424},
    { 1216, 688, -544},
    { 928, 576, -424},
    { 1192, 1016, -520},
    { 1288, 480, -128},
    { 1280, 720, -280},
    { 1120, 416, -256},
    { 976, 328, -224},
    { 832, 248, -216},
    { 888, 32, -312},
    { 1072, 120, -192},
    { 1192, 72, -128},
    { 1176, 144, -240},
    { 1216, 96, -184},
    { 832, -128, -128},
    { 1216, -56, -176},
    { 880, -104, -248},
    { 912, 200, -552},
    { 1136, 48, -328},
    { 976, 112, -264},
    { 744, 136, -376},
    { 736, 240, -288},
    { 856, 312, -352},
    // 99 seconds
    { 1048, 400, -416},
    { 1208, 640, -456},
    { 1016, 568, -392},
    { 952, 656, -440},
    { 1056, 704, -400},
    { 1176, 616, -264},
    { 1312, 584, -288},
    { 1288, 352, -320},
    { 1184, 288, -264},
    { 952, 168, -216},
    { 816, 112, -224},
    { 968, 136, -176},
    { 1152, 136, -192},
    { 1256, 104, -192},
    { 1328, 120, -208},
    { 848, -104, -216},
    { 1096, -88, -208},
    { 936, -96, -296},
    { 1104, 128, -464},
    { 1240, 104, -360},
    { 984, 104, -296},
    { 728, 192, -336},
    { 744, 240, -240},
    { 864, 512, -360},
    { 1080, 600, -352},
    // 100 seconds
    { 1128, 728, -392},
    { 1048, 696, -408},
    { 1008, 568, -304},
    { 1080, 712, -360},
    { 984, 608, -272},
    { 1208, 696, -264},
    { 1368, 504, -264},
    { 1312, 320, -224},
    { 992, 160, -200},
    { 960, 72, -168},
    { 1176, 184, -208},
    { 1280, 136, -136},
    { 1248, 128, -152},
    { 1216, 80, -152},
    { 864, -48, -144},
    { 1088, -56, -168},
    { 920, -72, -152},
    { 1056, 120, -384},
    { 1080, 64, -368},
    { 992, 80, -312},
    { 816, 96, -288},
    { 840, 200, -240},
    { 1032, 296, -264},
    { 1184, 384, -296},
    { 1240, 496, -336},
    // 101 seconds
    { 1192, 544, -352},
    { 1112, 744, -432},
    { 1024, 600, -328},
    { 1024, 752, -320},
    { 912, 496, -240},
    { 1040, 512, -240},
    { 1184, 416, -240},
    { 1096, 296, -216},
    { 1008, 192, -208},
    { 1016, 112, -200},
    { 1136, 192, -200},
    { 1312, 144, -136},
    { 1552, 152, -168},
    { 1368, 88, -128},
    { 896, -184, -184},
    { 904, -168, -56},
    { 816, -168, -240},
    { 984, 152, -416},
    { 1072, 120, -336},
    { 960, 128, -264},
    { 792, 192, -344},
    { 800, 208, -248},
    { 984, 328, -344},
    { 1208, 384, -400},
    { 1376, 696, -472},
    // 102 seconds
    { 1144, 528, -408},
    { 912, 848, -568},
    { 904, 808, -384},
    { 1104, 632, -168},
    { 1200, 608, -256},
    { 1320, 416, -280},
    { 1392, 320, -208},
    { 1016, 208, -184},
    { 824, 120, -256},
    { 976, 88, -224},
    { 1240, 216, -208},
    { 1272, 136, -240},
    { 1264, 176, -280},
    { 904, 24, -200},
    { 664, 16, -360},
    { 888, 96, -184},
    { 728, 144, -456},
    { 1016, 192, -480},
    { 1024, 208, -368},
    { 936, 160, -328},
    { 856, 240, -256},
    { 952, 304, -264},
    { 1152, 472, -384},
    { 1256, 768, -368},
    { 1016, 776, -288},
    // 103 seconds
    { 976, 512, -360},
    { 936, 616, -192},
    { 1328, 840, -96},
    { 1064, 448, -80},
    { 1136, 568, -200},
    { 1184, 456, -152},
    { 1080, 336, -168},
    { 800, 208, -200},
    { 728, 168, -224},
    { 952, 152, -160},
    { 1328, 176, -112},
    { 1296, 88, -168},
    { 1296, 152, -216},
    { 920, -16, -224},
    { 1104, -40, -144},
    { 624, -16, -280},
    { 888, 256, -448},
    { 1072, 168, -304},
    { 904, 128, -248},
    { 808, 216, -320},
    { 776, 256, -200},
    { 840, 336, -320},
    { 1008, 424, -320},
    { 1200, 568, -304},
    { 1144, 648, -320},
    // 104 seconds
    { 1048, 616, -312},
    { 1032, 768, -352},
    { 1232, 680, -216},
    { 1280, 608, -192},
    { 1120, 504, -272},
    { 1000, 384, -224},
    { 760, 240, -208},
    { 648, 184, -232},
    { 824, 136, -208},
    { 1200, 200, -184},
    { 1376, 72, -152},
    { 1416, 160, -248},
    { 1184, 136, -256},
    { 888, -72, -224},
    { 768, -24, -168},
    { 624, 72, -424},
    { 1016, 56, -360},
    { 1016, 216, -344},
    { 736, 88, -360},
    { 664, 184, -296},
    { 744, 256, -344},
    { 944, 344, -344},
    { 1208, 504, -416},
    { 1160, 584, -384},
    { 1064, 656, -384},
    // 105 seconds
    { 928, 608, -408},
    { 1240, 848, -400},
    { 1096, 544, -160},
    { 1152, 592, -224},
    { 1224, 416, -280},
    { 1000, 344, -216},
    { 736, 168, -240},
    { 736, 160, -208},
    { 976, 152, -208},
    { 1344, 176, -160},
    { 1344, 64, -176},
    { 1304, 176, -200},
    { 936, 72, -216},
    { 1000, 80, -104},
    { 624, -104, -296},
    { 736, 232, -528},
    { 944, 64, -328},
    { 824, 136, -288},
    { 664, 136, -336},
    { 704, 224, -256},
    { 928, 368, -336},
    { 1216, 512, -352},
    { 1312, 600, -240},
    { 1024, 744, -352},
    { 976, 544, -328},
    // 106 seconds
    { 960, 760, -344},
    { 1224, 832, -312},
    { 1320, 592, -104},
    { 1096, 592, -184},
    { 1152, 320, -256},
    { 800, 264, -200},
    { 736, 176, -176},
    { 912, 136, -224},
    { 1400, 184, -88},
    { 1448, 128, -136},
    { 1248, 80, -168},
    { 896, 56, -208},
    { 640, 40, -168},
    { 776, -24, -168},
    { 704, 96, -352},
    { 1008, 112, -440},
    { 1040, 176, -344},
    { 792, -8, -368},
    { 664, 144, -328},
    { 832, 208, -336},
    { 1080, 392, -432},
    { 1224, 528, -464},
    { 1144, 560, -456},
    { 1056, 504, -416},
    { 1032, 608, -480},
    // 107 seconds
    { 1336, 688, -504},
    { 1008, 416, -176},
    { 1112, 592, -368},
    { 1144, 360, -304},
    { 912, 352, -200},
    { 712, 80, -256},
    { 760, 32, -192},
    { 1008, 136, -208},
    { 1272, 112, -144},
    { 1256, 104, -184},
    { 1336, 128, -208},
    { 952, 64, -176},
    { 936, -56, -152},
    { 664, -120, -296},
    { 872, 96, -400},
    { 1032, -8, -296},
    { 880, 104, -312},
    { 688, 72, -296},
    { 728, 144, -232},
    { 944, 288, -360},
    { 1264, 384, -352},
    { 1360, 592, -392},
    { 1176, 568, -400},
    { 1128, 696, -496},
    { 1088, 632, -464},
    // 108 seconds
    { 856, 592, -296},
    { 1176, 600, -288},
    { 1152, 424, -272},
    { 1016, 296, -248},
    { 808, 144, -192},
    { 800, 64, -176},
    { 1080, 136, -248},
    { 1416, 56, -72},
    { 1264, 120, -176},
    { 1216, 96, -280},
    { 872, -48, -144},
    { 736, -40, -280},
    { 920, 48, -184},
    { 808, 80, -432},
    { 1024, 32, -344},
    { 1080, 192, -336},
    { 864, 136, -336},
    { 784, 152, -264},
    { 864, 272, -264},
    { 1056, 400, -328},
    { 1200, 552, -344},
    { 1144, 624, -360},
    { 1088, 544, -392},
    { 912, 568, -392},
    { 1040, 656, -400},
    // 109 seconds
    { 960, 520, -256},
    { 1168, 496, -280},
    { 1240, 368, -320},
    { 1040, 312, -216},
    { 896, 0, -248},
    { 936, 80, -208},
    { 1120, 184, -144},
    { 1328, 160, -112},
    { 1192, 120, -104},
    { 1208, 144, -208},
    { 944, -80, -104},
    { 1232, -48, 40},
    { 816, -96, -296},
    { 944, 32, -408},
    { 1016, 8, -176},
    { 856, 48, -320},
    { 680, 120, -320},
    { 744, 128, -264},
    { 952, 240, -384},
    { 1144, 360, -456},
    { 1336, 456, -616},
    { 1192, 544, -632},
    { 1016, 376, -424},
    { 1240, 536, -568},
    { 1096, 520, -432},
    // 110 seconds
    { 1224, 360, -328},
    { 1160, 360, -424},
    { 928, 200, -288},
    { 720, 168, -264},
    { 784, 168, -264},
    { 1104, 168, -200},
    { 1424, 152, -64},
    { 1256, 72, -112},
    { 1304, 144, -168},
    { 928, -32, -24},
    { 1160, 8, -48},
    { 720, -72, -144},
    { 952, 56, -352},
    { 1064, -64, -256},
    { 936, 48, -200},
    { 696, 16, -328},
    { 672, 0, -160},
    { 928, 168, -336},
    { 1216, 248, -400},
    { 1416, 344, -440},
    { 1312, 432, -648},
    { 1024, 488, -488},
    { 1128, 616, -656},
    { 1024, 424, -576},
    { 1040, 464, -376},
    // 111 seconds
    { 1208, 376, -408},
    { 1136, 296, -296},
    { 800, 144, -240},
    { 712, 192, -240},
    { 904, 136, -216},
    { 1152, 216, -184},
    { 1480, 160, -96},
    { 1328, 88, -72},
    { 1216, 128, -168},
    { 1256, -8, -120},
    { 696, -112, -104},
    { 864, -56, -480},
    { 1176, -112, -192},
    { 992, -72, -192},
    { 664, 16, -424},
    { 584, 24, -208},
    { 776, 152, -264},
    { 1088, 280, -368},
    { 1320, 376, -352},
    { 1416, 584, -480},
    { 1360, 624, -480},
    { 1312, 664, -448},
    { 1168, 784, -392},
    { 752, 472, -264},
    { 808, 648, -448},
    // 112 seconds
    { 1000, 528, -416},
    { 944, 416, -312},
    { 880, 344, -280},
    { 920, 120, -216},
    { 1032, 224, -224},
    { 1432, 144, -240},
    { 1600, 88, -136},
    { 1368, 128, -168},
    { 944, -32, -184},
    { 1120, -168, 48},
    { 584, -184, -200},
    { 896, 0, -464},
    { 1136, -144, -128},
    { 1032, -40, -168},
    { 784, 96, -360},
    { 768, 72, -248},
    { 952, 232, -240},
    { 1144, 320, -296},
    { 1328, 392, -328},
    { 1296, 584, -472},
    { 856, 608, -408},
    { 920, 744, -360},
    { 1352, 816, -424},
    { 1248, 536, -176},
    { 1144, 608, -360},
    // 113 seconds
    { 1080, 408, -312},
    { 1000, 368, -232},
    { 1104, 296, -184},
    { 1208, 288, -96},
    { 1504, 272, 104},
    { 1336, 584, -48},
    { 1216, 664, -24},
    { 1008, 504, -184},
    { 696, 464, -168},
    { 456, 600, -72},
    { 304, 744, -216},
    { -32, 912, -144},
    { 64, 1040, -80},
    { 184, 1048, -56},
    { 72, 952, 88},
    { -40, 832, -88},
    { -240, 752, -104},
    { -376, 840, 0},
    { -512, 1128, -24},
    { -640, 1024, -64},
    { -472, 1112, -432},
    { -160, 688, -352},
    { 40, 280, -688},
    { -48, 192, -896},
    { 88, -80, -888},
    // 114 seconds
    { 8, -80, -888},
    { 72, -216, -968},
    { 128, -248, -984},
    { 88, -256, -984},
    { 104, -264, -1040},
    { 8, -256, -1008},
    { -32, -272, -976},
    { -96, -264, -952},
    { -96, -376, -960},
    { -104, -280, -952},
    { -96, -288, -984},
    { -48, -368, -984},
    { -56, -168, -936},
    { -56, -64, -1040},
    { 72, -144, -784},
    { 64, 472, -688},
    { -224, 592, -552},
    { -320, 776, -320},
    { -544, 1048, -72},
    { -400, 1064, 24},
    { -536, 1136, 72},
    { -528, 864, 24},
    { -512, 912, 64},
    { -520, 816, 96},
    { -496, 944, 88},
    // 115 seconds
    { -488, 872, 112},
    { -496, 848, 192},
    { -480, 800, 128},
    { -480, 832, 112},
    { -512, 824, 120},
    { -504, 760, 104},
    { -520, 816, 104},
    { -496, 784, 48},
    { -536, 808, 120},
    { -528, 840, 104},
    { -496, 784, 56},
    { -512, 784, 128},
    { -528, 824, 64},
    { -568, 792, 120},
    { -552, 760, 112},
    { -568, 776, 144},
    { -544, 776, 136},
    { -512, 792, 112},
    { -488, 760, 120},
    { -472, 784, 128},
    { -456, 728, 88},
    { -408, 632, 184},
    { -552, 632, 184},
    { -536, 720, 176},
    { -504, 744, 144},
    // 116 seconds
    { -408, 800, 288},
    { -408, 896, 368},
    { -360, 912, 456},
    { -344, 864, 424},
    { -352, 888, 376},
    { -368, 872, 368},
    { -376, 840, 400},
    { -320, 800, 336},
    { -280, 784, 376},
    { -232, 672, 240},
    { -184, 800, 368},
    { -208, 824, 368},
    { -208, 800, 376},
    { -216, 768, 520},
    { -240, 912, 520},
    { -160, 680, 440},
    { -192, 856, 552},
    { -136, 760, 504},
    { -192, 784, 528},
    { -176, 816, 696},
    { -80, 816, 448},
    { -192, 880, 440},
    { -88, 816, 552},
    { -40, 832, 704},
    { 0, 784, 880},
    // 117 seconds
    { 96, 792, 800},
    { 80, 608, 568},
    { 0, 712, 552},
    { -8, 752, 544},
    { -48, 816, 384},
    { -48, 912, 456},
    { -72, 848, 416},
    { -88, 776, 296},
    { -96, 800, 200},
    { -112, 800, 224},
    { -32, 896, 280},
    { -24, 872, 248},
    { 40, 824, 200},
    { 80, 856, 160},
    { 16, 848, 208},
    { -80, 832, 232},
    { -160, 920, 328},
    { -168, 944, 344},
    { -120, 936, 320},
    { -88, 920, 280},
    { 0, 928, 256},
    { 0, 920, 240},
    { 72, 936, 232},
    { 120, 928, 240},
    { 112, 888, 264},
    // 118 seconds
    { -32, 768, 136},
    { -64, 736, 248},
    { -144, 1040, 376},
    { -112, 1000, 336},
    { -24, 856, 192},
    { 16, 856, 264},
    { -24, 872, 328},
    { -48, 888, 328},
    { -40, 888, 240},
    { -32, 912, 288},
    { -48, 848, 280},
    { -64, 840, 288},
    { -80, 872, 304},
    { -64, 872, 264},
    { -64, 896, 288},
    { -56, 888, 296},
    { -56, 888, 288},
    { -64, 880, 296},
    { -56, 864, 272},
    { -72, 864, 320},
    { -56, 840, 304},
    { -72, 896, 296},
    { -56, 920, 296},
    { -72, 896, 328},
    { -88, 880, 312},
    // 119 seconds
    { -72, 864, 304},
    { -64, 864, 296},
    { -88, 880, 312},
    { -96, 880, 304},
    { -88, 928, 304},
    { -80, 872, 304},
    { -64, 864, 288},
    { -64, 840, 296},
    { -88, 872, 312},
    { -64, 904, 280},
    { -96, 912, 296},
    { -64, 856, 288},
    { -88, 888, 312},
    { -104, 848, 280},
    { -72, 856, 272},
    { -88, 920, 272},
    { -96, 920, 304},
    { -88, 864, 304},
    { -96, 880, 288},
    { -72, 864, 272},
    { -56, 856, 216},
    { -112, 912, 320},
    { -80, 896, 280},
    { -64, 848, 272},
    { -96, 864, 296},
    // 120 seconds
    // elapsed: 2 minutes
    { -88, 928, 280},
    { -104, 912, 296},
    { -80, 840, 288},
    { -80, 848, 264},
    { -104, 928, 248},
    { -168, 1128, 200},
    { -192, 1176, 128},
    { -240, 1256, 176},
    { -304, 1168, 192},
    { -280, 944, 104},
    { -240, 688, -80},
    { -184, 576, -296},
    { -168, 424, -504},
    { -136, 168, -896},
    { -176, 272, -936},
    { -176, 304, -920},
    { -176, 120, -1032},
    { -176, 88, -1000},
    { -160, -48, -1000},
    { -184, 0, -992},
    { -192, -152, -1032},
    { -176, -136, -984},
    { -128, -232, -976},
    { -144, -232, -960},
    { -80, -160, -1040},
    // 121 seconds
    { -32, -128, -1040},
    { -24, -160, -1104},
    { -8, -120, -1072},
    { 232, -80, -1192},
    { 144, -200, -1104},
    { -240, -256, -848},
    { 64, -136, -1016},
    { -16, -104, -1064},
    { -80, -176, -1016},
    { -48, -112, -1048},
    { 8, -168, -1072},
    { -48, -136, -1048},
    { -32, -152, -1056},
    { 24, -144, -1016},
    { 488, -40, -736},
    { -168, -88, -992},
    { -32, -104, -1032},
    { -80, -112, -1016},
    { -96, -88, -1048},
    { -40, -112, -1032},
    { -80, -112, -1032},
    { -80, -120, -1056},
    { -80, -120, -1024},
    { -56, -112, -1024},
    { -72, -112, -1056},
    // 122 seconds
    { -56, -120, -1032},
    { -48, -104, -1032},
    { -8, -176, -1032},
    { -96, -104, -1040},
    { -48, -104, -1032},
    { -48, -112, -1032},
    { -64, -104, -1024},
    { -64, -112, -1032},
    { -64, -112, -1040},
    { -80, -112, -1032},
    { -72, -104, -1024},
    { -80, -104, -1048},
    { -72, -88, -1024},
    { -80, -96, -1032},
    { -80, -96, -1040},
    { -88, -104, -1040},
    { -72, -88, -1016},
    { -88, -96, -1040},
    { -80, -104, -1016},
    { -64, -96, -1032},
    { -32, -424, -1112},
    { 72, -704, -1000},
    { 216, -40, -896},
    { 24, 224, -640},
    { -56, 768, -320},
    // 123 seconds
    { -256, 1192, -136},
    { -232, 1056, -120},
    { -280, 1056, -112},
    { -184, 960, -96},
    { -256, 912, -120},
    { -248, 904, -80},
    { -240, 840, 24},
    { -208, 920, 40},
    { -248, 928, 48},
    { -216, 856, 8},
    { -184, 952, 64},
    { -192, 1000, 112},
    { -184, 984, 88},
    { -168, 936, 56},
    { -136, 880, 40},
    { -144, 928, 72},
    { -152, 968, 112},
    { -144, 912, 120},
    { -152, 888, 72},
    { -168, 920, 56},
    { -144, 912, 96},
    { -160, 912, 104},
    { -160, 944, 88},
    { -176, 920, 112},
    { -168, 888, 88},
    // 124 seconds
    { -160, 912, 128},
    { -168, 896, 112},
    { -160, 888, 96},
    { -152, 936, 64},
    { -200, 976, 152},
    { -192, 904, 112},
    { -184, 904, 96},
    { -152, 904, 96},
    { -152, 928, 80},
    { -176, 904, 120},
    { -176, 904, 112},
    { -152, 912, 80},
    { -168, 888, 80},
    { -176, 952, 88},
    { -200, 968, 112},
    { -168, 880, 112},
    { -152, 864, 112},
    { -176, 912, 88},
    { -184, 952, 120},
    { -192, 936, 136},
    { -176, 912, 88},
    { -152, 880, 88},
    { -184, 920, 104},
    { -176, 920, 120},
    { -192, 896, 88},
    // 125 seconds
    { -184, 912, 120},
    { -176, 912, 88},
    { -176, 952, 112},
    { -192, 936, 120},
    { -192, 920, 104},
    { -176, 888, 96},
    { -160, 872, 120},
    { -176, 880, 112},
    { -208, 920, 112},
    { -208, 976, 112},
    { -208, 928, 120},
    { -200, 888, 104},
    { -152, 896, 104},
    { -168, 896, 136},
    { -184, 912, 120},
    { -192, 904, 120},
    { -200, 896, 120},
    { -184, 888, 88},
    { -192, 952, 120},
    { -200, 936, 128},
    { -192, 920, 112},
    { -168, 888, 104},
    { -160, 880, 120},
    { -168, 896, 144},
    { -192, 936, 112},
    // 126 seconds
    { -168, 912, 96},
    { -216, 928, 152},
    { -248, 872, 192},
    { -152, 920, 80},
    { -192, 944, 144},
    { -200, 912, 136},
    { -192, 904, 120},
    { -152, 864, 144},
    { -176, 936, 144},
    { -184, 880, 136},
    { -216, 952, 136},
    { -192, 904, 128},
    { -152, 920, 120},
    { -168, 888, 120},
    { -200, 888, 184},
    { -216, 936, 112},
    { -224, 952, 136},
    { -192, 904, 104},
    { -224, 976, 80},
    { -376, 1256, -16},
    { -376, 1248, -64},
    { -312, 1184, 24},
    { -376, 1064, 32},
    { -264, 624, -8},
    { -208, 384, -304},
    // 127 seconds
    { -64, 168, -696},
    { -48, 8, -936},
    { -32, 64, -1072},
    { -96, 128, -992},
    { -128, -24, -1032},
    { -112, -16, -1032},
    { -144, -40, -1016},
    { -112, -48, -1008},
    { -128, 56, -1008},
    { -96, -128, -1064},
    { -72, -168, -1112},
    { -16, -312, -1120},
    { 8, -48, -864},
    { -24, 440, -528},
    { -64, 960, -232},
    { -104, 1176, -120},
    { -200, 1128, -48},
    { -136, 920, -72},
    { -88, 928, 0},
    { -224, 912, 40},
    { -224, 880, -32},
    { -184, 824, -32},
    { -168, 1016, 16},
    { -152, 1072, 8},
    { -112, 992, 0},
    // 128 seconds
    { -96, 968, 24},
    { -136, 944, 48},
    { -144, 968, 88},
    { -120, 904, 80},
    { -88, 984, 72},
    { -88, 920, 80},
    { -88, 936, 96},
    { -88, 920, 80},
    { -88, 912, 72},
    { -88, 928, 88},
    { -96, 888, 88},
    { -88, 912, 96},
    { -96, 920, 64},
    { -104, 952, 72},
    { -104, 960, 88},
    { -88, 920, 96},
    { -88, 888, 64},
    { -88, 880, 64},
    { -120, 944, 96},
    { -104, 976, 96},
    { -96, 928, 80},
    { -80, 912, 64},
    { -104, 928, 104},
    { -96, 904, 88},
    { -112, 912, 88},
    // 129 seconds
    { -104, 944, 80},
    { -96, 936, 40},
    { -64, 888, 80},
    { -112, 944, 112},
    { -120, 904, 72},
    { -120, 920, 80},
    { -80, 872, 112},
    { -96, 976, 104},
    { -80, 912, 56},
    { -120, 912, 80},
    { -112, 960, 104},
    { -112, 920, 104},
    { -96, 904, 72},
    { -64, 848, 32},
    { -80, 912, 80},
    { -112, 1008, 112},
    { -128, 904, 80},
    { -64, 872, 24},
    { -88, 952, 72},
    { -112, 888, 64},
    { -152, 928, 88},
    { -200, 1032, 128},
    { -176, 984, 104},
    { -160, 968, 64},
    { -128, 928, 24},
    // 130 seconds
    { -64, 848, 8},
    { -40, 808, -8},
    { 72, 848, -40},
    { 104, 752, -80},
    { 112, 744, -104},
    { 104, 776, 8},
    { 32, 856, 40},
    { 24, 1056, 216},
    { -56, 1352, 296},
    { -40, 1232, 168},
    { -104, 1560, 112},
    { -136, 1616, 200},
    { 32, 920, 200},
    { 128, 296, -280},
    { 248, -16, -656},
    { 216, -488, -904},
    { 168, -224, -1072},
    { 104, 16, -984},
    { 152, 0, -1000},
    { 152, -112, -1000},
    { 160, -248, -1016},
    { 160, -104, -968},
    { 152, -232, -976},
    { 168, -168, -1008},
    { 176, -128, -1000},
    // 131 seconds
    { 160, -120, -992},
    { 216, -296, -1008},
    { 232, -128, -840},
    { 320, -216, -928},
    { 392, -496, -792},
    { 552, -264, -400},
    { 696, 240, 8},
    { 720, 792, 352},
    { 520, 1480, 392},
    { 352, 1744, 264},
    { 224, 1680, 128},
    { 320, 1032, -80},
    { 200, 1720, -344},
    { 88, 1264, -296},
    { 88, 1008, -8},
    { 112, 112, -688},
    { 88, 232, -688},
    { 336, 112, -376},
    { 408, 296, -304},
    { 416, 544, -144},
    { 504, 616, -8},
    { 536, 568, -120},
    { 752, 512, -40},
    { 1008, 568, -232},
    { 1456, 808, -64},
    // 132 seconds
    { 1808, 528, -488},
    { 1376, 584, -24},
    { 784, 880, -296},
    { 704, 672, -120},
    { 736, 888, -128},
    { 944, 576, -40},
    { 1080, 552, -120},
    { 1312, 528, -152},
    { 1368, 344, -144},
    { 1360, 320, -16},
    { 1224, 328, -192},
    { 1184, 280, -112},
    { 1032, 224, -176},
    { 912, 208, -184},
    { 856, 184, -184},
    { 976, 152, -136},
    { 928, 224, -304},
    { 824, 288, -256},
    { 640, 216, -272},
    { 864, 232, -384},
    { 1176, 424, -392},
    { 1152, 336, -296},
    { 1104, 384, -240},
    { 1008, 344, -16},
    { 1008, 448, -104},
    // 133 seconds
    { 1144, 456, -96},
    { 1208, 528, -16},
    { 1128, 608, -32},
    { 936, 704, 40},
    { 808, 640, -8},
    { 1040, 776, -40},
    { 984, 664, -24},
    { 1056, 576, -72},
    { 1168, 560, -112},
    { 1296, 456, -128},
    { 1240, 344, -216},
    { 1200, 80, -112},
    { 1408, 64, 16},
    { 1304, 360, 0},
    { 1296, 152, -72},
    { 1256, 240, -176},
    { 944, 112, -176},
    { 648, 112, -296},
    { 752, 120, -112},
    { 552, 272, -480},
    { 952, 400, -392},
    { 1040, 304, -200},
    { 944, 240, -136},
    { 944, 344, -136},
    { 1056, 376, -88},
    // 134 seconds
    { 1104, 488, -104},
    { 1200, 552, -24},
    { 1192, 672, -40},
    { 1032, 648, 8},
    { 840, 592, -32},
    { 1088, 984, -16},
    { 1088, 592, 48},
    { 1072, 560, -32},
    { 1128, 536, -80},
    { 1008, 336, -112},
    { 736, 224, -128},
    { 800, 240, -80},
    { 1128, 480, -80},
    { 1528, 80, -88},
    { 1280, 240, -120},
    { 1296, 64, -152},
    { 960, -8, -280},
    { 1312, 144, 80},
    { 600, 56, -464},
    { 1192, 192, -336},
    { 1024, 304, -152},
    { 712, 224, -216},
    { 616, 288, -192},
    { 768, 384, -104},
    { 976, 504, -128},
    // 135 seconds
    { 1344, 536, -144},
    { 1096, 760, -56},
    { 960, 480, -256},
    { 880, 752, -104},
    { 1272, 1192, 0},
    { 1344, 288, 0},
    { 1104, 696, -128},
    { 1272, 488, -168},
    { 968, 224, -104},
    { 736, 336, -104},
    { 952, 200, -200},
    { 1136, 144, -80},
    { 1272, 184, -112},
    { 1336, -8, -192},
    { 1096, -104, -136},
    { 744, -56, -272},
    { 1352, -96, 32},
    { 888, 184, -344},
    { 1232, 88, -320},
    { 1144, 256, -272},
    { 712, 280, -304},
    { 584, 248, -296},
    { 744, 264, -152},
    { 896, 504, -232},
    { 1224, 512, -200},
    // 136 seconds
    { 1376, 880, -264},
    { 1000, 816, -168},
    { 936, 456, -312},
    { 1240, 1328, -32},
    { 1400, 456, 0},
    { 1160, 656, -144},
    { 1264, 432, -104},
    { 904, 408, -112},
    { 800, 232, 32},
    { 792, 112, -72},
    { 896, 288, -56},
    { 1832, 208, -424},
    { 1592, 192, -88},
    { 1312, 128, -208},
    { 792, -160, -200},
    { 1016, 16, -176},
    { 792, -272, -376},
    { 1344, 72, -416},
    { 1312, 248, -320},
    { 1104, 240, -272},
    { 888, 312, -264},
    { 912, 416, -224},
    { 1104, 488, -216},
    { 208, 232, -256},
    { 1704, 1144, 96},
    // 137 seconds
    { 680, 872, -384},
    { 776, 880, -160},
    { 1120, 992, -128},
    { 984, 664, -96},
    { 1032, 736, -176},
    { 1192, 584, -200},
    { 1192, 384, -160},
    { 984, 384, -208},
    { 1056, 336, -168},
    { 1184, 384, -184},
    { 1312, 336, -200},
    { 1416, 272, -248},
    { 1088, -96, -256},
    { 800, -72, -336},
    { 1192, -168, -104},
    { 864, 136, -448},
    { 1168, 176, -320},
    { 1160, 352, -352},
    { 872, 320, -296},
    { 736, 384, -272},
    { 864, 472, -224},
    { 1072, 600, -288},
    { 1368, 768, -248},
    { 1232, 920, -216},
    { 1032, 808, -240},
    // 138 seconds
    { 800, 1024, -112},
    { 1088, 1056, -48},
    { 1008, 592, -16},
    { 904, 640, -104},
    { 952, 576, -128},
    { 888, 456, -112},
    { 856, 304, -128},
    { 904, 328, -128},
    { 1072, 336, -160},
    { 1232, 288, -168},
    { 1200, 264, -184},
    { 1176, 344, -248},
    { 760, -32, -344},
    { 712, 152, -352},
    { 1224, -72, -112},
    { 864, 384, -488},
    { 1112, 480, -392},
    { 1008, 448, -312},
    { 896, 344, -224},
    { 912, 504, -232},
    { 1080, 608, -208},
    { 1144, 768, -224},
    { 1056, 840, -168},
    { 864, 904, -64},
    { 736, 984, -8},
    // 139 seconds
    { 1448, 1112, 0},
    { 1152, 512, 32},
    { 1176, 736, -96},
    { 1376, 592, -128},
    { 984, 408, -136},
    { 848, 272, -128},
    { 992, 152, -80},
    { 1104, 344, -96},
    { 1224, 328, -168},
    { 1168, 240, -208},
    { 1168, -24, -232},
    { 584, -88, -352},
    { 1144, -56, -200},
    { 1064, 192, -384},
    { 1128, 352, -552},
    { 1368, 464, -360},
    { 1032, 344, -264},
    { 808, 424, -248},
    { 824, 480, -120},
    { 976, 600, -168},
    { 1272, 704, 0},
    { 1128, 792, 24},
    { 864, 760, 0},
    { 720, 688, 88},
    { 1120, 1048, 160},
    // 140 seconds
    { 1152, 544, 48},
    { 1168, 704, -32},
    { 1312, 608, -24},
    { 1128, 440, -8},
    { 1040, 128, -8},
    { 1096, 200, 16},
    { 1216, 304, -120},
    { 1264, 304, -80},
    { 1408, 344, -120},
    { 1120, 64, -184},
    { 640, -16, -408},
    { 1040, 112, -168},
    { 840, 168, -328},
    { 952, 336, -440},
    { 1168, 472, -328},
    { 952, 320, -216},
    { 800, 392, -168},
    { 808, 424, -128},
    { 1048, 496, -88},
    { 1240, 776, -40},
    { 1152, 744, 72},
    { 872, 560, -96},
    { 808, 632, -40},
    { 1080, 896, 152},
    { 984, 736, 144},
    // 141 seconds
    { 1120, 600, -16},
    { 1224, 632, -88},
    { 1088, 480, -88},
    { 848, 416, -96},
    { 912, 344, -48},
    { 1072, 224, -176},
    { 1136, 168, -240},
    { 1320, -48, -176},
    { 1160, -112, -160},
    { 864, -40, -192},
    { 1296, 40, -248},
    { 920, 24, -88},
    { 1000, 296, -464},
    { 1144, 224, -248},
    { 984, 272, -176},
    { 760, 288, -192},
    { 688, 344, -224},
    { 768, 408, -112},
    { 920, 568, -192},
    { 1032, 784, -288},
    { 1024, 808, -216},
    { 960, 720, -384},
    { 1000, 968, -136},
    { 1096, 760, -48},
    { 1216, 712, -136},
    // 142 seconds
    { 1264, 664, -72},
    { 1280, 496, -96},
    { 904, 248, -136},
    { 728, 256, -120},
    { 776, 256, -96},
    { 1096, 320, -200},
    { 1352, 104, -136},
    { 1200, 72, -320},
    { 952, -16, -184},
    { 912, 168, -408},
    { 1184, -152, -16},
    { 856, 312, -416},
    { 1096, 112, -240},
    { 1048, 320, -272},
    { 808, 328, -248},
    { 696, 432, -200},
    { 920, 472, -128},
    { 1080, 592, -184},
    { 1120, 808, -40},
    { 976, 992, -176},
    { 944, 688, -144},
    { 848, 688, -128},
    { 1168, 992, -16},
    { 1048, 592, -96},
    { 1112, 592, -112},
    // 143 seconds
    { 1224, 592, -88},
    { 1008, 376, -128},
    { 1016, 192, -112},
    { 912, 232, -168},
    { 992, 336, -112},
    { 1168, 320, -112},
    { 1304, 216, -160},
    { 1176, 96, -160},
    { 832, -80, -352},
    { 1056, 64, -96},
    { 664, 168, -328},
    { 1008, 280, -384},
    { 1088, 256, -312},
    { 888, 400, -152},
    { 688, 360, -200},
    { 736, 472, -168},
    { 984, 584, -152},
    { 1160, 736, -128},
    { 1120, 728, -120},
    { 992, 688, -192},
    { 944, 744, -64},
    { 1120, 928, 32},
    { 984, 632, -24},
    { 1024, 624, 0},
    { 1152, 592, -40},
    // 144 seconds
    { 952, 344, -136},
    { 848, 144, -56},
    { 888, 264, -88},
    { 1120, 248, -64},
    { 1120, 248, -120},
    { 1144, 176, -192},
    { 1056, 104, -192},
    { 784, 64, -384},
    { 1312, 160, -96},
    { 840, 336, -368},
    { 1016, 352, -528},
    { 1120, 360, -256},
    { 840, 232, -152},
    { 632, 288, -200},
    { 656, 376, -152},
    { 800, 544, -168},
    { 1088, 768, -224},
    { 1144, 1232, 56},
    { 984, 256, -600},
    { 928, 736, -120},
    { 1120, 1128, 48},
    { 1120, 632, 32},
    { 1208, 520, -128},
    { 1176, 448, -128},
    { 840, 256, -120},
    // 145 seconds
    { 680, 216, -136},
    { 816, 304, -176},
    { 1280, 376, -144},
    { 1536, 296, -136},
    { 1312, 128, -328},
    { 848, -280, -288},
    { 800, -56, -344},
    { 1048, 8, -40},
    { 864, 288, -392},
    { 952, 352, -376},
    { 880, 192, -296},
    { 744, 360, -264},
    { 672, 376, -216},
    { 912, 488, -288},
    { 1192, 624, -312},
    { 1160, 888, -88},
    { 952, 984, -56},
    { 984, 576, -288},
    { 1328, 912, -128},
    { 944, 680, -32},
    { 1160, 648, -72},
    { 1240, 592, -152},
    { 1064, 240, -16},
    { 744, 200, -96},
    { 656, 280, -208},
    // 146 seconds
    { 984, 264, -32},
    { 1336, 232, -96},
    { 1368, 160, -128},
    { 1168, -16, -280},
    { 760, -88, -160},
    { 1256, 96, -24},
    { 680, 288, -432},
    { 1120, 184, -352},
    { 1168, 456, -144},
    { 880, -32, -264},
    { 832, 400, -152},
    { 824, 488, -112},
    { 1000, 496, -168},
    { 1184, 616, -96},
    { 1160, 864, 56},
    { 1048, 840, -16},
    { 928, 496, -184},
    { 1144, 880, 32},
    { 840, 616, 8},
    { 1064, 576, 0},
    { 1208, 576, 8},
    { 1128, 304, -120},
    { 960, 96, -144},
    { 864, 312, -120},
    { 1040, 368, -72},
    // 147 seconds
    { 1224, 312, -96},
    { 1224, 176, -200},
    { 1216, 168, -312},
    { 776, -48, -336},
    { 1176, 56, -224},
    { 768, 280, -320},
    { 1016, 200, -384},
    { 1104, 496, -312},
    { 944, 112, -216},
    { 800, 432, -184},
    { 808, 352, -120},
    { 968, 456, -168},
    { 1160, 624, -152},
    { 1184, 944, 88},
    { 856, 888, 8},
    { 896, 304, -352},
    { 1360, 856, 136},
    { 1016, 664, 80},
    { 1120, 560, 88},
    { 1136, 552, 0},
    { 960, 232, -176},
    { 736, 248, -184},
    { 808, 288, -104},
    { 1048, 352, -8},
    { 1304, 248, -120},
    // 148 seconds
    { 1392, 248, -184},
    { 1336, 248, -192},
    { 960, -184, -600},
    { 1144, -200, -40},
    { 608, 224, -352},
    { 1016, 416, -416},
    { 1280, 144, -208},
    { 904, 200, -200},
    { 672, 424, -144},
    { 832, 240, -224},
    { 936, 496, -192},
    { 1128, 688, -72},
    { 1048, 888, 8},
    { 936, 752, -56},
    { 936, 496, -168},
    { 1360, 952, 64},
    { 1016, 568, 16},
    { 1048, 560, -16},
    { 1112, 568, 32},
    { 1048, 368, -104},
    { 880, 128, -168},
    { 888, 160, -104},
    { 1000, 400, -80},
    { 1168, 256, -104},
    { 1184, 128, -272},
    // 149 seconds
    { 1048, -8, -288},
    { 928, -40, -280},
    { 1232, -48, -240},
    { 880, 144, -272},
    { 944, 328, -408},
    { 1232, 224, -352},
    { 816, 56, -320},
    { 736, 264, -248},
    { 696, 472, -144},
    { 960, 440, -128},
    { 1176, 536, -96},
    { 1096, 792, -16},
    { 984, 872, 136},
    { 952, 424, -160},
    { 1232, 760, 104},
    { 952, 552, 24},
    { 1096, 560, 16},
    { 1152, 624, 48},
    { 1160, 424, -24},
    { 832, 264, -104},
    { 792, 104, -96},
    { 912, 248, -96},
    { 1200, 312, -64},
    { 1384, 280, -128},
    { 1360, 184, -200},
    // 150 seconds
    { 944, -120, -392},
    { 984, 144, -168},
    { 920, 80, -96},
    { 784, 344, -384},
    { 1288, 200, -120},
    { 952, 480, -112},
    { 664, 176, -136},
    { 816, 288, -192},
    { 1016, 408, -48},
    { 1160, 704, -56},
    { 1120, 784, 112},
    { 952, 672, -56},
    { 936, 352, -136},
    { 1064, 712, 24},
    { 1112, 776, 200},
    { 1224, 552, 48},
    { 1200, 480, 24},
    { 1200, 384, -16},
    { 888, 200, -72},
    { 728, 208, -80},
    { 872, 232, -96},
    { 1272, 248, -120},
    { 1352, 272, 0},
    { 1200, 256, -144},
    { 1040, -64, -296},
    // 151 seconds
    { 888, 88, -200},
    { 1176, 8, 56},
    { 816, 376, -280},
    { 1208, 176, -120},
    { 1056, 464, -224},
    { 728, 328, -32},
    { 616, 256, -216},
    { 832, 400, 88},
    { 1024, 776, 272},
    { 1192, 784, 288},
    { 1080, 576, 136},
    { 920, 576, 32},
    { 888, 704, 192},
    { 1200, 824, 192},
    { 1104, 528, 56},
    { 1160, 608, 72},
    { 1280, 592, 80},
    { 832, 392, -184},
    { 776, 168, -208},
    { 792, 272, -104},
    { 984, 232, -40},
    { 1224, 232, 40},
    { 1264, 160, -48},
    { 1248, 160, -64},
    { 944, 96, -320},
    // 152 seconds
    { 1120, 88, -104},
    { 744, 88, -152},
    { 896, 392, -376},
    { 1184, 248, -208},
    { 848, 320, -168},
    { 672, 376, -136},
    { 632, 168, -88},
    { 960, 424, -24},
    { 1136, 696, -24},
    { 1304, 848, 0},
    { 1048, 776, 120},
    { 896, 472, -320},
    { 864, 600, -8},
    { 1168, 928, 64},
    { 1136, 576, 80},
    { 1288, 568, 40},
    { 1472, 512, 72},
    { 1168, 240, -136},
    { 864, 176, -136},
    { 792, 304, -88},
    { 1088, 312, -72},
    { 1344, 232, -24},
    { 1288, 272, -104},
    { 1216, 128, -248},
    { 728, -32, -256},
    // 153 seconds
    { 1152, 80, -104},
    { 744, 144, -256},
    { 984, 296, -272},
    { 1248, 376, -224},
    { 952, 400, -200},
    { 608, 488, -80},
    { 608, 544, -72},
    { 872, 320, -184},
    { 1144, 576, -16},
    { 1280, 824, 88},
    { 1208, 896, 136},
    { 1000, 712, 104},
    { 1032, 848, 40},
    { 1040, 672, 104},
    { 1096, 568, 56},
    { 1256, 616, 104},
    { 1296, 480, 64},
    { 1120, 280, -96},
    { 944, 96, -136},
    { 920, 240, -96},
    { 1112, 352, -40},
    { 1288, 264, -128},
    { 1200, 160, -128},
    { 1128, 120, -248},
    { 768, 8, -256},
    // 154 seconds
    { 1152, 120, -48},
    { 736, 288, -312},
    { 1104, 304, -288},
    { 1264, 384, -144},
    { 976, 384, -80},
    { 760, 392, -88},
    { 752, 352, -40},
    { 920, 464, -24},
    { 1112, 648, 8},
    { 1200, 632, 8},
    { 1048, 752, -8},
    { 912, 808, 40},
    { 1144, 992, 176},
    { 1072, 600, 80},
    { 1152, 552, -24},
    { 1320, 600, 104},
    { 1360, 368, 0},
    { 1056, 136, -128},
    { 896, 304, -104},
    { 1040, 344, -40},
    { 1272, 192, -64},
    { 1352, 208, -72},
    { 1240, 40, -224},
    { 960, -24, -264},
    { 1016, 96, -392},
    // 155 seconds
    { 1048, -8, -216},
    { 1032, 344, -336},
    { 1136, 352, -248},
    { 928, 360, -248},
    { 600, 272, -152},
    { 552, 344, -80},
    { 776, 264, -104},
    { 1104, 488, -16},
    { 1200, 752, 80},
    { 1192, 888, 72},
    { 1104, 768, 16},
    { 992, 720, -120},
    { 1072, 864, 0},
    { 1008, 600, -8},
    { 944, 632, -8},
    { 1096, 568, -56},
    { 1056, 312, -104},
    { 848, 280, -192},
    { 784, 336, -248},
    { 1040, 272, -120},
    { 1400, 352, -88},
    { 1408, 200, -160},
    { 1160, 104, -304},
    { 896, 0, -408},
    { 1472, 32, 0},
    // 156 seconds
    { 792, 416, -400},
    { 928, 272, -360},
    { 808, 416, -240},
    { 544, 232, -168},
    { 464, 360, -120},
    { 624, 344, -48},
    { 904, 472, -56},
    { 1232, 800, 0},
    { 1288, 816, 104},
    { 1056, 704, 8},
    { 912, 640, -48},
    { 1280, 904, 40},
    { 1224, 656, 144},
    { 1040, 688, 152},
    { 1112, 688, 104},
    { 864, 496, 0},
    { 808, 544, -16},
    { 992, 632, 0},
    { 1136, 752, -8},
    { 1120, 768, -64},
    { 1064, 696, -216},
    { 1080, 384, -216},
    { 728, -152, -72},
    { 752, 136, -200},
    { 520, 128, -224},
    // 157 seconds
    { 664, 208, -424},
    { 728, 824, -728},
    { 728, 512, -904},
    { 448, 712, -960},
    { 232, 216, -688},
    { 464, 120, -552},
    { 408, 120, -584},
    { 344, -40, -664},
    { 408, 24, -968},
    { 528, 448, -1480},
    { 592, 592, -1536},
    { 728, 560, -1448},
    { 656, 984, -1288},
    { 632, 744, -1192},
    { 680, 640, -1032},
    { 600, 392, -752},
    { 488, 200, -608},
    { 496, 72, -640},
    { 440, 152, -616},
    { 464, 56, -544},
    { 488, 8, -520},
    { 544, -16, -448},
    { 496, -72, -304},
    { 704, 296, -496},
    { 664, 184, -552},
    // 158 seconds
    { 920, 16, -360},
    { 1320, 448, -472},
    { 1184, 264, -432},
    { 984, 200, -416},
    { 1024, 152, -128},
    { 1416, 392, -216},
    { 1544, 512, -376},
    { 1320, 688, -424},
    { 1072, 896, -328},
    { 864, 912, -312},
    { 1040, 1056, -312},
    { 792, 584, -176},
    { 1016, 672, -240},
    { 1248, 576, -200},
    { 1200, 400, -208},
    { 1000, 176, -176},
    { 968, 168, -280},
    { 1128, 112, -152},
    { 1312, 264, -272},
    { 1336, 224, -240},
    { 1240, 192, -272},
    { 728, -128, -320},
    { 936, 0, -208},
    { 936, 288, -240},
    { 784, 320, -440},
    // 159 seconds
    { 984, 248, -312},
    { 816, 328, -216},
    { 656, 304, -256},
    { 720, 208, -144},
    { 960, 384, -240},
    { 1296, 488, -256},
    { 1360, 832, -240},
    { 1104, 608, -272},
    { 992, 528, -304},
    { 1184, 920, -312},
    { 992, 696, 16},
    { 1256, 728, -80},
    { 1200, 504, -72},
    { 944, 392, -184},
    { 672, 256, -160},
    { 680, 288, -192},
    { 888, 184, -176},
    { 1168, 176, -200},
    { 1296, 88, -160},
    { 1320, 192, -184},
    { 792, -8, -224},
    { 1168, 240, -232},
    { 784, 64, -288},
    { 872, 384, -560},
    { 1072, 216, -344},
    // 160 seconds
    { 792, 288, -192},
    { 592, 232, -256},
    { 608, 296, -176},
    { 712, 376, -232},
    { 968, 360, -248},
    { 1320, 664, -216},
    { 1136, 792, -240},
    { 968, 808, -184},
    { 1352, 912, -136},
    { 1048, 576, -104},
    { 1168, 600, -128},
    { 1144, 536, -104},
    { 896, 384, -120},
    { 752, 208, -160},
    { 776, 152, -144},
    { 928, 208, -160},
    { 1200, 216, -120},
    { 1336, 208, -184},
    { 1400, 56, -152},
    { 968, -112, -216},
    { 968, -64, -272},
    { 856, -24, -144},
    { 912, 280, -416},
    { 1064, 216, -288},
    { 952, 352, -256},
    // 161 seconds
    { 712, 288, -216},
    { 712, 344, -240},
    { 832, 280, -144},
    { 1064, 240, -312},
    { 1344, 752, -128},
    { 1016, 848, -72},
    { 856, 544, -304},
    { 968, 856, -96},
    { 1288, 592, -136},
    { 1256, 432, -64},
    { 1152, 544, -120},
    { 1224, 504, -120},
    { 832, 320, -224},
    { 880, -8, -104},
    { 864, 64, -168},
    { 968, 312, -168},
    { 1216, 200, -96},
    { 1400, 136, -144},
    { 1240, 88, -136},
    { 856, -8, -304},
    { 1096, -48, -32},
    { 520, 208, -376},
    { 968, 224, -368},
    { 1168, 304, -224},
    { 896, 304, -200},
    // 162 seconds
    { 688, 376, -224},
    { 736, 288, -152},
    { 976, 440, -232},
    { 1232, 304, -304},
    { 1128, 992, -72},
    { 1024, 984, -200},
    { 792, 888, -208},
    { 1192, 1264, -56},
    { 1040, 344, 8},
    { 1168, 696, -80},
    { 1248, 472, -64},
    { 952, 288, -112},
    { 816, 328, -184},
    { 880, 312, -176},
    { 1120, 304, -200},
    { 1208, 248, -168},
    { 1296, 280, -256},
    { 1024, 56, -240},
    { 648, 56, -392},
    { 1088, 72, -176},
    { 696, 280, -400},
    { 1032, 280, -328},
    { 1160, 416, -296},
    { 856, 368, -168},
    { 704, 376, -232},
    // 163 seconds
    { 832, 264, -232},
    { 1080, 184, -216},
    { 1416, 752, -168},
    { 1224, 1024, 16},
    { 856, 592, -344},
    { 776, 872, -40},
    { 1288, 840, 40},
    { 1072, 512, 16},
    { 1160, 664, -32},
    { 1256, 560, -64},
    { 1056, 344, -128},
    { 872, 224, -88},
    { 904, 344, -168},
    { 1088, 296, -144},
    { 1232, 304, -104},
    { 1368, 296, -136},
    { 1248, 200, -144},
    { 816, -16, -280},
    { 1112, 152, -56},
    { 560, 0, -200},
    { 984, 416, -360},
    { 1072, 352, -280},
    { 904, 336, -304},
    { 672, 248, -240},
    { 632, 368, -248},
    // 164 seconds
    { 792, 288, -160},
    { 1008, 304, -192},
    { 1280, 808, -96},
    { 1112, 816, -104},
    { 992, 880, -96},
    { 1136, 944, -112},
    { 936, 920, -24},
    { 1208, 704, 8},
    { 1296, 744, 56},
    { 1168, 728, 16},
    { 1016, 608, 184},
    { 1048, 856, -16},
    { 1256, 1088, 160},
    { 1264, 1128, 184},
    { 1048, 1064, -96},
    { 1000, 1152, -240},
    { 664, 504, -264},
    { 336, 192, -568},
    { 184, 48, -528},
    { -40, -136, -832},
    { 80, -144, -808},
    { 24, -72, -808},
    { 0, -208, -728},
    { -80, -288, -680},
    { -128, -368, -664},
    // 165 seconds
    { -160, -384, -776},
    { -240, -352, -896},
    { -296, -384, -952},
    { -304, -336, -1176},
    { -304, -424, -1048},
    { -400, -240, -1144},
    { -448, -248, -1064},
    { -392, -152, -1000},
    { -240, -104, -1040},
    { -120, -312, -728},
    { -64, -208, -560},
    { -40, -160, -464},
    { 112, -56, -472},
    { 312, 184, -560},
    { 536, 256, -536},
    { 1048, 648, -504},
    { 1104, 664, -344},
    { 1608, 728, -128},
    { 1808, 976, -272},
    { 1920, 1272, -616},
    { 1640, 768, -88},
    { 1024, 784, -112},
    { 800, 416, -80},
    { 952, 480, -88},
    { 872, 280, 80},
    // 166 seconds
    { 904, 824, 304},
    { 680, 1072, 296},
    { 752, 696, 128},
    { 768, 552, -24},
    { 1168, 1080, 96},
    { 1200, 416, -120},
    { 1344, 672, -160},
    { 1616, 600, -40},
    { 1360, 400, -64},
    { 1120, 432, -144},
    { 1088, 408, -176},
    { 1216, 384, -144},
    { 1328, 256, -56},
    { 1320, 216, -72},
    { 992, 0, -136},
    { 704, 48, -304},
    { 1000, -136, 0},
    { 752, 304, -312},
    { 992, 360, -312},
    { 1208, 440, -216},
    { 848, 376, -112},
    { 616, 424, -176},
    { 920, 344, -144},
    { 1416, 632, -112},
    { 1464, 712, -80},
    // 167 seconds
    { 1360, 1064, 72},
    { 1032, 888, -32},
    { 792, 736, 24},
    { 944, 1168, 184},
    { 1048, 816, 240},
    { 1104, 632, 48},
    { 1200, 608, 40},
    { 1056, 448, 0},
    { 864, 312, -96},
    { 872, 368, -112},
    { 1144, 408, -104},
    { 1504, 440, -136},
    { 1368, 80, -112},
    { 1096, -16, -216},
    { 696, -88, -352},
    { 1640, -40, 8},
    { 1000, 200, -552},
    { 1280, 240, -456},
    { 1176, 280, -224},
    { 880, 272, -176},
    { 640, 400, -184},
    { 768, 336, -152},
    { 1048, 424, -56},
    { 1264, 624, -40},
    { 1360, 920, 40},
    // 168 seconds
    { 1040, 624, -88},
    { 800, 576, -8},
    { 1168, 968, 96},
    { 1072, 520, 152},
    { 1056, 640, 32},
    { 1128, 640, 16},
    { 992, 456, -40},
    { 784, 344, -64},
    { 816, 344, -80},
    { 968, 336, -128},
    { 1400, 288, 40},
    { 1592, 288, 32},
    { 1472, 80, -64},
    { 992, -336, -312},
    { 1536, -120, -8},
    { 752, 24, -320},
    { 1208, 408, -336},
    { 1208, 432, -32},
    { 768, 312, -32},
    { 568, 392, 16},
    { 624, 344, -8},
    { 832, 376, 24},
    { 1200, 312, -64},
    { 1432, 920, 272},
    { 1160, 848, 336},
    // 169 seconds
    { 1056, 600, -160},
    { 1272, 1064, 312},
    { 832, 184, -16},
    { 1000, 800, 120},
    { 1144, 672, 224},
    { 1048, 344, 72},
    { 792, 216, -16},
    { 776, 424, -136},
    { 936, 128, 16},
    { 1336, 448, 40},
    { 1448, 40, -56},
    { 1408, -48, -192},
    { 944, -48, -368},
    { 1216, -144, -400},
    { 1032, -152, -256},
    { 1072, 288, -304},
    { 1088, 88, -312},
    { 928, 216, -208},
    { 720, 320, -56},
    { 792, 328, 8},
    { 1024, 368, -152},
    { 1376, 536, 32},
    { 1312, 800, 160},
    { 1064, 1008, 376},
    { 888, 984, 168},
    // 170 seconds
    { 840, 816, 224},
    { 944, 792, 184},
    { 1144, 632, 192},
    { 1272, 640, 128},
    { 1200, 520, 96},
    { 960, 336, 16},
    { 760, 64, 72},
    { 880, 232, -48},
    { 1304, 368, 64},
    { 1656, 352, 48},
    { 1344, 208, -200},
    { 968, 24, -208},
    { 784, 152, -376},
    { 1024, -128, -152},
    { 912, 272, -296},
    { 1064, 312, -240},
    { 1096, 360, -128},
    { 856, 368, -72},
    { 736, 360, -48},
    { 936, 312, -80},
    { 1288, 400, -56},
    { 1576, 784, 80},
    { 1344, 1048, 296},
    { 944, 736, 72},
    { 832, 1056, 64},
    // 171 seconds
    { 896, 936, 152},
    { 936, 664, 80},
    { 984, 656, 96},
    { 1056, 656, 72},
    { 928, 440, 48},
    { 872, 208, 48},
    { 968, 296, -48},
    { 1304, 376, -120},
    { 1488, 352, 16},
    { 1288, 360, -40},
    { 1160, 256, -88},
    { 648, 72, -328},
    { 1064, 96, -88},
    { 912, 88, -168},
    { 864, 552, -328},
    { 1080, 400, -224},
    { 960, 416, -96},
    { 688, 376, -112},
    { 600, 408, -32},
    { 856, 424, -8},
    { 1456, 632, -40},
    { 1640, 928, 216},
    { 1200, 1576, 824},
    { 632, 104, -480},
    { 1088, 1768, 576},
    // 172 seconds
    { 1096, 248, 304},
    { 1160, 688, 192},
    { 1136, 624, 152},
    { 888, 448, 88},
    { 664, 440, 48},
    { 776, 416, -56},
    { 1088, 360, 24},
    { 1408, 432, -96},
    { 1648, 408, -80},
    { 1376, 208, 16},
    { 840, 200, -248},
    { 1200, 248, 88},
    { 472, 408, -208},
    { 648, 384, -200},
    { 968, 448, -216},
    { 784, 440, -160},
    { 608, 424, -96},
    { 584, 400, 0},
    { 840, 464, -24},
    { 1144, 704, -16},
    { 1384, 784, 248},
    { 1088, 632, 72},
    { 1008, 720, 128},
    { 1176, 976, 256},
    { 936, 704, 368},
    // 173 seconds
    { 984, 600, 288},
    { 1024, 568, 168},
    { 904, 464, 96},
    { 656, 416, 8},
    { 600, 400, -32},
    { 912, 312, -24},
    { 1336, 320, -56},
    { 1288, 352, -64},
    { 1288, 344, -104},
    { 1016, 304, -264},
    { 1312, 176, -48},
    { 568, 192, -264},
    { 824, 384, -336},
    { 1120, 328, -176},
    { 720, 288, -120},
    { 504, 344, -112},
    { 568, 312, -64},
    { 808, 328, -32},
    { 1152, 360, -88},
    { 1304, 888, 104},
    { 1032, 848, 64},
    { 888, 640, -24},
    { 1096, 872, 88},
    { 984, 824, 168},
    { 992, 544, 88},
    // 174 seconds
    { 1064, 616, 136},
    { 992, 528, 80},
    { 728, 296, 0},
    { 600, 328, -64},
    { 856, 344, -80},
    { 1328, 432, -8},
    { 1408, 248, 8},
    { 1384, 400, -176},
    { 1080, 96, -216},
    { 1064, 80, -168},
    { 872, 96, -24},
    { 792, 488, -240},
    { 1104, 296, -184},
    { 872, 416, -88},
    { 592, 400, -48},
    { 592, 336, -56},
    { 792, 384, -56},
    { 1144, 488, -48},
    { 1336, 808, -8},
    { 1200, 1080, 328},
    { 864, 552, -24},
    { 952, 792, -56},
    { 1120, 824, 288},
    { 976, 528, 144},
    { 1048, 664, 200},
    // 175 seconds
    { 1120, 568, 160},
    { 832, 408, 0},
    { 696, 376, -32},
    { 848, 384, -88},
    { 1152, 344, 48},
    { 1400, 424, 88},
    { 1312, 320, -48},
    { 1160, 328, 24},
    { 1256, 448, -40},
    { 1024, 256, 216},
    { 576, 544, -256},
    { 920, 360, -200},
    { 816, 472, -8},
    { 504, 344, -40},
    { 352, 400, -88},
    { 496, 360, 120},
    { 760, 504, 224},
    { 960, 720, 216},
    { 1080, 784, 176},
    { 1216, 824, 104},
    { 1368, 792, 272},
    { 1272, 824, 272},
    { 1176, 1152, 280},
    { 1032, 856, 104},
    { 920, 872, 232},
    // 176 seconds
    { 536, 728, -168},
    { 816, 696, 64},
    { 1672, 208, 200},
    { 984, -240, -8},
    { 672, -40, -128},
    { 728, 296, -96},
    { 736, 264, 96},
    { 744, 344, -56},
    { 1344, 608, 384},
    { 1024, 640, 264},
    { 1000, 840, 104},
    { 640, 296, 240},
    { 368, 288, 64},
    { 288, 408, 160},
    { 352, 384, 128},
    { 408, 648, 304},
    { 520, 744, 472},
    { 360, 944, 544},
    { 344, 872, 720},
    { 208, 912, 744},
    { 144, 1008, 1456},
    { -256, 1664, 800},
    { 0, 1088, 952},
    { -184, 1176, 680},
    { 0, 1424, 504},
    // 177 seconds
    { 112, 1128, 224},
    { 232, 864, -40},
    { 792, 1160, -96},
    { 160, 536, -208},
    { 216, 192, -384},
    { 304, 8, -800},
    { 224, -128, -904},
    { 216, -216, -944},
    { 56, -176, -1056},
    { 168, -152, -1112},
    { 224, -56, -1080},
    { 136, -264, -936},
    { -16, -192, -848},
    { -152, -288, -832},
    { -224, -280, -800},
    { -296, -248, -904},
    { -368, -408, -976},
    { -336, -352, -1032},
    { -248, -440, -1104},
    { -344, -496, -984},
    { -328, -448, -1056},
    { -392, -240, -936},
    { -432, -368, -800},
    { -208, -192, -816},
    { -24, -168, -568},
    // 178 seconds
    { 24, -200, -272},
    { 64, 16, -264},
    { 96, 72, -304},
    { 184, 232, -368},
    { 296, 472, -480},
    { 536, 624, -408},
    { 880, 1160, -152},
    { 976, 1160, -56},
    { 2048, 1912, 216},
    { 1560, 1808, -200},
    { 1376, 1272, 448},
    { 1016, 1056, 496},
    { 768, 968, 384},
    { 280, 488, 624},
    { 160, 576, 544},
    { 80, 584, 600},
    { 64, 544, 632},
    { 40, 592, 648},
    { 288, 784, 680},
    { 424, 640, 768},
    { 912, 1128, 896},
    { 1664, 976, 1088},
    { 808, 872, 624},
    { 688, 1040, 392},
    { 256, 944, 360},
    // 179 seconds
    { 264, 944, 512},
    { 528, 968, 656},
    { 640, 1680, 264},
    { 640, 1128, 208},
    { 464, 472, 16},
    { 320, 336, -552},
    { 40, 200, -488},
    { 64, -136, -880},
    { 64, -80, -944},
    { 72, -8, -960},
    { 160, -48, -976},
    { 152, -152, -832},
    { 0, -192, -880},
    { -144, -248, -896},
    { -128, -456, -928},
    { -320, -568, -952},
    { -240, -656, -1008},
    { -136, -824, -1384},
    { 264, -696, -1488},
    { 144, -808, -1544},
    { 280, -624, -1376},
    { 616, -760, -944},
    { 648, 320, -896},
    { 32, 736, -648},
    { 176, 368, -528},
    // 180 seconds
    // elapsed: 3 minutes
    { -24, 616, -168},
    { -280, 512, 0},
    { -320, 672, 320},
    { -424, 632, 344},
    { -328, 736, 312},
    { -360, 544, 136},
    { -376, 960, 112},
    { -512, 1240, 368},
    { -552, 584, -64},
    { -680, 624, -336},
    { -664, 312, -184},
    { -264, -368, -328},
    { -224, -1512, -576},
    { -224, -480, -616},
    { -184, -1256, -504},
    { -176, -1136, -520},
    { -152, -880, -552},
    { -120, -1152, -384},
    { -80, -936, -536},
    { -48, -1056, -472},
    { -16, -1016, -520},
    { 8, -960, -512},
    { 16, -1008, -488},
    { 16, -952, -528},
    { 40, -936, -544},
    // 181 seconds
    { 48, -984, -488},
    { 64, -896, -544},
    { 48, -896, -512},
    { 80, -920, -528},
    { 56, -896, -496},
    { 120, -808, -488},
    { 152, -856, -112},
    { 232, -832, -40},
    { 328, -456, -136},
    { 456, -384, -344},
    { 216, 192, 344},
    { 232, 2192, 1872},
    { -1248, 1936, 48},
    { -464, 1160, 968},
    { -664, 1408, 328},
    { -568, 1512, 488},
    { -440, 1448, 544},
    { -344, 1408, 552},
    { -384, 1136, 344},
    { -336, 832, 520},
    { -352, 712, 464},
    { -288, 712, 480},
    { -160, 608, 496},
    { -296, 656, 440},
    { -312, 664, 488},
    // 182 seconds
    { -344, 648, 488},
    { -400, 824, 616},
    { -472, 776, 680},
    { -432, 624, 552},
    { -384, 752, 400},
    { -288, 640, 432},
    { -272, 792, 272},
    { -320, 744, 456},
    { -288, 880, 328},
    { -272, 832, 280},
    { -264, 688, 216},
    { -304, 856, 288},
    { -312, 784, 312},
    { -280, 944, 368},
    { -304, 912, 448},
    { -256, 984, 432},
    { -192, 832, 392},
    { -192, 928, 312},
    { -184, 800, 352},
    { -304, 880, 392},
    { -272, 800, 432},
    { -304, 824, 376},
    { -288, 864, 408},
    { -296, 848, 392},
    { -256, 840, 368},
    // 183 seconds
    { -248, 752, 384},
    { -264, 800, 376},
    { -264, 760, 368},
    { -288, 680, 344},
    { -320, 672, 320},
    { -344, 752, 384},
    { -360, 872, 376},
    { -336, 720, 472},
    { -280, 760, 392},
    { -232, 656, 304},
    { -112, 672, 472},
    { 192, 1128, 560},
    { 112, 1152, 520},
    { 88, 976, 360},
    { -112, 1080, 472},
    { 8, 648, 600},
    { 128, 784, 328},
    { 200, 808, 216},
    { 192, 728, 224},
    { 224, 936, 48},
    { 232, 704, 200},
    { 152, 744, 120},
    { 80, 864, 216},
    { 96, 992, 24},
    { 112, 880, 16},
    // 184 seconds
    { 160, 912, 80},
    { 192, 928, 160},
    { 208, 896, 136},
    { 184, 872, 112},
    { 184, 888, 112},
    { 160, 880, 128},
    { 160, 920, 136},
    { 168, 912, 120},
    { 152, 888, 72},
    { 184, 872, 96},
    { 160, 912, 128},
    { 176, 920, 144},
    { 184, 872, 104},
    { 168, 880, 80},
    { 160, 904, 128},
    { 176, 920, 136},
    { 176, 872, 136},
    { 152, 904, 104},
    { 160, 920, 80},
    { 160, 896, 120},
    { 168, 904, 128},
    { 160, 904, 112},
    { 152, 904, 88},
    { 160, 896, 88},
    { 168, 904, 112},
    // 185 seconds
    { 168, 912, 128},
    { 184, 888, 112},
    { 168, 872, 88},
    { 192, 888, 48},
    { 160, 920, 128},
    { 176, 912, 96},
    { 152, 864, 72},
    { 152, 896, 88},
    { 160, 936, 96},
    { 160, 912, 72},
    { 96, 936, -48},
    { -24, 1008, -184},
    { 48, 1160, -224},
    { 80, 1000, -248},
    { 160, 1008, -240},
    { 136, 1168, -80},
    { 96, 928, -488},
    { 104, 664, -480},
    { 264, 472, -624},
    { 288, 112, -792},
    { 208, 160, -920},
    { 160, 16, -992},
    { 104, -24, -1040},
    { 80, 56, -904},
    { 40, 0, -936},
    // 186 seconds
    { 64, -8, -984},
    { 32, 104, -872},
    { 88, 56, -912},
    { 104, -24, -976},
    { 120, 56, -984},
    { 112, 160, -928},
    { 136, 120, -1000},
    { 152, 144, -992},
    { 200, 88, -1000},
    { 216, 128, -960},
    { 272, 72, -960},
    { 280, 192, -944},
    { 288, 128, -1048},
    { 232, 88, -1168},
    { 152, 152, -1192},
    { 168, 248, -936},
    { 216, 296, -808},
    { 176, 416, -936},
    { 168, 240, -984},
    { 208, 184, -904},
    { 160, 280, -920},
    { 144, 288, -944},
    { 160, 384, -920},
    { 96, 424, -784},
    { 296, 240, -1192},
    // 187 seconds
    { -96, 432, -944},
    { 104, 344, -896},
    { 144, 240, -976},
    { 176, 328, -952},
    { 128, 312, -896},
    { 128, 304, -976},
    { 40, 248, -920},
    { 48, 392, -944},
    { 328, 112, -936},
    { 160, 328, -984},
    { 96, 336, -912},
    { 128, 288, -936},
    { 128, 320, -920},
    { 160, 240, -952},
    { 96, 360, -920},
    { 104, 304, -920},
    { 32, 368, -968},
    { 112, 320, -936},
    { 104, 296, -944},
    { 96, 320, -936},
    { 96, 304, -952},
    { 104, 304, -944},
    { 96, 320, -936},
    { 96, 304, -936},
    { 104, 320, -936},
    // 188 seconds
    { 104, 328, -920},
    { 112, 320, -928},
    { 96, 336, -912},
    { 96, 312, -952},
    { 96, 312, -952},
    { 120, 288, -928},
    { -256, 544, -832},
    { 112, 344, -912},
    { 72, 344, -912},
    { 96, 328, -944},
    { 112, 328, -920},
    { 136, 336, -864},
    { 144, 360, -936},
    { 136, 384, -952},
    { 144, 400, -928},
    { 120, 392, -952},
    { 184, 328, -912},
    { 152, 408, -944},
    { 120, 496, -864},
    { 128, 344, -872},
    { 0, 472, -736},
    { -40, 496, -816},
    { -88, 536, -744},
    { -16, 576, -800},
    { -24, 680, -736},
    // 189 seconds
    { 16, 688, -728},
    { 56, 664, -736},
    { 96, 656, -736},
    { 88, 728, -688},
    { 96, 680, -680},
    { 88, 696, -656},
    { 64, 696, -640},
    { 72, 688, -624},
    { 80, 688, -664},
    { 88, 680, -696},
    { 96, 712, -664},
    { 104, 704, -648},
    { 88, 664, -664},
    { 80, 672, -664},
    { 72, 696, -680},
    { 72, 696, -672},
    { 80, 680, -664},
    { 72, 688, -664},
    { 64, 672, -680},
    { 64, 696, -672},
    { 80, 672, -680},
    { 88, 680, -680},
    { 104, 688, -672},
    { 88, 672, -696},
    { 80, 672, -704},
    // 190 seconds
    { 64, 680, -688},
    { 40, 712, -608},
    { 40, 696, -640},
    { 40, 664, -696},
    { 48, 680, -704},
    { 48, 696, -680},
    { 48, 680, -680},
    { 56, 688, -696},
    { 64, 688, -664},
    { 48, 696, -648},
    { 48, 664, -680},
    { 56, 640, -712},
    { 56, 696, -688},
    { 48, 704, -632},
    { 56, 696, -680},
    { 40, 664, -696},
    { 56, 672, -696},
    { 56, 704, -672},
    { 64, 656, -680},
    { 48, 664, -704},
    { 48, 672, -688},
    { 48, 728, -664},
    { 72, 680, -656},
    { 72, 640, -696},
    { 48, 640, -712},
    // 191 seconds
    { 32, 688, -680},
    { 48, 696, -680},
    { 64, 688, -704},
    { 64, 664, -680},
    { 56, 656, -672},
    { 48, 696, -680},
    { 72, 672, -712},
    { 56, 672, -688},
    { 64, 640, -688},
    { 40, 664, -680},
    { 64, 688, -688},
    { 48, 712, -680},
    { 48, 680, -680},
    { 48, 648, -712},
    { 40, 648, -720},
    { 56, 680, -680},
    { 56, 672, -640},
    { 72, 672, -664},
    { 56, 656, -696},
    { 40, 712, -704},
    { 48, 648, -680},
    { 72, 608, -672},
    { 32, 664, -672},
    { 48, 640, -720},
    { 96, 608, -656},
    // 192 seconds
    { 112, 760, -640},
    { 72, 800, -640},
    { 72, 744, -456},
    { 24, 752, -296},
    { -48, 712, -128},
    { -88, 832, 272},
    { -256, 912, 296},
    { -136, 736, 664},
    { -72, 712, 936},
    { -96, 744, 904},
    { -64, 624, 864},
    { 8, 520, 680},
    { 64, 576, 848},
    { -56, 768, 816},
    { -88, 464, 792},
    { -80, 704, 616},
    { -88, 832, 712},
    { -24, 680, 584},
    { -32, 784, 496},
    { -8, 904, 480},
    { 48, 880, 544},
    { 80, 928, 512},
    { 32, 976, 608},
    { 40, 1000, 464},
    { 128, 888, 440},
    // 193 seconds
    { 136, 912, 384},
    { 200, 832, 328},
    { 128, 824, 360},
    { 8, 680, 392},
    { -64, 672, 304},
    { -112, 768, 320},
    { -152, 720, 296},
    { -304, 992, 360},
    { -304, 920, 192},
    { -328, 1032, 128},
    { -392, 984, 112},
    { -392, 864, 32},
    { -296, 1000, 128},
    { -208, 1016, -96},
    { -168, 1080, -192},
    { 8, 704, -104},
    { -208, 816, -120},
    { -192, 768, -208},
    { -184, 696, -312},
    { -160, 592, -304},
    { -160, 528, -296},
    { -160, 472, -304},
    { -80, 408, -312},
    { -48, 504, -288},
    { 8, 544, -224},
    // 194 seconds
    { 168, 736, -224},
    { 640, 720, -8},
    { 720, 952, -184},
    { 1008, 768, -208},
    { 1648, 736, 184},
    { 1672, 920, 272},
    { 1488, 928, 40},
    { 1240, 496, 48},
    { 1016, 432, -96},
    { 824, 328, 136},
    { 640, 384, 152},
    { 576, 376, 128},
    { 592, 392, 168},
    { 680, 440, 176},
    { 728, 568, 160},
    { 840, 696, 208},
    { 904, 880, 256},
    { 1264, 640, 56},
    { 1112, 664, -8},
    { 1264, 592, 80},
    { 1328, 640, 128},
    { 1584, 464, 192},
    { 1248, 320, 96},
    { 1056, 184, 88},
    { 896, 256, -8},
    // 195 seconds
    { 840, 256, 72},
    { 896, 280, 32},
    { 1088, 368, -16},
    { 1008, 192, -80},
    { 872, 224, -176},
    { 1032, 192, -32},
    { 720, 416, -192},
    { 1152, 568, -208},
    { 1128, 512, -64},
    { 872, 408, -96},
    { 728, 432, -88},
    { 888, 304, -16},
    { 1024, 656, 40},
    { 1080, 672, 200},
    { 1072, 768, 152},
    { 952, 872, 176},
    { 792, 792, 112},
    { 992, 752, 168},
    { 912, 816, 272},
    { 1048, 640, 176},
    { 1032, 648, 176},
    { 1128, 624, 120},
    { 912, 408, 64},
    { 800, 352, 32},
    { 912, 416, 40},
    // 196 seconds
    { 1096, 296, 56},
    { 1336, 352, 104},
    { 1208, 400, -8},
    { 1176, 280, -48},
    { 792, 72, -216},
    { 1312, 376, -88},
    { 752, 152, -64},
    { 816, 608, -312},
    { 864, 456, -232},
    { 808, 392, -16},
    { 720, 416, -32},
    { 720, 448, 16},
    { 840, 464, 16},
    { 1048, 424, 8},
    { 1112, 896, 280},
    { 952, 872, 264},
    { 840, 680, 8},
    { 984, 840, 176},
    { 1264, 952, 360},
    { 1272, 736, 216},
    { 1032, 656, 176},
    { 912, 664, 136},
    { 840, 456, 80},
    { 896, 304, 152},
    { 1048, 360, 144},
    // 197 seconds
    { 1232, 264, 208},
    { 1008, 376, 224},
    { 984, 448, 208},
    { 944, 480, 192},
    { 832, 480, 136},
    { 672, 568, -40},
    { 680, 496, -48},
    { 400, 400, -112},
    { 472, 688, -256},
    { 832, 568, -104},
    { 848, 608, 48},
    { 760, 656, 0},
    { 640, 792, 216},
    { 688, 752, 192},
    { 688, 808, 48},
    { 528, 1288, 256},
    { 424, 944, 280},
    { 280, 1096, 184},
    { 200, 1048, 240},
    { 312, 1000, 504},
    { 544, 1168, 440},
    { 1192, 1240, 416},
    { 1496, 1104, 656},
    { 1112, 864, 416},
    { 792, 648, 216},
    // 198 seconds
    { 696, 416, 256},
    { 608, 312, 208},
    { 600, 408, 344},
    { 464, 472, 304},
    { 296, 464, 368},
    { 232, 496, 504},
    { 184, 624, 560},
    { 64, 664, 648},
    { 8, 664, 472},
    { -56, 872, 616},
    { 120, 832, 632},
    { -64, 1016, 600},
    { -32, 952, 464},
    { 16, 984, 304},
    { 16, 768, 320},
    { 64, 784, 424},
    { 64, 776, 344},
    { 64, 912, 352},
    { 88, 1040, 392},
    { 8, 832, 416},
    { -56, 704, 392},
    { -96, 680, 432},
    { -72, 752, 344},
    { -32, 680, 336},
    { -56, 912, 336},
    // 199 seconds
    { -48, 936, 320},
    { 24, 960, 232},
    { -8, 968, 328},
    { -88, 760, 392},
    { -104, 760, 528},
    { 8, 704, 496},
    { -144, 840, 504},
    { -232, 904, 408},
    { -200, 904, 568},
    { -272, 1064, 544},
    { -256, 952, 336},
    { -296, 1304, 304},
    { -200, 704, 208},
    { -352, 952, -136},
    { -352, 480, -176},
    { -360, 776, -272},
    { -464, 744, -208},
    { -504, 728, -304},
    { -560, 696, -432},
    { -608, 536, -472},
    { -584, 384, -512},
    { -640, 576, -608},
    { -672, 392, -632},
    { -736, 480, -696},
    { -664, 176, -816},
    // 200 seconds
    { -648, 80, -776},
    { -616, 128, -808},
    { -528, -8, -808},
    { -496, -40, -872},
    { -432, -48, -888},
    { -376, -88, -816},
    { -392, 48, -936},
    { -400, -208, -952},
    { -416, -48, -920},
    { -464, -160, -936},
    { -456, -96, -944},
    { -464, -96, -912},
    { -472, -40, -936},
    { -496, -40, -984},
    { -456, -88, -904},
    { -432, -32, -912},
    { -528, 8, -1000},
    { -528, -64, -920},
    { -552, -64, -952},
    { -520, -152, -896},
    { -536, -88, -944},
    { -552, -64, -904},
    { -560, -80, -912},
    { -560, -104, -856},
    { -568, -104, -848},
    // 201 seconds
    { -568, -88, -824},
    { -512, -72, -840},
    { -512, -72, -808},
    { -496, -104, -816},
    { -512, -40, -784},
    { -504, -8, -824},
    { -480, 32, -744},
    { -416, 152, -704},
    { -392, 176, -672},
    { -320, 280, -632},
    { -272, 576, -592},
    { -272, 896, -600},
    { -312, 976, -448},
    { -232, 1168, -256},
    { -256, 1240, -280},
    { -200, 1080, -224},
    { -160, 1160, -184},
    { -96, 1104, -216},
    { -40, 944, -56},
    { -64, 1072, -40},
    { -32, 864, 128},
    { 8, 944, 200},
    { 48, 808, 312},
    { 24, 872, 344},
    { 128, 888, 296},
    // 202 seconds
    { 152, 792, 328},
    { 32, 856, 376},
    { 8, 752, 448},
    { -120, 744, 400},
    { -160, 728, 544},
    { -160, 776, 504},
    { -120, 672, 576},
    { -176, 672, 392},
    { -16, 888, 456},
    { 96, 760, 480},
    { 368, 928, 496},
    { 608, 888, 456},
    { 592, 784, 376},
    { 600, 800, 360},
    { 488, 784, 312},
    { 384, 792, 320},
    { 408, 744, 392},
    { 512, 744, 344},
    { 560, 736, 296},
    { 528, 720, 224},
    { 464, 712, 232},
    { 376, 696, 248},
    { 360, 680, 200},
    { 320, 616, 336},
    { 216, 728, 360},
    // 203 seconds
    { 344, 904, 376},
    { 440, 824, 400},
    { 488, 760, 384},
    { 552, 736, 288},
    { 544, 760, 152},
    { 512, 696, 192},
    { 568, 640, 192},
    { 568, 608, 168},
    { 560, 632, 192},
    { 464, 592, 280},
    { 512, 608, 376},
    { 392, 480, 384},
    { 568, 664, 536},
    { 608, 608, 664},
    { 544, 672, 536},
    { 552, 632, 616},
    { 528, 640, 672},
    { 560, 664, 608},
    { 504, 696, 600},
    { 472, 672, 576},
    { 448, 624, 568},
    { 344, 568, 560},
    { 264, 528, 528},
    { 176, 592, 544},
    { 128, 600, 568},
    // 204 seconds
    { 120, 584, 568},
    { 128, 616, 496},
    { 112, 648, 512},
    { 96, 664, 496},
    { 88, 672, 376},
    { 192, 624, 504},
    { 208, 712, 352},
    { 184, 768, 360},
    { 240, 816, 344},
    { 344, 928, 384},
    { 384, 912, 392},
    { 288, 792, 392},
    { 216, 760, 360},
    { 232, 768, 320},
    { 248, 600, 336},
    { 240, 632, 328},
    { 208, 648, 384},
    { 272, 632, 560},
    { 304, 744, 640},
    { 392, 736, 680},
    { 344, 832, 688},
    { 440, 904, 768},
    { 448, 656, 616},
    { 368, 528, 656},
    { 328, 680, 712},
    // 205 seconds
    { 296, 704, 712},
    { 328, 760, 736},
    { 272, 776, 608},
    { 224, 744, 600},
    { 176, 848, 656},
    { 152, 728, 528},
    { 96, 864, 496},
    { 80, 768, 480},
    { 80, 792, 448},
    { 32, 840, 472},
    { 40, 856, 480},
    { 32, 840, 448},
    { -8, 944, 480},
    { 8, 784, 344},
    { -8, 824, 320},
    { -16, 728, 272},
    { -64, 720, 400},
    { -104, 688, 408},
    { -88, 672, 424},
    { -176, 720, 640},
    { -168, 592, 744},
    { -200, 712, 720},
    { -232, 952, 656},
    { -216, 680, 728},
    { -288, 752, 536},
    // 206 seconds
    { -144, 616, 232},
    { -64, 696, 376},
    { 128, 872, 224},
    { 168, 1040, 256},
    { 360, 1000, 168},
    { 456, 1352, 208},
    { 480, 1304, 32},
    { 520, 832, -248},
    { 264, 800, 24},
    { 0, 1064, 200},
    { -88, 640, 480},
    { -288, 544, 704},
    { -160, 728, 736},
    { -296, 528, 784},
    { -264, 352, 704},
    { -288, 856, 736},
    { -328, 384, 792},
    { -352, 408, 1088},
    { -328, 520, 728},
    { -344, 424, 768},
    { -392, 744, 416},
    { -392, 544, 440},
    { -352, 928, 408},
    { -368, 576, 320},
    { -328, 768, 216},
    // 207 seconds
    { -352, 776, 408},
    { -368, 832, 552},
    { -368, 632, 456},
    { -376, 760, 328},
    { -392, 824, 392},
    { -384, 720, 392},
    { -384, 768, 352},
    { -400, 744, 416},
    { -400, 784, 400},
    { -384, 768, 456},
    { -384, 728, 472},
    { -352, 640, 488},
    { -336, 760, 504},
    { -312, 672, 496},
    { -312, 664, 520},
    { -368, 696, 552},
    { -408, 848, 456},
    { -408, 560, 616},
    { -456, 736, 448},
    { -488, 752, 464},
    { -464, 736, 600},
    { -448, 824, 504},
    { -496, 896, 400},
    { -512, 728, 256},
    { -656, 792, 272},
    // 208 seconds
    { -696, 696, 248},
    { -760, 952, 248},
    { -848, 920, 328},
    { -792, 1080, 160},
    { -552, 1104, 152},
    { -480, 888, 40},
    { -240, 992, -224},
    { -144, 808, -256},
    { 144, 656, -336},
    { 552, 776, -392},
    { 976, 416, -352},
    { 1048, 144, -152},
    { 936, 416, -264},
    { 904, 888, -400},
    { 544, 776, -296},
    { -8, 880, -24},
    { -416, 1080, 48},
    { -624, 1344, 152},
    { -664, 1176, 344},
    { -824, 1264, 336},
    { -512, 984, 304},
    { -416, 640, 536},
    { -336, 624, 552},
    { -224, 736, 808},
    { -272, 720, 664},
    // 209 seconds
    { -264, 848, 464},
    { -232, 736, 536},
    { -256, 560, 632},
    { -296, 768, 576},
    { -248, 680, 472},
    { -288, 432, 432},
    { -288, 784, 448},
    { -256, 608, 600},
    { -176, 632, 536},
    { -176, 616, 680},
    { -168, 752, 616},
    { -88, 824, 792},
    { -200, 744, 696},
    { -344, 520, 376},
    { -432, 464, 344},
    { -424, 520, 544},
    { -192, 600, 584},
    { 48, 896, 960},
    { -104, 1192, 576},
    { -80, 672, 784},
    { -56, 640, 544},
    { -112, 792, 536},
    { -16, 768, 752},
    { -80, 840, 824},
    { -160, 888, 1224},
    // 210 seconds
    { -232, 528, 1160},
    { -176, 504, 1008},
    { -176, 344, 840},
    { -112, 456, 280},
    { 8, 576, 64},
    { -16, 768, 24},
    { -216, 1128, 104},
    { -152, 768, 264},
    { -288, 936, 264},
    { -344, 896, 408},
    { -360, 744, 472},
    { -352, 832, 448},
    { -320, 816, 472},
    { -304, 688, 504},
    { -296, 792, 528},
    { -296, 704, 504},
    { -304, 704, 568},
    { -288, 792, 488},
    { -320, 728, 544},
    { -328, 696, 520},
    { -344, 776, 528},
    { -344, 760, 504},
    { -344, 744, 488},
    { -320, 720, 424},
    { -312, 760, 424},
    // 211 seconds
    { -344, 720, 480},
    { -352, 768, 520},
    { -400, 728, 600},
    { -392, 848, 408},
    { -432, 816, 456},
    { -296, 976, 272},
    { -352, 848, 416},
    { -464, 872, 312},
    { -440, 880, 216},
    { -448, 912, 96},
    { -392, 912, -24},
    { -280, 600, 16},
    { -440, 1016, -24},
    { -376, 824, -144},
    { -376, 928, 40},
    { -200, 1008, -352},
    { -376, 688, -80},
    { -512, 808, 144},
    { -632, 728, 320},
    { -568, 784, 0},
    { -664, 784, -40},
    { -528, 744, -80},
    { -448, 624, -48},
    { -560, 728, 80},
    { -376, 1024, -600},
    // 212 seconds
    { -176, 240, 344},
    { -176, 1008, 640},
    { -408, 784, 784},
    { -392, 664, 688},
    { -360, 632, 552},
    { -344, 672, 736},
    { -352, 800, 592},
    { -328, 888, 568},
    { -280, 960, 616},
    { -192, 960, 544},
    { -56, 864, 488},
    { 72, 680, 504},
    { 72, 616, 552},
    { -24, 640, 560},
    { -40, 640, 624},
    { -72, 664, 672},
    { -88, 720, 672},
    { -80, 680, 672},
    { -104, 664, 680},
    { -96, 696, 664},
    { -80, 728, 648},
    { -40, 728, 648},
    { 16, 720, 616},
    { 8, 696, 576},
    { 16, 696, 608},
    // 213 seconds
    { 16, 680, 584},
    { 0, 704, 600},
    { 0, 696, 608},
    { 0, 656, 632},
    { -24, 632, 664},
    { -56, 632, 696},
    { -72, 648, 752},
    { -40, 672, 712},
    { -56, 624, 696},
    { -40, 608, 696},
    { 0, 600, 640},
    { 8, 544, 560},
    { -88, 560, 488},
    { -216, 656, 488},
    { -272, 632, 496},
    { -288, 752, 600},
    { -216, 728, 624},
    { -200, 792, 728},
    { -208, 872, 752},
    { -200, 864, 800},
    { -144, 856, 752},
    { -104, 864, 712},
    { -72, 824, 624},
    { -200, 720, 704},
    { -344, 744, 736},
    // 214 seconds
    { -552, 896, 584},
    { -416, 784, 392},
    { -368, 688, 400},
    { -232, 640, 304},
    { -176, 544, 208},
    { -80, 408, 264},
    { 32, 712, 288},
    { -112, 600, 400},
    { -208, 792, 392},
    { -240, 856, 376},
    { -248, 1032, 464},
    { -16, 1016, 152},
    { 32, 1384, -144},
    { 8, 880, 24},
    { -312, 992, 64},
    { -96, 1136, -136},
    { -72, 912, 56},
    { -96, 1008, -32},
    { -152, 1008, -16},
    { -152, 888, -88},
    { -224, 888, -24},
    { 120, 936, 88},
    { -48, 928, 8},
    { -80, 960, -24},
    { -72, 976, -16},
    // 215 seconds
    { -104, 920, 16},
    { -192, 952, 16},
    { -104, 936, 40},
    { -128, 952, 24},
    { -128, 912, 40},
    { -248, 872, 40},
    { -176, 912, 56},
    { -184, 928, 48},
    { -224, 936, 32},
    { -200, 928, 56},
    { -160, 760, 96},
    { -232, 984, 32},
    { -168, 904, 8},
    { -136, 1048, 56},
    { -56, 928, 64},
    { -216, 816, 88},
    { -96, 832, 72},
    { -248, 736, 32},
    { -128, 1144, -32},
    { -32, 936, 152},
    { -40, 1016, -104},
    { 40, 1032, 24},
    { 40, 1048, 0},
    { 48, 1048, 64},
    { 56, 1000, 72},
    // 216 seconds
    { -24, 864, 80},
    { -168, 648, 104},
    { -288, 808, 88},
    { -56, 912, 16},
    { 128, 960, 56},
    { 48, 960, 56},
    { -32, 952, 32},
    { -48, 864, 0},
    { -96, 888, -16},
    { 16, 960, 32},
    { 88, 952, 8},
    { -64, 880, 32},
    { -16, 816, 80},
    { -176, 688, 32},
    { 400, 1152, 48},
    { 200, 1056, 16},
    { 40, 928, -8},
    { 112, 928, 0},
    { 136, 904, 56},
    { 104, 896, 40},
    { 64, 912, 48},
    { 144, 896, 96},
    { 72, 936, 40},
    { 48, 944, 72},
    { 16, 1008, 128},
    // 217 seconds
    { 80, 952, 96},
    { 88, 968, 120},
    { 72, 928, 176},
    { 64, 1040, 112},
    { 120, 928, 160},
    { 40, 888, 48},
    { 96, 808, 152},
    { 272, 792, 384},
    { 240, 840, 192},
    { 144, 816, 312},
    { 56, 856, 296},
    { 8, 896, 240},
    { -72, 1072, 88},
    { -88, 1016, 56},
    { 16, 1216, 176},
    { 16, 1360, 248},
    { 312, 872, 120},
    { 552, 896, 712},
    { 416, 1072, 800},
    { 264, 880, 848},
    { 184, 616, 840},
    { 112, 552, 808},
    { 96, 320, 672},
    { 0, -152, 768},
    { -40, 96, 800},
    // 218 seconds
    { -128, -128, 808},
    { -232, 80, 696},
    { -224, 144, 824},
    { -176, 88, 864},
    { -272, 320, 888},
    { -240, 184, 840},
    { -240, 136, 824},
    { -128, 232, 800},
    { -152, 216, 832},
    { -192, 88, 872},
    { -120, 456, 672},
    { -168, 648, 680},
    { -160, 776, 568},
    { -208, 760, 760},
    { -352, 176, 640},
    { -456, 832, 480},
    { -464, 1056, 664},
    { -360, 984, 1000},
    { -352, 1104, 928},
    { -224, 1248, 1152},
    { -272, 608, 1008},
    { -296, 736, 608},
    { -464, 704, 320},
    { -496, 600, -32},
    { -424, 456, -216},
    // 219 seconds
    { -504, 688, -376},
    { -544, 848, 184},
    { -568, 1568, 376},
    { -576, 376, 568},
    { -784, 616, 360},
    { -808, 400, 272},
    { -992, 656, 192},
    { -1024, 208, 176},
    { -784, 568, 152},
    { -584, 1176, -424},
    { -368, 1256, -488},
    { -8, 136, 176},
    { 496, 136, -160},
    { -184, 112, -72},
    { -24, -400, 1264},
    { -360, -40, 1648},
    { -328, 576, 1376},
    { -88, 720, 1104},
    { 344, 1384, 696},
    { 624, 1568, 648},
    { 472, 1480, 200},
    { 304, 1264, -224},
    { 208, 1128, -56},
    { 176, 1136, -72},
    { 88, 1280, -544},
    // 220 seconds
    { 0, 808, -112},
    { -264, 504, 224},
    { -424, 616, 416},
    { -360, 368, 552},
    { -384, 40, 840},
    { -440, 216, 1008},
    { -368, 472, 896},
    { -424, 480, 536},
    { -264, 424, 1048},
    { -208, 640, 1296},
    { -128, 616, 1176},
    { -144, 424, 1152},
    { -256, 392, 1080},
    { -240, 488, 960},
    { -192, 464, 960},
    { -176, 416, 1000},
    { -144, 400, 928},
    { -88, 320, 936},
    { -32, 344, 936},
    { 16, 304, 944},
    { 56, 216, 936},
    { 56, 168, 880},
    { 24, 160, 864},
    { -8, 176, 896},
    { -48, 208, 944},
    // 221 seconds
    { -56, 312, 960},
    { -40, 352, 976},
    { -8, 384, 912},
    { 8, 400, 824},
    { 8, 392, 848},
    { 8, 408, 832},
    { 8, 448, 840},
    { 0, 488, 840},
    { 16, 552, 800},
    { 24, 528, 888},
    { 32, 520, 920},
    { 96, 424, 872},
    { 112, 496, 776},
    { 184, 768, 416},
    { 32, 272, 952},
    { 48, 560, 584},
    { 144, 624, 584},
    { 64, 552, 816},
    { 40, 704, 784},
    { 32, 544, 808},
    { 96, 448, 696},
    { 72, 432, 680},
    { 120, 424, 736},
    { 112, 448, 840},
    { 128, 568, 920},
    // 222 seconds
    { 192, 392, 984},
    { 208, 400, 888},
    { 224, 376, 888},
    { 216, 312, 896},
    { 176, 272, 952},
    { 184, 280, 912},
    { 176, 320, 944},
    { 224, 336, 920},
    { 248, 264, 928},
    { 224, 224, 976},
    { 224, 336, 880},
    { 264, 232, 872},
    { 296, 96, 840},
    { 280, 120, 904},
    { 232, 176, 856},
    { 200, 224, 880},
    { 200, 152, 968},
    { 144, 104, 944},
    { 88, 144, 904},
    { 136, 112, 856},
    { 152, 112, 872},
    { 120, 144, 944},
    { 136, 216, 1048},
    { 208, 344, 1096},
    { 240, 272, 1096},
    // 223 seconds
    { 232, 264, 1064},
    { 224, 216, 1016},
    { 224, 192, 960},
    { 240, 128, 936},
    { 192, 144, 960},
    { 136, 80, 992},
    { 64, 144, 1112},
    { 120, 144, 1112},
    { 96, 168, 1128},
    { 144, 160, 1120},
    { 88, 232, 1080},
    { 144, 288, 1104},
    { 80, 272, 992},
    { 40, 216, 968},
    { 16, 280, 832},
    { -64, 216, 704},
    { -72, 128, 640},
    { -264, 400, 688},
    { -272, 592, 552},
    { -264, 680, 696},
    { -200, 584, 616},
    { -136, 592, 584},
    { -152, 496, 560},
    { -144, 528, 616},
    { -184, 512, 632},
    // 224 seconds
    { -232, 728, 576},
    { -320, 872, 632},
    { -288, 584, 648},
    { -240, 776, 456},
    { -304, 800, 368},
    { -304, 784, 296},
    { -344, 736, 200},
    { -400, 720, 168},
    { -448, 664, 280},
    { -472, 824, 160},
    { -408, 752, 168},
    { -440, 1024, 376},
    { -280, 1096, 440},
    { -200, 832, 448},
    { -248, 808, 392},
    { -280, 784, 392},
    { -312, 824, 384},
    { -272, 840, 296},
    { -224, 800, 296},
    { -256, 816, 336},
    { -264, 960, 352},
    { -272, 904, 360},
    { -304, 832, 344},
    { -328, 832, 296},
    { -344, 880, 336},
    // 225 seconds
    { -368, 880, 360},
    { -328, 784, 376},
    { -376, 752, 392},
    { -424, 808, 400},
    { -432, 800, 408},
    { -440, 720, 424},
    { -440, 760, 400},
    { -440, 776, 400},
    { -416, 760, 376},
    { -392, 776, 360},
    { -392, 800, 320},
    { -368, 792, 320},
    { -408, 712, 328},
    { -488, 696, 312},
    { -552, 696, 336},
    { -536, 728, 296},
    { -520, 784, 320},
    { -480, 824, 304},
    { -480, 720, 264},
    { -520, 704, 304},
    { -536, 744, 240},
    { -592, 768, 280},
    { -568, 744, 264},
    { -560, 800, 304},
    { -512, 864, 368},
    // 226 seconds
    { -480, 872, 376},
    { -472, 1000, 352},
    { -280, 800, 256},
    { -296, 832, 272},
    { -296, 816, 440},
    { -272, 632, 328},
    { -392, 704, 392},
    { -552, 624, 288},
    { -544, 736, 424},
    { -440, 576, 432},
    { -392, 640, 312},
    { -384, 640, 328},
    { -392, 664, 272},
    { -440, 688, 272},
    { -528, 744, 384},
    { -584, 808, 424},
    { -608, 800, 480},
    { -576, 792, 408},
    { -624, 704, 792},
    { -560, 888, 1152},
    { -264, 672, 760},
    { -352, 512, 816},
    { -328, 448, 744},
    { -296, 472, 544},
    { -344, 472, 528},
    // 227 seconds
    { -360, 528, 568},
    { -280, 600, 584},
    { -224, 568, 504},
    { -232, 616, 488},
    { -200, 664, 456},
    { -256, 720, 464},
    { -264, 824, 520},
    { -288, 1032, 504},
    { -264, 1328, 728},
    { 168, 824, 536},
    { -32, 752, 464},
    { 112, 376, 464},
    { -8, 528, 768},
    { 208, 864, 704},
    { 104, 344, 464},
    { 48, 200, 360},
    { -32, 136, 936},
    { -240, 408, 920},
    { -232, 216, 1152},
    { -248, 240, 1448},
    { -120, 568, 1424},
    { -112, 408, 1848},
    { 136, 336, 1616},
    { -56, 464, 1568},
    { -384, 712, 1608},
    // 228 seconds
    { -176, 704, 1584},
    { -312, 848, 1480},
    { -384, 600, 1080},
    { -464, 624, 736},
    { -232, 480, 488},
    { 80, 216, 288},
    { 176, 296, -32},
    { 592, -40, -8},
    { 832, -80, -512},
    { 1304, -456, -1224},
    { 992, -176, -1552},
    { 1104, -152, -1400},
    { 1064, 208, -1368},
    { 848, -184, -784},
    { 680, -64, -344},
    { 520, -160, -56},
    { 496, -120, 152},
    { 608, -344, 264},
    { 600, 32, 312},
    { 904, 264, 736},
    { 808, 536, 1024},
    { 1088, 1416, 1088},
    { 760, 1176, 1128},
    { 1376, 1432, 1496},
    { 1720, 1336, 1744},
    // 229 seconds
    { 1208, 1456, 1480},
    { 712, 1184, 1680},
    { 496, 888, 1296},
    { 320, 936, 784},
    { 448, 632, 560},
    { 1040, 440, 408},
    { 1032, 200, 536},
    { 1240, 344, 200},
    { 1064, -16, -312},
    { 1088, 432, -40},
    { 1120, 128, -48},
    { 1752, 144, -112},
    { 952, 560, -152},
    { 1128, 160, 24},
    { 784, 136, 168},
    { 568, 232, 88},
    { 584, 8, 88},
    { 768, 144, 232},
    { 984, 128, 688},
    { 1256, 312, 568},
    { 1000, 208, 816},
    { 928, 352, 936},
    { 824, 272, 872},
    { 1192, 480, 664},
    { 944, 216, 688},
    // 230 seconds
    { 1032, 408, 536},
    { 1088, 352, 640},
    { 744, 248, 560},
    { 560, 200, 344},
    { 696, 192, 592},
    { 976, 256, 648},
    { 1144, 224, 776},
    { 1136, 376, 872},
    { 1056, 528, 856},
    { 896, 504, 736},
    { 776, 696, 920},
    { 264, 528, 544},
    { 112, 848, 144},
    { 144, 880, 136},
    { 56, 496, 376},
    { -128, 472, 296},
    { -336, 424, 232},
    { -440, 736, 248},
    { -728, 760, 168},
    { -808, 776, 528},
    { -752, 1056, 544},
    { -680, 928, 704},
    { -800, 744, 456},
    { -672, 960, 480},
    { -760, 488, 648},
    // 231 seconds
    { -664, 584, 560},
    { -496, 424, 560},
    { -296, 240, 528},
    { -336, 616, 232},
    { -456, 440, 128},
    { -344, 528, -88},
    { -296, 448, -128},
    { -144, 232, -16},
    { 256, 280, 144},
    { 752, 224, 128},
    { 1536, -104, 560},
    { 2104, -384, 1664},
    { 2176, 960, 952},
    { 3008, 256, 552},
    { 2800, -72, 672},
    { 2176, -16, 1040},
    { 1872, -256, 912},
    { 1792, 8, 776},
    { 1344, -232, 1024},
    { 1112, -248, 928},
    { 936, -120, 1032},
    { 544, -32, 936},
    { 496, 152, 920},
    { 424, 312, 1024},
    { 536, 328, 704},
    // 232 seconds
    { 832, 192, 744},
    { 1416, 392, 920},
    { 1760, 400, 824},
    { 1800, 408, 600},
    { 1800, 368, 672},
    { 1840, 440, 688},
    { 1904, 320, 680},
    { 1832, 152, 520},
    { 1384, 256, 280},
    { 1712, -504, -1136},
    { 1144, -864, -496},
    { 1408, 496, -704},
    { 1624, 552, -144},
    { 1816, 416, 280},
    { 1688, -128, 416},
    { 1832, -48, 712},
    { 1576, 176, 1024},
    { 1688, 320, 1072},
    { 1712, 376, 928},
    { 1224, 128, 1104},
    { 760, -32, 1392},
    { 592, -88, 1120},
    { 712, -56, 1128},
    { 768, 96, 1000},
    { 1040, 200, 1024},
    // 233 seconds
    { 1608, 336, 1080},
    { 1832, 384, 880},
    { 1656, 392, 792},
    { 1800, 264, 816},
    { 1840, 184, 680},
    { 1912, 344, 480},
    { 1744, 128, 472},
    { 1360, 104, 368},
    { 1360, -464, -848},
    { 776, -656, -664},
    { 1440, 368, -752},
    { 1344, 392, 40},
    { 1848, 552, 360},
    { 1912, 96, 192},
    { 2208, 392, 1008},
    { 1792, 392, 1240},
    { 1792, 376, 752},
    { 1776, 616, 792},
    { 1288, 296, 1200},
    { 848, 256, 1232},
    { 512, 328, 1256},
    { 648, 256, 1136},
    { 512, 256, 864},
    { 920, 320, 912},
    { 1432, 416, 992},
    // 234 seconds
    { 1720, 376, 832},
    { 1648, 272, 648},
    { 1632, 232, 576},
    { 1800, 296, 576},
    { 2016, 224, 608},
    { 1640, 136, 448},
    { 1696, 368, 168},
    { 1072, -760, -976},
    { 1336, -312, -560},
    { 1056, 408, -320},
    { 1224, 512, 72},
    { 1608, 144, 280},
    { 1400, -184, 344},
    { 1632, 104, 584},
    { 1704, 184, 952},
    { 1680, 416, 1216},
    { 1616, 504, 816},
    { 1464, 312, 912},
    { 936, 368, 1432},
    { 568, 384, 1264},
    { 712, 336, 1384},
    { 752, 256, 992},
    { 1088, 344, 896},
    { 1552, 408, 912},
    { 1736, 384, 760},
    // 235 seconds
    { 1648, 296, 600},
    { 1600, 168, 632},
    { 1656, 224, 600},
    { 1720, 48, 544},
    { 1536, 72, 416},
    { 1272, 184, 336},
    { 1208, -496, -952},
    { 752, -48, -744},
    { 1024, 152, -344},
    { 1312, 480, 128},
    { 1768, 440, 200},
    { 1568, -48, 360},
    { 1656, -8, 584},
    { 1672, 248, 864},
    { 1648, 400, 1008},
    { 1632, 480, 696},
    { 1344, 512, 1176},
    { 816, 624, 1504},
    { 576, 640, 1120},
    { 624, 488, 1240},
    { 912, 464, 1072},
    { 1056, 336, 816},
    { 1432, 352, 808},
    { 1920, 344, 872},
    { 1808, 160, 736},
    // 236 seconds
    { 1600, 152, 560},
    { 1528, 200, 488},
    { 1560, 104, 512},
    { 1408, 112, 400},
    { 1336, 232, 296},
    { 1304, 184, -48},
    { 560, -352, -688},
    { 1072, 0, -584},
    { 1064, 408, -128},
    { 1392, 416, 200},
    { 1512, 248, 280},
    { 1592, -88, 424},
    { 1784, 168, 632},
    { 1912, 344, 1024},
    { 1792, 632, 1112},
    { 1744, 496, 864},
    { 1048, 760, 1608},
    { 392, 1176, 1384},
    { 584, 600, 1368},
    { 848, 472, 1232},
    { 1016, 344, 864},
    { 1432, 272, 760},
    { 1928, 328, 840},
    { 1960, 104, 864},
    { 1736, 80, 608},
    // 237 seconds
    { 1552, 104, 504},
    { 1496, 192, 464},
    { 1416, 152, 424},
    { 1296, 152, 328},
    { 1184, 88, 120},
    { 632, -448, -752},
    { 1080, 120, -768},
    { 1008, 440, -304},
    { 1432, 528, 96},
    { 1504, 272, 216},
    { 1528, -64, 312},
    { 1712, -8, 488},
    { 1840, 240, 872},
    { 1832, 448, 1080},
    { 1976, 376, 784},
    { 1768, 376, 1144},
    { 968, 560, 1552},
    { 608, 760, 1352},
    { 696, 552, 1496},
    { 680, 312, 952},
    { 1144, 296, 824},
    { 1616, 280, 856},
    { 1720, 216, 736},
    { 1592, 112, 584},
    { 1552, 120, 528},
    // 238 seconds
    { 1664, 112, 552},
    { 1872, 104, 512},
    { 1600, 56, 416},
    { 1416, 112, 256},
    { 872, -464, -816},
    { 552, 392, -608},
    { 928, -64, -272},
    { 1096, 72, 48},
    { 1328, 392, 136},
    { 1312, 208, 320},
    { 1368, -24, 392},
    { 1544, 64, 552},
    { 1792, 216, 768},
    { 1888, 496, 872},
    { 1720, 416, 976},
    { 1312, 432, 1232},
    { 864, 688, 1256},
    { 672, 904, 1368},
    { 840, 504, 1160},
    { 984, 304, 840},
    { 1392, 360, 792},
    { 1720, 336, 840},
    { 1592, 168, 624},
    { 1512, 152, 488},
    { 1648, 112, 552},
    // 239 seconds
    { 1864, 64, 528},
    { 1632, 32, 416},
    { 1392, 200, 328},
    { 1336, 152, -88},
    { 856, -328, -512},
    { 968, 0, -448},
    { 968, 360, -48},
    { 1112, 232, 224},
    { 1208, 24, 272},
    { 1400, 40, 424},
    { 1664, 152, 664},
    { 1720, 160, 1104},
    { 1648, 448, 1104},
    { 1760, 248, 592},
    { 1312, 312, 1136},
    { 824, 384, 1232},
    { 624, 464, 1304},
    { 832, 408, 1352},
    { 808, 768, 1512},
    { 1568, 1056, 1648},
    { 2352, 800, 1888},
    { 2624, 760, 1544},
    { 2920, 648, 1376},
    { 3112, 392, 1352},
    { 3016, 496, 1168},
    // 240 seconds
    // elapsed: 4 minutes
    { 2288, 424, 968},
    { 1568, 672, 608},
    { 1008, 136, 232},
    { 888, -80, -288},
    { -272, -216, -72},
    { 520, 616, -480},
    { 88, 472, -448},
    { 432, 256, -56},
    { 664, 456, -296},
    { 528, 328, 192},
    { 352, -1048, -272},
    { 472, -184, -160},
    { 352, 256, 120},
    { -120, 528, 1064},
    { -784, 1408, 2656},
    { -224, 1192, 2760},
    { -688, 1400, 3848},
    { -1072, 880, 2720},
    { -1288, 1184, 1880},
    { -1120, 760, 1136},
    { -800, 248, 1072},
    { -392, 64, 808},
    { -192, 320, 424},
    { -128, 168, 336},
    { -80, 120, 320},
    // 241 seconds
    { 208, 264, 496},
    { 792, 304, 504},
    { 1312, -32, 520},
    { 1176, 168, 376},
    { 1680, 56, 576},
    { 1816, 232, 592},
    { 1808, 528, 552},
    { 1736, 240, 632},
    { 1296, -104, 592},
    { 1136, 104, 560},
    { 1104, -64, 640},
    { 1112, -40, 688},
    { 1064, 56, 832},
    { 912, 112, 896},
    { 744, 248, 1040},
    { 792, 136, 976},
    { 912, -24, 1016},
    { 984, 136, 968},
    { 1200, 96, 760},
    { 1560, 200, 832},
    { 1912, 104, 896},
    { 1632, -40, 600},
    { 1536, -16, 560},
    { 1472, 40, 592},
    { 1456, 8, 472},
    // 242 seconds
    { 1536, -48, 416},
    { 1400, -104, 384},
    { 1344, -248, -720},
    { 744, -88, -872},
    { 1104, 360, -312},
    { 1296, 400, 120},
    { 1400, -8, 312},
    { 1480, -48, 288},
    { 1608, 32, 472},
    { 1728, 136, 768},
    { 1816, 64, 1056},
    { 1896, 320, 920},
    { 1728, 232, 968},
    { 1128, 216, 1352},
    { 568, 552, 1448},
    { 568, 288, 1488},
    { 776, 200, 1184},
    { 992, 160, 888},
    { 1392, 192, 888},
    { 1832, 256, 872},
    { 1688, 128, 648},
    { 1664, 168, 520},
    { 1776, -48, 624},
    { 1760, -192, 552},
    { 1528, 152, 320},
    // 243 seconds
    { 1456, 360, 200},
    { 944, -264, -584},
    { 736, 296, -632},
    { 888, 104, -432},
    { 1192, 432, 32},
    { 1312, 328, 208},
    { 1360, -24, 272},
    { 1464, -24, 464},
    { 1640, 48, 672},
    { 1824, 32, 1056},
    { 1808, 264, 1256},
    { 1536, 40, 792},
    { 1032, 48, 1088},
    { 776, 80, 1368},
    { 648, -48, 1256},
    { 832, -8, 1280},
    { 920, 16, 928},
    { 1224, 104, 888},
    { 1664, 160, 920},
    { 1656, 80, 704},
    { 1600, -8, 592},
    { 1608, -152, 584},
    { 1504, 16, 496},
    { 1552, -40, 472},
    { 1480, -72, 376},
    // 244 seconds
    { 1360, -112, -224},
    { 648, -184, -672},
    { 1304, -16, -600},
    { 1256, 264, 32},
    { 1656, 312, 368},
    { 1744, -32, 336},
    { 1768, -24, 464},
    { 1832, 168, 808},
    { 1304, 72, 1256},
    { 1072, 152, 448},
    { 1464, 160, 408},
    { 1424, -264, 1080},
    { 1008, -552, 1456},
    { 560, -776, 1352},
    { 968, -128, 1008},
    { 736, -408, 1048},
    { 968, -296, 848},
    { 1312, -192, 864},
    { 1496, 32, 840},
    { 1304, 168, 624},
    { 1224, 232, 592},
    { 1400, 304, 664},
    { 1720, -64, 736},
    { 1520, -208, 632},
    { 1352, -8, 320},
    // 245 seconds
    { 1240, -104, -192},
    { 448, -328, -400},
    { 1296, 296, -584},
    { 1464, 1120, -64},
    { 1512, 608, 272},
    { 1568, -112, 336},
    { 1560, -248, 408},
    { 1736, -96, 712},
    { 1808, 40, 1224},
    { 1776, 336, 1056},
    { 1632, 352, 848},
    { 1016, 256, 1424},
    { 264, 400, 1416},
    { 344, 224, 1288},
    { 888, -24, 1328},
    { 1240, 152, 1144},
    { 1392, 240, 800},
    { 1816, 312, 832},
    { 2232, 160, 1024},
    { 2168, -104, 840},
    { 1904, -24, 616},
    { 1808, 48, 552},
    { 1832, 72, 568},
    { 1600, 24, 440},
    { 1448, 136, 248},
    // 246 seconds
    { 1248, -392, -760},
    { 560, 208, -800},
    { 888, 16, -608},
    { 1104, 296, 40},
    { 1480, 376, 216},
    { 1800, 64, 320},
    { 2112, 80, 600},
    { 2240, 248, 824},
    { 2032, 360, 1368},
    { 1936, 304, 576},
    { 2056, 368, 752},
    { 1320, 424, 1736},
    { 760, 776, 1296},
    { 576, 496, 1464},
    { 632, 296, 1064},
    { 736, 256, 752},
    { 1176, 256, 824},
    { 1648, 200, 840},
    { 1704, 104, 664},
    { 1648, 72, 568},
    { 1728, 80, 584},
    { 1832, -40, 560},
    { 1720, 32, 400},
    { 1648, 160, 384},
    { 1520, -96, -368},
    // 247 seconds
    { 944, -160, -664},
    { 984, 64, -688},
    { 1184, 376, -160},
    { 1480, 304, 96},
    { 1512, 8, 224},
    { 1552, -128, 368},
    { 1712, 152, 616},
    { 1736, 184, 864},
    { 1600, 400, 1144},
    { 1560, 200, 680},
    { 1432, 264, 1000},
    { 920, 392, 1488},
    { 680, 496, 1168},
    { 808, 432, 1400},
    { 768, 176, 760},
    { 1112, 304, 696},
    { 1616, 288, 856},
    { 1712, 160, 688},
    { 1680, 80, 528},
    { 1616, 32, 552},
    { 1528, 0, 496},
    { 1624, 8, 440},
    { 1520, 56, 376},
    { 1408, 88, 304},
    { 1168, -328, -856},
    // 248 seconds
    { 1112, -144, -792},
    { 1008, 320, -408},
    { 1528, 392, 152},
    { 1480, 168, 248},
    { 1632, -184, 328},
    { 1792, -88, 648},
    { 1888, 136, 1096},
    { 1792, 336, 1176},
    { 1880, 312, 672},
    { 1416, 168, 1352},
    { 720, 344, 1544},
    { 480, 272, 1384},
    { 544, 240, 1128},
    { 744, 120, 928},
    { 1168, 96, 904},
    { 1720, 176, 848},
    { 1696, 144, 648},
    { 1576, 112, 544},
    { 1608, 88, 536},
    { 1744, 8, 528},
    { 1688, 32, 416},
    { 1584, 192, 368},
    { 1408, -256, -752},
    { 664, 256, -744},
    { 1208, -128, -712},
    // 249 seconds
    { 1256, 240, -144},
    { 1640, 576, 128},
    { 1584, 112, 400},
    { 1624, -264, 456},
    { 1816, -64, 616},
    { 1880, 152, 1112},
    { 1592, 416, 1144},
    { 1464, 248, 744},
    { 976, 144, 1488},
    { 528, 352, 1512},
    { 512, 56, 1288},
    { 888, 112, 1336},
    { 1184, 56, 1024},
    { 1656, 144, 952},
    { 2120, 240, 912},
    { 1960, 152, 680},
    { 1832, 80, 640},
    { 1768, 88, 544},
    { 1688, 24, 456},
    { 1576, 8, 392},
    { 1376, 32, 200},
    { 1184, -208, -504},
    { 632, 112, -800},
    { 1136, -144, -856},
    { 1288, 304, -136},
    // 250 seconds
    { 1496, 456, 248},
    { 1616, 168, 384},
    { 1744, -128, 424},
    { 1912, 32, 720},
    { 1896, 192, 1144},
    { 1800, 160, 832},
    { 1688, 256, 952},
    { 1200, 200, 1608},
    { 664, 368, 1496},
    { 608, 136, 1160},
    { 848, 152, 1440},
    { 1008, 112, 1064},
    { 1368, 192, 888},
    { 1864, 216, 856},
    { 1776, 168, 672},
    { 1616, 120, 592},
    { 1696, 104, 624},
    { 1696, -48, 528},
    { 1616, -48, 424},
    { 1520, -32, 360},
    { 1232, -32, 112},
    { 904, -72, -616},
    { 1048, -176, -632},
    { 984, 208, -280},
    { 1288, 328, 120},
    // 251 seconds
    { 1288, 88, 240},
    { 1496, 0, 328},
    { 1704, 168, 536},
    { 1880, 216, 760},
    { 1880, 208, 1008},
    { 1888, 264, 944},
    { 1664, 416, 960},
    { 1128, 480, 1496},
    { 688, 616, 1440},
    { 736, 512, 1376},
    { 688, 320, 1032},
    { 1128, 328, 968},
    { 1696, 224, 944},
    { 1696, 144, 712},
    { 1616, 96, 568},
    { 1616, 72, 560},
    { 1680, 40, 544},
    { 1728, 8, 464},
    { 1440, 48, 424},
    { 1456, 200, 240},
    { 1208, -264, -944},
    { 1088, -440, -648},
    { 1104, 448, -368},
    { 1184, 192, 32},
    { 1280, 112, 200},
    // 252 seconds
    { 1344, -200, 280},
    { 1560, -32, 504},
    { 1840, 40, 832},
    { 1880, 224, 1096},
    { 1776, 256, 960},
    { 1544, 296, 944},
    { 1040, 256, 1528},
    { 696, 376, 1480},
    { 840, 200, 1328},
    { 824, 208, 1072},
    { 1112, 232, 920},
    { 1520, 176, 872},
    { 1488, 128, 664},
    { 1440, 88, 560},
    { 1552, 32, 608},
    { 1672, 24, 576},
    { 1720, -8, 464},
    { 1560, 48, 392},
    { 1272, 104, 128},
    { 824, -56, -640},
    { 1160, 0, -664},
    { 1104, 272, -224},
    { 1528, 440, 0},
    { 1328, 104, 184},
    { 1344, -40, 280},
    // 253 seconds
    { 1432, 24, 456},
    { 1680, 168, 688},
    { 1824, 184, 848},
    { 1736, 368, 1184},
    { 1448, 320, 1096},
    { 880, 536, 1776},
    { 552, 576, 1528},
    { 896, 160, 1592},
    { 1040, 80, 1032},
    { 1440, 96, 888},
    { 2032, 104, 992},
    { 1984, 120, 720},
    { 1704, 24, 552},
    { 1584, -24, 560},
    { 1536, 32, 472},
    { 1472, -16, 488},
    { 1600, 144, 432},
    { 1296, 288, 240},
    { 1016, -16, -744},
    { 744, 208, -720},
    { 672, 160, -200},
    { 1296, 464, 80},
    { 1352, 160, 288},
    { 1432, 144, 496},
    { 1528, 48, 536},
    // 254 seconds
    { 1720, 160, 696},
    { 1896, 56, 840},
    { 2032, 64, 1104},
    { 1872, 112, 1032},
    { 1416, 120, 1344},
    { 872, 384, 1520},
    { 512, 256, 1376},
    { 528, 256, 1320},
    { 848, 96, 1048},
    { 1248, 120, 952},
    { 1832, 160, 976},
    { 1784, 48, 760},
    { 1600, 120, 592},
    { 1592, -16, 624},
    { 1656, 32, 528},
    { 1688, -32, 480},
    { 1632, 72, 400},
    { 1392, 96, 144},
    { 928, -72, -776},
    { 984, -32, -800},
    { 984, 224, -232},
    { 1504, 432, 136},
    { 1424, 80, 232},
    { 1568, -40, 312},
    { 1640, 40, 560},
    // 255 seconds
    { 1792, 80, 792},
    { 1976, 264, 1000},
    { 1832, 272, 1056},
    { 1536, 248, 1088},
    { 888, 496, 1376},
    { 480, 560, 1456},
    { 760, 328, 1392},
    { 768, 224, 1032},
    { 1024, 248, 824},
    { 1560, 240, 936},
    { 1976, 88, 872},
    { 1784, 88, 624},
    { 1656, 104, 568},
    { 1664, 64, 560},
    { 1664, 8, 448},
    { 1568, 48, 376},
    { 1472, 112, 224},
    { 1024, -216, -608},
    { 936, 336, -800},
    { 880, -216, -448},
    { 1344, 464, -48},
    { 1488, 304, 240},
    { 1552, -64, 344},
    { 1696, -48, 512},
    { 1856, 144, 712},
    // 256 seconds
    { 2000, 248, 1008},
    { 1912, 208, 1064},
    { 1656, 216, 1040},
    { 1000, 256, 1528},
    { 600, 480, 1456},
    { 672, 208, 1432},
    { 880, 208, 1248},
    { 1048, 176, 944},
    { 1456, 184, 912},
    { 1896, 144, 864},
    { 1792, 48, 664},
    { 1672, 88, 560},
    { 1688, 64, 560},
    { 1856, -32, 560},
    { 1640, -104, 456},
    { 1480, 88, 376},
    { 1368, 8, -256},
    { 664, -56, -904},
    { 1024, -128, -688},
    { 1192, 360, -168},
    { 1536, 256, 176},
    { 1480, -56, 288},
    { 1584, -128, 392},
    { 1872, 88, 664},
    { 1936, 272, 976},
    // 257 seconds
    { 1816, 360, 1088},
    { 1744, 384, 744},
    { 1400, 320, 1408},
    { 864, 768, 1408},
    { 584, 640, 1304},
    { 896, 456, 1328},
    { 920, 296, 840},
    { 1272, 376, 752},
    { 1704, 320, 832},
    { 1856, 136, 736},
    { 1728, -8, 600},
    { 1632, 16, 608},
    { 1600, 64, 512},
    { 1568, -56, 464},
    { 1512, 0, 400},
    { 1392, 16, 360},
    { 1200, -280, -880},
    { 848, -72, -824},
    { 936, 144, -304},
    { 1312, 256, 128},
    { 1472, 48, 224},
    { 1696, -56, 376},
    { 1808, 104, 632},
    { 1880, 184, 864},
    { 1752, 352, 1096},
    // 258 seconds
    { 1744, 296, 704},
    { 1560, 496, 1112},
    { 944, 664, 1440},
    { 616, 744, 1272},
    { 704, 360, 1256},
    { 896, 312, 960},
    { 984, 288, 712},
    { 1440, 336, 784},
    { 1856, 176, 848},
    { 1736, 0, 648},
    { 1520, 8, 536},
    { 1496, 56, 512},
    { 1480, 96, 464},
    { 1512, -48, 416},
    { 1264, -24, 360},
    { 1208, 40, 24},
    { 696, -112, -592},
    { 1168, 16, -592},
    { 968, 256, -96},
    { 1440, 272, 208},
    { 1432, 64, 288},
    { 1464, 16, 408},
    { 1544, 104, 536},
    { 1680, 104, 744},
    { 1768, 232, 1040},
    // 259 seconds
    { 1816, 184, 880},
    { 1576, 184, 976},
    { 984, 232, 1280},
    { 704, 408, 1240},
    { 608, 264, 1440},
    { 592, 168, 904},
    { 920, 168, 872},
    { 1408, 176, 904},
    { 1664, 136, 792},
    { 1528, 48, 576},
    { 1592, 96, 560},
    { 1672, 16, 584},
    { 1712, -32, 504},
    { 1408, 0, 384},
    { 1368, 112, 344},
    { 1248, -144, -928},
    { 1040, -152, -752},
    { 968, 112, -320},
    { 1424, 272, -16},
    { 1600, 96, 224},
    { 1616, -32, 400},
    { 1712, 48, 592},
    { 1840, 144, 856},
    { 1752, 296, 1144},
    { 1640, 224, 840},
    // 260 seconds
    { 1336, 368, 1208},
    { 744, 656, 1448},
    { 512, 504, 1400},
    { 712, 384, 1424},
    { 1016, 176, 1064},
    { 1344, 240, 864},
    { 1912, 248, 920},
    { 2176, 32, 848},
    { 1792, 0, 616},
    { 1600, 56, 520},
    { 1704, 120, 512},
    { 1632, -16, 440},
    { 1384, 16, 344},
    { 1256, 40, 32},
    { 784, -288, -744},
    { 1032, 88, -984},
    { 936, 0, -272},
    { 1424, 384, 144},
    { 1576, 184, 256},
    { 1656, 48, 424},
    { 1704, 0, 568},
    { 1744, 112, 744},
    { 1848, 216, 824},
    { 1888, 360, 880},
    { 1576, 352, 1080},
    // 261 seconds
    { 1056, 432, 1424},
    { 656, 856, 1304},
    { 672, 576, 1336},
    { 808, 288, 1112},
    { 1056, 264, 840},
    { 1512, 248, 880},
    { 1928, 160, 904},
    { 1816, 40, 664},
    { 1616, 56, 560},
    { 1600, 80, 568},
    { 1584, -16, 520},
    { 1600, -8, 448},
    { 1480, -64, 400},
    { 1200, -208, -216},
    { 624, 72, -584},
    { 976, -40, -752},
    { 1056, 232, -128},
    { 1536, 216, 224},
    { 1496, 16, 336},
    { 1600, -40, 432},
    { 1680, 112, 616},
    { 1736, 32, 872},
    { 1832, 272, 952},
    { 1808, 296, 800},
    { 1480, 312, 1128},
    // 262 seconds
    { 928, 440, 1312},
    { 640, 552, 1160},
    { 688, 520, 1376},
    { 800, 304, 1008},
    { 1112, 280, 896},
    { 1664, 248, 944},
    { 1896, 96, 816},
    { 1728, 32, 600},
    { 1624, 112, 584},
    { 1672, 96, 536},
    { 1664, -8, 496},
    { 1608, -112, 456},
    { 1392, -64, 400},
    { 1120, 0, -312},
    { 640, -32, -736},
    { 896, -104, -656},
    { 1208, 312, -88},
    { 1480, 224, 184},
    { 1520, 16, 336},
    { 1552, -128, 480},
    { 1720, 64, 648},
    { 1928, 160, 936},
    { 1912, 360, 1064},
    { 1672, 296, 976},
    { 1144, 408, 1296},
    // 263 seconds
    { 656, 808, 1400},
    { 568, 464, 1320},
    { 864, 400, 1424},
    { 1048, 208, 912},
    { 1368, 272, 808},
    { 1984, 296, 952},
    { 2032, 88, 800},
    { 1696, 80, 552},
    { 1552, 0, 560},
    { 1480, 8, 520},
    { 1496, 32, 440},
    { 1408, -104, 408},
    { 1248, -88, 368},
    { 1040, -152, -336},
    { 808, -40, -632},
    { 696, 48, -472},
    { 1184, 320, -24},
    { 1472, 160, 240},
    { 1552, -16, 368},
    { 1688, 24, 496},
    { 1824, 136, 688},
    { 1920, 120, 976},
    { 1976, 296, 992},
    { 1888, 328, 944},
    { 1328, 312, 1368},
    // 264 seconds
    { 760, 792, 1392},
    { 512, 552, 1416},
    { 800, 392, 1400},
    { 952, 256, 976},
    { 1280, 256, 832},
    { 1864, 256, 944},
    { 1944, 72, 856},
    { 1696, -16, 576},
    { 1624, 40, 536},
    { 1664, 72, 552},
    { 1584, -16, 440},
    { 1408, -96, 368},
    { 1312, -40, 224},
    { 920, -248, -584},
    { 824, 224, -656},
    { 800, -200, -272},
    { 1272, 288, 104},
    { 1432, 224, 304},
    { 1584, -8, 440},
    { 1728, 48, 552},
    { 1832, 88, 728},
    { 1944, 272, 1008},
    { 1904, 224, 928},
    { 1672, 424, 1032},
    { 1096, 672, 1488},
    // 265 seconds
    { 560, 1000, 1424},
    { 600, 576, 1288},
    { 800, 408, 1112},
    { 960, 296, 784},
    { 1504, 352, 824},
    { 2072, 160, 960},
    { 1904, -8, 680},
    { 1624, 32, 528},
    { 1592, 128, 544},
    { 1640, 40, 488},
    { 1488, -80, 400},
    { 1384, 8, 344},
    { 1256, -152, -440},
    { 632, -64, -600},
    { 976, -112, -488},
    { 1120, 264, -72},
    { 1392, 104, 176},
    { 1456, -80, 312},
    { 1568, 152, 560},
    { 1664, 160, 648},
    { 1792, 128, 856},
    { 1856, 152, 984},
    { 1808, 520, 992},
    { 1352, 40, 1656},
    { 688, 552, 2040},
    // 266 seconds
    { 688, 320, 1032},
    { 688, 176, 1232},
    { 752, 32, 1032},
    { 1144, 0, 920},
    { 1648, 80, 920},
    { 1632, -96, 792},
    { 1568, 24, 648},
    { 1592, 80, 520},
    { 1688, 24, 464},
    { 1584, -48, 416},
    { 1448, 40, 368},
    { 1376, -168, -296},
    { 888, -16, -640},
    { 1080, -176, -384},
    { 1240, 320, 48},
    { 1440, 320, 240},
    { 1400, 32, 360},
    { 1296, 56, 400},
    { 1384, 216, 496},
    { 1552, 184, 704},
    { 1632, 304, 800},
    { 1664, 352, 960},
    { 1240, 416, 944},
    { 680, 624, 1136},
    { 464, 856, 1312},
    // 267 seconds
    { 664, 472, 1464},
    { 1072, 256, 1096},
    { 1712, 328, 1224},
    { 2440, 80, 1232},
    { 2312, 72, 944},
    { 2080, -24, 1032},
    { 2112, 24, 752},
    { 1848, -16, 648},
    { 1728, 272, 752},
    { 1224, 384, 736},
    { 720, 696, 648},
    { 320, 664, 568},
    { 368, 416, 592},
    { -24, 328, 488},
    { 216, -24, 432},
    { 184, -96, 560},
    { -24, 112, 400},
    { -176, 120, 104},
    { -240, -144, -40},
    { -640, 168, 432},
    { -1016, 104, 616},
    { -864, -184, -480},
    { -872, -248, -344},
    { -88, 344, -1104},
    { -96, -128, -1344},
    // 268 seconds
    { -136, 144, -1488},
    { -232, 168, -1104},
    { -256, 104, -960},
    { -544, 424, -952},
    { -480, 712, -672},
    { -176, 672, -664},
    { -16, 472, -760},
    { 8, 456, -816},
    { 24, 504, -624},
    { 104, 600, -656},
    { 240, 624, -592},
    { 536, 552, -656},
    { 552, 400, -528},
    { 280, 1048, -256},
    { 560, 968, -296},
    { 544, 1232, -520},
    { 392, 1192, -312},
    { 360, 1144, -456},
    { 256, 832, -360},
    { 400, 896, -352},
    { 416, 792, -504},
    { 480, 800, 192},
    { 1128, 104, -344},
    { 584, 728, -240},
    { 720, 744, -304},
    // 269 seconds
    { 648, 1208, -336},
    { 272, 1216, -296},
    { 304, 608, -312},
    { 192, 640, -560},
    { 80, 488, -800},
    { 208, -656, -1224},
    { 760, 288, -824},
    { 256, -328, -760},
    { 344, -584, -872},
    { 1520, -680, -320},
    { 480, -248, -792},
    { 176, -352, -936},
    { 208, -280, -1200},
    { 264, -560, -1072},
    { 0, -264, -992},
    { 0, 200, -1120},
    { -32, 264, -1000},
    { -144, -88, -968},
    { -80, -272, -864},
    { -208, -320, -736},
    { -192, -432, -776},
    { -248, -448, -808},
    { -248, -504, -872},
    { -256, -600, -880},
    { -256, -608, -960},
    // 270 seconds
    { -216, -576, -1048},
    { -296, -680, -1112},
    { -96, -488, -1184},
    { -248, -488, -1008},
    { -280, -304, -976},
    { -184, -376, -984},
    { -160, -408, -808},
    { -160, -464, -712},
    { -128, -384, -688},
    { -72, -456, -624},
    { -80, -416, -552},
    { 24, -352, -624},
    { 168, -496, -576},
    { 288, -352, -432},
    { 712, -208, -480},
    { 1168, 136, -440},
    { 1528, 232, -496},
    { 1848, 128, -440},
    { 1808, 264, -288},
    { 1512, 400, -224},
    { 1504, 408, -344},
    { 1512, 328, -560},
    { 1472, 544, -752},
    { 1208, 208, -824},
    { 984, 152, -896},
    // 271 seconds
    { 968, 376, -976},
    { 1056, 520, -840},
    { 1032, 352, -760},
    { 1000, 408, -552},
    { 1248, 328, -528},
    { 1664, 200, -624},
    { 1576, 192, -408},
    { 1392, 376, -192},
    { 1408, 352, -144},
    { 1400, 392, -232},
    { 1440, 352, -360},
    { 1336, 264, -288},
    { 952, 152, -296},
    { 728, -40, -456},
    { 504, -80, -496},
    { 88, -160, -720},
    { 296, -272, -808},
    { 192, -256, -864},
    { 96, -288, -792},
    { -48, -320, -816},
    { -152, -392, -760},
    { -144, -400, -928},
    { -176, -384, -1104},
    { -168, -352, -1200},
    { 0, -312, -1264},
    // 272 seconds
    { -96, -256, -1360},
    { 112, -208, -1280},
    { -88, -112, -1064},
    { -56, -88, -1080},
    { 88, -144, -1008},
    { 72, -216, -760},
    { 0, -216, -640},
    { 0, -256, -600},
    { 32, -272, -544},
    { 144, -304, -440},
    { 432, -224, -464},
    { 800, -80, -536},
    { 1104, 72, -400},
    { 1584, 592, -344},
    { 1784, 408, -432},
    { 1752, 216, -264},
    { 1520, 392, -136},
    { 1152, 640, -304},
    { 1096, 240, -176},
    { 1152, 480, -256},
    { 1040, 648, -616},
    { 864, 512, -696},
    { 792, 568, -800},
    { 848, 728, -744},
    { 960, 696, -536},
    // 273 seconds
    { 1216, 632, -640},
    { 1328, 408, -456},
    { 1512, 512, -472},
    { 1808, 432, -352},
    { 1264, 336, -264},
    { 1192, 336, -184},
    { 1160, 336, -208},
    { 1208, 432, -336},
    { 1264, 256, -360},
    { 1120, 272, -616},
    { 904, 384, -576},
    { 784, 416, -712},
    { 408, 88, -744},
    { 152, -64, -928},
    { 40, -296, -880},
    { -24, -336, -648},
    { -112, -232, -656},
    { -120, -448, -576},
    { -240, -608, -552},
    { -208, -360, -776},
    { -224, -280, -1000},
    { -168, -456, -1088},
    { -80, -352, -1240},
    { -248, -320, -1200},
    { -96, -160, -1288},
    // 274 seconds
    { -240, -184, -1176},
    { -64, -40, -1168},
    { 64, -176, -1008},
    { -8, -256, -720},
    { -96, -208, -608},
    { -48, -272, -688},
    { 32, -208, -872},
    { 160, -216, -1000},
    { 328, -272, -1152},
    { 320, -264, -1240},
    { 248, -304, -1320},
    { 352, -296, -1144},
    { 360, -208, -768},
    { 616, -304, -184},
    { 616, -32, 64},
    { 624, 272, 40},
    { 720, 504, -104},
    { 864, 464, -272},
    { 1264, 240, -48},
    { 2032, 504, -136},
    { 2296, 968, -952},
    { 1872, 1464, -912},
    { 1432, 424, -328},
    { 1008, 1136, -632},
    { 464, 968, -328},
    // 275 seconds
    { 608, 1176, -280},
    { 952, 1016, -240},
    { 1016, 512, -248},
    { 968, 312, -424},
    { 1080, 272, -360},
    { 1368, 296, -336},
    { 1672, 352, -184},
    { 1680, 312, -208},
    { 1640, 312, -264},
    { 1192, -192, -80},
    { 1096, -432, 176},
    { 592, 16, -232},
    { 856, -80, -848},
    { 1064, -160, -248},
    { 1032, 88, 8},
    { 1072, 104, -232},
    { 1176, 368, -392},
    { 1368, 448, -392},
    { 1624, 744, -528},
    { 1536, 1416, -608},
    { 856, 1016, -456},
    { 696, 808, -416},
    { 824, 1112, -480},
    { 736, 920, -304},
    { 1112, 968, -248},
    // 276 seconds
    { 1472, 944, -320},
    { 1744, 680, -280},
    { 1456, 256, -280},
    { 1392, 312, -328},
    { 1504, 416, -336},
    { 1816, 312, -192},
    { 1504, 168, -120},
    { 1256, -200, 144},
    { 696, -280, -80},
    { 872, -192, -312},
    { 720, -176, -168},
    { 888, 144, -544},
    { 1224, 104, -304},
    { 1448, 112, -32},
    { 1608, 280, -232},
    { 1512, 624, -312},
    { 1376, 848, -464},
    { 1392, 776, -376},
    { 1360, 856, -352},
    { 1000, 1064, -592},
    { 744, 968, -568},
    { 728, 1008, -576},
    { 856, 888, -368},
    { 920, 680, -248},
    { 1352, 768, -224},
    // 277 seconds
    { 1704, 784, -136},
    { 1328, 472, -48},
    { 1296, 200, -80},
    { 1136, 192, -136},
    { 1168, 288, -144},
    { 1328, 328, -24},
    { 1440, 304, 104},
    { 1048, 216, 88},
    { 1064, -384, 184},
    { 840, 176, 192},
    { 576, 304, -856},
    { 928, 80, -584},
    { 1216, 232, -104},
    { 1056, 144, -184},
    { 1096, 248, -304},
    { 1288, 440, -288},
    { 1496, 664, -240},
    { 1528, 1288, -400},
    { 1184, 1176, -248},
    { 992, 624, -416},
    { 864, 680, -320},
    { 864, 1104, -296},
    { 776, 992, -112},
    { 1120, 968, -80},
    { 1472, 736, -88},
    // 278 seconds
    { 1272, 376, -192},
    { 1184, 240, -160},
    { 1280, 288, -160},
    { 1456, 384, -128},
    { 1544, 328, 56},
    { 1480, 296, 72},
    { 1144, 192, -32},
    { 952, -496, 48},
    { 920, 16, 176},
    { 712, 328, -152},
    { 728, 256, -288},
    { 816, 280, -208},
    { 1008, 144, 48},
    { 1040, 104, -136},
    { 1184, 352, -208},
    { 1424, 656, -336},
    { 1608, 1072, -384},
    { 1368, 1104, -256},
    { 1056, 792, -584},
    { 904, 904, -424},
    { 1000, 1312, -408},
    { 736, 776, -176},
    { 1144, 808, -152},
    { 1440, 760, -136},
    { 1440, 560, -120},
    // 279 seconds
    { 1152, 256, -40},
    { 1072, 288, -184},
    { 1168, 248, -16},
    { 1296, 368, -104},
    { 1384, 320, 88},
    { 1200, 216, 200},
    { 1000, 96, 40},
    { 1080, -824, 304},
    { 816, 360, 328},
    { 856, 88, -768},
    { 1008, 24, -248},
    { 1248, 312, 8},
    { 1280, 168, 96},
    { 1408, 384, -144},
    { 1648, 688, -88},
    { 1648, 1312, -336},
    { 1288, 776, -288},
    { 896, 872, -488},
    { 696, 1104, -328},
    { 736, 1240, -280},
    { 912, 1176, -216},
    { 1208, 824, -160},
    { 1560, 928, -224},
    { 1768, 968, -168},
    { 1736, 888, -24},
    // 280 seconds
    { 1752, 1072, 72},
    { 1808, 1096, 128},
    { 1664, 896, -72},
    { 1336, 632, -16},
    { 1120, 768, -160},
    { 552, 440, -144},
    { 416, 248, -592},
    { 288, 56, -704},
    { -16, -152, -544},
    { 192, -248, -528},
    { 56, -752, -576},
    { 80, -560, -592},
    { 16, -768, -472},
    { -200, -776, -496},
    { -208, -784, -608},
    { -264, -744, -712},
    { -328, -800, -776},
    { -280, -912, -808},
    { -264, -832, -920},
    { -448, -864, -1048},
    { -328, -488, -1048},
    { -376, -592, -848},
    { -432, -400, -832},
    { -272, -376, -872},
    { -272, -472, -832},
    // 281 seconds
    { -288, -440, -736},
    { -328, -440, -664},
    { -392, -496, -680},
    { -384, -456, -784},
    { -272, -600, -808},
    { -248, -664, -928},
    { -128, -720, -992},
    { -136, -720, -1024},
    { -136, -552, -1112},
    { 72, -624, -1016},
    { 16, -592, -936},
    { -40, -584, -768},
    { -312, -480, -744},
    { -192, -552, -656},
    { -280, -640, -648},
    { -392, -720, -704},
    { -328, -744, -752},
    { 64, -560, -592},
    { -248, -816, -832},
    { -184, -832, -840},
    { -296, -784, -888},
    { -320, -696, -984},
    { -312, -600, -864},
    { -320, -488, -776},
    { -160, -368, -984},
    // 282 seconds
    { -280, -312, -928},
    { -264, -664, -672},
    { -440, -552, -720},
    { -504, -784, -848},
    { -176, -288, -888},
    { -456, -656, -816},
    { -536, -584, -912},
    { -592, -520, -1032},
    { -448, -920, -904},
    { -392, -296, -1112},
    { -272, -296, -1064},
    { -248, -256, -992},
    { -280, -232, -800},
    { -432, -304, -784},
    { -624, -328, -768},
    { -520, -304, -632},
    { -584, -432, -624},
    { -592, -408, -752},
    { -624, -464, -800},
    { -576, -480, -888},
    { -616, -392, -944},
    { -672, -416, -936},
    { -600, -528, -1008},
    { -1080, 184, -1216},
    { -688, -56, -840},
    // 283 seconds
    { -512, 64, -864},
    { -560, -232, -864},
    { -496, -208, -720},
    { -296, -256, -752},
    { -344, -168, -728},
    { -208, -648, -696},
    { -184, -736, -560},
    { 48, -256, -488},
    { 344, 48, -576},
    { 144, 120, -200},
    { 1456, 488, 8},
    { 1904, 592, -336},
    { 1952, 712, -264},
    { 2184, 608, 48},
    { 2192, 960, 8},
    { 2032, 1072, 296},
    { 2032, 952, 152},
    { 1624, 1008, -296},
    { 1208, 1000, -384},
    { 856, 1696, -336},
    { 592, 1704, -320},
    { 832, 1336, -256},
    { 880, 792, -296},
    { 1160, 784, -208},
    { 1624, 1024, -168},
    // 284 seconds
    { 2056, 928, 8},
    { 2008, 512, 184},
    { 1880, 296, 152},
    { 1752, 240, 0},
    { 1688, 336, 16},
    { 1400, 336, 40},
    { 1280, 280, 64},
    { 872, -752, 648},
    { 608, -560, 360},
    { 472, -240, -32},
    { 936, 40, -456},
    { 1520, 8, 360},
    { 1480, 568, -40},
    { 1512, 584, 56},
    { 1608, 568, -128},
    { 1728, 856, -248},
    { 1832, 872, -264},
    { 1560, 936, -464},
    { 1160, 1200, -624},
    { 752, 1208, -520},
    { 784, 1240, -680},
    { 832, 1128, -360},
    { 1032, 816, -232},
    { 1424, 872, -200},
    { 1832, 784, -72},
    // 285 seconds
    { 1576, 440, 16},
    { 1456, 352, 0},
    { 1536, 408, -24},
    { 1752, 496, 16},
    { 1688, 400, 192},
    { 1400, 352, 80},
    { 1072, -816, 544},
    { 1032, -688, 496},
    { 616, 200, -120},
    { 928, 32, -392},
    { 1216, 120, -144},
    { 1328, 392, 80},
    { 1648, 272, 336},
    { 1856, 504, 80},
    { 2048, 1144, -224},
    { 1856, 920, -296},
    { 1512, 784, -384},
    { 1080, 1488, -640},
    { 624, 1416, -632},
    { 904, 1296, -480},
    { 840, 640, -272},
    { 1080, 624, -200},
    { 1808, 912, -208},
    { 2024, 640, 24},
    { 1792, 344, 80},
    // 286 seconds
    { 1544, 304, 40},
    { 1408, 392, 40},
    { 1344, 424, 40},
    { 1320, 384, 120},
    { 1192, 312, 80},
    { 1000, 128, 16},
    { 680, -872, 320},
    { 704, -144, 168},
    { 688, -176, -224},
    { 1016, 152, -168},
    { 1360, 216, -56},
    { 1664, 376, 48},
    { 1816, 408, 176},
    { 1872, 792, -112},
    { 1848, 944, -168},
    { 1808, 512, -184},
    { 1536, 1136, -360},
    { 952, 1624, -552},
    { 624, 1304, -440},
    { 872, 1312, -480},
    { 1072, 928, -288},
    { 1432, 840, -104},
    { 1856, 864, -88},
    { 1680, 552, -56},
    { 1440, 360, 24},
    // 287 seconds
    { 1416, 312, -120},
    { 1664, 408, -40},
    { 1800, 384, 264},
    { 1528, 288, 152},
    { 1528, -72, 248},
    { 680, -944, 568},
    { 784, -264, -152},
    { 784, -128, 48},
    { 1384, 80, 136},
    { 1448, -48, 224},
    { 1584, 144, 240},
    { 1792, 432, 88},
    { 2016, 872, -96},
    { 1944, 1200, -304},
    { 1880, 880, -112},
    { 1352, 1008, -296},
    { 888, 1328, -440},
    { 648, 1400, -608},
    { 928, 1504, -400},
    { 1032, 816, -184},
    { 1488, 776, -96},
    { 1784, 792, -128},
    { 1656, 552, -72},
    { 1632, 432, 24},
    { 1664, 416, 32},
    // 288 seconds
    { 1728, 424, 40},
    { 1808, 424, 160},
    { 1488, 264, 192},
    { 1168, 200, 128},
    { 848, 184, -80},
    { 888, 216, -40},
    { 464, 464, -168},
    { -296, 440, -936},
    { -568, 712, -1224},
    { -952, 1160, -1224},
    { -528, 712, -984},
    { -440, 416, -784},
    { -512, 384, -536},
    { -288, -144, -504},
    { -152, -272, -784},
    { -72, -432, -800},
    { 16, -528, -848},
    { -144, -904, -848},
    { 64, -736, -920},
    { -64, -744, -720},
    { 72, -784, -672},
    { 192, -688, -680},
    { 176, -608, -672},
    { 144, -664, -632},
    { 312, -768, -624},
    // 289 seconds
    { -40, -688, -592},
    { 24, -712, -712},
    { -152, -624, -784},
    { -48, -992, -568},
    { 24, -904, -696},
    { 80, -928, -736},
    { 56, -760, -864},
    { 72, -688, -1016},
    { 128, -736, -824},
    { -16, -696, -680},
    { -48, -560, -736},
    { -208, -656, -792},
    { -328, -640, -784},
    { -344, -592, -768},
    { -336, -608, -824},
    { -288, -752, -1088},
    { -168, -464, -968},
    { -248, -808, -800},
    { -424, -800, -728},
    { -200, -512, -784},
    { -360, -432, -768},
    { -328, -448, -872},
    { -320, -80, -816},
    { -376, 408, -704},
    { -488, 528, -384},
    // 290 seconds
    { -640, 944, -32},
    { -776, 1192, 64},
    { -720, 976, -80},
    { -600, 968, -312},
    { -472, 768, -216},
    { -560, 784, -144},
    { -560, 736, -88},
    { -576, 648, -400},
    { -496, -472, -288},
    { -280, -736, -640},
    { -264, -208, -704},
    { -216, -1088, -656},
    { -240, -712, -872},
    { -288, -776, -784},
    { -320, -584, -776},
    { -240, -688, -736},
    { -224, -632, -768},
    { -208, -664, -776},
    { -240, -624, -776},
    { -240, -624, -808},
    { -224, -656, -776},
    { -208, -616, -816},
    { -240, -616, -840},
    { -176, -648, -848},
    { -168, -616, -848},
    // 291 seconds
    { -184, -624, -872},
    { -160, -632, -896},
    { -168, -600, -920},
    { -152, -568, -936},
    { -160, -616, -920},
    { -160, -544, -928},
    { -152, -552, -920},
    { -160, -592, -896},
    { -136, -552, -904},
    { -128, -592, -888},
    { -120, -584, -880},
    { -112, -576, -880},
    { -112, -600, -872},
    { -112, -584, -872},
    { -112, -576, -888},
    { -104, -592, -896},
    { -104, -576, -896},
    { -112, -584, -896},
    { -120, -584, -880},
    { -120, -576, -872},
    { -128, -592, -872},
    { -128, -584, -864},
    { -128, -600, -856},
    { -128, -584, -872},
    { -128, -584, -880},
    // 292 seconds
    { -128, -592, -872},
    { -128, -584, -880},
    { -128, -592, -872},
    { -136, -576, -880},
    { -144, -568, -888},
    { -152, -576, -888},
    { -160, -560, -896},
    { -176, -568, -896},
    { -168, -576, -896},
    { -160, -592, -872},
    { -152, -600, -856},
    { -144, -592, -856},
    { -160, -496, -888},
    { -168, -568, -912},
    { -176, -536, -904},
    { -184, -544, -912},
    { -200, -544, -896},
    { -192, -568, -896},
    { -184, -584, -864},
    { -168, -576, -872},
    { -168, -600, -848},
    { -160, -584, -864},
    { -160, -568, -872},
    { -160, -584, -872},
    { -168, -568, -864},
    // 293 seconds
    { -176, -576, -880},
    { -176, -576, -880},
    { -168, -568, -888},
    { -176, -584, -880},
    { -168, -576, -888},
    { -168, -568, -888},
    { -160, -576, -888},
    { -160, -568, -880},
    { -168, -568, -888},
    { -160, -576, -880},
    { -152, -568, -888},
    { -168, -584, -880},
    { -168, -576, -888},
    { -160, -584, -888},
    { -152, -560, -888},
    { -168, -576, -896},
    { -168, -584, -880},
    { -184, -528, -896},
    { -216, -536, -896},
    { -240, -528, -888},
    { -248, -528, -888},
    { -256, -512, -880},
    { -248, -528, -880},
    { -240, -528, -896},
    { -232, -536, -888},
    // 294 seconds
    { -224, -520, -896},
    { -224, -528, -896},
    { -224, -528, -896},
    { -224, -528, -904},
    { -232, -512, -904},
    { -240, -544, -904},
    { -232, -520, -904},
    { -224, -528, -888},
    { -224, -520, -888},
    { -208, -528, -904},
    { -208, -528, -904},
    { -208, -512, -904},
    { -216, -512, -904},
    { -216, -520, -896},
    { -208, -512, -912},
    { -208, -520, -912},
    { -208, -528, -912},
    { -208, -504, -912},
    { -216, -536, -904},
    { -216, -504, -904},
    { -208, -528, -904},
    { -216, -512, -904},
    { -216, -520, -904},
    { -224, -512, -904},
    { -208, -520, -904},
    // 295 seconds
    { -216, -512, -896},
    { -232, -512, -904},
    { -224, -504, -904},
    { -216, -528, -904},
    { -216, -520, -912},
    { -224, -536, -912},
    { -216, -512, -912},
    { -224, -528, -912},
    { -232, -520, -904},
    { -224, -512, -896},
    { -224, -536, -888},
    { -224, -496, -872},
    { -184, -520, -912},
    { -192, -624, -936},
    { -216, -568, -944},
    { -248, -520, -1000},
    { -272, -536, -952},
    { -280, -416, -888},
    { -288, -408, -808},
    { -280, -568, -824},
    { -304, -600, -920},
    { -320, -464, -872},
    { -384, -216, -968},
    { -416, 160, -880},
    { -344, 128, -1008},
    // 296 seconds
    { -368, 240, -984},
    { -320, 240, -880},
    { -368, 688, -624},
    { -256, 712, -968},
    { -400, 520, -800},
    { -288, 240, -888},
    { -376, 344, -704},
    { -344, 392, -712},
    { -384, 488, -728},
    { -360, 512, -784},
    { -304, 528, -864},
    { -312, 552, -888},
    { -296, 512, -872},
    { -304, 472, -832},
    { -336, 624, -784},
    { -392, 536, -752},
    { -432, 328, -664},
    { -464, 288, -760},
    { -424, 232, -832},
    { -376, 216, -960},
    { -232, 64, -1024},
    { -120, -384, -1088},
    { -32, -400, -1072},
    { -24, -408, -1040},
    { 64, -488, -1032},
    // 297 seconds
    { 104, -448, -976},
    { 48, -720, -912},
    { 40, -528, -960},
    { -24, -376, -944},
    { -56, -504, -904},
    { -88, -408, -944},
    { -112, -376, -960},
    { -96, -480, -920},
    { -112, -456, -960},
    { -144, -520, -936},
    { -192, -416, -936},
    { -56, -464, -1000},
    { -112, -512, -952},
    { -88, -344, -888},
    { -104, -552, -984},
    { -128, -440, -984},
    { -144, -384, -904},
    { -176, -464, -968},
    { -224, -328, -960},
    { -184, -408, -920},
    { -208, -368, -976},
    { -176, -320, -944},
    { 632, -400, -1160},
    { -336, -384, -960},
    { -256, -368, -1016},
    // 298 seconds
    { -224, -320, -968},
    { -88, -304, -992},
    { -112, -392, -976},
    { -144, -368, -992},
    { -152, -376, -1008},
    { -168, -280, -984},
    { -184, -280, -952},
    { -192, -368, -952},
    { -176, -352, -968},
    { -144, -352, -976},
    { -176, -312, -952},
    { -184, -344, -968},
    { -128, -384, -968},
    { -168, -384, -984},
    { -168, -368, -1000},
    { -176, -352, -984},
    { -136, -408, -1008},
    { -128, -336, -984},
    { -136, -376, -992},
    { -72, -488, -1016},
    { -168, -288, -936},
    { -400, -608, -1152},
    { -40, -280, -984},
    { -144, -384, -984},
    { -120, -392, -960},
    // 299 seconds
    { -120, -384, -968},
    { -120, -400, -968},
    { -128, -392, -960},
    { -120, -408, -968},
    { -120, -384, -968},
    { -120, -400, -976},
    { -152, -392, -968},
    { -128, -400, -976},
    { -128, -408, -968},
    { -128, -392, -960},
    { -128, -408, -976},
    { -144, -400, -968},
    { -136, -392, -968},
    { -136, -424, -976},
    { -152, -400, -976},
    { -144, -416, -960},
    { -128, -416, -952},
    { -128, -392, -952},
    { -120, -400, -952},
    { -128, -408, -952},
    { -128, -408, -960},
    { -128, -416, -960},
    { -136, -408, -960},
    { -136, -424, -968},
    { -144, -416, -960},
    // 300 seconds
    // elapsed: 5 minutes
    { -136, -416, -968},
    { -128, -424, -976},
    { -128, -408, -960},
    { -136, -408, -968},
    { -136, -392, -952},
    { -176, -392, -968},
    { -152, -400, -976},
    { -160, -424, -920},
    { -120, -424, -944},
    { -88, -440, -960},
    { -112, -496, -1008},
    { -168, -440, -1024},
    { -120, -368, -960},
    { -152, -448, -984},
    { -168, -320, -960},
    { -144, -416, -944},
    { -152, -384, -952},
    { -152, -392, -944},
    { -144, -408, -960},
    { -144, -384, -968},
    { -144, -384, -968},
    { -160, -408, -984},
    { -144, -384, -968},
    { -144, -408, -968},
    { -144, -400, -968},
    // 301 seconds
    { -152, -400, -968},
    { -152, -384, -976},
    { -152, -400, -968},
    { -144, -376, -968},
    { -144, -416, -968},
    { -144, -392, -960},
    { -144, -416, -968},
    { -160, -384, -968},
    { -152, -416, -960},
    { -160, -376, -960},
    { -144, -392, -952},
    { -144, -408, -968},
    { -136, -408, -952},
    { -80, -408, -960},
    { -192, -392, -968},
    { -160, -416, -960},
    { -136, -392, -976},
    { -136, -344, -976},
    { -152, -360, -984},
    { -136, -336, -960},
    { -176, -296, -976},
    { -136, -448, -960},
    { -200, -272, -968},
    { -184, -312, -976},
    { -128, -312, -968},
    // 302 seconds
    { -80, -312, -968},
    { -40, -160, -992},
    { -104, -160, -992},
    { -152, -168, -1008},
    { -176, -80, -984},
    { -328, -96, -1016},
    { -688, -40, -1000},
    { -984, 160, -1152},
    { -704, -160, -1128},
    { -448, 32, -1072},
    { -160, 200, -1176},
    { 16, 200, -992},
    { 104, 384, -984},
    { 64, 384, -968},
    { -136, 512, -784},
    { -368, 552, -584},
    { 24, 576, -72},
    { -896, 632, -784},
    { -344, -8, -848},
    { -232, 96, -1064},
    { 96, 288, -792},
    { -280, 456, -688},
    { 168, 752, -800},
    { -136, 888, -1192},
    { 0, 904, -1448},
    // 303 seconds
    { 112, 808, -1400},
    { -288, 656, -1168},
    { -448, 800, -696},
    { -304, 696, -272},
    { -768, 648, -136},
    { -752, 416, -80},
    { -856, 656, -104},
    { -688, 392, 80},
    { -696, 184, 24},
    { -768, 280, -24},
    { -856, 80, -144},
    { -880, -8, -320},
    { -864, -120, -288},
    { -768, 88, -496},
    { -800, 112, -712},
    { -728, 144, -696},
    { -760, 408, -632},
    { -584, 424, -640},
    { -616, 560, -552},
    { 144, -176, -568},
    { -576, 368, -392},
    { -656, 536, -184},
    { -536, 560, 160},
    { -728, 992, 24},
    { -680, 1024, 72},
    // 304 seconds
    { -664, 840, -104},
    { -664, 1008, -104},
    { -592, 1072, -224},
    { -448, 912, -136},
    { -312, 1112, -144},
    { -200, 1384, -320},
    { -624, 744, -200},
    { -352, 904, 160},
    { -464, 816, 240},
    { -560, 840, 144},
    { -568, 568, -208},
    { -344, 808, 56},
    { -400, 936, 112},
    { -448, 992, 240},
    { -456, 808, 192},
    { -416, 832, 240},
    { -408, 824, 336},
    { -368, 848, 248},
    { -432, 864, 376},
    { -400, 840, 232},
    { -416, 824, 224},
    { -384, 976, 152},
    { -360, 952, 296},
    { -464, 768, 456},
    { -432, 664, 344},
    // 305 seconds
    { -456, 872, 64},
    { -496, 696, 248},
    { -464, 864, 288},
    { -504, 760, 216},
    { -472, 872, 120},
    { -432, 784, 48},
    { -400, 840, -56},
    { -344, 760, -56},
    { -328, 752, -136},
    { -296, 800, -128},
    { -232, 760, -64},
    { -312, 784, 80},
    { -312, 928, 280},
    { -384, 864, 432},
    { -440, 976, 488},
    { -392, 1048, 360},
    { -392, 864, 344},
    { -304, 896, 304},
    { -352, 840, 264},
    { -320, 760, 144},
    { -320, 720, 176},
    { -208, 904, 344},
    { -192, 816, 192},
    { -144, 864, 56},
    { -88, 992, 160},
    // 306 seconds
    { -64, 1040, 160},
    { -144, 952, 168},
    { -80, 896, -72},
    { -120, 776, -152},
    { -128, 888, -224},
    { -200, 1040, -160},
    { -192, 912, -144},
    { -152, 1056, -112},
    { -144, 1064, -120},
    { -104, 920, -96},
    { -96, 880, -96},
    { -80, 896, -120},
    { -96, 872, -168},
    { -112, 912, -136},
    { -72, 968, -96},
    { -40, 960, -144},
    { 8, 928, -192},
    { -24, 912, -240},
    { -64, 872, -272},
    { -112, 856, -272},
    { -136, 888, -240},
    { -144, 920, -224},
    { -144, 928, -200},
    { -120, 888, -192},
    { -96, 928, -208},
    // 307 seconds
    { -88, 920, -200},
    { -96, 904, -200},
    { -96, 912, -200},
    { -96, 928, -192},
    { -112, 928, -176},
    { -112, 928, -168},
    { -96, 928, -176},
    { -96, 888, -176},
    { -112, 896, -176},
    { -96, 896, -176},
    { -96, 896, -176},
    { -96, 920, -192},
    { -104, 920, -184},
    { -96, 928, -192},
    { -96, 912, -168},
    { -104, 904, -168},
    { -104, 912, -208},
    { -112, 920, -160},
    { -112, 912, -168},
    { -88, 912, -160},
    { -96, 920, -192},
    { -112, 928, -168},
    { -112, 920, -168},
    { -104, 920, -160},
    { -96, 920, -160},
    // 308 seconds
    { -96, 928, -176},
    { -104, 912, -160},
    { -112, 928, -160},
    { -104, 920, -168},
    { -96, 912, -168},
    { -104, 920, -160},
    { -104, 912, -168},
    { -104, 928, -168},
    { -96, 928, -160},
    { -88, 912, -184},
    { -112, 912, -160},
    { -104, 928, -176},
    { -80, 912, -176},
    { -88, 904, -192},
    { -120, 920, -176},
    { -112, 928, -160},
    { -88, 928, -152},
    { -88, 904, -192},
    { -120, 896, -200},
    { -144, 912, -208},
    { -152, 992, -192},
    { -168, 952, -264},
    { -176, 880, -352},
    { -296, 832, -336},
    { -392, 1304, -448},
    // 309 seconds
    { -160, 472, -408},
    { -16, -40, -984},
    { -96, 296, -1080},
    { -120, 472, -944},
    { -56, 136, -1040},
    { -80, 136, -928},
    { -72, 184, -944},
    { -64, 176, -936},
    { -48, 152, -968},
    { -56, 96, -992},
    { -64, 136, -1008},
    { -56, 192, -984},
    { -72, 112, -1040},
    { -80, 152, -1000},
    { -112, 152, -1000},
    { -112, 160, -1008},
    { -104, 184, -984},
    { -96, 152, -992},
    { -96, 232, -976},
    { -56, 104, -992},
    { -16, 96, -944},
    { 16, 168, -888},
    { 88, 360, -712},
    { -16, 920, -688},
    { -112, 792, -736},
    // 310 seconds
    { -160, 768, -568},
    { -192, 880, -552},
    { -176, 808, -608},
    { -144, 808, -640},
    { -88, 824, -576},
    { -16, 776, -488},
    { -48, 784, -472},
    { -56, 808, -488},
    { -56, 792, -528},
    { -56, 800, -528},
    { -48, 808, -512},
    { -56, 800, -512},
    { -64, 800, -528},
    { -40, 832, -544},
    { -48, 776, -520},
    { -40, 800, -520},
    { -32, 768, -536},
    { -48, 784, -520},
    { -48, 800, -512},
    { -56, 808, -520},
    { -56, 784, -544},
    { -56, 784, -560},
    { -64, 792, -520},
    { -72, 800, -504},
    { -64, 808, -544},
    // 311 seconds
    { -64, 792, -528},
    { -64, 776, -552},
    { -64, 784, -536},
    { -72, 808, -512},
    { -72, 792, -528},
    { -80, 808, -520},
    { -80, 800, -544},
    { -64, 776, -560},
    { -64, 776, -552},
    { -80, 792, -544},
    { -72, 792, -560},
    { -96, 792, -568},
    { -128, 768, -560},
    { -168, 816, -552},
    { -128, 840, -576},
    { -120, 840, -632},
    { -120, 768, -656},
    { -112, 648, -656},
    { -96, 736, -712},
    { -88, 640, -752},
    { -96, 552, -728},
    { -88, 576, -696},
    { -56, 560, -728},
    { -88, 544, -760},
    { -136, 608, -776},
    // 312 seconds
    { -128, 592, -800},
    { -112, 592, -808},
    { 408, 560, -704},
    { -64, 688, -864},
    { -136, 552, -760},
    { -112, 536, -824},
    { -128, 552, -832},
    { -56, 488, -848},
    { -136, 536, -872},
    { -136, 512, -840},
    { -144, 456, -856},
    { -192, 488, -824},
    { -144, 448, -848},
    { -248, 544, -856},
    { -112, 432, -888},
    { -160, 496, -888},
    { -136, 432, -872},
    { -216, 472, -880},
    { -144, 456, -832},
    { -160, 504, -840},
    { -136, 520, -840},
    { -120, 480, -848},
    { -152, 512, -848},
    { -152, 504, -832},
    { -160, 528, -840},
    // 313 seconds
    { -160, 520, -824},
    { -160, 520, -848},
    { -168, 536, -800},
    { -120, 504, -856},
    { -128, 496, -848},
    { -152, 496, -856},
    { -152, 504, -856},
    { -152, 480, -840},
    { -144, 496, -856},
    { -144, 488, -856},
    { -144, 496, -840},
    { -152, 504, -840},
    { -160, 504, -848},
    { -152, 496, -856},
    { -160, 496, -832},
    { -160, 504, -832},
    { -152, 512, -856},
    { -152, 496, -856},
    { -152, 496, -848},
    { -160, 504, -856},
    { -152, 496, -856},
    { -168, 504, -848},
    { -160, 496, -840},
    { -168, 480, -856},
    { -160, 504, -840},
    // 314 seconds
    { -168, 496, -848},
    { -160, 504, -856},
    { -136, 496, -848},
    { -176, 480, -832},
    { -160, 488, -832},
    { -160, 496, -864},
    { -160, 488, -864},
    { -152, 496, -864},
    { -152, 480, -848},
    { -152, 488, -848},
    { -96, 544, -832},
    { -176, 496, -848},
    { -184, 512, -848},
    { -160, 496, -848},
    { -144, 520, -864},
    { -152, 496, -840},
    { -144, 504, -840},
    { -224, 512, -1080},
    { -192, 496, -840},
    { -168, 512, -856},
    { -152, 496, -872},
    { -144, 488, -864},
    { -152, 512, -832},
    { -176, 480, -840},
    { -168, 512, -848},
    // 315 seconds
    { -160, 496, -832},
    { -168, 488, -848},
    { -152, 496, -848},
    { -168, 496, -848},
    { -176, 504, -832},
    { -160, 504, -832},
    { -240, 568, -896},
    { -176, 512, -848},
    { -160, 512, -840},
    { -152, 496, -864},
    { -144, 504, -856},
    { -144, 488, -832},
    { -160, 512, -832},
    { -168, 504, -840},
    { -144, 520, -856},
    { 176, 504, -776},
    { -152, 504, -824},
    { -192, 536, -832},
    { -168, 528, -840},
    { -160, 528, -824},
    { -128, 512, -832},
    { -168, 568, -816},
    { -128, 520, -832},
    { -152, 528, -824},
    { -136, 504, -832},
    // 316 seconds
    { -160, 528, -832},
    { -144, 544, -832},
    { -152, 512, -832},
    { -120, 528, -832},
    { -120, 576, -800},
    { -104, 480, -824},
    { -88, 448, -808},
    { -128, 488, -784},
    { -128, 528, -784},
    { -160, 576, -784},
    { -184, 656, -760},
    { -176, 640, -736},
    { -192, 648, -704},
    { -208, 648, -688},
    { -200, 712, -664},
    { -184, 744, -640},
    { -208, 776, -616},
    { -216, 824, -624},
    { -176, 792, -616},
    { -120, 728, -632},
    { -168, 768, -608},
    { -168, 776, -568},
    { -144, 744, -576},
    { -168, 744, -584},
    { -168, 720, -584},
    // 317 seconds
    { -128, 720, -624},
    { -104, 728, -624},
    { -112, 704, -616},
    { -128, 736, -600},
    { -136, 744, -608},
    { -128, 760, -624},
    { -128, 744, -600},
    { -128, 728, -616},
    { -128, 736, -608},
    { -128, 728, -624},
    { -128, 744, -608},
    { -128, 736, -608},
    { -144, 728, -600},
    { -136, 744, -608},
    { -144, 760, -624},
    { -128, 728, -616},
    { -120, 712, -648},
    { -136, 704, -648},
    { -136, 736, -624},
    { -144, 736, -584},
    { -152, 720, -592},
    { -160, 728, -624},
    { -160, 736, -640},
    { -136, 736, -632},
    { -136, 720, -616},
    // 318 seconds
    { -144, 720, -624},
    { -152, 728, -624},
    { -144, 736, -624},
    { -144, 720, -632},
    { -144, 720, -640},
    { -136, 712, -656},
    { -144, 736, -608},
    { -160, 728, -592},
    { -168, 736, -624},
    { -160, 736, -624},
    { -136, 720, -632},
    { -136, 712, -648},
    { -136, 720, -648},
    { -144, 720, -632},
    { -152, 720, -592},
    { -160, 736, -616},
    { -168, 744, -632},
    { -152, 720, -640},
    { -136, 712, -640},
    { -144, 720, -624},
    { -144, 712, -632},
    { -152, 736, -632},
    { -144, 736, -624},
    { -152, 720, -600},
    { -152, 712, -640},
    // 319 seconds
    { -152, 720, -656},
    { -144, 720, -640},
    { -152, 728, -632},
    { -160, 728, -592},
    { -160, 712, -632},
    { -152, 736, -632},
    { -136, 728, -624},
    { -144, 720, -632},
    { -144, 720, -640},
    { -144, 704, -656},
    { -144, 728, -632},
    { -136, 736, -640},
    { -144, 736, -632},
    { -152, 712, -616},
    { -160, 728, -608},
    { -160, 728, -632},
    { -152, 752, -616},
    { -128, 720, -648},
    { -136, 704, -624},
    { -136, 712, -632},
    { -144, 712, -656},
    { -136, 752, -632},
    { -112, 720, -640},
    { -120, 696, -632},
    { -136, 728, -584},
    // 320 seconds
    { -136, 712, -592},
    { -168, 736, -584},
    { -192, 760, -600},
    { -208, 808, -608},
    { -200, 824, -600},
    { -168, 816, -584},
    { -144, 760, -552},
    { -144, 760, -616},
    { -112, 728, -664},
    { -176, 632, -752},
    { -224, 672, -720},
    { -208, 600, -720},
    { -152, 576, -720},
    { -144, 552, -784},
    { -112, 512, -800},
    { -136, 512, -832},
    { -112, 544, -832},
    { -368, 504, -832},
    { -704, 392, -1232},
    { -112, 552, -872},
    { -24, 568, -800},
    { -120, 672, -816},
    { -128, 448, -824},
    { -72, 440, -856},
    { -272, 640, -752},
    // 321 seconds
    { -136, 528, -816},
    { -208, 528, -896},
    { -216, 520, -896},
    { 80, 160, -896},
    { 56, 248, -912},
    { 80, 200, -952},
    { -64, 88, -920},
    { 24, 16, -1072},
    { 1000, 584, -1016},
    { -536, 736, -1080},
    { -240, 336, -936},
    { -160, 360, -920},
    { -176, 344, -912},
    { -200, 408, -888},
    { -216, 448, -824},
    { -224, 496, -848},
    { -184, 496, -848},
    { -136, 416, -736},
    { -88, 392, -704},
    { -72, 576, -632},
    { -64, 816, -560},
    { -88, 824, -536},
    { -64, 824, -392},
    { -72, 1016, -264},
    { -72, 1024, -248},
    // 322 seconds
    { -112, 984, -160},
    { -64, 952, -136},
    { 40, 816, -96},
    { 112, 872, -16},
    { 184, 904, 40},
    { 160, 888, 152},
    { 128, 1008, 208},
    { 96, 1040, 352},
    { 24, 952, 496},
    { -48, 896, 448},
    { -128, 936, 520},
    { -72, 992, 360},
    { -64, 952, 400},
    { 0, 888, 408},
    { 192, 848, 456},
    { 296, 984, 608},
    { 312, 832, 456},
    { 264, 800, 408},
    { 232, 728, 408},
    { 192, 648, 432},
    { 144, 736, 432},
    { 112, 784, 528},
    { 104, 720, 600},
    { 64, 704, 480},
    { 16, 840, 400},
    // 323 seconds
    { 8, 888, 424},
    { -32, 848, 336},
    { -48, 824, 184},
    { -64, 768, 128},
    { -88, 760, 88},
    { -112, 952, 144},
    { -104, 776, 72},
    { -72, 928, 88},
    { 0, 904, 64},
    { 96, 872, -16},
    { 264, 880, -232},
    { 56, 488, -320},
    { 496, 968, -312},
    { 24, 1192, -120},
    { 184, 640, -200},
    { 240, 984, -128},
    { 448, 1272, -104},
    { 360, 952, -256},
    { 320, 640, -296},
    { 472, 896, -296},
    { 544, 1432, -64},
    { 368, 1072, 160},
    { 280, 480, -336},
    { 352, 232, -400},
    { 136, 936, -368},
    // 324 seconds
    { 440, 616, 96},
    { 120, 888, -72},
    { 272, 928, 96},
    { 168, 912, 88},
    { 160, 984, 192},
    { 136, 952, 88},
    { 32, 888, 128},
    { 8, 1080, 88},
    { 0, 1008, 160},
    { -48, 1184, 208},
    { 200, 1200, 312},
    { -16, 1000, 200},
    { 104, 1000, 240},
    { 128, 888, 264},
    { 104, 712, 104},
    { 48, 648, 32},
    { 16, 528, -16},
    { 40, 440, -88},
    { 232, 368, -104},
    { 520, 416, -104},
    { 912, 256, -232},
    { 1840, 704, -8},
    { 1584, 776, 40},
    { 1872, 688, 32},
    { 1264, 904, -184},
    // 325 seconds
    { 1088, 504, -240},
    { 944, 296, -176},
    { 872, 464, -136},
    { 696, 504, 16},
    { 552, 296, 104},
    { 464, 448, 144},
    { 480, 512, 128},
    { 472, 640, 8},
    { 656, 824, -40},
    { 960, 816, -120},
    { 1232, 616, -264},
    { 1544, 712, -200},
    { 1368, 528, -64},
    { 1192, 408, -232},
    { 1704, 552, -296},
    { 1504, 256, 56},
    { 992, 328, -112},
    { 856, 240, -88},
    { 920, 368, -160},
    { 1000, 336, -152},
    { 928, 360, -144},
    { 928, 360, -176},
    { 816, 216, -192},
    { 1032, 368, -208},
    { 656, 392, -112},
    // 326 seconds
    { 640, 520, -168},
    { 1088, 600, -136},
    { 1168, 576, -96},
    { 1024, 552, 8},
    { 936, 600, 8},
    { 992, 440, 64},
    { 1192, 568, 8},
    { 1336, 520, 80},
    { 1184, 632, 152},
    { 968, 744, 328},
    { 880, 792, 408},
    { 888, 688, 352},
    { 1112, 744, 432},
    { 984, 472, 136},
    { 1080, 600, 16},
    { 1296, 632, 56},
    { 1224, 400, -56},
    { 1072, 304, -200},
    { 1048, 296, -144},
    { 1176, 400, -16},
    { 1328, 456, 0},
    { 1248, 280, -56},
    { 1184, 360, -136},
    { 832, 240, -304},
    { 688, 272, -248},
    // 327 seconds
    { 856, 240, -88},
    { 728, 560, -184},
    { 784, 576, -288},
    { 696, 720, -136},
    { 480, 296, -8},
    { 520, 360, -64},
    { 872, 448, -88},
    { 1384, 512, -48},
    { 1456, 776, 88},
    { 1312, 952, 440},
    { 872, 296, -200},
    { 1280, 928, 200},
    { 1248, 920, 368},
    { 1144, 528, 216},
    { 1144, 520, 248},
    { 760, 368, 128},
    { 408, 296, -8},
    { 440, 352, 56},
    { 848, 304, -40},
    { 1312, 352, -40},
    { 1648, 488, -120},
    { 1512, 288, -200},
    { 1240, 352, -208},
    { 856, 168, -256},
    { 968, 240, 112},
    // 328 seconds
    { 648, 480, -104},
    { 800, 424, -256},
    { 848, 320, -72},
    { 536, 312, -72},
    { 480, 328, -16},
    { 536, 456, 64},
    { 792, 488, 144},
    { 1024, 624, 176},
    { 1032, 736, 160},
    { 944, 728, 280},
    { 888, 352, 368},
    { 1656, 696, 264},
    { 1496, 672, 248},
    { 1128, 512, 264},
    { 976, 496, 152},
    { 608, 400, 64},
    { 616, 368, -24},
    { 776, 256, 48},
    { 1104, 368, -8},
    { 1512, 376, 0},
    { 1872, 432, -208},
    { 1224, 160, -488},
    { 640, 192, -544},
    { 904, -72, -88},
    { 832, 360, -280},
    // 329 seconds
    { 904, 384, -248},
    { 784, 288, -160},
    { 560, 240, -56},
    { 552, 328, -24},
    { 808, 512, -56},
    { 1144, 816, 0},
    { 1176, 1000, 224},
    { 1104, 880, 40},
    { 1016, 624, -136},
    { 1104, 712, -120},
    { 696, 672, 0},
    { 728, 664, 200},
    { 904, 592, 280},
    { 952, 376, 40},
    { 688, 296, -56},
    { 664, 288, -48},
    { 856, 360, -64},
    { 1216, 456, -136},
    { 1352, 392, -176},
    { 1320, 376, -440},
    { 1024, 168, -464},
    { 1168, 248, -240},
    { 936, 192, -128},
    { 632, 448, -392},
    { 896, 296, -232},
    // 330 seconds
    { 784, 336, -144},
    { 616, 304, -112},
    { 608, 344, -8},
    { 736, 448, -24},
    { 1016, 544, -104},
    { 1152, 712, -56},
    { 1144, 904, 80},
    { 1216, 864, 376},
    { 968, 464, -272},
    { 976, 680, 168},
    { 720, 592, 120},
    { 800, 608, 168},
    { 904, 608, 120},
    { 768, 312, 88},
    { 552, 384, 8},
    { 776, 376, -64},
    { 1240, 520, -176},
    { 1432, 456, -224},
    { 1488, 536, -256},
    { 1248, 432, -160},
    { 976, 392, -208},
    { 1008, 304, 56},
    { 424, 352, -216},
    { 600, 456, -296},
    { 736, 352, -136},
    // 331 seconds
    { 528, 280, 0},
    { 456, 312, -8},
    { 568, 384, -32},
    { 928, 600, 88},
    { 1184, 1056, 248},
    { 984, 824, 64},
    { 1048, 864, 56},
    { 920, 816, 208},
    { 1032, 928, 360},
    { 704, 544, 328},
    { 952, 560, 264},
    { 992, 600, 264},
    { 800, 440, 136},
    { 664, 376, 48},
    { 688, 408, 0},
    { 944, 456, 24},
    { 1192, 520, -24},
    { 1480, 504, -40},
    { 1416, 496, -232},
    { 920, 216, -512},
    { 1200, 216, -216},
    { 752, 144, -104},
    { 744, 584, -360},
    { 968, 400, -136},
    { 800, 320, -32},
    // 332 seconds
    { 640, 424, -24},
    { 688, 472, 88},
    { 824, 488, 24},
    { 1104, 640, 56},
    { 1224, 816, 288},
    { 976, 784, 368},
    { 904, 432, 56},
    { 1232, 784, 376},
    { 888, 576, 152},
    { 984, 472, 192},
    { 1040, 584, 312},
    { 1024, 440, 224},
    { 848, 232, -24},
    { 808, 360, -80},
    { 928, 512, 40},
    { 1144, 480, 48},
    { 1272, 384, -8},
    { 1360, 464, -128},
    { 1128, 312, -216},
    { 656, 232, -224},
    { 1160, 336, 24},
    { 656, 392, 16},
    { 648, 560, -192},
    { 928, 496, -72},
    { 832, 416, -16},
    // 333 seconds
    { 712, 472, -24},
    { 704, 432, 48},
    { 1008, 560, 56},
    { 1192, 760, 88},
    { 1144, 856, 416},
    { 976, 720, 328},
    { 808, 632, 88},
    { 1024, 816, 408},
    { 984, 584, 344},
    { 1016, 504, 248},
    { 1168, 528, 240},
    { 1200, 408, 176},
    { 912, 320, -56},
    { 880, 376, -56},
    { 1080, 536, 16},
    { 1464, 528, 40},
    { 1328, 432, 24},
    { 1240, 360, -312},
    { 688, -120, -280},
    { 496, 168, -344},
    { 1280, 152, -32},
    { 1024, 504, -240},
    { 960, 592, -240},
    { 1080, 480, -168},
    { 824, 440, 8},
    // 334 seconds
    { 768, 392, -24},
    { 920, 432, -16},
    { 1152, 536, 32},
    { 1296, 824, 200},
    { 1168, 928, 688},
    { 792, 560, 72},
    { 792, 640, 232},
    { 1288, 768, 504},
    { 1184, 560, 288},
    { 1080, 536, 224},
    { 1120, 552, 160},
    { 976, 392, 56},
    { 848, 368, -32},
    { 968, 384, -24},
    { 1264, 440, 128},
    { 1312, 464, 128},
    { 1464, 400, 16},
    { 1248, 272, -40},
    { 784, -40, -376},
    { 1104, 200, -208},
    { 856, 80, 184},
    { 792, 664, -152},
    { 984, 568, -72},
    { 960, 408, 40},
    { 720, 304, -32},
    // 335 seconds
    { 736, 464, -40},
    { 904, 464, 112},
    { 1016, 648, 40},
    { 1248, 792, 88},
    { 1272, 968, 616},
    { 936, 600, -40},
    { 936, 656, 104},
    { 1160, 792, 408},
    { 880, 520, 208},
    { 1008, 624, 160},
    { 1080, 688, 40},
    { 1000, 456, -72},
    { 768, 416, -136},
    { 760, 528, -144},
    { 1144, 560, -104},
    { 1216, 400, -104},
    { 1232, 392, -72},
    { 1200, 368, -120},
    { 912, 240, -216},
    { 952, 208, -320},
    { 1072, 152, 80},
    { 736, 544, -80},
    { 912, 592, -224},
    { 944, 440, -208},
    { 656, 264, -192},
    // 336 seconds
    { 616, 312, -64},
    { 816, 424, 48},
    { 1072, 488, 160},
    { 1256, 600, 112},
    { 1336, 680, 216},
    { 1184, 744, 224},
    { 1016, 736, -80},
    { 992, 680, 152},
    { 1136, 872, 408},
    { 656, 456, 208},
    { 584, 648, -24},
    { 952, 648, 48},
    { 1064, 552, 56},
    { 872, 480, -80},
    { 784, 504, -80},
    { 920, 456, 16},
    { 976, 464, -56},
    { 1216, 568, -64},
    { 1184, 312, -80},
    { 896, 168, -216},
    { 624, 248, -104},
    { 728, 440, -184},
    { 1536, 464, 112},
    { 1176, 728, -176},
    { 1576, 712, -120},
    // 337 seconds
    { 1264, 512, 72},
    { 608, 488, -112},
    { 560, 400, -40},
    { 720, 408, 72},
    { 968, 512, 256},
    { 1120, 712, 480},
    { 1104, 696, 416},
    { 1168, 576, 432},
    { 824, 608, 528},
    { 824, 816, 464},
    { 896, 488, 312},
    { 1128, 456, 96},
    { 1200, 464, 56},
    { 1064, 592, 72},
    { 808, 320, 32},
    { 656, 320, -96},
    { 784, 480, -24},
    { 1152, 536, 8},
    { 1424, 656, 112},
    { 1336, 448, -24},
    { 1120, 416, -168},
    { 872, 696, -152},
    { 896, 720, 256},
    { 632, 1176, 208},
    { 512, 912, 32},
    // 338 seconds
    { 464, 976, 144},
    { 8, 888, 184},
    { 0, 896, 160},
    { -80, 520, 328},
    { -224, 496, 280},
    { -320, 488, 280},
    { -552, 576, 384},
    { -720, 776, 408},
    { -848, 1008, 480},
    { -784, 1264, 480},
    { -480, 968, 320},
    { -392, 1072, 336},
    { -392, 1048, 376},
    { -336, 760, 328},
    { -304, 736, 144},
    { -272, 480, 128},
    { -240, 560, 168},
    { -224, 576, 168},
    { -200, 520, 112},
    { -216, 888, 152},
    { 40, 576, -40},
    { 184, 520, -240},
    { 360, 360, 16},
    { 608, 560, 312},
    { 648, 904, 328},
    // 339 seconds
    { 896, 824, 416},
    { 960, 728, 480},
    { 1144, 648, 568},
    { 1032, 984, 472},
    { 1096, 736, 208},
    { 1448, 560, 80},
    { 1408, 568, 376},
    { 1248, 352, 200},
    { 1144, 376, 504},
    { 1176, 408, 608},
    { 728, 504, 648},
    { 632, 384, 400},
    { 696, 440, 464},
    { 928, 448, 344},
    { 952, 456, 192},
    { 1032, 440, 232},
    { 984, 216, 264},
    { 1176, 344, 208},
    { 1296, 368, 80},
    { 1280, 224, -16},
    { 1368, 208, 248},
    { 1232, 160, -128},
    { 1088, 24, -24},
    { 600, 456, -8},
    { 960, 440, -72},
    // 340 seconds
    { 944, 184, -8},
    { 664, 200, -16},
    { 584, 320, -24},
    { 648, 288, 64},
    { 1016, 296, 128},
    { 1312, 424, 176},
    { 1376, 544, 320},
    { 1288, 840, 496},
    { 1224, 848, 608},
    { 1104, 584, 272},
    { 664, 672, 360},
    { 784, 512, 384},
    { 856, 408, 424},
    { 816, 368, 280},
    { 656, 376, 144},
    { 640, 368, 72},
    { 960, 264, 88},
    { 1288, 192, 240},
    { 1640, 336, 384},
    { 1496, 544, 208},
    { 1168, 80, -200},
    { 1360, 160, -40},
    { 712, 288, -184},
    { 824, 560, -336},
    { 880, 264, -120},
    // 341 seconds
    { 640, 168, 72},
    { 480, 440, 152},
    { 504, 528, 280},
    { 664, 648, 376},
    { 728, 608, 440},
    { 656, 872, 536},
    { 560, 992, 696},
    { 512, 856, 744},
    { 696, 968, 936},
    { 736, 824, 776},
    { 832, 624, 864},
    { 848, 640, 832},
    { 672, 568, 576},
    { 568, 504, 584},
    { 440, 520, 528},
    { 528, 632, 640},
    { 432, 720, 784},
    { 376, 704, 680},
    { 336, 624, 656},
    { 48, 472, 600},
    { -152, 656, 544},
    { -272, 376, 504},
    { -416, 656, 528},
    { -304, 576, 280},
    { -280, 512, 456},
    // 342 seconds
    { -312, 504, 296},
    { -440, 552, 272},
    { -552, 528, 232},
    { -704, 448, 240},
    { -912, 488, 392},
    { -888, 624, 360},
    { -944, 560, 416},
    { -1184, 632, 616},
    { -936, 1032, 720},
    { -880, 560, 480},
    { -912, 632, 416},
    { -800, 792, 296},
    { -584, 536, -8},
    { -480, 168, -232},
    { -456, 280, -488},
    { -400, 336, -488},
    { -184, 208, -280},
    { 24, 152, -144},
    { 424, 312, -80},
    { 760, 320, 64},
    { 1528, 1184, 376},
    { 1704, 1008, 552},
    { 2112, 1000, 240},
    { 2656, 1320, 408},
    { 2056, 1208, 784},
    // 343 seconds
    { 1304, 784, 480},
    { 1272, 392, 248},
    { 1408, 608, 344},
    { 1200, 896, 656},
    { 832, 704, 624},
    { 496, 1072, 624},
    { 536, 936, 768},
    { 824, 976, 576},
    { 888, 880, 536},
    { 1288, 840, 488},
    { 1728, 872, 552},
    { 1976, 784, 536},
    { 1832, 472, 376},
    { 1592, 528, 256},
    { 1640, 592, 280},
    { 1680, 600, 360},
    { 1472, 224, 344},
    { 1208, 216, 192},
    { 848, -128, -680},
    { 616, -40, -520},
    { 976, -328, -248},
    { 1472, 616, -80},
    { 1496, 560, 72},
    { 1424, 592, 256},
    { 1376, 464, 400},
    // 344 seconds
    { 1368, 584, 416},
    { 1584, 648, 496},
    { 1960, 864, 624},
    { 2064, 1112, 936},
    { 1224, 1008, 976},
    { 776, 1168, 880},
    { 472, 1216, 1032},
    { 696, 1144, 992},
    { 848, 736, 720},
    { 1296, 880, 640},
    { 1888, 952, 704},
    { 1896, 720, 488},
    { 1592, 584, 376},
    { 1648, 584, 392},
    { 1936, 640, 440},
    { 2112, 528, 448},
    { 1552, 296, 336},
    { 1328, -248, -472},
    { 592, -584, -496},
    { 1152, -184, -464},
    { 1240, 416, -240},
    { 1496, 296, 80},
    { 1480, 280, 280},
    { 1520, 384, 392},
    { 1576, 624, 512},
    // 345 seconds
    { 1792, 736, 736},
    { 1832, 1216, 800},
    { 1808, 944, 648},
    { 1296, 912, 712},
    { 824, 1016, 1152},
    { 400, 1176, 992},
    { 424, 1000, 912},
    { 680, 736, 760},
    { 1176, 784, 648},
    { 1720, 944, 600},
    { 1928, 888, 512},
    { 1712, 648, 472},
    { 1648, 512, 432},
    { 1664, 480, 360},
    { 1712, 512, 312},
    { 1608, 336, 336},
    { 1296, 200, 232},
    { 1032, -512, -424},
    { 984, -672, -216},
    { 1208, 656, -368},
    { 1184, 336, -112},
    { 1320, 248, 152},
    { 1392, 272, 304},
    { 1408, 464, 376},
    { 1488, 608, 528},
    // 346 seconds
    { 1648, 816, 656},
    { 1664, 1040, 512},
    { 1464, 928, 496},
    { 1104, 1184, 808},
    { 720, 1048, 832},
    { 792, 1080, 1056},
    { 776, 792, 728},
    { 920, 720, 528},
    { 1224, 848, 552},
    { 1512, 800, 552},
    { 1432, 528, 496},
    { 1416, 504, 392},
    { 1568, 448, 432},
    { 1656, 360, 488},
    { 1656, 328, 472},
    { 1376, 208, 352},
    { 1080, 232, 24},
    { 984, -312, -416},
    { 800, -552, -320},
    { 1240, 648, -232},
    { 1104, 256, 16},
    { 1488, 288, 240},
    { 1408, 336, 368},
    { 1536, 560, 504},
    { 1624, 704, 712},
    // 347 seconds
    { 1728, 1072, 648},
    { 1536, 888, 312},
    { 1216, 1056, 568},
    { 720, 1456, 808},
    { 616, 1080, 816},
    { 712, 944, 736},
    { 832, 736, 520},
    { 1128, 816, 488},
    { 1496, 840, 536},
    { 1464, 592, 440},
    { 1408, 480, 360},
    { 1512, 448, 368},
    { 1584, 408, 424},
    { 1624, 320, 384},
    { 1448, 248, 312},
    { 1288, 248, 80},
    { 928, -464, -472},
    { 1184, -440, -168},
    { 1024, 256, -288},
    { 1128, 432, -144},
    { 1416, 416, 104},
    { 1416, 248, 352},
    { 1536, 520, 408},
    { 1584, 664, 608},
    { 1560, 1032, 640},
    // 348 seconds
    { 1512, 984, 392},
    { 1216, 1048, 552},
    { 760, 1416, 824},
    { 496, 1088, 712},
    { 848, 1120, 920},
    { 920, 688, 552},
    { 1216, 776, 472},
    { 1584, 880, 536},
    { 1608, 680, 496},
    { 1432, 512, 368},
    { 1464, 408, 368},
    { 1552, 480, 320},
    { 1744, 328, 424},
    { 1488, 120, 400},
    { 1232, 256, 224},
    { 1192, -320, -392},
    { 944, -688, -176},
    { 1048, 256, -448},
    { 1072, 472, -240},
    { 1384, 376, 24},
    { 1528, 248, 240},
    { 1704, 400, 416},
    { 1704, 616, 560},
    { 1656, 960, 640},
    { 1760, 1032, 376},
    // 349 seconds
    { 1576, 992, 416},
    { 1056, 1472, 792},
    { 472, 1296, 648},
    { 552, 1264, 784},
    { 664, 752, 568},
    { 1072, 744, 424},
    { 1568, 888, 512},
    { 1832, 768, 512},
    { 1696, 584, 392},
    { 1688, 440, 392},
    { 1656, 416, 400},
    { 1840, 392, 416},
    { 1576, 288, 304},
    { 1272, 328, 144},
    { 1248, 208, -104},
    { 432, -280, -344},
    { 760, -888, -480},
    { 888, 408, -312},
    { 944, 360, -176},
    { 1408, 392, 152},
    { 1640, 272, 264},
    { 1904, 616, 512},
    { 1992, 880, 888},
    { 1864, 1648, 552},
    { 1520, 688, 248},
    // 350 seconds
    { 1248, 1272, 832},
    { 680, 1424, 816},
    { 536, 1144, 848},
    { 664, 872, 632},
    { 808, 608, 384},
    { 1184, 808, 424},
    { 1728, 896, 576},
    { 1576, 568, 392},
    { 1568, 600, 352},
    { 1680, 656, 736},
    { 2000, 784, 664},
    { 1856, 1144, 744},
    { 1768, 1272, 1144},
    { 1336, 1048, 872},
    { 696, 656, 448},
    { 200, 128, -96},
    { -192, -120, -152},
    { -552, -232, -344},
    { -1368, 376, 104},
    { -560, 448, -720},
    { -792, 112, -544},
    { -784, -72, -280},
    { -928, 160, -440},
    { -952, 48, -880},
    { -888, -248, -680},
    // 351 seconds
    { -1008, -264, -576},
    { -632, -216, -912},
    { -672, -256, -1064},
    { -632, -280, -1048},
    { -520, -416, -1008},
    { -568, -392, -856},
    { -488, -440, -1288},
    { -424, 48, -1024},
    { -576, -112, -416},
    { -592, -304, -168},
    { -152, 312, -1848},
    { -440, -392, -608},
    { 560, -720, -2272},
    { 240, -744, -2248},
    { 40, -656, -1736},
    { -144, -664, -1152},
    { -48, -296, -216},
    { 368, 392, 120},
    { -40, 1664, 80},
    { -448, 992, 1208},
    { -368, -1600, 552},
    { -360, -1120, 192},
    { -472, 64, 104},
    { -952, 792, 656},
    { -256, 512, -64},
    // 352 seconds
    { 40, 192, 680},
    { -160, -240, 504},
    { -248, 96, 464},
    { 16, 16, 200},
    { 248, 1000, -40},
    { 824, 2504, -496},
    { 328, 4000, 504},
    { 40, 4000, -112},
    { -216, 2752, -696},
    { 168, 2344, -640},
    { 472, 1528, -704},
    { 312, 920, -416},
    { 608, 416, -336},
    { 1216, 24, -240},
    { 952, -232, 32},
    { 1296, 224, 328},
    { 1248, 592, -64},
    { 1312, 712, -152},
    { 1520, 536, 24},
    { 1928, 600, 160},
    { 2144, 552, 640},
    { 1712, 552, 1416},
    { 2024, 1432, 344},
    { 1832, 920, 672},
    { 1320, 896, 760},
    // 353 seconds
    { 1000, 800, 832},
    { 720, 832, 920},
    { 672, 912, 976},
    { 544, 848, 504},
    { 696, 872, 384},
    { 1096, 976, 600},
    { 1728, 968, 656},
    { 1944, 704, 536},
    { 1936, 576, 336},
    { 2064, 840, -16},
    { 2232, 552, 232},
    { 1784, 464, 152},
    { 1536, 600, -72},
    { 1184, -728, -680},
    { 680, -672, -872},
    { 864, -728, -384},
    { 1192, 320, -344},
    { 1464, 200, -24},
    { 1624, 1080, 832},
    { 1920, 760, 216},
    { 2024, 928, 392},
    { 1824, 1312, 648},
    { 1616, 736, 464},
    { 1416, 1056, 736},
    { 760, 1248, 904},
    // 354 seconds
    { 408, 1208, 960},
    { 624, 1016, 856},
    { 832, 880, 792},
    { 952, 688, 584},
    { 1280, 752, 504},
    { 1736, 840, 552},
    { 1696, 592, 456},
    { 1576, 512, 360},
    { 1512, 536, 208},
    { 1576, 528, 208},
    { 1560, 352, 280},
    { 1384, 416, 168},
    { 1048, -16, -296},
    { 848, -400, -464},
    { 960, -656, -408},
    { 1232, 352, -288},
    { 1272, 368, -112},
    { 1696, 584, 112},
    { 1592, 416, 392},
    { 1576, 672, 352},
    { 1624, 816, 528},
    { 1592, 1048, 472},
    { 1552, 920, 400},
    { 1184, 1184, 632},
    { 648, 1400, 808},
    // 355 seconds
    { 336, 1360, 680},
    { 808, 1176, 776},
    { 984, 856, 528},
    { 1440, 936, 552},
    { 2008, 1072, 648},
    { 2072, 920, 528},
    { 1992, 800, 544},
    { 2032, 1016, 504},
    { 2144, 904, 504},
    { 1816, 960, 312},
    { 1464, 1048, 192},
    { 1112, 416, 240},
    { 832, 504, 72},
    { 232, -352, -320},
    { -24, -96, -480},
    { -32, -104, -736},
    { -64, -504, -736},
    { -80, -384, -760},
    { -72, -144, -840},
    { -152, -256, -872},
    { -128, -472, -864},
    { -192, -480, -912},
    { -288, -496, -1000},
    { -136, -424, -1080},
    { -184, -360, -1120},
    // 356 seconds
    { -312, -424, -1160},
    { -128, -320, -1216},
    { -216, -336, -1040},
    { -192, -184, -992},
    { -48, -200, -944},
    { -16, -360, -872},
    { 32, -288, -880},
    { 32, -320, -848},
    { 184, -352, -848},
    { 432, -456, -792},
    { 104, -656, -1016},
    { 248, -328, -1136},
    { 256, -1064, -1256},
    { 96, -584, -1000},
    { 408, -512, -792},
    { 304, -888, -784},
    { 424, -520, -728},
    { 296, -784, -400},
    { 192, -696, -360},
    { 264, -472, -528},
    { 1056, -600, 176},
    { 496, 56, 312},
    { 304, 856, -16},
    { -216, 616, -1032},
    { -184, 888, -1208},
    // 357 seconds
    { -144, 1400, -1400},
    { -96, 1432, -1416},
    { -192, 1288, -1440},
    { -232, 1344, -1432},
    { 8, 1008, -1448},
    { 160, 504, -1112},
    { 40, 128, -784},
    { 16, 176, -640},
    { 104, 24, -656},
    { 264, -144, -448},
    { 512, -200, -272},
    { 1464, 80, -184},
    { 1272, 304, -456},
    { 1408, 360, -456},
    { 1216, 136, -424},
    { 1520, 192, -272},
    { 1592, 224, -88},
    { 1496, 304, 24},
    { 1296, 376, -200},
    { 1072, 520, -232},
    { 1032, 512, -256},
    { 1096, 640, -248},
    { 1040, 888, -448},
    { 816, 1168, -528},
    { 920, 816, -456},
    // 358 seconds
    { 1216, 616, -200},
    { 1240, 712, -296},
    { 1488, 600, -88},
    { 1744, 592, -176},
    { 1888, 576, -312},
    { 1560, 320, -72},
    { 1392, 168, -88},
    { 1480, 168, -32},
    { 1496, 184, -16},
    { 1392, 184, -80},
    { 1264, 152, -32},
    { 816, -680, 280},
    { 424, -456, 88},
    { 632, -344, -80},
    { 1120, 56, -312},
    { 1224, 208, -240},
    { 1504, 256, -128},
    { 1944, 256, 232},
    { 1912, 608, -216},
    { 1544, 1184, -488},
    { 1632, 408, -392},
    { 1496, 944, -480},
    { 976, 1432, -616},
    { 704, 1456, -664},
    { 832, 952, -496},
    // 359 seconds
    { 912, 896, -440},
    { 1240, 768, -200},
    { 1792, 904, -184},
    { 1936, 664, -184},
    { 1688, 376, -152},
    { 1472, 312, -80},
    { 1424, 296, -128},
    { 1408, 232, -136},
    { 1440, 168, -104},
    { 1272, 80, -128},
    { 944, -816, 296},
    { 632, -552, -152},
    { 904, -440, 144},
    { 1528, 136, -168},
    { 1592, 400, -168},
    { 1584, 48, -96},
    { 1736, 24, -80},
    { 1832, 672, -336},
    { 1840, 1104, -272},
    { 1848, 976, -96},
    { 1416, 1208, -144},
    { 880, 1576, -176},
    { 576, 1408, -16},
    { 816, 1496, 136},
    { 872, 992, 0},
    // 360 seconds
    // elapsed: 6 minutes
    { 1272, 904, -24},
    { 1776, 952, -48},
    { 1928, 760, -88},
    { 1856, 416, -88},
    { 1640, 352, -24},
    { 1552, 376, -184},
    { 1640, 312, -88},
    { 1528, 224, -80},
    { 1360, 184, -88},
    { 816, -824, 32},
    { 928, -704, -112},
    { 832, -344, -360},
    { 1448, 360, -360},
    { 1496, -8, -112},
    { 1680, 8, -200},
    { 1712, 544, -216},
    { 1784, 808, -144},
    { 1848, 1056, -176},
    { 1904, 928, -264},
    { 1616, 1408, -64},
    { 856, 2480, -200},
    { 376, 1600, -152},
    { 800, 1592, -88},
    { 832, 928, -72},
    { 1432, 952, -56},
    // 361 seconds
    { 2128, 976, -64},
    { 2048, 640, -72},
    { 1816, 432, -112},
    { 1592, 392, -120},
    { 1624, 392, -200},
    { 1648, 344, -248},
    { 1560, 232, -192},
    { 1200, 32, -200},
    { 624, -1496, 328},
    { 752, -648, -168},
    { 1080, -288, -480},
    { 1688, -160, -208},
    { 1736, 104, -360},
    { 1744, 144, -288},
    { 1920, 368, -240},
    { 2160, 872, -208},
    { 2104, 1368, -96},
    { 1872, 992, -24},
    { 1352, 1120, -96},
    { 928, 1632, -120},
    { 408, 1560, -16},
    { 648, 1536, 120},
    { 928, 1176, -8},
    { 1456, 1000, -72},
    { 1984, 880, -144},
    // 362 seconds
    { 1944, 560, -144},
    { 1784, 464, -128},
    { 1760, 416, -184},
    { 1992, 400, -272},
    { 1960, 248, -32},
    { 1472, 224, -80},
    { 1360, -256, 112},
    { 600, -920, 24},
    { 664, -656, 24},
    { 1104, -216, -384},
    { 1280, -120, -136},
    { 1760, 392, 40},
    { 1640, 544, -224},
    { 1776, 560, -192},
    { 1920, 1016, -200},
    { 1792, 1200, -152},
    { 1656, 992, -136},
    { 1200, 1384, -264},
    { 744, 1368, -360},
    { 544, 1528, -416},
    { 752, 1240, -288},
    { 968, 904, -224},
    { 1496, 1072, -96},
    { 2032, 984, 8},
    { 1864, 496, -16},
    // 363 seconds
    { 1624, 400, -8},
    { 1544, 432, -8},
    { 1576, 384, -16},
    { 1528, 336, -8},
    { 1584, 296, 40},
    { 1176, 64, 200},
    { 672, -776, 16},
    { 584, -352, -32},
    { 792, -112, -224},
    { 1032, 8, -144},
    { 1480, 176, -48},
    { 1680, 376, -16},
    { 1744, 552, -112},
    { 1800, 824, -224},
    { 1800, 1200, -232},
    { 1672, 808, -280},
    { 1272, 1280, -416},
    { 760, 1544, -424},
    { 584, 1432, -432},
    { 824, 1272, -224},
    { 1008, 1168, -168},
    { 1440, 1016, -40},
    { 1976, 928, 128},
    { 1936, 528, 24},
    { 1656, 376, -112},
    // 364 seconds
    { 1648, 496, -80},
    { 1768, 464, -64},
    { 1688, 264, 112},
    { 1544, 280, -32},
    { 1376, 272, -72},
    { 776, -680, 72},
    { 664, -672, -88},
    { 480, -528, -208},
    { 1176, -48, -192},
    { 1528, 176, -288},
    { 1632, 216, -328},
    { 1648, 400, -304},
    { 1672, 624, -296},
    { 1744, 960, -520},
    { 1400, 1128, -792},
    { 1048, 1768, -1072},
    { 720, 1576, -1184},
    { 944, 1112, -808},
    { 1104, 1024, -416},
    { 1368, 992, -232},
    { 1552, 728, 48},
    { 1920, 728, 72},
    { 1960, 600, 136},
    { 1544, 424, 96},
    { 1376, 416, 16},
    // 365 seconds
    { 1376, 368, 0},
    { 1448, 320, -40},
    { 1368, 272, -72},
    { 1304, 224, -176},
    { 792, -752, 32},
    { 560, -888, -72},
    { 672, -440, -224},
    { 968, 184, -408},
    { 1240, 144, -232},
    { 1616, -48, -128},
    { 1832, 232, -200},
    { 1816, 504, -152},
    { 1848, 808, -136},
    { 1776, 912, -216},
    { 1760, 736, -248},
    { 1232, 1472, -496},
    { 600, 1944, -960},
    { 808, 1504, -600},
    { 1272, 1272, -328},
    { 1384, 824, -216},
    { 1720, 744, 0},
    { 2200, 1040, 72},
    { 2344, 800, 264},
    { 1968, 664, 352},
    { 1824, 800, 392},
    // 366 seconds
    { 1880, 1160, 472},
    { 1936, 1096, 528},
    { 1600, 504, 272},
    { 1160, 8, 232},
    { 768, -288, -16},
    { 584, -616, -48},
    { 392, -624, -72},
    { 88, -608, -256},
    { 72, -880, -368},
    { 152, -984, -272},
    { 168, -888, -392},
    { 88, -824, -480},
    { 104, -784, -488},
    { 48, -864, -480},
    { 40, -816, -672},
    { -24, -840, -744},
    { -32, -864, -800},
    { -32, -864, -856},
    { -192, -944, -856},
    { -168, -768, -896},
    { -328, -672, -816},
    { -184, -576, -760},
    { -64, -520, -800},
    { -24, -568, -648},
    { 8, -560, -496},
    // 367 seconds
    { 32, -568, -400},
    { 88, -632, -320},
    { 272, -512, -312},
    { 400, -408, -288},
    { 608, -88, -136},
    { 1080, 360, -272},
    { 1472, 536, -808},
    { 1864, 248, -488},
    { 2224, 280, -168},
    { 2192, 400, -240},
    { 1936, 112, -304},
    { 1832, 192, 0},
    { 1784, 440, 104},
    { 1680, 760, -16},
    { 1336, 1056, 32},
    { 904, 1256, 112},
    { 696, 1504, 32},
    { 816, 1200, -64},
    { 1072, 960, -152},
    { 1320, 640, -144},
    { 1752, 712, 72},
    { 2328, 720, 56},
    { 2112, 264, -96},
    { 1808, 8, 40},
    { 1608, 120, -40},
    // 368 seconds
    { 1768, 216, -80},
    { 1616, 200, 24},
    { 1360, 152, -72},
    { 1064, -592, 16},
    { 800, -936, 352},
    { 528, -528, -248},
    { 848, 104, -624},
    { 1080, -40, -192},
    { 1448, 128, -536},
    { 1696, 168, -96},
    { 1960, 416, -144},
    { 2048, 992, -272},
    { 1944, 1032, -64},
    { 1832, 800, -64},
    { 1312, 1320, -144},
    { 816, 1280, -184},
    { 640, 1480, -152},
    { 952, 1352, 40},
    { 1232, 1000, 16},
    { 1528, 816, -80},
    { 1720, 648, -216},
    { 1608, 464, -128},
    { 1592, 392, -72},
    { 1736, 320, -96},
    { 1864, 304, -64},
    // 369 seconds
    { 1800, 224, 112},
    { 1336, 128, 16},
    { 1024, 40, -184},
    { 808, -1336, 280},
    { 760, -120, -232},
    { 760, -104, -472},
    { 1288, -32, 48},
    { 1496, 96, -272},
    { 1512, 192, 120},
    { 1728, 408, -80},
    { 1984, 632, -64},
    { 1896, 1136, -648},
    { 1776, 752, -424},
    { 1296, 792, -584},
    { 896, 1352, -704},
    { 720, 1360, -640},
    { 1144, 1368, -304},
    { 1320, 704, -136},
    { 1712, 536, -120},
    { 1984, 624, -248},
    { 1840, 400, -96},
    { 1632, 304, -24},
    { 1536, 296, -32},
    { 1568, 272, -48},
    { 1640, 304, 24},
    // 370 seconds
    { 1456, 240, 48},
    { 1288, 120, -24},
    { 640, -1496, 104},
    { 632, -200, -24},
    { 848, -312, -424},
    { 1496, -8, 24},
    { 1616, 152, -32},
    { 1896, 344, 16},
    { 1800, 496, -56},
    { 1896, 760, -264},
    { 1968, 912, -376},
    { 1984, 984, -400},
    { 1600, 1496, -200},
    { 848, 1648, -544},
    { 536, 1416, -472},
    { 808, 1384, -320},
    { 984, 1032, -208},
    { 1472, 992, -88},
    { 2048, 912, -112},
    { 1968, 568, -112},
    { 1792, 400, -104},
    { 1744, 400, -96},
    { 1768, 432, -48},
    { 1792, 360, 104},
    { 1488, 264, -8},
    // 371 seconds
    { 1088, 160, -72},
    { 896, -1200, 432},
    { 584, -376, 368},
    { 672, -384, -552},
    { 976, -48, -224},
    { 1192, 176, -48},
    { 1584, 208, 168},
    { 1864, 432, 16},
    { 1992, 680, -152},
    { 1976, 1072, -424},
    { 1840, 840, -432},
    { 1440, 816, -680},
    { 1016, 1648, -728},
    { 832, 1448, -768},
    { 1120, 1168, -440},
    { 960, 744, -296},
    { 1328, 704, -176},
    { 1736, 824, -184},
    { 1824, 584, -64},
    { 1696, 376, -40},
    { 1632, 320, 16},
    { 1720, 384, 0},
    { 1728, 312, 48},
    { 1528, 224, -48},
    { 1160, 240, -104},
    // 372 seconds
    { 936, -512, -56},
    { 896, -552, 8},
    { 600, -424, -240},
    { 928, -8, -424},
    { 1248, 16, -200},
    { 1616, 184, 16},
    { 1664, 352, -104},
    { 1712, 552, -320},
    { 1880, 744, -280},
    { 1920, 1176, -360},
    { 1672, 808, -376},
    { 1240, 1072, -552},
    { 712, 1544, -472},
    { 832, 1296, -416},
    { 896, 1216, -352},
    { 776, 880, -328},
    { 1096, 848, -200},
    { 1680, 992, -112},
    { 1944, 688, -16},
    { 1760, 384, -72},
    { 1680, 368, -72},
    { 1712, 448, -88},
    { 1712, 368, 8},
    { 1624, 304, 40},
    { 1328, 272, -88},
    // 373 seconds
    { 984, -968, 128},
    { 808, -488, 136},
    { 648, -376, -416},
    { 992, -112, -296},
    { 1288, 24, -120},
    { 1608, 104, 72},
    { 1800, 408, 8},
    { 1848, 760, -336},
    { 1848, 1008, -352},
    { 1768, 1032, -248},
    { 1608, 728, -448},
    { 1096, 1352, -560},
    { 776, 1304, -648},
    { 840, 1080, -472},
    { 976, 1072, -464},
    { 1040, 608, -264},
    { 1432, 720, -224},
    { 1744, 776, -80},
    { 1784, 480, 32},
    { 1648, 328, -64},
    { 1584, 360, -48},
    { 1592, 352, -24},
    { 1616, 312, 48},
    { 1464, 296, -80},
    { 1288, 264, -48},
    // 374 seconds
    { 1024, -656, 48},
    { 432, -360, -128},
    { 592, -336, -456},
    { 896, -64, -184},
    { 1200, 208, 0},
    { 1648, 176, 88},
    { 1904, 480, -144},
    { 1936, 792, -224},
    { 1872, 1296, -304},
    { 1728, 520, -304},
    { 1536, 664, -496},
    { 984, 1344, -488},
    { 728, 1288, -456},
    { 768, 1312, -368},
    { 976, 912, -368},
    { 1304, 720, -200},
    { 1552, 752, -184},
    { 1784, 640, -104},
    { 1712, 448, -32},
    { 1608, 368, 8},
    { 1624, 368, -80},
    { 1800, 336, 40},
    { 1536, 232, 104},
    { 1280, 280, -32},
    { 1120, -456, 72},
    // 375 seconds
    { 824, -608, 88},
    { 608, -536, -312},
    { 1072, -64, -384},
    { 1608, 120, -392},
    { 1656, 288, 96},
    { 1640, 232, 112},
    { 1736, 400, 32},
    { 1776, 1008, -344},
    { 1744, 968, -296},
    { 1552, 800, -312},
    { 1240, 968, -320},
    { 936, 984, -464},
    { 808, 992, -392},
    { 1008, 1456, -632},
    { 976, 856, -304},
    { 1312, 728, -168},
    { 1688, 808, -120},
    { 1712, 592, -72},
    { 1616, 384, 32},
    { 1520, 376, -56},
    { 1568, 376, 48},
    { 1720, 400, 96},
    { 1600, 280, 168},
    { 1328, 272, 104},
    { 1136, -768, 192},
    // 376 seconds
    { 328, -352, 128},
    { 488, -696, -40},
    { 1040, 0, -112},
    { 1208, 240, -80},
    { 1448, 232, 88},
    { 1608, 256, 96},
    { 1808, 496, -224},
    { 1880, 792, -176},
    { 1904, 1056, -352},
    { 1752, 592, -312},
    { 1408, 1064, -592},
    { 760, 1400, -896},
    { 752, 1264, -616},
    { 1024, 1168, -368},
    { 1016, 624, -224},
    { 1416, 760, -208},
    { 1888, 840, -88},
    { 1792, 456, 24},
    { 1680, 320, -16},
    { 1616, 360, 0},
    { 1704, 368, 24},
    { 1624, 288, 64},
    { 1384, 216, 56},
    { 1184, 88, 24},
    { 536, -1072, 64},
    // 377 seconds
    { 616, -240, -304},
    { 632, -512, 32},
    { 1120, 120, -232},
    { 1352, 216, -128},
    { 1600, 280, 40},
    { 1784, 352, 0},
    { 1864, 568, -112},
    { 1848, 1112, -248},
    { 1784, 640, -232},
    { 1552, 696, -432},
    { 1128, 1312, -544},
    { 880, 1168, -952},
    { 800, 1144, -528},
    { 888, 1096, -400},
    { 1240, 848, -192},
    { 1840, 864, -88},
    { 2088, 592, 16},
    { 1832, 312, -48},
    { 1648, 352, -64},
    { 1680, 440, -16},
    { 1784, 360, 64},
    { 1568, 240, 120},
    { 1312, 184, 72},
    { 888, -320, 136},
    { 592, -720, 72},
    // 378 seconds
    { 536, -136, -112},
    { 736, -144, -336},
    { 960, -8, -224},
    { 1256, 224, -80},
    { 1208, 136, 168},
    { 1456, 240, 144},
    { 1816, 568, -16},
    { 2112, 856, -200},
    { 2040, 1104, -376},
    { 1624, 840, -368},
    { 1120, 800, -624},
    { 888, 1408, -648},
    { 872, 2016, -560},
    { 1072, 1064, -208},
    { 1368, 936, -192},
    { 1736, 984, -104},
    { 1952, 808, 24},
    { 1960, 792, 344},
    { 2168, 1520, 544},
    { 2680, 816, 472},
    { 2360, 760, 216},
    { 2048, 784, 104},
    { 1328, 560, -24},
    { 792, 408, -152},
    { 808, 416, 40},
    // 379 seconds
    { 696, -192, 224},
    { 360, -248, 64},
    { 544, -280, -56},
    { 560, -536, -248},
    { 272, -808, -144},
    { 128, -840, -304},
    { 88, -792, -448},
    { -16, -920, -360},
    { -8, -984, -376},
    { -8, -1128, -392},
    { 80, -1288, -464},
    { 144, -984, -616},
    { 32, -896, -696},
    { 32, -928, -768},
    { -8, -776, -872},
    { -88, -736, -920},
    { -120, -712, -864},
    { 48, -632, -904},
    { 104, -592, -880},
    { 136, -592, -808},
    { 96, -600, -752},
    { 128, -576, -752},
    { 168, -664, -744},
    { 152, -832, -720},
    { 160, -808, -704},
    // 380 seconds
    { 136, -760, -720},
    { 280, -792, -568},
    { 440, -632, -272},
    { 408, -136, -16},
    { 408, 264, 24},
    { 592, 440, -624},
    { 888, 592, -608},
    { 1264, 488, -336},
    { 1816, 696, 32},
    { 2408, 1064, 208},
    { 2680, 976, 8},
    { 2792, 1552, -424},
    { 2328, 2408, 1128},
    { 1072, 384, 648},
    { 1128, 1264, 256},
    { 576, 1496, 184},
    { 584, 1384, 152},
    { 576, 864, 168},
    { 792, 896, 216},
    { 1248, 920, 176},
    { 1800, 920, 48},
    { 1920, 672, 32},
    { 1800, 528, 48},
    { 1736, 456, 48},
    { 1680, 400, 0},
    // 381 seconds
    { 1552, 408, 48},
    { 1360, 320, 72},
    { 1360, 240, -96},
    { 1176, -936, 240},
    { 720, -472, 384},
    { 896, -296, -488},
    { 1160, -16, -344},
    { 1544, 104, -16},
    { 1592, 216, 104},
    { 1640, 408, -120},
    { 1752, 704, -96},
    { 1760, 1056, -264},
    { 1704, 880, -344},
    { 1400, 904, -216},
    { 1000, 1368, -208},
    { 712, 1248, -72},
    { 808, 1368, -144},
    { 840, 888, -104},
    { 1200, 880, -160},
    { 1720, 904, -176},
    { 1760, 632, -200},
    { 1672, 456, -168},
    { 1648, 408, -88},
    { 1696, 400, -184},
    { 1680, 264, 32},
    // 382 seconds
    { 1528, 256, 8},
    { 1272, 192, -80},
    { 744, -664, 72},
    { 936, -432, -16},
    { 760, -440, -104},
    { 1000, 0, -560},
    { 1272, 0, -224},
    { 1528, 128, -8},
    { 1632, 328, -48},
    { 1888, 664, -296},
    { 2024, 992, -440},
    { 1608, 928, -424},
    { 1224, 768, -208},
    { 832, 1736, -168},
    { 656, 1488, 144},
    { 848, 1400, 272},
    { 920, 1136, 56},
    { 1320, 896, 40},
    { 1704, 904, -40},
    { 1808, 808, -144},
    { 1640, 624, -96},
    { 1656, 536, 8},
    { 1688, 328, -32},
    { 1680, 256, -224},
    { 1552, 216, -128},
    // 383 seconds
    { 1264, 112, -216},
    { 840, -528, 280},
    { 688, -832, -224},
    { 808, -400, 144},
    { 960, 64, -640},
    { 1136, 0, -352},
    { 1536, 104, -72},
    { 1744, 312, 48},
    { 1744, 552, -240},
    { 1680, 896, -424},
    { 1576, 840, -520},
    { 1648, 696, -416},
    { 1224, 1144, -544},
    { 768, 1328, -512},
    { 712, 1304, -448},
    { 864, 1152, -440},
    { 1056, 792, -336},
    { 1352, 912, -376},
    { 1744, 880, -312},
    { 1608, 552, -224},
    { 1568, 368, -88},
    { 1592, 352, -152},
    { 1696, 392, -192},
    { 1664, 280, 24},
    { 1512, 240, 32},
    // 384 seconds
    { 1200, 232, -80},
    { 944, -552, 288},
    { 608, -424, 296},
    { 624, -256, -440},
    { 880, -96, -320},
    { 1136, 120, -80},
    { 1424, 280, 48},
    { 1496, 360, -120},
    { 1768, 592, -192},
    { 1952, 896, -560},
    { 1760, 968, -696},
    { 1360, 704, -584},
    { 1016, 1312, -816},
    { 688, 1432, -808},
    { 1000, 1408, -584},
    { 984, 880, -384},
    { 1256, 672, -248},
    { 1656, 808, -216},
    { 1800, 672, -216},
    { 1608, 448, -96},
    { 1536, 376, -112},
    { 1576, 408, -16},
    { 1512, 368, 64},
    { 1264, 280, 8},
    { 1176, 264, -72},
    // 385 seconds
    { 944, -120, 192},
    { 832, -520, 280},
    { 472, -360, -88},
    { 864, -104, -336},
    { 1200, 96, -256},
    { 1480, 200, 48},
    { 1600, 304, 72},
    { 1792, 512, -112},
    { 1936, 864, -208},
    { 1720, 1072, -648},
    { 1624, 472, -392},
    { 1280, 856, -656},
    { 840, 1192, -784},
    { 736, 1128, -728},
    { 1008, 1240, -520},
    { 1064, 744, -360},
    { 1384, 760, -264},
    { 1688, 800, -272},
    { 1632, 568, -144},
    { 1464, 432, -88},
    { 1464, 408, -72},
    { 1656, 408, -72},
    { 1752, 384, 48},
    { 1432, 264, 72},
    { 1144, 296, -80},
    // 386 seconds
    { 976, -736, 176},
    { 824, -288, 104},
    { 648, -216, -200},
    { 928, 16, -280},
    { 1048, 192, -136},
    { 1264, 232, 64},
    { 1336, 336, 16},
    { 1632, 536, -64},
    { 1992, 872, -144},
    { 1992, 1392, -480},
    { 1616, 912, -312},
    { 1160, 888, -352},
    { 816, 1136, -464},
    { 760, 1536, -560},
    { 696, 1168, -432},
    { 984, 832, -272},
    { 1368, 832, -248},
    { 1648, 704, -256},
    { 1504, 496, -112},
    { 1448, 424, -112},
    { 1632, 448, -144},
    { 1936, 472, 72},
    { 1704, 368, 152},
    { 1360, 312, 80},
    { 1080, -264, 88},
    // 387 seconds
    { 744, -384, 152},
    { 432, -352, -176},
    { 824, -56, -280},
    { 1064, 200, -360},
    { 1312, 296, -144},
    { 1368, 304, 64},
    { 1568, 456, -56},
    { 1856, 848, -168},
    { 1640, 1328, -656},
    { 1480, 752, -424},
    { 1048, 1128, -608},
    { 888, 1464, -808},
    { 864, 1152, -440},
    { 1112, 1152, -336},
    { 1056, 672, -184},
    { 1328, 776, -176},
    { 1600, 864, -192},
    { 1568, 584, -40},
    { 1480, 440, 0},
    { 1480, 384, 8},
    { 1600, 368, -40},
    { 1488, 280, 104},
    { 1264, 288, 8},
    { 1136, -8, 48},
    { 696, -696, 200},
    // 388 seconds
    { 752, -200, -232},
    { 816, -216, -88},
    { 1080, 152, -240},
    { 1448, 264, 56},
    { 1632, 312, 128},
    { 1656, 504, -72},
    { 1736, 760, -128},
    { 1752, 1184, -416},
    { 1656, 744, -288},
    { 1344, 840, -360},
    { 992, 1288, -384},
    { 672, 1440, -432},
    { 848, 1240, -344},
    { 840, 904, -304},
    { 1088, 736, -216},
    { 1456, 912, -184},
    { 1824, 840, -120},
    { 1640, 480, 56},
    { 1528, 344, -16},
    { 1536, 336, -40},
    { 1592, 384, -32},
    { 1560, 368, 136},
    { 1328, 304, 96},
    { 1112, 272, 32},
    { 936, -1024, 160},
    // 389 seconds
    { 576, -240, 32},
    { 840, -296, -264},
    { 1432, -48, 40},
    { 1416, 296, -40},
    { 1496, 280, 72},
    { 1616, 480, -64},
    { 1760, 768, -80},
    { 1704, 1328, -456},
    { 1816, 608, -304},
    { 1472, 880, -368},
    { 1120, 1112, -328},
    { 832, 960, -304},
    { 840, 1144, -568},
    { 792, 768, -432},
    { 1088, 816, -320},
    { 1568, 824, -192},
    { 1600, 536, -72},
    { 1368, 272, 40},
    { 1472, 592, 16},
    { 1616, 1080, 136},
    { 1600, 1192, 232},
    { 1504, 960, -64},
    { 1368, 880, -16},
    { 968, 856, -208},
    { 920, 1016, 288},
    // 390 seconds
    { 664, 792, -288},
    { 1016, 368, -216},
    { 912, -160, -128},
    { 664, -416, -288},
    { 512, -664, -200},
    { 200, -808, -232},
    { 176, -760, -368},
    { 64, -616, -600},
    { -40, -912, -696},
    { 24, -976, -832},
    { 88, -624, -1112},
    { -16, -672, -1200},
    { 16, -456, -1216},
    { -192, -552, -1128},
    { -288, -384, -1080},
    { -184, -248, -1104},
    { -72, -360, -968},
    { -8, -384, -840},
    { -24, -360, -784},
    { -40, -448, -784},
    { -40, -376, -776},
    { -32, -480, -824},
    { 32, -616, -864},
    { -24, -488, -1024},
    { -24, -616, -1224},
    // 391 seconds
    { -40, -440, -1256},
    { -16, -208, -1264},
    { 72, -424, -1048},
    { -8, -328, -944},
    { -104, -376, -856},
    { -176, -408, -792},
    { -160, -360, -824},
    { -224, -440, -864},
    { -200, -432, -944},
    { -120, -480, -968},
    { -128, -528, -936},
    { -128, -568, -928},
    { -160, -536, -912},
    { -192, -544, -928},
    { -208, -496, -952},
    { -232, -368, -1016},
    { -200, -400, -984},
    { -272, -288, -960},
    { -312, -232, -1000},
    { -240, -312, -984},
    { -240, -288, -936},
    { -208, -336, -944},
    { -232, -328, -960},
    { -272, -304, -960},
    { -288, -280, -968},
    // 392 seconds
    { -288, -288, -984},
    { -272, -224, -1032},
    { -280, -216, -1040},
    { -280, -248, -1000},
    { -280, -280, -984},
    { -312, -256, -992},
    { -312, -304, -976},
    { -328, -248, -976},
    { -328, -280, -960},
    { -336, -272, -968},
    { -336, -248, -984},
    { -376, -216, -968},
    { -392, -200, -928},
    { -392, -200, -960},
    { -416, -168, -960},
    { -400, -192, -960},
    { -376, -184, -976},
    { -352, -248, -976},
    { -344, -216, -992},
    { -336, -232, -992},
    { -328, -240, -1000},
    { -328, -248, -976},
    { -336, -264, -968},
    { -344, -232, -976},
    { -336, -264, -968},
    // 393 seconds
    { -352, -224, -960},
    { -352, -224, -968},
    { -344, -248, -968},
    { -336, -256, -944},
    { -344, -264, -944},
    { -352, -240, -952},
    { -352, -192, -928},
    { -352, -192, -944},
    { -392, -104, -1016},
    { -392, -56, -992},
    { -424, 16, -1016},
    { -408, -32, -968},
    { -408, -48, -968},
    { -424, -24, -984},
    { -432, -40, -928},
    { -400, -72, -928},
    { -368, -128, -1008},
    { -304, -88, -1000},
    { -224, -80, -888},
    { -216, 112, -784},
    { -344, 376, -736},
    { -360, 680, -600},
    { -488, 824, -416},
    { -496, 864, -336},
    { -512, 888, -352},
    // 394 seconds
    { -400, 752, -280},
    { -496, 808, -264},
    { -472, 888, -312},
    { -480, 840, -224},
    { -560, 968, -160},
    { -496, 904, -240},
    { -504, 744, -168},
    { -520, 736, -96},
    { -544, 912, -56},
    { -432, 848, -64},
    { -400, 888, 48},
    { -432, 752, -16},
    { -368, 768, 312},
    { -488, 920, 496},
    { -360, 976, 464},
    { -344, 888, 368},
    { -360, 880, 472},
    { -368, 928, 288},
    { -272, 856, 328},
    { -336, 832, 272},
    { -248, 1008, 96},
    { -248, 744, 48},
    { -272, 680, 8},
    { -312, 800, 264},
    { -360, 880, 200},
    // 395 seconds
    { -288, 712, 232},
    { -320, 960, 0},
    { -320, 800, 232},
    { -288, 1008, -80},
    { -328, 816, 72},
    { -288, 888, 272},
    { -216, 952, 16},
    { -280, 1296, 96},
    { -328, 1152, 352},
    { -360, 1176, 368},
    { -408, 608, 440},
    { -488, 832, 264},
    { -280, 472, 40},
    { -104, 784, -152},
    { -176, 1104, 96},
    { -248, 1096, -32},
    { -120, 760, -168},
    { -160, 944, -144},
    { -208, 888, -128},
    { -200, 888, -152},
    { -192, 768, -120},
    { -208, 888, 8},
    { -176, 1008, 16},
    { -40, 1200, 64},
    { -64, 1040, 88},
    // 396 seconds
    { -32, 920, 104},
    { 0, 920, 80},
    { -16, 872, 56},
    { -32, 880, 64},
    { -64, 912, 64},
    { -48, 888, 72},
    { -48, 856, 80},
    { -24, 848, 64},
    { 24, 928, 40},
    { 8, 960, 32},
    { 8, 944, 48},
    { -8, 888, 48},
    { 0, 904, 56},
    { -8, 904, 48},
    { -8, 912, 24},
    { -8, 936, 40},
    { 0, 936, 48},
    { 8, 920, 32},
    { 24, 912, 40},
    { 16, 928, 56},
    { 16, 936, 56},
    { 24, 920, 48},
    { 0, 920, 48},
    { 8, 928, 32},
    { 0, 928, 32},
    // 397 seconds
    { 16, 928, 48},
    { -24, 920, 80},
    { -16, 920, 80},
    { 24, 904, 24},
    { 24, 936, 0},
    { 0, 928, 32},
    { -24, 928, 80},
    { -32, 928, 96},
    { -16, 944, 64},
    { -8, 944, 32},
    { 16, 928, 32},
    { -8, 912, 24},
    { -16, 928, 40},
    { -8, 944, 56},
    { -8, 912, 72},
    { -24, 904, 56},
    { -40, 928, 40},
    { -16, 944, 16},
    { -16, 960, 16},
    { -8, 944, 56},
    { -8, 904, 80},
    { -8, 904, 56},
    { -8, 928, 16},
    { -16, 952, 16},
    { -32, 944, 56},
    // 398 seconds
    { -16, 896, 64},
    { -8, 920, 32},
    { -8, 944, 24},
    { -8, 920, 24},
    { -32, 912, 64},
    { -40, 920, 64},
    { -16, 944, 24},
    { -24, 968, 32},
    { 0, 912, 48},
    { -16, 904, 56},
    { -8, 896, 24},
    { -48, 944, 24},
    { -56, 936, 16},
    { -64, 928, 40},
    { -32, 936, -104},
    { -184, 968, -160},
    { -408, 1000, -152},
    { -528, 1080, -104},
    { -488, 1000, -24},
    { -344, 1104, -56},
    { -280, 1048, 56},
    { 288, 944, -592},
    { 288, 432, -584},
    { 320, 72, -936},
    { 232, -80, -1136},
    // 399 seconds
    { 168, 152, -1128},
    { 48, -64, -1008},
    { -24, -120, -912},
    { -216, -24, -968},
    { -144, -64, -960},
    { -144, 24, -976},
    { -104, -72, -1040},
    { -168, -88, -1048},
    { -168, -32, -1016},
    { -200, -88, -1016},
    { -192, -40, -1008},
    { -152, -176, -1008},
    { -168, -64, -1032},
    { -152, -56, -1008},
    { -224, -80, -1080},
    { -216, -128, -1056},
    { -288, 16, -1064},
    { -232, -8, -1024},
    { -272, -112, -1040},
    { -248, -8, -968},
    { -272, -56, -984},
    { -296, -64, -1000},
    { -352, -64, -1056},
    { -424, -120, -904},
    { -376, -16, -936},
    // 400 seconds
    { -320, 0, -968},
    { -280, 32, -1016},
    { -280, -8, -1024},
    { -240, -8, -968},
    { -216, -128, -1032},
    { -520, -104, -1008},
    { 344, -152, -1152},
    { -304, -224, -1000},
    { -256, -104, -1024},
    { -232, -96, -1008},
    { -232, -184, -1000},
    { -304, -128, -1008},
    { -272, -176, -1008},
    { -280, -192, -1008},
    { -368, -200, -944},
    { -272, -208, -952},
    { -8, -176, -1104},
    { -232, -208, -984},
    { -128, -216, -1032},
    { -104, -120, -1032},
    { -136, -328, -1064},
    { -192, -24, -1048},
    { -128, -120, -1072},
    { -192, -136, -1040},
    { -264, 40, -1112},
    // 401 seconds
    { -312, -80, -984},
    { -264, -48, -992},
    { -280, -40, -992},
    { -304, -56, -1000},
    { -320, -56, -992},
    { -320, -56, -968},
    { -312, -128, -976},
    { -288, -104, -960},
    { -280, -120, -968},
    { -296, -96, -1016},
    { -328, -72, -968},
    { -224, -128, -1024},
    { -272, -120, -1016},
    { -256, -104, -1024},
    { -248, -96, -1016},
    { -264, -120, -1016},
    { -256, -136, -1032},
    { -232, -160, -1064},
    { -304, 8, -944},
    { -280, -176, -1040},
    { -280, -48, -992},
    { -272, -64, -992},
    { -272, -96, -984},
    { -280, -88, -992},
    { -288, -80, -968},
    // 402 seconds
    { -280, -104, -992},
    { -280, -88, -960},
    { -280, -88, -968},
    { -312, -64, -1024},
    { -520, -24, -944},
    { -312, 16, -1056},
    { -280, -72, -888},
    { -240, 16, -1024},
    { -272, -8, -1008},
    { -280, 8, -1016},
    { -264, 48, -1024},
    { -256, 24, -992},
    { -264, 16, -1000},
    { -240, 32, -1000},
    { -272, 16, -1008},
    { -256, 40, -976},
    { -280, 24, -992},
    { -272, 24, -1008},
    { -280, 40, -1008},
    { -272, 40, -1008},
    { -280, 32, -1000},
    { -280, 32, -1000},
    { -272, 24, -1000},
    { -264, 8, -1000},
    { -240, 0, -1000},
    // 403 seconds
    { -216, 40, -1024},
    { -176, 0, -1024},
    { -128, 32, -1040},
    { -64, -64, -1016},
    { -16, -120, -1016},
    { -16, 120, -936},
    { -112, 440, -832},
    { -160, 584, -712},
    { -224, 784, -472},
    { -280, 1224, -152},
    { -440, 904, -336},
    { -320, 536, -240},
    { -336, 840, -8},
    { -264, 960, -56},
    { -256, 1112, -88},
    { -208, 968, -64},
    { -80, 920, -72},
    { -56, 856, -16},
    { -24, 1040, -8},
    { -24, 992, -40},
    { -8, 960, -72},
    { 0, 1016, -16},
    { 8, 984, -8},
    { 16, 944, 8},
    { 32, 864, 0},
    // 404 seconds
    { 96, 904, -80},
    { 72, 936, 0},
    { 72, 912, 24},
    { 72, 904, 0},
    { 104, 880, -32},
    { 80, 904, -48},
    { 64, 936, -8},
    { 96, 928, -32},
    { 64, 944, -8},
    { 48, 936, 16},
    { 32, 888, 40},
    { 96, 944, -40},
    { 80, 936, -24},
    { 88, 912, -8},
    { 88, 928, 24},
    { 88, 904, -8},
    { 96, 936, -32},
    { 96, 936, -16},
    { 72, 928, -8},
    { 72, 920, -8},
    { 72, 912, -16},
    { 72, 928, -16},
    { 80, 904, -16},
    { 96, 904, -32},
    { 96, 920, -32},
    // 405 seconds
    { 72, 912, -24},
    { 48, 912, 0},
    { 56, 936, -32},
    { 40, 936, -40},
    { 56, 928, -40},
    { 64, 888, -40},
    { 56, 928, -64},
    { 56, 936, -32},
    { 32, 904, -8},
    { 48, 920, -40},
    { 48, 944, -48},
    { 64, 928, -32},
    { 48, 920, -40},
    { 48, 912, -40},
    { 32, 936, -24},
    { 40, 912, -40},
    { 32, 936, -64},
    { 64, 952, -56},
    { 72, 896, -16},
    { 48, 888, -24},
    { 8, 920, -40},
    { 24, 960, -80},
    { 64, 936, -72},
    { 48, 912, -32},
    { 40, 904, -32},
    // 406 seconds
    { 32, 944, -40},
    { 56, 936, -48},
    { 40, 928, -16},
    { 48, 896, -40},
    { 40, 936, -72},
    { 64, 960, -64},
    { 56, 904, -24},
    { 48, 912, -24},
    { 24, 912, -32},
    { 32, 920, -88},
    { 40, 952, -64},
    { 24, 936, -32},
    { 56, 912, -8},
    { 80, 912, -48},
    { 64, 912, -56},
    { 24, 928, -32},
    { 16, 928, -16},
    { 56, 944, -40},
    { 56, 920, -72},
    { 64, 920, -80},
    { 72, 912, -104},
    { 112, 920, -104},
    { 48, 928, -72},
    { 24, 992, -48},
    { -8, 936, -16},
    // 407 seconds
    { -48, 936, -72},
    { -24, 936, -72},
    { -16, 928, -64},
    { 0, 920, -80},
    { 0, 928, -96},
    { -16, 928, -104},
    { -88, 976, -176},
    { -232, 1056, -160},
    { -352, 1064, -32},
    { -392, 944, -112},
    { -344, 960, -88},
    { -264, 568, -208},
    { -184, 584, -336},
    { -32, 632, -608},
    { 8, 600, -776},
    { 80, 592, -848},
    { 152, 240, -1080},
    { 136, 408, -992},
    { 72, 392, -992},
    { 88, 248, -984},
    { 80, 272, -960},
    { 8, 216, -952},
    { 40, 192, -992},
    { 40, 208, -968},
    { 72, 144, -1000},
    // 408 seconds
    { 104, 152, -1008},
    { 112, 112, -1024},
    { 128, 144, -1008},
    { 152, -32, -1144},
    { 96, -216, -920},
    { 72, -32, -1088},
    { -24, 112, -1016},
    { 8, 136, -1064},
    { 96, 208, -1048},
    { 144, -232, -1016},
    { -16, -216, -992},
    { 0, -168, -1008},
    { 136, -128, -952},
    { 24, 8, -1064},
    { 152, -272, -1000},
    { 200, -248, -976},
    { 120, -112, -1048},
    { 136, -248, -1048},
    { 184, -216, -1104},
    { 200, -152, -1104},
    { 152, -224, -1080},
    { 192, -224, -1048},
    { 152, -200, -1128},
    { 184, -232, -1056},
    { 48, -240, -992},
    // 409 seconds
    { -16, -240, -952},
    { -152, -408, -880},
    { -96, -336, -856},
    { -112, -400, -856},
    { -104, -344, -768},
    { 16, -416, -688},
    { -16, -440, -664},
    { 32, -296, -432},
    { 72, -176, -272},
    { 496, 248, -432},
    { 552, 648, -640},
    { 464, 568, -384},
    { 688, 896, -440},
    { 824, 968, -592},
    { 1152, 632, -808},
    { 1456, 512, -560},
    { 1640, 664, -480},
    { 1376, 568, -304},
    { 1160, 456, -256},
    { 952, 656, -56},
    { 880, 728, 128},
    { 896, 688, 80},
    { 704, 632, -120},
    { 584, 608, -136},
    { 696, 432, -96},
    // 410 seconds
    { 856, 312, -128},
    { 1000, 376, -240},
    { 1136, 344, -144},
    { 1160, 336, -168},
    { 1240, 368, -208},
    { 1328, 440, -48},
    { 1376, 440, -176},
    { 1240, 384, -288},
    { 1272, -64, -112},
    { 776, -8, -144},
    { 624, -8, -424},
    { 952, -24, -328},
    { 920, 40, -280},
    { 848, 40, -360},
    { 736, 192, -336},
    { 672, 272, -336},
    { 776, 328, -312},
    { 848, 408, -368},
    { 840, 320, -392},
    { 1048, 552, -488},
    { 1168, 704, -528},
    { 1040, 832, -488},
    { 1152, 872, -336},
    { 800, 872, -352},
    { 704, 680, -232},
    // 411 seconds
    { 944, 656, -160},
    { 1232, 680, -224},
    { 1096, 224, -184},
    { 992, 208, -232},
    { 960, 200, -232},
    { 944, 312, -296},
    { 1024, 408, -280},
    { 1112, 376, -288},
    { 1128, 312, -272},
    { 896, 224, -328},
    { 784, 360, -400},
    { 624, 80, -328},
    { 456, -8, -336},
    { 584, 160, -440},
    { 792, 280, -408},
    { 752, 248, -368},
    { 712, 280, -408},
    { 824, 376, -296},
    { 1024, 432, -328},
    { 1184, 592, -392},
    { 1120, 696, -432},
    { 1056, 856, -488},
    { 1048, 848, -448},
    { 960, 808, -368},
    { 896, 888, -336},
    // 412 seconds
    { 720, 736, -240},
    { 832, 736, -152},
    { 1072, 712, -176},
    { 920, 448, -152},
    { 832, 272, -256},
    { 952, 264, -240},
    { 1088, 280, -256},
    { 1224, 376, -352},
    { 1336, 368, -192},
    { 1232, 400, -232},
    { 1088, 344, -280},
    { 1136, 296, -96},
    { 400, -136, -400},
    { 608, 32, -488},
    { 992, 56, -256},
    { 792, 192, -288},
    { 592, 232, -408},
    { 680, 320, -288},
    { 808, 360, -304},
    { 968, 360, -392},
    { 1264, 384, -432},
    { 1400, 864, -712},
    { 1176, 864, -432},
    { 1200, 712, -456},
    { 688, 680, -456},
    // 413 seconds
    { 720, 616, -240},
    { 800, 736, -200},
    { 896, 744, -256},
    { 824, 312, -184},
    { 840, 256, -280},
    { 1016, 232, -320},
    { 1216, 320, -296},
    { 1288, 336, -264},
    { 1328, 296, -232},
    { 1144, 288, -200},
    { 968, 288, -256},
    { 824, 264, -200},
    { 496, 112, -280},
    { 608, 184, -344},
    { 784, 264, -408},
    { 656, 232, -328},
    { 600, 192, -344},
    { 608, 256, -304},
    { 792, 288, -392},
    { 1088, 456, -488},
    { 1088, 744, -648},
    { 1136, 816, -608},
    { 1160, 544, -416},
    { 968, 536, -448},
    { 864, 800, -600},
    // 414 seconds
    { 776, 680, -416},
    { 912, 688, -336},
    { 1040, 736, -384},
    { 1008, 552, -216},
    { 872, 624, -264},
    { 1168, 856, -280},
    { 1264, 736, -208},
    { 936, 776, -320},
    { 600, 808, -376},
    { 488, 824, -368},
    { 184, 600, -320},
    { 48, 840, -552},
    { -48, 448, -408},
    { -56, 656, -744},
    { -56, 576, -496},
    { 40, 400, -640},
    { -112, 248, -640},
    { -256, 104, -608},
    { -400, 192, -768},
    { -592, 64, -872},
    { -752, 208, -1096},
    { -768, 240, -1120},
    { -872, 256, -1048},
    { -1032, 360, -992},
    { -736, 40, -704},
    // 415 seconds
    { -728, 80, -504},
    { -808, -24, -408},
    { -608, -136, -304},
    { -136, -24, -376},
    { -144, 8, -232},
    { -80, 24, -168},
    { 40, 8, -192},
    { 1384, 1448, 88},
    { 2048, 520, -248},
    { 2488, 656, -144},
    { 2656, 832, 32},
    { 2256, 1072, -320},
    { 1856, 952, -104},
    { 1552, 800, -80},
    { 1200, 568, -144},
    { 888, 448, -80},
    { 936, 600, 16},
    { 808, 832, 40},
    { 696, 1096, 112},
    { 472, 1168, -64},
    { 568, 904, -200},
    { 936, 872, -144},
    { 1232, 824, -272},
    { 1232, 584, -112},
    { 1616, 720, -144},
    // 416 seconds
    { 1880, 792, -128},
    { 1672, 584, -88},
    { 1504, 424, -64},
    { 1552, 408, -88},
    { 1512, 344, -104},
    { 1288, 184, -160},
    { 1184, 184, -80},
    { 1000, 16, 0},
    { 728, -704, 248},
    { 848, 48, -16},
    { 856, 120, -576},
    { 1296, 16, -224},
    { 1504, 288, -136},
    { 1512, 384, -72},
    { 1608, 520, -120},
    { 1680, 792, -120},
    { 1672, 1088, -240},
    { 1704, 1136, -48},
    { 1208, 1208, -48},
    { 776, 1272, -112},
    { 672, 1032, -120},
    { 744, 1360, -184},
    { 880, 1032, -112},
    { 1144, 976, -120},
    { 1600, 968, -120},
    // 417 seconds
    { 1680, 728, -96},
    { 1616, 544, -72},
    { 1640, 472, -104},
    { 1688, 424, -40},
    { 1664, 376, -8},
    { 1504, 336, 64},
    { 1120, 288, 24},
    { 864, -288, 24},
    { 888, -272, 248},
    { 608, -320, -192},
    { 760, 40, -560},
    { 1360, -96, -136},
    { 1304, 136, 104},
    { 1600, 240, 88},
    { 1896, 752, -128},
    { 1888, 1168, -416},
    { 1672, 1176, -528},
    { 1472, 664, -416},
    { 1032, 904, -600},
    { 760, 1000, -480},
    { 832, 1392, -496},
    { 776, 1072, -248},
    { 1080, 792, -256},
    { 1360, 752, -328},
    { 1352, 576, -272},
    // 418 seconds
    { 1264, 408, -256},
    { 1368, 400, -144},
    { 1576, 504, -160},
    { 1728, 440, -168},
    { 1584, 304, -104},
    { 1256, 208, -8},
    { 912, -360, 72},
    { 1000, 8, 240},
    { 664, -8, -304},
    { 784, 48, -432},
    { 1000, 32, -312},
    { 976, 128, 8},
    { 952, 256, -120},
    { 1064, 464, -224},
    { 1360, 504, -184},
    { 1752, 760, -256},
    { 1744, 1296, -416},
    { 1328, 1120, -296},
    { 1008, 800, -360},
    { 1032, 1456, -416},
    { 752, 1088, -120},
    { 800, 1016, -128},
    { 1064, 904, -152},
    { 1184, 720, -136},
    { 1144, 592, -32},
    // 419 seconds
    { 1136, 408, -96},
    { 1216, 392, 192},
    { 1360, 536, -8},
    { 1456, 448, 0},
    { 1512, 432, -136},
    { 1360, 120, -128},
    { 920, -432, -80},
    { 744, -296, -104},
    { 848, -48, -480},
    { 904, -16, -504},
    { 1144, 40, -168},
    { 1168, 152, -40},
    { 1176, 328, -216},
    { 1288, 544, -152},
    { 1432, 696, -344},
    { 1600, 1016, -288},
    { 1352, 1040, -136},
    { 1056, 1016, -152},
    { 752, 1176, -240},
    { 968, 1296, -240},
    { 880, 936, -136},
    { 1128, 904, -104},
    { 1336, 832, -88},
    { 1288, 616, -144},
    { 1224, 424, -120},
    // 420 seconds
    // elapsed: 7 minutes
    { 1200, 296, -104},
    { 1328, 344, -120},
    { 1584, 392, -120},
    { 1456, 288, 80},
    { 1400, 304, 40},
    { 1192, -224, 160},
    { 928, -552, 288},
    { 576, -72, -240},
    { 856, -48, -416},
    { 1128, 40, -240},
    { 1240, 200, -16},
    { 1360, 216, -56},
    { 1440, 416, -16},
    { 1520, 768, -112},
    { 1552, 1024, -400},
    { 1600, 800, -376},
    { 1160, 1064, -424},
    { 792, 1312, -360},
    { 752, 1272, -360},
    { 888, 1080, -328},
    { 1048, 696, -304},
    { 1368, 768, -320},
    { 1592, 720, -264},
    { 1440, 504, -104},
    { 1432, 376, -104},
    // 421 seconds
    { 1504, 336, -160},
    { 1536, 304, -72},
    { 1440, 304, 16},
    { 1288, 272, 16},
    { 976, 224, -24},
    { 696, -352, 88},
    { 856, -184, 224},
    { 656, -64, -368},
    { 920, 96, -480},
    { 1112, 240, -440},
    { 1456, 168, -64},
    { 1440, 192, 0},
    { 1592, 456, -48},
    { 1808, 920, -272},
    { 1704, 832, -512},
    { 1536, 784, -504},
    { 1160, 1160, -480},
    { 864, 1352, -608},
    { 1072, 1168, -360},
    { 752, 544, -296},
    { 1056, 608, -248},
    { 1160, 728, -288},
    { 1320, 704, -248},
    { 1432, 504, -64},
    { 1496, 400, 24},
    // 422 seconds
    { 1504, 320, -40},
    { 1608, 288, -8},
    { 1432, 224, 0},
    { 1296, 248, 0},
    { 1064, -352, 128},
    { 904, -336, -8},
    { 800, -448, 168},
    { 904, 120, -496},
    { 960, 48, -352},
    { 1296, 136, -88},
    { 1360, 344, -104},
    { 1336, 432, -256},
    { 1472, 552, -120},
    { 1744, 776, -200},
    { 1688, 1160, -192},
    { 1208, 1600, -240},
    { 672, 1400, -384},
    { 720, 1376, -304},
    { 1032, 1128, -72},
    { 1160, 848, -72},
    { 1384, 880, -112},
    { 1584, 832, -64},
    { 1512, 608, -40},
    { 1504, 480, 16},
    { 1496, 400, -24},
    // 423 seconds
    { 1528, 336, -72},
    { 1592, 320, -24},
    { 1464, 264, 8},
    { 1200, 128, 8},
    { 760, -888, 152},
    { 680, -176, 80},
    { 656, -136, -464},
    { 984, 64, -240},
    { 1328, 272, -40},
    { 1568, 192, 152},
    { 1640, 376, -112},
    { 1712, 688, -152},
    { 1600, 1064, -528},
    { 1720, 568, -424},
    { 1488, 824, -472},
    { 1016, 1208, -512},
    { 792, 1456, -640},
    { 960, 1136, -440},
    { 824, 696, -368},
    { 1080, 680, -224},
    { 1448, 880, -256},
    { 1752, 824, -152},
    { 1704, 512, -56},
    { 1600, 352, -40},
    { 1480, 312, -48},
    // 424 seconds
    { 1440, 280, -88},
    { 1408, 272, -24},
    { 1320, 272, -16},
    { 1096, -360, 168},
    { 672, -648, 216},
    { 704, -360, -112},
    { 920, -56, -304},
    { 1280, 152, -312},
    { 1504, 288, -56},
    { 1776, 240, 128},
    { 1848, 416, -16},
    { 1768, 888, -312},
    { 1656, 768, -304},
    { 1688, 536, -336},
    { 1416, 1104, -328},
    { 952, 1568, -384},
    { 696, 1168, -456},
    { 904, 1032, -408},
    { 824, 720, -384},
    { 1152, 720, -256},
    { 1648, 880, -232},
    { 1880, 648, -152},
    { 1744, 376, -72},
    { 1592, 256, -104},
    { 1560, 312, -104},
    // 425 seconds
    { 1680, 328, -56},
    { 1560, 264, 24},
    { 1416, 232, -40},
    { 1448, -424, 200},
    { 992, -1136, 576},
    { 496, -336, -1032},
    { 880, -312, -200},
    { 1440, 248, -120},
    { 1832, -32, 328},
    { 1952, 296, 48},
    { 1928, 752, -272},
    { 1592, 1160, -520},
    { 1456, 448, -360},
    { 1544, 568, -384},
    { 1256, 1264, -312},
    { 888, 1320, -392},
    { 728, 1344, -552},
    { 864, 944, -376},
    { 840, 752, -312},
    { 1160, 768, -224},
    { 1664, 896, -176},
    { 1904, 696, -112},
    { 1760, 400, -88},
    { 1672, 192, -8},
    { 1536, 264, -120},
    // 426 seconds
    { 1568, 264, -96},
    { 1336, 248, 24},
    { 1128, 200, -40},
    { 888, -648, 184},
    { 896, -336, 240},
    { 768, -304, -432},
    { 1072, 24, -320},
    { 1304, 216, -128},
    { 1520, 104, -16},
    { 1584, 248, -24},
    { 1744, 544, -160},
    { 1664, 888, -368},
    { 1608, 728, -352},
    { 1544, 624, -288},
    { 1248, 952, -224},
    { 1064, 1216, -176},
    { 792, 1320, -232},
    { 808, 1304, -296},
    { 928, 784, -256},
    { 1168, 728, -176},
    { 1648, 856, -176},
    { 1912, 528, -72},
    { 1816, 304, 0},
    { 1720, 280, -72},
    { 1704, 392, -80},
    // 427 seconds
    { 1752, 368, -32},
    { 1520, 256, 96},
    { 1224, 272, -48},
    { 1144, -144, 88},
    { 592, -960, 224},
    { 424, -536, -184},
    { 712, -312, -56},
    { 1448, 240, -640},
    { 1736, 288, -80},
    { 1872, 336, 208},
    { 1896, 432, -96},
    { 1768, 680, -384},
    { 1696, 640, -344},
    { 1736, 424, -528},
    { 1496, 1024, -600},
    { 832, 1504, -1184},
    { 672, 1496, -912},
    { 1160, 688, -544},
    { 1360, 960, -496},
    { 1360, 616, -272},
    { 1776, 768, -208},
    { 2232, 792, -176},
    { 2048, 384, 0},
    { 1760, 232, 16},
    { 1632, 280, 0},
    // 428 seconds
    { 1520, 312, 24},
    { 1424, 288, 40},
    { 1288, 200, 88},
    { 1088, 104, 72},
    { 544, -616, 200},
    { 384, -416, 72},
    { 288, -304, -344},
    { 840, 24, -328},
    { 1400, 8, -560},
    { 1512, 200, -192},
    { 1592, 408, -96},
    { 1528, 392, -128},
    { 1680, 328, -408},
    { 1960, 648, -632},
    { 1728, 864, -640},
    { 928, 1192, -408},
    { 1048, 1128, -832},
    { 848, 1048, -720},
    { 904, 1160, -512},
    { 976, 1016, -232},
    { 1344, 992, -96},
    { 1712, 720, -112},
    { 1608, 408, -96},
    { 1440, 336, -104},
    { 1480, 400, -88},
    // 429 seconds
    { 1664, 448, -88},
    { 1672, 336, 56},
    { 1448, 272, 48},
    { 1192, 128, -80},
    { 744, -864, 40},
    { 552, -464, -184},
    { 808, -480, 24},
    { 1144, 128, -136},
    { 1240, 200, -200},
    { 1232, 120, -240},
    { 1488, 112, -40},
    { 1928, 440, -304},
    { 2096, 760, -424},
    { 1920, 1136, -520},
    { 1416, 976, -624},
    { 840, 1520, -1048},
    { 608, 1392, -632},
    { 920, 1240, -440},
    { 1040, 936, -320},
    { 1552, 920, -176},
    { 2048, 792, -112},
    { 1800, 480, -112},
    { 1528, 344, -144},
    { 1520, 376, -112},
    { 1696, 312, -120},
    // 430 seconds
    { 1744, 312, 8},
    { 1512, 232, -64},
    { 1128, 128, -48},
    { 664, -912, 120},
    { 576, -600, -56},
    { 736, -360, -240},
    { 1184, 8, -192},
    { 1392, 152, -144},
    { 1592, 160, -136},
    { 1832, 288, -88},
    { 2032, 760, -136},
    { 2000, 1176, -568},
    { 2136, 504, -240},
    { 1776, 1024, -328},
    { 1176, 1456, -384},
    { 728, 1440, -488},
    { 808, 1384, -416},
    { 824, 840, -328},
    { 1296, 824, -264},
    { 1784, 840, -200},
    { 1872, 584, -144},
    { 1808, 320, -120},
    { 1608, 272, -152},
    { 1648, 280, -104},
    { 1872, 304, -56},
    // 431 seconds
    { 1608, 200, 32},
    { 1344, 184, -48},
    { 768, -728, 144},
    { 872, -376, -144},
    { 680, -512, -72},
    { 1176, -16, -248},
    { 1368, 32, -184},
    { 1424, 176, -208},
    { 1480, 328, -200},
    { 1568, 496, -224},
    { 1840, 648, -152},
    { 2064, 1072, -240},
    { 1872, 952, -112},
    { 1232, 1312, -280},
    { 704, 1472, -328},
    { 792, 1408, -16},
    { 856, 1088, 24},
    { 1120, 816, -16},
    { 1576, 824, -64},
    { 1880, 648, -80},
    { 1840, 504, -128},
    { 1704, 104, -40},
    { 1576, 248, -120},
    { 1648, 272, -240},
    { 1592, 176, -8},
    // 432 seconds
    { 1328, 104, -80},
    { 848, -528, 88},
    { 864, -528, -152},
    { 720, -464, -32},
    { 1072, -48, -368},
    { 1280, 64, -208},
    { 1336, 224, -328},
    { 1408, 296, -248},
    { 1512, 416, -232},
    { 1776, 584, -128},
    { 2008, 1000, -280},
    { 1712, 1064, -112},
    { 1072, 1224, -248},
    { 656, 1384, -280},
    { 632, 1400, -192},
    { 792, 1000, -40},
    { 1112, 896, -96},
    { 1560, 832, -72},
    { 1768, 648, -136},
    { 1632, 472, -128},
    { 1568, 392, -104},
    { 1624, 328, -80},
    { 1720, 352, -128},
    { 1632, 272, -24},
    { 1344, 192, -24},
    // 433 seconds
    { 976, -40, -64},
    { 840, -624, -16},
    { 544, -480, 80},
    { 896, -160, -576},
    { 1128, 24, -112},
    { 1240, 144, -328},
    { 1336, 192, -280},
    { 1560, 440, -232},
    { 1840, 696, -152},
    { 1984, 1192, -336},
    { 1896, 984, -128},
    { 1472, 968, -200},
    { 992, 1312, -120},
    { 792, 1424, -96},
    { 760, 1208, -64},
    { 872, 840, -40},
    { 1056, 856, -152},
    { 1368, 864, -168},
    { 1576, 648, -152},
    { 1680, 456, -112},
    { 1648, 296, -136},
    { 1656, 280, -200},
    { 1704, 288, -160},
    { 1592, 232, -56},
    { 1296, 224, -176},
    // 434 seconds
    { 1040, -688, 128},
    { 512, -640, 32},
    { 864, -152, -544},
    { 1240, -136, -128},
    { 1400, 168, -208},
    { 1456, 232, -64},
    { 1464, 488, -280},
    { 1760, 608, -168},
    { 1896, 952, -408},
    { 1824, 1128, -256},
    { 1384, 1104, -320},
    { 888, 1616, -296},
    { 512, 1448, -272},
    { 832, 1336, -192},
    { 856, 896, -152},
    { 1224, 888, -184},
    { 1808, 912, -208},
    { 1864, 520, -160},
    { 1840, 432, -56},
    { 1896, 488, -56},
    { 1760, 208, 64},
    { 1464, 248, -128},
    { 1472, 80, 16},
    { 1128, -328, 232},
    { 872, -432, 64},
    // 435 seconds
    { 840, -528, 72},
    { 840, 8, -424},
    { 1104, 8, -624},
    { 1616, 72, -128},
    { 1608, 264, -328},
    { 1592, 448, -528},
    { 1640, 600, -544},
    { 1648, 952, -592},
    { 1656, 744, -400},
    { 1288, 1008, -328},
    { 800, 1400, -592},
    { 640, 1240, -400},
    { 928, 1080, -328},
    { 1080, 784, -256},
    { 1280, 792, -240},
    { 1664, 776, -224},
    { 1632, 512, -160},
    { 1536, 336, -264},
    { 1616, 296, -160},
    { 1584, 288, -136},
    { 1632, 272, -160},
    { 1472, 168, -64},
    { 976, -320, 56},
    { 672, -408, 56},
    { 592, -360, -168},
    // 436 seconds
    { 688, -40, -320},
    { 872, 56, -448},
    { 1328, 152, -128},
    { 1344, 264, -128},
    { 1360, 368, -304},
    { 1448, 408, -352},
    { 1816, 632, -368},
    { 1720, 1088, -592},
    { 1376, 968, -576},
    { 992, 1160, -616},
    { 784, 1160, -480},
    { 968, 1200, -408},
    { 976, 760, -240},
    { 1152, 712, -232},
    { 1384, 608, -240},
    { 1312, 488, -200},
    { 1200, 304, -160},
    { 1280, 280, -264},
    { 1432, 256, -160},
    { 1512, 264, -136},
    { 1496, 224, -104},
    { 1272, 176, -144},
    { 896, -384, -104},
    { 848, -288, -24},
    { 480, -56, -448},
    // 437 seconds
    { 648, 112, -632},
    { 1040, 24, -320},
    { 1208, 56, -112},
    { 1208, 152, -232},
    { 1360, 424, -232},
    { 1648, 624, -344},
    { 1712, 976, -512},
    { 1520, 952, -248},
    { 1144, 936, -376},
    { 976, 1088, -312},
    { 1064, 1336, -360},
    { 760, 744, -216},
    { 1008, 720, -232},
    { 1304, 824, -272},
    { 1464, 632, -272},
    { 1376, 216, -200},
    { 1360, 184, -208},
    { 1440, 192, -232},
    { 1584, 264, -184},
    { 1632, 224, -112},
    { 1376, 200, -16},
    { 992, -88, -96},
    { 680, -672, -112},
    { 488, -208, -56},
    { 720, -16, -496},
    // 438 seconds
    { 904, 72, -416},
    { 1352, 184, -168},
    { 1504, 200, -72},
    { 1528, 312, -128},
    { 1728, 640, -128},
    { 1640, 1008, -520},
    { 1528, 656, -408},
    { 1328, 824, -464},
    { 1064, 1456, -520},
    { 776, 1088, -392},
    { 1024, 1072, -352},
    { 768, 600, -272},
    { 1120, 648, -304},
    { 1672, 864, -392},
    { 1776, 568, -240},
    { 1576, 264, -184},
    { 1480, 184, -152},
    { 1352, 232, -160},
    { 1408, 232, -192},
    { 1440, 200, -88},
    { 1248, 176, -72},
    { 912, -328, -40},
    { 840, -808, -88},
    { 536, -88, -192},
    { 776, 8, -504},
    // 439 seconds
    { 1072, 88, -328},
    { 1488, 168, -240},
    { 1680, 288, -80},
    { 1680, 448, -152},
    { 1760, 800, -256},
    { 1768, 696, -360},
    { 1672, 560, -448},
    { 1408, 1080, -456},
    { 904, 1344, -480},
    { 704, 1112, -448},
    { 944, 1064, -448},
    { 792, 664, -376},
    { 1080, 640, -328},
    { 1528, 752, -320},
    { 1888, 648, -168},
    { 1760, 400, -152},
    { 1616, 288, -200},
    { 1600, 296, -192},
    { 1584, 272, -104},
    { 1512, 184, -64},
    { 1312, 128, -16},
    { 896, 112, -184},
    { 536, 864, -344},
    { 352, 1008, -376},
    { 56, 120, 88},
    // 440 seconds
    { 8, 784, -968},
    { 40, 392, -776},
    { 208, 112, -792},
    { 248, -136, -496},
    { 120, -448, -552},
    { -24, -656, -512},
    { -8, -696, -600},
    { -40, -896, -584},
    { 32, -1160, -504},
    { -40, -1296, -392},
    { -160, -1176, -544},
    { 24, -752, -960},
    { -80, -680, -768},
    { 16, -512, -888},
    { 32, -304, -832},
    { -56, -584, -688},
    { 8, -544, -760},
    { 16, -568, -872},
    { 56, -496, -920},
    { -112, -672, -856},
    { -184, -768, -792},
    { -304, -736, -856},
    { -288, -720, -888},
    { -280, -440, -984},
    { -64, -384, -1048},
    // 441 seconds
    { -80, -592, -864},
    { -80, -408, -808},
    { -192, -544, -672},
    { -256, -632, -584},
    { -384, -664, -560},
    { -400, -608, -640},
    { -464, -576, -744},
    { -256, -720, -888},
    { -176, -720, -976},
    { -240, -888, -968},
    { -112, -712, -1032},
    { -272, -600, -912},
    { -288, -584, -856},
    { -160, -584, -872},
    { -88, -576, -824},
    { -48, -528, -920},
    { -40, -688, -624},
    { -16, -608, -696},
    { -8, -784, -616},
    { -96, -832, -640},
    { -88, -776, -704},
    { 192, -920, -840},
    { 104, -944, -784},
    { 296, -632, -528},
    { 472, -528, -104},
    // 442 seconds
    { 784, -256, 136},
    { 792, -120, 416},
    { 1512, 136, 200},
    { 1328, 440, 160},
    { 1536, 648, 104},
    { 1784, 776, 64},
    { 2096, 792, -64},
    { 2616, 592, -336},
    { 2544, 1280, -704},
    { 1952, 360, -256},
    { 1560, 632, -288},
    { 864, 1144, -512},
    { 680, 1336, -248},
    { 928, 1160, -176},
    { 1144, 600, -144},
    { 1144, 176, -144},
    { 1152, 16, -224},
    { 1336, -56, -184},
    { 1728, 64, -152},
    { 1952, 240, -80},
    { 1760, 176, -88},
    { 1416, -144, 48},
    { 1008, -592, 312},
    { 592, -568, -128},
    { 1064, -424, -56},
    // 443 seconds
    { 1320, -504, 48},
    { 1152, -232, -48},
    { 1128, 88, -216},
    { 1184, 168, -208},
    { 1416, 224, -176},
    { 1656, 336, -192},
    { 1744, 736, -304},
    { 1320, 912, -320},
    { 976, 816, -376},
    { 992, 920, -312},
    { 928, 816, -304},
    { 984, 512, -16},
    { 1424, 568, -16},
    { 1448, 408, -240},
    { 1344, 232, -288},
    { 1224, 128, -200},
    { 1336, 152, -168},
    { 1568, 176, -96},
    { 1672, 160, -24},
    { 1456, 96, -16},
    { 1248, -184, 48},
    { 728, -904, 264},
    { 600, 120, 8},
    { 720, -112, -344},
    { 1144, 64, -200},
    // 444 seconds
    { 1224, 192, -152},
    { 1248, -32, -24},
    { 1512, -56, -120},
    { 1816, 384, -48},
    { 1880, 880, -464},
    { 1696, 688, -232},
    { 1304, 792, -304},
    { 1024, 1120, -408},
    { 816, 1000, -400},
    { 1016, 1000, -376},
    { 1000, 608, -224},
    { 1288, 576, -184},
    { 1712, 624, -264},
    { 1784, 424, -168},
    { 1592, 144, -104},
    { 1592, 104, -96},
    { 1624, 200, -48},
    { 1560, 112, -112},
    { 1560, 80, -48},
    { 1328, 40, -8},
    { 752, -776, 256},
    { 656, -184, -64},
    { 552, -344, 16},
    { 800, 48, -176},
    { 992, 136, -216},
    // 445 seconds
    { 1296, 72, -264},
    { 1608, 136, -248},
    { 1776, 280, -184},
    { 1904, 752, -288},
    { 1920, 648, -176},
    { 1776, 608, -272},
    { 1360, 1008, -200},
    { 984, 1464, -440},
    { 1064, 1416, -440},
    { 1056, 800, -168},
    { 1232, 664, -264},
    { 1312, 640, -200},
    { 1440, 536, -160},
    { 1456, 320, -112},
    { 1472, 200, -72},
    { 1608, 192, -136},
    { 1776, 152, -40},
    { 1488, 56, 56},
    { 1376, 56, -72},
    { 1120, 32, 0},
    { 672, -664, -16},
    { 584, -432, 16},
    { 784, -72, -248},
    { 992, 32, -216},
    { 1344, 80, -112},
    // 446 seconds
    { 1576, 120, 40},
    { 1696, 408, -168},
    { 1736, 544, -264},
    { 1792, 808, -264},
    { 1704, 528, -216},
    { 1520, 1040, -176},
    { 1048, 1352, -296},
    { 856, 1400, -304},
    { 1096, 1248, -272},
    { 1216, 696, -96},
    { 1352, 600, -232},
    { 1592, 648, -216},
    { 1624, 336, -80},
    { 1536, 248, -88},
    { 1544, 216, -40},
    { 1584, 168, -96},
    { 1560, 256, -88},
    { 1376, 72, 56},
    { 1096, 64, -32},
    { 776, -312, 136},
    { 736, -496, 88},
    { 664, -368, 64},
    { 1056, 64, -320},
    { 1240, 112, -120},
    { 1424, 192, -256},
    // 447 seconds
    { 1480, 144, -232},
    { 1680, 160, -216},
    { 1952, 496, -472},
    { 2008, 704, -560},
    { 1720, 496, -576},
    { 1304, 608, -728},
    { 1152, 904, -704},
    { 1048, 1032, -648},
    { 888, 792, -504},
    { 944, 520, -256},
    { 896, 584, -240},
    { 1064, 656, -280},
    { 1352, 520, -152},
    { 1504, 392, -72},
    { 1544, 296, -56},
    { 1536, 216, -56},
    { 1464, 128, -112},
    { 1576, 112, 24},
    { 1384, 136, -8},
    { 1232, 96, -96},
    { 944, -648, 248},
    { 592, -392, 160},
    { 736, 144, -408},
    { 864, 328, -256},
    { 1008, 152, -216},
    // 448 seconds
    { 1048, -328, -88},
    { 1344, -120, -160},
    { 1792, 384, -168},
    { 2056, 904, -392},
    { 1616, 1544, -504},
    { 1288, 416, -400},
    { 1176, 656, -552},
    { 944, 760, -408},
    { 920, 1128, -384},
    { 640, 1024, -352},
    { 936, 768, -312},
    { 1216, 688, -288},
    { 1424, 528, -240},
    { 1480, 336, -184},
    { 1456, 264, -168},
    { 1472, 232, -144},
    { 1416, 216, -192},
    { 1504, 200, -112},
    { 1384, 128, -24},
    { 1056, 56, -48},
    { 984, -592, 256},
    { 648, -264, 80},
    { 664, 24, -432},
    { 928, 112, -352},
    { 1248, 32, -184},
    // 449 seconds
    { 1288, -64, -56},
    { 1368, 72, -352},
    { 1648, 552, -176},
    { 1592, 1120, -232},
    { 1232, 1096, -96},
    { 872, 784, -256},
    { 704, 776, -288},
    { 680, 1000, -240},
    { 1112, 1376, -152},
    { 1568, 1136, -8},
    { 1544, 608, -128},
    { 1424, 592, -216},
    { 1552, 712, -448},
    { 1664, 616, 16},
    { 1584, 544, -184},
    { 1816, 472, 32},
    { 1648, 544, -40},
    { 1248, 480, -232},
    { 824, 144, -264},
    { 200, -160, -88},
    { 432, -416, -1160},
    { 288, -1360, -128},
    { 640, -1456, -224},
    { 760, -800, -240},
    { 336, 512, -864},
    // 450 seconds
    { 264, -736, -560},
    { 488, -408, -288},
    { 296, -360, 352},
    { -56, 0, 328},
    { -256, 656, 112},
    { -584, 1128, -1144},
    { -184, 1800, -64},
    { -88, 896, 520},
    { 96, 432, 288},
    { 408, 408, 200},
    { 992, 144, 160},
    { 232, -3416, -280},
    { -120, -584, 560},
    { -8, -1448, -1776},
    { 536, -1048, -632},
    { 1168, -1464, -24},
    { 1088, -1704, -536},
    { 952, -1152, -416},
    { 608, -760, -456},
    { 384, -824, -504},
    { 288, -744, -440},
    { 288, -640, -464},
    { 216, -560, -528},
    { 128, -664, -504},
    { -104, -936, -680},
    // 451 seconds
    { 208, -800, -512},
    { 80, -792, -520},
    { 48, -784, -552},
    { 56, -784, -616},
    { 144, -776, -696},
    { 184, -848, -688},
    { 160, -912, -616},
    { 160, -904, -608},
    { 112, -824, -632},
    { 152, -768, -664},
    { 256, -784, -688},
    { 240, -808, -648},
    { 240, -816, -640},
    { 216, -776, -664},
    { 200, -784, -680},
    { 176, -808, -672},
    { 160, -800, -672},
    { 160, -776, -672},
    { 168, -776, -688},
    { 152, -784, -680},
    { 160, -792, -680},
    { 136, -800, -672},
    { 112, -800, -664},
    { 120, -800, -656},
    { 112, -816, -656},
    // 452 seconds
    { 120, -832, -656},
    { 144, -824, -680},
    { 136, -824, -704},
    { 152, -816, -720},
    { 128, -808, -704},
    { 112, -808, -696},
    { 88, -808, -664},
    { 96, -800, -640},
    { 88, -808, -624},
    { 80, -784, -616},
    { 48, -768, -632},
    { 48, -776, -672},
    { 56, -792, -696},
    { 64, -816, -712},
    { 56, -832, -704},
    { 32, -816, -696},
    { 40, -824, -688},
    { 40, -808, -688},
    { 48, -792, -672},
    { 56, -776, -680},
    { 64, -776, -688},
    { 72, -776, -688},
    { 64, -784, -688},
    { 104, -784, -680},
    { 168, -776, -640},
    // 453 seconds
    { 152, -736, -632},
    { 64, -696, -664},
    { 8, -704, -728},
    { 0, -704, -816},
    { 32, -712, -856},
    { 40, -736, -872},
    { 48, -760, -864},
    { 48, -728, -856},
    { 64, -680, -832},
    { 88, -664, -768},
    { 88, -552, -768},
    { 40, -392, -776},
    { -112, -360, -856},
    { -256, -400, -944},
    { -304, -552, -1064},
    { -240, -568, -1128},
    { -200, -576, -1096},
    { -200, -600, -1032},
    { -184, -632, -976},
    { -192, -568, -904},
    { -200, -520, -888},
    { -216, -520, -848},
    { -232, -512, -832},
    { -240, -528, -872},
    { -264, -536, -872},
    // 454 seconds
    { -280, -528, -864},
    { -280, -536, -880},
    { -280, -560, -864},
    { -272, -568, -888},
    { -280, -552, -888},
    { -280, -528, -888},
    { -272, -488, -880},
    { -272, -544, -888},
    { -272, -544, -880},
    { -256, -536, -872},
    { -240, -576, -872},
    { -224, -608, -856},
    { -248, -640, -888},
    { -232, -512, -888},
    { -240, -424, -896},
    { -200, -320, -912},
    { -152, -224, -848},
    { -136, -96, -920},
    { -64, -160, -840},
    { -280, -336, -824},
    { -376, -168, -840},
    { -408, 16, -712},
    { -352, 144, -416},
    { -560, 992, -288},
    { -528, 1048, -328},
    // 455 seconds
    { -768, 1176, -152},
    { -624, 1144, 224},
    { -400, 696, -120},
    { -512, 888, 160},
    { -376, 1048, 64},
    { -320, 1064, 16},
    { -280, 1080, -72},
    { -240, 912, -136},
    { -256, 648, -32},
    { -360, 960, -392},
    { -152, 912, -496},
    { -352, 896, -272},
    { -320, 840, -512},
    { -328, 768, -496},
    { -312, 856, -544},
    { -320, 896, -400},
    { -336, 824, -432},
    { -360, 896, -464},
    { -392, 752, -416},
    { -400, 776, -464},
    { -400, 712, -424},
    { -392, 672, -488},
    { -368, 576, -488},
    { -304, 472, -440},
    { -312, 608, -520},
    // 456 seconds
    { -304, 584, -320},
    { -184, 960, -408},
    { -216, 1048, -320},
    { -184, 984, -56},
    { -288, 1144, 664},
    { -264, 720, 304},
    { -200, 944, 360},
    { -136, 832, 432},
    { -64, 664, 504},
    { -64, 720, 680},
    { -24, 696, 768},
    { -64, 632, 824},
    { -80, 640, 736},
    { -32, 584, 840},
    { -24, 520, 792},
    { -8, 528, 784},
    { -16, 560, 808},
    { -32, 488, 824},
    { -32, 712, 768},
    { -24, 456, 792},
    { 0, 336, 832},
    { 8, 352, 696},
    { 16, 728, 816},
    { -32, 584, 784},
    { -16, 792, 648},
    // 457 seconds
    { -48, 928, 800},
    { -80, 688, 800},
    { -136, 840, 720},
    { -192, 952, 664},
    { -232, 1000, 552},
    { -200, 1000, 560},
    { -168, 864, 312},
    { -48, 728, -616},
    { -344, 784, -368},
    { -192, 544, -400},
    { -184, 48, -928},
    { -104, 128, -832},
    { -192, 88, -968},
    { -152, -48, -928},
    { -88, 24, -944},
    { -72, -96, -1008},
    { -88, 0, -1024},
    { -96, 56, -1040},
    { -80, -56, -1072},
    { -48, -16, -1048},
    { -64, 8, -1016},
    { -64, -24, -1000},
    { -40, -16, -984},
    { 40, -200, -976},
    { 128, -248, -928},
    // 458 seconds
    { 272, -96, -672},
    { 192, 248, -384},
    { 240, 752, -112},
    { 408, 1032, 240},
    { 64, 1224, 632},
    { -328, 1248, 752},
    { -344, 1680, 968},
    { -48, 864, 800},
    { -88, 520, 616},
    { 0, 792, 672},
    { 56, 432, 704},
    { 48, 544, 768},
    { 144, 392, 608},
    { 248, 600, 464},
    { 280, 736, 360},
    { 304, 864, 400},
    { 344, 904, 480},
    { 288, 936, 536},
    { 304, 784, 504},
    { 264, 736, 528},
    { 240, 736, 528},
    { 216, 672, 568},
    { 184, 584, 616},
    { 128, 624, 640},
    { 128, 504, 672},
    // 459 seconds
    { 168, 568, 696},
    { 232, 624, 720},
    { 304, 560, 688},
    { 336, 576, 632},
    { 352, 648, 648},
    { 344, 616, 672},
    { 288, 560, 688},
    { 256, 560, 736},
    { 216, 584, 744},
    { 216, 560, 704},
    { 224, 528, 672},
    { 256, 584, 696},
    { 288, 600, 728},
    { 280, 664, 824},
    { 208, 576, 744},
    { 152, 648, 584},
    { 136, 664, 608},
    { 144, 608, 592},
    { 144, 616, 544},
    { 168, 736, 584},
    { 160, 760, 600},
    { 112, 744, 640},
    { 72, 680, 472},
    { 64, 760, 384},
    { 24, 776, 328},
    // 460 seconds
    { 8, 832, 456},
    { -8, 848, 456},
    { 0, 784, 480},
    { 184, 648, 520},
    { 192, 648, 600},
    { 232, 720, 560},
    { 136, 752, 576},
    { 128, 800, 592},
    { 104, 872, 536},
    { 64, 904, 472},
    { 64, 928, 416},
    { 80, 768, 464},
    { 160, 664, 472},
    { 136, 640, 544},
    { 160, 560, 728},
    { 208, 400, 736},
    { 208, 336, 680},
    { 264, 264, 688},
    { 280, 472, 696},
    { 288, 640, 704},
    { 320, 544, 624},
    { 368, 696, 600},
    { 368, 712, 632},
    { 400, 792, 704},
    { 368, 784, 776},
    // 461 seconds
    { 304, 696, 784},
    { 352, 704, 776},
    { 320, 576, 712},
    { 296, 616, 728},
    { 272, 520, 664},
    { 288, 496, 608},
    { 256, 536, 632},
    { 248, 544, 624},
    { 264, 608, 680},
    { 272, 560, 720},
    { 256, 560, 728},
    { 240, 536, 736},
    { 248, 608, 744},
    { 232, 600, 720},
    { 216, 568, 720},
    { 216, 568, 696},
    { 192, 608, 664},
    { 200, 712, 672},
    { 216, 832, 624},
    { 200, 872, 512},
    { 248, 952, 432},
    { 200, 1016, 216},
    { 208, 1040, 184},
    { 200, 976, 72},
    { 192, 864, -48},
    // 462 seconds
    { 232, 832, -176},
    { 96, 904, -256},
    { 136, 488, -456},
    { 192, 312, -736},
    { 56, 240, -912},
    { 32, 232, -904},
    { -8, 240, -904},
    { -24, 296, -880},
    { -32, 208, -936},
    { -32, 176, -944},
    { -32, 256, -920},
    { -16, 160, -984},
    { 48, 152, -1048},
    { 72, -144, -1192},
    { 88, -128, -1120},
    { 184, 48, -936},
    { 416, 432, -456},
    { 248, 800, 336},
    { 72, 864, 720},
    { 48, 776, 936},
    { 504, 1160, 896},
    { 64, 920, 544},
    { -96, 536, 264},
    { 112, 824, 536},
    { 216, 824, 456},
    // 463 seconds
    { 240, 784, 576},
    { 232, 704, 536},
    { 248, 728, 496},
    { 288, 728, 488},
    { 320, 648, 472},
    { 328, 768, 552},
    { 344, 736, 568},
    { 368, 704, 560},
    { 392, 720, 568},
    { 384, 712, 608},
    { 360, 704, 576},
    { 368, 792, 584},
    { 312, 688, 608},
    { 296, 664, 600},
    { 264, 624, 632},
    { 264, 616, 656},
    { 264, 640, 640},
    { 280, 664, 632},
    { 288, 600, 616},
    { 304, 584, 616},
    { 288, 608, 608},
    { 280, 624, 624},
    { 296, 632, 632},
    { 288, 616, 648},
    { 312, 616, 616},
    // 464 seconds
    { 312, 616, 584},
    { 304, 616, 584},
    { 280, 648, 640},
    { 272, 632, 656},
    { 240, 600, 640},
    { 264, 616, 632},
    { 264, 608, 640},
    { 288, 624, 608},
    { 304, 656, 592},
    { 288, 640, 640},
    { 280, 608, 688},
    { 264, 584, 640},
    { 296, 632, 568},
    { 304, 640, 616},
    { 304, 632, 640},
    { 296, 608, 656},
    { 256, 592, 640},
    { 256, 584, 616},
    { 272, 616, 656},
    { 288, 632, 648},
    { 288, 640, 632},
    { 304, 632, 584},
    { 304, 640, 600},
    { 288, 608, 656},
    { 272, 592, 688},
    // 465 seconds
    { 264, 616, 648},
    { 280, 640, 600},
    { 296, 648, 568},
    { 312, 648, 624},
    { 280, 584, 656},
    { 256, 600, 648},
    { 256, 608, 632},
    { 280, 648, 640},
    { 296, 656, 624},
    { 296, 640, 576},
    { 280, 656, 608},
    { 264, 640, 648},
    { 240, 800, 656},
    { 248, 1008, 632},
    { 224, 1168, 616},
    { 232, 1072, 600},
    { 248, 1128, 592},
    { 176, 976, 384},
    { 184, 760, 72},
    { 64, 624, -112},
    { -48, 768, -208},
    { 48, 520, -424},
    { -8, 504, -560},
    { -64, 264, -664},
    { -168, 448, -744},
    // 466 seconds
    { -240, 240, -800},
    { -232, 448, -808},
    { -296, 448, -840},
    { -256, 440, -816},
    { -272, 488, -864},
    { -328, 416, -872},
    { -312, 480, -816},
    { -344, 408, -872},
    { -296, 512, -864},
    { -320, 504, -816},
    { -336, 424, -856},
    { -328, 456, -864},
    { -344, 496, -864},
    { -344, 496, -808},
    { -328, 464, -872},
    { -320, 528, -784},
    { -328, 472, -824},
    { -336, 496, -832},
    { -352, 512, -792},
    { -344, 472, -776},
    { -344, 488, -848},
    { -296, 408, -840},
    { -296, 440, -856},
    { -272, 416, -872},
    { -216, 384, -888},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

