/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */




// ----------------------------------------------------------------
// Sample captured: 2015-10-03 08:49:33 local
AccelRawData *activity_sample_walk_100_pbl_25531_1(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25531_1
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 200, 160, -1008},
    { 176, 136, -992},
    { 176, 136, -992},
    { 168, 152, -992},
    { 176, 136, -992},
    { 176, 136, -992},
    { 200, 136, -1000},
    { 152, 120, -984},
    { 168, 112, -976},
    { 160, 120, -1000},
    { 176, 128, -1000},
    { 144, 112, -1008},
    { 192, 112, -1008},
    { 184, 96, -1032},
    { 184, 96, -984},
    { 168, 104, -1000},
    { 168, 88, -1000},
    { 184, 104, -1000},
    { 168, 88, -1016},
    { 184, 80, -1000},
    { 168, 80, -1016},
    { 160, 88, -1024},
    { 184, 80, -1008},
    { 136, 56, -1032},
    { 184, 104, -1024},
    // 1 seconds
    { 200, -184, -912},
    { 136, -16, -1056},
    { 8, 0, -1008},
    { -80, 72, -1040},
    { -144, -72, -1192},
    { 384, 856, -1016},
    { 40, 168, -952},
    { 184, 104, -960},
    { 120, 208, -928},
    { 120, 184, -984},
    { 104, 208, -968},
    { 96, 200, -936},
    { 184, 256, -960},
    { 256, 288, -912},
    { 128, 88, -792},
    { 176, 424, -1032},
    { 32, 432, -880},
    { 96, 328, -712},
    { 232, 352, -832},
    { 264, 488, -752},
    { 352, 512, -736},
    { 240, 352, -528},
    { 248, 416, -568},
    { 432, 552, -648},
    { 384, 584, -544},
    // 2 seconds
    { 464, 616, -640},
    { 608, 792, -616},
    { 528, 648, -600},
    { 616, 648, -584},
    { 544, 472, -472},
    { 904, 944, -680},
    { 688, 472, -472},
    { 688, 312, -408},
    { 912, 728, -496},
    { 816, 480, -296},
    { 968, 960, -392},
    { 872, 912, -264},
    { 704, 632, -152},
    { 648, 576, -232},
    { 600, 728, -384},
    { 672, 496, -192},
    { 656, 384, -72},
    { 656, 456, -224},
    { 744, 488, -152},
    { 760, 560, -152},
    { 744, 544, -152},
    { 848, 616, -152},
    { 1064, 688, -128},
    { 1048, 704, -80},
    { 1176, 776, -152},
    // 3 seconds
    { 848, 720, -216},
    { 584, 408, -96},
    { 704, 344, -32},
    { 864, 512, -8},
    { 888, 488, 24},
    { 856, 416, 24},
    { 784, 368, 72},
    { 720, 336, -16},
    { 672, 312, -24},
    { 712, 328, 32},
    { 680, 368, -8},
    { 736, 360, 48},
    { 960, 304, 144},
    { 1072, 184, 112},
    { 1624, -8, 384},
    { 1528, 432, 152},
    { 1032, 464, 64},
    { 456, 800, -152},
    { 880, 224, 392},
    { 936, 448, 224},
    { 728, 320, 64},
    { 792, 648, 208},
    { 800, 600, 240},
    { 816, 416, 160},
    { 744, 152, 168},
    // 4 seconds
    { 712, 256, 112},
    { 600, 160, 104},
    { 816, 472, 48},
    { 1024, 600, 200},
    { 1264, 800, 336},
    { 1544, 880, 368},
    { 1168, 592, 280},
    { 504, 584, -56},
    { 696, 40, 152},
    { 760, 312, 232},
    { 800, 328, 344},
    { 816, 272, 304},
    { 728, 288, 104},
    { 776, 232, 144},
    { 728, 192, 176},
    { 728, 136, 144},
    { 768, 128, 168},
    { 1184, 184, 168},
    { 1304, 72, 336},
    { 1656, -48, 440},
    { 1408, 440, -24},
    { 728, 608, -320},
    { 768, 200, 48},
    { 760, 496, 176},
    { 816, 496, 192},
    // 5 seconds
    { 720, 224, 152},
    { 664, 184, 136},
    { 632, 184, 168},
    { 752, 280, 64},
    { 784, 168, 168},
    { 872, 368, 64},
    { 1208, 288, 120},
    { 1344, 296, 240},
    { 1576, 392, 216},
    { 1352, 552, 96},
    { 784, 400, -24},
    { 832, 296, -48},
    { 944, 8, 280},
    { 952, 184, 272},
    { 824, 200, 208},
    { 728, 152, 144},
    { 736, 88, 184},
    { 736, 48, 192},
    { 744, 32, 208},
    { 792, 56, 112},
    { 1072, 80, 96},
    { 1248, 104, 104},
    { 1736, -64, 320},
    { 1680, 296, 104},
    { 960, 784, -368},
    // 6 seconds
    { 648, 160, -288},
    { 560, -328, 0},
    { 608, -280, 144},
    { 760, 72, 224},
    { 904, 264, 176},
    { 864, 544, 64},
    { 792, 368, 8},
    { 824, 248, 0},
    { 864, 160, 16},
    { 1272, 152, -8},
    { 1488, 104, 160},
    { 1800, 272, 152},
    { 1328, 464, -48},
    { 704, 288, -112},
    { 1032, 152, -40},
    { 1064, -88, 112},
    { 784, -312, 192},
    { 800, 128, 168},
    { 736, 160, 184},
    { 792, 184, 152},
    { 720, 152, 144},
    { 832, 160, 72},
    { 912, 32, 184},
    { 1160, 32, 120},
    { 1216, 16, 128},
    // 7 seconds
    { 1632, -96, 232},
    { 1336, 224, 56},
    { 768, 496, -360},
    { 824, 120, -272},
    { 720, -72, -24},
    { 736, 192, 88},
    { 768, 200, 104},
    { 800, 240, 88},
    { 768, 208, 136},
    { 736, 288, 32},
    { 880, 232, 0},
    { 952, 200, 8},
    { 1248, 184, 56},
    { 1424, 216, 104},
    { 1728, 288, 184},
    { 1272, 552, 24},
    { 736, 432, -104},
    { 984, -16, -48},
    { 1088, -40, 328},
    { 992, 184, 248},
    { 856, 168, 136},
    { 776, 152, 112},
    { 704, 72, 112},
    { 648, 32, 136},
    { 648, -8, 128},
    // 8 seconds
    { 744, 0, 64},
    { 1064, 72, 56},
    { 1328, 80, 176},
    { 1744, -24, 376},
    { 1512, 296, 176},
    { 1000, 680, -264},
    { 888, 376, -88},
    { 792, 224, 112},
    { 736, 160, 160},
    { 760, 216, 120},
    { 792, 216, 128},
    { 744, 280, 104},
    { 736, 328, -16},
    { 832, 248, 64},
    { 904, 320, 16},
    { 1112, 184, 80},
    { 1312, 232, 96},
    { 1640, 216, 256},
    { 1536, 464, 160},
    { 808, 536, -112},
    { 800, 320, 8},
    { 856, 328, 64},
    { 1152, 64, 376},
    { 920, 144, 216},
    { 864, 160, 232},
    // 9 seconds
    { 560, 304, 112},
    { 528, 160, 216},
    { 424, 296, 16},
    { 704, 496, -64},
    { 872, 304, 48},
    { 960, 232, -32},
    { 1440, -56, 264},
    { 1520, 160, 248},
    { 1144, 536, -144},
    { 944, 328, -64},
    { 896, 232, 152},
    { 768, 200, 144},
    { 792, 232, 120},
    { 832, 240, 136},
    { 800, 224, 184},
    { 760, 368, 16},
    { 792, 256, 56},
    { 880, 312, 0},
    { 1032, 264, 24},
    { 1264, 304, 40},
    { 1696, 264, 232},
    { 1840, 344, 224},
    { 1096, 416, 40},
    { 680, 416, -88},
    { 960, -16, 200},
    // 10 seconds
    { 944, 160, 224},
    { 880, 120, 224},
    { 736, 112, 152},
    { 624, 64, 152},
    { 584, 48, 160},
    { 608, 80, 128},
    { 664, 80, 136},
    { 864, 72, 96},
    { 1160, 104, 136},
    { 1368, 112, 136},
    { 1696, -72, 264},
    { 1512, 280, 40},
    { 912, 632, -368},
    { 744, 208, -320},
    { 768, -72, 72},
    { 744, 112, 136},
    { 776, 224, 96},
    { 832, 296, 40},
    { 752, 336, 24},
    { 816, 272, -8},
    { 864, 232, 16},
    { 976, 232, 8},
    { 1176, 152, 48},
    { 1288, 192, 96},
    { 1744, 128, 200},
    // 11 seconds
    { 1560, 384, 104},
    { 760, 408, -48},
    { 864, 440, -288},
    { 984, 48, 304},
    { 1016, 224, 248},
    { 808, 232, 152},
    { 744, 184, 80},
    { 704, 72, 160},
    { 656, 48, 192},
    { 704, 56, 128},
    { 792, 88, -16},
    { 1016, 128, 32},
    { 1240, -32, 192},
    { 1584, -96, 224},
    { 1816, 16, 320},
    { 1096, 776, -320},
    { 640, 352, -192},
    { 696, 32, 168},
    { 800, 64, 176},
    { 840, 56, 248},
    { 880, 288, 144},
    { 760, 416, 8},
    { 744, 384, -96},
    { 808, 256, 16},
    { 944, 240, -80},
    // 12 seconds
    { 1016, 96, 64},
    { 1264, 160, 56},
    { 1512, 208, 136},
    { 1560, 328, 280},
    { 1072, 568, 72},
    { 664, 328, 32},
    { 1000, 48, 224},
    { 1048, 48, 232},
    { 952, 80, 192},
    { 808, 88, 104},
    { 736, 96, 16},
    { 704, 8, 120},
    { 680, 8, 136},
    { 688, 40, 72},
    { 760, 32, 72},
    { 1104, 112, 0},
    { 1344, 16, 192},
    { 1648, 24, 344},
    { 1656, 344, 72},
    { 1176, 640, -80},
    { 968, 520, -176},
    { 656, 0, 216},
    { 648, 88, 184},
    { 728, 96, 168},
    { 792, 224, 120},
    // 13 seconds
    { 832, 376, 56},
    { 808, 320, 48},
    { 808, 336, -32},
    { 928, 224, 72},
    { 1112, 232, 64},
    { 1192, 192, 176},
    { 1528, 616, -376},
    { 1408, 488, 120},
    { 1056, 304, -216},
    { 904, 248, 168},
    { 1048, 288, 48},
    { 984, 208, 176},
    { 872, 136, 144},
    { 744, 96, 48},
    { 664, -64, 184},
    { 632, 0, 104},
    { 600, 8, 64},
    { 640, 56, 24},
    { 880, 32, 64},
    { 1352, 112, 128},
    { 1864, 48, 320},
    { 1992, 184, 328},
    { 1280, 776, -264},
    { 688, 432, -120},
    { 704, 24, 120},
    // 14 seconds
    { 792, 88, 200},
    { 712, 56, 208},
    { 784, 120, 152},
    { 768, 312, 80},
    { 728, 296, 32},
    { 736, 272, 32},
    { 896, 288, 8},
    { 960, 224, 72},
    { 1216, 224, 56},
    { 1544, 144, 368},
    { 1712, 136, 416},
    { 1256, 752, -16},
    { 640, 688, 24},
    { 936, 448, -88},
    { 944, 104, 280},
    { 904, 16, 368},
    { 824, 32, 240},
    { 720, 80, 112},
    { 672, 16, 120},
    { 664, 16, 152},
    { 712, 56, 104},
    { 824, 16, 168},
    { 1088, 128, 104},
    { 1352, 200, 136},
    { 1744, 8, 320},
    // 15 seconds
    { 1376, 312, 112},
    { 784, 584, -80},
    { 1112, 264, -256},
    { 760, 200, 88},
    { 776, 160, 216},
    { 696, 352, 128},
    { 768, 128, 272},
    { 736, 416, -16},
    { 760, 336, 152},
    { 832, 392, 208},
    { 832, 440, 280},
    { 1096, 384, 328},
    { 1168, 432, 216},
    { 1448, 240, 264},
    { 1352, 480, 96},
    { 1008, 424, 24},
    { 928, 200, 136},
    { 968, 96, 272},
    { 920, 216, 168},
    { 720, 192, 136},
    { 600, 200, 56},
    { 640, 168, 56},
    { 648, 160, 88},
    { 656, 192, 112},
    { 696, 248, 96},
    // 16 seconds
    { 888, 216, 152},
    { 1200, 256, 208},
    { 1432, 216, 280},
    { 1608, 168, 376},
    { 1256, 504, 120},
    { 728, 656, -64},
    { 680, 288, -16},
    { 776, 136, 128},
    { 752, 24, 200},
    { 856, 128, 136},
    { 840, 256, 40},
    { 744, 328, -64},
    { 744, 248, -48},
    { 888, 248, -32},
    { 944, 320, -48},
    { 1184, 224, 72},
    { 1208, 272, 184},
    { 1728, 200, 352},
    { 1440, 536, 168},
    { 680, 512, 16},
    { 896, 416, -240},
    { 880, -272, 352},
    { 856, 56, 272},
    { 848, 224, 88},
    { 768, 96, 120},
    // 17 seconds
    { 768, 112, 88},
    { 720, 56, 152},
    { 704, 48, 160},
    { 784, 64, 104},
    { 1104, 128, 96},
    { 1312, 200, 120},
    { 1792, -48, 376},
    { 1488, 96, 160},
    { 1120, 432, -72},
    { 784, 168, 24},
    { 832, -520, 168},
    { 552, -368, 112},
    { 1128, -456, 240},
    { 1112, -424, -120},
    { 1288, -96, -240},
    { 1384, 184, -88},
    { 1352, 464, 80},
    { 1232, 424, 336},
    { 816, 880, 424},
    { 824, 1168, 664},
    { 976, 1176, 352},
    { 984, 824, 824},
    { 920, 952, 264},
    { 536, 864, 8},
    { 536, 536, 104},
    // 18 seconds
    { 544, 488, 232},
    { 376, 384, 280},
    { 608, 416, 328},
    { 328, 384, 352},
    { 320, 472, 392},
    { 328, 512, 376},
    { 376, 920, 184},
    { 472, 1496, -592},
    { 80, 992, 48},
    { 176, 1112, 480},
    { 72, 400, 488},
    { 336, 544, 184},
    { 80, 768, 360},
    { -152, 1152, 112},
    { 56, 1000, 144},
    { 120, 920, 352},
    { -32, 936, 320},
    { 128, 864, 320},
    { 272, 1104, 136},
    { 240, 928, 104},
    { 184, 1008, -48},
    { 72, 808, 256},
    { -40, 864, 40},
    { -152, 880, 48},
    { -80, 656, -64},
    // 19 seconds
    { -136, 752, -112},
    { -224, 840, -272},
    { -48, 1168, -288},
    { -88, 1320, 48},
    { -64, 1112, -64},
    { 40, 1144, -328},
    { 88, 1072, -328},
    { 64, 976, -312},
    { 56, 888, -376},
    { 104, 744, -184},
    { 64, 736, -312},
    { 24, 816, -288},
    { 8, 808, 0},
    { 72, 1024, -224},
    { 152, 1160, -288},
    { 176, 1344, -328},
    { 192, 1248, -104},
    { 72, 1032, -296},
    { 88, 872, -672},
    { 48, 664, -464},
    { 40, 680, -344},
    { 80, 800, -328},
    { 136, 712, -152},
    { 240, 888, -272},
    { 128, 864, -136},
    // 20 seconds
    { 24, 768, -184},
    { 72, 816, -400},
    { 96, 720, -328},
    { 152, 688, -208},
    { 336, 872, -312},
    { 568, 984, -120},
    { 712, 1208, -392},
    { 552, 1016, -240},
    { 600, 840, -168},
    { 672, 744, -136},
    { 656, 680, -240},
    { 568, 568, -72},
    { 544, 584, -176},
    { 544, 568, -192},
    { 584, 560, -104},
    { 632, 592, -128},
    { 680, 560, -80},
    { 816, 656, -72},
    { 960, 648, -144},
    { 944, 504, -80},
    { 1160, 336, 16},
    { 1048, 352, 48},
    { 1056, 288, -96},
    { 984, 200, -80},
    { 816, 224, 120},
    // 21 seconds
    { 728, 240, 128},
    { 792, 272, 96},
    { 784, 376, 136},
    { 768, 376, 96},
    { 768, 376, 64},
    { 800, 368, 80},
    { 984, 312, 96},
    { 1184, 304, 112},
    { 1352, 280, 144},
    { 1704, 456, 64},
    { 1096, 464, 208},
    { 928, 336, 80},
    { 992, 336, 192},
    { 1008, 320, 112},
    { 1032, 136, 240},
    { 896, 296, 80},
    { 768, 216, 136},
    { 688, 192, 136},
    { 640, 200, 64},
    { 656, 160, 104},
    { 816, 136, 136},
    { 1080, 288, 40},
    { 1352, 104, 136},
    { 1304, 104, 200},
    { 1048, 232, 8},
    // 22 seconds
    { 1040, 152, -24},
    { 960, 152, 48},
    { 792, 128, 184},
    { 856, 112, 224},
    { 928, 336, 72},
    { 856, 328, 136},
    { 816, 408, 88},
    { 896, 304, 104},
    { 976, 304, 72},
    { 1200, 208, 120},
    { 1216, 296, 96},
    { 1592, 304, 200},
    { 1368, 512, 136},
    { 904, 384, 120},
    { 1032, 184, 168},
    { 1240, 168, 232},
    { 1128, 232, 256},
    { 1032, 144, 312},
    { 912, 232, 160},
    { 816, 168, 152},
    { 728, 128, 168},
    { 672, 144, 104},
    { 656, 144, 80},
    { 784, 72, 104},
    { 928, 144, 16},
    // 23 seconds
    { 1072, 120, 0},
    { 1400, -128, 280},
    { 1256, 128, 240},
    { 1328, 240, 128},
    { 1160, 320, -32},
    { 896, 296, 88},
    { 856, 192, 184},
    { 848, 296, 112},
    { 840, 256, 160},
    { 880, 352, 144},
    { 880, 352, 40},
    { 920, 336, 24},
    { 1024, 312, 16},
    { 1272, 224, 112},
    { 1296, 256, 200},
    { 1688, 360, 192},
    { 1200, 464, 144},
    { 888, 288, 160},
    { 992, 120, 280},
    { 1176, 104, 304},
    { 944, -96, 488},
    { 952, 120, 128},
    { 816, 48, 152},
    { 712, 64, 136},
    { 640, 80, 136},
    // 24 seconds
    { 640, 96, 88},
    { 704, 32, 112},
    { 1024, 56, 96},
    { 1264, 16, 216},
    { 1704, -144, 464},
    { 1464, 336, 168},
    { 1120, 536, -208},
    { 960, 240, -16},
    { 792, -88, 168},
    { 840, 328, 80},
    { 872, 152, 208},
    { 816, 256, 128},
    { 736, 200, 136},
    { 752, 256, 40},
    { 840, 232, 48},
    { 928, 216, 64},
    { 1176, 168, 96},
    { 1240, 160, 168},
    { 1696, 144, 216},
    { 1464, 384, 120},
    { 872, 336, 176},
    { 872, 200, 120},
    { 1248, 584, -232},
    { 1008, -144, 656},
    { 768, -264, 360},
    // 25 seconds
    { 896, -16, 264},
    { 752, 232, 224},
    { 792, 456, 32},
    { 728, 224, 80},
    { 680, 88, 112},
    { 768, 56, 144},
    { 960, 136, 32},
    { 1128, 184, 40},
    { 1272, 16, 168},
    { 1504, -8, 328},
    { 1136, 432, -16},
    { 1136, 248, -88},
    { 904, 184, 80},
    { 704, 152, 152},
    { 728, 120, 184},
    { 792, 248, 160},
    { 800, 200, 208},
    { 776, 280, 96},
    { 792, 208, 120},
    { 888, 328, -16},
    { 984, 248, 48},
    { 1152, 192, 104},
    { 1184, 176, 152},
    { 1512, 160, 208},
    { 1408, 360, 192},
    // 26 seconds
    { 992, 400, 168},
    { 936, 296, 96},
    { 1072, 400, -176},
    { 960, 144, 328},
    { 944, 152, 96},
    { 832, 64, 192},
    { 784, -32, 248},
    { 728, 48, 168},
    { 696, 80, 88},
    { 768, 48, 120},
    { 896, 56, 136},
    { 1160, 104, 112},
    { 1336, 40, 232},
    { 1720, -96, 416},
    { 1360, 376, 32},
    { 936, 496, -176},
    { 632, 64, 48},
    { 704, -64, 192},
    { 752, 64, 168},
    { 752, 160, 184},
    { 792, 312, 136},
    { 760, 280, 40},
    { 800, 280, 16},
    { 904, 224, 56},
    { 976, 240, 72},
    // 27 seconds
    { 1184, 152, 112},
    { 1272, 168, 216},
    { 1616, 184, 248},
    { 1376, 312, 248},
    { 792, 376, 152},
    { 840, 272, 64},
    { 1056, 168, 32},
    { 904, -240, 480},
    { 912, 320, 16},
    { 816, 128, 120},
    { 792, 128, 168},
    { 752, 176, 64},
    { 776, 112, 120},
    { 872, 32, 160},
    { 1096, 112, 136},
    { 1304, -32, 280},
    { 1640, -160, 400},
    { 1280, 272, 144},
    { 800, 528, -128},
    { 720, 104, -40},
    { 784, 0, 216},
    { 768, 56, 224},
    { 800, 176, 120},
    { 808, 216, 120},
    { 784, 288, 32},
    // 28 seconds
    { 784, 216, 56},
    { 864, 232, -8},
    { 1016, 192, 32},
    { 1128, 152, 56},
    { 1272, 120, 128},
    { 1528, 136, 232},
    { 1464, 336, 112},
    { 920, 320, 160},
    { 784, 224, 112},
    { 936, 96, 192},
    { 920, 144, 168},
    { 776, 112, 240},
    { 800, 152, 120},
    { 768, 96, 120},
    { 768, 88, 144},
    { 736, 96, 120},
    { 784, 64, 128},
    { 968, 8, 160},
    { 1224, 128, 96},
    { 1328, 48, 200},
    { 1528, -64, 312},
    { 1064, 312, 24},
    { 896, 336, -48},
    { 1032, 128, 104},
    { 736, 104, 192},
    // 29 seconds
    { 720, 144, 168},
    { 760, 128, 152},
    { 776, 216, 120},
    { 776, 248, 72},
    { 792, 248, 16},
    { 872, 224, 0},
    { 952, 224, 8},
    { 1168, 136, 56},
    { 1232, 120, 152},
    { 1616, 192, 176},
    { 1344, 424, 136},
    { 816, 424, 112},
    { 856, 232, 112},
    { 1048, 144, 152},
    { 992, 40, 336},
    { 952, 168, 112},
    { 848, 96, 128},
    { 792, 40, 128},
    { 720, -40, 168},
    { 680, 0, 128},
    { 744, -32, 104},
    { 944, 8, 104},
    { 1216, 176, 40},
    { 1400, 0, 280},
    { 1584, 40, 232},
    // 30 seconds
    { 1176, 376, 16},
    { 1048, 336, 16},
    { 872, 224, 88},
    { 696, 128, 152},
    { 744, 56, 168},
    { 768, 192, 112},
    { 800, 248, 128},
    { 816, 296, 32},
    { 832, 240, 72},
    { 856, 304, 32},
    { 1040, 168, 120},
    { 1248, 200, 136},
    { 1280, 40, 352},
    { 1496, 64, 264},
    { 1240, 128, 144},
    { 824, 72, 192},
    { 952, 160, 24},
    { 960, -568, -96},
    { 688, -448, 256},
    { 752, -272, 64},
    { 776, -48, 48},
    { 840, 24, 104},
    { 928, 192, 104},
    { 920, 160, 248},
    { 1024, 152, 232},
    // 31 seconds
    { 1232, -8, 344},
    { 1312, 24, 216},
    { 1488, -264, 240},
    { 1192, -208, 96},
    { 856, 160, 40},
    { 848, -16, -96},
    { 800, -224, 80},
    { 712, -216, 208},
    { 792, 16, 216},
    { 760, 160, 216},
    { 784, 272, 144},
    { 760, 296, 96},
    { 712, 120, 48},
    { 792, 232, 80},
    { 936, 96, 128},
    { 1184, -64, 312},
    { 1200, 152, 280},
    { 1704, 144, 384},
    { 1312, 344, 64},
    { 904, 64, 272},
    { 912, 0, 192},
    { 840, -8, -32},
    { 720, -192, 80},
    { 800, -168, 24},
    { 776, -24, 104},
    // 32 seconds
    { 824, 16, 136},
    { 952, 152, 224},
    { 1024, 168, 224},
    { 928, 168, 208},
    { 976, 16, 280},
    { 1240, -16, 312},
    { 1176, -408, 208},
    { 1472, -376, 208},
    { 1048, 88, 136},
    { 760, 184, -376},
    { 792, -48, -88},
    { 816, -136, 208},
    { 792, -56, 216},
    { 784, 72, 80},
    { 808, 168, 48},
    { 840, 128, 144},
    { 832, 256, -72},
    { 856, 120, 32},
    { 912, 152, 8},
    { 1136, 48, 40},
    { 1248, 64, 232},
    { 1592, 32, 344},
    { 1464, 232, 200},
    { 872, 184, 336},
    { 728, 120, 104},
    // 33 seconds
    { 1000, 88, -152},
    { 904, -88, 280},
    { 840, 128, 216},
    { 984, -232, 224},
    { 768, 200, 112},
    { 728, 456, 24},
    { 760, 216, 160},
    { 808, 232, 72},
    { 1048, 192, 152},
    { 1336, 184, 240},
    { 1336, 160, 192},
    { 1464, 32, 224},
    { 1120, 168, 160},
    { 696, 272, 40},
    { 808, -104, -144},
    { 944, 264, 96},
    { 744, 160, 264},
    { 680, 160, 168},
    { 744, 168, 200},
    { 808, 328, 216},
    { 784, 312, 208},
    { 736, 280, 160},
    { 832, 376, 48},
    { 864, 384, 48},
    { 1016, 344, 104},
    // 34 seconds
    { 1136, 360, 200},
    { 1440, 304, 280},
    { 1512, 400, 232},
    { 1008, 560, 176},
    { 688, 400, 144},
    { 840, 288, 192},
    { 920, 208, 400},
    { 832, 248, 376},
    { 776, 296, 336},
    { 824, 264, 392},
    { 744, 296, 344},
    { 744, 264, 272},
    { 760, 272, 184},
    { 816, 280, 120},
    { 936, 288, 16},
    { 1112, 160, 64},
    { 1352, -232, 192},
    { 1376, 240, 200},
    { 1032, 680, -112},
    { 896, 352, -152},
    { 984, 72, 184},
    { 904, 200, 224},
    { 864, 248, 168},
    { 824, 304, 112},
    { 816, 280, 144},
    // 35 seconds
    { 776, 216, 160},
    { 672, 256, 88},
    { 832, 288, 80},
    { 968, 376, 72},
    { 1104, 344, 112},
    { 1144, 376, 112},
    { 1728, 384, 224},
    { 1448, 488, 200},
    { 768, 416, 192},
    { 872, 296, 128},
    { 968, 296, 136},
    { 968, 240, 288},
    { 968, 200, 264},
    { 896, 200, 216},
    { 816, 144, 248},
    { 744, 128, 192},
    { 672, 96, 184},
    { 680, 128, 120},
    { 808, 176, 96},
    { 1016, 200, 72},
    { 1072, 184, 80},
    { 1432, -56, 264},
    { 1168, 184, 200},
    { 976, 392, -72},
    { 1128, 408, -104},
    // 36 seconds
    { 1136, 432, 40},
    { 872, 264, -16},
    { 888, 384, 120},
    { 928, 352, 112},
    { 784, 344, 96},
    { 856, 240, 112},
    { 752, 216, 80},
    { 880, 240, 0},
    { 1088, 224, 80},
    { 1192, 208, 144},
    { 1304, 120, 272},
    { 1576, 232, 240},
    { 1128, 448, 128},
    { 872, 304, 136},
    { 1120, 56, 320},
    { 1096, 48, 336},
    { 976, 72, 232},
    { 840, 32, 184},
    { 696, 24, 152},
    { 648, 24, 104},
    { 640, -16, 136},
    { 672, 24, 120},
    { 832, 88, 80},
    { 1072, 112, 120},
    { 1256, 184, 200},
    // 37 seconds
    { 1696, -32, 512},
    { 1456, 464, 240},
    { 1000, 696, -184},
    { 976, 288, -72},
    { 728, 288, 64},
    { 792, 192, 152},
    { 856, 208, 176},
    { 792, 280, 104},
    { 744, 280, 8},
    { 800, 208, 40},
    { 872, 288, -56},
    { 1000, 184, 16},
    { 1168, 240, -16},
    { 1176, 152, 152},
    { 1576, 176, 144},
    { 1296, 408, 104},
    { 944, 368, 128},
    { 1096, 224, 56},
    { 1048, 40, 376},
    { 984, 104, 176},
    { 832, 128, 144},
    { 760, 120, 40},
    { 760, 16, 96},
    { 760, 0, 104},
    { 688, -32, 96},
    // 38 seconds
    { 688, -48, 120},
    { 872, 56, 160},
    { 1088, 192, 88},
    { 1688, -24, 416},
    { 1528, 312, 368},
    { 1280, 608, -136},
    { 1032, 472, -112},
    { 736, 520, 0},
    { 736, 160, -16},
    { 800, 88, 216},
    { 984, 24, 248},
    { 808, 200, 96},
    { 744, 368, -32},
    { 880, 256, 48},
    { 912, 264, 32},
    { 1064, 128, 168},
    { 1192, 208, 192},
    { 1312, 240, 200},
    { 1488, 368, 184},
    { 1152, 512, 176},
    { 944, 296, 152},
    { 1112, 24, -24},
    { 1016, 128, 280},
    { 920, 144, 144},
    { 816, 176, 64},
    // 39 seconds
    { 800, 80, 88},
    { 744, 8, 144},
    { 704, 16, 128},
    { 688, 0, 144},
    { 872, 8, 112},
    { 1048, 160, 72},
    { 1272, 24, 200},
    { 1496, 0, 296},
    { 1304, 304, 176},
    { 1216, 472, -120},
    { 928, 448, -96},
    { 832, -24, 328},
    { 744, 40, 176},
    { 808, 184, 120},
    { 864, 304, 64},
    { 824, 360, -16},
    { 848, 288, 8},
    { 912, 272, -16},
    { 1032, 136, 80},
    { 1136, 176, 120},
    { 1520, 80, 272},
    { 1712, 352, 104},
    { 1000, 528, 88},
    { 888, 240, 16},
    { 1472, 96, -32},
    // 40 seconds
    { 1272, 96, 336},
    { 992, 280, 136},
    { 864, 224, 16},
    { 680, 168, 16},
    { 648, 16, 104},
    { 584, -64, 136},
    { 576, -40, 128},
    { 704, 16, 104},
    { 1056, 88, 112},
    { 1272, 128, 184},
    { 1832, 56, 384},
    { 1608, 384, 224},
    { 1048, 856, -288},
    { 1016, 328, -216},
    { 688, 48, 160},
    { 816, 24, 232},
    { 768, 136, 112},
    { 784, 232, 120},
    { 768, 384, 16},
    { 840, 328, 24},
    { 864, 312, 40},
    { 960, 256, 32},
    { 1168, 200, 72},
    { 1152, 224, 112},
    { 1464, 232, 216},
    // 41 seconds
    { 1376, 448, 64},
    { 936, 376, 144},
    { 1376, 24, -200},
    { 1048, -64, 560},
    { 856, -248, 288},
    { 872, 56, 112},
    { 744, 104, 48},
    { 728, 240, 8},
    { 640, 56, 128},
    { 536, -32, 120},
    { 632, -88, 128},
    { 904, -8, 104},
    { 1128, 152, 88},
    { 1672, -24, 384},
    { 1712, 288, 248},
    { 1240, 880, -32},
    { 1080, 296, -64},
    { 1016, -280, 560},
    { 744, -224, 240},
    { 728, 32, 112},
    { 872, 280, 104},
    { 872, 464, 16},
    { 864, 392, -48},
    { 888, 272, 32},
    { 960, 232, 56},
    // 42 seconds
    { 1080, 72, 184},
    { 1208, 136, 200},
    { 1464, 64, 384},
    { 1592, 256, 248},
    { 1080, 400, 144},
    { 984, 240, 128},
    { 1184, -144, 272},
    { 920, -232, 392},
    { 984, 24, 192},
    { 776, 88, 120},
    { 720, 120, 96},
    { 696, 24, 136},
    { 616, 32, 104},
    { 680, 0, 128},
    { 784, 16, 112},
    { 1104, 128, 72},
    { 1200, 128, 160},
    { 1688, -80, 344},
    { 1488, 304, 152},
    { 1256, 512, -88},
    { 1008, 320, -80},
    { 696, 328, 104},
    { 744, 32, 192},
    { 792, 120, 160},
    { 824, 232, 152},
    // 43 seconds
    { 784, 248, 112},
    { 784, 296, 24},
    { 840, 280, 0},
    { 920, 216, 32},
    { 1144, 176, 80},
    { 1208, 200, 80},
    { 1584, 176, 136},
    { 1568, 344, 88},
    { 1008, 256, 176},
    { 1000, 168, 104},
    { 1176, 80, -80},
    { 824, -96, 408},
    { 816, 112, 304},
    { 832, 224, 144},
    { 856, 144, 144},
    { 880, 152, 176},
    { 816, 80, 152},
    { 720, 32, 128},
    { 720, -8, 96},
    { 896, 32, 24},
    { 1112, 32, 128},
    { 1608, -120, 408},
    { 1648, 128, 408},
    { 1168, 752, -160},
    { 928, 352, 16},
    // 44 seconds
    { 856, -72, 248},
    { 904, 328, 184},
    { 856, 184, 120},
    { 824, 272, 80},
    { 800, 336, 40},
    { 768, 344, 56},
    { 880, 216, 104},
    { 880, 248, 56},
    { 1120, 200, 120},
    { 1192, 296, 88},
    { 1496, 232, 184},
    { 1608, 384, 240},
    { 1152, 432, 192},
    { 952, 224, 144},
    { 1432, 328, -72},
    { 1200, -104, 384},
    { 1104, 64, 176},
    { 904, 64, 160},
    { 768, 40, 120},
    { 688, -24, 128},
    { 648, -24, 112},
    { 624, -32, 96},
    { 776, -40, 96},
    { 1080, 8, 88},
    { 1200, 32, 200},
    // 45 seconds
    { 1704, -24, 368},
    { 1600, 408, 112},
    { 1328, 528, 72},
    { 984, 264, 160},
    { 768, 112, 224},
    { 760, -8, 200},
    { 824, 40, 168},
    { 816, 216, 144},
    { 784, 376, 32},
    { 784, 328, -8},
    { 872, 312, -16},
    { 1032, 256, 16},
    { 1152, 256, 40},
    { 1176, 88, 168},
    { 1680, -8, 312},
    { 1616, 280, 240},
    { 1000, 440, 56},
    { 1048, 192, 120},
    { 1048, -216, 384},
    { 1032, -64, 224},
    { 896, 56, 152},
    { 784, 0, 144},
    { 696, 32, 56},
    { 608, 8, 80},
    { 536, -48, 80},
    // 46 seconds
    { 776, 0, 80},
    { 912, 144, 48},
    { 1096, 208, 80},
    { 1400, 40, 288},
    { 1808, -248, 392},
    { 1456, 464, 0},
    { 1096, 608, -160},
    { 840, 288, 72},
    { 744, -72, 288},
    { 744, -136, 256},
    { 784, 104, 176},
    { 816, 336, 16},
    { 784, 392, -72},
    { 824, 304, -48},
    { 952, 184, 136},
    { 1136, 440, 80},
    { 1264, 328, 184},
    { 1256, 152, 344},
    { 1592, 160, 312},
    { 1224, 328, 144},
    { 960, 280, 160},
    { 1168, 232, 128},
    { 1152, 80, 352},
    { 1032, 80, 264},
    { 872, 64, 168},
    // 47 seconds
    { 752, 32, 144},
    { 616, 16, 144},
    { 576, -8, 136},
    { 608, 48, 24},
    { 728, -40, 88},
    { 952, 56, 16},
    { 1160, 120, 16},
    { 1656, -88, 352},
    { 1664, 128, 312},
    { 1488, 552, -72},
    { 1032, 432, -48},
    { 696, 168, 104},
    { 688, -8, 192},
    { 760, 40, 296},
    { 880, 160, 296},
    { 808, 472, 112},
    { 760, 480, -8},
    { 848, 368, 0},
    { 992, 208, 72},
    { 1160, 160, 144},
    { 1128, 200, 168},
    { 1544, 192, 216},
    { 1448, 344, 200},
    { 1192, 288, 288},
    { 1168, 168, 200},
    // 48 seconds
    { 1336, -40, 192},
    { 840, -128, 312},
    { 864, 64, 88},
    { 864, -8, 184},
    { 760, 40, 128},
    { 664, 16, 120},
    { 592, 0, 104},
    { 608, -16, 120},
    { 864, 8, 24},
    { 1152, 152, 0},
    { 1240, -48, 296},
    { 1544, -32, 360},
    { 1592, 240, 256},
    { 1384, 560, -40},
    { 928, 400, 24},
    { 704, 32, 184},
    { 768, 112, 144},
    { 808, 128, 200},
    { 816, 312, 104},
    { 760, 432, 0},
    { 840, 344, 56},
    { 848, 232, 104},
    { 1008, 72, 216},
    { 1152, 248, 120},
    { 1112, 232, 232},
    // 49 seconds
    { 1680, 280, 200},
    { 1496, 416, 296},
    { 1056, 288, 192},
    { 1080, 96, -88},
    { 888, -96, 368},
    { 832, 80, 200},
    { 760, 104, 160},
    { 704, -16, 192},
    { 632, 40, 80},
    { 592, 32, 232},
    { 704, 48, 216},
    { 768, 176, 168},
    { 1040, 224, 208},
    { 1120, 224, 248},
    { 1424, 112, 312},
    { 1504, 88, 416},
    { 1256, 536, 128},
    { 1000, 424, -32},
    { 760, 184, 80},
    { 720, 24, 256},
    { 784, 136, 176},
    { 816, 184, 168},
    { 808, 312, 72},
    { 776, 296, 32},
    { 832, 280, 16},
    // 50 seconds
    { 864, 200, 32},
    { 1104, 104, 144},
    { 1168, 192, 136},
    { 1120, 168, 224},
    { 1664, 312, 208},
    { 1208, 464, 296},
    { 992, 320, 168},
    { 1104, 160, 208},
    { 1080, 96, 312},
    { 992, 144, 136},
    { 896, 32, 168},
    { 792, 8, 128},
    { 688, 0, 88},
    { 616, 0, 120},
    { 632, -48, 104},
    { 760, -16, 80},
    { 1016, 80, 64},
    { 1240, -24, 264},
    { 1712, -64, 432},
    { 1672, 312, 280},
    { 1360, 584, -48},
    { 816, 336, -16},
    { 616, -56, 216},
    { 728, 48, 184},
    { 736, 160, 184},
    // 51 seconds
    { 800, 272, 168},
    { 832, 336, 136},
    { 832, 344, 48},
    { 888, 296, 64},
    { 1024, 256, 64},
    { 1184, 152, 168},
    { 1128, 136, 232},
    { 1528, 184, 272},
    { 1608, 472, 232},
    { 1104, 400, 168},
    { 1288, 144, -168},
    { 984, -136, 768},
    { 520, -568, 368},
    { 904, 8, 96},
    { 704, 0, 176},
    { 728, 152, 104},
    { 632, 96, 96},
    { 624, 64, 136},
    { 688, 64, 128},
    { 856, 80, 120},
    { 1104, 224, 80},
    { 1288, -8, 272},
    { 1648, -64, 400},
    { 1336, 288, 224},
    { 1224, 480, -120},
    // 52 seconds
    { 936, 432, -24},
    { 776, 128, 144},
    { 784, 168, 128},
    { 808, 160, 192},
    { 816, 280, 72},
    { 776, 216, 120},
    { 824, 272, 48},
    { 880, 248, 40},
    { 1000, 224, 72},
    { 1160, 216, 88},
    { 1208, 136, 248},
    { 1672, 232, 280},
    { 1416, 376, 280},
    { 984, 368, 232},
    { 1216, 400, 24},
    { 1064, -40, 408},
    { 992, 80, 184},
    { 872, 80, 192},
    { 768, 8, 192},
    { 672, 0, 160},
    { 600, -16, 104},
    { 592, -24, 96},
    { 648, -32, 120},
    { 1016, 40, 80},
    { 1312, 8, 232},
    // 53 seconds
    { 1704, -8, 392},
    { 1840, 240, 264},
    { 1272, 736, -64},
    { 944, 576, 16},
    { 696, 64, 192},
    { 760, -48, 264},
    { 736, -48, 200},
    { 784, 160, 128},
    { 752, 296, 72},
    { 768, 344, 8},
    { 840, 232, 72},
    { 936, 232, 64},
    { 1024, 176, 88},
    { 1168, 208, 56},
    { 1288, 104, 240},
    { 1712, 232, 256},
    { 1400, 416, 208},
    { 904, 312, -48},
    { 920, -32, 216},
    { 936, 40, 224},
    { 928, 240, 88},
    { 864, 56, 192},
    { 752, 88, 64},
    { 664, 0, 104},
    { 640, -40, 168},
    // 54 seconds
    { 672, 16, 104},
    { 752, 16, 120},
    { 984, 120, 48},
    { 1120, 136, 80},
    { 1752, 40, 344},
    { 1616, 208, 360},
    { 1248, 688, -120},
    { 936, 480, -168},
    { 688, 264, 64},
    { 696, 112, 184},
    { 704, -8, 240},
    { 744, 176, 176},
    { 760, 224, 136},
    { 792, 320, 32},
    { 840, 312, 40},
    { 904, 320, 32},
    { 1136, 280, 48},
    { 1192, 176, 112},
    { 1464, 144, 168},
    { 1632, 272, 152},
    { 1152, 368, 208},
    { 920, 224, 160},
    { 1008, 280, 64},
    { 952, 264, 136},
    { 736, 0, 336},
    // 55 seconds
    { 888, 176, 96},
    { 808, 136, 184},
    { 784, 224, 120},
    { 744, 96, 120},
    { 664, 0, 160},
    { 736, -16, 136},
    { 920, 16, 104},
    { 1040, 104, 104},
    { 1192, 80, 104},
    { 1560, -176, 408},
    { 1592, 264, 256},
    { 1184, 640, -152},
    { 752, 336, -56},
    { 712, -32, 224},
    { 760, 112, 136},
    { 808, 80, 224},
    { 864, 296, 112},
    { 832, 336, 32},
    { 808, 368, -40},
    { 848, 328, -56},
    { 1016, 112, 104},
    { 1224, 152, 184},
    { 1160, 176, 248},
    { 1704, 232, 256},
    { 1480, 416, 232},
    // 56 seconds
    { 928, 296, 176},
    { 1104, 72, -48},
    { 896, -200, 368},
    { 920, 216, 128},
    { 872, 224, 96},
    { 800, 96, 136},
    { 720, 80, 112},
    { 648, 0, 144},
    { 688, -16, 144},
    { 784, 0, 144},
    { 928, 80, 112},
    { 1048, 136, 48},
    { 1248, 0, 160},
    { 1728, -208, 480},
    { 1280, 432, 152},
    { 1272, 488, -80},
    { 864, 264, 24},
    { 720, -32, 176},
    { 720, 72, 112},
    { 768, 184, 168},
    { 816, 280, 120},
    { 832, 344, 40},
    { 928, 296, 96},
    { 896, 248, 24},
    { 920, 184, 48},
    // 57 seconds
    { 1160, 184, 120},
    { 1136, 176, 216},
    { 1480, 80, 368},
    { 1528, 224, 320},
    { 1048, 248, 344},
    { 1176, 104, 88},
    { 976, 32, 120},
    { 688, 288, 152},
    { 816, 144, 176},
    { 744, 8, 200},
    { 904, 24, 168},
    { 704, 112, 80},
    { 720, 80, 96},
    { 776, 80, 168},
    { 888, 64, 152},
    { 1064, 152, 96},
    { 1096, 128, 176},
    { 1576, -48, 336},
    { 1552, 176, 336},
    { 1248, 600, 24},
    { 912, 512, -120},
    { 648, 120, -8},
    { 720, 104, 192},
    { 704, 112, 216},
    { 736, 128, 200},
    // 58 seconds
    { 800, 216, 120},
    { 784, 240, 56},
    { 768, 216, 96},
    { 832, 312, 0},
    { 1064, 224, 56},
    { 1248, 264, 72},
    { 1448, 176, 184},
    { 1656, 328, 184},
    { 1144, 512, 144},
    { 880, 328, 120},
    { 1056, 200, 208},
    { 1048, 160, 256},
    { 760, -56, 48},
    { 840, 80, 168},
    { 752, -8, 176},
    { 712, 64, 80},
    { 648, 88, 72},
    { 728, 56, 128},
    { 840, 80, 120},
    { 1000, 168, 48},
    { 1048, 208, 64},
    { 1608, -64, 336},
    { 1496, 144, 280},
    { 1240, 472, -32},
    { 1008, 216, -96},
    // 59 seconds
    { 752, 160, 80},
    { 688, 96, 120},
    { 688, 192, 128},
    { 720, 232, 88},
    { 752, 176, 160},
    { 816, 232, 112},
    { 808, 320, 0},
    { 912, 304, 0},
    { 1080, 296, 16},
    { 1200, 208, 120},
    { 1400, 216, 192},
    { 1712, 216, 200},
    { 1152, 384, 144},
    { 1040, 176, 256},
    { 1192, -40, 248},
    { 1040, -8, 0},
    { 744, -640, 288},
    { 496, -296, 16},
    { 768, 168, 104},
    { 816, 328, 120},
    { 720, 224, 152},
    { 744, 296, 56},
    { 800, 240, 112},
    { 896, 200, 168},
    { 952, 296, 80},
    // 60 seconds
    // elapsed: 1 minutes
    { 1024, 176, 184},
    { 1784, -112, 424},
    { 1584, 344, 256},
    { 1064, 544, -24},
    { 1080, -56, -40},
    { 840, 272, 120},
    { 896, 304, 312},
    { 912, 520, 208},
    { 896, 512, 336},
    { 920, 704, 264},
    { 896, 856, 184},
    { 896, 864, 208},
    { 864, 864, 64},
    { 776, 776, 96},
    { 608, 728, -48},
    { 536, 712, -96},
    { 424, 624, -144},
    { 312, 568, -144},
    { 272, 776, -200},
    { 216, 624, -216},
    { 160, 664, -248},
    { 112, 720, -296},
    { 56, 768, -408},
    { 48, 1048, -408},
    { -96, 816, -416},
    // 61 seconds
    { -144, 760, -520},
    { -96, 960, -600},
    { -120, 896, -512},
    { -176, 744, -520},
    { -136, 688, -584},
    { -128, 856, -744},
    { -136, 760, -808},
    { -176, 616, -768},
    { -176, 440, -872},
    { -72, 584, -824},
    { -96, 200, -864},
    { -88, 232, -904},
    { -64, 144, -952},
    { 64, 184, -904},
    { 120, 288, -912},
    { 80, 120, -976},
    { 136, 168, -976},
    { 80, 112, -1000},
    { 160, 160, -992},
    { 144, 80, -1048},
    { 176, 104, -1008},
    { 136, -48, -992},
    { 184, 72, -1040},
    { 168, -8, -984},
    { 216, 80, -992},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-03 08:50:51 local
AccelRawData *activity_sample_walk_100_pbl_25531_2(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25531_2
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 104, -56, -1040},
    { 144, -88, -1016},
    { 136, -88, -1016},
    { 120, -88, -1008},
    { 136, -88, -1016},
    { 120, -88, -1032},
    { 128, -112, -1016},
    { 112, -112, -1016},
    { 112, -128, -1000},
    { 96, -136, -1008},
    { 104, -128, -1000},
    { 96, -144, -1032},
    { 96, -144, -1024},
    { 96, -152, -1008},
    { 80, -160, -1032},
    { 80, -160, -1016},
    { 80, -168, -1032},
    { 80, -160, -1024},
    { 48, -184, -1008},
    { 56, -184, -1016},
    { 80, -184, -1000},
    { 64, -192, -1016},
    { 64, -208, -1016},
    { 80, -200, -1016},
    { 80, -248, -1000},
    // 1 seconds
    { 56, -208, -1016},
    { 88, -208, -1032},
    { 72, -240, -1016},
    { 120, -192, -1024},
    { 32, -264, -984},
    { 104, -296, -992},
    { 0, -320, -952},
    { 0, -280, -944},
    { -56, -200, -1040},
    { 24, -392, -1048},
    { 144, -56, -992},
    { 120, -104, -1000},
    { 0, -24, -984},
    { 80, 32, -1072},
    { 8, 48, -1056},
    { 40, 0, -1000},
    { 56, 0, -1000},
    { 112, -96, -864},
    { 40, 96, -984},
    { 40, 360, -1000},
    { 24, 24, -888},
    { 64, 112, -896},
    { 272, 288, -904},
    { 200, 376, -784},
    { 136, 232, -784},
    // 2 seconds
    { 96, 504, -720},
    { 48, 360, -616},
    { 152, 512, -456},
    { 480, 800, -512},
    { 336, 760, -472},
    { 328, 728, -320},
    { 360, 608, -200},
    { 992, 968, -480},
    { 568, 616, -136},
    { 968, 960, -56},
    { 864, 712, -8},
    { 976, 696, -32},
    { 976, 728, -24},
    { 864, 536, 0},
    { 936, 480, 96},
    { 968, 584, 48},
    { 1024, 600, 120},
    { 880, 456, 128},
    { 920, 536, 24},
    { 984, 464, 88},
    { 928, 392, 96},
    { 896, 344, 72},
    { 904, 328, 40},
    { 888, 296, 128},
    { 920, 296, 64},
    // 3 seconds
    { 888, 240, 120},
    { 920, 304, 80},
    { 920, 336, 40},
    { 960, 336, 80},
    { 1008, 328, 96},
    { 1104, 312, 128},
    { 1216, 312, 144},
    { 64, 520, 504},
    { 928, 968, -136},
    { 776, 168, 64},
    { 896, 144, 40},
    { 808, 176, 128},
    { 832, 72, 200},
    { 744, 232, -32},
    { 696, 224, 0},
    { 704, 192, 96},
    { 728, 320, -32},
    { 784, 288, 72},
    { 808, 472, -40},
    { 928, 360, 24},
    { 1056, 416, 96},
    { 1520, 368, 240},
    { 1640, 544, 232},
    { 1184, 680, 136},
    { 544, 640, -96},
    // 4 seconds
    { 792, 272, 48},
    { 1072, 120, 624},
    { 960, 200, 400},
    { 832, 112, 208},
    { 832, 280, -16},
    { 856, 176, 0},
    { 760, 144, 64},
    { 760, 64, 144},
    { 736, 32, 56},
    { 912, 8, 112},
    { 1200, 152, 8},
    { 1464, 160, 152},
    { 1808, 40, 368},
    { 1400, 576, -224},
    { 640, 488, -64},
    { 560, -160, 432},
    { 728, 992, 288},
    { 800, 408, 272},
    { 880, 448, 0},
    { 656, 280, 184},
    { 616, 632, -144},
    { 672, 384, 184},
    { 832, 472, 120},
    { 920, 416, 200},
    { 1160, 304, 232},
    // 5 seconds
    { 1208, 312, 208},
    { 1416, 344, 224},
    { 1408, 824, 40},
    { 896, 664, -40},
    { 760, 280, 0},
    { 888, 72, 336},
    { 928, 80, 312},
    { 824, 136, 208},
    { 736, 184, 8},
    { 664, 128, -32},
    { 640, 72, -8},
    { 680, 104, 8},
    { 744, 64, 72},
    { 944, 152, 32},
    { 1432, 48, 248},
    { 1856, 0, 448},
    { 2000, 224, 320},
    { 1296, 632, -48},
    { 576, 608, -80},
    { 720, 400, 232},
    { 784, 80, 424},
    { 752, 264, 232},
    { 712, 168, 176},
    { 768, 400, -8},
    { 664, 312, 56},
    // 6 seconds
    { 728, 376, 16},
    { 872, 288, 128},
    { 984, 328, 104},
    { 1440, 176, 176},
    { 1304, 272, 176},
    { 1584, 328, 200},
    { 1568, 584, -16},
    { 688, 424, 8},
    { 736, 200, -160},
    { 912, 80, 136},
    { 904, 208, 304},
    { 832, 216, 112},
    { 720, 152, 112},
    { 608, 64, 200},
    { 656, 80, 160},
    { 736, 256, -80},
    { 744, 240, -16},
    { 1024, 128, 152},
    { 1352, 168, 64},
    { 1800, -24, 312},
    { 1632, 288, 112},
    { 1048, 592, -88},
    { 488, 488, 72},
    { 920, 208, 144},
    { 760, 168, 184},
    // 7 seconds
    { 688, 96, 248},
    { 768, 80, 176},
    { 736, 176, 48},
    { 664, 240, 24},
    { 720, 208, 16},
    { 776, 256, -136},
    { 864, 176, -56},
    { 1104, 240, -48},
    { 1168, 360, 24},
    { 1600, 312, 184},
    { 1656, 456, 128},
    { 904, 456, 0},
    { 872, 352, -160},
    { 968, -136, 336},
    { 840, 72, 176},
    { 776, 240, 24},
    { 768, 96, 136},
    { 696, 128, 64},
    { 696, 40, 96},
    { 664, 16, 152},
    { 712, 72, 88},
    { 880, 120, 40},
    { 1112, 168, 40},
    { 1568, 80, 184},
    { 1696, 144, 200},
    // 8 seconds
    { 1240, 488, -168},
    { 960, 288, -184},
    { 792, 48, 80},
    { 792, -56, 64},
    { 720, 152, 136},
    { 696, 160, 120},
    { 664, 312, -32},
    { 736, 200, 40},
    { 712, 328, -104},
    { 776, 256, -40},
    { 944, 232, -16},
    { 1176, 264, 24},
    { 1160, 296, 128},
    { 1736, 256, 256},
    { 1464, 440, 216},
    { 872, 432, 40},
    { 1000, 392, -336},
    { 864, -280, 512},
    { 680, -40, 280},
    { 856, 200, 72},
    { 816, 120, 104},
    { 608, 136, -80},
    { 664, 96, 80},
    { 656, 8, 144},
    { 736, 40, 96},
    // 9 seconds
    { 864, 120, 24},
    { 1112, 160, 88},
    { 1400, 56, 152},
    { 1824, -48, 344},
    { 1384, 480, 16},
    { 912, 464, -256},
    { 768, 120, -24},
    { 800, 88, 144},
    { 728, 136, 80},
    { 680, 160, 136},
    { 736, 312, -8},
    { 664, 280, 24},
    { 784, 312, 0},
    { 864, 264, 8},
    { 984, 232, 40},
    { 1200, 256, 40},
    { 1344, 184, 192},
    { 1704, 312, 128},
    { 1312, 344, 96},
    { 1104, 280, -144},
    { 952, -128, 240},
    { 872, 128, 232},
    { 824, 208, 48},
    { 728, 136, 80},
    { 680, 16, 136},
    // 10 seconds
    { 640, 16, 112},
    { 600, 16, 104},
    { 704, 48, 80},
    { 856, 32, 120},
    { 1112, 160, 72},
    { 1552, -8, 328},
    { 1888, 152, 232},
    { 1432, 656, -136},
    { 808, 408, -184},
    { 656, 24, 64},
    { 720, -80, 136},
    { 696, 152, 128},
    { 768, 216, 168},
    { 744, 296, 40},
    { 768, 144, 128},
    { 784, 272, -8},
    { 872, 240, 24},
    { 1024, 280, -48},
    { 1192, 128, 88},
    { 1848, 168, 280},
    { 1624, 392, 240},
    { 1160, 440, 48},
    { 912, 456, -296},
    { 816, -144, 216},
    { 712, 24, 192},
    // 11 seconds
    { 768, 184, 104},
    { 776, 96, 136},
    { 728, 80, 128},
    { 640, 64, 152},
    { 632, 16, 168},
    { 720, 48, 128},
    { 896, 104, 96},
    { 1176, 144, 128},
    { 1384, 32, 232},
    { 1696, -32, 280},
    { 1424, 416, -56},
    { 944, 560, -320},
    { 776, 96, -24},
    { 680, -104, 104},
    { 648, 48, 192},
    { 736, 288, 232},
    { 832, 480, 24},
    { 752, 344, 8},
    { 680, 240, 16},
    { 784, 128, 0},
    { 928, 88, 96},
    { 1224, 216, 72},
    { 1328, 248, 176},
    { 1920, 304, 280},
    { 1256, 576, 96},
    // 12 seconds
    { 856, 312, 24},
    { 992, 216, 56},
    { 856, 16, 280},
    { 696, 96, 152},
    { 824, 120, 56},
    { 784, 24, 176},
    { 728, 96, 104},
    { 680, 56, 128},
    { 664, 24, 136},
    { 848, 16, 136},
    { 1096, 72, 120},
    { 1384, 0, 256},
    { 1824, -24, 392},
    { 1160, 480, -40},
    { 864, 512, -272},
    { 1072, 208, 32},
    { 832, 240, 88},
    { 784, 240, 56},
    { 744, 192, 80},
    { 760, 240, 8},
    { 784, 160, 112},
    { 800, 280, -8},
    { 872, 224, 32},
    { 928, 216, 64},
    { 1152, 264, 8},
    // 13 seconds
    { 1288, 72, 192},
    { 1752, 184, 160},
    { 1264, 400, 80},
    { 928, 328, -144},
    { 960, 80, 16},
    { 896, 8, 256},
    { 864, 112, 144},
    { 752, 120, 120},
    { 704, 48, 152},
    { 696, 40, 112},
    { 712, 8, 136},
    { 792, 72, 144},
    { 920, 56, 144},
    { 1184, 136, 136},
    { 1264, 104, 168},
    { 1560, 0, 200},
    { 1160, 320, -112},
    { 912, 352, -104},
    { 992, 40, 56},
    { 784, 104, 56},
    { 696, 144, 80},
    { 744, 168, 96},
    { 744, 272, 40},
    { 816, 232, 72},
    { 744, 288, -8},
    // 14 seconds
    { 808, 304, 0},
    { 864, 240, 32},
    { 1144, 184, 152},
    { 1152, 200, 272},
    { 1616, 176, 296},
    { 1432, 328, 232},
    { 968, 320, 384},
    { 856, 320, 112},
    { 880, 328, 24},
    { 840, 56, 208},
    { 552, -96, 184},
    { 792, -8, 128},
    { 736, -64, 32},
    { 728, 112, 56},
    { 840, 64, 184},
    { 1144, 176, 240},
    { 1320, -80, 480},
    { 1376, -184, 432},
    { 1416, -528, 200},
    { 1424, 320, -104},
    { 864, 552, -248},
    { 856, 208, -80},
    { 776, 272, 144},
    { 728, 64, 416},
    { 752, 120, 248},
    // 15 seconds
    { 736, 160, 160},
    { 712, 200, 56},
    { 816, 136, 72},
    { 824, 192, 64},
    { 928, 232, 48},
    { 1120, 240, 64},
    { 1192, 200, 168},
    { 1464, 176, 248},
    { 1536, 280, 256},
    { 984, 480, 128},
    { 872, 248, 112},
    { 1056, 280, 48},
    { 880, 16, 168},
    { 752, 136, 168},
    { 720, 88, 128},
    { 688, 88, 136},
    { 680, 144, 56},
    { 680, 80, 96},
    { 744, 48, 120},
    { 928, 48, 112},
    { 1216, 88, 152},
    { 1408, 64, 288},
    { 1768, 72, 328},
    { 1312, 480, 8},
    { 952, 464, -120},
    // 16 seconds
    { 768, 136, 16},
    { 720, 24, 256},
    { 752, 48, 152},
    { 736, 184, 104},
    { 792, 272, 56},
    { 760, 280, -24},
    { 728, 248, -32},
    { 824, 248, -48},
    { 952, 184, 24},
    { 1112, 168, 72},
    { 1192, 184, 144},
    { 1800, 176, 280},
    { 1472, 552, 144},
    { 936, 488, 88},
    { 1016, 264, -248},
    { 816, -296, 552},
    { 832, 32, 240},
    { 864, 232, -40},
    { 872, 72, 112},
    { 736, 104, 64},
    { 632, 96, 32},
    { 640, 16, 72},
    { 736, 48, 88},
    { 944, 40, 80},
    { 1248, 48, 168},
    // 17 seconds
    { 1536, 88, 200},
    { 1832, 104, 344},
    { 1128, 608, -64},
    { 872, 408, -160},
    { 848, 144, 24},
    { 736, -48, 240},
    { 728, 40, 168},
    { 760, 224, 56},
    { 784, 376, -64},
    { 712, 280, 8},
    { 808, 280, -16},
    { 896, 240, -8},
    { 1072, 216, 40},
    { 1152, 248, 96},
    { 1648, 232, 248},
    { 1640, 432, 216},
    { 1016, 408, 120},
    { 912, 288, 32},
    { 1080, -8, 56},
    { 848, -216, 280},
    { 840, 112, 72},
    { 808, 24, 152},
    { 736, 24, 160},
    { 928, -48, 128},
    { 712, -32, 48},
    // 18 seconds
    { 792, -8, 104},
    { 1096, 16, 160},
    { 1208, 64, 296},
    { 1880, 136, 208},
    { 1568, 176, 240},
    { 1024, 440, -24},
    { 664, 224, 64},
    { 672, 504, 48},
    { 760, 296, 40},
    { 848, 208, 320},
    { 728, 264, 192},
    { 760, 152, 224},
    { 688, 216, 120},
    { 800, 184, 120},
    { 944, 128, 184},
    { 1104, 72, 232},
    { 1248, -8, 232},
    { 1472, -40, 112},
    { 1712, -296, -144},
    { 1152, 320, -32},
    { 904, 136, 192},
    { 864, -136, 176},
    { 760, -168, 160},
    { 760, -144, 80},
    { 712, -128, 120},
    // 19 seconds
    { 776, -56, 320},
    { 888, 112, 256},
    { 808, 368, 176},
    { 896, 168, 248},
    { 1040, -56, 312},
    { 1264, -152, 312},
    { 1280, -256, 192},
    { 1352, -176, 56},
    { 1032, 248, -48},
    { 1112, 184, -128},
    { 1096, 88, -160},
    { 784, -280, 8},
    { 544, -552, 96},
    { 552, -224, 120},
    { 632, 184, 168},
    { 808, 288, 232},
    { 792, 400, -72},
    { 720, 224, 56},
    { 880, 104, 136},
    { 1232, 232, 48},
    { 1264, 408, 176},
    { 1712, 344, 320},
    { 1488, 488, 248},
    { 880, 432, 160},
    { 880, 296, -32},
    // 20 seconds
    { 1048, 128, -88},
    { 840, -192, 288},
    { 664, -176, 232},
    { 824, 56, 200},
    { 768, 88, 192},
    { 792, 152, 176},
    { 776, 144, 176},
    { 848, 40, 208},
    { 1024, 48, 160},
    { 1168, 112, 152},
    { 1560, -88, 296},
    { 1616, 16, 344},
    { 1048, 488, -64},
    { 768, 800, -216},
    { 728, -144, 16},
    { 744, 152, 136},
    { 712, 120, 128},
    { 672, 200, 104},
    { 736, 152, 152},
    { 768, 248, 64},
    { 816, 200, 120},
    { 840, 240, 64},
    { 1032, 240, 80},
    { 1224, 296, 48},
    { 1480, 200, 176},
    // 21 seconds
    { 1768, 336, 272},
    { 1184, 512, 160},
    { 1016, 280, -272},
    { 920, -312, 152},
    { 984, -184, 408},
    { 912, 136, 240},
    { 800, 144, 160},
    { 824, 104, 152},
    { 696, 48, 160},
    { 640, 8, 144},
    { 656, -24, 160},
    { 808, 0, 144},
    { 1072, 88, 80},
    { 1240, 72, 152},
    { 1704, -16, 304},
    { 1696, 296, 272},
    { 1096, 544, -112},
    { 856, 424, -208},
    { 728, 216, 8},
    { 760, -32, 288},
    { 720, 48, 168},
    { 752, 120, 136},
    { 784, 336, -40},
    { 808, 208, 104},
    { 824, 320, -64},
    // 22 seconds
    { 944, 136, 72},
    { 1112, 280, -80},
    { 1312, 88, -24},
    { 1624, 64, 96},
    { 1672, 240, 16},
    { 1104, 352, -16},
    { 992, 448, -136},
    { 912, -272, 408},
    { 784, -96, 352},
    { 864, 160, 224},
    { 848, 176, 136},
    { 752, 208, -8},
    { 664, 32, 112},
    { 600, 0, 144},
    { 632, -24, 120},
    { 808, -40, 72},
    { 1160, 80, 112},
    { 1320, 168, 176},
    { 1800, 64, 328},
    { 1528, 504, -24},
    { 984, 808, -128},
    { 848, 168, -56},
    { 808, 48, 88},
    { 672, -80, 224},
    { 752, 72, 128},
    // 23 seconds
    { 800, 288, -48},
    { 808, 248, 40},
    { 768, 320, -88},
    { 768, 96, 88},
    { 880, 168, 128},
    { 1136, 168, 168},
    { 1312, 256, 280},
    { 1760, 240, 256},
    { 1400, 464, 176},
    { 816, 384, 176},
    { 1152, 240, -56},
    { 1040, 144, 232},
    { 944, 120, 216},
    { 880, 32, 232},
    { 752, 32, 128},
    { 664, 88, 88},
    { 712, 72, 208},
    { 656, 136, 40},
    { 704, 144, 112},
    { 864, 184, 168},
    { 856, 488, 296},
    { 1152, 424, 232},
    { 1664, 240, 336},
    { 1096, 496, 280},
    { 968, 544, 8},
    // 24 seconds
    { 1168, 456, -144},
    { 680, 296, 24},
    { 736, 496, 56},
    { 592, 536, 8},
    { 784, 456, 112},
    { 720, 304, 0},
    { 720, 136, 72},
    { 784, 224, -8},
    { 936, 280, 104},
    { 1112, 304, 96},
    { 1160, 176, 184},
    { 1464, 216, 240},
    { 1536, 440, 144},
    { 960, 352, 72},
    { 912, 264, 64},
    { 976, 32, 232},
    { 1056, 280, 112},
    { 880, 200, 112},
    { 808, 64, 152},
    { 704, 96, 120},
    { 672, 56, 104},
    { 672, -16, 152},
    { 760, 72, 72},
    { 856, 56, 128},
    { 1096, 136, 160},
    // 25 seconds
    { 1128, 136, 208},
    { 1808, -80, 392},
    { 1776, 384, 192},
    { 936, 1024, -232},
    { 688, -32, -40},
    { 712, -72, 192},
    { 752, -8, 248},
    { 720, 104, 248},
    { 760, 192, 160},
    { 744, 368, 24},
    { 600, 376, -96},
    { 776, 272, -72},
    { 864, 144, 48},
    { 984, 128, -16},
    { 1224, 64, 40},
    { 1440, 256, 160},
    { 1752, 328, 264},
    { 1368, 544, 112},
    { 712, 320, 48},
    { 976, 8, 200},
    { 832, -256, 320},
    { 648, -328, 240},
    { 776, 16, 200},
    { 768, 128, 144},
    { 808, 264, 128},
    // 26 seconds
    { 736, 232, 88},
    { 760, 64, 152},
    { 920, 0, 200},
    { 1152, 80, 136},
    { 1224, 144, 136},
    { 1544, -24, 424},
    { 1600, 312, 88},
    { 1136, 536, -216},
    { 880, 448, -88},
    { 784, 280, -32},
    { 776, 248, 48},
    { 760, 144, 88},
    { 656, 160, 136},
    { 664, 64, 168},
    { 608, 152, 152},
    { 720, 112, 176},
    { 808, 168, 40},
    { 1016, 128, 96},
    { 1216, 184, 56},
    { 1456, 296, 192},
    { 1664, 416, 160},
    { 1232, 536, 136},
    { 1304, 232, 352},
    { 1144, 40, -8},
    { 896, 136, 384},
    // 27 seconds
    { 688, -176, 208},
    { 720, -256, 216},
    { 736, 48, 208},
    { 768, 152, 184},
    { 784, 232, 80},
    { 768, 112, 120},
    { 880, 8, 200},
    { 1096, 48, 200},
    { 1176, 208, 48},
    { 1592, 8, 288},
    { 1336, 160, 152},
    { 1192, 360, 48},
    { 976, 272, 48},
    { 656, 128, 104},
    { 688, 80, 112},
    { 728, 24, 208},
    { 736, 176, 112},
    { 776, 224, 32},
    { 776, 224, -24},
    { 832, 208, 0},
    { 864, 208, 0},
    { 1056, 176, 24},
    { 1168, 120, 112},
    { 1344, 152, 168},
    { 1800, 232, 224},
    // 28 seconds
    { 1208, 528, 176},
    { 816, 272, 104},
    { 968, 80, 160},
    { 816, -176, 336},
    { 632, -120, 240},
    { 816, 72, 48},
    { 800, 80, 184},
    { 720, 160, 88},
    { 672, 72, 80},
    { 712, 32, 112},
    { 944, 24, 136},
    { 1224, 96, 112},
    { 1144, 136, 48},
    { 1568, -48, 208},
    { 1464, 152, 248},
    { 1016, 464, -56},
    { 760, 256, -72},
    { 824, 72, 144},
    { 760, 48, 160},
    { 744, 120, 112},
    { 744, 176, 96},
    { 728, 232, 40},
    { 768, 200, 40},
    { 792, 224, 8},
    { 872, 192, 24},
    // 29 seconds
    { 1120, 160, 72},
    { 1144, 160, 144},
    { 1424, 128, 264},
    { 1768, 432, 328},
    { 1128, 640, 232},
    { 848, 168, -40},
    { 816, -424, 144},
    { 920, 136, 256},
    { 840, -16, 88},
    { 784, -64, 200},
    { 664, 16, 104},
    { 672, 112, -32},
    { 736, 0, 128},
    { 808, 64, 136},
    { 960, 88, 176},
    { 1224, 128, 136},
    { 1432, 32, 288},
    { 1704, 112, 344},
    { 1248, 432, 144},
    { 800, 480, -104},
    { 672, 104, 80},
    { 736, -16, 168},
    { 736, 32, 192},
    { 768, 128, 104},
    { 792, 184, 64},
    // 30 seconds
    { 736, 248, -56},
    { 824, 152, 0},
    { 888, 208, -24},
    { 1040, 144, 0},
    { 1224, 112, 40},
    { 1544, 160, 248},
    { 1840, 328, 192},
    { 984, 480, 136},
    { 712, 208, 0},
    { 1104, 280, -8},
    { 960, -192, 368},
    { 800, 120, 144},
    { 784, 120, 72},
    { 752, 96, 120},
    { 688, 112, 104},
    { 672, 64, 128},
    { 744, -8, 168},
    { 952, 8, 168},
    { 1224, 88, 184},
    { 1288, 104, 200},
    { 1536, 72, 264},
    { 1320, 336, 112},
    { 1032, 488, -160},
    { 808, 168, -8},
    { 744, 24, 104},
    // 31 seconds
    { 760, 64, 120},
    { 776, 112, 136},
    { 808, 240, 40},
    { 792, 184, 24},
    { 816, 216, -8},
    { 840, 224, -32},
    { 880, 160, 24},
    { 1144, 96, 64},
    { 1208, 160, 192},
    { 1592, 112, 296},
    { 1440, 328, 144},
    { 744, 368, 40},
    { 808, 176, 8},
    { 1080, -104, 152},
    { 920, -128, 344},
    { 872, 240, 88},
    { 728, 168, 96},
    { 712, 184, 88},
    { 680, 144, 104},
    { 776, 48, 144},
    { 872, 40, 152},
    { 1120, 48, 168},
    { 1328, 136, 128},
    { 1464, 80, 208},
    { 1488, 96, 224},
    // 32 seconds
    { 1000, 368, -48},
    { 848, 224, -240},
    { 832, -8, 32},
    { 744, 48, 128},
    { 688, 80, 152},
    { 744, 144, 96},
    { 728, 192, 48},
    { 712, 184, 48},
    { 768, 128, 56},
    { 816, 216, -8},
    { 952, 184, 32},
    { 1240, 184, 48},
    { 1352, 264, 184},
    { 1600, 176, 224},
    { 1336, 384, 56},
    { 704, 376, 40},
    { 800, 208, 32},
    { 1120, 200, 96},
    { 968, -104, 312},
    { 872, 104, 96},
    { 744, 64, 176},
    { 696, 144, 64},
    { 680, 72, 96},
    { 720, 0, 192},
    { 864, 32, 184},
    // 33 seconds
    { 1096, 104, 112},
    { 1200, 216, 64},
    { 1672, 16, 320},
    { 1536, 224, 80},
    { 1024, 432, -136},
    { 840, 248, -80},
    { 768, -16, 128},
    { 752, -16, 144},
    { 832, 96, 72},
    { 792, 176, 112},
    { 744, 232, -8},
    { 720, 208, -72},
    { 752, 144, 8},
    { 760, 160, -40},
    { 928, 136, 48},
    { 1080, 176, 168},
    { 1296, 192, 192},
    { 1632, 296, 152},
    { 1288, 464, 136},
    { 1072, 312, 16},
    { 944, 328, -88},
    { 832, -200, 280},
    { 776, 128, 0},
    { 864, 184, 304},
    { 752, 336, 8},
    // 34 seconds
    { 712, 320, 48},
    { 608, 352, 80},
    { 744, 328, 40},
    { 936, 424, 80},
    { 1120, 312, 104},
    { 1312, 80, 328},
    { 1392, 40, 376},
    { 1184, 232, 160},
    { 936, 336, -104},
    { 784, 16, 0},
    { 752, 80, -136},
    { 496, 288, -80},
    { 928, 192, 136},
    { 800, 320, -64},
    { 688, 424, -120},
    { 760, 328, -24},
    { 912, 296, 104},
    { 952, 312, 64},
    { 1112, 400, 56},
    { 1328, 312, 200},
    { 1584, 448, 120},
    { 1280, 488, 152},
    { 920, 400, 40},
    { 944, 320, 56},
    { 888, 112, 128},
    // 35 seconds
    { 896, 216, 72},
    { 832, 152, 104},
    { 808, 72, 160},
    { 688, 184, 64},
    { 696, 136, 120},
    { 688, 88, 144},
    { 720, 104, 128},
    { 952, 128, 96},
    { 1088, 136, 112},
    { 1640, -56, 328},
    { 1640, 144, 288},
    { 1176, 624, -120},
    { 864, 400, -208},
    { 848, 152, 88},
    { 800, 120, 104},
    { 840, 280, 64},
    { 808, 248, 120},
    { 736, 224, 96},
    { 632, 304, -72},
    { 792, 192, 16},
    { 864, 264, -24},
    { 1032, 152, 80},
    { 1128, 216, 48},
    { 1272, 200, 120},
    { 1640, 392, 120},
    // 36 seconds
    { 1232, 424, 184},
    { 976, 256, 64},
    { 1104, 240, -24},
    { 1056, 48, 304},
    { 920, 168, 8},
    { 816, 72, 112},
    { 744, 88, 64},
    { 696, 72, 96},
    { 624, 32, 72},
    { 608, 64, 72},
    { 712, 56, 120},
    { 976, 144, 112},
    { 1288, 48, 328},
    { 1920, -96, 496},
    { 1544, 640, -64},
    { 968, 768, -288},
    { 720, 152, 24},
    { 744, -168, 216},
    { 800, 24, 112},
    { 816, 160, 184},
    { 800, 312, 80},
    { 752, 248, 0},
    { 720, 240, -56},
    { 784, 200, -40},
    { 864, 128, -80},
    // 37 seconds
    { 1040, 72, -16},
    { 1216, 168, 72},
    { 1616, 256, 208},
    { 1848, 400, 192},
    { 1184, 520, 152},
    { 632, 336, -32},
    { 984, 152, -96},
    { 912, -192, 336},
    { 792, 152, 168},
    { 792, 128, 168},
    { 752, 136, 112},
    { 712, 112, 128},
    { 680, 48, 160},
    { 728, 8, 176},
    { 840, 16, 200},
    { 1000, 112, 104},
    { 1168, 200, 40},
    { 1712, -56, 256},
    { 1520, 224, 0},
    { 1192, 528, -288},
    { 928, 216, -168},
    { 672, -32, 48},
    { 720, 128, 80},
    { 736, 64, 160},
    { 776, 176, 160},
    // 38 seconds
    { 768, 192, 144},
    { 736, 216, 56},
    { 760, 232, -16},
    { 848, 208, 8},
    { 1048, 200, -16},
    { 1184, 216, 16},
    { 1504, 136, 160},
    { 1640, 280, 128},
    { 1088, 432, 112},
    { 920, 176, 136},
    { 1064, 48, 248},
    { 952, -56, 88},
    { 688, -328, 240},
    { 744, -48, 48},
    { 744, 160, 104},
    { 688, 208, 56},
    { 680, 112, 120},
    { 728, 120, 136},
    { 848, 176, 136},
    { 1080, 272, 88},
    { 1168, 280, 112},
    { 1648, 88, 320},
    { 1496, 360, 136},
    { 1016, 544, -112},
    { 912, 392, -136},
    // 39 seconds
    { 848, 32, 112},
    { 696, 72, 96},
    { 736, 120, 96},
    { 768, 144, 152},
    { 720, 208, 112},
    { 664, 248, 40},
    { 680, 336, -24},
    { 744, 432, 8},
    { 872, 408, 96},
    { 976, 528, 40},
    { 1080, 480, 160},
    { 1344, 544, 216},
    { 1200, 640, 128},
    { 992, 480, 224},
    { 904, 536, 104},
    { 912, 352, 192},
    { 864, 296, 184},
    { 856, 304, 192},
    { 792, 296, 152},
    { 736, 336, 112},
    { 712, 320, 120},
    { 656, 352, 8},
    { 688, 312, 24},
    { 800, 248, 56},
    { 952, 264, 32},
    // 40 seconds
    { 976, 256, -64},
    { 1424, 80, 64},
    { 1472, 32, 256},
    { 1208, 256, 104},
    { 936, 360, -160},
    { 832, 208, 32},
    { 840, 48, 216},
    { 832, 104, 224},
    { 872, 160, 208},
    { 928, 200, 224},
    { 872, 344, 80},
    { 888, 392, 8},
    { 864, 544, -120},
    { 976, 400, -32},
    { 1232, 328, 32},
    { 1216, 312, 136},
    { 1592, 392, 136},
    { 1544, 504, 152},
    { 960, 320, 184},
    { 1088, 96, 240},
    { 1256, 136, 208},
    { 1168, 64, 360},
    { 1048, 88, 136},
    { 856, 0, 160},
    { 744, 0, 112},
    // 41 seconds
    { 672, 16, 40},
    { 656, -16, 96},
    { 640, -40, 112},
    { 808, -24, 80},
    { 1088, 32, 104},
    { 1336, -24, 176},
    { 1848, -184, 488},
    { 1672, 376, 176},
    { 1176, 736, -272},
    { 1056, 456, 96},
    { 864, 288, 184},
    { 824, 144, 216},
    { 856, 216, 184},
    { 808, 328, 128},
    { 752, 328, 32},
    { 816, 312, 32},
    { 824, 288, 48},
    { 960, 336, 120},
    { 1224, 376, 184},
    { 1328, 392, 232},
    { 1816, 288, 288},
    { 1480, 520, 128},
    { 1104, 352, 160},
    { 1256, 32, 328},
    { 1312, 0, 128},
    // 42 seconds
    { 1080, -96, 288},
    { 864, -8, 168},
    { 672, 16, -8},
    { 536, -16, 40},
    { 464, -16, 80},
    { 560, 32, 24},
    { 648, 16, 120},
    { 936, 72, 136},
    { 1232, 160, 144},
    { 1816, 8, 456},
    { 2080, 168, 520},
    { 1584, 784, -32},
    { 1248, 576, -320},
    { 552, 104, 176},
    { 656, -120, 272},
    { 752, 48, 184},
    { 792, 216, 192},
    { 840, 424, 104},
    { 784, 408, 56},
    { 832, 376, 8},
    { 888, 336, 0},
    { 1104, 120, 152},
    { 1240, 168, 160},
    { 1360, 144, 240},
    { 1608, 240, 208},
    // 43 seconds
    { 1352, 368, 176},
    { 1056, 232, 184},
    { 1008, -176, 272},
    { 1096, 96, 264},
    { 952, 88, 192},
    { 808, 56, 112},
    { 672, 32, 48},
    { 592, 8, 104},
    { 584, 8, 128},
    { 624, 80, 48},
    { 752, 136, 48},
    { 1056, 168, 48},
    { 1200, 208, 56},
    { 1712, 16, 304},
    { 1816, 184, 352},
    { 1144, 664, -72},
    { 760, 464, -160},
    { 848, 160, 200},
    { 792, 80, 240},
    { 792, 120, 120},
    { 768, 200, 120},
    { 776, 312, 56},
    { 776, 328, -40},
    { 768, 288, -16},
    { 872, 272, -16},
    // 44 seconds
    { 1032, 216, 0},
    { 1176, 256, 40},
    { 1352, 224, 144},
    { 1680, 296, 136},
    { 1328, 416, 120},
    { 936, 312, 112},
    { 1032, 160, 152},
    { 1008, 32, 80},
    { 920, 80, 232},
    { 872, 160, 72},
    { 808, 96, 112},
    { 728, 96, 112},
    { 680, 96, 56},
    { 664, 64, 104},
    { 712, 64, 104},
    { 880, 80, 80},
    { 1064, 88, 96},
    { 1160, 168, 8},
    { 1552, -104, 360},
    { 1512, 104, 336},
    { 1304, 520, -48},
    { 864, 568, -184},
    { 720, 256, 80},
    { 784, 32, 216},
    { 872, 112, 192},
    // 45 seconds
    { 896, 248, 104},
    { 848, 336, 40},
    { 816, 360, -56},
    { 880, 280, -8},
    { 904, 272, -56},
    { 1072, 168, 32},
    { 1208, 160, 104},
    { 1496, 152, 184},
    { 1648, 280, 120},
    { 1112, 304, 224},
    { 1008, 192, 144},
    { 1248, 248, -80},
    { 1000, -88, 344},
    { 1016, 112, 32},
    { 912, 24, 176},
    { 816, 152, 56},
    { 688, 48, 72},
    { 608, 0, 104},
    { 600, 0, 80},
    { 720, 48, 72},
    { 944, 136, 96},
    { 1040, 200, 64},
    { 1512, 32, 280},
    { 1416, 176, 344},
    { 1504, 400, 24},
    // 46 seconds
    { 1240, 496, -72},
    { 848, 384, 104},
    { 776, 24, 224},
    { 840, 128, 152},
    { 776, 152, 168},
    { 784, 312, -24},
    { 832, 224, 56},
    { 872, 392, -24},
    { 880, 368, 48},
    { 1000, 320, 120},
    { 1160, 288, 208},
    { 1448, 208, 432},
    { 1600, 248, 392},
    { 1248, 336, 360},
    { 1248, 104, 136},
    { 1104, 552, -80},
    { 1008, -392, 256},
    { 776, 224, 136},
    { 784, -48, 160},
    { 632, 112, -8},
    { 608, 112, 8},
    { 656, 160, 104},
    { 688, 152, 120},
    { 848, 136, 152},
    { 1080, 104, 200},
    // 47 seconds
    { 1264, 152, 240},
    { 1584, 24, 288},
    { 1680, 176, 232},
    { 1128, 712, -120},
    { 1000, 120, -56},
    { 720, 400, 88},
    { 776, 312, 208},
    { 840, 336, 152},
    { 32, 368, 104},
    { 1944, 1600, 376},
    { 920, 104, -32},
    { 952, -552, 136},
    { 560, -144, -248},
    { 792, 224, -216},
    { 848, 384, 112},
    { 1256, 760, 32},
    { 1528, 696, 248},
    { 1288, 792, 272},
    { 952, 440, 184},
    { 1000, 560, 192},
    { 600, 520, 240},
    { 408, 560, -96},
    { 240, 424, -24},
    { 608, 680, -184},
    { 576, 536, -64},
    // 48 seconds
    { 752, 608, -128},
    { 832, 648, -120},
    { 824, 544, 16},
    { 736, 568, -80},
    { 720, 464, -152},
    { 776, 320, -56},
    { 1040, 440, -32},
    { 1272, 576, 160},
    { 1088, 568, 32},
    { 808, 624, -104},
    { 648, 568, -152},
    { 624, 720, -160},
    { 632, 768, -72},
    { 592, 784, -160},
    { 648, 552, -56},
    { 608, 448, -72},
    { 592, 464, -296},
    { 608, 544, -248},
    { 576, 696, -304},
    { 552, 824, -320},
    { 568, 960, -240},
    { 560, 992, -240},
    { 680, 992, -208},
    { 784, 984, -200},
    { 1032, 936, -216},
    // 49 seconds
    { 984, 672, -168},
    { 984, 528, -144},
    { 864, 512, -112},
    { 720, 424, -104},
    { 568, 360, -64},
    { 480, 424, -120},
    { 400, 432, -136},
    { 384, 472, -168},
    { 424, 536, -200},
    { 544, 552, -232},
    { 696, 512, -208},
    { 840, 400, -240},
    { 1048, 392, -136},
    { 1448, 200, -32},
    { 1480, 216, 136},
    { 1096, 392, -8},
    { 928, 424, -176},
    { 992, 256, -72},
    { 920, 224, 104},
    { 912, 216, 112},
    { 952, 240, 88},
    { 888, 272, 56},
    { 824, 288, -72},
    { 840, 264, -88},
    { 880, 296, -112},
    // 50 seconds
    { 960, 272, -128},
    { 1064, 280, -96},
    { 1104, 272, -56},
    { 1328, 160, -16},
    { 1504, 152, 72},
    { 1320, 320, 24},
    { 1016, 264, 16},
    { 1416, 144, 152},
    { 1736, -48, 200},
    { 720, -1400, -40},
    { 1200, -912, -96},
    { 976, -952, -24},
    { 1016, -440, 120},
    { 1088, -80, 104},
    { 1032, 80, 112},
    { 904, 96, 152},
    { 864, 144, 88},
    { 896, 232, 32},
    { 904, 240, 16},
    { 1016, 200, 8},
    { 992, 224, -40},
    { 1064, 72, 0},
    { 1024, 16, -64},
    { 1040, -40, -56},
    { 1040, -80, -64},
    // 51 seconds
    { 1024, -80, -32},
    { 1056, -72, 8},
    { 984, -32, 16},
    { 944, 8, 16},
    { 936, 8, 16},
    { 984, 32, 16},
    { 976, 80, 16},
    { 968, 88, 8},
    { 968, 120, 16},
    { 976, 136, 24},
    { 968, 160, 24},
    { 968, 192, 24},
    { 984, 240, 8},
    { 984, 256, 0},
    { 968, 264, -8},
    { 960, 272, -32},
    { 944, 264, -24},
    { 952, 272, -16},
    { 960, 296, 0},
    { 952, 312, -16},
    { 952, 320, -24},
    { 936, 320, -16},
    { 928, 352, -64},
    { 928, 384, -40},
    { 888, 408, -96},
    // 52 seconds
    { 880, 400, -72},
    { 856, 408, -96},
    { 840, 440, -104},
    { 808, 456, -72},
    { 800, 488, -112},
    { 816, 512, -72},
    { 800, 536, -112},
    { 768, 560, -120},
    { 776, 600, -112},
    { 744, 632, -136},
    { 712, 632, -136},
    { 824, 608, -8},
    { 712, 768, -168},
    { 680, 816, -208},
    { 640, 840, -200},
    { 592, 880, -288},
    { 512, 840, -328},
    { 400, 816, -360},
    { 392, 872, -336},
    { 320, 872, -392},
    { 264, 760, -312},
    { 240, 672, -192},
    { 272, 624, -80},
    { 272, 584, -104},
    { 312, 680, 40},
    // 53 seconds
    { 464, 856, 56},
    { 400, 1088, -112},
    { 224, 648, 8},
    { 216, 712, -40},
    { 120, 696, 56},
    { 48, 984, 24},
    { 128, 1040, 496},
    { 136, 1024, 592},
    { 176, 880, 672},
    { 232, 840, 736},
    { 208, 736, 792},
    { 232, 728, 696},
    { 224, 600, 768},
    { 192, 584, 528},
    { 120, 640, 736},
    { 24, 608, 784},
    { 24, 488, 736},
    { -128, 672, 688},
    { -40, 680, 672},
    { 16, 808, 736},
    { -32, 760, 576},
    { -32, 888, 448},
    { -16, 888, 424},
    { -80, 840, 376},
    { 0, 952, 440},
    // 54 seconds
    { -104, 792, 336},
    { -80, 856, 240},
    { -136, 824, 120},
    { -160, 920, 256},
    { -136, 904, 272},
    { -224, 792, 200},
    { -264, 1056, -120},
    { -224, 920, -32},
    { -216, 920, 0},
    { -168, 1024, 120},
    { -240, 1016, 8},
    { -256, 968, -96},
    { -232, 792, -64},
    { -200, 912, -160},
    { -280, 840, -256},
    { -288, 800, -264},
    { -320, 944, -392},
    { -344, 904, -248},
    { -368, 896, -264},
    { -376, 832, -320},
    { -360, 904, -312},
    { -376, 864, -248},
    { -248, 1024, 0},
    { -360, 904, -184},
    { -304, 864, -200},
    // 55 seconds
    { -320, 848, -224},
    { -344, 784, -320},
    { -344, 776, -240},
    { -336, 808, -176},
    { -312, 800, -224},
    { -320, 816, -176},
    { -296, 808, -296},
    { -320, 776, -320},
    { -224, 784, -168},
    { -256, 856, -104},
    { -240, 840, -96},
    { -176, 784, -136},
    { -128, 792, -80},
    { -48, 728, -56},
    { 16, 696, -72},
    { 192, 992, -80},
    { 152, 872, -48},
    { 320, 1040, -56},
    { 424, 1112, -64},
    { 408, 1016, -24},
    { 472, 976, -96},
    { 488, 960, -72},
    { 552, 976, -48},
    { 568, 912, -40},
    { 584, 952, -56},
    // 56 seconds
    { 576, 872, -48},
    { 584, 816, -24},
    { 592, 824, -32},
    { 600, 800, 0},
    { 600, 776, 0},
    { 608, 768, -8},
    { 616, 744, -8},
    { 616, 736, -16},
    { 616, 728, -8},
    { 608, 720, -24},
    { 616, 720, -24},
    { 616, 720, -24},
    { 600, 728, -32},
    { 600, 720, -24},
    { 608, 720, -32},
    { 608, 736, -24},
    { 616, 736, -32},
    { 616, 768, -32},
    { 616, 744, -32},
    { 608, 736, -32},
    { 608, 744, -40},
    { 608, 736, -48},
    { 608, 728, -40},
    { 600, 736, -40},
    { 608, 736, -32},
    { 608, 736, -32},
    { 608, 736, -40},
    { 616, 744, -32},
    { 616, 728, -24},
    { 608, 728, -32},
    { 608, 736, -24},
    { 616, 728, -24},
    { 616, 728, -24},
    { 608, 728, -32},
    { 600, 712, -24},
    { 616, 712, -32},
    { 624, 720, -32},
    { 632, 728, -24},
    { 632, 736, -32},
    { 624, 728, -32},
    { 616, 720, -40},
    { 616, 736, -40},
    { 624, 736, -32},
    { 624, 736, -32},
    { 624, 720, -24},
    { 624, 720, -24},
    { 624, 720, -24},
    { 624, 736, -32},
    { 624, 728, -32},
    { 624, 736, -32},
    // 58 seconds
    { 616, 728, -32},
    { 616, 752, -24},
    { 616, 744, -32},
    { 616, 744, -40},
    { 616, 768, -40},
    { 592, 800, 0},
    { 544, 984, 104},
    { 448, 1456, 112},
    { 368, 1560, -64},
    { 536, 1360, -32},
    { 472, 1112, 8},
    { 480, 1048, -56},
    { 400, 1184, -32},
    { 336, 1112, -160},
    { 256, 728, -240},
    { 120, 304, -112},
    { 40, -96, -472},
    { 56, 128, -704},
    { 48, 16, -776},
    { 0, -8, -816},
    { 8, 16, -904},
    { 8, -16, -968},
    { 0, -48, -928},
    { 32, 80, -1048},
    { 24, -24, -1032},
    // 59 seconds
    { 48, 88, -1072},
    { 24, 24, -1032},
    { 24, 56, -1040},
    { 0, 64, -1016},
    { -8, 24, -1000},
    { 8, 72, -1016},
    { -16, 80, -1016},
    { -16, 48, -1000},
    { 32, 64, -944},
    { 80, 8, -712},
    { 112, 32, -488},
    { 192, 216, -608},
    { 224, 432, -584},
    { 216, 368, -320},
    { 344, 656, -456},
    { 328, 792, -528},
    { 456, 864, -464},
    { 600, 1024, -488},
    { 544, 888, -336},
    { 648, 1040, -360},
    { 680, 1200, -360},
    { 568, 936, -256},
    { 640, 1072, -256},
    { 632, 896, -176},
    { 704, 912, -200},
    // 60 seconds
    // elapsed: 1 minutes
    { 736, 888, -176},
    { 648, 688, -112},
    { 680, 752, -152},
    { 696, 720, -128},
    { 672, 584, -112},
    { 704, 584, -80},
    { 720, 592, -64},
    { 704, 496, -64},
    { 752, 560, -48},
    { 720, 480, -16},
    { 792, 400, 24},
    { 808, 488, 0},
    { 960, 360, 80},
    { 1064, 384, 160},
    { 1160, 208, 208},
    { 1072, 384, 144},
    { 728, 408, -40},
    { 832, 176, 112},
    { 992, 176, 216},
    { 1000, 336, 224},
    { 880, 352, 136},
    { 808, 376, 16},
    { 768, 256, 104},
    { 784, 280, 120},
    { 776, 328, 136},
    // 61 seconds
    { 792, 384, 144},
    { 776, 424, 288},
    { 944, 432, 264},
    { 1072, 456, 176},
    { 1224, 392, 376},
    { 1424, 488, 344},
    { 1416, 640, 368},
    { 896, 360, 16},
    { 872, 368, 0},
    { 672, -144, -8},
    { 920, 216, 224},
    { 920, 216, 328},
    { 856, 392, 144},
    { 712, 232, 176},
    { 648, 184, 184},
    { 640, 192, 160},
    { 704, 256, 120},
    { 744, 224, 240},
    { 896, 336, 280},
    { 1136, 224, 280},
    { 1312, 72, 352},
    { 1696, 160, 368},
    { 1520, 376, -88},
    { 656, 656, -120},
    { 664, 192, 88},
    // 62 seconds
    { 800, 360, 200},
    { 824, 216, 296},
    { 720, 192, 176},
    { 776, 96, 192},
    { 688, 136, 184},
    { 752, 208, 136},
    { 776, 280, 64},
    { 800, 128, 96},
    { 920, 96, 48},
    { 1104, 184, 96},
    { 1424, 232, 280},
    { 1680, 200, 280},
    { 1416, 304, 312},
    { 672, 328, 184},
    { 928, -16, 72},
    { 872, -264, 0},
    { 808, 0, 80},
    { 824, -72, 96},
    { 648, -80, -24},
    { 704, -80, 96},
    { 864, 0, 232},
    { 944, 120, 280},
    { 904, 152, 288},
    { 1048, 136, 224},
    { 1240, 48, 272},
    // 63 seconds
    { 1368, -88, 240},
    { 1392, -344, 152},
    { 1152, 40, 104},
    { 664, 104, -168},
    { 784, -112, -80},
    { 856, -88, 104},
    { 864, -32, 168},
    { 800, 72, 56},
    { 760, 144, 104},
    { 728, 216, 48},
    { 704, 168, 96},
    { 840, 224, 24},
    { 896, 200, 72},
    { 1024, 184, 192},
    { 1272, 320, 168},
    { 1472, 320, 376},
    { 1592, 512, 280},
    { 1080, 1080, -168},
    { 864, 520, 56},
    { 888, -296, 288},
    { 960, -56, 224},
    { 1000, 472, 64},
    { 744, 256, 40},
    { 600, 112, 40},
    { 568, 48, 104},
    // 64 seconds
    { 632, 112, 88},
    { 704, 176, 56},
    { 832, 200, 32},
    { 1160, 232, 8},
    { 1304, 168, 88},
    { 1696, 32, 192},
    { 1448, 176, 112},
    { 896, 608, -360},
    { 848, 152, -248},
    { 704, 56, 56},
    { 776, 24, 192},
    { 776, 160, 176},
    { 848, 312, 80},
    { 816, 312, 88},
    { 784, 320, -8},
    { 800, 240, 32},
    { 880, 280, -8},
    { 952, 232, 8},
    { 1128, 208, 24},
    { 1208, 288, 72},
    { 1448, 288, 200},
    { 1456, 560, 168},
    { 928, 592, 112},
    { 1000, 504, 128},
    { 1304, 656, -64},
    // 65 seconds
    { 1344, -112, 512},
    { 1208, 48, 176},
    { 1000, 64, 184},
    { 784, 96, 80},
    { 576, 56, 32},
    { 496, -40, 96},
    { 536, 56, 96},
    { 568, 136, 32},
    { 840, 208, 56},
    { 1096, 208, 88},
    { 1520, 80, 248},
    { 1688, 184, 336},
    { 1288, 792, -192},
    { 1112, 480, -208},
    { 1008, 304, 136},
    { 880, 152, 240},
    { 904, 160, 200},
    { 832, 256, 160},
    { 816, 408, 40},
    { 840, 368, 24},
    { 856, 440, -72},
    { 864, 344, 40},
    { 1072, 424, -40},
    { 1184, 224, 72},
    { 1488, 216, 144},
    // 66 seconds
    { 1632, 256, 256},
    { 1216, 336, 192},
    { 1064, 208, 216},
    { 1168, 208, 104},
    { 1088, -80, 176},
    { 864, -80, 256},
    { 816, -40, 192},
    { 680, 56, 80},
    { 608, 192, -32},
    { 664, 248, 80},
    { 664, 152, 128},
    { 704, 200, 72},
    { 928, 192, 88},
    { 1112, 320, 40},
    { 1600, 200, 144},
    { 1632, 112, 344},
    { 1128, 456, 40},
    { 824, 312, 48},
    { 880, 432, 144},
    { 808, 288, 16},
    { 760, 256, 64},
    { 760, 216, 96},
    { 808, 264, 112},
    { 792, 224, 160},
    { 832, 288, 32},
    // 67 seconds
    { 824, 192, 64},
    { 952, 296, -32},
    { 1120, 280, -24},
    { 1272, 336, 72},
    { 1664, 336, 168},
    { 1328, 616, 144},
    { 872, 480, 168},
    { 1184, 200, 0},
    { 1200, -224, 472},
    { 1080, 248, 160},
    { 920, 168, 96},
    { 752, 144, 24},
    { 608, 64, 40},
    { 576, 24, 72},
    { 656, 40, 72},
    { 728, 40, 96},
    { 904, 80, 112},
    { 1056, 160, 56},
    { 1504, 128, 176},
    { 1768, 112, 320},
    { 1392, 656, -80},
    { 1216, 504, -120},
    { 720, 104, 136},
    { 616, -64, 216},
    { 824, 112, 120},
    // 68 seconds
    { 736, 248, 104},
    { 792, 344, 64},
    { 768, 272, 56},
    { 816, 384, -72},
    { 864, 320, -8},
    { 920, 224, 104},
    { 1120, 272, 232},
    { 1216, 400, 264},
    { 1608, 336, 368},
    { 1488, 456, 328},
    { 1024, 432, 264},
    { 1040, 104, 320},
    { 1312, 168, 144},
    { 1176, 32, 240},
    { 976, 104, 144},
    { 784, 8, 72},
    { 576, 32, -16},
    { 488, 56, 16},
    { 504, 72, 96},
    { 536, 208, 224},
    { 696, 304, 288},
    { 840, 440, 280},
    { 968, 352, 320},
    { 1240, 96, -16},
    { 1952, 280, 704},
    // 69 seconds
    { 1696, 776, 488},
    { 944, 728, 72},
    { 472, -64, 296},
    { 648, -160, 432},
    { 976, 184, 328},
    { 808, 328, 272},
    { 704, 456, 112},
    { 736, 328, 56},
    { 680, 208, 96},
    { 864, 344, 80},
    { 920, 360, 64},
    { 1128, 312, 96},
    { 1232, 288, 168},
    { 1520, 248, 240},
    { 1544, 328, 224},
    { 1016, 440, 128},
    { 1064, 216, 16},
    { 1048, -112, 224},
    { 1024, 24, 328},
    { 864, 152, 152},
    { 784, 136, 48},
    { 648, 80, 48},
    { 696, 64, 80},
    { 592, -104, 240},
    { 576, 16, 128},
    // 70 seconds
    { 712, 64, 104},
    { 1112, 224, 56},
    { 1464, 216, 120},
    { 2008, -160, 720},
    { 1608, 440, 160},
    { 928, 784, -312},
    { 688, 288, -24},
    { 712, -40, 256},
    { 728, 0, 336},
    { 776, 152, 232},
    { 784, 248, 176},
    { 768, 416, 24},
    { 768, 248, 32},
    { 848, 240, 64},
    { 904, 176, 80},
    { 1096, 144, 96},
    { 1192, 168, 112},
    { 1496, 112, 160},
    { 1536, 256, 168},
    { 1088, 352, 136},
    { 968, 160, 128},
    { 1192, 112, 56},
    { 1032, -304, 344},
    { 920, 168, 104},
    { 840, 64, 120},
    // 71 seconds
    { 744, 192, 64},
    { 648, 152, 192},
    { 584, 184, 240},
    { 608, 304, 216},
    { 680, 336, 232},
    { 760, 416, 168},
    { 856, 424, 168},
    { 952, 288, 152},
    { 1664, 192, 440},
    { 1872, 536, 264},
    { 1152, 840, -312},
    { 680, 392, -72},
    { 792, 224, 240},
    { 784, 312, 184},
    { 880, 536, 192},
    { 944, 640, 240},
    { 856, 704, 136},
    { 752, 672, 56},
    { 688, 720, 64},
    { 664, 720, 32},
    { 544, 736, 72},
    { 488, 840, 24},
    { 440, 936, -56},
    { 424, 952, -72},
    { 336, 744, -96},
    // 72 seconds
    { 256, 752, -184},
    { 200, 896, -352},
    { -8, 824, -352},
    { -40, 904, -416},
    { -144, 888, -544},
    { -96, 816, -624},
    { -32, 440, -488},
    { -96, 160, -552},
    { -40, 288, -808},
    { -56, 336, -848},
    { -80, 232, -1000},
    { -32, 328, -992},
    { -56, 192, -920},
    { -8, 216, -1000},
    { -64, 176, -944},
    { -72, 232, -1008},
    { -48, 216, -1048},
    { -120, 120, -1056},
    { -88, 72, -1056},
    { -80, 136, -1016},
    { -56, 200, -1040},
    { -80, 128, -984},
    { -64, 120, -1000},
    { -24, 72, -992},
    { 24, 96, -1000},
    // 73 seconds
    { 64, 112, -1040},
    { 72, 16, -1040},
    { 104, 32, -1008},
    { 112, 16, -992},
    { 136, 32, -1008},
    { 128, 0, -1024},
    { 176, 0, -1016},
    { 152, 16, -1032},
    { 152, 56, -1024},
    { 104, 48, -1032},
    { 112, 72, -1024},
    { 112, 88, -1048},
    { 128, 56, -1032},
    { 112, 64, -1024},
    { 120, 32, -1024},
    { 120, 16, -1000},
    { 144, 24, -992},
    { 112, -32, -1008},
    { 136, -8, -1016},
    { 184, 0, -1024},
    { 208, 56, -1032},
    { 192, 16, -992},
    { 200, -16, -1024},
    { 184, -16, -1024},
    { 176, 56, -1016},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-03 08:52:18 local
AccelRawData *activity_sample_walk_100_pbl_25531_3(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25531_3
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 96, -208, -1032},
    { 120, -184, -1048},
    { 136, -240, -992},
    { 112, -256, -1008},
    { 96, -256, -1016},
    { 112, -256, -1000},
    { 160, -224, -1024},
    { 96, -248, -1016},
    { 120, -264, -1008},
    { 136, -264, -960},
    { 120, -272, -920},
    { 200, -328, -904},
    { 32, -296, -976},
    { 88, -264, -1016},
    { 80, -328, -1016},
    { 200, -632, -840},
    { -80, -736, -184},
    { 704, -112, -1160},
    { -16, -64, -952},
    { 168, -120, -912},
    { 152, -32, -896},
    { -32, 328, -1024},
    { -64, 248, -1184},
    { -48, -112, -1096},
    { 96, 240, -1112},
    // 1 seconds
    { 120, 160, -1008},
    { 0, 120, -872},
    { 48, 328, -800},
    { -72, 328, -680},
    { 96, 360, -728},
    { 104, 408, -504},
    { 280, 512, -576},
    { 264, 384, -664},
    { 224, 424, -376},
    { 584, 608, -216},
    { 480, 392, -96},
    { 736, 520, -168},
    { 1056, 432, 136},
    { 1928, 784, 240},
    { 1384, 992, 520},
    { 1264, 1000, 400},
    { 1024, 888, 144},
    { 912, 680, 88},
    { 872, 528, 152},
    { 976, 552, 240},
    { 960, 536, 288},
    { 952, 464, 256},
    { 936, 456, 224},
    { 936, 384, 208},
    { 976, 384, 16},
    // 2 seconds
    { 1080, 80, -88},
    { 936, 144, -32},
    { 1000, 400, 32},
    { 1072, 216, 224},
    { 1000, 328, 144},
    { 960, 256, 128},
    { 896, 280, 64},
    { 864, 216, 64},
    { 744, 264, 8},
    { 800, 344, 88},
    { 776, 480, 16},
    { 768, 456, 56},
    { 704, 472, 56},
    { 784, 488, 0},
    { 880, 440, 40},
    { 1008, 384, 112},
    { 1256, 280, 168},
    { 1272, 248, 256},
    { 1048, 440, 16},
    { 648, 376, -72},
    { 856, 152, 8},
    { 888, 160, 112},
    { 920, 272, 152},
    { 800, 232, 56},
    { 760, 328, -40},
    // 3 seconds
    { 744, 256, 40},
    { 728, 304, 24},
    { 800, 304, 56},
    { 808, 392, -72},
    { 936, 352, 16},
    { 1112, 416, 16},
    { 1248, 328, 168},
    { 1648, 504, 144},
    { 1440, 392, 24},
    { 664, 288, 40},
    { 760, 104, -152},
    { 872, -520, 384},
    { 1128, 136, 48},
    { 856, -120, 96},
    { 832, 224, 32},
    { 776, 8, -144},
    { 704, 72, -88},
    { 736, 96, 8},
    { 792, 120, 32},
    { 928, 216, 48},
    { 1160, 208, 112},
    { 1160, 240, 88},
    { 1712, 24, 256},
    { 1512, 376, 200},
    { 1064, 544, -200},
    // 4 seconds
    { 648, 184, -56},
    { 600, 56, 176},
    { 808, -8, 288},
    { 712, 56, 192},
    { 736, 144, 112},
    { 792, 280, 0},
    { 696, 256, 56},
    { 760, 304, 40},
    { 832, 392, 16},
    { 952, 256, 56},
    { 1216, 256, 48},
    { 1536, 296, 208},
    { 1736, 400, 96},
    { 1064, 528, 8},
    { 736, 344, -112},
    { 936, 192, -32},
    { 728, 112, 232},
    { 800, 88, 88},
    { 768, 48, 88},
    { 728, 112, 72},
    { 720, 112, 120},
    { 736, 160, 64},
    { 776, 144, 56},
    { 872, 120, 80},
    { 1184, 128, 112},
    // 5 seconds
    { 1256, 176, 48},
    { 1872, -8, 280},
    { 1504, 472, -136},
    { 808, 536, -368},
    { 632, 288, -48},
    { 768, -32, 136},
    { 720, 72, 64},
    { 728, 80, 80},
    { 728, 216, 40},
    { 656, 216, -40},
    { 664, 208, -64},
    { 760, 312, -88},
    { 792, 384, -192},
    { 992, 328, -88},
    { 1232, 400, -96},
    { 1384, 376, -56},
    { 1816, 520, -80},
    { 1248, 592, -32},
    { 912, 400, -232},
    { 952, -96, 48},
    { 904, 208, 80},
    { 816, 208, 32},
    { 784, 136, 24},
    { 680, 80, 24},
    { 672, 112, 32},
    // 6 seconds
    { 688, 152, 8},
    { 712, 192, 8},
    { 744, 216, -32},
    { 960, 176, -104},
    { 1184, 144, -24},
    { 1768, -56, 192},
    { 1616, 208, 128},
    { 1024, 600, -296},
    { 744, 360, -264},
    { 688, 112, 16},
    { 760, 96, 48},
    { 816, 200, 96},
    { 824, 288, 24},
    { 792, 288, 72},
    { 744, 408, -88},
    { 808, 304, -8},
    { 848, 392, -104},
    { 1008, 288, -48},
    { 1248, 344, -40},
    { 1600, 352, 40},
    { 1536, 496, -8},
    { 976, 512, -48},
    { 928, 384, -112},
    { 1072, -32, 96},
    { 920, 56, 80},
    // 7 seconds
    { 944, 168, 96},
    { 808, 112, 96},
    { 696, 128, 16},
    { 688, 72, 72},
    { 696, 80, 72},
    { 720, 56, 56},
    { 912, 64, 24},
    { 1120, 64, 56},
    { 1616, -16, 192},
    { 1728, 120, 264},
    { 1088, 656, -320},
    { 832, 488, -304},
    { 760, 168, 8},
    { 776, 88, 96},
    { 888, 184, 72},
    { 808, 232, 96},
    { 768, 368, -40},
    { 808, 288, -16},
    { 824, 328, -120},
    { 864, 224, -16},
    { 904, 320, -104},
    { 1168, 200, -8},
    { 1456, 296, 0},
    { 1840, 280, 168},
    { 1184, 512, -56},
    // 8 seconds
    { 664, 456, -144},
    { 928, 208, -64},
    { 1040, -8, 272},
    { 1040, 168, 136},
    { 880, 104, 136},
    { 704, 88, 160},
    { 664, 96, 40},
    { 640, 24, 128},
    { 656, 40, 96},
    { 736, 80, 40},
    { 1072, 176, -24},
    { 1240, 184, 32},
    { 1816, -16, 272},
    { 1760, 352, 24},
    { 904, 792, -472},
    { 656, 392, -192},
    { 760, 40, 8},
    { 776, 168, 56},
    { 752, 192, 24},
    { 856, 336, 16},
    { 824, 296, 64},
    { 736, 344, -144},
    { 824, 272, -88},
    { 880, 312, -168},
    { 952, 136, -80},
    // 9 seconds
    { 1176, 208, -136},
    { 1328, 160, -56},
    { 1760, 336, -72},
    { 1352, 456, -80},
    { 800, 328, -48},
    { 912, 176, 72},
    { 1040, 88, 216},
    { 952, 64, 216},
    { 856, 40, 184},
    { 736, 104, 32},
    { 624, 112, 8},
    { 608, 80, 72},
    { 624, 96, 24},
    { 744, 64, 32},
    { 1016, 72, 80},
    { 1296, 224, 80},
    { 1832, 152, 112},
    { 1744, 136, 176},
    { 1000, 552, -328},
    { 896, 144, -32},
    { 776, 160, 8},
    { 784, 320, 16},
    { 672, 376, 56},
    { 720, 184, 152},
    { 720, 232, 48},
    // 10 seconds
    { 736, 184, 160},
    { 784, 368, -48},
    { 848, 200, 136},
    { 936, 392, 32},
    { 1216, 304, 88},
    { 1312, 280, 160},
    { 1616, 504, 112},
    { 1312, 616, 40},
    { 768, 544, -16},
    { 880, 304, 48},
    { 1104, 168, 112},
    { 984, 48, 264},
    { 840, 104, 136},
    { 704, 80, 80},
    { 632, 56, 104},
    { 616, 104, 56},
    { 688, 48, 112},
    { 752, 88, 64},
    { 1008, 112, 112},
    { 1264, 144, 128},
    { 1800, 8, 360},
    { 1600, 392, 88},
    { 816, 704, -368},
    { 768, 360, -152},
    { 784, -64, 80},
    // 11 seconds
    { 904, 208, 72},
    { 832, 168, 112},
    { 808, 280, 56},
    { 784, 288, 16},
    { 736, 280, -48},
    { 792, 256, -24},
    { 872, 248, -32},
    { 1144, 232, 8},
    { 1240, 232, 120},
    { 1760, 232, 136},
    { 1432, 440, 40},
    { 824, 416, -48},
    { 1040, 304, -296},
    { 944, -200, 360},
    { 896, 8, 248},
    { 856, 208, -8},
    { 808, 120, 104},
    { 712, 104, 104},
    { 656, 96, 72},
    { 640, 40, 120},
    { 672, 24, 104},
    { 1040, 192, -48},
    { 1200, 224, -88},
    { 1584, 40, 112},
    { 1688, -128, 376},
    // 12 seconds
    { 1248, 416, 8},
    { 736, 448, -96},
    { 752, 240, -40},
    { 752, 176, 80},
    { 808, 144, 176},
    { 832, 288, 56},
    { 856, 296, -8},
    { 744, 360, -160},
    { 808, 288, -96},
    { 896, 288, -136},
    { 1032, 168, -24},
    { 1272, 224, -24},
    { 1448, 208, 144},
    { 1712, 208, 232},
    { 1016, 448, -8},
    { 1008, 216, 40},
    { 1104, 80, 80},
    { 920, -184, 216},
    { 864, 176, 24},
    { 744, 168, 32},
    { 720, 152, 40},
    { 656, 88, 72},
    { 632, 32, 128},
    { 656, 32, 120},
    { 864, 56, 104},
    // 13 seconds
    { 1184, 144, 120},
    { 1576, 264, 224},
    { 1760, 32, 192},
    { 1224, 400, -248},
    { 816, 48, -152},
    { 776, -64, -72},
    { 824, 176, -16},
    { 816, 184, 120},
    { 832, 312, 120},
    { 816, 256, 96},
    { 760, 280, 24},
    { 744, 272, -16},
    { 776, 264, -32},
    { 952, 200, 0},
    { 1176, 232, -8},
    { 1248, 256, 104},
    { 1688, 296, 184},
    { 1464, 376, 152},
    { 808, 432, 88},
    { 920, 224, 80},
    { 1216, 248, 240},
    { 1112, 184, 184},
    { 800, 48, 168},
    { 712, 56, 96},
    { 608, 72, 24},
    // 14 seconds
    { 616, 40, 104},
    { 656, 48, 104},
    { 720, 32, 104},
    { 984, 40, 96},
    { 1272, 112, 136},
    { 1624, 112, 208},
    { 1672, 160, 232},
    { 1272, 528, -96},
    { 944, 456, -368},
    { 688, 96, 64},
    { 752, 56, 136},
    { 752, 80, 168},
    { 760, 264, 72},
    { 784, 344, 16},
    { 712, 376, -136},
    { 792, 216, 0},
    { 1016, 184, 32},
    { 1184, 224, 24},
    { 1160, 232, 72},
    { 1544, 176, 176},
    { 1472, 344, 96},
    { 1096, 464, 40},
    { 1096, 456, -144},
    { 1032, -88, 448},
    { 944, 176, 208},
    // 15 seconds
    { 872, 184, 112},
    { 776, 128, 120},
    { 664, 120, 40},
    { 592, 48, 72},
    { 584, 32, 56},
    { 688, 8, 48},
    { 960, 0, 72},
    { 1256, 96, 112},
    { 1560, 64, 248},
    { 1840, 104, 232},
    { 1280, 616, -200},
    { 904, 464, -32},
    { 776, 144, -8},
    { 792, 16, 240},
    { 736, 80, 200},
    { 736, 192, 160},
    { 776, 328, 64},
    { 752, 288, 56},
    { 784, 304, -16},
    { 864, 232, 32},
    { 1000, 296, -40},
    { 1256, 248, 0},
    { 1408, 224, 112},
    { 1664, 240, 136},
    { 1256, 440, 0},
    // 16 seconds
    { 856, 360, -56},
    { 1256, 512, -112},
    { 1128, -304, 440},
    { 912, 152, 232},
    { 800, 216, 72},
    { 720, 184, 40},
    { 632, 152, 16},
    { 608, 96, 64},
    { 672, 16, 128},
    { 808, 8, 104},
    { 1096, 96, 56},
    { 1264, 112, 152},
    { 1840, -16, 352},
    { 1472, 360, 56},
    { 1072, 696, -320},
    { 832, 224, -120},
    { 680, -80, 104},
    { 736, 40, 64},
    { 768, 120, 88},
    { 864, 248, 64},
    { 808, 320, 0},
    { 784, 264, -24},
    { 864, 280, -48},
    { 912, 240, -32},
    { 1176, 256, -72},
    // 17 seconds
    { 1280, 208, 56},
    { 1784, 240, 40},
    { 1368, 368, 64},
    { 920, 280, -48},
    { 888, 248, -16},
    { 976, 64, 128},
    { 1000, 112, 152},
    { 824, 152, 136},
    { 760, 104, 96},
    { 760, 16, 176},
    { 688, 56, 112},
    { 688, 24, 128},
    { 744, 24, 96},
    { 1008, 144, 24},
    { 1176, 128, 64},
    { 1736, -192, 272},
    { 1584, 192, 0},
    { 1216, 424, -272},
    { 896, 360, -224},
    { 704, -72, -16},
    { 840, 248, -16},
    { 800, 88, 128},
    { 848, 280, 64},
    { 824, 296, 72},
    { 776, 344, 8},
    // 18 seconds
    { 880, 336, -24},
    { 904, 264, 24},
    { 1248, 208, 40},
    { 1336, 248, 48},
    { 1648, 352, -8},
    { 1368, 296, 16},
    { 856, 384, -152},
    { 1592, 328, -232},
    { 1200, -56, 200},
    { 1120, 384, 56},
    { 896, 152, 208},
    { 672, 120, 56},
    { 608, 128, 104},
    { 576, 120, 64},
    { 640, 112, 96},
    { 784, 152, -40},
    { 872, 80, 16},
    { 984, 24, 104},
    { 1584, 0, 328},
    { 1600, 336, 280},
    { 1184, 720, -96},
    { 1144, 496, -72},
    { 1072, 600, 104},
    { 856, 456, 8},
    { 824, 280, 120},
    // 19 seconds
    { 760, 344, 48},
    { 744, 312, 64},
    { 744, 352, 40},
    { 816, 360, 40},
    { 880, 312, 48},
    { 1024, 328, 112},
    { 1240, 376, 8},
    { 1600, 136, 216},
    { 1696, 328, 232},
    { 1008, 432, 56},
    { 960, 320, -152},
    { 976, 224, 184},
    { 1032, 264, 144},
    { 952, 192, 176},
    { 720, 136, 104},
    { 640, 64, 112},
    { 656, 24, 80},
    { 664, 48, 64},
    { 712, 80, 48},
    { 888, 48, 96},
    { 1104, 128, 88},
    { 1280, 104, 192},
    { 1896, 72, 280},
    { 1464, 512, -16},
    { 944, 624, -144},
    // 20 seconds
    { 872, 136, 0},
    { 792, 136, 32},
    { 752, -56, 224},
    { 792, 176, 136},
    { 792, 336, 32},
    { 776, 360, -8},
    { 792, 296, 8},
    { 920, 312, -96},
    { 976, 200, 16},
    { 1120, 208, 40},
    { 1208, 160, 128},
    { 1672, 224, 176},
    { 1320, 416, 72},
    { 752, 368, 8},
    { 936, 120, -144},
    { 1032, -8, 216},
    { 968, 208, 80},
    { 848, 184, 48},
    { 744, 144, 16},
    { 680, 64, 64},
    { 648, 40, 88},
    { 672, 56, 56},
    { 752, 56, 56},
    { 1080, 128, 32},
    { 1256, 168, 80},
    // 21 seconds
    { 1824, 32, 296},
    { 1584, 352, 64},
    { 848, 656, -256},
    { 744, 240, -48},
    { 800, -16, 128},
    { 848, 104, 112},
    { 864, 224, 104},
    { 808, 352, 32},
    { 760, 328, -32},
    { 744, 272, -48},
    { 880, 296, -80},
    { 928, 256, -40},
    { 1040, 192, 8},
    { 1248, 256, -24},
    { 1496, 256, 72},
    { 1576, 360, 16},
    { 992, 360, 0},
    { 992, 240, -88},
    { 1008, -56, 168},
    { 928, 64, 240},
    { 904, 168, 88},
    { 832, 160, 88},
    { 784, 160, 32},
    { 744, 40, 112},
    { 688, 8, 136},
    // 22 seconds
    { 656, 32, 128},
    { 824, -24, 80},
    { 1048, 144, 24},
    { 1216, 168, 104},
    { 1824, 24, 360},
    { 1608, 400, 120},
    { 832, 672, -232},
    { 888, 424, -232},
    { 728, 192, 80},
    { 848, 296, 144},
    { 856, 296, 112},
    { 856, 280, 72},
    { 824, 232, 64},
    { 792, 240, -24},
    { 816, 240, -56},
    { 832, 184, -64},
    { 1008, 96, -16},
    { 1200, 96, -16},
    { 1544, 184, 168},
    { 1752, 448, 112},
    { 968, 448, 16},
    { 816, 264, -40},
    { 984, -32, 216},
    { 1024, 232, 72},
    { 872, 192, 128},
    // 23 seconds
    { 760, 128, 104},
    { 688, 104, 56},
    { 704, 32, 112},
    { 784, 80, 96},
    { 792, 104, 72},
    { 952, 72, 80},
    { 1120, 112, 80},
    { 1184, 72, 200},
    { 1592, 152, 136},
    { 1184, 408, 24},
    { 1032, 448, -144},
    { 832, 256, -24},
    { 776, 168, 104},
    { 744, 280, 48},
    { 752, 248, 16},
    { 744, 264, 96},
    { 712, 280, 40},
    { 776, 288, 48},
    { 824, 376, -56},
    { 944, 296, 16},
    { 1088, 272, 32},
    { 1136, 240, 120},
    { 1592, 320, 152},
    { 1368, 464, 104},
    { 928, 432, 136},
    // 24 seconds
    { 872, 344, 48},
    { 1040, 40, 288},
    { 912, 104, 240},
    { 808, 184, 72},
    { 784, 64, 120},
    { 680, 64, 96},
    { 640, 48, 104},
    { 648, 40, 152},
    { 792, 88, 120},
    { 1048, 192, 112},
    { 1184, 208, 152},
    { 1576, 64, 312},
    { 1608, 160, 328},
    { 912, 568, -72},
    { 1184, 680, -128},
    { 888, 464, 72},
    { 832, 280, 32},
    { 832, 208, 128},
    { 808, 200, 152},
    { 760, 208, 72},
    { 776, 160, 80},
    { 824, 280, 48},
    { 872, 256, 56},
    { 976, 288, 80},
    { 1152, 320, 64},
    // 25 seconds
    { 1376, 232, 216},
    { 1576, 360, 208},
    { 1112, 456, 184},
    { 800, 400, 152},
    { 1120, 408, -16},
    { 1056, 424, 232},
    { 1008, 336, 224},
    { 904, 288, 200},
    { 904, 208, 168},
    { 784, 136, 168},
    { 664, 80, 168},
    { 664, 56, 120},
    { 664, 16, 128},
    { 800, 128, 64},
    { 1040, 200, 8},
    { 1744, -32, 280},
    { 1496, 256, 176},
    { 1176, 424, -208},
    { 1032, 416, -320},
    { 904, 240, -64},
    { 896, 224, 32},
    { 864, 336, 24},
    { 904, 352, 32},
    { 824, 296, 64},
    { 744, 368, -40},
    // 26 seconds
    { 800, 320, -40},
    { 888, 360, -48},
    { 1000, 360, -16},
    { 1120, 376, -24},
    { 1288, 312, 56},
    { 1744, 504, 72},
    { 1184, 520, 96},
    { 1032, 416, -24},
    { 1120, 256, 88},
    { 1184, 176, 64},
    { 1160, 112, 152},
    { 1064, 96, 96},
    { 920, 104, 56},
    { 768, 72, 40},
    { 632, 40, 40},
    { 576, 24, 16},
    { 592, 32, 8},
    { 680, 48, 40},
    { 1008, 208, -32},
    { 1328, 88, 136},
    { 1608, 136, 352},
    { 1432, 472, 88},
    { 1304, 696, -280},
    { 1008, 528, -40},
    { 856, 248, 112},
    // 27 seconds
    { 808, 280, 88},
    { 760, 360, 64},
    { 808, 504, 88},
    { 712, 576, 0},
    { 776, 544, 96},
    { 888, 504, 104},
    { 952, 432, 176},
    { 1104, 576, 216},
    { 1488, 528, 416},
    { 1520, 1024, 40},
    { 1048, 768, 96},
    { 896, 504, 48},
    { 984, 312, 72},
    { 952, 176, 200},
    { 840, 192, 96},
    { 712, 104, 136},
    { 648, 176, 96},
    { 648, 112, 72},
    { 616, 112, -32},
    { 696, 128, 32},
    { 856, 184, 32},
    { 952, 304, 0},
    { 1240, 312, 80},
    { 1768, 208, 248},
    { 1376, 704, 48},
    // 28 seconds
    { 1200, 704, -96},
    { 824, 560, 32},
    { 688, 336, 136},
    { 728, 392, 104},
    { 704, 336, 192},
    { 688, 320, 312},
    { 688, 424, 152},
    { 672, 328, 184},
    { 776, 544, 144},
    { 824, 536, 200},
    { 1048, 608, 272},
    { 1312, 536, 464},
    { 1832, 920, 144},
    { 1440, 720, -320},
    { 1032, 408, 176},
    { 928, 136, 32},
    { 1016, 224, 264},
    { 992, 328, 200},
    { 816, 192, 152},
    { 696, 40, 176},
    { 624, -72, 152},
    { 576, -8, 136},
    { 576, 104, 88},
    { 680, 232, -40},
    { 952, 304, 56},
    // 29 seconds
    { 1256, 248, 144},
    { 1704, 64, 360},
    { 1672, 440, 208},
    { 1144, 928, -216},
    { 776, 472, -24},
    { 624, 184, 40},
    { 848, 504, 24},
    { 792, 400, 72},
    { 696, 416, 128},
    { 664, 272, 296},
    { 672, 520, 8},
    { 784, 456, 192},
    { 800, 720, 240},
    { 896, 688, 432},
    { 952, 640, 608},
    { 1696, 656, 344},
    { 2376, 1256, 200},
    { 872, 648, -48},
    { 952, 208, 112},
    { 944, 96, 296},
    { 1000, 296, 264},
    { 672, 304, 72},
    { 360, 176, -120},
    { 432, 280, 0},
    { 624, 280, 128},
    // 30 seconds
    { 592, 368, -8},
    { 632, 272, 72},
    { 872, 264, 160},
    { 1088, 264, 224},
    { 1328, 136, 312},
    { 1752, 192, 464},
    { 1552, 792, 40},
    { 872, 760, -88},
    { 808, 648, 128},
    { 808, 48, 176},
    { 784, 256, 168},
    { 832, 232, 184},
    { 720, 304, 96},
    { 656, 320, 40},
    { 736, 336, 16},
    { 832, 368, -32},
    { 920, 336, 40},
    { 1168, 376, 24},
    { 1256, 288, 200},
    { 1728, 448, 232},
    { 1416, 632, 144},
    { 1080, 408, -184},
    { 920, 200, 112},
    { 1200, 168, 56},
    { 1024, 208, 112},
    // 31 seconds
    { 808, 96, 136},
    { 640, 24, 104},
    { 536, 16, 56},
    { 536, 24, 104},
    { 576, 56, 128},
    { 712, 120, 56},
    { 904, 240, -16},
    { 1248, 112, 144},
    { 1992, 32, 440},
    { 1792, 728, -80},
    { 1008, 712, -160},
    { 736, 232, 80},
    { 784, -104, 336},
    { 784, 96, 112},
    { 704, 120, 160},
    { 776, 344, 64},
    { 736, 312, -16},
    { 744, 360, -40},
    { 832, 344, -64},
    { 992, 304, -72},
    { 1144, 256, 16},
    { 1288, 280, 64},
    { 1680, 344, 80},
    { 1512, 464, 112},
    { 928, 416, 24},
    // 32 seconds
    { 1184, 232, -224},
    { 952, 160, 272},
    { 984, 344, 184},
    { 912, 256, 144},
    { 784, 200, 80},
    { 672, 104, 120},
    { 600, 32, 160},
    { 600, 72, 104},
    { 648, 56, 104},
    { 800, 72, 112},
    { 1128, 192, 24},
    { 1368, 56, 192},
    { 1640, 64, 216},
    { 1544, 320, 32},
    { 1000, 640, -376},
    { 824, 336, -144},
    { 768, 24, 96},
    { 904, 208, 24},
    { 800, 224, 104},
    { 800, 376, 8},
    { 768, 320, 32},
    { 776, 280, -16},
    { 848, 248, 16},
    { 928, 264, -32},
    { 1200, 232, 48},
    // 33 seconds
    { 1208, 328, 24},
    { 1552, 232, 80},
    { 1600, 400, 16},
    { 888, 464, 56},
    { 992, 472, -96},
    { 1192, 96, 400},
    { 1112, 248, 160},
    { 936, 104, 224},
    { 768, 32, 208},
    { 712, 24, 112},
    { 624, -8, 88},
    { 616, 32, 88},
    { 720, 16, 48},
    { 880, 40, -16},
    { 1096, 64, 56},
    { 1584, -16, 224},
    { 1936, 48, 376},
    { 1232, 848, -336},
    { 1048, 432, -168},
    { 992, 240, 96},
    { 864, 160, 200},
    { 816, 64, 160},
    { 784, 192, 128},
    { 760, 376, -8},
    { 744, 216, 136},
    // 34 seconds
    { 728, 352, 0},
    { 864, 224, 72},
    { 976, 360, -80},
    { 1232, 240, 56},
    { 1272, 368, 24},
    { 1704, 296, 24},
    { 1248, 504, -8},
    { 1088, 424, -96},
    { 1088, 32, 240},
    { 1112, 136, 224},
    { 920, 208, 64},
    { 824, 96, 88},
    { 664, 64, 40},
    { 592, 8, 40},
    { 664, 40, 32},
    { 728, -16, 144},
    { 760, -40, 192},
    { 912, 96, 160},
    { 1168, 248, 120},
    { 1704, 104, 280},
    { 1672, 384, 224},
    { 1304, 664, -64},
    { 784, 488, -48},
    { 704, 112, -24},
    { 856, 120, 152},
    // 35 seconds
    { 808, 296, 128},
    { 792, 280, 104},
    { 744, 296, 88},
    { 800, 344, -24},
    { 808, 248, 24},
    { 832, 288, -16},
    { 1040, 192, 40},
    { 1184, 232, 80},
    { 1712, 240, 200},
    { 1616, 520, 176},
    { 936, 624, 56},
    { 912, 280, 80},
    { 1136, -96, 376},
    { 1168, 72, 304},
    { 1104, 96, 392},
    { 960, 88, 544},
    { 856, 216, 648},
    { 656, 256, 432},
    { 488, 856, 312},
    { 392, 680, 360},
    { 264, 560, 216},
    { 336, 656, 160},
    { 560, 808, 72},
    { 560, 1120, 216},
    { 392, 1280, 1184},
    // 36 seconds
    { 96, 472, 1032},
    { 392, 496, 408},
    { 16, 384, 440},
    { 8, 592, 408},
    { 208, 880, 264},
    { 176, 680, 208},
    { 136, 632, 224},
    { 40, 632, 184},
    { 224, 880, -112},
    { 592, 1040, -168},
    { 720, 1144, -288},
    { 656, 1160, 232},
    { 496, 1224, 360},
    { 280, 1704, 888},
    { 144, 736, 824},
    { -24, 256, 488},
    { 8, 536, 448},
    { -304, 600, 608},
    { -192, 832, 520},
    { -336, 704, 376},
    { -192, 960, 216},
    { -192, 744, 256},
    { -88, 568, 120},
    { 872, 1232, -264},
    { 696, 1200, 40},
    // 37 seconds
    { 768, 1008, 296},
    { 416, 936, 504},
    { 376, 1168, 1032},
    { 64, 1280, 1088},
    { 232, 384, 640},
    { 120, 64, 408},
    { 344, 280, 168},
    { 216, 16, 136},
    { 112, -24, 280},
    { 536, 488, 480},
    { 824, 1072, 400},
    { 720, 1400, 448},
    { 272, 1032, 280},
    { 504, 1216, 304},
    { 432, 1048, 216},
    { 560, 1072, 280},
    { 800, 968, 408},
    { 1152, 1008, 472},
    { 904, 896, 384},
    { 696, 568, 264},
    { 624, 496, 192},
    { 640, 600, 40},
    { 640, 528, 120},
    { 584, 472, -64},
    { 520, 424, -112},
    // 38 seconds
    { 504, 376, 16},
    { 512, 344, 32},
    { 616, 432, 32},
    { 800, 480, 152},
    { 1000, 384, 232},
    { 1016, 360, 200},
    { 1272, 320, 152},
    { 1472, 344, 376},
    { 1144, 536, 112},
    { 1072, 272, -240},
    { 760, 576, 144},
    { 760, 272, 0},
    { 776, 256, 208},
    { 784, 168, 216},
    { 760, 192, 152},
    { 720, 280, 72},
    { 744, 368, 16},
    { 800, 392, -48},
    { 968, 336, 40},
    { 1176, 376, 56},
    { 1224, 280, 144},
    { 1680, 344, 176},
    { 1288, 304, 272},
    { 992, 144, 328},
    { 1024, -72, -112},
    // 39 seconds
    { 960, -440, 408},
    { 728, -328, 248},
    { 720, -88, -8},
    { 752, 288, -160},
    { 888, 328, -176},
    { 832, 280, -112},
    { 800, 256, 64},
    { 1024, 392, 128},
    { 1208, 376, 208},
    { 1312, 88, 216},
    { 1096, -352, 264},
    { 1576, -208, 280},
    { 992, 120, 192},
    { 896, 152, -32},
    { 736, 88, 8},
    { 672, 96, 160},
    { 632, 184, 48},
    { 696, 192, 72},
    { 784, 320, 48},
    { 840, 336, 64},
    { 920, 312, 88},
    { 928, 376, -32},
    { 992, 264, 24},
    { 1112, 176, 152},
    { 1176, 192, 256},
    // 40 seconds
    { 1472, 248, 272},
    { 1528, 352, 264},
    { 1000, 336, 248},
    { 1144, 248, 120},
    { 1072, 656, 176},
    { 496, -72, -32},
    { 776, 72, 208},
    { 816, 48, 128},
    { 776, 152, 80},
    { 712, 192, -8},
    { 704, 144, 32},
    { 712, 112, 32},
    { 872, 56, 64},
    { 1080, 136, 40},
    { 1128, 104, 120},
    { 1696, -40, 368},
    { 1512, 176, 360},
    { 1328, 464, 136},
    { 824, 520, -80},
    { 680, 256, 16},
    { 784, -8, 224},
    { 824, 56, 256},
    { 840, 264, 120},
    { 824, 344, 48},
    { 808, 424, -104},
    // 41 seconds
    { 816, 232, 0},
    { 920, 264, 16},
    { 1120, 248, -16},
    { 1184, 152, 88},
    { 1568, 152, 272},
    { 1664, 328, 288},
    { 1000, 392, 216},
    { 1192, 384, -448},
    { 968, -296, 144},
    { 808, -96, 128},
    { 880, 296, 40},
    { 816, 248, 8},
    { 656, 304, -144},
    { 608, 48, 120},
    { 592, -32, 168},
    { 632, 32, 80},
    { 832, 96, 136},
    { 1144, 152, 192},
    { 1264, 168, 176},
    { 1920, -40, 416},
    { 1392, 576, -48},
    { 1040, 672, -144},
    { 840, 256, -56},
    { 744, -88, 160},
    { 880, 80, 8},
    // 42 seconds
    { 800, 24, 160},
    { 792, 216, 56},
    { 784, 288, 24},
    { 824, 360, -24},
    { 832, 344, -104},
    { 824, 176, -48},
    { 1064, 192, -56},
    { 1304, 120, 56},
    { 1736, 240, 48},
    { 1720, 424, 120},
    { 992, 440, 32},
    { 992, 192, 32},
    { 1088, 64, 64},
    { 936, -96, 296},
    { 872, 96, 96},
    { 784, 32, 152},
    { 688, 64, 104},
    { 608, 72, 104},
    { 600, 48, 128},
    { 648, 24, 144},
    { 792, 16, 104},
    { 1152, 160, 16},
    { 1520, 56, 176},
    { 1872, -104, 536},
    { 1408, 704, -224},
    // 43 seconds
    { 1040, 752, -368},
    { 896, 224, 104},
    { 768, 48, 176},
    { 736, 56, 160},
    { 760, 232, 128},
    { 784, 368, 72},
    { 720, 384, 8},
    { 784, 304, 8},
    { 880, 256, 24},
    { 1032, 240, 32},
    { 1224, 192, 96},
    { 1200, 216, 176},
    { 1728, 312, 192},
    { 1296, 568, 104},
    { 840, 392, 40},
    { 1000, 336, 24},
    { 1184, 168, 304},
    { 1064, 176, 136},
    { 952, 152, 80},
    { 824, 16, 176},
    { 672, 0, 128},
    { 568, -16, 104},
    { 536, 16, 120},
    { 664, 64, 80},
    { 896, 112, 80},
    // 44 seconds
    { 1168, 144, 144},
    { 1792, -8, 320},
    { 1800, 152, 424},
    { 1152, 920, -320},
    { 984, 472, -136},
    { 1008, 48, 96},
    { 816, 320, 80},
    { 824, 168, 144},
    { 752, 248, 136},
    { 736, 336, 40},
    { 760, 272, 56},
    { 784, 304, 24},
    { 920, 264, 32},
    { 1112, 272, 64},
    { 1232, 264, 104},
    { 1496, 232, 200},
    { 1616, 280, 224},
    { 1088, 448, 120},
    { 920, 280, -16},
    { 1232, -296, 424},
    { 1144, -296, 488},
    { 1016, 176, 256},
    { 664, 520, 8},
    { 760, 256, 24},
    { 576, 24, 160},
    // 45 seconds
    { 608, -8, 184},
    { 664, -64, 200},
    { 808, 16, 200},
    { 944, 152, 120},
    { 1192, 208, 216},
    { 1824, 96, 472},
    { 1616, 600, 88},
    { 792, 712, -16},
    { 912, 168, 208},
    { 856, 448, 112},
    { 728, 192, 288},
    { 752, 248, 304},
    { 752, 256, 184},
    { 760, 248, 112},
    { 744, 304, 40},
    { 848, 264, 56},
    { 928, 248, 80},
    { 1120, 216, 112},
    { 1200, 208, 200},
    { 1528, 240, 280},
    { 1432, 392, 192},
    { 864, 392, 176},
    { 952, 264, 56},
    { 1088, 128, 256},
    { 1040, 144, 184},
    // 46 seconds
    { 872, 144, 176},
    { 752, 112, 64},
    { 648, 80, 64},
    { 576, 88, 144},
    { 584, 72, 160},
    { 664, 112, 152},
    { 888, 176, 208},
    { 1080, 280, 112},
    { 1168, 328, 80},
    { 1616, 72, 336},
    { 1480, 368, 56},
    { 1192, 576, -208},
    { 864, 328, -120},
    { 728, 88, 40},
    { 720, 112, 88},
    { 776, 112, 192},
    { 760, 216, 168},
    { 688, 296, 72},
    { 704, 248, 40},
    { 800, 328, -64},
    { 896, 256, 24},
    { 1080, 248, 56},
    { 1208, 208, 80},
    { 1584, 248, 144},
    { 1568, 344, 136},
    // 47 seconds
    { 1000, 352, 96},
    { 984, 304, -192},
    { 864, -208, 272},
    { 880, 200, 112},
    { 832, 184, 136},
    { 776, 128, 104},
    { 712, 88, 72},
    { 648, 40, 128},
    { 672, 40, 160},
    { 744, 56, 128},
    { 928, 104, 88},
    { 1112, 120, 144},
    { 1400, 32, 264},
    { 1688, 64, 336},
    { 1256, 584, -120},
    { 1016, 360, -216},
    { 856, 152, -88},
    { 840, 144, -24},
    { 768, 184, -64},
    { 744, 80, 16},
    { 728, 144, 24},
    { 672, 176, 88},
    { 704, 304, -24},
    { 752, 192, 56},
    { 936, 184, 136},
    // 48 seconds
    { 1168, 232, 152},
    { 1240, 296, 256},
    { 1792, 328, 384},
    { 1392, 696, 256},
    { 720, 480, 40},
    { 1016, 208, 120},
    { 1248, 136, 184},
    { 1088, 144, 192},
    { 896, 144, 48},
    { 824, 96, 88},
    { 720, -40, 128},
    { 592, -64, 112},
    { 616, -8, 80},
    { 704, 72, 80},
    { 880, 160, -48},
    { 1232, 256, -80},
    { 1672, -96, 352},
    { 1632, -64, 432},
    { 1240, 288, 88},
    { 896, 376, -56},
    { 888, 248, 16},
    { 800, 120, 120},
    { 784, 104, 152},
    { 792, 216, 96},
    { 776, 304, -24},
    // 49 seconds
    { 752, 256, -32},
    { 840, 272, -80},
    { 928, 248, -88},
    { 944, 208, -40},
    { 1136, 168, 24},
    { 1224, 208, 72},
    { 1584, 232, 80},
    { 1360, 432, 104},
    { 1016, 440, 224},
    { 1032, 392, 120},
    { 1056, 632, 152},
    { 1048, 424, 384},
    { 1056, 416, 136},
    { 960, 264, 192},
    { 888, 176, 176},
    { 752, 80, 136},
    { 640, 0, 128},
    { 640, -8, 112},
    { 736, 40, 72},
    { 848, 160, -16},
    { 1168, 120, 48},
    { 1408, 96, 256},
    { 1272, 352, 144},
    { 1200, 448, -24},
    { 1088, 528, -40},
    // 50 seconds
    { 936, 328, 144},
    { 904, 272, 176},
    { 896, 280, 184},
    { 872, 344, 136},
    { 832, 336, 104},
    { 864, 360, 32},
    { 888, 392, -8},
    { 936, 376, -24},
    { 1088, 384, -16},
    { 1152, 408, 24},
    { 1560, 416, 72},
    { 1592, 496, 96},
    { 1032, 416, 152},
    { 992, 304, 120},
    { 1072, 280, 168},
    { 1008, 208, 208},
    { 968, 176, 240},
    { 936, 112, 272},
    { 856, 144, 144},
    { 784, 104, 128},
    { 704, 120, 112},
    { 704, 96, 40},
    { 840, 88, -24},
    { 984, 104, -72},
    { 1112, -16, 32},
    // 51 seconds
    { 1552, -192, 240},
    { 1440, 80, 200},
    { 1208, 336, -8},
    { 1008, 328, -64},
    { 968, 240, 104},
    { 936, 200, 144},
    { 1000, 240, 200},
    { 1000, 368, 176},
    { 888, 440, 56},
    { 768, 376, 16},
    { 824, 472, -48},
    { 928, 376, -16},
    { 1088, 416, 16},
    { 1248, 336, 192},
    { 1560, 400, 232},
    { 1760, 240, 440},
    { 1224, 440, 256},
    { 1272, 336, 96},
    { 1536, 544, -224},
    { 1048, -536, -88},
    { 1016, 136, 464},
    { 864, -24, 160},
    { 616, 48, -80},
    { 480, 32, -16},
    { 488, 56, 128},
    // 52 seconds
    { 472, 152, -24},
    { 664, 160, 80},
    { 952, 104, 224},
    { 1168, 264, 176},
    { 1424, 176, 216},
    { 1960, 104, 504},
    { 1592, 736, 48},
    { 1744, 680, -400},
    { 736, 224, 96},
    { 824, 136, 200},
    { 808, 136, 208},
    { 752, 224, 160},
    { 736, 272, 104},
    { 680, 296, 56},
    { 792, 304, 24},
    { 912, 256, 72},
    { 1032, 312, 40},
    { 1176, 232, 96},
    { 1472, 176, 128},
    { 1808, 256, 152},
    { 1208, 480, 32},
    { 1400, 288, -88},
    { 1040, -336, 320},
    { 1056, 184, 80},
    { 952, 200, 72},
    // 53 seconds
    { 776, 128, 72},
    { 568, 144, 24},
    { 512, 80, 64},
    { 568, 136, 0},
    { 560, 48, 112},
    { 584, 16, 176},
    { 832, 136, 136},
    { 1096, 216, 120},
    { 1800, 72, 344},
    { 1856, 392, 288},
    { 1384, 968, -192},
    { 1280, 304, -288},
    { 864, 144, 216},
    { 872, 112, 200},
    { 824, 120, 264},
    { 856, 168, 328},
    { 664, 344, 64},
    { 744, 312, -32},
    { 712, 336, -80},
    { 856, 312, 56},
    { 1080, 376, 56},
    { 1312, 488, 144},
    { 1624, 424, 208},
    { 1616, 320, 160},
    { 1216, 328, 176},
    // 54 seconds
    { 1256, 296, 200},
    { 1024, 40, 336},
    { 888, -520, 416},
    { 968, 112, 128},
    { 704, 8, 184},
    { 616, 136, 40},
    { 496, 88, 48},
    { 480, 80, 104},
    { 552, 192, 48},
    { 680, 168, 88},
    { 992, 160, 88},
    { 1352, -80, 272},
    { 1704, -8, 352},
    { 1592, 536, -88},
    { 1216, 664, -328},
    { 1072, 440, 48},
    { 872, 536, -8},
    { 760, 144, 64},
    { 752, 296, 80},
    { 808, 352, 72},
    { 752, 400, 40},
    { 736, 328, 48},
    { 808, 360, -8},
    { 904, 264, 32},
    { 1144, 272, 32},
    // 55 seconds
    { 1216, 256, 104},
    { 1760, 288, 144},
    { 1408, 464, 48},
    { 904, 376, 24},
    { 1128, 320, -160},
    { 1128, 32, 440},
    { 1080, 216, 128},
    { 848, 176, 96},
    { 736, 112, 112},
    { 616, 104, 104},
    { 560, 64, 216},
    { 584, 168, 304},
    { 712, 296, 136},
    { 912, 96, 88},
    { 1152, 240, 16},
    { 1640, 24, 152},
    { 1448, 312, -160},
    { 1184, 232, -112},
    { 992, 352, -40},
    { 864, 456, 32},
    { 768, 288, 88},
    { 776, 240, 136},
    { 768, 272, 120},
    { 736, 328, 160},
    { 744, 360, 248},
    // 56 seconds
    { 752, 656, 184},
    { 800, 616, 296},
    { 912, 496, 360},
    { 1088, 408, 504},
    { 1416, 424, 472},
    { 1600, 432, 416},
    { 1072, 512, 224},
    { 920, 272, 112},
    { 856, 112, 40},
    { 856, 88, 288},
    { 840, 240, 136},
    { 696, 192, 56},
    { 560, 192, 56},
    { 584, 232, 80},
    { 592, 232, 112},
    { 624, 240, 152},
    { 840, 328, 200},
    { 1056, 320, 192},
    { 1152, 320, 176},
    { 1568, 88, 352},
    { 1376, 392, 128},
    { 1048, 344, 24},
    { 1056, 480, 0},
    { 800, 224, 296},
    { 704, 520, 288},
    // 57 seconds
    { 648, 192, 256},
    { 808, 312, 240},
    { 696, 264, 312},
    { 800, 288, 240},
    { 688, 328, 112},
    { 816, 504, 256},
    { 1056, 504, 256},
    { 1056, 352, 392},
    { 1304, 320, 424},
    { 1312, 392, 216},
    { 1176, 864, 304},
    { 864, 472, 296},
    { 1128, 280, 352},
    { 1040, 176, 352},
    { 768, 136, 64},
    { 672, 280, -232},
    { 600, 224, -160},
    { 552, 176, 40},
    { 576, 296, 0},
    { 616, 384, -56},
    { 680, 264, 248},
    { 848, 32, 592},
    { 1320, 640, -160},
    { 1688, 160, 464},
    { 1584, 200, 552},
    // 58 seconds
    { 664, 544, -272},
    { 776, 1104, -264},
    { 680, 664, 112},
    { 512, 424, 32},
    { 528, 616, 32},
    { 552, 680, 176},
    { 608, 528, 216},
    { 560, 368, -56},
    { 536, 192, -112},
    { 560, 216, -160},
    { 752, 216, -40},
    { 1056, 408, 8},
    { 1240, 536, 64},
    { 1744, 616, 200},
    { 1456, 728, 200},
    { 888, 656, -16},
    { 792, 256, 16},
    { 760, 112, 128},
    { 768, 224, 64},
    { 704, 248, 64},
    { 760, 288, 16},
    { 712, 240, 120},
    { 720, 280, 112},
    { 728, 256, 104},
    { 872, 208, 152},
    // 59 seconds
    { 1032, 264, 112},
    { 1104, 264, 128},
    { 1152, 128, 144},
    { 1808, -48, 272},
    { 1112, 696, -208},
    { 880, 168, -168},
    { 872, 16, -80},
    { 768, 104, 56},
    { 768, 208, -40},
    { 720, 208, -40},
    { 728, 216, 8},
    { 736, 248, -8},
    { 736, 280, -72},
    { 712, 296, -48},
    { 712, 352, -40},
    { 768, 376, -72},
    { 856, 464, -56},
    { 920, 416, 88},
    { 1552, 384, 176},
    { 1448, 520, 136},
    { 1288, 432, 232},
    { 1112, 200, 104},
    { 808, 200, -88},
    { 592, 48, 312},
    { 856, 104, 248},
    // 60 seconds
    // elapsed: 1 minutes
    { 960, 144, 168},
    { 976, 144, 56},
    { 920, 88, 176},
    { 960, 184, 192},
    { 920, 264, 96},
    { 952, 264, 136},
    { 1016, 360, 224},
    { 936, 488, 168},
    { 920, 608, 168},
    { 888, 632, 192},
    { 816, 688, 176},
    { 792, 856, 144},
    { 704, 992, 112},
    { 664, 1152, 104},
    { 488, 1096, 24},
    { 440, 992, -16},
    { 368, 800, 40},
    { 272, 728, 0},
    { 216, 760, -88},
    { 72, 496, -40},
    { 56, 664, -120},
    { 112, 536, -232},
    { 64, 928, -384},
    { -192, 1072, -416},
    { -152, 768, -336},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-03 08:53:39 local
AccelRawData *activity_sample_walk_100_pbl_25531_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25531_4
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 336, 72, -920},
    { 376, -24, -944},
    { 480, 24, -960},
    { 488, -8, -952},
    { 440, -104, -920},
    { 304, -112, -928},
    { 456, -56, -960},
    { 376, -136, -976},
    { 352, -152, -928},
    { 304, -160, -968},
    { 384, -160, -960},
    { 288, -192, -976},
    { 368, -128, -888},
    { 280, -184, -1000},
    { 128, -272, -992},
    { 184, -392, -920},
    { 128, -328, -1048},
    { 64, -400, -992},
    { 192, -344, -976},
    { 168, -312, -968},
    { 80, -336, -1024},
    { -144, -560, -776},
    { 1008, 8, -1312},
    { 408, -264, -1088},
    { 664, -272, -1208},
    // 1 seconds
    { 560, 248, -1144},
    { 224, 608, -768},
    { -600, 720, -104},
    { -1056, 1256, -344},
    { -552, 712, 48},
    { -728, 600, 80},
    { -360, 320, -464},
    { -552, 272, -312},
    { -656, 472, -160},
    { -688, 608, -200},
    { -728, 480, -152},
    { -800, 528, -56},
    { -872, 544, -16},
    { -912, 536, -32},
    { -816, 496, -64},
    { -808, 552, -120},
    { -872, 544, 0},
    { -832, 512, -8},
    { -840, 448, -56},
    { -824, 528, -128},
    { -880, 456, 24},
    { -872, 504, -48},
    { -944, 528, -80},
    { -688, 480, -480},
    { -480, 312, -408},
    // 2 seconds
    { -272, 16, -240},
    { -104, -104, -328},
    { 40, 8, -376},
    { 104, 120, -40},
    { 376, 280, 16},
    { 1688, 1712, 264},
    { 1168, 1376, 408},
    { 1264, 728, 312},
    { 1688, 720, 384},
    { 1912, 960, 504},
    { 1640, 648, 288},
    { 1416, 592, 200},
    { 1232, 504, 328},
    { 1000, 528, 216},
    { 888, 416, 192},
    { 832, 320, 200},
    { 824, 224, 168},
    { 768, 272, 72},
    { 800, 280, 24},
    { 808, 368, 40},
    { 992, 424, 16},
    { 912, 400, 64},
    { 1112, 336, 184},
    { 1264, 280, 352},
    { 1568, 264, 416},
    // 3 seconds
    { 1520, 400, 320},
    { 1080, 272, 176},
    { 760, 472, 144},
    { 880, 264, 136},
    { 912, -96, 376},
    { 904, 112, 312},
    { 760, 240, 32},
    { 672, 216, -48},
    { 648, 176, 24},
    { 720, 200, 0},
    { 720, 88, 80},
    { 760, 64, 136},
    { 960, 72, 176},
    { 1336, 128, 216},
    { 1408, 120, 296},
    { 1664, 144, 304},
    { 1376, 432, 152},
    { 912, 464, -112},
    { 696, 224, 16},
    { 736, 152, 88},
    { 736, 16, 216},
    { 744, 112, 240},
    { 776, 192, 200},
    { 776, 288, 144},
    { 792, 304, 72},
    // 4 seconds
    { 864, 248, 64},
    { 912, 120, 32},
    { 1160, -272, -176},
    { 1160, -64, -336},
    { 1624, 336, 56},
    { 1904, 400, 192},
    { 1136, 408, 160},
    { 616, 144, 112},
    { 608, -600, 448},
    { 816, -400, 432},
    { 768, -384, 344},
    { 744, -64, 224},
    { 752, 24, 264},
    { 824, 264, 176},
    { 792, 328, 160},
    { 800, 152, 120},
    { 872, 64, 144},
    { 1112, 160, 88},
    { 1136, -40, 216},
    { 1552, -224, 312},
    { 1328, 128, 152},
    { 936, 256, 56},
    { 832, 104, -64},
    { 792, 16, 200},
    { 808, -96, 288},
    // 5 seconds
    { 784, -16, 144},
    { 800, -80, 160},
    { 776, 16, 168},
    { 912, 48, 112},
    { 896, 176, -72},
    { 960, -24, -64},
    { 1024, 144, -80},
    { 1256, 136, 240},
    { 1608, 16, 464},
    { 1592, 96, 352},
    { 1048, 216, 272},
    { 656, 136, 152},
    { 824, 32, 120},
    { 1032, -64, -112},
    { 792, -288, 144},
    { 632, -208, 160},
    { 816, -24, 184},
    { 872, 128, 248},
    { 896, 256, 240},
    { 816, 248, 192},
    { 832, 80, 216},
    { 1080, 48, 280},
    { 1152, -160, 304},
    { 1712, -248, 464},
    { 1376, 128, 272},
    // 6 seconds
    { 656, 392, -184},
    { 752, 112, -24},
    { 872, -48, 136},
    { 832, -64, 192},
    { 824, 32, 80},
    { 792, 144, 24},
    { 784, 152, 32},
    { 800, 112, 24},
    { 824, 64, 56},
    { 856, 56, 80},
    { 1016, 16, 56},
    { 1264, 104, 176},
    { 1640, 120, 288},
    { 1504, 400, 120},
    { 920, 312, 104},
    { 912, 168, 112},
    { 1040, 24, 40},
    { 928, -96, 376},
    { 632, 0, 176},
    { 712, 32, 112},
    { 744, 64, 144},
    { 768, 192, 112},
    { 800, 64, 176},
    { 848, 160, 240},
    { 1016, 48, 264},
    // 7 seconds
    { 1160, -8, 264},
    { 1424, -152, 304},
    { 1320, 168, 104},
    { 920, 440, 160},
    { 1024, 536, -112},
    { 752, 240, -16},
    { 752, 48, 200},
    { 696, 8, 232},
    { 768, 120, 184},
    { 808, 232, 104},
    { 816, 224, 112},
    { 832, 240, 112},
    { 904, 184, 128},
    { 1016, 104, 176},
    { 1264, 96, 184},
    { 1520, 72, 312},
    { 1568, 128, 184},
    { 1096, 192, -248},
    { 848, 128, -64},
    { 800, -288, 48},
    { 864, -256, 288},
    { 760, -264, 272},
    { 672, -112, 192},
    { 760, -48, 224},
    { 856, 168, 184},
    // 8 seconds
    { 720, 88, 256},
    { 880, 88, 304},
    { 1016, 80, 328},
    { 1216, -72, 384},
    { 1408, -216, 304},
    { 1584, 384, -32},
    { 1056, 432, 32},
    { 752, 152, 56},
    { 904, -168, 128},
    { 984, -144, 32},
    { 800, -128, -48},
    { 744, 80, -8},
    { 800, 80, 64},
    { 800, 152, 120},
    { 760, 96, 72},
    { 792, 40, 88},
    { 896, 24, 104},
    { 1144, 40, 184},
    { 1528, 96, 408},
    { 1752, 264, 400},
    { 1176, 440, 152},
    { 776, 176, 120},
    { 984, -112, -160},
    { 720, -608, 168},
    { 712, -312, 344},
    // 9 seconds
    { 760, -272, 184},
    { 832, -88, 144},
    { 832, 80, 128},
    { 896, 88, 288},
    { 888, 48, 312},
    { 984, 96, 288},
    { 1048, 24, 288},
    { 1160, -96, 408},
    { 1576, -32, 328},
    { 1104, 496, 64},
    { 976, 120, 40},
    { 976, -336, -80},
    { 944, -528, 40},
    { 840, -560, 288},
    { 528, 136, -136},
    { 816, 200, 160},
    { 864, 144, 216},
    { 776, 216, 64},
    { 840, 88, 96},
    { 880, 112, 152},
    { 1056, 152, 192},
    { 1240, 96, 280},
    { 1536, 48, 384},
    { 1600, 32, 120},
    { 992, 24, -184},
    // 10 seconds
    { 784, -120, 88},
    { 824, -320, 224},
    { 880, -64, 240},
    { 752, 112, 8},
    { 784, -96, 112},
    { 688, -160, 192},
    { 832, -24, 208},
    { 888, 64, 240},
    { 944, 88, 264},
    { 1048, 128, 216},
    { 1120, 72, 208},
    { 1400, -160, 312},
    { 1512, 88, 240},
    { 1032, 176, 208},
    { 1120, -112, -216},
    { 960, -480, -264},
    { 696, -600, 224},
    { 672, -256, 224},
    { 720, 96, 152},
    { 760, 344, 120},
    { 736, 216, 96},
    { 760, 136, 72},
    { 824, 88, 32},
    { 1040, 0, 24},
    { 1216, 144, 96},
    // 11 seconds
    { 1624, 80, 272},
    { 1704, 56, 136},
    { 1072, 160, -96},
    { 864, 88, 80},
    { 880, -216, 224},
    { 752, -296, 272},
    { 712, -216, 176},
    { 720, -80, 80},
    { 784, 16, 88},
    { 840, 56, 128},
    { 816, 40, 200},
    { 792, 32, 248},
    { 848, 120, 216},
    { 1016, 184, 168},
    { 1072, 56, 192},
    { 1560, -216, 192},
    { 1736, 8, 192},
    { 1440, 360, -16},
    { 1120, 160, -208},
    { 1080, -192, -296},
    { 832, -720, 112},
    { 368, -560, 208},
    { 584, -224, 136},
    { 760, 376, 280},
    { 728, 544, 88},
    // 12 seconds
    { 640, 320, 64},
    { 712, 272, 16},
    { 712, 160, -56},
    { 944, 144, 8},
    { 1400, 152, 328},
    { 1888, 528, 392},
    { 1280, 720, 248},
    { 1016, 496, -16},
    { 1008, 336, -40},
    { 904, 80, 104},
    { 640, 32, 160},
    { 656, 72, 112},
    { 680, 56, 120},
    { 680, 104, 136},
    { 776, 128, 168},
    { 928, 88, 184},
    { 1128, 128, 208},
    { 1192, 104, 144},
    { 1768, -144, 304},
    { 1552, 136, 168},
    { 952, 336, -136},
    { 808, 64, -160},
    { 704, -224, 8},
    { 688, -88, 56},
    { 688, 144, -40},
    // 13 seconds
    { 752, 232, -80},
    { 720, 232, -8},
    { 744, 264, -88},
    { 736, 136, 0},
    { 920, 160, 16},
    { 1192, 192, 24},
    { 1376, 296, 96},
    { 1712, 304, 96},
    { 1464, 560, -40},
    { 968, 400, 136},
    { 968, 200, 136},
    { 1088, 192, 104},
    { 912, 48, 216},
    { 832, 232, 112},
    { 800, 152, 40},
    { 784, 160, 24},
    { 800, 160, -16},
    { 744, -8, 96},
    { 880, -72, 184},
    { 1032, -16, 120},
    { 1144, 64, 184},
    { 1576, -112, 504},
    { 1256, 216, 232},
    { 952, 672, -128},
    { 952, 584, -8},
    // 14 seconds
    { 920, 80, 192},
    { 792, 120, 16},
    { 752, 312, -88},
    { 736, 336, -24},
    { 776, 408, -16},
    { 728, 352, 16},
    { 840, 240, 72},
    { 1000, 280, 72},
    { 1240, 280, 104},
    { 1296, 392, 64},
    { 1688, 800, -128},
    { 1472, 568, 40},
    { 960, 40, 272},
    { 784, -48, 352},
    { 592, 168, -240},
    { 640, -584, 528},
    { 584, -224, 344},
    { 616, -216, 240},
    { 696, 312, 112},
    { 760, 368, 104},
    { 736, 248, 56},
    { 816, 160, 80},
    { 1072, -8, 224},
    { 1296, 8, 256},
    { 1296, 24, 248},
    // 15 seconds
    { 1560, -72, 352},
    { 1224, 496, -168},
    { 896, 456, -96},
    { 960, 216, 48},
    { 736, 176, 104},
    { 696, 208, 272},
    { 736, 376, 184},
    { 768, 304, 368},
    { 648, 104, 56},
    { 616, 416, -88},
    { 672, 192, 152},
    { 888, 72, 128},
    { 1168, 224, 64},
    { 1336, 240, 208},
    { 1736, 320, 296},
    { 1448, 456, 224},
    { 824, 440, 168},
    { 784, 224, 48},
    { 1160, -24, -80},
    { 864, -240, 320},
    { 648, -232, 264},
    { 704, -120, 272},
    { 688, 224, 168},
    { 728, 280, 128},
    { 808, 232, 136},
    // 16 seconds
    { 824, 48, 176},
    { 1024, 96, 112},
    { 1264, 168, 104},
    { 1456, 120, 192},
    { 1688, -24, 312},
    { 1000, 424, -128},
    { 784, 144, -56},
    { 872, -96, 136},
    { 736, 248, 64},
    { 768, 272, 152},
    { 776, 304, 88},
    { 720, 240, 168},
    { 712, 192, 208},
    { 712, 248, 96},
    { 728, 280, 16},
    { 808, 296, 16},
    { 1024, 152, 104},
    { 1376, 400, 392},
    { 1744, 472, 384},
    { 1528, 528, 200},
    { 896, 288, -40},
    { 824, 216, -128},
    { 848, 40, 208},
    { 960, 104, 280},
    { 816, 192, 216},
    // 17 seconds
    { 752, 152, 88},
    { 648, 0, 208},
    { 616, 80, 208},
    { 712, 176, 160},
    { 800, 176, 216},
    { 976, 280, 240},
    { 1232, 144, 264},
    { 1280, 104, 232},
    { 1496, 88, 176},
    { 1240, 280, 56},
    { 1056, 560, -296},
    { 968, 112, -176},
    { 872, 56, -24},
    { 712, 32, 96},
    { 704, 144, 40},
    { 712, 264, 0},
    { 688, 208, 120},
    { 640, 272, 32},
    { 640, 232, 112},
    { 744, 352, 104},
    { 928, 416, 104},
    { 1112, 456, 152},
    { 1448, 376, 264},
    { 1712, 512, 216},
    { 1128, 608, 208},
    // 18 seconds
    { 744, 384, -16},
    { 800, 392, 24},
    { 696, 184, 16},
    { 848, 120, 280},
    { 880, 200, 136},
    { 712, 184, 24},
    { 672, 176, 120},
    { 704, 184, 152},
    { 752, 216, 136},
    { 872, 224, 136},
    { 976, 312, 48},
    { 1096, 56, 240},
    { 1624, 64, 344},
    { 1344, 592, 24},
    { 952, 472, -176},
    { 760, -56, 32},
    { 832, 160, 104},
    { 752, 160, 176},
    { 728, 376, -32},
    { 728, 208, 104},
    { 736, 320, 104},
    { 728, 360, 56},
    { 736, 192, 128},
    { 888, 328, 0},
    { 1056, 256, 24},
    // 19 seconds
    { 1128, 256, 112},
    { 1336, 208, 136},
    { 1480, 240, 160},
    { 1224, 344, 288},
    { 1048, 256, 168},
    { 984, -184, 112},
    { 872, 256, 64},
    { 672, 80, 128},
    { 720, -16, 224},
    { 744, 72, 176},
    { 728, 104, 128},
    { 768, 80, 152},
    { 832, 88, 128},
    { 848, 48, 152},
    { 1120, 104, 136},
    { 1120, 208, 96},
    { 1736, -40, 296},
    { 1584, 216, 160},
    { 1184, 504, -64},
    { 768, 112, 8},
    { 720, 8, 88},
    { 720, 88, 168},
    { 712, 144, 200},
    { 712, 208, 88},
    { 680, 176, 96},
    // 20 seconds
    { 664, 184, 72},
    { 768, 224, 48},
    { 864, 192, 80},
    { 968, 232, 88},
    { 1176, 208, 0},
    { 1544, 112, 248},
    { 1712, 344, 128},
    { 1056, 344, 64},
    { 1064, 80, 0},
    { 928, 56, 32},
    { 768, -32, 152},
    { 664, 72, 152},
    { 688, 152, 40},
    { 720, 104, 96},
    { 752, 128, 136},
    { 752, 72, 160},
    { 800, 64, 184},
    { 1024, 64, 240},
    { 1160, 152, 200},
    { 1392, 0, 304},
    { 1736, 40, 296},
    { 1120, 576, -264},
    { 912, 184, -160},
    { 784, -168, 48},
    { 768, -112, 80},
    // 21 seconds
    { 696, 136, 8},
    { 736, 160, 0},
    { 712, 136, 40},
    { 688, 160, 0},
    { 672, 200, 0},
    { 728, 184, 40},
    { 912, 208, -32},
    { 1096, 256, 32},
    { 1232, 368, 80},
    { 1816, 216, 264},
    { 1560, 480, 248},
    { 1008, 432, 136},
    { 736, 264, 8},
    { 944, 128, 160},
    { 912, 192, 24},
    { 736, -48, 216},
    { 824, 88, 128},
    { 768, 56, 184},
    { 808, 120, 168},
    { 800, 96, 160},
    { 784, 0, 208},
    { 896, 64, 136},
    { 1064, 88, 168},
    { 1376, 16, 280},
    { 1720, 64, 216},
    // 22 seconds
    { 1320, 520, -256},
    { 976, 296, -176},
    { 704, -88, 16},
    { 768, -72, 40},
    { 728, 216, 72},
    { 744, 312, 24},
    { 752, 224, 64},
    { 728, 192, 48},
    { 688, 272, -8},
    { 704, 160, 104},
    { 816, 256, 48},
    { 1080, 192, 176},
    { 1304, 272, 192},
    { 1960, 192, 352},
    { 1528, 528, 128},
    { 840, 496, 72},
    { 808, 288, 16},
    { 1192, 328, -168},
    { 856, -152, 304},
    { 696, -416, 24},
    { 816, -24, 144},
    { 688, 64, 168},
    { 696, 176, 72},
    { 672, 88, 104},
    { 760, 16, 200},
    // 23 seconds
    { 1152, 80, 224},
    { 1512, 80, 296},
    { 1656, 8, 336},
    { 1544, 72, 152},
    { 928, 488, -256},
    { 768, 112, -24},
    { 696, -32, -8},
    { 680, 160, 8},
    { 696, 248, -16},
    { 728, 232, -16},
    { 736, 256, 24},
    { 704, 208, 88},
    { 720, 200, 96},
    { 840, 288, 80},
    { 1128, 280, 152},
    { 1312, 280, 160},
    { 1304, 280, 256},
    { 1568, 440, 144},
    { 1248, 592, 152},
    { 728, 392, 184},
    { 1000, 96, 32},
    { 824, -408, 296},
    { 760, -248, 48},
    { 792, 104, 56},
    { 784, 64, 104},
    // 24 seconds
    { 624, 96, 80},
    { 632, 80, 96},
    { 736, 48, 104},
    { 912, 48, 144},
    { 1200, 72, 184},
    { 1376, 104, 208},
    { 1664, 152, 160},
    { 1448, 248, 64},
    { 952, 512, -176},
    { 864, 296, -200},
    { 728, -72, 104},
    { 704, 104, 176},
    { 720, 128, 152},
    { 800, 128, 152},
    { 744, 216, 104},
    { 720, 288, -48},
    { 752, 136, 56},
    { 888, 192, 24},
    { 1008, 144, 24},
    { 1216, 248, -32},
    { 1384, 232, 56},
    { 1680, 368, 24},
    { 1232, 504, 80},
    { 888, 248, 176},
    { 960, 56, 184},
    // 25 seconds
    { 1128, -80, -8},
    { 824, -584, 200},
    { 800, 96, 40},
    { 784, 80, 72},
    { 672, 104, 56},
    { 640, 24, 104},
    { 712, 0, 120},
    { 872, 40, 168},
    { 1032, 160, 144},
    { 1312, 96, 296},
    { 1744, 104, 272},
    { 1232, 512, -80},
    { 944, 344, -104},
    { 784, 32, 16},
    { 792, 24, 128},
    { 792, 304, 48},
    { 872, 280, 112},
    { 760, 216, 112},
    { 768, 216, 24},
    { 768, 176, 48},
    { 792, 184, 32},
    { 864, 208, 8},
    { 1016, 136, 48},
    { 1296, 168, 168},
    { 1512, 136, 240},
    // 26 seconds
    { 1672, 176, 264},
    { 976, 352, 152},
    { 824, 168, 32},
    { 1160, 48, -192},
    { 968, -272, 168},
    { 696, -88, 88},
    { 720, -16, 168},
    { 752, 176, 48},
    { 800, 232, 72},
    { 840, 152, 200},
    { 888, 40, 272},
    { 848, 32, 256},
    { 1072, 80, 176},
    { 1280, -16, 288},
    { 1680, 80, 200},
    { 1296, 312, 24},
    { 840, 448, -272},
    { 880, -40, -104},
    { 872, 8, -32},
    { 728, -144, 216},
    { 832, 96, 136},
    { 776, 144, 112},
    { 720, 248, 8},
    { 656, 192, -8},
    { 672, 144, 72},
    // 27 seconds
    { 736, 248, 32},
    { 848, 208, 48},
    { 1192, 296, 32},
    { 1408, 360, 192},
    { 1672, 368, 288},
    { 1328, 520, 168},
    { 712, 360, 56},
    { 808, 176, -16},
    { 1112, -24, 72},
    { 912, -48, 248},
    { 720, -128, 184},
    { 832, 88, 160},
    { 760, 200, 104},
    { 760, 184, 80},
    { 776, 104, 136},
    { 848, 32, 160},
    { 992, 96, 112},
    { 1136, 104, 128},
    { 1704, -72, 312},
    { 1480, 296, 8},
    { 928, 472, -136},
    { 960, 120, -144},
    { 840, -112, 96},
    { 736, 192, 48},
    { 768, 80, 120},
    // 28 seconds
    { 744, 104, 184},
    { 712, 104, 152},
    { 712, 168, 120},
    { 728, 192, 104},
    { 800, 120, 8},
    { 992, 96, -24},
    { 1304, 184, -48},
    { 1624, 248, 128},
    { 1704, 376, 120},
    { 1096, 288, 24},
    { 824, 216, -64},
    { 888, -352, 72},
    { 1008, -448, 312},
    { 656, -288, 208},
    { 792, -88, 136},
    { 848, 24, 120},
    { 856, 168, 80},
    { 736, 128, 120},
    { 768, 32, 176},
    { 880, 80, 256},
    { 1192, 8, 296},
    { 1320, 72, 40},
    { 1584, -168, 72},
    { 1488, 112, -8},
    { 960, 456, -280},
    // 29 seconds
    { 1040, 224, -424},
    { 952, -200, -144},
    { 672, -224, 328},
    { 768, 32, 176},
    { 728, 88, 144},
    { 648, 288, -40},
    { 584, 320, -40},
    { 640, 176, 80},
    { 720, 128, 96},
    { 936, 264, 80},
    { 1120, 344, 160},
    { 1456, 536, 120},
    { 1720, 432, 168},
    { 1192, 648, 192},
    { 832, 408, 104},
    { 968, 144, 160},
    { 992, 152, 56},
    { 808, 144, 88},
    { 728, 48, 48},
    { 768, 88, 112},
    { 744, 112, 128},
    { 760, 112, 104},
    { 808, 72, 136},
    { 1024, 40, 184},
    { 1168, 96, 144},
    // 30 seconds
    { 1160, 152, 112},
    { 1552, 48, 216},
    { 1168, 392, -16},
    { 952, 384, -136},
    { 896, 48, 8},
    { 792, 72, 72},
    { 712, 96, 112},
    { 744, 192, 48},
    { 752, 184, 72},
    { 728, 208, 16},
    { 736, 136, 56},
    { 800, 192, -16},
    { 952, 200, -72},
    { 1176, 136, -16},
    { 1264, 224, 88},
    { 1568, 168, 176},
    { 1432, 360, 72},
    { 832, 344, 80},
    { 856, 144, 56},
    { 1096, 40, 48},
    { 1008, -112, 208},
    { 616, -192, 136},
    { 768, 88, 48},
    { 712, 120, 72},
    { 704, 168, 48},
    // 31 seconds
    { 704, 88, 104},
    { 760, 72, 104},
    { 896, 72, 128},
    { 1160, 120, 136},
    { 1176, 152, 160},
    { 1752, -8, 304},
    { 1336, 432, 8},
    { 888, 456, -160},
    { 872, 72, -48},
    { 864, -40, 128},
    { 696, -8, 160},
    { 728, 136, 120},
    { 768, 272, 72},
    { 728, 184, 88},
    { 696, 168, 96},
    { 760, 208, 56},
    { 880, 256, 8},
    { 1008, 0, 16},
    { 1176, 200, -56},
    { 1552, 240, 168},
    { 1744, 592, 48},
    { 1056, 552, 96},
    { 888, 152, -96},
    { 912, 208, 96},
    { 864, 80, 192},
    // 32 seconds
    { 864, 72, 152},
    { 784, 0, 192},
    { 744, 72, 136},
    { 728, 80, 120},
    { 728, 72, 160},
    { 776, 64, 200},
    { 928, 104, 160},
    { 1080, 256, 80},
    { 1152, 176, 160},
    { 1688, -16, 368},
    { 1056, 416, 8},
    { 968, 440, -160},
    { 1000, 264, -88},
    { 968, -184, -88},
    { 776, 136, -88},
    { 728, 184, 48},
    { 760, 160, 152},
    { 728, 152, 72},
    { 760, 160, 24},
    { 816, 184, 24},
    { 840, 328, -32},
    { 1064, 192, -24},
    { 1224, 336, 112},
    { 1608, 256, 304},
    { 1408, 352, 200},
    // 33 seconds
    { 848, 392, 152},
    { 904, 272, 80},
    { 968, 192, 80},
    { 888, 104, 200},
    { 824, 120, 176},
    { 800, 72, 160},
    { 688, 80, 104},
    { 680, 64, 80},
    { 728, 32, 152},
    { 888, 56, 184},
    { 1112, -8, 376},
    { 1024, 216, 32},
    { 1320, -208, 288},
    { 1624, -8, 224},
    { 1216, 600, -168},
    { 896, 512, -160},
    { 824, 368, -128},
    { 808, 168, 232},
    { 720, 232, 256},
    { 752, 240, 256},
    { 728, 192, 208},
    { 664, 160, 120},
    { 736, 8, 88},
    { 752, 88, -128},
    { 928, 120, 72},
    // 34 seconds
    { 1264, 336, 120},
    { 1392, 344, 232},
    { 1672, 400, 256},
    { 1080, 464, 264},
    { 928, 104, 232},
    { 928, 272, 88},
    { 1280, 280, -160},
    { 552, -408, 64},
    { 840, 96, 152},
    { 720, -104, 288},
    { 704, 136, 120},
    { 736, 144, 32},
    { 816, 120, 72},
    { 1008, 48, 184},
    { 1240, 88, 200},
    { 1328, 0, 240},
    { 1616, 40, 216},
    { 1104, 480, -48},
    { 1032, 464, -240},
    { 856, 16, 144},
    { 752, 184, 128},
    { 800, 112, 176},
    { 704, 56, 200},
    { 672, 128, 96},
    { 664, 192, 24},
    // 35 seconds
    { 728, 176, 40},
    { 776, 160, 56},
    { 840, 192, -48},
    { 1136, 24, 48},
    { 1280, 296, 136},
    { 1648, 272, 176},
    { 1464, 512, 80},
    { 864, 376, 88},
    { 888, 328, 112},
    { 1080, 312, 16},
    { 840, 64, 336},
    { 816, 224, 136},
    { 784, 136, 96},
    { 776, 40, 176},
    { 728, -16, 192},
    { 744, -8, 176},
    { 904, 0, 192},
    { 992, 96, 128},
    { 1152, 104, 104},
    { 1632, -32, 288},
    { 1312, 400, -32},
    { 1072, 584, -200},
    { 824, 160, -72},
    { 784, -8, 64},
    { 768, 168, 104},
    // 36 seconds
    { 792, 272, 88},
    { 768, 232, 80},
    { 728, 224, 32},
    { 736, 288, -48},
    { 832, 200, 24},
    { 880, 216, 24},
    { 1088, 216, 24},
    { 1232, 200, 80},
    { 1560, 208, 192},
    { 1568, 328, 272},
    { 872, 528, 192},
    { 928, 376, -184},
    { 1096, 232, 232},
    { 848, -16, 176},
    { 744, 112, 200},
    { 768, -8, 200},
    { 664, 48, 112},
    { 656, 48, 120},
    { 704, 96, 112},
    { 752, 56, 128},
    { 944, 56, 120},
    { 1248, 80, 152},
    { 1440, 80, 184},
    { 1632, 136, 208},
    { 1032, 712, -216},
    // 37 seconds
    { 968, 264, -8},
    { 728, 88, -8},
    { 808, 40, 136},
    { 840, 64, 120},
    { 696, 88, 144},
    { 680, 256, 40},
    { 680, 248, 32},
    { 744, 192, 40},
    { 848, 184, 56},
    { 1056, 232, -24},
    { 1176, 216, 32},
    { 1296, 240, 192},
    { 1648, 328, 176},
    { 1160, 504, 120},
    { 880, 360, 80},
    { 1144, 176, 24},
    { 1008, -8, 360},
    { 824, 168, 232},
    { 824, 216, 72},
    { 776, 96, 112},
    { 672, 80, 96},
    { 664, 40, 120},
    { 672, 16, 112},
    { 784, 24, 88},
    { 1072, 64, 88},
    // 38 seconds
    { 1224, 88, 120},
    { 1736, -88, 296},
    { 1528, 280, 104},
    { 984, 600, -160},
    { 848, 248, -32},
    { 784, 56, 128},
    { 760, 80, 120},
    { 816, 128, 64},
    { 816, 256, 80},
    { 784, 304, 0},
    { 728, 232, 0},
    { 800, 216, 16},
    { 904, 208, 48},
    { 1024, 168, 48},
    { 1128, 232, 104},
    { 1456, 128, 272},
    { 1568, 216, 192},
    { 1072, 448, 208},
    { 968, 376, 64},
    { 1192, 336, 112},
    { 848, 120, 192},
    { 840, 184, 120},
    { 744, -24, 152},
    { 728, 40, 48},
    { 648, 16, 64},
    // 39 seconds
    { 648, 0, 112},
    { 776, 32, 152},
    { 1016, 80, 160},
    { 1224, 176, 168},
    { 1336, 136, 208},
    { 1736, 144, 256},
    { 1192, 320, 8},
    { 984, 384, -224},
    { 832, 176, -16},
    { 768, 24, 104},
    { 768, 48, 112},
    { 776, 64, 144},
    { 784, 216, 80},
    { 768, 232, 32},
    { 792, 200, -8},
    { 864, 160, 8},
    { 984, 120, -24},
    { 1112, 40, -48},
    { 1240, 64, 56},
    { 1824, 144, 200},
    { 1240, 416, 128},
    { 840, 208, 48},
    { 960, 24, -32},
    { 888, -152, 272},
    { 768, -80, 272},
    // 40 seconds
    { 712, 120, 120},
    { 728, 64, 112},
    { 776, 128, 104},
    { 792, 96, 120},
    { 808, 40, 152},
    { 912, 0, 168},
    { 1120, 88, 120},
    { 1216, -40, 264},
    { 1728, 104, 176},
    { 1192, 432, -32},
    { 1008, 320, -216},
    { 864, -64, 64},
    { 784, 200, 64},
    { 760, 64, 96},
    { 728, 80, 152},
    { 712, 128, 104},
    { 688, 144, 80},
    { 712, 120, 72},
    { 800, 152, -16},
    { 912, 216, -40},
    { 1104, 216, -56},
    { 1256, 272, 56},
    { 1712, 248, 200},
    { 1504, 368, 176},
    { 744, 368, 48},
    // 41 seconds
    { 816, 192, 8},
    { 1072, 88, 16},
    { 896, -56, 328},
    { 736, 200, 136},
    { 768, 120, 88},
    { 776, 56, 144},
    { 728, 88, 104},
    { 736, 32, 120},
    { 928, 80, 184},
    { 1008, 136, -16},
    { 1096, 128, 40},
    { 1576, -96, 120},
    { 1544, -56, 176},
    { 1016, 320, -144},
    { 880, 272, -240},
    { 768, 24, 32},
    { 760, -120, 152},
    { 856, 16, 120},
    { 832, 168, 96},
    { 784, 248, 56},
    { 744, 176, 8},
    { 784, 160, 0},
    { 856, 136, 0},
    { 992, 32, -16},
    { 1168, 24, 0},
    // 42 seconds
    { 1344, 112, 136},
    { 1624, 184, 112},
    { 1200, 224, 144},
    { 872, 144, 48},
    { 952, 24, 40},
    { 1048, -168, 120},
    { 824, -232, 224},
    { 608, -56, 80},
    { 760, 232, 40},
    { 784, 152, 136},
    { 752, 56, 128},
    { 792, 16, 152},
    { 904, 56, 176},
    { 1128, 136, 128},
    { 1240, 176, 120},
    { 1680, 16, 208},
    { 1328, 272, 16},
    { 944, 352, -192},
    { 1032, 208, -200},
    { 904, 40, 48},
    { 784, -32, 144},
    { 776, 16, 120},
    { 696, 32, 128},
    { 648, 176, 0},
    { 656, 192, -32},
    // 43 seconds
    { 656, 224, -80},
    { 800, 424, -88},
    { 920, 312, -8},
    { 1128, 528, -16},
    { 1328, 488, 144},
    { 1544, 600, 104},
    { 1200, 584, 144},
    { 752, 408, 120},
    { 824, 264, 24},
    { 928, 152, 32},
    { 840, 88, 72},
    { 704, 40, 80},
    { 768, 160, 72},
    { 840, 136, 128},
    { 816, 120, 96},
    { 824, 96, 72},
    { 816, 80, 128},
    { 976, 104, 112},
    { 1184, 48, 160},
    { 1400, -128, 232},
    { 1688, -40, 232},
    { 1048, 416, -32},
    { 752, 360, -208},
    { 792, 56, 0},
    { 848, -64, 208},
    // 44 seconds
    { 768, 48, 176},
    { 768, 184, 64},
    { 808, 216, 40},
    { 776, 256, -8},
    { 768, 184, 32},
    { 840, 152, 16},
    { 840, 104, 0},
    { 1080, 24, 64},
    { 1264, 72, 200},
    { 1592, 64, 264},
    { 1584, 136, 248},
    { 960, 224, 184},
    { 808, -56, 8},
    { 896, -544, -112},
    { 656, -256, 16},
    { 840, -256, 144},
    { 856, -72, 192},
    { 808, 0, 128},
    { 880, 24, 96},
    { 904, 56, 136},
    { 912, 120, 120},
    { 1016, 128, 80},
    { 1168, 128, 120},
    { 1088, 16, 136},
    { 1512, -168, 120},
    // 45 seconds
    { 1456, -152, 216},
    { 928, 88, -16},
    { 744, 48, -112},
    { 776, -96, 24},
    { 776, -128, 96},
    { 792, 0, 72},
    { 840, 56, 104},
    { 840, 128, 56},
    { 808, 72, 88},
    { 840, 112, 64},
    { 856, 136, 16},
    { 912, 48, 80},
    { 1152, 32, 168},
    { 1408, -24, 328},
    { 1744, 16, 392},
    { 1312, 136, 280},
    { 824, 40, -32},
    { 856, -152, -176},
    { 816, -64, -64},
    { 792, -24, 168},
    { 792, 96, 144},
    { 800, 72, 104},
    { 880, -8, 200},
    { 856, -88, 304},
    { 792, 32, 240},
    // 46 seconds
    { 872, 120, 120},
    { 944, 80, 168},
    { 1128, 96, 128},
    { 1264, 0, 200},
    { 1616, -8, 192},
    { 1440, 56, 128},
    { 784, 168, -128},
    { 648, -160, -120},
    { 728, -304, 40},
    { 880, -272, 168},
    { 832, -96, 96},
    { 848, 128, -8},
    { 800, 208, 40},
    { 784, 216, -8},
    { 792, 192, 48},
    { 784, 200, 104},
    { 976, 248, 56},
    { 1128, 208, 152},
    { 1288, 224, 200},
    { 1680, 224, 272},
    { 1440, 360, 272},
    { 728, 376, 80},
    { 776, 216, 24},
    { 976, 160, 80},
    { 920, 104, 256},
    // 47 seconds
    { 904, 96, 192},
    { 848, 88, 184},
    { 784, 128, 160},
    { 776, 72, 160},
    { 768, 80, 120},
    { 784, 112, 40},
    { 912, 128, 24},
    { 1120, 168, 16},
    { 1232, 56, 80},
    { 1600, -56, 176},
    { 1464, 128, 136},
    { 672, 456, -216},
    { 712, 256, -168},
    { 848, 48, 96},
    { 808, 112, 168},
    { 816, 96, 144},
    { 832, 184, 112},
    { 792, 320, -8},
    { 760, 256, 0},
    { 784, 280, -56},
    { 896, 320, -120},
    { 1040, 272, -72},
    { 1104, 184, 0},
    { 1248, 192, 32},
    { 1576, 168, 128},
    // 48 seconds
    { 1568, 312, 64},
    { 864, 336, 16},
    { 928, 216, 48},
    { 1152, 72, 232},
    { 1096, 48, 240},
    { 872, 112, 160},
    { 712, 88, 64},
    { 624, 56, 40},
    { 592, 128, -112},
    { 648, 104, -56},
    { 784, 0, 56},
    { 904, -56, 152},
    { 1176, 16, 200},
    { 1488, 40, 280},
    { 1968, 56, 432},
    { 1384, 552, 24},
    { 752, 616, -216},
    { 664, 184, 40},
    { 688, -176, 296},
    { 784, -32, 232},
    { 792, 160, 112},
    { 792, 280, 80},
    { 800, 384, -64},
    { 792, 328, -40},
    { 880, 288, -48},
    // 49 seconds
    { 936, 168, 0},
    { 1176, 176, 0},
    { 1264, 192, 64},
    { 1528, 216, 72},
    { 1592, 272, 104},
    { 984, 344, 112},
    { 904, 192, -56},
    { 992, -24, 32},
    { 840, -160, 352},
    { 840, 32, 88},
    { 776, 104, 80},
    { 744, 104, 88},
    { 744, 64, 128},
    { 728, 40, 128},
    { 776, -8, 128},
    { 960, 24, 96},
    { 1184, 144, 56},
    { 1728, -40, 216},
    { 1496, 88, 8},
    { 1040, 592, -352},
    { 968, 336, -296},
    { 840, 0, 8},
    { 816, 136, -24},
    { 744, 104, -16},
    { 736, 200, 48},
    // 50 seconds
    { 784, 224, 40},
    { 744, 200, 40},
    { 816, 256, 16},
    { 864, 256, -8},
    { 1008, 128, 88},
    { 1224, 232, -32},
    { 1304, 224, 0},
    { 1624, 440, -56},
    { 1288, 400, 8},
    { 864, 208, -32},
    { 1016, 168, -64},
    { 968, -48, 144},
    { 952, 104, 160},
    { 904, 144, 80},
    { 800, 152, -24},
    { 752, 80, 0},
    { 752, -104, 208},
    { 712, -16, 112},
    { 768, 16, 104},
    { 920, 88, 48},
    { 1072, 256, -40},
    { 1848, -80, 328},
    { 1480, 312, 128},
    { 1152, 512, 16},
    { 960, 440, -144},
    // 51 seconds
    { 712, -16, 168},
    { 784, 8, 184},
    { 856, 224, 80},
    { 808, 352, 16},
    { 816, 352, -8},
    { 816, 304, -16},
    { 880, 272, 56},
    { 888, 288, 16},
    { 1032, 248, 96},
    { 1240, 296, 88},
    { 1544, 152, 264},
    { 1576, 280, 224},
    { 1008, 344, 120},
    { 1128, 272, -232},
    { 856, -296, 416},
    { 800, -40, 232},
    { 760, 200, 40},
    { 752, 152, 56},
    { 656, 120, 56},
    { 672, 56, 72},
    { 728, 8, 144},
    { 776, 56, 96},
    { 920, 104, 64},
    { 1240, 136, 104},
    { 1496, -32, 272},
    // 52 seconds
    { 1728, 48, 240},
    { 1208, 456, -88},
    { 792, 552, -256},
    { 800, 112, 0},
    { 728, -48, 176},
    { 752, 48, 144},
    { 808, 144, 104},
    { 848, 272, 48},
    { 744, 288, -64},
    { 736, 184, -40},
    { 808, 128, 16},
    { 888, 128, 24},
    { 1184, 184, -8},
    { 1232, 232, 16},
    { 1544, 96, 16},
    { 1640, 232, 0},
    { 832, 320, 0},
    { 832, 152, -248},
    { 848, -584, 304},
    { 1016, -232, 288},
    { 848, 120, 200},
    { 712, 232, 80},
    { 720, 288, -32},
    { 696, 152, 48},
    { 712, 8, 168},
    // 53 seconds
    { 768, -40, 168},
    { 992, 8, 144},
    { 1288, 144, 136},
    { 1496, 240, 136},
    { 1872, 312, 152},
    { 944, 920, -136},
    { 848, 120, 152},
    { 904, -88, 256},
    { 760, -312, 256},
    { 736, -264, 184},
    { 664, 32, 32},
    { 696, 144, 8},
    { 744, 144, -48},
    { 864, 256, -152},
    { 920, 64, -24},
    { 912, -80, -40},
    { 1136, -128, 0},
    { 1152, 80, 160},
    { 1520, 128, 168},
    { 1488, 336, 40},
    { 920, 328, 64},
    { 936, 72, -16},
    { 1064, -8, 64},
    { 936, 56, 120},
    { 680, -240, 184},
    // 54 seconds
    { 704, -192, 192},
    { 752, 48, 160},
    { 776, 192, 136},
    { 888, 184, 144},
    { 840, 56, 152},
    { 968, 24, 176},
    { 1112, 80, 192},
    { 1400, 8, 264},
    { 1784, -40, 336},
    { 1008, 456, -152},
    { 888, 232, -184},
    { 912, -32, -160},
    { 736, -192, -8},
    { 592, 72, 8},
    { 704, 128, 144},
    { 760, 200, 152},
    { 728, 264, 32},
    { 768, 160, 104},
    { 864, 200, 88},
    { 936, 232, 16},
    { 1168, 216, 24},
    { 1272, 200, 168},
    { 1768, 224, 160},
    { 1448, 440, 80},
    { 784, 400, 16},
    // 55 seconds
    { 832, 176, -24},
    { 1104, 64, 48},
    { 856, -64, 232},
    { 664, 8, 160},
    { 776, 104, 64},
    { 768, 112, 120},
    { 744, 136, 96},
    { 744, 8, 184},
    { 800, 0, 176},
    { 1000, 64, 96},
    { 1200, 128, 96},
    { 1616, 24, 176},
    { 1536, 128, 104},
    { 920, 456, -224},
    { 976, 216, -208},
    { 904, 32, 24},
    { 728, 112, 40},
    { 736, 136, -16},
    { 744, 168, 0},
    { 752, 232, 8},
    { 736, 192, -16},
    { 744, 176, -8},
    { 816, 200, -8},
    { 936, 208, 0},
    { 1088, 208, 80},
    // 56 seconds
    { 1376, 240, 120},
    { 1816, 384, 136},
    { 1352, 512, 80},
    { 760, 320, -8},
    { 1072, 200, -224},
    { 952, -72, 408},
    { 632, -424, 272},
    { 920, 112, 128},
    { 776, 160, 112},
    { 728, 128, 120},
    { 696, 88, 112},
    { 720, -16, 152},
    { 848, 32, 144},
    { 1056, 104, 96},
    { 1224, 160, 104},
    { 1560, 8, 184},
    { 1544, 112, 192},
    { 920, 576, -224},
    { 1024, 384, -128},
    { 880, 96, 72},
    { 696, 80, 112},
    { 720, 56, 136},
    { 752, 160, 64},
    { 760, 216, 72},
    { 736, 168, 48},
    // 57 seconds
    { 800, 136, 48},
    { 864, 176, 0},
    { 1008, 168, 8},
    { 1144, 168, 24},
    { 1176, 200, 80},
    { 1464, 224, 24},
    { 1368, 384, -16},
    { 1048, 280, 168},
    { 1040, 136, 136},
    { 1088, 96, 192},
    { 832, 40, 96},
    { 752, 64, 160},
    { 768, 120, 80},
    { 736, 96, 96},
    { 736, 16, 144},
    { 760, -16, 152},
    { 856, 32, 104},
    { 1048, 96, 80},
    { 1208, 48, 200},
    { 1368, 8, 192},
    { 1616, -120, 184},
    { 1088, 232, -160},
    { 968, 224, -336},
    { 800, 8, -72},
    { 832, 8, 144},
    // 58 seconds
    { 800, 136, 88},
    { 856, 240, 24},
    { 840, 256, 112},
    { 784, 288, 24},
    { 760, 184, 32},
    { 824, 248, -40},
    { 920, 184, 8},
    { 1080, 240, -8},
    { 1128, 272, -8},
    { 1416, 240, 8},
    { 1384, 272, 56},
    { 1160, 232, 176},
    { 1192, 144, 168},
    { 1064, 80, 240},
    { 1128, 72, -24},
    { 1008, -152, 208},
    { 864, 32, 72},
    { 816, 48, 120},
    { 664, 104, 128},
    { 624, 128, 168},
    { 672, 256, 152},
    { 712, 296, 200},
    { 760, 352, 200},
    { 864, 408, 136},
    { 888, 408, 104},
    // 59 seconds
    { 1392, 264, 328},
    { 1720, 472, 320},
    { 1184, 808, 24},
    { 816, 520, -88},
    { 952, 560, 16},
    { 968, 560, 288},
    { 896, 728, 176},
    { 984, 968, 208},
    { 864, 928, 216},
    { 664, 888, 152},
    { 640, 888, -72},
    { 536, 704, -88},
    { 384, 552, -136},
    { 296, 608, -208},
    { 240, 480, -176},
    { 144, 520, -224},
    { 80, 632, -272},
    { 24, 640, -320},
    { 8, 728, -408},
    { -88, 832, -472},
    { -160, 824, -512},
    { -144, 816, -568},
    { -112, 896, -600},
    { -200, 824, -592},
    { -232, 768, -568},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-03 08:54:51 local
AccelRawData *activity_sample_walk_100_pbl_25531_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25531_5
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 200, -208, -1000},
    { 56, -296, -936},
    { 208, -136, -1024},
    { 200, -208, -944},
    { 184, -168, -1040},
    { 160, -224, -1024},
    { 288, -216, -1056},
    { 224, -200, -1016},
    { 376, -176, -1048},
    { 128, -272, -992},
    { 256, -184, -1024},
    { 240, -304, -1064},
    { 192, -376, -1032},
    { 136, -464, -896},
    { 64, -320, -1096},
    { 176, -448, -848},
    { 328, -656, -976},
    { -240, -872, -560},
    { 936, -160, -1112},
    { 96, -320, -928},
    { 328, -288, -952},
    { 208, -296, -952},
    { 264, -280, -960},
    { 264, -320, -960},
    { 256, -216, -968},
    // 1 seconds
    { 232, -288, -944},
    { 240, -256, -920},
    { 200, -216, -952},
    { 224, -264, -944},
    { 200, -256, -760},
    { 184, -184, -576},
    { 376, 40, -584},
    { 216, 144, -328},
    { 296, 504, -408},
    { 304, 696, -320},
    { 320, 712, -312},
    { 440, 720, -288},
    { 472, 672, -136},
    { 744, 1208, -168},
    { 752, 976, 8},
    { 928, 880, 40},
    { 960, 1008, 152},
    { 936, 752, 128},
    { 1080, 1032, 120},
    { 976, 760, 176},
    { 880, 584, 112},
    { 968, 728, 96},
    { 896, 680, 80},
    { 816, 464, 104},
    { 888, 544, 112},
    // 2 seconds
    { 856, 496, 168},
    { 792, 424, 144},
    { 816, 408, 56},
    { 832, 368, 96},
    { 840, 360, 40},
    { 856, 328, 56},
    { 864, 312, 64},
    { 864, 312, 32},
    { 904, 272, 72},
    { 960, 280, 112},
    { 1080, 312, 80},
    { 1304, 144, 296},
    { 1240, 192, 336},
    { 1080, 320, 192},
    { 744, 400, 88},
    { 768, 168, 208},
    { 864, 56, 280},
    { 872, 56, 272},
    { 840, 128, 216},
    { 808, 296, 72},
    { 792, 288, -16},
    { 704, 288, 96},
    { 760, 344, 176},
    { 808, 616, 104},
    { 840, 552, 384},
    // 3 seconds
    { 832, 416, 304},
    { 952, 376, 224},
    { 1336, 528, 264},
    { 1544, 592, 232},
    { 1424, 560, -88},
    { 600, 304, -32},
    { 464, 32, 88},
    { 576, 264, 160},
    { 824, 384, 160},
    { 848, 360, 184},
    { 744, 288, 200},
    { 712, 280, 144},
    { 704, 272, 112},
    { 704, 248, 112},
    { 768, 200, 112},
    { 800, 160, 120},
    { 1144, 80, 224},
    { 1288, -80, 440},
    { 1824, -88, 496},
    { 1600, 456, 288},
    { 752, 952, -136},
    { 392, 112, 24},
    { 800, -304, 248},
    { 960, 80, 232},
    { 912, 216, 192},
    // 4 seconds
    { 760, 392, 64},
    { 696, 256, -8},
    { 680, 264, 40},
    { 744, 208, 40},
    { 800, 280, 40},
    { 936, 296, 88},
    { 1176, 304, 208},
    { 1520, 400, 384},
    { 1736, 432, 488},
    { 1064, 688, 296},
    { 608, 408, 128},
    { 1040, 504, -96},
    { 760, -208, 208},
    { 840, 352, 248},
    { 880, 120, 280},
    { 808, 144, 176},
    { 720, 168, 104},
    { 688, 104, 144},
    { 664, 80, 128},
    { 720, 80, 88},
    { 984, 112, 56},
    { 1184, 24, 184},
    { 1664, -88, 336},
    { 1744, 152, 320},
    { 1072, 760, -136},
    // 5 seconds
    { 720, 472, -136},
    { 736, 48, 120},
    { 848, 152, 112},
    { 832, 88, 232},
    { 840, 256, 160},
    { 736, 216, 136},
    { 720, 336, 24},
    { 760, 216, 104},
    { 864, 288, 16},
    { 984, 160, 112},
    { 1240, 240, 96},
    { 1640, 104, 248},
    { 1728, 368, 232},
    { 1120, 488, 40},
    { 840, 432, -72},
    { 880, 16, -152},
    { 904, -208, 392},
    { 808, 24, 264},
    { 776, 184, 120},
    { 752, 96, 152},
    { 720, 104, 112},
    { 728, 120, 128},
    { 768, 80, 128},
    { 1048, 88, 104},
    { 1144, 104, 96},
    // 6 seconds
    { 1296, -56, -8},
    { 1552, -296, 304},
    { 1160, 104, 216},
    { 800, 472, -160},
    { 888, 304, -104},
    { 888, 160, 128},
    { 880, 160, 176},
    { 856, 128, 208},
    { 864, 280, 32},
    { 848, 232, 88},
    { 848, 392, -72},
    { 840, 256, -16},
    { 936, 240, -24},
    { 1136, 176, 72},
    { 1224, 216, 208},
    { 1672, 208, 192},
    { 1512, 360, 176},
    { 984, 360, 64},
    { 1024, -96, -144},
    { 1056, -264, 424},
    { 1048, 200, 344},
    { 856, 216, 96},
    { 792, 200, 40},
    { 688, 32, 120},
    { 600, -8, 136},
    // 7 seconds
    { 592, 24, 56},
    { 664, -16, 104},
    { 984, 56, 72},
    { 1248, 72, 112},
    { 1856, -56, 408},
    { 1704, 520, -56},
    { 1072, 760, -376},
    { 760, 168, 104},
    { 816, -152, 208},
    { 808, 48, 224},
    { 840, 192, 144},
    { 800, 256, 152},
    { 760, 304, 56},
    { 768, 200, 56},
    { 848, 248, -40},
    { 888, 168, 40},
    { 1016, 280, -72},
    { 1216, 184, 40},
    { 1496, 208, 96},
    { 1720, 168, 256},
    { 1120, 432, 144},
    { 848, 352, -224},
    { 904, -192, 264},
    { 1016, 16, 264},
    { 944, 144, 128},
    // 8 seconds
    { 840, 128, 80},
    { 712, 96, 56},
    { 624, 48, 80},
    { 608, 16, 104},
    { 672, -16, 96},
    { 784, 32, 72},
    { 1056, 96, 64},
    { 1408, -72, 312},
    { 1880, 16, 384},
    { 1552, 608, 16},
    { 904, 776, -248},
    { 744, 280, 48},
    { 744, -280, 216},
    { 760, -24, 104},
    { 784, 56, 72},
    { 832, 296, 64},
    { 848, 376, -16},
    { 792, 248, 0},
    { 864, 272, 32},
    { 872, 232, 72},
    { 1064, 176, 96},
    { 1208, 200, 232},
    { 1680, 224, 312},
    { 1464, 472, 360},
    { 832, 576, 72},
    // 9 seconds
    { 928, 352, 80},
    { 1104, 216, 152},
    { 1000, 192, 192},
    { 824, 136, 136},
    { 648, 96, 72},
    { 560, 40, 64},
    { 544, 72, 88},
    { 600, 136, 128},
    { 752, 240, 208},
    { 936, 312, 128},
    { 1128, 360, 176},
    { 1488, 112, 296},
    { 1408, 320, 168},
    { 1088, 536, -120},
    { 912, 312, -88},
    { 848, 176, 104},
    { 888, 144, 96},
    { 848, 160, 168},
    { 864, 320, 120},
    { 832, 320, 120},
    { 752, 312, 72},
    { 776, 272, 32},
    { 840, 256, 32},
    { 1008, 256, 80},
    { 1144, 304, 80},
    // 10 seconds
    { 1432, 248, 224},
    { 1680, 320, 312},
    { 1168, 456, 200},
    { 960, 304, 112},
    { 1000, 0, 144},
    { 984, -248, 352},
    { 816, -8, 224},
    { 808, 160, 120},
    { 720, 24, 88},
    { 560, 24, 16},
    { 600, -32, 24},
    { 656, -16, 80},
    { 888, 56, 64},
    { 1240, 96, 168},
    { 1776, -88, 408},
    { 2064, 112, 384},
    { 1280, 888, -168},
    { 808, 440, -304},
    { 704, -8, 144},
    { 832, -32, 256},
    { 736, 24, 256},
    { 768, 192, 152},
    { 784, 264, 128},
    { 760, 344, 0},
    { 752, 200, 40},
    // 11 seconds
    { 808, 248, -8},
    { 976, 184, 104},
    { 1168, 280, 64},
    { 1352, 208, 216},
    { 1848, 264, 464},
    { 1224, 544, 104},
    { 880, 16, 56},
    { 1024, -8, 112},
    { 880, -112, 40},
    { 888, 200, -8},
    { 832, 184, 64},
    { 680, 48, 96},
    { 648, 16, 80},
    { 608, -8, 88},
    { 640, 32, 64},
    { 760, 40, 40},
    { 1120, 40, 128},
    { 1392, 64, 176},
    { 2136, -104, 496},
    { 1544, 720, -88},
    { 888, 640, -112},
    { 800, 136, 104},
    { 712, -120, 248},
    { 712, 0, 248},
    { 816, 248, 80},
    // 12 seconds
    { 776, 376, 8},
    { 752, 176, 176},
    { 728, 320, 192},
    { 872, 472, 88},
    { 928, 368, 128},
    { 1144, 416, 256},
    { 1200, 0, 424},
    { 1744, 112, 408},
    { 1360, 400, 144},
    { 1088, 248, 24},
    { 1088, 784, 312},
    { 872, -248, -136},
    { 976, 152, 304},
    { 880, -48, 280},
    { 688, 8, 120},
    { 544, 72, -16},
    { 568, 48, -16},
    { 640, 16, 40},
    { 792, 56, 48},
    { 1072, 80, 88},
    { 1336, 112, 160},
    { 1824, -32, 416},
    { 1848, 264, 328},
    { 1296, 808, -96},
    { 800, 424, -8},
    // 13 seconds
    { 656, -48, 184},
    { 704, -48, 208},
    { 736, 32, 232},
    { 744, 264, 96},
    { 776, 304, 88},
    { 776, 328, 0},
    { 760, 232, 80},
    { 888, 288, 40},
    { 992, 0, 144},
    { 1224, -616, 192},
    { 936, -192, 424},
    { 1512, 304, 424},
    { 1560, 360, 912},
    { 768, 328, 304},
    { 1456, -152, -424},
    { 1328, 376, 80},
    { 776, 200, 128},
    { 712, 160, 296},
    { 728, 216, 144},
    { 648, 176, 296},
    { 712, 32, 376},
    { 648, 48, 312},
    { 984, -104, 376},
    { 1016, -56, 352},
    { 1256, 40, 240},
    // 14 seconds
    { 1512, 112, 144},
    { 1552, 24, 240},
    { 696, 272, 408},
    { 1064, 672, -600},
    { 824, -40, 40},
    { 784, 232, 216},
    { 704, 176, 168},
    { 688, 144, 192},
    { 656, 208, 144},
    { 672, 136, 200},
    { 696, 112, 176},
    { 840, 288, 104},
    { 992, 216, 200},
    { 1176, 400, 192},
    { 1304, 264, 376},
    { 1608, 408, 392},
    { 1392, 696, 240},
    { 936, 552, 56},
    { 848, 304, 24},
    { 976, -112, 96},
    { 960, 16, 336},
    { 920, 136, 232},
    { 704, 80, 128},
    { 608, -16, 120},
    { 544, -48, 120},
    // 15 seconds
    { 584, -32, 128},
    { 728, 24, 96},
    { 992, 56, 120},
    { 1216, 24, 248},
    { 1600, 72, 288},
    { 1952, 128, 328},
    { 1424, 760, -80},
    { 1096, 872, -152},
    { 736, 248, 56},
    { 696, -56, 224},
    { 720, -96, 200},
    { 712, 64, 160},
    { 752, 184, 144},
    { 784, 312, 80},
    { 824, 200, 136},
    { 832, 336, -48},
    { 888, 152, 96},
    { 1128, 312, 8},
    { 1200, 184, 216},
    { 1640, 216, 280},
    { 1552, 432, 200},
    { 960, 456, 192},
    { 976, 400, 136},
    { 1136, 144, 104},
    { 920, 80, 296},
    // 16 seconds
    { 848, 152, 216},
    { 760, 104, 96},
    { 624, 40, 104},
    { 552, -8, 144},
    { 552, -16, 128},
    { 680, 0, 144},
    { 816, 8, 120},
    { 1200, 232, 160},
    { 1752, 296, 192},
    { 1984, 288, 312},
    { 1200, 712, -184},
    { 1152, 616, -872},
    { 880, -80, -216},
    { 776, 288, -56},
    { 864, 48, 208},
    { 784, 224, 160},
    { 744, 288, 64},
    { 728, 224, 136},
    { 760, 312, 64},
    { 816, 248, 96},
    { 960, 224, 112},
    { 1152, 200, 160},
    { 1264, 200, 192},
    { 1704, 352, 152},
    { 1432, 464, 152},
    // 17 seconds
    { 1048, 560, -8},
    { 1200, 520, -256},
    { 1056, -240, 352},
    { 1032, 152, 136},
    { 920, 80, 208},
    { 856, 120, 120},
    { 752, 40, 128},
    { 696, 80, 112},
    { 632, 0, 136},
    { 680, -32, 112},
    { 832, -32, 104},
    { 984, 88, 32},
    { 1352, -248, 328},
    { 1600, -136, 504},
    { 1784, 568, 24},
    { 1328, 960, -280},
    { 1096, 696, 48},
    { 824, 376, 128},
    { 856, 16, 168},
    { 832, 136, 136},
    { 800, 320, 64},
    { 784, 336, 80},
    { 816, 360, 32},
    { 848, 232, 112},
    { 1016, 280, 80},
    // 18 seconds
    { 1088, 312, 16},
    { 1176, 256, 80},
    { 1664, 160, 264},
    { 1448, 408, 272},
    { 1080, 360, 136},
    { 1232, 384, -144},
    { 1448, 80, 320},
    { 1224, -16, 200},
    { 984, 104, 80},
    { 808, 48, 56},
    { 568, -16, 48},
    { 488, -24, 72},
    { 520, 16, 48},
    { 640, 16, 40},
    { 808, 104, 96},
    { 1080, 192, 200},
    { 1520, 136, 240},
    { 1984, 120, 488},
    { 1616, 616, 56},
    { 1216, 800, -224},
    { 808, 408, 80},
    { 776, 136, 136},
    { 768, -216, 288},
    { 696, 112, 208},
    { 808, 248, 144},
    // 19 seconds
    { 864, 456, -8},
    { 864, 288, 40},
    { 880, 312, -48},
    { 984, 200, 56},
    { 1184, 240, 72},
    { 1200, 88, 328},
    { 1520, 312, 584},
    { 1360, 720, 680},
    { 1000, 336, 384},
    { 1472, 720, 120},
    { 1176, 104, 352},
    { 1072, -72, 464},
    { 864, -104, 328},
    { 712, 72, 40},
    { 448, -48, -16},
    { 424, 8, -24},
    { 568, 56, 32},
    { 688, 56, 104},
    { 1016, 144, 104},
    { 1320, 40, 232},
    { 1976, -120, 520},
    { 2224, 264, 408},
    { 1208, 1144, -256},
    { 896, 896, -16},
    { 680, 32, 152},
    // 20 seconds
    { 808, -104, 376},
    { 800, 96, 272},
    { 848, 264, 128},
    { 808, 288, 152},
    { 784, 408, 8},
    { 792, 304, -56},
    { 824, 200, 8},
    { 952, 184, 48},
    { 1200, 192, 16},
    { 1352, 48, 208},
    { 1648, 72, 248},
    { 1384, 208, 192},
    { 736, 296, -32},
    { 936, 568, 192},
    { 1152, 168, 168},
    { 960, 224, 120},
    { 792, 56, 176},
    { 744, 248, 136},
    { 688, 216, 232},
    { 560, 288, 104},
    { 512, 264, 104},
    { 528, 288, 120},
    { 728, 224, 104},
    { 976, 168, 160},
    { 1320, -64, 256},
    // 21 seconds
    { 1616, 48, 376},
    { 1400, 648, 16},
    { 936, 592, -152},
    { 760, 112, 144},
    { 880, -72, 304},
    { 984, 144, 224},
    { 944, 168, 216},
    { 840, 320, -8},
    { 776, 264, -16},
    { 800, 336, -96},
    { 816, 208, 24},
    { 960, 320, -40},
    { 1136, 192, 80},
    { 1232, 328, 64},
    { 1592, 152, 256},
    { 1568, 376, 256},
    { 1008, 400, 120},
    { 1128, 456, -192},
    { 1216, -144, 368},
    { 1160, 96, 304},
    { 952, 24, 200},
    { 808, 104, 48},
    { 672, 32, 96},
    { 592, 8, 80},
    { 592, 0, 80},
    // 22 seconds
    { 688, -8, 104},
    { 920, 104, 40},
    { 1120, 168, 16},
    { 1528, -48, 248},
    { 1848, -32, 384},
    { 1272, 544, 0},
    { 1000, 552, -88},
    { 824, 208, 104},
    { 872, -40, 184},
    { 832, 40, 160},
    { 784, 256, 128},
    { 824, 312, 56},
    { 800, 296, 16},
    { 800, 200, 88},
    { 848, 224, 48},
    { 904, 208, 48},
    { 1072, 160, 56},
    { 1208, 160, 96},
    { 1456, 48, 216},
    { 1592, 80, 136},
    { 1168, 88, 128},
    { 968, 120, -96},
    { 888, -240, 24},
    { 680, -200, 96},
    { 744, -56, 144},
    // 23 seconds
    { 784, 176, 240},
    { 800, 168, 192},
    { 744, 152, 144},
    { 736, 32, 160},
    { 824, -8, 192},
    { 936, 16, 184},
    { 1176, 96, 136},
    { 1224, 40, 224},
    { 1584, -8, 296},
    { 1384, 24, 312},
    { 952, 320, -128},
    { 840, 232, -232},
    { 792, 88, -48},
    { 776, -56, 96},
    { 784, 112, 88},
    { 832, 120, 80},
    { 792, 160, 64},
    { 720, 112, 72},
    { 720, 136, 48},
    { 816, 128, 72},
    { 1016, 144, 16},
    { 1128, 128, 72},
    { 1200, 224, 88},
    { 1520, 72, 96},
    { 1480, 224, 80},
    // 24 seconds
    { 1000, 192, 120},
    { 960, 96, 72},
    { 1240, 48, -8},
    { 880, -320, 192},
    { 720, 128, 48},
    { 720, 96, 80},
    { 680, 136, 112},
    { 680, 80, 136},
    { 792, 56, 168},
    { 936, 8, 208},
    { 1168, 0, 216},
    { 1288, 80, 184},
    { 1560, -24, 208},
    { 1472, 160, 96},
    { 984, 336, -104},
    { 984, -40, 48},
    { 840, -96, 56},
    { 728, -16, 40},
    { 792, 168, -56},
    { 808, 216, 40},
    { 712, 112, 72},
    { 696, 272, -120},
    { 696, 176, 144},
    { 672, 368, 0},
    { 864, 408, 32},
    // 25 seconds
    { 1160, 352, 312},
    { 1344, 368, 280},
    { 1536, 432, 128},
    { 1336, 448, 152},
    { 776, 296, -8},
    { 896, -80, -72},
    { 1024, -72, 80},
    { 864, 56, 224},
    { 784, 104, 128},
    { 664, 144, 136},
    { 824, 384, 80},
    { 624, 424, 224},
    { 640, 376, 200},
    { 896, 504, 40},
    { 1120, 488, 8},
    { 1272, 280, 24},
    { 1408, 32, 192},
    { 880, -16, 352},
    { 1080, 56, 224},
    { 912, 288, -56},
    { 704, -48, 296},
    { 808, 448, -176},
    { 968, 600, -56},
    { 800, 432, 112},
    { 640, 376, 40},
    // 26 seconds
    { 712, 264, 136},
    { 824, 264, 192},
    { 888, 376, 72},
    { 1032, 328, 88},
    { 1184, 272, 224},
    { 1592, 336, 168},
    { 1512, 336, 240},
    { 912, 328, 192},
    { 912, 184, 136},
    { 704, 224, 448},
    { 944, 264, 128},
    { 928, 112, 176},
    { 816, 56, 184},
    { 704, 192, 0},
    { 632, 168, 40},
    { 664, 208, 112},
    { 720, 224, 72},
    { 888, 208, 136},
    { 960, 168, 136},
    { 1168, 128, 152},
    { 1464, -32, 288},
    { 1328, 296, 160},
    { 1096, 488, -144},
    { 840, 96, -48},
    { 792, 144, 0},
    // 27 seconds
    { 832, 232, 32},
    { 824, 296, 152},
    { 816, 408, 144},
    { 712, 272, 176},
    { 744, 288, 80},
    { 792, 208, 112},
    { 872, 264, 80},
    { 1024, 200, 72},
    { 1240, 216, 120},
    { 1544, 80, 232},
    { 1600, 208, 176},
    { 1000, 304, 80},
    { 1000, 128, -176},
    { 872, -56, -80},
    { 752, -136, 112},
    { 712, -192, 160},
    { 824, 128, 64},
    { 768, 96, 144},
    { 784, 72, 176},
    { 824, 56, 192},
    { 808, 8, 280},
    { 1056, 16, 264},
    { 1192, 64, 232},
    { 1488, -40, 224},
    { 1544, 64, 176},
    // 28 seconds
    { 1024, 480, -112},
    { 904, 112, -168},
    { 920, -80, -64},
    { 784, -80, -16},
    { 768, 56, 24},
    { 808, 184, 56},
    { 776, 184, 56},
    { 728, 144, 88},
    { 736, 136, 64},
    { 800, 208, -48},
    { 880, 128, 16},
    { 1128, 64, -16},
    { 1344, 264, 152},
    { 1792, 336, 216},
    { 1280, 496, 160},
    { 784, 368, 56},
    { 896, 200, 40},
    { 1008, 144, 152},
    { 800, 48, 184},
    { 768, 104, 56},
    { 720, 32, 128},
    { 688, 88, 80},
    { 744, 48, 128},
    { 792, 48, 152},
    { 904, 80, 128},
    // 29 seconds
    { 1112, 120, 120},
    { 1272, 56, 208},
    { 1664, -24, 264},
    { 1144, 344, 40},
    { 1032, 456, -216},
    { 912, 112, -32},
    { 784, -16, 56},
    { 672, -32, 16},
    { 712, 104, 0},
    { 728, 152, 64},
    { 712, 224, 40},
    { 752, 288, 8},
    { 824, 312, 112},
    { 904, 408, 88},
    { 1064, 320, 176},
    { 1192, 352, 256},
    { 1560, 344, 312},
    { 1424, 488, 232},
    { 944, 376, 200},
    { 912, 248, 120},
    { 984, 184, 168},
    { 904, 160, 192},
    { 800, -80, 192},
    { 672, -80, 168},
    { 632, 72, 32},
    // 30 seconds
    { 608, 16, 80},
    { 672, 48, 80},
    { 832, 136, 32},
    { 1104, 96, 144},
    { 1248, 80, 208},
    { 1560, 0, 264},
    { 1576, 136, 256},
    { 1072, 584, -48},
    { 960, 384, -40},
    { 752, 128, 128},
    { 728, 16, 184},
    { 776, 72, 160},
    { 776, 152, 152},
    { 784, 240, 40},
    { 752, 200, 24},
    { 848, 216, 0},
    { 920, 152, -8},
    { 1112, -8, -32},
    { 1216, -8, -16},
    { 1448, 96, 120},
    { 1488, 264, 48},
    { 1096, 344, 112},
    { 960, 160, 88},
    { 1016, 48, 56},
    { 920, -64, 264},
    // 31 seconds
    { 776, 104, 176},
    { 760, 128, 112},
    { 720, 96, 96},
    { 712, 64, 88},
    { 728, 16, 136},
    { 808, -32, 168},
    { 1024, -40, 176},
    { 1144, 56, 176},
    { 1336, 136, 104},
    { 1616, 24, 224},
    { 1144, 544, -144},
    { 1016, 368, -168},
    { 824, 16, 40},
    { 696, -40, 104},
    { 696, 104, 72},
    { 744, 256, 24},
    { 776, 240, 40},
    { 728, 208, -16},
    { 768, 128, 40},
    { 880, 216, -32},
    { 1008, 128, -24},
    { 1184, 144, -16},
    { 1336, 208, 112},
    { 1584, 224, 144},
    { 1160, 400, 112},
    // 32 seconds
    { 1032, 248, 104},
    { 1016, 104, 112},
    { 992, 88, 72},
    { 792, -40, 216},
    { 760, 136, 112},
    { 712, 144, 56},
    { 712, 112, 80},
    { 712, 56, 104},
    { 792, 8, 144},
    { 936, 8, 168},
    { 1160, 48, 192},
    { 1144, 128, 144},
    { 1568, 32, 232},
    { 1336, 288, 88},
    { 992, 488, -112},
    { 928, 216, -24},
    { 816, -24, 112},
    { 800, 72, 72},
    { 856, 160, 48},
    { 752, 160, 16},
    { 720, 80, 8},
    { 664, 112, 0},
    { 680, 160, 8},
    { 808, 224, 64},
    { 1048, 192, 64},
    // 33 seconds
    { 1184, 336, 144},
    { 1536, 224, 272},
    { 1584, 360, 200},
    { 1016, 408, 224},
    { 936, 216, 128},
    { 1056, 80, 128},
    { 912, -24, 120},
    { 640, -144, 16},
    { 688, 80, 40},
    { 712, 32, 112},
    { 696, 128, 56},
    { 768, 104, 112},
    { 896, 48, 184},
    { 1064, 32, 200},
    { 1160, 112, 168},
    { 1280, 120, 144},
    { 1536, -32, 328},
    { 1064, 432, 16},
    { 1024, 352, -136},
    { 888, 120, -32},
    { 808, 0, 48},
    { 752, 72, 112},
    { 760, 200, 16},
    { 760, 144, 40},
    { 704, 144, 8},
    // 34 seconds
    { 704, 72, 8},
    { 736, 96, 40},
    { 896, 168, 40},
    { 1184, 248, 16},
    { 1328, 304, 216},
    { 1776, 400, 200},
    { 1296, 496, 240},
    { 872, 312, 120},
    { 936, 152, 112},
    { 1120, 152, 24},
    { 760, 72, 480},
    { 888, 224, 24},
    { 800, 64, 88},
    { 712, 72, 96},
    { 720, 48, 96},
    { 768, -16, 128},
    { 888, -24, 160},
    { 1072, 24, 184},
    { 1152, 72, 184},
    { 1568, -80, 320},
    { 1264, 376, 112},
    { 1032, 464, -200},
    { 904, 104, -24},
    { 752, -72, 152},
    { 768, 80, 96},
    // 35 seconds
    { 776, 272, 48},
    { 792, 280, 64},
    { 760, 272, 16},
    { 768, 168, 56},
    { 848, 184, 40},
    { 896, 184, 16},
    { 1064, 192, 40},
    { 1232, 248, 56},
    { 1648, 144, 216},
    { 1472, 360, 144},
    { 928, 256, 112},
    { 880, 240, -216},
    { 968, -168, 232},
    { 952, 240, 160},
    { 800, 176, 96},
    { 728, 56, 120},
    { 688, 32, 80},
    { 656, 16, 104},
    { 704, 16, 112},
    { 840, 40, 96},
    { 1096, 88, 56},
    { 1208, 24, 184},
    { 1704, -88, 344},
    { 1544, 288, 96},
    { 920, 688, -192},
    // 36 seconds
    { 832, 224, -64},
    { 784, -72, 128},
    { 784, 56, 160},
    { 816, 136, 104},
    { 848, 240, 64},
    { 776, 240, 24},
    { 744, 184, 8},
    { 760, 128, 24},
    { 880, 104, -56},
    { 920, 64, -32},
    { 1120, 72, -24},
    { 1352, 256, 48},
    { 1704, 256, 144},
    { 1344, 408, 104},
    { 840, 336, 48},
    { 896, 152, 48},
    { 1088, 48, 88},
    { 880, -88, 272},
    { 768, 120, 136},
    { 728, 112, 96},
    { 720, 72, 120},
    { 704, 72, 136},
    { 752, 32, 176},
    { 856, 24, 184},
    { 1048, 64, 192},
    // 37 seconds
    { 1128, 144, 128},
    { 1560, 48, 192},
    { 1576, 176, 160},
    { 984, 552, -232},
    { 920, 320, -232},
    { 912, -96, -112},
    { 760, 40, 32},
    { 792, 120, 72},
    { 800, 104, 112},
    { 728, 176, 32},
    { 672, 168, 72},
    { 688, 280, 16},
    { 744, 368, 32},
    { 832, 504, 88},
    { 1016, 552, 56},
    { 1120, 472, 216},
    { 1464, 456, 224},
    { 1344, 624, 224},
    { 912, 448, 264},
    { 832, 376, 144},
    { 816, 264, 200},
    { 784, 240, 208},
    { 712, 240, 88},
    { 696, 160, 104},
    { 720, 184, 72},
    // 38 seconds
    { 744, 184, 32},
    { 784, 168, 88},
    { 824, 200, 80},
    { 968, 224, 40},
    { 1152, 248, 16},
    { 1328, 160, 88},
    { 1664, -32, 160},
    { 1192, 208, 24},
    { 824, 264, -136},
    { 808, 80, -24},
    { 752, 16, 48},
    { 712, 8, 48},
    { 728, 104, 56},
    { 768, 152, 64},
    { 768, 264, -64},
    { 816, 264, -56},
    { 888, 296, -32},
    { 968, 312, -56},
    { 1104, 280, 0},
    { 1192, 320, 48},
    { 1568, 296, 152},
    { 1616, 440, 152},
    { 880, 416, 144},
    { 848, 240, 72},
    { 1064, 168, 160},
    // 39 seconds
    { 1144, 208, 120},
    { 896, 8, 352},
    { 856, 112, 144},
    { 872, 8, 208},
    { 848, 40, 112},
    { 816, 40, 56},
    { 760, 0, 80},
    { 832, 24, -8},
    { 992, 96, -88},
    { 1160, -40, 8},
    { 1640, -176, 248},
    { 1400, 176, 88},
    { 1160, 368, -104},
    { 952, 264, -32},
    { 832, 88, 216},
    { 832, 104, 216},
    { 816, 184, 184},
    { 800, 176, 240},
    { 800, 280, 216},
    { 800, 344, 200},
    { 832, 440, 80},
    { 864, 400, 72},
    { 1152, 384, 128},
    { 1288, 312, 208},
    { 1664, 392, 176},
    // 40 seconds
    { 1712, 512, 152},
    { 1136, 376, 176},
    { 1144, 328, 192},
    { 1336, -208, -8},
    { 1112, -16, 456},
    { 1112, 176, 168},
    { 1008, 128, 152},
    { 872, -32, 264},
    { 776, -24, 168},
    { 688, -88, 128},
    { 600, -48, 24},
    { 584, -72, -24},
    { 760, 24, -104},
    { 1048, 8, -112},
    { 1704, -72, 128},
    { 1968, -40, 248},
    { 1536, 320, -64},
    { 1352, 408, -144},
    { 1296, 184, 288},
    { 1144, 184, 400},
    { 992, 96, 288},
    { 936, 216, 216},
    { 912, 368, 160},
    { 816, 560, -56},
    { 944, 736, -208},
    // 41 seconds
    { 1024, 600, -24},
    { 1128, 256, 112},
    { 1256, 88, 184},
    { 1624, 48, 320},
    { 1824, 120, 416},
    { 1360, 368, 152},
    { 1312, 200, 112},
    { 1488, 128, 144},
    { 1600, -64, 376},
    { 1280, -96, 376},
    { 1136, -32, 216},
    { 960, 0, 120},
    { 784, 16, 72},
    { 648, -72, 56},
    { 512, -104, -64},
    { 496, -152, -80},
    { 640, -16, -272},
    { 912, -24, -208},
    { 1920, -264, 696},
    { 1864, 400, 696},
    { 1664, 816, -72},
    { 1496, 480, -24},
    { 1176, 504, 384},
    { 944, 144, 448},
    { 832, -32, 344},
    // 42 seconds
    { 912, 48, 280},
    { 952, 328, 176},
    { 936, 368, 184},
    { 904, 560, 0},
    { 864, 440, 24},
    { 1080, 520, 16},
    { 1232, 688, 16},
    { 1576, 688, 48},
    { 1656, 584, 232},
    { 1368, 256, 560},
    { 1520, 344, 360},
    { 1600, 56, 312},
    { 1384, 112, 352},
    { 1168, 152, 168},
    { 944, 32, 224},
    { 752, 40, 96},
    { 656, 8, 24},
    { 576, -16, -32},
    { 544, -8, -40},
    { 648, -32, -24},
    { 920, 0, -8},
    { 1296, -48, 144},
    { 1968, -104, 432},
    { 1904, 328, 304},
    { 1584, 720, -128},
    // 43 seconds
    { 1312, 488, 64},
    { 1080, 168, 312},
    { 1040, 64, 312},
    { 1000, 96, 264},
    { 944, 224, 224},
    { 880, 408, 112},
    { 800, 416, 48},
    { 808, 456, 16},
    { 880, 432, 0},
    { 1040, 400, 40},
    { 1296, 368, 56},
    { 1456, 208, 120},
    { 1728, 312, 144},
    { 1432, 400, 176},
    { 1272, 256, 248},
    { 1496, 40, 224},
    { 1480, 8, 504},
    { 1392, 272, 288},
    { 1184, 216, 120},
    { 976, 104, 136},
    { 792, 32, 104},
    { 640, -40, 40},
    { 536, -104, 48},
    { 432, -104, -16},
    { 600, -16, -120},
    // 44 seconds
    { 864, 56, 0},
    { 1480, 0, 200},
    { 1864, 88, 536},
    { 1864, 392, 416},
    { 1544, 608, 0},
    { 1264, 568, 56},
    { 1096, 248, 288},
    { 1096, 168, 328},
    { 968, 144, 248},
    { 920, 280, 120},
    { 864, 408, 64},
    { 880, 504, -8},
    { 832, 424, 40},
    { 1000, 440, 48},
    { 1200, 352, 144},
    { 1304, 224, 288},
    { 1744, 352, 264},
    { 1432, 464, 408},
    { 1400, 384, 288},
    { 1736, 112, -352},
    { 1272, -784, 632},
    { 1256, 376, 336},
    { 1032, 240, 248},
    { 912, 240, 168},
    { 768, 152, 128},
    // 45 seconds
    { 664, 32, 128},
    { 584, -64, 136},
    { 568, -104, 120},
    { 720, -16, 16},
    { 1048, 160, -192},
    { 1528, -80, 96},
    { 1832, 8, 456},
    { 1408, 640, -24},
    { 1392, 488, -128},
    { 1232, 184, 336},
    { 1128, 384, 280},
    { 1008, 224, 328},
    { 984, 248, 296},
    { 888, 320, 296},
    { 800, 392, 176},
    { 776, 432, 40},
    { 816, 384, 40},
    { 912, 392, 80},
    { 1144, 480, 128},
    { 1248, 384, 240},
    { 1616, 320, 384},
    { 1560, 624, 544},
    { 1224, 320, 416},
    { 1408, 352, 208},
    { 1288, -312, -144},
    // 46 seconds
    { 1112, 24, 440},
    { 1080, 88, 352},
    { 928, 32, 216},
    { 808, -16, 200},
    { 728, -88, 208},
    { 704, -48, 112},
    { 656, -88, 16},
    { 792, -104, -40},
    { 1064, 40, -176},
    { 1704, -200, 200},
    { 1768, -8, 488},
    { 1592, 592, 144},
    { 1464, 456, 0},
    { 1352, 352, 256},
    { 1200, 328, 352},
    { 1064, 296, 384},
    { 952, 344, 312},
    { 872, 392, 192},
    { 800, 432, 72},
    { 792, 472, 40},
    { 824, 512, 40},
    { 992, 432, 104},
    { 1216, 424, 128},
    { 1808, 256, 360},
    { 1928, 296, 424},
    // 47 seconds
    { 1328, 200, 296},
    { 1728, 312, 216},
    { 1616, 88, 136},
    { 1512, 152, 216},
    { 1352, 8, 320},
    { 1048, -32, 192},
    { 840, -64, 112},
    { 640, -144, 120},
    { 536, -88, 24},
    { 496, -128, 8},
    { 560, -120, 0},
    { 800, 40, 40},
    { 1240, 8, 296},
    { 1816, 120, 632},
    { 1584, 792, 400},
    { 1400, 736, 40},
    { 1128, 544, 512},
    { 1144, 552, 256},
    { 1096, 544, 224},
    { 952, 392, 320},
    { 848, 424, 232},
    { 776, 320, 240},
    { 792, 440, 128},
    { 800, 416, 216},
    { 824, 360, 312},
    // 48 seconds
    { 1024, 448, 424},
    { 1248, 568, 448},
    { 1624, 440, 624},
    { 1832, 312, 600},
    { 1336, 312, 520},
    { 1528, -8, 208},
    { 1472, -360, 0},
    { 1128, 96, 384},
    { 1104, 24, 352},
    { 920, 48, 192},
    { 704, -16, 96},
    { 576, -104, 96},
    { 496, -64, 32},
    { 480, -24, -24},
    { 608, -40, -16},
    { 928, 8, 24},
    { 1688, -96, 264},
    { 2352, 24, 648},
    { 1808, 680, 168},
    { 1384, 736, -152},
    { 1280, 488, 128},
    { 984, 368, 248},
    { 912, 48, 312},
    { 944, 168, 224},
    { 896, 336, 176},
    // 49 seconds
    { 816, 568, 144},
    { 808, 688, 160},
    { 808, 552, 208},
    { 920, 480, 216},
    { 1144, 408, 296},
    { 1272, 408, 528},
    { 1864, 464, 616},
    { 2160, 536, 504},
    { 1624, 384, -104},
    { 1208, -176, -192},
    { 968, 0, 192},
    { 1136, 16, 336},
    { 1024, 88, 184},
    { 832, 24, 72},
    { 632, -88, 40},
    { 536, -112, 96},
    { 536, -48, 72},
    { 584, 24, 16},
    { 752, 24, -40},
    { 1232, -8, 208},
    { 1632, -32, 496},
    { 2504, -32, 624},
    { 1904, 856, 208},
    { 1504, 960, -160},
    { 856, 104, 272},
    // 50 seconds
    { 1008, 112, 320},
    { 936, 200, 312},
    { 816, 288, 304},
    { 720, 352, 240},
    { 704, 472, 96},
    { 720, 320, 184},
    { 856, 424, 88},
    { 880, 264, 192},
    { 1136, 312, 128},
    { 1200, 128, 336},
    { 1816, 416, 288},
    { 1768, 408, 240},
    { 1424, 400, 0},
    { 1552, 376, 440},
    { 1456, 64, -8},
    { 1168, -16, 376},
    { 1040, 48, 288},
    { 864, 72, 96},
    { 752, 8, 72},
    { 640, -64, 112},
    { 560, -64, 48},
    { 520, -104, 16},
    { 664, -88, 16},
    { 976, 0, 16},
    { 1672, -152, 288},
    // 51 seconds
    { 2144, 32, 528},
    { 1688, 768, -72},
    { 1496, 488, -48},
    { 1296, 184, 256},
    { 1080, 224, 344},
    { 1024, 152, 288},
    { 928, 240, 176},
    { 856, 320, 160},
    { 800, 432, 56},
    { 816, 464, 56},
    { 808, 472, 88},
    { 1040, 416, 128},
    { 1288, 400, 168},
    { 1624, 296, 240},
    { 1832, 320, 232},
    { 1424, 360, 184},
    { 1392, 328, 224},
    { 1464, -40, 240},
    { 1480, 80, 272},
    { 1232, 120, 256},
    { 1040, 48, 208},
    { 872, 8, 136},
    { 768, -64, 120},
    { 656, -80, 40},
    { 528, -96, 16},
    // 52 seconds
    { 488, -152, 24},
    { 728, -56, 24},
    { 1040, 40, 64},
    { 1592, -32, 248},
    { 1872, 176, 456},
    { 1792, 512, 200},
    { 1600, 624, 8},
    { 1312, 416, 272},
    { 1152, 296, 344},
    { 1024, 240, 288},
    { 952, 264, 216},
    { 896, 416, 88},
    { 816, 432, 64},
    { 856, 496, 40},
    { 920, 456, 48},
    { 1144, 360, 112},
    { 1248, 304, 184},
    { 1752, 272, 232},
    { 1760, 368, 328},
    { 1312, 80, 448},
    { 1416, 272, 184},
    { 1536, 272, 240},
    { 1376, 96, 320},
    { 1184, 56, 280},
    { 944, -32, 232},
    // 53 seconds
    { 752, 16, 88},
    { 624, -40, 80},
    { 528, -56, 64},
    { 472, -96, 40},
    { 544, -144, 136},
    { 920, -56, 168},
    { 1376, 296, -72},
    { 1760, -72, 408},
    { 1752, 248, 416},
    { 1568, 544, 40},
    { 1336, 592, 8},
    { 1120, 280, 224},
    { 960, 392, 184},
    { 968, 336, 280},
    { 880, 256, 264},
    { 832, 400, 128},
    { 792, 376, 120},
    { 872, 480, 56},
    { 928, 352, 104},
    { 1200, 440, 48},
    { 1296, 256, 216},
    { 1728, 408, 176},
    { 1496, 352, 160},
    { 1104, 472, 152},
    { 1448, 456, 112},
    // 54 seconds
    { 1456, 184, 192},
    { 1280, 152, 240},
    { 1088, 80, 208},
    { 888, 40, 152},
    { 776, -8, 136},
    { 648, 8, 80},
    { 552, -32, 72},
    { 504, -72, 72},
    { 664, -48, 16},
    { 888, 48, -64},
    { 1552, -160, 152},
    { 1904, -112, 520},
    { 1744, 408, 264},
    { 1552, 560, -88},
    { 1304, 504, 128},
    { 1128, 192, 328},
    { 1120, 200, 320},
    { 1008, 296, 232},
    { 944, 360, 144},
    { 856, 392, 96},
    { 880, 488, 40},
    { 880, 472, 24},
    { 976, 432, 24},
    { 1216, 368, 112},
    { 1280, 312, 192},
    // 55 seconds
    { 1568, 288, 216},
    { 1576, 400, 272},
    { 1256, 280, 232},
    { 1456, 296, 160},
    { 1536, 144, 344},
    { 1392, 128, 304},
    { 1232, 40, 272},
    { 1048, 0, 208},
    { 888, 0, 144},
    { 744, -48, 152},
    { 600, -88, 104},
    { 504, -128, 16},
    { 584, -80, -96},
    { 696, 0, -72},
    { 1440, -144, 160},
    { 1872, -72, 704},
    { 1776, 552, 416},
    { 1672, 864, 48},
    { 1344, 536, -24},
    { 992, -16, 520},
    { 992, 560, 312},
    { 968, 576, 240},
    { 872, 512, 192},
    { 832, 496, 128},
    { 816, 488, 128},
    // 56 seconds
    { 880, 536, 128},
    { 1016, 392, 200},
    { 1224, 400, 304},
    { 1352, 336, 360},
    { 1568, 104, 448},
    { 1512, -104, 592},
    { 1416, 104, 592},
    { 2632, 216, -1312},
    { 1352, -144, 40},
    { 1160, 360, 96},
    { 928, -32, 304},
    { 824, 24, 144},
    { 680, -16, -16},
    { 584, -64, 8},
    { 552, -40, -24},
    { 624, 16, -48},
    { 856, -16, 96},
    { 1256, 160, 168},
    { 1864, -72, 496},
    { 2016, 168, 504},
    { 1344, 856, 176},
    { 1552, 688, -120},
    { 920, 376, 400},
    { 968, 472, 152},
    { 816, 144, 160},
    // 57 seconds
    { 696, 200, 328},
    { 856, 288, 232},
    { 840, 368, 264},
    { 856, 416, 272},
    { 880, 520, 216},
    { 1032, 336, 296},
    { 1224, 456, 432},
    { 1592, 360, 640},
    { 1872, 424, 752},
    { 1304, 296, 504},
    { 1816, 632, -304},
    { 1064, -64, 280},
    { 1184, -48, 240},
    { 920, 232, 296},
    { 848, 200, 136},
    { 696, 80, 104},
    { 600, -48, 160},
    { 592, 0, 24},
    { 600, -64, 40},
    { 808, -64, 32},
    { 1112, 32, 40},
    { 1744, -144, 248},
    { 2128, -16, 456},
    { 1672, 584, 80},
    { 1248, 456, -96},
    // 58 seconds
    { 1120, 184, 152},
    { 968, 56, 288},
    { 1016, 128, 272},
    { 928, 192, 272},
    { 848, 352, 184},
    { 760, 424, 144},
    { 752, 544, 128},
    { 784, 464, 192},
    { 1016, 400, 136},
    { 1240, 376, 208},
    { 1488, 376, 264},
    { 1840, 368, 488},
    { 1688, 392, 384},
    { 1448, 424, 328},
    { 1784, 264, 384},
    { 1664, 24, 208},
    { 1312, -184, 512},
    { 1088, -16, 200},
    { 888, -8, 72},
    { 664, -64, 48},
    { 552, -40, -40},
    { 520, -72, -88},
    { 544, -128, -48},
    { 752, -64, -48},
    { 1088, 64, 152},
    // 59 seconds
    { 1880, 88, 400},
    { 2128, 272, 512},
    { 1880, 608, 144},
    { 1408, 520, 288},
    { 1224, 544, 400},
    { 1056, 536, 168},
    { 1008, 288, 400},
    { 888, 288, 368},
    { 832, 392, 296},
    { 688, 424, 200},
    { 680, 456, 104},
    { 712, 424, 64},
    { 824, 280, 104},
    { 1096, 296, 144},
    { 1272, 200, 208},
    { 1968, 144, 248},
    { 1608, 128, 288},
    { 1464, 32, 296},
    { 1496, -16, 184},
    { 960, -432, 216},
    { 760, -576, 384},
    { 1280, -168, 272},
    { 1160, 88, 320},
    { 1192, 288, 256},
    { 1088, 336, 336},
    // 60 seconds
    // elapsed: 1 minutes
    { 864, 616, 280},
    { 624, 728, 56},
    { 504, 936, -80},
    { 536, 1024, -48},
    { 280, 976, -16},
    { 224, 896, -32},
    { 80, 736, -80},
    { 152, 728, -192},
    { 56, 528, -64},
    { 40, 608, -56},
    { 0, 800, -200},
    { -192, 704, -144},
    { -160, 856, -160},
    { -192, 1000, -264},
    { -224, 1112, -336},
    { -352, 992, -352},
    { -288, 984, -352},
    { -320, 920, -480},
    { -280, 800, -504},
    { -184, 888, -600},
    { -192, 576, -776},
    { -8, 472, -760},
    { 24, 280, -872},
    { 96, 272, -968},
    { 368, 152, -928},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-03 08:56:10 local
AccelRawData *activity_sample_walk_100_pbl_25531_6(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25531_6
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 544, 136, -296},
    { 376, 56, -288},
    { 432, -8, -200},
    { 408, 8, -528},
    { 368, -40, -792},
    { 440, 56, -840},
    { 368, -88, -792},
    { 448, -48, -888},
    { 400, -32, -872},
    { 368, -24, -856},
    { 416, 40, -864},
    { 544, -112, -840},
    { 504, -136, -928},
    { 456, -144, -936},
    { 424, -144, -976},
    { 400, -160, -872},
    { 480, -112, -896},
    { 576, -112, -936},
    { 520, -96, -872},
    { 456, -136, -936},
    { 416, -176, -888},
    { 504, -240, -952},
    { 392, -304, -880},
    { 456, -352, -856},
    { 360, -416, -840},
    // 1 seconds
    { 392, -400, -848},
    { 392, -376, -848},
    { 176, -280, -840},
    { 400, -368, -832},
    { 528, -264, -888},
    { 432, -232, -832},
    { 384, -272, -856},
    { 400, -120, -904},
    { 368, -232, -896},
    { 384, -168, -880},
    { 392, -152, -832},
    { 464, -104, -752},
    { 408, -120, -632},
    { 392, 88, -552},
    { 344, 0, -400},
    { 344, 64, -232},
    { 528, 208, -192},
    { 728, 448, -392},
    { 920, 496, -328},
    { 1152, 864, -264},
    { 944, 512, -72},
    { 1024, 584, 24},
    { 1192, 720, 48},
    { 1304, 1008, 104},
    { 936, 1136, 320},
    // 2 seconds
    { 1184, 1048, -56},
    { 824, 216, 168},
    { 752, 8, 192},
    { 912, 144, 168},
    { 1064, 296, 176},
    { 984, 256, 184},
    { 944, 232, 184},
    { 912, 248, 136},
    { 912, 208, 96},
    { 904, 208, 96},
    { 912, 248, 104},
    { 896, 280, 88},
    { 912, 288, 88},
    { 960, 296, 96},
    { 960, 296, 96},
    { 904, 328, 72},
    { 888, 296, 64},
    { 936, 280, 88},
    { 952, 280, 112},
    { 960, 304, 104},
    { 920, 304, 96},
    { 904, 288, 80},
    { 944, 296, 56},
    { 960, 240, 80},
    { 968, 216, 88},
    // 3 seconds
    { 960, 184, 64},
    { 936, 136, 48},
    { 952, 120, 48},
    { 968, 120, 48},
    { 960, 112, 56},
    { 968, 104, 48},
    { 968, 112, 40},
    { 952, 104, 40},
    { 968, 120, 56},
    { 960, 152, 48},
    { 960, 168, 56},
    { 968, 184, 56},
    { 952, 208, 56},
    { 952, 192, 40},
    { 944, 176, 48},
    { 960, 160, 48},
    { 968, 152, 48},
    { 968, 128, 48},
    { 968, 120, 56},
    { 968, 128, 56},
    { 960, 120, 56},
    { 976, 112, 64},
    { 984, 120, 48},
    { 976, 112, 48},
    { 960, 120, 24},
    // 4 seconds
    { 952, 112, 32},
    { 968, 136, 32},
    { 960, 144, 40},
    { 960, 144, 40},
    { 968, 136, 40},
    { 976, 136, 40},
    { 968, 152, 32},
    { 968, 144, 40},
    { 960, 144, 24},
    { 968, 152, 32},
    { 968, 168, 32},
    { 968, 160, 40},
    { 968, 152, 48},
    { 968, 136, 40},
    { 968, 112, 40},
    { 960, 128, 32},
    { 952, 144, 32},
    { 952, 160, 40},
    { 968, 176, 56},
    { 960, 184, 56},
    { 960, 184, 48},
    { 960, 168, 40},
    { 952, 160, 32},
    { 960, 160, 32},
    { 944, 160, 40},
    // 5 seconds
    { 952, 152, 48},
    { 960, 160, 48},
    { 968, 176, 40},
    { 960, 176, 32},
    { 968, 168, 24},
    { 968, 160, 32},
    { 960, 152, 40},
    { 960, 152, 48},
    { 960, 144, 56},
    { 960, 144, 56},
    { 960, 136, 56},
    { 960, 136, 56},
    { 960, 128, 48},
    { 952, 136, 40},
    { 968, 152, 40},
    { 968, 168, 40},
    { 968, 168, 32},
    { 968, 160, 40},
    { 968, 152, 40},
    { 960, 144, 32},
    { 960, 136, 40},
    { 952, 136, 48},
    { 960, 136, 64},
    { 976, 144, 64},
    { 976, 160, 40},
    // 6 seconds
    { 968, 152, 16},
    { 952, 152, 32},
    { 952, 160, 56},
    { 936, 144, 72},
    { 952, 120, 80},
    { 968, 144, 48},
    { 968, 160, 32},
    { 992, 168, 24},
    { 1000, 192, 16},
    { 960, 200, 32},
    { 936, 160, 40},
    { 928, 120, 72},
    { 928, 128, 80},
    { 960, 168, 64},
    { 968, 176, 32},
    { 976, 160, 24},
    { 968, 144, 24},
    { 976, 152, 40},
    { 968, 160, 56},
    { 960, 144, 64},
    { 960, 136, 56},
    { 952, 144, 40},
    { 976, 152, 40},
    { 976, 152, 40},
    { 976, 160, 56},
    // 7 seconds
    { 944, 152, 64},
    { 952, 144, 72},
    { 952, 136, 48},
    { 952, 136, 48},
    { 976, 168, 32},
    { 968, 160, 40},
    { 968, 168, 32},
    { 976, 160, 48},
    { 968, 152, 48},
    { 952, 128, 64},
    { 944, 128, 64},
    { 960, 120, 64},
    { 960, 136, 40},
    { 944, 160, 40},
    { 968, 160, 48},
    { 952, 160, 48},
    { 968, 176, 56},
    { 976, 184, 56},
    { 968, 192, 48},
    { 960, 168, 40},
    { 960, 152, 48},
    { 968, 136, 56},
    { 968, 128, 64},
    { 968, 136, 56},
    { 952, 128, 64},
    // 8 seconds
    { 952, 128, 72},
    { 960, 128, 72},
    { 968, 120, 56},
    { 984, 112, 56},
    { 976, 120, 56},
    { 968, 104, 56},
    { 952, 96, 56},
    { 960, 88, 72},
    { 976, 96, 72},
    { 976, 88, 80},
    { 992, 88, 72},
    { 960, 88, 64},
    { 960, 96, 56},
    { 960, 104, 56},
    { 960, 120, 80},
    { 960, 144, 88},
    { 960, 128, 80},
    { 976, 104, 80},
    { 976, 104, 64},
    { 944, 104, 56},
    { 976, 88, 72},
    { 992, 128, 80},
    { 960, 136, 104},
    { 944, 120, 88},
    { 952, 96, 64},
    // 9 seconds
    { 976, 112, 88},
    { 1024, 144, 72},
    { 976, 136, 72},
    { 952, 152, 64},
    { 944, 144, 88},
    { 936, 152, 64},
    { 928, 184, 104},
    { 912, 208, 104},
    { 920, 208, 120},
    { 944, 200, 96},
    { 960, 192, 40},
    { 960, 184, -8},
    { 936, 184, -16},
    { 928, 208, 24},
    { 928, 232, 56},
    { 960, 200, 88},
    { 1000, 176, 80},
    { 1216, 88, 192},
    { 1360, 128, 232},
    { 1416, -80, 192},
    { 1048, -96, -136},
    { 512, -80, -232},
    { 704, -176, 16},
    { 944, -136, 184},
    { 952, -88, 176},
    // 10 seconds
    { 872, 0, 88},
    { 808, 48, 72},
    { 792, 88, 96},
    { 776, 136, 88},
    { 808, 240, 8},
    { 840, 200, 32},
    { 904, 208, 0},
    { 1136, 136, 48},
    { 1256, 176, 96},
    { 1608, 96, 176},
    { 1688, 104, 216},
    { 992, 256, 0},
    { 656, 16, 32},
    { 872, -192, -80},
    { 912, -456, 304},
    { 680, -360, 256},
    { 896, -48, 184},
    { 872, 128, 96},
    { 832, 72, 288},
    { 768, -112, 248},
    { 744, 80, 288},
    { 824, 112, 184},
    { 1136, -96, 208},
    { 1240, 16, 104},
    { 1448, -40, 112},
    // 11 seconds
    { 1552, 240, 136},
    { 1080, 416, 80},
    { 928, 0, 8},
    { 808, -144, -136},
    { 856, -392, 160},
    { 672, -432, 256},
    { 688, -136, 160},
    { 752, 304, 16},
    { 792, 312, 80},
    { 768, 208, 104},
    { 824, 216, 136},
    { 968, 200, 128},
    { 1104, 216, 48},
    { 1312, 264, 376},
    { 1592, 408, 392},
    { 1376, 672, 352},
    { 544, 272, 280},
    { 744, 176, 144},
    { 776, 176, 184},
    { 680, 440, -80},
    { 752, 272, 176},
    { 712, 392, -112},
    { 712, 168, 48},
    { 712, 192, 64},
    { 696, 120, 8},
    // 12 seconds
    { 760, 152, 152},
    { 800, 248, 56},
    { 1080, 336, 120},
    { 1000, 328, 128},
    { 1600, -16, 448},
    { 1776, 184, 528},
    { 1168, 680, 104},
    { 600, 456, -128},
    { 608, 72, 104},
    { 680, 48, 264},
    { 664, 112, 208},
    { 720, 184, 152},
    { 632, 312, 8},
    { 776, 216, 88},
    { 840, 288, 80},
    { 912, 216, 128},
    { 1120, 240, 128},
    { 1640, 184, 320},
    { 1712, 272, 352},
    { 1424, 344, 256},
    { 1184, 248, 32},
    { 856, 192, 168},
    { 632, -72, 336},
    { 528, -64, 264},
    { 680, 0, 208},
    // 13 seconds
    { 824, 192, 184},
    { 856, 160, 272},
    { 800, 120, 240},
    { 792, 112, 128},
    { 888, 80, 144},
    { 992, 208, 32},
    { 1168, 232, -16},
    { 1536, -112, 128},
    { 1496, -120, 264},
    { 976, 256, 56},
    { 784, 200, -80},
    { 736, 176, -72},
    { 688, 192, -24},
    { 736, 160, 64},
    { 824, 96, 208},
    { 848, 224, 128},
    { 800, 240, 88},
    { 808, 312, 0},
    { 864, 312, 0},
    { 992, 280, 96},
    { 1184, 256, 224},
    { 1880, 168, 456},
    { 1864, 400, 352},
    { 1016, 408, 272},
    { 840, 184, 176},
    // 14 seconds
    { 840, 16, 192},
    { 776, -32, 264},
    { 824, 64, 184},
    { 760, -8, 224},
    { 752, 64, 128},
    { 688, -8, 216},
    { 688, 32, 176},
    { 744, 80, 96},
    { 1064, 120, 72},
    { 1352, 224, 56},
    { 1776, 40, 200},
    { 1592, -56, 200},
    { 992, 232, -144},
    { 736, 272, -264},
    { 744, -16, -80},
    { 712, -24, 136},
    { 760, 312, 64},
    { 856, 168, 112},
    { 776, 176, 136},
    { 752, 216, 64},
    { 768, 224, 64},
    { 856, 248, 32},
    { 992, 272, 24},
    { 1248, 240, 120},
    { 1432, 280, 160},
    // 15 seconds
    { 1528, 280, 176},
    { 1528, 288, 176},
    { 1008, 440, 64},
    { 792, 296, -128},
    { 1016, -320, 408},
    { 880, -16, 288},
    { 912, 144, 136},
    { 912, 72, 176},
    { 760, 136, 80},
    { 736, 72, 72},
    { 704, 24, 88},
    { 664, 56, 32},
    { 712, 56, -16},
    { 944, 104, -24},
    { 1216, 128, 24},
    { 1648, -24, 224},
    { 1624, 16, 288},
    { 1088, 288, 64},
    { 824, 408, -168},
    { 888, 112, 32},
    { 864, 264, 80},
    { 800, 96, 184},
    { 800, 200, 192},
    { 808, 280, 96},
    { 784, 232, 120},
    // 16 seconds
    { 816, 272, 88},
    { 880, 328, 8},
    { 888, 296, 32},
    { 1152, 256, 48},
    { 1296, 224, 160},
    { 1784, 200, 272},
    { 1640, 384, 208},
    { 752, 408, 120},
    { 760, 240, 104},
    { 1048, 88, 176},
    { 1064, 72, 232},
    { 904, 64, 224},
    { 848, 48, 160},
    { 760, 48, 144},
    { 696, 72, 104},
    { 688, 56, 112},
    { 688, 32, 80},
    { 792, 56, 32},
    { 1080, 128, 16},
    { 1392, 64, 112},
    { 1624, -64, 232},
    { 1400, 112, 96},
    { 992, 368, -136},
    { 856, 224, -64},
    { 776, -24, 80},
    // 17 seconds
    { 792, 144, 96},
    { 824, 168, 144},
    { 848, 296, 72},
    { 800, 264, 112},
    { 792, 352, 32},
    { 880, 336, 24},
    { 888, 280, 16},
    { 1096, 192, 64},
    { 1360, 208, 112},
    { 1752, 176, 256},
    { 1688, 336, 160},
    { 1048, 384, 88},
    { 944, 232, 88},
    { 1000, 32, 192},
    { 960, 104, 248},
    { 944, 120, 208},
    { 896, 32, 224},
    { 784, 64, 128},
    { 736, -8, 160},
    { 672, -8, 152},
    { 640, 24, 80},
    { 664, 0, 32},
    { 888, 40, 16},
    { 1368, -32, 144},
    { 1848, -288, 464},
    // 18 seconds
    { 1592, 56, 312},
    { 976, 584, -304},
    { 800, 432, 0},
    { 1000, 176, 40},
    { 1016, 88, 368},
    { 904, 264, 288},
    { 912, 248, 144},
    { 848, 392, 24},
    { 864, 392, 16},
    { 912, 432, -120},
    { 880, 256, 40},
    { 1072, 312, 40},
    { 1248, 216, 168},
    { 1488, 208, 232},
    { 1720, 184, 360},
    { 1424, 408, 248},
    { 984, 328, 168},
    { 1208, 288, 184},
    { 1288, 104, 352},
    { 1136, 72, 312},
    { 992, 80, 184},
    { 848, -56, 224},
    { 696, -40, 152},
    { 616, -24, 80},
    { 552, -40, 64},
    // 19 seconds
    { 536, -32, 32},
    { 768, 24, -72},
    { 1080, 0, 16},
    { 1760, -216, 352},
    { 2032, -24, 600},
    { 1720, 688, 8},
    { 1272, 688, -224},
    { 1032, 336, 200},
    { 960, -32, 400},
    { 904, 104, 304},
    { 872, 208, 208},
    { 832, 464, 40},
    { 696, 416, 48},
    { 832, 448, 8},
    { 944, 400, 56},
    { 1088, 384, 96},
    { 1296, 344, 128},
    { 1616, 264, 232},
    { 1816, 400, 256},
    { 1200, 408, 176},
    { 1264, 240, 208},
    { 1360, -160, 416},
    { 1336, 48, 328},
    { 1088, 40, 272},
    { 960, 24, 216},
    // 20 seconds
    { 848, 16, 160},
    { 752, 0, 120},
    { 688, -80, 136},
    { 560, -144, 32},
    { 576, -120, -32},
    { 872, 64, -96},
    { 1240, 32, 0},
    { 1680, -88, 480},
    { 1680, 312, 432},
    { 1472, 664, 96},
    { 1232, 608, 0},
    { 1064, 280, 344},
    { 968, 168, 416},
    { 928, 256, 328},
    { 904, 368, 248},
    { 832, 424, 176},
    { 776, 408, 112},
    { 768, 448, 40},
    { 904, 328, 136},
    { 1184, 456, 120},
    { 1512, 520, 280},
    { 1712, 584, 296},
    { 1416, 528, 224},
    { 1136, 320, 200},
    { 1408, 264, 256},
    // 21 seconds
    { 1552, 144, 368},
    { 1312, 72, 336},
    { 1136, 136, 152},
    { 960, 40, 168},
    { 784, 16, 128},
    { 624, -40, 80},
    { 472, -104, 32},
    { 432, -120, 0},
    { 616, -64, -40},
    { 968, -24, -32},
    { 1584, -200, 312},
    { 1904, 72, 504},
    { 1888, 472, 256},
    { 1512, 704, -56},
    { 1224, 464, 240},
    { 1096, 192, 328},
    { 1064, 96, 344},
    { 1024, 248, 232},
    { 912, 408, 136},
    { 800, 560, -48},
    { 872, 552, -16},
    { 960, 536, -16},
    { 1200, 368, 56},
    { 1296, 272, 176},
    { 1824, 256, 304},
    // 22 seconds
    { 1696, 424, 320},
    { 1216, 200, 296},
    { 1424, 104, 248},
    { 1576, -88, 480},
    { 1344, 8, 352},
    { 1192, 80, 224},
    { 1008, 64, 168},
    { 808, 8, 128},
    { 656, -64, 112},
    { 552, -128, 64},
    { 504, -144, 32},
    { 576, -168, 0},
    { 880, -64, -104},
    { 1416, -8, 16},
    { 2016, 56, 560},
    { 1936, 592, 440},
    { 1552, 952, -80},
    { 1240, 440, 248},
    { 944, 216, 472},
    { 888, 336, 368},
    { 896, 320, 360},
    { 912, 344, 360},
    { 688, 376, 192},
    { 728, 304, 104},
    { 920, 528, -16},
    // 23 seconds
    { 1136, 504, 88},
    { 1288, 504, 152},
    { 1608, 512, 176},
    { 1808, 384, 288},
    { 1256, 304, 272},
    { 1544, 296, -392},
    { 1408, 184, 512},
    { 1392, 376, 272},
    { 1120, 224, 288},
    { 936, 8, 328},
    { 784, 0, 216},
    { 688, -80, 208},
    { 616, -48, 136},
    { 608, -8, 80},
    { 672, -32, 72},
    { 944, 48, -40},
    { 1168, -16, -48},
    { 1592, -32, 176},
    { 1640, 112, 296},
    { 1328, 408, 184},
    { 1304, 408, 176},
    { 1208, 424, 232},
    { 1032, 440, 176},
    { 960, 352, 160},
    { 936, 424, 72},
    // 24 seconds
    { 856, 376, 64},
    { 784, 496, -56},
    { 872, 392, -8},
    { 984, 392, 0},
    { 1128, 256, 72},
    { 1304, 320, 112},
    { 1824, 248, 272},
    { 1672, 400, 216},
    { 1032, 344, 88},
    { 1240, 160, 128},
    { 1384, 88, 344},
    { 1248, 104, 288},
    { 1032, 64, 224},
    { 896, 24, 160},
    { 768, -48, 208},
    { 664, -40, 144},
    { 560, -16, 80},
    { 520, -40, 88},
    { 664, 0, -40},
    { 968, 168, -176},
    { 1472, -128, 240},
    { 1808, -96, 576},
    { 1464, 480, 232},
    { 1328, 664, -96},
    { 1216, 472, 184},
    // 25 seconds
    { 928, 320, 408},
    { 856, 344, 304},
    { 800, 448, 192},
    { 896, 504, 144},
    { 872, 504, 40},
    { 904, 480, 0},
    { 936, 416, -8},
    { 936, 296, 24},
    { 1184, 208, 152},
    { 1352, 248, 320},
    { 1672, 360, 360},
    { 1448, 592, 280},
    { 848, 320, 288},
    { 1112, 240, 264},
    { 1216, 184, 360},
    { 1080, 160, 408},
    { 888, 184, 184},
    { 768, 104, 152},
    { 664, 120, 104},
    { 592, 40, 96},
    { 568, -8, 104},
    { 552, -16, 24},
    { 736, -32, 24},
    { 1128, 88, -96},
    { 1608, -176, 264},
    // 26 seconds
    { 1960, -32, 488},
    { 1544, 576, -8},
    { 1200, 688, -184},
    { 984, 88, 344},
    { 968, 0, 392},
    { 992, 80, 304},
    { 976, 232, 184},
    { 872, 408, 64},
    { 768, 480, -48},
    { 776, 400, 8},
    { 952, 408, 8},
    { 1136, 288, 72},
    { 1336, 480, -8},
    { 1616, 368, 208},
    { 1840, 264, 472},
    { 1344, 376, 360},
    { 1160, 472, 144},
    { 1384, 296, 288},
    { 1376, 88, 400},
    { 1200, -40, 416},
    { 1040, -24, 280},
    { 928, 8, 232},
    { 832, 40, 144},
    { 736, 32, 120},
    { 648, -24, 88},
    // 27 seconds
    { 648, -56, -32},
    { 768, 8, -128},
    { 1096, -88, -80},
    { 1472, -232, 328},
    { 1488, 192, 256},
    { 1440, 432, 32},
    { 1504, 336, 96},
    { 1368, 328, 296},
    { 1216, 280, 392},
    { 1128, 328, 392},
    { 1072, 312, 280},
    { 984, 392, 160},
    { 904, 472, 48},
    { 888, 568, 24},
    { 1008, 576, 72},
    { 1200, 544, 136},
    { 1704, 536, 248},
    { 1768, 528, 312},
    { 1264, 272, 208},
    { 1400, 184, 232},
    { 1792, 280, 80},
    { 1616, 192, 408},
    { 1392, 80, 240},
    { 1224, 16, 272},
    { 1072, 16, 208},
    // 28 seconds
    { 968, -24, 200},
    { 808, -40, 120},
    { 608, -184, 32},
    { 520, -176, -56},
    { 664, -56, -128},
    { 1008, -80, 8},
    { 1408, -16, 224},
    { 1544, 248, 304},
    { 1432, 440, 120},
    { 1560, 416, 96},
    { 1576, 376, 336},
    { 1464, 448, 352},
    { 1256, 536, 312},
    { 1032, 568, 184},
    { 824, 456, 48},
    { 816, 432, 56},
    { 864, 472, 48},
    { 920, 440, 80},
    { 1192, 480, 120},
    { 1272, 464, 232},
    { 1528, 424, 176},
    { 1528, 440, 208},
    { 1304, 240, 240},
    { 1488, 136, 248},
    { 1624, 56, 336},
    // 29 seconds
    { 1512, 48, 352},
    { 1272, 80, 208},
    { 1080, 56, 144},
    { 888, 16, 120},
    { 752, 32, 112},
    { 672, 0, 72},
    { 584, -96, 24},
    { 536, -120, -72},
    { 712, -16, -112},
    { 1240, -96, 48},
    { 1632, 48, 328},
    { 1664, 384, 232},
    { 1696, 416, 40},
    { 1576, 456, 144},
    { 1320, 320, 336},
    { 1152, 392, 280},
    { 1072, 240, 232},
    { 1008, 248, 168},
    { 920, 344, 40},
    { 896, 400, -16},
    { 872, 472, -48},
    { 872, 392, 0},
    { 1120, 464, -8},
    { 1240, 360, 144},
    { 1664, 336, 120},
    // 30 seconds
    { 1648, 312, 224},
    { 1280, 256, 224},
    { 1392, 144, 208},
    { 1584, 128, 184},
    { 1472, 112, 376},
    { 1296, 64, 248},
    { 1128, 64, 208},
    { 968, -16, 216},
    { 856, -8, 120},
    { 736, 8, 56},
    { 592, -64, 32},
    { 512, -80, -32},
    { 632, -8, -160},
    { 1056, -64, -8},
    { 1488, -24, 272},
    { 1504, 376, 296},
    { 1144, 720, 0},
    { 1240, 408, 96},
    { 1336, 304, 336},
    { 1216, 304, 416},
    { 1104, 336, 352},
    { 1040, 408, 296},
    { 920, 416, 336},
    { 824, 472, 240},
    { 792, 512, 200},
    // 31 seconds
    { 832, 600, 200},
    { 1048, 648, 128},
    { 1128, 624, 208},
    { 1624, 448, 352},
    { 1672, 248, 496},
    { 936, 320, 400},
    { 984, 232, 288},
    { 1280, 160, 296},
    { 1352, 120, 320},
    { 1232, 112, 216},
    { 1176, 64, 160},
    { 1016, 48, 80},
    { 840, 32, 8},
    { 720, -48, 40},
    { 584, -104, 0},
    { 560, -88, -32},
    { 816, 96, -32},
    { 1016, 152, 40},
    { 1600, 16, 480},
    { 1488, 304, 568},
    { 1120, 552, 160},
    { 1192, 432, 120},
    { 1264, 536, 312},
    { 1064, 424, 368},
    { 928, 384, 248},
    // 32 seconds
    { 904, 288, 240},
    { 856, 448, 104},
    { 808, 400, 96},
    { 832, 480, 32},
    { 864, 400, 64},
    { 1144, 352, 104},
    { 1296, 296, 208},
    { 1704, 288, 328},
    { 1672, 440, 248},
    { 1040, 304, 200},
    { 1384, 192, -72},
    { 1520, 16, 504},
    { 1320, 96, 296},
    { 1104, 136, 224},
    { 960, 104, 152},
    { 816, 32, 152},
    { 696, 0, 112},
    { 584, -8, 48},
    { 480, -64, 40},
    { 520, -72, -24},
    { 824, 80, -96},
    { 1448, -88, 184},
    { 1776, -8, 592},
    { 1576, 448, 312},
    { 1440, 624, -120},
    // 33 seconds
    { 1256, 504, 152},
    { 1096, 344, 296},
    { 1024, 144, 344},
    { 976, 288, 256},
    { 912, 424, 192},
    { 808, 480, 112},
    { 808, 488, 112},
    { 808, 528, 56},
    { 1056, 432, 128},
    { 1280, 536, 240},
    { 1640, 424, 352},
    { 1880, 384, 432},
    { 1216, 440, 184},
    { 1176, 280, 128},
    { 1360, 136, 240},
    { 1304, 144, 224},
    { 1128, 32, 360},
    { 944, -16, 304},
    { 816, -8, 176},
    { 760, -48, 176},
    { 680, -8, 128},
    { 600, -16, 80},
    { 600, -40, 16},
    { 808, 32, -80},
    { 1056, -32, 8},
    // 34 seconds
    { 1536, -168, 272},
    { 1768, 72, 312},
    { 1456, 520, -104},
    { 1376, 456, -104},
    { 1392, 440, 136},
    { 1112, 416, 144},
    { 1056, 320, 184},
    { 944, 288, 144},
    { 832, 368, 48},
    { 800, 392, -48},
    { 824, 400, -72},
    { 928, 392, -72},
    { 1088, 264, 56},
    { 1312, 288, 80},
    { 1656, 232, 208},
    { 1640, 440, 176},
    { 1200, 288, 184},
    { 1360, 168, 168},
    { 1488, 80, 280},
    { 1272, 64, 320},
    { 1064, 112, 168},
    { 984, 40, 192},
    { 888, 16, 152},
    { 800, -40, 152},
    { 680, -40, 104},
    // 35 seconds
    { 584, -48, 32},
    { 624, -64, -24},
    { 848, 64, -144},
    { 1272, -88, 8},
    { 1656, -88, 240},
    { 1496, 224, 232},
    { 1360, 360, 24},
    { 1416, 344, 88},
    { 1288, 424, 232},
    { 1088, 296, 328},
    { 992, 296, 240},
    { 944, 296, 176},
    { 856, 360, 104},
    { 880, 408, 32},
    { 920, 480, 0},
    { 1008, 496, -64},
    { 1232, 312, -8},
    { 1472, 136, 128},
    { 1624, 208, 216},
    { 1288, 368, 136},
    { 960, 296, 120},
    { 1248, 248, 144},
    { 1416, 176, 248},
    { 1272, 112, 288},
    { 1120, 72, 240},
    // 36 seconds
    { 1016, 64, 168},
    { 888, -8, 176},
    { 752, -8, 152},
    { 640, -24, 80},
    { 584, -72, 56},
    { 752, 0, -48},
    { 928, 72, -120},
    { 1392, -200, 192},
    { 1600, -80, 384},
    { 1448, 384, 72},
    { 1360, 480, -120},
    { 1200, 392, 152},
    { 1160, 184, 184},
    { 1024, 320, 240},
    { 1008, 336, 224},
    { 920, 320, 184},
    { 824, 400, 112},
    { 816, 440, 56},
    { 848, 528, -8},
    { 984, 440, 56},
    { 1328, 496, 88},
    { 1496, 416, 152},
    { 1616, 400, 208},
    { 1296, 392, 136},
    { 1120, 208, 176},
    // 37 seconds
    { 1472, 112, 152},
    { 1368, 32, 296},
    { 1192, 104, 224},
    { 1016, 112, 144},
    { 848, 104, 88},
    { 784, 24, 112},
    { 752, -40, 120},
    { 672, -56, 48},
    { 616, -56, 0},
    { 720, 48, -80},
    { 936, 48, -72},
    { 1536, 72, 184},
    { 1648, 344, 280},
    { 1288, 624, 0},
    { 1264, 608, -16},
    { 1176, 496, 200},
    { 1024, 352, 208},
    { 944, 176, 328},
    { 896, 352, 248},
    { 816, 392, 136},
    { 760, 400, 56},
    { 808, 360, 80},
    { 832, 384, 120},
    { 1032, 448, 120},
    { 1304, 552, 104},
    // 38 seconds
    { 1528, 408, 288},
    { 1712, 264, 176},
    { 1200, 272, 128},
    { 1032, 240, 88},
    { 1240, 120, 72},
    { 1248, 40, 216},
    { 1160, 152, 240},
    { 1040, 96, 184},
    { 912, 40, 144},
    { 816, 16, 136},
    { 736, 32, 88},
    { 664, 16, 48},
    { 648, -32, 16},
    { 768, 24, -64},
    { 1000, -16, -56},
    { 1512, -88, 136},
    { 1632, 8, 232},
    { 1400, 280, 8},
    { 1328, 400, -64},
    { 1264, 352, 104},
    { 1064, 264, 240},
    { 968, 160, 256},
    { 976, 216, 200},
    { 920, 312, 120},
    { 864, 384, 40},
    // 39 seconds
    { 864, 464, 8},
    { 896, 448, 16},
    { 1000, 424, 16},
    { 1272, 368, 104},
    { 1744, 280, 216},
    { 1776, 264, 264},
    { 1256, 280, 184},
    { 1144, 208, 128},
    { 1552, 112, -48},
    { 1416, 48, 376},
    { 1216, 64, 272},
    { 1048, 40, 192},
    { 928, 32, 144},
    { 816, -16, 152},
    { 696, -24, 96},
    { 600, -72, 40},
    { 504, -120, 8},
    { 664, 24, -104},
    { 936, 48, -8},
    { 1544, 48, 336},
    { 1768, 368, 432},
    { 1280, 696, 208},
    { 1080, 744, -8},
    { 984, 472, 280},
    { 912, 688, 256},
    // 40 seconds
    { 888, 320, 328},
    { 904, 424, 256},
    { 800, 408, 240},
    { 760, 456, 144},
    { 816, 336, 168},
    { 848, 432, 112},
    { 944, 336, 120},
    { 1176, 360, 152},
    { 1352, 288, 240},
    { 1592, 304, 248},
    { 1288, 416, 208},
    { 888, 360, 176},
    { 984, 312, 184},
    { 1088, 240, 296},
    { 1064, 80, 400},
    { 952, 168, 264},
    { 864, 112, 208},
    { 824, 48, 208},
    { 752, 64, 120},
    { 640, 24, 104},
    { 552, 24, 32},
    { 664, 8, -32},
    { 1000, 136, -104},
    { 1392, -216, 144},
    { 1944, -152, 544},
    // 41 seconds
    { 1544, 360, 216},
    { 1096, 584, -232},
    { 976, 256, 24},
    { 992, 240, 208},
    { 960, 176, 256},
    { 936, 232, 200},
    { 888, 272, 200},
    { 832, 408, 40},
    { 800, 352, 40},
    { 880, 456, -56},
    { 920, 320, 8},
    { 1176, 328, 16},
    { 1288, 200, 192},
    { 1728, 232, 184},
    { 1536, 376, 104},
    { 1032, 288, 104},
    { 1144, 200, 160},
    { 1272, 72, 264},
    { 1200, 88, 312},
    { 1016, 120, 240},
    { 952, 64, 192},
    { 856, 32, 168},
    { 728, 64, 80},
    { 624, 24, 80},
    { 576, 56, -40},
    // 42 seconds
    { 776, 104, -184},
    { 896, 24, -88},
    { 1344, -224, 184},
    { 1672, -128, 320},
    { 1424, 368, 120},
    { 1160, 552, -120},
    { 1112, 240, 64},
    { 1160, 184, 312},
    { 1056, 144, 320},
    { 984, 208, 240},
    { 896, 312, 112},
    { 864, 296, 80},
    { 848, 336, 40},
    { 880, 400, -32},
    { 968, 360, 16},
    { 1184, 400, 0},
    { 1304, 400, 72},
    { 1608, 400, 40},
    { 1424, 384, 48},
    { 976, 280, 96},
    { 1160, 176, 144},
    { 1304, 72, 224},
    { 1192, 104, 344},
    { 1016, 64, 256},
    { 928, 64, 208},
    // 43 seconds
    { 904, 32, 192},
    { 864, 0, 168},
    { 776, 8, 104},
    { 720, -8, 56},
    { 808, -16, -24},
    { 936, 56, -144},
    { 1432, -120, 40},
    { 1512, -72, 152},
    { 1168, 296, -72},
    { 1152, 336, -192},
    { 1224, 192, 112},
    { 1176, 216, 208},
    { 1040, 400, 176},
    { 936, 248, 184},
    { 888, 224, 136},
    { 840, 280, 32},
    { 848, 408, -96},
    { 880, 408, -96},
    { 1016, 400, -48},
    { 1208, 352, 24},
    { 1328, 280, 152},
    { 1560, 312, 136},
    { 1440, 368, 144},
    { 936, 176, 208},
    { 1144, 88, 176},
    // 44 seconds
    { 1272, -64, 288},
    { 1232, 32, 312},
    { 1080, 112, 176},
    { 944, 96, 112},
    { 872, 32, 112},
    { 824, 32, 32},
    { 744, 0, 24},
    { 656, -40, -8},
    { 696, -32, -104},
    { 888, 40, -152},
    { 1280, -152, 56},
    { 1600, -120, 248},
    { 1568, 192, 280},
    { 1408, 496, -24},
    { 1328, 376, 120},
    { 1136, 336, 336},
    { 976, 200, 320},
    { 944, 128, 272},
    { 888, 240, 192},
    { 800, 328, 72},
    { 792, 392, 8},
    { 816, 392, 32},
    { 928, 512, -72},
    { 1168, 440, -48},
    { 1288, 400, 24},
    // 45 seconds
    { 1664, 280, 152},
    { 1592, 288, 232},
    { 976, 248, 208},
    { 1064, 304, 168},
    { 1416, 192, 256},
    { 1432, 144, 336},
    { 1176, 56, 360},
    { 984, 56, 216},
    { 880, 0, 216},
    { 832, -32, 176},
    { 744, -24, 120},
    { 640, -64, 80},
    { 728, -128, 56},
    { 856, 40, -168},
    { 1152, -56, -120},
    { 1496, -200, 240},
    { 1608, 224, 192},
    { 1520, 536, -120},
    { 1536, 472, 32},
    { 1304, 448, 352},
    { 1016, 296, 360},
    { 928, 88, 296},
    { 952, 208, 160},
    { 824, 264, 136},
    { 824, 448, -40},
    // 46 seconds
    { 744, 408, -24},
    { 856, 408, -48},
    { 1120, 336, 16},
    { 1288, 288, 120},
    { 1784, 296, 120},
    { 1608, 432, 160},
    { 1160, 232, 144},
    { 1288, 160, 128},
    { 1472, 48, 216},
    { 1320, 40, 240},
    { 1120, 80, 184},
    { 984, 32, 176},
    { 848, 0, 152},
    { 752, -32, 136},
    { 680, -32, 88},
    { 616, -72, 48},
    { 632, -112, -32},
    { 960, 120, -120},
    { 1592, 72, -40},
    { 1640, 48, 240},
    { 1440, 448, 40},
    { 1384, 696, -312},
    { 1272, 392, 32},
    { 1176, 360, 160},
    { 1008, 344, 216},
    // 47 seconds
    { 968, 152, 256},
    { 904, 200, 232},
    { 752, 280, 56},
    { 736, 312, 16},
    { 824, 400, -16},
    { 944, 360, 8},
    { 1088, 648, -120},
    { 1280, 568, 56},
    { 1800, 552, 240},
    { 1664, 424, 224},
    { 1096, 336, 88},
    { 1312, 352, 88},
    { 1584, 264, 224},
    { 1408, 88, 400},
    { 1160, 40, 344},
    { 1032, 48, 240},
    { 896, 24, 192},
    { 744, 40, 96},
    { 648, -8, 40},
    { 528, -96, 0},
    { 608, -72, -136},
    { 784, 0, -184},
    { 1304, -160, 96},
    { 1824, 32, 480},
    { 1696, 632, 208},
    // 48 seconds
    { 1504, 776, -144},
    { 1552, 320, -96},
    { 1232, 264, 424},
    { 1048, 328, 408},
    { 936, 320, 264},
    { 856, 320, 208},
    { 768, 376, 136},
    { 768, 424, 72},
    { 776, 456, 72},
    { 952, 424, 112},
    { 1216, 488, 120},
    { 1656, 416, 264},
    { 1840, 448, 312},
    { 1168, 384, 152},
    { 1272, 264, 120},
    { 1536, 104, 216},
    { 1512, 32, 296},
    { 1192, 32, 264},
    { 976, 48, 128},
    { 808, 32, 104},
    { 736, 32, 64},
    { 672, 8, 40},
    { 640, -88, 48},
    { 656, -120, 0},
    { 856, 56, -144},
    // 49 seconds
    { 1400, -104, 72},
    { 1544, -48, 232},
    { 1488, 280, 128},
    { 1472, 472, -64},
    { 1352, 352, 168},
    { 1176, 256, 312},
    { 1120, 208, 312},
    { 1072, 208, 264},
    { 1016, 296, 144},
    { 888, 344, 72},
    { 872, 464, -8},
    { 856, 464, 8},
    { 1000, 440, 32},
    { 1320, 424, 128},
    { 1952, 504, 200},
    { 1816, 320, 240},
    { 1064, 200, 72},
    { 1224, 248, 80},
    { 1488, 88, 80},
    { 1456, 80, 240},
    { 1208, 16, 304},
    { 1056, -40, 256},
    { 888, -24, 208},
    { 704, -32, 168},
    { 576, -64, 128},
    // 50 seconds
    { 560, -64, 40},
    { 688, 16, -96},
    { 896, 96, -96},
    { 1488, -168, 136},
    { 1848, -168, 376},
    { 1568, 408, 224},
    { 1280, 600, -96},
    { 1336, 400, -16},
    { 1224, 288, 296},
    { 1112, 176, 352},
    { 1048, 296, 272},
    { 912, 352, 216},
    { 816, 424, 136},
    { 760, 448, 88},
    { 824, 456, 72},
    { 992, 424, 24},
    { 1232, 400, 88},
    { 1488, 240, 128},
    { 1784, 216, 112},
    { 1392, 336, 112},
    { 1144, 216, 104},
    { 1248, 104, 360},
    { 1568, 296, 624},
    { 1456, 192, 600},
    { 1256, 192, 320},
    // 51 seconds
    { 1080, 48, 336},
    { 904, -24, 376},
    { 760, 24, 152},
    { 728, 184, -168},
    { 648, 184, -120},
    { 488, -80, -64},
    { 608, 48, -64},
    { 1032, 72, 328},
    { 1136, 432, 304},
    { 1128, 560, 144},
    { 984, 360, 208},
    { 1072, 320, 264},
    { 1096, 192, 288},
    { 1144, 192, 368},
    { 1152, 288, 368},
    { 1264, 368, 344},
    { 1296, 544, 272},
    { 1128, 528, 192},
    { 888, 536, -48},
    { 904, 360, 8},
    { 1192, 408, 104},
    { 1472, 456, 200},
    { 1672, 528, 216},
    { 1248, 472, 120},
    { 1008, 176, 144},
    // 52 seconds
    { 1264, 120, 216},
    { 1440, 200, 464},
    { 1256, 120, 304},
    { 1136, 40, 224},
    { 984, -8, 216},
    { 896, 0, 176},
    { 792, -8, 152},
    { 728, -32, 104},
    { 704, -80, 64},
    { 808, 24, -72},
    { 1016, 8, -144},
    { 1664, -216, 200},
    { 1352, 152, 320},
    { 1224, 472, -80},
    { 1216, 728, -312},
    { 1112, 552, 112},
    { 1128, 264, 288},
    { 1112, 224, 504},
    { 952, 248, 528},
    { 768, 376, 208},
    { 824, 424, 88},
    { 864, 536, 8},
    { 896, 504, 32},
    { 1136, 480, 72},
    { 1224, 472, 152},
    // 53 seconds
    { 1640, 560, 176},
    { 1552, 536, 224},
    { 1088, 336, 168},
    { 1288, 280, 224},
    { 1736, 248, 104},
    { 1240, 144, 368},
    { 1216, 96, 152},
    { 1056, 0, 296},
    { 912, -16, 240},
    { 824, 8, 120},
    { 680, -40, 120},
    { 576, -72, 64},
    { 592, -56, -48},
    { 824, 32, -128},
    { 1344, -64, 64},
    { 1728, 104, 240},
    { 1408, 368, -64},
    { 1424, 408, -128},
    { 1416, 632, -32},
    { 1248, 560, 200},
    { 1112, 376, 184},
    { 960, 320, 272},
    { 896, 384, 296},
    { 816, 352, 184},
    { 816, 400, 64},
    // 54 seconds
    { 848, 432, 40},
    { 976, 456, -16},
    { 1160, 504, -16},
    { 1424, 344, 56},
    { 1728, 400, 32},
    { 1440, 328, 120},
    { 1064, 288, 112},
    { 1232, 208, 112},
    { 1376, 256, 88},
    { 1280, 160, 224},
    { 1088, 40, 240},
    { 960, 72, 168},
    { 872, 8, 192},
    { 784, -8, 144},
    { 720, 0, 32},
    { 664, -88, -16},
    { 728, -72, -32},
    { 904, 72, -136},
    { 1432, -32, 0},
    { 1696, -32, 256},
    { 1432, 376, 32},
    { 1312, 472, -152},
    { 1328, 280, 160},
    { 1168, 264, 312},
    { 1024, 360, 296},
    // 55 seconds
    { 968, 320, 280},
    { 904, 352, 192},
    { 864, 368, 120},
    { 824, 448, 56},
    { 840, 464, -72},
    { 920, 392, -8},
    { 1248, 472, 80},
    { 1552, 416, 192},
    { 1704, 376, 256},
    { 1336, 376, 144},
    { 1152, 216, 176},
    { 1360, 104, 208},
    { 1416, 80, 248},
    { 1256, 56, 256},
    { 1096, 32, 216},
    { 944, 24, 160},
    { 848, 24, 104},
    { 768, -8, 96},
    { 664, -24, 24},
    { 584, -128, 0},
    { 752, -24, -104},
    { 992, 152, -192},
    { 1464, -144, 136},
    { 1600, 8, 304},
    { 1512, 384, 72},
    // 56 seconds
    { 1496, 592, -72},
    { 1192, 496, 224},
    { 1048, 232, 344},
    { 984, 128, 336},
    { 952, 208, 280},
    { 904, 248, 264},
    { 768, 368, 152},
    { 824, 496, 64},
    { 864, 536, 56},
    { 1024, 440, 80},
    { 1168, 432, 96},
    { 1208, 376, 144},
    { 1536, 472, 96},
    { 1472, 472, 56},
    { 1080, 296, 104},
    { 1208, 152, 184},
    { 1384, 56, 264},
    { 1232, 56, 328},
    { 1064, 88, 216},
    { 1008, 32, 200},
    { 920, 24, 208},
    { 832, 32, 120},
    { 760, -16, 120},
    { 688, -16, 40},
    { 752, 0, -80},
    // 57 seconds
    { 936, 56, -144},
    { 1408, -144, 32},
    { 1560, -112, 168},
    { 1360, 288, -16},
    { 1320, 416, -168},
    { 1272, 320, 88},
    { 1120, 288, 264},
    { 1040, 264, 264},
    { 960, 176, 264},
    { 936, 288, 144},
    { 832, 328, 56},
    { 832, 440, -16},
    { 840, 488, 0},
    { 1032, 392, 48},
    { 1200, 392, 72},
    { 1520, 368, 160},
    { 1752, 408, 208},
    { 1200, 320, 160},
    { 1104, 136, 168},
    { 1480, -16, -56},
    { 1472, -120, 400},
    { 1232, 88, 192},
    { 1040, 80, 160},
    { 920, 72, 128},
    { 888, 8, 120},
    // 58 seconds
    { 792, -8, 72},
    { 680, -40, 40},
    { 624, -64, -40},
    { 792, 64, -144},
    { 1016, 24, -120},
    { 1504, -168, 64},
    { 1648, -32, 168},
    { 1392, 288, 8},
    { 1336, 256, 32},
    { 1288, 264, 248},
    { 1088, 336, 304},
    { 984, 288, 296},
    { 936, 280, 224},
    { 856, 272, 160},
    { 816, 328, 56},
    { 832, 424, -32},
    { 856, 440, -8},
    { 1064, 408, 40},
    { 1240, 352, 120},
    { 1696, 296, 176},
    { 1632, 320, 152},
    { 1144, 296, 88},
    { 1184, 160, 160},
    { 1400, 200, -40},
    { 1344, -624, 376},
    // 59 seconds
    { 1080, 96, 152},
    { 984, 40, 184},
    { 888, 48, 120},
    { 816, 0, 128},
    { 704, -8, 64},
    { 600, -64, 48},
    { 592, -72, 0},
    { 920, 152, -192},
    { 1312, -80, 8},
    { 1728, -168, 336},
    { 1440, 240, 136},
    { 1320, 400, -104},
    { 1200, 144, 40},
    { 1000, 216, 328},
    { 888, 256, 216},
    { 936, 136, 288},
    { 920, 176, 264},
    { 856, 272, 160},
    { 824, 320, 64},
    { 936, 504, -64},
    { 1032, 504, -80},
    { 1200, 440, -24},
    { 1416, 240, 168},
    { 1640, 240, 280},
    { 1352, 336, 208},
    // 60 seconds
    // elapsed: 1 minutes
    { 848, 176, 152},
    { 1080, 64, 192},
    { 1328, 64, 272},
    { 1240, 64, 320},
    { 1080, 72, 216},
    { 984, 24, 176},
    { 912, 24, 152},
    { 856, 24, 96},
    { 768, -24, 80},
    { 664, -64, 48},
    { 744, 0, -80},
    { 928, 128, -240},
    { 1336, -136, 0},
    { 1560, -168, 216},
    { 1424, 248, 40},
    { 1312, 440, -128},
    { 1248, 288, 88},
    { 1104, 232, 280},
    { 1000, 176, 320},
    { 952, 168, 272},
    { 856, 280, 168},
    { 816, 280, 96},
    { 824, 336, 8},
    { 832, 376, 0},
    { 960, 416, -24},
    // 61 seconds
    { 1224, 432, -32},
    { 1648, 328, 72},
    { 1752, 320, 104},
    { 1136, 264, 152},
    { 1176, 128, 144},
    { 1432, 56, 176},
    { 1328, 120, 424},
    { 976, 8, 360},
    { 1000, 112, 128},
    { 976, 16, 200},
    { 944, 40, 128},
    { 816, -40, 160},
    { 648, -96, 152},
    { 616, -192, 96},
    { 800, 168, -192},
    { 1296, 176, -208},
    { 1344, -152, 144},
    { 1264, 8, 128},
    { 1336, 248, -112},
    { 1392, 360, -24},
    { 1160, 288, 176},
    { 1040, 296, 208},
    { 992, 232, 272},
    { 960, 248, 256},
    { 920, 240, 200},
    // 62 seconds
    { 936, 280, 120},
    { 864, 368, 0},
    { 928, 432, -8},
    { 1152, 480, -8},
    { 1480, 472, 32},
    { 1600, 600, 80},
    { 1344, 416, 96},
    { 1016, 200, 120},
    { 1216, 152, 120},
    { 1184, 168, 48},
    { 1104, 16, 440},
    { 1112, 184, 184},
    { 1008, 72, 200},
    { 888, 0, 232},
    { 800, 16, 144},
    { 712, 16, 72},
    { 680, -32, 40},
    { 760, -8, -56},
    { 976, 32, -104},
    { 1424, -80, 80},
    { 1408, -24, 168},
    { 1072, 264, -16},
    { 1200, 176, -40},
    { 1312, 168, 136},
    { 1216, 248, 240},
    // 63 seconds
    { 1112, 336, 152},
    { 1024, 344, 144},
    { 920, 336, 72},
    { 896, 304, 0},
    { 928, 328, -8},
    { 968, 440, -112},
    { 976, 360, -96},
    { 1200, 336, -16},
    { 1584, 328, 120},
    { 1712, 456, 192},
    { 1016, 360, 224},
    { 1048, 120, 168},
    { 1400, 64, 248},
    { 1424, 64, 328},
    { 1264, 128, 216},
    { 1144, 56, 144},
    { 1016, 48, 112},
    { 888, 24, 112},
    { 784, -24, 64},
    { 656, -192, 0},
    { 640, -128, -104},
    { 848, 48, -208},
    { 984, -32, -120},
    { 1424, -216, 208},
    { 1640, 24, 288},
    // 64 seconds
    { 1640, 336, 120},
    { 1448, 384, 40},
    { 1200, 296, 200},
    { 1088, 264, 320},
    { 984, 256, 320},
    { 936, 184, 256},
    { 928, 336, 80},
    { 864, 496, -88},
    { 920, 560, 8},
    { 1136, 552, 136},
    { 1136, 472, 272},
    { 1640, 360, 376},
    { 1664, 152, 560},
    { 952, 328, 400},
    { 1272, 512, 216},
    { 1664, 360, 216},
    { 1496, 280, 312},
    { 1296, 32, 312},
    { 1152, -32, 280},
    { 1016, -64, 248},
    { 896, -24, 168},
    { 760, -8, 64},
    { 664, -120, 24},
    { 632, -72, -64},
    { 736, 16, -168},
    // 65 seconds
    { 1248, -128, 152},
    { 1384, 112, 416},
    { 1288, 520, 232},
    { 1328, 456, 64},
    { 1376, 408, 240},
    { 1320, 272, 216},
    { 1088, 280, 328},
    { 1016, 344, 296},
    { 1000, 408, 264},
    { 912, 376, 176},
    { 880, 392, 128},
    { 880, 464, 96},
    { 1024, 472, 88},
    { 1208, 544, 120},
    { 1696, 584, 248},
    { 1664, 592, 280},
    { 1048, 272, 200},
    { 1224, 240, 128},
    { 1608, 248, -104},
    { 1384, 64, 392},
    { 1240, 96, 152},
    { 1096, -16, 240},
    { 920, 8, 192},
    { 824, -16, 176},
    { 720, 0, 88},
    // 66 seconds
    { 664, -48, 56},
    { 632, -40, -24},
    { 776, 88, -176},
    { 1056, -48, -80},
    { 1464, -184, 208},
    { 1456, 176, 168},
    { 1512, 416, 32},
    { 1472, 488, 104},
    { 1160, 424, 256},
    { 1024, 288, 304},
    { 944, 200, 288},
    { 936, 280, 208},
    { 912, 320, 168},
    { 912, 432, 80},
    { 832, 456, 32},
    { 840, 424, -16},
    { 952, 352, -16},
    { 1112, 336, 24},
    { 1320, 200, 144},
    { 1688, 328, 96},
    { 1328, 248, 152},
    { 1304, 256, 176},
    { 1504, 288, 376},
    { 1544, 152, 448},
    { 1640, 280, 584},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

