/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */



// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:44:34 local
AccelRawData *activity_sample_walk_200_pbl_25479_7(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25479_7
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -280, -8, -1040},
    { -352, -32, -1072},
    { -280, -272, -992},
    { -312, -296, -1016},
    { -304, -448, -936},
    { -248, -424, -944},
    { -192, -488, -912},
    { -120, -496, -872},
    { -128, -464, -848},
    { -128, -472, -832},
    { -104, -496, -840},
    { -80, -528, -824},
    { -72, -504, -848},
    { -80, -440, -832},
    { -104, -592, -824},
    { -120, -584, -856},
    { -56, -560, -880},
    { -304, -416, -824},
    { 88, -528, -1168},
    { -328, -512, -792},
    { -176, -448, -944},
    { -72, -448, -936},
    { -200, -464, -912},
    { -88, -472, -952},
    { -88, -448, -952},
    // 1 seconds
    { 0, -296, -936},
    { 32, -128, -800},
    { 128, 40, -632},
    { 144, 520, -520},
    { 72, 888, -448},
    { 112, 880, -400},
    { 72, 912, -288},
    { 112, 928, -216},
    { 144, 864, -216},
    { 120, 736, -184},
    { 96, 928, -104},
    { 72, 872, -136},
    { 40, 984, -56},
    { 88, 1056, 40},
    { 96, 944, 32},
    { 136, 952, 24},
    { 160, 856, 72},
    { 120, 728, 0},
    { 64, 728, 40},
    { -8, 880, 96},
    { -24, 1016, -48},
    { 0, 736, 32},
    { -80, 888, -56},
    { -128, 760, -8},
    { -200, 720, -128},
    // 2 seconds
    { -264, 552, -128},
    { -360, 400, -216},
    { -544, 232, -248},
    { -832, 88, -208},
    { -1488, 32, -120},
    { -1864, 504, -208},
    { -1744, 552, -48},
    { -1424, 808, -264},
    { -1288, 288, -8},
    { -1176, 280, -176},
    { -1016, 168, -272},
    { -936, 232, -184},
    { -1048, 456, -144},
    { -1152, 448, -176},
    { -1272, 800, -208},
    { -1224, 496, -152},
    { -1112, 448, -160},
    { -1112, 488, -128},
    { -1424, 344, -56},
    { -1584, 408, 48},
    { -1392, 352, 176},
    { -1240, 256, 88},
    { -1120, 256, 88},
    { -976, 136, 128},
    { -808, 80, 48},
    // 3 seconds
    { -720, 72, 24},
    { -624, 16, 48},
    { -600, -56, 32},
    { -648, 8, -104},
    { -960, 128, -104},
    { -1272, 80, -128},
    { -1528, 56, -376},
    { -1680, -232, -552},
    { -1688, -128, -440},
    { -1368, 520, -320},
    { -1224, 72, -120},
    { -1152, 344, -48},
    { -960, 264, -56},
    { -736, 176, -64},
    { -640, 136, -48},
    { -616, 112, -128},
    { -664, 136, -72},
    { -880, 248, -160},
    { -1128, 296, -144},
    { -1256, 448, -120},
    { -1520, 328, -240},
    { -1480, 16, -432},
    { -1256, 72, -392},
    { -1216, 176, -400},
    { -1264, 248, -264},
    // 4 seconds
    { -1400, 192, -136},
    { -1328, 128, -72},
    { -1160, 120, -24},
    { -1016, 88, -32},
    { -888, 48, -24},
    { -800, 64, -32},
    { -648, 104, 0},
    { -728, 128, -16},
    { -800, 128, -40},
    { -776, 72, -80},
    { -1016, 96, -96},
    { -1232, 48, -256},
    { -1488, 64, -488},
    { -1568, -176, -520},
    { -1536, -192, -592},
    { -1440, -24, -296},
    { -1112, 120, -128},
    { -920, 216, -120},
    { -840, 168, -56},
    { -768, 144, 0},
    { -672, 184, -24},
    { -584, 256, -96},
    { -624, 240, -96},
    { -1168, 392, -264},
    { -1296, 336, -144},
    // 5 seconds
    { -1680, 704, -280},
    { -1328, -16, -368},
    { -1088, 368, -592},
    { -1312, 328, -360},
    { -1544, 304, -328},
    { -1464, 192, -240},
    { -1184, 80, -136},
    { -1032, 96, -104},
    { -1032, 112, -40},
    { -952, 152, -8},
    { -896, 104, -16},
    { -856, 120, 24},
    { -936, 184, 8},
    { -800, -8, 32},
    { -1000, -8, -72},
    { -1128, 24, -328},
    { -1344, 72, -480},
    { -1568, -160, -328},
    { -1584, -144, -112},
    { -1392, 88, -192},
    { -1168, 168, -72},
    { -1024, 280, 48},
    { -952, 264, 24},
    { -872, 232, -24},
    { -872, 360, 24},
    // 6 seconds
    { -952, 416, 48},
    { -1264, 520, 0},
    { -1232, 736, -96},
    { -1384, 352, -240},
    { -1144, 88, -280},
    { -1120, 440, -408},
    { -1368, 616, -280},
    { -1680, 544, -184},
    { -1616, 288, -104},
    { -1456, 136, -24},
    { -1304, 72, 24},
    { -1248, 144, 0},
    { -1120, 168, -16},
    { -1048, 208, 8},
    { -1056, 192, 0},
    { -1008, 32, 64},
    { -848, -264, 0},
    { -1024, -160, -184},
    { -1240, -32, -240},
    { -1448, 32, -432},
    { -1504, -168, -280},
    { -1712, -160, -32},
    { -1584, 224, -176},
    { -1408, 336, 32},
    { -1240, 288, -128},
    // 7 seconds
    { -1264, 288, -8},
    { -1240, 512, -32},
    { -1224, 512, 152},
    { -1200, 624, 152},
    { -1032, 728, 104},
    { -944, 856, -88},
    { -944, 896, -80},
    { -840, 672, -256},
    { -1160, 816, -200},
    { -1568, 784, -96},
    { -2000, 576, -16},
    { -1920, 352, -32},
    { -1744, 456, 88},
    { -1712, 408, 144},
    { -1560, 336, 128},
    { -1320, 296, 128},
    { -1000, 192, 112},
    { -944, 160, 224},
    { -680, -464, 56},
    { -192, -672, -128},
    { -1016, -152, 40},
    { -1240, 80, -360},
    { -1448, 232, -568},
    { -1632, 264, -496},
    { -1704, 104, -224},
    // 8 seconds
    { -1672, 272, -296},
    { -1432, 304, -352},
    { -1432, 336, -248},
    { -1368, 408, -352},
    { -1312, 392, -296},
    { -1120, 512, -304},
    { -1040, 720, -416},
    { -1152, 1000, -504},
    { -808, 632, -424},
    { -1296, 312, -256},
    { -1232, 336, -472},
    { -1280, 368, -392},
    { -1432, 336, -360},
    { -1800, 376, -264},
    { -1992, 384, -264},
    { -1760, 304, -168},
    { -1576, 240, -104},
    { -1376, 208, -80},
    { -1200, 184, -64},
    { -1024, 48, -40},
    { -784, -248, 80},
    { -688, -40, -200},
    { -744, -224, -104},
    { -984, -368, -56},
    { -1392, -56, -336},
    // 9 seconds
    { -1408, -32, -504},
    { -1520, -144, -112},
    { -1520, 8, -72},
    { -1464, 208, -16},
    { -1352, 392, -120},
    { -1176, 552, -144},
    { -1152, 304, -144},
    { -1184, 312, -80},
    { -1168, 144, -224},
    { -1352, 352, -584},
    { -1152, 888, -680},
    { -1536, 432, -400},
    { -1408, 104, -424},
    { -1296, 168, -296},
    { -1536, 56, -88},
    { -1632, 32, -16},
    { -1696, 96, 80},
    { -1440, 24, -8},
    { -2232, -176, -136},
    { -1328, -96, 80},
    { -1224, 200, 96},
    { -968, -264, 152},
    { -672, -424, 304},
    { -712, -144, -72},
    { -688, -304, 112},
    // 10 seconds
    { -1144, -224, -8},
    { -1424, -144, -240},
    { -1592, -256, -232},
    { -1648, -256, -216},
    { -1552, -72, -152},
    { -1400, 40, -144},
    { -1216, 200, -144},
    { -1048, 152, 8},
    { -1024, 264, 24},
    { -992, 288, -40},
    { -1000, 352, -80},
    { -1232, 496, -232},
    { -1288, 832, -136},
    { -1456, 560, -104},
    { -1408, 392, -400},
    { -1128, 384, -216},
    { -1312, 488, -176},
    { -1528, 312, -176},
    { -1648, 240, -112},
    { -1648, 224, -40},
    { -1528, 224, -8},
    { -1392, 152, 16},
    { -1224, 144, 24},
    { -1056, 152, 16},
    { -1024, 120, 0},
    // 11 seconds
    { -896, -352, 224},
    { -720, -400, 80},
    { -984, -264, 8},
    { -1464, 112, 8},
    { -1616, 136, -384},
    { -1728, 96, -168},
    { -1704, -24, -96},
    { -1568, 88, -136},
    { -1424, 304, -112},
    { -1288, 344, -96},
    { -1288, 352, -72},
    { -1256, 352, -24},
    { -1160, 368, 16},
    { -1128, 384, 48},
    { -1160, 552, 104},
    { -1096, 576, 80},
    { -1048, 728, -160},
    { -992, 488, -176},
    { -1216, 608, -208},
    { -1560, 568, -120},
    { -1872, 448, -80},
    { -1800, -56, -112},
    { -1672, 144, -168},
    { -1648, 136, -64},
    { -1528, 192, -64},
    // 12 seconds
    { -1400, 224, 16},
    { -1224, 112, 24},
    { -1112, 72, 56},
    { -840, -352, 304},
    { -664, -336, 56},
    { -1008, -48, -64},
    { -1328, 32, -152},
    { -1536, 80, -416},
    { -1432, -48, -240},
    { -1408, -112, -264},
    { -1416, 104, -312},
    { -1392, 192, -168},
    { -1320, 280, -32},
    { -1344, 408, -120},
    { -1424, 424, -72},
    { -1272, 560, -72},
    { -1160, 696, -168},
    { -1072, 560, -232},
    { -1176, 616, -416},
    { -1176, 840, -472},
    { -1072, 616, -424},
    { -1400, 560, -424},
    { -1768, 496, -256},
    { -2024, 488, -96},
    { -1832, 384, -48},
    // 13 seconds
    { -1816, 488, -24},
    { -1648, 320, 24},
    { -1384, 176, 80},
    { -1144, 192, 40},
    { -960, 72, 0},
    { -848, -64, 0},
    { -576, -368, -112},
    { -328, -680, -320},
    { -1016, -32, -312},
    { -1616, 296, -384},
    { -1872, 128, -528},
    { -1824, 144, -224},
    { -1704, 320, -280},
    { -1512, 256, -184},
    { -1632, 488, 32},
    { -1376, 416, 136},
    { -1248, 504, 48},
    { -1344, 560, 136},
    { -1120, 704, 32},
    { -1000, 880, -104},
    { -904, 832, -88},
    { -1144, 864, -72},
    { -1208, 824, -56},
    { -1256, 440, 32},
    { -1536, 440, 104},
    // 14 seconds
    { -1744, 312, 120},
    { -1720, 336, 64},
    { -1632, 280, 80},
    { -1560, 280, 128},
    { -1464, 248, 144},
    { -1296, 208, 144},
    { -1144, 152, 152},
    { -1072, 136, 112},
    { -928, -208, 192},
    { -712, -448, -40},
    { -1096, -176, 16},
    { -1320, 176, -272},
    { -1528, 192, -176},
    { -1496, -16, -128},
    { -1616, -40, -72},
    { -1560, 208, -112},
    { -1424, 312, 32},
    { -1304, 392, 16},
    { -1216, 432, -120},
    { -1224, 520, -152},
    { -1224, 536, 40},
    { -1120, 896, -104},
    { -1104, 560, 8},
    { -1360, 656, -32},
    { -1296, 824, -112},
    // 15 seconds
    { -1072, 728, -88},
    { -1312, 536, -120},
    { -1696, 400, -16},
    { -1904, 312, -64},
    { -1840, 192, -112},
    { -1688, 264, -24},
    { -1584, 280, 72},
    { -1432, 240, 56},
    { -1208, 168, 8},
    { -1088, 80, 32},
    { -736, -432, 144},
    { -368, -576, -104},
    { -776, -232, -144},
    { -1168, -64, 0},
    { -1552, 192, -376},
    { -1696, 160, -304},
    { -1800, -64, -80},
    { -1872, 32, -144},
    { -1688, 224, -280},
    { -1560, 288, 72},
    { -1512, 368, 120},
    { -1408, 336, 104},
    { -1232, 336, 72},
    { -1168, 456, 56},
    { -1104, 808, -32},
    // 16 seconds
    { -848, 688, -88},
    { -1216, 704, -176},
    { -1240, 496, -72},
    { -1176, 296, -72},
    { -1488, 368, -16},
    { -1880, 288, 120},
    { -1896, 120, 88},
    { -1896, 128, 48},
    { -1912, 168, 104},
    { -1816, 184, 136},
    { -1536, 200, 104},
    { -1280, 192, 48},
    { -1128, 24, 120},
    { -696, -520, 240},
    { -384, -480, -264},
    { -792, -312, -64},
    { -1216, 48, -16},
    { -1464, 112, -312},
    { -1584, 64, -128},
    { -1704, -120, -16},
    { -1720, 24, -112},
    { -1688, 224, 128},
    { -1624, 352, 200},
    { -1616, 544, 104},
    { -1584, 568, -16},
    // 17 seconds
    { -1328, 712, -144},
    { -1048, 1064, -336},
    { -976, 400, -344},
    { -1160, 472, -208},
    { -1136, 648, -264},
    { -1120, 480, -144},
    { -1344, 432, 8},
    { -1552, 416, 32},
    { -1832, 344, 104},
    { -1736, 216, 56},
    { -1544, 152, 16},
    { -1520, 112, -80},
    { -1464, 216, 88},
    { -1288, 112, 48},
    { -1136, 80, 48},
    { -1000, -232, 192},
    { -624, -480, -8},
    { -888, -248, -96},
    { -1288, -56, -112},
    { -1552, 152, -272},
    { -1600, -16, -184},
    { -1616, -120, -136},
    { -1656, 112, -136},
    { -1552, 232, -128},
    { -1336, 312, 112},
    // 18 seconds
    { -1216, 408, 0},
    { -1216, 304, 88},
    { -1264, 352, 120},
    { -1096, 320, 80},
    { -1272, 456, 168},
    { -1000, 1248, 208},
    { -872, 968, -208},
    { -1024, 912, -40},
    { -968, 688, -192},
    { -1472, 648, -176},
    { -1952, 512, -24},
    { -2200, 368, 0},
    { -2008, 232, -8},
    { -1760, 200, 48},
    { -1528, 232, 56},
    { -1368, 176, 72},
    { -1168, 176, 56},
    { -1032, 152, 104},
    { -1056, -208, 128},
    { -480, -848, 64},
    { -776, -584, -128},
    { -1168, -72, -312},
    { -1560, 176, -384},
    { -1792, 216, -352},
    { -1848, 96, 8},
    // 19 seconds
    { -1792, 296, -160},
    { -1640, 320, -96},
    { -1536, 312, 80},
    { -1432, 328, -48},
    { -1488, 296, 24},
    { -1456, 360, 144},
    { -1216, 352, 112},
    { -1272, 560, 272},
    { -896, 1160, 136},
    { -936, 704, 112},
    { -896, 840, 144},
    { -984, 664, 32},
    { -1536, 584, 192},
    { -1720, 536, 168},
    { -1928, 464, 200},
    { -1864, 384, 256},
    { -1784, 288, 248},
    { -1760, 224, 240},
    { -1600, 184, 216},
    { -1368, 120, 200},
    { -1296, 136, 176},
    { -1160, -176, 304},
    { -672, -904, 32},
    { -1064, -368, -16},
    { -1160, -64, -288},
    // 20 seconds
    { -1600, 88, -176},
    { -1632, -64, -72},
    { -1808, 8, 48},
    { -1800, 240, 72},
    { -1744, 432, 192},
    { -1600, 560, 208},
    { -1504, 656, 200},
    { -1384, 288, 144},
    { -1152, 352, 88},
    { -1136, 520, 152},
    { -992, 704, 208},
    { -1064, 728, 184},
    { -848, 624, 16},
    { -944, 464, 40},
    { -1368, 672, 136},
    { -1664, 472, 144},
    { -1912, 512, 80},
    { -1824, 120, 24},
    { -1816, 144, 56},
    { -1832, 80, 64},
    { -1688, 88, 72},
    { -1504, 160, 128},
    { -1256, 8, 120},
    { -1032, -128, 72},
    { -688, -168, -160},
    // 21 seconds
    { -880, -312, -144},
    { -1000, -32, -360},
    { -1064, -104, -336},
    { -1376, -232, -64},
    { -1512, -88, -32},
    { -1528, 120, -64},
    { -1400, 176, -64},
    { -1416, 208, 64},
    { -1512, 336, 80},
    { -1528, 368, 24},
    { -1464, 376, 16},
    { -1480, 376, -32},
    { -1416, 560, -56},
    { -1112, 664, -96},
    { -1280, 784, -192},
    { -1016, 512, -160},
    { -1088, 472, -168},
    { -1280, 464, -80},
    { -1576, 328, 16},
    { -1528, 184, 0},
    { -1416, 144, -16},
    { -1504, 192, -24},
    { -1576, 136, 0},
    { -1584, 264, 104},
    { -1352, 32, 104},
    // 22 seconds
    { -1312, 80, 56},
    { -1072, -224, 152},
    { -672, -696, -80},
    { -784, -168, -376},
    { -1200, -128, -144},
    { -1560, 288, -168},
    { -1536, -96, -8},
    { -1608, 96, -72},
    { -1544, 280, -80},
    { -1408, 416, 112},
    { -1288, 416, 8},
    { -1296, 408, 0},
    { -1240, 408, 16},
    { -1112, 360, -16},
    { -1224, 512, 48},
    { -1048, 728, 160},
    { -1168, 672, 0},
    { -960, 504, -64},
    { -968, 552, -80},
    { -1224, 544, 48},
    { -1488, 456, 128},
    { -1552, 424, 48},
    { -1488, 304, 80},
    { -1448, 232, 88},
    { -1504, 208, 72},
    // 23 seconds
    { -1464, 200, 64},
    { -1312, 184, 104},
    { -1240, 152, 72},
    { -1208, -56, 64},
    { -960, -424, 40},
    { -904, -240, -128},
    { -1008, 32, -256},
    { -1248, 160, -296},
    { -1392, 88, -184},
    { -1520, 24, -48},
    { -1496, 160, -120},
    { -1472, 288, -24},
    { -1384, 384, -32},
    { -1288, 408, -64},
    { -1192, 360, -64},
    { -1120, 440, -64},
    { -1136, 504, -48},
    { -1072, 584, -48},
    { -968, 600, -112},
    { -1008, 688, -144},
    { -968, 528, -104},
    { -1336, 552, -112},
    { -1704, 456, 0},
    { -1760, 424, -48},
    { -1608, 336, -40},
    // 24 seconds
    { -1552, 288, -8},
    { -1504, 248, 40},
    { -1392, 200, 72},
    { -1208, 104, 64},
    { -1104, 240, 136},
    { -960, 176, 320},
    { -792, -8, 144},
    { -936, -104, 256},
    { -840, -448, -240},
    { -1160, 16, -168},
    { -1408, 352, -288},
    { -1688, 224, -112},
    { -1848, 376, -88},
    { -1672, 376, 64},
    { -1352, 544, -96},
    { -1192, 504, -96},
    { -1256, 392, -40},
    { -1200, 328, 16},
    { -1064, 328, 120},
    { -1064, 472, 160},
    { -1000, 712, 232},
    { -936, 536, 200},
    { -1176, 680, 208},
    { -968, 640, 128},
    { -1184, 608, 40},
    // 25 seconds
    { -1480, 584, 104},
    { -1632, 488, 72},
    { -1552, 344, 128},
    { -1512, 232, 152},
    { -1520, 184, 144},
    { -1464, 176, 120},
    { -1296, 152, 112},
    { -1120, 96, 104},
    { -1056, -32, 104},
    { -752, -400, 32},
    { -952, -184, 0},
    { -1152, 0, -136},
    { -1216, 184, -240},
    { -1344, 192, -216},
    { -1488, -16, -40},
    { -1584, 152, -176},
    { -1440, 224, -136},
    { -1288, 280, -24},
    { -1240, 304, -32},
    { -1256, 312, 0},
    { -1240, 392, 16},
    { -1040, 376, 24},
    { -1160, 528, 24},
    { -1088, 672, 88},
    { -1272, 520, -40},
    // 26 seconds
    { -1080, 544, -104},
    { -960, 448, -88},
    { -1336, 432, -48},
    { -1704, 344, -16},
    { -1728, 288, -56},
    { -1584, 176, 0},
    { -1512, 128, 72},
    { -1456, 120, 0},
    { -1264, 72, 0},
    { -1120, 72, 48},
    { -1104, 72, 80},
    { -968, -288, 184},
    { -688, -312, -104},
    { -1088, -232, -64},
    { -1272, 56, -208},
    { -1368, 128, -256},
    { -1440, 40, -208},
    { -1592, -8, -136},
    { -1544, 112, -168},
    { -1416, 232, -96},
    { -1296, 328, -56},
    { -1280, 416, -120},
    { -1264, 480, -120},
    { -1136, 464, -168},
    { -1080, 560, -200},
    // 27 seconds
    { -1032, 544, -160},
    { -1240, 520, -168},
    { -1280, 560, -152},
    { -1088, 336, -144},
    { -1344, 360, -96},
    { -1616, 304, -8},
    { -1752, 264, -16},
    { -1640, 216, 8},
    { -1496, 128, 48},
    { -1400, 88, 48},
    { -1272, 64, 40},
    { -1064, 56, 0},
    { -992, 32, -8},
    { -928, -448, 16},
    { -624, -216, -248},
    { -888, -248, -160},
    { -1264, 16, -240},
    { -1288, 80, -336},
    { -1472, -8, -272},
    { -1656, -88, -80},
    { -1656, 72, -72},
    { -1480, 200, 24},
    { -1280, 296, 56},
    { -1240, 360, 64},
    { -1280, 336, 96},
    // 28 seconds
    { -1208, 312, 56},
    { -1112, 288, 88},
    { -1168, 496, -32},
    { -1128, 824, -8},
    { -1200, 584, -184},
    { -1208, 560, -296},
    { -1160, 432, -384},
    { -1264, 416, -400},
    { -1560, 304, -200},
    { -1720, 224, -112},
    { -1680, 192, -72},
    { -1528, 88, 8},
    { -1496, 128, 24},
    { -1352, 88, 24},
    { -1176, 80, 48},
    { -1136, 64, 48},
    { -944, -296, 144},
    { -704, -432, -8},
    { -880, -192, -168},
    { -1192, 48, -304},
    { -1448, 104, -384},
    { -1480, -32, -272},
    { -1648, -120, -192},
    { -1640, 104, -224},
    { -1536, 280, -88},
    // 29 seconds
    { -1424, 336, 24},
    { -1384, 392, -48},
    { -1352, 416, 32},
    { -1216, 328, 40},
    { -1192, 528, 112},
    { -1000, 632, 56},
    { -1112, 720, 96},
    { -1128, 704, 0},
    { -992, 688, -104},
    { -1096, 704, -216},
    { -1400, 560, -168},
    { -1888, 584, -80},
    { -1968, 368, -48},
    { -1856, 168, 56},
    { -1728, 288, 240},
    { -1680, 528, 296},
    { -1520, 568, 144},
    { -1208, 344, 176},
    { -1136, 48, 400},
    { -680, -640, -248},
    { -464, -608, -192},
    { -728, -280, -128},
    { -1272, 128, -160},
    { -1768, 400, 0},
    { -1832, 776, -240},
    // 30 seconds
    { -1928, 400, 112},
    { -1856, 504, 8},
    { -1616, 440, 40},
    { -1440, 504, 48},
    { -1408, 408, 88},
    { -1392, 360, 96},
    { -1224, 400, 144},
    { -1072, 384, 232},
    { -1192, 616, 320},
    { -880, 872, 304},
    { -960, 648, 184},
    { -952, 736, 120},
    { -1040, 656, 112},
    { -1376, 664, 128},
    { -1784, 568, 176},
    { -2144, 464, 128},
    { -2128, 200, 144},
    { -1888, 96, 160},
    { -1824, 184, 96},
    { -1624, 120, 104},
    { -1312, 136, 120},
    { -1064, 120, 104},
    { -904, -96, 80},
    { -560, -216, -40},
    { -856, 96, 144},
    // 31 seconds
    { -736, 928, -104},
    { -408, 1560, -216},
    { -152, 1536, -200},
    { 88, 1544, -120},
    { 240, 1136, -64},
    { 368, 928, -56},
    { 288, 584, 72},
    { 248, 408, 96},
    { 272, 408, 48},
    { 344, 384, 48},
    { 424, 400, -16},
    { 368, 536, -8},
    { 528, 608, 16},
    { 656, 720, 48},
    { 776, 728, -56},
    { 904, 968, 16},
    { 752, 752, 184},
    { 528, 512, 40},
    { 336, 488, 0},
    { 32, 424, -184},
    { -48, 328, -160},
    { -320, 168, -96},
    { -456, 80, -256},
    { -720, 240, -88},
    { -1128, 192, -240},
    // 32 seconds
    { -1384, 88, -184},
    { -2432, -336, 216},
    { -2312, 328, -104},
    { -2480, 448, -128},
    { -2168, 688, -136},
    { -1232, 552, -192},
    { -904, 352, -128},
    { -1056, 120, 32},
    { -952, 200, 96},
    { -736, 304, 112},
    { -664, 424, 48},
    { -680, 448, 16},
    { -720, 448, -56},
    { -768, 520, -32},
    { -1136, 480, 8},
    { -1152, 336, 8},
    { -1632, 400, -104},
    { -1528, 352, -112},
    { -1536, 400, -72},
    { -1656, 296, -16},
    { -1960, 304, 48},
    { -1408, 80, 40},
    { -1072, 56, 96},
    { -944, 88, 72},
    { -888, 88, 72},
    // 33 seconds
    { -832, 88, 96},
    { -768, 64, 104},
    { -840, 0, 120},
    { -832, -232, 160},
    { -1072, -112, 72},
    { -1304, 200, -80},
    { -1584, 352, -152},
    { -1576, 464, -200},
    { -1536, 88, -128},
    { -1464, 104, -264},
    { -1368, 392, -416},
    { -1104, 440, 72},
    { -904, 376, -144},
    { -944, 384, -128},
    { -968, 248, -16},
    { -872, 304, 16},
    { -992, 312, 0},
    { -1192, 376, 72},
    { -1240, 656, 120},
    { -1240, 424, -136},
    { -1024, 512, -104},
    { -1408, 504, 8},
    { -1656, 304, 16},
    { -1712, 288, 8},
    { -1312, 176, 72},
    // 34 seconds
    { -1152, 136, 80},
    { -1152, 128, 80},
    { -1152, 136, 80},
    { -1128, 128, 88},
    { -1128, 112, 80},
    { -1112, 0, 72},
    { -888, -328, -32},
    { -992, -416, 56},
    { -1288, 296, -256},
    { -1336, 336, -432},
    { -1496, 496, -368},
    { -1568, 24, -56},
    { -1536, 56, -8},
    { -1304, 192, 16},
    { -1168, 368, 72},
    { -1064, 360, 80},
    { -976, 448, -88},
    { -904, 336, -112},
    { -1016, 568, -168},
    { -1080, 928, 8},
    { -1024, 520, -192},
    { -1296, 624, -144},
    { -1240, 760, -80},
    { -1344, 704, -208},
    { -1672, 632, -160},
    // 35 seconds
    { -1992, 296, 64},
    { -1856, 256, 32},
    { -1664, 320, 24},
    { -1456, 248, -24},
    { -1304, 240, 32},
    { -1096, 256, -32},
    { -880, 232, -80},
    { -784, 480, -568},
    { -448, -408, 184},
    { -248, -1256, -136},
    { -880, 192, -224},
    { -1344, -152, -88},
    { -1912, -16, -232},
    { -2336, 144, -120},
    { -2168, 336, -8},
    { -1704, 960, -112},
    { -1560, 224, 48},
    { -1584, 320, 176},
    { -1200, 312, 64},
    { -1120, 352, 120},
    { -1048, 392, 96},
    { -944, 336, 224},
    { -1008, 736, 184},
    { -880, 1016, 256},
    { -1168, 528, 56},
    // 36 seconds
    { -920, 536, -56},
    { -1104, 272, -8},
    { -1648, 368, -24},
    { -1856, 344, 32},
    { -2024, 272, 72},
    { -1856, 192, 104},
    { -1696, 136, 96},
    { -1568, 112, 168},
    { -1336, 80, 144},
    { -1136, 120, 128},
    { -1056, 56, 96},
    { -984, -112, 184},
    { -728, -384, 32},
    { -1008, -216, -72},
    { -1208, 80, -216},
    { -1352, 136, -208},
    { -1552, 104, -88},
    { -1664, -24, 56},
    { -1712, 144, 88},
    { -1632, 280, 136},
    { -1792, 464, 264},
    { -1392, 488, 152},
    { -1328, 424, 48},
    { -1224, 352, 56},
    { -1176, 360, 168},
    // 37 seconds
    { -1216, 648, 160},
    { -1016, 648, 176},
    { -1120, 512, 112},
    { -944, 512, 72},
    { -1096, 560, -16},
    { -1304, 552, 72},
    { -1528, 456, 96},
    { -1720, 328, 120},
    { -1672, 232, 152},
    { -1600, 176, 152},
    { -1544, 144, 160},
    { -1416, 120, 144},
    { -1272, 112, 160},
    { -1120, 96, 144},
    { -1024, -104, 80},
    { -752, -496, 0},
    { -1032, -128, -120},
    { -1120, 8, -176},
    { -1304, 80, -88},
    { -1544, 320, -144},
    { -1704, 192, 32},
    { -1704, 192, 8},
    { -1504, 352, 80},
    { -1360, 344, 128},
    { -1328, 400, 56},
    // 38 seconds
    { -1376, 320, 88},
    { -1192, 344, 144},
    { -936, 392, 40},
    { -1016, 472, 136},
    { -976, 800, 288},
    { -1264, 664, 88},
    { -1000, 432, 16},
    { -1136, 584, 24},
    { -1424, 512, 104},
    { -1728, 344, -8},
    { -1776, 248, -88},
    { -1680, 248, -48},
    { -1584, 192, -64},
    { -1520, 208, -40},
    { -1416, 240, 104},
    { -1200, 152, 96},
    { -984, 24, 48},
    { -736, -408, 112},
    { -712, -240, -32},
    { -928, -120, -16},
    { -1280, 136, 8},
    { -1488, 336, -320},
    { -1512, 448, -256},
    { -1552, 56, -32},
    { -1656, 112, -104},
    // 39 seconds
    { -1576, 312, -104},
    { -1424, 424, 32},
    { -1264, 400, 16},
    { -1168, 400, -32},
    { -1128, 416, -24},
    { -1048, 368, 40},
    { -1136, 520, 168},
    { -1024, 816, 288},
    { -1056, 312, 112},
    { -968, 568, 248},
    { -936, 512, 24},
    { -1272, 512, 0},
    { -1768, 448, 152},
    { -1904, 456, 128},
    { -1720, 320, 136},
    { -1656, 264, 184},
    { -1600, 216, 240},
    { -1512, 136, 264},
    { -1304, 112, 240},
    { -1096, 136, 56},
    { -840, -320, 80},
    { -768, -496, -8},
    { -776, -232, -216},
    { -1192, 8, -144},
    { -1384, 272, -304},
    // 40 seconds
    { -1696, 336, -160},
    { -1760, 0, 32},
    { -1752, -48, 64},
    { -1640, 176, 120},
    { -1496, 336, 168},
    { -1440, 392, 144},
    { -1360, 344, 80},
    { -1232, 328, 120},
    { -1120, 296, 216},
    { -1112, 544, 176},
    { -976, 888, 384},
    { -880, 528, 0},
    { -1064, 688, 136},
    { -1040, 760, 16},
    { -1400, 784, -24},
    { -1984, 528, 64},
    { -2168, 392, 80},
    { -1880, 232, 176},
    { -1928, 320, 184},
    { -1784, 256, 232},
    { -1640, 264, 200},
    { -1376, 208, 200},
    { -1136, 56, 200},
    { -976, 160, -80},
    { -32, -968, -720},
    // 41 seconds
    { -792, -384, -376},
    { -1272, -288, -304},
    { -1648, 264, -312},
    { -1784, 304, 0},
    { -1688, 184, 152},
    { -1688, 472, 0},
    { -1648, 272, 88},
    { -1640, 288, 152},
    { -1616, 328, 232},
    { -1624, 336, 296},
    { -1608, 400, 320},
    { -1336, 504, 320},
    { -1088, 696, 256},
    { -952, 736, 376},
    { -728, 488, 360},
    { -936, 784, 272},
    { -736, 744, 152},
    { -936, 640, 160},
    { -1432, 616, 256},
    { -2040, 552, 312},
    { -2168, 448, 360},
    { -2024, 256, 376},
    { -1944, 176, 336},
    { -1856, 168, 288},
    { -1616, 144, 264},
    // 42 seconds
    { -1304, 88, 224},
    { -1168, 24, 192},
    { -832, -560, 144},
    { -584, -360, -184},
    { -912, -440, -16},
    { -1304, 40, -96},
    { -1456, 336, -104},
    { -1488, 208, -104},
    { -1680, -56, 96},
    { -1832, 72, 64},
    { -1752, 312, 48},
    { -1552, 352, 264},
    { -1536, 488, 104},
    { -1512, 488, 104},
    { -1368, 432, 168},
    { -1152, 416, 176},
    { -1032, 504, 264},
    { -1008, 576, 328},
    { -1144, 752, 256},
    { -816, 488, 152},
    { -992, 544, 80},
    { -1272, 536, 216},
    { -1664, 464, 184},
    { -1784, 424, 248},
    { -1752, 184, 272},
    // 43 seconds
    { -1720, 136, 248},
    { -1672, 128, 200},
    { -1504, 104, 184},
    { -1336, 112, 184},
    { -1304, 56, 144},
    { -1000, -432, 176},
    { -808, -560, 184},
    { -1208, 64, -360},
    { -1288, 392, -296},
    { -1272, 480, -168},
    { -1456, -152, 248},
    { -1728, 128, 128},
    { -1656, 488, 48},
    { -1512, 464, 224},
    { -1408, 592, 72},
    { -1248, 456, 80},
    { -1272, 352, 136},
    { -1136, 384, 216},
    { -1216, 432, 216},
    { -1064, 592, 336},
    { -1096, 744, 264},
    { -896, 616, 88},
    { -848, 720, 24},
    { -1152, 728, 144},
    { -1568, 584, 280},
    // 44 seconds
    { -1912, 488, 256},
    { -1896, 304, 320},
    { -1800, 184, 320},
    { -1712, 112, 264},
    { -1608, 112, 232},
    { -1392, 104, 216},
    { -1232, 96, 192},
    { -1128, 56, 176},
    { -824, -384, 72},
    { -744, -544, -72},
    { -1072, 0, -120},
    { -1328, -88, -120},
    { -1568, 352, -152},
    { -1632, 320, -24},
    { -1760, 88, 96},
    { -1864, 296, -16},
    { -1840, 472, 40},
    { -1592, 536, 176},
    { -1384, 640, 56},
    { -1232, 432, 8},
    { -1104, 392, 176},
    { -1056, 496, 280},
    { -944, 504, 352},
    { -928, 608, 280},
    { -904, 656, 288},
    // 45 seconds
    { -944, 688, 120},
    { -1336, 640, 272},
    { -1784, 456, 240},
    { -2056, 392, 96},
    { -1984, 328, -40},
    { -1720, 8, 128},
    { -1648, 192, 104},
    { -1592, 232, 136},
    { -1352, 192, 136},
    { -1072, 96, 152},
    { -864, -120, 152},
    { -632, -376, -88},
    { -824, 0, -272},
    { -912, -312, 144},
    { -1216, 176, -16},
    { -1440, 392, -40},
    { -1680, 288, 48},
    { -2088, 384, 208},
    { -2192, 272, 344},
    { -1848, 408, 280},
    { -1400, 520, 24},
    { -1472, 312, 16},
    { -1440, 400, 248},
    { -1136, 408, 208},
    { -1040, 408, 160},
    // 46 seconds
    { -976, 464, 184},
    { -776, 728, 272},
    { -1064, 672, 232},
    { -936, 680, 168},
    { -1136, 616, 120},
    { -1688, 576, 200},
    { -2192, 512, 256},
    { -2296, 312, 376},
    { -2040, 216, 344},
    { -1944, 256, 296},
    { -1752, 288, 280},
    { -1568, 248, 256},
    { -1232, 192, 272},
    { -1008, 96, 272},
    { -1000, -240, 312},
    { -536, -624, -712},
    { -856, -464, -224},
    { -1112, -80, -128},
    { -1504, 336, -272},
    { -1624, 120, -56},
    { -1880, -48, 224},
    { -2008, 336, 72},
    { -1960, 480, 128},
    { -1752, 288, 424},
    { -1736, 528, 200},
    // 47 seconds
    { -1664, 520, 224},
    { -1416, 424, 192},
    { -1240, 408, 288},
    { -1136, 576, 432},
    { -792, 816, 416},
    { -768, 1104, 360},
    { -872, 568, 432},
    { -1040, 552, 352},
    { -1376, 544, 312},
    { -1840, 528, 424},
    { -2160, 456, 472},
    { -2184, 264, 544},
    { -2080, 152, 504},
    { -1912, 80, 432},
    { -1632, 96, 320},
    { -1320, 104, 312},
    { -1176, 168, 144},
    { -1160, -216, 192},
    { -856, -744, -16},
    { -880, -232, -224},
    { -1144, 152, -280},
    { -1528, 80, -48},
    { -1592, 176, 104},
    { -1712, -40, 168},
    { -1800, 240, 152},
    // 48 seconds
    { -1776, 456, 152},
    { -1704, 408, 120},
    { -1640, 560, 80},
    { -1624, 448, 80},
    { -1392, 432, 144},
    { -1368, 568, 176},
    { -1224, 976, 376},
    { -944, 584, 144},
    { -968, 832, 120},
    { -840, 688, 80},
    { -1016, 632, 40},
    { -1360, 560, 168},
    { -1880, 456, 168},
    { -1968, 344, 192},
    { -1904, 240, 232},
    { -1816, 240, 184},
    { -1704, 192, 192},
    { -1488, 128, 208},
    { -1256, 16, 216},
    { -1144, -384, 128},
    { -816, -848, -64},
    { -1112, -40, 0},
    { -1224, -312, -80},
    { -1480, 208, -272},
    { -1608, -32, 88},
    // 49 seconds
    { -1496, -200, 40},
    { -1624, 48, -32},
    { -1576, 296, -32},
    { -1440, 408, 48},
    { -1352, 520, 40},
    { -1408, 456, 120},
    { -1392, 552, 200},
    { -1264, 576, 392},
    { -1096, 432, 384},
    { -928, 584, 368},
    { -1200, 688, 448},
    { -888, 624, 280},
    { -944, 432, 232},
    { -1320, 456, 272},
    { -1648, 456, 248},
    { -1664, 416, 232},
    { -1632, 328, 280},
    { -1656, 256, 288},
    { -1616, 192, 264},
    { -1480, 152, 208},
    { -1240, 40, 144},
    { -1056, -144, 24},
    { -992, -384, -24},
    { -776, -256, -120},
    { -1208, -232, -56},
    // 50 seconds
    { -1408, 304, -384},
    { -1520, 384, -280},
    { -1488, 136, -56},
    { -1488, -8, -16},
    { -1464, 248, -40},
    { -1320, 352, 80},
    { -1192, 344, 160},
    { -1208, 368, 96},
    { -1296, 352, 120},
    { -1240, 352, 216},
    { -1184, 360, 296},
    { -1160, 616, 440},
    { -1000, 440, 296},
    { -1016, 704, 104},
    { -928, 696, -48},
    { -1112, 616, -88},
    { -1392, 632, -40},
    { -1600, 512, -16},
    { -1536, 448, -16},
    { -1536, 392, 40},
    { -1560, 264, 104},
    { -1536, 232, 112},
    { -1360, 176, 136},
    { -1160, 128, 112},
    { -1224, 24, 64},
    // 51 seconds
    { -1072, -400, 64},
    { -1024, -416, 8},
    { -1232, -104, -48},
    { -1320, 200, -240},
    { -1472, 488, -312},
    { -1488, 288, -88},
    { -1600, 104, -40},
    { -1536, 336, -136},
    { -1472, 336, -112},
    { -1328, 664, -152},
    { -1200, 608, -112},
    { -1144, 464, -88},
    { -1072, 384, 80},
    { -1032, 480, -16},
    { -912, 416, 120},
    { -1160, 552, 96},
    { -1176, 584, 48},
    { -1168, 472, 96},
    { -1496, 496, -8},
    { -1808, 456, 56},
    { -1840, 392, 24},
    { -1656, 408, 64},
    { -1632, 344, 104},
    { -1440, 136, 80},
    { -1320, 184, 200},
    // 52 seconds
    { -1152, 88, 152},
    { -968, 144, 216},
    { -896, 16, 120},
    { -808, -224, 152},
    { -656, -424, -48},
    { -968, -208, -280},
    { -1576, 200, -8},
    { -1832, 656, -288},
    { -1968, 568, -144},
    { -2024, 32, 328},
    { -1648, 552, 80},
    { -1344, 560, 56},
    { -1304, 408, 72},
    { -1216, 296, 136},
    { -1136, 280, 160},
    { -1000, 344, 184},
    { -904, 256, 312},
    { -880, 528, 416},
    { -816, 464, 312},
    { -928, 416, 328},
    { -1040, 584, 256},
    { -1136, 560, 96},
    { -1544, 608, 8},
    { -1824, 696, -8},
    { -1880, 584, -8},
    // 53 seconds
    { -1752, 448, 112},
    { -1680, 224, 184},
    { -1520, 144, 160},
    { -1336, 136, 120},
    { -1080, 104, 104},
    { -912, 72, 120},
    { -824, -80, 128},
    { -704, -192, 128},
    { -792, -96, 48},
    { -1144, 96, 40},
    { -1320, 368, -136},
    { -1432, 600, -360},
    { -1616, 112, -80},
    { -1728, -112, 128},
    { -1584, 360, 56},
    { -1360, 520, 424},
    { -1184, 672, 136},
    { -1232, 448, 120},
    { -1160, 344, 200},
    { -1072, 368, 232},
    { -1112, 440, 296},
    { -1048, 624, 392},
    { -1264, 416, 504},
    { -1112, 424, 392},
    { -872, 456, 328},
    // 54 seconds
    { -1168, 552, 336},
    { -1456, 480, 272},
    { -1672, 392, 256},
    { -1624, 272, 232},
    { -1560, 208, 264},
    { -1512, 184, 248},
    { -1256, 144, 168},
    { -1128, 136, 336},
    { -952, 176, 192},
    { -888, 0, 176},
    { -768, -272, 144},
    { -968, -48, 8},
    { -1168, 96, 72},
    { -1296, 496, -200},
    { -1352, 488, -144},
    { -1560, -16, 200},
    { -1656, 80, 168},
    { -1472, 456, 136},
    { -1128, 472, 208},
    { -1064, 488, 152},
    { -1168, 352, 128},
    { -1120, 256, 184},
    { -944, 248, 192},
    { -1008, 288, 248},
    { -1120, 360, 400},
    // 55 seconds
    { -1192, 960, 568},
    { -1032, 320, -40},
    { -880, 392, -56},
    { -1240, 592, 96},
    { -1648, 584, 224},
    { -1664, 400, 24},
    { -1456, 376, -96},
    { -1240, -72, 192},
    { -1384, 128, 160},
    { -1272, 128, 136},
    { -1152, 136, 120},
    { -1072, 136, 104},
    { -1064, 88, 160},
    { -904, -256, 200},
    { -904, -152, 120},
    { -1136, 160, -64},
    { -1256, 416, -200},
    { -1440, 560, -240},
    { -1528, 136, -24},
    { -1456, -56, 16},
    { -1288, 232, 32},
    { -1056, 416, 128},
    { -984, 480, -24},
    { -1080, 304, 72},
    { -1160, 208, 152},
    // 56 seconds
    { -1032, 208, 184},
    { -1144, 304, 224},
    { -1104, 424, 336},
    { -1168, 976, 224},
    { -1040, 392, -24},
    { -912, 600, -72},
    { -1280, 504, -32},
    { -1672, 328, -24},
    { -1720, 384, -112},
    { -1448, 320, -352},
    { -1224, -272, 264},
    { -1312, 240, 104},
    { -1216, 224, 24},
    { -1064, 184, 56},
    { -976, 136, 96},
    { -1016, -8, 176},
    { -872, -112, 168},
    { -960, -64, 56},
    { -1056, 88, -48},
    { -1080, 320, -184},
    { -1344, 200, -144},
    { -1536, 144, -144},
    { -1592, 72, -120},
    { -1472, 208, -224},
    { -1384, 520, -120},
    // 57 seconds
    { -1112, 456, 96},
    { -1024, 696, -96},
    { -1048, 392, -32},
    { -1008, 408, 40},
    { -1096, 360, 80},
    { -1064, 528, 184},
    { -1304, 504, 88},
    { -1264, 504, 104},
    { -1160, 488, 0},
    { -1312, 520, -104},
    { -1576, 400, -16},
    { -1712, 184, 32},
    { -1544, 312, 152},
    { -1352, 184, 48},
    { -1304, 440, 184},
    { -1184, 280, 112},
    { -1064, 296, 208},
    { -872, 72, 208},
    { -832, 40, 240},
    { -784, -32, 200},
    { -568, -344, -120},
    { -1000, 80, -96},
    { -1336, 496, -40},
    { -1552, 720, -248},
    { -1752, 512, -112},
    // 58 seconds
    { -1736, 200, 160},
    { -1424, 536, -56},
    { -1216, 384, 32},
    { -1216, 288, 120},
    { -1256, 192, 144},
    { -1152, 288, 72},
    { -1080, 288, 224},
    { -952, 424, 312},
    { -920, 720, 496},
    { -832, 608, 328},
    { -1000, 512, 192},
    { -1152, 632, 256},
    { -1216, 608, 256},
    { -1456, 640, 224},
    { -1704, 664, 16},
    { -1960, 664, 64},
    { -1960, 616, 256},
    { -1656, 536, 296},
    { -1224, 448, 240},
    { -880, 312, 272},
    { -664, 320, 240},
    { -512, 368, 176},
    { -360, 384, 176},
    { -232, 512, 168},
    { -56, 712, 128},
    // 59 seconds
    { 72, 872, 264},
    { 264, 1200, 176},
    { 352, 1272, 32},
    { 240, 1088, 56},
    { 152, 968, 16},
    { 144, 704, 64},
    { 200, 488, 64},
    { 184, 360, 32},
    { 200, 192, 128},
    { 232, 288, -32},
    { 200, 448, 80},
    { 256, 504, 208},
    { 256, 888, 344},
    { 248, 1456, 440},
    { 328, 1472, 656},
    { 328, 1520, 624},
    { 280, 1144, 416},
    { 248, 856, 432},
    { 272, 824, 544},
    { 224, 928, 576},
    { 120, 808, 496},
    { 80, 624, 288},
    { 64, 456, 184},
    { 56, 280, 144},
    { 40, 192, 80},
    // 60 seconds
    // elapsed: 1 minutes
    { -8, 152, 56},
    { -120, 136, 0},
    { -480, 224, 40},
    { -1312, 424, 272},
    { -1952, 704, 504},
    { -2632, 888, 0},
    { -2144, 952, -272},
    { -1272, 360, 120},
    { -1088, 8, 88},
    { -1064, 264, 104},
    { -896, 224, 56},
    { -696, 168, 136},
    { -576, 136, 144},
    { -576, 176, 128},
    { -600, 248, 112},
    { -872, 328, 72},
    { -1344, 480, 72},
    { -1416, 688, 400},
    { -1280, -40, 224},
    { -1400, 592, -80},
    { -1272, 808, -448},
    { -1312, 544, -304},
    { -1368, 440, -264},
    { -1120, 288, -16},
    { -1064, 224, 200},
    // 61 seconds
    { -1048, 136, 184},
    { -968, 104, 144},
    { -856, 64, 128},
    { -848, 48, 112},
    { -904, 8, 96},
    { -872, -96, 288},
    { -1016, -16, 208},
    { -1448, 168, 88},
    { -1328, 408, -256},
    { -1288, 464, -200},
    { -1456, 112, -144},
    { -1400, 112, -136},
    { -1104, 272, -72},
    { -960, 384, -48},
    { -896, 312, -24},
    { -944, 304, 8},
    { -936, 224, 88},
    { -872, 224, 160},
    { -928, 272, 120},
    { -1112, 352, 184},
    { -1360, 536, 280},
    { -1384, 512, 136},
    { -1024, 280, 64},
    { -1240, 464, -8},
    { -1464, 464, -136},
    // 62 seconds
    { -1552, 352, -112},
    { -1320, 312, -64},
    { -1192, 144, 48},
    { -1160, 48, 72},
    { -1080, 64, 72},
    { -928, 112, 72},
    { -840, 96, 32},
    { -872, -48, 32},
    { -832, -256, 136},
    { -824, 96, -128},
    { -1216, 56, -16},
    { -1464, 440, -288},
    { -1472, 424, -344},
    { -1664, 128, -128},
    { -1520, 48, -40},
    { -1224, 240, 32},
    { -1024, 304, 8},
    { -984, 336, 48},
    { -928, 232, 80},
    { -880, 168, 136},
    { -808, 168, 192},
    { -816, 208, 184},
    { -1104, 288, 216},
    { -1064, 416, 384},
    { -1336, 928, 200},
    // 63 seconds
    { -1024, 296, -96},
    { -1192, 640, -80},
    { -1392, 520, -136},
    { -1640, 512, -48},
    { -1680, 552, -24},
    { -1488, 288, 152},
    { -1512, 400, 280},
    { -1328, 312, 120},
    { -1072, 232, 72},
    { -832, 144, 192},
    { -688, 24, 200},
    { -656, -136, 144},
    { -568, -584, 32},
    { -448, -616, -768},
    { -1760, 280, 344},
    { -2024, 760, 48},
    { -1904, 568, 40},
    { -1560, 464, 304},
    { -1376, 784, -16},
    { -1312, 672, 8},
    { -1112, 288, 192},
    { -952, 448, 104},
    { -912, 312, 176},
    { -968, 352, 216},
    { -952, 336, 248},
    // 64 seconds
    { -840, 384, 296},
    { -944, 464, 376},
    { -920, 376, 416},
    { -1304, 504, 400},
    { -1096, 584, 224},
    { -1024, 528, 104},
    { -1352, 528, 8},
    { -1664, 520, 80},
    { -1744, 424, 128},
    { -1568, 256, 184},
    { -1368, 128, 240},
    { -1160, 96, 168},
    { -952, 96, 120},
    { -792, 56, 112},
    { -696, -152, 120},
    { -768, -184, 112},
    { -808, -80, 64},
    { -1256, 136, 40},
    { -1592, 256, 96},
    { -1504, 616, -352},
    { -1528, 384, -184},
    { -1448, -72, 8},
    { -1376, 104, -136},
    { -1216, 312, -32},
    { -1136, 328, 40},
    // 65 seconds
    { -1032, 368, 32},
    { -1032, 264, 112},
    { -976, 208, 144},
    { -944, 264, 232},
    { -1128, 320, 288},
    { -1040, 504, 424},
    { -1144, 312, 200},
    { -1192, 472, 208},
    { -1000, 456, 152},
    { -1216, 544, 40},
    { -1488, 440, 40},
    { -1672, 520, 112},
    { -1424, 352, -8},
    { -1472, 280, 64},
    { -1392, 136, 176},
    { -1272, 176, 104},
    { -1056, 136, 64},
    { -920, 136, 72},
    { -928, 40, 112},
    { -840, -8, 144},
    { -960, 40, 120},
    { -1040, 224, -160},
    { -976, 464, -320},
    { -1264, 456, -256},
    { -1552, 72, -48},
    // 66 seconds
    { -1592, 16, 120},
    { -1352, 384, 40},
    { -1128, 472, 56},
    { -1024, 424, -24},
    { -1136, 296, 16},
    { -1144, 280, 80},
    { -1032, 288, 128},
    { -1152, 304, 176},
    { -1176, 512, 312},
    { -1064, 712, 216},
    { -1168, 376, 88},
    { -928, 472, 48},
    { -1128, 528, 80},
    { -1456, 432, 136},
    { -1576, 336, 72},
    { -1408, 312, 104},
    { -1344, 208, 176},
    { -1360, 216, 136},
    { -1296, 120, 96},
    { -1112, 88, 88},
    { -984, 96, 112},
    { -1032, 88, 120},
    { -1120, -48, 160},
    { -968, -208, -136},
    { -1104, -48, -152},
    // 67 seconds
    { -1080, 328, -432},
    { -1512, 200, -304},
    { -1496, -72, -160},
    { -1456, 112, -88},
    { -1280, 352, -208},
    { -1104, 272, -152},
    { -1096, 312, -24},
    { -1112, 320, 0},
    { -1104, 240, 16},
    { -1064, 328, 64},
    { -1192, 456, 80},
    { -1088, 480, 176},
    { -1208, 520, 136},
    { -1216, 512, 24},
    { -1072, 376, 56},
    { -1304, 400, 24},
    { -1544, 376, 88},
    { -1608, 336, 120},
    { -1352, 200, 160},
    { -1288, 200, 136},
    { -1264, 112, 136},
    { -1208, 112, 128},
    { -1080, 96, 112},
    { -944, 72, 120},
    { -944, -56, 88},
    // 68 seconds
    { -912, -296, 96},
    { -1128, -32, -64},
    { -1312, 176, -104},
    { -1280, 304, -256},
    { -1472, 296, -328},
    { -1568, -24, 16},
    { -1576, 248, 24},
    { -1296, 400, 56},
    { -1072, 352, 160},
    { -1024, 424, 72},
    { -1040, 344, 120},
    { -1008, 320, 216},
    { -992, 456, 240},
    { -1080, 472, 192},
    { -1016, 576, 320},
    { -1224, 616, 240},
    { -1152, 560, 48},
    { -1112, 520, -112},
    { -1288, 560, -256},
    { -1632, 464, -120},
    { -1760, 344, 24},
    { -1568, 408, 40},
    { -1576, 544, 200},
    { -1368, 336, 208},
    { -1264, 248, 232},
    // 69 seconds
    { -1112, 224, 128},
    { -872, 160, 152},
    { -848, -40, 248},
    { -816, -136, 192},
    { -560, -528, 56},
    { -1208, -128, -32},
    { -1568, 368, -184},
    { -1816, 112, -272},
    { -2032, 24, -296},
    { -1912, 384, -248},
    { -1664, 832, -552},
    { -1392, 384, -64},
    { -1232, 336, 0},
    { -1216, 320, 96},
    { -1216, 312, 176},
    { -1080, 416, 224},
    { -912, 400, 368},
    { -904, 464, 448},
    { -816, 384, 464},
    { -992, 512, 400},
    { -928, 432, 296},
    { -1208, 520, 144},
    { -1608, 584, 96},
    { -2040, 664, 72},
    { -1968, 448, 176},
    // 70 seconds
    { -1800, 200, 304},
    { -1672, 424, 1072},
    { -1432, 88, 176},
    { -1160, 128, 136},
    { -984, 128, 88},
    { -904, -96, 80},
    { -824, -608, 24},
    { -848, -288, 0},
    { -1176, -336, 88},
    { -1656, 288, -288},
    { -1832, 648, -376},
    { -1784, 40, 240},
    { -1656, -120, 216},
    { -1456, 288, 96},
    { -1304, 280, 224},
    { -1296, 576, 160},
    { -1208, 368, 136},
    { -1200, 392, 168},
    { -1000, 360, 208},
    { -880, 496, 392},
    { -888, 624, 288},
    { -896, 312, 216},
    { -1280, 536, 296},
    { -1200, 376, 160},
    { -1256, 408, 88},
    // 71 seconds
    { -1480, 384, 48},
    { -1656, 352, 40},
    { -1560, 264, 112},
    { -1448, 88, 40},
    { -1152, -8, 616},
    { -1288, 176, 144},
    { -1176, 240, 112},
    { -1040, 136, 152},
    { -1072, 96, 176},
    { -1040, -64, 160},
    { -832, -264, 56},
    { -1104, -88, 0},
    { -1152, 256, -96},
    { -1248, 352, -200},
    { -1408, 304, -24},
    { -1480, -32, 120},
    { -1528, 256, -8},
    { -1336, 488, -40},
    { -1056, 568, 440},
    { -1048, 664, 416},
    { -1320, 632, 568},
    { -1104, 248, 216},
    { -952, 312, 256},
    { -928, 328, 376},
    { -896, 496, 480},
    // 72 seconds
    { -1240, 264, 368},
    { -1264, 408, 312},
    { -1104, 392, 248},
    { -1184, 424, 216},
    { -1392, 336, 168},
    { -1616, 312, 200},
    { -1600, 240, 224},
    { -1480, 128, 200},
    { -1368, 72, 240},
    { -1248, 120, 208},
    { -1024, 88, 200},
    { -864, 88, 168},
    { -832, -40, 104},
    { -776, -272, 104},
    { -712, 8, -64},
    { -1048, 56, 24},
    { -1464, 248, 8},
    { -1504, 776, -312},
    { -1544, 304, -32},
    { -1624, -48, 256},
    { -1504, 440, 0},
    { -1248, 640, 80},
    { -1152, 456, 112},
    { -1104, 232, 152},
    { -1064, 144, 232},
    // 73 seconds
    { -1000, 144, 264},
    { -856, 152, 288},
    { -800, 200, 288},
    { -1008, 296, 384},
    { -928, 328, 456},
    { -1128, 328, 152},
    { -1168, 568, 160},
    { -1096, 672, 24},
    { -1120, 624, 16},
    { -1296, 576, 56},
    { -1496, 400, 112},
    { -1456, 280, 104},
    { -1400, 176, 128},
    { -1344, 112, 160},
    { -1192, 104, 152},
    { -1008, 104, 128},
    { -920, 120, 104},
    { -936, -32, 80},
    { -776, -192, 24},
    { -1000, 0, -16},
    { -1160, 200, -112},
    { -1256, 504, -240},
    { -1504, 400, -128},
    { -1664, -24, 192},
    { -1584, 296, 120},
    // 74 seconds
    { -1320, 416, 96},
    { -1144, 352, 96},
    { -1080, 232, 160},
    { -1064, 184, 224},
    { -976, 128, 248},
    { -896, 152, 280},
    { -832, 104, 320},
    { -960, 232, 312},
    { -1000, 312, 448},
    { -1320, 480, 480},
    { -1016, 304, 280},
    { -952, 520, 64},
    { -1280, 632, -104},
    { -1472, 528, -32},
    { -1368, 808, -328},
    { -1456, 816, -280},
    { -1496, 640, -96},
    { -1192, 496, 8},
    { -792, 352, 32},
    { -592, 200, 104},
    { -488, 104, 40},
    { -456, 112, 104},
    { -544, 0, 328},
    { -736, 24, 256},
    { -1128, 232, 128},
    // 75 seconds
    { -1400, 384, 240},
    { -1656, 696, 64},
    { -1768, 792, 32},
    { -1560, 496, 216},
    { -1344, 728, 120},
    { -1208, 240, 168},
    { -976, 376, 216},
    { -1080, 48, 328},
    { -752, 80, 264},
    { -832, 72, 344},
    { -696, 88, 312},
    { -672, 128, 344},
    { -816, 216, 376},
    { -960, 192, 480},
    { -1312, 440, 336},
    { -1568, 504, 408},
    { -824, 488, 120},
    { -1048, 744, -40},
    { -1576, 696, 32},
    { -1728, 864, 24},
    { -1496, 536, 304},
    { -1320, 720, 264},
    { -1056, 648, 424},
    { -768, 416, 592},
    { -600, 512, 488},
    // 76 seconds
    { -392, 504, 448},
    { -240, 368, 352},
    { -96, 272, 400},
    { 64, 392, 264},
    { 128, 528, 384},
    { 304, 696, 560},
    { 376, 952, 632},
    { 392, 1232, 392},
    { 232, 896, 432},
    { 192, 808, 400},
    { 232, 664, 400},
    { 280, 520, 352},
    { 328, 376, 264},
    { 328, 264, 232},
    { 360, 192, 240},
    { 360, 224, 216},
    { 344, 352, 288},
    { 232, 816, 680},
    { 288, 1240, 808},
    { 368, 1192, 856},
    { 696, 1496, 872},
    { 208, 776, 984},
    { 280, 600, 808},
    { 320, 464, 744},
    { 320, 400, 816},
    // 77 seconds
    { 264, 288, 544},
    { 272, 160, 352},
    { 192, 88, 488},
    { 184, 352, 312},
    { 40, 272, 192},
    { -72, 208, 280},
    { -216, 40, 480},
    { -584, 216, 896},
    { -1264, 768, 888},
    { -1480, 936, 560},
    { -1672, 384, 744},
    { -1616, 776, 288},
    { -1448, 560, 320},
    { -1144, 664, 24},
    { -1096, 408, 232},
    { -920, 136, 256},
    { -888, 128, 304},
    { -768, 240, 88},
    { -824, 264, 288},
    { -720, 96, 256},
    { -688, 96, 208},
    { -920, 224, 248},
    { -1208, 256, 304},
    { -1688, 320, 512},
    { -1216, 576, 448},
    // 78 seconds
    { -912, 720, 88},
    { -1400, 656, 200},
    { -1688, 552, 128},
    { -1408, 440, 32},
    { -1136, 320, 184},
    { -1104, 360, 264},
    { -1024, 336, 248},
    { -896, 216, 448},
    { -792, 264, 368},
    { -752, 320, 376},
    { -720, 288, 472},
    { -560, 416, 488},
    { -440, 552, 568},
    { -184, 904, 704},
    { 80, 1136, 640},
    { 16, 1240, 432},
    { -24, 1000, 408},
    { -8, 672, 480},
    { 40, 488, 368},
    { 80, 312, 336},
    { 64, 352, 264},
    { 144, 208, 256},
    { 80, 376, 344},
    { 88, 520, 528},
    { 72, 856, 744},
    // 79 seconds
    { 120, 1168, 872},
    { 136, 1280, 872},
    { 88, 1160, 984},
    { 120, 952, 784},
    { 104, 880, 696},
    { 96, 856, 824},
    { 48, 880, 760},
    { 16, 744, 552},
    { 8, 576, 344},
    { 16, 400, 248},
    { 24, 248, 200},
    { 16, 128, 144},
    { -8, 120, 88},
    { -200, 208, 64},
    { -584, 192, 168},
    { -1640, 112, 120},
    { -2656, -288, 464},
    { -3128, 776, 248},
    { -2000, 136, 208},
    { -1288, 416, -24},
    { -1256, 368, 112},
    { -1080, 216, 320},
    { -880, 264, 224},
    { -680, 136, 224},
    { -720, 72, 272},
    // 80 seconds
    { -800, 96, 280},
    { -808, 152, 280},
    { -1000, 296, 392},
    { -1208, 424, 408},
    { -1168, 584, 88},
    { -1432, 344, -32},
    { -1024, 600, -376},
    { -1280, 632, -456},
    { -1608, 576, -352},
    { -1856, 464, -40},
    { -1544, 344, 168},
    { -1360, 368, 168},
    { -1296, 368, 128},
    { -1032, 168, 184},
    { -824, 64, 208},
    { -664, 16, 144},
    { -616, -16, 152},
    { -584, -64, 120},
    { -752, 232, 464},
    { -680, -112, -160},
    { -1448, 272, -56},
    { -1984, 688, 288},
    { -2008, 896, 64},
    { -1912, 400, 744},
    { -1152, 1008, 376},
    // 81 seconds
    { -1304, 568, 456},
    { -856, 296, 48},
    { -1280, 304, 544},
    { -944, 280, 256},
    { -936, 144, 328},
    { -816, 56, 384},
    { -864, 120, 488},
    { -968, 208, 584},
    { -928, 168, 464},
    { -1184, 304, 440},
    { -1088, 352, 344},
    { -1360, 464, 304},
    { -1480, 456, 280},
    { -1648, 392, 288},
    { -1488, 312, 232},
    { -1344, 112, 312},
    { -1232, -24, 304},
    { -1152, 48, 280},
    { -1072, 40, 224},
    { -992, 16, 192},
    { -944, -48, 224},
    { -904, -144, 208},
    { -928, -128, 120},
    { -1232, 112, 32},
    { -1392, 352, 0},
    // 82 seconds
    { -1264, 376, -96},
    { -1440, 184, -48},
    { -1640, 8, 112},
    { -1424, 352, 24},
    { -1168, 472, 104},
    { -1024, 320, 104},
    { -1056, 176, 160},
    { -1064, 160, 216},
    { -968, 160, 232},
    { -904, 264, 192},
    { -1096, 208, 272},
    { -1016, 248, 416},
    { -1344, 352, 424},
    { -1280, 384, 280},
    { -1128, 496, 160},
    { -1296, 432, 104},
    { -1504, 376, 136},
    { -1480, 280, 168},
    { -1304, 144, 216},
    { -1288, 48, 232},
    { -1264, 0, 224},
    { -1144, 16, 200},
    { -1032, 64, 160},
    { -1040, 24, 152},
    { -1048, -264, 128},
    // 83 seconds
    { -920, -352, 64},
    { -1208, -80, -32},
    { -1440, 184, 80},
    { -1376, 472, -104},
    { -1456, 128, -88},
    { -1480, -208, 32},
    { -1440, 256, -16},
    { -1288, 272, 48},
    { -1176, 208, 184},
    { -1144, 176, 176},
    { -1160, 144, 216},
    { -1056, 136, 224},
    { -1024, 192, 224},
    { -1160, 288, 264},
    { -944, 224, 320},
    { -1088, 280, 296},
    { -1176, 296, 208},
    { -1248, 312, 128},
    { -1384, 352, 64},
    { -1552, 272, 56},
    { -1568, 240, 184},
    { -1336, 112, 160},
    { -1256, 32, 128},
    { -1216, 24, 152},
    { -1168, 8, 160},
    // 84 seconds
    { -1104, 32, 192},
    { -1112, -48, 176},
    { -1096, -136, 184},
    { -968, -280, 144},
    { -1104, -152, 64},
    { -1360, 264, -48},
    { -1320, 368, -176},
    { -1320, 304, -112},
    { -1408, -32, 128},
    { -1352, 216, 48},
    { -1136, 296, 72},
    { -1144, 408, 80},
    { -1016, 448, 176},
    { -1088, -408, 176},
    { -1024, 136, 192},
    { -976, 200, 280},
    { -1064, 304, 408},
    { -968, 304, 408},
    { -1216, 160, 296},
    { -1336, 344, 320},
    { -1216, 344, 232},
    { -1296, 392, 184},
    { -1432, 352, 192},
    { -1568, 384, 200},
    { -1432, 216, 224},
    // 85 seconds
    { -1328, 32, 296},
    { -1248, -16, 232},
    { -1152, 24, 208},
    { -1000, 24, 176},
    { -864, 16, 160},
    { -888, -96, 96},
    { -872, -272, 16},
    { -1096, 32, 16},
    { -1304, 112, 0},
    { -1344, 480, -176},
    { -1432, 416, -120},
    { -1592, 24, 144},
    { -1528, 168, 192},
    { -1280, 328, 184},
    { -1136, 320, 216},
    { -1112, 288, 176},
    { -1088, 104, 216},
    { -1016, 56, 264},
    { -888, -8, 320},
    { -1080, 296, 328},
    { -1104, 224, 344},
    { -1040, 504, 632},
    { -1112, 640, 416},
    { -1240, 680, 352},
    { -1200, 720, 248},
    // 86 seconds
    { -1360, 760, 184},
    { -1664, 552, 408},
    { -1656, 464, 536},
    { -1624, 360, 512},
    { -1544, 256, 464},
    { -1352, 96, 464},
    { -1120, 80, 368},
    { -912, 72, 304},
    { -744, -200, 416},
    { -736, -184, 184},
    { -664, -600, 144},
    { -808, -456, -264},
    { -1336, -24, 192},
    { -1768, 512, 280},
    { -1944, 456, 184},
    { -1832, 152, 568},
    { -1560, 472, 584},
    { -1352, 552, 488},
    { -1264, 368, 456},
    { -1256, 168, 440},
    { -1216, 144, 400},
    { -1136, 232, 488},
    { -912, 160, 640},
    { -808, 304, 624},
    { -816, 208, 504},
    // 87 seconds
    { -1096, 232, 640},
    { -1048, 368, 528},
    { -1088, 376, 368},
    { -1344, 368, 416},
    { -1712, 280, 456},
    { -1824, 272, 448},
    { -1664, 80, 448},
    { -1568, -16, 424},
    { -1480, -32, 336},
    { -1376, -24, 288},
    { -1152, -8, 224},
    { -1056, 24, 168},
    { -1000, -192, -40},
    { -752, -296, -168},
    { -1208, -104, -416},
    { -1168, 216, -560},
    { -1448, 184, -400},
    { -1528, 56, -8},
    { -1512, -144, 264},
    { -1520, 176, 280},
    { -1512, 368, 224},
    { -1464, 312, 272},
    { -1432, 240, 376},
    { -1344, 200, 368},
    { -1200, 320, 288},
    // 88 seconds
    { -1016, 408, 304},
    { -1016, 520, 464},
    { -992, 528, 520},
    { -1152, 608, 536},
    { -1032, 712, 312},
    { -1032, 592, 296},
    { -1160, 536, 304},
    { -1584, 456, 408},
    { -1736, 208, 456},
    { -1632, -24, 400},
    { -1560, 0, 296},
    { -1488, 48, 232},
    { -1312, 56, 200},
    { -1256, 152, 136},
    { -1280, -16, 40},
    { -792, -392, -160},
    { -944, -64, -288},
    { -1088, -104, -160},
    { -1280, 232, -120},
    { -1232, 392, -40},
    { -1320, 72, 120},
    { -1512, -48, 280},
    { -1496, 152, 248},
    { -1488, 416, 160},
    { -1400, 336, 288},
    // 89 seconds
    { -1312, 456, 248},
    { -1208, 640, 224},
    { -1008, 560, 240},
    { -960, 656, 176},
    { -1040, 576, 240},
    { -1080, 592, 256},
    { -1288, 624, 304},
    { -1048, 472, 240},
    { -1184, 424, 224},
    { -1568, 280, 320},
    { -1888, 184, 360},
    { -1704, 96, 344},
    { -1456, -8, 344},
    { -1288, -8, 288},
    { -1152, 32, 248},
    { -1064, 24, 216},
    { -1096, 56, 168},
    { -1088, -168, -64},
    { -736, -600, -272},
    { -1040, -192, -360},
    { -1400, -24, -248},
    { -1888, 384, -144},
    { -1664, 208, 40},
    { -1640, 96, 184},
    { -1728, 248, 208},
    // 90 seconds
    { -1656, 272, 264},
    { -1464, 176, 352},
    { -1360, 224, 360},
    { -1304, 176, 416},
    { -1144, 328, 328},
    { -968, 296, 344},
    { -888, 464, 416},
    { -896, 600, 536},
    { -920, 504, 488},
    { -1144, 672, 392},
    { -944, 544, 256},
    { -1304, 552, 224},
    { -1848, 440, 328},
    { -2432, 480, 376},
    { -2256, 160, 496},
    { -2048, 72, 456},
    { -1872, 16, 392},
    { -1560, -8, 352},
    { -1176, 0, 280},
    { -936, 88, 112},
    { -808, -152, -152},
    { -576, -440, -264},
    { -608, -232, -376},
    { -920, -152, -224},
    { -1328, 192, -312},
    // 91 seconds
    { -1736, 368, -56},
    { -1968, 496, -96},
    { -2080, 272, 176},
    { -1904, 200, 296},
    { -1760, 280, 264},
    { -1696, 368, 208},
    { -1680, 272, 296},
    { -1664, 176, 344},
    { -1584, 40, 424},
    { -1136, 512, 472},
    { -1008, 544, 560},
    { -712, 456, 656},
    { -712, 616, 656},
    { -600, 616, 512},
    { -776, 608, 408},
    { -1424, 480, 592},
    { -1944, 456, 608},
    { -2320, 600, 520},
    { -2312, 280, 672},
    { -2248, 248, 616},
    { -2088, 336, 616},
    { -1648, 176, 552},
    { -1280, 152, 440},
    { -1048, 96, 368},
    { -840, -64, 208},
    // 92 seconds
    { -744, 8, -344},
    { -680, 0, -504},
    { -928, 216, -112},
    { -1184, 528, 112},
    { -1488, 736, 104},
    { -1704, 560, 136},
    { -1896, 200, 448},
    { -1792, 248, 552},
    { -1688, 544, 440},
    { -1576, 624, 440},
    { -1600, 536, 416},
    { -1352, 672, 384},
    { -952, 720, 408},
    { -824, 712, 360},
    { -808, 512, 528},
    { -1072, 464, 728},
    { -1144, 520, 696},
    { -1024, 680, 376},
    { -1392, 632, 480},
    { -1800, 576, 664},
    { -1920, 792, 768},
    { -1576, 744, 752},
    { -1168, 496, 616},
    { -856, 440, 416},
    { -624, 336, 352},
    // 93 seconds
    { -472, 288, 376},
    { -384, 392, 408},
    { -264, 440, 488},
    { -112, 600, 496},
    { 80, 616, 504},
    { 248, 800, 552},
    { 392, 1040, 456},
    { 440, 968, 464},
    { 416, 872, 392},
    { 296, 624, 448},
    { 336, 504, 384},
    { 352, 472, 280},
    { 352, 288, 264},
    { 352, 256, 216},
    { 328, 240, 168},
    { 272, 224, 88},
    { 208, 280, -32},
    { -48, 504, -128},
    { -520, 488, -104},
    { -1496, 32, 168},
    { -1960, 408, 480},
    { -2616, 544, 680},
    { -2880, 688, 664},
    { -2520, 1000, 272},
    { -1440, 472, 792},
    // 94 seconds
    { -680, 216, 304},
    { -840, 136, 200},
    { -680, 304, 184},
    { -552, 352, 168},
    { -584, 208, 160},
    { -936, 256, 392},
    { -1144, 400, 416},
    { -1232, 392, 400},
    { -1512, 544, 280},
    { -1552, 592, 208},
    { -1688, 600, 120},
    { -2144, 576, 112},
    { -2552, 224, 344},
    { -2112, 136, 232},
    { -1504, 200, 104},
    { -1160, 272, 16},
    { -896, 56, 56},
    { -632, -32, 24},
    { -384, -40, -104},
    { -248, -48, -104},
    { -336, -8, -88},
    { -432, 56, -48},
    { -608, 72, 8},
    { -1184, 304, 144},
    { -1568, 680, 456},
    // 95 seconds
    { -1784, 536, 472},
    { -2464, 648, 568},
    { -2632, 760, 504},
    { -1624, 432, 784},
    { -1032, 248, 16},
    { -1296, 232, 224},
    { -1064, 360, 256},
    { -856, 320, 216},
    { -744, 272, 136},
    { -1008, 360, 192},
    { -1248, 656, 240},
    { -968, 640, 256},
    { -1568, 304, 224},
    { -1392, 600, 216},
    { -1368, 584, 232},
    { -1984, 688, 216},
    { -2424, 464, 352},
    { -2400, 360, 416},
    { -2000, 160, 448},
    { -1472, 56, 392},
    { -1104, 96, 256},
    { -896, 104, 144},
    { -728, 112, 48},
    { -520, -112, -88},
    { -496, -104, -96},
    // 96 seconds
    { -608, 56, -144},
    { -792, 168, -104},
    { -1104, 112, 136},
    { -1224, 144, 232},
    { -1512, 208, 312},
    { -2232, 408, 488},
    { -2648, 664, 536},
    { -2272, 536, 816},
    { -1800, 808, 448},
    { -1592, 616, 488},
    { -1128, 960, 768},
    { -1296, -312, 488},
    { -1032, 312, 208},
    { -1232, 240, 256},
    { -1128, 544, 584},
    { -1032, 632, 424},
    { -864, 432, 312},
    { -808, 384, 376},
    { -1232, 432, 256},
    { -1944, 360, 256},
    { -2592, 440, 152},
    { -2368, 368, 288},
    { -1944, 152, 344},
    { -1648, 136, 264},
    { -1448, 184, 216},
    // 97 seconds
    { -1224, 240, 136},
    { -1000, 200, -32},
    { -856, -64, 0},
    { -776, -56, -216},
    { -784, 0, -280},
    { -824, -80, -176},
    { -912, 216, -64},
    { -1160, 56, 176},
    { -1904, 272, 360},
    { -2896, 424, 704},
    { -2904, 448, 944},
    { -1240, 1248, 688},
    { -1576, 736, -256},
    { -1320, 72, 288},
    { -1136, 144, 384},
    { -1032, 440, 344},
    { -1208, 232, 608},
    { -896, 304, 1048},
    { -672, 184, 1128},
    { -1056, 704, 416},
    { -840, 88, 768},
    { -1072, 552, 584},
    { -2016, 504, 640},
    { -2328, 728, 520},
    { -2712, 304, 864},
    // 98 seconds
    { -2456, 632, 744},
    { -1968, 456, 640},
    { -1360, 216, 520},
    { -928, 128, 328},
    { -592, 128, 184},
    { -336, 88, 88},
    { -224, 8, 176},
    { -104, 344, 136},
    { 88, 416, 272},
    { 264, 664, 344},
    { 352, 752, 392},
    { 632, 856, 392},
    { 384, 816, 328},
    { 144, 504, 328},
    { -64, 256, 240},
    { -336, 232, 232},
    { -688, 144, 168},
    { -952, -152, 288},
    { -1472, 96, 392},
    { -1736, 80, 504},
    { -2296, 464, 352},
    { -1840, 320, 552},
    { -1712, 552, 376},
    { -1904, 136, 272},
    { -2072, 552, 208},
    // 99 seconds
    { -1296, 728, 40},
    { -520, 1112, 248},
    { -512, 648, 160},
    { -976, 616, 144},
    { -1352, 392, 104},
    { -1624, 48, 248},
    { -1376, 16, 232},
    { -1144, 88, 192},
    { -1040, 72, 216},
    { -912, 80, 168},
    { -800, 88, 136},
    { -864, 80, 112},
    { -968, 128, 128},
    { -1024, 64, 144},
    { -1400, 56, 96},
    { -1208, 64, 144},
    { -1016, 360, -80},
    { -1232, 200, 80},
    { -1392, 176, 112},
    { -1240, 224, 56},
    { -1096, 352, 120},
    { -968, 248, 288},
    { -992, 272, 48},
    { -936, 152, 256},
    { -1000, 192, -680},
    // 100 seconds
    { -1072, -264, 312},
    { -1336, 0, 216},
    { -1336, 112, 192},
    { -1504, 176, 288},
    { -1096, 528, 280},
    { -808, 328, 120},
    { -1200, 280, 112},
    { -1600, 296, 40},
    { -1664, -8, 104},
    { -1400, 64, 48},
    { -1168, 184, 24},
    { -1112, 144, 32},
    { -1008, 216, -48},
    { -864, 56, -128},
    { -784, 24, -240},
    { -680, 128, -200},
    { -848, 176, -80},
    { -1232, 120, -56},
    { -1520, 176, 104},
    { -1632, 160, 248},
    { -1816, 144, 280},
    { -1952, 264, 296},
    { -1416, 240, 688},
    { -1032, -56, 144},
    { -1016, 392, 48},
    // 101 seconds
    { -1000, 8, 104},
    { -928, 72, 184},
    { -896, 136, 248},
    { -1080, 32, 304},
    { -1344, 0, 392},
    { -1296, 320, 512},
    { -1176, 392, 248},
    { -1008, 536, 328},
    { -1152, 528, 392},
    { -1568, 184, -72},
    { -2072, 392, -48},
    { -2176, 112, 152},
    { -1784, 32, 112},
    { -1528, 56, 184},
    { -1288, 80, 24},
    { -1056, 40, -72},
    { -696, -144, -176},
    { -640, -8, -304},
    { -808, 104, -408},
    { -840, 24, -344},
    { -1160, -8, -304},
    { -1400, 144, -104},
    { -1504, 56, 200},
    { -1840, 88, 248},
    { -2376, 248, 304},
    // 102 seconds
    { -2312, 216, 416},
    { -1624, 496, 616},
    { -1216, -152, 160},
    { -1360, 96, 280},
    { -1232, 112, 264},
    { -1088, 200, 280},
    { -1136, 168, 328},
    { -1344, 208, 464},
    { -1088, 536, 800},
    { -1016, 456, 512},
    { -768, 656, 408},
    { -968, 744, 256},
    { -1616, 632, 112},
    { -2408, 552, 200},
    { -2664, 336, 288},
    { -2200, 96, 344},
    { -1816, 96, 264},
    { -1520, 96, 224},
    { -1208, 48, 176},
    { -880, 56, 128},
    { -776, 64, 32},
    { -696, -176, -152},
    { -744, -56, -192},
    { -944, 16, -168},
    { -1008, 280, -112},
    // 103 seconds
    { -1024, 216, -32},
    { -1368, 16, 152},
    { -2064, 112, 280},
    { -2680, 256, 520},
    { -2784, 448, 712},
    { -1864, 1056, 1088},
    { -1664, -80, 640},
    { -1448, -16, 432},
    { -1200, -56, 472},
    { -1144, 168, 496},
    { -1112, 112, 568},
    { -568, 104, 856},
    { -944, 232, 928},
    { -776, 320, 752},
    { -752, 304, 536},
    { -1152, 416, 712},
    { -1752, 416, 680},
    { -2504, 352, 696},
    { -2288, -24, 608},
    { -1912, 72, 472},
    { -1656, 168, 376},
    { -1384, 128, 312},
    { -1088, 128, 240},
    { -856, 64, 96},
    { -728, -88, -88},
    // 104 seconds
    { -816, 152, -192},
    { -776, 128, -168},
    { -1032, -56, 16},
    { -1008, -32, 24},
    { -1032, 112, 152},
    { -1488, 184, 264},
    { -2096, 192, 400},
    { -2360, 232, 536},
    { -2008, 80, 688},
    { -1424, 616, 320},
    { -1728, 144, 464},
    { -1432, 312, 400},
    { -1176, 368, 360},
    { -1040, 280, 352},
    { -1296, 424, 512},
    { -1112, 576, 584},
    { -1072, 664, 400},
    { -832, 688, 344},
    { -1080, 632, 248},
    { -1640, 512, 168},
    { -2512, 264, 240},
    { -2624, -16, 216},
    { -2232, 40, 288},
    { -1744, -16, 256},
    { -1384, 48, 224},
    // 105 seconds
    { -1112, 88, 144},
    { -808, -40, 72},
    { -568, -104, -48},
    { -664, -88, -192},
    { -808, -40, -328},
    { -952, -408, -240},
    { -1216, 160, -88},
    { -1432, 72, 232},
    { -1744, 64, 304},
    { -2600, 176, 528},
    { -2968, 264, 568},
    { -2064, 336, 1536},
    { -1472, 72, 288},
    { -1576, 216, 608},
    { -1288, 232, 432},
    { -1080, 288, 424},
    { -1080, 296, 456},
    { -1184, 440, 616},
    { -992, 368, 896},
    { -1240, 448, 528},
    { -1008, 608, 432},
    { -960, 632, 384},
    { -1544, 672, 136},
    { -2264, 336, 280},
    { -2536, 232, 520},
    // 106 seconds
    { -2240, 216, 400},
    { -1736, 0, 496},
    { -1480, 24, 576},
    { -1232, 176, 544},
    { -1040, 136, 504},
    { -816, 152, 440},
    { -680, 144, 416},
    { -528, 320, 408},
    { -200, 368, 416},
    { 88, 600, 496},
    { 272, 632, 552},
    { 640, 664, 608},
    { 480, 592, 680},
    { 440, 456, 760},
    { 424, 496, 752},
    { 384, 496, 584},
    { 440, 384, 520},
    { 440, 424, 480},
    { 216, 352, 264},
    { 496, 280, 512},
    { 424, 320, 536},
    { 416, 288, 696},
    { 416, 480, 760},
    { 424, 672, 888},
    { 528, 760, 1104},
    // 107 seconds
    { 376, 1048, 1184},
    { 264, 1088, 920},
    { 184, 816, 696},
    { 128, 584, 640},
    { 72, 512, 552},
    { 48, 432, 448},
    { 64, 328, 320},
    { 120, 288, 248},
    { 168, 288, 224},
    { 192, 272, 256},
    { 200, 408, 464},
    { 176, 864, 768},
    { 208, 1048, 1112},
    { 392, 1200, 1416},
    { 312, 1144, 1176},
    { 288, 800, 832},
    { 288, 552, 808},
    { 272, 544, 776},
    { 136, 544, 872},
    { 88, 448, 672},
    { 80, 296, 480},
    { 80, 264, 360},
    { 88, 248, 368},
    { 96, 216, 440},
    { 80, 376, 680},
    // 108 seconds
    { 80, 648, 1000},
    { 120, 728, 1232},
    { 232, 856, 1296},
    { 248, 1160, 1080},
    { 240, 1160, 808},
    { 40, 920, 632},
    { 80, 736, 624},
    { 24, 528, 592},
    { 16, 448, 536},
    { 40, 416, 504},
    { 104, 312, 368},
    { 120, 248, 408},
    { 200, 304, 344},
    { 280, 352, 400},
    { 344, 568, 632},
    { 296, 848, 816},
    { 328, 968, 1272},
    { 224, 1240, 1160},
    { 176, 1032, 960},
    { 176, 712, 736},
    { 224, 664, 704},
    { 224, 744, 768},
    { 192, 680, 632},
    { 184, 528, 440},
    { 216, 384, 384},
    // 109 seconds
    { 240, 280, 304},
    { 256, 208, 288},
    { 312, 200, 256},
    { 280, 272, 400},
    { 600, 192, 48},
    { 200, 320, 616},
    { -64, 1160, 1200},
    { -264, 1800, 1680},
    { 72, 1368, 1496},
    { 128, 1096, 616},
    { 80, 640, 616},
    { 8, 536, 584},
    { 0, 504, 512},
    { 40, 400, 448},
    { 128, 296, 344},
    { 224, 248, 280},
    { 248, 320, 336},
    { 288, 312, 376},
    { 328, 432, 512},
    { 264, 712, 792},
    { 280, 816, 1104},
    { 296, 1208, 1264},
    { 280, 1120, 1216},
    { 248, 888, 784},
    { 208, 488, 808},
    // 110 seconds
    { 240, 440, 816},
    { 200, 344, 744},
    { 208, 288, 640},
    { 216, 264, 504},
    { 200, 160, 544},
    { 176, 296, 496},
    { 160, 328, 560},
    { 160, 400, 728},
    { 160, 568, 960},
    { 128, 816, 1064},
    { 248, 768, 1408},
    { 216, 856, 1328},
    { 16, 1000, 1000},
    { 0, 720, 712},
    { -24, 560, 600},
    { 16, 344, 640},
    { 8, 328, 552},
    { 48, 344, 432},
    { 88, 416, 328},
    { 160, 480, 296},
    { 264, 448, 320},
    { 272, 560, 496},
    { 296, 704, 808},
    { 192, 736, 1072},
    { 248, 768, 1368},
    // 111 seconds
    { 192, 840, 1392},
    { 160, 696, 1016},
    { 208, 600, 824},
    { 224, 600, 880},
    { 136, 720, 896},
    { 96, 648, 680},
    { 96, 504, 464},
    { 88, 392, 352},
    { 96, 320, 376},
    { 96, 272, 456},
    { 88, 296, 560},
    { 128, 368, 800},
    { 128, 520, 1096},
    { 168, 680, 1240},
    { 264, 872, 1256},
    { 256, 1072, 1008},
    { 176, 1000, 768},
    { 88, 880, 576},
    { 112, 640, 584},
    { 120, 440, 592},
    { 80, 392, 520},
    { 96, 312, 472},
    { 144, 216, 448},
    { 176, 240, 440},
    { 216, 296, 488},
    // 112 seconds
    { 256, 440, 696},
    { 264, 680, 936},
    { 296, 792, 1272},
    { 288, 1048, 1472},
    { 176, 936, 1352},
    { 144, 696, 912},
    { 160, 520, 680},
    { 216, 432, 752},
    { 136, 384, 832},
    { 72, 432, 744},
    { 80, 352, 568},
    { 80, 280, 488},
    { 160, 160, 592},
    { 168, 256, 712},
    { 128, 328, 720},
    { 144, 496, 936},
    { 136, 392, 960},
    { 192, 552, 1120},
    { 320, 592, 1312},
    { 264, 824, 1272},
    { 184, 800, 1000},
    { 128, 664, 840},
    { 152, 480, 800},
    { 232, 248, 728},
    { 232, 336, 592},
    // 113 seconds
    { 296, 144, 560},
    { 288, 240, 560},
    { 296, 280, 536},
    { 280, 408, 528},
    { 288, 528, 600},
    { 392, 672, 776},
    { 344, 784, 912},
    { 400, 832, 1152},
    { 320, 776, 792},
    { 400, 560, 704},
    { 480, 360, 824},
    { 448, 448, 832},
    { 368, 440, 768},
    { 328, 336, 640},
    { 312, 352, 472},
    { 320, 288, 440},
    { 320, 320, 432},
    { 304, 368, 504},
    { 312, 472, 616},
    { 400, 432, 856},
    { 288, 552, 896},
    { 344, 776, 992},
    { 384, 864, 1168},
    { 288, 848, 1128},
    { 232, 848, 976},
    // 114 seconds
    { 120, 584, 888},
    { 80, 456, 808},
    { 8, 368, 680},
    { 40, 288, 552},
    { 104, 224, 528},
    { 192, 224, 456},
    { 216, 240, 584},
    { 264, 320, 592},
    { 280, 320, 704},
    { 360, 424, 944},
    { 280, 544, 1080},
    { 352, 624, 1296},
    { 288, 680, 1368},
    { 248, 680, 1168},
    { 240, 544, 848},
    { 232, 232, 880},
    { 248, 360, 872},
    { 224, 320, 1016},
    { 160, 344, 936},
    { 168, 280, 824},
    { 168, 280, 728},
    { 160, 216, 648},
    { 176, 232, 536},
    { 216, 240, 448},
    { 56, 448, 744},
    // 115 seconds
    { 256, 136, 832},
    { 256, 592, 816},
    { 432, 560, 1064},
    { 352, 864, 1136},
    { 392, 816, 1048},
    { 216, 720, 936},
    { 160, 488, 752},
    { 96, 392, 688},
    { 64, 368, 736},
    { 48, 360, 744},
    { 80, 376, 712},
    { 120, 448, 704},
    { 160, 440, 704},
    { 168, 520, 712},
    { 184, 616, 736},
    { 208, 632, 752},
    { 232, 624, 704},
    { 216, 576, 688},
    { 232, 504, 728},
    { 224, 520, 720},
    { 216, 568, 776},
    { 184, 528, 728},
    { 152, 464, 664},
    { 120, 496, 824},
    { 112, 408, 848},
    // 116 seconds
    { 48, 424, 1008},
    { 8, 432, 1032},
    { 24, 488, 1056},
    { 88, 352, 968},
    { 88, 360, 904},
    { 72, 336, 880},
    { 80, 272, 960},
    { 112, 248, 896},
    { 88, 392, 904},
    { 144, 344, 904},
    { 128, 488, 840},
    { 152, 568, 776},
    { 160, 704, 736},
    { 152, 744, 648},
    { 152, 848, 456},
    { 152, 920, 296},
    { 136, 936, 136},
    { 88, 808, 0},
    { 64, 824, -152},
    { -32, 832, -224},
    { -80, 760, -208},
    { -112, 768, -312},
    { -136, 624, -376},
    { -216, 712, -472},
    { -224, 672, -544},
    // 117 seconds
    { -168, 544, -488},
    { -304, 752, -536},
    { -368, 648, -504},
    { -376, 704, -584},
    { -368, 624, -608},
    { -536, 880, -752},
    { -400, 768, -896},
    { -360, 616, -696},
    { -344, 736, -648},
    { -240, 720, -640},
    { -128, 560, -672},
    { -168, 568, -872},
    { -216, 408, -856},
    { -80, 112, -896},
    { -320, 48, -976},
    { -296, -128, -984},
    { -112, -328, -928},
    { -192, -352, -952},
    { -248, -352, -928},
    { -112, -240, -952},
    { -64, -240, -968},
    { -176, -368, -960},
    { -152, -328, -928},
    { -64, -456, -912},
    { -56, -368, -904},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:47:01 local
AccelRawData *activity_sample_walk_200_pbl_25479_8(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25479_8
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 32, -200, -968},
    { 32, -248, -984},
    { 0, -224, -984},
    { 16, -208, -1016},
    { 16, -224, -960},
    { 8, -272, -936},
    { 24, -280, -920},
    { -8, -352, -888},
    { 0, -216, -856},
    { -96, -256, -928},
    { -88, -384, -944},
    { -336, -16, -1104},
    { -216, -160, -1056},
    { -112, -296, -968},
    { -192, -240, -1016},
    { -136, -352, -968},
    { -128, -320, -944},
    { -208, -240, -1056},
    { -16, -440, -1000},
    { -8, -232, -1032},
    { -288, -352, -976},
    { -160, -344, -960},
    { -192, -256, -992},
    { -192, -184, -992},
    { -64, -384, -1048},
    // 1 seconds
    { -184, -304, -960},
    { -128, -312, -960},
    { -128, -344, -976},
    { -128, -312, -952},
    { -152, -320, -960},
    { -144, -384, -960},
    { -80, -416, -944},
    { -72, -328, -960},
    { -96, -296, -952},
    { -80, -232, -976},
    { -56, -256, -1000},
    { -48, -232, -1008},
    { -8, -208, -1016},
    { -8, -264, -1008},
    { 40, -224, -984},
    { 128, -184, -936},
    { 88, -184, -928},
    { 80, -224, -944},
    { 24, -104, -824},
    { 0, 192, -904},
    { 24, 312, -880},
    { 48, 472, -792},
    { 64, 592, -736},
    { 96, 648, -576},
    { 184, 728, -552},
    // 2 seconds
    { 240, 720, -464},
    { 272, 688, -392},
    { 208, 696, -432},
    { 224, 720, -424},
    { 128, 544, -432},
    { 200, 792, -448},
    { 208, 896, -376},
    { 208, 840, -232},
    { 256, 800, -192},
    { 192, 680, -88},
    { 72, 808, -48},
    { 72, 680, 120},
    { 56, 1088, 56},
    { -152, 1392, 16},
    { -328, 1368, 88},
    { 176, 1184, -112},
    { 176, 1008, 104},
    { 56, 992, -48},
    { 56, 840, -48},
    { -16, 760, -136},
    { -40, 664, -160},
    { -88, 512, -176},
    { -128, 400, -168},
    { -208, 344, -176},
    { -328, 304, -64},
    // 3 seconds
    { -544, 128, -104},
    { -1040, 304, 0},
    { -2416, 224, 240},
    { -2584, 664, -336},
    { -1896, 280, -64},
    { -1056, 440, -248},
    { -1064, 408, -112},
    { -1232, 416, 32},
    { -976, 256, 80},
    { -736, 192, 48},
    { -616, 240, 24},
    { -608, 208, 72},
    { -648, 304, -80},
    { -712, 216, -48},
    { -1024, 424, -216},
    { -1216, 440, -128},
    { -1168, 616, -416},
    { -1600, 744, -520},
    { -1400, 984, -320},
    { -1368, 624, -296},
    { -1656, 672, -32},
    { -1688, 792, 144},
    { -1368, 776, 216},
    { -1184, 632, 312},
    { -960, 448, 272},
    // 4 seconds
    { -784, 408, 296},
    { -648, 328, 208},
    { -464, 624, 320},
    { -248, 856, 288},
    { 112, 464, 40},
    { 320, 760, -112},
    { 440, 552, 216},
    { 632, 760, 80},
    { 432, 984, -32},
    { 256, 776, 88},
    { 152, 560, -32},
    { 152, 360, -144},
    { 208, 184, -200},
    { 160, 112, -216},
    { 56, 88, -120},
    { -56, 104, -128},
    { -136, 184, -112},
    { -392, 296, -152},
    { -1360, 584, -96},
    { -1744, 1096, -136},
    { -2536, 872, -216},
    { -2640, 640, -56},
    { -2288, 608, 256},
    { -1720, 704, -144},
    { -1504, 552, 128},
    // 5 seconds
    { -1032, 464, 136},
    { -712, 352, -32},
    { -592, 216, -40},
    { -496, 328, -208},
    { -512, 320, -256},
    { -672, 432, -176},
    { -1272, 640, -48},
    { -1544, 568, -208},
    { -1808, 464, -216},
    { -1816, 480, -240},
    { -1680, 440, -384},
    { -1792, 408, -280},
    { -2224, 400, -104},
    { -2144, 272, -160},
    { -1736, 168, 8},
    { -1336, 120, -24},
    { -952, 104, -120},
    { -720, 40, -96},
    { -352, -392, -56},
    { -136, -368, -192},
    { -280, -224, -232},
    { -520, -80, -296},
    { -688, -88, -320},
    { -1280, -56, -192},
    { -1392, 16, -224},
    // 6 seconds
    { -1952, 184, -112},
    { -2288, 384, -160},
    { -2288, 664, -72},
    { -1944, 88, -16},
    { -1840, 312, -80},
    { -1584, 408, 112},
    { -1256, 472, -24},
    { -1112, 400, -40},
    { -1104, 416, 16},
    { -1352, 592, 32},
    { -1256, 1008, 56},
    { -1304, 592, -80},
    { -776, 696, -176},
    { -632, 920, -160},
    { -1392, 824, -184},
    { -2160, 608, -96},
    { -2832, 480, 40},
    { -2680, 112, 120},
    { -2128, 16, 64},
    { -1656, 144, 48},
    { -1232, 136, -112},
    { -968, 112, -248},
    { -768, -168, -184},
    { -576, -752, -208},
    { -536, -520, -496},
    // 7 seconds
    { -784, -400, -344},
    { -1120, -120, -472},
    { -1240, -96, -104},
    { -1712, 128, 80},
    { -2208, 312, 64},
    { -2520, 408, 80},
    { -2312, 472, 72},
    { -2072, 472, 8},
    { -1888, 560, -48},
    { -1560, 464, -32},
    { -1400, 504, -32},
    { -1296, 592, -8},
    { -1312, 704, 32},
    { -1032, 792, 72},
    { -912, 1136, -144},
    { -768, 944, -184},
    { -920, 1040, -456},
    { -1600, 688, -272},
    { -2408, 640, -256},
    { -2920, 328, -160},
    { -2592, 168, 24},
    { -2112, 216, -40},
    { -1784, 176, 40},
    { -1464, 128, 88},
    { -1056, 96, 0},
    // 8 seconds
    { -848, 24, -64},
    { -600, -184, -240},
    { -544, -424, -304},
    { -536, -760, -160},
    { -856, -432, -472},
    { -968, -152, -232},
    { -1192, 64, -216},
    { -1640, 96, -56},
    { -2256, 176, -208},
    { -2592, 464, -400},
    { -2872, 368, 448},
    { -1736, 712, 48},
    { -1696, 680, -112},
    { -1544, 520, 32},
    { -1472, 568, 104},
    { -1568, 752, 152},
    { -1160, 1000, 184},
    { -1024, 1024, 32},
    { -584, 952, -48},
    { -456, 808, -240},
    { -1136, 776, -88},
    { -2128, 776, -72},
    { -2352, 464, 56},
    { -2168, 328, 136},
    { -1808, 256, 96},
    // 9 seconds
    { -1488, 280, -24},
    { -1312, 336, -88},
    { -1072, 272, -136},
    { -1168, 184, -32},
    { -1120, -88, 48},
    { -864, -504, -16},
    { -1024, -64, -304},
    { -848, 24, -232},
    { -1080, 48, -72},
    { -1384, 64, -96},
    { -1728, 40, -32},
    { -1744, 224, -64},
    { -1648, 280, -72},
    { -1568, 280, -208},
    { -1520, 544, -80},
    { -1440, 408, -184},
    { -1592, 384, -24},
    { -1712, 512, 32},
    { -1488, 736, 0},
    { -1400, 936, 88},
    { -824, 608, -128},
    { -432, 656, -248},
    { -864, 800, -168},
    { -1728, 672, -88},
    { -2280, 264, -24},
    // 10 seconds
    { -1992, -72, -48},
    { -1632, -152, -128},
    { -1408, 16, -280},
    { -1336, 152, -264},
    { -1008, 24, -272},
    { -928, 8, -312},
    { -888, -80, -240},
    { -864, -376, -208},
    { -1032, -264, -376},
    { -992, -200, -248},
    { -1048, -104, -144},
    { -1360, 80, -120},
    { -1672, 160, -120},
    { -1800, 264, -72},
    { -1704, 288, -128},
    { -1544, 256, -64},
    { -1432, 320, -136},
    { -1448, 216, -120},
    { -1480, 336, -64},
    { -1536, 352, -160},
    { -1464, 424, -224},
    { -1496, 728, -248},
    { -944, 512, -328},
    { -664, 616, -336},
    { -1008, 680, -344},
    // 11 seconds
    { -1960, 584, -240},
    { -2432, 232, -120},
    { -2232, -24, 168},
    { -1672, -40, -80},
    { -1384, -88, -48},
    { -1144, 16, -136},
    { -912, 184, -184},
    { -1016, 312, -144},
    { -904, -40, -96},
    { -616, -208, -104},
    { -904, -200, -152},
    { -1160, -184, -64},
    { -1120, -16, -72},
    { -1184, 56, -160},
    { -1544, 144, -16},
    { -1792, 248, -80},
    { -1808, 264, -16},
    { -1672, 344, -104},
    { -1464, 448, -184},
    { -1320, 392, -136},
    { -1320, 384, -128},
    { -1384, 336, -48},
    { -1760, 296, 24},
    { -1472, 536, -152},
    { -1392, 592, -192},
    // 12 seconds
    { -928, 552, -352},
    { -664, 560, -376},
    { -1176, 568, -232},
    { -1968, 504, -64},
    { -2344, 216, -8},
    { -2152, -16, 120},
    { -1784, -32, 72},
    { -1552, 80, 24},
    { -1320, 120, -96},
    { -1128, 120, -40},
    { -952, 24, -160},
    { -840, -176, -88},
    { -728, -376, -120},
    { -1040, -576, -152},
    { -1056, -440, -104},
    { -1232, -120, -32},
    { -1616, 48, -48},
    { -2192, 216, -8},
    { -2472, 384, -136},
    { -2360, 464, -176},
    { -1832, 768, -256},
    { -1688, 400, -152},
    { -1472, 392, -224},
    { -1280, 424, -112},
    { -1176, 456, -104},
    // 13 seconds
    { -1064, 720, -136},
    { -832, 800, 240},
    { -864, 984, 24},
    { -984, 848, -200},
    { -1248, 672, -208},
    { -1992, 536, -216},
    { -2824, 160, -200},
    { -2832, 320, -168},
    { -2456, 144, -8},
    { -1944, -16, 72},
    { -1632, 80, 24},
    { -1408, 24, -128},
    { -1000, -208, -96},
    { -1008, -208, -256},
    { -648, -680, -80},
    { -448, -560, -200},
    { -760, -176, -520},
    { -888, -72, -392},
    { -1160, -64, -152},
    { -1760, 112, -176},
    { -2184, 112, -120},
    { -2488, 168, 24},
    { -2208, 336, 40},
    { -1632, 536, -96},
    { -1688, 112, -40},
    // 14 seconds
    { -1800, 352, 160},
    { -1640, 480, 104},
    { -1624, 544, 192},
    { -1296, 952, 168},
    { -1184, 616, 96},
    { -712, 728, 0},
    { -160, 632, -168},
    { -1224, 984, -32},
    { -1848, 584, -208},
    { -2344, 224, -40},
    { -2304, 48, -40},
    { -2024, 120, -168},
    { -1824, 128, -88},
    { -1488, 176, -128},
    { -1144, 96, -112},
    { -1080, 128, -160},
    { -1024, 24, -216},
    { -904, -488, -112},
    { -1080, -392, -336},
    { -928, -392, -16},
    { -1120, -152, 0},
    { -1456, 40, 24},
    { -1824, 200, -56},
    { -2048, 224, -104},
    { -1984, 208, -48},
    // 15 seconds
    { -1776, 416, -264},
    { -1504, 480, -112},
    { -1600, 40, -8},
    { -1688, 72, 344},
    { -1752, 320, 600},
    { -1264, 832, 560},
    { -1120, 1184, 440},
    { -416, 488, 208},
    { -424, 496, 240},
    { -1088, 344, 296},
    { -1912, 600, -176},
    { -2280, 440, -208},
    { -2048, 360, -192},
    { -1848, 240, -120},
    { -1728, 184, 56},
    { -1536, 168, -24},
    { -1296, 112, -32},
    { -1136, 128, -16},
    { -992, -88, 16},
    { -712, -208, 8},
    { -1096, 0, -144},
    { -944, 32, -272},
    { -968, 56, -144},
    { -1120, 56, -136},
    { -1480, 176, -32},
    // 16 seconds
    { -1584, 320, -56},
    { -1520, 344, -16},
    { -1408, 248, 176},
    { -1376, 128, 16},
    { -1496, 280, 56},
    { -1528, 208, 72},
    { -1680, 264, 80},
    { -1648, 384, 128},
    { -1784, 528, 184},
    { -1176, 728, -120},
    { -712, 688, -208},
    { -456, 568, -336},
    { -928, 608, -160},
    { -1688, 504, 40},
    { -1952, 72, 176},
    { -1752, 64, 216},
    { -1544, -112, 48},
    { -1368, -24, -32},
    { -1272, 112, -80},
    { -1144, 216, -136},
    { -1256, 96, -216},
    { -1136, -416, 24},
    { -1112, -400, -376},
    { -1128, -264, -280},
    { -1184, -152, -104},
    // 17 seconds
    { -1424, 72, -32},
    { -1632, 216, -24},
    { -1632, 296, -16},
    { -1480, 336, -80},
    { -1352, 272, -24},
    { -1264, 296, -24},
    { -1168, 352, -64},
    { -1216, 344, -40},
    { -1448, 392, -32},
    { -1552, 560, -72},
    { -1288, 792, -272},
    { -1088, 616, -560},
    { -984, 272, -472},
    { -1152, 704, -472},
    { -1640, 376, -328},
    { -2040, 384, -112},
    { -1880, 336, -152},
    { -1496, 184, 80},
    { -1192, 216, -40},
    { -1040, 144, 32},
    { -912, 96, -32},
    { -736, -136, 32},
    { -656, -272, -40},
    { -864, -144, -152},
    { -1192, -176, -120},
    // 18 seconds
    { -1424, 128, -136},
    { -1312, 264, -200},
    { -1680, 272, -40},
    { -2312, 472, -16},
    { -2552, 712, -8},
    { -1968, 976, 112},
    { -1032, 584, -72},
    { -1064, 648, -336},
    { -912, 520, -40},
    { -792, 544, -72},
    { -936, 584, 120},
    { -1088, 704, 416},
    { -1296, 840, 520},
    { -1240, 784, 128},
    { -904, 704, 0},
    { -872, 712, -64},
    { -1384, 760, 128},
    { -2272, 920, 56},
    { -2704, 728, 152},
    { -2304, 456, 224},
    { -1680, 416, 24},
    { -1360, 400, 88},
    { -1080, 328, -40},
    { -896, 224, -112},
    { -696, 80, -240},
    // 19 seconds
    { -696, -88, -288},
    { -600, -104, -360},
    { -904, -64, -152},
    { -1000, -16, -152},
    { -1096, 224, -216},
    { -1368, 304, -152},
    { -1808, 336, 16},
    { -2248, 376, 168},
    { -2480, 656, 40},
    { -2184, 864, -40},
    { -1840, 488, -48},
    { -1672, 184, 48},
    { -1592, 448, 232},
    { -1528, 416, 168},
    { -1472, 504, 176},
    { -1328, 728, 328},
    { -864, 616, 304},
    { -448, 640, 0},
    { -608, 688, 0},
    { -1272, 728, 88},
    { -2128, 504, 136},
    { -2504, 176, 88},
    { -2232, -40, 16},
    { -1808, 120, -96},
    { -1584, 168, -24},
    // 20 seconds
    { -1472, 168, 8},
    { -1216, 120, -32},
    { -1112, 120, -104},
    { -952, 8, -120},
    { -768, -128, -256},
    { -976, 0, -296},
    { -936, -88, -136},
    { -952, -64, -128},
    { -1184, 56, -80},
    { -1568, 192, -200},
    { -1760, 200, -120},
    { -1816, 192, 0},
    { -1632, 368, -40},
    { -1312, 488, -72},
    { -1272, 216, 40},
    { -1560, 416, 248},
    { -1568, 296, 112},
    { -1672, 392, 112},
    { -1472, 360, 264},
    { -1000, 504, 248},
    { -424, 488, 80},
    { -720, 688, -72},
    { -1096, 520, -152},
    { -1816, 456, -168},
    { -1920, 288, -208},
    // 21 seconds
    { -1656, 56, -152},
    { -1416, 72, -144},
    { -1368, 416, -200},
    { -1072, 280, -288},
    { -968, 176, -168},
    { -1096, 256, -168},
    { -1056, -40, -328},
    { -1064, -136, -432},
    { -1088, -8, -216},
    { -1144, 64, -152},
    { -1336, 208, -64},
    { -1648, 232, 16},
    { -1808, 464, -64},
    { -1584, 400, 56},
    { -1264, 400, 56},
    { -1096, 232, 8},
    { -1208, 288, -8},
    { -1184, 344, -40},
    { -1072, 304, -32},
    { -1440, 384, 32},
    { -1384, 472, 104},
    { -1144, 544, 0},
    { -808, 568, -152},
    { -840, 624, -432},
    { -1312, 512, -456},
    // 22 seconds
    { -2064, 376, -336},
    { -2264, 120, -216},
    { -1832, 56, -128},
    { -1464, 120, -128},
    { -1256, 72, -128},
    { -968, 56, -208},
    { -688, -96, -264},
    { -632, -272, -184},
    { -528, -336, -320},
    { -952, -16, -408},
    { -1368, 24, -384},
    { -1264, 48, -256},
    { -1448, 104, -184},
    { -1776, 272, -208},
    { -2024, 264, -80},
    { -1800, 320, -24},
    { -1440, 264, -48},
    { -1224, 264, -96},
    { -1160, 232, -32},
    { -1152, 256, -40},
    { -1104, 336, -40},
    { -1320, 384, 32},
    { -1280, 712, 24},
    { -1240, 496, -104},
    { -984, 592, -72},
    // 23 seconds
    { -704, 792, -80},
    { -1160, 768, -184},
    { -1968, 560, -32},
    { -2776, 480, 240},
    { -2472, 48, 288},
    { -1888, -72, 160},
    { -1496, 80, 64},
    { -1232, 88, -56},
    { -976, 104, -160},
    { -696, -176, -72},
    { -512, -296, -192},
    { -672, -56, -304},
    { -944, -112, -232},
    { -1152, 32, -280},
    { -1176, 56, -120},
    { -1440, 112, -32},
    { -1888, 232, 32},
    { -2168, 360, 48},
    { -1960, 368, 144},
    { -1616, 408, 16},
    { -1536, 328, 24},
    { -1520, 368, 24},
    { -1416, 352, 16},
    { -1640, 248, 176},
    { -1472, 808, 8},
    // 24 seconds
    { -1256, 704, 328},
    { -936, 808, 248},
    { -400, 744, 48},
    { -624, 816, -104},
    { -1160, 672, -40},
    { -1960, 512, -80},
    { -2216, 360, 240},
    { -1920, 0, 104},
    { -1680, 64, 64},
    { -1504, 120, -16},
    { -1344, 144, -24},
    { -1136, 120, 8},
    { -1104, 72, -40},
    { -944, 96, -96},
    { -1056, -72, -40},
    { -1048, 24, -320},
    { -912, 40, -208},
    { -936, 56, -104},
    { -1240, 128, -80},
    { -1560, 192, -48},
    { -1632, 336, -144},
    { -1616, 312, -152},
    { -1432, 264, -40},
    { -1152, 648, -144},
    { -1120, 128, -224},
    // 25 seconds
    { -1416, 344, 48},
    { -1760, 456, 136},
    { -1560, 464, 200},
    { -1160, 696, 128},
    { -688, 536, -64},
    { -632, 528, -216},
    { -968, 528, -208},
    { -1672, 432, -88},
    { -2024, 208, -64},
    { -1744, 144, -8},
    { -1384, 24, 24},
    { -1224, 112, -16},
    { -1168, 160, -88},
    { -976, 152, -136},
    { -920, -16, -120},
    { -944, -160, -224},
    { -888, -160, -344},
    { -1184, 24, -312},
    { -1120, -16, -152},
    { -1392, 24, -8},
    { -1720, 168, -8},
    { -1832, 312, 16},
    { -1672, 456, -8},
    { -1352, 432, 88},
    { -1096, 464, -48},
    // 26 seconds
    { -1024, 320, -80},
    { -1160, 216, 96},
    { -1160, 288, 104},
    { -1408, 336, 160},
    { -1440, 312, 312},
    { -1360, 928, 280},
    { -784, 480, -32},
    { -704, 760, -152},
    { -872, 632, -224},
    { -1656, 536, -112},
    { -2128, 256, 144},
    { -1816, 88, 160},
    { -1456, 40, 80},
    { -1272, 104, 56},
    { -1160, 168, 8},
    { -1008, 168, 0},
    { -984, 16, 24},
    { -888, -304, 0},
    { -904, -128, -136},
    { -1200, 64, -216},
    { -1288, 152, -112},
    { -1288, 112, -72},
    { -1576, 40, 168},
    { -1992, 376, 104},
    { -1840, 560, 128},
    // 27 seconds
    { -1424, 536, 104},
    { -1112, 536, -64},
    { -1096, 280, 24},
    { -1048, 296, 120},
    { -944, 376, 96},
    { -1200, 368, 176},
    { -1368, 488, 272},
    { -1392, 472, 392},
    { -1000, 312, 384},
    { -688, 608, 152},
    { -1056, 792, -144},
    { -1512, 744, -240},
    { -1968, 616, 40},
    { -1816, 320, 80},
    { -1616, 32, 192},
    { -1328, -16, 152},
    { -1104, 48, -16},
    { -952, 144, -80},
    { -776, 104, -40},
    { -840, 16, -104},
    { -848, -8, -168},
    { -1120, 64, -264},
    { -1264, 112, -240},
    { -1280, 16, -24},
    { -1456, 80, 96},
    // 28 seconds
    { -1800, 288, 48},
    { -1840, 464, 56},
    { -1440, 368, 224},
    { -1192, 424, 8},
    { -1064, 272, 32},
    { -1184, 232, 120},
    { -1208, 232, 184},
    { -1416, 272, 288},
    { -1392, 448, 328},
    { -1320, 704, 296},
    { -1032, 640, 368},
    { -656, 632, 160},
    { -688, 544, -48},
    { -1296, 528, 48},
    { -1872, 400, 40},
    { -1880, 288, 32},
    { -1624, 176, 64},
    { -1384, 192, 0},
    { -1280, 224, -48},
    { -1128, 200, -120},
    { -984, 160, -64},
    { -1016, 112, -128},
    { -824, -128, -200},
    { -1000, -72, -288},
    { -1232, 72, -264},
    // 29 seconds
    { -1192, 0, -56},
    { -1352, 176, 0},
    { -1672, 384, -56},
    { -1816, 440, -56},
    { -1656, 368, 120},
    { -1208, 832, -160},
    { -1144, 648, -16},
    { -1056, 248, 96},
    { -904, 192, 72},
    { -1000, 328, 72},
    { -1376, 544, 168},
    { -1200, 712, -232},
    { -1288, 816, -72},
    { -1024, 616, -208},
    { -888, 576, -400},
    { -1232, 504, -472},
    { -1720, 464, -512},
    { -2064, 520, -312},
    { -1840, 320, -48},
    { -1424, 144, 40},
    { -1120, 128, 40},
    { -920, 72, 80},
    { -744, 64, 88},
    { -616, 8, 72},
    { -664, -64, 96},
    // 30 seconds
    { -824, 48, -48},
    { -1136, 160, -56},
    { -1248, 264, -216},
    { -1256, 176, -128},
    { -1384, 64, -40},
    { -1816, 264, -120},
    { -2016, 432, -144},
    { -1696, 352, 64},
    { -1216, 808, -256},
    { -1168, 352, 88},
    { -1184, 280, 264},
    { -784, 312, 224},
    { -1104, 424, 280},
    { -1304, 408, 288},
    { -1120, 464, 248},
    { -1208, 992, 1400},
    { -792, 328, 216},
    { -872, 768, 56},
    { -1224, 464, 24},
    { -1896, 552, 176},
    { -1944, 304, 224},
    { -1664, 248, 224},
    { -1440, 224, 192},
    { -1216, 160, 184},
    { -1024, 136, 104},
    // 31 seconds
    { -880, 128, 96},
    { -872, 16, 64},
    { -848, 0, -32},
    { -856, -40, 0},
    { -1120, 80, -8},
    { -1096, 280, -56},
    { -1344, 176, 88},
    { -1704, 208, 176},
    { -1888, 336, 168},
    { -1616, 400, 192},
    { -1288, 512, 136},
    { -1048, 304, 0},
    { -1096, 360, 88},
    { -1080, 376, 176},
    { -1120, 360, 104},
    { -1408, 392, 176},
    { -1296, 560, 112},
    { -1320, 776, 176},
    { -1216, 232, 0},
    { -768, 528, -112},
    { -976, 648, -224},
    { -1440, 512, -168},
    { -2056, 296, -32},
    { -2008, 168, 64},
    { -1656, 48, 32},
    // 32 seconds
    { -1352, 152, 24},
    { -1176, 160, 40},
    { -1032, 288, -56},
    { -800, 56, -112},
    { -768, -192, -32},
    { -840, -32, -264},
    { -976, 16, -208},
    { -1232, 160, -192},
    { -1128, 136, -64},
    { -1392, 96, 48},
    { -1800, 264, 72},
    { -1984, 536, 8},
    { -1648, 536, -16},
    { -1280, 408, 128},
    { -1160, -80, 24},
    { -1312, 240, 24},
    { -1288, 336, 136},
    { -1232, 360, 168},
    { -1416, 368, 224},
    { -1224, 416, 312},
    { -1232, 952, 368},
    { -840, 304, 8},
    { -744, 680, -120},
    { -1184, 896, -40},
    { -1600, 416, -176},
    // 33 seconds
    { -2104, 296, -40},
    { -1960, 144, 72},
    { -1616, 80, 80},
    { -1368, 128, 72},
    { -1176, 200, 40},
    { -1016, 136, 88},
    { -856, -72, 56},
    { -952, -168, -104},
    { -1040, -104, -136},
    { -1224, -48, -192},
    { -1152, 64, -184},
    { -1320, 40, -24},
    { -1640, 152, 80},
    { -1864, 328, 40},
    { -1688, 424, 136},
    { -1392, 488, 104},
    { -1064, 632, -128},
    { -1072, 280, -40},
    { -1200, 280, 216},
    { -1152, 232, 88},
    { -1416, 464, 256},
    { -1344, 328, 304},
    { -1192, 672, 384},
    { -1000, 512, 368},
    { -656, 584, 24},
    // 34 seconds
    { -904, 552, -200},
    { -1472, 328, -184},
    { -1816, 464, -288},
    { -1632, 296, -240},
    { -1504, 504, -304},
    { -1248, 272, -56},
    { -1008, 352, -144},
    { -888, 248, 64},
    { -840, 224, 72},
    { -928, 200, 56},
    { -960, 192, 8},
    { -1208, 272, -104},
    { -1120, 312, -120},
    { -1128, 104, 160},
    { -1312, 328, 64},
    { -1624, 448, 144},
    { -1616, 440, 184},
    { -1440, 432, 224},
    { -1224, 448, 288},
    { -1136, 472, 208},
    { -1168, 448, 144},
    { -1048, 304, 208},
    { -1048, 448, 152},
    { -1056, 464, 88},
    { -1032, 592, 536},
    // 35 seconds
    { -1088, 768, 600},
    { -832, 928, 544},
    { -656, 784, 168},
    { -1096, 944, 200},
    { -1752, 912, 344},
    { -2416, 848, 648},
    { -2128, 824, 384},
    { -1616, 648, 344},
    { -1184, 488, 296},
    { -888, 288, 304},
    { -616, 264, 144},
    { -400, 312, 56},
    { -264, 312, 152},
    { -128, 632, 152},
    { 80, 720, 272},
    { 208, 848, 224},
    { 216, 816, 216},
    { 128, 664, 208},
    { 8, 456, 248},
    { -176, 400, 184},
    { -304, 376, 40},
    { -432, 216, 224},
    { -672, 328, 128},
    { -888, 368, 72},
    { -1328, 472, 56},
    // 36 seconds
    { -1648, 744, 48},
    { -1968, 480, 512},
    { -1960, 304, 216},
    { -2152, 312, -208},
    { -2056, 832, -32},
    { -1048, 720, 136},
    { -360, 680, -160},
    { -504, 504, -184},
    { -960, 480, -32},
    { -1016, 288, 8},
    { -872, 240, -24},
    { -816, 192, -8},
    { -872, 136, -80},
    { -880, 216, 8},
    { -856, 184, 64},
    { -1040, 176, 32},
    { -1272, 280, 24},
    { -1688, 288, 32},
    { -1688, 368, -24},
    { -1344, 184, 136},
    { -1064, 40, 72},
    { -1064, 168, -24},
    { -992, 240, -112},
    { -784, 192, -88},
    { -600, 120, -80},
    // 37 seconds
    { -552, 80, -88},
    { -536, 80, -104},
    { -520, 112, -88},
    { -712, 112, -40},
    { -1304, 192, 64},
    { -1664, 256, 192},
    { -1960, 656, 80},
    { -1912, 912, -504},
    { -1112, 960, 200},
    { -360, -288, 24},
    { -936, 48, 96},
    { -1096, 16, 136},
    { -888, 152, 40},
    { -664, 192, 24},
    { -544, 152, 48},
    { -568, 136, -8},
    { -632, 136, 8},
    { -624, 160, 8},
    { -960, 280, -88},
    { -1280, 304, -48},
    { -2008, 592, -504},
    { -1704, 400, -440},
    { -1112, 208, -272},
    { -1072, 192, -80},
    { -1096, 256, -112},
    // 38 seconds
    { -1096, 256, -64},
    { -864, 240, 24},
    { -680, 112, 56},
    { -648, 112, 48},
    { -712, 128, 64},
    { -768, 120, 64},
    { -840, 104, 96},
    { -1112, 104, 144},
    { -1216, 120, 128},
    { -1472, 144, 104},
    { -1600, 328, -128},
    { -1224, 312, -280},
    { -1016, 56, -312},
    { -1064, 240, -360},
    { -1120, 192, -224},
    { -920, 184, -144},
    { -744, 208, -80},
    { -664, 192, -32},
    { -664, 176, -8},
    { -664, 152, 16},
    { -608, 136, 48},
    { -912, 208, -8},
    { -1280, 296, 16},
    { -1808, 320, 48},
    { -1472, 360, 0},
    // 39 seconds
    { -880, 320, -184},
    { -1264, 496, -352},
    { -1352, 272, -224},
    { -1176, 168, -128},
    { -912, 168, -104},
    { -744, 176, -64},
    { -704, 160, -32},
    { -736, 136, 16},
    { -744, 112, 48},
    { -816, 120, 64},
    { -1056, 104, 112},
    { -1176, 112, 160},
    { -1392, 128, 184},
    { -1488, 264, -176},
    { -1312, 280, -120},
    { -1120, 112, -208},
    { -1120, 24, -248},
    { -1160, 128, -216},
    { -1016, 144, -120},
    { -816, 192, -24},
    { -696, 224, 8},
    { -720, 232, 48},
    { -808, 272, 32},
    { -752, 272, 16},
    { -904, 256, 0},
    // 40 seconds
    { -1312, 56, 272},
    { -1392, 512, 272},
    { -1368, 1096, 256},
    { -1200, 696, 184},
    { -1192, 512, 184},
    { -1272, 408, 208},
    { -1448, 448, 440},
    { -1360, 440, 296},
    { -1128, 360, 376},
    { -1008, 424, 312},
    { -1008, 360, 296},
    { -800, 152, 288},
    { -632, 48, 280},
    { -552, 0, 208},
    { -536, 0, 384},
    { -1208, 24, -304},
    { -784, -24, 192},
    { -1136, 320, 112},
    { -1696, 776, -200},
    { -2176, 536, 104},
    { -1824, 368, 376},
    { -992, 1272, -256},
    { -1096, 656, -144},
    { -1032, 344, 96},
    { -896, 184, 192},
    // 41 seconds
    { -784, 256, 232},
    { -760, 320, 232},
    { -680, 272, 272},
    { -848, 336, 248},
    { -1048, 272, 608},
    { -1000, 352, 408},
    { -1368, 416, 344},
    { -1224, 552, 152},
    { -1088, 624, 0},
    { -1264, 672, -40},
    { -1496, 648, 32},
    { -1376, 792, -152},
    { -1424, 304, 456},
    { -1240, 8, 400},
    { -1224, 176, 144},
    { -952, 216, -16},
    { -760, 96, 136},
    { -664, 0, 192},
    { -704, 0, 192},
    { -776, 72, 192},
    { -1112, 112, 264},
    { -1544, 400, 40},
    { -1408, 720, -296},
    { -1424, 280, 80},
    { -1456, 168, -200},
    // 42 seconds
    { -1272, 504, -168},
    { -1104, 336, -48},
    { -1104, 384, -8},
    { -1024, 304, -8},
    { -944, 240, 96},
    { -856, 272, 88},
    { -704, 296, 104},
    { -856, 248, 88},
    { -1112, 416, 168},
    { -1240, 544, 232},
    { -1392, 352, 16},
    { -1112, 448, -64},
    { -1072, 584, -152},
    { -1256, 400, -184},
    { -1512, 360, -248},
    { -1408, 344, -200},
    { -1392, 32, -40},
    { -1168, -88, 136},
    { -1048, 120, 8},
    { -880, 184, -80},
    { -768, 144, -16},
    { -792, 64, 88},
    { -864, 56, 104},
    { -792, 64, 128},
    { -1120, 120, 64},
    // 43 seconds
    { -1360, 344, -168},
    { -1368, 624, -488},
    { -1376, 160, -192},
    { -1272, -80, -200},
    { -1224, 408, -296},
    { -1024, 304, -104},
    { -944, 376, -96},
    { -896, 288, -88},
    { -880, 232, 16},
    { -832, 192, 32},
    { -776, 224, 56},
    { -1104, 264, 96},
    { -1392, 416, 112},
    { -1520, 840, 224},
    { -1128, 120, -120},
    { -992, 632, -232},
    { -1112, 480, -232},
    { -1272, 272, -144},
    { -1424, 304, -136},
    { -1312, 288, -64},
    { -1168, 216, 8},
    { -1112, 184, 16},
    { -1080, 184, 48},
    { -968, 144, 56},
    { -880, 128, 80},
    // 44 seconds
    { -1008, 32, 176},
    { -1120, -152, 192},
    { -1040, -144, 16},
    { -1304, 120, -16},
    { -1296, 440, -304},
    { -1416, 280, -168},
    { -1464, 80, -176},
    { -1480, 192, -144},
    { -1248, 360, -120},
    { -984, 360, -104},
    { -928, 272, -32},
    { -944, 264, 32},
    { -928, 248, 64},
    { -768, 272, 24},
    { -784, 256, 56},
    { -1160, 344, 56},
    { -1152, 360, 160},
    { -1568, 640, 40},
    { -1128, 264, -24},
    { -1024, 440, -216},
    { -1192, 432, -248},
    { -1512, 368, -200},
    { -1592, 240, 24},
    { -1320, 160, 40},
    { -1088, 72, 112},
    // 45 seconds
    { -1016, 104, 48},
    { -960, 112, 56},
    { -856, 96, 80},
    { -872, 88, 104},
    { -936, 64, 120},
    { -976, 16, 152},
    { -1184, 96, 112},
    { -1208, 320, -232},
    { -1104, 392, -328},
    { -1280, 104, -160},
    { -1440, -56, -136},
    { -1480, 200, -136},
    { -1208, 368, -144},
    { -1000, 352, -16},
    { -944, 368, -80},
    { -1040, 344, -32},
    { -952, 288, 56},
    { -888, 304, 64},
    { -1080, 376, 80},
    { -1032, 472, 168},
    { -1304, 592, 200},
    { -1232, 536, 80},
    { -984, 456, -48},
    { -1200, 480, -120},
    { -1488, 416, -96},
    // 46 seconds
    { -1680, 480, -272},
    { -1456, 136, 80},
    { -1392, 352, 72},
    { -1336, 384, 104},
    { -1160, 312, 64},
    { -904, 200, 128},
    { -736, 120, 192},
    { -680, 48, 184},
    { -688, -40, 256},
    { -992, 424, 56},
    { -760, -80, 32},
    { -1192, 552, -16},
    { -1392, 560, -240},
    { -1544, 352, -136},
    { -1696, 472, 24},
    { -1616, 744, -160},
    { -1112, 640, 144},
    { -880, 776, 80},
    { -960, 536, 56},
    { -1032, 400, 120},
    { -896, 304, 184},
    { -752, 272, 264},
    { -824, 320, 288},
    { -920, 400, 368},
    { -1040, 360, 536},
    // 47 seconds
    { -1232, 552, 384},
    { -920, 568, 152},
    { -1016, 512, 112},
    { -1336, 520, 176},
    { -1712, 560, 104},
    { -1632, 464, 112},
    { -1344, 152, -16},
    { -1240, 152, 200},
    { -1232, 128, 120},
    { -1056, 56, 96},
    { -920, 64, 104},
    { -912, 72, 104},
    { -912, -16, 152},
    { -824, -32, 208},
    { -1008, 48, 176},
    { -1088, 120, 32},
    { -1168, 512, -168},
    { -1328, 280, -72},
    { -1640, 272, -80},
    { -1512, 424, -224},
    { -1072, 608, -32},
    { -1016, 624, 520},
    { -1008, 768, 576},
    { -816, 880, 1208},
    { -976, 304, 264},
    // 48 seconds
    { -800, 136, 280},
    { -824, 144, 352},
    { -1104, 200, 448},
    { -1416, 512, 616},
    { -1432, 264, 400},
    { -896, 256, 232},
    { -872, 456, 160},
    { -1232, 400, 296},
    { -1632, 368, 328},
    { -1520, 272, 200},
    { -1440, 72, 272},
    { -1344, 0, 312},
    { -1232, -8, 248},
    { -1040, 80, 184},
    { -832, 80, 128},
    { -728, 32, 144},
    { -800, -48, 168},
    { -776, -8, 168},
    { -960, 48, 128},
    { -1216, 248, 32},
    { -1384, 584, -136},
    { -1696, 512, 0},
    { -1736, 128, 328},
    { -1272, 472, 448},
    { -904, 280, -104},
    // 49 seconds
    { -1024, 328, 120},
    { -1096, 136, 264},
    { -984, 96, 224},
    { -848, 80, 240},
    { -704, 160, 208},
    { -704, 176, 224},
    { -1072, 216, 256},
    { -1312, 200, 520},
    { -1440, 712, 584},
    { -1056, 352, 88},
    { -896, 600, 120},
    { -1072, 472, 72},
    { -1304, 344, 88},
    { -1496, 344, 128},
    { -1328, 296, 120},
    { -1280, 184, 168},
    { -1208, 0, 288},
    { -1112, 136, 200},
    { -944, 128, 160},
    { -864, 104, 144},
    { -888, 40, 168},
    { -840, 0, 128},
    { -664, 40, 72},
    { -1192, 136, 72},
    { -1264, 360, -56},
    // 50 seconds
    { -1120, 392, -120},
    { -1376, 320, 0},
    { -1608, 296, 152},
    { -1432, 472, 200},
    { -1048, 120, 280},
    { -1024, 296, 272},
    { -984, 376, 128},
    { -944, -248, 96},
    { -792, 16, 200},
    { -760, 152, 216},
    { -784, 200, 216},
    { -984, 328, 208},
    { -1056, 328, 328},
    { -1232, 304, 216},
    { -1304, 368, 144},
    { -1120, 432, -16},
    { -1072, 464, -88},
    { -1256, 512, -144},
    { -1528, 416, -232},
    { -1432, 384, 0},
    { -1272, 32, 168},
    { -1080, 168, 40},
    { -960, 200, 104},
    { -808, 144, 112},
    { -792, 64, 160},
    // 51 seconds
    { -856, -8, 184},
    { -888, -16, 192},
    { -904, 8, 192},
    { -1144, 72, 176},
    { -1312, 256, 104},
    { -1344, 312, -8},
    { -1144, 608, -304},
    { -1192, 632, -216},
    { -1288, 400, 232},
    { -1072, 296, 176},
    { -1008, 352, 48},
    { -1032, 272, 104},
    { -976, 240, 112},
    { -832, 104, 176},
    { -744, 56, 184},
    { -760, 128, 192},
    { -832, 112, 208},
    { -960, 224, 232},
    { -1080, 120, 280},
    { -1328, 424, 368},
    { -1616, 400, 112},
    { -1232, 1632, -1088},
    { -896, 88, -32},
    { -816, 104, 248},
    { -1032, 472, 184},
    // 52 seconds
    { -1192, 560, 360},
    { -1192, 408, 456},
    { -1120, 440, 360},
    { -904, 328, 296},
    { -664, 240, 224},
    { -520, 152, 192},
    { -464, 168, 280},
    { -512, -80, 144},
    { -712, 312, 128},
    { -768, 336, 160},
    { -1056, 392, 160},
    { -1432, 512, 0},
    { -1792, 1232, -328},
    { -1680, 168, 584},
    { -296, 856, 456},
    { -1016, 944, -96},
    { -1160, 360, 112},
    { -1088, 200, 152},
    { -816, 104, 200},
    { -672, 88, 200},
    { -672, 120, 208},
    { -720, 168, 248},
    { -752, 264, 240},
    { -928, 280, 312},
    { -1272, 344, 488},
    // 53 seconds
    { -1128, 320, 560},
    { -1432, 304, 160},
    { -1184, 656, 80},
    { -944, 872, -296},
    { -976, 1120, -400},
    { -1240, 368, 416},
    { -1176, -104, 432},
    { -1048, -40, 256},
    { -968, 176, 144},
    { -920, 80, 184},
    { -904, 112, 176},
    { -784, 0, 200},
    { -768, 80, 192},
    { -872, 64, 192},
    { -1032, 48, 224},
    { -1032, 128, 176},
    { -1360, 160, 152},
    { -1392, 408, 24},
    { -1120, 1056, -528},
    { -1080, 232, 0},
    { -1096, 88, 216},
    { -1000, 200, 216},
    { -1024, 376, 112},
    { -976, 312, 128},
    { -840, 192, 160},
    // 54 seconds
    { -720, 120, 176},
    { -640, 88, 160},
    { -600, 88, 168},
    { -672, 160, 160},
    { -1008, 240, 216},
    { -1432, 208, 320},
    { -1632, 336, 608},
    { -1288, 216, 112},
    { -992, 504, -48},
    { -952, 736, -32},
    { -1056, 760, -392},
    { -1240, 344, -24},
    { -1112, 72, 224},
    { -872, 64, 256},
    { -824, 208, 96},
    { -832, 216, 88},
    { -800, 136, 144},
    { -808, 56, 184},
    { -904, 88, 192},
    { -1096, 96, 192},
    { -960, 64, 152},
    { -1208, 104, 216},
    { -1432, 240, 112},
    { -1336, 296, 88},
    { -976, 808, -344},
    // 55 seconds
    { -816, 512, -192},
    { -1000, 272, 104},
    { -1072, 248, 136},
    { -936, 296, 64},
    { -864, 248, 96},
    { -864, 192, 144},
    { -816, 144, -104},
    { -672, -80, 152},
    { -712, 88, 168},
    { -920, 240, 200},
    { -1128, 336, 232},
    { -1016, 224, 344},
    { -1296, 424, 224},
    { -1480, 376, 136},
    { -1208, 544, -120},
    { -944, 568, -168},
    { -968, 272, 64},
    { -1032, 64, 200},
    { -1144, 272, 152},
    { -1024, 208, 176},
    { -952, 128, 240},
    { -952, 40, 272},
    { -928, 0, 256},
    { -896, 48, 232},
    { -904, 64, 216},
    // 56 seconds
    { -952, 48, 240},
    { -944, 16, 264},
    { -1024, 24, 296},
    { -1360, 48, 312},
    { -1504, 144, 224},
    { -896, 296, 64},
    { -640, 504, -48},
    { -880, 248, 0},
    { -1296, 448, -144},
    { -1264, 808, -272},
    { -880, 392, -72},
    { -744, 248, 16},
    { -1024, 288, 40},
    { -1008, 232, 72},
    { -832, 184, 160},
    { -688, 488, 264},
    { -920, 264, 144},
    { -936, 256, 248},
    { -1112, 224, 336},
    { -1416, 224, 256},
    { -1040, 216, 272},
    { -968, 168, 224},
    { -1112, 232, 208},
    { -1144, 128, 240},
    { -1128, 96, 216},
    // 57 seconds
    { -1128, 112, 208},
    { -1176, 88, 224},
    { -1152, 56, 232},
    { -1080, 72, 232},
    { -992, 64, 240},
    { -952, 48, 240},
    { -952, 48, 240},
    { -992, 24, 248},
    { -1024, 16, 272},
    { -960, 24, 256},
    { -1120, 16, 288},
    { -1184, -64, 312},
    { -936, 224, 112},
    { -872, 256, 88},
    { -1024, 344, -8},
    { -1216, 328, -80},
    { -1136, 440, -248},
    { -944, 648, -472},
    { -1064, 1256, -736},
    { -968, 392, -72},
    { -896, 200, 32},
    { -904, 272, -8},
    { -936, 240, 120},
    { -864, 168, 152},
    { -944, 104, 160},
    // 58 seconds
    { -1056, 80, 288},
    { -1168, 40, 288},
    { -1520, 184, 240},
    { -1096, 128, 232},
    { -672, 240, 152},
    { -936, 272, 136},
    { -1304, 208, 224},
    { -1192, 216, 184},
    { -872, 160, 144},
    { -744, 192, 104},
    { -824, 192, 104},
    { -976, 176, 104},
    { -1080, 168, 128},
    { -1288, 152, 136},
    { -1408, 0, 136},
    { -1512, 8, 72},
    { -1296, 200, -72},
    { -1024, 216, -88},
    { -1032, -8, 40},
    { -1160, -40, 112},
    { -1008, 48, 152},
    { -816, 144, 136},
    { -792, 168, 168},
    { -800, 192, 168},
    { -872, 192, 192},
    // 59 seconds
    { -848, 208, 208},
    { -1032, 280, 232},
    { -1272, 520, 376},
    { -888, 888, 240},
    { -1312, 488, 144},
    { -1136, 616, 208},
    { -1288, 608, 112},
    { -1512, 520, 112},
    { -1432, 336, 144},
    { -1272, 240, 136},
    { -1320, 200, 152},
    { -1288, 168, 160},
    { -1104, 112, 160},
    { -936, 104, 144},
    { -832, 16, 152},
    { -728, 16, 136},
    { -600, -48, 136},
    { -496, 16, 80},
    { -720, 0, 120},
    { -1080, 144, 104},
    { -1360, 272, -8},
    { -1776, 264, 104},
    { -1960, 400, 464},
    { -1568, 968, 640},
    { -784, 968, -296},
    // 60 seconds
    // elapsed: 1 minutes
    { -1032, 848, -376},
    { -1144, -24, 312},
    { -1120, 80, 264},
    { -976, 240, 200},
    { -792, 184, 264},
    { -704, 200, 288},
    { -720, 248, 280},
    { -872, 200, 296},
    { -952, 320, 296},
    { -1456, 392, 264},
    { -1672, 272, 240},
    { -1480, 184, 168},
    { -1312, 424, -352},
    { -1512, 312, -440},
    { -1552, 24, 432},
    { -1200, -72, 360},
    { -960, 200, 136},
    { -880, 264, 168},
    { -816, 48, 232},
    { -824, -16, 280},
    { -832, -16, 272},
    { -960, -64, 320},
    { -1168, -184, 424},
    { -1272, 40, 280},
    { -1472, 152, 144},
    // 61 seconds
    { -1328, 480, -64},
    { -1032, 464, -168},
    { -1048, 120, -88},
    { -1176, 344, -184},
    { -1088, 592, -328},
    { -912, 472, -152},
    { -904, 288, 56},
    { -1048, 264, 168},
    { -1072, 272, 256},
    { -912, 400, 208},
    { -848, 216, 200},
    { -1024, 312, 240},
    { -1056, 200, 336},
    { -1408, 272, 288},
    { -1392, 280, 272},
    { -1016, 360, 160},
    { -968, 416, 96},
    { -1200, 424, 88},
    { -1440, 448, 152},
    { -1248, 144, 264},
    { -1104, 184, 232},
    { -1088, 184, 184},
    { -1024, 112, 168},
    { -912, 128, 160},
    { -856, 96, 152},
    // 62 seconds
    { -1024, 120, 168},
    { -1008, -96, 216},
    { -1176, 48, 48},
    { -1224, 264, -24},
    { -1296, 520, -48},
    { -1240, 384, 32},
    { -1232, 56, 40},
    { -1208, 384, 16},
    { -1040, 208, 32},
    { -952, 224, 224},
    { -992, 128, 344},
    { -1000, 576, -256},
    { -792, -184, 144},
    { -776, 64, 248},
    { -1032, 240, 280},
    { -1152, 344, 504},
    { -1360, 416, 488},
    { -944, 328, 264},
    { -1056, 480, 208},
    { -1312, 368, 232},
    { -1472, 328, 224},
    { -1256, 496, 96},
    { -1168, 416, -8},
    { -1160, 208, 128},
    { -1064, 80, 312},
    // 63 seconds
    { -936, 72, 144},
    { -816, 176, 96},
    { -792, 40, 128},
    { -864, -104, 168},
    { -816, -120, 104},
    { -1040, 104, 0},
    { -1584, 288, 104},
    { -1640, 1336, -592},
    { -1344, -128, 256},
    { -1296, 168, 288},
    { -1144, 296, 328},
    { -1008, 320, 224},
    { -992, 184, 320},
    { -864, 176, 224},
    { -800, 80, 280},
    { -744, 120, 312},
    { -776, 112, 376},
    { -800, 176, 456},
    { -896, 464, 752},
    { -904, 136, 336},
    { -1376, 496, 440},
    { -1216, 384, 280},
    { -1024, 1000, -152},
    { -1312, 2872, -1696},
    { -1080, -392, 424},
    // 64 seconds
    { -1056, 208, 208},
    { -1016, 712, 200},
    { -920, 304, 152},
    { -920, 376, 216},
    { -888, 240, 240},
    { -776, 240, 160},
    { -672, 216, 152},
    { -648, 16, 160},
    { -816, 352, 480},
    { -624, 160, -56},
    { -888, -56, 136},
    { -1536, 368, 448},
    { -1992, 256, 296},
    { -1352, 424, 328},
    { -536, 944, -64},
    { -824, 808, -168},
    { -1032, 424, 72},
    { -928, 312, 120},
    { -800, 264, 80},
    { -768, 240, 136},
    { -784, 232, 152},
    { -800, 216, 168},
    { -776, 248, 168},
    { -768, 280, 128},
    { -896, 424, 112},
    // 65 seconds
    { -1056, 592, 56},
    { -1480, 568, 112},
    { -1432, 336, 32},
    { -1000, 264, 40},
    { -1112, 256, 128},
    { -1376, 232, 112},
    { -1408, 288, 232},
    { -1008, 48, 280},
    { -656, 80, 176},
    { -656, 152, 232},
    { -648, 192, 208},
    { -672, 88, 192},
    { -784, 64, 200},
    { -1040, 72, 176},
    { -1160, 24, 32},
    { -1504, 152, 88},
    { -1392, 504, -128},
    { -1560, 928, -72},
    { -1664, 48, 328},
    { -1320, 32, 424},
    { -912, 368, 256},
    { -744, 304, 184},
    { -688, 120, 360},
    { -664, 112, 336},
    { -624, 160, 376},
    // 66 seconds
    { -680, 232, 408},
    { -1072, 304, 552},
    { -1048, 336, 792},
    { -1448, 544, 768},
    { -1224, 496, 640},
    { -1504, 320, 632},
    { -1712, 24, 680},
    { -1632, 320, 424},
    { -1240, 344, 288},
    { -1080, 72, 408},
    { -1072, 160, 240},
    { -1152, 176, 328},
    { -984, 96, 296},
    { -944, -96, 304},
    { -976, -72, 184},
    { -880, -48, 248},
    { -1000, 168, 304},
    { -968, 568, 304},
    { -1480, 640, 448},
    { -1712, 504, 760},
    { -1232, 384, 728},
    { -1152, 440, 560},
    { -912, 328, 552},
    { -664, 336, 552},
    { -544, 304, 568},
    // 67 seconds
    { -432, 288, 560},
    { -360, 208, 688},
    { -600, 344, 944},
    { -672, 208, 1312},
    { -1152, 432, 1376},
    { -1064, 600, 1152},
    { -1048, 688, 848},
    { -984, 584, 704},
    { -856, 456, 712},
    { -672, 504, 624},
    { -472, 424, 528},
    { -296, 272, 408},
    { -288, 256, 336},
    { -296, 184, 272},
    { -352, 152, 216},
    { -448, 112, 208},
    { -656, 104, 216},
    { -888, 112, 232},
    { -1432, 104, 480},
    { -1928, 216, 616},
    { -2424, 400, 560},
    { -1752, 536, 416},
    { -1120, 232, 48},
    { -1096, 432, 80},
    { -968, 280, 88},
    // 68 seconds
    { -768, 216, 144},
    { -576, 168, 144},
    { -536, 184, 160},
    { -592, 256, 136},
    { -680, 272, 152},
    { -1160, 424, 144},
    { -1464, 512, 176},
    { -1352, 224, 224},
    { -1296, 584, 32},
    { -1064, 368, 152},
    { -1576, 440, 16},
    { -1720, 184, 160},
    { -1440, 16, 256},
    { -1088, 224, 152},
    { -936, 96, 200},
    { -856, 40, 200},
    { -808, 32, 232},
    { -864, 32, 232},
    { -1128, -8, 240},
    { -1344, -296, 248},
    { -1304, -176, 112},
    { -1256, 112, -104},
    { -1240, 584, -208},
    { -1288, 472, -64},
    { -1432, 112, 56},
    // 69 seconds
    { -1544, 360, -24},
    { -1256, 464, -8},
    { -976, 432, 72},
    { -872, 408, 120},
    { -880, 344, 152},
    { -952, 288, 216},
    { -904, 304, 224},
    { -984, 392, 400},
    { -896, 304, 456},
    { -1264, 376, 472},
    { -1392, 272, 448},
    { -1256, 432, 376},
    { -1296, 440, 328},
    { -1576, 304, 272},
    { -1544, 280, 216},
    { -1320, 224, 240},
    { -1120, 56, 304},
    { -1136, -64, 344},
    { -1008, 24, 224},
    { -904, 24, 224},
    { -752, -8, 184},
    { -792, -88, 104},
    { -800, -672, -176},
    { -1192, 560, -576},
    { -1888, 264, 312},
    // 70 seconds
    { -1872, 560, 144},
    { -1496, 520, 328},
    { -1056, 200, 320},
    { -1072, 400, 144},
    { -1000, 232, 176},
    { -904, 104, 288},
    { -928, 64, 296},
    { -992, 168, 312},
    { -1016, 192, 384},
    { -1024, 104, 496},
    { -1176, 304, 832},
    { -848, 664, 720},
    { -1104, -88, 288},
    { -1160, 328, 456},
    { -1136, 424, 280},
    { -1304, 560, 272},
    { -1488, 424, 248},
    { -1480, 432, 224},
    { -1312, 320, 192},
    { -1328, 208, 248},
    { -1344, 144, 336},
    { -1272, 16, 304},
    { -1096, 8, 240},
    { -1024, 64, 128},
    { -1000, -184, 144},
    // 71 seconds
    { -744, -80, 96},
    { -912, -104, 184},
    { -1208, 144, 168},
    { -1264, 384, 112},
    { -1552, 304, 144},
    { -1600, 496, 176},
    { -1208, 256, 128},
    { -984, 240, 224},
    { -920, 304, 144},
    { -1000, 112, 168},
    { -1232, 416, 200},
    { -1152, 376, 376},
    { -1120, -72, 1080},
    { -592, 880, 720},
    { -928, 72, 872},
    { -1464, 240, 848},
    { -1240, 248, 528},
    { -1648, 272, 520},
    { -1840, 136, 536},
    { -1688, -16, 472},
    { -1280, 0, 368},
    { -1120, 8, 320},
    { -1072, 8, 264},
    { -992, 80, 184},
    { -872, 168, 64},
    // 72 seconds
    { -768, -176, -32},
    { -760, -480, -16},
    { -904, 16, 64},
    { -1392, 96, 104},
    { -1424, 568, -48},
    { -1616, 688, 56},
    { -1688, 192, 272},
    { -1544, 56, 328},
    { -1240, 480, 168},
    { -1104, 352, 120},
    { -1064, 288, 64},
    { -1056, 176, 240},
    { -1072, 208, 504},
    { -872, 88, 464},
    { -944, 144, 640},
    { -816, 352, 664},
    { -1280, 312, 696},
    { -1176, 240, 624},
    { -1032, 344, 352},
    { -1344, 336, 528},
    { -1744, 224, 496},
    { -1528, 400, 400},
    { -1400, 312, 352},
    { -1416, 240, 192},
    { -1344, 112, 416},
    // 73 seconds
    { -1224, 48, 288},
    { -1008, 104, 184},
    { -936, -120, 72},
    { -760, -464, 32},
    { -848, -80, -24},
    { -1232, 8, 56},
    { -1464, 280, 152},
    { -1720, 608, -16},
    { -1792, 344, 288},
    { -1640, 152, 376},
    { -1176, 344, 392},
    { -920, 472, 280},
    { -1016, 312, 272},
    { -1160, 168, 256},
    { -1128, 208, 296},
    { -960, 272, 368},
    { -976, 240, 512},
    { -1048, 368, 912},
    { -1376, 368, 456},
    { -1096, 464, 312},
    { -1176, 520, 264},
    { -1592, 480, 400},
    { -1744, 320, 280},
    { -1472, 328, 288},
    { -1256, 304, 216},
    // 74 seconds
    { -1136, 144, 176},
    { -1112, 216, 144},
    { -1144, 336, 128},
    { -1072, 176, 136},
    { -1120, 16, 248},
    { -1120, -128, 248},
    { -1288, -48, 216},
    { -1312, 256, 40},
    { -1256, 648, -248},
    { -1424, 368, 32},
    { -1376, -16, 264},
    { -1232, 376, 128},
    { -1064, 400, 160},
    { -984, 280, 184},
    { -1056, 192, 160},
    { -1080, 224, 256},
    { -1048, 232, 320},
    { -1064, 224, 320},
    { -1280, 248, 408},
    { -1240, 184, 464},
    { -1232, 400, 528},
    { -1112, 512, 456},
    { -840, 472, 360},
    { -1008, 528, 160},
    { -1304, 464, 160},
    // 75 seconds
    { -1592, 496, 72},
    { -1640, 408, 192},
    { -1472, 184, 352},
    { -1296, 176, 272},
    { -1088, 328, 96},
    { -992, 176, 272},
    { -920, 120, 272},
    { -1016, 64, 280},
    { -1104, -72, 336},
    { -1016, -96, 48},
    { -1304, -56, -312},
    { -1496, 520, -136},
    { -1680, 320, 200},
    { -1744, 40, 264},
    { -1384, 176, 296},
    { -1168, 424, 224},
    { -1048, 376, 304},
    { -944, 288, 320},
    { -1000, 280, 312},
    { -1120, 208, 376},
    { -1120, 248, 432},
    { -1144, 120, 528},
    { -1176, 240, 688},
    { -984, 360, 584},
    { -992, 464, 544},
    // 76 seconds
    { -728, 520, 280},
    { -928, 640, 264},
    { -1296, 496, 408},
    { -1560, 448, 424},
    { -1384, 352, 384},
    { -1352, 224, 392},
    { -1384, 192, 376},
    { -1376, 160, 304},
    { -1280, 152, 312},
    { -1232, 88, 288},
    { -1208, -56, 264},
    { -1072, 120, 168},
    { -1376, -672, 536},
    { -1248, 296, -176},
    { -1240, 336, -128},
    { -1384, 312, -32},
    { -1376, 56, 152},
    { -1264, 232, 176},
    { -1088, 312, 272},
    { -1024, 536, 280},
    { -1096, 416, 264},
    { -936, 256, -72},
    { -1032, 8, 352},
    { -1136, 144, 336},
    { -1176, 120, 408},
    // 77 seconds
    { -1200, 224, 432},
    { -1216, 272, 376},
    { -888, 328, 296},
    { -1104, 392, 240},
    { -1304, 304, 320},
    { -1544, 216, 368},
    { -1376, 248, 312},
    { -1192, 128, 264},
    { -1128, 336, 288},
    { -1120, 184, 248},
    { -1048, 64, 272},
    { -1136, -48, 288},
    { -1240, -112, 296},
    { -1072, -176, 320},
    { -1256, -56, 488},
    { -1296, 352, 1008},
    { -1032, 1088, 1272},
    { -752, 640, 1040},
    { -488, 424, 896},
    { -288, 432, 672},
    { 16, 352, 528},
    { 104, 280, 520},
    { 136, 176, 496},
    { 176, 240, 568},
    { 184, 240, 584},
    // 78 seconds
    { 240, 240, 632},
    { 200, 448, 720},
    { 168, 432, 880},
    { 104, 656, 1072},
    { -96, 856, 1320},
    { 56, 456, 1032},
    { 0, 640, 856},
    { 96, 608, 808},
    { 32, 456, 608},
    { 72, 296, 320},
    { 0, 168, 248},
    { -64, 128, 184},
    { -168, 104, 136},
    { -432, 216, 216},
    { -1056, 448, 344},
    { -1928, 256, 488},
    { -2016, 160, 288},
    { -2600, 80, 240},
    { -2064, 304, 48},
    { -1120, 352, 216},
    { -656, 328, 8},
    { -928, 224, 128},
    { -944, 160, 88},
    { -800, 144, 112},
    { -688, 128, 88},
    // 79 seconds
    { -608, 112, 72},
    { -824, 128, 264},
    { -728, 224, 80},
    { -952, 448, 16},
    { -1384, 512, -72},
    { -1416, 448, -152},
    { -1648, 464, -224},
    { -1112, 176, -216},
    { -1080, 248, -216},
    { -1352, 248, 24},
    { -1408, 176, 64},
    { -1136, 224, 184},
    { -880, 96, 200},
    { -784, 48, 208},
    { -768, 40, 208},
    { -752, 24, 152},
    { -776, 8, 184},
    { -848, -56, 208},
    { -1016, -64, 232},
    { -1088, -8, 200},
    { -1552, 288, 80},
    { -1648, 776, -152},
    { -1280, 408, -112},
    { -1192, 184, -120},
    { -1200, 408, -72},
    // 80 seconds
    { -1096, 360, 48},
    { -944, 200, 96},
    { -872, 200, 144},
    { -840, 128, 288},
    { -832, 160, 312},
    { -776, 216, 280},
    { -840, 280, 304},
    { -1088, 336, 312},
    { -992, 248, 400},
    { -1424, 392, 336},
    { -1400, 344, 248},
    { -1200, 416, 80},
    { -1464, 536, 0},
    { -1552, 368, 304},
    { -1544, 392, 304},
    { -1248, 88, 368},
    { -1072, 24, 344},
    { -1008, 80, 264},
    { -912, 64, 248},
    { -800, 72, 192},
    { -808, -88, 192},
    { -912, -224, 184},
    { -960, -464, 304},
    { -1200, 160, -520},
    { -1840, -32, 192},
    // 81 seconds
    { -2000, 808, 144},
    { -1632, 672, 232},
    { -1272, 568, -8},
    { -1328, 552, 120},
    { -1048, 448, 168},
    { -816, 328, 216},
    { -800, 336, 272},
    { -840, 248, 280},
    { -816, 240, 288},
    { -816, 272, 368},
    { -976, 344, 472},
    { -960, 232, 568},
    { -1392, 280, 424},
    { -1304, 408, 392},
    { -1072, 456, 304},
    { -1280, 472, 296},
    { -1768, 328, 392},
    { -1776, 312, 360},
    { -1472, 80, 400},
    { -1368, 136, 312},
    { -1256, 88, 304},
    { -1112, 40, 296},
    { -952, 48, 240},
    { -896, -40, 152},
    { -800, -256, 48},
    // 82 seconds
    { -840, -168, 16},
    { -1096, -16, 56},
    { -1376, 304, 56},
    { -1616, 528, 32},
    { -1848, 344, 192},
    { -1744, 200, 368},
    { -1368, 576, 48},
    { -1136, 520, 128},
    { -1080, 240, 176},
    { -1208, 128, 224},
    { -1208, 96, 288},
    { -1032, 176, 328},
    { -1000, 168, 360},
    { -1160, 168, 584},
    { -984, 368, 720},
    { -1104, 56, 408},
    { -1056, 232, 352},
    { -1264, 312, 416},
    { -1440, 304, 272},
    { -1584, 464, 176},
    { -1392, 560, -64},
    { -1288, 640, 192},
    { -1424, 112, 496},
    { -1280, -24, 464},
    { -1256, 176, 360},
    // 83 seconds
    { -1032, 120, 224},
    { -1016, 24, 264},
    { -1096, -168, 336},
    { -1208, -264, 344},
    { -1304, 72, 168},
    { -1208, 304, 72},
    { -1304, 488, -128},
    { -1288, 368, 8},
    { -1248, 88, 192},
    { -1152, 320, 128},
    { -1128, 400, 384},
    { -1032, 120, 688},
    { -1144, 848, -24},
    { -1144, 208, 392},
    { -1080, 208, 616},
    { -1248, 224, 592},
    { -1088, 176, 632},
    { -1224, 184, 704},
    { -976, 288, 536},
    { -872, 360, 464},
    { -1192, 416, 384},
    { -1496, 320, 320},
    { -1576, 352, -512},
    { -1128, 176, 528},
    { -1208, -32, 440},
    // 84 seconds
    { -1144, 56, 224},
    { -1136, 56, 232},
    { -1040, 80, 192},
    { -1136, 72, 216},
    { -1160, 8, 224},
    { -1080, -88, 200},
    { -1256, -48, 160},
    { -1304, 408, -72},
    { -1232, 512, -168},
    { -1336, 176, 40},
    { -1392, 48, 136},
    { -1248, 336, 96},
    { -1048, 320, 224},
    { -936, 192, 304},
    { -904, 120, 248},
    { -1080, 216, 192},
    { -984, 120, 376},
    { -1128, 144, 328},
    { -1168, 256, 448},
    { -1408, 352, 520},
    { -1320, 344, 464},
    { -920, 488, 264},
    { -904, 552, 208},
    { -1192, 376, 320},
    { -1464, 256, 272},
    // 85 seconds
    { -1272, 72, 272},
    { -1208, 160, 296},
    { -1208, 120, 264},
    { -1144, 64, 240},
    { -1032, 40, 200},
    { -1032, 48, 240},
    { -1240, 32, 240},
    { -1232, -208, 48},
    { -1264, -176, 40},
    { -1352, 136, -112},
    { -1360, 552, -152},
    { -1368, 464, -80},
    { -1400, 40, 168},
    { -1352, 248, 128},
    { -1112, 160, 184},
    { -1008, 208, 304},
    { -1024, 264, 232},
    { -1056, 192, 264},
    { -1000, 176, 264},
    { -984, 168, 360},
    { -1192, 176, 424},
    { -928, 352, 616},
    { -1232, 312, 624},
    { -1200, 376, 528},
    { -1120, 464, 352},
    // 86 seconds
    { -1360, 472, 320},
    { -1640, 472, 312},
    { -1528, 280, 400},
    { -1344, 120, 392},
    { -1248, 48, 400},
    { -1192, 40, 368},
    { -1096, 64, 328},
    { -936, 56, 240},
    { -880, -32, 296},
    { -1024, -80, 272},
    { -968, -328, 184},
    { -1176, 112, -200},
    { -1320, -48, 256},
    { -1528, 624, 200},
    { -1496, 608, 112},
    { -1504, 336, 272},
    { -1408, 352, 216},
    { -1120, 368, 288},
    { -984, 328, 384},
    { -976, 264, 376},
    { -1024, 192, 360},
    { -1008, 176, 416},
    { -912, 128, 456},
    { -1032, 184, 592},
    { -864, 160, 640},
    // 87 seconds
    { -1208, 200, 728},
    { -1064, 296, 608},
    { -968, 384, 424},
    { -1296, 320, 496},
    { -1528, 200, 512},
    { -1480, 280, 440},
    { -1328, 104, 384},
    { -1392, 144, 440},
    { -1384, 80, 320},
    { -1288, 64, 312},
    { -1096, 80, 248},
    { -984, -8, 56},
    { -760, -464, -152},
    { -1048, -248, -56},
    { -1440, 216, -96},
    { -1856, 568, -32},
    { -1560, 392, 96},
    { -1352, -136, 344},
    { -1288, 136, 248},
    { -1216, 384, 200},
    { -1064, 312, 216},
    { -968, 184, 248},
    { -984, 208, 232},
    { -1008, 104, 272},
    { -912, 184, 264},
    // 88 seconds
    { -1064, 112, 344},
    { -1272, 184, 488},
    { -1304, 472, 904},
    { -1136, 552, 320},
    { -1088, 608, 312},
    { -968, 544, 232},
    { -1224, 472, 336},
    { -1520, 216, 328},
    { -1416, 216, 232},
    { -1264, 144, 240},
    { -1216, 72, 216},
    { -1128, 64, 232},
    { -1080, 72, 264},
    { -984, 40, 168},
    { -1080, 40, 208},
    { -880, -192, 112},
    { -952, -80, 56},
    { -1336, -64, 160},
    { -1736, 720, -64},
    { -1392, 480, -24},
    { -1280, -112, 232},
    { -1168, 192, 40},
    { -1056, 416, 16},
    { -912, 304, 56},
    { -904, 232, 88},
    // 89 seconds
    { -968, 168, 160},
    { -1048, 240, 216},
    { -992, 256, 280},
    { -1112, 280, 360},
    { -1232, 264, 560},
    { -1040, 360, 400},
    { -1264, 392, 328},
    { -1024, 344, 280},
    { -1152, 424, 256},
    { -1304, 392, 256},
    { -1360, 376, 200},
    { -1152, 352, 136},
    { -944, 64, 216},
    { -992, 144, 224},
    { -1032, 88, 224},
    { -1088, 88, 192},
    { -1072, 72, 184},
    { -1168, 56, 184},
    { -1224, -136, 184},
    { -1248, 56, -40},
    { -1352, 280, -120},
    { -1152, 560, -304},
    { -1304, 248, -128},
    { -1328, 48, 48},
    { -1224, 128, 80},
    // 90 seconds
    { -1088, 256, 176},
    { -952, 184, 232},
    { -912, 128, 272},
    { -976, 144, 240},
    { -1048, 112, 256},
    { -968, 136, 264},
    { -1200, 200, 296},
    { -1136, 184, 392},
    { -1408, 328, 464},
    { -1136, 264, 352},
    { -1096, 504, 160},
    { -1152, 424, 96},
    { -1408, 392, 152},
    { -1360, 440, 88},
    { -1200, 120, 40},
    { -1208, 328, 312},
    { -1128, -48, 240},
    { -1064, 96, 160},
    { -928, 112, 144},
    { -968, -8, 200},
    { -1184, -232, 208},
    { -1152, -232, 232},
    { -1400, 88, 48},
    { -1352, 336, -16},
    { -1312, 344, -32},
    // 91 seconds
    { -1344, 144, 48},
    { -1320, 56, 160},
    { -1184, 192, 128},
    { -1096, 264, 288},
    { -960, 32, 424},
    { -1152, 568, 976},
    { -1152, 480, 328},
    { -1008, 352, 336},
    { -984, 208, 400},
    { -968, 288, 512},
    { -872, 208, 496},
    { -1680, 440, 408},
    { -1000, 664, 320},
    { -1184, 552, 352},
    { -1464, 344, 344},
    { -1568, 256, 400},
    { -1352, 128, 344},
    { -1272, 88, 312},
    { -1312, 80, 328},
    { -1312, 32, 336},
    { -1216, 24, 312},
    { -1056, -24, 288},
    { -1008, 0, 464},
    { -1112, -480, -48},
    { -1200, -672, -504},
    // 92 seconds
    { -1608, -160, -192},
    { -2000, 456, -96},
    { -2048, 432, 368},
    { -1600, 232, 480},
    { -1264, 552, 352},
    { -1176, 608, 280},
    { -1000, 168, 296},
    { -1032, 288, 384},
    { -1096, 256, 448},
    { -1016, 176, 464},
    { -1008, 112, 520},
    { -1088, 160, 688},
    { -1016, 128, 592},
    { -1216, 280, 536},
    { -1032, 296, 408},
    { -1048, 456, 272},
    { -1264, 408, 304},
    { -1528, 392, 296},
    { -1488, 200, 336},
    { -1320, 184, 184},
    { -1272, 192, 192},
    { -1200, 208, 184},
    { -1096, 64, 136},
    { -1144, 144, 200},
    { -1344, -8, 16},
    // 93 seconds
    { -1272, -192, 160},
    { -1280, -392, 8},
    { -1200, 24, -80},
    { -1088, 280, -192},
    { -1312, 112, 8},
    { -1440, -32, 160},
    { -1408, 248, 128},
    { -1272, 256, 216},
    { -1248, 336, 776},
    { -1008, 240, 400},
    { -1024, 280, 304},
    { -1000, 680, 392},
    { -1272, 680, 360},
    { -1208, 304, 448},
    { -1072, 224, 456},
    { -1464, 304, 384},
    { -992, 360, 320},
    { -760, 464, 208},
    { -1056, 336, 248},
    { -1504, 224, 280},
    { -1488, 160, 272},
    { -1336, 40, 80},
    { -1256, 144, 128},
    { -1216, 184, 136},
    { -1096, 152, 120},
    // 94 seconds
    { -1024, 160, 128},
    { -1280, 32, 96},
    { -1296, -184, -104},
    { -1192, -200, -192},
    { -1320, 48, -224},
    { -1392, 360, -192},
    { -1400, 216, -56},
    { -1440, 152, 80},
    { -1368, 312, 56},
    { -1184, 312, 112},
    { -992, 136, 216},
    { -984, 368, 48},
    { -960, -192, 192},
    { -936, 96, 224},
    { -856, 192, 216},
    { -1056, 280, 296},
    { -1040, 304, 416},
    { -1304, 336, 376},
    { -1224, 304, 248},
    { -944, 472, 200},
    { -1104, 264, 304},
    { -1528, 224, 104},
    { -1576, 16, 384},
    { -1320, 104, 352},
    { -1136, 144, 232},
    // 95 seconds
    { -1080, 120, 224},
    { -1064, 88, 240},
    { -976, 56, 248},
    { -1080, 8, 248},
    { -1224, -112, 176},
    { -1176, -216, 56},
    { -1344, -64, 32},
    { -1304, 296, -56},
    { -1128, 552, -120},
    { -1336, 200, 96},
    { -1432, -32, 216},
    { -1232, 216, 304},
    { -1040, 400, 288},
    { -960, 224, 304},
    { -960, 360, 248},
    { -976, -112, 488},
    { -928, 168, 344},
    { -1120, 112, 400},
    { -1264, 168, 504},
    { -1376, 360, 592},
    { -944, 256, 360},
    { -952, 512, 248},
    { -1152, 440, 280},
    { -1296, 360, 208},
    { -1192, 304, 96},
    // 96 seconds
    { -1040, 88, 312},
    { -1088, 48, 304},
    { -1096, 304, 160},
    { -1056, 248, 120},
    { -1056, 152, 152},
    { -1352, -56, 112},
    { -1336, -80, 24},
    { -1312, -96, -24},
    { -1464, 312, -56},
    { -1248, 480, -112},
    { -1280, 192, 128},
    { -1232, 56, 128},
    { -1112, 120, 72},
    { -1000, 128, 144},
    { -880, 80, 256},
    { -864, 128, 320},
    { -944, 256, 288},
    { -976, 312, 312},
    { -1088, 360, 512},
    { -1120, 608, 472},
    { -1224, 256, 224},
    { -1432, 456, 312},
    { -1120, 456, 272},
    { -1296, 440, 128},
    { -1576, 528, -224},
    // 97 seconds
    { -1368, 336, 200},
    { -1248, 416, 72},
    { -1152, 328, 80},
    { -1120, 136, 200},
    { -1088, 96, 224},
    { -888, 0, 224},
    { -792, -48, 216},
    { -832, -96, 248},
    { -840, -272, 296},
    { -1376, 8, 8},
    { -1424, 424, 8},
    { -1272, 480, 16},
    { -1264, 880, -112},
    { -1256, -40, 136},
    { -1320, 352, -152},
    { -984, 176, -24},
    { -976, 464, 88},
    { -968, 376, 224},
    { -1032, 344, 272},
    { -1016, 424, 296},
    { -936, 536, 432},
    { -1056, 456, 424},
    { -1000, 384, 376},
    { -1496, 376, 392},
    { -1040, 416, 384},
    // 98 seconds
    { -1104, 440, 280},
    { -1312, 368, 264},
    { -1520, 256, 312},
    { -1344, 192, 288},
    { -1216, 120, 280},
    { -1168, 48, 288},
    { -1120, 8, 272},
    { -1024, 0, 216},
    { -960, 32, 216},
    { -1024, 0, 224},
    { -1096, -96, 256},
    { -1224, -88, 224},
    { -1368, 40, 176},
    { -1192, 536, -64},
    { -1160, 520, -72},
    { -1232, 168, 48},
    { -1360, 24, 112},
    { -1248, 344, 152},
    { -1120, 488, 176},
    { -1056, 288, 264},
    { -1072, 312, 256},
    { -984, 264, 256},
    { -1040, 256, 296},
    { -1152, 256, 368},
    { -984, 168, 456},
    // 99 seconds
    { -1136, 272, 416},
    { -1280, 240, 480},
    { -1016, 312, 424},
    { -1072, 592, 240},
    { -1240, 536, 288},
    { -1472, 416, 280},
    { -1376, 360, 296},
    { -1288, 184, 224},
    { -1224, 112, 280},
    { -1184, 48, 264},
    { -1112, 48, 232},
    { -1064, 24, 232},
    { -1072, -56, 232},
    { -968, -104, 192},
    { -968, 0, 120},
    { -1168, 64, 80},
    { -1200, 352, -16},
    { -1096, 464, -96},
    { -1296, 288, 32},
    { -1520, 80, 120},
    { -1456, 240, 208},
    { -1216, 368, 256},
    { -1048, 336, 232},
    { -1024, 304, 224},
    { -1048, 272, 232},
    // 100 seconds
    { -896, 232, 256},
    { -848, 328, 280},
    { -1000, 304, 392},
    { -936, 312, 472},
    { -1320, 376, 432},
    { -1224, 384, 336},
    { -1192, 432, 216},
    { -1304, 392, 160},
    { -1440, 344, 264},
    { -1408, 272, 368},
    { -1240, 64, 328},
    { -1176, 136, 224},
    { -1176, 128, 208},
    { -1160, 104, 216},
    { -1080, 88, 200},
    { -1104, 56, 208},
    { -1128, -88, 136},
    { -912, -184, -104},
    { -1264, 48, -56},
    { -1224, 272, -176},
    { -1376, 536, -64},
    { -1512, 136, 168},
    { -1480, 168, 224},
    { -1248, 368, 176},
    { -1056, 304, 232},
    // 101 seconds
    { -1040, 248, 192},
    { -1144, 168, 232},
    { -1184, 96, 296},
    { -1048, 8, 376},
    { -1072, 64, 376},
    { -1064, 128, 424},
    { -1400, 424, 512},
    { -1008, 376, 368},
    { -744, 552, 288},
    { -1080, 536, 232},
    { -1408, 392, 224},
    { -1424, 400, 48},
    { -1280, 496, 40},
    { -1312, 320, 184},
    { -1272, 256, 144},
    { -1160, 192, 136},
    { -1144, 136, 208},
    { -1160, -80, 40},
    { -1240, -152, 72},
    { -1080, -288, 40},
    { -1448, -72, -8},
    { -1328, 272, -128},
    { -1272, 272, -112},
    { -1336, 304, 48},
    { -1336, 136, 144},
    // 102 seconds
    { -1144, 192, 176},
    { -976, 208, 216},
    { -1064, 328, 376},
    { -1112, 624, 24},
    { -1056, 408, 32},
    { -936, 152, 136},
    { -1112, 256, 328},
    { -1072, 320, 576},
    { -1480, 320, 416},
    { -1128, 240, 328},
    { -848, 376, 200},
    { -1168, 344, 192},
    { -1456, 216, 264},
    { -1512, 408, 168},
    { -1352, 288, 224},
    { -1328, 168, 400},
    { -1240, 80, 320},
    { -1152, 32, 392},
    { -1024, -8, 360},
    { -976, 32, 288},
    { -1032, -112, 240},
    { -816, 72, 216},
    { -920, -32, 264},
    { -920, 112, 568},
    { -720, 840, 1144},
    // 103 seconds
    { -752, 1016, 1632},
    { -416, 1048, 1152},
    { -192, 656, 848},
    { 0, 424, 640},
    { 48, 344, 576},
    { 56, 144, 576},
    { 80, 152, 512},
    { 128, 208, 520},
    { 192, 184, 648},
    { 216, 408, 928},
    { 280, 488, 1032},
    { 360, 456, 984},
    { 376, 560, 1000},
    { 584, 720, 968},
    { 312, 424, 840},
    { 368, 384, 744},
    { 360, 424, 800},
    { 200, 488, 744},
    { 104, 392, 472},
    { 128, 296, 224},
    { 64, 144, 176},
    { 16, 72, 152},
    { -72, 24, 152},
    { -272, 24, 200},
    { -736, 208, 376},
    // 104 seconds
    { -1952, 744, 1616},
    { -1936, 864, 880},
    { -1768, 584, 656},
    { -1664, 464, 560},
    { -1400, 376, 424},
    { -1120, 304, 64},
    { -984, 248, 168},
    { -888, 136, 232},
    { -800, 80, 192},
    { -776, 64, 224},
    { -824, 192, 352},
    { -720, 232, 280},
    { -1032, 344, 328},
    { -1200, 264, 288},
    { -1384, 248, 304},
    { -1520, 384, 296},
    { -1056, 240, 232},
    { -1240, 352, 216},
    { -1552, 240, 224},
    { -1512, 56, 104},
    { -1208, 128, 232},
    { -1040, 40, 264},
    { -992, -8, 240},
    { -976, -24, 232},
    { -888, -16, 200},
    // 105 seconds
    { -872, -16, 192},
    { -1000, -80, 208},
    { -1088, -56, 176},
    { -1360, -208, 240},
    { -1312, 160, 152},
    { -1032, 560, -128},
    { -1080, 280, 40},
    { -1400, 48, 208},
    { -1496, 472, 168},
    { -1304, 432, 288},
    { -904, -40, 824},
    { -768, 840, 488},
    { -888, 288, -88},
    { -832, 128, 176},
    { -960, 136, 368},
    { -1184, 48, 416},
    { -1296, 152, 576},
    { -1400, 152, 560},
    { -1096, 256, 344},
    { -1064, 392, 200},
    { -1240, 280, 320},
    { -1504, 184, 352},
    { -1352, 160, 344},
    { -1160, 24, 336},
    { -1072, -48, 280},
    // 106 seconds
    { -1056, 8, 216},
    { -960, 24, 192},
    { -1040, 32, 176},
    { -1360, -256, 88},
    { -1256, -224, 72},
    { -1288, -256, 40},
    { -1264, 184, -16},
    { -1184, 304, -40},
    { -1336, 368, 72},
    { -1352, 64, 232},
    { -1248, 112, 240},
    { -1104, 208, 384},
    { -1048, -40, 432},
    { -992, 440, -424},
    { -1088, 128, 376},
    { -984, 16, 400},
    { -1016, 184, 512},
    { -984, 192, 560},
    { -1328, 216, 424},
    { -1240, 280, 384},
    { -1000, 312, 320},
    { -1152, 272, 280},
    { -1472, 152, 336},
    { -1560, 136, 280},
    { -1256, -24, 224},
    // 107 seconds
    { -1200, 0, 312},
    { -1144, -16, 256},
    { -1088, -16, 232},
    { -1032, -24, 216},
    { -1232, -56, 248},
    { -1320, -528, 216},
    { -1312, -344, 72},
    { -1352, -8, -96},
    { -1384, 288, -72},
    { -1248, 312, -192},
    { -1344, -48, 232},
    { -1376, 288, 248},
    { -1208, 336, 248},
    { -1048, 144, 344},
    { -1040, 200, 400},
    { -1080, 208, 392},
    { -1008, 208, 416},
    { -880, 160, 464},
    { -1080, 208, 440},
    { -1120, 136, 504},
    { -1280, 208, 504},
    { -1192, 256, 384},
    { -1064, 288, 320},
    { -1136, 472, 296},
    { -1360, 328, 264},
    // 108 seconds
    { -1664, 304, 392},
    { -1496, 48, 448},
    { -1344, 32, 496},
    { -1240, 0, 424},
    { -1128, 24, 384},
    { -952, 40, 312},
    { -808, 0, 376},
    { -992, 16, 32},
    { -936, 232, -288},
    { -1056, 104, -72},
    { -1472, -40, 288},
    { -1680, 272, 360},
    { -1584, 416, 152},
    { -1408, 176, 472},
    { -1248, 256, 512},
    { -1080, 424, 344},
    { -928, 208, 328},
    { -944, 72, 328},
    { -992, 72, 312},
    { -1000, 40, 336},
    { -880, 96, 384},
    { -928, 64, 368},
    { -1200, 64, 584},
    { -1264, 192, 664},
    { -1496, 112, 520},
    // 109 seconds
    { -1024, 304, 400},
    { -1000, 464, 240},
    { -1264, 424, 232},
    { -1464, 576, 264},
    { -1280, 208, 360},
    { -1184, -80, 296},
    { -1184, -40, 232},
    { -1120, 56, 200},
    { -976, 8, 232},
    { -880, 0, 168},
    { -992, -64, 136},
    { -1080, -144, 136},
    { -1320, -160, 48},
    { -1408, -8, -16},
    { -1256, 368, -144},
    { -1312, 240, -80},
    { -1232, 96, -8},
    { -1136, 152, -8},
    { -1000, 224, 80},
    { -952, 168, 152},
    { -968, 112, 208},
    { -1016, 176, 176},
    { -1056, 224, 288},
    { -1152, 208, 368},
    { -1368, 320, 624},
    // 110 seconds
    { -1040, 88, 448},
    { -1480, 168, 360},
    { -1120, 320, 328},
    { -984, 464, 216},
    { -1184, 344, 216},
    { -1392, 240, 240},
    { -1216, 112, 192},
    { -1176, 40, 224},
    { -1192, 80, 168},
    { -1168, 40, 168},
    { -1040, 16, 160},
    { -944, 48, 160},
    { -1160, 0, 136},
    { -1264, -224, -16},
    { -1264, -96, -152},
    { -1408, 24, -104},
    { -1368, 432, -128},
    { -1472, 176, 32},
    { -1344, -56, 120},
    { -1240, 176, 120},
    { -1088, 240, 176},
    { -968, 136, 224},
    { -960, 104, 232},
    { -984, 96, 224},
    { -976, 136, 248},
    // 111 seconds
    { -1144, 128, 336},
    { -1248, 136, 496},
    { -1184, 440, 584},
    { -1376, 96, 408},
    { -992, 272, 328},
    { -1104, 408, 272},
    { -1352, 216, 240},
    { -1544, 128, 248},
    { -1408, 88, 248},
    { -1296, 8, 248},
    { -1264, -48, 224},
    { -1168, -72, 232},
    { -1080, -56, 224},
    { -992, -80, 200},
    { -1080, -96, 184},
    { -1120, -312, 80},
    { -1264, -104, -16},
    { -1312, 48, -24},
    { -1344, 392, -56},
    { -1536, 272, -8},
    { -1400, 88, 56},
    { -1240, 192, 96},
    { -1048, 312, 224},
    { -944, 64, 288},
    { -992, 432, 168},
    // 112 seconds
    { -1224, -176, 464},
    { -1096, 360, 360},
    { -1192, 120, 432},
    { -1168, 56, 584},
    { -1128, 208, 576},
    { -1320, 496, 232},
    { -1032, 256, 432},
    { -1168, 176, 352},
    { -1360, 160, 248},
    { -1472, 192, 216},
    { -1288, 144, 192},
    { -1184, 232, 200},
    { -1216, 200, 216},
    { -1224, 104, 272},
    { -1128, 32, 224},
    { -1112, 128, 152},
    { -1232, 112, 200},
    { -1072, 48, 184},
    { -1152, 8, 104},
    { -1056, 112, 0},
    { -984, 440, -152},
    { -1264, 384, -72},
    { -1392, 64, 128},
    { -1320, 144, 200},
    { -1104, 208, 256},
    // 113 seconds
    { -992, 144, 216},
    { -1080, 248, 224},
    { -1168, 272, 224},
    { -1088, 216, 408},
    { -960, 560, 760},
    { -952, 320, 816},
    { -976, 424, 760},
    { -1400, 256, 1256},
    { -1264, 392, 1104},
    { -1592, 384, 1120},
    { -1608, 224, 1096},
    { -1416, 144, 1016},
    { -1120, 216, 808},
    { -792, 248, 616},
    { -544, 192, 448},
    { -408, 0, 456},
    { -336, 160, 416},
    { -216, -16, 376},
    { -176, 96, 312},
    { -160, 56, 456},
    { -104, 224, 712},
    { -72, 160, 1216},
    { -264, 272, 1736},
    { -64, 616, 1840},
    { 72, 536, 1464},
    // 114 seconds
    { 128, 648, 1560},
    { 40, 456, 872},
    { 16, 264, 752},
    { 16, 264, 592},
    { 40, 128, 576},
    { 64, 56, 568},
    { 80, 96, 592},
    { 112, 144, 616},
    { 120, 144, 656},
    { 32, 216, 1016},
    { -72, 344, 1464},
    { -80, 408, 1664},
    { -32, 560, 1480},
    { 120, 504, 1128},
    { 88, 392, 1048},
    { 72, 320, 1080},
    { -16, 384, 1152},
    { -88, 400, 1008},
    { -72, 336, 760},
    { -72, 192, 624},
    { -80, 208, 520},
    { -80, 208, 496},
    { -88, 184, 560},
    { -168, 280, 856},
    { -256, 496, 1104},
    // 115 seconds
    { -440, 616, 1432},
    { -360, 928, 1168},
    { -280, 984, 992},
    { -328, 936, 656},
    { -272, 736, 528},
    { -168, 336, 616},
    { -80, 328, 632},
    { -48, 280, 632},
    { 0, 216, 688},
    { 104, 288, 648},
    { 168, 408, 616},
    { 112, 408, 808},
    { -104, 672, 1184},
    { -144, 800, 1424},
    { -176, 744, 1488},
    { -184, 744, 1264},
    { -112, 600, 928},
    { -128, 536, 840},
    { -160, 496, 880},
    { -240, 552, 840},
    { -216, 424, 656},
    { -200, 320, 472},
    { -216, 280, 392},
    { -232, 264, 336},
    { -224, 224, 360},
    // 116 seconds
    { -288, 312, 528},
    { -464, 816, 688},
    { -504, 872, 1032},
    { -464, 1392, 1136},
    { -224, 1808, 696},
    { -224, 1104, 464},
    { -216, 696, 416},
    { -216, 632, 360},
    { -248, 504, 400},
    { -200, 408, 400},
    { -168, 384, 400},
    { -136, 456, 408},
    { -120, 536, 440},
    { -80, 584, 512},
    { -176, 928, 920},
    { -184, 1224, 1016},
    { -168, 1360, 1104},
    { -232, 1224, 992},
    { -200, 744, 768},
    { -128, 688, 552},
    { -96, 624, 608},
    { -104, 624, 584},
    { -152, 584, 520},
    { -136, 416, 416},
    { -136, 344, 344},
    // 117 seconds
    { -152, 464, 344},
    { -144, 352, 448},
    { 8, 280, 352},
    { -160, 672, 640},
    { -352, 1120, 888},
    { -400, 1328, 1168},
    { -400, 1560, 816},
    { -336, 960, 552},
    { -304, 792, 280},
    { -296, 696, 240},
    { -240, 544, 288},
    { -192, 432, 304},
    { -152, 432, 336},
    { -128, 488, 344},
    { -120, 520, 432},
    { -112, 672, 504},
    { -96, 800, 624},
    { -128, 1056, 744},
    { -176, 1104, 848},
    { -240, 1320, 920},
    { -208, 1032, 808},
    { -120, 760, 632},
    { -80, 752, 584},
    { -88, 752, 664},
    { -128, 672, 616},
    // 118 seconds
    { -104, 440, 528},
    { -96, 392, 376},
    { -88, 336, 288},
    { -96, 328, 280},
    { -112, 336, 344},
    { -296, 672, 536},
    { -304, 864, 744},
    { -440, 1000, 952},
    { -464, 1544, 1000},
    { -336, 1432, 768},
    { -232, 1056, 328},
    { -272, 856, 144},
    { -264, 696, 160},
    { -216, 552, 280},
    { -176, 504, 352},
    { -120, 456, 416},
    { -80, 448, 448},
    { -48, 432, 504},
    { -24, 504, 512},
    { 0, 536, 640},
    { -64, 824, 768},
    { -176, 1112, 1056},
    { -296, 1408, 1272},
    { -264, 1168, 1080},
    { -128, 800, 856},
    // 119 seconds
    { -144, 920, 848},
    { -152, 688, 920},
    { -128, 536, 752},
    { -96, 328, 616},
    { -104, 296, 520},
    { -32, 64, 592},
    { 8, 184, 456},
    { 64, 80, 504},
    { 192, -24, 472},
    { 272, 136, 1072},
    { 336, 296, 944},
    { 264, 384, 1472},
    { 368, 736, 1416},
    { 280, 736, 1384},
    { 168, 632, 968},
    { 136, 496, 864},
    { 56, 344, 760},
    { 8, 304, 648},
    { 8, 232, 656},
    { 32, 248, 632},
    { 48, 256, 792},
    { 72, 384, 952},
    { 96, 424, 952},
    { 88, 528, 920},
    { 136, 472, 760},
    // 120 seconds
    // elapsed: 2 minutes
    { 120, 304, 880},
    { 144, 424, 904},
    { 160, 360, 1040},
    { 120, 344, 1136},
    { 64, 384, 1024},
    { 64, 312, 960},
    { 24, 304, 928},
    { 0, 312, 928},
    { 0, 304, 992},
    { 0, 368, 928},
    { 48, 376, 920},
    { 72, 376, 888},
    { 128, 296, 944},
    { 120, 312, 904},
    { 152, 304, 920},
    { 152, 408, 872},
    { 160, 520, 784},
    { 200, 512, 824},
    { 224, 440, 768},
    { 200, 440, 816},
    { 184, 600, 720},
    { 160, 312, 928},
    { 112, 544, 760},
    { 24, 528, 888},
    { 32, 504, 864},
    // 121 seconds
    { 0, 560, 808},
    { 8, 592, 688},
    { 40, 664, 728},
    { 144, 472, 840},
    { 120, 648, 744},
    { 120, 800, 696},
    { 128, 784, 616},
    { 104, 912, 464},
    { 128, 840, 288},
    { 112, 944, 152},
    { 80, 920, 72},
    { 32, 800, -80},
    { -32, 888, -184},
    { -72, 872, -264},
    { -72, 880, -368},
    { -64, 784, -384},
    { -24, 792, -456},
    { 16, 832, -448},
    { 48, 784, -416},
    { 64, 824, -376},
    { 80, 760, -400},
    { 104, 864, -480},
    { 56, 824, -512},
    { 80, 784, -456},
    { 88, 720, -456},
    // 122 seconds
    { 96, 792, -464},
    { 152, 728, -448},
    { 184, 656, -496},
    { 128, 720, -520},
    { 144, 712, -552},
    { 176, 696, -560},
    { 152, 720, -584},
    { 224, 864, -664},
    { 248, 728, -592},
    { 128, 608, -536},
    { 56, 600, -552},
    { -24, 608, -584},
    { -80, 576, -648},
    { -32, 736, -912},
    { -96, 272, -616},
    { -120, 640, -680},
    { -160, 552, -704},
    { 40, 688, -592},
    { -96, 520, -656},
    { -120, 624, -752},
    { -24, 632, -600},
    { -504, 776, -448},
    { -408, 888, -632},
    { -256, 584, -792},
    { -176, 472, -872},
    // 123 seconds
    { -160, 464, -912},
    { -40, 528, -1016},
    { -120, 600, -960},
    { -80, 264, -1192},
    { -248, -232, -504},
    { -216, -248, -1016},
    { -128, -296, -1024},
    { -328, -264, -952},
    { -88, -408, -920},
    { -264, -472, -928},
    { -216, -504, -824},
    { 8, -568, -896},
    { -224, -392, -928},
    { -184, -432, -896},
    { -120, -424, -880},
    { -96, -464, -880},
    { -32, -424, -912},
    { -24, -456, -912},
    { -88, -456, -928},
    { -8, -424, -888},
    { -48, -472, -920},
    { -40, -464, -912},
    { 8, -400, -912},
    { 16, -448, -904},
    { 0, -504, -904},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:49:34 local
AccelRawData *activity_sample_walk_200_pbl_25479_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25479_9
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -184, -344, -944},
    { -184, -368, -912},
    { -152, -384, -944},
    { -160, -368, -960},
    { -160, -376, -952},
    { -168, -376, -952},
    { -136, -472, -896},
    { -216, -400, -880},
    { -248, -392, -960},
    { -232, -384, -960},
    { -184, -432, -936},
    { -168, -408, -976},
    { -128, -440, -936},
    { -176, -352, -872},
    { -152, -528, -944},
    { -128, -376, -960},
    { -152, -432, -944},
    { -136, -416, -944},
    { -152, -296, -976},
    { -128, -200, -992},
    { -72, 96, -1000},
    { 8, 32, -1056},
    { 88, 8, -1000},
    { 168, 216, -840},
    { 168, 248, -1000},
    // 1 seconds
    { 144, 192, -984},
    { 72, 176, -904},
    { 16, 208, -1024},
    { 56, 192, -952},
    { 96, 176, -952},
    { 104, 152, -944},
    { 120, 144, -880},
    { 128, 160, -912},
    { 96, 168, -880},
    { 152, 264, -888},
    { 136, 248, -832},
    { 136, 320, -832},
    { 152, 256, -832},
    { 144, 312, -824},
    { 152, 336, -816},
    { 168, 248, -728},
    { 72, 296, -712},
    { 8, 320, -632},
    { -32, 720, -616},
    { -72, 920, -376},
    { -8, 1336, -328},
    { 24, 1096, -192},
    { 104, 1120, -216},
    { 64, 872, -168},
    { 80, 872, -184},
    // 2 seconds
    { 80, 872, -232},
    { 48, 880, -192},
    { 8, 792, -176},
    { -32, 744, -248},
    { -80, 704, -224},
    { -128, 656, -248},
    { -200, 512, -232},
    { -256, 416, -176},
    { -352, 360, -264},
    { -352, 272, -176},
    { -544, 392, -440},
    { -2144, 128, -72},
    { -1448, 456, -232},
    { -1904, 856, 144},
    { -1664, 872, 72},
    { -1376, 976, -288},
    { -1336, 744, 120},
    { -1544, 400, 72},
    { -1376, 376, -88},
    { -1152, 664, -256},
    { -736, 880, -408},
    { -768, 672, -352},
    { -992, 576, -120},
    { -1520, 424, 120},
    { -1584, 144, -40},
    // 3 seconds
    { -1504, 256, -96},
    { -1392, 264, 24},
    { -1296, 232, 24},
    { -1184, 176, 24},
    { -1056, 176, 16},
    { -1032, 160, -24},
    { -944, 200, -32},
    { -1064, -40, 96},
    { -1128, 64, -192},
    { -1184, 304, -344},
    { -1008, 192, -440},
    { -1104, -208, -216},
    { -1376, -168, -136},
    { -1496, 344, -160},
    { -1344, 528, -16},
    { -1224, 504, -104},
    { -1200, 576, -88},
    { -1104, 488, -88},
    { -864, 304, -104},
    { -1032, 296, -136},
    { -1240, 696, -192},
    { -1112, 808, -344},
    { -1176, 552, -336},
    { -896, 552, -440},
    { -1064, 696, -408},
    // 4 seconds
    { -1472, 456, -296},
    { -1872, 448, -128},
    { -1704, 288, -136},
    { -1488, 248, -112},
    { -1376, 248, -64},
    { -1200, 96, -48},
    { -1072, 168, 80},
    { -1048, 120, 24},
    { -992, -160, 128},
    { -664, -424, 32},
    { -784, -208, -184},
    { -1232, 88, -360},
    { -1288, 88, -520},
    { -1528, -104, -584},
    { -1776, -168, -392},
    { -1832, 40, -352},
    { -1600, 240, -232},
    { -1296, 392, -88},
    { -1184, 336, -72},
    { -1224, 352, -40},
    { -1120, 328, -48},
    { -1008, 320, 8},
    { -1184, 368, -112},
    { -1160, 536, -16},
    { -1352, 736, -184},
    // 5 seconds
    { -904, 752, -400},
    { -808, 616, -344},
    { -1384, 624, -240},
    { -1632, 464, -256},
    { -1728, 336, -224},
    { -1600, 136, -136},
    { -1488, 96, -112},
    { -1472, 152, -104},
    { -1400, 168, -80},
    { -1320, 208, -32},
    { -1432, 208, 32},
    { -1264, -104, 208},
    { -1040, -128, 80},
    { -1152, -40, -112},
    { -1016, 88, -400},
    { -1136, -88, -296},
    { -1200, -184, -280},
    { -1328, -16, -272},
    { -1408, 208, -240},
    { -1472, 312, -208},
    { -1536, 416, -64},
    { -1520, 536, -48},
    { -1320, 592, -144},
    { -1552, 504, -152},
    { -1464, 544, -88},
    // 6 seconds
    { -1192, 728, -216},
    { -1048, 1000, -192},
    { -920, 616, -208},
    { -1088, 696, -280},
    { -1384, 584, -144},
    { -1728, 488, -120},
    { -1712, 272, -152},
    { -1528, 216, -160},
    { -1424, 272, 32},
    { -1536, 216, 48},
    { -1352, 176, 24},
    { -1208, 184, 0},
    { -1192, 176, 24},
    { -968, -280, 200},
    { -776, -592, -24},
    { -1192, -312, -144},
    { -1360, -80, -328},
    { -1600, -48, -368},
    { -1688, -56, -200},
    { -1824, 168, -296},
    { -1648, 416, -384},
    { -1360, 640, -160},
    { -1144, 288, -320},
    { -1272, 416, -176},
    { -1272, 248, -160},
    // 7 seconds
    { -1352, 240, -40},
    { -1360, 672, -176},
    { -1080, 720, -352},
    { -1144, 872, -448},
    { -1040, 960, -568},
    { -968, 704, -752},
    { -1552, 600, -704},
    { -2224, 672, -592},
    { -2600, 680, -408},
    { -2408, 592, -296},
    { -2096, 448, -200},
    { -1728, 360, -144},
    { -1416, 360, -96},
    { -1016, 32, 24},
    { -872, 72, 48},
    { -704, -160, 328},
    { -328, -848, 432},
    { -472, -768, 368},
    { -1240, -320, -280},
    { -1768, -96, -624},
    { -2152, -24, -312},
    { -2144, 256, -400},
    { -2144, 144, -296},
    { -2184, 128, -200},
    { -2104, 496, -312},
    // 8 seconds
    { -1936, 584, -248},
    { -1832, 664, -96},
    { -1584, 592, 24},
    { -1352, 648, 80},
    { -1240, 680, 224},
    { -1056, 680, 288},
    { -816, 560, 200},
    { -864, 824, 344},
    { -648, 952, 72},
    { -864, 968, 32},
    { -1624, 936, 200},
    { -2408, 856, 288},
    { -2656, 568, 304},
    { -2576, 424, 280},
    { -2352, 200, 280},
    { -2024, 176, 192},
    { -1584, 120, 184},
    { -1264, 136, 184},
    { -1112, -120, 144},
    { -728, -800, 240},
    { -680, -464, -72},
    { -1080, -184, -240},
    { -1488, -208, 256},
    { -1720, -112, 224},
    { -1728, -232, 280},
    // 9 seconds
    { -1928, 144, 120},
    { -2152, 384, 312},
    { -2096, 664, 160},
    { -1872, 640, -16},
    { -1712, 456, 32},
    { -1680, 8, 160},
    { -1688, 320, 312},
    { -1424, 776, 160},
    { -960, 1048, 80},
    { -928, 1104, 88},
    { -712, 848, 40},
    { -832, 584, -96},
    { -1208, 648, 96},
    { -1896, 752, 248},
    { -2192, 408, 264},
    { -2312, 280, 344},
    { -2256, 160, 392},
    { -2056, 160, 336},
    { -1768, 144, 280},
    { -1368, 160, 264},
    { -1288, 256, 240},
    { -1040, -88, 320},
    { -640, -936, 136},
    { -1032, -208, 56},
    { -1296, -168, -152},
    // 10 seconds
    { -1576, 56, -40},
    { -1448, 8, -256},
    { -1568, -64, -32},
    { -1680, 56, 72},
    { -1728, 400, 32},
    { -1712, 560, 160},
    { -1640, 768, 56},
    { -1488, 624, 96},
    { -1320, 360, 104},
    { -1352, 472, 96},
    { -1272, 640, 120},
    { -1048, 624, 120},
    { -1048, 672, 72},
    { -968, 640, 40},
    { -968, 616, -104},
    { -1176, 704, -32},
    { -1664, 600, 32},
    { -2008, 528, 96},
    { -2080, 168, 80},
    { -1824, -56, 8},
    { -1664, -16, -56},
    { -1544, 56, -40},
    { -1344, 168, -40},
    { -1248, 96, 24},
    { -880, -240, 256},
    // 11 seconds
    { -728, -272, 144},
    { -864, -168, -72},
    { -1192, -32, -152},
    { -1232, -64, -288},
    { -1256, 0, -224},
    { -1320, -224, -120},
    { -1504, 72, -112},
    { -1616, 184, -88},
    { -1688, 264, -72},
    { -1640, 384, -32},
    { -1464, 560, -96},
    { -1312, 336, -104},
    { -1368, 488, -144},
    { -1408, 576, -16},
    { -1200, 656, -48},
    { -1256, 816, -208},
    { -912, 632, -296},
    { -936, 504, -448},
    { -1240, 472, -344},
    { -1696, 464, -208},
    { -1792, 296, -48},
    { -1696, 184, 48},
    { -1560, 144, 56},
    { -1424, 136, 64},
    { -1248, 128, 80},
    // 12 seconds
    { -1176, 144, 88},
    { -1304, -24, 240},
    { -1216, -432, 216},
    { -1024, -280, -112},
    { -1168, -176, -312},
    { -1232, -40, -328},
    { -1312, 48, -352},
    { -1200, -128, -248},
    { -1448, -8, -64},
    { -1496, 192, -136},
    { -1504, 368, -120},
    { -1392, 416, -32},
    { -1272, 440, -64},
    { -1120, 184, -192},
    { -1280, 672, 184},
    { -1520, 728, 248},
    { -1016, 872, 96},
    { -992, 888, -32},
    { -976, 664, 0},
    { -1168, 696, -200},
    { -1424, 704, -136},
    { -1784, 640, -16},
    { -1992, 616, 168},
    { -1776, 432, 448},
    { -1576, 376, 360},
    // 13 seconds
    { -1432, 208, 360},
    { -1224, 136, 320},
    { -1040, 96, 288},
    { -976, 48, 280},
    { -792, 0, 496},
    { -648, 160, 416},
    { -904, 224, 288},
    { -1224, 600, -440},
    { -832, 248, -528},
    { -1312, 624, -296},
    { -1616, 480, -192},
    { -2192, 456, 224},
    { -2264, 816, 512},
    { -1336, 1704, 328},
    { -1168, 424, 64},
    { -1456, 584, 320},
    { -1176, 248, 296},
    { -864, 352, 224},
    { -1024, 416, 240},
    { -1096, 520, 440},
    { -880, 656, 400},
    { -944, 760, 360},
    { -888, 912, 312},
    { -1272, 904, 200},
    { -1776, 728, 216},
    // 14 seconds
    { -2056, 472, 400},
    { -2056, 272, 184},
    { -1944, 264, 64},
    { -1760, 304, 96},
    { -1520, 280, 152},
    { -1280, 224, 192},
    { -1088, 184, 128},
    { -984, -32, 48},
    { -696, -416, -360},
    { -920, -464, -32},
    { -1032, 48, 88},
    { -1240, 728, -16},
    { -1336, 560, 184},
    { -1464, 384, 336},
    { -1768, 368, 256},
    { -1792, 440, 216},
    { -1624, 376, 320},
    { -1400, 656, 184},
    { -1408, 160, 112},
    { -1456, 352, 104},
    { -1408, 384, 96},
    { -1528, 344, 600},
    { -1112, 1136, 704},
    { -856, 1120, -56},
    { -808, 720, 168},
    // 15 seconds
    { -960, 568, 240},
    { -1200, 640, 328},
    { -1584, 616, 312},
    { -1880, 528, 328},
    { -1920, 352, 488},
    { -1784, 88, 480},
    { -1640, 16, 328},
    { -1424, 48, 280},
    { -1224, 120, 256},
    { -1168, 144, 232},
    { -992, -104, 168},
    { -960, -472, 56},
    { -1096, -152, -256},
    { -1240, 104, -352},
    { -1520, 184, -48},
    { -1512, 0, 192},
    { -1584, -144, 304},
    { -1792, 168, 160},
    { -1840, 440, 168},
    { -1744, 592, 328},
    { -1368, 944, 248},
    { -1168, -8, 40},
    { -1168, 56, 112},
    { -1120, 96, 448},
    { -1240, 744, 536},
    // 16 seconds
    { -1056, 1056, 336},
    { -1000, 1016, 176},
    { -880, 640, 192},
    { -1056, 440, 184},
    { -1376, 408, 224},
    { -1848, 400, 320},
    { -2168, 400, 368},
    { -2032, 208, 296},
    { -1848, 80, 368},
    { -1520, 200, 48},
    { -1440, 216, -16},
    { -1248, 128, 32},
    { -1176, -64, 80},
    { -976, -800, 48},
    { -608, -728, -16},
    { -1144, -352, -216},
    { -1464, -256, -432},
    { -1936, 48, -32},
    { -1824, 8, 56},
    { -1768, 8, 112},
    { -1720, 160, -48},
    { -1736, 288, 176},
    { -1600, 336, 224},
    { -1480, 352, 248},
    { -1368, 352, 168},
    // 17 seconds
    { -1136, 312, 128},
    { -1160, 472, 240},
    { -1048, 1136, 144},
    { -856, 584, 40},
    { -1000, 704, -8},
    { -1168, 768, -40},
    { -1688, 456, 32},
    { -1864, 160, 40},
    { -2200, 264, 48},
    { -2224, 264, 24},
    { -2080, 64, 224},
    { -1816, 208, 96},
    { -1624, 152, 96},
    { -1376, 104, 160},
    { -1168, 104, 184},
    { -992, -88, 248},
    { -888, -544, 72},
    { -608, -448, 112},
    { -1056, -328, 304},
    { -1552, -40, -128},
    { -1776, -240, 112},
    { -1920, -32, -72},
    { -2328, 208, -40},
    { -2576, 472, -48},
    { -2432, 472, 176},
    // 18 seconds
    { -1896, 1192, 72},
    { -1632, 72, -232},
    { -1720, 648, 264},
    { -1264, 512, 48},
    { -920, 528, 40},
    { -728, 648, 120},
    { -712, 664, 152},
    { -960, 736, 96},
    { -1088, 704, -16},
    { -1528, 760, -224},
    { -2064, 512, -96},
    { -2792, 80, -8},
    { -2824, -32, 96},
    { -2568, 24, 152},
    { -2256, 64, 120},
    { -1912, 16, 112},
    { -1488, 96, 112},
    { -1064, -264, 312},
    { -352, -464, -80},
    { -600, -528, 152},
    { -560, -584, -56},
    { -728, -728, -176},
    { -1448, -328, -248},
    { -1704, -160, -328},
    { -1968, 72, -472},
    // 19 seconds
    { -2088, 56, -312},
    { -2064, 488, -408},
    { -2216, 344, -144},
    { -2096, 360, 16},
    { -2064, 424, 0},
    { -1904, 376, 144},
    { -1528, 424, 168},
    { -1328, 472, 160},
    { -1248, 528, 144},
    { -856, 552, 72},
    { -768, 608, 72},
    { -768, 808, 72},
    { -792, 632, 40},
    { -1360, 584, 384},
    { -2080, 528, 536},
    { -2456, 352, 528},
    { -2336, 64, 520},
    { -1840, 128, -168},
    { -1952, 296, -56},
    { -1928, 472, -24},
    { -1584, 288, 24},
    { -1344, 160, -16},
    { -1200, 80, 64},
    { -1008, -40, 56},
    { -904, -200, -16},
    // 20 seconds
    { -776, 56, -392},
    { -768, 296, -432},
    { -888, 176, -144},
    { -1096, -80, -56},
    { -1384, -80, -112},
    { -1752, 504, -104},
    { -1944, 640, -24},
    { -1872, 632, 160},
    { -1536, 736, -96},
    { -1416, 160, -296},
    { -1600, 480, -176},
    { -1824, 632, 112},
    { -1416, 1208, 56},
    { -1176, 336, -120},
    { -736, 560, -384},
    { -768, 832, -280},
    { -1080, 848, -56},
    { -1472, 440, 48},
    { -1616, 272, 64},
    { -1544, 176, 64},
    { -1544, 192, 64},
    { -1520, 152, 96},
    { -1400, 112, 112},
    { -1296, 128, 112},
    { -1320, 120, 88},
    // 21 seconds
    { -1160, 56, -96},
    { -1096, -528, -176},
    { -1240, -8, -448},
    { -1128, -176, -400},
    { -1368, 40, -368},
    { -1336, -56, -160},
    { -1320, -32, -80},
    { -1280, 168, -56},
    { -1304, 304, 64},
    { -1344, 320, 144},
    { -1368, 352, 32},
    { -1208, 312, 72},
    { -1216, 312, -48},
    { -1368, 416, -72},
    { -1272, 608, -8},
    { -1280, 848, -72},
    { -1024, 360, -128},
    { -816, 464, -144},
    { -1048, 424, -48},
    { -1288, 312, 8},
    { -1536, 248, 16},
    { -1448, 232, 48},
    { -1360, 192, 16},
    { -1352, 208, 32},
    { -1304, 216, 16},
    // 22 seconds
    { -1232, 184, 56},
    { -1264, 104, 120},
    { -1304, -176, 128},
    { -1080, -536, -72},
    { -1240, -760, 8},
    { -1440, 88, -432},
    { -1536, 120, -392},
    { -1504, 360, -192},
    { -1400, -160, -8},
    { -1376, 48, 8},
    { -1232, 216, 48},
    { -1120, 368, 48},
    { -976, 352, -40},
    { -1056, 416, -56},
    { -928, 408, -80},
    { -1088, 392, 16},
    { -1248, 696, 64},
    { -1136, 544, -96},
    { -1240, 576, -176},
    { -1104, 520, -120},
    { -1232, 480, -72},
    { -1456, 360, 8},
    { -1640, 280, 40},
    { -1640, 264, 72},
    { -1504, 184, 120},
    // 23 seconds
    { -1368, 128, 120},
    { -1272, 112, 120},
    { -1136, 80, 120},
    { -1040, 96, 96},
    { -1056, -248, 232},
    { -824, -496, 144},
    { -936, -120, -8},
    { -1392, 128, -144},
    { -1424, 464, -568},
    { -1552, 88, -192},
    { -1472, -552, -128},
    { -1560, 0, -192},
    { -1464, 456, -48},
    { -1208, 400, 96},
    { -1104, 432, 80},
    { -1160, 336, 56},
    { -1032, 288, 136},
    { -1064, 328, 104},
    { -1256, 520, 136},
    { -848, 768, 160},
    { -1216, 768, 80},
    { -1144, 680, 32},
    { -1056, 608, -40},
    { -1432, 536, -16},
    { -1784, 424, 104},
    // 24 seconds
    { -1680, 288, 112},
    { -1496, 264, 128},
    { -1464, 264, 88},
    { -1488, 192, 160},
    { -1312, 40, 160},
    { -1136, 296, 200},
    { -1064, 136, 168},
    { -1056, 112, 208},
    { -1000, -104, -40},
    { -696, -640, 8},
    { -1184, 40, -272},
    { -1448, 296, -504},
    { -1496, 80, -416},
    { -1480, -336, 16},
    { -1480, 168, -232},
    { -1304, 288, -88},
    { -1216, 368, 120},
    { -1304, 512, 48},
    { -1272, 448, 152},
    { -1152, 480, 128},
    { -992, 488, 176},
    { -1192, 632, 288},
    { -888, 424, 296},
    { -1200, 672, 192},
    { -968, 632, 120},
    // 25 seconds
    { -872, 552, 48},
    { -1208, 600, 112},
    { -1568, 552, 288},
    { -1504, 432, 296},
    { -1376, 360, 240},
    { -1416, 304, 232},
    { -1488, 264, 264},
    { -1488, 240, 272},
    { -1376, 184, 272},
    { -1464, 72, 288},
    { -1264, -472, 136},
    { -984, -584, 0},
    { -1304, -320, -48},
    { -1368, 176, -352},
    { -1536, 320, -184},
    { -1512, 120, 32},
    { -1576, 208, 104},
    { -1520, 336, 88},
    { -1408, 336, 144},
    { -1344, 416, 160},
    { -1248, 432, 48},
    { -1192, 424, 80},
    { -976, 480, 72},
    { -976, 600, 72},
    { -848, 584, 104},
    // 26 seconds
    { -1216, 544, 104},
    { -1088, 576, 48},
    { -1000, 528, 16},
    { -1320, 520, 64},
    { -1864, 496, 168},
    { -1960, 368, 160},
    { -1720, 296, 104},
    { -1616, 8, 232},
    { -1464, 176, 144},
    { -1328, 160, 128},
    { -1200, 144, 144},
    { -1280, 32, 200},
    { -1104, -192, 232},
    { -736, -368, 24},
    { -1040, -160, -144},
    { -1168, 104, -272},
    { -1256, 184, -192},
    { -1384, 160, -72},
    { -1544, -40, 112},
    { -1648, 160, 104},
    { -1616, 400, 88},
    { -1488, 488, 176},
    { -1384, 528, 88},
    { -1352, 424, 104},
    { -1200, 304, 120},
    // 27 seconds
    { -1088, 408, 112},
    { -1056, 648, 160},
    { -1024, 624, 120},
    { -1160, 568, 88},
    { -872, 440, 8},
    { -1040, 440, -16},
    { -1592, 504, 160},
    { -1880, 368, 104},
    { -1680, 264, 88},
    { -1592, 224, 160},
    { -1592, 160, 120},
    { -1568, 192, 112},
    { -1376, 144, 96},
    { -1144, 120, 120},
    { -1096, -8, 152},
    { -856, -440, 216},
    { -696, -384, 80},
    { -1128, -72, -80},
    { -1200, 152, -192},
    { -1336, 472, -440},
    { -1472, 32, -128},
    { -1664, -208, 0},
    { -1672, 248, -216},
    { -1392, 672, -296},
    { -1176, 384, -120},
    // 28 seconds
    { -1280, 224, 0},
    { -1320, 128, 104},
    { -1176, 200, 48},
    { -1184, 304, 8},
    { -1120, 568, 80},
    { -1032, 544, 72},
    { -1224, 464, 96},
    { -952, 368, 56},
    { -1136, 384, 88},
    { -1496, 424, 264},
    { -1648, 336, 232},
    { -1568, 256, 144},
    { -1488, 168, 176},
    { -1528, 160, 192},
    { -1512, 144, 248},
    { -1328, 120, 216},
    { -1192, 128, 208},
    { -1232, -88, 248},
    { -944, -544, 128},
    { -888, -248, 40},
    { -1152, 56, -152},
    { -1360, 88, -296},
    { -1600, 64, -32},
    { -1664, 8, 56},
    { -1560, 264, -8},
    // 29 seconds
    { -1320, 312, 40},
    { -1184, 352, 32},
    { -1120, 336, 16},
    { -1088, 264, 8},
    { -1008, 240, 8},
    { -976, 296, 48},
    { -1152, 456, 160},
    { -960, 784, 208},
    { -1232, 520, 160},
    { -1264, 488, 200},
    { -1080, 528, 24},
    { -992, 584, -184},
    { -1240, 544, -88},
    { -1552, 664, 16},
    { -1568, 256, -80},
    { -1504, 232, 248},
    { -1400, 152, 152},
    { -1312, 208, 128},
    { -1144, 240, 128},
    { -936, 192, 128},
    { -1056, 352, 312},
    { -864, -192, -192},
    { -704, -608, -304},
    { -1264, -120, -288},
    { -1712, 208, -296},
    // 30 seconds
    { -1688, 352, -216},
    { -1192, 296, -400},
    { -1088, 176, -368},
    { -1168, 248, -336},
    { -1040, 176, -384},
    { -944, 160, -64},
    { -1032, 272, -48},
    { -1208, 352, 16},
    { -1008, 464, -32},
    { -944, 424, 80},
    { -1176, 624, 184},
    { -1144, 520, 88},
    { -1280, 592, 8},
    { -1128, 560, -72},
    { -1080, 576, -176},
    { -1224, 568, -168},
    { -1376, 392, -96},
    { -1376, 408, -16},
    { -1232, 272, 40},
    { -1224, 192, 88},
    { -1232, 152, 104},
    { -1176, 144, 96},
    { -1040, 96, 64},
    { -1128, 24, 80},
    { -1168, -288, 88},
    // 31 seconds
    { -1048, -328, 8},
    { -1256, -72, -184},
    { -1344, 272, -432},
    { -1344, 392, -464},
    { -1368, 64, -192},
    { -1448, -136, -88},
    { -1408, 152, -72},
    { -1200, 288, -40},
    { -1016, 336, -16},
    { -1016, 304, -32},
    { -1048, 272, -32},
    { -960, 296, 96},
    { -1000, 456, 88},
    { -1080, 480, 120},
    { -968, 528, 200},
    { -1392, 520, 104},
    { -1040, 352, 24},
    { -1192, 448, -80},
    { -1408, 384, -24},
    { -1528, 400, -24},
    { -1464, 328, -80},
    { -1160, 48, 48},
    { -1248, 112, 96},
    { -1240, 96, 64},
    { -1176, 96, 64},
    // 32 seconds
    { -1064, 96, 88},
    { -1160, -8, 72},
    { -1216, -304, 128},
    { -1272, -80, 104},
    { -1328, 80, -112},
    { -1296, 512, -512},
    { -1320, 312, -168},
    { -1304, -192, 88},
    { -1344, -40, 16},
    { -1240, 296, 16},
    { -1064, 304, 72},
    { -984, 376, 96},
    { -992, 344, -16},
    { -920, 336, 0},
    { -952, 328, 40},
    { -1208, 408, 240},
    { -1136, 624, 352},
    { -1408, 760, 144},
    { -1224, 712, 152},
    { -920, 512, 48},
    { -1160, 440, 152},
    { -1440, 352, 232},
    { -1528, 688, 696},
    { -1088, 56, 80},
    { -1216, 216, 240},
    // 33 seconds
    { -1168, 96, 216},
    { -1064, 32, 112},
    { -952, 96, 104},
    { -1000, 144, 64},
    { -1112, -176, 144},
    { -1040, -320, -16},
    { -1248, 40, -80},
    { -1384, 264, -296},
    { -1536, 592, -504},
    { -1504, 80, 64},
    { -1440, -24, 240},
    { -1272, 472, 96},
    { -896, 504, 96},
    { -816, 416, -16},
    { -904, 384, 56},
    { -880, 200, 144},
    { -744, 232, 96},
    { -848, 296, 80},
    { -1128, 360, 144},
    { -1288, 528, 224},
    { -1424, 560, 112},
    { -1088, 424, -168},
    { -1080, 632, -160},
    { -1272, 488, -88},
    { -1472, 328, -16},
    // 34 seconds
    { -1376, 304, 8},
    { -1160, 184, 72},
    { -1072, 160, 88},
    { -1056, 136, 96},
    { -1008, 112, 96},
    { -904, 144, 80},
    { -1040, 56, 72},
    { -1120, -296, 120},
    { -968, -264, 16},
    { -1160, -32, -48},
    { -1616, 280, -136},
    { -1704, 360, -192},
    { -1456, 336, -160},
    { -1392, 184, -240},
    { -1256, 440, 72},
    { -1080, 272, -40},
    { -984, 376, 96},
    { -896, 312, 88},
    { -824, 192, 56},
    { -752, 232, 56},
    { -680, 192, -16},
    { -1088, 416, 136},
    { -1080, 568, 184},
    { -1336, 904, 136},
    { -1272, 584, -80},
    // 35 seconds
    { -1144, 336, -232},
    { -1320, 328, -184},
    { -1536, 256, -184},
    { -1608, 208, -96},
    { -1464, 88, 8},
    { -1312, 64, 96},
    { -1224, 152, 96},
    { -1088, 176, 64},
    { -856, 64, 64},
    { -832, 120, 96},
    { -896, 48, -16},
    { -1048, -32, 64},
    { -616, -832, -56},
    { -1416, 56, -392},
    { -1712, 120, -232},
    { -1744, -160, -304},
    { -1472, -128, -72},
    { -1304, 320, -312},
    { -1256, 288, -208},
    { -1112, 216, -72},
    { -1024, 144, 72},
    { -1064, 216, 56},
    { -1064, 256, 120},
    { -984, 320, 176},
    { -1072, 408, 240},
    // 36 seconds
    { -1072, 688, 280},
    { -1120, 352, 168},
    { -1328, 520, 160},
    { -1104, 472, 56},
    { -1032, 560, -72},
    { -1272, 520, -104},
    { -1608, 432, -192},
    { -1392, 400, -72},
    { -1344, 192, 224},
    { -1288, 184, 232},
    { -1256, 160, 152},
    { -1176, 136, 144},
    { -1032, 136, 168},
    { -976, 48, 128},
    { -984, -112, 264},
    { -984, -464, 240},
    { -1480, 336, -184},
    { -1280, 312, -248},
    { -1232, 400, -184},
    { -1360, -48, 72},
    { -1464, 24, 144},
    { -1440, 336, 80},
    { -1352, 432, -40},
    { -1096, 344, 152},
    { -1016, 424, 200},
    // 37 seconds
    { -1000, 592, 16},
    { -832, 408, 48},
    { -792, 464, 40},
    { -976, 560, 200},
    { -984, 416, 208},
    { -1384, 520, -40},
    { -1224, 720, 80},
    { -1080, 592, 16},
    { -1184, 448, 24},
    { -1360, 448, 0},
    { -1544, 424, -112},
    { -1448, 368, 232},
    { -1384, 296, 152},
    { -1264, 184, 152},
    { -1208, 176, 184},
    { -1088, 184, 176},
    { -960, 80, 128},
    { -1016, 112, 208},
    { -912, -32, 168},
    { -992, -64, 32},
    { -1128, 280, -112},
    { -1136, 504, -368},
    { -1208, 256, -168},
    { -1392, -216, 40},
    { -1560, 216, 0},
    // 38 seconds
    { -1392, 520, -136},
    { -1184, 400, -16},
    { -1120, 448, -16},
    { -1120, 456, -16},
    { -1032, 424, 16},
    { -960, 464, 96},
    { -1048, 600, 152},
    { -1040, 576, 168},
    { -1120, 456, 104},
    { -1224, 520, 72},
    { -1056, 440, 56},
    { -1000, 416, 16},
    { -1216, 384, 104},
    { -1568, 336, 176},
    { -1584, 288, 200},
    { -1408, 192, 208},
    { -1296, 128, 192},
    { -1256, 128, 152},
    { -1160, 128, 136},
    { -1096, 152, 104},
    { -1120, 40, 72},
    { -920, -312, 48},
    { -920, -176, -80},
    { -1232, -16, -88},
    { -1392, 264, -184},
    // 39 seconds
    { -1288, 288, -216},
    { -1352, 120, -40},
    { -1480, 144, 104},
    { -1456, 376, 64},
    { -1240, 400, 48},
    { -1088, 376, 48},
    { -1040, 344, 24},
    { -1056, 280, 96},
    { -888, 240, 80},
    { -1008, 288, 80},
    { -1200, 360, 120},
    { -1112, 480, 256},
    { -1144, 536, 64},
    { -1040, 448, -88},
    { -848, 552, -104},
    { -1064, 536, 16},
    { -1360, 368, 40},
    { -1616, 360, 24},
    { -1480, 264, 8},
    { -1400, 32, 120},
    { -1304, 144, 80},
    { -1200, 136, 56},
    { -1016, 152, 56},
    { -1008, 176, 40},
    { -1024, -48, 24},
    // 40 seconds
    { -856, -312, 8},
    { -968, -88, -72},
    { -1352, 280, -240},
    { -1416, 464, -344},
    { -1216, 336, -304},
    { -1216, -24, 24},
    { -1312, 88, 64},
    { -1288, 304, 48},
    { -1136, 440, 8},
    { -1016, 408, 40},
    { -1032, 328, 96},
    { -1016, 408, 0},
    { -872, 448, -104},
    { -944, 440, -56},
    { -1088, 392, 184},
    { -1168, 584, 200},
    { -1288, 832, 48},
    { -1184, 728, -88},
    { -1024, 632, -120},
    { -1208, 472, -56},
    { -1448, 472, 32},
    { -1672, -32, -176},
    { -1624, 440, 208},
    { -1320, 192, 16},
    { -1128, 256, -16},
    // 41 seconds
    { -1136, 344, 40},
    { -864, 256, -8},
    { -792, 216, 16},
    { -816, 88, 112},
    { -928, -32, 232},
    { -1216, -8, 64},
    { -912, 328, -400},
    { -1144, 512, -328},
    { -1240, 616, -424},
    { -1736, 456, -400},
    { -1696, 184, 24},
    { -1328, 592, -48},
    { -1144, 504, 32},
    { -1272, 928, 352},
    { -1040, 232, 64},
    { -944, 232, 72},
    { -848, 232, 80},
    { -808, 248, 128},
    { -1024, 304, 216},
    { -1152, 416, 304},
    { -1232, 432, 216},
    { -1304, 544, 128},
    { -1096, 608, 64},
    { -976, 488, -16},
    { -1264, 456, 56},
    // 42 seconds
    { -1552, 384, -32},
    { -1560, 280, 208},
    { -1456, 200, 136},
    { -1376, 168, 120},
    { -1248, 120, 96},
    { -1080, 104, 104},
    { -872, 40, 128},
    { -840, 32, 128},
    { -952, 16, 128},
    { -928, -184, 64},
    { -1160, 80, 0},
    { -1200, 192, -240},
    { -1304, 440, -328},
    { -1336, 168, -224},
    { -1512, -8, 32},
    { -1544, 280, -16},
    { -1296, 528, 40},
    { -1048, 488, -24},
    { -1032, 368, -32},
    { -1064, 256, 96},
    { -1008, 208, 192},
    { -840, 264, 168},
    { -976, 264, 192},
    { -1096, 352, 288},
    { -1176, 424, 272},
    // 43 seconds
    { -1280, 352, 128},
    { -984, 440, 24},
    { -920, 544, -40},
    { -1240, 456, 120},
    { -1488, 352, 152},
    { -1448, 352, -64},
    { -1272, 96, 224},
    { -1216, 248, 96},
    { -1208, 248, 112},
    { -1112, 184, 112},
    { -1040, 136, 160},
    { -1032, 128, 104},
    { -1056, -72, -40},
    { -1024, -368, -216},
    { -1352, -520, 344},
    { -1456, 280, -48},
    { -1592, 712, -376},
    { -1552, 408, -24},
    { -1376, 184, 120},
    { -1352, 264, 160},
    { -1208, 296, 168},
    { -1096, 328, 112},
    { -1048, 248, 72},
    { -1088, 0, 400},
    { -888, 120, 496},
    // 44 seconds
    { -744, 264, 464},
    { -952, 440, 328},
    { -992, 512, 488},
    { -1344, 448, 384},
    { -1080, 256, 264},
    { -848, 512, 136},
    { -1016, 584, 176},
    { -1424, 640, 344},
    { -1664, 464, 104},
    { -1560, 152, 464},
    { -1456, 128, 320},
    { -1424, 192, 296},
    { -1304, 136, 208},
    { -1096, 136, 192},
    { -912, 96, 160},
    { -848, -40, 144},
    { -752, -216, 96},
    { -880, 16, -8},
    { -1048, 136, 16},
    { -1392, 368, -88},
    { -1448, 608, -176},
    { -1512, 176, 64},
    { -1576, 136, 176},
    { -1384, 464, 176},
    { -1160, 424, 8},
    // 45 seconds
    { -1096, 448, 256},
    { -1120, 408, 280},
    { -992, 264, 192},
    { -848, 192, 176},
    { -704, 264, 96},
    { -936, 336, 200},
    { -1136, 336, 320},
    { -1224, 712, 328},
    { -1280, 336, 56},
    { -984, 488, -16},
    { -1016, 584, -24},
    { -1328, 496, 96},
    { -1600, 472, 168},
    { -1384, 440, 224},
    { -1312, 392, 304},
    { -1296, 488, 440},
    { -1296, 456, 416},
    { -1112, 472, 416},
    { -960, 416, 416},
    { -800, 368, 424},
    { -608, 448, 344},
    { -328, 504, 320},
    { -176, 616, 328},
    { 56, 872, 456},
    { 152, 1192, 408},
    // 46 seconds
    { 128, 1144, 280},
    { 56, 904, 256},
    { 64, 672, 184},
    { 128, 544, 88},
    { 168, 392, 56},
    { 168, 256, 8},
    { 152, 136, 16},
    { 112, 72, 328},
    { -608, 376, 880},
    { -144, 1232, 840},
    { 32, 1240, 736},
    { 64, 1048, 984},
    { -8, 1408, 1048},
    { 72, 1448, 816},
    { 104, 1216, 624},
    { 72, 696, 800},
    { 0, 824, 872},
    { 0, 664, 864},
    { -24, 608, 640},
    { -8, 408, 424},
    { -32, 288, 376},
    { -48, 224, 248},
    { -56, 176, 144},
    { -112, 168, 112},
    { -280, 128, 216},
    // 47 seconds
    { -440, 288, 136},
    { -1032, 528, -16},
    { -1984, 784, 280},
    { -2712, 928, 0},
    { -2192, 472, 1120},
    { -464, 648, -552},
    { -1856, 984, -24},
    { -1272, 184, 128},
    { -936, 120, 232},
    { -680, 288, 208},
    { -696, 256, 144},
    { -728, 272, 264},
    { -808, 256, 328},
    { -784, 304, 384},
    { -912, 536, 584},
    { -952, 264, 200},
    { -1256, 472, 248},
    { -1336, 520, 168},
    { -1176, 584, 128},
    { -1240, 456, 128},
    { -1504, 448, 40},
    { -1448, 208, 320},
    { -1360, 168, 256},
    { -1296, 176, 280},
    { -1176, 168, 184},
    // 48 seconds
    { -1008, 120, 152},
    { -840, 64, 160},
    { -744, 40, 160},
    { -792, 16, 144},
    { -704, 24, 72},
    { -728, 112, 24},
    { -1016, 264, -88},
    { -1384, 536, -144},
    { -1568, 784, -424},
    { -1656, 240, 240},
    { -1496, 544, 256},
    { -1056, 152, 96},
    { -1112, 416, 136},
    { -1176, 320, 232},
    { -888, 256, 136},
    { -744, 176, 168},
    { -688, 200, 160},
    { -672, 256, 152},
    { -800, 328, 96},
    { -1088, 368, 224},
    { -1104, 456, 392},
    { -1376, 112, 152},
    { -1256, 728, -80},
    { -1104, 832, 40},
    { -1128, 608, -232},
    // 49 seconds
    { -1408, 760, -480},
    { -1472, 400, 104},
    { -1216, 200, 200},
    { -1096, 168, 120},
    { -936, 160, 112},
    { -840, 96, 120},
    { -784, 72, 152},
    { -744, 88, 168},
    { -720, 104, 144},
    { -744, 152, 88},
    { -776, 216, 16},
    { -1072, 232, 72},
    { -1520, 344, 56},
    { -1768, 984, -560},
    { -1640, 576, 8},
    { -1208, -48, 448},
    { -752, 344, 120},
    { -896, 400, 96},
    { -1248, 424, 216},
    { -968, 272, 192},
    { -760, 96, 216},
    { -640, 56, 216},
    { -640, 96, 216},
    { -672, 160, 184},
    { -760, 168, 200},
    // 50 seconds
    { -1032, 304, 176},
    { -1256, 208, 344},
    { -1664, 664, 368},
    { -1568, 96, 64},
    { -1040, 1728, -2080},
    { -1136, 320, 104},
    { -872, -248, 224},
    { -960, 608, 384},
    { -1152, 920, 208},
    { -1128, 672, 536},
    { -1048, 656, 448},
    { -896, 552, 480},
    { -672, 472, 368},
    { -536, 536, 280},
    { -424, 560, 256},
    { -304, 616, 272},
    { -128, 832, 232},
    { 0, 904, 312},
    { 192, 872, 336},
    { 304, 1088, 128},
    { 280, 1008, 40},
    { 144, 864, 64},
    { 88, 776, 112},
    { 104, 728, 168},
    { 136, 672, 176},
    // 51 seconds
    { 176, 552, 136},
    { 216, 392, 96},
    { 240, 336, 40},
    { 248, 248, 136},
    { 200, 488, 408},
    { 224, 968, 688},
    { 280, 1104, 728},
    { 224, 1088, 816},
    { 216, 1224, 880},
    { 192, 1232, 712},
    { 176, 792, 600},
    { 200, 560, 568},
    { 200, 680, 520},
    { 104, 784, 624},
    { 64, 688, 496},
    { 32, 552, 336},
    { 0, 408, 200},
    { -48, 304, 144},
    { -120, 216, 112},
    { -264, 160, 96},
    { -528, 208, 144},
    { -952, 344, 232},
    { -1440, 160, 304},
    { -2896, 856, 328},
    { -2544, 536, 424},
    // 52 seconds
    { -1328, 1272, -272},
    { -728, -144, 176},
    { -1200, 536, 312},
    { -1120, 408, 120},
    { -1008, 136, 128},
    { -744, 136, 200},
    { -608, 96, 232},
    { -648, 64, 240},
    { -736, 88, 304},
    { -800, 208, 216},
    { -912, 328, 168},
    { -1176, 320, 216},
    { -1136, 552, 416},
    { -1200, 528, -216},
    { -1480, 880, -424},
    { -856, 1200, -1872},
    { -1216, 152, -104},
    { -1048, -72, 112},
    { -1120, 304, 80},
    { -1232, 528, 152},
    { -888, 320, 240},
    { -856, 304, 312},
    { -912, 240, 280},
    { -888, 200, 256},
    { -800, 240, 144},
    // 53 seconds
    { -784, 184, 224},
    { -944, 88, 568},
    { 168, 32, -288},
    { -1392, 392, -24},
    { -2056, 416, 424},
    { -1432, 584, 616},
    { -888, 1672, -16},
    { -520, 752, 376},
    { -920, 552, 144},
    { -1192, 352, 208},
    { -1032, 200, 232},
    { -816, 104, 240},
    { -688, 40, 232},
    { -680, 72, 208},
    { -640, 104, 224},
    { -592, 72, 216},
    { -896, 192, 224},
    { -1280, 352, 320},
    { -1744, 256, 768},
    { -1336, 608, 704},
    { -1016, 832, -232},
    { -968, 696, 16},
    { -960, 824, -144},
    { -1280, 568, 312},
    { -1016, 552, 800},
    // 54 seconds
    { -752, 288, 128},
    { -752, 232, 72},
    { -888, 184, 208},
    { -904, 72, 232},
    { -864, 72, 216},
    { -1008, 72, 200},
    { -1128, 88, 232},
    { -1360, -80, 240},
    { -1392, 256, 80},
    { -1120, 384, 0},
    { -984, 216, 128},
    { -960, 360, -8},
    { -1040, 736, -264},
    { -1160, 480, 16},
    { -896, 328, 160},
    { -736, 304, 104},
    { -744, 280, 24},
    { -856, 344, 96},
    { -792, 248, 128},
    { -728, 272, 136},
    { -1016, 264, 128},
    { -1192, 440, 304},
    { -1424, 632, 264},
    { -1368, 648, 112},
    { -992, 536, 184},
    // 55 seconds
    { -1032, 456, 192},
    { -1208, 336, 264},
    { -1376, 328, 264},
    { -1176, 224, 280},
    { -1040, 184, 248},
    { -1040, 184, 200},
    { -1032, 200, 160},
    { -912, 208, 72},
    { -744, -48, -88},
    { -656, -200, -232},
    { -896, -80, -56},
    { -1336, 208, 0},
    { -1752, 352, -176},
    { -1680, 592, 24},
    { -1392, 248, 216},
    { -1104, 440, 312},
    { -1200, 288, 48},
    { -1264, 328, 136},
    { -1096, 256, 160},
    { -864, 208, 184},
    { -824, 208, 176},
    { -848, 240, 192},
    { -736, 200, 288},
    { -896, 224, 376},
    { -1112, 904, 1008},
    // 56 seconds
    { -1160, -112, 184},
    { -1232, 520, 64},
    { -1040, 440, 184},
    { -1288, 544, 376},
    { -1504, 336, 376},
    { -1552, 296, 264},
    { -1328, 264, 264},
    { -1256, 200, 304},
    { -1256, 112, 288},
    { -1240, 112, 256},
    { -1080, 112, 184},
    { -1008, 88, 104},
    { -936, -432, -72},
    { -912, -200, -128},
    { -1112, 48, -144},
    { -1600, 264, -104},
    { -1496, 656, -192},
    { -1592, 200, 264},
    { -1528, 16, 368},
    { -1352, 240, 272},
    { -1056, 376, 200},
    { -944, 360, 176},
    { -1024, 280, 192},
    { -1120, 168, 256},
    { -1008, 192, 248},
    // 57 seconds
    { -880, 232, 304},
    { -1032, 328, 440},
    { -936, 752, 824},
    { -1184, 72, 384},
    { -992, 584, 288},
    { -1064, 672, 240},
    { -1440, 504, 464},
    { -1760, 328, 440},
    { -1496, 336, 336},
    { -1328, 184, 336},
    { -1320, 192, 488},
    { -1392, 88, 416},
    { -1280, 80, 344},
    { -1088, 104, 232},
    { -984, 56, 200},
    { -840, -368, -32},
    { -856, 0, -296},
    { -1104, 128, -176},
    { -1392, 376, -64},
    { -1528, 208, 112},
    { -1808, -56, 344},
    { -1840, 312, 424},
    { -1528, 440, 312},
    { -1128, 480, 336},
    { -1072, 368, 320},
    // 58 seconds
    { -1080, 200, 384},
    { -1072, 160, 408},
    { -880, 184, 392},
    { -848, 136, 200},
    { -1080, 312, 624},
    { -936, 600, 816},
    { -1136, 296, 728},
    { -960, 456, 432},
    { -1040, 632, 288},
    { -1264, 592, 344},
    { -1616, 512, 504},
    { -1704, 440, 480},
    { -1408, 416, 296},
    { -1400, 320, 312},
    { -1384, 240, 344},
    { -1240, 192, 296},
    { -1088, 152, 280},
    { -1032, 136, 288},
    { -952, 216, 168},
    { -832, 8, -48},
    { -1088, 640, 120},
    { -960, -200, 152},
    { -1448, 928, -120},
    { -1512, 520, 176},
    { -1520, 408, 160},
    // 59 seconds
    { -1480, 368, 200},
    { -1152, 200, 416},
    { -1136, 432, 320},
    { -1224, 384, 328},
    { -1216, 352, 400},
    { -1104, 392, 424},
    { -1088, 488, 520},
    { -872, 656, 552},
    { -736, 560, 496},
    { -992, 544, 440},
    { -960, 504, 432},
    { -1032, 576, 312},
    { -1368, 512, 192},
    { -1648, 616, 184},
    { -1552, 608, 80},
    { -1376, 392, 256},
    { -1472, 368, 96},
    { -1384, -16, 400},
    { -1240, 64, 256},
    { -1016, 72, 176},
    { -872, 56, 192},
    { -848, -200, 120},
    { -704, -208, 32},
    { -1104, 8, -8},
    { -1440, 216, 80},
    // 60 seconds
    // elapsed: 1 minutes
    { -1496, 608, -80},
    { -1472, 528, -136},
    { -1512, 96, 184},
    { -1544, 72, 248},
    { -1384, 416, 264},
    { -1200, 440, 240},
    { -1152, 328, 312},
    { -1192, 376, 248},
    { -1176, 344, 304},
    { -1056, 416, 392},
    { -936, 576, 504},
    { -768, 304, 384},
    { -1144, 472, 376},
    { -1184, 488, 368},
    { -1088, 408, 216},
    { -1288, 472, 152},
    { -1568, 464, 224},
    { -1784, 352, 208},
    { -1704, 384, 240},
    { -1648, 208, 208},
    { -1632, 136, 344},
    { -1456, 112, 272},
    { -1192, 144, 208},
    { -1048, 128, 120},
    { -832, -240, -32},
    // 61 seconds
    { -584, -336, -32},
    { -784, 112, -112},
    { -1168, 224, -128},
    { -1208, 368, -88},
    { -1272, 272, -8},
    { -1632, 96, 208},
    { -1776, 160, 344},
    { -1608, 416, 312},
    { -1208, 104, 864},
    { -1368, 560, 480},
    { -1656, 48, 784},
    { -1280, 168, 488},
    { -1048, 96, 432},
    { -984, 128, 424},
    { -1040, 168, 496},
    { -928, 312, 600},
    { -1200, 328, 552},
    { -1008, 208, 408},
    { -960, 488, 264},
    { -1024, 488, 304},
    { -1400, 568, 456},
    { -1568, 408, 408},
    { -1608, 208, 384},
    { -1616, 48, 512},
    { -1608, 8, 352},
    // 62 seconds
    { -1496, 88, 304},
    { -1288, 64, 280},
    { -1184, 56, 224},
    { -1112, -80, 280},
    { -984, -232, 200},
    { -1024, -288, 40},
    { -984, 400, -240},
    { -944, 384, -200},
    { -1352, 528, -160},
    { -1672, 184, 216},
    { -1664, 128, 384},
    { -1456, 400, 376},
    { -1216, 416, 416},
    { -1160, 552, 144},
    { -1344, 176, 232},
    { -1256, 184, 360},
    { -1144, 200, 328},
    { -1152, 200, 480},
    { -912, 448, 776},
    { -1160, 512, 432},
    { -952, 272, 368},
    { -1056, 576, 344},
    { -1264, 568, 408},
    { -1608, 440, 344},
    { -1568, 392, 136},
    // 63 seconds
    { -1600, 224, 264},
    { -1672, 120, 264},
    { -1624, 88, 272},
    { -1432, 104, 296},
    { -1192, 80, 224},
    { -1056, -8, 104},
    { -856, -488, 48},
    { -952, -112, -120},
    { -1216, -264, 56},
    { -1368, 200, -24},
    { -1432, 432, -136},
    { -1448, 232, 104},
    { -1520, -32, 344},
    { -1480, 248, 288},
    { -1336, 400, 240},
    { -1224, 448, 232},
    { -1256, 392, 240},
    { -1264, 320, 248},
    { -1168, 312, 288},
    { -1064, 512, 504},
    { -896, 904, 592},
    { -944, 728, 704},
    { -1112, 704, 624},
    { -1048, 624, 456},
    { -1272, 576, 368},
    // 64 seconds
    { -1640, 456, 448},
    { -1920, 432, 504},
    { -2072, 256, 584},
    { -1688, 200, 560},
    { -1536, 48, 528},
    { -1336, -40, 440},
    { -1032, 8, 288},
    { -600, -168, 248},
    { -760, -368, -328},
    { -608, -240, -232},
    { -952, -256, 16},
    { -1568, -64, 120},
    { -1656, 272, 40},
    { -1848, 168, 184},
    { -1720, 264, 528},
    { -1576, 712, 256},
    { -1392, 640, 184},
    { -1312, 344, 248},
    { -1280, 232, 360},
    { -1344, 192, 384},
    { -1232, 232, 400},
    { -976, 240, 472},
    { -952, 216, 544},
    { -936, 592, 856},
    { -728, 168, 584},
    // 65 seconds
    { -1072, 296, 632},
    { -1040, 512, 568},
    { -984, 528, 424},
    { -1376, 672, 544},
    { -2024, 456, 456},
    { -2008, 304, 552},
    { -1936, -64, 416},
    { -1712, 56, 392},
    { -1536, 160, 288},
    { -1376, 256, 288},
    { -1192, 232, 224},
    { -1000, -8, 176},
    { -624, -344, -8},
    { -720, -40, -152},
    { -848, -144, 24},
    { -1168, 248, 32},
    { -1296, 280, 8},
    { -1488, 536, 176},
    { -1632, 208, 504},
    { -1600, 536, 440},
    { -1344, 456, 328},
    { -1240, 504, 216},
    { -1328, 352, 232},
    { -1424, 208, 368},
    { -1272, 232, 376},
    // 66 seconds
    { -1168, 328, 432},
    { -1144, 592, 552},
    { -888, 632, 376},
    { -1104, 488, 312},
    { -968, 456, 320},
    { -928, 496, 224},
    { -1160, 480, 248},
    { -1416, 336, 280},
    { -1592, 216, 288},
    { -1432, 192, 232},
    { -1408, 216, 240},
    { -1472, 208, 248},
    { -1472, 192, 248},
    { -1264, 136, 208},
    { -1080, 112, 192},
    { -1024, 24, -24},
    { -680, -472, -224},
    { -968, 136, -200},
    { -1272, 320, -120},
    { -1440, 664, -232},
    { -1424, 368, 32},
    { -1504, -136, 328},
    { -1464, 136, 384},
    { -1304, 392, 288},
    { -1200, 360, 248},
    // 67 seconds
    { -1208, 368, 272},
    { -1232, 176, 336},
    { -1264, 144, 376},
    { -1200, 200, 384},
    { -1216, 200, 480},
    { -1248, 448, 880},
    { -664, 376, 296},
    { -928, 440, 240},
    { -936, 584, 264},
    { -1008, 496, 192},
    { -1248, 464, 248},
    { -1480, 408, 288},
    { -1456, 304, 232},
    { -1368, 248, 232},
    { -1440, 224, 216},
    { -1504, 184, 240},
    { -1448, 136, 288},
    { -1232, 112, 240},
    { -1192, -64, 144},
    { -976, -432, -32},
    { -984, 8, -224},
    { -1272, -136, -72},
    { -1416, 232, -144},
    { -1240, 184, -56},
    { -1232, -16, 120},
    // 68 seconds
    { -1312, 80, 168},
    { -1368, 304, 112},
    { -1280, 312, 152},
    { -1176, 288, 248},
    { -1176, 256, 232},
    { -1240, 344, 200},
    { -1168, 416, 208},
    { -1040, 488, 272},
    { -1032, 600, 384},
    { -1040, 608, 224},
    { -1224, 600, 312},
    { -1088, 424, 232},
    { -1032, 392, 160},
    { -1192, 352, 216},
    { -1496, 320, 248},
    { -1568, 288, 264},
    { -1360, 160, 304},
    { -1288, 80, 296},
    { -1288, 56, 264},
    { -1232, 56, 240},
    { -1152, 40, 240},
    { -1168, 48, 232},
    { -992, -120, 8},
    { -632, -376, 8},
    { -1168, 72, 56},
    // 69 seconds
    { -1328, 432, -32},
    { -1144, 424, -160},
    { -1168, 368, 56},
    { -1352, 216, 128},
    { -1352, 328, 120},
    { -1224, 376, 152},
    { -1152, 408, 168},
    { -1160, 360, 208},
    { -1192, 336, 248},
    { -1144, 360, 240},
    { -936, 344, 296},
    { -1016, 568, 408},
    { -904, 528, 432},
    { -1168, 504, 360},
    { -1176, 480, 200},
    { -952, 552, 336},
    { -1096, 448, 312},
    { -1344, 368, 384},
    { -1560, 384, 400},
    { -1424, 248, 440},
    { -1288, 88, 416},
    { -1272, 48, 400},
    { -1280, 88, 320},
    { -1104, 96, 272},
    { -1000, 40, 232},
    // 70 seconds
    { -968, 80, 216},
    { -792, -128, 72},
    { -1144, 344, -480},
    { -1160, 192, -296},
    { -1296, 496, -184},
    { -1296, 376, -72},
    { -1376, 320, 40},
    { -1456, 48, 128},
    { -1344, 496, 120},
    { -1160, 432, 168},
    { -1120, 272, 224},
    { -1136, 304, 224},
    { -1136, 360, 224},
    { -1016, 264, 240},
    { -848, 312, 312},
    { -800, 552, 328},
    { -848, 448, 304},
    { -1368, 440, 384},
    { -1216, 440, 360},
    { -960, 488, 224},
    { -1136, 496, 192},
    { -1312, 432, 232},
    { -1536, 384, 296},
    { -1512, 328, 368},
    { -1392, 104, 312},
    // 71 seconds
    { -1336, 112, 296},
    { -1232, 104, 256},
    { -1032, 104, 216},
    { -928, 144, 128},
    { -992, -24, 32},
    { -816, -288, -72},
    { -880, -48, 0},
    { -1240, 240, -24},
    { -1400, 528, -120},
    { -1312, 544, -16},
    { -1432, 200, 288},
    { -1520, 112, 424},
    { -1352, 352, 280},
    { -1096, 368, 320},
    { -1128, 320, 320},
    { -1016, 264, 104},
    { -960, 40, 168},
    { -768, 120, 160},
    { -744, 264, 240},
    { -1032, 272, 336},
    { -1064, 848, 728},
    { -1200, 152, 184},
    { -1328, 576, 96},
    { -1064, 504, 136},
    { -1096, 528, 208},
    // 72 seconds
    { -1296, 368, 208},
    { -1544, 304, 240},
    { -1496, 200, 288},
    { -1336, 80, 312},
    { -1256, 24, 280},
    { -1200, 64, 248},
    { -1064, 40, 224},
    { -896, 64, 184},
    { -840, 32, 176},
    { -824, -88, 144},
    { -728, -56, 104},
    { -896, 112, 64},
    { -1160, 360, -104},
    { -1288, 688, -320},
    { -1464, 128, 104},
    { -1728, 80, 296},
    { -1648, 696, 80},
    { -1128, 376, 344},
    { -976, 192, 16},
    { -1160, 296, 1128},
    { -1064, 416, 216},
    { -904, 248, 184},
    { -736, 232, 168},
    { -840, 304, 248},
    { -1056, 384, 520},
    // 73 seconds
    { -1056, 496, 440},
    { -1248, 336, 176},
    { -1232, 376, 240},
    { -1072, 496, 216},
    { -1064, 432, 136},
    { -1296, 328, 208},
    { -1512, 360, 256},
    { -1448, 168, 352},
    { -1312, 40, 336},
    { -1224, 80, 272},
    { -1144, 88, 256},
    { -1008, 128, 208},
    { -888, 96, 184},
    { -936, 16, 104},
    { -808, -208, 16},
    { -952, 64, 40},
    { -1208, 216, 16},
    { -1216, 576, -96},
    { -1360, 320, 0},
    { -1632, 168, 216},
    { -1496, 344, 200},
    { -1184, 480, 152},
    { -1040, 392, 128},
    { -1016, 296, 168},
    { -1040, 232, 208},
    // 74 seconds
    { -984, 192, 232},
    { -856, 216, 240},
    { -808, 168, 280},
    { -1072, 272, 360},
    { -1040, 408, 656},
    { -1184, 368, 240},
    { -1176, 432, 176},
    { -1064, 488, 264},
    { -1160, 496, 168},
    { -1408, 408, 200},
    { -1616, 312, 280},
    { -1464, 248, 320},
    { -1312, 112, 264},
    { -1296, 96, 264},
    { -1240, 88, 240},
    { -1072, 72, 208},
    { -1000, 24, 200},
    { -1072, -128, 176},
    { -808, -296, 128},
    { -1024, -96, 136},
    { -1160, 248, -48},
    { -1168, 568, -192},
    { -1272, 576, -80},
    { -1528, 128, 264},
    { -1616, 344, 312},
    // 75 seconds
    { -1392, 528, 312},
    { -1056, 496, 376},
    { -1000, 416, 48},
    { -1128, 400, 152},
    { -1064, 264, 248},
    { -856, 216, 216},
    { -808, 280, 248},
    { -944, 328, 376},
    { -1000, 664, 472},
    { -1208, 368, 272},
    { -1168, 472, 224},
    { -1088, 464, 192},
    { -1232, 368, 128},
    { -1392, 312, 320},
    { -1648, 232, 192},
    { -1464, 224, 480},
    { -1248, 16, 368},
    { -1192, 160, 344},
    { -1152, 136, 336},
    { -1024, 200, 272},
    { -920, 112, 248},
    { -760, -32, 304},
    { -648, -224, -264},
    { -784, 104, -336},
    { -1256, 272, 88},
    // 76 seconds
    { -1664, 448, 240},
    { -1640, 648, 80},
    { -1576, 280, 192},
    { -1352, 408, 400},
    { -1200, 520, 352},
    { -1240, 328, 272},
    { -1096, 352, 216},
    { -944, 272, 232},
    { -904, 296, 264},
    { -864, 312, 304},
    { -776, 328, 272},
    { -640, 528, 448},
    { -752, 448, 288},
    { -1024, 184, 416},
    { -1512, 544, 352},
    { -1320, 568, 240},
    { -1160, 512, 200},
    { -1200, 416, 224},
    { -1384, 336, 264},
    { -1528, 424, 392},
    { -1600, 232, 376},
    { -1408, 112, 424},
    { -1160, -168, 448},
    { -1032, 104, 488},
    { -1072, 576, 496},
    // 77 seconds
    { -1072, 808, 672},
    { -968, 912, 984},
    { -584, 1048, 984},
    { -248, 1000, 728},
    { -32, 920, 600},
    { 256, 816, 144},
    { -16, 496, -32},
    { 0, 304, -216},
    { 120, 480, -264},
    { 248, 408, -256},
    { 416, 376, -296},
    { 464, 512, -344},
    { 456, 496, -384},
    { 424, 496, -440},
    { 416, 696, -448},
    { 408, 512, -400},
    { 456, 640, -128},
    { 480, 808, -152},
    { 416, 840, -352},
    { 296, 784, -552},
    { 192, 736, -704},
    { 328, 976, -584},
    { 416, 920, -416},
    { 368, 528, -344},
    { 328, 416, -384},
    // 78 seconds
    { 256, 592, -576},
    { 80, 864, -720},
    { 136, 880, -440},
    { 160, 392, -200},
    { 96, 112, -416},
    { -32, 704, -632},
    { -200, 544, -760},
    { 16, 448, -640},
    { 56, 552, -576},
    { 184, 616, -928},
    { -72, 568, -1136},
    { -96, 1032, -848},
    { -176, 1168, -640},
    { -248, 1008, -408},
    { -360, 552, -64},
    { -216, 560, 144},
    { -80, 672, 56},
    { -200, 680, -424},
    { -264, 1088, -856},
    { -192, 536, -656},
    { -176, 304, -600},
    { -208, 456, -776},
    { -168, 416, -864},
    { -424, 320, -168},
    { -456, 1160, 24},
    // 79 seconds
    { -144, 1360, 0},
    { 80, 1408, 8},
    { 200, 1344, -392},
    { 240, 896, -696},
    { 240, 600, -568},
    { 64, 464, -504},
    { -112, 648, -288},
    { -240, 736, -400},
    { -208, 744, -440},
    { -160, 472, -432},
    { -120, 848, -592},
    { -56, 752, -696},
    { 40, 568, -752},
    { 136, 496, -600},
    { 200, 608, -640},
    { 104, 680, -896},
    { -16, 456, -1152},
    { -112, 680, -1360},
    { -152, 528, -1128},
    { -232, 416, -744},
    { -136, 480, -688},
    { 104, 464, -736},
    { 208, 240, -720},
    { 320, 160, -784},
    { 304, -24, -896},
    // 80 seconds
    { 224, 16, -768},
    { 120, -192, -800},
    { 128, 216, -888},
    { -48, -128, -752},
    { -16, 208, -976},
    { -56, 160, -1112},
    { -216, -400, -1448},
    { 8, -624, -1088},
    { 256, 264, -1056},
    { 128, -808, -728},
    { 112, -112, -872},
    { 64, -240, -784},
    { -112, 200, -840},
    { -96, 304, -912},
    { 40, 248, -704},
    { 232, -8, -584},
    { 288, -384, -400},
    { 168, -16, -840},
    { 120, 272, -1024},
    { 192, 672, -1072},
    { 112, 600, -776},
    { -88, 920, -832},
    { 168, 992, -136},
    { 128, 568, -208},
    { 448, 696, -312},
    // 81 seconds
    { 216, 952, -32},
    { 96, 696, 224},
    { 304, 760, 208},
    { 168, 776, 424},
    { 536, 688, 344},
    { 248, 544, 496},
    { 440, 424, 392},
    { 312, 544, 360},
    { 312, 600, 600},
    { 248, 704, 768},
    { 184, 1096, 1696},
    { 56, 1632, 1584},
    { 200, 1368, 1432},
    { 304, 1144, 856},
    { 144, 992, 696},
    { -8, 824, 448},
    { -64, 688, 272},
    { -80, 552, 328},
    { -144, 408, 216},
    { -168, 320, 128},
    { -64, 248, 104},
    { -160, 40, -16},
    { -368, -416, 24},
    { -888, 352, -8},
    { -1752, 304, 128},
    // 82 seconds
    { -2984, -24, 208},
    { -2840, 864, 16},
    { -1232, 1048, 480},
    { -1424, 992, 32},
    { -1304, 264, 72},
    { -1328, 312, 168},
    { -984, 216, 192},
    { -808, 224, 168},
    { -888, 264, 232},
    { -920, 304, 256},
    { -760, 472, 280},
    { -616, 408, 240},
    { -784, 464, 200},
    { -960, 472, 216},
    { -1376, 464, 224},
    { -1584, 496, 232},
    { -1280, 392, 96},
    { -1472, 448, 72},
    { -1712, 360, 48},
    { -1720, 456, 200},
    { -1552, 144, 360},
    { -1264, 112, 304},
    { -1176, 112, 264},
    { -1032, 48, 200},
    { -856, 24, 216},
    // 83 seconds
    { -712, 48, 144},
    { -656, -184, 8},
    { -528, -288, -8},
    { -768, 192, 24},
    { -1048, 128, 16},
    { -1432, 312, 16},
    { -1632, 776, -120},
    { -1768, 456, 0},
    { -1888, 448, 144},
    { -1208, 752, 144},
    { -1088, 184, 32},
    { -1200, 368, 296},
    { -1088, 240, 344},
    { -928, 272, 184},
    { -840, 208, 232},
    { -688, 176, 288},
    { -688, 272, 256},
    { -944, 544, 536},
    { -1224, 568, 480},
    { -1344, 344, 248},
    { -1072, 584, 112},
    { -1312, 592, 272},
    { -1608, 416, 424},
    { -1648, 288, 248},
    { -1328, 240, 352},
    // 84 seconds
    { -1264, 56, 360},
    { -1304, 192, 344},
    { -1320, 200, 280},
    { -1128, 192, 248},
    { -1008, 24, 232},
    { -1016, 0, 176},
    { -960, 64, -48},
    { -832, 136, -16},
    { -1016, 160, 160},
    { -960, 544, 88},
    { -1128, 616, 8},
    { -1520, -112, 216},
    { -1880, -16, 328},
    { -1720, 496, 232},
    { -1344, 408, 312},
    { -1168, 384, 144},
    { -1296, 320, 200},
    { -1208, 240, 296},
    { -920, 224, 272},
    { -880, 296, 296},
    { -936, 448, 440},
    { -1032, 600, 384},
    { -1208, 560, 232},
    { -1096, 592, 40},
    { -1168, 816, 32},
    // 85 seconds
    { -1584, 800, 304},
    { -1944, 304, 312},
    { -1880, 232, 248},
    { -1784, 160, 248},
    { -1688, 280, 200},
    { -1496, 256, 208},
    { -1184, 168, 208},
    { -952, 112, 184},
    { -808, 64, 192},
    { -648, 32, 112},
    { -384, 208, 64},
    { -336, 560, 432},
    { -128, 1288, 600},
    { 168, 1392, 592},
    { 288, 1176, 568},
    { 96, 1008, 472},
    { 80, 824, 416},
    { 184, 624, 400},
    { 304, 528, 344},
    { 336, 368, 408},
    { 384, 280, 416},
    { 432, 352, 416},
    { 448, 384, 488},
    { -1784, 552, 848},
    { 520, 608, 672},
    // 86 seconds
    { 328, 712, 872},
    { 360, 960, 1040},
    { 392, 888, 944},
    { 544, 672, 640},
    { 464, 488, 656},
    { 488, 424, 624},
    { 272, 384, 408},
    { 128, 224, 296},
    { -16, 256, 200},
    { -136, 272, 160},
    { -288, 224, 152},
    { -496, 184, 160},
    { -784, 112, 96},
    { -3088, -152, 432},
    { -1992, 656, 288},
    { -2096, -200, 728},
    { -1736, 672, -160},
    { -1776, 904, 80},
    { -856, 400, 184},
    { -712, 376, 192},
    { -960, 288, 144},
    { -1048, 240, 104},
    { -968, 160, 344},
    { -664, 32, 232},
    { -736, 88, 280},
    // 87 seconds
    { -776, 88, 272},
    { -672, 224, 216},
    { -736, 240, 240},
    { -1016, 336, 216},
    { -1304, 448, 368},
    { -1624, 584, 248},
    { -1232, 544, 120},
    { -1336, 696, -352},
    { -1616, 608, -56},
    { -1376, -72, 280},
    { -992, 216, 216},
    { -888, 448, 208},
    { -888, 48, 264},
    { -912, 64, 320},
    { -856, 24, 280},
    { -800, 24, 240},
    { -808, 0, 272},
    { -808, -24, 272},
    { -720, -160, 336},
    { -1312, 248, 400},
    { -1264, 392, 248},
    { -1312, 560, 208},
    { -1288, 648, 224},
    { -1352, 408, 328},
    { -1200, 704, 288},
    // 88 seconds
    { -992, 416, 336},
    { -928, 456, 168},
    { -936, 152, 232},
    { -928, 160, 264},
    { -840, 144, 224},
    { -760, 144, 280},
    { -720, 152, 320},
    { -824, 248, 264},
    { -1040, 272, 400},
    { -1216, 304, 512},
    { -1344, 304, 296},
    { -1256, 328, 264},
    { -1080, 360, 168},
    { -1192, 344, 8},
    { -1320, 552, 128},
    { -1296, 96, 296},
    { -1184, -64, 392},
    { -984, 144, 168},
    { -944, 144, 160},
    { -896, 56, 200},
    { -800, 56, 184},
    { -784, 88, 168},
    { -976, 88, 168},
    { -1000, -40, 128},
    { -1256, 0, 88},
    // 89 seconds
    { -1368, 376, -56},
    { -1392, 496, -104},
    { -1192, 440, -48},
    { -1168, 144, 120},
    { -1216, 336, 48},
    { -1232, 272, 64},
    { -1072, 272, 104},
    { -944, 272, 120},
    { -904, 304, 96},
    { -864, 336, 120},
    { -784, 280, 176},
    { -752, 288, 320},
    { -864, 568, 408},
    { -944, 120, 240},
    { -1528, 368, 304},
    { -1432, 336, 240},
    { -1360, 360, 136},
    { -1184, 360, 120},
    { -1304, 288, 112},
    { -1392, 240, 168},
    { -1312, 104, 232},
    { -1240, 72, 224},
    { -1152, 80, 192},
    { -1008, 112, 128},
    { -864, 96, 112},
    // 90 seconds
    { -728, 112, 0},
    { -728, -128, -120},
    { -872, -192, -168},
    { -984, 80, -168},
    { -1528, 72, -8},
    { -1584, 408, -88},
    { -1432, 264, 24},
    { -1280, 112, 144},
    { -1400, 208, 144},
    { -1536, 304, 120},
    { -1288, 296, 184},
    { -1032, 328, 120},
    { -952, 312, 136},
    { -920, 328, 176},
    { -792, 368, 280},
    { -632, 384, 280},
    { -680, 488, 304},
    { -848, 416, 272},
    { -1328, 368, 296},
    { -1664, 216, 240},
    { -1616, 280, 192},
    { -1432, 448, 0},
    { -1544, 576, 64},
    { -1592, -8, 384},
    { -1304, 152, 264},
    // 91 seconds
    { -1096, 136, 208},
    { -992, 72, 208},
    { -904, 24, 208},
    { -792, 8, 176},
    { -736, 48, 72},
    { -688, -264, -40},
    { -800, -104, -40},
    { -824, 32, -80},
    { -1320, 88, 72},
    { -1760, 520, -32},
    { -1856, 440, -24},
    { -1768, 392, 120},
    { -1424, 632, 216},
    { -976, 176, 104},
    { -1024, 440, 128},
    { -1080, 192, 256},
    { -936, 200, 184},
    { -792, 136, 232},
    { -656, 152, 240},
    { -752, 176, 272},
    { -1080, 360, 320},
    { -1080, 432, 712},
    { -1072, 168, 288},
    { -1264, 640, 136},
    { -1368, 472, 160},
    // 92 seconds
    { -1208, 520, 88},
    { -1376, 448, 96},
    { -1544, 432, 280},
    { -1416, 168, 272},
    { -1256, 56, 304},
    { -1184, 80, 256},
    { -1120, 88, 224},
    { -976, 96, 184},
    { -824, 64, 72},
    { -696, -208, 0},
    { -720, -144, 24},
    { -696, 40, -40},
    { -1144, 120, 32},
    { -1640, 464, 16},
    { -1648, 648, -80},
    { -1536, 232, 208},
    { -1440, 232, 336},
    { -1304, 464, 216},
    { -1192, 328, 136},
    { -1112, 248, 272},
    { -984, 136, 144},
    { -928, 104, 296},
    { -904, 56, 184},
    { -704, 200, 400},
    { -784, 240, 288},
    // 93 seconds
    { -936, 256, 456},
    { -1128, 704, 864},
    { -1352, 1120, 216},
    { -1216, 680, 336},
    { -1120, 464, 216},
    { -1192, 432, 168},
    { -1488, 288, 200},
    { -1600, 344, 296},
    { -1432, 24, 336},
    { -1288, 192, 312},
    { -1240, 112, 304},
    { -1152, 56, 288},
    { -968, 72, 240},
    { -840, 96, 160},
    { -768, -152, 40},
    { -688, -216, -24},
    { -632, 48, -88},
    { -1000, 88, 88},
    { -1496, 384, 120},
    { -1648, 528, 56},
    { -1480, 288, 40},
    { -1464, 240, 208},
    { -1304, 696, 152},
    { -1232, 272, 160},
    { -1216, 288, 168},
    // 94 seconds
    { -1112, 200, 248},
    { -992, 272, 184},
    { -904, 216, 200},
    { -736, 176, 304},
    { -720, 264, 256},
    { -992, 344, 376},
    { -1224, 384, 480},
    { -1328, 376, 336},
    { -1184, 416, 216},
    { -1032, 408, 128},
    { -1168, 352, 120},
    { -1440, 368, 144},
    { -1680, 368, 80},
    { -1528, 280, 368},
    { -1280, -24, 320},
    { -1144, 56, 224},
    { -1040, 72, 192},
    { -904, 88, 184},
    { -832, 104, 128},
    { -776, -88, 56},
    { -720, -120, 104},
    { -968, -40, 144},
    { -1272, 144, 144},
    { -1528, 520, 16},
    { -1424, 744, -112},
    // 95 seconds
    { -1432, 64, 344},
    { -1400, 264, 264},
    { -1320, 520, 56},
    { -1184, 344, 128},
    { -1080, 264, 208},
    { -936, 192, 200},
    { -872, 192, 208},
    { -776, 192, 216},
    { -744, 192, 248},
    { -920, 240, 280},
    { -1160, 288, 408},
    { -1288, 496, 600},
    { -1272, 472, 216},
    { -1024, 616, 208},
    { -1000, 568, 272},
    { -1160, 408, 216},
    { -1352, 344, 232},
    { -1608, 344, 312},
    { -1624, 176, 336},
    { -1416, 56, 344},
    { -1264, 24, 296},
    { -1136, 96, 216},
    { -936, -24, 288},
    { -840, 232, 152},
    { -832, 264, 8},
    // 96 seconds
    { -672, -96, -48},
    { -448, -8, -88},
    { -768, 232, -96},
    { -1168, 288, 16},
    { -1664, 552, 88},
    { -1840, 536, 128},
    { -1752, 224, 560},
    { -1384, 800, 520},
    { -1152, 136, -40},
    { -1336, 288, 248},
    { -1168, 112, 464},
    { -960, 200, 344},
    { -840, 160, 296},
    { -712, 192, 328},
    { -688, 192, 360},
    { -904, 200, 456},
    { -1064, 240, 720},
    { -1352, 368, 536},
    { -1024, 256, 112},
    { -1040, 392, 216},
    { -1160, 376, 384},
    { -1256, 368, 384},
    { -1536, 264, 288},
    { -1648, 248, 288},
    { -1568, 40, 384},
    // 97 seconds
    { -1400, -72, 344},
    { -1232, -32, 240},
    { -1064, 16, 216},
    { -896, 40, 192},
    { -824, -64, -16},
    { -680, -224, -56},
    { -792, -56, 24},
    { -1032, 72, 0},
    { -1336, 112, 72},
    { -1464, 600, -24},
    { -1416, 272, 32},
    { -1552, 128, 208},
    { -1512, 312, 160},
    { -1280, 360, 256},
    { -1104, 312, 216},
    { -1112, 272, 208},
    { -1080, 208, 248},
    { -1000, 192, 248},
    { -856, 224, 272},
    { -808, 200, 312},
    { -992, 304, 360},
    { -1000, 400, 648},
    { -944, 120, 168},
    { -1184, 304, 136},
    { -1304, 376, 232},
    // 98 seconds
    { -1168, 424, 208},
    { -1208, 408, 216},
    { -1480, 392, 200},
    { -1560, 272, 272},
    { -1448, 160, 352},
    { -1376, -136, 280},
    { -1360, 24, 240},
    { -1256, 32, 216},
    { -1056, 48, 200},
    { -904, 56, 152},
    { -680, -248, -16},
    { -608, -112, 16},
    { -672, 32, 32},
    { -1024, 16, 88},
    { -1360, 240, 64},
    { -1384, 632, -88},
    { -1528, 144, 176},
    { -1632, 224, 264},
    { -1512, 632, 112},
    { -1336, 408, 168},
    { -1184, 400, 152},
    { -1104, 312, 168},
    { -1048, 240, 176},
    { -936, 256, 200},
    { -816, 208, 224},
    // 99 seconds
    { -760, 208, 200},
    { -816, 328, 408},
    { -760, 336, 320},
    { -936, 616, 424},
    { -1160, 280, 200},
    { -1344, 264, 232},
    { -1280, 400, 216},
    { -1152, 448, 184},
    { -1288, 384, 176},
    { -1424, 392, 216},
    { -1336, 280, 352},
    { -1216, 136, 336},
    { -1216, 48, 320},
    { -1144, 40, 280},
    { -1000, 72, 216},
    { -824, 48, 104},
    { -752, 0, 104},
    { -712, -192, 72},
    { -704, 0, -16},
    { -1008, 208, 48},
    { -1256, 104, -40},
    { -1552, 248, -48},
    { -1952, 984, -248},
    { -1704, 464, 32},
    { -1136, 688, 544},
    // 100 seconds
    { -872, 48, -64},
    { -1240, 344, 240},
    { -1056, 136, 128},
    { -904, 200, 168},
    { -808, 160, 200},
    { -720, 168, 192},
    { -688, 208, 168},
    { -736, 336, 176},
    { -896, 376, 208},
    { -928, 296, 176},
    { -1640, 128, 224},
    { -1616, 392, 248},
    { -1216, 648, 80},
    { -1216, 776, -304},
    { -1496, 1432, -424},
    { -1576, -400, 832},
    { -1056, -360, 344},
    { -920, 16, 200},
    { -824, 216, 72},
    { -752, 144, 136},
    { -696, -72, 232},
    { -752, -88, 304},
    { -848, 16, 312},
    { -840, 80, 240},
    { -1000, 80, 184},
    // 101 seconds
    { -1264, 376, 80},
    { -1328, 904, -320},
    { -1616, 1664, -376},
    { -1400, -792, 776},
    { -872, 888, 344},
    { -1000, 176, 40},
    { -1152, 376, 184},
    { -944, 200, 248},
    { -744, 112, 192},
    { -664, 32, 184},
    { -656, 32, 232},
    { -696, 144, 200},
    { -888, 296, 168},
    { -1256, 432, 208},
    { -1184, 304, 392},
    { -1296, 648, 96},
    { -1248, 152, 176},
    { -1072, 792, -80},
    { -1144, 640, -120},
    { -1392, 472, -160},
    { -1408, 528, 72},
    { -1072, 360, 288},
    { -1072, -240, 336},
    { -1040, 240, 192},
    { -992, 72, 176},
    // 102 seconds
    { -864, 80, 208},
    { -792, 72, 192},
    { -880, 72, 208},
    { -1024, -96, 192},
    { -1152, -104, 64},
    { -1288, 144, 88},
    { -1320, 544, -56},
    { -1336, 600, -120},
    { -1416, 144, 176},
    { -1440, 384, 136},
    { -1352, 472, 256},
    { -1008, 320, 144},
    { -968, 296, 216},
    { -968, 144, 272},
    { -968, 120, 296},
    { -912, 72, 312},
    { -792, 128, 296},
    { -736, 200, 264},
    { -872, 312, 336},
    { -920, 384, 432},
    { -1360, 240, 264},
    { -1432, 344, 208},
    { -1224, 424, 88},
    { -1184, 528, 8},
    { -1328, 480, 40},
    // 103 seconds
    { -1608, 288, 16},
    { -1528, 448, 360},
    { -1384, -232, 376},
    { -1216, 72, 256},
    { -1096, 56, 176},
    { -912, 0, 224},
    { -720, 40, 192},
    { -688, 48, 160},
    { -784, -56, 160},
    { -864, 104, 176},
    { -1096, 136, 192},
    { -1056, 328, -56},
    { -1272, 864, -256},
    { -1456, 536, -48},
    { -1592, -88, 312},
    { -1656, 552, 256},
    { -1312, 376, 496},
    { -1032, 624, 168},
    { -992, 288, 152},
    { -1000, 184, 328},
    { -848, 136, 272},
    { -664, 136, 248},
    { -688, 160, 280},
    { -928, 264, 368},
    { -968, 216, 592},
    // 104 seconds
    { -904, 576, 848},
    { -1072, 744, 400},
    { -1224, 720, 264},
    { -976, 672, 88},
    { -1112, 632, 104},
    { -1360, 456, 248},
    { -1544, 504, 384},
    { -1328, 200, 392},
    { -1240, 144, 352},
    { -1224, 136, 288},
    { -1080, 120, 280},
    { -928, 112, 184},
    { -784, 144, 192},
    { -728, -32, 136},
    { -648, -200, 40},
    { -640, 48, -56},
    { -1080, 232, 72},
    { -1432, 504, 72},
    { -1760, 720, 32},
    { -1688, 328, 320},
    { -1472, 160, 560},
    { -1056, 912, 96},
    { -1176, 568, 72},
    { -1192, 352, 176},
    { -1008, 256, 280},
    // 105 seconds
    { -952, 184, 216},
    { -904, 240, 240},
    { -824, 264, 248},
    { -792, 312, 304},
    { -792, 504, 352},
    { -920, 336, 240},
    { -1248, 280, 264},
    { -1352, 272, 216},
    { -1192, 200, 200},
    { -1296, 256, 240},
    { -1464, 224, 232},
    { -1560, 256, 176},
    { -1480, 152, 320},
    { -1216, 152, 280},
    { -1040, 80, 264},
    { -1008, 0, 248},
    { -960, -16, 208},
    { -824, 40, 208},
    { -792, 32, 184},
    { -784, -152, 112},
    { -728, -40, 64},
    { -880, 160, 56},
    { -1272, 288, 32},
    { -1576, 288, 176},
    { -1672, 376, 224},
    // 106 seconds
    { -1616, 680, 128},
    { -896, 1032, -40},
    { -1248, 48, 216},
    { -1256, 168, 304},
    { -984, 184, 224},
    { -864, 160, 264},
    { -824, 168, 232},
    { -800, 120, 296},
    { -736, 152, 288},
    { -816, 272, 288},
    { -1008, 208, 496},
    { -1056, 376, 464},
    { -1272, 296, 96},
    { -1304, 528, 200},
    { -1160, 456, 200},
    { -1192, 408, 88},
    { -1328, 368, 96},
    { -1432, 400, 120},
    { -1280, -152, 336},
    { -1176, 232, 144},
    { -1160, 152, 200},
    { -1120, 96, 208},
    { -960, 32, 200},
    { -848, 40, 152},
    { -832, 32, 96},
    // 107 seconds
    { -784, -64, -8},
    { -704, -16, 24},
    { -1208, 136, 136},
    { -1360, 464, -40},
    { -1424, 424, 16},
    { -1496, 416, 72},
    { -1480, 208, 272},
    { -1256, 408, 200},
    { -1168, 280, 104},
    { -1152, 232, 192},
    { -1040, 176, 256},
    { -952, 152, 264},
    { -872, 136, 272},
    { -760, 152, 304},
    { -744, 224, 344},
    { -952, 328, 512},
    { -960, 272, 376},
    { -1384, 240, 440},
    { -1312, 480, 312},
    { -1072, 480, 200},
    { -1096, 504, 248},
    { -1280, 384, 360},
    { -1544, 280, 472},
    { -1568, 152, 496},
    { -1416, 64, 472},
    // 108 seconds
    { -1304, 0, 384},
    { -1176, -40, 280},
    { -1000, -24, 200},
    { -816, 16, 152},
    { -744, 32, 104},
    { -736, -32, 88},
    { -664, -8, 32},
    { -744, 80, -96},
    { -1112, 120, 64},
    { -1552, 664, -104},
    { -1872, 936, 56},
    { -1792, 40, 552},
    { -816, 1128, 448},
    { -1136, 144, 240},
    { -1392, 296, 184},
    { -1136, 288, 224},
    { -904, 136, 256},
    { -800, 144, 208},
    { -760, 192, 224},
    { -784, 232, 272},
    { -920, 184, 344},
    { -1072, 368, 656},
    { -1000, 312, 288},
    { -1304, 288, 128},
    { -1344, 448, 224},
    // 109 seconds
    { -1224, 432, 272},
    { -1128, 408, 96},
    { -1280, 360, 112},
    { -1480, 360, 200},
    { -1504, 176, 176},
    { -1272, 88, 368},
    { -1248, 112, 264},
    { -1144, 96, 216},
    { -960, 80, 208},
    { -808, 40, 168},
    { -712, -64, 96},
    { -656, -184, 24},
    { -720, 40, -56},
    { -1056, 144, 88},
    { -1432, 360, 112},
    { -1656, 712, 16},
    { -1624, 152, -48},
    { -1696, 432, 536},
    { -912, 232, -80},
    { -1328, 336, 192},
    { -1248, 352, 200},
    { -920, 264, 176},
    { -752, 160, 256},
    { -768, 208, 272},
    { -744, 208, 296},
    // 110 seconds
    { -728, 208, 344},
    { -880, 312, 472},
    { -776, 224, 664},
    { -1344, 488, 400},
    { -1344, 104, 608},
    { -1128, 304, 424},
    { -1176, 392, 312},
    { -1376, 392, 352},
    { -1496, 552, 432},
    { -1296, 208, 360},
    { -1128, 192, 336},
    { -1104, 8, 376},
    { -1168, 40, 328},
    { -1056, 56, 272},
    { -872, 96, 200},
    { -792, 64, 176},
    { -776, -136, 48},
    { -624, -160, -24},
    { -816, 120, -8},
    { -1272, 344, -24},
    { -1744, 248, 240},
    { -1912, 704, -24},
    { -1696, 352, 352},
    { -888, 1232, 392},
    { -1104, -136, 112},
    // 111 seconds
    { -1256, 192, 200},
    { -952, 232, 288},
    { -864, 752, 360},
    { -736, 560, 656},
    { -632, 656, 672},
    { -472, 688, 688},
    { -440, 672, 704},
    { -624, 688, 824},
    { -768, 776, 960},
    { -1080, 744, 1216},
    { -952, 912, 1040},
    { -768, 928, 680},
    { -512, 728, 488},
    { -352, 680, 440},
    { -280, 720, 528},
    { -208, 744, 696},
    { -160, 984, 696},
    { -48, 872, 376},
    { 24, 480, 184},
    { 56, 368, -40},
    { 88, 248, -112},
    { 112, 112, -88},
    { 120, -96, 136},
    { 72, 256, 248},
    { -136, 760, 176},
    // 112 seconds
    { -456, 768, 256},
    { -824, 472, 240},
    { -1528, 392, 336},
    { -2080, 448, 400},
    { -2616, 512, 632},
    { -2256, 616, 552},
    { -1320, 992, 160},
    { -1136, -176, 80},
    { -1352, 72, 352},
    { -1200, 272, 304},
    { -912, 392, 208},
    { -776, 320, 240},
    { -864, 448, 344},
    { -1000, 728, 456},
    { -1104, 336, 200},
    { -1296, 392, 72},
    { -1272, 424, 40},
    { -1240, 368, 32},
    { -1456, 344, 88},
    { -1792, 296, 40},
    { -1952, 344, 24},
    { -1856, 88, 344},
    { -1464, -64, 184},
    { -1248, 104, 88},
    { -1056, 48, 104},
    // 113 seconds
    { -912, 56, 152},
    { -736, -40, 40},
    { -544, -336, 24},
    { -688, 0, -96},
    { -728, 48, -128},
    { -1264, 88, -24},
    { -1512, 384, -160},
    { -1496, 416, -64},
    { -1664, 384, 128},
    { -1760, 560, 80},
    { -1544, 832, 120},
    { -1224, 360, 256},
    { -1136, 424, 120},
    { -1128, 336, 176},
    { -1104, 272, 216},
    { -944, 184, 304},
    { -816, 208, 360},
    { -912, 320, 400},
    { -888, 288, 416},
    { -1056, 256, 384},
    { -1208, 368, 312},
    { -1144, 384, 240},
    { -1128, 376, 224},
    { -1376, 368, 288},
    { -1680, 312, 304},
    // 114 seconds
    { -1752, 248, 272},
    { -1560, 136, 384},
    { -1408, 40, 312},
    { -1296, 104, 264},
    { -1136, 80, 232},
    { -960, 56, 200},
    { -920, 8, 104},
    { -792, -392, -136},
    { -728, -112, -32},
    { -1040, -16, 40},
    { -1360, 128, 8},
    { -1496, 720, -128},
    { -1456, 304, 112},
    { -1568, 80, 384},
    { -1512, 304, 240},
    { -1392, 512, 128},
    { -1232, 352, 200},
    { -1208, 264, 224},
    { -1168, 184, 280},
    { -1080, 224, 304},
    { -904, 240, 312},
    { -784, 328, 328},
    { -792, 424, 368},
    { -800, 408, 360},
    { -1152, 304, 400},
    // 115 seconds
    { -1368, 360, 344},
    { -1248, 376, 264},
    { -1128, 384, 136},
    { -1224, 400, 176},
    { -1504, 368, 160},
    { -1744, 464, 216},
    { -1608, 112, 400},
    { -1392, 120, 392},
    { -1224, 0, 336},
    { -1064, 32, 296},
    { -888, 40, 232},
    { -824, 72, 224},
    { -880, 40, 224},
    { -824, -48, 264},
    { -1000, -96, 416},
    { -960, 96, 416},
    { -872, 688, 368},
    { -840, 1040, 320},
    { -920, 976, 320},
    { -1216, 744, 496},
    { -1312, 336, 720},
    { -1048, 248, 680},
    { -936, 360, 432},
    { -1000, 336, 240},
    { -1008, 160, 336},
    // 116 seconds
    { -872, 96, 312},
    { -792, 144, 456},
    { -880, 184, 464},
    { -920, 128, 504},
    { -776, 64, 456},
    { -976, 24, 472},
    { -1096, 376, 448},
    { -1000, 528, 432},
    { -1000, 560, 424},
    { -1048, 472, 472},
    { -1096, 520, 392},
    { -1048, 568, 384},
    { -1264, 576, 424},
    { -1160, 456, 672},
    { -1200, 472, 688},
    { -1056, 472, 664},
    { -960, 312, 680},
    { -792, 336, 656},
    { -608, 272, 624},
    { -384, 280, 488},
    { -240, 528, 376},
    { -208, 496, 464},
    { -88, 648, 496},
    { 88, 880, 432},
    { 160, 816, 320},
    // 117 seconds
    { 256, 800, 288},
    { 256, 808, 288},
    { 232, 888, 344},
    { 232, 960, 296},
    { 192, 968, 232},
    { 224, 904, 208},
    { 232, 808, -152},
    { 152, 816, -64},
    { 128, 600, -256},
    { 120, 808, -400},
    { 128, 808, -392},
    { 120, 688, -488},
    { 128, 912, -592},
    { 64, 744, -640},
    { 16, 568, -704},
    { -8, 368, -504},
    { 32, 376, -368},
    { 40, 640, 168},
    { 288, 1000, 376},
    { 144, 896, 368},
    { 72, 728, 424},
    { -192, 1192, 576},
    { 160, 856, 512},
    { 136, 784, 544},
    { 128, 672, 592},
    // 118 seconds
    { 120, 856, 784},
    { 152, 752, 656},
    { 8, 728, 536},
    { 96, 824, 368},
    { 32, 664, 616},
    { 120, 976, 488},
    { 160, 992, 384},
    { 208, 768, 264},
    { 136, 880, 8},
    { 24, 944, -48},
    { -56, 776, -240},
    { -152, 832, -360},
    { -104, 576, -584},
    { 24, -472, -576},
    { 56, 1024, -728},
    { -304, 1056, -648},
    { 192, 424, -784},
    { -232, 520, -728},
    { 72, 408, -936},
    { 24, 272, -968},
    { -112, -48, -256},
    { -88, 240, -1136},
    { -336, -352, -832},
    { -352, -464, -1056},
    { -272, -312, -1064},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

