/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:21:06 local
AccelRawData *activity_sample_walk_120_pbl_25478_1(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_120_pbl_25478_1
  //> TEST_EXPECTED 120
  //> TEST_EXPECTED_MIN 50
  //> TEST_EXPECTED_MAX 130
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 184, -208, -960},
    { 144, -216, -968},
    { 144, -224, -944},
    { 176, -192, -944},
    { 184, -104, -944},
    { 144, -264, -960},
    { 136, -208, -984},
    { 152, -200, -968},
    { 160, -200, -952},
    { 168, -272, -960},
    { 200, -248, -960},
    { 176, -224, -968},
    { 184, -216, -960},
    { 184, -232, -960},
    { 176, -232, -936},
    { 200, -232, -952},
    { 184, -240, -952},
    { 224, -240, -952},
    { 176, -240, -944},
    { 240, -232, -936},
    { 200, -232, -936},
    { 208, -240, -936},
    { 208, -232, -928},
    { 208, -232, -944},
    { 200, -240, -936},
    // 1 seconds
    { 216, -232, -952},
    { 208, -224, -952},
    { 208, -232, -960},
    { 200, -240, -944},
    { 232, -216, -944},
    { 200, -232, -944},
    { 208, -232, -944},
    { 208, -232, -936},
    { 240, -312, -944},
    { 248, -208, -944},
    { 200, -168, -976},
    { 256, -192, -960},
    { 248, -200, -928},
    { 240, -152, -920},
    { 248, -72, -944},
    { 216, -8, -928},
    { 256, 8, -936},
    { 264, 80, -936},
    { 256, 136, -928},
    { 240, 88, -912},
    { 264, 48, -944},
    { 272, 88, -936},
    { 224, 80, -952},
    { 216, 8, -944},
    { 216, -24, -944},
    // 2 seconds
    { 176, -32, -936},
    { 232, 72, -928},
    { 256, 152, -840},
    { 264, 224, -800},
    { 296, 344, -792},
    { 224, 448, -744},
    { 280, 440, -736},
    { 248, 520, -680},
    { 256, 512, -656},
    { 248, 512, -664},
    { 216, 464, -648},
    { 176, 512, -608},
    { 72, 616, -608},
    { -16, 768, -520},
    { 104, 1080, -360},
    { 0, 1440, -368},
    { 232, 1048, -336},
    { 256, 808, -200},
    { 232, 904, -240},
    { 168, 880, -224},
    { 104, 920, -184},
    { 48, 968, -232},
    { 136, 864, -216},
    { 136, 776, -184},
    { 200, 752, -224},
    // 3 seconds
    { 232, 776, -248},
    { 288, 720, -192},
    { 304, 760, -208},
    { 288, 808, -232},
    { 272, 824, -216},
    { 328, 904, -272},
    { 224, 912, -360},
    { 168, 928, -352},
    { 56, 1200, -440},
    { -160, 1176, -360},
    { -120, 832, -288},
    { -32, 800, -248},
    { 32, 792, -224},
    { 136, 800, -232},
    { 176, 720, -216},
    { 248, 576, -200},
    { 232, 728, -224},
    { 272, 728, -232},
    { 272, 704, -256},
    { 248, 712, -280},
    { 240, 816, -368},
    { 216, 848, -336},
    { 176, 832, -352},
    { 304, 832, -272},
    { 232, 1240, -208},
    // 4 seconds
    { 120, 1296, -272},
    { 240, 880, -232},
    { 288, 832, -80},
    { 208, 944, -136},
    { 80, 968, -160},
    { 16, 856, -192},
    { 144, 720, -232},
    { 136, 672, -240},
    { 176, 680, -200},
    { 216, 648, -232},
    { 224, 664, -216},
    { 264, 704, -200},
    { 216, 816, -200},
    { 224, 856, -240},
    { 224, 936, -272},
    { 32, 1104, -344},
    { 64, 1184, -448},
    { 48, 1080, -432},
    { 0, 888, -424},
    { 40, 752, -336},
    { 112, 760, -248},
    { 72, 736, -248},
    { 112, 640, -192},
    { 192, 616, -200},
    { 176, 760, -184},
    // 5 seconds
    { 216, 744, -152},
    { 184, 816, -96},
    { 168, 864, -32},
    { 152, 904, -40},
    { 88, 952, -16},
    { 152, 976, 48},
    { 88, 1080, 160},
    { 40, 992, 184},
    { 24, 1096, 296},
    { -96, 1128, 344},
    { -128, 968, 272},
    { -40, 848, 272},
    { -32, 800, 272},
    { -24, 736, 264},
    { -40, 752, 256},
    { -32, 792, 288},
    { -8, 848, 328},
    { 0, 848, 328},
    { 32, 872, 328},
    { 56, 816, 312},
    { 72, 840, 352},
    { 128, 872, 248},
    { 128, 736, 224},
    { 128, 784, 160},
    { 152, 920, 128},
    // 6 seconds
    { 152, 920, 152},
    { 16, 1168, 128},
    { 48, 1056, 48},
    { 40, 1088, 40},
    { -80, 1384, -80},
    { -112, 896, -144},
    { -120, 888, -368},
    { -72, 656, -352},
    { -48, 672, -472},
    { -40, 688, -504},
    { 24, 560, -472},
    { 88, 472, -456},
    { 104, 512, -464},
    { 128, 440, -472},
    { 128, 416, -488},
    { 24, 488, -496},
    { -24, 592, -568},
    { -128, 744, -584},
    { -48, 864, -512},
    { -88, 1104, -472},
    { -104, 1312, -296},
    { -88, 1432, -88},
    { 48, 1208, 128},
    { 160, 1040, 272},
    { 16, 1024, 264},
    // 7 seconds
    { -48, 880, 304},
    { -128, 832, 224},
    { -48, 744, 240},
    { 16, 704, 248},
    { 16, 704, 184},
    { 56, 568, 208},
    { 104, 672, 176},
    { 200, 784, 264},
    { 216, 912, 256},
    { 328, 1080, 240},
    { 368, 1224, 232},
    { 312, 1328, 216},
    { 128, 1256, 248},
    { 120, 1016, 128},
    { 152, 824, 208},
    { 176, 736, 176},
    { 200, 640, 152},
    { 296, 504, 144},
    { 328, 488, 120},
    { 496, 448, 88},
    { 520, 488, -24},
    { 568, 552, -120},
    { 568, 712, -176},
    { 664, 848, -144},
    { 608, 1048, -384},
    // 8 seconds
    { 896, 1328, -168},
    { 920, 1000, -232},
    { 1040, 728, -32},
    { 832, 400, 8},
    { 720, 224, 144},
    { 576, 80, 160},
    { 424, 144, 160},
    { 224, 88, 56},
    { 56, -32, 32},
    { 48, -8, 104},
    { -64, 40, 0},
    { -208, 40, -48},
    { -208, -208, 168},
    { -720, 256, -448},
    { -1728, 128, -88},
    { -3224, 1272, -1208},
    { -3256, 1048, -928},
    { -2960, 1264, -1016},
    { -1904, 1496, -472},
    { -928, 672, -272},
    { -704, 376, -104},
    { -624, 376, -56},
    { -776, 288, -96},
    { -704, 256, 112},
    { -552, 376, -24},
    // 9 seconds
    { -576, 352, -64},
    { -696, 344, -72},
    { -752, 368, -192},
    { -816, 344, -112},
    { -1272, 568, 8},
    { -1392, 352, -320},
    { -1744, 488, -288},
    { -1800, 616, -1592},
    { -920, -432, 760},
    { -1104, 72, 104},
    { -992, 432, -88},
    { -928, 640, -336},
    { -904, 368, 128},
    { -856, 400, -32},
    { -792, 400, -72},
    { -704, 248, -48},
    { -704, 432, 80},
    { -648, 208, -232},
    { -504, 160, -80},
    { -608, 160, -128},
    { -760, 72, -216},
    { -1048, 0, -320},
    { -1544, -88, -352},
    { -2032, -168, -1024},
    { -2024, 80, -520},
    // 10 seconds
    { -1464, -40, -72},
    { -1320, -16, -336},
    { -1208, 72, -56},
    { -992, 376, 8},
    { -704, 232, -56},
    { -624, 184, 24},
    { -576, 208, 16},
    { -544, 216, -64},
    { -568, 272, -80},
    { -1024, 424, -168},
    { -1392, 328, 224},
    { -1680, 280, -728},
    { -1512, 192, -472},
    { -1280, 176, -400},
    { -1296, 296, -280},
    { -1544, 440, -128},
    { -1672, 280, -104},
    { -1504, 32, -32},
    { -1304, -128, -24},
    { -1152, 0, -8},
    { -1008, 96, -104},
    { -880, -24, -104},
    { -768, 120, -184},
    { -744, 336, -24},
    { -792, 152, -120},
    // 11 seconds
    { -776, 8, -160},
    { -912, 48, 8},
    { -1120, 48, -392},
    { -1344, 88, -216},
    { -1672, 32, -352},
    { -1944, 104, -216},
    { -1888, 288, -128},
    { -1432, 328, -296},
    { -1256, 72, -8},
    { -1168, 272, 56},
    { -992, 296, 32},
    { -808, 336, -72},
    { -672, 392, -232},
    { -880, 352, -136},
    { -992, 400, -128},
    { -1192, 640, -248},
    { -1352, 440, -288},
    { -1208, 216, -360},
    { -1280, 376, -176},
    { -1432, 392, -312},
    { -1760, 264, -144},
    { -1960, 272, -64},
    { -1888, 192, 16},
    { -1696, 112, 24},
    { -1496, 136, 8},
    // 12 seconds
    { -1312, 192, 16},
    { -1040, 168, -32},
    { -888, 64, -24},
    { -752, -64, 96},
    { -608, -120, -64},
    { -704, -112, -40},
    { -872, -88, -144},
    { -1024, 0, -40},
    { -1296, 56, -352},
    { -1720, -112, -120},
    { -2016, 152, -296},
    { -2024, 192, -32},
    { -1848, 632, -200},
    { -1504, 592, -104},
    { -1320, 368, -80},
    { -1224, 392, -8},
    { -1168, 368, 32},
    { -1136, 584, 104},
    { -928, 880, -272},
    { -968, 600, -88},
    { -1016, 648, -200},
    { -1040, 584, -232},
    { -1184, 648, -408},
    { -1600, 624, -280},
    { -2088, 584, -160},
    // 13 seconds
    { -2096, 456, -112},
    { -1856, 216, -136},
    { -1832, 264, 0},
    { -1672, 264, 8},
    { -1432, 216, 48},
    { -1192, 168, 56},
    { -1024, 152, 24},
    { -832, 64, -32},
    { -624, 16, -144},
    { -552, -40, -152},
    { -512, -80, -296},
    { -648, -32, -320},
    { -856, -264, -240},
    { -1368, -152, -168},
    { -2000, 200, -216},
    { -2496, 424, -176},
    { -2488, 944, -176},
    { -1784, 728, -248},
    { -1432, 400, -256},
    { -1488, 656, 232},
    { -1080, 192, 144},
    { -976, 320, -160},
    { -1160, 592, -400},
    { -1296, 1272, -480},
    { -1328, 1712, -944},
    // 14 seconds
    { -1784, 920, -1064},
    { -2224, 488, -848},
    { -3056, 344, -416},
    { -3912, 72, -32},
    { -3600, 408, 48},
    { -3296, 1008, -32},
    { -2408, 464, 88},
    { -1448, 264, 440},
    { -808, -136, 312},
    { -512, -128, 184},
    { -424, -288, 152},
    { -336, -416, -40},
    { -344, -376, -80},
    { -240, -608, -56},
    { -144, -760, -192},
    { -24, -824, -480},
    { -1088, -280, -8},
    { -3216, 1984, -112},
    { -2416, 3696, 280},
    { -1472, 2368, 248},
    { -640, 944, -80},
    { -568, 584, -72},
    { -520, 672, 24},
    { -568, 480, 168},
    { -488, 568, 64},
    // 15 seconds
    { -576, 488, -40},
    { -840, 568, -80},
    { -1440, 688, -168},
    { -1624, 1344, -984},
    { -1448, 504, 16},
    { -1144, 24, -880},
    { -1648, 936, -656},
    { -1752, 168, -224},
    { -1992, 416, -168},
    { -1984, 504, -208},
    { -1792, 376, -104},
    { -1592, 312, -72},
    { -1360, 224, -16},
    { -1120, 168, 32},
    { -880, 104, 40},
    { -688, 80, 48},
    { -432, -184, 136},
    { -312, -200, 0},
    { -624, -72, 24},
    { -800, -104, 0},
    { -1112, 128, -280},
    { -1592, 128, -80},
    { -2152, 296, -568},
    { -2512, 144, -104},
    { -2448, 352, 0},
    // 16 seconds
    { -1848, 968, -576},
    { -1528, 96, 88},
    { -1728, 392, 744},
    { -1264, 296, 320},
    { -1048, 368, 104},
    { -872, 440, -120},
    { -928, 608, -56},
    { -760, 1208, -552},
    { -1120, 600, -88},
    { -1632, 592, 88},
    { -1624, 384, -48},
    { -1832, 120, -80},
    { -2232, 248, 328},
    { -2424, 360, 184},
    { -2352, 296, 208},
    { -2184, 232, 224},
    { -1904, 152, 224},
    { -1552, 128, 192},
    { -1224, 144, 144},
    { -976, 168, 32},
    { -880, -24, 40},
    { -544, -504, 256},
    { -384, -248, -96},
    { -568, -16, -232},
    { -664, 16, -208},
    // 17 seconds
    { -984, 80, -568},
    { -1400, 0, -584},
    { -1776, -296, -208},
    { -2064, -24, -160},
    { -2040, 480, -64},
    { -1960, 448, 48},
    { -1872, 328, -40},
    { -1824, 464, 40},
    { -1600, 448, 128},
    { -1504, 376, 32},
    { -1344, 456, -120},
    { -1224, 664, -240},
    { -1080, 880, -320},
    { -912, 768, -400},
    { -912, 608, -480},
    { -1104, 648, -344},
    { -1528, 656, -168},
    { -2024, 384, 40},
    { -2096, 40, 32},
    { -1976, 48, 24},
    { -1920, 240, -56},
    { -1768, 216, -24},
    { -1488, 248, -48},
    { -1160, 152, -32},
    { -1056, 152, -96},
    // 18 seconds
    { -800, -184, 16},
    { -536, -304, -40},
    { -680, -240, -256},
    { -952, -168, -136},
    { -1176, -80, -208},
    { -1456, -160, -208},
    { -1728, 80, -200},
    { -1768, 80, -152},
    { -1792, 208, -144},
    { -1848, 392, -104},
    { -1848, 328, -96},
    { -1840, 272, -72},
    { -1656, 352, -64},
    { -1368, 576, -168},
    { -1232, 744, -248},
    { -1080, 800, -104},
    { -1064, 672, -48},
    { -856, 976, 56},
    { -944, 776, -64},
    { -1440, 696, -8},
    { -1968, 624, 16},
    { -2376, 464, 88},
    { -2424, 456, 200},
    { -2224, 224, 192},
    { -1912, 144, 104},
    // 19 seconds
    { -1544, 136, 112},
    { -1136, 152, 24},
    { -808, 168, -152},
    { -872, 144, -104},
    { -568, -408, 96},
    { -432, -312, 16},
    { -720, -192, -112},
    { -1048, -48, -56},
    { -1312, 144, -136},
    { -1512, 72, -152},
    { -1848, 232, -200},
    { -2096, 176, -160},
    { -2208, 256, -96},
    { -2104, 280, -24},
    { -1976, 456, 288},
    { -1648, 552, 56},
    { -1408, 568, 256},
    { -1208, 456, 320},
    { -1128, 440, 328},
    { -1024, 544, 480},
    { -864, 640, 480},
    { -824, 704, 392},
    { -952, 616, 328},
    { -1184, 800, -8},
    { -1744, 808, -72},
    // 20 seconds
    { -2536, 888, 192},
    { -2976, 360, -712},
    { -2568, 656, -16},
    { -2456, 128, 288},
    { -2008, 424, 192},
    { -1632, 152, 184},
    { -1168, 152, 176},
    { -888, 112, 128},
    { -600, -224, 144},
    { -344, -544, 16},
    { -544, -784, 304},
    { -536, -640, -248},
    { -1336, 48, -136},
    { -1736, 304, -240},
    { -2424, 488, 80},
    { -2360, 432, 40},
    { -2344, 448, 184},
    { -2104, 592, 32},
    { -2072, 408, -24},
    { -1976, 416, 88},
    { -1688, 472, 144},
    { -1360, 488, 120},
    { -1256, 672, 448},
    { -864, 648, 536},
    { -616, 664, 544},
    // 21 seconds
    { -656, 584, 536},
    { -760, 624, 360},
    { -1168, 608, 520},
    { -1360, 568, 344},
    { -1608, 560, 160},
    { -2176, 640, 248},
    { -2872, 856, 80},
    { -2768, 448, 336},
    { -2640, 200, 528},
    { -2168, 48, 352},
    { -1672, 96, 264},
    { -1192, 72, 224},
    { -928, 112, 128},
    { -560, -280, 136},
    { -312, -312, 24},
    { -560, -48, 8},
    { -680, 24, -120},
    { -880, 216, -192},
    { -1008, 176, -352},
    { -1336, 208, -136},
    { -1712, -24, 192},
    { -2016, 120, 184},
    { -2040, 416, 160},
    { -1968, 480, 0},
    { -2032, 656, 88},
    // 22 seconds
    { -1944, 480, 120},
    { -1672, 352, 176},
    { -1384, 368, 80},
    { -1248, 360, 56},
    { -1136, 496, 136},
    { -1024, 656, 88},
    { -928, 888, -48},
    { -816, 776, -96},
    { -1048, 632, -128},
    { -1440, 624, -48},
    { -1888, 600, 0},
    { -2200, 336, 48},
    { -2616, -80, 616},
    { -2240, 216, 288},
    { -1992, 32, 248},
    { -1712, 16, 192},
    { -1344, 24, 184},
    { -1088, 128, 112},
    { -1024, 248, 208},
    { -712, -24, 440},
    { -432, -440, 264},
    { -696, -232, 64},
    { -1032, -248, -152},
    { -1392, -296, -240},
    { -1536, -200, -416},
    // 23 seconds
    { -1688, -120, -224},
    { -1744, 72, -256},
    { -1824, 288, -328},
    { -1864, 304, -272},
    { -2064, 1296, -280},
    { -1672, 528, -144},
    { -1336, 512, -96},
    { -1128, 360, 24},
    { -1160, 792, -48},
    { -1080, 936, -160},
    { -1032, 968, -256},
    { -1128, 712, -296},
    { -1232, 528, -192},
    { -1440, 392, -56},
    { -1736, 336, 64},
    { -1928, 288, 128},
    { -1928, 240, 168},
    { -1816, 216, 160},
    { -1712, 176, 152},
    { -1536, 136, 128},
    { -1232, 168, 144},
    { -1112, 200, -224},
    { -960, -64, 48},
    { -600, -456, -96},
    { -736, -56, -168},
    // 24 seconds
    { -888, 56, -416},
    { -1040, 224, -512},
    { -1144, -56, -184},
    { -1440, -184, -16},
    { -1816, 136, 120},
    { -1848, 464, 112},
    { -1688, 480, 120},
    { -1560, 472, 96},
    { -1528, 488, 112},
    { -1424, 304, 80},
    { -1296, 328, 48},
    { -1160, 216, 264},
    { -1176, 968, -32},
    { -1008, 736, 88},
    { -1080, 440, -64},
    { -984, 480, -144},
    { -952, 536, -104},
    { -1192, 608, 48},
    { -1528, 496, 152},
    { -1760, 352, 168},
    { -1720, 216, 224},
    { -1640, 40, 208},
    { -1624, 328, 272},
    { -1512, 416, 120},
    { -1312, 392, 88},
    // 25 seconds
    { -1112, 336, 16},
    { -1064, 248, 112},
    { -872, -88, 8},
    { -736, -312, -80},
    { -976, -96, -120},
    { -1224, 40, -64},
    { -1312, 176, -280},
    { -1560, 184, -24},
    { -1752, 0, 64},
    { -1936, 416, 40},
    { -1864, 576, 56},
    { -1648, 528, 168},
    { -1480, 624, 136},
    { -1360, 376, 192},
    { -1200, 280, 200},
    { -1024, 296, 192},
    { -1064, 416, 256},
    { -1000, 664, 272},
    { -888, 528, 208},
    { -1024, 720, 184},
    { -984, 624, 96},
    { -1152, 608, 8},
    { -1496, 544, 96},
    { -2176, 552, 296},
    { -2288, 320, 200},
    // 26 seconds
    { -2200, 496, 144},
    { -1968, 152, 384},
    { -1800, 336, 296},
    { -1480, 208, 280},
    { -1104, 104, 312},
    { -880, 56, 240},
    { -792, 64, 168},
    { -712, -168, 32},
    { -248, -744, -336},
    { -808, -264, -240},
    { -1472, 280, -104},
    { -1680, 320, -112},
    { -2160, 576, -232},
    { -2120, 32, 64},
    { -2120, 256, 176},
    { -1880, 512, 56},
    { -1824, 488, 144},
    { -1656, 496, 232},
    { -1312, 456, 368},
    { -1264, 664, 360},
    { -888, 320, 288},
    { -840, 408, 360},
    { -880, 640, 416},
    { -792, 232, 280},
    { -968, 600, 280},
    // 27 seconds
    { -944, 592, 136},
    { -1128, 768, 24},
    { -1520, 720, 40},
    { -2040, 560, 120},
    { -2376, 328, 216},
    { -2392, 280, 168},
    { -2216, 232, 176},
    { -2000, 176, 176},
    { -1648, 160, 176},
    { -1240, 120, 176},
    { -912, 120, 80},
    { -832, 80, 8},
    { -592, -304, 16},
    { -600, -232, 0},
    { -696, 104, -248},
    { -824, 120, -280},
    { -952, 328, -488},
    { -1280, -96, -152},
    { -1824, 128, 8},
    { -2144, 688, -264},
    { -1920, 608, -368},
    { -1832, 608, -272},
    { -1632, 472, -120},
    { -1640, 328, -96},
    { -1312, 312, -88},
    // 28 seconds
    { -1168, 216, -80},
    { -1192, 408, -8},
    { -1104, 608, 24},
    { -1072, 1192, -40},
    { -880, 528, -232},
    { -920, 560, -216},
    { -1024, 560, -216},
    { -1296, 464, -104},
    { -1752, 352, -32},
    { -1856, 328, -32},
    { -1824, 312, 0},
    { -1736, 248, 40},
    { -1632, 168, 80},
    { -1392, 160, 88},
    { -1160, 136, 8},
    { -1152, 160, 56},
    { -1040, 184, -136},
    { -816, -296, -144},
    { -880, -80, -216},
    { -920, -16, -408},
    { -1136, 176, -448},
    { -1352, 24, -232},
    { -1680, -64, 24},
    { -1760, 328, -32},
    { -1600, 528, 120},
    // 29 seconds
    { -1448, 528, 80},
    { -1392, 432, -32},
    { -1408, 152, 112},
    { -1328, 128, 304},
    { -1264, 304, 224},
    { -1200, 480, 112},
    { -1248, 488, 344},
    { -1152, 1856, 376},
    { -856, 160, -40},
    { -648, 576, -336},
    { -952, 560, -64},
    { -1504, 632, 288},
    { -1664, 320, 208},
    { -1592, 200, 192},
    { -1544, 240, 200},
    { -1600, 256, 240},
    { -1560, 200, 240},
    { -1384, 160, 240},
    { -1352, 152, 240},
    { -1272, 136, 176},
    { -1104, -136, 48},
    { -1112, -320, 0},
    { -1056, -240, -296},
    { -1168, 0, -224},
    { -1328, -136, -24},
    // 30 seconds
    { -1520, 40, 72},
    { -1632, 144, 160},
    { -1584, 424, 80},
    { -1568, 448, 144},
    { -1488, 448, 192},
    { -1376, 496, 176},
    { -1200, 456, 56},
    { -1080, 376, 112},
    { -1136, 536, 224},
    { -1112, 568, 232},
    { -1120, 744, 232},
    { -1024, 640, 48},
    { -1016, 512, 8},
    { -1152, 560, 40},
    { -1392, 496, 144},
    { -1816, 368, 304},
    { -1928, 272, 304},
    { -1848, 224, 360},
    { -1712, 136, 360},
    { -1576, 80, 336},
    { -1376, 64, 296},
    { -1152, 72, 264},
    { -1064, 48, 264},
    { -880, -144, 240},
    { -528, -376, -8},
    // 31 seconds
    { -840, 88, -56},
    { -1080, 192, -16},
    { -1176, 296, -144},
    { -1248, 208, -32},
    { -1456, -64, 80},
    { -1736, 48, 184},
    { -1792, 368, 152},
    { -1640, 368, 200},
    { -1664, 584, 248},
    { -1464, 240, 208},
    { -1392, 200, 280},
    { -1176, 248, 304},
    { -1104, 352, 328},
    { -1104, 816, 264},
    { -1128, 1024, 208},
    { -1128, 720, 160},
    { -1032, 424, 104},
    { -1264, 472, 16},
    { -1520, 368, 128},
    { -2000, 328, 344},
    { -1904, 80, 280},
    { -1816, 96, 400},
    { -1768, 136, 376},
    { -1576, 96, 352},
    { -1280, 112, 312},
    // 32 seconds
    { -1008, 160, 184},
    { -872, 112, 200},
    { -776, -96, 96},
    { -640, -160, 112},
    { -720, -208, 72},
    { -992, -152, -160},
    { -1296, 560, -600},
    { -1464, 232, -392},
    { -1704, 408, -576},
    { -1736, 664, -584},
    { -1376, 608, -544},
    { -1248, 536, -360},
    { -1056, 440, -168},
    { -1000, 296, -216},
    { -928, 232, -232},
    { -776, 520, -288},
    { -856, 384, -184},
    { -1144, 328, -176},
    { -1360, 520, -344},
    { -1624, 344, -176},
    { -1288, 256, -208},
    { -1424, 336, -272},
    { -1784, 408, -248},
    { -1904, 264, -376},
    { -1880, 32, -296},
    // 33 seconds
    { -1704, 160, -144},
    { -1152, -272, -272},
    { -824, 112, -288},
    { -560, -24, -288},
    { -352, 120, -432},
    { -272, 80, -448},
    { -144, -8, -600},
    { -104, 112, -776},
    { 0, 88, -936},
    { 184, 208, -1392},
    { -96, -64, -1160},
    { -184, -104, -888},
    { -160, 24, -648},
    { -72, 248, -320},
    { 64, 624, -200},
    { 160, 960, -216},
    { 40, 824, -64},
    { 72, 720, 376},
    { 88, 832, 520},
    { 128, 688, 696},
    { 64, 704, 840},
    { 144, 600, 984},
    { 128, 688, 1072},
    { 144, 704, 1072},
    { 160, 592, 1144},
    // 34 seconds
    { 176, 600, 920},
    { 216, 656, 904},
    { 232, 512, 880},
    { 208, 776, 528},
    { 144, 600, 464},
    { 216, 536, 296},
    { 232, 536, 272},
    { 248, 384, 200},
    { 232, 536, 168},
    { 312, 568, 344},
    { 368, 824, 536},
    { 592, 1160, 480},
    { 648, 1216, 592},
    { 648, 1328, 512},
    { 344, 1304, 272},
    { 224, 912, 128},
    { 152, 624, 120},
    { 152, 448, 48},
    { 136, 328, -72},
    { 144, 200, -80},
    { 168, 80, -32},
    { 184, 0, 120},
    { 216, -104, 24},
    { -120, 240, -296},
    { -416, 352, -296},
    // 35 seconds
    { -960, 368, -256},
    { -2128, 48, 48},
    { -3184, 1304, -104},
    { -2288, 408, 624},
    { -1832, 1072, -136},
    { -1448, 488, -128},
    { -1456, 344, 136},
    { -1088, 368, 240},
    { -784, 200, 48},
    { -688, 232, 32},
    { -640, 248, 8},
    { -648, 272, -40},
    { -792, 264, -40},
    { -1000, 256, 32},
    { -1416, 376, -24},
    { -1376, 208, 0},
    { -1648, 552, -96},
    { -1880, 456, -128},
    { -1544, 352, -16},
    { -1368, 240, 80},
    { -1496, 208, 144},
    { -1536, 152, 184},
    { -1264, 112, 192},
    { -984, 120, 120},
    { -744, 104, 40},
    // 36 seconds
    { -584, -32, -48},
    { -440, -144, -16},
    { -400, 72, -136},
    { -416, 56, -160},
    { -624, 152, -160},
    { -992, 40, 152},
    { -1680, 216, 224},
    { -2184, 984, 144},
    { -1784, 848, 512},
    { -1776, 672, 440},
    { -1656, 1168, 264},
    { -1232, 272, 96},
    { -1048, 232, 160},
    { -808, 256, 304},
    { -712, 328, 208},
    { -704, 184, 200},
    { -680, 584, -144},
    { -720, 488, 232},
    { -952, 840, 592},
    { -1248, 448, 304},
    { -1552, 1032, -40},
    { -1688, 840, 112},
    { -2152, 816, 488},
    { -1880, 520, 272},
    { -1928, 680, 488},
    // 37 seconds
    { -1976, 720, 440},
    { -1600, 584, 368},
    { -1136, 320, 440},
    { -736, 352, 336},
    { -536, 312, 248},
    { -264, 616, 192},
    { 32, 648, 120},
    { 224, 544, 208},
    { 376, 768, 136},
    { 400, 440, 320},
    { 536, 288, -32},
    { 1048, 128, 8},
    { 1264, -248, 48},
    { 960, -456, 8},
    { 976, -440, 8},
    { 600, -464, 32},
    { 512, -480, 0},
    { 392, -352, -32},
    { 296, -256, -72},
    { 232, -136, -136},
    { 232, -16, -8},
    { 136, 120, -88},
    { -72, 160, -136},
    { -368, 200, -144},
    { -1048, 552, -248},
    // 38 seconds
    { -3600, 528, 600},
    { -3848, 2064, 360},
    { -2576, 1104, 840},
    { -1320, 928, -24},
    { -1224, 280, 104},
    { -1448, 88, 312},
    { -1096, 208, 208},
    { -832, 328, 232},
    { -648, 360, 208},
    { -624, 336, 224},
    { -648, 472, 128},
    { -720, 608, 32},
    { -704, 616, 16},
    { -976, 488, 152},
    { -1256, 432, 72},
    { -1608, 456, 200},
    { -1528, 608, 184},
    { -1400, 616, 80},
    { -1416, 424, -32},
    { -1584, 328, 488},
    { -1768, 256, 304},
    { -1360, 312, 352},
    { -1168, 208, 304},
    { -1016, 96, 224},
    { -872, -104, 384},
    // 39 seconds
    { -712, -8, 264},
    { -712, 96, 224},
    { -824, 104, 240},
    { -752, 184, 72},
    { -808, 360, -72},
    { -888, 520, -296},
    { -1072, 216, 160},
    { -1664, 312, 248},
    { -1992, 544, 424},
    { -1768, 704, 632},
    { -928, 1224, -128},
    { -952, 8, 120},
    { -1136, 472, 272},
    { -1112, 312, 360},
    { -984, 376, 288},
    { -840, 360, 272},
    { -936, 448, 368},
    { -976, 992, 568},
    { -1072, 496, 352},
    { -1200, 672, 272},
    { -1080, 584, 232},
    { -1208, 640, 328},
    { -1576, 504, 408},
    { -1840, 440, 408},
    { -1664, 400, 472},
    // 40 seconds
    { -1528, 208, 448},
    { -1376, 224, 376},
    { -1224, 152, 336},
    { -1056, 120, 312},
    { -864, 104, 240},
    { -848, 72, 192},
    { -816, -312, 128},
    { -928, -144, 88},
    { -1088, 144, 104},
    { -1248, 336, 96},
    { -1504, 528, -40},
    { -1736, 656, -56},
    { -1840, 96, 512},
    { -1656, 248, 560},
    { -1288, 784, 264},
    { -1120, 440, 88},
    { -1176, 400, 232},
    { -1136, 312, 376},
    { -976, 296, 288},
    { -1056, 368, 272},
    { -968, 464, 400},
    { -992, 816, 584},
    { -1064, 600, 152},
    { -1048, 440, 224},
    { -1232, 672, 200},
    // 41 seconds
    { -1496, 584, 352},
    { -1704, 360, 400},
    { -1584, 320, 368},
    { -1288, 184, 448},
    { -1408, 144, 400},
    { -1392, 248, 328},
    { -1232, 184, 312},
    { -1128, 136, 320},
    { -1264, -8, 280},
    { -1240, -352, 368},
    { -1192, -272, 296},
    { -1160, 64, -32},
    { -1216, 272, 16},
    { -1352, 216, 120},
    { -1488, 120, 192},
    { -1696, 288, 288},
    { -1688, 424, 400},
    { -1520, 624, 496},
    { -1184, 1264, 216},
    { -1104, 344, 64},
    { -1104, 488, 216},
    { -1096, 440, 416},
    { -1008, 496, 440},
    { -1088, 616, 488},
    { -1072, 520, 328},
    // 42 seconds
    { -952, 416, 200},
    { -1064, 560, 192},
    { -1400, 528, 304},
    { -1664, 400, 272},
    { -1720, 456, 288},
    { -1600, 288, 392},
    { -1424, 104, 328},
    { -1440, 184, 232},
    { -1240, 144, 272},
    { -1152, 176, 272},
    { -1104, 152, 184},
    { -1056, -88, 240},
    { -1016, -208, 72},
    { -952, -8, -192},
    { -1104, 272, -64},
    { -1296, 88, 0},
    { -1520, 240, 104},
    { -1672, 240, 232},
    { -1736, 288, 376},
    { -1576, 392, 496},
    { -1280, 792, 320},
    { -1208, 208, 192},
    { -1320, 304, 320},
    { -1128, 376, 376},
    { -1016, 384, 344},
    // 43 seconds
    { -912, 400, 424},
    { -1112, 896, 424},
    { -912, 424, 224},
    { -936, 552, 168},
    { -1136, 656, 176},
    { -1456, 600, 424},
    { -1816, 408, 552},
    { -1776, 176, 432},
    { -1720, 288, 600},
    { -1672, 256, 528},
    { -1480, 0, 576},
    { -1168, 72, 512},
    { -1000, -64, 464},
    { -976, -56, 472},
    { -592, 200, -24},
    { -448, 328, 272},
    { -288, 544, 184},
    { -592, 520, 736},
    { -640, 608, 512},
    { -808, 440, 552},
    { -1000, 584, 496},
    { -944, 288, 504},
    { -880, 104, 376},
    { -960, 232, 288},
    { -1120, 208, 344},
    // 44 seconds
    { -1312, 296, 328},
    { -1464, 536, 224},
    { -1416, 584, 192},
    { -1520, 776, 344},
    { -1288, 648, 168},
    { -1408, 992, -88},
    { -1168, 808, 48},
    { -952, 592, 24},
    { -952, 504, 32},
    { -1096, 432, 152},
    { -1344, 400, 216},
    { -1408, 360, 384},
    { -1312, 408, 328},
    { -1336, 400, 368},
    { -1296, 328, 352},
    { -1160, 304, 464},
    { -952, 528, 320},
    { -992, 552, 488},
    { -816, 688, 304},
    { -616, 736, 384},
    { -280, 728, 184},
    { -128, 856, 168},
    { 72, 912, 152},
    { 48, 912, 152},
    { 56, 688, 336},
    // 45 seconds
    { 128, 736, 176},
    { 240, 704, 112},
    { 312, 536, 136},
    { 336, 480, 96},
    { 336, 440, 56},
    { 336, 360, 16},
    { 320, 360, 16},
    { 152, 408, 40},
    { -120, 776, 72},
    { -536, 816, 544},
    { -664, 1216, 224},
    { -672, 1080, 200},
    { -672, 760, 56},
    { -1024, 648, 48},
    { -1336, 376, 16},
    { -1560, 264, 72},
    { -1208, 168, 136},
    { -872, 536, -32},
    { -1032, 88, 24},
    { -1032, 344, -160},
    { -904, 320, -160},
    { -1160, 392, -200},
    { -1376, 264, -152},
    { -1736, 288, -200},
    { -1528, 216, -296},
    // 46 seconds
    { -1296, 320, -376},
    { -1136, 184, -264},
    { -1376, 184, -152},
    { -1472, 136, -104},
    { -1216, 152, -56},
    { -1032, 264, 0},
    { -792, 72, -24},
    { -584, 296, -280},
    { -544, 232, -384},
    { -328, 104, -560},
    { -264, 240, -752},
    { -160, 192, -872},
    { -200, 368, -1000},
    { -248, 496, -1072},
    { -184, 336, -976},
    { -96, 376, -960},
    { -48, 312, -912},
    { -64, 288, -872},
    { -168, 280, -872},
    { -216, 168, -784},
    { -152, 128, -768},
    { -160, 104, -616},
    { -120, -8, -688},
    { -136, 40, -704},
    { -192, 128, -944},
    // 47 seconds
    { -304, 232, -1096},
    { -312, 304, -1360},
    { -288, 288, -1504},
    { -352, 272, -1512},
    { -504, 280, -1168},
    { -392, 112, -984},
    { -240, 176, -864},
    { -160, 104, -728},
    { -80, 48, -720},
    { -32, 0, -696},
    { -8, -80, -656},
    { 24, -160, -712},
    { 0, -144, -816},
    { 40, -184, -872},
    { 0, -24, -1120},
    { -88, -176, -1136},
    { -24, 48, -1312},
    { 32, 0, -1160},
    { 120, -136, -960},
    { 144, 120, -784},
    { 344, 440, -592},
    { 272, 592, -400},
    { -48, 896, -72},
    { 16, 808, 48},
    { -24, 648, 208},
    // 48 seconds
    { -64, 432, 464},
    { -96, 520, 440},
    { -136, 296, 656},
    { -208, 248, 672},
    { -232, 416, 472},
    { -488, 104, 632},
    { -912, 232, 560},
    { -1312, 296, 768},
    { -1800, 240, 808},
    { -1776, 448, 600},
    { -1624, -128, 696},
    { -1360, 448, 392},
    { -1112, 456, 200},
    { -1096, 224, 256},
    { -1160, 216, 448},
    { -1024, 360, 288},
    { -992, 384, 232},
    { -1008, 464, 408},
    { -952, 520, 552},
    { -1056, 736, 456},
    { -1160, 808, 392},
    { -1008, 592, 376},
    { -1176, 608, 296},
    { -1448, 512, 408},
    { -1760, 544, 496},
    // 49 seconds
    { -1784, 352, 512},
    { -1656, 256, 576},
    { -1552, 376, 488},
    { -1336, 320, 480},
    { -1080, 144, 432},
    { -840, 88, 344},
    { -760, 88, 336},
    { -752, -72, 248},
    { -576, -120, -200},
    { -840, 128, -136},
    { -1112, 240, 128},
    { -1384, 568, 200},
    { -1552, 816, 112},
    { -1856, 672, 384},
    { -1800, 400, 592},
    { -1448, 880, 328},
    { -1240, 712, 240},
    { -1192, 496, 288},
    { -1216, 232, 320},
    { -1104, 296, 360},
    { -944, 400, 272},
    { -960, 472, 424},
    { -888, 600, 624},
    { -960, 648, 552},
    { -1104, 680, 384},
    // 50 seconds
    { -1048, 664, 264},
    { -1152, 568, 248},
    { -1368, 560, 200},
    { -1744, 600, 392},
    { -1816, 384, 464},
    { -1752, 360, 520},
    { -1680, 328, 520},
    { -1520, 280, 584},
    { -1304, 400, 480},
    { -1056, 440, 416},
    { -880, 456, 400},
    { -648, 488, 408},
    { -416, 648, 272},
    { -192, 576, 352},
    { 80, 856, 304},
    { 256, 960, 312},
    { 144, 848, 288},
    { 152, 760, 232},
    { 240, 568, 192},
    { 400, 544, 72},
    { 480, 376, 128},
    { 520, 336, 152},
    { 536, 448, 96},
    { 568, 408, 144},
    { 640, 568, 8},
    // 51 seconds
    { 696, 584, 192},
    { 712, 616, 192},
    { 848, 768, 240},
    { 1032, 688, 320},
    { 928, 600, 336},
    { 880, 536, 384},
    { 752, 488, 440},
    { 600, 496, 384},
    { 472, 568, 272},
    { 456, 472, 232},
    { 456, 488, 112},
    { 496, 456, 120},
    { 552, 408, 120},
    { 640, 488, 152},
    { 664, 544, 256},
    { 776, 608, 200},
    { 896, 776, 224},
    { 776, 944, 296},
    { 744, 920, 456},
    { 520, 1144, 280},
    { 432, 848, 344},
    { 544, 472, 240},
    { 568, 472, 16},
    { 592, 328, 88},
    { 528, 280, 88},
    // 52 seconds
    { 544, 312, 104},
    { 584, 384, 88},
    { 672, 416, 128},
    { 808, 584, 184},
    { 680, 744, 312},
    { 840, 768, 376},
    { 920, 808, 344},
    { 968, 752, 352},
    { 864, 624, 320},
    { 768, 496, 384},
    { 592, 488, 352},
    { 488, 440, 224},
    { 392, 384, 208},
    { 352, 368, 160},
    { 376, 440, 96},
    { 352, 544, 200},
    { 456, 600, 304},
    { 608, 880, 488},
    { 744, 864, 384},
    { 880, 856, 312},
    { 800, 936, 352},
    { 648, 1104, 448},
    { 456, 1152, 432},
    { 232, 1016, 336},
    { 160, 688, 328},
    // 53 seconds
    { 224, 440, 272},
    { 312, 424, 136},
    { 400, 320, 224},
    { 488, 328, 264},
    { 464, 448, 328},
    { 576, 456, 352},
    { 616, 592, 328},
    { 680, 632, 424},
    { 640, 752, 520},
    { 720, 688, 552},
    { 824, 792, 656},
    { 784, 656, 696},
    { 784, 640, 664},
    { 696, 496, 672},
    { 584, 432, 672},
    { 368, 472, 440},
    { 216, 416, 368},
    { 152, 288, 264},
    { 40, 552, 152},
    { 56, 376, 88},
    { 0, 392, 16},
    { -96, 296, 16},
    { -288, 248, 0},
    { -624, 144, -32},
    { -1216, 24, -88},
    // 54 seconds
    { -3664, -72, 488},
    { -3752, 880, 336},
    { -2280, 384, 752},
    { -1424, 736, -80},
    { -1656, 24, 256},
    { -1640, 56, 480},
    { -1104, 200, 288},
    { -832, 64, 288},
    { -824, 96, 320},
    { -720, 248, 456},
    { -600, 544, 232},
    { -512, 808, 328},
    { -808, 464, 496},
    { -1136, 144, 376},
    { -1392, 384, 240},
    { -1464, 576, 144},
    { -1872, 504, 256},
    { -2000, 568, 248},
    { -2368, 552, 376},
    { -2352, 400, 752},
    { -2208, 456, 936},
    { -2000, 248, 904},
    { -1592, 112, 648},
    { -1144, 40, 464},
    { -792, -112, 352},
    // 55 seconds
    { -440, -392, 72},
    { -336, -320, 120},
    { -312, -448, -304},
    { -480, -336, -120},
    { -744, -8, 32},
    { -1240, 368, 240},
    { -1920, 504, 488},
    { -2568, 1152, 384},
    { -2816, 416, 976},
    { -2024, 712, 1096},
    { -1656, 488, 56},
    { -1904, 592, 400},
    { -1624, 328, 512},
    { -1344, 280, 400},
    { -1216, 376, 368},
    { -944, 304, 536},
    { -824, 496, 800},
    { -704, 416, 448},
    { -776, 232, 432},
    { -960, 480, 552},
    { -1160, 384, 384},
    { -1136, 464, 264},
    { -1320, 592, 312},
    { -1824, 568, 464},
    { -2312, 536, 520},
    // 56 seconds
    { -2176, 280, 640},
    { -2144, 136, 576},
    { -1792, 344, 264},
    { -1520, 296, 192},
    { -1184, 304, 144},
    { -984, 288, 96},
    { -816, -232, 48},
    { -560, -360, 64},
    { -712, 56, -64},
    { -832, 272, -168},
    { -1128, 296, 8},
    { -1288, 608, -152},
    { -1640, 224, 400},
    { -1840, 160, 608},
    { -1632, 472, 616},
    { -1504, 648, 280},
    { -1480, 560, 216},
    { -1408, 328, 632},
    { -1488, 264, 528},
    { -1280, 328, 368},
    { -1304, 344, 552},
    { -1072, 504, 744},
    { -1032, 520, 488},
    { -832, 512, 272},
    { -800, 600, 216},
    // 57 seconds
    { -984, 648, 272},
    { -1304, 568, 360},
    { -1552, 312, 304},
    { -1632, 184, 328},
    { -1664, 200, 248},
    { -1688, 216, 304},
    { -1608, 184, 296},
    { -1432, 160, 280},
    { -1312, 104, 280},
    { -1184, 64, 264},
    { -1048, 32, 40},
    { -992, -240, 56},
    { -1136, 160, -144},
    { -1112, 320, -224},
    { -1224, 288, -112},
    { -1304, 96, 88},
    { -1392, 128, 232},
    { -1392, 368, 248},
    { -1400, 432, 288},
    { -1424, 368, 400},
    { -1384, 432, 392},
    { -1216, 400, 288},
    { -1120, 152, 232},
    { -1256, 280, 352},
    { -1168, 296, 456},
    // 58 seconds
    { -1176, 536, 392},
    { -968, 688, 328},
    { -848, 456, 176},
    { -976, 536, 160},
    { -1296, 440, 280},
    { -1600, 312, 280},
    { -1616, 408, -184},
    { -1376, -160, 512},
    { -1392, 0, 376},
    { -1344, 208, 272},
    { -1232, 168, 232},
    { -1112, 136, 232},
    { -1112, 48, 248},
    { -992, 24, 240},
    { -1048, 48, 80},
    { -1152, -16, 72},
    { -1240, 352, -136},
    { -1144, 264, -104},
    { -1264, 200, 40},
    { -1424, 128, 168},
    { -1424, 384, 200},
    { -1312, 440, 176},
    { -1288, 352, 296},
    { -1280, 376, 320},
    { -1208, 360, 312},
    // 59 seconds
    { -1032, 312, 240},
    { -984, 328, 272},
    { -1056, 384, 312},
    { -1048, 400, 448},
    { -1040, 624, 488},
    { -936, 408, 248},
    { -1048, 640, 128},
    { -1304, 488, 240},
    { -1568, 456, 344},
    { -1696, 376, 256},
    { -1608, 248, 296},
    { -1416, 200, 312},
    { -1320, 176, 288},
    { -1264, 128, 320},
    { -1152, 80, 296},
    { -992, 80, 336},
    { -984, 8, 232},
    { -832, -256, 56},
    { -1016, -240, 16},
    { -1176, 96, -152},
    { -1312, 248, -8},
    { -1608, 408, 48},
    { -1792, 112, 280},
    { -1960, 376, 336},
    { -1744, 584, 288},
    // 60 seconds
    // elapsed: 1 minutes
    { -1328, 504, 392},
    { -1144, 288, 248},
    { -1232, 232, 320},
    { -1144, 184, 368},
    { -960, 144, 360},
    { -912, 168, 424},
    { -920, 352, 616},
    { -840, 616, 568},
    { -912, 400, 400},
    { -1152, 456, 472},
    { -1272, 448, 432},
    { -1504, 552, 328},
    { -1944, 352, 336},
    { -2208, 392, 304},
    { -2072, 536, 624},
    { -1888, 168, 440},
    { -1688, 408, 512},
    { -1248, 72, 424},
    { -896, 8, 336},
    { -648, 40, 168},
    { -528, -48, 16},
    { -448, -304, -72},
    { -504, -328, -32},
    { -848, -160, -320},
    { -1224, 488, 360},
    // 61 seconds
    { -1632, 2456, 1040},
    { -856, 1440, 1672},
    { -464, 1224, 1152},
    { -176, 896, 1072},
    { -16, 776, 1032},
    { -16, 600, 968},
    { -80, 528, 840},
    { -152, 368, 792},
    { -120, 480, 696},
    { -80, 464, 712},
    { 64, 376, 568},
    { 56, 432, 704},
    { 144, 464, 744},
    { 184, 536, 1040},
    { 248, 640, 1112},
    { 224, 488, 976},
    { 272, 368, 920},
    { 368, 376, 856},
    { 400, 360, 808},
    { 312, 352, 544},
    { 256, 352, 472},
    { 248, 512, 488},
    { 216, 616, 544},
    { 296, 664, 368},
    { 344, 592, 344},
    // 62 seconds
    { 336, 616, 336},
    { 328, 672, 424},
    { 376, 888, 432},
    { 312, 960, 648},
    { 232, 944, 648},
    { 104, 1136, 528},
    { 112, 728, 480},
    { 152, 544, 536},
    { 160, 648, 432},
    { 248, 480, 616},
    { 328, 648, 608},
    { 312, 536, 648},
    { 296, 608, 576},
    { 272, 560, 512},
    { 256, 456, 464},
    { 240, 408, 400},
    { 216, 456, 440},
    { 288, 552, 648},
    { 152, 648, 968},
    { -24, 888, 1048},
    { -56, 816, 1112},
    { 0, 656, 904},
    { 72, 584, 728},
    { 120, 584, 688},
    { 160, 616, 808},
    // 63 seconds
    { 64, 792, 888},
    { 80, 704, 808},
    { 112, 712, 696},
    { 112, 648, 616},
    { 120, 536, 656},
    { 120, 512, 648},
    { 160, 544, 712},
    { 200, 504, 800},
    { 264, 536, 840},
    { 264, 504, 864},
    { 264, 568, 856},
    { 184, 584, 840},
    { 168, 472, 736},
    { 168, 528, 792},
    { 208, 496, 744},
    { 232, 440, 792},
    { 224, 472, 760},
    { 256, 592, 664},
    { 232, 496, 688},
    { 248, 640, 608},
    { 264, 784, 608},
    { 304, 648, 568},
    { 320, 560, 528},
    { 304, 664, 528},
    { 272, 632, 584},
    // 64 seconds
    { 248, 720, 584},
    { 224, 696, 656},
    { 240, 704, 608},
    { 240, 656, 632},
    { 248, 632, 592},
    { 240, 672, 600},
    { 248, 640, 600},
    { 232, 648, 632},
    { 224, 696, 648},
    { 216, 672, 640},
    { 216, 680, 624},
    { 216, 728, 584},
    { 216, 760, 536},
    { 224, 728, 584},
    { 256, 784, 448},
    { 264, 800, 392},
    { 272, 936, 280},
    { 104, 1296, 184},
    { 280, 544, 224},
    { 344, 768, -192},
    { 440, 984, 16},
    { 312, 784, -376},
    { 304, 784, -520},
    { 264, 752, -544},
    { 200, 680, -616},
    // 65 seconds
    { 128, 640, -672},
    { 40, 480, -736},
    { 8, 440, -832},
    { -80, 280, -864},
    { -104, 264, -912},
    { -144, 224, -904},
    { -160, 120, -968},
    { -152, 208, -968},
    { -136, 160, -920},
    { -112, 104, -896},
    { -88, 144, -888},
    { -88, 144, -880},
    { -104, 168, -912},
    { -88, 208, -944},
    { -104, 248, -976},
    { -96, 224, -976},
    { -88, 232, -968},
    { -88, 256, -1000},
    { -104, 168, -928},
    { -112, 224, -960},
    { -96, 208, -968},
    { -120, 152, -920},
    { -96, 224, -1008},
    { -96, 136, -960},
    { -80, 168, -952},
    // 66 seconds
    { -64, 184, -968},
    { -64, 168, -968},
    { -72, 176, -960},
    { -72, 176, -968},
    { -80, 192, -952},
    { -104, 168, -960},
    { -96, 200, -968},
    { -112, 120, -928},
    { -80, 240, -896},
    { -72, 216, -872},
    { -80, 192, -896},
    { -64, 272, -976},
    { -88, 232, -1008},
    { -80, 280, -992},
    { -80, 264, -992},
    { -88, 272, -960},
    { -88, 256, -952},
    { -120, 272, -936},
    { -128, 232, -944},
    { -120, 240, -960},
    { -120, 208, -952},
    { -112, 240, -936},
    { -104, 240, -904},
    { -80, 224, -896},
    { -72, 232, -912},
    // 67 seconds
    { -88, 248, -920},
    { -88, 264, -936},
    { -96, 264, -928},
    { -96, 272, -920},
    { -104, 280, -928},
    { -104, 272, -928},
    { -104, 256, -928},
    { -88, 200, -912},
    { -64, 184, -888},
    { -80, 96, -832},
    { -144, 40, -480},
    { -232, 288, -520},
    { -344, 632, -360},
    { -240, 904, -360},
    { -232, 1128, -328},
    { -40, 1216, -120},
    { 32, 1216, 216},
    { 128, 1080, 488},
    { 184, 992, 616},
    { 152, 664, 752},
    { 184, 592, 840},
    { 160, 656, 824},
    { 128, 568, 768},
    { 80, 624, 744},
    { 32, 664, 672},
    // 68 seconds
    { 80, 632, 696},
    { 56, 568, 696},
    { 104, 560, 752},
    { 104, 536, 744},
    { 104, 584, 800},
    { 112, 720, 712},
    { 104, 632, 672},
    { 80, 560, 664},
    { 112, 712, 624},
    { 96, 704, 720},
    { 168, 664, 600},
    { 200, 728, 568},
    { 216, 672, 584},
    { 200, 712, 584},
    { 232, 584, 568},
    { 224, 688, 520},
    { 176, 704, 568},
    { 176, 752, 480},
    { 176, 712, 576},
    { 192, 768, 552},
    { 184, 768, 568},
    { 176, 728, 536},
    { 184, 760, 464},
    { 184, 784, 520},
    { 232, 728, 512},
    // 69 seconds
    { 240, 832, 368},
    { 232, 816, 352},
    { 208, 848, 264},
    { 208, 864, 200},
    { 216, 832, 232},
    { 224, 840, 272},
    { 256, 928, 192},
    { 232, 776, 280},
    { 256, 872, 216},
    { 216, 856, 128},
    { 232, 776, 120},
    { 216, 760, 384},
    { 232, 864, 488},
    { 200, 1008, 496},
    { 168, 920, 368},
    { 216, 896, 248},
    { 208, 880, 88},
    { 216, 840, -48},
    { 200, 752, -200},
    { 208, 704, -376},
    { 104, 600, -504},
    { 8, 448, -744},
    { -32, 440, -928},
    { -104, 352, -984},
    { -120, 296, -888},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:26:49 local
AccelRawData *activity_sample_walk_100_pbl_25478_2(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25478_2
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 208, -112, -952},
    { 104, -264, -984},
    { 168, -288, -944},
    { 88, -264, -960},
    { 136, -248, -984},
    { -16, 40, -904},
    { 152, -208, -984},
    { 128, -248, -968},
    { 232, -144, -952},
    { 168, -224, -952},
    { 136, -232, -936},
    { 176, -224, -984},
    { 176, -208, -960},
    { 128, -232, -952},
    { 176, -240, -952},
    { 176, -240, -960},
    { 152, -240, -960},
    { 168, -248, -960},
    { 184, -320, -968},
    { 192, -192, -968},
    { 136, -256, -968},
    { 192, -256, -960},
    { 168, -192, -936},
    { 192, -216, -944},
    { 184, -248, -928},
    // 1 seconds
    { 192, -224, -944},
    { 176, -216, -944},
    { 192, -280, -968},
    { 168, -248, -944},
    { 160, -272, -960},
    { 160, -272, -952},
    { 160, -256, -944},
    { 160, -272, -944},
    { 176, -272, -944},
    { 168, -280, -936},
    { 176, -312, -952},
    { 160, -320, -944},
    { 200, -320, -928},
    { 144, -304, -928},
    { 168, -320, -920},
    { 152, -328, -952},
    { 144, -280, -960},
    { 128, -280, -952},
    { 160, -232, -952},
    { 168, -256, -944},
    { 176, -256, -936},
    { 168, -280, -928},
    { 168, -272, -920},
    { 152, -256, -952},
    { 136, -272, -960},
    // 2 seconds
    { 120, -288, -952},
    { 96, -272, -976},
    { 120, -280, -960},
    { 72, -280, -952},
    { 80, -296, -944},
    { 48, -288, -936},
    { 24, -304, -952},
    { 40, -280, -920},
    { 8, -288, -960},
    { 8, -280, -952},
    { 16, -224, -992},
    { 24, -264, -1016},
    { 32, -216, -1016},
    { 40, -240, -1056},
    { 64, -240, -1000},
    { 0, -240, -1008},
    { 24, -416, -984},
    { 16, -320, -928},
    { 0, -448, -960},
    { 0, -416, -920},
    { 8, -440, -952},
    { -8, -392, -920},
    { -16, -416, -944},
    { -40, -376, -968},
    { -56, -288, -992},
    // 3 seconds
    { 0, -432, -984},
    { -40, -216, -992},
    { -40, -272, -1024},
    { -24, -280, -968},
    { -24, 88, -944},
    { -32, 72, -1008},
    { 40, 160, -848},
    { 56, 336, -904},
    { 64, 344, -832},
    { 96, 392, -688},
    { 64, 624, -704},
    { 80, 664, -640},
    { 80, 696, -616},
    { 64, 672, -672},
    { 88, 680, -616},
    { 64, 656, -656},
    { 72, 616, -632},
    { 104, 688, -592},
    { 64, 744, -600},
    { -48, 912, -576},
    { 32, 888, -528},
    { 48, 936, -448},
    { -48, 832, -384},
    { -144, 944, -448},
    { -96, 816, -360},
    // 4 seconds
    { -56, 784, -328},
    { -64, 776, -272},
    { -8, 848, -232},
    { -16, 848, -176},
    { -24, 896, -144},
    { -40, 976, -128},
    { 0, 904, -168},
    { 56, 872, -216},
    { 88, 848, -208},
    { 120, 816, -232},
    { 128, 784, -224},
    { 144, 752, -224},
    { 168, 728, -232},
    { 184, 832, -264},
    { 176, 1016, -448},
    { -48, 1256, -576},
    { -104, 976, -528},
    { -136, 816, -504},
    { -104, 728, -504},
    { -176, 736, -488},
    { -240, 752, -520},
    { -216, 752, -480},
    { -136, 680, -504},
    { -88, 608, -544},
    { -16, 600, -488},
    // 5 seconds
    { 24, 640, -472},
    { 48, 632, -456},
    { 80, 672, -440},
    { 120, 688, -424},
    { 160, 752, -408},
    { 168, 880, -488},
    { 224, 944, -480},
    { 216, 1192, -464},
    { -8, 1368, -536},
    { -96, 1208, -456},
    { -56, 920, -336},
    { -40, 888, -288},
    { -96, 912, -288},
    { -56, 760, -304},
    { 40, 592, -296},
    { 72, 544, -272},
    { 128, 456, -304},
    { 224, 432, -304},
    { 264, 536, -360},
    { 320, 576, -408},
    { 408, 704, -480},
    { 392, 952, -592},
    { 184, 1136, -696},
    { 72, 1288, -672},
    { -160, 1264, -672},
    // 6 seconds
    { -200, 1032, -568},
    { -144, 784, -376},
    { -88, 576, -368},
    { 40, 400, -304},
    { 176, 336, -232},
    { 272, 376, -224},
    { 272, 424, -200},
    { 320, 520, -256},
    { 232, 744, -320},
    { 352, 1024, -368},
    { 336, 1296, -440},
    { 320, 1296, -488},
    { 248, 1264, -392},
    { 144, 1104, -256},
    { 184, 992, -160},
    { 152, 1024, -120},
    { 136, 1008, -144},
    { 104, 856, -184},
    { 152, 712, -168},
    { 120, 592, -192},
    { 136, 448, -224},
    { 176, 416, -208},
    { 232, 512, -240},
    { 376, 736, -256},
    { 504, 928, -312},
    // 7 seconds
    { 608, 976, -464},
    { 544, 1232, -416},
    { 320, 1408, -456},
    { 96, 1216, -512},
    { 88, 880, -352},
    { 120, 648, -360},
    { 112, 464, -368},
    { 272, 312, -232},
    { 400, 224, -200},
    { 440, 232, -272},
    { 544, 216, -248},
    { 568, 304, -272},
    { 600, 480, -368},
    { 504, 896, -424},
    { 520, 1176, -248},
    { 584, 1264, -504},
    { 472, 1112, -568},
    { 368, 800, -368},
    { 448, 824, -232},
    { 376, 936, -232},
    { 240, 872, -240},
    { 208, 712, -264},
    { 240, 560, -280},
    { 272, 488, -184},
    { 352, 624, -160},
    // 8 seconds
    { 360, 280, -64},
    { 424, 256, -184},
    { 520, 672, -280},
    { 424, 1024, -624},
    { 728, 824, -808},
    { 400, 1264, -1088},
    { -104, 1264, -1032},
    { -112, 784, -920},
    { -80, 528, -784},
    { -72, 352, -544},
    { -16, 392, -448},
    { 136, 368, -320},
    { 232, 344, -288},
    { 360, 352, -272},
    { 400, 464, -280},
    { 416, 624, -352},
    { 480, 704, -376},
    { 504, 872, -320},
    { 608, 1088, -296},
    { 568, 1488, -232},
    { 280, 1336, -312},
    { 376, 976, -256},
    { 416, 984, -96},
    { 344, 896, -136},
    { 248, 744, -216},
    // 9 seconds
    { 216, 608, -152},
    { 232, 480, -168},
    { 248, 400, -184},
    { 296, 368, -200},
    { 304, 376, -248},
    { 384, 368, -224},
    { 648, 616, -160},
    { 528, 648, -488},
    { 408, 1304, -376},
    { 464, 1936, -472},
    { 168, 1336, -384},
    { 152, 992, -336},
    { 192, 672, -288},
    { 208, 560, -272},
    { 248, 424, -216},
    { 296, 392, -168},
    { 336, 336, -104},
    { 400, 376, -88},
    { 464, 440, -96},
    { 520, 536, -184},
    { 640, 864, -264},
    { 552, 1144, -296},
    { 680, 1368, -384},
    { 584, 1416, -288},
    { 376, 1056, -288},
    // 10 seconds
    { 416, 776, -152},
    { 392, 816, -96},
    { 352, 792, -120},
    { 200, 712, -152},
    { 176, 544, -144},
    { 208, 408, -136},
    { 264, 368, -144},
    { 344, 400, -168},
    { 424, 448, -216},
    { 648, 656, -208},
    { 728, 1080, -232},
    { 616, 1296, -376},
    { 376, 1488, -520},
    { 72, 1520, -560},
    { -56, 1024, -560},
    { 112, 632, -400},
    { 240, 504, -272},
    { 264, 432, -160},
    { 280, 312, -88},
    { 432, 272, -72},
    { 488, 344, 24},
    { 632, 400, -112},
    { 688, 512, -120},
    { 752, 848, -224},
    { 728, 1040, -288},
    // 11 seconds
    { 880, 1232, -384},
    { 680, 1232, -200},
    { 528, 912, -184},
    { 536, 720, -24},
    { 536, 784, 8},
    { 384, 752, -80},
    { 264, 672, -128},
    { 264, 512, -144},
    { 264, 432, -192},
    { 312, 424, -200},
    { 336, 496, -288},
    { 440, 528, -168},
    { 632, 752, -176},
    { 608, 752, -256},
    { 768, 1104, -288},
    { 640, 1304, -256},
    { 248, 1336, -256},
    { 152, 1240, -232},
    { 160, 816, -184},
    { 248, 616, -192},
    { 264, 448, -184},
    { 320, 384, -112},
    { 344, 336, -64},
    { 392, 344, -64},
    { 472, 392, -56},
    // 12 seconds
    { 616, 480, -64},
    { 768, 776, -96},
    { 728, 1080, -96},
    { 776, 1312, -120},
    { 672, 1448, -32},
    { 528, 1176, -48},
    { 512, 856, 72},
    { 496, 816, 128},
    { 408, 720, 120},
    { 280, 600, 24},
    { 248, 424, 24},
    { 264, 352, 0},
    { 320, 344, -32},
    { 376, 432, -8},
    { 392, 544, -72},
    { 544, 648, -80},
    { 712, 824, -152},
    { 752, 952, -168},
    { 584, 1040, 32},
    { 160, 1544, 408},
    { -8, 1432, 88},
    { 96, 1048, -104},
    { 200, 928, -264},
    { 224, 688, -368},
    { 256, 480, -272},
    // 13 seconds
    { 272, 416, -216},
    { 256, 392, -80},
    { 352, 568, -16},
    { 384, 600, -40},
    { 448, 680, 8},
    { 440, 848, -144},
    { 472, 1000, -104},
    { 424, 1520, 336},
    { 440, 1824, 376},
    { 408, 1016, 392},
    { 520, 896, 464},
    { 336, 840, 408},
    { 264, 704, 288},
    { 168, 576, 176},
    { 160, 472, 0},
    { 152, 376, -96},
    { 208, 264, -152},
    { 264, 256, -112},
    { 344, 704, 24},
    { 504, 984, 40},
    { 600, 1072, 24},
    { 560, 1416, 0},
    { 392, 1288, 168},
    { 256, 1312, 88},
    { 0, 1104, -8},
    // 14 seconds
    { 24, 856, -80},
    { 120, 632, -240},
    { 168, 416, -320},
    { 256, 408, -280},
    { 280, 480, -232},
    { 264, 600, -128},
    { 232, 640, -80},
    { 288, 792, -56},
    { 480, 1064, -40},
    { 424, 1080, -128},
    { 472, 1512, -184},
    { 248, 1488, -152},
    { 80, 1328, -128},
    { 176, 1088, 8},
    { 136, 928, 40},
    { 128, 992, 0},
    { 104, 808, -40},
    { 80, 632, -8},
    { 96, 472, -88},
    { 160, 336, -88},
    { 232, 232, -72},
    { 320, 160, 0},
    { 432, 440, -128},
    { 496, 648, -200},
    { 504, 1448, -248},
    // 15 seconds
    { 400, 1712, -288},
    { 328, 1800, -368},
    { 168, 1456, -200},
    { 16, 920, -384},
    { 104, 648, -264},
    { 160, 584, -176},
    { 184, 400, -72},
    { 248, 328, -32},
    { 336, 304, -32},
    { 392, 312, -48},
    { 472, 424, -96},
    { 568, 592, -192},
    { 600, 880, -160},
    { 688, 1080, -168},
    { 992, 1200, -64},
    { 840, 1160, 0},
    { 632, 1016, -24},
    { 480, 952, 144},
    { 456, 880, 152},
    { 232, 816, 40},
    { 152, 616, -96},
    { 224, 448, -104},
    { 280, 344, -104},
    { 360, 384, -152},
    { 408, 456, -152},
    // 16 seconds
    { 536, 544, -128},
    { 688, 776, -152},
    { 760, 944, -280},
    { 728, 1264, -88},
    { 560, 1304, -96},
    { 248, 1248, -256},
    { 128, 992, -232},
    { 168, 688, -248},
    { 296, 568, -200},
    { 416, 552, -152},
    { 376, 432, -120},
    { 432, 400, -104},
    { 464, 360, -64},
    { 504, 424, -48},
    { 544, 472, -40},
    { 664, 712, 8},
    { 768, 1024, -48},
    { 824, 1216, -120},
    { 664, 1384, -96},
    { 424, 1000, -104},
    { 464, 880, 16},
    { 408, 888, 128},
    { 328, 784, 80},
    { 272, 696, -8},
    { 328, 560, 40},
    // 17 seconds
    { 288, 480, -48},
    { 272, 432, -88},
    { 360, 464, -88},
    { 456, 616, -120},
    { 544, 776, -160},
    { 600, 944, -208},
    { 656, 1128, -152},
    { 496, 1288, -176},
    { 248, 1368, -208},
    { 184, 1192, -312},
    { 152, 808, -288},
    { 224, 560, -208},
    { 272, 392, -120},
    { 368, 328, -72},
    { 464, 328, -8},
    { 688, 312, 32},
    { 664, 440, 64},
    { 632, 584, -64},
    { 656, 736, -120},
    { 592, 984, -168},
    { 632, 1080, -288},
    { 656, 1216, -184},
    { 480, 1136, -112},
    { 504, 944, 48},
    { 464, 904, 128},
    // 18 seconds
    { 400, 896, 128},
    { 336, 776, 72},
    { 296, 576, 48},
    { 288, 600, 16},
    { 256, 464, -40},
    { 280, 376, -96},
    { 344, 472, -152},
    { 480, 544, -168},
    { 696, 656, -272},
    { 696, 952, -280},
    { 728, 1240, -392},
    { 568, 1376, -336},
    { 288, 1320, -384},
    { 160, 1096, -304},
    { 176, 976, -232},
    { 248, 640, -272},
    { 368, 256, -184},
    { 432, 104, -104},
    { 448, 72, -104},
    { 488, 40, -104},
    { 616, 120, -96},
    { 784, 360, -48},
    { 760, 872, -216},
    { 728, 712, -176},
    { 840, 1360, -64},
    // 19 seconds
    { 592, 1336, -288},
    { 392, 1168, -144},
    { 392, 1064, -96},
    { 456, 920, 8},
    { 384, 952, 72},
    { 216, 808, 0},
    { 216, 600, 8},
    { 288, 512, 80},
    { 232, 336, -80},
    { 328, 296, -152},
    { 384, 368, -152},
    { 544, 496, -144},
    { 744, 872, -224},
    { 696, 936, -136},
    { 536, 1384, -256},
    { 184, 1504, -160},
    { 72, 1368, -224},
    { 72, 960, -232},
    { 160, 800, -264},
    { 160, 608, -240},
    { 184, 520, -168},
    { 264, 416, -136},
    { 288, 400, -128},
    { 360, 424, -72},
    { 400, 496, -128},
    // 20 seconds
    { 440, 696, -48},
    { 536, 1048, 8},
    { 584, 1272, 88},
    { 504, 1480, 136},
    { 336, 1408, 152},
    { 352, 1096, 152},
    { 344, 952, 152},
    { 312, 952, 152},
    { 184, 744, 56},
    { 152, 624, 16},
    { 176, 560, 64},
    { 176, 424, 40},
    { 192, 472, -8},
    { 248, 496, 16},
    { 312, 544, -72},
    { 352, 720, -176},
    { 400, 768, -152},
    { 376, 1264, -224},
    { -112, 1656, -152},
    { -16, 2264, -200},
    { -32, 1328, -184},
    { -16, 904, -256},
    { -16, 720, -224},
    { 64, 424, -128},
    { 144, 352, -96},
    // 21 seconds
    { 192, 280, -88},
    { 248, 368, -96},
    { 320, 392, -104},
    { 440, 400, -112},
    { 512, 784, -96},
    { 520, 1280, -104},
    { 584, 1176, 80},
    { 496, 1520, 96},
    { 272, 1408, 104},
    { 248, 1296, 88},
    { 112, 1208, 80},
    { -48, 968, -72},
    { -56, 648, -128},
    { -48, 472, -128},
    { 56, 440, -104},
    { 64, 432, -168},
    { 184, 416, -88},
    { 256, 616, -200},
    { 440, 632, -272},
    { 376, 832, -496},
    { 296, 1232, -472},
    { 344, 1576, -488},
    { 80, 1496, -424},
    { -200, 1144, -448},
    { -120, 888, -432},
    // 22 seconds
    { -24, 736, -368},
    { 32, 528, -352},
    { 120, 456, -256},
    { 128, 456, -192},
    { 176, 384, -144},
    { 288, 408, -96},
    { 352, 512, -112},
    { 416, 768, -168},
    { 336, 1040, -160},
    { 320, 1288, -32},
    { 280, 1728, 192},
    { 216, 1272, 224},
    { 320, 1104, 232},
    { 368, 1120, 280},
    { 208, 984, 192},
    { 144, 840, 120},
    { 96, 632, 24},
    { 48, 424, -80},
    { 96, 472, -48},
    { 80, 488, -88},
    { 144, 512, -16},
    { 248, 608, -40},
    { 392, 888, 8},
    { 288, 1096, -96},
    { 344, 1488, -168},
    // 23 seconds
    { 32, 1432, -136},
    { -24, 1480, -40},
    { -48, 1328, 24},
    { 24, 984, -120},
    { 32, 664, -152},
    { 96, 440, -120},
    { 152, 320, -120},
    { 208, 224, -128},
    { 280, 312, -120},
    { 264, 496, -80},
    { 264, 856, -104},
    { 272, 1016, -112},
    { 352, 1432, -168},
    { 264, 1928, -88},
    { 104, 1592, -184},
    { 224, 1056, -128},
    { 312, 944, 24},
    { 200, 888, 72},
    { 96, 832, 32},
    { 40, 712, 0},
    { 72, 528, -24},
    { 104, 408, -48},
    { 144, 424, -96},
    { 192, 472, -104},
    { 304, 552, -160},
    // 24 seconds
    { 344, 696, -328},
    { 280, 1024, -416},
    { 80, 1360, -680},
    { 72, 1648, -632},
    { 72, 1328, -824},
    { 32, 1008, -552},
    { 72, 944, -360},
    { 72, 656, -192},
    { 160, 440, -80},
    { 216, 384, 8},
    { 216, 368, 32},
    { 256, 384, -8},
    { 304, 432, -48},
    { 392, 576, -88},
    { 408, 992, -128},
    { 520, 1240, -216},
    { 448, 1888, -48},
    { 344, 1464, -320},
    { 312, 1304, -432},
    { 208, 984, -216},
    { 16, 944, -328},
    { -56, 816, -216},
    { -80, 584, -240},
    { -32, 392, -216},
    { 104, 344, -208},
    // 25 seconds
    { 160, 296, -208},
    { 248, 416, -168},
    { 272, 528, -200},
    { 352, 672, -360},
    { 344, 840, -384},
    { -80, 1432, -536},
    { -240, 1568, -568},
    { -288, 1592, -752},
    { -32, 1128, -496},
    { 24, 952, -416},
    { 16, 792, -288},
    { 72, 520, -176},
    { 136, 424, -104},
    { 168, 408, -40},
    { 224, 440, -16},
    { 280, 440, -24},
    { 360, 600, -64},
    { 416, 848, -96},
    { 328, 1192, -96},
    { 368, 1432, -136},
    { 272, 1624, -232},
    { 240, 1488, -360},
    { 256, 1200, -168},
    { 264, 1056, -120},
    { 168, 976, -16},
    // 26 seconds
    { 16, 864, -24},
    { -8, 600, -32},
    { 48, 504, 8},
    { 64, 408, 48},
    { 120, 256, 16},
    { 144, 360, -96},
    { 280, 424, -136},
    { 376, 584, -344},
    { 352, 1000, -392},
    { 376, 1704, -488},
    { 232, 1544, -640},
    { 176, 1952, -432},
    { -104, 1192, -216},
    { -184, 960, -312},
    { -24, 904, -368},
    { 32, 592, -368},
    { 152, 240, -176},
    { 168, 320, -120},
    { 200, 312, -32},
    { 288, 240, -8},
    { 376, 160, -48},
    { 440, 304, -56},
    { 464, 648, 16},
    { 504, 1040, 168},
    { 784, 1480, 104},
    // 27 seconds
    { 552, 1672, 8},
    { 352, 1680, 24},
    { 416, 1152, 136},
    { 408, 888, 72},
    { 312, 928, 40},
    { 72, 864, 80},
    { 24, 656, 24},
    { 56, 488, 8},
    { 64, 408, -8},
    { 80, 368, -48},
    { 152, 368, -24},
    { 288, 528, 24},
    { 520, 992, -64},
    { 376, 1376, -384},
    { 72, 1776, -408},
    { 48, 1824, -320},
    { -80, 1232, -280},
    { -88, 920, -224},
    { -112, 976, -272},
    { -88, 632, -224},
    { 56, 416, -160},
    { 168, 320, -144},
    { 192, 280, -112},
    { 240, 336, -40},
    { 336, 520, 0},
    // 28 seconds
    { 440, 640, 136},
    { 496, 912, 352},
    { 536, 1648, 576},
    { 352, 1448, 736},
    { 224, 1416, 544},
    { 256, 1192, 416},
    { 216, 952, 392},
    { 200, 856, 360},
    { 112, 792, 288},
    { 96, 648, 168},
    { 80, 520, 96},
    { 88, 448, 64},
    { 104, 400, 56},
    { 152, 400, 0},
    { 256, 360, 24},
    { 416, 848, 248},
    { 416, 1976, 48},
    { 512, 1664, -64},
    { 112, 1432, 104},
    { 88, 1264, 40},
    { -48, 880, 128},
    { -64, 720, 72},
    { 32, 640, -16},
    { 128, 472, 64},
    { 224, 344, 56},
    // 29 seconds
    { -240, 576, 232},
    { 248, 416, 168},
    { 352, 592, 216},
    { 408, 704, 224},
    { 432, 968, 344},
    { 344, 1392, 528},
    { 320, 1576, 512},
    { 264, 1560, 392},
    { 256, 1200, 240},
    { 224, 912, 272},
    { 304, 872, 248},
    { 144, 792, 264},
    { 48, 672, 240},
    { 64, 480, 160},
    { 104, 392, 160},
    { 168, 456, 120},
    { 176, 464, 64},
    { 200, 592, 48},
    { 240, 880, 24},
    { 312, 1184, -72},
    { 288, 1528, -136},
    { 168, 1560, 16},
    { 80, 1560, 8},
    { -8, 1136, -8},
    { 8, 856, -16},
    // 30 seconds
    { 48, 800, -32},
    { 80, 544, -16},
    { 184, 376, -16},
    { 232, 384, 16},
    { 200, 400, 40},
    { 248, 496, 16},
    { 256, 680, 8},
    { 344, 824, 8},
    { 344, 1064, 160},
    { 432, 1528, 176},
    { 232, 1656, 280},
    { 152, 1464, 160},
    { 160, 1096, 104},
    { 120, 1032, 144},
    { 72, 912, 136},
    { 72, 672, 8},
    { 24, 520, -16},
    { 88, 416, -32},
    { 112, 400, -24},
    { 168, 424, -16},
    { 224, 544, -40},
    { 320, 912, -56},
    { 296, 1112, -160},
    { 288, 1296, -56},
    { 64, 1768, 64},
    // 31 seconds
    { -88, 1648, 88},
    { -152, 1120, -336},
    { -344, 840, -400},
    { -232, 928, -488},
    { -128, 520, -376},
    { 8, 208, -248},
    { 48, 304, -168},
    { 56, 264, -48},
    { 144, 304, 16},
    { 184, 264, 168},
    { 144, 760, 192},
    { 0, 1352, 288},
    { -416, 1544, 344},
    { -392, 1600, 336},
    { -328, 1824, 400},
    { -296, 1304, 320},
    { -128, 1184, 256},
    { -272, 1040, 280},
    { -240, 1128, 96},
    { -264, 784, 112},
    { -184, 592, 32},
    { -176, 408, 32},
    { -176, 336, 32},
    { -112, 272, 40},
    { -144, 264, 0},
    // 32 seconds
    { -248, 248, -56},
    { -336, 1040, -280},
    { -1880, 2136, -472},
    { -344, 2168, -344},
    { -264, 1896, 656},
    { -520, 1408, 136},
    { -592, 768, 360},
    { -368, 544, 112},
    { -184, 496, 40},
    { -40, 312, 56},
    { 56, 208, 64},
    { 0, 312, 136},
    { 104, 368, 224},
    { 192, 448, 272},
    { 192, 968, 512},
    { 88, 1232, 696},
    { -40, 1728, 760},
    { -40, 1808, 600},
    { -24, 1328, 432},
    { -64, 960, 408},
    { -120, 840, 408},
    { -144, 608, 304},
    { -128, 512, 168},
    { -88, 392, 128},
    { -88, 440, -32},
    // 33 seconds
    { -72, 448, -40},
    { 40, 312, 48},
    { 168, 680, -64},
    { 264, 1128, -128},
    { 176, 1544, -128},
    { 192, 1776, -264},
    { -48, 1632, 8},
    { -8, 1408, -176},
    { -176, 992, -128},
    { -272, 864, -128},
    { -184, 664, -56},
    { -8, 368, 16},
    { 96, 256, -80},
    { 40, 184, -64},
    { 72, 192, -48},
    { 184, 200, 128},
    { 192, 776, 208},
    { -24, 1416, 496},
    { -160, 1704, 456},
    { -144, 1544, 544},
    { -168, 1560, 512},
    { -104, 1200, 520},
    { -48, 1024, 536},
    { -160, 992, 448},
    { -160, 832, 344},
    // 34 seconds
    { -152, 728, 160},
    { -128, 608, 72},
    { -136, 480, 200},
    { -120, 520, 56},
    { -24, 432, 64},
    { 24, 624, 176},
    { 88, 784, 96},
    { 136, 1032, 24},
    { -152, 1408, 280},
    { -104, 1544, 200},
    { -64, 1288, 376},
    { -200, 1160, 264},
    { -168, 952, 184},
    { -136, 784, 192},
    { -40, 576, 144},
    { 64, 496, 120},
    { 64, 480, 112},
    { 88, 552, 200},
    { 160, 552, 224},
    { 248, 648, 296},
    { 288, 904, 488},
    { 160, 1112, 656},
    { 256, 1344, 736},
    { -24, 1248, 784},
    { -48, 1048, 656},
    // 35 seconds
    { -48, 952, 712},
    { -80, 904, 672},
    { -72, 768, 432},
    { 8, 544, 264},
    { 8, 448, 240},
    { 16, 384, 176},
    { 32, 248, 280},
    { 136, 576, 336},
    { 256, 560, 352},
    { 416, 744, 552},
    { 312, 1072, 800},
    { 136, 1232, 520},
    { -168, 1752, 1048},
    { -128, 1584, 432},
    { -224, 1192, 424},
    { -216, 856, 440},
    { -104, 464, 448},
    { 8, 272, 328},
    { 48, 104, 384},
    { 88, 96, 336},
    { 128, 192, 352},
    { 224, 288, 328},
    { 312, 464, 600},
    { 328, 720, 800},
    { 280, 968, 1224},
    // 36 seconds
    { 208, 1376, 1280},
    { 152, 1264, 1192},
    { 216, 1032, 856},
    { 144, 808, 856},
    { 48, 784, 720},
    { 40, 656, 560},
    { 32, 416, 400},
    { 0, 336, 328},
    { 40, 272, 256},
    { 112, 336, 296},
    { 200, 424, 280},
    { 288, 600, 416},
    { 464, 872, 448},
    { 472, 1112, 592},
    { 504, 1296, 584},
    { 432, 1344, 688},
    { 200, 1200, 520},
    { 72, 920, 328},
    { 0, 712, 304},
    { 24, 656, 240},
    { 128, 488, 120},
    { 200, 360, 64},
    { 232, 312, 80},
    { 264, 280, 128},
    { 264, 304, 216},
    // 37 seconds
    { 288, 400, 392},
    { 408, 664, 768},
    { 336, 1008, 864},
    { 80, 888, 1024},
    { -160, 1416, 1520},
    { -64, 1080, 1232},
    { -8, 888, 912},
    { 0, 688, 880},
    { -128, 760, 880},
    { -168, 544, 664},
    { -160, 488, 520},
    { -120, 336, 336},
    { -80, 256, 360},
    { -88, 320, 312},
    { -48, 448, 240},
    { 56, 248, 344},
    { 280, 848, 272},
    { 200, 616, -8},
    { -48, 1648, 792},
    { -456, 2240, 1088},
    { -392, 1272, 1256},
    { -304, 976, 712},
    { -336, 656, 600},
    { -312, 584, 384},
    { -120, 464, 256},
    // 38 seconds
    { -8, 304, 232},
    { 128, 232, 216},
    { 160, 248, 272},
    { 152, 168, 336},
    { 160, 304, 456},
    { 168, 464, 696},
    { 112, 920, 1240},
    { -16, 984, 1408},
    { -152, 1320, 1568},
    { -24, 984, 1264},
    { 104, 544, 1024},
    { 0, 504, 952},
    { -128, 528, 960},
    { -120, 472, 768},
    { -80, 336, 624},
    { -56, 264, 544},
    { -32, 256, 488},
    { 0, 272, 400},
    { 56, 272, 384},
    { 128, 280, 384},
    { 304, 504, 496},
    { 344, 936, 696},
    { -112, 1576, 984},
    { -72, 1384, 952},
    { 16, 1416, 936},
    // 39 seconds
    { -112, 880, 744},
    { -328, 792, 496},
    { -136, 608, 392},
    { 16, 408, 304},
    { 112, 312, 248},
    { 144, 296, 312},
    { 152, 432, 296},
    { 184, 392, 376},
    { 224, 464, 512},
    { 200, 512, 552},
    { 200, 576, 872},
    { -80, 960, 1584},
    { -88, 1056, 1360},
    { -56, 1072, 1376},
    { 96, 648, 1176},
    { 56, 496, 960},
    { -8, 520, 920},
    { -32, 392, 680},
    { 0, 280, 504},
    { 8, 192, 560},
    { -24, 240, 440},
    { 8, 376, 304},
    { -56, 472, 368},
    { 64, 632, 280},
    { 152, 880, 568},
    // 40 seconds
    { 32, 1016, 816},
    { 32, 1352, 1232},
    { -296, 1440, 1480},
    { 0, 1248, 584},
    { 32, 800, 488},
    { -48, 624, 248},
    { 32, 360, 152},
    { 80, 256, 48},
    { 112, 216, 56},
    { 128, 224, 128},
    { 104, 256, 520},
    { 208, 368, 688},
    { 160, 840, 1096},
    { -24, 576, 1344},
    { 112, 848, 1720},
    { -128, 672, 1816},
    { -16, 568, 1112},
    { 112, 336, 944},
    { 104, 432, 1136},
    { -48, 376, 976},
    { -96, 440, 712},
    { -16, 360, 472},
    { 48, 240, 416},
    { 72, 224, 464},
    { 104, 264, 400},
    // 41 seconds
    { 144, 248, 360},
    { 184, 472, 480},
    { 288, 984, 480},
    { 224, 1264, 512},
    { 0, 1216, 832},
    { -560, 1192, 968},
    { -352, 1376, 808},
    { -184, 1200, 400},
    { 8, 952, 408},
    { 48, 504, 288},
    { 144, 352, 112},
    { 80, 240, 168},
    { 120, 240, 208},
    { 184, 328, 392},
    { 272, 488, 624},
    { 336, 632, 864},
    { 232, 856, 976},
    { 256, 960, 1072},
    { 128, 1088, 1296},
    { 176, 840, 1048},
    { 144, 648, 912},
    { 96, 520, 912},
    { 32, 528, 800},
    { 24, 432, 680},
    { -8, 376, 560},
    // 42 seconds
    { -40, 432, 360},
    { -56, 328, 360},
    { -8, 472, 232},
    { 96, 464, 280},
    { 192, 720, 432},
    { 256, 1264, 328},
    { 256, 1104, 800},
    { -16, 1792, 808},
    { -136, 1432, 840},
    { -304, 1056, 504},
    { -496, 800, 480},
    { -288, 792, 328},
    { -72, 592, 280},
    { 72, 400, 256},
    { -32, 312, 264},
    { 88, 224, 304},
    { 184, 200, 312},
    { 184, 320, 520},
    { 264, 184, 680},
    { 200, 480, 1072},
    { -24, 624, 1240},
    { 24, 640, 1504},
    { -64, 768, 1680},
    { 48, 616, 1304},
    { 48, 496, 1280},
    // 43 seconds
    { -72, 488, 1336},
    { -96, 472, 1040},
    { -120, 408, 848},
    { -80, 296, 680},
    { -80, 160, 496},
    { -56, 144, 384},
    { -40, 72, 240},
    { -48, 152, 168},
    { -8, 176, 224},
    { -72, 856, 208},
    { -64, 856, 248},
    { -608, 1984, 720},
    { -576, 1656, 1288},
    { -944, 1800, 1368},
    { -720, 968, 984},
    { -392, 784, 448},
    { -296, 496, 352},
    { -136, 464, 240},
    { -40, 288, 192},
    { 0, 216, 200},
    { 32, 264, 224},
    { 64, 176, 216},
    { 64, 280, 224},
    { -48, 392, 576},
    { -160, 584, 1224},
    // 44 seconds
    { -144, 880, 1464},
    { -280, 1088, 1512},
    { -152, 1008, 1568},
    { -40, 808, 1160},
    { -48, 496, 1096},
    { -192, 576, 1104},
    { -184, 368, 896},
    { -168, 480, 680},
    { -168, 304, 672},
    { -136, 288, 536},
    { -96, 248, 384},
    { -16, 192, 328},
    { 0, 280, 344},
    { 48, 416, 528},
    { 56, 1152, 408},
    { -152, 1848, 440},
    { -104, 1912, 456},
    { -272, 1560, 152},
    { -272, 968, -16},
    { -400, 784, 48},
    { -224, 640, 88},
    { -88, 608, 80},
    { 72, 448, 56},
    { 216, 400, 8},
    { 232, 344, -56},
    // 45 seconds
    { 256, 560, -160},
    { 248, 776, -264},
    { 288, 888, -312},
    { 320, 1080, -392},
    { 280, 1304, -688},
    { 88, 1440, -680},
    { 64, 1072, -400},
    { 184, 920, -320},
    { 152, 880, -336},
    { 24, 848, -160},
    { -40, 776, -256},
    { -32, 688, -192},
    { 16, 504, -32},
    { 32, 488, 48},
    { 64, 536, 80},
    { 88, 600, 288},
    { 96, 768, 544},
    { 120, 1104, 664},
    { 200, 1400, 808},
    { 192, 968, 1064},
    { 144, 1128, 904},
    { -56, 912, 736},
    { -176, 752, 616},
    { -168, 656, 496},
    { 16, 576, 376},
    // 46 seconds
    { 72, 408, 328},
    { 144, 328, 272},
    { 168, 280, 312},
    { 184, 296, 336},
    { 120, 416, 480},
    { 96, 488, 568},
    { 0, 736, 1016},
    { -88, 912, 1216},
    { 88, 976, 1248},
    { 80, 880, 1408},
    { 128, 616, 1160},
    { 56, 520, 1184},
    { -112, 560, 1128},
    { -176, 448, 928},
    { -120, 368, 664},
    { -72, 264, 632},
    { -80, 192, 568},
    { -8, 240, 552},
    { 48, 304, 528},
    { 112, 352, 488},
    { 144, 440, 608},
    { 136, 720, 792},
    { 48, 952, 896},
    { 24, 1128, 1128},
    { -88, 1056, 1112},
    // 47 seconds
    { -192, 904, 864},
    { -272, 736, 648},
    { -240, 600, 648},
    { -136, 488, 616},
    { 16, 384, 448},
    { 104, 336, 432},
    { 104, 312, 504},
    { 96, 352, 560},
    { 144, 360, 672},
    { 232, 480, 888},
    { 240, 544, 1168},
    { 176, 632, 1184},
    { 88, 880, 1424},
    { -24, 704, 1264},
    { 24, 560, 904},
    { 40, 384, 960},
    { -40, 456, 1008},
    { -72, 440, 936},
    { -56, 368, 768},
    { -24, 296, 648},
    { 0, 208, 552},
    { 0, 224, 456},
    { 48, 272, 416},
    { 64, 352, 488},
    { 64, 672, 616},
    // 48 seconds
    { 128, 1024, 736},
    { 168, 1128, 952},
    { 168, 1336, 1080},
    { 24, 1040, 968},
    { -144, 832, 784},
    { -328, 632, 688},
    { -312, 536, 528},
    { -136, 464, 488},
    { -24, 392, 440},
    { 56, 328, 456},
    { 80, 288, 512},
    { 88, 352, 544},
    { 112, 496, 648},
    { 152, 456, 728},
    { 208, 632, 896},
    { 168, 744, 1120},
    { 224, 1088, 1360},
    { 8, 1136, 1232},
    { 144, 904, 832},
    { 144, 752, 960},
    { 32, 728, 920},
    { -112, 736, 792},
    { -104, 592, 600},
    { -88, 400, 424},
    { -88, 296, 272},
    // 49 seconds
    { -48, 288, 264},
    { -16, 104, 64},
    { 16, 168, 144},
    { -80, 400, 112},
    { -64, 616, 24},
    { -696, 1712, 432},
    { -744, 2048, 1592},
    { -360, 1904, 952},
    { -328, 1256, 592},
    { -568, 752, 520},
    { -560, 752, 248},
    { -392, 496, 248},
    { -160, 400, 184},
    { -24, 320, 88},
    { -48, 208, 240},
    { -16, 264, 304},
    { 48, 256, 472},
    { 64, 336, 664},
    { 40, 720, 864},
    { -192, 640, 1184},
    { -352, 1320, 1368},
    { -336, 1456, 1512},
    { -112, 1160, 832},
    { -24, 712, 760},
    { -72, 584, 848},
    // 50 seconds
    { -128, 648, 760},
    { -128, 544, 640},
    { -104, 440, 536},
    { -64, 296, 464},
    { -24, 248, 424},
    { -64, 280, 456},
    { -48, 344, 336},
    { -16, 464, 416},
    { -72, 944, 408},
    { 24, 1096, 568},
    { -80, 1784, 792},
    { -120, 1504, 728},
    { -192, 1288, 464},
    { -256, 1064, 320},
    { -440, 896, 232},
    { -256, 592, 312},
    { -64, 408, 304},
    { 16, 368, 264},
    { 24, 360, 304},
    { 32, 344, 384},
    { 48, 392, 456},
    { 80, 504, 520},
    { 120, 696, 608},
    { 88, 848, 864},
    { 72, 1152, 1192},
    // 51 seconds
    { -72, 1368, 1304},
    { 56, 1064, 888},
    { 104, 760, 776},
    { 32, 584, 936},
    { -24, 688, 800},
    { -112, 584, 672},
    { -88, 440, 560},
    { -96, 376, 512},
    { -120, 416, 320},
    { -48, 360, 288},
    { -40, 408, 408},
    { 88, 512, 472},
    { 104, 840, 832},
    { 40, 1184, 800},
    { 56, 1176, 768},
    { -40, 1224, 1000},
    { -112, 1152, 648},
    { -216, 824, 544},
    { -264, 696, 440},
    { -232, 640, 344},
    { -112, 472, 272},
    { -32, 432, 208},
    { 8, 368, 208},
    { 32, 344, 336},
    { 32, 288, 456},
    // 52 seconds
    { 56, 328, 504},
    { -64, 720, 816},
    { -168, 504, 1360},
    { -448, 1360, 1568},
    { -312, 1064, 1632},
    { -56, 824, 1144},
    { -32, 464, 1008},
    { -120, 392, 968},
    { -304, 352, 992},
    { -360, 264, 840},
    { -296, 240, 584},
    { -224, 232, 408},
    { -192, 216, 528},
    { -112, 336, 520},
    { 64, 376, 640},
    { 80, 648, 696},
    { 8, 760, 720},
    { -72, 1200, 848},
    { -56, 1408, 832},
    { -120, 1168, 720},
    { -376, 1024, 688},
    { -504, 728, 608},
    { -392, 576, 504},
    { -256, 416, 544},
    { -104, 304, 376},
    // 53 seconds
    { -64, 280, 328},
    { -24, 232, 336},
    { 8, 296, 560},
    { 8, 344, 720},
    { 96, 336, 984},
    { -80, 592, 1304},
    { -72, 920, 1320},
    { -232, 1080, 1544},
    { -272, 1064, 1304},
    { -152, 720, 872},
    { -136, 520, 896},
    { -248, 432, 960},
    { -208, 424, 760},
    { -168, 352, 616},
    { -136, 296, 576},
    { -144, 256, 560},
    { -128, 312, 448},
    { -72, 344, 408},
    { 40, 344, 568},
    { 48, 616, 720},
    { -24, 1064, 784},
    { -128, 1104, 1104},
    { -32, 1424, 1048},
    { -296, 1104, 856},
    { -424, 800, 584},
    // 54 seconds
    { -472, 624, 680},
    { -240, 480, 624},
    { 8, 368, 440},
    { 64, 328, 384},
    { 104, 320, 392},
    { 144, 312, 368},
    { 152, 304, 504},
    { 144, 440, 616},
    { 168, 464, 824},
    { 96, 688, 1168},
    { 56, 992, 1472},
    { -16, 1240, 1440},
    { 96, 960, 1056},
    { 144, 672, 1232},
    { 160, 464, 1088},
    { 40, 376, 896},
    { -8, 264, 600},
    { -24, 160, 424},
    { -72, 152, 368},
    { 0, -48, 264},
    { -8, 136, 136},
    { 88, 176, 200},
    { 48, 504, 224},
    { 112, 1224, 288},
    { -152, 1480, 1344},
    // 55 seconds
    { -472, 2200, 1624},
    { -192, 1368, 1568},
    { -280, 968, 944},
    { -488, 608, 712},
    { -560, 528, 368},
    { -280, 392, 320},
    { -8, 448, 272},
    { 120, 360, 272},
    { 200, 416, 264},
    { 264, 464, 272},
    { 336, 408, 264},
    { 336, 352, 248},
    { 328, 440, 264},
    { 376, 592, 688},
    { 488, 1032, 752},
    { -72, 1368, 1152},
    { 128, 792, 1152},
    { 96, 1016, 960},
    { 152, 696, 1048},
    { -8, 680, 936},
    { 56, 648, 696},
    { 88, 440, 624},
    { 80, 328, 488},
    { 80, 320, 424},
    { 72, 344, 368},
    // 56 seconds
    { 112, 336, 328},
    { 144, 360, 384},
    { 144, 744, 400},
    { 104, 1080, 864},
    { 96, 1264, 1264},
    { 312, 1928, 936},
    { 128, 1352, 712},
    { -152, 744, 528},
    { -352, 616, 352},
    { -184, 424, 336},
    { 16, 376, 336},
    { 96, 272, 248},
    { 152, 272, 328},
    { 136, 368, 368},
    { 176, 392, 440},
    { 208, 424, 544},
    { 200, 688, 848},
    { 216, 800, 984},
    { 160, 992, 1208},
    { 320, 1472, 1176},
    { 248, 1112, 1064},
    { 144, 744, 768},
    { 80, 584, 800},
    { 24, 504, 856},
    { -88, 504, 824},
    // 57 seconds
    { -88, 464, 616},
    { -48, 336, 544},
    { 0, 336, 488},
    { 32, 320, 368},
    { 112, 320, 384},
    { 176, 416, 360},
    { 272, 704, 488},
    { 248, 1136, 744},
    { 144, 1424, 680},
    { 272, 1392, 880},
    { 128, 1232, 792},
    { -152, 912, 496},
    { -408, 736, 344},
    { -280, 608, 264},
    { -64, 440, 240},
    { 48, 368, 184},
    { 16, 408, 224},
    { 24, 368, 280},
    { 32, 408, 400},
    { 0, 608, 712},
    { 0, 800, 800},
    { -8, 1008, 1112},
    { -48, 1008, 1240},
    { -120, 1168, 1400},
    { -96, 936, 1096},
    // 58 seconds
    { -48, 632, 840},
    { -16, 488, 856},
    { -56, 520, 872},
    { -96, 504, 840},
    { -88, 440, 696},
    { -64, 336, 600},
    { -48, 288, 528},
    { -56, 304, 488},
    { -40, 304, 424},
    { -8, 408, 400},
    { 8, 664, 512},
    { -72, 1024, 712},
    { -72, 1328, 872},
    { 8, 1456, 1016},
    { -32, 1144, 944},
    { -192, 880, 656},
    { -304, 648, 576},
    { -344, 592, 536},
    { -192, 512, 448},
    { -40, 408, 368},
    { 32, 336, 352},
    { 64, 344, 424},
    { 104, 352, 456},
    { 136, 440, 656},
    { 192, 536, 816},
    // 59 seconds
    { 144, 752, 1096},
    { 136, 712, 1216},
    { 88, 880, 1448},
    { 96, 968, 1176},
    { 144, 736, 848},
    { 176, 472, 840},
    { 120, 488, 888},
    { -72, 464, 856},
    { -128, 456, 760},
    { -120, 312, 608},
    { -96, 304, 536},
    { -56, 304, 456},
    { 32, 304, 408},
    { 104, 384, 384},
    { 64, 432, 528},
    { 168, 800, 592},
    { 32, 1000, 880},
    { -80, 1152, 1272},
    { -128, 1200, 1328},
    { -256, 896, 1128},
    { -200, 664, 784},
    { -240, 688, 728},
    { -136, 504, 688},
    { -16, 328, 504},
    { 64, 224, 424},
    // 60 seconds
    // elapsed: 1 minutes
    { 80, 248, 456},
    { 88, 184, 512},
    { 112, 248, 608},
    { 128, 336, 680},
    { 168, 536, 840},
    { 184, 600, 920},
    { 216, 744, 1104},
    { 344, 1000, 1304},
    { 168, 1040, 1264},
    { 208, 864, 904},
    { 176, 568, 1048},
    { 48, 768, 1000},
    { 48, 648, 904},
    { -24, 520, 584},
    { 40, 384, 472},
    { 80, 280, 272},
    { 120, 248, 232},
    { 168, 304, 136},
    { 232, 200, 216},
    { 192, 440, 184},
    { 336, 376, 560},
    { 248, 880, 840},
    { 208, 1536, 1112},
    { 264, 1408, 1248},
    { 264, 1048, 928},
    // 61 seconds
    { 88, 744, 752},
    { -168, 832, 648},
    { -184, 760, 608},
    { -128, 656, 440},
    { -56, 560, 376},
    { 0, 432, 376},
    { 40, 592, 480},
    { 64, 616, 584},
    { 64, 928, 640},
    { 168, 920, 576},
    { 144, 904, 480},
    { 176, 912, 336},
    { 184, 736, 272},
    { 168, 1024, 168},
    { 48, 1344, -32},
    { 72, 920, 128},
    { 72, 432, -136},
    { 104, 712, -408},
    { 104, 680, -328},
    { 160, 824, -432},
    { 208, 768, -440},
    { 184, 784, -416},
    { 136, 720, -480},
    { 96, 872, -472},
    { 64, 768, -192},
    // 62 seconds
    { 24, 752, -120},
    { -8, 840, 176},
    { 72, 888, 392},
    { -32, 864, 352},
    { -32, 744, 592},
    { -88, 928, 632},
    { -64, 848, 704},
    { -16, 696, 816},
    { 48, 680, 880},
    { 56, 584, 832},
    { 48, 528, 808},
    { 16, 504, 696},
    { 0, 552, 720},
    { 0, 664, 696},
    { -24, 768, 616},
    { 16, 680, 632},
    { 8, 840, 576},
    { 64, 696, 648},
    { 96, 832, 584},
    { 56, 712, 576},
    { 64, 832, 488},
    { 112, 832, 424},
    { 144, 776, 360},
    { 168, 864, 184},
    { 152, 864, -8},
    // 63 seconds
    { 96, 792, -200},
    { 112, 688, -304},
    { 64, 696, -480},
    { 88, 752, -512},
    { 80, 672, -576},
    { 72, 568, -624},
    { 120, 528, -512},
    { 48, 712, -592},
    { -64, 696, -624},
    { -64, 616, -864},
    { -104, 688, -760},
    { 16, 464, -800},
    { 184, 352, -904},
    { 104, 336, -952},
    { 112, 320, -944},
    { 88, 144, -936},
    { 32, 0, -904},
    { 96, -136, -928},
    { 16, -88, -952},
    { 16, 24, -984},
    { -136, 16, -984},
    { 160, -104, -992},
    { -48, 64, -1008},
    { 48, -24, -1008},
    { 48, -120, -1016},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:31:09 local
AccelRawData *activity_sample_walk_100_pbl_25478_3(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25478_3
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -280, -392, -928},
    { -184, -432, -904},
    { -184, -328, -960},
    { -128, -384, -928},
    { -280, -360, -960},
    { -192, -376, -968},
    { -184, -384, -944},
    { -200, -424, -936},
    { -352, -384, -848},
    { 40, -272, -1480},
    { -368, -528, -976},
    { -256, -344, -1008},
    { -216, -544, -920},
    { -144, -536, -936},
    { -120, -536, -888},
    { -96, -536, -840},
    { -56, -552, -880},
    { -32, -480, -864},
    { -16, -416, -848},
    { 16, -384, -856},
    { -24, -480, -832},
    { -32, -424, -864},
    { -40, -408, -888},
    { -40, -416, -960},
    { -80, -480, -992},
    // 1 seconds
    { -56, -440, -936},
    { -56, -416, -912},
    { -88, -464, -928},
    { -112, -520, -912},
    { -104, -440, -928},
    { -96, -440, -944},
    { -72, -256, -944},
    { -48, -272, -944},
    { -96, -400, -944},
    { -144, -320, -968},
    { -104, -464, -912},
    { -104, -248, -1000},
    { -80, -424, -944},
    { -112, -472, -880},
    { -144, -416, -968},
    { -80, -560, -968},
    { -16, -480, -784},
    { 0, -464, -768},
    { 48, -432, -776},
    { 112, -280, -792},
    { 56, 224, -840},
    { 136, 632, -696},
    { 120, 768, -408},
    { 128, 992, -256},
    { 160, 968, -160},
    // 2 seconds
    { 184, 992, 88},
    { 176, 920, 288},
    { 152, 936, 408},
    { 144, 920, 360},
    { 120, 800, 392},
    { 112, 824, 368},
    { 152, 848, 416},
    { 160, 888, 376},
    { 176, 872, 344},
    { 184, 880, 232},
    { 200, 864, 280},
    { 192, 912, 264},
    { 200, 984, 80},
    { 128, 800, 256},
    { 88, 936, 80},
    { 72, 968, 72},
    { -16, 840, 64},
    { -80, 664, 64},
    { -152, 696, 16},
    { -200, 608, -72},
    { -224, 392, -88},
    { -360, 272, -216},
    { -544, 320, -208},
    { -696, 264, -208},
    { -1296, 216, 456},
    // 3 seconds
    { -2152, 296, -920},
    { -2120, 464, 8},
    { -1136, 992, 0},
    { -1048, 568, -216},
    { -1136, 608, 152},
    { -880, 352, 8},
    { -984, 448, -16},
    { -1072, 640, 104},
    { -920, 728, 80},
    { -808, 664, 80},
    { -1112, 608, 184},
    { -1248, 512, 192},
    { -1312, 568, 184},
    { -1392, 344, 136},
    { -1392, 384, 216},
    { -1288, 192, 112},
    { -1104, 160, 136},
    { -968, 232, 152},
    { -912, 208, 160},
    { -832, 216, 152},
    { -816, 192, 120},
    { -720, 192, 136},
    { -696, 8, 160},
    { -1000, 48, -96},
    { -1168, 144, -224},
    // 4 seconds
    { -1176, -144, -72},
    { -1512, -224, 72},
    { -1664, 232, -64},
    { -1512, 208, -280},
    { -1336, 496, -176},
    { -1104, 328, -296},
    { -1016, 248, -160},
    { -1080, 432, -104},
    { -904, 408, -48},
    { -872, 408, -88},
    { -784, 312, -128},
    { -768, 360, -176},
    { -808, 352, -248},
    { -952, 408, -216},
    { -1544, 328, -144},
    { -1496, 216, -216},
    { -1416, 328, -232},
    { -1224, 248, -216},
    { -1448, 336, -80},
    { -1560, 304, 0},
    { -1368, 176, -40},
    { -1184, 104, -32},
    { -1064, 104, -32},
    { -928, 104, -8},
    { -808, 104, -8},
    // 5 seconds
    { -712, 168, 32},
    { -776, 136, 16},
    { -800, 64, 72},
    { -760, 72, 24},
    { -976, 88, -56},
    { -1232, 112, -208},
    { -1440, 48, -288},
    { -1536, -80, -432},
    { -1576, -104, -216},
    { -1496, 112, -416},
    { -1328, 240, -352},
    { -1152, 264, -192},
    { -1024, 176, -96},
    { -1000, 208, -48},
    { -960, 304, -16},
    { -848, 352, -40},
    { -792, 344, -104},
    { -872, 392, -136},
    { -976, 344, -192},
    { -1224, 280, -160},
    { -1416, 240, -360},
    { -1536, 312, -400},
    { -1296, 296, -464},
    { -1304, 256, -352},
    { -1568, 224, -208},
    // 6 seconds
    { -1912, 232, -64},
    { -1864, 192, 24},
    { -1568, 136, 56},
    { -1288, 112, 48},
    { -1072, 128, 72},
    { -896, 152, 56},
    { -736, 136, 32},
    { -648, 24, 8},
    { -584, -88, 88},
    { -560, -16, 32},
    { -592, 48, -200},
    { -816, 112, -224},
    { -1256, 168, -432},
    { -1808, -160, -392},
    { -2248, 32, -384},
    { -1944, 672, -120},
    { -1176, 696, -504},
    { -1032, 432, -264},
    { -1248, 448, -48},
    { -1152, 344, 104},
    { -976, 392, 64},
    { -800, 400, -48},
    { -944, 416, 64},
    { -1144, 536, 184},
    { -1112, 752, 256},
    // 7 seconds
    { -1112, 408, 16},
    { -1088, 496, 96},
    { -888, 616, -24},
    { -1096, 616, -8},
    { -1440, 528, 0},
    { -1808, 376, -48},
    { -1944, 344, -48},
    { -1888, 280, 48},
    { -1624, 112, 56},
    { -1352, 152, 8},
    { -1096, 152, 32},
    { -864, 168, -40},
    { -880, 288, -72},
    { -704, -120, 56},
    { -520, -336, 80},
    { -576, -160, -120},
    { -856, 48, -176},
    { -1312, 24, -272},
    { -1672, 264, -496},
    { -1968, -208, -152},
    { -1904, 120, -264},
    { -1568, 544, -496},
    { -1528, 216, -160},
    { -1400, 248, -96},
    { -1184, 224, -72},
    // 8 seconds
    { -1000, 248, -64},
    { -832, 224, -24},
    { -864, 288, 80},
    { -904, 488, 104},
    { -888, 656, 80},
    { -776, 520, 24},
    { -1000, 336, -24},
    { -1280, 680, -232},
    { -1344, 616, 32},
    { -1408, 120, -208},
    { -1400, 8, -352},
    { -1664, 256, -280},
    { -1824, 256, -144},
    { -1728, 88, -272},
    { -1776, 160, 16},
    { -1536, 104, -8},
    { -1304, 32, -24},
    { -1024, 48, -24},
    { -824, 136, 24},
    { -648, 48, 8},
    { -432, -152, 72},
    { -352, -144, -8},
    { -328, -40, -120},
    { -712, 56, -104},
    { -1096, 40, -392},
    // 9 seconds
    { -1424, 16, -456},
    { -1856, 56, -176},
    { -2176, 32, -240},
    { -1960, 368, -200},
    { -1624, 288, -56},
    { -1432, 240, -40},
    { -1240, 264, -32},
    { -1080, 304, -32},
    { -976, 344, -48},
    { -888, 376, 8},
    { -800, 464, -96},
    { -792, 544, -120},
    { -864, 448, -136},
    { -944, 384, -112},
    { -984, 288, -168},
    { -1296, 376, -64},
    { -1424, 424, 16},
    { -1568, 360, 96},
    { -1616, 248, 96},
    { -1736, 248, 152},
    { -1800, 272, 192},
    { -1664, 192, 200},
    { -1488, 128, 192},
    { -1344, 120, 184},
    { -1176, 120, 144},
    // 10 seconds
    { -976, 120, 120},
    { -840, 136, 96},
    { -712, 120, 64},
    { -664, 88, 88},
    { -552, 40, 80},
    { -456, 56, -16},
    { -672, 168, -104},
    { -904, 80, -104},
    { -1272, 224, -240},
    { -1688, 208, -464},
    { -1960, 0, -224},
    { -1776, 80, -600},
    { -1416, 128, -232},
    { -1464, -48, -232},
    { -1240, 376, -96},
    { -960, 368, -176},
    { -928, 288, -208},
    { -920, 296, -152},
    { -920, 320, -96},
    { -896, 392, -184},
    { -928, 296, -184},
    { -936, 208, -128},
    { -992, 224, -128},
    { -1056, 208, -96},
    { -1184, 216, -24},
    // 11 seconds
    { -1640, 328, -8},
    { -1624, 360, 24},
    { -1248, 200, 128},
    { -1160, 120, 96},
    { -1344, 168, 128},
    { -1408, 200, 176},
    { -1304, 216, 184},
    { -1120, 176, 176},
    { -968, 144, 168},
    { -880, 152, 160},
    { -808, 152, 144},
    { -808, 160, 136},
    { -816, 176, 96},
    { -816, 160, 56},
    { -896, 128, 32},
    { -968, 168, -48},
    { -984, 80, -112},
    { -1056, 64, -280},
    { -1472, -48, -272},
    { -1568, -64, -808},
    { -1280, -232, -552},
    { -1184, -16, -616},
    { -1216, 64, -528},
    { -1248, 272, -432},
    { -1112, 256, -376},
    // 12 seconds
    { -1000, 248, -176},
    { -928, 232, -72},
    { -928, 216, -32},
    { -912, 216, -56},
    { -872, 224, -40},
    { -832, 264, -32},
    { -752, 208, -48},
    { -816, 192, -40},
    { -944, 216, -16},
    { -1288, 216, 24},
    { -1512, 344, -32},
    { -1336, 328, 32},
    { -1280, 312, 0},
    { -1408, 264, 48},
    { -1528, 240, 24},
    { -1440, 200, 72},
    { -1256, 120, 72},
    { -1072, 88, 64},
    { -952, 80, 56},
    { -832, 88, 48},
    { -776, 104, 48},
    { -824, 120, 72},
    { -824, 112, 48},
    { -880, 72, 48},
    { -1040, 72, -32},
    // 13 seconds
    { -1320, 288, -288},
    { -1352, 152, -456},
    { -1424, -56, -280},
    { -1448, -272, -168},
    { -1440, 24, -296},
    { -1272, 152, -88},
    { -1160, 280, 0},
    { -1104, 296, 48},
    { -1040, 296, 0},
    { -928, 312, -72},
    { -768, 288, -48},
    { -776, 320, -160},
    { -936, 384, -136},
    { -1208, 472, -80},
    { -1440, 304, -200},
    { -1312, 232, -184},
    { -1184, 352, -288},
    { -1312, 240, -248},
    { -1528, 200, -256},
    { -1568, 136, -144},
    { -1528, 160, -16},
    { -1392, 136, 24},
    { -1256, 160, 40},
    { -1128, 136, 48},
    { -952, 144, 72},
    // 14 seconds
    { -848, 144, 64},
    { -800, 128, 64},
    { -736, 64, 112},
    { -584, 48, 104},
    { -720, 72, 64},
    { -936, 104, -144},
    { -1272, 400, -448},
    { -1360, -16, -440},
    { -1520, -328, -256},
    { -1848, -88, -160},
    { -1824, 416, -416},
    { -1496, 904, -112},
    { -1272, 272, -184},
    { -1248, 280, -48},
    { -1192, 312, 8},
    { -944, 248, -112},
    { -824, 200, -112},
    { -848, 400, -72},
    { -784, 424, -320},
    { -1072, 632, -216},
    { -1272, 584, -304},
    { -1128, 392, -368},
    { -1352, 376, -280},
    { -1696, 496, -264},
    { -1952, 304, -280},
    // 15 seconds
    { -1736, 64, 312},
    { -1656, 120, 80},
    { -1600, 32, 96},
    { -1424, 152, 24},
    { -1176, 112, -8},
    { -920, 152, 8},
    { -720, 96, 16},
    { -664, -48, 88},
    { -440, -272, 160},
    { -528, -192, 56},
    { -952, 16, -136},
    { -1304, 176, -216},
    { -1496, 248, -456},
    { -1840, 72, -272},
    { -2168, 128, -24},
    { -2152, 360, 0},
    { -1680, 784, -128},
    { -1344, 328, -184},
    { -1280, 416, -40},
    { -1120, 432, 24},
    { -928, 352, 16},
    { -784, 344, 16},
    { -664, 472, 24},
    { -680, 528, -32},
    { -752, 424, -16},
    // 16 seconds
    { -1152, 504, 16},
    { -1368, 568, -64},
    { -1336, 448, -96},
    { -1624, 512, -152},
    { -1928, 440, -96},
    { -1960, 416, -136},
    { -1784, 288, -72},
    { -1704, 192, 56},
    { -1568, 192, 8},
    { -1336, 168, 32},
    { -1016, 136, 24},
    { -808, 120, 24},
    { -736, 16, 48},
    { -560, -232, 128},
    { -536, -104, 56},
    { -728, 88, -24},
    { -952, 120, -168},
    { -1352, 376, -496},
    { -1584, 184, -352},
    { -1784, -272, -208},
    { -1800, 72, -168},
    { -1544, 472, -280},
    { -1376, 360, -216},
    { -1336, 384, -128},
    { -1256, 328, -72},
    // 17 seconds
    { -1160, 304, -40},
    { -992, 288, -24},
    { -912, 344, 72},
    { -864, 600, 32},
    { -856, 712, -120},
    { -1000, 320, -56},
    { -1264, 624, -40},
    { -1128, 536, -152},
    { -1184, 472, -136},
    { -1456, 448, -8},
    { -1760, 384, 120},
    { -1824, 304, 160},
    { -1744, 176, 192},
    { -1632, 120, 168},
    { -1472, 120, 120},
    { -1232, 104, 112},
    { -984, 120, 88},
    { -832, 120, 80},
    { -720, 104, 56},
    { -656, 32, 80},
    { -608, -16, 32},
    { -776, 80, -96},
    { -968, 232, -288},
    { -1192, 360, -304},
    { -1640, 64, -176},
    // 18 seconds
    { -2024, -168, 40},
    { -1640, 256, -96},
    { -1152, 64, -144},
    { -1184, 152, 32},
    { -1240, 312, 232},
    { -1112, 384, 128},
    { -912, 312, 48},
    { -800, 280, -96},
    { -952, 312, -200},
    { -1288, 496, -160},
    { -1328, 1136, -264},
    { -1336, 248, -56},
    { -1040, 128, -208},
    { -1016, 376, -160},
    { -1320, 528, 64},
    { -1688, 432, 160},
    { -1728, 312, 112},
    { -1600, 176, 184},
    { -1536, 136, 232},
    { -1432, 112, 200},
    { -1272, 104, 152},
    { -1096, 112, 128},
    { -976, 112, 120},
    { -912, 104, 80},
    { -760, -128, 184},
    // 19 seconds
    { -632, -208, 8},
    { -952, 24, -104},
    { -1224, 136, -304},
    { -1352, 144, -232},
    { -1584, -8, 72},
    { -1616, 80, -96},
    { -1512, 152, -208},
    { -1384, 328, -192},
    { -1264, 144, 584},
    { -1256, 128, 24},
    { -1176, 312, -24},
    { -1000, 336, -24},
    { -856, 360, -24},
    { -984, 448, 16},
    { -1136, 648, 72},
    { -1144, 464, -32},
    { -1152, 392, -128},
    { -1024, 400, -72},
    { -1072, 432, -56},
    { -1368, 440, 8},
    { -1688, 360, 16},
    { -1840, 360, 32},
    { -1744, 224, 112},
    { -1608, 112, 136},
    { -1424, 112, 88},
    // 20 seconds
    { -1192, 112, 72},
    { -968, 136, 88},
    { -872, 168, 48},
    { -784, 0, -40},
    { -640, 184, 232},
    { -568, 64, 120},
    { -744, 160, -32},
    { -936, 192, -112},
    { -1144, 232, -392},
    { -1448, 96, -256},
    { -1936, 16, -48},
    { -1992, 312, -248},
    { -1576, 912, -232},
    { -1200, 456, -56},
    { -1272, 360, 168},
    { -1176, 320, 64},
    { -1008, 376, 48},
    { -864, 440, -16},
    { -760, 352, 0},
    { -792, 464, -8},
    { -840, 752, 16},
    { -920, 408, -120},
    { -1120, 664, -32},
    { -1144, 544, -248},
    { -1240, 488, -80},
    // 21 seconds
    { -1520, 456, 0},
    { -1616, 440, -40},
    { -1752, 456, 80},
    { -1552, 432, 128},
    { -1520, 360, 272},
    { -1480, 328, 352},
    { -1376, 160, 328},
    { -1064, 8, 168},
    { -864, 112, 184},
    { -752, 112, 136},
    { -688, 120, 176},
    { -608, 64, 224},
    { -760, 88, 248},
    { -864, 192, 8},
    { -704, 408, -208},
    { -776, 472, -184},
    { -1560, 600, -416},
    { -1968, 1248, -480},
    { -1416, 880, -80},
    { -1056, 688, -264},
    { -944, -16, -320},
    { -1152, 488, -208},
    { -1000, 392, -56},
    { -864, 416, -32},
    { -832, 424, -64},
    // 22 seconds
    { -800, 392, -64},
    { -840, 416, -88},
    { -928, 424, 0},
    { -1080, 376, 80},
    { -1376, 384, 24},
    { -1416, 352, 56},
    { -1224, 352, 16},
    { -1280, 176, 40},
    { -1432, 280, 88},
    { -1320, 232, 160},
    { -1144, 184, 136},
    { -1144, 216, 128},
    { -1248, 240, 176},
    { -1168, 216, 240},
    { -1000, 184, 256},
    { -856, 144, 216},
    { -864, 160, 208},
    { -880, 184, 240},
    { -968, 240, 272},
    { -952, 168, 248},
    { -928, 192, 192},
    { -1112, 336, -8},
    { -1248, 368, -184},
    { -1168, 368, -392},
    { -1192, 248, -744},
    // 23 seconds
    { -1368, -152, -1224},
    { -1104, -1112, -1816},
    { -1152, -296, -824},
    { -944, -88, -640},
    { -1000, 24, -472},
    { -960, 8, -280},
    { -888, 88, -80},
    { -840, 120, 64},
    { -752, 232, 64},
    { -736, 248, -8},
    { -736, 216, -56},
    { -832, 224, -88},
    { -1120, 264, -88},
    { -1408, 320, -104},
    { -1352, 448, -248},
    { -1136, 208, -392},
    { -1088, 384, -424},
    { -1280, 616, -256},
    { -1480, 152, -32},
    { -1448, 24, 24},
    { -1192, -8, 24},
    { -1008, 24, -8},
    { -904, 80, 0},
    { -816, 176, -32},
    { -736, 216, 8},
    // 24 seconds
    { -760, 256, 48},
    { -952, 168, 56},
    { -968, -8, 120},
    { -1208, -24, 16},
    { -1408, 104, -144},
    { -1336, 136, -304},
    { -1112, 32, -216},
    { -1144, -40, -80},
    { -1256, 200, -152},
    { -848, -176, 120},
    { -848, 592, -296},
    { -856, 328, -88},
    { -824, 272, -8},
    { -840, 336, -64},
    { -816, 416, -88},
    { -840, 440, -112},
    { -992, 552, -136},
    { -1040, 624, -112},
    { -1448, 496, -176},
    { -1464, 312, -240},
    { -1136, 200, -376},
    { -1096, 248, -376},
    { -1216, 280, -360},
    { -1304, 296, -232},
    { -1248, 208, -88},
    // 25 seconds
    { -1152, 176, -40},
    { -1112, 80, 0},
    { -1104, 88, 24},
    { -960, 96, -8},
    { -912, 120, -8},
    { -1008, 88, 0},
    { -992, 96, 48},
    { -1016, -16, -72},
    { -1064, 112, -120},
    { -1072, 120, -344},
    { -1128, 120, -440},
    { -1184, 96, -456},
    { -1256, 40, -496},
    { -1248, 128, -504},
    { -1104, 192, -432},
    { -1032, 248, -392},
    { -560, -504, -280},
    { -1208, 744, -280},
    { -864, 336, -192},
    { -816, 392, -160},
    { -928, 512, -192},
    { -1016, 448, -128},
    { -1328, 456, -184},
    { -1352, 424, -152},
    { -1240, 384, -96},
    // 26 seconds
    { -1200, 336, -120},
    { -1312, 344, -104},
    { -1472, 368, -40},
    { -1416, 272, 56},
    { -1256, 152, 80},
    { -1144, 96, 88},
    { -1096, 104, 56},
    { -960, 96, 48},
    { -840, 96, 56},
    { -848, 96, 64},
    { -904, 96, 88},
    { -984, 80, 104},
    { -1048, 104, -64},
    { -1056, 232, -280},
    { -1144, 264, -456},
    { -1232, 24, -256},
    { -1496, -224, -216},
    { -1544, 152, -368},
    { -1376, 288, -296},
    { -1240, 208, -112},
    { -1128, 280, -48},
    { -1088, 272, 24},
    { -984, 344, 32},
    { -848, 392, 24},
    { -856, 376, 48},
    // 27 seconds
    { -952, 464, 64},
    { -960, 464, 136},
    { -968, 552, 64},
    { -1176, 352, -56},
    { -1312, 528, -160},
    { -1216, 408, -128},
    { -1560, 552, 0},
    { -1768, 536, -8},
    { -1656, 216, -32},
    { -1432, 8, 312},
    { -1464, 296, 200},
    { -1448, 440, 200},
    { -1280, 560, 248},
    { -960, 488, 256},
    { -736, 440, 192},
    { -560, 576, 112},
    { -448, 584, 128},
    { -232, 728, 56},
    { -56, 744, -24},
    { 128, 992, -48},
    { 144, 1080, -56},
    { 216, 1056, -272},
    { 224, 904, -184},
    { 248, 592, -112},
    { 312, 472, -168},
    // 28 seconds
    { 312, 376, -192},
    { 312, 256, -192},
    { 296, 168, -152},
    { 240, 80, -72},
    { -56, 16, -72},
    { -472, -48, -136},
    { -744, 48, -152},
    { -944, 224, -160},
    { -1984, 792, -104},
    { -2392, 992, 160},
    { -3024, 872, 184},
    { -2536, 848, 392},
    { -1720, 1512, 56},
    { -1112, 24, -152},
    { -1032, 544, 64},
    { -888, 432, 96},
    { -704, 360, -40},
    { -624, 344, -40},
    { -656, 400, 24},
    { -912, 488, 8},
    { -976, 384, -72},
    { -1336, 80, 200},
    { -1776, 240, 176},
    { -1704, 120, 184},
    { -1912, 256, 176},
    // 29 seconds
    { -1744, -8, 208},
    { -1352, -208, -184},
    { -1248, -360, -56},
    { -1104, -344, -80},
    { -1000, -328, -96},
    { -808, -312, -48},
    { -664, -104, -16},
    { -720, -16, 64},
    { -872, 112, 112},
    { -1144, 248, 136},
    { -1240, 280, 136},
    { -1312, 320, 128},
    { -1472, 392, 64},
    { -1392, 544, 80},
    { -1368, 344, -112},
    { -1176, 360, -72},
    { -912, 480, -40},
    { -976, 528, -80},
    { -1160, 480, -8},
    { -1384, 496, 8},
    { -1344, 320, -280},
    { -1008, -168, 320},
    { -992, -208, 304},
    { -1000, 240, 128},
    { -960, 256, 40},
    // 30 seconds
    { -880, 200, 24},
    { -1016, 160, 176},
    { -1160, 112, 160},
    { -1112, 96, 80},
    { -1344, -16, 216},
    { -1240, 168, -400},
    { -1008, 64, -312},
    { -1016, 24, -328},
    { -1200, 48, -240},
    { -1184, 48, -152},
    { -1064, 152, -88},
    { -960, 272, -16},
    { -944, 280, 40},
    { -968, 320, 80},
    { -952, 376, 0},
    { -816, 360, -56},
    { -928, 312, 40},
    { -1168, 472, 16},
    { -1368, 560, 32},
    { -1416, 520, -48},
    { -1288, 480, -56},
    { -1016, 424, -88},
    { -1024, 384, -56},
    { -1224, 344, -8},
    { -1304, 312, 56},
    // 31 seconds
    { -1248, 232, 128},
    { -1184, 160, 152},
    { -1096, 104, 168},
    { -984, 80, 136},
    { -864, 104, 112},
    { -880, 104, 120},
    { -1032, 112, 144},
    { -1008, 0, 104},
    { -1176, 24, 32},
    { -1160, 232, -232},
    { -1256, 392, -320},
    { -1208, 208, -224},
    { -1232, -8, -192},
    { -1320, 184, -208},
    { -1184, 288, -120},
    { -1024, 320, -40},
    { -976, 288, -8},
    { -992, 320, -16},
    { -960, 368, -32},
    { -800, 344, -56},
    { -904, 408, -96},
    { -1128, 496, -56},
    { -1328, 480, 24},
    { -1296, 424, -64},
    { -1232, 424, -88},
    // 32 seconds
    { -1104, 408, -136},
    { -1176, 384, -112},
    { -1368, 352, -72},
    { -1480, 320, -56},
    { -1344, 264, 80},
    { -1216, 144, 144},
    { -1128, 80, 120},
    { -1008, 96, 112},
    { -872, 120, 72},
    { -816, 136, 80},
    { -880, 120, 112},
    { -848, 80, 104},
    { -936, 104, 64},
    { -1112, 200, -64},
    { -1288, 464, -376},
    { -1304, 360, -416},
    { -1368, -256, -112},
    { -1544, -176, -32},
    { -1480, 360, -64},
    { -1272, 448, -24},
    { -1072, 416, 88},
    { -1008, 368, 88},
    { -1016, 344, 160},
    { -952, 328, 224},
    { -792, 280, 184},
    // 33 seconds
    { -840, 344, 144},
    { -960, 392, 112},
    { -1208, 512, 208},
    { -1320, 480, 88},
    { -1128, 608, -48},
    { -1160, 720, -184},
    { -1168, 480, -136},
    { -1440, 568, 0},
    { -1512, 296, -48},
    { -1440, 304, 168},
    { -1392, 264, 192},
    { -1352, 192, 192},
    { -1224, 136, 184},
    { -1032, 136, 176},
    { -840, 112, 144},
    { -800, 104, 128},
    { -792, 64, 136},
    { -744, 56, 128},
    { -912, 216, -80},
    { -1024, 328, -184},
    { -1184, 320, -96},
    { -1224, 264, -272},
    { -1504, -40, 40},
    { -1648, 112, 88},
    { -1456, 384, 24},
    // 34 seconds
    { -1176, 552, 64},
    { -1032, 728, -32},
    { -1008, 424, -72},
    { -952, 336, 48},
    { -872, 344, 0},
    { -912, 328, 16},
    { -984, 384, -48},
    { -1056, 488, -48},
    { -1280, 592, -72},
    { -1304, 584, -104},
    { -1160, 472, -112},
    { -1168, 408, -80},
    { -1392, 360, 0},
    { -1600, 336, 8},
    { -1568, 320, 40},
    { -1392, 200, 120},
    { -1248, 176, 104},
    { -1104, 152, 96},
    { -960, 128, 104},
    { -824, 120, 96},
    { -856, 120, 88},
    { -824, 0, 112},
    { -808, -72, 80},
    { -912, 72, 8},
    { -1168, 272, -184},
    // 35 seconds
    { -1360, 408, -224},
    { -1416, 312, -288},
    { -1592, 16, -112},
    { -1568, 168, -168},
    { -1280, 320, -120},
    { -1152, 392, -40},
    { -1128, 416, -56},
    { -1048, 368, -8},
    { -944, 384, -32},
    { -824, 384, -40},
    { -888, 440, -8},
    { -968, 520, 48},
    { -1120, 456, 48},
    { -1208, 488, 8},
    { -1312, 448, 48},
    { -1080, 384, -40},
    { -1144, 368, 8},
    { -1304, 360, 80},
    { -1488, 384, 104},
    { -1424, 336, 128},
    { -1344, 216, 200},
    { -1280, 72, 216},
    { -1096, 8, 160},
    { -952, 88, 112},
    { -912, 120, 88},
    // 36 seconds
    { -1008, 96, 136},
    { -920, 48, 120},
    { -968, 16, 192},
    { -1112, 120, 8},
    { -1232, 296, -88},
    { -1144, 424, -152},
    { -1152, 288, -272},
    { -1336, 336, -408},
    { -1352, 288, -88},
    { -1120, 384, 0},
    { -1024, 408, -64},
    { -1072, 384, -48},
    { -1080, 384, -16},
    { -848, 320, 24},
    { -808, 312, 80},
    { -1048, 392, 232},
    { -1112, 616, 328},
    { -1304, 424, 160},
    { -1160, 496, 72},
    { -1008, 512, -32},
    { -976, 520, -16},
    { -1224, 488, 88},
    { -1424, 384, 96},
    { -1408, 280, 104},
    { -1288, 160, 208},
    // 37 seconds
    { -1216, 112, 184},
    { -1112, 112, 136},
    { -976, 120, 96},
    { -840, 128, 72},
    { -880, 104, 88},
    { -904, 32, 88},
    { -992, -8, -48},
    { -1144, 160, -72},
    { -1288, 328, -184},
    { -1368, 296, -152},
    { -1464, 544, -208},
    { -1344, 496, -112},
    { -1168, 456, 120},
    { -960, 312, -72},
    { -984, 344, 0},
    { -1032, 296, 136},
    { -992, 240, 152},
    { -832, 216, 128},
    { -720, 256, 120},
    { -968, 328, 112},
    { -1120, 456, 240},
    { -1400, 736, 312},
    { -1064, 264, -104},
    { -880, 480, -224},
    { -1008, 600, -88},
    // 38 seconds
    { -1288, 608, 56},
    { -1480, 408, 48},
    { -1440, 280, 80},
    { -1296, 176, 64},
    { -1264, 192, 80},
    { -1168, 168, 48},
    { -1040, 152, 32},
    { -856, 144, 32},
    { -976, 168, 120},
    { -936, 112, 160},
    { -992, 456, 256},
    { -888, 1120, 232},
    { -488, 1680, 72},
    { -440, 1552, 200},
    { -480, 1376, 336},
    { -328, 1048, -64},
    { -328, 608, 16},
    { -224, 312, -40},
    { -144, 104, -16},
    { -128, 64, 48},
    { -168, -8, 96},
    { -264, 8, 128},
    { -416, 40, 176},
    { -640, 64, 208},
    { -1304, 136, 272},
    // 39 seconds
    { -2560, 880, 576},
    { -2712, 1024, -16},
    { -1880, 1024, 632},
    { -1360, 1008, 40},
    { -1352, 1136, 64},
    { -912, 816, 176},
    { -776, 472, 320},
    { -792, 656, 200},
    { -776, 512, 16},
    { -904, 424, 112},
    { -1032, 224, 184},
    { -1064, 184, 200},
    { -1000, 168, 176},
    { -1064, 136, 200},
    { -1280, 136, 200},
    { -1224, 136, 176},
    { -1392, 184, 112},
    { -1344, 88, -80},
    { -1320, 240, -336},
    { -888, 16, -376},
    { -904, -48, -224},
    { -1064, 24, -64},
    { -1080, 40, 0},
    { -904, 128, 24},
    { -800, 224, 56},
    // 40 seconds
    { -784, 208, 128},
    { -912, 288, 104},
    { -928, 304, 128},
    { -872, 336, 104},
    { -1016, 392, 104},
    { -1200, 464, 216},
    { -1384, 456, 208},
    { -1552, 288, 112},
    { -1232, 384, 32},
    { -936, 504, 0},
    { -960, 488, -128},
    { -1232, 416, -32},
    { -1272, 160, 144},
    { -1216, 120, 184},
    { -1064, 40, 168},
    { -992, 48, 168},
    { -936, 72, 144},
    { -864, 128, 144},
    { -816, 112, 120},
    { -1000, 64, 160},
    { -1024, 8, 160},
    { -1136, 40, 56},
    { -1280, 232, -104},
    { -1352, 256, -184},
    { -1232, 328, -352},
    // 41 seconds
    { -1136, 64, -192},
    { -1208, 144, -216},
    { -1160, 240, -192},
    { -992, 200, -64},
    { -888, 232, -72},
    { -872, 248, -32},
    { -864, 264, -24},
    { -824, 344, -40},
    { -640, 400, -152},
    { -784, 440, -128},
    { -1208, 448, -136},
    { -1704, 328, 16},
    { -1368, 456, -88},
    { -1008, 248, -64},
    { -1056, 312, -80},
    { -1224, 360, -32},
    { -1352, 312, 40},
    { -1344, 224, 136},
    { -1232, 160, 128},
    { -1096, 72, 168},
    { -1000, 64, 160},
    { -896, 96, 152},
    { -792, 112, 96},
    { -760, 128, 80},
    { -848, 120, 104},
    // 42 seconds
    { -840, 112, 40},
    { -984, -24, -40},
    { -1312, 200, -128},
    { -1472, 336, -296},
    { -1376, 400, -464},
    { -1304, 152, -368},
    { -1240, 328, -432},
    { -1208, 288, -232},
    { -1024, 344, -176},
    { -880, 208, -128},
    { -816, 192, 8},
    { -784, 192, 48},
    { -808, 232, 104},
    { -712, 224, 48},
    { -968, 304, 16},
    { -1232, 360, 120},
    { -1416, 680, 168},
    { -1360, 400, 24},
    { -1088, 488, -96},
    { -1064, 520, -176},
    { -1200, 328, -104},
    { -1424, 352, -112},
    { -1360, 328, 0},
    { -1192, 208, 80},
    { -1112, 184, 88},
    // 43 seconds
    { -1064, 176, 104},
    { -936, 208, 0},
    { -848, 224, 96},
    { -872, 168, 72},
    { -856, 72, 24},
    { -728, -32, 24},
    { -912, 136, -56},
    { -1128, 248, -160},
    { -1520, 408, -192},
    { -1600, 496, -216},
    { -1512, 200, -8},
    { -1224, 312, 40},
    { -1056, 120, 24},
    { -1008, 264, 112},
    { -968, 256, 128},
    { -880, 288, 88},
    { -816, 296, 112},
    { -752, 296, 72},
    { -768, 280, 104},
    { -1032, 352, 96},
    { -1168, 504, 272},
    { -1352, 624, 160},
    { -1136, 520, -136},
    { -1008, 568, -88},
    { -1112, 552, 32},
    // 44 seconds
    { -1304, 336, 88},
    { -1616, 512, 80},
    { -1296, 80, 152},
    { -1200, 144, 136},
    { -1144, 72, 128},
    { -1080, 144, 80},
    { -952, 152, 48},
    { -856, 104, 72},
    { -888, 48, 88},
    { -896, 8, 120},
    { -888, 176, 72},
    { -1040, 168, -128},
    { -1296, 512, -288},
    { -1304, 344, -480},
    { -1360, 96, -264},
    { -1472, 104, -72},
    { -1408, 352, 80},
    { -1168, 432, 24},
    { -1112, 496, -16},
    { -1072, 304, 72},
    { -992, 304, 128},
    { -864, 120, 128},
    { -792, 256, 144},
    { -744, 288, 96},
    { -904, 432, 48},
    // 45 seconds
    { -1064, 576, 112},
    { -1064, 392, 8},
    { -1192, 616, -120},
    { -1064, 584, -224},
    { -1128, 512, -184},
    { -1360, 648, -112},
    { -1648, 648, -88},
    { -1616, 120, 360},
    { -1432, 232, 208},
    { -1328, 48, 136},
    { -1224, 128, 80},
    { -1056, 160, 32},
    { -880, 168, -24},
    { -752, 112, 32},
    { -784, 16, 64},
    { -680, -64, 80},
    { -768, 40, -8},
    { -976, 200, -152},
    { -1400, 416, -272},
    { -1648, 840, -376},
    { -1536, -152, -64},
    { -1568, 184, -208},
    { -1304, 408, -64},
    { -1184, 288, -112},
    { -1152, 264, 72},
    // 46 seconds
    { -992, 128, 96},
    { -872, 176, 32},
    { -816, 176, 48},
    { -680, 160, 24},
    { -736, 320, -64},
    { -1032, 352, 40},
    { -1256, 832, 120},
    { -1416, 608, 24},
    { -1072, 504, -128},
    { -992, 496, -232},
    { -1152, 496, -192},
    { -1352, 368, -120},
    { -1512, 248, -16},
    { -1400, 104, 24},
    { -1352, 144, -48},
    { -1312, 136, -16},
    { -1128, 48, 0},
    { -880, 112, -56},
    { -704, 72, -96},
    { -552, -16, -64},
    { -552, 0, -80},
    { -568, 104, -176},
    { -864, 136, -240},
    { -1392, 280, -408},
    { -1992, 608, -312},
    // 47 seconds
    { -1784, 344, -48},
    { -1424, 48, 312},
    { -1128, 472, -8},
    { -1088, -8, 136},
    { -1144, 304, 224},
    { -1024, 288, 208},
    { -768, 136, 200},
    { -656, 128, 240},
    { -608, 200, 136},
    { -592, 320, 16},
    { -736, 400, 8},
    { -1000, 440, 56},
    { -1152, 280, 192},
    { -1488, 688, -64},
    { -1496, 368, -248},
    { -1112, 352, -376},
    { -1128, 440, -448},
    { -1464, 384, -328},
    { -1496, 72, -64},
    { -1264, 96, -56},
    { -1200, 104, 16},
    { -1072, 168, 72},
    { -912, 168, -56},
    { -800, 160, -96},
    { -736, 88, -64},
    // 48 seconds
    { -664, -8, -16},
    { -664, 88, -48},
    { -872, 64, 8},
    { -1256, 256, -56},
    { -1464, 504, -288},
    { -1576, 584, -408},
    { -1432, -144, 96},
    { -1288, 152, -56},
    { -1176, 368, -64},
    { -1080, 392, -88},
    { -936, 192, 24},
    { -808, 128, 88},
    { -728, 128, 144},
    { -672, 208, 112},
    { -672, 272, 64},
    { -960, 304, 64},
    { -1352, 472, 216},
    { -1496, 1168, 448},
    { -1248, -88, 64},
    { -976, 520, -240},
    { -1040, 608, -192},
    { -1296, 272, -136},
    { -1328, 96, -120},
    { -1160, 288, -120},
    { -1072, 288, -104},
    // 49 seconds
    { -1088, 224, -56},
    { -1032, 128, 32},
    { -912, 136, 0},
    { -808, 136, -24},
    { -840, 72, 32},
    { -880, 56, 24},
    { -920, 96, 0},
    { -1232, 168, 24},
    { -1400, 464, -264},
    { -1512, 520, -392},
    { -1368, 24, -8},
    { -1160, -24, 152},
    { -1064, 240, 128},
    { -984, 352, 104},
    { -912, 280, 136},
    { -816, 208, 176},
    { -696, 160, 200},
    { -608, 200, 152},
    { -584, 272, 72},
    { -832, 352, 40},
    { -1208, 424, 112},
    { -1512, 376, 304},
    { -1424, 848, 24},
    { -1152, 344, -160},
    { -928, 408, -328},
    // 50 seconds
    { -1016, 384, -312},
    { -1368, 328, -384},
    { -1384, 344, -288},
    { -1136, 272, -88},
    { -1000, 200, -96},
    { -952, 176, -48},
    { -904, 176, -8},
    { -816, 208, -72},
    { -808, 112, 8},
    { -920, 88, 48},
    { -856, 120, 0},
    { -984, 168, -24},
    { -1240, 320, -184},
    { -1408, 376, -304},
    { -1280, 368, -408},
    { -1112, 120, -264},
    { -1120, 136, -104},
    { -1184, 136, 0},
    { -1144, 336, 0},
    { -976, 240, 80},
    { -824, 256, 80},
    { -816, 240, 112},
    { -816, 232, 104},
    { -760, 248, 96},
    { -848, 304, 64},
    // 51 seconds
    { -1080, 360, 40},
    { -1200, 464, 96},
    { -1432, 408, -88},
    { -1224, 848, -96},
    { -1056, 648, -200},
    { -1072, 776, -104},
    { -1376, 872, 88},
    { -1512, 720, 208},
    { -1352, 688, 328},
    { -1192, 464, 344},
    { -1016, 456, 360},
    { -800, 320, 368},
    { -608, 328, 304},
    { -440, 320, 312},
    { -288, 368, 352},
    { -208, 560, 400},
    { -56, 728, 384},
    { 8, 776, 528},
    { 88, 1064, 552},
    { 192, 1200, 464},
    { 112, 1152, 376},
    { 32, 896, 288},
    { 16, 696, 240},
    { 32, 560, 176},
    { 56, 416, 120},
    // 52 seconds
    { 48, 288, 112},
    { 24, 128, 32},
    { -80, 56, 256},
    { -240, 184, 280},
    { -408, 680, 392},
    { -576, 536, 480},
    { -904, 488, 432},
    { -1784, 432, 1232},
    { -2008, 1856, 880},
    { -1320, 176, 1144},
    { -744, 976, 480},
    { -872, 560, 600},
    { -1032, 392, 832},
    { -880, 304, 744},
    { -680, 352, 456},
    { -648, 304, 368},
    { -760, 272, 408},
    { -832, 216, 368},
    { -856, 192, 352},
    { -840, 184, 312},
    { -984, 128, 336},
    { -1088, 112, 328},
    { -1216, 160, 208},
    { -1280, 280, 152},
    { -1104, 504, -72},
    // 53 seconds
    { -1064, 448, -224},
    { -1096, 48, -160},
    { -1136, 128, -208},
    { -984, 272, -232},
    { -800, 288, -128},
    { -720, 256, -16},
    { -704, 224, 80},
    { -752, 280, 104},
    { -744, 272, 112},
    { -1000, 328, 152},
    { -1280, 432, 216},
    { -1128, 408, 512},
    { -1240, 560, 144},
    { -1208, 488, 136},
    { -1048, 480, 136},
    { -1032, 560, 40},
    { -1208, 528, 64},
    { -1112, 576, 104},
    { -912, 392, 192},
    { -880, 248, 152},
    { -952, 248, 144},
    { -1000, 224, 168},
    { -976, 208, 160},
    { -968, 176, 184},
    { -1184, 128, 224},
    // 54 seconds
    { -1136, 40, 168},
    { -1232, 48, 144},
    { -1136, 264, -176},
    { -1000, 352, -240},
    { -1136, 280, -168},
    { -1256, 32, 40},
    { -1280, 72, 96},
    { -1104, 296, 144},
    { -992, 384, 240},
    { -912, 328, 248},
    { -936, 296, 272},
    { -912, 320, 232},
    { -848, 384, 200},
    { -896, 448, 208},
    { -1048, 536, 224},
    { -1040, 624, 296},
    { -1248, 608, 240},
    { -1184, 480, 120},
    { -1080, 480, 16},
    { -1208, 488, 40},
    { -1472, 480, 96},
    { -1440, 456, 152},
    { -1296, 200, 248},
    { -1272, 208, 272},
    { -1256, 136, 224},
    // 55 seconds
    { -1104, 160, 240},
    { -920, 208, 160},
    { -880, 168, 192},
    { -984, 48, 200},
    { -864, -80, 208},
    { -976, -40, 144},
    { -1000, 264, -88},
    { -1120, 288, -80},
    { -1296, 432, -64},
    { -1528, 56, 264},
    { -1768, 16, 176},
    { -1624, 256, 120},
    { -1416, 376, 120},
    { -1272, 416, 112},
    { -1224, 336, 128},
    { -1112, 448, 40},
    { -896, 688, -88},
    { -832, 864, -80},
    { -936, 688, 32},
    { -1296, 360, 16},
    { -1440, 424, -88},
    { -1368, 520, -200},
    { -1752, 344, -80},
    { -2176, 240, 8},
    { -2448, 376, 48},
    // 56 seconds
    { -2384, 424, 248},
    { -2136, 320, 312},
    { -1568, 184, 192},
    { -1024, 88, 216},
    { -624, 0, 136},
    { -432, -56, 32},
    { -320, -176, 64},
    { -288, -168, -72},
    { -304, -248, -24},
    { -472, -176, -64},
    { -672, 8, -136},
    { -1080, -16, -120},
    { -1600, 0, 80},
    { -2224, -32, 304},
    { -2632, 256, 512},
    { -2416, 432, 544},
    { -1872, 1024, 88},
    { -1640, 24, 344},
    { -1592, 280, 224},
    { -1320, 496, 120},
    { -1096, 496, 80},
    { -1024, 736, 208},
    { -800, 640, 136},
    { -992, 744, 296},
    { -1128, 760, 248},
    // 57 seconds
    { -1040, 696, 88},
    { -1160, 560, 104},
    { -1544, 544, 112},
    { -2072, 688, 264},
    { -2192, 384, 432},
    { -2016, 120, 440},
    { -1760, 72, 352},
    { -1472, 64, 280},
    { -1200, 80, 232},
    { -952, 128, 184},
    { -968, 104, 184},
    { -992, -264, 264},
    { -816, -304, 280},
    { -968, 48, 136},
    { -848, 296, -272},
    { -920, 432, -248},
    { -1168, 128, -104},
    { -1624, 88, -24},
    { -2128, 200, 312},
    { -2112, 680, 400},
    { -1424, 1624, 328},
    { -1216, 8, 40},
    { -1520, 472, 152},
    { -1296, 360, 336},
    { -968, 432, 200},
    // 58 seconds
    { -976, 448, 240},
    { -912, 848, 520},
    { -1024, 384, 368},
    { -960, 376, 200},
    { -992, 456, 144},
    { -1192, 512, 240},
    { -1512, 560, 280},
    { -1752, 616, 304},
    { -1744, 344, 328},
    { -1696, 296, 384},
    { -1648, 288, 336},
    { -1536, 272, 304},
    { -1328, 232, 296},
    { -1152, 144, 296},
    { -1080, 56, 224},
    { -736, -184, 136},
    { -840, 48, -40},
    { -848, 64, -24},
    { -944, 136, 56},
    { -1000, 344, -184},
    { -1240, 288, -72},
    { -1608, 192, 136},
    { -1824, 328, 240},
    { -1752, 496, 200},
    { -1408, 1120, 192},
    // 59 seconds
    { -1216, 368, -32},
    { -1328, 800, -144},
    { -984, 792, 16},
    { -696, 584, 8},
    { -880, 496, 32},
    { -856, 456, 136},
    { -1168, 672, 120},
    { -1160, 552, 224},
    { -1080, 616, 176},
    { -1376, 656, 152},
    { -1656, 568, 392},
    { -1584, 680, 360},
    { -1320, 656, 336},
    { -1104, 576, 296},
    { -832, 528, 248},
    { -616, 416, 288},
    { -464, 392, 248},
    { -256, 440, 224},
    { -240, 720, 192},
    { -80, 680, 320},
    { 48, 848, 280},
    { 120, 984, 304},
    { 176, 1080, 376},
    { 240, 1192, 224},
    { 216, 1008, 232},
    // 60 seconds
    // elapsed: 1 minutes
    { 184, 800, 128},
    { 224, 632, 120},
    { 256, 456, 176},
    { 264, 424, 88},
    { 256, 304, 56},
    { 264, 152, 80},
    { 168, 144, 24},
    { 32, 248, 88},
    { -184, 608, 456},
    { -552, 1456, 672},
    { -520, 1440, 752},
    { -544, 1712, 744},
    { -232, 1208, 536},
    { -144, 1144, 368},
    { -160, 1008, 488},
    { -208, 992, 560},
    { -280, 1048, 520},
    { -288, 864, 504},
    { -248, 696, 352},
    { -232, 600, 320},
    { -208, 512, 312},
    { -168, 472, 280},
    { -176, 432, 240},
    { -192, 488, 328},
    { -264, 608, 400},
    // 61 seconds
    { -408, 912, 720},
    { -600, 1312, 696},
    { -576, 1048, 856},
    { -360, 1168, 56},
    { -432, 920, 216},
    { -408, 768, 344},
    { -376, 656, 424},
    { -352, 688, 400},
    { -288, 552, 392},
    { -264, 544, 536},
    { -224, 608, 584},
    { -168, 608, 504},
    { -136, 696, 520},
    { -128, 824, 520},
    { -128, 848, 560},
    { -456, 1008, 1040},
    { -264, 1416, 1032},
    { -488, 752, 896},
    { -360, 688, 840},
    { -344, 648, 848},
    { -360, 760, 808},
    { -344, 664, 784},
    { -328, 544, 680},
    { -240, 400, 504},
    { -200, 360, 472},
    // 62 seconds
    { -120, 336, 440},
    { -48, 384, 400},
    { -16, 424, 472},
    { 0, 488, 720},
    { 40, 712, 848},
    { -8, 928, 1104},
    { 40, 784, 1216},
    { 32, 1000, 944},
    { -24, 808, 840},
    { -32, 536, 968},
    { -32, 624, 896},
    { 8, 528, 816},
    { 104, 400, 648},
    { 160, 304, 536},
    { 240, 296, 504},
    { 256, 256, 512},
    { 256, 304, 552},
    { 240, 352, 512},
    { 168, 440, 616},
    { 240, 504, 560},
    { 224, 240, 1040},
    { 184, 920, 1152},
    { 168, 936, 1224},
    { 104, 776, 1184},
    { 224, 424, 880},
    // 63 seconds
    { 168, 448, 552},
    { 208, 496, 464},
    { 256, 520, 616},
    { 208, 768, 608},
    { 120, 808, 576},
    { 96, 720, 536},
    { 96, 696, 432},
    { 72, 672, 520},
    { 88, 776, 528},
    { 104, 824, 512},
    { 160, 728, 560},
    { 160, 856, 432},
    { 224, 880, 368},
    { 192, 872, 216},
    { 256, 632, 232},
    { 168, 728, 184},
    { 112, 1072, 176},
    { 120, 872, 224},
    { 56, 952, 184},
    { 88, 896, 176},
    { 80, 832, 128},
    { 72, 960, 184},
    { 80, 968, 184},
    { 40, 960, 88},
    { 128, 880, 176},
    // 64 seconds
    { 120, 848, 184},
    { 112, 832, 144},
    { 56, 864, 152},
    { 80, 864, 144},
    { 96, 912, 200},
    { 112, 1016, 232},
    { 168, 944, 184},
    { 128, 1112, 64},
    { 168, 920, 88},
    { 216, 928, -56},
    { 280, 816, -128},
    { 104, 992, -216},
    { 168, 744, -336},
    { 72, 808, -376},
    { 16, 696, -408},
    { 0, 568, -512},
    { -64, 520, -568},
    { -120, 488, -680},
    { -152, 520, -728},
    { 152, 320, -880},
    { -168, 800, -816},
    { 88, 376, -808},
    { 24, 512, -792},
    { 152, 288, -904},
    { 24, 240, -912},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:36:25 local
AccelRawData *activity_sample_walk_100_pbl_25478_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25478_4
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 65
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 56, -320, -944},
    { 72, -320, -976},
    { 72, -320, -968},
    { 56, -320, -960},
    { 56, -328, -968},
    { 56, -328, -968},
    { 56, -328, -960},
    { 40, -344, -944},
    { 72, -328, -960},
    { 56, -328, -952},
    { 56, -328, -912},
    { 64, -320, -960},
    { 88, -80, -944},
    { 64, -352, -968},
    { 32, -352, -976},
    { 8, -304, -992},
    { -8, -376, -1000},
    { 64, -264, -976},
    { -8, -328, -968},
    { 64, -352, -960},
    { 48, -304, -944},
    { 40, -280, -976},
    { 24, -312, -952},
    { 48, -328, -952},
    { 32, -296, -960},
    // 1 seconds
    { 24, -312, -944},
    { 16, -320, -968},
    { 16, -328, -960},
    { 16, -320, -968},
    { 16, -320, -960},
    { 8, -232, -896},
    { 176, -416, -1104},
    { 0, -280, -992},
    { -16, -288, -960},
    { 24, -256, -984},
    { 8, -288, -944},
    { 48, -232, -992},
    { 48, -248, -952},
    { 64, -160, -984},
    { 72, -176, -984},
    { 72, -184, -984},
    { 88, -160, -1008},
    { 88, -208, -1008},
    { 96, -80, -1032},
    { 112, 16, -1008},
    { 152, 64, -888},
    { 200, 240, -840},
    { 280, 400, -672},
    { 256, 544, -720},
    { 272, 576, -664},
    // 2 seconds
    { 264, 568, -600},
    { 264, 680, -624},
    { 264, 576, -584},
    { 336, 592, -480},
    { 352, 648, -520},
    { 368, 552, -496},
    { 320, 504, -352},
    { 304, 696, -376},
    { 232, 720, -328},
    { 232, 704, -320},
    { 208, 720, -344},
    { 232, 736, -296},
    { 264, 736, -272},
    { 280, 848, -168},
    { 344, 808, -136},
    { 232, 880, -120},
    { 208, 1224, -176},
    { 160, 1416, -128},
    { -32, 1608, -256},
    { -104, 1256, -136},
    { 48, 928, -24},
    { 200, 864, -104},
    { 104, 760, 0},
    { 144, 728, 96},
    { 24, 728, -40},
    // 3 seconds
    { 80, 784, 32},
    { 128, 768, -88},
    { 184, 744, -112},
    { 200, 664, -136},
    { 248, 712, -120},
    { 304, 632, -80},
    { 296, 856, -128},
    { 272, 1120, -184},
    { 152, 1200, -200},
    { 112, 1216, -328},
    { 120, 1336, -304},
    { -32, 1048, -128},
    { -8, 864, -216},
    { 24, 776, -112},
    { 40, 672, 0},
    { 96, 744, -48},
    { 96, 824, -88},
    { 120, 688, -56},
    { 120, 632, -176},
    { 200, 664, -176},
    { 232, 664, -272},
    { 240, 712, -344},
    { 272, 792, -184},
    { 248, 1024, -152},
    { 192, 1176, -56},
    // 4 seconds
    { 176, 1456, -48},
    { 48, 1168, -56},
    { 48, 1008, -112},
    { 176, 864, 16},
    { 104, 928, 0},
    { 64, 1072, 48},
    { -16, 888, -64},
    { -24, 648, -136},
    { 40, 560, -96},
    { 72, 560, -136},
    { 80, 520, -160},
    { 144, 600, -144},
    { 184, 848, -144},
    { 112, 1096, -160},
    { 200, 1368, -112},
    { 256, 1496, -176},
    { 128, 1480, -304},
    { -16, 1000, -72},
    { -24, 632, -136},
    { -56, 592, -128},
    { -40, 488, -48},
    { -64, 664, -32},
    { -48, 584, -40},
    { 32, 680, 208},
    { 64, 528, 72},
    // 5 seconds
    { 64, 568, 216},
    { 64, 840, 512},
    { 240, 1408, 648},
    { 256, 1424, 752},
    { 152, 1808, 872},
    { 80, 1456, 664},
    { -64, 1040, 440},
    { 8, 784, 312},
    { -32, 552, 328},
    { 144, 696, 112},
    { 112, 632, 168},
    { 56, 864, 80},
    { 96, 544, 16},
    { 192, 512, -72},
    { 208, 456, -32},
    { 272, 488, 112},
    { 400, 664, 32},
    { 424, 712, 192},
    { 624, 1040, 176},
    { 360, 1144, 328},
    { 248, 1216, 376},
    { 248, 1048, 216},
    { -8, 848, 400},
    { 56, 856, 424},
    { 48, 840, 576},
    // 6 seconds
    { 0, 896, 632},
    { 128, 672, 440},
    { 280, 768, 440},
    { 256, 464, 304},
    { 320, 608, 296},
    { 328, 576, 232},
    { 352, 600, 216},
    { 328, 808, 272},
    { 304, 848, 424},
    { 280, 1136, 488},
    { 248, 1120, 584},
    { 160, 1104, 568},
    { 136, 904, 448},
    { 192, 608, 376},
    { 224, 656, 384},
    { 224, 760, 576},
    { 112, 888, 536},
    { 40, 848, 504},
    { 128, 656, 328},
    { 136, 560, 328},
    { 216, 616, 288},
    { 192, 664, 328},
    { 248, 720, 368},
    { 264, 792, 408},
    { 216, 1000, 240},
    // 7 seconds
    { 240, 944, 272},
    { 184, 1096, 248},
    { 80, 1440, 184},
    { 72, 1024, 160},
    { -56, 992, -48},
    { -40, 872, -24},
    { -8, 688, 152},
    { -8, 888, 8},
    { 48, 656, -40},
    { 88, 584, -32},
    { 88, 640, -104},
    { 144, 728, -112},
    { 96, 688, -56},
    { 168, 824, -112},
    { 128, 936, 112},
    { 88, 1128, 200},
    { 80, 1336, 496},
    { -232, 1416, 568},
    { -144, 1144, 448},
    { -40, 936, 16},
    { 40, 656, 312},
    { 8, 1008, 144},
    { -72, 1016, 360},
    { -80, 1000, 208},
    { -48, 848, 224},
    // 8 seconds
    { -16, 760, 88},
    { 8, 736, 112},
    { 72, 688, 88},
    { 96, 848, 72},
    { 104, 760, 64},
    { 128, 936, 96},
    { 224, 912, -8},
    { 248, 952, 24},
    { 248, 984, -16},
    { 272, 848, -80},
    { 240, 824, -72},
    { 216, 872, -16},
    { 248, 648, 24},
    { 224, 840, 72},
    { 192, 944, 64},
    { 224, 784, 48},
    { 232, 856, -8},
    { 264, 800, 40},
    { 376, 808, 24},
    { 312, 848, 16},
    { 320, 832, 32},
    { 312, 848, 40},
    { 304, 888, 152},
    { 328, 872, 224},
    { 336, 792, 128},
    // 9 seconds
    { 320, 816, 160},
    { 336, 768, 176},
    { 336, 744, 216},
    { 320, 808, 224},
    { 328, 736, 320},
    { 320, 824, 192},
    { 304, 1016, 400},
    { 336, 712, 272},
    { 336, 880, 144},
    { 328, 800, 224},
    { 360, 832, 128},
    { 376, 784, 208},
    { 352, 680, 216},
    { 352, 856, 224},
    { 320, 816, 304},
    { 336, 848, 296},
    { 384, 760, 248},
    { 368, 840, 192},
    { 360, 776, 208},
    { 336, 808, 216},
    { 328, 848, 232},
    { 344, 864, 232},
    { 344, 784, 256},
    { 344, 800, 216},
    { 344, 816, 192},
    // 10 seconds
    { 376, 824, 216},
    { 352, 800, 208},
    { 336, 832, 216},
    { 352, 872, 224},
    { 400, 752, 224},
    { 376, 776, 224},
    { 352, 768, 184},
    { 368, 816, 200},
    { 376, 800, 224},
    { 352, 776, 216},
    { 368, 800, 216},
    { 376, 808, 280},
    { 376, 736, 152},
    { 384, 784, 232},
    { 360, 800, 208},
    { 336, 808, 224},
    { 368, 824, 240},
    { 344, 808, 248},
    { 336, 840, 216},
    { 328, 800, 232},
    { 352, 800, 200},
    { 328, 824, 248},
    { 304, 768, 288},
    { 320, 848, 304},
    { 312, 824, 312},
    // 11 seconds
    { 328, 784, 328},
    { 320, 792, 280},
    { 320, 808, 272},
    { 328, 808, 288},
    { 320, 792, 272},
    { 296, 784, 248},
    { 312, 800, 232},
    { 280, 848, 264},
    { 288, 864, 304},
    { 288, 816, 256},
    { 312, 864, 296},
    { 320, 784, 112},
    { 264, 880, 208},
    { 296, 736, 104},
    { 336, 736, 152},
    { 320, 848, 280},
    { 344, 808, 184},
    { 320, 784, 208},
    { 376, 792, 240},
    { 296, 712, 224},
    { 312, 624, 128},
    { 256, 512, 80},
    { 128, 456, -40},
    { -24, 368, -16},
    { -160, 320, -40},
    // 12 seconds
    { -488, 144, -168},
    { -1576, 264, -248},
    { -2208, 568, -288},
    { -2176, 376, -384},
    { -1848, 240, -280},
    { -1112, 472, 840},
    { -1176, 456, -160},
    { -1184, 320, -96},
    { -1064, 360, -56},
    { -992, 368, -72},
    { -880, 400, -176},
    { -864, 344, -144},
    { -880, 344, -192},
    { -856, 216, -208},
    { -856, 232, -248},
    { -1000, 280, -104},
    { -992, 280, -432},
    { -1304, 320, -408},
    { -1520, 216, -336},
    { -1544, 128, -400},
    { -1400, -64, -272},
    { -1136, 256, -184},
    { -1128, 184, -88},
    { -1160, 176, 40},
    { -1272, 376, 96},
    // 13 seconds
    { -1104, 408, 184},
    { -944, 248, 224},
    { -712, 168, 104},
    { -648, 208, 168},
    { -640, 48, 88},
    { -560, 256, 176},
    { -744, 248, 184},
    { -968, 120, 96},
    { -1248, 160, 224},
    { -1424, 128, -120},
    { -1864, 328, -64},
    { -1672, 480, -160},
    { -976, 408, -32},
    { -872, 944, 8},
    { -1104, 576, 152},
    { -1048, 448, 280},
    { -760, 400, 216},
    { -664, 376, 160},
    { -640, 216, 120},
    { -688, 312, 200},
    { -632, 248, 248},
    { -664, 344, 224},
    { -1104, 400, 224},
    { -1408, 552, 416},
    { -1488, 624, 248},
    // 14 seconds
    { -1120, 720, -16},
    { -952, 792, -56},
    { -1088, 624, -24},
    { -1376, 616, 8},
    { -1608, 520, -632},
    { -976, -472, 608},
    { -1032, 224, -152},
    { -840, 88, 192},
    { -856, 208, 120},
    { -776, 216, 96},
    { -800, -48, 72},
    { -960, -32, 128},
    { -1208, 136, 80},
    { -1304, 160, -40},
    { -1272, 336, -248},
    { -1360, 568, -96},
    { -1344, 168, -40},
    { -1248, 456, -184},
    { -992, 320, -176},
    { -896, 296, -16},
    { -808, 320, -16},
    { -800, 352, 24},
    { -816, 344, 16},
    { -760, 304, 0},
    { -960, 320, -8},
    // 15 seconds
    { -1312, 496, -32},
    { -1352, 688, -32},
    { -1408, 584, -248},
    { -1072, 440, -272},
    { -960, 344, -360},
    { -1224, 424, -232},
    { -1472, 456, -96},
    { -1464, 432, 0},
    { -1208, 56, 88},
    { -1248, 224, 64},
    { -1168, 80, 112},
    { -1080, 200, 40},
    { -920, 160, 16},
    { -944, 152, 104},
    { -672, -208, 184},
    { -840, 56, -8},
    { -1056, 0, -104},
    { -1256, 64, -168},
    { -1320, -72, -344},
    { -1528, -200, -272},
    { -1560, -32, -80},
    { -1360, -32, 64},
    { -1176, 224, -136},
    { -1056, 248, -40},
    { -992, 264, 0},
    // 16 seconds
    { -1000, 160, 24},
    { -912, 336, -104},
    { -872, 376, -256},
    { -1224, 352, -32},
    { -1696, 512, 168},
    { -1280, 744, -24},
    { -1016, 320, -104},
    { -1072, 344, 16},
    { -1168, 392, 112},
    { -1312, 280, 96},
    { -1272, 336, 136},
    { -1200, 152, 296},
    { -1088, 136, 240},
    { -1056, 72, 296},
    { -1024, 216, 192},
    { -1048, 264, 232},
    { -1280, 336, 248},
    { -1272, 112, 80},
    { -1288, -24, 168},
    { -1152, -104, -64},
    { -1152, 192, -216},
    { -1320, -48, 88},
    { -1456, 112, 200},
    { -1376, 360, 224},
    { -1192, 432, 232},
    // 17 seconds
    { -1040, 408, 280},
    { -1032, 424, 344},
    { -1056, 504, 296},
    { -960, 568, 232},
    { -856, 544, 248},
    { -992, 696, 320},
    { -840, 792, 360},
    { -1176, 800, 400},
    { -1016, 752, 224},
    { -1056, 776, 88},
    { -1264, 688, 88},
    { -1512, 640, 200},
    { -1672, 472, -56},
    { -1616, 616, 216},
    { -1424, 288, 192},
    { -1384, 312, 272},
    { -1240, 240, 248},
    { -1048, 200, 232},
    { -856, 208, 192},
    { -952, 440, -24},
    { -728, -336, 568},
    { -360, -816, -152},
    { -1144, 0, -64},
    { -1480, 152, -312},
    { -1640, 88, -512},
    // 18 seconds
    { -1848, -24, -16},
    { -1576, 160, -256},
    { -1344, 40, -272},
    { -1168, 256, -40},
    { -1256, 120, -224},
    { -1232, 128, -72},
    { -1192, 184, -184},
    { -1072, 272, -176},
    { -1072, 368, -136},
    { -1248, 648, -128},
    { -1296, 600, -72},
    { -1192, 704, -400},
    { -1000, 552, -392},
    { -1112, 504, -376},
    { -1552, 408, -152},
    { -1968, 296, -56},
    { -1752, -136, -104},
    { -1720, 152, -56},
    { -1512, 80, -40},
    { -1376, 96, 8},
    { -1224, 40, 32},
    { -1000, -72, -32},
    { -1008, 48, 64},
    { -776, -184, 104},
    { -688, -208, -48},
    // 19 seconds
    { -880, -184, -104},
    { -1072, -104, -304},
    { -1368, 16, -320},
    { -1536, -88, -344},
    { -1816, -128, -56},
    { -1632, 168, -216},
    { -1320, 264, -8},
    { -904, 328, 344},
    { -1408, 528, -184},
    { -1304, 360, -40},
    { -1224, 360, 16},
    { -1344, 544, -80},
    { -1160, 1064, -56},
    { -1336, 792, -192},
    { -1168, 416, -208},
    { -960, 864, -272},
    { -1152, 360, -272},
    { -1504, 344, -160},
    { -1680, 264, -32},
    { -1632, 304, -248},
    { -1272, -264, -368},
    { -1344, 120, 40},
    { -1352, 152, 24},
    { -1328, 136, 48},
    { -1320, 128, 48},
    // 20 seconds
    { -984, -264, 144},
    { -896, -408, -16},
    { -1144, -96, -120},
    { -1184, -64, -232},
    { -1216, -40, -224},
    { -1360, -136, 104},
    { -1424, 176, -80},
    { -1400, 208, -40},
    { -1336, 304, 152},
    { -1448, 880, 96},
    { -1352, 512, 72},
    { -1352, 416, 152},
    { -1240, 464, 232},
    { -1192, 512, 248},
    { -1184, 800, 120},
    { -1080, 992, -128},
    { -864, 800, -224},
    { -992, 776, -280},
    { -1272, 584, -136},
    { -1688, 512, 56},
    { -1688, 360, 24},
    { -1536, 208, 72},
    { -1560, 272, 136},
    { -1496, 248, 88},
    { -1344, 216, 136},
    // 21 seconds
    { -1216, 176, 160},
    { -1120, 176, 120},
    { -936, -72, 96},
    { -840, -256, 24},
    { -952, -8, -320},
    { -1144, 128, -264},
    { -1320, 168, -344},
    { -1352, -128, -168},
    { -1424, -264, -24},
    { -1440, 240, -160},
    { -1584, 664, -600},
    { -1296, 296, -248},
    { -1296, 408, -96},
    { -1224, 392, -32},
    { -1232, 424, -56},
    { -1376, 504, -32},
    { -1136, 648, -152},
    { -1208, 584, -136},
    { -1104, 600, -176},
    { -904, 488, -192},
    { -1072, 544, -160},
    { -1376, 520, 8},
    { -1512, 344, 32},
    { -1440, 280, 32},
    { -1392, 200, 64},
    // 22 seconds
    { -1416, 192, 80},
    { -1360, 168, 80},
    { -1200, 168, 120},
    { -1160, 192, 152},
    { -1224, 200, 120},
    { -1024, -256, 216},
    { -944, -400, 56},
    { -1112, -152, -256},
    { -1320, -72, -120},
    { -1536, 64, -216},
    { -1536, 24, -256},
    { -1544, 24, -208},
    { -1056, 256, -424},
    { -1320, 72, 80},
    { -1224, 456, -160},
    { -1216, 512, -56},
    { -1088, 408, -48},
    { -960, 248, -24},
    { -1112, 368, -112},
    { -1112, 504, -56},
    { -1224, 600, -256},
    { -1264, 688, -368},
    { -1224, 360, -344},
    { -1464, 344, -240},
    { -1760, 352, -152},
    // 23 seconds
    { -2128, 224, -16},
    { -1912, 544, -320},
    { -1600, 280, -48},
    { -1376, 112, 128},
    { -1272, 152, 112},
    { -1064, 152, 104},
    { -944, 120, 96},
    { -816, -48, 160},
    { -560, -192, 104},
    { -672, -216, 88},
    { -936, 96, -352},
    { -1168, 264, -312},
    { -1448, 352, -408},
    { -1640, 192, -464},
    { -1760, 64, -168},
    { -1752, 408, -64},
    { -1280, 688, 400},
    { -1344, 424, -96},
    { -1296, 392, 8},
    { -1304, 312, 88},
    { -1080, 376, 64},
    { -944, 368, 104},
    { -1064, 560, 120},
    { -1000, 608, 160},
    { -1120, 584, 40},
    // 24 seconds
    { -912, 680, 8},
    { -920, 568, -64},
    { -1280, 552, -16},
    { -1592, 536, -32},
    { -1688, 384, 8},
    { -1600, 256, 16},
    { -1808, 248, -224},
    { -1472, -48, 32},
    { -1328, 152, 176},
    { -1216, 192, 120},
    { -1096, 96, 88},
    { -992, -32, 136},
    { -760, -288, 80},
    { -920, -208, 8},
    { -1184, 80, -200},
    { -1288, 224, -320},
    { -1416, 72, -192},
    { -1544, -136, -40},
    { -1592, 40, -56},
    { -1200, 40, 184},
    { -1248, 232, 128},
    { -1200, 400, 48},
    { -1176, 360, 8},
    { -1152, 368, 32},
    { -1056, 336, 40},
    // 25 seconds
    { -1232, 496, -8},
    { -1072, 720, -80},
    { -1288, 728, -224},
    { -968, 528, -320},
    { -856, 688, -360},
    { -1328, 888, -120},
    { -1800, 664, 48},
    { -1904, 408, 32},
    { -1696, 328, 104},
    { -1552, 248, 184},
    { -1408, 168, 152},
    { -1280, 112, 88},
    { -1080, 96, 104},
    { -1024, 120, 0},
    { -904, -192, 64},
    { -672, -296, -88},
    { -984, -48, -232},
    { -1128, 8, -368},
    { -1256, 80, -216},
    { -1456, 8, -248},
    { -1712, -160, 24},
    { -1752, 160, -80},
    { -1528, 336, -440},
    { -1456, 400, -184},
    { -1304, 512, -48},
    // 26 seconds
    { -1264, 360, 8},
    { -1104, 296, -40},
    { -992, 232, 80},
    { -1136, 552, 56},
    { -1144, 848, 128},
    { -1272, 744, 8},
    { -824, 496, -112},
    { -904, 576, -144},
    { -1248, 592, 104},
    { -1616, 520, 184},
    { -1672, 352, 96},
    { -1624, 264, 160},
    { -1608, 176, 160},
    { -1584, 152, 136},
    { -1440, 136, 136},
    { -1264, 160, 112},
    { -1240, 152, 152},
    { -1112, -272, 208},
    { -808, -656, 96},
    { -1192, -256, 0},
    { -1304, 16, -312},
    { -1504, 176, -240},
    { -1536, -96, -16},
    { -1664, -144, 40},
    { -1648, 136, -24},
    // 27 seconds
    { -1496, 256, 152},
    { -1368, 680, -64},
    { -1272, 504, 40},
    { -1216, 384, 64},
    { -1040, 352, 24},
    { -1096, 456, 80},
    { -1048, 784, 0},
    { -1280, 952, 48},
    { -976, 416, -120},
    { -840, 288, -280},
    { -1128, 520, -128},
    { -1560, 568, 72},
    { -1792, 368, 56},
    { -1704, 248, 80},
    { -1592, 208, 112},
    { -1552, 208, 144},
    { -1440, 168, 128},
    { -1296, 168, 128},
    { -1264, 224, 104},
    { -1176, -216, 296},
    { -792, -576, 80},
    { -904, -488, -80},
    { -1392, -144, -72},
    { -1432, -96, -336},
    { -1552, -48, -144},
    // 28 seconds
    { -1656, -128, 32},
    { -1680, 192, -16},
    { -1624, 440, 24},
    { -1400, 400, 40},
    { -1272, 448, -56},
    { -1288, 416, 24},
    { -1184, 416, -8},
    { -1056, 576, -112},
    { -1040, 760, -136},
    { -1168, 608, 8},
    { -1136, 688, -72},
    { -968, 536, -160},
    { -1192, 536, -104},
    { -1512, 416, 80},
    { -1616, 80, 48},
    { -1760, 416, 104},
    { -1616, 248, 136},
    { -1512, 176, 120},
    { -1440, 208, 120},
    { -1288, 176, 136},
    { -1104, 168, 80},
    { -1064, 144, 88},
    { -1024, -32, 120},
    { -816, -496, 40},
    { -672, -264, -704},
    // 29 seconds
    { -1448, 88, -440},
    { -1704, 72, -512},
    { -1672, 104, -248},
    { -1600, 8, -56},
    { -1520, 264, -144},
    { -1432, 392, 56},
    { -1384, 224, 80},
    { -1416, 376, 32},
    { -1256, 336, 112},
    { -1032, 328, 160},
    { -1136, 456, 208},
    { -1080, 696, 232},
    { -1040, 552, 192},
    { -1048, 752, 64},
    { -856, 632, -8},
    { -1032, 704, -16},
    { -1288, 512, 24},
    { -1656, 560, -24},
    { -1656, 264, -56},
    { -1608, 208, -8},
    { -1304, 88, 1544},
    { -1608, 304, -168},
    { -1352, 168, 96},
    { -1128, 128, 88},
    { -1040, 136, 48},
    // 30 seconds
    { -1048, 8, 72},
    { -960, -312, 64},
    { -1072, -120, -120},
    { -984, -40, -344},
    { -1352, 48, -328},
    { -1504, -56, -120},
    { -1632, -104, -80},
    { -1640, 96, -56},
    { -1632, 344, 48},
    { -1304, 336, 104},
    { -1328, 472, -24},
    { -1304, 352, 40},
    { -1120, 376, 48},
    { -1128, 576, -32},
    { -1096, 680, 32},
    { -1288, 816, -8},
    { -976, 576, -128},
    { -840, 512, -296},
    { -1064, 528, -192},
    { -1456, 560, 8},
    { -1696, 384, 40},
    { -1648, 256, 48},
    { -1568, 240, 48},
    { -1520, 216, 96},
    { -1424, 176, 88},
    // 31 seconds
    { -1264, 160, 88},
    { -1240, 176, 96},
    { -1232, -152, 232},
    { -1016, -456, 80},
    { -1112, -328, 32},
    { -1256, -8, -304},
    { -1344, 136, -344},
    { -1416, 104, -160},
    { -1432, -176, -120},
    { -1544, 24, -56},
    { -1384, 120, 336},
    { -1416, 392, 200},
    { -1336, 488, 8},
    { -1208, 512, -48},
    { -1048, 368, -16},
    { -912, 544, -128},
    { -1000, 608, -104},
    { -1176, 640, -64},
    { -1232, 680, -96},
    { -968, 464, -200},
    { -1136, 480, -184},
    { -1456, 520, -64},
    { -1768, 408, -104},
    { -1816, 184, 8},
    { -2048, 152, -648},
    // 32 seconds
    { -1536, 184, -168},
    { -1336, 24, 48},
    { -1264, 144, 160},
    { -1024, 88, 64},
    { -1032, 216, 104},
    { -872, 272, -40},
    { -808, 384, 72},
    { -560, 592, 24},
    { -320, 944, 72},
    { -104, 1312, 112},
    { 0, 1184, -64},
    { -144, 928, 232},
    { 32, 864, 112},
    { 144, 856, 184},
    { 224, 624, 192},
    { 240, 648, 144},
    { 256, 608, 168},
    { 288, 608, 128},
    { 280, 672, 104},
    { 176, 792, 184},
    { 160, 928, 248},
    { 224, 1152, 232},
    { 240, 1136, 312},
    { 312, 1064, 264},
    { 312, 920, 376},
    // 33 seconds
    { 288, 920, 416},
    { 24, 952, 424},
    { -40, 856, 176},
    { 56, 608, 120},
    { 80, 568, 16},
    { 136, 592, 8},
    { 144, 664, 0},
    { 144, 864, 16},
    { 144, 952, 80},
    { 248, 1112, -32},
    { 216, 1216, 80},
    { 224, 1240, 32},
    { 144, 1288, -48},
    { 8, 1080, 24},
    { -40, 912, 8},
    { 8, 800, -16},
    { 104, 632, -16},
    { 208, 504, 32},
    { 280, 488, 24},
    { 320, 456, 96},
    { 384, 512, 48},
    { 336, 568, 88},
    { 248, 912, 160},
    { 184, 1120, 240},
    { 240, 1488, 176},
    // 34 seconds
    { 176, 1288, 216},
    { 256, 1064, 184},
    { 184, 1032, 248},
    { 144, 1016, 232},
    { 0, 1088, 192},
    { 56, 800, 40},
    { 112, 640, 16},
    { 136, 560, -8},
    { 136, 488, -32},
    { 160, 424, -16},
    { 88, 408, 184},
    { 56, 504, -160},
    { 64, 616, 120},
    { -280, 1152, -24},
    { -584, 2080, 224},
    { -312, 1832, 208},
    { -64, 1152, 120},
    { -136, 944, -40},
    { -256, 856, 24},
    { -216, 824, -48},
    { -144, 744, -56},
    { -32, 632, -32},
    { 80, 576, -56},
    { 96, 600, -24},
    { 136, 584, -72},
    // 35 seconds
    { 168, 592, -32},
    { 72, 856, -64},
    { -48, 1024, 112},
    { -272, 1248, 24},
    { -408, 1304, 128},
    { -296, 1232, 8},
    { -280, 1080, 256},
    { -240, 1136, 208},
    { -192, 1080, 176},
    { -104, 912, 96},
    { -8, 760, 0},
    { 16, 680, 16},
    { 16, 728, 8},
    { -8, 736, 72},
    { -72, 912, 88},
    { -72, 936, 128},
    { -32, 1016, 104},
    { -64, 1176, 88},
    { -48, 1160, -24},
    { -160, 1176, -40},
    { -160, 1088, -120},
    { -88, 832, -32},
    { 8, 680, -32},
    { 112, 584, -56},
    { 192, 504, 0},
    // 36 seconds
    { 272, 512, -16},
    { 256, 592, -32},
    { 272, 576, 40},
    { 224, 776, 16},
    { 152, 976, 152},
    { 176, 1216, 8},
    { 176, 1480, -104},
    { 208, 1240, -8},
    { 200, 1040, 88},
    { 144, 1008, 168},
    { 88, 1024, 152},
    { 40, 888, 104},
    { 112, 680, 24},
    { 144, 528, -16},
    { 160, 520, -16},
    { 136, 520, 0},
    { 88, 520, 32},
    { 32, 624, 96},
    { -64, 872, 224},
    { -136, 1176, 176},
    { -112, 1432, 96},
    { -120, 1728, -176},
    { -176, 1504, -280},
    { -144, 1072, -320},
    { -160, 784, -160},
    // 37 seconds
    { -168, 672, -80},
    { -168, 632, -72},
    { -144, 544, -48},
    { -80, 472, -8},
    { -40, 464, -8},
    { -8, 560, -32},
    { -48, 792, 0},
    { -128, 1128, 56},
    { -184, 1448, 144},
    { -216, 1624, 168},
    { -192, 1304, 176},
    { -72, 1056, 104},
    { -72, 992, 160},
    { -152, 1056, 232},
    { -272, 1064, 128},
    { -176, 776, 40},
    { -144, 560, 24},
    { -120, 496, 48},
    { -136, 608, 40},
    { -104, 576, 32},
    { -104, 744, 72},
    { -200, 912, 160},
    { -280, 1104, 216},
    { -272, 1384, 192},
    { -216, 1520, 48},
    // 38 seconds
    { -264, 1264, -104},
    { -200, 1000, -96},
    { -208, 784, 40},
    { -216, 776, 40},
    { -184, 632, 72},
    { -136, 504, 104},
    { -64, 416, 112},
    { 24, 408, 80},
    { 120, 472, -80},
    { 104, 424, 184},
    { -336, 992, 200},
    { -736, 1768, 168},
    { -592, 1688, 304},
    { -344, 1408, 16},
    { -240, 1048, 128},
    { -240, 1032, 176},
    { -312, 1144, 200},
    { -424, 1088, 216},
    { -336, 824, 64},
    { -296, 584, 8},
    { -272, 464, 0},
    { -256, 352, 0},
    { -240, 312, 32},
    { -256, 192, 120},
    { -496, 696, 224},
    // 39 seconds
    { -912, 1088, 512},
    { -776, 1272, 768},
    { -648, 1552, 696},
    { -464, 872, 680},
    { -416, 880, 536},
    { -432, 592, 616},
    { -440, 464, 672},
    { -288, 488, 472},
    { -248, 408, 424},
    { -248, 368, 456},
    { -248, 336, 496},
    { -264, 504, 408},
    { -352, 616, 560},
    { -408, 736, 688},
    { -512, 1040, 728},
    { -552, 1200, 880},
    { -456, 1208, 808},
    { -272, 1040, 664},
    { -248, 840, 792},
    { -280, 920, 792},
    { -328, 880, 824},
    { -272, 664, 648},
    { -248, 504, 528},
    { -240, 360, 464},
    { -216, 224, 360},
    // 40 seconds
    { -160, 136, 264},
    { -176, 96, 208},
    { -288, 112, 224},
    { -544, 112, 224},
    { -1432, 648, 672},
    { -1368, 440, 808},
    { -1720, 1872, 752},
    { -1200, 1240, 968},
    { -880, 704, 752},
    { -696, 768, 568},
    { -448, 560, 400},
    { -336, 408, 448},
    { -256, 344, 440},
    { -272, 360, 424},
    { -296, 360, 512},
    { -280, 496, 568},
    { -432, 592, 592},
    { -648, 736, 712},
    { -848, 912, 800},
    { -888, 1008, 672},
    { -864, 1048, 568},
    { -848, 960, 528},
    { -728, 792, 248},
    { -680, 624, 464},
    { -752, 560, 320},
    // 41 seconds
    { -728, 632, 224},
    { -688, 504, 232},
    { -624, 248, 168},
    { -584, 160, 128},
    { -528, 152, 64},
    { -608, 128, 64},
    { -840, 144, 40},
    { -1232, 208, -32},
    { -1648, 160, -48},
    { -1976, 400, -480},
    { -1592, 312, -744},
    { -1280, -40, -224},
    { -1120, 392, -48},
    { -1344, 80, -32},
    { -968, 480, 16},
    { -952, 400, 136},
    { -824, 224, 112},
    { -752, 160, 152},
    { -640, 320, 8},
    { -608, 240, 16},
    { -968, 400, -56},
    { -1248, 176, 192},
    { -1536, 728, 48},
    { -1216, -80, -160},
    { -1048, 448, -200},
    // 42 seconds
    { -1192, 568, -104},
    { -1400, 512, -80},
    { -1472, 320, 0},
    { -1296, 288, 72},
    { -1224, 208, 176},
    { -1080, 40, 208},
    { -1112, 32, 80},
    { -872, 72, 112},
    { -840, 112, 200},
    { -880, 104, 144},
    { -840, 128, 112},
    { -944, 104, 88},
    { -1160, 200, -80},
    { -1320, 376, -232},
    { -1296, 352, -376},
    { -1400, -72, -216},
    { -1400, 128, -232},
    { -1440, 480, 16},
    { -1224, 456, -200},
    { -1032, 312, -64},
    { -1040, 336, -56},
    { -976, 376, -40},
    { -848, 368, 0},
    { -904, 384, 88},
    { -1040, 824, 112},
    // 43 seconds
    { -1176, 432, 88},
    { -1352, 584, 56},
    { -1056, 568, -104},
    { -1080, 664, -16},
    { -1360, 512, 208},
    { -1472, 376, 232},
    { -1488, 272, 184},
    { -1576, 224, 304},
    { -1552, 96, 320},
    { -1520, 80, 312},
    { -1296, 64, 272},
    { -1152, 72, 264},
    { -1080, 112, 240},
    { -960, 120, 216},
    { -896, 72, 176},
    { -896, 64, 152},
    { -808, 360, -128},
    { -800, 408, -368},
    { -888, 352, -224},
    { -944, 72, -280},
    { -1064, 8, -336},
    { -1064, 152, -512},
    { -1072, 256, -624},
    { -1096, 184, -408},
    { -1272, 200, -456},
    // 44 seconds
    { -1168, -32, -328},
    { -1040, 160, -392},
    { -1056, 456, -360},
    { -1048, 464, -168},
    { -1304, 256, 88},
    { -1320, 336, 8},
    { -1120, 432, -88},
    { -984, 360, 80},
    { -1168, 368, 184},
    { -1472, 320, 272},
    { -1336, 176, 304},
    { -1168, 56, 288},
    { -1080, 72, 232},
    { -1032, 72, 232},
    { -1048, 136, 232},
    { -1080, 144, 208},
    { -1176, 168, 256},
    { -1200, 104, 232},
    { -1328, 96, 256},
    { -1408, 120, 256},
    { -1080, 128, -136},
    { -552, 168, -544},
    { -800, 120, -288},
    { -920, -48, -272},
    { -1032, -24, -272},
    // 45 seconds
    { -1192, 120, -240},
    { -1080, 320, -440},
    { -912, 312, -424},
    { -1200, 536, -520},
    { -1056, 640, -488},
    { -904, 400, -224},
    { -952, 584, -144},
    { -1128, 312, -136},
    { -1384, 456, -136},
    { -1176, 368, -152},
    { -1032, 400, -104},
    { -1248, 296, -24},
    { -1616, 528, 40},
    { -1432, 232, 96},
    { -1224, 392, 72},
    { -1112, 336, 120},
    { -1128, 312, 112},
    { -1120, 288, 168},
    { -1008, 152, 336},
    { -1112, 312, -192},
    { -1232, -152, 240},
    { -912, -352, -280},
    { -1232, -40, -128},
    { -1520, 240, 152},
    { -1296, 568, -64},
    // 46 seconds
    { -1352, 376, 176},
    { -1432, 520, 120},
    { -1344, 472, 120},
    { -1152, 456, 136},
    { -1040, 448, 184},
    { -1008, 472, 240},
    { -944, 432, 232},
    { -872, 400, 208},
    { -920, 448, 296},
    { -1056, 536, 424},
    { -992, 440, 328},
    { -1224, 640, 280},
    { -1072, 528, 184},
    { -1232, 552, 72},
    { -1584, 600, 328},
    { -1704, 392, 320},
    { -1480, 224, 288},
    { -1336, 152, 256},
    { -1272, 160, 192},
    { -1248, 168, 176},
    { -1152, 192, 80},
    { -1176, 336, -96},
    { -1400, 224, 64},
    { -1032, -192, 32},
    { -1088, -320, 32},
    // 47 seconds
    { -920, 56, -160},
    { -776, 184, -56},
    { -928, 88, -16},
    { -1360, 120, 136},
    { -2000, 416, 168},
    { -1816, 560, 40},
    { -1448, 784, 272},
    { -1000, 344, -32},
    { -1120, 72, -408},
    { -1192, 784, -128},
    { -824, 368, -280},
    { -1048, -112, -392},
    { -1400, 8, -592},
    { -1456, -32, -608},
    { -1096, 136, -416},
    { -1440, 296, -504},
    { -1832, 240, -328},
    { -1792, 232, -288},
    { -1392, 136, -128},
    { -1216, 160, 24},
    { -1224, 184, 72},
    { -1096, 104, 40},
    { -976, 72, 48},
    { -984, 72, 112},
    { -936, 80, 144},
    // 48 seconds
    { -872, 80, 40},
    { -1240, -72, 208},
    { -1136, 152, -88},
    { -928, 352, -456},
    { -1112, 152, -256},
    { -1440, 120, -232},
    { -1552, 152, -288},
    { -1600, 312, -168},
    { -1568, 536, -40},
    { -1344, 912, -64},
    { -1184, 216, -184},
    { -1144, 432, -128},
    { -1072, 504, 96},
    { -1032, 696, 112},
    { -1088, 616, 24},
    { -1120, 560, -24},
    { -888, 528, -56},
    { -1264, 616, -64},
    { -1840, 536, 24},
    { -1880, 352, 8},
    { -1576, 224, 40},
    { -1448, 216, 104},
    { -1344, 192, 96},
    { -1240, 192, 88},
    { -1120, 184, 112},
    // 49 seconds
    { -1016, 152, 152},
    { -984, 64, 184},
    { -856, -232, 216},
    { -952, -320, 192},
    { -1160, 200, -128},
    { -1264, 344, -352},
    { -1568, 464, -136},
    { -1688, -288, 200},
    { -1824, 184, -72},
    { -952, 48, -16},
    { -1480, 1592, 688},
    { -1024, 584, -208},
    { -1144, 352, -80},
    { -1144, 312, 104},
    { -1200, 232, 248},
    { -1232, 472, 504},
    { -1080, 552, 432},
    { -1000, 392, 176},
    { -760, 496, 128},
    { -1064, 584, 112},
    { -1464, 568, 248},
    { -1656, 536, 200},
    { -1464, 256, 176},
    { -1472, 264, 168},
    { -1464, 176, 200},
    // 50 seconds
    { -1504, 152, 232},
    { -1376, 208, 192},
    { -1288, 288, 320},
    { -1336, 656, 328},
    { -968, 400, 288},
    { -864, 760, 392},
    { -408, 760, 304},
    { -72, 1024, 240},
    { -120, 856, 336},
    { -64, 784, 288},
    { 72, 672, 232},
    { 256, 464, 232},
    { 296, 480, 192},
    { 272, 384, 216},
    { 296, 320, 256},
    { 288, 440, 296},
    { 288, 720, 568},
    { 520, 1088, 696},
    { 696, 1112, 792},
    { 656, 1192, 704},
    { 488, 1120, 624},
    { 472, 896, 544},
    { 408, 704, 488},
    { 360, 640, 360},
    { 288, 584, 192},
    // 51 seconds
    { 240, 328, -56},
    { 152, 264, -96},
    { 96, 72, -32},
    { -32, 0, 48},
    { -216, 96, 96},
    { -432, 80, 128},
    { -888, 48, 208},
    { -1872, 616, 88},
    { -2936, 672, 288},
    { -3008, 832, 320},
    { -1672, 1088, 304},
    { -1560, 1048, -472},
    { -1592, 96, -8},
    { -1184, 168, 0},
    { -944, 280, 184},
    { -768, 472, 216},
    { -744, 488, 248},
    { -696, 512, 232},
    { -696, 360, 248},
    { -664, 384, 272},
    { -896, 184, 392},
    { -1320, 496, 400},
    { -1664, 568, 104},
    { -1240, 544, 24},
    { -1136, 560, 0},
    // 52 seconds
    { -1552, 568, 80},
    { -1832, 496, 248},
    { -1720, 280, 232},
    { -1360, 80, 224},
    { -1152, 152, 112},
    { -984, 192, 64},
    { -856, 168, 40},
    { -776, 120, 48},
    { -808, -24, 0},
    { -872, -176, 112},
    { -872, 0, -288},
    { -1152, 240, -208},
    { -1304, 256, -192},
    { -1696, 360, -144},
    { -1712, 104, 32},
    { -1672, 136, 104},
    { -1568, 552, 160},
    { -1208, 224, 96},
    { -1168, 352, -40},
    { -1152, 272, 88},
    { -1048, 312, 120},
    { -960, 392, 160},
    { -1064, 632, 152},
    { -1024, 496, 152},
    { -1184, 368, 160},
    // 53 seconds
    { -1272, 488, 88},
    { -1160, 384, 104},
    { -1336, 384, 32},
    { -1600, 304, 40},
    { -1632, 304, 72},
    { -1448, 392, -728},
    { -1080, -360, 208},
    { -1256, 80, 136},
    { -1224, 192, 104},
    { -1112, 112, 128},
    { -1152, 88, 160},
    { -1072, -352, 200},
    { -984, -264, 120},
    { -1160, 96, -24},
    { -1168, 232, -128},
    { -1368, 352, -160},
    { -1592, 192, 56},
    { -1648, 88, 136},
    { -1488, 416, 256},
    { -1160, 456, 72},
    { -1024, 624, -40},
    { -1104, 336, 16},
    { -1184, 288, 120},
    { -1064, 352, 144},
    { -1064, 544, 168},
    // 54 seconds
    { -880, 440, 176},
    { -1216, 624, 224},
    { -1064, 584, 128},
    { -1224, 616, 56},
    { -1392, 440, 88},
    { -1576, 424, 120},
    { -1496, 320, 88},
    { -1336, 264, 144},
    { -1312, 240, 152},
    { -1240, 176, 136},
    { -1144, 152, 160},
    { -1040, 64, 120},
    { -1136, -8, 104},
    { -1120, -144, 272},
    { -1264, -24, 216},
    { -1120, 168, -160},
    { -1152, 496, -344},
    { -1368, 456, -152},
    { -1520, 16, 104},
    { -1568, 40, 40},
    { -1176, 448, 208},
    { -1224, 672, 288},
    { -1016, 640, 56},
    { -1080, 360, 168},
    { -1016, 296, 224},
    // 55 seconds
    { -1016, 352, 144},
    { -1032, 440, 192},
    { -1160, 544, 224},
    { -1312, 456, 256},
    { -1000, 488, 176},
    { -1048, 592, -32},
    { -1184, 464, 0},
    { -1456, 400, 96},
    { -1448, 384, 0},
    { -1400, 304, -728},
    { -1344, 480, 128},
    { -1192, 336, 224},
    { -1232, 184, 296},
    { -1080, 168, 280},
    { -1232, 64, 360},
    { -1200, -256, 280},
    { -1176, -152, 120},
    { -1168, 64, -24},
    { -1104, 456, -288},
    { -1392, 344, -56},
    { -1496, 72, 152},
    { -1360, -96, 16},
    { -1464, 304, 240},
    { -1064, 432, 80},
    { -992, 488, 0},
    // 56 seconds
    { -1136, 472, 112},
    { -1088, 416, 144},
    { -1056, 520, 208},
    { -1184, 760, 280},
    { -984, 616, 248},
    { -1168, 464, 152},
    { -1136, 560, 88},
    { -1136, 592, 16},
    { -1296, 504, -56},
    { -1704, 480, 104},
    { -1800, 448, 96},
    { -1736, 480, 192},
    { -1544, 416, 104},
    { -1168, 248, 80},
    { -840, 96, 176},
    { -624, 16, 136},
    { -528, -80, 200},
    { -592, -40, 208},
    { -688, 304, 40},
    { -912, 440, 144},
    { -904, 1016, 696},
    { -792, 2104, 424},
    { -560, 1512, 288},
    { -464, 1184, 280},
    { -336, 1040, 224},
    // 57 seconds
    { -152, 816, 144},
    { -40, 688, 48},
    { 8, 560, 80},
    { 88, 528, 64},
    { 136, 488, 104},
    { 232, 520, 16},
    { 192, 800, 8},
    { 152, 944, 136},
    { 128, 1352, -16},
    { 152, 1280, 152},
    { 200, 1176, 96},
    { 232, 1024, 32},
    { 200, 880, 128},
    { 120, 744, 112},
    { 48, 640, -24},
    { 24, 456, -48},
    { 56, 160, 8},
    { -80, 192, 16},
    { -160, 144, -16},
    { -392, 224, -80},
    { -912, 344, -88},
    { -1448, -56, 408},
    { -2968, 424, 224},
    { -2688, 896, -48},
    { -1800, 256, 448},
    // 58 seconds
    { -816, 24, -408},
    { -1184, 320, -48},
    { -1104, 328, 280},
    { -720, 256, 192},
    { -488, 224, 88},
    { -512, 168, 72},
    { -728, 328, 64},
    { -920, 424, -24},
    { -920, 424, 0},
    { -1136, 376, -56},
    { -1344, 296, -88},
    { -1976, 416, -200},
    { -1368, 344, -168},
    { -1432, 176, -320},
    { -1464, 288, -64},
    { -1400, 96, 552},
    { -1296, 392, -8},
    { -1032, 224, 72},
    { -896, 96, 112},
    { -816, 72, 120},
    { -752, 56, 112},
    { -688, 56, 104},
    { -728, 40, 88},
    { -784, -120, 104},
    { -944, 48, 112},
    // 59 seconds
    { -1328, 264, 32},
    { -1592, 440, -72},
    { -1736, 656, -352},
    { -1688, 168, -64},
    { -1400, 704, -144},
    { -864, -72, 48},
    { -1048, 472, 24},
    { -880, 352, -32},
    { -792, 240, 40},
    { -704, 232, 80},
    { -688, 264, 88},
    { -904, 304, 120},
    { -1256, 384, 184},
    { -1272, 768, 392},
    { -1456, 248, 184},
    { -1240, 424, 24},
    { -1048, 568, -8},
    { -1232, 424, -32},
    { -1464, 328, -32},
    { -1416, 256, 80},
    { -1040, -312, 320},
    { -1136, 120, 160},
    { -1040, 160, 128},
    { -944, 144, 80},
    { -888, 160, 88},
    // 60 seconds
    // elapsed: 1 minutes
    { -1000, 160, 192},
    { -1008, -32, 152},
    { -1104, -176, 136},
    { -1192, 216, 16},
    { -1176, 368, -128},
    { -1352, 376, -96},
    { -1480, 96, 168},
    { -1464, -24, 216},
    { -1080, 0, 376},
    { -920, 256, 80},
    { -984, 392, 56},
    { -1088, 280, 88},
    { -1112, 312, 112},
    { -864, 232, 72},
    { -1040, 376, 112},
    { -1128, 584, 352},
    { -1344, 408, 232},
    { -1192, 368, 80},
    { -1112, 472, 104},
    { -1320, 488, -40},
    { -1408, 456, -56},
    { -1384, 392, -24},
    { -1232, 208, 120},
    { -1176, 136, 424},
    { -1200, 136, 120},
    // 61 seconds
    { -1144, 152, 112},
    { -1040, 136, 120},
    { -1024, 120, 128},
    { -1088, 64, 168},
    { -912, -72, 152},
    { -1016, -24, 128},
    { -1040, 240, -72},
    { -992, 352, -248},
    { -1208, 416, -240},
    { -1432, 72, -32},
    { -1400, 32, -8},
    { -1208, 304, -176},
    { -960, 376, -336},
    { -984, 368, -120},
    { -1048, 296, -32},
    { -1016, 312, 24},
    { -856, 280, 88},
    { -872, 512, 120},
    { -880, 448, 176},
    { -1216, 560, 136},
    { -1192, 520, 48},
    { -1224, 416, 8},
    { -1368, 320, -40},
    { -1552, 360, -40},
    { -1552, 288, -144},
    // 62 seconds
    { -1568, 312, 24},
    { -1544, 304, -16},
    { -1360, 352, 40},
    { -1040, 344, 80},
    { -832, 344, 24},
    { -624, 208, 104},
    { -464, 192, 152},
    { -392, 112, 112},
    { -232, 536, -392},
    { -592, 744, 640},
    { -560, 1536, 392},
    { -224, 1128, 256},
    { -56, 1136, 16},
    { -120, 992, 144},
    { -144, 960, 152},
    { -136, 944, 248},
    { -88, 832, 200},
    { -104, 848, 168},
    { -32, 752, 208},
    { -24, 752, 232},
    { 8, 872, 184},
    { 64, 784, 280},
    { 72, 864, 200},
    { 120, 864, 304},
    { 64, 984, 144},
    // 63 seconds
    { 128, 824, 80},
    { 64, 808, 184},
    { 72, 856, 64},
    { 48, 792, 96},
    { 40, 808, 160},
    { 24, 904, 104},
    { 0, 896, 240},
    { -32, 984, 208},
    { -8, 912, 128},
    { -32, 824, 272},
    { -40, 936, 208},
    { -48, 888, 272},
    { -48, 856, 304},
    { -48, 888, 304},
    { -8, 808, 304},
    { -16, 864, 248},
    { 0, 824, 328},
    { -40, 992, 376},
    { -16, 1048, 248},
    { -8, 784, 448},
    { 48, 784, 160},
    { 8, 896, 216},
    { 16, 848, 240},
    { 0, 840, 312},
    { 0, 880, 184},
    // 64 seconds
    { 56, 824, 288},
    { 56, 984, 264},
    { 24, 928, 352},
    { 48, 952, 368},
    { 80, 800, 336},
    { 56, 976, 376},
    { -8, 1064, 720},
    { 72, 1136, 440},
    { 160, 704, 432},
    { 216, 824, 368},
    { 232, 680, 312},
    { 256, 728, 440},
    { 264, 752, 376},
    { 264, 688, 504},
    { 288, 712, 408},
    { 288, 760, 416},
    { 288, 776, 400},
    { 280, 760, 424},
    { 264, 864, 384},
    { 264, 744, 480},
    { 280, 768, 448},
    { 272, 824, 440},
    { 320, 720, 448},
    { 344, 808, 376},
    { 352, 712, 384},
    // 65 seconds
    { 328, 744, 456},
    { 344, 760, 392},
    { 376, 560, 200},
    { 352, 800, 304},
    { 376, 736, 312},
    { 368, 704, 368},
    { 360, 672, 424},
    { 344, 736, 360},
    { 336, 672, 456},
    { 368, 760, 416},
    { 320, 776, 440},
    { 328, 800, 424},
    { 304, 760, 424},
    { 352, 816, 360},
    { 344, 720, 360},
    { 344, 720, 392},
    { 344, 744, 352},
    { 344, 736, 376},
    { 328, 768, 360},
    { 304, 848, 280},
    { 312, 744, 312},
    { 328, 928, 160},
    { 376, 848, 232},
    { 312, 952, 144},
    { 328, 912, -16},
    // 66 seconds
    { 224, 936, -64},
    { 160, 760, -216},
    { 144, 816, -432},
    { 152, 552, -256},
    { 160, 592, -264},
    { 152, 832, -240},
    { 128, 824, -120},
    { 80, 960, 40},
    { 56, 968, 184},
    { 128, 992, 296},
    { 64, 992, 312},
    { 96, 880, 432},
    { 48, 1016, 464},
    { 64, 912, 440},
    { 40, 792, 408},
    { 104, 936, 352},
    { 216, 1000, 312},
    { 160, 904, 296},
    { 184, 1000, -8},
    { 240, 768, -56},
    { 256, 680, -280},
    { 256, 600, -416},
    { 184, 584, -584},
    { 176, 424, -704},
    { 144, 448, -808},
    // 67 seconds
    { 96, 216, -880},
    { 48, 288, -952},
    { 56, 240, -968},
    { 48, 136, -912},
    { -24, 240, -856},
    { 80, 208, -904},
    { 96, 136, -896},
    { 40, 104, -928},
    { 24, 120, -968},
    { 16, 104, -1000},
    { -8, 120, -1120},
    { 24, 16, -968},
    { 96, -96, -1000},
    { 48, -152, -968},
    { -48, -208, -1016},
    { 8, -296, -960},
    { 16, -8, -1000},
    { 16, -208, -1016},
    { -32, -208, -984},
    { 16, -184, -1008},
    { 0, -256, -976},
    { -24, -264, -968},
    { -32, -208, -968},
    { 32, -224, -976},
    { 8, -240, -976},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:38:07 local
AccelRawData *activity_sample_walk_100_pbl_25478_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25478_5
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -96, -376, -1080},
    { -360, -280, -928},
    { 0, -320, -1072},
    { -248, -344, -1000},
    { -112, -376, -952},
    { -216, -400, -936},
    { -144, -392, -920},
    { -160, -368, -944},
    { -120, -360, -968},
    { -128, -432, -1008},
    { -48, -328, -960},
    { -120, -376, -944},
    { -104, -432, -904},
    { -48, -448, -920},
    { -72, -424, -928},
    { -88, -456, -912},
    { 0, -456, -976},
    { -136, -360, -952},
    { -96, -416, -936},
    { -88, -368, -936},
    { -48, -432, -912},
    { -24, -400, -936},
    { -40, -424, -928},
    { -16, -392, -936},
    { -8, -408, -944},
    // 1 seconds
    { 8, -384, -944},
    { 8, -352, -952},
    { 24, -376, -944},
    { 24, -352, -944},
    { 32, -376, -960},
    { 0, -376, -960},
    { -16, -360, -976},
    { 0, -376, -968},
    { -48, -392, -944},
    { -8, -392, -952},
    { -8, -368, -960},
    { -8, -344, -968},
    { 0, -384, -968},
    { -8, -384, -936},
    { 0, -352, -936},
    { 0, -352, -928},
    { -8, -368, -920},
    { 16, -368, -928},
    { 8, -376, -928},
    { 16, -392, -920},
    { 8, -392, -928},
    { 0, -384, -920},
    { -8, -416, -920},
    { -56, -376, -896},
    { -104, -400, -912},
    // 2 seconds
    { -80, -368, -928},
    { -112, -336, -936},
    { -144, -344, -976},
    { -120, -352, -976},
    { -128, -384, -952},
    { -184, -352, -944},
    { -112, -296, -960},
    { -112, -312, -952},
    { -112, -264, -1000},
    { -144, -232, -1016},
    { -224, -200, -1008},
    { -216, -176, -920},
    { -240, -136, -784},
    { -264, 40, -760},
    { -192, 192, -744},
    { -96, 424, -624},
    { -8, 872, -424},
    { 160, 1336, -296},
    { 216, 1128, -168},
    { 280, 1040, 0},
    { 272, 1016, 72},
    { 208, 1032, 216},
    { 160, 928, 272},
    { 168, 936, 176},
    { 176, 880, 336},
    // 3 seconds
    { 136, 840, 272},
    { 128, 800, 208},
    { 176, 808, 264},
    { 136, 824, 304},
    { 144, 776, 264},
    { 112, 880, 144},
    { 0, 808, 40},
    { 232, 864, 192},
    { 240, 976, 144},
    { 280, 840, 104},
    { 304, 984, 216},
    { 296, 1032, 192},
    { 248, 1040, 240},
    { 184, 1152, 248},
    { 40, 976, 296},
    { -64, 912, 128},
    { -128, 616, 176},
    { -128, 616, 176},
    { -152, 760, 216},
    { -96, 632, 240},
    { -40, 680, 184},
    { -8, 752, 168},
    { -48, 776, 232},
    { -56, 808, 136},
    { -56, 760, 128},
    // 4 seconds
    { -24, 1024, -56},
    { -104, 1312, 72},
    { -128, 1328, 344},
    { -128, 1520, 408},
    { -128, 1288, 512},
    { -40, 1096, 400},
    { 48, 800, 304},
    { 16, 744, 384},
    { -64, 792, 336},
    { -152, 736, 224},
    { -120, 600, 240},
    { -184, 560, 56},
    { -232, 400, 16},
    { -264, 328, -56},
    { -376, 400, -48},
    { -640, 368, 56},
    { -928, 136, 16},
    { -2360, 264, -192},
    { -2040, -72, -808},
    { -1832, 144, -856},
    { -1456, 200, -488},
    { -1256, 192, -8},
    { -1128, 416, -112},
    { -1000, 296, 56},
    { -824, 272, 48},
    // 5 seconds
    { -728, 272, 80},
    { -648, 216, 32},
    { -696, 360, 16},
    { -568, 256, -152},
    { -816, 424, -88},
    { -1128, 424, -168},
    { -1432, 512, -312},
    { -1592, 560, -472},
    { -1448, 544, -584},
    { -1464, 480, -528},
    { -1600, -416, 720},
    { -1680, 288, -224},
    { -1360, 208, 96},
    { -1184, 184, -112},
    { -976, 40, -56},
    { -872, 120, -16},
    { -752, 88, -32},
    { -688, 56, -24},
    { -536, -240, 128},
    { -624, 16, 24},
    { -848, -8, -136},
    { -1336, 120, -144},
    { -1584, 128, -632},
    { -1984, -32, -416},
    { -2096, -144, -64},
    // 6 seconds
    { -2048, 104, -232},
    { -1368, 472, -184},
    { -1088, 448, -24},
    { -888, 536, 8},
    { -800, 392, -32},
    { -792, 312, -16},
    { -864, 520, -64},
    { -1056, 1000, -344},
    { -984, 416, -144},
    { -1352, 424, -384},
    { -1280, 528, -288},
    { -1488, 304, -344},
    { -1912, 200, -256},
    { -2048, 168, -288},
    { -1808, 96, -224},
    { -1544, 112, -176},
    { -1352, 112, -96},
    { -1176, 104, -88},
    { -968, 112, -56},
    { -824, 120, 0},
    { -704, -248, 136},
    { -632, -320, 136},
    { -616, -336, -128},
    { -1104, -72, -120},
    { -1440, -32, -152},
    // 7 seconds
    { -1720, -32, -376},
    { -2040, -96, -72},
    { -2280, 152, -24},
    { -2072, 112, 88},
    { -1584, 424, 0},
    { -1384, 448, 48},
    { -1352, 480, 112},
    { -1192, 392, 104},
    { -944, 312, 64},
    { -824, 384, -40},
    { -864, 728, -104},
    { -1160, 1128, -88},
    { -1024, 544, -232},
    { -1136, 456, -456},
    { -1448, 632, -192},
    { -2032, 304, -256},
    { -1904, 472, -96},
    { -2048, 784, 168},
    { -1912, 592, 232},
    { -1720, 536, 256},
    { -1528, 416, 208},
    { -1272, 248, 248},
    { -1152, 168, 256},
    { -928, 32, 264},
    { -920, 248, 112},
    // 8 seconds
    { -952, -128, -192},
    { -968, -96, -496},
    { -1376, 504, -128},
    { -1448, 592, -200},
    { -1888, 544, 200},
    { -2184, 608, 456},
    { -1592, 64, 2760},
    { -1832, 1512, 1080},
    { -1424, 768, -64},
    { -1456, 792, 272},
    { -1248, 504, 416},
    { -1136, 488, 552},
    { -960, 640, 728},
    { -512, 800, 624},
    { -704, 712, 432},
    { -656, 864, 264},
    { -792, 792, 480},
    { -1504, 424, 552},
    { -1680, 624, 296},
    { -1864, 584, 296},
    { -1928, 544, 280},
    { -1928, 480, 360},
    { -1848, 376, 376},
    { -1656, 304, 376},
    { -1432, 224, 368},
    // 9 seconds
    { -1200, 120, 368},
    { -1016, -64, 200},
    { -1040, -312, 112},
    { -1024, -568, 72},
    { -1176, 640, -448},
    { -1280, 480, 16},
    { -1256, 360, 136},
    { -1312, 488, 200},
    { -1304, 448, 320},
    { -1344, 520, 408},
    { -1408, 560, 408},
    { -1432, 640, 464},
    { -1264, 696, 400},
    { -1480, 800, 256},
    { -1408, 648, 520},
    { -976, 1312, 400},
    { -904, 1136, 416},
    { -840, 824, 408},
    { -1080, 816, 312},
    { -1376, 696, 416},
    { -1640, 544, 456},
    { -1496, 464, 432},
    { -1416, 368, 472},
    { -1408, 264, 472},
    { -1400, 248, 440},
    // 10 seconds
    { -1304, 280, 304},
    { -1232, 144, 424},
    { -1184, 88, 304},
    { -1040, -136, 152},
    { -1016, -344, 112},
    { -1160, 120, -328},
    { -1168, 360, -312},
    { -1312, 152, 0},
    { -1512, 56, 144},
    { -1640, 272, 184},
    { -1584, 400, 160},
    { -1416, 424, 264},
    { -1304, 568, 120},
    { -1288, 504, 144},
    { -1240, 432, 192},
    { -1208, 608, 128},
    { -1168, 896, 72},
    { -1000, 640, 136},
    { -1184, 760, 152},
    { -936, 648, 80},
    { -984, 616, 80},
    { -1256, 528, 232},
    { -1600, 480, 312},
    { -1584, 368, 344},
    { -1432, 280, 336},
    // 11 seconds
    { -1352, 208, 368},
    { -1352, 264, 288},
    { -1216, 208, 376},
    { -1152, 152, 392},
    { -1200, 200, 336},
    { -952, 176, 192},
    { -1016, 80, 120},
    { -1008, 128, -80},
    { -928, 280, -184},
    { -1032, 296, -128},
    { -1168, 312, 24},
    { -1288, 320, 112},
    { -1288, 336, 136},
    { -1272, 344, 288},
    { -1344, 400, 224},
    { -1352, 544, 184},
    { -1280, 664, 120},
    { -1344, 568, 88},
    { -1328, 608, 120},
    { -1328, 752, 136},
    { -1024, 928, -80},
    { -808, 560, -64},
    { -1048, 520, 72},
    { -1272, 504, 128},
    { -1424, 408, 208},
    // 12 seconds
    { -1320, 272, 264},
    { -1224, 248, 280},
    { -1208, 192, 304},
    { -1192, 168, 288},
    { -1144, 240, 240},
    { -1152, 200, 296},
    { -1272, 96, 400},
    { -1248, 64, 112},
    { -1216, 80, -16},
    { -1040, 120, -296},
    { -1000, 56, -208},
    { -1328, 16, -96},
    { -1448, -72, -16},
    { -1328, -96, 40},
    { -1192, 200, -16},
    { -1136, 192, -40},
    { -1272, 280, -64},
    { -1288, 360, -112},
    { -1288, 376, -216},
    { -1304, 1016, -328},
    { -1080, 400, -280},
    { -1440, 776, -280},
    { -1216, 736, -96},
    { -1320, 624, -40},
    { -1424, 496, 48},
    // 13 seconds
    { -1696, 688, 184},
    { -1696, 568, 312},
    { -1552, 528, 432},
    { -1456, 528, 336},
    { -1272, 504, 376},
    { -1032, 336, 408},
    { -784, 248, 336},
    { -632, 360, 240},
    { -432, 384, 208},
    { -160, 528, 64},
    { 48, 584, 216},
    { 192, 1456, 16},
    { 256, 1168, 320},
    { 64, 1224, 208},
    { 48, 936, 240},
    { 128, 704, 344},
    { 128, 880, 280},
    { 336, 288, 24},
    { 528, 224, -48},
    { 432, 344, 192},
    { 368, 600, 288},
    { 376, 648, 304},
    { 344, 768, 352},
    { 328, 832, 432},
    { 472, 960, 440},
    // 14 seconds
    { 400, 1056, 552},
    { 416, 1048, 520},
    { 376, 840, 600},
    { 296, 800, 592},
    { 208, 736, 488},
    { 208, 560, 288},
    { 216, 472, 120},
    { 168, 376, 96},
    { 96, 296, 64},
    { 24, 224, 32},
    { -88, 152, 104},
    { -392, 232, -72},
    { -888, 216, -280},
    { -2720, 800, 216},
    { -3136, 912, 0},
    { -2592, 584, 672},
    { -928, 1240, -152},
    { -1400, 336, -32},
    { -1416, 304, 320},
    { -984, 96, 152},
    { -720, 152, 168},
    { -688, 216, 120},
    { -720, 336, 104},
    { -760, 368, 88},
    { -848, 368, 152},
    // 15 seconds
    { -1096, 568, 192},
    { -1064, 624, 112},
    { -1480, 496, 8},
    { -1360, 608, -56},
    { -1608, 488, -152},
    { -1768, 408, -176},
    { -1928, 416, -64},
    { -1664, 208, 48},
    { -1448, 112, 104},
    { -1288, 112, 120},
    { -1128, 104, 120},
    { -968, 88, 128},
    { -912, 48, 144},
    { -784, -296, 224},
    { -624, -136, 8},
    { -912, -32, -40},
    { -1152, 264, -128},
    { -1336, 320, -304},
    { -1616, 208, -152},
    { -1776, -224, 136},
    { -1776, 192, 0},
    { -1672, 768, -56},
    { -1432, 720, -136},
    { -1280, 448, -96},
    { -1288, 328, 0},
    // 16 seconds
    { -1144, 392, 40},
    { -1168, 440, 128},
    { -1128, 768, 192},
    { -1216, 496, 200},
    { -984, 560, 32},
    { -760, 488, -88},
    { -1136, 552, 40},
    { -1560, 408, 200},
    { -1648, 344, 104},
    { -1480, 200, 120},
    { -1408, 232, 136},
    { -1400, 184, 144},
    { -1360, 176, 128},
    { -1248, 112, 144},
    { -1216, 168, 184},
    { -1272, 120, 176},
    { -1024, 0, 48},
    { -1184, -152, -96},
    { -1208, 72, -240},
    { -1136, 112, -336},
    { -1232, 24, -328},
    { -1400, 8, -80},
    { -1448, 168, 8},
    { -1368, 304, 72},
    { -1224, 456, 216},
    // 17 seconds
    { -1296, 464, 80},
    { -1368, 448, 80},
    { -1184, 408, 128},
    { -1200, 432, 192},
    { -1168, 672, 224},
    { -1080, 456, 72},
    { -1176, 584, 104},
    { -944, 512, 16},
    { -1168, 528, 80},
    { -1320, 472, 192},
    { -1432, 376, 272},
    { -1352, 256, 224},
    { -1264, 240, 240},
    { -1288, 216, 264},
    { -1376, 256, 248},
    { -1272, 192, 224},
    { -1176, 200, 224},
    { -1256, 128, 144},
    { -1088, -160, 96},
    { -1032, -296, -32},
    { -1272, 200, -304},
    { -1232, 296, -288},
    { -1288, 80, -48},
    { -1440, -112, 184},
    { -1384, 176, 112},
    // 18 seconds
    { -1280, 376, 144},
    { -1256, 496, 344},
    { -1152, 408, 240},
    { -1152, 448, 192},
    { -1104, 464, 200},
    { -1080, 592, 184},
    { -1104, 848, 224},
    { -992, 752, 152},
    { -1120, 592, 16},
    { -1232, 416, 32},
    { -1312, 440, 64},
    { -1368, 504, -32},
    { -1488, 504, 80},
    { -1520, 288, 136},
    { -1352, 216, 224},
    { -1424, 256, 224},
    { -1304, 264, 184},
    { -1136, 192, 160},
    { -944, 208, 104},
    { -944, 128, 144},
    { -904, 168, 64},
    { -432, -520, -312},
    { -1000, 96, -344},
    { -1304, 280, -272},
    { -1560, 272, -384},
    // 19 seconds
    { -1608, 272, -344},
    { -1480, 104, 32},
    { -1512, 480, 8},
    { -1160, -136, 24},
    { -1360, 240, -504},
    { -1000, -184, -408},
    { -1064, 240, 64},
    { -960, 336, 200},
    { -1000, 328, 336},
    { -1104, 696, 280},
    { -872, 720, 392},
    { -1248, 440, 368},
    { -1224, 496, 368},
    { -960, 624, 176},
    { -1160, 552, 240},
    { -1528, 368, 408},
    { -1744, 352, 432},
    { -1648, 272, 472},
    { -1512, 112, 432},
    { -1384, -8, 392},
    { -1216, -48, 328},
    { -1040, 16, 256},
    { -992, -40, 216},
    { -792, -456, 152},
    { -648, -288, -232},
    // 20 seconds
    { -1344, 144, 240},
    { -1392, 120, -16},
    { -1400, 408, -96},
    { -1288, -48, 104},
    { -1472, -224, 96},
    { -1520, 64, 104},
    { -1376, 248, 192},
    { -1328, 312, 208},
    { -1208, 376, 256},
    { -1168, 336, 264},
    { -1128, 352, 232},
    { -992, 360, 208},
    { -1080, 424, 288},
    { -1080, 848, 336},
    { -1024, 464, 232},
    { -1240, 368, 256},
    { -1168, 376, 216},
    { -1176, 416, 160},
    { -1280, 376, 184},
    { -1560, 320, 192},
    { -1568, 336, 0},
    { -1400, 72, 192},
    { -1480, 224, 432},
    { -1520, 280, 392},
    { -1384, 200, 312},
    // 21 seconds
    { -1184, 96, 320},
    { -1072, -8, 360},
    { -992, -96, 320},
    { -832, -280, 208},
    { -784, -328, 216},
    { -704, 320, 8},
    { -1008, 280, 176},
    { -1424, 424, 144},
    { -1480, 488, 64},
    { -1336, 512, 24},
    { -1256, 496, -64},
    { -1224, 400, -184},
    { -1272, 480, -424},
    { -1136, 168, -280},
    { -1208, 832, -200},
    { -1112, 888, 8},
    { -1048, 632, 168},
    { -1064, 400, 224},
    { -1248, 536, 456},
    { -1064, 664, 552},
    { -1288, 512, 728},
    { -1656, 72, 952},
    { -1528, 80, 504},
    { -1208, 184, 216},
    { -1280, 328, 224},
    // 22 seconds
    { -1288, 264, 320},
    { -1264, 272, 368},
    { -1112, 112, 328},
    { -984, 184, 120},
    { -928, 136, 80},
    { -968, -24, 112},
    { -1040, 16, 88},
    { -1064, 144, -40},
    { -992, 304, -152},
    { -992, 312, -104},
    { -1288, 304, -64},
    { -1632, 320, 32},
    { -1688, 320, 88},
    { -1400, 416, 144},
    { -1088, 592, 64},
    { -1128, 240, 144},
    { -1232, 328, 120},
    { -1016, 408, 48},
    { -840, 488, 40},
    { -960, 728, 104},
    { -1056, 512, 176},
    { -1352, 296, 224},
    { -1472, 520, 200},
    { -1344, 552, 200},
    { -1120, 464, 208},
    // 23 seconds
    { -1272, 376, 288},
    { -1600, 264, 448},
    { -1560, 152, 488},
    { -1392, 16, 440},
    { -1320, 88, 448},
    { -1224, 120, 296},
    { -1104, 120, 312},
    { -992, 104, 304},
    { -1056, 200, 320},
    { -1112, 72, 144},
    { -1160, 48, -16},
    { -1016, 160, -312},
    { -880, 104, -184},
    { -960, 48, -440},
    { -1272, 64, -472},
    { -1488, 104, -480},
    { -1496, 256, -472},
    { -1376, 344, -344},
    { -1240, 264, -112},
    { -1120, 544, -64},
    { -1016, 400, -16},
    { -936, 368, 32},
    { -952, 536, -8},
    { -1064, 696, 104},
    { -1208, 808, 120},
    // 24 seconds
    { -1240, 608, 160},
    { -1128, 528, 72},
    { -1280, 504, 64},
    { -1656, 432, 256},
    { -1680, 336, 288},
    { -1480, 248, 264},
    { -1296, 272, 272},
    { -1264, 272, 432},
    { -1296, 240, 424},
    { -1096, 88, 296},
    { -1024, 288, 280},
    { -1016, -240, 368},
    { -888, -280, -96},
    { -1088, -88, -168},
    { -1224, -64, 72},
    { -1360, 440, -120},
    { -1376, 472, -88},
    { -1504, 304, 16},
    { -1624, 328, 80},
    { -1472, 480, 64},
    { -1312, 512, 96},
    { -1184, 480, 176},
    { -1160, 472, 176},
    { -1152, 456, 136},
    { -960, 488, 264},
    // 25 seconds
    { -840, 704, 328},
    { -848, 696, 304},
    { -1064, 464, 416},
    { -1192, 696, 288},
    { -1072, 592, 64},
    { -1424, 616, 56},
    { -1696, 536, 88},
    { -1720, 512, 152},
    { -1560, 392, 248},
    { -1424, 288, 280},
    { -1384, 184, 272},
    { -1280, 176, 200},
    { -1072, 104, 152},
    { -1088, 56, 128},
    { -1072, -264, 72},
    { -824, -224, 8},
    { -1056, -80, -96},
    { -1360, 408, -288},
    { -1352, 352, -224},
    { -1504, -24, 24},
    { -1704, 88, -112},
    { -1640, 432, -216},
    { -1440, 408, -216},
    { -1288, 344, 56},
    { -1200, 264, 168},
    // 26 seconds
    { -1216, 224, 248},
    { -1192, 312, 296},
    { -1024, 376, 232},
    { -1024, 512, 336},
    { -1080, 640, 328},
    { -1192, 544, 224},
    { -984, 608, 192},
    { -1080, 456, 120},
    { -1360, 424, 200},
    { -1712, 480, 232},
    { -1616, 288, 280},
    { -1544, 216, 280},
    { -1560, 208, 320},
    { -1592, 240, 264},
    { -1424, 128, 216},
    { -1176, 64, 208},
    { -1248, -216, 264},
    { -1072, -424, 176},
    { -960, -288, 64},
    { -1152, -256, -136},
    { -1368, 128, -288},
    { -1496, 72, -152},
    { -1520, 208, -40},
    { -1488, 312, -120},
    { -1496, 320, 8},
    // 27 seconds
    { -1512, 416, 160},
    { -1344, 456, 144},
    { -1288, 520, 152},
    { -1176, 488, 104},
    { -1136, 576, 192},
    { -1000, 680, 400},
    { -1048, 808, 280},
    { -1096, 680, 216},
    { -1016, 576, 136},
    { -1184, 624, 184},
    { -1312, 584, 256},
    { -1512, 496, 336},
    { -1512, 344, 344},
    { -1552, 280, 328},
    { -1624, 264, 360},
    { -1560, 200, 328},
    { -1304, 144, 296},
    { -1080, 104, 264},
    { -1072, 72, 256},
    { -984, -48, 256},
    { -992, -200, 88},
    { -1088, 64, -16},
    { -1112, 368, -336},
    { -1256, 312, -248},
    { -1480, 48, -40},
    // 28 seconds
    { -1728, -24, 160},
    { -1696, 616, 144},
    { -1528, 880, 48},
    { -1104, 832, 88},
    { -1040, 232, 32},
    { -1136, 320, 120},
    { -1096, 240, 96},
    { -1296, 616, 304},
    { -952, 768, 384},
    { -1120, 856, 288},
    { -984, 584, 232},
    { -1040, 544, 184},
    { -1280, 424, 160},
    { -1600, 400, 280},
    { -1600, 320, 264},
    { -1384, 232, 240},
    { -1344, 240, 264},
    { -1368, 376, 392},
    { -1288, 256, 312},
    { -1112, 200, 296},
    { -1168, 112, 256},
    { -1096, -296, 40},
    { -1056, -408, -40},
    { -1232, -104, -152},
    { -1464, 352, -240},
    // 29 seconds
    { -1752, 456, -48},
    { -1744, 176, 272},
    { -1744, 264, 344},
    { -1504, 408, 424},
    { -1160, 376, 400},
    { -1152, 512, 320},
    { -1248, 456, 336},
    { -1112, 488, 312},
    { -920, 512, 280},
    { -928, 640, 368},
    { -768, 568, 520},
    { -1136, 976, 320},
    { -936, 1008, -16},
    { -1208, 1040, -40},
    { -1568, 656, 40},
    { -1880, 648, 104},
    { -2008, 480, 328},
    { -1792, 360, 360},
    { -1608, 344, 384},
    { -1504, 304, 384},
    { -1304, 264, 352},
    { -1096, 208, 320},
    { -984, 152, 312},
    { -912, -232, 288},
    { -672, -624, -320},
    // 30 seconds
    { -704, -392, -344},
    { -1296, -72, 56},
    { -1696, 632, -296},
    { -1840, 704, -64},
    { -1968, 568, 176},
    { -1896, 656, 288},
    { -1568, 688, 288},
    { -1400, 888, 1064},
    { -1464, 624, 120},
    { -1272, 336, 376},
    { -1160, 328, 424},
    { -984, 304, 504},
    { -920, 424, 728},
    { -880, 456, 424},
    { -944, 512, 760},
    { -968, 496, 648},
    { -984, 520, 432},
    { -1152, 560, 456},
    { -1504, 528, 488},
    { -1808, 520, 512},
    { -1808, 392, 576},
    { -1744, 248, 584},
    { -1680, 104, 464},
    { -1512, 112, 360},
    { -1280, 120, 312},
    // 31 seconds
    { -1192, 120, 240},
    { -1048, 104, 144},
    { -776, 56, 64},
    { -776, 384, -120},
    { -560, 1088, -504},
    { -408, 1592, -640},
    { -544, 1144, -576},
    { -480, 784, -640},
    { -288, 584, -696},
    { -128, 392, -584},
    { -88, 288, -584},
    { -72, 208, -536},
    { -32, 200, -584},
    { -8, 232, -760},
    { 0, 152, -816},
    { -48, 160, -992},
    { -16, 16, -1040},
    { 32, -64, -1136},
    { 176, -40, -1096},
    { 296, -80, -1032},
    { 296, -8, -944},
    { 240, -32, -984},
    { 64, -32, -976},
    { -56, -112, -872},
    { -64, -192, -800},
    // 32 seconds
    { -56, -200, -800},
    { -56, -272, -848},
    { -104, -296, -808},
    { -56, -368, -920},
    { -40, -360, -1088},
    { -72, -424, -1128},
    { -152, -408, -1216},
    { -264, -288, -1280},
    { -328, -168, -1224},
    { -384, -240, -1008},
    { -224, -216, -840},
    { -80, -248, -760},
    { -32, -312, -696},
    { -16, -336, -680},
    { -8, -408, -664},
    { -24, -360, -744},
    { -40, -400, -736},
    { -32, -488, -808},
    { -144, -296, -1016},
    { -144, -376, -1312},
    { -224, -312, -1416},
    { -128, -344, -1288},
    { -24, -288, -1224},
    { -16, -232, -1096},
    { -128, -144, -1032},
    // 33 seconds
    { -216, -120, -896},
    { -224, -216, -704},
    { -208, -248, -592},
    { -184, -240, -504},
    { -208, -360, -416},
    { -216, -352, -384},
    { -296, -208, -264},
    { -376, -192, -128},
    { -672, 176, -56},
    { -1168, 816, -376},
    { -1688, 808, -320},
    { -1736, 1112, -664},
    { -1680, 488, -400},
    { -1656, 584, -496},
    { -1336, 488, -688},
    { -968, 728, -1112},
    { -1016, 288, -976},
    { -872, 448, -1016},
    { -680, 544, -856},
    { -752, 632, -432},
    { -736, 776, 0},
    { -688, 1016, 448},
    { -880, 1376, 448},
    { -488, 1104, 352},
    { -472, 816, 456},
    // 34 seconds
    { -368, 872, 416},
    { -232, 808, 376},
    { -136, 736, 376},
    { -48, 704, 208},
    { 0, 536, 168},
    { 40, 400, 120},
    { 24, 352, 32},
    { 8, 232, 0},
    { -80, 176, 0},
    { -264, 160, 24},
    { -616, 280, 168},
    { -1408, 1224, 280},
    { -1360, 736, 296},
    { -1920, 896, 200},
    { -1928, 768, 304},
    { -1680, 392, 536},
    { -1392, 656, 56},
    { -984, 328, 24},
    { -928, 280, 152},
    { -928, 216, 256},
    { -904, 264, 248},
    { -752, 312, 144},
    { -696, 368, 168},
    { -912, 496, 104},
    { -984, 472, 272},
    // 35 seconds
    { -1384, 576, 264},
    { -1472, 568, 232},
    { -1128, 712, -96},
    { -1160, 664, -96},
    { -1536, 520, 64},
    { -1720, 448, 208},
    { -1472, 288, 304},
    { -1264, 248, 248},
    { -1168, 232, 272},
    { -1016, 176, 184},
    { -880, 128, 176},
    { -792, 112, 216},
    { -856, -136, 224},
    { -824, -288, -184},
    { -768, -184, -160},
    { -1264, 256, -32},
    { -1680, 688, -144},
    { -1888, 640, -8},
    { -1744, 224, 400},
    { -1328, 584, 224},
    { -1272, 720, 160},
    { -1152, 336, 112},
    { -1088, 256, 168},
    { -1024, 208, 216},
    { -944, 264, 216},
    // 36 seconds
    { -872, 288, 224},
    { -848, 320, 216},
    { -1136, 552, 456},
    { -984, 464, 384},
    { -1240, 296, 288},
    { -1072, 528, 152},
    { -1064, 480, 144},
    { -1208, 440, 136},
    { -1472, 392, 208},
    { -1616, 304, 280},
    { -1504, 232, 328},
    { -1400, 120, 320},
    { -1344, 104, 288},
    { -1232, 112, 248},
    { -1064, 88, 224},
    { -1024, 72, 224},
    { -1056, -232, 168},
    { -984, -424, 56},
    { -1040, 0, -32},
    { -1112, 184, -120},
    { -1488, 472, -208},
    { -1656, 328, 80},
    { -1552, -56, 336},
    { -1376, 224, 416},
    { -1144, 408, -48},
    // 37 seconds
    { -792, 480, 120},
    { -1168, 240, 232},
    { -1152, 256, 192},
    { -1024, 304, 312},
    { -1056, 352, 384},
    { -944, 464, 472},
    { -1160, 288, 320},
    { -1336, 504, 392},
    { -1128, 504, 248},
    { -1000, 480, 208},
    { -1224, 400, 368},
    { -1472, 224, 368},
    { -1416, 160, 344},
    { -1472, 112, 352},
    { -1448, 8, 360},
    { -1424, -8, 304},
    { -1256, 0, 272},
    { -1112, 0, 272},
    { -1192, -72, 304},
    { -1024, -392, 240},
    { -1056, -424, 360},
    { -1112, -8, 256},
    { -888, 720, -352},
    { -1064, 360, -40},
    { -1552, 112, 8},
    // 38 seconds
    { -1664, 672, -168},
    { -1352, 688, -16},
    { -1288, 544, 936},
    { -960, 960, 40},
    { -992, 464, -800},
    { -1136, -448, 432},
    { -960, 280, 344},
    { -864, 232, 344},
    { -944, 456, 464},
    { -1104, 448, 456},
    { -1384, 248, 496},
    { -1008, 248, 320},
    { -1048, 296, 288},
    { -1384, 240, 384},
    { -1632, 232, 376},
    { -1544, 192, 344},
    { -1472, 8, 408},
    { -1384, -24, 432},
    { -1336, -40, 400},
    { -1208, -8, 328},
    { -1152, 32, 328},
    { -1368, -328, 248},
    { -1168, -824, -256},
    { -1184, -640, 248},
    { -1056, 352, -112},
    // 39 seconds
    { -1088, 680, 48},
    { -1648, 392, 328},
    { -1864, 368, 440},
    { -1712, 240, 584},
    { -1456, 552, 560},
    { -1064, 480, 216},
    { -1112, 240, 232},
    { -1112, 336, 368},
    { -920, 360, 392},
    { -728, 376, 328},
    { -736, 512, 432},
    { -744, 528, 472},
    { -1248, 632, 448},
    { -1264, 584, 376},
    { -1512, 592, 400},
    { -1968, 536, 488},
    { -1920, 504, 608},
    { -1752, 256, 456},
    { -1632, 200, 400},
    { -1640, 176, 376},
    { -1544, 120, 384},
    { -1256, 16, 360},
    { -1056, 8, 320},
    { -968, -24, 304},
    { -800, -80, 304},
    // 40 seconds
    { -872, -152, 240},
    { -904, 80, 216},
    { -440, 648, -352},
    { -704, 448, -56},
    { -1032, 520, -80},
    { -1296, 760, -88},
    { -1608, 616, 184},
    { -1576, 672, 136},
    { -1456, 464, 168},
    { -1272, 616, 160},
    { -1120, 448, -16},
    { -1048, 632, -64},
    { -960, 816, -16},
    { -1160, 1040, 136},
    { -1560, 648, 200},
    { -1336, 408, 264},
    { -1112, 432, 88},
    { -1232, 400, 192},
    { -1480, 336, 264},
    { -1616, 280, 448},
    { -1528, 144, 488},
    { -1448, 72, 488},
    { -1408, -32, 464},
    { -1240, -96, 408},
    { -992, -96, 328},
    // 41 seconds
    { -896, 8, 344},
    { -1000, -256, 240},
    { -704, -536, 24},
    { -1064, 424, -408},
    { -1392, 176, 168},
    { -1488, 880, -104},
    { -1280, 560, 56},
    { -1320, 552, 120},
    { -1480, 576, 160},
    { -1336, 472, 128},
    { -1112, 504, 136},
    { -1104, 440, 216},
    { -1088, 440, 160},
    { -1064, 352, 144},
    { -864, 352, 104},
    { -800, 616, 208},
    { -928, 536, 200},
    { -1368, 392, 288},
    { -1344, 504, 216},
    { -1168, 432, 256},
    { -1344, 392, 96},
    { -1592, 168, 216},
    { -1864, -56, 264},
    { -1768, -8, 296},
    { -1512, -16, 296},
    // 42 seconds
    { -1304, 32, 280},
    { -1120, 56, 256},
    { -984, 56, 208},
    { -1008, 24, 192},
    { -1152, 32, -120},
    { -776, -584, 24},
    { -1016, 8, -104},
    { -1120, 264, -88},
    { -1128, 312, -88},
    { -1296, 424, -72},
    { -1504, 360, 224},
    { -1560, 312, 280},
    { -1400, 608, 128},
    { -1160, 472, -8},
    { -1176, 360, 120},
    { -1080, 352, 176},
    { -1024, 672, 152},
    { -920, 1096, 432},
    { -1072, 680, 344},
    { -1288, 472, 472},
    { -1344, 608, 352},
    { -1184, 440, 304},
    { -1344, 256, 304},
    { -1584, 104, 384},
    { -1728, 72, 328},
    // 43 seconds
    { -1416, 128, 304},
    { -1104, 72, 264},
    { -960, 136, 208},
    { -928, 120, 216},
    { -904, 40, 168},
    { -984, -96, 104},
    { -936, -512, 24},
    { -960, -136, -64},
    { -1256, 296, -120},
    { -1528, 416, -104},
    { -1496, 440, -24},
    { -1488, -24, 216},
    { -1504, 16, 312},
    { -1312, 320, 112},
    { -1160, 432, 184},
    { -1032, 312, 248},
    { -1048, 256, 192},
    { -1064, 320, 176},
    { -1048, 416, 168},
    { -1224, 440, 352},
    { -1096, 936, 432},
    { -1248, 56, 296},
    { -1256, 472, 344},
    { -1072, 552, 232},
    { -1168, 536, 192},
    // 44 seconds
    { -1408, 368, 272},
    { -1560, 256, 336},
    { -1416, 184, 328},
    { -1328, 80, 320},
    { -1296, 24, 304},
    { -1232, 40, 272},
    { -1096, 40, 248},
    { -1112, 16, 224},
    { -1128, -200, 120},
    { -960, -288, 8},
    { -1112, 40, 24},
    { -1192, 432, -104},
    { -1320, 392, -96},
    { -1472, 160, 80},
    { -1488, 8, 200},
    { -1368, 280, 184},
    { -1064, -8, -168},
    { -1128, 328, 216},
    { -1144, 392, 192},
    { -1120, 312, 208},
    { -1056, 304, 280},
    { -1152, 488, 360},
    { -1168, 624, 440},
    { -1192, 400, 408},
    { -1200, 336, 360},
    // 45 seconds
    { -984, 384, 200},
    { -984, 400, 192},
    { -1248, 320, 288},
    { -1424, 232, 280},
    { -1328, 208, 296},
    { -1224, 120, 296},
    { -1200, 64, 280},
    { -1208, 104, 288},
    { -1328, 88, 248},
    { -1408, 24, 272},
    { -1272, -48, 224},
    { -1280, -248, 144},
    { -1232, -48, 16},
    { -1048, 208, -120},
    { -992, 256, -240},
    { -1072, 168, -40},
    { -1184, 160, 112},
    { -1224, 320, 80},
    { -1184, 376, 168},
    { -1168, 280, 200},
    { -1232, 392, 208},
    { -1176, 528, 176},
    { -984, 632, 176},
    { -1048, 584, 144},
    { -1080, 616, 80},
    // 46 seconds
    { -1272, 744, 192},
    { -1192, 792, 128},
    { -1184, 592, 152},
    { -1296, 504, 104},
    { -1472, 376, 200},
    { -1656, 280, 400},
    { -1448, 400, 528},
    { -1384, 288, 472},
    { -1520, 296, 496},
    { -1272, 112, 432},
    { -1112, 40, 536},
    { -1008, -248, 216},
    { -1000, 24, 160},
    { -760, 24, -96},
    { -896, 56, -88},
    { -1032, 256, 0},
    { -1136, 544, -80},
    { -1120, 560, -24},
    { -1224, 536, 8},
    { -1448, 360, 200},
    { -1376, 472, 208},
    { -1336, 504, 240},
    { -1280, 528, 296},
    { -1296, 624, 320},
    { -1240, 568, 272},
    // 47 seconds
    { -1000, 640, 184},
    { -880, 360, 528},
    { -784, 856, 528},
    { -992, 664, 504},
    { -1224, 528, 552},
    { -1304, 472, 424},
    { -1248, 392, 464},
    { -1440, 240, 544},
    { -1664, 200, 544},
    { -1672, 88, 496},
    { -1576, -24, 464},
    { -1448, -120, 416},
    { -1304, -112, 328},
    { -1104, -56, 280},
    { -904, -16, 248},
    { -856, -16, 248},
    { -920, -40, 256},
    { -976, 0, 248},
    { -904, 144, 96},
    { -760, 312, -56},
    { -768, 208, -8},
    { -1320, 512, -24},
    { -1584, 528, 0},
    { -1608, 440, 88},
    { -1496, 456, 168},
    // 48 seconds
    { -1232, 664, 264},
    { -1112, 488, -16},
    { -1104, 392, 64},
    { -936, 240, 264},
    { -936, 432, 312},
    { -976, 640, 464},
    { -1264, 600, 376},
    { -1208, 368, 288},
    { -1048, 448, 360},
    { -1280, 704, 544},
    { -1520, 352, 376},
    { -1456, 408, 400},
    { -1392, 368, 360},
    { -1352, 272, 408},
    { -1344, 208, 424},
    { -1296, 152, 376},
    { -1072, 48, 296},
    { -992, -24, 264},
    { -1000, -56, 296},
    { -928, -72, 304},
    { -1024, 64, 192},
    { -984, 144, 120},
    { -896, 528, -136},
    { -872, 440, -192},
    { -1024, 272, 24},
    // 49 seconds
    { -1224, 256, 96},
    { -1312, 480, 16},
    { -1384, 656, -72},
    { -1360, 656, 24},
    { -1224, 600, 160},
    { -968, 656, 136},
    { -920, 432, 104},
    { -1032, 584, 104},
    { -1048, 528, 128},
    { -1280, 664, 240},
    { -1152, 520, 272},
    { -1000, 424, 264},
    { -1208, 440, 232},
    { -1472, 408, 272},
    { -1576, 344, 344},
    { -1416, 192, 392},
    { -1320, 72, 384},
    { -1272, 8, 336},
    { -1208, 16, 312},
    { -1104, 24, 288},
    { -1088, 24, 296},
    { -1104, -16, 312},
    { -1032, -224, 208},
    { -1120, -512, -32},
    { -1408, 128, 96},
    // 50 seconds
    { -1160, 672, -200},
    { -968, 528, -32},
    { -1176, 256, 88},
    { -1400, 344, 56},
    { -1344, 208, 104},
    { -1288, 376, 64},
    { -1232, 432, 16},
    { -1120, 416, 40},
    { -1064, 264, 56},
    { -968, 336, 80},
    { -904, 456, 56},
    { -1056, 648, 96},
    { -1256, 704, 208},
    { -1384, 424, 264},
    { -1216, 352, 224},
    { -1064, 360, 208},
    { -1336, 576, 392},
    { -1688, 728, 544},
    { -1768, 504, 744},
    { -1544, -16, 800},
    { -1352, 96, 528},
    { -1208, 208, 496},
    { -960, 144, 472},
    { -736, 112, 408},
    { -720, 80, 440},
    // 51 seconds
    { -680, 160, 520},
    { -584, 272, 592},
    { -400, 632, 624},
    { -144, 1080, 616},
    { 8, 1128, 576},
    { -32, 1064, 560},
    { 24, 864, 512},
    { 144, 872, 384},
    { 224, 688, 352},
    { 256, 544, 328},
    { 240, 464, 312},
    { 256, 392, 296},
    { 280, 336, 224},
    { 264, 272, 272},
    { 136, 416, 512},
    { 64, 744, 1304},
    { 80, 1432, 1672},
    { 432, 1304, 824},
    { 352, 856, 1152},
    { 344, 616, 992},
    { 232, 616, 856},
    { 160, 504, 672},
    { 96, 352, 440},
    { 56, 248, 248},
    { 16, 184, 136},
    // 52 seconds
    { -8, 40, 112},
    { -32, -144, 272},
    { -272, -248, 424},
    { -400, 752, -96},
    { -984, 424, 928},
    { -1680, 1176, 696},
    { -1312, 568, 1520},
    { -1440, 888, 464},
    { -1408, 528, 528},
    { -1328, 304, 456},
    { -1144, 280, 264},
    { -1080, 184, 280},
    { -1024, 144, 312},
    { -1008, 160, 304},
    { -888, 192, 280},
    { -856, 232, 248},
    { -968, 288, 232},
    { -1040, 112, 272},
    { -1520, 120, 72},
    { -1528, 8, 0},
    { -1112, -328, -72},
    { -1024, -320, -128},
    { -976, -392, -40},
    { -648, -184, -416},
    { -1128, -2096, 488},
    // 53 seconds
    { -960, -528, 240},
    { -1240, -152, 264},
    { -1024, 384, 200},
    { -904, 64, 248},
    { -800, 104, 288},
    { -968, 184, 288},
    { -1168, 112, 368},
    { -1592, -40, 424},
    { -1352, -504, 344},
    { -880, -552, 104},
    { -624, -560, 304},
    { -792, -608, 488},
    { -888, -856, 344},
    { -1024, -304, 112},
    { -1000, -32, 64},
    { -872, 72, 104},
    { -832, -16, 88},
    { -792, -120, 144},
    { -752, -96, 72},
    { -1032, 64, 24},
    { -1232, -16, 184},
    { -1608, -144, 168},
    { -1568, -176, 16},
    { -1216, 296, 136},
    { -1184, 160, 232},
    // 54 seconds
    { -1288, 176, 680},
    { -1112, -8, 392},
    { -1056, 160, 224},
    { -968, 264, 216},
    { -856, 120, 248},
    { -880, 16, 248},
    { -888, -8, 224},
    { -864, 32, 216},
    { -968, 96, 176},
    { -1032, -40, 24},
    { -1120, -128, 56},
    { -1472, 240, 264},
    { -1256, 392, -40},
    { -1160, 392, -64},
    { -1200, -40, 96},
    { -1320, 48, 272},
    { -1192, 352, 200},
    { -952, 496, 96},
    { -832, 336, 192},
    { -776, 240, 216},
    { -840, 256, 168},
    { -744, 272, 184},
    { -944, 352, 184},
    { -1192, 344, 216},
    { -1568, 552, 272},
    // 55 seconds
    { -1400, 280, 152},
    { -1096, 384, 112},
    { -1072, 616, 104},
    { -1320, 536, 224},
    { -1432, 352, 256},
    { -1256, 200, 264},
    { -1128, 56, 312},
    { -1056, -32, 304},
    { -936, -8, 208},
    { -840, 56, 152},
    { -776, 72, 128},
    { -848, -96, 128},
    { -848, -72, 80},
    { -1112, 128, 144},
    { -1248, 328, 96},
    { -1280, 456, 0},
    { -1472, 376, 152},
    { -1464, 160, 288},
    { -1288, 240, 248},
    { -1144, 552, 64},
    { -984, 352, 144},
    { -904, 128, 208},
    { -936, 72, 208},
    { -856, 152, 168},
    { -792, 280, 184},
    // 56 seconds
    { -992, 464, 200},
    { -1200, 432, 472},
    { -1320, 704, 224},
    { -1248, 120, 216},
    { -1016, 248, 192},
    { -1240, 472, 248},
    { -1432, 352, 208},
    { -1648, 528, -192},
    { -1296, 288, 232},
    { -1112, 128, 280},
    { -1056, 168, 232},
    { -1016, 152, 224},
    { -960, 112, 224},
    { -960, 64, 240},
    { -952, 16, 256},
    { -824, 8, 240},
    { -928, 24, 240},
    { -968, 136, 200},
    { -840, 368, 32},
    { -1136, 904, -48},
    { -1328, 392, 376},
    { -1352, 680, 72},
    { -1088, 768, -24},
    { -848, 664, 136},
    { -856, 552, 104},
    // 57 seconds
    { -840, 528, 184},
    { -808, 624, 288},
    { -696, 680, 368},
    { -832, 480, 328},
    { -1048, 464, 360},
    { -1328, 464, 384},
    { -1088, 368, 424},
    { -912, 336, 304},
    { -1008, 336, 272},
    { -1248, 192, 384},
    { -1360, 112, 456},
    { -1312, -32, 472},
    { -1112, -8, 464},
    { -984, 8, 416},
    { -1016, 16, 416},
    { -1024, -24, 416},
    { -968, -32, 360},
    { -856, -24, 296},
    { -856, 96, 304},
    { -856, 192, 296},
    { -952, 344, 344},
    { -1144, 416, 432},
    { -1792, 456, 728},
    { -952, 824, 376},
    { -560, 816, 440},
    // 58 seconds
    { -672, 928, 376},
    { -688, 832, 632},
    { -696, 944, 584},
    { -464, 840, 440},
    { -384, 600, 416},
    { -368, 560, 440},
    { -280, 432, 408},
    { -240, 672, 472},
    { -168, 608, 776},
    { -168, 560, 912},
    { -88, 656, 720},
    { -48, 528, 712},
    { -8, 616, 640},
    { 80, 528, 712},
    { 160, 560, 576},
    { 224, 552, 584},
    { 264, 568, 648},
    { 256, 712, 608},
    { 264, 776, 528},
    { 288, 800, 480},
    { 264, 816, 400},
    { 384, 984, 320},
    { 168, 744, -8},
    { 80, 1224, -160},
    { 128, 912, -176},
    // 59 seconds
    { 144, 904, -320},
    { 128, 800, -408},
    { 24, 624, -416},
    { 32, 472, -528},
    { -16, 392, -608},
    { 40, 184, -488},
    { 120, 456, -392},
    { 72, 856, -24},
    { -152, 984, 168},
    { 88, 1168, 112},
    { 104, 1080, 312},
    { 176, 944, 488},
    { 216, 784, 544},
    { 152, 936, 528},
    { 16, 736, 584},
    { -160, 920, 424},
    { 152, 864, 336},
    { -96, 952, 600},
    { 80, 912, 520},
    { 136, 1056, 328},
    { 144, 912, 144},
    { 96, 888, -152},
    { -72, 768, -360},
    { -144, 616, -568},
    { -16, 400, -784},
    // 60 seconds
    // elapsed: 1 minutes
    { -344, -2160, -544},
    { 88, 496, -824},
    { -32, 512, -816},
    { -24, 344, -912},
    { 56, 136, -872},
    { 152, 152, -888},
    { 144, 160, -992},
    { 0, -224, -952},
    { -24, -56, -1088},
    { 0, -304, -992},
    { -48, -200, -952},
    { 8, -336, -960},
    { -48, -296, -1000},
    { -64, -408, -864},
    { -88, -352, -984},
    { -80, -376, -960},
    { -24, -424, -952},
    { -264, -184, -976},
    { -40, -264, -992},
    { -72, -256, -968},
    { 16, -456, -928},
    { 40, -504, -880},
    { -72, -416, -912},
    { -24, -368, -976},
    { -40, -280, -1008},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-02 15:39:33 local
AccelRawData *activity_sample_walk_100_pbl_25478_6(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25478_6
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 75
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -488, 168, -944},
    { -456, 208, -1040},
    { -320, 24, -984},
    { -400, 72, -960},
    { -376, 32, -1024},
    { -264, -16, -992},
    { -312, 144, -968},
    { -336, -80, -992},
    { -320, -16, -960},
    { -288, 288, -1000},
    { -232, -136, -928},
    { -352, 24, -920},
    { -288, -8, -968},
    { -144, -304, -936},
    { -320, 8, -1000},
    { -240, -120, -992},
    { -248, -176, -976},
    { -216, -80, -968},
    { -216, -216, -960},
    { -216, -216, -968},
    { -240, -200, -976},
    { -224, -200, -952},
    { -208, -240, -1000},
    { -208, -224, -960},
    { -280, -240, -976},
    // 1 seconds
    { -256, -272, -952},
    { -232, -272, -984},
    { -224, -248, -976},
    { -224, -280, -960},
    { -208, -232, -976},
    { -232, -272, -976},
    { -208, -280, -960},
    { -216, -288, -952},
    { -200, -312, -936},
    { -192, -336, -912},
    { -168, -416, -848},
    { -208, -416, -752},
    { -216, -448, -664},
    { -296, -472, -520},
    { -384, -360, -416},
    { -464, -216, -312},
    { -576, -184, -128},
    { -1464, -824, -176},
    { -1168, -224, -224},
    { -1400, -184, -96},
    { -1328, -232, -24},
    { -1680, 40, 104},
    { -1616, 256, 32},
    { -1624, 160, 0},
    { -1592, 168, -8},
    // 2 seconds
    { -1632, 176, -16},
    { -1528, 248, -120},
    { -1440, 264, -160},
    { -1208, 312, -352},
    { -1296, 376, -288},
    { -1264, 376, -552},
    { -1384, 448, -800},
    { -1512, 248, -664},
    { -1248, 168, -608},
    { -1472, -112, -328},
    { -1952, 200, -168},
    { -2296, 104, -136},
    { -2304, 96, -40},
    { -2040, -64, 24},
    { -1744, -24, 96},
    { -1344, -16, 88},
    { -1048, 48, 144},
    { -704, -16, 160},
    { -336, -144, 192},
    { -312, -72, 88},
    { -472, -128, 224},
    { -608, 0, -120},
    { -936, -136, -224},
    { -1328, -128, -536},
    { -1272, -96, -760},
    // 3 seconds
    { -1712, -168, -832},
    { -1920, -72, -688},
    { -1760, 104, -608},
    { -1512, 48, -568},
    { -1440, 80, -480},
    { -1272, 208, -368},
    { -1128, 248, -288},
    { -992, 232, -352},
    { -864, 248, -384},
    { -912, 232, -480},
    { -1056, 384, -528},
    { -1056, 328, -600},
    { -1312, 336, -512},
    { -1240, 304, -400},
    { -1344, 264, -336},
    { -1616, 200, -256},
    { -1848, 168, -256},
    { -1808, 96, -200},
    { -1616, 8, -152},
    { -1456, 0, -152},
    { -1320, -24, -88},
    { -1096, 48, -112},
    { -888, -8, -64},
    { -848, -176, 32},
    { -776, -312, -88},
    // 4 seconds
    { -864, -400, -24},
    { -1240, -160, -304},
    { -1384, -200, -360},
    { -1472, -152, -504},
    { -1456, -56, -488},
    { -1416, 32, -440},
    { -1280, 88, -336},
    { -1192, 144, -312},
    { -1248, 160, -272},
    { -1328, 168, -256},
    { -1272, 256, -368},
    { -1504, 208, -408},
    { -1320, 536, -824},
    { -1080, 552, -840},
    { -1224, 424, -736},
    { -1000, 328, -616},
    { -1272, 368, -568},
    { -1600, 192, -464},
    { -1856, 112, -424},
    { -1768, 72, -360},
    { -1496, 40, -296},
    { -1400, 16, -280},
    { -1400, 112, -200},
    { -1224, 128, -168},
    { -1064, 88, -120},
    // 5 seconds
    { -1064, -64, 48},
    { -872, -312, 56},
    { -912, -224, 64},
    { -1216, -152, -168},
    { -1376, -200, -280},
    { -1432, -64, -376},
    { -1408, -40, -392},
    { -1440, -40, -216},
    { -1376, 144, -328},
    { -1384, 176, -320},
    { -1424, 136, -288},
    { -1456, 232, -576},
    { -1352, 360, -600},
    { -1152, 368, -616},
    { -976, 528, -536},
    { -1136, 544, -464},
    { -1192, 704, -360},
    { -1224, 464, -216},
    { -1448, 376, -344},
    { -1776, 312, -352},
    { -1904, 200, -296},
    { -1608, 192, -248},
    { -1448, 344, -208},
    { -1432, 496, -64},
    { -1248, 520, 96},
    // 6 seconds
    { -1072, 552, 256},
    { -888, 352, 384},
    { -680, 352, 248},
    { -464, 408, 24},
    { -464, 520, -48},
    { -224, 832, -368},
    { -344, 1064, -432},
    { -600, 832, -552},
    { -296, 968, -448},
    { -96, 944, -328},
    { 208, 920, -224},
    { 248, 640, 16},
    { 304, 544, 136},
    { 336, 608, 112},
    { 400, 528, 152},
    { 392, 584, 224},
    { 344, 1000, 296},
    { 432, 1240, 488},
    { 504, 1592, 528},
    { 456, 1472, 432},
    { 528, 1072, 304},
    { 320, 784, 416},
    { 288, 624, 328},
    { 208, 504, 296},
    { 160, 408, 192},
    // 7 seconds
    { 128, 272, 96},
    { 104, 184, 96},
    { 72, 168, 128},
    { 88, 144, 224},
    { -104, 240, 280},
    { -256, 656, -40},
    { -888, 1448, 160},
    { -1008, 1856, 768},
    { -696, 2848, 312},
    { -280, 1552, 208},
    { -176, 1048, 200},
    { -128, 680, 304},
    { -176, 768, 448},
    { -128, 648, 504},
    { -48, 400, 456},
    { -24, 376, 408},
    { 0, 248, 336},
    { 8, 208, 264},
    { -40, 200, 288},
    { -344, 656, 456},
    { -1192, 1728, 624},
    { -1552, 1720, 720},
    { -1456, 1760, 560},
    { -1016, 1352, 352},
    { -1088, 1024, 376},
    // 8 seconds
    { -1160, 872, 168},
    { -952, 576, 176},
    { -760, 336, 200},
    { -648, 216, 128},
    { -520, 80, 80},
    { -400, 48, 32},
    { -424, 56, 0},
    { -576, 24, 16},
    { -800, 8, 80},
    { -944, -64, 48},
    { -2816, -520, 600},
    { -3352, 1592, 0},
    { -2216, 776, 1008},
    { -440, 800, -1168},
    { -1256, 704, -320},
    { -1336, 488, 120},
    { -1056, -8, 360},
    { -712, 144, 336},
    { -688, 136, 328},
    { -568, 304, 344},
    { -824, 368, 184},
    { -1048, 520, 240},
    { -1136, 752, 280},
    { -1408, 672, 184},
    { -1144, 696, -176},
    // 9 seconds
    { -1264, 560, -256},
    { -1496, 472, -160},
    { -1552, 440, -208},
    { -1232, 368, -112},
    { -1160, 248, -16},
    { -1152, 144, 64},
    { -1152, 104, 88},
    { -1024, 120, -16},
    { -984, 160, 48},
    { -808, -328, 168},
    { -616, -632, -32},
    { -1168, 96, -80},
    { -1824, 216, -184},
    { -1800, 472, -472},
    { -1736, -64, 0},
    { -1592, 40, 32},
    { -1264, 464, 8},
    { -952, 400, -40},
    { -896, 288, 24},
    { -936, 224, 128},
    { -896, 280, 224},
    { -800, 280, 72},
    { -840, 336, 0},
    { -1128, 376, -32},
    { -1304, 792, 192},
    // 10 seconds
    { -1384, 600, -128},
    { -1112, 752, -360},
    { -1136, 760, -376},
    { -1448, 816, 40},
    { -1704, 392, 208},
    { -1560, 288, 160},
    { -1320, 168, 144},
    { -1184, 192, 184},
    { -1088, 160, 192},
    { -1056, 184, 168},
    { -1008, 192, 160},
    { -1040, 144, 200},
    { -904, -416, 248},
    { -1048, -176, 16},
    { -1312, 136, 16},
    { -1456, 376, -288},
    { -1656, 256, -128},
    { -1560, 0, -56},
    { -1400, 160, -168},
    { -1392, 432, -136},
    { -1064, 304, 16},
    { -1088, 248, 128},
    { -1128, 280, 152},
    { -1064, 376, 32},
    { -1176, 392, 112},
    // 11 seconds
    { -1264, 712, 32},
    { -1056, 1008, -160},
    { -1240, 624, -104},
    { -992, 584, -8},
    { -1248, 496, -136},
    { -1488, 408, -8},
    { -1752, 408, 56},
    { -1576, 328, 112},
    { -1520, 264, 168},
    { -1480, 168, 144},
    { -1344, 96, 64},
    { -1128, 160, 24},
    { -1160, 184, 32},
    { -1216, -48, 160},
    { -1016, -56, -160},
    { -960, -136, 160},
    { -1104, 296, -248},
    { -1184, 176, -232},
    { -1280, -104, -64},
    { -1456, -288, 88},
    { -1544, 184, 176},
    { -1592, 440, 352},
    { -1448, 816, 96},
    { -1320, 520, 120},
    { -1296, 400, 152},
    // 12 seconds
    { -1296, 320, 280},
    { -1240, 496, 192},
    { -1176, 440, -8},
    { -1136, 1416, -248},
    { -1072, 760, -88},
    { -1184, 672, -120},
    { -1352, 704, -64},
    { -1728, 552, 136},
    { -1688, 384, 168},
    { -1648, 360, 152},
    { -1624, 320, 136},
    { -1520, 272, 152},
    { -1296, 272, 320},
    { -1128, 328, 352},
    { -1128, 384, 280},
    { -992, 104, 280},
    { -728, -528, -408},
    { -920, -592, 48},
    { -1384, 384, -280},
    { -1664, 304, -272},
    { -1680, 384, -232},
    { -1840, 480, -8},
    { -1672, 472, 176},
    { -1528, 600, 248},
    { -1448, 728, 80},
    // 13 seconds
    { -1360, 576, 208},
    { -1184, 384, 280},
    { -1064, 416, 272},
    { -1072, 560, 280},
    { -928, 608, 320},
    { -984, 808, 184},
    { -1056, 1048, 248},
    { -856, 1048, 8},
    { -1352, 608, 16},
    { -1664, 144, 64},
    { -2008, 232, 72},
    { -1920, 224, 72},
    { -1712, 272, 88},
    { -1624, 232, 104},
    { -1472, 208, 208},
    { -1176, 184, 168},
    { -1064, 256, 72},
    { -1088, 120, 248},
    { -904, -112, 264},
    { -840, -280, 80},
    { -968, -112, -152},
    { -1152, 200, -440},
    { -1288, 48, -280},
    { -1256, -256, -72},
    { -1352, -72, -120},
    // 14 seconds
    { -1368, 336, -320},
    { -1360, 416, -288},
    { -1504, 344, -392},
    { -1496, 520, -184},
    { -1352, 528, -160},
    { -1160, 616, -280},
    { -1272, 672, -312},
    { -1152, 600, -160},
    { -1248, 544, -208},
    { -1248, 616, -368},
    { -1040, 512, -352},
    { -1120, 352, -312},
    { -1360, 288, -192},
    { -1616, 264, -96},
    { -1552, 224, -32},
    { -1440, 176, 48},
    { -1320, 184, -8},
    { -1192, 176, 24},
    { -1032, 176, 8},
    { -1008, 80, -16},
    { -968, -256, 88},
    { -800, -240, -88},
    { -976, -152, -144},
    { -1344, 112, -344},
    { -1400, 296, -464},
    // 15 seconds
    { -1392, -32, -136},
    { -1560, -160, 24},
    { -1536, 224, -64},
    { -1312, 344, -96},
    { -1144, 416, 16},
    { -1064, 320, -56},
    { -1104, 280, -16},
    { -1088, 168, 40},
    { -968, 384, 176},
    { -1064, 416, 72},
    { -1000, 608, 136},
    { -1344, 528, 216},
    { -1096, 440, -32},
    { -992, 472, -144},
    { -1176, 400, -200},
    { -1408, 440, -256},
    { -1576, 328, -304},
    { -1512, 272, -296},
    { -1416, 184, -456},
    { -1600, 336, -144},
    { -1400, 96, -104},
    { -1184, 128, -80},
    { -1000, 120, -80},
    { -784, -120, 16},
    { -528, -384, 80},
    // 16 seconds
    { -632, 40, -32},
    { -1016, 72, -88},
    { -1368, 344, -280},
    { -1600, 384, -488},
    { -1512, 32, -360},
    { -1624, -328, -48},
    { -1632, 72, 224},
    { -1400, 320, 224},
    { -1312, 392, 160},
    { -1176, 336, 176},
    { -1032, 208, 216},
    { -952, 160, 296},
    { -816, 152, 360},
    { -736, 200, 328},
    { -896, 256, 200},
    { -1528, 216, 88},
    { -1176, 200, 256},
    { -840, 232, 88},
    { -1088, 176, 48},
    { -1360, 216, 96},
    { -1096, 176, -32},
    { -1016, 200, -72},
    { -1008, 192, -168},
    { -1072, 136, -224},
    { -928, 136, -720},
    // 17 seconds
    { -1040, 72, -112},
    { -864, 336, -152},
    { -904, 288, -112},
    { -1128, 256, -88},
    { -1256, 224, -64},
    { -1392, 168, 168},
    { -1384, 224, 72},
    { -1096, 296, 64},
    { -728, 304, -72},
    { -904, 24, 48},
    { -1224, -8, -64},
    { -1080, -104, -56},
    { -648, -72, -216},
    { -400, -24, -368},
    { -1344, 272, -488},
    { -880, 0, -88},
    { -768, 456, -248},
    { -696, 64, -40},
    { -1184, 280, 16},
    { -1808, 392, -80},
    { -1520, 456, 112},
    { -832, 584, -280},
    { -1080, 528, -464},
    { -1312, 344, -160},
    { -1256, 400, -192},
    // 18 seconds
    { -1096, 368, -112},
    { -888, 344, -88},
    { -856, 360, -80},
    { -704, 296, -88},
    { -536, 136, 0},
    { -544, 96, 48},
    { -656, 136, 0},
    { -896, 208, 8},
    { -1360, 168, 312},
    { -1672, 664, 144},
    { -1584, 680, -416},
    { -1240, 520, -264},
    { -1000, 616, -488},
    { -1080, 640, -336},
    { -984, 536, -168},
    { -824, 392, -72},
    { -696, 248, 48},
    { -688, 216, 128},
    { -728, 168, 184},
    { -744, 272, 128},
    { -800, 384, 112},
    { -1128, 456, 208},
    { -1056, 536, 328},
    { -1496, 432, 80},
    { -1504, 288, 152},
    // 19 seconds
    { -1136, 448, -160},
    { -1072, 232, -344},
    { -1072, 1032, -784},
    { -656, 288, 1168},
    { -1032, -360, 176},
    { -808, -112, -16},
    { -1000, 176, -16},
    { -752, 104, -80},
    { -656, 160, -64},
    { -656, 104, 104},
    { -856, 64, 176},
    { -1128, 144, 256},
    { -1448, 224, 128},
    { -1640, 424, -56},
    { -1368, 456, -536},
    { -1168, 128, -576},
    { -1136, -280, -352},
    { -1080, 24, -224},
    { -824, 272, -144},
    { -680, 288, -144},
    { -688, 288, -104},
    { -752, 280, 0},
    { -760, 216, 32},
    { -776, 288, 48},
    { -1216, 336, 16},
    // 20 seconds
    { -1272, 320, -48},
    { -1584, 512, -112},
    { -1264, 448, -168},
    { -1080, 392, -240},
    { -1312, 392, -224},
    { -1496, 280, -176},
    { -1152, -104, 8},
    { -984, 120, -48},
    { -848, 144, -80},
    { -840, 120, -16},
    { -872, 136, 40},
    { -840, 152, 0},
    { -968, 144, 72},
    { -1208, -248, 296},
    { -1120, -128, 112},
    { -1400, -24, 168},
    { -1552, 432, -336},
    { -1384, 256, -352},
    { -1320, 104, -88},
    { -1216, -112, -40},
    { -1088, 248, -136},
    { -840, 304, -144},
    { -712, 336, -192},
    { -744, 288, -120},
    { -808, 256, -96},
    // 21 seconds
    { -864, 288, -80},
    { -1136, 320, -24},
    { -1192, 592, 80},
    { -1448, 400, -40},
    { -1344, 488, -104},
    { -1240, 408, -88},
    { -1336, 328, -72},
    { -1400, 304, -40},
    { -1264, 144, -240},
    { -1016, 136, 64},
    { -968, 120, 72},
    { -976, 128, 56},
    { -968, 120, 80},
    { -904, 136, 64},
    { -1096, 16, 160},
    { -1096, -72, 192},
    { -992, -104, 120},
    { -1240, 80, 48},
    { -1296, 304, -184},
    { -1248, 344, -320},
    { -1360, 200, -112},
    { -1344, -88, 48},
    { -1200, 80, -32},
    { -976, 304, -96},
    { -904, 408, -152},
    // 22 seconds
    { -920, 368, -104},
    { -928, 264, -40},
    { -864, 280, -48},
    { -1016, 336, -16},
    { -1168, 584, 72},
    { -1312, 512, 0},
    { -1304, 336, -40},
    { -1128, 392, -40},
    { -1328, 432, -8},
    { -1440, 352, 24},
    { -1384, 296, 0},
    { -1216, 272, 40},
    { -1112, 184, 120},
    { -1088, 160, 88},
    { -1048, 136, 104},
    { -912, 104, 112},
    { -848, 96, 128},
    { -912, 24, 120},
    { -816, -32, 104},
    { -1040, 128, 64},
    { -1312, 256, -152},
    { -1328, 280, -256},
    { -1448, 96, -80},
    { -1432, 40, -80},
    { -1312, 248, -200},
    // 23 seconds
    { -1080, 240, -56},
    { -904, 392, 16},
    { -976, 320, 16},
    { -936, 184, 56},
    { -824, 208, 56},
    { -768, 232, 96},
    { -1032, 328, 88},
    { -1312, 288, 120},
    { -1504, 1264, 72},
    { -1192, 384, 224},
    { -1024, 368, 32},
    { -1216, 712, -304},
    { -1456, 880, -184},
    { -1616, 896, 48},
    { -1632, 968, -40},
    { -1496, 872, 24},
    { -1184, 520, 160},
    { -824, 256, 160},
    { -600, 176, 72},
    { -608, 160, 208},
    { -664, 0, 456},
    { -520, -120, 88},
    { -896, 24, 280},
    { -1056, 416, -224},
    { -1256, 584, -240},
    // 24 seconds
    { -1384, 184, -128},
    { -2104, 288, 248},
    { -2048, 472, 40},
    { -1624, 736, -136},
    { -1232, 824, -280},
    { -1272, 312, -96},
    { -1344, 296, 168},
    { -1160, 328, 48},
    { -920, 304, 112},
    { -1128, 560, 200},
    { -1008, 984, 96},
    { -976, 472, 128},
    { -1176, 456, 224},
    { -1024, 464, 168},
    { -1416, 400, 224},
    { -1848, 544, 200},
    { -1792, 216, 152},
    { -1608, 224, 152},
    { -1568, 344, 152},
    { -1504, 304, 128},
    { -1336, 248, 168},
    { -1128, 208, 72},
    { -992, 152, 88},
    { -952, 112, -32},
    { -688, -152, 56},
    // 25 seconds
    { -776, -168, 128},
    { -824, 152, -176},
    { -1072, 208, -88},
    { -1408, 248, 176},
    { -1560, 296, 152},
    { -1568, 264, 128},
    { -1400, 352, -16},
    { -1376, 440, 0},
    { -1304, 352, -8},
    { -1416, 264, 72},
    { -1344, 280, 40},
    { -1120, 336, 0},
    { -1176, 552, 8},
    { -1128, 672, 56},
    { -1232, 560, 40},
    { -1112, 464, 16},
    { -1008, 416, 32},
    { -1192, 456, 64},
    { -1408, 432, 120},
    { -1664, 440, 152},
    { -1632, 288, 400},
    { -1456, 160, 264},
    { -1392, 160, 232},
    { -1288, 120, 208},
    { -1128, 152, 184},
    // 26 seconds
    { -1032, 152, 152},
    { -1000, -112, 168},
    { -800, -248, 128},
    { -1000, -24, 144},
    { -1112, 224, -8},
    { -1160, 264, -136},
    { -1352, 272, -40},
    { -1440, 72, 192},
    { -1416, 128, 104},
    { -1296, 280, 72},
    { -1120, 416, 80},
    { -1168, 456, 72},
    { -1176, 320, 136},
    { -1176, 344, 80},
    { -1000, 304, 32},
    { -1136, 384, -24},
    { -1232, 528, 104},
    { -1464, 840, -112},
    { -992, 400, -144},
    { -936, 392, -136},
    { -1352, 472, -112},
    { -1720, 432, -24},
    { -1592, 240, 112},
    { -1448, 96, 192},
    { -1360, 120, 184},
    // 27 seconds
    { -1256, 136, 176},
    { -1120, 144, 160},
    { -1032, 176, 152},
    { -1032, 152, 184},
    { -952, 8, 192},
    { -1000, -224, 248},
    { -1144, 48, 88},
    { -1200, 144, -64},
    { -1240, 208, -192},
    { -1328, 128, -160},
    { -1440, -40, -8},
    { -1480, 160, -8},
    { -1416, 368, 24},
    { -1328, 576, 80},
    { -1184, 496, -32},
    { -1096, 392, 16},
    { -936, 360, 24},
    { -936, 376, 32},
    { -1080, 512, 56},
    { -1208, 552, 96},
    { -1376, 552, 96},
    { -1120, 432, 16},
    { -1096, 496, 16},
    { -1328, 488, 40},
    { -1568, 400, 40},
    // 28 seconds
    { -1568, 296, 168},
    { -1408, 40, 56},
    { -1312, 56, 88},
    { -1200, 168, -8},
    { -1040, 208, -24},
    { -920, 200, 8},
    { -968, 152, 104},
    { -952, -64, 144},
    { -904, -200, 0},
    { -1016, -192, 96},
    { -1328, 232, -136},
    { -1336, 240, -232},
    { -1504, 128, 8},
    { -1560, 8, 40},
    { -1416, 192, 64},
    { -1200, 480, 0},
    { -1112, 400, -32},
    { -1104, 312, 32},
    { -1112, 344, 24},
    { -976, 408, -24},
    { -808, 776, -64},
    { -984, 696, 136},
    { -1224, 632, 96},
    { -1256, 696, 104},
    { -1032, 616, 32},
    // 29 seconds
    { -1208, 616, 56},
    { -1416, 376, 136},
    { -1688, 792, 400},
    { -1616, 336, 216},
    { -1480, 304, 232},
    { -1280, 184, 120},
    { -1152, 232, 48},
    { -976, 136, 136},
    { -816, 240, -40},
    { -744, -8, 104},
    { -728, -184, 24},
    { -688, -32, -72},
    { -992, 120, 32},
    { -1296, 304, -88},
    { -1536, 464, -288},
    { -1792, 512, -144},
    { -1608, 424, 88},
    { -1264, 712, -160},
    { -1160, 376, -64},
    { -1136, 456, 0},
    { -920, 280, 80},
    { -808, 56, 408},
    { -712, 360, 312},
    { -856, 632, 400},
    { -672, 624, 712},
    // 30 seconds
    { -776, 624, 464},
    { -936, 856, 328},
    { -1360, 776, 440},
    { -1152, 624, 344},
    { -1072, 648, 128},
    { -1584, 448, 240},
    { -1680, 408, -40},
    { -1408, 488, 288},
    { -1240, 264, 200},
    { -1088, 320, 272},
    { -872, 328, 224},
    { -704, 320, 216},
    { -560, 344, 144},
    { -560, 296, 192},
    { -552, 184, 360},
    { -512, 432, 240},
    { -480, 880, 360},
    { -456, 1144, 488},
    { -264, 1536, 296},
    { -88, 1216, 224},
    { -40, 1136, 160},
    { -32, 936, 248},
    { 16, 928, 240},
    { 24, 840, 232},
    { 64, 696, 264},
    // 31 seconds
    { 96, 744, 184},
    { 144, 672, 176},
    { 176, 584, 176},
    { 200, 552, 88},
    { 232, 584, 120},
    { 272, 704, 120},
    { 200, 960, 232},
    { 88, 1424, 304},
    { 32, 1384, 336},
    { 32, 936, 352},
    { 48, 792, 216},
    { 16, 1032, 96},
    { -56, 1040, 144},
    { -56, 800, 136},
    { -64, 648, 80},
    { -64, 720, -80},
    { -64, 816, -104},
    { -208, 1064, -144},
    { -216, 864, -112},
    { -208, 728, -160},
    { -160, 792, -216},
    { -104, 920, -256},
    { -128, 1256, -344},
    { -104, 976, -288},
    { -40, 544, -224},
    // 32 seconds
    { -64, 832, -312},
    { -232, 1096, -400},
    { -248, 624, -240},
    { -288, 192, -192},
    { -376, 176, -248},
    { -504, 408, -264},
    { -688, 568, -272},
    { -864, 728, -280},
    { -1016, 720, -224},
    { -1224, 536, -80},
    { -1344, 544, -144},
    { -1304, 464, 104},
    { -1456, 504, 144},
    { -1264, 568, 8},
    { -904, 216, 72},
    { -904, 312, 48},
    { -1312, 400, 88},
    { -1336, 320, 208},
    { -1264, 192, 224},
    { -1192, 40, 256},
    { -1200, 40, 256},
    { -1168, 80, 232},
    { -1072, 128, 200},
    { -936, 152, 168},
    { -864, 128, 176},
    // 33 seconds
    { -960, 88, 184},
    { -1080, 32, 312},
    { -1320, 176, 288},
    { -1104, 592, 416},
    { -840, 1328, 136},
    { -856, 1208, 168},
    { -792, 1072, 256},
    { -680, 1128, 128},
    { -408, 968, 80},
    { -248, 712, 88},
    { -192, 648, -8},
    { -128, 528, 176},
    { -16, 528, 72},
    { 48, 576, 120},
    { 88, 720, 256},
    { 168, 960, 240},
    { 272, 1240, 392},
    { 368, 1264, 312},
    { 400, 1008, 216},
    { 384, 720, 224},
    { 416, 616, 360},
    { 416, 504, 392},
    { 264, 616, 240},
    { 256, 448, 168},
    { 200, 280, 192},
    // 34 seconds
    { 176, 152, 184},
    { 160, 200, 232},
    { -96, 456, 200},
    { -56, 544, 224},
    { -280, 576, 424},
    { -536, 1552, 600},
    { -688, 1664, 896},
    { -592, 1480, 304},
    { -424, 1096, -24},
    { -352, 808, -200},
    { -616, 280, 48},
    { -680, 104, 96},
    { -768, 632, -32},
    { -712, 528, 104},
    { -784, 264, 176},
    { -904, 472, 16},
    { -920, 512, -32},
    { -864, 416, 88},
    { -1192, 576, 24},
    { -1392, 672, 136},
    { -1440, 800, 0},
    { -1168, 632, 48},
    { -1192, 592, 48},
    { -1240, 568, -8},
    { -1320, 592, -8},
    // 35 seconds
    { -1192, 424, 384},
    { -1064, 168, 504},
    { -632, -256, 416},
    { -448, -16, 328},
    { -488, -16, 352},
    { -576, 56, 104},
    { -1120, 608, -616},
    { -968, 840, -120},
    { -824, 696, 248},
    { -1000, 488, 224},
    { -1200, 592, -8},
    { -1104, 688, -56},
    { -1064, 688, -184},
    { -928, 248, -104},
    { -912, 104, -64},
    { -1128, 424, -128},
    { -808, 392, -224},
    { -696, 552, -448},
    { -512, 360, -504},
    { -440, 472, -624},
    { -336, 192, -584},
    { -456, -160, -712},
    { -664, -336, -448},
    { -1184, 944, -568},
    { -1192, 968, -408},
    // 36 seconds
    { -800, 400, -120},
    { -704, 640, -376},
    { -536, 392, -568},
    { -800, 400, -592},
    { -1056, 24, -720},
    { -1096, 64, -808},
    { -864, -88, -712},
    { -808, -32, -440},
    { -1376, 360, 1304},
    { -992, 280, 128},
    { -1016, -32, -112},
    { -992, -128, 24},
    { -1208, 48, -24},
    { -1488, 120, 16},
    { -1200, 720, 64},
    { -1200, 632, 56},
    { -1040, 448, 96},
    { -624, 512, -40},
    { -640, 744, 16},
    { -600, 608, 144},
    { -368, 520, 256},
    { -328, 528, 296},
    { -320, 792, 448},
    { -304, 808, 64},
    { -208, 648, 216},
    // 37 seconds
    { -232, 408, 144},
    { -144, 424, 200},
    { -272, 1064, 216},
    { -216, 592, 192},
    { -304, 1080, 120},
    { -304, 632, 128},
    { -448, 1072, -144},
    { -440, 1096, -88},
    { -280, 952, 112},
    { -408, 1120, 528},
    { -432, 1184, 368},
    { -312, 848, 304},
    { -224, 952, 392},
    { -240, 1048, 312},
    { -112, 1056, 344},
    { -216, 616, -96},
    { -280, 1360, 8},
    { 80, 720, 512},
    { 64, 320, 256},
    { -312, 640, -256},
    { -56, 752, 16},
    { -104, 952, -32},
    { -216, 1080, -24},
    { -440, 1672, -64},
    { -552, 1128, 120},
    // 38 seconds
    { -232, 688, -16},
    { -512, 848, -104},
    { -528, 704, -88},
    { -496, 592, -56},
    { -456, 576, -32},
    { -216, 920, 0},
    { -88, 736, 192},
    { 24, 680, 144},
    { 104, 632, 120},
    { 88, 856, 160},
    { 32, 1192, 72},
    { -160, 1048, 776},
    { -8, 1176, 480},
    { -104, 1104, 512},
    { -216, 1144, 576},
    { -240, 1088, 536},
    { -200, 992, 480},
    { -160, 680, 544},
    { -96, 760, 576},
    { -224, 840, 656},
    { -128, 704, 488},
    { -168, 528, 520},
    { -32, 536, 352},
    { -8, 488, 344},
    { 40, 512, 344},
    // 39 seconds
    { 80, 456, 352},
    { 88, 512, 408},
    { 8, 752, 560},
    { 16, 1104, 688},
    { 88, 1192, 984},
    { 136, 1464, 808},
    { 88, 1064, 584},
    { 56, 808, 512},
    { -80, 744, 536},
    { -72, 696, 496},
    { -32, 560, 464},
    { 72, 528, 384},
    { 152, 464, 344},
    { 256, 400, 248},
    { 272, 320, 344},
    { 288, 560, 392},
    { 248, 720, 640},
    { 208, 888, 880},
    { 184, 1008, 1128},
    { 184, 1120, 1016},
    { 200, 872, 736},
    { 184, 696, 648},
    { 208, 528, 640},
    { 176, 736, 712},
    { 104, 624, 664},
    // 40 seconds
    { 96, 544, 584},
    { 128, 504, 456},
    { 152, 392, 376},
    { 168, 360, 280},
    { 184, 304, 264},
    { 184, 208, 368},
    { 104, 448, -96},
    { -120, 1120, 896},
    { -24, 1440, 1120},
    { 128, 1352, 1072},
    { 264, 1240, 768},
    { 144, 1048, 472},
    { 40, 784, 312},
    { 0, 704, 392},
    { -16, 656, 360},
    { 0, 512, 312},
    { 56, 336, 224},
    { 104, 320, 232},
    { 184, 368, 216},
    { 208, 416, 264},
    { 240, 592, 224},
    { 224, 704, 504},
    { 160, 1088, 688},
    { 200, 1312, 848},
    { 168, 1344, 1040},
    // 41 seconds
    { 160, 1232, 872},
    { 208, 840, 512},
    { 232, 592, 568},
    { 184, 656, 616},
    { 56, 824, 776},
    { -16, 744, 664},
    { 8, 616, 440},
    { 8, 512, 320},
    { 8, 472, 216},
    { 16, 368, 152},
    { -56, 488, 296},
    { -72, 768, 368},
    { -104, 1016, 376},
    { -80, 1168, 400},
    { 16, 1288, 640},
    { 184, 1440, 528},
    { 120, 1384, 160},
    { 48, 976, 200},
    { -32, 760, 328},
    { -104, 632, 344},
    { -96, 608, 272},
    { -56, 552, 240},
    { -8, 472, 264},
    { 64, 472, 280},
    { 128, 528, 304},
    // 42 seconds
    { 144, 720, 448},
    { 144, 1016, 568},
    { 88, 1368, 832},
    { -40, 1624, 976},
    { 0, 1488, 656},
    { 40, 1088, 440},
    { -16, 856, 536},
    { -96, 840, 520},
    { -176, 832, 488},
    { -176, 680, 368},
    { -120, 512, 208},
    { -104, 456, 152},
    { -112, 448, 160},
    { -120, 432, 32},
    { -200, 568, 64},
    { -288, 800, 0},
    { -320, 968, 88},
    { -408, 1528, 240},
    { -320, 1528, 448},
    { -96, 1472, 112},
    { -112, 1064, 288},
    { -56, 840, 248},
    { -64, 792, 48},
    { -80, 696, 96},
    { -40, 528, 152},
    // 43 seconds
    { 16, 504, 144},
    { 40, 568, 184},
    { 64, 720, 184},
    { 72, 776, 424},
    { -40, 1136, 624},
    { -176, 1368, 792},
    { -416, 1472, 936},
    { -344, 1216, 800},
    { -232, 840, 640},
    { -224, 656, 688},
    { -264, 656, 728},
    { -312, 632, 744},
    { -264, 608, 576},
    { -184, 440, 464},
    { -160, 376, 360},
    { -136, 352, 264},
    { -200, 408, 376},
    { -264, 520, 360},
    { -416, 776, 432},
    { -416, 1000, 624},
    { -432, 1400, 792},
    { -168, 1376, 632},
    { -88, 1208, 464},
    { -80, 952, 392},
    { -168, 912, 576},
    // 44 seconds
    { -104, 712, 448},
    { 0, 592, 432},
    { 128, 480, 368},
    { 176, 464, 400},
    { 232, 528, 384},
    { 288, 632, 472},
    { 296, 816, 632},
    { 232, 1160, 808},
    { 40, 1360, 856},
    { -8, 1168, 704},
    { 72, 808, 448},
    { 32, 760, 568},
    { 16, 856, 520},
    { -24, 760, 520},
    { -40, 632, 304},
    { 64, 496, 216},
    { 104, 496, 224},
    { 256, 480, 200},
    { 216, 568, 304},
    { 272, 552, 400},
    { 408, 784, 376},
    { 384, 1032, 440},
    { 448, 1304, 488},
    { 184, 1480, 520},
    { 136, 1112, 312},
    // 45 seconds
    { 56, 832, 208},
    { 32, 696, 336},
    { 72, 624, 360},
    { 144, 472, 352},
    { 216, 416, 344},
    { 248, 424, 320},
    { 312, 432, 312},
    { 408, 528, 376},
    { 408, 696, 408},
    { 360, 1128, 688},
    { 328, 1216, 776},
    { 336, 1320, 752},
    { 280, 1192, 656},
    { 224, 912, 424},
    { 232, 696, 448},
    { 256, 736, 448},
    { 200, 792, 504},
    { 120, 744, 472},
    { 120, 608, 360},
    { 144, 488, 264},
    { 168, 392, 272},
    { 240, 296, 264},
    { 168, 768, 392},
    { 320, 568, 528},
    { 224, 1064, 608},
    // 46 seconds
    { 424, 1152, 688},
    { 296, 1528, 552},
    { 248, 1160, 400},
    { 264, 824, 176},
    { 208, 664, 280},
    { 160, 640, 312},
    { 152, 608, 312},
    { 184, 552, 264},
    { 208, 544, 248},
    { 272, 568, 216},
    { 272, 680, 216},
    { 312, 712, 216},
    { 296, 784, 288},
    { 272, 928, 232},
    { 248, 856, 344},
    { 248, 944, 448},
    { 288, 1136, 664},
    { 272, 1272, 704},
    { 232, 960, 528},
    { 248, 688, 400},
    { 272, 672, 464},
    { 208, 632, 496},
    { 152, 680, 320},
    { 176, 616, 232},
    { 224, 560, 280},
    // 47 seconds
    { 248, 560, 336},
    { 256, 656, 280},
    { 272, 664, 344},
    { 328, 736, 464},
    { 256, 960, 424},
    { 304, 1184, 584},
    { 280, 1272, 680},
    { 224, 1240, 536},
    { 168, 1016, 408},
    { 136, 856, 328},
    { 72, 712, 368},
    { 80, 664, 360},
    { 104, 520, 256},
    { 136, 424, 176},
    { 184, 408, 192},
    { 264, 464, 200},
    { 264, 560, 264},
    { 320, 776, 392},
    { 272, 1056, 488},
    { 328, 1112, 584},
    { 264, 1432, 592},
    { 152, 1136, 672},
    { 168, 888, 424},
    { 216, 640, 408},
    { 216, 736, 496},
    // 48 seconds
    { 104, 936, 640},
    { 8, 736, 488},
    { 56, 608, 304},
    { 104, 488, 280},
    { 128, 504, 296},
    { 160, 584, 264},
    { 168, 656, 280},
    { 232, 744, 400},
    { 248, 936, 480},
    { 320, 1120, 576},
    { 248, 1272, 640},
    { 240, 1256, 480},
    { 152, 1048, 408},
    { 56, 864, 312},
    { 0, 744, 368},
    { 16, 664, 344},
    { 96, 632, 280},
    { 184, 528, 224},
    { 256, 536, 272},
    { 320, 536, 224},
    { 352, 592, 240},
    { 352, 672, 288},
    { 328, 864, 368},
    { 240, 1032, 488},
    { 312, 1080, 504},
    // 49 seconds
    { 256, 1088, 552},
    { 256, 1024, 456},
    { 224, 872, 384},
    { 224, 744, 432},
    { 192, 856, 480},
    { 72, 896, 568},
    { 64, 752, 376},
    { 136, 640, 248},
    { 160, 592, 264},
    { 192, 608, 264},
    { 216, 672, 224},
    { 240, 656, 280},
    { 264, 744, 312},
    { 224, 824, 352},
    { 248, 976, 400},
    { 200, 1120, 496},
    { 168, 1280, 552},
    { 0, 1280, 352},
    { -72, 976, 288},
    { -120, 848, 208},
    { -104, 808, 264},
    { -40, 816, 312},
    { 0, 800, 336},
    { 56, 704, 344},
    { 128, 680, 296},
    // 50 seconds
    { 200, 640, 272},
    { 264, 680, 240},
    { 304, 736, 232},
    { 304, 776, 264},
    { 272, 840, 304},
    { 272, 744, 304},
    { 456, 872, 376},
    { 360, 936, 504},
    { 224, 960, 496},
    { 200, 1008, 544},
    { 96, 1024, 600},
    { 0, 912, 456},
    { 56, 800, 328},
    { 80, 744, 368},
    { 128, 704, 416},
    { 176, 768, 440},
    { 280, 728, 480},
    { 368, 640, 320},
    { 408, 512, 384},
    { 472, 488, 416},
    { 416, 528, 392},
    { 384, 592, 400},
    { 416, 608, 480},
    { 408, 728, 544},
    { 304, 952, 624},
    // 51 seconds
    { 256, 1072, 552},
    { 224, 1000, 456},
    { 160, 944, 488},
    { 152, 904, 504},
    { 152, 776, 440},
    { 184, 600, 312},
    { 248, 488, 328},
    { 280, 400, 400},
    { 328, 576, 392},
    { 336, 576, 432},
    { 368, 584, 544},
    { 376, 688, 512},
    { 384, 736, 568},
    { 440, 872, 672},
    { 432, 1056, 856},
    { 288, 1144, 920},
    { 104, 992, 768},
    { 168, 712, 648},
    { 136, 552, 592},
    { 96, 640, 664},
    { 72, 592, 608},
    { 104, 520, 464},
    { 184, 448, 392},
    { 224, 432, 368},
    { 240, 456, 336},
    // 52 seconds
    { 280, 376, 176},
    { 328, 456, 32},
    { 120, 776, 528},
    { 136, 912, 552},
    { -48, 1632, 840},
    { 104, 1336, 1064},
    { 200, 1240, 752},
    { 168, 896, 432},
    { 24, 840, 368},
    { -24, 640, 432},
    { -8, 592, 368},
    { 16, 480, 328},
    { 96, 448, 264},
    { 216, 408, 280},
    { 280, 488, 224},
    { 296, 512, 200},
    { 304, 528, 240},
    { 312, 784, 424},
    { 248, 1072, 680},
    { 304, 1200, 816},
    { 280, 1192, 832},
    { 256, 984, 632},
    { 248, 824, 592},
    { 200, 784, 672},
    { 96, 968, 712},
    // 53 seconds
    { -8, 840, 632},
    { 56, 656, 352},
    { 112, 488, 200},
    { 152, 376, 240},
    { 176, 448, 112},
    { 128, 544, 240},
    { 112, 712, 432},
    { 104, 832, 520},
    { 96, 896, 512},
    { 48, 1096, 552},
    { 152, 1272, 520},
    { 128, 1344, 320},
    { 40, 1216, 256},
    { -8, 960, 296},
    { -64, 744, 296},
    { -48, 560, 248},
    { 8, 408, 232},
    { 56, 320, 232},
    { 80, 304, 272},
    { 112, 368, 352},
    { 104, 624, 488},
    { 88, 888, 704},
    { -32, 1224, 872},
    { -48, 1648, 896},
    { -144, 1448, 760},
    // 54 seconds
    { 24, 1048, 440},
    { 56, 864, 464},
    { 0, 848, 528},
    { -80, 864, 496},
    { -80, 728, 384},
    { -64, 568, 272},
    { -48, 504, 232},
    { -56, 464, 224},
    { -64, 528, 200},
    { -88, 608, 312},
    { -112, 824, 392},
    { -72, 928, 528},
    { 0, 1192, 672},
    { 96, 1456, 536},
    { 160, 1368, 376},
    { 72, 1080, 264},
    { 8, 880, 360},
    { -48, 848, 288},
    { -104, 616, 160},
    { -16, 368, 192},
    { 72, 328, 88},
    { 120, 480, 88},
    { 152, 584, 152},
    { 200, 824, 264},
    { 192, 1096, 488},
    // 55 seconds
    { 184, 1440, 560},
    { 40, 1520, 592},
    { 56, 1120, 352},
    { 64, 952, 296},
    { 24, 880, 424},
    { -72, 1056, 480},
    { -168, 872, 352},
    { -64, 672, 184},
    { -24, 480, 136},
    { -8, 456, 136},
    { -24, 504, 128},
    { -24, 512, 224},
    { -56, 736, 344},
    { -88, 936, 432},
    { -72, 1224, 472},
    { -88, 1464, 560},
    { -16, 1248, 360},
    { 0, 1160, 224},
    { -56, 1000, 200},
    { -96, 856, 264},
    { -96, 696, 232},
    { -48, 584, 184},
    { 0, 496, 192},
    { 48, 504, 184},
    { 64, 600, 184},
    // 56 seconds
    { 96, 656, 248},
    { 112, 1064, 288},
    { 16, 1208, 456},
    { 24, 1416, 384},
    { -56, 1456, 336},
    { -16, 1144, 256},
    { 0, 952, 104},
    { 8, 928, 208},
    { -56, 1088, 248},
    { -144, 1048, 200},
    { -88, 744, 104},
    { -40, 528, 48},
    { -32, 472, 24},
    { -48, 440, 56},
    { -64, 488, 56},
    { -88, 688, 88},
    { -144, 936, 136},
    { -144, 1200, 232},
    { -56, 1432, 280},
    { 72, 1616, 208},
    { 24, 1472, -104},
    { -32, 1184, 32},
    { 16, 768, 200},
    { -16, 680, 104},
    { -32, 648, 104},
    // 57 seconds
    { 8, 472, 160},
    { 24, 488, 160},
    { 72, 440, 184},
    { 104, 512, 136},
    { 104, 672, 312},
    { 128, 784, 424},
    { 24, 1128, 600},
    { 16, 1224, 880},
    { -48, 1328, 856},
    { -16, 1080, 760},
    { 40, 888, 616},
    { 8, 776, 528},
    { -88, 848, 648},
    { -152, 816, 512},
    { -128, 680, 432},
    { -152, 656, 488},
    { -176, 720, 464},
    { -160, 688, 480},
    { -152, 704, 480},
    { -176, 728, 544},
    { -88, 720, 536},
    { 56, 656, 352},
    { 168, 560, 584},
    { 136, 808, 272},
    { 144, 872, 424},
    // 58 seconds
    { 176, 720, 376},
    { 144, 720, 360},
    { -32, 688, 408},
    { -64, 632, 376},
    { -216, 664, 320},
    { -264, 768, 168},
    { -336, 648, 320},
    { -448, 848, 80},
    { -520, 744, 176},
    { -720, 912, -184},
    { -824, 792, -152},
    { -808, 552, -280},
    { -936, 488, -320},
    { -904, 424, -368},
    { -912, 256, -312},
    { -960, 336, -360},
    { -976, 208, -376},
    { -1104, 368, -360},
    { -1072, 336, -480},
    { -1160, 480, -280},
    { -1048, 168, -584},
    { -1240, 168, -496},
    { -1384, 280, -392},
    { -1256, 256, -320},
    { -1160, 344, -320},
    // 59 seconds
    { -976, 632, -392},
    { -816, 704, -232},
    { -608, 408, -40},
    { -336, 248, 304},
    { -952, 728, 1032},
    { -8, 696, 680},
    { -128, 544, 568},
    { -168, 512, 360},
    { -104, 216, 736},
    { -376, 448, 584},
    { -408, 520, 744},
    { -552, 368, 536},
    { -624, 56, 824},
    { -416, 80, 960},
    { -368, -104, 1136},
    { -296, 32, 1096},
    { -184, -304, 1008},
    { -336, -232, 1096},
    { -272, -184, 952},
    { -360, -456, 984},
    { -376, -256, 1080},
    { -424, -168, 1040},
    { -272, -368, 1000},
    { -320, -224, 976},
    { -272, -120, 984},
    // 60 seconds
    // elapsed: 1 minutes
    { -288, -144, 1048},
    { -392, -80, 1000},
    { -384, -16, 984},
    { -344, -40, 936},
    { -296, -32, 976},
    { -216, 8, 976},
    { -280, 80, 952},
    { -336, 120, 944},
    { -424, 112, 904},
    { -456, 144, 896},
    { -416, 104, 920},
    { -384, 104, 904},
    { -384, 160, 920},
    { -376, 192, 952},
    { -336, 192, 960},
    { -304, 224, 936},
    { -328, 248, 960},
    { -408, 248, 904},
    { -456, 304, 920},
    { -440, 248, 920},
    { -424, 304, 896},
    { -360, 304, 920},
    { -296, 280, 904},
    { -248, 344, 896},
    { -248, 288, 936},
    // 61 seconds
    { -424, 512, 904},
    { -640, 408, 920},
    { -640, 560, 736},
    { -688, 608, 712},
    { -656, 424, 728},
    { -664, 296, 824},
    { -720, 296, 976},
    { -680, 144, 1008},
    { -744, 128, 960},
    { -664, 144, 888},
    { -640, -120, 736},
    { -568, 120, 760},
    { -608, -40, 872},
    { -560, 40, 1104},
    { -384, 232, 1152},
    { -248, 208, 1016},
    { -136, 560, 912},
    { -56, 616, 728},
    { -224, 536, 672},
    { -488, 536, 720},
    { -568, 608, 720},
    { -504, 360, 648},
    { -424, 504, 760},
    { -592, 328, 840},
    { -408, 640, 792},
    // 62 seconds
    { -152, 256, 680},
    { -296, 304, 880},
    { -256, 496, 936},
    { -72, 336, 840},
    { -64, 288, 952},
    { -144, 80, 1032},
    { -352, 488, 1064},
    { -424, 1288, 496},
    { -152, 840, 696},
    { -672, 840, 320},
    { -384, 1064, -64},
    { -512, 744, -112},
    { -184, 1448, -512},
    { -40, 288, -752},
    { 40, 880, -512},
    { -96, 288, -40},
    { -136, 720, -224},
    { -320, 1096, -8},
    { -216, 472, 168},
    { -416, 1680, 392},
    { 128, 1144, 200},
    { -56, 1024, 200},
    { 56, 1248, 304},
    { -184, 808, 224},
    { -216, 712, 112},
    // 63 seconds
    { -288, 592, 104},
    { -368, 640, -176},
    { -184, 672, -224},
    { -80, 664, -80},
    { 32, 976, 176},
    { -120, 904, 608},
    { 40, 616, 848},
    { -168, 432, 528},
    { -216, 464, 712},
    { -240, 656, 944},
    { -400, 1032, 784},
    { -184, 624, 1192},
    { -136, 704, 1048},
    { -168, 672, 800},
    { -152, 496, 664},
    { -216, 192, 520},
    { -232, 416, 464},
    { -224, 664, 488},
    { -200, 552, 536},
    { -104, 640, 496},
    { -80, 808, 528},
    { 16, 1008, 496},
    { 8, 824, 904},
    { -48, 1056, 512},
    { -144, 760, 632},
    // 64 seconds
    { -136, 752, 560},
    { -176, 680, 584},
    { -160, 688, 536},
    { -168, 688, 552},
    { -104, 712, 512},
    { -120, 808, 448},
    { -168, 760, 448},
    { -256, 664, 480},
    { -376, 752, 512},
    { -264, 616, 816},
    { -184, 864, 760},
    { -96, 672, 576},
    { -224, 848, 600},
    { -176, 872, 448},
    { -264, 592, 560},
    { -392, 696, 416},
    { -352, 712, 552},
    { -208, 768, 712},
    { -80, 792, 512},
    { -136, 728, 448},
    { -224, 568, 304},
    { -272, 928, 272},
    { -56, 688, 592},
    { -368, 1016, 208},
    { -528, 784, 224},
    // 65 seconds
    { -464, 784, 168},
    { -376, 864, 104},
    { -512, 896, 216},
    { -360, 1024, 232},
    { -240, 968, 128},
    { -128, 944, 88},
    { -176, 840, 40},
    { -352, 840, 88},
    { -472, 712, 104},
    { -504, 896, -8},
    { -520, 632, 80},
    { -464, 632, 136},
    { -464, 672, 224},
    { -448, 832, 144},
    { -424, 1080, -168},
    { -376, 936, -248},
    { -528, 928, -112},
    { -400, 760, 64},
    { -400, 856, 16},
    { -432, 808, 72},
    { -520, 800, 56},
    { -592, 848, -72},
    { -592, 752, -144},
    { -576, 672, -144},
    { -544, 672, -240},
    // 66 seconds
    { -544, 680, -104},
    { -504, 760, -72},
    { -488, 856, 40},
    { -408, 768, 152},
    { -424, 800, 120},
    { -408, 776, 224},
    { -424, 864, 168},
    { -504, 744, 256},
    { -640, 840, 176},
    { -656, 848, 192},
    { -712, 760, 248},
    { -656, 784, 176},
    { -720, 752, 144},
    { -776, 704, 168},
    { -728, 696, 88},
    { -704, 656, 64},
    { -728, 656, 72},
    { -720, 640, 24},
    { -712, 672, -64},
    { -744, 584, 8},
    { -704, 624, 24},
    { -672, 656, 16},
    { -672, 680, 72},
    { -632, 712, 120},
    { -600, 744, 152},
    // 67 seconds
    { -616, 808, 168},
    { -632, 800, 184},
    { -632, 760, 192},
    { -600, 752, 192},
    { -600, 752, 152},
    { -608, 720, 168},
    { -656, 696, 176},
    { -656, 736, 160},
    { -712, 680, 168},
    { -736, 664, 160},
    { -768, 640, 144},
    { -664, 584, 136},
    { -592, 648, 120},
    { -760, 744, 152},
    { -736, 656, 192},
    { -752, 656, 152},
    { -720, 616, 168},
    { -736, 568, 168},
    { -736, 568, 176},
    { -728, 568, 216},
    { -704, 704, 184},
    { -688, 704, 192},
    { -672, 712, 192},
    { -688, 728, 200},
    { -656, 680, 168},
    // 68 seconds
    { -632, 632, 168},
    { -632, 704, 160},
    { -664, 680, 200},
    { -648, 688, 176},
    { -656, 696, 184},
    { -640, 680, 184},
    { -632, 688, 176},
    { -616, 688, 240},
    { -536, 752, 288},
    { -496, 824, 336},
    { -528, 864, 424},
    { -536, 840, 360},
    { -496, 744, 408},
    { -488, 616, 360},
    { -504, 528, 376},
    { -544, 616, 392},
    { -672, 616, 560},
    { -680, 712, 456},
    { -680, 480, 600},
    { -688, 520, 688},
    { -504, 520, 520},
    { -832, 736, 736},
    { -616, 552, 472},
    { -624, 632, 600},
    { -456, 744, 624},
    // 69 seconds
    { -352, 632, 656},
    { -224, 712, 552},
    { -256, 632, 624},
    { -272, 712, 616},
    { -264, 800, 568},
    { -248, 792, 536},
    { -240, 800, 464},
    { -192, 768, 456},
    { -184, 752, 424},
    { -136, 744, 456},
    { -128, 792, 528},
    { -104, 800, 512},
    { -104, 808, 592},
    { -96, 792, 568},
    { -56, 792, 616},
    { -24, 840, 632},
    { 48, 752, 624},
    { 80, 688, 584},
    { 112, 648, 600},
    { 184, 632, 520},
    { 232, 616, 536},
    { 272, 560, 528},
    { 272, 592, 472},
    { 288, 584, 472},
    { 296, 424, 448},
    // 70 seconds
    { 248, 376, 736},
    { 176, 664, 528},
    { 168, 816, 584},
    { 224, 680, 608},
    { 176, 680, 512},
    { 112, 840, 520},
    { 144, 736, 536},
    { 152, 968, 488},
    { 248, 1032, 392},
    { 280, 824, 568},
    { 352, 824, 600},
    { 216, 728, 544},
    { 264, 696, 504},
    { 264, 1216, -72},
    { 216, 1024, 368},
    { 336, 1272, -192},
    { 288, 752, -96},
    { 248, 512, -448},
    { 168, 472, -752},
    { 152, 344, -696},
    { -112, 216, -816},
    { -104, 216, -976},
    { -136, 72, -912},
    { -160, -8, -856},
    { -56, 72, -936},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

